﻿USE sofia;
DROP TABLE IF EXISTS sofia.mlp_vpl;
CREATE TABLE mlp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mlp_vpl WRITE;
INSERT INTO mlp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ari ka Yesus Krais asesan diqmo ginan. Yesus in Devit asenlulibta. Teq Devit in Abraham asenlulibta. ");
INSERT INTO mlp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ari Abraham in Aisak amam. Sa Aisak in Jekob amam. Sa Jekob in Juda amaqbaban nenaq gimam. ");
INSERT INTO mlp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Sa Juda in Peres ama Sera inaq gimam. Giger na ginen anan Tamar. Sa Peres in Hesron amam. Sa Hesron in Ram amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Sa Ram in Aminadab amam. Sa Aminadab in Nason amam. Sa Nason in Salmon amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sa Salmon in Bowaz amam. Teq Bowaz anen Rahab. Sa Bowaz in Obet amam. Teq Obet anen Rut. Sa Obet in Jesi amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Sa Jesi in Isrel gigo king Devit amam. Teq Devit in Solomon amam. Solomon anen in kwaziqmo mat anan Uriya haqayta na awe iyim osta. ");
INSERT INTO mlp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sa Solomon in Rehobowam amam. Sa Rehobowam in Abiya amam. Sa Abiya in Asa amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sa Asa in Jehosafat amam. Sa Jehosafat in Jehoram amam. Sa Jehoram in Usiya amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Sa Usiya in Jotam amam. Sa Jotam in Ahaz amam. Sa Ahaz in Hesekiya amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Sa Hesekiya in Manase amam. Sa Manase in Emon amam. Sa Emon in Josaya amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sa Josaya in Jekonaya amaqbaban nenaq gimam. An Jekonaya amaqbaban nenaq gigo kamub Babiloniya mataw bolim Isrel nenaq bab emim in Isrel on mataw giwazim giqad lehim in gigo ogib giqeman in begbeg iyim osiyta. ");
INSERT INTO mlp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ari in Isrel giqad Babiloniya-ib lehiyta nab Yesus asesan asor gwahtiqiyta na ginan kazaq: Jekonaya in Sealtiyel amam. Sa Sealtiyel in Zerubabel amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sa Zerubabel in Abiyut amam. Sa Abiyut in Eliyakim amam. Sa Eliyakim in Azor amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sa Azor in Zadok amam. Sa Zadok in Akim amam. Sa Akim in Eliyut amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Sa Eliyut in Eleasar amam. Sa Eleasar in Matan amam. Sa Matan in Jekob amam. ");
INSERT INTO mlp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Sa Jekob in Josep amam. An Josep in Mariya aduw iyan Mariya in Yesus am, on mataw anan Krais ");
INSERT INTO mlp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nazaq iyan Abraham asenlulib iyim bolim Devit-ib iyta nab Yesus asesan in 14 nazaq iyiy. Ad Devit asenlulib iyim bolim Isrel on mataw Babiloniya-ib begbeg iyim osiyta nab in asesan 14 nazaq iyiy. Ad Isrel on mataw Babiloniya-ib begbeg iyim osim bolim Krais gwahtimta nab in asesan 14 nazaq iyiymo. ");
INSERT INTO mlp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ari Yesus Krais anen amta awagamun kazaq. Mariya anan bilaqiy, In teq Josep waqdaq haqiy. Haqan teq Mariya ayow Josep inaq an a hi waqsamo God ago Bugaw Dimunta Mariya aholib bolan in agem tiqiy. ");
INSERT INTO mlp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Agem iysa aduw Josep nazaq in ago aw ahol waqad anad emyaq, Ya Mariya tuhulosdaiq haqyaq. Haqad teq in mat dimunta iyim in awe mebay ugnan anad a hi bilaqyaq. In anad emyaq, Ya nan kabemmo a hi bilaqad kiskismo tuhulosdaiq haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Haqad in anad nazaq emad luwad kam araqab in ussa ago sen qway aduganib Iyahta ago angelo araq in ameb tugwahtim. Gwahtiqim in bulon, Devit ases Josep ham. Ni ningo aw Mariya waqgo hi rab ham. Ni hurit ham. Amun nawa ningo aw agemab usaqta na God ago Bugaw Dimunta inmo ugta ham. ");
INSERT INTO mlp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ugan ningo aw na amun matta araq tiqemdaq ham. Emid ni anan Yesus biydaq ham. Na ezaqgo in teq ago on mataw gigo daq meqinta giwalemad gimen dante wastitayid in God agerab tileh daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Nazaq iyan daq na in Iyahta ago gamuk araq in kwaziqmo ago nantut aqezab eman gwahtimta na tuwolnet bug. Gamuk na kazaq bilam, Ne huritiy ham. Aw araq mat inaq asit a hi usta na agem iyeq amun matta araq tiqemdaq haqad in bilam ham. Emid teq mataw amun na anan biyeq Emanuwel tihaq daqay haqad in bilam ham. Teq gamuk Emanuwel na alulin in kazaq: “God i ginaq osauqta” haqayta. ");
INSERT INTO mlp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ari Josep usim ago sen qway na tihiqiyan in tiqeram. Eraqim Iyahta ago angelo bulonta nazaqmo in emim awe Mariya tuwam. ");
INSERT INTO mlp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Waqim teq in asit inaq a hi ussa le awe amun matta na tiqam. Eman Josep in amun anan Yesus haqad tibiy. ");
INSERT INTO mlp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Ari Herot saw Judiya-ib king iyim ossa Mariya in saw nabmo uliq Betlehem-ub Yesus tiqam. Eman teq zeq gwalaqta ban kantri araq ago mataw aseseqta ginad awaz meqinta asor uliq Jerusalem-ub bolim mataw haresmo susumun negeq bilaq yaqay, Amun muturta Juda gigo king na edob diq osaq? haq yaqay. I in ago ulig saw zeq gwalaqta ban ahol waqim i nagunim bol haq yaqay. I amun na ahol waqeq teq i amen lotu emam haqad i bol haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Haqsa Herot gamuk na huritim ritan. Sa Jerusalem-ub on mataw bunmo riteniymo. ");
INSERT INTO mlp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","An Herot in Isrel gigo mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na bunmo gihumab wolim tisusumun nag, Mat ne anan Krais haqayta na uliq edob diq gwahtiqdaqta? ham. ");
INSERT INTO mlp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Haqan mataw aseseqta na buloniy, Saw Judiya-ib uliq anan Betlehem haqayta nab in gwahtiqdaqta haqiy. God ago nantut gamuk nazaq mar tonan usaqta haqiy. Gamuk na bilam, Uliq Betlehem saw Judiya-ibta ham ni saw Judiya-ib uliq gibin inaqta na gihaqenibta a haiq ham haqiy. Na ezaqgo ne gilikmanib teq maror araq ayahta tugwahtiqdaq ham haqiy. Gwahtiqeq teq in yaqgo on mataw Isrel tigiwamuzdaq haqad in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Haqan Herot gamuk na huritim in ulilemimmo nan eman saw zeq gwalaqta ban mataw ginad awaz meqinta na gigo hib tilah, in boleq Herot ahol waq daqay haqad. An mataw na bolan in tisusumun nag, Kam gineh diq ulig na gwahtim? ham. ");
INSERT INTO mlp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Haqan mataw aseseqta na tubuloniy. Bulonan Herot giqeman Betlehem-ub lehsa in gibilan, Ne leheq amun na nagun naqmo diq hiqiyiy ham. Naguneq ne ahol waqeq teq boleq ya ibileniy ham. Ibilenid ta ya leheq in ayon lotu tiqemdaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","In nazaq gibilenan huritadmo in tilehiy. Lehad ulig teko zeq gwalaqta ban ahol waqiyta na in ahol a ta waqiy. Ahol waqsa ulig na ameb lehim bit amun usaqta nabmo titur. ");
INSERT INTO mlp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tursa in ulig na ahol waqad in ginad tidimniy naqmo diq hiqiy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ginad dimniysa in le bit aduganib gwahtiqim amun anen Mariya inaq ossa tigibiyiy. Gibiyad in gibakbakan ulum laquwim ginobun mulbunim ogib woqsa in amun amen lotu emad abin tiqiluwiy. Ad teq in amun ayon naw a boliyta na hasim tuqugiy. Naw na gol teq masil dimunta teq nal ahuran dimun diqta na tuqugiy. ");
INSERT INTO mlp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ugadmo in nab tuqusiy. Ussa in gigo sen qway aduganib God kazaq gibilan, Ne muleqeq Herot ago hib ta hi lehiy ham. Haqan in usim eraqim dan ta araq muzim giquliqab muleqim tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ari mataw aseseqta kantri araqabta na muleqim gigo uliqab ta lehsa Josep a ta usim sen qwaysa Iyahta ago angelo tubulon, Ni eraq ham. Herot teq ningo amun na wol emnan tinagundaq ham. Ni amun anen inaq giwaqeq giqad kantri Isip-ubmo tukeq woleh ham. Ni nab leheq ossa ya a ta nibilenid teq ni giqad ta boldaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Haqan tarom nabmo Josep eraqim amun na anen inaq giwaqim giqad Isip-ub tuwolehiy. ");
INSERT INTO mlp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wolehim ossa Herot tumoqan teq in ta muleqiy. Nazaq iyan daq na in Iyahta ago gamuk in kwaziqmo eman ago nantut aqezab gwahtimta na tuwolnet bug. Gamuk na bilam, Ya itatin lilewunid in Isip huloseq gwahtiqdaq haqad in bilam. ");
INSERT INTO mlp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ari zeq gwalaqta ban mataw ginad awaz meqinta na in Herot ame titonim dan ta araq waqim in gigo uliqab ta lehiyta na ago Herot tuhurit. Huritim in agem meqin diq iysa in ago bab mataw asor giqeman Betlehem-ub lehim in uliq sinsin nagab onmin matmatta ginen muturmo giqemiyta gigo ulig gigermo a hi iyayta nagan tiginol em bugiy. Na ezaqgo Herot in mataw marorta na susumun negim kam gineh diq ulig gwahtiqan in ahol waqiyta na ago in huritta iyan in onmin nazaqta ginol am. ");
INSERT INTO mlp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nazaq iyan daq na in kwaziqmo God ago nantut Jeremaya gamuk bilamta na tuwol net bug. In kazaq bilam, ");
INSERT INTO mlp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Uliq Rama-ib aw araq gaq wazad ek tonaq ham. Na Jekob awe Resel in ago onmin ginan gaq wazaq ham. Gaq wazsa on mataw anad waqsa in hulosaq ham. Na ezaqgo in ago onmin na tumoqiyta na ago ham. ");
INSERT INTO mlp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Ari Josep Isip-ub ossa Herot tumom. Moqan teq Josep usim sen ta qwayan Iyahta ago angelo na gwahtiqim tubulon, Ni eraq ham. Mataw ningo amun wol emnan bilaqiyta na tumoq bugiy ham. Ningo aw amun giwaqeq giqad Isrel-ib ta gwaleh ham. ");
INSERT INTO mlp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Haqan in eraqim amun anen inaq giwaqim nenaq Isrel-ib tugwalehiy. ");
INSERT INTO mlp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gwalehim Herot atatin Arkelaus amamgo ban waqim saw Judiya-ib on mataw gigo king iyim osaqta na ago Josep tuhurit. Huritim in saw Judiya-ib lehnan rab. Ad in usim sen ta qwayim gamuk araq kazaq hurit, Ni saw Judiya-ib hi leh ham. Haqan Josep eraqim saw ta araq anan Galiliy haqayta nab ago aw amun nenaq tilah. ");
INSERT INTO mlp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Lehim in uliq anan Nasaret haqayta nab tuqosiy. Nazaq iyan daq na in God ago gamuk araq nantut bilaqiyta na tuwol net bug. Gamuk na bilam, In anan mat uliq Nasaret-ibta haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ari Yesus uliq Nasaret-ib osim ayah tiqiy bugan kam nagab Jon mataw huz negyaqta na tugwahtim. Gwahtiqim in saw Judiya-ib og araq amatawun haiqtab osad teq in on mataw God ago gamuk tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","In bilaqyaq, God ago maror bolim sinsin tiqiy haqyaq. Nazaq iyan ne ginad buliyeq gigo daq meqinta gileh ugiy haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ari kwaziqmo God ago nantut Aisaya mat anan bilamta na amatin in Jon-mo. Teq Aisaya bilam, Mat na aqez saw amatawun haiqtab lileyim bilaqaq, Ne Iyahta ayon dan balaw toniy haqaq ham. Ad ne in ayon dante na wastitayid titnonan haqaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Haqan Jon gwahtiqim osad in ago tubusan karuw anan kamel haqayta na asan ulim emiyta. Teq in karuw asan asor am gan nog ahulib am wazeq luwyaqta. Luwad in ago didaq kasum teq garanab kubiq akokin neqyaqta. ");
INSERT INTO mlp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ari Jon in God ago gamuk na bilaqsa uliq Jerusalem-ub teq saw Judiya-ib teq yuw Jodan aqurumnib uliq sinsin usayta nagab on mataw kabemmo Jon ago hib tubol yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bolad in gigo daq teq ginad meqinta ulum hassa Jon giqad le yuw Jodan-ib gihuz negyaq. ");
INSERT INTO mlp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sa Farisi teq Sadyusi kabemmo yuw huznan bolsa Jon tigibiy. Gibiyad in ginadad gibilan, Ne ured amidgotniz ham. God teq ne ginan agem meqniysa gimeqin tondaqta na nog gibilenan ne tukim gigbeb leh nog iyay? ham. ");
INSERT INTO mlp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ne ginad meqniysa gigem buliyid teq ne gigo daq nazaqmo tubuliydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Luweq ne ginad kazaq em daqay ham. I Abraham asenlulibta haq daqay ham. Nazaq iyan God anad dimunta igad a hi gimeqin tondaq haq daqay ham. Nazaq ne ginad hi emiy ham. Ya ne gibilenaiq ham. God gig kag gibilenid buliyeq Abraham asenlulniz iygo azawayin in aholib usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Talgis ay abeqarib tuqusaq ham. Ay bunmo anon dimunta a hi emaqta na in qwayeq faqab hunegid le tuqoydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ne ginad buliyim gigo daq meqinta gileh ugan teq ya ne yuwibmo huz negaiqta ham. Ari mat araq teq ya ibeb boldaqta na abin in ya ibin uriyamta ham. Ya in ahaqenibta ham. In yaqgo Iyahta ham. Ya in ago kabibiy mat samanta ham. In boleq nagah giger God ago Bugaw Dimunta teq faq inaq gimalib ne tuhuz negdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","In abenab sabol wazim in ago wit wolayta asawnib wit tigiluwiynan ham. Giluwiyad in wit anagin dimunta na ginuweq ago wit abitnib humab tuwoldaq ham. Humab wolad in wit asan meqinta na ginuweq faq a hi miyaqtab hunegid le tuqoydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ari kam nab Yesus saw Galiliy hulosim Jon huz yagdaq haqad yuw Jodan-ib Jon ago hib tubol. ");
INSERT INTO mlp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bolan Jon huz ugnan hulosyaq. Ad in bulon, Ya ni a hi huz nigdaiq ham. Ninmo teq ya huz yagdaq ham. Ni ezaq haqad yaqgo hib bol? ham. ");
INSERT INTO mlp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Haqan Yesus amenin emim bulon, Nab iysa ya bilay nazaq muran ni em ham. I God anad muzinad daq dimunta ka tiqemam ham. Daq dimdimunta God anan anad bilaqaqta na i araq diq a hi hulosam ham. In nazaq haqanmo Jon aqez muzinim tuhuz ug. ");
INSERT INTO mlp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Huz ugan Yesus hidmo yuw hulosim dubub gwaladmo ame gwalehim kait misireq nog iyim aqez hassa in ahol wam. Ahol waqsa God ago Bugaw Dimunta ah husta nog iyim hitiqim bolim aholib tisoqot. ");
INSERT INTO mlp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Soqotan Heven-ib God aqez kazaq bilam, Mat ka ya itatin ham. Ya in anan inad bilaqsa ya igem dimun diq iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ari daq na abe ban God ago Bugaw Dimunta in Yesus waqim ad saw araq amatawun haiqtab tilah, Satan in Yesus anad ulum waqdaq haqad. ");
INSERT INTO mlp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A lehan saw nab Yesus didaq haiqmo ossa kam 40 nazaqmo tihiqiy. An abeb in agemnan tumoqyaq. ");
INSERT INTO mlp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","In agemnan moqad ossa Mat I Gilum Waqaqta na bolim tubulon, Ni God atatin iyeq teq ni gig ka bulonid in buliyeq bret iyid ni neq ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Haqan Yesus amenin emim bilam, God ago marib gamuk araq kazaq bilam ham. Bret amomo in mat eman kayeqmo a hi osaqta haqad in bilam ham. Mat God aqezab gamuk gwahtiqaqta na bunmo huritim muzinad teq in kayeqmo osaqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","In nazaq bilaqan Satan in waqim ad God ago uliq tawonta Jerusalem-ub tilah. A lehim in Tempel abigmanib Yesus eman titur. ");
INSERT INTO mlp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tursa in bulon, God ago marib gamuk araq kazaq bilam ham, God in ago angelo gibilenid in tinibiy muz daqay haqad in bilam ham. Nibiy muzad in boleq gibenab tinisor daqay haqad in bilam ham. Luweq ni nisen gigib woltaydaq haqad in bilam ham. Nazaq iyan ni God atatin iyeq teq ni sortukeq woq ham. Woqsa ni nimam nilumsihsa ya nibiyiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Haqan Yesus bilam, Teq God ago marib gamuk ta araq kazaq usaqmo ham. Na in bilam, Iyahta in ningo God haqad in bilam ham. Nazaq iyan ni girerey emad in hi ulum waq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Haqanmo Satan in Yesus waqim ad garah araq sisaqta abigmanib tugwalah. A gwalehim in kantri aseseqta gigo nagah dimdimunta bunmo tiqisihun bug. ");
INSERT INTO mlp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Isihun bugad teq in Yesus bulon, Ni yaqmen nibakbakan ulum laquwad ya ibin iluwid teq ya nagah ko bunmo tinigdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Haqan Yesus bulon, Satan ni tuk ham. God ago marib gamuk kazaq bilam ham. Iyahta in ningo God haqad in bilam ham. Ni in amomo abin iluwad ago kabiy emdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ari Yesus nazaq haqanmo Satan in hulosadmo tilah. Lehsa teq God ago angelo asor bolim Yesus tuqulumsihiy. ");
INSERT INTO mlp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ari Yesus in Jon irquriyta na huritim in muleqim saw Galiliy-ib tilah. ");
INSERT INTO mlp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Lehim in uliq Nasaret hulosim le uliq Kapaneam-ub tuqos. Uliq Kapaneam na in Juda gisesan Zebulun ayow Naptaliy inaq gigo og amuganib yuw akurorqan anan Galiliy haqayta na aqurumnib usaqta. ");
INSERT INTO mlp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesus le uliq Kapaneam-ub tuqossa teq daq na in God ago gamuk kwaziqmo nantut Aisaya bilamta na tuwol net bug. ");
INSERT INTO mlp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Gamuk na bilam, Saw Zebulun teq saw Naptaliy in yuw ayahta akurorqanta aqurumnib usaqta ham. Saw giger na in yuw Jodan aqurumun kozaq ban usaqta ham. Teq mataw saw giger na ginan Galiliy haqayta ham. Ad in bilaqay, Saw nab on mataw en ta asor Juda a haiqta kabemmo Juda gilikmanib osay haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","On mataw saw nab osayta na in ginad a hi em hasad meqin diq os yaqayta ham. Bilaqne in romriqab os yaqayta nazaqmo ham. Teq muran mataw na saw anuwan ayahta ahol tuwaqiy ham. Saw anuwan na bilaqne tarommo saw hastitaysa zeq ahokan gwalaq nazaq nogta in ahol waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ari Yesus uliq Kapaneam-ub lehim tuqosad teq in gamuk alulin emim tibilam, God ago maror bolim sinsin tiqiy ham. Nazaq iyan ne ginad buliyeq gigo daq meqinta gileh ugiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ari Yesus yuw-kurorqan Galiliy aqurumun muzim lehad luwim in maqbab gigermo dob hunegim nabiq waqad luwsa tigibiy. Araq na anan Saimon. In anan araq Pita haqayta. Teq in amikqan anan Andru. In giger kabiy naqmo em yaqayta amatawun. ");
INSERT INTO mlp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus mataw giger na gibiyad gibilan, Ne ya imuzeq boliy ham. Bolsa ya giqisihunid ne nabiq waqayta nazaqmo teq ne mataw tigiwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Haqan hidmo giger na dob hulosan ussa in Yesus muzim inaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Lehad luwim Yesus maqbab gigermo a ta gibiy. Mataw na in Sebediy atatniz Jems ama Jon inaq. In gimam inaq muyib dob wastitayad ossa Yesus giger na tigililewunmo. ");
INSERT INTO mlp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Gililewunan hidmo in gimam hulosan muyib ossa in Yesus muzim inaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ari Yesus saw Galiliy-ib uliq bunmo lehad in on mataw gigo bit humab wolayta nab suleq negad in God ago maror og kab gwahtimta na agamukan tigibilenyaq. In gamuk dimunta na gibilenad teq in gigo moq teq gihol asor meqniyta na bunmo tigiwastitayyaqmo. ");
INSERT INTO mlp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","In nazaq emsa abin saw Siriya-ib uliq bunmo tilah. Lehan mataw gigo moq inaq na bunmo giqad Yesus ago hib tubol yaqay. Mataw gigo moq amo amo inaqta na teq mataw gihol titiyaqta na teq mataw gihol gibensen agadan iyim in ogib woqim gibensen ayim gihol harara nemaqta na teq mataw gigo bugaw meqinta giholib usaqta na teq mataw gibensen momta nagan bunmo giqad bolid Yesus in giwastitayyaq. ");
INSERT INTO mlp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Teq on mataw dauh biyahta saw Galiliy-ibta teq saw Dekapolis-ibta teq uliq Jerusalem-ubta teq saw Judiya-ibta teq yuw Jodan aqurumnibta na kabemmo in Yesus muzeq inaq leh yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Ari Yesus on mataw dauh biyahmo gibiyad in garah araq abigmanib tugwalah. Gwalehim in os woqim ossa ago disaipel agerab tuboliy. Bolan Yesus gamuk negim kazaq gibilan, ");
INSERT INTO mlp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ni nog bilaqaq, Ya God ago maror aduganib gwahtiqdaiqta na ago ya mat dimun a haiq haqaqta na ni tidimniyim osaq ham. Na ezaqgo ni teq God ago maror aduganib gwahtiqeq anonon diqmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ni nog ninad meqniysa gaqad osaqta na ni tidimniyim osaq ham. Na ezaqgo God teq ni ninad tuwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ni nog daq haresmo a hi emad tok nemim luwaqta na ni tidimniyim osaq ham. Na ezaqgo ni teq mat nibin inaqta tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ni nog didaq teq yuwnan moqaqta nazaqmo ni God ago daq titnonta anan moqaqta na ni tidimniyim osaq ham. Na ezaqgo God teq nagah ni anan moqaqta na nigid tiniyunindaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ni nog on mataw ginan ninad meqniysa ni ninad negaqta na ni tidimniyim osaq ham. Na ezaqgo God teq ni ninan anad meqniysa in anad tinigdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ni nog nigem dimun diqmo anumlan haiqmo usaqta na ni tidimniyim osaq ham. Na ezaqgo ni teq God ahol tuwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ni nog mataw gilikmanib an mug teq an wol bayan woqaqta na ni tidimniyim osaq ham. Na ezaqgo mataw teq ni ninan God atatin tihaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ni nog God ago daq titnonta emsa mataw afaqan nigayta na ni tidimniyim osaq ham. Na ezaqgo ni teq God ago maror aduganib gwahtiqeq anonon diqmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ni nog niholib ya ibin ussa mataw nibilawunad teq in ni nimeqin tonad nimalib nan katiyta emayta na ni tidimniyim osaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ni ninad dimniysa nigem dimun diq iyan ham. Na ezaqgo ningo naw ayahmo Heven-ib nawa nibaq tunim usaq ham. Kwaziqmo mataw in God ago nantut ginan gigem meqniysa in nazaqmo gimeqin ton yaqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ari Yesus gamuk bilaq tutim a lehad in bilam, Kamis didaq eman aneq dimniyaqta nazaq nogmo ne og kab osayta ham. Teq kamis agon hiqiyid i ezaq tonid teq kamis na agon inaq a ta iydaq? ham. Kamis nazaqta na akabiyan haiqta ham. Mataw ogib hunegim gisenab tubaysisiyayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ne og kab saw anuwan nogta iyim osayta ham. Ne ginad emiy ham. Uliq araq garah abigmanib usad in ulilemim a hi usaqta ham. Na ezaqgo taromab mataw na gigo faq oysa mataw ahol waqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ad nazaqmo mataw lam miderim kuramab a hi sihenayta ham. Haiq ham. In lam miderim ulilib othenan oysa bit nab mataw bunmo anuwanib osayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ad nazaqmo ne gigo daq dimunta ne mataw gimeb ulalabmo emsa in ahol waqiy ham. Ne gigo daq dimunta na lam anuwan oy nog iysa mataw ahol waqad teq in ne Gimam Heven-ib Osaqta na abin tiqiluw daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ne luweq ya inan bilaq daqay, Mat ka God ago maror Moses mar tonta na teq gamuk God ago nantut mar toniyta na baymuznan bol haq daqay ham. Nazaq ne ginad hi emiy ham. Ya gamuk na baymuzgo a hi bol ham. Ya gamuk na muzinad wol net buggo haqad ya bolta ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya helmo ne gibilenaiq ham. Og kait inaq us tutsamo God ago maror agamukan asit diq araq a hi hiqiydaq ham. Mar na bun diqmo kuluwa-kuluwmo ussa le nagah bunmo in anan bilamta na tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nazaq iyan mat God ago marib gunun araq amik diqta itiyonad teq in nazaqmo mataw giqisihunid in emsa mat na God ago maror aduganib abin amik diq iydaq ham. Ari mat God ago marib gunun bunmo muz bugad teq in nazaqmo mataw giqisihunid in emsa mat na God ago maror aduganib abin tidimniydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ya ne gibilenaiq ham. Ne gigo daq titnonta ne emayta na in mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq gigo daq a hi giquriyamid ne God ago maror aduganib le a hi gwahtiq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Teq ne gisesan gigo gunun araq ne huritiyta na in kazaq bilam ham. Ni mat wol emid hi moqan haqad in bilam ham. Ad mat in mat araq wol emid moqid mat na hazizirib leheq ago daq na amenin tuwaqdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ta teq yaqmo kazaq ne gibilenaiq ham. Ni nigem meqinta nimaqbab ugeq ni hazizirib titurdaqmo ham. Ad ni nimaqbab bilawuneq ni kaunsel ayahta na gimeb tugwahtiqdaq ham. Ad ni nimaqbab buloneq bilaqdaq, Ni agadan haqeq ni saw faq oyad a hi miyaqta nab tilehdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Nazaq iyan ni God naw ugnan haqad ago tamaz em abanab naw tiqemad nab ni niyow meqin tonta na anadin emeq ni ningo naw ban nab hulosad niyowgo hib leh ham. Leheq niyow inaq an anobun wastitayeq teq ni muleqeq ningo naw na God ug ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ari ta mat araq nan nignan haqad ninaq hazizirib lehad hidmo danib ni inaq gamuk na wastitayiy ham. Luweq mat na niwaqeq megistret abenab niqemdaq ham. Niqemid megistret niwaqeq hurmey gibenab niqemid hurmey niwazeq bit giqirquran osaytab tiniqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya helmo ne gibilenaiq ham. Ni bit na hidmo a hi hulosdaq ham. Ni bit nab osad ningo daq meqinta amenin zay bugeq teq ni asanib tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Teq ne gisesan gigo gunun araq ne huritiyta na in kazaq bilam ham. Ni an alulib hureqeq inaq hi usiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ta teq yaqmo kazaq ne gibilenaiq ham. Mat in aw tuwaqim teq in aw ta araq amebmo ahol waqad in utetad anadibmo bilaqaq, Ya aw ko waqeq inaq us nagta haqaqta, mat na in awe meqin tonim an haresmo huramta nog tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Teq ni nimeqnagin niqabun kat nigid ni ninad helta hulosnan tonad ni nimeqnagin na othaseq hunegid lehan ham. Ni nihol asormo os dimuntab lehdaqta na in dimun ham. Ari ni nihol anaghan bunmo ussa in ni niwazeq nihunegid ni saw faq oyaqtab lehdaqta na in meqin diq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Teq ni niben niqabun kat nigid ni ninad helta hulosnan tonad ni niben na uroteq hunegid lehanmo ham. Ni nihol asormo os dimuntab lehdaqta na in dimun ham. Ari ni nihol anaghan bunmo ussa ni saw faq oyaqtab lehdaqta na in meqin diq ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Teq ne gisesan gigo gunun araq na in kazaq bilam ham. Mat araq anadibmo awe tumuznan haqad in sansandek mar toneq awe ugad teq in tumuzdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ta teq yaqmo kazaq ne gibilenaiq ham. Mat araq awe in mat ta araq uteteq inaq luwsa aduw diq na in aw na muznan in tumuzdaq ham. Ari in awe daq araq meqinta a hi emsa aduw anadib samanmo muzeq in awe na timeqin tondaq ham. Na ezaqgo in ago aw muzta na le mat muturta a ta waqim in bilaqne aduw hulosim mat araq inaq luw nog iyaqta ham. Sa mat muturta na in aw aduw muzan osta na waqim inaq osad in bilaqne mat ta araq ago aw inaq luw nog iyaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Teq ne gisesan gigo gunun araq ne huritiyta na in kazaq bilam ham. Ni nagah araq abinib Iyahta bulondaq, Helmo ya ninmen kabiy ka tiqemdaiq haqeq na ni nazaqmo diq tiqemdaq haqad in bilam ham. Ni a hi katiydaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ta teq yaqmo kazaq ne gibilenaiq ham. Ni ningo gamuk ulumsihnan haqad nagah araq anan hikidik biy ham. Ad ni helmo haqad Heven anan hi biymo ham. Na ezaqgo saw nab God in ago ban tawontab osad nagah bunmo giwamuzaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Teq ne helmo haqad og ka anan hi biyiymo ham. Og ka in God asen abanan iysa in asen emim osaqta ham. Teq ne helmo haqad uliq Jerusalem anan hi biyiymo ham. Uliq ayahta na in God ago king ago uliqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Teq ne helmo haqad negmo gihol anan hi biyiymo ham. Na ezaqgo ne gifaqnib giqensan araq emid husta o dubta iygo ne zaway haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ne nan heltaqmo bilaqiy ham. Eqemo ne bilaqiy ham. Teq haiqgammo ne bilaqiy ham. Ari gamuk hares mataw in gigo nan ulumsihnan haqad bilaqayta na mat meqinta naqmo in giqezab eman gwahtiqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Teq ne gisesan gigo gunun araq ne huritiyta na in kazaq bilam ham. Mat araq ni nime ulum hasid ni amenin in ame tuqulum hasdaqmo haqad in bilam ham. Teq mat araq ni nite wolworid ni amenin in ate tuwolwordaqmo haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ta teq yaqmo ne kazaq gibilenaiq ham. Mat araq ni nimeqin tonid ni amenin hi em ham. Ad mat araq ni nimanmanan niqabun wolid ni nihol buliyid in nimanmanan ninasaran wol tonanmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mat araq ningo niholsihen waqnan haqad hurmey gigo sansandek na nigid ni niholsihen na ugad ni ningo saket inaqmo ug ton ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ad mat araq in ago es afaqanta kilomita amulikmo sorgo nibe yaheq nibilenid ni ago es na sor tuteq ad kilomita amulikmo a ta leh ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mat araq ningo nagah anan sunid na ni ug ham. Ad mat araq ningo nagah waqeq teq amenin emgo nibilenid na ni ugad hi baymuz ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Teq ne gisesan gigo gunun araq ne huritiyta na in kazaq bilam ham. Ni nimaqbabanmo gilowan tonad ningo bab ni nigem meqinta neg haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ta teq yaqmo kazaq diq ne gibilenaiq ham. Ne gigo bab ginan ginad bilaqan ham. Ad mataw ne gibilawunsa ne in gimen God bulonid in gidimun tonan ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ne nazaq toneq teq ne Gimam Heven-ib Osaqta na atatniz diqmo iyeq tuqos daqay ham. Gimam Iyahta na in ago zeq eman mataw meqmeqinta teq dimdimunta inaqmo gimalib worireqaqta ham. Ad in urom eman mataw daq dimun emayta teq daq meqin emayta inaqmo gigo hib woqaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mat araq ni ninan anad bilaqsa ta ni in anan ninad bilaqaqta na in nagah a haiq ham. Ne daq na amenin araq God abenab a hi waq daqay ham. Mataw gibin meqinta takis waqayta na in nazaqmo emayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Teq ne giyognizmo nenaq gamuk emayta na in nagah a haiqmo ham. On mataw en ta asor Juda a haiqta nagan in nazaqmo emayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nazaq iyan ne Gimam Heven-ib titnonimmo osaqta nazaqmo diq ne titnoneqmo osiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ne gihol waz naqmo hiqiyiy ham. Luweq ne ginad em daqay, I daq dimdimunta mataw gimeb emsa in i gibiyad i gibin tiqiluw daqay haq daqay ham. Ne nazaq emeq ne Gimam Heven-ib Osaqta na abenab naw araq dimunta a hi waq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mataw gimileq meqinta na in mataw gina haiqta nagah tinegnan haqad in mat araq bulonan in bit humab wolaytab teq uliq gemab taur ulam negaqta ham. Mataw na ginad kazaq emay ham. Mat ka taur ulamsa mataw bunmo gime bo gibiyad i mataw ginaghan haiqta ka nagah negsa in i gibiyad gibin tiqiluw daqay haqayta ham. Ya ne gibilenaiq ham. Mataw na in gigo naw nawaqmo tuwaqiy ham. In God abenab naw araq dimunta a ta hi waq daqay ham. Nazaq iyan in emay nazaq ne hi emiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ne mat ana haiqta ulumsihnan haqad ne mataw gime titoneqmo ulumsihiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ne nazaq ulilemeqmo daq emsa mataw ne a hi gibiy daqay ham. Id teq ne Gimam daq ulilemabta ahol waqaqta na in ne naw dimunta tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Teq mataw gimileq meqinta na in God inaq gamuk emnan haqad in bit humab wolaytab teq uliq gemab ulalab turad in God inaq gamuk emayta ham. In ginad emay, I God inaq gamuk emsa mataw i gibiy daqay haqad in nazaq emayta ham. Ya helmo ne gibilenaiq ham. Mataw na in gigo daq na anawun nawaqmo tuwaqiy ham. In God abenab nagah araq dimunta a ta hi waq daqay ham. Nazaq iyan in emay nazaq ne hi emiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ne God inaq gamuk emnan haqad ne bit aduganib gwahtiqeq dan oteq teq ne Gimam ulilemim osaqta na inaq gamuk emiy ham. Sa ne Gimam daq ulilemabta ahol waqaqta na in amenin dimunta tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","On mataw en ta asor Juda a haiqta nagan in gigo god katiyta inaq gamuk emad in gamuk samanta kabemmo inaqmo bilaqim a lehayta ham. In ginad emay, I daq kazaq emsa teq i gigo god i giqez tuhuritdaq haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ta teq ne in gigo daq na hi muziniy ham. Na ezaqgo ne nagah araq ago siqim iyayta na anan Gimam Iyah a hi bulonsamo in tekomo tuhuritta ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ari ne God inaq gamuk emnan ne kazaq buloniy ham. I Gimam Iyah Heven-ib osaqta, Ni on mataw bunmo giqemid in ni ninan waziniy. ");
INSERT INTO mlp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ad ni ningo maror emid og kab gwahtiqan. Sa mataw Heven-ib ninad muzinayta nazaqmo ni mataw og kabta giqemid in ni ninad muziniymo. ");
INSERT INTO mlp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kam amulik-mulikmo ago didaqta ni ig. ");
INSERT INTO mlp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ad mataw i gigo hib daq meqinta emsa i walemad anadin a ta hi emauqta nazaqmo ni i gigo daq meqinta giwalemad anadin ta hi emmo. ");
INSERT INTO mlp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nagah i gilum waqdaqta na ni wasihid i giholib hi gwahtiqan. Sa mat meqinta na i gimeqin tonsa ni i gilumsih. ");
INSERT INTO mlp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ad Yesus bilam, Ne huritiy ham. Mataw ne gimeqin tonsa ne in gigo daq na walemad anadin a ta hi emsa ne Gimam Heven-ib Osaqta na in ne gigo daq meqinta tigiwalemdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ari mataw ne gimeqin tonsa ne in gigo daq na a hi walemsa Gimam Iyah in ne gigo daq meqinta a hi giwalemdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mataw gimileq meqinta na in didaq tuqudinad in ginobun iyim giwaq meqin diq iysa luwayta ham. In ginad emay, I ginobun iyeq luwsa mataw i tigibiy daqay haqad in nazaq emayta ham. Ya helmo ne gibilenaiq ham. Mataw na in gigo naw nawaqmo tuwaqiy ham. In God abenab naw araq dimunta a ta hi waq daqay ham. Nazaq iyan in emay nazaq ne hi emiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ne didaq tuqudinnan haqad ne ginobun suholeq giqensan otsireqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ne nazaq emid teq mataw ne didaq udinayta na ago a hi hurit daqay ham. Ta teq ne Gimam ulilemim osaqta na in amomo ne tigibiydaq ham. Ad ne Gimam daq ulilemabta ahol waqaqta na in ne gigo daq dimunta na amenin dimuntamo tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ari Yesus kazaq bilam, Ne giholyon nagah dimdimunta og kab humab hi emiy ham. Og kab bidbid teq hurhur in nagah meqin tonayta ham. Teq mataw girin inaqta na in gel wolim gwahtiqim nagah rin tonayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nazaq iyan ne Heven-ibmo nagah dimdimunta giholyon humab emiy ham. Uliq nab bidbid teq hurhur haiqta ham. Teq mataw gel wolim gwahtiqim nagah rin tonayta na haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ne ginad emiy ham. Uliq edob ne gigo nagah dimdimunta usdaqta nabmo teq ne ginad ayahmo tuqusdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ni nimeqnagin nihol bunmo anuwan ugaqta ham. Ni nime dimun iyid ni nihol bunmo anuwan inaq tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ari ni nime meqin iyid ni nihol bunmo aromriq inaq tiqiydaq ham. Nazaq iyan ni nimuganib anuwan us nagta na in romriq iyid romriq na in ni niholib ayahmo diq tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ari mat araq in mataw aseseqta giger giqez a hi muzdaqta ham. In nazaq tonad luweq in araq agem meqinta ugad araq in agem dimunta ugdaq ham. Teq in araq anadin diq emad araq in gileh ugdaq ham. Nazaq iyan ne mani anadin diq emad ne God aqez a hi muzin daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nazaq iyan ya ne gibilenaiq ham. Ne gigo luw os anan ginad haresmo hi emiy ham. Ad “I teq naga neqam?” o “I teq naga uluwam?” haqad ne nazaq ginad hi emiy ham. Teq ne giholgo ginad haresmo hi emiymo ham. Ad “I teq naga amalib i gihol isiham?” haqad nazaq ne ginad hi emiy ham. Ne didaq neqgomo og kab a hi osayta ham. Ad ne gihol in tubusanib sihengomo a hi usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ne ah gibiyiy ham. In didaq a hi leyayta ham. Ad in didaq tayim didaq abitnib a hi emaytamo ham. Teq ne Gimam Heven-ib Osaqta inmo didaq negsa neqayta ham. Ari in nagah amik diqta na anononmo wamuzaqta nazaqmo in ne a hi giwamuzdaqmo ye? ham. Haiqgam ham. Ne ah ayahmo giquriyamiyta ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ne gilikmanib nog diq inmo ahol anan anad meqniysa in ahol moqdaqta akaman na ulum riyawuneq asitmo a ta osdaq? ham. Na haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ad nagaqgo ne tubusango ginad haresmo emayta? ham. Ne mazrewrew kabiyab gwalaqta na anadin emiy ham. Teq in ezaq gwalaqta na ne ahol waq kemiy ham. In aholyon kabiy araq a hi emaqta ham. Ad in aholyon tubusan a hi initaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Teq ya ne gibilenaiq ham. Kwaziqmo Isrel gigo king Solomon in ago balaw dimdimunta aholib emyaqta ham. Ta teq in ago balaw araq dimun diqta mazrewrew nogta haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Muran mazrewrew na kabiyab gwalim turaq ham. Sa babeq mataw uroteq faqab ginuwid gwaldaq ham. On mataw, ne ginad God anan helmo haqayta na in amik diq ham. God nagah samanta na balaw tonad in nazaqmo ne giholyon tubusan a hi negdaqmo ye? ham. Haiqgam ham. In tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Ne nagah osgota na a hi waqeq ne meqin os daqayta na ago ne Gimam Heven-ib osaqta na tuhurit ham. Nazaq iyan ne ginad haresmo emad, “I teq naga neqam?” o “I teq naga uluwam?” nazaq ne ginad hi emiy ham. On mataw en ta asor Juda a haiqta nagan in nagah osgota na waqgo haqad giholtuw bulad luwayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Teq negmo nazaq hi emiy ham. Itureqmo ne God ago maror aduganib gwahtiqeq in ago daq dimdimunta emgo ne giholtuw bulad luwiy ham. Ne nazaq emsa teq God nagah osgota na bunmo inaqmo tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nazaq iyan ne kam babeqta na anadin diq hi emiy ham. Kam babeqta na inmo ago afaqan araq inaqta ham. Luweq ne babeq ago afaqanta na waqeq kam muranta na ago inaq wastoneq ne loyinsa in afaqan ayah diqta iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ne mataw gigo daq ulum kemad, “Ka mataw meqin” nazaq ne ginan hi bilaqiy ham. Luweq God ne gigo daq ulum kemad ne ginan nazaq bilaqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Na ezaqgo ne mataw gigo daq ulum kemim ginan bilaqayta nazaqmo teq God in ne gigo daq ulum kemeq ne ginan bilaqdaqmo ham. Daq ezaqta ne mataw gimen emayta nazaqmo God in amenin ne gimen tiqemdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nagaqgo ni niyow ameb rohroh amik diqta ussa ni ahol waqad ta ninmo nimeb ay anabun ayahta usaqta na ni ahol a hi waqaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ni ninad ezaq emad ni niyow bulonaq, Ya iyow haqaq ni nimeb rohroh usaqta na ya walemnan haqaq? ham. Haqad ta ninmo nimeb ay anabun ayahta na usaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ni nimileq meqin diq ham. Itureqmo ninmo nimeb ay anabun usaqta na walemeq nime saw anononmo ahol waqad teq ni le niyow ameb rohroh usaqta na walem ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ne gihol waziy ham. Mataw asor in bilaqne bul gaun nog ham. Ne God ago gamuk dimdimunta negsa in bilaq daqay, Na nagah amik diq haq daqay ham. Bilaqne pokpok dimdimunta anawun ayahmota hunegan bul ginognib woqan in ahol waqad bay ninalayta nazaq nog ham. Ad ne mataw meqinta na ginan maqbab haqsa abeb in gihol buliyeq ne gibabun diq iyeq teq in ne tigimeqin ton daqay ham. Bilaqne gaun anamreniz didaq negsa in gihol buliyim gimugayta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ne nagah araq anan God susumun ugid teq in tinegdaq ham. Ne nagah araq naguneq teq ne ahol tuwaq daqay ham. Ne dan ez wolhamsa teq God ne giyon dan tihas negdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","On mataw nagah anan God susumun ugayta na in nagah na waqayta ham. Teq on mataw nagah nagunayta na in nagah na ahol waqayta ham. Ad on mataw dan ez wolhamayta na God teq in giyon dan tihas negdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ne gilikmanib mat araq atatin in bret anan amam bulonid amam gig ugdaq e? ham. Haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ad in ago amun na nabiq anan bulonsa amam in nagah ahulinaqta gimugaqta araq waqeq ugdaq e? ham. Na haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ne mataw ginad meqinta usaqta ham. Teq ne gigo onmin nagah dimdimunta neggo ne tuhurit kemiyta ham. Ari ne Gimam Heven-ib osaqta na in nazaq ago on mataw a hi gitondaqmo ye? ham. Haiq ham. On mataw in Gimam Iyahta na inaq gamuk bilaqad bulonsa in ago nagah dimdimun diqta tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nazaq iyan on mataw in ne ezaq gitonid ne ginad dimniydaqta nazaqmo ne in gigo hib daq emiymo ham. Daq naqmo in God ago maror Moses mar tonta na teq God ago nantut gamuk mar toniyta na bunmo alulin diq ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ne dan ez amik diqta nab le gwahtiqiy ham. Dan mataw muzim le hiqiyayta na agarahin haiqta ham. Teq dan meqinta na ago dan ez ayahmo diqta ham. Nazaq iyan on mataw kabemmo dan ez nabmo le gwahtiqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ari dan ni muzeq le saw kayeqmo kuluwa-kuluwmo osaytab gwahtiqdaqta na in garah aseseqta kabemmo inaqta ham. Ad dan dimunta na ago dan ez amik diqta ham. Nazaq iyan on mataw gilikmanib amulik-mulikmo in dan ez na nagunim ahol waqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ne nantut katiyta na ginan ne gihol asawan woltayiy ham. Ne mataw na giloyinsa in mataw midemqan diqta bilaqne sipsip nog iy daqayta ham. Teq in ginadmo diq na in ne kat negeq ne gimeqin tonnan ham. Bilaqne gaun kwasikta sipsip gimug emim gineqayta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mataw katiyta na gigo kabiy anon emsa teq ne in gigo tuhurit kem daqay ham. Mataw am asasuqin inaqta ahulib wain anagin waqayta ye? ham. Teq in sisihun meqinta abiyoran inaqta na amuganib ay fik anon waqayta ye? ham. Haiqmo diq ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Na nazaqmo ham. Ay dimdimunta bunmo ginon dimunta emayta ham. Teq ay meqinta anon meqinta emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ay dimunta anon meqinta a hi emdaqta ham. Teq ay meqinta anon dimunta a hi emdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ay bunmo anon dimunta a hi emayta na mataw in qwayim hunegan faqab lehayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nazaq iyan ne mataw katiyta na gigo kabiy anon emsa ahol waqad teq ne in gigo tuhurit kem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","On mataw kabemmo ya inan samanta biyim bilaqay, Iyahta, Iyahta haqayta ham. In ginad emay, I Yesus anan Iyahta biyadmo i God ago maror aduganib le tugwahtiqam haqay ham. Hikidik ham. Mat ya imam anad muzaqta naqmo in ya imam Heven-ib osaqta na ago maror aduganib tugwahtiqdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Abeb mataw kabemmo yaqgo maror aduganib gwahtiqnan tonadmo in ya ibileneq bilaq daqay, Iyahta, Iyahta haq daqay ham. I ogib osad ni nibinib nagah abeb teq gwahtiqdaqta na ago i bilaqad luwta haq daqay ham. Teq i nibinib mataw giholib bugaw meqinta gimuzta haq daqay ham. Ad i nibinib daq azawayin inaqta kabemmo emta haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Haqid teq ya gibilendaiq, Ya ne gigo a hi hurit haqdaiq ham. Ne mataw daq meqinta emayta ne ya ihuloseq kozaq lehiy haqdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nazaq iyan on mataw yaqgo gamuk ka huritim muzinayta na in bilaqne mat ago bit gig ayahta amalib amta nazaq nog iy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mat na bit tiqeman teq urom ayahmo wom ham. Woqsa uq hitiqad tim ayahta inaqmo eraqim sibim le bit na othasan teq haiq ham. Bit na a hi wom ham. Na ezaqgo mat na gigmo diq amalib ago bit alulin am ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ari on mataw yaqgo gamuk ka huritim teq a hi muzinayta na in bilaqne mat agadanta ago bit ibur amalib amta nazaq nog iy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mat na bit tiqeman teq urom ayahta woqan uq hitim ham. Uq hitiqad tim inaqmo sibim le bit othasan bit na atoranmo woqim timeqniy has ham. ");
INSERT INTO mlp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ari Yesus gamuk na bunmo bilaq bugan tihiqiyan on mataw dauh biyahta na in ago suleq huritim in gihol turuh nem yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Na ezaqgo Yesus ago gamuk in mataw Moses ago gunun hurit kemiyta na gigo gamuk nog a hi iyyaq. In ago gamuk bilaqne God inmo abin ugan in suleq bilamta nazaq nog iyyaq. ");
INSERT INTO mlp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ari Yesus garah nab osim gewoqanmo on mataw dauh kabemmo muzim inaq tileh yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lehsa mat araq ago moq lepra inaqta bolim Yesus agerab abakbakan ulum laquwim turad teq in bulon, Iyahta ham ni ninad bilaqsa teq ni ya iwastitayid ya God ameb isan anumlan ka tihiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Haqan Yesus aben itiwunim mat na wazad bulon, Ya inad bilaqaq ham. Ni nisanib ninumlan usaqta na hiqiyan ham. Haqan muran diq nawaqmo mat na ago moq lepra tihiqiy. ");
INSERT INTO mlp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","An Yesus in mat na adek wazim bulon, Daq kawa ya emta ka ago ni mat araq hikidik bulon ham. Ni leheq mat tamaz emaqta naqmo nihol isihun ham. Isihunad teq Moses bilamta nazaqmo ni nihol anawun em ham. Emid teq mataw ningo moq tihiqiyta na ago tuhurit daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Ari Yesus le uliq Kapaneam-ub tugwahtiqan teq Rom gigo bab mataw 100 nazaq gigo ayahta araq bolim in anad awaz meqin amalib Yesus bulonim bilam, Iyahta ham. Yaqgo kabibiy mat kowa bitab moqad usaq ham. In abensen moqan ahol titiy naqmo hiqiysa usaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Haqan Yesus bulon, Ya teq leheq wastitayid in tidimniydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Haqan bab mataw gigo ayahta na amenin emim bilam, Iyahta ham ni yaqgo bit aduganib le gwahtiqdaqta na ago ya mat dimun a haiq ham. Ya inad emaiq ham ni kabmo turad gamuk bilaqidmo yaqgo kabibiy mat na ahol tidimniydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na ezaqgo ya inaqmo yaqgo mat danmebta ahaqenib osaiqta ham. Ad yaqgo mataw bab emayta na in ya ihaqenib osaytamo ham. Ossa ya araq bulonaiq, “Ni leh” haqsa in lehaqta ham. Teq ya araq bulonaiq, “Ni bol” haqsa in bolaqtamo ham. Ad yaqgo kabibiy mat bulonaiq, “Ni kabiy em” haqsa in kabiy na emaqta ham. Nazaq iyan ya inad emaiq ham ni gamukmo bilaqid yaqgo kabibiy mat na ahol tidimniydaq haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Haqan Yesus mat na ago gamuk huritim ahol turuh nam. Ad in mataw muzim inaq boliyta na gibilan, Ya ne gibilenaiq ham. Mat ka in Juda mat a haiqta ham. Teq in Juda mataw bunmo giquriyamim ya inan helmo diq haqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ad ya ne gibilenaiq ham. Zeq gwalaqta ban teq zeq wolehaqta ban on mataw amo amota kabemmo boleq in Abraham, Aisak teq Jekob nenaq God ago maror aduganib didaq neqad tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ari on mataw Gimam Iyah ago maror aduganib danmeb le gwahtiq nagiyta na God in gimuzid asanib gwahtiqeq romriqab tuqos daqay ham. Osad in ginad meqniysa gaqad gite guruwad os daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Haqad in bab mataw gigo amebta na bulon, Ni leh ham. Ni ninad helta usaqta nazaqmo in tugwahtiqdaq ham. An kam nabmo mat na ago kabibiy mat na ahol tidimniy. ");
INSERT INTO mlp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ari Yesus le Pita ago bitab gwahtiqim in Pita alen asan afan iyad banab ussa ahol wam. ");
INSERT INTO mlp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ahol waqad in le aw na abenab wazanmo in asan afan iyim usta na tuhulos ug. Hulos uganmo in eraqim Yesus amen didaq anaran usta na waqim a bolim tuqug. ");
INSERT INTO mlp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ari teq zeq wolehsa imisor diq tiqiyan mataw in giyogniz kabemmo giholib bugaw meqinta usaqta na giwaqim giqad Yesus ago hib tuboliy. A bolan Yesus gamukmo bilaqsa bugaw meqinta na tituk yaqay. Sa in mataw gigo moq inaq na giwastitayan gihol tidimniy yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Daq nazaq gwahtiqad in God ago nantut Aisaya aqezab gamuk gwahtimta na tuwol net bug. Gamuk na bilam, In i gigo moq teq gihol asor meqniyta na inmo ahol ugim soran i gihol tidimniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ari on mataw dauh biyahta Yesus lilut ugim tursa in gibiyad ago disaipel gibilan, I yuw urumun kozaq ban lehuq ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Haqad in tilehsamo mat araq Moses ago gunun hurit kamta na bolim Yesus bulon, Tisa ham. Uliq saw edob ni lehdaqta nab ya nimuzeq ninaq tilehdaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Haqan Yesus bulon, Ni ninad em haseq teq ya imuzeq bol ham. Gaun kwasikta kuduqib usayta ham. Ah in gigo rir inaqta ham. Ari Mat Atatin in ago us osad anamur emdaqta abanan araq diq haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Haqan teq Yesus ago disaipel ta araq bolim bulon, Iyahta ham ni ya ihulossa ya leheq imam tumomta na yay tonad teq ya boleq nimuzeq ninaq tilehdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Haqan Yesus bilam, Nab iyan ham. Mataw giwitan moqim usad in God anadin a hi emayta na in gimo an wamuzad an yay toniy ham. Sa ni ya imuzeq bol ham. ");
INSERT INTO mlp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ari Yesus muyib gwalsa in ago disaipel muzim inaq tugwaliymo. ");
INSERT INTO mlp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Gwalim lehadmo Yesus ame rursa wo muyib ussa tim ayahta eraqim kamis wolan muy isihnan tonyaq. ");
INSERT INTO mlp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Isihnan tonsa disaipel bolim Yesus bulonan tiqeram. Eraqan in buloniy, Iyahta haqiy ni i gilumsih haqiy. I tumoqnan tonauq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Haqan in gibilan, Ne nagaqgo rabay? ham. Ne ginad helta na amik diq ham. Haqad in eraqim tim kamis inaq ginadan in kute tinemiy. ");
INSERT INTO mlp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kute nemanmo disaipel ahol waqad in gihol riten lam. Admo in bilaqiy, Ka naga matin diq? haqiy. Tim yuw inaq in aqez huritayta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ari Yesus le yuw-kurorqan Galiliy aqurumun kozaq ban tugwahtim, uliq Gadara gigo og saw ban. Gwahtiqanmo mataw giholib bugaw meqinta usayta giger in hodhod hulosim bolim danib Yesus ahol tuwaqiy. Mataw na agadan iyim saw nab kwasik diq iyim luwsa on mataw dan nab a hikidik luw yaqayta. ");
INSERT INTO mlp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","In giger Yesus ahol waqadmo lileyim bilaqiy, God atatin haqiy ni i ezaq gitonnan bol? haqiy. I meqniyamta akaman na a hi gwahtiqsamo ni i gimeqin tonnan kab bolya haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","In nazaq haqsamo bul gihumaban araq ayahta pesan nogmo didaq neqad turiy. ");
INSERT INTO mlp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tursa bugaw meqinta nagan ginad meqniysa Yesus bulon yaqay, Ni i gimuznan iysun ni i gimuzid bul gihumab inaq ko gimuganib lehuq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Haqsa Yesus gibilan, Ne nabmo lehiy ham. Haqanmo mataw giger giholib bugaw giqusiyta na gwahtiqim le bul na gimuganib woqanmo bul bunmo sibtitayim lehim garah asibsibranib bay hilek tonim yuwmeb woqim tumoq bugiy. ");
INSERT INTO mlp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","An mataw bul giwamuzim osiyta na in daq na ahol waqad in tukim giquliqab tilehiy. Lehim in mataw giholib bugaw meqinta usim teq gihulos negiyta na ago ananin in gigo walmataw tigibilen bugiy. ");
INSERT INTO mlp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gibilenan in huritim uliq na hulosad bunmo Yesus ahol waqnan tilehiy. Lehim in Yesus abe yahad buloniy, Ni saw ka huloseq leh haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ari Yesus muyib gwalim yuw urotim urum kozaq ban le gwahtiqim in ago uliqab tilah. ");
INSERT INTO mlp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lehanmo mataw asor in mat araq abensen aditin tumoq bugta banab ussa in sorim a bolsa Yesus tigibiy. Gibiyad in mataw na ginad helta ahol waqadmo in mat moqaqta na tubulon, Yaqgo amun ham ni ninad hi meqniyan ham. Ya ningo daq meqinta bunmo tigiwalem bug ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Haqan mataw Moses ago gunun hurit kemiyta na asor in gamuk na huritim in gihol bulonim bilaq yaqay, Mat ko in God bilawunad ago ban waq nog iyaq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","In nazaq ginad emsamo Yesus tuhurit. Huritim in bilam, Nagaqgo ne ginad meqinta nazaq emay? ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ya naga gamukin bilaqid teq ne nan a hi yag daqay? ham. “Ya ningo daq meqinta tigiwalem” haqdaiq o “Ni eraqeq loq gel” haqdaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Teq Mat Atatin in og kab daq meqinta walemgo azawayin aholib usaqta na ago ne hurit daqay haqad ya kazaq diq bilaqdaiq ham. Haqad in mat abensen moqan banab usaqta na tubulon, Ni eraqeq ningo us ban waqeq ad ningo bitab a leh ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Haqan mat na eraqimmo ago bitab tilah. ");
INSERT INTO mlp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","An on mataw nab turiyta na in nagah na ahol waqim tirabiy. Rabad teq in God abin tiqiluw yaqay. Na ezaqgo God inmo ago zaway na eman mataw gigo hib ulal iyta na ago. ");
INSERT INTO mlp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ari Yesus lehad luwim in mat araq anan Matyu haqayta takis abitnib ossa ahol tuwam. Ahol waqadmo in bulon, Ni ya imuzeq bol ham. Haqan Matyu eraqim Yesus muzim inaq tilah. ");
INSERT INTO mlp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","An daq na abe ban Yesus le bitab didaq neqad tuqos. Ossa mataw gibin meqinta takis waqayta teq mataw daq meqinta emayta nenaq kabemmo bolim Yesus ago disaipel nenaq didaq neqad tuqosiymo. ");
INSERT INTO mlp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ossa Farisi nazaq gibiyad in Yesus ago disaipel tisusumun negiy, Doq tonnan ne gigo tisa in mataw takis waqayta ko teq mataw daq meqinta emayta ko nenaq didaq neqad osaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","In nazaq haqan Yesus huritim gibilan, Mataw gigo moq haiqta na in le dokta ahol a hi waqayta ham. Mataw gigo moq inaqta naqmo dokta ago hib lehayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ne leheq God ago marib gamuk araq usaqta ka ago alulin diq ne hurit kemiy ham. Gamuk nab God bilam, Ne yaqmen tamaz emad karuw anat urotayta na ya hulosaiq haqad in bilam ham. Ne mataw gigem neg daqayta naqmo ya ahol waqnan inad bilaqaqta haqad in bilam ham. Haqad Yesus bilam, Nazaq iyan ya on mataw titnonta gililewunnan a hi bol ham. Ya on mataw daq meqinta emad osayta naqmo gililewunnan bolta ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ari kam nab Jon ago disaipel bolim in Yesus susumun ugim bilaqiy, Ezaq tonim sirisirimo i Farisi nenaq didaq udinsa ta ningo disaipel didaq a hi udinayta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Haqan Yesus gibilan, Mat araq aw waqnan tonsa in ayogniz boleq inaq osad in ginad meqniysa gaq waz daqay ye? ham. Haiqgam ham. Na ezaqgo in giyow na inaq osad in ginad dimniysa osayta na ago ham. Ari abeb mataw asor boleq mat aw waqaqta na ayogniz gibenab tuwaq daqay ham. Kam na teq boldaqta ham. Bolid teq mat na ayogniz didaq tuqudin daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Haqad in bilam, Mataw tubusan muturta waqim amalib tubusan kwaziqta misiramta inaq a hi initayta ham. Luweq in tubusan kwaziqta na suholsa tubusan muturta na irnik toneq le amik iyadmo in tubusan kwaziqta na bulsireqid ayahmo diq a ta tartaydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ad nazaqmo mataw wain ayun muturta memeq asan kwaziqtab a hi tenaytamo ham. In nazaq tonid wain aqurin gwalad huhuw nemsa memeq asan kwaziqta na tartayid wain ayun mutbaleq ogib woqsa memeq asan na timeqniydaqmo ham. Nazaq iyan mataw memeq asan muturtamo waqim wain ayun muturta tenayta ham. Tenan wain ayun teq memeq asan inaq araqibmo dimunmo usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ari Yesus in Jon ago disaipel nenaq gamuk bilaqad tursa Juda gigo mat marorta araq bolim Yesus agerab abakbakan ulum laquwim turad bulon, Ya imiy muran diqmo tumoqim usaq ham. Teq ni boleq niben aholib emeq wazid in kayeq ta iyan ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Haqanmo Yesus ago disaipel nenaq eraqim mat na muzim inaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Lehsa aw araq ulig 12 nazaq moqad ned hunegad luwyaqta na in Yesus agilehun ban bolim ago tubusan adek tuwaz. ");
INSERT INTO mlp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Na ezaqgo in tekomo ahol bulonim bilam, Ya iben Yesus ago tubusan adekmo wazeq teq ya ihol tidimniydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Haqad in Yesus ago tubusan adek wazsamo Yesus ahol buliyim ahol waqad bulon, Ya imiy ham ni ninad hi meqniyan ham. Ni ya inan helmo hamta naqmo niqeman ni nihol tidimniy ham. Haqsamo aw na ahol tidimniy. ");
INSERT INTO mlp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ari Yesus le Juda gigo mat marorta na ago bitab tugwahtim. Gwahtiqim in on gaq wazsa mataw kadug ulamad gihulan kabemmo emsa gibiy. ");
INSERT INTO mlp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Gibiyad in gibilan, Ne eraqeq kozaq lehiy ham. Amun aw na a hi mom ham. In usaq ham. In nazaq haqan on mataw na bunmo in aqez tiyuquwuniy. ");
INSERT INTO mlp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yuquwunsa Yesus gimuzan asan ban gwahtiqsa in le gwahtiqim amun aw na aben wazan in eraqim titur. ");
INSERT INTO mlp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","An teq Yesus daq amta na abin saw nab uliq bunmo tilah. ");
INSERT INTO mlp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ari Yesus uliq na hulosim lehsa mataw giger gime haiqta in muzim inaq lehad teq in lileyeq bulon yaqay, Devit atatin haq yaqay ni i ginan ninad meqniyan haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Haqsa Yesus le bitab tugwahtiqanmo mataw giger gime haiqta na in ago hib tuboliy. Bolan Yesus tisusumun nag, Ya ne giwastitaydaiqta na ago ne ginad helmo haqay ye? ham. Haqan in bilaqiy, Iyahta haqiy i helmo tihaqauq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Haqan Yesus aben mataw giger na gimeqnagnib emim gibilan, Ne ya inan helmo haqayta nazaqmo in ne giholib gwahtiqan ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Haqanmo mataw giger na gimeqnagin tiriram. Gime rireqan Yesus gamuk awaz meqin diqta gibilenim bilam, Daq kawa ne giholib gwahtimta ka ago ne mat araq diq hikidik buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Haqan teq haiq. Mataw giger na Yesus giholib daq amta na bilaqsa abin saw nab uliq bunmo tilah bug. ");
INSERT INTO mlp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mataw giger na Yesus hulosim tilehsa on mataw in mat ta araq aqez haiqta aholib bugaw meqinta usaqta waqim Yesus ago hib a boliy. ");
INSERT INTO mlp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","A bolan Yesus bugaw meqinta na muzan lehan teq mat aqez haiqta na gamuk tibilaqyaq. Gamuk bilaqsa on mataw ahol waqad in gihol turuh nemsa bilaq yaqay, Kwaziqmo nagah araq kazaqta Isrel-ib a hi gwahtimta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Haqsa teq ta Farisi bilaq yaqay, In bugaw meqinta gigo danmebta na ago zaway amalib bugaw meqinta gimuzaqta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ari Yesus uliq saw bunmo tilehad luwyaq. Luwad in mataw gigo bit humab wolaytab gwahtiqeq suleq negad teq in God ago maror og kab gwahtimta na agamukan tigibilenyaq. In gamuk dimun diqta na gibilenad teq in mataw gigo moq teq gihol asor meqniyta na bunmo giwastitaysa in gihol tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sa Yesus on mataw dauh biyahta na gibiyad in ginan anad timeqniy. Na ezaqgo on mataw na meqin diq osad in gimo gihol ulumsihgo biyab a hi iy yaqayta na ago iyan. Mataw na bilaqne sipsip ginamren haiqta os nog iy yaqayta. ");
INSERT INTO mlp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nazaq iyan Yesus in ago disaipel gibilan, Kabiyab didaq kabemmo tizilimim giqusaq ham. Teq kabibiy mataw kabemmo diq haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nazaq iyan ne kabiy anamren inaq gamuk emad bulonsa in kabibiy mataw kabemmo giqemid boleq in ago didaq na giwaq ugiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ari Yesus in ago disaipel 12 na gibilenan agerab tuboliy. Bolan in ahol abinib bugaw meqinta gimuzgo azawayin tinag. Negad in moq bunmo wastitaygo azawayin teq mataw gihol asor meqniyta na bunmo giwastitaygo azawayin tinagmo. ");
INSERT INTO mlp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Teq Aposel 12 na ginan kazaq: Saimon, in anan araq Pita haqayta teq Saimon amikqan Andru teq Sebediy atatniz giger Jems ama Jon inaq teq Filip teq Bartolomyu teq Tomas teq Matyu mat takis waqyaqta na teq Alfiyus atatin Jems teq Tadiyus teq Saimon mat Rom nenaq bab emyaqta amatin na teq Judas uliq Kariyot-ibta na. Mat naqmo in Yesus waqim bab gibenab amta. ");
INSERT INTO mlp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ari Yesus in mataw 12 na giqeman lehsa in gibilan, Ne on mataw en ta asor Juda a haiqta nagan gigo hib hi lehiy ham. Ad ne Samariya gigo uliq araqab le hi gwahtiqiymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ne Isrel on mataw gimomo gigo hib lehiy ham. Mataw na in bilaqne sipsip nabag haresmo le luwayta nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ne leheq luwad gamuk dimunta kazaq gibileniy ham. God ago maror bolim sinsin tiqiy haqad ne gibileniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ad ne on mataw moqayta na giwastitayid dimniyiy ham. Mataw tumoqiyta na ne giwazid ta eraqiy ham. Ad mataw gigo moq lepra inaqta na ne giwastitayid in gihol dimniyan ham. Ya zaway negta na ne samanmo waqiy ham. Ne zayim a hi waqiyta ham. Nazaq iyan ne on mataw samanmo tigilumsih daqaymo ham. Gilumsihad ne amenin waqgo hi bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ad ne mani gol teq mani silva teq mani kapa-ta araq waqeq ad hi lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Teq ne ziy araq es siheneq danib a lehgo hi waqiymo ham. Tubusan amulik giholib usaqta naqmo ne a lehad araqmo ta hi waqiy ham. Ne gigo gisendugan gisenab hi emiy ham. Ad ne katek wazeq ad hi lehiymo ham. Na ezaqgo ne mataw gimen kabiy samanmo a hi em daqayta ham. Ne yaqgo kabiy emsa mataw didaq nagah tineg daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ari ne leheq uliq araqab gwahtiqeq nab ne on mataw gibiy kemiy ham. Uliq nab nog in mat dimunta teq titnonta na ne ahol waqeq teq ne mat naqmo inaq oseq le ne uliq na tuhulos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ne bit aqez araqab loqeq on mataw nabta gibilen waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","In on mataw dimdimunta iyid teq ne gigem dimunta in gigo hib tilehdaq ham. Ari in dimunta a haiq iyid ne gigem dimunta negiyta na in ne gigo hib muleqeq ta boldaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bit nab mat araq ne giwazinad nenaq a hi osid teq ne bit na hulosad gisen aqogin wolhamid nab woqan ham. Ad nazaqmo uliq araqab on mataw ne gigo gamuk a hi huritid ne uliq na hulosad gisen aqogin wolhamid uliq nab woqanmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya ne helmo gibilenaiq ham. Abeb God hazizir ayahta emdaqta nab uliq giger Sodom teq Gomora afaqan waq daqayta nazaq nog uliq na a hi waq daqay ham. Uliq ne gibaymuz daqayta na in uliq giger na giquriyameq afaqan ayah diqta tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ne huritiy ham. Ya ne giqeman ne bilaqne sipsip gaun kwasikta gilikmanib leh nog iyay ham. Nazaq iyan nagah ahulinaqta anad em hasim daq emaqta nazaqmo ne gihol waz naqmo hiqiyiy ham. Ad ah muluk kiskismo luwaqta nazaqmo ne luwiymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ne mataw ginan gihol waz naqmo hiqiyiy ham. In teq ne giwazeq kaunsel gibenab giqem daqay ham. Ad in gigo bit humab wolaytab ne giwazeq ginol titay daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ne ya inan helmo haqad imuzad luwayta na ago in ne giwazeq in gigo king teq in gigo gavman aseseqta gigo hib ne giqad tileh daqay ham. Giqad lehid teq ne nagah gimeb ahol waqiyta na awagamun gibilensa mataw aseseqta teq on mataw en ta asor Juda a haiqta nagan in tuhurit daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mataw na ne giwazeq giqad mataw aseseqta gimeb lehid ne hi rabiy ham. Ad ne naga gamukin bilaq daqayta na ago ginadnad hi emiymo ham. Kam nabmo teq God in ne naga gamukin bilaq daqayta na tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nazaq iyan negmo diq gamuk na a hi bilaq daqay ham. Haiqgam ham. Ne Gimam ago Bugaw Dimunta naqmo in gamuk emid ne giqezab gwahtiqdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kam nab teq mataw in gimaqbaban giwaqeq bab gibenab giqemid in ginol emid tumoq daqay ham. Sa gimaman in nazaqmo gigo onmin giwazeq bab gibenab giqem daqaymo ham. Teq onmin in nazaqmo ginenmaman gihar negad bab gibenab giqemid in ginol emid tumoq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ya ihol abin ne giholib usaqta na ago on mataw bunmo gigem meqinta ne neg daqay ham. Ari mat aw nog in zaway diq iyeq ossa le in gigo kam abebtanta iydaqta nab teq God in gilumsiheq ta giwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Teq uliq araqab on mataw eraqeq ne gimeqin tonsa ne tukeq uliq ta araqab lehiy ham. Ya helmo ne gibilenaiq ham. Ne Isrel gigo uliq a hi wolnet bugsa Mat Atatin tuboldaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ne ginad emiy ham. Disaipel araq in ago tisa uriyameq danmeb a hi lehdaq ham. Sa kabibiy mat in ago ayahta a hi itiyondaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Disaipel na in ago tisa nogmo iyid na in dimunmo ham. Teq kabibiy mat na in ago mat ayah nogmo iyid na in dimunmo tiqiydaqmo ham. Nazaq iyan mataw bit anamren bilawunad anan Belsebul haqeq in nazaqmo bit anamren na ago asenlul ginan meqin diq tibilaq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nagah bunmo mataw giqisihan usaqta na abeb teq God hasid mataw bunmo ahol tuwaq daqay ham. Ad nagah bunmo mataw gikasnaknib usaqta na abeb teq God emid ulalab tugwahtiqdaq ham. Nazaq iyan ne yaqgo gamuk mataw gibilengo hi rabiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ya romriqab gamuk gibilenaiqta na ne saw anuwanibmo mataw gibileniy ham. Ad ne gamuk kiskismo gidekib huritayta na ne bit ahuqunib gwale turad teq ne dedibmo lileyeq mataw gibileniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mataw ne gisanmo wol em daqayta ham. Ari in ne giwitan wol emgo in gigo zaway haiqta ham. Nazaq iyan ne mataw hi girabuniy ham. Haiq ham. Mat araq ne rabun daqayta nawa osaq ham. In mataw gisan teq giwitan inaqmo gihunegan saw faq oyad a hi miyaqtab wolehim timeqniy hasayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mataw mani asit diqmo hulosim ah amikmikta giger gizayayta ham. Teq ah amik diqta nagan giholib daq araq gwahtiqsa ne Gimam Iyah tuhuritaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ad God ne gibiy kemad ne gifaqnib giqensan na in ginulinim ganim diq usaqta na in tuhurit bugta ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nazaq iyan ne hi rabiy ham. Ne ah amikmikta na nog a haiq ham. Ne ah amikmikta na ayahmo giquriyamiyta ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ari mat aw nog in mataw gimeb bilaqdaq, Ya Yesus-mo ago matta iyim osaiqta haqdaqta na ya nazaqmo ya imam Heven-ib osaqta na ameb mataw na ginan bilaqdaiq, In yaqgota tihaqdaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ad mat aw nog in on mataw girabunad gimeb gileh yagid ya nazaqmo ya imam Heven-ib osaqta na ameb mataw na gileh tinegdaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ne luweq ginad em daqay, Ya og kab on mataw bunmo giqemid zib alowab osgo haqad ya bolta haq daqay ham. Haiqgam ham. Ya bab emid gwahtiqgo haqad bolta ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na in kazaq ham. Mat araq ya inan helmo haqsa in amam gileh yagdaq ham. In giger nazaq emad, Mat na amam inaq an gihar ug daqay ham. Ad nazaqmo amun awta anen inaq an gihar ug daqay ham. Sa aw in aduw anen inaq an gihar ug daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mat asenlulmo diq eraqeq mat na bab ug daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ari mat in anenmaman ginan anad bilaqsa teq in ya inan anad a hi diq bilaqaqta, mat na in yaqgo disaipel iyeq osgo dimun a hi iydaq ham. Ad mat in atatin o in amiy anan anad bilaqsa teq in ya inan anad a hi diq bilaqaqta, mat na in yaqgo disaipel a hi iydaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Teq mat in ago kruse waqim abetarib emim ya imuzim a hi bolaqta, mat na in yaqgo disaipel iyeq osgo dimun a haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na ezaqgo mat inmo ahol anadin emdaqta na in nabag tihiqiydaq ham. Ari mat yaqgo kabiy emad ahol nog hulosdaqta na in dimunmo kuluwa-kuluwmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ari on mataw ne giwazinad in bilaqne ya iwazinayta nog tiqiyaymo ham. Ad in ya iwazinad in mat ya iqeman bolta na tuwazinaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mat aw nog in God ago nantut araq bolsa ahol waq hasad wazinayta na, on mataw na in God ago nantut naw waqayta nazaq in tuwaq daqaymo ham. Ad mat aw nog in mat araq titnonta bolsa ahol waq hasad wazinayta na, on mataw na in mataw titnonta bunmo naw waq daqayta nazaq in tuwaq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ad mat aw nog in yaqgo disaipel gibin haiqta kagan gigo araq ahol waq hasad anan Yesus ago disaipel haqad yuw soqoreq ugid uluwdaqta na, ya ne helmo gibilenaiq ham. On mataw na God abenab naw dimunta tuwaq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ari Yesus in ago disaipel 12 na suleq negim tihiqiyan teq in uliq na hulosim saw Galiliy-ib uliq-uliqgo lehad tiluwyaq. Luwad in God ago gamuk on mataw tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sa Jon irquran osad in Krais kabiy emaqta na abin tuhurit. Huritim in ago disaipel asor giqeman Yesus ago hib tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Lehim in Yesus tisusumun ugiy, Ni i nibaq tunim osta naqmo amatin ni bol o haiq mat ta araq teq abeb boldaqta i baq tunam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Haqan Yesus in gigo gamuk amenin emim bilam, Ko gibiyiy ham. Mataw gime haiqta saw ahol tuwaqay ham. Mataw gisen meqinta tiloq gelay ham. Mataw gigo moq lepra inaqta gisanib ginumlan usta na tihiqiyaq ham. Ad mataw gidek haiqta gamuk tuhuritay ham. Teq mataw tumoqiyta kayeq iyim ta eraqay ham. Mataw ginaghan haiqta God ago gamuk dimunta tuwaqay ham. Ne muleqeq leheq nagah ne gimeb kawa ahol tuwaqiyta ka teq gamuk kawa ne tuhuritiyta ka bunmo Jon buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mat ya ibiyad anadnad a hi emad teq in ya inan helmo diq haqaqta, mat na tidimniyim osaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","8","Ari Jon ago disaipel muleqim tilehsa Yesus in on mataw biyahta nab turiyta na Jon anan gibilenim bilam, Kwaziqmo ne nog diq ahol waqnan saw amatawun haiqtab lehiy? ham. Ne mat araq bilaqne tuqir tim retsa ahol wolad ahulan iysa ne ahol waqnan lehiy ye? ham. Teq ne nog diq ahol waqnan saw nab lehiy? ham. Ne mat araq tubusan dimunta muturta welim tursa ahol waqnan lehiy ye? ham. Mataw tubusan dimunta muturta welayta na in king gigo bit aseseqtab osayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ne ya ibileniy ham. Ne nog diq ahol waqnan lehiy? ham. Ne God ago nantut araq ahol waqnan lehiy ye? ham. Helmo ham. Mat na in God ago nantut araq ham. Teq mat nawa na in God ago nantut kwaziqmo osiyta na bunmo giquriyamta ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mat naqmo God ago marib ananin mar tonan usaqta ham. Gamuk na bilam, Ahol waqiy ham, ya teq mat araq emid in yaqgo gamuk ad danmeb lehdaq haqad in bilam ham. Leheq in ninmen dan tuwastitaydaq haqad in bilam ham. Wastitayid teq ni lehdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ya helmo ne gibilenaiq ham. Jon mataw huz negyaqta na in mataw og kab gwahtiqiyta na bunmo giquriyamim in abin ayah diqta ham. Ta teq mat aw nog God ago maror aduganib gibin amik diq usaqta na in Jon tuquriyamiyta ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","God ago nantut kwaziqta na bunmo teq God ago maror Moses mar tonta na in nagah abeb teq gwahtiqdaqta na ago bilaqan ussa bo Jon ago kamubmo iy ham. An Jon mataw huz negyaqta na ago akamnib iyim bo muranmo God ago maror og kab gwahtiqim awaz diq meqniyim lehaqta ham. Sa mataw asor in giwaz diq meqniyim maror na geg ugad in ginadibmo wasihnan tonayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ari ne yaqgo gamuk ka huritnan iysun ne huritiy ham. God ago gamuk bilam, Elaija bolid teq Krais boldaq haqad in bilam ham. Teq ya ne gibilenaiq ham. Elaija boldaq hamta na in Jon-mo anan bilamta ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mat aw nog in gidek inaq iyeq teq in gamuk ka huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ya on mataw kam kabta gigo daq anan bilaqnan teq ya gamuk awowun ezaq diqta amalib bilaqdaiq? ham. In bilaqne onmin maket-ib an bulonad osayta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","In bilaqay, I ne gimen kadug ulamsa ne ginad dimniysa a hi doray haqayta ham. Teq i gaq wazsa ne ginad meqniysa a hi gaqay haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ari Jon bolim didaq amo amo a hi neqad wain ayun a hi uluwyaqta ham. Sa ne in anan bilaq yaqay, Bugaw meqinta aholib usaq haq yaqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ta teq Mat Atatin bolim didaq neqad wain uluwsa ne bilaqay, Mat ko meqin haqayta ham. In didaq kabemmo neqad wain ayun ayahmo uluwaqta amatin haqayta ham. In mataw gibin meqinta takis waqayta na teq mataw daq meqinta emayta na giyowmo diq haqayta ham. O tob iyan ham. Abeb ya Jon inaq i gigo kabiy anon tiqemsa teq i giger ginad em hasim daq emta na ulal tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ari Yesus uliq kagan gigo hib daq azawayin inaqta kabemmo amta ka tiginadyaq. Na ezaqgo in daq azawayin inaqta emsa on mataw uliq nagabta ginad a hi buliyiyta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ginadad in kazaq bilam, Uliq Korasin teq uliq Betsaida ham ne teq timeqniy daqay ham. Kwaziqmo mat araq leheq daq azawayin inaq ya ne gigo hib emta nazaq in uliq giger Tair-ib teq Saidon-ib emid on mataw na ginad tubuliy nagiy ham. Ginad buliyeq in gigo daq teq ginad meqinta gileh ugad in tubusan asorqan abiyornaqta weleq butbut huz nagiy ham. Teq ne yaqgo daq azawayin inaqta na ahol waqim ne ginad buliyim gigo daq meqinta gileh a hi ugiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nazaq iyan ya ne gibilenaiq ham. Abeb God hazizir ayahta emdaqta nab Tair teq Saidon afaqan waq daqayta nazaq nog ne a hi waq daqay ham. Ne in giquriyameq afaqan ayah diqta tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Teq uliq Kapaneam ham ne gibin iluwid Heven-ib gwalehdaq e? ham. Haiqgam ham. In ne gihunegid ne mataw tumoqiyta gigo sawab tuwoleh daqay ham. Na ezaqgo kwaziqmo mat araq leheq ya ne gigo hib daq azawayin inaq emta nazaq in uliq Sodom-ub emid uliq na og kab a hi hiqiyid i muran ahol waq nagta ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nazaq iyan ya ne gibilenaiq ham. Abeb God hazizir ayahta emdaqta nab uliq Sodom afaqan waq daqayta nazaq nog ne a hi waq daqay ham. Ne in giquriyameq afaqan ayah diqta tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ari kam nab Yesus kazaq bilam, O ya imam ham, Heven-ib teq og kab inaqmo ni Iyahta iyim osaqta ham. Ni mataw ginad awaz meqinta na teq mataw gimaqbel inaq iyim igmo ag haqad osayta na ni yaqgo kabiy alulin a hi giqisihunta ham. Haiq ham. Mataw gihol wazan woqsa in onmin gibin haiqta os nog iyayta naqmo ni yaqgo kabiy alulin tigiqisihunta ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ya imam ham ni ninad nazaqmo usan ni tiqam ham. Nazaq iyan ya esey nigaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Haqad Yesus ta bilam, Ya imam in ago kabiy bunmo ya ibenab tiqam ham. Mat araq diq in yaqgo a hi hurit ham. Ya imam amomo in yaqgo huritta ham. Teq mat araq ya imam ago a hi huritmo ham. Ya in atatin iyim ya imomo in ago huritta ham. Ad on mataw ya inad bilaqsa imam giqisihunaiqta naqmo in ya imam ago huritaytamo ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ne on mataw kabiy awaz meqinta emad afaqan sorayta na ne bunmo yaqgo hib boliy ham. Bolid ya giqemid ne ginamur tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ne boleq yaqgo kabiy soriy ham. Ad ne yaqgo daq ahol waqad nazaqmo ne emiy ham. Ya ihol wazan woqsa ya ibin a hi iluwaiqta ham. Ne nazaqmo toneq teq ne ginamur emad gihol sinamolsa tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na ezaqgo ya kabiy negdaiqta na in awaz meqin diq a haiq ham. Ad ne yaqgo afaqan sor daqayta na in afaqan diq a haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ari Juda gigo lotu akaman araqab Yesus ago disaipel nenaq kabiy araq wit leyiyta aduganib gwahtiqim tileh yaqay. Lehad ago disaipel gigem moqsa in wit anagin asor guraqim tineq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Neqsa Farisi asor gibiyad in Yesus buloniy, Ni ko gibiy haqiy. Ningo disaipel in lotu akaman ago gunun itiyonim kabiyab wit tuguraqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Haqan Yesus gibilan, Nabag ne Devit ago dauh nenaq gigem moqsa Devit daq amta na awagamun ne ahol a hi waqiy-ya ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit agemnan moqad le God ago bit aduganib gwahtiqim in gunun itiyonim God ameb bret eman osta na tinam ham. Helmo, Devit bret tawonta na neqdaqta abin haiqta ham. Sa in ayogniz na in bret na neqgo gibin haiqtamo ham. Mataw tamaz emayta naqmo gimomo bret na neqayta ham. Ta teq Devit ayogniz nenaq gigem moq titaysa neqim in daq meqinta a hi emiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Teq God ago maror Moses mar tonta na aduganib gamuk araq usaqta ka ne ahol a hi waqay ye? ham. Gamuk na bilam, Mataw tamaz emayta na in Juda gigo lotu akamnib Tempel-ib kabiy emad in lotu akaman ago gunun na itiyonayta haqad in bilam ham. Ta teq in God ameb gihol a hi meqin tonayta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ya ne gibilenaiq ham. Nagah araq Tempel uriyamta in kawa ne nenaq osaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Teq God ago gamukib nan ta araqmo usaq ham. Gamuk na bilam, Ne yaqmen tamaz emad karuw anat urotayta na ya hulosaiq haqad in bilam ham. Ne mataw ginan ginad meqniydaqta naqmo ya ahol waqnan inad bilaqaqta haqad in bilam ham. Ne gamuk na adugan hurit kemeq teq ne mataw giholib daq meqin haiqta ka ginan meqin a hi bilaq nagiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na ezaqgo Mat Atatin in lotu akaman anamrenmo diq iyim inmo mataw kam nab ezaq luw os daqayta na ago tigibilendaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ari Yesus saw na hulosim uliq ta araqab lehim in mataw na gigo bit humab wolaytab tugwahtim. ");
INSERT INTO mlp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sa mat araq aben akogan anedan mayim aditinmo usaqta in nab osmo. Ossa Farisi in Yesus ulum waqnan haqad tuboliymo. Bolim in Yesus kat ugid nan araq ginad a hi usaqta bilaqid i tuwazam haqad in Yesus kazaq susumun ugiy, I gigo lotu akamnib i mat moqaqta wastitayid dimniydaq o haiq? haqiy. I Juda gigo maror ezaq bilamta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Haqan Yesus gibilan, Ta ne gilikmanib mat araq ago sipsip lotu akamnib yayib woqid mat na wazeq hureqid a hi gwaldaq e? ham. Haiqgam ham. In hureqid tugwaldaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Teq mat in sipsip nog a haiq ham. Mat in sipsip ayahmo uriyamta ham. Nazaq iyan i lotu akamnib mataw gidimun tonamta na ago agununin haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Haqad in mat na bulon, Niben itiwun ham. Haqan mat na aben meqinta na itiwunan in aben dimunta na nogmo tiqiy. ");
INSERT INTO mlp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","An teq Farisi na gigem meqniysa asanib gwahtiqim humab emim in ezaq toneq Yesus wol emid moqdaqta na agamukan tibilaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sa Yesus in Farisi ginad na tuhuritim in uliq na hulosadmo tilah. Lehsa on mataw dauh kabemmo muzim inaq lehsa Yesus in gigo asor gigo moq inaqta na bunmo giwastitayan gihol tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Gihol dimniysa Yesus atoranmo gibilenyaq, Ne ya ihol abin ka ulalab hi bilaqiy haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","18","Yesus daq nazaq emad in God ago nantut Aisaya aqezab gamuk gwahtimta na tuwol net bug. Gamuk nab God bilam, Ka yaqgo kabibiy mat ham. Yaqmo in anan bilaqan osaqta ham. Ya in anan inad bilaqsa igem tidimniyaq ham. Teq ya igo Bugaw Dimunta emid in aholib tilehdaqta ham. Lehid teq yaqgo kabibiy mat na in yaqgo daq titnonta agamukan on mataw en ta asor Juda a haiqta nagan tigibilendaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","In mataw nenaq an a hi mugdaqta ham. Ad in uliq gemab turad gamuk atoranmo a hi bilaqdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yaqgo kabibiy mat na amidemqanmo luwdaqta ham. Luwad in tuqir araq asitmo talquweq tursa ahol waqad a hi orqaydaq ham. Ad in lam araq ago faq miynan tonsa ahol waqad in a hi wolmiydaq ham. In ago daq nazaq amidemqan diqmo emad luwsa teq on mataw uliq saw bunmo God ago daq titnontab tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ad teq on mataw en ta asor Juda a haiqta nagan in mat naqmo anan helmo haqad in God teq gilumsihdaqta na akaman baq tuneq tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ari kam nab on mataw in mat araq aholib bugaw meqinta usaqta waqim Yesus ago hib a boliy. Mat na ame haiqta teq in gamuk a hi emyaqta. A bolanmo Yesus in mat na wastitayan in gamuk bilaqad teq in saw ahol tuwaqyaq. ");
INSERT INTO mlp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sa on mataw dauh biyahmo nab osiyta na in gihol turuh nemsa bilaqiy, Luweq mat ka in Devit atatin i baq tunim osauqta naqmo iydaq daqagya? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Haqsa ta Farisi in mataw giqez nazaq huritim bilaqiy, Haiq haqiy. Mat na in bugaw meqinta gigo danmebta Belsebul ago zaway amalib bugaw meqinta gimuzaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Haqsa Yesus mataw na ginad hurit kemim gibilan, Kantri araq ago on mataw gihol husereq an gihar ugad an wolad oseq in tihiqiy bug daqay ham. Teq uliq araqab o bit araqab on mataw gihol husereq an gihar ugad an wolad osad in zaway iyeq a hi tur daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ad nazaqmo Satan inmo ago kabibiy mataw ginaq an gihar ugad gimuzid in gihol huserid giger tiqiy daqaymo ham. In nazaq toneq Satan ago zaway hiqiysa ago kabiy tuwoqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ari ya Belsebul ago zaway amalib bugaw meqinta gimuzid ta ne gigo gisenlul asor na in nog diq ago zaway amalib bugaw meqinta gimuzayta? ham. Nazaq iyan ne ya ibilawunayta na negmo gigo gisenlul naqmo in tuqulum kem daqay ham. Ulum kemeq in bilaq daqay, Gamuk nawa ne bilaqayta na ne katiyay haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ari God ago Bugaw Dimunta ilumsihsa ya bugaw meqinta gimuzsa teq ne ginad emiy ham. God ago maror ne gilikmanib tubol haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mat araq ezaq toneq teq in mat awaz meqinta ago bit aduganib gwahtiqeq ago nagah ginuwdaq? ham. In mat awaz meqinta na abensen irqureq teq in mat na ago bit aduganib gwahtiqeq ago nagah tiginuwdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ne ginad emiy ham. On mataw ya inaq kabiy a hi emayta na in ya ibabun ham. Teq on mataw ya inaq yaqgo dauh a hi girom tonayta na in yaqgo mataw gimuzan hares-haresmo lehayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nazaq iyan ya ne gibilenaiq ham. God in on mataw gigo daq meqinta teq in bilawunayta na bunmo tigiwalem bugdaq ham. Ari in God ago Bugaw Dimunta bilawunid God in gigo daq meqinta na a hi walemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Teq on mataw Mat Atatin bilawunid God in gigo daq meqinta na tuwalemdaq ham. Ari on mataw God ago Bugaw Dimunta anan meqinta haqid God in gigo daq meqinta na a hi walemdaq ham. Muran kam kab teq abeb kam muturta teq boldaqta nab daq meqinta na in giholib tuqus tutdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ne gime haiq e? ham. Ne ay alowan tonid in anon dimunta emdaqta ham. Teq ne ay meqin tonid in anon meqinmo emdaqta ham. Mataw ay anon ahol waq kemim teq in ay ezaqta na ago ginad em hasay ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mataw meqinta ne bilaqne nagah ahulinaqta ginaqmugnaqta nog ham. Ne mataw meqinta iyim iyan ezaq teq ne giqezab gamuk dimunta gwahtiqdaq? ham. Nagah mat agemab ayahmo usaqta naqmo in aqezab gwahtiqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mat dimunta agemab anad dimunta kabemmo ussa in daq dimunta emaqta ham. Sa mat meqinta agemab anad meqinta kabemmo ussa in daq meqinta emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ya ne gibilenaiq ham. Abeb God hazizir ayahta emdaqta nab teq on mataw bunmo in ginad ezaq emad gamuk hares alulin haiqta bilaqiyta na in tibilaq kem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Na ezaqgo ningo gamuk naqmo in ni nilum kemdaqta ham. Ni niqezab gamuk dimunta gwahtiqsa abeb God in ni ninan mat dimunta haqdaq ham. Ad nazaqmo ni niqezab gamuk meqinta gwahtiqsa abeb God in ni ninan mat meqinta haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ari mataw Moses ago gunun hurit kemiyta na asor teq Farisi asor in Yesus buloniy, Tisa haqiy ni daq araq azawayin inaqta emsa i ahol waquq haqiy. Ahol waqeq teq i bilaqam, Helmo ni God-mo ago kabiy emaqta haqam haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Haqan Yesus amenin emim gibilan, Ne on mataw muran kam kabta ham, ne on mataw meqinta God gileh ugayta ham. Ne daq azawayin inaqta naqmo ahol waqnan bilaqayta ham. Teq God in daq araq azawayin inaq a hi em negdaq ham. God ago nantut Jona aholib daq gwahtimta naqmo ne ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona kam ezeqmanmo nabiq ayahta na agemab usta ham. An nazaqmo Mat Atatin kam ezeqmanmo og aduganib tuqusdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Abeb God hazizir ayahta emdaqta nab on mataw Niniwe-ibta na in mataw muran kam kabta nenaq eraqeq God ameb turad teq Niniwe mataw na in mataw kam kabta gigo daq meqinta emid ulal tiqiydaq ham. Na ezaqgo on mataw Niniwe-ibta na in Jona ago gamuk huritim in ginad buliyim gigo daq meqinta gileh ugiy ham. Teq ne ahol waqiy ham. Mat araq Jona uriyamta na in kawa ne gilikmanib osaq ham. Ta teq ne in ago gamuk huritim ginad a hi buliyayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ad God hazizir ayahta emdaqta nab teq aw marorta kwaziqmo saw araq pesantab osta na in on mataw muran kam kabta nenaq eraqeq God ameb turad teq aw na in mataw kam kabta gigo daq meqinta emid ulal tiqiydaqmo ham. Na ezaqgo aw marorta na in uliq pesan diqtab osad Solomon abin huritim in eraqim Solomon ago gamuk dimunta huritnan haqad ago hib tilah ham. Teq ne ahol waqiy ham. Mat araq Solomon uriyamta na in kawa ne gilikmanib osaq ham. Ta teq ne in ago gamuk dimunta huritnan gituw hiqiyayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Haqad Yesus bilam, Bugaw meqinta araq mat hulos ugim gwahtiqim haresmo saw ayuwun haiqtab lehim luwaqta ham. Luwad in ban araq anamur emad osdaqta na nagunaqta ham. Teq haiq ham. In ban araq nazaqta ahol a hi waqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","In ban araq ahol a hi waqim teq in ahol bulonim bilaqaq, Bit kwaziqmo ya osta nab ya muleqeq ta lehdaiq haqaqta ham. Haqad in bit nab muleqim ta lehim bit na samanmo ussa asawun wolrironim anaghan bunmo wastitayim abanab eman ussa in ahol waqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ahol waqim teq in lehim bugaw meqin diqta 7 nazaq in daq meqinta emgo uriyamiyta na gililewunim giwaqim nenaq ta bolim in bit nab gwahtiqim osayta ham. Mebmebmo bugaw amulikmo mat na aholib ussa in ahol meqin dimun nog osyaqta ham. Ari muran teq bugaw 8 nazaq bolim mat na aholib ussa in ahol timeqniy hasim osaqta ham. Ad daq nazaqmo on mataw meqinta kam kabta ka giholib tugwahtiqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ari Yesus on mataw biyahta na gibilenad ossamo in anen teq amagniz in inaq gamuk bilaqnan haqad bolim asanib tituriy.  ");
INSERT INTO mlp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tursa mat araq Yesus bulon, Ko gibiy ham. Ni ninen teq ni nimagniz bolim in ni ninaq gamuk bilaqnan haqad kowa asanib turay ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Haqan Yesus in mat na ago gamuk amenin emim bilam, Ya inen teq ya imagniz gingan diq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Haqad in aben ago disaipel gigo hib itiyad bilam, Ka gibiyiy ham. Ya inen teq ya imagniz kawa osay ham. ");
INSERT INTO mlp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mat aw nog in ya imam Heven-ib osaqta na anad muzad ago kabiy emayta naqmo in ya ima teq in ya ihiy teq in ya inen ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ari kam nabmo Yesus bit hulosim asanib tugwahtim. Gwahtiqim in lehim yuw-kurorqan Galiliy aqurumnib tuqos. ");
INSERT INTO mlp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ossa on mataw dauh kabemmo bolim Yesus agerabmo diq loqsa iyan Yesus giban emim muy araqab gwalim tuqos. Ossa on mataw na yuw aqurumnib turiy. ");
INSERT INTO mlp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tursa Yesus suleq kabemmo negad gamuk amo amo tigibilenyaq. Ad in gibilan, Ne huritiy ham. Mat araq ago kabiyab wit anagin hunegnan tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","In lehim wit anagin hunegad luwsa asor danib woqan ah bolim tineqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sa wit anagin asor saw agigin inaqtab og asitmo usaqta nab wom ham. Woqim og ayah diq haiqgam iyan wit hidmo tugwal ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","An zeq gwalim oysa wit na aninin haiqgam iyan in mayim tumom ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sa wit asor am asasuqin inaqta na aduganib wom ham. Woqan am asasuqin inaqta na gwalad isihan wit na abesbesan iy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Teq wit asor og dimuntab woqim anon tiqam ham. Asor anon kabemmo diq 100 nazaq giqam ham. Sa asor anon 60 nazaq giqam ham. Sa asor anon 30 nazaq giqam ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mat aw nog in gidek inaq iyeq teq in gamuk ka huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ari disaipel in Yesus ago hib bolim tisusumun ugiy, Ni ezaq haqad gamuk awowunmo amalib on mataw gibilenaqta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Haqan Yesus in gigo gamuk amenin emim gibilan, Negmo God ago maror aduganib osayta ham. Nazaq iyan God ago maror abe alulin ulilemim usaqta na in negmo tigiqisihunaq ham. Ari on mataw asan banta na in a hi giqisihunaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Na ezaqgo in on mataw gigo nagah inaqta na bunmo nagah asor a ta negid in gigo nagah kabemmo diq tiqiydaq ham. Teq in mataw ginaghan haiqta na gibenab nagah asitmo wazayta na walem bugdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Daq naqmo ago ya gamuk awowunmo bilaqaiqta ham. Ya mataw asanibta na gamuk awowunibmo gibilensa in gime saw waqad teq in nagah araq ahol a hi waqayta ham. In gidek emad teq in gamuk a hi huritad ginad a hi em hasayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mataw na daq nazaq emad in God ago nantut Aisaya gamuk bilamta na tuwol net bugay ham. Aisaya bilam, Ne gamuk huritad teq ne ginad a hi em has daqay haqad in bilam ham. Ne gime saw waqad teq ne nagah araq ahol a hi waq daqay haqad in bilam ham. Na ezaqgo on mataw ka gigem soqotim usaqta haqad in bilam ham. Sa in gideksan ituqim usaqtamo haqad in bilam ham. Mataw ka gime miyim osayta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","God in nazaq giqeman luweq in gime nagah ahol waqad teq in gidek nan huritad in ginad em has nagiy haqad in bilam ham. Ginad em hasad gigem buliyeq in God ago hib ta bolid God giwastitayid tidimniy nagiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Teq negmo ginad dimniyan ham. Ne gime nagah ahol tuwaqayta ham. Ad ne gidek gamuk tuhuritayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ya helmo ne gibilenaiq ham. Kwaziqmo God ago nantut kabemmo teq mataw dimdimunta kabemmo in nagah muran kawa ne ahol waqayta ka in ahol waqnan ginad diq bilaq yaqayta ham. Teq in moqim ahol a hi waqiyta ham. Ad gamuk kawa ne huritayta ka in huritnan ginad bilaq yaqaytamo ham. Teq in moqim a hi huritiyta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ari mat didaq anagin kabiyab hunagta ago gamuk awowun na alulin ne huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mat aw nog in God ago maror agamukan huritim ginad a hi em hasayta na in bilaqne wit anagin danib woqaqta na nog ham. God ago gamuk mataw na gigemab leyan ussa Satan hidmo bolim gamuk na gigemab ta walemaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Teq mat araq in wit anagin og agigin inaqtab woqaqta na nog ham. In God ago gamuk huritim in anad bilaqsa hidmo waqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Teq mat naqanta in bilaqne wit aninin haiqta nog ham. In God ago gamuk agemabmo diq a hi wazad in muzinad sisaqmo a hi luwaqta ham. Na ezaqgo in God ago gamuk muzinaqta na ago mataw in meqin tonad afaqan amo amo ugsa in hidmo God hulosaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Teq mat araq in wit anagin am asasuqin inaqta aduganib woqaqta na nog ham. Mat naqanta in God ago gamuk huritaqta ham. Teq in og ka ago nagah kabemmo anadin emsa mani-mo in kat ugad anad hureqaqta ham. Nagah nagan in God ago gamuk isihsa iyan gamuk na in mat na agemab anon a hi emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Teq mat araq in wit anagin og dimuntab woqaqta na nog ham. Mat naqanta in God ago gamuk huritim anad em hasaqta ham. Anad em hassa God ago gamuk in agemab anon emaqta ham. Mat araq agemab in anon kabemmo diq 100 nazaq giqemaqta ham. Sa mat araq agemab in anon 60 nazaq giqemaqta ham. Sa mat araq agemab in anon 30 nazaq giqemaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ari Yesus gamuk awowun araq ta gibilan. In bilam, God ago maror in bilaqne mat araq ago kabiyab wit anagin dimunta hunagta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Hunegan teq taromab mat na ago bab bolim bonbon anagin wit alikmanib hunegim lah ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","An abeb wit na gwalim anon tiqemsa nab teq kabibiy mataw in bonbon na wit inaq araqib tursa ahol tuwaq kemiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ad in lehim kabiy na anamren tubuloniy ham. Mat ayah haqiy i bilaw ni ningo kabiyab wit anagin dimunta hunag hawta haqiy ham. Teq ta ezaq tonim i lehim bonbon meqinta ko wit inaq tursa i ahol waw? haqad in bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","An kabiy anamren gibilan, Na i gibabun araq daq na am haqad in bilam ham. Haqan kabibiy mataw na susumuniy, I leheq bonbon ko titeqam e? haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Haqan in gibilan, Haiq ham. Luweq ne bonbon na titeqad ne wit inaqmo titeq daqay haqad in gibilan ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nab iyan ham. Sa garabmo gwalsa le didaq waqgo akaman iyan haqad in bilam ham. Didaq waqgo akamnib teq ya kabibiy mataw gibileneq bilaqdaiq, Ne bonbon meqinta ko titeqeq gituq toneq faqab em oygo humab emiy haqdaiq haqad in bilam ham. Ad wit dimunta na ne titeqeq yaqgo didaq abitnib nab humab emiy haqdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ari Yesus gamuk awowun araq ta bilam, God ago maror in bilaqne ay mastet anagin amik diqta amulikmo mat araq ago kabiyab layta na nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Didaq anagin bunmo gilikmanib mastet anagin in amik diqta ham. Teq in gwalim ayah iyim in kwasin-kwasan kabiyabta na bunmo giquriyamaqta ham. Giquriyamim in bilaqne ay diq gwal nog iyan ah bolim abenab giholyon rir emim osayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ad Yesus gamuk awowun araq kazaq ta bilam, God ago maror in bilaqne yis nogta ham. Aw araq yis na waqim mel deg ezeqman nazaq inaq buliyan yis ulilemim ussa mel na bunmo huhuw tinam ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ari Yesus in on mataw dauh bunmo gamuk awowunmo amalib gibilenyaqta. In gamuk bilaq sireqeq a hi gibilenyaq. Haiqgam. In gamuk awowunmo negyaqta. ");
INSERT INTO mlp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","In daq nazaq emad in God ago nantut araq gamuk bilamta na tuwol net bug. Gamuk na bilam, Ya ite akeq nagah God ulileman usta na anan ya gamuk awowunmo amalib tibilaqdaiq ham. Nagah na og ka mutur gwahtimta nab iyim bo muran kam kabmo in ulilemim usta ham. Ussa nagah na ago agamukan ya muran kam kabmo tibilaqdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ari Yesus on mataw gihulosim le bit araq aduganib tugwahtim. Gwahtiqan ago disaipel in agerab bolim buloniy, Ni teq gamuk awowun bonbon meqinta kabiyab gwalta na adugan ni i tigibilendaq e? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Haqan Yesus amenin emim kazaq gibilan, Mat wit anagin dimunta hunegaqta na in Mat Atatin ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Teq kabiy na in og ka ham. Wit anagin dimunta na in on mataw God ago maror aduganib osayta naqmo ham. Teq bonbon meqinta na in Satan ago on mataw ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ad bab bonbon meqinta kabiyab hunagta na in Satan ham. Teq didaq waqgo akaman na in og ka ago kam abebtanta ham. Ad kabibiy mataw na in God ago angelo ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mataw bonbon meqinta humab wolim faqab eman oyaq nazaqmo teq og ka ago kam abebtanta nab in tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kam nab Mat Atatin in ago angelo giqemid in og kab boleq God ago maror aduganib nagah meqinta mataw ginad hureqsa in ginad helta hulosnan tonayta na teq on mataw God ago gunun itiyonayta na bunmo tiginuw bug daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","In ginuweq a le hunegid faq ayahtab le tuwoq daqay ham. Woqeq osad teq in gaqad gite sisad tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kam nab on mataw dimdimunta na ulal iyeq in God ago maror aduganib zeq anuwan oy nog iyad tuqos daqay ham. Mat aw nog in gidek inaq iyeq teq in gamuk ka huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","God ago maror in bilaqne nagah araq dimun diqta og araqab ulileman usaqta nazaq nog ham. Mat araq og nab lehim nagah na ahol waqim teq in a ta ulilam ton ham. Ulilemim in anad dimniysa lehim ago nagah bunmo giwaqim a le gizayim amenin mani waqim teq in lehim og na zayan nagah dimunta ulilemim usaqta na inmo ago diqta tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Teq God ago maror in bilaqne mat mani akabiyan emaqta araq in kaliloy pokpok dimdimunta nagunad luwaqta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mat na pokpok nagunad luwim in araq dimun diqta ahol tuwam ham. Ahol waqim teq in lehim ago nagah bunmo giwaqim a le gizayim amenin mani waqim teq in lehim pokpok na aholyon tizay ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Teq God ago maror in bilaqne nabiq adobun kamisib hunegan wo ussa nabiq amo amo bolim dob nab woqiyta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nabiq kabemmo dobub woqan dob ate gwalan mataw hureqan bo dubub tugwal ham. Gwalan mataw na nabiq dimdimunta giwaqim degib giqemad nabiq meqmeqinta nag in gihunegiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ari og ka ago kam abebtanta in nazaqmo tugwahtiqdaqta ham. Angelo boleq mataw meqmeqinta mataw dimdimunta gilikmanib osayta na giluwiyeqmo tigiwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Giwaqeq giqad le faq ayahtab gihunegid le tuwoq daqay ham. Woqeq in faq nab osad teq in gaqad gite sisad tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Haqad Yesus in ago disaipel susumun negim gibilan, Ne gamuk ka adugan bunmo ginad tiqem hasiy ye? ham. Haqan in buloniy, Eqe haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Haqan Yesus gibilan, Mataw Moses ago gunun hurit kemiyta na asor in God ago maror agamukan muturta huritim muzinim in disaipel tiqiyiyta ham. Nazaq iyan mataw na in bilaqne bit araq ayahta anamreniz nog iyayta ham. Bit anamreniz na in gigo nagah kabemmo bit aduganib usaqta nab in nagah muturta teq kwaziqta inaqmo giwaqim asanib ad gwahtiqim mataw giqisihunayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ari Yesus gamuk awowun na bilaqim tihiqiyan in uliq na hulosim tilah. ");
INSERT INTO mlp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Lehim inmo ago uliq diq Nasaret-ib tugwahtim. Gwahtiqim in Juda gigo bit humab wolaytab lehim God ago gamuk asuleqin on mataw tigibilenyaq. Gibilensa in huritad gihol riten nog iy yaqay. Gihol riten nog iysa in bilaq yaqay, Mat ko ago anad awaz meqinta na teq in daq azawayin inaqta emaqta na in edob diq wam? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","In mat bit emaqta naqmo atatinta haq yaqay. In anen Mariya-mo haq yaqay. In amagniz Jems teq Josep teq Saimon teq Judas haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Teq in ahiyan bunmo kawa i nenaq osauq haq yaqay. Mat ko daq zawayta nagan edob diq wam? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","In nazaq haqad Yesus anan gigem timeqniy yaqay. Gigem meqniysa Yesus gibilan, God ago nantut abin uliq bunmo usaqta ham. Ari inmo ago uliqab teq in ago bitabmo diq in ahol abin haiqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ari on mataw na Yesus anan helmo a hi haqsa iyan in uliq nab daq azawayin inaqta kabemmo a hi am. ");
INSERT INTO mlp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Ari kam nab king Herot in on mataw Galiliy-ibta giwamuzim osad in Yesus kabiy daq emyaqta na ago abin tuhurit. Huritim in ago kabibiy mataw gibilan, Ko Jon mataw huz negyaqta naqmo ham. God in hodhodab wazan eraqan in aholib zaway ayahmo usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Na ezaqgo kwaziqmo Herot in ama Filip awe Herodiyas hureqim wam. Waqan Jon in Herot bulonyaq, Ni God ago gunun ayahta itiyonim aw na wamta haqyaq. In nazaq haqsa teq Herot bilaqan in ago mataw asor lehim Jon wazim tiqirquriy. ");
INSERT INTO mlp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Irquran ossa Herot in wol emgo anad emyaqta teq on mataw bunmo Jon anan God ago nantut araq haqsa iyan in wol emnan rabyaq. ");
INSERT INTO mlp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ari kam araqab Herot anen iqamta na akaman tugwahtim. An mataw asor bolim Herot inaq humab wolim didaq neqad osiy. Ossa Herot awe Herodiyas amiy bolim mataw na ginognib dorsa Herot in ahol waqad anad tibilam. ");
INSERT INTO mlp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Anad bilaqsa in amun aw na bulon, God ya ibiysa ya helmo diq bilaqaiq ham. Ni nagah araq ninad usaqta na anan ibilenid ya tinigdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Haqan amun aw na in anen Herodiyas anad huritnan tilah. Lehan anen anadta bulonan in ta bolim Herot tubulon, Ni Jon mataw huz negyaqta na anat uroteq afaqin degib emeq a bo ya yag ham. ");
INSERT INTO mlp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","In nazaq bilaqan king na afaqan tiqiy. Afaqan iyad teq in helmo ulilib hamta na anadin emad in mataw na gimeb amebay woqnan hulos. Nazaq iyan amun aw nagah anan bilamta na in em uggo tibilam. ");
INSERT INTO mlp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ad in nan eman lehan mataw giqirquran osayta na abitnib in Jon anat urot tayim afaqin tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Waqim in degib emim a bolim aw barasta na tuqugiy. Ugan in waqim anen ago hib ad tilah. ");
INSERT INTO mlp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","An abeb Jon ago disaipel huritim in bolim asan waqim a lehim tiyay toniy. Yay tonim teq in lehim Yesus tubuloniy. ");
INSERT INTO mlp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ari Jon wol emiyta na ago Yesus huritim in muyib gwalim saw na hulosim saw araq amatawun haiqtab tilah. Lehsa on mataw kabemmo huritim in gigo uliq hulosim in yuw aqurumun muzim gisenabmo Yesus muzim inaq tilehiymo. ");
INSERT INTO mlp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","An abeb Yesus bo tugwahtiqim in muy hulosad dubub gwalimmo ame le on mataw kabemmo gibiyad in ginan anad timeqniy. Anad meqniysa in gigo asor gigo moq inaq na giwastitayan gihol tidimniyiy. ");
INSERT INTO mlp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sa imisor zeq tuwolehsa Yesus ago disaipel bolim tubuloniy, Saw ka amatawun haiqta haqiy. Teq zeq tuwolehaqmo haqiy. Nazaq iyan ni on mataw giqemid in uliq sinsin usayta kogab lehad giholmen didaq zayeq neqiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Haqan Yesus bilam, Na nagaqgo in leh daqay? ham. Negmo didaq negid neqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Haqan in buloniy, I gigo didaq ka kabem a haiq haqiy. Bret abaynaginmo teq nabiq gigermo kawa usaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Haqan Yesus gibilan, Nagah nag ne giwaqeq yaqgo hib a boliy ham. ");
INSERT INTO mlp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Haqad in on mataw gibilenan in saw nab sisihunibmo tuqos woqiy. Os woqim ossa Yesus bret abaynagin na teq nabiq giger na waqim ame ulilib gwalsa in God esey ugim teq in bret na orqayim ago disaipel tinag. Negan disaipel waqim on mataw tinegiy. ");
INSERT INTO mlp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Negan in bunmo didaq na neqan tigiyunin bug. Giyuninan disaipel didaq abeyan hulosiyta na ginuwim kuram 12 nazaqmo gisihenan ate tugwal bug. ");
INSERT INTO mlp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ari mataw didaq neqiyta na ginulinqan kabemmo diq 5,000 nazaq. Ad in on teq onmin a hi ginuliniy. ");
INSERT INTO mlp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ari Yesus in ago disaipel giqeman muyib gwalim in ameb yuw-kurorqan Galiliy urotim aqurumun kozaq ban tilehiy. Lehsa inmo osim mataw dauh biyahta na giqeman giquliqab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Giqeman lehsa teq in amomo God inaq gamuk emnan haqad garahab tugwalah. In gwalehim ossa imisor diq tiqiyan in amomo garah nabmo tuqos. ");
INSERT INTO mlp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ossa muy pesanmo tiqiyan tim ayahmo eraqim muy anobun ban bolad in kamis wolsa eraqim muy tuqothasyaq. ");
INSERT INTO mlp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Othassa saw tihastitaynan tonsa tarom asor ussamo Yesus in ago disaipel gigerab yuw bayim tilah. ");
INSERT INTO mlp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lehsa disaipel in Yesus yuw bayim bolsa ahol waqadmo in ritenim an buloniy, Ko wit araqagya haqiy. Haqad in rabad tiqek ton yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ek tonsa Yesus hidmo gibilan, Ne giwaz meqniyiy ham. Ka yaqmo lehaiq ham. Ne hi rabiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Haqanmo Pita amenin emim bilam, Iyahta ham ka ninmo iyeq teq ni ya ibilenid ya nazaqmo yuw bayeq nigerab lehiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Haqan Yesus bulon, Ni bol ham. Haqan Pita muy hulosim yuw bayim Yesus agerab tilah. ");
INSERT INTO mlp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lehsa tim awaz meqin diq sibsa in tirabyaq. Rabad in yuw aduganib tuwolehyaq. Wolehadmo in lileyim bilam, Iyahta ni ya iwaz ham. ");
INSERT INTO mlp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Haqsamo hidmo Yesus aben emim Pita tuwaz. Wazad in bulon, Ni ninad helmo haqaqta na amik ham. Ezaq haqad ni ninad giger usaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Haqad in giger muyib gwalanmo tim timidam. ");
INSERT INTO mlp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mideman mataw muyib osiyta na in Yesus abin iluwad bilaq yaqay, Helmo ni God atatinmo diq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ari Yesus ago disaipel nenaq yuw-kurorqan Galiliy urotim lehim urum kozaq ban uliq Genesaret ago lan ezab tugwaliy. ");
INSERT INTO mlp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gwalan mataw saw nabta na in Yesus ahol waq hasim in uliq sinsin usayta nagab nan eman lehan mataw in giyogniz gigo moq inaqta na bunmo giqad Yesus ago hib tuboliy. ");
INSERT INTO mlp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bolim in ginad awaz meqin amalib Yesus bulon yaqay, Ni on mataw gigo moq inaq ka gihulosid in giben ningo tubusan adekmo waziy haq yaqay. Haqsa on mataw Yesus ago tubusan adek waz yaqayta na bunmo gihol tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Ari kam nabmo Farisi asor teq mataw Moses ago gunun hurit kemiyta na asor in Jerusalem hulosim Yesus ago hib tuboliy. Bolim in susumun ugim bilaqiy, Ezaq haqad ningo disaipel i gisesan gigo gunun itiyonim giben a hi suholimmo didaq neqayta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Haqan Yesus in gigo gamuk amenin emim gibilan, Ta ne ezaq haqad ne gisesan gigo gunun muzinad teq ne God ago gunun itiyonayta? ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God bilam, Ni ninen nimam giwazinad gilumsih haqad in bilam ham. Teq in bilam, Mat araq anen amam a hi giqudinad gamuk meqinta amalib gibilawunid ne wol emid moqan haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ta teq negmo kazaq bilaqayta ham. Mat araq in anen amam gibileneq bilaqdaq, Yaqgo nagah ne gilumsihgo usta na ya inad buliyim God abinib eman usaqta haqdaq haqad ne bilaqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mat na gamuk awaz meqinta nazaq bilaqeq teq in anen amam giwazinad a ta hi gilumsihdaqta haqad ne bilaqayta ham. Nazaq iyan ne God ago gamuk bayan woqim samanta ussa ne gisesan gigo hib gunun waqiyta naqmo ne wazan eraqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ne mataw gimileq meqin diqta ham. God ago nantut Aisaya in ne gilum kemim ne gigo daq na anan hel diqmo bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","In bilam, On mataw ka giqezabmo God abin iluwayta haqad in bilam ham. Teq in ginad gigem pesanmo God ago hib usaqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mataw na God abin samanta iluwayta haqad in bilam ham. In mataw og kabtaqmo gigo gunun anan bilaqay, God ago maror dimunta haqayta haqad in bilam ham. Ad in gunun naqmo mataw giqisihunayta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ari Yesus on mataw biyahta na gibilenan bolan in gibilan, Ne gamuk ka huriteq teq ginad em hasiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nagah bunmo mataw wazim giteb eman lehaqta na in mataw gihol eman God ameb anumlan a hi iyaqta ham. Haiq ham. Nagah mat aduganib usim bo aqezab gwahtiqaqta naqmo in mat ahol eman God ameb anumlan inaq iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Haqanmo disaipel in agerab loqim buloniy, Se haqiy ni Farisi gigo gamuk bayan woqsa in huritim gigem timeqniyaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Haqan Yesus bilam, Didaq ahokan bunmo ya imam Heven-ib osaqta a hi layta na in titeqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mataw na gihulosid luwiy ham. In gime haiqta ham. Gime hiqiysa in mataw gibilenay, Dan kawaqmo usaq haqayta ham. Bo kazaq lehiy haqayta ham. Teq mat ame haiqta in mat ta araq ame haiqtamo dan isihuneq a lehadmo in giger garabmo le yayib tuwoq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Haqan Pita bilam, Nagah mat eman ahol anumlan inaq iyaqta ago gamuk awowun na alulin ni i gibilen ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Haqan Yesus bilam, Ne kam gineh teq ginad em daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nagah mat ateb eman agemab wolehaqta na in abekoqib lehim le yayib wolehaqta ham. Na ne ginad a hi emay ye? ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ari nagah mat aqezab gwahtiqaqta na in mat agemab usim teq gwahtiqaqta ham. Nazaq iyan nagah naqmo in mat na eman God ameb ahol anumlan inaq iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Daq meqinta mataw gigemab gwahtiqaqta na kagzaq ham. Ni ninad meqmeqinta nigemab usaqta na teq ni mat wol emaqta na teq ni an alulib hureqim inaq usaqta na teq ni an a hi waqadmo an haresmo hureqim inaq usaqta na teq ni rin tonaqta na teq ni hazizirib mat araq kat ugaqta na teq ni mataw gibilawunaqta na ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Daq nagan bunmo in mat eman God ameb ahol anumlan inaq iyaqta ham. Ari mat aben a hi suholadmo didaq neqaqta na in ahol eman God ameb anumlan inaq a hi iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ari Yesus uliq na hulosim in uliq giger Tair teq Saidon gigo saw ban tilah. ");
INSERT INTO mlp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lehan Kenan-ib aw araq saw nab osyaqta na bolim in lileyim bilam, O Iyahta ham. Ni Devit atatin ham. Ni ya inan ninad meqniyan ham. Bugaw araq meqinta ya imiy meqin diq tonaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Haqan Yesus amenin araq a hi bilam. An Yesus ago disaipel bolim buloniy, Aw ka i gimuzad gililewunad luwaq haqiy. Nagah in anan bilaqaqta na ni em ugidmo in lehan haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Haqan Yesus bilam, God iqeman ya Isrel on mataw gimomo gigo hib bolta ham. Isrel on mataw na in bilaqne sipsip nabag lehiyta nog ham. An ya on mataw naqmo ginagunim bol ham. Ya mataw en ta araq gigo hib a hi bol ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","An aw na bolim Yesus agerab abakbakan ulum laquwim turad bulon, Iyahta ham ni ya ilumsih ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Haqan Yesus amenin emim bilam, Ni hulossa yaqgo onmin didaq negid giyunin bugid teq ham. Luweq ya onmin gigo didaqta na waqeq gaun negid neqsa yaqgo onmin gigemnan moq daqay ham. Daq nawa na in dimun a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Haqan aw na bilam, Iyahta ni helmo bilaqaq ham. Ta teq gaun in gimam ago ban ahaqenib didaq aneglan woqsa in neqaytamo ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Haqan Yesus bilam, Ni ninad helmo haqaqta na ayahmo ham. Nagah anan ninad bilaqaqta na in ningo hib tugwahtiqdaq ham. Yesus nazaq bilaqan muran diq nawaqmo aw na amiy ahol tidimniy. ");
INSERT INTO mlp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ari Yesus uliq na hulosad in yuw-kurorqan Galiliy aqurumun muzim lehim in garah araqab gwalehim tuqos wom. ");
INSERT INTO mlp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Os woqim ossa teq on mataw kabemmo in ago hib gaboliy. Gabolad in mataw gisen meqinta teq gime haiqta teq giditin kok tonta teq giqez haiqta teq gigo moq amo amo giholib usaqta kabemmo in Yesus ago hib giqad gaboliy. Giqad gabolim Yesus anognib giqeman teq Yesus in giwastitayan tidimniyiy. ");
INSERT INTO mlp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","An on mataw biyahta na in mataw giqez haiqta na gamuk tiqemsa teq mataw giditin kok tonta na gihol tidimniysa teq mataw gisen meqinta na eraqim tiloq gelsa teq mataw gime haiqta na saw ahol tuwaqsa in nazaq gibiyad in gihol turuh nemyaq. Gihol turuh nemsa in Isrel gigo God abin tiqiluw yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ari Yesus in ago disaipel gibilenan bolan in gibilan, Ya on mataw ka ginan inad timeqniyaq ham. Ya nenaq kam ezeqmanmo osan in gigo didaq tihiqiy ham. In didaq haiqmo gigemnan moqsa ya samanmo giqemid lehnan ituw hiqiyaq ham. Luweq in lehad danib gime sinsanid woq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Haqan disaipel buloniy, Saw ka saman diqta haqiy. I edob bret kabemmo giwaqeq on mataw humab ayahta kazaq ka i negid neq daqay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Haqan Yesus tisusumun nag, Ta negmo gigo bret ganim diq usaq? ham. An in bilaqiy, I gigo bret 7 nazaq diq teq nabiq amikmikta amulik-mulikmo kawa usaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Haqan Yesus on mataw gibilenan in ogib os woqim tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ossa teq Yesus in bret 7 na nabiq inaq giwaqim God esey ugim teq in orqayim ago disaipel tinag. Negan disaipel waqim on mataw tinegiy. ");
INSERT INTO mlp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Negan on mataw bunmo neqan tigiyunin bug. Giyunin bugan didaq abeyan asor osan in kuram 7 giwaqim amalib tigisiheniy. ");
INSERT INTO mlp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mataw didaq neqiyta na ginulinqan kabemmo diq 4,000 nazaq. Teq on onmin nenaq a hi ginulin bugiy. ");
INSERT INTO mlp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","An Yesus on mataw giqeman tilehsa teq in muyib gwalim og anan Magadan haqayta na ago saw ban tilah. ");
INSERT INTO mlp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ari Farisi asor teq Sadyusi asor in Yesus ulum waqnan haqad agerab tuboliy. Bolim in bilaqiy, Ni Mat Iyah ulilib osaqta na bulonid in daq araq azawayin inaqta emid i ahol waquq haqiy. Ahol waqad teq i ni ninan helmo tihaqam haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Haqan Yesus amenin emim bilam, Zeq wolehad imisor iysa kait akakaqan iysa ne ahol waqad bilaqay, Kam tidimniynan kait akakaqan iyaq haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ad tarommo onqas dubta tiqad kait akakaqan iysa ne ahol waqad bilaqay, Muran urom woqad tim sibdaq haqayta ham. Ne kait awaqan ahol waqad nagah teq gwahtiqdaqta na ago ne ginad em hasayta ham. Ta teq muran kam kab ne nagah ahol waqad ginad a hi em hasay ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","On mataw kam kabta ham ne on mataw meqinta God gileh ugayta ham. Ne daq azawayin inaqta naqmo ahol waqnan bilaqayta ham. Ta teq God in daq araq azawayin inaqta a hi giqisihundaq ham. Kwaziqmo Jona aholib daq gwahtimta naqmo ne ahol waq daqay ham. Haqad Yesus in gihulosad tilah. ");
INSERT INTO mlp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ari disaipel yuw-kurorqan Galiliy urotim le urum kozaq ban tugwahtiqiy. Teq in gidek zizalan bret asor waqim ad a hi boliy. ");
INSERT INTO mlp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sa Yesus gibilan, Ne Farisi teq Sadyusi gigo yis anan gihol waz naqmo hiqiyiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Haqan disaipel in gimo an bulonim bilaqiy, Ka i bret waqim ad a hi bolan daqag in bilaqaqya haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Haqsa Yesus in gigo gamuk tuhuritim in bilam, Mataw ham ne gigo ginad helmo haqayta na amik diq ham. Ezaqgo ne bilaqay, I bret haiq haqay? ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ne ginad a hi emad os tutay ye? ham. Mataw 5,000 nazaq bret abaynagin neqan teq ne abeyan ginuwim kuram kabemmo gisiheniyta na ne anadin a hi emay ye? ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Teq mataw 4,000 nazaq bret 7 neqan ne abeyan ginuwim kuram kabemmo gisiheniyta na ne anadin a hi emaymo ye? ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ezaq diq tonim ne ginad a hi emay? ham. Ya bret diq anan a hi gibilen ham. Ya bilay, Ne Farisi teq Sadyusi gigo yis anan gihol waz naqmo hiqiyiy hay ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","In nazaq haqan teq disaipel ginad tiqemiy. Yesus in bret ago yis anan a hi bilam haqiy. In Farisi teq Sadyusi gigo daq in on mataw giqisihunayta naqmo i anan gihol waz naqmo hiqiyam haqad in bilamta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ari Yesus uliq ayahta Sisariya Filipay gigo saw ban lehim kam nab in ago disaipel susumun negim bilam, On mataw in Mat Atatin anan nog diq haqsa ne huritay? ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Haqan disaipel buloniy, Mataw asor ni ninan Jon mataw huz negyaqta na amatin haqay haqiy. Sa asor ni ninan bilaqay, Ni Elaija haqay haqiy. Sa asor bilaqay, Jeremaya o God ago nantut kwaziqta na gigo araq daqag ni haqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","An Yesus a ta susumun nag, Ta negmo ya inan nog diq haqay? ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Haqan Saimon Pita amenin emim tibilam, Ni Krais ham. God mat emid bo i gilumsihdaqta amatin na ninmo ham. Ni God kayeqmo osaqta na atatin ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Haqan Yesus bulon, Jona atatin Saimon ham, ni tidimniyim osaq ham. Ogib kab mat araq in ya ihol alulin nawa ni tibilamta na in a hi niqisihun ham. Haiqgam ham. Ya imam Heven-ib osaqta naqmo in ya ihol alulin na tiniqisihun ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","An ya kazaq nibilenaiq ham. Pita ni gig nog ham. Ni nimalib teq yaqgo on mataw giqemid in nab zaway iyeq titur daqay ham. Tursa nagah zawayta mataw tumoqiyta gigo uliqab boleq giqothassa in a hi hiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ya teq zaway kazaq tinigdaiq ham. Og kab mat araq God ago maror aduganib gwahtiqnan tonsa ni wasihdaqta na tekomo God in mat na wasihgo anad tiqamtamo ham. Ari mat araq God ago maror aduganib gwahtiqnan tonsa ni bo gwahtiq haqdaqta na tekomo God in mat na gwahtiqgo anad tiqamtamo ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Haqad Yesus in ago disaipel gunun negim atoranmo gibilan, Ne ya ihol alulin ya mat God iqeman bolta anan Krais haqayta na ago ne mat araq hikidik buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ari kam nabmo Yesus ago gamuk amebta in moqdaqta na alulin emim in ago disaipel gibilenim bilam, Ya Jerusalem-ub lehmo tilehdaiq ham. Lehid mataw marorta na teq mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na in santitiy ayahmo tiyag daqay ham. Yagad teq in ya inol emid tumoqdaiq ham. Moqeq ya kam ezeqmanmo usid teq God iwazid ta eraqdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Haqan Pita nazaq huritadmo in Yesus waqim dan adek ban a lehim teq in wadim bulon, Iyahta ham haiq diqmo ham. Daq meqinta nagan niholib a hi gwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","An Yesus ahol buliyim in Pita kazaq bulon, Satan ni tukeq ya igilehun ban leh ham. Ni ya idanin qwaynan tonaq ham. Ni God anad a hi muzaq ham. Haiq ham. Ni mat og kabtaqmo anad muzaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Haqad in ago disaipel bunmo kazaq gibilan, Mat araq ya imuzeq bolnan haqad anad emeq in ahol wazid woqan ham. Ad ya afaqan soraiqta nazaqmo in sornan anad bilaqsa in ago kruse sorid abetarib gwalan ham. In nazaq toneq teq in ya imuzeq bolan ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Na ezaqgo mat nog inmo ahol anadin emad asan alowan tonaqta na in ahol awitan tihik hulesdaq ham. Ari mat nog in ya inadin emad ahol nog hulosdaqta na in dimunmo kuluwa-kuluwmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nagaqgo mataw og kab osad in giholyon nagah kabemmo diq rom tonayta? ham. Abeb in moqid in gigo nagah giholyon rom toniyta na ezaq teq gilumsihdaq? ham. In gihol awitan tihik hules daqay ham. Teq in nagah ogibta na amalib gihol awitan zayeq os dimuntab le tugwahtiq daqay ye? ham. Na haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Abeb Mat Atatin in amam ago ahol anuwanib ago angelo nenaq tuboldaqta ham. Boleq in on mataw bunmo gigo daq in emiyta na ahunibmo amenin tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ya helmo ne gibilenaiq ham. On mataw muran kam kab osayta ka gigo asor a hi moqadmo in Mat Atatin king iyeq bolsa ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ari abeb kam 6 nazaq tihiqiyan Yesus in Pita teq Jems ama Jon inaq giwaqim nenaq garah araq sisaqta abigmanib tugwalehiy. Gwalehim in nab giholbinmo tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ossa mataw na gimeb Yesus ahol buliyim awaqan lul araq diq iy. In anobun zeq anuwan nog iysa ago tubusan hus diq saw anuwan nog iy. ");
INSERT INTO mlp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sa disaipel nazaq Yesus ahol waqad ossamo Elaija ayow Moses inaq giwitan tugwahtiqiy. Gwahtiqim in disaipel gimeb Yesus inaq gamuk bilaqad turiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tursa Pita in Yesus bulon, Iyahta ham i kab osauqta ka in dimun diq ham. Ni ninad bilaqid ya kab baybay ezeqmanmo tiqemdaiq ham. Araq ninmen teq araq Moses amen teq araq Elaija amen ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","In nazaq bilaqad tursamo onqas anuwan inaqta gehitiqim tigiqisih. Giqisihan God aqez onqas na aduganib bilam, Ka ya itatin ham. Ya in anan inad bilaqsa ya igem dimun diq iyaqta ham. Ne in aqez huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","An disaipel God aqez na huritim gihol rabsa in ogib woqim tuqusiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ussa Yesus gigerab bolim giwazad gibilan, Ne hi rabiy ham. Eraqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Haqan in ogib usad gimemo gwalehim in mat araq ahol a hi waqiy. In Yesus amomo tursa ahol waqiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ari in aweweqmo garah na hulosim gewoqadmo Yesus disaipel ezeqman na gidek wazim gibilan, Ne muran sen qway nog iyim nagah ahol waqiyta ka ne mat araq hikidik buloniy ham. Abeb God in Mat Atatin hodhodab waz ta eraqid teq ne nagah ka ago tibilaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Haqan disaipel tisusumun ugiy, Ta ezaqta ago mataw Moses ago gunun hurit kemiyta na bilaqay, Elaija danmeb bolid teq Krais abeb boldaq haqayta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Haqan Yesus bilam, Helmo ham. Elaija boldaqta ham. In boleq nagah bunmo tuwastitaydaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ta teq ya ne gibilenaiq ham. Elaija tubol ham. Bolan mataw in ahol a hi waq hasiy ham. Ahol a hi waq hasad in ginadibmo mat na aholib daqdaq emim timeqin toniy ham. Ad teq in nazaqmo Mat Atatin ayon emsa in santitiy ayahmo tuwaqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesus nazaq haqanmo disaipel ginad tiqemiy, Yesus in Jon mataw huz neqyaqta naqmo anan bilaqaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Ari Yesus ago disaipel ezeqman na nenaq on mataw biyahta na gigerab gewoqanmo mat araq bo Yesus agerab loqim abakbakan ulum laquwim turad bilam, Iyahta ham ni yaqgo amun matta ka ninad ug ham. In agadan iyad ahol meqin diq iyaqta ham. Sirisirimo in faqmeb teq yuwmeb woqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Sa ya waqim ningo disaipel gigo hib a bolan in wastitaygo biyab a hi iyiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Haqan Yesus bilam, On mataw kam kabta ne God anan helmo a hi haqayta ham. Ad ne ginad titnonim diq a hi usaqta ham. Kam ganim teq ya nenaq a ta osdaiq? ham. Kam ganim teq ya ne ginad siqim iyaqta na ago a hi bilaqad ya ne gigo afaqan sordaiq? ham. Ne amun yaqgo hib kab a boliy ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Haqan in amun a bolan Yesus bugaw meqinta na tuwad. Wadanmo bugaw meqinta na amun tuhulos ug. Hulos ugan nawaqmo amun na ago moq tihiqiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Abeb disaipel in gimomo Yesus ago hib bolim buloniy, I ezaq iyim bugaw meqinta ko a hi muz? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","An Yesus gibilan, Ne ginad helmo haqayta na in siqim diq na ago ne bugaw meqinta na a hi muziy ham. Ya helmo ne gibilenaiq ham, Ne ginad helmo haqayta na amik diq ay mastet anagin nog usid teq ne garah ka buloneq bilaq daqay, Ni eraqeq kobmo leh haqid in ne giqez tumuzdaq ham. Ad teq ne nagah araq a hi em daqayta a hi iy daqay ham.  ");
INSERT INTO mlp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Teq bugaw meqinta muzgo adanteqin araq araq haiqgam ham. Ne God amomo bulonad susumun ugad teq ne didaq udiniy ham. Dante amulik naqmo amalib teq ne bugaw meqinta muz daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ari Yesus ago disaipel nenaq saw Galiliy-ib humab wolim osad teq in ago disaipel gibilan, Mat araq teq Mat Atatin waqeq mataw gibenab tiqemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Emid teq in wol emid tumoqdaq ham. Moqeq kam ezeqmanmo usid teq God in wazid ta eraqdaq ham. Haqan disaipel gihol afaqan diq iyiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ari abeb in le uliq Kapaneam-ub tugwahtiqiy. Gwahtiqanmo nab mataw Tempel ago takis waqayta na in Pita ago hib bolim tisusumun ugiy, Ne gigo tisa ko Tempel ago takis zayaqta ye? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Haqan Pita bilam, Eqe ham in zayaqta ham. Haqad in muleqim bitab ta bolim in nan na ago asit a hi bilaqsamo Yesus inmo gamuk na wazan eraqan in tisusumun, Saimon ham ni ninad ezaq emaq? ham. Og kab mataw king iyim osayta na in gingan gigo hib takis waqayta? ham. In gimo gigo onmin gigo hib takis waqayta o haiq in mataw ta asor gigo hib waqayta? ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Haqan Pita bilam, In mataw ta asor gigo hib takis waqayta ham. An Yesus bulon, Ni dimunmo tibilam ham. King gigo onmin takis a hi zayayta ham. In samanmo osayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nazaq iyan i takis a hi emamta na in dimunmo ham. Ta teq luweq i mataw na gigem wizid in i ginad daqay ham. Nazaq iyan ni yuwub leheq aul huneg ham. Hunegeq nabiq danmebta ni tuqotdaqta na ni waqeq ate hiksis ham. Hiksiseq teq in ateb mani araq ussa ni ahol tuwaqdaq ham. Mani na ni waqeq a le ya ninaq giholyon takis na ni zayad neg ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kam nab Yesus ago disaipel in Yesus ago hib bolim tisusumun ugiy, God ago maror aduganib nog in ayah diqta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Haqan Yesus amun amikta araq bulonan bolan in amun na eman disaipel gilikmanib titur. ");
INSERT INTO mlp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tursa Yesus gibilan, Ya helmo ne gibilenaiq ham. Amun kazaqta ka abin haiqta ham. Teq ne ginad buliyeq amun abin haiqta ka nogmo a hi iyeq ne God ago maror aduganib a hi gwahtiq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ari mat nog inmo ahol wazid woqsa in amun abin haiqta nog iyeq mat naqmo God ago maror aduganib abin ayahta tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mat nog in amun kaqanta ya ibinib bolsa ahol waqad wazinaqta na in ya iwazinaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ari ne gigo araq in onmin amikmikta ya inan helmo haqayta na gigo araq baymuzsa in anad helta na hulosnan tonid mat naqanta in yaqgo faq meqin diq tuwaqdaq ham. Na in kwaziqmo gig ayahta anatgumnib am wazeq hunegid kamismeb woqid yuw tineq nagta ham. Neqid mat na moqeq daq meqinta na a hi emeq in yaqgo faq meqin diqta na a hi waq nagta ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Daq meqinta mataw ginad hureqsa in ginad helta hulosayta na og kab tugwahtiqdaqta ham. Teq mat aw nog daq nazaq em daqayta na in timeqniy has daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ni nibensen araq kat nigid ni ninad helta hulosnan tonad ni nihol asor na uroteq hunegid lehan ham. Ni niben o nisen amulikmo inaq iyeq ni God inaq kuluwa-kuluwmo osdaqta na in dimunmo ham. Ari ni niben nisen giger inaq iyid in nihunegid ni faq a hi miyaqta nab lehdaqta na in meqin diq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ari ni nimeqnagin araq kat nigid ni ninad helta hulosnan tonad ni nimeqnagin na othaseq hunegid lehan ham. Ni nimeqnagin amulikmo inaq iyeq ni God inaq kuluwa-kuluwmo osdaqta na in dimunmo ham. Ari ni nimeqnagin giger inaq iyid in nihunegid ni os meqinta na ago faqab lehdaqta na in meqin diq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ne gihol wamuziy ham. Luweq ne onmin amikmikta na gigo araq baymuz daqay ham. Ya kazaq ne gibilenaiq ham. In gigo angelo gibiy muzayta na in Heven-ib ya imam anobun tutimmo ahol waqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Teq ne ginad ezaq emay? ham. Mat araq in ago sipsip 100 nazaq giwamuzad luwsa ta araq nabag lehid mat na le a hi nagundaq e? ham. Haiqgam ham. In ago sipsip 99 na gihulosid garahab luwsa in leheq sipsip amulikmo nabag lahta na tinagundaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ya helmo ne gibilenaiq ham. Mat na in ago sipsip nabag lahta na ahol tuwaqeq ari in ago sipsip kabemmo garahab luwad nabag a hi lehiyta na ginadin a hi emdaq ham. In ago sipsip amulikmo nabag lehan in nagim le ta wamta naqmo ago in anad dimniy naqmo hiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na nazaqmo ne Gimam Heven-ib osaqta na in onmin amikmikta na gigo araq aban iygo in anad a hi bilaqaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ni nimaqbab araq daq araq meqinta niholib emid ni leheq ahol waq ham. Ahol waqad ni inaq negmo giger giholbinmo osad ni ago daq meqinta na anan bulon waq ham. In ningo gamuk huritid teq ni nimaqbab na hureqid in God ago hib ta boldaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ari in ni niqez a hi huritid ni boleq mat amulik o giger nazaq giwaqeq nenaq ta leheq nimaqbab na inaq gamuk na wastitay waqiy ham. Na ezaqgo mataw na in giqez ni niqez inaq wastonid ningo gamuk awaz timeqniydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ari ni nimaqbab na in ne giqez a hi huritid ni on mataw yaqgo nan huritayta na bunmo gibilen ham. Gibilenid in ni nimaqbab na bulonsa in giqez a hi huritid teq ne bunmo mat na aholib hiqiyiy ham. Ne on mataw en ta asor Juda a haiqta nagan teq mataw takis waqayta na giholib hiqiyayta nazaq ne mat na aholib hiqiyiymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ya helmo ne gibilenaiq ham. Og kab ne gigo mat araq in ago daq meqinta hulosnan atuw hiqiysa ne baymuzsa God tekomo mat na baymuzgo anad tiqamtamo ham. Ari mat na in ago daq meqinta na hulosid ne ta waqid ne gimuganib ta bolid God tekomo mat na ta waqgo anad tiqamtamo ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ad ya ne a ta gibilenaiq ham. Og kab ne gigo mataw giger in nagah araq anan gigem amulikmo iyad ya imam Heven-ib osaqta na bulonsa in nagah anan ginad usaqta na tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Na ezaqgo mataw giger o ezeqman nazaq ya ibinib humab emeq ossa teq ya in gilikmanib tuqosdaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ari kam nab Pita bolim Yesus kazaq susumun ug, Iyahta ham ya imaqbab araq imeqin tonsa ya ime ganim in ago daq na walemad anadin a ta hi emdaiq? ham. Ya inad emaiq, Ya ime 7 nazaq ago daq meqinta walemdaiqta na in kabemmo diq haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Haqan Yesus bilam, Haiq ham. Ni nimaqbab ame 77 nazaq nimeqin tonid ni nazaqmo nime 77 nazaq in ago daq meqinta na walemad anadin a ta emdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ni hurit ham. God ago maror aduganib daq usaqta na in bilaqne king araq ago kabibiy mataw in gigo ayahta ago mani asor samanmo waqiyta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Abeb king na in ago mani amenin waqgo alulin emsa mataw in ago mani waqiyta na gigo araq in ago hib tubol ham. Mat na in king ago 10 milyon kina wamta ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Waqim teq in mani na amenin emdaqta na araq diq aholib a hi us ham. Nazaq iyan in ago ayahta na bilam, Mat ka ago aw amun nenaq gizayid in leheq mat araq ago kabibiy mataw samanta iyeq osiy haqad in bilam ham. Ad in ago nagah bunmo gizayeq mani na ne waq a bo ya yagiy haqad in bilam ham. I daq nazaq emid teq mat ka in yaqgo mani amenin asormo tiqemdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Haqan kabibiy mat na nazaq huritadmo in king agerab abakbakan ulum laquwim turad bulon, Ni ya inan ninad meqniysa ni asit ibaq tun haqad in bilam ham. Ya ningo mani wayta na amenin bunmo tinigdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","An kabibiy mat ago ayahta na in anan anad meqniysa in ago hib amenin usta na tuwal em bug ham. Ad in mat na hulosan tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Teq kabibiy mat na asanib gwahtiqim lehim in aholyow araq in inaq araqib kabiy emayta na ahol tuwam ham. Ahol waqad in ayow na anatgumnib waz naqmo hiqiyadmo bulon, Yaqgo 100 kina niholib usaqta na muran diqmo ni yagdaqta haqad in bulon ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Haqan in ayow na huritadmo in abakbakan ulum laquwim turad bulon, Ni ya inan ninad meqniysa ni asit ibaq tun haqad in bilam ham. Ya mani wayta na amenin bunmo tinigdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Teq haiq ham. Mat na hulos ham. Ad in ayow na wazim a lehim bit giqirquran osaytab tiqam ham. Emad in bulon, Ni bit kab oseq le ni yaqgo gimeq wamta na amenin em bugeq teq ni gwahtiqdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ari mat na ayogniz asor in inaq araqib kabiy emayta na in daq nazaq ahol waqad in gigem meqin diq iyiy ham. Gigem meqniysa in lehim daq gwahtimta na awagamun bunmo in gigo ayahta tubuloniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bulonan kabibiy mat na ago ayahta inmen nan eman bolan in bulon, Ni kabibiy mat meqin haqad in bilam ham. Teko ni gaqsa ya ningo amenin usta na walem bugta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ya ni ninan inad meqniyta haqad in bilam ham. Ta ezaq haqad ni niyow na anan ni ninad a hi meqniymo? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Haqad agem meqniysa in mat na waqim bit giqirquran osayta nab a tilah ham. A lehim in mataw bit na wamuzayta gibenab emim gibilan, Ne mat ka santitiy ugsa le in yaqgo gimeq wamta na amenin em bugeq teq in gwahtiqan haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Haqad Yesus bilam, Ya ne gibilenaiq ham. Ne giyogniz nenaq an anobun a hi wastitayid ya imam Heven-ib osaqta na in nazaqmo ne tigitondaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ari gamuk na tihiqiyan Yesus saw Galiliy hulosad in yuw Jodan urotim saw Judiya-ib tilah. ");
INSERT INTO mlp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lehsa on mataw kabemmo muzim inaq tilehiymo. Lehan nab teq Yesus in gigo asor gigo moq inaqta na giwastitayan tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sa Farisi asor Yesus ulum waqnan haqad agerab tuboliy. Bolim in tisusumun ugiy, I Juda gigo maror bilam, Mat anadibmo ago aw muznan in tumuzdaq hamta na in daq dimun o daq meqin? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Haqan Yesus amenin emim bilam, Ne tobag God ago gamuk ka ahol a hi waqiy daqagya ham. Gamuk na kazaq bilam ham. Mebmebmo diq God nagah bunmo giqemad in on mataw matmatta teq onqonta inaqmo giqam haqad in bilam ham. Teq in bilam, ");
INSERT INTO mlp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Daq alulin naqmo ago mat in anen amam gihuloseq in awe aholib tisoqotdaq ham. Soqoteq in giger gihol amulikmo iyeq tuqos daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nazaq iyan mat awe inaq in gihol giger a ta hi iyayta ham. Haiqgam ham. In giger gihol amulikmo tiqiyim osayta ham. Nazaq iyan nagah God am tuwazan usaqta na mat araq ta hi urotan ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Haqanmo Farisi amenin emim buloniy, Nazaq na teq ta ezaqta ago Moses gunun igim bilam, Mat araq aw muz agamukan mar toneq ago aw ugadmo in tumuzdaq haqad in bilam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Haqan Yesus gibilan, Ne gigem soqotim usad God anad a hi muzinsa iyan Moses ne gihulosan ne on gimuzayta ham. Ta teq kwaziq diqmo God nagah bunmo giqamta nab daq naqanta a hi usta ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ad yaqmo kazaq ne gibilenaiq ham. Mat awe muzad aw ta araq muturta waqaqta na in bilaqne mat ta araq ago aw inaq luw nog iyaqta ham. Ari mat na awe in mat ta araq uteteq inaq luwsa aduw diq na in aw na muznan in tumuzdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Haqan disaipel buloniy, Mat in aw inaq gigo daq nazaq usid ari in an hi waqiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Haqan Yesus kazaq gibilan, On mataw bunmo in ne gigo gamuk na a hi hurit daqay ham. God in mataw asormo zaway negan in aw a hi waqadmo samanmo osayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mataw aw a hi waqayta na alulin amo amo ham. Mataw asor ginen nazaqmo giqeman in ginad aw waqgo hulosayta ham. Ta asor gikayogin ayan in aw a hi waqayta ham. Ad mataw ta asor in God ago maror anadin emad in aw waqgo gihol wasihayta ham. Mat nog in ne gigo gamuk na huritad teq in muzinnan iysun in muzinan ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ari kam nabmo on mataw gigo onmin amikmikta giqad Yesus ago hib tubol yaqay, Yesus aben in giholib emeq giwazad gimen God bulondaq haqad. Teq haiq. In onmin giqad bolsa disaipel ginadad tigimuz yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sa Yesus gibilan, Ne onmin gihulosid yaqgo hib boliy ham. Ne hi giwasihiy ham. On mataw naqantaqmo God ago maror aduganib gwahtiqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Haqadmo in onmin na gimalib aben emim giwazad teq in tilah. ");
INSERT INTO mlp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ari Yesus tilehsamo mat araq in ago hib bolim bulon, Tisa ham ya daq dimun doqag diqta emeq teq ya os dimunta kuluwa-kuluwmo osayta na iholyon tuwaqdaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Haqan Yesus bulon, Nagaqgo ni nagah dimunta ago ya susumun yagaq? ham. Mat amulikmoqmo in dimunta ham. Ari ni kayeqmo kuluwa-kuluwmo tuqosnan haqad ni gunun bunmo Moses bilamta na muz bug ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Haqan mat na bulon, Na naga gununin diq? ham. Haqan Yesus bilam, Gunun ni muzdaqta na kawa ham. Ni mat araq wol emid hi moqan ham. Ni an alulib hureqeq inaq hi us ham. Ni hi rin ton ham. Ni hazizirib mat araq hi kat ug ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ni ninenmaman giqez hurit ham. Ad ninmo nihol anan ninad bilaqaq nazaqmo ni niyow anan ninad bilaqan ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Haqan mat minminta na in Yesus bulon, Gunun nagan bunmo ya tumuz bugta ham. Ta ya daq ezaq diqta emnagta a hi emaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Haqan Yesus bulon, Ari ni mat dimun diqta tiqiy hasnan iysun ni leheq ningo nagah bunmo gizayeq amenin waqeq mataw ginaghan haiqta neg ham. Ni nazaq toneq teq ni Heven-ib ningo nagah kabemmo diq inaq iydaq ham. Ad ni daq na emeq teq ni ya imuzeq bol ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Haqan mat minminta na gamuk nazaq huritim in anobun iyim anad ayahmo meqniysa tilah. Na ezaqgo in ago nagah dimdimunta kabemmo usta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sa Yesus in ago disaipel gibilenim bilam, Ya gamuk helmo ne gibilenaiq ham. Mat ago nagah kabemmo usaqta na in God ago maror aduganib gwahtiqgo afaqan diq ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ya ne a ta gibilenaiq ham. Karuw ayahta anan kamel haqayta na in nidel akwiyaknib le tugwahtiqdaq e? ham. Hikidik ham. Ad nazaqmo mat ago es kabemmo ginadin emaqta na in God ago maror aduganib le a hi gwahtiqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Haqan disaipel gamuk na huritim gihol turuh nam. Gihol turuh nemsa in bilaqiy, Nazaq iyid teq mat araq diq God ago os dimunta nab le a hi gwahtiqdaqya haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Haqan Yesus gibiyad gibilan, Mataw in gimo gigo zaway amalib le a hi gwahtiq daqayta ham. Ari God-mo mataw gilumsihsa teq in le tugwahtiq daqay ham. Na ezaqgo God in nagah araq a hi emdaqta a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Haqan Pita amenin emim bulon, Ni i gibiy ham. I nagah bunmo gihulosim i ninmo nimuzim ninaq tilehauq ham. Teq God amenin ezaqta tiqigdaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Haqan Yesus in disaipel bunmo gibilan, Ya helmo ne gibilenaiq ham. God nagah bunmo og kab giwastitayid mutur iydaqta akaman nab Mat Atatin abin ayahta inaq iyeq ago ban tawontab tuqos woqdaq ham. Kam nab teq ne mataw ya imuzim boliyta na ne nazaqmo marorgo ban 12 nazaq nab ne tuqos daqaymo ham. Osad ne Isrel gigo gem 12 na tigibiymuz daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Teq mat aw nog in ya imuzeq bolnan haqad in gigo bit teq gimaqbaban teq gihiyan teq ginenmaman teq gigo onmin teq gigo og gihulosiyta, on mataw na bunmo teq in gigo nagah na amenin 100 nazaq tuwaq daqay ham. Ad teq in God ago os dimuntab gwahtiqeq kuluwa-kuluwmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kam nab teq mataw gibin inaq iyim og kab osayta na kabemmo gibin hiqiysa bo abeb tiqiy daqay ham. Sa mataw kabemmo og kab gibin haiqta na in gibin inaq iyeq le danmeb tiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ari Yesus bilam, God ago maror in bilaqne mat araq tarommo lehim kabibiy mataw asor in ago ogib am wain akabiyan em daqay haqad giwamta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mat na lehim kabibiy mataw giwaqad gibilan, Kam amulik-mulikmo ya gimeq amulik-mulikmo amalib ne tigizaydaiq haqad in bilam ham. Haqan mataw na ‘dimunmo’ haqiy ham. An mat na giqeman in wain akabiyan emnan tilehiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Lehsa 9 kilok nagzaq mat na maket-ib lehim mataw asor samanmo kabiy haiqmo tursa in gibiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gibiyad in gibilan, Ne inaqmo leheq wain akabiyan emiy haqad in bilam ham. Emid teq ya ne kabiy em daqayta na amenin anononmo tinegdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Haqan mataw na tilehiymo ham. Lehsa 12 kilok teq 3 kilok mat na lehim in a nazaqmo ta am ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Emim teq 5 kilok imisor in lehim mataw asor samanmo tursa in gibiy ham. Gibiyad in gibilan, Ne nagaqgo kam kab sisaqmo samanmo turiy? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","An mataw na bilaqiy, I mat araq kabiy a hi igaq haqiy ham. Haqan mat na gibilan, Ne inaqmo leheq yaqgo wain akabiyan emiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ari imisor diq tiqiyan kabiy anamren na in mat kabibiy mataw gibunib turaqta na bulon, Ni kabibiy mataw gibilen bolid mani neg haqad in bilam ham. Itureq ni kabibiy mataw abeb bolim kabiy emiyta na gizay haqad in bilam ham. Gizayeq teq ni ta mataw ameb bolim kabiy emiyta na gizay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","An mataw 5 kilok imisor bolim kabiy emiyta na gwahtiqim in amulik-mulikmo mani ameta amulik-mulikmo waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Waqsa mataw ameb diq bolim kabiy emiyta na in ginad emiy, I mani ayahmo waqam daqagya haqiy ham. Haqimmo haiq ham. In nazaqmo mani ameta amulikmo waq toniymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","In mani na waqim ahol waqan ayah a hi iyan in gigem meqinta kabiy anamren ugad bilaqiy, Mataw abeb bolim kabiy emiyta na in kam sisaq diq kabiy a hi emiyta haqiy ham. Mataw abeb na gigo mani nogmo i gigo haqiy ham. I tarommo kabiy atoran diq emim zeq ginoysa bo imisor tiqiy haqiy ham. Teq ni araqibmo i gizayaq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","An kabiy anamren in mataw na gigo araq bulonim bilam, Kadoy ham ya ni a hi nimeqin ton haqad in bilam ham. Ya ninaq ni mani ameta amulikmo waqgo a hi bilawta ye? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ningo mani na ni waqeq a leh haqad in bilam ham. Mani nawa ya nigta nazaqmo ya mataw abeb boliyta na neggo inad bilaqan ya tinegmo haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nagah na in yaqgo haqad in bilam ham. Ya inadibmo a hi gizaydaiq e? haqad in bilam ham. Nagaqgo ni nigem meqniyaq? haqad in bilam ham. Ya daq dimunta emaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Haqad Yesus bilam, God ago maror aduganib daq nazaqmo usaqta ham. On mataw abeb iyim osayta na in bo danmeb iysa ta asor danmeb iyim osayta na in le abeb tiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Ari Yesus in mataw biyahmo nenaq Jerusalem-ub tugwalehyaq. In danib gwalehad luwad in ago disaipel 12 na giwaqim giqad lehim giholbin osad teq in gibilan, Ne huritiy ham. Muran i Jerusalem-ub tugwalehauq ham. Nab teq mat araq in Mat Atatin waqeq mataw tamaz emayta gigo aseseqta na giyogniz mataw Moses ago gunun hurit kemiyta na nenaq gibenab tiqemdaq ham. Emid in ayon tibilaq daqay, Wol emid moqan haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Haqad in mataw en araq Juda a haiqta na gibenab emid in Mat Atatin bilawunad woltitayad teq in ayib abensen dom wolid tumoqdaq ham. Moqeq kam ezeqmanmo usid teq God wazid ta eraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ari kam nab Sebediy atatniz giger Jems ama Jon inaq in ginen inaq Yesus ago hib tuboliy. Bolim in ginen Yesus anognib abakbakan ulum laquwim turad in Yesus ago hib nagah araq waqgo haqad tisusumun ug. ");
INSERT INTO mlp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","An Yesus bulon, Ni naga waqnan? ham. Haqan aw na bilam, Yaqgo onmin giger ka in ningo maror aduganib maror aseseqta iyeq osgo haqad ni gitowun emeq bilaq ham. Araq niben niqabun ban ossa araq niben ninasaran ban osdaq na ago ni bilaqsa mataw ka huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","In nazaq bilaqan Yesus amenin emim gibilan, Ne nagah anan susumunayta ka ago ne a hi hurit kemiy ham. Abeb mataw gileh yagsa santitiy ayahmo tiqiqisih bugdaq ham. Ne giger teq gog ayuwun agon meqin diqta ya uluwdaiqta na asor ne tuquluw daqaymo ye? ham. Haqan giger na bilaqiy, Na i tuquluwamta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","An Yesus gibilan, Helmo ham. Ne giger teq yaqgo gogib yuw tuquluw daqayta ham. Ari nog diq ya iben iqabun ban osdaqta na teq nog ya iben inasaran ban osdaqta na in yaqgo nagah a haiq ham. Ya imam in mataw gangan gimen ban tuwastitayan usaqta naqmo in ban na tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ari disaipel 10 na gamuk na huritim in maqbab giger na gigem meqinta negiy. ");
INSERT INTO mlp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","In nazaq tonsa Yesus gibilenan agerab bolan in gibilan, On mataw en ta asor Juda a haiqta nagan gigo maror aseseqta in gihol abin iluwad igmo ag haqad osayta ham. Ad in gigo walmataw giqemid in gimo ginad muzad gihaqenib iyeq osgo in giwaz meqniyayta ham. Na ago ne tuhuritiyta ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Teq ne in gigo daq na hikidik muziniy ham. Ne gilikmanib mat nog in mat ayahta iyeq osnan haqad in ahol wazid woqsa in ne gilumsiheq gimen kabiy eman ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ad mat nog in ne gigo mat amebta iyeq osnan haqad in ne gigo kabibiy mat samanta iyeq osan ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ne Mat Atatin em nogmo ne emiy ham. In mataw giqemid inmen kabiy sorgo a hi bol ham. In mataw gigo kabibiy mat nog iyeq in gigo afaqan inmo ahol ugad teq in ahol amalib mataw kabemmo gizayeq bab gibenab ta giwaqgo haqad in bolta ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ari Yesus ago disaipel nenaq uliq Jeriko hulosad tilehiy. Lehsa on mataw kabemmo Yesus muzim inaq tilehiymo. ");
INSERT INTO mlp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sa mataw giger gime haiqta dan adekib osad in Yesus bolaqta na abin tuhuritiy. Huritim in dedibmo lileyim bilaqiy, Iyahta haqiy. Devit atatin haqiy. Ni i ginan ninad meqniyan haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Haqan on mataw biyahta na in mataw giger na ginadad gibileniy, Ne giqez hiqiyiy haqiy. Haqan haiq. In dedibmo a ta lileyim bilaqiy, Iyahta haqiy. Devit atatin haqiy. Ni i ginan ninad meqniyan haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Haqsa Yesus ahol wasihim turad in giger na gililewunim gibilan, Ya ne ezaq gitondaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Haqan in buloniy, Iyahta haqiy ni i gime wastitayid dimniyan haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Haqan Yesus in ginan anad meqniysa in aben mataw giger na gimeqnagnib tiqam. Eman muran diq nawaqmo in gime hastitayan in saw ahol tuwaq yaqay. Ad in Yesus muzim inaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Ari Yesus ago dauh nenaq le Jerusalem sinsin tuqugad in le uliq Betfage-ib tugwahtiqiy, garah Oliv asenab. Gwahtiqim nab Yesus in disaipel giger giqeman danmeb lehsa in gibilan, Ne le uliq ginobun ban usaqta kob gwahtiqeqmo donki araq amidon inaq am giwazan turayta na ne tigibiy daqay ham. Na ne giqamun haseq giwaqeq giqad yaqgo hib a boliy ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sa mat araq nan bilaqid teq ne kazaq buloniy ham. Iyahta karuw giger ka gigo hib ago kabiy inaq haqad ne buloniy ham. Bulonid teq in hid naqmo giqemid tubol daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesus nazaq bilaqim in kwaziqmo God ago nantut gamuk bilamta na tuwol net bug. ");
INSERT INTO mlp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gamuk na bilam, Ne on mataw uliq Sayon-ibta kazaq gibileniy ham. Ahol waqiy haqiy ham. Ne gigo king nawa donki amalib osim tubolaq haqiy ham. In ahol wazan woqsa donki amidon amalib osim bolaq haqad ne nazaq gibileniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","An disaipel giger na lehim Yesus gibilanta nazaqmo in tiqemiy. ");
INSERT INTO mlp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","In donki anen amidon inaq giwaqim giqad tuboliy. Bolim in gigo tubusan asor donki gimalib eman Yesus tubusan na amalib tuqos. ");
INSERT INTO mlp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ossa on mataw kabemmo in gigo tubusan danib gihureniy. Gihurensa asor in ay aben qwayim danib rireniymo. ");
INSERT INTO mlp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Samo on mataw Yesus anobun ban danmeb lehad asor agilehun ban muzim inaq bolad in lileyim bilaq yaqay, Devit atatin ka abin sorid ulilib gwalan haq yaqay. Mat ka Iyahta abinib bolan i ginad bilaq gigayinaq haq yaqay. I God abin sorid ulilibmo diq gwalan haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ari Yesus le uliq Jerusalem-ub tugwahtim. Gwahtiqsamo on mataw uliq nabta na bunmo gihol turuh nemsa bilaq yaqay, Ko nog diq? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Haqsamo on mataw biyahta Yesus muzim inaq boliyta na bilaq yaqay, Ka God ago nantut Yesus uliq Nasaret saw Galiliy-ibta naqmo amatin haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ari Yesus Tempel agelin aduganib le gwahtiqim in mataw nagah gizayad osiyta na gimuzan asanib tukim tilehiy. Lehsa Yesus in mataw mani amo amo waqad amenin bit na ago mani negayta na gigo ban otbuliyan tuwom. Ad teq in mataw ah ");
INSERT INTO mlp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ad in mataw na gibilan, God ago marib in gamuk araq kazaq bilam ham. Mataw yaqgo bit anan bilaq daqay, God inaq gamuk emgo abitan haq daqay haqad in bilam ham. Ta teq ne bit ka eman in mataw rin tonayta gigo bit nog tiqiyaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Teq Yesus Tempel-ib luwsa mataw asor gime haiqta teq gisen meqinta in ago hib bolsa in giwastitayan tidimniyiy. ");
INSERT INTO mlp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sa mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na in Yesus daq azawayin inaq na emsa ahol tuwaqiy. Ahol waqsa teq ta onmin in Tempel agelin aduganib turad in lileyim bilaq yaqay, I Devit atatin ka abin wazid ulilibmo gwalan haq yaqay. Haqsa mataw aseseqta gamuk na huritad in gigem meqin diq iy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Gigem meqniysa in Yesus buloniy, Onmin ko ni nibin iluwsa ni a hi huritaq e? haqiy. Haqan Yesus gibilan, Ya huritaiq ham. Ta ne God ago marib gamuk araq mar tonan usaqta na ne ahol a hi waqiy daqagya ham. Gamuk na bilam, Ni onmin amikmikta teq onmin susibta giqez eman in ni nibin soran ulilibmo gwalaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Haqadmo in mataw na gihulosad uliq Betaniy-ib tilah. Lehim tarom nab in uliq nab tuqus. ");
INSERT INTO mlp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Usim tarommo diq Yesus eraqim uliq Jerusalem-ub muleqim ta lah. Lehad danib in agem tumoqyaq. ");
INSERT INTO mlp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Agem moqsa in ame le ay fik araq dan adek ban tursa ahol waqad agerab tilom. Loqim in anon araq ahol a hi wam. Haiqgam. Aben samanmo ananmo us. An in ay fik na bulonim bilam, Ni ninon a ta hi emdaq ham. Haiq diqmo ham. Haqan hid naqmo ay fik na tumay. ");
INSERT INTO mlp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mayan disaipel ahol waqad gihol riten lamsa bilaqiy, Ay fik ko ezaq tonim hid naqmo may? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Haqan Yesus gibilan, Ya helmo ne gibilenaiq ham. Ne helmo diq haqad ginad giger a hi emeq ya ay fik bulonan mayta kazaqmo ne tiqem daqaymo ham. Ad ne garah ko bulonid in ne giqez muzeq sor tukeq le kamismeb tuwoqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ne ginad em hasiy ham. Ne helmo haqad God inaq gamuk emeq teq nagah ne anan susumunayta na ne tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ari Yesus Tempel agelin aduganib lo gwahtiqim in on mataw suleq tinegyaq. Suleq negsa mataw tamaz emayta gigo aseseqta na teq Juda gigo mataw marorta na in ago hib bolim atoranmo susumun ugiy, Ni nibin ezaqta iyim ni daq kagan emaq? haqiy. Teq nog diq nibin na nig? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Haqan Yesus gibilan, Ta ya nazaqmo nagah araq ago ne tisusumun negnan ham. Ne yaqgo susumun ka amenin emid teq nog ibin yagan ya daq kagan emaiqta na ago ya tigibilendaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ari Jon mataw gihuz negyaqta ago kabiy na edob bol? ham. Kabiy na Heven-ib bolta o haiq in matawmo gigo hib kabiy na wamta? ham. Haqan mataw aseseqta na in gimo an mugad bilaqiy, I bilaqam, Kabiy na God ago hib bolta haqid in tibilaqdaq, Ta nagaqgo ne Jon ago gamuk huritim anan helmo a hi haqiy? haqdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ari i bilaqam, Kabiy na matawmo gigo hib bolta haqeq i on mataw biyahta ka girabunam haqiy. Na ezaqgo in bunmo Jon anan bilaqay, God ago nantut araqmo diq haqayta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nazaq iyan in Yesus ago susumun na amenin emim buloniy, I a hi hurit haqiy. Haqan Yesus gibilan, Ya nazaqmo ham. Nog ibin yagan ya daq kagan emaiqta na ago ya a hi gibilendaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Haqad Yesus in mataw aseseqta na gibilan, Ne ginad ezaq emay? ham. Mat araq ago onmin gigermo nenaq os yaqay ham. Osad teq gimam in atatin aqenta na bulon, Amun ham muran ni leheq yaqgo am wain akabiyan em ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Haqan atatin bilam, Ya ituw hiqiyaq ham. Ta teq abeb in anad buliyim in kabiy na emnan tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sa gimam in atatin ta araq na ago hib tilah ham. Lehim in teko bilamta nazaqmo in ta na tubulonmo ham. Bulonan amun na bilam, Eqe mam ya le kabiy na tiqemdaiq ham. Haqim teq in a hi lah ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ari onmin giger na gilikmanib amun nog in amam anad muzta? ham. Haqan mataw na bilaqiy, Amun amebta naqmo haqiy. Haqan Yesus gibilenim bilam, Ya helmo ne gibilenaiq ham. Mataw takis waqayta na teq on danatabta na in ne giquriyamim ameb diq God ago maror aduganib tugwahtiqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Haqad in bilam, Jon daq dimunta giqisihunyaqta ham. Giqisihunsa teq ne in ago gamuk anan helmo a hi haqiy ham. Ari mataw takis waqayta na teq on danatabta na in Jon ago gamuk anan helmo haqsa ne in gibiyiy ham. Gibiyad teq ne ginad buliyim Jon ago gamuk na anan helmo a hi haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Haqad Yesus bilam, Gamuk awowun ta araq ka ne huritiy ham. Mat araq in ago og araqab am wain anagin kabemmo leyim tigel ton ham. Gel tonim in yay araq wain anagin em woqid bay ninaleq ayun waqgota na titay ham. Na tihiqiyan in mat kabiy wamuzdaqta ayon bit araq asen sisaqta emim in kabiy na mataw asor gibenab tiqam ham. In anad mataw na in gimo giholyon kabiy emad wain anagin asor waqad asor in ya yag daqay haqad ham. Kabiy anamren anad nazaq emad gibilenim hulosad in era uliq araq pesantab tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lehim ossa wain anagin waqgo akaman sinsin tiqiy ham. Sinsin iysa in ago kabibiy mataw giqeman in mataw na gibenab ago wain anagin asor waqnan tilehiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Lehan mataw wain akabiyan emayta na in mataw na giwazim araq wolad araq in wol emiy ham. Ad in araq gigib woliy ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","An kabiy anamren in ago mataw kabemmo giqeman ta lehiy ham. Mebmebmo in mataw giqeman lehiyta na in kabem a haiq ham. Ari in abeb mataw giqeman lehiyta na in kabemmo diq ham. In mataw na giqeman lehsa mataw wain akabiyan emayta na in nazaqmo tigimeqin toniymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","An abeb diq kabiy anamren in atatinmo eman tilah ham. In anad am, Ya itatin em lehid teq mataw na in aqez tuhurit daqay haqad ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Teq haiq ham. Mataw kabiy wamuzayta na in kabiy anamren atatin bolsa ahol waqad in gimo an bulonim bilaqiy, Abeb mat ko amam moqid in amam ago ahuran nagah bunmo tuwaqdaqta haqiy ham. Bolsa i le mat ko wol emid moqanmo haqiy ham. Moqsa amam ago kabiy ka i giholyon waquq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Haqad in mat na waqim kabiy asanib a lehim wol eman tumom ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nazaq iyan kabiy anamren boleq in mataw wain akabiyan wamuzayta na ezaq gitondaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Haqan mataw na buloniy, Kabiy anamren in mataw meqinta na santitiy ayahmo negad ginol emid tumoq bug daqay haqiy. Sa in ago kabiy na waqeq kabibiy mataw ta asor bunta tinegdaq haqiy. Negid in kabiy na anononmo wamuzad wain anagin waqgo akamnib in wain anagin asor waqeq kabiy anamren tuqug daqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Haqan Yesus gibilan, Ne God ago mar ahol a hi waqayta ye? ham. Mar nab gamuk araq kazaq bilam ham. Tituq mataw anan bilaqiy ‘meqin’ haqiyta naqmo in awaz meqin diq turad bit anon bunmo soraq haqad in bilam ham. Iyahtaqmo nagah na eman gwahtiqan i ahol waqsa in dimun diq iyaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nazaq iyan ya ne gibilenaiq ham. God in ago maror ne gibenab walemeq in on mataw lul ta araq in ago maror akabiyan anononmo em daqayta naqmo gibenab tiqemdaq ham.  ");
INSERT INTO mlp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sa mat araq tituq na amalib woqeq in aditin bunmo tuwolbiyaydaq ham. Ari tituq na in mat araq amalib woqeq in mat na tuwol ninal bugdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ari mataw tamaz emayta gigo aseseqta na giyogniz Farisi nenaq in Yesus gamuk awowun bilamta na huritim ginad tiqemiy, Yesus igmo ginan bilaqaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Haqad in Yesus wazeq irqurnan ginad emad teq in ta on mataw ginan rab yaqay. Na ezaqgo on mataw na ginad em yaqay, Yesus in God ago nantut araq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ari Yesus gamuk awowun ta araq gibilan. ");
INSERT INTO mlp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","God ago maror in bilaqne king araq ago amun matta aw waqnan tonsa in ayon didaq ayahta oyta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Danmeb in mataw humab nab boleq an waq adidaqan neq daqayta na gimen nan eman tilah ham. Lehan abeb didaq neqgo akaman na tugwahtiqan in ago kabibiy mataw giqeman in mataw tanabmo gimen nan amta na gibilennan a ta lehiy ham. Lehan mataw na bunmo humab nab bolnan gituw tihiqiyiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","An king na in ago kabibiy mataw ta asor giqeman ta lehiy ham. Lehsa in gibilan, Ne le ya iqez tuteq mataw ya gimen nan emta na kazaq gibileniy ham. Ne huritiy haqiy ham. Ya didaq nagah bunmo tigiwastitay haqiy ham. Yaqgo bulmakau matmatta teq yaqgo bulmakau gimidgotniz ginon aseseqta na ya ginol emim tigiqoy haqiy ham. Ya nagah bunmo tigiwastitayan usaq haqiy ham. Ne an waqgo adidaqnib boliy haqad ne gibileniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Haqan kabibiy mataw gamuk na huritim in lehim mataw na nazaqmo tigibileniy ham. Gibilenan mataw na in king ago gamuk na a hi huritiymo ham. Ad in haresmo lehad araq ago kabiyab tilah ham. Sa araq ago mani akabiyan emnan tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sa mataw na asor in king ago kabibiy mataw na giwazim gimeqin diq tonim ginol eman tumoqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Moqan king na agem meqniyan in ago bab mataw giqeman lehim in mataw in ago kabibiy mataw ginol emiyta na ginol eman tumoq bugiy ham. Ginol emad in gigo uliqab bit nagah bunmo mideran tuqoy bug ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sa king na in ago kabibiy mataw gibilan, Ya an waqgo adidaqan tuwastitayan usaq ham. Ta teq ya mataw gibilenta na in yaqgo humabub bolgo dimun a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nazaq iyan ne lehad dante buntab mataw gibiyad ne mataw na bunmo gibilenid in yaqgo an waq adidaqnib kab boliy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Haqan kabibiy mataw na tilehiy ham. Lehad in dante buntab mataw gibiyad gihumab woliy, mataw meqmeqinta teq mataw dimdimunta inaqmo ham. Gihumab wolan bit humab em daqayta nab ban tihiqiy bug ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ari mataw bo humabub tuqossa teq king na in gibiynan tugwahtim ham. Gwahtiqim gibiyim gibiyim lehadmo mat araq ago tubusan anumlan inaqta emim an waq ahumabnib nab ossa in ahol tuwam ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ahol waqad in mat na bulonim bilam, Kadoy ham. Ezaqgo ni tubusan araq dimunta emim teq ni bo a hi gwahtim? haqad in bilam ham. Haqan mat na amenin araq emdaqta haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nazaq iyan king in ago kabibiy mataw gibilan, Ne mat ka abensen am wazeq hunegid le asanib gwahtiqeq in romriqab osan ham. Osad in anad meqniysa gaqad ate guruwad tuqosdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Haqad Yesus bilam, God in mataw kabemmo gililewunaqta ham. Gililewunad in mataw na gilikmanib amulik-mulikmo gilumim giwaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ari Farisi asor lehim humab wolim osad teq in ezaq toneq Yesus kat ugid in gavman gigo gunun araq itiyonad nan hi bilaqnanta bilaqid i tuwazam haqad in an bulonad osiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Osim in ginad tiqemim in gigo matawta asor teq Herot ago matawta asor nenaq giqeman tilehiy. Lehim in Yesus ago hib gwahtiqim tubuloniy, Tisa haqiy, i ningo tuhurit haqiy. Ni a hi katiyaqta haqiy. Ad ni on mataw God ago dan titnonta giqisihunad ni hel diqmo gibilenaqta haqiy. Ni gamuk helta bilaqnan a hi rabaqta haqiy. Na ezaqgo haqiy ni mataw gibin inaqta a hi girabunad gigomo a hi lehaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nazaq iyan ni i gibilen haqiy. Ni ninad ezaq emaq? haqiy. I gibabun Rom gigo king Sisa in i gituw bulsa i takis ugauqta na in daq dimun o daq meqin? haqiy. I Juda gigo maror ezaq bilamta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Haqan Yesus in mataw ginad meqinta na tuhurit. Ad in bilam, Ne mataw gimileq meqin diqta ham. Nagaqgo ne ya ilum waqay? ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mani takis zayayta na araq iqisihunid ya ahol waqiq ham. Haqan in mani araq a bolim tuqugiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ugan Yesus ahol waqad in mataw na tisusumun nag, Ka nog diq adulan teq ahol anan usaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Haqan mataw na bilaqiy, Na Sisa-mo agota haqiy. Haqan Yesus gibilan, Nazaq iyan Sisa ago nagah na ne Sisa-mo ugiy ham. Ad God ago nagah na ne God-mo ugiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Haqan mataw na ginadnad emad Yesus hulosim tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","Ari mataw aseseqta na tilehsa kam nabmo Sadyusi asor Yesus ago hib tuboliy. Mataw na ginad kazaq emayta. Mataw tumoqiyta hodhodab a hi eraq daqay haqayta. Na in bolim Yesus buloniy, Tisa haqiy, Moses i gimen gamuk araq mar tonim in kazaq bilam haqiy. Mat araq aw waqeq amun a hi emsamo moqid in amikqan araq abab aqoburan na waqeq alulib abab ayon onmin tigiqemdaq haqad in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ari gamuk araq kazaq lahta haqiy. Mat araq amikqaniz nenaq 7 nazaq diq iyim i gilikmanib osiy haqiy. Osim in gibab na aw araq tuwam haqiy. Waqim inaq osad in ago amun haiqmo osimmo tumom haqiy. Moqan ama araq in abab aqoburan na tuwam haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Waqim in nazaqmo amun haiqmo osim tumommo haqiy. Moqan ama ta araq in aw naqmo waqim in nazaqmo ton haqiy. Mat ezeqmanta na amun haiqmo moqan amagniz bunmo nazaqmo toniy haqiy. In nazaqmo emim emim le gima 7-ta na in nazaqmo tonmo haqiy. In bunmo aw amulik naqmo waqim amun araq a hi emimmo tumoq bugiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mataw na tumoq bugan abeb aw na tumommo haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nazaq iyan abeb mataw bunmo hodhod huloseq eraq daqayta nab teq maqbab 7 na gilikmanib aw na in nog awe tiqiydaq? haqiy. Mataw na bunmo in aw amulik naqmo waqiyta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Haqan Yesus amenin emim gibilan, Ne God ago marib gamuk usaqta na ago ne ginad a hi em hasay ham. Teq ne God ago zaway a hi hurit kemaymo ham. Nazaq iyan ne gamuk menmen bilaqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","On mataw hodhodab eraq daqayta nab in an a ta hi waq daqay ham. In bilaqne God ago hib angelo osayta nazaq nogmo in os daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Teq mataw tumoqiyta hodhodab eraq daqayta agamukan God nagta na ne ahol a hi waqiyta daqagya? ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Gamuk nab God bilam, Abraham ago God, teq Aisak ago God, teq Jekob ago God na yaqmo haqad in bilam ham. Nazaq iyan God in mataw moqim kayeqmo osayta na gigo God iyim in gibiy muzaqta ham. Mataw moqim a hi hiqiyayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Haqan mataw biyahta nab turiyta na in Yesus ago gamuk huritim gihol turuh nemiy. ");
INSERT INTO mlp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ari Yesus in Sadyusi gigo gamuk na amenin anononmo eman Sadyusi giqez tihiqiyim osiy. Ossa mataw ginan Farisi haqay na in nazaq huritad in bo Yesus agerab humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Mataw na gilikmanib mat araq Moses ago gunun hurit kamta in nab osmo. Osim in Yesus ulum waqad susumun ugim bilam, Tisa ham God ago maror Moses bilamta na aduganib gunun doqag diqta in gunun bunmo giquriyamim in ayah diqta? ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Haqan Yesus bulonim bilam, God ago gamuk bilam, Ne gigem, giqutil, teq ginad bunmo amalib ne gigo Iyahta God anan ginad bilaqan haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gunun na in ayah diqta teq in ameb diqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Haqad in bilam, Teq gigerta na in gunun amebta na nogmo ham. Na in kazaq bilam ham, Ni nihol anan ninad bilaqaqta nazaqmo ni niyow anan ninad bilaqan haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Gunun giger na in God ago maror Moses mar tonta na teq God ago nantut gamuk mar toniyta na bunmo alulinmo diq ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Ari Farisi Yesus agerab humab wolim os tutsa Yesus susumun negim bilam, Ne ginad ezaq emay? ham. Mat anan Krais haqayta na in nog atatin? ham. Haqan Farisi bilaqiy, In Devit atatin ");
INSERT INTO mlp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Haqan Yesus bilam, Nazaq na teq ezaq haqad God ago Bugaw Dimunta in Devit anad ugsa Devit in Krais anan bilam, Yaqgo Iyahta haqad in bilam? ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Devit gamuk araq mar tonim bilam, Iyahta in yaqgo Iyahta kazaq bulonim bilam ham. Ni ya iben iqabun ban kab ya imen emad ossa ya ningo bab giqemid nisen ahaqenib tiqiy bug daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ari Devit in Krais anan bilam, ‘Yaqgo Iyahta’ haqad in bilam ham. Nazaq iyan ezaq toneq Krais in Devit ago Iyahta iyeq teq in Devit atatin a ta iydaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Haqan mat araq in Yesus ago gamuk na amenin emgo biyab haiq. In bunmo giqez tihiqiyiy. Nazaq iyan mataw bunmo rabad in Yesus ulum waqnan a ta hi susumun ug yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Ari abeb Yesus in on mataw biyahta na teq inmo ago disaipel nenaq gamuk gibilenim bilam, Mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq in Moses ago ban waqim Moses mataw suleq negyaqta nazaq in ne suleq negayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nazaq iyan in gamuk bunmo amalib suleq negayta na ne huritad muzmo muziniy ham. Ari in gigo daqmo teq ne hikidik muziniy ham. Na ezaqgo in suleq negayta na in gimo a hikidik muzinayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","In gunun kabemmo diq mataw negayta ham. Bilaqne in nagah afaqanta tuq tonim am wazim mataw gibetarib emayta nazaq nog ham. Eman mataw nagah afaqanta na sorad in giholtuw bulad luwayta ham. Luwsa ta mataw aseseqta na in gilumsihgo giben amotin asit lo a hikidik wazayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mataw aseseqta na in gigo daq bunmo emsa mataw gibiyad gibin iluw daqay haqad in emayta ham. In God inaq gamuk emgo arin aseseqta gibenab teq gimaqbelab emayta ham. Teq in God inaq gamuk emgo abalawun in gigo tubusan adekib emayta na in aburgan sisaqmo wole giqusaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","In humab adidaqan inaqtab ogib garuruhab osnan hulosmo diq hulosayta ham. Ad bit humab wolaytab nazaqmo in ban ulilibta nabmo osnan ginad bilaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","In maket-ib luwsa mataw in ginan ‘mat ayah’ haqsa in ginad dimniyaqta ham. Teq mataw in gibin iluwad ginan ‘tisa’ haqgo in ginad diq bilaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ta teq negmo mataw giwasihsa in ne ginan ‘tisa’ hi bilaqiy ham. Haiqgam ham. Mat amulikmoqmo in ne gigo Tisa-ta ham. Sa ne bunmo maqbabmo osay ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ad ogib kab ne mat araq anan ‘kamam’ nazaq ne hi bilaqiymo ham. Ne Gimam amulikmoqmo osaqta ham, Mat Heven-ib osaqta naqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ad ne mataw giwasihsa in ne ginan ‘maror’ hi bilaqiymo ham. Ne gigo Maror amulikmo osaqta ham, mat anan Krais haqayta naqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ne gilikmanib mat ayah diqta na in ne gigo kabibiy matmo iyeq osan ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mat aw nog in gimo gihol abin wazan eraqaqta na in gibin tuwoqdaq ham. Ad mat aw nog in gihol abin wazan woqaqta na in gibin tiqeraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Haqad Yesus bilam, Ne mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq ham ne timeqniyim osayta ham. Ne ginad emay ye? ham. Ne mataw gimileq meqinta ham. On mataw God ago maror aduganib gwahtiqnan tonsa ne gidanin qwayayta ham. Negmo a hi gwahtiqayta ham. Ad on mataw God ago maror aduganib lo gwahtiqsamo ne giwasihayta ham.  ");
INSERT INTO mlp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ne mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq ham ne timeqniyim osayta ham. Ne ginad emay ye? ham. Ne mataw gimileq meqinta ham. Ne on waburta kat negad gigo bit samanmo waqayta ham. Ad ne mataw gimeb God inaq gamuk sisaqmo bilaqim a lehayta ham, mataw gibiyad ginan dimun diqta haq daqay haqad ham. God hazizir ayahta emdaqta nab ne on mataw bunmo giquriyameq faq ayah diqmo tuwaq daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ne mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq ham ne timeqniyim osayta ham. Ne ginad emay ye? ham. Ne mataw gimileq meqinta ham. Ne mat amulikmo emid ne gigo maror ahaqenib iyeq muzingo haqad ne giholtuw diq bulayta ham. Ne gihol anadin a hi emad ne kamis urotim lehim teq ne ogib dan pesanmo diq lehayta ham. Lehim ne mat na kat ugan in ne gigo maror ahaqenib iyim ne faqab leh daqayta nazaq nog in tiqiyaqmo ham. Teq ne mat na isihunan in ne giquriyamim daq meqinta kabemmo diq emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ne timeqniyim osayta ham. Ne ginad emay ye? ham. Ne gime haiqta ham. Ezaq teq ne mataw dan giqisihun daqay? ham. Ne kazaq bilaqayta ham. Mat Tempel abinib an adugan wazaqta na in nagah hel diq a haiq haqayta ham. Ari mat Tempel-ib gol usaqta naqmo abinib an adugan wazaqta na in nagah hel diqta haqayta ham. Mat gol na abinib gamuk awaz meqin bilamta nazaqmo diq in tiqemdaq haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ne mataw agadanta gime haiqta ham. Nagah edo diq in God ameb ayah diqta? ham. Ne ginad emiy ham. Gol na amomo in abin haiqta ham. Gol na Tempel-ibmo usad iyan in abin inaqta ham. Nazaq iyan Tempel-mo in nagah ayah diqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ad ne kazaq bilaqaymo ham. Mat Tempel-ib tamaz emgo abanan usaqta na abinib an adugan wazaqta na in nagah hel diq a haiq haqayta ham. Ari mat in nagah tamaz emgo abanab usaqta naqmo abinib an adugan wazaqta na in nagah hel diqta haqayta ham. Mat tamaz na abinib gamuk awaz meqin bilamta nazaqmo diq in tiqemdaq haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ne gime haiqta ham. Nagah edo diq in God ameb ayah diqta? ham. Ne ginad emiy ham. Nagah tamaz emgo abanab usaqta na in abin haiqta ham. Nagah na in God ago tamaz em abanab usad iyan in abin inaqta ham. Nazaq iyan God ago tamaz em abanan naqmo in nagah ayah diqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nazaq iyan ne ginad em haseq teq gamuk bilaqiy ham. Mat tamaz em abanan na abinib hel diqtaqmo haqaqta na in ban na teq nagah ban amalib usaqta na inaqmo gibinib gamuk bilaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ad mat Tempel abinib an adugan wazim hel diqtaqmo haqaqta na in Tempel teq bit na anamren inaqmo gibinib gamuk bilaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ad mat Heven abinib hel diqtaqmo haqaqta na in God ago ban tawonta na teq ban na anamren inaqmo gibinib gamuk bilaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ne mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq ham ne timeqniyim osayta ham. Ne ginad emay ye? ham. Ne gimileq meqinta ham. Kabiyab kwasin amikmikta ginan mint teq dil teq kumin haqayta na ne giwaqim gihuseran humab 10 nazaq iyan ne humab amulikmo God ugayta ham. Ta teq God ago maror aduganib daq aseseqta na ne tuhulos bugiy ham. Daq titnonta amalib mataw gilum kemayta na teq mataw ginad negayta na teq God anan helmo haqayta na ago ne gidek zizalan ne a ta hi emayta ham. Ne daq aseseqta nawa na gidek a hi zizalsa ne tiqem nagiyta ham. Emad ne daq amikmikta nagan tiqem nagiymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ne mataw gime haiqta ne on mataw dan tigiqisihun daqay ye? ham. Ne daq amikmik didiqta ago bilaqad teq ne God ago daq aseseqta emgo ginad a hi emayta ham. Ne didaq neqsa taqorib honam amik diqta woqan ne ahol waqad waqim hunegayta ham. Ta teq karuw ayahta anan kamel haqayta na ne gigo taqorib woqan ne ahol a hi waqad taqor inaqmo tilonan gimuganib wolehaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ne mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq ham ne timeqniyim osayta ham. Ne ginad emay ye? ham. Ne mataw gimileq meqinta ham. Ne gog teq deg asanmo suholayta ham. Teq aduganib nagah rin tongo adan teq negmo gihol anadin emgo adan ame gwalim usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ne Farisi ham, ne gime haiqta ham. Itureqmo ne gog adugan suholiy ham. Adugan suholid teq gog asan anumlan hiqiydaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ne mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq ham ne timeqniyim osayta ham. Ne ginad emay ye? ham. Ne gimileq meqinta ham. Ne bilaqne hodhod asan balaw tonan hus diq iyaqta nazaq nog ham. Balaw tonan hodhod ahol awaqan dimun diqta teq aduganib mataw tumoqiyta giditin teq nagah lilihta kabemmo usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ne nazaqmo diq osayta ham. Mataw ne gibiyad ginad emay, Mataw ko in God ago mataw dimdimunta haqay ham. Ta teq mataw kat neg ago adan teq God ago maror othas ago adan in ne giduganib ame gwalim usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ne mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq ham ne timeqniyim osayta ham. Ne ginad emay ye? ham. Ne gimileq meqinta ham. Ne God ago nantut gimen hodhod abitan dimdimunta emayta ham. Ad ne mataw titnonta moqiyta gigo hodhod balaw tonayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne bilaqay, I gisesan gigo kamub osta iyeq i gisesan God ago nantut ginolsa i gilumsiheq a hi ginol em nagta haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Gamuk nabmo ne gihol ulal tonim bilaqayta ham. Helmo ne mataw God ago nantut ginol eman moqiyta na ginaynaynizta ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nazaq iyan ne gisesan gisen muzineq ne nazaqmo God ago nantut bunmo ginol emiymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ne nagah ahulinaqta meqinta ham. Ne ured amidgotniz ham. God teq ne ginan bilaqid ne faqab tileh daqayta ham. Ezaq teq ne tuk daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nazaq iyan ne huritiy ham. Ya teq mataw God ago nantut bilaq daqayta asor teq mataw ginad awaz meqinta asor teq mataw suleq neg daqayta asor giqemid in ne gigo hib tileh daqay ham. Lehsa ne asor ginol emid moqsa asor ne ayib dom wolid moq daqay ham. Ad asor ne bit humab wolaytab gusib ginol titay daqay ham. Teq asor ne gimuzsa in le uliq araqab ossa nab ne gimuzeq lehid in oseq eraqeq uliq ta araqab leh daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nazaq iyid teq og kab ne gisesan mataw dimdimunta ginol eman ginedan womta na ago afaqan ne gigo hib tuqusdaq ham. Mebmebmo in mat titnonta anan Abel haqayta na wol eman moqan in anedan wom ham. An abeb diq in Tempel teq tamaz em abanan asan ban turaqta na gilikmanib in Barekiya atatin Sekaraya na wol eman moqan in anedan wommo ham. Ne gisesan Abel akamnib mataw dimdimunta ginol emim bo bo Sekaraya ago akamnib tiqiyiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","An ya helmo ne gibilenaiq ham. God in mataw dimdimunta ginedan womta na amenin bunmo on mataw muran og kab osayta na gigo hib tiqemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Haqad Yesus bilam, O Jerusalem, Jerusalem ham. Ningo mataw God ago nantut ginol emayta ham. Ad God in ago gamuk kabibiy mataw negim giqeman ningo hib lehayta na gimalib in gig hunegayta ham. Kam kabemmo ya ningo on mataw gituwal emnan inad bilamta ham. Bilaqne kurek anenqab in amidgotniz aben gayik ahaqenib gituwal emim giqisihaqta nazaq ham. Ta teq ne hulosiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nazaq iyan ne huritiy ham. God ne gigo uliq hulosan in ne gibenab useq teq timeqniydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ya ne gibilenaiq ham. Ne ya a ta hi ibiy daqay ham. Ari ne ginad dimniysa bilaq daqay, Mat ka Iyahta abinib bolan i ginad bilaq gigayinaq haq daqayta kam nab teq ne a ta ibiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ari Yesus Tempel hulosim lehsa in ago disaipel Tempel abitan aseseqta nagan Yesus isihunnan haqad agerab tuboliy. ");
INSERT INTO mlp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bolim isihunsa teq Yesus in gigo gamuk amenin emim gibilan, Ne bit ko bunmo ahol waqay ye? ham. Gig ko bunmo teq wolzizilayeq gihunegid tuwoq bug daqay ham. Ya helmo bilaqaiq ham. Gig an amalib usayta ko teq muruwoqeq tiqmo bug daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ari Yesus garah anan Oliv haqaytab ossa ago disaipel gimomo in ago hib bolim bilaqiy, Ni i gibilen haqiy. Kam gineh teq nagah ni anan bilamta na tugwahtiqdaq? haqiy. Naga daqin diq ameb gwahtiqsa i ahol waqad ginad emam, Ni muleqeq tubolnan haqam? haqiy. Ad i ginad emam, Og ka hiqiydaqta akaman tugwahtiqaq haqam haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Haqan Yesus amenin emim bilam, Ne gihol waziy ham. Luweq mat araq ne kat negdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mataw kabemmo teq boleq ya inan biyad bilaq daqay, Yaqmo Krais haq daqay ham. Haqad in on mataw kabemmo kat neg daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Sa mataw bab emsa ne gihulan huritad teq ta mataw pesanta bab emsa ne gibin hurit daqaymo ham. Huritad ne ginad haresmo emad hi rabiy ham. Daq nagan nazaq tugwahtiqdaqta ham. Ta teq kam abebtanta na teqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mataw en araq eraqeq mataw saw araqabta nenaq an wol daqayta ham. Sa king araq ago dauh nenaq eraqeq king ta araq ago dauhta nenaq an wol daqaymo ham. Uliq saw amo amo zarow ayahta gwahtiqsa og ahol woldaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Daq nagan bunmo bilaqne aw agemab amun tubaysa loyinaq nazaq nog iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kam nab teq mataw ne giwazeq santitiy neggo haqad bab gibenab giqem daqay ham. Ad in ne ginol emid moq daqay ham. Ya ihol abin ne giholib usaqta na ago on mataw en bunmo gigem meqinta neg daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kam nab teq on mataw kabemmo in gigo ginad helmota na hulos daqay ham. Hulosad in an anan gigem meqniy daqay ham. Ad in gimaqbaban giwaqeq bab gibenab giqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Sa nantut katiyta kabemmo eraqeq on mataw kabemmo gikat neg daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mataw kabemmo gunun dimdimunta itiyonad daq meqintabmo os daqay ham. Daq meqinta kuluwmo gwahtiqad ban waq bugsa mataw kabemmo an anan ginad bilaqaqta na adan hulos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ari mat aw nog in zaway diq iyeq ossa le in gigo kam abebtanta gwahtiqdaqta nab God in gilumsiheq ta giwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mataw God ago maror agamukan dimunta ka og saw bunmo a leheq on mataw gibilen daqay ham. Gibilenad in bilaq daqay, God ne gimen gamuk kazaq bilamta haq daqay ham. Haqad in on mataw og saw bunmo God ago gamuk gibilen bugid nab teq kam abebtanta na tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Teq nagah meqin diqta uliq saw meqin tonaqta na in Tempel aduganib tursa ne ahol tuwaq daqay ham, kwaziqmo God ago nantut Daniel anan bilamta nazaq ham. (Mat gamuk ka ahol waqad bilaqaqta na in anad em hasad bilaq sireqan.) ");
INSERT INTO mlp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kam nab on mataw saw Judiya-ib os daqayta na in tukeq garah ban gwalehiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ad mat bit ahuqunib ban osnantab osdaqta na in ogib hitiqeq tukeq lehanmo ham. Lehad in ago es nagah bit aduganib usaqta na anadin emad hi giwaqan ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Teq mat kabiyab luwdaqta na in ago aholsihen waqnan uliqab muleqeq ta hi lehanmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kam nab on gigem iyayta na teq on amun muturta sus ugayta na in timeqniy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nazaq iyan ne God susumun ugid ne tuk daqayta akaman na in urom akamnib teq ne gigo lotu akamnib hi gwahtiqan ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kam nab mataw afaqan ayah diqta tisor daqay ham. Kwaziqmo God og saw bunmo giqemim bo muranmo afaqan araq nazaqta a hi gwahtimta ham. Teq abeb afaqan araq nazaqta a ta hi gwahtiqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ari God kam meqinta na siqim diq a hi emid on mataw bunmo tihiqiy bug nagiy ham. Teq God in ago on mataw in gilumim aholyon giwamta na ginadin emad in kam na emid siqim tiqiydaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kam nab mat araq ne gibileneq bilaqdaq, “Ahol waqiy, Krais kawa osaq” o “Krais kowa osaq” haqsa ne in aqez na hikidik huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Na ezaqgo krais katiyta teq nantut katiyta kabemmo tugwahtiq daqay ham. Gwahtiqeq in daq azawayin inaq aseseqta giqemad in kabiy lul araq diqta amo amo giqem daqay ham. In nazaq emad teq in God ago on mataw in gilumim aholyon giwamta na gihureqnan diq ton daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ne ginad em hasiy ham. Daq nagan a hi gwahtiqsa kawa ya ne tigibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nazaq iyan abeb in ne gibileneq bilaq daqay, Ahol waqiy, Krais saw amatawun haiqta nab osaq haqsa ne nazaq ban hi lehiy ham. Ad in gibileneq bilaq daqay, Ahol waqiy, Krais bit ka aduganib osaq haqsa ne giqez hi huritiymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kaitab mewlig hikliyanim anuwan zeq gwalaqta ban oyim le zeq wolehaqta banmo iyaqta ham. Teq Mat Atatin muleqeq ta boldaqta nab in nazaqmo diq tiqiydaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","In boldaqta nab in mataw gime titoneq a hi boldaq ham. Ne gamuk araq mataw bilaqad luwayta ka anadin emiy ham. In bilaqay, Karuw tumomta asan lilihim usaqta nabmo tirgaw bolim humab wolay haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ari kam nab afaqan ayahta na tihiqiyidmo, Zeq ame romriq iysa kalam a ta hi oydaq ham. Sa kaitab ulig milheseq ogib tuwoq daqay ham. Woqsa nagah aseseqta zawayta ulilib usayta nagan in gihol tuwol daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kam nab teq Mat Atatin ta boldaqta atowun kaitab tugwahtiqdaq ham. Gwahtiqid teq on mataw en bunmo ahol waqad in gaq wazad bilaq daqay, Mat na i giyon hazizir emnan bolaq haq daqay ham. Haqad in gaq wazad osad Mat Atatin kaitab onqas amalib oseq ago zaway teq ahol anuwan ayahta inaq bolsa in ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ahol waqsa taur atoranmo gayonsa Mat Atatin in ago angelo giqemid in og saw bunmo lehad inmo ago on mataw in gilumim aholyon giwaqan osayta na giwaqeq giwaqeq a lehad teq in tigiwaq bug daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Haqad Yesus bilam, Ay fik ago hib teq ne ginad tiqem has daqay ham. Ay na aben hur tonad atitoqin muturta gwahtiqsa ne ahol waqad ginad emay, Zeq akaman tiqiynan tonaq haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nazaqmo teq abeb nagah ya anan bilayta ka bunmo tugwahtiqsa ne ahol waqad ginad kazaq emiy ham. Nagah Yesus anan bilamta na bolim sinsin tiqiy haqiy ham, bilaqne mat dan ezab turad bit aduganib gwahtiqnan tonaq nazaq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya helmo ne gibilenaiq ham. On mataw muran kam kab osayta ka a hi moq bugsa daq nagan bunmo tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kait og inaq teq tihiqiydaqta ham. Ari yaqgo gamuk ka a hi hiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ari teq Mat Atatin kam gineh diq ta boldaqta na teq in zeq adulan ganimtab bo gwahtiqdaqta na mat araq a hi hurit ham. Angelo Heven-ib osayta na teq God Atatin inaqmo in kam na a hi huritiymo ham. God amomo kam na ago tuhuritta ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nowa akamnib mataw daq em yaqayta nazaqmo Mat Atatin ta boldaqta na akamnib in em daqaytamo ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Uq ayahta na a hi gwahtiqsamo on mataw didaq neqad yuw uluwad an waqad ossa le Nowa muy aduganib tugwahtim ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","In ginad a hi emad ossamo uq ayahta na hitiqim on mataw na bunmo gisorim giqad lehim tigineq bug ham. An Mat Atatin ta boldaqta na akaman in nazaqmo diq iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kam nab mataw giger leheq kabiyab luw daqay ham. Luwsa in araq waqad araq in hulosid nab tiluwdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Teq on giger mel emayta ago banib wit anagin wolworad os daqay ham. Ossa in araq waqad araq in hulosid nab tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nazaq iyan ne gihol asawan woltayad osiy ham. Ne gigo Iyahta kam gineh boldaqta na ago ne a hi huritayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ne gamuk ka huriteq teq ginad em hasiy ham. Bit anamren in mat rin tonaqta naga kamnib boldaqta na ago huriteq teq in ago bit wamuzeq saw waqad ossa mat rin tonaqta na bo bit wolzilayeq a hi gwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nazaq iyan ne gihol asawan woltayad osiy ham. Ne bilaq daqay, Mat Atatin a hi boldaq haq daqayta nabmo diq in bo tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ari naga matin in kabibiy mat dimunta nog? ham. Kabibiy mat dimunta in anad em hasad ago ayahta aqez muzinaqta ham. Aqez muzinad in kabibiy mataw bunmo giwamuzad didaq neq akamnib in didaq negaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Abeb ago ayahta na boleq in kwaziqmo bilamta nazaqmo ago kabibiy mat na emsa in ahol waqsa in ago kabibiy mat na tidimniyeq osdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya helmo ne gibilenaiq ham. Mat ayahta na in ago kabibiy mat dimunta na emid in ago nagah bunmo tigiwamuzdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ari kabibiy mat meqinta na in ahol buloneq bilaqdaq, Yaqgo ayahta lehim sisaqmo tiluwaq haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Haqad in ayogniz nenaq araqibmo kabiy emayta na haresmo tiginoldaq ham. Ad in mataw yuw atoranta uluwayta na nenaq didaq neqad yuw tuquluw daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","In nazaq emad ossamo ago ayahta bolsa in a hi huritdaq ham. Ad in ahol asawan a hi wastitaydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sa mat ayahta na boleq in kabibiy mat na wazeq woltitayeq teq in mataw gimileq meqinta na gigo sawab hunegid wo tilehdaq ham. Saw nab mataw ginad meqniysa gaqad gite guruwad osayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kam abebtanta nab God ago maror in bilaqne mat araq aw waqnan tonsa on barasta 10 nazaq adanin lehiyta nazaq nog iydaq ham. Mat aw waqdaqta na in ago bitab tubolad luw ham. Bolad luwsa in awe na ayogniz on barasta na gigo lam miderim adanin lehiy ham. In le danib ahol waqad teq inaq ta bolnan haqad ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","On na gilikmanib abaynagin in ginad haiqta ham. Teq abaynagin in ginad inaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","On ginad haiqta na in gigo lam waqim a bolad teq in wel lam-ub teneq mider daqayta na a hi waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ari on ginad inaqta na wel botol-ib tenim teq in lam inaq waqim a boliy ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Teq mat aw waqdaqta na hidmo a hi bol ham. Nazaq iyan on na bunmo gime rursa tuqusiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ussa tarom alihanib mat araq lileyim bilam, Mat aw waqdaqta na kowa tubolaq haqad in bilam ham. Ne eraqeq leheq ahol waqad waqeq inaq boliy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Haqan on barasta na bunmo eraqim in gigo lam waqim timideriy ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sa on ginad haiqta na in on ginad inaqta na gibileniy, Ne wel asor igiy haqiy ham. I gigo lam wel hiqiyim miynan tonaq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Haqan on ginad inaqta na bilaqiy, Wel ka ayah diq a haiq haqiy ham. Luweq i wel ka asor negid i gigo lam timiydaqmo haqiy ham. Nazaq iyan negmo leheq mataw gigo wel inaq na gigo hib asor ne giholyon zayiy haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Haqan on ginad haiqta na wel zaynan tilehsamo mat aw waqdaqta na tubol ham. Bolan on ginad inaqta na in mat na waqim inaq bit aduganib gwahti tilehiy ham. Lehim in gihol adanin otim mat aw waqaqta na inaq didaq neqad tuqosiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ossa on ginad haiqta na wel zayim muleqim ta bolim in dan ezab turad teq in dan ez wol hamad bilaq yaqay, Iyahta, Iyahta haq yaqay ham. Ni i giyon dan hasid i gwahtiquq haq yaqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Haqsa mat na in gigo gamuk amenin emim bilam, Ya helmo ne gibilenaiq haqad in bilam ham. Ya ne gigo a hi hurit haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Haqad Yesus bilam, Nazaq iyan ne gihol asawan woltayad osiy ham. Kam gineh teq zeq adulan ganimtab ya ta boldaiqta na ne a hi huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ari Yesus gamuk awowun ta araq gibilenim bilam, Kam abebtanta nab God ago maror in bilaqne mat ayahta araq saw pesantab lehnan haqad ago kabibiy mataw gibenab kabiy amta nazaq nog iydaq ham. Mat na in ago kabibiy mataw gibilenan bolan in ago nagah bunmo gibenab am ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Emad in ago kabibiy mataw gilum kemim kabiy negad in kabibiy mat araq ago zaway teq anad ayah diqta na 5,000 kina nazaq ug ham. Teq araq ago zaway teq anad ayah nogta na in 2,000 kina nazaq ug ham. Ugad araq ago zaway teq anad amik nogta na in 1,000 kina nazaq ug ham. In mani na negim gihulosadmo tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Lehsa mat 5,000 kina wamta na hidmo mani na amalib kabiy emim in 5,000 kina araqmo a ta wam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sa mat 2,000 kina wamta na nazaqmo mani na amalib kabiy emim in 2,000 kina araqmo a ta wam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ta teq mat 1,000 kina wamta na lehim ogib yay tayim in ago ayahta mani ugta na tuqulilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","An mat ayah na lehim sisaqmo osim teq in muleqim ta bol ham. Bolim in ago kabibiy mataw mani nagta na ago agamukan wastitaynan haqad in gimen nan eman in agerab tuboliy ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bolim mat 5,000 kina wamta na in ago ayahta na bulonim bilam, Mat ayah ham ni 5,000 kina yagta na kawa ahol waq haqad in bilam ham. Ya amalib kabiy emim amenin 5,000 kina-mo a ta way haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Haqan in ago ayahta bulon, Esey ham. Ni ya inad usta na em bugim ni kabibiy mat dimun diq haqad in bilam ham. Ni nagah asitmo anonon diqmo tuwamuzan ya nagah kabemmo nigid ni tuwamuzdaq haqad in bilam ham. Ni bolid ya ninaq ginad dimniysa osuq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","An mat 2,000 kina wamta na in bolmo ham. Bolim in bilam, Mat ayah ham ni 2,000 kina yagta na kawa ahol waq haqad in bilam ham. Ya amalib kabiy emim 2,000 kina-mo a ta way haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Haqan in ago ayahta bulon, Esey ham. Ni ya inad usta na em bugim ni kabibiy mat dimun diq haqad in bilam ham. Ni nagah asitmo na anonon diqmo tuwamuzan ya nagah kabemmo nigid ni tuwamuzdaq haqad in bilam ham. Ni bolid ya ninaq ginad dimniysa osuq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ari mat 1,000 kina wamta na tubolmo ham. Bolim in bilam, Mat ayah ham ya ningo tuhurit haqad in bilam ham. Ni mat afanta kamolmol a hi emaqta haqad in bilam ham. Didaq ni a hi layta na anon ni niholyon waqaqta haqad in bilam ham. Ad mat araq ago kabiyab wit anagin hunagta nab ni niholyon wit na anon tuwal emaqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nazaq iyan ya rabad ningo 1,000 kina ka ulileman us haqad in bilam ham. Ningo mani na kawa haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Haqan in ago ayahta amenin emim bulon, Ni kabibiy mat meqin haqad in bilam ham. Ya inad usta na ni a hi am haqad in bilam ham. Ni nabag yaqgo tuhurit haqad in bilam ham. Didaq ya a hi leyta na anon ya iholyon waqaiqta haqad in bilam ham. Ad mat araq ago kabiyab wit anagin hunagta na ago wit anon ya iholyon tuwal emaiqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nagaqgo ni mataw mani abitnib osayta na gibenab yaqgo mani eman in akabiyan a hi emiy haqad in bilam? ham. Emid teq ya muleqeq boleq yaqgo gimeq na amenin mani ayahmo inaqmo waqnagta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Haqad in bilam, Ne mat na abenab 1,000 kina in wazaqta na waqeq mat ago 10,000 kina inaqta na ugiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Na ezaqgo ya on mataw gigo nagah inaqta na bunmo nagah asor a ta negdaiq haqad in bilam ham. Teq ya mataw ginaghan haiqta na gibenab nagah asitmo in wazayta na walem bugdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ad ne kabibiy mat meqinta na muzid in asanib saw aromriq inaqtab lehan haqad in bilam ham. Saw nab mataw ginad meqniysa gaqad gite guruwad os daqayta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ari Yesus bilam, Abeb teq Mat Atatin king ayahta iyeq ago balaw anuwan oysa in angelo bunmo nenaq tuboldaq ham. Boleq in ago ban tawontab tuqos woqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Os woqeq ossa teq on mataw en bunmo boleq in anognib humab tuwol daqay ham. Humab woleq tursa in gihuserid dauh giger tiqiy daqay ham. Bilaqne mat sipsip teq memeq gihuseran sipsip kazaq bolsa memeq kozaq lehayta nazaq nog iy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","In ago sipsip aben aqabun ban giqemad teq memeq in aben anasaran ban giqemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Teq king na in on mataw aben aqabun ban turayta na gibileneq bilaqdaq, On mataw haqdaq ya imam anad dimun diqta tinegaq haqdaq ham. Ne boleq ya imam ago maror aduganib gwahtiqeq ban dimdimunta waqeq ago nagah giwamuzeq osiy haqdaq ham. Kwaziqmo ya imam og eman a hi gwahtiqsamo in ne gimen ban dimdimunta na tigiwastitayan usaqta haqdaq ham. Ya imam nazaq ne tigidimun tonnan haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na ezaqgo kwaziqmo ya igemnan moqad ossa ne ya didaq yagiy haqdaq ham. Ya yuwnan moqsa ne yuw yagan ya uluw haqdaq ham. Ya mat begbegta iyim bolan ne ya iwaqim ilowan toniy haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ya ibe aholmo luwsa ne tubusan yagiy haqdaq ham. Ya moqad ussa ne ya iwamuzad osiy haqdaq ham. Ya iqirquran ossa ne bolim ya ibiyiy haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Haqid teq on mataw dimdimunta na in ago gamuk amenin emeq bilaq daqay, Iyahta haq daqay kam gineh ni nigemnan moqad ossa i nibiyad didaq nig? haq daqay ham. Teq kam gineh ni yuwnan moqsa i yuw nigan ni uluw? haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kam gineh ni mat begbegta iyim bolsa i ni niwaqim nilowan ton? haq daqay ham. Teq kam gineh ni nibe aholmo luwsa i tubusan nig? haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kam gineh ni moqad ussa teq ni niqirquran ossa i bolim ni nibiy? haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Haqid teq king na amenin emeq bilaqdaq, Ya helmo ne gibilenaiq haqdaq ham. Nagah bunmo ne ya isenlul araq abin haiqta ago hib emad na ne yaqgo hib emiymo haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Haqad in on mataw anasaran ban turayta na kazaq gibilendaq ham. On mataw haqdaq ya imam ne kusluw tinag haqdaq ham. Ne tukeq dan ko muzeq faq oyad a hi miyaqta kob lehiy haqdaq ham. Faq na kwaziqmo Satan ago angelo nenaq gimen tiqeman usaqta haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na ezaqgo kwaziqmo ya igemnan moqad ossa ne didaq a hi yagiy haqdaq ham. Ya yuwnan moqsa ne yuw a hi yagiy haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ya mat begbegta iyim bolan ne ya iwaqim ilowan a hi toniy haqdaq ham. Ya ibe aholmo luwsa ne tubusan a hi yagiy haqdaq ham. Ya moqad ussa teq ya iqirquran ossa ne bolim ya a hi ibiyiy haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Haqid teq mataw na in ago gamuk amenin emeq bilaq daqay, Iyahta haq daqay kam gineh ni nigemnan moqsa teq ni yuwnan moqsa teq ni begbeg iyim bolsa teq ni nibe aholmo luwsa teq ni moqad ossa teq ni niqirquran ossa i ni a hi nilumsih? haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Haqid teq in on mataw na gigo gamuk amenin emeq bilaqdaq, Ya helmo ne gibilenaiq haqdaq ham. Ne ya isenlul ka gigo araq abin haiqta ago hib nagah na a hi emim na ne yaqgo hib a hi emiymo haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nazaq iyid on mataw na leheq santitiy waqad tuqos daqay ham. Osad tuteqmo in gisan titiydaq ham. Sa on mataw dimdimunta na in God ago maror aduganib gwahtiqeq ginad dimniysa kuluwa-kuluwmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Yesus gamuk na bilaq bugan tihiqiyan in ago disaipel gibilan, Kam giger le tihiqiyid teq i gigo lotu akaman ayahta anan Pasova haqay na tugwahtiqdaq ham. Na ne tuhuritiy ham. Kam na gwahtiqid teq in Mat Atatin bab gibenab emid in ayib dom tuwol daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ari kam nab mataw tamaz emayta gigo aseseqta na giyogniz Juda gigo mataw marorta na nenaq in tamaz mat danmebta anan Kayafas haqayta na ago bitab humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Humab wolim in on mataw gime titoneq Yesus wazeq wol emid moqdaqta na agamukan tibilaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Admo in bilaqiy, I Pasova akamnib Yesus ulalabmo a hi wazam haqiy. Luweq on mataw biyahta na gigem meqniysa bab araq ayahta wazid eraqdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ari Yesus uliq Betaniy-ib mat araq kwaziqmo aholib moq lepra usim tihiqiyta anan Saimon haqayta na ago bitab os. ");
INSERT INTO mlp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ossa aw araq Yesus ago hib tubol. In kagoh araq amikta gig anan alabasta haqay na sisoqim emiyta nab in masil ahuran dimunta anawun ayahmota tenim teq in wazim a bol. A bolim Yesus banab ossa in masil na Yesus afaqnib wazbalan tuwom. ");
INSERT INTO mlp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Anmo Yesus ago disaipel daq na ahol waqim in gigem meqniysa bilaqiy, Nagaqgo in masil dimunta ko abu ulumaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Masil ko i mat araq inaq zayeq mani ayahmo waq nagta haqiy. Waqeq i mataw ginaghan haiqmo osayta na neg nagta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Haqan Yesus in gigo gamuk na huritim gibilan, Nagaqgo ne aw ka afaqan ugay? ham. In ya ilowan tonim daq dimunta tiqem yag ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tutimmo mataw ginaghan haiqta na ne nenaq osayta ham. Ari ya nenaq tuteqmo a hi osdaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aw ka iholib masil wazbalta ka in ya ihol wastitayeq hodhodab iqemgo haqad in amta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ya helmo ne gibilenaiq ham. Mataw edobya leheq ya iwagamun dimunta bilaqad in aw ka daq amta ka awagamun tibilaq daqaymo ham. Bilaqsa mataw huritad teq in aw ka anadin tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ari kam nab disaipel 12 na gigo araq anan Judas uliq Kariyot-ib haqayta na in mataw tamaz emayta gigo aseseqta gigo hib tilah. ");
INSERT INTO mlp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Lehim in gibilan, Ya Yesus ne gibenab emid teq ne naga diq yag daqay? ham. Haqan mataw na Yesus ayon banzaw emim in mani silva 30 nazaq Judas tuqugiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ugan nab Judas in Yesus waqeq mataw na gibenab emdaqta adanteqin araq dimunta tinagunyaq. ");
INSERT INTO mlp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ari bret yis haiqmo neqayta na akaman tugwahtim. Gwahtiqan disaipel Yesus ago hib bolim tisusumun ugiy, Ni ninad i bit edob leheq ninmen nagah wastitayid teq ni Pasova adidaqan neqdaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Haqan in gibilan, Ne le uliq kob gwahtiqeq mat araq ahol waqad teq ne kazaq buloniy ham. Iyahta bilam, Yaqgo kam na bolim sinsin tiqiy haqiy ham. Yaqgo disaipel nenaq ningo bitab Pasova adidaqan neqnan haqad ne buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Haqan Yesus gibilanta nazaqmo in lehim Pasova adidaqan neqgo abanan tuwastitayiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ari imisor diq tiqiyan Yesus in ago disaipel 12 na nenaq didaq neqnan banab tuqos woqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Os woqim osad in didaq neqadmo Yesus gibilenim bilam, Ya helmo ne gibilenaiq ham. Ne gilikmanib teq mat araq ya iwaqeq bab gibenab iqemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Haqan disaipel gihol afaqan diq iysa in amulik-mulikmo Yesus susumun ugad bilaq yaqay, Iyahta yaqmo ye? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Haqsa Yesus amenin emim gibilan, Mat ya inaq degib aben eman womta naqmo teq ya iwaqeq bab gibenab iqemdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","God ago mar Mat Atatin anan bilamta nazaqmo diq in dan muzeq tilehdaqta ham. Teq mat in Mat Atatin bab gibenab emdaqta na timeqniy hasdaq ham. Mat na anen a hi em nagta in am ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Haqan Judas mat Yesus waqeq bab gibenab emdaqta na bilam, Iyahta yaqmo ye? ham. Haqan Yesus bulon, Ninmo nawa tibilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ari in didaq neqad osad Yesus bret asor waqim God esey ugim in orqayim ago disaipel negad gibilan, Ne bret ka waqeq neqiy ham. Ka ya inon ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Haqad in wain agogin inaq waqim God esey ugim teq in negad gibilan, Ne bunmo ka waqeq uluwiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ka ya inedan God ago maror muturta na zaway ugdaqta ham. Ya ned ka on mataw kabemmo gigo daq meqinta giwalemgo wazbaldaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya ne gibilenaiq ham. Ya wain ayun ka a ta hi uluwdaiq ham. Abeb ya nenaq ya imam ago maror muturta aduganib osad teq ya wain ayun ka a ta uluwdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Admo in bunmo lotu ago bar araq wazim hulosadmo in uliq hulosim garah Oliv-ub tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ari Yesus in ago disaipel nenaq lehad gibilan, Tarom kab ya iholib afaqan araq meqin diq gwahtiqsa ne bunmo ya ibiyad ne ginad ya inan helmo haqayta na hulosad gileh tiyag daqay ham. Na ezaqgo God ago marib gamuk araq kazaq bilam ham. Ya mat sipsip giwamuzaqta na wol emsa in ago sipsip haresmo tukeq tileh daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ari ya hodhodab eraqeq teq ya ameb saw Galiliy-ib tilehdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Haqan Pita gamuk na amenin emim bilam, Mataw ka bunmo in ni afaqan waqsa nibiyad in ginad helta hulosad gileh nigsa ya haiq ham. Ya ni ninan helmo haqaiqta na hulosad gileh a hi nigdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Haqan Yesus bulon, Ya helmo nibilenaiq ham. Tarom kab kurek a hi gayonsamo ni nime ezeqmanmo gileh tiyagdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Haqan Pita bilam, Haiq ham. Mataw ya ninaq ginol emnan bilaqsa ya gileh a hi nigdaiq ham. Hikidik ham. Haqan disaipel bunmo nazaqmo bilaqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ari Yesus ago disaipel nenaq og araq awaqan dimunta anan Getsemaniy haqaytab tilehiy. Lehim in ago disaipel gibilan, Ne kab osiysa ya kob leheq God inaq gamuk emnan ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Haqadmo in Pita teq Sebediy atatniz giger na giwaqim nenaq tilah. Lehad in ahol afaqan iysa ahol meqin diq tiloyinyaq. ");
INSERT INTO mlp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ad in gibilan, Ya ihol afaqan diq iysa tumoqnan tonaiq ham. Ya nenaq kab saw waqad osuq ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Haqad in gihulosim asitmo ta leh nog iyim in anobun ban woqim usad God buloneq bilaqyaq, Ya imam haqyaq ya iholib afaqan ayahta ka aban emdaiqta adanteqin ussun teq ni ya iqisihun haqyaq. Ari ni ninad nazaq a hi usid teq ni ya inad ka hi muz haqyaq. Ninmo ninad muz haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Haqad in eraqim ago disaipel ezeqman na gigo hib muleqim ta lehim in ussa gibiy. Gibiyad in Pita bulon, Ezaq? ham. Ne asitmo ya nenaq saw waqad a hi osam e? ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ne saw waqad God inaq gamuk emad osiy ham. Gamuk emad daq ne gilum waqdaqta na bo giholib gwahtiqsa ne hi woqgo haqad buloniy ham. Helmo ne ya inad muznan ginad bilaqaqta teq ne gihol awaz meqin haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Haqad in ame gigerta lehim God inaq gamuk emim bilam, Ya imam ham. Afaqan ka ya iban a hi emid ari ni ninad usaq naqmo ya iholib gwahtiqan ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Haqad in muleqim ta lehim disaipel ezeqman na gime rursa ussa in gibiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Gibiyad gihulosim ta lehim ame ezeqmanta in God inaq gamuk a ta am. Teko in gamuk bilamta nazaqmo in a ta bilaq ton. ");
INSERT INTO mlp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bilaqim tihiqiyan in disaipel gigo hib ta lehim gibilan, Ne ginamur emad us tutay ye? ham. Ahol waqiy ham. Muran in Mat Atatin waqeq mataw meqinta gibenab emdaqta na akaman tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ne eraqiysa i lehuq ham. Ahol waqiy ham. Mat ya iwaqeq bab gibenab iqemdaqta na bo tugwahtim ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ari Yesus nazaq gamuk bilaqad tursamo disaipel 12 na gigo araq anan Judas haqay na tubol. Bolsa mataw dauh biyahta baqir sebur wazim ad Judas inaq boliymo. Mataw tamaz emayta gigo aseseqta na teq Juda gigo mataw marorta na in bab mataw na giqeman boliyta. ");
INSERT INTO mlp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ari mat Yesus bab gibenab emdaqta na in naga daqin emid in Yesus ahol waqad waz daqayta na ago in teko tigibilanta. In bilam, Ya leheq mat nog ya wazeq ilawundaiqta naqmo ne waziy ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nazaq iyan in hid naqmo Yesus ago hib loqimmo tibilam, Iyahta ham tarom dimun ham. Haqadmo in tiqilawun. ");
INSERT INTO mlp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ilawunan Yesus bulon, Kadoy ham ni nagah emnan bolta na ni hidmo em ham. Haqsamo mataw na eraqim Yesus tuwaziy. ");
INSERT INTO mlp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wazsamo mataw Yesus inaq turiyta na gigo araq ago baqir hureq hasim wam. Waqim in tamaz mat danmebta ago kabibiy mat araq wolim adeksanmo qwatayan ogib tuwom. ");
INSERT INTO mlp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Anmo Yesus bulon, Ningo baqir asanib ta sihen ham. Mataw baqirib an wolayta na baqiribmo tumoq daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ni a hi hurit daqagya ham. Ya imam susumun ugid in angelo kabemmo diq tiyagdaq ham. Angelo na ginulinqan in mataw bab emayta gidauhan 12 nazaq giquriyam daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ta teq ya daq nazaq emeq ya God ago gamuk a hi wol net bugdaiq ham. Daq kagan bunmo ya iholib gwahtiqdaqta agamukan God ago marib mar tonan usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Haqadmo in mataw biyahta na gibilan, Ne baqir sebur wazim a boliyta ka ne mat rin tonaqta waznan boliy ye? ham. Kam kabemmo ya on mataw suleq negad Tempel-ib ossa ne ya a hi iwaziy ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Teq daq ka bunmo agamukan God ago nantut mar tonan usaqta nazaqmo in ya iholib tugwahtiq bugaq ham. In nazaq haqanmo disaipel bunmo Yesus hulosim titukiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ari mataw Yesus waziyta na in waqim ad tamaz mat danmebta Kayafas ago hib tilehiy. Bit nab mataw Moses ago gunun hurit kemiyta na teq Juda gigo mataw marorta na in tekomo bo humab tuwolim osiyta. ");
INSERT INTO mlp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Teq mataw Yesus wazim a lehsa Pita in Yesus muzim lehad teq in pesan nog lehyaq. In lehim tamaz mat danmebta na ago bit agelin aduganib le gwahtiqim in mataw Tempel-ib hurmey gan turayta na nenaq tuqos, in nagah teq gwahtiqdaqta na ahol waqgo haqad. ");
INSERT INTO mlp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ari mataw tamaz emayta gigo aseseqta na teq Juda gigo kaunsel ayahta na amatawun bunmo in mat araq Yesus ago hib nan katiyta bilaqid teq in wol emid moqgo na tinagun yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sa mataw kabemmo gwahtiqim Yesus amalib nan katiyta em yaqay. Ta teq mataw aseseqta na in gamuk araq amalib Yesus wol em daqayta na a hi hurit yaqay. Sa abeb diq mataw giger tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Gwahtiqim in bilaqiy, Mat ka bilam, Ya God ago Tempel wol inereq kam ezeqmanmo aduganib ya wazid a ta eraqdaq haqad in bilamta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Haqan tamaz mat danmebta na eraqim turad in Yesus bulon, Mataw ni ninan gamuk bilaqayta ka in ezaq diq? ham. Ni gamuk na araq amenin a hi emdaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Haqan teq haiq. Yesus aqezmo hiqiyim tur. Sa tamaz mat danmebta na bulon, God kayeqmo osaqta na nibiysa ni hel diqtaqmo bilaq ham. Mat anan Krais haqayta na amatin ninmo ye? ham. Ni God atatin e? ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Haqan Yesus bulon, Ninmo nawa tibilam ham. Ta teq ya ne gibilenaiq ham. Muran teq abeb Mat Atatin in God Awaz Meqin Diqta aben aqabun ban ossa ne ahol tuwaq daqay ham. Ahol waqsa in kaitab onqas amalib oseq bolsa ne ahol tuwaq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesus nazaq bilaqanmo tamaz mat danmebta na era inmo aholib tubusan bulsireqim bilam, Mat ka God tibilawun ham. Mat araq in ayon nan araq ta hi bilaqan ham. In kawaqmo God bilawunim gamuk bilaqsa ne tuhuritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ne in ago daq na ulum kemim ginad ezaq emay? ham. Haqan mataw na bilaqiy, Mat daq nazaq amta na in moq nagta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Haqad in Yesus anobun kusluw ugad tuwol yaqay. Wolad asor amanmanan wolad bulon yaqay, Ni ninan Krais haqayta ye? haq yaqay. Ni God ago nantut iyeq teq ni i gibilen haq yaqay. Nog diq kawa ninolaqta ka ni anan biysa i hurituq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ari Pita asanib bit aqezab os. Ossa kabibiy aw araq in agerab loqim bilam, Ni inaqmo Yesus saw Galiliy-ibta na inaq osta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Haqan Pita mataw bunmo gimeb bilam, Haiqgam ham. Ya ni gamuk bilaqaqta na inad a hi emaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Haqad in lehim bit na agelin ago dan ezab tur. Tursa aw ta araq Pita ahol waqadmo in on mataw nab osiyta na gibilan, Mat ka in Yesus uliq Nasaret-ibta na inaq osta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Haqan Pita ahol ulilemim bilam, God Ulilibta ibiysa ya helmo bilaqaiq ham. Ya mat na ago a hi huritta ham. ");
INSERT INTO mlp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Abeb mataw nab turiyta na Pita agerab loqim buloniy, Hel diqtaqmo haqiy. Ni mataw ko gigo araq haqiy. I ni niziyan alulin tuhurit kem haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Haqan Pita bilam, God Ulilibta ibiysa ya bilaqaiq ham. Ya mat na ago a hi huritta haqaiq ham. Ya helmo a hi haqid teq God ya inol eman ham. Haqanmo kurek tigayon. ");
INSERT INTO mlp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Gayonanmo Pita in Yesus gamuk bilamta na anadin tiqam. Yesus bilam, Kurek a hi gayonsamo ni nime ezeqmanmo gileh tiyagdaq ham. Pita gamuk na anadin emad in asan ban lehim gaq naqmo diq hiqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ari saw tihastitayan mataw tamaz emayta gigo aseseqta na teq Juda gigo mataw marorta na bunmo in Yesus ayon dan emid Rom mataw in wol emid moqdaqta na ago in bilaqim teq in an adugan tuwaziy. ");
INSERT INTO mlp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","An adugan wazim teq in Yesus irqurim wazim ad lehim Rom gigo maror saw Judiya wamuzim osta anan Pailat haqay na tuqugiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ari Judas mat Yesus bab gibenab amta na in mataw Yesus ayon hazizir emim anan bilaqiy, In moqan haqsa in tigibiy. Gibiyim in anad ta buliyim mani silva 30 na waqim ad mataw tamaz emayta gigo aseseqta na giyogniz mataw marorta na nenaq gigo hib a ta lah. ");
INSERT INTO mlp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A lehim in gibilan, Ya daq meqinta tiqem ham. Ya mat dimunta bab gibenab eman in tumoqdaq ham. Haqan mataw aseseqta na buloniy, Na i gigo nagah a haiq haqiy. Na ninmo ningo nagah haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Haqan Judas Tempel aqezab mani silva na hunegad in lehim amub yuk tonim inmo ahol anatguman hihiqim tumom. ");
INSERT INTO mlp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ari mataw tamaz emayta gigo aseseqta na in mani silva na waqim bilaqiy, Mani ka mat anedan anawunta haqiy. I Tempel-ib mani usaqta na inaq wastoneq na i gunun tiqitiyonam haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Haqad in an bulonim teq in mani na amalib og araq zayiy. Og na kwaziqmo mataw reb emayta na leheq og soskaq waq yaqayta asawun. Mataw aseseqta og na zayid in mataw Jerusalem-ub bolim begbeg osim moqayta gimen hodhod iydaqta haqad in zayiyta. ");
INSERT INTO mlp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nazaq iyan mataw og na anan Ned Aqogin bilaqad luwim bo muran in bilaq tutayta. ");
INSERT INTO mlp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Daq nazaq gwahtiqim kwaziqmo God in ago nantut Jeremaya aqezab gamuk bilamta na in tuwol net bug. Gamuk na bilam, Isrel on mataw in mat na zaynan haqad in mani silva 30 nazaq anan bilaqiyta ham. Bilaqim in mat na zayim amenin nazaqmo tuwaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","In mani na waqim a le mataw reb emayta na aqogin tizayiy ham. Iyahta ibilanta nazaqmo in emiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ari mataw Yesus wazim a lehim Pailat ameb eman tursa Pailat tisusumun ug, Ni Juda on mataw gigo king e? ham. Haqan Yesus bilam, Ninmo nawa tibilam ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Haqan mataw tamaz emayta gigo aseseqta na teq Juda gigo mataw marorta na in Yesus amalib nan kabemmo em yaqay. Emsa teq Yesus gamuk araq amenin a hi emyaq. ");
INSERT INTO mlp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nazaq iyan Pailat bulon, Ni gamuk nimalib emayta ko a hi huritaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Haqan teq haiq. Yesus in Pailat ago gamuk amenin a hi emad in mataw nan kabemmo ug yaqayta na gigo gamuk araq diq amenin a hi bilammo. Nazaq iyan Pailat anadnad diq emyaq. ");
INSERT INTO mlp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ari ulig bunmo Juda gigo lotu akaman ayahta nab Pailat bit giqirquran osayta nab mat araq hasid gwahtiqyaqta. Juda on mataw in mat araq anan bilaqid Pailat naqmo hasid in gigo hib lehyaqta. ");
INSERT INTO mlp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ari kam nab mat araq meqin diqta anan Barabas haqayta na irquran os. ");
INSERT INTO mlp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ossa on mataw bo humab tuwolim ossa Pailat gibilan, Ya nog diq hasid ne gigo hib lehgo ne ginad usaq? ham. Ya Barabas hasdaiq o haiq, ya Yesus, mataw anan Krais haqayta na has negdaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Na ezaqgo Pailat anad tiqam, Yesus in Juda gigo mataw aseseqta na gibayan woqiyta na ago in gigem meqniysa amalib nan emay ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ari Pailat in ago ban in mataw gigo afaqan huritim gilum kemaqta nab osad gamuk bilaqsa awe inmen nantut araq kazaq eman bolan in hurit. Ni mat titnonta na ago hib daq araq hi em ham. Taromab ya in asenan qwayim ya ihol afaqan diq iyaq ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ari mataw tamaz emayta gigo aseseqta na giyogniz mataw marorta na nenaq in gigo walmataw gamuk awaz meqinta gibilenad in ginad tubuliyiy. Ginad buliyan mataw biyahta na in Barabas hasad Yesus wol emid moqgo haqad Pailat tubulon yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bulonsa Pailat a ta gibilan, Ya mataw giger ka gilikmanib nog diq hasid gwahtiqeq samanmo tiluwdaq? ham. Haqan in bilaqiy, Barabas haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Haqsa Pailat gibilan, Nazaq na teq ya Yesus mataw anan Krais haqayta ka ezaq ton ugdaiq? ham. Haqan mataw na bunmo bilaqiy, Ayib dom woliy haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Haqan Pailat bilam, Nagaqgo? ham. Mat ka naga daqin meqinta am? ham. Haqsa teq haiq. Mataw na dedibmo lileyim a ta bilaq toniy, Ayib dom wolid moqan haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sa Pailat ago gamuk loyinan in amomo iy. On mataw na in anad a hi muzad in bab ayahta wazid tiqeraqnan tonyaq. Nazaq iyan Pailat in on mataw bunmo gimeb yuw waqim aben suholad bilam, Mat ka anedan woqid na yaqgo afaqan a haiq ham. Na negmo gigo afaqan ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Haqan on mataw na bunmo amenin emim bilaqiy, Afaqan ka i gigo hib teq i gigo onmin gigo hib tuboldaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nazaq iyan Pailat in Barabas hasan mataw gigo hib tilah. Lehsa in ago mataw gibilenan in warig waqim hiklaquwim amalib Yesus tuwoltitayiy. Woltitayim hulosan Pailat Yesus ayib dom wolgo haqad ago mataw bab emayta na gibenab tiqam. ");
INSERT INTO mlp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ari Pailat ago mataw bab emayta na in Yesus waqim ad le Pailat ago bit aduganib tugwahtiqiy. Gwahtiqim in giyogniz bunmo gibilenan bolim in Yesus lilut ugim turiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Turad in Yesus ago tubusan hasad teq in tubusan araq sisaqta kakaqta amalib ahol tiqisihiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Isihim teq in am asasuqin inaqta tal tonim king ago balaw nogta afaqnib emiy. Ad in tuqir araq gwatuq nog haqad aben aqabnib emim teq in anognib gibakbakan ulum laquwim turad in bilawunim bulon yaqay, Mat ayah haq yaqay. Ni Juda gigo king-mo diq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Haqad in kusluw ugad teq in tuqir abenab waqim afaqin wol yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mataw na Yesus bilawunim hulosadmo in tubusan sisaqta na hasim waqad inmo ago tubusan na aholib ta em ugim teq in ayib dom wolnan haqad waqim ad tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ari in Yesus waqim ad tilehad teq in mat araq uliq Sairin-ibta anan Saimon haqayta ahol tuwaqiy. Ahol waqad in mat na Yesus ago ay sorgo haqad abe yahan in ay na sorim ad mataw na nenaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lehim in garah akululqan araq anan Golgota haqaytab tugwahtiqiy. Gamuk Golgota na alulin in ‘Gifaqin Agolgolan’ haqayta. ");
INSERT INTO mlp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","In saw nab gwahtiqimmo bab mataw na wain ayun teq masil araq agon meqinta anan gal haqayta inaq buliyim Yesus uluwgo haqad ugiy. Ugan in uluw waqim teq in hulosim a ta hi uluw bug. ");
INSERT INTO mlp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","An bab mataw na Yesus ayib dom tuwolim teq in gig amikmikta hunegad Yesus ago tubusan nagan iberim giholyon tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Waqim teq in saw nabmo os woqim Yesus wamuzim tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ad Yesus naga daqin eman in ayib dom woliyta na ananin mar tonim afaqnib ulilib tuqotheniy. Gamuk na in kazaq mar toniy. ");
INSERT INTO mlp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ad teq in Yesus agerab mataw rin tonayta gigermo ayib dom giwoliymo. Dom wolan araq Yesus aben aqabun ban tursa araq aben anasaran ban turyaq. ");
INSERT INTO mlp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Sa on mataw bo lehad in Yesus ahol waqad bilawun yaqay. Bilawunad gifaqin lelad teq in bilaq yaqay, Mat Tempel wol inereq kam ezeqmanmo aduganib wazid a ta eraqdaqta na amatin ninmo haq yaqay. Nazaq iyan ni niwaz meqniyeq ninmo nihol ulumsih haq yaqay. Ni God atatin iyeq teq ni ay na huloseq gehitiq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Sa mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na teq Juda gigo mataw marorta nagan in nazaqmo Yesus bilawuneq bilaq yaqay, In mataw asor gilumsihan a hi moqiyta haq yaqay. Ta teq inmo ahol ulumsihgo ago zaway haiqta haq yaqay. In Isrel gigo king daqag haq yaqay. Nazaq iyan in ay huloseq gehitiqan haq yaqay. Gehitiqid teq i anan helmo tihaqam haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mat ko bilam, Ya God atatin hamta haq yaqay. God teq tiqilumsihdaq hamta haq yaqay. Ari God in mat ko anan anad bilaqid teq in ulumsihid hi moqan haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sa mataw giger girin inaqta Yesus agerab ayib dom woliyta na in nazaqmo Yesus bilawun yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ari zeq gabolim liqabmo tiqiysa saw bunmo romriq iyad le 3 kilok imisor tiqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ad 3 kilok imisor nazaq tiqiyanmo Yesus dedibmo lileyim bilam, Eli Eli lama sabaktaniy? ham. Gamuk na in kazaq bilam, Yaqgo God Yaqgo God nagaqgo ni ya ihulosaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Haqanmo mataw asor nab turiyta na in Yesus aqez huritim bilaqiy, Ko Elaija lilewunaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sa hid naqmo in gigo araq sibim lehim tubusandek waqim tuqir amotnib am wazim teq in wain ayun agon iyta ulum turim Yesus ateb tiqam, in sisowdaq haqad. ");
INSERT INTO mlp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Samo mataw ta asor bilaqiy, Hulossa i ahol waqad teq haqiy. Elaija boleq ulumsihdaq o haiq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Haqanmo Yesus dedibmo a ta lileyimmo tumom. ");
INSERT INTO mlp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Moqanmo tubusan ayahta Tempel-ib othenan usta na ulilib liqabmo tartayim giger iyim bo ogibmo tuwom. Woqsamo og ahol wolsa gig aseseqta timizilayiymo. ");
INSERT INTO mlp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sa mataw moqiyta gigo hodhod giqez hassa God in ago on mataw tawonta kwaziqmo tumoqiyta na kabemmo giwazan tiqeraqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Eraqim abeb Yesus ta eraqan teq on mataw na hodhod hulosim le God ago uliq tawonta Jerusalem-ub gwahtiqsa mataw kabemmo tigibiyiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ari bab mataw Yesus wamuzim osiyta na gigo ayahta inaq in daq nagan gwahtiqsa ahol waqad teq og ahol wolsa in loyinad in gihol rab naqmo diq hiqiy yaqay. Ad in bilaqiy, Helmo diq haqiy mat ko in God atatin haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sa on kabemmo pesanmo nog turad teq in nagah na ahol waqad turiy. On na Galiliy hulosim Yesus muzim inaq bolad in ulumsih yaqayta. ");
INSERT INTO mlp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","In gilikmanib Mariya uliq Magdala-ibta na teq Jems ayow Josep inaq ginen anan Mariya haqayta na teq Sebediy atatniz giger na ginen in nab turiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ari imisor tiqiyan uliq Arimatea-ib mat araq ago mani kabemmota na tubol. In anan Josep haqayta. Teq in inaqmo Yesus anan helmo hamta amatin araq. ");
INSERT INTO mlp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","In bo Pailat ago hib gwahtiqim in Yesus asan waqeq a le yay tongo tisusumun ug. An Pailat in ago mataw bab emayta gibilenan in Yesus asan waqim Josep tuqugiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ugan in Yesus asan waqim tubusan husta anumlan haiqta amalib tiqil ton. ");
INSERT INTO mlp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Il tonim in sorim a le inmo ago hodhod muturta na aduganib tiqam. Hodhod na in gig qwayim amta. Nab in Yesus asan emad teq in gig araq ayahta otbuliyim a le hodhod aqez ituqimmo in tilah. ");
INSERT INTO mlp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Lehsa Mariya uliq Magdala-ibta na ayow Mariya araq na inaq in giger hodhod ago dan ezab pesan nog tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ari Juda gigo lotu ayon nagah wastitayayta akaman na tihiqiy. Hiqiyan Juda gigo lotu akaman diq na tugwahtiqan nab mataw tamaz emayta gigo aseseqta na giyogniz Farisi nenaq in le Pailat ago hib humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Humab wolim in bilaqiy, Mat ayah haqiy mat akatiynaqta na osad in gamuk araq bilamta na i anadin emauq haqiy. In bilam, Kam ezeqmanmo tihiqiyid ya ta eraqdaiq hamta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nazaq iyan ni bab mataw asor giqemid leheq in hodhod na wamuz naqmo diq hiqiysa le kam ezeqmanta nabmo iyan haqiy. Luweq mat na ago disaipel boleq asan rin toneq teq in on mataw gibilen daqay, In hodhodab tiqeram haq daqay haqiy. In on mataw nazaq kat negid luweq on mataw bunmo mat akatiynaq na anan helmo haq daqay haqiy. Ad nan katiy abebta na in nan katiy kwaziqta na uriyamdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Haqan Pailat bilam, Ya bab mataw asor giqemid tileh daqay ham. Lehsa ne nenaqmo leheq gibilenid in mat momta na ago disaipel gitawanan osiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Haqan mataw aseseqta na in bab mataw asor nenaq hodhodab lehim gig ayahta nab Pailat ananib tarin emim teq in bab mataw na giqeman in hodhod wamuzim tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ari Juda gigo lotu akaman tihiqiyan Sande tarommo saw tihastitaynan tonsa Mariya uliq Magdala-ibta na ayow Mariya araq na inaq in hodhod ahol waqnan tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","3","Lehsa Iyahta ago angelo araq Heven hulosim bo ogib hitiqim in gig hodhod aqezab usta na otbuliyan lehan teq in gwalim amalib tuqos. Angelo na ahol awaqan bilaqne mewlig hikliyanaqta nazaq nog iyyaq. Sa ago tubusan in hus didiq bilaqne onqas ahus gan nog. In gehitiqim nazaq emsamo kanawrigrig araq ayahta tisib. ");
INSERT INTO mlp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sibsa mataw bab emayta na in angelo na ahol waqad in rabunad gibensen harara nemsa in mataw moqiyta nogmo tiqiyiy. ");
INSERT INTO mlp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","An teq angelo na in on giger na gibilan, Ne hi rabiy ham. Ne Yesus mat ayib dom woliyta na nagunim boliyta na ya tuhurit ham. ");
INSERT INTO mlp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Na in kab haiq ham. In tiqeram ham. Kwaziqmo in bilamta nazaqmo ham. Ne giger boleq in usta asawan ka ahol waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ahol waqad teq ne hidmo leheq in ago disaipel gibileniy ham. Gibilenad ne kazaq bilaqiy ham. God Yesus hodhodab wazan tiqeram haqiy ham. Eraqim in ameb Galiliy-ib tilehaq haqiy ham. Nab teq ne in ahol tuwaq daqay haqad ne gibileniy ham. Ari yaqgo nan nawaqmo ham. Ya ne tigibilen ham. ");
INSERT INTO mlp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ari on giger na rabad teq in ginad tidimniyaqmo. Ginad dimniysa in hodhod hulosad Yesus ago disaipel gibilennan sibim tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lehsamo danib Yesus on giger na gibiyad in “Tarommo dimun” nag. Negan on giger na agerab loqim asen wazim ayon lotu tiqemiy. ");
INSERT INTO mlp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Samo Yesus gibilenim bilam, Ne hi rabiy ham. Ne giger leheq ya imagniz gibilenid in Galiliy-ib lehiy ham. Nab teq in ya tiqibiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","On giger na danib lehad luwsa bab mataw disaipel gitawanan osiyta na gigo asor uliq aduganib gwahtiqim tilehiy. Lehim nagah bunmo gwahtimta na ago in mataw tamaz emayta gigo aseseqta na tigibileniy. ");
INSERT INTO mlp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Gibilenan tamaz mataw aseseqta na in Juda gigo mataw marorta na nenaq humab wolim in gamuk emim an adugan tuwaziy. An adugan wazim in bab mataw na mani kabemmo negiy. ");
INSERT INTO mlp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Negad in gibileniy, Ne kazaq bilaqiy haqiy. Taromab i ussa Yesus ago disaipel bolim asan rin toniy haqad nazaq ne bilaqiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ari Pailat ne gibin meqinta nazaq na huritid i tubulonam haqiy. Bulonsa ne gibin meqinta na ago afaqan a hi waq daqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Haqan bab mataw na mani na waqim in mataw aseseqta na giqez tumuziniy. Nazaq iyan Juda on mataw wagam katiyta na huritim bilaqad luwim bo muran in bilaq tutayta. ");
INSERT INTO mlp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ari disaipel 11 na saw Galiliy-ib lehad luwim le Yesus garah anan gibilenim bilam, Nab ne lehiy hamta nab in tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Gwahtiqim in Yesus ahol waqad teq in ayon lotu tiqemiy. Lotu emad in gilikmanib asor ginad giger em yaqay. ");
INSERT INTO mlp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sa Yesus in gigerab bolim kazaq gibilan, God zaway bunmo yagan ya Heven-ib teq ogib kab nagah bunmo giwamuzim osaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nazaq iyan ne ya ibin og saw bunmo ad leheq on mataw bunmo gibileniy ham. Gibilenad ne Gimam Iyahta teq in Atatin teq in ago Bugaw Dimunta ginanib ne mataw huz negiy ham. ");
INSERT INTO mlp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Huz negad ne gamuk bunmo ya tigibilenta na asuleqin negsa in muzin bugiy ham. Ne nazaq on mataw giqemsa in yaqgo disaipel iyiy ham. Ne huritiy ham. Ya kam bunmo ne nenaq ossa le og ka ago kam abebtanta na tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mar ka in Yesus Krais God atatin awagamun dimunta usaqta. ");
INSERT INTO mlp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Teq wagam ka alulin in kwaziqmo God ago nantut Aisaya gamuk mar tonta nazaqmo tugwahtimta. Gamuk na bilam, Ahol waqiy ham. Ya teq mat araq emid in yaqgo gamuk ad danmeb lehdaq ham. Leheq in ninmen dan tuwastitaydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mat na aqez saw amatawun haiqtab lileyim bilaqaq, Ne Iyahta ayon dan balaw toniy haqaq ham. Ad ne in ayon dante na wastitayid titnonan haqaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","An abeb Aisaya mat anan bilamta na amatin gwahtiqim saw amatawun haiqtab osad in on mataw tuhuz negyaq. In anan Jon haqayta. Ad in kazaq mataw gibilenyaq. Ne ginad buliyeq ne gigo daq teq ginad meqinta bunmo gileh ugiy haqyaq. Gileh ugad ne bolsa ya huz negiq haqyaq. Ne nazaq emsa teq God in ne gigo daq teq ginad meqinta na tigiwalem bugdaq haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Haqsa mataw saw Judiya-ibta teq uliq Jerusalem-ubta kabemmo in Jon ago gamuk huritnan agerab tubol yaqay. Bolad in gigo daq teq ginad meqinta ulum hassa Jon giqad le yuw Jodan-ib tigihuz negyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ago tubusan karuw anan kamel haqayta na asan ulim emiyta. Teq in karuw asan asor am gan nog ahulib am wazeq luwyaqta. Luwad in kasum teq garanab kubiq akokin neqad luwyaqta. ");
INSERT INTO mlp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ad in mataw kazaq gibilenyaq, Mat araq teq ya ibeb boldaqta na abin in ya ibin uriyamta haqyaq. Ya in ahaqenibta haqyaq. In yaqgo Iyahta haqyaq. Ya in ago kabibiy mat samanta haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ya ne yuwibmo huz negaiqta haqyaq. Ari mat ayahta na boleq teq in God ago Bugaw Dimunta amalib ne tuhuz negdaq haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kam nab Yesus uliq Nasaret saw Galiliy-ibta hulosim bolan Jon yuw Jodan-ib in tuhuz ug. ");
INSERT INTO mlp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Huz ugan Yesus hidmo yuw hulosim dubub gwaladmo ame ulilib gwalehim kait misireq nog iyim aqez hasim ussa in ahol wam. Ahol waqsa God ago Bugaw Dimunta ah husta nog iyim in amalib tigehitim. ");
INSERT INTO mlp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gehitiqan Heven-ib God aqez bilam, Ni ya itatin ham. Ya ni ninan inad bilaqsa ya igem dimun diq iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ari God ago Bugaw Dimunta in Yesus eman saw araq amatawun haiqtab tilah. ");
INSERT INTO mlp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Lehim saw nab in kam 40 nazaqmo didaq haiqmo os. Ossa Satan gwahtiqim Yesus daq araq meqinta emdaq haqad tuqulum waqyaq. Saw nab Yesus amomo karuw kwasikta nenaq osyaq. Ossamo angelo bolim in tuqulumsih yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ari mataw in Jon wazim bit giqirquran osaytab eman ossa teq abeb Yesus saw Galiliy-ib gwahtiqim God ago gamuk dimunta on mataw tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","In bilaqyaq, God kwaziqmo kam anan bilam teq gwahtiqdaq hamta na muran tugwahtim haqyaq. Gwahtiqan God ago maror bolim sinsin tiqiy haqyaq. Ne ginad buliyad gigo daq meqinta gileh ugiy haqyaq. Ad ne God ago gamuk dimunta ka anan helmo haqiy haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ari Yesus yuw-kurorqan Galiliy aqurumnib lehad luwim in Saimon amikqan Andru inaq dob hunegim nabiq waqad luwsa tigibiy. In giger kabiy naqmo em yaqayta amatawun. ");
INSERT INTO mlp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus mataw giger na gibiyad gibilan, Ne ya imuzeq boliy ham. Bolsa ya giqisihunid ne nabiq waqayta nazaqmo teq ne mataw tigiwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Haqan hidmo giger na dob hulosan ussa in Yesus muzim inaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesus in giger na nenaq asitmo ta leh nog iyimmo in Sebediy atatniz giger Jems ama Jon inaq tigibiy. In nazaqmo muyib osad dob wastitayad osiy. ");
INSERT INTO mlp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ossa Yesus giger na gililewunan in gimam Sebediy ago kabibiy mataw nenaq gihulosan muyib ossa in Yesus muzim inaq tilehiymo. ");
INSERT INTO mlp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ari Yesus mataw na nenaq le uliq Kapaneam-ub tugwahtiqiy. Gwahtiqim Juda gigo lotu akamnib Yesus le Juda gigo bit humab wolaytab gwahtiqim mataw suleq negad tuqosyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Suleq negsa mataw huritad gihol turuh nem yaqay. Na ezaqgo Yesus ago gamuk in mataw Moses ago gunun hurit kemiyta na gigo gamuk nog a hi iyyaq. In ago gamuk bilaqne God inmo abin ugan in suleq bilaqaqta nazaq nog iyyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Samo mat araq ago bugaw meqinta inaqta bolim bit na aduganib gwahtiqim in lileyim bilam, Yesus Nasaret-ibta ham, ni i ezaq gitonnan bol? ham. Ni i gimeqin tonnan daqag ni bolya ham. Ya ningo tuhurit ham. Ni God ago mat tawon diqta naqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Haqsa Yesus wadim bulon, Ni niqez hiqiy ham. Bugaw meqinta ni mat na hulosad gwahtiqeq leh ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Haqan bugaw meqinta na in mat na eman woqim abensen hunegsa bugaw na ek tonim gwahtiqimmo tituk. ");
INSERT INTO mlp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tukanmo mataw bunmo daq na ahol waqad ginadnad emad teq in an bulon yaqay, I kwaziqmo nagah araq kazaqta ahol a hi wawta haq yaqay. Ka naga daqin diq? haq yaqay. Ka suleq muturta ago azawayin inaqta haq yaqay. Mat ko bugaw meqinta gamukmo gibilensa in aqez huritayta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nazaq iyan mataw kabemmo in Yesus daq amta na abin eman saw Galiliy-ib uliq bunmo tuhuritiy. ");
INSERT INTO mlp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ari Yesus bit na hulosim in Jems ama Jon inaq giwaqim nenaq Saimon ama Andru inaq gigo bitab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lehanmo mataw bit nabta Yesus buloniy, Saimon alen moq ayahta waqim asan afanfan iyad nawa banab usaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Haqan Yesus aw na agerab lehim abenab wazim wazan tiqeram. Eraqim in asan afan iyim usta na tuhulos ug. Hulos uganmo in era lehim Yesus ago mataw na nenaq gimen didaq anaran usta na waqim a bolim tinag. ");
INSERT INTO mlp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Ari teq zeq wolehsa imisor diq tiqiyan on mataw uliq nabta na bunmo Yesus ago hib bolad teq in giyogniz asor gigo moq inaqta na teq asor giholib bugaw meqinta usaqta na in giwaqim nenaq boliy. Bolim in Yesus bit osaqta na aqezab humab wolim turiy. ");
INSERT INTO mlp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tursa Yesus nazaq gibiyad in mataw giholib moq amo amo usta na giwastitayad in gigo bugaw meqinta na gimuzan titukiy. Bugaw meqinta na in Yesus ahol alulin in God atatin na ago tuhuritiyta. Nazaq iyan Yesus ginadad gimuzad gibilenyaq, Ne giqezmo hiqiyeq lehiy haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ari Yesus usim tarom asor ussamo in bit na hulosim saw araq amatawun haiqtab tilah. Lehim in amomo God inaq gamuk emad tuqos. ");
INSERT INTO mlp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ossa teq Saimon ayogniz nenaq Yesus nagunim tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lehim ahol waqad teq in buloniy, Mataw kabemmo ninagunad luway haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Haqan Yesus bilam, Nab iysa i uliq sinsin sinsin usayta kogabmo lehuq ham. Leheq ya God ago gamuk in tigibilendaiqmo ham. God ya iqeman ya kabiy naqmo emnan bolta ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Haqad in saw Galiliy ago uliq bunmo tilehyaq. Lehad in mataw gigo bit humab wolaytab gwahtiqeq gamuk dimunta gibilenad teq in mataw gigo bugaw meqinta tigimuzyaq. ");
INSERT INTO mlp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ari Yesus daq nazaq emad luwsa mat araq aholib moq lepra inaqta in agerab tubol. Bolim in Yesus anognib abakbakan ulum laquwim turad kuh tonim in anad meqniysa bulon, Yesus ham ni ninad bilaqsa teq ni ya iwastitayid ya God ameb isan anumlan ka tihiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Haqan Yesus anad meqniysa in aben itiwunim mat na wazad bulon, Ya inad bilaqaq ham. Ni nisanib ninumlan usaqta na hiqiyan ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Haqan muran diq nawaqmo mat na ago moq lepra tihiqiy. ");
INSERT INTO mlp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Hiqiyan Yesus mat na eman lehsa in adek wazim bulon, ");
INSERT INTO mlp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ni hurit ham. Daq muran kawa ya niholib emta ka ni mat araq hikidik bulon ham. Ni leheq mat tamaz emaqta naqmo nihol isihun ham. Ad Moses bilamta nazaqmo ni nihol dimniyta na anawun em ham. Emid teq mataw in ningo moq tihiqiyta na ago tuhurit daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Teq haiq. Mat na lehim nagah bunmo in aholib gwahtimta na in mataw haresmo tigibilan. Nazaq iyan Yesus uliq-uliqgo lehad mataw gimeb a ta hi gwahtiqyaq, luweq ya in gimeb luwsa in bo ya iqisih net daqay haqad. Nazaq haqad in le saw amatawun haiqta nagab luw osyaqta. Ossa on mataw uliq saw bunmo in saw nabmo leheq Yesus ahol waq yaqayta. ");
INSERT INTO mlp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ari kam asor le tihiqiyan Yesus uliq Kapaneam-ub a ta lah. Lehim ossa mataw Yesus bolim bitab osaqta na ago tuhuritiy. ");
INSERT INTO mlp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Huritim mataw kabemmo bolim bit nab humab wolan ban tihiqiy bug. Bit aqezab nazaqmo ban haiq tiqiymo. Na matawmo osan lah. Sa Yesus gamuk dimunta tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Gibilenad ossa mataw aweweqmo in mat araq moqaqta banab emim sorim a boliy. Mat na abensen aditin moqan in asit a hi luwyaqta. ");
INSERT INTO mlp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ari in mat na a bolan bit nab mataw ban tuwaq bugan in ad Yesus agerab loqgo dan haiq. Nazaq iyan in bit ahuqunib gwalehim Yesus osaq diqta nab in asor tihikneriy. Hiknerim in mat moqaqta na abanan inaqmo am emim Yesus osaqta nabmo eman tuwolah. ");
INSERT INTO mlp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wolehan Yesus mataw na ginad helta ahol waqadmo in mat moqaqta na tubulon, Yaqgo amun ham ya ningo daq meqinta tigiwalem bug ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Haqan mataw Moses ago gunun hurit kemiyta na asor Yesus agerab osad in ginadibmo susumunim bilaqiy, ");
INSERT INTO mlp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Nagaqgo mat ka God ago ban waq nog iyim kazaq God bilawunaq? haqiy. Og kab mat araq mataw gigo daq meqinta walemdaqta haiqgam haqiy. Naqmo God amulikmoqmo ago kabiyta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mataw na nazaq ginadib susumunsa Yesus giloyin kemim gibilan, Doq tonnan ne ginad haresmo nazaq emay? ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ya naga gamukin bilaqid teq ne nan a hi yag daqay? ham. “Ya ningo daq meqinta tigiwalem” haqdaiq o “Ni eraqeq ningo ban waqeq a leh” haqdaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Teq Mat Atatin in og kab daq meqinta walemgo azawayin aholib usaqta na ago ne hurit daqay haqad ya kazaq diq bilaqdaiq ham. Haqad in mat abensen moqan banab usaqta na tubulon, ");
INSERT INTO mlp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ya nibilenaiq ham. Ni eraqeq ningo us ban waqeq ad ningo bitab a leh ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Haqanmo mat na eraqim mataw na gimeb ago ban sorim ad ago bitab tilah. A lehsa mataw bunmo gihol ritensa in God abin iluwad bilaq yaqay, I nagah kazaqta kwaziqmo ahol a hi wawta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ari Yesus yuw-kurorqan Galiliy aqurumnib a ta lehan mataw kabemmo in agerab tuboliy. Bolan Yesus in God ago suleq tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Gibilenad osim teq in era lehad luwim in Alfiyus atatin Liway ahol tuwam. Mat na takis abitnib ago kabiy takis waqad ossa Yesus ahol waqad tubulon, Ni ya imuzeq bol ham. Haqanmo Liway eraqim Yesus muzim inaq tilah. ");
INSERT INTO mlp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ari abeb Yesus in Liway ago bitab didaq neqad tuqos. Ossa mataw gibin meqinta takis waqayta teq mataw daq meqinta emayta nenaq kabemmo bolim Yesus ago disaipel nenaq bit nab didaq neqad tuqosiymo. Mataw naqanta kabemmo Yesus muzinad inaq luw yaqayta. ");
INSERT INTO mlp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","In bunmo nazaq Yesus inaq didaq neqad ossa Farisi asor gibiyad osim in Yesus ago disaipel tigibileniy, Nagaqgo Yesus in mataw daq meqin emayta ko teq mataw takis waqayta ko nenaq didaq neqaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Haqsa Yesus huritim gibilan, Mataw gigo moq haiqta na in le dokta ahol a hi waqayta ham. Mataw gigo moq inaqta naqmo dokta ago hib lehayta ham. Ya on mataw titnonta gililewunnan a hi bol ham. Ya on mataw daq meqinta emad osayta naqmo gililewunnan bolta ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ari Jon mataw huz negyaqta na ago disaipel teq Farisi nenaq in tuteqmo didaq udin yaqayta. Nazaq iyan mataw asor bolim Yesus buloniy, Ezaqgo Jon ago disaipel na teq Farisi gigo disaipel na in udinsa ta ningo disaipel a hi udinayta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Haqan Yesus gamuk awowun araq kazaq gibilan, Mat araq aw waqnan tonsa in ayogniz boleq inaq osad in ginad meqniysa didaq udin daqay ye? ham. Haiqgam ham. Mataw na giyow inaq osad iyan in didaq a hi udin daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ari abeb mataw asor boleq mat aw waqaqta na ayogniz gibenab tuwaq daqay ham. Kam na teq boldaqta ham. Bolid kam nab teq mat na ayogniz didaq tuqudin daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Haqad in bilam, Mataw tubusan muturta waqim amalib tubusan kwaziqta misiramta na inaq a hi initayta ham. In nazaq toneq abeb in tubusan kwaziqta na suholsa tubusan muturta na irnik toneq le amik iyadmo in tubusan kwaziqta na bulsireqid ayahmo diq a ta tartaydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Teq mataw wain ayun muturta memeq asan kwaziqtab a hi tenayta ham. In nazaq tonid wain aqurin gwalad huhuw nemsa memeq asan kwaziqta na tartayid wain ayun mutbaleq ogib woqsa memeq asan na timeqniydaqmo ham. Nazaq iyan mataw memeq asan muturtamo waqim wain ayun muturta tenayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ari teq Juda gigo lotu akaman araqab Yesus ago disaipel nenaq kabiy araq wit leyiyta aduganib gwahtiqim tileh yaqay. Lehad in ago disaipel gigem moqsa wit anagin asor tuguraq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Guraqsa Farisi asor gibiyad in Yesus buloniy, Ni ko gibiy haqiy. Nagaqgo in lotu akaman ago gunun itiyonim kabiyab wit tuguraqay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Haqan Yesus gibilan, Nabag ne Devit ago dauh nenaq in nagah osgo siqim iyim gigemnan moqad teq Devit daq amta na awagamun ne ahol a hi waqiy-ya ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tamaz mat danmebta Abiyatar akamnib Devit le God ago bit aduganib gwahtiqim God ameb bret eman usta na waqim tinam ham. Bret na gunun emiyta ham. Mataw tamaz emayta naqmo gimomo bret na neqayta ham. Teq haiq ham. Devit agem moq titaysa neqad in bret tawonta na asor in ayogniz negan tineqiymo ham. Ta teq in daq meqinta a hi emiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Haqad in gibilan, God mataw gimeqin tonnan lotu akaman eman a hi gwahtim ham. Haiq ham. In mataw gidimun tonnan haqad lotu akaman eman gwahtimta ham. ");
INSERT INTO mlp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nazaq iyan Mat Atatin in lotu akaman anamrenmo diq iyim inmo mataw kam nab ezaq luw os daqayta na ago tigibilendaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ari kam araqab Yesus in Juda gigo bit humab wolaytab tilah. Lehan mat araq aben akogan anedan mayim aditinmo usaqta in nab os. ");
INSERT INTO mlp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ossa Yesus ago bab in Yesus wamuzim nab osiymo, Yesus i gigo lotu akaman kab mat ka wastitayid dimniyid i amalib nan emam haqad. ");
INSERT INTO mlp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Haqsa Yesus mat aben meqinta na tubulon, Ni boleq mataw ka gimeb tur ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Haqad in mataw na tisusumun nag, I Juda gigo maror ezaq usaqta? ham. Lotu akamnib i mataw gidimun tonamta o i gimeqin tonamta? ham. Kam na i mat moqaqta ulumsihamta akaman o i mat na aholib hiqiyid in moqdaqta akaman? ham. Haqan mataw na giqezmo hiqiyim osiy. ");
INSERT INTO mlp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ossa Yesus in mataw na bunmo ginad ahol waqim le bolsa in ginad soqotim us. Ussa Yesus ahol afaqan diq iyad in mataw na ginan agem timeqniy. Agem meqniysa in mat na bulon, Ni niben itiwun ham. Haqan mat na aben itiwunan aben akogan na tidimniy. ");
INSERT INTO mlp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dimniyan Farisi na hidmo lehim in Herot ago dauh nenaq humab wolim osad in ezaq toneq Yesus wol emid moqdaqta na agamukan tibilaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ari Yesus ago disaipel nenaq yuw-kurorqan Galiliy-ib tilehiy. Lehsa mataw kabemmo Yesus muzim inaq tilehiymo. ");
INSERT INTO mlp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Sa mataw saw Galiliy-ibta teq saw Judiya-ibta teq uliq Jerusalem-ubta teq saw Idumea-ibta teq mataw kabemmo yuw Jodan aqurumnibta teq uliq giger Tair teq Saidon-ibta nagan kabemmo diq in kabiy daq bunmo Yesus emyaqta na abin huritim in agerab tuboliymo. ");
INSERT INTO mlp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bolan Yesus in ago disaipel gibilan, Ne yaqmen muy araq ahol waqid teq usan ham. Luweq mataw ka ya iqisih daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Na ezaqgo Yesus in mataw kabemmo gigo moq tuwastitayan iyan biyahta na gigo asor gigo moq inaq na bunmo in agerabmo diq loq yaqay, i Yesus wazeq teq gihol tidimniydaq haqad. ");
INSERT INTO mlp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sa mataw gigo bugaw meqinta inaq na in Yesus ahol waqadmo in anognib woqeq usad lileyeq bilaq yaqay, Ni God atatin haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Haqsa in bugaw meqinta na atoran diqmo gibileneq bilaqyaq, Ne ya ihol abin na ulalab hi bilaqiy haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ari kam araqab Yesus garah araqab tugwalah. Gwalehim in mataw asor in ginan anad bilaqaqta naqmo gibilenan agerab tuboliy. ");
INSERT INTO mlp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Bolan in mataw 12 nazaq gitowun emim ginan Aposel haqad tibiy. In anad mataw na in inaq ossa teq in giqemid in uliq-uliqgo lehad inmo ahol abinib ago gamuk dimunta na gibilenad teq in bugaw meqinta gimuz daqay haqad in anad am. ");
INSERT INTO mlp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ari in mataw 12 giwamta na ginan kazaq: Saimon, Yesus anan araq Pita haqad biyim ugta. ");
INSERT INTO mlp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Teq Sebediy atatniz Jems ama Jon inaq. Yesus in maqbab giger na ginan araq Bowanerges haqad biyta. Nan Bowanerges na alulin mat ago daq atoranta kait ahulan iyaq nazaq nogta haqayta. ");
INSERT INTO mlp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Teq Andru teq Filip teq Bartolomyu teq Matyu teq Tomas teq Alfiyus atatin Jems teq Tadiyus teq Saimon, mat Rom nenaq bab emyaqta amatin na teq Judas uliq Kariyot-ibta na. Mat naqmo Yesus waqim bab gibenab amta. ");
INSERT INTO mlp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ari Yesus bitab tilah. Lehan mataw in ahol waqnan haqad lehim bit nab humab a ta woliy. Humab wolim ossa Yesus ago disaipel nenaq in gikabiyan kabemmo emad didaq neqgo akaman haiq iy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sa Yesus asenlul huritim in Yesus waqnan haqad tuboliy, i gigo amun ahol agadan tiqiy daqag haqad. ");
INSERT INTO mlp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sa mataw Moses ago gunun hurit kemiyta na asor Jerusalem-ub osim gewoqim osad teq in bilaqiy, Bugaw meqinta gigo amebta Belsebul in Yesus aholib usaq haqiy. Ussa Yesus in Belsebul ago zaway amalib bugaw meqinta gimuzaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Haqan Yesus in mataw aseseqta na gibilenan agerab bolan in gamuk awowun araq kazaq gibilan, Ezaq teq Satan inmo ago dauhta tigimuzdaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kantri araq ago on mataw gihol husereq an gihar ugad an wolad osad in zaway iyeq a hi tur daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Teq bit araqab on mataw gihol husereq an gihar ugad an wolad osad in zaway iyeq a hi tur daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ad nazaqmo Satan ago dauh nenaq gihol huserad an geg ugad Satan zaway iyeq a hi turdaq ham. In tihiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Haqad in bilam, Mat araq in mat awaz meqinta ago bit aduganib samanmo gwahtiqeq ago nagah a hi ginuwdaq ham. Haiq ham. In mat awaz meqinta na abensen irqureq teq in mat na ago bit aduganib gwahtiqeq ago nagah tiginuwdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ya helmo ne gibilenaiq ham. God in on mataw gigo daq meqinta teq in bilawunayta na bunmo tigiwalem bugdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ari on mataw God ago Bugaw Dimunta bilawunid God in gigo daq meqinta na a hi walemdaq ham. Haiq ham. Daq meqinta na in giholib tuqus tutdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Na ezaqgo mataw aseseqta na Yesus anan bilaqiy, In aholib bugaw meqinta usaq haqiyta na ago Yesus nazaq gibilan. ");
INSERT INTO mlp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ari kam nab Yesus anen teq in amagniz bolim asanib turad in Yesus ayon nan eman tilah, in gigerab boldaq haqad. ");
INSERT INTO mlp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Teq mataw kabemmo Yesus lilut ugim osiy. Osad in Yesus buloniy, Ni ko gibiy haqiy. Ni ninen teq ni nimagniz bolim asanib kowa turad in ni ninan saw waqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Haqan Yesus amenin emim gibilan, Ya inen teq ya imagniz gingan diq? ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Haqad in on mataw lilut ugim osiyta na gibiyim le bolim bilam, Ne ahol waqiy ham. Ya inen teq ya imagniz kawa osay ham. ");
INSERT INTO mlp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mat aw nog in God anad muzad ago kabiy emayta naqmo in ya ima teq in ya ihiy teq in ya inen ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ari kam araqab Yesus yuw-kurorqan Galiliy aqurumnib mataw suleq a ta gibilenyaq. Gibilensa mataw kabemmo bolim Yesus agerabmo diq loqsa iyan in giban emim muy araqab gwalim yuwmeb tuqos. Ossa mataw bunmo yuw aqurumnib osiy. ");
INSERT INTO mlp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ossa Yesus suleq kabemmo negad gamuk amo amo tigibilenyaq. Gibilenad in kazaq bilam, ");
INSERT INTO mlp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ne huritiy ham. Mat araq ago kabiyab wit anagin hunegnan tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","In lehim wit anagin hunegad luwsa asor dan adekib woqan ah bolim tineqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Teq wit anagin asor saw agigin inaqtab og asitmo usaqta nab wom ham. Woqim og ayah diq haiqgam iyan wit hidmo tugwal ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","An zeq gwalim oysa wit na aninin haiqgam iyan in mayim tumom ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Teq wit anagin asor am asasuqin inaqta aduganib wom ham. Woqan am asasuqin inaqta na gwalad isihan wit na anon a hi am ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Teq wit anagin asor og dimuntab woqim ahokan gwalim anon tiqam ham. Wit anagin na asor anon 30 nazaq giqam ham. Sa asor anon 60 nazaq giqam ham. Teq asor anon kabemmo diq 100 nazaq giqam ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Haqad Yesus gibilan, Mat aw nog in gidek nan huritgo usaqta na in gamuk ka hurit kemiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Abeb mataw biyahta na haresmo tilehsa Yesus ago disaipel 12 na teq mataw asor nenaq in Yesus lilut ugim osad gamuk awowun in bilaqyaqta nagan ago tisusumun ugiy. ");
INSERT INTO mlp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Susumun ugan in gibilan, Negmo God ago maror aduganib osayta ham. Nazaq iyan ya God ago maror abe alulin ulilemim usaqta na bilaqsa ne huritayta ham. Teq mataw God ago maror asan ban osayta na ya gamuk awowunmo amalib gibilenaiqta ham. Ya nazaq gitonsa, ");
INSERT INTO mlp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Mataw na gime saw waqad teq in nagah araq ahol a hi waqayta ham. In gamuk huritad teq in ginad a hi em hasayta ham. Luweq in ginad em hasad ginad buliyid God in gigo daq meqinta na tigiwalem nag ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Haqad Yesus gibilan, Ne gamuk awowun ka ago ginad a hi em hasay ye? ham. Ne gamuk awowun ka alulin ginad em haseq teq ne yaqgo gamuk awowun bunmo ago ginad tiqem has daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ari ne huritiy ham. Wit anagin na in God ago gamukmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sa mataw asor in wit anagin dan adekib woqaqta na nog ham. In God ago gamuk huritiyta nabmo Satan bolim God gamuk dimunta mataw na gigemab layta na ta walemaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Teq mataw asor in wit anagin og agigin inaqtab woqaqta na nog ham. In God ago gamuk huritim in ginad bilaqsa hidmo waqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Teq mataw na in bilaqne wit aninin haiqta nog ham. In God ago gamuk na gigemabmo diq a hi wazad in muzinad sisaqmo a hi luwayta ham. Na ezaqgo in God muzayta na ago mataw in gimeqin tonad afaqan amo amo negsa in God hulosayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Teq mataw asor in wit anagin am asasuqin inaqta amuganib woqaqta na nog ham. Mataw na God ago gamuk huritayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Teq in og ka ago nagah kabemmo anadin emsa mani-mo kat negad ginad hureqsa in nagah kabemmo diq utetayta ham. Ginad meqinta na ginadib bolad in God ago gamuk isihaqta ham. Isihsa iyan gamuk na in gigemab anon a hi emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Teq mataw asor in wit anagin og dimuntab woqaqta na nog ham. In God ago gamuk huritim in waqim wazayta ham. An gamuk na in gigemab anon emaqta ham. Mataw na asor gigemab God ago gamuk anon 30 nazaq giqemaqta ham. Sa mataw asor gigemab God ago gamuk anon 60 nazaq giqemaqta ham. Teq mataw na asor gigemab God ago gamuk anon kabemmo diq 100 nazaq giqemaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ari teq Yesus bilam, Mataw lam miderim kuramab a hi sihenayta ham. Ad in ban ahaqenib a hi emaytamo ham. In lam miderim ulilib othenan oyad usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nazaq iyan nagah bunmo ulilemim usaqta na in teq ulal tiqiydaq ham. Teq nagah bunmo giqisihan usaqta na in teq saw anuwanib tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mat aw nog in gidek inaq iyeq teq in gamuk ka huriteq ginad emiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Haqad Yesus gibilan, Gamuk ne huritayta ka ago ne ginad em hasiy ham. Mat God ago gamuk huritad anad a hi em hasaqta na, God in mat naqanta anad emid a hi hastitaydaq ham. Ari mat God ago gamuk huritim anad em hasaqta na, God in mat naqanta anad emid ayahmo diq tihastitaydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Na ezaqgo God in on mataw gigo nagah inaqta na bunmo nagah asor a ta negdaq ham. Ad in mataw ginaghan haiqta na gibenab nagah asitmo wazayta na tigiwalem bugdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Haqad Yesus gamuk awowun araq kazaq ta bilam, God ago maror in bilaqne mat araq didaq anagin ogib hunegaq nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mat na taromab usad zeqab in luwsa ago didaq gwalim ezaq ayah iyaqta na ago in a hi huritaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Og inmo didaq eman kabiyab gwalaqta ham. Danmeb diq ahokan gwalaqta ham. Ahokan sisaq iyim in azizorin emaqta ham. Ari abeb in anon emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Anon na gihemeq ussa teq mat na baqir waqeq a le tigiqurotdaq ham. Na ezaqgo in didaq waqgo akaman tugwahtim ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Haqad Yesus bilam, Ya naga diq atowun emeq bilaqid teq ne God ago maror anan ginad em daqay? ham. Teq ya naga gamukin amalib awowun hulsa ne hurit kem daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ari God ago maror na in bilaqne ay mastet anagin amulikmo nog ham. Mataw ay anagin na kabiyab leyan in didaq anagin bunmo giquriyamim amik didiq iyim usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Teq abeb in gwalim ayah iyim in kwasin-kwasan kabiyabta na bunmo giquriyamim turaqta ham. In gwalim aben aseseqmo iyan ah bolim abenab giririn emim amurnib osayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ari Yesus in on mataw God ago gamuk gibilenad in gamuk awowun kabemmo amalib nazaqmo gibilenyaqta. Gibilenad mataw naga gamukin hurit daqayta na in anad emadmo in gamuk awowun nazaqmo gibilenyaqta. ");
INSERT INTO mlp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Teq in gamuk araq diq alulin a hi gibilenyaq. Haiqgam. In gamuk awowunmo gibilenyaq. Ari in ago disaipel-mo nenaq giholbinmo osad teq in gamuk alulin tigibilen kemyaqta. ");
INSERT INTO mlp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ari kam nabmo imisor Yesus in ago disaipel gibilan, I yuw urumun kozaq ban lehuq ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Haqan disaipel in mataw biyahta na gihulosadmo in Yesus muy amalib osta nab le gwalim Yesus inaq tilehiy. Lehsa mataw asor gimuyin inaqta na Yesus muzim inaq tilehiymo. ");
INSERT INTO mlp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lehsa tim ayahta eraqad yuw eman sortukim muy amuganib woqad ate tugwalnan tonyaq. ");
INSERT INTO mlp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ari na teko Yesus muy abe ban hartiy qwayim tuqus. Ussamo tim eraqsa ago disaipel bo bulonan in kayeq tiqiy. Kayeq iyan in buloniy, Tisa haqiy, i tumoqnan tonauq haqiy. Ni i ginan ninad a hi meqniyaq e? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Haqan Yesus eraqim tim wadad teq in yuw atoranmo bulon, Muleqeq woq ham. Haqanmo tim hiqiysa yuw midemim ahol a ta hi wol. ");
INSERT INTO mlp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","An Yesus in ago disaipel gibilan, Ne nagaqgo kazaq rabay? ham. Ne ezaq tonim God anadin a hi emay? ham. ");
INSERT INTO mlp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Haqan disaipel rabad in an tubulon yaqay, Mat ka nog diq? haq yaqay. Tim yuw inaq in aqez huritayta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ari Yesus ago disaipel nenaq le yuw urumun kozaq ban tugwahtiqiy, uliq Gerasa gigo og saw ban. ");
INSERT INTO mlp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Gwahtiqim Yesus muy hulosim itiqsamo mat araq ago bugaw meqinta inaq luwaqta na hodhod hulosim in agerab tubol. ");
INSERT INTO mlp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Mat na hodhodabmo luw osyaqta. Ossa mataw in wazan yo hiqiy yaqayta. In mat na aben amub am wazan haiq. Ad in sen-ib am wazan haiqmo. Kam kabemmo in abensen sen-ib am waz yaqayta teq in sen na gibultayad hankap asenab usta na wolzilayyaqtamo. In mat awaz meqin diqta. ");
INSERT INTO mlp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sirisirimo zeqab teq taromab in hodhodab teq garahab osad in ek tonad inmo ahol asan gigib qwatayyaqta. ");
INSERT INTO mlp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ari mat na Yesus pesanmo bolsa ahol waqad in sibim bolim Yesus anognib abakbakan ulum laquwim tur. ");
INSERT INTO mlp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Turad in dedibmo lileyim bilam, Yesus ham ni God Ulilibta atatin ham. Ni ya ezaq itonnan bol? ham. Ya God ameb nibilenaiq ham. Ni santitiy hi yag ham. ");
INSERT INTO mlp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Na ezaqgo Yesus tekomo tubulon, Bugaw meqin ham ni mat ka hulosad gwahtiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Haqad teq in susumun ug, Ni ninan ezaq? ham. Haqan in bilam, Ya inan Kuluwmo ham. Na ezaqgo i mataw kabemmo diq ham. ");
INSERT INTO mlp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Teq mat na anad awaz meqin amalib ame kabemmo Yesus bulonyaq, Ni saw kab bugaw hi gimuz haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Haqsa bul gihumaban araq ayahta didaq neqad garah amanmanib sinsinmo turiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tursa bugaw meqinta nagan ginad meqniysa Yesus buloniy, Ni i giqemid i bul ko gimuganib le woquq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Haqan Yesus bilam, Lehiy ham. Haqanmo mat aholib bugaw meqinta giqusiyta na gwahtiqim le bul na gimuganib tuwoqiy. Woqanmo bul bunmo sibim wole garah asibsibranib bayhilek tonim yuwmeb woqan yuw gineqanmo tumoq bugiy. Bul na bunmo gigo ginulinqan 2,000 nazaq. ");
INSERT INTO mlp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ari mataw bul giwamuzim osiyta na in daq na ahol waqad titukiy. Tukim lehad uliqab teq saw haresmo in nagah ahol waqiyta na awagamun tibilaqiy. Bilaqsa on mataw huritim in nagah na ahol waqnan tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lehim in Yesus ago hib bolim mat kwaziqmo bugaw meqinta kabemmo amuganib usiyta na in ahol tuwaqiy. Mat na anad dimunta waqim tubusan welim ossa in ahol waqad tirabiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Rabsa mataw gimeb daq ahol waqiyta na in mat kwaziqmo bugaw meqinta aholib usiyta na awagamun gibilenad teq in bul ago bilaq toniy. ");
INSERT INTO mlp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bilaqan mataw na Yesus abe yahad buloniy, Ni saw ka huloseq leh haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Haqan Yesus le muyib tugwalsa mat bugaw meqinta aholib usan in gimuzta na in inaqmo lehnan anad bilaqsa in anad awaz meqin amalib Yesus bulonyaq, Ya ninaq lehdaiq haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Haqsa Yesus hulos. Hulosad in mat na bulon, Ni ningo uliqab nisenlul gigerabmo leh ham. Leheq teq Iyahta daq ayah diqmo em nigta na teq in ni ninan anad meqniyta na ni gibilen ham. ");
INSERT INTO mlp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Haqan mat na saw anan Dekapolis haqayta nab lehim uliq bunmo luwad in nagah Yesus inmen amta na tibilaq bugyaq. Sa mataw bunmo huritim gihol turuh nemyaq. ");
INSERT INTO mlp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ari teq Yesus ago disaipel nenaq yuw-kurorqan Galiliy urotim aqurumun kozaq ban ta lehiy. Lehan mataw kabemmo bolim Yesus agerab humab tuwoliy, yuw na aqurumnib. ");
INSERT INTO mlp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Humab wolim Yesus inaq nab ossa Juda gigo bit humab wolayta ago danmebta araq anan Jairus haqay na bolim Yesus asen agerab ahol hulosan wom. ");
INSERT INTO mlp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ahol hulosan woqim usad in anad meqniysa ame kabemmo bulonyaq, Yaqgo amun aw amikta tumoqnan diq tonaq haqyaq. Ni boleq niben aholib emeq wazid in ahol dimniyeq hi moqan haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Haqan Yesus in inaq ago bitab tilah. Lehsa on mataw kabemmo Yesus muzim inaq lehad teq in aholib soqotim diq inaq leh yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lehsa aw araq moqad sirisirimo ned hunegyaqta na in Yesus muzim mataw na nenaq tilehyaqmo. Ulig 12 nazaq moq na aholib usta. ");
INSERT INTO mlp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ussa mataw gime inaqta santitiy ayahmo ug yaqayta, in ahol dimniydaq haqad. Teq haiq. Aw na ago mani kabemmo mataw na gigo hib hulos bugta teq in ago moq na asit a hi hiqiyyaq. Haiqgam. In aholib moq ayahmo diq iyyaq. ");
INSERT INTO mlp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ari aw na Yesus ahol awagamun huritim in anad tiqam, Ya iben Yesus ago tubusanmo wazeq teq ya ihol tidimniydaq ham. Haqad in bolim mataw biyahta na gilikmanib gwahtiqim nenaq lehad in Yesus abun ban loqimmo aben le in ago tubusan tuwaz. ");
INSERT INTO mlp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wazimmo in ago ned muran diq nawaqmo tumay. Mayan aholib moq tihiqiyan in ahol tiloyin. ");
INSERT INTO mlp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Loyinsa Yesus ago zaway asor tuhulos ugim lahta na ago in ahol tiloyinmo. Nazaq iyan in ahol buliyim bilam, Nog aben yaqgo tubusan waz? ham. ");
INSERT INTO mlp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Haqan ago disaipel buloniy, Ni mataw kabemmo soqot nigim ninaq lehayta ka a hi gibiyaq e? haqiy. Ni nagaqgo susumunim bilam, Nog aben yaqgo tubusan waz ham? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Haqan teq haiq. Yesus saw waqim le bol, nog diq daq na amta na ago haqad. ");
INSERT INTO mlp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sa aw na in nagah aholib gwahtimta na ago anad emad in tirabyaq. Rabad in bolim Yesus anognib abakbakan ulum laquwim turad nagah aholib gwahtimta na in tibilaq bug. ");
INSERT INTO mlp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bilaq bugan Yesus bulon, Ya imiy ham ni ya inan helmo hamta naqmo niqeman ni nihol tidimniy ham. Ningo moq tihiqiyan ni le nigem dimniysa os ham. ");
INSERT INTO mlp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ari Yesus gamuk bilaqad nab tursamo Jairus ago bitab mataw asor osim bolim in gigo mat ayahta na danib ahol waqad buloniy, Ningo amun aw tumom haqiy. Nagaqgo i Tisa atuw a ta bulam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Haqan Yesus gamuk na ago adek a hi emad in Jairus bulon, Ni hi rab ham. Ni God amomo anan helmo haq ham. ");
INSERT INTO mlp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Haqad teq in on mataw bunmo giwasihan nab tursa in Pita teq Jems ama Jon inaq naqmo giwaqim nenaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Lehim in Jairus ago bitab tugwahtiqiy. Gwahtiqim in mataw ek tonad gaq wazad ossa tigibiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Gibiyad in lehim gibilan, Ne nagaqgo gaqad saw zunad osay? ham. Amun aw na a hi mom ham. In usaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Haqan on mataw na bunmo in aqez tiyuquwuniy. Yuquwunsa Yesus gimuzan asanib gwahtiqsa in amun anen amam teq inmo ago disaipel ezeqman na giwaqim nenaq bit adugan amun usaqta nab le tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gwahtiqim in amun na aben wazim in Juda gigo nanib bulonim kazaq bilam, Talita kumi ham. Na in kazaq bilam, Amun aw amik, ni eraq ham. ");
INSERT INTO mlp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Haqan hidmo in eraqim tiloq gelyaq. (Amun aw na ayah tiqiy bugim in ago ulig 12 nazaq tiqiyta.) An amun anen amam in nagah na gimeb ahol waqim in gihol turuh nem naqmo diq hiqiy. ");
INSERT INTO mlp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sa Yesus atoranmo gibilan, Nagah ka ago ne mat araq hikidik buloniy ham. Haqad in amun didaq ugid neqgo gibilan. ");
INSERT INTO mlp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ari Yesus uliq na hulosim inmo ago uliq diq Nasaret-ib lehsa in ago disaipel muzim inaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lehim Juda gigo lotu akamnib Yesus bit humab wolaytab gwahtiqim in mataw God ago gamuk tigibilenyaq. Gibilensa mataw kabemmo Yesus ago gamuk huritad in gihol turuh nemsa bilaq yaqay, Mat ko gamuk bilaqaqta na in edob diq wam? haq yaqay. In anad usaqta ko ezaq diqta in wam? haq yaqay. In ezaq diq tonim anad emsamo nagah gwahtiqaq? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mat ko in igmo gisenlul araq haq yaqay. In bitmo emaqta amatin araqta haq yaqay. In anen Mariya teq in amagniz Jems teq Josep teq Judas teq Saimon kawa osay haq yaqay. Teq ahiyan kawa i nenaq osauqmo haq yaqay. In nazaq haqad Yesus anan gigem timeqniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Gigem meqniysa Yesus gibilan, Mat God ago nantut bilaqaqta na abin uliq bunmo usaqta ham. Ari inmo ago uliqab teq in asenlulib teq in ago bitabmo diq in ahol abin haiqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nazaq iyan in daq azawayin inaqta araq diq uliq nab a hi emyaq. In mataw gigo moq inaqta naqmo amulik-mulikmo giholib aben emim giwazsa in dimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Teq mataw uliq nabta na in anan helmo a hi haqsa iyan in anadnad emyaq. Yesus in ago disaipel ago zaway giqisihunsa teq in ago a hi hurit kem yaqay Ari Yesus saw nab uliq-uliqgo luwad in God ago gamuk on mataw tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","In nazaqmo emad luwim kam nab in ago disaipel 12 na gibilenan boliy. Bolan inmo ahol abinib bugaw meqinta gimuzgo azawayin in negim teq in giqeman giger giger tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Lehsa in gibilan, Ne lehad es araq waqeq ad hi lehiy ham. Ne katekmo wazeq ulum ugeq a lehiy ham. Teq ne ziy araq es sihengo hi waqiy ham. Ad didaq araq neqgota ad hi lehiymo ham. Teq mani araq ne giholib hi usanmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ne gigo gisendugan gisenab tiqem daqay ham. Teq ne tubusan gigermo gihol siheneq hi lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Haqad in gibilan, Ne uliq araqab le tugwahtiqeq bitbitmo leheq hi osiy ham. Bit amulikmo ne os daqayta nabmo ne osiy ham. Oseq teq ne era uliq araqab lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ari ne le uliq araqab gwahtiqid mataw uliq nabta na in ne gibaymuzad gigo gamuk a hi huritsa teq ne uliq na huloseq uliq ta araqab lehiy ham. Lehad ne gisen aqogin uliq nab wolhamid woqan ham. Woqid teq mataw na in gigo daq na anadin tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Haqan disaipel lehim on mataw gibileneq bilaq yaqay, Ne ginad buliyeq gigo daq meqinta gileh ugiy haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Haqad in bugaw meqinta kabemmo gimuzad teq in mataw gigo moq inaqta na giholib masil emad giwastitay yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ari mataw saw nabta gigo king Herot in Yesus abin tuhurit. Na ezaqgo Yesus abin saw bunmo lehim ayah tiqiy bug. An mataw asor in anan bilaq yaqay, Jon mataw huz negyaqta na moqan God hodhodab wazan ta eram haq yaqay. Nazaq iyan in aholib zaway ayahmo usaqta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sa mataw asor bilaq yaqay, Ko Elaija haq yaqay. God mat emid bo Iyahta ayon dan wastitaydaqta na amatin inmo haq yaqay. Teq mataw asor bilaq yaqay, Ko God ago nantut araq haq yaqay. Mataw kwaziqmo God ago nantut bilaq yaqayta naqanta araq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Haqsa Herot gamuk na huritim bilam, Kwaziqmo ya bilaqan Jon mataw huz negyaqta na anat urot tayiyta ham. Ta teq God in hodhodab wazan ta eram daqagya ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Na ezaqgo kwaziqmo Herot in ama Filip awe Herodiyas hureqim aholyon wam. In daq nazaq eman Jon tutimmo bulonyaq, Ni God ago gunun ayahta itiyonim ni nima awe wamta haqyaq. Haqsa teq Herot in ago mataw asor giqeman lehim in Jon wazim tiqirquriy. ");
INSERT INTO mlp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Irquran ossa Herot awe Herodiyas agem meqin diq Jon ugad in anad emyaq, In moq nagta haqyaq. Haqad teq in wol emgo dan nagun yo hiqiyyaq. ");
INSERT INTO mlp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Na ezaqgo aduw Herot in Jon rabunad alowan tonyaqta na ago. Herot anad emyaq, Jon in mat dimun diqta daq araq meqinta a hi amta haqyaq. Haqad in Jon gamuk bilaqsa huritad anad kabemmo emyaqta teq in huritnan anad bilaqyaqmo. ");
INSERT INTO mlp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ari abeb Herodiyas aduw Herot anen iqamta na akaman tugwahtim. Gwahtiqan kam nab Herot humab araq ayahta tiqam. Emim in mataw aseseqta in nenaq gavman ago kabiy muzayta na teq mataw bab emayta gigo aseseqta na teq saw Galiliy-ib mataw marorta nagan in gibilenan bolan nenaq humab wolim didaq neqad tuqosiy. Ossa Herodiyas gibiyad anad tiqam, Ari muran ya Jon wol emdaiqta adanteqin inaq tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Haqad Herodiyas in amiy eman lehim bit na aduganib gwahtiqim dorsa Herot ago mataw nenaq in amun aw na ahol waqad gime tisiriryaq. An abeb Herot aw barasta na bulonim bilam, Ni naga diq waqnan ninad bilaqaq? ham. Na ni ya ibilenid ya tinigdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","God ya ibiysa ya bilaqaiq ham. Ni naga diq anan susumun yagid ya tinigdaiq ham. Ari ni ninad yaqgo og ya wamuzaiqta na liqabmo uroteq asor nigdaiq haqid na dimunmo ya tinigdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Haqan amun aw na asanib gwahtiqim lehim in anen tisusumun ug, Ya le naga diq anan bilaqdaiq? ham. Haqan anen bilam, Ni Jon mataw huz negyaqta naqmo afaqin waqgo bilaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Haqan amun aw na hidmo lehim in Herot atoranmo bulon, Muranmo ni Jon mataw huz negyaqta na anat uroteq afaqin degib emeq a bo yag ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","In nazaq bilaqan Herot afaqan tiqiy. Na ezaqgo in ago mataw na gimeb helmo ulilib hamta na anadin emad in amun aw na aqez othasnan atuw tihiqiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ad hidmo in ago mat araq bab emaqta eman in Jon afaqin waqeq a bolnan tilah. Lehim in bit giqirquran osaytab gwahtiqim Jon anat urot tayim afaqin tuwam. ");
INSERT INTO mlp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Waqim in degib emim a bolim aw barasta na ugan in waqim a le anen tuqug. ");
INSERT INTO mlp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","An abeb Jon ago disaipel in Jon wol emiyta na ago huritim in bolim asan waqim a le hodhodab tiyay toniy. ");
INSERT INTO mlp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ari Yesus ago mataw in giqeman uliq-uliqgo lehiyta na muleqim ta bolim Yesus agerab humab tuwoliy. Humab wolim in lehim kabiy emiyta na teq gamuk bunmo in mataw gibileniyta na awagamun in Yesus tubuloniy. ");
INSERT INTO mlp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bulonsa kam nabmo mataw kabemmo leh bolsa Yesus ago disaipel nenaq gikabiyan emad in didaq neq daqayta akaman haiq iy yaqay. Nazaq iyan Yesus in ago disaipel gibilan, Bolsa i gimomo saw araq amatawun haiqtab leheq asitmo ginamur emuq ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Haqad in muyib gwalim saw araq amatawun haiqtab in gimo tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lehsa mataw kabemmo gibiyad ginad emiy, Ko in saw nabmo tilehay haqiy. Haqsa mataw uliq kabemmo era gisenab yuw adek muzim ameb lehim saw nab tugwahtiqiy. Gwahtiqim tuqossa teq Yesus ago disaipel nenaq muyib abeb le gwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Gwahtiqim Yesus muy hulosad le dubub gwalimmo ame le on mataw kabemmo gibiyad in ginan anad timeqniy. Mataw na bilaqne sipsip ginamren haiqta os nog iy yaqay. Nazaq iyan Yesus suleq dimdimunta kabemmo tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Gibilenad ossa zeq tuwolehnan tonsa Yesus ago disaipel bolim tubuloniy, Zeq tuwolehaq haqiy. Teq saw ka amatawun haiqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ni on mataw ka giqemid leheq kabiy uliq sinsin usayta kogab giholmen didaq zayeq neqiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Haqan Yesus amenin emim gibilan, Negmo didaq negid neqiy ham. Haqan in bilaqiy, Sey haqiy, i gigo 200 kina i a leheq bret kabemmo zayeq mataw biyahta ka negid neq daqayta na edowa? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Haqan Yesus tisusumun nag, Ta ne gigo bret ganim usaq? ham. Leheq ahol waqiy ham. Haqan in lehim ahol waqim bolim Yesus buloniy, I gigo bret abaynagin teq nabiq giger nazaqmo usaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Haqan Yesus gibilan, Ne mataw gibilenid in humab ame ame emeq teq sisihun dimunta kogab osiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Haqan in mataw gibilenan tuqosiy. Mataw humab asor 100 teq mataw humab asor 50 nazaq in osiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ossa Yesus bret abaynagin na teq nabiq giger na waqim ame ulilib gwalsa in God esey ugim teq in bret na orqayim ago disaipel tinag. Negan in a le mataw negan tineqiy. Teq nabiq giger na Yesus nazaqmo orqayim mataw bunmo negan tineqiymo. ");
INSERT INTO mlp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Neqan tigiyuninan teq bret na nabiq inaq abeyan ayahmo ussa disaipel kuram 12 nazaqmo giwaqim gisihenan ate tugwal bug. ");
INSERT INTO mlp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ari mataw didaq neqiyta na ginulinqan kabemmo diq 5,000 nazaq. ");
INSERT INTO mlp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ari Yesus in ago disaipel giqeman muyib gwalim in ameb yuw-kurorqan Galiliy urotim aqurumun kozaq uliq Betsaida-ib tilehiy. Lehsa inmo osim mataw dauh biyahta na giqeman giquliqab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Lehsa Yesus gihulosim garahab God inaq gamuk emnan tugwalah. ");
INSERT INTO mlp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gwalehim ossa imisor diq tiqiysa ago disaipel gimuyin inaq yuwmeb liqabmo tiqiyiy. Iysa Yesus wole yuw aqurumnib titur. ");
INSERT INTO mlp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","49","Tursa ago disaipel na tim ginobun ban bolsa in giholtuw bulad luwsa in tigibiy. Gibiyad saw tihastitaynan tonsa tarom asor ussamo in disaipel gigerab yuw bayim tilah. Lehim in disaipel gimeb gwahtiqeq bo lehdaiq haqsamo disaipel in Yesus yuw bayim lehsa ahol waqad in rabim ek tonim bilaqiy, Ko witag bo lehaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Haqsamo Yesus hidmo gibilan, Ne giwaz meqniyiy ham. Ka yaqmo lehaiq ham. Ne hi rabiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Haqad in muyib gwalanmo tim timidam. Mideman disaipel gihol riten lamsa ginadnad tiqem yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Na ezaqgo in ginad gigem soqotim ussa in Yesus mataw didaq nagta na abe alulin anan ginad a hi em hasiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ari Yesus ago disaipel nenaq yuw-kurorqan Galiliy urotim lehim urum kozaq ban uliq Genesaret ago lan ezab tugwaliy. Gwalim saw nab in muy am wazan us. ");
INSERT INTO mlp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ussa Yesus muy hulosim hitiqsa mataw hidmo ahol tuwaq hasiy. ");
INSERT INTO mlp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ahol waq hasad in saw nab uliq haresmo sibim lehad gibilensa mataw bunmo Yesus edob osaqta na huritad in giyogniz gigo moq inaq na banab giqemim gisorim giqad tubol yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sa Yesus saw nabmo uliq aseseqtab teq uliqben amikmiktab in lehsa mataw in giyogniz gigo moq inaqta na giwaqeq maket-ib giqad leheq giqemid us yaqay. Usad in Yesus atoran diqmo bulon yaqay, Ni on mataw gigo moq inaqta ka gihulosid in giben ningo tubusan adekmo waziy haq yaqay. Haqsa on mataw Yesus ago tubusan adek waz yaqayta na bunmo gihol tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ari Farisi asor teq mataw Moses ago gunun hurit kemiyta na asor in Jerusalem hulosim bolim Yesus ago hib humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Humab wolim osad in Yesus ago disaipel gisesan Juda gigo gunun a hi muzinim giben a hi suholimmo didaq neqsa in tigibiyiy. ");
INSERT INTO mlp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Na Farisi teq Juda bunmo in gisesan gigo gunun muzinad in giben a hi suholim didaq a hi neqayta, luweq God ameb i gihol anumlan inaq iydaq haqad. ");
INSERT INTO mlp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Teq mataw na maket-ib lehim muleqim a hi huzimmo in didaq a hi neqaytamo. Ad in gisesan gigo gunun naqanta kabemmo muzinayta. Muzinad in gigo reb, deg, gog teq ban gisuholaytamo. ");
INSERT INTO mlp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nazaq iyan Farisi giyogniz mataw Moses ago gunun hurit kemiyta na nenaq in Yesus tisusumun ugiy, Ezaq tonim ningo disaipel in i gisesan Juda gigo gunun a hi muzinim in giben a hi suholimmo didaq tineqay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Haqan Yesus gibilan, Ne mataw gimileq meqinta ham. Kwaziqmo God ago nantut Aisaya in ne gilum kemim gamuk araq kazaq mar ton ham. On mataw ka giqezabmo God abin iluwayta haqad in bilam ham. Teq in ginad gigem pesanmo God ago hib usaqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mataw na God abin samanta iluwayta haqad in bilam ham. In mataw og kabtaqmo gigo gunun anan bilaqay, God ago maror dimunta haqayta haqad in bilam ham. Ad in gunun naqmo mataw giqisihunayta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ari Aisaya bilamta nazaq diqmo ne emad ne God ago gunun tuhulosim ne gisesan gigo gunun naqmo waz naqmo hiqiyayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Haqad Yesus bilam, Ne God ago gunun dimunta walemad ne gisesan gigo daq naqmo wazgo ne tuhurit kemiyta ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses bilam, Ni ninen nimam giwazinad gilumsih haqad in bilam ham. Teq in bilam, Mat araq anen amam a hi giqudinad gamuk meqinta amalib gibilawunid ne wol emid moqan haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ta teq negmo kazaq bilaqayta ham. Mat araq in anen amam gilumsihgo ago nagah giqusdaqta teq in gibileneq bilaqdaq, Yaqgo nagah ka in Korban iyim usaqta haqdaq haqayta ham. (Hibru nan Korban haqayta na alulin in kazaq. Nagah God abinib eman usaqta haqayta.) ");
INSERT INTO mlp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mat na gamuk awaz meqinta nazaq gibileneq teq abeb in anad buliyeq ago nagah na amalib anen amam gilumsihgo haqsa ne wasihayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nazaq iyan ne gisesan gigo gunun waqiyta naqmo ne muzinad ne God ago gamuk bayan woqim samanta usaq ham. Ad ne daq naqanta kabemmo emayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Haqad Yesus on mataw nab turiyta na a ta gibilenan bolan in gibilan, Ne bunmo yaqgo gamuk ka huriteq teq ne ginad em hasiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nagah asanib usaqta na mat aduganib lehim in mat na ahol eman God ameb anumlan a hi iyaqta ham. Haiq ham. Nagah mat aduganib usaqta naqmo bo asanib gwahtiqim in mat na ahol eman God ameb anumlan inaq iyaqta ham.  ");
INSERT INTO mlp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mat aw nog in gidek nan huritgo usaqta na in gamuk ka hurit kemiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Haqad Yesus ago disaipel nenaq mataw gihulosim bitab tilehiy. Lehimmo disaipel in Yesus gamuk awowun bilamta na ago tisusumun ugiy. ");
INSERT INTO mlp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Susumun ugan Yesus gibilan, Ne mataw aseseqta ginad a hi em hasayta ko nog ne ham. Ne ginad a hi emay daqag ham. Nagah bunmo asanib usaqta na mat aduganib lehim in mat na ahol eman anumlan inaq a hi iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Na ezaqgo nagah nazaqta na in mat agemab lehim aholib a hi usaqta ham. Haiq ham. Na mat abekoqib lehim le yayib wolehaqta ham. (Yesus nazaq haqad, in didaq bunmo anan dimunmo ham.) ");
INSERT INTO mlp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Haqad in bilam, Nagah mat aduganib usaqta naqmo bo asanib gwahtiqim in mat na ahol eman God ameb anumlan inaq iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ari mataw giduganib daq meqinta gigemab gwahtiqad giqeman gihol anumlan inaq iyayta na kagzaq ham. Ni ninad meqmeqinta nigemab usaqta ham. Teq ni an a hi waqadmo an haresmo hureqim inaq usaqta ham. Teq ni rin tonaqta ham. Teq ni mat wol emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Teq ni an alulib hureqaqta ham. Teq ni mataw gigo nagah utetaqta ham. Teq ni daq meqinta amo amo emaqta ham. Teq ni nan katiyta bilaqaqta ham. Teq ni yaqmo ag haqad daq daq emaqta ham. Teq ni mataw ginan nigem meqniyaqta ham. Teq ni mataw gibilawunaqta ham. Teq ni nihol abin wazan eraqaqta ham. Teq ni ninad a hi em hasadmo daq emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Daq meqinta nawa nagan bunmo in mat aduganib usim bo asanib gwahtiqim in mat na eman God ameb ahol anumlan inaq iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ari Yesus uliq na hulosim in uliq araq anan Tair haqaytab tilah. Lehim in bit araq aduganib gwahtiqim ulilemim os, mataw ya edob osaiqta na a hi hurit daqay haqad. ");
INSERT INTO mlp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Teq haiq. Amun aw araq aholib bugaw meqinta usaqta na anen in Yesus edob osaqta na tuhurit. Huritim in hidmo lehim Yesus anognib abakbakan ulum laquwim turad afaqin mulbunim ogib wom. ");
INSERT INTO mlp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aw na in Juda aw a haiqta. In Grik nan bilaqyaqta teq in ago uliq diq Fonisiya saw Siriya-ibta. In lehim Yesus anogib abakbakan ulum laquwim turad tubulonyaq, Ni ya imiy aholib bugaw meqinta usaqta na muzid lehan haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Haqsa teq Yesus bulon, Ni hulossa yaqgo onmin didaq negid giyunin bugid teq ham. Luweq ya onmin gimen didaqta na waqeq gaun negid neqsa yaqgo onmin gigemnan moq daqay ham. Daq nawa na in dimun a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Haqan aw na amenin emim bulon, Mat Iyah ham ni helmo bilaqaq ham. Ta teq ningo onmin didaq neqsa aneglan ban ahaqenib woqsa gaun neqaytamo ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Haqan Yesus bulon, Ni nazaq haqaq na ni muleqeq leh ham. Bugaw meqinta na ni nimiy tuhulos ug ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Haqan aw na muleqim aquliqab ta lehim bugaw meqinta na amiy tuhulos ugan amiy banab dimunmo ussa in ahol tuwam. ");
INSERT INTO mlp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ari Yesus uliq Tair hulosim in uliq Saidon-ib tilah. Lehim uliq na hulosadmo in saw araq anan Dekapolis haqaytab gwahtiqim yuw-kurorqan Galiliy aqurumnib tilah. ");
INSERT INTO mlp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Lehan teq mataw in mat araq adek haiqta gamuk a hi emaqta waqim ad Yesus agerab tuboliy, in bulonid aben mat na aholib emeq wastitaydaq haqad. ");
INSERT INTO mlp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","An Yesus mat na waqim mataw na gihulosad lehim in giholbinmo tituriy. Turad Yesus aben balaw-waz gigermo mat na adeksanib tiqam. Emim teq aben ta waqim abenab kusluwim in mat na amileqib tiqammo. ");
INSERT INTO mlp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Emadmo in ame ulilib gwalsa ahol aqurin ayahmo gwahtiqsa inmo ago nanib bilam, Efata ham. Na in kazaq bilam, Ni nidek hastitayan ham. ");
INSERT INTO mlp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Haqanmo mat na adeksan hastitaysa amileq abunbunan iyim usta na hulos uganmo in gamuk dimunmo tibilaqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sa Yesus mataw na gibilan, Ne nagah kawa ya emta ka ago ne mat araq hikidik buloniy ham. Teq haiq. Mataw na bilaqnan zaway diq iy yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sa mataw bunmo huritim bilaqiy, Helmo haqiy. Mat na nagah bunmo dimunmo emaqta haqiy. In mataw gidek haiqta na giwastitaysa in gamuk tuhuritayta haqiy. Ad in mataw giqez haiqta na giwastitaysa in gamuk tibilaqaytamo haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ari kam nab mataw kabemmo Yesus agerab humab ta woliy. Humab wolim osad in didaq a boliyta na tineq bugiy. An Yesus in ago disaipel gibilenim bilam, ");
INSERT INTO mlp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ya on mataw ka ginan inad timeqniyaq ham. Ya nenaq kam ezeqmanmo osan in gigo didaq tihiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Luweq in gigemnan moqad ossa ya giqemid lehad in gime sinsanid danib woq daqay ham. Mataw ka asor pesanmo boliyta ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Haqan in ago disaipel bilaqiy, Saw ka amatawun haiqta haqiy. I edob didaq waqeq mataw ka negid neq daqay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Haqan Yesus tisusumun nag, Ta ne gigo bret ganim usaq? ham. Haqan in bilaqiy, Bret 7 nazaq diq usaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Haqan Yesus on mataw biyahta na gibilenan ogib tuqosiy. Ossa in bret 7 na waqim God esey ugim in orqayim teq in ago disaipel ibergo tinag. Negan in mataw gigo hib iberim iberim a tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ad in gigo nabiq amikmikta amulik-mulikmo usta na Yesus waqim God esey ugan in ago disaipel waqim tiqiberiymo. ");
INSERT INTO mlp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","An mataw neqan tigiyunin bug. Giyunin bugan didaq abeyan asor osan disaipel kuram 7 giwaqim amalib tigisiheniy. ");
INSERT INTO mlp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mataw na ginulinqan kabemmo diq 4,000 nazaq. An Yesus on mataw na gibilenan giquliq-uliqgo tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lehsa Yesus ago disaipel nenaq muy araqab gwalim saw anan Dalmanuta haqaytab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lehan teq Farisi asor Yesus agerab tuboliy. Bolim in Yesus ulum waqad buloniy, Ni God bulonid in daq araq azawayin inaqta em gwahtiqsa i ahol waqad teq i ni ninan helmo tihaqam haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Haqan Yesus in Farisi gimugan meqinta na tiloyinim in ahol afaqan tiqiy. Ahol afaqan iyad ahol aqurin ayahmo gwahtiqsa in bilam, Nagaqgo mataw muran kam kabta ka in daq azawayin inaqta ahol waqnan bilaqay? ham. Ya helmo bilaqaiq ham. God daq araq azawayin inaqta mataw muran kam kabta gimen a hi em negdaq ham. Haiqmo diq ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Haqad Yesus ago disaipel nenaq in mataw na gihulosad muyib ta gwalim in yuw urotim aqurumun kozaq ban tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lehad disaipel gidek zizalan in bret kabemmo a hi waqiy. Bret amulikmo muyib osta naqmo in a lehiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Lehad luwimmo Yesus era ago disaipel tigibilan, Ne Farisi teq Herot inaq gigo yis anan gihol waz naqmo hiqiyiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Haqan disaipel in gimo an bulonim bilaqiy, I bret haiqgam iyan daqag in bilaqaqya haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Haqsa Yesus huritad teq in gibilan, Ne nagaqgo “i bret haiq” haqad osay? ham. Ne gime haiqta iyim ginad a hi em hasay ye? ham. Ne ginad gigem soqotim usaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ne gime inaqta teq ne nagah ahol a hi waqayta ham. Ne gidek inaqta teq ne gamuk huritim ginad a hi em hasayta ham. Ne gidek tizizal daqag ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ya bret abaynaginmo orqayim mataw 5,000 negta na abeyan ne kuram ganim siheniy? ham. Haqan disaipel bilaqiy, Na i kuram 12 nazaqmo gisihen haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Haqan Yesus bilam, Teq ya bret 7 na orqayim mataw 4,000 negta na abeyan ne kuram ganim siheniymo? ham. An in bilaqiy, Na i kuram 7 nazaqmo gisihen haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Haqan Yesus gibilan, Kam gineh teq ne ginad em has daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ari Yesus ago disaipel nenaq lehim uliq Betsaida-ib tugwahtiqiy. Gwahtiqan mataw in mat araq ame haiqta Yesus agerab a boliy, in Yesus bulonid in aben mat na aholib emeq wazid dimniydaq haqad. ");
INSERT INTO mlp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","An Yesus mat na abenab wazim ad uliq asan ban le tugwahtim. Gwahtiqim in mat na ameqnagnib kusluwim aben emimmo tisusumun ug, Ni nagah araq ahol tuwaqaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","An mat na saw ahol waqad teq in bilam, Ya mataw loq gelsa gibiyaiqta ham. Teq ya gibiysa in bilaqne ay nog iyim turay ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Haqan Yesus aben mat na ameqnagnib a ta am. Eman mat na ameqnagin dimniyan in ame rireqim saw ahol tuwaq kemyaq. ");
INSERT INTO mlp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sa Yesus mat na eman ago bitab lehsa in bulon, Ni bitab lehad uliq aduganib gwahtiqeq hi leh ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ari Yesus ago disaipel nenaq eraqim saw Sisariya Filipay gigo uliq amikmiktab tilehad luwiy. Lehad luwad teq Yesus in ago disaipel tisusumun nag, On mataw ya inan nog diq haqsa ne huritay? ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Haqan disaipel bilaqiy, Mataw asor ni ninan Jon mataw huz negyaqta na amatin haqay haqiy. Sa asor ni ninan bilaqay, Ni Elaija haqay haqiy. Sa asor bilaqay, God ago nantut kwaziqta na gigo araq daqag ni haqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Haqan Yesus a ta susumun nag, Ta negmo ya inan nog diq haqay? ham. Haqan Pita amenin emim tibilam, Ni Krais ham. God mat emid bo i gilumsihdaqta amatin na ninmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Haqan Yesus gunun negim gibilan, Ari ne yaqgo tuhurit kemiy ham. Teq ne ya ihol alulin na ulalab hi bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Haqad Yesus in ago disaipel suleq negim bilam, Mat Atatin teq santitiy ayahmo tisordaqta ham. Sa Juda gigo mataw marorta na teq mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na in gileh tuqug daqay ham. Ugad teq in wol emid tumoqdaq ham. Moqeq kam ezeqmanmo useq teq in kayeq iyeq ta eraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus inmo moqdaqta na ahol alulin nazaq bilaq keman Pita waqim ad dan adek ban loqimmo in tuwad. ");
INSERT INTO mlp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wadan Yesus ahol buliyim ago disaipel bunmo gibiyad teq in Pita wadim bulon, Satan ni tukeq ya igilehun ban leh ham. Ni God anad a hi muzaq ham. Haiqgam ham. Ni mat og kabtaqmo anad muzaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Haqad in mataw biyahta na gibilenan agerab boliy, in ago disaipel na nenaq. Bolan in gibilan, Mat araq ya imuzeq bolnan haqad anad emeq in ahol wazid woqan ham. Ad ya afaqan soraiqta nazaqmo in sornan anad bilaqsa in ago kruse sorid abetarib gwalan ham. In nazaq toneq teq in ya imuzeq bolan ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Na ezaqgo mat nog inmo ahol anadin emad asan alowan tonaqta na in ahol awitan tihik hulesdaq ham. Ari mat nog in yaqmo teq ya iwagamun dimunta na inaq ginadin emad ahol nog hulosaqta na in ahol awitan ulumsiheq kuluwa-kuluwmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nagaqgo mataw og kab osad in giholyon nagah kabemmo diq rom tonayta? ham. Abeb in moqid in gigo nagah giholyon rom toniyta na ezaq teq gilumsihdaq? ham. Na haiq ham. In gihol awitan tihik hules daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Teq in nagah ogibta na amalib gihol awitan zayeq le os dimunta nab tugwahtiq daqay ye? ham. Na haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mataw muran kam kabta in God gileh ugad daq meqinta em bugayta ham. Sa mat aw nog in mataw meqinta na gimeb ya teq yaqgo gamuk inaq ginan gimebay woqaqta na, abeb Mat Atatin in amam ago ahol anuwanib angelo tawonta kabemmo nenaq ta boleq in nazaqmo mataw na ginan amebay tuwoqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Haqad Yesus gibilan, Ya helmo ne gibilenaiq ham. On mataw muran kam kab osayta ka gigo asor a hi moqadmo in God ago maror azawayin inaq og kab gwahtiqsa ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ari abeb kam 6 nazaq tihiqiyan Yesus in Pita, Jems teq Jon giwaqim nenaq garah araq sisaqta abigmanib tugwalehiy. Gwalehim in gimomo nab giholbin tuqosiy. Ossa mataw na gimeb Yesus ahol buliyim awaqan lul araq diq iy. ");
INSERT INTO mlp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sa in ago tubusan hus diq zeq anuwan nog iymo. Mat araq og kabta ago tubusan suhol naqmo hiqiyan in nazaq hus diq a hi iyaqta. ");
INSERT INTO mlp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ari disaipel in Yesus nazaq ahol waqad ossa Elaija ayow Moses inaq giwitan tugwahtiqiy. Gwahtiqim in disaipel gimeb Yesus inaq gamuk bilaqad turiy. ");
INSERT INTO mlp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tursa Pita in Yesus bulon, Tisa ham i kab osauqta ka in dimun diq ham. I baybay ezeqmanmo emuq ham. Araq ninmen teq araq Moses amen teq araq Elaija amen ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Disaipel ezeqman na rab naqmo diq hiqiyad Pita anad a hi em hasadmo gamuk nazaq bilamta. ");
INSERT INTO mlp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","In gamuk nazaq bilaqad tursamo onqas hitiqim tigiqisih nat. Giqisih netan God aqez onqas na aduganib gehitiqim bilam, Ka ya itatin ham. Ya in anan inad bilaq naqmo hiqiyaqta ham. Ne in aqez huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Haqanmo disaipel ezeqman na gihol bubuliyad saw waqim leh boladmo in Moses ayow Elaija inaq a ta hi gibiyiy. In Yesus amomo gigerab tursa ahol waqiy. ");
INSERT INTO mlp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ari in aweweqmo garah na hulosim gewoqadmo Yesus disaipel ezeqman na gidek wazim gibilan, Ne nagah muran ahol waqiyta ka hikidik bilaqiy ham. Abeb ya hodhod huloseq eraqid teq ne nagah ka ago tibilaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","An in Yesus ago gamuk huritim ginadnad emad in gimo an bulonim bilaqiy, Yesus bilam, Ya hodhodab eraqdaiq hamta ko in gamuk alulin ezaqta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Haqad in Yesus tisusumun ugiy, Ta ezaqta ago mataw Moses ago gunun hurit kemiyta na bilaqay, Elaija danmeb bolid teq Krais abeb boldaq haqayta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Haqan Yesus gibilan, Helmo ham. Elaija nagah bunmo wastitaynan haqad danmeb boldaqta ham. Teq gamuk araq kazaq usaqmo ham. Mat Atatin boleq santitiy ayahmo sorsa mataw gileh tuqug daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ya ne gibilenaiq ham. Elaija tubol ham. Bolan mataw ginadibmo in aholib daqdaq emim timeqin toniy ham. Kwaziqmo mat na anan gamuk mar toniyta nazaqmo in tiqemiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ari Yesus disaipel ezeqman na nenaq muleqim tigewoqiy. Gewoqim in disaipel ta asor na mataw kabemmo nenaq humab ayahta wolim ossa tigibiyiy. Sa mataw Moses ago gunun hurit kemiyta na asor in disaipel na nenaq an mugad osiy. ");
INSERT INTO mlp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ossa mataw biyahta na in Yesus bolsa ahol waqad gihol turuh nemsa in sibim agerab lehim tubuloniy, Yesus ni tigewom e? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Haqsa Yesus disaipel susumun negim bilam, Ne nagaqgo mataw ka nenaq an mugay? ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Haqan mat araq biyahta na gilikmanib osim era Yesus tubulon, Mat Iyah ham ya igo amun matta ka a bol ham. In atenmosib bugaw ussa in gamuk a hi emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bugaw na amun aholib bolaqta nab in amun wazim ogib hunegan woqaqta ham. Woqim in ateb asabalbalin husta gwahtiqsa in ate guruwad ahol baytunim usaqta ham. Ya ningo disaipel gibilenan in bugaw na muznan biyab a hi iyiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Haqan Yesus amenin emim gibilan, On mataw kam kabta ne God anan helmo a hi haqayta ham. Kam ganim teq ya nenaq a ta osdaiq? ham. Kam ganim teq ya ne ginad siqim iyaqta na ago a hi bilaqad ya ne gigo afaqan sordaiq? ham. Ari amun a boliy ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Haqan in amun na Yesus ago hib a boliy. A bolsamo bugaw meqinta na in Yesus ahol waqad in amun na othasan ogib woqim ahol bubuliyad usad asabalbalin husta atenmosib gwahtiqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sa Yesus amun amam tisusumun ug, Kam ganim amun aholib moq ka tuqusta? ham. Haqan amam bilam, In amun amik osadmo in kazaq emyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tutimmo bugaw meqinta na amun wol emnan tonad in faqab teq yuwmeb hunegan woqaqta ham. Ari ninmo ningo zaway ussun teq ni i ginan ninad meqniysa gilumsih ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Haqan Yesus bulon, Ni nagaqgo bilam, Ningo zaway ussun teq i gilumsih haqad ni bilam? ham. Nazaq ni hi bilaq ham. Mat nog in helmo Mat Atatin ago zaway inaqta haqid teq God in mat nazaqta na ayon nagah tiqem ugdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Haqan hidmo amun amam dedibmo bilam, Ya helmo haqaiqta teq ya inad siqim iyaq ham. Ni ya ilumsih ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus in mataw kabemmo agerab bolsa gibiyad in bugaw meqinta na atoranmo bulon, Bugaw ni gamuk a hi emaqta nan a hi huritaqta ya ni nibilenaiq ham. Ni amun ka huloseq gwahtiq ham. Gwahtiqeq le in amuganib ta hi woq ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Haqan bugaw meqinta na ek tonim amun wol hasan woqim abensen hunegsamo in amun hulosim gwahtiqim tituk. Tukim lehsa amun na bilaqne mat tumomta nog iy. Iyan mataw kabemmo bilaqiy, Amun ka tumom haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Teq haiq. Yesus amun na abenab wazim wazan eraqim titur. ");
INSERT INTO mlp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Abeb Yesus bitab lehim in ago disaipel nenaq giholbinmo osad disaipel tisusumun ugiy, I ezaq iyim bugaw meqinta ko a hi muz? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Haqan Yesus bilam, Ne nagah araq amalib bugaw naqanta a hi muz daqay ham. Haiq ham. Ne God amomo bulonad susumun ugeq teq ne bugaw naqanta tumuz daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ari Yesus ago disaipel nenaq saw na hulosim le saw Galiliy-ib tugwahtiqiy. Gwahtiqim lehad in le edob osaqta na ago mat araq huritgo in hulos. ");
INSERT INTO mlp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Na ezaqgo in ago disaipel suleq negyaqta na ago iyan. Suleq negad in gibilenyaq, Mat araq teq Mat Atatin waqeq mataw gibenab tiqemdaq haqyaq. Emid teq in wol emid tumoqdaq haqyaq. Moqeq kam ezeqmanmo useq teq in kayeq iyeq ta eraqdaq haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","In nazaq bilaqsa ago disaipel ginad a hi em has yaqay. Ad teq in Yesus susumun ugnan rab yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ari in lehim uliq Kapaneam-ub tugwahtiqiy. Gwahtiqim in bitab lehim tuqosad teq Yesus in ago disaipel tisusumun nag, Ne danib naga gamukin an bulonim bulonim boliy? ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Haqan disaipel giqezmo hiqiyim osiy. Na ezaqgo in danib bolad in gimo an bulonim bilaq yaqay, I gilikmanib nog diq in ayah diqta? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","An Yesus os woqim osad ago disaipel 12 na gibilenan agerab boliy. Bolan in gibilan, Mat aw nog in danmebta iynan haqad in ahol waqeq abeb diq emeq teq in mataw bunmo gigo kabibiy mat samanta iyan ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Haqad in amun amikta araq waqim eman nob negim tursa in ay netim teq disaipel gibilan, Mat nog in amun kaqanta ya ibinib bolsa ahol waqad wazinaqta na in ya iwazinaqmo ham. Teq in ya imomo a hi iwazinaq ham. Haiq ham. In ya imam iqeman bolta na wazinaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ari Jon in Yesus bulon, Tisa ham mat araq ni nibinib bugaw meqinta gimuzsa i luwim ahol waw ham. Teq mat na i inaq araqib a hi luwad iyan i wasihad bulon, Ni nazaq ta hi em haw ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Haqan Yesus bilam, Ne hi wasihiy ham. Mat araq ya ibinib daq azawayin inaqta emeq in hidmo ya igilehnib nan meqinta a hi bilaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Na ezaqgo mat geg a hi igaqta na in i giyowta ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ad mat aw nog in ne gibiy kemad bilaqdaq, Ka Krais ago mataw haqad teq in ne gimen yuw soqoreq negid uluw daqayta na, ya helmo ne gibilenaiq ham. Mat na inaqmo God abenab naw dimunta tuwaqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Haqad Yesus bilam, Mat nog in onmin amikmikta ya inan helmo haqayta na gigo araq baymuzsa in anad helta na hulosnan tonid mat daq nazaq emdaqta na in yaqgo faq meqin diq tuwaqdaq ham. Na in kwaziqmo gig ayahta anatgumnib am wazeq kamismeb huneg nagiyta ham. Hunegid mat na moqeq daq meqinta na a hi emeq in yaqgo faq meqin diqta na a hi waq nagta ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ari ni niben araq kat nigid ni ninad helta hulosnan tonad ni niben na uroteq hunegid lehan ham. Ni niben amulikmo inaq iyeq os dimuntab lehdaqta na in dimunmo ham. Ari ni niben giger inaq iyeq os meqintab lehdaqta na in meqin diq ham. Saw nab faq oyad a hi miyaqta usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Teq ni nisen araq kat nigid ni ninad helta hulosnan tonad ni nisen na uroteq hunegid lehan ham. Ni nisen amulikmo inaq iyeq os dimuntab lehdaqta na in dimunmo ham. Ari ni nisen giger inaq iyeq os meqintab lehdaqta na in meqin diq ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Teq ni nimeqnagin araq kat nigid ni ninad helta hulosnan tonad ni nimeqnagin na othaseq hunegid lehan ham. Ni nimeqnagin amulikmo inaq iyeq God ago maror aduganib gwahtiqdaqta na in dimunmo ham. Ari ni nimeqnagin giger inaq iyeq os meqintab lehdaqta na in meqin diq ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Saw nab kadum gisan neqayta na a hi hiqiyayta ham. Teq nab faq oyad a hi miyaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ne nazaq giholib ginad meqinta gwahtiqsa wolad gihol loyinsa in bilaqne faq ginoy nog iydaqta ham. Teq God in faq nazaqta amalib ne bunmo ginoy nog iysa teq ne bilaqne kamis dimunta nog tiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kamis in nagah araq dimunta ham. Teq kamis agon hiqiyid ni ezaq tonid teq in agon inaq a ta iydaq? ham. Nazaq iyan ne gimugan bilaqne kamis dimunta nog iysa ne an ulumsihad an hi bayiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ari Yesus saw na hulosim le saw Judiya-ib gwahtiqim teq in le yuw Jodan urotim aqurumun kozaq ban le luw. Luwsa mataw dauh kabemmo boleq agerab humab tuwol yaqay. Humab wolsa Yesus in ago daq muzim God ago suleq tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Gibilensa Farisi asor Yesus ulum waqnan haqad agerab tuboliy. Bolim in Yesus tisusumun ugiy, I Juda gigo maror bilam, Mat in ago aw muznan tumuzdaq hamta na in daq dimun o daq meqin? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Haqan ta Yesus in susumun negim gibilan, Moses naga gununin ne nag? ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Haqan in bilaqiy, Moses gunun emim bilam, Mat in aw muz agamukin mar toneq teq in ago aw tumuzdaq haqad in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Haqan Yesus gibilan, Ne gigem soqotim ussa ne God anad a hi muzinsa iyan Moses ne gimen gunun na mar ton nag ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Teq mebmebmo diq, God nagah bunmo giqamta nab in on mataw matmatta teq onqonta inaqmo giqam ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Daq alulin naqmo ago mat in anen amam gihuloseq in awe aholib tisoqotdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Soqoteq in giger gihol amulikmo iyeq tuqos daqay ham. Nazaq iyan mat awe inaq in gihol giger a ta hi iyayta ham. Haiqgam ham. In giger gihol amulikmo tiqiyim osayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nazaq iyan nagah God am tuwazan usaqta na mat araq in ta hi urotan ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ari abeb Yesus ago disaipel nenaq le bit aduganib gwahtiqim teq disaipel in gamuk na ago tisusumun ugiy. ");
INSERT INTO mlp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Susumun ugan Yesus gibilan, Mat awe muzad aw ta araq muturta waqaqta na in awe amebta na meqin tonad in bilaqne mat ta araq ago aw inaq luw nog iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ad daq nazaqmo aw aduw hulosim le mat ta araq muturta waqaqta na in aduw amebta na meqin tonad in bilaqne aw ta araq ago mat inaq luw nog iyaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ari on mataw gigo onmin amikmikta Yesus agerab giqad tubol yaqay, Yesus giwazad gidimun tondaq haqad. Teq haiq. In onmin giqad bolsa disaipel ginadad tigimuz yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sa Yesus in disaipel nazaq tonsa gibiyad agem timeqniy. Agem meqniysa in gibilan, Ne onmin gihulosid yaqgo hib boliy ham. Ne hi giwasihiy ham. On mataw naqantaqmo God ago maror aduganib gwahtiqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ya helmo ne gibilenaiq ham. Mat aw nog in onmin gibin haiqta ka nogmo iyad God ago maror ahaqenib a hi oseq in God ago maror na aduganib le a hi gwahtiq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Haqadmo in onmin giqay netim aben giholib emim giwazad tigibar ton. ");
INSERT INTO mlp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ari Yesus eraqim danib lehad luwsa mat araq sibim bolim in anognib abakbakan ulum laquwim turad tubulon, Tisa dimunta ham, ya ezaq tonid teq God in ago os dimunta kuluwa-kuluwmo osayta na tiyagdaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Haqan Yesus bulon, Ni ninad ezaq emad ya inan dimun haqaq? ham. God amomo in dimunta ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Haqad in mat na bulon, Gunun bunmo Moses bilamta na ago ni tuhurit ham. Ni mat araq wol emid hi moqan ham. Ni an alulib hureqeq inaq hi us ham. Ni hi rin ton ham. Ni hazizirib mat araq hi kat ug ham. Ni mat araq kat ugeq ago nagah samanmo hi waq ham. Ni ninenmaman giqez hurit ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Haqanmo mat na bulon, Tisa ham ya amunibmo osad gunun nagan bunmo muzim bolim muran ya mat ayah tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Haqan Yesus mat na ahol waqad in anan anad bilam. Anad bilaqsa in bulon, Ni daq amulikmo em nagta a hi emaq ham. Ni leheq ningo nagah bunmo gizayeq amenin waqeq teq ni mataw ginaghan haiqta neg ham. Ni nazaq toneq teq Heven-ib ningo nagah kabemmo diq inaq iydaq ham. Ad ni daq na emeq teq ni ya imuzeq bol ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Haqan mat na gamuk nazaq huritim in anobun iyim anad ayahmo meqniysa tilah. Na ezaqgo in ago nagah dimdimunta kabemmo usta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ari mat na tilehsa teq Yesus ahol buliyim in ago disaipel gibiyad gibilan, Mataw gigo nagah kabemmo inaqta na in God ago maror aduganib gwahtiqgo afaqan diq ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Haqan disaipel gamuk na huritim gihol turuh nam. Samo Yesus a ta gibilan, Yaqgo onmin ham mataw God ago maror aduganib gwahtiqgo in afaqan diq ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Haqad in gamuk awowun araq gibilenim bilam, Karuw ayahta anan kamel haqayta na in nidel akwiyaknib le tugwahtiqdaq e? ham. Hikidik ham. Ad nazaqmo mat ago es kabemmo ginadin emaqta na in God ago maror aduganib le a hi gwahtiqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Haqan disaipel gihol turuh nemsa in an bulonim bilaqiy, Nazaq iyid teq mat araq diq God ago os dimunta nab le a hi gwahtiqdaqya haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Haqsa Yesus gibiyad gibilan, Mataw in gimo gigo zawayib le a hi gwahtiq daqayta ham. Ari God in mat nog a haiq ham. Inmo mataw gilumsihsa teq in le tugwahtiq daqay ham. Na ezaqgo in nagah araq a hi emdaqta a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Haqan Pita tubulon, Ni i gibiy ham. I nagah bunmo gihulosim i ninmo nimuzim ninaq tilehauq ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Haqan Yesus bilam, Ya helmo ne gibilenaiq ham. Mat aw nog in ya iwagamun huritim teq in ya imuzeq bolnan haqad in gigo bit teq gimaqbaban teq gihiyan teq ginenmaman teq in gigo onmin teq in gigo og gihulosiyta, on mataw na bunmo og kab osad in gigo nagah gihulosiyta na amenin 100 nazaq tuwaq daqay ham. Waqad in gigo bit teq gimaqbaban teq gihiyan teq ginenan teq gigo onmin kabemmo diq inaq iy daqay ham. Ta teq in ya imuzeq bolsa mataw in afaqan tineg daqaymo ham. Ad abeb kam muturta nab teq mataw na in God ago os dimuntab gwahtiqeq kuluwa-kuluwmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kam nabmo mataw gibin inaq iyim osayta na kabemmo in gibin hiqiyad bo abeb tiqiy daqay ham. Sa mataw kabemmo og kab gibin haiqta na in gibin inaq iyeq le danmeb tiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ari kam nab Yesus danib gwahtiqim uliq Jerusalem-ub lehad in danmeb lehsa ago disaipel in abeb muzim inaq lehad teq in ginad haresmo em yaqay. Samo mataw ta asor in Yesus ago disaipel gibeb gimuzim nenaq lehad in gihol rabsa leh yaqaymo. Lehsa Yesus in ago disaipel 12 na giwaqim giqad le giholbinmo turad teq in aholib daq gwahtiqdaqta na anan tigibilan. ");
INSERT INTO mlp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","In bilam, Ne huritiy ham. Muran i Jerusalem-ub tugwalehauq ham. Nab teq mat araq in Mat Atatin waqeq mataw tamaz emayta gigo aseseqta na giyogniz mataw Moses ago gunun hurit kemiyta na nenaq gibenab tiqemdaq ham. Emid in ayon tibilaq daqay, Wol emid moqan haq daqay ham. Haqad in mataw en ta araq Juda a haiqta na gibenab tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Emid teq in Mat Atatin bilawunad kusluw ugad tuwoltitay daqay ham. Woltitayeq teq in wolemid tumoqdaq ham. Moqeq kam ezeqmanmo useq teq in kayeq iyeq ta eraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Haqan teq Sebediy atatniz giger Jems ama Jon inaq in Yesus buloniy, Mat Iyah haqiy i giger nagah araq ago tisusumun nignan haqiy. Nagah na ni i gimen tiqemdaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Haqan Yesus gibilan, Ya ne giger gimen naga diq emdaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Haqan in bilaqiy, Abeb ni maror ayah diqta iyeq ni nibin saw bunmo lehsa teq ni i giger ban igid i ninaq tuqosam haqiy. I ni nigerab niqabun ban teq ninasaran ban ossa on mataw bunmo i gihaqenib os daqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Haqan Yesus gibilan, Ne nagah anan susumunayta ka ago ne a hi hurit kemiy ham. Gog ayuwun agon meqin diqta ya uluwdaiqta na asor ne giger tuquluw daqaymo ye? ham. Teq santitiy ya iqisih bugdaqta na in ne giqisihsa ne tisor daqay ye? ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Haqanmo giger na bilaqiy, I nazaq tiqemam haqiy. Haqan Yesus gibilan, Helmo ham. Ya gog ayuwun agon meqinta uluwdaiqta na nogmo ne tuquluw daqaymo ham. Teq ya santitiy sordaiqta nazaq ne tisor daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ari nog diq ya iben iqabun ban osdaqta na teq nog ya iben inasaran ban osdaqta na in yaqgo nagah a haiq ham. God in mataw gingan gimen ban tuwastitayan usaqta naqmo in ban na tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ari disaipel 10 na gamuk na huritim in Jems ama Jon inaq gigem meqinta tineg yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Negsa Yesus gibilenan agerab bolan in gibilan, On mataw en ta asor Juda a haiqta nagan gigo maror aseseqta in gihol abin iluwad igmo ag haqad osayta ham. Ad in gigo walmataw giqemid in gimo ginad muzad gihaqenib iyeq osgo in giwaz meqniyayta ham. Na ago ne tuhuritiyta ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Teq ne in gigo daq na hikidik muziniy ham. Ne gilikmanib mat nog in mat ayahta iyeq osnan haqad in ahol wazid woqsa in ne gilumsiheq gimen kabiy eman ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ad mat nog in ne gigo mat amebta iyeq osnan haqad in ne gigo kabibiy mat samanta iyeq osan ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na ezaqgo Mat Atatin in mataw giqemid inmen kabiy sorgo a hi bol ham. In mataw gigo kabibiy mat nog iyeq in gigo afaqan inmo ahol ugad teq in ahol amalib mataw kabemmo gizayeq bab gibenab ta giwaqgo haqad in bolta ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ari Yesus ago disaipel nenaq teq mataw asor dauh biyahta nenaq in uliq ayahta Jerusalem-ub lehad luwim le uliq Jeriko-ib tugwahtiqiy. Gwahtiqim in uliq na hulosim lehsa Timeus atatin anan Bartimeus haqayta na in ame haiqta iyim dan adekib osad nagah anan sunad osyaqta. ");
INSERT INTO mlp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Osad in Yesus mat Nasaret-ibta bolaq haqsa abin tuhurit. Huritim in dedibmo lileyeq bilaqyaq, Yesus haqyaq. Devit atatin ");
INSERT INTO mlp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Haqsa mataw kabemmo mat na wadad buloniy, Ni niqez hiqiy haqiy. Teq haiq. In dedibmo lileyeq a ta bilaqyaq, Yesus haqyaq. Devit atatin haqyaq. Ni ya inan ninad meqniyan haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Haqsa Yesus bolim turad in mat na aqez huritadmo bilam, Bulonid ya igerab bolan ham. Haqan mataw na in mat ame haiqta na bulonim bilaqiy, Kadoy haqiy ni ninad dimniyan haqiy. In tinibilenaq haqiy. Ni eraqeq agerab leh haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Haqan mat ame haiqta na ago tubusan ahol isihim usta na hasim hulosan woqsa in hidmo eraqim Yesus agerab tilah. ");
INSERT INTO mlp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Lehan Yesus bulon, Ya ni ezaq nitondaiq? ham. Haqan mat ame haiqta na bilam, Mat Iyah ham ya saw ahol waqnan inad bilaqaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Haqan Yesus bulon, Ni leh ham. Ni ya inan helmo hamta naqmo niqeman ni nime tidimniy ham. Haqan muran diq nawaqmo mat na ame hastitayan in saw ahol tuwaqyaq. Saw ahol waqad in Yesus muzim inaq Jerusalem-ub tilah. ");
INSERT INTO mlp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ari Yesus ago disaipel nenaq le Jerusalem sinsin tuqugad in le uliq giger Betfage teq Betaniy gigerab tugwahtiqiy, garah Oliv asenab. ");
INSERT INTO mlp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Gwahtiqim Yesus in ago disaipel giger giqeman danmeb lehsa in gibilan, Ne le uliq ginobun ban usaqta kob gwahtiqeqmo donki amidon araq amalib asit a hi luwiyta nawa am wazan tursa ne ahol tuwaq daqay ham. Ahol waqeq ne haseq a boliy ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sa mat araq gibileneq bilaqdaq, “Ne nagaqgo nazaq emay?” haqid ne kazaq buloniy ham. Iyahta ago kabiy inaq iyan haqiy ham. Kabiy na hiqiyid teq in hidmo emid ta boldaq haqad ne buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Haqan giger na lehim donki araq minminta bit araq aqezab am wazan tursa ahol tuwaqiy. Ahol waqad in donki na aqamun tihasiy. ");
INSERT INTO mlp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hassa mataw nab turiyta na tisusumun negiy, Ne giger nagaqgo donki minminta na aqamun hasay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Haqan Yesus gibilanta nazaqmo in mataw na tigibileniy. Gibilenan mataw na ‘dimunmo’ haqanmo in donki amidon na tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Waqim in Yesus agerab a lehim in gigo tubusan asor hasim donki amalib emanmo Yesus donki amalib tuqos. ");
INSERT INTO mlp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Osim lehsa mataw kabemmo in gigo tubusan hasim danib gihureniy. Gihurensa asor ay aben amikmikta giwaqim a bolim danib gihunegim giqad lehiy. ");
INSERT INTO mlp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dan balaw tonim hulosad teq mataw asor ameb lehad mataw asor abeb bolad in lileyim bilaq yaqay, God abin soriy haq yaqay. Mat ka Iyahta abinib bolan i ginad bilaq gigayinaq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Teq kwaziqmo i gises Devit maror iyim osta na akaman diq a ta gwahtiqsa i ginad tidimniy hasaq haq yaqay. I God abin sorid ulilibmo diq gwalan haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ari Yesus le uliq Jerusalem-ub gwahtiqim Tempel-ib tilah. Lehim Tempel ago gel aduganib gwahtiqim luwad in nagah bunmo ahol waqad luwsa tarom tiqiynan tonsa in ago disaipel 12 na nenaq usnan haqad uliq Betaniy-ib muleqim ta lehiy. ");
INSERT INTO mlp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","13","Lehim usim tarommo in eraqim Betaniy hulosim Jerusalem-ub ta lehad luwimmo Yesus agem moqsa in ay fik araq pesanmo tursa ahol waqad in anon waqnan agerab tilom. Loqim in anon araq ahol a hi wam. Haiqgam. Ananmo us. Na ezaqgo kam na in ay fik anon emgo akaman a haiq. ");
INSERT INTO mlp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","An Yesus ay na bulonim bilam, Ni ninon a ta hi emsa mataw ninon araq waqeq a ta hi neq daqay ham. Haqsa ago disaipel tuhuritiy. ");
INSERT INTO mlp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ari Yesus ago disaipel nenaq le Jerusalem-ub tugwahtiqiy. Gwahtiqim Yesus le Tempel agelin aduganib gwahtiqim in mataw nagah gizayad osiyta na gimuzan in tukim asan ban gwahti tileh yaqay. Lehsa in mataw mani amo amo waqad amenin bit na ago mani negayta na gigo ban otbuliyan tuwom. Teq in mataw ah hushusta God ayon tamaz emgo gizayayta na gigo ban nagan inaqmo giqot buliyan woqiymo. ");
INSERT INTO mlp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sa mataw Tempel a hi wazinad in saw na agem siseyim nagah sorim leh bolad luwsa Yesus gibiyad in gunun emim gibilan, Ne Tempel ago saw ka wazinad nagah haresmo sorad uliq gem ka siseyad hi luwiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Haqad in mataw suleq negim kazaq gibilan, God ago marib in gamuk araq kazaq bilam ham. Mataw yaqgo bit anan bilaq daqay, On mataw en bunmo God inaq gamuk emgo abitan haq daqay haqad in bilam ham. Ta teq ne bit ka eman in mataw rin tonayta gigo bit nog tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ari mataw tamaz emayta gigo aseseqta na giyogniz mataw Moses ago gunun hurit kemiyta na nenaq in Yesus ago gamuk nazaq huritim in wol emid moqgo adanteqin tinagun yaqay. Teq in Yesus rabun yaqaymo. Na ezaqgo on mataw bunmo Yesus ago suleq huritad gihol turuh nemsa in wazin yaqayta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ari imisor tiqiysa Yesus ago disaipel nenaq Jerusalem hulosim tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lehim usim eraqim tarommo in Jerusalem-ub ta lehad luwimmo in ay fik na a ahol ta waqiy. Ay na aninin, abeqar teq anan inaqmo tumay bugim tur. ");
INSERT INTO mlp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sa Pita in irimo Yesus gamuk bilamta na anadin emad in Yesus bulon, Iyahta ham ni ay ka ahol waq ham. Irimo ni ay fik anan bilam ‘meqniydaq’ hamta ka tumay bug ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Haqan Yesus bilam, Ni ninad ayahmo God amomo ago hib usan ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ya helmo ne gibilenaiq ham. Mat anad amulikmo ussa in helmo God nagah yaqmen tiqem yagdaq haqaqta, mat na garah ko bulonid in eraqeq sortukeq le kamismeb tuwoqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na alulin nazaq iyan ya ne gibilenaiq ham. Ni nagah araq anan God susumun ugad bilaqeq “Helmo God tiyagdaq” haqid God nagah na tinigdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ari ni God inaq gamuk tiqemnan haqad luweq ni mat araq nimeqin tonta na anadin emdaq ham. Nazaq iyid danmeb ni mat na ago daq meqinta na walemad anadin ta hi em ham. Ad teq ni Gimam Iyah Heven-ib osaqta na ningo gamuk bulon ham. Ni nazaq tonid teq God nazaqmo ningo daq meqinta giwalemad in ni niqez tuhuritdaq ham.  ");
INSERT INTO mlp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ari ni mat na ago daq meqinta a hi walemid i Gimam Ulilib Osaqta na in ningo daq meqinta a hi giwalemdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ari Yesus ago disaipel nenaq Jerusalem-ub a ta lehiy. Lehim Yesus Tempel agelin aduganib loq gelad luwsa mataw tamaz emayta na giyogniz mataw Moses ago gunun hurit kemiyta na teq Juda gigo mataw marorta nagan in Yesus agerab tuboliy. ");
INSERT INTO mlp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bolim in Yesus tisusumun ugiy, Ni nibin ezaqta iyim ni daq kagan emaq? haqiy. Teq nog diq nibin na nigan ni kazaq emaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Haqan Yesus gibilan, Ta ya nazaqmo nagah araq ago susumun negid ne amenin emiy ham. Ne yaqgo susumun ka amenin emid teq nog ibin yagan ya daq kagan emaiqta na ago ya tigibilendaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ari Jon mataw huz negyaqta na ago kabiy Heven-ib bol o haiq in matawmo gigo hib kabiy na wamta? ham. Ne yaqgo gamuk ka amenin bilaqid ya huritiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Haqan mataw aseseqta na in gimo an mugad bilaqiy, I bilaqam, Kabiy na God ago hib bolta haqid in tibilaqdaq, Ta nagaqgo ne Jon ago gamuk huritim anan helmo a hi haqiy? haqdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ari i bilaqam, Kabiy na matawmo gigo hib bolta haqid mataw biyahta ka eraqeq i ezaq giton daqayta na i a hi hurit haqiy. Na ezaqgo on mataw na bunmo Jon anan God ago nantut araqmo diq haqsa mataw marorta nagan in ginan tirab yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nazaq iyan in Yesus ago susumun na amenin emim buloniy, I a hi hurit haqiy. Haqan Yesus gibilan, Ya nazaqmo ham. Nog ibin yagan ya daq kagan emaiqta na ago ya a hi gibilendaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Haqad Yesus in mataw aseseqta na gamuk awowun araq gibilenim bilam, Mat araq am wain anagin kabemmo leyim in tigel ton ham. Gel tonim in yay araq wain anon em woqid bay ninaleq ayun waqgota na titay ham. Na tihiqiyan in mat kabiy wamuzdaqta ayon bit araq asen sisaqta emim in kabiy na mataw asor gibenab tiqam ham. In anad mataw na in gimo giholyon kabiy emad wain anagin asor waqad asor in ya yag daqay haqad ham. Kabiy anamren anad nazaq emad gibilenim hulosad in era uliq araq pesantab tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lehim ossa wain anagin waqgo akaman tugwahtiqan in ago kabibiy mat araq eman mataw wain akabiyan emayta na gigerab tilah ham. In leheq kabibiy mataw na gibenab wain anagin asor tuwaqdaq haqad ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Teq haiq ham. Kabibiy mat na lehanmo mataw wain akabiyan emayta na in wazim woltitayim muzan samanmo muleqim tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lehan kabiy anamren in kabibiy mat ta araq eman tilah ham. Lehan in mat na afaqin wolturim meqin diq toniy ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Anmo in kabibiy mat araq eman a ta lah ham. Lehan in mat na wol eman tumom ham. Moqan kabiy anamren in ago kabibiy mataw kabemmo giqeman leh yaqay ham. Lehsa mataw akabiyan emayta na in asor ginolad asor in ginol eman tumoqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ari kabiy anamren ago mat amulikmo tiqiy ham. Na in atatinmo in anan anad bilaq naqmo hiqiyyaqta ham. In anad am, Ya itatin em lehid teq mataw na in aqez tuhurit daqay haqad in eman abebtanta tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Teq haiq ham. Mataw kabiy wamuzayta na in gimo an bulonim bilaqiy, Abeb mat ko amam moqid in amam ago ahuran nagah bunmo tuwaqdaqta haqiy ham. Bolsa i mat ko wol emid moqanmo haqiy ham. Moqsa amam ago kabiy ka igmo waquq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Haqadmo in mat na wazim wol eman moqan in asan waqim kabiy asan ban hunegan tilah ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nazaq iyan kabiy anamren na ezaq tondaq? ham. In boleq mataw wain akabiyan wamuzayta na ginol em bugad teq in ago kabiy na mataw ta asor bunta gibenab tiqemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Haqad Yesus bilam, Ne God ago mar ahol a hi waqayta ye? ham. Mar nab gamuk araq kazaq bilam ham. Tituq mataw anan bilaqiy ‘meqin’ haqiyta naqmo in awaz meqin diq turad bit anon bunmo soraq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iyahtaqmo nagah na eman gwahtiqan i ahol waqsa in dimun diq iyaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesus nazaq haqan mataw aseseqta na ginad tiqemiy. Yesus i gibin wazid woqgo haqad gamuk awowun na bilam haqiy. Haqad in Yesus waznan ginad bilaqsa teq in ta on mataw girabun yaqay. Nazaq iyan in Yesus hulosim tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ari mataw aseseqta na lehim in Farisi asor teq Herot ago matawta asor nenaq gibilenan tilehiy, in leheq Yesus kat ugid in gavman gigo gunun araq itiyonad gamuk araq hi bilaqnanta bilaqid i tuwazam haqad. ");
INSERT INTO mlp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","15","In lehim Yesus buloniy, Tisa haqiy, i ningo tuhurit haqiy. Ni a hi katiyaqta haqiy. Ni mataw gibin inaqta a hi girabunad gigomo a hi lehaqta haqiy. Ad ni on mataw God ago dan titnonta giqisihunad ni hel diqmo gibilenaqta haqiy. Ni ninad ezaq emaq? haqiy. I gibabun Rom gigo king Sisa in i gituw bulsa i takis ugauqta na in daq dimun o daq meqin? haqiy. I Juda gigo maror ezaq bilamta? haqiy. I tuqugam o haiq? haqiy. Haqan Yesus in gigo gamuk katiyta na tuhurit. In ya imeqin tongo adanin tiqemay ham. Haqad in gibilan, Nagaqgo ne ya ilum waqay? ham. Ari mani araq waq a bolid ya ahol waqiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Haqan in araq a bolim tuqugiy. Ugan ahol waqad in tisusumun nag, Ka nog diq adulan teq ahol anan usaq? ham. Haqan in bilaqiy, Na Sisa-mo agota haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Haqan Yesus gibilan, Sisa ago nagah na ne Sisa-mo ugiy ham. Ad God ago nagah na ne God-mo ugiy ham. Haqan mataw na ginadnad emad tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Sa Sadyusi asor Yesus ago hib tuboliy. Mataw na ginad kazaq emayta. Mataw tumoqiyta hodhodab a hi eraq daqay haqayta. Na in bolim Yesus buloniy, Tisa haqiy Moses i gimen gamuk araq mar tonim in kazaq bilam haqiy. Mat araq aw waqeq amun a hi emsamo moqid ago aw amomo ossa teq in amikqan araq abab aqoburan na waqeq alulib abab ayon onmin tigiqemdaq ham haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ari gamuk araq kazaq lahta haqiy. Mat araq amikqaniz nenaq 7 nazaq diq iyim osiy haqiy. Osim in gibab na aw araq tuwam haqiy. Waqim inaq osad in ago amun haiqmo osimmo tumom haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Moqan ama ta araq aw naqmo tuwam haqiy. Waqim in nazaqmo amun haiqmo osim tumommo haqiy. Ta in gima ezeqmanta na nazaqmo ton haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na moqan in amagniz bunmo nazaqmo titoniymo haqiy. Mataw maqbab 7 na in aw amulik naqmo waqim amun araq eman a hi gwahtiqsamo in tumoq bugiy haqiy. An abeb aw na tumommo haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nazaq iyan abeb mataw bunmo hodhod huloseq eraq daqayta nab teq aw na in nog diq awe tiqiydaq? haqiy. Maqbab 7 na bunmo in aw amulik naqmo waqiyta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","In nazaq haqanmo Yesus gibilan, Ne God ago marib gamuk usaqta na ago ginad a hi em hasay ham. Teq ne God ago zaway a hi hurit kemaymo ham. Na ago iyan ne gamuk menmen bilaqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ari on mataw hodhodab eraqeq in an a ta hi waq daqay ham. In bilaqne God ago hib angelo osayta nazaq nogmo in os daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Teq God mataw tumoqiyta giwazid hodhodab eraq daqayta na agamukan Moses ago marib usaqta ham. Mar nab ne ay amikta faq oyad a hi oyworta awagamun na ne ahol a hi waqiyta daqagya ham. Wagam nab God in Moses bulonim bilam, Abraham ago God, teq Aisak ago God, teq Jekob ago God na yaqmo haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nazaq iyan God in mataw moqim kayeqmo osayta gigo God iyim in gibiy muzaqta ham. Mataw moqim a hi hiqiyayta ham. Ne gigo gamuk nawa na ne menmen diq bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ari mat araq Moses ago gunun hurit kamta na bolim Yesus Sadyusi nenaq gamukib an bayad tursa in tuhurit. Huritsa Yesus in gigo gamuk amenin dimun diqmo bilaqan mat na era Yesus tisusumun ug, God ago gunun doqag diqta in gunun bunmo giquriyamim in danmeb diqta? ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Haqan Yesus bilam, Gunun ameb diqta na kazaq bilam ham. Ne Isrel huritiy haqad in bilam ham. I gigo Iyahta God in amomo Iyahta iyim osaqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Sa ne gigem, giqutil, ginad, teq ne gigo zaway bunmo amalib ne gigo Iyahta God anan ginad bilaqan haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Teq gunun gigerta na in kazaq ham. Ni nihol anan ninad bilaqaqta nazaqmo ni niyow anan ninad bilaqan haqad in bilam ham. Gunun giger na in God ago daq dimdimunta bunmo giquriyamim in ameb diqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Haqan mat Moses ago gunun hurit kamta na in Yesus bulon, Mat Iyah ham helmo ni dimunmo bilam ham. God amomo in Iyahta iyim osaqta ham. God araq haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ad i giqutilibmo teq i ginadibmo teq i gigo zawayibmo i God anan ginad bilaqdaq ham. Teq igmo gihol anan ginad bilaqaqta nazaqmo i on mataw bunmo ginan ginad bilaqdaq ham. Daq giger na in mataw God ayon tamaz emad naw ugayta na bunmo giquriyamim in ameb diqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","In nazaq anad em hasim bilaqan Yesus huritim tubulon, Ni God ago maror sinsin diq ugim osaqta ham. Ari Yesus in mataw na gigo susumun bunmo amenin anononmo eman mataw bunmo rabad in Yesus ulum waqnan a ta hi susumun ug yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ari Yesus Tempel agelin aduganib mataw suleq negad tuqos. Osad in bilam, Ezaq haqad mataw Moses ago gunun hurit kemiyta na bilaqay, Krais in Devit atatin haqayta? ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kwaziqmo God ago Bugaw Dimunta in Devit anad ugsa Devit in Krais anan bilam, Iyahta in yaqgo Iyahta kazaq bulonim bilam ham. Ni ya iben iqabun ban kab ya imen emad ossa ya ningo bab giqemid nisen ahaqenib tiqiy bug daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ari Devit-mo in Krais anan bilam, ‘Yaqgo Iyahta’ haqad in bilam ham. Nazaq iyan ezaq toneq Krais in Devit ago Iyahta iyeq teq in Devit atatin a ta iydaq? ham. Haqan on mataw biyahta nab turiyta na in Yesus ago gamuk huritim ginad tidimniyiy. Na ezaqgo Yesus in mataw aseseqta na gigo gamuk adanin qway bugta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ari Yesus mataw na suleq negad osim gibilan, Ne mataw Moses ago gunun hurit kemiyta na gigo ne gihol waz naqmo hiqiyiy ham. In tubusan dimun diqta giholib emim dan muzad luwayta ham. Luwsa mataw gibiyad ginan ‘mat ayah’ haqsa in ginad diq dimniyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mataw na bit humab wolaytab ban ulilibta nabmo osnan ginad bilaqaqta ham. Ad in humab adidaqan inaqtab ogib garuruhab osnan hulosmo diq hulosayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Teq in on waburta kat negad gigo bit samanmo waqayta ham. Ad in mataw gimeb God inaq gamuk sisaqmo bilaqim a lehayta ham, mataw gibiyad ginan dimun diqta haq daqay haqad ham. God hazizir ayahta emdaqta nab teq mataw na in on mataw bunmo giquriyameq faq ayah diqmo tuwaq daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ari teq Yesus Tempel agelin aduganib osad mataw gigo naw hunegan mani emayta abanab woqsa in gibiyad os. Ossa mataw ginaghan inaqta na kabemmo boleq mani kabemmo giqem yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sa teq aw waburta araq anaghan haiqta bolim mani amikmikta gigermo hunag. ");
INSERT INTO mlp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hunegan Yesus ahol waqad in ago disaipel gibilenan agerab boliy. Bolan in gibilan, Ya helmo ne gibilenaiq ham. Aw waburta ahol anaghan haiqta ko in mani amik diqta emim in on mataw mani kabemmo emiyta ko giquriyam bug ham. ");
INSERT INTO mlp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Na ezaqgo mataw ko bunmo in gigo mani kabemmo usaqta na ago asitmo emiyta ham. Ari aw ko haiq ham. In aholib mani asitmo usta na bunmo em bugim in ago mani araq in didaq zayeq neqdaqta na haiq tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ari Yesus ago disaipel nenaq Tempel hulosim lehadmo disaipel araq in Yesus tubulon, Mat Iyah ham gig aseseqta amalib bit dimdimunta giqemiyta ko ni gibiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Haqan Yesus bilam, Ni bit aseseqta ko gibiyaq e? ham. Gig ko bunmo teq wolzizilayeq gihunegid tuwoq bug daqay ham. Gig an amalib usayta ko teq muruwoqeq tiqmo bug daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Haqad in tilehiy. Lehim Yesus garah anan Oliv haqayta nab osad teq in ame lehim Tempel na ahol waqad osyaq. Ossa Pita, Jems, Jon teq Andru nazaqmo in agerab tuboliy. Bolim in tisusumun ugiy, ");
INSERT INTO mlp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Yesus haqiy ni i gibilen haqiy. Kam gineh teq nagah ni anan bilamta na tugwahtiqdaq? haqiy. Naga daqin diq gwahtiqsa i ahol waqad ginad emam nagah na tugwahtiqnan tonaq haqam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Haqan Yesus gibilenim bilam, Ne gihol waz naqmo hiqiyiy ham. Luweq mat araq ne kat negdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mataw kabemmo teq boleq ya inan biyad bilaq daqay, Mat naqmo ya kawa haq daqay ham. Haqad in mataw kabemmo kat negsa in ginan helmo haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ad mataw bab emsa ne gihulan huritad teq ta mataw pesanta bab emsa ne gibin hurit daqaymo ham. Huritad ne ginad haresmo emad hi rabiy ham. Daq nagan nazaq tugwahtiqdaqta ham. Ta teq kam abebtanta na teqmo ham. Afaqan na bunmo gwahtiqeq le hiqiyid teq kam na tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Na ezaqgo mataw en araq in eraqeq mataw saw araqabta nenaq an wol daqayta ham. Sa king araq ago dauh in king ta araq ago dauhta nenaq an wol daqaytamo ham. Saw haresmo og ahol woleq lehsa uliq saw asor zarow ayahta gwahtiqdaqta ham. Daq nagan bunmo bilaqne aw agemab amun tubaysa loyinaqta nazaq nog iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ari negmo gihol waz naqmo hiqiyiy ham. Mataw teq ne giwazeq kaunsel gibenab giqem daqay ham. Ad in bit humab wolayta nagab ne ginol titay daqay ham. Ne ya inan helmo haqad imuzad luwayta na ago in ne giqemid ne king teq gavman aseseqta gimeb tur daqay ham. Turad teq ne nagah gimeb ahol waqiyta na awagamun tigibilen daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","On mataw ya iwagamun dimunta uliq saw bunmo a leheq gibilensa teq nagah ya anan bilayta na tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ari in ne giwazeq giqad gavman gimeb lehid teq ne naga gamukin bilaq daqayta na ago ginadnad hi emiy ham. Gamuk bunmo ne bilaq daqayta na God tinegdaq ham. Kam nab in gamuk negdaqta nazaqmo ne bilaqiy ham. Nazaq iyan negmo diq gamuk na a hi bilaq daqay ham. Haiq ham. God ago Bugaw Dimunta inmo gamuk na ne giqezab tibilaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kam nab teq mataw in gimaqbaban giwaqeq bab gibenab giqemid in ginol emid tumoq daqay ham. Sa gimaman in nazaqmo gigo onmin giwazeq bab gibenab giqem daqaymo ham. Ad onmin in nazaqmo ginenmaman gihar negad bab gibenab giqemid in ginol emid tumoq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ya ihol abin ne giholib usaqta na ago on mataw bunmo gigem meqinta neg daqay ham. Ari on mataw zaway diq iyeq ossa le in gigo kam abebtanta iydaqta nab teq God in gilumsiheq ta giwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Haqad Yesus bilam, Teq nagah meqin diqta uliq saw meqin tonaqta na in ban a hi osnagta nab ossa ne ahol tuwaq daqay ham. (Mat gamuk ka ahol waqad bilaqaqta na in anad em hasad bilaq sireqan.) Kam nab on mataw saw Judiya-ib os daqayta na in tukeq garah ban gwalehiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sa mat bit ahuqunib ban osnantab osdaqta na in ogib hitiqeq tukeq lehanmo ham. In ago es nagah giwaqgo bit aduganib lo hi gwahtiqan ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Teq mat kabiyab luwdaqta na in ago aholsihen waqnan uliqab muleqeq ta hi bolanmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kam nab on gigem iyayta na teq on amun muturta sus ugayta na in timeqniy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nazaq iyan ne God susumun ugid in kam meqinta na emid urom akamnib hi gwahtiqan ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kam nab mataw afaqan ayah diqmo tisor daqay ham. God nagah bunmo giqeman gwahtiqiyta nab iyim bo muran kam kabmo afaqan araq nazaqta a hi gwahtimta ham. Teq abeb afaqan araq nazaqta a ta hi gwahtiqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ari Iyahta kam meqinta na siqim diq hi emid on mataw bunmo tihiqiy bug nagiy ham. Teq inmo ago on mataw in gilumim aholyon giwamta na ginadin emad in kam na emid siqim tiqiydaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kam nab mat araq ne gibileneq bilaqdaq, Ahol waqiy, Krais kawa osaq o Krais kowa osaq haqsa ne in aqez na hikidik huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Na ezaqgo krais katiyta teq nantut katiyta kabemmo tugwahtiq daqay ham. Gwahtiqeq in daq azawayin inaqta kabemmo giqemad in kabiy lul araq diqta amo amo giqem daqayta ham. In nazaq emad teq in God ago on mataw in gilumim aholyon giwamta na gihureqnan diq ton daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ne gihol waz naqmo hiqiyiy ham. Daq nagan bunmo a hi gwahtiqsa kawa ya ne tigibilen kemaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Haqad Yesus bilam, Kam nab afaqan ayahta na tihiqiyid teq Zeq ame romriq iysa kalam a ta hi oydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sa kaitab ulig milheseq ogib tuwoq daqay ham. Woqsa nagah aseseqta zawayta ulilib usayta nagan gihol tuwol daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kam nabmo Mat Atatin onqas amalib oseq ago zaway ayahta teq ahol anuwan inaqmo bolsa on mataw ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sa in angelo asor giqemid in og saw bunmo lehad inmo ago on mataw in gilumim aholyon giwaqan osayta na giwaqeq giwaqeq a lehad teq in tigiwaq bug daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Haqad Yesus bilam, Ay fik ago hib teq ne ginad tiqem has daqay ham. Ay na aben hur tonad atitoqin muturta gwahtiqsa ne ahol waqad ginad emay, Zeq akaman tiqiynan tonaq haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nazaqmo teq abeb nagah ya anan bilayta ka bunmo tugwahtiqsa ne ahol waqad ginad kazaq emiy ham. Nagah Yesus anan bilamta na bolim sinsin tiqiy haqiy ham, bilaqne mat dan ezab turad bit aduganib gwahtiqnan tonaq nazaq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya helmo ne gibilenaiq ham. On mataw muran kam kab osayta ka a hi moq bugsa daq nagan bunmo tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kait og inaq teq tihiqiydaqta ham. Ari yaqgo gamuk ka a hi hiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ari teq Mat Atatin kam gineh diq ta boldaqta na teq in zeq adulan ganimtab bo gwahtiqdaqta na mat araq a hi hurit ham. Angelo Heven-ib osayta na teq God Atatin inaqmo in kam na a hi huritiymo ham. God amomo kam na ago tuhuritta ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nazaq iyan ne saw waqad gihol waz naqmo hiqiyeq osiy ham. In boldaqta akaman na ne a hi huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na in bilaqne mat ayahta araq ago uliq hulosim saw araq pesantab lehaqta nazaq nog iydaq ham. Mat na a hi lehadmo in kabiy iberim ago kabibiy mataw amulik-mulikmo negad gibilenan in ago nagah wamuzayta ham. Sa mat ayahta na in mat dan ez wamuzim turaqta na bulonaq, Ni dan ez wamuz naqmo hiqiyeq os haqaqta ham. Haqad in gihulosim tilehaqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Haqad Yesus bilam, Nazaq iyan ne gihol waz naqmo hiqiyeq osiy ham. Kam gineh bit anamren ta boldaqta na ne a hi huritayta ham. In taromab o tarom alihanib o saw hastitaysa o tarommo in boldaqta na ne a hi huritayta ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Luweq in hidmo boleq ne ussa in gibiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gamuk kawa ya ne gibilenaiqta ka ya on mataw uliq saw bunmo gibilenaiqmo ham. Ne bunmo gihol asawan woltayad osiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ari abeb kam giger le tihiqiyid teq Juda gigo lotu akaman ayahta anan Pasova haqayta na teq bret yis haiqmo neqayta na akaman tugwahtiqdaq. Sa mataw tamaz emayta na teq mataw Moses ago gunun hurit kemiyta na in mataw gime titoneq Yesus wazeq wol emid moqdaqta ago adanteqin tinagun yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na ezaqgo in bilaqiy, I Pasova akamnib Yesus ulalabmo a hi wazam haqiy. Luweq mataw biyahta na gigem meqniysa bab araq ayahta wazid eraqdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ari Yesus uliq Betaniy-ib mat araq kwaziqmo aholib moq lepra usim tihiqiyta anan Saimon haqayta ago bitab os. Osad in didaq neqsa aw araq tubol. Aw na kagoh araq amikta gig anan alabasta haqay na sisoqim emiyta nab in masil ahuran dimunta anan nard haqayta anawun ayahmota tenim teq in wazim a bol. A bolim in aqez orqayim Yesus afaqinib wazbalan tuwom. ");
INSERT INTO mlp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wazbalan woqsa mataw asor nab osiyta na gigem timeqniysa in ginadibmo bilaqiy, Nagaqgo aw ko masil dimunta ko abu ulumaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","I masil ko mat araq inaq zayeq 300 kina nazaq waq nagta haqiy. Waqeq i mataw ginaghan haiqmo osayta na neg nagta haqiy. Haqad in aw na tuwad yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wadsa Yesus bilam, Ne hulosiy ham. Nagaqgo ne aw na afaqan ugay? ham. In ya ilowan tonad yaqmen daq dimun diqta tiqem yag ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tutimmo mataw ginaghan haiqta na ne nenaq osayta ham. Ossa ne gilumsih daqayta akaman kabemmo ham. Ari ya nenaq tuteqmo a hi osdaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aw ka ya inadin emim in yaqmen emdaqta na kawa tiqem yag ham. In masil ya iholib amta ka in ya isan wastitayeq hodhodab iqemgo in kawa tiqam ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya helmo ne gibilenaiq ham. Mataw edobya leheq ya iwagamun dimunta bilaqad in aw ka daq amta ka awagamun tibilaq daqaymo ham. Bilaqsa mataw huritad teq in aw ka anadin tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ari kam nab disaipel 12 na gigo araq anan Judas uliq Kariyot-ib haqayta na in mataw tamaz emayta gigo aseseqta gigerab lehim gibilan, Ya Yesus waqeq ne gibenab tiqemdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","In nazaq bilaqan mataw aseseqta na huritim ginad tidimniyiy. Ginad dimniysa in Judas naw uggo tubuloniy. Bulonan Judas huritim teq in Yesus waqeq mataw na gibenab emdaqta adanteqin araq dimunta tinagunyaq. ");
INSERT INTO mlp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ari bret yis haiqmo neqayta na akaman tugwahtim. Kam nab in Pasova ayon sipsip amidon wol emayta. Nazaq iyan disaipel in Yesus tisusumun ugiy, Ni ninad i bit edob leheq ni Pasova adidaqan neqdaqta abanan wastitayam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Haqan Yesus in ago disaipel gigermo gibilan, Ne giger le uliq kob gwahtiqid teq mat araq reb ayuwun inaqta soreq a bo lehad in ne danib tigibiydaq ham. Mat naqmo ne muzeq inaq lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Leheq mat na bit edob gwahtiqdaqta nab ne loqeq bit na anamren kazaq susumun ugiy ham. Tisa bilam, Yaqgo disaipel nenaq Pasova adidaqan neqamta na ago bit adugan edowa? haqad ne buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ne nazaq bulonid teq in bit adugan araq ayahta ulilib usaqta na tigiqisihundaq ham. Bit adugan nab didaq neqayta anaghan bunmo usaqta ham. Nab ne leheq i bunmo Pasova adidaqan neqamta abanan wastitayiy ham. Haqad Yesus in giqeman tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lehim uliq nab gwahtiqim in Yesus nagah bunmo ginan gibilanta nazaqmo ahol tuwaqiy. Ahol waqad in nab Pasova adidaqan neq daqayta abanan tuwastitayiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","An imisor diq tiqiyan Yesus ago disaipel 12 na nenaq didaq neqnan tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lehim in banab didaq neqad osad Yesus bilam, Ya helmo ne gibilenaiq ham. Ne gilikmanib teq mat araq ya iwaqeq bab gibenab iqemdaq ham. Mat ya inaq araqib didaq neqauqta naqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Haqan disaipel gihol afaqan tiqiysamo in amulik-mulikmo Yesus tisusumun ug yaqay, Yaqmo ye? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Haqsa Yesus gibilan, Ne disaipel 12 gilikmanib mat ya inaq degib aben woqaq naqmo ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Helmo diq ham. God ago mar Mat Atatin anan bilamta nazaqmo diq in dan muzeq tilehdaqta ham. Teq mat in Mat Atatin bab gibenab emdaqta na timeqniy hasdaq ham. Mat na anen a hi em nagta in am ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ari in didaq neqad osad Yesus bret asor waqim God esey ugim in orqayim ago disaipel tinag. Negad in gibilan, Ne bret ka waqeq neqiy ham. Ka ya inon ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Haqad in wain agogin inaq waqim God esey ugim teq in negan in bunmo tuquluwiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Uluwan Yesus gibilan, Ka ya inedan God ago maror muturta na zaway ugdaqta ham. Ya ned ka on mataw kabemmo giwastitaynan haqad wazbaldaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ya ne helmo gibilenaiq ham. Ya wain ayun ka a ta hi uluwdaiq ham. Abeb ya God ago maror muturta aduganib osad teq ya wain ayun ka a ta uluwdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Admo in lotu ago bar araq wazim hulosadmo in uliq hulosim garah Oliv-ub tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Lehad Yesus in ago disaipel gibilan, Ne bunmo ginad ya inan helmo haqayta na hulosad gileh tiyag daqay ham. Na ezaqgo God ago marib gamuk araq kazaq bilam ham. Ya mat sipsip giwamuzaqta na wol emsa in ago sipsip haresmo tukeq tileh daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ari ya hodhodab eraqeq teq ya ameb saw Galiliy-ib tilehdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Haqan Pita bulon, Mataw ka bunmo in ginad helta na hulosad gileh nigsa ya haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Haqan Yesus bulon, Ya helmo nibilenaiq ham. Tarom kab kurek ame gigerta a hi gayonsamo ni nime ezeqmanmo gileh tiyagdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Haqan Pita atoranmo bilam, Nab iyan ham. Mataw ya ninaq ginol emnan bilaqsa ya gileh a hi nigdaiq ham. Hikidik ham. Haqan disaipel bunmo gamuk nazaqmo bilaqiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ari Yesus ago disaipel nenaq le og araq awaqan dimunta anan Getsemaniy haqayta nab tugwahtiqiy. Gwahtiqim Yesus in ago disaipel gibilan, Ne kab osiy ham. Sa ya leheq God inaq gamuk emnan ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Haqad in Pita, Jems teq Jon giwaqim nenaq tilah. Lehad in ahol afaqan diq iysa ahol meqin diq tiloyinyaq. ");
INSERT INTO mlp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ad in gibilan, Ya ihol afaqan diq iysa ya tumoqnan tonaiq ham. Ne kab saw waqad osiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Haqad in asitmo ta leh nog iyim in ogib woqim usad God tubulonyaq, God anad bilaqid in afaqan ka ya iholib walemdaq haqad. ");
INSERT INTO mlp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","In bilaqyaq, O kabay haqyaq ni ya imam haqyaq. Ni nagah araq a hi emdaqta a haiq haqyaq. Ya iholib afaqan ayahta ka ni walem haqyaq. Teq ni ya inad ka hi muz haqyaq. Ninmo ninad muz haqyaq. ");
INSERT INTO mlp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Haqad in muleqim ta lehim disaipel ezeqman na ussa in gibiy. Gibiyad in Pita bulon, Saimon ham ni nagaqgo usaq? ham. Ni asitmo saw waqad a hi osdaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ne saw waqad God inaq gamuk emad osiy ham. Gamuk emad daq ne gilum waqdaqta na bo giholib gwahtiqsa ne hi woqgo haqad buloniy ham. Helmo ne ya inad muznan ginad bilaqaqta ham. Teq ne gihol awaz meqin a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Haqad in lehim a God ta bulon. Teko in God bulonta nazaqmo in a ta bulon ton. ");
INSERT INTO mlp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bulonim in muleqim ta lehim disaipel gime rursa ussa in gibiy. Gibiysa in kayeq ta iyim in gamuk araq bilaq daqayta hiqiyan in giqezmo hiqiyim tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sa Yesus ame ezeqmanta lehim teq ta bol. Bolim in gibilan, Ne ginamur emad us tutay ye? ham. Ne dimunmo tuqusiy ham. Ahol waqiy ham. Muran in Mat Atatin waqeq mataw meqinta gibenab em daqayta akaman tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ne eraqiysa i lehuq ham. Ahol waqiy ham. Mat ya iwaqeq bab gibenab iqemdaqta na bo tugwahtim ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus nazaq gamuk bilaqad tursa hid naqmo disaipel 12 na gigo araq anan Judas haqayta na tubol. In bolsa mataw dauh biyahta baqir sebur wazim ad in inaq tuboliymo. Mataw tamaz emayta gigo aseseqta na teq Juda gigo mataw marorta na teq mataw Moses ago gunun hurit kemiyta na in mataw na giqeman boliyta. ");
INSERT INTO mlp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ari mat Yesus waqeq bab gibenab emdaqta na in naga daqin emid in Yesus ahol waqad waz daqayta na ago in teko tigibilanta. In bilam, Ya leheq mat nog ya wazeq ilawundaiqta naqmo ne wazeq bab mataw na gibenab emid in mat na wamuzeq ad lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nazaq iyan in hidmo Yesus agerab loqimmo tibilam, Tisa ham. Haqadmo in wazim tiqilawun. ");
INSERT INTO mlp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ilawunanmo mataw na eraqim Yesus tuwaziy. ");
INSERT INTO mlp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wazsa mat araq Yesus agerab turta na ago baqir hureq hasim wam. Waqim in tamaz mat danmebta ago kabibiy mat araq wolim adeksanmo qwatayan ogib tuwom. ");
INSERT INTO mlp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","An teq Yesus in bab mataw na gibilan, Ne baqir sebur giwaqim a boliyta ka ne mat rin tonaqta waznan boliy ye? ham ");
INSERT INTO mlp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kam kabemmo ya ne suleq negad nenaq Tempel-ib ossa ne ya a hi iwaziy ham. Teq daq kagan bunmo gwahtiqad in God ago mar tuwol net bugaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Haqanmo disaipel bunmo Yesus hulosim titukiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Disaipel tukim lehsa mat araq minminta ago tubusan dimunta husta amta na in Yesus muzim inaq lehsa mataw na ahol waqad tuwaziy. ");
INSERT INTO mlp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Wazan haiq in giben lelhasadmo ago tubusan gibenab hulosadmo in abe aholmo tukim tilah. ");
INSERT INTO mlp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ari mataw na Yesus wazim ad tamaz mat danmebta ago bitab tilehiy. Lehan mataw tamaz emayta gigo aseseqta na teq Juda gigo mataw marorta na teq mataw Moses ago gunun hurit kemiyta na in bolim humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Sa Pita in Yesus muzim lehad teq in pesan nog lehyaq. Lehim in tamaz mat danmebta na ago bit agelin aduganib le gwahtiqim in mataw Tempel-ib hurmey gan turayta na nenaq faq iterad tuqos. ");
INSERT INTO mlp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ossa mataw tamaz emayta gigo aseseqta na teq Juda gigo kaunsel ayahta na amatawun bunmo in mat araq Yesus ago hib nan bilaqid teq in wol emid moqgo na tinagun yaqay. Ta teq in gamuk araq amalib Yesus wol em daqayta na ahol a hi waq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mataw kabemmo bolim Yesus amalib nan katiyta em yaqayta. Teq haiq in gigo gamuk katiyta na araqibmo a hi iyyaq. ");
INSERT INTO mlp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Sa mataw asor turad in katiyim kazaq bilaq yaqay, Yesus kazaq bilaqsa i hurit haq yaqay. Yaqmo teq Tempel mataw gibenab emiyta ka wol inereq kam ezeqmanmo aduganib ya Tempel ta araq gibenab a hi em daqayta na wazid tiqeraqdaq haqad in bilamta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Teq gamuk in bilaq yaqayta na araqib diq a hi iyyaqmo. ");
INSERT INTO mlp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Anmo tamaz mat danmebta na eraqim liqabmo turad in Yesus tisusumun ug, Mataw ka bolim ni ninan gamuk bilaqayta ka in ezaq diq? ham. Ni gamuk ka araq amenin a hi emdaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Haqanmo Yesus aqez hiqiyim in mat na ago gamuk amenin araq a hi bilam. Sa tamaz mat danmebta na a ta susumun ug, Mat Iyah Ulilib Diqta na atatin mataw anan Krais haqayta na ninmo ye? ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Haqan Yesus bilam, Eqe ham. Na yaqmo kawa ham. Teq Mat Atatin in God Awaz Meqin Diqta aben aqabun ban ossa ne ahol tuwaq daqay ham. Ahol waqsa in kaitab onqas inaq bolsa ne ahol tuwaq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Haqanmo tamaz mat danmebta na era inmo aholib tubusan bulsireqim bilam, Mat araq in ayon nan araq ta hi bilaqan ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mat ka God bilawunsa ne tuhuritiy ham. Ne in ayon naga gamukin bilaq daqay? ham. Haqan mataw bunmo bilaqiy, Na in daq meqin diq haqiy. Mat daq nazaq amta na in moq nagta haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Haqad mataw na gigo asor in Yesus tukusluw ug yaqay. Ad in tubusanib ame isihim wolad teq in bulon yaqay, Ni nantut iysun nog ninolaqta ka anan biy haq yaqay. Haqsa mataw tamaz emayta gigo hurmey na in Yesus waqim tuwoltitay yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ari in Yesus nazaq tonsa Pita bit asisuranib ossamo tamaz mat danmebta na ago kabibiy aw araq tubol. ");
INSERT INTO mlp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bolim Pita faq iterad ossa in ahol waninunadmo bulon, Ni Yesus Nasaret-ibta na inaq luwta ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Haqan Pita bilam, Haiq ham. Ya ni gamuk bilaqaqta na inad a hi emaiq ham. Ni nog diq anan bilaqaq? ham. Haqad in asanib bit aqez ban le tugwahtim. Gwahtiqsamo kurek araq tigayon. ");
INSERT INTO mlp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","An kabibiy aw na in Pita nab tursa ahol waqad in mataw nab turiyta na tigibilan, Mat ka in Yesus ago mat araq kawa ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Haqan Pita a ta bilam, Na ya a haiq ham. Haqan mataw in agerab turiyta na asitmo ta tur nog iyim bilaqiy, Helmo diq haqiy ni mat Galiliy-ibta iyim iyan ni Yesus ago mat araq daqag haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Haqan Pita atoranmo bilam, God Ulilibta ibiysa ya helmo bilaqaiq ham. Ya mat na ago a hi huritta ne anan bilaqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Haqanmo kurek ame gigerta tigayon. Gayonanmo Pita in Yesus gamuk bilamta na anadin tiqam. Yesus bilam, Kurek ame gigerta a hi gayonsamo ni nime ezeqmanmo gileh tiyagdaq ham. Pita gamuk na anadin emad in anad meqniysa gaqad tuqos. ");
INSERT INTO mlp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ari tarommo diq mataw tamaz emayta gigo aseseqta na teq Juda gigo mataw marorta na teq mataw Moses ago gunun hurit kemiyta na teq Juda gigo kaunsel ayahta na amatawun bunmo in humab wolim an amugan tuwaziy. An amugan wazim in Yesus irqurim wazim ad lehim Rom gigo maror saw Judiya wamuzim osaqta anan Pailat haqay na tuqugiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ugan Pailat Yesus tisusumun ug, Ni Juda on mataw gigo king e? ham. Haqan Yesus bilam, Nawaqmo ni tibilam ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Haqanmo mataw tamaz emayta gigo aseseqta na in Yesus amalib nan kabemmo tiqem yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Emsa Pailat in Yesus a ta susumun ug, Ni gamuk araq amenin a hi emdaq e? ham. Ni hurit ham. Mataw ko nan kabemmo nimalib tiqemay ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Haqan Yesus gamuk amenin araq diq a ta hi bilam. Nazaq iyan Pailat anad kabemmo emyaq. ");
INSERT INTO mlp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ari ulig bunmo Juda gigo lotu akaman ayahta nab Pailat in mat araq irquran ossa hasid gwahtiqyaqta. Juda on mataw nog anan bilaqid Pailat naqmo hasid in gigo hib lehyaqta. ");
INSERT INTO mlp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Teq kam nab mat araq anan Barabas haqayta na irquran os. Mat na in Rom gimuznan haqad ago dauh nenaq lehim Rom ginolad in mataw asor ginol amta amatin. Nazaq iyan Rom in mat na wazim a le mataw giqirquran osayta na nenaq eman osta. ");
INSERT INTO mlp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ari Juda mataw kabemmo Pailat agerab lehim tisusumun ugiy, Pailat ago daq muzeq mat araq bit giqirquran osaytab hasid gwahtiqdaq haqad. ");
INSERT INTO mlp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Susumun ugan Pailat in gigo gamuk amenin emim bilam, Ne ginad ya Juda gigo king na hasid ne gigo hib lehdaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Na ezaqgo Pailat anad tiqam, Yesus mataw tamaz emayta gigo aseseqta ka gibayan woqiyta na ago in gigem meqniysa amalib nan emay ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Teq haiq. Mataw tamaz emayta gigo aseseqta na in mataw biyahta na gigem wazan eraqsa in Pailat buloniy, Ni Barabas hasid i gigerab bolan haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Haqan Pailat gibilan, Nazaq na teq mat ne anan bilaqay, Juda gigo king haqayta ka ya ezaq tondaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Haqan in lileyim bilaqiy, Ayib dom wolid moqan haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Haqan Pailat bilam, Nagaqgo? ham. Mat ka naga daqin meqinta am? ham. Haqsa teq haiq. Mataw na dedibmo lileyim a ta bilaq toniy, Ayib dom woliy haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Haqan Pailat in Juda mataw ginad emid dimniynan haqad in Barabas hasan in gigo hib tilah. Lehsa in ago mataw gibilenan in warig waqim hiklaquwim amalib Yesus tuwoltitayiy. Woltitayim hulosan Pailat in Yesus ayib dom wolgo haqad ago mataw bab emayta na gibenab tiqam. ");
INSERT INTO mlp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ari mataw bab emayta na in Yesus waqim ad Pailat ago bitab lehim in bit na ago gel aduganib ad tugwahtiqiy. Gwahtiqim in giyogniz bunmo gibilenan bo humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Humab wolim in tubusan araq sisaqta kakaqta amalib Yesus ahol isihim teq in am araq asasuqin inaqta tal tonim king ago balaw nogta afaqinib emiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Emim teq in eraqim Yesus buloneq bilaq yaqay, Mat ayah haq yaqay, ni Juda gigo king-mo diq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Haqadmo in tuqir araq waqim afaqin wolad tukusluw ug yaqay. Kusluw ugad in gibakbakan ulum laquwim turad bilaq yaqay, Maror haq yaqay i ni nibin tisorauq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ari in Yesus bilawunim hulosadmo in tubusan kakaqta na hasim waqad inmo ago tubusan na aholib ta em ugiy. Em ugim teq in ayib dom wolnan haqad waqim ad tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ari in Yesus waqim a lehsa Aleksanda ayow Rufus inaq gimam Saimon uliq Sairin-ibta na in uliqab bolad luwsa bab mataw in abe yahad bulonan in Yesus ulumsihim ayon ay tisor ug, Yesus ago zaway tihiqiy bugan iyan. ");
INSERT INTO mlp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sa bab mataw na in Yesus waqim ad garah akululqan araq anan Golgota haqaytab tilehiy. Gamuk Golgota na alulin ‘Gifaqin Agolgolan’ haqayta. ");
INSERT INTO mlp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A lehim in wain ayun teq masil anan mir haqayta na inaq buliyim Yesus ugiy. Ugan teq haiq. Yesus tuhulos. ");
INSERT INTO mlp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Anmo in Yesus ayib dom tuwoliy. Dom wolim hulosad teq in nog Yesus ago tubusan waqdaqta na ahol waqnan haqad in gig amikmikta hunegad tubusan nagan iberim giholyon tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ari tarommo 9 kilok nazaq in Yesus ayib dom woliy. ");
INSERT INTO mlp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Teq Yesus naga daqin eman in ayib dom woliyta na agamukan in mar tonim ulilib ay nabmo tuqotheniy. Gamuk na in kazaq mar toniy. ");
INSERT INTO mlp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Teq Yesus agerab in mataw rin tonayta gigermo ayib dom giwoliymo. Dom wolan araq Yesus aben aqabun ban tursa araq aben anasaran ban turyaq.  ");
INSERT INTO mlp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nazaq iyan daq na in gamuk araq God ago marib usaqta na tuwol net bug. Gamuk na bilam, In mat na anan mat gunun othasaqta araq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sa on mataw bo lehad in Yesus ahol waqad bilawun yaqay. Bilawunad gifaqin lelad teq in bilaq yaqay, Oyeq! haq yaqay. Mat Tempel wol inereq kam ezeqmanmo aduganib wazid a ta eraqdaqta na amatin ni haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nazaq iyan ni niwaz meqniyeq ninmo nihol ulumsiheq ay na huloseq gehitiq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sa mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na in nazaqmo Yesus bilawunad in an bulonim kazaq bilaq yaqay, In mataw asor gilumsihan a hi moqiyta haq yaqay. Ta teq inmo ahol ulumsihgo ago zaway haiqta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ari in Isrel gigo king anan Krais haqayta na iyeq teq in ay na huloseq gehitiqan haq yaqay. Gehitiqid teq i ahol waqad anan helmo tihaqam haq yaqay. Sa mataw giger Yesus inaq ayib dom woliyta na in inaqmo Yesus bilawun yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ari zeq gabolim liqabmo tiqiysa saw bunmo romriq iyad le 3 kilok imisor tiqiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ad 3 kilok imisor nazaq tiqiyanmo Yesus dedibmo lileyim bilam, Eloy Eloy lama sabaktaniy ham. Gamuk na in kazaq bilam, Yaqgo God yaqgo God nagaqgo ni ya ihulosaq? ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Haqanmo mataw asor nab turiyta na in Yesus aqez huritim bilaqiy, Huritiy haqiy. Ko in Elaija lilewunaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Anmo mat araq sibim lehim tubusandek waqim tuqir amotnib am wazim teq in wain ayun agon iyta na ulum turim Yesus ateb tiqam, in sisowdaq haqad. Emim teq in bilam, Sa i ahol waqad teq ham. Elaija boleq walemid tiqdaq o haiq ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Haqanmo Yesus dedibmo ek tonimmo tumom. ");
INSERT INTO mlp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Moqanmo tubusan ayahta Tempel-ib othenan usta na ulilib liqabmo tartayim giger iyim bo ogibmo tuwom. ");
INSERT INTO mlp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Teq bab mataw gigo ayahta saw nab Yesus wamuzim turad in Yesus nazaq moqsa ahol waqad bilam, Helmo diq ham. Mat ko in God atatin ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sa on asor pesanmo turad teq in nagah na ahol waqad turiy. In gilikmanib Mariya uliq Magdala-ibta na teq Jems ayow Josep inaq ginen anan Mariya haqayta na teq aw araq anan Salome haqayta na in nab turiy. ");
INSERT INTO mlp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kwaziqmo Yesus saw Galiliy-ib ossa on na in muzad ulumsihad luw yaqayta. Teq on kabemmo Yesus inaq Jerusalem-ub boliyta na in nab turiymo. ");
INSERT INTO mlp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ari kam Yesus momta na in Juda gigo lotu ayon nagah wastitayayta na akamnib in momta. Babeq na Juda gigo lotu akaman diq na tugwahtiqdaqta. Nazaq iyan Yesus momta kam nab imisor tiqiysa uliq Arimatea-ib mat araq anan Josep haqayta na bolim Pailat ago hib tilah. Mat na in Juda gigo mat marorta araq teq in abin inaqta. In inaqmo God ago maror og kab gwahtiqsa in ahol waqnan haqad amen emyaqta. In awaz meqniyim lehim Yesus asan waqeq a le yay tongo Pailat tisusumun ug. ");
INSERT INTO mlp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","An Pailat in Yesus momta na huritim anadnad am. Anadnad emim in ago mat bab emaqta araq bulonan bolan in tisusumun ug, Yesus tumom e? ham. Haqan mat na bilam, Yesus tumom ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailat in mat na gamuk bilaqan huritad teq in Josep bulon, Ari ni Yesus asan tuwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Haqan Josep le tubusan araq husta tizay. Zayim a lehim in Yesus asan walemim ogib eman ussa teq in tubusan husta na amalib tiqil ton. Il tonim a lehim mataw gig qwayan hodhod iyta na amuganib tiqam. Nab emim teq in gig araq otbuliyan bo hodhod aqez tiqitum. ");
INSERT INTO mlp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Sa Mariya uliq Magdala-ibta na ayow Josep ta araq na anen Mariya inaq in giger nab turad mat na Yesus asan hodhodab emsa in ahol tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ari Juda gigo lotu akaman na tihiqiyan Mariya uliq Magdala-ibta na teq Jems anen Mariya teq aw anan Salome haqayta na in nagah asor ahuran dimun diqta tizayiy, in hodhodab a leheq Yesus asanib emnan haqad. ");
INSERT INTO mlp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Zayim Sande tarommo in hodhodab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Lehad in an bulonim bilaqiy, Nog teq i gilumsiheq hodhod aqezab gig otbuliydaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Haqadmo in gime lehim hodhodab gig ayahta na tuqotbuliyan hodhod adek ban lehim ussa in ahol waqiy. ");
INSERT INTO mlp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ahol waqad in lehim hodhod amuganib gwahtiqimmo mat araq minminta aholib tubusan husta emim ossa in ahol waqiy. Ahol waqad in tirabiy. ");
INSERT INTO mlp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Rabsa mat na gibilan, Ne hi rabiy ham. Ya tuhurit ham. Ne Yesus Nasaret-ibta mataw ayib dom wolan momta naqmo ahol waqnan boliy ham. Mat na tiqeram ham. In kab haiq ham. In asan eman usta asawan ka ne ahol waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ad ne leheq disaipel bunmo gibilenad ne Pita inaqmo buloniy ham. Yesus ameb Galiliy-ib tilehaq haqiy ham. Ne nab leheq teq Yesus ahol tuwaq daqay haqiy ham. Kwaziqmo in ne gibilanta nazaq haqad ne gibileniy ham. ");
INSERT INTO mlp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Haqan on na gihol ritenim harara nemsa in hodhod hulosim gwahtiqim tukim tilehiy. Lehad in rab titayad mat araq a hi buloniy. ");
INSERT INTO mlp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ari kam nab Sande tarommo Yesus hodhod hulosim in danmeb Mariya uliq Magdala-ibta na ago hib tugwahtim. Kwaziqmo Yesus in aw na ago bugaw meqinta 7 gimuzta. ");
INSERT INTO mlp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","An teq Mariya lehim mataw Yesus inaq luwiyta na gaqad ginadnad emad ossa in gibilan, ");
INSERT INTO mlp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yesus hodhodab eraqim ossa ya ahol tuway ham. Haqan mataw na Mariya ago gamuk huritim anan helmo a hi haqiy. ");
INSERT INTO mlp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Abeb disaipel giger Jerusalem hulosim lehsa Yesus ahol awaqan lul araq diq iyim in gigerab gwahtim. ");
INSERT INTO mlp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Gwahtiqan giger na muleqim ta lehim disaipel ta asor na gibilenan in helmo a hi haqiymo. ");
INSERT INTO mlp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","An abeb disaipel 11 na didaq neqad ossa Yesus in gimeb gwahtim. Gwahtiqim in ginadad gibilan, Ne nagaqgo on mataw ya ibiyiyta na in bo ne gibilensa ne ginad soqotim ussa ya inan helmo a hi haqiy? ham. ");
INSERT INTO mlp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Haqad in gibilan, Ne og saw bunmo leheq ya iwagamun dimunta na on mataw bunmo gibileniy ham. ");
INSERT INTO mlp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mat ya ihol awagamun anan helmo haqad yuw huzdaqta na God in mat na waqid ingo tiqiydaq ham. Ari mat ya inan helmo a hi haqdaqta na God in mat na emid saw meqintab tilehdaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sa God in mataw ya inan helmo haq daqayta na gibenab daq kazaq tiqemdaq ham. In ya inanib bugaw meqinta tigimuz daqay ham. Teq uliq amo amo gigo nan ginadib bolsa in gamuk tibilaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","In nagah ahulinaqta ahol a hi waqeqmo wazid gimugid a hi moq daqay ham. Ad in nagah uluwim moqayta na ahol a hi waqeqmo uluweq a hi moq daqaymo ham. Teq in mat moqaqta aholib giben emeq wazsa mat na ago moq tihiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ari Iyahta Yesus gamuk na gibilen bugan tihiqiyan teq God in waqim ad Heven-ib tugwalah. Gwalehim eman in God aben aqabun ban tuqos wom. ");
INSERT INTO mlp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Os woqim ossa in ago disaipel og saw bunmo lehad in Yesus awagamun dimunta na on mataw gibileneq gibileneq tileh yaqay. In nazaq emad luwsa Iyahta in nenaq kabiy tiqemyaqmo. Sa disaipel Yesus awagamun bilaqsa God inmo daq azawayin inaqta emsa on mataw ahol waqad bilaq yaqay, Wagam na in hel diqtaqmo haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Mat ayah Tiyofilus, mebmebmo God in ago on mataw gimen daq aseseqta eman i gilikmanib gwahtiqsa mataw asor in gimeb ahol waq bugim teq awagamun bilaq yaqayta. Bilaqad in wagam na akabiyan emad luwad le in i on mataw abeb gwahtiwta i gigo hib wagam na tibilaqiymo. Bilaqsa mataw ta asor kabemmo in wagam anamreniz na giqez muzinim nagah na awagamun mar ton waqiyta. ");
INSERT INTO mlp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nazaq iyan ya inaqmo wagam na tumar tondaiqmo haqad inad emta. Inad emim ya wagam na agamukan bunmo alulin ulum muzad sisaqmo tiluw. Luwim ya daq bunmo gwahtiqiyta na ago tuhurit kemim teq ya wagam ka wastitayimmo mar tonim ninmen eman nawa lehaq. ");
INSERT INTO mlp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Wagam ka mataw nibilensa ni tuhuritta. Teq in wagam hel diqta nibileniyta na ago ni hurit kemdaq haqad ya ninmen gamuk ka mar tonim nawa eman leh nigaq. ");
INSERT INTO mlp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ari king Herot saw Judiya-ib on mataw giwamuzim ossa kam nab mat araq God ayon tamaz emaqta anan Sekaraya haqayta in os. Mat na in tamaz mataw gidauhan araq anan Abiya haqayta na gigo araq. Sa in awe anan Elisabet haqayta. Aw na in tamaz mat aqen diqta anan Aron haqayta na anaynayin araq. ");
INSERT INTO mlp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sekaraya awe inaq in Iyahta ago maror agamukan bunmo teq in ago gunun bunmo muzinad in giholib daq araq ananin waq daqayta haiq iysa in God ameb titnonimmo os yaqayta. ");
INSERT INTO mlp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Teq Elisabet in aw nignigta iyim iyan in aduw inaq gigo amun haiqmo os yaqayta. Ad in giger adinowan diq tiqiyiymo. ");
INSERT INTO mlp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ari kam araqab Sekaraya ago dauhta na gigo kam tugwahtiqan Sekaraya uliq Jerusalem-ub lehim God ameb tamaz emgo akabiyan tiqemyaq. ");
INSERT INTO mlp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Emad in ago dauh nenaq tamaz em ago adan muzinim in gig amikmikta hunegan Sekaraya anan gwahtiqan in Iyahta ago bit adugan Tawonta nab le tugwahtim, in faq aqasin ahuran dimunta gwalaqta ulamad God ayon tamaz emnan haqad. ");
INSERT INTO mlp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sa faq aqasin ahuran dimunta ulamayta akaman nab on mataw kuluwmo asanib humab emim in God bulonad titur yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tursa Sekaraya Tempel aduganib ago kabiy emad in Iyahta ago angelo araq faq aqasin ahuran dimunta gwalaqta abanan aqabun ger nab tursa in ahol tuwam. ");
INSERT INTO mlp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ahol waqad in anadnad emsa rab tuqulum netyaq. ");
INSERT INTO mlp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Samo angelo na bulonim bilam, Sekaraya ham ni hi rab ham. Ni amun araq waqnan haqad God susumun ugan in ni niqez tuhurit ham. Ni niwe Elisabet teq amun matta araq tiqemdaq ham. Emid teq ni anan Jon haqad biydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ni amun na ahol waqad ni ninad dimniysa nigem tidimniydaqmo ham. Sa on mataw kabemmo in ningo amun na anan ginad tidimniy daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Na ezaqgo ham amun na in Iyahta ameb abin inaq iydaq ham. In wain ayun teq yuw atoranta nagan a hi uluwdaq ham. Teq in anen agemab ussamo God ago Bugaw Dimunta in aholib tuboldaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bolid teq abeb in ayah iyeq in Isrel on mataw kabemmo ginad buliyid in gigo Iyahta God ago hib muleqeq ta leh daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Teq in anad Elaija anad nog iyeq in Elaija ago zawayibmo Iyahta ayon dan wastitaynan ameb lehdaq ham. Lehad in onmin ginenmaman gigem buliyid in gigo onmin ginadin a ta em daqay ham. Ad in mataw God ago nan a hi huritayta na gigem buliyid in mataw titnonta gigo ginad dimdimunta tuhurit daqay ham. Ningo amun na in nazaq Iyahta ayon on mataw gidauhan araq gihumab wolid ossamo Iyahta boleq in nenaq ginad dimniysa tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Haqan Sekaraya in angelo bulon, Ezaq teq ya ningo gamuk na anan helmo haqdaiq? ham. Ya mat nenqab tiqiy ham. Sa ya iwe nazaqmo aw nenqab tiqiymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","An angelo amenin emim bilam, Ya Gebriyel ham. Ya God anognib turaiqta ham. God-mo ya iqeman ya gamuk dimunta ka a bo ni tinibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ni hurit ham. Yaqgo gamuk ka akaman gwahtiqid teq in anon tiqemdaq ham. Ta teq ni yaqgo gamuk ka anan helmo a hi bilam ham. Nazaq iyan muran diq kabmo ni niqez hiqiyeq ni gamuk a ta hi bilaqdaq ham. Ni nazaq niqez hiqiyeq gamuk a hi bilaqad ossa le gamuk ya nibilenta ka tugwahtiqid nab teq ni niqez inaq ta iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ari on mataw asanib God inaq gamuk emad tur yaqayta na in Sekaraya amen eman haiq in ginad kabemmo tiqem yaqay. Sekaraya ezaq diq tonad Tempel aduganib sisaqmo luwaq? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","In nazaq ginadnad emad tursamo Sekaraya bo asanib tugwahtim. Gwahtiqim in aqez tihiqiyan in gamuk araq gibilengo haiq. Nazaq iyan on mataw na ginad tiqemiy, Sekaraya naqagag lul araq diqta Tempel aduganib ahol tuwam haqiy. Samo Sekaraya aqez tihiqiyan in kabiyakibmo on mataw na gibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ari Sekaraya ago kabiy akaman na tihiqiyan in ago uliqab muleqim ta lah. ");
INSERT INTO mlp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Lehim in awe Elisabet inaq usan awe agem tiqiy. Agem iyim in kalam abaynaginmo ulilemim bit aduganib tuqos. Osad in bilaqyaq, Iyahta nob yagim tiqidimun ton haqyaq. Idimun tonim in ya imebay on mataw gimeb usta na tuwalam haqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ari Elisabet agem iyim ossa kalam 6 nazaq tihiqiyan God in angelo Gebriyel bulonan in saw Galiliy-ib uliq araq anan Nasaret haqaytab tilah. ");
INSERT INTO mlp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Lehim in aw araq barasta ago hib tugwahtim. Aw na anan Mariya haqayta. In Devit ago asenlulibta araq. Teq in mat anan Josep haqayta na tuwaqdaq haqad anan bilaqan osyaqta. ");
INSERT INTO mlp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ossa kam nab angelo Gebriyel gwahtiqim Mariya bulon, Aw ni nawa osaq e? ham. Iyahta agem dimunta nigad in ni ninaq osaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Haqan Mariya in angelo gamuk bilamta na huritim ahol riten lam. Ritenad in anadibmo bilam, Gamuk ka adugan ezaq diqta ago angelo bilam? ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Haqan angelo bilam, Mariya ham ni hi rab ham. God agem dimun diqta ni nigaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ni hurit ham. Ni nigem iyeq teq ni amun matta araq tiqemdaq ham. Emeq ni anan Yesus haqad biydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Amun na in mat abin ayah diqta iyeq osdaqta ham. Ossa mataw in anan God Ulilib Diqta atatin haq daqay ham. Iyahta God in amun na emid in ases Devit king iyim osta nazaqmo in king iyeq tuqosdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Osad in Jekob asenlulniz Isrel on mataw giwamuzad in king kuluwa-kuluwmo tuqosdaqta ham. Osad in ago kam a hi hiqiydaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Haqan Mariya in angelo bulonim bilam, Nagah na ya iholib ezaq diq teq gwahtiqdaq? ham. Ya mat araq a hi wayta ham. Ad ya mat araq asit inaq a hi ustamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","An angelo amenin emim kazaq bulon, God ago Bugaw Dimunta ningo hib tuboldaq ham. Sa God Ulilib Diqta ago zaway tiniqisih bugdaq ham. Niqisih bugid teq amun na ni nigemab tugwahtiqdaq ham. Ningo amun tawonta na ahol alulin nazaq iyid teq mataw in anan bilaq daqay, God-mo atatin haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ni ninad em ham. Ni ninedan araq Elisabet na in adinowan tiqiyta teq muran amun matta araq in agemab usaq ham. Kwaziqmo mataw in anan bilaq yaqay, Aw nignigta amun a hi emdaqta haq yaqayta ham. Teq haiq ham. Muran in agem tiqiy ham. Agem iyim in ago kalam 6 nazaq tihiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nazaq iyan God in nagah araq a hi emdaqta a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","An Mariya bilam, Ni hurit ham. Iyahta ago kabibiy aw ya kawa osaiq ham. Ni ya ibilanta nazaqmo in ya iholib tiqemdaq ham. Haqan angelo huritadmo in Mariya hulosim tilah. ");
INSERT INTO mlp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ari kam nabmo Mariya hidmo eraqim in Elisabet ahol waqnan haqad tilah. Lehim in saw Judiya-ib Elisabet ago uliq garah ban usaqta nab tugwahtim. ");
INSERT INTO mlp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Gwahtiqim in Sekaraya ago bit aduganib loqim awe Elisabet ahol waqad “Zeq dimun” tuqug. ");
INSERT INTO mlp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ugan Elisabet in Mariya aqez huritsamo amun agemab usta na tubaytun. Samo God ago Bugaw Dimunta in Elisabet aholib ayahmo tubol. ");
INSERT INTO mlp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bolan in lileyim atoranmo bilam, On bunmo gilikmanib God agem dimun diqta ninmo tinigaq ham. Ad amun nawa nigemab usaqta na God in agem dimunta tuqugaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ya aw dimun a haiq ham. Teq ni yaqgo Iyahta anen ham. Doq tonnan ni yaqgo hib ya ibiynan bol? ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ya ni niqez huritsamo ya igemab amun usaqta ka anad dimniysa tubaytun ham. Na ago ya ningo tuhurit kemim kazaq nibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Aw ni ninad am, Helmo Iyahta ibilanta nazaqmo in tiqem yagdaq haqad ni ninad am ham. Nazaq iyan ni tidimniyim osaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","48","Haqan Mariya bilam, Ya God ago kabibiy awmo ham. Ya ibin haiqta teq God agem dimunta yag ham. Nazaq iyan ya inad teq idugan bunmo Iyahta abin tiqiluwaiq ham. God ya ilumsihim iwaqan ya dimunmo osad igemabmo diq ya in anan inad tidimniyaq ham. Muran teq abeb on mataw dauh bunmo ya inan bilaq daqay, Aw naqmo Iyahta in agem dimunta ugan in tidimniyim osta haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","God ago zaway ayahmo diq iyan in yaqmen nagah ayahta tiqam ham. In ago daq bunmo dimunmo iyim titnonimmo lahta ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","On mataw God wazinad ahaqenib ossa in ginan anad meqniyaqta ham. Ad in mataw na gigo onminta teq onmin na giduganib onminta na ginan anad meqniysa in ago daq na nazaqmo tileh tutdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","In kabiy awaz meqinta kabemmo tiqamta ham. Emad in mataw igmo ag haqayta na gimuzan haresmo tilehiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ad in king giwaz meqinta giwazan woqsa in mataw gibin haiqta na giqeman in mataw gibin inaqta na gigo ban tuwaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","In nagah dimunta kabemmo mataw ginaghan haiqta na negan giyuninsa in ta mataw ginaghan kabemmota na gimuzan samanmo tilehiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","In i gisesan hel diqmo gibilenim bilam, Ya Abraham teq in ago dauh abeb bol daqayta na tuteqmo ya inad tinegdaiq haqad in bilamta ham. Ad muran in gamuk bilamta na anadin a ta emad in ago on mataw Isrel tigilumsihaq ham. In gamuk bilamta nazaqmo diq in muzinim tiqemaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ari Mariya in Elisabet inaq kalam ezeqman nazaqmo osim teq in ago uliqab muleqim ta lah. ");
INSERT INTO mlp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ari Elisabet amun emgo akaman tugwahtiqan in amun matta araq tiqam. ");
INSERT INTO mlp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Eman Iyahta in Elisabet anan anad ayahmo meqniysa amun ugta na ago Elisabet asenlul teq in ayogniz tuhuritiy. Huritim in Elisabet inaq ginad tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sa abeb amun na ago kam 8 nazaq tiqiyan teq mataw in amun ahol abatan asan urotnan tuboliy. Bolim in amun aholnan ugnan haqad in amun amammo anan ugnan bilaqiy. ");
INSERT INTO mlp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bilaqan teq amun anen bilam, Haiqgam ham. In anan Jon-mo usdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Haqan mataw na buloniy, Ni nisenlul araq aholnan nazaqta haiq haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Haqad in ta amun amam kabiyakibmo susumun ugiy, I amun ka anan doqagta biyam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Haqan amam kabiyakibmo gibilenan in ay anabun araq teq zamor asor ugan in gamuk kazaq mar ton. In anan Jon ham. An mataw na gamuk na ahol waqad gihol riten lam. ");
INSERT INTO mlp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sa muran diq nawaqmo Sekaraya aqez hiqiyim usta na hulos ugan in aqez inaq iyim gamuk tibilaqad in God abin tiqiluwyaq. ");
INSERT INTO mlp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sa Sekaraya awe Elisabet inaq giyogniz bunmo tirab yaqay. Ad in nagah gwahtimta na abin eman saw Judiya-ib uliq bunmo garah ban usaqta nab tileh bug. ");
INSERT INTO mlp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lehan on mataw bunmo nagah gwahtimta na ago huritim in anadin emad os yaqay. Osad in Iyahta ago zaway Jon aholib ussa ahol waqad bilaq yaqay, Amun ka ayah iyeq teq in mat ezaq diqta iydaq? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ari God ago Bugaw Dimunta in amun amam Sekaraya aholib ayahmo bol. Bolan God in Sekaraya anad ugan Sekaraya aqezab gamuk gwahtiqsa in kazaq bilam, ");
INSERT INTO mlp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","I Iyahta God abin iluwuq ham. In ago on mataw Isrel nob negim in gizayim in gigo bab gibenab tigiwaqaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","In mat araq awaz meqinta eman in ago kabibiy mat Devit asenlulib tugwahtim ham. Gwahtiqim in teq i gilumsiheq giwaqid i dimunmo tuqosam ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kwaziqmo God in ago nantut tawonta nagan giqezab gamuk eman gwahtimta nazaqmo in tiqam ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","In mat awaz meqinta na eman gwahtiqim in i gilumsihsa i gibabun a hi gimeqin ton daqay ham. Sa in mataw gigem meqinta igayta na gibenab i giwaqid i dimunmo osam ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kwaziqmo God i gisesan hel diqmo gibilenim bilam, Ya ne ginan inad meqniysa tigilumsihdaiq haqad in bilam ham. Ad muran in ago gamuk na anadin emad in nazaqmo tiqemaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Kwaziqmo in i gises Abraham inaq an adugan wazim in hel diqtaqmo bulonim bilam, Ni nisesan bab gibenab ossa ya gilumsiheq ta giwaqdaiq haqad in bilam ham. An muran in i gimen dante nazaq diq tiqem igid i in ago kabibiy mataw tawonta iyeq osad i in ameb daq titnonta emad tuqosam ham. Ossa kam dimunta na a hi hiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ari yaqgo amun ham mataw ni ninan God Ulilib Diqta ago nantut tihaq daqay ham. Na ezaqgo ni ameb leheq Iyahta ayon dan tuwastitaydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wastitayad ni Iyahta ago on mataw gibilensa in gigo daq meqinta gileh ugsa Iyahta gilumsiheq ta giwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","I gigo God in i ginan anad meqniysa in i gilowan diq tonaqta ham. Teq in ulilib osad i gilumsihaqta na in bilaqne i gigo sawab zeq ahokan gwalsa saw hastitayaq nazaq nog iyaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nazaq iysa teq i romriqab moqgo danteb osauqta na hulosad i le saw anuwanib tugwahtiqam ham. Gwahtiqeq ossa Iyahta dan giqisihuneq giqad lehsa i gigo hib bab hiqiysa i gigem kute nemsa tuqosam ham. ");
INSERT INTO mlp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ari amun na ayah tiqiyim in anad teq ahol bunmo zilimim in ago zaway inaq tiqiy. Iyim in lehim saw amatawun haiqtab osad in Isrel gimeb ulalab gwahtiqdaqta na akaman amen tiqemyaq. ");
INSERT INTO mlp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ari Elisabet Jon iqamta kam nagab Rom gigo maror ayah diqta anan Sisa Ogastus haqayta na in gamuk araq kazaq bilam, Yaqgo on mataw bunmo ginulinad teq ginan waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Na in gime ameb diqta on mataw ginuliniyta. Mat anan Kwiriniyus haqayta na in on mataw saw Siriya-ibta giwamuzim ossa daq na gwahtimta. ");
INSERT INTO mlp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ari Sisa nazaq haqan on mataw bunmo in gigo uliq diqtab ginan emnan tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Lehsa mat anan Josep haqayta na in Devit ago ned teq in asenlul araq iyim in uliq Nasaret saw Galiliy-ibta hulosim in Devit ago uliq Betlehem-ub saw Judiya-ibtab tilah. ");
INSERT INTO mlp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Lehad in ayow Mariya waqim inaq tilahmo. Ad in Mariya inaq nanmo wastitayim an a hi waqadmo Mariya agem tiqiy. Agem tiqiyan teq in giger ginan emnan haqad uliq Betlehem-ub tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lehim in uliq nab osad Mariya amun emgo akaman tiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Iyan in ago amun aqenta matta na tiqam. Emim in tubusanib isihim bulmakau didaq neqayta adegnib eman wo tuqus. Na ezaqgo bit bunmo ban haiq tiqiyan in asanib karuw abitnibmo osiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ari saw nab mataw sipsip giwamuzayta na asor in uliq adek ban pesan nog osad teq in taromab gigo sipsip giwamuz yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sa Iyahta ago angelo araq in gigerab tugwahtim. Gwahtiqanmo Iyahta ahol anuwan hitiqad mataw na tigiqisih nat. Giqisih netsa in tirab yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Rabsa angelo na gibilan, Ne hi rabiy ham. Ad ne huritiy ham. Ya gamuk araq dimun diqta on mataw bunmo gimen a bol ham. On mataw kabemmo gamuk ka huriteq teq in ginad tidimniy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Muran diqmo aw araq in Devit ago uliqab amun tiqam ham. Amun na ayah iyeq teq in ne gilumsiheq ta giwaqdaqta ham. In anan Krais ham. In ne gigo Iyahta ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne leheq amun na kazaq ahol tuwaq daqayta ham. In tubusanib isihim bulmakau didaq neqayta adegnib eman woqim usaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ari angelo na in nazaq haqad tursamo God ago hib angelo kabemmo in agerab tugwahtiqiy. Gwahtiqim in God abin iluwad bilaqiy, ");
INSERT INTO mlp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","I God anan sorid ulilibmo gwaleh bugan haqiy. Sa og kab on mataw God agem dimunta negaqta na in ginad dimniysa gigem kute nemsa osiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angelo nazaq haqadmo in mataw na gihulosad muleqim Heven-ib ta gwalehiy. Ari angelo gwalehsamo mataw sipsip giwamuzayta na an bulonim bilaqiy, I Betlehem-ub leheq nagah Iyahta anan bilamta ka i le ahol waquq haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Haqad in hidmo tilehiy. Lehim in Mariya aduw Josep inaq ossa tigibiyiy. Ad amun bulmakau didaq neqayta adegnib ussa in ahol tuwaqiymo. ");
INSERT INTO mlp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","In amun na ahol waqim teq in angelo amun anan gibilanta na ananin tutim tibilaqiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bilaqsa mataw huritiyta na bunmo in mataw sipsip giwamuzayta gigo gamuk na anan ginadnad emad gihol turuh nam. ");
INSERT INTO mlp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Teq amun anen Mariya in gamuk na huritan gamuk na bunmo in anadib tuqus bugyaq. Ussa in gamuk na anadin emad teq in anadibmo bilaqyaq, Ka yaqgo amunmo anan bilaqiyta ka in gamuk adugan ezaq diqta bilaqiy? haqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Teq mataw sipsip giwamuzayta na muleqim ta lehiy. Lehad angelo gamuk gibileniyta na teq in le nagah ahol waqiyta na bunmo ago in ginad dimniysa in God abin diq tiqiluw yaqay. Na ezaqgo angelo gibileniyta nazaqmo diq in le ahol waqiyta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ari abeb kam 8 nazaq tihiqiyan teq mataw in amun ahol abatan asan tuqurotim teq in anan Yesus haqad tibiyiy. Amun anen agemab a hi gwahtiqsamo angelo anan bilaqan usta nazaqmo in tibiyiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ari Mariya amun tiqemim in ahol udinim os. Osim tihiqiyan aw amun inaq gihol zaygo akaman tugwahtim, Moses ago marib gunun bilamta nazaq. Gwahtiqan Josep awe Mariya inaq in gigo amun ad Jerusalem-ub tilehiy, in amun Iyahta abenab emgo haqad. ");
INSERT INTO mlp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Na ezaqgo Iyahta ago maror Moses mar tonta na in kazaq bilam, Ne amun matta aqenta Iyahta ugid in agota iyeq tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nazaq iyan in Jerusalem-ub lehim Mariya amun emim ahol busirin iyta na ago tamaz ah amikmikta in tiqemiy. Na ezaqgo Iyahta ago maror in kazaq bilammo, Ne muluk amidgot giger o ah husta amikmikta giger tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Teq mat araq anan Simeon haqayta uliq Jerusalem-ub os. In mat titnonta teq in God anadin diq emyaqta. In mat Isrel on mataw gilumsihid dimunmo os daqayta na amatin baq tunim osyaqta. Ossa God ago Bugaw Dimunta in aholib usyaqta. ");
INSERT INTO mlp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Usad tekomo in Simeon tubulon. Ni hidmo a hi moqdaq ham. Iyahta ago mat Isrel gilumsihdaqta na amatin gwahtiqid ni ahol waqeq teq ni moqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ari kam nab God ago Bugaw Dimunta Simeon abe yahsa in le Tempel agelin aduganib tugwahtim. Gwahtiqim luwsa Yesus anen amam in gigo amun ad Tempel-ib tuboliymo. Giger na God ago gunun Moses bilamta na muzinim in Yesus ayon naw emnan haqad boliy. ");
INSERT INTO mlp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","29","Bolan Simeon gibiyad in gibenab amun waqim wazad in God abin iluwim kazaq bilam, Iyahta ham ya ningo kabibiy mat ham. Muran ni ya iwaqid ya inad dimniysa tumoqdaiq ham. Kwaziqmo ni ya ibilanta nazaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na ezaqgo ham mat ni emid bo i gilumsiheq ta giwaqdaqta na kawa ya ime anonabmo ahol tuwaqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Daq ka ni on mataw dauh bunmo gimeb eman tugwahtim ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Amun ka in on mataw en ta asor Juda a haiqta nagan giqemid in ningo tuhurit daqay ham. Bilaqne lam anuwan lehsa mataw saw ahol waq kemay nazaq ham. Amun ka in Isrel on mataw giduganib gwahtiqan iyan on mataw bunmo in Isrel gibin tiqiluw daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Haqan amun anen amam in Simeon ago gamuk in amun anan bilamta na huritim in gihol turuh nemyaq. ");
INSERT INTO mlp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Sa Simeon gibar tonad in amun anen Mariya kazaq bulon, Ni hurit ham. Amun ka in Isrel on mataw kabemmo eraqim turayta na giqothasid tuwoq daqay ham. Ad in on mataw kabemmo woqim usayta na giwazid tiqeraq daqay ham. Amun ka tarin nog osdaqta ham. Ossa mataw kabemmo ahol waqad tubaymuz daqay ham. Bay muzsa ni ahol waqad ni ninad ayahmo meqniydaq ham. Bilaqne baqir niqutil ulum tayaq nazaq nog ham. Amun ka ayah iyeq teq in mataw kabemmo ginad ulilemim usaqta na giqemid in ginad na ulal tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ari Simeon gamuk emim tihiqiyanmo aw araq anan Ana haqayta in gigerab tubol. Aw na in God ago nantut araq. In amam Fanuwel teq in ago gem anan Aser haqayta. Teq in aw adinowan diqta. Kwaziqmo in mat waqim inaq ulig 7 nazaqmo osta. ");
INSERT INTO mlp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Osim aduw tumoqan in wabur osad ago ulig 84 nazaq tiqiy. Aw na Tempel a hi hulosyaqta. Kam bunmo zeqab taromab inaqmo in God ayon lotu emad sirisirimo in didaq udinad teq in God inaq gamuk emyaqta. ");
INSERT INTO mlp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yesus anen amam in amun wazim nab tursamo aw na gigerab bolim amun ahol waqad in God esey tuqugyaq. Esey ugad teq in mataw asor nab turiyta na amun anan gibilenim bilam, God mat emid boleq i gilumsihdaqta na amatin i amen emim osauqta na in kawaqmo tugwahtim ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ari Josep awe Mariya inaq in nagah bunmo Iyahta ago marorib gunun bilamta na tiqem bugiy. Em bugim teq in muleqim gigo uliq Nasaret saw Galiliy-ibtab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Lehan amun na ayah iyad in ago zaway inaq tiqiyyaq. Ad in anad awaz timeqniyyaqmo. Sa God agem dimunta ugad tidimun tonyaq. ");
INSERT INTO mlp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ari ulig bunmo Yesus anen amam uliq Jerusalem-ub leh yaqayta, in Juda gigo lotu akaman ayahta anan Pasova haqay na ahol waqnan haqad. ");
INSERT INTO mlp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ad Yesus ago ulig 12 nazaq tiqiyan teq in anen amam gigo daq na muzinim in bunmo Jerusalem-ub tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lehim Pasova akaman na tihiqiyan in muleqim giquliqab ta bol yaqay. Bolsa amun Yesus uliq Jerusalem-ub tuqos tut. Os tutsa anen amam in Yesus Jerusalem-ub osaqta na a hi huritiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","In giger ginad emiy, Yesus tabag on mataw ta asor na nenaq tilehaq haqiy. Haqad kam amulikmo in muleqim danmo ta lehad teq imisor tiqiysa in gisenlul teq gikadoyniz gilikmanib amun tinagun yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","In amun nagunim le ahol a hi waqadmo in muleqim Jerusalem-ub amun nagim a ta lehiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lehim in bit ban bunmo amun nagunad luwad le kam ezeqmanta nab in Tempel ago gel aduganib amun ahol tuwaqiy. In gigo amun na in mataw Moses ago gunun asuleqin bilaqayta na gilikmanib osad in gigo gamuk huritad teq in gisusumun negyaq. ");
INSERT INTO mlp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sa mataw aseseqta na nazaqmo Yesus susumun ug yaqaymo. Susumun ugsa Yesus amenin emsa mataw nab osiyta na bunmo in Yesus anad awaz meqinta na teq in ago gamuk na huritad in ginadnad emad gihol turuh nemyaq. ");
INSERT INTO mlp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Samo Yesus anen amam nazaq in gigo amun ahol waqad in gihol ritan. Sa anen bulon, Ya itatin ham doq tonnan ni i giger kazaq giton? ham. Ya nimam inaq ginad meqniysa i ninagunad luwta ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Haqan Yesus gibilan, Nagaqgo ne bit bitmo ya inagunad luwiy? ham. Ya imammo ago bitab osdaiqta na ago ne a hi huritim teq ne ya inagunad luwiy ye? ham. ");
INSERT INTO mlp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Haqan anen amam in Yesus ago gamuk na huritim in alulin ginad a hi emiy. ");
INSERT INTO mlp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Samo Yesus eraqim anen amam nenaq uliq Nasaret-ib tilehiy. Lehim nab in anen amam giqez huritad ginad muzad tiluwyaq. Sa daq nagan bunmo anen anadib us bugsa in anadin emad osyaq. ");
INSERT INTO mlp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ari Yesus uliq nab osad ayah tiqiy bugim in anad teq ahol bunmo tizilim bug. Sa God teq on mataw bunmo in Yesus ahol waqad in gigem dimunta ug yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ari mat anan Sisa Taiberiyas haqayta na in Rom gigo king iyim ossa ago ulig 15 nazaqmo tiqiy. Iyan kam nab Pontiyus Pailat saw Judiya wamuzyaq. Sa Herot saw Galiliy wamuzsa in amikqan Filip saw gigermo Ituriya teq Trakonitis giwamuzim osyaq. Ossa mat anan Lisaniyas haqayta na saw Abilin wamuzad osyaqmo. ");
INSERT INTO mlp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Sa Isrel gimuganib mat anan Anaz haqayta na amam Kayafas inaq in tamaz mataw danmebta iyim os yaqay. Ossa kam nabmo Sekaraya atatin Jon gwahtiqim saw araq amatawun haiqtab ossa God ago gamuk in anadib tugwahtim. ");
INSERT INTO mlp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Gwahtiqan in yuw Jodan aqurumnib uliq saw bunmo luwad in on mataw God ago gamuk tigibilenyaq. Gibilenad in bilaqyaq, Ne ginad buliyeq ne gigo daq teq ginad meqinta bunmo gileh ugiy haqyaq. Gileh ugad ne bolsa ya huz negiq haqyaq. Ne nazaq emsa teq God ne gigo daq teq ginad meqinta na tigiwalem bugdaq haqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ari Jon gwahtiqim nazaq emad luwad in kwaziqmo God ago nantut Aisaya gamuk mar tonta na tuwol net bug. Aisaya bilam, Mat na aqez saw amatawun haiqtab lileyim bilaqaq, Ne Iyahta ayon dan balaw toniy haqaq ham. Ad ne in ayon dante na wastitayid titnonan haqaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iyahta boldaqta kam nab garah bunmo aseseqta teq amikmikta inaqmo giqurotid woqid saw agemqanmo tiqiydaq haqaq ham. Ad akalhonan usaqta na bunmo ituq bugid in nazaqmo agemqan tiqiydaqmo haqaq ham. Dan kok tonim usaqta na bunmo tititnon bug daqay haqaq ham. Ad dan bunmo gig ate usaqta na wolid in ate tihiqiy bugdaq haqaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kam nab God in ago on mataw gilumsihad giwastitaysa og kab on mataw bunmo tigibiy daqay haqaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ari on mataw kabemmo Jon i huz igdaq haqad agerab tubol yaqay. Bolsa Jon gibilan, Ne ured amidgotniz ham. God teq ne ginan agem meqniysa gimeqin tondaqta na nog gibilenan ne tukim gigbeb leh nog iyay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ne ginad meqniysa gigem buliyid teq ne gigo daq nazaqmo tubuliydaq ham. Luweq ne ginad kazaq em daqay ham. I Abraham asenlulibta haq daqay ham. Nazaq iyan God anad dimunta igad a hi gimeqin tondaq haq daqay ham. Nazaq ne ginad hi emiy ham. Ya ne gibilenaiq ham. God gig kag gibilenid buliyeq Abraham asenlulniz iygo azawayin in aholib usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Talgis ay abeqarib tuqusaq ham. Ay bunmo anon dimunta a hi emaqta na in qwayeq faqab hunegid le tuqoydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","In nazaq haqanmo on mataw dauh biyahta na Jon tisusumun ugiy, I ezaq toneq teq i gigem tubuliyta na mataw tigiqisihunam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Haqan Jon gibilan, Ne daq kazaq emiy ham. Mat ago tubusan giger usaqta na in araq mat ago tubusan haiqta na ugan ham. Sa mat ago didaq inaqta na in nazaqmo eman ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Haqsa mataw takis waqayta na asor in Jon huz igdaq haqad ago hib tuboliymo. Bolim in Jon susumun ugiy, Ta igmo teq ezaq tonam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Haqan Jon gibilan, Gavman gibilanta nazaqmo ne takis waqiy ham. Ad ne katiyeq mani asor samanmo ta hi waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Haqan ta mataw bab emayta asor nab turiyta na in susumunim bilaqiy, Ta i teq ezaq tonam? haqiy. Haqan Jon gibilan, Ne mataw tor negad giqutil ulumad gigo mani hi rin toniy ham. Ad ne hazizirib katiyad mataw gimalib nan emad gigo mani samanmo hi waqiy ham. Teq ne kabiy emayta na anawun waqad nan kabemmo hi bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Haqsa on mataw bunmo Jon ahol waqad giqutil eraq yaqay. Ad in ginadnad emad in gimo gihol buloneq bilaq yaqay, Luweq mat ko in Krais iydaq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Haqsa Jon in bunmo gibilenim bilam, Ya ne yuwibmo huz negaiqta ham. Ari mat araq teq ya ibeb boldaqta na abin in ya ibin uriyamta ham. Ya in ahaqenibta ham. In yaqgo Iyahta ham. Ya in ago kabibiy mat samanta ham. In boleq nagah giger God ago Bugaw Dimunta teq faq inaq gimalib ne tuhuz negdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","In abenab sabol wazim in ago wit wolayta asawnib wit tigiluwiynan ham. Giluwiyad in wit anagin dimunta na ginuweq ago wit abitnib humab tuwoldaq ham. Humab wolad in wit asan meqinta na ginuweq faq a hi miyaqtab hunegid le tuqoydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Haqad Jon gamuk naqanta kabemmo amalib on mataw ginad wazan eraqsa teq in God ago gamuk dimunta gibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Teq king Herot in ama awe Herodiyas hureqim waqan Jon tuwadyaq. Wadad in Herot daq meqinta kabemmo amta na ago tuwadyaqmo. Wadsa Herot ago daq meqinta kabemmo aholib usta na amalib in daq ta araq meqin diqta emim in Jon wazim tiqirqur. ");
INSERT INTO mlp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ari Herot in Jon a hi irqursamo Jon on mataw bunmo huz negad teq in Yesus tuhuz ugmo. Huz ugan Yesus God inaq gamuk emad tursa kait misireq nog iyim aqez hasan God ago Bugaw Dimunta ahol buliyim ah husta nog iyim Yesus amalib tigehitim. Gehitiqan Heven-ib God aqez bilam, Ni ya itatin ham. Ya ni ninan inad bilaqsa ya igem dimun diq iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ari Yesus ago ulig 30 nazaq tiqiyan teq in ago kabiy alulin tiqam. Teq on mataw in ahol alulin diq a hi huritim iyan in anan bilaq yaqay, Josep-mo atatin haq yaqay. Teq Josep in Heli atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Sa Heli in Matat atatin. Sa Matat in Liway atatin. Sa Liway in Melki atatin. Sa Melki in Janay atatin. Sa Janay in Josep atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sa Josep in Matatiyas atatin. Sa Matatiyas in Amos atatin. Sa Amos in Nahum atatin. Sa Nahum in Esli atatin. Sa Esli in Nagay atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Sa Nagay in Maqat atatin. Sa Maqat in Matatiyas atatin. Sa Matatiyas in Semen atatin. Sa Semen in Josek atatin. Sa Josek in Joda atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sa Joda in Jowanan atatin. Sa Jowanan in Resa atatin. Sa Resa in Zerubabel atatin. Sa Zerubabel in Sealtiyel atatin. Sa Sealtiyel in Neri atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Sa Neri in Melki atatin. Sa Melki in Adi atatin. Sa Adi in Kosam atatin. Sa Kosam in Elmadam atatin. Sa Elmadam in Er atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Sa Er in Josuwa atatin. Sa Josuwa in Eliyezer atatin. Sa Eliyezer in Jorim atatin. Sa Jorim in Matat atatin. Sa Matat in Liway atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Sa Liway in Simeon atatin. Sa Simeon in Juda atatin. Sa Juda in Josep atatin. Sa Josep in Jonam atatin. Sa Jonam in Eliyakim atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Sa Eliyakim in Melea atatin. Sa Melea in Mena atatin. Sa Mena in Matata atatin. Sa Matata in Natan atatin. Sa Natan in Devit atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Sa Devit in Jesi atatin. Sa Jesi in Obet atatin. Sa Obet in Bowaz atatin. Sa Bowaz in Salmon atatin. Sa Salmon in Nason atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Sa Nason in Aminadab atatin. Sa Aminadab in Atmin atatin. Sa Atmin in Arni atatin. Sa Arni in Hesron atatin. Sa Hesron in Peres atatin. Sa Peres in Juda atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Sa Juda in Jekob atatin. Sa Jekob in Aisak atatin. Sa Aisak in Abraham atatin. Sa Abraham in Tera atatin. Sa Tera in Nahor atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Sa Nahor in Serug atatin. Sa Serug in Rew atatin. Sa Rew in Pelek atatin. Sa Pelek in Eber atatin. Sa Eber in Sela atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sa Sela in Kainan atatin. Sa Kainan in Arpaksat atatin. Sa Arpaksat in Siyem atatin. Sa Siyem in Nowa atatin. Sa Nowa in Lamek atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Sa Lamek in Metusela atatin. Sa Metusela in Enok atatin. Sa Enok in Jaret atatin. Sa Jaret in Mahalalel atatin. Sa Mahalalel in Kainan atatin. ");
INSERT INTO mlp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Sa Kainan in Enos atatin. Sa Enos in Set atatin. Sa Set in Adam atatin. Sa Adam in God atatin. ");
INSERT INTO mlp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ari God ago Bugaw Dimunta Yesus aholib ayahmo diq tuqusyaq. Ussa Yesus yuw Jodan hulosim muleqim ta lehsa God ago Bugaw Dimunta in waqim ad saw araq amatawun haiqtab tilah. ");
INSERT INTO mlp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A lehan Satan kam 40 nazaqmo Yesus ulum waqad luwyaq. Luwsa kam nab Yesus didaq haiqmo osyaq. Ossa kam 40 na le tihiqiyan in agem tumoqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","In agemnan moqad ossa Satan bolim tubulon, Ni God atatin iyeq teq ni gig ka bulonid in buliyeq bret iyid ni neq ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Haqan Yesus amenin emim bulon, God ago marib gamuk araq kazaq bilam ham. Bret amomo in mat eman kayeqmo a hi osaqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Haqan Satan in Yesus waqim garah araq abigmanib a gwalehim muran diq nawaqmo in kantri bunmo tiqisihun bug. ");
INSERT INTO mlp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Isihun bugad in Yesus bulon, Ya kantri aseseqta kogan bunmo giqemid ni nihaqenib iysa ni nibin ayahmo diq iydaqta ham. Nagah kogan bunmo ya ibenab ussa ya giwamuzaiqta iyan ya mat araq ugnan inad bilaqid ya tuqugdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nazaq iyan ni mulbuneq ya ibin iluwid teq nagah ko bunmo in ningo tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Haqan Yesus amenin emim bulon, God ago marib gamuk araq kazaq bilam ham. Iyahta in ningo God haqad in bilam ham. Ni in amomo abin iluwad ago kabiy emdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Anmo mat meqinta na in waqim ad uliq Jerusalem-ub tilah. A lehim in Tempel abigmanib Yesus eman tursa in bulon, God ago marib gamuk araq kazaq bilam ham. God in ago angelo gibilenid in ni nitawanan emad tinibiy muz daqay haqad in bilam ham. Nibiy muzad in boleq gibenab tinisor daqay haqad in bilam ham. Luweq ni nisen gigib woltaydaq haqad in bilam ham. Nazaq iyan ni God atatin iyeq teq ni kab sortukeq woq ham. Woqsa ni nimam nilumsihsa ya nibiyiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Haqan Yesus amenin emim bulon, Teq God ago marib gamuk araq kazaq bilammo ham. Iyahta in ningo God haqad in bilam ham. Nazaq iyan ni girerey emad in hi ulum waq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ari Satan daq nag bunmo amalib Yesus tuqulum waqim in hulosadmo tilah. Lehad in anad emyaq, Kam ta araqab teq ya a ta ulum waqdaiq haqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ari God ago Bugaw Dimunta Yesus aholib zaway diq iyim ussa in muleqim saw Galiliy-ib a ta lah. Lehim ossa in abin saw nab uliq bunmo tilehyaq. ");
INSERT INTO mlp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sa Yesus saw nab uliq-uliqgo luwad in ago daq muzineq tuteqmo in mataw gigo bit humab wolaytab gwahtiqeq suleq tinegyaq. Negsa on mataw bunmo in ago gamuk huritad abin tiqiluw yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ari Yesus saw nagab luwimmo in ago uliq diq Nasaret-ib tilah. Uliq nab in osad ayah iy bugta. In nab le osad Juda gigo lotu akamnib in ago daq muzinim bit humab wolaytab le tugwahtim. Gwahtiqim osad teq in God ago gamuk bilaqnan haqad eraqim titur. ");
INSERT INTO mlp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tursa mat araq God ago gamuk nantut Aisaya mar tonta na waqim a bo Yesus tuqug. Ugan in hasim mar nagunim le ahol tuwaqim teq in kazaq bilam, ");
INSERT INTO mlp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Iyahta ya itowun emim ibilan, Ni mataw ginaghan haiqta yaqgo gamuk dimunta tigibilendaq haqad in bilam ham. In ya inan nazaq haqad teq in ago Bugaw Dimunta yagan ya iholib tuqusaqta ham. Ussa Iyahta iqeman ya gamuk kazaq on mataw gibilennan tubol ham. Mataw giqirquran osayta na ya ne giqamun hasid ne samanmo tiluw daqay haqaiq ham. Teq mataw gime haiqta na ya ne gime wastitayid ne saw ahol tuwaq daqay haqaiq ham. Ne mataw afaqan kabemmo gisorayta na ya ne gigo afaqan giholib walemid ne gihol tisinamoldaq haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Teq ya bilaqaiq, Iyahta in ago on mataw gidimun tondaqta na akaman tugwahtiqaq haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesus gamuk na bilaq bugim tihiqiyan in sansandek na tal tonim mat wamuzaqta na ugad in le tuqos wom. Os woqim ossa on mataw bit nab osiyta na bunmo in Yesus ahol tuwaninun yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ahol waninunsa Yesus in gamuk bilamta na alulin emim gibilan, Muran mat araq God ago mar ne nawa tuhuritiyta na wol net bugsa ne ahol tuwaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ari on mataw uliq nabta na bunmo Yesus abin tiqiluw yaqay. Ad in Yesus aqezab gamuk dimunta gwahtiqyaqta na huritad gihol turuh nemsa teq in bilaq yaqay, Ka Josep-mo atatin a haiq e? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Haqsa Yesus gibilan, Helmo ham. Ne teq kazaq ibilen daqay ham. Ni i gimen daq araq a hi emaq haq daqay ham. Kapaneam-ub ni daq azawayin inaqta eman i abin huritta naqanta araq ninmo ningo uliq kabmo emsa i ahol a hi waqauq haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Teq ya helmo ne gibilenaiq ham. God ago nantut ago uliqabmo diq in ahol abin haiqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ya ne gibilen kemaiq ham. Kwaziqmo Elaija ago kamub zarow araq ayah diqta saw bunmo gwahtim ham. Gwahtiqan ulig ezeqman teq aweweqta na asormo urom a hi wom ham. Kam nab Isrel-ib on waburta kabemmo osiyta ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ta teq God in Elaija eman ago on mataw Isrel gigo aw waburta araq ulumsihnan a hi lah ham. Haiq ham. In Elaija eman on mataw en ta araq Juda a haiqta naqmo gigo saw anan Saidon haqayta nab in lah ham. Lehim uliq anan Sarefat haqayta nabmo in aw waburta araq ulumsih ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ad nazaqmo ham. God ago nantut anan Elisa haqayta na ago kamub mataw gigo moq lepra inaqta kabemmo Isrel-ib osiyta ham. Teq God in ago mataw Isrel na gilikmanib araq ago moq lepra wastitayan a hi dimniy ham. Haiq ham. In mat anan Naman haqayta naqmo amomo ulumsihan ahol dimniy ham. Mat na in on mataw en ta araq Juda a haiqta ginan Siriya haqayta naqmo gigo araq ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesus nazaq Isrel on mataw gibin wazan woqan bit nab mataw bunmo huritim gigem meqin diq iy. ");
INSERT INTO mlp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","Gigem meqniysa in eraqim Yesus muzan uliq asan ban gwahtim. Gwahtiqan in waqim ad in gigo uliqab garah araq abigmanib saw ban meqintab usaqta nab in hunegid woqdaq haqad adek ban a lehiy. Teq haiq. Yesus mataw na gilikmanib gwahtiqim gihulosad tilah. ");
INSERT INTO mlp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ari Yesus uliq Kapaneam saw Galiliy-ibtab tilah. Lehim Juda gigo lotu akamnib in on mataw suleq tinegyaq. ");
INSERT INTO mlp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Suleq negsa on mataw in ago gamuk huritad gihol turuh nem yaqay. Na ezaqgo Yesus bilaqne God inmo abin ugan in suleq bilaq nog iyyaq. ");
INSERT INTO mlp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Samo mat araq aholib bugaw meqinta usaqta na in Juda gigo bit humab wolayta nab osmo. Osim in dedibmo lileyim bilam, Sey! ham. Yesus Nasaret-ibta ham ni i ezaq gitonnan bol? ham. Ni i gimeqin tonnan daqag ni bolya ham. Ya ningo tuhurit ham. Ni God ago mat tawon diqta naqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Haqsa Yesus wadim bulon, Ni niqez hiqiy ham. Ad bugaw meqinta ni mat na hulosad gwahtiqeq leh ham. Haqan bugaw meqinta na in mat na othasan le mataw gilikmanib woqsa in hulosad gwahtiqim tilah. Lehad in mat na santitiy araq a hi ug. ");
INSERT INTO mlp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Anmo mataw bunmo gihol riten lamsa in an tubulon yaqay, Mat ka ago gamuk azawayin inaqta ka in naga gamukin diq? haq yaqay. In bugaw meqinta gamukmo gibilensa in gwahtiqim lehayta haq yaqay. Bilaqne in God ago zawayibmo bugaw gibilen nog iyaq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mataw nazaq haqad bilaqsa Yesus abin saw nab uliq bunmo tileh bugyaq. ");
INSERT INTO mlp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ari Yesus eraqim bit humab wolayta na hulosad in Saimon ago bitab tilah. Lehan Saimon alen aqawun moq waqim asan afan meqin diq iyim banab ussa in Yesus tubuloniy. ");
INSERT INTO mlp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bulonan in loqim ban aw usaqta na agerab turad gamuk atoranmo bilaqanmo aw asan afan iyim usta na hulos ugim nabag tilah. Lehanmo in eraqim gimen didaq anaran usta na a bolim tinag. ");
INSERT INTO mlp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ari zeq tuwolehsa mataw in giyogniz gigo moq amo amo usaqta na giwaqim giqad Yesus ago hib tuboliy. A bolan Yesus mataw na amulik-mulikmo giholib aben emim giwazsa in tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sa bugaw meqinta on mataw kabemmo giholib usiyta na in gihuloseq lehad lileyeq bilaq yaqay, Ni God atatin haq yaqay. Haqsa Yesus ginadad gibilensa in giqezmo hiqiyeq leh yaqay. Na ezaqgo bugaw na in Yesus ahol alulin in Krais na ago tuhuritiyta iyan. ");
INSERT INTO mlp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ari tarom iyim saw tihastitayim bolsa Yesus uliq na hulosim saw araq amatawun haiqtab tilah. Lehan teq on mataw in tinagun yaqay. Nagunim lehim ahol tuwaqim teq in tuwasih yaqay, luweq in i gihuloseq lehdaq haqad. ");
INSERT INTO mlp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sa Yesus gibilan, Ne ya hi iwasihiy ham. Ya mataw kabta gibilenta nazaqmo ya uliq bunmo leheq God ago maror agamukan dimunta na in tigibilendaiqmo ham. Ya kabiy naqmo emgo haqad God ya iqeman bolta ham. ");
INSERT INTO mlp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Haqad teq in saw Judiya-ib uliq bunmo luwad in Juda gigo bit humab wolaytab gwahtiqeq God ago gamuk tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ari kam araqab Yesus yuw Genesaret aqurumnib tursa on mataw kabemmo God ago gamuk huritnan haqad in agerabmo diq loqim os yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ossa muy amikmikta giger kamis aqezab ussa Yesus tigibiy. Muy na ginamreniz muy hulosim in gigo dob nabiq waqayta na tisuhol yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Samo Yesus le muy na araqab gwalim tuqos. Na in Saimon ago muyibmo gwal. Gwalim in Saimon bulon, Ni muy ulum hasid in lan ez asit hulos ugeq usan ham. Haqan Saimon nazaq eman Yesus muy nab osad on mataw gamuk tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ari in gamuk gibilenim tihiqiyan in Saimon bulon, Muy hureqid kamismeb mayawabmo diq lehan ham. Lehid teq ne dob huneg woqid nabiq waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Haqan Saimon amenin emim bilam, Mat Iyah ham i tarom kab nabiq nagunad luwsamo saw tihastitay ham. Sa i nabiq araq diq a hi waw ham. Ta teq ya na ago a hi bilaqad ya ni niqez muzineq le dob a ta hunegeq teq saw ta waqdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Haqad in le dob a ta huneganmo nabiq kuluw diqmo dobub tuwoqiy. Woqan dob titartaynan tonyaq. ");
INSERT INTO mlp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nazaq iysa Pita ayogniz nenaq in gigo kadoyniz asor muy araqab osiyta na gililewunan bo tigilumsihiy. In bolim muy giger nab nabiq ginuwan woqsa muy ame tugwal. Ame gwalan muy giger na munannan toniy. ");
INSERT INTO mlp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Samo Saimon Pita ayogniz nenaq muyib osad nabiq kabemmo diq waqiyta na gibiyad in gihol riten lamsa tirab yaqay. Rabsa Sebediy atatniz giger Jems ama Jon inaq in Pita inaq araqibmo kabiy em yaqayta na in muy ta araq nab osad tirab yaqaymo. Sa Pita in Yesus anognib kuh tonim asen ulum laquwim turad bilam, Iyahta ham ni ya ihuloseq leh ham. Ya mat dimun a haiq ham. Haqan Yesus bulon, Ni hi rab ham. Ni nabiq giwaqad luwaqta kazaqmo muran teq abeb ni on mataw nazaqmo tigiwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ari mataw na muy hureqim a le lan ezab emad teq in gigo nagah bunmo hulosad in Yesus muzim inaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ari kam araqab Yesus le uliq araqab tuqos. Ossa mat araq ago moq lepra inaqta bolim Yesus ahol waqadmo in abakbakan ulum laquwim turad afaqin mulbunim ogib emim teq in tisusumun ug, Iyahta ham ni ninad bilaqsa teq ni ya iwastitayid ya God ameb isan anumlan ka tihiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Haqan Yesus aben itiwunim mat na wazad bulon, Ya inad bilaqaq ham. Ni nisanib ninumlan usaqta na hiqiyan ham. Haqan muran diq nawaqmo mat na ago moq lepra tihiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hiqiyan Yesus atoranmo bulon, Ni leheq daq kawa ya niholib emta ka ago ni mat araq hikidik bulon ham. Ni leheq mat tamaz emaqta naqmo nihol isihun ham. Ad Moses bilamta nazaqmo ni nihol dimniyta na anawun em ham. Emid teq mataw in ningo moq tihiqiyta na ago tuhurit daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Teq haiq. Daq na amalib Yesus abin ayah diqmo iyim saw bunmo tilehyaq. Lehsa on mataw dauh kabemmo in Yesus ago gamuk huritnan teq in giholib moq usaqta na wastitaygo haqad tubol yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bolsa Yesus sirisirimo on mataw na gihulosad saw amatawun haiqtab leheq God inaq gamuk tiqemyaq. ");
INSERT INTO mlp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ari kam araqab Yesus on mataw suleq negad tuqos. Ossa Farisi asor giyogniz mataw Moses ago gunun asuleqin bilaqayta na nenaq in nab osiymo. Mataw aseseqta na in uliq bunmo saw Galiliy-ibta teq saw Judiya-ibta teq uliq Jerusalem-ub osim boliyta. Bolim nab ossa Iyahta ago zaway mataw giqemid dimniygo Yesus aholib ayahmo usyaq. ");
INSERT INTO mlp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sa mataw asor in mat araq abensen aditin tumoq bugta abanan inaq sorim a boliy. A bolim in mat na soreq ad bit aduganib leheq Yesus agerab loqgo em yo hiqiy yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na ezaqgo on mataw kabemmo diq bolim ban tuwaq bugan in mat na ad Yesus agerab loqgo adanin haiq. Nazaq iyan in bit ahuqunib gwalehim asor tihikneriy. Hiknerim in mat na abanan inaqmo eman on mataw gilikmanib wolehim Yesus anognib tuqus. ");
INSERT INTO mlp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ussa Yesus in mataw na ginad helta ahol waqadmo in mat moqaqta na tubulon, Kadoy ham ya ningo daq meqinta tigiwalem bug ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Haqan mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq in Yesus ago gamuk na huritim in gimo an bulonad tisusumun yaqay, Ko nog in nazaq God ago ban waq nog iyim God bilawunaq? haq yaqay. Og kab mat araq mataw gigo daq meqinta walemdaqta haiqgam haq yaqay. Naqmo God amomo ago kabiyta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Haqsa Yesus in gigo susumun na huritim gibilan, Doq tonnan ne ginad haresmo nazaq emay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ya naga gamukin bilaqid teq ne nan a hi yag daqay? ham. “Ya ningo daq meqinta tigiwalem” haqdaiq o “Ni eraqeq loq gel” haqdaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Teq Mat Atatin in og kab daq meqinta walemgo azawayin aholib usaqta na ago ne hurit daqay haqad ya kazaq diq bilaqdaiq ham. Haqad in mat abensen moqan banab usaqta na tubulon, Ya nibilenaiq ham. Ni eraqeq ningo us ban waqeq ad ningo bitab a leh ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Haqanmo mat na on mataw gimeb eraqim ago ban in amalib usta na sorim ad ago bitab tilah. Lehad in God abin tiqiluwyaq. ");
INSERT INTO mlp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Samo on mataw nab osiyta na bunmo ritenim in ginadnad tiqem yaqay. Ad in God abin iluwad bilaq yaqay, Muran i daq lul araq diqta ahol tuwaw haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ari abeb Yesus lehim in mat takis waqaqta araq anan Liway haqayta takis abitnib ossa ahol tuwam. Ahol waqad in tubulon, Ni ya imuzeq bol ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Haqan Liway eraqim ago nagah bunmo hulosan ussamo in Yesus muzim inaq tilah. ");
INSERT INTO mlp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Abeb Liway in ago bitab Yesus amen didaq oyad humab araq ayahta tiqam. Emim in Yesus inaq banab didaq neqad ossa mataw gibin meqinta takis waqayta na teq mataw ta asor kabemmo nenaq in Yesus inaq didaq neqad tuqosiymo. ");
INSERT INTO mlp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ossa Farisi asor teq in gigo mataw Moses ago gunun hurit kemiyta na asor nenaq gimot meqniysa in Yesus ago disaipel tigibileniy, Doq tonnan ne mataw takis waqayta na teq mataw daq meqinta emayta na nenaq garabmo didaq neqad yuw uluwad osay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Haqan Yesus in gigo gamuk amenin emim bilam, Mataw gigo moq haiqta na in le dokta ahol a hi waqayta ham. Mataw gigo moq inaqta naqmo dokta ago hib lehayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ya on mataw titnonta gililewunnan a hi bol ham. Ya on mataw daq meqinta emad osayta naqmo gililewunnan bolta ham. Gililewunid in ginad buliyeq gigo daq meqinta na gileh ug daqay haqad ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Haqan mataw aseseqta na in Yesus buloniy, Jon ago disaipel sirisirimo didaq udinad God inaq gamuk emayta haqiy. Ad Farisi gigo disaipel nazaqmo emayta haqiy. Ta teq ningo disaipel didaq a hi udinayta haqiy. In didaq neqad wain ayun uluwayta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Haqan Yesus gibilan, Mat araq aw waqnan tonsa in ayogniz boleq inaq ossa ne in giqemid didaq udin daqay ye? ham. Haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ari abeb mataw asor boleq mat aw waqaqta na ayogniz gibenab tuwaq daqay ham. Kam na teq boldaqta ham. Bolid kam nab teq mat na ayogniz didaq tuqudin daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Haqad Yesus gamuk awowun ta araq kazaq gibilan, Mataw in gigo tubusan kwaziqta tartayan in gigo tubusan muturta asor hiksireqim tubusan kwaziqta na inaq a hi initayta ham. In nazaq tonid tubusan muturta na timeqniydaq ham. Ad tubusan asor muturta na in kwaziqta na inaq a hi iydaqmo ham. Muturta na a hi ulilemsa kwaziqta na awaq timeqniydaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Teq mataw wain ayun muturta memeq asan kwaziqtab a hi tenayta ham. In nazaq tonid wain aqurin gwalad huhuw nemsa memeq asan kwaziqta na tartayid wain ayun na tumutbaldaq ham. Ad memeq asan na timeqniydaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mataw memeq asan muturtamo waqim wain ayun muturta tenayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Haqad Yesus bilam, Mataw wain ayun kwaziqta tuquluwiyta na bunmo in wain ayun muturta hulosayta ham. Hulosad in bilaqay, Wain kwaziqta naqmo aquluw dimunta haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ari Juda gigo lotu akaman araqab Yesus ago disaipel nenaq kabiy araq wit leyiyta aduganib gwahtiqim tileh yaqay. Lehad Yesus ago disaipel wit anagin asor guraqim gibenab iworad tineq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Neqsa Farisi asor gibiyad bilaqiy, Nagaqgo ne lotu akaman ago gunun itiyonim kabiyab wit tuguraqay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Haqan Yesus in gigo gamuk amenin emim gibilan, Nabag ne Devit ago dauh nenaq gigem moqsa Devit daq amta na awagamun ne ahol a hi waqiy-ya ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devit le God ago bit aduganib gwahtiqim God ameb bret eman osta na in waqim tinam ham. Bret na gunun emiyta ham. Mataw tamaz emayta naqmo gimomo bret na neqayta ham. Teq haiq ham. Devit agem moq titaysa neqad in bret tawonta na asor in ayogniz negan tineqiymo ham. Ta teq in daq meqinta a hi emiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Haqad in gibilan, Mat Atatin in lotu akaman anamrenmo diq iyim inmo mataw kam nab ezaq luw os daqayta na ago tigibilendaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ari Juda gigo lotu akaman ta araqab Yesus le Juda gigo bit humab wolayta araq aduganib gwahtiqim in on mataw suleq tinegyaq. Negsa mat araq aben akogan aqabun ger anedan mayim aditinmo usaqta in nab os. ");
INSERT INTO mlp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ossa mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq in Yesus ahol waq kemad nab osiymo, Yesus lotu akamnib mat aben meqinta na wastitayid dimniyid i amalib nan emam haqad. ");
INSERT INTO mlp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Haqsa Yesus in ginad na tuhuritim in na ago a hi bilaqadmo in mat aben meqinta na tubulon, Ni eraqeq bo kab tur ham. Haqan mat na eraqim le nab titur. ");
INSERT INTO mlp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tursa Yesus mataw aseseqta na gibilan, Ya ne susumun negaiq ham. I Juda gigo maror ezaq usaq? ham. Lotu akamnib i mataw gidimun tonamta o i gimeqin tonamta? ham. Kam na i mat moqaqta ulumsihamta akaman o i mat na aholib hiqiyid in moqdaqta akaman? ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Haqad in ame le mataw na gibiy bugim teq in mat na bulon, Niben itiwun ham. Haqan mat na aben itiwunimmo in aben akogan na tidimniy. ");
INSERT INTO mlp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dimniyan mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq in Yesus anan gigem meqin diq iysa in gimo an bulonad in Yesus ezaq ton daqayta na ago tibilaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ari kam nagab Yesus God inaq gamuk emnan haqad garah araq abigmanib tugwalah. Gwalehim tarom nab in God inaq gamuk emad ossa le saw tihastitay. ");
INSERT INTO mlp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Saw hastitayan tarommo zeq tugwalsamo Yesus in ago disaipel gililewunan agerab tuboliy. Bolan in gilikmanib mataw 12 nazaq in aholyon gitowun emim in ginan Aposel haqad tibiy. ");
INSERT INTO mlp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Na in ginan kazaq: Saimon, Yesus anan araq Pita haqad biyta. Teq Saimon amikqan Andru teq Jems ama Jon inaq teq Filip teq Bartolomyu teq Matyu teq Tomas teq Alfiyus atatin Jems teq Saimon ta araq mat Rom nenaq bab emyaqta amatin na ");
INSERT INTO mlp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","teq Jems atatin Judas teq Judas ta araq uliq Kariyot-ibta na. Mat naqmo anad buliyim Yesus waqim bab gibenab amta. ");
INSERT INTO mlp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ari Yesus ago mataw na nenaq garahab gewoqim in le saw agemqantab ago disaipel dauh biyahta na nenaq tituriy. Tursa on mataw kabemmo saw Judiya-ibta teq uliq Jerusalem-ubta teq uliq giger Tair teq Saidon gigo lan ezabta na in bolim Yesus ago hib humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mataw na Yesus ago suleq huritnan teq in gigo moq emid dimniynan haqad in boliyta. Bolan Yesus in gigo bugaw meqinta giholib usad gimeqin ton yaqayta na gimuzan lehsa in tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sa on mataw biyahta na bunmo Yesus asan waz waqnan ton yaqay. Na ezaqgo in aholib zaway gwahtiqeq le mataw gigo moq inaqta na bunmo giqemid dimniy yaqayta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ari Yesus ame gwalim ago disaipel gibiyad gibilan, Ne mataw ginaghan haiqta ham ne teq God ago maror aduganib gwahtiqeq anononmo tuqos daqay ham. Nazaq iyan ne tidimniyim osayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Teq ne mataw gigemnan moqayta ham God teq nagah negid ne tigiyunindaq ham. Nazaq iyan ne tidimniyim osayta ham. Teq ne mataw gaqad osayta ham ne teq tiyuquw daqay ham. Nazaq iyan ne tidimniyim osayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ne Mat Atatin muzinad inaq luwsa mataw ne ginan gigem meqniysa tigibaymuz daqay ham. Ad in ne gibilawunad gigilehunan tibilaq daqaymo ham. In nazaq ne gitonsa ne ginad dimniyan ham. Ne tidimniyim osayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mataw nazaq ne gitonsa ne gigem dimniysa ginad dimun dikan iyan ham. Na ezaqgo ne gigo naw ayahmo Heven-ib ne gibaq tunim usaqta ham. Mataw ne gimeqin tonayta na gisesan in nazaqmo God ago nantut gimeqin ton yaqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ari ne mataw ginaghan kabemmo usaqta ham ne timeqniyim osayta ham. Nagah ne gigem emid dimniydaqta na ne muranmo tuwaqay ham. Abeb teq ne God abenab naw araq dimunta a ta hi waq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Teq ne mataw muran didaq neqad gigem aseseqmo iyayta ham ne timeqniyim osayta ham. Abeb teq ne gigemnan tumoq daqay ham. Teq ne mataw muran yuquwayta ham ne timeqniyim osayta ham. Abeb ne gaq wazad atoranmo tigaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Teq mataw og kabta bunmo in ne ginan dimunta haqsa ne gihol waziy ham. In nazaq ne gibin iluwsa ne timeqniyim osayta ham. Kwaziqmo mataw na gisesan gibaqbaqniz in nantut katiyta na nazaqmo ginan dimunta haq yaqaytamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Haqad Yesus bilam, Ne mataw ya iqez huritayta na ya ne kazaq gibilenaiq ham. Ne gibabun ginan ginad bilaqan ham. Ad mataw gigem meqinta negsa ne gilowan toniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mataw ne kusluw negsa ne gidimun toniy ham. Ad mataw ne gibilawunsa ne in gimen God susumun ugid gilumsihan ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mat araq nimanmanan asor ger wolid ni nimanmanan ta asor ger buliyid in wol tonanmo ham. Ad mat araq ningo saket waqsa ni ningo niholsihen ugid in waq tonanmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mat aw nog in ningo nagah anan sunid na ni neg ham. Ad mat araq ningo nagah araq waqid ni anan ta hi bilaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","On mataw in ne ezaq gitonid ne ginad dimniydaqta nazaqmo ne in gigo hib daq emiymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ari mataw ni ninan ginad bilaqsa ta ni in ginan ninad bilaqaqta na in nagah diq a haiq ham. Daq nazaqta na anawun araq ne God abenab a hi waq daqay ham. Mataw God gileh ugim daq meqintab osayta na in nazaqmo an anan ginad bilaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ad mataw ni nidimun tonsa ta ni in gidimun tonaqta na in nagah diq a haiqmo ham. Daq nazaqta na anawun araq ne God abenab a hi waq daqaymo ham. Mataw daq meqintab osayta na in nazaqmo an dimun tonad osayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ad ne mataw ginaghan inaqta naqmo gibiyad nagah negayta na in nagah diq a haiqmo ham. Ne mataw naqanta nagah negad ginad emay, In teq amenin tiqem daqay haqayta ham. Daq nazaqta na anawun araq ne God abenab a hi waq daqay ham. Mataw daq meqinta emayta na in nazaqmo amenin waqgo haqad nagah an ugayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ta teq negmo kazaq emiy ham. Ne gigo bab ginan ginad bilaqsa ne gidimun toniy ham. Ad ne gibabun nagah negad in amenin neg daqayta na ago ne ginad hi usan ham. God in mataw meqinta teq mataw igmo ag haqad osayta na gilowan tonaqta ham. Nazaq iyan ne daq nazaqmo emeq teq abeb ne God abenab naw ayahmo tuwaq daqay ham. Ad ne God Ulilib Diqta atatnizmo diq iyeq tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ne Gimam in mataw ginan anad meqniyaqta nazaqmo ne mataw ginan ginad meqniyanmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ari ne mataw gigo daq ulum kemad ginan meqin a hi bilaqid God ne gigo daq ulum kemad ne ginan meqin a hi bilaqdaqmo ham. Mataw ne gigo hib daq meqinta emsa ne daq meqinta na walemad anadin ta hi emiy ham. Ne nazaq emid teq God in ne gigo daq meqinta na giwalemad anadin a ta hi emdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ne nagah asitmo mataw negid God amenin asitmo ne negdaq ham. Ari ne mataw nagah ayahmo negsa God amenin ayahmo tinegdaq ham. Nazaq iyan ne mataw nagah negiy ham. Negid teq God ne nagah tinegdaqmo ham. Helmo ham. In nagah ayahmo diq negid ne wazlilin ton daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Haqad Yesus gamuk awowun araq gibilenim bilam, Mat ame haiqta in mat ta araq ame haiqtamo dan isihuneq a lehdaq e? ham. Haiq ham. In nazaq toneq in giger garabmo le yayib tuwoq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ad nazaqmo disaipel araq in ago tisa uriyameq danmeb a hi lehdaqmo ham. Haiq ham. Ari disaipel na in suleq tuwaq bugeq teq in ago tisa nogmo tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Haqad Yesus bilam, Nagaqgo ni niyow ameb rohroh amik diqta ussa ni ahol waqad ta ninmo nimeb ay anabun ayahta usaqta na ni ahol a hi waqaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ni ninad ezaq emad ni niyow bulonaq, Ya iyow haqaq rohroh nimeb usaqta na ya walemnan haqaq ham. Haqad ta ninmo nimeb ay anabun na ni ahol a hi waqaq ham. Ni nimileq meqin ham. Itureqmo ninmo nimeb ay anabun usaqta na ni walemeq nime saw anononmo ahol waqad teq ni le niyow ameb rohroh usaqta na walem ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ay dimunta anon meqinta a hi emaqta ham. Ad nazaqmo ay meqinta anon dimunta a hi emaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mataw ay amulik-mulikmo ginon ahol waq kemim teq in ay ezaqta na ago ginad tiqem hasayta ham. Mataw ay fik anon waqnan haqad in am asasuqin inaqtab le a hi waqayta ham. Ad nazaqmo in wain anagin waqnan haqad le am asasuqin inaqtab a hi waqaytamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mat dimunta agemab anad dimunta kabemmo usaqta na in daq dimuntaqmo emaqta ham. Sa mat meqinta agemab anad meqinta kabemmo usaqta na in daq meqintaqmo emaqta ham. Nagah mat agemab ayahmo usaqta naqmo in aqezab gwahtiqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Doq tonnan ne ya inan Iyahta, Iyahta haqad teq ne yaqgo gamuk a hi muzinayta? ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Ari mat yaqgo hib bolim yaqgo gamuk huritim muzinaqta na ago ya ne tigibilennan ham. Mat naqanta in bilaqne mat bit awaz meqinta amta nazaq nog ham. Mat na bit waznan haqad iturimmo in og tayan sisaqmo wolehan gig tugwahtiqan teq in tituq hunegan wom ham. Abeb uq araq ayahta hitiqim bit na dedibmo ulum has ham. Teq haiq ham. Bit na ahol asit a hikidik wol ham. Na ezaqgo mat na bit alulin dimunmo amta ham. ");
INSERT INTO mlp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ari mat yaqgo gamuk huritim teq a hi muzinaqta na in bilaqne mat bit atituqin haiqta ogibmo wazan eramta nazaq nog ham. Abeb uq hitiqim bo bit na wol haman bit na hidmo tuwom ham. Woqim timeqniy hasan in waz ta eraqgo haiq tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ari Yesus on mataw gibilenim hulosadmo in le uliq Kapaneam-ub tugwahtim. ");
INSERT INTO mlp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Gwahtiqan uliq nab mataw bab emayta gigo ayahta araq in os. Ossa in ago kabibiy mat araq in anan anad diq bilaqaqta na ago moq inaq iyim moqnan tonad usyaq. ");
INSERT INTO mlp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ussa bab mataw gigo ayahta na in Yesus bolim uliq nab osaqta na ago abin huritim in Juda gigo mataw marorta asor giqeman tilehiy, in Yesus bulonid boleq ago kabibiy mat na wastitayid dimniydaq haqad. ");
INSERT INTO mlp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mataw na le Yesus ago hib gwahtiqim in ginad awaz meqin amalib buloniy, Mat ko in mat dimunta haqiy. Ni leheq tuqulumsihdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","In i Juda ginan anad bilaqaqta haqiy. Inmo i giyon bit humab wolayta araq waz igta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Haqan Yesus era nenaq tilah. In le bit sinsin tuqugsamo bab mataw gigo ayahta na in ago kadoyniz asor giqeman bolim Yesus danib ahol waqad bulonim bilaqiy, I gigo amebta na in ninmen gamuk kazaq bilam haqiy. Mat ayah ni niholtuw hi bul haqad in bilam haqiy. Ni yaqgo bit aduganib bo gwahtiqdaqta na ago ya mat dimun a haiq haqad in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ya nazaq haqad ya ningo hib lehim a hi nibilen haqad in bilam haqiy. Ya inad emaiq ni gamukmo bilaqid yaqgo kabibiy mat ka ahol tidimniydaq haqaiq haqad in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na ezaqgo ya inaqmo yaqgo amebta ahaqenib osaiqta haqad in bilam haqiy. Ad yaqgo mataw bab emayta na in ya ihaqenib osaytamo haqad in bilam haqiy. Ossa ya araq bulonaiq, “Ni leh” haqsa in lehaqta haqad in bilam haqiy. Teq ya araq bulonaiq, “Ni bol” haqsa in bolaqtamo haqad in bilam haqiy. Ad yaqgo kabibiy mat bulonaiq, “Ni kabiy ka em” haqsa in kabiy na emaqta haqad in bilam haqiy. Nazaq iyan ya inad emaiq ni gamukmo bilaqid yaqgo kabibiy mat na ahol tidimniydaq haqaiq haqad in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Haqan Yesus gamuk na huritim ahol turuh nam. Ahol turuh nemsa in ahol buliyim on mataw dauh biyahta in muzim inaq boliyta na kazaq gibilan, Ya ne gibilenaiq ham. Mataw bab emayta gigo ayahta na in Juda mat a haiq ham. Teq in Juda mataw bunmo giquriyamim in ya inan helmo diq haqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","An mataw marorta Yesus ago hib giqeman boliyta na in muleqim bitab ta lehim kabibiy mat na ahol tidimniyim ossa in ahol waqiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ari Yesus usim ta tiqim in uliq araq anan Nain haqaytab tilah. Lehsa in ago disaipel teq on mataw dauh biyahta in inaq tilehiymo. ");
INSERT INTO mlp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lehan uliq nab aw waburta araq os. Sa in atatin amulikmo osta na tumom. Moqan mataw in asan banab emim sorim hodhodab ad tilehsa uliqab on mataw biyahmo aw na inaq hodhodab tileh yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lehsa Iyahta in aw waburta na ahol waqad in anan anad meqniysa bulon, Ni hi gaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Haqad in mat momta asan banab usaqta na agerab loqim in aben banab emim wazsa mataw mat aban inaq sorim a lehiyta na wasihim tituriy. Tursa Yesus bilam, Mat minminta ham ya tinibilenaiq ham. Ni eraq ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Haqanmo mat tumomta na kayeq iyim eraqim osad gamuk tibilaqyaq. Sa Yesus amun na waqim anen tuqug. ");
INSERT INTO mlp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","An on mataw na bunmo daq na ahol waqim tirab yaqay. Ad in God abin iluwad teq in bilaq yaqay, God ago nantut araq awaz meqin diqta i gilikmanib tugwahtim haq yaqay. Haqad in bilaq yaqay, God in ago on mataw tigilumsihnan haqad nob tinegaq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ad in le Juda gigo og saw bunmo luwad Yesus daq amta na awagamun tibilaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Ari Jon irquran ossa in ago disaipel bolim nagah bunmo Yesus giqamta na ago in Jon tubuloniy. Bulonan Jon in ago disaipel giger gibilenim giqeman Iyahta ago hib susumun ugnan tilehiy. Lehsa in gibilan, Ne leheq Yesus kazaq susumun ugiy ham. Ni i nibaq tunim osta naqmo amatin ni bol o haiq mat ta araq teq abeb boldaqta i baq tunam? haqad ne buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","An mataw giger na le Yesus ago hib gwahtiqim tubuloniy, Jon mataw huz negyaqta na i giqeman i kawa tubol haqiy. Ad in i gibilenim bilam, Ne leheq mat na susumun ugiy haqad in bilam haqiy. Ni i nibaq tunim osta naqmo amatin ni bol o haiq mat ta araq teq abeb boldaqta i baq tunam? haqad nazaq in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ari kam nabmo Yesus in mataw gigo moq amo amo inaqta na giwastitaysa tidimniy yaqay. Ad in bugaw meqinta mataw giholib usaqta na gimuzsa tileh yaqay. Teq in mataw gime haiqta na giwastitaysa in gime rireqim nagah ahol tuwaq yaqay. In kabiy nagan emsamo Jon ago disaipel giger na susumun ugnan boliy. ");
INSERT INTO mlp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nazaq iyan Yesus in giger na gigo gamuk amenin emim gibilan, Ko gibiyiy ham. Mataw gime haiqta saw ahol tuwaqay ham. Mataw gisen meqinta tiloq gelay ham. Mataw gigo moq lepra inaqta gisanib ginumlan usta na tihiqiyaq ham. Teq mataw gidek haiqta gamuk tuhuritay ham. Mataw tumoqiyta kayeq iyim ta eraqay ham. Ad mataw ginaghan haiqta God ago gamuk dimunta tuwaqay ham. Ne muleqeq leheq nagah ne gimeb kawa ahol tuwaqiyta ka teq gamuk kawa ne tuhuritiyta ka bunmo ne Jon buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mat ya ibiyad anadnad a hi emad teq in ya inan helmo diq haqaqta, mat na tidimniyim osaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ari Jon ago mataw giger na tilehsa teq Yesus in on mataw biyahta nab turiyta na Jon anan gibilenim bilam, Kwaziqmo ne nog diq ahol waqnan saw amatawun haiqtab lehiy? ham. Ne mat araq bilaqne tuqir tim retsa ahol wolad ahulan iysa ne ahol waqnan lehiy ye? ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Teq ne nog diq ahol waqnan saw nab lehiy? ham. Ne mat araq tubusan dimunta welim ossa ahol waqnan lehiy ye? ham. Haiqgam ham. Mataw ginaghan kabemmota tubusan dimdimunta giholib emim didaq dimdimunta neqayta na in king gigo bit aseseqtabmo osayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ne ya ibileniy ham. Ne nog diq ahol waqnan lehiy? ham. Ne God ago nantut araq ahol waqnan lehiy ye? ham. Helmo ham. Mat na in God ago nantut araq ham. Teq mat nawa na in God ago nantut bunmo giquriyamta ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mat naqmo God ago marib ananin mar tonan usaqta ham. Gamuk na bilam ham, Ahol waqiy ham, ya teq mat araq emid in yaqgo gamuk ad danmeb lehdaq haqad in bilam ham. Leheq in ninmen dante tuwastitaydaq haqad in bilam ham. Wastitayid teq ni lehdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ya ne gibilenaiq ham. Jon in mataw og kabta na bunmo giquriyamim in abin ayah diqta ham. Ta teq mat aw nog God ago maror aduganib gibin amik diq usaqta na in Jon tuquriyamiyta ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ari on mataw nab turiyta na bunmo kwaziqmo in Jon ago hib lehan Jon tuhuz nagta, mataw takis waqayta na inaqmo. Nazaq iyan in Yesus ago gamuk na huritim bilaqiy, Helmo haqiy God daq titnonta emaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ta teq Farisi giyogniz mataw Moses ago gunun hurit kemiyta na nenaq in ginad a hi bilaqan in Jon huz neggo hulosiyta. Hulosad in God anad in gigo hib usta na othasim God in giyon dante dimunta amta na in gileh tuqugiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ari Yesus gamuk bilaq tutim a lehad in gibilan, Ya on mataw kam kabta gigo daq anan bilaqnan teq ya gamuk awowun ezaq diqta amalib bilaqdaiq? ham. Teq in on mataw ezaq diqta? ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","In bilaqne onmin maket-ib an bulonad osayta nazaq nog ham. In bilaqay, I ne gimen kadug ulamsa ne ginad dimniysa a hi doray haqayta ham. Teq i gaq wazsa ne ginad meqniysa a hi gaqay haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ari Jon mataw huz negyaqta na bolim didaq amo amo a hi neqad wain ayun a hi uluwyaqta ham. Sa ne in anan bilaq yaqay, Bugaw meqinta aholib usaqta haq yaqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ta teq Mat Atatin bolim didaq neqad wain uluwsa ne bilaqay, Mat ko meqin haqayta ham. In didaq kabemmo neqad wain ayun ayahmo uluwaqta amatin haqayta ham. In mataw gibin meqinta takis waqayta na teq mataw daq meqinta emayta na giyowmo diq haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","O tob iyan ham. Mataw ginad em hasim daq emayta na bunmo in God ago anad awaz meqinta eman ulal iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ari Farisi araq Yesus bulonim inaq ago bitab didaq neqnan tilah. Lehan Yesus in Farisi na ago bitab didaq neqad tuqos. ");
INSERT INTO mlp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ossa uliq nab aw araq danatabta in Yesus bo Farisi na ago bitab didaq neqaqta na abin tuhurit. Huritim in kagoh amikta gig anan alabasta haqay na sisoqim emiyta araq waqim aduganib masil ahuran dimunta tenim teq in wazim a bol. ");
INSERT INTO mlp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A bolim Yesus ahol wol emim banab us nog iyad didaq neqsa aw na lehim abun ban asen agerab turad teq in tigaqyaq. In gaqad ameqil woqsa ameqil ayunib Yesus asen suholad teq in aqensanib bayan tumay. Mayan in Yesus asen ilawunad teq in masil ahuran dimunta na wazbalan Yesus asenab tuwom. ");
INSERT INTO mlp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Samo Farisi Yesus bulonan ago bitab bolta na in daq nazaq ahol waqadmo anad kazaq am. Mat ka in God ago nantut diq iyeq teq aw ka in naga awun diqta na ago in tuhurit nagta ham. Ad in aw ka baymuzid in asan a hi waz nagta ham. Aw ka daq meqinta emad luwaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mat na anad nazaq emsa Yesus anan biyim bulon, Saimon ham ya gamuk araq tinibilennan ham. Haqan Saimon bilam, Tisa ham ningo gamuk bilaqsa ya huritiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Haqan Yesus bilam, Ari ni nidek em ham. Mataw giger mat araq ago hib mani waqiyta ham. Mat na araq 500 kina nazaq wam ham. Sa araq na 50 kina nazaqmo wam ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Waqim abeb in mani waqiyta na amenin emgo in giholib gimeq araq diq a hi us ham. Nazaq iyan mani anamren na in mataw giger na ginan anad meqniysa in ago mani amenin giholib usta na tuwalam ham. Ari ya susumun nignan ham. Mataw giger na gilikmanib nog in mani anamren na anan anad ayahmo diq bilaqdaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Haqan Saimon bilam, Ya inad emaiq mat ago mani amenin ayahmo usan in walamta naqmo in mani anamren na anan anad ayahmo diq bilaqdaqta haqaiq ham. Haqan Yesus bulon, Na ni ulum kemim dimunmo tibilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Haqad in ahol buliyim aw na ahol waqadmo in Saimon bulon, Ni aw ka ahol waqaq e? ham. Ya ningo bitab bolan ni yuw yagan ya isen a hi suhol ham. Teq aw ka ameqil ayunib isen suholim in aqensanib bayan tumay ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ya ningo bitab bolan ni ya a hi ilawun ham. Teq ya ningo bit aduganib gwahtiqim ossa bo muran kawa aw ka ya isen tiqilawunaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni ya ifaqinib masil ahuran dimunta wazbalan a hi wom ham. Teq aw ka ya isen amalib masil ahuran dimunta wazbalan tuwom ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nazaq iyan ya ni nibilenaiq ham. Aw ka in daq meqinta kabemmo amta ham. Teq in ya inan anad ayahmo bilaqaqta ham. Na ezaqgo ya in ago daq meqinta na tigiwalem bugta na ago iyan ham. Ari mat bilaqaq, Ya iholib daq meqinta kabemmo haiq haqaqta na in ya inan anad asitmoqmo bilaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Haqad in aw na bulon, Ya ningo daq meqinta na tigiwalem bug ham. ");
INSERT INTO mlp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Haqan mataw Yesus inaq garab banab didaq neqad osiyta na in gimo an bulonim bilaqiy, Ka naga matin diq? haqiy. In mataw giholib daq meqinta usaqta na inaqmo giwalemaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Haqsa Yesus aw na bulon, Ni ya inan helmo hamta naqmo in nawa nilumsihan ni niholib daq meqinta usta na tihiqiy ham. Ni leheq nigem dimniysa os ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Abeb Yesus uliq aseseqta amikmikta inaqmo kabemmo gigo hib leheq luwad in God ago maror agamukan dimunta tigibilenyaq. Sa disaipel 12 na in Yesus inaq tiluw yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Teq kwaziqmo on asor Yesus in giholib bugaw meqinta gimuzad gigo moq eman hiqiyta na in Yesus inaq tileh yaqaymo. On na gilikmanib araq anan Mariya uliq Magdala-ibta haqayta. Kwaziqmo Yesus in aholib bugaw meqinta 7 nazaq gimuzta. ");
INSERT INTO mlp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Teq araq anan Jowana haqayta. Aw na aduw anan Kusa. Mat na King Herot ago bit wamuzim osyaqta. Teq aw araq anan Susana haqayta. Sa on asor kabemmo in Yesus muzeq inaq leh yaqaymo. On nagan in gimo gigo nagahta amalib Yesus ago disaipel nenaq gilumsih yaqayta. ");
INSERT INTO mlp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","Ari uliq saw bunmo on mataw kabemmo in Yesus ago hib bolim humab tuwoliy. Humab wolim ossa Yesus gamuk awowun araq gibilenim bilam, Mat araq ago kabiyab wit anagin hunegnan tilah ham. In lehim wit anagin hunegad luwsa asor danib wom ham. Woqan mataw loq gelad gisenab bay ninalsa ah boleq tineq yaqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sa didaq anagin asor saw agigin inaqtab wom ham. Woqim wit anagin na gwalad og na ayuwun haiqgam iyan in tumay ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sa wit anagin asor am asasuqin inaqta gilikmanib wom ham. Woqan am asasuqin inaqta na inaq araqibmo gwalad in wit na isih bugan abesbesan iy ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Sa wit anagin asor og dimuntab wom ham. Woqim in gwalim alulin amulik-mulikmo anon kabemmo diq 100 nazaq am ham. Ad Yesus bilam, Mat aw nog in gidek nan huritgo usaqta na in gamuk ka hurit kemiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ari Yesus ago disaipel gamuk awowun na alulin hurit kemnan haqad in Yesus tisusumun ugiy. ");
INSERT INTO mlp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Susumun ugan Yesus gibilan, Negmo God ago maror aduganib osayta ham. Nazaq iyan in ago maror abe alulin ulilemim usaqta na in negmo tigiqisihunaq ham. Ari on mataw asan banta na ya gamuk awowun hulim gibilenaiq ham. Ya nazaq gitonsa teq, Mataw na gime saw waqad teq in nagah araq ahol a hi waq daqay ham. Ad in gamuk huritad teq in ginad a hi em has daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ari gamuk awowun na alulin in kazaq ham. Wit anagin na in God ago gamuk ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Teq mataw asor in wit anagin danib womta na nog ham. Mataw na God ago gamuk huritan teq abeb Satan bolim gigemab gamuk na ta walemaqta ham. Satan anad emaq, Luweq mataw na God anan helmo haqsa God in aholyon tigiwaqdaq haqad in mataw na gigemab God ago gamuk walemaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Teq mataw asor in wit anagin saw agigin inaqtab womta na nog ham. Mataw na God ago gamuk huritim in ginad bilaqsa wazayta ham. Teq mataw na in wit aninin haiqta nog ham. In God ago gamuk gigemabmo diq a hi wazayta ham. Kam asitmoqmo in helmo haqsa teq gilumwaq akaman bolsa in ginad helta na hulosayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Teq mataw asor in wit anagin am asasuqin inaqtab womta na nog ham. Mataw na God ago gamuk huritim teq in og kab luw ossa og ka ago afaqan amo amo gamuk na isihaqta ham. Mataw na in mani akabiyan emad daq gihol bilaqaqta nagan emad in God ago gamuk anadin a hi emsa gamuk na gigemab a hi zilimaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ari mataw asor in wit anagin og dimuntab womta na nog ham. Mataw na God ago gamuk huritim in waz naqmo hiqiyayta ham. Ad in gigem titnonimmo ussa in daq helta emayta ham. In afaqan sorad gituw a hi hiqiyayta ham. In giwaz meqniyim ossa God ago gamuk na in gigemab anon giqemaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ari mataw lam miderim kuramab a hi sihenayta ham. Ad in ban ahaqenib a hi emaytamo ham. Haiqgam ham. In lam miderim ulilib othenan oyad usaqta ham. Ussa mataw lam anuwan ahol waqad in bolim bit aduganib gwahtiqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nazaq iyan nagah bunmo ulilemim usaqta na in teq ulal tiqiydaq ham. Ad nagah bunmo giqisihan usaqta na in teq saw anuwanib gwahtiqid mataw ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nazaq iyan ne ginad em hasad yaqgo gamuk huritiy ham. Na ezaqgo God in on mataw gigo nagah inaqta na bunmo nagah asor a ta negdaq ham. Ari mataw ginaghan haiqta gihol kat ugad bilaqay, I gigo nagah inaq haqayta na God in gibenab nagah asitmo in wazayta na tigiwalem bugdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ari kam nabmo Yesus anen teq in amagniz in ago hib tuboliy. Bolim teq haiq on mataw kabemmo humab wolim ossa in Yesus agerab loqgo dan haiqgam. ");
INSERT INTO mlp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Samo mataw asor Yesus tubuloniy, Ni ninen teq ni nimagniz bolim in nibiynan haqad kowa asanib turay haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Haqan Yesus amenin emim gibilan, On mataw God ago gamuk huritad muzinayta naqmo in ya inen teq in ya imagniz ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ari kam araqab Yesus ago disaipel nenaq muyib gwalim osad Yesus gibilan, I yuw urumun kozaq ban lehuq ham. Haqad in tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lehadmo Yesus ame rursa tuqus lah. Ussa tim ayahta eraqim bolad yuw eman muyib gwalsa muy ame tugwalnan tonyaq. Sa disaipel timeqniynan ton yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ad in le Yesus wazan eraqanmo tubuloniy, Iyahta, Iyahta haqiy i tumoqnan tonauq haqiy. In nazaq haqan Yesus eraqim tim yuw inaqmo ginadan tim moqim hiqiysa yuw kute nemim ahol a ta hi wolyaq. ");
INSERT INTO mlp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sa Yesus disaipel gibilan, Ne ginad God anan helmo haqayta na edowa? ham. Haqan disaipel rabad gihol turuh nemsa bilaq yaqay, Ka naga matin diq? haq yaqay. In tim yuw inaqmo gibilensa aqez huritayta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ari Yesus ago disaipel nenaq muyib yuw urotim le uliq Gerasa gigo og saw ban tugwahtiqiy. Uliq na yuw urumun kozaq ban ussa saw Galiliy yuw urumun kazaq ban usaqta. ");
INSERT INTO mlp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesus muy hulosim lan ezab hitiqanmo uliq nab mat araq aholib bugaw meqinta giqusaqta in agerab tubol. Mat na kam sisaqmo abe aholmo tubusan haiqmo luwyaqta. In bitab asit a hi osad in hodhodabmo luw osyaqta. ");
INSERT INTO mlp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","In Yesus ahol waqad ek tonim anognib asen agerab woqim usad bilam, Yesus ham ni God Ulilibta atatin ham. Ni ya ezaq itonnan bol? ham. Ya inad meqniysa nibilenaiq ham. Ni santitiy hi yag ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Na ezaqgo Yesus tekomo bugaw meqinta na mat huloseq lehgo gibilanta na ago iyan in nazaq Yesus bulon. Tuteqmo bugaw meqinta na in mat na anad wamuzyaqta. Wamuzsa mataw sen teq hankap amalib in irqureq waz waq yaqayta. Teq haiq. Mat na sen nagan bul titaysa bugaw meqinta abe yahsa in saw amatawun haiqtab le luwyaqta. ");
INSERT INTO mlp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ari Yesus mat na tisusumun ug, Ni ninan ezaq? ham. Haqan in bilam, Ya inan Kuluwmo ham. Na ezaqgo bugaw meqinta kabemmo diq mat na aholib ussa in ahol anan nazaq biyim bilam. ");
INSERT INTO mlp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Teq bugaw meqinta nagan ginad meqniysa gime kabemmo Yesus bulon yaqay, Ni i gimuzid i yay abe milhasta aromriq inaqta nab hi lehuq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sa bul gihumaban araq ayahta garah nab didaq neqad turiy. Tursa bugaw meqinta nagan ginad meqniysa Yesus buloniy, Ni i giqemid i bul ko giduganib lehuq haqiy. Haqan Yesus bilam, Lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Haqan bugaw meqinta nagan in mat na hulosad gwahtiqim le bul na giduganib tuwoqiy. Woqanmo bul bunmo sibim wole garah asibsibranib bayhilek tonim yuwmeb woqan yuw gineqanmo tumoq bugiy. ");
INSERT INTO mlp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sa mataw bul giwamuzim osiyta na in daq na ahol waqad in tukim uliqab teq saw haresmo lehad in nagah ahol waqiyta na awagamun tibilaqiy. ");
INSERT INTO mlp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bilaqsa on mataw nagah na ahol waqnan tilehiy. Lehim in Yesus ago hib tubolim in mat aholib bugaw meqinta gwahtiqim lehiyta na ahol waqiy. Mat na anad dimunta waqim tubusan welim Yesus asen agerab ossa in ahol waqad tirab yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sa mataw gimeb daq ahol waqiyta na in mat aholib bugaw meqinta usan Yesus gimuzan lehiyta na awagamun on mataw biyahta na tigibilen yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gibilensa uliq Gerasa ago saw ban on mataw bunmo rabad bo Yesus buloniy, Ni i gihuloseq leh haqiy. Haqan Yesus muyib ta gwalim in muleqim ta lah. ");
INSERT INTO mlp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Lehsa mat aholib bugaw meqinta gwahtiqim lehiyta na in Yesus inaq lehnan haqad anad awaz meqin amalib bulonyaq, Ya ninaq lehdaiq haqyaq. Haqsa Yesus hulos. Ad in mat na eman ago uliqab muleqim ta lehsa in bulon, Ni ningo uliqab muleqeq ta leh ham. Leheq God daq ayahta em nigta na awagamun ni on mataw gibilen ham. Haqan mat na muleqim lehim in uliq nab bitbitmo luwad Yesus ayahmo ulumsihta na ago in on mataw tigibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ari Yesus muleqim ta bolanmo on mataw biyahta saw nab in amen emim osiyta na in Yesus ahol waqad ginad tidimniyiy. ");
INSERT INTO mlp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Samo mat araq anan Jairus haqayta tubol. Mat na in Juda gigo bit humab wolayta ago danmebta araq. In bolim Yesus asen agerab ahol hulosan ogib woqim usad Yesus in ago bitab bolgo haqad in anad meqniysa ame kabemmo tubulonyaq. ");
INSERT INTO mlp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mat na amiy amulikmoqmo osta na tumoqnan tonsa iyan in bolim Yesus nazaq bulonyaq. Amun aw na ago ulig 12 nazaqta. Ari mat na nazaq Yesus bulonan in inaq tilehsa on mataw dauh biyahmo Yesus aholib soqotim diq inaq tileh yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lehsa aw araq ulig 12 nazaq moqad ned hunegad luwyaqta na in mataw na gilikmanib tilehyaqmo. Mataw kabemmo in aw na ago moq wastitay waqiyta. Teq haiq. In ago moq asit a hi hiqiyyaq. ");
INSERT INTO mlp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ari aw na Yesus abun ban muzim inaq lehadmo in agerab diq loqim ago tubusan adek tuwaz. Wazim muran diq nawaqmo in aholib ned usta na tihiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Anmo Yesus tisusumun, Nog ya iwaz? ham. Haqan on mataw bunmo bilaqiy, I asit a hi niwaz haqiy. Haqsa Pita bilam, Iyahta ham on mataw dauh biyahta ka bunmo nililut nigad soqot nigim ninaq lehayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Haqan Yesus bilam, Haiq ham. Ne gilikmanib guyaqag diq ya iwaz ham. Iwazan yaqgo zaway asor ihulos yagim lehsa ya ihol loyin ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yesus nazaq bilaqsa aw na anad tiqam, Ya daq emta ka ulal tiqiyaq ham. Haqad in ahol harara nemsamo bolim Yesus anognib ahol hulosan ogib tuwom. Woqim usad on mataw na bunmo gimeb in anad ezaq emad Yesus wazta na teq in wazanmo ahol tidimniyta na ago in tibilaq bug. ");
INSERT INTO mlp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bilaq bugan Yesus bulon, Ya imiy ham ni ya inan helmo hamta naqmo niqeman ni nihol tidimniy ham. Ni nigem dimniysa leh ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ari Yesus gamuk bilaqad nab tursa Jairus ago bitab mat araq osim bolim in ago mat ayahta na danib ahol waqad tubulon, Ningo amun aw tumom ham. Nazaq iyan ni Tisa atuw ta hi bul ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Haqan Yesus gamuk na huritim in Jairus bulon, Ni hi rab ham. Ni God amomo anan helmo haqid teq ni nimiy tidimniydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Haqad in Jairus ago bitab tubol. Bolim on mataw kabemmo amun aw na anan gaq wazad ossa Yesus gibilan, Ne hi gaqiy ham. Amun aw na a hi mom ham. In usaq ham. Haqan on mataw na bunmo in aqez tiyuquwuniy. Na ezaqgo amun tumoq hasta na ago in tuhuritiyta iyan. Yuquwunsa Yesus in on mataw biyahta in inaq boliyta na bunmo giwasihan asanib tursa in Pita teq Jems ama Jon inaq teq amun na anen amam naqmo giwaqim nenaq bit aduganib tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gwahtiqim Yesus lehim amun aw na aben wazim in lilewunim bulon, Yaqgo amun ham ni eraq ham. ");
INSERT INTO mlp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Haqanmo amun aw na awitan muleqim asanib ta woqanmo in hidmo tiqeram. Eraqan Yesus amun didaq ugid neqgo tigibilan. ");
INSERT INTO mlp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Sa amun aw momta na kayeq ta iyan anen amam in ahol waqad in gihol riten lamyaq. Sa Yesus in gidek wazim gibilan, Kawa ya daq emta ka ago ne mat araq hikidik buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ari Yesus in ago disaipel 12 na gibilenan agerab bolan inmo ahol abinib bugaw meqinta bunmo gimuzgo azawayin teq moq amo amo wastitaygo azawayin tinag. ");
INSERT INTO mlp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Negad teq in disaipel giqeman in God ago maror agamukan mataw gibilenad gigo moq giwastitaynan tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Lehsa Yesus gibilan, Ne lehad es araq waqeq ad hi lehiy ham. Teq katek ulum ugayta na ne hi waqiymo ham. Ne ziy araq es sihengo hi waqad didaq danib neq daqayta na ne ad hi lehiymo ham. Ad mani araq ne giholib hi usanmo ham. Ne gigo tubusan amulik giholib usaqta naqmo ne a lehad araqmo ta hi waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ari ne le bit aqez araqab gwahtiqid in ne gihol bulonid teq ne loqeq bit nabmo osiy ham. Osad kabiy hiqiyid teq ne eraqeq bit na huloseq lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ari uliq edob ne lehid mataw ne gibaymuzsa ne uliq na huloseq lehiy ham. Lehad ne gisen aqogin wolhamid uliq nab woqan ham. Woqid teq mataw na in gigo daq na anadin tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesus nazaq haqan disaipel tilehiy. Lehad in uliq bunmo God ago gamuk dimunta gibilenad teq in on mataw gigo moq inaqta na giwastitaysa gihol tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ari saw Galiliy-ib king Herot in kabiy daq bunmo Yesus emyaqta na abin tuhurit. Huritim in anadnad diq emyaq. Na ezaqgo mataw asor bilaq yaqay, Jon mataw huz negyaqta na moqan God hodhodab wazan ta eram haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sa asor bilaq yaqay, Elaija a ta gwahtim haq yaqay. Sa asor bilaq yaqay, God ago nantut kwaziqta araq kayeq ta iyim luwaq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mataw nazaq haqsa Herot bilam, Ya bilaqan Jon anat tuqurot tayiyta ham. Ta teq na naga matin ya abin kazaq diq huritaiq? ham. Haqad in Yesus ahol waqnan dan tinagunyaq. ");
INSERT INTO mlp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ari Yesus ago disaipel kabiy emad luwiyta na muleqim Yesus ago hib tuboliy. Bolim in kabiy bunmo emiyta na awagamun tubuloniy. Bulonim tihiqiyan Yesus in giwaqim nenaq in gimomo uliq anan Betsaida haqayta nab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lehim ossa on mataw in Yesus ago disaipel nenaq uliq Betsaida-ib lehiyta na ago huritim in ginagunim tilehiy. In le Yesus ago hib tugwahtiqan Yesus in gibiyad anad tidimniy. Anad dimniysa in God ago maror asuleqin tigibilenyaq. Ad in mataw gigo moq inaqta na giwastitaysa tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","In nazaq emad ossa imisor diq tiqiy. Iysa disaipel 12 na bolim tubuloniy, Ni on mataw ko giqemid in uliq saw kogab haresmo lehad in usgo ban nagunad teq in gigemyon naguniymo haqiy. Saw i osauqta ka amatawun haiqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Haqan Yesus gibilan, Negmo didaq negid neqiy ham. Haqan disaipel bilaqiy, I gigo didaq kabem a haiq haqiy. Bret abaynagin teq nabiq gigermo kawa usaq haqiy. Ni ninad i leheq humab ka gimen didaq zayeq teq negam haqaq e? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na mataw 5,000 nazaq ossa iyan disaipel nazaq bilaqiyta. An Yesus in ago disaipel gibilan, Ne mataw gibilenid in humab 50 nazaq giholbin giholbin emeq osiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Haqan disaipel in aqez muzinim in on mataw bunmo gibilenan in nazaqmo tiqemiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","In nazaq emim ossa Yesus bret abaynagin na teq nabiq giger na waqim ame ulilib gwalsa in God esey ugim teq in orqayim ago disaipel negan in on mataw tinegiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Negan in neqan tigiyunin. Giyuninan abeb disaipel le didaq abeyan ginuwim kuram 12 nazaqmo ta gisiheniy. ");
INSERT INTO mlp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ari kam araqab Yesus amomo God inaq gamuk emad ossa ago disaipel agerab tuboliy. Bolan in tisusumun nag, On mataw ya inan nog diq haqsa ne huritay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Haqan disaipel amenin emim bilaqiy, Mataw asor ni ninan Jon mataw huz negyaqta na haqay haqiy. Sa asor ni ninan bilaqay, Ni Elaija haqay haqiy. Sa asor bilaqay, Ni God ago nantut kwaziqmo moqiyta na gigo araq tugwahtimya haqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Haqan Yesus a ta susumun nag, Ta negmo ya inan nog diq haqay? ham. Haqan Pita amenin emim tibilam, Ni Krais ham. God mat emid bo i gilumsihdaqta amatin na ninmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita nazaq haqan Yesus in ago disaipel bunmo gunun negim gamuk awaz meqinta kazaq gibilan, Ne ya ihol alulin na mat araq hikidik buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Haqad in gibilan, Mataw marorta na teq mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na in Mat Atatin gileh ugad santitiy ayahmo tuqug daqay ham. Ugad teq in wol emid tumoqdaq ham. Moqeq kam ezeqmanmo usid teq God in wazid ta eraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Haqad in on mataw bunmo gibilenim bilam, Mat araq ya imuzeq bolnan haqad anad emeq in ahol wazid woqan ham. Ad ya afaqan soraiqta nazaqmo in sornan anad bilaqsa kam bunmo in ago kruse sorid abetarib gwalan ham. In nazaq toneq teq in ya imuzeq bolan ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Na ezaqgo mat nog inmo ahol anadin emad asan alowan tonaqta na in ahol awitan tihik hulesdaq ham. Ari mat nog in ya inadin emad ahol nog hulosdaqta na in ahol awitan ulumsihid kuluwa-kuluwmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nagaqgo mataw og kab osad in giholyon nagah kabemmo diq rom tonayta? ham. Mataw na gihol awitan hik hulesid nagah in giholyon rom toniyta na ezaq teq gilumsihdaq? ham. Na haiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Abeb Mat Atatin maror ayahta iyeq inmo ago ahol anuwan inaq ta bolad in amam teq amam ago angelo tawonta na nenaq gihol anuwanib tuboldaqta ham. Bolad mat aw nog in og kab osad ya teq yaqgo gamuk inaq ginan gimebay womta na kam nab Mat Atatin in mataw na ginan amebay tuwoqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ya helmo ne gibilenaiq ham. On mataw muran kam kab osayta ka gigo asor a hi moqadmo in God ago maror og kab gwahtiqsa ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ari Yesus gamuk na tiqemim abeb kam 8 nazaq tihiqiyan in Pita teq Jems ama Jon inaq giwaqim nenaq garah araq abigmanib God inaq gamuk emnan tugwalehiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Gwalehim Yesus God inaq gamuk emad ossa in anobun buliyim lul araq diq iy. Iysa ago tubusan inaqmo buliyim hus diq iymo. ");
INSERT INTO mlp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sa mataw giger Moses ayow Elaija inaq giwitan gwahtiqim Yesus inaq gamuk bilaqad tituriy. ");
INSERT INTO mlp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","In giger God ago anuwan inaq Yesus agerab gwahtiqim in Yesus Jerusalem-ub leheq ago kabiy emid hiqiyid in og ka huloseq gwa tilehdaqta na ago ananin in Yesus inaq bilaqad tur yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tursa Pita ayogniz giger na nenaq gime sahuq iysa tuqusiy. Usim kayeq ta iyim in Yesus ahol anuwan inaq mataw giger na giwitan nenaq tursa tigibiyiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gibiysa mataw giger na Yesus huloseq tilehnan tonsamo Pita era Yesus tubulon, Mat ayah ham i kab osauqta ka in dimun diq ham. I baybay ezeqmanmo emuq ham. Araq ninmen teq araq Moses amen teq araq Elaija amen ham. Pita anad a hi em hasadmo gamuk nazaq bilamta. ");
INSERT INTO mlp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","In gamuk nazaq emad tursamo onqas tihitim. Hitiqim in Yesus ayogniz giger Moses ayow Elaija inaq giqisih netim ussa disaipel ezeqman na gibiyad tirab yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Rabsa God aqez onqas na aduganib gehitiqim bilam, Ka ya itatin ham. Ya inmo atowun eman in osaqta ham. Ne in aqez huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","God aqez na tihiqiyan disaipel Yesus amomo tursa ahol waqiy. Ad abeb in gewoqim luwad giqezmo hiqiyim tiluwiy. In nagah ahol waqiyta na mat araq diq a hi buloniy. ");
INSERT INTO mlp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ari Yesus ago disaipel ezeqman na nenaq usim tarommo in eraqim garah na hulosim tigewoqiy. Gewoqanmo mataw dauh biyahta Yesus amen emim osiyta na in ahol tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ahol waqadmo mat araq gilikmanib era turad in lileyim bilam, Tisa ham ya inad meqniysa nibilenaiq ham. Ni ya itatin ka nob ugad ulumsih ham. Ka yaqgo amun amulikmota ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kam buntab bugaw meqinta araq in yaqgo amun ahol waqsa in ritenad ek tonaqta ham. Sa bugaw na amun wazim ulelsa anosnosin ateb gwahtiqaqta ham. Ad in amun woltitayad in hulos ugnan atuw diq hiqiyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya ningo disaipel bugaw meqinta na muzgo haqad susumun negan in muznan biyab a hi iyiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Haqan Yesus bilam, On mataw kam kabta ne God anan helmo a hi haqayta ham. Ad ne ginad titnonim diq a hi usaqta ham. Kam ganim teq ya nenaq og kab osad ya ne ginad siqim iyaqta na ago a hi bilaqad ya ne gigo afaqan sordaiq? ham. Ningo amun a bol ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Haqan amun na Yesus agerab lehsamo bugaw meqinta na amun wazim hunegan woqan in tuqulelyaq. Ulelsa Yesus bugaw meqinta na wadim teq in amun ahol wastitayan tidimniy. Dimniyan in amun na waqim amam tuqug. ");
INSERT INTO mlp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","An on mataw bunmo God ago zaway na ahol waqim gihol riten lamiy. Mataw biyahta na in Yesus daq amta na anan ginadnad emad an bulonsa Yesus in ago disaipel gibilan, ");
INSERT INTO mlp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ne gidek tih nemeq gamuk ka huritad gidek hi zizalan ham. Mat araq teq Mat Atatin waqeq mataw gibenab tiqemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Haqan teq haiq. Yesus ago disaipel gamuk na alulin ago ginad a hi em hasiy. Gamuk alulin na ulilemim ussa in ahol a hi waqiy. Ad teq in Yesus susumun ugnan rab yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ari disaipel in gimo an mugad in gilikmanib nog diq in ayah diqta na ago tibilaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sa Yesus in disaipel ginad nazaq emsa huritim in amun amikta araq waqim inmo agerab eman titur. ");
INSERT INTO mlp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tursa Yesus gibilan, Mat nog in amun kaqanta ya ibinib bolsa ahol waqad wazinaqta na in ya iwazinaqmo ham. Ad nog ya iwazinaqta na in mat ya iqeman bolta na wazinaqmo ham. Nazaq iyan ne gilikmanib mat ahol abin haiqta na in ne bunmo giquriyamim in mat ayahta iyim luw osaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Haqan Jon bilam, Iyahta ham mat araq ni nibinib bugaw meqinta gimuzsa i luwim ahol waw ham. Teq mat na i inaq araqib a hi luwad iyan i wasihad bulon, Ni nazaq ta hi em haqad i bulon ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Haqan Yesus bilam, Ne hi wasihiy ham. Na ezaqgo mat geg a hi negaqta na in ne giyowta ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ari God Yesus waqeq ad Heven-ib gwalehgo akaman bolim sinsin tiqiy. Sinsin iysa Yesus uliq Jerusalem-ub lehnan anad awaz diq timeqniy. ");
INSERT INTO mlp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Samo in mataw asor ameb leheq ago dan wastitay daqayta na giqeman tilehiy. Lehad luwim in Yesus ayon bit in usdaqta na wastitaynan haqad saw Samariya gigo uliqben araqab le tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Teq haiq. Mataw uliq nabta in Yesus Jerusalem-ub lehaqta na ago huritim in Yesus waqeq inaq gigo bitab osnan tuhulosiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hulosan Yesus ago disaipel giger Jems ama Jon inaq in daq na ahol waqad Yesus tubuloniy, Iyahta haqiy ni ninad bilaqid teq i God bulonid in kaitab faq emid hitiqeq mataw ka ginoy em bugan haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Haqan Yesus ahol buliyim giger na ginadim gibilan, Ne nazaq hi bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Haqad in ago disaipel nenaq uliq ta araqab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","In danib lehad luwsa mat araq Yesus bulon, Uliq saw edob ni lehdaqta nab ya nimuzeq ninaq tilehdaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Haqan Yesus bulon, Ni ninad em haseq teq ya imuzeq bol ham. Gaun kwasikta kuduqib osayta ham. Ah in gigo rir inaqta ham. Ari Mat Atatin in ago us osad anamur emdaqta abanan araq diq haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Haqad Yesus mat ta araq bulonim bilam, Ni ya imuzeq bol ham. Haqan mat na bilam, Iyahta ham ni ya ihulossa ya leheq imam tumomta na yay tonad teq ya boleq nimuzeq ninaq tilehdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Haqan Yesus bulon, Nab iyan ham. Mataw giwitan moqim usad God anadin a hi emayta na in gimo an wamuzad an yay toniy ham. Ari ninmo leheq God ago maror agamukan on mataw gibilenad luw ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sa mat ta araq in Yesus bulon, Iyahta ham ya nimuzeq ninaq lehdaiqta ham. Teq ni ya ihulosid ya leheq isenlul giben wazeq teq ya ta boleq nimuzeq ninaq tilehdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Haqan Yesus bilam, Mat dante dimunta tuwaqim teq sirisirimo in ame agilehun ban ta lehaqta, mat na God ago maror aduganib le a hi gwahtiqdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ari abeb Iyahta in mataw 72 nazaq gitowun emim giqeman in giger giger uliq saw bunmo Yesus abeb teq lehdaqta nabmo in danmeb tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lehsa Yesus gibilan, Kabiyab didaq kabemmo tizilimim giqusaq ham. Teq kabibiy mataw kabem diq a haiq ham. Nazaq iyan ne kabiy anamren inaq gamuk emad bulonsa in kabibiy mataw kabemmo giqemid boleq in ago didaq na giwaq ugiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Teq ne ginad em haseq lehiy ham. Ya ne giqeman ne sipsip amidgotniz gaun kwasikta gilikmanib leh nog iyay ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ne lehad mani araq giholib hi usan ham. Ad ne ziy araq hi bideqiy ham. Teq ne gisendugan hi emiymo ham. Ne lehad on mataw danib gibiyad nenaq gamuk sisaqmo emad hi turiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ne leheq bit araqab gwahtiqeq osnan haqad itureqmo ne kazaq gibileniy ham. On mataw bit kabta ne gigem dimniysa osiy haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Haqid mat araq dimunta bit nab osid teq ne gigem dimunta ugiyta na le mat na ago hib tuqusdaq ham. Ari mat araq dimunta nazaqta bit nab a hi osid teq ne gigem dimunta na ne gigo hib muleqeq bo ta usdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bit amulikmo ne os daqayta nabmo ne osiy ham. Ossa in didaq teq yuw negsa ne gihol afaqan hi iyiy ham. Ne neqmo neqiy ham. Na ezaqgo kabibiy mat mataw gimen kabiy emsa in amenin tuqug daqay ham. Teq ne haresmo bitbitmo hi luwiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ne leheq uliq araq aduganib gwahtiqid in ne giwazinad nenaq osad didaq negsa ne neqad nan kabemmo hi bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ad ne uliq nab on mataw gigo moq inaqta giwastitayid dimniysa ne gibileneq bilaqiy, God ago maror ne gigo hib sinsinmo tubol haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ari ne le uliq araqab gwahtiqid in ne gibaymuzsa ne uliq na agemab turad kazaq gibileniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ne gigo uliq ka aqogin i gisenab soqotim usaqta ka i wolilaman ne gigo hib ta lehaq haqiy ham. Na ago teq ne afaqan tisor daqay haqiy ham. Teq ne ginad em hasiy haqiy ham. God ago maror ne gigo hib sinsinmo bolan ne gileh ugiy haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ya ne gibilenaiq ham. Kam abebtanta nab uliq Sodom afaqan waq daqayta nazaq nog in afaqan a hi waq daqay ham. Uliq ne gibaymuz daqayta na in Sodom giquriyameq afaqan ayah diqta tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Haqad Yesus bilam, Uliq Korasin teq uliq Betsaida ham ne teq timeqniy daqay ham. Kwaziqmo mat araq leheq daq azawayin inaq ya ne gigo hib emta nazaq in uliq giger Tair-ib teq Saidon-ib emid on mataw na ginad tubuliy nagiy ham. Ginad buliyeq in gigo daq teq ginad meqinta gileh ugad in tubusan asorqan abiyornaqta weleq butbutmeb tuqos woq nagiy ham. Teq ne yaqgo daq azawayin inaqta na ahol waqim ne ginad buliyim gigo daq meqinta gileh a hi ugiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nazaq iyan abeb God hazizir ayahta emdaqta nab Tair teq Saidon afaqan waq daqayta nazaq nog ne a hi waq daqay ham. Ne in giquriyameq afaqan ayah diqta tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Teq uliq Kapaneam ham ne gibin iluwid Heven-ib gwalehdaq e? ham. Haiqgam ham. In ne gihunegid ne mataw tumoqiyta gigo sawab tuwoleh daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Haqad in ago disaipel gibilenim bilam, Mat ne giqez huritaqta na in ya iqez huritaqmo ham. Ad mat ne gibaymuzaqta na in ya ibaymuzaqmo ham. Ad mat ya ibaymuzaqta na in mat ya iqeman bolta na tubaymuzaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ari abeb mataw 72 Yesus giqeman lehiyta na in ginad dimniysa muleqim ta boliy. Bolim in Yesus buloniy, Iyahta haqiy i ni ninan biysa bugaw meqinta inaqmo i gihaqenib iyim in i gigo gamuk huritad muziniy haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Haqan Yesus gibilan, Ne le yaqgo kabiy emad luwsa Satan ulilibmo diq osim in mewlig hikliyan nog iyim ogib woqsa ya ahol way ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ne huritiy ham. Ya nagah meqmeqinta gibayid woqgo azawayin tineg ham. Negan ne nagah ahulinaqta teq kahkah nagan tigibay daqay ham. Teq ne ya ibinib luwad ne gigo bab na ago zaway bunmo ne wazid tuwoq bugdaq ham. Sa nagah araq diq a hi gimeqin tondaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ta teq bugaw meqinta ne giqez muzinayta na ago ne ginad hi dimniyan ham. Haiqgam ham. Ne giholnan God ago uliq Heven-ib tumar tonan usaqta naqmo ago ne ginad dimniyan ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ari kam nabmo diq God ago Bugaw Dimunta Yesus aholib ayahmo bolan in anad diq dimniysa bilam, O ya imam ham, Heven-ib teq og kab inaqmo ni Iyahta iyim osaqta ham. Ni mataw ginad awaz meqinta na teq mataw gimaqbel inaq iyim igmo ag haqad osayta na ni yaqgo kabiy alulin a hi giqisihunta ham. Haiq ham. On mataw gihol wazan woqsa in onmin gibin haiqta os nog iyayta naqmo ni yaqgo kabiy alulin tigiqisihunta ham. Ya imam ham ni ninad nazaqmo usan ni tiqam ham. Nazaq iyan ya esey nigaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Haqad Yesus ta bilam, Ya imam in ago kabiy bunmo ya ibenab tiqam ham. Mat araq diq in yaqgo a hi hurit ham. Ya imam amomo in yaqgo huritta ham. Teq mat araq ya imam ago a hi huritmo ham. Ya in atatin iyim ya imomo in ago huritta ham. Ad on mataw ya inad bilaqsa imam giqisihunaiqta naqmo in ya imam ago huritaytamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Haqad in ahol buliyim ago disaipel gibiyad in gidekib kiskismo gibilenim bilam, Nagah ne ahol waqayta ka ago ne ginad dimniyan ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ya ne gibilenaiq ham. Kwaziqmo God ago nantut kabemmo teq Isrel gigo king kabemmo in nagah ne muran ahol waqayta ka in ahol waqnan ginad diq bilaq yaqayta ham. Teq in moqim ahol a hi waqiyta ham. Ad gamuk kawa ne huritayta ka in huritnan ginad bilaq yaqaytamo ham. Teq in moqim a hi huritiyta ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yesus nazaq gamuk bilaqsamo mataw na gilikmanib mat araq Moses ago gunun hurit kamta na in eraqim Yesus ulum waqad tisusumun ug, Tisa ham ya ezaq toneq teq kayeqmo kuluwa-kuluwmo tuqosdaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Haqan Yesus bulon, God ago maror Moses bilamta na aduganib gamuk ezaq diqta mar tonan usaq? ham. Ni gamuk na ahol waqim ninad ezaq emaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Haqan mat na bilam, Gamuk na kazaq bilam ham. Ne gigem, ginad, giwitan, teq ne gigo zaway bunmo amalib ne gigo Iyahta God anan ginad bilaqan ham. Ad ni nihol anan ninad bilaqaqta nazaqmo ni niyow anan ninad bilaqan ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mat na nazaq bilaqan Yesus bulon, Ni gamuk amenin dimunmo tibilam ham. Ni nazaq toneq teq ni kayeqmo kuluwa-kuluwmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Teq mat na inmo ahol abin iluwnan haqad in Yesus bulonim bilam, Ta ya iyowta na nog? ham. Haqan Yesus bilam, Gamuk araq kazaq lahta ham. Ni hurit ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Juda mat araq uliq Jerusalem hulosim in uliq Jeriko-ib tuwolehad luw ham. Wolehad luwsamo mataw meqmeqinta danib ahol waqim wazim wolim ago nagah bunmo giwaqim in tukim tilehiy ham. Lehsa mat na moqnan tonad danib tuqus ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ussa kam nab Juda gigo mat tamaz emaqta araq in dan naqmo muzim wolehad luwimmo mat na ussa in ahol tuwam ham. Ahol waqad in aban emim dan adek ban loqim uriyamad lehmo tilah ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","An nazaqmo Juda gigo gem Liway anaynayin araq Tempel-ib kabiy emaqta na in dan nab bolim mat na ahol waqad in aban emim uriyamad tilahmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lehsa mat na ababun araq Samariya-ibta in dan nabmo bolim bo mat na agerab tugwahtim ham. Gwahtiqim mat na ahol waqad in anan anad timeqniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Anad meqniysa agerab loqim in oliv amasilan teq wain ayun mat na asulanib emim teq in tinat ham. Ad in mat na sorim inmo ago donki amalib emim in ad tilah ham. A lehim in bit araq mataw zayim usayta abitan nab eman ussa in wamuzim tuqus ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Usim eraqim tilehnan haqad in mani ameta gigermo bit na anamren ugad bulon, Ni mat ka wamuz ham. Ya muleqeq ta boleq teq mani ganim ni mat ka ayon hulosta na ya amenin tinigdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Haqad Yesus in mat Moses ago gunun hurit kamta na tisusumun ug, Ni ninad ezaq emaq? ham. Mataw ezeqman na gilikmanib nog diq in mat woliyta na ayowmat nog iyim ulumsih? ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","An mat na bilam, I gibabun Samariya-ibta bolim mat na anan anad meqniysa ulumsihta naqmo ham. Haqan Yesus bulon, Ari ni leheq Samariya mat daq amta nazaq ni asen muzeq em ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ari Yesus ago disaipel nenaq lehad luwim le uliq araqab tugwahtiqiy. Gwahtiqan aw araq anan Marta haqayta na in Yesus wazinad bulonim inaq ago bitab tilah. ");
INSERT INTO mlp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Lehan teq Marta ama anan Mariya haqayta na in eraqim le Iyahta anognib os woqim osad in ago suleq huritad osyaq. ");
INSERT INTO mlp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ossa Marta amomo in Yesus ago disaipel nenaq gimen didaq oyad kabiy kabemmo anadin emad anad timeqniyaq. Anad meqniysa in bolim Yesus tubulon, Iyahta ham ya ima ihulosim bo ni ninaq ossa ya imomo didaq oy akabiyan emaiq ham. Ni ya inan ninad a hi meqniyaq e? ham. Ni ya ima bulonid in boleq ya ilumsihan ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Haqan Iyahta bulon, Marta, Marta ham ni kabiy kabemmo na ginadin emad nihol afaqan iyaq ham. Teq kabiy amulikmo emnanta usaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kabiy dimunta na ni nima kawa ahol tuqug ham. Ugan i in aholib kabiy dimun diqta na a hi walemam ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ari kam araq Yesus le saw araqab God inaq gamuk emad tuqos. In God inaq gamuk bilaqim tihiqiyanmo ago disaipel araq bolim tubulon, Iyahta ham i ezaq God inaq gamuk emamta na ni i giqisihun ham, Jon in ago disaipel giqisihunta nazaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Haqan Yesus disaipel bunmo gibilan, Ne God inaq gamuk bilaqnan haqad ne kazaq bilaqiy ham. I Gimam Iyah, Ni on mataw bunmo giqemid in ni ninan waziniy. Ad ni ningo maror emid og kab gwahtiqan. ");
INSERT INTO mlp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kam amulik-mulikmo ago didaqta ni ig. ");
INSERT INTO mlp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Teq mataw i gigo hib daq meqinta emsa i walemad anadin a ta hi emauqta nazaqmo ni i gigo daq meqinta walemad anadin ta hi emmo. Ad nagah i gilum waqdaqta na ni wasihid i giholib hi gwahtiqan. ");
INSERT INTO mlp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesus nazaq gibilenim teq in bilam, Gamuk araq kazaq lahta ham. Ne huritiy ham. Tarom alihanib mat araq in ago kadoy ago bitab bolim bulon ham. Kadoy ni bret ezeqmanmo yag haqad in bulon ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ya iyow araq dan pesanmo bolad luwim bo yaqgo bitab tugwahtiqan ya didaq araq ugdaiqta na haiqgam haqad in bulon ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Haqan mat bit aduganib osta na bilam, Ni ya ituw hi bul haqad in bilam ham. Ya dan otim yaqgo onmin nenaq tuqusad iyan ya eraqeq nagah na a hi nigdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ari ya ne gibilenaiq ham. Mat bit aduganib osaqta na in ayow anadin a hi emaqta ham. Ta teq luweq inmo ahol abin timeqniydaq haqad in eraqeq nagah ayow ago siqim iyaqta na tuqug bugdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ad i God inaq gamuk bilaqgo adan nazaqmo usaqta ham. Teq God atuw a hi hiqiyaqta ham. Ne nagah araq anan susumun ugid teq in tinegdaq ham. Ne nagah araq naguneq teq ne ahol tuwaq daqay ham. Ne dan ez wolhamsa teq God ne giyon dan tihas negdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","On mataw nagah anan God susumun ugayta naqmo in nagah na waqayta ham. Teq on mataw nagah nagunayta naqmo in nagah na ahol waqayta ham. Ad on mataw dan ez wolhamsa teq God in giyon dan tihas negdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Teq ne gilikmanib amun araq nabiq neqnan haqad amam bulonsa amam in nagah ahulinaqta gimugaqta araq waqeq ugdaq e? ham. Haiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Teq amun na kurek akokin anan bilaqsa amam in kahkah araq waqeq ugdaq e? ham. Na haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ne mataw ginad meqinta usaqta ham. Teq ne gigo onmin nagah dimdimunta neggo ne tuhurit kemiyta ham. Ari i Gimam Heven-ib osaqta na in nazaq ago on mataw a hi gitondaqmo ye? ham. Haiq ham. On mataw Gimam Iyah inaq gamuk bilaqad bulonsa in ago Bugaw Dimunta tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ari Yesus in mat araq aholib bugaw meqinta ussa gamuk a hi emyaqta na tumuz. Muzan lehsa mat aqez hiqiyim luwta na gamuk tibilaqyaq. Bilaqsa on mataw ahol waqad in gihol riten lamyaq. ");
INSERT INTO mlp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sa mataw asor bilaq yaqay, Yesus in bugaw meqinta gigo danmebta Belsebul ago zaway amalib bugaw meqinta gimuzaqta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sa mataw ta asor Yesus ulum waqad susumun ug yaqay, Ni God bulonid in Heven-ib daq araq azawayin inaqta emid gehitiqsa i ahol waqad teq i ni ninan helmo tihaqam haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Teq Yesus mataw na ginad hurit kemim gibilan, Kantri araq ago on mataw gihol husereq an gihar ugad an wolad oseq in tihiqiy bug daqay ham. Ad bit araqab on mataw gihol husereq an gihar ugad teq in an tirabun daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ad nazaqmo Satan ago dauh nenaq gihol husereq an gihar ugad an wolad Satan ago zaway hiqiysa in ago kabiy tuwoqdaq ham. Ne ya inan bilaqay, In Belsebul ago zaway amalib bugaw meqinta gimuzaqta haqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ta teq ya Belsebul ago zaway amalib bugaw meqinta gimuzid ari ne gigo gisenlul asor na in nog diq ago zaway amalib bugaw meqinta gimuzayta? ham. Nazaq iyan ne ya ibilawunayta na negmo gigo gisenlul naqmo in tuqulum kem daqay ham. Ulum kemeq in bilaq daqay, Gamuk nawa ne bilaqayta na ne katiyay haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ari God-mo ago zaway ilumsihsa ya bugaw meqinta gimuzsa teq ne ginad emiy ham. God ago maror ne gilikmanib tubol haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ne ginad em hasiy ham. Mat araq awaz meqinta em sebur inaq wazim ago bit wamuzim ossa in ago nagah bunmo bitab dimunmo usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ta teq mat araq zaway diqta boleq bit anamren na inaq an woleq tuquriyamdaqta ham. Uriyameq in bit anamren abenab em sebur in wazim ago zaway inaq iyim osta na waqad in bit anamren ago nagah bunmo giwaq bugeq a le ago walmataw gigo hib tiqiberdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ne ginad emiy ham. On mataw ya inaq kabiy a hi emayta na in ya ibabun ham. Teq on mataw ya inaq yaqgo dauh a hi girom tonayta na in yaqgo mataw gimuzan hares-haresmo lehayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Haqad Yesus bilam, Bugaw meqinta araq mat hulos ugim gwahtiqim haresmo saw ayuwun haiqtab lehim luwaqta ham. Luwad in ban araq anamur emad osdaqta na nagunaqta ham. Teq haiq ham. In ban araq nazaqta ahol a hi waqaqta ham. In ban araq ahol a hi waqim teq in ahol bulonim bilaqaq, Bit kwaziqmo ya osta nab ya muleqeq ta lehdaiq haqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Haqad in bit nab muleqim ta lehim bit na asawun wolrironim anaghan bunmo wastitayim abanab eman ussa in ahol waqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ahol waqim teq in lehim bugaw meqin diqta 7 nazaq in daq meqinta emgo uriyamiyta na gililewunim giwaqim nenaq ta bolim in bit nab gwahtiqim osayta ham. Mebmebmo bugaw amulikmo mat na aholib ussa in ahol meqin dimun nog osyaqta ham. Ari muran teq bugaw 8 nazaq bolim mat na aholib ussa in ahol timeqniy hasim osaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus gamuk na bilaqsamo mataw dauh biyahta na gilikmanib aw araq lileyim bulon, Aw niqemim sus nigta naqmo tidimniyim osaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Haqan Yesus bilam, Haiqgam ham. Mataw God ago gamuk huritad muzinayta naqmo tidimniyim osayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ari on mataw teko bolim osiyta na os tutsamo mataw bunta in gigerab tubol yaqay. Bolsa Yesus gibilan, On mataw muran kam kab osayta ka in meqin diq ham. In daq azawayin inaqta naqmo ahol waqnan bilaqayta ham. Teq God daq araq azawayin inaqta a hi em negdaq ham. Daq Jona aholib gwahtimta naqmo in ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kwaziqmo Jona uliq ayahta anan Niniwe haqayta nab gwahtiqim on mataw gibilanta ham. Gibilenad in bilaqne God Niniwe on mataw hazizirib giqemeq gigo daq meqinta amenin negdaqta atowun in gigo hib os nog iyaq ham. Ad nazaqmo Mat Atatin in bilaqne God on mataw kam kabta hazizirib giqemeq gigo daq meqinta amenin negdaqta atowun in gigo hib os nog iyaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Abeb God hazizir ayahta emdaqta nab teq aw marorta kwaziqmo saw araq pesantab osta na in eraqeq on mataw muran kam kabta nenaq God ameb turad in mataw kam kabta gigo daq meqinta emid ulal tiqiydaq ham. Na ezaqgo aw marorta na uliq pesan diqtab osim Solomon abin huritim ago gamuk dimunta huritnan haqad ago hib tubol ham. Teq ne ahol waqiy ham. Mat araq Solomon uriyamta na in kawa ne gilikmanib osaq ham. Ta teq ne in ago gamuk dimunta huritnan gituw hiqiyayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Teq God hazizir ayahta emdaqta nab uliq Niniwe on mataw na eraqeq mataw muran kam kabta nenaq God ameb turad in mataw kam kabta gigo daq meqinta emid ulal tiqiydaqmo ham. Na ezaqgo on mataw Niniwe-ibta na in Jona ago gamuk huritim in ginad buliyim gigo daq meqinta gileh ugiyta ham. Teq ne ahol waqiy ham. Mat araq Jona uriyamta na in kawa ne gilikmanib osaq ham. Ta teq ne in ago gamuk huritim ginad a hi buliyayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ari mataw lam miderim bit aqiradnib eman a hi usaqta ham. Ad in lam miderim kuramab a hi sihenaytamo ham. Haiqgam ham. In lam miderim ulilib othenan oyad usaqta ham. Oyad ussa mataw lam anuwan na ahol waqad bolim bit na aqezab lo tugwahtiqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ad nazaqmo ni nimeqnagin nihol bunmo anuwan ugaqta ham. Ni nime dimun iyid ni nihol bunmo anuwan inaq tiqiydaq ham. Ari ni nime meqin iyid ni nihol bunmo aromriq inaq tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nazaq iyan ni nihol waz naqmo hiqiy ham. Luweq ni ninad emdaq, Ya idugan anuwan inaqta haqdaq ham. Teq haiq, ni nidugan aromriqnaq usdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ari ni nihol bunmo anuwan inaq iyad ni nihol anaghan araq romriqab a hi ussa teq ni nihol bunmo anuwan inaq tiqiy hasdaq ham. Bilaqne lam taromab oysa ni anuwanib osad nihol bunmo anuwan inaq iyaqta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ari Yesus gamuk bilaqim tihiqiyan Farisi araq Yesus waqeq ad ago bitab leheq inaq didaq neqnan haqad tubulon. Bulonan Yesus mat na inaq lehim ago bit aduganib gwahtiqim banab tuqos. ");
INSERT INTO mlp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Osad in aben a hi suholimmo didaq neqsa Farisi na ahol waqad anadnad tiqemyaq. ");
INSERT INTO mlp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Sa Iyahta bulon, Ne Farisi ham ne gog teq deg gisanmo suholayta ham. Teq ne giduganib rin tongo adan teq daq meqinta amo amo ate gwalim usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ne mataw agadanta ham. Mat ne gisan amta na in ne gimugan amtamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nazaq iyan nagah ne gimuganib usaqta na ne wastitayid dimniyid teq ne daq dimdimunta God anan anad bilaqaqta naqmo emiy ham. Ne nazaq emsa teq nagah bunmo ne giwazayta na anumlan tihiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ne Farisi ham ne timeqniyim osayta ham. Ne gigo kabiyab kwasin amik diqta anan mint haqayta na teq gunay teq kwasin-kwasan amikmikta amo amo ne giwaqim gihuseran humab 10 nazaq iyan humab amulikmo ne God ugayta ham. Ta teq daq titnonta amalib mataw gilum kemayta na teq God anan ginad bilaqayta na ago ne gidek zizalan ne a hi emayta ham. Ne daq aseseqta nawa na gidek a hi zizalsa ne tiqem nagiyta ham. Emad ne daq amikmikta na tiqem nagiymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ne Farisi ham ne timeqniyim osayta ham. Ne bit humab wolaytab ban ulilibta nabmo osnan ginad bilaqaqta ham. Ad ne maket-ib luwsa mataw ne gibiyad ginan ‘mat ayah’ haqsa ne ginad diq dimniyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ne timeqniyim osayta ham. Ne bilaqne hodhod agelin haiqta nog ham. Gel haiqgam iyan mataw hodhod usaqta na ahol a hi waqadmo gwahtiqim loq gelad luwayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Haqan mataw Moses ago gunun hurit kemiyta na gigo araq in Yesus ago gamuk amenin emim bilam, Tisa ham ni nazaq Farisi ginan bilaqad ni igmo gibin inaqmo meqin tonaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Haqan Yesus bilam, Ne mataw Moses ago gunun hurit kemiyta na ham ne timeqniyim osaytamo ham. Ne gunun kabemmo diq on mataw negayta ham. Bilaqne ne nagah afaqanta on mataw gibetarib eman in sorgo giholtuw diq bulayta nazaq ham. Teq ne giben akurgan araq diq loqim gilumsihad asit a hi sor negayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ne timeqniyim osayta ham. Ne gisesan God ago nantut kabemmo ginol emiyta ham. Ginol eman abeb ne nantut na gimen hodhod abitan dimdimunta giqemiyta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ne gisesan God ago nantut ginol eman moqiyta na ago ne ginad dimniyiy daqagya ham. Ginad dimniysa ne in gilumsihad mataw ginol emiyta na gimen hodhod abitan na giqemiyta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","God anad awaz meqin diqta iyim iyan in ne gilum kemimmo ginan kazaq bilam ham. Ya Aposel asor teq yaqgo nantut asor giqemid in yaqgo on mataw gigo hib leh daqay haqad in bilam ham. Lehid teq yaqgo on mataw na in gibaymuzad asor in ginol em daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","God og ka mutur amta nab iyim bo muranmo mataw in ago nantut kabemmo ginol eman moqiyta ham. Teq nantut na bunmo ginedan womta na in mataw kam kab osayta ka gigo afaqan ham. Nazaq iyan in ginedan womta na aqenin God in on mataw muran kam kabta gigo hib tuwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mebmebmo mataw Abel wol eman moqan in anedan wom ham. An abeb diq in Tempel teq tamaz em abanan Tempel asan ban turaqta na gilikmanib in Sekaraya wol eman moqan in anedan wommo ham. Ne gisesan Abel akamnib mataw dimdimunta ginol emim bo bo Sekaraya ago akamnib tiqiyiy ham. An ya helmo ne gibilenaiq ham. God in mataw dimdimunta ginedan womta na giqenin on mataw muran kam kab osayta na gigo hib tuwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Haqad Yesus bilam, Mataw Moses ago gunun hurit kemiyta na ham ne timeqniyim osayta ham. On mataw God ago hurit kemnan haqad susumun negsa ne in gidanin qwayayta ham. Negmo diq God ago a hi hurit kemayta ham. Ad mataw ta asor na in God ago hurit kemnan tonsa ne giwasihayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Admo Yesus bit na hulosim le asanib tugwahtim. Gwahtiqan teq mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq in Yesus anan gigem meqin diq iysa in ulum waqad nagah haresmo anan susumun tuqug yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Susumun ugid in gamuk araq hi bilaqnanta bilaqid teq i tuwazam haqad in baynetim tur yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ari Yesus gamuk na bilaqad tursamo on mataw kuluw diqmo in agerab humab emim an ger ger diq turad in an asen tubay yaqay. Sa Yesus iturimmo inmo ago disaipel gibilenim bilam, Ne Farisi gigo yis anan gihol waz naqmo hiqiyiy ham. Ari ya Farisi gigo yis haqad bilayta na ya in gigo daq in gimileq iyayta naqmo anan bilayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nagah bunmo mataw giqisihan usaqta na abeb teq God hasid mataw bunmo ahol tuwaq daqay ham. Ad nagah bunmo mataw gikasnaknib usaqta na abeb God emid ulalab tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nazaq iyan gamuk bunmo ne mataw gime titonim romriqab bilaqiyta na abeb mataw gamuk na saw anuwanibmo bilaqsa on mataw bunmo tuhurit daqay ham. Ad ne ulilemim bit aduganib gamuk kiskismo an adekib bilaqiyta na bunmo abeb mataw bit ahuqunib gwale turad teq in dedibmo lileyeq tibilaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ya ikadoyniz ham ya ne gibilenaiq ham. Mataw ne gisanmo wol em daqayta ham. Gisan wol emeq in ne gigo hib daq araq emgo in gigo zaway haiqta ham. Nazaq iyan ne mataw hi girabuniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ari ne mat rabun daqayta na ago ya tigibilendaiq ham. In ago zaway kazaq usaqta ham. In ne ginol emeq teq in ne gihunegid saw faq oyad a hi miyaqtab tuwoleh daqayta ham. Helmo ya ne gibilenaiq ham. Ne mat naqmo rabuniy haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mataw mani asit diqmo hulosim ah amikmikta abaynaginmo gizayayta ham. Teq God in ah amikmikta na gigo araq diq anan adek a hi zizalaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ad in ne gibiy kemad ne gifaqinib giqensan na in ginulinim ganim diq usaqta na in tuhurit bugta ham. Nazaq iyan ne hi rabiy ham. Ne ah amikmikta nog a haiq ham. Ne ah amikmikta na ayahmo giquriyamiyta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ya ne gibilenaiq ham. Mat aw nog in mataw gimeb bilaqdaq, Ya Yesus-mo ago matta iyim osaiqta haqdaqta na abeb Mat Atatin nazaqmo God ago angelo gimeb turad in mat na anan bilaqdaq, In yaqgota tihaqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ari mat nog in on mataw girabunad gimeb gileh yagid ya nazaqmo God ago angelo gimeb mat na gileh tuqugdaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","On mataw Mat Atatin bilawunayta na bunmo God in gigo daq meqinta na tuwalemdaq ham. Ari mat araq God ago Bugaw Dimunta bilawunid God in ago daq meqinta na a hi walemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Abeb mataw ne giqad Juda gigo bit humab wolaytab leheq mataw marorta gimeb teq gavman gimeb giqemid tursa ne hi rabiy ham. Ad ne mataw aseseqta na gigo gamuk amenin emeq ne naga gamukin bilaq daqayta na ago ne ginadnad hi emiymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kam nabmo diq teq God ago Bugaw Dimunta in gamuk ne bilaq daqayta na tigiqisihundaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ari mat araq on mataw dauh biyahta na gilikmanib eraqim turad in Yesus bulon, Iyahta ham ni ya ibab bulonid in i gimam tumomta na ago ahuran nagah husereq asor ya yagan ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Haqan Yesus bulon, Kadoy ham. Nog diq ya iqeman ya ne gigo jas o megistret iyim ya ne gimen midiyesin wazdaiq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Haqad in on mataw bunmo gibilenim bilam, Ne gihol asawan woltayad osiy ham. Luweq ne amota gigo nagah utet daqay ham. Ne giholyon nagah kabemmo tuwal emgo og kab a hi osayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Haqad in gamuk awowun araq kazaq gibilan, Mat ago es kabemmo inaqta araq ago kabiyab didaq gwalim anon kabemmo diq giqam ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sa mat na ahol bulonim bilam, Ya teq ezaq tondaiq? haqad in bilam ham. Yaqgo bit araq ayahta yaqgo didaq tuwal emid osdaqta na haiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Haqad in anad tiqemim bilam, Ya kazaq tiqemdaiq haqad in bilam ham. Yaqgo didaq abitan amikmikta na giqiner tiqsa teq ya gisawnib bit muturta aseseqta tigiwazdaiq haqad in bilam ham. Giwazeq yaqgo wit anagin teq yaqgo es bunmo bit na giduganib tuwal em bugdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tuwal emid ussa teq ya ihol buloneq bilaqdaiq, Ya matmo diq haqdaiq haqad in bilam ham. Yaqgo nagah dimdimunta ulig kabemmo agota usaq haqdaiq haqad in bilam ham. Ya kabiy araq a ta hi emdaiq haqdaiq haqad in bilam ham. Ya inamur emad didaq neqad yuw uluwad inad dimniysa tuqosdaiq haqdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Haqan teq haiq ham. In ahol nazaq bulonad ossamo God tubulon, Ni mat agadanta haqad in bilam ham. Muran tarom kabmo ni tumoqdaq haqad in bilam ham. Moqid ni nagah niholyon tuwal emad osta na nog teq waqdaq? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Haqad Yesus bilam, Mataw asor in giholyon es nagah kabemmo tuwal emayta ham. Teq God ago hib in gigo nagah araq dimunta a hi usaqta ham. Mataw naqanta gigo hib teq daq nawa ya anan bilayta na tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Haqad Yesus in ago disaipel gibilan, Nazaq iyan ya ne gibilenaiq ham. Ne gigo luw os anan ginad haresmo hi emiy ham. Ad “I teq naga neqam?” o “I teq naga amalib i gihol sihenam?” haqad nazaq ne ginad hi emiymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ne didaq neqgomo og kab a hi osayta ham. Ad ne gihol in tubusanib sihengomo a hi usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ne ah ginadin emiy ham. In didaq a hi leyayta ham. Ad in didaq a hi tayaytamo ham. In gigo didaq abitan in giholyon didaq tuwal em daqayta na haiqmo ham. God-mo didaq negsa neqayta ham. Teq ne ah nog a haiq ham. Ne ah ayahmo giquriyamiyta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ne gilikmanib nog diq inmo ahol anan anad meqniysa in ahol moqdaqta akaman na ulum riyawuneq asitmo a ta osdaq? ham. Na haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ne nagah amik diqta na a hi em daqayta iyan nagaqgo ne nagah aseseqta na ginan ginad meqniyaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ne mazrewrew kabiyabta na anadin emiy ham. In aholyon kabiy araq a hi emaqta ham. Ad in aholyon tubusan a hi initaqtamo ham. Teq ya ne gibilenaiq ham. Kwaziqmo Isrel gigo king Solomon in ago balaw dimdimunta aholib emyaqta ham. Ta teq in ago balaw araq dimun diqta mazrewrew nogta haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mazrewrew na muran usid babeq mataw uroteq faqab ginuwid gwaldaq ham. Teq God nagah samanta na dimun diqmo balaw tonaqta ham. Nazaq iyan in ne tubusan tinegdaqmo ham. On mataw ham ne ginad God anan helmo haqayta na in amik diq ham. Ne ginad em hasiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ginad em haseq ne nagah neq daqayta na teq ne nagah uluw daqayta na ago ne gituw bulad hi luwiy ham. Ad negmo gihol anan ginad hi meqniyan ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Og kab on mataw en bunmo in nagah osgota na waqgo giholtuw bulad luwayta ham. Teq ne nagah osgota na a hi waqeq ne meqin os daqayta na ago ne Gimam Iyahta na tuhuritta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nazaq iyan ne og ka ago nagah na waqgo gituw hi buliy ham. Haiq ham. Ne God ago maror aduganib gwahtiqgo giholtuw bulad luwiy ham. Ne nazaq emsa teq God nagah osgota na bunmo inaqmo tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Haqad Yesus bilam, Ne mataw zaway haiqta ne hi rabiy ham. Ne Gimam anad bilaqan in ne giqeman ne in ago maror aduganib tugwahtiqiyta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nazaq iyan ne gigo nagah bunmo gizayeq amenin waqad teq ne mataw gina haiqta nagan negiy ham. Negeq teq ne mani aziyan a hi tartaydaqta araq ne giholyon nayiy ham. Nayeq teq ziy nab ne giholyon nagah dimdimunta Heven-ib tuteqmo usdaqta na tuwal emid usan ham. Uliq nab mataw nagah rin tonayta a hi luwayta ham. Sa bidbid nagah a hi meqin tonaytamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ne ginad emiy ham. Uliq edob ne gigo nagah dimdimunta usdaqta nabmo teq ne ginad ayahmo tuqusdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ne gihol wastitayeq lam miderid oysa ne saw waqad osiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bilaqne kabibiy mataw gigo ayahta an waq ahumabun araqab oseq bolsa in amen emayta nazaq nogmo ne osiy ham. Kabibiy mataw na saw woltayad ossa in gigo ayahta na bo dan ez wolhamsamo in hidmo era ayon dan tihas daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kabibiy mataw na gime a hi rursa in saw waqad ossa in gigo ayahta na boleq nazaq gibiyid kabibiy mataw na tidimniyeq os daqay ham. Ya ne helmo gibilenaiq ham. Mat ayahta na ahol wazid woqsa in ago kabibiy mataw na gigo kabibiy mat nog tiqiydaq ham. Iyeq in ago kabibiy mataw na giqemid banab ossa teq in gimen didaq a bo negid in tineq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mat ayahta na tarom alihanib o tarommo saw tihastitaynan tonsa in boleq ago kabibiy mataw na a hi usad saw waqad ossa in gibiyid, kabibiy mataw na tidimniyeq os daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ari ne gamuk ka huriteq teq ne ginad em hasiy ham. Bit anamren in mat rin tonaqta naga kamnib boldaqta na ago huritid teq mat rin tonaqta na bo ago bit wolzilayeq a hi gwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ad nazaqmo ne saw waqad osiy ham. Ne bilaq daqay, Mat Atatin a hi boldaq haq daqayta nabmo diq in bo tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Haqan Pita bilam, Iyahta ham gamuk awowun na ni i disaipel gimomo gibilenaq o haiq ni mataw bunmo gibilenaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Haqan Iyahta bilam, Naga matin in kabibiy mat dimunta nog? ham. Kabibiy mat dimunta in anad em hasad ago ayahta aqez muzinaqta ham. Aqez muzinad in kabibiy mataw bunmo giwamuzad didaq neq akamnib in didaq negaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Abeb ago ayahta boleq in kwaziqmo bilamta nazaqmo ago kabibiy mat na emsa in ahol waqsa in ago kabibiy mat na tidimniyeq osdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya helmo ne gibilenaiq ham. Mat ayahta na in ago kabibiy mat dimunta na emid in ago nagah bunmo tigiwamuzdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ari luweq kabibiy mat na ahol buloneq bilaqdaq, Yaqgo ayahta lehim sisaqmo luwad in hidmo a hi boldaq haqdaq ham. Haqad in kabibiy on mataw ta asor giwamuzaqta na haresmo tiginoldaq ham. Ad in didaq neqad yuw uluwad ahol agadan iysa osdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","In nazaq emad ossamo ago ayahta bolsa in a hi huritdaq ham. Ad in ahol asawan a hi wastitaydaq ham. Sa mat ayahta na boleq in kabibiy mat na wazeq woltitayeq teq in mataw nan a hi huritayta na gigo sawab hunegid wo tilehdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Haqad Yesus bilam, Kabibiy mat araq in ago ayahta anad huritdaqta ham. Huritad teq in ahol a hi wastitayad ago ayahta anad na a hi muzdaq ham. Abeb ago ayahta na in ago mataw gibilenid in kabibiy mat meqinta na woltitay naqmo diq hiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ari kabibiy mat ta araq in ago ayahta anad a hi huritdaqta ham. Ad teq in daq a hi em nagta tiqemdaq ham. Abeb mataw in kabibiy mat na asitmoqmo wol daqay ham. Ari mataw God ago hib nagah kabemmo tuwaqiyta na God in gigo hib amenin ayahmo waqdaqta ham. Ad God in mataw gibenab kabiy ayahmo amta na gibilenid in amenin emad in nagah asor bunta amalib emeq tuqug daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ari Yesus bilam, Ya og kab faq araq ayahta ulamnan haqad bol ham. Ad ya inad emaiq faq na tekomo tiqeraq nagta haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Teq haiq ham. Santitiy araq ayahta ya tiqiqisih bugid teq faq na tiqeraqdaq ham. Sa muran ya santitiy na a hi loyinadmo ihol afaqan diq tiqiyaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ne ginad emay ya og kab on mataw bunmo giqemid zib alowab osgo haqad ya bolta haqay ye? ham. Haiqgam ham. Ya ne gibilenaiq ham. Ya on mataw gihusernan bol ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Abeb on mataw abaynagin in bit araqab osad teq in gihol husereq dauh gigermo iy daqay ham. Iyeq mataw ezeqman na ya inan helmo haqsa mataw giger na in haiq ham. Nazaq iyid teq in an gihar tuqug daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","In nazaq emad, Onmin matmatta in gimaman gihar negsa gimaman in gitatniz gihar neg daqaymo ham. Ad nazaqmo onmin onqonta in ginenan gihar negsa ginenan in gimigniz gihar neg daqaymo ham. Sa on in gidugniz ginenan gihar negsa gidugniz ginenan in gilenan na gihar neg daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ad Yesus in on mataw dauh biyahta na gibilenim bilam, Zeq wolehaqta ban kait dub iyeq bolsa ne ahol waqad bilaqay, Ka urom tuwoqdaq haqayta ham. An helmo urom woqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ad tim ayahta sibim bolsa ne ahol waqad bilaqay, Ka zeq afan meqin diq iydaq haqayta ham. An helmo in nazaqmo iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ne mataw gimileq meqinta ham. Ne og kait inaq giwaqan ahol waqad nagah teq gwahtiqdaqta na ago ne ginad em hasayta ham. Ari nagaqgo muran kam kab nagah ne gimeb gwahtiqsa ne ahol waqad ginad a hi em hasay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nagaqgo ne ginad a hi em hasad daq dimunta teq daq meqinta na a hi gilum kemay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mat araq ni niqad hazizirib leheq nan nignan tonsa ni inaq danib lehad hidmo gamuk na wastitayiy ham. Luweq in nihureqeq niqad le megistret ameb gwahtiqdaq ham. Gwahtiqid megistret niwaqeq hurmey gibenab niqemid hurmey niwazeq bit giqirquran osaytab nihuneg daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ya ni nibilenaiq ham. Ni bit na hidmo a hi hulosdaq ham. Ni bit nab osad ningo daq meqinta amenin zay bugeq teq ni asanib gwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ari kam nabmo mataw asor osim Yesus buloniy, Mataw Galiliy-ibta asor God amen tamaz emad ossa Pailat ago mataw giqeman lehim in mataw na ginol em bugiy haqiy. Ginol em bugan mataw na ginedan woqim karuw tamaz emnan haqad anat urotiyta na anedan inaq wastonim tamaz em abanab giqus haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","In nazaq haqan Yesus amenin emim gibilan, Luweq ne ginad em daqay, Mataw ginol emiyta na gigo daq meqinta in Galiliy-ib on mataw bunmo gigo daq meqinta giquriyaman iyan in moqiy haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Haiqmo diq ham. Ari ya helmo gibilenaiq ham. Ne gigo daq meqinta giholib usaqta na ne gileh a hi ugeq ne bunmo nazaqmo tumoq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Haqad in bilam, Kwaziqmo uliq Jerusalem-ub yuw akurorqanta anan Silowam haqayta nab bit araq ayahta sisaqmo gwalahta na woqim mataw 18 nazaq giqisihan moqiy ham. Ne luweq ginad em daqay, Mataw moqiyta na gigo daq meqinta in Jerusalem-ub on mataw bunmo gigo daq meqinta giquriyaman iyan in moqiy haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Haiqgam ham. Ya helmo gibilenaiq ham. Ne gigo daq meqinta giholib usaqta na ne gileh a hi ugeq ne bunmo nazaqmo tumoq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Haqad Yesus gamuk awowun araq kazaq gibilan, Mat araq ay fik amagin araq ago wain akabiynib tilay ham. Leyim abeb in bolim ay fik na anon araq a hi ussa ahol wam ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ad in ago mat kabiy wamuzaqta na bulon, Ni hurit haqad in bilam ham. Ya ay fik ka leyan in ulig ezeqmanmo titur haqad in bilam ham. Tursa ya bo anon anan saw waqaiqta teq in anon araq diq a hi emaq haqad in bilam ham. In turad og amoyan samanta waqaq haqad in bilam ham. Ni qwayid woqan haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Haqan kabibiy mat na bilam, Iyahta ham i ay ka hulosid in ulig kab a ta turan haqad in bilam ham. Tursa ya abeqarib og tayeq bulmakau abekoq tiqemdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Luweq ulig araq kob teq in anon emdaqta hi waqan us haqad in bilam ham. Ari ulig nab in anon a hi emsa teq ya tuqwaydaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ari Juda gigo lotu akaman araqab Yesus Juda gigo bit humab wolaytab on mataw suleq tinegyaq. ");
INSERT INTO mlp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Suleq negsamo aw araq bit nab bo tugwahtim. Aw na aholib bugaw meqinta usad ulig 18 nazaq in moq ugad usyaqta. Ussa aw na kor toneq luwad in akorkoran itiwuneq titnoneq turgo hiqiyyaqta. ");
INSERT INTO mlp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sa Yesus aw na ahol waqad bulonan agerab bolan in bulon, Neng ham ya niholib moq usta na waleman tihiqiy ham. Muran ni samanmo titnoneqmo tiluwdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Haqad in aben aw na aholib emim wazan hid naqmo in titnonimmo titur. Turad in God abin tiqiluwyaq. ");
INSERT INTO mlp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesus aw na eman dimniyta na in lotu akamnib daq na amta. Nazaq iyan bit humab wolayta ago danmebta na in Yesus anan agem timeqniy. Agem meqniysa in on mataw gibilan, I kabiy emgo kam 6 nazaq usaqta ham. Kam nab teq ne gigo moq wastitaynan boliy ham. Ari lotu akamnib ne gigo moq walemnan hi boliy ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Haqan Iyahta amenin emim bulon, Ne mataw gimileq meqinta ham. Lotu akamnib ne bunmo lehim ne gigo bulmakau teq donki giqirquran gibitnib turayta na giqamun hasim giqad lehan in yuw uluwayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aw ka in Abraham asenlulibta ham. Teq Satan sisaq diqmo ulig 18 nazaq in irquran osta ham. Ta nagaqgo ya lotu akamnib in aqamun na a hi hasdaiqmo? ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus nazaq ago bab gibin wazan woqan in gimebay tuwom. Gimebay woqsa on mataw dauh biyahta na bunmo in daq dimdimunta Yesus emyaqta na ahol waqad in ginad tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Haqad Yesus ta gibilan, God ago maror in naga diq nog? ham. Ya naga diq atowun emeq bilaqid teq ne ginad em has daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","God ago maror in bilaqne ay mastet anagin amik diqta amulikmo mat araq ago kabiyab layta na nog ham. Leyan in gwalim ay nog iyim ayah tiqiy bug ham. An teq ah bolim giholyon rir emim tuqos yaqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Haqad Yesus ta bilam, Ya God ago maror atowun emnan haqad ya naga diq atowun emeq bilaqid teq ne ginad tiqem has daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","God ago maror in bilaqne yis nogta ham. Aw araq yis na waqim mel deg ezeqman nazaq inaq buliyan yis ulilemim ussa mel na bunmo huhuw tinam ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ari Yesus uliq Jerusalem-ub wolehadmo in uliq aseseqta teq uliqben amikmikta nagab on mataw suleq negim negim tilehyaq. ");
INSERT INTO mlp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Lehad luwsa mat araq Yesus tisusumun ug, Iyahta ham ni ya ibilen kem ham. God teq mataw amulik-mulikmo giqemid ago maror aduganib gwahtiq daqay o haiq in mataw kabemmo giqemid gwahtiq daqay? ham. Haqan Yesus mataw nab turiyta na bunmo gibilan, Ne zaway diq iyeq dan ez amikta nabmo le gwahtiqiy ham. Mataw kabemmo dan ez amikta nab le gwahtiqan yo hiqiyayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Abeb bit anamren eraqeq bit ago dan ez amikta na tuqotdaq ham. Otid teq ne boleq dan ezab turad dan ez wol hamad ne kazaq bilaq daqay ham. Iyahta haq daqay ni i giyon dan has haqad ne bilaq daqay ham. Haqid in ne gigo gamuk amenin emeq kazaq gibilendaq ham. Ne mataw edob boliyta na ya a hi hurit haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Haqid ne tubulon daqay ham. Haiq haq daqay ham. I ni ninaq didaq neqad yuw uluwad osta haq daqay ham. Teq ni i gigo uliqab bolim suleq igta haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Haqid in ne a ta gibilendaq ham. Haiq haqdaq ham. Ne edob diq boliyta na ya a hi hurit haqdaq ham. Ne mataw daq meqin emayta ne bunmo kozaq lehiy haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ad in ne gimuzid ne le in ago maror asan ban gwahtiqeq tuqos daqay ham. Osad ne Abraham teq Aisak teq Jekob teq God ago nantut bunmo in God ago maror aduganib ossa ne tigibiy daqay ham. Gibiyad ne ginad meqniysa gaqad gite guruwad tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Teq og saw bunmo gigo on mataw amo amo kabemmo boleq God ago maror aduganib didaq neqad tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nazaq iyan ne ginad em hasiy ham. Mataw kabemmo og kab gibin haiqmo osayta na in le danmeb tiqiy daqay ham. Sa mataw og kab gibin inaqta nagan gibin hiqiysa in abeb tiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ari kam nabmo diq Farisi asor bolim Yesus buloniy, Ni uliq ka huloseq saw araqab leh haqiy. Herot ninol emnan bilaqaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Haqan Yesus gibilan, Ne leheq gaun kwasikta na buloniy ham. Ni hurit haqad buloniy ham. Muran teq babeq ya bugaw meqinta gimuzad mataw gigo moq inaqta giwastitaysa dimniy daqay haqad ne buloniy ham. Ad misireq ya igo kabiy tuwol hasdaiq haqad ne buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ari ya kam ezeqman na aduganib dan ahulib Jerusalem-ub wolehad ya dimunmo tiluwdaiq ham. Na ezaqgo God ago nantut saw haresmo a hi ginol emayta ham. In Jerusalem-ubmo ginol eman moqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Haqad Yesus bilam, O Jerusalem, Jerusalem ham. Ningo mataw God ago nantut ginol emayta ham. Ad ne God ago kabibiy mataw in giqeman ne gigo hib lehayta na gimalib gig hunegayta ham. Kam kabemmo ya ningo on mataw gituwal emnan inad bilamta ham. Bilaqne kurek anenqab aben gayik ahaqenib amidgotniz gituwal emim giqisihaqta nazaq ham. Ta teq ne hulosiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nazaq iyan ne huritiy ham. God ne gigo uliq hulosim tilah ham. Ya ne gibilenaiq ham. Ne ya a ta hi ibiy daqay ham. Ari ne ginad dimniysa bilaq daqay, Mat ka Iyahta abinib bolan i ginad bilaq gigayinaq haq daqayta kam nab teq ne ya a ta ibiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ari Juda gigo lotu akaman araqab Yesus in Farisi gigo danmebta araq ago bitab didaq neqnan tilah. Lehim ossa mataw gibin inaqta nagan in Yesus anononmo diq wirinad os yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sa mat araq ahol umta Yesus anognib os. ");
INSERT INTO mlp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ossa Yesus mat na ahol waqad in mataw Moses ago gunun hurit kemiyta na giyogniz Farisi nenaq tisusumun nag, I gigo lotu akamnib i mat ago moq inaqta na wastitayid dimniydaq o haiq? ham. I Juda gigo maror ezaq usaqta? ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Haqan mataw aseseqta na giqezmo hiqiyim osiy. Nazaq iyan Yesus mat na wazim wastitayan ago moq dimniyan in eman tilah. ");
INSERT INTO mlp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mat na tilehsa teq Yesus mataw aseseqta na gibilan, Ne gilikmanib mat araq ago amun o ago bulmakau araq lotu akamnib yuw yayibtab woqid tobag mat na hidmo hureqid a hi gwaldaqya ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Haqan mataw aseseqta na in Yesus ago gamuk na amenin araq a hi emiy. ");
INSERT INTO mlp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ari Yesus humab nab osad in mataw didaq neqnan boliyta na gibiysa in ban ulilibta nabmo osnan ginad bilaqyaq. Nazaq iyan in gamuk awowun araq kazaq gibilan, ");
INSERT INTO mlp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Mat araq aw waqnan tonad in ni nibilenid ni ago humabub leheq itureqmo ni le ban ulilibtab hi os ham. Luweq humab na anamren mat ta araq in abin ni nibin uriyamta na lilewundaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nazaq iyid teq humab anamren ne giger gililewunan boliyta na in ni nigerab boleq nibileneq bilaqdaq, Ningo ban dimunta na ni mat ayahta ka ug haqdaq ham. Id teq ni nimebay woqsa leheq ogib garuruhab tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nazaq iyan mat araq nililewunid ni didaq neqnan leheq ni le ogib garuruhabmo os ham. Ni nazaq emid teq humab na anamren boleq nibilendaq, Kadoy haqdaq ni bo leheq ban ulilibta kob os haqdaq ham. In nazaq nibilenid on mataw ninaq didaq neqad osayta na bunmo in ni nibin tiqiluw daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","On mataw in gimo gihol abin iluwayta na bunmo gibin tuwoqdaq ham. Sa on mataw gihol abin wazan woqaqta na gibin tiqeraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Haqad Yesus humab na anamren bulon, Ni humab araq a ta emnan haqad ni niyogniz teq nimaqbaban teq nisenlul teq ningo uliq araqibta gigo es kabemmo inaqta na ni hi gililewun ham. Luweq abeb in ni nililewunid ni le in gigo bitab didaq neqsa in ningo didaq neqiyta na amenin nig daqay ham. Nigid teq ni God ago hib amenin araq dimunta a ta hi waqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ni nazaq hi em ham. Ni humab araq tiqemnan haqad ni mataw ginaghan haiqta teq mataw gibensen ayqayta teq mataw gisen meqinta teq mataw gime haiqta naqmo gililewun ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ni nazaq tonid teq God tinidimun tondaq ham. Na ezaqgo ham mataw nazaqta na in ningo didaq amenin a hi em daqayta ham. Abeb God-mo teq ningo daq dimunta na amenin tinigdaq ham, kam mataw dimdimunta hodhodab eraq daqayta nab ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ari mataw didaq neqad osiyta na gilikmanib mat araq gamuk na huritim in Yesus tubulon, On mataw God ago maror aduganib teq didaq neqad os daqayta na in muran tidimniyim osayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Haqan Yesus bulon, Wagam araq kazaq lahta ham. Mat araq didaq ayahta oynan haqad mataw kabemmo gimen nan am ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nan eman teq abeb humab na ago kam diq tugwahtim ham. Gwahtiqan mat na in ago kabibiy mat bulonan in le mataw tanabmo gibilanta na a ta gibilan ham. Ne boliy haqad in bilam ham. Nagah bunmo neqgomo tiqiyim usaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Haqan mataw na bunmo gituw tihiqiyiy ham. Gituw hiqiysa araq bilam, Ya le og araq muturta zayta na ahol tuwaqnan ham. Nazaq iyan ya humab nab a hi lehdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sa mat araq bilam, Ya bafalo 10 nazaqmo tigizay ham. Gizayim ya giqad leheq kabiyab og tuwol waqnan ham. Nazaq iyan ya humab nab a hi lehdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sa mat araq bilam, Muran diq kawa ya aw tuway ham. Nazaq iyan ya humab nab a hi lehdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Haqan kabibiy mat na muleqim lehim in ago ayahta nagah na bunmo ago tubulon bug ham. Bulon bugan bit anamren na agem meqniysa in ago kabibiy mat na bulon, Ni hidmo uliq aduganib kob ta leheq mataw ginaghan haiqta teq mataw gibensen kok tonta teq mataw gime haiqta teq mataw gisen meqinta edob edob osayta na ni giwaq bugeq yaqgo bit aduganib giqad bol haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","An abeb kabibiy mat na bolim bilam, Iyahta ham ya ni niqez na tumuz bug ham. Teq ban asor samanmo usaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Haqan mat ayahta na in kabibiy mat na bulon, Ni uliq asan ban leheq dante haresmo saw waq ham. Saw waqeq ni mataw gibiyad gibe yaheq gihureqeq giqad bo gwahtiq haqad in bilam ham. Gwahtiqid yaqgo bitab mataw ban waqmo bugiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya nibilenaiq ham. Ya mataw mebmebmo gililewunan a hi boliyta na gigo araq diq in yaqgo didaq aneglan asit a hi neq waq daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Ari on mataw dauh biyahmo Yesus muzim inaq tileh yaqay. Lehsa Yesus ahol buliyim gibilan, Mat nog ya imuzeq bolnan haqad in yaqmo imomo inan anad ayahmo bilaqan ham. Ari mat in anenmaman teq ago aw amun teq amaqbaban teq ahiyan ginadin emad teq inmo ahol anadin diq emaqta, mat naqanta in yaqgo disaipel a hi iydaq ham. Na ezaqgo in ya iqeman ya abeb iyaiq na ago ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Teq mat in ago kruse sorim ya imuzim a hi bolaqta na in yaqgo disaipel a hi iydaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ne ginad emiy ham. Ne gilikmanib mat araq bit tuwaznan haqad itureqmo in osad ago mani tinulindaq ham. Luweq ago mani siqim iyid in bit a hi waz bugdaq haqad ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ari mat na anad a hi em haseq in bit ago tituq teq kalik emeqmo tuhulosdaq ham. Huloseq in bit na a ta hi waz bugdaq ham. Sa mataw bunmo ahol waqad in mat na tibilawun daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ad in bilaq daqay, Mat kaqmo atuw haiqta haq daqay ham. In bit wazan eramta teq in a ta hi em bug haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Teq king araq in le king ta araq inaq bab tiqemnan haqad itureqmo in osad anad ulumad tuqosdaq ham. Osad in anad emeq bilaqdaq, Yaqgo mataw bab emayta na in 10 tausen nazaq haqdaq ham. Ta yaqgo bab ko in ya iquriyamim in ago bab mataw 20 tausen nazaq haqdaq ham. Ya maror ko ago dauh nenaq bab emeq tiginol bugdaiq o haiq? haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Haqad in ago zaway loyinsa biyab a hi iyid in ago bab na danib pesanmo bolsa in amen gamuk emid ameb lehid in bulondaq, Bab o tob iyan haqdaq ham. Ya ezaq tonid teq bab ka hiqiysa i zib alowab osam? haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ad Yesus bilam, Na nazaqmo ham. Ne gigo nagah bunmo gileh a hi ugeq ne yaqgo disaipel a hi iy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kamis in nagah araq dimunta ham. Teq in agon tihiqiyid i ezaq tonid teq kamis na agon inaq ta iydaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kamis agon hiqiyta na akabiyan haiqta ham. I kabiyab hunegid in didaq emid anonon a hi gwaldaq ham. Ad i bulmakau abekoq inaq buliyeq ay abeqarib emid in ay na emid anon a hi emdaqmo ham. Kamis nazaqta akabiyan haiqta na i hunegan lehaqta ham. Mat aw nog in gidek nan huritgo usaqta na in gamuk ka hurit kemiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ari kam ta araqab mataw takis waqayta na teq mataw daq meqinta emayta na kabemmo in Yesus ago gamuk huritnan haqad agerab tubol yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bolsa Farisi giyogniz mataw Moses ago gunun hurit kemiyta na nenaq in nazaq gibiyad in Yesus wadad anan bilaq yaqay, Mat ko in mataw daq meqinta emayta kogan agem dimunta negad nenaq didaq neqaqta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","In nazaq haqsa Yesus gamuk awowun araq kazaq gibilan, ");
INSERT INTO mlp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ne gilikmanib mat araq in ago sipsip 100 nazaq giwamuzad luwsa ta araq nabag lehid teq mat na le a hi nagundaq e? ham. Haiq ham. In ago sipsip 99 na gihulosid nab tursa in sipsip amulikmo nabag lahta na naguneq tilehdaq ham. Nagunad luweq le in ahol tuwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ahol waqad in waqeq abetarib emeq in anad dimniysa soreq ad tuboldaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","A boleq in ayogniz bunmo gibilenid bo humab woleq ossa teq in gibilendaq, Yaqgo sipsip araq nabag lehan ya nagunim le tuway haqdaq ham. Ne bolid ya nenaq ginad dimniysa osuq haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Teq ya ne gibilenaiq ham. Daq nazaq Heven-ib usaqtamo haqaiq ham. Mat daq meqinta emad luwaqta amulikmoqmo in anad buliyeq ago daq meqinta na gileh ugsa Heven-ib God ago dauh nenaq in mat na anan ginad ayahmo dimniyayta ham. Ari on mataw kabemmo ginad emay, I giholib daq araq meqinta i gileh ugamta haiqgam haqayta na God ago dauh nenaq in mataw kabemmota na ginan ginad a hi dimniyayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ari ne gilikmanib aw araq ago mani silva 10 nazaq usid in araq nabag hunegeq teq in a hi nagundaq e? ham. Haiq ham. Aw na lam midereq in ago bitab saw wolrironad mani na nagunad luweq le in ahol tuwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ahol waqeq in ayogniz teq in ago uliq araqibta bunmo gibilenid bo humab woleq ossa teq in gibilendaq, Yaqgo mani araq nabag tuhuneg hayta na ya nagunim le ahol tuway haqdaq ham. Ne bolid ya nenaq ginad dimniysa osuq haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Teq ya ne gibilenaiq ham. Daq nazaq Heven-ib usaqtamo haqaiq ham. Mat daq meqinta emad luwaqta amulikmoqmo in anad buliyeq ago daq meqinta na gileh ugsa Heven-ib God ago angelo in mat na anan ginad ayahmo dimniyayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Haqad Yesus bilam, Mat araq atatniz giger nenaq tuqosiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Osad atatin araq amikta na in amam bulon, Kabay ham abeb ni tumoqid ya ningo nagah asor ya ibab inaq waqamta na muranmo ni yaqmenta na yag ham. Haqan amam in ago nagah bunmo huserim atatniz giger na tinag ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Negan sisaq haiq atatin amikta na in ago nagah bunmo giwaqim a lehim saw araq pesantab tuqos ham. Osad in daq haresmo emad ago mani haresmo tuhunegyaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","In nazaq emad luwsa ago nagah bunmo tihiqiy bug ham. Hiqiy bugan teq zarow ayahta saw nab tugwahtim ham. Gwahtiqan in aholib nagah araq diq haiqgam iyan in agemnan tumoqyaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nazaq iyan in lehim mat araq saw nabta ago hib kabiy wam ham. Waqan kabiy anamren mat na eman lehim in ago bul gelibta giwamuzad osyaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Osad in agem moqsa anad tiqemyaq, Bul itez neqayta ko asor ya neq nagta haqyaq ham. Haqsa teq haiq ham. Mat araq in ulumsiheq didaq araq a hi ugyaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","In nazaq meqin diq osad anad emwirad osim teq in tibilam, Ya imamgo kabibiy mataw gigo didaq kabemmo iysa in a hi neq bugayta haqad in bilam ham. Sa ya kab osad igemnan tumoqaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nab iysa ya eraqeq muleqeq imam ago hib ta lehdaiq haqad in bilam ham. Leheq ya imam bulondaiq, Kabay haqdaiq ya daq meqinta ningo hib emim ya God ago hib em tonmo haqdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya ningo amun dimunta a haiq haqdaiq haqad in bilam ham. Muran ni ya inan ‘yaqgo amun’ haqad ta hi bilaq haqdaiq haqad in bilam ham. Ni ya iqemid ya ningo kabibiy matmo araq iyiq haqdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Haqad in eraqim amam ago hib muleqim ta lah ham. Lehsa amam osim atatin pesanmo danib bolsa in ame le ahol tuwam ham. Ahol waqad in ago amun anan anad ayahmo diq meqniysa in sibim lehim atatin wazim ay netim tiqilawun ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ilawunan ago amun na bilam, Kabay ham ya daq meqinta ningo hib emim ya God ago hib em tonmo haqad in bilam ham. Ya ningo amun dimunta a haiq haqad in bilam ham. Muran ni ya inan ‘yaqgo amun’ haqad ta hi bilaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Haqan haiqgam ham. Amam era ago kabibiy mataw gibilenim bilam, Ne yaqgo tubusan dimun diqta naqmo waq a boleq ya itatin ka ayon wel ugiy haqad in bilam ham. Ad ring araq aben akurganib em ugad teq gisendugan asenab em ugiymo haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Em ugeq teq ne le bulmakau amidon anon ayahta naqmo waq a boleq wol emeq oyiy haqad in bilam ham. Oyid i inaq neqad ginad dimniysa osuq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Na ezaqgo ham yaqgo amun ka tumomta teq muran in kayeq ta iy haqad in bilam ham. In nabag tilahta teq muran i ahol a ta waqauq haqad in bilam ham. Haqad in atatin na ayon humab ayahta tiqemiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","In humab emim ossa mat na atatin ayahta na kabiyab luwim tubol ham. Bolim bit agerab tugwahtiqadmo in mataw itiy wolad dorsa gihulan tuhurit ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Huritad in kabibiy mat araq bulonan bolan tisusumun ug ham. Ko ezaq tonay? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Haqan kabibiy mat na bulon, Ni nimikqan muleqim tubol haqad in bulon ham. Bolan ni nimam bulmakau amidon anon ayahta na wol emim oy haqad in bilam ham. Na ezaqgo ham in ago amun nabag lahta na in a ta wam haqad in bilam ham. Waqan in ago amun na afaqan araq a hi waqim in dimunmo osaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kabibiy mat nazaq haqan atatin aqenta na agem timeqniy ham. Agem meqniysa in bit aduganib lo gwahtiqnan atuw tihiqiy ham. Atuw hiqiysa in bit asan ban tursa amam asanib gwahtiqim anad waqad gamuk dimunta tubulonyaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bulonsa in amam ago gamuk amenin emim bilam, Ulig kabemmo ya iholtuw bulad ningo kabiy emad teq ya amenin araq ahol a hi way haqad in bilam ham. Ya kam araq diq niqez a hi othasta haqad in bilam ham. Ta teq ni memeq amidon araq diq yagan yaqmo igo kadoyniz nenaq oyim humab wolim i ginad dimniysa a hi os haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ari ningo amun na in ningo nagah bunmo on danatabta gigo hib huneg bugim tihiqiyan in muleqim ta bolan ni ninad ugad bulmakau amidon anon ayahta na tuwol em ug haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Haqan amam bulon, Ya itatin ham tutimmo i giger araqibmo osauqta haqad in bilam ham. Ad yaqgo nagah bunmo in ningota haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Teq muran i humab woleq ginad dimniysa tuqosamta haqad in bilam ham. Na ezaqgo ham ni nima ka tumomta teq in kayeq ta iy haqad in bilam ham. I bilaw in nabag tilah hawta teq in muleqim ta bolan i ahol a ta waqauq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ari Yesus in ago disaipel gibilan, Mat araq ago es nagah kabemmota in os ham. Ossa in ago kabibiy mat gibunibta araq ago kabibiy mataw giwamuzyaqta na in osmo ham. Ossa mataw asor bolim mat ayahta na tubuloniy ham. Ningo kabibiy mat gibunibta na in ningo nagah abu ulumaq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Haqan mat ayahta na in ago kabibiy mat gibunibta na lilewunan agerab bolan in bulon, Ya nibin huritta na alulin in ezaq diq? haqad in bulon ham. Ni leheq yaqgo nagah bunmo nibenab usaqta na mar ton bug haqad in bilam ham. Mat ni yaqgo kabiy a ta hi wamuzdaq haqad in bilam ham. Ya ningo kabiy na nibenab tuwalemaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","In nazaq haqan kabibiy mat gibunibta na anadibmo bilam, Yaqgo ayahta kabiyab ya tiqimuzaq haqad in bilam ham. Ya teq ezaq tondaiq? haqad in bilam ham. Ya kabiy afaqanta emgo igo zaway haiqgam haqad in bilam ham. Ad ya didaqnan sunnan imebay woqaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","In anad nazaq emwirad osim teq in bilam, Ari ya inad tiqem haqad in bilam ham. Ya iholyon dante wastitayid teq yaqgo ayahta imuzid mataw asor gigem dimunta yagad in gigo bitab iqad tileh daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","6","Nazaq haqad in mataw in ago ayahta ago hib nagah waqan amenin in gigo hib usaqta na amulik-mulikmo gililewunan tubol yaqay ham. Bolsa mat araq ameb bolan in tisusumun ug, Ni yaqgo ayahta ago nagah wamta na amenin ganim diq ningo hib usaq? haqad in bilam ham. Haqan mat na bilam, Masil arebnaq aseseq diqta na 100 nazaq usaqta haqad in bilam ham. Haqan kabibiy mat gibunibta na bulon, Ni nagah wamta ago sansandek waqeq hidmo 100 na suholeq abanab ni 50 nazaqmo mar ton haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","An abeb mat ta araq bolan in susumun ug, Ni nagah wamta na amenin ganim ningo hib usaq? haqad in bilam ham. Haqan mat na bilam, Wit aziynaq 100 nazaq usaqta haqad in bilam ham. An kabibiy mat gibunibta na bulon, Ni nagah wamta ago sansandek waqeq 100 na suholeq 80 nazaqmo ni mar ton haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ari abeb mat ayahta na in daq na ago tuhuritim in ago kabibiy mat amileq meqinta na abin tiqiluw ham. Na ezaqgo kabibiy mat na anad emim aholyon dante dimunta wastitayta na ago ham. Haqad Yesus bilam, Mataw og ka ago daq muzinayta na in on mataw God ago saw anuwanib osayta na giquriyamad in giyogniz nenaq gihol adanteqin anononmo wastitayayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nazaq iyan ya ne gibilenaiq ham. Ne og ka ago mani-ta amalib on mataw asor giqemsa in ne giyognizmo diq iyiy ham. Iyid teq abeb mani wazgo akaman hiqiyid ne giyogniz na in gigem dimunta negsa ne nenaq dimunmo kuluwa-kuluwmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mat nagah amikmikta anononmo wamuzaqta na in nagah aseseqta anononmo tuwamuzdaqmo ham. Ari mat nagah amikta akabiyan anononmo a hi emaqta na in nagah ayahta akabiyan anononmo a hi emdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ne og ka ago mani anonon a hi wamuzid ta nog in nagah helta negid ne wamuz daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ad ne mat araq ago nagah anonon a hi wamuzid ta nog in nagah araq negid ne gigo diq iydaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kabibiy mat araq in mataw aseseqta giger giqez a hi muzdaqta ham. In nazaq tonad luweq in araq agem meqinta ugad araq in agem dimunta ugdaq ham. Teq in araq anadin diq emad araq in gileh ugdaq ham. Nazaq iyan ne mani anadin diq emad ne God aqez a hi muzin daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ari mataw ginan Farisi haqayta na in mani anan ginad diq bilaq yaqayta. Nazaq iyan in gamuk bunmo Yesus bilamta na huritim in Yesus tibilawun yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Bilawunsa Yesus gibilan, Ne mataw kat negad gimeb daq titnonta emsa in ne ginan mataw dimunta haqayta ham. Teq God ne gimugan tuhurit kamta ham. Og ka ago nagah on mataw anan diq moqayta na in God ameb bilaqne nagah lilihad ahuran meqin diq iyad usaqta nazaq nog ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Haqad Yesus ta bilam, God ago maror Moses mar tonta na teq God ago nantut gamuk bilaqiyta na in kwaziqmo usim bo Jon mataw huz negyaqta na ago kamubmo iy ham. Teq Jon ago kamub iyim bo muran kawa ya God ago maror agamukan dimunta bilaqsa on mataw tuhuritay ham. Huritad in God ago gamuk kwaziqta na anadin a ta hi emad in bunmo God ago maror aduganib ginadibmo gwahtiqgo giwaz diq timeqniyay ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Teq ya kazaq ne gibilenaiq ham. Kait og inaq anadibmo tihiqiydaq e? ham. Haiqgam ham. Ad nazaqmo God ago maror Moses mar tonta na ago asit diq araq samanta iyeq a hikidik usdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Haqad Yesus bilam, Mat ago aw muzim aw ta araq muturta waqaqta na in bilaqne mat ta araq ago aw inaq luw nog iyaqta ham. Ad mat in aw araq kwaziqmo aduw muzan osta na waqeq na nazaqmo in bilaqne mat araq ago aw inaq luw nog iyaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Haqad Yesus bilam, Kwaziqmo mat araq ago nagah kabemmota in osyaq ham. Osad kam bunmo in tubusan dimdimunta kakaqta aholib emad in didaq dimdimunta neqyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sa in ago bit aqezab mat araq anaghan haiqta in osyaqmo ham. Mat na anan Lazarus ham. In ahol bunmo na asulanmo usyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ad in agemnan moqad in mat anaghan inaqta na didaq neqsa didaq aneglan ban ahaqenib woqsa ahol waqad anad emyaq, Ya didaq aneglan na asor neq nagta haqyaq ham. In nazaq anad emad ossa teq gaun boleq asulan mideq yaqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ari mat anaghan haiqta na nazaq emad osimmo tumom ham. Moqan God ago angelo waqim a le Abraham agerab eman tuqos ham. Ossa mat ago nagah kabemmota na inaqmo moqan tiyay toniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yay tonan in le mataw tumoqiyta gigo ban meqintab ahol titiysa osad in ame gwalehim Lazarus Abraham inaq pesanmo ossa tigibiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Gibiyad in lileyim bilam, Ya imam Abraham ham ni ya inan ninad meqniyan haqad in bilam ham. Ninad meqniysa ni Lazarus emid boleq aben akurgan yuw ulum tureq in yuw asitmo ya imileqib emid muditinan haqad in bilam ham. Ya faq kab santitiy ayahmo waqaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Haqan Abraham bilam, Amun ham ni ogib kayeqmo osad ni nagah dimdimunta niholyon giwaq bugyaqta haqad in bilam ham. Giwaqsa Lazarus nagah meqmeqinta waqyaqta haqad in bilam ham. Ari muran saw kab Lazarus anad dimniysa ossa ta ni nab osad ni nihol titiysa osaqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Teq nagah araqmo ham. Saw ni osaqta na teq saw kawa i osauqta ka gilikmanib akalhonan araq sisaqta abe milhasta usaq haqad in bilam ham. Nazaq iyan mataw kab osayta ka in nab lehgo dan haiqgam haqad in bilam ham. Ad mataw nabta na in kab bolgo dan haiqmo haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Haqan mat na bilam, Ari ya imam ham nazaq iyan ni Lazarus emid muleqeq in ya imam ago uliqab ta lehan haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Leheq in ya imaqbaban abaynaginmo osayta na gidek wazad gamuk awaz meqinta gibilenan haqad in bilam ham. Luweq in ginad a hi buliyeq in inaqmo saw santitiy ayahmo usaqta kab tubol daqaymo haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Haqan Abraham bilam, Ni nimaqbaban na in God ago maror Moses bilamta na teq God ago nantut gamuk mar toniyta na in wazayta haqad in bilam ham. In gamuk naqmo huriteq teq in ginad buliyiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Haqan mat na bilam, Ya imam Abraham ham na haiqgam iydaq ham. Ya imaqbaban gamuk na huritad anan helmo a hi haqayta haqad in bilam ham. Ari mat momta araq hodhodab eraqeq le gibilenid teq in ginad buliyeq gigo daq meqinta gileh tuqug daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Haqan Abraham bulon, Ni nimaqbaban Moses ago gamuk teq God ago nantut gigo gamuk na huritad anan helmo a hi haqeq in mat araq hodhodab eraqdaqta na ago gamuk anan helmo a hi haq daqaymo haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ari Yesus ago disaipel gibilan, Daq hihiq on mataw ginad hureqsa in ginad helta hulosayta na teq gwahtiqdaqta ham. Teq on mataw daq hihiq nazaq em daqayta na timeqniy has daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ya ne gibilenaiq ham. Mat naqanta in yaqgo onmin amikmikta no gigo araq emid in anad ya inan helmo haqaqta na hulosnan tonid mat na in yaqgo faq meqin diq tuwaqdaq ham. Na in kwaziqmo gig araq ayahta anatgumnib am wazeq kamismeb huneg nagiyta ham. Hunegid mat na moqeq daq meqinta na a hi emeq in yaqgo faq meqin diqta na a hi waq nagta ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Haqad Yesus bilam, Ni nimaqbab araq daq meqinta emid ni wad ham. Wadsa in anad buliyeq ago daq meqinta na gileh ugid ni ago daq meqinta na walemad anadin ta hi em ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ari ni nimaqbab na kam amulikmo aduganib ame 7 nazaq nimeqin tonad teq in ame 7 nazaq ningo hib boleq ninaq an aben wazgo nibilensa ni hi hulos ham. Ni ago daq meqinta na bunmo walemad anadin ta hi em ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ari disaipel in Iyahta bulonim bilaqiy, Ni i ginad God anan helmo haqauqta na emid ayahmo iyan haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Haqan Iyahta gibilan, Ne ginad helmo haqayta na in amik diq ay mastet anagin nog ussa teq ne ay araq buloneq bilaq daqay, Ni nibeqar teq nininin bunmo titeqeq ad leheq kamismeb woq haqid in nazaqmo ne giqez na tumuzindaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","Haqad Yesus bilam, Ne gilikmanib mat araq ago kabibiy mat in kabiyab og wolad luweq o in sipsip giwamuzad luweq in muleqeq bitab ta bolid ago ayahta na buloneq bilaqdaq, Ni sibeqmo bo osad didaq neq nazaq in a hi bulondaq ham. Hikidik ham. Mat ayahta na in ago kabibiy mat na kazaq bulondaq ham. Ni yaqmen didaq oy haqdaq ham. Ad ni nihol wastitayeq ya ibaq tunsa ya didaq neqeq yuw uluwid teq ningo abeb neq haqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ne ginad ezaq emay? ham. Kabibiy mat na in anamren aqez muz bugid anamren in abin tiqiluwdaq haqad ne ginad emay ye? ham. Haiqmo diq ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ad ne nazaqmo God ne gibenab kabiy amta na ne em bugeq teq ne ginad kazaq emiy ham. I kabibiy mataw gibin haiqta haqiy ham. I gigo kabiy i emamta naqmo kawa i tiqem haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ari Yesus uliq Jerusalem-ub wolehad luwim in saw giger Samariya teq Galiliy gilikmanib tugwahtim. ");
INSERT INTO mlp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Gwahtiqim in danib lehad luwim le uliq araqab tugwahtiqanmo mataw 10 nazaq gigo moq lepra inaqta bolad luwim in Yesus danib bolsa ahol tuwaqiy. Ahol waqad in pesanmo turad lileyim bilaqiy, Yesus haqiy ni mat ayah diqta haqiy ni i ginan ninad meqniyan haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Haqan Yesus gibiyad gibilan, Ne gihol ad leheq mataw tamaz emayta na giqisihuniy ham. Haqan in Yesus aqez muzim danib teqmo lehadmo in bunmo gihol tidimniyiy. ");
INSERT INTO mlp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Gihol dimniyan in gilikmanib mat amulikmo ahol loyinim in muleqim Yesus agerab ta bol. Bolad in dedibmo God abin tiqiluwyaq. ");
INSERT INTO mlp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","In bolim Yesus asen agerab ahol hulosan ogib woqim usad teq in Yesus esey tuqugyaq. Ari mat muleqim bolta na in saw Samariya-ib matta araq. ");
INSERT INTO mlp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sa Yesus mat amulik naqmo ahol waqad bilam, Ya bilay mataw 10 nazaqmo gihol tidimniyiy hayta ham. Mataw ta asor na edowa? ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nagaqgo yaqmo isenlul araq diq muleqim bolim God esey a hi ugaq? ham. Sa mat saw araqabta kaqmo bolim God esey ugaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Haqad in mat na bulon, Ni eraqeq leh ham. Ni ya inan helmo hamta naqmo niwastitayan ni tidimniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ari kam araqab Farisi asor Yesus susumun ugim bilaqiy, Kam gineh teq God ago maror boldaq? haqiy. Haqan Yesus amenin emim bilam, Muran God ago maror ayawalan inaq bolsa on mataw gimeb ahol a hi waqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Teq in bolsa mataw ahol waqad bilaq daqay, “God ago maror kab usaq” o “God ago maror kob usaq” haq daqay nazaq a haiqmo ham. Na ezaqgo ham God ago maror ne gilikmanib tubolim usaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Haqad in ago disaipel gibilan, Abeb ne sirisirimo gihol buloneq bilaq daqay, Mat Atatin hidmo ta bolid i inaq ta osuq haq daqay ham. Teq haiq ham. Ne kam na hidmo ahol a hi waq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mataw ne gibileneq bilaq daqay, Kazaq bo saw waqiy haq daqay ham. Kozaq le saw waqiy haq daqay ham. Haqsa ne gimuzeq nenaq hi lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Na ezaqgo Mat Atatin in mataw gime titoneq a hi boldaq ham. In ta boldaqta na in bilaqne mewlig kaitab hikliyanim anuwan saw bunmo waqaqta nazaq nog in boldaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ari nagah na hidmo a hi gwahtiqdaqta ham. Haiq ham. Nagah na a hi gwahtiqsa Mat Atatin santitiy waqsa mataw muran kam kab osayta ka gileh tuqug daqay ham. Gileh ugid kam abebag teq nagah na tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nowa akamnib mataw daq em yaqayta nazaqmo Mat Atatin ta boldaqta na akamnib daq nazaq usdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nowa akamnib mataw didaq neqad yuw uluwad an waqad ossa le Nowa muy aduganib tugwahtim ham. Gwahtiqan uq ayahta na hitiqim on mataw na bunmo gimeqin ton ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ari Lot ago kamub mataw nazaqmo em yaqayta ham. In didaq neqad yuw uluwad nagah gizayad kabiyab didaq leyad uliqab bit giqemad os yaqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ossa Lot uliq Sodom hulosim lehsa kam nabmo faq gig afanfanta inaq kaitab urom nog woqim on mataw na ginoyan tumoq bugiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ari Mat Atatin ulalab ta boldaqta nab daq nazaqmo diq tugwahtiqdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kam nab mat bit ahuqunib ban osnanta nab oseq in ogib hitiqeq tukeq lehad in ago es bit aduganib usaqta na le hi waqan ham. Ad nazaqmo mat kabiyab luwdaqta na in muleqeq ago bitab ta hi lehanmo ham. Luweq ne uliqabmo ossa afaqan ayahta na gwahtiqeq mataw gadgadmo osayta na gimeqin tonad in ne inaqmo gimeqin tondaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ne Lot awe awagamun anadin emiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","On mataw og ka ago es nagah waz naqmo hiqiyayta na in nazaqmo timeqniy daqay ham. Ari on mataw og ka ago nagah na hulosad anadin diq a hi emayta na in dimunmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ya ne helmo gibilenaiq ham. Taromab mataw giger ban amulikmo garabmo us daqay ham. Ussa in araq waqad araq in hulosid nab usdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ad on giger wit anagin wolworad mel emad os daqay ham. Ossa in araq waqad araq in hulosid nab osdaq ham.  ");
INSERT INTO mlp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ad mataw giger leheq kabiyab luw daqay ham. Luwsa in araq waqad araq in hulosid nab luwdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Haqan disaipel Yesus tisusumun ugiy, Iyahta haqiy daq na uliq edob diq gwahtiqdaq? haqiy. Haqan Yesus gibilan, Kam nab daq na gwahtiqsa ne a hi nagun daqay ham. Ne gamuk araq mataw bilaqad luwayta ka anadin emiy ham. In bilaqay, Karuw tumomta asan lilihim usaqta nabmo tirgaw bolim humab wolay haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ari Yesus in ago disaipel gibilenid in kam bunmo God inaq gamuk emad gituw a hi hiqiy daqay haqad in gamuk awowun araq kazaq gibilan, ");
INSERT INTO mlp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Uliq araqab megistret araq os ham. Osad in God anan a hi rabad teq in on mataw ginadin diq a hi emyaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sa uliq nab aw araq waburta in osad teq tuteqmo in megistret na ago hib boleq bulonyaq, Yaqgo bab samanta imeqin tonaq haqyaq ham. Ni hazizirib teq yaqgo afaqan sorad yaqmen daq titnonta em yag haqyaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Haqsa megistret hulosyaq ham. Hulossa aw na sirisirimo bulonsa iyan abeb megistret na inmo ahol bulonim bilam, Ya God anan a hi rabaiqta haqad in bilam ham. Ad ya on mataw ginadin diq a hi emaiqtamo haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ta teq aw waburta ka kam bunmo ya ituw bulsa ya inamur asit a hi emaiq haqad in bilam ham. Nazaq iyan ya hazizirib ulumsiheq daq titnonta tiqem ugdaiq haqad in bilam ham. Luweq kam bunmo tuteqmo in bolad ya ituw bulsa ya ihol a hi bilaqdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Haqad Iyahta bilam, Ne megistret meqinta na ago gamuk hurit kemiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","God ago on mataw in gilumim aholyon giwamta na in zeqab teq taromab inaqmo God bulonsa in giqez huritad gimen daq titnonta a hi em negdaq e? ham. Haiqgam ham. Teq God in ago on mataw tigilumsihnan haqad agudan emdaq e? ham. Na haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ya ne gibilenaiq ham. God hidmo ago on mataw gimen daq titnonta tiqem negdaqta ham. Ari teq abeb Mat Atatin og kab ta boldaqta kam nab in on mataw asor God anan helmo haqad ossa gibiydaq o haiq, on mataw naqanta nabag tihiqiy bug daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Ari kam nab mataw asor ginad em yaqay, Igmo gimomo God ameb titnonim luw osauqta haq yaqay. Haqad in bilaq yaqay, Mataw ta asor ko in i nog a haiq haq yaqay. In nazaq ginad emsa Yesus gamuk awowun ka gibilenim bilam, Mataw giger God inaq gamuk emnan haqad Tempel-ib tugwalehiy ham. Mat araq na in Farisi ham. Teq araq na in mat abin meqinta takis waqaqta amatin ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi na aholbin turad in God bulonim bilam, O God ham ya mataw asor ko nog a haiq haqad in bilam ham. Ya a hi rin tonaiqta teq ya daq meqinta a hi emaiqta haqad in bilam ham. Ad ya aw tuwaqim teq ya aw araq inaq a hi luwaiqta haqad in bilam ham. Ya mat takis waqaqta ko nog a haiqmo haqad in bilam ham. Nazaq iyan ya esey diq tinigaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wik amulik-mulikmo ya ime gigermo ninadin emad didaq udinaiqta haqad in bilam ham. Ad ya nagah bunmo waqaiqta na huseran le humab 10 nazaq iyan ya humab amulikmo ni nigaiqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ari mat takis waqaqta na le pesanmo turad in ame Heven-ib a hi gwalehyaq ham. In afaqin kuh tonim turad anad meqniysa in aban wolim bilam, O God ham ya mat daq meqinta emaiqta haqad in bilam ham. Ni ya inan ninad meqniysa ilumsih haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Haqad Yesus bilam, Ya helmo ne gibilenaiq ham. Mataw giger na Tempel-ib osim gwahtiqim in gigo bitab tilehad in gilikmanib mat takis waqaqta naqmo in God ameb mat titnonta iy ham. Ari Farisi na teq haiq ham. Na ezaqgo on mataw in gimo gihol abin iluwayta na bunmo God in gibin wazid tuwoqdaq ham. Sa on mataw gihol abin wazan woqaqta na God in gibin wazid tiqeraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ari on mataw gigo onmin amikmikta teq susibta inaqmo giqad Yesus ago hib tubol yaqay, Yesus giwazad gidimun tondaq haqad. Teq haiq. In onmin giqad bolsa disaipel gibiyad ginadad tigimuz yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sa Yesus onmin na gibilenan agerab bolsa teq in ago disaipel gibilan, Ne onmin gihulosid yaqgo hib boliy ham. Ne hi giwasihiy ham. On mataw naqantaqmo God ago maror aduganib gwahtiqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya helmo ne gibilenaiq ham. Mat aw nog in onmin gibin haiqta ka nogmo iyad God ago maror ahaqenib a hi oseq in God ago maror na aduganib le a hi gwahtiq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ari mat marorta araq bo Yesus susumun ugim bilam, Tisa dimunta ham ya ezaq tonid teq God in ago os dimunta kuluwa-kuluwmo osayta na tiyagdaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Haqan Yesus bulon, Ni ninad ezaq emad ya inan dimun haqaq? ham. God amomo in dimunta ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Haqad in mat na bulon, Gunun bunmo Moses bilamta na ni tuhurit ham. Ni an alulib hureqeq inaq hi us ham. Ni mat araq wol emid hi moqan ham. Ni hi rin ton ham. Ni hazizirib mat araq hi kat ug ham. Ni ninenmaman giqez hurit ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yesus nazaq haqan mat marorta na bilam, Ya amunibmo osad gunun nagan bunmo muzim bolim muran ya mat ayah tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Haqan Yesus gamuk na huritim in mat na bulon, Ni daq amulikmo emnanta a hi emaq ham. Ningo nagah bunmo gizayeq amenin waqeq teq ni mataw ginaghan haiqta gigo hib ibereq neg ham. Ni nazaq toneq teq Heven-ib ningo nagah kabemmo inaq iydaq ham. Ni daq na emeq teq ni ya imuzeq bol ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Haqan mat marorta na ago nagah kabemmo diq giqusta iyan in Yesus ago gamuk na huritim ahol afaqan tiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Anmo Yesus mat na ahol waqad bilam, Mataw gigo nagah kabemmo inaqta na in God ago maror aduganib gwahtiqgo afaqan diq ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Haqad in bilam, Karuw ayahta anan kamel haqayta na in nidel akwiyaknib le tugwahtiqdaq e? ham. Hikidik ham. An nazaqmo mat ago es kabemmo ginadin emaqta na in God ago maror aduganib le a hi gwahtiqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yesus nazaq haqan on mataw nab turiyta na huritim bilaqiy, Nazaq iyid teq mat araq diq le God ago os dimunta nab a hi gwahtiqdaqya haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Haqan Yesus gibilan, Mataw gigo zawayibmo le a hi gwahtiq daqayta ham. Teq nagah mataw emgo biyab a hi iyayta na God inmo emid tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Haqan Pita bulon, Ni i gibiy ham. I gigo og nagah bunmo gihulosim i ninmo nimuzim ninaq tilehauq ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Haqan Yesus in ago disaipel bunmo gibilan, Ya helmo ne gibilenaiq ham. Mat God ago maror aduganib gwahtiqnan haqad in ago aw teq amaqbaban teq anenmaman teq ago onmin gihulosta, mat naqanta og kab osad amenin ayah diqmo tuwaqdaq ham. Ad abeb kam muturta nab teq in God ago os dimuntab gwahtiqeq kayeqmo kuluwa-kuluwmo tuqosdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ari Yesus in ago disaipel 12 na giwaqim giqad giholbinmo lehim teq in gibilan, Ne huritiy ham. Muran i Jerusalem-ub tugwalehauq ham. Gwalehid teq kwaziqmo God ago nantut Mat Atatin anan bilaqad gamuk mar toniyta na adan bunmo in aholib tugwahtidaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mataw in Mat Atatin wazeq mataw en ta araq Juda a haiqta na gibenab tiqem daqay ham. Emid teq in Mat Atatin bilawunad kamolmol ugad tukusluw ug daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kusluw ugad in wazeq woltitayad teq in wol emid tumoqdaq ham. Moqeq kam ezeqmanmo useq teq in kayeq iyeq ta eraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesus nazaq bilaqan in ago gamuk na disaipel ginadib ulal a hi iyyaq. Gamuk na alulin ulilemim usta iyan disaipel ginad a hi em has yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ari Yesus danib lehad in uliq ayahta anan Jeriko haqayta na sinsin tuqugim lehsa mat araq ame haiqta dan adekib nagah anan sunad osyaq. ");
INSERT INTO mlp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ossa on mataw dauh biyahta bo lehsa in gihulan huritad tisusumun nag, Ne gingan lehay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Haqan in buloniy, Yesus uliq Nasaret-ibta na bo tilehaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Haqan in dedibmo bilam, Yesus ham Devit atatin ham. Ni ya inan ninad meqniyan ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Haqan mataw danmeb leh yaqayta na in mat ame haiqta na wadad buloniy, Ni niqez hiqiy haqiy. Haqsa haiq mat ame haiqta na dedibmo lileyeq a ta bilaqyaq, Devit atatin haqyaq. Ni ya inan ninad meqniyan haqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Haqsa Yesus ahol wasihim nab titur. Turad in gibilan, Mat na waqeq ya igerab a boliy ham. Haqan in mat na Yesus agerab a bolan Yesus tisusumun ug, Ya ni ezaq nitondaiq? ham. Haqan in bilam, Iyahta ham ya saw ahol waqnan inad bilaqaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Haqan Yesus bulon, Ni nime hastitayan ham. Ni ya inan helmo hamta naqmo niqeman ni nime tidimniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Haqan muran diq nawaqmo mat na ame hastitayan in saw ahol tuwaqyaq. Saw ahol waqad in Yesus muzim inaq lehad in God abin tiqiluwyaq. Sa on mataw bunmo daq na ahol waqim in God abin tiqiluw yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ari Yesus le uliq Jeriko-ib tugwahtim. ");
INSERT INTO mlp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Uliq nab mat araq anan Sakiyus haqayta in os. Mat na in mataw takis waqayta gigo amebta teq in ago mani kabemmo diq usta. ");
INSERT INTO mlp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ari Yesus uliq nab gwahtiqim lehsa Sakiyus in ahol waq kemnan haqad turan haiq. On mataw kabemmo nab tursa in mat siqim diq iyim in Yesus ahol a hi waqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nazaq iyan in sibim ameb lehim ay fik araq regim teq ame woqsa tuqos. In anad am, Yesus dan kaqmo muzeq boldaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Haqad in ay alonib ossa Yesus bolad luwimmo in ame gwalim ahol waqadmo tubulon, Sakiyus ham ni hidmo gehitiq ham. Muran ya le ningo bitab ninaq tuqosdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Haqan Sakiyus hidmo gehitiqim in Yesus waqim inaq anad dimniysa ago bitab tilah. ");
INSERT INTO mlp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lehsa mataw gibiyad in bunmo gigem meqniysa bilaqiy, Mat ko abin dimun a haiqta haqiy. Nagaqgo Yesus inaq osnan haqad ago bitab tilehaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ari Sakiyus Yesus inaq bitab lehim osad teq in eraqim turad Iyahta tubulon, Iyahta ni hurit ham. Muran yaqgo nagah bunmo ya liqabmo uroteq asor na ya mataw ginaghan haiqta tinegdaiq ham. Ad ya mataw kat negim gigo nagah samanmo wayta na bunmo amenin nazaqmo ime aweweqmo tinegdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Haqan Yesus bulon, Ni Abraham asen muzim ni inaqmo God anan helmo haqan iyan muran God tiniwam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Haqad in bilam, Mat Atatin in mataw God gileh ugim ginadibmo haresmo nabag luwayta naqmo ginaguneq ta giwaqnan haqad bolta ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ari Yesus le uliq Jerusalem sinsin diq tuqugsa iyan mataw biyahta na ginad tiqem yaqay, Muran diq kam kabmo God ago maror ulal tiqiy bugdaq haq yaqay. Nazaq iyan mataw na Yesus ago gamuk huritad ossamo in gamuk awowun ta araq kazaq gibilan, ");
INSERT INTO mlp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mat ayahta araq saw araq pesantab king ayah diqta ago hib lehnan anad tiqam ham. In leheq maror na abenab zaway waqeq teq in muleqeq ta boleq king na aqumnib in ago walmataw tigiwamuzdaq haqadmo in tilah ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Lehad in ago kabibiy mataw 10 nazaq gibilenan bolan in mat amulik-mulikmo 20 kina nazaq tinag ham. Negim in gibilan, Ya le luwsa igilehnib ne mani ka amalib kabiy emsa le ya muleqeq ta boldaiq haqad in bilam ham. Haqadmo in tilah ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lehsa mat ayahta na ago on mataw uliqabta na in mat na anan ginad a hi bilaqan in mataw asor giqeman uliq pesanta nab sibim ameb lehim in king na tubuloniy, Mat na i giwamuzgo i hulosauq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ari mat ayahta na abeb lehim king abenab zaway tuwaqim teq in muleqim ta bol ham. Bolim in ago kabibiy mataw na gimen nan eman tilah, in mani nagta na akabiyan emim amenin ganim amalibmo a ta waqiyta na in huritnan haqad ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Haqan kabibiy mat araq ameb bolim bilam, Iyahta ham ni mani yagta na amalib ya kabiy emim 200 kina nazaq a ta way haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Haqan in ago ayahta bulon, Esey ham. Ni kabibiy mat dimun diqta haqad in bilam ham. Ni ya inad muzim kabiy anononmo emim ni nagah amikta na alowan diq tonta haqad in bilam ham. Nazaq iyan ya uliq 10 nazaq nigid ni in gigo maror iyeq tigiwamuzdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","An kabibiy mat ta araq bolim bilam, Iyahta ham ni mani yagta na amalib ya kabiy emim 100 kina nazaq a ta way haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Haqan ago ayahta bulon, Ari ya uliq abaynagin nazaq nigid ni in gigo maror iyeq tigibiy muzdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","An kabibiy mat ta araq bolim bilam, Iyahta ham ni mani yagta na kawa haqad in bilam ham. Ya ningo tuhuritta haqad in bilam ham. Ni mat afanfanta kamolmol a hi emaqta haqad in bilam ham. Nagah ni akabiyan a hi amta naqmo ni niholyon waqaqta haqad in bilam ham. Ad didaq ni a hi layta naqmo ni niholyon tayim anon waqaqta haqad in bilam ham. Nazaq iyan ya nirabunim ningo mani tubusanib il tonim eman us haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Haqan in ago ayahta bulon, Ni kabibiy mat meqin diq haqad in bilam ham. Ni ya inan bilam, Ni mat afanfanta haqad ni bilam ham. Ad ni ya inan bilam, Nagah ni akabiyan a hi amta na ni niholyon waqaqta haqad ni bilam ham. Ni bilam, Didaq ni a hi layta na ni niholyon tayaqta haqad ni nazaq ya inan bilam ham. Ni gamuk nawa bilamta naqmo amalib ya ningo daq tuqulum kemdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Doq tonnan ni yaqgo nazaq huritim teq ni yaqgo gimeq na mani abitnib eman a hi us? haqad in bilam ham. Usid teq ya muleqeq boleq yaqgo gimeq na amenin mani ayahmo inaqmo waq nagta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Haqad mat ayahta na in mataw nab turiyta na gibilan, Ne mat atuw haiqta na abenab 20 kina in wazaqta na waqeq mat ago 200 kina inaqta na ugiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Haqan mataw na bilaqiy, Iyahta haqiy mat na ago 200 kina inaq tiqiy haqad in bilaqiy ham. I mani araq na a ta ug tonam e? haqad in bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Haqan mat ayahta na bilam, Ya ne gibilenaiq haqad in bilam ham. Ya on mataw gigo nagah inaqta na bunmo nagah asor a ta negdaiq haqad in bilam ham. Teq ya mataw ginaghan haiqta na gibenab nagah asitmo in wazayta na walem bugdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Teq ya ibabun mebmebmo ya inan bilaqiy, Mat ka i giwamuzgo hulosauq haqiyta na ne giwaqeq giqad kab boleq ya imeb ginol emid moq bugiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ari Yesus gamuk na bilaqim tihiqiyan in saw na hulosim ago disaipel nenaq uliq Jerusalem-ub tugwalehiy. ");
INSERT INTO mlp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Gwalehad in uliq giger Betfage teq Betaniy gigerab garah Oliv asenab tugwahtiqiy. Gwahtiqim Yesus in disaipel giger giqeman danmeb lehsa in gibilan, Ne le uliq kob gwahtiqeqmo donki amidon araq am wazan tursa ne ahol tuwaq daqay ham. Donki na mat araq in amalib asit a hi luwta ham. Na ne haseq kab a boliy ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Sa mat araq na ago susumun negeq bilaqdaq, “Nagaqgo ne donki na aqamun hasay?” haqid ne kazaq buloniy ham. Iyahta ago kabiy inaq iyan haqad ne buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Haqan in giger lehim nagah bunmo Yesus anan bilamta nazaqmo in ahol tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ahol waqad in donki na aqamun hassa donki anamreniz tisusumun negiy, Ne giger nagaqgo donki na aqamun hasay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Haqan in bilaqiy, Iyahta ago kabiy inaq iyan haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Haqad in donki waqim ad Yesus ago hib muleqim tuboliy. Bolim in gigo tubusan asor donki amalib emim teq in Yesus bulonan donki amalib tuqos. ");
INSERT INTO mlp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ossa on mataw gigo tubusan danib gihurensa teq Yesus donki amalib osim tubusan na bayim bayim tilah. ");
INSERT INTO mlp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","In le Jerusalem sinsin tuqugad dante garah Oliv ban gewoqayta nab in tugwahtiqiy. Gwahtiqanmo on mataw dauh biyahta Yesus muzim inaq leh yaqayta na in Yesus daq azawayin inaq emyaqta nagan ginadin emad in ginad dimniysa dedibmo God abin tiqiluw yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iluwad in bilaq yaqay, I gigo king ka Iyahta abinib bolan i ginad bilaq gigayinaq haq yaqay. Muran God nob igsa i dimunmo afaqan haiqmo tuqosam haq yaqay. I God abin sorid ulilibmo diq gwalehan haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Haqsa Farisi asor on mataw biyahta na gilikmanib turim in Yesus buloniy, Tisa haqiy ningo disaipel gibilenid giqez hiqiyiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Haqan Yesus amenin emim gibilan, Ya ne gibilenaiq ham. I nagah ka ulilemamta abanan haiq ham. Mataw ka giqez hiqiyid gig haresmo kagab usayta ka in giqez inaq iyeq tililey daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Haqad Yesus bo Jerusalem-ub tugwahtiqnan tonad in uliq na ahol waqad tigaqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Gaqad in uliq na anan bilam, On mataw Jerusalem-ubta ham ne gime haiqta ham. God ne nenaq an anobun wastitaynan tonsa ne ahol a hi waqay ham. Na ne ahol waqeq teq ne dimunmo os nagiy ham. Teq muran nagah na ulilemim ussa ne ahol a hi waqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Helmo diq ham. Abeb teq kam ta araq tugwahtiqdaq ham. Gwahtiqid ne gigo bab boleq gel ne gigo uliq lilut ugim turaqta nab in og tayeq humab emeq in og na bayeq bayeq gwaleheq ne gigo uliqab tugwahtiq daqay ham. Gwahtiqadmo in gigo asor gililut negad saw bunmo ne gitawanan tur daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Turad in ne teq ne gigo onmin nenaqmo tiginol em bug daqay ham. Ad in ne gigo uliqab gig an amalib usayta na wolzizilayid tiq bug daqaymo ham. Na ezaqgo God ne gigo hib bolim nenaq osta na ne ginad a hi em hasiyta na ago ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ari Yesus lehim Tempel agelin aduganib gwahtiqim in mataw nagah gizayad osiy na gimuzan in tukim asan ban tileh yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Lehsa in gibilan, God ago marib in gamuk araq kazaq bilam ham. Yaqgo bit in ya inaq gamuk emgo abitan iydaq haqad in bilam ham. Ta teq ne bit ka eman in mataw rin tonayta gigo bit nog tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ari kam bunmo Yesus Tempel agelin aduganib mataw suleq tinegyaq. Sa mataw tamaz emayta gigo aseseqta na giyogniz mataw Moses ago gunun hurit kemiyta na nenaq teq Juda gigo mataw marorta na in bunmo Yesus wol emid moqgo adanteqin tinagun yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Teq haiq. On mataw bunmo Yesus ago gamuk huritnan zaway diq iysa mataw aseseqta na dante araq ahol a hi waq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kam araqab Yesus le Tempel agelin aduganib osad in on mataw God ago gamuk tigibilenyaq. Gibilensa mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na teq mataw marorta asor in Yesus ago hib tuboliy. ");
INSERT INTO mlp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bolim in Yesus susumun ugiy, Ni i gibilen haqiy. Ni nibin ezaqta iyim ni daq kagan emaq? haqiy. Teq nog diq nibin na nig? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Haqan Yesus amenin emim gibilan, Ta ya nazaqmo nagah araq ago ne tisusumun negnan ham. Ne ya ibileniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon mataw huz negyaqta na ago kabiy Heven-ib bol o haiq in matawmo gigo hib kabiy na wamta? ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Haqan mataw aseseqta na in gimo an bulonim bilaqiy, I bilaqam, Kabiy na Heven-ib bolta haqid in bilaqdaq, Ta nagaqgo ne Jon ago gamuk huritim anan helmo a hi haqiy? haqdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ari i bilaqam, Kabiy na matawmo gigo hib bolta haqid on mataw bunmo i gimalib gig tuhuneg daqay haqiy. Na ezaqgo in bunmo ginad awaz timeqniyim Jon anan bilaqay, Hel diqtaqmo in God ago nantut araq haqayta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nazaq iyan in Yesus ago susumun na amenin emim bilaqiy, I a hi hurit haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Haqan Yesus gibilan, Ya nazaqmo ham. Nog ibin yagan ya daq kagan emaiqta na ago ya a hi gibilendaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ari Yesus on mataw gamuk awowun ka gibilenim bilam, Mat araq am wain anagin kabemmo og araqab tilay ham. Leyim in wain na akabiyan mataw asor gibenab tiqam ham, in gimo giholyon kabiy emad teq in wain anagin asormo ya yag daqay haqad ham. In kabibiy mataw gibilenim hulosad era uliq araq pesantab lehim kam sisaqmo in nab tuqos ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Osad wain anagin waqgo akaman tugwahtiqan in ago kabibiy mat araq eman mataw wain akabiyan emayta na gigo hib tilah ham. In lehid mataw na yaqmen wain anaginta na tuqug daqay haqad ham. Teq haiq ham. Kabibiy mat na lehan mataw wain akabiyan emayta na in wazim woltitayim muzan samanmo muleqim tilah ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Lehan kabiy anamren in kabibiy mat ta araq eman tilah ham. Lehan na nazaqmo in wazim woltitayad nan meqinta ugad teq in muzan samanmo tilahmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","An in kabibiy mat ezeqmanta eman lehan na in wazim wolan anedan woqsa in kabiy asan ban hunegan tilahmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","In nazaq eman kabiy anamren bilam, Teq ya ezaq tondaiq? haqad in bilam ham. Ya itatin amulikmoqmo ya anan inad diq bilaqaqta naqmo ya emid tilehdaq haqad in bilam ham. Nabag in lehid teq kabibiy mataw na in aqez tuhurit daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Haqad in eman lehan mataw kabiy wamuzayta na in bolsa ahol tuwaqiy ham. Ahol waqad in gimo an bulonim bilaqiy, Abeb mat ko amam moqid in amam ago ahuran nagah bunmo tuwaqdaqta haqiy ham. In bolid i wol emuq haqiy ham. Wol emid teq amam ago kabiy ka igmo gigota tiqiydaq haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Haqad in mat na wazim kabiy asan ban hunegan lehan in wol eman tumom ham. Nazaq iyan kabiy anamren in mataw wain akabiyan wamuzayta na ezaq gitondaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","In boleq mataw kabiy wamuzim osayta na ginol em bugad teq in ago kabiy na mataw ta asor gibenab tiqemdaq ham. Haqan mataw nab turiyta na ginad emim bilaqiy, Haiq kidik! haqiy. Kabiy anamren nazaq hi eman haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Haqan Yesus gibiyad gibilan, Ne ginad nazaq emay ye? ham. Ta gamuk araq God ago marib usaqta ka alulin ezaqta? ham. Gamuk na bilam, Tituq mataw anan bilaqiy ‘meqin’ haqiyta naqmo in awaz meqin diq turad bit anon bunmo soraq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","An ya ne gibilenaiq ham. Mat aw nog tituq na amalib woqeq in giditin bunmo tuwolbiyay daqay ham. Ari tituq naqmo in mat araq amalib woqeq in mat na tuwol ninal bugdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Haqan mataw Moses ago gunun hurit kemiyta na teq mataw tamaz emayta gigo aseseqta na in ginad tiqem hasiy. Yesus i gibin wazid woqgo haqad gamuk awowun ka bilam haqiy. Haqad muran diq nabmo in Yesus wazeq irqurgo ginad emad teq in ta on mataw girabun yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nazaq iyan mataw aseseqta na in Yesus wamuz naqmo diq hiqiy yaqay. Ad in mataw asor giqeman lehim in katiyad Yesus ago gamuk huritnan haqad teq in wirinad luw yaqay. I Yesus kat ugid in gavman gigo gunun araq itiyonad nan araq hi bilaqnanta bilaqid teq i gavman abenab emid in hazizirib titurdaq haqad. ");
INSERT INTO mlp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","In nazaq haqad Yesus tubuloniy, Tisa haqiy i ningo tuhurit haqiy. Ni gamuk hel diqta amalib on mataw suleq negaqta haqiy. Ni mataw gibin inaqta a hi girabunaqta haqiy. Ad ni on mataw God ago dan titnonta giqisihunad ni gamuk hel diqmo gibilenaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ni ninad ezaq emaq? haqiy. I gibabun Rom gigo king Sisa in i gituw bulsa i takis ugauqta na in daq dimun o daq meqin? haqiy. I Juda gigo maror ezaq bilamta? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Haqan Yesus anad tiqam. Mataw ka tikat yagay ham. Haqad in gibilan, Mani araq iqisihunid ya ahol waqiq ham. Haqan in mani araq ugan ahol waqad bilam, Ka nog diq adulan teq ahol anan mani kab usaq? ham. Haqan in bilaqiy, Na Sisa-mo agota haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Haqan Yesus gibilan, Nazaq iyan Sisa ago nagah na ne Sisa-mo ugiy ham. Ad God ago nagah na ne God-mo ugiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ari Yesus ago gamuk bunmo dimunmo iyan mataw aseseqta na in on mataw gimeb Yesus waz daqayta ago adanteqin haiqgam tiqiyiy. Ad in Yesus ago gamuk huritim ginadnad emad giqezmo hiqiyim tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ari Sadyusi asor Yesus ago hib tuboliy. Mataw na ginad kazaq emayta. Mataw tumoqiyta hodhodab a hi eraq daqay haqayta. ");
INSERT INTO mlp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Na in bolim Yesus buloniy, Tisa haqiy, Moses i gimen gamuk araq mar tonim in kazaq bilam haqiy. Mat araq aw waqeq amun a hi emsamo moqid ago aw amomo ossa teq in amikqan araq abab aqoburan na waqeq alulib abab ayon onmin tigiqemdaq ham haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ari gamuk araq kazaq lahta haqiy. Mat araq amikqaniz nenaq 7 nazaq diq iyim osiy haqiy. Osim in gibab na aw araq tuwam haqiy. Waqim inaq amun araq a hi emimmo in tumom haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Moqan ama ta araq in abab aqoburan na wam haqiy. Waqim in amun haiqmo osim tumommo haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","An gima ezeqmanta na in aw naqmo wammo haqiy. Nazaqmo mataw maqbab 7 na in aw naqmo waqim amun araq eman a hi gwahtiqsamo in tumoq bugiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","An abeb aw na tumommo haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nazaq iyan abeb mataw bunmo hodhod huloseq eraq daqayta nab teq aw na in nog diq awe tiqiydaq? haqiy. Maqbab 7 na bunmo in aw amulik naqmo waqiyta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Haqan Yesus gibilan, Muran on mataw og kab osayta na in an waq agamukan wastitayim teq in an waqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ari on mataw God in gibiyan titnonta iyiyta na God in giwazid hodhodab eraqeq in ago maror aduganib gwahtiqeq tuqos daqay ham. Osad nab in an a ta hi waq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na ezaqgo in a ta hi moq daqayta na ago ham. In angelo nogmo iyeq tuqos daqay ham. God in hodhodab giwazan eraqan iyan in God atatniz tiqiyiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Teq God mataw tumoqiyta giwazid hodhodab eraq daqayta na ago Moses ne tigiqisihunmo ham. In ago marib ay amikta araq faq oyad a hi oyworta awagamun nab in gamuk kazaq mar tonim bilam ham. Iyahta in Abraham ago God, teq Aisak ago God, teq Jekob ago God haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nazaq iyan God in mataw moqim kayeqmo osayta gigo God iyim in gibiy muzaqta ham. Na ezaqgo mataw tumoqiyta teq mataw a hi moqayta inaqmo in God ameb kayeqmo osayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Yesus nazaq bilaqan mataw bunmo rabad in Yesus ulum waqnan a ta hi susumun ug yaqay. Nazaq iyan mataw Moses ago gunun hurit kemiyta na asor in Yesus buloniy, Tisa haqiy ni gamuk amenin bunmo dimunmo bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ari Yesus on mataw nab turiyta na gibilan, Ezaq haqad mataw bilaqay, Krais in Devit atatin haqayta? ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Devit Buk Song-ib gamuk araq mar tonim bilam, Iyahta in yaqgo Iyahta kazaq bulonim bilam ham. Ni ya iben iqabun ban kab ya imen emad ossa ya ningo bab giqemid nisen ahaqenib tiqiy bug daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ari Devit in Krais anan bilam, ‘Yaqgo Iyahta’ haqad in bilam ham. Nazaq iyan ezaq toneq Krais in Devit ago Iyahta iyeq teq in Devit atatin a ta iydaq? ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Haqad Yesus in on mataw bunmo gimeb ago disaipel gibilenim bilam, Ne mataw Moses ago gunun hurit kemiyta na ginan gihol waz naqmo hiqiyiy ham. In tubusan sisaqta giholib emeq mataw gimeb luwnan ginad bilaqaqta ham. Ad in maket-ib luwsa mataw gibiyad ginan ‘mat ayah’ haqsa in ginad diq dimniyaqta ham. Mataw na bit humab wolaytab ban ulilibta nabmo osnan ginad bilaqaqta ham. Ad in humab adidaqan inaqtab ogib garuruhab osnan hulosmo diq hulosayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Teq in on waburta kat negad gigo bit samanmo waqayta ham. Ad in mataw gimeb God inaq gamuk sisaqmo bilaqim a lehayta ham, mataw gibiyad ginan dimun diqta haq daqay haqad ham. God hazizir ayahta emdaqta nab teq mataw na in on mataw bunmo giquriyameq faq ayah diqmo tuwaq daqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ari on mataw gigo nagah kabemmo inaqta asor Tempel agelin aduganib bo gwahtiqad gigo naw hunegan mani emayta abanab woqsa Yesus in gibiyad os. ");
INSERT INTO mlp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ossa aw waburta araq anaghan haiqta bolim mani amikmikta giger hunegsa in ahol tuwam. ");
INSERT INTO mlp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ahol waqad in ago disaipel gibilan, Ya helmo ne gibilenaiq ham. Aw waburta ahol anaghan haiqta ko in mani amik diqta emim in on mataw bunmo gigo nawta na giquriyam bug ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Na ezaqgo mataw bunmo in gigo mani kabemmo usaqta na ago asitmo emiyta ham. Ari aw ko haiq ham. In ago mani in didaq zayeq neqdaqta na tiqem bug ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Ari mataw asor Tempel anan bilaqiy, Bit ko haqiy mataw gig dimdimunta amalib emim teq in mataw God naw ugiyta na anawun waqim amalib balaw tonan in awaqan dimun diq iyaq haqiy. Haqan Yesus bilam, Ne nagah dimdimunta ahol waqayta ko ago akaman gwahtiqid teq gig ko bunmo wolzizilayeq gihunegid tuwoq bug daqay ham. Gig an amalib usayta ko teq muruwoqeq tiqmo bug daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Haqan disaipel Yesus tisusumun ugiy, Iyahta haqiy kam gineh teq nagah ni anan bilamta na tugwahtiqdaq? haqiy. Naga daqin ameb gwahtiqsa i ahol waqad ginad emam, Nagah na gwahtiqgo akaman sinsin tiqiy haqam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Haqan Yesus gibilan, Ne gihol waz naqmo hiqiyeq osiy ham. Luweq mataw asor boleq kat neg daqay ham. Mataw kabemmo teq boleq ya inan biyad bilaq daqay, Mat naqmo ya kawa haq daqay ham. Ad in bilaq daqay, Kam abebtanta na sinsin tiqiy haq daqay ham. In nazaq haqsa ne helmo haqad gimuzeq nenaq hi lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Abeb mataw bab emsa ne gihulan huritad teq ta saw haresmo mataw eraqeq gavman gigo maror othassa ne in gibin hurit daqaymo ham. Huritad ne hi ninoriy ham. Daq nagan danmeb tugwahtiqdaqta ham. Teq kam abebtanta na in bab na muzeq hidmo a hi gwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Haqad in gibilan, Mataw en araq eraqeq leheq mataw saw araqabta nenaq an wol daqayta ham. Sa king araq ago dauh nenaq eraqeq king ta araq ago dauhta nenaq an wol daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kanawrigrig aseseqta sibad og ahol wolsa saw asor moq aseseqta teq zarow meqin diqta tugwahtiqdaq ham. Teq nagah arab inaqta amo amo teq daq hares lul araq diqta kaitab gwahtiq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ari daq nagan a hi gwahtiqsamo mataw asor ne giwazeq gimeqin ton daqay ham. Ad in ne giqad bit humab wolaytab leheq ne gimen hazizir emad teq in ne tigiqirqur daqay ham. Ya ihol abin ne giholib usaqta na ago in ne giqad gavman gigo aseseqta na gimeb leh daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kam nab ne nagah gimeb ahol waqiyta na awagamun bilaqgo adanteqin inaq tiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Teq muranmo ne naga gamukin amalib gihol adanin qway daqayta na ago ne ginadnad hi emiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yaqmo teq inad dimunta negad gamuk ne bilaq daqayta na yaqmo ne giqezab emid tugwahtiqdaq ham. Gwahtiqsa mataw ne gimeqin ton daqayta na in ne gigo gamuk amenin em yo hiqiyad in ne gigo gamuk bayid a hikidik woqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kam nab ne ginenmaman teq ne gimaqbaban teq ne gisenlulniz teq ne giyogniz in ne giwaqeq bab gibenab tigiqem daqay ham. Ad in ne gilikmanib asor ginol emid ne tumoq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ya ihol abin ne giholib usaqta na ago on mataw bunmo gigem meqinta neg daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Teq God ne giwamuzsa ne gifaqinib giqensan araq diq a hi milhesdaq ham. Ne giwaz diq meqniyeq oseq teq abeb ne le os dimunta kuluwa-kuluwmo osayta nab gwahtiqeq ne anononmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ari abeb bab bo Jerusalem lilut ugeq tursa ne gibiyad teq ne ginad em daqay, Uliq meqniydaqta akaman na tugwahtim haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kam nab mataw saw Judiya-ib os daqayta na in tukeq garah ban gwalehiy ham. Ad on mataw uliq Jerusalem-ub os daqayta na in uliq na hulosad saw asor ban lehiymo ham. Teq mataw garanab luw daqayta na in muleqeq le uliqab ta hi gwahtiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kam nab God in on mataw daq meqinta emad luwiyta na amenin tinegdaqta ham. In nazaq emeq in ago gamuk mar tonan usaqta na bunmo tuwol net bugdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kam nab on gigem iyayta na teq on amun muturta sus ugayta na in timeqniy daqay ham. Na ezaqgo afaqan na ayah diqmo og kab gwahtiqdaqta ham. Gwahtiqadmo God ago agem meqniy in on mataw na tigimeqin diq tondaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sa mataw en Juda a haiqta nagan boleq Juda on mataw nenaq bab emeq in Juda kabemmo baqirib tiginol em daqay ham. Ginol emad asor in giwazeq giqad in gigo ogib ta leheq giqemid tuqos daqay ham. Mataw en Juda a haiqta nagan bo Jerusalem meqin tonad luwsa le God kam nagta na tihiqiyid teq in muleqeq in gigo uliqab ta leh daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ari Yesus bilam, Kaitab zeq teq kalam teq ulig in gihol buliyeq giwaqan lul araq diq iy daqay ham. Sa ogib kab on mataw dauh bunmo nagah na gwahtiqsa ahol waqad in ginadnad emad rabad tuqos daqay ham. Kamis eraqeq woleq bolsa ahulan ayahmo iysa on mataw huritad in tirab naqmo diq hiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Teq in nagah aseseqta zawayta ulilib usayta nagan gihol wolsa gibiyad in ginad em daqay, Og ka timeqniynan tonaq haq daqay ham. Haqsa rab meqin diqta gilum netsa in gime sinsanid ogib woqeq moq nog iyeq tuqus daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ussamo Mat Atatin kaitab onqas amalib oseq ago zaway teq ahol anuwan ayahta inaq bolsa in ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nazaq iyan abeb daq nagan tugwahtiqsamo ne eraqeq gime ulilib gwalehsa usan ham. Ussa mat ne gizayeq bab gibenab giwaqdaqta na gehitiqsa ne ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ad Yesus in ago disaipel gamuk awowun araq gibilenim bilam, Ne ay fik teq ay bunmo inaqmo gibiyiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ay nagan gihokan muturta gwahtiqsa ne ahol waqad ginad emay, Zeq akaman tiqiynan tonaq haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nazaqmo teq abeb daq ya anan bilayta nagan bunmo tugwahtiqsa ne ahol waqad ginad kazaq emiy, God ago maror bolim sinsin tiqiy haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ya helmo ne gibilenaiq ham. On mataw muran kam kab osayta ka a hi moq bugsa daq nagan bunmo tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kait og inaq teq tihiqiydaqta ham. Ari yaqgo gamuk ka a hi hiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ari ne gihol waz naqmo hiqiyiy ham. Luweq ne daq haresmo emad yuw atoranta uluwad ginad agadan iyad os daqay ham. Ad ne og ka ago afaqan amo amo loyinad ne ginad meqniydaqmo ham. Daq nazaqta na ne gime isihid Iyahta ago kam na gwahtiqsa ne riten daqay ham. Bilaqne karuw dobub woqim ritenaq nazaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mat Atatin ta boldaqta na akaman in on mataw og saw bunmo gigo hib tugwahtiqdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nazaq iyan ne tuteqmo gihol asawan woltayad osiy ham. Ad sirisirimo ne God inaq gamuk bilaqsa in ne zaway negan ham. Zaway negid ne giwaz meqniyeq osad daq nawa ya anan bilayta na in ne gigo hib gwahtiqsa ne dimunmo tuqos daqay ham. Oseq abeb ne Mat Atatin anognib turad ne gimebay a hi woqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ari Yesus kam bunmo Tempel ago gel aduganib le gwahtiqeq in on mataw suleq negyaqta. Ad taromab in le garah anan Oliv haqayta nab usyaq. ");
INSERT INTO mlp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sa on mataw bunmo tarom naqmo saw a hi hastitaysamo in eraqeq Yesus ago gamuk huritnan haqad Tempel-ib tileh yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ari bret yis haiqmo neqayta akaman anan Pasova haqayta na bo sinsin tiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","An mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na in on mataw ginan rabad iyan in gime titoneq Yesus wol emid moqdaqta na ago adanteqin tinagun yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","In Yesus wol emgo adanteqin nagunad luwsa Satan in Yesus ago disaipel gigo araq Judas uliq Kariyot-ibta na aholib tugwal. ");
INSERT INTO mlp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Gwalan in lehim mataw tamaz emayta gigo aseseqta na teq mataw Tempel-ib hurmey osayta gigo aseseqta na nenaq gamuk tiqemiy. Gamuk emad Judas ezaq toneq Yesus waqeq mataw na gibenab emdaqta na ago agamukan tuwastitayiy. ");
INSERT INTO mlp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mataw aseseqta na ginad diq dimniysa in Judas inaq an adugan wazim buloniy, I ni nizayeq mani tinigam haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Haqan Judas gamuk na huritim bilam, Na dimunmo ham. Haqadmo in kam araq dimunta on mataw dauh biyahmo a hi ossa in gime titoneq Yesus waqeq mataw na gibenab emdaqta na akaman tinagunyaq. ");
INSERT INTO mlp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ari bret yis haiqmo neqayta na akaman tugwahtim. Kam nab Juda on mataw God ayon tamaz emad in Pasova ayon sipsip amidgot wol emayta. ");
INSERT INTO mlp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nazaq iyan Yesus in Pita ayow Jon inaq giqeman lehsa in gibilan. Ne leheq i Pasova adidaqan neqamta na abanan wastitayid teq i leheq nequq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Haqan giger na Yesus buloniy, I bit edob diq leheq Pasova adidaqan neqamta na abanan wastitayam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Haqan Yesus gibilan, Huritiy ham. Ne uliq ayahta nab le gwahtiqsa mat araq reb ayuwun inaqta soreq a bo lehad in ne danib tigibiydaq ham. Ne mat naqmo muzeq inaq leheq bit edob in gwahtiqdaqta nab ne bit na anamren kazaq susumun ugiy ham. Tisa bilam, Yaqgo disaipel nenaq didaq neqamta na ago bit adugan edowa? ham haqad ne buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bulonid teq mat na bit adugan araq ayahta ulilib usaqta na tigiqisihundaq ham. Bit adugan nab didaq neqayta anaghan bunmo usaqta ham. Nab ne leheq i Pasova adidaqan neqamta na abanan wastitayiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Haqan giger na tilehiy. Lehim Yesus nagah bunmo ginan gibilanta nazaqmo in ahol tuwaqiy. Ahol waqad in Pasova adidaqan neq daqayta na abanan tuwastitayiy. ");
INSERT INTO mlp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ari imisor didaq neqgo akaman tiqiyan Yesus ago disaipel nenaq humab wolim banab osad didaq tineq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Neqad teq Yesus in ago disaipel gibilan, Ya nenaq Pasova adidaqan ka neqeq teq ya santitiy sordaiq haqad ya inad awaz meqin usta ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Teq ya kazaq ne gibilenaiq ham. Abeb ya nenaq Pasova adidaqan ka a ta hi neqdaiq ham. Ari i gigo Pasova ka anon diq tugwahtiqid kam nab teq ya nenaq God ago maror aduganib osad Pasova adidaqan ka a ta neqdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Haqad in wain agogin inaq waqim God esey ugim gibilan, Ka ne waqeq an ugeq uluwiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ad in bilam, Ya ne gibilenaiq ham. Ya wain ayun ka a ta hi uluwdaiq ham. Abeb God ago maror og kab tugwahtiqid nab teq ya wain ayun ka a ta uluwdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Haqad in bret asor waqim God esey ugim in orqayim tinag. Negad in gibilan, Ka ya inon ne giyon hulosdaiqta ham. Abeb ne ya inadin emad kazaq em daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ari in didaq tineqim hulosad Yesus wain agogin inaq waqim in emim bilam, Gog kab ya inedan God ago maror muturta na zaway ugdaqta usaq ham. Ya ned ka ne giwastitaynan wazbaldaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ari ne ahol waqiy ham. Mat ya iwaqeq bab gibenab iqemdaqta na in ya inaq humab kab osaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","God kwaziqmo Mat Atatin ayon bilaqan usaqta nazaqmo in dan muzeq tilehdaq ham. Ta teq mat bab gibenab Mat Atatin emdaqta na timeqniy hasdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesus nazaq bilaqan disaipel bunmo in gimo an tisusumun ug yaqay, Nog diq teq daq na emdaq? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ari disaipel eraqim nog diq in gilikmanib mat ayah diqta iydaqta na ago in an tumug yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","An mugsa Yesus gibilan, On mataw en ta asor Juda a haiqta nagan gigo maror aseseqta na in igmo ag haqad gihol wazan eraqaqta ham. Sa in gigo walmataw in gihaqenib osayta na in maror na gibin iluwad bilaqay, I gigo maror ka i gilumsihan i dimunmo osauqta haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ari ne nazaq hi emiy ham. Ne gilikmanib mat ayahta na in ahol wazid woqsa in mat minminta abin haiqta nog iyan ham. Ad ne gigo mat danmebta na in ne gigo kabibiy mat samanta nog iyan ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ne ginad emiy ham. Mat banab ossa inmen didaq a bolim anognib emayta na in abin inaq o haiq kabibiy mat didaq iberim a lehaqta naqmo in abin inaqta? ham. Mat banab ossa didaq a bolim ugayta naqmo in mat ayah diqta ham. Teq ya nazaq a hi emaiqta ham. Ya ne gilikmanib osad ya ne gigo kabibiy mat nog iyim ne gilumsihad osaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kwaziqmo mataw afaqan yagad ibaymuzsa negmo a hi ihulos yaqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nazaq iyan ya imam ibenab maror amta nazaqmo ya ne gibenab maror tiqemaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Abeb yaqgo maror aduganib teq ne maror iyeq osad ne yaqgo banab didaq neqad yuw tuquluw daqay haqad ya ne gibenab maror ka emaiq ham. Kam nab teq ne yaqgo maror aduganib marorgo banab osad ne Isrel gigo gem 12 na tigibiy muz daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Haqad Yesus in Pita bulon, Saimon, Saimon ham ni hurit ham. Satan ne bunmo giwaqeq wit nog giqiwornan haqad atoranmo tibilamta ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Teq ya God inaq gamuk emim ninmen tubulon ham. In nilumsihid ni ninad helmo haqaqta na a hi woq hasdaq haqad ya tubulonta ham. Abeb ni ninad buliyeq yaqgo hib ta bolad teq ni nimaqbaban zaway negad in gigo ginad helta na ni wazid ta eraqan ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Haqan Pita bulon, Iyahta ham, ya ninaq bit giqirquran osayta nab tilehgo ham. Ningo bab in ya ninaq garabmo ginol emgo bilaqsa ya a hi rabdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Haqan Yesus bulon, Pita ham ya nibilenaiq ham. Tarom kab kurek a hi gayonsamo ni nime ezeqmanmo gileh tiyagdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ari Yesus in ago disaipel gibilenim bilam, Kwaziqmo ya giqeman ne yaqgo kabiy emnan lehad ne mani aziynaq teq kuram teq baqir a hi soriy ham. Ad ne gisendugan gisenab a hi emiymo ham. Kam nab ne nagah araq ago siqim iyiy ye? ham. Haqan disaipel bilaqiy, Haiq haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Haqan Yesus gibilan, Ari muran ya kazaq ne tigibilenaiq ham. Ne gigo mani aziynaq ussun ne waqiy ham. Ad ziy araq ne gigo es siheneq a luw daqayta na ne waqiymo ham. Ne baqir haiqta iyeq ne gigo giholsihen mat araq ago hib zayeq amenin waqeq ne giholyon baqir zayiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ya helmo gibilenaiq ham. Daq araq teq ya iholib gwahtiqdaqta na in God ago marib gamuk araq ya inan bilamta na tuwol net bugdaq ham. Gamuk na bilam, In mat na anan mat gunun othasaqta araq haqiy ham. Daq na teq ya iholib tugwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Haqan disaipel bilaqiy, Iyahta haqiy i gigo baqir giger kawa haqiy. Haqan Yesus bilam, Na dimunmo tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ari Yesus eraqim uliq hulosim lehad in ago daq muzinim garah Oliv-ub tilah. Lehsa ago disaipel muzim inaq tilehiymo. ");
INSERT INTO mlp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Lehim saw nab tugwahtiqim teq Yesus tigibilan, Ne God inaq gamuk emad osiy ham. Osad ne God bulonid in ne gilumsihid daq ne gilum waqdaqta na ne giholib gwahtiqsa ne hi woqgo haqad buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Haqadmo in disaipel gihulosim asitmo ta leh nog iyim in abakbakan ulum laquwim turad God inaq gamuk tiqemyaq. ");
INSERT INTO mlp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","In bilaqyaq, Ya imam haqyaq ni ninad bilaqsun iyid teq ni ya iholib afaqan ka walem haqyaq. Teq ni ya inad ka hi muz haqyaq. Ninmo ninad muz haqyaq.  ");
INSERT INTO mlp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sa Heven-ib angelo araq gehitiqim Yesus ulumsihad zaway tuqugyaq. ");
INSERT INTO mlp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Zaway ugsa Yesus aholib afaqan ayah diqta loyinad in anad awaz meqin amalib God inaq a gamuk ta emyaq. Emsa ahol qwal wolad ned nog ogib tiqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ari in God inaq gamuk tiqemim hulosad in eraqim ago disaipel gigerab muleqim ta lah. Lehim disaipel gihol afaqan diq iyad ussa in gibiy. ");
INSERT INTO mlp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Gibiyad in gibilan, Ne ezaq haqad usay? ham. Ne eraqeq God inaq gamuk emad osiy ham. Gamuk emad daq ne gilum waqdaqta na bo giholib gwahtiqsa ne hi woqgo buloniy ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus nazaq gamuk bilaqad tursamo mataw dauh biyahmo tuboliy. Bolad Yesus ago disaipel 12 na gigo araq anan Judas haqay na in mataw na dan giqisihunim ameb bol. Bolim in Yesus agerab loqimmo tiqilawun. ");
INSERT INTO mlp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ilawunan Yesus bulon, Judas ham ni daq kaqmo amalib Mat Atatin bab gibenab emaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","An disaipel Yesus inaq turiyta na in daq na ahol waqad ginad emim bilaqiy, Iyahta haqiy i baqirib tiginolam e? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Haqadmo in gigo araq eraqim tamaz mat danmebta ago kabibiy mat araq baqirib wolim adeksan aqabun ger qwatayanmo ogib tuwom. ");
INSERT INTO mlp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Anmo Yesus bilam, Daq na hulosiy ham. Haqad in mat na adeksan usta asawnib aben emim wazanmo in tidimniy. ");
INSERT INTO mlp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ari mataw tamaz emayta gigo aseseqta na teq mataw Tempel-ib hurmey osayta na teq Juda gigo mataw marorta asor in Yesus waznan bolan Yesus gibiyad gibilan, Ne baqir sebur wazim a boliyta ka ne mat rin tonaqta waznan boliy ye? ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kam kabemmo ya nenaq Tempel-ib ossa ne a hi iwaziy ham. Teq muran kam ka in ne gigo kamta ham. Muran romriq awaz meqniyim in saw anuwan tiqisih bugaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ari mataw na Yesus wazim ad tamaz mat danmebta ago bitab tilehiy. Lehsa Pita gimuzim lehad in gibeb pesan nogmo lehyaq. ");
INSERT INTO mlp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mataw na bit nab lehim gel aduganib gwahtiqim bit aqezab faq ulamim iterad tuqosiy. Ossa Pita gigerab lehim nenaq faq iterad tuqosmo. ");
INSERT INTO mlp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","In faq iterad anuwanib ossa kabibiy aw araq Pita ahol waninunadmo tibilam, Mat ka in Yesus inaq luwtamo ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Haqan Pita bilam, Neng ham ya mat na ago a hi huritta ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Haqad in asitmo ta osanmo mat ta araq Pita ahol waqad tubulon, Ni inaqmo mataw na gigo gisenlul araq ham. Haqan Pita bilam, Mang ham na ya a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Haqad in asit sisaq nog ta ossamo mat ta araq awaz meqniyim tibilaqyaq, Helmo diq haqyaq mat ka in mat Galiliy-ibta iyim iyan in Yesus inaq luwta daqag haqyaq. ");
INSERT INTO mlp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sa Pita bilam, Mang ham ni gamuk bilaqaqta na ago ya inad a hi emaiq ham. In nazaq bilaqanmo kurek tigayon. ");
INSERT INTO mlp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gayonan Iyahta ahol buliyim Pita ahol tuwam. Ahol waqsa Pita in Iyahta gamuk bulonta na anadin tiqam. Kurek a hi gayonsamo ni nime ezeqmanmo gileh tiyagdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita gamuk na anadin emadmo in gel asan ban gwahtiqim lehim gaq naqmo diq hiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ari mataw Yesus waz yaqayta na in Yesus woltitayad teq in tibilawun yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ad in tubusan waqim Yesus ame isihim teq in wolad bulon yaqay, Ni God ago nantut iyeq teq nog kawa ninolaqta ka anan biysa i hurituq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ad in gamuk meqmeqinta kabemmo amalib Yesus bilawun yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","67","Ari abeb zeq tigabolan Juda gigo mataw marorta nagan humab tuwoliy. Mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na bo humab wolim ossa teq mataw Yesus waqim a bolim ginognib eman titur. Tursa mataw aseseqta na Yesus tubuloniy, Ni mat anan Krais haqayta na iyeq teq ni i gibilen kem haqiy. Haqan Yesus gibilan, Ya ne gibilenid ne helmo a hi haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ad ta ya ihol alulin anan ne susumun negid ne amenin a hi ibilen daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Teq ya kazaq bilaqdaiq ham. Muran teq abeb Mat Atatin in God Awaz Meqin Diqta na aben aqabun ban tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Haqan mataw na bunmo bilaqiy, Nazaq iyan ni God atatin e? haqiy. An Yesus gibilan, Nawaqmo ne tibilaq sireqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Haqan mataw na bilaqiy, I naga gamukin a ta huritam? haqiy. Inmo aqezab aholyon bilaqan i tuhurit haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ari Juda mataw aseseqta na bunmo eraqim in Yesus waqim ad Pailat ago hib tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A lehim in Yesus amalib nan emad bilaqiy, Mat ka i gigo on mataw bunmo kat negad ginad buliysa in i gigo maror a ta hi muzinayta haqiy. Ad i Sisa takis ugnan bilaqsa in i gidanin qwayaqta haqiy. Teq in bilaqaq, Mat anan Krais haqayta na yaqmo kawa haqaqta haqiy. Ad inmo aholnan bilaqaq, Yaqmo king haqaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Haqan Pailat Yesus tisusumun ug, Ni Juda gigo king e? ham. Haqan Yesus amenin emim bilam, Ni nawaqmo tibilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Haqan Pailat in mataw tamaz emayta gigo aseseqta na teq on mataw biyahta na bunmo gibilan, Ya mat ka ago afaqan araq nagunim ahol a hi way ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Haqan mataw na atoranmo bilaq yaqay, Mat ka saw Galiliy-ib ago kabiy alulin emim in mataw suleq negad luwim bo saw Judiya-ibmo iyim bo uliq kabmo tiqiy haq yaqay. In mataw gamuk gibilenad giqutil wazan eraqsa in ginad haresmo tiqemay haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ari Pailat gamuk na huritim in mataw nab turiyta na tisusumun nag, Ka Galiliy-ib mat araq e? ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Haqan mataw na Pailat bulonan in anad tiqam, Yesus in og saw Herot wamuzaqta na amatinta ham. Nazaq iyan in Yesus eman Herot ago hib tilah. Kam nab Herot in saw Galiliy hulosim bolim in uliq Jerusalem-ub tuqosyaq. ");
INSERT INTO mlp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ari Pailat Yesus eman Herot ago hib lehan Herot ahol waqad anad tidimniy. Kam sisaqmo in Yesus abin huritad in ahol waqnan anad usta, Yesus daq araq azawayin inaqta emsa ya ahol waqdaiq haqad. ");
INSERT INTO mlp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Teq in nagah kabemmo ago Yesus tisusumun ugyaq. Susumun ugsa Yesus gamuk araq amenin a hi emyaq. ");
INSERT INTO mlp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sa mataw tamaz emayta gigo aseseqta na teq mataw Moses ago gunun hurit kemiyta na in bo sinsin diq turad Yesus amalib nan kabemmo emad gamuk atoran diqmo bilaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bilaqsa Herot ago mataw bab emayta na nenaq in inaqmo Yesus kamolmol ugad bilawun yaqaymo. Bilawunad in tubusan araq sisaqta awaq dimunta waqim Yesus aholib emim teq in eman Pailat ago hib muleqim ta lah. ");
INSERT INTO mlp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ari kam nab Herot Pailat inaq yow tiqemiy. Kwaziqmo in giger an gihar ugad os yaqayta. ");
INSERT INTO mlp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ari Pailat in mataw tamaz emayta gigo aseseqta na teq Juda gigo mataw marorta na gigo on mataw asor nenaq gibilenan boliy. ");
INSERT INTO mlp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Bolan in gibilan, Ne mat ka waqim yaqgo hib a bolim bilaqiy, Mat ka on mataw gihureqsa ginad agadan iysa in gisesan gigo gunun a ta hi muzinayta haqiy ham. Haqan ya ne gimeb gamuk na ulum muzad ya mat ka tisusumun ug ham. Susumun ugim ya in ago hib daq araq meqinta ahol a hi way ham. Ne gigo hazizir ka alulin haiqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ad ya Herot ago hib eman lehan Herot nazaqmo alulin araq ahol a hi waqad in mat ka eman yaqgo hib muleqim ta bol ham. Helmo ham. Mat ka daq araq meqinta i wol emid moqdaqta na a hi amta ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nazaq iyan ya mataw gibilenid in gusib woltitayid teq ya hasid tilehdaq ham.  ");
INSERT INTO mlp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ari ulig bunmo Pasova akamnib Pailat ago daq in mataw giqirquran osayta na gigo araq hasid gwahtiqyaqta. ");
INSERT INTO mlp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nazaq iyan in Yesus woltitayeq hulosid lehgo bilaqan on mataw bunmo araqibmo dedibmo bilaqiy, Mat na wol emiy haqiy. Ad ni Barabas-mo hasid i gigo hib bolan haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mat anan Barabas haqayta na in Rom gimuznan haqad nenaq bab emim gigo mataw asor ginol amta na ago in irquran osta. ");
INSERT INTO mlp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ari mataw nazaq bilaqan Pailat in Yesus hasid gwahtiqnan haqad a ta gibilan. ");
INSERT INTO mlp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gibilenan haiq. On mataw na dedibmo a ta bilaq yaqay, Ayib dom wolid moqan haq yaqay. Ayib dom wolid moqan haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Haqsa Pailat ame ezeqmanta a ta gibilan, Nagaqgo? ham. Mat ka naga daqin meqinta am? ham. Ya in ago hib daq araq meqinta ya wol emid moqdaqta na ahol a hi way ham. Nazaq iyan ya woltitayeqmo hasid tilehdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Teq haiq. Mataw na zaway diq iyim lileyad in ayib dom wolgo atoran diqmo bilaq yaqay. Ad in giqez na Pailat ago gamuk bayan tuwom. ");
INSERT INTO mlp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nazaq iyan Pailat bilam, On mataw dauh biyahta ka ginad usaqta nazaqmo tiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Haqad in giqez muzinim in mat Rom nenaq bab emim mataw ginol eman bit giqirquran osaytab eman osta na hasan lehsa in Yesus ayib dom wolgo tibilam. ");
INSERT INTO mlp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ari in Yesus waqim ad tilehad teq in mat araq anan Saimon haqayta uliq Sairin-ibta ahol waqadmo tuwaziy. Mat na uliq Jerusalem ban bolad luwsa in wazim Yesus ay soryaqta na ugan in ay na sorim Yesus muzim inaq tilah. ");
INSERT INTO mlp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lehsa on mataw dauh biyahmo Yesus muzim inaq lehad in gilikmanib on asor giban wolad gaq wazim leh yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sa Yesus ahol buliyim on na gibilan, Ne Jerusalem on ham ne ya inan hi gaqiy ham. Negmo giholnan teq ne gigo onmin ginan ne gaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ne huritiy ham. Abeb kam araq meqin diqta tugwahtiqdaq ham. Gwahtiqid kam nab ne bilaq daqay, On nignigta onmin giqemim sus a hi negiyta na in tidimniyim osayta haq daqay ham. Na ezaqgo in gigo amun araq moqsa in ahol a hi waqayta haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kam meqinta nab mataw garah gibileneq bilaq daqay, Ne i gimalib woqeq giqisihiy haq daqay ham. Giqisihid bab bo i a hi ginol em daqay haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ne ginad emiy ham. Kam dimunta kab mataw ya iholib daq meqinta kazaq emid kam meqinta nab daq timeqniy hasdaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ari in mataw daq meqin emiyta gigermo Yesus inaq ginol emnan giqad lehiymo. ");
INSERT INTO mlp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Giqad lehim in le garah akululqan araq anan Gifaqin Agolgolan haqayta nab tugwahtiqiy. Gwahtiqim saw nab in Yesus ayib dom tuwoliy. Ad mataw meqinta giger na inaqmo ayib dom giwoliymo. Dom wolan mat araq Yesus aqabun ban tursa araq anasaran ban turyaq.  ");
INSERT INTO mlp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Sa Yesus bilam, Ya imam ham mataw ya imeqin tonayta gigo daq meqinta ka ni walemad anadin ta hi em ham. In ginad a hi em hasadmo daq ka emay ham. Ari mataw Yesus ayib dom wolim hulosad teq in ago tubusan nagan ibereq giholyon waqgo haqad gig amikmikta tuhuneg yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sa on mataw Yesus aholmo waqad turiy. Tursa Juda gigo mataw marorta na in Yesus bilawuneq bilaq yaqay, In mataw asor gilumsihan a hi moqiyta haq yaqay. In mat God atowun emim kabiy ugta anan Krais haqayta na iyeq teq in awaz meqniyeq inmo ahol ulumsiheq hi moqan haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Haqsa mataw bab emayta na nazaqmo Yesus bilawun yaqaymo. Bilawunad in agerab loqim wain ayun agon iyta ugnan ton yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ad teq in bulon yaqay, Ni Juda gigo king iyeq teq ni ninmo nihol ulumsiheq hi moq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Teq in Yesus ayib dom woliyta na ago ananin mar tonim afaqinib othenan us. Gamuk na in kazaq mar toniy. ");
INSERT INTO mlp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ari mataw daq meqinta emiyta giger Yesus agerab giqotheniyta na gigo araq in Yesus bilawunim bilam, Ni mat anan Krais haqayta ye? ham. Ni mat na iyeq teq ninmo nihol ulumsihad ni i giger gilumsihmo ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Haqan ta araq na in gamuk na huritim in araq na wadim bulon, Ni in afaqan waq nogmo ni waqaq ham. Ni God anan a hi rabaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","I giger ginol emid moqamta na dimunmo ham. I daq meqinta emad luwta na ago afaqan i kawa tisorauq ham. Ari mat ka daq araq meqinta a hi amta ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Haqad in Yesus bulon, Yesus ham abeb ni king iyeq teq ni ya inadin em ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Haqan Yesus bulon, Ya helmo nibilenaiq ham. Muran ya ninaq i giger Paradais-ibmo tuqosam ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ari zeq gabolim liqab tiqiysa saw bunmo romriq iyad le 3 kilok imisor tiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kam nab zeq anuwan hiqiysamo tubusan ayahta Tempel-ib othenan usta na aliqabmo tartayim gigermo iy. ");
INSERT INTO mlp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Samo Yesus dedibmo lileyim bilam, Ya imam ham ya iwitan eman ni nibenab tilehaq ham. Haqadmo in tumom. ");
INSERT INTO mlp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Moqanmo bab mataw gigo amebta na in daq nazaq ahol waqad in God abin iluwad bilam, Helmo diq ham. Mat ko aholib daq araq meqinta a hi usta ham. ");
INSERT INTO mlp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","An on mataw biyahta mareren boliyta na in daq nagan bunmo ahol waqim in muleqim ta lehad giqutil tartaysa in giban wazim gigo uliqab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lehsa Yesus ayogniz bunmo teq Galiliy-ib on Yesus muzim inaq boliyta na inaqmo in pesan nogmo turad nagah na bunmo gwahtiqsa in ahol tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ari Juda gigo uliq anan Arimatea haqayta na amatin araq anan Josep haqayta in Jerusalem-ub tubolim os. Mat na in Juda gigo mat marorta araq teq in mat dimunta ago daq titnonimmo usta. Juda gigo maror bunmo in Yesus wol emid moqgo an adugan wazsa Josep asor a hi bilamta. Teq in God ago maror og kab gwahtiqsa ahol waqnan haqad amen emyaqta. ");
INSERT INTO mlp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mat naqmo Pailat ago hib lehim Yesus asan waqeq a le yay tongo tisusumun ug. ");
INSERT INTO mlp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Susumun ugim in lehim Yesus asan ayib walemim ogib eman ussa in tubusan husta araq amalib il tonim hodhod aduganib tiqam. Hodhod na gig araq ayahta adugan qwayim emiyta. Teq kwaziqmo in mat araq momta asan hodhod nab eman a hi usta. ");
INSERT INTO mlp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ari kam Yesus momta na in Juda gigo lotu ayon nagah wastitayayta akaman. Kam nab imisor zeq tuwolehsa Juda gigo lotu akaman diq na tugwahtiqnan tonyaq. ");
INSERT INTO mlp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Samo Galiliy-ib on Yesus muzim inaq boliyta na in Josep muzim inaq hodhodab tilehiy. Lehim in hodhod na ahol tuwaqiy. Ahol waqad Josep Yesus asan wastitayim hodhodab emsa in ahol waqiymo. ");
INSERT INTO mlp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ahol tuwaqim teq in muleqim in gigo bitab tilehiy. Lehim in masil nagah amo amo ahuran dimunta Yesus asanib em daqayta na tuwastitayiy. Wastitayim eman ussa lotu akaman na tugwahtiqan in ginamur emad tuqosiy, God ago gunun bilamta nazaq. ");
INSERT INTO mlp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ari Sande tarommo saw hastitay inaq on na in masil nagah ahuran dimdimunta tanabmo wastitayan usta na giwaqim ad hodhodab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lehim gig hodhod aqez ituqim usta na otbuliyan le ussa in ahol tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ahol waqad in le hodhod aduganib gwahtiqim Yesus asawanmo ahol waqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ahol waqad in ginadnad emad nab tursamo mataw giger gigo tubusan oy gigayinsa in gigerab tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gwahtiqanmo on na rabad ginobun mulbunim ogib woqim usiy. Ussa mataw giger na gibileniy, Ne ezaq haqad mataw tumoqiyta gigo sawab mat kayeqmo osaqta na nagunay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mat na kab haiq haqiy. In tiqeram haqiy. In a hi moqadmo saw Galiliy-ib osad gamuk gibilanta na ne anadin emiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","In ne gibilan, Mat araq in Mat Atatin mataw meqinta gibenab tiqemdaq haqad in bilam haqiy. Gibenab emid in ayib dom tuwol daqay haqad in bilam haqiy. Dom wolid kam ezeqmanta nab in ta eraqdaq haqad in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","In nazaq haqanmo on na in kwaziqmo Yesus gamuk bilamta na anadin a ta emiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ad in hodhod hulosim muleqim tilehiy. Lehim in disaipel 11 na teq mataw asor disaipel nenaq osiyta na bunmo in giholib daq gwahtimta na awagamun tigibilen bugiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mariya uliq Magdala-ibta na teq Jowana teq Jems anen Mariya teq on asor in nenaq luwiyta naqmo in Aposel gibileniy. ");
INSERT INTO mlp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Gibilenan mataw na in gigo gamuk huritim in ginadibmo bilaqiy, Gamuk na samanta alulin haiqta haqiy. Haqad in on na giqez anan helmo a hi haqiy.  ");
INSERT INTO mlp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ta teq Pita eraqim hodhodab sibim tilah. Lehim in kuh tonim wiliyanim ame loqim tubusan husta na amomo ussa in ahol tuwam. Ahol waqim in muleqim bitab ta lehad teq in daq gwahtimta na ago anadnad diq tiqemyaq. ");
INSERT INTO mlp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ari kam nabmo disaipel gilikmanib mataw giger eraqim uliq araq amikta anan Emeus haqaytab tilehiy. Dan Jerusalem hulosim le Emeus-ib gwahtimta na in 11 kilomita nazaq. ");
INSERT INTO mlp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","In giger danib lehad daq bunmo Jerusalem-ub gwahtimta na anan in an bulonim leh yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","In gamuk emad an bulonim lehsa Yesus-mo in gigerab gwahtiqim nenaq tilehyaq. ");
INSERT INTO mlp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Lehsa giger na nagah araq gime ituq nog iyan in Yesus ahol a hi waq has yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sa Yesus gibilan, Ne giger naga diq ago bilaqim lehay? ham. In nazaq bilaqan giger na wasihim ginad meqniysa tituriy. ");
INSERT INTO mlp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Turad araq anan Kliyopas haqayta na in Yesus ago gamuk amenin emim bilam, Mataw kabemmo uliq saw bunmo uliq Jerusalem-ub bolim osad in daq gwahtimta na ago tuhuritiyta ham. Ta teq ni edob luwim ni nimomo nagah na ago a hi huritta? ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Haqan Yesus tisusumun nag, Na naga? ham. An in buloniy, Yesus uliq Nasaret-ibta na ago hib daq gwahtimta naqmo haqiy. Mat na in God ago nantut araq haqiy. In God teq on mataw bunmo gimeb kabiy awaz meqin diqta emad in gamuk dimdimunta bilaqyaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sa mataw tamaz emayta gigo aseseqta na teq i gigo mataw marorta na in mat na wazim gavman gibenab emiy haqiy. Eman gavman gamuk emim anan bilaqiy, In moqan haqad bilaqiy haqiy. Haqad in ayib dom wolim othenan tumom haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Teq kwaziqmo i ginad emyauq, Mat naqmo Isrel on mataw bunmo gizayeq gibabun gibenab giwaqeq ban dimuntab giqemid in dimunmo tuqos daqay haqyauqta haqiy. Teq ta nagah araqmo haqiy. Daq na gwahtimta ago akaman ezeqmanta muran tiqiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","An muran i gisenlulib on asor in i giqeman i gihol turuh nam haqiy. Tarom naqmo in hodhodab lehiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Lehim in Yesus asan asawanmo ahol waqiy haqiy. Ad in muleqim ta bolim kazaq bilaqiy haqiy. I God ago angelo asor gibiy haqad in bilaqiy haqiy. Gibiysa angelo bilaqiy, Yesus hodhodab eraqim kayeqmo osaq haqiy haqad in i gibileniy haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Haqan i gilikmanib mataw asor hodhodab tilehiymo haqiy. Lehim on bilaqiyta nazaqmo in gimeb nagah ahol tuwaqiy haqiy. Teq in Yesus-mo ahol a hi waqiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Haqan Yesus gibilan, Ne giger ginad siqim diq ham. Ne God ago nantut gamuk bilaqan usta na anan helmo haqgo ne gigem soqotim usaq ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Gamuk na ezaq bilam? ham. In bilam, Krais boleq afaqan nagan bunmo sorad santitiy waqeq teq in abin ayahta inaq iyeq ago ban ulilibta nab tuqos woqdaq haqad in bilam ham. Nazaq a haiq e? ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Haqad in Moses teq God ago nantut inmo ananin mar toniyta na bunmo gibilenad in gamuk na alulin bilaq hasyaq. ");
INSERT INTO mlp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ari in lehim mataw giger na gigo uliqab tugwahtiqim Yesus in gihuloseqmo lehnan ton. ");
INSERT INTO mlp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sa mataw giger na Yesus wasihim buloniy, I ninaq osam haqiy. Zeq tuwolehsa tarom tiqiynan tonaq haqiy. In nazaq haqan Yesus le nenaq bitab gwahtiqim tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Osim abeb in didaq tineqgo haqad banab tuqosiy. Osad Yesus bret waqim God esey ugim in orqayim mataw giger na tinag. ");
INSERT INTO mlp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","In nazaq tonanmo giger na gime tihastitaysa in ginad tiqem hasiy. Ka Yesus-mo haqiy. Haqsamo haiq muran diq nawaqmo Yesus in gime titonim nabag lehan in ahol a ta hi waqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ad in an bulonim bilaqiy, I mat na inaq danib bolsa in suleq igad God ago gamuk alulin gibilensa i giqutil bilaqne faq oy nog iyyaqta haqiy. Naqmo Yesus-mo i gamuk gibilenyaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","In nazaq bilaqad kam nabmo in eraqim Jerusalem-ub a muleqim ta lehiy. Lehim in disaipel 11 na giyogniz asor nenaq humab wolim ossa gibiyiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Gibiysa in bilaq yaqay, Helmo diq haq yaqay. Iyahta tiqeram haq yaqay. Saimon ahol tuwam haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Haqsa teq ta giger na danib luwsa daq bunmo giholib gwahtimta na ago agamukan bunmo in tigibileniymo. Ad in bilaqiy, In bret orqayim igta nab i ahol tuwaq has haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ari in gamuk na bilaqad ossamo Yesus gilikmanib gwahtiqim titur. ");
INSERT INTO mlp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tursa in ahol waqad gihol riten lamsa rabad ginad emiy, Ka i mat momta awitan daqag ahol waqauq haqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Haqsa Yesus gibilan, Doq tonnan ne gihol riten lamsa ginadnad tiqemay? ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ne ya ibensen ahol waqiy ham. Ka yaqmo ham. Ne giben ya isanib emeq iwaz waqiy ham. Mat momta awitan in asan teq aditin kazaq haiqta ham.  ");
INSERT INTO mlp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","In nazaq gibilenim teq in aben asen tigiqisihun. ");
INSERT INTO mlp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Giqisihunan disaipel ginad dimniysa teq in helmo haqgo ginad siqim iysa in ginadnad em yaqay. Sa Yesus gibilan, Ne gigo didaqag usaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Haqan in nabiq oyiyta asor tuqugiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ugan in waqim neqsa in ahol tuwaqiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ahol waqsa Yesus gibilan, Kwaziqmo ya nenaq osad gibilenyaiq ham. God ago maror Moses mar tonta nab ya inanin usaqta haqyaiq ham. Teq God ago nantut kwaziqta na gigo marib in yaqmo inan bilaqiyta haqyaiq ham. Sa Buk Song-ib bar usaqta nab ya ibin usaqtamo haqyaiq ham. Gamuk na bunmo adidaqan teq gwahtiqdaq haqyaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Haqad in disaipel na ginad eman hastitayan in God ago mar na ginad tiqem hasiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Sa Yesus ta gibilan, God ago marib gamuk kazaq bilam ham. Krais santitiy tisordaq haqad in bilam ham. Soreq kam ezeqmanta nab in hodhodab tiqeraqdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Eraqid teq mataw in abin ad leheq on mataw en bunmo tigibilen daqay haqad in bilam ham. Gibileneq in bilaq daqay, Ne Krais anan helmo haqad ginad buliyeq ne gigo daq teq ginad meqinta gileh ugid teq God ne gigo daq meqinta bunmo tigiwalem bugdaq haq daqay haqad in bilam ham. Daq na uliq Jerusalem-ub danmeb gwahtiqeq in og saw bunmo tuwaqdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Negmo gime anonabmo daq nagan bunmo ahol tuwaqim iyan ne awagamun tibilaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ne huritiy ham. Ya imam in ago Bugaw Dimunta negnan hel diqmo bilamta na muran ya emid tubol negdaq ham. Ne uliq ayahta kabmo osiy ham. Ossa ulilib zaway na bo ne gimalib tuwoqid teq ne yaqgo kabiy na tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ari Yesus in ago disaipel giwaqim nenaq uliq Betaniy-ibmo tilehiy. Lehim in aben giger wazan eraqan in ago disaipel gidimun tonad tigibar ton. ");
INSERT INTO mlp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Gibar tonsamo God Yesus waqim ad Heven-ib tugwalah. ");
INSERT INTO mlp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Gwalehsamo disaipel gibakbakan ulum laquwim turad in Yesus abin tiqiluwiy. Abin iluwim hulosadmo in muleqim ginad ayahmo dimniysa Jerusalem-ub tilehiy. ");
INSERT INTO mlp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lehim osad kam bunmo in Tempel-ib leheq God abin tiqiluw yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kwaziq diqmo God ago Gamuk in tuqosta. Gamuk na God inaq osad teq Gamuk na in God-mo. ");
INSERT INTO mlp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nagah bunmo og kab a hi gwahtiqsamo mebmebmo diq Gamuk na God inaq osta. ");
INSERT INTO mlp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gamuk naqmo in nagah bunmo giqamta. Nagah araq diq dante araqab a hi gwahtimta. Haiqgam. ");
INSERT INTO mlp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Teq on mataw kayeqmo kuluwa-kuluwmo osayta na alulin Gamuk nabmo usaqta. Gamuk na in saw anuwan nog iyad on mataw bunmo gimalib worireqaqta. ");
INSERT INTO mlp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Teq saw anuwan na romriqab oysa romriq in saw anuwan na a hi wolmiyaqta. ");
INSERT INTO mlp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ari God in mat araq eman bol. In anan Jon haqayta. ");
INSERT INTO mlp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jon saw anuwan na anan bilaq kemnan bolta. In on mataw gibilenid in bunmo saw anuwan na anan helmo haq daqay haqad in bolta. ");
INSERT INTO mlp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Inmo saw anuwan na a haiqta. Haiqgam. In saw anuwan na anan on mataw gibilennan haqad bolta. ");
INSERT INTO mlp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Saw anuwan hel diqta on mataw bunmo gimalib worireqaqta na in og kab tugwahtiqyaq. ");
INSERT INTO mlp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gwahtiqadmo in on mataw og kabta gilikmanib tuqos. Inmo nagah bunmo og kab giqeman gwahtiqiyta. Teq on mataw og kabta in mat na ahol waqad in ahol a hi waq hasiy. ");
INSERT INTO mlp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mat na asenlulmo diq gigo hib bolta teq in asenlul na baymuzim a hi waziniy. ");
INSERT INTO mlp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ari on mataw mat na ahol waq hasim waziniyta na bunmo, mat na in giqeman in God ago onminmo diq tiqiyiy. Na ezaqgo on mataw na in anan helmo haqiyta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Teq on mataw God ago onmin iyiyta na in mataw og kabta gilulib a hi gwahtiqiyta. Teq in og ka ago daqib a hi gwahtiqiymo. Mataw ginad bilaqsa giqonan amun emayta nazaq in a hi gwahtiqiy. Haiqgam. God-mo in on mataw na giqeman in ago onmin tiqiyiyta. ");
INSERT INTO mlp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ari God ago gamuk na in mat diq iyim i gilikmanib osta. Ossa i in ahol anuwan ahol tuwawta. I in ahol anuwan ahol waqad i bilaqne God atatin amulikmo osaqta naqmo ahol anuwanta ahol waq nog iy. Teq i ahol waqsa in agem dimunta igaqta na teq in gamuk heltaqmo bilaqaqta na in aholib ate gwalim ussa i ahol tuwaw. ");
INSERT INTO mlp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Teq Jon in mat naqmo anan on mataw gibilenad in lileyim kazaq gibilan, Ya mat naqmo anan gibilenad kazaq bilayta ham. Mat ya ibeb boldaqta na in yaqgo danmebta hay ham. Na ezaqgo hay ya a hi gwahtiqsamo in tuqosta na ago iyan haqad ya bilayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Teq mat nawa Jon anan bilamta na in agem dimunta igad gamuk helta gibilenaqta na aholib ame gwalad usim wazbalim i gimalib woqaqta. Woqsa in aholib daq dimdimunta usaqta na amalib in i bunmo tigidimun tonaq. Gidimun tonsa i daq dimdimunta na loyinsa in nagah mebmebmo God igta na uriyam bugaq. ");
INSERT INTO mlp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Na ezaqgo God ago maror in mebmebmo igta na Moses abenab bolan i wawta. Ari God agem dimunta igaqta na teq in ago daq helta nagan bunmo Yesus Krais-mo abenab bolta. ");
INSERT INTO mlp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mat araq ame anonab God asit ahol a hi wamta. Haiq diqmo. God atatin amulikmo osaqta naqmo in God giqisihunta. Inmo God diqta teq in Amam abuknibmo osaqta. In amomo God eman i gimeb ulal iysa i ahol waqauqta. ");
INSERT INTO mlp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ari Juda mataw aseseqta na in mataw tamaz emayta gigo asor teq Liway mataw Tempel-ib kabiy emayta gigo asor giqeman in Jerusalem hulosim Jon ago hib bolim tisusumun ugiy, Ni nog diq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Haqan Jon gibilen kam. Gibilen kemad in ahol alulin na a hi isihyaq. Haiq. In gamuk bilaq sireqimmo kazaq bilam, Ya Krais a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Haqan mataw na a ta susumun ugiy, Ta ezaq? haqiy. Luweq ni Elaija iydaq haqiy. An Jon bilam, Haiq ham. Haqan in bilaqiy, Luweq i God ago nantut amen emad osauqta na ninmo iydaq haqiy. Haqan Jon bilam, Na haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Haqan in buloniy, Ni nog? haqiy. I muleqeq ta leheq mataw i giqeman bolta na naga gamukin gibilenam? haqiy. Ta ninmo nihol anan ezaq haqaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Haqan Jon bilam, Mat aqez saw amatawun haiqtab lileyim bilaqaq, Ne Iyahta ayon dan wastitayiy haqaqta na yaqmo kawa ham. Kwaziqmo God ago nantut Aisaya bilamta nazaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ari mataw ginan Farisi haqayta naqmo in mataw na giqeman Jon agerab boliyta. ");
INSERT INTO mlp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","An Jon in gigo susumun amenin nazaq eman mataw na buloniy, Ni bilaqaq, Ya Krais a haiq haqaq haqiy. Ad ya Elaija a haiqmo haqaq haqiy. Teq ya God ago nantut na a haiqmo haqaq haqiy. Nazaq iyan teq ni nagaqgo mataw huz negaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Haqan Jon amenin emim bilam, Ya mataw yuwibmo huz negaiqta ham. Ari ne gilikmanib mat araq nawa turaq ham. Teq ne in ago a hi huritayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mat na ya ibeb nawa bolaqta ham. In abin ya ibin uriyamta ham. Ya in ahaqenibta ham. In yaqgo Iyahta ham. Ya in ago kabibiy mat samanta ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon yuw Jodan aqurumun kozaq ban uliq anan Betaniy haqayta na agerab luwad mataw huz negsa daq na gwahtimta. ");
INSERT INTO mlp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ari tarom iyim saw tihastitayan Yesus Jon ago hib bolsa in ahol tuwam. Ahol waqadmo in on mataw nab turiyta na gibilenim bilam, Ne ahol waqiy ham. God ago Sipsip Amidon kawaqmo tubol ham. In teq on mataw og saw bunmo gigo daq meqinta tigiwalemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ya kwaziqmo mat kaqmo anan bilayta ham. Ya bilay, Mat araq ya ibeb boldaqta na in yaqgo danmebta hay ham. Na ezaqgo hay ya a hi gwahtiqsamo in tuqosta na ago iyan hay ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yaqmo in ago a hi huritta ham. Teq ya bolim on mataw huz negaiqta ka alulin in kazaq ham. Ya on mataw huz negsa mat ko Isrel gimeb ulal iydaq haqad ya kazaq emaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon nazaq haqad teq in kazaq gibilan, God ago Bugaw Dimunta ah husta nog iyim Heven hulosim gehitiqim mat ko aholib soqotim ossa ya ahol way ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yaqmo in ago a hi huritta ham. Teq mat ya iqeman ya bolim mataw yuwub huz negaiqta na in ya ibilenim bilam, Yaqgo Bugaw Dimunta gehitiqeq mat araq aholib soqoteq ossa ni ahol waqad teq ni ninad emdaq, Mat God ago Bugaw Dimunta amalib on mataw huz negdaqta na amatin nawaqmo haqdaq haqad in ya ibilan ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","An ya daq na ahol tuway ham. Ahol waqim ya bilaqaiq, Mat ko in God atatin haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ari tarom iyim saw tihastitayan Jon ago disaipel giger nenaq saw nab a ta turiy. ");
INSERT INTO mlp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tursa Yesus bo lehsa Jon ahol waqad tibilam, Ne ahol waqiy ham. God ago Sipsip Amidon kowaqmo tilehaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Haqan disaipel giger na nazaq huritadmo in Yesus muzim inaq tilehiy. ");
INSERT INTO mlp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Lehsa Yesus ahol buliyim giger na muzim bolsa gibiyad in gibilan, Ne naga nagunay? ham. An in buloniy, Rabbi haqiy ni edob osaqta? haqiy. (Hibru nanib gamuk ‘rabbi’ na alulin in ‘tisa’ haqayta.) ");
INSERT INTO mlp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","An Yesus gibilan, Ne boleq ahol waqiy ham. Haqan giger na lehim Yesus ago bit in osaqta na ahol tuwaqiy. Ahol waqad luwsa in 4 kilok imisor nazaq iysa iyan in Yesus inaq tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mataw giger Jon ago nan huritim Yesus muzim inaq lehiyta na gigo araq na anan Andru haqayta. In abab anan Saimon Pita. ");
INSERT INTO mlp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Abeb Andru muleqim ta bolim iturimmo in le abab Saimon nagunim ahol waqadmo tubulon, I Mesaya ahol tuwaw ham. (Hibru nanib gamuk ‘Mesaya’ na alulin in ‘Krais’ haqayta.) ");
INSERT INTO mlp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andru nazaq bilaqim teq in Saimon waqim ad Yesus ago hib tilah. A lehan Yesus in Saimon ahol waqad bulon, Ni Jon atatin Saimon ham. Abeb ni ninan Sifas haqad biy daqay ham. (Hibru nanib gamuk Sifas haqayta na alulin in ‘Pita’ haqayta.) ");
INSERT INTO mlp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ari tarom iyim saw tihastitayan Yesus saw Galiliy-ib lehgo anad tiqam. Anad emim in lehadmo mat araq anan Filip haqayta na ahol waqim tubulon, Ni ya imuzeq bol ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip in uliq Betsaida-ibta. Uliq na in Andru abab Pita inaq gigo uliqta. ");
INSERT INTO mlp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ari Yesus nazaq Filip bulonan in eraqim le mat araq anan Nataniyel haqayta nagunim ahol waqad tubulon, Moses in God ago maror agamukan aduganib mat ananin mar tonta na amatin gwahtiqan i ahol tuwaw ham. I ginad emauq, God ago nantut kwaziqmo mat ananin mar toniyta amatin nawaqmo tubol haqauq ham. Na in Josep atatin Yesus uliq Nasaret-ibta ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Haqan Nataniyel bilam, Uliq Nasaret abin meqinta ham. Daq araq dimunta nazaq uliq nab a hi gwahtiqdaq daqag ham. Haqan Filip bilam, Nab iysa ni bo ahol waq ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ari Yesus in Nataniyel bolsa ahol waqadmo in anan bilam, Mat ko ahol waqiy ham. Ko Isrel gigo mat diqmo araq ham. In aholib nan katiyta araq a hi usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Haqan Nataniyel tisusumun ug, Ni ezaq tonim yaqgo tuhurit? ham. Haqan Yesus amenin emim bilam, Filip a hi nililewunsa ni ay fik ahaqenib ossa ya nibiyta ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Haqanmo Nataniyel bilam, Tisa ham ni God atatin ham. Ni Isrel gigo king ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Haqan Yesus bilam, Ya bilay, Ni ay fik ahaqenib ossa ya nibiy hayta na ago ni ya inan helmo haqaq e? ham. Na in nagah amik ham. Teq ni yaqgo daq aseseqta tigibiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Haqad in bulon, Ya helmo nibilenaiq ham. Abeb kait misireq nog iyeq aqez hassa angelo asor Mat Atatin ago hib gewoqad Heven-ib gwalehsa ni tigibiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ari kam gigermo tihiqiyan ezeqmanta nab saw Galiliy-ib uliq araq anan Kana haqayta nab mat araq awe inaq an waqsa ahumabun tuwoliy. Sa Yesus anen humab nab os. ");
INSERT INTO mlp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ossa mataw nabta na in Yesus ago disaipel nenaq gimen nan eman in humab nab bolim osiymo. ");
INSERT INTO mlp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ossa mataw wain ayun uluw bugan tihiqiy. Hiqiyan Yesus anen lehim atatin tubulon, Mataw gigo wain ayun tihiqiy bug ham. ");
INSERT INTO mlp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Haqan Yesus amenin emim bulon, Kanen ham ya inad usaq nazaq nogmo ni ninad a hi usaq ham. Ya ihol ulal tondaiqta akaman teqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Haqan anen in kabibiy mataw nab turiyta na gibilan, Ya itatin ezaq gibilenid ne emmo emiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ari bit nab reb gigib sisoqiyta aseseqta 6 nazaq giturta. Reb na mataw yuw soqoreq a bo gitenid ussa teq in Juda gigo gunun muzinad huz yaqayta arebun. Reb na amulik-mulikmo aduganib yuw ayahmo 100 lita nazaq tenid osyaqta. ");
INSERT INTO mlp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ari Yesus in kabibiy mataw asor gibilenim bilam, Reb ko bunmo yuw soqoreq a boleq gitenid ame gwal bugan ham. Haqan mataw na le yuw soqorim a bolim reb na gitenan amemo gwal bug. ");
INSERT INTO mlp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","An in gibilan, Ari ne yuw teniyta na asor reb amiktab soqoreq a leheq mat didaq wamuzaqta na ugiy ham. Haqan kabibiy mataw yuw na asor soqorim a lehim mat didaq wamuzaqta na tuqugiy. ");
INSERT INTO mlp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ugan in uluw waqan yuw diq na in wain ayunmo tiqiy. Teq in wain ayun na edob waqiyta na ago in a hi hurit. Kabibiy mataw yuw soqoriyta naqmo huritiyta. Nazaq iyan mat didaq wamuzaqta na in mat aw waqaqta na bulonan agerab tubol. ");
INSERT INTO mlp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Bolan in bulon, Mataw bunmo iturimmo gigo mareren wain ayun dimunta negan uluwayta ham. Uluwim in ginad dimunta hulos nog iysa teq in wain agon inaqta negan uluwayta ham. Ta ni nazaq a hi amta ham. Wain meqinta tuquluw bugan teq ni wain ayun dimun diqta ka abeb a bol ham. ");
INSERT INTO mlp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Na kam ameb diqta Yesus daq azawayin inaqta am. In uliq Kana-ib saw Galiliy-ibta nab daq na amta. Emim in ahol abin ulileman usta na tuqulal ton. Ulal tonan in ago disaipel ahol waqad anan helmo tihaqiy. ");
INSERT INTO mlp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ari daq na tihiqiyan Yesus in anen teq in amagniz teq in ago disaipel nenaq uliq Kapaneam-ub tuwolehiy. Wolehim in uliq nab kam asor tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ari Juda gigo lotu akaman ayahta anan Pasova haqay na bolim sinsin tiqiysamo Yesus uliq Kapaneam hulosim Jerusalem-ub tugwalah. ");
INSERT INTO mlp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Gwalehim in Tempel ago gel aduganib mataw bulmakau teq sipsip teq ah gizayad amenin waqad ossa in tigibiy. Ad mataw saw haresmo gigo mani waqad amenin Tempel ago mani negayta na in gigo kabiy emad ossa Yesus tigibiymo. ");
INSERT INTO mlp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Gibiyad in yuk abatan asor giwaqim tuq tonim in mataw na gigo bulmakau teq sipsip bunmo ginolad gimuzan le Tempel hulosim gel asan ban tugwahtiq yaqay. Gwahtiqsa in mataw mani akabiyan emad osiyta na gigo mani wazbalan woqsa gigo ban inaqmo wazim tuwazbilbalmo. ");
INSERT INTO mlp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ad in mataw ah gizayad osiyta na gibilan, Ne nagah na bunmo giwaqeq asanib a lehiy ham. Ne ya imam ago bit emid in maket abitan nog hi iyan ham. ");
INSERT INTO mlp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Haqsa in ago disaipel gamuk araq God ago marib usaqta na anadin tiqemiy. Gamuk na bilam, Ya ningo bit ka inad diq ugsa ananin bilaqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ta teq Juda mataw aseseqta asor daq na ahol waqad in Yesus buloniy, Ni naga daqin azawayin inaqta giqisihunid i ahol waqad ginad emam, Ni daq kazaq emgo ni nibin inaq haqam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Haqan Yesus gibilan, Ne Tempel ka wol inerid kam ezeqmanmo aduganib ya wazid a ta eraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Haqanmo Juda mataw aseseqta na bilaqiy, Ulig 46 nazaq aduganib mataw Tempel ka wazan eraqsa teq kabiy a hi hiqiyaq haqiy. Ta ni kam ezeqmanmo aduganib wazid a ta eraqdaq e? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Naqmo Yesus inmo ahol anan bilaqad in bilam, Tempel ham. ");
INSERT INTO mlp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nazaq iyan abeb Yesus hodhod hulosim ta eramta nab in ago disaipel gamuk nawa in bilamta na anadin tiqemiy. Anadin emad in God ago gamuk anan helmo haqad teq in Yesus ago gamuk na anan helmo tihaqiymo. ");
INSERT INTO mlp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ari Yesus uliq Jerusalem-ub Pasova ago ahumabun ayahta nab osad in daq azawayin inaqta emsa on mataw kabemmo ahol waq yaqay. Ahol waqad in Yesus anan helmo tihaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ta teq Yesus in mataw na ginan helmo a hi haqyaq. Ad inmo ahol mataw na giholib a hi emyaqmo. Na ezaqgo in mataw bunmo gigo tuhurit bugta. ");
INSERT INTO mlp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Teq mat araq Yesus bulonan teq in mataw na gigo huritta nazaq a haiq. Haiqgam. Inmo anadibmo mataw bunmo gimugan ezaq usaqta na ago in tuhurit bugta. ");
INSERT INTO mlp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ari Farisi araq anan Nikodemus haqayta in osyaq. Mat na in Juda gigo mat marorta araq. ");
INSERT INTO mlp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","In taromab bolim Yesus tubulon, Tisa ham i ningo tuhurit ham. God ni ninaq osaqta ham. In ninaq a hi osid teq ni daq azawayin inaq emaqta nagan a hi em nag ham. Nazaq iyan i ginad emauq, God-mo niqeman ni bolim i suleq igaqta haqauq ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Haqan Yesus amenin emim bilam, Ya helmo nibilenaiq ham. Mat aw nog in zaway ulilibta na amalib gime gigerta mutur a ta hi gwahtiqeq in God ago maror aduganib le a hi gwahtiq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Haqan Nikodemus bilam, Mat nenqab tiqiyta ezaq toneq ame gigerta mutur a ta gwahtiqdaq? ham. In anen agemab a ta lehid anen a ta emdaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Haqan Yesus bilam, Ya helmo nibilenaiq ham. On mataw yuw teq God ago Bugaw ago zaway gimalib mutur a hi iyeq in God ago maror aduganib le a hi gwahtiq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","On mataw og kabta in onmin in gimo gihol nogta giqemayta ham. Sa God ago Bugaw in onmin inmo nogta giqemaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ya nibilenim bilay, Ni zaway ulilibta na amalib nime gigerta mutur a ta hi gwahtiqeq ni God ago maror aduganib le a hi gwahtiqdaq hayta na ago ni ninadnad hi em ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tim anadibmo saw bunmo lehaqta ham. Lehsa ni ahulanmo huritaqta ham. Huritad in ezaq bolta na teq in ezaq lehaqta na ago ni a hi huritaqta ham. Ari God ago Bugaw bolim mataw giqeman gimugan mutur iyayta na in nazaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Haqan Nikodemus bilam, Daq nazaqta na ezaq teq i giholib gwahtiqdaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","An Yesus bulon, Na ta ezaq? ham. Ni Isrel gigo tisa araq ham. Ezaq tonim ni nagah ka ago ninad a hi em hasaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ya helmo nibilenaiq ham. I nagah ginad tiqem hasta naqmo agamukan bilaqauq ham. Bilaqad i nagah gimeb ahol tuwawta naqmo ago i ne gibilenauq ham. Teq ne i gigo gamuk na gileh ugayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ya nagah og kabta ago gibilensa ne anan helmo a hi haqayta ham. Ta ezaq teq ya nagah Heven-ibta na ago gibilenid ne anan helmo haq daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mat araq Heven-ib a hi gwalahta ham. Haiq ham. Mat Atatin Heven hulosim hitimta naqmo amomo Heven ahol wamta ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Teq Moses kwaziqmo saw samantab nagah ahulinaqta adulan wazan eramta nazaqmo mataw in Mat Atatin wazid eraqeq titurdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Eraqeq tursa teq on mataw in ahol waqad anan helmo haq daqayta na bunmo in kayeqmo kuluwa-kuluwmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ari God in on mataw og saw bunmo ginan anad bilaqsa iyan in atatin amulikmo osta na tinag. In atatin negid mat aw nog atatin na anan helmo haq daqayta na bunmo a hi moq hasad in kayeqmo tuteqmo tuqos daqay haqad in nazaq amta. ");
INSERT INTO mlp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Na ezaqgo in atatin on mataw gilum kemeq giyon bilaqid moq daqay haqad in eman og kab a hi bol. Haiqgam. In anad am, Ya itatin leheq on mataw gimen dante wastitayid ya gilumsiheq giwaqid a hi moq daqay haqad in atatin eman bolta. ");
INSERT INTO mlp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nazaq iyan on mataw God atatin anan helmo haqayta na bunmo in God ameb dimunmo osayta. God in giyon bilaqan in moq hasgo a hi osayta. Ari on mataw God atatin anan helmo a hi haqayta na God in giyon tibilaqan in moq hasgo tiqiyim osayta. Na ezaqgo in God atatin amulik na anan helmo a hi haqayta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Teq God on mataw gilum kemim gigo daq amenin negaqta na alulin in kazaq. Saw anuwan og kab tugwahtim. Gwahtiqan teq on mataw saw anuwan na anan ginad a hi bilam. Haiqgam. On mataw na gigo daq bunmo meqin iyim iyan in romriqmo anan ginad bilam. ");
INSERT INTO mlp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Na ezaqgo on mataw daq meqinta emayta na in saw anuwan anan ginad a hi bilaqsa in saw anuwanib a hi gwahtiqayta, luweq in gigo daq meqinta nagan ulal iydaq haqad. ");
INSERT INTO mlp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ari on mataw daq helta emayta na in saw anuwan ahol waqad bolayta. In God anad muzinim daq emayta nagan ulal iydaq haqad in saw anuwanib nab bo tugwahtiqayta. ");
INSERT INTO mlp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ari daq na tihiqiyan Yesus ago disaipel nenaq saw Judiya gigo og araqab tilehiy. Lehim in saw nab luw osad teq in on mataw tuhuz negyaq. ");
INSERT INTO mlp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Sa Jon saw nagab on mataw tuhuz negyaqmo. Saw anan Ainon haqayta saw Selim agerab usaqta nab yuw ame ayahta usaqta iyan Jon nab luwyaqta. Kam nab Jon a hi irqursamo on mataw kabemmo bolsa in tuhuz negyaq. ");
INSERT INTO mlp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Teq Jon ago disaipel asor in Juda mat araq inaq an tumug yaqay. Na in Juda gigo daq araq in gihol huz ugim God ameb gihol abusirinan hiqiyaqta na ago ananin bilaqad an mug yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ad teq in bunmo Jon ago hib bolim tubuloniy, Tisa haqiy, Mat ni ninaq yuw Jodan aqurumun kozaq ban ossa ni anan bilamta na in on mataw tuhuz negaqmo haqiy. Sa on mataw bunmo inmo ago hib tilehay haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Haqan Jon gibilan, God mat abenab kabiy amta naqmo amomo in tiqemdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ya kwaziqmo ne gibilenim bilay, Ya Krais a haiq hay ham. God ya iqeman ya Krais ago danmeb bolta haqad ya bilay ham. Ya nazaq bilaqsa ne tuhuritiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mat aw wamta naqmo in aw na aduw diq ham. Teq mat na ayow in adek emim turad in ayow aw wamta na aqez huritad in anad ayahmo dimniyaq ham. Nazaq iyan muran ya inad tidimniy hasaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mat ko abin ayah tiqiydaq ham. Sa ya ibin amik iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ari Mat ulilib osim bolta naqmo in nagah bunmo gigo Iyahta iyim osaqta. Teq mat abe alulin og kab usaqta na in og kabta iyim iyan in og kaqmo ago nagahta anan bilaqaqta. Ari mat Heven-ib osim bolta na in nagah bunmo gigo Iyahta iyim osaqta. ");
INSERT INTO mlp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Osad in nagah ameb ahol wamta na teq in gamuk huritta naqmo in i gibilenaqta. Ta teq mataw in ago gamuk na anan helmo a hi haqayta. ");
INSERT INTO mlp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ari on mataw in ago gamuk huritim anan helmo haqayta na in kazaq i gibilenay. God gamuk heltaqmo bilaqaqta haqay. ");
INSERT INTO mlp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na ezaqgo God in ago Bugaw Dimunta ayahmo mat na ugim teq in eman bolim in God ago gamukmo diq bilaqaqta. ");
INSERT INTO mlp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Amam in atatin na anan anad diq bilaqsa in zaway bunmo atatin abenab tiqam. ");
INSERT INTO mlp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nazaq iyan on mataw God atatin anan helmo haqayta na in kayeqmo kuluwa-kuluwmo tuqos daqay. Ari mat God atatin ago gamuk othasaqta na in kayeqmo kuluwa-kuluwmo a hi osdaq. Haiqgam. God in mat naqanta agem meqinta ugsa in osaqta. ");
INSERT INTO mlp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Ari Farisi gamuk kazaq huritiy. Yesus mataw kabemmo yuwub gihuz negsa in ago disaipel tiqiyay haqiy. Sa Jon haiqgam haqiy. (Teq Yesus-mo mataw a hi gihuz negyaqta. Haiqgam. In ago disaipel naqmo mataw gihuz neg yaqayta.) Ari Yesus anad am, Mataw kabemmo yaqgo disaipel tiqiyiyta na ago Farisi tuhuritiy ham. Haqad in saw Judiya na hulosadmo in muleqim saw Galiliy-ib ta lah. ");
INSERT INTO mlp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Lehad dan in lehyaqta na saw Samariya-ib gwahtiqim lahta. ");
INSERT INTO mlp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nazaq iyan in dan na muzim lehim in Samariya gigo uliq araq anan Sikar haqayta na agerab tugwahtim. Uliq na in Jekob atatin Josep og ugta na agerab usaqta. ");
INSERT INTO mlp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Teq saw nab yay araq kwaziqmo Jekob yuw waqgo haqad yay tayta in nab usaqta. Sa Yesus bolad luwim zeq ayahtab 12 kilok nazaq tiqiyan in yuw yayibta nab gwahtiqim ahol husisiqsa anamur emad tuqos. ");
INSERT INTO mlp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ossa Samariya aw araq yuw soqornan tubol. Bolan Yesus bulonim bilam, Yuw soqoreq asitmo yagid uluwiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Na Yesus ago disaipel bunmo uliq Sikar-ib didaq zaynan tilehiy.) ");
INSERT INTO mlp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ari in bilam, Yuw yag uluwiq haqan Samariya aw na bulon, Ni Juda mat araq ham. Sa ya Samariya-ib awta ham. Ta ezaqgo ni bilaqaq, Yuw asit yagid ya uluwiq haqaq? ham. (Na ezaqgo Juda in Samariya nenaq an gihar ugad in garab a hi luw osayta iyan aw na nazaq bilam.) ");
INSERT INTO mlp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","In nazaq haqan Yesus amenin emim bilam, Ni God ago naw na ago a hi hurit kemaq ham. Teq mat kawa yuw uluwgo susumun nigaqta ka ago ni ninad a hi em hasaqmo ham. Ni nagah giger na ago huritta iyeq teq ni susumun ugid in yuw dimunta tutimmo gwahtiqad usaqta na nigid ni tuquluw nag ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","In nazaq haqan aw na bulon, Mat Iyah ham, ni nagah araq amalib yuw soqoreq yagdaqta na haiqgam ham. Ta yay ka sisaq diqmo ham. Ni yuw dimunta tutimmo gwahtiqad usaqta na edob waqdaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","I gises Jekob-mo yuw yayibta ka tay igta ham. Ad inmo ago onmin teq ago sipsip, bulmakau nenaqmo in yuw ka uluw yaqayta ham. Ta teq ni in uriyamaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Haqan Yesus amenin emim bulon, Mataw yuw yayibta ka uluwim teq in yuwnan a ta moqayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ari mat aw nog in yaqgo yuw ya negdaiqta na uluweq in yuwnan a ta hi moq daqay ham. Haiqgam ham. Ya yuw negdaiqta na in bilaqne yuw og aduganib tutimmo gwahtiqaqta nazaq nog in giholib usdaq ham. Yuw na mataw giduganib useq gwahtiqad giqemsa in kuluwa-kuluwmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Haqan aw na bulon, Mat Iyah ham, ni yuw na yagid uluwiq ham. Uluweq teq abeb ya yuwnan a ta hi moqad ya yuw soqornan kab a ta hi boldaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Haqan Yesus bulon, Ni le niduw buloneq inaq kab muleqeq ta boliy ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Haqan aw na amenin emim bilam, Ya iduw haiqta ham. An Yesus bulon, Ni bilam, Ya iduw haiq hamta na ni dimunmo bilam ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwaziqmo ni mataw abaynagin nazaq giwamta ham. Giwaqim teq ta mat muran ni inaq osaqta na in ni niduw diq a haiq ham. Ningo gamuk na in hel diqtaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Haqan aw na bilam, Mat Iyah ham, muran ya ningo tuhurit ham. Ni God ago nantut araq ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","I gisesan kwaziqmo garah kabmo humab woleq lotu em yaqayta ham. Ta teq ne Juda bilaqay, Uliq mataw lotu em daqayta na Jerusalem-mo haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","An Yesus bulon, Neng ham ya heltaqmo nibilenaiq ham. Abeb ne garah kab Gimam Iyahta ayon lotu a ta hi em daqay ham. Ad ne Jerusalem-ub leheq lotu a hi em daqaymo ham. Kam na tugwahtiqnan tonaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ne on mataw Samariya-ibta, ne nog diq ayon lotu emayta na ago ne ginad a hi em hasayta ham. Ari i Juda on mataw God ayon lotu emgo i ginad em hasauqta ham. Na ezaqgo ham God in on mataw gilumsiheq ta giwaqnan haqad in kabiy na alulin i Juda gigo hib eman gwahtimta ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Abeb on mataw Gimam Iyah ayon lotu hel diqta tiqemnan haqad teq in God ago Bugaw Dimunta ago hib zaway waqeq daq helta amalib lotu tiqem daqay ham. In nazaqmo Gimam Iyah ayon lotu emsa in ginan anad tibilaqdaqta ham. Kam na gwahtiqnan tonad teq in tugwahtimta nog tiqiyaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God in bugawta ham. Nazaq iyan mataw in ayon lotu emnan haqad in ago Bugaw Dimunta ago hib zaway waqeq teq in daq helta amalib lotu tiqem daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Haqan aw na bulon, Mesaya teq boldaqta na ago ya tuhurit ham. Mataw in anan Krais haqayta na ham. In boleq nagah bunmo ago i tigibilendaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Haqan Yesus bilam, Mat naqmo kawa ni ninaq gamuk tibilaqaq ham. Na yaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","In nazaq bilaqsa ago disaipel didaq zaynan lehiyta na muleqim ta boliy. Bolimmo Yesus aw na inaq gamuk bilaqsa in gibiyad ginadnad tiqem yaqay. Ta teq in Yesus susumun ugim bilaqiy, “Aw ka naga waqnan?” teq “Nagaqgo ni aw ka inaq gamuk emaq?” nazaq in a hi susumun ugiy. ");
INSERT INTO mlp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ari aw na in ago yuqsan nab hulosan ussamo in muleqim aquliqab tilah. Lehim in mataw tigibilan, Ne bo leheq mat ko ahol waqiy ham. Ya kwaziqmo daq giqemta nagan bunmo ago in ya tiqibilen bug ham. Luweq mat na in Krais-mo iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Haqan mataw bunmo era uliq na hulosadmo in Yesus ahol waqnan ago hib tilehiy. ");
INSERT INTO mlp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ari aw na le ago walmataw gibilenad luwsa disaipel Yesus buloniy, Tisa haqiy ni didaq ka araq neq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Haqan Yesus gibilan, Yaqgo didaq inaq ham. Teq ne yaqgo didaq na ago ginad a hi em hasay ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","In nazaq haqan disaipel an bulonim bilaqiy, Nabag mat araq in ayon didaq a bolim tuqug daqagya haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Haqan Yesus gibilan, Yaqgo didaq na in kazaq ham. Ya mat iqeman bolta na anad muzad ago kabiy emid hiqiy bugdaqta naqmo in yaqgo didaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ne bilaqay, Didaq kabiyab teqmo zilimaq haqay ham. Kalam aweweqmo hiqiyid teq i tayam haqay ham. Ta teq yaqmo kazaq gibilendaiq ham. Ne gime rireqeq saw ahol waq kemiy haqaiq ham. Didaq kabiyab tizilim bugim usaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mat didaq anon tayaqta na in kabiy emad anawun waqaqta ham. Teq in didaq anon ginuwan osayta na dimunmo kuluwa-kuluwmo tuqos daqay ham. Ossa mat didaq layta na teq mat didaq tayta na in giger gigo kabiy anon na gibiyad in araqibmo ginad dimniysa osayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nazaq iyan gamuk araq mataw bilaqad luwayta na in heltaqmo ham. In bilaqay, Mat araq didaq leyaqta haqay ham. Leyan ta mat araq bolim didaq na tayaqta haqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ya ne giqeman ne didaq anon gitaynan lehiyta ham. Didaq na ne akabiyan a hi emiyta ham. Haiqgam ham. Mataw ta asor kwaziqmo didaq na akabiyan tiqemiyta ham. Eman ne mataw na gigo kabiy ahaqenib lehim ne in gigo kabiy asor tiqemaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ari aw na bilam, Mat na yaqgo daq bunmo ya emad luwta na ago tiqibilen bug ham. Haqsa Samariya on mataw uliq nab osiyta na kabemmo in aw na ago gamuk huritim Yesus anan helmo tihaqiy. ");
INSERT INTO mlp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Haqad in Yesus ago hib lehim in nenaq osgo haqad buloniy. Bulonan Yesus uliq nab kam gigermo a ta os. ");
INSERT INTO mlp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ossa mataw kabemmo Yesus ago gamuk huritad in helmo diq tihaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Haqad in aw na bulon yaqay, Mebmebmo ninmo mat ka ago gamuk huritim a bolim gibilenan i huritim anan helmo hawta haq yaqay. Ari muran igmo diq in ago gamuk huritim i in ago tuhurit kemauq haq yaqay. Hurit kemad i ginad emauq, Mat on mataw bunmo gilumsiheq gimen dante emdaqta na amatin diq kawaqmo tubol haqauq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ari Yesus Samariya on mataw na nenaq kam gigermo osim tihiqiyan in uliq na hulosadmo saw Galiliy-ib tilah. ");
INSERT INTO mlp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Na ezaqgo Yesus inmo tekomo tibilam, God ago nantut ago uliqabmo diq in ahol abin haiqta hamta na ago.) ");
INSERT INTO mlp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ari in le saw Galiliy-ib tugwahtiqan Galiliy-ib mataw na Yesus ahol waqad in gigem dimunta ugad tuwaziniy. Mataw na Jerusalem-ub Pasova ahumabun ayahta nab lehim in Yesus kabiy daq bunmo emsa ahol waqiyta. Nazaq iyan Yesus in gigo hib bolan in ginad tidimniyiy. ");
INSERT INTO mlp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sa teq Yesus eraqim le uliq Kana saw Galiliy-ibta nab a ta gwahtim. Uliq nabmo in yuw diq buliyan wain ayun iyta. Ari kam nab king ago gavman mat araq uliq Kapaneam-ub os. Ossa in ago amun matta araq moqad us. ");
INSERT INTO mlp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ussa mat na Yesus saw Judiya hulosim saw Galiliy-ib bolta na ago huritim in Yesus ago hib tilah. Lehim in Yesus waqeq inaq Kapaneam-ub leheq ago amun wastitaygo haqad tubulonyaq. Na ezaqgo in ago amun tumoqnan diq tonyaqta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sa Yesus bulon, Ne daq azawayin inaqta amo amo ahol a hi waqeq ne ya inan helmo a hi haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Haqan mat marorta na bilam, Iyahta ham ni hidmo gewoq ham. Luweq yaqgo amun moqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Haqan Yesus bulon, Ni muleqeq ta leh ham. Ningo amun kayeqmo dimunmo osaq ham. Haqan maror na Yesus ago gamuk anan helmo haqadmo in muleqim tilah. ");
INSERT INTO mlp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Lehad in ago uliqab le a hi gwahtiqsamo ago kabibiy mataw bolim danib ahol waqadmo buloniy, Ningo amun kayeqmo dimunmo osaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Haqan mat marorta na tisusumun nag, Zeq adulan ganim diqtab amun ahol hastitay nog iy? ham. Haqan in bilaqiy, Irimo zeq ayahtab wan kilok nazaq asan afanfan iyyaqta na ahol tiyuh haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Haqan amun na amam anad tiqam, Irimo zeq adulan nabmo diq Yesus bilam, Ningo amun kayeqmo dimunmo osaq haqad in bilamta ham. Haqad in Yesus anan helmo tiham. Haqsamo ago on mataw in inaq osiyta na bunmo Yesus anan helmo tihaqiymo. ");
INSERT INTO mlp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na Yesus in saw Judiya hulosim bo saw Galiliy-ib osad in daq azawayin inaq ame gigerta amta. ");
INSERT INTO mlp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Daq na abeb Juda gigo lotu akaman araq ayahta tugwahtim. Gwahtiqan Yesus uliq Jerusalem-ub tugwalah. ");
INSERT INTO mlp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Teq uliq Jerusalem agelin ago dan ez araq anan Sipsip Gigo Dan Ez haqayta na agerab yuw akurorqanta araq usaqta. Hibru nanib in yuw na anan Betesda haqayta. Teq yuw na aqurumnib baybay abaynagin nazaqmo turyaqta. ");
INSERT INTO mlp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Baybay nagab mataw gigo moq inaqta kabemmo gime haiqta teq gisen meqinta teq gibensen tumomta nagan in nab os yaqayta.  ");
INSERT INTO mlp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ossa Iyahta ago angelo boleq yuw na amalib hitiqeq yuw baysa ahol wolyaqta. Ahol wolsa mat nog danmeb yuw nab hitiqeq huzad teq inmo amomo ago moq hiqiysa in ahol tidimniyyaqta. ");
INSERT INTO mlp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Teq mat araq ago moq ulig 38 nazaqmo aholib usta in nab tuqos. ");
INSERT INTO mlp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ossa Yesus bolim mat na ahol waqad anad tiqam, Mat ka kam sisaqmo diq moqad osta ham. Haqad in bulon, Ni nihol dimniynan ninad bilaqaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Haqan mat moqaqta na bilam, Mat ayah ham yuw ahol wolsa mat araq hidmo ya iwaqeq iqad yuwub hitiqdaqta na haiqgam ham. Nazaq iyan ya kiskismo tiqad luwsamo mat araq iquriyamim hidmo le danmeb yuwub hitiqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Haqan Yesus bulon, Ni eraqeq ningo us ban soreq a leh ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Haqan muran diq nawaqmo mat na ahol tidimniyan in era ago us ban sorim ad tilah. Ari kam na in Juda gigo lotu akaman. ");
INSERT INTO mlp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nazaq iyan mat ahol dimniyta na ago us ban sorim ad tilehsa Juda mataw aseseqta asor tubuloniy, Muran i gigo lotu akaman haqiy. Nagaqgo ni ningo us ban na sorim a lehaq? haqiy. Ni kam ka ago gunun tiqitiyonaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Haqan mat na amenin emim bilam, Mat ya ihol wastitayan dimniyta naqmo ibilenim bilam, Ningo us ban soreq a leh haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Haqan Juda mataw na tisusumun ugiy, Mat ni nibilenim bilam, Ningo us ban soreq a leh hamta na nog diq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Haqan mat ahol dimniyta na in nog diq dimun tonta na a hi hurit. Na ezaqgo mataw kabemmo nab tursa Yesus daq na tiqemimmo in gilikmanib gwahtiqad tilahta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Abeb Yesus mat na Tempel-ib ossa ahol waqad bulon, Ahol waq ham. Ni nihol tidimniy ham. Muran ni daq meqinta araq ta hi em ham. Luweq daq ta araq meqin diqta niholib gwahtiqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","An mat na lehim in Juda mataw aseseqta na gibilenim bilam, Mat ya iwastitayta na in Yesus-mo ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","In nazaq haqan Juda mataw aseseqta na Yesus muzad luwad in wadad nan tuqug yaqay. Na ezaqgo Yesus in Juda gigo lotu akamnib daq nazaqta emyaqta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sa Yesus gibilan, Ya imam kam bunmo kabiy emim emim bo muran kawa in tiqem tutaq ham. Emsa ya inaqmo kabiy tiqemaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","In nazaq haqan Juda mataw aseseqta na ginad emiy, Mat ka in God anan ya imam haqaq haqiy. Bilaqne in God-mo nog haqiy. Haqad in Yesus lotu akaman ago gunun itiyonsa ahol waqad teq in Yesus ago gamuk na huritad in Yesus wol emid moqgo adanteqin tinagun naqmo hiqiy yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ari Yesus in Juda mataw na gibilan, Ya helmo ne gibilenaiq ham. Mat Atatin anadibmo daq araq a hi emaqta ham. In amam daq emsa ahol waqad in daq naqmo emaqta ham. Na ezaqgo amam daq emsa in Atatin daq nazaqmo emaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Amam in Atatin anan anad bilaqsa in kabiy daq bunmo emaqta na in atatin isihunaqta ham. Nazaq iyan in daq aseseqta atatin tiqisihundaqmo ham. Isihunid Atatin in daq aseseqta na emsa ne ahol waqad gihol riten lamdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Amam in mataw tumoqiyta giwazan eraqsa in giqeman kayeqmo osayta ham. Ad nazaqmo diq Atatin in anadibmo on mataw in ginan anad bilaqaqta na giqeman kayeqmo osaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Amam in mat araq ago daq a hi ulum kemaqta ham. Haiqgam ham. In kabiy na Atatin abenab eman Atatinmo on mataw gilum kemaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nazaq iyan mataw Amam wazinayta nazaqmo in Atatin tuwazin daqaymo ham. Amam in Atatin eman bolta ham. Nazaq iyan on mataw Atatin a hi wazinayta na in Amam a hi wazinaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ya helmo ne gibilenaiq ham. Mat yaqgo gamuk huritim teq in mat ya iqeman bolta na anan helmo haqaqta, mat naqanta in os kayeqmo tutimmo osayta na tuwaqim osaq ham. Osad in teq God ago hazizirib turad nan araq a hi waqdaq ham. Haiqgam ham. In moqdaqta atowun tuhulosim in kayeqmo dimunmo osaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ya helmo ne gibilenaiq ham. On mataw tumoqiyta na in teq God Atatin aqez tuhurit daqay ham. Huritad in gilikmanib mataw in aqez waz daqayta na bunmo eraqeq kayeqmo tuqos daqay ham. Kam na tugwahtiqnan tonaqta teq in tugwahtimta nog tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Amam in mataw giqemid kayeqmo osgo azawayin inaqta ham. Teq in zaway na atatin ugan in nazaqmo mataw giqemid kayeqmo os daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Teq atatin na in Mat Atatin iyim iyan Amam in zaway ugan in Amam abinib mataw gilum kemeq gigo daq amenin tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ya kazaq bilaqsa ne ginadnad hi emiy ham. Abeb mataw hodhodab usayta na bunmo God Atatin aqez tuhurit daqay ham. Huritadmo in hodhod huloseq tugwahtiq daqay ham. Mataw daq dimdimunta emad osiyta na eraqeq kayeqmo kuluwa-kuluwmo tuqos daqay ham. Sa mataw daq meqmeqinta emad osiyta na eraqeq hazizirib turad in gigo daq na amenin tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ya daq araq inadibmo emgo haiq ham. Ya imam ibilensa ya mataw gigo daq gilum kemaiqta ham. Gilum kemad ya a hi katiyad mataw ginan titnonimmo bilaqaiqta ham. Na ezaqgo yaqmo inad muzinim kabiy na a hi emaiqta ham. Ya mat iqeman bolta naqmo anad muzinad mataw gilum kemaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ya imomo ihol anan gibilendaiqta na in daq helta a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Teq mat ta araq ya ibin gibilenaqta na in nawa osaq ham. Ya inad emaiq, Mat na ya inan helmo diq bilaqaqta haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kwaziqmo ne mataw giqeman in Jon ago hib lehiy ham. Lehan Jon in ya inan gamuk helta gibilanta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Helmo, ya matmo ago hib ibin waqgo hulosaiqta ham. Teq ne Jon ago gamuk na anadin emad ne ginad buliyeq a hi moq daqay haqad in ya inan bilamta na ago ya ne gibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon in bilaqne lam araq oyad anuwan ayahmo leh nog iyyaqta ham. Sa ne Jon ahol anuwanib kam asor ginad dimniysa osnan ginad bilamta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ari teq nagah araq Jon ago gamuk uriyamta na in ya inan ne gibilen sireqaqmo ham. Na in kabiy God ya ibenab amta naqmo ham. Ya kabiy na emid hiqiy bugdaq haqad ya imam ibenab amta ham. Eman ya kabiy na emsa kabiy naqmo ya ihol alulin eman ulal iyaq ham. Kabiy na ya inan bilaqaq, Gimam Iyah ya iqeman bolta haqaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Teq ya imam iqeman bolta na in inaqmo ya inan tibilammo ham. Ne in aqez asit a hi huritim ne in anobun asit ahol a hi waqiymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Teq in ago gamuk ne gigemab a hi usaq ham. Na ezaqgo in mat ne gigo hib eman bolta na ne anan helmo a hi haqiyta na ago ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ne ginad emay, God ago marib gamuk usaqta na in i giqemid i dimunmo kuluwa-kuluwmo tuqosam haqayta ham. Haqad ne gamuk na ahol waqad alulin nagunayta ham. Ta teq mar naqmo in ya inan ne gibilen sireqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Gibilen sireqsa teq haiq ham. Ne yaqgo hib boleq God ago os dimunta waqnan hulosmo diq hulosayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mataw ya ibin iluwsa ya hulosaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Teq ya ne gigo tuhurit ham. Ne God anan ginad a hi bilaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ya imam abinib bolan ne ya ibaymuzayta ham. Ari mat ta araq inmo ahol abinib bolid ne waqeq inaq tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ne an abin iluwad ginad dimniysa osayta ham. Osad ne gibin dimunta God amulikmo osaqta na ago hib waqnan ginad a hi emayta ham. Nazaq iyan ezaq teq ne yaqgo gamuk anan helmo haq daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ya teq imam anognib turad ne gimalib nan emdaiqta nazaq ne ginad hi emiy ham. Mat ne gimalib nan emdaqta na in Moses-mo ham. Ne Moses anan bilaqay, In God ago hazizirib i gisen baysiheq tigilumsihdaq haqayta ham. Teq haiq ham. Mat naqmo teq ne gimalib nan tiqemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ne Moses ago gamuk anan helmo haqeq ne yaqgo gamuk anan helmo tihaq nagiymo ham. Na ezaqgo in gamuk mar tonta na in ya inan bilamta ham. ");
INSERT INTO mlp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ne gamuk Moses ya inan mar tonta na anan helmo a hi haqeq, ezaq teq ne yaqgo gamuk anan helmo haq daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ari gamuk na tihiqiyan abeb Yesus yuw-kurorqan Galiliy aqurumun kozaq ban tilah. Yuw akurorqan na anan araq Taiberiyas haqayta. ");
INSERT INTO mlp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lehsa on mataw dauh biyahmo in muzim inaq tilehiy. Na ezaqgo Yesus mataw moqayta gigo hib daq aseseqta emsa in ahol waq yaqayta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Teq Yesus le garah araqab gwalehim in ago disaipel nenaq nab tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kam nab Juda gigo lotu akaman ayah diqta anan Pasova haqayta na bolim sinsin tiqiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ari Yesus osim ame wole mataw dauh biyahta na agerab gabolsa in tigibiy. Gibiyad in Filip bulon, I teq edob didaq gizayeq on mataw ko negid neq daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na in Filip ulum waqad nazaq bulon. Inmo daq ezaqta emdaqta na in tekomo anad tiqam. ");
INSERT INTO mlp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","An Filip amenin emim bilam, I bret 200 kina ago zayid in on mataw dauh biyahta ko inaq diq a hi iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Haqsa Yesus ago disaipel ta araq Saimon Pita amikqan Andru in era Yesus tubulon, Amun araq ago bali bret abaynaginmo teq nabiq gigermo inaq kawa osaq ham. Teq didaq asitmo na in on mataw kuluwmo kozaq ko inaq a hi iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","In nazaq haqan Yesus bilam, On mataw gibilenid in os woqeq osiy ham. Saw nab sisihun dimunta amalib osgo asawan dimunta usta. Nazaq iyan mataw na bunmo nab tuqos woqiy. Teq mataw biyahta na in kabemmo diq 5,000 nazaq. ");
INSERT INTO mlp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","On mataw na os woqim ossa teq Yesus in bret waqim God esey ugim in mataw na tinag. Negad in nabiq giger na waqim nazaqmo ton. An on mataw bunmo ginadibmo didaq na neqan tigiyunin bug. ");
INSERT INTO mlp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mataw na didaq dimunmo tineqan teq Yesus in ago disaipel gibilan, Bret asugin abeyanta na bunmo ginuweq tuwal emiy ham. I abu hi ulumuq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Haqan disaipel lehim bali bret abaynagin on mataw neqim abeyan hulosiyta na in tuwal emim kuram 12 nazaqmo tigisiheniy. ");
INSERT INTO mlp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kam nab on mataw daq azawayin inaqta na ahol waqim bilaqiy, Helmo haqiy, God ago nantut og kab boldaqta na amatin kawaqmo tubol haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Haqsamo Yesus in ginad na huritim in anad tiqam, On mataw ka giwaz meqniyeq boleq in ya iwazeq in gigo king iqem daqay haqad in amomo garah abigmanib tugwalah. ");
INSERT INTO mlp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ari imisor diq ni nog ya nog tiqiyan Yesus ago disaipel yuw-kurorqan Galiliy-ib wole tihitiqiy. Hitiqim saw romriq tiqiyan Yesus in gigerab a hi gwahtiqsamo in muyib gwalim yuw urotim uliq Kapaneam-ub tilehiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lehad luwsa tim ayahta eraqad kamis wolsa ayahmo tiqeraqyaq. ");
INSERT INTO mlp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Eraqsa disaipel giholtuw bulad muy hureqim le 5 o 6 kilomita nazaq tiqiyanmo Yesus yuw amalib bayim bayim muy agerab bolsa in ahol tuwaqiy. Ahol waqadmo in tirab yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Rabsa Yesus gibilan, Ne hi rabiy ham. Ka yaqmo lehaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Haqan disaipel ginad dimniysa Yesus waqim muyib emad hid naqmo in uliq leh yaqayta nab tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ari tarom iyim saw tihastitayan on mataw Yesus gihulosan yuw aqurumun kozaq ban osiyta na in Yesus asawan waqad teq in ginad tiqemiy, Irimo muy amulikmoqmo kab usta haqiy. Teq Yesus ago disaipel muy nabmo gwalsa Yesus a hi gwal haqiy. Disaipel gimomo muyib gwalim tilehiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","In nazaq haqad ossamo mataw ta asor uliq Taiberiyas-ibta na gimuyin inaq bolim Iyahta bret waqim God esey ugan mataw neqiyta na asawnib tugwahtiqiy, mataw biyahta na gigerab. ");
INSERT INTO mlp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Gwahtiqan on mataw nab osiyta na in Yesus ago disaipel nenaq saw nab a hi gibiyad in Taiberiyas gigo muy nagab gwalim Yesus nagunim uliq Kapaneam ban tilehiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Lehim in yuw urum kozaq ban Yesus ahol tuwaqiy. Ahol waqad in tubuloniy, Tisa haqiy ni gineh diq kab bol? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Haqan Yesus gibilan, Ya helmo gibilenaiq ham. Ya irimo daq emta na alulin diq ne ahol waq kemim teq inagunayta nazaq a hi haiq ham. Ne bret neqim gigem aseseq iyiyta naqmo ago ne ya inagunay ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ne didaq lilihaqta na akabiyan hi emiy ham. Ne didaq mataw neqim kuluwa-kuluwmo osayta naqmo akabiyan ne emiy ham. Didaq na Mat Atatin inmo teq tinegdaq ham. Na ezaqgo amam God in Mat Atatin na anan bilam, Mataw bunmo gilikmanib ya ni nibiysa ni nimomo yaqgo kabiy na tiqem bugdaq haqad in bilam ham. Nazaq iyan Mat Atatin inmo teq didaq a hi lilihaqta na tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Haqan on mataw na tisusumun ugiy, Ta i ezaq toneq teq God ago kabiy na emam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Haqan Yesus gibilan, Ne mat God eman bolta naqmo anan helmo haqiy ham. God ago kabiy nawaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Haqan mataw na buloniy, Kwaziqmo i gisesan saw samantab osad in manna bret neq yaqayta haqiy. God ago marib gamuk nazaq bilam haqiy. In bilam, God Heven-ib bret eman woq negan in neqiy ham haqiy. Ta teq ni i gimen naga kabiyan diq tiqem igdaq? haqiy. Ni naga daqin azawayin inaqta emid i ahol waqeq teq i ni ninan helmo haqam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Haqan Yesus bilam, Ya heltaqmo ne gibilenaiq ham. Moses-mo bret diq Heven-ib hitimta na a hi nag ham. Ya imammo in Heven-ib bret diqta na eman woq negaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bret diq God ago hib bolaqta na in Heven hulosim gewoqan on mataw neqad in gihol kayeq iyad kuluwa-kuluwmo osayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Haqan mataw na buloniy, Mat Iyah haqiy bret naqmo tuteqmo ig haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Haqan Yesus gibilan, Bret diq on mataw neqad gihol kayeq iyim kuluwa-kuluwmo osayta na in yaqmo ham. Mat aw nog in yaqgo hib bolayta na in gigemnan a ta hi moq daqay ham. Ad mat aw nog ya inan helmo haqayta na in yuwnan a ta hi moq daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ya ne gibilenim bilay, Ne ya tiqibiyiyta teq ne ya inan helmo a hi haqay haqad ya bilay ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","On mataw ya imam giyagta na in yaqgo hib tubol bug daqay ham. Bolsa ya a hikidik gimuzdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na ezaqgo yaqmo inad muznan haqad ya Heven hulosim a hi gewoy ham. Ya imam iqeman bolta naqmo anad muznan haqad ya gewoyta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Teq mat ya iqeman bolta na ago anad in kazaq ham. Ya on mataw in giyagta na gigo araq diq a hi hulosad kam abebtanta nab ya on mataw na bunmo giwazid tiqeraq daqay haqad in anad usaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ya imam anadmo diq on mataw in atatin ahol waqad anan helmo haqayta na bunmo in os dimunta kuluwa-kuluwmo osayta na giholyon tuwaq daqay haqaq ham. Teq kam abebtanta nab ya in giwazid tiqeraq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ari Yesus bilam, Bret diq Heven-ib gewomta na in yaqmo haqan Juda mataw aseseqta na in anan gigem meqniysa nan kabemmo kazaq bilaq yaqay, ");
INSERT INTO mlp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mat ka in Josep-mo atatin Yesus a haiq e? haq yaqay. I in anen amam gigo tuhuritta haq yaqay. Ta ezaqgo in bilaqaq, Ya Heven hulosim ogib gewoyta haqaq? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Haqsa Yesus gibilan, Ne an bulonad nan kabemmo hi bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mat araq anadibmo yaqgo hib a hi boldaq ham. Ya imam iqeman bolta naqmo in on mataw gihureqsa teq in yaqgo hib tubol daqay ham. Bolid teq kam abebtanta nab ya in giwazid tiqeraq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","God ago nantut gamuk araq kazaq mar toniy ham. Gamuk na bilam, God-mo teq on mataw bunmo suleq tinegdaq haqad in bilam ham. Nazaq iyan on mataw ya imam ago hib suleq waqad ago nan huritayta na bunmo in yaqgo hib bolayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mat araq diq Gimam Iyah ahol a hi wam ham. Mat God ago hib osim bolta naqmo in ahol tuwamta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ya helmo gibilenaiq ham. Mat aw nog ya inan helmo haqayta na in os kayeqmo kuluwa-kuluwmo osayta na tuwaqim osayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Bret mataw neqim kayeqmo kuluwa-kuluwmo osayta na yaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kwaziqmo ne gisesan saw samantab luw osad in manna bret neq yaqayta ham. Neqad teq in oseqmo tumoq yaqayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ari bret Heven hulosim ogib gewomta na in lul araq diqta ham. Mataw bret na neqeq in a hi moq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Bret mataw neqim kuluwa-kuluwmo osayta na yaqmo ham. Ya Heven-ib osim og kab gewoyta ham. Gewoqan mat aw nog bret na neqeq in kayeqmo kuluwa-kuluwmo tuqos tut daqay ham. Ari bret ya on mataw og kabta negid in neqeq kuluwa-kuluwmo os daqayta na in ya inon ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesus nazaq haqan Juda mataw aseseqta na in gimo an mugad in gamuk na alulin nagunad kazaq an bulon yaqay, Mat ko ezaq toneq teq in anon igid i neqam? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Haqsa Yesus gibilan, Ya helmo ne gibilenaiq ham. Ne Mat Atatin anon a hi neqeq teq ne in anedan a hi uluweq ne kayeqmo kuluwa-kuluwmo a hi os daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","On mataw ya inon neqad teq in ya inedan uluwayta na in os kayeqmo kuluwa-kuluwmo osayta na tuwaqim osayta ham. Ossa kam abebtanta nab ya in giwazid tiqeraq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Na ezaqgo ya inon in didaqmo diq ham. Teq ya inedan in nagah uluwgo diqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","On mataw ya inon neqad teq in ya inedan uluwayta na in yaqgo hib ossa ya in gigo hib osaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ya imam kayeqmo osaqta na iqeman bolta ham. Bolim ya imam ago zawayib kayeqmo osaiqta ham. An nazaqmo mat ya inon neqeq in yaqgo zaway amalib kayeqmo tuqosdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ya bret negdaiqta na in Heven hulosim gehitimta ham. Kwaziqmo i gisesan bret kaitab womta na neqiy ham. Neqim teq in osimmo tumoqiyta ham. Ari ya bret negdaiqta na in bret kwaziqta na nog a haiq ham. Mat yaqgo bret na neqeq in kayeqmo kuluwa-kuluwmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ari Yesus uliq Kapaneam-ub Juda gigo bit humab wolayta nab osad in on mataw suleq negim gamuk kawa ka gibilan. ");
INSERT INTO mlp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ari Yesus ago disaipel kabemmo gamuk na huritim bilaq yaqay, Gamuk na in afaqan diq haq yaqay. Nog teq gamuk na huritdaq? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Haqsa Yesus anad tiqam, Yaqgo disaipel gamuk na huritim nan kabemmo bilaqay ham. Haqad in tisusumun nag, Ne yaqgo gamuk na huritim ne ginad helta hulosnan tonay ye? ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nazaq iyid teq abeb Mat Atatin in kwaziqmo ulilib ostab nab muleqeq ta gwalehsa ne ahol waqad teq ne ginad ezaq em daqay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","I giwitan in i gisan zaway ugsa i kayeqmo osauqta ham. I gisan in i giwitan ulumsihgo zaway haiqgam ham. Gamuk kawa ya negaiqta ka in ne giwitan ulumsihsa ne kayeqmo osayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Teq ne gilikmanib mataw asor ya inan helmo a hi haqayta ham. Yesus mebmebmo ago kabiy alulin tiqemad in mataw helmo a hi haqayta na gigo tuhurit. Teq mat in waqeq bab gibenab emdaqta na ago in tuhuritmo. Na ago in bilam, Ne gilikmanib mataw asor ya inan helmo a hi haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Haqad in bilam, Ne gilikmanib mataw asor ya inan helmo a hi haqayta naqmo ago ya gibilenim bilay, Ya imam mat araq anad emid a hi hastitayid mat na yaqgo hib a hi boldaq hayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","In nazaq bilaqan mataw kabemmo Yesus muzeq inaq leh yaqayta na gihol buliyim in muleqim gigo uliqab tilehiy. Lehim in Yesus inaq a ta hi luw yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nazaq iyan Yesus in ago disaipel 12 na gibilan, Ne inaqmo ya ihuloseq leh daqaymo ye? ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Haqan Saimon Pita amenin emim bulon, Iyahta ham i ni nihuloseq nog ago hib leham? ham. Ninmo ningo gamuk amomo in mataw giqeman kayeqmo kuluwa-kuluwmo osayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","I ningo tuhuritim i ginad emauq, Helmo ni God ago mat tawon diqta naqmo haqauq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Haqan Yesus nan na amenin emim gibilan, Yaqmo ne mataw 12 na iholyon gilumim giwayta ham. Ta teq ne gilikmanib araq in bilaqne Satan nog osaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na in Saimon uliq Kariyot-ibta atatin Judas ayon gamuk na bilam. Mat na in disaipel 12 na gigo araqta. Teq abeb in Yesus waqeq bab gibenab emdaqta na ago Yesus in anan nazaq bilamta. ");
INSERT INTO mlp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Abeb Yesus saw Galiliy-ibmo tiluwyaq. Na ezaqgo Juda mataw aseseqta na in Yesus wol emid moqnan ginad emad adanteqin nagunsa iyan Yesus saw Judiya gigo saw ban luwnan atuw hiqiyyaq. ");
INSERT INTO mlp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ari Juda gigo lotu akaman araq ayahta anan Gisesan Baybay Emim Osiyta haqayta na akamun bolim sinsin tiqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nazaq iyan Yesus amikqaniz in Yesus bulonim bilaqiy, Ni uliq ka huloseq saw Judiya-ib leh haqiy. Leheq ni kabiy emsa ningo disaipel ahol waq kemiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mat ahol abin emid ayah iynan anad bilaqaq na in ulilemim ago kabiy a hi emaqta haqiy. Ni kazaq daq amo amo emnan ninad bilaqsun ni leheq on mataw bunmo gimeb emsa in ahol waqiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Na Yesus amikqaniz inaqmo in Yesus anan helmo a hi haqad iyan in nazaqmo bilawuniy.) ");
INSERT INTO mlp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","In nazaq haqan Yesus gibilan, Ya inadibmo a hi luwaiqta ham. Ya ibin ayahta waqdaiqta akaman teqmo bolaq ham. Ari ne ginadibmo luw daqayta akaman tutimmo usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","On mataw God gileh ugayta na in gigem meqinta ne a hi negayta ham. Ari ya mataw na gigo daq anan meqin haqsa in gigem meqinta ya yagayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Negmo leheq humab ayahta na ahol waqiy ham. Yaqgo kam a hi gwahtiqsa iyan ya humab nab a hi lehdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","In nazaq haqad saw Galiliy-ibmo tuqos. ");
INSERT INTO mlp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ossa in amikqaniz lotu akaman ayahta na ahumabnib tilehiy. Lehsa Yesus osim abeb teq tilahmo. Lehim in ulalab mataw gimeb a hi gwahtim. Haiqgam. In le ulilemadmo luwyaq. ");
INSERT INTO mlp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Luwsa Juda mataw aseseqta na in humab nab Yesus nagunad bilaq yaqay, Mat na edowa? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sa on mataw biyahta na in gimo an bulonad gamuk kabemmo bilaq yaqay. Asor bilaq yaqay, Mat na in dimunta haq yaqay. Sa asor bilaq yaqay, Haiq haq yaqay. In on mataw kat negaqta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Haqad teq mat araq diq Yesus anan ulalab a hi bilaqyaq, in Juda mataw aseseqta na girabunad iyan. ");
INSERT INTO mlp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ari humab ayahta na le liqabmo tiqiyan teq Yesus Tempel-ib lehim on mataw suleq tinegyaq. ");
INSERT INTO mlp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Samo Juda gigo mataw aseseqta na Yesus ago gamuk huritim in gihol turuh nemsa bilaqiy, Mat ka i gigo hib suleq a hi wamta haqiy. In ezaq tonim gamuk awaz meqin kazaq ka in anadib usaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","In nazaq haqsa Yesus in gigo gamuk amenin emim gibilan, Ya gamuk gibilenaiqta ka in yaqgo gamuk a haiq ham. Mat ya iqeman bolta naqmo ago gamukta ya ne gibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","On mataw God anad muznan giwaz meqniyayta na in yaqgo gamuk ka huritad in ginad tiqem has daqay ham. Ginad em haseq in ya inan bilaq daqay, Mat na anadibmo gamuk a hi bilaqaqta haq daqay ham. In God-mo ago hib gamuk waqim teq bilaqaqta haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mataw in gimo gihol abinib gamuk bilaqayta na in gihol abin emid ayah iygo haqad in bilaqayta ham. Ari mat in mat ta araq in eman bolta naqmo abin emid ayah iygo haqad gamuk bilaqaqta, mat naqmo in gamuk helta bilaqaqta ham. Mat naqanta aholib daq katiyta araq a hi usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kwaziqmo Moses in God ago maror waqim ne nagta ham. Teq ne gilikmanib mat araq diq maror na ago gunun a hi muzin bugaqta ham. Nagaqgo ne ya inol emnan ginad emay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Haqan on mataw biyahta na bilaqiy, Nog ninol emnan bilaqaq? haqiy. Bugaw meqinta niholib ussa ni nazaq bilaqaqya haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Haqan Yesus gibilan, Ya daq azawayin inaqta amulikmoqmo eman ne bunmo ginad kabemmo emay ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ne gihol abatan asan urotgo adan giqisihunta ham. Helmo daq na in Moses ago hib a hi gwahtim ham. Na in i gitormagniz gigo hib gwahtimta ham. Teq Moses ago marorib daq na agamukan ussa ne muzinad lotu akamnibmo ne amun matta asan urotayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moses ago gunun aduganib gamuk bilam, Amun matta gwahtiqid ago kam 8 nazaq tihiqiyid teq ne ahol abatan asan tuqurot daqay haqad in bilamta ham. An muran ne gigo amun matta araq gwahtiqim ossa ago kam 8-ta na lotu akamnib tugwahtiqan ne lotu akaman ago gunun na anadin a hi emad ne amun asan urotmo urotayta ham. Luweq ne Moses maror nagta na itiyon daqay haqad ne nazaq emayta ham. Ari ne lotu akamnib amun asan urotayta ham. Ta teq doh haqad ya lotu akamnib mat moqad osta na ahol bunmo wastitayan ne gigem meqinta yagay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ne gimebmo daq ahol waqad hid naqmo ne ulum kemim anan meqin haqayta ham. Ne nazaq hi emiy ham. Ne ginad em haseq teq yaqgo daq anononmo ulum kemiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","On mataw Jerusalem-ubta asor osim in Yesus gamuk bilaqsa huritad bilaqiy, Mataw aseseqta in mat wol emnan bilaqayta na amatin kawaqmo daqagya haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ahol waqiy haqiy. In mataw aseseqta ko gimeb gamuk bilaqsa in nan araq a hi bulonay haqiy. Nabag mataw aseseqta ko in ago tuhuritim ginad emay, In Krais haqay daqagya haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ta teq mat ko uliq edob bolta na ago i tuhurit haqiy. Ari Krais helmo boldaqta nab mat araq diq in uliq edob osim bolta na ago a hi huritdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","In nazaq haqsa iyan Yesus Tempel ago gel aduganib mataw suleq negad osimmo in lileyim bilam, Ne yaqgo tuhuritiy ye? ham. Ad ya edob bolta na ago ne ginad emay ye? ham. Ya inadibmo a hi bol ham. Mat araq ya iqeman bolta ham. In gamuk helta bilaqaqta ham. Teq ne in ago a hi huritayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ya mat na inaq osta ham. Ossa inmo ya iqeman ya bolta ham. Nazaq iyan ya in ago tuhurit ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesus nazaq haqanmo mataw na asor in irqurnan haqad tuwaznan ton yaqay. Teq haiq. Yesus bab gibenab osdaqta na akaman teqmo bolsa iyan mataw na a hi waziy. ");
INSERT INTO mlp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sa mataw biyahta na gigo asor kabemmo in Yesus anan helmo tihaq yaqay. Ad in bilaq yaqay, Mat ko daq azawayin inaqta kabemmo tiqamta haq yaqay. Mat araq boleq mat ko a hi uriyam nagta haq yaqay. Nazaq iyan inmo Krais daqagya haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ari mataw biyahta na Yesus anan gamuk kabemmo bilaqsa Farisi tuhuritiy. Huritsa mataw tamaz emayta gigo aseseqta na giyogniz Farisi nenaq in hurmey asor giqeman Yesus wazeq irqurnan tilehiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Lehan teq Yesus tibilam, Ya nenaq kam asitmo a ta osdaiq ham. Oseq teq ya muleqeq mat ya iqeman bolta na agerab ta lehdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lehid teq ne ya tiqinagun daqay ham. Ta teq ne ya a hi ibiy daqay ham. Uliq ya le osdaiqta nab ne a hi leh daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Haqan Juda mataw aseseqta na in gimo an bulonim bilaqiy, Na in edob lehid i naguneq ahol a hi waqam? haqiy. Luweq in Grik mataw gigo sawab leheq i gisenlul asor nab osayta na nenaq osdaq haqiy. Osad in Grik mataw na suleq negdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Haqad in bilaqiy, Mat na bilam, Ne ya inagunad teq ne ya a hi ibiy daqay ham haqiy. Teq in bilam, Uliq ya le osdaiqta nab ne a hi leh daqay ham haqiy. Gamuk na alulin ezaq diq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ari humab ayahta na ago kam abebtanta na in kam ayah diqta. Kam nab Yesus eraqim turad in lileyim bilam, On mataw yuwnan moqayta na in yaqgo hib boleq yuw uluwiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","On mataw ya inan helmo haqsa teq God ago mar bilamta nazaq in giholib gwahtiqdaq ham. In gigemab yuw dimunta gwahtiqad in tuteqmo nazaq sibad tuqusdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesus in God ago Bugaw Dimunta anan gamuk na bilam. Abeb on mataw Yesus anan helmo haqeq teq in Bugaw na tuwaq daqay. Ari Yesus gamuk bilamta kam nab in ahol abin ayahta waqim amam agerab a hi gwalehsa God ago Bugaw Dimunta og kab a hi gewoqyaq. ");
INSERT INTO mlp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","On mataw na Yesus ago gamuk na huritim asor bilaq yaqay, God ago nantut boldaqta na amatin diq kawaqmo tubol haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sa asor bilaq yaqay, Ka Krais-mo haq yaqay. Haqsa ta asor bilaq yaqay, Haiq haq yaqay. Krais saw Galiliy-ib a hi gwahtiqdaqta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","God ago gamuk bilam, Krais in Devit ago uliq Betlehem-ub Devit asenlul gimuganib gwahtiqdaqta haqad in bilam haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nazaq iyan mataw na ginad giger iyan in gimo gihol huserim dauh gigermo tiqiyiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sa mataw na gigo asor Yesus wazeq irqurnan ginad bilaqsa teq haiq. In nazaq a hi toniy. ");
INSERT INTO mlp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nazaq iyan hurmey na muleqim mataw tamaz emayta gigo aseseqta na giyogniz Farisi nenaq gigo hib ta lehiy. Lehan mataw aseseqta na tisusumun negiy, Ne nagaqgo mat na wazim ad a hi boliy? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Haqan hurmey na bilaqiy, Mat ko ago gamuk in lul araq diq haqiy. Kwaziqmo i mat araq gamuk nazaq bilaqsa a hi huritta haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Haqan Farisi bilaqiy, Mat na ne inaqmo kat negan ne in anan helmo haqaymo daqagya haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mataw marorta bunmo mat na anan helmo a hi haqayta haqiy. Sa Farisi bunmo in nazaqmo mat na anan helmo a hi haqaytamo haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mataw biyahta na ginad haiq haqiy. In God ago maror Moses igta na ago a hi hurit kemayta haqiy. Nazaq iyan God kusluw negan in oseq teq timeqniy daqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Haqan Farisi gigo araq anan Nikodemus, mat kwaziqmo Yesus ago hib lahta na, in osim gibilan, I mat araq samanta nan ugam nazaq i gigo maror a hi bilam ham. Mat na i gimeb turad in naga daqin diq emaqta na ago bilaqsa i huriteq teq i in ago daq ulum kemam ham. Nazaq a haiq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Haqan mataw na amenin emim buloniy, Ni inaqmo saw Galiliy-ibta daqagya haqiy. Ni leheq God ago marib gamuk usaqta na ahol ta waq kem haqiy. Ahol waq kemeq teq ni ninad em hasdaq haqiy. God ago nantut araq saw Galiliy-ib gwahtiqdaq nazaq in a hi usaq haqiy. Hikidik haqiy.  ");
INSERT INTO mlp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ari gamuk na tihiqiyan mataw bunmo gibit gibit tilehiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mataw bunmo gibit gibit tilehsamo Yesus garah anan Oliv haqayta nab tilah. ");
INSERT INTO mlp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lehim usim tarommo diq in eraqim Tempel-ib a ta lah. Lehan nab on mataw bunmo in ago hib bolan in os woqim osad suleq tinegyaq. ");
INSERT INTO mlp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Suleq negsa mataw Moses ago gunun hurit kemiyta na asor giyogniz Farisi asor nenaq in aw araq wazim a boliy. Aw na aduw ame titonim le mat araq inaq ussa in ahol waqad waziyta. Wazim a bolim in liqabmo on mataw bunmo gimeb eman titur. ");
INSERT INTO mlp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tursa mataw aseseqta na Yesus buloniy, Tisa haqiy, aw ka aduw ame titonim le mat araq inaq ussa i ahol waqadmo i wazim ningo hib a bol haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","God ago maror Moses igta na bilam, Aw kazaqta ka amalib gig hunegid in moqan haqad in bilam haqiy. Ari teq ninmo ezaq haqdaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mataw na Yesus ulum waqnan haqad nazaq buloniy, Yesus daq na agamukan bilaq kireh tonid teq in nan na ginuwid amalib gwaldaq haqad. Teq haiq. Yesus ahol holosan woqan abakbakan ulum laquwim in abenab mar ogib tiqemyaq. ");
INSERT INTO mlp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Emsamo mataw aseseqta na Yesus a ta susumun ug yaqay. Susumun ugsa Yesus eraqim turad tigibilan, Ne gilikmanib nog diq in aholib daq meqinta haiqta naqmo in ameb diq aw ka amen gig hunegan ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Haqad in ahol hulosan ta woqan in ogib mar a ta emyaq. ");
INSERT INTO mlp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Emsa mataw na in ago gamuk na huritim in amulik-mulikmo hulosadmo tileh yaqay. Mataw marorta na ameb lehsa ta biyahta na abeb lehiy. In tileh bugan teq aw na amomo Yesus anognib tur. ");
INSERT INTO mlp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tursa Yesus eraqim turad tubulon, Neng ham mataw nimalib nan emiyta na edowa? ham. Mat araq nimalib nan emdaqta kabag turaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Haqan aw na bilam, Mat Iyah ham araq diq kab a hi turaq ham. An Yesus bilam, Ya inaqmo nan a hi nigdaiqmo ham. Ni leh ham. Ad abeb ni daq meqinta na ta hi em ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ari Yesus in on mataw ta gibilenim in kazaq bilam, Yaqmo og ka ago saw anuwan ham. Mat ya imuzeq boldaqta na in romriqab a hi luwdaq ham. Haiq ham. In ya inuwanib luwad in kayeqmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Haqan Farisi gamuk na huritim in Yesus buloniy, Ni nimomo nihol anan bilaqaq haqiy. Mat araq nisen baysihim gamuk a hi emaq haqiy. Nazaq iyan ningo gamuk na in helta a hi haiq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Haqan Yesus amenin emim gibilan, Helmo ham ya imomo ihol anan bilaqaiqta ham. Ta teq yaqgo gamuk ka in heltaqmo ham. Na ezaqgo ham, ya uliq edob bolta na ago ya tuhurit kem ham. Teq uliq edob ya lehdaiqta na ya tuhuritmo ham. Ari ne yaqgo uliq diqmo ago a hi huritayta ham. Ad ya edob lehdaiqta na ne a hi huritaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ne mataw og kabta gigo ginadta amalib mataw gilum kemayta ham. Yaqmo mat araq a hi ulum kemaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ari teq ya mat araq ulum kemnan haqad na ya imomo mat na anan a hi bilaqdaiq ham. Haiq ham. Ya imam iqeman bolta na inaq i araqibmo nan na bilaqamta ham. Nazaq iyid i gigo nan in heltaqmo iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Negmo gigo maror bilam, Mataw giger an ulumsiheq nan amulikmo bilaqid teq nan na in heltaqmo tiqiydaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","An nazaqmo ya iholyon gamuk bilaqsa ya imam iqeman bolta na in ya iyon gamuk bilaqaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Haqanmo Farisi buloniy, Ta ni nimam edob osaq? haqiy. Haqan Yesus bilam, Ne yaqgo a hi huritim iyan ne ya imam ago a hi huritaymo ham. Ari ne yaqgo huriteq teq ne ya imam ago tuhurit daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesus Tempel-ib bit adugan mani eman usta nab osad in on mataw suleq negim gamuk na gibilanta. Gibilensa mat araq diq bolim Yesus wazim a hi irqur. Na ezaqgo Yesus ago kam a hi gwahtiqsa iyan na ago in a hi waziy. ");
INSERT INTO mlp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ari Yesus a ta gibilenim bilam, Ya ne gihuloseq tilehdaiq ham. Lehid teq ne ya inagunad tiluw daqay ham. Luwad ne gigo daq meqinta ne giholib soqoteq ussamo ne inaq tumoq daqay ham. Moqeq ya lehdaiqta nab ne a hi leh daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ari Juda mataw aseseqta na in gamuk na huritim in gimo an bulonim bilaqiy, Ezaqgo in i ginan bilam, Ya uliq lehdaiqta nab ne a hi leh daqay ham? haqiy. Luweq inmo ahol wol emid moqdaqta na ago in bilaqdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Haqsa Yesus gibilan, Ne mataw og kabta ham. Teq ya ulilibmo osim gehitiyta ham. Ne gibe alulin og kab usaqta ham. Teq ya ihol alulin og kab a hi usaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ya ne gibilenim bilay, Ne gigo daq meqinta ne giholib soqoteq ussamo ne inaq tumoq daqay hayta ham. Na ezaqgo ne ya inan helmo a hi haqeq teq ne gigo daq meqinta ne giholib ussa ne inaq tumoq daqayta na ago ya nazaq gibilenta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Haqan mataw na susumun ugim buloniy, Ni nog? haqiy. Haqan Yesus gibilan, Ya kabiy alulin emim gibilenim gibilenim bolta naqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yaqgo gamuk kabemmo ya ne ginan bilaqdaiqta usaq ham. Ad ya ne gigo daq meqinta kabemmo gilum kemeq ginan bilaqdaiqta usaqmo ham. Ta teq mat ya iqeman bolta na in gamuk helta bilaqaqta ham. Nazaq iyan ya in ago hib nan huritta naqmo amalib ya on mataw og kabta gibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ari Yesus in amam anan gibilensa mataw na ginad a hi em has yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nazaq iyan Yesus gibilan, Ne Mat Atatin wazid eraqeq tursa teq ne yaqgo tuhurit kem daqay ham. Ya daq araq inadib a hi emaiqta ham. Ya gamuk kagan bilaqaiqta ka ya imammo isihunan ya bilaqaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mat ya iqeman bolta na in ya inaq osauqta ham. Osad ya tutimmo in anad muzim daq emaiqta ham. Nazaq iyan in ya ihulosan ya imomo a hi osaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesus gamuk na bilaqan on mataw kabemmo huritim anan helmo tihaqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ari Yesus in Juda on mataw in anan helmo haqiyta na gibilenim bilam, Ne gituw a hi hiqiysa yaqgo gamuk muzinad teq ne yaqgo disaipel-mo diq tiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ad ne yaqgo nan helta na ago ginad tiqem has daqaymo ham. Ginad em hassa nan helta naqmo ne giqamun hasid ne samanmo tiluw os daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Haqan mataw na amenin emim bilaqiy, I Abraham ago anaynayniz asor kawa haqiy. I mat araq ago kabibiy mataw samanta a hi osauq haqiy. Ni ezaq haqad i ginan bilam, Ne giqamun hasid samanmo tiluw os daqay ham? haqiy. Ni nazaq bilaqsa i ginad a hi em hasauq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Haqan Yesus in gigo gamuk amenin emim gibilan, Ya helmo ne gibilenaiq ham. Mat daq meqinta emaqta na in daq meqinta naqmo ago kabibiy mat samanta iyim osaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kabibiy mat in ago ayahta ago bitab tuteqmo a hi osdaqta ham. Ari mat ayahta na atatin teq in amam ago bitab tuteqmo tuqosdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nazaq iyan Mat Atatinmo ne giqamun hasid teq ne saman diqmo tiluw os daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ne Abraham ago anaynayniz osayta na ya inad emaiq ham. Ta teq yaqgo gamuk ne gigemab usdaqta na abanan haiq ham. Nazaq iyan ne ya inol emid moqgo adanteqin nagunay ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ya imam ago hib osad nagah ahol wayta naqmo ago ya bilaqaiqta ham. Sa nazaqmo negmo gimam gibilanta nazaq ne daq emaytamo ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Haqan Juda mataw na amenin emim bilaqiy, I gimam Abraham-mo haqiy. Haqan ta Yesus gibilan, Ne Abraham atatniz diq iyeq teq Abraham daq emyaqta nazaq ne em nagiymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ya God ago hib gamuk helta huritta naqmo gibilensa ta ne ya inol emid moqgo adanteqin tinagunay ham. Daq nawa na in Abraham ago daqta nog a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ne gimam diq ago daq ne muzayta ham. Haqan mataw na buloniy, I ginenan in danatab mataw ginaq daq meqinta emad luwim i a hi giqemiy haqiy. I gimam amulikmo na God-mo haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Haqan ta Yesus gibilan, God in ne gimam diq iyid teq ne ya inan ginad bilaq nagiy ham. Na ezaqgo ya God inaq osim teq ya bolim kawa osaiq ham. Inmo ya iqeman bolta ham. Ya inadibmo a hi bol ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ne ginad soqotim ussa ne yaqgo gamuk anan helmo a hi haqayta ham. Nazaq iyan ne yaqgo gamuk ka huritim ginad a hi em hasay ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ne gimam Satan alulibmo ne gwahtiqiyta ham. Nazaq iyan ne gimam na daq emaqta nazaqmo ne emnan ginad emayta ham. Kwaziq diqmo Satan mutur gwahtimta nab in mataw ginol emim emim bo muran kawa tiqiyaq ham. In daq helta a hi muzinaqta ham. Na ezaqgo in aholib daq araq helta haiqgam ham. In nan katiyta naqmo anamren ham. In aholib nan katiytamo ussa iyan in nan katiyta naqmo bilaqad luwaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nazaq iysa iyan ya nan helta gibilensa ne anan helmo a hi haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yaqgo daq meqinta edowa? ham. Ne gilikmanib nog bilaqdaq? ham. Ari ya nan helta bilaqsa teq ta nagaqgo ne yaqgo nan na anan helmo a hi haqay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","On mataw God alulib gwahtiqiyta na in God ago gamuk huritayta ham. Ta ne God alulib a hi gwahtiqiyta na ago ne God aqez a hi huritayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ari Juda mataw aseseqta na in Yesus ago gamuk amenin emim bilaqiy, I bilaqauq, Ni i gibabun Samariya-ibta gigo araq niholib bugaw meqinta usaq haqauqta na in helmo diq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Haqan ta Yesus amenin emim bilam, Ya bugaw meqinta haiqgam ham. Ya imammo abin wazinad iluwaiqta ham. Ta teq ne ya ihol abin bilawunaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yaqmo ihol abin ayah iydaq haqad ya kabiy a hi emaiqta ham. Mat araq ya ibin emid ayah iynan anad bilaqsa nawa osaqta ham. Mat naqmo teq i tigilum kemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ya helmo ne gibilenaiq ham. On mataw yaqgo gamuk muzin daqayta na in a hikidik moq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Haqan Juda mataw na buloniy, Muran i ningo tuhurit kemauq haqiy. Hel diqtaqmo ni niholib bugaw meqinta usaq haqiy. Abraham tumomta haqiy. Teq God ago nantut bunmo tumoq bugiymo haqiy. Ta teq ni bilam, On mataw yaqgo gamuk muzin daqayta na a hikidik moq daqay ham haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ezaq? haqiy. I gimam Abraham tumomta haqiy. Teq ni Abraham uriyamaq e? haqiy. God ago nantut bunmo tumoq bugiymo haqiy. Ni nihol anan ezaq diq haqad nazaq bilaqaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Haqan Yesus bilam, Yaqmo ihol abin iluwid teq ya ibin na ayah a hi iydaq ham. Ta teq ya imam inmo ya ibin iluwaqta ham. Mat ne anan bilaqay, I gigo God haqayta naqmo in ya ibin iluwaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ta teq ne ya imam ago a hi huritayta ham. Ari yaqmo in ago tuhurit kemta ham. Ya in ago a hi huritta nazaq ya a hi bilaqdaiq ham. Ya nazaq bilaqeq ya mat katiyta ne ginogmo tiqiynag ham. Teq ya God ago huritim ya in ago gamuk muz bugaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ne gises Abraham in yaqgo kam ka ahol waqnan anad ayahmo bilamta ham. Ad in yaqgo kam ka ahol tuwaqim in agem dimun diq iyaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yesus nazaq bilaqanmo Juda mataw aseseqta na tubuloniy, Ningo ulig 50 nazaq a hi iyaq haqiy. Ni ezaq tonim Abraham ahol wam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Haqan Yesus gibilenim bilam, Ya helmo ne gibilenaiq ham. Abraham a hi gwahtiqsa yaqmo tuqosta ham. ");
INSERT INTO mlp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","In nazaq haqan mataw na gig waqim Yesus amen hunegeq wolnan tonsamo in gimeb ulilemim Tempel ago gel asan ban gwahtiqim tilah. ");
INSERT INTO mlp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ari Yesus lehad luwimmo in mat araq ame haiqta ahol tuwam. Mat na anen agemab nazaqmo gwahtimta. ");
INSERT INTO mlp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ahol waqsa in ago disaipel era tisusumun ugiy, Tisa haqiy nog diq daq meqinta eman mat ka anen agemab usadmo ame hiqiy? haqiy. Mat kaqmo daq meqinta am o haiq in anen amam daq meqinta emiy? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Haqan Yesus amenin emim gibilan, Mat ka daq meqinta a hi am ham. Ta in anen amam daq meqinta a hi emiymo ham. Haiqgam ham. Mat ka aholib God ago kabiy emid ulal iysa on mataw ahol waq kem daqay haqad in ame hiqiyta ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Muran saw tihastitayim usaq ham. Sa i mat ya iqeman bolta na ago kabiy saw anuwanibmo emuq ham. Tarom teq tiqiydaq ham. Iyid teq mataw kabiy araq a ta hi em daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ya og kab osad ago saw anuwan iyim osaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Haqadmo in ogib kusluwim og inaq buliyim in waqim mat ame haiqta na ameqnagnib tiqam. ");
INSERT INTO mlp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Emadmo in bulon, Ni leheq yuw akurorqanta anan Silowam haqayta nab ni nime suhol ham. (Gamuk Silowam na alulin in kazaq, ‘Eman lah’ haqayta.) In nazaq bulonan mat ame haiqta na lehim ame tisuhol. Suholim ame tihastitayan in saw ahol waq kemadmo muleqim ta bol. ");
INSERT INTO mlp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bolan ago uliqab walmataw teq mataw kwaziqmo in mani anan sun negsa ahol waqiyta na tibilaqiy, Ezaq? haqiy. Mat danib mani anan sunad osyaqta na amatin kawaqmo daqag haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Haqsa asor ‘Eqe’ haq yaqay. Ka mat naqmo daqag haq yaqay. Sa asor ‘Haiqgam’ haq yaqay. Ka in mat naqmo nogta teq ka in mat ta araq haq yaqay. Haqsa mat na bilaqyaq, Ka yaqmo haqyaq. ");
INSERT INTO mlp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Haqsa teq mataw na tisusumun ugiy, Ta ni ezaq tonim nime na dimniy? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Haqan in gibilan, Mat anan Yesus haqayta na ogib kusluwim og inaq buliyim in waqim ya imeqnagnib am ham. Emim in ya ibilan, Ni leheq yuw Silowam-ub nime suhol haqad in bilam ham. In nazaq ibilenan ya le ime suholan tidimniy ham. An muran ya saw ahol tuwaqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Haqan mataw na buloniy, Ta mat na edowa? haqiy. Haqan in bilam, Yowo ham. Ya a hi hurit ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Haqanmo mataw na in mat ame hiqiyim osta na waqim ad Farisi gigo hib tilehiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(Na Yesus ogib kusluwim og inaq buliyim in waqim mat na ameb eman ame hastitayta na in Juda gigo lotu akamnib kabiy na amta.) ");
INSERT INTO mlp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nazaq iyan Farisi in mat na tisusumun ugiy, Ni nime ezaq diq tonim dimniy? haqiy. Haqan in gibilan, Mat na ogib kusluwim og inaq buliyim in waqim ya imeb am ham. Eman ya le ime suholim ya saw ahol tuwaqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Haqanmo Farisi asor bilaqiy, God mat na eman a hi bolta haqiy. In i gigo lotu akaman ago gunun a hi muzinaqta haqiy. Haqsa ta asor bilaqiy, Ezaq teq mat aholib daq meqinta usaqta na in anad emsamo daq azawayin inaq kazaq gwahtiqdaq? haqiy. Farisi nazaq haqad in gimo gihol huserim dauh giger tiqiyiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nazaq iyan Farisi in mat ame hiqiyim osta na a ta susumun ugiy, Ni mat nime eman hastitayta na anan ninad ezaq emaq? haqiy. Haqan in bilam, Mat na in God ago nantut araq ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ari Juda mataw na in mat na ame haiqmo osim teq ame dimniyta na anan helmo a hi haq yaqay. Nazaq iyan in mat ame dimniyta na anen amam gimen nan eman in tuboliy. ");
INSERT INTO mlp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bolan in susumun negim gibileniy, Ka ne giger gitatin e? haqiy. Ka ne ame haiqmo emiyta ye? haqiy. Ezaq tonim in saw ahol tuwaqaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Haqan in anen amam gamuk amenin emim bilaqiy, Ka i giger gigo amunta haqiy. Teq in ame haiqmo i emta haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ta teq muran in ezaq tonim ame saw ahol tuwaqaqta na ago i a hi hurit haqiy. Ad nog diq in ame eman hastitayta na i a hi huritmo haqiy. Ne inmo susumun ugiy haqiy. In mat ayah tiqiyta haqiy. Inmo aholmen gamuk tibilaqdaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mat na anen amam in Juda mataw aseseqta na ginan rabad iyan in nazaq bilaqiy. Na ezaqgo Juda mataw na tekomo an adugan wazim bilaqiy, Mat araq Yesus anan Krais haqid teq na i bit humab wolaytab muzid in i ginaq lotu a ta hi emdaq haqad in bilaqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nan asen naqmo ago mat na anen amam bilaqiy, In mat ayah tiqiyta haqiy. Ne inmo susumun ugiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nazaq iyan Farisi in mat ame hiqiyim osta na gime gigerta bulonan bolan in buloniy, Ni God amomo abin wazid eraqsa teq ni gamuk heltaqmo i gibilen haqiy. I mat na ago tuhurit haqiy. In daq meqinta emaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Haqan mat ame dimniyta na in gigo gamuk amenin emim gibilan, Mat na daq meqinta emaqta o haiqta na ya a hi hurit ham. Ya nagah amulikmo ago huritta na in kazaq ham. Kwaziqmo ya ime haiqmo osta teq muran ya saw ahol tuwaqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Haqan mataw na buloniy, Mat na ezaq diq nitonan teq ni nime hastitay? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Haqan in gibilan, Ya tigibilenta teq ne huritnan gituw hiqiyaq ham. Ne ginad ezaq diq emad ne a ta huritnan bilaqay? ham. Ne inaqmo ingo disaipel iynan haqad ne susumun yagay ye? ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Haqan Farisi in mat na bilawunim buloniy, Ninmo in ago disaipel-ta haqiy. Ari igmo Moses ago disaipel-ta haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God in Moses-mo gamuk bulonta naqmo ago i tuhuritta haqiy. Ta teq mat nawa na in edob bolta na i a hi hurit haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Haqan mat na in Farisi gigo gamuk amenin emim gibilan, Ne gigo gamuk nawa ne bilaqayta na in lul araq diq ham. Mat na edob bolta na ago ne a hi huritayta teq in ya ime eman tihastitay ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","God in mataw daq meqinta emayta giqez a hi huritaqta ham. Na ago i bunmo tuhuritta ham. Ari mat God abin wazinad anad muzinsa teq God in aqez tuhuritdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kwaziq diqmo og mutur gwahtimta nab iyim bolim bo muran kam kab aw araq amun ame haiqta eman teq abeb mat araq in ame eman hastitayta na awagamun araq diq i a hi huritta ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ari God in mat na emid a hi bolta iyid in daq araq a hi em nagta ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Haqan mataw aseseqta na amenin emim buloniy, Ni ninen niqamta nab ni daq meqinta emad luwim bo muranmo haqiy. Ni mat nazaqta iyim osadmo ni i suleq igaq e? haqiy. Haqadmo in mat na baymuzan tilah. ");
INSERT INTO mlp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ari Farisi mat na baymuzan lahta na ago Yesus huritim in mat na nagunim le ahol waqad tubulon, Ni Mat Atatin anan helmo haqaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Haqan mat na bilam, Mat ayah ham. Mat Atatin na nog? ham. Ni ya ibilenid teq ya in anan helmo tihaqdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Haqan Yesus bulon, Ni mat na ahol tuwam ham. Mat na muran ni ninaq gamuk emaq kaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Haqan mat na bilam, Iyahta ham ya ninan helmo tihaqaiq ham. Haqad in abakbakan ulum laquwim turad Yesus abin tiqiluw. ");
INSERT INTO mlp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","An Yesus bilam, Ya mataw gilum kemnan haqad og kab bolta ham. Gilum kemsa mataw gime haiqta na saw ahol tuwaq daqay ham. Sa mataw bilaqay, I saw ahol tuwaqauq haqayta na in gime tihiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Haqsa Farisi asor Yesus agerab turad gamuk na tuhuritiy. Huritim in Yesus buloniy, Ezaq? haqiy. I inaqmo gime hiqiyim osauqta ye? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Haqan Yesus gibilan, Ne mataw gime haiqta iyeq teq ne gigo daq meqinta na amenin a hi waq nagiy ham. Ta teq ne bilaqay, I gime saw waqauqta haqayta ham. Nazaq iyan ne gigo daq meqinta na giholib us tutsa ne teq amenin tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ari Yesus bilam, Hel diqtaqmo ya ne gibilenaiq ham. Mat sipsip gigo gel ago dan ezab le a hi gwahtiqaqta na in mat arin inaqta ham. Mat naqanta in gel asan ban luwad gel itiyonim adugan ban gwahtiqaqta ham. Nazaq iyan in bilaqne mat mataw gigo bit wolim gigo nagah rin tonaqta na nog iyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ari mat dan ezabmo lo gwahtiqaqta naqmo in sipsip ginamrenmo diq ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kabibiy mat gel ago dan ez wamuzim osaqta na in sipsip ginamren diq bolsa ahol waqad in ayon dan tihas ugaqta ham. Teq sipsip in ginamren na aqez huritayta ham. Sipsip ginamren na in sipsip amulik-mulikmo ginan biyim gililewunad giqad asanib lehaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","In ago sipsip bunmo giqad asanib lehad inmo danmeb lehaqta ham. Lehsa sipsip in mat na aqez hurit kemim in muzim inaq lehayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sipsip na in mat amota a hi muz daqayta ham. Haiqgam ham. In mat amota na rabunad tuk daqayta ham. Na ezaqgo in ginamren amomo aqez huritayta na ago ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus gamuk awowun ka amalib Farisi nagan gibilanta teq in gamuk awowun na alulin diq ginad a hi em hasiy. ");
INSERT INTO mlp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nazaq iyan Yesus ta gibilan, Ya helmo ne gibilenaiq ham. Sipsip gigo gel ago dan ez na yaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mataw bunmo ya a hi bolsa in ameb boliyta na in mataw girin inaqta teq in mataw danib giwazim ginolim gigo nagah samanmo waqiyta amatawun ham. Teq sipsip in mataw na giqez a hi huritiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yaqmo gel ago dan ezmo diq ham. Mat aw nog yaqgo hib boleq yaqgo gel aduganib gwahtiqid God in gilumsiheq tigiwaqdaq ham. Giwaqid teq on mataw na lo gwahtiqad ge gwahtiqad loq gwagelad didaq waqad tiluw daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mat arin inaqta na in sipsip girin toneq gimeqin tonad ginol emid moqgo haqad in bolaqta ham. Mat naqanta in kabiy araq ago a hi bolaqta ham. Ta teq ya sipsip giqemid in kayeqmo dimunmo osgo haqad bolta ham. Ya giqemid kayeqmo ossa yaqgo os dimunta na in giholib ame gwaleq tuqusdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yaqmo sipsip ginamrenmo diq ham. Nazaq iyan yaqgo sipsip anonon diqmo giwamuzaiqta ham. Mat sipsip anononmo giwamuzaqta na in ago sipsip ginadin emad in gimen ahol nog hulosaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ari kabibiy matmo teq in sipsip giwamuzaqta ago anawun waqaqta naqmo in anadin emaqta ham. In sipsip ginadin diq a hi emaqta ham. Na ezaqgo in sipsip ginamren a haiqta ham. In mani-mo anadin emad luwsa gaun kwasikta bolsa in ahol waqadmo in ago sipsip gihulosad tukaqta ham. Tuksa gaun kwasikta na sipsip gimug ninalad gimuzan haresmo lehayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mat nazaq emaqta na in ago sipsip ginadin a hi emad in mani-mo anadin emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ari yaqmo sipsip ginamrenmo diq ham. Ya anonon diqmo giwamuzaiqta ham. Ya imam in yaqgo huritsa ta yaqmo ya imam ago huritaiqtamo ham. Ad nazaqmo ya igo sipsip gigo huritsa ta yaqgo sipsip in yaqgo huritaytamo ham. Ad teq ya igo sipsip ginadin emad ya in gimen ihol nog hulosdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yaqgo sipsip ta asor saw araqab luway ham. In yaqgo sipsip gihumaban kab luwayta ka gigo asor a haiqta ham. Ya sipsip en ta araq na gililewunid in ya iqez huriteq yaqgo hib bolsa ya giwaqeq giqad yaqgo gel aduganib le tugwahtiqdaiq ham. Gwahtiqid teq yaqgo sipsip bunmo in en amulikmo iysa sipsip ginamren na amulikmo tiqiydaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yaqgo sipsip ginadin emad ya in gimen ihol nog hulosdaiqta ham. Nazaq iyan ya imam in ya inan anad diq bilaqaqta ham. Ya sipsip gimen ihol nog huloseq teq ya kayeq ta iydaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mat araq anadibmo a hi inol emdaq ham. Haiqgam ham. Yaqmo inadibmo ihol nog tuhulosdaiq ham. Ya inadibmo ihol nog hulosdaiqta na ago zaway ya iholib usaqta ham. Teq ya inadibmo kayeq ta iydaiqta na azawayin yaqgo hib usaqtamo ham. Ya daq nazaq emgo haqad ya imam ibilanta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ari Juda mataw aseseqta na Yesus ago gamuk na huritim in ginad giger iyan in gimo gihol huserim humab giger tiqiyiy, teko in emiyta nazaq. ");
INSERT INTO mlp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Iyim mataw na asor kabemmo Yesus anan bilaq yaqay, Bugaw meqinta aholib ossa in anad agadan iyaq haq yaqay. Nagaqgo i ago gamuk huritam? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sa asor bilaq yaqay, In gamuk bilaqaqta na in mat ago bugaw meqinta aholib ussa gamuk bilaqaqta na nog a hi iyaq haq yaqay. Mat ago bugaw meqinta aholib usaqta na in ezaq mat ame haiqta wastitayid ame hastitaydaq? haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ari kam nagab uliq Jerusalem-ub humab araq ayahta ago akaman tugwahtim. Kam na kwaziqmo Tempel meqniyan Juda gisesan wastitayim asirin tonim adanin hasiyta na anadin emgo akaman. Ulig bunmo saw amuditqan diq iyyaqta na akamnib kam na gwahtiqaqta. ");
INSERT INTO mlp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kam nab Yesus Tempel ago gel aduganib gwahtiqim le veranda sisaqta anan Solomon ago veranda haqayta nab gwalim in leh bolad tiluwyaq. ");
INSERT INTO mlp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Luwsa Juda mataw aseseqta na Yesus agerab bolim lilut ugim turadmo in bulonim bilaqiy, Kam gineh teq ni i gibilen kemdaq? haqiy. Ni Krais iyeq teq ni bilaq sireqeqmo i gibilen haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Haqan Yesus in gigo gamuk amenin emim bilam, Ya ne tigibilenta ham. Teq ne helmo a hi haqiy ham. Kabiy ya imam abinib emaiqta na in ya ihol alulin ago ne gibilen kemaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Teq ne ya inan helmo a hi haqayta ham. Ne yaqgo sipsip a haiqta ham. Nazaq iyan ne ya inan helmo a hi haqayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yaqgo sipsip ya iqez huritayta ham. Teq ya in gigo huritsa in ya imuzim inaq bolayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ya igo sipsip giqemid in kuluwa-kuluwmo osad a hikidik moq daqay ham. Sa mat araq yaqgo sipsip ya ibenab a hi giwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ya imam inmo yaqgo sipsip na giyagta ham. Teq in og ka ago zaway bunmo giquriyamim osaqta ham. Nazaq iyan mat araq ya imam abenab yaqgo sipsip na a hi giwalemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ya imam inaq i mat amulikmoqmo iyim osauqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesus nazaq haqanmo Juda mataw aseseqta na gig waqim Yesus amen a ta hunegnan toniy. ");
INSERT INTO mlp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Sa Yesus bilam, Ya Gimam Iyahta ago kabiy dimdimunta kabemmo tigiqisihun ham. Kabiy dimdimunta na gilikmanib edo diq ago ne yaqmen gig tuhunegnan tonay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Haqan mataw na bilaqiy, I kabiy araq dimunta ago ninmen gig a hi hunegauq haqiy. Haiq haqiy. Ni God bilawunaqta naqmo ago i ni ninolnan ginad emauq haqiy. Ni mat diqmo araqta teq ni bilaqaq, Yaqmo God haqaq haqiy. Na ago i ninmen gig tuhunegnan haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Haqan Yesus gibilan, God ago maror Moses mar tonta nab gamuk araq kazaq usaq ham. Gamuk nab God kazaq bilam ham. Yaqmo ne ginan bilay, Ne god-mo hay ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","God ago marib in on mataw God ago gamuk waqiyta na ginan ‘god’ haqan usaqta ham. Ussa mat araq diq in God ago mar na emid samanta iygo biyab a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ari ya imam in ya itowun emim aholyon tiqiwamta ham. Iwaqim iqeman ya og kab bolta ham. Nazaq iyan ya ihol anan bilaqdaiq, Ya God Atatin nazaq ya a hi bilaqdaiq e? ham. Nagaqgo ne ya imalib nan emim bilaqay, Ni God bilawunaq haqay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ya imam ago kabiy diq a hi emsa teq ne ya inan helmo hi haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ari ne yaqgo gamuk anan helmo haqnan ginadnad emad teq ne ya imam ago kabiy ya emaiqta naqmo ne ahol waq kemad teq ne ya inan helmo haqiy ham. Ne yaqgo kabiy ahol waqad ya inan helmo haqeq teq ne ginad tiqem has daqay ham. Ginad em haseq ya imam yaqgo hib ossa ya in ago hib osaiqta na ago ne tuhurit daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Haqanmo mataw na Yesus wazeq irqurnan tonsa in giquriyamim tilah. ");
INSERT INTO mlp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","In muleqim ta lehad in yuw Jodan urotim saw kwaziqmo Jon in mataw huz negyaqta nab in gwahtiqim tuqos. ");
INSERT INTO mlp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ossa mataw kabemmo in ago hib tubol yaqay. Bolad in bilaq yaqay, Jon in ago gamuk ulumsihad daq araq azawayin inaqta emsa i ahol a hi waw haq yaqay. Ta teq gamuk bunmo in mat ka anan bilamta na in helmo diq haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ad saw nab mataw kabemmo Yesus anan helmo tihaqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ari mat araq anan Lazarus uliq Betaniy-ibta na moqad us. Uliq na in Mariya abab Marta inaq gigo uliqta. ");
INSERT INTO mlp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Teq aw masil ahuran dimunta wazbalan Iyahta asenab woqan in aqensanib bayta na Mariya-mo. Sa mat moqad usta na in Mariya ahiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ari mat na moqad ussa in ahiyan giger na nan eman Yesus ago hib lehan in bilaqiy, Iyahta haqiy mat ni anan ninad bilaqaqta na tumoqaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Haqan Yesus nan na huritim bilam, Moq na in mat moq hasdaqta a haiq ham. Moq na on mataw giqemid in God abin iluw daqayta ham. Iluwsa daq na amalib God Atatin abin ayah tiqiydaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus in Marta ama inaq teq in gihiy Lazarus inaq ginan anad diq bilaqyaqta. ");
INSERT INTO mlp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nazaq iyan in Lazarus moqad usaqta na huritim in kam gigermo a ta os, uliq in osta nab. ");
INSERT INTO mlp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Osim teq in ago disaipel gibilan, I muleqeq saw Judiya-ib ta lehuq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Haqan disaipel buloniy, Tisa haqiy muran kawa Juda mataw aseseqta na in ni nimalib gig hunegeq ninol emnan haqad ginad usaq haqiy. Teq ni nab a ta lehnan bilaqaq e? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Haqan Yesus gibilan, Saw hastitayim le imisor iyaqta nab zeq huramad usaqta ham. Ussa mat zeqab luwad a hi woqaqta ham. In og ka anuwan ahol waqad dimunmo luwaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ari mat taromab luwaqta na in woqnan woqnan tonad luwaqta ham. Na ezaqgo in ame romriq iysa in saw ahol a hi waqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","In nazaq bilaqim teq in gibilan, I gigo kadoy Lazarus tuqusaq ham. Sa ya leheq wazid tiqeraqnan ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Haqan in ago disaipel buloniy, Iyahta haqiy in usmo usaqta iyeq in teq tidimniydaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na Yesus in Lazarus tumom haqad bilamta teq disaipel ginad a hi emiy. In ginad emiy, In us diq usaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nazaq iyan Yesus gibilen hasim bilam, Lazarus tumom ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ad in moqsa ya inaq a hi osta na in dimun diq ham. Ya ne ginadin emad ya inad tidimniyaq ham. Muran ne ya inan helmo tihaq daqay ham. Ari i mat na ago hib lehuq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Haqan Tomas, anan araq Didimus haqayta na, in disaipel ta asor na gibilan, O tob iysa i inaq leheq inaq moquq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ari Yesus le uliq Betaniy-ib gwahtiqim Lazarus kam aweweqmo hodhodab tuqusta na ago in tuhurit. ");
INSERT INTO mlp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Uliq Betaniy in Jerusalem agerabmo usaqta. In pesan diq a haiq, 3 kilomita nazaq in usaqta. ");
INSERT INTO mlp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nazaq iyan Juda on mataw kabemmo uliq ayahta nab osim in Marta ayow Mariya inaq gigerab boliy, on giger na gihiy amatqanta moqan in ginad waqnan haqad. ");
INSERT INTO mlp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ari Marta in Yesus bolaqta na abin huritad in eraqim adanin tilah. Sa Mariya bitabmo os. ");
INSERT INTO mlp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ossa Marta lehim Yesus tubulon, Iyahta ham ni kab osta iyid ya ihiy a hi moq nag ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Teq ya inad emaiq ham. Ni God inaq gamuk emad nagah araq ago susumun ugid in tiqem nigdaq haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Haqan Yesus bilam, Ni nihiy teq tiqeraqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Haqan Marta bilam, Kam abebtanta nab teq in eraqdaqta na ago ya tuhurit ham, kam on mataw bunmo hodhod huloseq eraq daqayta nab ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Haqan Yesus bulon, Mataw hodhodab eraq daqayta na alulin yaqmo ham. Teq mataw kayeqmo kuluwa-kuluwmo osayta alulin na yaqmo ham. Mat ya inan helmo haqad osim moqaqta na in teq kayeq ta iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Teq on mataw og kab kayeqmo osad ya inan helmo haqayta na in moqeq a hi moq has daqay ham. In kayeqmo kuluwa-kuluwmo tuqos daqay ham. Ni yaqgo gamuk ka anan helmo haqaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Haqan Marta bulon, Eqe ham, Iyahta ham. Ya inad emaiq, Ni Krais haqaiq ham. Ni God atatinmo haqaiq ham. God mat emid og kab bolnan anad usta na amatin ninmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta gamuk na tibilaqim in muleqim ta lehim in amikqan Mariya waqim ad adek ban loqim kiskismo bulon, Tisa tubolim osad in ni ninan susumunaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Haqan Mariya gamuk na huritim in hidmo eraqim Yesus ago hib tilah. ");
INSERT INTO mlp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesus uliqab a hi gwahtiqad in saw Marta lehim ahol wamta nab luwsa Mariya in agerab lah. ");
INSERT INTO mlp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Lehsa on mataw Mariya anad waqad inaq bitab osiyta na in Mariya hidmo eraqim asanib lehsa ahol waqad in muzim inaq tilehiy. In ginad emiy, Aw ka hodhodab gaq waznan lehaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Haqsa Mariya Yesus agerab bolim ahol waqad anognib abakbakan ulum laquwim turad teq in bilam, Iyahta ham ni kab osta iyid ya ihiy a hi moq nag ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Haqan Yesus in Mariya gaqsa ahol waqad teq Juda on mataw Mariya inaq boliyta na inaqmo gaqsa in gibiyad in ahol afaqan iyad anad timeqniyyaqmo. ");
INSERT INTO mlp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Anad meqniysa in bilam, Mat na asan edob emiy? ham. Haqan in buloniy, Iyahta haqiy, bo leheq ahol waq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Haqan Yesus lehim ahol waqad in tigam. ");
INSERT INTO mlp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Gaqsa Juda mataw nab turiyta na bilaqiy, Ahol waqiy haqiy. Mat ko in mat momta na anan anad diq bilaqyaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Haqan teq ta asor bilaqiy, Mat ko in mat ame haiqta na wastitayan in ame hastitayta haqiy. Ta nagaqgo in mebmebmo bolim mat momta ka moqad kayeqmo banab ussa a hi ulumsih? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ari Yesus ahol afaqan iysa in hodhod agerab tilom. Hodhod na in gigib yay emim aduganib mat asan emim teq in gig ayahta ulum buliyan loqim yay aqez ituqim usta. ");
INSERT INTO mlp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Teq Yesus hodhod agerab loqimmo tibilam, Ne yay aqezab gig usaqta na walemiy ham. Haqan mat momta na ahiy Marta bilam, Iyahta ham in asan kam aweweqmo hodhodab tuqusim ahuran tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Haqan Yesus bulon, Ya tinibilen ham. Ni ya inan helmo haqeq teq ni God ago zaway ahol tuwaqdaq hay ham. Na ni anadin a hi emaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","In nazaq haqanmo mataw yay aqezab gig usta na tuwalemiy. Waleman Yesus ame ulilib gwalsa in bilam, Ya imam ham ni ya iqez tuwazta na ago ya esey nigaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ni tutimmo ya iqez wazaqta na ya tuhurit ham. Teq ya on mataw kawa turayta ka ginadin emad ya in gimeb ni ninaq gamuk kawa tibilaqaiq ham. Bilaqsa teq ni ya iqeman bolta na ago in anan helmo haq daqay haqad ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","In gamuk na tibilaqim teq in lileyim bilam, Lazarus ham ni bo gwahtiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Haqanmo mat momta na abensenab tubusan hiksireqim amalib net muziyta nagan teq tubusan araq anobun isihan usta na inaqmo in bo asanib tugwahtim. Gwahtiqan Yesus in mataw nab turiyta na gibilan, Hasid in luwan ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ari Juda on mataw Mariya inaq bolim hodhod agerab turiyta na in Yesus daq amta na ahol tuwaqiy. Ahol waqad kabemmo in anan helmo tihaqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ta teq in gigo asor Farisi gigo hib lehim Yesus daq amta na ago tigibileniy. ");
INSERT INTO mlp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Gibilenan mataw tamaz emayta gigo aseseqta na giyogniz Farisi nenaq in Juda gigo kaunsel ayahta na amatawun bunmo gibilenan bolim humab tuwoliy. Humab wolim in bilaqiy, Teq i ezaq tonam? haqiy. Mat na daq azawayin inaqta kabemmo emaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","I mat na adanin a hi qwayid in nazaq em tutsa mataw bunmo in anan helmo tihaq daqay haqiy. Sa teq Rom huriteq in boleq i gigo Tempel wol inerad in i gimuzid i og ka hulosad haresmo leheq mataw ta asor gigo ogib begbegta iyeq osam haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Haqsa in gigo araq anan Kayafas haqayta in ulig nab tamaz mat danmebta iyim osta na in eraqim tigibilan, Ne ginad haiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","I bunmo hiqiy bugamta na in meqin ham. Ari mat amulikmo i gimen moqid i bunmo dimunmo osamta na in dimun ham. Na ne ginad a hi emay ye? ham. ");
INSERT INTO mlp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na in anadibmo gamuk na a hi bilamta. Haiqgam. In ulig nab tamaz mat danmebta iyan God-mo anad ugan in Yesus Juda on mataw gimen moqdaqta na ago bilamta. ");
INSERT INTO mlp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Teq Yesus in Juda on mataw gimomo gimen moqdaqta nazaq a haiq. In God ago onmin og saw bunmo osayta na girom tonid in mataw en amulikmo iy daqay haqad in bunmo gimen moqdaqta. ");
INSERT INTO mlp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ari Kayafas nazaq haqan nab mataw aseseqta na in Yesus wol emid moqgo adanteqin tinagun yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nazaq iyan Yesus in Juda gimeb ulalab a ta hi luwyaq. In saw na hulosim le uliq abebtanta anan Efrayim haqayta nab in ago disaipel nenaq tuqosiy. Uliq na abun ban saw saman diqta aquliqin haiqta usaqta. ");
INSERT INTO mlp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ari Juda gigo kam ayah diqta anan Pasova haqayta na akaman bolim sinsin tiqiy. Iyan kam na a hi gwahtiqsamo Juda mataw kabemmo in gihol udineq gihol wastitayid teq kam ayahta na gwahtiqan haqad in uliq Jerusalem-ub tugwalehiy. ");
INSERT INTO mlp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Gwalehim in Yesus anan saw waqad teq in Tempel ago gel aduganib gwahtiqim turad in an tisusumun ug yaqay, Ne ginad ezaq emay? haq yaqay. Yesus humab kab a hi boldaq daqagya haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na mataw tamaz emayta gigo aseseqta na giyogniz Farisi nenaq in tekomo mataw gibilenim bilaqiy, Ne Yesus edob osaqta na ago huriteq teq ne bo i gibilenid i tuwazam haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ari abeb kam 6 nazaq le tihiqiyid teq Juda gigo lotu akaman ayahta anan Pasova haqay na tugwahtiqdaqta. Kam nab Yesus muleqim Lazarus ago uliq Betaniy-ib ta lah. Mat naqmo moqan Yesus hodhodab wazan eramta. ");
INSERT INTO mlp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lehan uliq nab in amen didaq tuqoyiy. Oyim Marta didaq soqoreq a bolsa Lazarus in mataw nenaq didaq neqad os yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ossa Mariya in masil anan nard haqayta anawun ayahmota na asor wazim a bo Yesus asenab wazbalan woq bugan teq in aqensanib tubayyaq. In nazaq emsa masil na ahuran dimun diqta bit adugan tuwaleq ton bug. ");
INSERT INTO mlp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Sa ta Yesus ago disaipel araq Judas uliq Kariyot-ibta na bilam, Nagaqgo i mataw ginaghan haiqta gihulosauq? ham. I masil ahuran dimunta na mat araq inaq zayeq 300 kina nazaq waqeq mataw ginaghan haiqta na neg nagta ham. Mat naqmo teq Yesus bab gibenab emdaqta na amatin. ");
INSERT INTO mlp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Teq in mataw gina haiqta na ginadin emad nazaq a hi bilam. Haiqgam. In mat rin tonaqta iyim in nazaq bilamta. Na ezaqgo in Yesus ago disaipel nenaq gigo hululut mani emayta na wamuzyaqta amatin. Ad hululutib mani usta na asor in hikrinad aholyon waqyaqta. ");
INSERT INTO mlp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ari Yesus nan na huritim bilam, Ne aw ka hulosiy ham. Ya moqid mataw iyay ton daqayta nab aw ka masil ahuran dimunta na ya iholib emgo haqad in zayan usta ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tutimmo mataw ginaghan haiqta na ne nenaq osayta ham. Ari yaqmo ne nenaq tuteqmo a hi osdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Juda mataw biyahmo Yesus uliq Betaniy-ib osaqta na huritim in ahol waqnan tuboliy. Teq mataw na Yesus amomo ahol waqnan a hi boliy. Haiqgam. In Lazarus mat Yesus hodhodab wazan eramta na inaqmo ahol waqnan haqad boliy. ");
INSERT INTO mlp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Juda mataw kabemmo in Lazarus moqim ta eramta na ago huritim in mataw tamaz emayta gigo aseseqta na gihulosad in Yesus ago hib bolad anan helmo tihaq yaqay. Nazaq iyan mataw tamaz emayta gigo aseseqta na in Lazarus inaqmo wol emid moqgo ginad emiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","An tarom iyim saw tihastitayan Yesus eraqim Jerusalem-ub tilah. Lehsa on mataw dauh kabemmo Pasova ahumabun ahol waqnan haqad Jerusalem-ub bolim osiyta na in Yesus bolsa abin tuhuritiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Huritim in ay anan det haqayta na aben giwaqim teq in Yesus ahol waqnan adanin tilehiy. Lehad in bilaq yaqay, God abin soriy haq yaqay. Mat ka Iyahta abinib bolan iyan i ginad bilaq gigayinaq haq yaqay. Mat kaqmo in Isrel gigo king haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Haqsa Yesus donki minminta araq ahol waqim in amalib osim tilehyaq. God ago marib gamuk usaqta nazaqmo in am. ");
INSERT INTO mlp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Gamuk na bilam, Ne on mataw uliq Sayon-ibta ham ne hi rabiy ham. Ahol waqiy ham. Ne gigo king nawa donki amidon amalib osim bolaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kam nabmo Yesus ago disaipel gamuk na alulin ago ginad a hi em hasiy. Abeb God Yesus abin ayahta tuqugan teq in daq na anadin a ta emiy. Anadin emad in ginad emiy, God ago marib gamuk Yesus anan bilamta nazaqmo diq on mataw in ayon em ugiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Teq Yesus Lazarus lilewunan hodhodab ge gwahtiqsa on mataw kabemmo nab turad ahol waqiyta. Ahol waqim in nagah gimeb ahol waqiyta na tekomo uliq-uliqgo tibilaqiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bilaqsa on mataw biyahta na in Yesus daq azawayin inaq amta na ago huritim in ahol waqnan adanin lehiyta. ");
INSERT INTO mlp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lehsa Farisi gibiyad in gimo an bulonim bilaqiy, I ginad emuq haqiy. I mat ko adanin qwaygo akamun tihiqiy haqiy. I ko gibiyuq haqiy. On mataw bunmo in anan helmo haqad muzim inaq tilehay haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ari on mataw biyahmo Juda gigo lotu akaman ayahta na ahol waqnan bolsa in gilikmanib Grik mataw asor nenaq tuboliymo. ");
INSERT INTO mlp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bolim in Filip ago hib lehiy. Filip in uliq Betsaida saw Galiliy-ibta amatin. Nazaq iyan mataw na Filip ago hib lehim tisusumun ugiy, Mat ayah haqiy i Yesus ahol waqnan bol haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Haqan Filip le Andru bulonim teq in giger le Yesus tubuloniy. ");
INSERT INTO mlp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Bulonan Yesus in gigo gamuk amenin emim gibilan, Mat Atatin ahol abin ayahta waqdaqta na akaman muran tugwahtim ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ya helmo ne gibilenaiq ham. Wit anagin ogib woqeq a hi moqeq na in anon a hi emdaq ham. In amulikmoqmo usdaq ham. Ari wit anagin na ogib woqeq moqeq teq in ahokan gwaleq anon kabemmo tiqemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","On mataw in gimo gihol anadin diq emayta na in gihol awitan tihik hules daqay ham. Ari on mataw og kab osad in gihol anadin a hi emayta na in kuluwa-kuluwmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mat aw nog yaqgo kabiy emnan ginad bilaqaqta na in ya imuzeq tubol daqay ham. Ad uliq ya osaiqta nab in tuqos daqaymo ham. Osad in yaqmen kabiy emsa Gimam Iyah in gibin tiqiluwdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Haqad Yesus bilam, Muran ya ihol afaqan diq iyaq ham. Ta teq ya ezaq haqdaiq? ham. Ya imam ni ya iholib daq gwahtiqnan tonaqta ka walem haqdaiq e? ham. Haiqgam ham. Ya nazaq a hi bilaqdaiq ham. Daq naqmo ya iholib gwahtiqgo ya og kab bolta ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Haqad in bilam, Ya imam ham ni nibin emid ayah iyan ham. Haqsamo God aqez Heven-ib gehitiqim bilam, Ya ihol abin eman ayah tiqiy ham. Teq ya emid in ayahmo diq ta iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Haqan on mataw nab turiyta na huritim bilaqiy, Kait ahulan iyaq haqiy. Sa asor bilaqiy, Angelo araq bulonsa i aqez hurit haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Haqsa Yesus gibilan, Gamuk na ya ilumsihgo a hi gwahtim ham. Haiqgam ham. Gamuk na negmo gilumsihgo gwahtimta ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Muran God in on mataw og kabta hazizirib giqemim gigo daq tigilum kemaq ham. Muran in mat meqinta og ka wamuzim osaqta na muzid tilehdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ari yaqmo teq mataw ya iwazid eraqeq og huloseq gwale turad teq ya on mataw bunmo gihureqid yaqgo hib tubol daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Na Yesus in dante ezaqtab moqdaqta na ago in nazaq bilam. ");
INSERT INTO mlp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","In nazaq haqan on mataw na amenin emim bilaqiy, God ago marib gamuk araq kazaq bilaqsa i huritta haqiy. Gamuk na bilam, Mat anan Krais haqayta na og kab gwahtiqeq osad in ago os a hi hiqiydaqta haqad in bilam haqiy. Nagaqgo ni bilam, Mataw in Mat Atatin wazid eraqeq gwale turdaq ham? haqiy. Teq ni Mat Atatin anan bilamta na in nog diq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Haqan Yesus gibilan, Saw anuwan asitmo ne nenaq a ta usdaq ham. Saw anuwan na oysa ne saw waqad lehiy ham. Luweq ne le God ago maror aduganib a hi gwahtiqsamo romriq tigiqisihdaq ham. Mat romriqab luwad in ezaq lehaqta na ago in anad a hi em hasaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Muran saw anuwan na oysa ne anan helmo haqiy ham. Ne helmo haqeq teq ne saw anuwan na ago onmin tiqiy daqay ham. Ari Yesus gamuk na bilaqim tihiqiyan in on mataw na gihulosad lehim gimeb tuqulilam. ");
INSERT INTO mlp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesus kabiy azawayin inaqta kabemmo on mataw gimeb amta teq in anan helmo a hi haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","On mataw na daq nazaq emim in God ago nantut Aisaya gamuk bilamta na tuwol net bugiy. Aisaya bilam, Iyahta ham nog i gigo gamuk anan helmo haqaqta? ham. Teq ni kabiy awaz meqin diqta emsa nog ahol waqad anad em hasaqta? ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","On mataw na Yesus anan helmo haqgo ginad soqotim diq usyaqta. Teq Aisaya daq na alulin bilaqad in gamuk araq kazaq bilammo. ");
INSERT INTO mlp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","In bilam, God in mataw na gimeqnagin eman in saw a hi waqayta ham. Ad in ginad eman soqotim diq usaqta ham. Luweq in gime nagah ahol waqad in ginad em haseq teq in ginad buliyeq God ago hib ta bol daqay haqad ham. Bolid teq God in giwastitayid dimniy daqay haqad ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaya in Yesus ago zaway teq in ahol anuwan ahol waqim teq in Yesus-mo ananib gamuk na bilaqan usta. ");
INSERT INTO mlp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Helmo Juda gigo mataw marorta kabemmo in Yesus anan helmo haqiyta. Teq in Farisi ginan rabad in ulalabmo Yesus anan helmo a hi bilaq yaqay. Luweq Farisi gimuzid in Juda gigo bit humab wolaytab mataw nenaq lotu a ta hi em daqay haqad. ");
INSERT INTO mlp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Na ezaqgo mataw na in gigo walmataw gigo hib gibin dimunta waqnan ginad bilaqad teq in God ago hib gibin dimunta waqnan giqutil a hi eraqyaq. ");
INSERT INTO mlp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ari Yesus lileyim bilam, On mataw ya inan helmo haqayta na in ya imomo inan helmo a hi haqayta ham. Na in mat ya iqeman bolta na anan helmo haqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ad on mataw ya ibiyayta na in mat ya iqeman bolta na ahol waqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ya og ka ago saw anuwan ham. On mataw ya inan helmo haqayta na romriqab a ta hi os daqay haqad ya bolta ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ari on mataw yaqgo gamuk huritad teq in a hi muzinayta na yaqmo diq in gigo daq na a hi ulum kemdaiq ham. Ya og kab on mataw giyon hazizir emeq gigo daq ulum kemnan a hi bol ham. Ya on mataw gilumsiheq ta giwaqeq ban dimuntab giqemid osnan haqad ya bolta ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ari on mataw gileh yagad yaqgo nan a hi huritsa nagah araq teq in giyon hazizir emdaqta nawa usaq ham. Na yaqgo gamuk ya bilayta naqmo ham. Yaqgo gamuk naqmo in kam abebtanta nab on mataw na gigo daq tuqulum kemdaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na ezaqgo ya inadibmo gamuk na a hi bilayta ham. Gimam Iyah ya iqeman bolta naqmo in gamuk awaz meqinta na yag ham. Yagad ya ezaq haqad gamuk bilaqdaiqta na inmo iqisihunan ya nazaqmo bilayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ad ya inad emaiq, God ago gamuk awaz meqinta na in mataw giqemid kayeqmo kuluwa-kuluwmo tuqos daqay haqaiq ham. Nazaq iyan gamuk nawa ya bilaqaiqta na ya imammo ibilanta nazaqmo diq ya ne gibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ari Pasova ago kam ayahta na bolim sinsin diq tiqiysa Yesus anad tiqam, Ya og ka huloseq imam ago hib lehdaiqta na akaman sinsin tiqiyaq ham. Yesus in ago on mataw og kabta na ginan anad bilaqsa osta. Osad in ginan anad bilaqsa osim le in gimen ahol nog tuhulos. ");
INSERT INTO mlp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ari imisor Yesus ago disaipel nenaq didaq neqad tuqosiy. Ossa Satan tekomo anad meqinta Judas ugan in Yesus waqeq bab gibenab emgo anad tiqemyaq. Mat na in Saimon uliq Kariyot-ibta atatin. ");
INSERT INTO mlp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Samo Yesus anad emyaq, Ya imam zaway bunmo ya ibenab tiqam haqyaq. Haqad in God ago hib osim bolim ta God ago hib in muleqim ta lehaqta na in tuhuritmo. ");
INSERT INTO mlp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Huritim in didaq neqim hulosad in eraqim turad ago aholsihen sisaqta hasim emad teq in giholbay araq waqim ahulib tuhuram. ");
INSERT INTO mlp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hureqim in yuw waqim deg araqab wazbalan woqan in deg na waqim disaipel gisen tisuholyaq. In araq asen yuwub suholeq teq in giholbay ahulib hureqan usta na amalib asen tubayyaq. ");
INSERT INTO mlp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","In nazaq emim emim a lehim le Saimon Pita ago hib tubol. Bolan Pita tubulon, Iyahta ham ni ya isen tisuholnan e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Haqan Yesus bilam, Muran daq kawa ya emaiqta ka ago ni ninad a hi em hasaq ham. Abeb teq ni ninad tiqem hasdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Haqan Pita bulon, Ni ya isen a hikidik suholdaq ham. Haiq diqmo ham. Haqanmo Yesus bilam, Ya nisen a hi suholid ni yaqgo disaipel a hi iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Haqan Saimon Pita bilam, Iyahta ham, nazaq na ni ya isen amomo hi suhol ham. Ni ya isen suholad ya iben teq ifaqin inaqmo ni suhol ton ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Haqan Yesus bilam, Mat tuhuzta na asen suholeqmo in ahol bunmo anumlan haiqmo tiqiydaq ham. In ahol bunmo a ta hi suholdaq ham. Ari ne bunmo gihol anumlan haiqta ham. Teq ne gilikmanib mat amulikmoqmo ahol anumlan inaqta osaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Na ezaqgo mat nog Yesus waqeq bab gibenab emdaqta na ago in tuhurit. Nazaq iyan in bilam, Ne gilikmanib mat amulikmoqmo ahol anumlan inaqta osaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ari Yesus in gisen tisuholim in ago aholsihen ta emim teq in le abanab a ta os. Osad in disaipel gibilan, Ya ne gigo hib daq tiqemta ka ago ne ginad tiqem hasiy ye? ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ne ya inan giger Tisa teq Iyahta haqad biyayta ham. Na ne dimunmo bilaqayta ham. Ya mat nazaqtaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ya ne gigo Iyahta teq ya ne gigo Tisa-mo ham. Teq ya ne gisen tisuhol ham. Nazaq iyan ne nazaqmo an asen tisuhol daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ya daq na tigiqisihun ham. Giqisihunan ne ya isen muzeq ya ne gimen daq emta nazaq ne tiqem daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ya helmo gibilenaiq ham. Kabibiy mat in ago ayahta a hi itiyondaq ham. Ad mat nantut waqim a lehaqta na in nan na anamren a hi uriyamdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ne daq ka ago ginad em hasay ye? ham. Ne ginad em hasad daq kawa ya emta kazaqmo ne emsa teq God ne ginan anad tidimniydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ya mataw iholyon gilumim giwayta na gigo tuhurit kemta ham. Teq gamuk kawa ya gibilenaiqta ka ya ne bunmo ginan a hi bilaqaiq ham. Haiq ham. Ne gilikmanib mat araq yaqgo a haiqta osaq ham. Mat na teq God ago marib gamuk araq usaqta na tuwol net bugdaq ham. Gamuk na bilam, Mat ya inaq garab didaq newta na in asenab tiqibay has haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Teq daq na a hi gwahtiqsamo ya kawa ne tigibilenaiq ham. Abeb daq na gwahtiqsa ne ahol waqad ya inan bilaq daqay, Helmo gamuk God ago marib usaqta na in yaqmo inan bilamta haq daqay haqad muran ya ne ginadib tiqemaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ya helmo gibilenaiq ham. Mat araq in yaqgo kabibiy mat ya eman in ago hib bolta na ahol waq hasad wazinaqta na in yaqgo kabibiy mat na amomo a hi wazinaq ham. In ya iwaqim iwazinaqmo ham. Teq in ya imomo a hi iwazinaq ham. In mat ya iqeman bolta na inaqmo tuwazinaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus nazaq bilaqim teq in ahol afaqan iyad anad timeqniyyaq. Anad meqniysa in bilam, Ya helmo gibilenaiq ham. Ne gilikmanib mat araq teq ya iwaqeq bab gibenab iqemdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Haqanmo disaipel an anobun ahol tuwaq yaqay, Yesus nog diq anan bilamta haqad. ");
INSERT INTO mlp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sa Yesus ago disaipel araq in anan anad diq bilaqaqta na in banab ahol wol emim Yesus anognib us. ");
INSERT INTO mlp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ussa Saimon Pita afaqin ugad kabiyakibmo bulon, Ni susumun ug ham. In nog diq anan bilaqaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","An disaipel na Yesus anogib usadmo in afaqin Yesus abanibmo emim tisusumun ug, Iyahta ham ni nog diq anan bilaqaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Haqan Yesus bilam, Ya bret anabun asor waqeq degib taqor ulum tureq mat doqag ya ugdaiqta na nawaqmo ham. Haqadmo in bret waqim taqor ulum turim Saimon uliq Kariyot-ibta atatin Judas-mo tuqug. ");
INSERT INTO mlp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ugan Judas waqsamo Satan aholib tubol. Anmo Yesus in Judas bulon, Ni daq emnan ninad emaqta na hidmo le em ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Haqsa disaipel bunmo gamuk na huritim in ginad a hi em hasiy. ");
INSERT INTO mlp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Asor ginad emiy, Judas mani wamuzaqta iyan Yesus Pasova ahumabun emgo anaghan zaygo bulonaq haqiy. Haqsa ta asor ginad emiy, Yesus in mataw gina haiqta nagah neggo Judas bulonaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Anmo Judas bret na tuwaqim hidmo in eraqim bit na hulosad asanib gwahtiqim tilah. Sa tarom tiqiy. ");
INSERT INTO mlp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas tilehsa teq Yesus bilam, Muran Mat Atatin abin ayah tiqiy ham. Ayah iysa in God abin eman ayah tiqiymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ari Mat Atatin God abin emid ayah iysa God inmo ahol abin Mat Atatin ugid in abin ayah tiqiydaqmo ham. Teq in muran diqmo Mat Atatin abin emid ayah iydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Onmin ham ya nenaq asitmo a ta oseq teq ya tilehdaiq ham. Lehid teq ne ya tiqinagun daqay ham. Ya Juda mataw gibilenta nazaqmo ya ne tigibilenaiq ham. Ya uliq lehdaiqta nab ne a hi leh daqay haqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ya gunun araq muturta tinegaiq ham. Ne an anan ginad diq bilaqsa osiy ham. Ya ne ginan inad bilaqaiqta nazaqmo ne an anan ginad bilaqsa osiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ne an anan ginad bilaqsa ossa teq on mataw bunmo ne gibiyad ginad tiqem daqay, Yesus ago disaipel kowaqmo haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Haqan Saimon Pita in Yesus bulon, Iyahta ham ni edob lehnan? ham. Haqan Yesus bilam, Muran ya uliq lehdaiqta nab ni ya imuzeq a hi lehdaq ham. Abeb teq ni ya imuzeq boldaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Haqan Pita bulon, Iyahta ham ezaqgo ya muran ni nimuzeq ninaq a hi lehdaiq? ham. Ya nilumsihad ihol nog huloseq ninmen tumoqdaiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Haqan Yesus gamuk na amenin emim bilam, Ni ya ilumsiheq moqgo bilaqaq e? ham. Ya helmo nibilenaiq ham. Kurek a hi gayonsamo ni nime ezeqmanmo gileh tiyagdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ari Yesus in ago disaipel bunmo gibilenim bilam, Ne gihol afaqan iysa ginadnad hi emiy ham. Ne God anan helmo haqad ne ya inan helmo haqiymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ya imam ago bit adugan kabemmo usaqta ham. Nazaq iyan ya leheq ne gimen ban wastitaynan ham. Ya nazaq emnan inad a hi usta iyid ya ne gimen ban wastitaynan haqad nazaq a hi gibilen nagta ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ya leheq ne gimen ban wastitayeq teq ya muleqeq ta boldaiq ham. Boleq ya ne giwaqeq giqad yaqgo sawab tilehdaiq ham. Giqad lehid uliq ya osdaiqta nab ne tuqos daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Teq ya uliq lehdaiqta na ago dante ne tuhuritiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Haqan Tomas bilam, Iyahta ham ni edob lehdaqta na i a hi hurit ham. I ezaq toneq teq dante na ago hurit kemam? ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Haqan Yesus bulon, Dante ya imamgo hib lahta na yaqmo ham. Ya gamuk helta alulinmo diq ham. Teq yaqmo on mataw giqeman kayeqmo kuluwa-kuluwmo osayta ham. On mataw dante amulikmo ya gimen emdaiqta naqmo muzineq teq in le ya imam ago hib tugwahtiq daqay ham. Dante amo amo haiqgam ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ne yaqgo huriteq teq ne ya imam ago tuhurit daqaymo ham. Ari muran ne in ago tuhuritad teq ne in ahol tuwaqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Haqan Filip bulon, Iyahta ham ni nimam i giqisihun ham. Giqisihunid i ahol waqad teq i ginadnad a ta hi emad i nagah araq ago a hi susumunam ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Haqan Yesus bulon, Filip ham ya nenaq kam sisaqmo tuqos ham. Ta teq ni yaqgo a hi huritaq e? ham. Mat ya ibiyaqta na in ya imam ahol waqaqmo ham. Ezaq haqad ni bilaqaq, “Ni nimam i giqisihun” haqaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ya imam ago hib ossa in yaqgo hib osaqmo ham. Na ne anan helmo a hi haqay e? ham. Ya gamuk gibilenaiqta ka ya inadibmo a hi bilaqaiq ham. Ya imam ya iholib osad ago kabiy emaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ya bilay, Ya imam ago hib ossa in yaqgo hib osaq hayta na ne anan helmo haqiy ham. Ari ne yaqgo gamuk na anan helmo a hi haqeq teq ne yaqgo kabiy naqmo anadin emad ya inan helmo haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ya helmo gibilenaiq ham. Mat ya inan helmo haqaqta na in ya kabiy emaiqta nazaqmo in kabiy tiqemdaqmo ham. Teq in kabiy ayahmo diq emad in ya kabiy emta na tuquriyamdaq ham. Na ezaqgo ya imam ago hib lehdaiqta na ago ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Lehid teq ne ya ibinib nagah anan susumunsa ya tiqem negdaiq ham. Nazaq iyid teq Gimam Iyah in Atatin ago hib abin ayahta tuwaqdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ne ya ibinib nagah araq ago susumun yagsa ne ginad usaqta nazaq ya tiqem negdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ari Yesus bilam, Ne ya inan ginad bilaqsa teq ne yaqgo gunun ya giqisihunta na bunmo anonon diqmo tumuzin daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Teq ya imam susumun ugid in ne giteqsor araq awaz meqinta tinegdaq ham. Negid in ne nenaq tuteqmo tuqosdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mat ne gilumsihdaqta na in God ago Bugaw gamuk helmo bilaqaqta naqmo ham. Og kab on mataw God gileh ugayta na in God ago Bugaw ahol a hi waqad teq in ago a hi huritayta ham. Nazaq iyan in Bugaw na a hi waq daqay ham. Ari negmo teq Bugaw na ne gilikmanib osaqta ham. Osad in teq ne giduganib tuqosdaqmo ham. Nazaq iyan ne in ago tuhuritayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ya ne gihulosid ne onmin ginenmaman haiqta nog a hi os daqay ham. Haiq ham. Ya teq ne gigo hib ta boldaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sisaq haiq og kab on mataw God gileh ugayta na a ta hi ibiy daqay ham. Ari negmo teq ya tiqibiy daqay ham. Ya kayeqmo osaiqta ham. Nazaq iyan ne kayeqmo tuqos daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kam nab teq ya imam ago hib osaiqta na ago ne tuhurit daqay ham. Teq ne yaqgo hib ossa ya ne gigo hib osaiqta na ago ne tuhurit daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","On mataw yaqgo gunun giwaqim muzinayta na in ya inan ginad bilaqayta ham. Teq in ya inan ginad bilaqsa ya imam in ginan anad bilaqdaqmo ham. Sa ya nazaqmo mataw na ginan inad bilaqsa ihol tigiqisihundaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesus nazaq haqsamo Judas ta araq, in mat uliq Kariyot-ibta na a haiqta, in Yesus kazaq bulon, Iyahta ham ezaqta ago ni nihol i gimomo giqisihundaq? ham. Ad ni og kab on mataw ta asor na bunmo nihol a hi giqisihundaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Haqan Yesus bilam, Mat ya inan anad ayahmo bilaqaqta na in yaqgo gamuk tumuzdaq ham. Sa ya imam in mat na anan anad ayahmo tibilaqdaq ham. Ad ya imam inaq boleq i mat na inaq kuluwa-kuluwmo tuqosam ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ari mat ya inan anad a hi bilaqaqta na in yaqgo gamuk a hi muzinaqta ham. Teq ya gamuk negaiqta ka in yaqgota a haiq ham. Gamuk na in ya imam iqeman bolta naqmo ago gamukta ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ya nenaq osad gamuk nawa na bunmo tigibilenta ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ari ya imam teq ya ibinib inmo ago Bugaw Dimunta na emid tuboldaq ham. Ne giteqsor na boleq teq in ne gilumsihad nagah bunmo ago asuleqin tinegdaq ham. Ad in ne ginad enqenunid eraqsa ne yaqgo gamuk bunmo ya negta na anadin a ta em daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ya ne giqemid ne gigem kute nemsa os daqay ham. Yaqmo igem kute nemim usaqta nazaq nogmo ya negid ne gigem kute tinemdaqmo ham. Teq on mataw og kabta gigem kute nemsa osayta nazaq nog ya a hi negdaiq ham. Ne gihol afaqan iysa ginadnad hi emiy ham. Ad ne hi rabiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ari ya gibilenim bilay, Ya ne gihuloseq leheq teq ya ne gigo hib a ta boldaiq haqsa ne tuhuritiy ham. Ne ya inan ginad bilaqid teq ya bilay, Ya imam ago hib lehaiq haqsa ne huritad ginad tidimniy nagiy ham. Na ezaqgo ya imam ago zaway in yaqgo zawayta uriyamim usaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Daq nawa ya teko anan bilayta na a hi gwahtiqsa ya anan kawa ne tigibilenta ham. Abeb daq na gwahtiqsa ne ahol waqad teq ne ya inan helmo haq daqay haqad ya muran kawa ne tigibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ya nenaq nan sisaqmo bilaqad osgo akamun haiq tiqiyaq ham. Na ezaqgo mat meqinta og ka wamuzim osaqta na tubolaq ham. Teq in anadibmo ya imeqin tongo in ago zaway haiqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ya imam ibilanta nazaqmo ya emaiqta ham. Ya nazaq emad teq ya imam anan inad bilaqaqta na ulal iysa on mataw og kabta bunmo tuhurit daqay ham. Ari ne eraqiysa i lehuq ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yaqmo am wain-mo diq ham. Sa ya imam in am wain na anamren ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Teq ya imam in ya iben anon a hi emayta na bunmo giqurotim hunegaqta ham. Ad in ya iben anon emayta na bunmo gisawan emad in ya iben samanta dimunta giqisih ugim usayta na giqurotim hunegsa iben dimunta na anon kabemmo emayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ari ya gamuk tigibilenta naqmo in ne gisuholan ne giholib ginumlan haiq tiqiyiyta ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ne ya iholib soqoteq inaq ossa teq ya ne gigo hib tuqosdaiqmo ham. Am wain aben ahulib a hi soqoteq anon a hi emdaqta ham. Ad nazaqmo ne yaqgo hib a hi soqoteq ne ginon a hi em daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Am wain na yaqmo ham. Sa ne ya iben ham. On mataw yaqgo hib ossa ta ya in gigo hib osaiqta na in ginon kabemmo emayta ham. Na ezaqgo ne ya ihulos yageq ne ginon araq a hikidikmo em daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ya imam in on mataw yaqgo hib soqotim a hi osayta na giqurot tayan in miliyawim may bugayta ham. Bilaqne mataw ay aben samanta urot tayim hunegan lehim mayaqta nazaq ham. Mataw am aben naqanta ginuwim faqab eman oyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nazaq iyan ya ne gigo hib ossa yaqgo gamuk ne gigemab ussa ne nagah ginad usaqta na ago susumun yagsa ya ne gimen tiqem negdaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ya ne gibilenaiq ham. Ne yaqgo disaipel iyeq ginon kabemmo emiy haqaiq ham. Na ezaqgo ya imam daq naqmo ago hib abin ayahta waqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ya imam ya inan anad bilaqaqta nazaqmo ya ne ginan inad bilaqaqmo ham. Nazaq iyan ya ne ginan inad bilaqsa ne hi ihulosiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ne yaqgo gunun ya tinegta na muz bugsa teq ya ne ginan inad bilaqsa ne a hi ihulos daqay ham. Ya imam ago gunun muz bugsa in ya inan anad bilaqsa ya in a hi hulosaiqta nazaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yaqgo inad dimniy in ne gigemab ayahmo usdaq haqad ya gamuk ka gibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Teq yaqgo gunun na in kazaq ham. Ya ne ginan inad bilaqaqta nazaqmo ne an anan ginad bilaqanmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mat araq ayogniz ginadin emad gilumsihad gimen ahol nog hulosdaqta na, daq na in an anan ginad bilaqgo adan bunmo giquriyamim in ameb diqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ne yaqgo gunun ya nawa tigibilenta na muz bugad teq ne ya iyognizmo diq tiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kabibiy mat ago ayahta daq emsa in daq na alulin a hi hurit kemaqta ham. Teq ne nazaq a haiq ham. Ya imam ago hib gamuk bunmo huritta na ya ne tigibilen bug ham. Nazaq iyan ya ne ginan yaqgo kabibiy mataw nazaq a ta hi bilaqdaiq ham. Muran ya ne ginan ya iyognizmo diq tibilaqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ne ya inan ni i gigo haqan ya a hi osaiqta ham. Haiq ham. Yaqmo ne ginan yaqgo haqan ne osayta ham. Ne yaqgo kabiy emgo haqad ya ne gitowun tiqem ham. Emad ya bilay, Ne leheq yaqgo kabiy emsa ne gigo kabiy na anon eman hay ham. Anon emid teq anon na tuqus tutdaq haqad ya bilay ham. Nazaq iyan ne ya ibinib nagah araq anan Gimam Iyah bulonid in tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ya gunun kazaqmo ne negaiq ham. Ne an anan ginad bilaqsa osiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Og kab on mataw God gileh ugayta na gigem meqinta negsa teq ne ginad emiy ham. Mebmebmo in gigem meqinta ya yagiymo haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Helmo ne og kabta iyid teq on mataw og kabta ne ginan ginad bilaq nagiy ham, in gimo an anan ginad bilaqsa osayta nazaqmo ham. Teq haiq ham. Ya on mataw og kabta bunmo gilikmanib ne giluwiyim giwaqan ne og kabta a ta hi iyay ham. Nazaq iyan on mataw og kabta gigem meqinta ne negayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Teq on mataw God gileh ugayta na in ya ibaymuzad imeqin toneq in ne gibaymuzad gimeqin ton daqaymo ham. Ari on mataw yaqgo gamuk huriteq in ne gigo gamuk tuhurit daqaymo ham. Nazaq iyan ya mebmebmo ne gibilenim bilay, Kabibiy mat in ago ayahta a hi itiyondaq hayta na ne anadin emiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mataw og kabta na in mat ya iqeman bolta na ago a hi huritayta ham. Nazaq iyan ya ibin ne gigo hib ussa in ne gibaymuzad gimeqin ton daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Helmo ya mataw na gigo hib boleq a hi gibilenta iyid in daq meqinta emayta na ananin a hi waq nagiy ham. Teq ya bolim tigibilen ham. Nazaq iyan in daq meqinta emayta na ananin tuwaq daqay ham. Ananin waqad in gamuk araq bilaq daqayta haiq tiqiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mat agem meqinta ya yagad in agem meqinta God ugaqtamo ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mat araq boleq ya kabiy emta nazaq in a hi em nag ham. Nazaq iyan ya og kab boleq kabiy a hi emta iyid mataw og kabta in daq meqinta emayta na ananin a hi waq nagiy ham. Teq haiq ham. Ya og kab bolim kabiy emsa in ahol tuwaq kemiy ham. Ahol waqad in gigem meqinta ya yagad in ya imam tuqugaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","In gigo daq nawa na in gamuk araq in gigo marorib mar tonan usaqta na tuwol net bug ham. Gamuk na bilam, Mataw na gigem meqinta samanta yagiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ari ya imam ago hib leheq teq ya ne giteqsor na emid ne gigo hib tuboldaq ham. Na in God ago Bugaw Dimunta gamuk helta bilaqaqta ham. In Gimam Iyah inaq osaqta ham. In boleq ya mat ezaq diqta na ago ne tigibilendaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Teq kwaziqmo ya og kab kabiy alulin emsa ne ya ibiyad osim bo muran kawa tiqiy ham. Nazaq iyan ne nagah gimeb ahol waqiyta na ago ne on mataw gibileniymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ne ginad ya inan helmo haqayta na hi hulosiy haqad ya gamuk ka gibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Abeb mataw ne gibaymuzsa ne in ginaq bit humab wolaytab humab a ta hi wol daqay ham. Helmo kam nab mataw na ginad em daqay, I Yesus ago mataw ka ginol emad i bilaqne God ayon tamaz em nog iyauq haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mataw na ya imam ago a hi huritayta ham. Ad in yaqgo a hi huritaymo ham. Nazaq iyan in ne nazaq tigiton daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Abeb mataw nazaq ne gimeqin tonsa ne yaqgo gamuk ka anadin a ta em daqay haqad ya muran kawa ne tigibilenaiq ham. Kwaziqmo ya nenaq luw osad nagah kagan ago ya ne a hi gibilenta ham. Na ezaqgo ya nenaq osad iyan ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ari muran ya muleqim ya imam iqeman bolta na ago hib ta lehaiq ham. Ta teq ne gigo araq diq ibilenim bilaqaq, Ni edob lehaq? nazaq in a hi susumun yagaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ad muran ya gamuk ka gibilensa ne huritad ginad a hi em hasad ne gigem afaqan diq iyaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ya helmo ne gibilenaiq ham. Ya ne gilumsihnan haqad ya gihulosim imam ago hib tilehaiq ham. Ya nab a hi lehid teq ne giteqsor na ne gigo hib a hi bolnag ham. Nazaq iyan yaqmo leheq teq mat na emid ne gigo hib tuboldaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","In og kab boleq on mataw God gileh ugayta na bunmo giqisihunsa in daq meqinta emay na ago gihol tiloyin daqay ham. Ad in giqisihunsa in ezaq toneq God ameb titnonta iy daqayta na ago tuhurit daqay ham. Ad in giqisihunsa in teq hazizirib tursa God in gigo daq gilum kemdaqta na ago in ginad tiqem has daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","On mataw God gileh ugayta bunmo in ya inan helmo a hi haqayta ham. Nazaq iyan ne giteqsor na boleq in on mataw na giqisihunsa in daq meqinta emay na ago gihol tiloyin daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Teq ya imam ago hib lehid ne a ta hi ibiy daqay ham. Nazaq iyan ne giteqsor na in on mataw og kabta na giqisihunsa in ezaq toneq God ameb titnonta iy daqayta na ago tuhurit daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Teq God in mat meqinta og ka wamuzim osaqta na hazizirib emim ayon tibilamta ham. Nazaq iyan ne giteqsor na in on mataw God gileh ugayta bunmo giqisihunsa in teq nazaqmo hazizirib tursa God in gigo daq gilum kemdaqta na ago in ginad tiqem has daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Yaqgo gamuk kabemmo ne gibilendaiqta usaq ham. Teq ne muran huritgo ginad siqim iyaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ari abeb God ago Bugaw gamuk helta bilaqaqta na boleq in ne ginad wamuzsa ne gamuk helta bunmo alulin tuhurit daqay ham. Teq in anadibmo gamuk a hi gibilendaqta ham. In yaqgo hib gamuk huritaqta naqmo tigibilendaq ham. Ad in nagah abeb teq gwahtiqdaqta na ago tigibilendaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","God ago Bugaw na in ya ibin emid ayah iydaq ham. Na ezaqgo in yaqmo igo gamuk waqeq ne gibilendaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ya imam ago nagah bunmo in yaqgota ham. Nazaq iyan ya bilay, God ago Bugaw in yaqmo igo gamuk waqeq gibilendaq hay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kam asitmo tihiqiyid teq ne a ta hi ibiy daqay ham. Ad kam asitmo loq nog iyeqmo ne a ta ibiy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Haqan in ago disaipel asor an bulonim bilaqiy, In bilaqaq, Kam asitmo tihiqiyid teq ne a ta hi ibiy daqay haqaq haqiy. Ad kam asitmo loq nog iyeqmo ne a ta ibiy daqay haqaq haqiy. Teq in bilaqaq, Na ezaqgo ya imam ago hib lehaiqta na ago haqad in bilaqaq haqiy. Gamuk ko alulin ezaq diqta in i gibilenaq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Haqadmo in bilaqiy, Kam asitmota nawa in anan bilamta na in naga diq anan bilaqaq? haqiy. Nan kowa in bilaqaqta ko alulin ago i ginad a hi em hasauq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Haqsa Yesus anad tiqam, Yaqgo disaipel in nan na ago susumun yagnan ginad emay ham. Haqad in gibilan, Ya bilay, Kam asitmo tihiqiyid teq ne a ta hi ibiy daqay hay ham. Ad kam asitmo loq nog iyeqmo ne a ta ibiy daqay hay ham. Nan nawa ya bilayta na ago ne an bulonad osay ye? ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ya helmo ne gibilenaiq ham. Ne gaqad gaq ayahmo tuwaz daqay ham. Sa on mataw God gileh ugayta na in ginad diq tidimniy daqay ham. Ne ginad ayahmo meqniydaq ham. Ta teq ne ginad meqniydaqta na hiqiysa ne ginad tidimniy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aw amun baysa anad meqniyaqta ham. Na ezaqgo in amun emdaqta akaman tugwahtim ham. Ari in amun tiqemimmo in santitiy na anadin a ta hi emaqta ham. Na ezaqgo in ago amun muturta og kab tugwahtimta na ago in anad tidimniyaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ad nazaqmo muran ne ginad ayahmo meqniyaq ham. Teq abeb ya bo ne ta gibiydaiqta nabmo ne ginad a ta dimniydaq ham. Ginad dimniysa mataw ne gigo ginad dimniy na walemgo biyab a hi iy daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kam nab ne nagah araq ago a ta hi susumun yag daqay ham. Ya helmo gibilenaiq ham. Ne nagah araq ago ginad emad ya ibinib imam bulonsa in tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kwaziqmo ne nagah araq waqgo haqad ya ibinib a hi susumuniyta ham. Ari muran ya ne gibilenaiq ham. Ne susumuneq teq ne tuwaq daqay haqaiq ham. Waqeq ne ginad dimniy hassa osad ne nagah araq ago ginad a hi meqniydaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Gamuk kawa ya bilaqaiqta ka ya gamuk awowunmo bilaqaiqta ham. Ari abeb teq ya gamuk awowun amalib a ta hi gibilendaiq ham. Kam na tugwahtiqnan tonaq ham. Gwahtiqid teq ya imam abin anononmo bilaq sireqeqmo tigibilendaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kam nab ne ya ibinibmo Gimam Iyah tisusumun ug daqay ham. Ya ne gimen Gimam Iyah susumun ugid in ne gilumsihdaq nazaq ya a hi bilaqdaiq ham. Na ezaqgo negmo teq Gimam Iyah tubulon daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ne ya inan ginad bilaqsa osiyta ham. Ad ya imam ago hib osim bolta na ne anan helmo tihaqiymo ham. Nazaq iyan Gimam Iyah ne ginan anad bilaqaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kwaziqmo ya imam inaq osim teq ya hulosim og kab bolta ham. Ta muran ya og ka hulosad ya imam ago hib ta lehaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Haqan in ago disaipel bilaqiy, Muran ni nan tibilaq sireqaq haqiy. Bilaq sireqad ni gamuk awowun a ta hi bilaqaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Muran i ginad tiqem hasauq haqiy. Ni nagah bunmo ago tuhurit kamta haqiy. Mataw gigo susumun ginadib ussa in a hi bilaqsamo ni amenin emaqta haqiy. Nazaq iyan i ginad emauq, Ni God-mo agerab osim bolta haqauq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Haqan Yesus amenin emim bilam, Muran ne helmo tihaqay ye? ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ne huritiy ham. Mataw ne gimuzsa ne hares iyad giquliqab tukeq tileh daqay ham. Lehad ne ya ihulosid ya imomo tuqosdaiq ham. Kam na tugwahtiqnan tonad teq in tugwahtimta nog tiqiy ham. Ta teq ya imomo diq a hi osdaiq ham. Na ezaqgo ya imam in ya inaq osaqta ham. ");
INSERT INTO mlp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ne ya iholib soqoteq inaq osad ne gigem kute nemdaq haqad ya gamuk ka gibilenaiq ham. Ne og kab ossa afaqan teq ne gigo hib tugwahtiqdaq ham. Teq ne giwaz meqniyiy ham. Ya og ka ago zaway tuquriyam bugta ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus gamuk nawa na tibilaqim teq in ame ulilib Heven-ib gwalsa bilam, Ya imam ham, ya ibin ayah iydaqta na akaman tugwahtim ham. Nazaq iyan ni nitatin abin emid ayah iyan ham. Ayah iyid teq in ni nibin emid ayah tiqiydaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ni og kab on mataw bunmo giqeman in ni nitatin ahaqenib tiqiyiy ham. Ad ni nitatin zaway ayahmo tuqugmo ham. Zaway ugan in mataw ni ugta na giqemid in tuteqmo kuluwa-kuluwmo tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Teq os dimunta ahiqiy haiqta na alulin in kazaq ham. On mataw God diqmo ago tuhurit daqay ham. Huritad in Yesus Krais mat ni eman bolta na ago tuhurit daqaymo ham. Mataw na i gigo nazaq diq huriteq teq in os dimunta kuluwa-kuluwmo osayta na tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ni kabiy yagta na ya eman tihiqiy bug ham. Ya nazaq emim nibin eman og kab ayahmo diq tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kwaziqmo og ka a hi gwahtiqsamo ya ibin ayahta inaq ni nimeb osyaiqta ham. Ari muran ni ya ibin ayahta na a ta yagid kwaziqmo ya nimeb osyaiqta nazaqmo ya ta osiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ni on mataw og kabta asor giyagan ya in gigo hib ni nibin eman ulal tiqiy ham. Mataw na in ningota ham. Teq ni mataw na tigiyag ham. Yagan ya ningo gamuk gibilenan in tumuz bugay ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Muran in ginad emay, Ni nagah bunmo yagta na in ninmo ningo hib bolta haqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Na ezaqgo ya gamuk bunmo ni yagta na tigibilen bug ham. Teq ya ninaq osan ni ya iqeman bolta na ago in huritim anan helmo tihaqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ni yaqgo on matawmo diq gilumsihdaq haqad ya kawa ni tinibilenaiq ham. Ya og kab on mataw gileh nigayta na gimen a hi nibilenaiq ham. Haiq ham. Ni on mataw giyagta naqmo ni gilumsihdaq haqad ya nibilenaiq ham. Na ezaqgo mataw naqmo in ningota ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yaqgo on mataw in ningota ham. Ad ningo on mataw in yaqgota ham. Nazaq iyan yaqgo on mataw na gigo hib ya ibin ayahta tuway ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Muran ya og kab a ta hi osdaiq ham. Ta teq yaqgo on mataw ka og kab tuqos tut daqayta ham. Os tutsa ya gihuloseq ningo hib tilehdaiq ham. Ya imam dimun diqta ham, ni nibin ayah diqta na tiyag ham. Nazaq iyan ni yaqgo mataw ya ibinib osayta ka giwamuz ham. Giwamuzsa in ginad gigem amulikmo iyeq osiy ham. Ya ninaq ginad gigem amulikmo iyim osauqta nazaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ni nibin ayahta na tiyag ham. Yagan ya mataw ya ibinib osayta ka giwamuzsa in dimunmo osayta ham. Ya in giwamuzsa in gigo araq diq nabag a hi iy ham. Ari mat amulikmo ni anan bilam, In teq meqniydaq hamta naqmo amomo in nabag iyta ham. Iyan daq na in ningo marib mat na ananin usaqta na tuwol net bug ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Muran ya ningo hib tilehaiq ham. Teq yaqgo inad dimniy in yaqgo on mataw gigemab ayahmo usdaq haqad ya og kab nenaq osad gamuk kagan bunmo tigibilen bug ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ya og kabta a haiq ham. Ad nazaqmo ya ningo gamuk yaqgo on mataw tinegan in ya isen muzim in og kabta a haiqmo ham. Nazaq iyan on mataw og kabta in yaqgo on mataw gigem meqinta negayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ni yaqgo on mataw giwaqid in og kab a ta hi os daqay haqad nazaq ya a hi nibilenaiq ham. Yaqgo on mataw og kab ossa ni giwamuzsa mat meqinta na hi gimeqin tonan haqad ya nibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ya og kabta a haiq ham. Ad nazaqmo yaqgo on mataw in og kabta a haiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ningo gamuk in helmo diq ham. Nazaq iyan ningo gamuk helta na in yaqgo on mataw gigemab kabiy emsa ni giqemid in ningo on matawmo diq iyiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ni ya iqeman ya on mataw og kabta gigo hib bolta nazaqmo ya igo on mataw ka giqeman in on mataw na gigo hib tilehaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yaqgo on mataw ka in ningo gamuk helta huriteq teq in gihol bunmo nigad in ningo kabiy amomo emgo os daqay haqad ya nazaqmo ihol bunmo tinigim ya ningo kabiy amomo emgo tuqosaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ari ya mataw kawa nenaq osaiqta ka gimomo ginan a hi nibilenaiq ham. Haiq ham. Mataw ka leheq on mataw ta asor gibilenid helmo haq daqayta na inaqmo ya ginadin emad gamuk ka nibilenaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nibilenid ni yaqgo on mataw na bunmo giqemid in ginad gigem amulikmo iyeq os daqay haqad. Ya imam ham ni yaqgo hib ossa ya ningo hib osaiqta nazaqmo yaqgo on mataw in i gigo hib osiy haqad ya inad emaiq ham. Ossa on mataw ni gileh nigayta na in nazaq gibiyad in ya inan bilaq daqay, Helmo God in mat na eman bolta haq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ni ya ibin eman ayahmo tiqiy ham. An yaqgo mataw ya ibinib gigem ginad amulikmo iyeq os daqay haqad ya ihol abin ayahta na in tineg ham. Negid ya ni ninaq gigem amulikmo iyim osauqta nazaqmo in tuqos daqaymo haqad ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ya in gigo hib ossa ni yaqgo hib tuqosdaq ham. Nazaq iyid teq yaqgo on mataw ka gigem amulikmo tiqiy haseq os daqay ham. Ossa og kab on mataw ni gileh nigayta na in gibiyad ginad em daqay, Helmo haq daqay, God-mo Yesus eman bolta haq daqay ham. Haqad ni ya inan ninad bilaqaqta nazaqmo ni yaqgo on mataw ginan ninad bilaqaqta na ago in tuhurit daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ya imam ham, uliq ya osdaiqta nab ya on mataw ni giyagta na nenaq osnan inad bilaqaq ham. Ya nenaq ossa in ya ibin ayahta teq ya ihol anuwan ni giyagta na ahol tuwaq daqay ham. Kwaziq diqmo og ka a hi gwahtiqsamo ni ya inan ninad bilaqsa osta ham. Na ago ni nagah aseseqta na tiyag ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ya imam ham, ni daq titnonta emaqta ham. Og kab on mataw gileh nigayta na in ningo a hi huritayta ham. Teq ya ningo tuhuritta ham. Sa ni ya iqeman bolta na ago yaqgo on mataw ka tuhuritiymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ya nibin eman yaqgo on mataw gigo hib ulal tiqiyta ham. Teq ya nibin emid in gigo hib ulal tiqiy hasdaq ham. Ulal iy hassa teq ni ya inan ninad bilaqaqta na ago adan in gigo hib ussa ya in gigo hib tuqosdaiqmo ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus gamuk na bilaqim tihiqiyan in ago disaipel nenaq lehim yuw anan Kidron haqay na asarqan tuqurotiy. Yuw na aqurumun kozaq ban uzaq araq gel tonan usta. In yuw asarqan na urotim lehim in uzaq na agelin aduganib le tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Teq Judas mat Yesus bab gibenab emdaqta na in saw na ago hurittamo. Na ezaqgo kam kabemmo Yesus ago disaipel nenaq uzaq nabmo leheq humab wol yaqayta na ago. ");
INSERT INTO mlp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nazaq iyan Judas in mataw tamaz emayta gigo aseseqta na giyogniz Farisi nenaq gigo hurmey asor teq Rom gigo bab mataw asor giwaqim in dan giqisihunim giqad saw nab tuboliy. Bolad mataw na em sebur giwaqim teq in lam sul mideran oysa in giwazim giqad boliy. ");
INSERT INTO mlp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Bolan Yesus daq bunmo aholib gwahtiqdaqta na ago tuhuritim in mataw biyahta na gigerab loqim tisusumun nag, Ne nog diq nagunay? ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Haqan mataw na bilaqiy, I Yesus uliq Nasaret-ibta nagunim bol haqiy. Haqan Yesus bilam, Na yaqmo kawa ham. Haqsa Judas mat Yesus bab gibenab emdaqta na in nab turmo. ");
INSERT INTO mlp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ari Yesus bilam, Na yaqmo kawa haqanmo mataw na hureq hasim ta lehim ogib woqim tuqusiy. ");
INSERT INTO mlp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sa Yesus a ta gibilan, Ne nog diq nagunay? ham. Haqan mataw na bilaqiy, Yesus Nasaret-ibta haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Haqan Yesus bilam, Ya ne tigibilenta ham. Yaqmo kawa haqaiq ham. Ari ne yaqmo inagunsun teq ne yaqgo mataw ka gihulosid lehiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","In nazaq bilaqadmo in teko God bulonim bilam, Ya mataw ni giyagta na giwamuzsa in gigo araq diq nabag a hi iy hamta na in tuwol net bug. ");
INSERT INTO mlp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yesus nazaq haqanmo Saimon Pita baqir araq asanib sihenim a bolta na tuhureq has. Hureq hasimmo in mat araq adeksan aqabun ger qwatayanmo ogib tuwom. Mat na anan Malkus haqayta. In tamaz mat danmebta ago kabibiy mat araq. ");
INSERT INTO mlp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Anmo Yesus in Pita bulon, Ni baqir asanib ta sihen ham. Ni ninad ezaq emaq? ham. Ya imam gog yagan ya ayuwun a hi uluw bugdaiq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ari bab mataw gigo amebta inaq teq Juda gigo hurmey na in Yesus wazim warigib am tuwaziy. ");
INSERT INTO mlp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Am wazim danmeb in waqim ad Anaz ago hib tilehiy. Anaz in mat anan Kayafas haqayta na alen. Teq ulig nab Kayafas in tamaz mat danmebta iyim osta. ");
INSERT INTO mlp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mat naqmo kwaziqmo Juda mataw gibilenim bilam, Mat amulikmo on mataw bunmo gimen moqdaqta na in dimunmo hamta amatin. ");
INSERT INTO mlp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sa Saimon Pita ayow disaipel araq inaq in Yesus muzim inaq tamaz mat danmebta na ago bitab tilehiy. Lehan mat ayahta na in disaipel araq na ago tuhuritta iyan disaipel naqmo Yesus muzim inaq bit na ago gel aduganib le tugwahtim. ");
INSERT INTO mlp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Sa Pita dan ezab asanibmo titur. Tursa tamaz mat danmebta na in disaipel araq na ago huritta iyan disaipel na bolim aw dan ez wamuzim turaqta na bulonad teq in Pita waqim inaq aduganib le ta gwahtim. ");
INSERT INTO mlp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Gwahtiqsa aw na Pita susumun ugim kazaq bulon, Luweq ni inaqmo mat ko ago disaipel iydaq ham. Haqan Pita bilam, Ya in ago disaipel a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Teq saw amuditqan iyim tim ginolsa kabibiy mataw asor hurmey nenaq faq ulaman tuqoyta azamorin kiskismo oysa in iterad nab turiy. Tursa Pita le mataw na nenaq faq iterad nab turmo. ");
INSERT INTO mlp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ari Yesus tamaz mat danmebta na ameb tursa mat na in Yesus ago disaipel ginan susumun ugim teq in Yesus ago suleq in bilaqyaqta na anan tisusumun ugmo. ");
INSERT INTO mlp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Susumun ugan Yesus amenin emim bilam, Ya on mataw bunmo ulalabmo gibilenyaiq ham. Sirisirimo Juda on mataw bo bit humab wolaytab teq Tempel ago gel aduganib humab woleq ossa ya suleq negyaiq ham. Ya gamuk araq ulilemimmo a hi bilaqyaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nagaqgo ni susumun yagaq? ham. Ya mataw suleq negta naqmo ni susumun neg ham. In yaqgo gamuk hurit kemiyta ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","In gamuk nazaq bilaqanmo hurmey araq nab turta na era Yesus amanmanan wolimmo bulon, Nagaqgo ni nazaq gamuk atoranmo bilaqad ni tamaz mat danmebta ka ago gamuk amenin emaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Haqan Yesus bilam, Edowa ya nan meqinta bilay? ham. Ni muran kawa mataw ka gimeb bilaqsa ya huritiq ham. Haiq iyid ta nagaqgo ya gamuk helta bilaqsa ni ya inolaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anmo Anaz in Yesus aben aqamun inaqmo eman tamaz mat danmebta Kayafas ago hib tilah. ");
INSERT INTO mlp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sa Saimon Pita mataw na nenaq faq iterad tursa in susumun ugim buloniy, Luweq ni mat na ago disaipel araq iydaqmo haqiy. Haqan in bilam, Ya in ago disaipel a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","An tamaz mat danmebta ago kabibiy mat araq in uzaq nab Pita in ago asenlul araq adeksan urotan in ahol wamta iyan in bilam, Ninmo daqag uzaq aduganib in inaq ossa ya nibiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Haqan Pita a ta bilam, Na ya a haiq ham. Haqanmo kurek tigayon. ");
INSERT INTO mlp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ari tarommo diq Juda mataw aseseqta na in Yesus wazim Kayafas ago bit hulosim in waqim ad Pailat ago hib tilehiy. Lehim in gavman amebta na ago bit aduganib le a hi gwahtiqiy. In ginad emiy, Luweq i God ameb gihol anumlan inaq iyid i Pasova akaruwun a hi neqam haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Haqad in asanib Pailat amen emim tursa Pailat gigerab bolim tisusumun nag, Mat na ezaq tonan ne amalib nan emnan a boliy? ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Haqan mataw na amenin emim bilaqiy, Mat ka daq meqinta a hi emid i ningo hib ad a hi bol nag haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Haqan Pailat gibilan, Ne mat na waqeq a leheq negmo gigo maror amalib ago daq ulum kemeq wastitayiy ham. Haqan Juda mataw na bilaqiy, Ne Rom gunun ayahta eman igmo ginadib mat araq wol emid moqgo azawayin haiqgam haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","In nazaq bilaqad kwaziqmo Yesus in naga daqin amalib moqdaqta anan bilamta na in tuwol net bugiy. ");
INSERT INTO mlp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ari mataw na nazaq bilaqan Pailat ahol buliyim le ago bit ayahta na aduganib ta gwahtim. Gwahtiqim in Yesus lilewunan bolan tisusumun ug, Ni Juda on mataw gigo king e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Haqan Yesus bilam, Ninmo ninad emad gamuk na bilaqaq o haiq mat araq nibilenan ni nazaq ya inan bilaqaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Haqan Pailat amenin emim bilam, Ya Juda mat a haiq ham. Ninmo ningo walmataw teq ninmo ningo mataw tamaz emayta gigo aseseqta naqmo in ni niwazim yaqgo hib a boliy ham. Ni daq ezaq diqta am? ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Haqan Yesus bilam, Yaqgo maror in og kabta a haiq ham. Ari yaqgo maror og kabta iyid teq yaqgo kabibiy mataw eraqeq ya ibabun nenaq an wolsa mat araq ya iwaqeq bab gibenab a hi iqem nag ham. Ta teq yaqgo maror in og kabta a haiq iyan yaqgo mataw nazaq a hi emay ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Haqan Pailat bulon, Ni bilaqaq, Yaqgo maror in og kabta a haiq haqsa ya inad emaiq, Ni king araqagya haqaiq ham. Haqan Yesus bilam, Ni ya inan bilaqaq, Ni king araq haqaq ham. Teq ya kawa ni tinibilen kemaiq ham. Ya gamuk helta bilaqaiqta naqmo in yaqgo kabiy ham. Ya inen iqeman ya kabiy naqmo emgo og kab gwahtiyta ham. Gwahtiqim ya gamuk helta bilaqsa mataw gamuk helta muzinayta na bunmo in ya iqez huritayta ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","An Pailat susumun ugim bilam, Naga gamukin in gamuk helta? ham. Pailat nazaq bilaqim teq in asanib Juda gigerab le a ta gwahtim. Gwahtiqim in kazaq gibilan, Ya mat ko ago afaqan araq nagunim ahol a hi way ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Teq ne gigo daq ne ulig bunmo Pasova akamnib mat araq irquran osaqta atowun emim ibilenan ya hasan gwahtiqaqta ham. Nazaq iyan ne ginad ya Juda gigo king ko aqamun hasid ne gigo hib lehdaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Haqan mataw na dedibmo bilaqiy, Nawa na haiq haqiy. Ni Barabas-mo hulosid bol igan haqiy. Mat anan Barabas haqayta na in gunun othasad mataw haresmo ginol titayad gigo es nagah giwaqyaqta amatin. ");
INSERT INTO mlp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ari teq Pailat in Yesus waqim ago bab mataw gibenab eman in tuwoltitayiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Woltitayim teq in am asasuqin inaqta waqim tal tonim king ago balaw nogta afaqinib tiqemiy. Emim teq in tubusan araq kakaqta waqim aholib emiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Emim in agerab loqeq bulon yaqay, Ni Juda gigo king-mo diqta haq yaqay. I nibin wazan ulilibmo gwalehaq haq yaqay. Haqadmo in amanmanib tuwol yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sa teq Pailat bit asanib gwahtiqim Juda mataw na a ta gibilan, Ne huritiy ham. Ya mat na ago daq meqinta araq ahol a hi way ham. Nazaq iyan ya waqeq ad asanib tubolnan ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Haqanmo Yesus afaqinib am asasuqin inaqta na teq tubusan kakaqta na aholib ussa in asanib mataw biyahta na gimeb bo tugwahtim. Gwahtiqan Pailat gibilan, Mat ka ahol waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Haqan mataw tamaz emayta gigo aseseqta na giyogniz hurmey na nenaq in Yesus ahol waqad dedibmo bilaqiy, Mat na ayib dom woliy haqiy. Ayib dom woliy haqiy. Haqan Pailat gibilan, Negmo waqeq a le ayib dom woliy ham. Ya in ago daq meqinta araq ahol a hi way ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Haqan Juda mataw aseseqta na amenin emim bilaqiy, I gigo maror aduganib gunun araq ayahta usaq haqiy. Sa mat na i gigo gunun na itiyonim bilam, Ya God atatin ham haqiy. In nazaq haqan i gigo gunun na bilam, In moqan ham haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Haqan Pailat gamuk na huritim in rab naqmo hiqiyyaq. ");
INSERT INTO mlp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ad in Yesus waqim inaq ago bit aduganib a ta gwahtiqim in susumun ugim bilam, Ni edob bolta? ham. Teq haiq. Yesus gamuk amenin araq a hi bilam. ");
INSERT INTO mlp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Anmo Pailat bulonim bilam, Ni yaqgo gamuk amenin a hi emdaq e? ham. Ya niqamun hasid ni samanmo gwahtiqgo azawayin ya iholib usaq ham. Teq ya ni ayib dom wolgo azawayin ya iholib usaqmo ham. Na ni ninad a hi emaq e? ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Haqan Yesus bilam, Mat ulilib osaqta naqmo in zaway na nigta ham. In zaway na a hi nigid ni daq araq ya iholib emgo nibin hiqiy nag ham. Nazaq iyan mat ya iwaqim ni nibenab amta na in ni niquriyamim in daq meqin diqta am ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yesus nazaq bilaqan nab Pailat in Yesus hulosid lehgo adanteqin tinagunyaq. Ta teq Juda mataw na lileyim bilaqiy, Mat na bilaqaq, Yaqmo king araq haqad in Sisa ago babmo diq iyim luwaq haqiy. Ni hasid lehid teq ni Sisa ayow a hi iydaq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Haqan Pailat gamuk na huritim in Yesus waqim ad asanib a ta gwahtim. Gwahtiqim in ago ban in mataw gigo daq gilum kemad osaqta nab in tuqos wom. Ban na in bit ago veranda araq anan Gig Rireniy haqaytab usta. Hibru nanib in veranda na anan Gabata haqayta. ");
INSERT INTO mlp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Teq kam na in Pasova ayon nagah wastitayayta akaman. Ari kam nab zeq ayahtab 12 kilok nazaq Pailat ago ban nab tuqos woqim osad in Juda mataw na gibilan, Ahol waqiy ham. Ne gigo king kawa turaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Haqan Juda mataw na lileyim bilaqiy, Wol emid moqan haqiy. Wol emid moqan. Ayib dom wolid in moqan haqiy. Haqsa Pailat tisusumun nag, Ya ne gigo king ka ayib dom woldaiq e? ham. Haqan mataw tamaz emayta gigo aseseqta na bilaqiy, Sisa amomo in i gigo king haqiy. I gigo king araq haiq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","In nazaq haqan teq Pailat in giqez muzinim in Yesus waqim ayib dom wolgo bab mataw gibenab tiqam. Eman in Yesus waqim ad tilehiy. Ari in Yesus waqim ad tilehiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Lehsa Yesus inmo ago ay na sorim ad tilehyaq. Lehad in uliq ayahta na hulosim garah akululqan araq anan Gifaqin Agolgolan haqayta nabmo in tugwalehiy. Hibru nanib garah akululqan na anan Golgota haqayta. ");
INSERT INTO mlp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","In garah nab tugwalehim saw nab teq in Yesus ayib dom tuwoliy. Wolad in mataw gigermo Yesus inaq ayib dom giwoliymo. Araq Yesus aqabun ban tursa araq anasaran ban turyaq. Sa Yesus in gilikmanib liqabmo turyaq. ");
INSERT INTO mlp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Dom tuwolan teq Pailat mataw gibilenan in Yesus ayib dom woliyta na ananin mar tonim afaqinib tuqotheniy. Gamuk na in kazaq mar toniy. ");
INSERT INTO mlp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Teq saw Yesus ayib dom woliyta na in Jerusalem agerab usaqta. Teq in gamuk mar tonim ay afaqinib emiyta na in Hibru gigo nanib teq Rom gigo nanib teq Grik gigo nanib mar toniyta. Nazaq iyan Juda on mataw kabemmo leh bolad luwad in gamuk na ahol tuwaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sa teq Juda gigo mataw tamaz emayta gigo aseseqta na lehim Pailat bulonim bilaqiy, Ni gamuk “Juda gigo king” nazaq ni a hi mar ton nagta haqiy. “Mat ka bilam, ‘Ya Juda gigo king hamta’” nazaq ni mar ton nagta haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Haqan Pailat bilam, Nab iyan ham. Ya gamuk tumar tonta na in dimunmo ham. Nazaq usan ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ari mataw bab emayta na in Yesus ayib dom tuwolim teq in ago tubusan giwaqim huseran humab aweweq nazaqmo iy. Iyan in amulik-mulikmo giholyon humab amulikmo waq yaqay. Ad in Yesus ago aholsihen araq waqiymo. Tubusan na in laplap urotim a hi initiyta. Na in ahol amulikmoqmo atutan haiqta. ");
INSERT INTO mlp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nazaq iyan bab mataw na an bulonim bilaqiy, I tubusan ka hi hiksirequq haqiy. I gig amikmikta hunegad mat nog ameb iyeq in tuwaqdaq haqiy. In nazaq bilaqim in gamuk araq God ago marib usaqta na tuwol net bugiy. Gamuk na bilam, In yaqgo tubusan giwaqim an huserim giholyon waqiy ham. Ad in gig amikmikta hunegim yaqgo iholsihen waqiymo ham. Gamuk nazaq usta iyan in daq nazaqmo tiqemiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ari Yesus anen diq teq in anen amikta teq mat anan Klopas haqay na awe anan Mariya haqayta na teq Mariya araq uliq Magdala-ibta na in bunmo ay Yesus dom wolan turaqta na asenab turiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tursa Yesus anen teq in ago disaipel in anan anad bilaqaqta na in giger ay agerab diq tursa Yesus ame wo tigibiy. Gibiyadmo in anen bulonim bilam, Kanen ham ni nitatin nawa turaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Haqad in ago disaipel na bulonim bilam, Ni ninen nawa ham. Haqan kam nab disaipel na in Yesus anen waqim inmo anen nog iyan in wamuzad inaq tuqosyaq. ");
INSERT INTO mlp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Daq na tihiqiyan Yesus anad tiqam, Yaqgo kabiy bunmo tihiqiy ham. Haqad in gamuk araq God ago marib usaqta na tuwol net bugnan haqad in bilam, Ya yuwnan moqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Teq deg araq wain ayun agon iyta ate gwalim usta nab os. Ossa Yesus bilam, “Ya yuwnan moqaiq” haqanmo mataw nab turiyta na in ay anan hisop haqayta aben araq waqim amotnib tubusandek am wazim wain ayun na ulum turim Yesus ateb tiqemiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Eman Yesus sisowim hulosadmo in bilam, Kabiy tihiqiy ham. Haqadmo in afaqin runan woqanmo in ahol awitan hulosanmo tilah. ");
INSERT INTO mlp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ari kam mataw Yesus ayib dom woliyta na in Juda gigo lotu ayon nagah wastitaygo akaman. Kam na hiqiyid babeq Juda gigo lotu akaman ayahta na tugwahtiqdaqta. Nazaq iyan Juda mataw aseseqta na in mataw moqiyta gisan hulosid lotu akaman ayahta nab ayib usgo gituw hiqiyiy. Nazaq iyan in le Pailat tubuloniy, Ningo mataw giqemid leheq mataw ayib usayta na gisen wolbiyayid in hidmo moqiy haqiy. Moqid teq in gisan ayib walemiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Haqan mataw bab emayta na lehim in Yesus agerab mataw giger dom wolan turiyta na gisen tuwolbiyayiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Gisen wolbiyayiyim teq in Yesus ago hib loqiy. Loqim Yesus tekomo tumoqim ussa in ahol waqiy. Nazaq iyan in asen a hi wolbiyayiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ta teq bab mataw na gigo araq in ago em waqim Yesus azawarnib tuqulum. Ulumanmo anedan yuw inaqmo gwahtiqad woqyaq. ");
INSERT INTO mlp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ari mat wagam ka mar tonta na in ame anonab daq na ahol wamta. Ahol waqim ne huriteq Yesus anan helmo haq daqay haqad in gamuk ka mar ton. Mat na ago gamuk ka in hel diqtaqmo. Ad inmo anad emaq, Ya gamuk mar tonta ka in helmo diq haqaq. ");
INSERT INTO mlp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ari bab mat na daq nazaq emim in God ago marib gamuk araq usaqta na tuwol net bug. Gamuk na bilam, In aditin araq a hi wolbiyay daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ad gamuk ta araq God ago marib usaqta na in kazaq bilam, In mat ulumiyta na ahol tuwaq daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ari daq na bunmo tihiqiyan teq Josep uliq Arimatea-ibta na lehim Pailat bulonim bilam, Ya Yesus asan waqeq a le yay tonnan ham. Mat na in Yesus ago disaipel araqtamo. Teq in Juda gigo rabad in ahol ulilemyaqta. In Pailat nazaq bulonan Pailat bilam, Dimunmo ham. Haqan Josep le Yesus asan ayib tuwalam. ");
INSERT INTO mlp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Samo Nikodemus mat kwaziqmo taromab Yesus ago hib lahta na in bolmo. Bolad in masil ahuran dimunta giger mir teq alow inaq buliyiyta na in waqim ad bol. Masil na ago afaqan in 30 kilo nazaqta. ");
INSERT INTO mlp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ari giger na Juda gigo daq mat moqan yay tonayta na adan muzinim in Yesus asan waqim masil ahuran dimunta na asanib hunegim teq in tubusanib net muzim a lehiy. ");
INSERT INTO mlp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","In kabiy na eman tihiqiyan ari saw Yesus ayib dom woliyta nab uzaq araq dimunta usta. Teq hodhod araq muturta aduganib mat araq momta asan eman a hi usta in uzaq nab usmo. ");
INSERT INTO mlp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nazaq iyan Pasova ahumabun ayon nagah wastitayayta akaman na tihiqiynan tonsa in lotu akaman ago gunun awaz meqinta na anadin emad in hodhod sinsin usta nabmo Yesus asan eman tuqus. ");
INSERT INTO mlp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ari Sande tarom naqmo saw a hi hastitay bugsa Mariya uliq Magdala-ibta hodhodab tilah. Lehim gig ayahta hodhod aqez ituqim usta na ulum buliyan lehan hodhod aqez hasim ussa in ahol tuwam. ");
INSERT INTO mlp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ahol waqad in sibim le Saimon Pita teq disaipel araq Yesus in anan anad diq bilaqaqta na gibilenim bilam, Iyahta nabag hodhodab tuwaqiy ham. Waqim in a le edob emiyta na i a hi hurit ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Haqan Pita ayow disaipel araq na inaq eraqim uliq hulosad in hodhodab tilehiy. ");
INSERT INTO mlp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","In sibim lehad teq disaipel araq na in Pita uriyamim sibtitayimmo lehim in ameb hodhodab tugwahtim. ");
INSERT INTO mlp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Gwahtiqim asanib turad in kuh tonim wiliyanim ame hodhod aduganib loqim tubusanmo ussa in ahol wam. Teq in hodhod aduganib lo a hi gwahtim. ");
INSERT INTO mlp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Samo Saimon Pita abeb bolimmo in hodhod aduganib le tugwahtim. Gwahtiqim in tubusan samanmo ussa ahol tuwam. ");
INSERT INTO mlp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ahol waqad tubusan amalib Yesus afaqin irquriyta na anononmo ayim aholbin eman ossa in ahol waq ton. ");
INSERT INTO mlp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sa disaipel hodhodab iturim le gwahtimta na inaqmo hodhod aduganib le gwahtiqim in nagah nagan ahol tuwammo. Ahol waqad nabmo in helmo Yesus hodhodab tiqeram ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Disaipel giger na in Yesus moqeq teq ta eraqdaqta na ago agamukan God ago marib ahol waq yaqayta teq in gamuk na alulin diq ginad a hi em has yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Admo in muleqim in gigo uliqab ta lehiy. ");
INSERT INTO mlp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ari Mariya hodhod aqezab asan ban turad in tigaqyaq. Gaqadmo in wiliyanim hodhod aduganib ame tilom. ");
INSERT INTO mlp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Loqimmo Yesus moqan asan eman usta nab angelo giger gigo tubusan husta inaqta nab ossa in tigibiy. Araq Yesus afaqin usta asawnib ossa araq Yesus asen usta asawnib os. ");
INSERT INTO mlp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Osad in giger Mariya kazaq buloniy, Aw, ni nagaqgo gaqaq? haqiy. Haqan in bilam, Yaqgo Iyahta nabag tuwaqiy ham. Waqim in a le edob emiyta na ya a hi hurit ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mariya nazaq bilaqim in ahol buliyimmo Yesus nab tursa ahol tuwam. Ta teq Yesus-mo turaq nazaq in anad a hi am. ");
INSERT INTO mlp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Samo Yesus susumun ugim bilam, Neng, ni nagaqgo gaqaq? ham. Ni nog nagunaq? ham. Haqan Mariya anad am. Uzaq ka anamren daqag ham. Haqad in bulon, Mat ayah ham ni mat momta na asan waqeq a lehsun iyid teq ni edob amta na ibilenid ya le waqnan ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","An Yesus in Mariya anan biyim bulon, Mariya ham. Haqanmo Mariya ahol buliyim in Hibru nanib bilam, Rabonay ham. Gamuk ‘rabonay’ na alulin ‘tisa’ haqayta. ");
INSERT INTO mlp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Haqanmo Yesus bulon, Ni ya hi iwaz ham. Ya ulilib imam ago hib a hi lehaiq ham. Teq ni ya imaqbaban gigo hib leheq kazaq gibilen ham. Yesus inmo amam teq ne gimam inaqmo ago hib tilehaq haqad ni gibilen ham. In ago God teq ne gigo God inaqmo ago hib lehaq haqad ni gibilen ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","An Mariya uliq Magdala-ibta na lehim disaipel gibilenim bilam, Ya Iyahta ahol tuway ham. Haqad Yesus gamuk bulonta na in tigibilen bug. ");
INSERT INTO mlp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ari Sande imisor diq disaipel in Juda mataw ginan rabad bit aduganib gihol adanin otim tuqosiy. Ossa Yesus bo in gilikmanib turad gibilan, Ne gigem kute neman ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","In nazaq bilaqim teq in ahol aben teq azawaran tigiqisihun. Giqisihunsa in Iyahta ahol waqad ginad ayahmo dimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ginad dimniysa Yesus a ta gibilan, Ne gigem kute neman ham. Ya imam iqeman bolta nazaqmo ya ne giqemid ne tileh daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","In nazaq bilaqim teq in ahol aqurin ulam hasan in gigo hib lehsa in gibilan, Ne God ago Bugaw Dimunta waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ne mataw gibileneq bilaq daqay, God ne gigo daq meqinta tigiwalam haqsa in gigo daq meqinta giholib hiqiysa tuqos daqay ham. Ari ne gibileneq bilaq daqay, God ne gigo daq meqinta a hi walemaq haqid in gigo daq meqinta na giholib soqoteq ussa in tuqos daqay ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ari Yesus disaipel gigerab gwahtimta nab disaipel araq anan Tomas haqayta na in nenaq a hi os. Tomas anan araq Didimus haqayta. ");
INSERT INTO mlp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Abeb Tomas bolan disaipel buloniy, I Iyahta ahol tuwaw haqiy. Haqan Tomas bilam, Ya in abenab dom woliyta na asawan ahol waqad ya iben le dom woliyta na abatlan teq emub ulumiyta na abatlan waz waqeq teq ya helmo tihaqdaiq ham. Muran ya helmo a hi haqdaiq ham. Haiqmo diq ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ari Sande ta araq nab Yesus ago disaipel bit nab a humab ta woliy. Humab wolim ossa Tomas in nenaq tuqos. Mataw na gihol adanin bunmo otim bit aduganib ossa Yesus in gilikmanib bo a ta gwahtim. Gwahtiqim turad in gibilan, Ne gigem kute neman ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Haqadmo in Tomas tubulon, Ni niben akurgan araq ya ibenab dom woliyta asawnib kab emeq teq ni ya iben ahol waq kem ham. Ahol waqad ni niben emid bo ya izawaran ka waz waqanmo ham. Ad ni ninad haresmo emaqta na o tob iysa ni ya inan helmo haq ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Haqan Tomas amenin emim bulon, Ni yaqgo Iyahta ham. Ni yaqgo God ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Haqan Yesus bulon, Ni nime anonab ya ibiyim teq ni ya inan helmo tiham ham. Ari mataw ya a hi ibiyadmo inan helmo haqayta na in tidimniyim osay ham. ");
INSERT INTO mlp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ari Yesus daq azawayin inaqta kabemmo disaipel gimeb giqamta. Teq ya bunmo wagam kab a hi mar ton. ");
INSERT INTO mlp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ya Yesus awagamun asormo kawa ya tumar tonta ka ne ahol waqad ne Yesus anan Krais haqad teq ne in anan God atatin tihaq daqaymo haqad ya gamuk ka mar tonta. Ne Yesus abin nazaq diqta anan helmo haqeq teq ne kayeqmo kuluwa-kuluwmo tuqos daqay. ");
INSERT INTO mlp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ari abeb Yesus disaipel gimeb a ta gwahtim, yuw akurorqanta anan Taiberiyas haqayta na ago lan aqezab. Teq in ago mataw gimeb gwahtimta na awagamun kazaq. ");
INSERT INTO mlp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Kam araqab Yesus ago disaipel asor humab wolim osiy. Mataw na ginan kazaq: Saimon Pita teq Tomas anan araq Didimus haqayta na teq Nataniyel uliq Kana saw Galiliy-ibta na teq Sebediy atatniz giger na teq disaipel ta asor gigermo in bunmo araqibmo osiy. ");
INSERT INTO mlp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ossa Saimon Pita gibilan, Ya le dob hunegeq nabiq waqnan ham. Haqan in ayogniz na buloniy, I ninaqmo leham haqiy. Haqad in le muy araqab gwalim tilehiy. Lehim tarom nab in nabiq araq diq a hi waqiy. ");
INSERT INTO mlp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","An tarommo saw tihastitaysa Yesus bolim lan ezab titur. Tursa disaipel ahol a hi waq hasiy. ");
INSERT INTO mlp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sa Yesus gibilan, Onmin ham ne nabiq araqag waqiy ye? ham. Haqan in bilaqiy, Haiq diq haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Haqan Yesus gibilan, Ne dob hunegid muy aqabun ban woqid teq ne nabiq asor tigiwaq daqay ham. Haqan in dob hunegan woqan nabiq kabemmo diq dobub tuwoqiy. Woqan in dob hureq yo hiqiy yaqay, nabiq kuluw diqmo iyan. ");
INSERT INTO mlp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sa disaipel araq Yesus in anan anad bilaqaqta na in Pita bulon, Ko Iyahtaqmo ham. Haqan Saimon Pita in “Ko Iyahta” haqan huritim in kabiy emnan haqad ago aholsihen hasim eman usta na waqim aholib ta emim in yuwmeb sortukim woqim Yesus ago hib amim tilah. ");
INSERT INTO mlp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lehsa disaipel ta asor na muyib osad dob anabiqnaq wazim hureqim ad lan ezab tuboliy. Na ezaqgo in lan ezab sinsinmo 90 mita nazaq osiy. ");
INSERT INTO mlp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Disaipel na bolim lan ezab tuwoqimmo faq araq ulaman tuqoyta azamorin kiskismo oysa in ahol waqiy. Teq faq azamornib nabiq oyad ussa bret faq agerab ossa in ahol waqiymo. ");
INSERT INTO mlp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Samo Yesus gibilan, Ne nabiq muran waqiyta na asor a boliy ham. ");
INSERT INTO mlp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Haqan Saimon Pita le muyib gwalim dob anabiqnaq na kamisib ussa in wazim hureqan yuw adekib tigal. Nabiq aseseqta kabemmo diq 153 nazaqmo dobub woqim usta. Teq dob a hi tartay. ");
INSERT INTO mlp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","An Yesus gibilan, Ne boleq didaq neqiy ham. Haqsa disaipel araq diq in “Ni nog?” nazaq a hi susumun ug yaqay. Na ezaqgo in bunmo ginad tiqemiy, Ka Iyahtaqmo haqiy. ");
INSERT INTO mlp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","An Yesus eraqim bolim bret waqim tinag. Negad teq in nabiq waqim nazaqmo ton. ");
INSERT INTO mlp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ari ka Yesus ame ezeqmanta in disaipel gimeb gwahtimta, in hodhodab ta eraqim teq. ");
INSERT INTO mlp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ari disaipel didaq tineqan abeb Yesus in Saimon Pita tubulon, Jon atatin Saimon ham nabag ni mataw kagan giquriyamim ni ya inan ninad diq bilaqaq e? ham. Haqan Pita bilam, Eqe Iyahta ham. Ya ninan inad diq bilaqaqta na ni tuhurit ham. Haqan Yesus bulon, Ni yaqgo sipsip amidgotniz didaq neg ham. ");
INSERT INTO mlp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Haqad Yesus ame gigerta a ta bulon, Jon atatin Saimon ham ni ya inan ninad diq bilaqaq e? ham. Haqan Pita bulon, Eqe Iyahta ham. Ya ninan inad bilaqaqta na ni tuhurit ham. Haqan Yesus bulon, Ni yaqgo sipsip gibiymuz ham. ");
INSERT INTO mlp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Teq Yesus ame ezeqmanta a Pita ta bulonim bilam, Jon atatin Saimon ham ni ya inan ninad bilaqaq e? ham. Haqan Pita nab afaqan tiqiy. Na ezaqgo Yesus ame ezeqmanmo susumun ugim bilam, Ni ya inan ninad bilaqaq e? hamta na ago iyan. Haqan Pita bulon, Iyahta ham ni nagah bunmo ago tuhuritta ham. Ya ninan inad bilaqaqta na ni tuhuritmo ham. Haqan Yesus bulon, Ni yaqgo sipsip didaq neg ham. ");
INSERT INTO mlp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ya helmo nibilenaiq ham. Ni minmin osad ni nihol wastitayim nihulib am hurorim ni edob lehnan ninad usta nab ni lehmo tilehyaqta ham. Ari abeb ni adinowan tiqiyeq teq ni niben wazid eraqsa mat araq nihulib am huroreq in niwaqeq saw ninad a hi usaqtab niqad tilehdaq ham. ");
INSERT INTO mlp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na Pita daq ezaqta amalib moqad in God abin emid ayah iydaqta na ago in Pita nazaq bulonta. Haqad in bulon, Ni ya imuzeq bol ham. ");
INSERT INTO mlp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ari Pita ahol buliyim disaipel Yesus in anan anad bilaqaqta na gimuzim nenaq lehsa in ahol tuwam. Mat naqmo kwaziqmo Yesus ago disaipel nenaq didaq neqad in banab ahol wol emim Yesus anognib us nog iyad in afaqin Yesus abanib emim bulon, Iyahta ham nog niwaqeq bab gibenab niqemdaq? hamta na amatin. ");
INSERT INTO mlp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita in disaipel na ahol waqad teq in Yesus bulon, Iyahta ham mat ko teq ezaq iydaq? ham. ");
INSERT INTO mlp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Haqan Yesus bulonim bilam, Ya inad mat na ossa ya muleqeq ta boldaiq haqid na in ningo nagah a haiq ham. Ni ya imuzeq bol ham. ");
INSERT INTO mlp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Teq Yesus nazaq haqan abeb gamuk na Yesus ago on mataw gigo hib le ayahmo diq iyta. Iyan mataw na ginad em yaqay, Disaipel na a hi moqdaqta haq yaqay. Ta teq Yesus bilam, Mat na a hi moqdaq nazaq in a hi bilam. Haiqgam. In bilam, Ya inad mat na ossa ya muleqeq ta boldaiq haqid na in ningo nagah a haiq haqad in Pita bulonta. ");
INSERT INTO mlp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ari disaipel naqmo in daq nagan bunmo amebmo ahol waqim in awagamun mar tonta. An i mat na ago tuhurit. In a hi katiyad gamuk heltaqmo mar tonta. ");
INSERT INTO mlp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ta teq Yesus kabiy daq kabemmo diq giqeman mat na asormo mar ton. In Yesus daq amta na bunmo awagamun mar ton bugta iyid ya inad emaiq, Amarin gwahtiqeq osdaqta na abanan og kab hiqiy nagta haqaiq. ");
INSERT INTO mlp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Mat ayah Tiyofilus, ya wagam danmeb mar tonta nab Yesus in ago kabiy alulin tiqemim ago kabiy daq emad teq in ago suleq on mataw gibilenad luwsa le God in waqim ad Heven-ib gwalahta na awagamun bunmo ya mar ton nigta. Teq in a hi gwalehadmo in ago Aposel inmo gilumim giwamta na gigo hib gwahtiqim in God ago Bugaw Dimunta ago zaway amalib mataw na kabiy negad gamuk awaz meqinta gibilan. ");
INSERT INTO mlp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesus santitiy sorim moqim kayeq ta iyim teq in Aposel gigo hib gwahtimta. Gwahtiqim in gimen daq azawayin inaqta kabemmo giqeman gwahtiqsa Aposel ginad tiqemiy, Helmo Yesus hodhodab tiqeramta haqiy. Sa kam 40 nazaq aduganib Yesus tuteqmo mataw na gimeb gwahtiqad in God ago maror agamukan gibilenyaq. ");
INSERT INTO mlp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ad in nenaq osad in atoranmo kazaq gibilan, Ne uliq Jerusalem huloseq hi lehiy ham. Ne uliq kab osad nagah ya imam negnan hel diqmo bilamta na ne amen emad osiy ham. Kwaziqmo ya nagah na anan ne tigibilenta ham. ");
INSERT INTO mlp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ya bilay, Jon yuwibmo on mataw huz negyaqta hay ham. Ari babeq misireqag teq God in ago Bugaw Dimunta ne tinegdaq hay ham. ");
INSERT INTO mlp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","An abeb Aposel bo Yesus ago hib humab wolim tisusumun ugiy, Iyahta haqiy, Luweq muran kam kab ni Isrel gigo maror woqim usaqta na waz ta eraqid in gigo king inaq a ta iy daqay-ya? haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Haqan Yesus gibilan, Ya imam inmo ago zawayib daq bunmo gwahtiqdaqta na akamun tibilaqan usaqta ham. Nagah na ne gigo a haiqta iyan ne kam na ago a hi hurit daqay ham. ");
INSERT INTO mlp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ta teq God ago Bugaw Dimunta ne giholib ayahmo tuboldaq ham. Bolid teq ne zaway waqeq nagah ne gimeb ahol waqiyta na teq ya iwagamun bunmo ne uliq Jerusalem-ub tibilaq daqay ham. Bilaqad teq ne leheq saw Judiya-ib teq saw Samariya-ib uliq bunmo luwad nab ne yaqgo gamuk na on mataw tigibilen daqaymo ham. Gibilenad teq ne saw giger na gihuloseq og saw bunmo lehad on mataw gibilensa in tuhurit daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesus gamuk na bilaqim tihiqiyan Aposel ahol waqad tursamo God Yesus waqim ad kaitab tugwalah. Gwalehsa onqas tiqim Yesus il tonan Aposel ahol a ta hi waqiy. ");
INSERT INTO mlp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ad in gime kaitab gwalehad tursamo mataw giger tubusan husta emiyta in gigerab gwahtiqim tituriy. ");
INSERT INTO mlp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Turad in bilaqiy, Galiliy-ib mataw haqiy nagaqgo ne turad kaitab gime gwalehaq? haqiy. Muran God in mat anan Yesus haqayta ka ne gibenab walemim in waqim ad Heven-ib tugwalah haqiy. Teq in Heven-ib gwalehsa ne ahol waqiyta nazaqmo in muleqeq ta gewoqdaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ari Aposel garah anan Oliv haqayta na hulosim in muleqim Jerusalem-ub wo tilehiy. Garah Oliv na in Jerusalem agerab sinsinmo usaqta, kilomita amulikmo nazaq. ");
INSERT INTO mlp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","In garah na hulosim le uliq Jerusalem-ub gwahtiqim bit in os yaqayta nab tilehiy. Lehim in bit na adugan ulilib osayta nab gwalehim tuqosiy. Mataw na ginan kazaq: Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomyu, Matyu, teq Alfiyus atatin Jems teq Saimon mat Rom nenaq bab emyaqta amatin na teq Jems ta araq atatin Judas. ");
INSERT INTO mlp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mataw na bunmo teq on asor Yesus muzeq inaq leh yaqayta na teq Yesus anen Mariya teq Yesus amagniz inaqmo bunmo in gigem amulikmo iyad tuteqmo in bit adugan nab humab woleq God inaq gamuk emad os yaqayta. ");
INSERT INTO mlp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ari kam araqab on mataw Yesus anan helmo haqad maqbab iyim osiyta 120 nazaq humab wolim ossa Pita in gilikmanib eraqim turad kazaq gibilan, ");
INSERT INTO mlp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ya iyogniz ham kwaziqmo God ago Bugaw Dimunta Devit aqezab gamuk araq eman gwahtiqsa in Judas-mo anan bilamta ham. An God ago gamuk bilamta nazaqmo Judas ago hib tugwahtim ham. Mat na a hi gwahtiqsa Bugaw Dimunta in anan tibilaqan usta ham. Ussa teq mat na gwahtiqim gamuk na muzinim in mataw dan giqisihunim giqad lehan in Yesus waziyta ham. ");
INSERT INTO mlp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Na ezaqgo in i giyow mat araq iyim in i inaq garabmo kabiy ka wamta ham. ");
INSERT INTO mlp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Teq Judas ago daq meqinta na anawun mani silva waqim a lehim in og araq tizay. Zayim in lehim og nab ban araq meqintab woqim agem muturan in agembekoq bunmo mutbalim gwahtim. ");
INSERT INTO mlp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","An abeb mataw Jerusalem-ub osiyta na bunmo in daq na ago huritim in gigo nanib in saw na anan Akeldama tihaqiy. Na in ‘og anednaqta’ haqad in og na anan nazaq biyiy.) ");
INSERT INTO mlp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ari Pita bilam, Gamuk araq Buk Song-ib mar tonan usaqta na kazaq bilam ham. In ago bit samanmo usan haqad in bilam ham. Ussa mat araq diq bit nab hi osan haqad in bilam ham. Teq buk nab gamuk araq kazaq bilammo ham. Mat ta araq in ago ban waqeq kabiy eman haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nazaq iyan muran i mat araq Judas ago ban waqdaqta na tinagunam ham. Nagunad i mat araq kazaqta waqam ham. Iyahta Yesus i gililewunim giwaqim ginaq leh bolad luwyaqta kam nab mat na in luw osta ham. ");
INSERT INTO mlp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Teq Yesus Jon ago hib lehan Jon huz ugsa mat na in ahol wamta ham. Ad Yesus ago kabiy alulin emsa in ahol wamtamo ham. Teq God i gibenab Yesus waqim ad gwalehsa in nab turtamo ham. Mat araq naqanta in daq nagan bunmo ahol wamta naqmo i ulum kemeq waquq ham. Id teq Yesus hodhodab eraqan in ameb ahol wamta na agamukan in i inaq garabmo tibilaqam ham. ");
INSERT INTO mlp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita nazaq bilaqan mataw nab osiyta na in mataw gigermo ginan tiqemiy. Araq na anan Josep haqayta. In anan giger Barsabas teq Jastus haqaytamo. Teq ta araq na anan Matiyas haqayta. ");
INSERT INTO mlp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","In mataw giger na ginan emim teq in kazaq God buloniy. Iyahta haqiy, ni mataw bunmo gigo gigem tuhuritta haqiy. Ni mataw giger ka gilikmanib mat doqag diq ni wamta na ni i giqisihun haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Giqisihunid teq mat na Judas ago ban waqeq in Aposel araq iyeq kabiy ka asor in tisordaqmo haqiy. Judas kabiy ka tuhulosim in moqim saw in osdaqta nab tilah haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Haqad in God inaq gamuk nazaq bilaqim tihiqiyan in gig amikmikta giwaqim mataw giger na ginan mar tonim teq hunegiy. Hunegan Matiyas-mo anan tugwahtim. Gwahtiqan in Matiyas waqim Aposel 11 na nenaq tigiwastoniy. ");
INSERT INTO mlp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ari Juda gigo lotu akaman ayahta anan Pentikos haqayta na tugwahtim. Gwahtiqan mataw Yesus anan helmo haqayta na bit araqab humab wolim tuqosiy. ");
INSERT INTO mlp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ossa nan saw haiqmo nagah araq ahulan bilaqne tim atoranmo sibaqta ahulan nog Heven-ib hitiqad bit in osiyta na tuwaleq ton bug. ");
INSERT INTO mlp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Samo nagah araq faq amileq nog in gimeb gwahtiqim in tartayad le on mataw amulik-mulikmo gigo hib us. ");
INSERT INTO mlp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ussa God ago Bugaw Dimunta mataw na giholib ayahmo bolan uliq amo amo gigo nan ginadib bolsa in tibilaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ari kam nab Juda on mataw God ayon lotu em yaqayta kuluwmo uliq saw bunmo hulosim bolim lotu akaman ayahta na ahol waqnan haqad uliq Jerusalem-ub tuqos yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Osad in nagah na ahulan iysa huritad in kabemmo bolim bit nab humab tuwoliy. Humab wolim tursa Yesus ago on mataw na in God ago gamuk bilaqsa mataw biyahta na in gimi gimo gigo nanibmo tuhurit yaqay. Huritad in ginadnad diq tiqem yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ad in gihol turuh nemsa ginadnad emad turad bilaqiy, Ka ezaq diq? haqiy. Mataw kawa gamuk emayta ka in bunmo saw Galiliy-ibtaqmo haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ta ezaq iyan in God ago gamuk bilaqsa i gimi gimo gigo uliq diq ago nanibmo gamuk tuhuritauq? haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","I mataw uliq amulikmo a hi bolta haqiy. I asor kantri Partiya-ibta teq kantri Midiya-ibta teq kantri Elam-ubta haqiy. Teq i asor saw Mesopotemiya-ibta teq saw Judiya-ibta haqiy. Teq i asor saw Kapadosiya-ibta teq saw Pontus-ibta teq saw Esiya-ibta haqiy. Teq i asor saw Frigiya-ibta teq saw Pamfiliya-ibta teq kantri Isip-ubta teq i asor saw Libiya-ib uliq Sairin agerab osauqta haqiy. Teq i asor uliq Rom-ubta haqiy. I asor Juda matawmo diqta teq asor in mataw en amo amo i Juda gigo maror ahaqenib iyim muzinayta haqiy. Teq i asor nud Krit-ibta teq kantri Arebiya-ibta haqiy. Mataw gamuk emayta ko in God kabiy awaz meqinta amta na anan bilaqsa i amulik-mulikmo gigo nanibmo tuhuritauq haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Haqad in bunmo gihol riten lamsa ginad kabemmo emad teq in an tubulon yaqay, Nagah ka alulin ezaq diq haq? yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Haqsa ta mataw na asor in hilhil emad bilaq yaqay, Mataw ko wain ayun muturta ayahmo uluwim in gihol agadan iyay daqag haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ari Pita in Aposel 11 na nenaq eraqim turad in dedibmo lileyim on mataw na kazaq gibilan, Ne Juda mataw teq ne mataw Jerusalem-ub bolim osayta na bunmo ham ne gidek emeq yaqgo gamuk huriteq teq ne daq kawa gwahtimta ka ago alulin ne ginad em hasiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ne ginad emay, “Mataw ka yuw atoranta uluwim gifaqin hulosiyta daqagya” haqay ham. Haiqgam ham. Mataw in 9 kilok tarommo kam kazaqtab yuw atoranta ayahmo uluwim gihol agadan a hi iyayta ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Teq daq kawa gwahtimta ka kwaziqmo God ago nantut Joel kam anan bilamta naqmo ham. In kazaq bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God bilam, Kam abebtanta na bo sinsin tiqiysa teq ya igo Bugaw Dimunta wazbalid on mataw bunmo gimalib tuwoqdaq haqad in bilam ham. Woqsa ne gigo onmin matmatta teq onqonta in yaqgo nantut tibilaq daqay haqad in bilam ham. Teq ya daq lul araq diqta ne gigo mataw minminta na tigiqisihundaiq haqad in bilam ham. Sa ne gigo mataw aseseqta sen qwayeq nagah amo amo ahol tuwaq daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kam nab ya igo Bugaw Dimunta wazbalid yaqgo kabibiy mataw bunmo onqonta teq matmatta inaqmo gimalib tuwoqdaq haqad in bilam ham. Woqsa yaqgo kabibiy on mataw na yaqgo nantut tibilaq daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Daq nawa teq gwahtiqdaqta nagan gitowun kazaq gwahtiqsa ne ahol tuwaq daqay haqad in bilam ham. Ya daq asor lul araq diqta kaitab ulilib kob emad teq og kab ya inad emsamo nagah amo amo tugwahtiqdaq haqad in bilam ham. Ned teq faq teq faq aqasin ayahmo gwahtiqdaqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Teq ya zeq emid in ahol buliyeq aromriqnaq iysa ya kalam buliyid in kakaqta iyeq ned nog tiqiydaq haqad in bilam ham. Iyahta ago kam ayahta abin inaqta na bo tugwahtiqnan tonsamo daq nagan bunmo tugwahtiqdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kam nab God in on mataw Iyahta ahaqenib iyim lilewunayta na bunmo gilumsiheq tigiwaqdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Haqad Pita bilam, Isrel-ib on mataw ham ne gamuk ka huritiy ham. Ya Yesus uliq Nasaret-ibta anan tigibilennan ham. God inmo Yesus eman bolta na ago in ne giqisihunnan haqad in Yesus zaway ugsa in ne gilikmanib daq azawayin inaqta amo amo giqeman gwahtiqsa in kabiy awaz meqinta kabemmo giqemyaq ham. Na ago ne tuhuritiyta ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God in mat naqmo ne gibenab eman ne mataw God ago maror asan ban osayta na gibe yahan in mat na ayib dom wolan tumom ham. Ne nazaq emim ne bilaqne negmo gibenab wol eman momta nog tiqiyiy ham. Kwaziqmo daq na bunmo a hi gwahtiqsa God anad emim adan tuwastitayan usta ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Teq in Yesus aholib moqgo santitiy meqinta wamta na walemad in Yesus wazan ta eram ham. Na ezaqgo moq in tuteqmo Yesus wazgo ago zaway biyab haiqta na ago iyan ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Teq kwaziqmo Devit in Yesus anan nazaq bilamtamo ham. In bilam, Iyahta tutimmo ya imeb ossa ya ahol waqaiqta haqad in bilam ham. In ya iben iqabun ban osad zaway yagsa ya iwaz meqniyad a hi tukdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nazaq iyan ya igem dimniysa Iyahta abin iluwaiqta haqad in bilam ham. In teq tiqidimun tondaq haqad ya og kab kayeqmo osad ya isan moqdaqta na ago ya inad a hi meqniyaqta haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Na ezaqgo ham ya moqid teq ni ya ihulosid ya mataw tumoqiyta gigo sawab kuluwa-kuluwmo a hi osdaiq haqad in bilam ham. Teq ni ningo mat tawon diqta na hulosid in asan hodhodab a hi lilihdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ni dante dimunta mataw muzim le os dimunta kuluwa-kuluwmo osaytab gwahtiqayta na ni ya tiqiqisihun haqad in bilam ham. Ad ni teq ya iwaqid ya ningo hib inad dimniysa ninaq tuqosdaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Haqad Pita bilam, Ya imaqbaban ham, ya i gises Devit anan kazaq ne gibilendaiq ham. In kwaziqmo tumomta ham. Moqan in tiyay toniyta ham. In ago hodhod na i gilikmanib usim bo muran kawa in us tutsa i ahol waqauqta ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Teq God gamuk awaz meqinta Devit bulonad in Devit anaynayin araq emid in ago ban waqeq king araq inmo nogta iyeq tuqosdaq haqad in bulonta ham. Haqan Devit in God ago nantut araq iyim iyan in gamuk na alulin anad tiqem has ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nazaq iyan in God ago gamuk na anadin emad in nagah abeb teq gwahtiqdaqta na ahol kemad in Krais teq moqeq ta eraqdaqta na ago in bilamta ham. In bilam, Krais moqid teq God hulosid mataw tumoqiyta gigo sawab a hi us tutdaq haqad in bilam ham. Teq in bilam, God in asan hodhodab hulosid a hi lilihdaq haqad in bilamtamo ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","An muran kawa ya ne tigibilen kemaiq ham. God in mat anan Yesus haqayta na wazan tiqeram haqaiq ham. I bunmo ahol tuwawta iyim i anan bilaqauqta ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesus hodhodab eraqan teq God in abin emid ayah iy bugnan haqad in Yesus eman inmo aben aqabun ban tuqos wom ham. Os woqim in Amam ago hib Bugaw Dimunta tuwam ham. Amam kwaziqmo ugnan hel diqmo bulonta nazaq ham. Waqim muran in God ago Bugaw Dimunta wazbalan on mataw kawa i osauqta ka gimalib woqan ne daq kaway ka ahol waqad teq ne gidekib gamuk ka tuhuritay ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Ne ginad em hasiy ham. Devit ulilib kaitab a hi gwalahta ham. Teq inmo bilam, Iyahta in yaqgo Iyahta kazaq bulon haqad in bilam ham. Ni ya iben iqabun ban kab ya imen emad ossa ya ningo bab giqemid nisen ahaqenib tiqiy bug daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nazaq iyan ne Isrel on mataw bun diqmo gamuk ka hurit kemeq ginad em hasiy ham. God in Yesus, mat ne ayib dom woliyta na eman in i bunmo gigo Iyahta teq i gigo Krais tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ari Pita nazaq gibilenan gamuk na mataw giqutil tuqulum. Uluman in Pita ayogniz nenaq kazaq susumun negiy, I gimaqbaban haqiy, teq i ezaq tonam? haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Haqan Pita gibilan, Ne bunmo ginad buliyeq ne gigo daq teq ginad meqinta na gileh ugeq teq ne Yesus Krais ananib yuw huziy ham. Id teq God in ne gigo daq meqinta na bunmo giwalemad anadin a ta hi emdaq ham. Ne nazaq tonsa teq God in ago Bugaw Dimunta samanmo naw nog tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Na ezaqgo ham God in ago Bugaw Dimunta mataw negnan hel diqmo bilamta na in ne teq ne gigo onmin teq on mataw God ago hib pesanmo osayta na bunmo inaqmo gimen gamuk na bilamta ham. I gigo Iyahta God in on mataw gililewunid agerab bol daqayta na bunmo in ago Bugaw Dimunta tinegdaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Haqad Pita gamuk naqanta kabemmo amalib atoranmo gibilenyaq. Ad in bilaqyaq, Ne God lilewunid in ne gilumsiheq ta giwaqan haqyaq. Giwaqid teq ne mataw meqmeqinta muran kam kab osayta na nenaq araqibmo a hi meqniy daqay haqyaq. ");
INSERT INTO mlp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","In nazaq bilaqan teq on mataw kabemmo diq 3,000 nazaq in Pita ago gamuk huritim anan helmo tihaqadmo yuw tuhuziy. Yuw huzim in le Yesus ago on mataw na nenaq an tuwastoniy. ");
INSERT INTO mlp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ari on mataw helmo haqiyta na in Yesus ago on mataw na nenaq an wastonim tuteqmo in Aposel gigo suleq huritad teq in an ulumsihad teq in humab woleq garab didaq neqad teq in God inaq gamuk tiqem yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sa God in Aposel gibenab daq azawayin inaqta amo amo kabemmo emsa on mataw bunmo ahol waqad teq in God rabunad abin tuwazin yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sa on mataw helmo haqayta na bunmo gigem amulikmo iyim os yaqay. Osad in ginad em yaqay, I gimi gimo gigo es nagah bunmo i wazauqta ka in i bunmo gigota haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Haqad in gigo og teq in gigo es nagah nagan mataw ta asor gigo hib zayeq amenin waqeq in gigo mataw nagah osgo siqim iyayta nagan gilumsihad tineg yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","In bunmo gigem amulikmo iyad kam bunmo in le Tempel-ib humab tuwol yaqay. Teq in gigo bit araq araqab humab woleq Yesus abinib bret orqayeq tineq yaqay. Neqad in an alowan tonad ginad dimniysa zib alowabmo tuqos yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Osad kam bunmo in God abin tiqiluw yaqay. Sa uliqab on mataw bunmo in Yesus ago on mataw na ginan gigem tidimniy yaqay. Teq kam bunmo Iyahta in on mataw ta asor muturta gililewunad tigiwaqyaq. Giwaqsa on mataw helmo haqayta na gigo dauh kabemmo diq tiqiy yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ari kam ta araqab 3 kilok imisor Juda mataw God inaq gamuk emayta akamnib nab Pita ayow Jon inaq Tempel-ib tilehiy. ");
INSERT INTO mlp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lehim in mataw mat araq asen meqinta sorim a bolsa tigibiyiy. Mat na anen agemab nazaqmo hitimta. Kam bunmo mataw mat na soreq a le Tempel agelin ago dan ez anan Awaq Dimun haqayta nab emid osyaqta. Ossa on mataw boleq gel na aduganib loqsa in mani nagah anan sunyaqta. ");
INSERT INTO mlp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ari Pita ayow Jon inaq le Tempel agelin aduganib lo gwahtiqnan haqsamo mat na mani anan tisun nag. ");
INSERT INTO mlp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sun negan Pita ayow Jon inaq gihol wasihim turad in mat na ahol waninunadmo Pita in tubulon, Ni nime kazaq boleq i giger gibiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","6","Haqan mat asen meqinta na anad am, Mataw ka nagah tiyagnan haqad in ahol buliyim giger na tigibiysa Pita bulon, Ya mani haiq ham. Teq nagah ya inaq naqmo ya tinignan ham. Yesus Krais Nasaret-ibta na abinib ya ni nibilenaiq ham. Ni eraqeq loq gel ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Haqad in mat na aben aqabnib wazim wazan tiqeram. Eraqim hid naqmo in asen aditin bunmo awaz timeqniy. ");
INSERT INTO mlp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Awaz meqniyan in ahol loyinadmo in dedibmo eraqim turad tiloq gelyaq. Samo Pita ayow Jon inaq Tempel agelin aduganib lo gwahtiqsa mat na in nenaq lehad in sor tiktukad teq in God abin wazan tiqeraqyaq. ");
INSERT INTO mlp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Sa on mataw bunmo in mat na loq gelad God abin wazan eraqsa ahol waqad ginad tiqemiy, Mat ko tutimmo Tempel agelin ago dan ez anan Awaq Dimun haqayta nab osad mani nagah anan sunyaqta naqmo amatin haqiy. Haqad in mat asen meqinta na tidimniyan ahol waqad in gihol riten lamsa ginadnad diq tiqem yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ari mat na Tempel ago veranda anan Solomon ago veranda haqayta nab in Pita ayow Jon inaq giwazim giqay netsa on mataw bunmo gihol turuh nemsa in gigerab sibim bolim humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Humab wolim tursa Pita gibiyad kazaq gibilan, Ne Isrel-ib mataw ham, nagaqgo ne nagah ka ago ginadnad emad ne i giger gibiy ninunay? ham. Ne towa ginad emay, I gigo zaway inaqta iyim i mat ka wastitay haqay-ya ham. Teq ne ginad emay, I giger God ago mataw dimun diqta iyim i mat ka wastitayan in tiloq gelaq haqay-ya ham. Na haiqgam ham. Ne ginad nazaq hi emiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","I gisesan Abraham, Aisak teq Jekob gigo God inmo daq kawa ne ahol tuwaqay ka amalib in ago kabibiy mat Yesus abin wazan tiqeraqaq ham. Mat ne waqim bab gibenab emiyta naqmo ham. Pailat in mat na hulosid lehgo bilamta teq haiq ham. Ne mat na gileh ugad bilaqiy, In i gigo a haiq haqad ne bilaqiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mat nawa na in God ago mat tawon diqta iyim in God anad muz bugta teq in ago daq bunmo titnon diqtamo ham. Ta teq ne in gileh ugad ne mat ta araq mataw ginol emaqta naqmo waqnan haqad Pailat bulonan in hulosan ne gigo hib lah ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Lehsa ne mat i giyon os kayeqmo kuluwa-kuluwmo osayta adanteqin wastitay igta na wol eman tumomta ham. Moqan God hodhodab wazan ta eram ham. Eraqim kayeqmo ossa i giger gimeb in ahol tuwawta iyim iyan i agamukan bilaqauqta ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","I Yesus anan helmo diq haqauqta ham. Nazaq iyan Yesus aholnan naqmo in mat ka asen eman awaz timeqniy ham. Ne mat ka ahol waqad ne in ago tuhurit kemayta ham. Teq i Yesus anan helmo haqsa Yesus-mo ne bunmo gimeb mat ka ahol wastitayan tidimniy bug ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ya imaqbaban ham. Ya inad emaiq, Ne ginad a hi em hasadmo Yesus ago hib daq meqinta na emiyta haqaiq ham. Sa ne gigo mataw aseseqta nazaqmo in ginad a hi em hasiymo ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kwaziqmo God in ago nantut giqezab bilam, Yaqgo Krais teq santitiy sordaq haqad in bilam ham. Haqad teq in ne gigo daq meqinta na amalib in ago gamuk bilaqan usta na tuwol net bug ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nazaq iyan ne gigo daq teq ginad meqinta na ne gileh ugad ginad buliyiy ham. Ad ne muleqeq God ago hib ta boliy ham. Id teq God ne gigo daq meqinta na giwalemad anadin a ta hi emdaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ad in kam dimunta negid ne Iyahta ago hib osad ne gigem hastitaysa gihol tisinamoldaq ham. Sa abeb in Yesus emid ne gigo hib tuboldaq ham. God in mat naqmo ne gilumsihgo haqad atowun eman osaqta ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mat na muran Heven-ib tuqosaq ham. Kwaziqmo God ago nantut tawonta na bilaq yaqay, Kam abebtanta nab teq God in nagah bunmo giqemid mutur tiqiydaq haq yaqay ham. An muran Yesus kam na amen emim osaqta ham. Kam na bo gwahtiqsa teq in muleqeq ta boldaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kwaziqmo Moses bilam, Iyahta God teq ne gilikmanib ne gimaqbab araq emid gwahtiqeq in ago nantut ya nogmo iyeq osdaq haqad in bilam ham. Osad in ne gamuk gibilensa ne in aqez huritiy haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ad in bilam, On mataw in aqez a hi hurit daqayta na bunmo God in gimuzid gibin tihiqiydaq haqad in bilam ham. Gibin hiqiysa in God ago on mataw nenaq a ta hi os daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Teq God ago nantut bunmo in gamuk naqanta bilaq toniymo ham. Samuel teq God ago nantut Samuel muzim gwahtiqiyta na bunmo in kam muturta ka anan bilaqiyta ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ari God ago nantut nagan gisesan negmo osayta ham. Ossa God kwaziqmo ne gisesan nenaq an amugan wazim nagah negnan gibilanta na muran negmo tuwaqayta ham. God Abraham inaq an adugan wazim bulon, Ni nises abeb teq gwahtiqdaqta na amalib ya on mataw en bunmo tigidimun tondaiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nazaq iyan muran God ne gilikmanib ago kabibiy mat na eman gwahtiqim in danmeb ne gigo hib tubol ham. In anad mat na ne gidimun tonad ginad buliysa ne bunmo ginad buliyeq gigo daq meqinta gileh ug daqay haqad in mat na eman ne gigo hib bolta ham. ");
INSERT INTO mlp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ari Pita ayow Jon inaq in on mataw gamuk gibilenad tursamo mataw tamaz emayta na asor teq mataw Tempel-ib hurmey osayta gigo mat danmebta na teq Sadyusi asor in bo tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gwahtiqim tursa Pita ayow Jon inaq mataw suleq negad gibilen yaqay, Yesus moqim ta eram haq yaqay. Nazaq iyan on mataw Yesus anan helmo haqayta na moqeq in hodhodab tiqeraq daqaymo haq yaqay. Haqsa mataw aseseqta na in giger gigo gamuk na huritad in ginan gigem timeqniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gigem meqniysa in giger na giwazim giqad lehim bit giqirquran osayta nab giqeman tuqosiy. Na ezaqgo zeq tuwolehsa imisor diq tiqiyan in babeq teq in giyon hazizir emgo haqad. ");
INSERT INTO mlp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ta teq on mataw kabemmo God ago gamuk na huritim in helmo tihaqiy. Nazaq iyan mataw helmo haqiyta na gigo dauh kabemmo diq iyim in ginulinqan gwalim 5,000 nazaqmo iy. ");
INSERT INTO mlp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ari usim ta eraqim Juda gigo mataw marorta na teq mataw aseseqta na teq mataw Moses ago gunun hurit kemiyta nagan bo uliq Jerusalem-ub humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Humab wolim ossa tamaz mat danmebta anan Anaz haqayta na teq Kayafas teq Jon teq Aleksanda teq tamaz mat danmebta na asenlul matmatta bunmo in humab nab osiymo. ");
INSERT INTO mlp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Osad in Pita ayow Jon inaq giqeman ginognib tursa teq in kazaq tisusumun negiy, Ne zaway ezaqta waqiy? haqiy. Ne nog anan biyad daq na emiy? haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Haqan God ago Bugaw Dimunta Pita aholib ayahmo bolan Pita era tigibilan, Ne Isrel-ib mataw aseseqta teq ne mataw marorta ham i giger mat araq asen meqinta ulumsihta na ago ne susumunay ye? ham. Ad ne mat na ahol ezaq dimniyta na ago ne hurit kemnan e? ham. ");
INSERT INTO mlp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ari ne bunmo gidek emeq hurit kemiy ham. Sa Isrel on mataw bunmo hurit kemiymo ham. Yesus Krais Nasaret-ibta na abinibmo mat ka ahol dimniyan in kawa ne gimeb tituraq ham. Ne Yesus ayib dom woliyta ham. Teq God hodhodab wazan ta eramta ham. ");
INSERT INTO mlp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ne bilaqne mataw bit emayta nog iysa ta mat na in bilaqne tituq nog osaqta ham. Sa ne tituq na ahol waqim hunegad anan ‘meqin’ haqiyta ham. Ta teq muran tituq na zaway diq iyim in bit anon bunmo tisor bugaqta ham. ");
INSERT INTO mlp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mat araq i gilumsihdaqta na haiqgam ham. Og kab on mataw bunmo gilikmanib God in mat amulikmoqmo eman gwahtiqim in amomo i gilumsiheq ta giwaqdaqta ham. Na Yesus-mo ham. ");
INSERT INTO mlp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Haqsa mataw aseseqta na in Pita ayow Jon inaq gibiyan in uliqabmo matawta suleq a hi emiyta nog iyiy. Ta teq in giger a hi rabad nan atoranmo bilaqsa in gibiyad gihol turuh nemsa ginad em yaqay, Mataw giger ko Yesus inaq luw osiyta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Haqad in mat ahol tidimniyta na Pita ayow Jon inaq gigerab tursa ahol waqad in Pita aqez amenin emgo gamuk haiqgam tiqiyiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nazaq iyan in Pita ayogniz nenaq gimuzan le kaunsel bit asan ban gwahtiqsa teq in gimo osad kazaq an tubuloniy. ");
INSERT INTO mlp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","I mataw giger ko ezaq gitonam? haqiy. In daq azawayin inaq lul araq diqta tiqemiy haqiy. Eman Jerusalem-ub on mataw bunmo daq na ago tuhuritiy haqiy. I haiq haqamta adanteqin tihiqiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Luweq daq ka agamukin haresmo on mataw og saw bunmo gigo hib tileh tutdaq haqiy. Nazaq iyan i giger ko gidek wazad gamuk awaz meqinta gibilenid in Yesus ananib mataw gamuk ta hi gibileniy haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Haqad in Pita ayow Jon inaq gililewunan ta bolan in gamuk araq o suleq araq Yesus ananib ta hi emgo atoranmo gibileniy. ");
INSERT INTO mlp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Gibilenan Pita ayow Jon inaq amenin emim gibileniy, Ne ginad ezaq emay? haqiy. I God anad othasad i negmo gigo gamuk muzinamta na in God ameb daq dimun o daq meqin? haqiy. Daq na negmo ulum kemeq teq ginad emiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Teq i giqez mugnetgo haiq haqiy. I nagah ahol tuwawta teq i gamuk tuhuritta na ago i tibilaq sireqam haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Haqan mataw marorta na in Pita ayow Jon inaq gigo hib daq meqinta alulin araq ahol a hi waqim in gamuk atoranmo a ta gibilenim teq in gihulosan tilehiy. Ari mat aholib daq azawayin inaq gwahtiqan in asen tidimniyta na ago ulig in 40 nazaq uriyamta. Nazaq iyan mataw aseseqta na in on mataw ginadin emad in Pita ayow Jon inaq santitiy araq negnan rabiy. Na ezaqgo on mataw bunmo in daq na ago God abin tiqiluw yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ari mataw aseseqta na in Pita ayow Jon inaq gihulosan giger na in giyogniz gigo hib muleqim ta lehim in mataw tamaz emayta gigo aseseqta na teq mataw marorta na giqez titutiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Giqez tutan giyogniz na bunmo huritim in ginad amulikmo iyad God inaq gamuk kazaq emiy. Iyahta haqiy ni kait teq og teq kamis teq saw nagab nagah bunmo giqusayta na inaqmo ni giqam bugta haqiy. Giqem bugim ni nagah nagan bunmo gigo anamren iyim ni giwamuzad osaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kwaziqmo ningo Bugaw Dimunta in i gises Devit aqezab gamuk araq eman gwahtimta haqiy. Gwahtiqsa ningo kabibiy mat na bilam, Nagaqgo mataw en ta asor Juda a haiqta nagan gigem meqniyaq? haqad in bilam haqiy. Nagaqgo in daq samanta anon a hi emdaqta haresmo emnan ginad emay? haqad in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Og kab king bunmo in Iyahta inaq bab emnan gihol tuwastitayiy haqad in bilam haqiy. Gihol wastitayim in Iyahta teq in ago Krais inaq gibaymuzad giwazid woqnan haqad humab woliyta haqad in bilam haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Helmo haqiy. Ningo kabibiy mat tawon diqta ni ninad muz bugta na Yesus-mo haqiy. Na in ningo on mataw gilumsiheq ta giwaqgo haqad ni ulumim wamta haqiy. Teq Herot ayow Pontiyus Pailat inaq teq mataw en ta asor Juda a haiqta nagan teq Isrel on mataw na in Yesus baymuznan haqad uliq kab humab woliy haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Teq in ginadibmo daq na a hi emiy haqiy. Kwaziqmo ni ningo zawayibmo in gimen dante tuwastitayta haqiy. Wastitayan mataw aseseqta na in ni ninad kwaziqmo ni eman usta naqmo muzinim daq na emiy haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Iyahta haqiy muran mataw aseseqta i gimeqin tonnan bilaqsa ni gibiy haqiy. I ningo kabibiy matawta haqiy. Ni i gilumsihsa i zaway diq iyeq ningo gamuk atoranmo bilaquq haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bilaqad i ningo kabibiy mat tawonta Yesus anan biysa ni niben itiwuneq mataw moqayta na giwastitayad ni daq azawayin inaqta amo amo giqemid gwahtiqan haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ari in gamuk na bilaqim tihiqiyan bit in humab wolim osiyta na dedibmo ahol wolsa God ago Bugaw Dimunta in giholib ayahmo tubol. Bolan mataw na zaway iyim God ago gamuk atoranmo tibilaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ari mataw helmo haqayta na bunmo gigem ginad amulikmo tiqiy yaqay. Sa in gigo araq ago nagah ahol waqad “Ka yaqgo diqmo” haqad in nazaq a hi bilaqyaq. Haiqgam. In bunmo gigo nagah araqibmo tuwaz yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sa Aposel in Iyahta Yesus hodhodab eraqan in ahol waqiyta na agamukan mataw tigibilen yaqay. Gibilensa in gigo gamuk na azawayin ayahta inaq iyyaq. Sa God agem dimunta ago on mataw na negsa in bunmo ginad dimniysa dimun diqmo tuqos yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","In gilikmanib mat araq diq in nagah osgo siqim a hi iyyaq. Na ezaqgo mat nog in ago og o in ago bit inaq na in mataw ta asor gigo hib zayad amenin waqeq in mani na a boleq Aposel tinegyaq. Negsa in gilikmanib nog nog in nagah araq ago woqsa Aposel ahol waqad in mani na asor uroteq tuqug yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sa in gigo mat araq anan Josep haqayta os. Aposel in anan araq Barnabas haqad ugiyta. Teq nan Barnabas na alulin mat mataw gigem zaway negaqta haqayta. Mat na in Juda gises Liway anaynayin araq teq in nud Saiprus-ibta. ");
INSERT INTO mlp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","In ago og araq mat araq ago hib zayim in mani na waqim a bolim Aposel tinag. ");
INSERT INTO mlp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ari mat araq anan Ananayas haqayta na in awe Safaira inaq in gigo og araq mat araq ugad amenin waqiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Amenin waqim aduw mani na asor ulilemsa awe huritim anad bilam. Sa aduw mani na asormo waqim a bolim Aposel negad in bilam, Ya og zayim mani wayta na bunmo kawaqmo ham. Sa in awe nagah na ago tuhuritta. ");
INSERT INTO mlp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","In nazaq haqan Pita tubulon, Ananayas ham ezaq tonim ni Satan hulosan in ni ninad wamuzad nibe yahsa ni ningo og na zayim amenin asor ulilam? ham. Ulilemad ni God ago Bugaw Dimunta tikat ugaq? ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Og na ni a hi zaysamo in ni nibinib tuqusta ham. Ad ni og na zayim amenin wamta na in ninmo ninad muzgo usta ham. Nagaqgo ni daq meqin kazaq emnan ninad am? ham. Ni matmo diq a hi kat ug ham. Haiqgam ham. Ni God-mo tikat ug ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Haqanmo Ananayas gamuk na huritim in ogib woqimmo tumom. Moqan mataw daq na abin huritiyta na bunmo tirab naqmo diq hiqiy yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sa mataw minminta asor bolim Ananayas momta na asan tubusanib il tonim sorim a le tiyay toniy. ");
INSERT INTO mlp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ari mataw na os tutsa zeq adulan ezeqman nazaq le tihiqiyan ta Ananayas awe bo tugwahtim. In aduw momta na ago abin a hi huritimmo in gadgadmo bol. ");
INSERT INTO mlp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bolan Pita bulon, Ezaq? ham. Ne giger og na zayim mani kazaqmo waqiy ye? ham. An aw na bilam, Eqe ham i giger mani nazaqmo wawta ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Haqan Pita bulon, Nagaqgo ne giger Iyahta ago Bugaw Dimunta ulum waqnan an adugan waziy? ham. Ni hurit ham. Mataw niduw yay toniyta na bo dan ezab tituray ham. Teq in ni nisoreq niqad tileh daqaymo ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Haqan nawaqmo aw na Pita anognib woqimmo tumom. Moqan mataw minminta na bo gwahtiqim in aw na moqan ahol tuwaqiy. Ahol waqad in sorim a lehim aduw agerab tiyay toniy. ");
INSERT INTO mlp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nazaq iyan Yesus ago on matawta na bunmo tirab titay yaqay. Sa on mataw God ago maror asan ban osiyta na nazaqmo in daq na abin huritad tirab yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ari Aposel in on mataw gilikmanib daq azawayin inaqta amo amo kabemmo giqeman gwahtiq yaqay. Sa Yesus ago on mataw na bunmo gigem amulikmo iyim in Tempel ago veranda anan Solomon ago veranda haqayta nab sirisirimo humab tuwol yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sa on mataw asan banta na in Yesus ago dauh na gibin tiqiluw yaqay. Ta teq in girabunad in bo nenaq humab a hi em yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sa God in on mataw kabem diqmo giqeman in Iyahta anan helmo haqad ago dauh na giduganib tubol yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nazaq iysa iyan mataw in giyogniz gigo moq inaqta gisoreq giqad leheq dan adek ban garuruh hureneq teq in haris-haresmo giqemid us yaqay. In ginad em yaqay, Pita loq gelad luwsa zeq bo aholib worireqsa adulan le mataw moqayta ka giwazid dimniy daqay haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Sa on mataw kabemmo uliqben amikmikta Jerusalem agerab osiyta nagan inaqmo Aposel gigo hib tubol yaqaymo. Bolad in mataw gigo moq inaqta na teq mataw gigo bugaw meqinta inaqta nagan giqad bolsa on mataw na bunmo gihol tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Daq nazaq gwahtiqsa tamaz mat danmebta na ayogniz Sadyusi nenaq in Aposel gigem meqinta tineg yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Gigem meqinta negad in eraqim Aposel giwazim giqad le gavman gigo bit giqirquran osayta nab tigiqemiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Giqeman ossa taromab Iyahta ago angelo araq bolim bit na adanin hasim in Aposel giqad asanib gwahtiqim teq in gibilan, Ne leheq Tempel ago gel aduganib gwahti turad ne os muturta ka ago adan agamukan bunmo on mataw gibileniy ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Haqan Aposel gamuk na huritim tarommo saw hastitaysa in Tempel-ib lehim on mataw gamuk tigibilen yaqay. Ari tamaz mat danmebta na ayogniz Sadyusi nenaq bolim nan eman Juda gigo kaunsel ayahta na gigo hib lehan Isrel-ib mataw marorta na bunmo bo humab tuwoliy. Humab wolim osad teq in kabibiy mataw asor giqeman in Aposel giqirquran osayta na giwaqeq giqad mataw aseseqta na gimeb ta bolnan haqad tilehiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lehim bit giqirquran osayta nab in Aposel gisawan tuwaqiy. Gisawan waqim in muleqim ta lehim mataw aseseqta na tigibileniy. ");
INSERT INTO mlp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","In bilaqiy, I bit nab lehim dan ez bunmo giqot bugan giwaz meqniyim ussa i ahol waw haqiy. Sa mataw dan ez wamuzayta nagan in dan ez buntab tituray haqiy. Ta teq i dan hasim mat araq aduganib ossa i ahol a hi waw haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Haqan mataw Tempel-ib hurmey osayta gigo mat danmebta na teq mataw tamaz emayta gigo aseseqta na in gamuk na huritim in ginadnad emad bilaqiy, Mataw na ezaq tonim nabag lehiy? haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sa mat ta araq bo gwahtiqim gibilan, Huritiy ham. Mataw ne giqirquriyta na in muran Tempel agelin aduganib turad on mataw gamuk tigibilenay ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Haqan hurmey gigo mat danmebta na ago mataw asor nenaq lehim in Aposel na amidemqanmo giwazim giqad ta boliy. Na ezaqgo in rabad ginad em yaqay, Luweq i mataw ka ginolid on mataw biyahta ko i gimen gig hunegad tiginol em daqay haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Mataw na Aposel giqad bolim Juda gigo kaunsel ayahta na ginognib giqeman tituriy. Tursa tamaz mat danmebta na gibilan, Ne mat na abinib on mataw ta hi gibilengo haqad i atoran diqmo gibilenta ham. Ta teq ne gigo suleq na ayah iyim in uliq Jerusalem tuwaleq ton bugaq ham. Sa mat na wol eman momta agamukan ne i gimalib emnan tonay ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Haqan Pita ayogniz Aposel bunmo nenaq in amenin emim bilaqiy, I God-mo aqez muzinamta haqiy. I mataw giqez a hi muzinam haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ne Yesus atoranmo wazim ayib dom wolad ne wol eman tumomta haqiy. Ta teq i gisesan gigo God in wazan ta eram haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Eraqan God in abin ayahta ugim teq in waqim eman ulilibmo inmo aben aqabun ban tuqos woqim osaq haqiy. Osad in Maror Iyah diqta on mataw gilumsiheq ta giwaqdaqta amatin tiqiy haqiy. Iyim in Isrel on mataw ginad wazid eraqsa in ginad buliyad gigo daq meqinta gileh ugsa in gigo daq meqinta na tigiwalemdaq haqad in osaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","God daq nagan bunmo emsa i gimebmo ahol tuwaqim on mataw gibilenauqta haqiy. Sa God in on mataw inmo aqez huritayta na in ago Bugaw Dimunta tinegan Bugaw na in daq nagan ago bilaqaqtamo haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ari mataw aseseqta na in Aposel gigo gamuk na huritim gigem diq meqniysa in Aposel ginol emnan ginad tiqem yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sa Farisi gigo araq Juda gigo kaunsel ayahta nab osim in eraqim titur. Mat na anan Gamaliyel haqayta. In God ago maror Moses bilamta na asuleqin bilaqaqta amatin araq. Sa on mataw bunmo in mat na wazinad ago gamuk hurit yaqayta. Ari mat na eraqim turad in Aposel gimuzid asanib lehgo tibilam. ");
INSERT INTO mlp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bilaqan Aposel asanib tilehsa teq in mataw aseseqta na kazaq gibilan, Ne Isrel mataw ham ne ginad em haseq teq mataw ko giholib daq emiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Na ezaqgo kwaziq nogmo mat anan Teudas haqayta na eraqim bilam, Ya mat ayahta ibin inaqta haqad in bilam ham. In nazaq haqan mataw 400 nazaq muzinad inaq luw yaqayta ham. Luwsa gavman mataw asor bolim mat na wol eman in ago mataw in anan helmo haqiyta na haresmo tuksa ago kabiy na tuwom ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Teq daq na abeb gavman in on mataw ginan waqad ginuliniyta nab mat ta araq anan Judas saw Galiliy-ibta na eraqim on mataw asor giqutil wazan eraqsa in gihuram ham. Teq mat na tumommo ham. Moqan ago mataw in anan helmo haqiyta na bunmo tukim hares tiqiy bugiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nazaq iyan ya ne gibilenaiq ham. Ne mataw ko ginan asit rabad giholib daq araq hi emiy ham. Ne gihulosidmo luwiy ham. Nagah ka alulin matawmo gigo hib ussa teq in anadibmo tihiqiydaqta ham. ");
INSERT INTO mlp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ari nagah ka alulin God-mo ago hib usid teq ne mataw ko a hi giwasih daqay ham. Luweq ne nazaq emad ne God inaq an tuwol daqay ham. Ari Gamaliyel nazaq haqan mataw aseseqta na aqez tumuziniy. ");
INSERT INTO mlp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Muzinim in Aposel gililewunan bolan in gusib tigitituw ninaliy. Ad in Yesus ananib gamuk araq ta hi emgo atoranmo gibileniy. Gibilenim gihulosan asanib tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Gwahtiqim in Juda gigo kaunsel ayahta na hulosad ginad dimniysa tilehiy. Na ezaqgo God agem dimunta negad in Yesus abin eman in gigo hib ayahmo iyan in Yesus abinib mebay soriyta na ago in God ago hib ginad ayahmo dimniyiy. ");
INSERT INTO mlp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ginad dimniysa kam bunmo in Tempel-ib teq on mataw gigo bit amo amo-ib leheq suleq negad bilaq yaqay, God mat emid bo i gilumsihdaqta amatin anan Krais haqayta na in Yesus-mo haq yaqay. Haqad in giwaz meqniyim gamuk na bilaqad in gigo daq na a hi hulos yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kam nab on mataw kabemmo diq disaipel tiqiy yaqay. Sa in gigo asor Grik nan bilaqayta na eraqim in disaipel Hibru nan bilaqayta na tiginad yaqay. Ginadad in bilaq yaqay, Kam bunmo ne on mataw didaq nagah ago siqim iyayta na gilumsihad ne i gigo on waburta gihulosad ginadin a hi emayta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Afaqan nazaq gwahtiqan Aposel 12 na in disaipel biyahta na bunmo gililewunan bolan in gibileniy, I God ago gamuk akabiyan hulosad didaq iberamta na in dimun a haiq haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nazaq iyan i gimaqbaban haqiy ne gilikmanib mataw 7 nazaq ginaguniy haqiy. Mataw na in on mataw gigo hib gibin dimunta usaqta teq God ago Bugaw Dimunta in giholib ayahmo usaqta teq in ginad awaz meqinta, mataw naqanta ne ginaguniy haqiy. Id teq i mataw 7 na giqemid in kabiy na tuwamuz daqay haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wamuzsa igmo kam buntab God inaq gamuk emad teq i on mataw God ago gamuk gibilenad i gihol bunmo emid kabiy nab lehdaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Haqan on mataw bunmo gamuk na huritim in ginad tibilam. Ginad bilaqsa in mat araq anan Stiven haqayta na anan bilaqim waqiy. Stiven in mat anad helta ayahmo usyaqta. Ussa God ago Bugaw Dimunta in aholib ayahmo usyaqtamo. Teq in Filip teq Prokorus teq Nikanor teq Timon teq Parmenas teq Nikolas ginan bilaqim giwaqiymo. Nikolas in mat uliq Antiyok-ibta. In Juda mat a haiqta teq kwaziqmo in Juda gigo maror ahaqenib iyim muzinyaqta. ");
INSERT INTO mlp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","In mataw 7 na giwaqim Aposel ginognib giqeman tursa Aposel God inaq gamuk tiqemim teq in giben mataw na giholib emim giwazad kabiy tinegiy. ");
INSERT INTO mlp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ari God ago gamuk le ayah iysa uliq Jerusalem-ub on mataw kabemmo gamuk na anan helmo haqsa disaipel ginulinqan kuluwmo diq tiqiy yaqay. Sa Juda gigo mataw tamaz emayta na kabemmo in nan huritad helmo tihaq yaqaymo. ");
INSERT INTO mlp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ari God agem dimunta teq zaway ayahmo Stiven ugsa in daq azawayin inaqta aseseqta amo amo on mataw gilikmanib giqemyaq. ");
INSERT INTO mlp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Emsa mataw asor eraqim Stiven inaq an tumugiy. Mataw na in Juda gigo dauh araq anan Friman haqayta na gigo asor. Na in uliq Sairin-ibta teq uliq Aleksandriya-ibta teq saw giger Silisiya-ibta teq Esiya-ibta. ");
INSERT INTO mlp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","In Stiven inaq an mugsa God ago Bugaw Dimunta Stiven anad dimunta ugsa mataw na Stiven ago gamuk bayan yo hiqiy yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nazaq iyan in ulilemim le mataw ta asor mani negan in katiyad bilaqiy, Stiven in Moses teq God inaq gibilawunsa i hurit haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","In nazaq haqad in Juda gigo mataw marorta na teq mataw Moses ago gunun hurit kemiyta na teq Juda on mataw kabemmo inaqmo gigem wazan eraqsa in Stiven anan gigem timeqniyyaq. Gigem meqniysa in le Stiven wazim ad Juda gigo kaunsel ayahta na gigo hib tilehiy. ");
INSERT INTO mlp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Lehim in mataw asor Stiven amalib nan katiyta em daqayta humab nab giqem toniymo. An mataw gimileq iyayta nagan in Stiven anan bilaqiy, Tutimmo mat ka God ago bit tawonta ka teq God ago maror Moses bilamta na inaqmo gibayan woqayta haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Haqad in bilaqiy, Mat ka bilam, Mat anan Yesus uliq Nasaret-ibta haqay na in teq Tempel wolinerad in i gigo maror Moses igta na tubuliydaqmo haqsa i huritta haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Haqan mataw kaunsel ayahta nab osiyta na bunmo in gime le Stiven atoranmo ahol waqsa Stiven anobun angelo anobun oy nog iysa in ahol waqiy. ");
INSERT INTO mlp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ari tamaz mat danmebta na in Stiven susumun ugim bilam, Gamuk nawa ni nimalib emayta na in helmo ye? ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Haqan Stiven bilam, Ya imaman teq ya imaqbaban ham ne huritiy ham. Kwaziqmo i gises Abraham uliq Haran-ib a hi lehadmo in saw Mesopotemiya-ib osyaq ham. Ossa God uliq Heven-ib abin teq ahol anuwan ayahta inaq osaqta na in Abraham ameb tugwahtim ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Gwahtiqim in Abraham bulon, Ni ningo og teq nisenlul bunmo gihulosad og araq ya tiniqisihundaiqta nab ni leh haqad in bulon ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Haqan Abraham eraqim Kaldiya gigo og in osta na hulosad uliq Haran-ib tilah ham. Lehim ossa amam nab tumom ham. Moqan God in Abraham eman bolim in og muran i Juda osauqta kab in tuqos ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ossa kam nab God in og ka ago asit diq araq Abraham aholyon waqgo a hi ug ham. Teq in hel diqmo haqad Abraham kazaq bulon, Abeb teq ya og ka nigid ni teq ni nitatniz nenaq giholyon tuwaq daqay haqad in bilam ham. Abraham amun haiqmo ossa God in nazaq bulonta ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Teq God kazaq bulonmo ham. Ni nisesan abeb teq gwahtiq daqayta na in le mataw asor gigo ogib begbeg iyeq tuqos daqay haqad in bilam ham. Ossa og anamreniz na in ni nisesan giqemid in gigo kabibiy mataw samanta iysa in gimeqin tonad kabiy afaqanta tineg daqay haqad in bilam ham. Negsa ni nisesan nazaq meqin diq ossa le ulig 400 nazaq tiqiydaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Sa ni nisesan in mataw na gimen kabiy emsa ya mataw na gilum kemad gigo daq amenin negsa in ni nisesan gimuzid og na huloseq tugwahtiq daqay haqad in bilam ham. Gwahtiqeq in boleq og kabmo yaqmen lotu tiqem daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","God nazaq bulonim teq in Abraham inaq an adugan wazim bulon, Abraham ham ni nihol abatan asan tuqurotdaq haqad in bilam ham. Na in Abraham inaq an adugan wazta na atowun Isrel mataw bunmo gisanib usdaq haqad in maror na ugta ham. Nazaq iyan abeb Abraham ago amun Aisak gwahtiqim in ago kam 8 nazaq tiqiyan Abraham in asan tuqurot ham. An abeb Aisak in Jekob amam iyim in nazaqmo ton ham. An Jekob in i gisesan 12 na gimam iyim in atatniz na gigo hib daq nazaq amtamo ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Teq i gisesan Jekob atatniz na in gimikqan Josep anan gigem meqniysa in waqim mataw ta asor gigo hib tizayiy ham. Zayan mataw na Josep waqim ad Isip-ub tuwolehiy ham. Ta teq God in Josep a hi hulosad in inaq luw os tutyaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ad in Josep ulumsihim in ago afaqan bunmo giwalam ham. Walemim teq in Josep zaway ugsa Josep in Isip gigo king Fero ameb mat dimun diqta anad awaz meqinta amatin tiqiy ham. Nazaq iyan king na in Josep ban ugan in gavman gigo mat danmebta iyim in Isip bunmo giwamuzad teq in king Fero ago kabiy nagah bunmo inaqmo tigiwamuzyaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Abeb zarow araq ayahta Isip teq Kenan gigo og saw bunmo tugwahtim ham. Gwahtiqan on mataw saw nagab bunmo afaqan ayahmo tisor yaqay ham. Sa i gises Jekob atatniz nenaq in didaq ago siqim tiqiyiymo ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sa Jekob in Isip-ub didaq usaqta na agamukan huritim in i gisesan giqeman in gime danmebta tuwolehiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Teq in gime gigerta a ta lehan Josep in ababan gimeb ahol tuqulal ton ham. Ulal tonan teq Fero in Josep asenlul na gigo tuhurit kam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","An teq Josep in amam Jekob amen nan emim lilewunan in amam teq in amaqbaban giqonan gigo onmin nenaqmo bunmo in ago hib tuwolehiy ham. Wolehim Josep asenlul na bunmo in on mataw 75 nazaq iyim tuqosiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ari Jekob Isip-ub tuwolah ham. Wolehim osad abeb in tumom ham. Sa i gisesan na bunmo osim tumoqiymo ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Moqsa mataw in gisan gisoreq giqad Sekem-ub leheq giyay ton yaqay ham. Kwaziqmo Abraham uliq Sekem-ub Hamor atatniz gigo hib mani silva negad gigo og asor zayta nab in hodhodab giyay toniyta ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Giyay tonan ulig kabemmo le tihiqiyan teq abeb God in Abraham asesan og negnan hel diqmo bilamta na akaman tugwahtiqnan tonyaq ham. Gwahtiqnan tonsa Jekob abaqbaqniz na Isip-ub osad in qwabiyayad on mataw kabemmo diq tiqiy yaqay ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sa kam nab mat araq gwahtiqim Isip gigo king iyim os ham. Mat na in Josep ago a hi huritad in abin a hi wazinyaqta ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","In i gisesan gikat negad gimeqin tonyaqta ham. Gimeqin tonad in gibe yahsa in gigo onmin ginen mutur giqemsamo in giwaqeq asanib giqemid useq tumoq yaqayta ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sa kam nab Moses anen in ago amun Moses tiqam ham. Eman God amun na ahol waqad ame bilaq naqmo hiqiyaq ham. Sa Moses anen amam in bitabmo amun alowan tonad ossa le kalam ezeqmanmo tihiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Hiqiyan in amun waqim asanib eman ussa Fero amiy in amun na warinim inmo ago amun nog alowan titonyaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sa Moses ayah iyim in Isip gigo ginad dimunta na bunmo asuleqin waqim in ago gamuk teq in ago kabiy bunmo azawayin inaq tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ad abeb in ago ulig 40 nazaq tiqiyan in leheq amaqbaban Isrel gibiygo haqad anad tiqam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Anad emim in lehim luwsa Isip mat araq eraqim anadibmo Isrel mat araq meqin tonsa in tigibiy ham. Isip mat na in mat ago zaway haiqta na meqin tonsa Moses gibiyadmo in lehim ayow ago zaway haiqta na ulumsihad in aqenin waqim Isip mat na wol eman tumom ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moqan Moses anad am, Muran ya imaqbaban ya inan ginad em daqay, God in Moses abenab i tigilumsihaq haq daqay haqad in anad am ham. Teq haiq ham. In ginad a hi emiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ari Moses usim ta tiqim in lehim Isrel mataw giger an wolsa gibiyad in gigerab tilom ham. Loqim in giger na ginobun wastitayid in an a ta hi wolgo haqad gibilenim bilam, Mataw ham ne maqbab haqad in bilam ham. Nagaqgo ne kazaq an meqin tonay? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Haqan giger na gigo araq in daq na anamren iyta na in Moses ulum hasan lehan bulon, Nog bilaqan ni i gigo maror iyim ni i gigo daq ulum kemaq? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Irimo ni Isip mat na wol eman momta nazaqmo ni ya inol emdaqmo ye? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","In nazaq bilaqanmo Moses tituk ham. In tukim lehim Midiya gigo ogib begbeg iyim osyaq ham. Osad teq in aw waqim in ago onmin matmatta giger inaq tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","An ulig 40 nazaq le tihiqiyan teq Moses le og araq amatawun haiqta garah Sainay agerab usaqta nab luwsa angelo araq in ameb tugwahtim ham. Angelo na faq ay amikta oysa in faq na ameb gwahtiqim tur ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Sa Moses faq na ahol waqad anadnad diq emyaq ham. Ad in anononmo ahol waqgo haqad ay agerab loqanmo Iyahta kazaq tubulon ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ya ni nisesan Abraham teq Aisak teq Jekob gigo God haqad in bilam ham. Haqan Moses abensen harara nemsa in ahol waqnan rabyaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Sa Iyahta bulon, Og kawa ni turaqta ka in tawon diqta haqad in bilam ham. Nazaq iyan ni nisenab nisendugan na haseq tur haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ad teq in bilam, Isip-ub og anamreniz in yaqgo on mataw afaqan kabemmo negsa ya daq na bunmo tigibiy bug haqad in bilam ham. Yaqgo on mataw gaqsa ya huritim muran ya in gilumsiheq giholib afaqan na walemgo haqad tigewoy haqad in bilam ham. Nazaq iyan ni eraqeq bo leh haqad in bilam ham. Ya ni Isip-ub niqemid lehnan haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ari kwaziqmo Isrel mataw giger na in Moses baymuzim buloniy, Nog bilaqan ni i gigo maror iyim ni i gigo daq ulum kemaq? haqad in buloniy ham. Ta teq mat baymuziyta naqmo in ay amikta agerab tursa angelo gwahtiqim bulonan in God ago on mataw gigo maror iyeq gilumsiheq gigo bab gibenab giwaqnan haqad lahta ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Lehim in Isrel on mataw giwaqim giqad le Isip hulosim tugwahtiqiy ham. Mat na in Isip-ub daq azawayin inaqta kabemmo giqamta ham. Teq in lehim yuw akurorqanta anan Kamis Kakaqta haqayta na agerab daq azawayin inaqta asor giqammo ham. Teq Isrel in og amatawun haiqtab ulig 40 nazaq luw ossa nab Moses daq azawayin inaqta kabemmo tigiqemyaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mat naqmo Isrel gibilenim bilam, God teq ne gilikmanib ne gimaqbab araq emid gwahtiqeq in ago nantut ya nogmo iyeq osdaq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mat Isrel on mataw nenaq og amatawun haiqtab osta na Moses-mo ham. Mat naqmo in i gisesan nenaq osta ham. Garah anan Sainay haqayta nab angelo in Moses-mo gamuk bulonta ham. Mat God ago gamuk dimunta mataw giqeman kayeqmo kuluwa-kuluwmo osayta na waqim i igta na Moses-mo ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ta teq i gisesan na in Moses aqez huritnan gituw hiqiyiy ham. Gituw hiqiysa in Moses aqez othasad in Isip-ub muleqeq ta lehnan ginad emiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ginad emad in Aron buloniy, Ni i giyon god asor giqem ig haqiy ham. Id teq god nagan danmeb lehad in i giwamuzeq giqad leh daqay haqiy ham. Na ezaqgo mat i giwaqim giqad Isip hulosim bolta na in nabagag lehim ezaqag titon haqiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Haqad kam nab in bulmakau amidon araq adulan emim teq in anognib karuw araq anat urotim faqab wizim in ayon tamaz em ugiy ham. Ad in god katiyta in gibenab emiyta na ahol waqad in ginad tidimniy yaqay ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nazaq iyan God in gileh negad gihulosan in nagah amo amo kaitab usayta na giyon lotu tiqem yaqay ham. God ago nantut gamuk mar toniyta nazaqmo diq in em yaqay ham. Gamuk na bilam, Ne Isrel-ib mataw ham kwaziqmo ne og amatawun haiqtab ulig 40 nazaq osiyta haqad in bilam ham. Osad ne bulmakau teq sipsip ginat urotim faqab giwiz yaqayta haqad in bilam ham. Na ne yaqmen tamaz em yagnan haqad ne nazaq em yaqay ye? haqad in bilam ham. Haiqgam haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ne ya gileh yagad ne god katiyta Molek ago lotu abitan emim teq ne ulig anan Refan haqayta na adulan emiy ham. Emim ne nagah giger na wazim saw haresmo ne luw yaqayta nab ne sorad a luw yaqay haqad in bilam ham. Ne god katiyta naqmo giyon tamaz em negnan haqad ne in gidulan emiyta haqad in bilam ham. Nazaq iyan ya ne gigo ogib gimuzid ne pesanmo saw Babiloniya-ib le tuqos daqay haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kwaziqmo God in Moses bit araq adulan isihunim bulon, Ni yaqmen bit araq kazaqta waz yag haqad in bulon ham. Haqan i gisesan og amatawun haiqtab luw osad kam nab in Tempel karuwsanibta na tiqemiy ham, God Moses bulonta nazaq ham. In bit na emim ahol waqad ginad em yaqay, Muran God i inaq tuqosauq haq yaqay ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ari abeb i gisesan in Josuwa inaq og kawa i osauqta ka anamreniz gimuzeq gigo og waqnan haqad tuboliy ham. Bolan God i gisesan gimeb mataw nagan gimuzan lehsa gigo og ka in waqim i gisesan tinag ham. Kam nab i gisesan lotu abitan karuwsanibta na og kab a bolim in duq tonan tursa le Devit ago kamubmo tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","An God agem dimunta Devit ugsa Devit loyinad in God bulonim bilam, Ni ya ises Jekob ago God haqad in bilam ham. Ni ya inan ninad dimniysa teq ya ninyon bit diq araq em nigiq haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Teq haiq ham. Devit in mat bab emad mataw kabemmo ginol amta iyim in bit na a hi am ham. Devit atatin Solomon teq in God ayon bit diq na tiqamta ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ta teq God Ulilib Diqta na in bit mataw gibenab emayta nab a hi osaqta ham, God ago nantut bilamta nazaq ham. In bilam, ");
INSERT INTO mlp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yaqmo Iyahta ya kazaq bilaqaiq haqad in bilam ham. Ya Heven-ib yaqgo ban tawontab osad nagah bunmo giwamuzaiqta haqad in bilam ham. Teq og ka in ya isen abanan iysa ya isen emim osaiqta haqad in bilam ham. Nazaq iyan bit ezaqta ne yaqmen em daqay? haqad in bilam ham. Teq ogib saw araq ayahta ya woqeq usad inamur emdaiqta na edowa? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yaqmo ibenab nagah kagan bunmo a hi giqemta ye? haqad in bilam ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ne mataw gifaqin atoran diqta ham. Ne gigem soqotim ussa gideksan nan a hi huritaqta ham. Tutimmo ne God ago Bugaw Dimunta baymuzayta ham. Ne gisesan gisen muzinad in daq emiyta nazaq ne emaymo ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kwaziqmo ne gisesan God ago nantut bunmo afaqan negad gimeqin ton yaqayta ham. Sa nantut na asor in mat titnonta teq boldaqta na agamukan bilaqsa ne gisesan na in ginol em yaqayta ham. An muran mat titnonta na gwahtiqan ne waqim bab gibenab eman in tuwol emiy ham. Na in bilaqne negmo gibenab wol emiyta nog tiqiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ne God ago maror Moses bilamta na angelo gibenab waqiyta teq ne maror na wazinad a hi muzinayta ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ari mataw aseseqta na in Stiven ago gamuk huritsa gamuk na giqutil tuqulum. Uluman in gite guruwad Stiven anan gigem diq timeqniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sa God ago Bugaw Dimunta Stiven aholib ayahmo bolan in ame Heven-ib gwalehim turad in God ahol anuwan oysa ahol waqad teq in Yesus God aben aqabun ban eraqim tursa ahol tuwammo. ");
INSERT INTO mlp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ahol waqad in bilam, Ne ahol waqiy ham. Kait misireq nog iyim aqez hassa ya Mat Atatin God aben aqabun ban kowa tursa ahol tuwaqaiq ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Haqanmo haiq mataw na dedibmo ek tonad gideksan ituqad in garabmo eraqim sibim le Stiven tuwaziy. ");
INSERT INTO mlp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Wazim in othishasim ad uliq asan ban lehim in amalib gig tuhuneg yaqay. Sa mataw iturimmo Stiven amalib nan emiyta nagan in daq na anamreniz iyim iyan in gigo giholsihen hasim mat minminta araq anan Sol haqayta anognib humab tuwoliy. ");
INSERT INTO mlp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Humab wolim teq in gigibmo Stiven tuwolsa Stiven bilam, Iyahta Yesus ham ni ya iwitan waq ham. ");
INSERT INTO mlp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Haqad in abakbakan ulum laquwim turad in dedibmo lilay, Iyahta ham ni mataw ka gigo daq meqinta ka walemad anadin ta hi em ham. Haqadmo in tumom. ");
INSERT INTO mlp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","An mataw Stiven wol eman momta na in mat araq anan Sol haqayta na anadib dimun diqmo iy. Ari Stiven momta kam nab Yesus ago on mataw uliq Jerusalem-ub osiyta na gigo hib bab meqin diqta tugwahtim. Gwahtiqan in bunmo haresmo tukim saw giger Judiya teq Samariya gigo saw ban le tuqosiy. Ari Aposel teq in uliq Jerusalem-ub os tutad a hi tukiy. ");
INSERT INTO mlp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Teq Stiven moqan mataw asor God anadin diq emayta na in Stiven asan waqim a le tiyay toniy. Yay tonim in ginad meqniysa gaq ayah waziy. ");
INSERT INTO mlp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sa Sol in Yesus ago on matawta na atoranmo tigimeqin tonyaq. Ad in bit bitmo luwad aduganib gwahtiqeq in mataw on inaqmo giwazeq gihureqeq giqad le bit giqirquran osayta nab tigiqemyaq. ");
INSERT INTO mlp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ari afaqan nazaq gwahtiqsa Yesus ago on mataw saw haresmo tukim le osad in Yesus awagamun dimunta on mataw tigibilen yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Sa Filip eraqim saw Samariya gigo uliq araqab wolehim in mataw na gibileneq bilaqyaq, Yesus in Krais haqyaq. ");
INSERT INTO mlp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Haqsa on mataw uliq nabta na in ago gamuk huritad teq in daq azawayin inaqta emsa ahol waqad in bunmo araqibmo gidek tih nemeq ago gamuk tuhurit naqmo hiqiy yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na ezaqgo in gigo on mataw kabemmo giholib bugaw meqinta usiyta na in on mataw na gihuloseq gwahtiqad in ek toneq tileh yaqay. Sa mataw kabemmo gibensen tumomta teq gisen meqinta nagan in gihol tidimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nazaq iyan uliq nab on mataw ginad ayahmo diq dimniy yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ari uliq nab mat araq anan Saimon haqayta in os. Kwaziqmo in liqiy emad bar hares meqinta giwazyaqta. In nazaq emsa saw Samariya-ib on mataw bunmo gihol riten lamsa in ginadnad diq em yaqay. Sa mat na inmo ahol abin iluwad bilaqyaq, Ya asittaqmo haqyaq. ");
INSERT INTO mlp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Haqsa on mataw bunmo gibin inaqta teq gibin haiqta inaqmo in Saimon ago gamuk tuhurit naqmo hiqiy yaqayta. Ad in mat na anan bilaq yaqay, God ago zaway ayahta na in aholib usaqta haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Saimon ame kabemmo daq lul araq diqta giqemsa iyan mataw ahol waqad gihol riten lamsa in ago gamuk bunmo hurit yaqayta. ");
INSERT INTO mlp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ari Filip bolim God ago maror agamukan dimunta bilaqad teq in Yesus Krais abin gibilensa kam nab on mataw na kabemmo gamuk na anan helmo haqsa Filip giqad le yuwub tigihuz nag. ");
INSERT INTO mlp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sa Saimon inaqmo helmo tihammo. Haqan Filip in huz ugan in Filip inaq soqoteq diq inaq tiluwyaq. Luwsa Filip daq azawayin inaqta amo amo giqemsa Saimon ahol waqad ahol turuh nemyaq. ");
INSERT INTO mlp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ari Aposel Jerusalem-ub osiyta na in Samariya-ib on mataw God ago gamuk anan helmo haqiyta na gibin tuhuritiy. Huritim in Pita ayow Jon inaq giqeman Samariya gigo hib tuwolehiy. ");
INSERT INTO mlp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wolehim osad in Samariya-ib on mataw helmo haqiyta na gimen God tubulon yaqay, God in ago Bugaw Dimunta negdaq haqad. ");
INSERT INTO mlp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Na ezaqgo on mataw na Iyahta Yesus abinib yuw huziyta teq God ago Bugaw Dimunta in gigo hib a hi bolyaqta na ago iyan. ");
INSERT INTO mlp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ari in giger God bulonim teq in on mataw na gifaqinib giben emsa in God ago Bugaw Dimunta tuwaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Teq Aposel giger na giben on mataw gifaqinib emsa in God ago Bugaw Dimunta waqsa Saimon tigibiy. Gibiyad teq in mani waqim giger na gigo hib a bolim gibilan, Ne giger zaway na ya yag toniy ham. Yagid ya nazaqmo iben mat araq afaqinib emsa in God ago Bugaw Dimunta tuwaqdaqmo ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Haqan Pita bulon, Ni ninad emaq, God ago naw in samanmo igaqta na ya mani-mo amalib tizaydaiq haqaq e? ham. Ni ninad nazaq emad ni ningo mani inaq garabmo tihiqiydaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","I God ago kabiy emauqta ka aduganib ni a hi loqdaq ham. Haiq diqmo ham. Ni nigem God ameb dimun a haiq ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nazaq iyan ni nigem buliyeq ninad meqinta na gileh ug bug ham. Ad ni Iyahta bulon waq ham. Yowo ham. In ni nigemab ninad meqinta na walemdaq o haiq? ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ya nibiysa ni nigem meqniysa ninad meqinta na nihol bunmo wamuzsa ni daq araq dimunta a hi emaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Haqan Saimon amenin emim bilam, Ne giger yaqmen Iyahta bulonsa in ya ilumsihan ham. Id teq daq nawa ne anan bilaqayta na in ya iholib hi gwahtiqan ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ari Aposel giger na in Iyahta awagamun teq nagah bunmo Iyahta emsa in gimeb ahol waqiyta na atoranmo gibilenim hulosad in muleqim Jerusalem-ub tugwalehiy. Gwalehad in Samariya gigo uliq amikmikta nagab lehad in Yesus awagamun dimunta na gibilenim gibilenim tilehiy. ");
INSERT INTO mlp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ari Iyahta ago angelo araq Filip bulon, Ni eraqeq saw Saut bantab leh ham. Dan Jerusalem hulosad uliq Gaza ban wolehaqta naqmo ni muzeq leh ham. (Dan na saw amatawun haiqtab usaqta.) ");
INSERT INTO mlp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Angelo nazaq bilaqan Filip eraqim tilah. Lehad danibmo in Itiyopiya mat araq akayogin ayiyta ahol tuwam. Mat na in Itiyopiya gigo aw marorta anan Kandasi haqayta na ago mat ayahta araq iyim in maror awta na ago mani bunmo wamuzyaqta. Mat na uliq Jerusalem-ub God ayon lotu emnan bolta. ");
INSERT INTO mlp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Bolim in ago wilka-ib muleqim ta lehad teq in God ago nantut Aisaya gamuk mar tonta na ahol tuwaqyaq. ");
INSERT INTO mlp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Samo God ago Bugaw Dimunta in Filip bulonim bilam, Ni wilka agerab loqeq inaq leh ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Haqan Filip sibim agerab lehim in mat na Aisaya ago nan asor ahol waqad bilaqsa tuhurit. Huritadmo in bulon, Ni marib nawa gamuk ahol waqad bilaqaqta na alulin asit ni towa hurit e? ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","An mat na wilka wazim teq in Filip bulon, Mat araq gamuk ka alulin a hi ibilenid ya ezaq teq inad em hasdaiq? ham. Haqad in Filip bulon, Ni gwalid ya ninaq osuq ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ari mat na God ago marib gamuk ahol waqad bilamta na in kazaq. Mataw sipsip wol emnan haqad wazim a bolayta nazaqmo in mat na wazim a boliy ham. Teq mataw sipsip amidon wazim ahulgen urotsa in a hi gayonaqta nazaqmo mat na ate akim a hi ek ton ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mataw daq titnontab mat na ago hazizir a hi emiyta ham. In mat na mebay ugad bayan diq wom ham. Ezaq teq mataw in mat na asesan ginulin daqay? ham. In amun a hi emsamo wol eman moqim in og kab ahol amagin titartay ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ari mat na in Filip bulon, Ya susumun nigaiq ham. God ago nantut nog anan bilaqad gamuk ka am? ham. Inmo ahol anan bilam o haiq in mat ta araq anan bilamta? ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Haqan Filip in God ago mar asitmo ahol wamta naqmo amalib gamuk alulin emim in Yesus awagamun tubulon bug. ");
INSERT INTO mlp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ad teq giger na lehad luwimmo in yuw araqab tugwahtiqiy. Gwahtiqimmo mat na in Filip bulon, Ahol waq ham. Yuw kowa usaq ham. Naga diq ya idanin qwaysa ni ya a hi huz yagdaq? ham.  ");
INSERT INTO mlp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","An Filip bilam, Ni nigemabmo diq helmo haqeq teq ni tuhuzdaq ham. Haqan mat na amenin emim bilam, Ya helmo diq haqaiq ham. Yesus Krais in God atatin ham. ");
INSERT INTO mlp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Haqadmo in bilaqan wilka tuwasih. An Filip in mat na inaq yuwub hitiqim in mat na tuhuz ug. ");
INSERT INTO mlp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Huz ugim teq in giger yuw hulosad dubub tugwaliy. Gwalim tursa nan saw haiq Iyahta ago Bugaw in Filip waqim ad saw araqab tilah. Lehan mat ayahta na in Filip ahol a ta hi waqyaq. Admo in anad dimniysa tilah. ");
INSERT INTO mlp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ari Filip ame rireqim in anad tiqam, Ka ya uliq Asdot-ibmo tubol ham. Haqadmo in eraqim lehad saw nab uliq bunmo in on mataw Yesus awagamun dimunta gibilenim gibilenim tilehyaq. Lehad luwim abeb in le uliq Sisariya-ib tugwahtim. ");
INSERT INTO mlp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ari kam nab Sol agem meqniysa tibilaqyaq, On mataw Yesus anan Iyahta haqayta na giwazeq ginol emid moq bugiy haqyaq. Haqad in tamaz mat danmebta na ago hib tilah. ");
INSERT INTO mlp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Lehim bulonan mat ayahta na in sansandek asor mar tonim tuqug. Sol sansandek na giwazeq a leheq uliq Damaskus-ib mataw aseseqta Juda gigo bit humab wolayta giwamuzim osayta na amulik-mulikmo tinegdaq haqad. Teq sansandek nab in bilaqiy, Sol i gibinib luwaq haqiy. Mat aw nog dante muturta na muzinsa Sol in gibiyeq giwazeq giqirqureq giqad Jerusalem-ub tuboldaq haqiy. Mataw on inaqmo in tigiwazdaqta haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","An Sol sansandek na wazim uliq Damaskus-ib tilah. In lehad luwim sinsin tiqiysamo Heven-ib faq anuwan hikliyanim tiqim Sol amalib tuwol huram. ");
INSERT INTO mlp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Samo Sol ogib woqim usad in mat araq aqez kazaq bulonsa tuhurit. Sol, Sol ham. Nagaqgo ni ya imeqin tonaq? ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Haqan Sol bilam, Iyahta ham ni nog? ham. Haqan in bilam, Mat ni meqin tonaqta naqmo ham. Ya Yesus-mo ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ari ni eraqeq uliq kob le gwahtiq ham. Gwahtiqid mat araq teq ni ezaq tondaqta na ago tinibilendaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Haqsa mataw Sol inaq boliyta na giqez hiqiyimmo nab turiy. Turad in mat aqez huritiyta teq in mat na anon ahol a hi waqiy. ");
INSERT INTO mlp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sa Sol ogib usim eraqim turad in ame rireqim saw ahol waqad teq ame aromriq inaq iyyaq. Nazaq iyan mataw in abenab wazim ad le uliq Damaskus-ib tugwahtiqiy. ");
INSERT INTO mlp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Gwahtiqan Sol kam ezeqmanmo ame hiqiyim os. Osad in yuw didaq haiqmo osyaq. ");
INSERT INTO mlp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ari Juda mat araq disaipel iyta anan Ananayas haqayta na in uliq Damaskus-ib os. Osad in nagah araq sen qwayim ahol waqayta nazaq nogta ahol waqsa Iyahta in ameb gwahtiqim anan biyim bilam, Ananayas ham. Haqan Ananayas bilam, Iyahta ham ya kawa osaiq ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","An Iyahta bulon, Ni eraqeq dan anan Titnonta haqayta nab ni leh ham. Leheq Judas ago bitab ni mat araq uliq Tarsus-ibta anan Sol haqayta na anan susumun ham. In nawa God inaq gamuk emad osaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mat na sen qwayim in mat araq anan Ananayas haqayta bo gwahtiqim aben giger aholib emim wazsa in ame hastitayta na ahol tuwam ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Haqan ta Ananayas amenin emim bilam, Iyahta ham mat na in ningo on mataw tawonta uliq Jerusalem-ub osayta na gigo hib daq hihiq emad ayahmo gimeqin tonta ham. Mataw kabemmo nazaq bilaqsa ya huritta ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ad in mataw tamaz emayta gigo aseseqta na gigo hib zaway ayahmo waqim in uliq kab on mataw ni nihaqenib iyim ninan biyayta na giqirqurnan haqad bolta ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Haqan haiq. Iyahta kazaq bulon, Ni leh ham. Ya mat na ulumim waqan in yaqgo kabibiy mat tiqiy ham. In leheq on mataw en ta asor Juda a haiqta nagan teq maror aseseqta teq Isrel on mataw inaqmo gigo hib in ya inan tigibilendaq ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Teq in ya ibinib yaqgo kabiy emsa mataw santitiy teq afaqan kabemmo ug daqayta na ago ya tiqisihundaiq ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ari Ananayas eraqim tilah. Lehim bit aduganib gwahtiqim in Sol aholib aben emim wazad bulon, Imaqbab Sol ham, ni danib bolsa Iyahta Yesus ningo hib gwahtimta naqmo in ya iqeman bol ham. Ni nime hastitayid saw ahol waqsa teq God ago Bugaw Dimunta ni niholib ayahmo boldaq haqad in ya iqeman ya kawa tubol ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Haqanmo naqagag nabiq atiblalan nogta Sol ame isihim usta na muruwoqim tihitim. Hitiqanmo in ame anuwan tiqiyan in saw ahol tuwaqyaq. Ad in eraqim yuwub lehan Ananayas tuhuz ug. ");
INSERT INTO mlp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Huz ugan abeb Sol didaq waqim neqad in ahol awaz ta meqniy. Ari Sol kam asor disaipel nenaq uliq Damaskus-ib tuqos. ");
INSERT INTO mlp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Osad in Juda gigo bit humab wolaytab leheq Yesus awagamun tigibilenyaq. In bilaqyaq, Yesus in God atatin haqyaq. ");
INSERT INTO mlp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Haqsa mataw Sol ago gamuk huritiyta na bunmo gihol turuh nemsa bilaq yaqay, Mat ko uliq Jerusalem-ub on mataw Yesus anan helmo haqayta na gimeqin diq tonad luwyaqta haq yaqay. Ad in nazaqmo tonim in i gigo on mataw Yesus anan helmo haqayta na giqirqureq giqad mataw tamaz emayta gigo aseseqta na gimeb gwahtiqgo haqad in uliq kab boltamo haq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Teq haiq. Sol ago zaway ayah diqmo iysa in bilaqyaq, Mat i gilumsiheq ta giwaqdaqta amatin i anan Krais haqauqta na in Yesus-mo haqyaq. Haqsa uliq Damaskus-ib Juda mataw na in Sol ago gamuk amenin eman yo hiqiy yaqay. Sa Sol anad em hasad gamuk bilaqsa Juda mataw na in ago gamuk bayid woqgo ginadnad diq em yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ari kam kabemmo le tihiqiyan Juda mataw asor humab wolim osad in Sol wol emid moqgo an amugan tuwaziy. ");
INSERT INTO mlp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","An amugan wazan teq in gigo gamuk na Sol adekib tuwom. Sa Juda mataw na zeqab taromab inaqmo uliq adekib gel ayah nenanta turaqta na ago dan ez bunmo baynetim tur yaqay, Sol bo asanib gwahtiqsa i wazeq wol emid tumoqdaq haqad. ");
INSERT INTO mlp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sa tarom araqab Sol ago disaipel in Sol waqim ad gel abigmanib gwalehim teq in bulonan in kuram araq ayahta aduganib wo ossa in ago disaipel am emim siney tonim sorim hulosan kiskismo wolehanmo Sol uliq asan ban ogib hitiqim tituk. ");
INSERT INTO mlp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Abeb Sol le Jerusalem-ub tugwahtiqim osad in disaipel uliq nabta na nenaq wastoneq osgo emsa teq haiq. Disaipel bunmo in Sol disaipel iyta na anan helmo a hi haqad in Sol tirabun yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Rabunsa mat anan Barnabas haqayta na in Sol waqim ad Aposel gigo hib tilah. A lehim in Sol danib Iyahta ahol waqan Iyahta gamuk ugta na awagamun bunmo tigibilan bug. Teq Sol uliq Damaskus-ib Yesus ananib gamuk atoranmo bilaqyaqta na ago in gibilanmo. ");
INSERT INTO mlp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nazaq iyan Sol in Yesus ago on mataw na nenaq osad in anadibmo uliq Jerusalem aduganib leh bolad tiluwyaq. Luwad in a hi rabad in Iyahta abin bilaqgo awaz diq timeqniyyaq. ");
INSERT INTO mlp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Teq in Juda mataw Grik nan bilaqayta nagan nenaq nan bilaqad in nenaq an mugyaq. An mugsa mataw na in Sol wol emid moqgo adanteqin tinagun yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nagunsa Sol ayogniz in nagah na ago tuhuritim in Sol waqim ad uliq Sisariya-ib tuwolehiy. Wolehim in Sol eman uliq Tarsus-ib tilah. ");
INSERT INTO mlp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kam nab saw Judiya-ib teq saw Galiliy-ib teq saw Samariya-ib on mataw Yesus ago nan huritayta na in kam dimunta waqim anononmo tuqos yaqay. Ossa bab araq in gigo hib a hi gwahtiqsa in giwaz timeqniy yaqay. Giwaz meqniysa in Iyahta abin wazinad anad muz bugsa God ago Bugaw Dimunta in gigem zaway tinegyaq. Sa on mataw kabemmo bo in giduganib tugwahtiq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ari Pita uliq saw bunmo gigo hib lehad luwim in le uliq araq anan Lida haqaytab tugwahtim. Gwahtiqim in God ago on mataw tawonta na nenaq tuqosyaq. ");
INSERT INTO mlp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Osad uliq nab in mat araq anan Ainiyas haqayta ahol tuwam. Mat na abensen aditin bunmo moqan in ulig 8 nazaqmo banab usta. ");
INSERT INTO mlp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ari Pita in mat na ahol waqad tubulon, Ainiyas ham muran Yesus Krais niqeman nihol tidimniyaq ham. Ni eraqeq ningo us ban wastitay ham. Haqanmo mat na hidmo tiqeram. ");
INSERT INTO mlp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","An on mataw uliq Lida-ibta na teq uliq Saron-ibta na bunmo in Ainiyas ahol waqad in ginad buliyad Iyahta anan helmo tihaq yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ari uliq Jopa-ib aw araq anan Tabita haqayta in osyaq. Aw na in Yesus ago disaipel araq. Teq Grik nanib in anan Dorkas haqayta. In daq dimdimunta kabemmo emad teq in sirisirimo on mataw ginaghan haiqta nagan gilumsihyaqta. ");
INSERT INTO mlp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kam nab in moq waqimmo tumom. Moqan mataw in asan suholim a le bit adugan araq ulilibtab tiqemiy. ");
INSERT INTO mlp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Teq uliq Lida na in Jopa agerab sinsin usaqta. Nazaq iyan disaipel Jopa-ibta na in Pita uliq Lida-ib osaqta na abin huritim in mataw giger giqeman Pita ago hib lehim in kazaq buloniy, Ni hidmo i gigo hib bol haqiy. ");
INSERT INTO mlp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Haqan Pita eraqim mataw giger na nenaq tilah. In le uliq Jopa-ib tugwahtiqanmo mataw in waqim inaq bit adugan ulilibtab aw asan usaqta nab tugwalehiy. Gwalehan on waburta nagan in Pita agerab gaq wazad tur yaqay. Turad in tubusan amo amo Dorkas in nenaq osad gimen giqamta na in waq a bo Pita tiqisihun yaqay. ");
INSERT INTO mlp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Sa teq Pita on mataw bunmo gimuzan asanib tilehsa in abakbakan ulum laquwim turad God inaq gamuk tiqam. Gamuk emim hulosad in eraqim aw na asan nob ugim turad tubulon, Tabita ham ni eraq ham. Haqanmo aw na ame rireqim Pita ahol waqad in eraqim tuqos. ");
INSERT INTO mlp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ossa Pita aw na abenab wazim wazan in eraqim titur. Tursa Pita in God ago on mataw tawonta na gigo on waburta nenaq gililewunan bolan in gibilan, Ne giyow kayeq tiqiyim kawa turaqta ka ne ahol waqiy ham. ");
INSERT INTO mlp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","An uliq Jopa-ib on mataw bunmo daq na awagamun tuhuritiy. Huritim kabemmo in Iyahta anan helmo tihaqiy. ");
INSERT INTO mlp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Sa Pita kam asor uliq Jopa-ib mat araq inaq tuqos. Ma