﻿USE sofia;
DROP TABLE IF EXISTS sofia.mlh_vpl;
CREATE TABLE mlh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mlh_vpl WRITE;
INSERT INTO mlh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristore apa ŋaso yoŋore tina buru oi iŋi: Abrahamde osigida mo Deiwid. Deiwidre osigida mo Yesu. ");
INSERT INTO mlh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamde made Aisak. Aisakre made Jeikob. Jeikobre madepu Juda eru iŋore kakagbopu. ");
INSERT INTO mlh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judare madeyoka Peres eru Zera, maŋgoyakuŋ Tamar. Peresre made Hesron. Hesronde made Ram. ");
INSERT INTO mlh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramde made Aminadab. Aminadabre made Nason. Nasonde made Salmon. ");
INSERT INTO mlh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonde made Boas, maŋgoine kantri more ŋigo Rahab. Boasre made Obed, maŋgoine kantri more ŋigo Rut. Obedre made Jesi. ");
INSERT INTO mlh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesire made kiŋ Deiwid. Deiwidre made Solomon, maŋgoine rone Uriare ŋonuŋ goya. Juda kiŋ sosowo oi Deiwidre osigidapu fukeru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonde made Rehoboam. Rehoboamde made Abija. Abijare made Asa. ");
INSERT INTO mlh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asare made Jehosafat. Jehosafatre made Jehoram. Jehoramde made Usia. ");
INSERT INTO mlh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiare made Jotam. Jotamde made Ahas. Ahasre made Hezekia. ");
INSERT INTO mlh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiare made Manase. Manasere made Amon. Amonde made Josia. ");
INSERT INTO mlh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiare madepu Jekonia eru iŋore kakagbopu. Damaŋ oo Babilon yoŋoji Israel kufufuŋ oga yabebi Babilon raru witi pi gogo kamasi oŋuine kinaŋqoqoyaŋuŋ gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon witi pi gogo kamasi oŋuine goku oo Jekoniare made Sealtiel fukeya. Sealtielre made Jerubabel. ");
INSERT INTO mlh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerubabelre made Abiud. Abiudre made Eliakim. Eliakimde made Azor. ");
INSERT INTO mlh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azore made Jadok. Jadokre made Akim. Akimde made Eliud. ");
INSERT INTO mlh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudre made Eleasar. Eleasare made Matan. Matande made Jeikob. ");
INSERT INTO mlh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jeikobre made Josef, Mariare ŋoe. Mariaji Yesu roya. Tinaine Kristo Munaŋqoqo Rauine miegobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Damaŋ Abrahamdeone fuŋgaru go wapebi kiŋ Deiwid fukeya, mimiŋine yoŋore jare buru oi 14. Moke kiŋ Deiwidreone fuŋgaru go wapebi Israel kufufuŋ oga yabebi Babilon raru witi pi gogo kamasi oŋuine gobuŋ, mimiŋine yoŋore jare buru oi oŋuakoŋ 14. Babilon witi pi gogo kamasi oŋuine gobuŋ, damaŋ oo akoŋ fuŋgaru go wapebi Kristo fukeya, mimiŋine yoŋore jare buru oi oŋuakoŋ 14. ");
INSERT INTO mlh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kristo fukeya ore sundu oi iŋi: Iŋore maŋgo Maria iŋo Josefre biŋe goku so qodureru gobire damaŋ oo Moro Tiriineji qowirie teko kuake goko fuŋine oŋu bofukebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Oŋu bofukebi ŋi biŋeine Josef iŋoji gogo poretiŋ goya ore Mariare fuŋneji totogo fukeko mimiineke fukeiŋ ore takigaya. Oŋu takigame maŋineji oi sumuŋgaru bokeiŋgo mamane buruine ruaya. ");
INSERT INTO mlh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Oŋu manesuku eko Ofonde mimerereŋ moji kubaŋgo fuke teru iŋi ojiya, “Josef Deiwidre osigida, Moro Tiriineji Maria qowirie teko kuaineke goga. Ore eru go oi ogagaru pigoo wareru ŋonuŋgo fukeinde kokoi so maneigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariaji koko made roiŋ. Ŋi iŋoji kufufuŋine agiburaŋyaŋuŋgone munaŋ qa yareko posikenimiŋ. Ore eru goji tinaine Yesu miigoŋ.” Oŋu ojiya. ");
INSERT INTO mlh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ofonji kajeqouŋ ŋi mo boburogame buŋo mo miya, oiji foriineke fukeiŋgo ore ya sosowo oi fukeya. Kajeqouŋ buŋo oi iŋi, ");
INSERT INTO mlh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ŋigo jeŋoŋ jumuine moji kuake eru made mo rome tinaine Imanuel minimiŋ.” Tina ore fuŋine oi iŋi, “Anutuji noŋuŋke goga.” ");
INSERT INTO mlh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josefji maŋine gboreme pakereru Ofonde mimererenji mitiga teko, ore so eku Maria ŋonuŋine fukeiŋ ore ogagaru piineo rabu. ");
INSERT INTO mlh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Raru gobuyoŋ, damaŋ botuineo oo moko so pebire raru madeine rome Josefji tinaine Yesu miya. Made roko iŋore ŋadio ŋoe ŋonuŋ gobu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesuji ŋi koito Herod iŋore damaŋgo Judia prowinsre taoŋ mo tinaine Betlehem oo fukeya. Fukeya, damaŋ oo bobunde mamane ŋi wegi wawapeineone Jerusalem sitio warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wareru iŋi weubuŋ, “Juda ŋoŋore ŋi koito fukeiŋ, made oi fukeru uro pega? Niŋo wegi wawapeineo goku iŋore ginja fukeme ŋoneru fuŋine oŋu maneru ohoweine baku miteŋ gakimiŋ ore waregobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Oŋu weubi ŋi koito Herod eru Jerusalem kufufuŋ iŋoke gobuŋ, yoŋo sosowo buŋo oi maneru popurebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Popurebi kiŋ Herodji buŋo ruaru kufufunde soriŋ gio siŋaŋ qoruine eru Kadi buŋore qaqaji sosowo kepore yabeme warebuŋ. Wareru tumaŋgabi iŋi weu yareya, “Munaŋqoqo Rauine Kristoji uro fukeiŋgo mibi pega?” ");
INSERT INTO mlh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Weu yareme iŋi bokirie tebuŋ, “Iŋoji Judia prowinsre taoŋ tinaine Betlehem oo fukeiŋ. Ore buŋo oi kajeqouŋ ŋi Maikaji iŋi quraŋgame pega, ");
INSERT INTO mlh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O Betlehem kufufuŋ Juda moreŋgo gogobi, ŋoŋore botugone koito sogo fukeru nakene Israel kufufuŋ botiŋgaru siŋaŋ nobeiŋ. Ore eru ŋoŋo Juda morende minebobo yoŋore botugo gobi tinabiŋeŋaŋunji wakiqoqoine so yobu fukeiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Oŋu bokirie tebi maŋgboroŋ ŋi oi kamiine oŋga yareme warebi iŋi weu yareya, “Ginja oi wamo damaŋgo fukeme fuŋgaru ŋonebuŋ?” Ore fuŋine poretiŋ maneiŋgo maneru oŋu weu yareya. ");
INSERT INTO mlh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ore buŋo maneru sore yaberu iŋi mitiga yareya, “Ŋoŋo Betlehem raru made oi poretiŋ weuku bofukeru oo akoŋ biŋe buŋo ruabi nondeo wareiŋ. Nonji oi maneru oŋuakoŋ raru iŋo ohowe baku miteŋ gabemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kiŋ koitoji oŋu eadu eku mitiga yareko maneru kadio rabuŋ. Raru ginja wegi wawapeineo goku ŋonebuŋ, oiji qoruyaŋuŋgo bonieru rako boyoberu Betlehem raru pi koko made peya, oo dimaya. ");
INSERT INTO mlh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ginja oi dimako ŋoneru jeribari soguine yobu manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jeribari maneru pi maŋineo roperu made eru maŋgoine Maria ŋone yapebuŋ. Oi ŋone yaperu dikanji keru daberu ohowe baku miteŋ gabuŋ. Miteŋ garu kopu kekereyaŋuŋ basiru oone goul, jinaŋ paora eru toki tinaine mor oi uduru yauŋ otebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ubu mo pebi Anutuji kubaŋgo fukeru kiŋ Herodreo moke so ranimiŋ ore qomuku yareya. Ore eru kadi mogo yoŋoyaŋunde kae moreŋyaŋuŋgo kirieru rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Maŋgboroŋ ŋi yoŋoji rabi Josefji kubaŋ ŋoneko Ofonde mimerereŋ moji fuke teru iŋi ojiya, “Herodji made qame komeiŋgo ore baaiŋ. Ore eru bio pakereru made eru maŋgoine oga yaperu sumuŋgaru Ijipt moreŋgo raniŋ. Oo raru gobi jiki nonji wareniminde damaŋ mibemiŋ, oo kirieru wareinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Oŋu ojime pakereru ubu oo akoŋ koko made eru maŋgoine oga yaperu Ijipt rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ijipt raru gobi kiŋ Herodji komeko damaŋ oo akoŋ kirieru warebuŋ. Rone Ofonji kajeqouŋ ŋi Hosea boburogame buŋo iŋi miya pega, “Nonji madene oŋga tebe Ijipt moreŋ bokeru wareya.” Kajeqouŋ buŋo oiji oŋu fukeko foriineke fukeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Maŋgboroŋ ŋi yoŋoji Juda moreŋ kamiine bokeru rabi Herodji ore fuŋine ŋoneru “Eadu nubuŋ,” miku maŋine kokoine rigaŋgame mimiti iŋi ruaya, “Mamari ŋi, ŋoŋo Betlehem eru moreŋ sosowo oi roregaru pega, oo raru made gosayaŋuŋ yoyoka eru ore yukuineo fukegobi, yoŋo sosowo yabebi komenimiŋ.” Maŋgboroŋ ŋi ginja fukeya ore damaŋine ore poretiŋ weu yareme ojibuŋ, ore so made gosayaŋunde mimiti oi ruaya. ");
INSERT INTO mlh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kajeqouŋ ŋi Jeremaiaji buŋo mo miya pega, oiji oŋu fukeko foriineke fukeya. Buŋo oi iŋi, ");
INSERT INTO mlh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Betlehem bembeŋgo kae mo tinaine Rama oone ku oyowoyaŋuŋ manebi oŋga jojoraku soguŋ soguine bagobi. Reizel ŋigore osigidapu yoŋoji osigidapuyaŋuŋ mataebi kuyobi. Ore eru kuyobi bobomiriŋ eyareiŋgo ebi maŋmoki akoŋ maneegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josefji Ijipt gokame kiŋ Herodji komeko oo akoŋ Ofonde mimerereŋ moji kubaŋgo fuke teru ");
INSERT INTO mlh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","iŋi ojiya, “Made qabi komeiŋ ore rubabuŋ, yoŋoji kome forebuŋ. Ore eru pakereru made maŋgoineke oga yaperu kirieru Israel moreŋgo rainebi.” ");
INSERT INTO mlh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Oŋu ojime Josefji pakereru made maŋgoineke oga yaperu kirieru Israel moreŋgo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kadio raru buŋo iŋi maneya, “Herod iŋore made Arkelaus iŋoji mamainere tifeo Judia prowins siŋaŋ yaberu goga.” Oŋu maneru oo rainde kokoi maneya. Maneru gome Anutuji kubaŋgo Galili prowinsgo raniminde mitiga teme pakereru oo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galili prowinsgo roperu taoŋ tinaine Nazaret oo gobuŋ. Oŋu gobi kajeqouŋ ŋi yoŋoji Munaŋqoqo Rauinere buŋo mibuŋ, oiji foriineke fukeya. Buŋo oi iŋi, “Iŋore tina oi Nazaret ŋi miku gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gosa goine tariko Jon Mitimeso ŋiji wareru Judia prowinsre moreŋ buroineo roregaru ŋiŋigo maŋyaŋuŋ Biŋe buŋoji bapakareru iŋi yajiru goya, ");
INSERT INTO mlh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Sombuŋ Rauineji qorumaŋine ruainde damanji wareru fukega. Ore eru ŋoŋo maŋ-ŋaŋuŋ kerisieru oo ropeniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jonde kajeqouŋ ŋi Aisaiaji buŋo mo iŋi miku quraŋgaya, “Kiŋaŋ mimerereŋ moji moreŋ buroineo oŋgaku gome raru buŋo fonuŋine iŋi manenimiŋ, ‘Ofonji warei-iiŋ! Ore eru bio jaueru kadiine bataniŋgainebi. Ŋoŋo maŋ-ŋaŋuŋ botiŋgaru kadiine reuinebi.’” ");
INSERT INTO mlh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jonde sakikomoŋ oi kamel sikiineji bakine eru botuineo bifuŋ joma sakiineji bakine oi kiperu goya. Uqoine oi putogisi burugisi eru gomende moruŋ obu. Oi sosowo kajeqouŋ ŋi Elaija iŋore so. ");
INSERT INTO mlh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jonji gioine bako ŋiŋigo kubu sogo yoŋoji Jerusalem siti eru Judia prowinsre moreŋ goine sosowo yoŋoreone iŋoreo kekogaru warebuŋ. Oŋuakoŋ Jordan obu mobemobe moreŋ sosowo pe rabuŋ, oone warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wareru waperu agiburaŋyaŋuŋ mifukebi Jonji oi Jordan obu rendaineo miti meso rau yareya. ");
INSERT INTO mlh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Rau yareyayoŋ, Farisi (Kadi buŋore yameŋyameŋ) eru Sadusi (Soriŋ giore yameŋyameŋ) ŋiŋigo kubu sogo yoŋoji miti meso rau yareiŋ ore warebi ŋone yaberu iŋi yajiya, “O qoti kobende osigidapu, ŋoŋo maŋ-ŋaŋuŋ so kerisiebi Anuture manji rigaŋgame geoine bokirie ŋareiŋgo ega. Oi sumuŋganiminde uŋsowoŋ buŋo oi moji ŋajime sombuŋaŋuŋ maneru yo waregobi? ");
INSERT INTO mlh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ore eru fofori maŋ-ŋaŋuŋ kerisieniŋ. Sembeneŋaŋuŋ bokeru maŋ-ŋaŋuŋ kerisiebi foriine fukeko oi eeboboŋaŋunji totogo yaduru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Maŋ-ŋaŋunji gbegbedi buŋo iŋi miiŋgo so manesuinebi, ‘Niŋoji Abrahamde osigida gobeneŋ Anutuji so sibiri nobeiŋ.’ Oŋu miku omoŋaŋuŋgo qaegobiyoŋ, foriine oi so fukeega. Nonji ore eru iŋi ŋajibemiŋ, Anutuji ko yo soine mitiga yareko qowirieru Abrahamde osigidapu fukeru Anutu miteŋ gaenimiŋyoŋ, ŋoŋo uruŋu? ");
INSERT INTO mlh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Maŋ-ŋaŋuŋ so kerisienimiŋ ine, Anutuji ŋoŋo yo oŋuine keti ŋabeme wakiiŋgo egobi. Yo sosowo foriyaŋuŋ fiine so fukeegobi, oi ketigame wakibi misigo bokeme rakanimiŋ. Yo oŋuine ketigainde ome oi miine jomuru yo fuŋineo ruame jaueru pega. Anutuji sembeneŋaŋunde geo bokirie ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nonji ŋoŋo maŋ-ŋaŋuŋ kerisienimiŋ ore obu omaineji rau ŋaregoyoŋ, nonde ŋadio ŋi sanaŋ qaŋqaŋine mo wareiŋ. Iŋore usuŋ soguine oi nonde odureiŋ. Iŋoji ŋi ropekiine fukeiŋ ore nonji iŋore kufu komoŋ bapi garu kekereo nikeru rubeiŋgo embimbiŋgabemiŋ. Iŋoji Moro Tiriine maŋ-ŋaŋuŋgo ruame jo boruŋineji keririke ŋabeku oo miti meso oŋuine rau ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Iŋoji foriine eru yauine boroiŋ yapeinde sara roru waperu pioru ketikieru osoeiŋ. Osoeru wit koruŋ roru qojugaru rouŋineo ruaiŋyoŋ, yau rasaine oi ofaŋgako misigo rakaru misi tatariine tomiri oo jaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Damaŋ oo Yesuji Galili prowins bokeru Jordan obu rendaineo Jondeo wareru miti meso rau teiŋgo weu teya. ");
INSERT INTO mlh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Weu teyayoŋ, Jonji qomuku teku iŋi ojiya, “Goji soine noŋ miti meso rau narenoŋyoŋ, goji agiburaŋ so eru uruŋu eru nondeo warege?” ");
INSERT INTO mlh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Oŋu ojime Yesuji iŋi bokirieya, “Damaŋ yoo oi soine eigoŋ. Oŋu egobere, oo Anutuji eebobo poretiŋ boyobekiminde buŋo miya, ore foriine fukeko sagaiŋ.” Oŋu bokirieme Jonji maneme sagako maŋmoakoŋ eya. ");
INSERT INTO mlh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Maŋmoakoŋ eru miti meso rau teme tariko oo akoŋ obuone wapeme iŋi fukeya: Qonikinji aŋgame Yesuji piku ŋoneme Anuture Moro Tiriineji kerisieru kabu webo oŋuine fukeru Yesure qorugo wakiya. ");
INSERT INTO mlh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Waki roko Sombuŋgone maru mo iŋi fukeya, “Iŋoji nakene yoro made fukega ore eru beune fiame ŋoneru aŋiine manego.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ore ŋadiineo Moro Tiriineji Yesu bapakareru soreme moreŋ buroineo Sembene Rauineji esoigaiŋgo ore eru raya. ");
INSERT INTO mlh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Oo raru ubu una 40 Anuture eru uqo sowo gogu uqore komeya. ");
INSERT INTO mlh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Uqore komeko gemokaku qoruyaŋuŋ tinaine Eesoi Rauine iŋoji fukeru iŋi ojiya, “Go Anuture Made fukege ine, go usuŋgo naduru ko yo mitigande qowirieru poroŋ fukeme noigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Oŋu ojiyayoŋ, Yesuji buŋo iŋi bokirieya, “Mata! Biŋe Quraŋgo buŋo mo iŋi quraŋgabi pega, ‘Uqoji akoŋ ŋiŋigo gogo so noreegayoŋ, Anuture mione buŋo wareega, oi sosowo reŋgabeneŋ oiji gume nobeko sanaŋgaru gokimiŋ’.” ");
INSERT INTO mlh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Oŋu ojime Sembene Rauineji Yesu ogagaru Jerusalem siti tiriine oo raru boji sorinde bubuo paibe roperu ruame dimaya. ");
INSERT INTO mlh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Oŋu dimako iŋi ojiya, “Go Anuture Made fukege ine, bio yoone tariru yuku rakaigoŋ. Biŋe Quraŋgo buŋo mo iŋi quraŋgabi pega, ‘Anutuji gore eru mimerereŋpuine mitiga yareko soine romaiŋga gubi rakaru koji kufugo so keku sibiri guiŋ.’ Ore eru soine rakaru so sibiri guiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Oŋu ojime iŋi bokirieya, “Mata! Biŋe Quraŋgo buŋo mo oŋuakoŋ iŋi pega, ‘Go Ofoŋ Anutugo so esoigaigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Oŋu bokirieme Sembene Rauineji moke ogagaru tuku ropekiine yobu mogo roperu moreŋ sosowo yoŋore kantri jokoroŋine jokoroŋine eru yoŋore mebo konu yayaŋuŋ qembibiyaŋuŋke sosowo oduya. ");
INSERT INTO mlh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Oduru iŋi ojiya, “Goji dikanji kenareru ohowene baku miteŋ numiŋ ine, nonji yareya sosowo yo mitari garebe raugaru siŋaŋ yabemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Oŋu ojime Yesuji iŋi bokirieya, “Mata! Satan go bio use. Biŋe Quraŋgo buŋo mo iŋi quraŋgabi pega, ‘Go Ofoŋ Anutugo, iŋo moakoŋ dikanji keteru ohowe baku miteŋ gaigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Oŋu bokirieme Sembene Rauineji oo akoŋ Yesu bokeru useya. Oŋu fukeko mimerereŋ yoŋo wareru Yesu bapi gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ore ŋadiineo Jon Mitimeso ŋi witi pigo ruabi ŋeko Yesuji oi maneru Judia prowins bokeru Galili raya. ");
INSERT INTO mlh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Raku prowins oo roperu kaeine Nazaret bokeru Kaperneam raru goya. Kaperneam taoŋ oi Zebulun eru Naftali moreŋgo Galili obu joguŋ keririŋineo pega. ");
INSERT INTO mlh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Oo goku gioine bako Anutuji buŋo mo kajeqouŋ ŋi Aisaia boburogame miya, oiji foriineke fukeya. Buŋo oi iŋi, ");
INSERT INTO mlh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ŋiŋigo Zebulun eru Naftali moreŋgo Jordan mobeineo gobi botuyaŋuŋgo kadi soguine koe oobe raru dimaga, oi Juda tomiriyoŋ, kubu goineji Galili prowinsgo gobuŋ, ");
INSERT INTO mlh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","kufufuŋ yoŋoji qisirigo goku tatama soguine ŋonenimiŋ. Komeji ŋiŋigo oi sabare yabeme qisiri moreŋgo gobuŋ, yoŋoreo kaere wegi jiriŋ qosoiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesuji Kaperneam goku damaŋ oo akoŋ fuŋgaru Biŋe buŋo mitaniŋgaru ŋiŋigo maŋyaŋuŋ bapakareru iŋi miku goya, “Sombuŋ Rauineji qorumaŋine ruainde damaŋ oi ware fukega. Ore eru ŋoŋo agiburaŋ gogoŋaŋuŋ bokeru maŋ-ŋaŋuŋ kerisieinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Oŋu miku roregaru goku Galili obu joguŋ keririŋineo boyoberu raru kakagbo yoyoka Saimon tinaine mo Pita eru gboine Andru ŋone yapeya. Yokoji jembaeŋ fufuru ŋi goku simemeŋyakuŋ obu joguŋgo jembaeŋ porenimi ore bokeru gobu. ");
INSERT INTO mlh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesuji ŋone yaperu iŋi yasiya, “Ŋiyoka, ŋoko noŋ boyobe nuru warebire qaji ŋatebe ŋiŋigo jembaeŋ oŋuine pore yabenimi.” ");
INSERT INTO mlh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Oŋu yasime oo akoŋ simemeŋyakuŋ bokeru fuŋgaru Yesu boyoberu rabu. ");
INSERT INTO mlh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesuji yokoke kokiine mo jikigaru raru moke kakagbo yoyoka Zebedire madeyoka Jeims eru Jon ŋone yapeya. Yokoji mamayakuŋ Zebedike ogâo ŋeku simemeŋyaŋuŋ bobiaŋgaru kipeku gokabi ŋone yaberu oŋga yateya. ");
INSERT INTO mlh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Oŋu ŋone yaberu oŋga yateme oo akoŋ pakereru ogâ eru mamayakuŋ bokeru fuŋgaru Yesu boyoberu ŋadiineo rabu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuji raru Galili prowins maŋineo kae sosowo roregaru oŋgawowosi piyaŋuŋgo roperu qorumande Bobiaŋ Biŋe mitaniŋgaru maŋyaŋuŋ bapakareru qaji yareru goya. Oŋu eru botuyaŋuŋgo ŋiŋigo jibe eru jibekatikati fuŋne fuŋne eyareme gobuŋ, yoŋo bobiaŋ yaberu goya. ");
INSERT INTO mlh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Oŋu baku gome Yesure Biŋeji saueru Siria kantri maŋineo sagaru raya. Oŋu rako oi maneru jibe ŋiŋigo sosowo oga yaperu iŋoreo warebuŋ. Goineji jibe wi eru jibekatikati fuŋne fuŋne eyareme gobuŋ. Goineji gemokakuji maŋyaŋuŋgo rakame biriqepoŋ me bapeboriŋke gobuŋ. Goineji rondiŋgaru wakiru yabeko yoyowo baku isiŋbiriŋ qaku gobuŋ. Goineji sakiyaŋunde mobe komekiine gobuŋ. Oŋuine oŋuine yoŋoji Yesureo warebi bobiaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oŋu eyareme ŋonebuŋ ore ŋiŋigo kufufuŋ sogo yoŋo Yesure ŋadio boyoberu warebuŋ. Kubu sogo oi Galili prowins eru Ten-taoŋ distrikgone warebuŋ. Kubu goineji Jerusalem siti eru Judia prowinsre moreŋ goineone warebuŋ. Kubu goineji Jordan obu mobeone warebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesuji ŋiŋigo kubu yasogo ŋone yaberu tukuo roperu ŋeko kiŋariŋpuineji waperu roregabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Roregabi fuŋgaru ŋiŋigo kubuine kubuine qaji yareru iŋi miya: ");
INSERT INTO mlh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Uri yoŋoji yoŋoyaŋunde maneru Anuture jiŋoo wakiqoqoine gogobi, yoŋoji Sombunde qorumaŋ oi rauganimiŋ ore kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Uri yoŋoji jiŋgeŋ keku kuyogobi, Anutuji yoŋo bomiriŋ yabeiŋ ore kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Uri yoŋoji denaŋdenaŋ boyobeegobi, Anutuji moreŋ yo oi yoŋore biŋe qa yareiŋ ore kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Uri yoŋoji Anuture jiŋoo posikekiminde yameŋ keku oi uqo obure kokome oŋu komeru qapeqawaki eku gogobi, Anutuji aŋiyaŋuŋ oi gume yabeiŋ. Ore eru yoŋoji kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Uri yoŋoji goine ŋonemaiŋ eyareegobi, Anutuji yoŋo ŋonemaiŋ eyareiŋ ore yoŋoji kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Uri yoŋore maŋyaŋunji gbagbataeŋine fukega, yoŋoji soine Anutu ŋonenimiŋ. Ore eru yoŋoji kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Uri yoŋo womo eegobi, yoŋore tina oi Anuture odumadepu minimiŋ. Ore eru yoŋoji kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Anutuji buŋoyaŋuŋ mitarime posikegobi ore eru kekesuesue eyareegobi, yoŋoji Sombunde qorumaŋ oi biŋe ganimiŋ. Ore eru yoŋoji kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ŋiŋigoji ŋoŋo nonde eru maŋqoqo buŋo fofoine miŋareru kekesuesue eku buŋo sembene fuŋne fuŋne sakiŋaŋuŋgo ruaku iko eegobi, ŋoŋoji kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","“Maneniŋ, Anutuji furiŋaŋuŋ ropekiine Sombuŋ kaeo ruame pega ore bio kokoriaŋ keru jeribari paio goinebi. Oi iŋi ore migo: Kajeqouŋ ŋiŋigo rone gobuŋ, oi kekesuesue kamasi oŋuine akoŋ eyarebi ŋoŋoji yoŋore ŋadiyaŋuŋgo fukeru yoŋoke sogokoŋ gogobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesuji miya, “Ŋoŋo moreŋ ŋiŋigo yoŋore seki kamasi fukegobiyoŋ, seki aŋiine tomiri fukeiŋ ine, oi uruŋu bobiaŋgabeneŋ moke aŋiineke fukena? Ore fuŋine mo mata. Jikigaru ya mo ruabeneŋ so sagaiŋyoŋ, oi yau oŋuine bokebi rakame ŋiŋigoji oi kufuyaŋunji odepereganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ŋoŋo moreŋine moreŋine yoŋore doi oŋuine fukeru gogobi. Siti mo tukuo roperu babuŋ ŋega, oo soŋsoŋgo ŋeiŋgo embimbiŋgaega. ");
INSERT INTO mlh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Moji doi qureru dero rurumaŋgo so ruaiŋyoŋ, doire ŋeŋeo ruame ŋeiŋ. Oŋu ŋeku tamaeko ŋiŋigo pi maŋineo ŋegobi, sosowo yoŋo jiŋo piku tatama ŋoneenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","“Oŋuakoŋ ŋoŋore tatama yadubi ŋiŋigo botuyaŋuŋgo tamaeko ŋoneegobi. Ŋiŋigoji eeboboŋaŋuŋ fiine ŋoneru ore eru Mamaŋaŋuŋ Sombuŋ kaeo goga, oi miteŋ garu gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nonji Mosesre Kadi buŋo eru kajeqouŋ ŋiŋigo yoŋore Biŋe Quraŋ oi kepiebemiŋ ore eru so wareru gogo. Oŋu kosa so manesuinebi. Nonji kepiebemiŋ ore matayoŋ, buŋo oi reŋga forebe ore foriineji damaŋ so fukeiŋ ore eru wareru gogo. ");
INSERT INTO mlh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ, Mosesre Kadi buŋoo quraŋ mendaine yobu mo me kirifi ququrande sipa moakoŋ oi so yobu mataeiŋyoŋ, buŋo sosowo oi rone foriineke fukeme Sombuŋ moreŋ yokoji niniŋganimi. ");
INSERT INTO mlh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Ore eru moji Kadi buŋore mimiti mendaine oone buŋo mo ketaru ŋiŋigo oŋu qaji yareega, iŋoji Sombunde qorumaŋgo ropeme tinaine mendainemeŋ minimiŋ. Oŋu oŋganimiŋyoŋ, moji oi reŋgaru boyoberu ŋiŋigo oŋu qaji yareega, iŋoji Sombunde qorumaŋ maŋgo ropeme tinaine Sogunenoŋuŋ minimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Nonji ore so iŋi ŋajibe maneniŋ: Ŋoŋore eebobo posiine oiji Kadi buŋore qaqaji eru Farisi (Kadi buŋore yameŋyameŋ) yoŋore mosi oŋuine sogokoŋ egu fukeiŋ. Mosiyaŋunji yoŋore mosi oi kokoine so odureiŋ ine, ŋoŋoji Sombunde qorumaŋ maŋgo so ropenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesuji jikigaru miya, “Ŋoŋoji ronekoŋ buŋo mo iŋi ŋajiku gobuŋ, ‘Ŋiŋigo mo so qabi komeine,’ eru ‘Moji rosiine qame komeiŋ, oi distrikre buŋo korogo ruabi buŋoine mitarinimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Oŋu ŋajiku gobuŋyoŋ, nonji buŋo oi iŋi mitaniŋgabe maneniŋ: Moji ogoineke kekepari eru maŋine rigaŋgame kakane rosi ega, iŋo oŋuakoŋ distrikre buŋo korogo ruabi buŋoine mitarinimiŋ ore so fukega. Oŋuakoŋ moji ogoine mipemiriŋ buŋoji misembearu ‘Go biriine maŋgo tomiri fukege,’ miga, iŋo kantrire soriŋ kaunsol yoŋore jiŋo maio ruabi buŋoine mitarinimiŋ ore so fukega. Moji ogoine buŋo simbiŋineji misembearu ‘Go jukuwigoke fukege,’ miga, iŋoji misi korugo rakaiŋ ore so fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ore eru goji yauŋ pesiŋgo roru wareru alatao ruaiŋgo ege oo buŋo yo iŋiineji mamanegoo wapena: Ogogore maŋgo buŋo peko iŋoji rosi egareiŋgo manega. Buŋo oŋuine manesumiŋ ine, ");
INSERT INTO mlh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yauŋgo oi bio koro alata yukuineo ruaru rone ogogoreo raru iŋoke buŋoŋakuŋ miposikeru maŋmoakoŋ eru ore ŋadio moke wareru yauŋ pesiŋgo Anuture ruaigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Rosigoji sakigoo ruaku buŋo koroineo pore guiŋgo eme komitireo raru kadi yasogoo oo yameŋ keku maŋmoakoŋ eru buŋoŋakuŋ miposikenimi. Oŋu so enimi ine, rosigoji soine furu guko (jas, majistreit) mimitari rauinere jiŋo maio ropende maneru miko kambantire meo rande witi pigo egu rua guiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Go oo tifego sosowo ruamiŋ ore so quŋgaru ŋemiŋ. Toiyago tatariine oŋuakoŋ rua foreru tifego ruaku wakimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Buŋo mo iŋi ŋajiku gobuŋ, ‘Boesau so eigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Oŋu yajibu gobuŋyoŋ, nonji buŋo oi iŋi mitaniŋgabe maneniŋ: Moji saure aŋi sanaŋinere paio ŋigo piku ŋonega, iŋoji maŋineo iŋoke boesau ega. ");
INSERT INTO mlh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Jiŋo furogoji agiburaŋ baiŋ ore suruyoiŋ egareiŋ ine, oi unugaru bokende raine. Saki mobego moji sibirigame oŋuineji Sombuŋgo ropende sagaiŋyoŋ, saki fugo jumuineke gokande igogabi misi korugo rakaru egu sibirigamiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Me furogoji agiburaŋ baiŋ ore suruyoiŋ egareiŋ ine, oi ketigaru bokende raine. Saki mobego moji sibirigame Sombuŋgo ropende sagaiŋyoŋ, saki fugo jumuineke goku misi korugo rakaru egu sibirigamiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Buŋo mo iŋi mibi pega, ‘Moji ŋonuŋine bokeiŋ, iŋoji bobokere papia quraŋgaru ŋonuŋine oteiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Oŋu mibi pegayoŋ, nonji iŋi ŋajibe maneniŋ: Moji ŋonuŋine jikiboti eko bokenayoŋ, fuŋine more ŋonuŋine bokeiŋ, oŋuine oo ŋonuŋineji jikiboti eiŋ ore kesosoeru agiburande buŋoke fukena. Oŋu fukeko ŋi moke roko ŋi gariine oiji oŋuakoŋ jikiboti eiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Buŋo mo oi oŋuakoŋ ronekoŋ iŋi ŋajiku gobuŋ, ‘Buŋoŋaŋuŋ mimipaŋ buŋoji misanaŋgabuŋ, oi so odureinebi. Ofonde ya ekiminde buŋo mimipaŋ buŋoji mikipebuŋ, oi boyobebi foriineke fukeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“Oŋu ŋajiku gobuŋyoŋ, nonji buŋo oi iŋi mitaniŋgabe maneniŋ: Buŋoŋaŋuŋ mimipaŋ buŋoji so yobu misanaŋgainebi. Sombuŋ oi Anuture morumboŋ ŋeŋe fukega ore eru buŋo iŋi so miinebi, ‘Buŋo foriine so mibemiŋ ine, Sombuŋ Rauineji soine geoine bokirieme paineo ropeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Moreŋ oi Anuture kufure koji fukega ore eru buŋo iŋi so miinebi, ‘Buŋo foriine so mibemiŋ ine, morenji soine kefa nuine.’ Jerusalem oi Kiŋ Tiriinere siti fukega ore eru buŋo yo oŋuine oi oŋuakoŋ so miinebi, ‘Buŋo foriine so mibemiŋ ine, Kiŋ Soguine iŋoji soine qaqosoriinere geo bokirieme paineo ropeine.’ ");
INSERT INTO mlh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Go qoru sikigo gogobu bande yagaŋine fukeiŋgo embimbiŋgamiŋ eru qoru sikigo yagaŋine bande gogobu fukeiŋgo embimbiŋgamiŋ. Ore eru buŋo iŋi so miigoŋ, ‘Buŋo foriine so mibemiŋ ine, Anutuji soine qorunere siki yoweji eme qopieiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mimipaŋ buŋo so miinebiyoŋ, oŋ-buŋore ‘Oŋ!’ miinebi eru mata ore ‘Mata!’ miinebi. Buŋo poretiŋ oiji buŋo ya jigiganimiŋ, oi Sembene Rauineji boburo ŋabeko fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Buŋo mo iŋi ŋajiku gobuŋ, ‘Moji jiŋogo igokobeiŋ, go geoine bokirieru iŋore jiŋo igokobeigoŋ. Moji migo qomuruŋgaiŋ, go geoine bokirieru iŋore miqomuruŋgaigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","“Oŋu ŋajiku gobuŋyoŋ, nonji buŋo oi iŋi mitaniŋgabe maneniŋ: Moji sembene eŋareiŋ, oi so qomukuru kiso eteinebi. Oŋu matayoŋ, maugo forego qotiŋbeiŋ ine, maugo mobeine oŋuakoŋ qotiŋbeiŋ ore kerisieigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Moji ‘Sakikomoŋgo robemiŋ,’ miku buŋo korogo rua guiŋgo manega ine, oi bokeru marikugo paiine oŋuakoŋ otende raugaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","“Oŋuakoŋ moji kekereine kilomita moakonde so deru ramiŋ ore bapakare gareiŋ ine, go soine reŋgaru kilomita yoyokare so deru iŋoke raigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Moji gore ya more weu gareiŋ, oi oteigoŋ. Moji ‘Ya narende mobeine jiki bokiriebemiŋ,’ miku weu gareiŋ, oi so ŋadi gaigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Buŋo mo iŋi ŋajiku gobuŋ, ‘Ŋiŋigo maŋfuŋ-ŋaŋuŋgo goku ogopuŋaŋuŋ fukegobi, oi manji jojoko eyareeinebiyoŋ, rosipuŋaŋuŋ kerisieru rosi eyareku goinebi.’ ");
INSERT INTO mlh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","“Oŋu ŋajiku gobuŋyoŋ, nonji buŋo oi iŋi mitaniŋgabe maneniŋ: Ŋoŋo rosipuŋaŋuŋ manji jojoko eyareru dimaku kekesuesue eŋareegobi, yoŋore eru oŋga wosiru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Oŋu eenimiŋ ine, oŋuine oo Mamaŋaŋuŋ Sombuŋ kaeo goga, iŋore fuŋne yaduru odumadepuine fukeru gonimiŋ. Iŋore fuŋne oi iŋi: Iŋoji wegiine so sabereme waperu ŋiŋigo fiine eru sembene oŋuakoŋ batamae yabeega eru kue ruame ŋiŋigo poretiŋ eru kekesiine yoŋore uqo gio oŋuakoŋ bogunu baega. ");
INSERT INTO mlh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Ŋoŋoji narende garebe kamasiine odureru Anuture fuŋne naduŋgaduŋ eeinebi. Takis eaduyaŋuŋke robi misombeŋ-ŋaŋuŋ baegobi, yoŋoji ogopuyaŋunji manjoko eyarebi oi kerisieru manji jojoko eyareegobi. Oi maŋkekerisiere mosi mata. Ŋoŋo yoŋore mosi oŋuakoŋ boyoberu eenimiŋ ine, Anuture tife mo so fukeko iŋoji mosiŋaŋunde tife so ŋareme furi mo so rauganimiŋ. Ore eru ŋiŋigo sosowo manji jojoko eyareru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“Maŋkekerisiere yaura ŋiŋigoji oŋuakoŋ botuyaŋuŋgo mijeriyaŋuŋ mi nareŋgareŋ eku gogobiyoŋ, oi maŋkekerisiere moge mata. Ŋoŋo yoŋore so ogopuŋaŋuŋ ŋoŋore botugone mijeriŋaŋuŋ mi nareŋgareŋ eenimiŋ ine, oo yaura ŋiŋigo oŋuine fukegobi. Yaura ŋiŋigo yoŋore mosi odureru fiine yobu fukeru goinebi? ");
INSERT INTO mlh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ŋoŋore Sombuŋ Mamaŋaŋunji kuriri yobu fukega, ŋoŋoji ore so kuriri yobuyaŋuŋke fukeru goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesuji iŋi qaji yareya, “Ŋoŋo iŋi ore sisiŋaŋ eru goinebi: Eeboboŋaŋuŋ posiine poretiŋ oi ŋiŋigoji ŋoneru ŋoŋore manekabi ropeiŋ ore eru so eku goinebi. Oŋu eenimiŋ ine, ŋoŋore Mama Sombuŋgo goga, iŋoji mosiŋaŋunde tife so ŋareme furi so biŋe ganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ore eru ‘Basiqasi ŋiŋigo yauŋ yabebemiŋ,’ miku oi tumoqoqoo oguŋ qeŋke puteru kiŋaŋ enimiŋ ore so eigoŋ. Maŋkekerisiere ŋiŋigo sasakiine yoŋo ŋiŋigoji borope ŋabeniminde maneru oŋgawowosi pigo eru kadi yasogoo raru ŋiŋigo ŋone yaberu oŋu eegobi. Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ, Yoŋoji mosiyaŋunde furi sosowo biŋe qaku ro forebi Sombuŋ Rauineji oi so jikigaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Goji oŋu so eigoŋyoŋ, ‘Basiqasi ŋiŋigo yauŋ yabebemiŋ,’ miku me furogoji uruŋu ega, oi me kijogoji so maneine. ");
INSERT INTO mlh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yauŋgo oiji soŋsoŋgo peko Mamagoji eebobo soŋsoŋine ŋoneega, iŋoji go furigo gareiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ore eru Anuture oŋga wosinimiŋ, oi maŋkekerisiere ŋiŋigo sasakiine yoŋore so, so einebi. Yoŋo ŋiŋigoji ŋone yabenimiŋgo maneru aŋiyaŋuŋgo oŋgawowosi pigo eru kadi sosokogo dimaku oŋga wosiegobi. Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ. Yoŋoji mosiyaŋunde furi sosowo biŋe qaku ro forebi Sombuŋ Rauineji oi so jikigaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Goji oŋu so eigoŋyoŋ, ‘Anuture oŋga wosibemiŋ,’ miku gogakunde pi maŋine mendaineo roperu mendi keku Mamago soŋsoŋgo goga, iŋo oŋga wosi eteigoŋ. Oŋu ende Mamagoji eebobo soŋsoŋine ŋoneega, iŋoji go furigo gareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Oŋga wosinimiŋ, oo maŋkekerisiere yaura ŋiŋigo yoŋore kamasi ore so buŋo mitomi oi so miku goinebi. Yoŋoji mibuŋo boakoŋ mibi Anutuji ore eru kaje ruaru mane yareiŋgo manesuegobi. ");
INSERT INTO mlh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ŋoŋo iŋi ore yoŋore so, so fukeru goinebi: Ŋoŋo wamo yare embimbiŋgaru basiqasi egobi, Mamaŋaŋunji oi so oŋga wosibi ronekoŋ mane foreega. ");
INSERT INTO mlh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ŋoŋo iŋi oŋga wosieinebi: Niŋore Mama, go Sombuŋgo goge. Gore tina tiriine peine. ");
INSERT INTO mlh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","“Go siŋaŋ nobende qorumaŋgore fori fukeine. Gore maŋ aŋi Sombuŋgo reŋgaegobi, ore so moreŋgo oŋuakoŋ fukeine. ");
INSERT INTO mlh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","“Muŋambere uqonoŋuŋ oi sonoŋuŋgo noreigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","“Goine yoŋore tife niŋoreo pega, niŋo oi boke yaregobeneŋ ine, go ore so niŋore tife jure noreigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","“Eesoigo egu waki nobeiŋ ore sabare noberu Sembene Rauinere meone bomuku nobeigoŋ. (Go gake qorumaŋ Rauine, usuŋ Rauine eru kuririquraŋ Rauine oi damaŋine damaŋine go waperu gomeŋ eru tatariine tomiri go ropemiŋ. Oi foriine.) ");
INSERT INTO mlh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ŋoŋo ŋiŋigo yoŋore agiburaŋ bokenimiŋ ine, Sombuŋ Mamaŋaŋunji oŋuakoŋ ŋoŋore agiburaŋ bokeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bokeiŋyoŋ, ŋiŋigo yoŋore agiburaŋ so bokenimiŋ ine, Mamaŋaŋunji oŋuakoŋ ŋoŋore agiburaŋ oi so bokeiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Uqo sowo gonimiŋ, oo maŋkekerisiere ŋiŋigo sasakiine oŋu mamaguine so eru goinebi. Yoŋoji Anuture uqo sowo goegobi, ŋiŋigoji oi ŋonenimiŋ ore eru tataki eru jiŋo maiyaŋunji kuyobekuyobe fukeega. Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ, Yoŋoji mosiyaŋunde furi sosowo biŋe qaku ro forebi Sombuŋ Rauineji oi so jikigaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Goji oŋu so eigoŋyoŋ, Anuture uqore sowo goku oo tinogunji me saifeji jiŋo maigo jureru qoru sikigo qaku goigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Oŋu eru uqore sowo gokande ŋiŋigoji matayoŋ, Mamago soŋsoŋgo goga, iŋoji oi ŋoneiŋ. Oŋu ende Mamagoji eebobo soŋsoŋine ŋoneega, iŋoji go furigo gareiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Moneŋ mebo ya oi moreŋgo pe ŋareiŋ ore so ro qojugainebi. Oŋu ro qojugakabi oo wofu kakaraji oi kitikabi gugu kufeŋ bosembeako suroŋqoqo yoŋoji pi qajaŋgaru roperu kiaŋ roegobi. ");
INSERT INTO mlh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","“Moreŋgo matayoŋ, Anuture maŋ aŋi reŋgabi tinabiŋeŋaŋunji sogueiŋ ore yameŋ keeinebi. Oŋu ebi juŋe boreŋ-ŋaŋuŋ fuŋine mo oi Sombuŋ kaeo peko wofu qujajanji so kitikabi gugu kufenji so bosembeanimiŋ. Suroŋqoqo yoŋoji paibe roperu pi qajaŋgaru ya kiaŋ so ronimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yare kuririine roru manende ropega, oiji pi mogo peko goji maŋgo oŋuakoŋ oo qakatoru gomiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Gore jiŋoji oi maŋ sakigore doi ega. Ore eru jibe moji jiŋogo so bosembeaga ine, oiji pinde tamae foreko Anuture tatamaji soine maŋgoo ba tamaeko gogogo sosowo tatamago gomiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","“Tatamago gomiŋyoŋ, aŋi sanaŋine sembeneji me ya moji jiŋogo bosembearu tatama sakogaga ine, oiji sakire gogogo sosowo oŋuakoŋ bokobeko qisiri maŋineo tiŋtuŋ gomiŋ. Oŋu fukeko qisiriji maŋgore tatama sakogako kobega ine, gogakere qisiriji ‘Yei!’ bibitatariineke fukega. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Moji siŋaŋ yoyoka kiŋaŋ qa yateiŋgo embimbiŋgaega. Moji oŋu eiŋgo manega, iŋoji mo rosi eteru mo manji jojoko eteiŋ. Moreo qakatoru mo mipemiriŋ eteiŋ. Ore eru yoŋoji Anutu eru moneŋ mebo oi qodureru kiŋaŋ qa yateiŋgo embimbiŋganimiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Oŋu fukeko nonji iŋi ŋajibe maneniŋ: Ŋoŋo moreŋgo goniminde manebu oi iŋi miku so maneinebi, ‘Niŋo wamo ya gugume enobeŋ eru wamo yaji sakinoŋuŋ komoŋ ganobeŋ?’ Mojiŋaŋuŋke gogobi, oiji ya foriine fukeko uqoji ore wawakiine fukega. Sakiŋaŋuŋke gogobi, oiji ya foriine fukeko kambaŋ sokiji ore wawakiine fukega. Ŋoŋo oi manesuinebi. ");
INSERT INTO mlh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Sowoo webo yoŋo ŋone yabeinebi. Yoŋoji uqo koruŋ so qopogaru tieegobi. Kurumbu foriine oi so ketigaru rouŋ piyaŋuŋgo so ro qojugaegobi. Oi mata yobu eme ŋoŋore Sombuŋ Mamaŋaŋunji jibu oi gume yabeega. Ŋoŋo webo yoŋore so matayoŋ, ŋoŋore furiji webo furiyaŋuŋ yadureru ropekiine fukega me mata? Ŋoŋo oi manesuku goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Ŋoŋoreone moji manebu eru oŋuine oo moreŋgo goinde damaŋ oi una moakonde so bojoroiŋ me mata? Oi mata yobu! ");
INSERT INTO mlh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kambaŋ sokiŋaŋunde ŋoŋo uruŋu manebu egobi? Oi so sagaga. Kae jiŋore juŋ jariŋ iruine sogueegobi, oi piku ŋone yabeniŋ. Yoŋoji kambaŋ sokiyaŋunde saka so yomueegobi eru gio goine so baegobi. ");
INSERT INTO mlh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","“Oi jibu nonji iŋi ŋajibe maneniŋ, Kiŋ Solomonji goul silwaine qojugaru bugeqonikiŋke goyayoŋ, iŋore marikuine oi saka firindua me iru more so ŋoneaŋike so fukeya. ");
INSERT INTO mlh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kae jiŋore juŋ jariŋ iruine sowo muŋambe maŋfuŋnoŋuŋgo peko yogo ketebi wakiko ro qodureru bokeru rigabi jaiŋyoŋ, oi jibu Anutuji oi fiine akoŋ basarigaega. Ore eru iŋoji ŋoŋo oŋuakoŋ soine komoŋ ŋabeiŋ. Ŋoŋoji juŋ jariŋ iruinere so mata. Anutuji maŋgo eŋareiŋgo maneru ore eru aŋiine ropekiine maneega. O ŋiŋigo, mamanesiŋ-ŋaŋunji wamore omaine yobu mendaine fukega? ");
INSERT INTO mlh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Oŋu fukeko ŋoŋo gogoŋaŋunde manebu eru manetiqoti so maneru goinebi. Oi maneru yobiŋgaru iŋi egu minimiŋ, ‘Niŋo wamo uqo obu nonobeŋ?’ eru ‘Wamo yaji sakinoŋuŋ komoŋ ganobeŋ?’ ");
INSERT INTO mlh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","“Oi iŋi ore: Maŋkekerisiere yauraine yoŋo ya sosowo oi raugakimiŋgo yameŋ keku manjo maneegobi. Ŋoŋoji ya kokoinere basiqasi eku quŋgaegobi, ŋoŋore Sombuŋ Mamaŋaŋunji oi mane forega. ");
INSERT INTO mlh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ore manjo so maneinebiyoŋ, rone Anuture qorumaŋgo roperu iŋore jiŋoo posikekimiŋgo yameŋ keeinebi. Maŋ-ŋaŋuŋ oo ruabi peko iŋoji siŋaŋ ŋaberu ya oŋuine sosowo oi oŋuakoŋ ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Oŋu eru ŋoŋo yogo goniminde manebu oi so eru goinebi. Yogore manemeja oi yogore. Una moakoŋ moakonde manebuyaŋuŋ bubu osigabi soŋaŋuŋgo fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesuji jikigaru iŋi yajiya, “Anutuji buŋoŋaŋuŋ osoeru mitarime egu wakinimiŋ ore goine yoŋore buŋo oi so osoeru mitariinebi. ");
INSERT INTO mlh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ore fuŋine oi iŋi: Ŋoŋoji goine yoŋore buŋo osoeru mitarinimiŋ, Anutuji kiriri oŋuineji akoŋ ŋoŋo-ŋaŋunde buŋo osoeru mitariiŋ. Ŋoŋoji goine yoŋore mimiti eba eku roperu wakiru osoe yareegobi, Anutuji ore so ŋoŋo-ŋaŋe eŋareme rope wakienimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Go ogogore jiŋoo go mendaine ŋonegeyoŋ, gakere jiŋoo yo diŋiŋine soguine pega, oi wamore so ŋone mukuge? ");
INSERT INTO mlh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Me uruŋu eru afagaru ogogo iŋi ojige, ‘Ogone mane, noŋ soine jiŋogoone go kepiabe wakiiŋ?’ Oŋu afagaru migeyoŋ, yo diŋiŋine soguine oi gogakere jiŋoo pega. ");
INSERT INTO mlh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","“O go maŋkekerisiere sasaki ŋi, go rone gakere jiŋoone yo diŋiŋine soguine roru bokeigoŋ. Oi roru bokeru poretiŋ ŋone mukuru ogogore jiŋoone go mendaine oi soine kepiende wakiiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yare manebi tiriine gbagbataiŋine fukega, oi qoro so yareinebi. Juŋe gopiŋ qoqoine oi kaneŋ maŋfuŋyaŋuŋgo so bokebi raine. Oŋu enimiŋ ine, yoŋoji oi kufuyaŋunji ode udu yaberu moke kerisieru ŋoŋo-ŋaŋe kiŋaberu kitiqoti egu eŋarenimiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ŋoŋo Anutu oŋga wosieinebi. Oŋga wosibi osoeru ya ŋareiŋ. Ŋoŋo ya Anuture jambae baku baaeinebi. Oi baabi ŋaduko ya bofukenimiŋ. Ŋoŋo dimaku mendigo keeinebi. Kebi mendi ro ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Moji Anutu oŋga wosiega, Anutuji iŋore mobe bokirieme biŋe gaiŋ. Yare baaega, iŋoji ya bofukeiŋ. Mendigo keega ore iŋo mendi ro teiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Maneniŋ, ŋiŋigo ŋoŋoreone moji iŋi ena: Madeineji bisketre weuko ko oteiŋ? ");
INSERT INTO mlh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Me madeineji jembaende weuko qoti oteiŋ? ");
INSERT INTO mlh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","“Oŋu fukeko ŋoŋo ŋiŋigo sembene fukeru jibu yauŋ fiine fiine odumadepuŋaŋuŋ yarekimiŋ ore so fukegobi ine, ŋoŋore Mama Sombuŋ kaeo goga, iŋoji yauŋine uruŋu sabarena? Iŋore mande eebobo oi nodureru fuŋine mo fukega. Ore eru ŋoŋo ya oroinere oŋga wosiru weu tenimiŋ ine, iŋoji aŋiinere oi ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ore eru ŋiŋigoji ŋoŋo ya sosowo eŋareniminde maneegobi, ore so oi oŋuakoŋ eyareeinebi. Oŋu ebi Mosesre Kadi buŋo eru kajeqouŋ ŋiŋigo yoŋore Biŋe Quraŋ buŋo oiji foriineke fukeko qoqodure fuŋineji totogo fukeiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Misi korugo rakakiminde kadi oi afaine eru mendiine oi yasogo. Ŋiŋigo boakonji mendi oi petigaru kadi oo boyobegaru ranimiŋ. Ore eru ŋoŋo sa mendi kokiine petigaru ore maŋineo rainebi. ");
INSERT INTO mlh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","“Gogo sanaŋineo roropere fuŋine oi goŋgoŋine embiŋqombiŋineke eru mendiine oi kokiine. Ŋiŋigo afaineji mendi oi bofukenimiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kajeqouŋ ŋiŋigo qaqajibuine yoŋo lamare saki komoŋ keru ŋoŋoreo wareegobiyoŋ, maŋyaŋunji qoro rigaŋine ore so gogobi. Ore eru ŋoŋo yoŋore eru ruŋaŋuŋ baru sisiŋaŋ eru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gioyaŋunde foriine ŋonebi fuŋneyaŋuŋ ŋaduko soine mane mukunimiŋ. Yojuŋ foriine oi fandoŋgo fukeega me mata? Waroŋ foriine oi fobuo fukeko ro qojugaegobeneŋ me mata? Mata! ");
INSERT INTO mlh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","“Ore so yo fiine sosowo yoŋo foriyaŋuŋ fiine fukeegayoŋ, yo sembeneji foriyaŋuŋ sembene fukeega. ");
INSERT INTO mlh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yo fiineji foriine sembene fukeiŋgo embimbiŋgaega eru yo sembeneji foriine fiine fukeiŋgo embimbiŋgaega. ");
INSERT INTO mlh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","“Yo sosowo foriine fiine so fukeegobi, oi siŋaŋineji ketigaru roru misigo bokeme rakanimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ore so ŋiŋigo yoŋore giore fori ŋonebi fuŋneyaŋuŋ ŋaduko soine mane mukunimiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nonde Sombuŋ mamanere maŋ aŋi reŋgaega, iŋoji iŋore qorumaŋgo ropeiŋ. Kokoine yoŋoji nonde ‘Ofoŋ, Ofoŋ!’ omaine oŋgaku miegobiyoŋ, sosowo yoŋoji Sombunde qorumaŋgo so ropenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Mimitarire damaŋ yasogo oo kokoine yoŋoji wareru noŋ iŋi najinimiŋ, ‘O Ofoŋ Ofoŋ, niŋoji gore tina miku ya fukeinde kajeqouŋ buŋo ronekoŋ miku gobeŋ. Niŋo gore tinare usunji gemoine gemoine yobe yaberu gobeŋ. Gore tinaji maŋgo enoreko mosi qoqowirie usuŋ suŋsuŋyaŋuŋke kokoine eku gobeŋ. Oi niga guga me?’ ");
INSERT INTO mlh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Oŋu najibi damaŋ oo fuŋneyaŋuŋ totogo iŋi yajibe manenimiŋ, ‘Nonji damaŋ mogo ŋoŋo so mane ŋabebe. Ŋiŋigo jaubaŋaŋuŋke, ŋoŋo bio boke nuru useniŋ.’ Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Oŋu fukega ore uri yoŋo nonde buŋo mine migo, oi maneru ore so reŋga eegobi, nonji sosowo yoŋore fuŋneyaŋuŋ ŋaduru mamane-muku ŋire so keru iŋi mibemiŋ: Iŋoji piine ko oŋgiŋ paiineo baya. ");
INSERT INTO mlh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oŋu bako kueyoiko damaŋgo kue misogo keseru wakime obu riŋako gbiŋ sogo qame obu yoiko soguine pakereru pi dobuineo igogayayoŋ, pi oi ko oŋgiŋ paiineo bame dimaya ore eru so bajiya. ");
INSERT INTO mlh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Uri yoŋoji nonde buŋo mine migo, oi maneru ore so oŋu so reŋga eegobi, nonji sosowo yoŋore fuŋne ŋaduru ŋi mutuinere so keru iŋi mibemiŋ: Iŋoji piine mageŋ paio baya. ");
INSERT INTO mlh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Oŋu bako kueyoiko damaŋgo kue misogo keseru wakime obu riŋako gbiŋ sogo qame obu yoiko soguine pakereru pi dobuineo igogame ŋeririkeru wakiya.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuji buŋo oi miforeko ŋiŋigo kubuine kubuine yoŋoji manebi qaji yareya, kamasi ore popureru waragabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Iŋoji yoŋore Kadi buŋore qaqajipuyaŋunde kamasi so qaji yareyayoŋ, usuŋ Rauine fukega ore so ŋiŋigo qaji yareme maneru kamasi ore waragabi meayaŋuŋ tariya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuji tuku oi bokeru wakiko kufufuŋ kubu sogo yasogoji ŋadiineo boyobebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Oŋu warekabi oo ŋi wakoineke moji wareru dikanji keru Yesure beufuŋineo rakaru iŋi ojiya, “O Ofoŋ, goji aŋigore bobiaŋ nuiŋgo manege ine, noŋ soine bofosike nuigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Oŋu ojime meine bofeŋgaru sakiine bouaku ojiya, “Nonji oi eiŋgo manego. Go bio posikeigoŋ.” Oŋu ojime wakoine oi oo akoŋ posikeko fiine fukeya. ");
INSERT INTO mlh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Posikeme iŋi mitiga teya, “Mane, yoore biŋe buŋo oi mo so minde maneinebi. Matayoŋ, soriŋ gio siŋandeo raru sakigo oduigoŋ eru Mosesre mimiti boyoberu posikege ore daŋge pesiŋ ruaru boji rigaigoŋ. Oi rigande ŋoneku ŋiŋigoji fuŋnego mane mukunimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesuji Kaperneam taoŋgo wapeko Rom mamari siŋaŋ moji iŋoreo wareru oŋga wosiru iŋi ojiya, ");
INSERT INTO mlh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“O Ofoŋ, nonde gio ŋire saki mobeineji komeine fukeko joiserereŋ mokiine maneru pigo pega.” ");
INSERT INTO mlh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Oŋu ojime iŋi mime maneya, “Nonji raru iŋo bobiaŋgabemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Oi maneru iŋi bokirieru ojiya, “O Ofoŋ, noŋ oŋunemeŋ gobe nonde pigo waremiŋ ore mimine manego. Ore eru buŋo migoji akoŋ minde kiŋaŋ ŋineji fiaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“Oi iŋi ore: Noŋ nake oŋuakoŋ siŋaŋnere usuŋ rurumaŋgo rua nubi gogo. Nonde rurumaŋgo mamari ŋi gobi yoŋo mitiga yareego. Yoŋoreone more ‘Raigoŋ,’ mitigabe iŋoji raiŋ. More ‘Wareigoŋ,’ mitigabe iŋoji wareiŋ eru kiŋaŋ ŋine more ‘Gio yo baigoŋ,’ mibe iŋoji oi baiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuji buŋo oi maneru waragaru ŋiŋigo boyoberu warebuŋ, yoŋoreo kerisieru iŋi yajiya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Israel kufufuŋ botuyaŋuŋgo oŋuakoŋ mamanesiŋ soguine oŋuine oi more maŋgo so bofukebe. ");
INSERT INTO mlh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Nonji buŋo iŋi ŋajibe maneniŋ: Ŋiŋigo kubu sogo sogoji wegi wawapeineone eru wegi rarakaineone wareru Sombunde qorumaŋ maŋgo waperu Abraham, Aisak eru Jeikob yoŋoke uqo munjaŋ noku jeribari eku gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yoŋo oŋu gonimiŋyoŋ, qorumande odumade oi boke yaberu igo yabebi qisirigo sakibe rakanimiŋ. Oo gonimiŋ, yoŋoji kuyo jojoraru ŋiraŋyaŋuŋ kibi qako gonimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Oŋu yajiru mamari siŋaŋ iŋi ojiya, “Go pigoo raigoŋ. Mamanesiŋgore foriji fuke gareine.” Oŋu ojime kiŋaŋ ŋiineji aua oo akoŋ fiaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuji Pitare pigo raru Pitare safanji sakijo jibe bame peko ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Oi ŋoneru meineji yoŋoko sakijoine bokeme pakereru fuŋgaru Yesu uqo rigaru gumeya. ");
INSERT INTO mlh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Oŋu gobi kae ubu eko oo ŋiŋigoji ogopuyaŋuŋ gemoyaŋuŋke oi kokoine oga yaperu iŋoreo warebuŋ. Warebi gemo oi buŋoineji miyobe yabeko waperu rabuŋ eru jibe ŋiŋigo sosowo oi bobiaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Oŋu eme Anutuji buŋoine kajeqouŋ ŋi Aisaiare maŋgo ruame mime pega, oiji foriineke fukeya. Buŋo oi iŋi, “Iŋoji noŋunde jibe winoŋuŋ rome paiineo ropeko osigaya.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu ŋiŋigo kubu sogoji oruŋgabi ŋone yaberu damaŋ oo kiŋariŋpuine yoŋoke obu joguŋ petigaru aribe ropekiminde mitigaya. ");
INSERT INTO mlh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kadi buŋore qaqaji moji Yesureo wareru iŋi ojiya, “Qaqaji, go uro uro ramiŋ, nonji oo go boyobe guru warebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Oi maneru Yesuji iŋi ojiya, “Gomende qoro yoŋoji ko kouŋyaŋuŋgo pebi sowo webo yoŋoji saraŋyaŋuŋgo goegobiyoŋ, Sombuŋ eru morende Ŋi foriineji uro raru qoruine wamo roŋguŋgo qaku roegaru ŋema nena?” ");
INSERT INTO mlh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Oŋu ojime kiŋariŋ yoŋoreone moji iŋi ojiya, “Oi soineyoŋ, mamaneji komeiŋgo ega ore minde rone raru siŋaŋ gabe komeko yaŋgabe tariko warebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Oŋu miyayoŋ, Yesuji bokirieru ojiya, “Oi boke, komiine yoŋoji qoŋgbuŋyaŋuŋ komekiine oi soine yaŋganimiŋyoŋ, goji bio wareru boyobe nuigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuji raru ogâ maŋineo ropeko kiŋariŋpuine yoŋo boyoberu iŋoke moko rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Rakabi siritemboŋ sogoji ututuŋ obu joguŋgo fukeru bokeya. Bokeko siriji ogâ maŋineo rakaru puseiŋgo eyayoŋ, Yesuji kubaŋ peya. ");
INSERT INTO mlh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kubaŋ peko kiŋariŋpuine yoŋo raru wiwigaku ojibuŋ, “Hei Ofoŋ, bio bapi nobe. Niŋo joguŋgo sibirigaiŋgo egobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Oŋu ojibi bokirieru iŋi yajiya, “O ŋoŋo mamanesiŋyaŋuŋ mendaine, wamore kokoi mamane ŋi fukegobi?” Oŋu yajiru pakereru gbiŋ eru siri mitiga yateme siriji benoŋgaya. ");
INSERT INTO mlh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Oŋu fukeme waragaku weweu eku mibuŋ, “Yei, mamagore sia! Ŋi yo wamo ŋi goga? Iŋoji gbiŋ eru koe mitiga yateme miine reŋgabu.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Oŋu fukeme obu joguŋ petigaru aribe Gadara yoŋore moreŋgo ropeya. Oo roperu ŋi gemoyakuŋke yoyoka yokoji jiŋoruŋgone wareru Yesu bofukebu. Yokoji maŋjibu ŋi manjoyakuŋke fukebire sosowoji kadi oo raiŋgo embimbiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yokoji Yesu bofukeru jojoraku iŋi oŋga jorabu, “Ae! Go Anuture Made fukege. Go uruŋu enoreiŋgo warege? Joiserereŋ mamane damaŋineji so ware fukeko ronekoŋ oi joineke enoremiŋ ore yo warege me?” ");
INSERT INTO mlh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Oo akoŋ jorigo matayoŋ, maŋfuŋyaŋuŋgo oo kaneŋ kubu soguine mo kegbaŋ maŋineo qojugaru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ore eru gemo yoŋoji iŋi miku Yesu karieru weu tebuŋ, “Goji niŋo yobe nobemiŋ ine, bio sore nobende soine kaneŋ kubu yoŋore maŋgo rakakimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Karieru weu tebi Yesuji “Bio raru rakaniŋ,” miku mitiga yareya. Oŋu mitiga yareme oo akoŋ ŋi maŋyakuŋgone waperu raru kaneŋ maŋyaŋuŋgo rakabuŋ. Rakabi kaneŋ kubu jumuine yoŋoji riŋaru pagaŋineo (aboŋineo) raru sururueru obu joguŋgo rakaru noru kome forebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kome forebi kaneŋ siŋaŋ yoŋoji perorieru kamieru taoŋgo raru buŋo biŋeyaŋuŋ sosowo mibuŋ. Ŋi gemoyakuŋke yokoreo ya fukeya, ore biŋeine oŋuakoŋ yajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yajibi maneru taoŋ ŋiŋigo jiŋoguru yoŋoji bokeru Yesu bofukeru ŋoneiŋgo warebuŋ. Wareru ŋoneru Yesuji yoŋore qoqodure sa moreŋ bokeru raiŋgo karie tebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesuji ogâ maŋineo roperu moke obu joguŋ petigaru aribe roperu iŋoyoŋunde taoŋgo raya. ");
INSERT INTO mlh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Damaŋ oo ŋi goineji ogoyaŋuŋ saki mobeine komekiine ramegaripepego peya, oi reŋgo ruaru koboru warebuŋ. Oŋu wareru Anutu manesiŋ gabuŋ, Yesuji yoŋore kamasi ŋoneme sagako jibe ŋi oi iŋi ojiya, “Madene, nonji gore agiburaŋ bokego. Ore eru go sanaŋgaru kobigake jogbake goigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Oŋu ojime Kadi buŋore qaqaji goineji dimaku maŋyaŋuŋgo iŋi manesubuŋ, “Ŋi iŋoji Anutu igosisi etega.” ");
INSERT INTO mlh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Oŋu manesubuŋyoŋ, Yesuji mamanesuyaŋuŋ oi mane mukuru iŋi yajiya, “Ŋoŋo wamore buŋo sembene maŋyaŋuŋgo manesugobi? ");
INSERT INTO mlh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nonji ‘Agiburaŋgo bokego,’ migo, buŋo oi afaine akoŋ mimiine. Moji oŋu miko goineji buŋo ore foriine so ŋonenimiŋ. Ore eru buŋo oi afainere so. Nonji buŋo mo iŋi ojibemiŋgo manego, ‘Go pakereru ra.’ Buŋo oi yobiŋineke mimiine fukega. Oŋu mibe foriine fukeiŋ me mata, oi totogo fukeko ŋonenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“Maneniŋ, moreŋgo agiburaŋ bobokere usuŋ oi Sombuŋ eru morende Ŋi foriinere pega, ŋoŋo ore fuŋinere tiŋtuŋ egu gonimiŋ. Ore eru buŋo yobiŋineke oi ŋi yo ojibe foriine ŋoneniŋ.” Oŋu miku ŋi saki mobeine komekiinere jiŋoo ŋoneru ojiya, “Go pakereru ramegaripepego roru pigoo ra. Buŋo yobiŋine oi foriineke fukeiŋ ine, buŋo afaine oi oŋuakoŋ uruŋu omaine fukena?” ");
INSERT INTO mlh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Oŋu ojime oo akoŋ pakereru piineo raya. ");
INSERT INTO mlh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Oŋu fukeme ŋiŋigo kubu yoŋoji oi ŋoneru waragaru Anutu miteŋ gabuŋ. Moreŋ ŋire usuŋ oŋuine oteya ore Anutu miteŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuji oo akoŋ raru takis ofis odureiŋgo eko oo ŋi tinaine Matyu ŋeko ŋoneru ojiya, “Go nonde ŋadineo ware.” Oŋu ojime pakereru takis gio bokeru Yesure ŋadio raya. ");
INSERT INTO mlh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Raru Matyure pigo raru uqo noku ŋebuŋ, damaŋ oo takis roro ŋi eaduyaŋuŋke eru agiburaŋ ŋi kokoineji wareru Yesu eru iŋore kiŋariŋpu yoŋoke ŋeku uqo moko nobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Oŋu nobi Farisi (Kadi buŋore yameŋyameŋ) yoŋoji oi ŋoneru Yesure kiŋariŋpu iŋi miyarebuŋ, “Ae! Ŋoŋore qaqajiji wamore takis roro eaduyaŋuŋke eru agiburaŋ ŋiŋigo yoŋoke ŋeku uqo noga? Oi so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Oŋu miyarebi Yesuji mobeine iŋi yajiya, “Ŋiŋigo jibeyaŋuŋ tomiri yoŋoji doktare aŋi so maneegobiyoŋ, jibe ŋiŋigoji doktareo raegobi. ");
INSERT INTO mlh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nonji agiburaŋ ŋiŋigo oŋga yareiŋgo ore wareru gogoyoŋ, ŋiŋigo yoŋoyaŋunde manebi posiine fukegobi, oi mata. Ore eru buŋo yoore fuŋne raru qaqaji eku maneniŋ, ‘Nonji boji riganimiŋ ore matayoŋ, ŋonemaiŋ naduŋgaduŋ eiŋ ore aŋi manego.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Damaŋ oo Jon Mitimeso ŋire kiŋariŋpu yoŋoji Yesureo wareru iŋi weubuŋ, “Niŋoji eru Farisi (Kadi buŋore yameŋyameŋ) yoŋoji Anuture uqo sowo kokoine goegobeneŋ. Gakere kiŋariŋpuji wamore uqo sowo so gogobi?” ");
INSERT INTO mlh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Oŋu weubi iŋi bokirieya, “Fofori, niŋo wamo damaŋgo uqo sowo goegobeneŋ? Ŋigo bobo damaŋineo ŋire wijepuji boreŋine ruabi ŋigore daritifepuji ya oi useegobi me mata? Nonji nakene kiŋariŋpu yoŋore ŋi biŋe fukeru yoŋore botugo aŋibaŋi ŋeego. Ŋebe yoŋoji ore eru aŋibaŋi jerieru ŋeku uqo sowo gonimiŋgo embimbiŋgaegobi. Embimbiŋgaegobiyoŋ, Anutuji gogone ogagako komebe yoŋoji damaŋ oo soine uqo sowo goenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“(Ŋoŋo gogo raŋgbaŋine eru jeri Biŋe gariine oi qodure yapenimiŋgo embimbiŋganimiŋ. Ore buŋo ŋadiine mo iŋi ŋajibemiŋ:) Ninike raŋgbaŋine pougame moji kambaŋ gariine so jujureine ketigaru oo kambaŋ mobeine so ruaru gbodueega. Kambaŋ mobeine gariine oŋuineji mujugaru ninike raŋgbaŋine furugame moke tiŋame kimbonji sogueme egu sembeqombeaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Oŋuakoŋ moji wain obu gariine oi jua me toru raŋgbaŋine lama sakiineji babaine oo so piome rakaega. Oŋu ruana ine, wain obu gariineji sogueru toru kesuqosugaru kesieko moreŋgo wakiru jibugame toruineji egu sembeqambeanimiŋ. Ore eru wain obu gariine oi toru gariineo akoŋ kesiebeneŋ rakame sagaiŋ. Oŋu ebeneŋ yokoji fiine fukegobire. (Oŋuakoŋ obu fiine oi kiniŋ raŋgbaŋineo so pioegobeneŋ. Oŋu pionobeŋ ine, oiji pougaru sisororo wakiko noku jibe egu ba nobeiŋ. Oŋu egu fukeiŋgo ore obu fiine oi kiniŋ fiineo pioegobeneŋ. Ŋoŋo oŋuakoŋ gogo raŋgbaŋine eru Bobiaŋ Biŋe gariine oi qodure yapenimiŋgo embimbiŋganimiŋ.) Oŋu.” ");
INSERT INTO mlh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuji buŋo oi yajime buŋo siŋaŋ moji waperu Yesure maŋfuŋgo raru dikanji keru iŋi oŋga wosi teya, “Nonde odu muŋambe yo komegayoŋ, go wareru megoji sakiineo yoŋonde gboreru jikigaru goiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Oŋga wosi teme pakereru kiŋariŋpuine yoŋoke iŋo boyoberu rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Rabi damaŋ oo botuyaŋuŋgo ŋigo mo goya. Iŋoji kaindari gosa 12:re so ŋoneku jibe bame goya. Ŋigo oiji Yesure ŋadio wareru marikuinere tife sisi bouaya. ");
INSERT INTO mlh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Oi bouaru iŋoyoŋunde iŋi miya, “Nonji iŋo bouaiŋgo maneru yobiŋgaru marikuine akoŋ kokiine mo yoŋonobo ine, noŋ soine fiabemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Oŋu miku bouako Yesuji oo akoŋ kerisieru iŋo ŋoneru iŋi ojiya, “Odune, mamanesiŋgoji bobiaŋ guga. Go sanaŋgaru kobigake jogbake goigoŋ.” Oŋu ojime maneru aua oo akoŋ fiaya. ");
INSERT INTO mlh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jikigaru rabi Yesuji buŋo siŋande pigo roperu ŋiŋigo jiŋgeŋ keku mimi putebuŋ eru ŋiŋigo kubu fonuŋ ebuŋ, yoŋo ŋone yaberu iŋi mitiga yareya, ");
INSERT INTO mlh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Ŋoŋo sakibe rakaniŋ. Odu mendaineji so komegayoŋ, kubaŋ pega.” Oŋu mitiga yareme manebi jere oŋuine fukeko goue tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Goue tebiyoŋ, ŋiŋigo kubu soguine yoŋo yajiko sakibe rakabi ŋigo mendaine iŋore pepe pi maŋgo roperu meineo roko pakereya. ");
INSERT INTO mlh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pakereme ore biŋe buŋoji saueru qoqodure sa moreŋ oi sosowo sagaru raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuji kae moreŋ oi bokeru raiŋgo rako ŋi jiŋokombi yoyokaji boyoberu ŋadiineo wareru iŋi oŋgabu, “Deiwidre osigida, go bio ŋonemaiŋ enote.” ");
INSERT INTO mlh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Oŋu oŋgabu pi more maŋgo ropeko jiŋokombi ŋi yokoji Yesureo warebire iŋi weu yateya, “Jiŋoŋakuŋ botigabeminde usuŋ nondeo pega, oi manesiŋ gagobire me mata?” Weu yateme iŋi bokirie tebu, “Ofoŋnokuŋ, oi soine manesiŋ gagobere.” ");
INSERT INTO mlh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Oŋu bokirie tebire jiŋo kobiyakuŋgo bouaru yasiya, “Mamanesiŋ-ŋakunde so bio fukeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Oŋu yasiko jiŋoyakunji pibu. Oŋu fukeko sowoŋ buŋo sanaŋine yateru iŋi yasiya, “Maneni, ore biŋe oi mo so mibire maneinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Oŋu yasiyayoŋ, yokoji bokeru raru ore biŋeine misauebire qoqodure sa moreŋ oi sosowo sagaru raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jiŋoyakuŋ tiŋame rabire biriqepoŋ ŋi mo iŋo ogaru Yesureo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Warebi Yesuji gemoine yobeko ŋi biriqepoŋ iŋoji buŋo miko ŋiŋigo kubu yoŋoji oi ŋoneru waragaru mibuŋ, “Kamasi yo oŋuine oi Israel maŋineo ronekoŋ damaŋ mogo so ŋonebuŋ. Mata. Muŋambe yo jiŋo furu ŋonegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Oŋu mibuŋyoŋ, Farisi (Kadi buŋore yameŋyameŋ) yoŋoji mibuŋ, “Iŋo gemokaku yoŋore koitore usunji gemo yobe yabeega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuji raru kae fureme taoŋ so roregaru ŋiŋigo oŋgawowosi piyaŋuŋgo qaji yareru qorumande Bobiaŋ Biŋe mitaniŋgaru oiji maŋyaŋuŋ bapakareru jibe wi eru jibekatikati fuŋne fuŋne bobiaŋ yaberu goya. ");
INSERT INTO mlh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Oŋu goku ŋiŋigo kubuine kubuine ŋone yabeme lama siŋaŋyaŋuŋ tomiri kamasi oŋuine roiŋgaru basiqasi eku siŋsaŋ gobi yoŋore beusembe maneya. ");
INSERT INTO mlh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Oŋu ŋone yaberu kiŋariŋpuine iŋi yajiya, “Anuture gioo uqo foriine kokoine oze gumuŋgaru pegayoŋ, oi roqoqodurere gio bobo ŋiŋigoji afaine gogobi. ");
INSERT INTO mlh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ore eru uqo foriine gumuŋinere Ofonji gio bobo ŋiŋigo sore yabeiŋgo oŋga wosiru goinebi. Oŋga wosi tebi gio ŋiŋigo fukeru foriine oi roqojuganimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuji kiŋariŋpuine 12 oŋga yareme iŋoreo warebi gemokaku yobe yabeniminde usuŋ yareya. Oŋuakoŋ jibe wi qapeqawaki fuŋne fuŋne bobiaŋganiminde usuŋ yareya. ");
INSERT INTO mlh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sosore ŋi aposol 12 yoŋore tina oi iŋi: Fuŋfuŋgaine oi Saimon, tinaine mo Pita mibuŋ eru iŋore gbo Andru. Iŋore ŋadio Jeims eru gboine Jon, mamayakuŋ tinaine Zebedi. ");
INSERT INTO mlh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip eru Bartolomyu, Tomas eru Matyu takis roro ŋi, Jeims Alfiusre made eru Lebeus tinaine mo Tadius, ");
INSERT INTO mlh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Zelot-politik ŋi eru Judas Iskariot. Kariot ŋi iŋoji jiki Yesu babae ba teya. ");
INSERT INTO mlh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuji ŋi 12 yoŋo sore yaberu iŋi mitiga yareru yajiya, “Ŋoŋo kotu kantrire ŋiŋigo yoŋoreo so rainebi. Oŋuakoŋ Samaria prowins yoŋore taoŋ mogo so rainebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Oo so rainebiyoŋ, Israel kufufunde lama jibugabuŋ, ŋoŋo yoŋoreo rainebi. Oi gioyaŋuŋ fuŋfuŋgaine. ");
INSERT INTO mlh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Uro uro ranimiŋ, oo Biŋe buŋo iŋi yajiru mitaniŋgainebi, ‘Sombunde qorumanji bembeŋgo warega. Ŋoŋo ore maŋineo ropeniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Ŋiŋigo jibeyaŋuŋke bobiaŋ yaberu komekiine yoŋo bogbore yaberu goinebi. Ŋiŋigo waeyaŋuŋke oi boposike yaberu gemokaku oi yobe yaberu goinebi. Anutuji ya yauŋ ŋareya, oi jikigaru yauŋ yareru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Kadi ranimiŋ ore siqojiŋo goul me silwa me aeŋ kopaji babaine oi bifuŋ nigiŋ-ŋaŋuŋgo so kipeinebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ŋiŋigoji gio bobo ŋiŋigo ŋoŋore gogo kitiŋ ganimiŋ ore so fukegobi. Ore eru kadi ranimiŋgo, ya yo so roru rainebi: kekere mata, mariku tebuine matayoŋ, moakoŋ roinebi, kadi komoŋ mata eru toku so roinebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Raru taoŋ me kae uro ropenimiŋ, oo moji ŋi yoine tinabiŋeineke fukega, iŋore weu tebi pi ŋarenimiŋ, oo akoŋ goku gio baku taoŋ oi bokeru kadi rainebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pi mogo roperu womoji yoŋoke peiŋ ore miinebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Oŋu mibi womoŋaŋuŋ sabarenimiŋ ore so fukegobi ine, womoŋaŋunji yoŋore paio ropeiŋyoŋ, oi sabarenimiŋ ore so, so fukegobi ine, womoŋaŋunji kirieru ŋoŋo-ŋaŋundeo wareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Raru goku pi mogo ropebi so kepore ŋaberu buŋoŋaŋuŋ so manebi ketayaŋuŋ iŋi miku yaduniŋ, ‘Niŋo ŋoŋore kaeo warebeneŋ rufe kufu tapenoŋuŋgo bakatoga, oi oderu keririkebeneŋ ŋoŋo-ŋaŋundeo kirieru rakaiŋ.’ Oŋu miku soine kae me taoŋ oi bokeru jikigaru rainebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Anutuji damaŋ yasogoo qaqosoriyaŋunde geo kerisieme taoŋ ore paiineo ropeiŋ, someda oiji Sodom eru Gomora kae yoŋore someda odureru jikigaru yareiŋ. (Sodom Gomora yoŋoji sembene mimiine eku maŋyaŋuŋ so kerisiebi Anutuji misiji ketotie yabeya.) Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Maneniŋ, lama yoŋoji gomende qoro rigaŋine yoŋore botugo rakabi riŋaru egu ki ŋabenimiŋ, nonji ŋoŋo ore kamasi oŋuine sore ŋabebe rainebi. Ore eru kobeŋ oŋuine mamane-muku paio sisiŋaŋ eru goku kabu oŋuine ŋiŋigo waigo bakare buŋoŋaŋuŋ tomiri goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ŋiŋigoji oga ŋaberu buŋo koroyaŋuŋgo rua ŋaberu oŋgawowosi piyaŋuŋgo buŋo gioyaŋuŋ baku kobiŋ joruinekeji ŋabenimiŋ. Ore eru ŋiŋigo oŋuine yoŋore ore sisiŋaŋ eru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“Goineji nonde eru oga yabebi kantriine kantriine yoŋore ŋi koito eru gawana yoŋore jiŋo maio dimanimiŋ. Oŋu dimaku nonde fuŋne kitiŋgaku mibi ŋi yoine oi eru kotu kantri kufufuŋ yoŋoji oi manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Oi manenimiŋ, buŋo koroineo rua ŋabebi dimanimiŋ, damaŋ oo wamo buŋo uruŋu minobeŋ, ore manebu so einebi. Buŋo minimiŋ, oi Moro Tiriineji aua oo akoŋ ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ŋoŋo-ŋaŋunde maŋgone buŋo so minimiŋyoŋ, Mamaŋaŋunde Moro Tiriineji maŋ-ŋaŋuŋ boburogame buŋo minimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Maŋkekerisiere yauraine mo kakagboineji maŋine kerisieya ore eru oi babae bako buŋo koroineo ruabi qabi komeiŋ. Oŋuakoŋ mama mo odu madeine babae bako komeiŋ eru odumade yoŋo maŋgomamayaŋuŋ igo yaberu mibi yabebi komenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nonde tinare eru kantriine kantriine yoŋoji sosowo rosi eŋarebi gonimiŋyoŋ, moji yameŋ keku damaŋ tariiŋ ore so sanaŋgaru qiŋ keru dimaiŋ, iŋoji seŋgiŋbaŋgiŋ raugaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Taoŋ moji kekesuesue eŋarenimiŋ, oi useru taoŋ mogo rainebi. Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Ŋoŋo Israel taoŋine taoŋine so rorega forebi Sombuŋ eru morende Ŋi foriineji kirieru wareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kiŋariŋ moji qaqajiine odureru mamaneineke so fukega eru kiŋaŋqoqo moji soguine odureru giore mamane so baru goga. ");
INSERT INTO mlh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","“Kiŋarinji qaqajiine oŋuine mamaneineke fukeko sagaiŋ eru kiŋaŋqoqoji soguine oŋuine giore mamane baru goko sagaiŋ. Pi maŋine more ŋi misembearu tinaine Gibio migobi ine, iŋore ŋigo madepu yoŋore tina afaine akoŋ oŋu mienimiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ŋiŋigoji ya iporo babi pega, oi sosowo qaratiebi totogo fukeiŋ. Oŋuakoŋ buŋo soŋsoŋine pega, oi sosowo barariŋga yarebi mane mukunimiŋ. Ore eru ŋiŋigo yoŋore kokoi so maneru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nonji buŋo qisirigo kamiine mibemiŋ, oi tatamago minimiŋ. Buŋo saŋu ebi kajeŋaŋuŋgo rakame manenimiŋ, oi kae jiŋoo totogo miinebi. Ore eru buŋoŋaŋunde sisiŋaŋ eku goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Goineji sakiŋaŋuŋ qaku komenobuŋyoŋ, iiruŋaŋuŋ qaku komeiŋgo embimbiŋganimiŋ, yoŋore kokoi so maneru goinebi. Oi matayoŋ, ya miine yo: Moji usuŋ roku iiru eru saki oŋuakoŋ sibiri yapeko misi korugo rakanimi, iŋore kokoi maneru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Goineji wirioŋ (me wiwisu) yoyoka moneŋ koruŋ moakomenji furiine banimiŋ ore eegobiyoŋ, muru yapebi Mamaŋaŋunji ‘Oŋ!’ so miko yokoreone moakonji moreŋgo so wakiiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","“Anutuji siŋaŋ ŋaberu qoru sikiŋaŋuŋ sosowo oŋuakoŋ ose foreru jareyaŋuŋ manega. ");
INSERT INTO mlh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ŋiŋigo ŋoŋore furi oi wirioŋ wiwisu kokoine yadureru ropekiine fukega. Ore eru kokoi so maneru goinebi. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Oŋu fukeko moji noŋ ŋiŋigo jiŋoyaŋuŋgo mifuke nuiŋ, nonji oŋuakoŋ iŋo Mamane Sombuŋ kaeo goga iŋore jiŋoo mifukebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Oŋuyoŋ, moji noŋ ŋiŋigo jiŋoyaŋuŋgo muga nuiŋ, nonji oŋuakoŋ iŋo Mamane Sombuŋ kaeo goga iŋore jiŋoo mugabemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesuji jikigaru iŋi yajiya, “Iŋi so manesuinebi: Yesuji womo eiŋgo eru moreŋgo wakiya. Nonji womo eiŋgo ore matayoŋ, nonde eru pougaru roiŋgabi jigore siqo yasogoji qoqo enimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","“Oi iŋi ore migo: Nonde Biŋe buŋoji ŋiŋigo maŋyaŋuŋ bapakareme kerisiebuŋ ore eru iŋi fukeiŋ: ‘Mama made yokoji pougaru rorosi ebire maŋgo odu yokoji roiŋgaru qoqo ebire yaŋoji yaŋoine qoqopie ee eru roiŋgamini. ");
INSERT INTO mlh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ŋiŋigo yoŋoyaŋunde garikiŋpuyaŋunji rosipuyaŋuŋ fukenimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Moji noŋ qaŋaŋineo rua nuku maŋgoine me mamaine mine ruaru manjoko eteiŋ, oi nondeo so sagaiŋ. Moji noŋ qaŋaŋineo rua nuku madeine me oduine mine ruaru manjoko eteiŋ, oi nondeo so sagaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Misombeŋ-ŋaŋuŋ babi moji noŋ boyobe nuru joiserereŋ maneru maripoŋgo komeiŋ ore so jaueiŋ, oi nondeo so sagaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Moji iŋoyoŋunde gogo batiqatiine tomiri oi bofukeiŋ, iŋore gogoji jibugaiŋ. Moji nonde eru gogoine kisiŋgako jibugaiŋ, iŋoji seŋgiŋbaŋgiŋ gogo bofukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesuji miya, “Moji ŋoŋo piineo keporeru siŋaŋ ŋabeiŋ, iŋoji noŋ kepore nuiŋ. Moji noŋ kepore nuiŋ, iŋoji sore nuya, iŋo piineo keporeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Moji kajeqouŋ ŋiŋigo mo kajeqouŋ gioinere eru piineo keporeru siŋaŋ gaiŋ, iŋoji kajeqouŋ ŋiŋigore furi raugaiŋ. Moji ŋiŋigo posiine mo posiine fukega ore eru piineo keporeru siŋaŋ gaiŋ, iŋoji ŋiŋigo posiinere furi raugaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Moji odumade yo yoŋoreone mo nonde kiŋariŋ fukega ore eru obu munaŋine popuineke noinde oteiŋ, Anutuji ore furiine bokirieru oteiŋ. Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Kitiŋ ŋabenimiŋ, yoŋoji furi ronimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuji mimiti buŋoine oŋu kiŋariŋpuine 12 yareme tarime kae oi bokeru jikigaru Galili prowinsre taoŋ goineo raru Biŋe buŋo qaji yareru oiji maŋyaŋuŋ bapakareru goya. ");
INSERT INTO mlh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Damaŋ oo Jon Mitimeso ŋiji witi pigo ŋeku Kristoji gio oŋu baya, oi maneru kiŋariŋyokaine yoyoka sore yapeme Yesureo rabu. ");
INSERT INTO mlh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iŋi weu teiŋgo ore sore yapeme raru mibu, “Bobobiaŋ ŋi wareiŋgo odigabeneŋ goji iŋo fukege me ŋi mo jiki wareinde odigakimiŋ?” ");
INSERT INTO mlh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Oŋu weu tebire iŋi bokirieya, “Ya ŋoneru manegobire, ore sunduine oi raru Jon iŋi ojibire maneiŋ: ");
INSERT INTO mlh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jiŋokombi yoŋo jiŋoyaŋuŋ piku ŋonegobi demba yoŋo kadi ra warebi waeyaŋuŋke yoŋoji posikegobi kajegi yoŋo buŋo manegobi komebuŋ yoŋo gboreru pakeregobi wakiqoqoine yoŋore Bobiaŋ Biŋe mitaniŋgabe maneegobi. ");
INSERT INTO mlh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Oŋu fukeko ŋonebi more manji so sembeako ŋadi nuiŋ, iŋoji kiwaqawaineke fukega.” ");
INSERT INTO mlh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Oŋu bokirieme Jonde kiŋariŋ yokoji rabire Yesuji fuŋgaru Jonde fuŋne ŋiŋigo kubu yoŋoreo iŋi mitaniŋgaya, “Ŋoŋo moreŋ buroineo wamo ya ŋoneiŋgo ore rabuŋ? Gbinji sabara yoyowogaru romaeŋgame gburugburu eega, ŋoŋo ŋi oŋuine iŋo ŋoneiŋgo rabuŋ me? ");
INSERT INTO mlh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Me wamo ya ŋoneiŋgo rabuŋ? Ŋi marikuine kuririineke keku goya, oi ŋoneiŋgo ore me? Maneniŋ, ŋiŋigo marikuyaŋuŋ ŋone aŋiineke keegobi, yoŋoji kiŋ yoŋore morumboŋ pigo gogobi. Oi moreŋ buroineo mata. ");
INSERT INTO mlh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Me wamo ya ŋoneiŋgo rabuŋ? Kajeqouŋ ŋi mo ŋoneiŋgo me? Fofori, nonji iŋi ŋajibe maneniŋ: Ŋi ŋonebuŋ, iŋoji kajeqouŋ ŋiŋigo goine yadureru fuŋine mo fukega. ");
INSERT INTO mlh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iŋore fuŋne oi ronekoŋ iŋi quraŋgabi pega, ‘Mane, nonji kiŋaŋne mimerereŋ mo sorebe bonieru raru ŋiŋigo maŋyaŋuŋ botiŋgaru gore kadi bataniŋgame goji iŋore ŋadio moreŋgo yuku rakamiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Buŋo oŋu pegayoŋ, nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Ŋigoone odumade fukebuŋ, sosowo yoŋore botugo Jonji sosowo yadureru tinabiŋeineke dimaga. Dimagayoŋ, Sombunde qorumaŋ maŋgo roperu Anuture tinabiŋe bofukeegobi, yoŋore botugo wawakiine tatariine iŋoji Jon odureega. ");
INSERT INTO mlh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Jon Mitimeso ŋiji Biŋe buŋo miko damaŋ oo akoŋ fuŋgaru Sombunde qorumaŋ oi joineke kiso eku jigo qaegobiyoŋ, jibu pipa raru sogueega. Jigo joyaŋuŋke qaegobi, yoŋoji qorumaŋ oi yoŋoyaŋunde furugaru biŋe gaegobi. ");
INSERT INTO mlh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Qorumande fuŋne oi Mosesre Kadi buŋoo eru kajeqouŋ ŋiŋigo sosowo yoŋore Biŋe Quraŋgo quraŋgabi oseru go wapebeneŋ Jonji fukeru foriine totogo barariŋgaya. ");
INSERT INTO mlh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Buŋo yo maneru roru sabarenimiŋgo manegobi ine, Elaija fukeiŋ ore so eya, Jonji iŋo fukega. ");
INSERT INTO mlh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Moji maŋkajeineke goga, iŋoji buŋo oi kaje ruaru mane mukuine. ");
INSERT INTO mlh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ŋiŋigo muŋambe moreŋgo gogobi, oi wamo yake so ke yarenobo? Yoŋoji memenda oŋuine fukegobi. Yoŋoji nareŋgareŋ kae jiŋoo ŋeku mi goue eku kosa oŋgaku iŋi miegobi, ");
INSERT INTO mlh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Niŋo kiki kiraŋ keku mimi putebeneŋ ŋoŋo so wobuŋ. Niŋo kimagu kebeneŋ ŋoŋo so kuyobuŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Ore fuŋine oi iŋi: Jon Mitimeso ŋiji wareru uqo sowo goku wain obu so noko iŋore miegobi, ‘Gemo moji maŋineo rakame goga.’ ");
INSERT INTO mlh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“Sombuŋ eru morende Ŋi foriineji wareru uqo munjaŋ noku jeri eko iŋore iŋi miegobi, ‘Maneniŋ, iŋoji kanenji nonoine uqo gaba tomiri noku wain obu jijiki noku takis ŋi eaduyaŋuŋke eru sembene bobo yoŋore ogo goga.’ Anuture maŋgboroŋ kegboreegobi, yoŋore eeboboyaŋunde foriji mamane-mukuyaŋunji sagaga, oi ŋaduega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ore ŋadio Yesuji fuŋgaru taoŋ goine kane yabeya. Taoŋ goine oo mosi qoqowirie usuŋineke boakoŋ bame fukeyayoŋ, jibu maŋyaŋuŋ so kerisiebuŋ. Ore eru oi kane yaberu iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“O Korasin rauine, nonji ŋoŋore ‘Yei!’ miku kuyogo eru Betsaida rauine, ŋoŋore oŋuakoŋ ‘Yei!’ miku kuyogo. Nonji ŋoŋoreo raru buŋone mibe keposikeko mosi qoqowiriene usuŋineke fukeyayoŋ, maŋ-ŋaŋuŋ jibu so kerisiebuŋ. Mosi qoqowirie oi kotu moreŋgo Taia (Tiro) eru Saidon sitio fukena ine, yoŋoji damaŋ joroine maŋyaŋuŋ kerisieniminde kegoi noduru gijeŋ eru kome rauku kuyonobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Kuyonobuŋyoŋ, nonji iŋi ŋajibe maneniŋ: Anutuji jiki Korasin eru Betsaida yoŋore buŋoyaŋuŋ mitariku geoine kerisieme joiserereŋ manenimiŋ, damaŋ yasogo oo oi Taia eru Saidon yoŋore joiserereŋ soine odureru manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Eme Kaperneam rauine, Anutuji ŋoŋo soine romaeŋ ŋabeme Sombuŋ kaeo ropenimiŋ me mata? Mata yobu! Ŋoŋo komere misoŋ kaeo rakanimiŋ. Nonji yoŋoreo raru buŋone mibe keposikeko mosi qoqowiriene usuŋineke babe fukeyayoŋ, maŋyaŋuŋ jibu so kerisiebuŋ. Mosi qoqowirie oi Sodom taoŋgo fukena ine, taoŋ oiji damaŋ yoo oŋuakoŋ jikigaru dimana. ");
INSERT INTO mlh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","“Dimanayoŋ, nonji iŋi ŋajibe maneniŋ: Anutuji jiki Kaperneam ŋoŋore buŋoŋaŋuŋ mitariku geoine kerisieme joiserereŋ manenimiŋ, damaŋ yasogo oo Sodom yoŋoji joiserereŋ ore soine odureru manenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Damaŋ oo Yesuji buŋo iŋi miya, “O Mamane, goji Biŋe buŋogo maŋgboroŋ ŋiŋigo mamane soguine robuŋ, yoŋoreo sumuŋgameŋyoŋ, ŋiŋigo yoŋoyaŋunde maneru wakiru odumade oŋuine mo gogobi, oi yoŋoreo barariŋga yarende mane taniŋgagobi. Ore eru nonji Sombuŋ morende Ofoŋ go miteŋ gugo. ");
INSERT INTO mlh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Mamane, go gogake oŋu fukeiŋgo manende sagako fiine fukeya. ");
INSERT INTO mlh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Mamaneji ya sosowo mitigako nonde biŋe fukeya. Mamaneji Madeinere fuŋne iŋoyoŋe akoŋ mane mukuko moji oi so manega. Oŋuakoŋ Madeineji Mamainere fuŋne mane mukuko moji oi so manega. Madeineji akoŋ oi manega eru ŋiŋigo roosoe yaberu yoŋore oi barariŋga yareiŋ, yoŋoji Mama mane tenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Gio baku maŋyobiŋyaŋuŋke gogobi, ŋoŋo sosowo nondeo warebi maŋ-ŋaŋuŋ ba afaga ŋarebe ŋema nainebi. ");
INSERT INTO mlh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nonde begi oi fagaŋaŋuŋgo ruaru koboinebi eru nonji eebobone qaji ŋarebe oi mane sarigaru goinebi. Nonji maŋne bawakiru eru womo ŋi fukego ore soine maŋ-ŋaŋuŋ ba afaga ŋarebe ŋeŋemane bofukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nonde begi roru kobobi soŋaŋuŋgo fukega eru yobiŋ ŋarebe osiganimiŋ, oiji afaine fukega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ore ŋadio Sabat kombaŋ mogo Yesuji wit kurumbu gio rondiŋine soguine petigaru raya. Rako kiŋariŋpuineji uqore komeru wit foriine moakoŋ moakoŋ fuŋgaru meyaŋunji bajiru nobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nobuŋyoŋ, Farisi (Kadi buŋore yameŋyameŋ) goineji oi ŋoneru Yesu iŋi ojibuŋ, “Mane, gore kiŋariŋpugoji Sabat kombande gio bobo agi oduregobi?” ");
INSERT INTO mlh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Oŋu ojibi iŋi bokirieya, “Kiŋ Deiwidji mamari ŋipuine yoŋoke roregaru uqore komeru ya ebuŋ, oi osebuŋ me mata? ");
INSERT INTO mlh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Iŋoji Anuture kambaŋ seri soriŋgo roperu poroŋ mokiine Anuture jiŋo maio koro alatao ruabi ŋeko usuŋineji kefagame qomukubuŋ, oi roko nobuŋ. Poroŋ mokiine bobokeine oi soriŋ gio siŋaŋ yoŋoji akoŋ noku gobuŋ. Iŋoji eru iŋore osigidapuji oi egu noniminde agi peyayoŋ, oi jibu nobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Oŋuakoŋ soriŋ gio siŋaŋ yoŋoji Sabat kombaŋgo boji soriŋgo dimaku gio baku gio baniminde agi odureru jibu buŋoyaŋuŋke so fukeegobi. Buŋo oi Kadi buŋoo osebuŋ me mata? ");
INSERT INTO mlh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Oi osebuŋ, oŋu manegoyoŋ, nonji iŋi ŋajibemiŋ: Yoo dimaga, iŋo boji soriŋ odureru ropekiine fukega. ");
INSERT INTO mlh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Biŋe Qurande buŋo mo iŋi pega, ‘Nonji boji riganimiŋ ore matayoŋ, botuŋaŋuŋgo ŋonemaiŋ naduŋgaduŋ enimiŋgo manego.’ Ŋoŋo buŋo ore fuŋine manenobuŋ ine, ŋiŋigo bakare buŋonoŋuŋ tomiri niŋore buŋo kosa so mitarinobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“Oi iŋi ore migo: Sombuŋ eru morende Ŋi foriineji Sabat kombande Ofoŋ goga.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuji moreŋ oi bokeru oŋgawowosi piyaŋuŋgo ropeya. ");
INSERT INTO mlh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Oo ŋi meine gbagbaŋiine mo ŋeya. Ŋiŋigoji Yesu buŋo korogo ruaiŋgo ore iŋi weu tebuŋ, “Ŋi Sabat kombaŋgo bobiaŋgaru Kadi buŋo odurekimiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Weu tebi iŋi bokirieya, “Ŋoŋoreone moji iŋi fukega: Ŋi more lama moakonji Sabat kombaŋgo yoŋgo kaiŋ ine, iŋoji oi so furugame wapeiŋ me mata? ");
INSERT INTO mlh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ŋire furiji lamare furi kokoine odurega, oi manesuinebi. Ore eru Sabat kombaŋgo gio fiine baku oŋuineji Kadi buŋo so odurekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Oŋu bokirieru ŋi oi ojiya, “Go mego poretiŋga.” Oŋu ojime poretiŋgame rone eya, ore so fiine fukeru meine ogoine ore so eya. ");
INSERT INTO mlh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ore so eme Farisi (Kadi buŋore yameŋyameŋ) yoŋo sakibe raru tutumaŋ eru Yesu uruŋu eru qabeneŋ komenonde buŋo miku baabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuji buŋoyaŋuŋ oi ŋone mukuru oo akoŋ kae oi bokeru mogobe raya. Rako kokoineji iŋore ŋadio boyoberu rabuŋ yoŋore botugo jibe ŋiŋigo sosowo bobiaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Bobiaŋ yaberu fuŋne totogo egu minimiŋ ore sanaŋ qaŋqaŋine qomuku yareya. ");
INSERT INTO mlh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Oŋu fukeme Anutuji kajeqouŋ ŋi Aisaia boburogame buŋo mo miya, oiji foriineke eya. Buŋo oi iŋi miko pega, ");
INSERT INTO mlh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ŋoneniŋ, yo nonde gio ŋi fukeko iŋo roosoeboŋ. Nonji yoro ogone iŋore manebe beune fiame maŋneji iŋore jerieego. Nonji Morone Tiriine iŋore maŋgo sagaiŋ ore sorebe kame iŋoji buŋo poretiŋ akoŋ mitariego ore Biŋe buŋo barariŋga ŋareru misaueko kantriine kantriine yoŋoreo raiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iŋoji kekepari so eru buŋo fofoine so oŋgaeiŋ. Ŋiŋigo moji iŋore buŋo fonuŋ oi tumaqoqo kadio so maneiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Sabara kasigabi, iŋoji oi so qopogaiŋ. Lambere wikji jotigaru mosiine fukeko boruŋineji ja kobe eega, iŋoji oi so qokobeiŋ. Gioine oŋu baku ŋiŋigoji buŋo poretiŋ boyobenimiŋ ore jigo qaku gome buŋo oiji gbiŋ eme kokoriaŋ enimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kantriine kantriine yoŋo iŋoji bapi yabeiŋgo odigaru ooriyaŋuŋ iŋore tinao ruaru gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Gemoji ŋi mo biriqepoŋ eteme jiŋoine kobeme mutu goya, oi ogaru Yesureo warebuŋ. Yesuji iŋo bobiaŋgako gemoine waperu rame namaŋine wirieme moke buŋo miku piku ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Piku ŋoneko ŋiŋigo kubu sosowo yoŋoji oi ŋoneru popureru mibuŋ, “Ŋi yo iŋoji Deiwidre osigida ega me?” ");
INSERT INTO mlh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Oŋu mibuŋyoŋ, Farisi (Kadi buŋore yameŋyameŋ) yoŋoji oi maneru iŋi mibuŋ, “Ŋi yo iŋoji more usunji matayoŋ, gemokaku yoŋore Koito Gibio iŋore usunji gemo yobe yabeega.” ");
INSERT INTO mlh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Oŋu mibuŋyoŋ, Yesuji maŋ mamanesuyaŋuŋ mane foreru iŋi yajiya, “Kantri uri yoŋore siŋaŋ yoŋo botuyaŋuŋgo kekepari kikiso eku pouganimiŋ, yoŋoji sisibiri eebi kantriyaŋunji sembearu sesuine akoŋ fukeru siŋsaŋ qaru peiŋ. Oŋuakoŋ siti me kae more kufufuŋ yoŋo botuyaŋuŋgo kekepari kikiso eru pouganimiŋ, yoŋoji siŋaŋyayabe gioyaŋuŋ baru dimaiŋgo embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Maneniŋ, Satanji ogoine Satan mo yobena ine, yoŋoji botuyaŋuŋgo kekepari kikiso eku pouganobuŋ. Oŋu fukeko siŋaŋyayabe gioyaŋuŋ baiŋgo embimbiŋgabi gemo qorumaŋyaŋunji uruŋu dimana? ");
INSERT INTO mlh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Maneniŋ, nonji Gibiore usunji gemokaku yobe yabenobo ine, ŋoŋore ogopu yoŋo more tobiriji oi yobe yarenobuŋ? Ore yoŋo buŋoyaŋuŋ foriine me mata, oi osoeru mitarinimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Oi mitarinimiŋyoŋ, Anuture usunji nonde me sisi boburogame gemokaku yobe yabeego ine, Anuture qorumanji ŋoŋoreo ware fukega. ");
INSERT INTO mlh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Moji ŋi sanaŋine Gibiore me kufu bonieru so kipeiŋ ine, iŋoji uruŋu piineo roperu meboine qojigaru rona? Bonieru iŋo kipeme ŋeko soine piineone yareyaine sosowo yao roru raiŋ. (Ore so nonji oŋuakoŋ Satan kiperu ŋadiineo gemoine yobe yabeebemiŋ.) ");
INSERT INTO mlh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Moji noke so goga, iŋoji kisiŋ nueega. Moji ŋiŋigo nonde tinao tumaŋganiminde so kepore yabeega, iŋoji boroiŋ yabeega. ");
INSERT INTO mlh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ore nonji buŋo mo iŋi ŋajibe: Ŋiŋigo agiburaŋ eru igosisi sosowo eegobi, yoŋo Anutuji soine bokeegayoŋ, moji Moro Tiriine igosisi eteiŋ, ore agiburaŋ Anutuji damaŋ mogo so bokeiŋ. Mata yobu! ");
INSERT INTO mlh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“Moji Sombuŋ eru morende Ŋi foriine igosisi eteru buŋo oŋuine miiŋ ine, Anutuji oi soine bokeiŋyoŋ, moji Moro Tiriine igosisi eteku buŋo ya miiŋ, iŋore agiburaŋ oi Anutuji moreŋgo goiŋ ore so me kome ŋadiineo so bokeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Yore fuŋne oi foriine ŋone osoeru manegobeneŋ. Ore eru yo siŋaŋ gabi fiine fukeko foriine fiine fukeeiŋ me yo bosembeabi foriine sembene fukeeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ŋi maŋineo ya puseru pega, oi mi bibiineji totogo miega. Ore eru ŋoŋo-ŋaŋe qotire madepu fukegobi. Sembene oŋuine fukeru uruŋu buŋo fiine minobuŋ? ");
INSERT INTO mlh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ŋi fiinere maŋ rouŋgo ya fiinere moriri pega, iŋoji fiine oi totogo akoŋ miega. Ŋi sembenere maŋ rouŋgo ya sembenere moriri pega, iŋoji sembene oi totogo miega. ");
INSERT INTO mlh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Oŋu miegayoŋ, nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Ŋiŋigo agi kigaru buŋo omaine omaine minimiŋ, yoŋo buŋoyaŋuŋ sosowore fuŋne oi mimitarire damaŋ yasogoo Anutureo mitaniŋgabi osoeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ore fuŋine oi iŋi: Anutuji buŋogo osoeru ore so buŋogo mitarime posikemiŋ me buŋogoke fukeru yobiŋ bofukemiŋ. Oŋu.” ");
INSERT INTO mlh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Damaŋ oo Farisi (Kadi buŋore yameŋyameŋ) eru Kadi buŋore qaqaji goineji Yesure iŋi ojibuŋ, “Qaqaji, go soine mosi qoqowirie mo bande oi ŋoneiŋgo manesugobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Oŋu ojibi iŋi bokirie yareya, “Ŋiŋigo muŋambe moreŋgo gogobi, yoŋo kubu sembene fukeru boesau eegobi. Yoŋoji Anuture mogere yameŋ keegobiyoŋ, moge mo kajeqouŋ ŋi Jonareo fuke foreya. Anutuji moge furuine mo so bayareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonaji gio bobo yokaomo koe jomare (gajugaju) beu maŋgo goya, ore so Sombuŋ eru morende Ŋi foriineji oŋuakoŋ gio bobo yokaomo ore so moreŋ maŋineo peiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Jonaji Niniwe ŋiŋigo botuyaŋuŋgo raru Anuture buŋoji maŋyaŋuŋ bapakareme maneru oo akoŋ maŋyaŋuŋ kerisiebuŋyoŋ, maneniŋ, nonji botuŋaŋuŋgo fukeru dimaku Jonare eebobo odureru eego. Oŋu eegoyoŋ, ŋoŋo jibu keta enareegobi. Ore eru Niniwe ŋiŋigo yoŋo mimitarire damaŋ yasogoo ŋiŋigo kubu yo dimagobi, ŋoŋoke moko komegone pakereru ŋoŋore keririŋgo moko dimanimiŋ. Moko dimaku Niniwe yoŋoji buŋo iŋi ŋoŋore sakigo ruanimiŋ, ‘Ŋoŋo Sombuŋ eru morende Ŋi foriine keta etebi Anutuji geoine bokirie ŋareme joiserereŋ ropekiine manenimiŋ.’ Niniwe yoŋo oŋu mibi eeboboyaŋunji ŋoŋo-ŋaŋunde fuŋne barariŋga yarebi mimiŋaŋuŋ manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Fuŋneŋaŋunde kegoi mo oi iŋi: Anutuji ronekoŋ maŋgboroŋ ropekiine oi kiŋ Solomon oteko Saut oobene kantri more kwin ŋigoji Solomonde maŋgboroŋ maneiŋgo aŋi maneya. Aŋi maneru moreŋ qaŋaŋineone pakereru kadi joroine yobu wareru goku Solomonde mamane foriine maneya. “Oi maneyayoŋ, maneniŋ, damaŋ yoo nonji botuŋaŋuŋgo fukeru dimaku Anuture maŋgboroŋ ropekiine roru warego, oi Solomonde maŋgboroŋ odurega. Oduregayoŋ, ŋoŋo jibu keta enareku mo gobi so sagaga. Ore eru Anutuji jiki ŋiŋigo sosowo furu yaberu buŋoyaŋuŋ mitariiŋgo ore jiŋo maiineo ropenimiŋ, damaŋ oo Saut kantrire kwin ŋigo oiji oŋuakoŋ ropeiŋ. Iŋoji ŋiŋigo kubu soguine yoo dimagobi, ŋoŋoke moko komegone pakereru ŋoŋore keririŋgo moko dimaiŋ. Moko dimaku buŋo iŋi ŋoŋore sakigo ruaiŋ, ‘Ŋoŋo Yesu keta etebi Anutuji geoine bokirie ŋareme joiserereŋ ropekiine manenimiŋ.’ Iŋoji oŋu mime yoŋoji mosiŋaŋuŋ osoeru ŋoŋo-ŋaŋunde mimiŋaŋuŋ manenimiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Gemoji ŋi maŋineone waperu moreŋ buroineo raru kosa roregaru goku ŋema neiŋgo pi baaru mo so bofukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Oi so bofukeru takigako iŋi miiŋ, ‘Pine bokeru wareboŋ, oo moke kiriebemiŋ.’ Oŋu miku kirieru piine ofaŋgaru basarigako peya, oi taine peko bofukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","“Oŋu bofukeru raru gemokaku goine 7 oga yabeiŋ. Gemokaku 7 yoŋo iŋoyoŋe odureru sembene yobu fukegobi. Iŋoji oi oga yabeme wareru pi oo roperu ore maŋgo gonimiŋ. Oŋu fukeme ŋi iŋore fuŋne rone sosoine fukeyayoŋ, jiki sembeqambeaiŋ. Ŋiŋigo kubu sembene yo muŋambe moreŋgo gogobi, ŋoŋore oŋuakoŋ oŋu fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuji jikigaru ŋiŋigo kubu buŋo yajiru gome maŋgo gboine yoŋoji wareru sakibe dimaku iŋoke buŋo mininde manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Manebi moji iŋi ojiya, “Mane, gore maŋgo gbogoji sakibe dimaku goke buŋo mininde manegobi.” ");
INSERT INTO mlh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Buŋo oi ojiyayoŋ, iŋoji bokirieru iŋi miya, “Nonde maŋgo oi moji? Nonde gbopu oi moji?” ");
INSERT INTO mlh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Oŋu miku meine kiŋariŋpuine yoŋore oobe bofeŋgaru miya, “Ŋoneniŋ, nonde maŋgo eru gbopu foriine yo. ");
INSERT INTO mlh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Uri yoŋoji nonde Sombuŋ Mamare maŋ aŋi reŋgaegobi, sosowo yoŋo nonde maŋgo eru seŋgbopune egobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Una oo akoŋ Yesuji pi oi bokeru obu joguŋ qaŋaŋineo rakaru ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ŋeko ŋiŋigo kubu sogoji iŋoreo raru tumaŋgabi ogâo roperu ŋeya. Ŋeko ŋiŋigo kubu sosowo yoŋo joguŋ qaŋaŋineo mageŋgo tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Oŋu tumaŋgabi soso buŋo kokoine miku iŋi miya, “Maneniŋ! Ŋi moji uqo koruŋ qopogaru tieiŋgo gioo raya. ");
INSERT INTO mlh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Raru qopogaru tieme koruŋ goineji kadi qaŋaŋineo rakaru ŋebuŋ. Rakaru ŋebi (uufuŋ) webo yoŋo waperu oi no forebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","“Koruŋ goineji ko oŋgiŋgo rakaru ŋebuŋ. Rakaru ŋeku oo moreŋ kokoine so bofukebuŋ. Moreŋ dikiine tomiri peya ore qioyaŋunji pipa wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wapebiyoŋ, wegiji waperu tamaeru ja yabeme goduyaŋuŋ tomiri ore gbaŋiru ŋeririkebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Koruŋ goineji komeqore joruinekeo rakaru ŋebuŋ. Rakaru ŋebi oiji waperu kefagaru mumu qa yarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Oŋu jaŋgaru mataeyayoŋ, koruŋ goineji moreŋ fiineo rakaru ŋebuŋ. Rakaru ŋeku goine koruŋyaŋuŋ 100 fukebuŋ. Goine koruŋyaŋuŋ 60, goine 30 ore so fukeru sauebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Moji maŋkajeineke goga ine, iŋoji soso buŋo yo kaje ruaru mane mukuine.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Oŋu miko kiŋariŋpuine yoŋo wareru Yesu iŋi weu tebuŋ, “Go wamore ŋiŋigo yoŋore buŋo miiŋgo miku oo soso buŋoji eru miege?” ");
INSERT INTO mlh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Weu tebi iŋi bokirieru yajiya, “Oi iŋi ore: Sombunde qorumaŋgo rope gokiminde buŋo soŋsoŋine oi ŋoŋo totogo ŋajibe mane mukugobiyoŋ, yoŋore oi oŋu mata. ");
INSERT INTO mlh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Ore fuŋine oi iŋi: Moji mamane-mukuineke goga, Anutuji oi jikigaru oteme kegboreru moririke goiŋyoŋ, moji mamane-mukuine tomiri goga, Anutuji mamaneine mendaine pega, oi oŋuakoŋ yao ro teiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Ŋiŋigo yoŋore buŋo mibemiŋgo miku oo iŋi ore soso buŋoji ruaru miego: Yoŋoji yoŋoyaŋunde jiŋoji ya ŋoneru fuŋine jibu so ŋone mukunimiŋ. Yoŋoyaŋunde kajeji buŋo poretiŋ maneru fuŋine jibu so mane mukunimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kajeqouŋ ŋi Aisaiaji ronekoŋ buŋo mo miku quraŋgaya, oiji ŋiŋigo oŋuine yoŋoreo foriineke fukeega. Buŋo oi iŋi, ‘Buŋo mane esegaru fuŋine jibu so mane taniŋganimiŋ. Ya ŋone esegaru fuŋine jibu so ŋone mukunimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ŋiŋigo kubu sogo yo yoŋore manji sanaŋine kebojigaru pega. Kajeyaŋunji buŋo mane esegaru jiŋoyaŋuŋ kobeme gogobi. Oŋu so enobuŋ ine, jiŋoyaŋunji ya ŋone mukuru kajeyaŋunji buŋo maneru maŋyaŋunji fuŋine mane mukuru maŋyaŋuŋ kerisiebi nonji oi soine bobiaŋ yabenobo.’ ");
INSERT INTO mlh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Buŋo oŋu pegayoŋ, ŋoŋo jiŋoŋaŋunji ya ŋone mukugobi ore kiwaqawaineke fukegobi. Kajeŋaŋunji buŋo mane mukugobi ore kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nonji buŋo foriine yobu mo iŋi ŋajibemiŋ: Kajeqouŋ ŋiŋigo eru Anuture ŋiŋigo posiine kokoineji ŋoŋo ya yo ŋonegobi, oi ŋonenimiŋ ore aŋi sogo maneru gobuŋyoŋ, oi so ŋonebuŋ. Ŋoŋo buŋo yo manegobi, yoŋoji oi bonieru manenimiŋ ore beufi soguine maneru gobuŋyoŋ, oi so manebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Qopogarutitie ŋire soso buŋo migo, ore fuŋine oi kaje ruaru maneniŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Uqo koruŋ qopogaru tieme kadi qaŋaŋineo rakaru ŋeya, oi iŋi: Moji qorumande Biŋe buŋo maneru fuŋine so mane taniŋgako Sembene Rauineji wareru maŋineo koruŋ saribuŋ, oi yao roiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Uqo koruŋ qopogame ko oŋgiŋgo rakaru ŋeya, oi ŋiŋigo sosoine mo. Yoŋoji Biŋe buŋo maneru oi oo akoŋ beufi paio maneru sabareegobi. ");
INSERT INTO mlh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","“Oŋu eegobiyoŋ, maŋyaŋuŋgo godu so pe yareiŋyoŋ, damaŋ pompoŋine akoŋ dimaku sanaŋgaru gonimiŋ. Biŋe buŋore eru suroŋqoqo me kekesuesue fukeme damaŋ oo akoŋ waki yabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Uqo koruŋ qopogame komegbore joruinekeo rakaru ŋebuŋ, oi iŋi: Yoŋo Biŋe buŋo manebi maŋyaŋuŋgo rakagayoŋ, moreŋgo gogore manebu eru moneŋ mebo bobore manjo fukeru yobiŋ yabeega. Tinabiŋeyaŋuŋke fukenimiŋgo sase ebi aŋi sanaŋine sembene goineji oŋuakoŋ maŋyaŋuŋgo maŋgaru Biŋe buŋo mumu qa teega. Oŋu fukeko foriyaŋuŋ tomiri aputa (gipeine) fukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Uqo koruŋ moreŋ fiineo qopogame rakaru ŋebuŋ, oi ŋiŋigo yo oŋuine: Yoŋo Biŋe buŋo kaje ruaru maneru mane taniŋgaru damaŋ so dimaku foriyaŋuŋ bofukeegobi. Goineji buŋo moakoŋgone koruŋ 30 bofukeegobi. Goineji foriyaŋuŋ 60, goineji buŋo koruŋ moakoŋ moakoŋ yoŋore fori 100 basaueru bofukeegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuji soso buŋo mo iŋi miya, “Sombuŋ qorumande fuŋne oi ŋi yo oŋuinere so eru mibemiŋ. Iŋoji gioineo raru uqo koruŋ fiine qopogaru tieya. ");
INSERT INTO mlh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Qopogaru tieyayoŋ, kae ubu eme pekabi oo rosi ŋiji wareru wit kurumbu botuyaŋuŋgo oo borurare koruŋ qopogaru tieru bokeru raya. ");
INSERT INTO mlh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit kurumbu korunji pougaru pakereru roperu foriine fukeya, damaŋ oo boruraji oŋuakoŋ totogo fukeya. ");
INSERT INTO mlh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Totogo fukeko kiŋaŋqoqopuineji oi ŋoneru gio rauinere wareru iŋi ojibuŋ, ‘Sogunenoŋuŋ, giogoo uqo koruŋ fiine qopogaru tiemeŋ me mata? Borurare koruŋ oi urone oo fukega?’ ");
INSERT INTO mlh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Oŋu ojibi iŋi yajiya, ‘Rosi ŋiji oi qopogaru tieya.’ Oŋu yajime kiŋaŋqoqo yoŋo iŋi mibuŋ, ‘Niŋo soine raru borura oi unugaru roru qojugakimiŋgo manege me mata?’ ");
INSERT INTO mlh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Oŋu mibiyoŋ, iŋi yajiya, ‘Mata! Ŋoŋo borura unugaru qojugaru oo kurumbu goine oi oŋuakoŋ egu unuganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Oi bokebi moko sogueru foriine rorore damaŋ ware fukeme nonji damaŋ oo kurumbu babaji ŋiŋigo oi iŋi yajibemiŋ: Ŋoŋo rone borura qojugaru ruabi jaiŋgore dodugaru niginji kipeinebi. Oi kiperu ŋadiineo wit kurumbu foriine oi qojugaru roru wareru nonde rouŋ pigo ruainebi.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuji soso buŋo mo iŋi jikigaru yajiya, “Sombunde qorumaŋ oi iŋi: Ŋi moji yojuŋ koruŋ roru iŋoyoŋere gio moreŋgo raru sariya. ");
INSERT INTO mlh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Koruŋ oi mendaine mademeŋ. Oi uqo koruŋ sosowo yoŋore wawakiineyaŋuŋ fukegayoŋ, pougaru pakereru munjaŋ sosowo yadureru sogueru yo fukeiŋ. Oŋu fukeme dimako sowo webo yoŋo waperu youyaŋuŋ yo ore tieŋineo baegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesuji ŋeŋeineo moke soso buŋo mo iŋi miya: “Sombunde qorumaŋ oi yist me flaua bosogueinde so iŋi fukega: Ŋigo moji Poroŋ rigabemiŋ miku yist roru flaua jambe yokaomo oo qodureru babokiri eru raru ŋeko sosowo sogueya.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuji buŋo sosowo oi kufufuŋ yoŋore soso buŋoji miya. Soso buŋo tomiri buŋo mo so yajiya. ");
INSERT INTO mlh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Oŋu fukeme Anutuji kajeqouŋ ŋi mo boburogame buŋo mo miya, oiji foriineke fukeya. Iŋoji buŋo oi iŋi mime pega, “Nonde mi bibiji afagako soso buŋoine buŋoine mibemiŋ. Anutuji moreŋ bofukeme fukeya, damaŋ oone akoŋ buŋo soŋsoŋgo peko go wapebeŋ, nonji buŋo oi totogo miku barariŋga ŋarebemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuji soso buŋo oi miforeru ŋiŋigo kubu sogo boke yaberu pi maŋgo ropeya. Ropeko kiŋariŋpuine yoŋo iŋoreo wareru iŋi weu teru ojibuŋ, “Borura uqo gioo fukeya, go soso buŋo ore fuŋine mitaniŋga noreigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Oŋu ojibi iŋi bokirieru yajiya, “Sombuŋ eru morende Ŋi foriineji uqo koruŋ fiine fiine qopogaru tieega. ");
INSERT INTO mlh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Uqo gio oi morende kantri sosowo. Uqo koruŋ fiine oi qorumande odumadepu ŋoŋore migo eru borura oi ŋi sembenere odumadepu yoŋore migo. ");
INSERT INTO mlh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Rosiji oi qopogaru tieya, oi Sembene Rauine iŋore migo. Kurumbu babaji damaŋ oi morende damaŋ tariiŋ ore damaŋ sogo oi. Kurumbu babaji ŋiŋigo oi Sombuŋ mimerereŋ yoŋore migo. ");
INSERT INTO mlh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Borura qojugaru misigo ruabi jaiŋ, ore so morende damaŋ tariinde damaŋ soguineo fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sombuŋ eru morende Ŋi foriineji mimerereŋpuine sore yabeme wareru buŋo buru sembene Kristore qorumaŋ maŋgo agiburaŋ eiŋgo kesosoega, oi kepieru botiŋganimiŋ eru ŋiŋigo jaubaineke sosowo yoŋo qodure yabenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","“Oŋu botiŋqotiŋ eru ŋiŋigo oi igo yabebi misi saqo joserereŋ jaku pega, oo rakanimiŋ. Oo rakanimiŋ, yoŋoji kuyo jojoraku ŋiraŋyaŋuŋ kikiari kiku gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Damaŋ oo ŋiŋigo posiine yoŋo wegi oŋuine fukeru Mamayaŋunde qorumaŋ maŋineo tamaeru go ropenimiŋ. Moji maŋkajeineke goga, iŋoji buŋo oi kaje ruaru mane mukuine. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Sombunde qorumaŋ oi juŋe gopiŋ furiine ropekiine ore so iŋi fukega: Oi gioo sumuŋgabi peko ŋi moji oi bofukeru roru sabareku moke moreŋgo sumuŋgaya. Sumuŋgaru ore eru jerieru raru meboine sosowo furiine banimiŋ ore ruame moneŋ wareme oiji gio moreŋ oi furiine baya.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Sombunde qorumaŋ oi stua ŋire so eru soso buŋo mo iŋi mibemiŋ: Iŋoji bote koruŋ baaku goya. ");
INSERT INTO mlh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Baaru goku bote koruŋ moakoŋ furi sogo oi bofukeru raru meboine sosowo furiine banimiŋgo ore ruame moneŋ wareme oiji bote koruŋ oi furiine baya.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Sombunde qorumaŋ oi simemende so ruaru soso buŋo mo iŋi mibemiŋ: Oi obu joguŋgo bokebi rakame jembaeŋ kamasiyaŋuŋ fuŋne fuŋne rakabi ro yaberu qojugaya. ");
INSERT INTO mlh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Qojugako puseme ŋiŋigo yoŋo oi porebi qaŋaŋineo wapeme waki ŋeku jembaeŋ fiine osoeru jambeo qojugabuŋyoŋ, jembaeŋ sembene oi bokebi raya. ");
INSERT INTO mlh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Buŋo ore so morende damaŋ tariinde damaŋ soguineo fukeiŋ. Sombuŋ mimerereŋ yoŋo wareru ŋiŋigo sembene oi posiine yoŋoreone osoe yabenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Osoe yaberu ŋiŋigo sembene oi boke yabebi saqo misi joserereŋ jaku pega, oo rakanimiŋ. Oo rakanimiŋ, yoŋoji kuyo jojoraru ŋiraŋyaŋuŋ kikiari kiku gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesuji soso buŋo oi miforeru iŋi weu yareya, “Buŋo sosowo migo, oi mane taniŋgagobi me mata?” Weu yareme bokirieru “Oŋ!” mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Oŋ!” mibi iŋi yajiya, “Pi rauineji pire rouŋgone mebo ya raŋgbaŋine eru gariine uduru ruaega. Ore so Kadi buŋore qaqaji sosowo Sombuŋ qorumande kiŋariŋpu fukebuŋ, yoŋoji oŋuakoŋ maŋyaŋunde rouŋgone buŋo kuririyaŋuŋke gariine eru buŋo fiine yobu raŋgbaŋine uduru miegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuji soso buŋo oi miforeru kae moreŋ oi bokeru raya. ");
INSERT INTO mlh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Raru sosogue taoŋineo roperu oŋgawowosi piyaŋuŋgo roperu Biŋe buŋo qaji yareya. Qaji yareme popureru waragaru iŋi mibuŋ, “Yei, kajeboji! Iŋoji maŋgboroŋ yo eru mosi qoqowirie usuŋineke oi urone baga? ");
INSERT INTO mlh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ŋi yo kae yoore ketigaqoqo ŋire made. Maŋgoinere tina Maria eru gbopuine Jeims, Josef, Saimon eru Juda. Oi soine manegobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Seŋpuineji sosowo botunoŋuŋgo yoo gogobi. Ore eru ya sosowo yo urone ba wareru ega?” ");
INSERT INTO mlh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nazaret yoŋo oŋu mibi maŋyaŋunji sembeame oo quŋgabuŋ. Quŋgabuŋyoŋ, Yesuji iŋi yajiya, “Kajeqouŋ ŋi iŋoyoŋunde taoŋgo eru iŋoyoŋunde pigo mipemiriŋ eteegobiyoŋ, kae goineo oŋu mata.” ");
INSERT INTO mlh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Oŋu yajime mamanesiŋyaŋunji so fukeme qoqomukuyaŋunde eru mosi qoqowirie usuŋineke oi oo kokoine so baya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Damaŋ oo moreŋ mobeine, Galili prowinsre kiŋ Herod iŋoji Yesure biŋe maneya. ");
INSERT INTO mlh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Oi maneru kiŋaŋqoqopuine iŋi yajiya, “Oi Jon Mitimeso ŋi. Iŋoji komegone pakereru gio bame mosi qoqowirie usuŋineke fukeegobi.” Manebu eru oŋu yajiya. ");
INSERT INTO mlh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Oi yoore eru miya: Herodji gboine Filipre ŋonuŋ Herodias kamiine roko Jon Mitimeso ŋiji kiŋ buŋo miteme kambanti sore yabeme raru Jon roru nigiŋgaru witi pigo ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jonji Herodre buŋo iŋi miya, “Go simogo roru goku Kadi buŋo odurege.” ");
INSERT INTO mlh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Oŋu miko Herodji Jon qabi komeiŋgo maneyayoŋ, kufufuŋ yoŋoji Jonde manebi kajeqouŋ ŋi goya, ore eru kufufuŋ yoŋore kokoi maneya. ");
INSERT INTO mlh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kokoi maneyayoŋ, Herodre fufuke damanji wareme sogunepuine yoŋo tumaŋgaru ŋekabi Herodias oduineji yoŋore jiŋoyaŋuŋgo boji bame Herodji iŋore ŋoneaŋi kokoine eteya. ");
INSERT INTO mlh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ore eru ŋigo jeŋoŋ iŋo wamo yare weuna, kiŋ koitoji oi oteinde buŋo kiperu buŋoine oi mimipaŋ buŋoji misanaŋgaya. ");
INSERT INTO mlh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Oŋu misanaŋgako maŋgoineji ŋigo jeŋoŋ oi bapakareru iŋi ojiya, “Go weu teinde Jon Mitimeso ŋire ube ketigaru qoruine jambeo ruaru roru wareru nareine.” ");
INSERT INTO mlh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Oŋu ojiko kiŋ koitore manji jajabame beusembe maneyayoŋ, mimipaŋ buŋoine miko sogunepuine yoŋo oi manebuŋ, yoŋore jiŋoo egu waki qaiŋ ore eru Jonde qoru oteniminde mitigaya. ");
INSERT INTO mlh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Oŋu mitigaru kambantiine mo soreru miya, “Go witi pigo raru Jonde ube ketigaru qoruine roru ware.” ");
INSERT INTO mlh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Oŋu mime Jonde qoru jambeo ruaru roru wareru ŋigo jeŋoŋ oi oteme roru raru maŋgoine oteya. ");
INSERT INTO mlh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jonde kiŋariŋpuji ore biŋe maneru raru qoŋgbuŋine roru jiŋorunde ko kouŋgo ruaru yaŋgabuŋ. Yaŋgaru raru buŋo oi Yesu ojibi maneya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuji Jonde sundu maneru moreŋ oi bokeru ogâo roperu moreŋ taine mogo yoŋoyoŋe akoŋ gokimiŋgo ore rabuŋ. Ŋiŋigo kubu yoŋo ore sunduine maneru taoŋ eru kaeyaŋuŋ bokeru Yesure ŋadio boyoberu moreŋ kadi rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Rabi Yesuji ogâone wakiru ŋiŋigo kubu sogo ŋone yaberu yoŋore beusembe maneya. Beusembe maneru botuyaŋuŋgo jibe bayabeme gobuŋ, yoŋo bobiaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Oŋu eku gome ubu eme kiŋariŋpuine yoŋo Yesureo wareru iŋi mibuŋ, “Qaqaji, niŋo moreŋ taine yoo gobeneŋ wegi jiriŋine ŋe mukuru rakaiŋ ega. Ore eru go soine ŋiŋigo kubu yo sore yabende kaeine kaeine oo raru uqo munjaŋyaŋuŋ furiine baku nonimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Oŋu mibuŋyoŋ, Yesuji iŋi yajiya, “Yoŋo soine yoo ŋenimiŋ. Ŋoŋo ŋoŋo-ŋaŋe uqo gume yabeniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Oŋu yajime mibuŋ, “Niŋo poroŋ 5 eru jembaeŋ yoyoka oŋu baru gogobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Oŋu mibi yajiya, “Oi roru wareru nareniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Oŋu yajiru ŋiŋigo kubu sogo yoŋo kegbaŋgo wakiru ŋeninde mitiga yareko ŋebuŋ. Ŋebi poroŋ 5 eru jembaeŋ yoyoka oi roru Sombuŋgo pime ropeko mifiagaru poroŋ bajiru kiŋariŋpuine yareme ŋiŋigo kubu so boroiŋ yabebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Boroiŋ yabebi ŋiŋigo sosowo noku no gaba ebuŋ. No gaba eku uqo mobeine kuŋgaŋine bokebuŋ, oi kiŋariŋ yoŋoji roru qojugabi jambe 12 oo rakaru puseya. ");
INSERT INTO mlh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ŋi poroŋ nobuŋ, yoŋore jare oi 5,000. Ŋigo odumade yoŋore jare oi so robuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nobi tariko Yesuji oo akoŋ kiŋariŋpuine mitiga yareru iŋi miya, “Ŋoŋo ogâo roperu bonieru obu joguŋ petigaru aribe raniŋ. Nonji soine damaŋ botuineo ŋiŋigo kubu yo sore yabebe rabi fobemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Oŋu miku ŋiŋigo sore yabeme rabi tukuo roperu iŋoyoŋe akoŋ goku oŋga wosiya. Oŋga wosiru gome ubu eme tukuo yoŋekoŋ ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ŋeko ogâyaŋunji obu joguŋ botuineo joroineo rako gbinji rabuŋ, oŋubene qaru wareme siriji ogâ igogaru bokeme rorisi raru wareya. ");
INSERT INTO mlh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Oŋu eko kae kekeineo (3-6 kilok) oo akoŋ Yesuji obu joguŋ paio ode ode kiŋariŋpuine yoŋoreo raya. ");
INSERT INTO mlh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Raru obu joguŋ paio ode ode rako kiŋariŋpuineji iŋo ŋoneru popureru kokoi maneru gburugburu yabeme “Koe Dabodanji warega,” miku sombuyaŋuŋ maneru oŋgaku oŋga jojorabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Oŋga jojorakabuŋyoŋ, Yesuji oo akoŋ buŋo miku iŋi yajiya, “Ogopune, ŋoŋo kobiŋaŋuŋke jogbake goinebi. Nake warego. Kokoi so maneniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Oŋu yajiko maneru Pitaji bokirieru iŋi ojiya, “Goji Ofoŋ fukege ine, soine minde nonji obu paio ode ode goreo warebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesuji oi maneru “Soine ware,” miya. Oŋu mime Pitaji ogâ bokeru obu joguŋ paio ode ode fuŋgaru Yesureo raya. ");
INSERT INTO mlh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Fuŋgaru rayayoŋ, gbiŋ kokoine qako siri wareme ŋoneru kokoi maneru gburugburu qame fuŋgaru obu maŋgo rakaru iŋi oŋgaya, “Ofoŋ, go bapi nu!” ");
INSERT INTO mlh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Oŋgame Yesuji oo akoŋ meine sineru Pitare meineo roru iŋi ojiya, “Mamanesiŋgo oi wawakiine. Go wamore maŋyoka ege?” ");
INSERT INTO mlh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Oŋu ojiru bapi gako ogâo ropebire gbinji niniŋgame siriji benoŋ baya. ");
INSERT INTO mlh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Benoŋ bame ŋi ogâo ŋebuŋ, yoŋo ohoweine baku miteŋ garu iŋi mibuŋ, “Fofori, go Anuture made.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Obu joguŋ petigaru aribe Genesaret kaeo roperu ogâ bokeru mageŋgo rakabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Maŋgeŋgo rakabi kae ore ŋiŋigo yoŋo Yesu mane mukubuŋ. Mane mukubi buŋo ruabi kae sosowo bembeŋgo ŋebuŋ, oo rame biŋeine maneru jibe ŋiŋigo sosowo oga yaberu Yesureo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wareru dimaku Yesure mariku sisiineo bouaninde karieru gobuŋ. Bouabuŋ, sosowo yoŋoji fia forebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ore ŋadiineo Farisi (Kadi buŋore yameŋyameŋ) eru Kadi buŋore qaqaji goineji Jerusalem sitione Yesureo wareru iŋi weu tebuŋ, ");
INSERT INTO mlh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Gore kiŋariŋpu yoŋo wamore kadi odureru apa ŋasopunoŋuŋ yoŋore mosi so boyobegobi? Yoŋo meyaŋuŋ so jureru munaŋ so qaku jibu fuŋgaru uqo munjaŋ nogobi?” ");
INSERT INTO mlh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Oŋu weu tebi iŋi yajiya, “Ŋoŋo-ŋaŋe wamore apa ŋasonoŋuŋ yoŋore mosi boyobekimiŋ ore kadi odureru Anuture mimipaŋ buŋo qaegobi? ");
INSERT INTO mlh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ore buŋo mo oi iŋi: Anutuji iŋi mitigaya, ‘Maŋgo mamago araŋ ba yateeigoŋ,’ eru ‘Mo iŋo mamaine me maŋgoine qaisogaiŋ, iŋo qabi komeine.’ ");
INSERT INTO mlh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Oŋu mitigayayoŋ, ŋoŋo buŋo oi odureru iŋi miegobi, ‘Mo iŋo mamaine me maŋgoine iŋi ojiiŋ: O beusembe manego. Nonde kikitiŋ yane rauganoŋ, oi Anuture daŋge yauŋ pesiŋ ore osoeru ruabe pega. Moji oŋu miku mamaine me maŋgoine araŋ bateiŋ ore so oŋu so fukega.’ ");
INSERT INTO mlh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Oŋu miku mosiŋaŋuŋ raŋgbaŋinere eru Anuture mimipaŋ buŋo kepiabi omaine fukeru mataeega. Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","O maŋkekerisiere ŋiŋigo sasakiine, kajeqouŋ ŋi Aisaiaji ŋoŋore fuŋne poretiŋ ronekoŋ barariŋgaru iŋi miya pega, ");
INSERT INTO mlh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ŋiŋigo kubu yo yoŋo mi bibiyaŋunji fiine akoŋ araŋ ba nareegobiyoŋ, maŋyaŋunji keta enareku mogo jorigo ruabi pega.’ ");
INSERT INTO mlh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“Oŋu peko nonde ohowe omaine yobu baku miteŋ nuegobi. ‘Kadi buŋo qaji yarekimiŋ,’ miku tifeo ŋiŋigo yoŋore mimitiyaŋuŋ oi edobodo eru bobojibu eegobi.” Oŋu bokirie yareya. ");
INSERT INTO mlh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuji ŋiŋigo kubu moke oŋga yareme warebi iŋi yajiya, “Ŋoŋo buŋo yo kaje ruaru mane mukuinebi. ");
INSERT INTO mlh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ŋiji ya nome maŋineo rakaega, oiji so kejiga teegayoŋ, iŋoyoŋunde maŋ wombuŋgone buŋo waperu wakiega, oiji iŋo kejiga teega.” ");
INSERT INTO mlh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Oŋu yajime kiŋariŋpuine yoŋo wareru iŋi weubuŋ, “Farisi (Kadi buŋore yameŋyameŋ) yoŋo buŋo oi manebi yabeko maŋyaŋuŋ sembeaga, oi manege me mata?” ");
INSERT INTO mlh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Weubi iŋi bokirieya, “Nonji wiki sosowo nonde Sombuŋ Mamaji so sariya, oi goduineke unugabemiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jibu, oi boke yabeinebi. Yoŋo ‘Ŋiŋigo jiŋokombi oga yabekimiŋ,’ miegobiyoŋ, yoŋoyaŋunde jiŋoji kobega. Jiŋokombi moji jiŋokombi ogoine mo meineo roru ogagaiŋ ine, yokoji moko yoŋgo rakaru yapeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Oŋu bokirieme Pitaji ojiya, “Soso buŋo ore fuŋine soine mitaniŋgande manekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Oŋu ojime Yesuji miya, “O ogopune, ŋoŋo oŋuakoŋ jikigaru mamaneŋaŋuŋ fiine so fukega me? ");
INSERT INTO mlh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ŋiji ya sosowo nome maŋineo rakaega, oi beuineo rakaru sakibe wakiega. Oi mane mukugobi me mata? ");
INSERT INTO mlh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","“Oi wakiegayoŋ, buŋo maŋ wombuŋineone waperu miineo wakiega, oiji kejiga teega. ");
INSERT INTO mlh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ŋiŋigo maŋ wombuŋyaŋuŋgone ya yo iŋiine fukeru wapeega: Buŋo sembene manesuku kipe seroŋ baku ŋiŋigo yabebi komeinde maneegobi. Bobojibu eru boesau eninde maneegobi. Ya kiaŋ roiŋgo maneegobi. Migoiga buŋo ikoine miiŋgo maneegobi. Ŋadiqoqo buŋo miku Anutu igosisi eninde maneegobi. ");
INSERT INTO mlh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ya oŋuineji ŋiŋigo kejiga yareegayoŋ, meyaŋuŋ so jureru uqo munjaŋ noegobi, oiji ŋi mo so kejigaega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesuji Genesaret moreŋ bokeru siti tinayakuŋ Taia Tiro eru Saidon yokore distrik tinaine Fonisia ore maŋineo raya. ");
INSERT INTO mlh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Rako Keinan ŋigo, moreŋ ore rauine moji wareru Yesu karieru iŋi oŋgaku ojiya, “Ofoŋ, Deiwidre osigida, ŋonemaiŋ enareigoŋ! Gemoji odune bapeboriŋ eteko joiserereŋ soguine maneega.” ");
INSERT INTO mlh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Oŋgaku ojiyayoŋ, Yesuji buŋo mo so bokirieya. Oŋu fukeko kiŋariŋpuineji wareru iŋi bapakareru ojibuŋ, “Ŋigo oi oŋga kuyo eku ŋadinoŋuŋgo warega ore iŋo bapigande raine.” ");
INSERT INTO mlh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Oŋu ojibi bokirieya, “Mamaneji Israel kufufunde lama jibugakiine yoŋo akoŋ munaŋ qa yarebemiŋ ore eru sore nume warego.” ");
INSERT INTO mlh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Oŋu bokirieme ŋigo iŋoji maŋfuŋgo wareru pedaberu ojiya, “Ofoŋ, go bapi nuigoŋ!” ");
INSERT INTO mlh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Oŋu ojiyayoŋ, Yesuji iŋi bokirie teya, “Mata, odumade yoŋore pigone poroŋ roru qoro yarebeneŋ so sagaiŋ. Juda niŋo kotupunoŋuŋ ŋoŋore tina qoro miegobeneŋ. Nonji rone Juda ŋiŋigo bapi yabebe kantri goine ŋoŋoji qoro oŋuine odigaru goinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bokirie teyayoŋ, ŋigoji miya, “Ofoŋ, oi soine manegoyoŋ, qoro mendaine yoŋo oŋuakoŋ rauyaŋunde uqo ŋeŋeone uqo kuŋgaŋine wakiko noegobi.” ");
INSERT INTO mlh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Oŋu mime Yesuji iŋi ojiya, “O ŋigo, gore mamanesiŋ oi soguine. Ore eru karie narege ore fori bio fukeiŋ.” Oŋu ojime maneko oduineji aua oo akoŋ fiaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuji moreŋ oi bokeru wareru Galili obu jogunde qaŋaŋineo waperu tukuo roperu waki ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ŋeko ŋiŋigo kubu sogoji iŋoreo wareru ŋiŋigo yo iŋiine oga yabebuŋ: Puriŋ eru ŋiŋigo jiŋokombi, goine mekufuyaŋuŋ poporiine, goine noŋguŋ eru goine jibe kokoine bayabeme gobuŋ, yoŋo oga yaberu Yesure kufu fuŋgo rua yabebi bobiaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bobiaŋ yabeme noŋguŋ ŋiŋigo yoŋo buŋo mibi mekufuyaŋuŋ poporiine yoŋo fiaru poretiŋgabi puriŋ yoŋo kufu oderu ra warebi jiŋoyaŋuŋ kobekiine yoŋo jiŋo piku ŋonebi ŋiŋigo kubu yoŋo oi ŋone wara eku Israel noŋunde Anutu miteŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuji kiŋariŋpuine oŋga yareme iŋoreo warebi iŋi yajiya, “Nonji ŋiŋigo kubu sogo yo yoŋore beusembe manego. Yoŋoji nondeo wareru una yokaomo go wapebi uqoyaŋuŋ matae foreme ŋonego. Kadio raku gogu botuineo jiŋoyaŋuŋ putarieme sisibiri egu bofukenimiŋ ore yoŋo mo sore yabeiŋgo so manego. Ore eru yoŋo uqo gume yabeiŋgo manego.” ");
INSERT INTO mlh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Oŋu yajime kiŋariŋpuine yoŋo bokirieru iŋi ojibuŋ, “Moreŋ buroineo yoo niŋo uroone uqo munjaŋ soguine bofukeru ŋiŋigo kubu sogo yo gume yabenobeŋ?” ");
INSERT INTO mlh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Oi maneru Yesuji iŋi weu yareya, “Ŋoŋoreo poroŋ wojimu pega?” Weu yareme “Poroŋ 7 eru jembaeŋ kokiine goine pega,” miku ojibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ojibi Yesuji ŋiŋigo kubu sogo oi moreŋgo waki ŋeninde mitiga yareme waki ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Waki ŋebi poroŋ 7 eru jembaeŋ oi roru Anutu oŋga wosiru daŋge miku bajiru kiŋariŋpuine yareme yoŋoji oi ŋiŋigo kubu so boroiŋga yarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Boroiŋga yarebi noku no gaba ebuŋ. No gaba eku uqo mobeine bokebi ŋeya, oi jambe 7 oo qojugabi rakaru puseya. ");
INSERT INTO mlh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ŋi uqo nobuŋ, yoŋore jare oi 4,000. Ŋigo odumade yoŋore jare oi so robuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuji ŋiŋigo kubu sogo sore yabeme rabi iŋoyaŋune ogâo roperu Magadan moreŋgo raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi (Kadi buŋore yameŋyameŋ) eru Sadusi (Soriŋ giore yameŋyameŋ) goineji Yesureo wareru buŋore budunji poreiŋ ore esoigaru iŋi weu tebuŋ, “Go minde Sombuŋgone mosi qoqowirie mo fukeko ŋonekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Oŋu weu tebi iŋi bokirieya, “Ŋoŋo wegi rakaiŋ eme oo iŋi miegobi, ‘Qonikinji boroŋgaga ore yogo wegi fiine fukeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","“Oŋuakoŋ kae fufurere akoŋ iŋi miegobi, ‘Qonikinji boroŋgame kuanji goburega ore kue gbiŋ qaiŋ.’ Oŋu oŋu miku qonikinde kamasi ŋoneru kue wegire fuŋne soine osoeegobiyoŋ, damaŋ gogobeneŋ, ore mogeine osoeninde so manegobi. Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ŋiŋigo kubu sembene moreŋgo goku jikiboti eegobi, yoŋo Anuture moge fukeiŋgo yameŋ keegobiyoŋ, Anutuji kajeqouŋ ŋi Jonare moge yare foreme moge goine so jikigaru ŋaduiŋ.” Oŋu bokirieru boke yaberu mogobe raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesuji kiŋariŋpuine yoŋoke obu joguŋ petigaru aribe roperu tebu roninde niga yabeya, oi ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Oi ŋonebi Yesuji iŋi yajiya, “Ŋoŋo Farisi eru Sadusi pati kubu yoyoka yoŋore momoki eru jama saboiyaŋuŋ ore eru sisiŋaŋ eku goinebi. Oi fiine akoŋ so osoeru ŋadi gabi yoŋoji yist oŋuine sogueru bosembea ŋabenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yajime buŋo ŋadiine oi so mane taniŋgaru botuyaŋuŋgo iŋi mimane ebuŋ, “Niŋo poroŋ so roku waregobeneŋ. Ore eru miga me uruŋu?” ");
INSERT INTO mlh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Oi mimane ebi kajeineo rakame iŋi yajiya, “O ŋoŋo mamanesiŋ-ŋaŋuŋ mendaine, wamore ‘Poroŋ so rogobeneŋ,’ miku ŋoŋo-ŋaŋe mimane egobi? ");
INSERT INTO mlh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nonde fuŋne oi wamore so mane mukugobi? Nonji poroŋ 5 oi 5,000 yoŋore bajibe ore mobeine qojugakabi jambe wojimuo rakaru puseya? Oi niga ŋabega me mata? ");
INSERT INTO mlh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Oŋuakoŋ poroŋ 7 oi 4,000 yoŋore bajibe ore mobeine qojugakabi jambe wojimuo rakaru puseya? Oi niga ŋabega me mata? ");
INSERT INTO mlh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Noŋ poronde buŋo so migo, oi uruŋu eru so mane mukugobi? Nonji poroŋ ore matayoŋ, Farisi eru Sadusi pati kubu yoŋore momoki eru jama saboi osoeru ŋadi ganinde ore migo.” ");
INSERT INTO mlh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Oŋu yajime oo akoŋ buŋore fuŋne iŋi mane taniŋgabuŋ, “Aha! Flaua bobosogue yistre sisiŋaŋ ekimiŋ ore so migayoŋ, Farisi pati eru Sadusi pati yoŋore buŋo bobojibu ŋadi ganimiŋ ore miga.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuji Sisaria Filipai taonde bembeŋgo raru oo kiŋariŋpuine iŋi weu yareya, “Ŋiŋigoji Sombuŋ eru morende Ŋi foriine nonde uruŋu miegobi? Noŋ mo fukego?” ");
INSERT INTO mlh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Weu yareme bokirieru iŋi ojibuŋ, “Goineji ‘Go Jon Mitimeso ŋi fukege,’ miegobiyoŋ, goineji ‘Go Elaija fukege,’ miegobi eru goineji jikigaru iŋi miegobi, ‘Go Jeremaia me kajeqouŋ ŋi raŋgbaŋine yoŋoreone mo fukege.’” ");
INSERT INTO mlh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Oŋu ojibi iŋi weu yareya, “Eme ŋoŋo-ŋaŋe nonde uruŋu miegobi? Noŋ mo fukego?” ");
INSERT INTO mlh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Weu yareme Saimon Pitaji bokirieru ojiya, “Go Munaŋqoqo Rauine Kristo eru gogo Rauine Anuture Made fukege.” ");
INSERT INTO mlh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Oŋu ojime Yesuji bokirieru iŋi ojiya, “O Saimon Jonare made, moreŋ ŋi dari fuineke moji matayoŋ, nonde Mama Sombuŋ kaeo goga, iŋoji buŋo oi go barariŋga guya. Ore eru goji kiwaqawaineke fukege. ");
INSERT INTO mlh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Noŋ iŋi gajibe mane: Go Pita (noŋunde buŋoo oŋgiŋ) fukende nonji oŋgiŋ ore paio maŋkekerisie kufufuŋnere otuŋ ruabe kitiŋ yabende maŋyaŋuŋ bobiaŋgaru sanaŋgaru dimanimiŋ. Goji oi siŋaŋ yabende kome Rauineji oi misoŋ kaere sa mendigo pore yabeiŋgo embimbiŋgaiŋ. Gemokaku goine yoŋore usunji oŋuakoŋ oi ketotieru gbiŋ eyarenimiŋgo embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“Nonji Sombuŋ qorumaŋinere ki mendaine yoyoka garebemiŋ. Go moreŋgo agiburaŋ kipende oiji Sombuŋ kaeo oŋuakoŋ kipekiine peiŋ. Go moreŋgo agiburaŋ bokeru piruende oiji Sombuŋ kaeo oŋuakoŋ piruekiine peiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Oŋu miku Munaŋqoqo Rauine Kristo fukeya, oi totogo mibi moji egu manenimiŋ ore kiŋariŋpuine yoŋore agi sanaŋine ba yareya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Damaŋ oone Yesuji fuŋgaru kiŋariŋpuine yoŋo buŋo iŋi barariŋga yareru miya, “Nonji Jerusalem raru joiserereŋ afaine mata manebemiŋ. Kantrire minebobo, soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji nubi komebemiŋ. Komebe una yokaomo fukeko komegone pakerebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yesuji oŋu mime Pitaji keporeme qaŋaŋineo raru fuŋgaru qomuku teru iŋi ojiya, “O Ofoŋ, oi damaŋ mogo egu fuke gareiŋ ore Anutuji dobu kipe gareine.” ");
INSERT INTO mlh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Qomuku teme kirieru Pita iŋi miteya, “Go buŋo manesuge, oi Anuture buŋo matayoŋ, moreŋ ŋiŋigo eru Satan aŋiyaŋuŋ. Go nonde kadi kejigaiŋgo manende maŋneji sembeaga. Ore eru Satan, go bio muŋambe yoo nonde jiŋo maione use!” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Damaŋ oo Yesuji kiŋariŋpuine buŋo iŋi yajiya, “Moji nonde ŋadio wareiŋgo manega, iŋoji iŋoyoŋunde maŋ sakire aŋi sanaŋine sembene ŋadi game ‘Biŋe gariine roru warega,’ miku misombeŋ babi joiserereŋ oi osigaeine. Yobiŋ oi maripoŋgo komeiŋ ore so maneku karieru noŋ boyobe nuru wareine. ");
INSERT INTO mlh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Moji gogoine iŋoyoŋunde roru sabareku iŋoyoŋere aŋigo goga, iŋoji gogoine foriine kipeme jibugaiŋ. Jibugaiŋyoŋ, moji morende gogoine nonde eru kisiŋgaru nareiŋ, iŋoji gogo foriinere kadi bofukeru sanaŋgaru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Moji kaeine kaeine yoŋore yareya sosowo poreko biŋeine ra foreme mande gogoine bojibugaru keoma goku komeko Anutuji buŋoine mitarime iruineji sibirigako so sagaiŋ. Meboine oiji manjeri so eteiŋ. Mata yobu! Sosowo noŋuŋ qodunoŋuŋ kipekimiŋgo embimbiŋgakimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Sombuŋ eru morende Ŋi foriineji jiki Sombuŋ mimerereŋ tiriine yoŋoke yoo wakibi Mamainere kuririquraŋ ŋoneru popurenimiŋ. Damaŋ oo moakoŋ moakoŋ noŋunde eebobo osoeru geoine me furiine ore so noreiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Yoo dimagobi, ŋoŋore botugone goineji Sombuŋ eru morende Ŋi foriineji kiŋ ofoŋ fuke taniŋgaiŋ, oi ŋone mukunimiŋ. Gariine goku komere joiserereŋ so manebi fukeko oi ŋonenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Una 6 tarime Yesuji Pita, Jeims eru Jeims gboine Jon oga yaberu yoŋoyoŋe akoŋ tuku joroine mogo roperu taineo gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gokabi jiŋo maiyaŋuŋgo dimako Yesure saki kamasiji qowirieru fuŋine mo fukeya. Jiŋo maiineji wegi jiŋoine oŋuine tamaeko marikuineji gbagbataeŋine fukeru tatamake fukeya. ");
INSERT INTO mlh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Oŋu fukeko ŋonebi Moses eru Elaija yokoji fuke yareru Yesuke buŋo buŋo mimane ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mimane ebi Pitaji fuŋgaru buŋo miku Yesu iŋi ojiya, “Ofoŋ, niŋo yoo manjeri manegobeneŋ. Ore eru aŋigo manege ine, nonji soine ako yokaomo babemiŋ. Gore mo, Mosesre mo eru Elaijare mo.” ");
INSERT INTO mlh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Oŋu ojiru dimako kuaŋ gbagbataeŋine kuririquraŋineke moji wakiru konuineo komoŋ yabeko ore maŋineone buŋo maru mo iŋi wakime manebuŋ, “Ŋi yo nakene yoro made. Nonde maŋ aŋi soguineji iŋoreo pega. Ŋoŋo iŋore buŋo maneru goinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kiŋariŋ yoŋo buŋo oi maneru gburugburu yabeko daberu moreŋgo wakiru kokoiyaŋuŋ afaine mata manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Oŋu manebi Yesuji yoŋoreo wareru sakiyaŋuŋ bouaku iŋi yajiya, “Ŋoŋo pakereniŋ. Kokoiŋaŋuŋ so maneinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Buŋo oi maneru piku pakereru yoyoka oi so ŋone yapebuŋyoŋ, Yesuji akoŋ dimako ŋonebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tukuone pagaŋgo wakiru Yesuji iŋi mitiga yareya, “Ŋoŋo ya ŋonegobi, ore biŋeine oi ŋiŋigo mo so yajiinebi. Sombuŋ eru morende Ŋi foriineji komegone pakereko ore ŋadiineo oi soine mitaniŋgaru gonimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Oŋu mitiga yareko kiŋariŋpuine yokaomo yoŋoji Yesu iŋi weu tebuŋ, “Kadi buŋore qaqaji yoŋoji buŋo iŋi oi wamore miegobi, ‘Ŋi Elaijaji bonieru Sombuŋgone wakiko Munaŋqoqo Rauineji iŋore ŋadio fukeiŋ?’” ");
INSERT INTO mlh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Weu tebi bokirieru iŋi yajiya, “Elaijaji bonieru wakiru fukeru gogo sosowo bobiaŋgaiŋ. Buŋo oi foriineyoŋ, ");
INSERT INTO mlh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","nonji iŋi ŋajibemiŋ: Elaijaji wakiru fukeyayoŋ, oi ŋoneru fuŋine so mane mukubuŋyoŋ, ŋiŋigo yoŋo oi yoŋoyaŋunde aŋi boyoberu kosa etebuŋ. Oŋuakoŋ Sombuŋ eru morende Ŋi foriine oŋuakoŋ kosa etebi Juda minebobo kekesuesueyaŋuŋke yoŋore meo rakaru joiserereŋ maneiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Elaijare oŋu miku foriine Jon Mitimeso ŋire buŋo yajiya, kiŋariŋ yoŋoji oi oŋu mane taniŋgabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu eru kiŋariŋ yokaomo yoŋoji tukuone wakiru ŋiŋigo kubu yoŋoreo warebi ŋi moji Yesure maŋfuŋgo wareru dikanji keteru iŋi ojiya, ");
INSERT INTO mlh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ofoŋ, goji madene ŋonemaiŋ eteigoŋ. Jibe bako rondiŋgaru wakiru qame isiŋbiriŋ qaku joiserereŋ kokoine maneega. Damaŋ kokoine rondiŋgaru misigo me obuo rakaega. ");
INSERT INTO mlh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nonji iŋo ogagaru kiŋariŋpugo yoŋoreo waregoyoŋ, yoŋoji iŋo bobiaŋganimiŋgo embimbiŋgagobi.” ");
INSERT INTO mlh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Oŋu ojiko bokirie teru miya, “Yei! Morende ŋiŋigo qoqomuku eru iŋgoŋmaŋgoŋineke, damaŋ wojimu ŋoŋoke goku qataŋ ŋabebe Anutu so manesiŋ gabi joiserereŋ maneebemiŋ? Iŋo ogaru nondeo yoo wareniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Oga garu warebi Yesuji gemo oi miteko bokeru rame madeji damaŋ oo akoŋ fiaya. ");
INSERT INTO mlh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Fiame kiŋariŋpuine yoŋo oi ŋoneru yoŋoyaŋekoŋ Yesureo wareru ŋeku iŋi weu tebuŋ, “Niŋoji wamore oi niŋonoŋe akoŋ yobeiŋgo embimbiŋgagobeneŋ?” ");
INSERT INTO mlh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Weu tebi iŋi yajiya, “Mamanesiŋ-ŋaŋuŋ mendaine fukega ore eru oi yobeiŋgo embimbiŋgagobi. Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Mamanesiŋ-ŋaŋunde fori oi yojuŋ korunde so ena ine, ŋoŋoji soine tuku yoore Rau iŋi mitiganobuŋ, ‘Go tuku oi bomukuru pakereru raru aribe aroo rua.’ Oŋu miku manesiŋ gabi ore so fukeko aroo raiŋ. Anutu manesiŋ gabi dobe ŋabeko ya more so embimbiŋganimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Gemo kamasiine oŋuine oi oŋga wosiru uqo sowo goku yobekimiŋ. Ya furuine mo ebeneŋ iŋoji so waperu raiŋ. Oŋu.) ");
INSERT INTO mlh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesuji kiŋariŋpuine yoŋoke moko Galili prowins maŋineo roregaru kadio rabi Yesuji buŋo koruŋ iŋi yajiya, “Anutuji Sombuŋ eru morende Ŋi foriine oi moreŋ ŋiŋigo yoŋore meo rua teko rakaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Rakame iŋo qabi komeiŋ. Komeme una yokaomo fukeko komegone pakereiŋ.” Kiŋariŋpuineji oi maneru maŋyaŋunji yobiŋgame beusembe manebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuji kiŋariŋpuine yoŋoke Kaperneam taoŋgo wapebi boji sorinde takis roro ŋi yoŋoji Pitareo wareru iŋi weu tebuŋ, “Ŋoŋore qaqajiji boji sorinde takis ruaiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Weu tebi “Oŋ!” miya. Ore ŋadio Pitaji pi maŋineo ropeko Yesuji buŋo fuŋfuŋgaine iŋi weu teya, “Saimon, go uruŋu manesuge? Uri yoŋo rojiki-bajikire takis eru takis goine (custom, revenue) oi morende kiŋ ŋi koito yoŋore ruaegobi? Kantri rauine noŋuŋ me kotuine yoŋoji oi ruabi qojugaegobi?” ");
INSERT INTO mlh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Oŋu weu teme bokirieru “Kotuine yoŋoji,” miya. Oŋu miko Yesuji iŋi ojiya, “Oŋu ruaegobi ore eru kantri rauine noŋuŋ oi ruakimiŋ ore so, so fukegobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Oŋu fukegobeneŋyoŋ, takis so ruabeneŋ ŋi yoŋore manji egu sembeaiŋ ore go raru nigiŋ hawigo obu joguŋgo bokeigoŋ. Bokeru jembaeŋ fuŋfuŋgaine poreru romiŋ, ore mauine boindaŋgaru moneŋ koruŋ oo bofukemiŋ. Moneŋ koruŋ oi ŋi yoyoka nokunde takisre so. Go oi roru yareru oiji nonde eru gakere takis ruaigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Damaŋ oo kiŋariŋ yoŋoji Yesureo wareru iŋi ojibuŋ, “Sombunde qorumaŋ maŋgo moji ropekiine ega?” ");
INSERT INTO mlh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Oŋu ojibi odumade mendaine mo oŋga teme wareme botuyaŋuŋgo ruame dimaya. ");
INSERT INTO mlh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Dimame iŋi miya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Maŋ-ŋaŋuŋ so kerisieru odumade oŋuine so fukenimiŋ ine, ŋoŋo damaŋ mogo Sombunde qorumaŋgo so ropenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","“Ore eru moji iŋoyaŋune ba wawaki eku odumade oŋuine fukeiŋ, iŋoji Sombunde qorumaŋ maŋgo ropekiine fukega. ");
INSERT INTO mlh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Moji odumade yo iŋiine mo nonde tinao keporeru maŋgo eteiŋ, iŋoji noŋ kepore nuiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesuji jikigaru iŋi miya, “Odumade yo iŋiineji manesiŋ nugobi, moji yoŋoreone mo suruyoiŋ eteko agiburaŋ eiŋ, ŋi oiji yobiŋ ropekiine bofukeiŋ. Anutuji yobiŋ ore geoine uruŋu oteko soineo fukena? Karoŋaŋ oŋgiŋ ubeineo kiperu koe botuineo bokebi rakana, oiji afaine fukena. ");
INSERT INTO mlh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Agiburande babotikiji afaine akoŋ fukeega. Ore eru moreŋ ŋiŋigo ŋoŋore ‘Yei!’ beusembe manego. Moji babotiki sabareiŋgo embimbiŋgaegayoŋ, mo moji goine suruyoiŋ eyareko agiburaŋ enimiŋ, iŋore ‘Yei!’ oŋga joroku kuyogo. Joiserereŋ ropekiineji iŋore paio ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Megoji me kufugoji agiburaŋ einde suruyoiŋ egareiŋ ine, oi ketigaru bokeigoŋ. Ketigaru bokeru meti me kufuti goku gogo sanaŋine bofukeru igoriŋ bofukemiŋyoŋ, kufu mego yoyokake gokande jiki misi korugo bokebi egu rakamiŋ. Koru misiine oi tatariine tomiri jaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Oŋuakoŋ jiŋogoji agiburaŋ einde suruyoiŋ egareiŋ ine, oi unugaru bokeigoŋ. Unugaru bokeru jiŋogo moakoŋke goku gogo sanaŋineo roperu igoriŋ bofukemiŋyoŋ, jiŋogo yoyokake gokande misi korure misigo bokegubi egu rakamiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ŋiŋigo mendaine yo yoŋoreone mo egu ba wakinimiŋgo ŋoŋo sisiŋaŋ einebi. Nonji buŋo iŋi ŋajibe maneniŋ: Yoŋore rubobo mimerereŋpuji Sombuŋ kae oo nonde Sombuŋ Mamare maŋfuŋgo goku jiŋo maiine jijiki ŋoneegobi. Ore eru mipemiriŋ so eyareinebi. ");
INSERT INTO mlh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Sombuŋ eru morende Ŋi foriineji ŋiŋigo jibugabuŋ, yoŋo qowirie yabeme seŋgiŋbaŋgiŋ fukenimiŋ ore wakiya.) ");
INSERT INTO mlh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ŋoŋo buŋo yoore uruŋu manesugobi? Ŋi more lamapu 100 gobi yoŋoreone moji jibugaru tiŋtuŋ rako rauineji uruŋu eiŋ? Iŋoji 99 oi tukuo boke yaberu raru moakoŋ tiŋtuŋ raya, iŋore baaru raiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Baaru raru goku bofukeiŋ ine, nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Iŋoji 99 tiŋtuŋ so rabuŋ, yoŋore damaŋ oo kokoine so jerieiŋyoŋ, moakoŋ ore mokemoke yobu jerieru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ore so ŋoŋore Mama Sombuŋ kaeo goga, iŋoji ŋiŋigo mendaine yo yoŋoreone moji jibugaru misi korugo so rakaiŋgo maneega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Maŋkekerisie ogogoji agiburaŋ egareiŋ ine, go iŋoreo raru jiŋo maiineo maigaku kadi tiriya, oi oduigoŋ. Oŋu ende buŋogo maneru rurumaŋgo raiŋ ine, goji ogogo gbiŋ etende moke maŋmoakoŋ eru gonimi. ");
INSERT INTO mlh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Oŋu ende buŋogo maneru ore rurumaŋgo so raiŋ ine, goji jikigaru ogo moakoŋ me yoyoka oga yaperu iŋoreo rainebi. Biŋe Qurande buŋo yoore so oŋu eigoŋ, ‘Buŋo sosowo oi ŋiŋigo yoyoka me yokaomoji kitiŋgaku mibi sanaŋgaiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","“Oŋu ebi buŋoyaŋuŋ maneru ore rurumaŋgo so raiŋ ine, goji maŋkekerisie kufufunde minebobo yoŋo yajinde iŋoke mimane einebi. Mimane einebiyoŋ, yoŋore buŋo rurumaŋgo oŋuakoŋ so raiŋ ine, oi totogo mibi ruge fukeme maŋkekerisiere yauraine oŋuine eteru goigoŋ. Takis eaduyaŋuŋke robi misombeŋyaŋuŋ baegobi, ore kamasi oŋuine oi bokende sakibe goine. ");
INSERT INTO mlh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Ŋoŋoji agiburaŋ moreŋgo kipenimiŋ, oi sosowo Sombuŋ kaeo oŋuakoŋ kipekiine peiŋ eru agiburaŋ moreŋgo bokeru piruenimiŋ, oi sosowo Anutuji bokeko Sombuŋ kaeo oŋuine akoŋ peiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Jikigaru buŋo iŋi ŋajibe maneniŋ: Moreŋgo ŋoŋoreone yoyokaji buŋo oi me oi ore maŋmoakoŋ eru oŋga wosinimire buŋo kipenimi, nonde Mama Sombuŋ kaeo goga, iŋoji oi bokirie yateme rauganimi. ");
INSERT INTO mlh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Oi yoore eru: Ŋiŋigo yoyoka me yokaomoji nonde tinao oo me oo tumaŋganimiŋ, nonji oo yoŋore botugo gobemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Damaŋ oo Pitaji Yesureo wareru buŋo iŋi ojiya, “Ofoŋ, ogoneji agiburaŋ enareega, nonji oi ate wojimure so bokebe sagaiŋ? Ateine 7 oi kokoine. Ore so bokebe sagaiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesuji oi maneru iŋi bokirie teya, “Ateine 7 matayoŋ, 70 taims 7 oi bokende sagaiŋ. Nonji oŋu gajigo. ");
INSERT INTO mlh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ore fuŋine oi iŋi mitaniŋgabemiŋ. Sombunde qorumaŋ oi kiŋ ŋi koitore so ruabe iŋi fukega: Kiŋ koitoji kiŋaŋqoqopuine oŋga yareko moneŋyaŋuŋ siŋaŋ gabuŋ, ore buru papia odubi botiŋgaiŋgo yameŋ keya. ");
INSERT INTO mlh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","“Oŋu fuŋgaru moneŋine ore sunduine osoeru botiŋgabi oo ŋi mo ogaru warebi iŋore jiŋoo dimaya. Tifeine oi 10 milyon Kina iŋoreo peya. ");
INSERT INTO mlh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Oi peyayoŋ, tifeine oi bajiiŋ ore moneŋine so sagako embimbiŋgaya ore eru soguineji dimaku iŋi mitigaya, ‘Meboine pega, oi sosowo furiine banimiŋ ore ruainebi. Oi eru ŋigo madeine oi oŋuakoŋ furiyaŋuŋ banimiŋ ore ruabi moneŋ wareko oiji tifeine oi bajiinebi.’ ");
INSERT INTO mlh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Oŋu mitigako kiŋaŋqoqoineji maŋfuŋgo wakiru dikanji keru daberu iŋi weu teya, ‘Go manjo so eru maneku karieru odi nunde gore tife sosowo oi soine baji garebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Oŋu weu teko soguineji kiŋaŋqoqoinere beusembe maneru tifeine oi mukuru bokeru pirueko wakiya. ");
INSERT INTO mlh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Wakiyayoŋ, sakibe raru oo kiŋaŋqoqo ogoine mo bofukeru ŋoneya. Iŋore tife oi giobobo 100:re furi (Kina 2,000) ore so iŋoreo peya. Oi ŋoneru ubeine sanaŋine roru bopogaru iŋi ojiya, ‘Nonde tife goreo pega, oi baji naremiŋ me?’ ");
INSERT INTO mlh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Oŋu ojime kiŋaŋqoqo ogoineji maŋfuŋineo wakiru dikanji keru daberu iŋi weu teya, ‘Go manjo so eru maneku karieru odi nunde gore tife oi soine baji garebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Oŋu ojiyayoŋ, iŋoji oi takigame raru mimitari ŋi majistreit ojime roru kiperu witi pigo ruabi ŋeko tifeine baji forebi wakiiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ya oi fukeko kiŋaŋqoqo ogopuineji kamasi oi ŋoneru maŋyaŋuŋ jajabame beusembe maneru raru ore sunduine sosowo oi soguneyaŋuŋ ojibi maneya. ");
INSERT INTO mlh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Oi maneru soguneyaŋunji kiŋaŋqoqo fuŋfuŋgaine iŋo oŋga teme jiŋoineo wareme iŋi ojiya, ‘Go gio bobo ŋi sembene! Go tifego mukuru bokemiŋgo weu narende nonji oi sosowo boke garego. ");
INSERT INTO mlh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nonji ŋone guru emboŋ eru ŋonemaiŋ garebe goji oŋuakoŋ ore so kiŋaŋqoqo ogogo ŋonemaiŋ etende sagana.’ ");
INSERT INTO mlh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Soguneineji oŋu ojime maŋine rigaŋgame kiŋaŋqoqo iŋore buŋo mitariku nigiŋ pire siŋaŋ yoŋore meo rua teko joiserereŋ kokoine maneru ŋeiŋ. Oo ŋeku tifeine kiŋ koitore peya, oi sosowo baji foreko wakiiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Soso buŋo yoore foriine oi iŋi: Ŋoŋo moakoŋ moakoŋ ogoŋaŋunde agiburaŋ maŋ-ŋaŋuŋgo so bokenimiŋ ine, nonde Sombuŋ Mamaji oŋuakoŋ buŋo ore so eŋareiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuji buŋo oi miforeku Galili prowins bokeru Jordan obu petigaru aribe raru boyoberu wakiru moke obu oi petigaru Judia prowinsgo wareya. ");
INSERT INTO mlh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wareme ŋiŋigo kubu sogoji boyoberu warebi oo bobiaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bobiaŋ yabeko Farisi (Kadi buŋore yameŋyameŋ) goineji iŋoreo wareru buŋore budunji poreinde eesoi eteku iŋi weu tebuŋ, “Ŋiji fuŋine oi me oi ore eru ŋonuŋine bokeiŋ, oi Kadi buŋo odureiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Weu tebi bokirieru iŋi yajiya, “Bobofuke Rauineji fuŋfuŋgaineone oi ‘Ŋi eru ŋigo gonimiŋ ore bofuke yabeya.’ Biŋe buŋo oi osebuŋ me mata? ");
INSERT INTO mlh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Bofukeru iŋi miya, ‘Ore eru ŋiji maŋgomamaine boke yaperu ŋonuŋineo raru qakotame yokoji saki moakoŋ fukeru gonimi.’ Buŋo oi osebuŋ me mata? ");
INSERT INTO mlh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Oŋu eru jikigaru yoyoka so fukegobireyoŋ, saki moakoŋ fukeru gonimi. Anutuji ŋi eru ŋigo qodure yapeya, ŋiŋigo moji yoko so boroiŋ yapeine.” ");
INSERT INTO mlh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Oŋu yajiko iŋi ojibuŋ, “Ŋiji bokeru boboke roroinde papia quraŋgaru ŋonuŋine soine bokeiŋ. Mosesji wamore buŋo oŋu mitiga noreya pega?” ");
INSERT INTO mlh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Oŋu ojibi iŋi miyareya, “Mosesji maŋyaŋuŋ sanaŋine fukeya ore eru ŋonuŋine bokeinde buŋo oŋu mitigayayoŋ, fuŋfuŋgaineo oŋu so peya. ");
INSERT INTO mlh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nonji iŋi ŋajibe maneniŋ: Ŋigoji jikiboti so eme jibu yoberu ŋigo mo roiŋ, iŋoji boesau eiŋ. Moji ŋigo bobokeine roiŋ, iŋoji boesau eiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesuji oŋu yajiko kiŋariŋ yoŋo ojibuŋ, “Ŋoe ŋonuŋ botuyakuŋgo boboke roroinde agi oŋu pega ine, ŋoe ŋonuŋ so fukebeneŋ sagaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Oŋu mibuŋyoŋ, Yesuji iŋi bokirieya, “Ore buŋoine qaji ŋarego, ŋiŋigo sosowoji oi yoŋoyaŋunde sabareku ore so soine so einebiyoŋ, Anutuji buŋo oi ŋiŋigo goine yoŋore yareya, yoŋoji akoŋ ore so einebi. ");
INSERT INTO mlh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ore fuŋine oi iŋi: Goineji maŋgo beu maŋineo fukeru oone fuŋgaru ŋoe ŋonuŋ fukekiminde so manegobi. Goineji ŋiŋigo yoŋo sakiyaŋuŋ ketigaru kesosoe yarebi ŋoe ŋonuŋ fukekimiŋ ore so, so fukegobi. Goineji Sombuŋ qorumaŋinere eru ŋoe ŋonuŋ so fukekiminde buŋo mikiperu buŋoyaŋuŋ oi boyobeegobi. Moji buŋo oi me oi mane sabareku boyobeiŋ ore so fukega, iŋoji ore so eine.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Damaŋ oo goineji odumade memenda oga yaberu Yesuji meine qoruyaŋuŋgo ruaru oŋga wosiiŋ ore iŋoreo warebuŋyoŋ, kiŋariŋ yoŋoji ŋiŋigo oi miqomuku eyarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Oŋu ebi Yesuji iŋi miya, “Odumade mendaine yoŋo soine boke yabebi nondeo wareniŋ. Sombunde Rauji ŋiŋigo oŋuine oi qorumaŋine yareme biŋe ganimiŋ. Ore eru yoŋo so kipe yabeinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Oŋu miku meine qoruyaŋuŋgo ruaru boke yaberu mogobe raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Damaŋ mogo ŋi moji Yesureo wareru iŋi weu teya, “Qaqaji, nonji eebobo fiine uruŋu eru gogo sanaŋinere biŋe fukenobo?” ");
INSERT INTO mlh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Weu teko iŋi ojiya, “Eebobo fiine uruŋu, wamore oŋu weu narege? Moakonji fiine fukega. Gogo sanaŋineo ropemiŋgo manemiŋ ine, go mimipaŋ buŋo reŋgaru goigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Oŋu ojiko maneru iŋi miya, “Wamo mimipaŋ buŋore mige?” Mime Yesuji oi maneru ojiya, “Buŋo yoore: ‘Mo so qande komeine. Boesau so eigoŋ. Ya mo kiaŋ so roigoŋ. Migoiga so eteigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Maŋgo mamago araŋ ba yateeigoŋ,’ eru ‘Gake manji jojoko eege, ore so ŋiŋigo sosowo manjoko eyareeigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Oŋu ojiko ŋi jeŋonji iŋi miya, “Oi sosowo reŋgaru go wapeboŋ. Wamore moke embimbiŋgago?” ");
INSERT INTO mlh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Oŋu miko Yesuji ojiya, “Go kuririke gomiŋgo manemiŋ ine, go raru mebo yago furiine banimiŋ ore ruande moneŋ wareko ŋiŋigo wakiqoqoine yareigoŋ. Oŋu ende mebo yago yasogo (juŋe boreŋ, milyon Kina oŋuine) oi Sombuŋ kaeo pe gareiŋ. Oŋu eru noŋ boyobe nuru wareigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Oŋu miyayoŋ, jeŋonji buŋo oi maneru meboine kokoine peya ore eru beusembe maneru jiŋo maiine posoeru mo bokeru raya. ");
INSERT INTO mlh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bokeru rako Yesuji kiŋariŋpuine iŋi yajiya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: ‘Yei!’ Ŋiŋigo tinabiŋeyaŋuŋke yoŋoji Sombunde qorumaŋgo ropenimiŋgo yobiŋgaru qiqu enimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Oi iŋi mitaniŋgabemiŋ: joma soguine kamel oi buŋi kimboŋgo soine so ropeiŋ. Ore so ŋiŋigo tinabiŋeyaŋuŋke yoŋoji Anuture qorumaŋ maŋgo ropenimiŋgo yobiŋgaru quŋganimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Oŋu yajime kiŋariŋ yoŋoji popureru waragaru iŋi mibuŋ, “Opopoŋ! Ŋiŋigo moji Sombunde biŋe fukena?” ");
INSERT INTO mlh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Oŋu mibi Yesuji piki ŋone yaberu iŋi miya, “Ŋiŋigoji oi esoigaru embimbiŋgaru quŋgaegobiyoŋ, Anutuji ya sosowo soine eega. Iŋoji ya mo eku baiŋgo so embimbiŋgaru quŋgaega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pitaji buŋo oi maneru bokirieru iŋi ojiya, “Mane, niŋoji yanoŋuŋ sosowo bokeru go boyobe guru warebeŋ. Ore furiine wamo ya rokimiŋ?” ");
INSERT INTO mlh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Oŋu ojime Yesuji iŋi yajiya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Ya sosowo gariine fukeko Sombuŋ eru morende Ŋi foriineji morumboŋ ŋeŋeineo ŋeko kuririquraŋineji tamaeiŋ, damaŋ fuŋine mo oo noŋ boyobe nuru warebuŋ, yoŋoji oŋuakoŋ morumboŋ ŋeŋe 12 oo ŋeku Israel kubu 12 yoŋore buŋo osoeru mitarinimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Moji nonde tinare eru ya mo bokeya, soriŋ piine, kaka gboine, seŋ baŋaine, maŋgo mamaine, odu madepuine me gio teniŋine oi boke yabeko Anutuji ore geoine odureru bokirie teko saueiŋ. Oŋu saueko gogo sanaŋine tatariine tomiri raugaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Oŋu fukeiŋyoŋ, fuŋfuŋgaine ŋoŋoreone kokoineji jikiine fukebi jikiine yoŋoreone kokoineji fuŋfuŋgaine fukenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesuji miya, “Sombunde qorumaŋ oi iŋi: Moreŋ rauine moji kae fufurere akoŋ pakereru sakibe raru ŋi goine ŋone yaberu wain gioineo moneŋ gio baninde weu yareya. ");
INSERT INTO mlh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Weu yareme ‘Soine,’ mibi giobobo moakonde furi (Kina 20) yareiŋ ore maŋmoakoŋ ebi sore yabeme wain gioineo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Rabi 9 kilok ore so fukeko moke jikigaru raru ŋi goine nareŋgareŋ kae jiŋoineo mo dimabi ŋone yabeya. ");
INSERT INTO mlh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ŋone yaberu iŋi yajiya, ‘Ŋoŋo oŋuakoŋ nonde wain gioo raru gio babi furiŋaŋuŋ soineo akoŋ ŋarebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Oŋu yajiko wain gioo rabuŋ. Rabi 12 kilok eko moke raya eru iŋande 3 kilok ore so ŋeŋeineo moke sakibe raru oŋuakoŋ eya. ");
INSERT INTO mlh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Oŋu eru iŋande 5 kilok ore so sakibe rako ŋi goine ŋeŋeineo moke mo kosa dimabi ŋone yabeya. Ŋone yaberu iŋi weu yareya, ‘Ŋoŋo wamore una joroine yo mo gogobi?’ ");
INSERT INTO mlh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Oŋu weu yareme iŋi bokiriebuŋ, ‘Moji moneŋ gio bakimiŋ ore so weu norega. Ore eru mo yoo dimagobeneŋ.’ Bokiriebi iŋi yajiya, ‘Ŋoŋo oŋuakoŋ nonde wain gioo raru gio baniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Gio babi kae iŋaŋgako wain gio rauineji gio siŋaŋine keporeru iŋi ojiya, ‘Go gio bobo ŋi oŋga yarende warebi furiyaŋuŋ yare. Tatariine kae iŋaŋgako waregobi, yoŋoreone fuŋgaru furiyaŋuŋ yareraku rande kaere akoŋ waregobi, yoŋoreo tariine.’ ");
INSERT INTO mlh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Oŋu ojime iŋande 5 kilok gioo warebuŋ, yoŋoji wapebi giobobo moakonde furi (Kina 20) oi moakoŋ moakoŋ yareya. ");
INSERT INTO mlh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Rone gioo warebuŋ, yoŋoji waperu furiyaŋuŋ odureru roniminde manesubuŋyoŋ, oi moakoŋ moakoŋ oŋuakoŋ una moakonde furi yareya. ");
INSERT INTO mlh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Furi moakoŋ oi akoŋ roru fuŋgaru moreŋ rauinere maŋyaŋuŋgo ŋunuŋ-ŋunuŋ miku miteru iŋi mibuŋ, ");
INSERT INTO mlh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Niŋo wegi joinekeo suŋoŋ rauku giore yobiŋ osigagobeneŋyoŋ, ŋi yoŋo muŋambemeŋ wareru gio baninde weu yarege. Yoŋoji aua moakonde so gio bagobiyoŋ, goji jibu yoŋore mane yarende niŋoke sogokoŋ fukegobi. Oi so sagaga.’ ");
INSERT INTO mlh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Oŋu mibuŋyoŋ, yoŋoreone more iŋi bokirieru ojiya, ‘Ogone, noŋ goke buŋo miku giobobo moakonde furi (Kina 20) garebemiŋ ore maŋmoakoŋ egobere. Ore so furi oi akoŋ garebe sagaga. Go oi manesuigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Maŋgo ore eru sembeaiŋ ine, go gakere furi roru raigoŋ. Ŋi muŋambemeŋ gio baninde weu yareba, yoŋore oŋuakoŋ furi garego, oi akoŋ yarebeminde manego. ");
INSERT INTO mlh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","‘Nakene monenji nake aŋire so ebe sagaga me mata? Nonji wiriine akoŋ ŋarego ore maŋgoji anda eru jiŋogo posoega me?’” ");
INSERT INTO mlh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesuji buŋo oi miforeru iŋi miya, “Ore so tatariine yoŋoji fuŋfuŋgaine fukebi fuŋfuŋgaine yoŋoji tatariine fukenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuji Jerusalem sitio ropeiŋgo ore moreŋ kadi rakabi kiŋariŋpuine 12 oi kepore yaberu qaŋaŋineo raru iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Maneniŋ, noŋuŋ Jerusalem ropekimiŋ. Oo moji Sombuŋ eru morende Ŋi foriine babae ba teme soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋore meo raiŋ. Yoŋo komeinde buŋoine miforeru ");
INSERT INTO mlh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","kotu gawman yoŋore meo ruanimiŋ. Ruabi igosisi eteku ŋoŋoru joruinekeji qotimberu qotibotiganimiŋ. Qotimberu qotibotigaru maripoŋgo qabi komeiŋ. Komeru una yokaomo fukeko komegone pakereiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Damaŋ oo Zebedire madeyoka yokore maŋgoji madeyokaine yokoke Yesureo wareru dikanji keteru ya fuŋine more karieiŋgo miya. ");
INSERT INTO mlh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Oŋu miko weu teya, “Go wamo yare eru egarega?” Weu teko iŋi ojiya, “Goji soine mitigande nonde madeyoka yo yokoji gore qorumaŋgo paibe roperu moji me furogoo eru moji me kijoo ŋeku ya sosowo siŋaŋ ganobu.” ");
INSERT INTO mlh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Oŋu ojiyayoŋ, Yesuji bokirieru iŋi miya, “Ŋoŋo ore fuŋine so mane mukuku kariegobi. Nonji popu jajaineke nobemiŋ, ŋoko oi soine noku joiserereŋ manenimi me mata?” Oŋu miko maneru “Soine nonimi,” ojibu. ");
INSERT INTO mlh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ojibire iŋi yasiya, “Oi fofori! Nonji popu jajaineke nobemiŋ, ŋoko oi oŋuine akoŋ nonimiyoŋ, nonde me furoneo me kijoneo moji ŋeiŋ, nonji buŋo oi mitigabemiŋ ore so mata. Nonde Mamaji ŋeŋe yoyoka oi uri yokore bomogaya, oi yokore yateme noke ŋeku ya sosowo siŋaŋ gaekimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kakagbo yoyoka yokoji oŋu karie tebire ogopuyakuŋ 10 yoŋoji oi maneru maŋyaŋuŋ sembeaya. ");
INSERT INTO mlh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Oŋu sembeayayoŋ, Yesuji oŋga yareko warebi iŋi yajiya, “Morende kantriine kantriine yoŋore muraŋpuji ŋi koito oŋu eyareegobi. Yoŋore soguneji buŋo mitigaru ŋiŋigo botiŋ yabeku usuŋyaŋuŋ yaduegobi. Ŋoŋo yoŋore fuŋne oi soine manegobi. ");
INSERT INTO mlh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ŋoŋore botugo mosi oŋuine egu peineyoŋ, moji ŋoŋore botugo soguneŋaŋuŋ fukeiŋgo manega, iŋoji kiŋaŋ qa ŋareku goine. ");
INSERT INTO mlh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","“Oŋuakoŋ moji ŋoŋore botugo minebobo fuŋfuŋgaine goiŋgo manega, iŋoji ŋoŋore mea yukuo goku kiŋaŋqoqoŋaŋuŋ omaine fukeine. ");
INSERT INTO mlh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sombuŋ eru morende Ŋi foriineji oŋuakoŋ mosi oŋuine ŋaduru iŋoyoŋe kiŋaŋ qa tenimiŋ ore eru so wareyayoŋ, kiŋaŋ qa ŋareku ŋiŋigo sosowo yoŋore due baiŋ ore eru wakiru gogoine kisiŋgaru bokeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesuji kiŋariŋpuine yoŋoke Jeriko siti bokeiŋgo ebi ŋiŋigo kubu sogoji boyobe yabeku ŋadiyaŋuŋgo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Oŋu warebi ŋi jiŋokombi yoyoka kadi qaŋaŋineo ŋebu. Ŋebire “Yesuji ŋatureiŋgo ega,” mibi maneru iŋi oŋgabu, “Ofoŋ Deiwidre osigida, go ŋonemaiŋ enote!” ");
INSERT INTO mlh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Oŋu oŋgakabire ŋiŋigo kubu soguine yoŋoji “Mo ŋenimi!” miki qomuku yatebuŋyoŋ, yokoji yameŋ keku iŋi oŋgabu, “Ofoŋ Deiwidre osigida, go ŋonemaiŋ enote!” ");
INSERT INTO mlh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Oŋu oŋgakabire Yesuji ode niniŋgaru “Nondeo wareni!” miku oŋgame warebire iŋi weu yateya, “Ogoyokane, nonji wamo ya eŋateiŋgo manegobire?” ");
INSERT INTO mlh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Oŋu weu yateko iŋi ojibu, “Ofoŋ, niko jiŋonokuŋ moke piiŋgo manegobere.” ");
INSERT INTO mlh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Oŋu ojibire Yesuji yokore beusembe maneru jiŋoyakuŋ yoŋoko oo akoŋ untoko piku Yesu boyoberu ŋadiineo rabu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesuji kiŋariŋpuine yoŋoke Jerusalem siti bombeŋgaru Oliwe yo tukuo Betfage kaeo warebuŋ. Wareru kiŋariŋyokaine yoyoka sore yabeiŋgo eku ");
INSERT INTO mlh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","iŋi yasiya, “Kae jiŋo maiŋakuŋgo ŋega, ŋoko oo rani. Raru oo roperu doŋgi ŋigoine niginji kipebi dimaga eru doŋgi mendaine oi oo akoŋ bofuke yapenimi. Oi pirue yaperu ro yaperu nondeo wareni. ");
INSERT INTO mlh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Piruebire moji buŋo mo miko iŋi ojinimi, ‘Ofoŋnokunji ore embimbiŋgaga.’ Oŋu ojibire doŋgi oi pipa ŋateme yoo wareni.” ");
INSERT INTO mlh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Anutuji buŋo mo kajeqouŋ ŋi more maŋgo ruame miya, oiji foriineke fukeiŋ ore oŋu fukeya. Buŋo oi iŋi, ");
INSERT INTO mlh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“O Jerusalem ŋiŋigo Zaion tuku roregaru gogobi, yoŋore iŋi yajibi maneniŋ, ‘Maneniŋ, ŋoŋore kiŋ koitoji ŋoŋoreo fukeiŋ. Iŋoji mosi waigo eru doŋgi paiineo ŋeru wareiŋ. Doŋgi yobiŋ kukuogaega ore madeinere paio ŋeru wareiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesuji kiŋariŋyokaine sore yapeko raru buŋo yasiya ore so ebu. ");
INSERT INTO mlh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yoko doŋgi maŋgo made oga yaperu warebu. Warebire marikuyaŋuŋ kemukuru doŋgi paiyakuŋgo ruabi Yesuji madeinere paio roperu ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Oŋu ŋeku rame ŋiŋigo kubu sogoji araŋ ba teku marikuyaŋuŋ kemukuru kadi sogoo ramegabi goineji yo maŋineo raru tieŋine bajiru kadi sogoo ramegabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ramegabi ŋiŋigo kubu sogo bonieru keporeru rabuŋ eru ŋadiineo boyoberu warebuŋ, yoŋoji iŋi miku oŋgabuŋ, “Hosana! Anutu miteŋ gagobeneŋ. Deiwidre osigida ohowe ohowe! Ofonde tinao wareiŋ, Anutuji oi mifiaine. Hosana! Tinabiŋego miteŋ gagobeneŋ paibe ropega! Ohowe ohowe!” ");
INSERT INTO mlh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Oŋu oŋgabi Jerusalem sitio roperu sitire ŋiŋigo sosowoji popureru oyowoqojibu fonuŋ eru iŋi weubuŋ, “Ŋi yo moji?” ");
INSERT INTO mlh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Weubi ŋiŋigo kubu sogo yoŋoji iŋi bokiriebuŋ, “Iŋoji kajeqouŋ ŋi Yesu, Galili prowinsre kae Nazaret oone.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuji boji sorinde jokoroŋ maŋgo raya. Oo ŋiŋigo ŋone yabeme mebo furiine banimiŋ ore ruabi furiine babuŋ, iŋoji yoŋo sosowo yobe yabeme wakibuŋ. Moneŋ nareŋgareŋ ŋiŋigo yoŋore koro romaeŋgaru bokirieme rabuŋ. Oŋuakoŋ kabu furiyaŋuŋ banimiŋ ore ruabuŋ, yoŋore ŋeŋe oi oŋuakoŋ ketuŋgame rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Oŋu eru iŋi yajiya, “Aisaiaji buŋo mo iŋi quraŋgame pega, ‘Nonde sorinji oŋgawowosi pi fukeiŋgo miinebi.’ Buŋo oi pegayoŋ, ŋoŋo oi igokogabi suroŋqoqo yoŋore kouŋ oŋuine fukega.” ");
INSERT INTO mlh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Oŋu fukeko jiŋokombi eru puriŋ ŋiŋigo yoŋo boji soriŋgo iŋoreo warebi bobiaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Oŋu fukeyayoŋ, soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji mosi qoqowirie baya, oi ŋonebuŋ eru odumade boji soriŋgo oŋgaku “Hosana! Deiwidre osigida ohowe ohowe!” mibuŋ, yoŋo ŋone yaberu maŋsembe manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Maŋ sembene maneru iŋi mitebuŋ, “Odumade buŋo oŋgagobi, oi manege me mata?” mitebi iŋi bokirie yareya, “Soine manego. Ŋoŋo damaŋ mogo Biŋe buŋo yo osebuŋ me mata, ‘Goji odumade eru koko gorubeine moŋ noegobi, oi qaji yarende gogake poretiŋ miteŋ guegobi.’” ");
INSERT INTO mlh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Oŋu bokirie yareru boke yaberu kae iŋaŋgako siti bokeru Betani raru peya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Peku kae fufurere akoŋ pakereru moke sitio raru uqore komeya. ");
INSERT INTO mlh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Uqore komeru kadi qaŋaŋineo fig yo mo ŋoneru ore fuŋineo raya. Rayayoŋ, foriine so bofukeyayoŋ, rekaineke akoŋ ŋoneya. Oŋu ŋoneru yo oi iŋi miteya, “Goji damaŋ mogo forigo moke so peine.” Oŋu mitari teko fig yo oiji oo akoŋ gbaŋiya. ");
INSERT INTO mlh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gbaŋiko kiŋariŋpuineji oi ŋoneru popureru iŋi mibuŋ, “Fig yoji uruŋu eru fofoakoŋ gbaŋiga?” ");
INSERT INTO mlh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mibi Yesuji iŋi bokirieya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Mamanesiŋ damaŋ so sabareku maŋyoka so enobuŋ ine, fig yogo ya fukega, ŋoŋoji oŋuakoŋ so enimiŋyoŋ, ya yo oŋuakoŋ soine enobuŋ: Tuku yoore raure iŋi mitiganobuŋ, ‘Go tuku yo qomukuru ogaru pakereru raru koego rua.’ Oŋu mitigaku Anutu manesiŋ gako ore so fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Wamo yare weu oŋga wosinimiŋ, oi sosowo rauganiminde manesiŋ gabi biŋeŋaŋuŋ fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuji boji sorinde jokoroŋ maŋgo raru ŋiŋigo qaji yareme soriŋ gio siŋaŋ eru kantrire minebobo goine yoŋoji iŋoreo wapebuŋ. Waperu iŋi weu tebuŋ, “Go yoo ya ege, oi moji mitiga gareme eege? Ore usuŋ oi moji gareya?” ");
INSERT INTO mlh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Weu tebi iŋi bokirie yareya, “Nonji oŋuakoŋ buŋo mo weu ŋarebemiŋ. Oi bokirie narenimiŋ ine, nonji oŋuakoŋ moji usuŋ nareko ya yo eego, oi ŋajibemiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jonji ŋiŋigo miti meso rau yareku goya, iŋoji ore usuŋ oi uroone roya? Sombuŋ Rauineji oteya me moreŋ rauineji otebuŋ?” Oŋu bokirie yareme botuyaŋuŋgo mimane eku iŋi mibuŋ, “‘Usuŋineji Sombuŋgone fukeya,’ oŋu mikimiŋ ine, iŋoji iŋi miiŋ, ‘Ŋoŋo wamore Jon so manesiŋ gabuŋ?’ Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Me ‘Moreŋ ŋiŋigone fukeya,’ mikimiŋ ine, niŋoji ŋiŋigo kubu yoŋore kokoi maneru embimbiŋgakimiŋ. Kufufuŋ sosowo yoŋoji Jonde ‘Kajeqouŋ ŋi fukega,’ miku gogobi.” ");
INSERT INTO mlh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Buŋo oŋu osoeru Yesure iŋi bokiriebuŋ, “Oi so manegobeneŋ.” Oŋu bokiriebi Yesuji iŋi yajiya, “Oŋu fukeko nonji oŋuakoŋ ya yo baego ore usuŋine moji nareya, oi so ŋajibemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesuji soso buŋo mo iŋi miya, “Ŋoŋo buŋo yoore eru uruŋu manesugobi? Ŋi mo madeyokaine yoyoka gobuŋ. Damaŋ mogo mamayakunji madeine moreo raru iŋi ojiya, ‘Madene, go soine muŋambe nonde wain nigiŋ gioo raru gio baigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Oŋu ojime iŋi bokirieya, ‘Noŋ taki nuga.’ Oŋu ojiyayoŋ, jiki buŋoine ore eru mane sembeaku kirieru raru gio baya. ");
INSERT INTO mlh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ore ŋadiineo mamayakunji madeine moreo raru rone madeine ojiya, buŋo oi akoŋ ojiya. Oi ojime buŋo iŋi bokirieru miya, ‘Sogunene, soine rabemiŋ.’ Oŋu miyayoŋ, jibu so raya.” ");
INSERT INTO mlh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesuji oŋu miku weu yareya, “Yoyoka yokoreone moji mamayakunde mi reŋgaya?” Oŋu weu yareme iŋi bokiriebuŋ, “Moru madeine iŋoji.” Oŋu bokiriebi iŋi yajiya, “Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Takis roro ŋiŋigo eaduyaŋuŋke eru kadi sogore ŋigo yoŋoji ŋoŋo ŋadureru rone Anuture qorumaŋ maŋgo ropenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Buŋo ore fuŋine oi iŋi: Jon Mitimeso ŋiji ŋoŋoreo wareru Anuture jiŋoo posikeniminde fuŋne ŋaduko ŋoŋo iŋore buŋo oi so manesiŋ gabuŋyoŋ, takis roro ŋiŋigo eaduyaŋuŋke eru kadi sogore ŋigo yoŋoji oi manesiŋ gabuŋ. Yoŋoji oi manesiŋ gabuŋ, ŋoŋo oi ŋoneru jibu jiki oŋuakoŋ ŋoŋo-ŋaŋe so mane sembeaku kirieru oi so manesiŋ gabuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesuji miya, “Soso buŋo mo oi iŋi maneinebi: Moreŋ rauine moji wain nigiŋ gio mo keru sariya. Keru sariru saine baku roregaya. Baku roregaru wain jua sogo koji baya. Oo wainde fori ruaru kufuji odeyagabi obuineji roruŋgo rakaya. Wain jua sogo oi koji baku wain kiaŋ egu ronimiŋ ore siŋaŋ bobo koro joroine rouŋineke baya. Ya sosowo ba foreru wain gio siŋaŋ goine bofuke yaberu iŋi yajiya, ‘Ŋoŋo gio baku foriinere mobe ŋoŋo-ŋaŋunde roru mobeine rauine noŋ nareinebi.’ Oŋu miku gio oi meyaŋuŋgo ruaru boke yaberu kantri mogo raru goya. ");
INSERT INTO mlh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Goku gome foriine gumuŋgaya ore damaŋine gosa 5 bembeŋgako oo kiŋaŋqoqopuine goine sore yabeme siŋaŋ yoŋoreo raru wain gio foriinere mobe oteniminde miya. ");
INSERT INTO mlh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Miyayoŋ, siŋaŋ yoŋoji oi oga yaberu kiperu goine kobinji darijombuŋ yaberu goine yabebi komebi goine koji bokeru yabebi komebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ore ŋadiineo kiŋaŋ ŋi goine jikigaru sore yabeme kokoine fukebuŋyoŋ, yoŋo oŋuine akoŋ pore imo kane eyarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Oŋu ebi wain gio rauineji buŋo baaru miya, ‘Nakene made araŋ ba tenimiŋ me uruŋu?’ Oŋu miku tatariine oi iŋoyoŋunde made soreme yoŋoreo raya. ");
INSERT INTO mlh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Rayayoŋ, wain gio siŋaŋ yoŋo madeine ŋoneru botuyaŋuŋgo iŋi mimane eku mibuŋ, ‘Iŋoji merufuinere rau fukega. Ayo, niŋo iŋo roru qabeneŋ komeko wain nigiŋ gioineji noŋunde biŋe fukeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Oŋu miku qafagaru roru kiperu bokebi gio sakibe rakako qabi komeya. ");
INSERT INTO mlh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Wain gio rauineji oi maneru wareru gio siŋaŋ oi uruŋu eyareiŋ?” ");
INSERT INTO mlh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yesuji oŋu weu yareme iŋi ojibuŋ, “Siŋaŋ sembene yoŋo ketotie yaberu boserereŋ eyareiŋ eru gio siŋaŋ gariine bofuke yaberu wain nigiŋ gioine yoŋore meo ruaiŋ. Yoŋoji foriine gumuŋgainde damaŋgo mobeine poretiŋ oteenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesuji oi maneru iŋi yajiya, “Biŋe Qurande buŋo yo damaŋ mogo osebuŋ me mata, ‘Pi bobo yoŋoji ko otuŋ mo ŋadi gaku mo bokebi ŋeya, oiji otuŋ sanaŋine fukeko bofukebuŋ. Oiji kerigako piji ŋeririkeru wakiru keiŋ. Ofonji otuŋ oi igodoŋgako jiŋonoŋunji ŋonebeneŋ bibiineke fukeko waragaegobeneŋ?’ ");
INSERT INTO mlh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ore eru iŋi ŋajibe maneniŋ, Anutuji qorumaŋine oi oga ŋaberu ŋiŋigo kubu mo yareme yoŋoji ore gioine babi foriine soine fukeeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Moji otuŋ qoruine oo odetataŋgaru wakiru qaiŋ, oi sakiine ketiqotigaiŋyoŋ, aeŋ otuŋ oiji pariru rondiŋgaru more paio wakiru qaiŋ, oi sosowo qanjaŋbanjaŋgaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yesuji oŋu miko maneru soriŋ gio siŋaŋ eru Farisi (Kadi buŋore yameŋyameŋ) yoŋoji soso buŋoine oi maneru fuŋine mane taniŋgaru iŋi mibuŋ, “Oi niŋore miga.” ");
INSERT INTO mlh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ore eru oi roru kipenimiŋgo manebuŋyoŋ, ŋiŋigo kubu soguine yoŋore kokoi maneru embimbiŋgabuŋ. Ŋiŋigo kubu soguine yoŋoji Yesure manebi kajeqouŋ ŋi fukeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuji moke fuŋgaru soso buŋoo buŋo iŋi miya, ");
INSERT INTO mlh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sombunde qorumaŋ oi yoore so fukega: Kiŋ ŋi koitoji madeinere suanjeŋ (bobotumaŋ) jebe burugaru bomogaya. ");
INSERT INTO mlh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bomogaru kiŋaŋqoqopuine sore yaberu iŋi miya, ‘Nonji ŋiŋigo goine suanjeŋ jebego wareniminde manego. Ŋoŋo yoŋoreo kiŋaŋ raru warenimiŋ ore yajiinebi.’ Oŋu miko raru yajibuŋyoŋ, ŋiŋigo yoŋoji oi maneru wareiŋgo taki yabeme keoma ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ore ŋadiineo kiŋaŋqoqopuine goine moke sore yaberu iŋi miya, ‘Ŋiŋigo warenimiŋ ore miboŋ, yoŋoreo raru iŋi yajiinebi: Maneniŋ, nonji jebere uqone bomoga forebe ŋega. Nonde bulmakao ŋiine eru bulmakao goine gume yabebeneŋ jijiyaŋuŋke fukebuŋ, oi yaberu rigaru qamagabeneŋ ya sosowo jaueru pega. Ŋoŋo suanjeŋ jebego wareniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Oŋu miko rabi ŋiŋigo yoŋoji buŋo ore kaje so ruabuŋyoŋ, qaqouma kosa rabuŋ. Goineji uqo gioyaŋuŋgo rabi goineji rojiki-bajiki gioyaŋuŋgo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Goineji kiŋ koitore kiŋaŋqoqopu qafagaru oga yaberu poreru yobe imo eru yabebi komebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Komebi kiŋ koitoji maŋine rigaŋgame mamari kubuine sore yabeko raru dimaku ŋiŋigo yayabe ŋi yoŋo ketotie yaberu taoŋ piyaŋuŋ oi rigabi jaya. ");
INSERT INTO mlh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ore ŋadiineo kiŋ koitoji kiŋaŋqoqopuine oi iŋi yajiya, ‘Suanjeŋ jebe bomogabeneŋ jaueru ŋegayoŋ, ŋiŋigo warenimiŋ ore miboŋ, yoŋoji jeri jebeo warenimiŋ ore so, so fukegobi. ");
INSERT INTO mlh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ore eru ŋoŋo kadi sosoyakuŋgo eru pi kae jiŋoine jiŋoine oo raru ŋiŋigo oi me oi bofuke yabenimiŋ, oi suanjeŋ jebego warenimiŋ ore miku yameŋ keku bapakare yabeinebi.’ ");
INSERT INTO mlh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Oŋu yajiko kiŋaŋqoqopuineji bokeru kadi pe rabuŋ, oo raru ŋiŋigo oi me oi bofuke yabebuŋ, oi sosowo keporeru qodure yaberu warebuŋ. So osoe yabebi ŋiŋigo fiine eru sembene oŋuakoŋ wareru suanjeŋ jebe pi puseru uqo ŋeŋe roregaru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Uqo ŋeŋe roregaru ŋebuŋyoŋ, kiŋ koitoji oi ŋone yabeiŋgo wareru oo ŋi mo suanjeŋ jebere mariku yagaŋine so keya, oi ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ŋi oi ŋoneru iŋi ojiya, ‘Ogone, go suanjeŋ jebere mariku so keru jibu uruŋu eru pi yoore maŋgo warege?’ Oŋu ojime ŋi oiji buŋoine mataeme kamiine ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Oŋu ŋeko kiŋ koitoji kiŋaŋqoqopuine iŋi mitiga yareya, ‘Ŋi oi roru me kufuine kiperu sakibe bokebi qisirigo rakaine.’ Oo gonimiŋ, yoŋoji kuyo jojoraku ŋiraŋyaŋuŋ kibi qako gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Buŋo ore so Anutu ŋiŋigo boakonji warenimiŋ ore miyayoŋ, afaine yoŋoji buŋo oi roru mane sabareku wareru Anutuji kubu soguine roosoe yabeya, yoŋore botugo wapenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ore ŋadiineo Farisi (Kadi buŋore yameŋyameŋ) yoŋoji raru mimane eku Yesu weu teru buŋore budunji furugame nigiŋganiminde buru ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Buru oŋu ruaru kiŋariŋpuine eru gawana Herodre pati ogopu goine sore yabebi Yesureo wareru iŋi weu teru mibuŋ, “Qaqaji, goji ŋi foriine fukege, niŋo oi manegobeneŋ. Goji ŋiŋigo goine so ŋoneaŋi yaberu goine so sure yabeegeyoŋ, so moakonji osoe nobeege. Ore eru bapakare gubi so kasigaru sogune oi so komoŋ yabeegeyoŋ, Anuture kadi oi buŋo foriinere so qaji noreege. Goji Anuture buŋo poretiŋ oiji ropekiine eru wakiqoqoine sogokoŋ sosowo mi botiŋ enoreega. ");
INSERT INTO mlh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ore eru buŋo yoore uruŋu manesuge, oi minde manekimiŋ. Niŋo Sisa-kiŋ koitore takis ruaru oiji Mosesre Kadi buŋo ririkimiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Oŋu weu tebi buruyaŋuŋ ikoine mane mukuru iŋi yajiya, “O maŋkekerisiere ŋi sasakiine, ŋoŋo wamore buŋore buduŋgo rua nunimiŋ ore esoi nugobi? ");
INSERT INTO mlh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Soine takis ruruare moneŋ mo nadubi ŋonebemiŋ.” Oŋu yajiko silwa moneŋ mo roru warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Warebi iŋi weu yareya, “More sasako eru tina oi yoo quraŋgabi pega?” ");
INSERT INTO mlh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“O oi Sisa-kinde,” oŋu bokirieru mibuŋ. Mibi iŋi yajiya, “Oŋu fukeko ya Sisa-kiŋ koitore sasakoke oi iŋore biŋe oteeinebi. Ya Anuture sasakoke pega, oi Anuture biŋe oteinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Oŋu yajiko iŋore kokoine waragaru bokeru sakibe rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadusi (Soriŋ giore yameŋyameŋ) yoŋoji “Komebuŋ, yoŋoji so pakerenimiŋ,” miku gobuŋ. Damaŋ oo yoŋoreone goineji Yesureo wareru iŋi weu teru mibuŋ, ");
INSERT INTO mlh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Qaqaji, Mosesji iŋi mitiga noreme pega, ‘Ŋi mo ŋigo roko odumade so fukebi komeko gboineji soine kojeine roru goku odumade bofuke teko kakainere tina roru goiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mane, damaŋ mogo kakagbo 7 gobuŋ. Kakayaŋuŋ fuŋfuŋgaineji ŋigo roru goku odumadeine tomiri mo goku komeya. Komeko gboineji kojeine oi roya. ");
INSERT INTO mlh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","“Roru goku komeko gboine moji kojeine oi roya. Roko ore ŋadiineo gboine moji ŋigo oi akoŋ roya. Oŋuakoŋ oŋu kakagbo 7 sosowo yoŋoji ŋigo moakoŋ oi akoŋ roru odumadeine tomiri goku kome forebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kome forebi tatariine kojeyaŋuŋ oi oŋuakoŋ komeya. ");
INSERT INTO mlh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Goji ‘Komebuŋ, yoŋoji gboreru pakerenimiŋ,’ migeyoŋ, niŋo oi so manesiŋ gagobeneŋ. Mane, ŋi 7 sosowo oi moko pakerenobuŋ ine, ŋigo moakoŋ oi ŋonuŋyaŋuŋ robi goya ore eru more ŋonuŋ fukena?” ");
INSERT INTO mlh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Oŋu weu tebi Yesuji bokirieru iŋi yajiya, “Ŋoŋo buŋo mijibugagobi. Maŋkekerisiere Biŋe Quraŋ eru Anuture usuŋ so mane mukugobi ore tiŋtuŋ eegobi. ");
INSERT INTO mlh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Fofori, komegone pakereru damaŋ oo ŋoe ŋonuŋ so fukenimiŋyoŋ, mimerereŋ yoŋoji Sombuŋ kaeo gogobi oŋuine fukeru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Maneniŋ! Komebuŋ, yoŋoji gboreru pakareniminde buŋo Anutuji ŋoŋore miya, ŋoŋo oi osebuŋ me mata? Buŋo oi iŋi, ");
INSERT INTO mlh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nonji Anutu Abrahamde Ofoŋ, Aisakre Ofoŋ eru Jeikobre Ofoŋ go waperu gogo.’ Anutuji komekiine yoŋore Ofoŋ matayoŋ, gogo sanaŋine gogobi, yoŋore Ofoŋ goga.” ");
INSERT INTO mlh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesuji ŋiŋigo kubu soguine oŋu qaji yareko maneru waragabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sadusi (Soriŋ giore yameŋyameŋ) yoŋoji Yesu weu tebi bokirieru misarigako buŋoyaŋuŋ mata eya, oi Farisi (Kadi buŋore yameŋyameŋ) yoŋoji maneru wareru tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yoŋoreone qaqaji mo Kadi buŋo poretiŋ mane mukuya, iŋoji wareru Yesu buduŋ ruaru iŋi weu teya, ");
INSERT INTO mlh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Qaqaji, Mosesre Kadi buŋo maŋgo wamo mimipaŋ buŋo oi yasogo yobu fukega?” ");
INSERT INTO mlh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Weu teko bokirieya, “Qoruine soguine oi iŋi, ‘Go maŋgo, iirugo eru mamanesugo jumuine oiji Ofoŋ Anutugo manjoko eteru goigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Oiji mimipaŋ buŋo qoruine eru ropekiine fukega. ");
INSERT INTO mlh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mimipaŋ buŋo ore ogoine oi iŋi, ‘Gake manji jojoko eege, oŋuine akoŋ ŋiŋigo sosowo manji jojoko eyareru goigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mimipaŋ buŋo yoyoka oi Mosesre Kadi buŋo eru kajeqouŋ ŋiŋigo yoŋore Biŋe Quraŋ sosowo ore qoruine fukega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi (Kadi buŋore yameŋyameŋ) yoŋoji wareru tumaŋgabi Yesuji iŋi weu yareya, ");
INSERT INTO mlh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ŋoŋo Kristore uruŋu manegobi? Iŋoji more made fukega?” Oŋu weu yareme bokirieru mibuŋ, “Oi kiŋ Deiwidre osigida fukega.” ");
INSERT INTO mlh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesuji mibi maneru yajiya, “Oŋu fukegayoŋ, uruŋu eru Moro Tiriineji Deiwid boburo teme iŋore ‘Nakene Ofoŋne,’ oŋgaku iŋi miya, ");
INSERT INTO mlh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Anutuji dimaku nonde Ofoŋ iŋi ojiya, Goji yoo wareru nonde me furoneo ŋende nonji damaŋ botuineo rosipugo ode rondiŋ yaberu gbiŋ eyareru gore kufu yukuo rua yabebemiŋ. Damaŋ oi wareru fukeiŋ ore so kuririquraŋgo yoo ŋeigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deiwidji iŋoyoŋe oŋu miku tinaine ‘Nonde Ofoŋ’ miga. Ofoŋne miku uruŋu eru iŋore osigida oŋuakoŋ fukena?” ");
INSERT INTO mlh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Oŋu yajiko ore tifeine moji mo bokirieiŋgo embimbiŋgaru buŋoyaŋuŋ mataeme dimabuŋ. Una oone akoŋ sosowo yoŋoji Yesu moke buŋo more weu tenimiŋ ore fogaturuŋ eru bokebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Damaŋ oo Yesuji ŋiŋigo kubu sogo eru kiŋariŋpuine oi iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Kadi buŋore qaqaji eru Farisi (Kadi buŋore yameŋyameŋ) yoŋoji Mosesre morumboŋ ŋeŋeo ŋeku Kadi buŋore fuŋne usuŋ paio qaji ŋareegobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ore eru buŋo sosowo mitiga ŋareegobi, oi reŋgainebiyoŋ, eeboboyaŋuŋ oi so boyobeinebi. Yoŋoji buŋo miyaŋunji mitaniŋgaegobiyoŋ, yoŋoyoŋe oi so boyobeegobi. Ore eru yoŋo oŋuine so eku goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Yoŋoji buŋoine buŋoine mitigaru ore begi yobiŋineke oi ŋiŋigo fagayaŋuŋgo ruaru rua ebi oi koboninde yobiŋgaru miqomuku eegobiyoŋ, yoŋoyoŋe oi me sisiyaŋuŋ mendaine moji bapi yabenimiŋ ore beusembeyaŋuŋ mo so peega. ");
INSERT INTO mlh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Yoŋo eeboboyaŋuŋ sosowo ŋiŋigoji ŋone yabenimiŋ ore eru eegobi. Miti buŋo koruŋ (memori ruge) bifuŋ nigiŋ katapayaŋuŋ bo sogueru totogo noduru Biŋe mamaneyaŋunde erioŋbarioŋ eegobi. Marikuyaŋunde sisio kuririre kegobiri soguine soguine roru gbedigaegobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yoŋoji jebego ŋeŋe fuŋfuŋgaineo minemine ŋeniminde maneegobi eru oŋgawowosi pigo miineo paibe ŋeninde aŋi maneegobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nareŋgareŋ kae jiŋoo me kadio ŋiŋigo ŋone yabebi mijeri eyarenimiŋgo maneru ‘O sogunenoŋuŋ,’ tinayaŋuŋ oŋu miniminde aŋi maneegobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Yoŋoji oŋu eegobiyoŋ, moakoŋ iŋoji ŋoŋore Qaqaji fukeko ŋoŋo sosowoji iŋore maŋkekerisie ogopu fukegobi. Ore eru ŋoŋore tina qaqajinoŋuŋ minimiŋ ore so maneinebi. ");
INSERT INTO mlh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Moakoŋ iŋoji Mamaŋaŋuŋ fukega. Iŋoji Sombuŋ kaeo goga ore eru moreŋ ŋi more niŋore Mamanoŋuŋ tina oŋu so miinebi. ");
INSERT INTO mlh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kristo moakoŋ nonji ŋoŋore sogune fukego. Ore eru ŋoŋore tina ‘Sogunenoŋuŋ,’ minimiŋgo so maneinebi. ");
INSERT INTO mlh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Oŋu matayoŋ, ŋoŋore botugo moji qoruine fukega, iŋoji kiŋaŋ qa ŋareku goine. ");
INSERT INTO mlh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Oŋu goineyoŋ, moji iŋoyoŋunde maŋ ba ropeiŋ, Anutuji oi ba wakiiŋ. Moji iŋoyoŋunde maŋ ba wakiiŋ, Anutuji oi ba ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“O Kadi buŋore qaqaji eru ore yameŋyameŋ ŋiŋigo! Ŋoŋo maŋkekerisiere ŋiŋigo sasakiine fukebi yobiŋ paiŋaŋuŋgo ropeiŋ ore oŋga joroku ‘Yei!’ migo. Ŋiŋigo Sombunde qorumaŋ maŋgo egu ropenimiŋ ore mendiine keku kipeegobi. Ŋoŋo-ŋaŋe ore maŋineo so ropegobi eru goineji ore maŋineo ropenimiŋgo egobi, ŋoŋo oi kiperu sabare yareegobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","O Kadi buŋore qaqaji eru ore yameŋyameŋ ŋiŋigo! Ŋoŋo maŋkekerisiere ŋiŋigo sasakiine fukebi yobiŋ paiŋaŋuŋgo ropeiŋ ore oŋga joroku ‘Yei!’ migo. Ŋoŋo koje yoŋore pi ya qoroeku anda eru koŋgo eegobi eru tinabiŋeŋaŋuŋ fukeiŋ ore eru oŋgawowosi joroine joroine oŋga wosiru omoŋaŋuŋgo qaegobi. Ore eru Anutuji buŋoŋaŋuŋ mitariku geoine ropekiine bokirieme ŋoŋore paio ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“O Kadi buŋore qaqaji eru ore yameŋyameŋ ŋiŋigo! Ŋoŋo maŋkekerisiere ŋiŋigo sasakiine fukebi yobiŋ paiŋaŋuŋgo ropeiŋ ore oŋga joroku ‘Yei!’ migo. Ŋoŋo moji Juda ŋiŋigo mo fukeiŋgo yameŋ keku koeya koeya petigaru moreŋine moreŋine roregaegobi. Oŋu ebi moji Juda noŋunde eeboboo qakatoiŋ, oi jijibu qaji tebi misi korure biŋe fukeiŋ. Ŋoŋo-ŋaŋe oŋuine matayoŋ, ateine yoyoka ŋoŋo-ŋaŋe ŋadureru sembeqombeaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Jiŋoŋaŋunji kobeme ŋiŋigo meyaŋuŋgo roru oga yabeegobi, yobiŋ ŋoŋore paio ropeiŋ ore oŋga joroku ‘Yei!’ migo. Ŋoŋo buŋo iŋi miegobi, ‘Moji boji sorinde tina miku buŋoine mimipaŋ buŋoji misanaŋgaiŋ ine, oiji so sanaŋgaiŋyoŋ, moji boji sorinde ya goulji bakine ore tinao mimipaŋ buŋoine miiŋ ine, mimipaŋ buŋo oiji kipeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“O jiŋokombi ŋiŋigo biriine! Ya goulji bakine eru boji soriŋ yoyoka yokoreone wamo yaji ropekiine ega? Goul oi kubaine so fukegayoŋ, boji soriŋgo ruabi oiji oi bako kubaine fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Buŋo mo iŋi miegobi, ‘Moji alatare tina miku buŋoine mimipaŋ buŋoji misanaŋgaiŋ ine, oiji so sanaŋgaiŋyoŋ, moji pesiŋ daŋge yauŋ alatao pega, ore tina miku mimipaŋ buŋo miiŋ ine, mimipaŋ buŋo oiji kikipe eiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“O jiŋokombi ŋiŋigo! Pesiŋ daŋge yauŋ eru koro alata yokoreone wamo yaji ropekiine ega? Pesiŋ oi wawakiine egayoŋ, alatao ruabi oiji pesiŋ rambuŋgako kubaiine fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ore eru moji alatare tina miku buŋoine mimipaŋ buŋoji misanaŋgaiŋ, iŋoji koro alata eru ya sosowo alatao pega, ore tinao buŋoine misanaŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Moji boji sorinde tina miku buŋoine mimipaŋ buŋoji misanaŋgaiŋ, iŋoji soriŋ ore eru oo sanaŋgaru goga, iŋore tinao buŋoine misanaŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Oŋuakoŋ moji Sombunde tina miku buŋoine mimipaŋ buŋoji misanaŋgaiŋ, iŋoji Anuture morumboŋ ŋeŋe eru oo ŋega, iŋore tinao buŋoine misanaŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“O Kadi buŋore qaqaji eru ore yameŋyameŋ ŋiŋigo! Ŋoŋo maŋkekerisiere ŋiŋigo sasakiine fukebi yobiŋ paiŋaŋuŋgo ropeiŋ ore eru oŋga joroku ‘Yei!’ migo. Ŋoŋo uqo munjaŋ sosowo boroiŋgaru mobeine 10 oone moakoŋ Anuture biŋe ruaegobi. Jama, raki eru supe oi oŋuakoŋ boroiŋgaru teŋgone moakoŋ oi Anuture biŋe ruaegobi. Pesiŋ oi poretiŋ ruaegobiyoŋ, Kadi buŋore koruŋ qoruine yo odureru bokeegobi: Go ŋiŋigo botuyaŋuŋgo eebobo poretiŋ boyoberu ŋonemaiŋ naduŋgaduŋ eku buŋo damaŋ so boyoberu goigoŋ. Buŋo qoruine oi yameŋ keku boyoberu goinebi eru buŋo memenda oi oŋuakoŋ so odureru bokeinebi. ");
INSERT INTO mlh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jiŋoŋaŋuŋ kobeme ŋiŋigo meyaŋuŋgo roru oga yabeegobi, ŋoŋo nomoruru obuke egu nonimiŋ ore obuŋaŋuŋ saiyaji osoeegobiyoŋ, joma yasogo kamel oi jibu gbagaegobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","O Kadi buŋore qaqaji eru kadi buŋore yameŋyameŋ ŋiŋigo! Ŋoŋo maŋkekerisiere ŋiŋigo sasakiine fukebi yobiŋ paiŋaŋuŋgo ropeiŋ ore eru oŋga joraku ‘Yei!’ migo. Ŋoŋo munaŋqoqo ee eiŋgo ore popu eru gombare saki jure mukuegobiyoŋ, ŋoŋo-ŋaŋunde suroŋ ebu so siŋaŋ garu ya kosa dukuŋ eku taki tomiri ebi oiji maŋ-ŋaŋuŋ puseme gogobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“O jiŋokombi ŋi Kadi buŋore yameŋ keege, go bonieru popure maŋ jurende sakiineji oŋuakoŋ qaŋkisiekiine fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","O Kadi buŋore qaqaji eru yoore yameŋyameŋ ŋiŋigo! Ŋoŋo maŋkekerisiere ŋiŋigo sasakiine fukebi yobiŋ paiŋaŋuŋgo ropeiŋ ore eru oŋga joroku ‘Yei!’ migo. Ŋoŋo jiŋorunde maripoŋ jurebi yagaŋine fukegobi, ore so fukegobi. Sakiŋaŋunji ŋone-aŋiŋaŋuŋke oŋuine fukegobiyoŋ, jiŋorunde maŋgo qoŋgbuŋ sia eru ya mamagiineke pega, oŋuine oiji ŋoŋore maŋ puseru pega. ");
INSERT INTO mlh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","“Ore so ŋoŋo oŋuakoŋ ŋiŋigo jiŋoyaŋuŋgo fofori poretiŋ kamasi fukeegobiyoŋ, maŋkekerisiere sasaki kamasi oi eru penaronji maŋ-ŋaŋuŋ puseko gogobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“O Kadi buŋore qaqaji eru yoore yameŋyameŋ ŋiŋigo! Ŋoŋo maŋkekerisiere ŋiŋigo sasakiine fukebi yobiŋ paiŋaŋuŋgo ropeiŋ ore eru oŋga joroku ‘Yei!’ migo. Ŋoŋo kajeqouŋ ŋiŋigo yoŋore jiŋoruŋgo simeŋ ruaru baegobi eru ŋiŋigo posiine yoŋore ko kouŋ basarigaegobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Oŋu eru iŋi miegobi, ‘Niŋoji apa ŋasopunoŋuŋ yoŋore damaŋgo gonobeŋ ine, yoŋoke so jikigabeneŋ kajeqouŋ ŋiŋigo yoŋore dariji niŋore paio so ropena.’ ");
INSERT INTO mlh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Oŋu miku oiji ŋoŋo-ŋaŋe kajeqouŋ ŋiŋigo yabebuŋ, yoŋore ŋasopu fukegobi, buŋo oi kitiŋgaku miku munaŋ moge oŋuine dimagobi. ");
INSERT INTO mlh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ore eru apa ŋasopuŋaŋunji agiburaŋ fuŋgaru ebuŋ, ore so ŋoŋo jikigaru sosowo eforeinebi. ");
INSERT INTO mlh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“O Farisi, ŋoŋo qoti mendaine oŋuine fukegobi. Anutuji buŋoŋaŋuŋ mitariko misi korugo egu rakanimiŋ ore uruŋu roiŋgaru useru ranobuŋ? Oi embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ore eru maneniŋ, nonji kajeqouŋ eru maŋgboroŋ ŋiŋigo eru Kadi buŋore qaqaji sore yabebe ŋoŋoreo warenimiŋ. Warebi yoŋoreone goine oi yabebi komenimiŋ eru goine maripoŋgo yabenimiŋ. Goine oŋgawowosi piŋaŋuŋgo furu yaberu buŋoyaŋuŋ mitariku ŋoŋoruji yaberu yobe yabebi taoŋine taoŋine oo raenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Ŋi posiine Abelre dariji wakiko oone fuŋgaru yaberu waperu goku Zekaraia boji soriŋ mokiine eru boji koro alata yokore botugo qabi dariine wakiko oo tariya. Ŋiŋigo posiine yoŋore dari moreŋgo keseru gobuŋ, dari sosowo ore geoine oi ŋoŋore paio ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Dariyaŋunde geo sosowo oi ŋiŋigo muŋambe gogobi, ŋoŋore paio ropeko Anutuji geoine bokirie ŋareko manenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesuji miya, “O Jerusalem Jerusalem, ŋoŋo kajeqouŋ ŋiŋigo yabebi komebi Anutuji ŋiŋigo sore yabeko ŋoŋoreo wareegobi, yoŋo koji yabebi komeegobi. Qoqu maŋgoineji odumadepuine toinere rurumaŋgo ruaru kenusu yabeega, nonji ore so damaŋine damaŋine gore kufufuŋpu kenusuku qoju ŋabemiŋgo maneru goboŋyoŋ, ŋoŋo oi taki ŋabeme go wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Maneniŋ, Anutuji soriŋ piŋaŋuŋ ŋadi gako sesuine akoŋ peiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","“Oŋu peiŋyoŋ, nonji iŋi ŋajibe maneniŋ, Ŋoŋo noŋ moke so ŋone nunimiŋ. Jiki damaŋ mo ware fukeko oo ŋone nuru iŋi minimiŋ, ‘Ofonde tinao ware norega, Anutuji iŋo mifia teine.’ Oŋu.” ");
INSERT INTO mlh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuji boji soriŋ bokeru wakiko kiŋariŋpuineji iŋoreo wareru boji sorinde jokoroŋ maŋgo pi ŋebuŋ, oi Yesu odubuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Odubi bokirieru iŋi yajiya, “Pi sosowo oi soine ŋonegobiyoŋ, nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Oi ketotiebi pire ko mo oi ko more paio so peiŋyoŋ, siŋsaŋ sesuine akoŋ peiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuji Oliwe yo tukuo raru ŋeko kiŋariŋpuine yoŋoyoŋe akoŋ iŋoreo wareru iŋi weu tebuŋ, “Qaqaji, buŋo mige, ore foriine mo damaŋgo fukeiŋ eru goji warende morende damaŋ tariiŋgo eiŋ, ore moge oi uruŋu fukeiŋ? Oi soine noji.” ");
INSERT INTO mlh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Oŋu weu tebi bokirieru iŋi miya: “Moji sinefuru eko tiŋtuŋ egu enimiŋ ore sisiŋaŋ eku goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ŋiŋigo kokoineji fukeru nonde tinao iŋi minimiŋ, ‘Nonji Munaŋqoqo Rauine Kristo fukego.’ Oŋu miku ŋiŋigo kokoine eadu yabenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ŋoŋo jigore biŋe eru fonuŋ fukeru raru wareko maneenimiŋ. Oi maneru gburugburu egu qanimiŋ ore ŋoŋo sisiŋaŋ einebi. Ya oŋuine oi ronekoŋ fukeiŋ ore mimiine. Oi fukeiŋyoŋ, morende damanji oo akoŋ pipa so tariiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Kantri moji kantri mo yabenimiŋ ore pakerenimiŋ. Ŋiŋigo kubu moji kubu mo yoŋoke buru baku qoqo ee eiŋgo ore pakerenimiŋ. Moreŋine moreŋine oo roroine roroine fukeiŋ eru komeŋ sogo sogo oi unugaru baku moreŋ bokirieme rakaeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ya sosowo oi ŋigo kuakeji goji fuŋgaru ki yabeega ore sogo. Morende damanji ore so fuŋgaru tariiŋgo eiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Oŋu eiŋyoŋ, damaŋ oo goineji ŋoŋo maŋ-ŋaŋuŋ kerisiebuŋ ore eru gawman yoŋore meo rua ŋabebi joiserereŋ eŋareku ŋabebi komenimiŋ. Kantri sosowo yoŋoji nonde eru rosi eŋareenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Damaŋ oo kokoineji mamanesiŋyaŋuŋ bokeru soŋsoŋburu baku rosi eru qoqo enimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kajeqouŋ ŋiŋigo jijibuine kokoineji fukeru ŋiŋigo kokoine kunuŋkunuŋ eyarebi tiŋtuŋ qaku raenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","“Jauba Rauineji saueru ŋiŋigo siŋaŋ yabeiŋ ore eru maŋkekerisie ŋiŋigo boakoŋ yoŋore manji munaŋgako manjokoyaŋunji gbaŋiru jimigaeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Moji yameŋ keku sanaŋgaru qiŋ keru dimaku goko morende damanji tariiŋ, iŋoji seŋgiŋbaŋgiŋ raugaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anuture qorumande Bobiaŋ Biŋe yo bonieru morende kantriine kantriine sosowo oo misauebi kufufuŋ so kikitiŋ buŋo mane forebi morende damanji ore ŋadiineo tariiŋ. Oŋu.” ");
INSERT INTO mlh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kajeqouŋ ŋi Danielji ketoqototie aariineke ore buŋoine mime pega. Buŋo ore so goineji wareru ketoqototie eru ya aŋgiŋineke oi boji soriŋ tiriineo ruabi dimako ŋonenimiŋ, buŋo yo osemiŋ, goji soine kaje ruaru mane mukuigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Damaŋ oo Judia prowinsgo gonimiŋ, yoŋoji use poreru tukuo rainebi. ");
INSERT INTO mlh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pi bembeŋgo kae jiŋoo goiŋ, iŋoji wakiru kekere yaine roiŋ ore pi maŋgo so ropeine. ");
INSERT INTO mlh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gioo raru goiŋ, iŋoji oŋuakoŋ marikuine roiŋ ore kirieru pigo so raine. ");
INSERT INTO mlh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Yei! Ŋigo kuake eru odumade moŋgo yoŋoji damaŋ oo uruŋu pipa ranobuŋ? ");
INSERT INTO mlh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ore eru ya oi kueyoiko me Sabat kombande damaŋgo so fukeiŋ ore oŋga wosieinebi. ");
INSERT INTO mlh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“Oi iŋi ore: Damaŋ oo sisikoŋkoŋ qembibiineke fukeiŋ. Sisikoŋkoŋ soine oŋuine oi ronekoŋ damaŋ mogo so fukeru peya. Anutuji ya sosowo bofukeya, damaŋ oo akoŋ fuŋgaru damaŋ yoo go waperu damaŋ botuineo mo so fukeya. Ronekoŋ so fukeya eru jiki damaŋ mogo moke so fukeiŋ. Ore eru ŋoŋo oŋga wosiru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ofonji bapeboriŋ damaŋ oi so qondiŋgana ine, ŋiŋigo sosowoji sibiriga forenobuŋyoŋ, ŋiŋigo iŋoyoŋunde roosoe yabeya, yoŋore eru una ore jare oi qondiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Damaŋ oo iŋi minimiŋ, ‘Maneniŋ! Kristoji yoo goga,’ me ‘Ŋoneniŋ! Munaŋqoqo Rauineji aroo dimaga.’ Moji oŋu miiŋ ine, oi so manesiŋ gainebi. ");
INSERT INTO mlh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Oi iŋi ore migo: Munaŋqoqo rauine ikoine eru kajeqouŋ ŋiŋigo jijibuine fukeru mosi qoqowirie eru soi sogo sogo babi qowirienimiŋ. Oŋu qowiriebi Anutuji ŋiŋigo iŋoyoŋunde roosoe yabeya, oi oŋuakoŋ bojiqojibu eyarenimiŋgo esoigaru yameŋ kebi tiŋtuŋ egu enimiŋ. Ŋoŋo sisiŋaŋ fiine akoŋ eku gobi oi embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Maneniŋ! Nonji ya sosowo oi so fukeko ronekoŋ ŋajibe mane foregobi. ");
INSERT INTO mlh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ore eru ‘Munaŋqoqo Rauineji moreŋ buroineo goga,’ oŋu mibi manenimiŋ ine, oo so rainebi. Me ‘Maneniŋ! Kristoji pi ore maŋgo fukeru ŋega,’ oŋu ŋajibi oi so manesiŋ gainebi. ");
INSERT INTO mlh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Oi iŋi ore migo: Sombuŋ eru morende Ŋi foriineji moke wareiŋ, damaŋ oo boborire so iŋi fukeiŋ: Oi wegi wawapeineone pipa borigaru aribe wegi rarakaineo sagaru tamaeru rako ŋonegobeneŋ, iŋoji ore so fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Joma komekiineji mogobe peiŋ, sonomeŋ yoŋoji oo poreru tumaŋgaegobi, ore so fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Koŋkoŋ damaŋ oiji tariko oo akoŋ wegi jiŋoji gobureko ayonji dabueiŋ. Bobuŋ yoŋoji qonikiŋgone mukuru wakinimiŋ eru qonikinji itiriŋgako ore yareya oi ŋeŋeyaŋuŋ bokeru bojiqojibu ebi jibugaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Damaŋ oo Sombuŋ eru morende Ŋi foriinere mogeji qonikiŋgo fukeko ŋonenimiŋ. Damaŋ oo morende kufufuŋ sosowo yoŋoji jiŋgeŋ keku kuyonimiŋ. Kuyoru Sombuŋ eru morende Ŋi foriine iŋoji qonikinde kuaŋ paio wareko ŋonenimiŋ. Usuŋine soguineji gbuŋgbasaŋineke totogo fukeko kuririquraŋine ŋonenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wareme ŋonebi qeŋ fuŋine mo putebi fonuŋine sanaŋine manebi Sombuŋ mimerereŋpuine sore yabeko yoŋoji ŋiŋigo Anutu iŋoyoŋunde roosoe yabeya, oi moreŋ qaŋaŋine mobemobe paibe yukube oone qoju yaberu oga yabenimiŋ. Oŋu.” ");
INSERT INTO mlh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ŋoŋo oguŋ yo ŋoneru kamasiine manesuku soso buŋo yo maneinebi. Tieŋineji obuineke fukeko rekaine posebi oi ŋoneru maneru iŋi miegobi, ‘Wegi damaŋine bembeŋgaga.’ ");
INSERT INTO mlh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ŋoŋoji oŋuakoŋ moge ore so fukeko ŋoneru mane taniŋgaru fuŋine iŋi miinebi, ‘Yesuji mendigo bombeŋgaga.’ ");
INSERT INTO mlh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Ŋiŋigo yo muŋambe moreŋgo gogobi, yoŋoji so komebi ya sosowo migo, oi yoŋore gogo damaŋgo fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Qonikiŋ eru morenji mataenimiyoŋ, nonde Biŋe buŋoji damaŋ mogo so mataeiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Sombuŋ eru morende Ŋi foriineji wareiŋyoŋ, wamo damaŋgo wareru fukeiŋ, ore unaine me aua damaŋine oi moji mo so manega. Sombuŋ mimererenji oi so manegobi. Anuture Madeji oŋuakoŋ oi so manega. Mamaji iŋoyoŋe akoŋ oi manega. ");
INSERT INTO mlh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ronekoŋ Noare damaŋgo ŋiŋigoji gogoyaŋuŋ qaqosori paio goku bosembeabuŋ, ore so Sombuŋ eru morende Ŋi foriineji moke wareinde damaŋgo fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","“Obu yoiko yasogoji so wareko ronekoŋ oo ŋiŋigo uqo jebe ruaru obu sanaŋine noku ŋigo furiine babi raru wareko rorobaba eku gobuŋ. Eebobo oŋu eba eku qaqosori gobi Noaji ogâ maŋineo ropeya, una oo tariya. ");
INSERT INTO mlh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tariko wamo ya fukeiŋ, oi so manebi obu yoiko yasogoji wareru jeŋgoma sibiri yabeya. Jiki Sombuŋ eru morende Ŋi foriineji moke wareiŋ, damaŋ oo ŋiŋigoji oŋuakoŋ qaqosori eru goku sibiriganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Damaŋ oo ŋi yoyoka gioo gobire yokoreone mo roru mo bokenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Oŋuakoŋ ŋigo yoyoka garaŋ pujeku ŋenimi, yokoreone mo roru mo bokenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ofonji wareinde damaŋ me aua so manegobi ore eru maŋgarigari goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Maŋgari gokiminde buŋo yo mane mukuinebi: Ubuo suroŋqoqo ŋiji wamo damaŋgo me auago wareiŋ, pi rauineji oi manena ine, iŋoji gariine ŋeku piine fiine akoŋ siŋaŋ bako qajaŋgaru ropeiŋgo embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ŋoŋo ‘Sombuŋ eru morende Ŋi foriineji damaŋ yoo so wapeiŋ,’ miku manesubi iŋoji damaŋ oo akoŋ wapeiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Oŋu fukeko gio bobo ŋiŋigo botuyaŋuŋgo moji qembibiineke fukeru goine yadurega? Goineji gbaŋiru gio bokebi moji mamane-muku oroinere paio yameŋ keku damaŋ so baega, iŋoji kiwaqawaineke fukega. Pi rauineji eeboboine osoeru ŋoneru mogobe raru pire yareya oi meineo ruame siŋaŋine fukeiŋ. Siŋaŋine fukeru kiŋaŋqoqopuine ojiya ore so siŋaŋ yaberu damaŋ poretiŋ oo gume yabeeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Oŋu siŋaŋ yaberu gome rauineji kirieru wareru oŋuine ŋoneru ‘Go kiwaqawagake fukege!’ miiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Rauineji ‘Go kiwaqawagake fukege!’ miku meboine sosowore siŋaŋ igodoŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Igodoŋgaiŋyoŋ, gio bobo gbagbaŋine iŋoji maŋineo manesuku iŋi miiŋ ine, ‘Ofoŋnere waware damanji joroine pega.’ ");
INSERT INTO mlh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Oŋu miku fuŋgaru gio bobo ŋiŋigopuine yaberu yobe imo eru jebe ruaru jerieru obu sanaŋine noku maŋine jibugako bojiqojibu keoma fukeru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","“Oŋu goku damaŋ mogo ofoŋine wapeiŋgo so odigaiŋ, iŋoji oo akoŋ wapeiŋ. Damande nomeniga qaqouma gokame aua oo akoŋ waperu ");
INSERT INTO mlh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","qaku boserereŋ eteru mitigako maŋkekerisiere ŋiŋigo sasakiine oŋuine misi korugo rakaru joiserereŋ maneiŋ. Oŋu maneru kuyo jojoraru ŋiraŋyaŋuŋ kibi qako gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesuji miya, “Moke warebemiŋ, damaŋ oo Sombunde qorumaŋ oi iŋi fukeiŋ: Suanjeŋ jebe damaŋgo ŋigo jeŋoŋ jumuine ten yoŋoji ‘Ŋi biŋeke qoturekimiŋ,’ miku doiyaŋuŋ roru kadio rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yoŋoreone 5 yoŋo mamane-mukuyaŋuŋke fukebuŋyoŋ, goine 5 oi biriine. ");
INSERT INTO mlh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Biriine yoŋoji doiyaŋuŋ robuŋyoŋ, misi (kufaŋ) jiji so roru rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mamane-mukuyaŋuŋke yoŋoji doiyaŋuŋ eru kufaŋ jiji sogoyaŋuŋ oŋuakoŋ roru rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Rabi ŋi biŋeji pipa so wareko odigabi damaŋ joroya ore sosowo yoŋo bedaŋgaru daberu kubaŋ pebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kubaŋ pebuŋyoŋ, ubu botuineo moji qeŋ puteme buŋo iŋi manebuŋ, ‘Maneniŋ, ŋi biŋeji warega-oo! Ŋoŋo iŋoreo raru qotureniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Buŋo oi maneru ŋigo jeŋoŋ ten oi sosowoji pakereru doiyaŋuŋ roru bobiaŋgaru qurebi. ");
INSERT INTO mlh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Qurebi biriine yoŋoji ŋigo mamane-mukuyaŋuŋke yoŋoreo wareru iŋi mibuŋ, ‘Niŋore doi kobega ore ŋoŋo kufaŋ jiji goine noreniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Oŋu mibi mamane-mukuyaŋuŋke yoŋoji bokirieru iŋi mibuŋ, ‘Mata! Oi ŋoŋo eru niŋo so saga nobeiŋ. Ore eru seki pigo raru ŋoŋo-ŋaŋunde kufaŋ jiji furiine baniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Oŋu mibuŋyoŋ, yoŋoji kufaŋ jiji furiine baiŋgo raru kadio gokabi ŋi biŋeji oo akoŋ wapeya. Ŋigo jeŋoŋ jaueru dimabuŋ, yoŋoji raru iŋoke qotureru suanjeŋ jebe pi maŋineo ropebi mendi kebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ŋigo jeŋoŋ nareŋgareŋ pigo rabuŋ, yoŋoji oŋuakoŋ jiki waperu mendigo qaku iŋi oŋgabuŋ, ‘Ofoŋ Ofoŋ, go mendi ro nore!’ ");
INSERT INTO mlh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Oŋu oŋgabuŋyoŋ, iŋi bokirieru miya, ‘Mata! Noŋ ŋoŋo so mane ŋabego. Buŋo oi foriine ŋajigo.’” ");
INSERT INTO mlh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesuji soso buŋo oŋu miku kiŋariŋpuine buŋo iŋi yajiya, “Ŋoŋo noŋ warebeminde damaŋ me aua so manegobi ore eru maŋgarigari goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ŋoŋo soso buŋo yoore so fukeiŋ: Ŋi mo kaeine bokeru jorigo kantri mogobe raiŋgo maneru kiŋaŋqoqopuine oŋga yareko warebi moneŋ meboine siŋaŋ ganiminde mitiga yareru meyaŋuŋgo ruaya. ");
INSERT INTO mlh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Gio boboyaŋuŋ osoeru foriine wojimu fukeiŋ ore so maneru gio bobo ŋi more moneŋ komoŋ 5 (Kina 20,000) oteru mo moneŋ komoŋ yoyoka (Kina 8,000) oteru mo moakoŋ (Kina 4,000) oteya. Oŋu siŋaŋ ganimiŋ ore boroiŋgaru yareru boke yaberu raya. ");
INSERT INTO mlh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Ŋi komoŋ 5 (Kina 20,000) roya, iŋoji oo akoŋ raru rojiki-bajiki gio bako moneŋ saueko komoŋ 5 jikigaru roya. ");
INSERT INTO mlh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Oŋuakoŋ komoŋ yoyoka (Kina 8,000) roya, iŋoji raru rojiki-bajiki gio bako moneŋ saueko komoŋ yoyoka jikigaru roya. ");
INSERT INTO mlh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Oŋu robuyoŋ, ŋi moneŋ komoŋ moakoŋ (Kina 4,000) roya, iŋoji bokeru raru moreŋ sikeku ŋi siŋaŋinere moneŋ yoŋ gaku sumuŋgaya. ");
INSERT INTO mlh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Damaŋ joroine tariko kiŋaŋqoqo yoŋore ŋi siŋanji kirieru wareru ‘Gio babuŋ ore sunduyaŋuŋ maneru osoebemiŋ,’ miku kepore yabeko warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Oŋu warebi ŋi komoŋ 5 (Kina 20,000) roya, iŋoji jiŋo maiineo waperu komoŋ 5 moke jikigaru roru wareru iŋi ojiya, ‘Sogunene mane, goji moneŋ komoŋ 5 naremeŋ, nonji ore rojiki-bajikiine babe saueko komoŋ 5 moke fukeko roru warego.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Oŋu ojiko ŋi siŋaŋineji iŋi bokirie teya, ‘Oi fiine. Go gio bobo ŋi fiine bose-qosembego tomiri. Go ya afaine roru oi yameŋ keku siŋaŋ garu gokande saueya. Ore eru nonji ya kokoine gore meo ruabe ore siŋaŋ goigoŋ. Soine wareru ŋi siŋaŋgo nonde pi maŋgo waperu moko jeribari eru gokimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ŋi moneŋ komoŋ yoyoka (Kina 8,000) roya, iŋoji oŋuakoŋ waperu iŋi ojiya, ‘Sogunene mane, goji moneŋ komoŋ yoyoka naremeŋ, nonji ore rojiki-bajikiine babe saueko komoŋ yoyoka moke fukeko roru warego.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Oŋu ojiko ŋi siŋaŋineji iŋi bokirie teya, ‘Oi fiine. Go gio bobo ŋi fiine bose-qosembego tomiri. Go ya afaine roru oi yameŋ keku siŋaŋ garu gokande saueya. Ore eru nonji ya kokoine gore meo ruabe ore siŋaŋ goigoŋ. Soine wareru ŋi siŋaŋgo nonde pi maŋgo waperu moko jeribari eru gokimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ore ŋadiineo ŋi moneŋ komoŋ moakoŋ (Kina 4,000) roya, iŋoji waperu iŋi ojiya, ‘Sogunene mane, nonji fuŋnego iŋi mane mukuboŋ: Ŋi Ofoŋneji ŋi sanaŋine joineke fukega. Gake uqo koruŋ so qopogaru tiende oo jibu foriine siqoji ketigaru roiŋgo maneege. Kurumbu koruŋ so sarinde rakako oo jibu foriine roru qojugaiŋgo maneege. ");
INSERT INTO mlh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","“Oŋu mane mukuku kokoi maneru raru gore moneŋ komoŋgo oi moreŋgo sumuŋgabe peya. Ŋone, moneŋ komoŋ naremeŋ, oi akoŋ poretiŋ yo.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Oŋu ojiru oi oteyayoŋ, ŋi siŋaŋineji bokirieru iŋi miteya, ‘Go rembeŋine fukeru kiŋaŋqoqo sembene fukege! Go fuŋnene mane mukumeŋ: Nake uqo koruŋ so qopogaru tiebe oo jibu foriine siqoji ketigaru robemiŋgo maneego. Nake kurumbu koruŋ so saribe rakako oo jibu foriine roru qojugabemiŋgo maneego. Nonde kamasi oŋuine mane mukumeŋ eru wamore jibugaru gomeŋ? ");
INSERT INTO mlh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","“Go nonde moneŋ oi benk pigo ruande sagana. Beŋk pigo ruande sogueme kirieru wareboŋ, damaŋ yoo oi soine sisiineke ronobo.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jikigaru goine oi yajiya, ‘Ŋoŋo qefeŋ rembeŋ ŋi yoore moneŋ komoŋ oi ogaru mo komoŋ 10 bofukeya, oi oteniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Soso buŋo yoore fuŋne oi iŋi: Uri yoŋore ya pega, sosowo yoŋore oi jikigaru yarebi saueko boakoŋ yobu pe yareiŋ. Oŋu saueiŋyoŋ, more ya mo so pega, iŋore ya oi oŋuakoŋ ogabi mo yobu goiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ayo, kiŋaŋqoqo ŋi omaine gioinere fori tomiri oi sakibe igogabi qisirigo rakaine. Oo rakaru kuyo jojoraru gobuyaŋuŋ kibi qako gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Sombuŋ eru morende Ŋi foriineji dimaku Sombuŋ mimerereŋ sosowo oga yaberu moko warenimiŋ, damaŋ oo Sombunde kuririquranji fukeko iŋoji Kiŋ Ofonde morumboŋ ŋeŋeo ŋeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ŋeku miko morende ŋiŋigo kubu sosowo qoju yabebi iŋore jiŋo maio fukenimiŋ. Fukebi lama siŋanji lamapuine noniŋ yoŋoreone osoeru boroiŋ yabega, ore so oi boroqoroiŋ eyareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Oi eyareku miko lama oi me furoineo erunoniŋ oi kijoineo rua yabenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Oŋu rua yabebi Kiŋ Ofonji me furoineo dimanimiŋ, oi iŋi yajiiŋ, ‘Nonde Mamaji mifia ŋareko gobuŋ, ŋoŋo wareniŋ. Mama Anutunoŋunji moreŋ sosowo bofuke yabeya, damaŋ oo akoŋ qorumaŋ ŋoŋore bomogaru bako jaueru pe wapega, ŋoŋo wareru oi raugaru goinebi. ");
INSERT INTO mlh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“Oi iŋi ore migo: Nonji uqonere komeru gobe ŋoŋo uqo munjaŋ nareku gobuŋ. Nonji obure komeru gobe ŋoŋo obu nareku gobuŋ. Nonji kotu fukeru gobe ŋoŋo kepore nubi piŋaŋuŋgo roperu goboŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nonji saki komoŋnere embimbiŋgaru gobe ŋoŋo kambaŋ kereŋ nareku gobuŋ. Nonji jibe ba nume gobe ŋoŋo maŋgo enareku gobuŋ. Nonji witi pigo gobe ŋoŋo noŋ ŋone nunimiŋgo oo wareru gobuŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Oŋu yajiko ŋiŋigo posiine yoŋoji iŋi bokirieru minimiŋ, ‘Ofoŋ, go wamo damaŋgo uqogore komende ŋoneru gume guru gobeŋ? Eru mo damaŋgo obure komeru gokande ŋoneru obu gareru gobeŋ? ");
INSERT INTO mlh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Eru wamo damaŋgo kotu gokande ŋone guru kepore gubeneŋ pinoŋuŋgo ropende gobeŋ? Eru wamo damaŋgo saki komoŋgore embimbiŋgaru gokande ŋone guru kambaŋ kereŋ gareru gobeŋ? ");
INSERT INTO mlh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","“Eru wamo damaŋgo jibe ba gume pende ŋone guru me witi pigo gokande maneru go ŋone guiŋgo goreo wareru gobeŋ?’ ");
INSERT INTO mlh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Oŋu mibi Kiŋ Ofonji bokirieru iŋi yajiiŋ, ‘Noŋ buŋo foriine mo iŋi ŋajibe maneniŋ: Ŋoŋo nakene maŋkekerisie ogopune wawakiine yo yoŋoreone more ya mo ebuŋ, oi sosowo noŋ enareku gobuŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Oŋu miku ore ŋadiineo me kijoineo dimanimiŋ, yoŋoreo kirieru iŋi yajiiŋ, ‘Mamaneji qaiso ŋabeme gobuŋ, ŋoŋo boke nuru useniŋ. Misi koru tatariine tomiri ja ropeiŋ, oo raru rakaniŋ. Anutuji oi Sembene Rauine eru iŋore mimerereŋpu yoŋore bomogaru bame jaueru pe wapega. ");
INSERT INTO mlh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Oi iŋi ore ŋajigo: Nonji uqonere komeru gobe ŋoŋo uqo munjaŋ so nareku gobuŋ. Nonji obure komeru gobe ŋoŋo obu so nareku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","“Nonji kotu fukeru gobe ŋoŋo so kepore nubi piŋaŋuŋgo so roperu goboŋ. Nonji saki komoŋnere embimbiŋgaru gobe ŋoŋo kambaŋ kereŋ so nareku gobuŋ. Nonji jibe ba nume peboŋ eru witi pigo goboŋyoŋ, ŋoŋo noŋ ŋone nunimiŋgo oo so wareru gobuŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Oŋu yajiko yoŋoji oŋuakoŋ bokirieru iŋi minimiŋ, ‘Ofoŋ, go wamo damaŋgo uqogore komemeŋ me obure komeru gomeŋ me kotu gomeŋ me saki komoŋgore embimbiŋgaru gomeŋ me jibe ba guko pemeŋ me witi pigo gokande niŋo go so kiŋaŋ qa gareru gobeŋ?’ ");
INSERT INTO mlh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Oŋu mibi bokirieru iŋi yajiiŋ, ‘Nonji buŋo foriine iŋi ŋajibe maneniŋ: Ŋoŋo maŋkekerisie ogopune wawakiine yo yoŋoreone more ya mo so ebuŋ, oi sosowo noŋ so enareku gobuŋ fukega.’ ");
INSERT INTO mlh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Oŋu yajiko geoine bokirie yareme paiyaŋuŋgo ropeko igo yabeko rakaru joiserereŋ damaŋ tatariine tomiri maneru go ropenimiŋ. Oŋu go ropenimiŋyoŋ, posiine yoŋoji seŋgiŋbaŋgiŋ gogo oi damaŋ tatariine tomiri go roperu gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuji buŋo sosowo oi miforeru kiŋariŋpuine iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Una yoyoka tariko pasowa kombaŋ wareru fukeiŋ. Ŋoŋo oi soine manegobi. Wareru fukeko Sombuŋ eru morende Ŋi foriine oi kotu gawman yoŋore meo ruabi maripoŋgo qabi komeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Damaŋ oo soriŋ gio siŋaŋ eru kantrire minebobo yoŋoji tumaŋgaru soriŋ gio siŋaŋ qoruine tinaine Kaiafas iŋore morumboŋ piineo ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Oo ŋeku uruŋu gbegbedi ebeneŋ Yesu sumuŋgaru roru qabi komena, ore fuŋine baaru osoebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Baaru osoeru iŋi mibuŋ, “Ŋiŋigo maŋyaŋuŋ rigaŋgame jigo oyowoine oyowoine egu qoqo enimiŋ ore oi jeri kombaŋ damaŋgo ekimiŋgo embimbiŋgakimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuji Betani kaeo goku Saimon mo wakoine bofosikeya, iŋore pigo roperu ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Oo uqo noku ŋeko ŋigo moji ko sogo mo roru iŋoreo wareya. Sogo oi ko yayagaŋ tinaine alabasta oiji bakine. Oi obu junjinaŋ kouineke oiji pusekiine. Iŋoji oi furiine sogoji baku wareru obuine Yesure qorugo keseru rau teya. ");
INSERT INTO mlh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Rau teme kiŋariŋpuineji oi ŋoneru maŋyaŋuŋ sembeame iŋi mibuŋ, “Oi wamore oŋu sibirigaga? ");
INSERT INTO mlh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Obu jijiineke oi furiine banimiŋ ore ruako moneŋ ropekiine fukeko oi ŋiŋigo wakiqoqoine yareme sagana.” ");
INSERT INTO mlh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesuji maŋ mamaneyaŋuŋ oi ŋone mukuru iŋi yajiya, “Ŋigo yoore maŋ oi wamore bosembeagobi? Iŋoji mosi fiine enare sarigako sagaga. ");
INSERT INTO mlh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ŋiŋigo wakiqoqoine oi damaŋine damaŋine botuŋaŋuŋgo gonimiŋyoŋ, nonji ŋoŋore botugo damaŋ so, so gobemiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nonji komebe yaŋga nunimiŋ ore eru jijiji sakine rau narega. ");
INSERT INTO mlh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Bobiaŋ Biŋe yo kantri oo me oo misauebi raiŋ, oo ŋigo yoji ya enarega, ore biŋeine oŋuakoŋ mibi saueko iŋore manesuku gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Damaŋ oo kiŋariŋpuine 12 yoŋoreone mo tinaine Judas Iskariot iŋoji soriŋ gio siŋaŋ yoŋoreo raru ");
INSERT INTO mlh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","iŋi weu yareya, “Nonji Yesu babae bateku meŋaŋuŋgo ruabe ŋoŋoji wamo furi narenimiŋ?” Weu yareme silwa moneŋ koruŋ 30 osegaru meineo ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aua oo akoŋ fuŋgaru Yesu damaŋ mogo babae bateinde kadi maneru ru ŋoneyoyobe eku goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Poroŋ yistine tomiri ore kombaŋ una fuŋfuŋgaineo (Sekiqonogo) kiŋariŋ yoyoka yokoji Yesureo wareru iŋi weu tebu, “Qaqaji, niko pi uro raru pasowa lama bomoga garebere nomiŋ? Aŋigo uruŋu pega?” ");
INSERT INTO mlh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Weu tebire iŋi bokirieya, “Ŋoko Jerusalem sitio roperu ŋi mo manego, oi bofukeru iŋi ojini, ‘Qaqajiji miga: Nonde damanji bembeŋgaga. Nonji gore pigo wareru kiŋariŋpune yoŋoke Pasowa lama nokimiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kiŋariŋ yokoji Yesu mitiga yateya, ore so boyoberu Pasowa lama bomogabu. ");
INSERT INTO mlh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kae iŋaŋgaru ubu eko Yesuji kiŋariŋpuine 12 yoŋoke pi oo waperu roperu ŋeŋe bembeŋgo ŋeku uqo boroiŋgaru nobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Uqo noku ŋeku Yesuji iŋi yajiya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Ŋoŋoreone moji babae ba nuiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Oŋu yajiko maneru oo akoŋ maŋyaŋuŋgo beusembe yasogo fukeko fuŋgaru bubu weu teru ojibuŋ, “Ofoŋ, goji nonde egu mimiŋ?” ");
INSERT INTO mlh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Weu tebi iŋi bokirieya, “Noke poroŋ sigo igokurugaga, iŋoji. ");
INSERT INTO mlh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sombuŋ eru morende Ŋi foriineji iŋore buŋo quraŋgabi pega ore so fofori moreŋ bokeru raiŋyoŋ, moji iŋo babae bateiŋ, iŋore ‘Yei!’ miku oŋga jojorago. Ore geoine mimiineji iŋore paio ropeiŋ. Ŋi oi maŋgo kua maŋineone so fukena, oiji afaga tena.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Oŋu bokirieme Judas babae bateiŋ, iŋoji iŋi bokirieru ojiya, “Qaqaji, oi nonde egu mimiŋ?” Yesuji iŋi ojiya, “Mige, oi oŋu!” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Uqo noku ŋeku Yesuji poroŋ roru mifiagaru bajiku yareru iŋi yajiya, “Yo nakene fu. Oi roru noniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Oŋu yajiru wain popu roru oŋga wosiru daŋge miku yareru iŋi yajiya, “Ŋoŋo sosowo popu yoone noniŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yo nakene dari. Oi Anutuji ŋiŋigo yoŋoke jojofo buru eko sanaŋgaiŋ ore darine kesiebi rakako ŋiŋigo kokoine yoŋore agiburaŋyaŋuŋ bokeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nonji buŋo mo iŋi ŋajibe maneniŋ: Nonji wain niginde fori yo moke jikigaru so nobemiŋ. Jiki Mamanere qorumaŋ maŋgo paibe ŋebeneŋ tebu jebe ruaiŋ, una oo wain obu fuŋine mo oi ŋoŋoke nobemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Oŋu yajiru jeri kiki keku bokeru raru Oliwe yo tukuo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Roperu Yesuji iŋi yajiya, “Kajeqouŋ ŋi moji buŋo mo iŋi quraŋgame pega, ‘Nonji siŋaŋyaŋuŋ qabe lama qokoineji roiŋganimiŋ.’ Ore so ŋoŋoji sosowo muŋambe ubune maŋ-ŋaŋuŋ nonde eru sembeako boke nuru totienimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Totiebi nunimiŋyoŋ, nonji komegone pakereru bonieru Galili prowinsgo raru oo fuke ŋarebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Oŋu yajime Pitaji bokirieru iŋi miya, “Yoŋoji sosowo maŋyaŋuŋ gore eru sembeame boke guru totienimiŋ ine, nonji jibu damaŋ mogo so boke gubemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Miko Yesuji ojiya, “Nonji buŋo foriine mo iŋi gajibemiŋ: Qoquji so qako goji muŋambe ubune muga nunde ateine yokaomo fukeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Oŋu miyayoŋ, Pitaji iŋi ojiya, “Qaqaji, oŋu matayoŋ, noŋ nubi goke moko komenobe, oi jibu nonji go so muga gubemiŋ.” Kiŋariŋ goine sosowo oŋuakoŋ buŋo oi akoŋ mibuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Oŋu mimane eku raru yoŋoke kaesesu mo tinaine Gezemane oo ropebuŋ. Roperu Yesuji kiŋariŋpuine iŋi yajiya, “Nonji aroo raru oŋga wosibe ŋoŋo damaŋ botuineo yoo ŋeniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Oŋu yajiru Pita eru Zebedi madeyokaine yoyoka oga yaperu rabi Yesuji fuŋgaru beusembe maneru koŋkoŋ fukeko me kufuine qomukuya. ");
INSERT INTO mlh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Damaŋ oo iŋi yajiya, “Nonde manji jaja bame wapega ore eru beusembe manebe komeiŋ enarega. Ŋoŋo yoo ŋeku noke gariine gokimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Oŋu yajiru iŋoyoŋe akoŋ kokiine mo jikigaru raru dikanji keru daberu iŋi oŋga wosiru miya, “Mamane, go ya mo baiŋgo so embimbiŋgaege. Ore eru aŋigo pega ine, joisererende popu yo oi nonde paineo egu ropeiŋ ore oi nowaro. Nowaromiŋ me mata, oi gogakere maŋ aŋigo fukeine. Oi nonde aŋire so mata!” ");
INSERT INTO mlh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Oŋu miku kirieme kiŋariŋpuine yokaomo yoŋoji kubaŋ pebi ŋone yaberu Pita iŋi ojiya, “Ŋoŋo aua moakomeŋ noke gariine gokimiŋ ore so sanaŋgagobi me? ");
INSERT INTO mlh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Maŋnoŋunji gariine gokiminde aŋi maneegobeneŋyoŋ, sakinoŋunji bedaŋine fukega. Ore eru eesoigo egu waki ŋabeiŋ ore ŋoŋo oŋga wosiru gariine goinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Oŋu ojiru moke boke yaberu raru ateine yoyoka fukeko iŋi oŋga wosiru miya, “Mamane, joisererende popu yoji so nadureiŋ ine, oi soine nobemiŋyoŋ, oi gogakere maŋ aŋigo fukeine.” ");
INSERT INTO mlh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Oŋga wosiru kirieme jiŋo kopiyaŋuŋ bedaŋgaya ore eru moke kubaŋ akoŋ pebi ŋone yabeya. ");
INSERT INTO mlh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Moke boke yaberu aribe raru buŋo oi akoŋ moke miku oŋga wosiko ateine yokaomo eya. ");
INSERT INTO mlh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kiŋariŋ yoŋoreo kirieru wareru iŋi yajiya, “Ŋoŋo jikigaru pema neru kubaŋ akoŋ penimiŋgo manegobi me? Maneniŋ! Moji Sombuŋ eru morende Ŋi foriine babae bateme gawman ŋi kekesuesueyaŋuŋke yoŋore meo ropeiŋ. Ore aua damaŋineji ware forega. ");
INSERT INTO mlh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ŋoŋo pakerebi raki! Babae banuiŋ, iŋoji bembeŋgo yoo warega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuji oŋu miku dimako oo kiŋariŋpuine 12 yoŋoreone mo tinaine Judas iŋoji kubu soguine mo mine bayareko wapebuŋ. Soriŋ gio siŋaŋ eru kantrire minebobo yoŋoji oi sore yabebi jigore siqo soguine eru damuyaŋuŋ roru warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Babae baiŋgo eya, iŋoji bonieru yoŋoke somiti buŋo iŋi kiperu yajiya, “Nonji ŋi mudugabemiŋ, iŋoji oi fukega. Oi roru kipeinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Oŋu yajiru wareru oo akoŋ Yesureo roperu “Qaqajine, sagego!” miku bibiine mudugaya. ");
INSERT INTO mlh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mudugako Yesuji iŋi ojiya, “Ogone, go wamore warege, oi pipa eigoŋ.” Oŋu ojiko ŋi kubu yoŋoji Yesureo waperu qafagaru roru kipebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kipebi Yesuke gobuŋ, yoŋoreone moji meineji jigore siqo sogo poreru soriŋ gio siŋaŋ qoruinere kiŋaŋqoqo qaku kajeine mobeine kemukume wakiya. ");
INSERT INTO mlh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesuji oi ŋoneru iŋi ojiya, “Oi boke! Furuji jigore siqo sogo ronimiŋ, oi sosowo jigore siqo sogoji yabeko komenimiŋ. Ore eru siqogo goyoŋgo ruande rakanoŋ! ");
INSERT INTO mlh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nonji Mamane oŋga wosibe soine bapi nuiŋ, oi manege me mata? Oŋga wosi tenobo, iŋoji oo akoŋ mimerereŋ mamari kubu 12 odureru sore yabeko wareru bapi nunobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bapi nunobuŋ ine, Biŋe Qurande buŋoji uruŋu foriineke fukena? Biŋe Quraŋ buŋore so ya yoji fukeiŋgo ore mimiine fukega.” ");
INSERT INTO mlh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Damaŋ oo akoŋ Yesuji mamari kubu oi iŋi yajiya, “Noŋ suroŋqoqo ŋi matayoŋ, jibu nonde oŋu maneru jigore siqo sogo eru damu baru ro nuru kipe nunimiŋ ore wapegobi. Nonji una so boji soriŋgo ŋoŋoke ŋeku dimaku Biŋe buŋo qaji yareru gobe so ro nubuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Oŋuyoŋ, ya sosowo yo kajeqouŋ ŋiŋigoji buŋo quraŋgabuŋ, oiji foriineke fukeiŋgo ore fukega.” Yesu kipebi kiŋariŋ yoŋoji sosowo Yesu bokeru totieru roiŋgaru rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mamari ŋi Yesu roru kipebuŋ, yoŋoji iŋo ogaru soriŋ gio siŋaŋ qoruine tinaine Kaiafas iŋore pigo rabuŋ. Rabi Kadi buŋore qaqaji eru kantrire minebobo yoŋoji oo wareru tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Rabi Pitaji taitai boyobe yabeku oo roperu morumboŋ pire sa maŋgo ropeya. Roperu tatariineo uruŋu fukeiŋ, oi ŋoneiŋgo ore kiŋaŋqoqo ŋi yoŋore botugo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Oŋu ŋeyayoŋ, soriŋ gio siŋaŋ eru soriŋ kaunsol kubu yoŋoji Yesure sakigo rurua buŋo uruŋu gbedigaru kitiŋgaku mibeneŋ qabi komeiŋ ore baabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Baaru dimaku kokoineji pakereru dimaku buŋo ikoine Yesure sakigo ruaru kitiŋgaku mibuŋyoŋ, jibu fuŋine mo so bofukebuŋ. So bofukebuŋyoŋ, tatariineo ŋi yoyoka waperu ");
INSERT INTO mlh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","iŋi mibu, “Ŋi yoji iŋi miko manebere, ‘Noŋ soine Anuture boji soriŋ ketotiebe moreŋgo wakiko una yokaomore maŋgo oi moke romaeŋgaru babemiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Oŋu mibire soriŋ gio siŋaŋ qoruineji pakereru Yesu weu teru iŋi ojiya, “Yoŋoji gore sakigoo buŋo ruaru kitiŋgabi, ore tifeine mo mimiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Weu teko Yesuji ya sembene mo so eyayoŋ, jibu buŋo mo dimaya. Buŋo mo dimako soriŋ gio siŋaŋ qoruine iŋoji iŋi ojiya, “Nonji Anutu gogo Rauinere tinao iŋi weuku bapakare gugo: Go Anuture Made Kristo fukege me mata, oi poretiŋ miku mimipaŋ buŋoji misanaŋgande manekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Oŋu ojiko iŋi miya, “Mige, noŋ oi. Oiyoŋ, nonji sosowo ŋoŋo iŋi ŋajibe maneniŋ: Damaŋ yoo akoŋ fuŋgaru Sombuŋ eru morende Ŋi foriineji usuŋ Rauinere me furoineo ŋeku jiki qonikinde kuaŋ paio wakiko ŋonenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Buŋo oi miko soriŋ gio siŋaŋ qoruine iŋoji marikuine qosugaru iŋi miya, “Yei, mamagore sia! Iŋo Anutu igosisi etega. Goineji buŋoine kitiŋganimiŋ ore moke so weu yarekimiŋ. Anutu igosisi etega, oi muŋambemeŋ yoo ŋoŋo-ŋaŋe mane foregobi. ");
INSERT INTO mlh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ore eru ŋoŋo uruŋu manesugobi?” Oŋu weu yareme iŋi mitaribuŋ, “Iŋoji komere biŋe fukeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Oŋu mitariku jiŋoineo tifegaru qaku rau teru meyaŋuŋ bajiru maiineo qabuŋ. Goineji mauineo qotimberu ");
INSERT INTO mlh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","iŋi ojibuŋ, “Go kajeqouŋ ŋi Kristo fukege ore moji guga, iŋore tina minde manekimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Oŋu fukeko Pitaji sakibe sa maŋgo kae jiŋoo ŋeya. Ŋeko kiŋaŋqoqo ŋigo moji iŋoreo wareru iŋi miya, “Go oŋuakoŋ Galili ŋi Yesuke moko gomeŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Oŋu miyayoŋ, sosowo yoŋore jiŋo maio mugaru iŋi miya, “Buŋo mige, oi kikiraŋgago.” ");
INSERT INTO mlh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Oŋu miku sa mendiineo rakako kiŋaŋqoqo ŋigo moji oi ŋoneru ŋi bembeŋgo dimabuŋ, oi iŋi yajiya, “Ŋi yoji oŋuakoŋ Nazaret ŋi Yesuke goya.” ");
INSERT INTO mlh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Oŋu yajiko moke mugaru mimipaŋ buŋoji misanaŋgaru iŋi miya, “Nonji ŋi oi so manego.” ");
INSERT INTO mlh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Damaŋ kokiine mo tariko ŋi bembeŋgo dimabuŋ, yoŋoji Pitareo waperu iŋi ojibuŋ, “Fofori! Goji oŋuakoŋ yoŋoreone mo fukege! Galili buŋo maru mige, oiji oŋuakoŋ oi noduko manegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Oi maneru fuŋgaru iŋoyoŋekoŋ qaiso eru mimipaŋ buŋoji misanaŋgaru miya, “Noŋ ŋi oi so yobu manego! Buŋo ikoine minobo ine, Anutuji geoine bokirie nareiŋ.” Oŋu miko oo akoŋ qoqu qaya. ");
INSERT INTO mlh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Qoquji qako maneru Yesuji buŋo iŋi ojiya, oi manesuya, “Goji bonieru ateine yokaomo muga nunde qoquji qaiŋ.” Buŋo oi manesuku beuine pougaiŋgo eko sakibe rakaru ŋoŋoti baku kuyoya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kae fufurere akoŋ soriŋ gio siŋaŋ sosowo eru kantrire minebobo (70) yoŋoji tumaŋgaru Yesu qabi komeinde buŋo mimane ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mimane ebi tariko Yesu kiperu ogaru Rom gawana Pailotre meo ruabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesu qabi komeinde buŋo mitaribi Judas babae bateya, iŋoji oi maneru mane sembeaku silwa moneŋ koruŋ 30 otebuŋ, oi roru soriŋ gio siŋaŋ eru kantrire minebobo yoŋoreo raru bokirie yareru iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nonji agiburaŋ eku ŋi bakaine tomiri oi babae batebe qabi komeiŋ.” Oŋu yajiyayoŋ, yoŋoji iŋi ojibuŋ, “Oi niŋore ya mata! Oi gogakuŋ manebu!” ");
INSERT INTO mlh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Oŋu ojibi maneru silwa moneŋ koruŋ oi roru bokeme boji soriŋ maŋineo raya. Rako iŋoyoŋe bokeru raru niginji kiperu ubeine bobogaya. ");
INSERT INTO mlh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Soriŋ gio siŋaŋ qoruine yoŋoji moneŋ koruŋ oi roru iŋi mibuŋ, “Moneŋ yo ŋi dariinere furi. Ore eru oi boji sorinde moneŋ rouŋgo ruakimiŋ ore so mata. Oŋu eru Mosesre Kadi buŋo egu odurekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Oŋu miku mimane eku moneŋ oiji afeji dero bobo ŋi more moreŋ rondiŋine mo furiine babi kotu ŋiŋigo yoŋore jiŋoruŋ fukeya. ");
INSERT INTO mlh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ore eru moreŋ rondiŋine ore tinaine oi damaŋ yoo oŋuakoŋ jikigaru “Moreŋ rondiŋ dariineke,” miegobi. ");
INSERT INTO mlh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kajeqouŋ ŋi Jeremaiaji buŋo ronekoŋ miya, oiji foriineke fukeya. Buŋo oi iŋi, “Yoŋoji Israel kufufunde mineboboyaŋuŋ fukeru ŋi oi furiine banimiŋ ore osoeru ruabi silwa moneŋ 30 fukeya, oi robuŋ. Oi ŋire furi. ");
INSERT INTO mlh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Yoŋoji oi roru oiji afeji dero bobo ŋi more moreŋ rondiŋine mo furiine babuŋ. Oi Ofonji mitiga noreya ore so oŋu babuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Damaŋ oo Yesuji Pailotre jiŋo maio dimako iŋi weu teya, “Fofori, go Juda yoŋore kiŋ koito fukege me mata?” Weu teko Yesuji bokirieru ojiya, “Oi gogake mige, oŋu.” ");
INSERT INTO mlh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Soriŋ gio siŋaŋ eru kantrire minebobo (70) yoŋoji buŋo kokoine Yesure sakigo ruaru mibuŋyoŋ, jibu buŋo tifeine mo so bokirieya. ");
INSERT INTO mlh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Buŋoine bokeru dimako Pailotji Yesu moke weu teru ojiya, “Mane! Yoŋoji buŋo kokoine gore sakigo ruaru kitiŋgaku migobi, oi manege me mata?” ");
INSERT INTO mlh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Oŋu ojiyayoŋ, Yesuji sembene mo so eyayoŋ, jibu buŋo ore tifeine mo so bokirieya. Buŋoine bokeru dimako gawanaji kokoine waragaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Rom gawanaji gosa so Pasowa jeri damaŋgo witi pigone ŋi moakoŋ aŋiyaŋunde so tinaine oŋgaku weubuŋ, oi pirue yabeeya. ");
INSERT INTO mlh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Damaŋ oo ŋi mo tinaine Barabas mibuŋ, iŋoji witi pigo ŋeya. Oi sembeneinere mibaafa etebi goya. ");
INSERT INTO mlh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Oŋu eko tumaŋgabi iŋi weu yareya, “Barabas me Yesu, tinaine Kristo miegobi, yokoreone mo piruebe ŋoŋoreo wakiiŋgo manegobi?” ");
INSERT INTO mlh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Siŋaŋ yoŋoji Yesure maŋ aari manebuŋ ore eru oi gawanare meo ruabuŋ. Oi maneru aŋiyaŋunde oŋu weu yareya. ");
INSERT INTO mlh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Oi maneyayoŋ, mimitarire morumboŋ ŋeŋeineo ŋeko ŋonuŋineji biŋe buŋo mo iŋi ruame wareya, “Noŋ muŋambe ubune pororo mo ŋoneru oo ŋi ore eru joiserereŋ afaine mata manego. Ore eru ŋi posiine oi yobiŋ so eteigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Buŋo oŋu wareyayoŋ, soriŋ gio siŋaŋ eru kantrire minebobo yoŋoji ŋiŋigo kubu maŋ bapakare eyareru iŋi yajibuŋ, “Go Barabas pirueru Yesu maripoŋgo qanimiŋ ore mi. Oŋu weu teniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Oŋu mibi gawanaji bokirieru weu yareya, “Ŋi yoyoka yokoreone mo piruebe ŋoŋoreo wakiiŋgo manegobi?” Oŋu weu yareme “Barabas!” mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Oŋu mibi Pailotji iŋi weu yareya, “Oŋu migobi ore Yesu, tinaine Kristo miegobi, nonji oi uruŋu eru etenobo?” Oŋu weu yareme yoŋoji sosowo oŋgabuŋ, “Oi maripoŋgo qanimiŋ mi!” ");
INSERT INTO mlh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Oŋu oŋgabi gawanaji miya, “Oi wamore? Iŋoji wamo sembene eya?” Oŋu miyayoŋ, yoŋoji oi maneru yameŋ keku jikigaru oŋga jojoraku iŋi oŋgabuŋ, “Oi maripoŋgo qanimiŋ mi!” ");
INSERT INTO mlh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Oŋu oŋgabi kajegi qabi oyowoqojibuji moke sogueko Pailotji oi ŋonemane eru jigo oyowo egu fukeiŋ ore obu roru meine ŋiŋigo kubu jiŋoyaŋuŋgo jureru iŋi yajiya, “Ŋi yoore dari kesiebi rakaiŋ, oiji nonde paio matayoŋ, oi ŋoŋo-ŋaŋunde paio ropeine.” ");
INSERT INTO mlh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Oŋu miko ŋiŋigo kubu sosowo yoŋoji iŋi bokiriebuŋ, “Dariinere geo niŋo eru odu madepunoŋuŋ niŋore paio ropeine!” ");
INSERT INTO mlh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Oŋu bokiriebi Pailotji Barabas pirueko yoŋoreo wakiyayoŋ, Yesure miko ŋoŋoru joruinekeji qaya baya qabuŋ. Oŋu qabi maripoŋgo qanimiŋ ore Rom mamari ŋi yoŋore meo ruaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Meyaŋuŋgo ruako Rom gawanare mamari ŋi yoŋoji Yesu ogaru gawanare morumboŋ pire sa maŋgo ropebuŋ. Roperu mamari kubu sosowo kepore yabebi wareru tumaŋgaru Yesu roregabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Roregaru iŋoyoŋunde saki komoŋ kemukuru mariku boboroŋ yojuŋ iruine mo ke tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ke teku qiŋambu nigiŋ maŋgeŋgaru hendiŋ oŋuine qoruineo ketebi rakaya. Rakame sabara mo me furoineo ruaru dikanji keteru gogoukerekere eteru iŋi ojibuŋ, “Ohowe ohowe! Juda yoŋore kiŋ koito, ohowe!” ");
INSERT INTO mlh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kobeqoqo oŋuine eru tifegaru qaku rau teru sabaraine yaororu oiji qoruineo qabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Igosisi oŋuine eteru mariku boboroŋ yojuŋ iruine oi qomukuru iŋoyoŋunde saki komoŋ moke ke teku maripoŋgo qanimiŋ ore ogaru rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Raru kadi yasogoo ŋi mo tinaine Saimon bofukebuŋ. Iŋoji Afrika siti tinaine Sairini ore ŋi. Bofukeru yoiŋgabi Yesure maripoŋ roru koboya. ");
INSERT INTO mlh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yesu oŋu ogaru moreŋ mo tinaine Golgota oi noŋunde buŋoo Qorusia, oo raru ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Roperu wain obu eru marasiŋ tinaine mor oi qodureru bojiqojibu baku noiŋgo ore otebuŋyoŋ, Yesuji oi noku maneru takigaya. ");
INSERT INTO mlh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Takigako dimaku maripoŋgo qabuŋ. Qabi dimako Yesure saki komoŋinere qosa qabi jare fukeko ore so botuyaŋuŋgo boroiŋgaru robuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Oi roru ŋeku Yesu ru ba tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Qoruineo paibe qabunde fuŋne oi iŋi quraŋgaru qabi dimaya, ‘Juda yoŋore kiŋ koito yo.’ ");
INSERT INTO mlh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Suroŋqoqo ŋi yoyoka oi iŋoke maripoŋgo yapebuŋ. Mo me furoineo, mo kijoineo mobemobe oŋu yapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ŋiŋigo odureru ra wareru nifebubu eteku igosisi eru qotikeru iŋi mibuŋ, ");
INSERT INTO mlh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Yei! Go boji soriŋ soine ketotiende moreŋgo wakiko una yokaomore maŋgo moke romaeŋgaru baiŋgo mimeŋ. O, go ŋi tinabiŋeke! Go Anuture Made fukege ine, soine gake babapi eku maripoŋgone waki.” ");
INSERT INTO mlh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Soriŋ gio siŋaŋ, Kadi buŋore qaqaji eru kantrire minebobo yoŋoji oŋuakoŋ igosisi eteku iŋi mibuŋ, ");
INSERT INTO mlh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Goine bapi yaberu goyayoŋ, iŋoyoŋe babapi eiŋgo embimbiŋgaga. Iŋoji Israelre kiŋ koito fukega ine, muŋambemeŋ yoo maripoŋgone wakiko ŋoneru oi manesiŋ ganobeŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iŋoji Anutu manesiŋ gaku kobiineke goku iŋoyoŋere ‘Anuture made fukego,’ miko manebeŋ. Ayo, Anutuji oi damaŋ yoo bomuku teiŋgo manega me mata, oi soine ŋonekimiŋ.” Oŋu mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Suroŋqoqo ŋi iŋoke maripoŋgo yapebuŋ, yokoji oŋuakoŋ maŋqoqo buŋo fofoine mitebu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Una botuine 12 kilok fukeko oo akoŋ qisiriji wakiru moreŋ sosowo sagaru peko raru aua yokaomore so eya. ");
INSERT INTO mlh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yesuji 3 kilok oo iŋoyoŋere buŋoo iŋi buŋo soguine oŋgaya, “Eli, Eli, lama sabaktani?” Oi noŋunde buŋoo: Anutune, Anutune, wamore ŋadi nuge? ");
INSERT INTO mlh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Oŋu oŋgako ŋi bembeŋgo dimabuŋ, yoŋoreone goineji oi maneru mibuŋ, “Oi Elaijare oŋgaga.” ");
INSERT INTO mlh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Oo akoŋ yoŋoreone moji giniŋgaru raru yaŋgbuŋ mo yaga oŋuine oi roru wain obu jajainekeo igokurugaru yo didi tifeineo kiperu itigaru Yesure bibi sisiineo paibe ruame noya. ");
INSERT INTO mlh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Noyayoŋ, goineji mibuŋ, “Oi bokebi iŋoyoŋe akoŋ dima. Elaijaji wareru bomukuko wakiiŋ me mata, oi ŋonekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Oŋu ebi Yesuji moke buŋo soguine oŋgaku nakafe rombuŋ tatariine poreru komeya. ");
INSERT INTO mlh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Komeko oo akoŋ boji sorinde maŋgo kambaŋ dimaya, oiji paibeone botuineo sugaru wakiru yoyoka fukeya. Oŋu wakiko komeŋ yasogo bako ko soguine soguine bomukuya. ");
INSERT INTO mlh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jiŋorunde ko kounde kimboŋ yoŋoyaŋekoŋ aŋgabi ŋiŋigo gbagbataeŋine komebuŋ, yoŋoreone kokoineji gboreru pakerebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pakereru jiŋorunde ko kouŋyaŋuŋ bokeru Yesuji komegone pakereya, ore ŋadio Jerusalem siti tiriine oo wareru ŋiŋigo kokoine fuke yarebi ŋone yabebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mamari siŋaŋ eru mamari ŋi iŋoke Yesure ru bobo eku gobuŋ, yoŋoji komeŋ bako ya goine sosowo fukeya, oi ŋoneru popureru gburugburu afaine mata yabeko sombu eru iŋi mibuŋ, “Iŋoji fofori Anuture made fukega.” ");
INSERT INTO mlh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ŋigo kokoineji taitai dimaku ya oi oŋuakoŋ ŋonebuŋ. Yoŋoji Yesu boyoberu Galilione wareru kiŋaŋ qateku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Yoŋore botugo Maria Magdalane eru Maria Jeims eru Joses yokore maŋgo eru Zebedire madeyoka yokore maŋgo. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iŋande fukeko Arimatia ŋi biŋeroroineke mo tinaine Josef wareya. Iŋoji oŋuakoŋ Yesure kiŋariŋ mo fukeya. ");
INSERT INTO mlh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iŋoji Pailotreo raru Yesure qoŋgbuŋ roiŋgo ore weuya. Weuko mamari ŋiji oi Josef oteninde mitiga yareya. ");
INSERT INTO mlh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mitiga yareme Josefji raru Yesure qoŋgbuŋ roru wakiru kambaŋ yagaŋineji komoŋ gaya. ");
INSERT INTO mlh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Komoŋ garu roru jiŋoruŋgo raru iŋoyoŋere kouŋ gariine kogo gufubi dimaya, qoŋgbuŋine oi oo ruaya. Oŋu ruaru ko yasogo mo romaeŋgako ko kounde kimboŋ kejigako bokeru raya. ");
INSERT INTO mlh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalane eru Maria ogoine mo yokoji oo ko kouŋ maigaku ŋebu. ");
INSERT INTO mlh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sabat kombaŋ ŋeŋere ya bomogaru peru pakereru oo soriŋ gio siŋaŋ eru Farisi (Kadi buŋore yameŋyameŋ) yoŋoji Pailotreo raru tumaŋgaru iŋi mibuŋ, ");
INSERT INTO mlh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Sogunenoŋuŋ, bojiqojibu maŋbapakare ŋi iŋoji sakike goya, damaŋ oo iŋi miko manebeŋ, ‘Nonji una yokaomo tariko moke gboreru pakerebemiŋ.’ Niŋoji buŋo oi manesugobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","“Ore eru goji soine mamari ŋipugo yajinde jiŋoruŋgo raru oi poretiŋ ru bobo eku gobi una yokaomo tariko bokenimiŋ. Oŋu so siŋaŋ ganimiŋ ine, kiŋariŋpuineji raru qoŋgbuŋine kamiine roru sumuŋgaru ŋiŋigo iŋi yajinimiŋ, ‘Yesuji komegone pakereya.’ Oŋu mibi eadu bojiqojibu buŋo tatariine oiji bojiqojibu buŋo fuŋfuŋgaine odureko egu sembeqombeaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Oŋu mibi iŋi yajiya, “Mamari ŋi yo soine oga yaberu raru igodoŋ yabebi jiŋoruŋ ko kounde kimboŋ oi poretiŋ siŋaŋ ga yobugainebi.” ");
INSERT INTO mlh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Oŋu yajime jiŋoruŋgo raru ko kounde kimboŋgo ko yasogo ruabi kejigaru dimaya, oi sopuine bakatoru mamari ŋi igodoŋ yabebi ru bobo sanaŋine ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat kombaŋ ŋebi tariko Sonda kae fufurere akoŋ pakereru kae fureme Maria Magdalane eru ogoine Maria mo yokoji jiŋorunde ko kouŋ ŋoneiŋgo rabu. ");
INSERT INTO mlh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Rabire oo akoŋ komeŋ yasogo iŋi ore baya: Ofonde mimerereŋ moji Sombuŋgone wakiru jiŋoruŋgo wareru kimboŋgo ko yasogo igogako rako paiineo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mimererende kamasi oi bobori oŋuine fukeko marikuine oi kuaŋ oŋuine gbagbataeŋine fukeya. ");
INSERT INTO mlh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Oŋu fukeko mamari ŋi jiŋoruŋ ru bobo ebuŋ, yoŋoji iŋore waragaku gburugburu yabeko komeiŋ ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Oŋu ebi mimererenji ŋigo yoyoka oi buŋo iŋi yasiya, “Yesu maripoŋgo qabuŋ, ŋoko iŋore baagobire, oi manego. Ore eru kokoi so maneni. ");
INSERT INTO mlh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iŋoyoŋe miya ore so komegone pakerega. Ore eru yoo so pega. Ŋoko wareru ŋeŋe peya, oi ŋoneni. ");
INSERT INTO mlh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“Oi ŋoneru pipa kiŋariŋpuine yoŋoreo raru biŋe buŋo yo yajini, Yesuji komegone pakerega. Maneniŋ, iŋoji bonieru Galili prowinsgo raiŋ. Ŋoŋo soine oo raru oi ŋoneniŋ. Maneniŋ, nonji oi ŋajibe manebuŋ.” ");
INSERT INTO mlh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Oŋu yasiko pipa akoŋ jiŋoruŋ bokeru kokoi maneru jibu mokemoke yobu jerieru biŋe oi roru kiŋariŋpuine yajinimi ore pipa rabu. ");
INSERT INTO mlh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pipa rabire Yesuji oi kadio fuke yateru “Kaereŋakuŋ!” yasiya. Oŋu yasiko bembeŋgo raru daberu kufuineo bayaeŋ gaku ohowe baku miteŋ gatebu. ");
INSERT INTO mlh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Miteŋ gatebire iŋi yasiya, “Kokoi so maneni. Bio raru gbopuneji Galili raniminde buŋo yajibire oo raru noŋ ŋone nuinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ŋigoyoko yokoji kadi rabire jiŋorunde ko kounde siŋaŋ bobo mamari ŋi goineji sitio wareru soriŋ gio siŋaŋ ŋone yaberu ya sosowo fukeya, ore sunduine yajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yoŋoji oi maneru Juda yoŋore minebobopuyaŋuŋ kepore yabebi moko tutumaŋ eru Yesu papakarere buŋo sumuŋganiminde buŋo buru bofukeru moneŋ soguine yobu oi mamari ŋi yarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Oi yareru iŋi mitiga yarebuŋ, “Ŋoŋo buŋo iŋi miinebi: Niŋo ubune kubaŋ pekabeneŋ kiŋariŋpuineji kamiine wareru qoŋgbuŋine kiaŋ roru rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Buŋo oŋu mibi buŋo oiji gawanare kajego rakako maneiŋ ine, yobiŋ ŋoŋore paio egu ropeiŋ ore niŋoji maŋine bowirieru bawaki ruabeneŋ manebu tomiri goinebi.” ");
INSERT INTO mlh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Oŋu mitiga yarebi ore so boyoberu moneŋ roru raru gio buŋoyaŋuŋ boyobebuŋ. Oŋu ebi Juda yoŋoji buŋo oi botuyaŋuŋgo misauebi maneru gobi raru damaŋ yoo oŋuakoŋ oi jikigaru mibi maneegobeneŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kiŋariŋpuine 11 yoŋoji Jerusalem bokeru Galili prowinsgo raru Yesuji tukuo warenimiŋ ore yajiya, oo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Oo roperu Yesu ŋoneru ohowe baku miteŋ gatebuŋyoŋ, goineji iŋore maŋyoka manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Miteŋ gatebi yoŋoreo wareru iŋi yajiya, “Sombunde eru morende usuŋ sosowo oi Anutuji nareme nonde pega. ");
INSERT INTO mlh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","“Ore eru ŋoŋo moreŋ so raru ŋiŋigo kubu sosowo iŋi ro yabebi nonde kiŋariŋpune fukenimiŋ: Oi Mama, Made eru Moro Tiriine niŋore tinao miti meso rau yareinebi ");
INSERT INTO mlh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","eru nonji buŋo boyobenimiŋgo mitiga ŋarebe, oi sosowo reŋganimiŋ ore qaji yareru goinebi. Maneniŋ, nonji damaŋine damaŋine ŋoŋoke go ropeku gobe morende damanji tariiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Munaŋqoqo Rauine Yesu Kristo iŋo Anuture Made fukega. Nonji iŋore Bobiaŋ Biŋe fuŋgaru quraŋgago. ");
INSERT INTO mlh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anutuji Sombuŋ maŋgo madeine buŋo mo ojime kajeqouŋ ŋi Aisaiaji oi quraŋgaya iŋore Biŋe Quraŋgo iŋi pega, “Mane. Nonji kiŋaŋ mimerereŋne mo sorebe ronekoŋ raku ŋiŋigo maŋyaŋuŋ botiŋgaru gore kadi bataniŋgame goji iŋore ŋadio moreŋgo rakaigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Biŋe mimerereŋ moji moreŋ buroineo oŋgaku gokame raku buŋoine iŋi maneinebi, ‘Ofonji wareiŋ-oo! Ore eru ŋoŋo jaueru kadiine bataniŋgainebi. Ŋoŋo maŋyaŋuŋ botiŋgaru kadiine kemaseinebi.’” ");
INSERT INTO mlh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Buŋo ore so ŋi mo tinaine Jon fukeya, tinaine mo Mitimeso ŋi. Fukeru moreŋ buroineo goku dimaku Biŋe buŋo iŋi miku goya, “Ŋoŋoji bio maŋyaŋuŋ kerisiebi nonji miti meso rau ŋarebemiŋ. Oŋu ebi Anutuji agiburaŋ-ŋaŋuŋ jureru bokeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Oŋu miku gokame Judia prowinsre kae sosowo eme Jerusalem siti yoŋoji qoko qoko keku poreru Jondeo warebuŋ. Wareru waperu agiburaŋyaŋuŋ mifukebi Jonji oi Jordan obu rendaineo miti meso rau yareya. ");
INSERT INTO mlh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jonde sakikomoŋ oi kamel sikiineji bakine eru ombuineo bifuŋ joma sakiineji bakine oi kiperu goya. Uqo munjaŋine oi putogisi burugisi eru gomende kou obuine, oi noku goya. Oi sosowo kajeqouŋ ŋi Elaija iŋore so. ");
INSERT INTO mlh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jonji buŋo iŋi mitaniŋgaru goya, “Nonde ŋadio ŋi usuŋine sanaŋine mo wareiŋ. Iŋore usuŋ ropekiineji nonde odureiŋ. Iŋoji ŋi ropekiine fukeiŋ ore nonji iŋore kufu komonde nigiŋ bapigaru pirueiŋ ore mimigaŋgaŋ eru embimbiŋgabemiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nonji obu omaineji rau ŋaregoyoŋ, iŋoji Moro Tiriineji rau ŋareiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Damaŋ oo Yesuji Galili prowinsre kae tinaine Nazaret oone Jondeo wareme Jordan obu rendaineo miti meso rauteya. ");
INSERT INTO mlh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Rau teko obuone wapeko oo akoŋ Sombunji aŋgame Yesuji pakeru ŋoneme Moro Tiriineji kerisieru kabu webo oŋu fukeru Yesure qoruineo waki roya. ");
INSERT INTO mlh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Oi ŋoneme Sombuŋ kaeone buŋo mo iŋi fukeya: “Goji nakene wombuŋ made fukende beune fiame ŋoneguru aŋi manego.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Miti meso rau teme oo akoŋ Moro Tiriineji Yesu eteru soreme moreŋ buroineo raya. ");
INSERT INTO mlh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Raru una 40 oŋu oo gome gemokaku qoruyaŋuŋ Satan iŋoji esoigaku goya. Joma rigaŋine yoŋore botugo gokame Sombuŋ mimerereŋ yoŋoji bapi garu gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jiki Jon witi pigo ruabi ŋeya. Yesuji damaŋ oo Galili prowinsgo kirieru raya. Raru Anuture Bobiaŋ Biŋe mitaniŋgaru goya. ");
INSERT INTO mlh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","mitaniŋgaru iŋi yajiya, “Anutuji qorumaŋine ruainde damanji bio bembeŋgaga. Anutuji damaŋ ruame go wapebuŋ, oi muŋambe yo fukega. Ore eru maŋyaŋuŋ kerisieru Bobiaŋ Biŋe manesiŋ gainebi.” ");
INSERT INTO mlh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesuji oŋu yajiru roregaru goku Galili obu jogunde qaŋaŋgo boyoberu raku jembaeŋ fufuru ŋi yoyoka ŋone yapeya. Tinayakuŋ Saimon, gboine tinaine Andru. Yokoji simemeŋyakuŋ obu joguŋgo jembaeŋ porenimi ore bokeru gobu. ");
INSERT INTO mlh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesuji ŋone yaperu iŋi yasiya, “Ŋiyoka, ŋoko noŋ boyobe nuru warebire qaji ŋatebe ŋiŋigo jembaeŋ oŋu pore yabenimi.” ");
INSERT INTO mlh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oŋu yasiya oo akoŋ simemeŋyakuŋ bokeru fuŋgaru Yesu boyoberu rabu. ");
INSERT INTO mlh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesuji yokoke kokiine mo jikigaru raku Zebedi madeine Jeims eru gboine Jon ŋone yapeya. Yokoji oŋuakoŋ ogâo ŋeku simemeŋyakuŋ bobiaŋgaru kiperu ŋebu. ");
INSERT INTO mlh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ŋebire ŋone yaperu oone oŋga yateya. Oŋga yateme mamayakuŋ Zebedi eru moneŋ gio ŋipuine ogâo boke yaberu fuŋgaru Yesu boyoberu ŋadiineo rabu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Oŋu moko raku Kaperneam taoŋgo ropebi Sabat kombaŋ fukeme Yesuji oo akoŋ oŋgawowosi piyaŋuŋgo roperu Biŋe buŋo qaji yareya. ");
INSERT INTO mlh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kadi buŋore qaqaji oŋuine matayoŋ, usuŋ pe teya ore so qaji yareru eeboboinere so enimiŋ ore miya. Ore kufufuŋ yoŋoji oi ŋoneru popureru waragabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Oŋgawowosi piyaŋuŋ oo damaŋ oo akoŋ ŋi mo gemoineke ŋeko gemo oo tinaine iŋi oŋgaya, ");
INSERT INTO mlh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“O Yesu, Nazaret ŋi! Go uruŋu eru enoreiŋgo ege? Bosembe nobeiŋgo ore warege me? Noŋ fuŋnego mane mukugo. Go Anuture ŋi Roosiŋine fukege.” ");
INSERT INTO mlh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Oŋu oŋgame Yesuji kanegaru iŋi ojiya, “Go bio buŋogo bokeru ŋi yo bokeru use.” ");
INSERT INTO mlh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Oŋu ojime gemoji ŋi oi yoyowogaru furu yoyou eteru buŋo sembeqambeine oŋgaru waperu bokeru raya. ");
INSERT INTO mlh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Rako sosowoji meayaŋuŋ mukume waragaru weweu eku iŋi mibuŋ, “Yei, mamagore sia! Yo oi wamo ya? Yo mamane gariine usuŋineke. Iŋoji gemokaku oŋuakoŋ mitiga yareme miine reŋgagobi.” ");
INSERT INTO mlh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Oŋu fukeme Yesure tinabiŋeji pipa saueru kae bembeŋgo ŋe rabuŋ, oo raku raku Galili prowins sosowo sagaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesuji Kaperneam yoŋore oŋgawowosi pi bokeru oo akoŋ Jeims Jon yokoke Saimon eru Andru yokore pigo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Oo ropebi Saimon safaŋineji sakijo jibe bame peya. Peko biŋeine oi pipa Yesu ojibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ojibi iŋoreo raru meineo roku bopeŋgame pakereya. Pakereme sakijoine bokeme uqo rigaru yareya. ");
INSERT INTO mlh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yareme kae ubu eme wegi jiriŋine rakame oo Kaperneam rauine yoŋoji dimaku ŋiŋigoine ŋiŋigoine jibe gemoyaŋuŋke oi sosowo oga yaberu Yesureo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kaperneam taoŋgone kubu sogoji wareru Saimonde pi mendiineo tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tumaŋgabi dimaku ŋiŋigo jibe fuŋne fuŋne fuke yareya, oi kokoine bobiaŋ yabeya. Oŋuakoŋ gemokaku yoŋoji Yesure fuŋne manebuŋ ore Yesuji mi bibiyaŋuŋ qojigaru kokoine yobe yabeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesuji kubaŋ peko ubu wegi jiriŋ sineme pakereru kae qaŋaŋineo raru iŋoyoŋe yobu yaŋekoŋ oo oŋga wosiya. ");
INSERT INTO mlh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Oŋga wosigako Saimon eru ogopuine iŋoke gobuŋ, yoŋoji pipa ŋadiineo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Raku bofukeru iŋi ojibuŋ, “Ŋiŋigo sosowoji bio go baagugobi.” ");
INSERT INTO mlh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Oŋu ojibi iŋi yajiya, “Kae goine roregaru ŋe ragobi, oi ŋonegobi. Nonji Biŋe buŋo kae so misauebemiŋ ore waki gogo. Ore kae roregaru rakimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Oŋu yajiru Galili prowins sosowo roregaru raru oŋgawowosi piyaŋuŋgo Biŋe buŋo miku gemoine gemoine oi yobe yabeku goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yesuji taoŋ mogo gome wako ŋi moji wareru dikanji keru Yesure maŋfuŋgo rakaru iŋi oŋga wosi teya, “Goji aŋigoji bobiaŋ nuiŋ ore manege ine, noŋ soine bofosike nuigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Oŋu oŋga wosi teme iŋore beusembe maneru meine sineru sakiine bouaku ojiya, “Nonji oi somieiŋ ore manego. Go bio posike.” ");
INSERT INTO mlh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Oŋu mime wakoine oi oo akoŋ posikeya. ");
INSERT INTO mlh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Posikeme siŋaŋ bobo buŋo sanaŋine ojiku oo akoŋ “Soine raigoŋ,” ojiya. ");
INSERT INTO mlh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kajeqouŋ buŋo oi iŋi ojiya, “Mane. Ore biŋe buŋoine oi mo so minde maneniŋ. Matayoŋ, soriŋ gio siŋandeo raru sakigo oduigoŋ eru Mosesre mimiti boyoberu posikege ore sogo eru boji rigamiŋ. Oi rigande ŋoneme ŋiŋigoji fuŋnego mane mukunimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yesuji oŋu ojikoyoŋ, iŋoji raku jibu fuŋgaru biŋe buŋo oi kokoine miku goko saueya. Saueme Yesuji taoŋine taoŋine oo totogo moke raiŋgore embimbiŋgaya. Embimbiŋgaru taoŋ ŋadiyaŋuŋgo moreŋ taine oo akoŋ goya. Oo goko kae so oone ŋiŋigoine ŋiŋigoine iŋoreo warebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Oŋu roregaru damaŋ goine tarime Yesuji kirieru moke kaeineo Kaperneam wareya. Warekame “Pigo goga,” mibi manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ŋiŋigo kokoineji oi maneru tumaŋgaru iŋore pi mendi korogo kekefoŋ eru kae jiŋoineo pusekabuŋ. Pusebi Yesuji dimaku Biŋe buŋo yajiya. ");
INSERT INTO mlh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yajime oo ŋi mo saki mobeine komekiine, oi ogagaru iŋoreo warebuŋ. Ŋi 4:ji oi reŋgo ruaru koboru warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Warebi puseru dimabuŋ ore eru Yesure bembeŋgo raru ruaiŋgo ore embimbiŋgabuŋ. Embimbiŋgaru pi paiineo roperu Yesure qorugo bubu sikeku borombiebuŋ. Borombiebi kimboŋ fukeme oo jibe ŋi oi reŋineke niginji kiperu ruabi rakaya. ");
INSERT INTO mlh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Oŋu rakame Anutu manesiŋ gabuŋ, Yesuji yoŋore kamasiyaŋuŋ oi ŋoneme sagako jibe ŋi oi iŋi ojiya, “Madene, nonji gore agiburaŋgo bokego.” ");
INSERT INTO mlh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Oŋu ojime Kadi buŋore qaqaji goineji botuyaŋuŋgo ŋeku maŋyaŋunji iŋi manesubuŋ, ");
INSERT INTO mlh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ŋi yoji uruŋu eru oŋu miga. Anutu igosisi etega. Anutu moakonji agiburaŋnoŋuŋ bokeegayoŋ, ŋi moji oi mata.” ");
INSERT INTO mlh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Maŋyaŋunji oŋu manesubi Yesuji oo akoŋ maŋineo oi mane mukuru iŋi yajiya, “Ŋoŋo wamore buŋo oŋu maŋ-ŋaŋuŋgo manesugobi? ");
INSERT INTO mlh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nonji ‘Agiburaŋgo bokego,’ jibe ŋi oŋu ojigo, buŋo oi afaine akoŋ mimiine. Moji oŋu miko goineji buŋo ore foriine so ŋonenimiŋ. Ore oi buŋo afainere oŋu. Nonji buŋo mo iŋi miiŋgo ore manego, ‘Go pakereru ramegaripepego roru raigoŋ.’ Buŋo oi yobiŋineke mimiine fukega. Oŋu mikabe foriine fukeiŋ me mata, oi totogo fukeme ŋonenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Maneniŋ, moreŋgo agiburaŋ bobokere usuŋine oi Sombuŋ eru morende Ŋi foriinere pega, ŋoŋo ore fuŋinere tiŋtuŋ egu gonimiŋ. Ore buŋo yobiŋineke oi ŋi yo ojibe foriine ŋonenimiŋ.” Oŋu miku ŋi saki mobeine komekiinere jiŋoo ŋoneru ojiya, “Nonji gajigo: Go bio pakereru ramegaripepego roru pigoo ra. Buŋo yobiŋine oi foriineke fukeiŋ ine, buŋo afaine oi oŋuakoŋ uruŋu eru omaine fukena?” ");
INSERT INTO mlh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Oŋu miku ŋi saki mobeine komekiine iŋi ojiya, “Nonji gajigo: Go bio pakereru ramegaripepego roru pigoo raigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ojiko pakereru oo akoŋ ramegaripepeine roru ŋiŋigo sosowo yoŋore jiŋoyaŋuŋgo sakibe raya. Oŋu rako sosowoji waragaru Anutu miteŋ garu iŋi mibuŋ, “Yei, mamagore siaine! Kamasi yo oŋu oi ronekoŋ damaŋ mogo so ŋonebeŋ. Mata! Muŋambe yo jiŋo furu ŋonegobeneŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesuji moke Kaperneam bokeru joguŋgo rakaru mageŋ keririŋineo raru goya. Goko ŋiŋigo kubu sogoji iŋoreo warebuŋ Biŋe buŋo qaji yareya. ");
INSERT INTO mlh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Raru takis ofis odureiŋgo eko oo ŋi tinaine Liwai Alfius madeine ŋeko ŋoneru ojiya, “Go bio nonde ŋadio boyobe nuru ware.” Oŋu mime pakereru takis gio bokeru Yesure ŋadio raya. ");
INSERT INTO mlh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Raru Liwaire pigo raru uqo noku ŋebuŋ, damaŋ oo takis roro ŋi eaduyaŋuŋke eru agiburaŋ ŋi kokoine yoŋoji wareru Yesu eru iŋore kiŋariŋpuine yoŋoke ŋeku uqo moko nobuŋ. Kokoineji Yesu boyoberu gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yesuji takis roro eaduyaŋuŋke eru agiburaŋ ŋiŋigo goine yoŋoke ŋeku uqo nobuŋ, oi Farisi (Kadi buŋore yameŋyameŋ) eru yoŋore qaqaji goineji ŋoneru Yesure kiŋariŋpuine iŋi miku yajibuŋ, “Ae! Iŋoji wamore takis roro eaduyaŋuŋke eru agiburaŋ ŋiŋigo yoŋoke ŋeku uqo naga? Oi so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Oŋu miku yajibi Yesuji mobeine iŋi yajiya, “Ŋiŋigo jibeyaŋuŋ tomiri yoŋoji doktare aŋi so maneegobiyoŋ, jibe ŋiŋigoji doktareo raegobi. Nonji agiburaŋ ŋiŋigo oŋga yareiŋgo ore wareru gogoyoŋ, ŋiŋigo yoŋoyaŋunde manebi posiine fukegobi, oi mata.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Damaŋ oo Jonde kiŋariŋpuine eru Farisi (Kadi buŋore yameŋyameŋ) yoŋoji uqo sowo gobi goineji Yesureo wareru iŋi weu tebuŋ, “Jon Mitimeso ŋire kiŋariŋpuine niŋoji Anuture uqo sowo goegobeneŋ. Farisi (Kadi buŋore yameŋyameŋ) yoŋore kiŋariŋpuyaŋunji oŋuakoŋ eru gogobi. Gakere kiŋariŋpuji wamore Anuture uqo sowo so gogobi?” ");
INSERT INTO mlh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Oŋu weu tebi iŋi bokirieya, “Fofori! Niŋo wamo damaŋgo uqo sowo goegobeneŋ? Ŋigo roro damaŋineo ŋire ujepuji boreŋine ruabi ŋigore daritifepuji ya oi useegobi me mata? Nonji nakene kiŋariŋpu yoŋore ŋi biŋe fukeru yoŋore botugo aŋibaŋi ŋeego. Ŋebe yoŋoji ore jerieru aŋibaŋi ŋeku sowo goiŋgo embimbiŋgaegobi. ");
INSERT INTO mlh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Embimbiŋgaegobiyoŋ, Anutuji gogone ogagako komebe yoŋoji damaŋ oo soine uqo sowo goenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“(Ŋoŋo gogo raŋgbaŋine eru jeri Biŋe gariine oi qodure yapeiŋgo embimbiŋganimiŋ. Ore buŋo ŋadiine oi iŋi ŋajibemiŋ.) Qorufa raŋgbaŋine pougame moji kambaŋ gariine so jujureine ketigaru oo kambaŋ mobeine so gboduru gbodueega. Oŋu ruana ine, kambaŋ mobeine gariineji mujugaru kebikoko raŋgbaŋine oi furugame moke kerigame kimboŋ sogueru egu sembeqombeaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Oŋuakoŋ moji wain obu gariine oi jua me toru raŋgbaŋine lama sakiineji babaine oo so pioru keseme rakaega. Oŋu ena ine, wain obu gariineji sogueru toru qopogame pougaru keseme moreŋgo waki jibugame toruineji egu sembeqombeaiŋ. Ore wain obu gariine oi toru gariineo koŋgabeneŋ rakame sagaiŋ. (Oŋuakoŋ obu fiine oi kiniŋ eseineo so pioegobeneŋ. Oŋu pionobeŋ ine, oo pougaru siisororo wakime nobeneŋ jibe egu ba nobeiŋ. Oŋu fukeiŋ ore obu fiine oi kiniŋ fiineo pioegobeneŋ. Ŋoŋo oŋuakoŋ gogo raŋgbaŋine eru Bobiaŋ Biŋe gariine oi qodure yapeiŋ ore embimbiŋganimiŋ.) Oŋu.” ");
INSERT INTO mlh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ore ŋadiineo Sabat kombaŋ mogo Yesuji wit gio rondiŋ soguine petigaru raya. Rako kiŋariŋpuineji beuyaŋuŋ yoŋuŋgame wit foriine moakoŋ moakoŋ fuŋgaru meyaŋunji bomukuru nobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Oŋu nobuŋ ore Farisi (Kadi buŋore yameŋyameŋ) goineji Yesu iŋi ojibuŋ, “Mane, yoŋoji wamore Sabat kombande gio bobo agiine oduregobi?” ");
INSERT INTO mlh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Oŋu ojibi iŋi bokirieya, “Kiŋ Deiwidji mamari ŋipuine yoŋoke roregaru beuyaŋuŋ yoŋuŋgame uqore embimbiŋgaru ya ebuŋ, oi damaŋ mogo osebuŋ me mata? ");
INSERT INTO mlh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iŋoji Anuture kambaŋ seri soriŋgo roperu poroŋ mokiine Anuture jiŋo maio koro alatao ruabi ŋeko usuŋineji kefagame qomukubuŋ, oi roru noya. Poroŋ mokiine bobokeine oi soriŋ gio siŋaŋ yoŋoji akoŋ noku gobuŋ. Goineji oi egu nonimiŋ ore agi peko jibu naya. Noku ŋipuine oŋuakoŋ yareme moko nobuŋ. Damaŋ oo ŋi tinaine Abiatar iŋoji soriŋ gio siŋaŋ qoruinere gio baku goya.” ");
INSERT INTO mlh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Oŋu kerisieru iŋi yajiya, “Anutuji Sabat kombaŋ oi ŋiŋigo fianimiŋ ore ruame pega. Oi ŋiŋigoji kosa mitiganimiŋ ore eru mata! ");
INSERT INTO mlh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Oŋu eko Qorumaŋ eru morende Ŋi foriineji Sabat kombande Ofoŋ oŋuakoŋ fukega.” ");
INSERT INTO mlh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesuji moke oŋgawowosi pigo ropeme oo ŋi meine gbaŋikine mo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ŋiŋigoji Yesu buŋo koroineo ruaiŋgo ore “Ŋi oi Sabat kombaŋgo bobiaŋgaiŋ me mata?” oŋu miku Yesure jiŋo ru baku ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Bakabi Yesuji ŋi meine gbagbaŋine oi iŋi ojiya, “Go pakereru jiŋo mainoŋuŋgo dima.” ");
INSERT INTO mlh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Oŋu ojiru iŋi yajiya, “Kadi buŋo boyoberu Sabat kombaŋgo ya fiine me sembene banobeŋ? Soine more qoru kipekimiŋ me bokebeneŋ komeiŋ? Mo me mo babeneŋ sagaiŋ?” Oŋu miko maneru buŋoyaŋuŋ bokeru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Buŋoyaŋuŋ bokeme ŋebuŋ kirieru ŋone yabekame maŋyaŋunji sanaŋine kebojigaya ore beusembe maneru manjogo ŋone yabeya. Oŋu ŋone yaberu ŋi oi iŋi ojiya, “Go bio mego poretiŋga.” Oŋu ojime meine poretiŋgame moke fiine fukeya. ");
INSERT INTO mlh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fiine fukeme Farisi (Kadi buŋore yameŋyameŋ) yoŋoji sakibe raru oo akoŋ gawana Herod iŋore pati ogopuine yoŋoke tutumaŋ eku “Yesu uruŋu qabeneŋ komena?” miku buŋo gio babuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Oŋu babi Yesuji kiŋariŋpuine oga yabeme obu joguŋ qaŋaŋineo rabuŋ. Rakabuŋ Not prowins tinaine Galili oone ŋiŋigo kubu sogo yoŋoji ŋadiineo boyoberu rabuŋ. Judia prowins oone oŋuakoŋ iŋoreo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Siti qoruine tinaine Jerusalem, Saut prowins tinaine Aidumia eru Jordan obu mobene wegi wawapeineo yoŋoji eru wegi rarakaineo oobe taoŋ tinayakuŋ Taia eru Saidon roregaru gobuŋ, yoŋoji oŋuakoŋ kubu soguineji poreru warebuŋ. Yesuji mosi qoqowirie yasogo yasogo baku goya, ore biŋeine maneru qodureru wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Oŋu waperu egu kekefoŋ ebi ore Yesuji kiŋariŋpuine iŋi yajiya, “Quŋgabemiŋ ore ŋoŋo bio ogâ mo bofukeru nonde maŋfuŋgo ruabi ŋenoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Oŋu yajiru ŋiŋigo boakoŋ bobiaŋ yaberu goya. Ore qapeqawaki eru saki yoyobiŋyaŋuŋke sosowo yoŋoji sakiineo bouaiŋ ore roregaru kokoine keketuŋ ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Gemoine gemoine yoŋoji Yesu ŋoneru jiŋo maiineo moreŋgo rakaru iŋi oŋgabuŋ, “Go Anuture Made fukege!” ");
INSERT INTO mlh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Oŋu oŋgabi Yesuji qomuku yareru fuŋineji totogo egu fukeiŋ ore agi sanaŋine rua yareya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jiki Yesuji tukuo roperu oo iŋoyoŋunde aŋi boyoberu ŋi oŋga yareme iŋoreo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Warebi ŋi 12 iŋoke gonimiŋ ore bofuke yaberu Biŋe buŋoine misauenimiŋ ore sore yabeya. ");
INSERT INTO mlh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Sore yaberu gemokaku yobe yabenimiŋ ore usuŋine yareya. ");
INSERT INTO mlh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Oŋu eru ŋi 12 oi iŋi qaji yareya: Pita, Yesuji tina oi Saimon oteya. ");
INSERT INTO mlh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jeims eru gboine Jon, mamayakuŋ tinaine Zebedi. Yesuji yokore tina mo Boanerges miya. Oi noŋunde buŋoo Gbuŋparandande Madeyoka. ");
INSERT INTO mlh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, Bartolomyu, Matyu, Tomas, Jeims Alfius madeine, Tadius, Saimon Zelot-politik ŋi, ");
INSERT INTO mlh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","eru Judas Iskariot. Kariot ŋi oi jiki Yesu babae baya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesuji oŋu eyareme tukuone waki iŋore pigo wareya. Pigo wareme ŋiŋigo kubu yasogoji moke waperu tumaŋgabuŋ uqo munjaŋ noiŋgo ore embimbiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Embimbiŋgabi daritifepuineji oi maneru “Maŋine jibuga forega!” mibuŋ. Miku rakaru roiŋgone rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Rakabi Kadi buŋore qaqaji Jerusalemgone warebuŋ, yoŋoji mibuŋ, “Satande Gibioji maŋineo rakame goga. Iŋoji gemokaku yoŋore qoru iŋore usunji gemo yobe yabeega.” ");
INSERT INTO mlh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Oŋu mibuŋ ore Yesuji oŋga yareme warekabuŋ soso buŋoji iŋi yajiya, “Satanji uruŋu ogoine Satan mo yobena? ");
INSERT INTO mlh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kantri more siŋaŋpuŋaŋunji botuyaŋuŋgo kekepari eru roiŋganimiŋ ine, yoŋoji siŋaŋyayabe gioyaŋuŋ baku kitiŋgakimiŋ ore embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Oŋuakoŋ pi more kufufuŋ yoŋoji botuyaŋuŋgo kekepari eru roiŋganimiŋ ine, siŋaŋyayabe gioyaŋuŋ baku dimaiŋgo ore embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Oŋuakoŋ Satande kufufuŋ yoŋoji botuyaŋuŋgo kekepari eru kiso eru qoqo enimiŋ ine, siŋaŋyayabeyaŋunde usunji wakime gemo qorumaŋyaŋunji mataeiŋ ega. ");
INSERT INTO mlh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Moji ŋi sanaŋine Gibiore kufu me fuŋgaru so kipeiŋ ore ine, iŋoji piineo roperu meboine basiru roiŋgo embimbiŋgaiŋ. Rone oi kipeme ŋeko soine piineone yareyaine sosowo keririke foreru roru raiŋ. (Ore oŋu nonji oŋuakoŋ Satan kiperu ŋadiineo gemoine yobe yabeebemiŋ.”) Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nonji buŋo foriine mo iŋi ŋajibemiŋ, “Ŋiŋigo soguine mendaine agiburaŋ baegobi, oi Anutuji boke yareega. Yobiŋineke me afaine igosisi enobuŋ ine, Anutuji oi soine jure yareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jure yareiŋyoŋ, moji Moro Tiriine igosisi eteiŋ, ore agiburaŋine Anutuji damaŋ mogo so bokeiŋ. Mata yobu! Agiburaŋ oiji paiineo ropeme damaŋ tatariine tomiri Anuture jiŋo maio buŋoineke goiŋ.” Oŋu yajiya. ");
INSERT INTO mlh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Gemoji maŋineo rakame goga,” oŋu mibuŋ ore eru oŋu qaji yareya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Oŋu mimane ebuŋ maŋgo gbopuine yoŋoji wareru sakibe dimaku yoŋoreo wakiiŋ ore buŋo ruabi iŋoreo raya. ");
INSERT INTO mlh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Rako ŋiŋigo kubu yoŋoji roregaru ŋeku iŋi ojibuŋ, “Mane! Gore maŋgo gbopugoji sakibe dimaku gore weugobi.” ");
INSERT INTO mlh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ojibi kerisieru iŋi yajiya, “Nonde maŋgo oi moji eru nonde gbopune oi uri yoŋoji?” ");
INSERT INTO mlh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yesuji oŋu yajiru ŋiŋigo roregaru ŋebuŋ, oi piru ŋone yaberu iŋi miya, “Ŋoneniŋ! Nonde maŋgo eru gbopune oi yo. ");
INSERT INTO mlh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Anuture maŋ aŋi reŋgaegobi, yoŋoji nonde maŋgo eru seŋ gbopune fukegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuji moke obu joguŋ qaŋaŋineo rakaru fuŋgaru qaji yareya. Qaji yareme ŋiŋigo kubu sogoji iŋoreo raru tumaŋgabi ogâo roperu obu joguŋ paiineo raru ŋeya. Ŋeko ŋiŋigo sosowo yoŋoji joguŋ qaŋaŋineo mageŋgo tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Oŋu tumaŋgabi soso buŋo kokoine miku qaji yareya. Qaji yareku iŋi miya: ");
INSERT INTO mlh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Maneniŋ! Ŋi moji uqo koruŋ qopogaru tieiŋgo ore gioo raya. ");
INSERT INTO mlh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Raku qopogaru tieme koruŋ goineji kadi qaŋaŋineo rakaru ŋebuŋ. Rakaru ŋebuŋ (uufuŋ) webo yoŋo waperu oi no forebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Koruŋ goineji ko oŋgiŋgo rakaru ŋebuŋ. Rakaru keku oo moreŋ kokoine so bofukebuŋ. Moreŋ dikisiaine tomiri peya ore bobuŋyaŋunji pipa wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wapebiyoŋ, wegiji waperu joti yabeme goduyaŋuŋ tomiri ore gbaŋiru ŋeririkebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Koruŋ goineji komeqore joruineke oo rakaru ŋebuŋ. Rakaru ŋebi komeqoreji waperu kefa yabeme boŋeŋgaru baŋi forebuŋ. Oŋu fukeme foriine so wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Koruŋ goineji moreŋ fiineo rakaru ŋebuŋ. Rakaru keku bobuŋyaŋunji pougaru pakereru yoyaŋunde fori fiine fukebuŋ. Goineji koruŋyaŋuŋ 30, goineji koruŋyaŋuŋ 60, goineji 100 ore so fukeru sauebuŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Oŋu miku miforeya, “Moji maŋkajeineke goga ine, iŋoji soso buŋo yo kaje ruaru mane mukuine.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kubu soguine yoŋoji roiŋgaru rakabuŋ Yesuji iŋoyoŋe akoŋ ŋeya. Iŋoyoŋe akoŋ ŋeko kiŋariŋpuine 12 eru goine roregakabuŋ, oi moko soso buŋo yo ore fuŋinere weu tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Weu tebi iŋi kerisieru yajiya, “Anuture qorumaŋgo ropegokiminde buŋo soŋsoŋine oi ŋoŋo totogo ŋajibe mane mukugobiyoŋ, sakibe gobuŋ, yoŋore ore oi sosowo soso buŋoji akoŋ fukeega. ");
INSERT INTO mlh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Oŋu fukeko ‘Yoŋoyaŋunde jiŋoji ya ŋoneku fuŋine jibu so mane mukunimiŋ. Yoŋoyaŋunde kajeji buŋo poretiŋ maneru fuŋine jibu so mane taniŋganimiŋ. Oi mane taniŋganimiŋ ine, soine maŋyaŋuŋ kerisiebi Anutuji agiburaŋyaŋuŋ bokena.’” ");
INSERT INTO mlh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuji jikigaku iŋi yajiya, “Soso buŋo ore fuŋine oi so mane taniŋgagobi ine, soso buŋo goine sosowo mibemiŋ, oi bio uruŋu mane taniŋganobuŋ? ");
INSERT INTO mlh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Soso buŋo ore fuŋine oi iŋi: Koruŋ titie ŋiji Biŋe buŋo qopogaru tieega. ");
INSERT INTO mlh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Uqo koruŋ kadi qaŋaŋineo rakaru ŋebuŋ, oi iŋi: Biŋe buŋo qopogaru tiebuŋ ŋiŋigo maŋyaŋuŋgo rakaegayoŋ, oi manebi Satanji oo akoŋ wareru buŋo maŋyaŋuŋgo qoqogabi rakaya, oi qomukuru oga ŋabeega. ");
INSERT INTO mlh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Uqo koruŋ qopogame ko oŋgiŋgo rakaru ŋebuŋ, oi oŋuakoŋ ŋiŋigo sosoyaŋuŋ mo. Yoŋoji Biŋe buŋo maneru oo akoŋ beufi paio maneru sabareegobi. ");
INSERT INTO mlh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Oŋu eyareegayoŋ, maŋyaŋuŋgo goduine so pe yareiŋyoŋ, damaŋ qondiŋineo akoŋ dimaku siŋaŋgaru gonimiŋ. Biŋe buŋo ore eru suroŋqoqo me kekesuesue fukeme damaŋ oo akoŋ waki ŋabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Uqo koruŋ qopogame komeqore joruinekeo rakaru ŋebuŋ, oi iŋi: Yoŋoji Biŋe buŋo manebi maŋyaŋuŋgo rakaega. ");
INSERT INTO mlh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Rakaegayoŋ, moreŋgo gogore manemeja eru moneŋ mebo fufurure manjo fukeru yobiŋ yabeega. Tinabiŋeyaŋuŋke fukeiŋ ore sase ebuŋ aŋi sanaŋine sembene goineji oŋuakoŋ maŋyaŋuŋgo maŋgaru Biŋe buŋo boŋeŋgaru barugoegobi. Oŋu fukeme foriyaŋuŋ tomiri aputa (gipeine) fukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Uqo koruŋ moreŋ fiineo qopogame rakaru ŋebuŋ, oi ŋiŋigo yo oŋu: Yoŋoji Biŋe buŋo kaje ruaru maneru maneru sabareru gbeŋ akoŋ dimaku foriyaŋuŋ bofukeegobi. Goineji buŋo miku moakoŋgone koruŋ 30 bofukeegobi. Goineji foriyaŋuŋ 60, goineji buŋo koruŋ moakoŋ moakoŋ ore foriyaŋuŋ 100 basaueru bofukeegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuji buŋo mo iŋi miya, “Moji lambe me doi roru qureru dero me ŋeŋe yukuineo ruaiŋ me mata? Oi uro ruaiŋ? Oi ore ŋeŋeineo totogo ruaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Oŋuakoŋ ya mo sumuŋgabi pega, oi totogo fukeiŋ ore pega. Ya mo keku kemagabi pega, oi borombiebi boroiŋgaiŋ ore eru pega. ");
INSERT INTO mlh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Moji maŋkajeineke goga ine, iŋoji soso buŋo yo kaje ruaru mane mukuine.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesuji buŋo iŋi yajiya, “Buŋo manegobi, oi maneru sabareru maŋ wombuŋ-ŋaŋuŋgo ruaru kegboreru goinebi. (Oŋu gokabi maŋyaŋuŋ poretiŋgame mamanesuŋaŋunji sogueme maneru komenimiŋ.) Ŋoŋo goine yoŋore buŋo osoeru mitarinimiŋ, Anutuji mimitiŋaŋuŋ moakoŋ ore so ŋoŋo-ŋaŋunde buŋo osoeru mitariiŋ. So oi odureru geoine kerisieru yareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ore fuŋine oi iŋi: Moji mamane-mukuineke goga, Anutuji oi jikigaku oteme goiŋyoŋ, moji mamane-mukuine tomiri goga, Anutuji mamaneine mendaine pega, oi oŋuakoŋ qomukuru roiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuji soso buŋo mo iŋi miya, “Anuture qorumaŋ oi yo oŋuine: Ŋi moji gioo raru uqo koruŋ qopogaru tieiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Qopogaru tieru raru una ubu peku papakare eme uqo korunde bobuŋine pougaru wapeegobi. Uruŋu pougaru wapeegobi, oi iŋoyoŋe so mane mukuga. ");
INSERT INTO mlh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Moreŋ iŋoyoŋe akoŋ maŋgo eteko foriine fukeega: Rone yoine, jiki foriine ruame ore ŋadiineo foriine ore koruŋ oi sosowo fukeru sogue forenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Foriine sogue foreru gumuŋgame foriine rorore damaŋ fukeme kiŋaŋqoqopuine sore yabeme siqoyaŋuŋ kekesiine miineke roru foriine roiŋ ore gioineo ranimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuji soso buŋo mo iŋi miya, “Anuture qorumaŋ oi wamoyake so minobeŋ me wamo soso buŋoji mifukenobeŋ? ");
INSERT INTO mlh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Oi yojuŋ korunde so iŋi fukega: Koruŋ oi mendaine made. Oi morende uqo koruŋ sosowo yoŋore wawakiine fukega. Oŋu fukeme gioo sariegobi. ");
INSERT INTO mlh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sariegobiyoŋ, pougaru pakereru munjaŋ sosowo yadureru sogueru tieŋine sogo sogo ruame raru wareega. Oŋu bokeru rako sowore webo yoŋo youyaŋuŋ ore mumuineo baegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuji soso buŋo oŋu oi kokoine miku goku Biŋe buŋo yajiya. Mane mukubuŋ ore so oi yajime maneru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Damaŋ so buŋoine sosowo oi soso buŋoji miku goya. Buŋoine mo omaine so miyayoŋ, kiŋariŋpuine yoŋoke yoŋoyoŋe akoŋ gobi damaŋ oo buŋo sosowo ore fuŋneyaŋuŋ oi mitaniŋga yareku goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wegi oo kae ubu eme Yesuji kiŋariŋpuine iŋi yajiya, “Niŋo bokeru joguŋ petigaru aribe ropeki.” ");
INSERT INTO mlh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Oŋu yajime ŋiŋigo kubu boke yaberu Yesu roru ogâo roperu ŋeko rabuŋ. Ogâ goine oi oŋuakoŋ yoŋoke ŋadio ŋadio rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Rakabuŋ siritemboŋ yasogoji ututuŋ pakereme siriji ogâ maŋineo rakame ogâ puseiŋgo eya. ");
INSERT INTO mlh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Oŋu fukeme Yesuji ogâ jikiineo ŋeku qoriŋgo roegaru kubaŋ peya. Kubaŋ peko kiŋariŋpuineji raru wiwigaku ojibuŋ, “Hei qaqaji! Niŋo joguŋgo sibirigaiŋgo egobeneŋ. Ore manebuine mo manege me mata?” ");
INSERT INTO mlh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Oŋu ojibi maŋine gboreme maneru pakereru gbiŋ eru siri iŋi mitiga yateya, “Bio bokeru niniŋ peni!” Oŋu miko gbinji munaŋgaru siriji benoŋ baru pebu. ");
INSERT INTO mlh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Oŋu eru iŋi miku yajiya, “Ŋoŋo wamore kokoi mamane ŋi fukegobi? Uruŋure eru Anutu so manesiŋ gagobi? Sombuŋaŋuŋ wamore omaine manegobi.” ");
INSERT INTO mlh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Miku yajime waragaku sombuyaŋuŋ maneru mimane ebuŋ, “Yei, mamagore siaine! Ŋi oi wamo ŋi goga? Iŋoji gbiŋ eru koe mitiga yateme miine reŋgabu?” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Oŋu fukeko joguŋ petigaru aribe Gerasin yoŋore moreŋgo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Roperu qaŋaŋineo ropebi Yesuji ogâ bokeru oo akoŋ ŋi gemoineke mo jiŋoruŋgone wareru dimaku Yesu bofukeya. ");
INSERT INTO mlh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ŋi oi jiŋoruŋgo goku qoŋgbuŋ ko kouŋ sikeru gufukabi pebuŋ, oo peku goya. Ŋi sosowoji me kufuine gbediji (niginji) kipeiŋgo embimbiŋgaru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ateine ateine kufuine gbediji kiperu maŋgu baru gobuŋyoŋ, me musaine qateebuŋ, oi qaisueru kufu nigiŋine odemukuru goko sosowoji oi siŋaŋ gaiŋgo embimbiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Embimbiŋgaru una ubu jijiki jiŋorunde ko kouŋgo me tukuo kosabasa peku goya. Oŋu goku oŋga jojoraku sakiine kogo qaku ketiqoti goya. ");
INSERT INTO mlh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesuji jojorigo wareme ŋoneru giniŋgaru wareru moreŋgo bembeŋgo rakaru dikanji ke teya. ");
INSERT INTO mlh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Dikanji bakaigame Yesuji gemoine oi iŋi ojiiŋgo eya, “Gemo sembene, go bio ŋi yo bokeru ra!” Oŋu miiŋgo eme fonuŋ ooŋ soguine oŋga rurugaru miya, “Ae! Yesu, go Anutu ropekiinere Made fukege. Go uruŋu eru enoreiŋgo warege? Nonji Anuture jiŋo maio karieru weu garego: Go buŋo kiperu mimipaŋ buŋoji misanaŋgaru joiserereŋ joineke so enareigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Oŋu miko iŋi weuya, “Go tinago mo?” Weume mibuŋ, “Niŋo kokoine gogobeneŋ ore tinanoŋuŋ Legion migobeneŋ.” Oi noŋunde buŋoo Mamari kubu soguine. ");
INSERT INTO mlh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Oŋu miku yameŋ keku iŋi karie tebuŋ, “Go yobe nabenoŋ ine, moreŋ yoone so sore nobe.” ");
INSERT INTO mlh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mafuŋyaŋuŋgo goyoŋine oo kaneŋ kubu soguine mo kegbaŋ maŋineo suaku dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ore gemo yoŋoji iŋi miku Yesu karieru weu tebuŋ, “Goji sore nobende niŋo soine kaneŋ yoŋore maŋyaŋuŋgo rakainebeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Karieru weu tebi “Bio raku rakaniŋ!” mitiga yareko ŋi maŋineone waperu raku kaneŋ maŋyaŋuŋgo rakabuŋ. Rakakabi oo akoŋ kaneŋ kubu 2,000 oŋu oi riŋaru pagaŋgo raku siririkeru obu joguŋgo rakaru noru komebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Komebi kaneŋ siŋaŋ yoŋoji kamieru taoŋ eru kae memendaine oo raru biŋe buŋo mibuŋ. Mibi maneru ŋiŋigo jiŋorara yoŋoji ya fukeya, oi ŋoneiŋgo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wareru Yesureo waperu ŋonebi ŋi gemo kubuinekeji goya, iŋoji kambaŋ sakikomoŋine poretiŋ kiperu ŋeku maŋine gboreme mamanesuine sosowo fukeko ŋoneru waragaku dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dimakabuŋ kaneŋ oi uruŋu rakaru komebuŋ eru ŋi gemoineke iŋoreo ya fukeya, oi ŋonebuŋ, yoŋoji sundu yoyoka oi yajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yajibi dimaku Yesuji qoqodure kae moreŋyaŋuŋ bokeru raiŋgo ore karieru weu tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Karieru weu tebi bokeru ogâo ropeiŋgo dimako ŋi gemoineke goya, iŋoji wareru Yesuke moko raku goiŋgo weuya. ");
INSERT INTO mlh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Weuyayoŋ, Yesuji qomuku teku iŋi ojiya, “Go bio kaegoo raru tifepugo ŋone yaberu Ofonji mosi qoqowirie soguine baku ŋonemaiŋ egareya, ore sundu oi yajinde manenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Oŋu ojime bokeru raru Yesuji mosi qoqowirie sogo sogo baku oduya, ore buŋoine fuŋgaru Ten-taoŋ distrik maŋineo miku saueme sosowoji maneru waragabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuji ogâo roperu kirieru joguŋ petigaru aribe wareme ŋiŋigo kubu kokoineji iŋoreo wareru tumaŋgaru joguŋ qaŋaŋineo dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dimakabuŋ oŋgawowosi pire buŋo siŋaŋ mo tinaine Jairus iŋoji wareru Yesu ŋoneru maŋfuŋineo rakaru dikanji ke teya. ");
INSERT INTO mlh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Dikanji ke teku yameŋ keku oŋga wosigaru iŋi ojiya, “Odune mendaineji komeiŋgo ega. Go wareru mego paiineo ruande fiaru jikigaru goiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Oŋu ojiru Yesu ogagame moko rabu ŋiŋigo kubu sogo yoŋoji ŋadiyakuŋgo raru kekepuŋ eru rore yaperu rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Rakabi oo botuyaŋuŋgo ŋigo mo goya. Iŋoji kaindari gosa 12 ore so ŋoneru jibe bame goya. ");
INSERT INTO mlh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Oŋu goku joiserereŋ kokoine maneme sakisiŋaŋ kokoineji iŋore gioine babi babapi mo so bofukeru goya. Iŋoji sakisiŋaŋ ŋiŋigo yoŋore furire moneŋ meboine sosowo bokeru goyayoŋ, jibe oiji moke moke bosembeame goya. ");
INSERT INTO mlh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Oŋu goku Yesure biŋe maneru iŋi miya, “Nonji oi yoŋoiŋgo maneru yobiŋgaru marikuine akoŋ kokiine mo yoŋonobo ine, bio soine fiabemiŋ.” Oŋu miku ŋiŋigo kubu botuyaŋuŋgo Yesure ŋadio raru marikuineo yoŋoya. ");
INSERT INTO mlh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yoŋome dariine oo akoŋ jigame qapeqawakiine oi mataeme sakiineji fiame maneya. ");
INSERT INTO mlh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Fiame Yesuji oo akoŋ usuŋine mo petigaru rame, oi maneru ŋiŋigo kubu botuyaŋuŋgo kirieru weuya, “Moji marikune yoŋoga?” ");
INSERT INTO mlh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Oŋu weume kiŋariŋpuineji iŋi ojibuŋ, “Ŋiŋigo kubuji kekefoŋ eru rore guru yoŋo gugobi. Oi ŋoneru uruŋu ‘Moji yoŋo nuga?’ weuge?” ");
INSERT INTO mlh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Oŋu mibuŋyoŋ, Yesuji moke “Moji oi ega?” miku weuku bofukeiŋgo ore kirieru piku ŋone yabeya. ");
INSERT INTO mlh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ŋone yabeme ŋigo sakiineo mosi qoqowirie fukeya, iŋoji oi maneru ore kokoi maneru gburugburu qakame wareru Yesure maŋfuŋgo rakaru dikanji keru fuŋine sosowo ojiya. ");
INSERT INTO mlh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesuji oi maneru iŋi ojiya, “Odune, mamanesiŋgoji bobiaŋ guga. Qapeqawakigoji bio mataeme soine maŋwomoo raigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Buŋo oŋu ojiru dimako oŋgawowosi pire buŋo siŋande pigone moji biŋeba wareru Jairus ojiya, “Odugo komega! Ore eru qaqajire paio yobiŋ jikigaru so ruaigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ojiko Yesuji buŋo ore keta eru oŋgawowosi pire buŋo siŋaŋ iŋi ojiya, “Kokoi so mane. Noŋ manesiŋ nuigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Oŋu ojiru ŋiŋigo goine boke yaberu Pita, Jeims eru Jeims gboine Jon oi akoŋ oga yabeme oi boyoberu rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Raru oŋgawowosi pire buŋo siŋande pigo ropekabi ŋiŋigo kubu oyowo bakabi ŋone yabeya. Kokoineji jiŋgeŋ keku sanaŋine kioku soguŋ babuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ŋone yaberu pigo roperu iŋi yajiya, “Ŋoŋo wamore oyowo baku kuyogobi? Odu oiji so komegayoŋ, kubaŋ pega.” ");
INSERT INTO mlh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Oŋu yajime jere oŋuine fukeme gou etebuŋyoŋ, iŋoji oi sosowo yobe yabeku odure maŋgo mamaine eru goine iŋoke gobuŋ, oi akoŋ oga yabeme odu peya, oo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Roperu Yesuji odu oi meineo roru ojiya, “Talita kum.” Oi noŋunde buŋoo Odu menda, noŋ gajigo: Go pakere! ");
INSERT INTO mlh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Oŋu ojime odu gosaine 12 iŋoji bio oo akoŋ pakereru dimaku ra wareya. Oŋu fukeme ŋoneru jorukuyaŋuŋ kitigaru waragabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Waragabi ore binaŋine mo mibi egu manenimiŋ ore miku agi sanaŋine ruaya. Oi ruaru odu menda oi uqo munjaŋ otebi noiŋgo ore yajiya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Oi fukeme Yesuji Jairusre kae moreŋ bokeme kiŋariŋpuineji boyoberu iŋoke raru Yesure sosogue taoŋgo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat kombaŋgo wareme oŋgawowosi pigo roperu Biŋe buŋo fuŋgaru qaji yareya. Qaji yareme maneru ŋiŋigo kokoineji popureru waragaru iŋi mibuŋ, “Yei, kajegi! Ya sosowo yo urone maneru miga? Maŋgboroŋine oi moji qaji teme miga? Eme mosi qoqowirie usuŋineke oŋu oi moji dobe gako meineo bako fukega? ");
INSERT INTO mlh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ŋi yo kae yoore ketigaqoqo ŋiine. Mariare made eru Jeims, Josef, Juda eru Saimon yoŋore kaka. Seŋpuineji botunoŋuŋgo yo gogobi.” Nazaret yoŋoji oŋu mibi maŋyaŋunji sembeako oo embimbiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Embimbiŋgabi Yesuji iŋi yajiya, “Kajeqouŋ ŋire daritife eru tifepuineji iŋoyoŋunde taoŋgo mipemiriŋ eteegobiyoŋ, kae goine oo oŋu mata.” ");
INSERT INTO mlh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Oŋu ebuŋ ore Yesuji jibe ŋiŋigo moakoŋ moakoŋ meine paiyaŋuŋgo ruaru bobiaŋ yabeyayoŋ, mosi qoqowirie usuŋineke goine baiŋgo ore embimbiŋgaya. ");
INSERT INTO mlh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Oŋu fukeme mamanesiŋyaŋunji so fukeko qoqomukuyaŋuŋ ore eru popureya. Popureru boke yaberu Nazaret bembeŋgo kaeine kaeine roregaru Biŋe buŋo qaji yareru goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesuji kiŋariŋpuine 12 oi oga yabeme warekabuŋ fuŋgaru yoyoka yoyoka sosowo sore yabeya. Sore yaberu gemokaku yobe yabenimiŋ ore usuŋine yareya. ");
INSERT INTO mlh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Oi yareru iŋi mitiga yareya, “Kadi raiŋgogobi ore tokuŋaŋuŋ roru ranimiŋ. Ya goine mo so roniŋ. Kadi tebuŋaŋuŋ mata, kekereŋaŋuŋ mata me siqojiŋo oi bifuŋ nigiŋ-ŋaŋuŋgo so kipeinebi. ");
INSERT INTO mlh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kufu komoŋ soine kufuŋaŋuŋgo kipeinebi. Mariku tebuine matayoŋ, mariku moakoŋ baniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Oŋu miku iŋi yajiya, “Raru pi uri uri ropenimiŋ, oo akoŋ goku gio baku taoŋ oi bokeru kadi rainebi. ");
INSERT INTO mlh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Raru goku pi mogo ropebi so ke pore ŋaberu buŋoŋaŋuŋ so manebi ketayaŋuŋ iŋi miku yaduinebi, ‘Niŋo ŋoŋore moreŋgo warebeneŋ rufe kufu tapenoŋuŋgo bakatoga, oi oderu qakiokabi ŋoŋo-ŋaŋundeo kirieru rakaiŋ.’ Oŋu mibi fuŋneŋaŋuŋ posiine mane mukubi soine kae me taoŋ oi bokeru jikigaru rainebi.” ");
INSERT INTO mlh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Oŋu yajime bokeru raru ŋiŋigo maŋyaŋuŋ bokirienimiŋ ore Biŋe buŋoine oi misaueku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Goku gemokaku kokoine yobe yabeku jibe ŋiŋigo kokoine jijiji rau yareru bobiaŋ yabebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesure tinabiŋeji saueru kiŋ Herodre kajeineo rakame maneya. Ŋiŋigoji iŋi mibuŋ, “Jon Mitimeso ŋiji komegone pakereru gioine bame mosi qoqowirie usuŋineke fukeega.” ");
INSERT INTO mlh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Oŋu mibiyoŋ, goineji iŋi mibuŋ, “Oi Elaija.” Goineji jikigaru mibuŋ, “Oi kajeqouŋ ŋi raŋgbaŋine yoŋoreone mo.” ");
INSERT INTO mlh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Oŋu mibuŋyoŋ, kiŋ Herodji oi maneru iŋi miya, “Jon Mitimeso ŋi nonji mikabe ubeine ketigabuŋ, iŋoji komegone pakereru goga.” Manebu eku oŋu miya. ");
INSERT INTO mlh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Oi iŋi ore miya: Herodji gboine Filip ŋonuŋine Herodias sumuŋgaru roko Jon Mitimeso ŋiji kiŋ koito ojiku miya ore kambanti sore yabeme raru Jon roru kiperu witi pigo ruabi. ");
INSERT INTO mlh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jonji Herodre buŋo iŋi miya: “Go simogo sumuŋgaru roru goku Kadi buŋo odurege.” ");
INSERT INTO mlh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Oŋu miko Herodiasji Jon rosi eteme qabi komeiŋ ore maneyayoŋ, ore fuŋine mo so bofukeya. ");
INSERT INTO mlh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","So bofukeme Jonji ŋi posiine eru gbagbataeŋine tiriine fukeya, Herodji oi maneru sa kiperu iporo keku maro qoso oteru Jonde kokoi maneru goya. Oŋu goku Herodji Jonde migone buŋo maneya, oi maŋine bapakarebi buŋo kokoineore maŋyoyoka maneya. Oi jibu Jonde buŋo maneiŋgo aŋi maneya. ");
INSERT INTO mlh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Oŋu fukeme Herodiasji Jon qaiŋgo ore fuŋine so bofukeru gome ore damaŋine fiine oi iŋi wareru fukeya: Kiŋ koitore fufuke damanji wareme jebe ruaru muraŋ eru mamari siŋaŋpuine eru Galili prowinsre minebobopu qoruine oi kepore yabeme waperu ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Waperu ŋebi Herodias oduineji pi ore maŋineo waperu boji bame Herod eru iŋoke uqo ŋeŋe roregaru ŋebuŋ, yoŋoji ore ŋone aŋiine kokoine manebuŋ. Oŋu manebi kiŋ koitoji ŋigo jeŋoŋ oi iŋi ojiya, “Odune, go wamo yare aŋi manemiŋ, oi soine weu narende kisiŋga garebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Oŋu ojiru buŋo oi mimipaŋ buŋoji misanaŋgaru iŋi ojiya, “Wamo yare weu narende, oi soine garebemiŋ. Ya oi me oi me prowins siŋaŋ yabeego, oi oŋuakoŋ soine boroiŋgaru mobeine mo garebe siŋaŋyaŋuŋ fukeigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Oŋu ojime sakibe raru maŋgoine iŋi weu teya, “Maŋgone, noŋ Kiŋ koitoji wamo ya nareiŋ ore weu tenobo?” Oŋu weu teya maŋgoineji iŋi bokirieya, “Go raru minde Jon Mitimeso ŋire ube ketigabi qoruine roru wareru nareigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Oŋu bokirieme oo akoŋ pi maŋineo giniŋgaru kiŋ koitoreo roperu iŋi weuku ojiya: “Mama, nonji aŋi iŋi manego: Goji mitigande Jon Mitimeso ŋire ube ketigaru qoruine jambeo ruaru roru ware oi muŋambe yo nareigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Oŋu ojime kiŋ koitore manji jajabame beusembe maneyayoŋ, mimipaŋ buŋoine kipeme sogunepuine yoŋo oi manebuŋ, yoŋore jiŋoo egu waki qaiŋ ore weweuine ŋadi gaiŋgo maneme yobiŋgame bokeya. ");
INSERT INTO mlh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bokeru oo akoŋ kambantiine mo soreru ojiya, “Go bio raru Jonde ube ketigaru qoruine roru wareigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Oŋu ojiru soreme witi pi yukuineo raru ubeine ketigaru qoruine juago ruaru roru wareru ŋigo jeŋoŋ oi oteme maŋgoine oteya. ");
INSERT INTO mlh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jonde kiŋariŋpuineji ore biŋeine maneru raru qoŋgbuŋine roru jiŋarunde ko kouŋgo ruaru yaŋgabuŋ. Oŋu fukeya ore eru kiŋ Herodji jiki Yesure miya, “Jonji komegone gboreru pakere goga.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sosore ŋi aposol yoŋoji Yesureo wareru tumaŋgaru ya baku ŋiŋigo qaji yarebuŋ, ore sundu sosowo ojibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ojibi ŋiŋigo jijiki raware ebi sakiyaŋuŋ takireyayoŋ, uqo nonimiŋ ore damaŋine so fukeya. Ore eru Yesuji kiŋariŋpuine iŋi yajiya, “Ŋoŋo noke warebi moreŋ qotigo noŋuŋ jikoŋ raru goku gbiŋ mendaine rokimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Oŋu yajime ŋiŋigo boke yaberu ogâo roperu moreŋ qotigo mogo yoŋoyoŋe jikoŋ goiŋgo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Rabi ŋiŋigoji oi ŋoneru kokoineji ore biŋeine maneru taoŋ eru moreŋ so oone moreŋ kadi giniŋgaru bonieru raru oo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ropebi Yesuji ogâone waki ŋiŋigo kubu soguine ŋone yabekame lama siŋaŋyaŋuŋ tomiri kamasi siŋsaŋ qaru gobi yoŋore beusembe maneya. Beusembe maneru fuŋgaru Biŋe buŋo fuŋne fuŋne qaji yareya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Oŋu eru goko wegi jiŋo mukuru rakaiŋgo eme kiŋariŋpuineji Yesureo wareru iŋi ojibuŋ, “Qaqaji, Niŋo moreŋ qotigo yo gobeneŋ kae ubu eiŋgo ega. ");
INSERT INTO mlh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ore eru go soine ŋiŋigo yo sore yabende kae eru pi memendaine bembeŋgo ŋe ragobi, oo raru uqo munjaŋ furiine baku nonimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Oŋu mibiyoŋ, iŋi kerisieru yajiya, “Ŋoŋoji ŋoŋo-ŋaŋe oi uqo gume yabeniŋ.” Oŋu yajime weu tebuŋ, “Niŋoji bio uruŋu enobeŋ? Gio bobo damaŋ 200:re furi (Kina 2,000) pega. Moneŋ oi roru raru uqo poroŋ furiine baru gume yabeiŋgo ore mige me?” ");
INSERT INTO mlh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Oŋu weu tebi miya, “Ŋoŋo-ŋaŋunde uqo poroŋ wojimu pega? Oi raru ŋoneniŋ.” Oŋu miko kekereyaŋuŋ basiru mibuŋ, “Poroŋ 5 eru jembaeŋ yoyoka oŋumeŋ baru gogobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Oŋu mikabuŋ Yesuji ŋiŋigo kubu iŋi mitiga yareya, “Ŋiŋigo sosowo, ŋoŋo roiŋgaru uqo noiŋgo qoko memendaine tumaŋgaru kegbaŋ rekagarigo rakaru ŋeniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Oŋu mitiga yareme bembeŋgo qokoine qokoine roiŋgaru ŋebuŋ. Kubu goine 100 eru goine 50 oŋu oŋu qodureru ŋe rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ŋe rabi poroŋ 5 eru jembaeŋ yoyoka oi roru Sombuŋgo pime ropeme mifiagaru poroŋ bajiku kiŋariŋpuine yareme ŋiŋigo qoko so boroiŋgaru botuyaŋuŋgo ruabuŋ. Jembaeŋ yoyoka oi oŋuakoŋ qoko sosowo yoŋore boroiŋgaya. ");
INSERT INTO mlh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Boroiŋgame ŋiŋigo sosowo noku gaba yabeya. ");
INSERT INTO mlh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Noku gaba yabeme uqo tifeine tifeine bokebuŋ, oi kiŋariŋ yoŋoji roru qojugabi jambe 12 oo rakaru puseya. Oŋuakoŋ jembaeŋ tifeine oi roru qojugabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ŋi poroŋ nobuŋ, yoŋore jare oi 5,000. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nobi tarime Yesuji oo akoŋ kiŋariŋpuine mitiga yareru iŋi miya, “Ŋoŋo ogâo roperu bonieru obu joguŋ petigaru aribe Betsaida kaeo raniŋ. Nonji soine damaŋ botuineo ŋiŋigo kubu yo sore yaberu warebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Oŋu miku momojoyaŋuŋ yajiru tukuo roperu oŋga wosiya. ");
INSERT INTO mlh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Oŋga wosiru gokame kae ubu eme iŋoyoŋe akoŋ tukuo gokame ogâyaŋunji joguŋ botuineo raya. ");
INSERT INTO mlh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Rako qaqaji qaku qaku esegaru kitiŋgabi rako gbiŋgo rabuŋ, ore oobene qaku wareme yobiŋgame manebu sogo manebuŋ. Kae fufurere (3-6 kilok) oŋuine oo Yesuji oŋu ŋone yaberu obu joguŋ paio ode ode kiŋariŋpuine yoŋoreo raru yadureiŋgo eya. ");
INSERT INTO mlh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Obu joguŋ paio ode ode rame oi ŋoneru “Koe Dabodanji warega!” miku fuŋgaru oŋga jojorabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Oŋga jojoraku sosowoji oi ŋoneru kokoi manekabuŋyoŋ, Yesuji oo akoŋ buŋo waigomeŋ miku iŋi yajiya, “Ogopune, kobiŋaŋuŋke jogbake goinebi. Nake warego. Kokoi so maneniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Oŋu miku yoŋoreo ogâo ropeme gbinji niniŋgaya. Niniŋgame gburugburu yabeme mokemoke yobu popurebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Rone poroŋ ba saueru gume yabeya, ore fuŋine so mane taniŋgabuŋyoŋ, maŋyaŋunji kebojigame oŋuakoŋ popureru ŋebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Obu joguŋ petigaru aribe Genesaret moreŋgo roperu ogâ bokeru mageŋgo rakabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ogâ bokeru mageŋgo rakakabi ŋiŋigoji Yesu oo akoŋ mane mukubuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mane mukubi buŋo ruabi roru giniŋgaru qoqodure dobu kaeyaŋuŋgo kae so roregabuŋ. Roregabi maneru fuŋgaru jibe ŋiŋigo reŋgo kobe yaberu Yesuji kae uri goya ore so oga yaberu warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kae so, taoŋ, pi me ako more maŋgo raya ore so jibe ŋiŋigo oga yaperu kae jiŋoyaŋuŋgo rua yabebuŋ. Rua yaberu Yesure sakio me marikure tifeo bouaiŋ ore karie teru gobuŋ. Bouabuŋ, sosowo yoŋoji bio fia forebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kadi buŋore yameŋyameŋ eru ore qaqaji goine Jerusalem sitione warebuŋ, yoŋoji Yesureo wareru tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Damaŋ oo Yesure kiŋariŋpu goineji meyaŋuŋ so jureru babaaŋ so qaku uqo munjaŋ nobi ŋone yaberu maŋyaŋuŋ sembeaya. ");
INSERT INTO mlh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi (Kadi buŋore yameŋyameŋ) eru Juda ŋiŋigo goine sosowo yoŋoji apa ŋaso yoŋore mosiyaŋuŋ boyoberu gobuŋ. Ore eru meyaŋuŋ bonieru jureru emasaŋgaru uqo munjaŋ noku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Oŋuakoŋ gioone me nareŋgareŋ kaeone warenimiŋ, oo bonieru obu pioru rauku keririkeru uqo bouaku gobuŋ. Oŋuakoŋ popu, dero eru gomba sosowo oi jureru babaaŋ qaku gobuŋ. Mosi oŋuine oŋuine oi kokoine boyoberu gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ore eru Kadi buŋore yameŋyameŋ eru ore qaqaji yoŋoji Yesu iŋi weu tebuŋ, “Gore kiŋariŋpugoji wamore apa ŋasopunoŋuŋ yoŋore mosi so boyoberu meyaŋuŋ babaaŋ so qaku jibu uqo munjaŋ roru noegobi.” ");
INSERT INTO mlh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Oŋu weu tekabuŋ iŋi yajiya, “O maŋkekerisiere ŋiŋigo sasakiine, kajeqouŋ ŋi Aisaiaji ŋoŋore fuŋneŋaŋuŋ poretiŋ kekogaru Biŋe Quraŋ mo iŋi quraŋgame pega, ‘Ŋiŋigo kubu yo oiji mi bibiyaŋunji fiine akoŋ araŋ ba nareegobiyoŋ, maŋyaŋunji keta enareku mogo jorigo ruabi pega.’ ");
INSERT INTO mlh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Oŋu peko nonde ohowe omaine yobu baku miteŋ nuegobi. ‘Kadi buŋo qaji yareiŋgo ore tifeineo ŋiŋigo yoŋore mimitiyaŋuŋ oi edobodo eku bobojibu eegobi.’ ");
INSERT INTO mlh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aisaiaji oŋu quraŋgaya. Ŋoŋo ore so Anuture mimipaŋ buŋo ŋadi gaku apa ŋasopuyaŋuŋ yoŋore mosi boyobeegobi. Oi so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Oŋu miku iŋi yajiya, “Ŋoŋo-ŋaŋunde mosi raŋgbaŋine boyobeiŋgo ore fiine akoŋ Anuture mimipaŋ buŋo kepiegobi. ");
INSERT INTO mlh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ore buŋoine mo oi iŋi: Mosesji iŋi mitigaya, ‘Maŋgo mamago araŋ ba yateeigoŋ,’ eru ‘Moji mamaine me maŋgoine qaiso gaiŋ, oi bio qabi komenoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Oŋu mitigayayoŋ, ŋoŋo buŋo oi odureru iŋi miegobi, ‘Moji maŋgo mamaine oi iŋi yasiiŋ: O beusembe manego. Nonde kikitiŋ ya biŋe qaku qoture nopebuŋ, oi Anuture taha pesiŋ ore osoeru rua forebe mitire pesiŋ fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Moji oŋu yasime sagaiŋ migobi.’ Oŋu miku kiperu otebi maŋgo mamaine yokore babapi mo so jikiga yateeiŋ. Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yei! Oŋu eku ŋoŋo-ŋaŋunde eeboboŋaŋunde mosiŋaŋuŋ mitigaku oo Anuture mimipaŋ buŋo kepiebi omaine fukeru jaŋgaru mataeega. Ŋoŋo ya oŋu oi kokoine baegobi.” Oŋu miku bokirie yareya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuji ŋiŋigo kubu moke oga yabeme warebi iŋi yajiya, “Ŋoŋo sosowo buŋo yo kaje ruaru mane taniŋganiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ya sakiineone ŋi maŋineo rakaega, oiji kejigaiŋ ore embimbiŋgaegayoŋ, iŋoyoŋunde maŋ wombuŋgone buŋo waperu wakiega, oiji maŋine kejigame gobureega. ");
INSERT INTO mlh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Moji kajeineke goga ine, iŋoji buŋo yo kaje ruaru mane mukuine.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesuji oŋu miku ŋiŋigo kubu boke yaberu raru pi mogo ropeya. Roperu ŋeko kiŋariŋpuineji soso buŋo ore fuŋinere weubuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Weubi iŋi yajiya, “O ogopune, ŋoŋo oŋuakoŋ mamaneŋaŋuŋ fiine so fukegameŋ? Uqo munjaŋ ya sakiineone ŋi beuineo rakaega, oi kejigaiŋ ore embimbiŋgaega. Oi mane mukugobi me mata? ");
INSERT INTO mlh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Oi maŋ wobuŋineo so rakaegayoŋ, beuineo rakaru sakibe wakiega.” Yesuji buŋo oŋu miku oo uqo munjaŋ sosowo oi bagbagbaga foreya. ");
INSERT INTO mlh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesuji jikigaru iŋi miya, “Ŋi maŋ wombuŋineone buŋo waperu wakiega, oiji maŋine kejigame gobureega. ");
INSERT INTO mlh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ŋiŋigo maŋ wombuŋyaŋuŋgone ya yo oŋuine fukeru wapeega: Buŋo sembene manesuku boesau eiŋgo ore maneegobi. Ya kiaŋ roru kipe seroŋ baku ŋiŋigo yabebi komenimiŋ ore maneegobi. ");
INSERT INTO mlh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Bobojibu eiŋgone ore maneegobi. Roruro eiŋgone ore ebu eegobi. Gboruiŋ mimisembe eru sinefuru eiŋgone ore maneegobi. Buŋo kekesiine miku maŋgigi eiŋgo ore maneegobi. Kajegi eku maŋboiŋ eiŋ ore maneegobi. Sigokeiŋ goku ŋadiqoqo buŋo miku Anutu igosisi eneiŋgo ore maneegobi. Jauba-iriŋbiriŋ eku mosi maŋyaŋuŋ tomiri eegobi. ");
INSERT INTO mlh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ya sembene sosowo oi ŋiŋigo maŋ wombuŋyaŋuŋgone waperu keji yabeega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuji pakereru Genesaret kae bokeru siti tinayakuŋ Taia (Tiro) eru Saidon ore distrik tinaine Fonisia ore maŋgo raya. Raru moreŋ mogo roperu biŋeine moji egu maneiŋ ore miyaŋuŋ bojigayayoŋ, jibu soŋsoŋgo goiŋ ore embimbiŋgaya. ");
INSERT INTO mlh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Embimbiŋgame oo akoŋ ŋigo mo odu mendaine iŋo gemoineke goko Yesure biŋe maneru iŋoreo wareru maŋfuŋineo rakaru dikanji ke teya. ");
INSERT INTO mlh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ŋigo oi Judaone matayoŋ, Grik buŋo miku goya. Maŋgo mamaine oi Fonisiare Siria prowins oone. Iŋoji oduinere maŋgone gemo yobeiŋgo karieru ojiya. ");
INSERT INTO mlh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Karieru ojime iŋi ojiya, “Juda niŋo rone niŋonoŋunde odumadepu gume yabebeneŋ noku gaba yabeiŋ. Ore eru odumade yoŋore pigone poroŋ roru qoro yarebeneŋ egu so sagaiŋ. Juda noŋuŋ kotupunoŋuŋ ŋoŋore tina qoro miegobeneŋ. Nonji bonieru Juda ŋiŋigo bapi yabebe kantri goine yoŋoji qoro oŋuine odigaru goinebi.” ");
INSERT INTO mlh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Oŋu ojime maneru iŋi bokirieya, “Ofoŋ, oi soine manegoyoŋ, qoro madeine yoŋoji oŋuakoŋ odumade yoŋore uqo kuŋgaŋine uqo ŋeŋe yukuineo wakime noegobi.” ");
INSERT INTO mlh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Oŋu bokirieme Yesuji iŋi ojiya, “Buŋo oŋu mige ore soine mane garego. Gemo oiji muŋambe yo odugo bokeru raga. Ore eru go soine raigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Oŋu ojime maneru piineo rako gemoji oduine bokeme ŋeŋeineo peko ŋoneya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuji moke Taia siti moreŋ bokeru Saidon sitio raru odureru kegoigaru Ten-taoŋ morende botu odureru Galili obu joguŋ bembeŋgo wareya. ");
INSERT INTO mlh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Warekame kajegi ŋi mo buŋoine mataeiŋ ore gogo, oi ogaru Yesureo warebuŋ. Wareru meine qoruineo ruaiŋgo ore weu tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Weu tebi ŋi oi ogaru ŋiŋigo kubu oi boke yaberu mogo rabu. Raku Yesuji me sisiine kajeineo ruaru dimaku moke iŋoyoŋunde me sisiji tifagaru namaŋineo bouoya. ");
INSERT INTO mlh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bouoru Sombuŋgo pime ropeme gobogobo oŋga wosiru iŋoyoŋunde buŋoo “Efata,” noŋunde buŋoo ‘Unto,’ oŋu miya. ");
INSERT INTO mlh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Oŋu miko kajeyokaineji untome namaŋineji wirieko buŋoine fiine akoŋ miya. ");
INSERT INTO mlh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Miko Yesuji ore biŋe ŋiŋigo egu yajinimiŋ ore qomuku yareya. Qomuku yareru yameŋ keko yoŋoji oi yameŋ keku misaueku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mi saueru gobi ŋiŋigoji meayaŋuŋ mukume waragaru iŋi mibuŋ, “Ya sosowo fiine akoŋ baega. Kajegi kajeyaŋuŋ bouŋtome maneegobi. Ŋiŋigo mutuine yoŋore namaŋ kerisieme buŋo miegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Damaŋ oo ŋiŋigo kubu yasogoji moke tumaŋgabuŋ. Uqo munjaŋyaŋuŋ tomiri gobuŋ ore Yesuji kiŋariŋpuine oŋga yareme iŋoreo warebi iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nonji ŋiŋigo kubu yo yoŋore beusembe manego. Yoŋoji noke wareru una yokaomo gobi uqo munjaŋyaŋuŋ matae foreme ŋonego. ");
INSERT INTO mlh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yoŋoreone goineji jorigone wareru gobuŋ nonji ‘Soine kaeŋaŋuŋgo rainebi,’ egu yajibemiŋ. Uqo so nobuŋ omaine sore yabebe kadi botuineo ragu ragu jiŋoyaŋuŋ buburime sisibiri egu bofukenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Oŋu yajime kiŋariŋpuineji kerisieru iŋi ojibuŋ. “Moreŋ buroineo yoo moji urone uqo munjaŋ oŋuine bofukeru kubu sogo yo gume yabenobeŋ?” ");
INSERT INTO mlh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Oŋu ojikabuŋ iŋi weu yareya, “Ŋoŋoreo poroŋ wojimu ŋega?” Weu yareme “Poroŋ 7 ŋega,” ojibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ojibi Yesuji ŋiŋigo kubu sogo oi moreŋgo rakaru ŋenimiŋ ore mitiga yareko rakaru ŋebuŋ. Rakaru ŋekabuŋ poroŋ 7 oi roru Anutu oŋga wosiru daŋge miku bajiku kiŋariŋpuine yareru ŋiŋigo qoko so botuyaŋuŋgo ruanimiŋ ore miya. Oŋu miko ore so ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yoŋore jembaeŋ memendaine goine oŋuakoŋ ŋeya. Oi oŋuakoŋ roru mifiagaru ŋiŋigo qoko so botuyaŋuŋgo boto baku yarenimiŋ ore mitiga yareya. ");
INSERT INTO mlh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mitiga yareme yarebuŋ noru gaba yabeya. Nogu gaba yabeme uqo mobeine bokebi ŋeya, oi jambe 7 roru qojukabi puseya. ");
INSERT INTO mlh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ŋi uqo nobuŋ, yoŋore jareyaŋuŋ oi 4,000. Nokabuŋ sore yabeme kaeyaŋuŋgo rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Rakabi oo akoŋ kiŋariŋpuine yoŋoke ogâo roperu distrik tinaine Dalmanuta oo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi (Kadi buŋore yameŋyameŋ) goineji oo wareru Yesuke fuŋgaru migobobo ebuŋ. Buŋore buduŋgo furugaiŋgo ore esoigaru iŋi yameŋ keku weubuŋ, “Go minde Sombuŋgone mosi qoqowirie mo fukeko ŋonekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Oŋu mibi maŋineji yobiŋgame mofoŋgokeme miya, “O ŋiŋigo damaŋ yoo moreŋgo gobuŋ, ŋoŋo wamore Anuture soi fukeiŋ ore yameŋ keegobi? Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Anutuji soi oŋuine oi so baku ŋaduiŋ. Mata yobu!” ");
INSERT INTO mlh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Oŋu miku boke yaberu moke kiŋariŋpuine yoŋoke ogâo roperu obu joguŋ petigaru aribe ropebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Oo roperu tebu baiŋgo ore niga yabe poroŋ moakomeŋ oi ogâo baru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ŋebi Yesuji iŋi mitiga yareya, “Ŋoŋo Kadi buŋore yameŋyameŋ (Farisi) yoŋore beumomoki buŋoyaŋuŋ eru Herodre jama saboi ore eru siŋaŋ-ŋaŋuŋ baninebi. Oi fiine akoŋ so osoeru ŋadi ganimiŋ ine, yokoji yist oŋuine sogueru bosembe ŋabenimi.” ");
INSERT INTO mlh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mitiga yareme buŋo ŋadiine oi so mane taniŋgaru botuyaŋuŋgo iŋi mimane ebuŋ. “Poroŋnoŋuŋ tomiri ore miga me uruŋu?” ");
INSERT INTO mlh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Oi mimane ebi kajeineo rakame iŋi yajiya, “Wamore poroŋnoŋuŋ tomiri miku mimane egobi? Nonde fuŋne oi wamore so mane mukugobi? Oi so mane taniŋgagobi me? Maŋkajeŋaŋunji gigaru pega me? ");
INSERT INTO mlh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jiŋoŋaŋuŋ pegobireyoŋ, jibu so ŋone mukugobi me? Kajeŋaŋuŋ pegobireyoŋ, jibu so mane taniŋgagobi me? Ya fukeya, oi niga ŋabega me mata? ");
INSERT INTO mlh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nonji poroŋ 5 oi ŋiŋigo 5,000 yoŋore bajibe ore mobeine roru qojugabi jambe wojimu rakaru puseya?” Weu yareya “Jambe 12,” ojibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ojibi jikigaya, “Nonji poroŋ 7 oi ŋiŋigo 4,000 yoŋore bajibe ore mobeine ro qojugakabi jambe wojimu rakaru puseya?” Weu yareme “Jambe 7,” ojibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ojibi maneru miya, “Ore eru fuŋne oi oŋuakoŋ so mane taniŋgagobi me?” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesuji kiŋariŋpuine yoŋoke Betsaida taoŋgo warebuŋ. Oo wareru ŋi jiŋokombi mo ogagaru Yesureo waperu meineji bouaiŋ ore oŋga wosi tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Oŋga wosi tebi Yesuji ŋi jiŋokombi oi meineo roru ogagaru kae sakiineo rabu. Raru tifeine tifagaru jiŋoineo ruaru meine qoruineo ruaru weu teya, “Ya mo ŋonege me mata?” ");
INSERT INTO mlh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Weu teme jiŋoine pime ropeko miya, “Ŋiŋigo ŋone yabegoyoŋ, oi yo kamakamasi fukebi iiru akoŋ ŋone yabebe roware eru dimagobi.” ");
INSERT INTO mlh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Oŋu miko moke meineji jiŋoyokaine yoŋoko tiŋame poretiŋ pime taniŋgame ya sosowo fiine akoŋ ŋone foreya. ");
INSERT INTO mlh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ŋone foreme soreku iŋi ojiya, “Go moreŋ mogo so ramiŋyoŋ, poretiŋ gakere kaegoo raigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuji Betsaida bokeru kiŋariŋpuine yoŋoke Sisaria Filipai taonde bembeŋgo rabuŋ. Kadio raru kiŋariŋpuine iŋi weu yareya, “Ŋiŋigoji nonde uruŋu miegobi? Noŋ mo ŋi fukego?” ");
INSERT INTO mlh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Weu yareme kerisieru iŋi mibuŋ, “Goineji ‘Go Jon Mitimeso ŋi fukege,’ miegobiyoŋ, goineji ‘Go Elaija fukege,’ miegobi eko goineji jikigaru iŋi miegobi, ‘Go kajeqouŋ ŋi raŋgbaŋine yoŋoreone mo fukege.’” ");
INSERT INTO mlh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Oŋu mikabi iŋi weu yareya, “Eme ŋoŋo-ŋaŋe nonde uruŋu migobi? Noŋ mo fukego?” Weu yareme Pitaji iŋi bokirieya, “Go Anuture Munaŋqoqo Rauine Kristo fukege.” ");
INSERT INTO mlh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Oŋu bokirieme fuŋine totogo mikabi moji egu maneiŋ ore agi sanaŋine ba yareya. ");
INSERT INTO mlh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuji kiŋariŋpuine fuŋgaru iŋi qaji yareya, “Sombuŋ kaere Ŋi foriine joiserereŋ kokoine maneiŋ. Kantrire minebobo, soriŋ gio siŋaŋ eme Kadi buŋore qaqaji yoŋoji ŋadi gaku qabi komeiŋ. Komeko una yokaomo tariko komegone pakereiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesuji buŋo oi so kesoŋgaru totogo miko Pitaji oo akoŋ poreru qaŋaŋineo raru fuŋgaru qomuku teya. ");
INSERT INTO mlh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Qomuku teme kirieru kiŋariŋpuine piki ŋone yaperu Pita qomuku iŋi ojiya, “Go buŋo manesuge, oi Anuture buŋo matayoŋ, moreŋ ŋiŋigo eru Satan aŋiyaŋuŋ. Ore eru Satan, go muŋambe yo nonde jiŋo maione use.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesuji ŋiŋigo kubu eme kiŋariŋpuine oŋga yareme warebi buŋo iŋi yajiya, “Moji nonde ŋadio wareiŋgo manega, iŋoji iŋoyoŋunde maŋ sakiinere aŋi sanaŋine sembene ŋadi gakume misombeŋ ebi joiserereŋ oi koboeine. Oi maripoŋgo komeiŋ ore so maneku karieru noŋ boyobe nuru wareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Moji gogoine iŋoyoŋunde sabareru iŋoyoŋunde aŋigo goga, iŋoji gogoine foriine kipeme jibugaiŋ. Jibugaiŋyoŋ, moji morende gogoine oi noŋ eru nonde Bobiaŋ Biŋenere eru kisiŋgaru kisiŋga nareiŋ, iŋoji gogo foriinere fuŋne bofukeru sanaŋgaru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Moji moreŋine moreŋine yoŋore yareya sosowo keku furugame biŋeine ra foreme mande gogoine ro jibugaru keoma goku komeme Anutuji buŋoine mitarime qoqotiineji sibirigame so sagaiŋ. Meboine oiji manjeri so roru oteiŋ. Mata yobu! ");
INSERT INTO mlh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Noŋuŋ sosowoji noŋunde due bakimiŋ ore embimbiŋgakimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ŋiŋigo kubuine kubuine damaŋ yoo moreŋgo bobojibu eru agiburaŋ goine eru goegobi. Moji yoŋore botugo nonde tina eru nonde Biŋe buŋo baru wakiiŋ, oi Sombuŋ eru morende Ŋi foriineji oŋuakoŋ ŋoneru takigaiŋ. Iŋoji jiki Sombuŋ mimerereŋ tiriine yoŋoke yo wakibi Mamainere kuririquraŋ ŋoneru popurebi iŋoji ŋi me ŋigo oŋuine ŋone yaberu taki yabeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Oŋu yajiru iŋi miya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Yo dimagobi, ŋoŋore botugone goine Anutuji qorumaŋine bofukeme usuŋineji fukeiŋ, oi ŋone mukunimiŋ. Gariine goku komere joiserereŋ so manebi oi fuke taniŋgako ŋonenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Una 6 tariko Yesuji Pita, Jeims eru Jon oga yaperu ŋiŋigo boke yaberu yoŋoyoŋe jikoŋ tuku joroine mogo roperu qotigo gobuŋ. Oo gobi jiŋo maiyaŋuŋgo dimako Yesure saki kamasiji qowirieru furuine fukeya. ");
INSERT INTO mlh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Marikuineji gbagbataeŋine kuririquraŋineke fukeya. Moreŋgo kambaŋ yagaŋine tinogunji (saife, omo) jureegobi, oi odureru yagaŋgaya. ");
INSERT INTO mlh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Oŋu fukeme Elaija eru Moses yokoji fuke yareru Yesuke buŋo mimane ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mimane ebi Pitaji fuŋgaru buŋo miku Yesu iŋi ojiya, “Sogunenoŋuŋ, niŋoji yo manjeri manegobeneŋ. Ore eru niŋoji soine ako yokaomo baki: Gore mo, Mosesre mo eru Elaijare mo.” ");
INSERT INTO mlh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kiŋariŋ yoŋoji gburugburu kokoine yabeme Pitaji “Uruŋu mibemiŋ?” miku buŋo baaya. ");
INSERT INTO mlh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Buŋo baaru dimako kuaŋ gbagbataeŋine kuririquraŋineke moji waki nokumuineji komoŋ yabeme ore maŋineone buŋo maru mo iŋi fukeme manebuŋ, “Ŋi yo nakene yoro made fukega. Ŋoŋo iŋore buŋo maneru goinebi.” ");
INSERT INTO mlh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Buŋo oi maneru pipa kirieru piku baaru yoyoka oi moke so ŋone yapebi Yesuji akoŋ yoŋoke dimaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tukuone pagaŋgo waki Yesuji iŋi mitiga yareya, “Ŋoŋo ya ŋonegobi, ore biŋe oi ŋiŋigo mo so yajiinebi. Qorumaŋ eru morende Ŋi foriineji komegone pakereme ore ŋadiineo oi soine mitaniŋgaku goinebi.” ");
INSERT INTO mlh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Oŋu mitiga yarekame kiŋariŋpuine yokaomo yoŋoji buŋo oi maŋyaŋuŋgo sabareku komegone papakarere buŋo ore fuŋine oi yoŋoyoŋe weweu eku mimane ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mimane eru Yesu iŋi weu tebuŋ, “Kadi buŋore qaqaji yoŋoji buŋo iŋi miegobi, ‘Kajeqouŋ ŋi Elaijaji Sombuŋgone bonieru waki fukeiŋ.’ Oi uruŋure miegobi?” ");
INSERT INTO mlh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Weu tebi kerisieru iŋi yajiya, “Elaijaji bonieru waki fukeru gogo sosowo bobiaŋgaiŋ. Buŋo oi foriine fukegayoŋ, buŋo mo yo wamore quraŋgabuŋ pega: ‘Qorumaŋ eru morende Ŋi foriineji joiserereŋ kokoine maneme mipemiriŋ enimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Buŋo yoyoka oi pegobireyoŋ, nonji iŋi ŋajibemiŋ: Elaijaji waki fukeyayoŋ, iŋore Biŋe buŋo quraŋgabi pega ore so ŋiŋigoji oi yoŋoyaŋunde aŋi boyoberu kosa etebuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu eru kiŋariŋ yokaomo yoŋoji tukuone waki kiŋariŋpuine goine yoŋoreo wareru ya iŋi ŋonebuŋ: Kadi buŋore qaqaji goineji dimaku yoŋoke migobobo eru noigoi buŋo mikabi ŋiŋigo kubu sogoji roregaru ŋone yaberu dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Oŋu dimaku ŋiŋigo kubu sosowo yoŋoji Yesu ŋoneru oo akoŋ popureru giniŋgaru bembeŋgo raru mijeriine mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mijeriine mikabi iŋi weu yareya, “Ŋoŋoji wamore yoŋoke migobobo eru noigoi buŋo migobi?” ");
INSERT INTO mlh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Weu yareme kubuyaŋuŋgone ŋi moji bokirieru iŋi ojiya, “Qaqaji, nonde made gemoji miine qojigaru noŋguŋ bame ogaru goreo warego. ");
INSERT INTO mlh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Iŋoji oo me oo roru yoyoworu poreru bokeme waki qaku miineone tiferuruine wakime miine kijaŋga sakiineo baporeega. Oŋu fukeme wareru gore kiŋariŋpugo karieru weu yareru gemo oi yobenimiŋ ore yajibeyoŋ, yoŋoji oi embimbiŋgagobi.” ");
INSERT INTO mlh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Oŋu ojime bokirieru ojiya, “Yei! Morende ŋiŋigo qoqomukuŋaŋuŋke. O damaŋ wojimu ŋoŋoke qatiŋ ŋaberu gogabe Anutu so manesiŋ gabuŋ joiserereŋ maneebemiŋ. Oi ogaru nondeo wareniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Oŋu miko ogaru iŋoreo warebuŋ. Warebi gemoji Yesu ŋoneru oo akoŋ made yoyoworu furu yoyou eteru farata eru poreru rondiŋgaru moreŋgo qaku suriŋsuriŋ kepiaru kaakeku akoŋ peko miineone tiferuruine waperu wakiya. ");
INSERT INTO mlh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesuji oi ŋoneru mamaine iŋi weu teya, “Damaŋ wojimure so kamasi yo fuke teru wapeya?” Weu teme miya, “Oi gbieineone akoŋ fuke teya. ");
INSERT INTO mlh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Oi bosembeiŋ ore ateine ateine misigo me obuo romaeŋgame damaŋ kokoine rakaru qaku qaki akoŋ eega. Oŋuyoŋ, oo usuŋine mo goreo pega ine, ŋonemaiŋ eru bapi nope.” ");
INSERT INTO mlh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Oŋu miko Yesuji ojiya, “Usuŋine mo goreo pega ine, mige. Anuture usunji yareya more ore so embimbiŋgaega. Moji Anutu manesiŋ gaiŋ, iŋoreo yareya fuŋne fuŋne soine fukeeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Oŋu ojime mamaineji oo akoŋ oŋgaku miya, “Anutu manesiŋ gagoyoŋ, mamanesiŋneji wiriine fukega. Mamanesiŋne basanaŋgaigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Miko ŋiŋigo jiŋoraraineji giniŋgaru warekabi ŋone yaberu ore eru gemo oi iŋi ojiya, “Go qepoŋ eru kajegi gemoine, nonji mitiga garego: Go ŋi yo bokeru waperu raru moke so kirieru wareigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Miteme oŋgaku jojoraku made oi yoyoworu pipa furu yoyou eteru furugame ketuŋgaru waperu raya. Waperu rako qoŋgbuŋ ore so fukeru peko kokoineji oi ŋoneru “Nakafeine tariga!” mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Oŋu mibiyoŋ, Yesuji meineo roru bopeŋgame pakereru dimaya. ");
INSERT INTO mlh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Oŋu dimako Yesuji pi maŋineo ropeko kiŋariŋpuineji yoŋoyaŋekoŋ ŋeku iŋi weu tebuŋ, “Niŋoji wamore oi niŋonoŋe akoŋ yobeiŋgo ore embimbiŋgagobeneŋ?” ");
INSERT INTO mlh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Weu tebi iŋi yajiya, “Gemo kamasiine oŋuine oi oŋga wosiru uqo sowo goku soine yobekimiŋ. Ya furuine mo ebeneŋ so waperu raiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesuji kiŋariŋpuine yoŋoke kae moreŋ oi bokeru raru Galili prowins maŋineo roregaru wamo kaeo gobuŋ, oi moji maneiŋ ore takigaya. ");
INSERT INTO mlh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Oi takigako kiŋariŋpuine qaji yareiŋgo ore sumuŋgaru rabuŋ. Kadio raru buŋo koruŋ iŋi yajiya, “Anutuji Sombuŋ eru morende Ŋi foriine oi moreŋ ŋiŋigo yoŋore meo ruame rakaiŋ. Rakame oi qabi komeiŋ. Oi qabi komeme yaŋgabi una yokaomo fukeko komegone pakereiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Buŋo koruŋ oŋu yajiyayoŋ, oi so mane taniŋgabuŋ eru fuŋine uruŋu, oi weu teiŋgo ore fogaturuŋ ebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Oŋu raru Kaperneam taoŋgo wapebuŋ. Oo waperu iŋoyoŋunde pi maŋineo roperu kiŋariŋpuine iŋi weu yareya, “Ŋoŋo kadio wareru wamo buŋo mimane ebi?” ");
INSERT INTO mlh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yoŋoji kadio wareru “Moji ropekiine fukega?” miku oi yoŋoyaŋekoŋ mimane eku warebuŋ. Ore eru weu yareme buŋoyaŋuŋ bokeru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Buŋo bokeru ŋekabuŋ Yesuji rakaru ŋeku kiŋariŋpuine 12 oga yabeme warebi iŋi yajiya, “Moji ropekiine goiŋ ore maneiŋ ine, iŋoji sosowo ŋoŋore mea yukuyaŋuŋgo wakiqoqoine fukeru goine sosowo kiŋaŋ qayareeine.” ");
INSERT INTO mlh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Oŋu yajiru made menda mo roru botuyaŋuŋgo ruame dimaya. Dimako meineo roru quineo ruaru iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Moji made menda yo oŋuine mo nonde tinao piineo keporeru siŋaŋ gaku maŋgo eteiŋ, iŋoji noŋ kepore nuiŋ. Moji oŋu enareiŋ, iŋoji noŋ akoŋ matayoŋ, mo sore nuya, oi oŋuakoŋ keporeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jonji Yesu iŋi ojiya, “Qaqaji, niŋoji ŋi mo noŋuŋke so roregaega, iŋoji gore tinao gemokaku yobe yabeme ŋonebeŋ. Iŋoji niŋoke so qakatoru goega ore eru niŋo oi qomuku tebeŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Oŋu ojime Yesuji miya, “Oi so qomuku teinebi. Moji nonde tina miku mosi qoqowirie ega, iŋoji ore ŋadiineo nonde ŋadiqoqo buŋo afaine miiŋgo ore embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Moji so qomuku noreega, iŋoji noŋunde buruo goga. (Ore eru nonde ogopune goine oi igosisi so eyareinebi.) ");
INSERT INTO mlh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Oi kitiŋ yabebi Anutuji ore furiine yareiŋ. Moji Kristore tinao iŋore biŋe fukegobi ore eru obu popu nonimiŋ ore yareiŋ, Anutuji ore furiine bokirie teiŋ. Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Kitiŋ ŋabenimiŋ, yoŋoji furiine ronimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesuji buŋo iŋi miya, “Odumade yo oŋuine manesiŋ nugobi, moji yoŋoreone mo mauŋgaine eteme agiburaŋ baiŋ, ŋi oi yobiŋ ropekiine bofukeiŋ. Anutuji yobiŋ ore geoine uruŋu oteme soineo fukena? Karoŋaŋ oŋgiŋ ubeineo kiperu koe botuineo bokebi bodugame egu rakaiŋ, oi afaine fuke teme kamasi fukena. ");
INSERT INTO mlh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ore eru megoji agiburaŋ baiŋgo ore mauŋgaine egareiŋ ine, oi ketigaru boke. Ketigaru bokeru meti goku gogo sanaŋine bofukeru igoriŋ bofukemiŋyoŋ, mego yoyokake goku jiki misi korugo egu rakamiŋ. Koru misiine oi damaŋ mogo so kobeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Oo ‘Umbenji sakiyaŋuŋ igoqomuruŋ raru wapekabuŋ so komenimiŋ eru misiyaŋunji damaŋ mogo so kobeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Oŋuakoŋ kufugoji agiburaŋ baiŋgo ore mauŋgaine egareiŋ ine, oi ketigaru boke. Ketigaru bokeru kufuti goku gogo sanaŋine bofukeru igoriŋ bofukemiŋyoŋ, kufugo yoyoka gokande misi korugo bokebi egu rakaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Oo ‘Umbenji sakiyaŋuŋ igoqomuruŋ raka wapebi so komenimiŋ eru misiyaŋunji damaŋ mogo so kobeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Oŋuakoŋ jiŋogoji agiburaŋ baiŋgo ore mauŋgaine egareiŋ ine, oi unugaru boke. Unugaru bokeru jiŋogo moakoŋke goku Anuture qorumaŋgo roperu igoriŋ bofukemiŋyoŋ, jiŋogo yoyokake gokande misi korugo bokebi egu rakamiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Oo ‘Umbenji sakiyaŋuŋ igoqomuruŋ raka wapebi so komenimiŋ eru misiyaŋunji damaŋ mogo so kobeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Misi koru oo ŋiŋigo sosowo oi seki oŋuine misi borunji riga yabebi joiserereŋ manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Seki oi fiine fukegayoŋ, sekiji aŋiine bokeiŋ ine, oi uruŋu bobiaŋgabi aŋiine moke fukena? Ŋoŋo oŋuakoŋ maŋmoakoŋ gogore aŋi egu bokenobuŋ. Ore eru Sombuŋ sekiyaŋuŋ egu bokenobuŋ ore siŋaŋ-ŋaŋuŋ baku botuŋaŋuŋgo womo qoqo eeku goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuji pakereru Kaperneam kae bokeru Jordan obu petigaru aribe raru boyoberu waki moke obu oi petigaru Judia prowinsgo wareya. Warekame ŋiŋigo kubu sogoji moke iŋoreo tumaŋgabi eku goya, ore so moke qaji yareya. ");
INSERT INTO mlh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Qaji yareme Farisi (Kadi buŋore yameŋyameŋ) goineji iŋoreo wareru buŋore buduŋgo furuganimiŋ ore esoigaru iŋi weu tebuŋ, “Ŋiji ŋigoine bokeiŋ ine, oo Kadi buŋo odureiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Weu tebi bokirieru iŋi yajiya, “Mosesji ore buŋo uruŋu mitiga ŋareme pega?” ");
INSERT INTO mlh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Oŋu yajime iŋi ojibuŋ, “Ŋiji boboke eere papia quraŋgaru ŋonuŋine soine bokeiŋ. Mosesji oŋu mitigame pega.” ");
INSERT INTO mlh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Oŋu ojikabuŋ iŋi yajiya, “Iŋoji maŋyaŋuŋ sanaŋinere eru mimiti oŋu quraŋga yareya. ");
INSERT INTO mlh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Quraŋga yareyayoŋ, Anutuji fuŋfuŋgaineo yareya sosowo bofukeya, damaŋ oo akoŋ ‘Ŋi eru ŋigo gonimiŋ ore bofuke yabeya. ");
INSERT INTO mlh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ore eru ŋiji maŋgo mamaine boke yaperu ŋonuŋinereo raku qakotame ");
INSERT INTO mlh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yokoji saki moakoŋ fukeru gonimi. Oŋu fukeru jikigaru yoyoka so fukegobireyoŋ, saki moakoŋ fukeru gonimi. ");
INSERT INTO mlh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anutuji ŋi eru ŋigo qodure yapeya, ŋiŋigo moji oi so boroiŋ yapeine.’” ");
INSERT INTO mlh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesuji oŋu miyareru pi maŋineo ropeko kiŋariŋpuineji buŋo ore moke weu tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Weu tebi iŋi yajiya, “Ŋi moji ŋonuŋine yoberu ŋigo mo roiŋ, iŋoji jikiboti boesau baiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Oŋuakoŋ ŋonuŋ moji ŋoeine yoberu ŋi mo roiŋ, iŋoji jikiboti boesau baiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ŋiŋigo goineji odumade memendaine oga yaberu Yesuji boua yabeiŋ ore iŋoreo warebuŋyoŋ, kiŋariŋ yoŋoji ŋiŋigo oi miqomuku eyarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Oŋu ebuŋyoŋ, Yesuji oi ŋoneru maŋine sembeako iŋi yajiya, “Odumade mendaine oi boke yabebi nondeo wareinebi. Anutuji ŋiŋigo oŋuine oi qorumaŋine biŋe qa yareiŋ. Ore yoŋo so kipe yabeinebi. ");
INSERT INTO mlh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Moji Anuture qorumaŋ oi odumade oŋuine biŋe so qa yareiŋ, iŋoji ore maŋineo ropeiŋgo embimbiŋgaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Oŋu miku quineo rua kobo yaberu meine qoruyaŋuŋgo ruaru mifia yareya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesuji fuŋgaru kadi raiŋgo eko ŋi moji giniŋgaru iŋoreo wareya. Wareru maŋfuŋineo rakaru dikanji keru iŋi weu teya, “Qaqaji fiine, nonji uruŋu eku gogo sanaŋine biŋe fukenobo?” ");
INSERT INTO mlh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Weu teme iŋi ojiya, “Nonde ‘Qaqaji fiine,’ oi wamore mige? Anutu moakonji fiine fukega. Ŋi moji oi oŋuine fiine so fukega. ");
INSERT INTO mlh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Go mimipaŋ buŋo yo mane forege: ‘Mo so qande komeine. Boesau so baigoŋ. Ya kiaŋ so roigoŋ. Migoiga so eteigoŋ. Kigaku kiaŋ so roigoŋ. Maŋgo mamago araŋ ba yateeigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Oŋu ojime maneru iŋi miya, “Qaqaji, oi sosowo jeŋoŋneone reŋgaru go wapeboŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Oŋu miko Yesuji piku ŋoneru maŋ wombuŋineji manjoko eteru iŋi ojiya, “Go ya moakonde embimbiŋgage: Go raru mebogo sosowo furiine banimiŋ ore ruande moneŋ wareme ŋiŋigo wakiqoqoine yareigoŋ. Oŋu ruande mebo yago soguine yobu (milyon Kina ore so) oi Sombuŋ kaeo pe gareiŋ. Oŋu eku noŋ boyobe nuru ware.” ");
INSERT INTO mlh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesuji oŋu ojiyayoŋ, meboine kokoine peya ore eru buŋo oi maneru maŋine posoeme beusembe maneru omaine bokeru raya. ");
INSERT INTO mlh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bokeru rako Yesuji pime ra wareme kiŋariŋpuine iŋi yajiya, “Oyei! Ŋiŋigo moneŋ meboyaŋuŋke yoŋoji Anuture qorumaŋgo ropeiŋgo ore yobiŋgaru qiqu kenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Oŋu yajime kiŋariŋ yoŋoji oi maneru waragabuŋyoŋ, Yesuji jikigaru iŋi yajiya, “Qomopune, ŋiŋigo uri yoŋoji moneŋ meboyaŋuŋ manesiŋ gaegobi, yoŋoji Anuture qorumaŋ maŋineo ropeiŋgo ore yobiŋgaru qiqu kenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Oi iŋi mitaniŋgabemiŋ: Joma yasogo kamel oi buŋi kimboŋineo soine so ropeiŋ. Ore so ŋiŋigo biŋeroroyaŋuŋke yoŋoji Anuture qorumaŋ maŋineo ropeiŋgo ore yobiŋgaru embimbiŋganimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Oŋu yajime maneru popureru waragaru yoŋoyaŋunde iŋi mibuŋ, “Opopoŋ! Ŋiŋigo moji Sombunde biŋe fukena?” ");
INSERT INTO mlh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Oŋu mibi Yesuji piki ŋone yaperu iŋi miya, “Ŋiŋigoji oi eesoi baku quŋgaru embimbiŋgaegobiyoŋ, Anutuji oŋu so baega. Anutuji ya sosowo soine baega. Iŋoji ya mo baiŋ ore so quŋgaru embimbiŋgaega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pitaji buŋo oi maneru bokirieru Yesu iŋi ojiya, “Mane, niŋoji yareya sosowo bokeru go boyobe guru warebeŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Oi maneru Yesuji iŋi ojiya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Moji nonde eru Bobiaŋ Biŋere eru ya mo bokeya, oi soriŋ piine, kakagboine, seŋ baŋaine, maŋgo mamaine, odumadeine me gio teniŋine oi boke yabeko Anutuji ore furiine odureru bokirieru oteme saueiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Moji ya oi bokeya, Anutuji furiine oi 100:re so jikigaru oteme iŋoyoŋunde biŋe fukeiŋ. Morende gogoo kekesuesue maŋineo goiŋyoŋ, soriŋ pi, kaka gbo, seŋ baŋa, maŋgo mama, odumade eru gio teniŋine oi tifeineo fuke teiŋ eru damaŋ jikiineo gogo tatariine tomiri ore biŋe fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Oŋu fukeiŋyoŋ, ropekiine ŋoŋoreone kokoineji wawakiine fukenimiŋ eru wawakiine yoŋoreone kokoineji ropekiine fukenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesuji kiŋariŋpuine yoŋoke Jerusalem sitio ropeiŋgo ore moreŋ kadi rabuŋ. Yesuji bonieru rako kiŋariŋpuineji ŋadiineo raru waragabuŋ eru ŋiŋigo ŋadiyaŋuŋgo warebuŋ yoŋoji kokoi manebuŋ. Oŋu ebi Yesuji kiŋariŋpuine 12 oi moke furu yaberu fuŋgaru qaji yareya. Iŋoreo ya fukeiŋ, buŋo oi mitaniŋgaku iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Maneniŋ, noŋuŋ Jerusalem ropekimiŋ. Oo moji Qorumaŋ eru morende Ŋi foriine babae bame soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋore meo rakaiŋ. Yoŋoji komeinde buŋo mitariru kotu gawman yoŋore meo ruanimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ruabi igosisi eneku tifegaru qaku ŋoŋoru joruinekeji qotimberu qotibotiganimiŋ. Qotimberu qotibotigaku qabi komeiŋ. Komeru una yokaomo oo komegone pakereiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yesuji oŋu yajime Zebedire madeyoka Jeims eru Jon yokoji iŋoreo raru iŋi ojibu, “Qaqaji, nikoji ya more karieru weu garegobere, oi notemiŋ ore manegobere.” ");
INSERT INTO mlh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ojibire weu yateya, “Ŋokoji wamo ya eŋatebemiŋ ore manegobire?” ");
INSERT INTO mlh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Weu yateme iŋi ojibu, “Goji soine mitigande niko gore kuririquraŋgo paibe roperu moji me furogoo eru moji me kijogoo ŋeku ya sosowo siŋaŋ ganobeŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Oŋu ojibuyoŋ, Yesuji iŋi yasiya, “Ŋokoji ore fuŋine so mane mukuku kariegobire. Nonji popu jajaineke nobemiŋ, ŋokoji oi soine noku joiserereŋ manenimi me mata? Fobu jonji rau narenimiŋ, ŋokoji oi ronimi me mata?” ");
INSERT INTO mlh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yasime maneru mibu, “Oi soine ronomi.” Mikabire iŋi yasiya, “Oi foriine. Nonji popu jajaineke nobemiŋ, ŋokoji oi oŋuakoŋ nonimi eru fobu jonji rau narenimiŋ, oiji ŋoko oŋuakoŋ rau ŋatenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ŋa tenimiŋyoŋ, nonde me furoneo me kijoneo moji ŋeiŋ, nonji buŋo oi mitigabemiŋ ore so mata. Anutuji ŋeŋe yoyoka oi uri yokore bomogaya, oi yokore yateme noke ŋeku ya sosowo siŋaŋ gaekimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jeims Jon yokoji oŋu kariebu ogopuyakuŋ 10 yoŋoji oi maneru fuŋgaru maŋsembe manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Oŋu manebuŋyoŋ, Yesuji oga yabeme warekabi iŋi yajiya, “Morende kantriine kantriine yoŋore muraŋpuji siŋaŋ yabenimiŋ ore migobi, yoŋoji ŋi koito kamasi bayabeegobi. Yoŋore soguneyaŋunji buŋo mitigaku ŋiŋigo botiŋ yaberu usuŋyaŋuŋ yaduegobi. Ŋoŋo fuŋneyaŋuŋ oi soine manegobi. ");
INSERT INTO mlh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ŋoŋore botugo mosi oŋuine egu fukeiŋyoŋ, moji ŋoŋore botugo soguneŋaŋuŋ fukeiŋ ore manega, iŋoji kiŋaŋ qaŋareku goine. ");
INSERT INTO mlh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Oŋuakoŋ moji ŋoŋore botugo ropekiine goiŋgo manega, iŋoji sosowo ŋoŋore mea yukuo goku kiŋaŋqoqoŋaŋuŋ omaine fukeine. ");
INSERT INTO mlh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sombuŋ eru morende Ŋi foriineji oŋuakoŋ mosi oŋuine yadume iŋoyoŋe kiŋaŋ qatenimiŋ ore eru so wakiyayoŋ, kiŋaŋ qayareku ŋiŋigo sosowo yoŋore due baiŋ ore eru wakiru gogoine kisiŋgaru bokeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesuji kiŋariŋpuine yoŋoke Jeriko sitio warebuŋ. Wareru siti oi bokeiŋgo ore ebi ŋiŋigo kubu sogoji boyobe yabeku ŋadiyaŋuŋgo warebuŋ. Oŋu warebi jiŋokombi ŋi tinaine Bartimeus, Timeusre made iŋoji moneŋ eru uqo otenimiŋ ore karieru weu yareru kadi qaŋaŋineo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ŋeko “Nazaret ŋi Yesu warega,” mikabi maneru fuŋgaru iŋi oŋgaya, “Yesu Deiwidre osigida, gonji ŋonemaiŋ enare!” ");
INSERT INTO mlh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oŋu oŋgame kokoineji buŋo bokeru ŋeiŋgo ore qomuku nebuŋyoŋ, iŋoji yameŋ keku oŋgaya. “Deiwidre osigida, goji ŋonemaiŋ enare!” ");
INSERT INTO mlh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Oŋgame Yesuji maneru ode niniŋgaru iŋi miya, “Soine ojibi yoo wareine.” Oŋu miko jiŋokombi ŋi oi oŋgaku iŋi ojibuŋ, “Gore oŋgaga. Ore eru manemejago bokeru pakereru ware.” ");
INSERT INTO mlh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Oi maneru marikuine qomukuru bokeru farata pakereru dimaku Yesureo raya. ");
INSERT INTO mlh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Rako iŋi weu teya, “Ogone, nonji wamo ya egarebemiŋ ore manege?” Oŋu weu teme jiŋokombi ŋiji ojiya, “Sogunene, noŋ jiŋone moke piiŋgo manego.” ");
INSERT INTO mlh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Oŋu miko Yesuji iŋi ojiya, “Mamanesiŋgoji bobiaŋ guga. Go soine raigoŋ.” Oŋu ojime jiŋo koruŋ oo akoŋ tiŋame piku ŋadiyaŋuŋgo Yesu boyoberu raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesuji kiŋariŋpuine yoŋoke Jerusalem siti bombeŋgaru Betfage eru Betani kae yoyoka maŋfuŋyakuŋgo wareru Oliwe yo tukuo roperu kiŋariŋyokaine yoyoka sore yabeiŋ ore eru ");
INSERT INTO mlh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","iŋi yasiya, “Kae maŋfuŋyaŋuŋgo ŋega, oo rani. Raru oo roperu doŋgi mendaine niginji kipebuŋ dimaga, oi oo akoŋ bofukenimi. Oi doŋgi usuŋgari, ŋi moji paiineo so ŋekiine. Oi pirueru ogaru yoo warenimi. ");
INSERT INTO mlh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Piruebire moji ‘Wamore oŋu egobire?’ miku weu ŋateme iŋi ojinimi, ‘Ofoŋnokunji ore embimbiŋgaru miko waregobere damaŋ so joroko moke bokirieme wareiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Oŋu yasiru sore yapeme raru doŋgi usuŋgariine kadi qaŋaŋineo pi more mendi maŋfuŋineo niginji kipebuŋ dimako bofukeru piruebire. ");
INSERT INTO mlh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Piruebire ŋi goine oo dimabuŋ, yoŋoji ŋone yaperu iŋi weu yatebi, “Hei, uruŋu eŋgone doŋgi mendaine piruegobire?” ");
INSERT INTO mlh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Oŋu weu yatebi Yesuji yasiya ore so mibire maneru “Soine ogagaru rainebire,” mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mibi ogaru Yesureo warebire marikuyaŋuŋ qomukuru doŋgi mendainere paiineo ruabi roperu ŋeya. ");
INSERT INTO mlh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Oŋu ŋeku rako ŋiŋigo jiŋoraraineji araŋ bateku marikuyaŋuŋ qomukuru kadi soguineo ramegabi goineji moreŋ rondiŋgo raru yo rekaine bajiru ramegabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ramegabi ŋiŋigo bonieru keporeru rabuŋ eru ŋadiineo boyoberu warebuŋ, yoŋoji iŋi miku oŋgabuŋ, “Hosana! Ohowe ohowe! Anutu miteŋ gagobeneŋ. Ofonde tinao wareiŋ, Anutuji oi mifia teine. ");
INSERT INTO mlh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ŋasonoŋuŋ Kiŋ Deiwidji kantri guriŋ baku siŋaŋ yabeya, damaŋ oŋuineji moke ware norega. O Anutu kantri gurimbobonoŋuŋ mifiaine. Hosana! Biŋerorogo miteŋ gagobeneŋ paibere paibe ropeine. Ohowe ohowe!” ");
INSERT INTO mlh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Oŋu oŋgabi Jerusalem sitio roperu boji sorinde jokoroŋ maŋineo raya. Oo roregaru yareya sosowo ŋoneme kae ubu eme waki kiŋariŋpuine 12 yoŋoke soriŋ bokeru Betani kaeo raru pebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Peru kae fufurere akoŋ pakereru kiŋariŋpuine yoŋoke Betani kae bokeru rabi Yesuji uqore komeya. ");
INSERT INTO mlh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Uqore komeru pime rako fig yo mo rekaineke dimako ŋoneya. Ŋoneru “Rekaine maŋineo foriine ŋeko bofukeru nonobo,” miku fig yore fuŋneo raya. Rayayoŋ, foriinere damaŋineji so bembeŋgaya ore rekaine sowo dimako ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Oŋu ŋoneru yo oi iŋi ojiya, “Moji forigo moke so noine.” Oŋu ojime buŋo oi kiŋariŋpuineji manebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Raru goku Jerusalem sitio ropebi Yesuji boji sorinde jokoroŋ maŋgo raya. Oo ŋiŋigo ŋone yabekame mebo furiine banimiŋ ore ruabi furiine babuŋ, oi fuŋgaru yobe yabeme wakibuŋ. Moneŋ nareŋgareŋ ŋiŋigo yoŋore ŋeŋeyaŋuŋ romaeŋgaru kerisieme rabuŋ. Oŋuakoŋ kabu furiyaŋuŋ banimiŋ ore ebuŋ, yoŋore ŋeŋe oi oŋuakoŋ ketuŋgame rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kae jiŋo kubaine petigaru ya deru rope waki ore kadiine oi kipeya. ");
INSERT INTO mlh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Oŋu eku qaji yareru iŋi yajiya, “Aisaiaji buŋo mo iŋi quraŋgame pega, ‘Nonde sorinji moreŋine moreŋine sosowo yoŋore oŋgawowosi pi fukeiŋgo ore miinebi.’ Buŋo oi pegayoŋ, ŋoŋoji oi igokogabi suroŋqoqo ŋi yoŋore kouŋ oŋuine fukega.” ");
INSERT INTO mlh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Oŋu yajime ŋiŋigo kubu sosowo yoŋoji ore eru meayaŋuŋ mukume waragabuŋ. Ore eru soriŋ gio siŋaŋ eru kadi buŋore qaqaji yoŋoji oi maneru Yesure kokoi maneru mimane eku iŋi mibuŋ, “Oi uruŋu mikabeneŋ qabi komena?” ");
INSERT INTO mlh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kae ubu eko Yesuji kiŋariŋpuine yoŋoke siti bokeru sakibe raru pebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Peru kae fufurere akoŋ pakereru kadio raru fig yo oi odureiŋgo ore eku yo oi ŋonebi goduineke ŋeririkeru dimaya. ");
INSERT INTO mlh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dimako Pitaji Yesure buŋo manesuku iŋi ojiya, “Sogunene ŋone, fig yo qaisogameŋ, oi bio gbaŋiru dimaga.” ");
INSERT INTO mlh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ojiko Yesuji iŋi botikieya, “Anutu mamanesiŋ oi basanaŋgaru goinebi.” ");
INSERT INTO mlh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ, “Moji buŋore foriine fukeiŋ ore maŋyoka so maneru tuku yoore rauinere iŋi mitigana, ‘Go tuku yo qomukuru pakereru raru koego rua.’ Oŋu mitigaku Anutu manesiŋ gako foriine ore so fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ore eru nonji iŋi ŋajibe maneniŋ: Wamo yare weu oŋga wosinimiŋ, oi sosowo biŋe qoqo eforegobeneŋ, oi manesiŋ gabi biŋeŋaŋuŋ fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ŋoŋo dimaku Anutu oŋga wosibi moji ogoinere kekesiine ore maŋsembe maneiŋ ine, kekesiine oi bokeinebi. Oŋu enimiŋ ine, ŋoŋore Mamaŋaŋuŋ Sombuŋ kaeo goga, iŋoji oŋuakoŋ ŋoŋore agiburaŋ-ŋaŋuŋ bokeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Ŋoŋo goine yoŋore agiburaŋ so bokenimiŋ ine, ŋoŋore Mamaŋaŋuŋ Sombuŋ kaeo goga, iŋoji oŋuakoŋ ŋoŋore agiburaŋ-ŋaŋuŋ so boke ŋareiŋ.)” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesuji kiŋariŋpuine yoŋoke moke Jerusalem sitio ropebuŋ. Roperu boji sorinde jokoroŋ maŋgo raru wareme soriŋ gio siŋaŋ, kadi buŋore qaqaji eru kantrire minebobo goine yoŋo iŋoreo wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Waperu iŋi weu tebuŋ, “Go yo ya ege, oi moji mitiga gareme baege? Oi bamiŋ ore usuŋine oi moji gareya?” ");
INSERT INTO mlh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Weu tebi iŋi bokirie yareya, “Nonji oŋuakoŋ buŋo mo weu ŋarebemiŋ. Oi kerisie narebi nonji oŋuakoŋ moji usuŋ nareme yareya yo baego, oi ŋajibemiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonji ŋiŋigo miti meso rau yareru goya, iŋoji ore usuŋine oi urone roya? Sombuŋ Rauineji oteya me moreŋ rauineji otebuŋ? Oi bio najiniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Oŋu bokirie yareme botuyaŋuŋgo mimane eku iŋi mibuŋ, “‘Usuŋineji Sombuŋgone fukeya,’ oŋu mikimiŋ ine, iŋoji iŋi miiŋ: ‘Ŋoŋoji wamore Jon so manesiŋ gabi?’ Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Me ‘Moreŋ ŋiŋigo yoŋoreone fukeya,’ minobeŋ? Oi so sagaga.” Ŋiŋigo sosowoji Jonde ‘Fofori kajeqouŋ ŋi fukega,’ mibuŋ ore eru ŋiŋigo kubu yoŋore kokoi maneru oi miiŋgo embimbiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ore eru “Oi so manegobeneŋ,” bokiriebuŋ. Oŋu bokiriebi Yesuji iŋi yajiya, “Oŋu eru nonji oŋuakoŋ yareya yo baego ore usuŋine moji nareya, oi so ŋajibemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuji fuŋgaru ŋiŋigo soso buŋo iŋi yajiya, “Ŋi moji wain nigiŋ gio mo keku sariya. Kesari eku saine baku roregaya. Baku roregaru wain jua soguine koji baya. Oo wainde foriine ruaru kufuji odebi obuineji roruŋgo rakaya. Wain jua soguine oi baku wain kiaŋ egu ronimiŋ ore siŋaŋ bobo koro joroine rouŋineke baya. Ya sosowo baforeru wain gio siŋaŋ goine bofuke yaberu iŋi yajiya, ‘Ŋoŋo gio baku foriinere mobe ŋoŋo-ŋaŋe roru mobeine rauine noŋ nareinebi.’ Oŋu mikiperu gio oi meyaŋuŋgo ruaru boke yaberu kantri mogo raru goya. ");
INSERT INTO mlh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Goku gome foriine gumuŋgaya ore damaŋine (gosa 5) qondiŋgaya oo kiŋaŋqoqoine mo soreme siŋaŋ yoŋoreo raru wain gio foriinere mobeine otenimiŋ ore miya. ");
INSERT INTO mlh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Miyayoŋ, siŋaŋ yoŋoji oi roru nigiŋgaru kobinji qaku yobebi metariŋ kirieya. ");
INSERT INTO mlh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ore ŋadiineo kiŋaŋ ŋi mo soreme yoŋoreo rako qoruine qopogaru mimi qaqa etebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ore ŋadiineo kiŋaŋ ŋi mo moke soreme rako qabi komeya. Oŋuakoŋ ŋi goine kokoine sore yabeme goine kobinji darijombuŋ yaberu goine yabebi komebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Oŋu ebi wain gio rauineji buŋo baaru miya, ‘Nakunde yoro made moakoŋ iŋoji akoŋ goga. Iŋo araŋ ba tenimiŋ me uruŋu?’ Oŋu miku tatariine oŋu madeine soreme yoŋoreo raya. ");
INSERT INTO mlh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Rayayoŋ, wareme ŋoneru botuyaŋuŋgo iŋi mibuŋ, ‘Iŋoji meropuine yoore rauine fukeiŋ. Ayo, bio roru qabeneŋ komeko wain nigiŋ gio yoji noŋunde biŋe fukeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Oŋu miku qafagaru roru nigiŋgaru qabi komeko qoŋgbuŋine gio dobu sakibe igogabi rakaya. ");
INSERT INTO mlh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Wain gio rauineji oi maneru uruŋu eiŋ? Iŋoji iŋoyoŋe wareru gio siŋaŋ yoŋo ketotie yabeiŋ eru gio siŋaŋ gariine bofuke yaberu wain nigiŋ gioine oi yoŋore meo ruaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Biŋe Quraŋgo buŋo yo osebuŋ me mata? ‘Pi bobo yoŋoji ko otuŋ mo ŋadi gaku omaine bokebi ŋeya, oiji otuŋ sanaŋine fukeme bofukebuŋ. Oiji kerigame piji kerigaru wakiiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ofonji otuŋ oi bofeŋgame jiŋonoŋunji ŋonebeŋ tinabiŋeineke fukeme waragaegobeneŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesuji oŋu yajime siŋaŋ yoŋoji buŋo ore fuŋine mane taniŋgaru iŋi mibuŋ. “Soso buŋo oi niŋore miga.” Ore eru iŋo roru nigiŋgaiŋgo manebuŋyoŋ, ŋiŋigo kubu sogo yoŋore kokoi maneru embimbiŋgaru bokeru rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Juda minebobo yoŋoji Farisi eru gawana Herodre pati ogopuine goine sore yaberu iŋi yajibuŋ, “Ŋoŋo Yesureo raru weu teru buŋore buduŋgo poreru nigiŋganiŋ.” Oŋu yajibi Yesureo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yesureo wareru iŋi ojibuŋ, “Qaqaji, goji ŋi foriine fukege, niŋo oi manegobeneŋ. Goji ŋiŋigo goine so ŋone aŋi eyareku goine so igo yabeegeyoŋ, so moakonji osoe nobeege. Ore ure gubi so kasigaru soguine so komoŋ yabeegeyoŋ, Anuture kadi oi buŋo foriine boyoberu qaji noreege. Goji Anuture buŋo poretiŋ oiji ropekiine eru wakiqoqoine moko akoŋ sosowo mitiŋ nobeege. Ore eru niŋo sisa-kiŋ iŋore takis ruaru oo Mosesre Kadi buŋo ririkimiŋ me mata? Oi ruabeneŋ sagaga me mata?” ");
INSERT INTO mlh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Oŋu ojibi buruyaŋuŋ ikoine oi mane mukuru iŋi yajiya, “Ŋoŋo wamore buŋore buduŋgo rua nunimiŋ ore esoi nugobi? Soine silwa moneŋ mo baru warebi ŋonebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Oŋu yajime oi baru warebi iŋi weu yareya. “More sasako eru tina oi yo quraŋgabi pega?” “Oi Sisa-kiŋ koitore.” Oŋu kerisieru mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mibi iŋi yajiya, “Oŋu fukeme ya Sisa-kiŋ koitore sasakoke oi iŋore biŋe oteeinebi. Ya Anuture sasakoke pega, oi Anuture biŋe oteinebi.” Oŋu yajime iŋore kokoine waragabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusi (Soriŋ giore yameŋyameŋ) yoŋoji “Komebuŋ, yoŋoji so pakerenimiŋ,” miku gobuŋ. Yoŋoreone goineji Yesureo wareru iŋi weu tebuŋ, ");
INSERT INTO mlh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Qaqaji, Mosesji iŋi mitiga noreme pega, ‘Ŋi mo ŋigo rome odumade so fukebi komeme kojeine mo bokeme gboineji soine kojeine iŋo baku gariine bofuke teme kakainere tina roru goiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Mane! Damaŋ mogo kaka gbo 7 gobuŋ. Kakayaŋuŋ boboniji ŋigo roru goku gariine tomiri mo goku komeya. ");
INSERT INTO mlh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Komeko gboineji kojeine oi roru goku oŋuakoŋ gariine tomiri mo gogu komeya. Komeko gboine mo iŋore ŋadio oiji ŋigo iŋo akoŋ roru goku komeya. ");
INSERT INTO mlh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Oŋuakoŋ kaka gbo 7 sosowo yoŋoji ŋigo moakoŋ oi roru gariine tomiri goku kome forebuŋ. Sosowo komebi tatariine kojeyaŋuŋ iŋoji oŋuakoŋ komeya. ");
INSERT INTO mlh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Goji ‘Komebuŋ, yoŋoji gboreru pakerenimiŋ,’ migeyoŋ, niŋo oi so manesiŋ gagobeneŋ. Mane, ŋi 7 sosowo yoŋo sogokoŋ pakerenimiŋ ine, ŋigo moakoŋ oi ŋonuŋyaŋuŋ robi goya ore eru more ŋonuŋine fukena?” ");
INSERT INTO mlh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Oŋu weubuŋ Yesuji kerisieru iŋi yajiya, “Ŋoŋo buŋo mijibugagobi. Maŋkekerisiere Biŋe Quraŋine eru Anuture usuŋine so mane mukugobi ore tiŋtuŋ eegobi. ");
INSERT INTO mlh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Foriine, komegone pakereru damaŋ oo ŋoe ŋonuŋ so fukenimiŋyoŋ, mimerereŋ yoŋoji Sombuŋ kaeo gobuŋ oŋuine fukeru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Maneniŋ! Komebuŋ, yoŋoji gboreru pakareniminde buŋoine oi Mosesre Buk maŋgo iŋi pega: Qiŋambu didiineo misi boruŋ fukeru so jotigaya, ŋoŋo binaŋ oi osebuŋ me mata? Anutuji oo Moses iŋi ojiya, ‘Nonji Anutu Abrahamde Ofoŋ, Aisakre Ofoŋ eru Jeikobre Ofoŋ goku fuke waperu gogo.’ ");
INSERT INTO mlh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“Ŋaso fuŋgbodu yokaomo yoŋoji Anutuke goku sanaŋgaru ropenimiŋ. Anutuji komekiine yoŋore Ofoŋyaŋuŋ matayoŋ, gogo sanaŋine gobuŋ, yoŋore Ofoŋyaŋuŋ fukega. O Sadusi (Soriŋ giore yameŋyameŋ pati) ŋoŋo buŋo kokoine mane jibugaegobi.” Oŋu bokirieya. ");
INSERT INTO mlh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yesuji Sadusi (Soriŋ giore yameŋyameŋ) yoŋoke mimane eku mijakieku kerisieru yareya, oi kadi buŋore qaqaji ŋi moji maneya. Oŋu maneru jiŋo maiineo waperu iŋi weu teya, “Mimipaŋ buŋo sosowo oone qoruine soguine oi uruŋu?” ");
INSERT INTO mlh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Weu teme bokirieya, “Qoruine soguine oi iŋi, ‘Israel kufufuŋ maneniŋ! Anutuji moakoŋ noŋunde Ofoŋ fukega. Nemu ya moji mata. ");
INSERT INTO mlh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ore eru maŋgo, iirugo, mamanesugo eru usuŋgo sosowo, oiji Ofoŋ Anutugo manjoko eteru goigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Mimipaŋ buŋo ore ogoine oi iŋi, ‘Gake manji jojoko eege, oŋuakoŋ ŋiŋigo sosowo manjoko eyareru goigoŋ,’ Mimipaŋ buŋo moji buŋo yoyoka oi so odure yapega.” ");
INSERT INTO mlh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yesuji Kadi buŋore qaqajire oŋu bokirieme ojiya, “Qaqaji, go buŋo poretiŋ mige. Anutuji moakoŋ fukega. Nemu ya moji mata. ");
INSERT INTO mlh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Go maŋgo, mamane-mukugo sosowo eru usuŋgo sosowo, oiji Ofoŋ Anutugo manji jojoko eteru goigoŋ. Eme gake manji jojoko eege, oŋuakoŋ ŋiŋigo sosowo manjoko eyareru goigoŋ. Mimipaŋ buŋo yoyoka oiji qoruine soguine fukegobire. Oi reŋgage, oiji boji sosowo eru pesiŋ yauŋ goine yadurega.” ");
INSERT INTO mlh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Oŋu ojime Yesuji maŋ mamanesuine maneme sagako iŋi ojiya, “Go Anuture qorumaŋgo ropeiŋgo bombeŋgage.” Oŋu mimane ekabire ŋiŋigo sosowo yoŋoji Yesu jikigaru weu tenimiŋ ore fogaturuŋ eru bokebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuji boji soriŋgo dimaku Biŋe buŋo qaji yareru iŋi weu yareya, “Kristoji kiŋ Deiwidre osigida fukega, kadi buŋore qaqaji yoŋoji buŋo oi uruŋure miegobi? ");
INSERT INTO mlh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Deiwidji iŋoyoŋe Moro Tiriineji boburo teme iŋi miya, ‘Anutuji dimaku nonde Ofoŋ iŋi ojiya: Goji wareru nonde me furoneo ŋende nonji damaŋ botuineo rosipugo ode rondiŋ yaberu gbiŋ eyareme gore kufu yukuo rua yabebemiŋ. Damaŋ oi ware fukeiŋ so kuririquraŋgo yo ŋeigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deiwidji iŋoyoŋe oŋu miku tinaine ‘nonde Ofoŋ miga.’ Ofoŋne miku uruŋu eru iŋore osigida oŋuakoŋ fukena?” Oŋu miko ŋiŋigo kubu sogo yoŋoji Yesure buŋore aŋi maneru kaje ruabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuji qaji yareru jikigaru iŋi yajiya, “Ŋoŋo kadi buŋore qaqaji yoŋore siŋaŋ baku goinebi. Yoŋoji mariku joroine keru raware eku yaduiŋgo ore maneegobi eru nareŋgareŋ kaeo me kadio ŋiŋigo ŋone yabebi mijeri eyareninde ore maneegobi. ");
INSERT INTO mlh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Oŋgawowosi pi jiŋo pipiineo paibe ŋenimiŋ ore aŋi maneegobi eru jebego ŋeŋe boboniineo oo minemine ŋeiŋgo maneegobi. ");
INSERT INTO mlh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yoŋoji koje yoŋore pi ya anda eru koŋgo eegobi eru tinabiŋeyaŋuŋ fukeiŋ ore oŋgawowosi joroine joroine oŋga wosiru omoyaŋuŋgo qaegobi. Ore eru Anutuji buŋoyaŋuŋ mitariru geoine ropekiine bokirieme paiyaŋuŋgo ropeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuji boji soriŋgo pesiŋ katapa soguinere ŋadiineo ŋeko ŋiŋigoji moneŋ oo ruabi rakame piku ŋone yabeya. Ŋiŋigo tinabiŋe eru meboyaŋuŋke kokoine yoŋoji waperu kina moneŋ kokoine ruabi rakaya. ");
INSERT INTO mlh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ruabi rakame koje wakiqoqoine moji waperu siqojiŋo yoyoka, oi toiya boboroŋ oŋuine ruame rakaya. ");
INSERT INTO mlh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesuji oi ŋoneru kiŋariŋpuine kepore yaberu iŋi yajiya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Koje wakiqoqoine yo iŋoji pesiŋ ruaga, oi goine sosowo yoŋoji ya katapago ruabi rakaga, ore soine odureru ruaga. ");
INSERT INTO mlh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sosowo yoŋoji moneŋyaŋuŋ kokoine pe yareko mobeine akoŋ ruagobiyoŋ, ŋigo yo iŋoji taqararaŋine goga ore so yareyaine sosowo rua foreru omaine mata yobu goiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuji boji soriŋ bokeru wakiru kiŋariŋpuine yoŋoreone moji iŋi ojiya, “Qaqaji ŋone! Sorinde jokoroŋ maŋgo piine piine oi qembibiineke. Oi ko soguine soguineji baku mosiquranji basarigabi fiine yobu dimaga.” ");
INSERT INTO mlh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesuji oi maneru buŋo iŋi bokirieya, “Sorinde jokoroŋ maŋgo pi soguine qembibiyaŋuŋke sosowo yo ŋone yabegeyoŋ, oi ketotiebi pire ko mo oi ko more paiineo so peiŋyoŋ, siŋsaŋ qaku sesuine akoŋ peiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Oŋu miko Oliwe yo tukuo roperu aribe aroo boji sorinji dimaya, oi ŋoneru ŋebuŋ. Oo ŋeku Pita, Jeims, Jon eru Andru yoŋoji Yesu iŋoyoŋe akoŋ poreru iŋi weu tebuŋ, ");
INSERT INTO mlh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Qaqaji, buŋo mige, ore foriine wamo damaŋgo fukeiŋ eru ya sosowo oi fuŋgaru fuke foreiŋ, ore mogeineji uruŋu fukeiŋ? Oi soine minde manekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Oŋu weu tebi fuŋgaru iŋi yajiya, “Moji sinefuru eru tiŋtuŋ qaku egu ranimiŋ ore sisiŋaŋ ee eku goinebi. ");
INSERT INTO mlh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ŋiŋigo kokoineji fukeru nonde tinaneo iŋi minimiŋ, ‘Nonji Kristo fukego.’ Oŋu miku ŋiŋigo kokoine eadu yabenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ŋoŋo jigore biŋeine eru fonuŋine fukeme maneenimiŋ. Oi maneru gburugburu so qainebi. Ya oŋuine oi ronekoŋ fukeiŋ ore mimiine. Oi fukeiŋyoŋ, morende damanji oo akoŋ pipa so tariiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kantri moji kantri mo yabeiŋgo ore pakerenimiŋ. Ŋiŋigo kubu moji kubu mo yoŋoke buru baku qoqo eiŋgo ore pakerenimiŋ. Moreŋine moreŋine oo komeŋ yasogo yasogo baku moreŋ igogaru kerisieme rakaeiŋ. Oŋuakoŋ roro moreŋine moreŋine fukeru pe ropeiŋ. Ya oŋuine oi ŋigo kuakeji goji fuŋgaru keyabeega ore so. Morende damaŋineji ore so fuŋgaru foreiŋgo eiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Oŋu fukeiŋyoŋ, ŋoŋo sisiŋaŋ fiine akoŋ ee eku goinebi. Ŋiŋigoji oga ŋaberu buŋo korogo rua ŋaberu oŋgawowosi piyaŋuŋgo buŋo gio baku kobinji ŋabenimiŋ. Goineji nonde eru oga ŋabebi kantriine kantriine yoŋore ŋi koito eru gawana yoŋore jiŋo maio dimanimiŋ. Oŋu dimaku nonde fuŋne kitiŋgaku mikabuŋ manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bobiaŋ Biŋe yo bonieru moreŋgo kantriine kantriine sosowo yoŋore misaue forebi morende damaŋineji ore ŋadiineo tariiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pore ŋaberu buŋo korogo rua ŋabebi dimanimiŋ, damaŋ oo buŋo uruŋu minobeŋ, ore manemejaine oi bonieru so maneinebi. Moro Tiriineji aua oo akoŋ buŋo ŋareiŋ, oi minimiŋ. Ŋoŋo-ŋaŋunde maŋgone buŋo so miinebiyoŋ, Moro Tiriineji maŋ-ŋaŋuŋ boburogame buŋo minimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Maŋkekerisiere mutuine moji kaka gboine maŋine kerisieya ore eru oi babae bame buŋo korogo ruabi qabi komeiŋ. Oŋuakoŋ mama moji odumadepuine babae bame komeiŋ eme odumadepuine yoŋoji maŋgo mamayaŋuŋ igo yaberu mibi yabebi komenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kantriine kantriine yoŋoji nonde tinare eru rosi eyarebi gonimiŋyoŋ, moji yameŋ keku sanaŋgaru qiŋ keru dimaku goko morende damaŋineji tariiŋ, iŋoji seŋgiŋbaŋgiŋ bofukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Jiki goineji wareru ketoqototie eru ya wuwunuŋineke soriŋgo so ruruare so oi koroineo ruabi dimako ŋonenimiŋ, damaŋ oo Judia prowinsgo gonimiŋ, yoŋoji bio geŋga poreru tukuo rainebi. Buŋo yo oseiŋ, iŋoji soine kaje ruaru mane mukuigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pi bembeŋgo kae jiŋoo goiŋ, iŋoji waki yaine roiŋgo ore pi maŋineo so ropeigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gioo raru goiŋ, iŋoji oŋuakoŋ marikuine roiŋgo ore kirieru pigo so raigoŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yei! Ŋigo kuake eru odumade moŋgo yoŋoji damaŋ oo uruŋu pipa ranobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ore eru ya oi kue gbiŋ damaŋineo so fukeiŋ ore eru oŋga wosieinebi. ");
INSERT INTO mlh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Damaŋ oo sisikoŋkoŋ qembibiineke fukeiŋ. Sisikoŋkoŋ soine oŋuine oi ronekoŋ damaŋ mogo so fukeru peya. Anutuji ya sosowo bofukeya, damaŋ oo akoŋ fuŋgaru damaŋ yoo goku pakereru damaŋ botuineo mo so fukeya. Ronekoŋ so fukeya eme jiki damaŋ mogo so fukeiŋ. Ore eru oŋga wosiru goeinebi. ");
INSERT INTO mlh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ofonji koŋkoŋ damaŋ oi so bombeŋgana ine, ŋiŋigo sosowoji sibiriga forenobuŋyoŋ, ŋiŋigo iŋoyoŋunde roosoe yabeya, yoŋore eru una ore jare oi bombeŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Damaŋ oo iŋi minimiŋ, ‘Maneniŋ! Kristoji yoo goga,’ eru ‘Ŋoneniŋ! Munaŋqoqo Rauineji aroo dimaga.’ Moji oŋu miiŋ ine, oi so manesiŋ gainebi. ");
INSERT INTO mlh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Oi iŋi ore migo: Munaŋqoqo rauine ikoine eru kajeqouŋ ŋiŋigo jijibuine fukeru mosi qoqowirie eru soi jiŋofuru babi qowirienimiŋ. Oŋu qowiriebi Anutuji ŋiŋigo iŋoyoŋunde roosoe yabeya, oi oŋuakoŋ bobojibu eyarenimiŋ ore eesoi eku yameŋ kebi tiŋtuŋ egu qanimiŋ. Ŋoŋoji sisiŋaŋ fiine akoŋ ee eku gobi oi embimbiŋganobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nonji ya sosowo oi so fukeme bonieru sosowo ŋajibe manegobi. Oi rone migo ore oi bio maŋ wombuŋ-ŋaŋuŋgo ruaru sisiŋaŋ ee eku goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Sisikoŋkoŋ oi tariko damaŋ oo akoŋ wegi jiŋoineji gobureko ayonji dabu eiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Bobuŋ yoŋoji qonikiŋgone waki forenimiŋ eru qonikinji itiriŋgako ore yareyaine oi ŋeŋeyaŋuŋ bokeru bobojibu ekabi jibugaiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Damaŋ oo Sombuŋ eru morende Ŋi foriine iŋoji kuaŋ paiineo wareme ŋonenimiŋ. Usuŋine yasogoji gbuŋgbasaŋineke totogo fukeko kuririquraŋine ŋonenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wareru Sombuŋ mimerereŋpuine sore yabeme yoŋo ŋiŋigo Anutuji iŋoyoŋunde roosoe yabeya, yoŋo moreŋ qaŋaŋine mobemobe, paibe yukube oone akoŋ kenusu yabenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ŋoŋo oguŋ yo ŋoneru kamasiine manesuku soso buŋo yo maneniŋ. Tieŋineji obuineke fukeko rekayaŋuŋ posebi oi ŋoneru ore iŋi miegobi, ‘Wegi damaŋ bembeŋgaga.’ ");
INSERT INTO mlh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ŋoŋoji oŋuakoŋ soi ore so fukeko ŋoneru mane taniŋgaru fuŋine iŋi miinebi, ‘Yesuji mendigo bombeŋgaga.’ ");
INSERT INTO mlh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Ŋiŋigo yo muŋambe moreŋgo gobuŋ, yoŋoji so komebi ya sosowo migo, oi yoŋore gogo damaŋgo fukeiŋ ");
INSERT INTO mlh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Qonikiŋ eru moreŋ yokoji sirowenimiyoŋ, nonde Biŋe buŋoneji so mataeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Sombuŋ eru morende Ŋi foriine wamo damaŋgo wareiŋ, ore unaine me aua damaŋine oi moji mo so manega. Sombuŋgo mimerereŋ yoŋoji oi so manegobi. Anutu Madeineji oŋuakoŋ oi so manega. Mama iŋoyoŋe akoŋ oi manega. ");
INSERT INTO mlh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Wamo damaŋgo fukeiŋ, oi so manegobi ore ŋoŋoji siŋaŋ baku moko maŋgarigari goinebi. ");
INSERT INTO mlh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Oi soso buŋo yoore so pega: Ŋi moji moreŋine bokeru kantri mogo raya. Raiŋgo eru siŋaŋpuine ya sosowo mitiga yareme mendire ki mendaine meyaŋuŋgo ruaru usuŋine yareya. Usuŋine yareru kiŋaŋqoqopuine moakoŋ moakoŋ gioyaŋuŋ yareya. Yareru goku mendi siŋaŋine oŋuakoŋ maŋgarigari goiŋgo ore mitiga teya. ");
INSERT INTO mlh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pi rauineji wamo damaŋgo kirieru wareiŋ, oi so manegobi. Iŋande me ubu joŋiŋgo wareiŋ me? Wegijiriŋ sineko wareiŋ me? Wegi wapeko wareiŋ me? Ore so ŋoŋo oi so manegobi ore eru maŋgarigari goinebi. ");
INSERT INTO mlh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ŋoŋoji kubaŋ pekabi pipa wareru oŋu egu bofuke ŋabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ŋoŋo maŋgarigari goinebi. Buŋo oi kiŋariŋpune ŋoŋore migo, buŋo oi oŋuakoŋ ogopune sosowo ŋoŋore moko migo: Ŋoŋo maŋgari goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pasowa kombaŋ eru poroŋ yistine tomiri ore kombaŋ bembeŋgabire. Una yoyoka tariko oo fuŋganimiŋ ore ebeŋ soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji tumaŋgabuŋ. Tumaŋgaru uruŋu gbegbedi ebeneŋ Yesu sumuŋgaru roru qabi komena, ore fuŋine baaru mi osoebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Baaru osoeru iŋi mibuŋ, “Ŋiŋigo maŋyaŋuŋ rigaŋgame jigo oyowoine oyowoine egu fukeiŋ ore oi jeri kombaŋ damaŋineo eiŋgo ore embimbiŋgakimiŋ.” Oŋu mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuji Betani kaeo goku Saimon mo waeine bofosikeya, iŋore pigo roperu ŋeya. Oo uqo noku ŋeko ŋigo moji ko sogo mo roru iŋoreo wareya. Sogo oi ko yaŋgbuŋineke tinaine alabasta oiji bakine. Oi obu junjinaŋ kouineke foriine tinaine nad oiji puseru ŋeya. Iŋoji oi furiine sogoji roru wareru sogo ubeine ketigaru obuine Yesure qorugo keseru rau teya. ");
INSERT INTO mlh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rau teme ŋi ŋebuŋ, yoŋoreone goineji maŋyaŋuŋ sembeako yoŋoyoŋe akoŋ iŋi mimane ebuŋ, “Nad obu oi wamore oŋu sibirigaga? ");
INSERT INTO mlh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nad obu jijiineke oi furiine banimiŋ ore ruana ine, soine giobobo 300:re furiine odurena. Oi ŋiŋigo wakiqoqoine yareme sagana.” Oŋu miku ŋigo oi mitebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mitebi Yesuji iŋi yajiya, “Ŋigo yo so miteniŋ. Wamore maŋine bosembeagobi? Iŋoji mosi fiine sari yobu enareko sagaga. ");
INSERT INTO mlh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŋiŋigo wakiqoqoine yoŋo damaŋine damaŋine botuŋaŋuŋgo gobi ya fiine eyareiŋgo ore maneru oi soine damaŋ so enimiŋyoŋ, nonji ŋoŋore botugo damaŋ so, so gobemiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iŋoji oi iŋoyoŋunde eeboboinere sogo enarega. Nonji komebe yaŋga nunimiŋ ore soine bonieru sakine jijiji rau narega. ");
INSERT INTO mlh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Bobiaŋ Biŋe yo kantri oo me oo misauebi raiŋ, oo ŋigo yo oiji ya enarega, ore biŋeine oi oŋuakoŋ mibi saueme iŋore manesuku gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kiŋariŋpuine 12 yoŋoreone mo tinaine Judas Iskariot iŋoji Yesu babae bateiŋgo eru soriŋ gio siŋaŋ yoŋoreo raya. ");
INSERT INTO mlh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yoŋoreo raru buŋo miko oi maneru maŋyaŋuŋ fiame furiine moneŋ oteiŋgo ore buŋo kipebuŋ. Buŋo kipebi Yesu damaŋ mogo babae bateinde kadi baaru ŋone yoberu goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Poroŋ yistine tomiri ore kombaŋ una bobonio (sekiqonogo) mosiyaŋuŋ boyoberu pasowa lama mo qaku riga gobuŋ. Ore eru Yesure kiŋariŋpuji ojibuŋ, “Qaqaji, niŋo pi uro raru pasowa lama gore bomogaru moko nokimiŋ? Aŋigo uruŋu pega?” ");
INSERT INTO mlh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Oŋu ojibi kiŋariŋyokaine yoyoka iŋi miku sore yapeya, “Ŋoko Jerusalem sitio ropebire ŋi mo obu dero kukugaru wareme bofukenimi. Bofukeru iŋo soine boyoberu rani. ");
INSERT INTO mlh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Rakabire pigo ropeko ore rauine iŋi ojiinebire, ‘Qaqajiji iŋi miga: Soine pi maŋine mo mitari norende oo roperu kiŋariŋpune yoŋoke pasowa lama nokimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Oŋu ojibire rauineji pi paiineo paibe roperu maŋine soguine mo ŋatuiŋ. Oo ŋeŋe pepe ya bomogabi ŋega. Oi ŋatuko oo lama qaku riganimi.” ");
INSERT INTO mlh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Oŋu miko kiŋariŋyokaineji bokeru sitio roperu Yesuji buŋo miya, ore so bofukeru dimaku lama qaku rigaru bomogabu. ");
INSERT INTO mlh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kae ubu eko Yesuji kiŋariŋpuine 12 yoŋoke pi oo wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Waperu roperu ŋeŋeo ŋeku uqo nokabuŋ Yesuji iŋi yajiya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Ŋoŋoreone mo noke uqo noku ŋega, iŋoji babae banuiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Oŋu yajime maneru maŋyaŋunji beusembe maneru fuŋgaru bubu weu teru mibuŋ, “Nonde egu miiŋ?” ");
INSERT INTO mlh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Weu tebi iŋi yajiya, “12 ŋoŋoreone mo noke poroŋ sigo igokurugaga, iŋoji. ");
INSERT INTO mlh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sombuŋ eru morende Ŋi foriineji iŋore buŋo quraŋgabi pega ore so moreŋ bokeru raiŋ. Raiŋyoŋ, babae bateiŋ, iŋore ‘Yei beusembe!’ miku oŋga jojorago. Anutuji geoine ropekiine bokirie teiŋ. Ŋi oi maŋgoinere beu maŋgone so fukena, oo afaga tena.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Uqo noku ŋeku Yesuji poroŋ roru mifiagaru baji yareru iŋi miya, “Yo nakene fu. Oi roru noniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Oŋu miku wain popu roru daŋge miku yareme sosowoji popu oone nobuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nokabi iŋi yajiya, “Yo nakene dari. Yo Anutuji ŋiŋigo yoŋoke kikipe buru ruame sanaŋgaiŋ ore darine kesebi ŋiŋigo kokoine munaŋ qa yareiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Nonji wain niginde foriine yo moke jikigaru so nobemiŋ. Jiki Anuture qorumaŋ maŋineo paibe ŋekabeneŋ jebe baiŋ, una oo wain obu fuŋine mo oi nobemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Oŋu miko jeri kiki keku bokeru raru Oliwe yo tukuo ropebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Roperu Yesuji iŋi yajiya, “Kajeqouŋ ŋi moji buŋo mo iŋi quraŋgame pega, ‘Nonji siŋaŋyaŋuŋ qabe lama qokoineji roiŋganimiŋ.’ Ore so ŋoŋoji sosowo maŋ-ŋaŋuŋ sembeako boke nuru totienimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Totiekabi nunimiŋyoŋ, nonji komegone pakereru bonieru Galili prowinsgo raru oo fuke ŋarebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Oŋu yajime Pitaji iŋi ojiya, “Yoŋoji sosowo maŋyaŋuŋ sembeako boke guru totienimiŋ ine, nonji jibu oŋu so ebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ojiko Yesuji miya, “Nonji buŋo foriine mo iŋi gajibe mane: Qoquji ate yoyoka so qakame goji muŋambe ubune muga nunde ate yokaomo fukeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Oŋu miyayoŋ, Pitaji yameŋ keku sasanaŋ eko, “Qaqaji, oŋu matayoŋ, noŋ nubi goke moko komenobe, oi jibu nonji go so muga gubemiŋ.” Kiŋariŋ goine sosowoji buŋo oi akoŋ mibuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Oŋu mimane eku raru kae sesu mo tinaine Gezemane oo ropebuŋ. Roperu kiŋariŋpuine iŋi yajiya, “Nonji aroo raru oŋga wosibe ŋoŋo damaŋ botuineo yo ŋeniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Oŋu yajiru Pita, Jeims eru Jon oga yabeme rabuŋ. Rakabi Yesuji fuŋgaru koŋkoŋ bibiineke maneme kufu meine qomukuya. ");
INSERT INTO mlh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Oŋu eru iŋi yajiya, “Nonde maŋneji jaja bame pakerega ore eru beusembe manebe kokomeine enarega. Ŋoŋoji yo ŋeku noke gariine goinebeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Oŋu yajiru iŋoyoŋe akoŋ kokiine mo jikigaru raru dikanji keru daberu joiserereŋ damaŋine oi Mamainere mire so odureiŋgo ore oŋga wosigaya. ");
INSERT INTO mlh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Oŋga wosigaru miya, “Aba Mamane, go ya mo so emomoŋgaege. Ore eru joisererende popu yo roigoŋ. Ronunoŋ, oi nonde aŋire so matayoŋ, gogakere maŋ aŋigo boyoberu fukeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Oŋu miku kirieme kiŋariŋpuine yokaomo yoŋoji kubaŋ pebi ŋone yaberu Pita iŋi ojiya, “Saimon, go kubaŋ pege me? Go aua moakomeŋ gariine goiŋgo ore so sanaŋgage me? ");
INSERT INTO mlh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Maŋnoŋunji gariine goiŋgo ore aŋi maneegobeneŋyoŋ, sakinoŋunji wiriine fukega. Ore eru eesoigo egu waki ŋabeiŋ ore ŋoŋo oŋga wosiru maŋgarigari goinebi.” ");
INSERT INTO mlh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Oŋu yajiru moke boke yaberu raru buŋo oi akoŋ moke miku oŋga wosiya. ");
INSERT INTO mlh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Oŋga wosigaru kirieme jiŋo hopiyaŋuŋ yobiŋgame moke kubaŋ akoŋ pebi ŋone yabeya. Kubaŋgone pakereru buŋo bokirienimiŋ ore mumutu ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesuji raya ate yokaomo fukeko kirieru wareru iŋi yajiya, “Ŋoŋo jikigaru gbiŋ roru kubaŋ akoŋ peiŋgo ore manegobi me? Maneniŋ! Moji Sombuŋ eru morende Ŋi foriine babae bateme gawman ŋi kekesuesueyaŋuŋke yoŋore meo ropeiŋ, ore aua damaŋineji wareru fukega. Ŋoŋore kubaŋ pepe damaŋ oi tariga. ");
INSERT INTO mlh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bio pakerebi raki. Maneniŋ! Babae banuiŋ, iŋoji bembeŋgo yoo warega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuji oŋu miku dimako oo akoŋ kiŋariŋpuine 12 yoŋoreone mo tinaine Judas iŋoji kubu mo mine ba yareme wapebuŋ. Soriŋ gio siŋaŋ, Kadi buŋore qaqaji eru kantrire minebobo yoŋoji oi sore yabebi jigore siqo sogo eru damuyaŋuŋ roru warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Babae baiŋgo eya, iŋoji bonieru yoŋoke soi buŋo iŋi kiperu yajiya, “Nonji ŋi bibiineo mudugabemiŋ, oi ŋoneru ‘Iŋo oi!’ miku roru nigiŋgaru poretiŋ siŋaŋ gaku rainebi.” ");
INSERT INTO mlh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Oŋu miku wareru oo akoŋ Yesureo roperu “O kokone! (Qaqajine!)” miku bibiineo mudugaya. ");
INSERT INTO mlh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mudugame ŋoneru Yesu qafagaru roru kipebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kipebi bembeŋgo dimabuŋ, yoŋoreone moji jigore siqo sogo poreru soriŋ gio siŋaŋ qoruinere kiŋaŋqoqo qaku kajeine kemukume wakiya. ");
INSERT INTO mlh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu kipebi buŋo iŋi yajiya, “Noŋ suroŋqoqo ŋi matayoŋ, jibu nonde oŋu maneru jigore siqo sogo eru damu baru ro nuru kipe nuiŋgo ore waregobi. ");
INSERT INTO mlh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nonji una so boji soriŋgo ŋoŋoke dimaku Biŋe buŋo qaji ŋareru gobe so ronubuŋyoŋ, ya yo Biŋe Qurande buŋoji foriineke fukeiŋgo ore fukega.” ");
INSERT INTO mlh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesu kipebi kiŋariŋ yoŋoji sosowo Yesu bokeru totieru sumuŋgaru rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ŋi jeŋoŋ moji kambaŋine yagaŋine kiperu Yesure ŋadio boyoberu raya. Kambaŋine goine so keru rako oi babofosi eru roiŋgo ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Roiŋgo embimbiŋgaru kambaŋine qomukubi gbarandaŋ sumuŋgaru raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu kiperu ogaru soriŋ gio siŋaŋ qoruinere morumboŋ pigo rabuŋ. Rabi soriŋ gio siŋaŋ sosowo, kantrire minebobo eru Kadi buŋore qaqaji yoŋoji oo raru tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Rabi Pitaji taitai yobe yabeku soriŋ gio siŋaŋ qoruinere morumboŋ pigo roperu pire sa maŋineo ropeya. Roperu kiŋaŋqoqo ŋi yoŋore botugo misi bembeŋgo ŋeku furaya. ");
INSERT INTO mlh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Oŋu ŋeyayoŋ, soriŋ gio siŋaŋ eru soriŋ kaunsol qoko yoŋoji Yesure sakigo rurua buŋo uruŋu mi kitiŋgabi qabi komeiŋ ore mi baabuŋyoŋ, ore fuŋine mo so bofukebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Baaru dimaku kokoineji buŋo ikoine sakiineo ruaku kitiŋgaku mibuŋyoŋ, buŋoyaŋunji fuŋine moakoŋ so fukeya. ");
INSERT INTO mlh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Oŋu ebi goineji pakereru dimaku buŋo ikoine sakiineo ruaku kitiŋgaku iŋi mibuŋ, ");
INSERT INTO mlh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Iŋoji iŋi miko manebeŋ, ‘Nonji boji soriŋ meji bakine yo ketotiebe moreŋgo wakime una yokaomore maŋgo soriŋ fuŋine mo meji bakine mata oi bopeŋgabemiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Oŋu mibuŋyoŋ, jibu buŋoyaŋunji fuŋine moakoŋ so fukeya. ");
INSERT INTO mlh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Oŋu so fukeme soriŋ gio siŋaŋ qoruineji pakereru mai yaberu dimaku Yesu weu teru iŋi ojiya, “Yoŋoji gore sakigoo buŋo igoku kitiŋgabi, ore mobeine mo mimiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Oŋu ojime ya sembene mo so eyayoŋ, jibu mobeine mo so kerisieru buŋoine bokeru dimaya. Buŋoine bokeru dimako soriŋ gio siŋaŋ qoruineji moke iŋi weu teya, “Anutu miteŋ gaegobeneŋ, go iŋore Made Kristo fukege me mata?” ");
INSERT INTO mlh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Weu teme “Oŋ” miku iŋi yajiya, “Sombuŋ eru morende Ŋi foriine usuŋ Rauinere me furoineo ŋeku jiki qonikinde kuaŋ paiineo wakime ŋonenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Buŋo oi yajime soriŋ gio siŋaŋ qoruineji marikuine qosugaru iŋi miya, “Yei, mamagore sia! Goineji buŋoine kitiŋganimiŋ ore moke so weu yarekimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anutu igosisi etega, oi ŋoŋo-ŋaŋe mane foregobi. Ore eru ŋoŋo uruŋu manegobi?” Oŋu miko yoŋoji sosowo Yesu komere biŋe fukeiŋ ore mitaribuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Oŋu mitariru goineji fuŋgaru tifegaru qaku jiŋomaiine komoŋ garu me bajiru qaku iŋi ojibuŋ, “Moji guga, oi soine minde manekimiŋ.” Sorinde sa siŋaŋ (sikiriti) yoŋoji oŋuakoŋ Yesu roru mauineo qabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Damaŋ oo Pitaji sa maŋineo kae jiŋoo goya. Yukube goko soriŋ gio siŋaŋ qoruinere kiŋaŋqoqo ŋigo moji oo wapeya. ");
INSERT INTO mlh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Waperu Pitaji misi furaku dimako bibitatara eru iŋi miya, “Go oŋuakoŋ Nazaret ŋi Yesuke gomeŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Oŋu miyayoŋ, Pitaji mugaru iŋi miya, “Buŋo mige, oi kikiraŋgago.” Oŋu miku sa mendiineo rakaru dimako qoqu qaya. ");
INSERT INTO mlh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mendiineo rakame kiŋaŋqoqo ŋigo moji oi oo moke ŋoneru ŋi bembeŋgo dimabuŋ, yoŋo fuŋgaru iŋi yajiya, “Ŋi yo oiji yoŋoreone mo fukega.” ");
INSERT INTO mlh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Oŋu yajiyayoŋ, iŋoji moke mugaya. Mugame damaŋ kokiine mo tariko ŋi bembeŋgo dimabuŋ, yoŋoji moke Pitare iŋi mibuŋ, “Goji Galili ŋi mo fukege ore foriine yoŋoreone mo fukege.” ");
INSERT INTO mlh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Oi maneru fuŋgaru iŋoyoŋe qaqaiso eeru mipaŋgaru misanaŋgaru miya, “Ŋi buŋoine migobi, nonji iŋo so manego. Buŋo ikoine minobo ine, Anutuji geoine bokirieru nareine.” ");
INSERT INTO mlh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Oŋu miku dimako oo akoŋ qoquji qako ate yoyoka fukeya. Qoquji qako Yesuji buŋo iŋi ojiya, Pitaji oi manesuya, “Goji ate yokaomo muga nunde qoquji qako ate yoyoka fukeiŋ.” Buŋo oi manesuku beuine pougaiŋ ore eme jojoraku kuyoya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kae fufurere akoŋ soriŋ gio siŋaŋ, kantrire minebobo (70), eru Kadi buŋore qaqaji eru soriŋ kaunsol sosowo yoŋoji buŋore koro sogo tutumaŋ ruaru Yesure buŋo mitaribuŋ. mitaribi Yesu kiperu roru raru gawana Pailotre meo ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Rom gawana iŋoji Yesu iŋi weu teya, “Fofori, go Juda yoŋore kiŋ koito fukege me mata?” Weu teme Yesuji kerisieru ojiya, “Oi gogake mige, oŋu.” ");
INSERT INTO mlh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Soriŋ gio siŋaŋ yoŋoji buŋo kokoine Yesure sakigo ruaru mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mibi Pailotji Yesu moke weu teru ojiya, “Mane! Yoŋoji buŋo kokoine gore sakigoo ruaru migobi, goji ore mobeine mo mimiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Oŋu ojiyayoŋ, Yesuji sembene mo so eyayoŋ, jibu buŋo mobeine moke so bokirieya. Buŋoine bokeru dimako gawanaji waragaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gosa so pasowa kombaŋ damaŋineo gawanaji witi pigone ŋi mo tinaine miku weubuŋ, oi mosiine boyoberu pirueru yareebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Damaŋ oo ŋi mo tinaine Barabas iŋo witi pigo ŋeya. Iŋoji suroŋqoqo ŋi goine yoŋoke jigo oyowo eru ŋi mo qabi komeya, ore witi pigo rua yabebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Oŋu ebi kufufuŋ yoŋoji gawanare morumboŋ pi kae jiŋoineo paibe roperu dimaku fuŋgaru eku goya ore so eiŋgore weu tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Weu tebi kerisieru iŋi yajiya, “Nonji Juda ŋoŋore kiŋ koito piruebe wakiiŋ ore eru manegobi me?” ");
INSERT INTO mlh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Soriŋ gio siŋaŋ yoŋoji Yesure maŋririgaŋ manebuŋ ore eru iŋo gawanare meo ruabuŋ. Oi maneru aŋiyaŋuŋ maneiŋgo ore oŋu weu yareya. ");
INSERT INTO mlh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Weu yareme soriŋ gio siŋaŋ yoŋoji ŋiŋigo kubu maŋ bapakare eyareru iŋi mibuŋ, “Yesu bokeru Barabas pirue! Ŋoŋo oŋu weu teniŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Oŋu mibi moke kerisieru weu yareya, “Oŋu migobi ore Juda ŋoŋore kiŋ koito tinaine oŋu oŋgaegobi, nonji iŋo uruŋu etenobo?” ");
INSERT INTO mlh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Oŋu weu yareme moke oŋgabuŋ, “Bio maripoŋgo qaniŋ mi!” ");
INSERT INTO mlh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Oŋu oŋgabi Pailotji iŋi yajiya, “Oi wamore? Iŋoji wamo sembene eya?” Oŋu miyayoŋ, yoŋoji oi maneru yameŋ keku jikigaru oŋga jojoraru iŋi oŋgabuŋ, “Iŋo maripoŋgo qaniŋ mi!” ");
INSERT INTO mlh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Oŋu oŋgabi Pailotji ŋiŋigo kubu sogo aŋiyaŋunde so eiŋgo maneru Barabas pirue yareme wakiyayoŋ, Yesure miko kobiŋ joruinekeji qaya baya qabuŋ. Oŋu qabi maripoŋgo qanimiŋ ore iŋo Rom mamari ŋi yoŋore meo ruaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mamari ŋi yoŋoji Yesu ogaru raru gawanare morumboŋ pire sa maŋineo ropebuŋ. Roperu mamari kubu soguine sosowo furu yabekabuŋ oo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wareru mariku boboroŋ yojuŋiru oi Yesure sakiineo keteku qiŋambu nigiŋ maŋgeŋgaru hendiŋ oŋuine qoruineo ketebi rakaya. ");
INSERT INTO mlh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Oŋu rakame fuŋgaru ohoweine baku mijeri etebuŋ, “Ohowe ohowe! Juda yoŋore kiŋ koito, ohowe!” ");
INSERT INTO mlh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kobeqoqo oŋu eku mikabuŋ sabaraji qoruineo qaku tifegaru qaku dikanji ke teru daberu mimiteŋ ikoine batebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Igosisi oŋu ete foreru mariku boboroŋ yojuŋiru oi qomukuru iŋoyoŋunde saki komoŋ keteku maripoŋgo qaiŋgo ore ogaru rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Raru kadi yasogoo ŋi mo tinaine Saimon bofukebuŋ. Iŋoji Afrika siti tinaine Sairini ore ŋiine eru Aleksander eru Rufus yokore mama. Iŋoji gioone wapeme ojiri mibi Yesure maripoŋ roru koboya. ");
INSERT INTO mlh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesu oŋu roru moreŋ mo tinaine Golgota oi noŋunde buŋoo Qorusia, oo raru ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Roperu wain obu eru marasiŋ tinaine mor oi qodureru bojibugaru otebiyoŋ, Yesuji oi takigaya. ");
INSERT INTO mlh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Takigame dimaku maripoŋgo qabuŋ. Qabi dimako qosa qabi jare fukeko Yesure saki komoŋine moakoŋ moakoŋ botuyaŋuŋgo ore so boroiŋgaru robuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kaere 9 kilok oo maripoŋgo qabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Maripoŋgo qaku qoruineo paibe qabunde fuŋine iŋi quraŋgaru qabuŋ, “Juda yoŋore kiŋ koito yo.” ");
INSERT INTO mlh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Suroŋqoqo ŋi yoyoka oŋuakoŋ iŋoke maripoŋgo yapebuŋ. Mo me furoineo mo kijoineo mobemobe oŋu yapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Anuture Biŋe Quraŋgo buŋo iŋi quraŋgabi pega, “Oi osoeru suroŋqoqo ŋi oŋuine manesuku yoŋore botugo ruabuŋ.” Buŋo oŋu oiji foriineke fukeya.) ");
INSERT INTO mlh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ŋiŋigo odureru ra wareru nifebubu eteku igobi qotikeru iŋi mibuŋ, “Yei! Go boji soriŋ soine ketotiende moreŋgo wakiko una yokaomore maŋgo moke romaeŋgaru baiŋgo ore mimeŋ. O, go ŋi fiine yobu! ");
INSERT INTO mlh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Go gake babapi eru maripoŋgone waki.” ");
INSERT INTO mlh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji oŋuakoŋ botuyaŋuŋgo igosisi eteru mibuŋ, “Goine bapi yaberu goyayoŋ, iŋoyoŋe babapi eiŋgo ore embimbiŋgaga. ");
INSERT INTO mlh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iŋoji Munaŋqoqo Rauine Kristo eru Israelre kiŋ koito fukega ine, muŋambemeŋ yo maripoŋgone wakiko ŋoneru oi manesiŋ ganobeŋ.” Oŋu mibuŋ. Ŋi iŋoke maripoŋgo yapebuŋ, yokoji oŋuakoŋ maŋqoqo buŋo gomogofo mitebu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Una botuine 12 kilok fukeko oo moreŋ sosowo qisiri eku sagaru peko raru aua yokaomore so fukeya. ");
INSERT INTO mlh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yesuji 3 kilok oo iŋoyoŋunde buŋoo iŋi ooŋ yasogo oŋgaya, “Eli eli lama sabaktani?” Oi noŋunde buŋoo: Anutune, Anutune wamore ŋadi nuge? ");
INSERT INTO mlh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Oŋu oŋgame ŋi bembeŋgo dimabuŋ, yoŋoreone goineji oi maneru mibuŋ, “Maneniŋ! Elaijare oŋgaga.” ");
INSERT INTO mlh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yoŋoreone moji giniŋgaru raru yaŋgbuŋ mo yaga kamasiine oŋu oi roru wain obu jajainekeo igokurugaru yo didi tifeineo kiperu itigaru Yesure bibi sisio paibe ruame noku miya, “Oi bokebi iŋoyoŋe akoŋ dimaine. Elaijaji wareru bomukume wakiiŋ me mata, oi ŋonekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Oŋu ebi Yesuji ooŋ yasogo oŋgaku beuine niniŋgame komeya. ");
INSERT INTO mlh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Komeko oo akoŋ boji sorinde maŋgo kambaŋ dimaya, oiji paibeine botuineo sugaru wakiru yoyoka fukeya. ");
INSERT INTO mlh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mamari siŋanji maripoŋ mai garu dimaku Yesuji beuine niniŋgame komeya, oi ŋoneru iŋi miya, “Ŋi yo oiji fofori Anuture Made fukega.” ");
INSERT INTO mlh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ŋigo goineji oŋuakoŋ taitai dimaku ya oi ŋonebuŋ. Yoŋore botugo Maria Magdalane eru Maria Jeims jiŋaine eru Joses yokore maŋgoyakuŋ eru Salome yoŋoji moko dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yoŋoji Yesuji Galili prowinsgo goko oo iŋo boyoberu kiŋaŋ qateku gobuŋ. Oŋuakoŋ ŋigo goine kokoine Yesuke Jerusalem sitio roperu warebuŋ, yoŋoji oŋuakoŋ bembeŋgo dimabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sabat kombaŋ ŋeŋere ya bomogakabi Sabat kombaŋgo fuŋgaiŋgo ore bembeŋgako iŋande fukeru wareya. ");
INSERT INTO mlh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Maŋgogio oo Arimatia rauine, ŋi jiŋobiŋeineke tinaine Josef iŋoji wareya. Iŋoji oŋuakoŋ Anutu qorumande foriine fukeiŋ ore odigaru goko. Iŋoji Juda yoŋore soriŋ kaunsol kubure minebobo mo fukeru Sabat kombanji fuŋgaiŋ ore eya ore eru kokoi qamaseru Pailotreo raru Yesure qoŋgbuŋine roiŋgo weuya. ");
INSERT INTO mlh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Weume “Fofori komega me mata?” miku manesuku mamari siŋaŋine miko wareya “Yesuji damaŋ joroine me pompoŋine komega,” miku weu teya. ");
INSERT INTO mlh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Weu teme biŋe buŋoine maneru Yesure qoŋgbuŋ Josef mitari teya. ");
INSERT INTO mlh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mitari teme kambaŋ yagaŋine furiine baru raru qoŋgbuŋine maripoŋgone qomukuru bawakiru kambanji komoŋ gaya. Komoŋ garu roru jiŋoruŋgo raru ko kouŋ gufubi ŋeŋe peya, oo ruaya. Ruaru ko yasogo mo romaeŋgame kouŋ mauine kejigaya. ");
INSERT INTO mlh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Uro ruaya, oi Maria Magdalane eru Maria Josesre maŋgoine yokoji dimaku ŋonebu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat kombaŋ ŋebi tariko oo Maria Magdalane, Maria Jeims maŋgoine eru Salome yoŋoji “Yesure qoŋgbuŋ raru rau tekimiŋ,” miku juŋ jinaŋ kouineke furiine babuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Baru peku Sonda kae fufurere akoŋ pakereru kae fufurere wegi jojiriŋ wapeko jiŋoruŋgo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Raru mimane eku mibuŋ, “Jiŋoruŋ mauineo ko yasogo pega, oi moji igogaiŋ?” ");
INSERT INTO mlh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Oŋu miku pibi rako ŋonebuŋ: Ko yasogo yobu oi igogabi raru peya. ");
INSERT INTO mlh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jiŋoruŋgo ko mauine oŋu aŋgaru dimako maŋineo ropebuŋ. Ropebi furoyaŋuŋ obe ŋi jeŋoŋ mo marikuine joroine yagaŋine ŋeko ŋonebuŋ. Oŋu ŋoneru kokoine popurebuŋ. ");
INSERT INTO mlh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Popurebuŋyoŋ, iŋi yajiya, “Ŋoŋo kokoi so maneniŋ. Ŋoŋo Nazaret ŋi Yesure baagobi. Iŋo maripoŋgo qabuŋyoŋ, iŋoji gboreru pakereye. Ore eru yo so pega. Ŋoneniŋ! Pepeine yo, oo ruabi peya. ");
INSERT INTO mlh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ore eru bio raru Pita eru kiŋariŋpuine sosowo biŋe iŋi yajiniŋ, ‘Iŋoji mine bayareru bonieru Galili prowinsgo raiŋ. Ŋoŋo oŋuakoŋ oo raru buŋoine miya ore so oi ŋoneinebi.’” ");
INSERT INTO mlh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Oŋu yajime popureru gburugburu qaku jiŋaruŋ kouŋgone wakiru giniŋgaru rabuŋ. Sombuyaŋuŋ manebuŋ ore buŋo mo so mibuŋyoŋ, buŋoyaŋuŋ mataeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuji Maria Magdalane iŋore maŋgone gemokaku 7 yobe yabeme goya. Yesuji komegone pakereru Sonda kae fufurere akoŋ rone Maria oi fuke teya. ");
INSERT INTO mlh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Fuke teme ogopuineji Yesuke go waperu damaŋ oo jiŋgeŋ keku kuyobuŋ, Mariaji yoŋoreo raru biŋeine yajiya. ");
INSERT INTO mlh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yajiyayoŋ, Yesuji gboreru goko Mariaji ŋoneya, oi so manesiŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ore ŋadiineo ogoyokaineji Jerusalem siti bokeru kae mogo raiŋgo kadio rabire Yesuji kamasiine kerisieru fuke yateya. ");
INSERT INTO mlh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yokoji oŋuakoŋ raru biŋeine oi ogopuine yajibuyoŋ, yoŋoji oi oŋuakoŋ so manesiŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jiki kiŋariŋpuine 11 yoŋoji tumaŋgaru uqo noku ŋekabuŋ yoŋoreo oŋuakoŋ fukeya. Fukeru maŋyaŋuŋ sanaŋgaya ore kanegaru komegone pakereme ŋonebuŋ, iŋoji biŋeine yajibuŋ oi so manesiŋ gabuŋ ore oi miyareya. ");
INSERT INTO mlh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yesuji iŋi yajiya, “Ŋoŋo kantri so raru moreŋine moreŋine roregaru ŋiŋigo go ragobi ore so Bobiaŋ Biŋene mitaniŋgabi maneinebi. ");
INSERT INTO mlh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Moji Anutu manesiŋ gako miti meso rau tebi maŋine kerisieiŋ, iŋoji qowirieru Sombunde biŋe fukeiŋ. Moji so manesiŋ garu qoqomuku goiŋ, Anutuji iŋore buŋo mitarime misi korure biŋe fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Manesiŋ nuku gonimiŋ, oi soi bayarebe fuŋneyaŋuŋ iŋi fukeiŋ: Yoŋoji nonde tinao gemokaku yobe yabenimiŋ. Kantri goine yoŋore buŋo miku gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kobeŋ meyaŋunji bofeŋganimiŋ. Orabeŋ nombe obu ya nobi oo so bosembe yabeiŋ. Meyaŋuŋ jibe ŋiŋigo paiyaŋuŋgo ruabi fianimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ofoŋ Yesuji buŋoine oŋu yajime Anutuji ogagame Sombuŋgo roperu Anuture me furoineo ŋeku goga. ");
INSERT INTO mlh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Paibe gogayoŋ, kiŋariŋpuineji bokeru kae moreŋ so raru Biŋe buŋoine misaueku gobuŋ. Oŋu gokabi Ofonji yoŋoke gio baku dobe yaberu mosi qoqowirie fukeko buŋoyaŋunji sanaŋgaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kajeqouŋ ŋiŋigoji Munaŋqoqo Rauine fukeinde buŋo mibi ore foriine botunoŋuŋgo fukeya, ŋiŋigo kokoineji ore sunduine fuŋgaru quraŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ya foriine oi botunoŋuŋgo fukeko goineji oi fuŋfuŋgaineone fuŋgaru waperu yoŋoyaŋunde jiŋoji ŋoneru mane mukubuŋ, yoŋoji ore so ore biŋeine jikigaru misauebi kajenoŋuŋgo rakaru noŋunde biŋe fukeya. Ŋiŋigo oŋuine yoŋoji Biŋe oi fuŋgaru papiago quraŋgaru burugabi pega. ");
INSERT INTO mlh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nonji oŋuakoŋ ya sosowo fukeru wapeya, oi poretiŋ weu yarebe fuŋfuŋgaineone fuŋgaru mibi mane mukugo. O Tiofilus nonji gore manebe ropekiine fukege. Nonji goke buŋo mi manenimigo manebe fiine fukeko Yesure binaŋ oi sosowo akoŋ burugaru quraŋgago. ");
INSERT INTO mlh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Biŋe buŋo foriine qaji garebi manege, goji ore fuŋine oseru sosowo mane mukumiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judia prowinsre kiŋ tinaine Herod iŋore damaŋgo ŋi mo tinaine Zekaraia goya. Iŋoji soriŋ gio siŋaŋ goku Abaiare gio buruo dimaya. Ŋonuŋine tinaine Elisabet iŋoji oŋuakoŋ soriŋ gio siŋaŋ Aronde osigida mo fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yokoji Anuture jiŋo maio gogo poretiŋ goku Ofonde mimipaŋ buŋo eru mimiti oi sosowo poretiŋ boyoberu bakare buŋoyakuŋ tomiri gobu. ");
INSERT INTO mlh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Oŋu gobuyoŋ, Elisabetji kufiŋ ore gariyakuŋ tomiri goku ŋiŋigo pogo ebu. ");
INSERT INTO mlh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Damaŋ mogo Abaiare gio buru damanji wareme Zekaraiaji soriŋgo siŋaŋ gio baiŋgo Anuture jiŋo maio wapeya. ");
INSERT INTO mlh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Wapeme soriŋ gio siŋaŋ yoŋoji eeboboyaŋuŋ boyoberu botuyaŋuŋgo gio boroiŋgaru Zekaraia bomukubi Ofonde korogo roperu juŋ jinaŋ kouineke rigaya. ");
INSERT INTO mlh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Juŋ jinaŋ ririga damaŋineji ware fukeme iŋoji ya kouineke oi rigako ŋiŋigo kubu sosowo yoŋoji boji soriŋ sakibe odigaru Anutu oŋga wosigaru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jiniŋ rigako kouineji isirigaru pi maŋine sagako oo Ofonde mimerereŋ moji korogo paibe fuke teru me furoine obe dimaya. ");
INSERT INTO mlh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dimako Zekaraiaji ŋoneru popureru kokoi maneya. ");
INSERT INTO mlh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kokoi maneyayoŋ, mimererenji iŋi ojime maneya, “Zekaraia, go kokoi so mane. Anutuji oŋgawowosigo mane forega. Ore eru ŋonuŋgoji kuagaru koko madego roiŋ. Oi roko goji tinaine Jon miigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","“Madego fukeko maŋgoji iŋore fiame jeriende ŋiŋigo kokoineji jeri manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Oi maŋgoinere beu maŋgo ŋeko Moro Tiriineji oo akoŋ fuŋgaru maŋine puseko sogueru wain me obu sanaŋine oi so noku Ofonde keririŋgo ŋi ropekiine fukeru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Oŋu goku Israel ŋiŋigo kokoine maŋyaŋuŋ kerisieme Ofoŋyaŋuŋ Anutureo kirienimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anuture Moroji kajeqouŋ ŋi Elaija dobegako usuŋ paio gio baya, iŋoji ore so bonieru rame Ofonji ŋadiineo wareiŋ. Iŋoji raru kufufuŋ maŋ bapakare yabeko Ofonji wareiŋ ore jaueru dimanimiŋ. Mama eru odumade pougaru roiŋgabi maŋbapakare eyareko moke qoqoju enimiŋ eru qoqomuku ŋiŋigo oi poretiŋ yoŋore mamane buruo ropenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sombuŋ mimererenji oŋu ojime Zekaraiaji miya, “Ŋonuŋneke niko ŋiŋigo pogo egobere ore buŋogoji uruŋu foriineke fukena?” ");
INSERT INTO mlh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Oŋu miko bokirieya, “Noŋ Geibriel. Nonji Anuture maio dimabe sore nume biŋe fiine yo roru wareru gajibe manege. ");
INSERT INTO mlh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nonde buŋo mine foriineke fukeiŋ, goji oi mibe so manesiŋ gage ore buŋogo oi mata eko mutu gomiŋ. Oŋu gokande biŋe buŋo yoore fori fukeinde damaŋ ware fukeme oo namangoji wirieko buŋo moke mimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Damaŋ botuineo oo ŋiŋigoji odigaru ŋeku Zekaraiaji boji soriŋgo paibe damaŋ joroine dimaya ore maŋyaŋuŋgo manetiqotike manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Oŋu eru ŋebi sakibe wakiru buŋo miiŋgo embimbiŋgako mane taniŋgaru iŋi mibuŋ, “Iŋoji boji soriŋgo dimaku jiŋoine kerisieme Sombuŋgone sasako mo ŋonega.” Oŋu mibi meineji akoŋ soso eyareru mutu fukeru goya. ");
INSERT INTO mlh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Oŋu goku soriŋ gio bobo damaŋineji tariko kirieru piineo raya. ");
INSERT INTO mlh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Una goine tariko Elisabetji kuagaru kaiŋ 5 ore so pigo sumuŋgaru iŋi miku ŋeku goya, ");
INSERT INTO mlh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Madene tomiri ore ŋiŋigoji bawaki nubi Ofonji mai nuku ore yobiŋ roru bokeru ŋonemaiŋ enarega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabetji kuagaya ore kaiŋine 6 fukeko Anutuji mimerereŋine tinaine Geibriel soreme Galili prowinsre kae mo tinaine Nazaret oo wakiya. ");
INSERT INTO mlh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wakiru ŋigo jeŋoŋ jumuine tinaine Maria iŋoreo raya. Iŋoji ŋi tinaine Josef iŋore ŋigo biŋe goya. Josefji kiŋ Deiwidre osigida mo fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mimererenji Mariareo raru iŋi ojiya, “O Maria, wegi fii. Ofonji yauŋmoriri gareru goke dimaine.” ");
INSERT INTO mlh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Oŋu ojiyayoŋ, Mariaji mijeri ore kokoine popureru fuŋine baaru manetiqoti maneya. ");
INSERT INTO mlh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Manetiqoti maneko iŋi ojiya, “Maria, Anutuji yauŋmoriri gareko iŋore jiŋoo sagage. Ore eru kokoi so mane. ");
INSERT INTO mlh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mane, goji kuagaru koko madego romiŋ. Roru tinaine Yesu miigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yesu iŋoji sogueru ŋi tinabiŋeineke fukeko tinaine ‘Ropekiinere Made,’ mibi goiŋ. Oŋu gome Ofoŋ Anutuji apaine kiŋ Deiwidre morumboŋ ŋeŋe oteme ŋiŋigo siŋaŋ yaberu goiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jeikobre kufufuŋ yoŋore kiŋ koito fukeru tatariine tomiri siŋaŋ yaberu goiŋ. Qorumaŋine oiji damaŋ mogo so mataeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mimererenji oŋu ojime Mariaji miko maneya, “Yei! Noŋ ŋire fuŋne so manego. Ore eru buŋo mige, ore foriine oi uruŋu fukeiŋ?” ");
INSERT INTO mlh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Oŋu miko maneru bokirieya, “Moro Tiriineji sabare guko Anutu ropekiinere usunji sagaru iporo gareiŋ. Ore eru made romiŋ, iŋoji tiriine fukeko ŋiŋigoji tinaine ‘Anuture Made,’ miku oŋgaenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mane. Tifego Elisabet iŋoji oŋuakoŋ ‘Kufiŋ goku made roiŋgo embimbiŋgaga,’ mibuŋyoŋ, jibu ŋigo pogo fukeru damaŋ yoo koko madere kuaineke fukeko kaiŋine 6 fukega. ");
INSERT INTO mlh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutuji ya mo eiŋgo miku oi so embimbiŋgaega.” ");
INSERT INTO mlh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Oŋu miko Mariaji ojiya, “Mane, noŋ Ofonde kiŋaŋqoqo ŋigo fukego. Ore eru buŋo mige, ore so soine fuke nareine.” Oŋu ojime Sombuŋ mimererenji bokeru raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mariaji oi maneru damaŋ joroine so eko pakereru pipa jaueru moreŋ tukuo roperu Judia prowinsre taoŋ mogo raya. ");
INSERT INTO mlh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Raru Zekaraiare pigo roperu ŋonuŋine Elisabet ŋoneru jerieru mijeriine miya. ");
INSERT INTO mlh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mijeriine miko oo akoŋ maneko koko madeji beu maŋgo riŋaru roperu wakiko Moro Tiriineji Elisabetre maŋ puseya. ");
INSERT INTO mlh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Puseko buŋo soguine oŋgaku iŋi miya, “O ogone, Anutuji mifiaine ropekiine egareko ŋigo botunoŋuŋgo gomiŋ eru made romiŋ, oi oŋuakoŋ mifia teiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Uruŋu eru Ofoŋnere maŋgoji wareru ŋone nume oŋu fuke narega? ");
INSERT INTO mlh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mane, go mijerine minde buŋo marugo kajeneo rakame madeji beuneo oŋuakoŋ jeri eru riŋaru rope wakiga. ");
INSERT INTO mlh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ofonji biŋe buŋoine miko maneru ore fori fukeiŋ, oi manesiŋ gage ore gore manebe kiwaqawaineke ege.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariaji buŋo oi maneru iŋi miya, “Ii-ia! Nonde maŋ wombuŋneji jeŋgoma Ofoŋ miteŋ gaga. ");
INSERT INTO mlh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nonde moroji Anutu, Munaŋqoqo Raunere jerieru kokoriaŋ kega. ");
INSERT INTO mlh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nonji kiŋaŋqoqo ŋigo wakiqoqoine gogoyoŋ, Anutuji jibu mai nuku ŋonemaiŋ enarega. Mane, ŋiŋigo kubuine kubuine muŋambe fuŋgaru fukenimiŋ, yoŋoji nonde ‘Kiwaqawaineke!’ miku miteŋ nuku gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Usuŋ Rauineji mosi qoqowirie ropekiine enareko gogo. Iŋore tina oi Tiriine. ");
INSERT INTO mlh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ŋiŋigo muŋambe moreŋgo gogobi eru jiki fukeru sauenimiŋ, yoŋore botugo ŋaso uri yoŋoji Anuture mi egu odureniminde kokoi manenimiŋ, iŋore ŋonemainji yoŋoke damaŋ so peiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Anutu meineji mosi qoqowirie baku oiji usuŋine noduko ŋonebeŋ. Ŋiŋigo yoŋoyoŋe bobo rope eku sigopou gogobi, Anutuji oi ketotie yabeko siombeŋsaombeŋ eru gogobi. ");
INSERT INTO mlh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kiŋ muraŋine muraŋine morumboŋ ŋeŋeyaŋuŋgo ŋeku ŋiŋigo siŋaŋ yaberu gobuŋ, Anutuji yoŋo oone qomukuru ketuŋ yabeko wakibuŋ. Wakibuŋyoŋ, wakiqoqoine oi bapakare yabeya. ");
INSERT INTO mlh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ŋiŋigo yare basiqasi eru gobuŋ, yoŋore maŋ oi ya fiine fiineji puseyayoŋ, ŋiŋigo tinabiŋeyaŋuŋke oi sore yabeme meyaŋuŋ omaine mo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Anutuji apa ŋasopunoŋuŋ bomuku yabeme Israel fukebi niŋo jikigaru Anuture kiŋaŋqoqopu gogobeneŋ. Anutuji ronekoŋ mimipaŋ buŋoine iŋi mikiperu noreya, ‘Nonji Abram eru iŋore osigidapu tatariine tomiri go roperu gonimiŋ, oi ŋonemaiŋ eyareru gobemiŋ.’ Oŋu miku buŋoine oi so niga gako go wapeya. Matayoŋ, iŋoji buŋo miine oi boyoberu goku muŋambe bapi nobeiŋgo ore warega.” Mariaji oŋu miya. ");
INSERT INTO mlh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariaji kaiŋ yokaomo ore so Elisabetke goku moke piineo kirieya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetre made roro damanji ware fukeko koko made roya. ");
INSERT INTO mlh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Koko made roko pi bembeŋgo gobuŋ eru tifepuine yoŋoji Ofoŋ ŋonemaiŋ yasogo yobu oduya, oi mane taniŋgaru iŋoke moko jeribari ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jeribari eku una 7 tariko pakereru raru Anuture moge made sakiineo ketiganimiŋ ore tumaŋgabuŋ. Tumaŋgaru “Mamainere tina Zekaraia oi jiŋa baru otekimiŋ,” mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mibuŋyoŋ, maŋgoineji miya, “Oŋu matayoŋ, tinaine Jon mikimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Miko iŋi ojibi maneya, “Jon migeyoŋ, gore tifepu yoŋoreone more tina oŋu so pega.” ");
INSERT INTO mlh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Oŋu ojibi dimaku mamaineji iŋore tina miiŋ ore weuku meyaŋunji soso ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Soso ebi tafere weume otebi oo quraŋ iŋi quraŋgaya, “Tinaine oi Jon.” Oŋu quraŋgako ore eru sosowo popure yobugabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Popure yobugabi oo akoŋ bibiine afagako namaŋine wirieko buŋo miku Anutu miteŋ gaya. ");
INSERT INTO mlh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Miteŋ gako ogopuyaŋuŋ sosowo yoŋoji sombuyaŋuŋ kokoine manebuŋ. Manebi ya fukeya, ore biŋeine mimane ebi saueru Judia tuku moreŋ sosowo sagaya. ");
INSERT INTO mlh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Biŋeine mimane ebi sosowoji oi maneru maŋ wombuŋyaŋuŋgo ruaru sabarebuŋ. Ofonji usuŋine korube paiineo keseme goya, ore fuŋine mane taniŋgaru iŋi mibuŋ, “Made yoji sogueru wamo ya mo uruŋu eru bana?” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Oŋu mibi Moro Tiriineji mamaine Zekaraiare maŋ puseko kajeqouŋ buŋo iŋi miya, ");
INSERT INTO mlh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Niŋo Israel niŋore Ofoŋ Anutu miteŋ gakimiŋ. Ii-ia! Iŋoji kufufuŋpuine mai noberu duenoŋuŋ baiŋgo jaueru wareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anutuji kiŋaŋ ŋiine kiŋ Deiwidre kufufuŋ niŋore botugone ŋi usuŋineke igodoŋgako pakereru Munaŋqoqo Raunoŋuŋ fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ronere ronekoŋgo kajeqouŋ ŋiŋigopuine roosiŋine oi boburo yabeko mibuŋo iŋi miku gobuŋ, ");
INSERT INTO mlh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Nonji rosipuŋaŋuŋ yoŋore usuŋ qabe wakiko ŋoŋo ŋeji yabebemiŋ. Uri yoŋoji rosi eŋarenimiŋ, nonji sosowo yoŋore meone bomukuru dobu kipe ŋarebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Buŋo oŋu miku ŋasopunoŋuŋ ŋonemaiŋ eyareru yoŋoke jojofo buru kamasiine mo kipeya, oi manesuku boyobeko munaŋqoqore fori fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jojofo buŋo oi ŋasonoŋuŋ Abrahamde miku mimipaŋ buŋoji misanaŋgame pega. ");
INSERT INTO mlh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jojofo buŋo ore foriine iŋi: Iŋoji niŋo rosipunoŋuŋ yoŋore meone bomuku nobeko yoŋore kokoi so maneru kiŋaŋ qateru gokimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Iŋoji buŋonoŋuŋ mitariko posikebeneŋ iŋore jiŋo maio gbagbataeŋine fukeru gogonoŋuŋ foriine poretiŋ oŋu goku komekimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","O kokone Jon, goji sogueru goku bonieru raru ŋiŋigo maŋyaŋuŋ botiŋgaru oŋu oiji Ofonde kadi boburonde wareiŋ. Ore eru tinago ‘Anutu ropekiinere kajeqouŋ ŋi,’ oŋu mibi gomiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Oŋu goku munaŋqoqo Rauinere fuŋne oi Anuture kufufuŋpu qaji yarende oi mane mukuru maŋyaŋuŋ kerisiebi Anutuji agiburaŋyaŋuŋ jureru bokeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anutunoŋuŋ maŋineji manjoko eteru ŋonemaiŋ enoreega. Oŋu eru mai noberu ginjaine paibeone ruame boribori ega. Ore eru niŋoji wegi jiriŋ sineko totogo tamaekimiŋ ore egobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Niŋo qisirigo tiŋtuŋ ŋebeneŋ komere kukure Rauji sabare nobeegayoŋ, wegi jojiriŋ waperu painoŋuŋgo igaru batamae nobeiŋ. Batamae nobeko womore fuŋne totogo fukeko ŋoneru oo roperu oderu dimakimiŋ.” Zekaraiaji oŋu miya. ");
INSERT INTO mlh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Made Jon iŋoji sogueru pakereko Moro Tiriineji dobe gako Anuture kiŋaŋ ŋi sanaŋine fukeya. Oŋu fukeru moreŋ buroineo gokame damaŋineji ware fukeme Israel kufufuŋ yoŋore jiŋoo totogo fukeru tumoqoqo gioine fuŋgaru baya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jon Mitimeso ŋiji fukeko damaŋ oo Sisa-kiŋ Ogastus iŋoji Rom sitio goku moreŋine moreŋine siŋaŋ yabeya. Siŋaŋ yaberu takis fuŋgaru ruanimiŋ ore gawmande mimiti ruame kaeine kaeine sosowo yoŋoji tumaŋgabi kequraŋ (sensus ŋi) yoŋoji tinayaŋuŋ papiago quraŋgaru burugabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Buru gio oi damaŋ fuŋfuŋgaine babuŋ. Babuŋ, damaŋ oo ŋi tinaine Kwirinius iŋoji Siria prowinsre gawana goku siŋaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ogastusji mimiti ruame ŋiŋigo sosowo poreru roperu tinayaŋuŋ buruo quraŋganimiŋ ore yoŋoyaŋunde fufuke kae qoruyaŋuŋ so rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Galili prowinsre taoŋ tinaine Nazaret oo ŋi tinaine Josef goya. Iŋore apa oi kiŋ Deiwid. Kiŋ Deiwidre taoŋ tinaine Betlehem oi Judia prowinsgo peya. Ore eru Josefji Nazaret bokeru roperu rakaru Betlehem raya. ");
INSERT INTO mlh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Raiŋgo miko damaŋ oo ŋigo biŋeine tinaine Maria oi kuaineke goya. Goko oi moko ogako tinayakuŋ quraŋganimiŋ ore moko rabu. ");
INSERT INTO mlh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Raru Betlehem ropebire Mariare made roro damanji mai gaya. ");
INSERT INTO mlh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mai gako tumoqoqo pepe pigo roperu ore maŋgo sawaine mo so bofukebu. Ore eru kaneŋ bulmakao pigo roperu ŋebu. Ŋeku oo moru madeine roru kambanji komoŋ garu bulmakao juago ruame rakaru peya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Betlehem taoŋ moreŋ oo ŋi goineji ubu so moreŋ rondiŋine oo raru lama kubuyaŋuŋ siŋaŋ yaberu gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Oŋu gobi ubu oo Ofonde mimerereŋ moji maŋfuŋyaŋuŋgo fuke yareya. Fuke yareme Ofonde kuririquraŋineji rore yaberu tamaeko sombuyaŋuŋ maneru gburugburu yabeya. ");
INSERT INTO mlh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Gburugburu yabeyayoŋ, Sombuŋ mimererenji yajiya, “Kaje ruaniŋ! Nonji jeri Biŋe soguine ŋiŋigo sosowo yoŋore baru warego, oi barariŋga ŋarebemiŋ. Ore eru gburugburu so ŋabeine. ");
INSERT INTO mlh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Biŋe oi iŋi: Ŋoŋore Munaŋqoqo Rauŋaŋunji muŋambe yoo fukega. Iŋoji kiŋ Deiwidre taoŋgo fukeru Ofoŋ tinaine Kristo fukega. ");
INSERT INTO mlh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Buŋo ore mogeine oi iŋi: Ŋoŋo raru made gorubeine kambanji komoŋ garu bulmakao juago ruabi pega, oi bofukenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mimererenji oŋu miko oo akoŋ mimerereŋ kubu soguineji Sombuŋgone fukeru iŋoke qotureru Anuture mimiteŋ kiki keku iŋi mibuŋ, ");
INSERT INTO mlh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anuture tinabiŋe miteŋ gabeneŋ Sombuŋgo paibe ropega. Iŋoji ŋiŋigo iŋoyoŋunde roosoe yabeya, yoŋore beufi maneru moreŋgo womo eyarega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mimerereŋ yoŋoji boke yaberu Sombuŋgo kirieru ropebi lama siŋaŋ yoŋoji yoŋoyaŋekoŋ iŋi mibuŋ, “Ayo, Betlehem oo ya fukeko Ofonji ore buŋoine miko manegobeneŋ, niŋo oi raru ŋonekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Oŋu miku pipa raru Maria Josef eru made gorubeine bulmakao juago peya, bofukeru ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ŋoneru dimaku mimererenji madere buŋo miko maneru warebuŋ, oi barariŋga yareru mitaniŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mitaniŋgabi manebuŋ, yoŋoji sosowo popureru waragabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Waregabuŋyoŋ, Mariaji buŋo sosowo oi maŋ wombuŋineo ruaru maŋgaru kiperu fuŋine manesuku goya. ");
INSERT INTO mlh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Waragabuŋyoŋ, ya sosowo Sombuŋ mimererenji miya ore so fukeya, oi lama siŋaŋ yoŋoji ŋoneru maneru ore eru Anuture jeri kiki keku miteŋ gabuŋ. Miteŋ garu bokeru kirieru rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yesu fukeko Sonda moakoŋ ore so tariko Anuture moge sakiineo ketigainde damaŋ wareme tinaine Yesu mibuŋ. Sombuŋ mimererenji tina oi bonieru miku oteme damaŋ oo akoŋ maŋgoinere beu maŋgo fukeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mosesre Kadi buŋoo buŋo iŋi pega, “Ŋigoji koko madeine fuŋfuŋgaine roru una 40 akoineo goko tariko soki yoŋune keririke teru ŋoŋo boji soriŋgo roperu made oi Ofonde jiŋoo ruabi iŋore biŋe fukeiŋ.” Ore eru damaŋ oi ware fukeme Josef Maria yokoji buŋo oi reŋgaru Yesu ogaru Ofonde biŋe fukeiŋ ore Jerusalem ropebu. ");
INSERT INTO mlh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ofonde Kadi buŋoo buŋo iŋi quraŋgabi pega, “Made fuŋfuŋgaine sosowo oi rua yabebi Ofonde biŋe gbagbataeŋine fukenimiŋ.” Yokoji buŋo oi boyobebu. ");
INSERT INTO mlh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Oŋuakoŋ Ofonde Kadi buŋoo mimiti buŋo pega ore so kabu me hurua webo yoyoka oi boji riganimi ore Jerusalem sitio roperu rabu. ");
INSERT INTO mlh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Damaŋ oo ŋi mo tinaine Simeon Jerusalem goya. Iŋoji maŋ jumuine Anutureo qakatoru maŋkekerisiere kekegbore eme Moro Tiriineji iŋoke dimako Munaŋqoqo Rauineji Israel maŋgo fukeiŋgo odigaru goya. ");
INSERT INTO mlh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Odigaru gome Moro Tiriineji buŋo iŋi barariŋga teya, “Go Ofonde Munaŋqoqo Rauine Kristo fukeko bonieru ŋoneru komeminde joiserereŋ manemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maŋgo mamaineji Mosesre Kadi buŋo boyoberu Yesu ogaru boji soriŋgo ropebu. Ropebire Moro Tiriineji Simeon boburogame damaŋ oo akoŋ oŋuakoŋ soriŋgo ropeya. ");
INSERT INTO mlh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Roperu made oi ŋoneru roru koboru Anutu miteŋ garu iŋi miya. ");
INSERT INTO mlh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Ofoŋ, muŋambe kiŋaŋ ŋigoji soine raru maŋwomoo goku komebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gore buŋo pega ore so Munaŋqoqo Rauine sorende fukeme oi nakene jiŋoji ŋoneru kiwaqawaneke manego. Ore eru soine raru komebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Goji munaŋqoqo giore kadi bomogaru kantri sosowo yoŋore barariŋga yarende oi ŋoneru mane mukunimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Goji Munaŋqoqo Rauinere tatama yadunde kotu kantri yoŋore maŋ bapakareko mane taniŋganimiŋ eru tinabiŋegoji gakere kufufuŋ Israel niŋore botugo oŋuakoŋ sogueiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeonji made iŋore buŋo oŋu miko maŋgo mamaineji maneru qiqu eru waragabu. ");
INSERT INTO mlh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Waragabire mifia yareru maŋgoine Maria iŋi ojiya, “Mane, Anutuji made yo igodoŋgaru ruako Israel ŋiŋigo boakonji oi ŋadi gaku waki yabeko kokoineji maŋyaŋuŋ kerisieru fianimiŋ. Anutu iŋoyoŋe oi ruako moge fukeko kokoineji oi aari maneru mamboiŋ buŋo mitenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mamboiŋ mitebi maŋ mamaneyaŋuŋ sumuŋine oi oŋu totogo fukeiŋ. Gakere maŋgoo oŋuakoŋ beusembe fukeko oiji siqo teteine yobu oŋuine maŋgo ketigako qopogaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jerusalem oo kajeqouŋ ŋigo qoruine mo tinaine Ana goya. Iŋore apa tinaine Aser, mamaine tinaine Fanuel. Ŋigo oiji jeŋoŋineo ŋi roru gome gosa 7 moko gobu. ");
INSERT INTO mlh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Gobire ŋoeine komeko koje fukeru go wapeko damaŋ oo gosaine 84 fukeya. Iŋoji damaŋ so boji soriŋgo roperu oi una mo so bokeyayoŋ, ubu una Anuture uqo sowo goku oŋga wosigaru ohoweine baku miteŋ garu goya. ");
INSERT INTO mlh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Iŋoji damaŋ oo akoŋ waperu made oi ŋoneru Anutu miteŋ gaya. Anutuji Jerusalem ŋiŋigo dueyaŋuŋ baiŋgo odigaru gobuŋ, sosowo yoŋore made iŋore fuŋne mitaniŋgako manebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josef Maria yokoji Ofonji buruine mitigako Kadi buŋoo pega, oi sosowo ebire tariko Galili prowinsgo kirieru taoŋyakuŋ Nazaret oo rabu. ");
INSERT INTO mlh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Madeji sogueru pakereru sanaŋgaru maŋgboroŋineji fukeru puseko Anuture yauŋmoririji kefagame goya. ");
INSERT INTO mlh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesure maŋgo mamaji gosa so ŋonemaiŋ kombaŋ damaŋgo Jerusalem sitio roperu raebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Oŋu goku Yesu gosaine 12 tariko mosiyaŋuŋ eegobi ore so damaŋine ware fukeme oŋuakoŋ roperu rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Raru goku kombaŋ damaŋ oiji tariko kirieru piyakuŋgo rabu. Rabuyoŋ, made jeŋoŋ Yesuji Jerusalem ŋeko maŋgo mamaineji oi so mane mukubu. ");
INSERT INTO mlh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Iŋoji ŋiŋigo kubu sogo yoŋoke raga,” miku una moakonde so kadi raru daritife eru ogopuyakuŋ yoŋore botugo oŋgaru baabu. ");
INSERT INTO mlh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Oŋgaru baabuyoŋ, so bofukeru moke kirieru Jerusalem raru baabu. ");
INSERT INTO mlh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Baaru gokabire una yokaomo tariko boji soriŋgo roperu oo bofukebu. Bofukebire ŋi soguine yoŋore botugo ŋeya. Ŋeko qaji tebuŋ, oi maneru weu yareru ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ŋeku Biŋe buŋore fuŋne poretiŋ mane taniŋgaru poretiŋ akoŋ bokirieko sosowo yoŋoji oi maneru waragabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Maŋgo mamaineji ŋoneru popureru maŋgoineji ojiya, “Madene, go uruŋure oŋu enotege? Mane, mamagoke niko gore manebu eru oŋgaku baaguku gogobere.” ");
INSERT INTO mlh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Oŋu ojime iŋi bokirie yateya, “Ŋoko wamore noŋ baa nugobire? Noŋ nakene Mamare pigo ŋebe sagaga, oi manegobire me mata?” ");
INSERT INTO mlh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Oŋu bokirie yateyayoŋ, yokoji buŋo miya, ore fuŋine oi so mane mukubu. ");
INSERT INTO mlh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","So mane mukubuyoŋ, jibu pakereru yokoke kirieru Nazaret taoŋgo raru maŋgo mamaine miyakuŋ reŋgaru goya. Yesuji buŋo miya, maŋgoineji oi sosowo maneru maŋ wombuŋineo ruaru kiperu sabareya. ");
INSERT INTO mlh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesuji goku sogueme gosaine ropeko maŋgboroŋine tamaeru saueko Anutuji yauŋmoririine oteme sanaŋgaru ŋiŋigo eru Anutu yoŋore jiŋoo saga yabeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Zekaraiare made Jon iŋoji gioine fuŋgaya. Damaŋ oo Sisa-kiŋ tinaine Taiberius iŋoji Rom sitio goku moreŋine moreŋine qodureru gosa 15 ŋi koito fukeru jikigaru siŋaŋ yabeko gobuŋ. Siŋaŋ yabeiŋ ore moreŋine moreŋine Israel roregaru pegobi, oi bobogabi mobeine 4 fukeko yoŋore kiŋ koitoyaŋuŋ 4 oi iŋi igodoŋ yabebuŋ: Pontius Pailot, Herod, Filip eru Lisanias. Pontius Pailot oi Judia prowinsre gawanayaŋuŋ goya. Kiŋ Herodji Galili prowins siŋaŋ yabeya eru kakaine Filipji Ituria eru Trakonitis prowins yoyoka yoŋore koitoyaŋuŋ goya eru Lisanias iŋoji Abilene moreŋ roru goya. ");
INSERT INTO mlh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Soriŋ gio siŋaŋ qoruine yoyoka gobu, tinayakuŋ Anas eru Kaiafas. Damaŋ oo Zekaraiare made Jon iŋoji moreŋ buroineo gokame Anuture Biŋe buŋo fukeko maneya. ");
INSERT INTO mlh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Anuture Biŋe maneru raru Jordan obu sogore bembeŋgo moreŋ so roregaru goya. Roregaru goku Biŋe buŋoji maŋyaŋuŋ bapakareru iŋi miku goya, “Ŋoŋo maŋ-ŋaŋuŋ kerisiebi nonji miti meso rau ŋarebemiŋ. Oŋu ruabi Anutuji agiburaŋ-ŋaŋuŋ jureru bokeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ore buŋoine oi kajeqouŋ ŋi Aisaiaji quraŋgame iŋore Biŋe Quraŋgo iŋi pega, “Kiŋaŋ mimerereŋ moji moreŋ buroineo oŋgaku gome raru buŋoine iŋi manenimiŋ, ‘Ofonji wareiŋ-oo! Ore eru jaueru kadiine bataniŋgainebi. Maŋ-ŋaŋuŋ botiŋgaru kadiine reuinebi. ");
INSERT INTO mlh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kadi wone sosowo kemagabi poretiŋ fukeiŋ. Tuku fuŋqoduine sosowo oi qomukuru kega reubi rondiŋ fukeiŋ. Kadi kekekasiineke oi bobiaŋgabi poretiŋneiŋ. Gbinji kadi bakaigame siombeŋsaombeŋ pega, oi ketigaru bataniŋgabi posikeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anutuji seŋgiŋbaŋgiŋ Rauine soreme wareko moreŋine moreŋine sosowo yoŋoji oi ŋoneru mane mukunimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jonji ore so maŋyaŋuŋ bapakareko ŋiŋigo qokoine qokoine yoŋoji miti meso rau yareiŋ ore iŋoreo warebi ŋone yaberu iŋi yajiya, “O qoti kobende osigidapu, ŋoŋo maŋ-ŋaŋuŋ so kerisiebi Anuture maŋ rigaŋgame geoine bokirie ŋareiŋgo ega. Oi sumuŋganiminde kajeqouŋ buŋo oi moji ŋajiko sombuŋaŋuŋ maneru yoo waregobi? ");
INSERT INTO mlh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","“Ore eru bio fofori maŋ-ŋaŋuŋ kerisieinebi. Seineŋaŋuŋgone kiriebi foriine fukeko oi eeboboŋaŋunji totogo yaduru goinebi. Maŋ-ŋaŋuŋgo gbegbedi buŋo iŋi so manesuinebi, ‘Niŋoji Abrahamde osigida gobeneŋ Anutuji so sibiri nobeiŋ.’ Oŋu omoŋaŋuŋgo qaegobiyoŋ, foriine oi so eegobi. Nonji ore eru iŋi ŋajibemiŋ: Anutuji ko yo soine mitiga yareko qowirieru Abrahamde osigidapu fukeru Anutu miteŋ gaenimiŋyoŋ, ŋoŋo uruŋu? ");
INSERT INTO mlh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Maŋ-ŋaŋuŋ so kerisienimiŋ ine, Anutuji ŋoŋo yo oŋuine ketigabi wakiiŋgo egobi. Yo sosowo foriine fiine so fukeegobi, oi ketigame wakibi misigo bokeme rakanimiŋ. Yo oŋuine ketigainde ome miine suŋa baru yo fuŋgo ruame jaueru pega. Anutuji sembeneŋaŋunde geo bokirie ŋareiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Oŋu yajiko ŋiŋigo qokoine qokoine yoŋoji iŋi weu tebuŋ, “Ore eru niŋo uruŋu ebeneŋ sagaiŋ?” ");
INSERT INTO mlh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Weu tebi iŋi bokirieya, “Moji mariku yoyoka roru goga, iŋoji yokoreone mo oi marikuine tomiri oi oteine eru uri yoŋoji uqoyaŋuŋke gogobi, yoŋoji oŋuakoŋ uqoyaŋuŋ tomiri yoŋore boroiŋgaru yareinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis roro ŋi goineji oŋuakoŋ miti meso rau yareiŋ ore wareru weu tebuŋ, “Qaqaji, niŋoji uruŋu ebeneŋ sagaiŋ?” ");
INSERT INTO mlh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Weu tebi yajiya, “Gawmanji takisre jare mitiga ŋareme pega, so oi so odureru roinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mamari ŋi goineji oŋuakoŋ weu tebuŋ, “Eru niŋomeŋ? Niŋoji uruŋu ebeneŋ sagaiŋ?” Weu tebi iŋi yajiya, “More monende bapakareru yoyoiŋ eru kekogaru so einebiyoŋ, ŋoŋo-ŋaŋunde furi roegobi, oike maŋmoakoŋ eru waigo goinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ŋiŋigo sosowo yoŋoji “Jonji Munaŋqoqo Rauine Kristo egu fukeiŋ,” oŋu miku maŋyaŋuŋgo manesubuŋ. Ore fuŋine manenimiŋ ore kaje rurua gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Oŋu ebi Jonji oi sosowo iŋi yajiya, “Nonji meso omaineji rau ŋaregoyoŋ, ŋi usuŋine sanaŋ qaŋqaŋine mo wareiŋ. Iŋore usuŋ ropekiineji nonde odureiŋ. Iŋoji ŋi ropekiine fukeiŋ ore nonji iŋore kufu komonde nigiŋ bapigaru piruebemiŋgo embimbiŋgabemiŋ. Iŋoji Moro Tiriine maŋ-ŋaŋuŋgo ruame jo boruŋineji ke keririke ŋabeme oŋuine oiji rau ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iŋoji foriine eru komoŋine boroiŋ yapeinde sara roru waperu pioru ketikieru osoeiŋ. Osoeru wit koruŋine qojugaru rouŋineo ruaiŋyoŋ, komoŋine eru komeine oi ofaŋgako misi korugo rakaru tatariine tomiri ja kupeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Buŋo oŋuine oŋuine kokoine jikigaru miku maŋyaŋuŋ bapakareru Bobiaŋ Biŋe ŋiŋigo kubu sogo oi mitaniŋga yareru goya. ");
INSERT INTO mlh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Goyayoŋ, moreŋ mobeinere kiŋ koito Herodji kakainere ŋonuŋ tinaine Herodias oi kamiine roko eru sembene fuŋne fuŋne eru goya, oi Jonji barariŋga yareru totogo miteya. ");
INSERT INTO mlh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Miteme sembeneine mo jikigaru eru Jonde gio ketigaru mamari siŋaŋine miko Jon roru witi pigo ruabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jonji ŋiŋigo sosowo miti meso rau yareru Yesu oŋuakoŋ miti meso rau teya. Rau teko oŋga wosiko oo akoŋ qonikinji aŋgaya. ");
INSERT INTO mlh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aŋgame Moro Tiriineji kerisieru kabu webo oŋuine fukeru Yesure paio wakiya. Oŋu wakiko Sombuŋgone buŋo maru mo iŋi fukeya, “Goji nakene wombuŋ made fukende beune fiame ŋoneguru aŋi manego.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jonji Yesu miti meso rau teya, iŋo gosaine 30 ore so fukeko munaŋqoqo gioine fuŋgaru baku goya. Baku gokame Josefre made fukega, ŋiŋigoji oŋu manesubuŋ. Yesure mama Josef, ŋasoine tinaine Heli. ");
INSERT INTO mlh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yesu apaine tinaine Matat, ŋiriŋuruine tinaine Liwai. Liwai mamaine Melki, ŋasoine Janai, apaine Josef, ");
INSERT INTO mlh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ŋiriŋuruine Matatias. Matatias mamaine Amos, ŋasoine Nahum, apaine Esli, ŋiriŋuruine Nagai. ");
INSERT INTO mlh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai mamaine Mat, ŋasoine Matatias, apaine Semen, ŋiriŋuruine Josek. Josek mamaine Joda, ");
INSERT INTO mlh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ŋasoine Joanan, apaine Resa, ŋiriŋuruine Zerubabel. Zerubabel mamaine Sealtiel, ŋasoine Neri. ");
INSERT INTO mlh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Apaine Melki, ŋiriŋuruine Adi. Adi mamaine Kosam, ŋasoine Elmadam, apaine Er, ");
INSERT INTO mlh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ŋiriŋuruine Josua. Josua mamaine Elieser, ŋasoine Jorim, apaine Matat, ŋiriŋuruine Liwai. ");
INSERT INTO mlh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai mamaine Simeon, ŋasoine Juda, apaine Josef, ŋiriŋuruine Jonam. Jonam mamaine Eliakim, ");
INSERT INTO mlh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ŋasoine Melea, apaine Mena, ŋiriŋuruine Matata. Matata mamaine Natan, ŋasoine Deiwid, ");
INSERT INTO mlh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","apaine Jesi, ŋiriŋuruine Obed. Obed mamaine Boas, ŋasoine Salmon, apaine Nason. ");
INSERT INTO mlh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ŋiriŋuruine Aminadab. Aminadab mamaine Admin, ŋasoine Arni, apaine Hesron, ŋiriŋuruine Peres. Peres mamaine Juda, ");
INSERT INTO mlh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ŋasoine Jeikob, apaine Aisak, ŋiriŋuruine Abraham. Abraham mamaine Tera, ŋasoine Nahor, ");
INSERT INTO mlh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","apaine Seruk, ŋiriŋuruine Reu. Reu mamaine Pelek, ŋasoine Eber, apaine Sela, ");
INSERT INTO mlh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ŋiriŋuruine Kainan. Kainan mamaine Arpaksad, ŋasoine Siem, apaine Noa, ŋiriŋuruine Lamek. ");
INSERT INTO mlh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek mamaine Metusela, ŋasoine Enok, apaine Jared, ŋiriŋuruine Mahalalel. Mahalalel mamaine Kenan ");
INSERT INTO mlh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ŋasoine Enos, apaine Set, ŋiriŋuruine Adam. Adam oi Anutuji bofukeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jonji Yesu miti meso rau teme Moro Tiriineji maŋine puseko Jordan obuone kirieme ogagaru moreŋ buroineo raya. ");
INSERT INTO mlh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Raru oo gokame Sembene Rauineji esoigaru gokame una 40 tariya. Damaŋ 40 oo uqo mo so noku gome tariko uqore komeya. ");
INSERT INTO mlh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Uqore komeko Sembene Rauineji iŋi ojiya, “Go Anuture made fukege ine, oi naduru ko yo mitigande qowirieru poroŋ fukeko no.” ");
INSERT INTO mlh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ojiko bokirieya, “Mata! Biŋe Quraŋgo buŋo iŋi quraŋgabi pega, ‘Uqo akoŋ ŋiŋigo gogo so noreega.’” ");
INSERT INTO mlh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bokirieme Satanji ogagaru tuku joroine mogo roperu morende kantriine kantriine sosowo oi pipa odu teya. ");
INSERT INTO mlh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Odu teru iŋi ojiya, “Nonji kantri sosowo oi siŋaŋ yabebeminde usuŋ eru mebo yare kuririine oi nonde meo ruakiine pega. Ore eru oi nakene aŋi so mo otebemiŋgo miku soine oi otebemiŋ. Ore eru ya sosowo yo gore meo ruabemiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ore eru go ohowene baku miteŋ numiŋ ine, oi sosowo gore biŋe fuke foreiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Oŋu ojiko iŋi bokirieya, “Mata! Biŋe Quraŋgo buŋo iŋi quraŋgabi pega, ‘Go Ofoŋ Anutugore ohowe baku miteŋ garu oi moakoŋ kiŋaŋ qa teku goigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bokirieme Satanji Yesu moke ogagaru Jerusalem sitio raru boji sorinde bubuo paibe roperu iŋi ojiya, “Go Anuture made fukege ine, go yoone riŋaru yukube rakaigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Biŋe Quraŋgo buŋo mo iŋi quraŋgabi pega, ‘Anutuji mimerereŋpuine mitiga yareko soine siŋaŋ guru dobu kipe gunimiŋ,’ ");
INSERT INTO mlh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","eru buŋo mo oi iŋi, ‘Yoŋoji meyaŋunji ba gubi rakaru koji kufugo keguku kesibiri so egareiŋ.’” Ore eru soine rakaru so sibiri guiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Oŋu ojiyayoŋ, Yesuji iŋi bokirie teya, “Mata! Anutuji miga, ‘Go Ofoŋ Anutugo eesoi so eteigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sembene Rauineji eesoi sosowo oi Yesu eteme tariko bokeru raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesuji moreŋ buroine bokeme Moro Tiriinere usunji iŋoke dimako Galili prowinsgo kirieya. Kirieme buŋo biŋeineji saueru pi kae roregaru ŋe rabuŋ, oi sosowo sagaru raya. ");
INSERT INTO mlh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sagako kaeine kaeine roregaru oŋgawowosi piyaŋuŋgo roperu Biŋe buŋo qaji yareya. Qaji yareme manebuŋ, sosowo yoŋoji jerieru miteŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesuji kirieru sosogue taoŋine Nazaret oo raya. Sonda kombanji wareko eega ore so oŋgawowosi pigo roperu Biŋe Quraŋ ose yareiŋgo ore pakereya. ");
INSERT INTO mlh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pakereme kajeqouŋ ŋi Aisaiare Biŋe Quraŋ otebi qoromureru buŋo mobeine iŋi quraŋgabi pega, oi bofukeya: ");
INSERT INTO mlh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ofonde Moro Tiriineji nonde maŋgo rakaru gio bobore bogunu nume ŋiŋigo wakiqoqoine yoŋore Bobiaŋ Biŋe mitaniŋgaego. Iŋoji sore nume buŋo iŋi misaueego: Sembeneji nigiŋ yabeko gogobi, Anutuji oi pirueru bomuku yabeme gonimiŋ. Anutuji jiŋokombi ŋiŋigo jiŋoyaŋuŋ botigame moke piru ŋonenimiŋ. Rakakiine afakoŋ eru bodugaru bawaki eyarebi gogobi, Anutuji oi bomuku yabeme batiqatiine tomiri gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ofonji munaŋqoqore gosa fiine ruame ware fukeiŋ, nonji ore kiŋaŋine wareru oi mitaniŋgaego.” ");
INSERT INTO mlh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Buŋo oŋu osegaru quraŋ poporiŋine oi poporiŋgaru siŋaŋine oteru wakiru ŋeya. Ŋeko oŋgawowosi pigo ŋebuŋ, yoŋoji sosowo sorondoŋ eru jiŋosopu bibitatara ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bibitatara ebi fuŋgaru iŋi yajiya, “Biŋe Qurande buŋo yo osegabe kajeŋaŋuŋgo rakame manegobi, ore foriine muŋambe yoo fukega.” ");
INSERT INTO mlh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Oŋu yajiko yauŋmoriri buŋoine buŋoine miineone wakiko sosowoji oi maneru waragaru mijakieru buŋo ore midobodoine oi iŋi mibuŋ, “Ŋi yo Josefre made me?” ");
INSERT INTO mlh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mibi iŋi yajiya, “Ŋoŋo damaŋine damaŋine qoqiŋ buŋo yo miegobi, ‘Bobooro ŋi go gake bobobiaŋ eigoŋ.’ Ŋoŋo qoqiŋ buŋo oi muŋambe yoo najininde manegobi, oi manego. Oi miku iŋi minobuŋ, ‘Go Kaperneam taoŋgo raru mosi qoqowirie ropekiine bande biŋeine manebeŋ, ore so gakere kaeo yoo oŋuakoŋ baigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Oŋu miku yajiya, “Nonji buŋo foriine mo iŋi ŋajibemiŋ: Kajeqouŋ ŋiŋigo mo iŋoyoŋunde sosogue taoŋgo so mane tebi ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nonji buŋo fori wombuŋine mo iŋi ŋajibemiŋ: Elaijare damaŋgo Anutuji Sombuŋ mendiine keme gosa yokaomo eru kaiŋ 6 ore maŋgo kue so keme roro soguine fukeko moreŋ sosowo sagaya. Damaŋ oo ŋigo koje kokoine Israel maŋgo gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kokoineji gobuŋyoŋ, Anutuji Elaija yoŋoreone moreo raiŋgo ore so soreyayoŋ, kotu moreŋ Saidonde kae tinaine Sarefat oo ŋigo koje moakoŋ iŋoreo soreme raya. ");
INSERT INTO mlh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kajeqouŋ ŋi Elisare damaŋgo waeji Israel ŋi kokoine kefa yabeme gobuŋyoŋ, yoŋoreone moji mo so posikeya. Matayoŋ, kotu moreŋ Siriaone ŋi tinaine Naeman oi moakonji Elisare buŋo manesiŋ garu posikeru fiaya.” ");
INSERT INTO mlh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesuji oŋu yajiko oŋgawowosi pigo ŋebuŋ, yoŋoji sosowo buŋo oi maneru maŋyaŋuŋ rigaŋgame aari fuke yareya. ");
INSERT INTO mlh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aari fuke yareko pakereru Yesu kanegaru yobebi taoŋ sakiineo raya. Taoŋyaŋuŋ oi tukure koru bembeŋgo babi dimaya, oo igogabi rakaiŋ ore rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Rabuŋyoŋ, botuyaŋuŋgo kegoigaru boke yaberu raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesuji Galili prowins maŋineo Kaperneam taoŋgo wakiru roperu Sabat kombaŋgo ŋiŋigo kubu qaji yareya. ");
INSERT INTO mlh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Qaji yareko buŋoineji usuŋineke fukeko miya. Ore eru kufufuŋ yoŋoji oi ŋoneru popureru waragabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Oŋgawowosi pi oo ŋi mo gemoineke ŋeya. Ŋeko gemoineji fofo oŋga jojoraku buŋo iŋi oŋgaya, ");
INSERT INTO mlh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ae! Yesu, Nazaret ŋi! Go uruŋu enoreiŋgo ege? Niŋo sibiri nobeiŋgo ore warege me? Noŋ fuŋnego mane mukugo. Go Anuture ŋi Roosiŋine fukege.” ");
INSERT INTO mlh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Oŋu oŋgako Yesuji kanegaru iŋi miteya, “Go buŋogo bokeru ŋi yo bokeru use.” Oŋu miteme gemoji ŋi oi roru bokeme rondiŋgaru botuyaŋuŋgo moreŋgo rakako qaku kesibiri mata yobu fukeru wape bokeru raya. ");
INSERT INTO mlh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Rako sosowoji meayaŋuŋ tariko waragaru botuyaŋuŋgo mimane eku iŋi mibuŋ, “Yei! Buŋo yo wamo buŋo? Iŋoji usuŋ suŋsuŋ paiineo gemo mitiga yareko reŋgaru wape ragobi.” ");
INSERT INTO mlh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Oŋu fukeko Yesure tinabiŋeji saueru kae sosowo bembeŋgo ŋe rabuŋ, oo raru sagaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesuji pakereru Kaperneam oŋgawowosi pi oi bokeru Saimon Pitare pigo ropeya. Ropeko Saimonde safanji sakijo jibe yasogo bame peya. Peko iŋore eru Yesu oŋga wosi tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Oŋga wosi tebi raru daberu rakaru sakijo miteme bokeko oo akoŋ pakereru uqo rigaru gume yabeya. ");
INSERT INTO mlh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wegi jiriŋine mukuru rakako oo ŋiŋigo goine yoŋoji ogopuyaŋuŋ jibe fuŋne fuŋne oiji bayabeme pebuŋ, oi sosowo oga yaberu Yesureo warebuŋ. Warebi meine sosowo yoŋore paio bubu ruako fia forebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Gemo yoŋoji oŋuakoŋ ŋiŋigo kokoine yoŋore maŋgone wape jojoraku iŋi oŋgabuŋ, “Go Anuture made fukege.” Yesuji Munaŋqoqo Rauine Kristo fukega, yoŋoji oi manebuŋ ore Yesuji miyareru miyaŋuŋ qojigaru yobe yabeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yesuji kubaŋ peko kae wegi jiriŋ sineko pakereru iŋoyoŋe yaŋekoŋ rakaru guruine mogo raya. Rayayoŋ, ŋiŋigo yoŋoji baaru ra bofukeru so boke yaberu raiŋgo ore esoigaru sabarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sabarebuŋyoŋ, iŋi yajiya, “Nonji Anutu qorumaŋinere Bobiaŋ Biŋe oi taoŋ goine yoŋore oŋuakoŋ mitaniŋga yarebe sagaiŋ. Anutuji ore eru sore nuya.” ");
INSERT INTO mlh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Oŋu miku raru Galili prowins roregaru oŋgawowosi piyaŋuŋgo Biŋe buŋoji maŋ bapakare yaberu goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Damaŋ mogo Yesuji Genesaret obu joguŋ qaŋaŋineo dimako ŋiŋigoji wareru kubuine kubuine baku Anuture Biŋe buŋo manenimiŋ ore kekepuŋ eru rore gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Rore gabi dimaku ogâ yoyoka koe qaŋaŋineo ŋebire ŋone yapeya. Jembaeŋ fufuru yoŋoji ogâ oi bokeru rakaru simemeŋyaŋuŋ igo jurebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ogâ mo oi Saimonde. Yesuji oo roperu rauine iŋi weu teya, “Goji kitiŋgande kokiine mo oga nuru obu oobe raigoŋ.” Weu teko kitiŋgako rako ogâo ŋeku ŋiŋigo kubu sogo qaji yareya. ");
INSERT INTO mlh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Qaji yareme tariko Saimon ojiya, “Goji ogâ yo kitiŋgande obu joguŋ botuineo rako ogopugo yoŋoke simemeŋ-ŋaŋuŋ jembaende bokebi rakaine.” ");
INSERT INTO mlh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ojiko Saimonji bokirieya, “Sogunene, niŋo ubu joroine simemeŋ boke esegaru foriine mo so rogobeneŋ. Matayoŋ, goji mitigage ore jibu raru bokebeneŋ rakaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Oŋu bokirieme miya ore so ebi jembaeŋ sauesaueine simemeŋyaŋuŋgo rakabi simemenji tiŋaiŋgo eya. ");
INSERT INTO mlh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Oŋu eme ogopuyaŋuŋ ogâ mogo gobuŋ, yoŋore wareru bapi yabenimiŋgo me kayo kebi warebuŋ. Warebi ogâ yoyoka oi jembaenji puseme utugaiŋ ebu. ");
INSERT INTO mlh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Jembaeŋ mokemoke yobu roru ŋoneru ore eru sosowoji waragabuŋ. Waragaru Saimon Pitaji oi ŋoneru Yesure maŋfuŋgo rakaru dikanji keru ojiya, “O Ofoŋ, noŋ agiburaŋ ŋi fukego ore boke nuru ra.” ");
INSERT INTO mlh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimonde ogoyokaine Jeims eru Jon Zebedire madeyoka yokoji oŋuakoŋ meayakuŋ mukume waragabu. Saimonji buŋo oi ojiyayoŋ, Yesuji iŋi bokirieya, “Go kokoi so mane. Go yoore ŋadio ŋiŋigo oi jembaeŋ oŋuine pore yabende goke jikigabi gonimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Oŋu ojime ogâyaŋuŋ poreru waperu mageŋgo ruaru yareyayaŋuŋ sosowo bokeru Yesure ŋadio boyoberu rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuji taoŋ mogo gokame oo ŋi mo sakiine waeji bosembea foreko ŋeya. Ŋeku Yesu ŋoneru bembeŋgo dikanji keru rakaru iŋi oŋga wosi teya, “O Ofoŋ, go aŋigoo bobiaŋ nuiŋgo ore manege ine, noŋ soine bofosike nu.” ");
INSERT INTO mlh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Oŋu miko meine bofeŋgaru sakiine bouaku ojiya, “Nonji oŋu ebemiŋgo manego. Go posike.” Oŋu miko waeine oi oo akoŋ posikeya. ");
INSERT INTO mlh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Posikeme iŋi mitiga teya, “Mane, yoore biŋe buŋo oi mo so minde maneinebi. Matayoŋ, go soriŋ gio siŋandeo raru sakigo oduru Mosesre mimiti boyoberu posikege ore daŋge pesiŋ ruaru boji rigaigoŋ. Oi rigande ŋoneko ŋiŋigoji fuŋnego mane mukunimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Oŋu ojiyayoŋ, oi jibu Yesure tinabiŋe misaueko kae so sagaru raya. Raya ore so ŋiŋigo kubuine kubuine yoŋoji buŋoine maneiŋgo ore eru jibeyaŋuŋ bobiaŋ yabeiŋgo ore iŋoreo wareru tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Warebuŋyoŋ, Yesuji boke yaberu moreŋ buroineo ra goku oŋga wosiya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yesuji una mogo Biŋe buŋo qaji yareko Farisi (Kadi buŋore yameŋyameŋ) eru Kadi buŋore qaqaji goineji Galili eru Judia prowinsre kaeine kaeine eru Jerusalemgone wareru ŋiŋigo kubu sogo botuyaŋuŋgo ŋebuŋ. Ofonde usunji Yesu maŋgo eteko ŋiŋigo jibeyaŋuŋ bobiaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Damaŋ oo ŋi goineji ogoyaŋuŋ saki mobeine komekiine oi reŋgo ruaru koboru warebuŋ. Wareru petigaru Yesure bembeŋgo pi maŋineo rope ruanimiŋ ore esoebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Esoebuŋyoŋ, ŋiŋigo kubu sogoji kekefoŋ eru dimabuŋ ore kequŋgaru pi maŋineo ropeinde kadi mo so bofukeru roru pi paio ropebuŋ. Roperu bubu koji bakine oi sikeku borombiebi kimboŋ fukeko jibe ŋi reŋineke niginji kiperu oo ruabi ŋiŋigo botuyaŋuŋgo Yesure maŋfuŋgo rakaya. ");
INSERT INTO mlh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Oŋu rakame Anutu manesiŋ gabuŋ, Yesuji yoŋore kamasi oi ŋoneko sagako jibe ŋi iŋi ojiya, “Ogone, nonji agiburaŋgo bokego.” ");
INSERT INTO mlh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Oŋu ojime Kadi buŋore qaqaji eru Farisi yoŋoji oi maneru fuŋgaru iŋi miku manesubuŋ, “Ŋi yo wamo? Iŋoji Anutu igosisi etega. Anutu moakonji agiburaŋnoŋuŋ bokeegayoŋ, ŋi moji oi mata.” ");
INSERT INTO mlh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Oŋu manesubuŋyoŋ, Yesuji maŋyaŋuŋ ŋone mukuru iŋi yajiya, “Goine ŋoŋo maŋ-ŋaŋuŋgo wamore buŋo migo, ore eru kokoine manesugobi? Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Nonji agiburaŋgo bokego,’ migo, buŋo oiji afaine akoŋ mimiine. Moji oŋu miko goineji buŋo ore foriine so ŋonenimiŋ. Ore eru oi buŋo afainere so. Nonji buŋo mo iŋi mibeminde manego, ‘Go pakereru ra.’ Buŋo oi yobiŋineke mimiine fukega. Oŋu mibe foriine fukeiŋ me mata, oiji totogo fukeko ŋonenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","“Maneniŋ, moreŋgo agiburaŋ bobokere usuŋ oi Sombuŋ eru morende Ŋi foriinere pega, ŋoŋo ore fuŋinere tiŋtuŋ egu gonimiŋ. Ore eru buŋo yobiŋineke oi ŋi yo ojibe foriine ŋonenimiŋ.” Oŋu miku ŋi saki mobeine komekiine iŋo ojiya, “Nonji gajigo: Go pakereru ramegaripepego roru pigoo raigoŋ. Buŋo yobiŋine oi foriineke fukeiŋ ine, buŋo afaine oi oŋuakoŋ uruŋure omaine fukena?” ");
INSERT INTO mlh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Oŋu ojime oo akoŋ jiŋo maiyaŋuŋgo pakereru ramegaripepeine peya, oi roru Anutu miteŋ garu bokeru piineo raya. ");
INSERT INTO mlh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Oŋu fukeko ŋiŋigo sosowoji waragaru sombuyaŋuŋ maneru Anutu miteŋ garu mibuŋ, “Yei! Muŋambe ya fiine yobu ŋonegobeneŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ore ŋadiineo Yesuji Kaperneam bokeru raru takis ofis odureiŋgo eko oo takis roro ŋi tinaine Liwai ŋeko ŋoneru ojiya, “Go nonde ŋadio ware.” ");
INSERT INTO mlh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Oŋu ojiko gioine sosowo bokeru pakereru Yesure ŋadio raya. ");
INSERT INTO mlh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Raru Yesu piineo keporeru iŋore tebu jebe soguine bomogaya. Bomogaru takis roro eaduyaŋuŋke eru ogopuine goine furu yabeme kubu soguineji yoŋoke ŋeku uqo munjaŋ nobuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Oŋu nokabi Farisi (Kadi buŋore yameŋyameŋ) eru yoŋore qaqaji yoŋoji oi ŋoneru ŋunuŋ-ŋunuŋ miku Yesure kiŋariŋpu iŋi miyarebuŋ, “Ae! Ŋoŋo wamore takis roro eaduyaŋuŋke eru agiburaŋ ŋiŋigo yoŋoke ŋeku uqo obu nogobi? Oi so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Oŋu miyarebi Yesuji mobeine iŋi yajiya, “Ŋiŋigo jibeyaŋuŋ tomiri yoŋoji doktare aŋi so maneegobiyoŋ, jibe ŋiŋigoji doktareo raegobi. ");
INSERT INTO mlh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nonji agiburaŋ ŋiŋigo maŋyaŋuŋ kerisienimiŋ ore oŋga yareiŋgo wareru gogoyoŋ, ŋiŋigo yoŋoyaŋunde manebi posiine fukegobi, oi mata.” ");
INSERT INTO mlh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ŋiŋigo goineji Yesureo wareru weubuŋ, “Jon Mitimeso ŋire kiŋariŋpu niŋoji damaŋ kokoine Anuture uqo sowo goku oŋgawowosi tutumaŋ joroine ruaegobeneŋ. Farisi (Kadi buŋore yameŋyameŋ) yoŋore kiŋariŋpuji oŋuakoŋ eru gogobiyoŋ, gakere kiŋariŋpuji damaŋ so uqo obu noegobi.” ");
INSERT INTO mlh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Oŋu weu tebi iŋi bokirieya, “Fofori! Niŋo wamo damaŋgo uqo sowo goegobeneŋ? Ŋigo roro damaŋgo ŋire ujepuji boreŋine ruabi ŋigore daritifepuineji ya ore useegobi me mata? Nonji nakene kiŋariŋpu yoŋore ŋi biŋe fukeru yoŋore botugo aŋibaŋi ŋeego. Ŋebe uqo sowo gokimiŋgo mibi yoŋoji aŋibaŋi jerieru ŋeku sowo gonimiŋgo embimbiŋgaegobi. ");
INSERT INTO mlh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Embimbiŋgaegobiyoŋ, Anutuji gogone oga nuko komebe yoŋoji damaŋ oo soine uqo sowo goenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","“Ŋoŋo gogo raŋgbaŋine eru jeribari Biŋe gariine oi qodure yapenimiŋgo embimbiŋganimiŋ. Ore soso buŋo ŋadiine mo oi iŋi ŋajibemiŋ: Ninike raŋgbaŋine pougame moji ninike gariine qotigaru kambaŋ mobeine oiji so ruaru gbodueega. Oŋu ena ine, kambaŋ mobeine gariineji raŋgbaŋineke sogokoŋ so fukeru oi poreru kesuqosugako egu sembeqambeaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Oŋuakoŋ moji wain obu gariine oi jobo me toru raŋgbaŋine lama sakiineji bakine oo so pioru keseme rakaega. Oŋu ena ine, wain obu gariineji sogueru toru kesuqosugaru kesieko moreŋgo wakiko toruineji egu sembeqambeanimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","“Ore eru wain obu gariine oi toru gariineo akoŋ kesiebeneŋ rakame sagaiŋ. (Oŋuakoŋ moji obu fiine oi kiniŋ koteŋgao so pioegobeneŋ. Oŋu pionobeŋ ine, oiji pougaru siisororo wakiko noku jibe egu ba nobeiŋ. Oŋu egu fukeiŋ ore obu fiine oi kiniŋ fiineo pioegobeneŋ. Ŋoŋo oŋuakoŋ gogo raŋgbaŋine eru Bobiaŋ Biŋe gariine oi qodure yapenimiŋgo embimbiŋganimiŋ.) ");
INSERT INTO mlh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Moji wain obu raŋgbaŋine miteŋ garu noku goega, iŋoji wain obu gariine noiŋgo ore aŋi so maneru tataki eega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ore ŋadiineo Sabat kombaŋ mogo Yesuji wit kurumbu gio rondiŋ soguine petigaru raya. Rako kiŋariŋpuineji uqore komeru wit foriine moakoŋ moakoŋ meyaŋunji bajiku jomugaru nobuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Oŋu nobuŋ ore Farisi (Kadi buŋore yameŋyameŋ) goineji oi ŋoneru iŋi yajibuŋ, “Ŋoŋo wamore Sabat kombande gio bobo agi oduregobi?” ");
INSERT INTO mlh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Oŋu yajibuŋyoŋ, Yesuji iŋi bokirieya, “Kiŋ Deiwidji mamari ŋipuine yoŋoke roregaru uqore komeru ya ebuŋ, oi osebuŋ me mata? ");
INSERT INTO mlh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iŋoji Anuture kambaŋ seri soriŋgo roperu poroŋ mokiine Anuture jiŋo maio koro alatao ruabi ŋeko usuŋineji kefagame qomukubuŋ, oi roko nobuŋ. Poroŋ mokiine bobokeine oi soriŋ gio siŋaŋ yoŋoji akoŋ noku gobuŋ. Iŋoji eru iŋore osigidapuji oi egu nonimiŋ ore agi peyayoŋ, oi jibu nobuŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Oŋu miku iŋi yajiya, “Qorumaŋ eru morende Ŋi foriineji Sabat kombande Ofoŋ fukega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yesuji Sabat kombaŋ mogo oŋgawowosi pigo roperu Biŋe buŋo qaji yareya. Oo ŋi mo meine furoine gbaŋiko ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kadi buŋore qaqaji eru Farisi (Kadi buŋore yameŋyameŋ) yoŋoji Yesu ŋoneru buŋo koroineo ruaniminde fuŋne baaru “Ŋi oi Sabat kombaŋgo bobiaŋgaiŋ me mata?” oŋu miku ru baku ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ŋebuŋyoŋ, Yesuji mamanesuyaŋuŋ oi mane mukuru ŋi meine gbagbaŋine oi iŋi ojiya, “Go pakereru jiŋo mainoŋuŋgo dima.” Oŋu ojime pakereru dimaya. ");
INSERT INTO mlh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dimako Yesuji oŋu miya, “Kadi buŋo boyoberu Sabat kombaŋgo ya fiine me sembene ekimiŋ? Soine more qoru kipekimiŋ me bokebeneŋ sibirigaiŋ. Uruŋu ebeneŋ sagaiŋ? Oi weu ŋarebe miinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Oŋu miku peperisieru sosowo ŋone yabe foreru ŋi oi ojiya, “Go bio mego poretiŋga.” Oŋu ojime meine poretiŋgame moke fiine fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Fiine fukeyayoŋ, siŋaŋ yoŋoji maŋyaŋuŋ kokoine rigaŋgame “Yesu uruŋu etekimiŋ?” miku yoŋoyoŋe mimane ebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Damaŋ oo Yesuji tukuo oŋga wosiiŋ ore roperu ubu joroine oi Anutu oŋga wosi teru gome kae fureya. ");
INSERT INTO mlh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kae fureme kiŋariŋpuine oŋga yareru yoŋoreone 12 roosoe yaberu sosore ŋi aposol tina oi yareya. ");
INSERT INTO mlh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tinayaŋuŋ oi iŋi miya: Saimon, Yesuji tinaine Pita oteya, iŋore gboine Andru eru Jeims, Jon, Filip, Bartolomyu, ");
INSERT INTO mlh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jeims Alfiusre made eru Saimon tinaine mo Pururu ŋi mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jeimsre made eru Judas Iskariot. Kariot ŋi oiji jiki babae ŋi fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuji aposolpuine yoŋoke tukuone wakiru moreŋ rondiŋgo raru dimabuŋ. Dimabi kiŋariŋ kubu soguine eru ŋiŋigo kubu sogo yoŋoji iŋore tumaŋgaru odigabuŋ. Yoŋoji “Biŋeine miko manebeneŋ jibenoŋuŋ bobiaŋgaiŋ,” miku ore eru Judia prowins sosowo, Jerusalem siti eru koe qaŋaŋineone Taia eru Saidon taoŋ oone wareru tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Gemokakuji bapeboriŋ eyareya, yoŋoji oŋuakoŋ wareru fiabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Usuŋineji iŋoreone mukuru yoŋoreo ropeko sosowo bobiaŋ yabeya. Ore eru ŋiŋigo sosowoji Yesu bouaiŋgo janjaŋbumbuŋ odebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesuji kiŋariŋpuine qokiraŋgaru ŋone yaberu iŋi yajiya, “Anuture qorumaŋ oi wakiqoqoine yoŋore biŋe. Ore eru wakiqoqoine ŋoŋo kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Damaŋ yoo uqore oŋuine komeru yaimaiŋ qaku gogobi, Anutuji ŋoŋore aŋi oi bomukuiŋ. Ore eru ŋoŋo kiwaqawaineke fukegobi. Damaŋ yoo kuyogobi, ŋoŋoji jeribari eru gouenimiŋ. Ore eru beusembe gogobi, ŋoŋo kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ŋiŋigoji ŋoŋo Sombuŋ eru morende Ŋi foriinere eru rosi eru yoberu sakiŋaŋuŋo ruaru maŋqoqo buŋo fofoine miŋareru qoro sowesembeine oŋuine tinaŋaŋuŋ ketigaru ketotienimiŋ, ŋoŋo kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Apa ŋasopuŋaŋunji ore so kajeqouŋ ŋiŋigo yoŋo eyareku gobuŋ. Maneniŋ! Anutuji furiŋaŋuŋ ropekiine Sombuŋ kaeo ruame pega. Ore eru oŋu eŋarebi damaŋ oo ŋoŋo jerieru kokoriaŋ romaiŋgainebi. ");
INSERT INTO mlh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ŋoŋo kiwaqawaineke gogobiyoŋ, biŋeroro meboŋaŋuŋke ŋoŋo gogo batiqatiine tomiri gogobi, oi tariiŋ. Ore eru nonji ŋoŋore oŋga joraku ‘O yei!’ migo. ");
INSERT INTO mlh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Damaŋ yoo no gaba eru gogobi, ŋoŋo uqore komeru roro gonimiŋ. Ore eru nonji ŋoŋore oŋga joraku ‘O yei!’ migo. Damaŋ yoo jeribari eru gouegobi, ŋoŋo soguŋ baru kuyonimiŋ. Ore eru nonji ŋoŋore oŋga joraku ‘O yei!’ migo. ");
INSERT INTO mlh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Apa ŋasopuŋaŋunji kajeqouŋ ŋiŋigo qaqajibuine mimiteŋ yaberu gobuŋ. Ŋiŋigo sosowo ore so eŋarebi nonji yoŋore oŋga joraku ‘O yei!’ migo.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Sembene eŋarenimiŋyoŋ, ŋoŋo buŋone maneru gogobi, nonji ŋoŋore iŋi ŋajibe maneniŋ: Ŋoŋo rosipuŋaŋuŋ maŋ-ŋaŋunji manjoko eyareru goinebi. Uri yoŋoji rosi eŋaregobi, oi fiine akoŋ eyareku goinebi. ");
INSERT INTO mlh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Uri yoŋoji qaiso eru sowe ŋabegobi, oi romaiŋgaru mifia yareinebi. Pore kane eŋaregobi, yoŋore ore Anuture oŋga wosiinebi. ");
INSERT INTO mlh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Moji maugo mobeine qame aribe oŋuakoŋ bokirie ote. Moji marikugo paiine roru kambaŋgo dikiine oŋuakoŋ roiŋgo maneko go oi so sabareigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Yare karie garebi oi sosowo yareigoŋ. Moji gore mebo yago roko oi kerisie gareiŋ ore so yameŋ keku weuteigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ŋiŋigoji ŋoŋo ya eŋareiŋgo maneegobi, ore so yoŋore oŋuakoŋ eyareru goinebi. ");
INSERT INTO mlh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Morende agiburaŋ ŋiŋigo ogopuyaŋunji manjoko eyarebi tifeine bokirieru manjoko eyareru mimiteŋ eegobi. Ŋoŋo ore so morende kamasi boyobeegobi ine, Anuture tife so fukeko uruŋu ŋoŋo miteŋ ŋabena? Ogopunoŋuŋ eru rosipuŋaŋuŋ oi moko manjoko eyarebi furi ŋareme seŋgiŋbaŋgiŋ fukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Morende agiburaŋ ŋiŋigo ogopuyaŋunji ya fiine eyarebi tifeine bokirie yareru ogo bobo eru mimiteŋ eegobi. Ŋoŋo ore so eru morende kamasi boyobeegobi ine, Anuture tife so fukeko ŋoŋo so miteŋ ŋabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Morende agiburaŋ ŋiŋigoji moneŋ ya oi agiburaŋ ŋiŋigo goine yoŋore yareru tifeine oŋuakoŋ bokirie yarenimiŋgo yameŋ keegobi. Oi morende eebobo. Ŋoŋo goineji tifeŋaŋuŋ bokirie yarenimiŋgo odigabi Anutuji uruŋu miteŋ ŋabena? Goineji tifeŋaŋuŋ so bokirie ŋarebi Anutuji tifeine oi bokirieru furi ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Ŋoŋo Sombuŋ Rauinere eebobo eba eku goinebi. Moreŋ ŋiŋigoji sembene eru daŋge so miegobiyoŋ, Anutuji jibu oi ya fiine eyareega. Ore eru ŋoŋo rosipuŋaŋuŋ manjoko eyareru fiine akoŋ eyareku moneŋ ya yareru ore tife mo bokirie ŋarenimiŋgo so maneru odigainebi. Oŋu eru gobi furiŋaŋunji saueru ropekiine fukeko Anutu ropekiinere odumadepu fukeru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Sombuŋ Mamaŋaŋunji sosowo ŋonemaiŋ eŋareiŋgo manega, ŋoŋo ore so ŋiŋigo sosowo ŋonemaiŋ eyareru goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ŋiŋigo goine yoŋore buŋo oi so osoeru mitariinebi. Oi so mitari yabebi Anutuji ŋoŋo-ŋaŋe oŋuakoŋ so mitari ŋareiŋ. Ŋoŋo goine yoŋore agiburande geo oi so bokirie yareinebi. Oi so bokirie yarebi Anutuji ŋoŋo-ŋaŋunde agiburande geo oi oŋuakoŋ so bokirie ŋareiŋ. Ŋoŋo goine yoŋore agiburaŋ bokeinebi. Oi bokebi Anutuji ŋoŋo-ŋaŋunde agiburaŋ oŋuakoŋ jureru bokeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Ŋoŋo ŋiŋigo goine yoŋore ya eyarebi Anutuji ore so osoeru ya oi bokirieru ŋoŋo oŋuakoŋ eŋareiŋ. Ore eru ŋoŋo ya yauŋ yareeinebi. Oŋu yarebi Anutuji oŋuakoŋ yauŋ ŋareeiŋ. Fofori, Anutuji oi dukuŋ beugoro so maneru bapi ŋabeeiŋ. Anutuji osoeru ŋoŋo ya yarebuŋ, ore soine sosowo roru popugo keseme mau siroŋgo wapeko itiriŋgako sogokoŋ fukeko bodugame rakako jikigaru paiineo keseme soine odureru siŋsaŋ wakiko oi kekereŋaŋuŋgo nikeru ŋareiŋ.” Anuture fuŋne oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesuji soso buŋo mo iŋi yajiya, “Jiŋokombi ŋiŋigo moji jiŋokombi ogoine mo soine meineo roru ogagaiŋ me mata? Oŋu ranobu moko yoŋgo rakaru yapena. ");
INSERT INTO mlh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kiŋarinji qaqajiine so odurega. Qaqajiyaŋunji mamane sosowo poretiŋ qaji yareme mane mukunimiŋ, sosowo yoŋoji qaqajiyaŋuŋ oŋuine fukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Go wamore ogogore jiŋoo kubuke mendaine ŋonegeyoŋ, gakere jiŋoo yo diŋiŋine soguine pega, oi uruŋu so ŋone mukuge? ");
INSERT INTO mlh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gogakere jiŋoo yo diŋiŋine soguine pega, oi so ŋone mukuru uruŋu ore ogogore iŋi minoŋ, ‘Ogone mane! Jiŋogoo paibe kubuke rakaru ŋega, oi soine qopiebe wakiiŋ.’ O maŋkekerisiere sasaki ŋi, go bonieru gakere jiŋoone yo diŋiŋine soguine oi roru bokeigoŋ. Oi roru bokeru poretiŋ ŋone mukuru ogogore jiŋoo kubuke rakaru ŋega, oi soine qopiende wakiiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Yo fiine moji foriine sembene so fukeega. Oŋuakoŋ yo sembene moji foriine fiine so fukeega. ");
INSERT INTO mlh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Geme koruŋine oi atiŋgo fukeko roiŋgo embimbiŋgaegobeneŋ eru gudere foriine oi fobuo fukeko bomukuiŋgo embimbiŋgaegobeneŋ. Ore so yore foriine ŋoneru osoeru fuŋine mane mukuinebi. ");
INSERT INTO mlh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Ŋi maŋgo ya puseko pega, oi mi bibiineji totogo miega. Ore eru ŋi oroinere maŋ rouŋgo ya fiinere moriri pega, iŋoji fiine oi totogo akoŋ miega. Ŋi sembenere maŋ rouŋgo ya sembene pega, iŋoji sembene oi totogo miega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ŋoŋo nonde ‘Ofoŋ Ofoŋ!’ buŋo oi wamore miegobiyoŋ, nonji ya banimiŋ ore miego, oi so reŋgaru baegobi. ");
INSERT INTO mlh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Uri yoŋoji nondeo wareru buŋone maneru reŋgaru egobi, nonji yoŋore fuŋne ŋaduru soso buŋoji mibemiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iŋoji ketigaqoqo ŋi yoore so fukega: Ŋi oiji pi babemiŋ miki yoŋ joroine sikeru rakaru otuŋine ko oŋgiŋ (simeŋ) paio igodoŋgaru basanaŋgame dimaya. Oŋu dimako kueyoiko damaŋgo obu yoiko soguine qaku pi botuineo bapakareyayoŋ, fiine akoŋ baku baporeko dimaya ore bajiiŋgo qaku bibieko sanaŋgaru dimaya. ");
INSERT INTO mlh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Qaku bibieyayoŋ, moji buŋone maneru so reŋgaru ega, iŋoji ketigaqoqo ŋi yoore so fukega: Iŋoji pi babemiŋ miki otuŋine so sikeru sariru moreŋ paio qoti jigo akoŋ ruaru baya. Bako dimako kueyoiko damaŋgo obu yoiko soguine qaku pi botuineo bapakareko pi oi oo akoŋ bakaigame rinduŋgaru wakiya.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuji ŋiŋigo kubu sogo botuyaŋuŋgo goku Biŋe buŋoine sosowo oi yajiru boke yaberu Kaperneam taoŋgo wapeya. ");
INSERT INTO mlh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Oo Rom mamari siŋaŋ more gio ŋiineji jibe bame komeiŋgo eya. Siŋaŋineji iŋore maneko ropekiine fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ore eru Yesure binaŋ maneru Juda yoŋore minebobo goine sore yabeme Yesureo raru iŋi weubuŋ, “Go wareru kiŋaŋ ŋiine bobiaŋgaigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Raru Yesureo roperu yameŋ keku oŋga wosiru mibuŋ, “Sogunenoŋuŋ, mamari siŋaŋ oiji bapi gamiŋ ore so fiine yobu fukega. Ore eru ware. ");
INSERT INTO mlh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mane, iŋoji Juda ŋiŋigo kubu soguine niŋore aŋi maneko ‘Oŋgawowosi pinoŋuŋ bakimiŋ,’ mibeneŋ kotu iŋoji moneŋ ruame babuŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Oŋu mibi maneru yoŋoke raya. Rayayoŋ, mamari siŋande pi bombeŋgako iŋoji ogopuine sore yaberu Yesureo buŋo iŋi ruaya, “O Ofoŋ, noŋ oŋuinemeŋ gobe nonde pi bubuineji kiga guiŋgo mimine manego. Ore eru joi so maneku ware. ");
INSERT INTO mlh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Noŋ nakene manebe wawakiine fukega ore goreo warebemiŋ ore so, so manegoyoŋ, buŋo migo akoŋ minde kiŋaŋ ŋineji fiaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Oi iŋi ore: Noŋ nake oŋuakoŋ siŋaŋnere usuŋ yukumaŋgo rua nubi gogo. Nonde yukumaŋgo mamari ŋi gobi oi mitiga yareego. Yoŋoreone more ‘Raigoŋ!’ mitigabe iŋoji raiŋ. More ‘Wareigoŋ!’ mitigabe iŋoji wareiŋ eru kiŋaŋ ŋine more ‘Gio yo baigoŋ!’ mibe iŋoji oi baiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuji buŋo oi maneru mamari siŋande waragaru ŋiŋigo kubu boyoberu warebuŋ, yoŋoreo kirieru iŋi miya, “Nonji iŋi ŋajibe maneniŋ: Israel kufufuŋ botuŋaŋuŋgo oŋuakoŋ mamanesiŋ soguine oŋuine oi more maŋgo so bofukeboŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Oŋu miko mamari siŋande kiŋaŋ ŋipuji kirieru pigo roperu kiŋaŋ ŋi bofukeru ŋonebi fiaru ŋeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ore ŋadiineo Yesuji taoŋ tinaine Nain oo rako kiŋariŋpuine eru ŋiŋigo kubu sogoji boyoberu rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Oo taoŋ sa mendiine bombeŋgako qoŋgbuŋ mo koboru warebuŋ. Koje more made moakonji komeko taonde ŋiŋigo kubu yasogoji tumaŋgaru yaŋganimiŋ ore warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ofonji koje oi ŋoneru beusembe maneru ojiya, “So kuyo.” ");
INSERT INTO mlh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Oŋu miku raru katapa koboru warebuŋ, oi miko odeniniŋgabi katapa bouaku iŋi miya, “Ŋi jeŋoŋ, go pakere. Noŋ go oŋu gajigo.” ");
INSERT INTO mlh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Oŋu miko qoŋgbuŋ oiji gbore pakereru fuŋgaru buŋo miya. Buŋo miko Yesuji oi maŋgoine oteru ranimire ojiya. ");
INSERT INTO mlh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ŋiŋigo sosowo yoŋoji oi ŋoneru sombuyaŋuŋ maneru Anutu miteŋ garu mibuŋ, “Kajeqouŋ ŋi soguine moji botunoŋuŋgo fukeru goga.” Goineji mibuŋ, “Anutuji kufufuŋine mai nobeko gogobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iŋore biŋe buŋo oi saueru Judia prowins sosowo sagaku moreŋine moreŋine mobemobe oo raru tariya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon Mitimeso ŋiji witi pigo ŋeko kiŋariŋpuineji ya sosowo oi fukeya, ore sunduine ba tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ba tebi maneru kiŋariŋyokaine yoyoka oŋga yateme warebire Ofondeo raru iŋi weu tenimi ore sore yapeya, “Bobooro ŋi wareiŋgo odigabeneŋ goji oi fukege me ŋi mo jiki wareiŋgo odigakimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sore yapeko Yesureo roperu ojibu, “Jon Mitimeso ŋiji iŋi weu garenimi ore sore nopeko waregobere, ‘Bobooro ŋi wareiŋgo odigabeneŋ goji oi fukege me ŋi mo jiki wareiŋgo odigakimiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yesuji damaŋ oo akoŋ ŋiŋigo kokoine jibe wi wako eru gemokakuyaŋuŋke (isotaki) oi bobiaŋ yabeya eru ŋiŋigo jiŋokombi kokoine jiŋoyaŋuŋ botigame piku ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jonde kiŋariŋyokaji roperu weu tebire iŋi bokirieya, “Ya ŋoneru manegobire, ore binaŋ oi raru Jon iŋi ojini: Jiŋokombi yoŋo piru ŋonegobi. Demba yoŋo kadi raru waregobi. Wakoyaŋuŋke yoŋo posikegobi. Kajegi yoŋo buŋo manegobi. Komekiine yoŋo gboreru pakeregobi. Wakiqoqoine yoŋore Bobiaŋ Biŋe mitaniŋgabe maneegobi. ");
INSERT INTO mlh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Oŋu fukeko ŋonebi more manji so sembeako so ŋadi nuiŋ, iŋoji kiwaqawaineke fukega.” ");
INSERT INTO mlh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Oŋu bokirieme Jonde kiŋariŋ yokoji rabire Yesuji fuŋgaru Jonde fuŋne ŋiŋigo kubu sogo yoŋore iŋi mitaniŋgaya, “Ŋoŋo moreŋ buroineo oo wamo ya ŋoneiŋgo rabuŋ? Gbinji sabara puteru romaeŋgame ra wareega, ŋoŋo ŋi oŋuine ŋoneiŋgo rabuŋ me? ");
INSERT INTO mlh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Me wamo ya ŋoneiŋgo rabuŋ? Ŋi marikuine kuririineke keru goya, iŋo ŋoneiŋgo me? Maneniŋ, ŋiŋigo marikuyaŋuŋ quraŋine ŋone aŋiineke keru ra wareru batiqatiine tomiri gogobi, yoŋoji kiŋ koito yoŋore morumboŋ pigo gogobi. Oi moreŋ buroineo mata. ");
INSERT INTO mlh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Me wamo ya ŋoneiŋgo rabuŋ? Kajeqouŋ ŋi mo ŋoneiŋgo me? Fofori, nonji iŋi ŋajibe maneniŋ: Ŋi ŋonebuŋ, iŋoji kajeqouŋ ŋiŋigo goine yadureru fuŋine mo fukega. ");
INSERT INTO mlh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iŋore fuŋne oi ronekoŋ iŋi quraŋgabi pega, ‘Mane, nonji kiŋaŋne mimerereŋ mo sorebe bonieru raru ŋiŋigo maŋyaŋuŋ botiŋgaru gore kadi bataniŋgame goji iŋore ŋadio moreŋgo yuku rakaigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Buŋo oŋu pegayoŋ, nonji iŋi ŋajibe maneniŋ: Ŋigoone madepuyaŋuŋ sosowo fukebuŋ, yoŋore botugo Jonji sosowo yadureru tinabiŋeineke dimaga. Dimagayoŋ, Anuture qorumaŋ maŋgo roperu Anuture tinabiŋe bofukeegobi, yoŋore botugo wakiqoqoine tatariine iŋoji Jon odurega. ");
INSERT INTO mlh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Ŋiŋigo kufufuŋ sosowo eru yoŋore botugo takis roro yoŋoji oŋuakoŋ Jonde Biŋe buŋo manebi miti meso yareya ore Yesure Biŋe buŋo maneru kisiŋgaru mibuŋ, “Aha! Anuture kadi poretiŋ mitaniŋgaga.” Oŋu miku maŋyaŋuŋ kerisiebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Oŋu kerisiebuŋyoŋ, Jonji Farisi eru Kadi buŋore qaqaji miti meso so rau yareya ore yoŋoji Anuture buru so reŋgaru Biŋeine ŋadi gaku keoma ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Ŋiŋigo muŋambe moreŋgo gogobi, oi wamoyake so ke yarenobo? Yoŋore mosi oi uruŋu? ");
INSERT INTO mlh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yoŋoji kokiine oŋuine fukegobi. Yoŋoji nareŋgareŋ kae jiŋoo ŋeku buŋo goue baku kosa oŋgaku iŋi miegobi, ‘Niŋo mimi putebeneŋ ŋoŋo kiki kiraŋ so babuŋ. Niŋo jiŋgeŋ kebeneŋ ŋoŋo so jikigaru kuyobuŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ore fuŋine oi iŋi: Jon Mitimeso ŋiji wareru uqo sowo goku wain obu so noko ŋoŋo iŋore miegobi, ‘Gemo moji maŋineo rakame goga.’ ");
INSERT INTO mlh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","“Sombuŋ eru morende Ŋi foriineji wareru uqo noku jeri ebi ŋoŋoji miegobi, ‘Maneniŋ, iŋoji kanenji nonone akoŋ uqo gaba tomiri noku wain obu kokoine noku takis ŋi eaduyaŋuŋke eru sembene bobo yoŋore ogo goga.’ ");
INSERT INTO mlh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sosowo Anuture maŋgboroŋ kegboreegobi, yoŋore eebobore foriji oi maŋgboroŋyaŋuŋ sagaga, oi noduega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi (Kadi buŋore yameŋyameŋ) ŋi yoŋoreone moji Yesu oi iŋoyoŋunde piineo wareru uqo noiŋgo ore keporeya. Keporeko raru pigo roperu uqo ŋeŋeo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Taoŋ oo agiburaŋ ŋigo mo goya. Iŋoji Yesu Farisi ŋire pigo roperu ŋeku uqo noya, ore biŋeine maneru jiji mumundoŋineke keseme ko sogo mo puseya, oi roru roperu wareya. Sogo oi ko yayagaŋine tinaine alabasta oiji bakine. ");
INSERT INTO mlh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Roperu wareru Yesure kufuo rakaru ŋeku fuŋgaru kuyome jiŋo kuineji keseru rakaru kufuineo rau teya. Rau teme qoru sikiineji kereŋ, sakikeketi baru ketaniŋgame kereŋgako kufuine mudugaru jiji mumundoinekeji rau teya. ");
INSERT INTO mlh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Rau teyayoŋ, Farisi ŋiji Yesu keporeya, iŋoji oi ŋoneru maŋineo iŋi manesuya, “Ŋigo yo agiburaŋineke. Ŋi yo oiji kajeqouŋ ŋi gona ine, iŋoji ŋigo kufuineo bouaga iŋore fuŋne mane mukuna.” ");
INSERT INTO mlh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesuji oi mane mukuru iŋi bokirieru miya, “Saimon, nonji buŋo mo miiŋgo manego.” Miko ojiya, “Qaqaji, soine mikande manebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ojiko Yesuji iŋi ojiya, “Ŋiŋigo yoyokaji moneŋ pigo raru tife ruanimi ore moneŋ siŋande weu tebu. Moji giobobo 500 ore furiine (Kina 5,000), moji giobobo 50 ore furiine (Kina 500) oŋu tife ruanimi ore weu tebu. Weu tebire ore so yateya. ");
INSERT INTO mlh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yateru jiki ‘Tifeŋakuŋ bomukunimi,’ miko moneŋyakuŋ mataeme embimbiŋgabu. Embimbiŋgabire moneŋ pi siŋaŋineji tifeyakuŋ qomukuru ketigaru boke yateya. Boke yateme yokoreone moji oi maŋineji kokoine manjoko eteega?” ");
INSERT INTO mlh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Oŋu weuko Saimonji iŋi bokirieya, “Nonde mamaneo tife soguine ketigaru boke eteya, iŋoji.” Oŋu bokirieme miya, “Go buŋo poretiŋ osoeru mige.” ");
INSERT INTO mlh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Oŋu miku ŋigo iŋore kirieru iŋi ojiya, “Ŋigo yo ŋone. Nonji pigoo wapebe goji kufune jureiŋgo obu mo so naregeyoŋ, ŋigo yo oiji kufune jiŋo kuineji rau teru qoru sikiineji sakikeketi baru ketaniŋgame kereŋgaya. ");
INSERT INTO mlh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Goji mi bibine so mudugageyoŋ, ŋigo yo oiji pigo wapebe oo akoŋ yameŋ keku kufune mudugaru goga. ");
INSERT INTO mlh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Goji qorune jiji so rau naregeyoŋ, ŋigo yo oiji jiji mumundoinekeji kufune rau tega. ");
INSERT INTO mlh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ore eru nonji iŋi mibe mane: Anutuji ŋigo yoore agiburaŋ kokoine oi bokeru jureko ore eru maŋineji noŋ kokoine manji jojoko enarega. Moji agiburaŋ mendaine mo eme Anutuji agiburaŋine mendaine bokeme iŋoji maŋineji kokiine mo oi akoŋ manjoko enareega.” ");
INSERT INTO mlh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Oŋu miku ŋigo oi iŋi ojiya, “Nonji gore agiburaŋ jureru bokego.” ");
INSERT INTO mlh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Oŋu miko ŋi moko uqo noku ŋebuŋ, yoŋoji fuŋgaru yoŋoyoŋe akoŋ iŋi mibuŋ, “Agiburaŋ jureru bokega, iŋoji wamo ŋi fukeiŋgo manega?” ");
INSERT INTO mlh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Oŋu mibuŋyoŋ, Yesuji ŋigo ojiya, “Mamanesiŋgoji munaŋ qa garega. Soine womoo raigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ore ŋadiineo Yesuji roregaru taoŋine taoŋine eru moreŋine moreŋine oo raru Anuture qorumande fuŋne mitaniŋgaru Bobiaŋ Biŋe buŋoji ŋiŋigo maŋyaŋuŋ bapakareru goya. Kiŋariŋpuine 12 yoŋoji iŋoke moko rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Oŋuakoŋ ŋigo goineji iŋoke rabuŋ. Ŋigo oi rone jibe bayabeme gemoji bapeboriŋ eyareko gobi Yesuji bobiaŋ yabeya. Ŋigo oi iŋi: Magdalane ŋigo mo tinaine Maria mibuŋ. Yesuji iŋore maŋgone gemo 7 yobe yabeme wape rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ŋigo mo tinaine Joana. Iŋore ŋoe tinaine Kusa iŋoji kiŋ Herodre morumboŋ pi oo gawmande moneŋ siŋaŋ goya. Ŋigo mo tinaine Susana. Yoŋoji eru ŋigo goine kokoine yoŋoji yoŋoyaŋunde moneŋ meboji Yesu eru kiŋariŋpuine kadio siŋaŋ yaberu kitiŋ yabebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ŋiŋigoji taoŋ so oone poreru Yesureo wareru kubu sogoji tumaŋgabi Yesuji soso buŋo mo iŋi miya: ");
INSERT INTO mlh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ŋi moji uqo koruŋ qopogaru tieiŋgo raya. Raru qopogame koruŋ goineji kadi qaŋaŋgo rakaru ŋebuŋ. Rakaru ŋebi ŋiŋigoji oderu odetapa ebi sowo (uufuŋ) webo yoŋo waperu oi no forebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Koruŋ goineji ko oŋgiŋgo rakaru ŋebuŋ. Rakaru ŋeku oo moreŋ obuineke so bofukeru bobuŋyaŋunji waperu gbaŋiru ŋeririkebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Koruŋ goineji komegbore joruinekeo rakaru ŋebuŋ. Rakaru ŋebi oo sogokoŋ waperu yadureru kefa yabeme boŋeŋgaru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Koruŋ goineji moreŋ fiineo rakaru ŋebuŋ. Rakaru ŋeku pougaru waperu foriyaŋuŋ fiine fukeru handetre so fukeru sauebuŋ.” Buŋo oi miforeru buŋo sogo iŋi oŋgaya, “Moji maŋkajeineke goga ine, iŋoji soso buŋo yo kaje ruaru mane mukuine.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Oŋu miko kiŋariŋpuineji soso buŋo yoore fuŋnere Yesu weu tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Weu tebi miya, “Anuture qorumaŋgo rope gokiminde buŋo sumuŋine oi ŋoŋo totogo ŋajibe mane mukugobiyoŋ, goine yoŋore oi soso buŋoji mibe maneegobi. Oŋu maneru yoŋoyaŋunde jiŋoji ya ŋoneku fuŋine jibu so ŋone mukunimiŋ. Yoŋoyaŋunde kajeji buŋo poretiŋ maneru fuŋine jibu so mane mukunimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Soso buŋo ore fuŋine oi iŋi: Koruŋ qopogaru tiega, oi Anuture Biŋe buŋo. ");
INSERT INTO mlh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Uqo koruŋ kadi qaŋaŋineo rakaru ŋebuŋ, oi iŋi: Ŋiŋigo goineji Biŋe buŋo manegobiyoŋ, oi manebi Sembene Rauineji wareru maŋyaŋuŋ kerisieru Sombunde biŋe egu fukeniminde buŋo koruŋ oi maŋyaŋuŋgone qomukuru oga yabeega. ");
INSERT INTO mlh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Uqo koruŋ qopogame ko oŋgiŋgo rakaru ŋebuŋ, oi ŋiŋigo sosoine mo. Yoŋoji Biŋe buŋo maneru oi beufi paiineo maneru sabareegobiyoŋ, maŋyaŋuŋgo rakaru goduyaŋuŋ so babuŋ ore damaŋ pompoŋine akoŋ manesiŋ garu gobi eesoire damaŋgo waki yabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Uqo koruŋ qopogame komeqore joruinekeo rakaru ŋebuŋ, oi iŋi: Yoŋoji Biŋe buŋo manebi maŋyaŋuŋgo rakaegayoŋ, moreŋgo gogore manebu eru moneŋ mebo rorore manjo fukeru yobiŋ yabeega. Tinabiŋeyaŋuŋke fukenimiŋ ore sase ebi aŋi sanaŋine sembene goineji oŋuakoŋ maŋyaŋuŋgo maŋgaru Biŋe buŋo boŋeŋgaru ŋeegobi. Oŋu fukeko foriyaŋuŋ tomiri aputa (gipeine) fukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Oŋuyoŋ, uqo koruŋ moreŋ fiineo rakaru ŋebuŋ, oi ŋiŋigo yo oŋuine: Yoŋoji Biŋe buŋo kaje ruaru manebi maŋyaŋuŋ fiine kikoine tomiri oo rakame egu jibugaeiŋ ore maneku karieru yameŋ keku siŋaŋ gabi foriyaŋuŋ fiine fiine bofukeegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Moji lambe me doi qureru deroji so kefagaiŋ me ŋeŋe rurumaŋgo so ruaiŋ. Oi matayoŋ, oi ore ŋeŋe paiineo ruame ŋeiŋ. Ŋeru tamaeko goineji pi maŋgo ropeiŋgo manegobi, yoŋoji ore tatamaine ŋoneru soine ropenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Oŋuakoŋ maŋnoŋuŋgo ya mo sumuŋgabeneŋ soŋsoŋgo pega, oi totogo fukeiŋ. Ya mo kefa gabeneŋ pega, oi borombiebi totogo peiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ore eru Anuture buŋo manegobi, oi maŋ wombuŋ-ŋaŋuŋgo ruaru manesuku kegboreru goinebi. Moji mamane-mukuineke goga, Anutuji oi jikigaru oteme sogueiŋyoŋ, moji mamane-mukuine tomiri gogayoŋ, ‘Oike gogo,’ miga, Anutuji mamaneine mendaine oi oŋuakoŋ qomukuru ogagaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesuji oŋu miku goko maŋgo gbopuineji iŋo ŋoneiŋgo warebuŋyoŋ, ŋiŋigo kubu sogoji kekefoŋ eru quŋgabi ore bembeŋgo raiŋgo embimbiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Embimbiŋgaru dimabi moji iŋi ojiya, “Gore maŋgo gbopuji sakibe dimaku go ŋone guiŋgo manegobi.” ");
INSERT INTO mlh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Oŋu ojiyayoŋ, Yesuji iŋi bokirieru yajiya, “Ŋiŋigo yo Anuture Biŋe buŋo maneru reŋgaru kegboreegobi, yoŋoji nonde maŋgo eru seŋgbopu fukegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Una mogo Yesuji kiŋariŋpuine iŋi yajiya, “Niŋo bokeru obu joguŋ petigaru aribe ropeinebeneŋ.” Oŋu miko ogâo moko roperu obu joguŋ paio rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Raru kambaŋ seri gboromurebi gbinji kitiŋgako rabi Yesuji kubaŋ peya. Peko gbiŋ siritemboŋ obu joguŋgo bokeru siri kukugaru ogâ maŋineo rakaya. Rakaru puseiŋgo eme sibirigaiŋgo ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sibirigaiŋgo eru kiŋariŋpuineji raru wiwigaku ojibuŋ, “Ofoŋ Sogunenoŋuŋ, niŋo joguŋgo sibirigaiŋgo egobeneŋ.” Oŋu ojibi maŋine untome gbiŋ eru obu jogunde siri iŋi mitiga yateme usuŋyakunji wakiko niniŋgaru peya. ");
INSERT INTO mlh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oŋu fukeko yajiya, “Ŋoŋore mamanesiŋ oi uro?” Oŋu yajiyayoŋ, yoŋoji waragaku sombuyaŋuŋ maneru mibuŋ, “Yei! Ŋi yo wamo ŋi goga? Iŋoji gbiŋ eru koe siri mitiga yateme miine reŋgagobire.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesuji kiŋariŋpuine yoŋoke jikigaru kambaŋ seri gboromurebi gbinji kitiŋgako raru obu joguŋ petigaru Galili prowins aribe Gerasa moreŋgo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Oo roperu mageŋgo ropeko ŋi gemoineke mo taoŋgone wareru Yesu bofukeya. Ŋi oi jiŋoruŋgo goku qoŋgbunde ko kouŋ sikeru gufubi pebuŋ, oo peku goya. Damaŋ joroine kambaŋ mariku so keru pi more maŋgo so peku goya. ");
INSERT INTO mlh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Gemoji damaŋ joroine poreru qoimo eteko ŋi kokoineji meine maŋguine qaku kufuine gbediji (niginji) kiperu siŋaŋ garu gobuŋyoŋ, nigiŋine oi poreme tiŋako gemoji bapakareko moreŋ buroineo raru kosa goya. Ore eru Yesuji gemoine oi iŋi mitigaiŋgo eya, “Gemo sembene, go waperu ŋi yo bokeru ra.” Oŋu miiŋgo eko Yesu ŋoneru jojoraku moreŋgo bembeŋgo rakaru oŋga jojoraku iŋi oŋgaya, “Ae Yesu, go Anutu ropekiinere made fukege. Go uruŋu enaremiŋgo ore yoo warege? Nonji karie garego: Go joiserereŋ joineke so enareigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Oŋu oŋgako iŋi weuya, “Go tinago mo?” Gemokaku kokoine maŋineo rakaru gobuŋ ore eru “Tinanoŋuŋ Legion migobeneŋ,” mibuŋ. Oi noŋunde buŋoo Rosi kubu sogo. ");
INSERT INTO mlh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Oŋu miku Yesu iŋi karie tebuŋ, “Go yobe noberu gemo yoŋ dikiine tomiri oo rakakimiŋ ore so minoreigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Maŋfuŋyaŋuŋgo tuku tapiine oo kaneŋ kubu soguine mo kegbaŋ maŋineo qojugaru gobuŋ. Ore eru gemo yoŋoji iŋi miku karie tebuŋ, “Go soine minde niŋo kaneŋ yoŋore maŋgo rakagobeneŋ.” Karie tebi “Bio raru rakaniŋ,” mitiga yareya. ");
INSERT INTO mlh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mitiga yareme ŋi maŋgone waperu raru kaneŋ maŋyaŋuŋgo rakabuŋ. Rakabi kaneŋ kubu yoŋoji riŋaru pagaŋgo raru siririkeru obu joguŋgo rakaru noru komebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Oŋu fukeko kaneŋ siŋaŋ yoŋoji oi ŋoneru taoŋ eru kae memendaine oo useru kamieru raru biŋe buŋo oi mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mibi maneru ŋiŋigo jiŋorara yoŋoji ya fukeya, oi ŋoneninde warebuŋ. Wareru Yesureo waperu ŋi maŋgone gemoji wapebuŋ, iŋoji Yesure kufuineo ŋeko bofukebuŋ. Kambaŋ saki komoŋine poretiŋ kiperu maŋine untome mamanesuine sosowo fukeko ŋoneru waragabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ŋi gemoineke iŋoji uruŋu fiaya, oi jiŋoyoŋunji ŋonebi, oi yajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yajibi maneru kokoineji waragaku sombuyaŋuŋ manebuŋ. Ore eru Gerasa morende ŋiŋigo kubu sosowo yoŋoji Yesuji boke yabeiŋgo karie tebuŋ. Karie tebi kirieru raiŋ ore ogâo ropeiŋgo eya. ");
INSERT INTO mlh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ropeiŋgo eko ŋi maŋgone gemo wapebuŋ, iŋoji wareru Yesuke moko raku goiŋgo weuya. Oŋu weuyayoŋ, Yesuji qomukuru soreku iŋi ojiya, ");
INSERT INTO mlh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Go kirieru pigoo raru Anutuji mosi qoqowirie sogo egareya, ore binaŋ minde maneinebi.” Oŋu ojime raru Yesuji mosi qoqowirie sogo eteya, ore buŋo oi taoŋ maŋgo roregaru kae so misaueya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ŋiŋigo sosowo Yesure odigabi kirieru wareme kubuine kubuine baku jerieru keporebi. ");
INSERT INTO mlh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Oŋgawowosi pire buŋo siŋaŋ mo tinaine Jairus iŋoji wareru Yesure maŋfuŋgo rakaru dikanji keru piineo wareiŋgo oŋga wosi teya. ");
INSERT INTO mlh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Madepuine matayoŋ, oduine begu moakoŋ gosaine 12 ore so goku komeiŋgo peya. Yesu kepore tebi rako ŋiŋigoji mobemobe kekefoŋ eru ketuŋbotuŋ etebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ketuŋbotuŋ eteru rabi oo botuyaŋuŋgo ŋigo mo goya. Iŋoji kaindari gosa 12 ore so ŋoneru jibe bame goya. Iŋoji sakisiŋaŋ yoŋore furi moneŋ meboine sosowo bokeru gokame sakisiŋaŋ sosowoji bobiaŋ gaiŋgo embimbiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ŋigo iŋoji Yesure ŋadio raru marikuinere tife sisiine yoŋoko oo akoŋ dariine jigaya. ");
INSERT INTO mlh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesuji weuku miya, “Moji yoŋo nuga?” Oŋu miyayoŋ, ŋiŋigo sosowoji oi mugabi Pitaji ojiya, “Sogunene, ŋiŋigo kubuji kekefoŋ eru keketuŋ eku wareru yoŋo gugobi.” ");
INSERT INTO mlh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Oŋu ojiko Yesuji miya, “Mata, moji yoŋo nuko usuŋne mo rako manego.” ");
INSERT INTO mlh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Oŋu miko ŋigoji “Fuŋnene bofukega,” miku gburugburu qame wareru Yesure maŋfuŋgo dikanji keru jibeinere fuŋne eru yoŋoru oo akoŋ fiaya, ore fuŋine totogo miko ŋiŋigo kubu sosowoji manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Manebi Yesuji iŋi ojiya, “Odune, mamanesiŋgoji bobiaŋ guga. Soine maŋwomoo raigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Buŋo oŋu ojiru dimako oŋgawowosi pire buŋo siŋande pigone moji kiŋaŋ wareru Jairus ojiya, “Odugoji komega! Ore eru qaqajire paio yobiŋ jikigaru so ruaigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ojiyayoŋ, Yesuji buŋo oi maneru oŋgawowosi pire buŋo siŋaŋ iŋi ojiya, “Kokoi so mane. Go maŋmoakoŋ eru noŋ manesiŋ nunde odugoji fiaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Oŋu ojiru iŋore pigo raru ŋiŋigo goine boke yaberu Pita, Jon, Jeims eru odure maŋgo mamaine yoko akoŋ oga yabeme yoŋoyoŋe akoŋ pi maŋgo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ropebi ŋiŋigo sosowoji jiŋgeŋ keku kuyoku soguŋ babuŋyoŋ, Yesuji miya, “Iŋoji so komegayoŋ, kubaŋ pega. Ore eru kuyo bokeniŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Oŋu miko igosisi ore so fukeko “Kome forega!” buŋo oi maneru gou etebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gou etebuŋyoŋ, odu oi meineo roru oŋgaku ojiya, “Odune, pakere.” ");
INSERT INTO mlh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Oŋu ojime iiruineji kirieme oo akoŋ pakereru dimaya. Dimako uqo otebi noiŋgo miya. ");
INSERT INTO mlh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Maŋgo mamaineji oi ŋoneru waragabuyoŋ, Yesuji ya fukeya, ore biŋeine mo mibi egu manenimiŋ ore agi ba yareya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuji kiŋariŋpuine 12 yoŋo tumaŋgabi gemokaku sosowo yobe yabeniminde eru jibe wi bobiaŋganiminde usuŋ tobiri suŋsuŋineke yareya. ");
INSERT INTO mlh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Usuŋ yareru iŋi miku sore yabeya, “Ŋoŋo raru Anuture qorumande fuŋne ŋiŋigo mitaniŋga yareru jibe ŋiŋigo bobiaŋ yaberu goinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Sore yaberu yajiya, “Ŋoŋo kadi ranimiŋ ore ya mo so roru rainebi, toku gbaru mata, kekere mata, kadi tebu mata eru siqojiŋo mata. Mariku tebuine matayoŋ, moakoŋ roinebi. ");
INSERT INTO mlh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Raru pi uro uro ropenimiŋ, oo akoŋ goku gio baku taoŋ oi bokeru kadi rainebi. ");
INSERT INTO mlh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Raru goku pi mogo ropebi so kepore ŋaberu buŋoŋaŋuŋ so manebi ketayaŋuŋ iŋi miku yaduinebi, ‘Niŋo ŋoŋore moreŋgo warebeneŋ rufe kufu tapenoŋuŋgo bakatoga, oi qoigabeneŋ ŋoŋo-ŋaŋundeo kirieru rakaiŋ.’ Oŋu mibi fuŋneŋaŋuŋ posiine mane mukubi soine taoŋ oi bokeru jikigaru rainebi.” ");
INSERT INTO mlh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Oŋu yajiko bokeru raru moreŋine moreŋine roregaru pi so Bobiaŋ Biŋe mitaniŋgaru jibe ŋiŋigo bobiaŋ yaberu gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ya sosowo fukeya, ore tinabiŋeineji saueru moreŋ mobeinere (Galili prowinsre) kiŋ Herod iŋore kajego rakame maneya. Ŋiŋigo goineji iŋi mibuŋ, “Jon Mitimeso ŋiji komegone pakereru goga.” Ore eru kiŋ koitoji buŋore baaru kou baya. ");
INSERT INTO mlh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bayayoŋ, goineji mibuŋ, “Elaijaji moke fukeru goga.” Goineji jikigaru mibuŋ, “Kajeqouŋ ŋi raŋgbaŋine yoŋoreone moji gboreru pakereru goga.” ");
INSERT INTO mlh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Oŋu mibuŋyoŋ, kiŋ Herodji iŋi miya, “Jon Mitimeso ŋi oi nonji mibe ubeine ketigabuŋyoŋ, more buŋo oŋu mibi manego, oi moji?” Oŋu miku Yesu ŋoneiŋgo yameŋ keku origaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sosore ŋi aposol yoŋoji Yesureo kirieru ya eru babuŋ, ore binaŋ sosowo ojibuŋ. Ojibi oga yaberu ŋiŋigo tumoqoqo kae jiŋoyaŋuŋ bokeru taoŋ tinaine Betsaida ore bembeŋgo yoŋoyoŋekoŋ tuhuo gonimiŋ ore rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Rabuŋyoŋ, ŋiŋigo kubu yoŋoji oi maneru Yesu ŋadiineo boyoberu rabuŋ. Raru Yesureo warebi kepore yaberu Anuture qorumande fuŋne mitaniŋgaru jibe ŋiŋigo bobiaŋ yabeya. ");
INSERT INTO mlh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Oŋu eru gome wegi jiŋoine tariru rakaiŋgo eya. Oŋu fukeko kiŋariŋ 12 yoŋoji wareru Yesu iŋi ojibuŋ, “Niŋo moreŋ tuhuo yo oo gogobeneŋ ore go soine ŋiŋigo kubu yo sore yabende kae pi bembeŋgo bembeŋgo ŋe ragobi, oo raru pepe pi eru uqo munjaŋ bofukeinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Oŋu ojibuŋyoŋ, iŋi yajiya, “Ŋoŋoji ŋoŋo-ŋaŋe yoŋo uqo gume yabeniŋ.” Oŋu yajiko bokiriebuŋ, “Niŋo poroŋ 5 eru jembaeŋ yoyoka oi akoŋ baru gogobeneŋ. Ore eru uruŋu enobeŋ? Niŋo soine raru ŋiŋigo kubu yo sosowo yoŋore uqo furiine banobeŋ me? ");
INSERT INTO mlh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Yoŋoji ŋi 5,000 ore so gogobi.)” Oŋu bokiriebi kiŋariŋpuine iŋi yajiya, “Ŋoŋoji ŋiŋigo yajiru boroiŋ yabebi kubu so 50 ore so uqo nonimiŋ ore tumaŋgaru wakiru ŋeinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yajime oŋu eru boroiŋ yabebi ŋiŋigo sosowoji wakiru qokoine qokoine ŋe rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ŋe rabi poroŋ 5 eru jembaeŋ yoyoka oi roru Sombuŋgo pime ropeko mifiaya. Mifiagaru poroŋ bajiru kiŋariŋpuine yareme ŋiŋigo kubu so boroiŋgaru botuyaŋuŋgo ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Botuyaŋuŋgo ruabi sosowo noru gaba yabeya. Uqo tifeine kuŋgaŋine bokebuŋ, oi kiŋariŋ yoŋoji roru qojugabi jambe 12 oo rakaru puseya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Damaŋ mogo Yesuji iŋoyoŋe akoŋ kae mogo oŋga wosiko kiŋariŋpuineji iŋoke gokabi weu yareru iŋi yajiya, “Ŋiŋigoji nonde uruŋu miegobi? Noŋ mo fukego?” ");
INSERT INTO mlh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yajime bokirieru iŋi mibuŋ, “Goineji ‘Go Jon Mitimeso ŋi fukege,’ miegobiyoŋ, goineji ‘Go Elaija fukege,’ miegobi eru goineji jikigaru iŋi miegobi, ‘Go kajeqouŋ ŋi raŋgbaŋine yoŋoreone moji komegone pakereru goge.’” ");
INSERT INTO mlh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Oŋu mibi iŋi weu yareya, “Eme ŋoŋo-ŋaŋe nonde uruŋu migobi? Noŋ mo fukego?” Weu yareme Pitaji bokirieru ojiya, “Go Anuture Munaŋqoqo Rau Kristo fukege.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Oŋu weu yareme fuŋine totogo mibi moji manenimiŋ ore agi sanaŋine bayareya. ");
INSERT INTO mlh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesuji miya, “Sombuŋ eru morende Ŋi foriineji joiserereŋ kokoine maneiŋ. Kantrire minebobo, soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji ŋadi gaku qabi komeiŋ. Komeru una yokaomo fukeko komegone pakereiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuji ŋiŋigo sosowo yoŋo buŋo iŋi yajiya, “Moji nonde ŋadio boyobe nuru wareiŋgo manega, iŋoji iŋoyoŋunde maŋ sakire aŋi sanaŋine sembene ŋadi garu ‘Biŋe gariine roru warega,’ miku misombeŋ ebi joiserereŋ oi koboeine. Yobiŋ oi maripoŋgo komeiŋ ore so maneku karieru noŋ boyobe nuru wareine. ");
INSERT INTO mlh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Moji gogoine iŋoyoŋunde sabareku iŋoyoŋunde aŋigo goga, iŋoji gogoine foriine kipeme jibugaiŋ. Jibugaiŋyoŋ, moji morende gogoine nonde eru kisiŋgaru mitari nareiŋ, iŋoji gogo foriinere fuŋne bofukeru sanaŋgaru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Moji moreŋine moreŋine yoŋore yareya sosowo keporeko biŋeine ra foreme maŋinere gogo bojibugaru keoma goku komeko Anutuji buŋoine mitariko misi korugo rakaru qoqotiineji sibirigame so sagaiŋ. Meboine oiji manjeri so eteiŋ. Mata yobu! ");
INSERT INTO mlh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Moji nonde tina eru Biŋe buŋone bawakiru ruaga, iŋo Sombuŋ eru morende Ŋi foriineji oŋuakoŋ ŋone takigaiŋ. Iŋoji jiki Sombuŋ mimerereŋ tiriine yoŋoke yoo wakibi yoŋore, iŋoyoŋere eru Mamainere kuririquraŋyaŋuŋ ŋoneru popurenimiŋ. Damaŋ oo ŋi me ŋigo oŋuine ŋone takireiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Yo dimagobi, ŋoŋore botugone goineji Anuture qorumande foriji fukeiŋ, oi ŋone mukunimiŋ. Sakike goku komere joiserereŋ so manebi fukeko oi ŋonenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Buŋo oi yajime una 8 ore so tariko Yesuji Pita, Jon eru Jeims oga yaberu tukuo roperu Anutu oŋga wosi eteya. ");
INSERT INTO mlh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Oŋga wosi eteru oo jiŋo maiinere kamasiji qowirieru fuŋine mo fukeya. Marikuineji gbagbataeŋine fukeru buruburuineke tamaeya. ");
INSERT INTO mlh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Oo akoŋ ŋonebi ŋi yoyokaji fukeru Yesuke bubuŋo mimane ebuŋ. Oi Moses eru Elaija. ");
INSERT INTO mlh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kuririquraŋ maŋineo fukeru Yesuke buŋo iŋi mimane ebuŋ, “Anutuji Yesu joiserereŋ maneru komeiŋ ore soreme wakiru pipa Jerusalem sitio rako buru oiji foriineke fuke foreiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Oŋu mimane ebuŋyoŋ, Pitaji ogoyokaine yokoke jiŋoyaŋuŋ yobiŋgame kubaŋ pebuŋ. Pebuŋyoŋ, kubaŋgone maŋyaŋuŋ gboreko jiŋoyaŋuŋ piku Yesure kuririquraŋ eru ŋi yoyoka iŋoke dimabi, oi ŋone yabebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ŋone yabebi dimaku Yesu bokenimi ore ebi Pitaji Yesu ojiya, “Sogunenoŋuŋ, niŋoji yo oo beufi manegobeneŋ. Ore eru niŋoji soine ako yokaomo bakimiŋ: Gore mo, Mosesre mo eru Elaijare mo.” Pitaji oŋu ojiyayoŋ, iŋoyoŋunde buŋore fuŋne oi so mane mukuya. ");
INSERT INTO mlh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Oŋu miku dimako kuaŋ moji wakiru konuineo komoŋ yabeme kuaŋ maŋgo goku waragaku gburugburu yabeya. ");
INSERT INTO mlh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gburugburu yabeko dimabi kuaŋ maŋineone buŋo maru mo iŋi wakiko manebuŋ, “Ŋi yo oi nakene made. Oi ŋiŋigo munaŋ qa yareiŋ ore roosoeboŋ. Ŋoŋo iŋore buŋo maneru goinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Buŋo maru oiji wakiko maneru kiŋariŋ yoŋoji oo akoŋ piku Yesuji akoŋ dimako ŋonebuŋ. Tukuo ya ŋonebuŋ, ore biŋe oi damaŋ oo so miku buŋoyaŋuŋ mataeme gobi moji mo so maneya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Peku pakerebi Yesuji kiŋariŋpuine yokaomo yoŋoke tukuone wakiru pagaŋgo ŋiŋigo kubu sogo ŋone yabebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ŋone yabebi ŋiŋigo kubuone ŋi moji oŋgaku iŋi ojiya, “Qaqaji, nonde made begu fukega ore wareru oi ŋone. Ore eru oŋga wosi garego. ");
INSERT INTO mlh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mane, gemo moji oi bodugame oo akoŋ oŋga jojoraku yoyowo gako suriŋsuriŋ bame miineone tiferuruine wakiega. Gemo oiji poreru ro imagaru damaŋ kokoine so bokeega. ");
INSERT INTO mlh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Oŋu fukeko gore kiŋariŋpuji gemo oi yobenimiŋ ore karie yaregoyoŋ, yoŋoji oi embimbiŋgagobi.” ");
INSERT INTO mlh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Oŋu ojime Yesuji bokirie teru miya, “Yei, morende ŋiŋigo qoqomuku eru iŋgoŋmaŋgoŋineke, nonji damaŋ wojimu ŋoŋoke goku qataŋ ŋabebe Anutu so manesiŋ gabi joiserereŋ maneebemiŋ? Madego ronde yo wareni.” ");
INSERT INTO mlh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Made oi roru wareko damaŋ oo oŋuakoŋ gemoji made furu yoyou eteme yoyowo garu suriŋsuriŋ baya. Oŋu fukeyayoŋ, Yesuji gemo oi miteme bokeme made bobiaŋ garu mamaine oteya. ");
INSERT INTO mlh_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Anuture usuŋ soguineji oŋu fukeko sosowoji oi ŋoneru meayaŋuŋ mukume waragabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Yesuji ya sosowo oi baya, ore eru ŋiŋigo sosowoji waragabuŋ Yesuji damaŋ oo kiŋariŋpuine buŋo koruŋ iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Buŋo yo kaje ruaru maneniŋ: Anutuji Sombuŋ eru morende Ŋi foriine oi moreŋ ŋiŋigo kekesuesueyaŋuŋke yoŋore meo ruako rakaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Buŋo koruŋ oi yajiyayoŋ, oi so mane mukubuŋ. Anutuji oi kefagame soŋsoŋgo peko oi so mane taniŋgabuŋ eru fuŋine uruŋu, oi weu tenimiŋgo fogaturuŋ ebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kiŋariŋ niŋoreone ‘Moji ropekiine fukega?’ miku buŋo oi manesubuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Oi manesubuŋyoŋ, Yesuji maŋ mamanesuyaŋuŋ mane mukuru made mendaine mo roru keririŋineo ruame dimaya. ");
INSERT INTO mlh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Dimako iŋi yajiya, “Sosowo ŋoŋoreone moji wawakiine tatariine fukega, iŋoji ropekiine fukega. Ore eru moji made yo nonde tinao piineo keporeru siŋaŋ gaku maŋgo eteiŋ, iŋoji noŋ kepore nuiŋ. Moji noŋ kepore nuiŋ, iŋoji sore nuya, oi oŋuakoŋ keporeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Damaŋ oo Jonji fuŋgaru buŋo iŋi ojiya, “Sogunene, ŋi moji gore tinao gemokaku yobe yabeme ŋonebeŋ. Iŋoji niŋoke so roregaru goga ore niŋo iŋo qomuku tebeŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Oŋu ojiyayoŋ, Yesuji iŋi ojiya, “Iŋo so qomuku teinebi. Moji so qomuku ŋareega, iŋoji ŋoŋo-ŋaŋunde buruo goga. (Ore eru ŋoŋo nonde ogopu goine oi sisiri egu eyarenimiŋ.)” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuji Sombuŋgo ropeiŋgo eya. Ore damaŋine bembeŋgaga ore Yesuji dimaku “Jerusalem sitio rabemiŋ,” miku misanaŋgaru fuŋgaru kadio raya. ");
INSERT INTO mlh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Raru kiŋaŋ bonieru sore yabeme rabuŋ. Kadio raru goku Samaria prowinsre kae mogo roperu “Yesu wareiŋgo ore boemasaŋ ekimiŋgo ore waregobeneŋ,” mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mibuŋyoŋ, Samaria yoŋoji Juda eru Jerusalem mipemiriŋ eyareebuŋ ore Yesuji “Noŋ Judia prowinsgo Jerusalem soriŋ oobe rabemiŋ,” miya ore pi sabareru momojo buŋoyaŋuŋ so yajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Oŋu ebi kiŋariŋyokaine Jeims eru Jon yokoji oi ŋoneru mibu, “O Ofoŋ, qonikiŋgone misi wakiru ja yabeko mataenobuŋ, oŋu oŋga wosikimiŋgo manege me mata?” ");
INSERT INTO mlh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Oŋu mibuyoŋ, Yesuji kirieru kane yaperu miyateya. ");
INSERT INTO mlh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Oone jikigaru kae mogo rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kadio rakabi ŋi moji wareru Yesu ojiya, “Go uro uro ramiŋ, nonji oo go boyobe guru warebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Oi maneru Yesuji iŋi ojiya, “Gomende qoro yoŋoji ko siroŋyaŋuŋgo pebi sowoo webo yoŋoji youyaŋuŋ baku goegobiyoŋ, Sombuŋ eru morende Ŋi foriineji uro obe raru qoruine wamo roŋguŋgo roegaru pema nena?” ");
INSERT INTO mlh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesuji ŋi more ojiya, “Go wareru noŋ boyobe nuigoŋ.” Ojiyayoŋ, iŋi bokirieya, “Ofoŋ, oi soineyoŋ, mamaneji komeiŋgo ega. Ore eru bonieru minde raru siŋaŋ gabe komeko yaŋ gabe tarime.” ");
INSERT INTO mlh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Oŋu bokirieyayoŋ, Yesuji buŋoine bokirieru ojiya, “Boke! Komeine yoŋoji qoŋgbuŋyaŋuŋ komekiine oi soine yaŋ ganimiŋyoŋ, goji raru Anuture qorumande fuŋne mitaniŋga yareru goigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Moke ŋi moji waperu ojiya, “Ofoŋ, nonji go boyobe gubeminde aŋi manegoyoŋ, mane, go soine minde bonieru pigo raru tifepune momojo buŋoyaŋuŋ mibe tarime.” ");
INSERT INTO mlh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ojiyayoŋ, Yesuji bokirieya, “Moji moreŋ banjaŋgaiŋgo kiju oi bafalo ŋadio kiperu meineji kiju kifuineo roru dimako rako moke kirieru ŋadiineo ŋonega, iŋoji Anuture qorumaŋgo roperu gioine baiŋ ore so, so fukega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ore ŋadiineo Ofonji kiŋariŋ goine 72 oi roosoe yabeya. Iŋoyoŋe “Taoŋine taoŋine kaeine kaeine rabemiŋ,” miku oo yoyoka yoyoka bopo yaberu bonieru sore yabeya. ");
INSERT INTO mlh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","“Sore ŋabebemiŋ,” miku iŋi yajiko manebuŋ, “Anuture gioo uqo foriine kokoine gumuŋgaru pegayoŋ, oi roru qojugakimiŋ ore gio bobo ŋiŋigo noŋuŋ afaineji gogobeneŋ. Ore eru uqo foriine roqojure Rauine oŋga wosi tebi gio bobo ŋiŋigo sore yabeme foriine roru qojuganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Ŋoŋo rainebi. Maneniŋ, lama yoŋoji gomende qoro rigaŋine yoŋore botugo rakabi riŋaru egu ki ŋabenimiŋ, nonji ŋoŋo ore kamasi oŋuine sore ŋabebe ranimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ŋoŋo moneŋ bifuŋ nigiŋ me kekere mo me kufu komoŋ oi so roru rainebi. Raru kadio ŋiŋigo ŋone yaberu midobodo eru momojo buŋoyaŋuŋ so miinebi. ");
INSERT INTO mlh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Raru pi mogo roperu rone iŋi yajiinebi, ‘Anutuji pi yoo womo ŋareme waigo goinebi.’ ");
INSERT INTO mlh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Oŋu mibi moji womo ro sabareiŋ ore so fukeiŋ ine, womoŋaŋunji iŋore paio ropeiŋyoŋ, moji oi so ro sabareiŋ ine, womoŋaŋunji kirieru ŋoŋo-ŋaŋunde paio ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pi ropenimiŋ, oo akoŋ goku gio bainebi. Ŋiŋigoji gio bobo ŋiŋigo gogoŋaŋuŋ kitiŋ ganimiŋ ore so fukegobi. Ore eru yoŋoji uqo eru obu ŋarenimiŋ, oi noinebi. Pi goineo kosabasa so peinebi. Pi buru so ra wareinebi. ");
INSERT INTO mlh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Taoŋ oo me oo ropebi kepore ŋaberu uqo ŋarenimiŋ, oi noinebi. ");
INSERT INTO mlh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Noku goineji oo jibe ba yabeme penimiŋ, yoŋo bobiaŋ yabeinebi. Oŋu eru iŋi mibi maneinebi, ‘Anuture qorumanji bembeŋgo wareme ore maŋgo ropeniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Oŋu einebiyoŋ, taoŋ mogo ropebi ŋadi ŋabenimiŋ, oo nareŋgareŋ kaeo me kae jiŋoo raru iŋi yajiinebi, ");
INSERT INTO mlh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Niŋo ŋoŋore taoŋgo warebeneŋ rufe ya kufu tapenoŋuŋgo bakatoga, oi oderu keririkebeneŋ ŋoŋo-ŋaŋundeo kirieru rakaiŋ. Rakaiŋyoŋ, buŋo yo mane mukuinebi: Anutu qorumanji maŋfuŋ-ŋaŋuŋgo fukega.’ ");
INSERT INTO mlh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nonji iŋi ŋajibe maneniŋ: Anutuji damaŋ sogoo qaqosoriyaŋunde geo kerisieme taoŋ ore paiineo ropeiŋ, so oiji Sodom yoŋore joisererende so oi odureru jikiga ŋareiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“O Korasin rauine, nonji ŋoŋore ‘Yei!’ miku kuyogo eru Betsaida rauine, ŋoŋore oŋuakoŋ ‘Yei!’ miku kuyogo. Nonji yoŋoreo raru buŋone mibe keposikeko mosi qoqowiriene usuŋineke fukeyayoŋ, maŋyaŋuŋ jibu so kerisiebuŋ. Mosi qoqowirie oi kotu moreŋgo Taia (Tiro) eru Saidon sitio fukena ine, yoŋoji damaŋ joroine maŋyaŋuŋ kerisienimiŋ ore sosoine yaduru gijeŋ rau ega kome rauru kuyonobuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Kuyonobuŋyoŋ, Anutuji jiki Korasin eru Betsaida yoŋore buŋo mitariku geoine bokirieme joiserereŋ manenimiŋ, damaŋ sogo oo oi Taia (Tiro) eru Saidon yoŋore joisererende so oi odureru manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Eme Kaperneam rauine, Anutuji ŋoŋo soine romaeŋ ŋabeko Sombuŋ kaeo ropenimiŋ me mata? Mata yobu! Ŋoŋo komere joiserereŋ kaeo rakanimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Moji buŋoŋaŋuŋ maneiŋ, iŋoji nonde buŋo maneiŋ. Moji ŋadi ŋabeiŋ, iŋoji noŋ ŋadi nuiŋyoŋ, moji noŋ ŋadi nuiŋ, iŋoji sore nuya, oi ŋadi gaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kiŋariŋ 72 yoŋoji goku kirieru wareru jerieru iŋi mibuŋ, “Ofoŋ, niŋo gore tinao gemokaku mitiga yarebeneŋ yoŋoji oŋuakoŋ buŋonoŋuŋ yukuineo raru useru rabuŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Oŋu mibi Yesuji bokirieya, “Nonji Satan yobebi Sombuŋgone riŋaru kirabori ore so igogako rakame ŋoneboŋ. ");
INSERT INTO mlh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Maneniŋ, nonji usuŋ ŋarebe ŋoŋo soine kobeŋ, qoti, omeqoqo eru rosinoŋunde usuŋ suŋsuŋ miineke sosowo odebi wakiko gbiŋ enimiŋ. Ore eru ya moji ŋaberu kesibiri so eŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Ore eru gemokaku yoŋoji buŋoŋaŋuŋ yukuineo ragobiyoŋ, jibu ŋoŋore jeribari qoruine oi ore eru so jerieinebi. Ŋoŋore tina Sombuŋ kaeo quraŋgabi Anuture tina buru buk papiago pega, ore eru mokemoke yobu jerieinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Damaŋ oo Moro Tiriineji Yesu dobe gako jerieru buŋo iŋi miya, “O Mamane, goji Biŋe buŋogo maŋgboroŋ ŋiŋigo mamane soguine robuŋ, yoŋoreo sumuŋgameŋyoŋ, ŋiŋigo odumade oŋuine yoŋoyaŋunde manebi qaqouma fukega, oi yoŋore barariŋga yarende mane taniŋgagobi. Ore eru nonji Sombuŋ morende Ofoŋ go miteŋ gugo. O Mamane, go gake oŋu fukeiŋgo manende sagako fiine fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Mamaneji ya sosowo mitigako nonde biŋe fukeya. Mamaneji madeinere fuŋne iŋoyoŋe akoŋ mane mukuko moji oi so manega. Oŋuakoŋ moji Mamainere fuŋne so mane mukuko Madeineji akoŋ oi manega eru ŋiŋigo roosoe yaberu yoŋore oi yadureiŋ, yoŋoji Mama mane tenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesuji oŋu miku kiŋariŋpuine yoŋoreo kirieru yoŋoyoŋe akoŋ kamiine iŋi yajiya, “Uri yoŋoji ŋoŋo ya ŋonegobi, oi ŋoneru jiŋoyaŋunde eru kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ore fuŋine oi iŋi: Nonji buŋo iŋi ŋajibe maneniŋ, Kajeqouŋ ŋiŋigo eru kiŋ koito kokoineji ŋoŋo ya yo ŋonegobi, oi ŋonenimiŋ ore aŋi sogo maneru gobuŋyoŋ, oi so ŋonebuŋ. Ŋoŋo buŋo yo manegobi, yoŋoji oi manenimiŋ ore aŋi sogo maneru gobuŋyoŋ, oi so manebuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kadi buŋore qaqaji moji pakereru Yesu buduŋ ruaru iŋi weu teru ojiya, “Qaqaji, nonji uruŋu eru gogo sanaŋine tatariine tomirire biŋe fukenobo?” ");
INSERT INTO mlh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ojiko Yesuji iŋi bokirieru weuya, “Mosesre Kadi buŋoo buŋo uruŋu quraŋgabi pega? Ore fuŋine oi uruŋu?” ");
INSERT INTO mlh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Weume bokirieru miya, “‘Go maŋgo, qoqotigo, usuŋgo eru mamanesugo jumuine oiji Ofoŋ Anutugo manjoko eteru goigoŋ,’ eru ‘Gake manji jojoko eege, oŋuine akoŋ ŋiŋigo sosowo manjoko eyareru goigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Miko Yesuji bokirieya, “Poretiŋ bokiriege. Oi reŋgaru gogo sanaŋinere biŋe fukemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Oŋu bokirieyayoŋ, Kadi buŋore qaqajiji ‘Oi reŋgaru posiine fukego,’ oŋu manesuku fuŋneine oduteiŋgo maneru Yesu ojiya, “Ŋiŋigo botuyaŋuŋgo go wapeboŋ, yoŋoreone wamore mige? Noŋ mo so manjoko etenobo?” ");
INSERT INTO mlh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Oŋu miko Yesuji bokirieru miya, “Ŋi moji Jerusalem siti bokeru Jeriko kaeo rakaru kadio suroŋqoqo yoŋore meo rakame robuŋ. Roru mebo yaine roru kambaŋine qomukuru jobu qaku bokeru rabi komeiŋgo eru peya. ");
INSERT INTO mlh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Peru odigame soriŋ gio siŋaŋ moji kadi oo akoŋ raru ŋone takireru kadi mobego raru odureru raya. ");
INSERT INTO mlh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Rako odigame soriŋ gio ŋi (Liwait) moji oo waperu ŋoneru oŋuakoŋ takigame odureru raya. ");
INSERT INTO mlh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Rayayoŋ, Samaria prowinsre ŋi moji kadi oi akoŋ raru peya, oo roperu ŋoneru beusembe maneru ŋoneru emboŋ eya. ");
INSERT INTO mlh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","“Ŋoneru emboŋ eru bembeŋgo rakaru wiine jiji eru wain obuineji rau teru komoŋ gaya. Wiine komoŋ garu roru romaiŋgaru doŋgiinere paio ruaru ogaru tumoqoqo pepe pigo raru ruaru siŋaŋ gaya. ");
INSERT INTO mlh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Siŋaŋ garu peku pakereru kae fufurere akoŋ giobobo yoyokare furiine (Kina 20) uduru tumoqoqo pi rauine oteru ojiya, ‘Ŋi yo siŋaŋ garu gokande moneŋ garego, oi so sagaru odureiŋ ine, oi kirieru wareto oo jikigaru garebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ŋi yokaomo fuŋneyaŋuŋ oŋu odubi. Ŋi suroŋqoqo yoŋore meo rakaya, iŋore ogo moji fukeya? Yoŋoreone more manende, iŋo maŋyauŋ eteya?” ");
INSERT INTO mlh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Weu teko bokirieya, “Ŋonemaiŋ oteya, iŋoji.” Oŋu bokirieme Yesuji ojiko maneya, “Go raru oŋuakoŋ eru goigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuji kiŋariŋpuine yoŋoke kadio rabi Ofoŋyaŋunji kae mogo ropeya. Ropeko ŋigo mo tinaine Marta iŋoji kepore teme piineo ropeya. ");
INSERT INTO mlh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta qoine tinaine Maria goya. Iŋoji Ofoŋ ŋoneru bembeŋgo wakiru ŋeku Biŋe buŋo miya, oi kaje ruaru mane jijiweru maneya. ");
INSERT INTO mlh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maneyayoŋ, Martaji jebe gioji poreme ra wareru embiŋqombiŋ eru Yesu ojiya, “Ofoŋ, qoneji boke nuko nakekoŋ kiŋaŋ gio babe manende sagaga me mata? Ore eru Maria minde wareru bapi nuine.” ");
INSERT INTO mlh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ojiko Ofonji bokirieru ojiya, “Marta Marta, go ya fuŋne fuŋne ore manebu maneru manetiqoti eku janjaŋbumbuŋ goku joineke eru dimage. ");
INSERT INTO mlh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Oŋu dimageyoŋ, manebu moakoŋ mo eru ba sanaŋgabeneŋ sagaiŋ. Niŋo ya boakoŋ ore so embimbiŋgagobeneŋ. Mariaji osoeru mande mobe bobiaŋgaiŋ ore roosoeru kiwaqawaineke fukega. Gogore mobe fiine oi moji mo so ogagaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesuji kae mogo oŋga wosiru goko tariko kiŋariŋpuine yoŋoreone moji iŋi ojiya, “Ofoŋ, Jon Mitimeso ŋiji kiŋariŋpuine oŋgawowosire fuŋne qaji yareya, go oŋuakoŋ niŋo qaji noreigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ojiko Yesuji iŋi yajiya, “Ŋoŋo oŋga wosikimiŋ eku iŋi miinebi: Mama, gakere tinaji tiriine peine. Go siŋaŋ nobende qorumaŋgore fori fukeine. (Gore maŋ aŋi Sombuŋgo reŋgaegobi, oi moreŋgo oŋuakoŋ fukeine.) ");
INSERT INTO mlh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Go una so uqo munjaŋ sonoŋuŋgo noreigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Goineji agiburaŋ enorebuŋ, niŋo sosowo yoŋore agiburaŋ oi bokegobeneŋ ine, go ore so niŋore agiburaŋ jure noreigoŋ. Eesoigo egu waki nobeiŋ ore gonji sabare noberu Sembene Rauinere meone bomuku nobeigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesuji jikigaru iŋi yajiya, “Ŋoŋoreone moji ubu joŋiŋgo ogoinere pigo raru wiwigaku iŋi ojiiŋ, ‘Ogone, poroŋ yokaomo narende mobeine jiki bokirieru garebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ogone moji kadio goku nondeo ramume uqone tomiri ore gumebemiŋ ore baago.’ ");
INSERT INTO mlh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Oŋu ojiko ogoineji pi maŋgone iŋi bokirieru ojiiŋ, ‘Go kubaŋ gari enorege. Noŋ mendi keku odaine ruabe odumadepuneji noke makipepenoŋuŋ ramegaru kubaŋ pegobeneŋ. Ore eru pakereru oi gareiŋgo embimbiŋgago.’ ");
INSERT INTO mlh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Oŋu miiŋyoŋ, nonji ŋajibe maneniŋ: Pi rauineji ogoine fukega ore eru so pakereru oteiŋyoŋ, oi jibu yameŋ keku miku dimaga ore oi soine pakereru weuga ore so sosowo oteiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Nonji ore mobeine oi iŋi ŋajibe maneniŋ: Ŋoŋo Anutu oŋga wosiinebi. Oŋga wosibi ya ŋareiŋ. Anuture yare jambae baku baainebi. Oi baabi ŋadume bofukenimiŋ. Dimaku mendigo qainebi. Qabi mendi ro ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Moji Anutu oŋga wosiega, iŋoji ore tifeine raugaiŋ. Yare baaega, iŋoji ya bofukeiŋ. Mendiineo qaega ore mendi ro teiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Mamapune ŋoŋoreone moji iŋi fukega: Madeineji jembaende weume tifeineo qoti oteiŋ ");
INSERT INTO mlh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","me qoqu korunde weuko omeqoqo oteiŋ? ");
INSERT INTO mlh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ore eru ŋoŋo ŋiŋigo sembene fukegobi eru jibu yauŋ fiine fiine oi odumadepuŋaŋuŋ yareniminde manegobi ine, Sombuŋ Mamanoŋunji yauŋine uruŋu sabarena? Iŋore mande eebobo oi nodureru fuŋine mo fukega. Ore eru Moro Tiriinere oŋga wosiru weu tenimiŋ ine, iŋoji aŋiineo Moro oi soreme maŋ-ŋaŋuŋgo rakaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gemoji ŋi mo noŋguŋ bateko mutu gome Yesuji gemoine oi yobeko waperu rako namaŋine wirieko moke buŋo miya. Buŋo miko ŋiŋigo kubu yoŋoji oi ŋoneru waragabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waregabuŋyoŋ, yoŋoreone goineji iŋi mibuŋ, “Iŋoji gemokaku yoŋore koito Gibio iŋore usunji gemo yobe yabeega.” ");
INSERT INTO mlh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oŋu mibi goineji Yesu buŋore budunji furugaiŋgo ore iko eteru iŋi weubuŋ, “Go mitigande qonikiŋgone mosi qoqowirie mo fukeko ŋonekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Weu tebuŋyoŋ, iŋoji maŋ mamanesuyaŋuŋ mane foreru iŋi yajiya, “Kantri uri yoŋore siŋaŋpuji botuyaŋuŋgo kekepari eru pouganimiŋ, yoŋoji sisibiri ebi kantriyaŋunji sembearu sesuine akoŋ peiŋ. Oŋuakoŋ pi more kufufuŋ yoŋoji pouganimiŋ, piyaŋunji siŋsaŋ peiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“Maneniŋ! Satande kufufuŋ yoŋoji oŋuakoŋ botuyaŋuŋgo kekepari eru pouganobuŋ ine, yoŋoji siŋaŋyayabe gioyaŋuŋ banimiŋ ore embimbiŋgabuŋ gemo qorumaŋyaŋunji uruŋu dimana? Ŋoŋo nonde iŋi migobi: Iŋoji Gibiore tobiriji gemokaku yobe yabeega. ");
INSERT INTO mlh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Oŋu migobiyoŋ, maneniŋ, nonji Gibiore tobiriji gemokaku yobe yabenobo ine, ŋoŋore ogopuji more tobiriji oi yobe yabenobuŋ? Ore eru yoŋoji buŋoŋaŋuŋ foriine me mata, oi osoeru mitarinimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Oi mitarinimiŋyoŋ, Anuture usunji nonde me sisine boburogame gemo yobe yabeego ine, Anuture qorumanji ŋoŋoreo wareru fukega. ");
INSERT INTO mlh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ŋi sanaŋine Gibio iŋoji tebe damuineke kae piine siŋaŋ gako meboineji soine peiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Oŋu peiŋyoŋ, ŋi sanaŋ qaŋqaŋine yobu Moro Tiriine iŋoji riŋaru wareru qaku gbiŋ eteru tebe damuine ŋesiŋine peteya, oi sosowo yaororu meboine basiru roru raru ogopuine boroiŋgaru yareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Moji noke so goga, iŋoji kisiŋ nueega. Moji ŋiŋigo nonde tinao tumaŋganimiŋ so kepore yabeega, iŋoji oi boroiŋ yabeega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Gemoji ŋi maŋgone waperu moreŋ buroineo raru kosa roregaru goku ŋema neiŋgo pi baaru mo so bofukeru takigako iŋi miiŋ, ‘Pine bokeru warego, oo moke kiriebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Oŋu miku kirieru piine ofaŋgaru basarigako peya, oi oŋuakoŋ peko bofukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Oŋu bofukeru raru gemokaku goine 7 oga yabeiŋ. Gemokaku 7 oi iŋoyoŋe odureru sembene yobu fukegobi. Iŋoji oi oga yabeme wareru pi oo roperu ore maŋineo gonimiŋ. Oŋu fukeko ŋi iŋore fuŋne rone sembene fukeyayoŋ, jiki sembeqambea foreiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuji buŋo oŋu miku gome ŋiŋigo kubu botuyaŋuŋgone ŋigo moji oŋgaku Yesu iŋi ojime maneya, “Kokone, ŋigoji kuagaru ro guto moŋ gume guya, nonji iŋore manebe kiwaqawaineke fukega.” ");
INSERT INTO mlh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Oŋu ojiyayoŋ, Yesuji iŋi bokirieya, “Oi migeyoŋ, nonji iŋi mibemiŋ: Ŋiŋigo Anuture buŋore kaje ruaru maneru reŋgaru kegboreegobi, yoŋoji kiwaqawaineke fukegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ŋiŋigo kubuji tumaŋgabi sogueme Yesuji jikigaru buŋo iŋi miya, “Ŋiŋigo muŋambe moreŋgo gogobi, yoŋo kufufuŋ kubu sembene. Yoŋoji Anuture mogere yameŋ keegobiyoŋ, moge mo kajeqouŋ ŋi Jonareo fuke foreya. Anutuji moge furuine mo so eŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Buŋo ore fuŋine oi iŋi: Anutuji ronekoŋ Jona soreme Niniwe yoŋore botugo raru Anuture moge fukeya. Ore so Sombuŋ eru morende Ŋi foriineji oŋuakoŋ ŋiŋigo kubu yoore botugo fukeme maŋ-ŋaŋuŋ kerisienimiŋ ore bapakare ŋaberu mogeŋaŋuŋ fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Fuŋneŋaŋunde soso mo oi iŋi: Anutuji ronekoŋ maŋgboroŋ ropekiine sogo oi kiŋ Solomon oteme Saut oobene kantri more kwin ŋigoji Solomonde maŋgboroŋ maneinde aŋi maneya. Aŋiine maneru moreŋ qaŋaŋgone pakereru kadi joroine yobu wareru goku Solomonde mamaneine maneya. Oi maneyayoŋ, maneniŋ, damaŋ yoo nonji botuŋaŋuŋgo fukeru dimaku Anuture maŋgboroŋ ropekiine roru warego, oi Solomonde maŋgboroŋ odurega. Oduregayoŋ, ŋoŋo jibu keta enareku mutu dimabi so sagaga. “Ore eru Anutuji jiki ŋiŋigo sosowo furu yabeme buŋoyaŋuŋ mitariiŋgo ore jiŋo maio ropenimiŋ, damaŋ oo Saut kantrire kwin ŋigo oiji oŋuakoŋ ropeiŋ. Iŋoji ŋiŋigo kubu sogo yo dimagobi, ŋoŋoke moko komegone pakereru ŋoŋore keririŋgo moko dimaiŋ. Moko dimaku buŋo iŋi ŋoŋore sakigo ruaiŋ, ‘Ŋoŋo Yesu keta etebi Anutuji geoine bokirie ŋareme joiserereŋ ropekiine manenimiŋ.’ Iŋoji oŋu ŋajime mosiine osoeru ŋoŋo-ŋaŋunde mimi manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Jonaji Niniwe ŋiŋigo botuyaŋuŋgo raru Anuture buŋoji maŋyaŋuŋ bapakareko maneru oo akoŋ maŋyaŋuŋ kerisiebuŋyoŋ, maneniŋ, nonji botuŋaŋuŋgo fukeru dimaku Jonare eebobo odureru eego. Oŋu eegoyoŋ, ŋoŋo jibu keta enareegobi. “Ore eru Niniwe ŋiŋigoji mimitarire damaŋ sogoo ŋiŋigo kubu soguine yo dimagobi, ŋoŋoke moko komegone pakereru ŋoŋore keririŋgo moko dimanimiŋ. Moko dimaku Niniwe yoŋoji buŋo iŋi ŋoŋore sakigo ruanimiŋ, ‘Ŋoŋo Sombuŋ eru morende Ŋi foriine keta etebi Anutuji geoine bokirie ŋareme joiserereŋ ropekiine manenimiŋ.’ Niniwe yoŋoji oŋu mibi eeboboŋaŋunji ŋoŋo-ŋaŋunde fuŋne barariŋga ŋarebi mimiŋaŋuŋ manenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Moji lambe me doi qureru rouŋ guruineo me deroo so ruaiŋyoŋ, oi ore ŋeŋeo ruaiŋ. Oŋu ruame goineji pi maŋineo ropeiŋgo manegobi, yoŋoji ore tatama ŋoneru soine ropenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gore jiŋo oi maŋ sakigore doi fukega. Ore eru jibe moji jiŋogo so bosembeaga ine, oiji tiŋaru tamae foreko Anuture tatamaji soine maŋgoo ba tamaeko gogogo sosowo tatamaineo gomiŋ. Tatamaineo gomiŋyoŋ, aŋi sanaŋine sembeneji me ya moji jiŋogo bosembearu tatama kejigaga ine, oiji sakire gogogo oŋuakoŋ bokobeko qisiri maŋineo tiŋtuŋ gomiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Oŋu fukeko mane, qisiriji maŋgore tatama kejigako egu kobeiŋ ore rugo baru sisiŋaŋ ee eigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Oŋu ende Anuture tatamaji maŋgo sosowo sagako guruine mo so ubu ega ine, gore sakiji oŋuakoŋ bugeqonikiŋke fukeru jiŋo maigoji tamaega. Doi yasogoji sakigoo igoko buruburuineke batamae guga, gogogo ore so Anuture tatamago rua foreru gomiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuji buŋo oi miforeko Farisi (Kadi buŋore yameŋyameŋ) ŋi moji iŋi miku keporeme, “Go soine nonde pigo roperu ŋeku uqo nokimiŋ.” Oŋu miko raru roperu uqo noiŋgo ore ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bonieru meine so jureru wakiru ŋeyayoŋ, Farisi ŋiji mosi oi ŋoneru waragaya. ");
INSERT INTO mlh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Waragako Ofonji iŋi ojiya, “O Farisi ŋoŋo fofori munaŋqoqo ee eiŋ ore popu eru gombare sakiine jure mukuegobiyoŋ, ŋoŋo-ŋaŋunde manji kejigaga. Oi dukuŋ, omboŋ ebu eru mosi sembeine goine oiji puseko gogobi. ");
INSERT INTO mlh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","“O ŋoŋo, maŋ-ŋaŋuŋ tomiri. Moji sakiine sosowo bofukeya, iŋoji maŋine oŋuakoŋ bofukeya me mata? Ŋoŋo wamore maŋ-ŋaŋunde gio ore eru etaŋqataŋ egobi? Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ore eru ya popu, juago ŋega, oi yauŋ-ŋaŋuŋ ŋiŋigo wakiqoqoine yareinebi. Oŋu ebi Anutuji munaŋ qa ŋareko ŋoŋore ya sosowo gbagbataeŋine peiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“O Farisi ŋiŋigo, yobiŋ paiŋaŋuŋgo ropeiŋ ore oŋga joraku ‘Yei!’ migo. Ŋoŋo uqo munjaŋ sosowo boroiŋgaru mobeine 10:gone moakoŋ Anuture biŋe ruaegobi. Jama, supe eru munjaŋ fuŋne fuŋne oi oŋuakoŋ boroiŋgaru teŋgone moakoŋ oi Anuture biŋe ruaegobi. Pesiŋ oi poretiŋ ruaegobiyoŋ, Kadi buŋore koruŋ qoruine yo odureru bokeegobi: Go Anutu maŋ wombuŋgoji manjoko eteeigoŋ eru ŋiŋigo botuyaŋuŋgo eebobo poretiŋ boyoberu goigoŋ. Buŋo qoruine oi yameŋ keku boyoberu goinebi eru buŋo memenda oi oŋuakoŋ so odureru bokeinebi. ");
INSERT INTO mlh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“O Farisi, yobiŋ paiŋaŋuŋgo ropeiŋ ore oŋga joraku ‘Yei!’ migo. Ŋoŋo oŋgawowosi pigo ŋeŋe bobonio minemine ŋeniminde aŋi maneegobi. Nareŋgareŋ kae jiŋoo me kadio ŋiŋigo ŋone yabebi mijeriŋaŋuŋ enimiŋgo maneegobi. ");
INSERT INTO mlh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","O ŋoŋo, yobiŋ paiŋaŋuŋgo ropeiŋ ore oŋga joraku ‘Yei!’ migo. Ŋoŋo jiŋoruŋ tinayaŋuŋ tomiri ore so fukegobi. Ŋiŋigoji qoŋgbuŋ kouineke uri pega, oi so maneru paiyaŋuŋgo kosabasa oderu ya botiineke yoŋoru kejigaegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesuji buŋo oŋu miko Kadi buŋore qaqaji yoŋoreone moji maneru bokirieru iŋi ojiya, “Qaqaji, go buŋo oŋu miku niŋo oŋuakoŋ mimigaŋgaŋ enorege.” ");
INSERT INTO mlh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Oŋu miyayoŋ, Yesuji buŋo iŋi miya, “O Kadi buŋore qaqaji, ŋoŋore paiŋaŋuŋgo oŋuakoŋ yobiŋ ropeiŋ ore oŋga joraku ‘Yei!’ migo. Ŋoŋo buŋoine buŋoine mitigaru ore begi yobiŋineke oi ŋiŋigo paiyaŋuŋgo ruaru ruabi oi reŋganimiŋ ore yobiŋ yabeme jogbasasanaŋ eegobiyoŋ, ŋoŋo-ŋaŋe oi me sisiŋaŋunji kokiine mo bapi yabenimiŋ ore beusembeŋaŋuŋ mo so peega. ");
INSERT INTO mlh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“O ŋoŋo, yobiŋ paiŋaŋuŋgo ropeiŋ ore oŋga joraku ‘Yei!’ migo. Ŋoŋo kajeqouŋ ŋiŋigo yoŋore jiŋoruŋgo simeŋ ako baku basarigaegobiyoŋ, ŋoŋo-ŋaŋunde apa ŋasopuji oi yabebi komebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ŋoŋo-ŋaŋunde apa ŋasopuji kajeqouŋ ŋiŋigo yabebi komebi ŋoŋoji yoŋore jiŋoruŋgo ako baku simeŋ baegobi. Oŋu baku oiji apa ŋasopuŋaŋuŋ yoŋore eebobo ore qotikeru buŋoyaŋuŋ kitiŋgaku miku munaŋ moge oŋuine dimagobi. ");
INSERT INTO mlh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Ore eru Anutu, maŋgboroŋ Rauine iŋoji iŋi miga, ‘Nonji kajeqouŋ ŋiŋigo eru aposol sore yabebe ŋoŋoreo warenimiŋ. Warebi yoŋoreone goine oi yabebi komenimiŋ eru goine kekesuesue eyarenimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Anutuji Sombuŋ moreŋ bofuke yapeya, damaŋ oone akoŋ fuŋgaru kajeqouŋ ŋiŋigo yabebi dariyaŋuŋ kesiebi wakiya, ore dari geoine sosowo oi ŋiŋigo muŋambe gogobi, oi ŋoŋore paio ropeko joiserereŋ manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelre dariji wakiko oone akoŋ fuŋgaru yaberu waperu goku Zekaraia boji koro alata eru boji soriŋ kubaine yokore botugo qabi dariine wakiko oo tariya. Nonji buŋo iŋi ŋajibe maneniŋ: Dariyaŋunde geoji ŋiŋigo muŋambe gogobi, ŋoŋore paio ropeko joiserereŋ manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“O Kadi buŋore qaqaji ŋoŋo, yobiŋ paiŋaŋuŋgo ropeiŋ ore oŋga joraku ‘Yei!’ migo. Ŋoŋo Anuture mamane rokiminde mendi ki made oi ŋiŋigo yaago roru sabare yareegobi. Ŋoŋo-ŋaŋe ore maŋgo so ropebuŋ eru goineji ore maŋgo ropenimiŋgo egobi, ŋoŋoji oi kiperu sabare yareru gobuŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuji buŋo oŋu miku bokeru rako Kadi buŋore qaqaji eru Farisi yoŋoji fuŋgaru buŋo joineke miteku buŋo fuŋne fuŋne miiŋ ore kokoine weu tebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Weu tebi miineone buŋo mo mijibugame oiji kariŋgame buŋore budunji furugaiŋgo rubabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yesuji buŋoine miko damaŋ botuineo oo ŋiŋigo taoseŋine taoseŋine iŋoreo tumaŋgaru kekepuŋ eru keketuŋ eeku dimabuŋ. Oŋu eru dimabi fuŋgaru kiŋariŋpuine iŋi yajiya, “Ya miine yo: Ŋoŋo Farisi (Kadi buŋore yameŋyameŋ) yoŋore maŋkekerisiere sasaki eeboboyaŋunde sisiŋaŋ eru goinebi. Oi momoki oŋuine fukega. Oi so bokenimiŋ ine, oiji yist rombuŋ oŋuine sogueru bosembe ŋabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Ŋiŋigoji ya iporo babi pega, oi sosowo qaratiebi totogo fukeiŋ. Oŋuakoŋ buŋo sumuŋgabi pega, oi sosowo barariŋgabi mane mukunimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ore eru ŋoŋo buŋoŋaŋunde sisiŋaŋ eku goinebi. Ŋoŋo buŋo qisirigo kamiine minimiŋ, oi tatamago mibi manenimiŋ. Ŋoŋo pi maŋgo guruine mogobe saŋugo kajeŋaŋuŋgo minimiŋ, oi kae jiŋoo totogo mitaniŋganimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ogopune nonji ŋoŋo iŋi ŋajibe maneniŋ: Goineji sakiŋaŋuŋ qo komeru ore ŋadiineo ya mo jikigaru enimiŋgo embimbiŋganimiŋ, yoŋore kokoi so maneku goinebi. ");
INSERT INTO mlh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Oi matayoŋ, more kokoi manebi sagaiŋ, nonji oi ŋadubemiŋ. Mo moji usuŋ roru ŋabeko komebi soro ŋabeme misi korugo rakanimiŋ, iŋore kokoi maneku goinebi. Ŋoŋore buŋo oi moke migo: Iŋore kokoi maneru goinebi. ");
INSERT INTO mlh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Goineji (wirioŋ, wiwisu) 5 oi toiya yoyokaji furi banimiŋ ore eegobiyoŋ, Anutuji yoŋoreone moakonde so niga gaya. ");
INSERT INTO mlh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anutuji maŋgo eŋareko qoru sikiŋaŋuŋ sosowo oŋuakoŋ ose foreru jareyaŋuŋ manega. Ŋiŋigo ŋoŋore furi oi wiwisu kokoine yadureru ropekiine fukega. Ore eru kokoi so maneru goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nonji buŋo mo ŋajibe maneniŋ: Moji noŋ ŋiŋigo jiŋoyaŋuŋgo mifuke nuiŋ, Sombuŋ eru morende Ŋi foriineji oŋuakoŋ iŋo Anuture mimerereŋpu yoŋore jiŋoo mifukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Oŋuyoŋ, moji noŋ ŋiŋigo jiŋoyaŋuŋgo muga nuiŋ, nonji oŋuakoŋ iŋo Anuture mimerereŋpu yoŋore jiŋoo mugabemiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Moji Sombuŋ eru morende Ŋi foriine misoriŋgaru buŋo miiŋ, Anutuji agiburaŋine oi soine bokeiŋyoŋ, moji Moro Tiriine igosisi eteiŋ, iŋore agiburaŋ oi Anutuji so bokeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ŋiŋigoji furu ŋaberu buŋo koroyaŋuŋgo rua ŋabebi oŋgawowosi piŋaŋuŋgo me kiap gawana eru kantriine kantriine yoŋore ŋi koito yoŋore jiŋoo dimanimiŋ, damaŋ oo buŋoyaŋunde tife wamo buŋo uruŋu bokirieru mikimiŋ, ore manebu so einebi. ");
INSERT INTO mlh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Oi iŋi ore: Ŋoŋo buŋo minimiŋ, oi Moro Tiriineji aua oo akoŋ qaji ŋareko minimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ŋiŋigo kubu botuyaŋuŋgone ŋi moji Yesure miya, “Qaqaji, mamanokunji komeko go kakane ojinde mamanokunde meropu boroiŋga nareine.” ");
INSERT INTO mlh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Oŋu miyayoŋ, Yesuji iŋi bokirie teya, “O ŋi, moji ŋokore mimitari rauŋakuŋ fukeiŋ ore igodoŋ nume moreŋ-ŋakuŋ boroiŋganobo?” ");
INSERT INTO mlh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Oŋu miku buŋo iŋi jikigaya, “Mebo tebe marikuŋaŋunji afaine akoŋ me boakoŋ yobu ena ine, jibu gogoŋaŋunde fuŋne oi oo so pega. Gogoŋaŋuŋ so osoeru moneŋ meboo gbediganimiŋ ine, ŋoŋo sibiriganimiŋ. Ore eru roru rokiminde ebu (greed) sosowore sisiŋaŋ eku goinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Oŋu miku soso buŋo mo iŋi yajiya, “Ŋi tinabiŋeineke mo goya. Iŋoji moreŋineo uqo gioine bame touŋmoriri soguine fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Oi fukeko maŋineo iŋi manesuku miya, ‘Nonde rouŋ pi oi mendainemeŋ. Ore eru kurumbu kekereine kekereine, kuso qokoine qokoine, yagoŋ doduine doduine oi uro roru qojuganobo? Uruŋu enobo?’ ");
INSERT INTO mlh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Oŋu miku miya, ‘Noŋ Iŋi ebemiŋ: Noŋ rouŋ pine ketotieru tifeineo rouŋ pi soguine soguine babemiŋ. Oi baku uqo touŋmoririne eru mebone sosowo oo roru qojugabe ŋeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Oo ŋeko nakenere iŋi mibemiŋ: O go kiwaqawaineke! Touŋmoririgo afaine mata pe garega. Ore eru uqo noku jerieru gosaine gosaine batiqatiine tomiri ŋema neku waigo goigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Oŋu miyayoŋ, Anutuji iŋi ojiko maneya, ‘O go, maŋgo tomiri! Nonji damaŋgo ruaru mitariku qoqotigo ubu yoo ogabe komemiŋ. Komende yareya sosowo raugaru gomeŋ, oi more biŋe fukeiŋmeŋ?’ ");
INSERT INTO mlh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Moji iŋoyoŋunde tebe mariku juŋe boreŋ ya roru qojugaegayoŋ, Anutu keririŋineo mande touŋmoririine so pe tega, iŋore yobiŋ soguine oŋu fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesuji kiŋariŋpuine iŋi yajiya, “Oŋu fukeiŋyoŋ, nonji ŋoŋo iŋi ŋajibe maneniŋ: Ŋoŋo moreŋgo goniminde manebu oi iŋi miku so einebi: Niŋo wamo ya roru nonobeŋ eru wamo yaji sakinoŋuŋ komoŋ ganobeŋ? ");
INSERT INTO mlh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sakiŋaŋuŋke gogobi, oiji ya foriine fukeko kambaŋ saki komonji ore wawakiine fukega. Jiŋoŋaŋuŋke gogobi, oiji ya foriine fukeko uqoji ore wawakiine fukega. ");
INSERT INTO mlh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Ŋoŋo sonomeŋ webo ŋoneinebi: Yoŋoji uqo koruŋ so qopogaru tieegobi. Kurumbu foriine so ketigaru rouŋ piyaŋuŋgo so roru qojugaegobi. Seki beyaŋuŋ oi qomukuru (stua) uqo pigo so ruaegobi eru Anutuji oi jibu gume yabeega. Ŋiŋigo ŋoŋore furi oi webo furiyaŋuŋ yadureru ropekiine pega. Oi manesubi raiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Ŋoŋoreone moji manebu eru oŋuine oiji moreŋgo goinde damaŋine oi una moakonde so ba jikigaiŋ me mata? Oi mata yobu. ");
INSERT INTO mlh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Ya mendaine oŋuine enimiŋgo embimbiŋganimiŋ ine, ya goine kokoinere uruŋure manebu enobuŋ? ");
INSERT INTO mlh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ŋoŋo juŋ jariŋ iruine kuririyaŋuŋke oi ŋoneinebi: Yoŋoji kambaŋ sokiyaŋunde ore saka so yomueegobi. Gio ya goine so baegobi eru oi jibu iŋi ŋajibe maneniŋ: Kiŋ Solomonji goul silwaine qojugaru marikuine bugeqonikiŋke keru goyayoŋ, iŋore mariku oi gasau hoŋaru firindua ore so ŋone-aŋiineke so fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","“Juŋ jariŋ iruine omaine oi muŋambe moreŋgo maŋfuŋnoŋuŋgo ŋeko yogo ketebi wakiko bokeru qojugaru rigabi jaiŋ. Oi jibu Anutuji iru oŋuine mo oi oŋuakoŋ fiine akoŋ basarigaega. Ore eru iŋoji ŋoŋo oŋuakoŋ soine komoŋ ŋabeiŋ. Ŋoŋo juŋ jariŋ iruinere so, so fukegobi. Anutuji siŋaŋ ŋabeiŋgo manega, aŋiine oiji ya sosowo yadureru ropega. O ŋiŋigo, mamanesiŋ-ŋaŋunji wamore mendaine fukega? ");
INSERT INTO mlh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Oŋu fukeko ŋoŋo oŋuakoŋ gogoŋaŋunde manebu so einebi. Oi maneru yobiŋgaru iŋi egu minimiŋ, ‘Niŋo wamo uqo obu nonobeŋ?’ Oŋu miku maŋ-ŋaŋuŋ oo so ruaru maŋwawaki fukeru manjo so bofukeinebi. ");
INSERT INTO mlh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kantri so maŋkekerisiere yauraine yoŋoji ya oŋuine sosowo rauganimiŋgo yameŋ keku manjo eegobi. Oi eegobiyoŋ, ŋoŋo uqo kambaŋ yare basiqasi baku embimbiŋgagobi, Mamaŋaŋunji oi mane forega. ");
INSERT INTO mlh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ore manjo so einebiyoŋ, Anuture qorumaŋgo ropenimiŋgo yameŋ keeinebi. Maŋ-ŋaŋuŋ oo ruabi peko iŋoji siŋaŋ ŋaberu ya oŋuine oi oŋuakoŋ jikiga ŋareiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“O nonde kubu mendaine, Mamaŋaŋunji qorumaŋ ŋareiŋgo manega ore kokoi so maneru goinebi. ");
INSERT INTO mlh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Morende moneŋ mebo oi yameŋ keku egu qojuganimiŋ. Ore eru ya pe ŋarega, oi furi baninde ruaru moneŋ poreru mobeine ŋiŋigo wakiqoqoine yauŋ-ŋaŋunde yareinebi. Oŋu ruabi tinabiŋeŋaŋuŋ juŋe boreŋ ore so oi Sombuŋ kaeo peku saueru so mataeiŋ. Moneŋ kekereŋaŋuŋ fuŋine mo oi Sombuŋ kaeo so sembeaiŋ. Wofu pujajaŋ eru kiaŋ bobo yoŋoji paibe roperu ya bosembeanimiŋgo embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","“Yare kuririine roru manende ropega, oiji pi mogobe eko goji maŋgo oŋuakoŋ oo qakatoru gomiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ŋoŋo Anuture gio banimiŋ ore jaueru kambaŋ sokiŋaŋuŋ kipe mukuku kuririŋaŋuŋke dimaku maŋ-ŋaŋunde doiji qurebi jako goinebi. ");
INSERT INTO mlh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Oi yoore so: Pi rauine mo iŋo ŋiŋigo suanjeŋ (bobotumaŋ) jebego wareru jeriekimiŋ ore keporebi raya. Oo rako madepuineji pigo ŋeku kirieinde jiŋoyaŋuŋ sakibe piku pisaqasa eku yameŋ keku odigagobi. Odigaru gobi iŋoji damaŋ oo me oo waperu mendigo qana, yoŋoji oo akoŋ mendi robi wapeiŋ. Ŋoŋo made yoŋore so fukeru jaueru goinebi. ");
INSERT INTO mlh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","“Ofonji kirieru wareme gio bobopuine goineji maŋgari gogobi oŋu bofuke yabeiŋ, yoŋoji kiwaqawaineke fukegobi. Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Iŋoji waperu ketumaŋ yaberu uqo ŋeŋeo ruame ŋebi uqo gume yabeiŋgo jaueru kiŋaŋ yabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Iŋoji ubu joŋiŋgo me kae fufurere oo kirieme goineji maŋgari gobi bofuke yabeiŋ, yoŋoji kiwaqawaineke fukegobi. ");
INSERT INTO mlh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Maŋgari gonimiŋ ore buŋo yo soine manesuinebi: ubu eko suroŋqoqo ŋiji wamo damaŋgo me auago wareiŋ, pi rauineji oi manena ine, iŋoji gariine goku piine soine siŋaŋ bako qajaŋgaru ropeiŋgo embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ŋoŋo ‘Sombuŋ eru morende Ŋi foriineji damaŋ yoo so wareiŋ,’ miku manesunimiŋ, iŋoji damaŋ oo akoŋ wareiŋ. Ore eru ŋoŋo oŋuakoŋ jaueru goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesuji buŋo oŋu miko Pitaji weuya, “Ofoŋ, go soso buŋo yo oi niŋore me ŋiŋigo goine sosowo yoŋore oŋuakoŋ mige?” ");
INSERT INTO mlh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Oŋu weuko Ofonji miya, “Gio bobo ŋiŋigo botuyaŋuŋgo moji qembibiineke fukeru goine yadurega? Goineji gbaŋiru gio bokebi moji mamane-muku fiinere paio yameŋ keku damaŋ so baega, iŋoji kiwaqawaineke fukega. Pi rauineji eeboboine osoeru ŋoneru mogobe raru pire yareya oi iŋore meo ruame siŋaŋine fukeiŋ. Siŋaŋine fukeru kiŋaŋqoqopuine ojiya ore so siŋaŋ yaberu damaŋ poretiŋ oo gume yabeeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Oŋu siŋaŋ yaberu goko rauineji kirieru wareru oŋu ŋoneru ‘Go kiwaqawagake fukege!’ miiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","“Nonji buŋo foriine mo iŋi ŋajibe maneinebi: Rauineji kiwaqawake ojiru meboine sosowore siŋaŋ igodoŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Igodoŋgaiŋyoŋ, gio bobo gbagbaŋine iŋoji maŋineo manesuku iŋi miiŋ ine, ‘Ofoŋnere waware damanji joroine pega.’ Oŋu miku fuŋgaru gio bobo ŋiŋigopuine jebe ruaru jerieru obu sanaŋine noku maŋine jibugako bojiqojibu keoma eru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Oŋu goku damaŋ mogo ofoŋine wareiŋgo so odigaiŋ, iŋo oo akoŋ wareiŋ. Damaŋinere niniga qaqouma gome aua oo akoŋ wareru qaku boserereŋ eteku mitigako buŋoqoqomuku ŋiŋigo oŋuine misi korugo rakaru joiserereŋ maneiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Gio bobo moji Ofoŋinere maŋ aŋi mane mukuyayoŋ, buŋo buruine ojiya ore so jajau so ee eku gioine baku goya, Ofonji ore geoine miko kiperu ŋoŋoruji ate kokoine qaya baya qanimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Oŋu qanimiŋyoŋ, gio bobo ŋi moji Ofoŋinere maŋ aŋi so mane mukuku ya eru bako geoine soine mibi ŋoŋoruji qaniminde so fukega, Ofonji ore geoine miko afaine qanimiŋ. Anutuji more ya kokoine oteya, iŋoji oi basaueme foriine kokoine fukeiŋgo odigaiŋ. Anutuji more yare wiki boakoŋ oteya, iŋoji oi basaueme foriine boakoŋ fukeko bokirie teiŋgo weu teiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nonji moreŋgo jo ruaru putebe ja ra wareiŋgo ore wakibe maŋ aŋine ore boruŋineji ja foreiŋgo ore pega. ");
INSERT INTO mlh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pegayoŋ, oi ‘Jo ruaru putebemiŋ,’ mibe joiserereŋ kokoine joŋ joru oŋuine oi nonde paio roperu kefa nuiŋgo eiŋ. Anutuji oŋuine oiji miti meso fuŋine mo rau nareiŋ. O noŋ koŋkoŋ soguine maneru gobe rau nareko oiji tariiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Iŋi egu manesunimiŋ: Yesuji womo baiŋgo ore eru moreŋgo wakiya. Nonji iŋi ŋajibe maneinebi: Nonji womo baiŋgo ore matayoŋ, nonde eru pougaru roiŋgabi ruge fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Oi iŋi ore migo: Nonde Biŋe buŋoji ŋiŋigo maŋyaŋuŋ bapakareko kerisiebuŋ ore damaŋ yoo fuŋgaru iŋi fukeiŋ: Pi more maŋgo ŋiŋigo 5 yoŋoji botuyaŋuŋgo kekepari eru pouganimiŋ. Adibe yokaomo yoŋoji yoyoka yokoke kekepari ruabi aribe yoyoka yokoji yokaomo yoŋoke roroiŋ eru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mamamade yokoji pougaru rorosi ebire maŋgo-odu yokoji roiŋgaru qoqo ebire yaŋoineji yaŋoine qoqopie ee eru roiŋganimi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesuji jikigaru ŋiŋigo kubu yoŋo iŋi yajiya, “Wegi rarakaineo kae gobureko kuaŋ dabu eko ŋoŋo oi ŋoneru oo akoŋ ‘Kue wareiŋ,’ miegobi. Oŋu mibi kue wareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Saut obeone gbiŋ qako ŋone maneru iŋi miegobi, ‘Kae joineke fukeiŋ.’ Oŋu mibi ore so fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","O maŋkekerisiere ŋiŋigo sasakiine, ŋoŋo qonikiŋ morende kamasiyakuŋ ŋoneru kue wegire fuŋneyakuŋ soine osoeegobiyoŋ, damaŋ yo gogobeneŋ, ore fuŋine so osoeru mane mukubi so sagaga.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ŋoŋo ‘Ya poretiŋ oi uruŋu ekimiŋ,’ miku ore fuŋine oi uruŋure eru ŋoŋo-ŋaŋe so osoeru mitariegobi? Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Rosigoji sakigoo buŋo ruaru buŋo koroineo pore guiŋ ore eko mimitari siŋandeo raru kadi soguineo oo yameŋ keku maŋmoakoŋ eku buŋoŋakuŋ miposikenimi. Oŋu so enimi ine, rosigoji soine ro furu yoyou egareme (jas, majistreit) mimitari ŋire jiŋo maio ropende maneru miko kambantire meo warende witi pigo egu rua guiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nonji iŋi mibe mane, Go oo furigo sosowo ruamiŋ ore so quŋgaru ŋemiŋ. Toiyago tatariine oŋuakoŋ rua foreru tifego bajiru wakimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Damaŋ oo akoŋ goineji waperu Yesu sundu iŋi ojibi maneya, “Galili ŋiŋigo goineji Jerusalem soriŋgo boji rigabi gawana Pailotji miko mamari siŋaŋpuineji oo roperu yabebi komebi dariyaŋuŋ wakiru lama bulmakao dariyaŋuŋke jijibu peya.” ");
INSERT INTO mlh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Oŋu mibi bokirieru iŋi yajiya, “Ŋoŋo ore eru iŋi egu manesunimiŋ: Galili ŋiŋigo yoŋoji Galili ŋiŋigo goine sosowo yadureru agiburaŋ eru gobuŋ ore joiserereŋ oi manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Oŋu matayoŋ, nonji iŋi ŋajibe maneniŋ: Ŋoŋo maŋ-ŋaŋuŋ so kerisienimiŋ ine, ŋoŋo sosowoji oŋuakoŋ sibiriga forenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Me kae tinaine Siloam oo pi joroine moji waki keru ŋiŋigo 18 kema yabeme komebuŋ, ŋoŋo yoŋore iŋi egu manesunimiŋ: Yoŋoji Jerusalem kufufuŋ goine sosowo yadureru agiburaŋ eru buŋoyaŋuŋke gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Matayoŋ, nonji iŋi ŋajibe maneinebi: Ŋoŋo maŋ-ŋaŋuŋ so kerisienimiŋ ine, ŋoŋo sosowoji oŋuakoŋ sibiriga forenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesuji soso buŋo mo iŋi miya, “Ŋi moji gudere yo sariko gioineo waperu dimako ore foriine baaiŋ ore rayayoŋ, mo so bofukeya. ");
INSERT INTO mlh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","So bofukeru gio siŋaŋinere miya, ‘Mane, nonji gudere yo yoore foriine gosa yokaomore so wareru baaboŋyoŋ, mo so bofukeboŋ. Ore eru oi wamore jikigaru morende jiji omaine egu poreiŋ. Ore eru oi keku bokende raine.’ ");
INSERT INTO mlh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Rauineji oŋu miyayoŋ, siŋanji bokirieru ojiko maneya, ‘O ŋi siŋaŋne, oi soine bokende gosa yo moke dimaine. Nonji damaŋ botuineo yoo oo kijuji moreŋ sikeku bogboreru sonjoŋ ruaru roregabe jijiineke fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nonji oŋu ebe gosa ŋadiineo ore foriine soine fukena. Oi so fukeiŋ ine, oi soine keigoŋ.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesuji Sabat kombaŋgo oŋgawowosi pi mogo roperu Biŋe buŋo qaji yareya. ");
INSERT INTO mlh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Oo ŋigo mo ŋeya. Gemoji gosa 18 ore so bakaigame ŋadiine kasigako poretiŋgaiŋgo embimbiŋgaru ŋeku goya. ");
INSERT INTO mlh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuji ŋigo oi ŋoneru oŋga teme wareko iŋi ojiya, “Ŋigo, isotaki jibegoji boke guko fiine fukege.” ");
INSERT INTO mlh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Oŋu miku meine qoruineo ruame oo akoŋ poretiŋgaru Anutu miteŋ gaya. ");
INSERT INTO mlh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Miteŋ gayayoŋ, Yesuji Sabat kombaŋgo ŋigo oi bobiaŋgaya, oŋgawowosi pire siŋanji oi ŋoneru ore eru mane sembeako buŋo fuŋgaru ŋiŋigo kubu yoŋore miya, “Gio bobore damaŋ 6 pega, oo soine wareru bobiaŋ ŋabeiŋ ore miinebi. Oi Sabat kombaŋgo mata.” ");
INSERT INTO mlh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Oŋu miyayoŋ, Ofonji bokirieru iŋi miya, “O maŋkekerisiere sasaki ŋiŋigo, ŋoŋo sosowo bulmakao ŋiine me doŋgiŋaŋuŋ oi Sabat kombaŋgo pigone pirueru oga yabebi obuo raru noegobi me mata? Ŋoŋoreone moji oi so sabare yabeega. ");
INSERT INTO mlh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Maneniŋ! Ŋigo yoji Abrahamde osigida fukeko Satanji kipeme gosa 18:de so goko nonji nigiŋine oi Sabat kombaŋgo piruebe ŋoŋoreo sagaga me mata?” ");
INSERT INTO mlh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Oŋu miko kisopuine sosowo yoŋoji mimiyaŋuŋ manebuŋ eru ŋiŋigo kubu sosowo yoŋoji mosi qoqowirie qembibiineke baya, oi sosowo ŋone mane eru jeriebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuji soso buŋo mo iŋi miya, “Anuture qorumande fuŋne oi uruŋu? Oi wamoyago so kenobo? ");
INSERT INTO mlh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Oi yojuŋ korunde so iŋi fukega: Ŋi moji oi roru gioineo raru sariko pakere sogueru yo fukeya. Yo fukeko sowo webo yoŋoji youyaŋuŋ yo ore tieŋineo ruabuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesuji moke soso buŋo mo iŋi miya, “Anuture qorumaŋ oi wamo yake so kenobo? ");
INSERT INTO mlh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oi yist rombuŋ me flaua bobosoguere so iŋi fukega: Ŋigo moji ‘Poroŋ rigabemiŋ,’ miku yist roru flaua jambe yokaomo oo qodureru babokiri eru ruame ŋeku sosowo sogueya.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesuji raru taoŋine taoŋine eru kaeine kaeine oo Biŋe buŋo qaji yareru raru goku Jerusalem sitio oobe raya. ");
INSERT INTO mlh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Rako moji iŋi weu teya, “Ofoŋ, maŋyaŋuŋ kerisiebi Anutuji munaŋ qa yareko qowirienimiŋ, oi ŋiŋigo afaine me uruŋu?” Weu teko iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ŋoŋo mendi goŋgoŋineo ropeiŋgo janjaŋbumbuŋ oderu jogbasasanaŋ einebi. Nonji iŋi ŋajibe maneniŋ: Ŋiŋigo kokoineji Anuture qorumaŋ maŋgo ropeiŋ ore esoiganimiŋyoŋ, oi embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jiki pi rauineji pakereru mendi keko ŋoŋo damaŋ oo fuŋgaru sakibe dimaku mendigo qaku iŋi minimiŋ, ‘Ofoŋ, go mendi ro nore.’ Oŋu mibi bokirieru iŋi ŋajiiŋ, ‘Noŋ so mane ŋabego. Ŋoŋo urone, oi so manego.’ ");
INSERT INTO mlh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Oŋu ŋajiko ŋoŋo oo akoŋ fuŋgaru iŋi minimiŋ, ‘Niŋoji goke aŋibaŋi ŋeku uqo nobeŋ. Goji roregaru niŋore kae jiŋoo Biŋe qaji noremeŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Oŋu minimiŋyoŋ, iŋoji buŋo iŋi ŋajiiŋ, ‘Ŋoŋo urone, noŋ so mane ŋabego. Ore eru iŋi ŋajibe maneniŋ: Sembene bobo sosowo, ŋoŋo boke nuru useniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Usebi oo Abraham, Aisak, Jeikob eru kajeqouŋ ŋiŋigo sosowo yoŋoji Anuture qorumaŋ maŋgo dimabi ŋone yabenimiŋyoŋ, ŋoŋo-ŋaŋe igo ŋabebi sakibe dimanimiŋ. Fuŋneŋaŋuŋ oŋu bofukeru kuyo jojoraru ŋiraŋ-ŋaŋuŋ kibi qame gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ŋiŋigoine ŋiŋigoine yoŋo wegi wawapeineone eru rarakaineone eru mobemobe Not Saut oone wareru Anuture qorumaŋgo roperu ŋeŋeyaŋuŋ roru uqo munjaŋ noku jeribari eru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Oŋu gonimiŋyoŋ, maneniŋ! Tatariine yoŋoreone goineji fuŋfuŋgaine fukenimiŋ eru fuŋfuŋgaine yoŋoreone goineji tatariine fukenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Damaŋ oo akoŋ Farisi (Kadi buŋore yameŋyameŋ) goineji Yesureo wareru iŋi mibuŋ, “Kiŋ Herodji qokome guiŋgo manega. Ore eru go moreŋ yo bokeru raigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mibi iŋi bokirie yareya, “Ŋoŋo gomende qoro goŋine oi iŋi mibi maneine, ‘Mane! Nonji muŋambe eru yogo gemo yobe yabebemiŋ eru jibe ŋiŋigo bobiaŋ yaberu gobemiŋ. Rabemiŋ, fureme oo roperu gione bomukubemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Kajeqouŋ ŋiŋigo boakoŋ oi Jerusalem sitio yabebi komebuŋ. Moreŋ goineo so jikigaru yabebi komeegobi, ore kamakamasi peme ŋonego. Ore eru nonji muŋambe eru yogo yunekoŋ kadi raru gobemiŋ. Jerusalem ropebe nubi komebemiŋ ine, yoŋore eeboboyaŋuŋ oi jikigaru enimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yesuji miya, “O Jerusalem Jerusalem, ŋoŋo kajeqouŋ ŋiŋigo yabebi komebi Anutuji ŋiŋigo sore yabeme ŋoŋoreo wareegobi, yoŋo koji yabebi komeegobi. Qoqu maŋgoineji madepuine toinere rurumaŋgo ruaru ketumaŋ yabeega, nonji ore so damaŋine damaŋine gore kufufuŋpu kepore qoju ŋabebemiŋ ore maneru goboŋyoŋ, ŋoŋo oi taki ŋabeme go wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Maneniŋ! ‘Anutuji soriŋ piŋaŋuŋ ŋadi game sesuine akoŋ peiŋ.’ Oŋu peiŋyoŋ, nonji iŋi ŋajibe maneniŋ, Ŋoŋo noŋ moke so ŋone nunimiŋyoŋ, jiki damaŋ mo ware fukeme oo ŋone nuru iŋi minimiŋ, ‘Ofonde tinao ware norega, Anutuji iŋo mifia teine.’ Oŋu.” ");
INSERT INTO mlh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yesuji Sabat kombaŋ mogo Farisi (Kadi buŋore yameŋyameŋ) yoŋore minebobo more pigo roperu uqo noya. Noku ŋeko goineji siŋaŋ baru rubabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Oo iŋore jiŋo maio jibe ŋi mo me kufuine obuji nikeru sogueme ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesuji oi ŋoneru fuŋgaru Kadi buŋore qaqaji eru Farisi yoŋo weu yareru iŋi miya, “Sabat kombaŋgo ŋi bobiaŋ garu oŋuine oiji Kadi buŋo odurekimiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Oŋu miyayoŋ, yoŋoji niniŋgaru ŋebuŋ. Ŋebi meineji ŋi oi yoŋoru bobiaŋ garu soreme raya. ");
INSERT INTO mlh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Rako iŋi yajiya, “Ŋoŋoreone more made me bulmakao ŋiine oi Sabat kombaŋgo obu yoŋgo rakaiŋ ine, oi pipa porebi wapeiŋ. Moji oi so poreme wapena?” ");
INSERT INTO mlh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Oŋu weu yareme ore mobeine bokirienimiŋ ore yobiŋgaru buŋoyaŋuŋ mataeme ŋebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Farisi (Kadi buŋore yameŋyameŋ) ŋiji ŋiŋigo uqore kepore yabeya, yoŋoji ŋeŋe miineo paibe bomukuru ŋebuŋ, Yesuji oi ŋoneru ore eru soso buŋo mo iŋi ŋajiya, ");
INSERT INTO mlh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Moji go suanjeŋ (bobotumaŋ) jebere kepore guko oo raru ŋeŋe miine so roru ŋeigoŋ. Oŋu emiŋ ine, goine kepore yabeya, yoŋoreone moji go gadureru tinabiŋeineke egu fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","“Iŋoji wapeko jebe rauineji goreo wareru iŋi mina, ‘Go ŋeŋe yo bokende ropekiine iŋoji ŋeiŋ.’ Oŋu miiŋ ine, go pakereru ŋadiineo yukube wakiru ŋeŋe roru ŋeku mimigo egu manemiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Oŋu matayoŋ, moji kepore guiŋ, go soine ŋeŋe ŋadiineo yukube raru ŋeigoŋ. Oŋu ŋende jebe rauineji waperu ŋone guru miiŋ, ‘Ogone, go soine wareru ŋeŋe miineo paibe raru ŋeigoŋ. Oŋu miko goji ŋiŋigo goke ŋeku uqo nogobi, sosowo yoŋore jiŋoo tinabiŋegoke fukemiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Oi iŋi ore: Yoŋoyaŋunde maŋ ba ropenimiŋ, Anutuji yoŋo sosowo bawaki yabeiŋ. Moji iŋoyoŋe maŋine bawakiiŋ, Anutuji iŋo ba ropeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Farisi (Kadi buŋore yameŋyameŋ) ŋiji ŋiŋigo kepore yabeko jebego ŋebi Yesuji jebe rauine kirieru ŋoneru iŋi ojiya, “Go unare me ubure jebe mo rigaru oo gakere ogopu me kakagbopu oi so kepore yabeigoŋ. Tifepugo me pi ŋiŋigo tinabiŋeyaŋuŋke oi so kepore yabeigoŋ. Oŋuine jebe ore kepore yabemeŋ, oi oŋuakoŋ kepore guru tifego oi bomuku garebi tariiŋ. Oŋu emiŋ ine, Anutuji ore furiine so gareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Oŋu matayoŋ, jebe bomogaru rigamiŋ, go ŋiŋigo wakiqoqoine yoŋo kepore yabeigoŋ. Ŋiŋigo wakiqoqoine, puriŋ eru jiŋokombi fukegobi, yoŋo oŋga yarende sagaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Oi kepore yabende yoŋoji tife bomuku garenimiŋgo embimbiŋgabi go ore eru kiwaqawagake fukeru gomiŋ. Tifeyaŋuŋ oi mo peko gokande posiine yoŋoji komegone pakerebi damaŋ oo Anutuji iŋoyoŋe oi gore bomuku gareiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuji oŋu miko uqo noku ŋekabi yoŋoreone moji oi maneru iŋi ojiya, “Moji Anuture qorumaŋ maŋineo roperu uqo noku ŋeiŋ, nonji iŋore kiwaqawaineke migo.” ");
INSERT INTO mlh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Oŋu ojiko iŋi bokirieya, “Ŋi moji ubure jebe soguine bomogaru rigaru ŋiŋigo kokoine furu yabebi warenimiŋ ore miya. ");
INSERT INTO mlh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jebe damaŋine ware fukeme kiŋaŋqoqoine mo soreme kepore yabeiŋgo ojiya, iŋoji yoŋoreo raru miko manebuŋ, ‘Ya sosowo bomoga forebeneŋ pega. Ore eru soine wareniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Oŋu yajiyayoŋ, oi maneru yoŋoji sosowo fuŋgaru ya goineji gbedigaru usebuŋ. Ŋi fuŋfuŋgaineji miya, ‘Noŋ teniŋ mo furiine baba ore oo raru ŋonebemiŋgo manego. Oiji kipe nuga. Ore eru soine raru ojinde so mane sembea nareine.’ ");
INSERT INTO mlh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ŋi moji miya, ‘Noŋ bulmakao ŋiine 10 furiyaŋuŋ baba, oi kioŋgo kipebe kiju porebi raru gio esoigaru banjaŋgabemiŋ. Oiji kipe nuga ore soine ojinde so mane sembea nareine.’ ");
INSERT INTO mlh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Moji jikigaru iŋi miya, ‘Noŋ ŋigo yane akoŋ furiine baba ore foiŋgo embimbiŋgago.’ ");
INSERT INTO mlh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Oŋu mibi kiŋaŋqoqoji kirieru ŋi siŋaŋine biŋe oi ojiya. Ojiko maneru maŋine jo jako kiŋaŋqoqoine iŋi mitiga teya, ‘Go fofoakoŋ tumoqoqo kae jiŋoo eru kadio raru ŋiŋigo wakiqoqoine, hapeta, kufu meyaŋuŋ kekeriine, jiŋokombi eru puriŋ ŋiŋigo oi oga yabende jebe pi maŋineo yoo wareniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mitiga teya ore so eforeru wareru iŋi ojiya, ‘Ofoŋne, mitiga narege ore so egoyoŋ, ŋeŋe sawaine moke oŋuakoŋ ŋega.’ ");
INSERT INTO mlh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Oŋu ojiko ŋi siŋanji miya, ‘Go tumaqoqo eru akoyaŋuŋgo raru ŋiŋigo ŋe ragobi, oi yameŋ keku furu yabende jebe pi maŋineo waperu puseinebi. ");
INSERT INTO mlh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nonji iŋi ŋajibe maneniŋ: Ŋiŋigo rone kepore yabeiŋgo miboŋ, yoŋoreone moji nonde jebego so waperu uqo munjaŋ so noku aŋiine maneiŋ.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesuji rako ŋiŋigo kubu sogo yoŋoji boyoberu rakabi kirieru iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Moji noke wareru gobemiŋ miki noŋ qaŋaŋine obereo rua nuku maŋgo mamaine, ŋonuŋ madeine, kaka gboine, seŋ baŋaine eru iŋoyoŋunde gogo oŋuakoŋ miine ruaru manji jojoko eyareega, iŋoji nonde kiŋariŋ fukeiŋgo embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Misombeŋ-ŋaŋuŋ babi moji noŋ boyobe nuru joiserereŋ maneru maripoŋgo komeiŋ ore so jaueiŋ, iŋoji nonde kiŋariŋ fukeiŋgo embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ŋoŋoreone moji pi joroine baiŋgo manega ine, iŋoji rone wakiru ŋeku moneŋine pi ba foreiŋ ore so fukega me mata, ore fuŋine osoeru ŋone mukuiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Oŋu so eru pi otuŋine sariru pi ba foreiŋgo ore sasanaŋine so pe teko bokeko omaine dimako ŋiŋigo sosowo oi ŋoneru fuŋgaru miku igosisi egu etenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Oŋu eteru iŋi egu minimiŋ, ‘Ŋi oi fuŋgaru piine bayayoŋ, oi bo foreiŋgo ore so sanaŋgaya.’ Ore so go Yesu boyobemiŋ me mata, oi poretiŋ osoeru mane mukuigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Yesuji buŋo oi jikigaru iŋi miya, “Oŋuakoŋ kiŋ ŋi koito moji kiŋ moke mobemobe quraŋ qaqa eku ‘Jigo qakimiŋ,’ miku uruŋu eiŋ? Iŋoji pipa akoŋ rosi so eteiŋyoŋ, bonieru muraŋpuine furu yabeme tumaŋgaru ŋeku uŋsowoŋ buŋo iŋi mimane enimiŋ, ‘Nonunde ŋipu 10,000 gogobeneŋ eko aribe rosipunoŋuŋ yoŋo 20,000 gogobi. Ŋi koitoyaŋunji yoŋo oga yaberu warebi ŋone yaberu soine sanaŋgaru yabekimiŋ me mata?’ ");
INSERT INTO mlh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","‘So sanaŋgakimiŋ,’ minimiŋ ine, iŋoji rosi kiŋ koitoji jorigo wareko oo akoŋ minebobopu sore yabeme iŋoreo raru womo enimiŋ ore buru mimane enimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Oŋuakoŋ ŋoŋoreone moji ya sosowo pe tega, oi miine ruaiŋ, iŋoji nonde kiŋariŋ fukeiŋgo embimbiŋgaiŋ. Ore eru noŋ miineo rua nubi sagaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Seki oi fiine fukegayoŋ, aŋiine bokeiŋ ine, oi uruŋu bobiaŋgabeneŋ moke aŋiineke fukena? ");
INSERT INTO mlh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yau omaine oi moreŋ jijiineke fukeiŋ ore qojugaru sonjoŋ rua egobeneŋyoŋ, seki aŋiine tomiri oi ya more so sagaiŋ. Mata! Oi omaine moreŋgo bokebeneŋ rakaru omaine yobu peiŋ. (Go oŋuakoŋ nonde kiŋariŋ fukeru botuineo ketigaru boke numiŋ ine, ya omaine fukemiŋ.) Moji kajeineke goga ine, iŋoji buŋo oi mane mukuine.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis eadu eku babuŋ eru agiburaŋ ŋiŋigo goine oi jiŋoraraji Yesure Biŋe buŋo maneiŋgo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Oŋu warebuŋyoŋ, Farisi eru Kadi buŋore qaqaji yoŋoji Yesure eru maŋyaŋuŋ sembeako ŋunuŋ-ŋunuŋ buŋo iŋi mibuŋ, “Ŋi iŋoji agiburaŋ ŋiŋigo ro yaberu yoŋoke ŋeku uqo noga.” ");
INSERT INTO mlh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Oŋu mibuŋ ore Yesuji soso buŋo mo iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ŋoŋoreone more lamapu 100 gokabi yoŋoreone moji jibugaru tiŋtuŋ rako rauineji uruŋu eiŋ? Iŋoji 99 oi moreŋ buroineo boke yaberu raru moakoŋ tiŋtuŋ raya, ore eru baaru raru goku bofukeme tariiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bofukeru manjeri eru gbeoineo ruaru osigaru wareiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pigo wareru ogopuine eru goine bembeŋgo gobuŋ, oi oŋga yareko tumaŋgabi iŋi yajiiŋ, ‘Lamane jibugaya, oi bofukego ore eru ŋoŋo warebi noke jeri ekimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nonji iŋi ŋajibe maneniŋ: Ore so agiburaŋ ŋi moakonji maŋine kerisieiŋ, iŋore eru Sombuŋ kaeo jeribari soguine fukeiŋ. Ŋiŋigo 99 yoŋoyaŋunde jiŋoo posiine poretiŋ fukeru maŋyaŋuŋ kerisienimiŋgo so maneru gogobi, yoŋore eru jeri oŋuine so fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Oŋuakoŋ ŋigo moji silwa moneŋ koruŋ 10 roru gome yoŋoreone moakonji rakaru jibugako uruŋu eiŋ? Iŋoji doi qureru yameŋ keku pi ofaŋgaru baaiŋ. Baaru goku bofukeme tariiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Oi bofukeru ŋigo ogopuine eru ŋigo goine bembeŋgo gogobi, oi oŋga yareko tumaŋgabi iŋi yajiiŋ, ‘Nonde silwa moneŋ koruŋ moakonji jibugaya, oi bofukego ore eru ŋoŋo warebi noke jeribari ekimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ore so nonji iŋi ŋajibe maneniŋ: Agiburaŋ ŋiŋigo moji maŋine kerisieme Anuture mimerereŋpu yoŋoji iŋore eru jeribari ropekiine enimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesuji jikigaru iŋi miya, “Ŋi more madeyokaine yoyoka gobu. ");
INSERT INTO mlh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gboineji mamaine iŋi ojiya, ‘Mamane, go moneŋ mebogo boroiŋgaru mobeine nareigoŋ.’ Oŋu ojiko mamayakunji yareyaine sosowo soyakuŋgo boroiŋgaru yateya. ");
INSERT INTO mlh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Oi yateme made gboineji gio boboine yoyoka yokaomo goku mebo yaine sosowo oi qojugaru roru kantri mogobe raya. Oo raru iŋoyoŋunde aŋigo kadi sogo ŋigo yoŋoke kaneŋ qoro oŋuine qisiri gogo goku moneŋ meboine boke foreya. ");
INSERT INTO mlh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Ya sosowo boke foreko roro soguine fukeru moreŋ sosowo oi sagaya. Iŋoji damaŋ oo fuŋgaru obota fukeru basiqasi eru embimbiŋgaya. ");
INSERT INTO mlh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Embimbiŋgaru kantri ore rauine moreo raru giore weu teme soreme iŋore kaneŋ sago rakaru kaneŋ siŋaŋyaŋuŋ goya. ");
INSERT INTO mlh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Oo gome kaneŋ yoŋoji sako koruŋ nobi ŋoneru ‘Soine oi nobe beune sagana,’ miyayoŋ, iŋo oŋuakoŋ moji so oteya. ");
INSERT INTO mlh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Oŋu goku maŋine untome iŋi miya, ‘Mamanere gio ŋiŋigo wamo afaine yoŋoji gio babi furiine yareme uqo noku gaba yabeme gogobiyoŋ, nonji yoo kitaqata eru roro goku komeiŋgo ego. ");
INSERT INTO mlh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Noŋ pakereru mamanereo kirieru raru iŋi ojibemiŋ, “Mama, noŋ agiburaŋ baku oiji go eru Sombuŋ Rauine buŋoŋakuŋ qomukuru tinaŋakuŋ bosembeaboŋ. ");
INSERT INTO mlh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ore eru goji moke nonde ‘Madene,’ mimiŋ ore so, so fukego. Go soine minde kiŋaŋqoqogo mo fukebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Oŋu miku pakereru mamainereo raya. Raru pi bombeŋgako mamaineji jojorigo aroo dimaku ŋoneko wareko beuine jaŋgame ŋoneru emboŋ eru sanaŋine akoŋ giniŋgaru raru ubeineo keme rakako bibiine mudugaru ‘Madene, ohowe ohowe!’ miya. ");
INSERT INTO mlh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Oŋu eyayoŋ, madeineji ojiya, ‘Mamane, noŋ agiburaŋ eku oiji go eru Sombuŋ Rauine buŋoŋakuŋ qomukuru tinaŋakuŋ bosembeaboŋ. Ore eru goji moke nonde made, mimiŋ ore so, so fukego.’ ");
INSERT INTO mlh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Oŋu ojime mamaineji oo akoŋ kiŋaŋqoqopuine iŋi yajiya, ‘Ŋoŋo pipa mariku kuririineke mo roru wareru ke teniŋ. Resoŋburesoŋ ubeineo keku basarigaru kufu komoŋ kufuineo ke teniŋ. ");
INSERT INTO mlh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Oŋuakoŋ sago raru bulmakao yomaine jijiineke mo ro wareru qaru rigabi noku jeribari ekimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Madene yo komeiŋ eya, iŋoji moke gboreru warega. Iŋoji jibugame Anutuji moke bofukeme fukega.’ Oŋu yajiko fuŋgaru jeribari ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Jeribari ebuŋyoŋ, kakaineji gioo goku kirieru pi bombeŋgaru oo kiki kiraŋ keku boji baru jeriebuŋ, ore fonuŋine maneya. ");
INSERT INTO mlh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Oi maneru kiŋaŋ made mo oŋgame wareko ‘Oi uruŋure egobi?’ miku weu teya. ");
INSERT INTO mlh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Weu teko iŋi ojiya, ‘Gbogoji sakifuru kirieru wareme mamagoji oi moke ogaru keroŋgaru ore eru yajiko bulmakao yomaine jijiineke qaku rigaru jeriegobi.’ ");
INSERT INTO mlh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Oŋu ojime maŋine rigaŋgame pigo ropeiŋgo taki gaya. Taki gayayoŋ, mamaineji oi maneru sakibe wakiru maŋwomo buŋo waigoo miku bomiriŋ gaya. ");
INSERT INTO mlh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bomiriŋ gayayoŋ, iŋoji bokirieru iŋi ojiya, ‘Mamane, nonji gosa kokoine kiŋaŋgo qaku goku mimitigo damaŋ mogo so odureru goboŋyoŋ, jibu goji damaŋ mogo noniŋ made mo ogopune yoŋoke jeri ekimiŋ ore so naremeŋ. ");
INSERT INTO mlh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","So naremeŋyoŋ, madego yoji kadi sogo ŋigo yoŋoke goku moneŋ mebogo sibirigaru wapeko goji iŋore eru yajinde bulmakao yomaine jijiineke qaku rigagobi.’ ");
INSERT INTO mlh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ojiko mamaineji iŋi bokirieru miya, ‘Madene, go damaŋ so nakeke goege. Ore eru nakene biŋe sosowo oi gore biŋego oŋuakoŋ fukega. ");
INSERT INTO mlh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Oŋuakoŋ fukegayoŋ, gbogo yoji komeiŋ eyayoŋ, moke gboreru kirieru warega. Iŋoji jibuga foreyayoŋ, Anutuji oi moke bofukega. Ore eru muŋambemeŋ uqo jeribari ebeneŋ sagaga.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuji kiŋariŋpuine buŋo mo iŋi yajiko manebuŋ, “Ŋi tinabiŋeineke more mebo siŋaŋine mo goya. Goineji wareru ŋi tinabiŋeineke oi buŋo kipoŋ ojibuŋ, ‘Iŋoji gore moneŋ mebo ketotieru kosa bokeru goga.’ ");
INSERT INTO mlh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Oi maneru siŋaŋ oi miko wareko miteya, ‘Noŋ gore biŋe sembene mibi manego. Go nonde pi eru mebo moke siŋaŋ gamiŋ ore so, so fukege. Ore eru oi uruŋu siŋaŋ garu gokande, ore mimitaniŋ papia quraŋga nareigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Oŋu miko maŋineo iŋi manesuya, ‘Pi rauineji siŋaŋyayabe gione naago roko uruŋu enobo? Tobirine so sagaga ore moreŋ sikebemiŋgo embimbiŋgago eru rorogaru omaine karieru gobemiŋgo mimine manego. ");
INSERT INTO mlh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Iŋoji siŋaŋyayabe gione naago roiŋ, nonji damaŋ oo uruŋu ebe goineji piyaŋuŋgo keporeru maŋgo enarenobuŋ? Aha! Kadi mo manesugo.’ ");
INSERT INTO mlh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Oŋu miku ŋiŋigo rauineji tife eyareya, oi sosowo iŋoyoŋe kepore yabeme warebuŋ. Fuŋfuŋgaineji wareko iŋo iŋi ojiya, ‘Raunere tife goreo wojimu pega?’ ");
INSERT INTO mlh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Oŋu weuko miya, ‘Oil dram 100 roboŋ.’ Oŋu miko iŋi bokirieya, ‘Go tife papiago roru yoo ŋeku pipa kerisieru 50 quraŋgande peine.’ ");
INSERT INTO mlh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Oŋu miku ŋi mo weu teya, ‘Eme go? Gore tife wojimu pega?’ Weume iŋi miya, ‘Wit flaua oi 21,000 kilogram roboŋ.’ Oŋu miko ojiya, ‘Go tife papiago roru oo 16,800 kilogram oŋu quraŋgande peine.’ ");
INSERT INTO mlh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Oŋu fukeko pi rauineji maneru mimifi buŋo iŋi miya, ‘Siŋaŋneji eadu paiineo ya eya, oi maŋgboroŋ fiine naduga.’” Ofoŋ Yesuji sundu oŋu miku jikigaru miya, “Qisirire eebobo boyobeegobi, yoŋore mamane-mukuyaŋuŋ oi ŋiŋigo goine muŋambe gogobi, oi eadu eyarenimiŋ ore so pegayoŋ, Anuture tatamago gogobi, yoŋore mamane-mukuyaŋuŋ oi ore yukuineo fukega. ");
INSERT INTO mlh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ore eru iŋi mibe maneniŋ: Goineji morende moneŋ meboji ŋiŋigo eadu yabeegobiyoŋ, ŋoŋoji oiji roru ogopuŋaŋuŋ bofuke yabeinebi. Oi bofuke yabebi morende yaji mataeiŋ, Anutuji damaŋ oo kepore ŋabeko gogo sanaŋinere kaeo roperu tatariine tomiri gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Moji ya mendaine roru yameŋ keku poretiŋ siŋaŋ gaga, iŋoji ya soguine oŋuakoŋ poretiŋ siŋaŋ gaiŋ. Moji ya mendaine siŋaŋ garu bobojibu eega, iŋoji ya soguine oi oŋuakoŋ siŋaŋ gaiŋ ore mibeneŋ bobojibu eiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Morende moneŋ mebo meyaŋuŋgo ruabi oi poretiŋ so siŋaŋ gabi foriine so fukeya ine, moji ya biŋeine ropekiine foriine oi meyaŋuŋgo so ruaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ŋoŋo goine yoŋore ya oi poretiŋ so siŋaŋ gabi foriine so fukeya ine, ŋoŋo-ŋaŋunde mande biŋe foriine oi moji mo ŋarena? ");
INSERT INTO mlh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kiŋaŋqoqo moji ofoŋ yoyoka kiŋaŋ qayateiŋgo embimbiŋgaega. Moji oŋu eiŋgo manega, iŋoji mo rosi eteru mo maŋineji jojoko eteiŋ. Moreo qakatoru mo mipemiriŋ eteiŋ. Ore eru ŋoŋoji Anutu eru moneŋ mebo oi qodureru kiŋaŋ qa yateiŋgo embimbiŋganimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi (Kadi buŋore yameŋyameŋ) yoŋoji borende aŋi kokoine pe yareko gobuŋ ore Yesuji buŋo sosowo oi miya, oi maneru jiŋotitiki ŋoneku igosisi etebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Igosisi etebi iŋi yajiya, “Farisi ŋoŋoji ŋiŋigo jiŋoyaŋuŋgo posiine oŋuine yadunimiŋ ore joineke eegobiyoŋ, Anutuji maŋ-ŋaŋunde fuŋne mane muku forega. Ŋiŋigo jiŋoyaŋuŋgo ya more manebi ropekiine fukega, oi Anutuji ŋoneko mamagiineke fukeega. ");
INSERT INTO mlh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Qorumande fuŋne oi Mosesre Kadi buŋoo eru kajeqouŋ ŋiŋigo yoŋore Biŋe Quraŋgo quraŋgabi osegaru go wapebeneŋ Jonji fukeru foriine totogo barariŋga yareya. Damaŋ oone fuŋgaru buŋo oi misaueku Anuture qorumaŋgo ropenimiŋ ore ŋiŋigo maŋyaŋuŋ romaeŋgaegobeneŋ. Ŋiŋigo sosowoji janjaŋbumbuŋ oderu yameŋ keku qorumaŋ ore maŋineo ropeiŋgo eegobi. ");
INSERT INTO mlh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sombuŋ morenji mata enimi ore so egobireyoŋ, Kadi buŋore quraŋ sipaine moakoŋ oi damaŋ mogo so yobu mataeiŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ŋi moji ŋonuŋine bokeru ŋigo mo roiŋ, iŋoji jikiboti eiŋ. Ŋi moji ŋigo ŋoeineji bokeya, oi roiŋ, iŋoji oŋuakoŋ jikiboti eiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ŋi biŋeroroineke mo goya. Iŋoji kambaŋ mariku yojuŋ iruine boboroŋ kuririineke keru goku damaŋ so nojeri eru batiqatiine tomiri goya. ");
INSERT INTO mlh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oŋu goyayoŋ, iŋore pi mendiine bembeŋgo ŋi wakiqoqoine mo tinaine Lazarus peku goya. Wi jokuji sakiine sagaku ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Uqore komeme pi yukuo peku ŋirauinere uqo ŋeŋeone uqo kuŋgaŋine wakiko oi noiŋgo maneya. Maneru eko qoro yoŋoji waperu wi jokuine abureru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Oŋu goku wakiqoqoine iŋoji komeya. Komeko Sombuŋ mimerereŋ yoŋoji ogaru roperu seŋgiŋbaŋgiŋ kaeo ruabi Abrahamde keririŋgo ŋeya. Ŋi biŋeroroineke iŋoji oŋuakoŋ komeko yaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yaŋ gabi komere misoŋ kaeo rakame misiji jame joiserereŋ soguine maneru pime ropeko Lazarus Abrahamde keririŋgo jorigo aroo ŋeko ŋone yapeya. ");
INSERT INTO mlh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ŋone yaperu jojoraku oŋgaku miya, ‘O mamane Abraham, beusembe mane nare. Noŋ misi borunji ja nuko yoo ŋeriŋetataŋ ropekiine maneru dimago. Ore eru go Lazarus sorende raru me tifeineji obuo igoru wareru namaŋne rau teko munaŋgaine.’ ");
INSERT INTO mlh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Oŋu miyayoŋ, Abrahamji bokirieya, ‘Madene, go yo manesunde raya. Goji moreŋgo gogo jeriineke gokande tariyayoŋ, Lazarusji moreŋgo gogoine qapeqawaki eru goya. Oŋu goyayoŋ, damaŋ yoo bobomiriŋ etebeneŋ ŋegayoŋ, goji joiserereŋ maneru ŋeriŋetataŋ paiineo dimage. ");
INSERT INTO mlh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Oŋu gogobeneŋ eru jikigaru iŋi migo: Anutuji niŋo eru ŋoŋo botunoŋuŋgo boroiŋgaru ruge rua sanaŋgako pega. Ore eru goineji ruge kigaru niŋoreone ŋoŋoreo wapekimiŋgo manenobuŋ, oi embimbiŋganimiŋ. Oŋuakoŋ aribe aroo gogobi, ŋoŋoji oŋuakoŋ niŋoreo wapeiŋgo quŋganimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Oŋu miko iŋi ojiya, ‘Mamane, oŋu fukeko iŋi karie garego: Goji Lazarus sorende mamanere pigo raiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pi oo kakagbopune 5 gogobi, yoŋoji oŋuakoŋ misoŋ kae yoo wakiru joiserereŋ soguine egu manenimiŋ. Ore eru minde raru kajeqouŋ buŋo yajiko manenimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Oŋu karieyayoŋ, Abrahamji miya, ‘Mata! Mosesre Kadi buŋo eru kajeqouŋ ŋiŋigo yoŋore Biŋe Quraŋ oi yoŋore biŋe pega. Buŋo oi kaje ruaru maneinebi!’ ");
INSERT INTO mlh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Oŋu miko iŋi miya, ‘O mama Abraham, oŋu matayoŋ, komekiine niŋoreone moji yoŋoreo rana ine, yoŋoji maŋyaŋuŋ kerisienobuŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Miko Abrahamji iŋi ojiya, ‘Yoŋoji Moses eru kajeqouŋ ŋiŋigo yoŋore buŋore kaje so ruagobi ine, oŋuakoŋ komekiine niŋoreone moji pakereru buŋo mina ine, yoŋoji jibu Anutu so manesiŋ ganobuŋ.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuji kiŋariŋpuine buŋo iŋi yajiya, “Sembenere babotikiji afaine fukeega. Moji babotiki sabareiŋgo embimbiŋgaegayoŋ, mo moji goine yoyoiŋ eyareme agiburaŋ enimiŋ, iŋore eru oŋga rurugaku ‘Yei!’ oŋga jorago. Joiserereŋ ropekiineji iŋore paio ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Iŋoji ŋiŋigo mendaine yoŋoreone mo suruyoiŋ eteko agiburaŋ eiŋ, ŋi iŋoji yobiŋ ropekiine bofukeiŋ. Anutuji yobiŋ ore geoine uruŋu oteme soineo fukena? Karoŋaŋ oŋgiŋ ubeineo kiperu koe botuineo bokebi rakana, oiji afaine fukena. ");
INSERT INTO mlh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Ore eru ŋoŋo-ŋaŋe sisiŋaŋ eku goinebi. Ogogo moji agiburaŋ ega, iŋo mibotiŋ eteigoŋ. Mibotiŋ etende mane sembeaku beusembe maneiŋ ine, go agiburaŋine boke teigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Una more maŋgo agiburaŋ 7 eku bosembea guru ateine 7 goreo kirieru iŋi miiŋ, ‘Ogone, noŋ agiburaŋ ego ore nakene mane sembeago.’ Oŋu miiŋ ine, go agiburaŋine oi boke teigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposol yoŋoji Ofoŋ ojibuŋ, “Mamanesiŋnoŋuŋ jikigaru basanaŋgaigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Oŋu mibi Ofonji bokirieya, “Mamanesiŋ-ŋaŋunde fori oi yojuŋ korunde so ena ine, ŋoŋoji soine yojuŋ yo yoore iŋi mitiganobuŋ, ‘Go godugoke pariru pakereru riŋaru koego rakaru gake sariru dima.’ Oŋu miku manesiŋ gabi yo oiji buŋoŋaŋuŋ reŋgaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ŋoŋoreone more gio ŋiji bulmakao roru gioo raru kiju poreme moreŋ bopogaiŋ me lama siŋaŋyaŋuŋ goiŋ. Goku pigo wapeko oo rauineji iŋi miko maneiŋ me mata, ‘Go pigo waperu ŋeku uqogo no.’ ");
INSERT INTO mlh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Oŋu mata! Iŋoji iŋi miiŋ: ‘Go obu rauku gake bobobiaŋ eru ubure uqone rigaru narende nobemiŋ. Ore ŋadiineo gakere uqo rigaru noigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Oŋu mitiga teko gio ŋiineji rauine miya ore so gioine ba foreko sagako siŋaŋineji ore eru miteŋ gaiŋ me mata? Mata! ");
INSERT INTO mlh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ŋoŋore fuŋne oi oŋuakoŋ pega. Siŋaŋyaŋunji ya sosowo mitiga ŋareya, ŋoŋo oi eforeru oo iŋi minimiŋ, ‘Niŋo gio ŋiŋigo omaine gogobeneŋ. Raunoŋunji yare miya, oi akoŋ baku waregobeneŋ ore mimiteŋ baakimiŋgo embimbiŋgagobeneŋ.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuji Jerusalem sitio raiŋgore Galili eru Samaria prowins yoyoka yokore botugo kadi peya, oo raya. ");
INSERT INTO mlh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kadio raru kae mogo ropeko ŋi 10 sakiyaŋuŋ waeineke yoŋoji bofukeru ŋoneru jojorigo aroo dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Dimaku sanaŋine oŋga joraku mibuŋ, “Sogunenoŋuŋ Yesu, go ŋonemaiŋ enoreigoŋ!” ");
INSERT INTO mlh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Oŋgaru mibi ŋone yaberu iŋi yajiko manebuŋ, “Ŋoŋo soriŋ gio siŋaŋ yoŋoreo raru sakiŋaŋuŋ yaduinebi.” Oŋu yajiko reŋgaru kadio rabi sakiyaŋunji oo posikeru fiine fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Fiine fukeyayoŋ, 10 yoŋoreone moji sakiine posikeko ŋoneru kirieru wareru Anutu sanaŋine akoŋ oŋgaku miteŋ gaya. ");
INSERT INTO mlh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Miteŋ garu Yesure kufuo rakaru daberu dikanji keru ‘Daŋge!’ miya. Ŋi oi Samaria ŋi. Juda yoŋoji Samaria prowinsre ŋiŋigo yoŋore manebi wawakiine fukeko gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Daŋge miko Yesuji bokirieru ojiya, “Oi soine egeyoŋ, ŋi sosowo 10 ŋoŋore sakiji posike foreye me? Ŋi 9 yoŋoji uro gogobi? ");
INSERT INTO mlh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ŋi kotuine goji gake akoŋ kirieru wareru Anutu miteŋ gageyoŋ, ŋi 9 yoŋoji raru qouma eru ragobi.” ");
INSERT INTO mlh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Oŋu miku iŋi ojiko maneya, “Mamanesiŋgoji bobiaŋ guga. Ore eru soine pakereru raigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi (Kadi buŋore yameŋyameŋ) yoŋoji Yesu iŋi weu teru mibuŋ, “Anuture qorumaŋ oi mo damaŋgo fukeiŋ?” Mibi maneru bokirieru iŋi miya, “Anuture qorumaŋ jiŋonoŋunji ŋonekiminde so, so fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Maneniŋ! Anuture qorumaŋ oi botuŋaŋuŋgo maŋ-ŋaŋuŋgo fukeru pega. Ore eru oi yoo me aroo pega, oŋu miiŋgo embimbiŋgaegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesuji kiŋariŋpuine iŋi yajiko manebuŋ, “Jiki damaŋ mo ware fukeiŋ, oo Sombuŋ eru morende Ŋi foriinere gio bobo una oone mo ŋonekiminde aŋi manenimiŋyoŋ, oi moke ŋonenimiŋgo embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Damaŋ oo iŋi mibi manenimiŋ, ‘Maneniŋ! Munaŋqoqo Rauineji aroo goga. Maneniŋ! Iŋo yo fukega.’ Oŋu oŋu mibi oi ŋoneiŋgo oo pipa so riŋaru rainebi. ");
INSERT INTO mlh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Oi iŋi ore: Sombuŋ eru morende Ŋi foriineji moke wareiŋ, damaŋ oi boborire so iŋi fukeiŋ: Oi qonikiŋ mobeone pipa boribori eru tamaeru aribe sagaru raga, iŋoji ore so fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Jiki oŋu fukeiŋyoŋ, rone ŋiŋigo damaŋ yoo moreŋgo gogobi, yoŋoji ŋi oi yoberu ŋadi gabi joiserereŋ soguine maneiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ronekoŋ Noare damaŋgo ŋiŋigoji gogoyaŋuŋ qaqosori paiineo goku sibirigabuŋ, ore so Sombuŋ eru morende Ŋi foriineji moke wareinde damaŋgo oŋuakoŋ fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noare damaŋgo uqo jebe ruaru obu sanaŋine noku ŋigo furiine ruabi ra wareme rorobaba ebuŋ. Eebobo oŋu eba eku qaqosori gobi Noaji ogâ maŋineo ropeya, una oo tariya. Tariko obu yoiko yasogoji wareru ŋiŋigo jeŋgoma pema yabeme obu noru komebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lot iŋore damaŋgo oŋuakoŋ qaqosori gokabi oŋuakoŋ fukeya. Ŋiŋigoji uqo jebe ruaru obu kosaine noku gio ke sariru soriŋ piyaŋuŋ baku qomukuru uqo seki pi eru ya furiine banimiŋ ore ruabi ya goine furiine baku goegobi. ");
INSERT INTO mlh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Oŋu eba eku gokabiyoŋ, Lot iŋoji Sodom kae bokeru rako una oo akoŋ misi eru ko kombo misiineke oi kue oŋuine qonikiŋgone wakiru ŋiŋigo jeŋgoma ja yabeko komebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jiki Sombuŋ eru morende Ŋi foriineji moke fukeiŋ, damaŋ oo ŋiŋigoji oŋuakoŋ qaqosori eru goku sibiriganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Una oo kae jiŋoo goiŋ, iŋoji mebo yaine roiŋ ore pi maŋineo so ropeine me gioo raru goiŋ, iŋoji oŋuakoŋ piineo so kirieru wareigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot ŋonuŋineji kirieru ŋadiineo piku komeru ko koyagaŋ fukeya, oi manesuinebi. ");
INSERT INTO mlh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Moji gogoine batiqatiine tomiri iŋoyoŋunde sabareku iŋoyoŋunde aŋigo goiŋgo manega, iŋore gogoji jibugaiŋyoŋ, moji gogoine nonde eru kisiŋgaru bokeiŋ, iŋoji gogo foriinere fuŋne bofukeru seŋgiŋbaŋgiŋ goiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nonji iŋi ŋajibe maneniŋ: ubu oo ŋi yoyoka ŋeŋeo moko penimi, yokoreone mo ogaru mo bokenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Oŋuakoŋ ŋigo yoyoka moko garaŋ pujeku ŋenimi, yokoreone mo roru mo bokenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Ŋi yoyoka uqo gioo gonimi, yokoreone mo ogaru mo bokenimiŋ.) ");
INSERT INTO mlh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesuji oŋu miko kiŋariŋpuineji bokirieru weubuŋ, “O Ofoŋ, oi uro fukeiŋ?” Oŋu weubi iŋi yajiko manebuŋ, “Joma komekiineji mogo oobe peko sonomeŋ yoŋoji oo poreru tumaŋgaegobi, ore so fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","“Ŋoŋo damaŋ so Anutu oŋga wosiru roroka so eru goinebi.” Yesuji oŋu miku ore soso buŋoine iŋi yajiko manebuŋ, ");
INSERT INTO mlh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Taoŋ mogo buŋo mimitari ŋi mo goya. Iŋoji ŋiŋigo yoŋoji buŋo miteniminde mimi so maneru iŋoyoŋunde aŋigo goku Anutu miine egu odureiŋ ore kokoi so maneya. ");
INSERT INTO mlh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Taoŋ oo koje ŋigo mo goya. Iŋoji jijiki buŋo mimitari ŋi iŋoreo raru iŋi miku goya, ‘Moji noke kekepari ega ore go bapi nunoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Oŋu miko damaŋ joroine oi maneru ŋadi gaku goyayoŋ, jiki maŋineo iŋi miya, ‘Nonji ŋiŋigo yoŋore buŋoyaŋunde mimi so maneru nakene aŋigo goku Anutu miine egu odureiŋ ore kokoi so maneego. ");
INSERT INTO mlh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Oŋu gogoyoŋ, koje yoji mineneŋ damaŋ so enareku wareega ore tataki maneru soine bapi gabe buŋoine tariiŋ. So bapi ganobo ine, iŋoji kadi jijiki wareme egu tatakiine enareiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ofonji sundu oi ba foreru miya, “Mimitari ŋi kekesiineji buŋo miya, ore eru kaje ruaru fuŋine manesuinebi. ");
INSERT INTO mlh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Anutuji ŋiŋigo iŋoyoŋunde roosoe yabeya, yoŋoji ubu una bapi yabeiŋ ore oŋga wosibi Anutuji yoŋore buŋo osoeru mitariko fiine fukenimiŋ. Bapi ŋabeiŋgo miku keoma so eru damaŋ so keririkeko ropeiŋ. Oi mata yobu! ");
INSERT INTO mlh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nonji iŋi ŋajibe maneniŋ: Anutuji damaŋ so joroko buŋoŋaŋuŋ osoeru mitariko fiine fukenimiŋ. Iŋo fofoakoŋ bapi ŋabeegayoŋ, oi jibu Sombuŋ eru morende Ŋi foriineji kirieru wareru ŋiŋigo osoe yabeiŋ, damaŋ oo mamanesiŋ foriine bofukeiŋ me mata?” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ŋiŋigo goineji yoŋoyaŋunde manebi ropeko posiine poretiŋ fukegobeneŋ miku goine manebi wawakiine fukeya. Yesuji yoŋo ŋone yaberu soso buŋo mo iŋi yajiko manebuŋ, ");
INSERT INTO mlh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ŋi yoyokaji boji soriŋgo roperu oŋga wosibu. Moji Farisi eru moji takis roro ŋi. ");
INSERT INTO mlh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Farisi (Kadi buŋore yameŋyameŋ) iŋoji dimaku iŋoyoŋe akoŋ iŋi oŋga wosiya, ‘O Anutu, ŋiŋigo goineji maŋyaŋuŋ qosorieme kigaku boesau baegobi, noŋ yoŋo oŋuine so gogo me takis roro aroo dimaga, noŋ iŋore so oŋuakoŋ so gogo. Ore eru daŋge migarego. ");
INSERT INTO mlh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nonji sonda so ateine yoyoka uqore sowo goego. Nonji moneŋ mebone sosowo boroiŋgaru 10:gone moakoŋ Anuture biŋe ruaego.’ ");
INSERT INTO mlh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Oŋu oŋga wosiyayoŋ, takis roro iŋoji guruine mogo dimaku Sombuŋgo paibe piiŋgo mimi eru meineji jiŋoine komoŋ garu iŋi oŋga wosiya, ‘O Anutu, agiburaŋ ŋi noŋ ŋonemaiŋ enare.’ ");
INSERT INTO mlh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nonji iŋi ŋajibe maneniŋ: Iŋoji Anuture jiŋoo posikeru piineo kirieyayoŋ, Farisi (Kadi buŋore yameŋyameŋ) iŋoji oŋu mata. Uri yoŋoji yoŋoyaŋunde maŋ ba ropenimiŋ, Anutuji yoŋo sosowo bawaki yabeiŋyoŋ, moji iŋoyoŋunde maŋine ba wakiiŋ, Anutuji iŋo ba ropeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ŋiŋigo goineji odumade memenda oŋuakoŋ oga yaberu Yesu meineji boua yabeiŋ ore iŋoreo warebuŋ. Warebuŋyoŋ, kiŋariŋ yoŋoji oi ŋoneru miqomuku eyarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Oŋu ebuŋyoŋ, Yesuji odumade yoŋo kepore yabeko warebi iŋi miya, “Odumade mendaine oi soine boke yabebi nondeo wareniŋ. Anutuji ŋiŋigo oŋuine oi qorumaŋine biŋe qa yareiŋ. Ore eru yoŋo so kipe yabeinebi. ");
INSERT INTO mlh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Moji Anuture qorumaŋ oi odumade oŋuine biŋe so qaiŋ, iŋoji ore maŋineo ropeiŋgo embimbiŋgaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Siŋaŋbobo ŋi moji Yesureo wareru iŋi weu teya, “Qaqaji fiine, nonji uruŋu eru gogo sanaŋinere biŋe fukenobo?” ");
INSERT INTO mlh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Weu teko iŋi ojiya, “Go nonde ‘Qaqaji fiine’, oi wamore mige? Anutu moakonji fiine fukega. Ŋi moji iŋo oŋuine fiine so fukega. ");
INSERT INTO mlh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Go mimipaŋ buŋo yo mane forege: ‘Boesau so eigoŋ. Mo so qande komeine. Ya kiaŋ so roigoŋ. Mo migoiga so eteigoŋ. Maŋgo mamago araŋ ba yateeigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Oŋu miyayoŋ, siŋaŋyayabe ŋiji iŋi ojiya, “Oi sosowo jeŋoŋneone reŋgaru go wapeboŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ojiko Yesuji maneru iŋi ojiya, “Go ya moakonde embimbiŋgage: Go raru mebogo sosowo furi banimiŋ ore ruande moneŋ wareko boroiŋgaru ŋiŋigo wakiqoqoine yareigoŋ. Oŋu ruande mebo yago soguine (juŋe boreŋ, milyon kina oŋuine) oi Sombuŋ kaeo pe gareiŋ. Oŋu eru noŋ boyobe nuru wareigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Oŋu ojiyayoŋ, ŋi oiji jaijonjoŋke goya ore eru buŋo oi maneru beusembe bofukeru jiŋoine posoeme mo bokeru raya. ");
INSERT INTO mlh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Beusembe bofukeko Yesuji oi ŋoneru iŋi miya, “Yei! Ŋiŋigo moneŋ meboyaŋuŋke yoŋoji Anuture qorumaŋgo ropeiŋgo yobiŋgaru qiqu enimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Oi iŋi mitaniŋgabemiŋ: Joma soguine kamel oi buŋi kimboŋineo soine so ropeiŋ. Ore so ŋiŋigo tinabiŋeyaŋuŋke yoŋoji Anuture qorumaŋ maŋineo ropeiŋgo yobiŋgaru quŋganimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Buŋo oi miya, yoŋoji iŋi mibuŋ, “Opopoŋ! Ŋiŋigo moji Sombunde biŋe fukena?” ");
INSERT INTO mlh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Oŋu mibi iŋi bokirieya, “Ŋiŋigoji oi esoigaru embimbiŋgaru quŋgaegobiyoŋ, Anutuji ya sosowo soine baega. Iŋoji ya mo eku eiŋgo ore so embimbiŋgaru quŋgaega.” ");
INSERT INTO mlh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pitaji buŋo oi maneru kirieru iŋi miya, “Mane, niŋoji pi kae moreŋnoŋuŋ bokeru go boyobe guru warebeŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Oŋu miko Yesuji iŋi yajiya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Moji Anuture qorumande eru ya mo bokeya, pi kae moreŋine, ŋonuŋ madeine, kaka gboine me maŋgo mamaine-oi boke yabeko ");
INSERT INTO mlh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Anutuji tifeine jikigaru odureru furiine bokirie teko oi morende gogoo roiŋ eru gogo jikiineo gogo sanaŋine tatariine tomiri raugaru goiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuji kiŋariŋpuine 12 yoŋo kepore yabeme warebi iŋi yajiya, “Maneniŋ, niŋo Jerusalem ropekimiŋ. Kajeqouŋ ŋiŋigoji Sombuŋ eru morende Ŋi foriinere buŋo sosowo quraŋgabuŋ, oi foriineke fuke foreiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Moji iŋo babae bateme kotu gawman yoŋore meo rakaiŋ. Yoŋoji mipemiriŋ eru igosisi eteku buŋo fofoine miteku tifegaru qanimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tifegaru qaku ŋoŋoru joruinekeji qotiboti qabi komeiŋ. Komeru una yokaomo fukeko komegone pakereiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Oŋu yajiyayoŋ, kiŋariŋ yoŋoji buŋo oi so yobu mane taniŋgabuŋ. Buŋo yajiya, oi soŋsoŋgo peko oi so mane mukubuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuji raru Jeriko kae bombeŋgako ŋi jiŋokombi moji uqo moneŋ oteniminde karieru kadi qaŋaŋineo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ŋeko ŋiŋigo kubu sogo kadio odureru rabi fonuŋyaŋuŋ maneru “Wamo ya fukega?” miku weu yareya. ");
INSERT INTO mlh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Weu yareme iŋi mibuŋ, “Yesu, Nazaret ŋiji kadio wareru gadureiŋgo ega.” ");
INSERT INTO mlh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mibi iŋi oŋgaya, “Yesu, Deiwidre osigida! Go ŋonemaiŋ enareigoŋ!” ");
INSERT INTO mlh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Oŋu oŋgako ŋiŋigo bonieru rabuŋ, yoŋoji buŋo mo ŋenonde qomuku tebuŋyoŋ, iŋoji yameŋ keku oŋga jojoraya, “Deiwidre osigida! Go ŋonemaiŋ enare!” ");
INSERT INTO mlh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Oŋga jorako Yesuji ode niniŋgaru iŋi mitigaya, “Iŋo meineo ogaru nondeo wareniŋ.” Mitigako ogaru bembeŋgo wapebi iŋi weu teya, ");
INSERT INTO mlh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ogone, go wamo ya egarebeminde manege?” Weu teko ojiya, “Ofoŋ! Noŋ jiŋone moke piiŋgo manego.” ");
INSERT INTO mlh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ojiko Yesuji maneru iŋi ojiya, “Go jiŋo pi. Mamanesiŋgoji bobiaŋ guga.” ");
INSERT INTO mlh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Oŋu ojiko oo akoŋ jiŋoine tiŋame poretiŋ piku Anutu miteŋ garu Yesu boyoberu ŋadiineo raya. Ŋiŋigo sosowo yoŋoji ya oi ŋoneru Anutu miteŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu Jeriko taoŋgo waperu petigaru raiŋgo eya. ");
INSERT INTO mlh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Oo ŋi mo tinaine Zakius goya. Iŋoji ŋi tinabiŋeineke fukeru takis roro yoŋore minebobo goya. ");
INSERT INTO mlh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iŋoji Yesure kamasi ŋoneiŋgo aŋi maneyayoŋ, ŋi pompoŋine ore ŋiŋigo kubu botuyaŋuŋgo dimaku tiŋtiŋneku embimbiŋgaya. ");
INSERT INTO mlh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","“Yesuji yo ware nodureiŋ,” mibi maneru ŋoneiŋgo giniŋgaru raru ŋiŋigo yadureru Sikamore yo paiineo roperu ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ŋeko Yesuji oo roperu jiŋo pime ropeko ŋoneru iŋi ojiya, “Zakius, go pipa waki. Noŋ muŋambe gore pigo warebe moko ŋenomi.” ");
INSERT INTO mlh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Oŋu miko pipa wakiru jerieru keporeme piineo rabu. ");
INSERT INTO mlh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Rakabire ŋiŋigo sosowoji oi ŋoneru ŋunuŋ-ŋunuŋ eru iŋi mibuŋ, “Wamore eru agiburaŋ ŋi oŋuinere pigo roperu ŋega?” ");
INSERT INTO mlh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Oŋu mibuŋyoŋ, Zakiusji ŋiŋigo botuyaŋuŋgo totogo pakereru dimaku Ofoŋ iŋi ojiya, “Ofoŋ mane, nonji tebemarone botuineo boroiŋgaru mobeine ŋiŋigo wakiqoqoine yoŋore yarebemiŋ eru uri yoŋore yareya mo so odureru eadu eru roboŋ, oi ateine 4 ore so jikigaru bokirie yarebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Oŋu ojiko Yesuji iŋore fuŋnere iŋi miya, “Anutuji muŋambe pi yoore rauine munaŋ qoqo eteko qowiriega. Iŋoji oŋuakoŋ Abrahamde osigidapu yoŋore botugo goga. ");
INSERT INTO mlh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sombuŋ eru morende Ŋi foriineji ŋiŋigo jibugabuŋ, oi baaru munaŋ qa yareiŋ ore eru wakiya.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesuji wareru Jerusalem siti bombeŋgaru buŋo miko ŋiŋigo oi manebuŋ, yoŋoji iŋi manesubuŋ, “Anuture qorumande foriji pipa fukeiŋ.” Oŋu manesubuŋ ore Yesuji soso buŋo mo iŋi miya, ");
INSERT INTO mlh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Ŋi biŋeroroineke moji iŋi miya, ‘Noŋ kaene bokeru kantri mogo jorigo rabe oiji noŋ ŋi koito bapakare nubi goku kirieru warebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oŋu moreŋ jorigo raiŋgo miku gio ŋipuine 10 oŋga yareko warebi moneŋ komoŋ 10 boroiŋga yareru iŋi yajiya, ‘Nonji raru goku jiki kirieru warebemiŋ. Ŋoŋoji damaŋ botuineo moneŋ yoji rojiki-bajiki gio baku oi basaueinebi.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Oŋu miku rayayoŋ, kufufuŋpuineji rosi eteru iŋi mibuŋ, ‘Niŋo ŋi yoji noŋunde ŋi koito fukeru siŋaŋ nobeiŋ ore taki nobega.’ Oŋu miku kiŋaŋ ŋi goine sore yabebi ŋadiineo raru biŋe oi ojibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Oŋu ojibuŋyoŋ, jibu kantri raya, yoŋoji iŋo ŋi koito igodoŋgabi iŋoyoŋunde prowinsgo moke kirieru wareya. Wareru gio ŋipuine moneŋ komoŋ yareya, oi miko iŋore jiŋo maio wapebuŋ. Moakoŋ moakoŋ yoŋoji rojiki-bajiki gio baku moneŋ basauebi wojimu fukeya, oi odubi ŋoneiŋgo weu yareya. ");
INSERT INTO mlh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Gio ŋi boboniji jiŋo maiineo waperu miya, ‘Ofoŋ, nonji moneŋ komoŋgo basauebe jikigaru moke komoŋ 10 bofukeboŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Oŋu miko iŋi ojiya, ‘Oi fiine. Go gio bobo ŋi fiine. Go ya mendaine roru oi yameŋ keku siŋaŋ garu gokande saueya. Ore eru nonji taoŋ moreŋ 10 qodureru gore meo ruabe yoŋore siŋaŋ goigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Oŋu ojime gio ŋi ogoineji jiŋo maiineo waperu iŋi ojiya, ‘Ofoŋ, nonji gore moneŋ komoŋgo basauebe jikigaru moke komoŋ 5 bofukeboŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Oŋu ojiko iŋo oŋuakoŋ iŋi ojiya, ‘Oi fiine. Nonji taoŋ moreŋ 5 qodureru gore meo ruabe yoŋore siŋaŋ goigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Moke moji waperu ojiya, ‘Ofoŋ ŋone. Gore moneŋ komoŋgo yo. Oi kambanji komoŋ garu aimuŋ ruabe peya. ");
INSERT INTO mlh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Goji ŋi joineke fukege ore eru gore kokoi maneru goboŋ. Go gake mebo ya rouŋgo so ruameŋ, oi jibu roiŋgo maneege. Go gake uqo koruŋine so sarinde fukeya, ore foriine oi jibu ketigaru roiŋgo maneege.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Oŋu ojiko bokirieru iŋi miteya, ‘Go gio ŋi sembene. Gogake buŋo mige, nonji ore so osoe gareru geoine bokirie garebemiŋ. Noŋ ŋi joineke fukego. Nake ya rouŋgo so ruaru oi roiŋgo maneego. Nake uqo koruŋine so sariru ore foriine oi jibu ketigaru roiŋgo maneego. Oi soine maneru gomeŋ. ");
INSERT INTO mlh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Go fuŋnene oŋu maneru wamore moneŋ komoŋne oi moneŋ pigo so ruande sogueya. Oi rojiki-bajiki gioo ruanoŋ ine, oiji saueko nonji wareru tifeineke ronobo.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Oŋu miteku ŋi bembeŋgo dimagobi, yoŋo iŋi yajiya, ‘Ŋoŋo iŋore meone moneŋ komoŋine oi roru komoŋ 10 bofukeya, iŋo oteniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yajime maneru iŋi ojibuŋ, ‘Ofoŋ, iŋore moneŋ komoŋ 10 oi pe forega.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Oŋu ojibi bokirieru miya, ‘Nonji iŋi ŋajibe maneniŋ: Ŋiŋigo ya pe yareko gioine baegobi, sosowo yoŋore Anutuji oi jikiga yareko saueiŋyoŋ, more ya mendaine mo peko gioine so baega, Anutuji oi oŋuakoŋ yoogo rome omaine yobu goiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Oŋu migoyoŋ, ‘Rosipuneji noŋ ŋi koito fukeru siŋaŋ yabebemiŋgo taki yabeya, yoŋo oga yaberu warebi ŋone yaberu mitigabe yabebi komenimiŋ.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuji buŋo oi miforeru bokeru Jerusalem sitio ropeiŋgo bonieru raya. ");
INSERT INTO mlh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Raru Betfage eru Betani kae yoyoka maŋfuŋyakuŋgo wareru tuku tinaine Oliwe yo tuku miegobi, oo roperu kiŋariŋyokaine yoyoka sore yapeya. Sore yapeiŋgo eru ");
INSERT INTO mlh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","iŋi yasiya, “Kae jiŋo maiyakuŋgo ŋega, ŋoko oo rani. Raru oo roperu doŋgi madeine niginji kipebi dimaga, oi bofukenimi. Doŋgi oi gariine, ŋi moji paiineo so ŋeŋeine. Oi pirueru ogaru yoo wareni. ");
INSERT INTO mlh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Piruebire moji ‘Oi wamore piruegobire?’ miku weu ŋateme iŋi ojini, ‘Ofoŋnokunji ore eru embimbiŋgaga.’” ");
INSERT INTO mlh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Oŋu sore yapeme raru yasiya ore so bofukebu. ");
INSERT INTO mlh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bofukeru doŋgi madeine pirueiŋgo ebire rauine yoŋoji yasibuŋ, “Hei! Doŋgi madeine oi wamore piruegobire?” ");
INSERT INTO mlh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yasibi iŋi bokiriebu, “Ofoŋnokunji ore eru embimbiŋgaga.” ");
INSERT INTO mlh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Oŋu bokirieru ogagaru Yesureo wareru marikuyaŋuŋ qomukuru doŋgi paiineo ramegaru mibi Yesuji roperu ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Oŋu ŋeku rako ŋiŋigo kubu sogo yoŋoji araŋ baku kambaŋ marikuyaŋuŋ qomukuru kadi sogoo ramegabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ramegabi raru Jerusalem bombeŋgaru Oliwe yo tukure pagaŋgo rakame kiŋariŋ kubu sosowoji fuŋgaru jerieru mosi qoqowirie sosowo usuŋ paiineo bako ŋonebuŋ, ore eru buŋo soguine oŋgaku Anutu miteŋ garu ");
INSERT INTO mlh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","iŋi miku oŋgabuŋ, “Anutu miteŋ gagobeneŋ. Kiŋ Ofonde tinao wareiŋ, Anutuji oi mifiaine. Womogo eru tinabiŋego miteŋ gabeneŋ Sombuŋ paibe ropega. Ohowe ohowe!” ");
INSERT INTO mlh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oŋu oŋgabi Farisi (Kadi buŋore yameŋyameŋ) goineji ŋiŋigo kubu botuyaŋuŋgo dimaku iŋi mitebuŋ, “Qaqaji, kiŋariŋpugo buŋo miyare.” ");
INSERT INTO mlh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Oŋu mitebi iŋi bokirieya, “Nonji iŋi ŋajibe maneniŋ: Yoŋoji niniŋ dimanobuŋ ine, ko yoŋoji jojoraku oŋganobuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesuji Jerusalem bombeŋgaru siti oi ŋoneru kuyoya. ");
INSERT INTO mlh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kuyoru iŋi miya, “Ŋoŋoreo womo uruŋu fukena! Ŋoŋo ore fuŋine una yoo mane mukubi saganayoŋ, damaŋ yoo oi jiŋoŋaŋuŋ so tiŋaga ore eru soŋsoŋgo pega. ");
INSERT INTO mlh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ore fuŋine oi iŋi: Damaŋ mo ware fukeiŋ, oo rosi yoŋoji waperu sa sanaŋ qaŋqaŋineji siti yo baru roregaru mobemobe paibe yukube rande ruaru rubaru suroŋqoqo eŋarenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Anutuji mai eŋareku oŋga ŋareko ŋoŋo damaŋ qoruine oi so mane mukuru keta eru Anutu ŋadi gaku jibu go wapegobi, ore eru rosi yoŋoji ketoqototie ŋarebi pire ko mo oi ko more paio so dimaiŋyoŋ, siti yoji siŋsaŋ peiŋ. Yoŋoji soriŋ piŋaŋuŋ ketotieru odumadepuŋaŋuŋ siti maŋineo gogobi, yoŋo yabe ima eiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesuji buŋo oi miforeru boji sorinde jokoroŋ maŋgo raru mebo furiine banimiŋ ore ruabuŋ, oi fuŋgaru yobe yabeme wakibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yobe yaberu iŋi yajiya, “Aisaiaji buŋo mo iŋi quraŋgame pega, ‘Nonde sorinji oŋgawowosi piŋaŋuŋ fukeiŋ.’ Buŋo oi pegayoŋ, ŋoŋo oi kerisiebi suroŋqoqo yoŋore kouŋ oŋuine fukega.” ");
INSERT INTO mlh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesuji damaŋ so boji soriŋgo roperu Biŋe buŋo qaji yareru goya. Oŋu goyayoŋ, soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji tumaŋgaru kantri soriŋ kaunsol yoŋoke mimane eku iŋi mibuŋ, “Iŋo uruŋu mibeneŋ qabi komena?” ");
INSERT INTO mlh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Oŋu mibuŋyoŋ, ŋiŋigo kubu soguine sosowo yoŋoji iŋoke qakatoru Biŋeine kaje ruaru maneebuŋ. Ore eru “Noŋuŋ uruŋu enobeŋ?” miku kadi mo so bofukebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yesuji boji soriŋgo roperu ŋiŋigo kubu qaji yareru Bobiaŋ Biŋe mitaniŋga yareru goya. Damaŋ mogo oŋu eko soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji kantrire minebobo goine yoŋoke Yesure jiŋomaio wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Waperu iŋi weu tebuŋ, “Go yoo ya bage, oi moji mitiga gareme baege? Ore usuŋine oi moji gareya? Oi minde maneki.” ");
INSERT INTO mlh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Weu tebi iŋi bokirie yareya, “Nonji oŋuakoŋ weu ŋarebe oi bokirieru najiniŋ. ");
INSERT INTO mlh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jonji ŋiŋigo miti meso rau yareru goya, iŋoji ore usuŋ oi urone roya? Sombuŋ Rauineji oteya me moreŋ rauineji otebuŋ?” ");
INSERT INTO mlh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Oŋu bokirie yareme botuyaŋuŋgo mimane eku iŋi mibuŋ, “‘Usuŋineji Sombuŋgone fukeya,’ oŋu mikimiŋ ine, iŋoji iŋi miiŋ, ‘Oŋu fukeko ŋoŋoji oi wamore so manesiŋ gabuŋ? Oi so sagaga.’ ");
INSERT INTO mlh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kufufuŋ sosowo yoŋoji Jonde ‘Kajeqouŋ ŋi fukega,’ miku oi sanaŋine manesiŋ garu gogobi. Ore eru ‘Moreŋ ŋiŋigo yoŋoreone fukeya,’ mikimiŋ ine, yoŋoji maŋyaŋuŋ rigaŋgame koji kenobenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Buŋo oŋu osoeru iŋi bokiriebuŋ, “Usuŋineji urone fukeya, niŋo oi so manegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Oŋu bokiriebi Yesuji iŋi yajiya, “Oŋu fukeko nonji oŋuakoŋ ya yo baego ore usuŋine moji nareya, oi so ŋajibemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesuji fuŋgaru ŋiŋigo soso buŋoo iŋi yajiya, “Ŋi moji wain nigiŋ gio keku sariya. Kesari eku gio siŋaŋ goine bofuke yaberu miko gioine baku foriinere mobe yoŋoyoŋe roru mobeine rauine otenimiŋ ore meyaŋuŋgo ruaya. Meyaŋuŋgo ruaru boke yaberu kantri mogo raru damaŋ joroine goya. ");
INSERT INTO mlh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Goku gome foriine gumuŋgaya ore damaŋine (gosa 5) bombeŋgako oo kiŋaŋqoqoine mo soreme siŋaŋ yoŋoreo raru wain gio foriinere mobe otenimiŋ ore miya. Mikoyoŋ, gio siŋaŋ yoŋoji oi kobinji qaku yobebi meine metariŋ kirieya. ");
INSERT INTO mlh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ore ŋadiineo kiŋaŋ ŋi mo soreme rayayoŋ, oi oŋuakoŋ kobinji qaku mimi qateru yobebi meine metariŋ kirieya. ");
INSERT INTO mlh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kirieme gio rauineji kiŋaŋ ŋi mo moke soreme rame ateine yokaomo fukeyayoŋ, oi oŋuakoŋ darijombuŋ qaku gio sa sakiineo igogabi rakaya. ");
INSERT INTO mlh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Oŋu ebi wain gio rauineji buŋo baaru miya, ‘Uruŋu enobo? Nakene yoro made sorebe rako iŋo ŋoneru araŋ ba tenimiŋ me uruŋu?’ ");
INSERT INTO mlh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Oŋu miku madeine soreme rayayoŋ, wain gio siŋaŋ yoŋoji oi ŋoneru botuyaŋuŋgo iŋi mimane eku mibuŋ, ‘Iŋoji merofuinere rau fukeiŋ. Ayo, iŋo qabeneŋ komeko wain nigiŋ gio yoji noŋunde biŋe fukeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Oŋu miku igogabi gio sakiineo rakame qabi komeya. Wain gio rauineji oi maneru uruŋu eyareiŋ? ");
INSERT INTO mlh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iŋoji iŋoyoŋe wareru gio siŋaŋ oi ketotie yabeiŋ eru gio siŋaŋ gariine bofuke yaberu wain nigiŋ gioine yoŋore meo ruaiŋ.” Yesuji soso buŋo oŋu yajiko maneru mibuŋ, “Oi so sagaga. Kepieru (use)!” ");
INSERT INTO mlh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mibuŋyoŋ, Yesuji oi poretiŋ ŋone muku yaberu iŋi miya, “Biŋe Quraŋgo buŋo mo oi iŋi pega, ‘Pi bobo yoŋoji ko otuŋ mo ŋadi gaku omaine bokebi ŋeya, oiji otuŋ sanaŋine fukeko bofukebuŋ. Oiji kerigame piji ŋeririkeru waki qaiŋ.’ Buŋo ore fuŋine oi uruŋu? ");
INSERT INTO mlh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ore eru iŋi mibemiŋ: Moji otuŋ qoruine oo odetataŋgaru wakiru qaiŋ, oi sakiine ketiqotigaiŋyoŋ, aeŋ otuŋ oiji pariru rondiŋgaru more paio waki qaiŋ, oi sosowo qanjaŋbanjaŋgaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesuji oŋu miko Kadi buŋore qaqaji eru soriŋ gio siŋaŋ yoŋoji buŋo ore fuŋine mane taniŋgaru iŋi mibuŋ, “Soso buŋo oi noŋunde miga.” Ore eru oi damaŋ oo akoŋ roru nigiŋgaiŋgo manebuŋyoŋ, ŋiŋigo kubu sogo yoŋore kokoi maneru embimbiŋgabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Juda minebobo yoŋoji Yesure rubobo ebuŋ. Oŋu eku buŋoine mo mijibugame buŋore budunji poreme nigiŋgaiŋgo eru ŋi goine sore yabebi iŋoreo warebuŋ. Kambanti eru gawana yoŋore meo ruaiŋgo maneru Biŋe buŋo fiine mimi kamasi eru weu teru buŋoinere kaje ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Buru oŋu ruaru weu teru iŋi mibuŋ, “Qaqaji, niŋo gore fuŋne manegobeneŋ. Goji buŋo poretiŋ miku qaji noreege. Goji ŋiŋigo goine so ŋone aŋi eyareru goine so sure yabeegeyoŋ, so moakonji osoe nobeege. Oŋu eru Anuture kadi oi buŋo foriine boyoberu qaji noreege. ");
INSERT INTO mlh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ore eru niŋo Sisa-kiŋ koitore takis ruaru oŋu Mosesre Kadi buŋo ririkimiŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Oŋu mibuŋyoŋ, Yesuji sinefuru buruyaŋuŋ mane mukuru iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Soine silwa moneŋ mo nadubi ŋonebemiŋ. More sasako eru tina oi oo quraŋgabi pega?” “O, oi Sisa-kinde,” oŋu bokirieru mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mibi iŋi yajiya, “Oŋu fukeko ya Sisa-kinde sasakoke oi iŋore biŋe oteeinebi. Ya Anuture sasakoke oi Anuture biŋe ruainebi.” ");
INSERT INTO mlh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yesuji oŋu miya ore ŋiŋigo kubu sogo yoŋore jiŋo maio buŋore budunji ruaiŋgo embimbiŋgaru buŋoinere waragaru buŋoyaŋuŋ mataeme dimabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi qaqaji pati yoŋoji “Komebuŋ, yoŋoji so pakerenimiŋ,” miku gobuŋ. Yoŋoreone goineji Yesure jiŋomaio waperu iŋi weu teru ");
INSERT INTO mlh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","mibuŋ, “Qaqaji, Mosesji iŋi mitiga noreme pega, ‘Ŋi mo ŋigo roko odumade so fukebi komeko gboineji soine kojeine roru goku gbori bofuke teme kakainere tina roru goiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Mane! Damaŋ mogo kakagbo 7 gobuŋ. Kakayaŋuŋ boboniji ŋigo roru goku gariine tomiri mo goku komeya. ");
INSERT INTO mlh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Komeko gboineji kojeine iŋo roya. ");
INSERT INTO mlh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ore ŋadio gboine moji ŋigo iŋo akoŋ roya. Oŋuji oŋu kakagbo 7 sosowo yoŋoji ŋigo moakoŋ iŋo akoŋ roru gariine tomiri goku kome forebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kome forebi tatariine kojeyaŋuŋ iŋoji oŋuakoŋ komeya. ");
INSERT INTO mlh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Goji ‘Komebuŋ, yoŋoji gboreru pakerenimiŋ,’ migeyoŋ, niŋo oi so manesiŋ gagobeneŋ. Mane, ŋi 7 sosowo yoŋo moko pakerenimiŋ ine, ŋigo moko akoŋ iŋo ŋonuŋyaŋuŋ robi goya ore eru more ŋonuŋ fukena?” ");
INSERT INTO mlh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Oŋu mibi Yesuji iŋi bokirieya, “Damaŋ yoo moreŋ yoo ŋiŋigo ŋoe ŋonuŋ fukeru goegobi. ");
INSERT INTO mlh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Goegobiyoŋ, ŋiŋigo maŋyaŋuŋ kerisiebi Anutuji ŋoneru maneme sagako komegone pakereru kae moreŋ fuŋine mo paibe roperu gonimiŋ, yoŋoji oo so rorobaba enimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","“Ore fuŋine oi iŋi: Maŋkekerisie ŋiŋigo gboreru komegone pakerenimiŋ, yoŋoji Anuture odumadepu fukegobi. Yoŋoji Sombuŋ mimerereŋ oŋuine fukeru moke so komenimiŋyoŋ, tatariine tomiri go ropenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Maneniŋ! Komebuŋ, yoŋoji gboreru pakareniminde buŋoine oi Mosesji oŋuakoŋ kitiŋgaku miya. Qiŋambu didiineo misi boruŋ fukeru so ja foreya, iŋoji oi ŋoneru sunduine quraŋgako oo buŋo iŋi pega, ‘Nonji Anutu Abrahamde Ofoŋ, Aisakre Ofoŋ eru Jeikobre Ofoŋ go waperu gogo.’ ");
INSERT INTO mlh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ŋaso fuŋgbodu yokaomo yoŋoji Anutuke goku sanaŋgaru ropenimiŋ. Sosowo sanaŋgaru gogobi, yoŋoji gogoyaŋuŋ Anuture gogobi. Ore eru Anutuji komekiine yoŋore Ofoŋ matayoŋ, gogo sanaŋine gogobi, yoŋore Ofoŋ fukega.” ");
INSERT INTO mlh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yesuji oŋu bokirieme Kadi buŋore qaqaji goineji bokirieru iŋi ojibuŋ, “Qaqaji, oi buŋo poretiŋ mige.” ");
INSERT INTO mlh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Oŋu miku buŋo mo moke weu teiŋgo fogaturuŋ eru bokebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesuji buŋo mo iŋi yajiya, “Kristoji Kiŋ Deiwidre gari fukega, goineji buŋo oi uruŋure miegobi? ");
INSERT INTO mlh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Deiwidji iŋoyoŋe buŋo iŋi mime Miti kiki Quraŋgo (Buk song, Psalm) pega, ‘Anutuji dimaku nonde Ofoŋ iŋi ojiya, Goji wareru nonde me furoo ŋende ");
INSERT INTO mlh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nonji damaŋ botuineo rosipugo oderu odema yaberu gbiŋ eyareru gore kufu yukuo rua yabebemiŋ. Damaŋ oi ware fukeiŋ ore so kuririquraŋgo yoo ŋeigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Deiwidji oŋu miku tinaine ‘Nonde Ofoŋ’ miga. ‘Ofoŋne’ miku uruŋu eru iŋore osigida oŋuakoŋ fukena?” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesuji kiŋariŋpuine yoŋo buŋo iŋi yajiko ŋiŋigo kubu soguine sosowo oi manebuŋ, ");
INSERT INTO mlh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kadi buŋore qaqaji yoŋore eru sisiŋaŋ eku goinebi. Yoŋoji mariku joroine keru ra wareru yadunimiŋgo maneegobi. Nareŋgareŋ kae jiŋoo me kadio ŋiŋigo ŋone yabebi mijeri eyarenimiŋgo maneegobi. Oŋuakoŋ oŋgawowosi pigo miineo paibe ŋeniminde aŋi maneegobi eru jebego ŋeŋe bobonio minemine ŋenimiŋgo maneegobi. ");
INSERT INTO mlh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yoŋoji koje yoŋore pi ya anda eru koŋgo eegobi eru tinabiŋeyaŋuŋ fukeiŋ ore oŋgawowosi joroine joroine oŋga wosiru omoyaŋuŋgo qaegobi. Ore eru Anutuji buŋoyaŋuŋ mitariku geoine ropekiine bokirieme paiyaŋuŋgo ropeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesuji dimaku pime rako ŋiŋigo tinabiŋeyaŋuŋke yoŋoji pesiŋ-ŋaŋuŋ oi pesiŋ katapago ruabi rakaya. ");
INSERT INTO mlh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ruabi rakame ŋigo koje wakiqoqoine moji wareru siqojiŋo boboroŋ yoyoka ruame rakaya, oi oŋuakoŋ ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Oi ŋoneru iŋi miya, “Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Koje wakiqoqoine yoji pesiŋ ruaga, oi goine sosowo yadureru ruaga. ");
INSERT INTO mlh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ore fuŋine oi iŋi: Sosowo yoŋoji moneŋ soguine pe yareko mobeine akoŋ ruagobiyoŋ, ŋigo yoji pe tega ore so yaine sosowo rua foreru omaine yobu goiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jerusalem boji soriŋ oi ko ŋone-aŋiineke eru yauŋine yauŋine Anuture ruabuŋ, oiji basarigabi kuririineke peya, kiŋariŋ goineji oi ŋoneru mimane ebi Yesuji buŋo iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Pi yo ŋonegobi, oi ketotiebi pire ko mo oi ko more paio so peiŋyoŋ, siŋsaŋ sesuine akoŋ peiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Oŋu yajiko weu tebuŋ, “Qaqaji, buŋo mige, ore foriine wamo damaŋgo fukeiŋ eru fukeiŋgo eiŋ, ore mogeineji uruŋu fukeiŋ?” ");
INSERT INTO mlh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Weu tebi iŋi yajiya, “Moji sinefuru eko tiŋtuŋ qaku ranimiŋ ore sisiŋaŋ eku goinebi. Ŋiŋigo kokoineji fukeru nonde tinao iŋi ŋajinimiŋ, ‘Nonji Kristo fukego,’ eru, ‘Damaŋ oi bembeŋgaga.’ Oŋu ŋajinimiŋyoŋ, ŋoŋoji yoŋore ŋadio so rainebi. ");
INSERT INTO mlh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jigo oyowoine oyowoine fukeru ra wareko fonuŋine manenimiŋyoŋ, gburugburu so ŋabeine. Ya oi bonieru fukeiŋ ore mimiine. Oi fukeiŋyoŋ, morende damanji oo akoŋ pipa so tariiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Oŋu yajiru jikigaru iŋi miko manebuŋ, “Kantri moji kantri mo yabeiŋ ore pakerenimiŋ. Ŋiŋigo kubu moji kubu mo yoŋoke buru baku qoqo eiŋgo ore pakerenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Moreŋine moreŋine oo komeŋ soguine soguine gbeŋ akoŋ baku moreŋ bokirieko rakaeiŋ. Oŋuakoŋ roroine roroine fukeru roperu peiŋ. Jibe sanaŋine sanaŋine oi fukebi jiŋorara komeenimiŋ. Qonikiŋgo soi soguine jiŋofuru jiŋofuru ŋoneru popureru kokoi maneenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ya sosowo oi fukeiŋyoŋ, bonieru goineji ŋoŋo maŋ-ŋaŋuŋ kerisiebuŋ ore eru ro ŋaberu nigiŋ ŋaberu kekesuesue eŋarenimiŋ. Goineji pore ŋaberu oŋgawowosi piyaŋuŋgo buŋo gioŋaŋuŋ baku mitaribi witi piine piine oo rua ŋabenimiŋ. Goineji nonde tinare eru oga ŋabebi kantriine kantriine yoŋore ŋi koito eru gawana yoŋore jiŋo maio dimanimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Oŋu dimaku nonde fuŋne soine kitiŋgaku yajiinebi. ");
INSERT INTO mlh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Buŋo koroineo rua ŋabebi dimanimiŋ, damaŋ oo buŋo uruŋu minobeŋ, ore manemeja bonieru so maneinebi. Buŋo oi maŋ wombuŋ-ŋaŋuŋgo ruabi peine. ");
INSERT INTO mlh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","“Oi iŋi ore migo: Nonji ŋoŋoke dimaku maŋgboroŋ ŋareru miŋaŋuŋ baafagabemiŋ. Maŋafa akoŋ gobi kisopuŋaŋuŋ yoŋoreone moji maŋgboroŋ oi qomukuru buŋoŋaŋuŋ kepieru bawaki ŋabeniminde embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ŋoŋo-ŋaŋunde maŋgo mama, kaka gbo, tifepu eru ogopuŋaŋuŋ yoŋoji oŋuakoŋ soŋsoŋburu eŋarebi ŋoŋoreone goine ŋabebi komenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kantri sosowo yoŋoji nonde tinare eru rosi eŋarebi gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","“Oŋu gonimiŋyoŋ, nonji maŋgo eŋarebe qoruŋaŋunde siki moji so jibugaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ŋoŋo yameŋ keku sanaŋgaru qiŋ keru dimaku oiji gbiŋ eru seŋgiŋbaŋgiŋ gogo rauganimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jiki mamari kubu yoŋoji waperu Jerusalem siti roregaru rande ruanimiŋ, ŋoŋo oi ŋoneru damaŋ oo iŋi manesuinebi, ‘Siti qoruine ketoqototieniminde damanji ware fukega.’ ");
INSERT INTO mlh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Damaŋ oo Judia prowinsgo gonimiŋ, ŋoŋoji use poreru tukuo rainebi. Sitio gonimiŋ, ŋoŋoji siti bokeniŋ. Siti sakiineo gonimiŋ, ŋoŋoji sitio so rainebi. ");
INSERT INTO mlh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","“Oi iŋi ore migo: Biŋe Quraŋgo kajeqouŋ buŋo quraŋgabi pega, oi sosowo foriineke fukeiŋ. Buŋo ore so Anutuji damaŋ oo agiburaŋ-ŋaŋunde geo bokirieru paiŋaŋuŋgo ruame ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Anutuji Israel kufufuŋ agiburaŋyaŋunde eru maŋine rigaŋgame rosiine ŋaduko moreŋgo suroŋqoqo bibitatariine fukeiŋ. Ŋigo kuake eru odumade moŋgo yoŋoji damaŋ oo uruŋu pipa ranobuŋ? Ore eru ‘Yei!’ oŋga jojorago. ");
INSERT INTO mlh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","“Ketoqototie oo ŋiŋigo goine yoŋo jigore siqo sogoji keyabebi komenimiŋ. Goine niginji kipe yaberu oga yabebi kantri sosowo yoŋore botugo ropenimiŋ. Ropebi kotu kantri yoŋoji waperu Jerusalem odepariru gonimiŋ. Oŋu gobi Anutuji damaŋyaŋuŋ moge ruame ŋega, oiji ware fukeme bokenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Wegi eru ayoŋ jiŋoyakunji eru bobuŋ oo soi furuine furuine fukeiŋ. Koego siri qame fonuŋ soguine fukeeiŋ ore eru morende kantri sosowo yoŋoji ooriyaŋuŋ mukuko koŋkoŋ maneru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Oŋu gokabi qonikinji itiriŋgako ore yareyaine oi ŋeŋeyaŋuŋ bokeru bojiqojibu ebi jibugaiŋ. Ore eru moreŋine moreŋine oo yobiŋ sembene yobu fukeiŋ ore eru goku kokoi maneru maŋyaŋuŋ gigako jiŋobuburi enimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Damaŋ oo Sombuŋ eru morende Ŋi foriine iŋoji kuaŋ paio wareko ŋonenimiŋ. Usuŋine soguineji gbuŋgbasaŋineke totogo fukeko kuririquraŋine ŋonenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Oŋu wareiŋyoŋ, ya oi fuŋgaru fukeiŋ, ŋoŋoji damaŋ oo Sombuŋgo ropeniminde damaŋ-ŋaŋunji bembeŋgaiŋgo ore qoruŋaŋuŋ romaiŋgaru maŋ-ŋaŋuŋ qojugaru koimo dimainebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesuji soso buŋo mo iŋi yajiya, “Ŋoŋo wanjo eru yo goine oi ŋone yaberu kamasiyaŋuŋ maneinebi. ");
INSERT INTO mlh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yo oi rekayaŋuŋ posebi oi ŋoneru ore fuŋine ŋoŋo-ŋaŋe mane taniŋgaru iŋi miegobi, ‘Wegi damaŋ bombeŋgaga.’ ");
INSERT INTO mlh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ŋoŋoji oŋuakoŋ buŋo migo, ore foriineji fukeko ŋoneru mane taniŋgaru fuŋine iŋi minimiŋ, ‘Anutu qorumande Ŋi foriineji pipa bombeŋgaru wareiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nonji buŋo foriine mo iŋi ŋajibe maneniŋ: Ŋiŋigo muŋambe moreŋgo gogobi, yoŋoji so komebi ya sosowo migo, oi yoŋore gogo damaŋgo fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sombuŋ morenji mata enimiyoŋ, nonde Biŋe buŋoji so mataeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Damaŋ yasogo ore yobinji ŋiŋigo sosowo moreŋgo gonimiŋ, yoŋore paio oŋu fukeru ropeiŋ. Ore eru oiji ututuŋ wareru bitiŋ oŋuine egu qama ŋabeiŋ. Ore eru moreŋgo gogore manebuji paiŋaŋuŋgo ropeko jebe baru obu sanaŋine noku bojiqojibu eru maŋ-ŋaŋuŋ egu yobiŋgaiŋ ore sisiŋaŋ eku goinebi. ");
INSERT INTO mlh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","“Ore eru damaŋ so maŋgari goku oŋga wosigaru goinebi. Oŋu gokabi usuŋ ŋareme ya sosowo oi fukeiŋ, ore maŋineone kamieru Sombuŋ eru morende Ŋi foriinere jiŋo maio koimo dimanimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Damaŋ oo Yesuji una so boji soriŋgo dimaku Biŋe buŋo qaji yareme kae ubu eme bokeru tuku tinaine Oliwe yo tuku miegobeneŋ, oo roperu peku goya. ");
INSERT INTO mlh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Oŋu goko ŋiŋigo kubu sosowo yoŋoji una so kae fufurere akoŋ bojisoriŋgo roperu Biŋeine miko maneiŋgo iŋoreo wareru gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oŋu gobuŋyoŋ, poroŋ yistine tomiri ore kombaŋ, tinaine Pasowa kombaŋ miegobeneŋ, oi bombeŋgaya ");
INSERT INTO mlh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bombeŋgako oo soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji ŋiŋigo kubu yoŋore kokoi manebuŋ ore eru yoŋoyoŋe akoŋ tumaŋgaru “Uruŋu ebeneŋ qabi komena?” miku kadi baaru mimane ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Damaŋ oo Satanji Judasre maŋgo rakaya. Judas iŋo Yesure kiŋariŋpu 12 yoŋoreone mo. Kariot kaeone wareya ore tinaine mo Iskariot mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iŋoji soriŋ gio siŋaŋ eru sorinde sa siŋaŋ qoruine yoŋoreo raru Yesu babae baru meyaŋuŋgo ruainde buŋo yajiya. ");
INSERT INTO mlh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yoŋoji oi maneru “Ayo!” miku maŋyaŋunji fiame furiine moneŋ oteiŋgo ore buŋo kipebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Buŋo kipebi Judasji Yesu kamiine babae baru meyaŋuŋgo ruainde kadi baaru ŋone yoyoberu goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Poroŋ yistine tomiri ore kombaŋ una mogo Pasowa lama qaku rigaebuŋ, damaŋ oiji ware fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesuji Pita eru Jon iŋi yasiru sore yapeya, “Ŋoko raru Pasowa lama bomogabire nokimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Oŋu yasiru sore yapeme weu tebire, “Oi uro raru bomoganimi?” ");
INSERT INTO mlh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Weu tebire iŋi bokirieya, “Maneni, ŋoko sitio ropebire ŋi mo obu dero kukugaru wareko bofukenimi. Bofukeru iŋo boyoberu raru pi ropeiŋ, oo ropeni. ");
INSERT INTO mlh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Roperu pi rauine iŋi ojini, ‘Qaqajiji gore miga: Ogo pigo uro? Niŋoji soine ore maŋineo wareru kiŋariŋpune yoŋoke Pasowa lama nokimiŋ?’ ");
INSERT INTO mlh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Oŋu ojibire maneru pi paiineo paibe roperu maŋine soguine mo ŋatuiŋ. Oo ŋeŋe ya bomogabi ŋega. Oi ŋatuko oo lama qaku rigani.” ");
INSERT INTO mlh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Oŋu miku sore yapeme raru Yesuji buŋo miya, ore so bofukeru dimaku lama qaku rigaru bomogabu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Uqo damaŋineji wareko Yesuji aposolpuine yoŋoke uqo nokimiŋ ore wakiru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ŋebi iŋi yajiya, “Nonji Pasowa lama yo ŋoŋoke nokimiŋ ore aŋi kokoine maneru goboŋ. Uqo yo nobe tariko joiserereŋ manebemiŋ. Ore damaŋineji bembeŋgaga. ");
INSERT INTO mlh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Oi bembeŋgaga ore iŋi ŋajibe maneniŋ: Nonji Pasowa lama moreŋgo yoo jikigaru so nobemiŋ. Jiki uqo tebu yoore foriine fuŋine mo fukeiŋ, oi Anuture qorumaŋ maŋgo paibe nobemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Oŋu yajiru wain popu roru mifiagaru iŋi miya, “Yo roru ŋoŋo-ŋaŋe boroiŋgaru noniŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nonji iŋi ŋajibe maneniŋ: Noŋ wain niginde foriine yoo moke jikigaru so nobemiŋ. Moke nobemiŋ, oi Anuture qorumaŋ fuke foreko oo nobemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Oŋu miku poroŋ roru mifiagaru baji yareru iŋi miya, “Yo nakene fune. Oi ŋoŋore eru ŋarego. Oi noku noŋ manesu nuinebi.” ");
INSERT INTO mlh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Oi yareme nobi wain popu oŋuakoŋ roru iŋi miya, “Popu yo oi jojofo buru gariinere popu fukega. Nonji munaŋ qa ŋarebemiŋ ore eru darine keseru komebemiŋ. Dari oiji Anuture jojofo buru oi basanaŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Oŋu fukegayoŋ, maneniŋ, babae banuiŋ, iŋoji moko yoo uqo noku ŋegobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Fofori, Anutuji mitigaya ore so Sombuŋ eru morende Ŋi foriineji moreŋ bokeru raiŋ. Raiŋyoŋ, babae bateiŋ, iŋore oŋga joraku ‘O yei!’ migo. Anutuji geoine ropekiine kerisieru oteiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Oŋu miko kiŋariŋpuineji fuŋgaru botuyaŋuŋgo mi maneru weweu eku mibuŋ, “Niŋoreone moji babae batena?” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","“Kiŋariŋ niŋoreone moji minebobo qoruine fukega?” oŋu mibi ore eru oŋuakoŋ botuyaŋuŋgo migobobo ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Oŋu ebi Yesuji iŋi yajiya, “Morende kantriine kantriine yoŋore kiŋ koitoji ŋi ofoŋ oŋuine fukeru siŋaŋ yabeegobi. Yoŋore koito wakimiine muraŋyaŋunji buŋo mitigaku kufufuŋyaŋuŋ botiŋ yabebi kiŋaŋ qa yareku ‘Ŋi fiine!’ miku miteŋ yabeegobi. ");
INSERT INTO mlh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Oŋu eegobiyoŋ, ŋoŋoji ore so, so einebi. Ŋoŋore botugo moji soguneŋaŋuŋ fukega, iŋoji wawakiine oŋuine fukeru goine. Mineboboine qoruineji kiŋaŋqoqo oŋuine fukeru goine. ");
INSERT INTO mlh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Moji ŋeku uqo noko moji uqo keku oteru ra wareega, yokoreone ropekiine oi moji? Fofori, ‘Ŋeku uqo noga, iŋoji ropekiine fukega.’ Oŋu ŋajiegobiyoŋ, nonji ŋoŋore botugo kiŋaŋqoqo oŋuine fukeru gogo. ");
INSERT INTO mlh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Oŋu gobe esoi nubi koŋkoŋ sombuineke ore maŋineo ropebe ŋoŋo jibu yameŋ keku noke qakatoru go wapegobi. ");
INSERT INTO mlh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mamaneji mitiga nareme nonji iŋore qorumaŋ usuŋ paiineo siŋaŋ gaego. Ore eru nonji jikigaru mitiga ŋarebe ŋoŋo oŋuakoŋ usuŋ paiineo ŋiŋigo kiŋ oŋuine siŋaŋ yabeenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ore eru ŋoŋo soine nonde qorumaŋgo roperu uqo ŋeŋene roregaru ŋeku obu eru uqo noku gonimiŋ eru ŋi ofoŋ ŋeŋeo ŋeku Israel kufufuŋ kubu 12 yoŋore buŋo osoeru mitari yarenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesuji miya, “O Saimon Saimon, mane! Kesari ŋiji wit kurumbu koruŋ juago ruaru tieko komoŋine roiŋgaru wakiega, Satanji ore so ŋoŋoji wirieru iŋore meo wakinimiŋgo itiriŋgaru esoi eŋareiŋgo yameŋ keku jauega. ");
INSERT INTO mlh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Jauegayoŋ, gore mamanesinji gbaŋiru egu mataeiŋ ore nonji gore oŋga wosiru goboŋ. Ore eru damaŋ mogo maŋgo moke kerisieru nondeo waremiŋ, oo maŋkekerisie ogopugo kitiŋgaku basanaŋ yabeigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Oŋu miko Saimonji bokirieya, “Ofoŋ, nonji goke witi pigo ranimi ore eru moko komenimi ore jaueru gogo.” ");
INSERT INTO mlh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Oŋu bokirieyayoŋ, Yesuji ojiya, “Pita, nonji iŋi gajibe mane: Qoquji muŋambe so oŋgame goji bonieru ‘Iŋo so manego,’ miku noŋ muga nunde ateine yokaomo fukeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesuji kiŋariŋpuine iŋi weu yareya, “Nonji ŋoŋo bonieru kekereŋaŋuŋ tomiri, moneŋ kopu kekereŋaŋuŋ tomiri, kufu komoŋ-ŋaŋuŋ tomiri oŋu sore ŋabebe rabuŋ, damaŋ oo ya more embimbiŋgabuŋ me mata?” Weu yareme “Ya more so embimbiŋgabeŋ,” ojibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ojibi iŋi jikigaru yajiya, “Rone oŋu ebuŋyoŋ, damaŋ yoo more kekere eru moneŋ kopu kekere pega, oi roru ruberu goigoŋ. Jigore siqo sogo oi more so pega, iŋoji marikuine furiine banimiŋ ore ruaru moneŋ bofukeru siqo oi furiine baigoŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nonji ore eru iŋi ŋajibe maneniŋ: Anuture buŋoo nonde mibi pega, buŋo sosowo oi foriineke fuke foreiŋ. Ore damanji ware fukeiŋgo ega. Biŋe buŋo mo oi iŋi quraŋgabi pega, ‘Iŋoji sembene bobo yoŋore kubuo peine, mibuŋ.’ Ore eru migo: Buŋo ore foriine oi nondeo fuke foreiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oŋu yajiko kiŋariŋpuineji ojibuŋ, “Ofoŋ ŋone, jigore siqo sogo yoyoka yoo ŋegobire.” Oŋu ojibi “Oi sagaga,” miku bokirie yareya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesuji pi bokeru mosiine boyoberu Oliwe yo tukuo ropeko kiŋariŋpuineji ŋadiineo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Oo roperu iŋi yajiya, “Eesoigo egu waki ŋabeiŋ ore oŋgawowosi gio baniŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Oŋu yajiru boke yaberu ko bokebeneŋ raega, ore so raru dikanji keru oŋga wosiya. ");
INSERT INTO mlh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Oŋga wosiru iŋi miya, “Mamane, goji maŋ aŋigo manege ine, joisererende popu yoji nonde paio egu ropeiŋ ore oga nu. Oga numiŋ me mata, oi gakere maŋ aŋire so fukeine. Oi nonde aŋire so mata.” ");
INSERT INTO mlh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Oŋu oŋga wosiko mimerereŋ moji Sombuŋgone fukeru basanaŋgaya. ");
INSERT INTO mlh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Basanaŋgako koŋkoŋ ropekiine maneru yameŋ keku maŋine qojugaru oŋga wosiya. Oŋga wosime foroine oi dari jeje oŋuine oderu moreŋgo wakiya. ");
INSERT INTO mlh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Oŋga wosi foreru pakereru kiŋariŋpuine yoŋoreo raya. Raru bofukeru ŋone yabeme beusembeji bawaki yabeko kubaŋ pebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pebi yajiya, “Ŋoŋo wamore kubaŋ akoŋ pegobi? Pakereru eesoigo egu waki ŋabeiŋ ore oŋga wosiniŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesuji oŋu miku dimako oo akoŋ ŋi kubu wapebuŋ. Kiŋariŋpuine 12 yoŋoreone mo tinaine Judas iŋoji miine eyareku Yesureo waperu mi bibiine mudugaya. ");
INSERT INTO mlh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mudugayayoŋ, Yesuji iŋi ojiya, “Judas, go mi bibine mudugaru oŋuine oiji Sombuŋ eru morende Ŋi foriine babae ege me?” ");
INSERT INTO mlh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Oŋu fukeko goineji Yesu roregaru dimabuŋ, yoŋoji ya fukeiŋgo eme oi ŋoneru mibuŋ, “Ofoŋ, niŋo jigore siqo sogoji yabekimiŋ me?” ");
INSERT INTO mlh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Oŋu miku yoŋoreone moji soriŋ gio siŋaŋ qoruinere kiŋaŋqoqo qaku kaje furoine kemukume wakiya. ");
INSERT INTO mlh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wakiyayoŋ, Yesuji kirieru “Oi boke!” miku kiŋaŋqoqore kaje kemukuya, oi yoŋoko fiaya. ");
INSERT INTO mlh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Fiame dimaku soriŋ gio siŋaŋpuyaŋuŋ, sorinde sa siŋaŋ (sikiriti) qoruine eru kantrire minebobo yoŋoji Yesu roiŋgo wapebuŋ, yoŋo iŋi yajiya, “Noŋ suroŋqoqo ŋi matayoŋ, jibu nonde oŋu maneru jigore siqo sogo eru damu roru wapegobi. ");
INSERT INTO mlh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nonji una so boji soriŋgo ŋoŋoke gobe ŋoŋoji meŋaŋuŋ sineru noŋ so oga nubuŋ. Oi matayoŋ, muŋambe yoo qisirire usunji gbiŋ eru totogo fukeko ŋoŋore damanji ware fukega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Oŋu fukeko mamari ŋi yoŋoji Yesu roru kiperu ogagaru soriŋ gio siŋaŋ qoruinere pigo rabuŋ. Rabi Pitaji ŋadiyaŋuŋgo taitai yobe yabeku raya. ");
INSERT INTO mlh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Oo raru morumboŋ pire sa maŋineo rakaru kae jiŋo botuineo misi rigaru moko ŋebuŋ. Pitaji oŋuakoŋ yoŋore botugo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ŋeko kiŋaŋqoqo ŋigo moji Pitaji misi bembeŋgo ŋeko bibitatara eru iŋi miya, “Ŋi yoji oŋuakoŋ iŋoke goya.” ");
INSERT INTO mlh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Oŋu miyayoŋ, Pitaji mugaru iŋi ojiya, “Ŋigomeŋ, nonji oi so manego.” ");
INSERT INTO mlh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Oŋu ojiru ŋeko so joroko ŋi moji iŋo ŋoneru ojiya, “Go oŋuakoŋ yoŋoreone mo fukege.” Oŋu ojiyayoŋ, Pitaji bokirieya, “Ogone, noŋ mata.” ");
INSERT INTO mlh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aua moakonde so tariko moji buŋo oi moke yameŋ keku miya, “Ŋi yoji oŋuakoŋ fofori iŋoke goya. Iŋoji Galili ŋi fukega.” ");
INSERT INTO mlh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Oŋu miyayoŋ, Pitaji bokirieya, “Ŋimeŋ, buŋo mige, nonji oi kikiraŋgago.” Oŋu bokirieru miku dimako oo akoŋ qoquji oŋgaya. ");
INSERT INTO mlh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Oŋgame Ofonji kirieru Pita piku ŋoneko oo akoŋ buŋoine iŋi miya, oi manesuya, “Go muŋambe ateine yokaomo muga nunde qoquji oŋgaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Buŋo oi manesuku beuine pougaiŋgo eko sakibe rakaru bobiqobiri eku kuyoya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mamari ŋi Yesu roru kipebuŋ, yoŋoji igosisi eteru dimaku kepiebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kepieru jiŋo maiine komoŋ garu weu teru ojibuŋ, “Go kajeqouŋ ŋi fukege ore moji guga, iŋore tina miigoŋ!” ");
INSERT INTO mlh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Oŋu miku kokoine oŋga rurugaku igosisi eteku mi qopiebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Miku qopieru gokabi kae fureme kantrire minebobo eru soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji tumaŋgaru Yesu ogagaru Juda yoŋore soriŋ kaunsol kubu yoŋore jiŋo maio ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Oo ruabi ojibuŋ, “Goji Munaŋqoqo Rauine Kristo fukege ine, oi totogo misoguende manekimiŋ.” Oŋu ojibi bokirieya, “Oi ŋajinoboyoŋ, oi so manesiŋ ganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Me weu ŋarenoboyoŋ, oi so bokirie narenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Oŋu manegoyoŋ, damaŋ yoo akoŋ fuŋgaru Sombuŋ eru morende Ŋi foriine iŋoji Anutu, usuŋ Rauinere me furoineo ŋeku goiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Oŋu bokirieme oo akoŋ sosowo yoŋoji iŋi miku weubuŋ, “Fofori, go Anuture made fukege me mata?” Oŋu weu tebi iŋi bokirie yareya, “Oi fukeinde buŋo oi ŋoŋo-ŋaŋe migobi.” ");
INSERT INTO mlh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bokirie yareko mibuŋ, “Iŋoyoŋe sakigo rua qaku komeinde kikitiŋ buŋoine iŋoyoŋunde miineji miko mane foregobeneŋ. Ore eru goineji buŋoine kitiŋganimiŋ ore wamore moke weu yarenobeŋ?” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oŋu miku kubu sosowo yoŋoji pakereru Yesu ogagaru raru gawana Pailotreo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Iŋoreo raru fuŋgaru sakiineo buŋo bapakareru iŋi mibuŋ, “Ŋi yoore fuŋne oi iŋi ŋoneru manebeŋ: Iŋoji ŋiŋigo bapakare yabeko bojiqojibu fukeko oyowo eegobi. Niŋo Sisa-kiŋ koitore takis so ruakimiŋ ore agi baega. Iŋoyoŋere ‘Noŋ Munaŋqoqo Rauine Kristo eru kiŋ fukego,’ oŋu miega.” ");
INSERT INTO mlh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Oŋu mibi Pailotji iŋi weu teya, “Fofori, go Juda yoŋore kiŋ koitoyaŋuŋ fukege me mata?” Weu teko Yesuji bokirieru miya, “Oi gake mige, oŋu.” ");
INSERT INTO mlh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailotji soriŋ gio siŋaŋ eru ŋiŋigo kubu yoŋo iŋi yajiya, “Nonji ŋi yoore baka mo so bofukego.” ");
INSERT INTO mlh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Oŋu yajiko moke yameŋ keku bapakareru mibuŋ, “Iŋoji ŋiŋigo kubu bapakare yaberu Biŋe buŋoine Galili prowinsgo fuŋgaru qaji yareru moreŋ sagame wareru Judia prowins yoo oŋuakoŋ oi misaueega.” ");
INSERT INTO mlh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Oŋu mibi maneru weu yareru miya, “Iŋo Galili ŋi fukega me mata?” ");
INSERT INTO mlh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Oŋu miko “Oŋu!” mibi maneru Herodji Galili eru prowins goine qodureru siŋaŋ yaberu damaŋ oo akoŋ Jerusalem sitio wareru goya, ore eru Pailotji miko Yesu Herodreo ogaru rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodji Yesure binaŋ maneru damaŋ joroine ŋoneiŋgo aŋi maneru goya ore eru iŋo ŋoneru maŋineji kokoine fiaya. Yesuji mosi qoqowirie mo bako ŋoneiŋgo eru odigaru goya. ");
INSERT INTO mlh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ore eru weweu kokoine Yesu weu teya. Oŋu weu teyayoŋ, Yesuji mobeine mo so bokirieya. ");
INSERT INTO mlh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Soriŋ gio siŋaŋ eru Kadi buŋore qaqaji yoŋoji dimaku sakigo rua buŋo joineke mitebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodji mamari ŋipuine yoŋoke Yesu bawaki ruaru mipemiriŋ eru igosisi etebuŋ. Oŋu eru mariku kuririineke mo ketebi dimako soreme moke gawana Pailotre jiŋo maio raya. ");
INSERT INTO mlh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Rone Pailot eru Herod yokoji rorosi naduŋgaduŋ eku gobuyoŋ damaŋ oo oogo fukebu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesuji wareko gawana Pailotji soriŋ gio siŋaŋ eru siŋaŋyayabe ŋipuine eru ŋiŋigo kubu kepore yabeme tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tumaŋgabi iŋi yajiya, “Ŋoŋo ŋi yo iŋi miku nondeo ogagaru waregobi, ‘Iŋoji ŋiŋigo kubuine kubuine bapakare yabeko bobojibu eegobi.’ Maneniŋ! Ŋoŋo buŋo sakiineo ruagobi, nonji ore fuŋine yoŋore jiŋo maio osoeru iŋi bofukego: Ŋoŋo ŋi yoore sakiineo buŋo sosowo ruagobi, nonji ore bakaine mo so bofukego. ");
INSERT INTO mlh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodji buŋo oŋuakoŋ miku soreme moke niŋoreo warega. Maneniŋ, iŋoji ya bakaineke mo so baya. Ore eru komere biŋe fukeiŋgo embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ore eru nonji mibe mamari ŋi yoŋoji ŋoŋoruji akoŋ qabi piruebe wakiiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Pailotji gosa so Pasowa jeri damaŋgo witi piineone ŋi moakoŋ pirue yabeeya.) ");
INSERT INTO mlh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Oŋu yajiko sosowoji jojoraku oŋgaku mibuŋ, “Iŋo kepieru (use)! Barabas pirueru noreigoŋ!” ");
INSERT INTO mlh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasji sitio oyowo baku gobuŋ, yoŋore siŋaŋ fukeru ŋi mo qame komeya, ore eru witi pigo ruabi ŋeya. ");
INSERT INTO mlh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailotji Yesu piruebemiŋ ore maneru buŋo moke miya. ");
INSERT INTO mlh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Miyayoŋ, yoŋoji igogaru buŋo siaine bajiru oŋga jorabuŋ, “Maripoŋgo qaniŋ! Iŋo maripoŋgo qaniŋ!” ");
INSERT INTO mlh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Oŋga jojorabi iŋoji buŋo ateine yokaomo iŋi yajiya, “Iŋoji wamo sembene baya? Nonji iŋore baka mo so bofukebe komere biŋe fukeiŋ ore so, so fukega. Oŋu fukeko nonji mibe mamari ŋi yoŋoji ŋoŋoruji akoŋ qabi piruebe wakiiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Oŋu yajiyayoŋ, yoŋoji jauba eku yameŋ keku jikigaru oŋga jojoraku oŋgabuŋ, ‘Yesu maripoŋgo qabi komenoŋ.’ Oŋu oŋgaku Pailotre buŋo oi kepiebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kepiebi Pailotji buŋoyaŋunde rurumaŋgo raru buŋo yameŋ keku mibuŋ, ore foriine fukeiŋ ore mitariya. ");
INSERT INTO mlh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mitariku “Barabas wakiine!” miku yameŋ kebuŋ ore iŋo pirueko wakiya. Iŋo oyowo baku gobuŋ, yoŋore siŋaŋ fukeru ŋi mo qame komeya ore eru witi pigo ruabi ŋeya. Iŋo pirueko wakiyayoŋ, Yesu aŋiyaŋuŋ boyoberu etenimiŋ ore meyaŋuŋgo ruaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pailotji Yesu meyaŋuŋgo ruame ogagaru kadi yasogoo raru Afrika siti tinaine Sairini ore ŋi mo tinaine Saimon bofukebuŋ. Iŋoji gioone wapeme mitiga teku Yesure maripoŋ roru iŋore gbeoo ruabi koboru boyoberu raya. ");
INSERT INTO mlh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Oŋu rako ŋiŋigo kubu soguine yoŋoji doduru ŋadiineo boyoberu rabuŋ. Yoŋore botugo ŋigo goineji oŋuakoŋ jiŋgeŋ keku kuyoku rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kuyoru rabi Yesuji kirieru ŋone yaberu iŋi yajiya, “O Jerusalem ŋigo, ŋoŋo nonde so kuyoniŋ. Nonde matayoŋ, ŋoŋo-ŋaŋe eru odumadepuŋaŋuŋ yoŋore kuyoinebi. ");
INSERT INTO mlh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maneniŋ! Jiki damaŋ mo wareko oo iŋi minimiŋ, ‘Ŋigo kufiŋine yoŋo kiwaqawayaŋuŋke. Kua so eru odumade so robuŋ, yoŋo kiwaqawayaŋuŋke fukegobi. Odumade moŋ yareru so qugabuŋ, yoŋo kiwaqawayaŋuŋke.’ ");
INSERT INTO mlh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Damaŋ oo ŋiŋigoji fuŋgaru tuku Rauine yoŋo iŋi karie yabenimiŋ, ‘Ŋoŋo tuku oi mibi pogaru painoŋuŋgo ropenimiŋ.’ Eme koru Rauine oi iŋi karie yabenimiŋ, ‘Ŋoŋo kouŋyaŋuŋgo sumuŋ nobeniŋ.’ ");
INSERT INTO mlh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Nonji Anuture yo gariine fukego eru nonde jibu iŋi enaregobi. Ŋoŋo yo komiine agiburaŋ-ŋaŋuŋke oŋuine dimagobi. Ore eru Anutuji geoine bokirie ŋareme misiji ja ŋabeko joiserereŋ ropekiine manenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Sembene bobo yoyoka yoko oŋuakoŋ Yesuke moko yapeiŋgo ore oga yaperu rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Raru moreŋ tinaine Qorusia migobi, oo roperu Yesu maripoŋgo qabuŋ. Qaku sembene bobo yoyoka oi moko mo furoineo mo kijoineo mobemobe oŋu yapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Oŋu ebuŋyoŋ, Yesuji miya, “Mamane, yoŋoji ya egobi, ore fuŋine so mane mukugobi ore agiburaŋyaŋuŋ boke yare.” Qabi dimako Yesure saki komoŋinere qosa qabi jare fukeko ore so oi boroiŋgaru robuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Oŋu ruabi ŋiŋigo kubu yoŋoji dimaku oi piku ŋonebuŋ. Ŋonebuŋyoŋ, Juda minebobo yoŋoji oŋuakoŋ igosisi eteku iŋi mibuŋ, “Anutuji roosoeko Munaŋqoqo Rauine Kristo fukega ine, goine bapi yaberu goya, iŋoji iŋoyoŋe babapi enoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mamari ŋi yoŋoji oŋuakoŋ buŋo gogoukerekere miku igosisi eteku bembeŋgo raru wain obu jajaineke igokuru garu ba roperu oteru ");
INSERT INTO mlh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","iŋi ojibuŋ, “Go Juda yoŋore kiŋ koito fukege ine, soine gake babapi enoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Qoruineo paibe quraŋ mo iŋi quraŋgaru qabi dimaya, “Juda yoŋore kiŋ koito yo.” ");
INSERT INTO mlh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Suroŋqoqo ŋi yoyoka moko gbedi yapebi dimabu, yokoreone moji maŋqoqo buŋo fofoine Yesu miteku iŋi ojiya, “Go Munaŋqoqo Rauine Kristo fukege ine, gake babapi eru niko oŋuakoŋ bapi nope.” ");
INSERT INTO mlh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Oŋu ojiyayoŋ, ogoineji miteku iŋi ojiya, “Go arambobogo tomiri. Go Anuture oŋuakoŋ kokoi so manege me? Yoŋoji mitariku joiserereŋ sogokoŋ norebi osigagobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Niko fofori sembene ebe ore geoine sonokuŋgo bokirie notebi joiserereŋ manegobere. Oi manegobereyoŋ, ŋi yoji sembene mo so bako iŋo jibu sibirigagobi.” ");
INSERT INTO mlh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Oŋu miku ojiya, “Yesu, go qorumaŋgore maŋgo ropemiŋ, oo noŋ manesu nuigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ojiko iŋi ojiya, “Nonji buŋo foriine gajibe mane: Goji muŋambe noke seŋgiŋbaŋgiŋ kaeo roperu goigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Una botuine 12 kilok fukeko wegi jiŋoine gobureko qisiriji wakiru moreŋ sosowo sagaru peko raru aua yokaomo ore so eya. ");
INSERT INTO mlh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Damaŋ oo boji soriŋ maŋineo kambaŋ dimaya, oiji paibeone botuineo pougaru wakiru yoyoka fukeya. ");
INSERT INTO mlh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesuji damaŋ oo sanaŋine oŋgaku iŋi miya, “Mamane, noŋ iirune gore meo ruago.” Oŋu miku nakafe tatariine poreru komeya. ");
INSERT INTO mlh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Komeko ya fukeya, mamari siŋanji oi ŋoneru Anutu miteŋ garu iŋi miya, “Iŋoji fofori ŋi posiine fukega.” ");
INSERT INTO mlh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ŋiŋigo kubu sosowo oi ŋoneiŋgo wareru tumaŋgabuŋ, yoŋoji ya oi fukeko ŋoneru beuyaŋuŋ pougako qoru bokeru moakoŋ moakoŋ piyaŋuŋgo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Rabuŋyoŋ, ŋiŋigo sosowo Yesu mane tebuŋ, yoŋoji taitai dimaku oi piku ŋonebuŋ. Ŋigo goineji Yesu boyoberu Galilione warebuŋ, yoŋoji oŋuakoŋ dimaku oi ŋonebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Juda yoŋore taoŋ tinaine Arimatia oone ŋi fiine tinabiŋeineke tinaine Josef iŋoji oŋuakoŋ wareya. Iŋoji Anuture qorumande fori fukeiŋgo odigaru goya. Iŋoji Juda yoŋore soriŋ kaunsol kubure minebobo goku Yesure buŋo mikiperu ebuŋ, ore maŋmoakoŋ so eya. ");
INSERT INTO mlh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iŋoji Pailotreo raru Yesure qoŋgbuŋ roiŋgo weuya. ");
INSERT INTO mlh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Weuku roperu qoŋgbuŋine maripoŋgone bomukuru bawakiru kambaŋ yagaŋineji komoŋ gaya. Komoŋ garu roru jiŋoruŋgo raru ko kouŋ mo pujeru qoŋgbuŋ mo oo so ruabuŋ, oo Yesure qoŋgbuŋ oi ruaya. ");
INSERT INTO mlh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sabat kombaŋ ŋeŋere yaine bomogabuŋ, (maŋgogio) ore wegi jiŋo rakaiŋgo eya. ");
INSERT INTO mlh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Rakaiŋgo eko ŋigo Yesuke Galilione warebuŋ, yoŋoji Josefre kufuineo jiŋoruŋgo raru iŋoji Yesure qoŋgbuŋ roru ko kouŋgo ruaya, oi ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Oone kirieru pigo raru jinaŋ yojikou mumundoineke eru jiji koŋoineke Yesure qoŋgbuŋineo rau teiŋgo bomogabuŋ. Bomogabuŋyoŋ, Mosesji Kadi buŋoo Sabat kombande mitigako peya, oi boyoberu ŋeŋemane eku mo ŋebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sabat kombaŋ ŋebi tariko Sonda kae fufurere yobu ŋigo yoŋoji pakereru juŋ jinaŋ mumundoineke bomogabuŋ, oi roru jiŋoruŋgo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Raru moji jiŋorunde siroŋgo ko yasogo igogako raya, oi ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oi ŋoneru ko kounde maŋgo ropebuŋyoŋ, Ofoŋ Yesure qoŋgbuŋ so bofukebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ore eru maŋyaŋuŋ rope wakiko maneru dimabi ŋi yoyoka marikuyakuŋ yagaŋine buruburuineke yokoji maŋfuŋyaŋuŋgo dimabire ŋone yapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yoko ŋone yaperu waragaku moreŋgo rakaru dunduŋ pebi iŋi yajibu, “Gariine sanaŋgaru goga, iŋo uruŋure komiine yoŋore botugo baagobi? ");
INSERT INTO mlh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iŋoji yoo so pegayoŋ, gboreru pakereye. Galili prowinsgo goku buŋo yajiya, oi manesuinebi: ");
INSERT INTO mlh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Iŋoji iŋi miya, ‘Moji Sombuŋ eru morende Ŋi foriine babae bateme gawman ŋi kekesuesueyaŋuŋke yoŋore meo rako maripoŋgo qabi komeru una yokaomo fukeko gboreru pakereiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Oŋu mibire buŋoine oi mamaneyaŋuŋgo ropeme manesubuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Oŋu manesuku jiŋoruŋgone kirieru wareru ya sosowo fukeya, ore biŋe buŋoine oi kiŋariŋ 11 eru goine sosowo oi yajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Buŋo oi yajibuŋ, yoŋo Maria Magdalane, Joana eru Maria Jeimsre maŋgo eru ŋigo goine yoŋoke gobuŋ, yoŋoji buŋo oi wareru aposol yajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Biŋe buŋo oi yajibuŋyoŋ, oi manebi buŋo omaine fukeme oi so manesiŋ gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","So manesiŋ gabuŋyoŋ, Pitaji pakereru giniŋgaru jiŋoruŋgo raru ko kounde maŋgo pime rako kambaŋ yagaŋine komoŋ gabuŋ, oi akoŋ ŋeko ŋoneya. Oi ŋoneru ya fukeya, oi iŋoyoŋe akoŋ manesuku waragaru pigo kirieya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Una oo akoŋ Yesure kiŋariŋpu yoŋoreone yoyokaji Jerusalem siti bokeru kae tinaine Emaus sewen mail oo raiŋgo rabu. ");
INSERT INTO mlh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kadio raru ya fukeya, oi sosowo yokoyoke akoŋ mimane ebu. ");
INSERT INTO mlh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Oi mimane eku fuŋine miku yobiŋgaru rabire Yesuji iŋoyoŋe maŋfuŋyakuŋgo ropeme moko rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Rabuŋyoŋ, jiŋoyakuŋ kejigako iŋo so ŋone mukubu. ");
INSERT INTO mlh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","So ŋone mukubire iŋi yasiya, “Ŋoko ŋokoŋake akoŋ wamo buŋo kadio mimane eku waregobire?” Oŋu yasiko sorondoŋ eru beusembe jiŋo piku ŋoneru dimabu. ");
INSERT INTO mlh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ŋoneru dimaku yokoreone mo tinaine Kliopas iŋoji iŋi weu teya, “Pasowa kombaŋgo ya fukeya, oi Jerusalem ŋiŋigo sosowoji manegobi. Go moakonji kotu fukeru oi so manege me?” ");
INSERT INTO mlh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Weu teko “Oi wamo ya?” miko maneru iŋi ojibu, “Nazaret ŋi Yesureo ya fukeya, oi. Iŋoji kajeqouŋ ŋi goku Anutu eru ŋiŋigo sosowo yoŋore jiŋoo eebobo usuŋineke baku buŋo sanaŋine miku goya. ");
INSERT INTO mlh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Oŋu gome noŋunde soriŋ gio siŋaŋ eru siŋaŋyayabe ŋipunoŋunji iŋo ogagaru gawanare meo ruabi komeiŋgo mitariko maripoŋgo qabi komeya. ");
INSERT INTO mlh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Iŋoji Israel kufufuŋnoŋuŋ nigiŋgone pirue nobeku duenoŋuŋ baiŋgo odigaru origaru gobeŋyoŋ, ‘Yei!’ Iŋo qabi komeya. Ya oi fukeko go wapebeneŋ muŋambe una yokaomo fukega. ");
INSERT INTO mlh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Oi so sagako muŋambe niŋoreone ŋigo goineji buŋoji igodoŋ noberu waraga norebi gogobeneŋ. Yoŋoji kae fufure yobu jiŋoruŋgo raru ");
INSERT INTO mlh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","qoŋgbuŋine so bofukeru kirieru iŋi migobi, ‘Niŋo Sombuŋ mimerereŋ yoyoka qohoŋ iru ŋonebeneŋ yokoji “Yesuji gboreru goga,” ’ mibi manegobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Buŋo oi maneru ŋi niŋoke gogobi, yoŋoreone goineji jiŋoruŋgo raru ŋigo yoŋoji buŋo migobi, ore so peko ŋonegobi. Yoŋ taine ŋonegobiyoŋ, iŋoyoŋe so ŋonegobi.” ");
INSERT INTO mlh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Buŋo oi maneru iŋi yasiya, “Yei! Ŋoŋo kajeqouŋ yoŋoji buŋo mibuŋ, oi sosowo wamore etaŋqataŋ eru mujugaru tuturi goku so manesiŋ gagobi? ");
INSERT INTO mlh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Munaŋqoqo Rauine Kristoji joiserereŋ oŋuine maneru iŋoyoŋunde kuririquraŋ maŋgo ropeiŋ. Ore so quraŋgabi pega me mata?” ");
INSERT INTO mlh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Oŋu yasiru Moses eru kajeqouŋ ŋiŋigo sosowo yoŋoji buŋo mibuŋ, oone fuŋgaru iŋoyoŋunde buŋo sosowo quraŋgabi pega, ore fuŋine mitaniŋga yateya. ");
INSERT INTO mlh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mitaniŋga yateru raru kaeo raiŋgo miku rabu, oi bembeŋgaru oo jikigaru raiŋgo maneya. ");
INSERT INTO mlh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Oŋu maneyayoŋ, yokoji yameŋ keku iŋi ojibu, “Kae ubu eme wegi jiŋoji rakaiŋgo ega. Ore eru soine nikoke ŋeku peigoŋ.” Oŋu ojibire yokoke pigo roperu ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ŋeku yokoke uqo noiŋgo ore eru poroŋ roru mifiagaru bajiku yateiŋgo eko ya iŋi fukeya: ");
INSERT INTO mlh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Oo akoŋ jiŋoyakunji tiŋako ŋone mukubire jibugame moke so ŋonebu. ");
INSERT INTO mlh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Oŋu fukeko yokoyoke akoŋ iŋi mimane ebu, “Kadi yasogoo Biŋe Qurande buŋo miku fuŋine mitaniŋga noteya, damaŋ oo akoŋ maŋnokuŋgo jo jaga ore so manegobere.” ");
INSERT INTO mlh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Oŋu miku oo akoŋ pakereru Jerusalem sitio kirieru roperu kiŋariŋpuine 11 eru ogopuyaŋuŋ yoŋoke tumaŋgaru ŋebuŋ, oi bofuke yabebu. ");
INSERT INTO mlh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bofuke yabebire iŋi yasibuŋ, “Ofonji foriine pakereru Saimon fuke tega.” ");
INSERT INTO mlh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Oŋu yasibi yokoyoke kadio ya fukeya eru poroŋ bajiya, damaŋ oo maŋyakuŋ untoko mane mukubu, ore sunduine ba yarebu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kiŋariŋpuine yoŋoji buŋo oi mimane eku ŋekabuŋ oo akoŋ Yesu iŋoyoŋe botuyaŋuŋgo fukeru dimaku iŋi yajiya, “Ogopune, womoji ŋoŋoke peine!” ");
INSERT INTO mlh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Oŋu yajime kokoi maneru gburugburu yabeme “Gemo iiru ŋonegobeneŋ,” oŋu manesubuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Oŋu manesubuŋyoŋ, iŋi yajiya, “Ŋoŋo uruŋure popureru mamane oŋuine maŋ-ŋaŋuŋgo fukega? ");
INSERT INTO mlh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Noŋ nake yoo gogo. Oi ŋoŋo-ŋaŋekoŋ kufu mene piku ŋoneru maneniŋ. Gemo iiru yoŋo sia fuyaŋuŋ tomiri. Noŋ sia funeke dimabe ŋone nugobi. Ŋoŋo yoŋo nuru ŋone muku nuniŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Oŋu yajiru me kufuine yaduya. ");
INSERT INTO mlh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yaduyayoŋ, oi jeribariyaŋuŋ ore jibu so manesiŋ garu waragaru ŋekabi iŋi weuku yajiya, “Uqo munjaŋ-ŋaŋuŋ mo yoo ŋega me mata?” ");
INSERT INTO mlh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Oŋu weuku yajiko jembaeŋ rigakiine mobeine mo otebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Otebi roru noko ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Noko ŋonebi iŋi yajiya, “Noŋ ŋoŋoke goku damaŋ oo buŋo ŋajibe manebuŋ, ore foriine oi damaŋ yoo fukeko ŋonegobi. Nonji iŋi miku goboŋ: Nonde buŋo oi Mosesre Kadi buŋo eru kajeqouŋ ŋi yoŋore Biŋe Quraŋ eru Miti kiki (Owaowa kiki) buk maŋgo quraŋgabi pega, oi sosowo foriineke fuke foreiŋ.” ");
INSERT INTO mlh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Oŋu yajiru oo akoŋ Biŋe Qurande fuŋne mane mukunimiŋ ore maŋyaŋuŋ bouŋtoya. ");
INSERT INTO mlh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Bouŋtoru iŋi yajiya, “Buŋo iŋi quraŋgabi pega: Kristoji joiserereŋ mane komeru una yokaomo fukeko komegone pakereiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ore eru ŋoŋoji Jerusalem sitio fuŋgaru Biŋe buŋo nonde tinao mitaniŋgaru kantri sosowo sagaru raru maŋbapakare eyareeinebi. Uri yoŋo maŋyaŋuŋ kerisienimiŋ, Anutuji yoŋore agiburaŋ jureru bokeiŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Buŋo oi foriineke fukeya eru fukeiŋ, ŋoŋo oi fukeko ŋoneru kitiŋgaku miku munaŋ moge ore so dimainebi. ");
INSERT INTO mlh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Maneniŋ! Mamaneji yauŋ ŋareinde buŋo kipeya, nonji oi sorebe maŋ-ŋaŋuŋgo rakaiŋ. Paibene usuŋ ruabe paiŋaŋuŋgo ropeiŋ. Ŋoŋo siti yoo ore eru odigaru ŋeku goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesuji buŋoine miforeru kiŋariŋpuine oga yaberu raru Betani kae bembeŋgo roperu oo meine romaeŋgaru mifia yareya. ");
INSERT INTO mlh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mifia yareko oo akoŋ Anutuji ogagame boke yaberu Sombuŋgo ropeya. ");
INSERT INTO mlh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ropeko jeri soguine maneru daberu ohoweine baku miteŋ garu Jerusalem kiriebuŋ. ");
INSERT INTO mlh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kirieru jijiki boji soriŋgo goku Anutu miteŋ garu gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fuŋfuŋgaineo ronere ronekoŋgo mibuŋo goya. Iŋoji gogore fuŋne kitiŋgaku miku pakereru goya. Buŋo miine iŋoji Anuture keririŋgo go pakereya eru iŋoyoŋe Ofoŋ Anutu akoŋ fukega. ");
INSERT INTO mlh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mibuŋo iŋoji fuŋfuŋgaineo Anuture keririŋgo goya. ");
INSERT INTO mlh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iŋore keririŋgo goku bapi gako ya sosowo fukeya. Ya mo so bapi gana, oi so fukena. ");
INSERT INTO mlh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mi buŋo iŋoji gogore fuŋqodu fukega. Iŋore gogo sanaŋine oiji ŋiŋigo bataniŋ yabeme ŋoneru go pakerebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tatamaineji qisiri maŋgo fureegayoŋ, qisirigo gobuŋ, yoŋoji tatamainere fuŋne oi so mane taniŋgaru go wapebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Anutuji ŋiŋigo sosowo tatamaine manesiŋ ganimiŋ ore maneru kiŋaŋ ŋi tinaine Jon soreme fukeya. Fukeru wareru tatamainere fuŋne barariŋga yareru kitiŋgaku miku goya. ");
INSERT INTO mlh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon iŋoyoŋe tatama oi so fukeru goyayoŋ, iŋoji tatamainere fuŋne oi kitiŋgaku miku goya. ");
INSERT INTO mlh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tatama foriine yobu iŋoji ŋiŋigo kae so bataniŋ nobeega, iŋoji moreŋgo fukeiŋgo eya. ");
INSERT INTO mlh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iŋoji fuŋfuŋgaineo moreŋine moreŋine ore yareyaine sosowo oi maŋgo eyareko fukebuŋ. Fukebi iŋoyoŋe botuyaŋuŋgo go wapeyayoŋ, moreŋ ŋiŋigoji jibu oi so mane muku teru mo gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Oŋu koŋkoŋ gokabi iŋoyoŋunde kae pigo wareme kufufuŋpuineji taki yabeme keta eru ŋadi gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Oŋu ebuŋyoŋ, uri yoŋo keporeru tinabiŋeine maneru manesiŋ gabuŋ, iŋoji sosowo yoŋore kadi bataniŋgame iŋi fukeya: Iŋoyoŋe maŋgo eku usuŋ yareme fufuke gariine fukeru Anuture odumadepu fukebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Anuture maŋ aŋiji maŋgo eyareko fukebuŋ. Moreŋ ŋiji aŋiine boyoberu ŋonuŋineke buŋo kipeme kua eru made roko fukega, yoŋoji mosi oŋuine oiji Anuture odumadepu so fukebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mi buŋoine iŋoji ŋi saki fuineke fukeru botunoŋuŋgo roware eru goya. Oŋu goko kuririine piku ŋoneru gobeŋ. Mamaineji Madeine moakoŋ iŋore kuririine sosowo ruaru mumuineo keteme fuŋine mo goga, iŋoji ore so touŋmoririineji maŋine puseko kuririquraŋineke fukeru damaŋ so buŋo foriine yobu miku goya. ");
INSERT INTO mlh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jonji ŋi ore fuŋine kitiŋgaku iŋi oŋgaku miku goya, “Nonji more buŋo miku goboŋ, iŋoji oi fukega. Iŋi miku goboŋ: Nonde ŋadio ŋi mo wareiŋ, nonji so fukebe iŋoji ronekoŋ goya. Ore eru iŋore tinabiŋeji noŋ nadureru ropekiine fukega.” Jon Mitimeso ŋiji oŋu miku goya. ");
INSERT INTO mlh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yauŋmoririineji ŋi ore maŋine puseko kuririineke goya, iŋoji ore so mifia noreru goya. Mifiaine oi damaŋine damaŋine keseme sosowo niŋore paio ropeko gobeŋ. ");
INSERT INTO mlh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosesji Kadi buŋonoŋuŋ maŋgo eteko fukeyayoŋ, Yesu Kristoji buŋo foriine barariŋga noreru Anuture yauŋmoriri maŋgo eteko totogo fukeya. ");
INSERT INTO mlh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Moreŋ ŋi moji Anutu damaŋ mogo so ŋoneya. Madeine moakonji Mamainere beufuŋgo go waperu goya, iŋoji moreŋgo wakiru fuŋneine nodume manebeŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda minebobo yoŋo soriŋ gio siŋaŋ eru boji sorinde kiŋaŋqoqo goine Jerusalem sitione sore yabebi Jondeo warebuŋ. Wareru weu teru mibuŋ, “Go wamo ŋi fukege? Fuŋnego uruŋu?” Oŋu mikabi fuŋneine yaduru yajiya. ");
INSERT INTO mlh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Fuŋine so mugayayoŋ, totogo iŋi mifukeya, “Nonji Munaŋqoqo Rauine Kristo so fukego.” ");
INSERT INTO mlh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Oŋu mifukeme yameŋ keku weu tebuŋ, “Go ŋi mo fukege? Go Elaija fukege me mata?” Weu tebi “Mata!” miya. “Go kajeqouŋ ŋi mo fukege me mata?” Oŋu weukabi “Oŋu mata!” bokirieya. ");
INSERT INTO mlh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bokirieme weu tebuŋ, “Go mo fukege? Sore nobebi waregobeneŋ, yoŋo uruŋu bokirieru yajinobeŋ? Go gakere fuŋnego uruŋu mitaniŋgamiŋ?” ");
INSERT INTO mlh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Weubi iŋi yajiya, “Kajeqouŋ ŋi Aisaiaji buŋo mo iŋi miya pega, ‘Noŋ mimerereŋ fukeru moreŋ buroineo goku iŋi oŋgaeego: Ofonji wareiŋ-oo! Ore eru ŋoŋo bio maŋyaŋuŋ botiŋgaru kadiine boburoru bobiaŋgainebi.’ Noŋ ore kiŋaŋ mimerereŋ fukego.” ");
INSERT INTO mlh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ŋi sore yabebi Jondeo warebuŋ, yoŋo Farisi (Kadi buŋore yameŋyameŋ) ŋi fukebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yoŋoji moke iŋi miku weu tebuŋ, “Go Munaŋqoqo Rauine Kristo so fukege eru Elaija me kajeqouŋ ŋi yoŋoreone mo so fukege, ore go wamore ŋiŋigo miti meso rau yareege?” ");
INSERT INTO mlh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Weu tebi iŋi bokirie yareya, “Nonji obu omaineji rau ŋareegoyoŋ, ŋi mo ŋoŋo so mane mukugobi, iŋoji yoo botuŋaŋuŋgo dimaga. ");
INSERT INTO mlh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ŋi mo nonde ŋadio wareiŋgo miku goboŋ, iŋoji oi fukega. Iŋoji wareru noŋ nadureru sogunene fukeru goiŋ ore nonji iŋore bembeŋgo raru kopu kekereine ruberu kufu komoŋinere nigiŋ pirueiŋgo embimbiŋgabemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jonji Jordan obu mobeineo kae tinaine Betani oo goku ŋiŋigo miti meso rau yareru goya. Ya oi oo fukeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Oi fukeme kae fureme Jonji Yesu taitai wareko ŋoneru miya, “Ŋoneniŋ, ŋi oi Anuture lama made. Iŋoji moreŋine moreŋine noŋunde agiburaŋ keririkeko posikekimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nonji more buŋo miku goboŋ, iŋoji oi fukega. Iŋi miku goboŋ: Nonde ŋadio ŋi mo wareiŋ, nonji so fukebe iŋoji ronekoŋ go wapeya. Ore eru iŋore tinabiŋeji noŋ nadureru ropekiine fukega. ");
INSERT INTO mlh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nonji oi rone so mane mukuboŋyoŋ, Anutuji fuŋine Israel ŋiŋigo niŋo barariŋga noreme manekimiŋgo manega. Oi maneru noŋ sore nume wareru miti meso rau ŋareego.” ");
INSERT INTO mlh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jonji oŋu miku munaŋ moge oŋuine dimaku kitiŋgaku iŋi yajiya, “Moro Tiriineji Sombuŋgone wakiru kabu webo oŋuine iŋore qoruo waki keru ŋeko ŋoneboŋ. ");
INSERT INTO mlh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nonji oi rone so mane mukuru goboŋyoŋ, moji ŋiŋigo miti meso rau yarebemiŋ ore sore nuya, iŋoji iŋi najiya, ‘Moro Tiriineji more qorugo waki keru ŋeko ŋonemiŋ, iŋoji Moro Tiriine ŋiŋigo maŋyaŋuŋgo ruaku oiji miti rau yareiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nonji oi ŋoneboŋ ore eru fuŋine iŋi kitiŋgaku migo, ‘Iŋoji Anuture Made fukega.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Oŋu yajime kae ubu eme Jonji moke obu qaŋaŋineo oo akoŋ rako kiŋariŋpuine yoŋoreone yoyoka iŋoke moko dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dimabi Yesuji oo yadureru raya, oi poretiŋ piku bibitatara eku miya, “Ŋi oi ŋoneni. Iŋoji Anuture lama made fukega.” ");
INSERT INTO mlh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Oŋu miko kiŋariŋ yoyoka yokoji buŋo oi maneru Yesure ŋadio rabu. ");
INSERT INTO mlh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Rabire Yesuji kerisieru ŋadiineo warebu, yoko ŋone yaperu iŋi weu yateya, “Ŋoko wamo baaru waregobire?” Oŋu maneru kerisieru ojibu, “Sogunenokuŋ, go pi uro peku goge?” (Juda yoŋoji ‘Sogunenoŋuŋ’ buŋo oi qaqajire miegobi.) ");
INSERT INTO mlh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Oŋu ojibire bokirieya, “Ŋoko wareru ŋoneni!” Oŋu bokirieme wegi jiriŋine kerisieme 4 kilok oŋu fukeya. Wegi jiriŋine kerisieme oo moko raru pi uro peku goya, oi ŋonebuŋ. Oi ŋoneru oo iŋoke gogu kae ubueiŋ eko bokeru warebu. ");
INSERT INTO mlh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jonji buŋo miko kiŋariŋ yoyoka maneru Yesure ŋadio rabu, yokoreone more tina Andru, kakainere tina Saimon Pita. ");
INSERT INTO mlh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru iŋoji rone kakaine Saimon bofukeru iŋi ojime maneya, “Niko Munaŋqoqo Rauine bofukegobere.” Munaŋqoqo Rauine oi Grik buŋoo Kristo. ");
INSERT INTO mlh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Oŋu miku kakaine roru Yesureo rabu. Rabire Yesuji Saimon poretiŋ piku bibitatara eku miya, “Go Saimon, Jonde made fukegeyoŋ, nonji tinago Sifas mibe peiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kae fureme Yesuji Galili prowinsgo raiŋgo raru kadio ŋi tinaine Filip bofukeru iŋi ojiya, “Go noŋ boyobe nuru ware!” ");
INSERT INTO mlh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipji Andru eru Pita yokoke kaeyaŋuŋ moakoŋ. Taoŋyaŋuŋ tinaine Betsaida. ");
INSERT INTO mlh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipji ŋi tinaine Natanael bofukeru iŋi ojiya, “Mosesji ŋi more ore Kadi buŋoo quraŋgame kajeqouŋ yoŋoji jikigaru quraŋgabi pega, niŋo ŋi oi bofukegobeneŋ. Ŋi oi tinaine Yesu, mamainere tina Josef, kaeine tinaine Nazaret.” ");
INSERT INTO mlh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelji oi maneru waragaru miya, “O Nazaret! Oi kae qandaine. Oŋuineo ya fiine mo fukeiŋ ore so mata.” Oŋu miko Filipji ojiya, “Go wareru gake ŋone muku!” ");
INSERT INTO mlh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Oŋu ojime maneru Yesureo wareru wapeko ŋoneru iŋore buŋo iŋi miya, “Ŋoneniŋ! Ŋi yo iŋoji Israel ŋi foriine fukega. Maŋineo kiko ikoine tomiri.” ");
INSERT INTO mlh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Oŋu miko Natanaelji weu teru miya, “Go uruŋuneji noŋ mane muku nuge?” Oŋu miko Yesuji bokirieru ojiya, “Go fig yo mumuineo ŋende ŋone tari guboŋ. Rone ŋone tari gube Filipji ore ŋadiineo ŋone guru oŋga gareya.” ");
INSERT INTO mlh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Oŋu ojime Natanaelji bokirieru ojiya, “O Sogunene, go fofori Anuture Made fukege. Go Israel niŋore ŋi Ofoŋ goge.” ");
INSERT INTO mlh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Oŋu miko maneru Yesuji bokirieru ojiya, “Noŋ rone iŋi migo, ‘Go fig mumuineo ŋende ŋone guba.’ Oŋu mifukego ore manesiŋ nuge. Anuture usuŋ yo ŋoneru manege, oi ya mendaine fukega. Foriine yasogo oi jiki ŋoneru maneru gomiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Oŋu ojiru jikigaru ojiya, “Nonji buŋo foriine yobu mo iŋi mibe mane: Jiki nonde kiŋariŋpu fukebi qohoŋ yadube pororo iiru iŋi ŋonenimiŋ: Sombuŋ mendiji aŋgame Anuture mimerereŋpuji fukeru Sombuŋ eru morende Ŋi Foriineo rope waki ebi ŋone yabenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yesuji Filip eru Natanael oŋga yateme una yokaomo tariko gobi moji roro qoqoturere suanjeŋ jebe ruame tumaŋgabuŋ. Oi Galili prowinsre kae tinaine Kana oo ebuŋ. Yesure maŋgoji oo moko raru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu eru iŋore kiŋariŋpu yoŋo oŋuakoŋ furu yabebi jebego moko ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Oo ŋebi wain obuji mataeme Yesure maŋgoji madeine ojiya, “Yoŋore wain obu mataega.” ");
INSERT INTO mlh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Oŋu ojime iŋi ojiya, “Maŋgone, oi uruŋu ebemiŋ ore mige? Mitiga narege me? Nonde mosi qoqowirie bobo damanji so wareru fukeme gogo.” ");
INSERT INTO mlh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Oŋu miko maneru kiŋaŋqoqopuine iŋi yajiya, “Iŋoji ya more mitiga ŋareiŋ, oi bio boyoberu einebi.” ");
INSERT INTO mlh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Juda yoŋo munaŋqoqo ee eiŋ ore Kadi buŋoyaŋuŋ boyoberu meyaŋuŋ jureru goegobi. Ore so pi oo gbakeŋ yasogo 6 ŋeya. Gbakeŋ moakoŋ moakoŋ oi obu kiniŋ 8 me 12 oo rakaru pusenobuŋ ore so ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuji oi ŋoneru iŋi yajiya, “Ŋoŋo obu pioru wareru kesebi gbakeŋ yo puseiŋ.” Oŋu miko maneru miya ore so ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Gbakeŋ oi pusebi iŋi mitiga yareya, “Ŋoŋo obu paiine pioru roru raru jebe siŋaŋ oteniŋ.” Mitiga yareme roru rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pioru rabuŋyoŋ, siŋanji obu qowirieru wain fukeya, oi noku aŋiine maneru urone roru warebuŋ, oi so mane taniŋgaru popureya. Popurekoyoŋ, kiŋaŋqoqo obu piobuŋ, yoŋoji oi maneru mibi siŋanji suanjeŋ jebe rauine oŋga teme wareya. ");
INSERT INTO mlh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Wareme iŋi ojiya, “Suanjeŋ damaŋgo sosowo yoŋoji wain obu fiine oi rone roru wareru yareegobi oi noku bojiqojibu fukeru qoqo ebi wain obu aŋiine tomiri oi jiki yareegobi. Goji wain obu fiine oi rone sabareku so yareru muŋambe yo damaŋ odureru roru warege. Oi mosi furu mo ege.” ");
INSERT INTO mlh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuji mosi qoqowirie fuŋfuŋgaine yo oi Galili prowinsre kae tinaine Kana oo baya. Oi baku oo usuŋine totogo barariŋga yareya. Oŋu barariŋga yareko kiŋariŋpuineji manesiŋ gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jebego gobi tariko Yesure maŋgo gbopu eru kiŋariŋpu yoŋoji kaeyaŋuŋgo Kaperneam rabuŋ. Oo raru una goine jikigaru gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Damaŋ oo Juda niŋore ŋonemaiŋ kombaŋ damaŋine bombeŋgaya. Anutuji ronekoŋ ŋone noberu emboŋ eru nodureya, ore jeriekimiŋ ore ruabi Yesuji oŋuakoŋ kaeine bokeru Jerusalem sitio ropeya. ");
INSERT INTO mlh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sitio roperu boji sorinde jokoroŋ maŋgo roperu ya iŋi bofukeya: Ŋiŋigo bulmakao ŋiine, lama eru kabu webo oi furiine banimiŋ ore ruabuŋ eru goineji moneŋ nareŋgareŋ eiŋgo ore ŋebuŋ, oi ŋone yabeya. ");
INSERT INTO mlh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Oi ŋone yaberu niginji repa mijeri oiji yaberu yabeya. Yaberu ŋiŋigo oi sosowo qoyobe eyareru lama bulmakaoyaŋuŋke boji soriŋgone yobe yabeya. Nareŋgareŋ ŋiŋigo yoŋore siqojiŋo kepieko wakiko teboyaŋuŋ romaeŋgaru keseme raya. ");
INSERT INTO mlh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kabu furiyaŋuŋ banimiŋ ore ebuŋ, ŋiŋigo oi iŋi miyareya, “Ya oi roru useru sakibe raniŋ. Ŋoŋo nonde Mamare boji soriŋ yo wamore igokogabi bajiki pi oŋuine fukega?” ");
INSERT INTO mlh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Oŋu miyareme Biŋe buŋo mo kiŋariŋ yoŋore mamanego wapeme manesubuŋ. Buŋo oi iŋi quraŋgabi pega, “Nonde manji gore soriŋ oi mokiine eiŋ ore yameŋ kebe oo maŋneji nouŋaŋ yo oŋuine jako manebu oo jibe bofukeego.” ");
INSERT INTO mlh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Oi yobe yabeme Juda minebobo yoŋo kanegaru pakereru Yesureo waperu iŋi weu tebuŋ, “Go wamo mosi qoqowirie mo einde usuŋgo ŋonebeneŋ saga nobeko quraŋ oŋuine ena?” ");
INSERT INTO mlh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Oŋu weu tebi iŋi bokirie yareya, “Ŋoŋoji boji soriŋ yo ketotiebi moreŋgo wakiko nonji oi una yokaomo ore maŋgo romaeŋgaru babemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bokirie yareko iŋi ojibuŋ, “Gosa 46 ore maŋgo boji soriŋ yo baku goku baforebi dimaga eru goji oi una yokaomore maŋgo uruŋu eku romaeŋgaru bapakarena?” ");
INSERT INTO mlh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Oŋu ojibuŋyoŋ, Yesuji sorinde buŋo oi iŋoyoŋunde sakire soso miya. ");
INSERT INTO mlh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesuji jiki komegone pakereme soso buŋo miya, oi damaŋ oo kiŋariŋpuine yoŋore mamanesugo wapeko mane taniŋgabuŋ. Oi manesuku Yesuji buŋo miya, oi eru Biŋe buŋo quraŋgabuŋ, oi sosowo manesiŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesuji Jerusalem sitio ŋonemaiŋ kombande damaŋgo goku mosi qoqowirie usuŋineke eya, oi ŋiŋigo kokoineji ŋoneru tinaine manesiŋ garu iŋoreo fooregabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Fooregabuŋyoŋ, Yesuji ŋiŋigo sosowo yoŋore fuŋne mane muku foreya. Ore eru ŋiŋigo sosowo so manesiŋ yabe foreru buŋoyaŋunde yukuo so raru goya. ");
INSERT INTO mlh_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ŋiŋigo maŋyaŋuŋgo buŋo ya peya, Yesu moji ŋiŋigo maŋyaŋunde fuŋne oi barariŋgaru odu teiŋ ore so oŋu so fukeya. Iŋoyoŋe oi mane mukuya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Juda kufufunde soriŋ kaunsol botuyaŋuŋgo minebobo ŋi mo tinaine Nikodemus goya. Iŋoji Farisi (Kadi buŋore yameŋyameŋ) kubuo dimaya. ");
INSERT INTO mlh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Iŋoji ubu mogo Yesureo waperu iŋi ojiya, “Sogunene, go mosi qoqowirie eege, oi ŋi moji Anutu iŋoke so dimako iŋoyoŋe akoŋ eiŋgo embimbiŋgaega. Ore eru go Anutuji maŋgo egareko qaqaji fukege, oŋu manegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Oŋu miko iŋi miku bokirie teya, “Nonji buŋo foriine yobu mo iŋi mibe mane: Moji Anutureone fufuke gariine so fukeiŋ ine, iŋoji Anuture qorumaŋgo roperu ŋoneiŋ ore embimbiŋgaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Bokirie teko iŋi ojiya, “Moji ŋiŋigo qoruine fukeru gogu fufuke gariine oi uruŋu fukena? Iŋoji maŋgo beu maŋgo ropeme moke kuagaru roiŋgo embimbiŋgaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Oŋu ojime iŋi bokirieya, “Nonji buŋo foriine yobu mo iŋi mibe mane: Moji miti meso rau tebi Moro Tiriineji maŋineo rakame oo fufuke gariine so fukega ine, oŋuineji Anuture qorumaŋ maŋgo ropeiŋgo embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Morende maŋgomama yoŋoreone odumade fukegobi, yoŋo morende odumade. Moro Tiriineji dobegaru maŋgo eteko odumade fukeegobi, yoŋo Sombunde odumade. ");
INSERT INTO mlh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Ore eru ŋoŋo fufuke gariine Anutureone so fukenimiŋ, oi so sagaga. Buŋo oi mibe ore eru so popureniŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Gbinji iŋoyoŋere aŋigo kosa qame fonuŋine maneegeyoŋ, oi urone qaku wareega eru uroobe qaku raega, goji ore fuŋine so mane taniŋgage. Moro Tiriineji ŋiŋigo maŋgo eyareru fufuke gariine fukebuŋ, sosowo yoŋore fuŋne gbiŋ ore so fukega.” ");
INSERT INTO mlh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Oŋu bokirieme Nikodemusji qiŋgbuŋ qaku iŋi miya, “Oi uruŋu fukena?” ");
INSERT INTO mlh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Oŋu miko Yesuji ojiya, “Go Israel kufufuŋ qaji noreege eru jibu buŋo ore fuŋine so mane taniŋgage. Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nonji buŋo foriine yobu mo iŋi mibe mane: Niŋoji uruŋu mane mukugobeneŋ, oi miku barariŋga yareegobeneŋ eru uruŋu jiŋonoŋunji ŋoneru manegobeneŋ, oi kitiŋgaku miegobeneŋ. Oŋu egobeneŋyoŋ, ŋoŋoji jibu Biŋe buŋonoŋuŋ oi so maneru sabareegobi. ");
INSERT INTO mlh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","“Morende ya jiŋoji ŋoŋoneine ore buŋo mibe maneru so manesiŋ nugobi ine, nonji Sombunde ya so ŋoŋoneine ore fuŋine ŋajibe oi uruŋu manesiŋ ganobuŋ? ");
INSERT INTO mlh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Morende ŋi moji Sombuŋgo so ropeyayoŋ, Sombuŋ eru morende Ŋi foriineji Sombuŋ kaeo go wakiru fuke taniŋgaya, iŋoji kirieru Sombuŋgo ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Anutuji Moses moreŋ buroineo mitigako kopa aenji kobeŋ sasakoine baku tokuo qakasigako dimaya, ore so Sombuŋ eru morende Ŋi Foriine oi qakasigabi roperu dimaiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ŋiŋigo iŋo manesiŋ gagobi, yoŋoji sosowo gogo sanaŋine bofukeru gonimiŋ ore eru paibe ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Ore fuŋine oi iŋi: Ŋiŋigo oi manesiŋ gaegobi, yoŋoreone moji egu sibirigaiŋgo eru Anutuji moreŋ so jeŋgoma manjoko enoreya. Noŋuŋ sosowo qowirieru gogo sanaŋinere biŋe fukekimiŋ ore eru Madeine moakoŋ yobu oi noreya. ");
INSERT INTO mlh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ŋiŋigo moreŋ so go ragobeneŋ, Anutuji Madeine noŋunde buŋo mitariiŋgo ore matayoŋ, Madeineji munaŋ qa noreko kantri so qowirieru seŋgiŋbaŋgiŋ fukekimiŋ ore eru soreme moreŋgo wakiya. ");
INSERT INTO mlh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ŋiŋigo moji Madeine manesiŋ gaga, Anutuji iŋore buŋo mitarime so sibirigaiŋ, moji Yesu so manesiŋ gaga, Anutuji iŋore buŋo mitarime goga. Anuture Made moakonde tina so manesiŋ gaga ore eru misi korure biŋe fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Anutuji moreŋ ŋiŋigo buŋonoŋuŋ mitariega, ore fuŋine oi iŋi: Tatamaji moreŋgo wakiru fukeyayoŋ, ŋiŋigo eebobo sembene sembene eba eku gobuŋ. Oŋu goku Anuture tatamare taki yabeme maŋyaŋuŋ qisirire eeboboo kosa kiperu go wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","“Sosowo eebobo sembene eegobi, yoŋoji Anuture tatamare taki yabeme ŋadi gaegobi. Anutuji eeboboyaŋuŋ sembene sembene oi barariŋgaru miyareme mimiyaŋuŋ egu manenimiŋ ore kokoi maneegobi. Oi maneru tatamainere maŋgo so ropeegobi. ");
INSERT INTO mlh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","So ropeegobiyoŋ, moji buŋo foriine boyoberu goga, iŋoji soine tatamainere maŋgo ropeiŋ. Anutuji boburogame eeboboine eba eku goya, ore eeboboine oiji totogo fukeiŋ ore manega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesuji oŋu miforeru dimaku kiŋariŋpuine oga yaberu Jerusalem siti bokeru Judia prowinsre moreŋ ŋadio rabuŋ. Oo raru kiŋariŋpuine yoŋoke sonda goine jikigaru goku ŋiŋigo miti meso rau yareru goya. ");
INSERT INTO mlh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yesuji oŋu goyayoŋ, Jonji oŋuakoŋ moreŋ tinaine Salim ore bembeŋgo goya. Moreŋ tinaine Ainon oo obu kokoine peko eme ŋiŋigoji Jondeo waperu miti meso rau yareiŋgo weu tebi afagaru rau yareru goya. ");
INSERT INTO mlh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Damaŋ oo Jon iŋo witi pigo so ruabuŋ ŋeya. ");
INSERT INTO mlh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Juda yoŋoji munaŋ qaiŋgo ore meyaŋuŋ jureru gobuŋ. Ore eru Jonde kiŋariŋpu yoŋo Juda ŋi moke buŋo ore noigoi miku fuŋgaru migobobo ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Oŋu ebi yobiŋgame Jondeo wareru iŋi ojibuŋ, “Sogunenoŋuŋ mane, ŋi Jordan obu mobeineo goke goko gake fuŋine kitiŋgaku minde, iŋoji ŋiŋigo miti meso rau yareme kubu sogo sogo iŋoreo raegobi.” ");
INSERT INTO mlh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jonji oi maneru iŋi bokirieya, “Anutuji ŋi more ya mo Sombuŋgone so rua tena ine, iŋoji oi raugaiŋgo embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Iŋoke goku iŋi miboŋ, ‘Noŋ Munaŋqoqo Rauine Kristo so fukegoyoŋ, Anutuji sore nume rone warego iŋoji ŋadineo wareiŋ.’ Nonji buŋo oi miboŋ, ŋoŋo oi soine ŋoŋo-ŋaŋe kitiŋgaku miku gonimiŋ ore so fukegobi. ");
INSERT INTO mlh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ore soso eru iŋi mibemiŋ: Ŋi moji ŋigo biŋeineke fukeru ŋigo roiŋgo jeri buŋo misaueku goga. Oŋu gome ŋi ogoineji bembeŋgo dimaku jeri buŋore maru maneru iŋore jeŋgoma jerieega. Ore so nonji Yesure ogo fukeru iŋore jeriebe jeribari oiji muŋambe yo maŋne puseko gogo. ");
INSERT INTO mlh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yesure tinabiŋeji sogueru saueme Jon nonde qitiwako sagaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Moji paibeone wakiya, iŋoji ŋiŋigo sosowo yadureru ropekiine fukega. Moji moreŋgo fukeru morende biŋe fukega eru moreŋgo gogore buŋo miega. Sombuŋgone wakiru wareya, iŋoji sosowo yadureru ropekiine fukega. ");
INSERT INTO mlh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iŋoji ya ŋoneru mane mukuru goya, ore fuŋine miku kitiŋgaku munaŋ moge oŋuine dimaga. Oŋu dimagayoŋ, kikitiŋ buŋoine oi ŋiŋigo moji mo so maneru sabarega. ");
INSERT INTO mlh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","“Ŋiŋigo moji kikitiŋ buŋoine maneru sabarega, iŋoji Anutu foriine yobu fukega ore buŋoine basanaŋgame sanaŋ qaŋqaŋine fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anutuji kiŋaŋ ŋiine soreme Moro Tiriine suroŋ paio matayoŋ, boakoŋ yobu oteega. Ore eru kiŋaŋ ŋiineji Anuture buŋo foriine oi barariŋgaru miega. ");
INSERT INTO mlh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mamaineji Madeine manji jojoko eteega ore eru ya sosowo biŋe qa teru meineo ruame pega. ");
INSERT INTO mlh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Ŋiŋigo moji Madeine manesiŋ garu maŋine kerisiega, iŋoji moke qowirieru gogo sanaŋinere biŋe fukega. Moji Madeinere buŋo so reŋgaega, Anuture yombenji iŋore paio roperu damaŋ so dimako gogo sanaŋinere fuŋne oi so ŋone mukuru mo kosa goga.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesuji ŋiŋigo oŋu qaji yareme kiŋariŋpuine fukebi miti meso rau yareru oo Jon Mitimeso ŋi odureru gbiŋ eku goya, buŋo oi Farisi (Kadi buŋore yameŋyameŋ) yoŋore kajego rakame manebuŋ. Yoŋoji oi manebuŋ, biŋe oi mikabi saueru Ofonde kajego rakame maneya. ");
INSERT INTO mlh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesuji iŋoyoŋe ŋiŋigo so miti meso rau yareyayoŋ, iŋoji miko kiŋariŋpuineji oi ba yarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Oi maneru Judia prowins bokeru kirieru moke Galili prowins oobe rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kadi oŋu raru Samaria prowinsgo roperu odureru rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Odureru raru Samaria prowinsre taoŋ mo tinaine Sikar oo ropeya. Sikar taoŋ oi Jeikobji moreŋ mobeine mo madeine Josef oteya, ore bembeŋgo pega. ");
INSERT INTO mlh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jeikobre obu wikiŋ joroine oi Sikar taoŋgo pega. Yesuji kadi wareya ore eru sakiine yobiŋgame una yai fukeko obu wikiŋ oo roperu bembeŋgo wakiru ŋeya. ");
INSERT INTO mlh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Obu wikiŋ bembeŋgo ŋeko Samaria ŋigo moji obu pioiŋ ore wareya. Wareme Yesuji ŋoneru iŋi ojiya, “Go soine obu narende nonobo.” ");
INSERT INTO mlh_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Damaŋ oo kiŋariŋpuineji uqo furiine banimiŋ ore iŋo bokeru taoŋgo rabi yokoyoke akoŋ dimabu. ");
INSERT INTO mlh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Juda ŋiŋigoji Samaria prowins sure yaberu yoŋoke aŋibaŋi so gobuŋ eme pake moakoŋgo obu so pioru gobuŋ. Ore eru yokoyoke akoŋ dimabu oo ŋigo iŋoji iŋi ojiya, “Go Juda ŋi eme noŋ Samaria ŋigoyoŋ, uruŋu eru ‘Obu narende nonobo,’ miku weu narege?” ");
INSERT INTO mlh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesuji weweu oi maneru iŋi kerisie teya, “Go Anutu yauŋinere fuŋne mane mukunoŋ sagana. Moji ‘Obu narende nonobo,’ miku weu garega, iŋore fuŋne mane taniŋgaku ine, oi weu tende gogore obu garenoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Oŋu ojime iŋi ojiya, “O sogunene, obu pioinde pake mo so ŋega eru obu wikiŋ yoji joroine fukega. Ore eru gogore obure mige, oi urone bofukenoŋ? ");
INSERT INTO mlh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Apa ŋasonoŋuŋ Jeikobji obu wikiŋine yo noreya. Iŋoji rone iŋoyoŋe eru iŋore ŋadio madepuineji yoo wareru obu pioru noku gobuŋ eru bulmakao kubuine kubuine obu yarebi noku gobuŋ. Go Jeikob odureru ropekiine fukeru ŋiŋigo obu bofuke yareiŋgo mige me?” ");
INSERT INTO mlh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Oŋu miko maneru Yesuji iŋi bokirieya, “Ŋiŋigo sosowoji obu yo noru moke obu noiŋgo maneenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Oŋu gonimiŋyoŋ, nonji more obu otebemiŋ, iŋoji oi noru damaŋ mogo obure moke so maneiŋ. Oŋu matayoŋ, obu otenobo, oi iŋore maŋgo qowirieru gogore obu jiŋoine jijiine tomiri fukeko goiŋ. Igomuruŋgaru waperu gogo sanaŋine tatariine tomiri oi oteeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Oŋu bokirieme ŋigoji miya, “O sogunene, go obu oi narende nobemiŋ. Oi noru damaŋine damaŋine moke obure maneru obu pioiŋ ore yoo kadi jijiki so odenoboŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Oŋu miko iŋi mitiga teya, “Go raru ŋoego ogagaru yoo wareni.” ");
INSERT INTO mlh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Oŋu mitiga teya “Noŋ ŋoene tomiri,” miku bokirieya. Bokirieme iŋi ojiya, “Go ‘Ŋoene tomiri,’ buŋo oi foriine mige. ");
INSERT INTO mlh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Go rone ŋi 5 ro yaberu gokande eru muŋambe mo ronde ŋega, iŋoji gore ŋoe so fukega. Buŋo mige, oi fofori yobu.” ");
INSERT INTO mlh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ŋigoji oi maneru iŋi ojiya, “Sogunene, go kajeqouŋ ŋi fuŋine mo fukege. Nonji kamasigo oŋu ŋone muku gugo. ");
INSERT INTO mlh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Niŋore apa ŋasopuji tuku oduru yoo roperu dikanji keru oŋga wosigaru gobuŋyoŋ, Juda ŋoŋoji iŋi miegobi, ‘Samaria ŋoŋo Jerusalem sitio roperu boji soriŋgo daberu oŋga wosibi sagaiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Oi maneru Yesuji iŋi mitigaya, “O ŋigo, damaŋ mo wareru fukeiŋ, ŋoŋo damaŋ oo Mama ohoweine baku miteŋ ganimiŋ ore tuku yoo me Jerusalem oo so roperu gonimiŋ. Go buŋo oi manesiŋ gande sagaiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria ŋoŋo Anuture fuŋne poretiŋ so mane mukuru jibu iŋore ohowe kosa baku miteŋ gaegobi. Munaŋqoqore fuŋne oi Juda niŋore botugo toto fukeru pega. Ore eru Juda niŋoji Anutunoŋunde fuŋne mane mukugaru ohoweine baku miteŋ gabeneŋ sagaga. ");
INSERT INTO mlh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Jibu damaŋ mo iŋi fukeiŋ: Damaŋ oo Moro Tiriineji ŋiŋigo boburoru dobe yaberu buŋo foriine boyoberu Mama ohoweine baku fofori miteŋ garu gonimiŋ. Mamanoŋunji ŋiŋigo oŋuine baa yaberu bofukeniminde aŋi maneru goga. Damaŋ furuine oiji wareru fukeru muŋambe yoo pega. ");
INSERT INTO mlh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutuji Moro fukega. Ore eru Moro ore ohowe baku miteŋ gaegobi, yoŋoji Moro Tiriineji boburome dobe yabeko buŋo foriine boyoberu miteŋ garu gonimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yesuji oŋu mitigako ŋigoji ojiya, “Munaŋqoqo Rauine tinaine Kristo migobi, iŋoji fukeiŋ ore ega, oi manego. Iŋoji wareiŋ, damaŋ oo buŋo sosowo barariŋga noreko ŋoneru manekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesuji buŋo oi maneru fuŋine iŋi barariŋga teya, “Goke yoo dimaku buŋo mi manegobere, nonji iŋo fukego.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Fuŋine barariŋgako kiŋariŋ yoŋo oo akoŋ kirieru warebuŋ. Wareru ŋigoke buŋo mimane ebire, oi ŋoneru waragabuŋyoŋ, moji iŋi so weu teya, “Go uruŋure iŋoke buŋo buŋo egobire?” me “Go uruŋu egareiŋgo manege?” Oŋu weu teiŋgo manebuŋyoŋ, sosowoji fogaturuŋ eku ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oŋu ŋebi ŋigoji obu pakeine bokeru kirieru taoŋgo raru ŋiŋigo iŋi yajime manebuŋ, ");
INSERT INTO mlh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Maneniŋ! Nonji ŋi mo bofukebe ya sosowo eku goboŋ, ore fuŋine barariŋga nareru miko manego. Ore eru iŋoji Munaŋqoqo Rauine Kristo egu fukeiŋ. Bio ŋoŋo-ŋaŋe wareru ŋi oi ŋoneniŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Buŋo oi maneru taoŋ bokeru doduru poreru Yesureo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kiŋariŋ yoŋoji damaŋ botuineo oo Yesu igodoŋgaru iŋi ojibuŋ, “Sogunenoŋuŋ, uqo no.” ");
INSERT INTO mlh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Oŋu ojibuŋyoŋ, iŋi yajiya, “Nonji uqone fuŋine mo baru gogo, ŋoŋoji ore fuŋine so mane mukugobi. Mata.” ");
INSERT INTO mlh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Oŋu yajime yoŋoyoŋe weweu eku iŋi mibuŋ, “Moji uqo mo baru wareru otega me uruŋu?” ");
INSERT INTO mlh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Oŋu mibi iŋi yajiya, “Sore nume wareboŋ, nonji iŋore mi reŋgaru gioine basarigaego, oiji nonde uqo fukega. ");
INSERT INTO mlh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ŋoŋoji buŋo iŋi egu minimiŋ, ‘Kaiŋ 4 tariko qondoŋkoko damanji qondiŋgaiŋ.’ Maneniŋ, nonji ore iŋi migo, maneru kaje ruaniŋ: Gio gaŋine gaŋine yoŋore foriji oje foreko qaku rorore damanji wareru fukega. Ŋoŋo bio maŋyaŋunde jiŋoji kerisieme pibi rako oi ŋone mukuinebi. ");
INSERT INTO mlh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Goineji rone buŋo koruŋ qopogaru tieru gobi foriineji damaŋ yoo fukeko goineji oi roru qodureru furiyaŋuŋ babi ŋiŋigoine ŋiŋigoine gogo sanaŋinere biŋe fukeegobi. Oŋu fukeko foriine qaroro yoŋo qopoga-titiere ŋiŋigo yoŋoke tumaŋgaru moko jebe eku jerieru seŋgiŋbaŋgiŋineke manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‘Moji koruŋ qopogaru tieme moji foriine qaku roga,’ buŋo oŋu miegobi, oi buŋo foriine. Oi Anuture gio bobore fuŋne barariŋgaga. ");
INSERT INTO mlh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nonji ŋoŋo sore ŋabebe gio fuŋine mogo ŋoŋo-ŋaŋe ya koruŋ so saribuŋ, gio oo raru foriine qaku roniŋ. Goineji rone sakiyaŋuŋ qaku gio baku gobi ŋoŋoji yoŋore ŋadio raru gio babuŋ ore fori bofukeru qaku roenimiŋ. Nonji oŋu sore ŋabego.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria ŋigoji buŋo iŋi kitiŋgaku miya, “Nonji ŋi mo bofukebe ya sosowo eku goboŋ, iŋoji ore fuŋine barariŋga nareru miko manego.” Oŋu miya ore eru Samaria ŋiŋigo kokoine Sikar taoŋ oo maŋyaŋuŋ kerisieru Yesu manesiŋ gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Manesiŋ garu iŋoreo wareru yoŋoke jikigaru goiŋ ore yameŋ keku weu tebi una yoyokare so jikigaru oo goya. ");
INSERT INTO mlh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Oŋu goku buŋo miku goya ore eru kokoine Yesu manesiŋ garu jikigabi kubuyaŋuŋ sogueya. ");
INSERT INTO mlh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jikigaru ŋigo oi iŋi ojibuŋ, “Ŋi yoji fofori moreŋine moreŋine noŋunde Munaŋqoqo Rau fukega. Niŋoji oi gore buŋore akoŋ so jikigaru manesiŋ gagobeneŋyoŋ, oi niŋonoŋe kaje ruaru maneru mane mukugobeneŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesuji Samaria goko una yoyoka tariko boke yaberu Galili prowinsgo raya. ");
INSERT INTO mlh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu iŋoyoŋe damaŋ mogo buŋo mo iŋi kitiŋgaku miya, “Kajeqouŋ ŋiŋigo moji iŋoyoŋunde kae moreŋgo goko iŋore so manebi ropeko araŋ so ba teegobi.” ");
INSERT INTO mlh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Oŋu miyayoŋ, jibu damaŋ oo iŋoyoŋere prowinsgo Galili wapeme oo oŋuakoŋ goineji mijeri etebuŋ. Yoŋoji ŋonemaiŋ kombaŋ ore Jerusalem sitio roperu Yesuji kombaŋ damaŋgo mosi qoqowirie eya, oi sosowo ŋoneru manebuŋ. Ore eru damaŋ oo soine keporebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Galili prowins yoŋo keporebi kae tinaine Kana rone oo obu qowirieme wain fukeya, oo moke wareya. Taoŋ tinaine Kaperneam oo kiŋ koitore mamari siŋaŋ mo goya. Iŋore madeji jibe bame peya. ");
INSERT INTO mlh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Peru komeiŋgo eya. Ore eru Yesuji Judia prowins bokeru Galili maŋineo wareya, iŋoji ore biŋe maneru Yesureo raru iŋi weu teya, “Go soine wareru madene bobiaŋgaigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Weu teme iŋi ojiya, “Ŋoŋo noŋ mo so manesiŋ nunimiŋ ore oŋu so fukegobi, oi so sagaga. Nonji mosi qoqowirie soi ebe ŋoneku afagaru noŋ manesiŋ nuru maŋ-ŋaŋuŋ bokirienimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Oŋu ojiyayoŋ, mamari siŋanji iŋi ojiya, “Sogunene, madeneji egu komeiŋ ore go pipa ware.” ");
INSERT INTO mlh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Oŋu ojime bokirie teya, “Madegoji fiaru goiŋ. Ore eru soine kirieru ra.” Oŋu kerisie teme iŋoji oi manesiŋ garu kirieru raya. ");
INSERT INTO mlh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kadio rako kiŋaŋqoqopuineji wareru bofukeru iŋi ojibuŋ, “Madegoji fiaga.” ");
INSERT INTO mlh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Oŋu ojibi weu yareru miya, “Mo damaŋgo fuŋgaru fiaga?” Oŋu miku ojibuŋ, “Yanekoŋ iŋande wan kilok oo saki joine bokeya.” ");
INSERT INTO mlh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ojibi mamaneine iŋi fuke taniŋgaya: Aha! Yesuji “Madegoji fiaru goiŋ,” miya, aua oo akoŋ fiaga. Buŋo oi mane taniŋgaru iŋo eru garikiŋpuine sosowo yoŋo maŋyaŋuŋ kerisieru Yesu manesiŋ gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesuji Judia bokeru Galili prowins maŋgo wareru mosi qoqowirie mo yo eme ateine yoyoka fukeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jiki damaŋ mogo Juda yoŋore kombaŋ yasogo mo qondiŋgame Yesuji Jerusalem sitio ropeya. ");
INSERT INTO mlh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem sitire sago mendi mo oi lama ŋoŋore peya. Ore bembeŋgo joguŋ kora mo tinaine Hibru buŋoo Betesda mibuŋ, oi peya. Ore qaŋaŋineo gbiŋ pi joroine yasogo 5 dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Gbiŋ pi 5 ore maŋgo jibe ŋiŋigo kubu yasogo peegobuŋ. Goineji jiŋoyaŋuŋ kobeme ŋebuŋ. Goineji me kufuyaŋuŋ demba pebuŋ. Goineji mobeyaŋuŋ komekiine pebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Damaŋ goineo Ofonde mimerereŋ moji wakiru joguŋ korago odejaŋgako usuraŋgaeya. Obuji usuraŋgame damaŋ oo akoŋ moji rone joguŋ korago rakaeko jibe oi me oi oiji bio fiaku goya. Ore eru odigaru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Oo ŋi mo gosa 38:re so jibe bame peku goya. ");
INSERT INTO mlh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Oo peko Yesuji wape ŋoneru damaŋ joroine yobu jibe bame peku goya, oi maneru iŋi weu teya, “Go fiaiŋ ore manege me mata?” ");
INSERT INTO mlh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Weu teme iŋi bokirieya, “O Ofoŋ, obuji usuraŋgako fonuŋ eme ogone moji bio korago ro nuru rua nuna? Ogone oŋuine mo so goga. Nake raiŋgo maneru esoigaru goboŋ, damaŋ oo akoŋ goine yoŋoreone moji noŋ nadureru rakaegobi.” ");
INSERT INTO mlh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kerisie teko Yesuji ojiya, “Go bio pakereru ramegaripepego roru ra.” ");
INSERT INTO mlh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Oŋu ojime maneru oo akoŋ fiaru ramegaripepeine roru raya. Rayayoŋ, ya oi Sabat kombaŋgo fukeya. ");
INSERT INTO mlh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ore eru Juda yoŋo ŋi fiaya, oi iŋi ojibuŋ, “Muŋambe Sabat kombaŋ ega. Ore eru ramegaripepego roru koboru warende so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ojibi iŋi bokirieme manebuŋ, “Oroine banuga, iŋoji iŋi mitari narega, ‘Go bio pakereru ramegaripepego roru ra’.” ");
INSERT INTO mlh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Oi maneru iŋi weu tebuŋ, “Ŋi moji gore ‘Ramegaripepego roru ra,’ miga?” ");
INSERT INTO mlh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Weu tebiyoŋ, Yesuji roru bame orogako ŋiŋigo kubu sogoji kekefoŋ ebi yoŋore botugone kamieru raya. Ore eru moji oi eteya, oi so maneru koŋkoŋ qaku dimaya. ");
INSERT INTO mlh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ore ŋadiineo boji soriŋ jokoroŋ maŋgo ropeko Yesuji oo bofukeru uŋsowoŋ buŋo iŋi ojiya, “Mane, go fiage. Ore eru sisibiri soweineke sembene mo egu fuke gareiŋ ore eru agiburaŋ moke so jikigaru eku goigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ŋi fiaya, iŋoji Yesu ŋone mukuru raru Juda minebobo yoŋo iŋi yajiya, “Ŋi bobiaŋ nuya, iŋore tina Yesu.” ");
INSERT INTO mlh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Oi maneru Yesuji Sabat kombaŋgo gio oŋuine baya, Juda minebobo yoŋo ore eru kekesuesue eteku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Oŋu gobuŋyoŋ, Yesuji iŋi bokirie yareya, “Nonde Mamaji jijiki gio baega eru nonji oŋuakoŋ oi baego.” ");
INSERT INTO mlh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Oŋu bokirie yareru ŋiŋigo Sabat kombande buŋo goine jikigaru ebi Yesuji oi eeboboineo kepieru yoŋore jiŋoo agiburaŋ eya. Agiburaŋ oi jikigaru Anuture ‘Mamane!’ miku Anutu kamasi oŋuine goga ore so fukeru iŋoyoŋe bofeŋgaya. Juda ŋiŋigo yoŋo ya yoyoka ore eru maneru jajabaeru yameŋ keku Yesu qaiŋgo misanaŋgabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Oŋu ebuŋyoŋ, Yesuji buŋo iŋi yajiya, “Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Madeji iŋoyoŋunde mande eru ya mo so baegayoŋ, Mamaineji ya baega, Madeineji oi oŋuakoŋ baega. Ore eru Mamaineji ya bame ŋoneega, iŋoji oŋuakoŋ baega. ");
INSERT INTO mlh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mamaineji Madeine manji jojoko eteru goku iŋoyoŋe gio baega, oi sosowo odu teega. Ore eru mosi qoqowirie ŋoneru gobuŋ, oi ya wawakiine. Ore foriine oi jiki yaduko ŋoneru meayaŋuŋ tariko waragaru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","“Mo iŋi ore waraganimiŋ: Mamaji ŋiŋigo komekiine wiwi yabeme gboreegobi. Madeineji ore so oŋuakoŋ ŋiŋigo komekiine uri yoŋo gborenimiŋgo manega, yoŋo wiwi yabeme gboreegobi. ");
INSERT INTO mlh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Oŋuakoŋ Mamaji more buŋo so mitariegayoŋ, mimitari giore usuŋ sosowo oi iŋi ore Madeinere meo ruame pega: ");
INSERT INTO mlh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","“Ŋiŋigo Mama araŋ ba teegobi, ore so sosowoji Madeine araŋ ba tenimiŋgo manega. Mamaji Madeine soreya. Ore eru moji Madeine so araŋ ba tega, iŋoji Mama oŋuakoŋ araŋ so ba tega. ");
INSERT INTO mlh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ore eru nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Moji nonde Biŋe buŋo maneru noŋ sore nuya, oi manesiŋ gaga ine, iŋoji gogo sanaŋinere biŋe fukega. Nonji buŋoine mitaribe misi korure biŋe so fukeiŋ. Kome sanaŋinere mobe bokeru ruge kigaru gogo sanaŋinere mobe roperu go ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Damaŋ fuŋine mo wareiŋ, oi nonde eru ware forega. Damaŋ oo agiburaŋ baku manji komekiine fukegobi, yoŋoji Anuture Madeji oŋgako buŋo maruine manenimiŋ. Oi maneru reŋganimiŋ, yoŋoji gboreru sanaŋgaru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Oi iŋi ore: Mama iŋoyoŋe gogo sanaŋine kesosoega, ore so gogo gboreru sanaŋgainde usuŋ oi Madeine oteme iŋoji oŋuakoŋ ŋiŋigo bogbore yabeega. ");
INSERT INTO mlh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Iŋoji Sombuŋ eru morende Ŋi Foriine goga ore eru Mamaji ŋiŋigo buŋoyaŋuŋ mitariinde usuŋ oŋuakoŋ iŋore meo ruame iŋore biŋe fukeya. ");
INSERT INTO mlh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Nonji buŋo koruŋ migo, ore eru so popureniŋ. Damaŋ mo wareru fukeiŋ, oo sosowo jiŋoruŋgo pegobi, yoŋo oŋuakoŋ buŋo oŋgaiŋ, oi manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Buŋoine oi maneru pakereru totogo fukebi eebobo fiine eku gobuŋ, yoŋoji gogo sanaŋineo ropenimiŋyoŋ, eebobo sembene eku gobuŋ, nonji yoŋore buŋo mitaribe kome sanaŋinere biŋe fukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nonji nakene mande eru ya mo nake baiŋgo embimbiŋgaego. Noŋ Mamare migone buŋo maneego, ore so ŋiŋigo buŋoyaŋuŋ mitari yareego. Nakene mande eru kosa so baegoyoŋ, sore nuya, iŋore buŋo boyobeego. Ore eru mimitari buŋone miego, oi soineo akoŋ fukeega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nonji nakene fuŋne kitiŋgaku minobo ine, buŋone oiji soine so sanaŋgana. ");
INSERT INTO mlh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ogone moji nonde fuŋne kitiŋgaku miega. Iŋoji nonde buŋo miega, oiji sanaŋgaru foriineke fukega, oi manego. ");
INSERT INTO mlh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ŋoŋo minebobo sore yabebi Jondeo warebi buŋo foriinere so nonde fuŋne barariŋgaru mi kitiŋgaya. ");
INSERT INTO mlh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Mi kitingayayoŋ, nonji moreŋ ŋire kikitiŋ buŋo oi maneru so manebe ropega. So ropegayoŋ, Jonde kikitiŋ buŋore miego, oi ŋoŋo damaŋ yoo qowiriebi Anutuji qoruŋaŋuŋ kipeiŋgo ore eru miego. ");
INSERT INTO mlh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jonji doi soguine fukeru fiine akoŋ mitaniŋgayayoŋ, ŋoŋo damaŋ joroine matayoŋ, damaŋ pompoŋine iŋore tatamago kosa jerieniminde aŋi manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jonji nonde fuŋne pompoŋine ŋajiko manebuŋyoŋ, moji oi kitiŋgaku miega, iŋore buŋoji Jonde kikitiŋ buŋo odurega. Nakene Mamaji gioine nareme babe foriine fukeega. Foriine oiji fuŋne iŋi kitiŋgaku barariŋga yareega: Mamaji sore nume iŋore minebobo fukego. ");
INSERT INTO mlh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mamaji sore nume wakiboŋ, iŋoji fuŋne kitiŋgaku miku goya. Ŋoŋo damaŋ mogo iŋore buŋo maru so manebi eru kamasiine so ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Iŋoji mo soreme wakiya, ŋoŋo iŋo so manesiŋ gagobi. Ore eru iŋore buŋoji ŋoŋore maŋgo so pega. ");
INSERT INTO mlh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Ŋoŋo gogo sanaŋinere fuŋine oi Biŋe Quraŋgo pe ŋarega, oŋu manesuku oi osegaru maŋ wombuŋyaŋuŋgo ruaru Sombunde biŋe fukekimiŋ ore manegobi. Oŋu manegobiyoŋ, quraŋine quraŋine sosowo yoŋoji nonde fuŋne kitiŋgaku barariŋga ŋareegobi. Oi mane mukugobi me mata? ");
INSERT INTO mlh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kikitiŋ buŋo kokoine pegayoŋ, ŋoŋo gogo sanaŋine biŋe qaiŋgo ore nondeo wareiŋgo useegobi. ");
INSERT INTO mlh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Moreŋgo ŋiŋigo yoŋo tinabiŋe narebi sogueiŋ ore so odigago. Oi narebi manebe so ropeko gogo. ");
INSERT INTO mlh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Oŋu gogoyoŋ, ŋoŋore fuŋne oi iŋi pega, oi manego: Ŋoŋo maŋ-ŋaŋuŋ Anutureo mata yobu kiperu manji jojoko so eneku gogobi. ");
INSERT INTO mlh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nonji Mamanere tina oŋgaku warebe ŋoŋo ŋadi nuegobiyoŋ, moji iŋoyoŋunde tina oŋgaku wareiŋ, ŋoŋo oi soine maneru sabareru kepore tenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“O ŋoŋo-ŋaŋe mimiteŋ eru tinabiŋeŋaŋuŋ sogueiŋ ore manebi ropeega. Ropeegayoŋ, moreŋfuŋ moakonji Anutu foriine fukega, iŋoji tinabiŋe ŋareiŋ ore yameŋ so keegobi. Oŋu eru kuririŋaŋuŋke fukeiŋ ore so janjaŋbumbuŋ oderu dimagobi. Ore eru uruŋu noŋ manesiŋ nunobuŋ? Oi embimbiŋganobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Nonji ŋoŋo ‘Mamare jiŋo maio buŋo koroineo rua ŋabebemiŋ,’ oŋu egu manenimiŋ. Ŋoŋo Mosesre buŋore oori eku Sombuŋ kaeo ropenimiŋ ore odigaru gogobiyoŋ, Anuture jiŋo maio ropebi Moses iŋoyoŋe Anuture buŋo koroineo rua ŋaberu buŋo sakiŋaŋuŋgo ruame mimiŋaŋuŋ manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","“Oi iŋi ore: Mosesji nonde fuŋne mitaniŋgaru Biŋe Quraŋgo quraŋgame pega. Ore eru Moses manesiŋ ganobuŋ ine, bio noŋ manesiŋ nunobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Oŋuyoŋ, Mosesre quraŋ oi so manesiŋ garu reŋgagobi ore nonde buŋo oi uruŋu manesiŋ ganobuŋ? Oi quŋquŋgaineke egu fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ore ŋadiineo Yesuji Galili obu joguŋ, tinaine mo Taiberias obu joguŋ oi petigaru aribe ropeya. ");
INSERT INTO mlh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jibe ŋiŋigo bobiaŋ yabeko mosi qoqowirie fukeko ŋonebuŋ ore eru ŋiŋigo kubu sogo jiŋoraraji Yesure ŋadio boyoberu warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesuji kiŋariŋpuine oga yaberu tukuo roperu ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Damaŋ oo Juda niŋore ŋonemaiŋ kombanji qondiŋgaya. ");
INSERT INTO mlh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesuji jiŋo pime rako ŋiŋigo kubu sogo jiŋoraraji iŋoreo wapebuŋ, oi ŋone yaberu Filipre miya, “Niŋo uqo munjaŋ urone furiine babeneŋ kubu sogo oŋuine nogu gaba yabeme sagana?” ");
INSERT INTO mlh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ya eiŋgo eya, oi iŋoyoŋe maneyayoŋ, buŋo oi Filip eesoi eteku ojiya. ");
INSERT INTO mlh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Oŋu ojime iŋi bokirieya, “Uqo poroŋ giobobo 200:re furi (Kina4,000) oiji furiine baru boroiŋgabi sosowo yoŋoji mobeine akoŋ nokabi jibu so saga yabena.” ");
INSERT INTO mlh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Oŋu bokirieme kiŋariŋpuine yoŋoreone mo tinaine Andru, Saimon Pitare gboji iŋi ojiya, ");
INSERT INTO mlh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Made mendaine mo yo oo ŋega. Iŋoreo bali poroŋ 5 eru jembaeŋ yoyoka ŋegayoŋ, ŋiŋigo sauesaueine oŋuine oi so saga yabeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Oŋu ojime Yesuji yajiya, “Ŋoŋo ŋiŋigo kubu yo miku boroiŋ yabebi uqo nonimiŋ ore wakiru ŋenimiŋ.” Moreŋ oo kegbaŋ numa kokoine peya. Ore eru ŋi jareyaŋuŋ 5,000 ore so yoŋoji moreŋgo wakiru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Wakiru ŋebi Yesuji poroŋ oi roru daŋge miku oŋga wosiru ŋiŋigo ŋebuŋ, oi boroiŋgaru yareya eme jembaeŋ oi oŋuakoŋ boroiŋgaru aŋiyaŋunji mibuŋ ore so yareya. ");
INSERT INTO mlh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Boroiŋgaru yareme noku gaba yabeme Yesuji kiŋariŋpuine iŋi yajiya, “Uqo mobeine egu sibirigaiŋ ore oi roru qojuganiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Oŋu yajime bali poroŋ 5 oone noku mobeine bokebi ŋeya, oi roru qojugabi jambe 12 oo rakaru puseya. ");
INSERT INTO mlh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yesuji mosi qoqowirie oŋu bako ŋiŋigoji ŋoneru waragaru mibuŋ, “Kajeqouŋ ŋi moreŋgo fukeiŋ ore mibuŋ, iŋoji fofori oi fukega.” ");
INSERT INTO mlh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Oŋu miku Yesure kokoriaŋ keru kiŋ koitoyaŋuŋ fukeiŋ ore manesubuŋ. Manesuru wareru roregaru waragaru kiŋ koito igodoŋgaiŋ ore ebuŋ. Oŋu ebi mane mukuru ŋone yaberu takigame boke yaberu moke tukuo roperu iŋoyoŋe akoŋ goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nobi tariko kae ubu eme Yesure kiŋariŋpu yoŋo obu joguŋ qaŋaŋineo rakabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Rakaru ogâo roperu moreŋ oi bokeru obu joguŋ petigaru aribe Kaperneam kae oobe rabuŋ. Rabi ubu eko Yesuji jibu yoŋoreo so fukeya. ");
INSERT INTO mlh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Rabi gbiŋ sanaŋine qame obu jogunji koroŋineke kukugame roperu wakiya. ");
INSERT INTO mlh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Roperu wakiko qaqaji qaku kitiŋgaku 5 me 6 kilomita ore so rabi Yesuji obu joguŋ paio ode ode ogâ bembeŋgo wareko ŋoneru popureru kokoi manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Oŋu manebi iŋi yajiya, “Nake warego. Kokoi so maneniŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Oŋu yajime Yesuji ogâo ropeiŋ ore ojibi ropeya. Ropeko ogâyaŋunji oo akoŋ pipa oga yaberu moreŋ qaŋaŋineo raiŋgo ebuŋ, oo ropebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Oo ropebi kae fureme ŋiŋigo kubu sogo yoŋo obu joguŋ aribe jikigaru goku iŋi manesubuŋ, “Yanekoŋ ogâ moakonji ŋeko ŋonebeneŋ Yesuji kiŋariŋpuine yoŋoke ogâ oo so roperu rae. Yesu ruaru yoŋoyaŋekoŋ rabuŋ. Ogâ furuine mo so ŋonebuŋ. Ore eru Yesuji moke yo goga.” ");
INSERT INTO mlh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Oŋu manesuku goineji iŋi mibuŋ, “Ogâ moakoŋgo rabuŋyoŋ, fofori, Taiberias taoŋgone ogâ goine warebuŋ. Ogâ oi Ofonji poronde daŋge miku oŋga wosigako noku ŋebeŋ, moreŋ ore bembeŋgo warebi Yesuji ogâ yoŋoreone mogo roperu raya me uruŋu?” ");
INSERT INTO mlh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ŋiŋigo kubu yoŋoji oŋu miku Yesu eru kiŋariŋpuine oo so bofuke yabebuŋ. Oŋu ŋone maneru oŋuakoŋ ogâo roperu Kaperneam taoŋgo raru Yesu baabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ŋiŋigoji Yesu baaru obu joguŋ aribe ibe oobe bofukeru ŋoneru iŋi ojibi maneya, “O Sogunenoŋuŋ, go wamo damaŋgo yoo warege?” ");
INSERT INTO mlh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Oŋu ojibi iŋi bokirie yareya, “Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Ŋoŋo mosi qoqowirie babe ŋonebuŋ ore eru noŋ so baa nugobiyoŋ, uqo poroŋ mifiagabe noku gaba ŋabeya, ore noŋ boyobe nuru yo waregobi. ");
INSERT INTO mlh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Uqo mataeiŋ, oi bofukenimiŋ ore janjaŋbumbuŋ so oderu gonimiŋyoŋ, mande uqo gogo sanaŋ yareega, oi biŋe ganimiŋ ore yameŋ keku goinebi. Mama Anutuji mogeine Sombuŋ eru morende Ŋi Foriine oteme usuŋineji kefagame mande uqo yareme seŋgiŋbaŋgiŋ bofukenimiŋ. Oŋu eru goku sanaŋgaru komeru jikigaru tatariine tomiri gonimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Oŋu bokirie yareme iŋi weu tebuŋ, “Anuture maŋ aŋi boyoberu eebobo kamasiine uruŋu ebeneŋ sagana?” ");
INSERT INTO mlh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Weu tebi iŋi bokirieya, “Anutuji ŋi soreya, ŋoŋo iŋo manesiŋ gaku goinebi. Eebobo oiji Anuture maŋ aŋi boyoberu fukeega.” ");
INSERT INTO mlh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Oŋu bokirieme iŋi weu tebuŋ, “Oŋu fukeme go moke wamo mosi qoqowiriego usuŋineke mo bande ŋoneru manesiŋ gunobeŋ? Go wamo ya mo Mosesji baya, ore so baku bamiŋ me? ");
INSERT INTO mlh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Biŋe Quraŋ mo iŋi quraŋgabi pega, ‘Iŋoji Sombuŋgone uqo poroŋ yareme nobuŋ.’ Buŋo ore so noŋunde apa ŋaso yoŋoji moreŋ buroineo raru goku uqo tinaine ‘mana’ noku gobuŋ eru go fuŋnego Moses odureru uruŋu bataniŋganoŋ?” ");
INSERT INTO mlh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Weu tebi Yesuji iŋi yajiya, “Ŋoŋo ore fuŋine soine so mane mukugobi. Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Mosesji mosi qoqowirie Rauine so fukeya. Iŋoji uqo poroŋ oi Sombuŋgone so yareme nobuŋyoŋ, nakene Mamaneji Sombuŋgone poroŋ foriine yobu oi ŋareega. ");
INSERT INTO mlh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Anuture uqo poroŋ oi Sombuŋgone wakiru fukeru moreŋ so ŋiŋigo gogo sanaŋine ŋareega.” ");
INSERT INTO mlh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Oŋu yajime iŋi mibi maneya, “O Ofoŋ, go damaŋ so uqo poroŋ oi norende noku gokimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesuji oi maneru iŋi yajiya, “Nonji gogo sanaŋinere uqo fukego. Moji nondeo warega, iŋoji noku gaba gabeme uqore damaŋ mogo so komeiŋ. Moji noŋ manesiŋ nuega, iŋoji obure so maneiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Oŋu eme ŋoŋo noŋ ŋone taniŋ nugobiyoŋ, jibu so manesiŋ nugobi. Oi mibe manegobi. ");
INSERT INTO mlh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Eme jibu Mamaji ŋiŋigo goine nareega, yoŋoji sosowo nondeo warenimiŋ. Moji nondeo wareiŋ, nonji oi so yobebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Nonji Sombuŋgone wakiru nakene aŋigo ya kosa eba eku gobemiŋ ore so fukeboŋ. Oŋu mata. Sore nuya, iŋore maŋ aŋi boyoberu gio baku gobemiŋ ore wakiboŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","“Sore nuya, iŋore maŋ aŋi oi iŋi pega: Iŋoji ŋiŋigo nonde meo rua yabeme gogobi, nonji yoŋo sosowo maŋgo eyareku gobe yoŋoreone moji mo so jibugaru sibirigaiŋ. So sibirigabi nonji yoŋo damaŋ yasogoo wiwi yaberu bogbore yabebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","“Mamanere maŋ aŋiji iŋi pega: Goineji Madeine ŋoneru manesiŋ gagobi, yoŋoji sosowo damaŋ yoo qowirieru gogo sanaŋine biŋe gaku gonimiŋ. Oŋu goku komebi nonji yoŋo damaŋ yasogoo wiwi yaberu bogbore yabebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesuji oŋu yajiru buŋo koruŋ mo iŋi miya, “Nonji gogore uqo foriine fukeru Sombuŋgone wakiru fukeboŋ.” Oŋu miya ore eru Juda minebobo yoŋoji mane sembeaku maŋyaŋunji ŋunuŋ-ŋunuŋ miku mitebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Miku mitebuŋ, “Ŋi yo Yesu, Josefre made. Iŋore maŋgomama yoko soine mane yapegobeneŋyoŋ, uruŋu ‘Sombuŋgone wakiru fukeboŋ,’ miga?” ");
INSERT INTO mlh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Oŋu mibi maneru iŋi bokirieya, “Maŋ-ŋaŋunji so ŋunuŋ-ŋunuŋ miku minareniŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mama noŋ sore nuya, iŋoji ŋiŋigo so furu yabega ine, yoŋoreone moji nondeo wareiŋgo embimbiŋgaiŋ. Keforeme warena ine, nonji iŋo damaŋ yasogoo wiwi garu bogborebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Kajeqouŋ yoŋore Biŋe Quraŋgo buŋo mo iŋi quraŋgabi pega, ‘Anutuji oi sosowo qaji yareme manenimiŋ.’ Mamaji ŋiŋigo qaji yareme buŋo maneru maŋ wombuŋyaŋuŋgo ruaru gogobi, yoŋoji sosowo nondeo warenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ŋiŋigo moji Mama so ŋoneru goga. Mamareone wakiya, iŋo moakonji oi ŋoneru goga. ");
INSERT INTO mlh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Moji noŋ manesiŋ nuga, iŋoji gogo sanaŋine biŋe gaku go ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Nonji gogo sanaŋinere uqo foriine fukego. ");
INSERT INTO mlh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Maneniŋ! Ŋoŋore apa ŋasopuji moreŋ buroineo raru goku uqo tinaine mana noku gobuŋyoŋ, jibu komeru goregabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yoŋoji komebuŋyoŋ, uqo poroŋ damaŋ yoo Sombuŋgone wakiru goga, moji oi noku goku kome sanaŋine so komeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Uqo poroŋ gogoineke Sombuŋgone wakiya, oi nonji fukego. Moji uqo oi noku goiŋ, iŋoji tatariine tomiri sanaŋgaru goiŋ. Uqo oteru gobemiŋ, oi nonde fu. Moreŋine moreŋine yoŋo sanaŋgaru gonimiŋ ore oi rua yarebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesuji oŋu bokirieya Juda minebobo yoŋo botuyaŋuŋgo manjogo miku weweu eku mibuŋ, “Yei! Ŋi yo iŋoji uruŋu eru fuine noreko nonobeŋ?” ");
INSERT INTO mlh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Oi maneru mibi iŋi yajiya, “Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Ŋoŋo Sombuŋ eru morende Ŋi Foriinere dari eru fu so nonimiŋ ine, gogo sanaŋine oiji ŋoŋore maŋgo so peiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","55","Nonde dariji obu foriine fukega eru nonde fuji uqo foriine fukega. Ore eru moji nonde dari fu noega, iŋoji qowirieru gogo sanaŋinere biŋe fukeru go ropeiŋ. Oŋu goku komeme nonji iŋo damaŋ yasogoo wiwigaku bogborebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","“Moji nonde dari fune noega, iŋoji noke qakatoru dimaega eru nonji iŋoke dimaego. ");
INSERT INTO mlh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mamaji Gogo Rauine fukeru sore nume godune fukeru maŋgo enareko sanaŋgaru gogo. Oŋuakoŋ moji noŋ noku nareega, nonji oŋuakoŋ iŋore godu fukeru maŋgo etebe soine sanaŋgaru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Uqo foriine Sombuŋgone wakiya, oi nonji fukego. Ŋoŋore apa ŋasopuji Anuture uqo noku goku komebuŋyoŋ, damaŋ yoo ŋoŋoreone moji poroŋ yo noku goiŋ, iŋoji tatariine tomiri sanaŋgaru goiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuji Kaperneam taonde oŋgawowosi pigo dimaku buŋo oi miku qaji yareya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesure kiŋariŋpu yoŋoreone kokoineji buŋo oi maneru mibuŋ, “Buŋo miga, oiji buŋo koruŋ yobiŋineke fukega. Oi manebeneŋ maŋnoŋunji yobiŋgaru sembea forega. Ore eru oi moke maneiŋgo taki nobega ore oi bokekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kiŋariŋ yoŋo Yesure buŋore mane sembeaku maŋyaŋuŋgo ŋunuŋ-ŋunuŋ miku mitebi Yesuji oi maŋineji maneru iŋi miko manebuŋ, “Buŋo migo, oi mane sembeagobi me mata? ");
INSERT INTO mlh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Buŋo ore mane sembeagobi ine, jiki uruŋu fukena? Sombuŋ eru morende Ŋi foriineji rone moreŋ go wapeya, paibe moke kirieru ropeko ŋonenimiŋ ine, damaŋ oo uruŋu manenimiŋ? ");
INSERT INTO mlh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Moro Tiriine iŋoji ŋiŋigo bogbore yabeega. Ŋoŋo moreŋ ŋigoreone fukeru fuŋaŋuŋke fukegobiyoŋ, fufuke gariine so fukeru ŋoŋo-ŋaŋunde usuŋgo mo qowirieru Sombunde biŋe so fukegobi. Oi mata yobu. Moro Tiriineji gogo sanaŋine ŋarega, nonji buŋo koruŋ oi mitaniŋgabe maneru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Oŋu maneru gobuŋyoŋ, ŋoŋoreone goineji jibu noŋ so manesiŋ nuru gogobi.” Uri yoŋoji so manesiŋ gabuŋ eru moji jiki babae bateiŋ, Yesuji oi fuŋfuŋgaineone maneru wapeya. Ore eru buŋo oŋu miya. ");
INSERT INTO mlh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Oŋu miku jikigaru miya, “Ore eru nonji iŋi ŋajibe maneniŋ: Nonde Mamaji ŋiŋigo mo so dobe gaiŋ ine, iŋoji nondeo wareiŋ ore embimbiŋgaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Buŋo ore eru kiŋariŋ yoŋoreone kokoineji tataki eru ruruine fukeru bokeru iŋoke so jikigaru ra warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ore eru Yesuji kiŋariŋ 12 yoŋo iŋi yajiya, “Ŋoŋoji oŋuakoŋ boke nuru raiŋgo manegobi me mata?” ");
INSERT INTO mlh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Oŋu miko Saimon Pitaji bokirieya, “O Ofoŋ, niŋo moreo ranobeŋ? Gogo sanaŋinere Biŋe buŋo oi goreo pega. ");
INSERT INTO mlh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Goji Anuture ŋi gbagbataeŋine fukege, niŋo oi manesiŋ garu mane taniŋgaru gogobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Oŋu bokirieme Yesuji maneru yajiya, “Nonji ŋi 12 ŋoŋo roosoe ŋabebe eru ŋoŋoreone moji sembenere qoru fukega.” ");
INSERT INTO mlh_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Saimon Iskariotre made iŋoji kiŋariŋ 12 yoŋore botugo goku jiki babae bateya. Yesuji buŋo oi iŋore maneru yajiya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Juda minebobo yoŋoji Yesu qaiŋgo ore yameŋ kebuŋ ore Judia prowins maŋineo ra wareiŋgo takigaya. Ore eru Judia bokeru Galili prowins maŋineo raru roregaru goko kaiŋ goine tariya. ");
INSERT INTO mlh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Oi tariko Juda yoŋore kombaŋ mo tinaine reka-ako ore damanji qondiŋgaya. ");
INSERT INTO mlh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ore eru Yesure gbopuji iŋi ojibuŋ, “Go yo goku mosi qoqowirie eege, oi kiŋariŋpugoji oŋuakoŋ ŋone mukunimiŋ ore go bio moreŋ yo bokeru Judia rande sagaiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Moji iŋoyoŋe totogo fukeiŋ ore maneega, iŋoji ya mo soŋsoŋgo so baega. Mosi qoqowirie oŋuine eege ore go ŋiŋigo kubuine kubuine yoŋore jiŋoo raru fukeru fuŋnego barariŋga yareigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gbopuineji so manesiŋ gaku mo gobuŋ ore eru oŋu kosa ojibuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Oŋu ojibi iŋi yajiya, “Nonji mande gio totogo babeminde damanji so wareru fukeme gogoyoŋ, ŋoŋore damanji jijiki ranimiŋ ore so pega. ");
INSERT INTO mlh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Moreŋ ŋiŋigoji rosi eŋareiŋgo embimbiŋgaegobiyoŋ, nonji yoŋore eebobo sembene barariŋga ŋareru kitiŋgaku mibe manegobi ore noŋ rosi enareegobi. ");
INSERT INTO mlh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Rabeminde damanji so wareru fukega. Ore eru nonji jeri kombaŋ yoo so ropebemiŋ. Nonji pigo ŋebe ŋoŋoji soine raru roperu jerieinebi.” ");
INSERT INTO mlh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Buŋo oŋu yajiru Galili prowins maŋineo jikigaru goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesure gbopuji reka-ako kombaŋ ore rabuŋyoŋ, iŋoyoŋe pigo ŋeku jiki totogo matayoŋ, sumuŋgaru raru Jerusalem ropeya. ");
INSERT INTO mlh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juda yoŋore minebobopuji jeri damaŋgo Yesure jiŋo baaru weweu eku iŋi mibuŋ, “Ŋi oi uro ŋega?” ");
INSERT INTO mlh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ŋiŋigo kubu yoŋoji botuyaŋuŋgo Yesure saŋu buŋo kokoine mibuŋ. Goineji “Ŋi oi fiine yobu,” mibuŋyoŋ, goineji iŋi mibuŋ, “Mata! Iŋoji ŋiŋigo kubu sogo bojiqojibu eyareko witijibu fukeegobi.” ");
INSERT INTO mlh_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Oŋu oŋu kosa mibuŋyoŋ, Juda minebobo yoŋore kokoi maneru gobuŋ ore moji iŋore buŋo totogo so miya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kombaŋ jeri botuineo gobi Yesuji boji soriŋ jokoroŋ maŋgo roperu fuŋgaru ŋiŋigo qaji yareya. ");
INSERT INTO mlh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Qaji yareme Juda yoŋoji waragaru iŋi mibuŋ, “Ŋi yo mamane koro maŋgo so roperu jibu Biŋe Qurande fuŋne uruŋu mane sarigaga?” Oŋu miku waragabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Waragabi iŋi yajime manebuŋ, “Mamane Biŋe miego, nonji ore Rau so fukego. Nake matayoŋ, sore nuya, nonji iŋore mamane roru wareru miego. ");
INSERT INTO mlh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ŋiŋigo moji Anuture maŋ aŋi boyoberu eba eiŋgo manega, iŋoji mamane buŋo mibe ore Rau moji fukega, oi mane mukuiŋ. Anutuji Biŋeine nonde maŋgo ruame fukega me nakene mande eru buŋo kosa miego? ");
INSERT INTO mlh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Moji iŋoyoŋunde manji manesuku buŋo miega, iŋoji iŋoyoŋe tinabiŋeineke fukeiŋ ore manega. Oŋu manegayoŋ, sosore ŋi mo rauineji biŋeroroineke fukeiŋgo yameŋ kega, iŋoji minebobo foriine yobu kikoine tomiri fukega. ");
INSERT INTO mlh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesji Kadi buŋo rua yareya oi pega me mata? Oi pegayoŋ, ŋoŋoreone moji oi so reŋgaru boyobeega. Ŋoŋo wamore yameŋ keku noŋ nuiŋgo manesugobi?” ");
INSERT INTO mlh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Oŋu yajime maneru ŋiŋigo kubu yoŋoji iŋi bokiriebuŋ, “Gemokakuji gonde maŋgo rakaru dimaga. Moji yameŋ keku go guiŋgo manesuga?” ");
INSERT INTO mlh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Oŋu bokiriebi yajime manebuŋ, “Nonji mosi qoqowirie moakoŋ babe ŋoŋo sosowo popureru qiqu qagobi. ");
INSERT INTO mlh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesji sakiŋaŋuŋgo Anuture moge ketigaiŋ ore mitiga ŋareya, o Mosesji oi rone so mitigayayoŋ, apa ŋasopunoŋuŋ yoŋoji oi fuŋgaru baku gobi mosi oi niŋoreo wareme Sabat kombaŋgo oŋuakoŋ ŋi sakiyaŋuŋ ketigaegobi. ");
INSERT INTO mlh_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","“Noŋuŋ Mosesre Kadi buŋo kigabeneŋ agiburaŋ egu fukeiŋ ore sanaŋine manegobeneŋ. Oi manegobeneŋyoŋ, buŋo oi qougaru Sabat kombaŋgo oŋuakoŋ ŋi sakiyaŋuŋ ketigaru jibu ŋoŋo-ŋaŋe so miku naduŋgaduŋ eru keoma gogobi. Oŋu gogobiyoŋ, nonji ŋi jumuine Sabat kombaŋgo bobiaŋ gaboŋ, ore wamore noŋ kane nuru minaregobi? ");
INSERT INTO mlh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ŋoŋo ŋiŋigo sakiyaŋuŋ oŋuakoŋ ŋoneru oŋuine oo mobeine sowo osoeru buŋo kosa mitariegobi, oi bokeinebi. Oi bokeru maŋ-ŋaŋuŋ poretiŋ mane osoeru buŋo foriine akoŋ mitariinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem rauine yoŋoreone goineji iŋi mibuŋ, “Ŋi yameŋ keku qaiŋgo manesugobi, iŋoji oi me? ");
INSERT INTO mlh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ŋoneniŋ, iŋoji ŋiŋigo jiŋoyaŋuŋgo totogo buŋo miko so mitebi. Ore eru ŋi yo iŋoji Munaŋqoqo Rauine Kristo fukega, buŋo oi foriine siŋaŋyayabe ŋi yoŋore kajego rakame manegobi me mata? ");
INSERT INTO mlh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Munaŋqoqo Rauine Kristoji wareiŋ ore miku waperu gobuŋ, iŋoji ‘Urone fukeiŋ, oi moji mo so maneiŋ,’ migobiyoŋ, ŋi yoji urone fukeya, oi soine manegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Oŋu mimane ebi Yesuji boji sorinde jokoroŋ maŋgo dimaku maruine bofeŋgaru qaji yareru buŋo iŋi miya, “Ŋoŋo nonde iŋi migobi, ‘Ŋi oi maneru kaeine urone oi soine manegobeneŋ.’ Nakene usuŋ paio so fukeru dimago. Sore nuya, iŋoji sosore Rau foriine fukeme oi so mane mukuru gogobi. ");
INSERT INTO mlh_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Iŋoji sore nume iŋoreone wakiboŋ ore oi soine manego.” ");
INSERT INTO mlh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Oŋu miko oi roru nigiŋgaiŋgo manebuŋyoŋ, damaŋineji so wareru fukeya ore eru moji sakiineo so roya. ");
INSERT INTO mlh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Oŋu manebuŋyoŋ, ŋiŋigo kubu sogo yoŋoreone kokoineji manesiŋ gaku iŋi mibuŋ, “Kristoji wareiŋ, iŋoji ŋi yo odureru mosi qoqowirie eku goiŋ me uruŋu? Oŋu kamasi fukega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ŋiŋigo kubu yoŋo Yesure oŋu noigoi miku migobobo ebuŋ, oi Farisi (Kadi buŋore yameŋyameŋ) yoŋo manebuŋ. Oi maneru soriŋ gio siŋaŋ yoŋoke dimaku sa siŋaŋ (sikiriti) goine sore yabebi roru nigiŋgaiŋgo warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Warebi Yesuji iŋi miya, “Nonji ŋoŋoke damaŋ pompoŋine jikigaru gobemiŋ. Oi goku boke ŋaberu sore nume wakibe iŋoreo kirieru ropebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ropebe baa nuku gonimiŋyoŋ, noŋ so bofuke nonimiŋ. Nonji moreŋ gobemiŋ, ŋoŋo oo wareiŋgo embimbiŋganimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Oŋu miko Juda minebobo yoŋoji botuyaŋuŋgo iŋi mimane ebuŋ, “‘Niŋo bofukeiŋgo embimbiŋgakimiŋ,’ miga. Ore eru uro ropeiŋgo miga? Juda ŋiŋigo goine roiŋgaru kantri goineo raru Grik yoŋore botugo gobuŋ, yoŋoreo raru Grik ŋiŋigo qaji yareiŋgo maneru miga me? ");
INSERT INTO mlh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Buŋo iŋi miga, ‘Baa nuku gonimiŋyoŋ, noŋ so bofuke nunimiŋ,’ eru buŋo mo iŋi miga, ‘Nonji kae gobemiŋ, ŋoŋo oo wareiŋgo embimbiŋganimiŋ.’ Buŋo yoyoka yokore fuŋne uruŋu?” ");
INSERT INTO mlh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Oŋu mi manebuŋyoŋ, kombaŋ jeriebuŋ, ore una tatariine sogo oo wareru fukeme Yesuji dimaku sanaŋine yobu oŋgaku iŋi miya, “Moji obure manega, iŋoji nondeo wareru noine. ");
INSERT INTO mlh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Biŋe Quraŋgo buŋo mo iŋi quraŋgabi pega, ‘Moji noŋ manesiŋ nuga, iŋore maŋgone gogo sanaŋinere obuji tiŋaru buruburu wapeeiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Oŋu miyayoŋ, buŋo oi Moro Tiriinere soso baku iŋi miya, “Uri yoŋoji noŋ manesiŋ nugobi, yoŋoji Moro Tiriine biŋe baku gonimiŋ.” Anutuji Yesu moreŋgo goya ore so Sombunde kuririquraŋ so oteme goya. Ore eru Moro Tiriine so soreme wakiru maŋyaŋuŋgo rakame mo gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesuji oŋu miko ŋiŋigo kubu sogo yoŋoreone goineji buŋo oi maneru iŋi mibuŋ, “Ŋi yo iŋoji foriine kajeqouŋ ŋi fukeiŋ ore mibuŋ, oi fukega.” ");
INSERT INTO mlh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Goineji mibuŋ, “Iŋoji Munaŋqoqo Rauine Kristo fukega.” Oŋu mibuŋyoŋ, goineji kepieru mibuŋ, “Kristoji uruŋu Galili prowinsgone warena? Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Biŋe Quranji iŋi miga, ‘Kiŋ Deiwidji Judia prowinsre taoŋ mendaine Betlehem oo goya, Kristoji oone fukeru Deiwidre osigidapu yoŋoreone mo fukeiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Oŋu oŋu kosa mibi ŋiŋigo kubu yoŋoji Yesure eru pougaru roiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yoŋoreone goineji roru nigiŋgaiŋgo manebuŋyoŋ, moji sakiineo so roya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Boji sorinde sa siŋaŋ (sikiriti) yoŋoji kirieru soriŋ gio siŋaŋ eru Farisi (Kadi buŋore yameŋyameŋ) yoŋoreo warebi iŋi miyarebuŋ, “Ŋoŋo wamore iŋo so roru waregobi?” ");
INSERT INTO mlh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mi yarebi iŋi bokiriebuŋ, “Ŋi iŋoji buŋo miega, moji damaŋ mogo buŋo kamasiine oŋu so miya.” ");
INSERT INTO mlh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Oŋu bokiriebi Farisi (Kadi buŋore yameŋyameŋ) yoŋoji weu yarebuŋ, “Ŋoŋo oŋuakoŋ bojiqojibu baŋareko gogobi me? ");
INSERT INTO mlh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Siŋaŋyayabe ŋi niŋoreone moji iŋo so manesiŋ gaya. Eme Farisi (Kadi buŋore yameŋyameŋ) niŋoreone moji mo maŋine iŋore obe kerisieya me mata? ");
INSERT INTO mlh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Oŋu mata yobuyoŋ, ŋiŋigo kubu sogo Mosesre Kadi buŋo so mane mukuru Yesure buŋo maneru yaura buŋo kosa miegobi, yoŋore buŋo rerekaine oi bokekimiŋ! Anutuji yoŋo qaiso yabeme sibiriganimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Oŋu miyarebi ŋi tinaine Nikodemus rone Yesureo wareme uŋsowoŋ buŋo oteya, iŋoji oŋuakoŋ yoŋoreone mo fukeru botuyaŋuŋgo ŋeku iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ŋi moji agiburaŋ eya, oi so weubeneŋ miko maneru jibu osoebeneŋ sagaga me mata? So osoeru buŋoine omaine kosa mitarikimiŋ ine, noŋuŋ Kadi buŋonoŋuŋ qakimiŋ me? Oi so sagaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Oŋu miko maneru iŋi bokirie tebuŋ, “Goji oŋuakoŋ Yesu oŋuine kerisieru Galili qanda ŋi fukege me? Galili prowinsgone kajeqouŋ ŋi mo so fukeiŋ, oi manegobeneŋ. Oŋu oi gake Biŋe Quraŋ oseru fuŋine baaru mane mukuigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Oŋu migobobo eku pougaru roiŋgaru piyaŋuŋgo rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Piyaŋuŋgo rabuŋyoŋ, Yesuji raru Oliwe yo tukuo ropeya. ");
INSERT INTO mlh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Roperu peku kae fureme kaere akoŋ moke kirieru boji soriŋgo ropeme ŋiŋigo kubu sosowo wareru roregabi wakiru ŋeku qaji yareya. ");
INSERT INTO mlh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Qaji yareme Kadi buŋore qaqaji eru Farisi (Kadi buŋore yameŋyameŋ) yoŋoji ŋigo mo ogaru iŋoreo warebuŋ. Ŋigo iŋoji boesau bame ore roru kipebuŋ, oi ogaru kubu jiŋoyaŋuŋgo ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jiŋoyaŋuŋgo ruaru Yesure mibuŋ, “Qaqaji, ŋigo yo iŋoji jikiboti eba eme oo akoŋ bofukeru roru waregobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesre Kadi buŋoo ŋigo oŋuine oi koji bokeru qabeneŋ komeiŋ ore mitiga noreme pega. Oŋu pegayoŋ, goji iŋore uruŋu mimiŋ?” ");
INSERT INTO mlh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Oŋu miku oo gbedigaru Yesu buŋore buduŋgo furugabeneŋ embimbiŋgame fuŋine bofukeru buŋo korogo ruaru qaiŋgo ore mibuŋ. Oŋu mibi daberu wakiru meineji quraŋ mo moreŋgo quraŋgaya. ");
INSERT INTO mlh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Quraŋgayayoŋ, jikigaru yameŋ keku weu tebi qo kiraŋgaru pakereru poretiŋ dimaku iŋi yajime manebuŋ, “Ŋoŋoreone moji agiburaŋ mo so eku goga, iŋoji soine ko fuŋfuŋgaine roru bokeru qaine.” ");
INSERT INTO mlh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Oŋu yajime manebi moke daberu wakiru quraŋ moke moreŋgo quraŋgaya. ");
INSERT INTO mlh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yesuji buŋo miya, oiji ro yaberu kipe yabeme yoŋoyaŋunde agiburaŋ mimiineke ebuŋ, oi Anutuji yaduru yoŋoyaŋunde manji kitiŋgaku miko fonuŋyaŋuŋ mataeya. Oiji mataeme buŋo bokeku dimabi qoruyaŋunji rone boke yaberu rako iŋore muranji ŋadiineo rako goine moakoŋ moakoŋ yoŋoji mimigaŋgaŋ eku sosowo ra forebuŋ. Tatariineji rako Yesuji tinti quraŋgaru ŋeko ŋigoji iŋoyoŋe akoŋ iŋoke dimaya. ");
INSERT INTO mlh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesuji qokiraŋgaru pakereru poretiŋ dimaku ŋigo oi ŋoneru iŋi ojiya, “Ŋigo, go buŋo koroineo rua guiŋ ore migobi, yoŋoji urobe gake nake ragobi? Yoŋoreone moji dimaku go komeminde buŋo so mitariga me?” ");
INSERT INTO mlh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ojiko maneru bokirieya, “O Ofoŋ, moji so mitari narega.” Oŋu bokirieme ojiya, “Nonji oŋuakoŋ go so mitariru garego. Go muŋambe yo fuŋgaru agiburaŋ moke so baku goigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesuji buŋo moke jikigaru iŋi yajime manebuŋ, “Nonji ŋiŋigo moreŋine moreŋine ŋe ragobi, yoŋore tatama fukego. Moji noŋ boyobe nuru wareiŋ, iŋoji qisirigo tiŋtuŋ so qaku goiŋyoŋ, gogo sanaŋinere tatama ore maŋgo goiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Oŋu yajime Farisi (Kadi buŋore yameŋyameŋ) yoŋoji iŋi ojibuŋ, “Gake akoŋ fuŋnego kitiŋgaku mitaniŋgaege, oŋuine oi so sagaga. Mata.” ");
INSERT INTO mlh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Oŋu ojibi iŋi yajiya, “Nonji urone wakiru wareboŋ eru uro raru ropebemiŋ, oi mane forego. Ore eru nakene fuŋne kitiŋgaku mitaniŋgaego, buŋo oi soine sagaga. Oi sagagayoŋ, ŋoŋo nonde fuŋne oi fofori so mane mukugobi. ");
INSERT INTO mlh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ŋoŋoji ŋiŋigo sakiyaŋuŋ oi akoŋ ŋoneru oŋuine oiji mobeine sowo osoe yaberu buŋoyaŋuŋ kosa mitarigobiyoŋ, nonji ŋiŋigo more buŋo so mitariego. ");
INSERT INTO mlh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","“Noŋ nakekoŋ so gogoyoŋ, Mama sore nume wareboŋ, iŋoji noke dimaku gogobere. Ore eru more buŋo mitarinobo ine, oi poretiŋ akoŋ osoeru soineo mitarinobo. ");
INSERT INTO mlh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yoyokaji buŋo mo maŋmoakoŋ eku kitiŋgaku mibire sanaŋgaega. Buŋo oi ŋoŋore Kadi buŋoo oŋuakoŋ quraŋgabi pega. ");
INSERT INTO mlh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","“Nonji nakene fuŋne kitiŋgaku miego eru Mama sore nuya, iŋoji oŋuakoŋ nonde fuŋne kitiŋgaku miega. Ore eru yoyoka fukegobere oo soine sanaŋgaru saga forega.” ");
INSERT INTO mlh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yesuji oŋu miko maneru iŋi weu tebuŋ, “Gore Mama uro goga?” Weu tebi bokirieya, “Ŋoŋo noŋ eru Mamane nikore fuŋne so maneru gogobi. Ŋoŋo nonde fuŋne mane mukunimiŋ ine, nonde Mama oŋuakoŋ mane mukunimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuji boji sorinde pesiŋ ŋeŋe bembeŋgo dimaku ŋiŋigo qaji yareru buŋo oi miya. Oi miyayoŋ, damaŋineji so wareru fukeya ore eru moji oi so roru kipeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesuji buŋo mo iŋi jikigaru yajiya, “Nonji boke ŋaberu raru gobe ŋoŋo noŋ baa nuru gonimiŋ eru agiburaŋ ebuŋ, oo qakatoru dimaku kome sanaŋine komenimiŋ. Ore eru uro ropebemiŋ, ŋoŋo oo ropeiŋgo embimbiŋganimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Juda minebobo yoŋo oi maneru mibuŋ, “Iŋi miga, ‘Uro ropebemiŋ, ŋoŋo oo ropeiŋgo embimbiŋganimiŋ.’ Buŋo oi uruŋu? Ube qoqo ebemiŋgo miga me?” ");
INSERT INTO mlh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Oŋu mibi yajiya, “Ŋoŋo moreŋ yoore rau fukeru gogobiyoŋ, nonji kae moreŋ paibere biŋe fukego. Ŋoŋoji moreŋgo fukeru moreŋ yoore biŋe fukeru gogobiyoŋ, nonji ronekoŋ moreŋ yoo so fukeboŋ. ");
INSERT INTO mlh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","So fukeru gogore fuŋne damaŋ so go wapeboŋ, nonji oi fukego. Nonde oŋu so manesiŋ gagobi ine, agiburaŋ ebuŋ, oi so bokeru oo qakatoru dimaku kome sanaŋine komenimiŋ. Fuŋine ore eru iŋi ŋajibe manegobi, ‘Ŋoŋo agiburaŋ ebuŋ, oo qakatoru dimaku kome sanaŋine komenimiŋ.’ Buŋo oi fofori.” ");
INSERT INTO mlh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Buŋo oi maneru iŋi weu tebuŋ, “Go mo fukege?” Weu tekabi bokirieya, “Fuŋnene barariŋga ŋarebe mane foregobi, nonji oi fukego. ");
INSERT INTO mlh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nonji ŋoŋore buŋo kokoine soine jikigaru minobo eru agiburaŋ kokoine ebuŋ, ore buŋo soine mitarinoboyoŋ, sore nuya, iŋoji nonde sosore Rau foriine fukega. Iŋoji buŋo miko iŋoreone maneru waperu gogo, nonji buŋo oi totogo mibe moreŋine moreŋine yoŋoji maneenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Oŋu bokirieya, Mamare buŋo jikigaru miya, yoŋoji oi so mane taniŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesuji jikigaru iŋi yajiya, “Nonji gogore fuŋne damaŋ so go wapeboŋ, oi fukego. Ore fuŋine oi jiki soine mane taniŋganimiŋ. Nonji ya mo nakene usuŋgo me nakene mande eru so baegoyoŋ, Mamaneji buŋo qaji nareku goya, ore so buŋo mine yo miego. Buŋo koruŋ yoyoka ore fuŋine oi jiki mane mukunimiŋ. Ŋoŋo Sombuŋ eru morende Ŋi Foriine qakasigabi paibe roperu komeiŋ, damaŋ oo oi soine mane taniŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","“Sore nuya, iŋoji noke moko gogobere. Eebobo mo saga teega, nonji jijiki oi eego. Ore iŋoji so boke nuko nakekoŋ so gogo.” ");
INSERT INTO mlh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Buŋo oŋu miya ore eru ŋiŋigo kokoineji maŋyaŋuŋ kerisieru Yesu manesiŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuji Juda ŋiŋigo goineji manesiŋ gabuŋ, yoŋore buŋo iŋi yajiya, “Nonde Biŋe buŋoji maŋ-ŋaŋuŋgo rakame oo qakatoru mosiine qaku dimagobi ine, fofori nonde kiŋariŋpu fukegobi. ");
INSERT INTO mlh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Oŋu goku buŋo foriinere fuŋne mane mukubi Biŋe buŋo foriineji ŋoŋo sembeneŋaŋunde nigiŋgone pirue ŋareme posiine (fri) fukeru gonimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Oŋu miko maneru bokirieru iŋi mibuŋ, “Niŋo Abrahamde osigidapu goku kufufuŋ raŋgbaŋine fukegobeneŋ. Ore eru ŋi moji nigiŋ kipe nobeme gogobeneŋ ore mige, oi mata. Niŋo damaŋ mogo wakiqoqoine oŋuine so fukeru gobeŋ. Eme go uruŋu eru iŋi mige, ‘Nigiŋgone pirue yareme posiine fukeru gonimiŋ’? Buŋo oi so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Oŋu mibi iŋi bokirie yareya, “Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Agiburaŋ bagobi, sosowo yoŋoji agiburande kiŋaŋqoqo omaine furiŋaŋuŋ tomiri gobi ore niginji kariŋ ŋabeega. ");
INSERT INTO mlh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kariŋ ŋabeegayoŋ, kiŋaŋqoqoji rauinere pi maŋgo damaŋ so so go ropeiŋ. Iŋoyoŋunde Madeji soine piineo damaŋ tatariine tomiri goiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","“Madeineji sembenere nigiŋgone pirue yareme posikenimiŋ ine, yoŋoji fofori nigiŋ kipeine tomiri posiine (fri) fukeru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ŋoŋo Abrahamde osigidapu gobuŋ, manegoyoŋ, sembeneji maŋ-ŋaŋuŋ kejigaga ore nonde Biŋe buŋoji qofosi ŋaberu peperu wakiega. Fuŋine ore yameŋ keku noŋ nuiŋgo manegobi. ");
INSERT INTO mlh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nonji Mamanere keririŋgo goku ya ŋoneru go wapeboŋ, ore buŋoine miego. Ŋoŋoji oŋuakoŋ mamaŋaŋunji buŋo yajiya, ore so eegobi.” ");
INSERT INTO mlh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yesuji oŋu bokirie yareme iŋi mibi maneya, “Abrahamji noŋunde apa ŋaso fukega.” Oŋu mibi maneru miya, “Ŋoŋo Abrahamde osigidapu fukenimiŋ ine, iŋore eebobo yobebi sagana. ");
INSERT INTO mlh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ore kamasi iŋi fukega: Nonji Anuture migone buŋo maneru ore so buŋo foriine yobu oi mibe maneegobi. Damaŋ yoo ŋoŋo yameŋ keku ŋi noŋ nuiŋgo manegobiyoŋ, Abrahamji ore so oŋu so eya. ");
INSERT INTO mlh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ŋoŋo-ŋaŋunde mamapu yoŋore eebobo oŋuakoŋ boyoberu gogobi.” Oŋu miko ojibuŋ, “Boesau kadio fukeru mamanoŋuŋ tomiri (begu made) so fukegobeneŋyoŋ, Mamanoŋuŋke gogobeneŋ. Anutu iŋoyoŋe moakonji mama enorega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesuji iŋi yajiya, “Anutuji iŋoyoŋe mama eŋarena ine, nonji iŋoreone wakiru fukeboŋ ore soine noŋ manji jojoko enarenimiŋ. Nakene usunji maŋgo eŋareiŋ so fukeboŋyoŋ, Anutuji sore nume wakiru gogo. ");
INSERT INTO mlh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Buŋo miego, oi wamore mane taniŋgakimiŋ ore yobiŋgaegobi? Nonde buŋoji maŋ-ŋaŋuŋ sike igoroiŋ ore eru oi mane mukuiŋgo useru taki ŋabeega. Ore eru oi mane taniŋgaiŋ ore embimbiŋgaegobi? ");
INSERT INTO mlh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Ŋoŋo mamaŋaŋuŋ Sembene Rauinere biŋe fukegobi. Aŋiŋaŋuŋ sanaŋineji mamaŋaŋunde aŋi sembene yobenimiŋ ore pega. Iŋoji fuŋfuŋgaineone ŋiŋigo yayabe ŋi fukeru go waperu goga. Buŋo foriineji maŋineo so pega ore eru buŋo foriine odureru jijibu dimaga. Iko mimi ŋi fukeru iko mimire qoru fukega ore iko miega, oi iŋoyoŋunde mande eru miega. ");
INSERT INTO mlh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Iŋoji iko miegayoŋ, nonji buŋo foriine miego, ŋoŋo ore noŋ so manesiŋ nuegobi. ");
INSERT INTO mlh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ŋoŋo sosowoji nonde fuŋne iŋi bataniŋgaiŋgo embimbiŋgaegobi: Iŋoji agiburaŋ eku buŋoineke goga. Fuŋne oi baagobiyoŋ, nonji buŋo foriine miego, oi wamore so manesiŋ nugobi? ");
INSERT INTO mlh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","“Moji Anuture biŋe fukega, iŋoji Anuture buŋo kaje ruaru maneega. Ŋoŋo Anuture biŋe so fukegobi ore eru buŋo oi so mane taniŋgaegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yesuji Juda ŋiŋigo yoŋore fuŋne barariŋga yareko mobeine kerisieru iŋi ojibuŋ, “Go Samaria prowinsre jijibu ŋi fukende gemoji maŋgoo rakame goge. Oŋu mibeneŋ sagaga me iko egobeneŋ, oi soine gake minde manekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Oŋu ojibi iŋi bokirieya, “Gemoji maŋneo so rakame gogo. Noŋ Mamane akoŋ araŋ ba teku gobe ŋoŋoji jibu noŋ mimi bofuke nareegobi. ");
INSERT INTO mlh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Oŋu eegobiyoŋ, nake tinabiŋeneke fukeiŋgo ore janjaŋbumbuŋ so odeego. Moakonji oŋu fukeiŋ ore jigo qaku goga. Ŋi iŋoji moakoŋ osoe nuru ‘Go sagage,’ miku mitari nareega. ");
INSERT INTO mlh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Moji nonde Biŋe buŋo reŋgaru boyobeega, iŋoji damaŋ mogo kome sanaŋinere biŋe so fukeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Oŋu bokirieme Juda minebobo yoŋoji Yesu iŋi mibi maneya, “Abraham eru kajeqouŋ ŋiŋigo yoŋoji komebuŋ eru goji jibu iŋi minde jijibu fukega, ‘Moji nonde Biŋe buŋone reŋgaru boyobeega, iŋoji damaŋ mogo kome sanaŋinere biŋe so fukeiŋ.’ Oŋu mige ore go gemo moji maŋgoo rakame goge. Oi muŋambe yo soine mane taniŋgagobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Niŋore ŋaso Abraham komeya, goji iŋo odureru iŋore sogune fukege me? Kajeqouŋ yoŋoji oŋuakoŋ komebuŋ. Go gakere manende ropeko ‘Soguine moji fukego?’ miku manege?” ");
INSERT INTO mlh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Oŋu mibi maneru iŋi bokirieya, “Nakenere manebe ropeko Anuture kuriri oi nake rauganobo ine, tinabiŋene oi yau oŋuine fukena. Mamaneji iŋoyoŋunde kuririine nareya ore eru tinabiŋeneke fukeru gogo. Ŋoŋoji iŋore ‘Niŋore ŋaso Anutu fukega,’ migobi. ");
INSERT INTO mlh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ŋoŋoji fuŋine oi soine so mane mukuegobiyoŋ, nonji oi soine manego. ‘Oi so manego,’ minobo ine, ŋoŋo oŋuine eadu ŋi fukenobo. Noŋ ŋi oŋuine so fukegoyoŋ, oi soine manego eru iŋore buŋo reŋgaego. ");
INSERT INTO mlh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ŋoŋore ŋaso Abrahamji noŋ moreŋgo wakiru gobemiŋ ore odigaru damaŋ oi ŋoneiŋgo maŋ jeri maneru goya. Damaŋ yoo Sombuŋgo goku sanaŋgaya nonji fukebe nonde damaŋ oi ŋoneru ore jerieya.” ");
INSERT INTO mlh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Oŋu bokirieme Juda minebobo yoŋoji iŋi mibi maneya, “Gosago 50 so odureru ore rurumaŋgo goge eru ‘Abraham ŋoneboŋ,’ minde so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Oi maneru yajiya, “Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Abrahamji so fukeko nonji damaŋ oo goboŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oŋu miko maneru koji bokeru qaiŋgo ore ko amegaru robuŋyoŋ, Yesuji sumuŋgaru boji sorinde dobu bokeru kamieru raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesuji jikigaru kadi raru ŋi mo maŋgoinere beu maŋgone jiŋokombi fukeya, iŋo ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iŋo ŋoneme kiŋariŋpuineji weu teru mibuŋ, “Sogunenoŋuŋ, iŋoji more agiburande eru eru jiŋokombi oŋu fukeya? Iŋoyoŋunde agiburande eru me maŋgomamaine yokore agiburande eru?” ");
INSERT INTO mlh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mibi iŋi bokirieya, “Iŋoyoŋe agiburaŋ mo so eko maŋgo mamaineji agiburaŋ so ebuyoŋ, Anuture usunji iŋore gogoo totogo fukeiŋ ore oŋu fukeya. ");
INSERT INTO mlh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wegi fureru pega ore so sore nuya, iŋore gio gbeŋ akoŋ baku gokimiŋ. Kae ubu eiŋ, oo sosowo gio bakimiŋ ore embimbiŋgakimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nonji moreŋgo gobemiŋ ore so moreŋine moreŋine ŋoŋore tatama fukeru tamaeru gobemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Oŋu miku moreŋgo tifagame rakame afe kerisieru ŋi jiŋokombire jiŋoo rau teya. ");
INSERT INTO mlh_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Rau teru iŋi mitigaya, “Go Siloam obu joguŋineo raru jiŋogo jureigoŋ.” (Siloam tina oi noŋunde buŋoo Sosore ŋi.) Oŋu mitigako raru jiŋoine jureko tiŋame pime taniŋgako kirieru piineo wareya. ");
INSERT INTO mlh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Oŋu wareme ogopuine bembeŋgo gobuŋ eru goineji rone uqo yare karie yareru gome ŋonebuŋ, yoŋoji oi ŋoneru mibuŋ, “Jiŋokombi ŋi uqore karieru ŋeku goya, ŋi iŋoji me?” ");
INSERT INTO mlh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Goineji mibuŋ, “Ŋi oi iŋo.” Goineji mibuŋ, “Mata, kamasiine iŋo oŋuine fukegayoŋ, iŋoji mata.” Oŋu akoŋ oŋu mibi iŋoyoŋe miya, “Nonji oi fukego.” ");
INSERT INTO mlh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Oŋu miko iŋi weubuŋ, “Jiŋogo uruŋu eru pige?” ");
INSERT INTO mlh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Weubi iŋi kerisieru yajiya, “Ŋi tinaine Yesu oŋgaegobi, iŋoji tifagame moreŋ boboroŋgo rakame kerisieru jiŋoneo rau teru mitigaku iŋi miya, ‘Go Siloam obu joguŋgo raru jiŋogo jureigoŋ.’ Oŋu miko obu oo raru jiŋone jurebe tiŋame pibe taniŋgaya.” ");
INSERT INTO mlh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Oŋu bokirie yareme iŋi weubuŋ, “Ŋi oi uro goga?” Weu tebi “So manego,” miya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ŋi jiŋokombi goya, iŋoji “So manego,” miko ŋiŋigoji iŋo ogagaru Farisi (Kadi buŋore yameŋyameŋ) yoŋoreo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuji tifaine moreŋ boboroŋ kerisieru jiŋoineo rau teru botigaya, oi Sabat kombaŋ damaŋgo eya. ");
INSERT INTO mlh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ore eru Farisi yoŋo oŋuakoŋ iŋi weu tebuŋ, “Jiŋogo uruŋu eme pige?” Weu tebi iŋi bokirie yareya, “Ŋi oiji tifaineji moreŋ boboroŋ kerisieru jiŋoneo rau teme raru jiŋo maine jureru jiŋone pibe taniŋgaga.” ");
INSERT INTO mlh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Oŋu bokirie yareme Farisi yoŋoreone goineji mibuŋ, “Ŋi oiji Sabat kombaŋ qomukuga, ore eru iŋo Anuture ŋi so fukega.” Goineji mibuŋ, “Oŋu mata! Ŋi kekesiine moji uruŋu eru mosi qoqowirie oŋuine eiŋgo sanaŋgana?” Oŋu oŋu miku yoŋoyoŋe pougaru roiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Oŋu roiŋgaru ŋi jiŋokombi iŋoreo moke kirieru wareru mibuŋ, “Jiŋogo botigaya, iŋore uruŋu mimiŋ?” Oŋu mibi “Kajeqouŋ ŋi fukega,” miya. ");
INSERT INTO mlh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Oŋu miko jiŋoine fofori kobeme tiŋame ŋoneya, Juda minebobo yoŋoji oi so manesiŋ gabuŋ. So manesiŋ garu maŋyoka dimaku maŋgomamaine furu yapebi warebu. ");
INSERT INTO mlh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Warebire iŋi weu yatebuŋ, “Ŋi yo ŋokore made me mata? ‘Jiŋokombi fukeya,’ migobireyoŋ, uruŋu eru muŋambe yo jiŋoine piku ŋonega?” ");
INSERT INTO mlh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Weu yatebi iŋi bokiriebire, “Ŋi yo nikore made fukega eru jiŋokombi fukeya, oi soine manegobere. ");
INSERT INTO mlh_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Oi manegobereyoŋ, uruŋu eru muŋambe yo jiŋoine piku ŋonega, oi so manegobere. Moji jiŋoine botigame ŋonega, niko oŋuakoŋ so manegobere. Koko mata, sogueru iŋoyoŋe goku mamane-mukuineke fukega. Ore eru iŋoyoŋune weu tebi fuŋneine soine miiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Juda minebobo yoŋore kokoi maneru oŋu yajibu. Yoŋoji botuyaŋuŋgo buŋo iŋi kiperu maŋmoakoŋ eru dimabuŋ, “Moji ‘Yesu Munaŋqoqo Rauine Kristo fukega,’ oŋu miku fukeiŋ ine, iŋo oŋgawowosi pi kubu sogoone yobekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Buŋo ore eru iŋi yajibu, “Koko mata, iŋo maŋkajeineke. Ore eru iŋoyoŋene weu teniŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ore eru ŋi jiŋokombi goya, oi moke keforebi wareme iŋi mibi maneya, “Ŋi oi agiburaŋ ŋi fukega, oi manegobeneŋ. Ore eru Anuture tinabiŋe miteŋ gande kuririineke fukeko sagaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Oi maneru iŋi bokirieya, “Agiburaŋ ŋi fukega me mata, nonji oi so manego. Moakoŋ iŋi oi manego: Nonji jiŋokombi goboŋyoŋ, muŋambe yoo soine piku ŋonego.” ");
INSERT INTO mlh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Oŋu bokirieme iŋi weu tebuŋ, “Wamo ya egarega? Jiŋogo uruŋu botigae?” ");
INSERT INTO mlh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Weu tebi iŋi bokirie yareya, “Nonji bokirie yaregoyoŋ, ŋoŋoji buŋo migo, oi so manegobi. Wamore oi fori hosi moke mibe maneiŋgo yameŋ kegobi? Ŋoŋo oŋuakoŋ iŋore kiŋariŋpu fukekimiŋ ore manegobi me mata?” ");
INSERT INTO mlh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Oŋu bokirie yareme igosisi eteru maŋqoqo buŋo fofoine iŋi mitebuŋ, “Go iŋore kiŋariŋ fukegeyoŋ, niŋo Mosesre kiŋariŋpu gogobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anutuji Moses Biŋe buŋo oteya manegobeneŋyoŋ, ŋi oiji oone me oone fukeya, oi so manegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Oŋu mibi buŋo iŋi yajiya, “Iŋoji urone fukeya, ŋoŋo ore oŋuakoŋ koŋkoŋ eru qiqu qagobi ore maneru waragago. Fofori waragagoyoŋ, jibu nonde jiŋo botigame soine piku ŋonego. ");
INSERT INTO mlh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ŋiŋigo kekesiine yoŋoji Anutu oŋga wosigabi so mane yareega, oi manegobeneŋ. Oi manegobeneŋyoŋ, moji Anutu araŋ ba teku maŋ aŋiine boyobeega, iŋore oŋgawowosi kaje ruaru maneega. ");
INSERT INTO mlh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mo jiŋokombi fukeko moji wareru jiŋoine botigaya, sundu oŋuine oi ronekoŋ so maneru gobeŋ. Sombuŋ morenji fukebu, damaŋ oone fuŋgaru waperu muŋambe gogobeneŋ, oo sundu oŋuine mo so manebeŋ. ");
INSERT INTO mlh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Anutureone so warena ine, iŋoji ya oŋuine eiŋgo embimbiŋgana.” ");
INSERT INTO mlh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oŋu miko maneru iŋi mitebuŋ, “Maŋgomamagoji agiburaŋke gokabire go agiburaŋ sosowo oke fukeru soguende eru goji muŋambe niŋo qaji noreiŋgo manege. Oi so sagaga.” Oŋu miteku yobebi sakibe wakiya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yobebi sakibe wakiya, buŋo oiji Yesure kajeo rakame maneru ŋi oi bofukeru iŋi ojiya, “Go Anutu Madeine manesiŋ gage me mata?” ");
INSERT INTO mlh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Oŋu ojime iŋi bokirieru weuya, “O Sogunene, ŋi oi moji? Oi minde maneru oi soine manesiŋ gabemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Bokirieme iŋi mitiga teya, “Go yoo piku ŋone nu. Goke buŋo migo, ŋi oi nonji ego.” ");
INSERT INTO mlh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Oi maneru miya, “O Ofoŋ, noŋ manesiŋ gugo.” Oŋu miku daberu oŋga wosi teya. ");
INSERT INTO mlh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuji miya, “Nonji ŋiŋigo osoeru buŋoyaŋuŋ mitaribemiŋ ore eru wakiru moreŋgo fukeboŋ. Nonde eru goineji jiŋokombi fukegobi, yoŋore jiŋo tiŋame soine piku ŋone mukunimiŋ. Goine jiŋoyaŋuŋ fiine gobuŋ, yoŋoji nonde eru jiŋokombi fukeru gonimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Oŋu miko Farisi goineji bembeŋgo oo dimaku buŋo oi maneru iŋi weubuŋ, “Wae! Niŋo oŋuakoŋ jiŋokombi ŋi fukegobeneŋ me? Niŋore mige me?” ");
INSERT INTO mlh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Oŋu weubi iŋi yajiya, “Ŋoŋo ‘Jiŋokombi fukegobeneŋ,’ minimiŋ ine, agiburaŋ so pe ŋarenayoŋ, damaŋ yoo ‘Soine ŋone mukugobeneŋ,’ oŋu miegobi ore eru agiburaŋ-ŋaŋunji pe rope ŋareiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuji siŋaŋ bobo buŋo iŋi miya, “Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Goineji lama jokoroŋ maŋineo ropeiŋ ore mendigo matayoŋ, sa kigaru rakagobi, yoŋoji suroŋqoqo eru kiaŋ bobo ŋiŋigo fukegobi. ");
INSERT INTO mlh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Moji mendigo ropega, iŋoji lama yoŋore siŋaŋ fukega. ");
INSERT INTO mlh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Iŋoji wapeme mendi siŋaŋineji oi ŋoneru mendi ro teko wakiru oŋgame lama yoŋoji buŋo maruine soine mane mukuegobi. Siŋaŋyaŋunji iŋoyoŋunde lamapu oga yaberu tinayaŋuŋ oŋgaku oga yabeme jokoroŋyaŋuŋ bokeru soine sakibe raegobi. ");
INSERT INTO mlh_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","“Iŋoyoŋunde lamapu sosowo oga yabeme jokoroŋyaŋuŋ bokeru sakibe rabi iŋoji mineboboyaŋuŋ fukeru rone rako buŋo maruine mane mukugobi ore ŋadiineo boyoberu raegobi. ");
INSERT INTO mlh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yoŋoyaŋunde siŋaŋ soine boyobeegobiyoŋ, kotu moji wareru oŋgako oi so yobu boyobenimiŋ. Kotu yoŋore buŋo maru so mane mukugobi ore bio ruruine eru iŋore kokoi useru roiŋganimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuji buŋo sumuŋine oi yajiyayoŋ, buŋo ore fuŋine so mane taniŋgaru qiqu qabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Qiqu qabi jikigaru yoŋore iŋi miya, “Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Nonji lama jokoronde mendi fukego. ");
INSERT INTO mlh_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nonde ŋadio kubu siŋaŋ sosowo rone warebuŋ, yoŋoji suroŋqoqo eru kiaŋ bobo ŋiŋigo fukebuŋ. Oŋu fukebuŋ ore lama yoŋoji oi so mane muku yaberu gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Nonji moakoŋ lama jokoronde mendi fukego. Uri yoŋoji Anutuke sanaŋgaru gokimiŋ ore miku noke qakatoru gobuŋ, nonji munaŋ qa yarebe qowirienimiŋ. Oŋu fukeru lama jokoroŋ maŋgo rope wakiru sakibe raru uqo kaeine moririineke bofukeenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kiaŋ bobo yoŋoji wamore wareegobi? Yoŋoji kiaŋ roku noberu sibiri nobeiŋgo ore wareegobi. Ya furuine baiŋ ore mata. Nonji oŋuine so fukego. Nonji ŋoŋo gogo sanaŋine bofukeru seŋgiŋbaŋgiŋ gonimiŋ ore eru wareru gogo. ");
INSERT INTO mlh_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nonji lama siŋaŋ fiine fukego. Lama siŋaŋ fiineji lamapuine yoŋore eru gogoine kisiŋga yareiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Moji lama rauine so fukeru furiine banimiŋ ore akoŋ wareru jibu siŋaŋ yabeega, iŋo iŋi: Qoro rigaŋineji wareko ŋoneru lama boke yaberu totieru rako gomeŋ qoro rigaŋineji lama qomijie yaberu ki yabe boroiŋ yabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iŋoji sakibeone wareru furi rorore akoŋ ‘Lama siŋaŋ yabebemiŋ,’ oi miineji miku lama yoŋore manemeja so eru keta paio jibu goku kamieru raiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Nonji lama siŋaŋ fiine fukego. Mamaneji noŋ mane nuko nonji Mamane maneru gogo. Ore so nonji nakene lamapu mane yabebe yoŋoji noŋ mane nuegobi. Nonji gogone lamapune ŋoŋore ruaru kisiŋgaru bokebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nonde lama kubu goine oi oŋuakoŋ fukeru gonimiŋ. Yoŋoji lama jokoroŋ yoore rau so gogobiyoŋ, jibu nonde buŋo maru maneenimiŋ. Nonji yoŋo oŋuakoŋ oga yabebe ore so raru wareenimiŋ. Jiki kubuine kubuine yoŋoji qodureru kubu sogo moakoŋ fukebi siŋaŋ moakonji siŋaŋ yabeme gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Mamaji iŋi ore eru noŋ manji jojoko enareega: Nonji gogone bokeru moke gboreru go ropebemiŋ. Oi Mamare jiŋoo sagaga. ");
INSERT INTO mlh_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gogone moji so oga nuiŋyoŋ, oi nake kisiŋgaru bokebemiŋ. Mamaneji mitiga nareme nake gogone kisiŋgaru bokebemiŋ eru ore ŋadiineo moke gboreru go ropebemiŋ. Usuŋ oŋuine oi nondeo pega.” ");
INSERT INTO mlh_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesuji buŋo oi miya ore eru Juda minebobo yoŋore botugo noigoi moke fukeya. ");
INSERT INTO mlh_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yoŋoreone kokoineji iŋi mibuŋ, “Gemoji maŋineo rakame goku witijibu ega. Niŋo wamore buŋoine manenobeŋ? Bio bokeinebeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Goineji mibi, “Buŋo oŋuine oi bapeboriŋ ŋire buŋo oŋuine mata. Gemoji jiŋokombi ŋiŋigo yoŋore jiŋo uruŋu botigana?” Oŋu mimane ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ronekoŋ boji soriŋ keririkeru mendiine robuŋ. Oi gosa so manesuku kombande jeriekimiŋ ore Jerusalem tumaŋgabuŋ. Damaŋ oo ware fukeme kueyoiko damaŋ munaŋinere maŋgo gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesuji boji sorinde jokoroŋ maŋgo kiŋ Solomonde kae jiŋo saraŋineke mibuŋ, oo raru roregaya. ");
INSERT INTO mlh_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Raru roregaru Juda minebobo yoŋoji wareru roregaru iŋi weu tebuŋ, “Fuŋnego kemagande damaŋ wojimu jikigaru odigakimiŋ ore manege? Go Munaŋqoqo Rauine fukege me mata, oi totogo minde manekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Oŋu miku weu tebi Yesuji iŋi bokirie yareya, “Noŋ mibe manebuŋyoŋ, ŋoŋo nonde buŋo oi so manesiŋ gagobi. Nonji Mamanere tinao mosi qoqowirie eego, oiji fuŋnene barariŋgaru kitiŋgaku ŋaduega. ");
INSERT INTO mlh_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Oi kitiŋgaku ŋaduegayoŋ, ŋoŋo nonde lama kubu maŋineo so gogobi ore eru buŋone so manesiŋ gaegobi. ");
INSERT INTO mlh_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","“Nonji lamapune mane yabebe yoŋoji oŋuakoŋ nonde buŋo maru maneru noŋ boyobe nuegobi. ");
INSERT INTO mlh_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nonji gogo sanaŋine yarebe qowirieru damaŋ mogo so yobu sibiriganimiŋ. Moji mo oi nonde meone so poreru ketotie yabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nonde Mamaji yoŋo nonde meo rua yabeya, iŋoji sosowo yadureru ropekiine fukega. Ore eru sosowoji yoŋo nonde Mamare meone poreru ketotie yabenimiŋ ore embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Noŋ eru Mama nikoji moakoŋ fukeru gogobere.” ");
INSERT INTO mlh_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesuji oŋu miko Juda minebobo yoŋo moke moreŋgone ko amegaru oiji bokeru qaiŋgo ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Oŋu ebuŋyoŋ, iŋi miyareya, “Mamaji maŋgo enareko mosi qoqowirie yasogo kokoine eba ebe ŋonebuŋ, yoŋoreone wamo ya more manesuku noŋ koji bokeru nuiŋgo manegobi?” ");
INSERT INTO mlh_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mi yareko Juda yoŋoji kerisieru mibuŋ, “Niŋoji mosi qoqowirie soguine emeŋ ore eru so koji bokeru guiŋgo egobeneŋyoŋ, Anutu igosisi etege ore geo egarekimiŋ. Go moreŋ ŋi eru sakigo mo ba ropeku Anutu oŋuine fukeiŋ ore mige.” ");
INSERT INTO mlh_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Oŋu mibi Yesuji bokirie yareya, “Biŋe Quraŋgo Kadi buŋo mo iŋi quraŋgame pega, ‘Anutu nonji mibe: Ŋoŋo nonde apa ŋasopu fukegobi.’ ");
INSERT INTO mlh_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Biŋe Qurande buŋo oi so jaŋgaru mataeiŋyoŋ, sanaŋ qaŋqaŋine peiŋ. Ore eru Anutuji buŋoine ruame wareru ŋiŋigo biŋeyaŋuŋ fukeya, Anutuji yoŋore tina ‘apa ŋasopune’ oŋu miyareya. ");
INSERT INTO mlh_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ŋiŋigo omaine oŋu miyareyayoŋ, Mamaji ŋi bagbagbagaru soreme moreŋgo wakiya, ŋoŋoji uruŋu eku iŋore iŋi migobi, ‘Go Anutu igosisi eteku goge.’ Nonji ‘Anuture made fukego,’ buŋo oŋu mibe ŋoŋoji wamore oi manebi so sagaga? Ŋoŋo Anuture Biŋe buŋo oi qagobi me? ");
INSERT INTO mlh_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Gio baego, oi ŋonebi Mamanere eebobore so, so fukeega ine, ŋoŋo so manesiŋ nuniŋ. ");
INSERT INTO mlh_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mamanere eebobore so eba eku gogo ine, fuŋnene oŋuine ŋoneru manesiŋ nuinebi. Oi buŋonere eru so manesiŋ ganobuŋ ine, mosi qoqowirienere eru jibu manesiŋ nuinebi. Mamaji noke qakatoru dimaga eru nonji Mamake qakatoru dimago, ŋoŋo ore fuŋine mane muku sariganimiŋ ore yo migo.” ");
INSERT INTO mlh_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesuji oŋu miko moke roru nigiŋgaiŋgo manebuŋyoŋ, me yukuyaŋuŋgo qopogaru wakiru raya. ");
INSERT INTO mlh_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Boke yaberu Jordan obu fusiine petigaru moke aribe raru Jonji rone miti meso rau yareru goya, oo roperu damaŋ goine jikigaru oo goya. ");
INSERT INTO mlh_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Oo goko ŋiŋigo kokoineji iŋoreo wareru ŋoneru iŋi mibuŋ, “Jonji mosi qoqowirie moakoŋ mo so eyayoŋ, buŋo sosowo ŋi yo ore miya, oi buŋo foriine miku goya.” ");
INSERT INTO mlh_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Warebuŋ, yoŋoreone kokoineji maŋyaŋuŋ kerisieru manesiŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betani taoŋgone ŋi mo tinaine Lazarus iŋoji jibe bame peya. Maria eru Marta kakagbo yokoji Betani taoŋ oo gobu. ");
INSERT INTO mlh_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria iŋoji Ofoŋ obu koufiinekeji rauteru qoru sikiineji kufuine bokereŋgaya. Lazarus jibe bame peya, oi iŋore seŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazarusji jibe bame peko seŋyokaineji biŋe buŋo iŋi ruabire Yesureo raya, “Ofoŋ mane, yoro ogogoji jibe bame pega.” ");
INSERT INTO mlh_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Biŋe oi rayayoŋ, Yesuji oi maneru iŋi miya, “Jibe oiji ŋi ogone komeiŋ ore eru so fuke teya pega. Ore eru matayoŋ, Anutu Madeineji oi bobiaŋgako ŋiŋigoji fuŋine oi ŋone mukuru Anutu miteŋ gabi tinabiŋeineji taniŋgaru saueme Sombunde kuririke fukeiŋ. Jibe oi ore eru fuke teya.” ");
INSERT INTO mlh_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuji Marta, iŋore gbo eru seŋyakuŋ Lazarus yoŋore maŋine peme goya. ");
INSERT INTO mlh_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Oŋu goyayoŋ, jibu jibeinere biŋe maneru moreŋ goya, oo akoŋ una yoyoka jikigaru goya. ");
INSERT INTO mlh_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Oi gome damaŋ oi tariko kiŋariŋpuine yoŋore iŋi yajiya, “Noŋuŋ Judia prowinsgo kirieru rakimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Oŋu miko bokiriebuŋ, “Sogunenoŋuŋ, Juda yoŋoji yunekoŋ yameŋ keku koji bokeru guiŋgo ebuŋ. Ore eru moke Judia kirieru raiŋ ore mige, oi so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Oŋu bokiriebi Yesuji buŋo iŋi miya, “Unare aua 12 pegobi, moji ore tatamaineo kadi raiŋ, oi ya moji qaku qasibiri so eteiŋ. Morende tatamaji tamae neko soine ŋoneru raiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Soine raiŋyoŋ, moji doiine so pe teko kae ubu eko roigo-wareigo warepipu raiŋ, iŋoji raru qaku qasibiri eiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Buŋo oi miku iŋi yajiya, “Ogonoŋuŋ Lazarusji kubaŋ pegayoŋ, nonji raru kubaŋgone wiwigabe pakereiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Buŋo oi maneru iŋi mibi maneya, “Ofoŋ, fofori kubaŋ pega ine, soine peku fiaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesuji Lazarus komeya ore buŋo keroriine miyayoŋ, kiŋariŋ yoŋoji “Kubaŋ pega,” miya, ore eru mane bibieru buŋo fuŋine so mane mukubuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","So mane mukubi ore Yesuji totogo mifukeku miya, “Lazarusji komeru pega. ");
INSERT INTO mlh_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nonji iŋoke so gokabe komeya ore eru nonji raru bogborebe pakereko ŋonebi mamanesiŋ-ŋaŋunji sanaŋgaiŋ. Oŋu fukeme ŋoŋore jerieru seŋgiŋbaŋgiŋineke maneru migo. Ŋoŋo pakerebi iŋoreo rainebeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Oŋu mifukeme Tomas tinaine mo Gbogbodo mibuŋ, iŋoji kiŋariŋ ogopuine yoŋo iŋi yajiya, “Noŋuŋ soine moko oo rainebeneŋ. Raru iŋoke komekimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lazarusji komeru una 4 jiŋoruŋgo peme tariko Yesuji wapeko biŋeine oŋu mibi maneya. ");
INSERT INTO mlh_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani taoŋ oi Jerusalem siti bokeru 3 kilomita rarainere so maŋfuŋgo peya. ");
INSERT INTO mlh_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ore eru Juda ŋiŋigo kokoineji Marta Maria seŋyakuŋ komeya ore “Soŋguŋ ŋone yapekimiŋ,” miku wareru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ŋebi Martaji “Yesu warega,” mibi maneru pi bokeru kadio raru bofukeyayoŋ, Mariaji pigo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kadio bofukeru iŋi ojiya, “Ofoŋ, go yoo gonoŋ ine, seŋneji so komena. ");
INSERT INTO mlh_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","So komenayoŋ, goji damaŋ yoo oŋuakoŋ Anuture ya more oŋga wosimiŋ ine, oi sosowo soine maneru gareko bofukemiŋ, oŋu manego.” ");
INSERT INTO mlh_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Buŋo oi maneru Yesuji ojiya, “Gore senji gboreru pakereiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Oi maneru Martaji miya, “Morende damaŋ tatariineo komekiine yoŋoji pakerenimiŋ, iŋoji damaŋ yasogo oo gboreru pakereiŋ, oi mane mukugo.” ");
INSERT INTO mlh_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Oŋu miko Yesuji ojiya, “Komegone papakare Rau oi nonji fukego. Nake Gogo sanaŋinere Rau fukego. Ore eru moji noŋ manesiŋ nuga, iŋoji komeiŋyoŋ, jibu jikigaru goku sanaŋgaru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Moji mo moreŋgo goku manesiŋ nuiŋ ine, iŋoji damaŋ mogo kome sanaŋine so komeiŋ. Mata. Buŋo oi manesiŋ gage me mata?” ");
INSERT INTO mlh_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martaji buŋo oi maneru miya, “O Ofoŋ, oi manesiŋ gago. Goji Anuture Made fukege. Munaŋqoqo Rauine Kristo moreŋgo fukeiŋ ore mibuŋ, goji iŋo fukege. Oŋu manesiŋ gago.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martaji buŋo oŋu miku piineo kirieru raru qoine Mariare kamiine mime qaŋaŋineo wareme ojiya, “Qaqajiji wareru kadio dimaku gore aroo raru ŋonemiŋ ore miga.” ");
INSERT INTO mlh_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Oŋu miko Mariaji buŋo oi maneru oo akoŋ oi bokeru Yesureo raya. ");
INSERT INTO mlh_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Rayayoŋ, Yesuji pi kae jiŋoo so wapeme aroo Martaji kadi yasogoo bofukeru ŋoneya, oo akoŋ dimaya. ");
INSERT INTO mlh_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juda ŋiŋigo yoŋoji Mariake pi maŋineo Mariare maŋ bomunaŋgaiŋ ore ŋekabi Mariaji pipa pakereru sakibe wakiru rame ŋoneru iŋi manesuku mibuŋ, “Iŋoji jiŋoruŋgo raru kuyoiŋ.” Oŋu miku iŋore ŋadio boyoberu rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariaji raru Yesu dimaya oo rope ŋoneru kufuineo daberu wakiru iŋi ojiya, “O Ofoŋ, goji yoo gonoŋ ine, seŋneji so komena.” ");
INSERT INTO mlh_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Oŋu miku jojoraku oŋgaku kuyome Juda ŋiŋigo iŋoke wareru kitiŋgaku moko kuyobuŋ, Yesuji oi ŋoneru beu jajamaine mokiame jiŋoine buburiko me kufuine gburugburu qaya. ");
INSERT INTO mlh_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Gburugburu qame weu yareya, “Iŋo uro ruabi pega?” Weu yareme mibi maneya, “Ofoŋ, yoo wareru ŋone!” ");
INSERT INTO mlh_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Oŋu mibi Yesuji kuyoya. ");
INSERT INTO mlh_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kuyome Juda ŋiŋigo yoŋoji ŋoneru mibuŋ, “Yei! Ogoinere aŋi kokoine pe teko goega.” ");
INSERT INTO mlh_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Oŋu mibuŋyoŋ, goineji buŋo oi qaku iŋi mibuŋ, “Jiŋokombi ŋiŋigo jiŋoyaŋuŋ botigaru goya ine, soine Lazarus miko so komena me?” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Oŋu kosa mibi Yesure beu jajamaine moke mokiame jiŋoine buburiko jiŋoruŋgo raya. Jiŋoruŋgo raru ya iŋi ŋoneya: Ko kimboŋ pujeru qoŋgbuŋine ore maŋgo ruaru mendiine ko yasogoji kejigabi ŋeya. ");
INSERT INTO mlh_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Oi ŋoneru iŋi miya, “Ŋoŋo ko qoririkebi raine.” Oŋu miko ŋi komeya ore seŋ Marta iŋoji iŋi ojiya, “O Ofoŋne, una 4 peya ore kouineke fukega.” ");
INSERT INTO mlh_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesuji oi maneru Martare iŋi miya, “Go manesiŋ nunoŋ ine, Anuture usunji kuririineke fukeko ŋonenoŋ. Rone buŋo oŋu gajiboŋ me mata?” ");
INSERT INTO mlh_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Oŋu miko ko qoririkebi rako Yesuji paibe pime ropeko iŋi miya, “Mama, go oŋgawowosine manege ore eru ‘Beufii fiine!’ migarego. ");
INSERT INTO mlh_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Go damaŋ so oŋgawowosine maneege, manegoyoŋ, goji sore nunde moreŋgo wakiboŋ, ŋiŋigo kubu sogo rore nuru yoo dimagobi, yoŋoji oi maneru manesiŋ ganimiŋ ore eru buŋo yo migo.” ");
INSERT INTO mlh_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Oŋu miku maruine romaiŋgaru sanaŋine oŋgaku iŋi miya, “Lazarus, go pakereru ware!” ");
INSERT INTO mlh_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Oŋu oŋgame ŋi komiine iŋoji gboreru pakereru wareya. Me kufuine kambaŋ mobeine yagaŋineji komoŋgaru jiŋo maiine kambaŋ diŋiŋineji poporiŋgaru kipebi peya. Peko pakereru kambaŋ paiopaio wareya. Oŋu wareme Yesuji miya, “Ŋoŋo kambaŋ ropuine piruebi soine raine.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Juda ŋiŋigo Mariareo waperu Yesuji ya eko ŋonebuŋ, yoŋoreone kokoineji maŋyaŋuŋ kerisieru Yesu manesiŋ gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Manesiŋ gabuŋyoŋ, goineji Farisi (Kadi buŋore yameŋyameŋ) yoŋoreo raru Yesuji ya eya, ore sundu yajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sundu oi yajibi soriŋ gio siŋaŋ eru Farisi yoŋoji soriŋ kaunsol minebobo kepore yabebi tumaŋgabi iŋi mibuŋ, “Ŋi iŋoji mosi qoqowirie usuŋineke sauesaueine eega ore iŋo uruŋu etebeneŋ sagana? ");
INSERT INTO mlh_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Eibieku ya mo so etebeneŋ jikigaru oŋu eru goiŋ ine, ŋiŋigo sosowo iŋo manesiŋ ganobuŋ. Oŋu ebi Rom gawman yoŋore maŋ rigaŋgame wareru niŋonoŋunde boji soriŋ eru ŋiŋigo kubu sogo yo nowo ro norebi omaine yobu egu gokimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Oŋu miku ŋekabi yoŋoreone mo tinaine Kaiafas iŋoji gosa oo soriŋ gio siŋaŋ qoruine fukeru gio oi baku goya. Iŋoji pakereru kajeqouŋ buŋo iŋi yajiya, “Ŋoŋo maŋ mamaneŋaŋunde kimboŋ oŋuakoŋ so tiŋaga. ");
INSERT INTO mlh_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ŋoŋo buŋo yo soine so osoegobi: Niŋo ŋiŋigo kubu soguine sosowo sibirigabeneŋ yobiŋ yasogo yobu egu fukeiŋ. Ore eru ŋi moakonji Juda kubu soguine niŋore ikogonoŋuŋ eru duenoŋuŋ komeko sagaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Iŋoji buŋo oi iŋoyoŋunde marugo so fukeko miyayoŋ, gosa oo soriŋ gio siŋaŋ qoruine goya ore eru iŋoyoŋe buŋore fuŋne so maneru kajeqouŋ buŋo miya, “Yesuji ŋiŋigo kubu soguine niŋore eru komeko sagaiŋ.” Buŋo oi foriine miya. ");
INSERT INTO mlh_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Juda ŋiŋigo kubu soguine niŋore akoŋ so komeyayoŋ, Anuture maŋkekerisie kufufuŋ moreŋ so roiŋgaru gogobeneŋ, noŋuŋ oŋuakoŋ qodure nobeko maŋkekerisie kubu moakoŋ fukeru gokimiŋ ore komeya. Komeinde buŋo oi bonieru miya. ");
INSERT INTO mlh_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Una oo akoŋ fuŋgaru minebobo yoŋoji tumaŋgaru oŋu mimane eku Yesu komeinde buŋo misanaŋgaru buruine ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ore eru Yesuji jikigaru Juda yoŋore botugo totogo so roware eru goya. Oŋu matayoŋ, boke yaberu moreŋ buroinere qaŋaŋgo raya. Oo raru taoŋ tinaine Efraim oo roperu kiŋariŋpuine yoŋoke yoŋoyoŋe akoŋ gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juda niŋore ŋonemaiŋ kombanji qondiŋgaya. Ore eru Juda ŋiŋigo kokoineji kae so piyaŋuŋ bokeru Anutuji keririke yabeiŋgo maneru Jerusalem sitio ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yesu baaru goku boji sorinde jokoroŋ maŋgo dimaku mimane eku iŋi weweu ebuŋ, “Yesuji jeri kombaŋ ore yoo warena me mata? Uruŋu manegobi?” ");
INSERT INTO mlh_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Oŋu weweu ebuŋyoŋ, soriŋ gio siŋaŋ eru Farisi yoŋoji mimiti buŋo iŋi ruabi saueya, “Moji Yesure ŋeŋe pepe ŋoneru maneiŋ, iŋoji niŋoreo wareru biŋeine mime maneru ra roru kipekimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Anutuji ronekoŋ ŋone noberu emboŋ eru nodureya, ore ŋonemaiŋ kombanji bembeŋgaru una 6 tariko oiji wareru fukeiŋgo eya. Yesuji damaŋ oo kae tinaine Betani oo raya. Rone ŋi tinaine Lazarus bogboreme komegone pakereru goya, iŋore pigo ropeya. ");
INSERT INTO mlh_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Oo ropeme Yesu araŋ bateiŋgo ore pi mogo uqo rigaru bomogabuŋ. Martaji rigaru ruabomo eri keku yareyayoŋ, ŋi Yesuke moko ŋeku uqo nobuŋ, Lazarusji yoŋore botugo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Oŋu ŋebi Mariaji jiji sogo mo yobiŋine 500 gram oi roru Yesureo wareya. Wareme oi obu kouineke foriine tinaine nad furiine ropekiine sogo oiji pupuseine. Iŋoji oi roru wareru dikanji keru Yesure kufuo keseru rauteru qoru sikiineji bokereŋgame kereŋgaya. Oŋu fukeme pi maŋgo ŋebuŋ, oi obure kouji isirigaru sagaru peko manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Oŋu fukeko Yesure kiŋariŋ yoŋoreone mo tinaine Judas Iskariot, jiki Yesu babae baya, ŋi iŋoji qomuku teku iŋi miya, ");
INSERT INTO mlh_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Obu kouineke oi wamore furiine banimiŋ ore so ruaga? Yei, mamagore sia! Oi ruana ine, giobobo 300:re furi (Kina 6,000) ore so kitigana. Oi ŋiŋigo wakiqoqoine yarebi sagana.” ");
INSERT INTO mlh_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Oŋu miyayoŋ, buŋo oi ŋiŋigo wakiqoqoine yoŋore manebu eya ore eru so miya. Yoŋore eru matayoŋ, kiaŋ bobo ŋi goku qoqodure moneŋ kekereyaŋuŋ siŋaŋ gaku moneŋ ruabi rakame oone mobeine iŋoyoŋunde roru goya. Iŋo ore eru oi miya. ");
INSERT INTO mlh_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Oŋu miko Yesuji yajiya, “Ŋoŋo ŋigo yo so miteniŋ. Nonji komebe yaŋga nuniminde damaŋ bembeŋgaga ore soine sakine obu kouinekeji rau narega. ");
INSERT INTO mlh_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ŋiŋigo wakiqoqoine yoŋo damaŋ so botuŋaŋuŋgo gogobiyoŋ, nonji ŋoŋoke damaŋine damaŋine so gobemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yesuji Betani kaeo goya, oi Juda ŋiŋigo kubu kokoineji maneru oo warebuŋ. Yesure akoŋ so warebuŋyoŋ, Lazarus komegone bogboreme pakereya, oi moko ŋoneiŋgo ore mobemobe oone poreru wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Oŋu wapebuŋyoŋ, soriŋ gio siŋaŋ yoŋoji “Lazarus oŋuakoŋ qabeneŋ komeiŋ,” miku buŋo kipebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Juda ŋiŋigo kokoineji Lazarusre eru Betani raru maŋyaŋuŋ kerisieru Yesu manesiŋ gabuŋ. Ore eru buŋo oŋu kipebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Oŋu ketebi peku pakereru oo ŋiŋigo kubu sogoji ŋonemaiŋ kombaŋ ore Jerusalem sitio waperu gobuŋ, yoŋoji biŋe buŋo iŋi manebuŋ, “Yesuji Jerusalem wareiŋgo kadio warega.” ");
INSERT INTO mlh_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Buŋo oŋu maneru tupe meine rekaineke roru kadio bofukeru ŋoneiŋ ore raru iŋi miku oŋgabuŋ, “Hosana! Ohowe ohowe! Anutu miteŋ gagobeneŋ. Ofonde tinao warega, Anutuji oi mifiagaine! Israel niŋore Kiŋ Koitonoŋuŋ ohowe ohowe!” ");
INSERT INTO mlh_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesuji doŋgi mendaine mo bofukeru ore paio roperu ŋeya. Oi kajeqouŋ buŋo mo iŋi quraŋgabi pega ore so fukeya, ");
INSERT INTO mlh_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“O Jerusalem ŋiŋigo Zaion tuku roregaru ŋegobi, ŋoŋo maneniŋ, ŋoŋore Kiŋ Koitoŋaŋunji wareiŋ. Doŋgi madeinere paio ŋeku wareiŋ. Ore eru kokoiŋaŋuŋ so maneinebi.” ");
INSERT INTO mlh_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesure kiŋariŋpuji ya fukeya, ore fuŋine rone so mane mukubuŋyoŋ, jiki soine mane taniŋgabuŋ. Yesuji Sombuŋgo roperu kuririquraŋineke goya, buŋo oi damaŋ oo manesuku iŋi mibuŋ, “Aha! Buŋo oi Yesure quraŋgabi pega eru ŋiŋigoji buŋo ore so etebuŋ foriineke fukeya.” ");
INSERT INTO mlh_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ŋiŋigo Yesuke Betani gobuŋ, yoŋoji munaŋ moge oŋuine dimaku biŋeine misauebuŋ. Yesuji Lazarus oŋga teme komegone gboreru pakereru jiŋorunde ko kouŋ bokeru wapeme ŋiŋigo kubuji ŋonebuŋ, yoŋoji Yesure fuŋne kitiŋgaku miku mitaniŋgabi. ");
INSERT INTO mlh_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yesuji mosi qoqowirie oi baya, buŋo oi manebuŋ ore eru ŋiŋigo kubu sogoji doduru keporeiŋ ore rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Oŋu rakabi Farisi (Kadi buŋore yameŋyameŋ) yoŋoji yoŋoyoŋe akoŋ mimane eku iŋi mibuŋ, “Maneniŋ. Moreŋine moreŋine ŋiŋigo yoŋo dodu poreru iŋore ŋadio raegobi eru niŋo buŋo gio oi akoŋ baku bibiebeneŋ foriine mo so fukega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Juda ŋiŋigo ŋonemaiŋ kombaŋ ore Jerusalem sitio roperu Anutu ohoweine baku miteŋ gabuŋ, yoŋore botugo Grik ŋiŋigo goine moko gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yoŋoji kiŋariŋ tinaine Filip iŋoreo warebuŋ. Filipji Galili prowinsre taoŋ tinaine Betsaida ore ŋi goya. Grik yoŋoji iŋoreo wareru weuku iŋi ojibi maneya, “Sogunenoŋuŋ, niŋo aŋinoŋuŋgo Yesu ŋoneiŋgo manegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Oŋu ojibi maneru Andrureo raru buŋo oi ojiya. Miko maneru moko raru Yesu mibire maneya. ");
INSERT INTO mlh_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Buŋo oi maneru kerisieru iŋi miya, “Sombunde kuririquranji Sombuŋ eru morende Ŋi Foriine iŋoreo moke fuke mukume taniŋgaiŋ, ore damanji bembeŋgaga. ");
INSERT INTO mlh_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nonji komenere soso buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Yagoŋ koruŋ moreŋgo so rakaru pougaiŋ ine, omaine oŋuakoŋ peiŋ. Oŋu omaine peiŋyoŋ, rakaru pougaiŋ ine, bobuineji pougaru erioŋbarioŋ wapeko foriine kokoine fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Ore so uri yoŋoji gogoyaŋuŋ yoŋoyaŋunde sabareku yoŋoyaŋunde aŋigo batiqatiine tomiri goinde aŋi maneega, yoŋore gogoji jibugaiŋ. Oŋu jibugaiŋyoŋ, moji mo iŋoyoŋunde gogo ŋiŋira ruaru noŋ miineo rua nuiŋ, iŋoji gogo foriine erioŋbarioŋke bofukeru tatariine tomiri sanaŋgaru go ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Moji noŋ kiŋaŋ qanareiŋgo miga, iŋoji bio noŋ boyobe nuru goko sagaiŋ. Kiŋaŋ qaega, noŋ roware eru gobemiŋ, oo oŋuakoŋ noke goiŋ. Moji noke goku kiŋaŋ qanareega, Mamaji iŋo araŋ baneko goiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesuji miya, “Beune muŋambe yo waperu kejigame beune wapeko gogo. Bio uruŋu minobo? Buŋo baago. O Mama, go soine koŋkoŋ aua damaŋ yoone bomuku nu. Jibu iŋi ore oŋu so oŋga wosigabemiŋ: Aua yoore joiserereŋ oi maneku karieru osigabemiŋ ore eru gogake paineo ruage. ");
INSERT INTO mlh_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","O Mama, go gakere kuririquraŋ nareku tinabiŋego bosogueigoŋ.” Oŋu oŋga wosigako Sombuŋgone buŋo iŋi fukeya, “Nonji kuririquraŋne gareku oo tinabiŋene bosogueba eru jikigaru bosoguebe saueru raiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Buŋo oi fukeko ŋiŋigo kubu dimabi yoŋoji oi maneru mibuŋ, “Bobori parandaŋ oŋgaga.” Goineji mibuŋ, “Sombuŋ mimerereŋ moji iŋo buŋo ojime fonuŋine manegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Oŋu oŋu mikabi iŋi yajiya, “Fonuŋ oi nonde eru so fukegayoŋ, oi ŋoŋore eru fukega. ");
INSERT INTO mlh_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Damaŋ yoo moreŋine moreŋine ŋiŋigo eebobo sembene boyobeegobi, yoŋore oosoe damanji mai yabega. Anutuji yoŋore buŋo mitariru geoine bokirie yareme paiyaŋuŋgo ropeiŋgo ega. Damaŋ yoo Anutuji Sembenere Nemu moreŋ so siŋaŋ yabeega, oi yobeme sakiineo wakiiŋ ega. ");
INSERT INTO mlh_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iŋoji wakiiŋyoŋ, nonde iŋi fukeiŋ: Ŋiŋigoji moreŋgone ro nuru sowoo qakasi nubi roperu dimabe kadi fukeko ŋiŋigo moreŋ so furu yabebe doduru nondeo wareru kubu baku dimanimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Oi kome uruŋune komeiŋ, ore buŋo keroriine oŋu yajime manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ŋiŋigo kubu yoŋoji oi maneru iŋi ojibuŋ, “Niŋo Kadi buŋo oseru iŋi manegobeneŋ, ‘Kristoji so komeru tatariine tomiri go roperu goiŋ.’ Goji wamore iŋi nojige, ‘Sombuŋ eru morende Ŋi Foriine moreŋgone roku bopeŋgabi sowoo roperu dimaiŋ.’ Sombuŋ eru morende Ŋi Foriine oi moji?” ");
INSERT INTO mlh_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Oi maneru bokirie yareya, “Tatamaji damaŋ pompoŋine moke botuŋaŋuŋgo fureru goiŋ. Qisiriji paiŋaŋuŋgo roperu kema ŋabeme ore biŋe egu fukenimiŋ ore tatamaineo roware eru goinebi. Tatamaji pe ŋareiŋ ore so tatamaineo goinebi. Moji qisirigo qaŋgoqasa raru wareega, uro ropeiŋ, oi so manega. ");
INSERT INTO mlh_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ore eru tatamaineji damaŋ wojimu ŋoŋoke goiŋ, damaŋ oo oi manji mane sabareku goinebi. Tatamare kufufuŋ fukeru gonimiŋ ore tatamaine oi manesiŋ garu goinebi.” Yesuji buŋo oŋu miku boke yaberu sumuŋgaru raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuji mosi qoqowirie kokoine baku gome Juda siŋaŋ yoŋoji oi jiŋoyaŋunji noŋebuŋyoŋ, jibu oi so manesiŋ gaku keoma gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Oŋu gobi kajeqouŋ ŋi Aisaiare buŋo mo oi foriineke fukeya. Iŋoji buŋo oi iŋi quraŋgame pega, “O Ofoŋ, niŋoji Biŋe buŋo mitaniŋgaru maŋyaŋuŋ bapakare yabeegobeneŋyoŋ, moji oi manesiŋ gana? Ofonji usuŋine oi more barariŋgame mane taniŋgaiŋ?” ");
INSERT INTO mlh_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Munaŋqoqo Rauine manesiŋ gaiŋ ore yobiŋgaru embimbiŋgabuŋ, Aisaiaji ore fuŋine maneru buŋo mo ronekoŋ iŋi miku quraŋgame pega, ");
INSERT INTO mlh_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yoŋoyaŋunde jiŋoji ya ŋoneru fuŋine egu ŋone mukunimiŋ me maŋyaŋunji buŋo fuŋine egu mane taniŋganimiŋ. Oi mane taniŋgaru maŋyaŋuŋ egu kerisienimiŋ. Maŋyaŋuŋ kerisiebi egu bobiaŋ yabeiŋ. Iŋoji oŋu egu fukeiŋ ore ŋiŋigo jiŋoyaŋuŋ bokoberu maŋyaŋuŋ kejigame gogobi.” ");
INSERT INTO mlh_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesuji Sombunde kuririquraŋgo fureru gome Aisaiaji oŋu ŋoneru fuŋine mitaniŋgaru buŋo oi miya. ");
INSERT INTO mlh_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Minebobo eru siŋaŋyayabe ŋi yoŋoreone kokoineji oŋuakoŋ Yesu manesiŋ gabuŋyoŋ, Farisi (Kadi buŋore yameŋyameŋ) yoŋoji oŋgawowosi pi kubuone egu yobe yabeiŋ ore oi totogo so mifukebi. ");
INSERT INTO mlh_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ŋiŋigoji miteŋ yabenimiŋ ore yameŋ kebuŋyoŋ, Anutuji miteŋ yabeiŋ ore oi qaqosori ebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Goineji oŋu ebuŋyoŋ, Yesuji oŋgaku iŋi miya, “Moji manesiŋ nuga, iŋoji noŋ akoŋ so manesiŋ nugayoŋ, moji sore nuya, oi oŋuakoŋ manesiŋ gaga. ");
INSERT INTO mlh_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Moji noŋ ŋone nuru sore nuya, oi oŋuakoŋ ŋoneega. ");
INSERT INTO mlh_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ŋiŋigo mo noŋ manesiŋ nuga, iŋoji qisirigo qakatoru egu goiŋ. Ore eru nonji wakiru fukeru moreŋine moreŋine ŋoŋore tatama fukeru gogo. ");
INSERT INTO mlh_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Nonji wakiru fukeru moreŋine moreŋine ŋoŋore buŋo mitaribemiŋ ore eru so wakiboŋyoŋ, ŋiŋigo moreŋ so muŋaŋ qa yarebe damaŋ yoo qowirieru Sombunde biŋe fukenimiŋ ore eru wakiru gogo. Ore eru ŋiŋigo nonde Biŋe buŋo maneru so reŋgaru boyobeegobi ine, nonji yoŋore buŋo so mitaribemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Uri yoŋoji mipemiriŋ enareku Biŋe buŋone so maneru sabaregobi, yoŋore mimitariji iŋi fukeiŋ: Nonji Biŋe buŋo mibe manebuŋ, buŋo oiji damaŋ yasogoo buŋoyaŋuŋ mitarime joiserereŋ ore so manenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Fuŋine iŋi ore oŋu fukeiŋ: Nonji Biŋe buŋo miku goboŋ, oi buŋo omaine matayoŋ, oi nakene aŋigone so fukeko miku go wapeboŋ. Oŋu matayoŋ, Mama sore nuya, oi iŋoyoŋe mibuŋo uruŋu mibemiŋ, ore mitiga nareme miku go wapego. ");
INSERT INTO mlh_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mamare mimiti oiji ŋoŋo gogo sanaŋineo rua ŋabeega, oi manego. Ore eru Mamaneji oi mibemiŋ ore mitiga nareya, noŋ ore so Biŋe buŋo miego.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ŋonemaiŋ kombanji qondiŋgame Yesuji fuŋine iŋi mane mukuya, ‘Moreŋ bokeru Mamaneo ropebeminde damanji bembeŋgaga.’ Oŋu mane mukuku iŋoyoŋunde ogopu moreŋgo gobuŋ, oi maŋineji manjoko eyareru goku tatariine oo oŋuakoŋ manjokoine oi yaduya. ");
INSERT INTO mlh_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Komeinde damanji wareru fukeiŋgo eru damaŋ mogo ubure uqo nonimiŋ ore tumaŋgaru moko ŋekabi ya iŋi fukeya: Saimon Iskariotre made tinaine Judas oi Satanji sakioŋga foreya. Yesu babae eteinde buŋo oi saŋu qame maŋineo rakame maneru ŋeya. ");
INSERT INTO mlh_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuji iŋoyoŋunde fuŋne oi iŋi mane mukuya, ‘Mamaji ya sosowore usuŋ oi nonde meo ruame Anutureone wakiru goku moke iŋoreo ropeiŋ ego.’ ");
INSERT INTO mlh_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Fuŋine oŋu mane mukuru uqo noku ŋebuŋgone pakereru marikuine kemukuru giore kambaŋ mobeine mo roru ombuineo qukarieru kipeya. ");
INSERT INTO mlh_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Oi kiperu obu juago kesieko rakame fuŋgaru kiŋariŋpuine yoŋore kufu jureya. Jure foreru kereŋ mobeine (sakikeketi) ombuineo qukarieru kipeya, oiji kufuyaŋuŋ bokereŋgaya. ");
INSERT INTO mlh_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jureru raru Saimon Pitare kufuo wapeko iŋi ojiya, “O Ofoŋ go kiŋaŋqoqo wakiqoqoine mata. Goji nonde kufu jurende so sagaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Oŋu miko maneru iŋi bokirieya, “Ya muŋambe yo ego, goji ore fuŋine damaŋ yoo so mane mukugeyoŋ, jikiineo oi soine mane taniŋgaru gomiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bokirieme iŋi yameŋ keku miya, “Go nonde kufu damaŋ mogo so yobu juremiŋ.” Oŋu miko iŋi ojiya, “Nonji go so jure garebemiŋ ine, go nonde kiŋariŋ jikigaru goiŋgo embimbiŋgamiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Oŋu ojime Saimon Pitaji bio popureru bokirieya, “Ofoŋ, ore eru go kufune akoŋ matayoŋ, mene eru qorune oi moko jure.” ");
INSERT INTO mlh_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Oŋu bokirieme iŋi ojiya, “Moji obu rauku wareko kufuine oŋuakoŋ jurebeneŋ wonuŋine tomiri qaŋkisiekiine fukeiŋ. Ŋoŋo sosowo gbagbataeŋine fuke foregobiyoŋ, moakonji gbagbataeŋine so fukega.” ");
INSERT INTO mlh_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Moji babae bateiŋgo eya, Yesuji oi maneru ore eru iŋi miya, “Ŋoŋo sosowo gbagbataeŋine so fukegobi.” ");
INSERT INTO mlh_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kufuyaŋuŋ jure foreru marikuine moke keru wakiru ŋeko uqo nobi iŋi weu yareru miya, “Nonji ya eŋarego, ŋoŋo ore fuŋine mane taniŋgagobi me mata? ");
INSERT INTO mlh_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ŋoŋo nonde ‘Qaqaji!’ eru ‘Ofoŋ!’ oŋu minareegobi eru nonji oi foriine fukego. Ore eru oi soineo miegobi. ");
INSERT INTO mlh_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nonji ŋoŋore Ofoŋ Qaqaji fukeru kiŋaŋqoqo wakiqoqoinere mosi eba eku kufuŋaŋuŋ jurego ine, ŋoŋoji oŋuakoŋ baba waki eku kiŋaŋqoqo fukeru kufuŋaŋuŋ jujure eku gobi sagaiŋ. Oi ŋoŋore gio. ");
INSERT INTO mlh_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","“Nonji baku ŋadugo, ŋoŋo ore so kitiŋgaku kiŋaŋ qoqo eku goinebi. Oŋu gokimiŋ ore mosi nonji muŋambe ŋadube ŋonegobi. Oi manesuku ore kamasi boyobebi sagaiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Kiŋaŋqoqoji wakiqoqoine fukeko rauineji ropekiine fukega. Kiŋarinji qaqajiine odureru ropekiine fukeiŋgo embimbiŋgaiŋ. Oŋuakoŋ ŋi ofoŋ moji mimerereŋine soreme kiŋaŋ raru gio baega, iŋoji ofoŋinere yukuineo goga. ");
INSERT INTO mlh_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ŋoŋo buŋo koruŋ oi muŋambe mane mukugobi. Ore eru sakibobo bokeru ogopuŋaŋuŋ yoŋore mea yukuo raru gonimiŋ ine, nonji ŋoŋore ‘Oi kiwaqawaineke!’ mibemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Buŋo migo, oi ŋoŋo sosowo so ro ŋabega. Nonji mo roosoeru oga yabeboŋ, yoŋore fuŋne oi soine mane mukugo. Oŋu gogoyoŋ, Biŋe Quraŋ mo oiji foriineke fukeko sagaiŋ. Buŋo oi iŋi, ‘Moji noke uqo moko nogobere, iŋoji midobodo eku gbakuineji odepie nuru nuiŋgo jauega.’ ");
INSERT INTO mlh_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Noŋ foriine jiki fukeiŋ ore buŋoine rone migo. Ore eru foriine fukeiŋ, ŋoŋo damaŋ oo nonde fuŋne mane taniŋgaru iŋi minimiŋ, ‘Aha! Gogore fuŋne damaŋ so go waperu goya, iŋoji oi fukega.’ Oŋu miku manesiŋ nunimiŋ ore nonji buŋo oi bonieru totogo mibe manebi. ");
INSERT INTO mlh_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Nonji ŋiŋigo mo sorebe gio baiŋgo ore wareko moji oi keporega, iŋoji noŋ oŋuakoŋ kepore nuiŋ. Oŋuakoŋ noŋ kepore nuga, iŋoji moji sore nuya, oi oŋuakoŋ kepore teiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuji buŋo oŋu miku beuine waperu kebojiru pougaiŋ ore eru buŋo barariŋgaru iŋi yajiya, “Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Ŋoŋoreone moji noŋ babae banuiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Oŋu yajime kiŋariŋpuineji yoŋoyoŋe qipupiware piku bibitatara ŋoŋone eku bubu iŋi manesubuŋ, “Oi more miga?” Oŋu manesuku maŋyoka koŋkoŋ ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Koŋkoŋ ŋeku uqo nokabi Yesure wombuŋ kiŋarinji iŋore keririŋgo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Iŋoji ŋeko Saimon Pitaji qoruineji akoŋ kiŋariŋ oi soso eteku iŋi ojime maneya, “Buŋo oi more miga, oi weu teru minde manebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Oŋu ojime maneru fooreku Yesure omoineo kitiŋgaku iŋi weuya, “Ofoŋ, ŋi oi moji?” ");
INSERT INTO mlh_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Oŋu weume bokirie teya, “Poroŋ mobeine sigo igokurugaru mo otebemiŋ, iŋoji oi.” Kerisieru poroŋ mobeine roru sigo igokurugaru Judas oteya. Judasre mama tinaine Saimon Iskariot. ");
INSERT INTO mlh_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Poroŋ mobeine oi oteme Satanji oo akoŋ Judasre maŋgo rakaya. Ore eru Yesuji oi mitiga teku iŋi ojiya, “Ya bamiŋ, oi pipa baigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Buŋo oŋu ojiyayoŋ, oi wamore ojiya, oi kiŋariŋ goineji moko ŋeku uqo nobuŋ, yoŋoreone moji mo so mane taniŋgaya. ");
INSERT INTO mlh_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kiŋariŋ goineji ore eru iŋi manesubuŋ, “Judasji moneŋ kekerere siŋaŋ goya, ore eru kombaŋ damaŋgo ya embimbiŋgakimiŋ, oi furiine bainde sorega me ŋiŋigo wakiqoqoine moneŋ ya mo yareiŋ ore miga.” ");
INSERT INTO mlh_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasji buŋo oi soine mane taniŋgaru poroŋ mobeine oi roru oo akoŋ bokeru sakibe rako ubu eya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judasji bokeru sakibe rako Yesuji iŋi yajiya, “Muŋambe yo Anutuji kuririine Sombuŋ eru morende Ŋi Foriine ete foreme iŋoji Anuture tinabiŋe bosogueme taniŋgaga. ");
INSERT INTO mlh_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Iŋoji Anuture tinabiŋe bosogueru Anutuke qakatoga ore Anutuji oŋuakoŋ iŋore tinabiŋe bosogueiŋ. Oi damaŋ so joroko bosogueru kuririquraŋineji fukeko go ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“O kokopune, nonji damaŋ pompoŋine moke ŋoŋoke gobemiŋ. Oi goku boke ŋabebe jiki baa nuru gonimiŋ. Juda yoŋore iŋi ŋajibe maneniŋ, ‘Noŋ kae rabemiŋ, ŋoŋo oo wareiŋgo embimbiŋganimiŋ.’ Buŋo oi akoŋ muŋambe yo ŋoŋore oŋuakoŋ migo. ");
INSERT INTO mlh_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Nonji mimipaŋ buŋo gariine mitiga yarego: Ŋoŋo maŋ-ŋaŋunji jojoko eku goinebi. Nonji manjoko eŋareru goboŋ, ŋoŋo ore so jojoko eku goinebi. ");
INSERT INTO mlh_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Botuŋaŋuŋgo maŋ-ŋaŋunji jojoko naduŋgaduŋ eru gonimiŋ ine, ŋiŋigo sosowo yoŋo ŋone ŋaberu fuŋneŋaŋuŋ mane mukuru iŋi miku gonimiŋ, ‘Aha! Oi Yesure kiŋariŋpuine fukegobi.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pitaji Yesu iŋi weu teya, “Ofoŋ, go uro ramiŋ?” Weu teme bokirieya, “Noŋ uro rabemiŋ, goji oo boyobe nuru wareiŋgo embimbiŋgamiŋ. Damaŋ yoo embimbiŋgamiŋyoŋ, jiki oi soine boyobe nuru waremiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bokirieme iŋi weu teya, “Ofoŋ, noŋ wamore damaŋ yoo go boyobe guru wareiŋgo embimbiŋgabemiŋ? Nonji gogone gore eru kisiŋgaru bokebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Weume iŋi bokirieya, “Goji fofori gogogo nonde eru kisiŋgaru bokemiŋgo mige me? Buŋo oi migoji akoŋ mige. Nonji buŋo foriine yobu mo iŋi gajibe mane: Muŋambe qoquji oŋgaiŋgo bombeŋgako goji damaŋ oo muga nunde ateine yokaomo fukeiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Maŋ-ŋaŋunji manebu paio beusembe so maneru goinebi. Anutu manesiŋ gainebi eru noŋ oŋuakoŋ manesiŋ nuru goinebi. ");
INSERT INTO mlh_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nonde Mamare kae qoruineo pi maŋine boakoŋ pega. Oi so pena ine, ŋoŋore buŋo iŋi minobo: Nonji oo roperu ŋoŋore ŋeŋe pi baku bobiaŋgabemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","“Nonji bonieru raru roperu ŋoŋore ŋeŋe pi baku bobiaŋgabemiŋyoŋ, nonji kae gobemiŋ, ŋoŋoji oŋuakoŋ noke oo moko goniminde aŋi manego. Ore eru nonji moke kirieru wareru oga yabebe paibe ropenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nonji kae urobe rabemiŋ, ŋoŋoji ore fuŋine mane muku foregobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yesuji oŋu yajime kiŋariŋ tinaine Tomas iŋoji iŋi miya, “O Ofoŋ, go kae uri ramiŋ, niŋoji oi so manegobeneŋ. Ore eru ore fuŋine oi uruŋu mane mukuganobeŋ?” ");
INSERT INTO mlh_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Oi maneru iŋi ojiya, “Nonji Kadi fukego. Nonji Buŋo foriine eru Gogo sanaŋine fukego. Moji Mamareo ropeiŋgo maneru nondeo wareiŋ ine, iŋoji kadi bofukeiŋ. Kadi furuine mo so pega. ");
INSERT INTO mlh_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ŋoŋoji noŋ fofori mane muku nunobuŋ ine, nakene Mama oŋuakoŋ mane mukunobuŋ. Ŋoŋoji damaŋ yoo fuŋgaru nonde Mama ŋoneru mane foregobi.” ");
INSERT INTO mlh_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Oŋu miko Filipji iŋi ojime maneya, “O Ofoŋ, go Mama nodunde niŋoji oi piku ŋonebeneŋ saga nobeiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Oi maneru Yesuji ojime maneya, “O Filip, noŋ damaŋ joroine yobu ŋoŋoke gbeŋ akoŋ gobe ŋone nuru jibu fuŋne so mane mukuge me? Moji noŋ ŋone muku nuya, iŋoji Mamane oŋuakoŋ ŋone mukuru goga. Ore eru go uruŋu eru Mama nodunde ŋonekiminde mige? ");
INSERT INTO mlh_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","“Nonji Mamake qakatoru dimabe Mamaji noke qakatoru dimaga, oi manesiŋ gage me mata? Buŋo Biŋe mibe maneegobi, nonji buŋo oi nakene maŋgone so roru miego. Mata! Gio baego, oi oŋuakoŋ Mamaneji noke qakatoru dimaga, iŋoji maŋgo enareko foriine fukeega. Ore eru gio baego, oi iŋore gio baego. ");
INSERT INTO mlh_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Nonji Mamake qakatoru dimabe Mamaji noke qakatoru dimaga. Ŋoŋoji oŋu manesiŋ nuinebi. Buŋo oi mineji mibe maneru so manesiŋ nunobuŋ ine, oi mosi qoqowiriene ŋonegobi ore eru manesiŋ nuinebi. ");
INSERT INTO mlh_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Uri yoŋoji noŋ manesiŋ nugobi, yoŋoji oŋuakoŋ noŋ mosi qoqowirie ba gobe, oi akoŋ baenimiŋ. Oŋuakoŋ baenimiŋ eru damaŋ goineo nonji babe, ore soine odureru oi baenimiŋ. Nonji Mamareo roperu gobemiŋ ore eru mosi qoqowirie ropekiine sogo babi fukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","“Mamaneji nonde eru tinabiŋeineke fukeiŋ ore manego. Ore eru ŋoŋoji nonde tinao wamo yare oŋga wosinimiŋ, nonji oi ebemiŋ. Oŋu ebe oo Mamanere tinabiŋe mibi sogueeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ŋoŋoji ya more ore nonde tinao oŋga wosiru weu narenimiŋ ine, nonji oi ebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ŋoŋoji noŋ maŋ-ŋaŋunji jojoko enareegobi ine, nonde mimipaŋ buŋo reŋgaru boyoberu goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","“Nonji Mama oŋga wosi etebe iŋoji maŋgo uje Rauine mo ŋareme wakiru nonde tife tatariine tomiri ŋoŋoke go ropeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Maŋgo uje Rauine oi Moro Tiriine. Iŋoji buŋo foriinere Rau fukega. Maŋyaŋuŋ so kerisiebuŋ, yoŋoji oi so ŋone mukuru so manegobi. Ore eru yoŋoji oi kepore teru sabareiŋgo embimbiŋgaegobiyoŋ, Moro iŋoji ŋoŋoke goga eru jiki maŋ-ŋaŋuŋgo rakaru ŋoŋoke dimaiŋ. Ore eru oi kotu matayoŋ, oi soine mane mukugobi. ");
INSERT INTO mlh_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nonji boke ŋabebe begu made oŋuine so fukeru gonimiŋ. Noŋ ŋoŋore kirieru warebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Damaŋ pompoŋine tariko moreŋ ŋiŋigo omaine yoŋoji noŋ moke so ŋone nuru gonimiŋ. Yoŋoji matayoŋ, maŋ-ŋaŋuŋ kerisiebuŋ, ŋoŋoji noŋ soine ŋone nuenimiŋ. Nonji sanaŋgaru gogo ore ŋoŋoji oŋuakoŋ gboreru sanaŋgaru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mama, noŋ eru ŋoŋo, noŋuŋ moakoŋ fukeru gogobeneŋ. Nonji Mamaneke qakatoru dimabe ŋoŋoji noke qakatoru dimakabi nonji ŋoŋoke qakatoru dimago. Ore fuŋine oi Moro Tiriineji maŋ-ŋaŋuŋgo rakainde damaŋ oo soine mane taniŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Moji nonde mimipaŋ buŋo sosowo maneru sabareku reŋgaega, iŋoji maŋineji noŋ manjoko enareega. Moji noŋ manjoko enareko nonde Mamaji oi manjoko eteega eru nonji oi manjoko eteego. Nonji oi manjoko eteru fuŋnene barariŋgabe mane mukuiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesuji oŋu miko Judas Iskariotre jiŋa Judas iŋoji iŋi ojiya, “Ofoŋ, go uruŋu eru fuŋnego niŋo akoŋ barariŋga noremiŋ eru ŋiŋigo maŋyaŋuŋ so kerisiebuŋ, yoŋore oi kesoŋ yabeiŋgo mige?” ");
INSERT INTO mlh_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Oŋu ojime iŋi bokirie teya, “Moji maŋineji manjoko enareega ine, iŋoji nonde Biŋe buŋo reŋgaru boyoberu goiŋ. Oŋu gome Mamaneji oi manjoko eteko Mamake nikoji iŋore maŋgo rakaru damaŋ so iŋoke moko gokimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Moji noŋ maŋineji so manji jojoko enareega ine, oi nonde Biŋe buŋo so reŋgaru boyoberu goiŋ. Buŋo mibe maneegobi, oi nakene Biŋe matayoŋ, Mama sore nuya, iŋoji oi nareme miego. ");
INSERT INTO mlh_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nonji buŋo sosowo oi ŋoŋoke damaŋ so goboŋ, damaŋ oo qaji ŋareru goboŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Oŋu goboŋyoŋ, Mamaji Moro Tiriine nonde tinao soreme wakiru maŋgo uje Rauŋaŋuŋ fukeiŋ getire ŋareeiŋ. Iŋoji buŋo sosowo qaji ŋareru nonji uŋsowoŋ buŋo sosowo ŋarebe, oi egu niga ŋabeiŋ ore kegbore eŋareeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nonji womo ŋarego. Nakene womo yobu fuŋ mo oi ruabe maŋ-ŋaŋuŋgo peine. Moreŋgo ŋiŋigo yoŋoji womo qoqo eegobi, nonji ore kamasi oŋuine so qa ŋareegoyoŋ, oi odureru womo fuŋ mo ŋareebemiŋ. Ore eru maŋ-ŋaŋunji beusembe paio kokoiŋaŋuŋ so maneru goinebi. ");
INSERT INTO mlh_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nonji buŋo iŋi ŋajibe maneniŋ, ‘Nonji boke ŋaberu roperu goku moke ŋoŋoreo kirieru warebemiŋ.’ Ŋoŋoji maŋ-ŋaŋunji noŋ fofori manjoko enarenobuŋ ine, buŋo migo, ore eru soine jerienimiŋ. Mamaji nonde sogune fukega. Ore eru noŋ ‘Mamanereo ropebemiŋ,’ migo, ŋoŋoji oi maneru soine manjeri bofukebi sagana. ");
INSERT INTO mlh_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Buŋo muŋambe yo mikabe manegobi, ore foriine jiki fukeiŋ. Foriine fukeiŋ, ŋoŋoji damaŋ oo oi soine manesuku manesiŋ ganimiŋ. Ore eru oi bonieru ŋajibe manegobi. ");
INSERT INTO mlh_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Damaŋne bembeŋgaga ore ŋoŋoke buŋo kokoine moke miiŋgo so manego. Sembene Nemuji moreŋ so siŋaŋ yabeega, iŋoji bio wareiŋgo jauega. Iŋore tobiriji gbiŋ so enareku kemarieiŋ. Nonde fuŋne oi iŋoji mitigaiŋ ore so, so pega. ");
INSERT INTO mlh_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","So pegayoŋ, nonji Mama manjoko eteego ore ya sosowo buŋo mitiga nareega ore so baego. Moreŋ ŋiŋigoji nonde fuŋne oi miku qaji ŋarebi mane taniŋganiminde manego. Ore eru bio bokeru pakereru warebi raki.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesuji kiŋariŋpuine oi iŋi yajiya, “Nonji wain yo foriine fukebe nonde Mamaji wain giore rau fukega. ");
INSERT INTO mlh_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nonji yo oŋuine kiri tieŋneke fukego. Yo tieŋine sosowo foriyaŋuŋ so bofukeru aputa fukegobi, Mamaneji oi ketigaru boke yabeiŋ. Yo tieŋine sosowo nondeo ŋebi foriyaŋuŋ fukeru deegobi, Mamaneji oi ke keririke yabeiŋ. Eebobore foriine sogueru dekukuŋgaru boakoŋ fukenimiŋ ore boposike yabeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Ŋoŋo Biŋe buŋo ŋajibe oiji bofosike yaberu ke keririke yabeme gbagbataeŋine fukeru gogobi. ");
INSERT INTO mlh_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ore eru ŋoŋoji noke qakatoru dimainebi. Oŋu dimabi nonji ŋoŋoke dimabemiŋ. Wain tieŋine moji yo botuineo so ŋeku mukuru wakiga ine, oi iŋoyoŋe maŋgo ee eku foriine fukeiŋgo embimbiŋgaiŋ. Ore so ŋoŋoji oŋuakoŋ noke so qakatoru dimagobi ine, ŋoŋo-ŋaŋe akoŋ eebobore fori mo bofukenimiŋgo embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Noŋ wain yo fukekabe ŋoŋoji ore tieŋine fukegobi. Ŋoŋo boke nuru ŋoŋo-ŋaŋe akoŋ dimaku ya mo baniminde embiŋbimganimiŋ. Ore eru moji noke qakatoru dimako nonji iŋoke qakatoru dimabe iŋoji eebobore fori mokemoke yobu bofukeru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Uri yoŋoji noke so qakatoru dimagobi ine, wain yo rauineji oi yo tieŋ oŋuine keti yaberu bokeme sakibe ranimiŋ. Raru qaŋibi roru qodureru misigo bokeme rakaru janimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Yoŋoji janimiŋyoŋ, aribe ŋoŋo noke qakatoru dimainebi. Oŋu dimabi nonde Biŋe buŋoji ŋoŋore maŋgo qakatoru dimaga ine, ŋoŋoji oi me oi biŋe qoqo ekiminde manegobi, oi Mama oŋga wosi tebi ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ŋoŋoji nonde kiŋariŋpu fukeru dimakabi eeboboŋaŋunde fori mokemoke yobu fukeru wakiru ŋekabi gonimiŋ. Oŋu eba eku gonimiŋ ore Mamanere tinaji kuririineke fukeru peiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mamaneji noŋ manji jojoko enareku goya, nonji ore so oŋuakoŋ manji jojoko eyareru goboŋ. Ŋoŋo nonde manjoko maŋgo dimainebi. ");
INSERT INTO mlh_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nonji Mamanere mimipaŋ buŋo reŋgaru go waperu iŋore manjoko maŋgo dimago. Ore so ŋoŋo nonde mimipaŋ buŋo roru reŋgaru gonimiŋ ine, soine nonde manjoko maŋgo dimakabi manjoko eyareru gobemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nonji maŋ jeri ŋarebe petigaru maŋ-ŋaŋuŋ puseru peko mokemoke yobu jerieru gonimiŋ ore buŋo oi ŋajibe manegobi. ");
INSERT INTO mlh_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nonde Kadi buŋo oi iŋi: Nonji maŋneji manjoko eŋareru gobe, ŋoŋo ore so ŋoŋo-ŋaŋe jojoko eku goinebi. ");
INSERT INTO mlh_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Moji ogopuine yoŋore eru iŋoyoŋunde gogo kisiŋgaru bokeiŋ, oiji manjoko ropekiine sogo fukega. Moji oi odureru manjoko eŋareiŋgo embimbiŋgaiŋ. Manji jojoko goine oi ore wawakiine. ");
INSERT INTO mlh_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Nonji ya enimiŋ ore mitiga ŋareego, ŋoŋoji ore so eegobi ine, nonde ogopu fukegobi. ");
INSERT INTO mlh_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kiŋaŋqoqore fuŋne iŋi: Siŋaŋineji gioine uruŋu eru baega, oi kiŋaŋqoqoineji so maneega. Ore eru ŋoŋore tina ‘Kiŋaŋqoqopune,’ oŋu so jikigaru miŋarebemiŋyoŋ, Mamaneone Biŋe buŋo maneboŋ, oi sosowo ŋoŋore barariŋga ŋarebe manegobi. Ore eru tinaŋaŋuŋ ‘Ogopune,’ oŋu oŋga ŋarebe sagaga. ");
INSERT INTO mlh_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“O ogopune, ŋoŋoji noŋ so roosoe nubuŋyoŋ, nonji ŋoŋo roosoeru igodoŋ ŋabebe dimagobi. Ore eru ŋoŋoji roregaru raru foriine iŋi bofukeru damaŋ so dekabi pe ropeko sagaiŋ: Nonde tina oŋgaku ya oi me oi ore Mama oŋga wosinimiŋ, oi ŋareme biŋeŋaŋuŋ fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ŋoŋo botuŋaŋuŋgo jojoko eku goinebi. Nonji mimipaŋ buŋone oŋu mitari yarego.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Moreŋgo maŋyaŋuŋ so kerisiebi yoŋo rosi eŋarenimiŋ ine, ŋoŋo buŋo iŋi mane mukuinebi: Yoŋoji rone noŋ oŋuakoŋ rosi enareku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ŋoŋo maŋkekerisiere yaura kubuo gonimiŋ ine, kubupuyaŋuŋ yoŋoji yoŋoyaŋunde ogopu maŋyauŋ eyarenobuŋ. Oi eyarenobuŋyoŋ, nonji ŋoŋo roosoeru yoŋore buruone oga ŋabebe furuine fukeru gogobi. Yoŋore eebobo sembene oi ŋadi gaku gogobi ore eru rosi eŋareegobi. ");
INSERT INTO mlh_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Nonji buŋo mo iŋi ŋajibe manebuŋ, oi maŋ wombuŋ-ŋaŋuŋgo ruaru manesuinebi, ‘Kiŋaŋqoqoji wakiqoqoine fukeko rauineji soguneine fukega. Kiŋarinji qaqajiine odureru ropekiine fukeiŋgo embimbiŋgaiŋ.’ Ore so goineji noŋ kekesuesue enareku go wapebuŋ ine, goine yoŋoji nonde igokopu ŋoŋo oŋuakoŋ kekesuesue eyareku gonimiŋ. Yoŋoji nonde Biŋe buŋo maneru sabareku gobuŋ ine, ŋoŋoji nonde buŋo misaueku gobi oŋuakoŋ soine maneru sabareru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Oŋu gonimiŋyoŋ, noŋ sore nuya, yoŋoji oi so mane mukubi. Ore eru keoma paio ya fuŋne fuŋne kosa eŋarenimiŋ, oi nonde tinabiŋere eru fuke ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Nonji yoŋoreo so wakiru Biŋe buŋo yajibe manenimiŋ ine, yoŋoji agiburaŋyaŋunde mimi so maneru gonimiŋ. Oŋu mo gonimiŋyoŋ, damaŋ yoo agiburaŋyaŋuŋ mane foreru kefaganimiŋ ore embimbiŋganimiŋ. Gbegbedi buŋoyaŋuŋ uruŋu bofukenobuŋ? ");
INSERT INTO mlh_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Moji noŋ rosi enarega, iŋoji Mamane oŋuakoŋ rosi etega. ");
INSERT INTO mlh_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mosi qoqowirie ropekiine sogo babe, oi moji mo ŋoŋore botugo so baku goya. Nonji oi so banobo ine, yoŋoji agiburaŋyaŋunde mimi oi so maneru gonobuŋ. Koŋkoŋ qaku gonobuŋyoŋ, damaŋ yoo nonji oi babe ŋone foreru jibu noŋ eru Mamane oŋuakoŋ omaine yobu rosi enoteku gogobi. ");
INSERT INTO mlh_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Oŋu enoteku gobi Biŋe buŋo moji foriineke fukeya. Mosesji kadi buŋo ŋareya, oo buŋo oi iŋi quraŋgame pega, ‘Yoŋoji omaine yobu rosi enareku gobuŋ.’ Buŋo oiji foriineke fukeya. ");
INSERT INTO mlh_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nonji Mamareo roperu uje Rauine sorebe ŋoŋore wareru maŋ-ŋaŋuŋgo rakaru kitiŋ ŋabeiŋ. Moro Tiriine iŋoji buŋo foriinere Rau fukega. Iŋoji Mamaone wakiru nonde fuŋnene kitiŋgaku mitaniŋga yareru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Iŋoji oŋu goiŋ eru ŋoŋoji oŋuakoŋ nonde fuŋne kitiŋgaku mitaniŋgaru gonimiŋ. Nonji fuŋgaru mande tumoqoqo gio ba gobe, ŋoŋoji fuŋfuŋgaineone noke goku pakerebuŋ. Ore eru ŋoŋo oi soine mitaniŋgaru goinebi. Oŋu.” ");
INSERT INTO mlh_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesuji jikigaru iŋi miya, “Ŋoŋo waki ŋabeko tiŋtuŋ egu qanimiŋ. Ore eru nonji buŋo oi bonieru mibe manegobi. ");
INSERT INTO mlh_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Maŋyaŋuŋ so kerisiebi yoŋoji oŋgawowosi pi kubuyaŋuŋgone ketuŋ ŋabebi sakibe wakiru gonimiŋ. Jiki damaŋ mo wareru fukeiŋ, oo ŋoŋo nonde eru ŋabebi komenimiŋ. Oŋu ŋaberu iŋi minimiŋ, ‘Oŋuine oo Anuture kiŋaŋ qabeneŋ Anuture manji fiaga.’ Sosowoji oŋu mane jibugaru minimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yoŋoji Mama eru noŋ nikore fuŋne so mane taniŋgaegobi ore eru oŋu eŋareku gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","“Oŋu koŋkoŋ qaku gonimiŋyoŋ, nonji buŋo oi bonieru ŋajibe manegobi. Ore eru damaŋ oi ware fukeme buŋo ore foriine fukeiŋ, ŋoŋo damaŋ oo soine iŋi minimiŋ, ‘Kristoji yoore biŋe buŋo bonieru nojiko manebeŋ.’ Nake ŋoŋoke goboŋ ore eru buŋo oi damaŋ joroine peko rone so mikabe mane wapebuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Nonji damaŋ yoo sore nume wakiboŋ, iŋoreo ropeiŋgo ebe ŋoŋoreone moji mo iŋi so weu narega, ‘Go uro ramiŋ?’ ");
INSERT INTO mlh_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Buŋo oŋu migo, ŋoŋoji oi maneru ore eru beusembeji maŋ-ŋaŋuŋ puseko gogobi. ");
INSERT INTO mlh_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Oŋu gogobiyoŋ, jibu nonji ore mobeine buŋo foriine mo iŋi ŋajibe maneniŋ: Nonji boke ŋaberu kirieru ropebemiŋ, ore foriine fukeru iŋi bobiaŋ ŋabeiŋ: Nonji roperu uje Rauine sorebe ŋoŋoreo wakiru maŋ-ŋaŋuŋgo rakaiŋ. Nonji so boke ŋaberu ropenobo ine, Rauine iŋoji ŋoŋoreo wakiiŋgo embimbiŋgana. ");
INSERT INTO mlh_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Uje Rauine iŋoji wakiru gogore fuŋne iŋi ŋaduru goiŋ: Moreŋ so agiburaŋyaŋuŋ barariŋga yareko Anutuji buŋoyaŋuŋ mitarime posikenimiŋ me maŋyaŋuŋ so kerisiebi buŋoyaŋuŋ mitariru geoine bokirie yareiŋ. Ŋiŋigoji fuŋneyaŋuŋ oŋu ŋoneru mane mukunimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Noŋ so manesiŋ nugobi ore agiburande fuŋne barariŋga yareko mane mukunimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","“Anuture kadi posiine oi mane jibugaru nonde buŋo kosa miegobi. Ore eru iŋoji nonde fuŋne barariŋgaru yaduko iŋi mane muku nunimiŋ: Nonji posiine goku Mamanere kirieru ropebe noŋ moke so ŋone nuru gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Sembene Rauine moreŋ so siŋaŋ yabeegayoŋ, Anutuji iŋore buŋo mitarime misi koru Rauine fukeiŋ. Ore so sosowo noŋunde buŋo oŋuakoŋ mitariiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nonji soine buŋo kokoine jikigaru minoboyoŋ, oi damaŋ yoo mibe fonuŋkati eru kegborenimiŋ ore egu embimbiŋganimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Oi embimbiŋganimiŋyoŋ, buŋo foriinere Rau, Moro Tiriine iŋoji wakiru maŋ-ŋaŋuŋgo rakaru buŋo saŋu qame manenimiŋ. Oi iŋoyoŋunde mande eru kosa so miku goiŋyoŋ, Anuture buŋo kaje ruaru manega, iŋoji oŋuakoŋ mieiŋ eru jiki ya fukeiŋ, oi bonieru barariŋgaru miiŋ. Ore eru iŋoji ro ŋaberu buŋo foriine sosowo ore obu joguŋineo boudu ŋaberu buŋo foriinere kadio akoŋ ode ranimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","“Iŋoji nakene rouŋgone buŋo roku mitaniŋgaru maŋ bapakare ŋaberu goiŋ. Ore eru nonde fuŋne barariŋga ŋareko nonji tinabiŋeneke fukeebemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mamanere ya sosowo ega, oi nonde meo ruame pega. Ore eru migo, ‘Iŋoji nakene rouŋgone buŋo roru mitaniŋgaru maŋ-ŋaŋuŋ bapakareru goiŋ.’ Buŋo oi oŋu.” ");
INSERT INTO mlh_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Damaŋ pompoŋine tariko ŋoŋo noŋ moke so ŋone nunimiŋ. Ore ŋadiineo damaŋ pompoŋine tariko fuke ŋarebe soine moke ŋone nunimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oŋu miko kiŋariŋpuine yoŋoreone goineji yoŋoyoŋe akoŋ iŋi mimane ebuŋ, “Buŋo iŋi miga, ‘Damaŋ pompoŋine tariko ŋoŋo noŋ so ŋone nunimiŋ. Ore ŋadiineo damaŋ pompoŋine tariko fuke ŋarebe soine moke ŋone nunimiŋ,’ eru buŋo mo iŋi miga, ‘Noŋ Mamanereo ropebemiŋ.’ Oŋu miko manegobeneŋ, buŋo yoyoka ore fuŋine oi uruŋu?” ");
INSERT INTO mlh_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Oŋu mimane eku qayaya mibuŋ, “Iŋoji ‘Damaŋ pompoŋine tariko,’ migayoŋ, buŋo ore fuŋine uruŋu? Oi wamore miga, oi so mane taniŋgagobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Oŋu miku weu tenimiŋ ore manebi Yesuji ŋone muku yaberu iŋi yajiya, “Buŋo iŋi migo, ‘Damaŋ pompoŋine tariko ŋoŋo noŋ so ŋone nunimiŋ. Ore ŋadiineo damaŋ pompoŋine tariko fuke ŋarebe soine moke ŋone nunimiŋ,’ Ŋoŋo buŋo ore fuŋine baaru mimane egobi me? ");
INSERT INTO mlh_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","“Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Nonji rabe ŋoŋo jiŋgeŋ keku kuyonimiŋ, maŋyaŋuŋ so kerisiebuŋ, yoŋoji kosa jeri kiki keku jeribari eku gonimiŋ. Ŋoŋo beusembe eku gonimiŋyoŋ, beusembeŋaŋuŋ oiji nonde eru kerisieru jeribari eku gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ŋigoji odumade rorore damaŋ ware fukeko goji kime qapeqawaki paio odumade rogayoŋ, odumade gariine roru dimaku oi ŋoneru jeriinere ore bio joiserereŋine oi niga gaega. ");
INSERT INTO mlh_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ore so ŋoŋo oŋuakoŋ damaŋ yoo beusembeke gogobiyoŋ, nonji jiki moke fukeru ŋone ŋabebe ŋoŋo soine manjerike gonimiŋ. Manjeriŋaŋuŋ oi moji mo so ŋowa roiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Damaŋ oo ya more noŋ so weu narenimiŋyoŋ, oŋgawowosiŋaŋuŋ Mamareo ruabi poretiŋ akoŋ rako afagako gonimiŋ. Nonji buŋo foriine yobu mo iŋi ŋajibe maneniŋ: Ŋoŋo nonde tinao ya more Mama oŋga wosi teku ine, iŋoji oi kisiŋga ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Noke go warebuŋ, ŋoŋo damaŋ oo ya more nonde tinao so oŋga wosiru gobuŋ. Ŋoŋo Mama oŋga wosiru goinebi. Oŋga wosibi soine bokirie ŋareiŋ. Oi ŋareme jeribariŋaŋunji fukeru saueru maŋ-ŋaŋuŋ puseko gonimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Buŋo ŋajibe maneru wareegobi, oi buŋo soweineke mibe maneru gobuŋ. Jiki damaŋ mo ware fukeiŋ, oo buŋo sosoine oi moke so miku ŋajibemiŋ. Matayoŋ, Mamanere fuŋne oi totogo mitaniŋgaru gobemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Damaŋ oo ŋoŋo nonde tina oŋgaku Mama oŋga wosiru gonimiŋ. Ore fuŋine oi iŋi: Ŋoŋo oŋgawowosiŋaŋuŋ Mamareo ruaiŋgo ore nondeo moke so wareegobiyoŋ, ŋoŋo-ŋaŋe Mamareo poretiŋ oŋga wosiru gonimiŋ. Nonji ŋoŋore mi roku Mamare so oŋga wosibemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","“Mamaji iŋoyoŋe maŋineji manjoko eŋareru oŋgawowosiŋaŋuŋ iŋi ore maneru goiŋ: Nonji Anutureone wakiboŋ, ŋoŋo nonde fuŋne oŋu manesiŋ garu damaŋ so maŋ-ŋaŋunji manjoko enareku go wapebi kadi oŋu fukeko oŋgawowosiŋaŋuŋ maneru goiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nonji Mama bokeru moreŋgo wakiru goku moreŋ bokeru moke kirieru Mamanereo ropebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Oŋu miko kiŋariŋpuineji mibuŋ, “Mane, buŋo muŋambe yo mige, oi keroriine so qaku mige. Oi totogo akoŋ minde soine mane taniŋgagobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Niŋo muŋambe fuŋnego iŋi mane mukugobeneŋ: Goji gake akoŋ ya sosowo mane tarinde moji mo weuku qaji gareiŋgo ore so embimbiŋgage. Ore eru go Anutureone wakimeŋ, niŋo oi manesiŋ gagobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Oŋu mikabuŋ Yesuji kerisieru miya, “Muŋambe soine manesiŋ nugobiyoŋ, ");
INSERT INTO mlh_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","maneniŋ, damaŋ kamasiine mo wareiŋ eru oiji mai garu mendigo dimaga. Damaŋ oiji ware fukeko ŋoŋoji kokoi maneru boke nuru roiŋgabi nakekoŋ gobemiŋ. Jibu nakekoŋ yobu so gobemiŋyoŋ, Mamaneji noke goiŋ. Mamaji noke goiŋ ore eru nakekoŋ sowo so gobemiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ŋoŋoji jikigaru moreŋgo goku sisikoŋkoŋ paio gonimiŋyoŋ, noke qakatoru womoo gonimiŋ ore maneru buŋo tatariine yo mibe manegobi. Buŋo akoŋ so migoyoŋ, nonji morende eebobo sembene oi gbiŋ eru joruine baji forebe wakiya. Ore eru kobiŋaŋuŋke jogbake goinebi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","2","Yesuji buŋo oŋu mitariru Sombuŋgo oobe pime ropeko iŋi oŋga wosiya, “Mamane, goji moreŋ so ŋiŋigo sosowo Madego nonde rurumaŋgo rua yabende usuŋ paio Ofoŋ eyarego. Ŋiŋigoji Madego nonde buŋo soine so ŋadi gaku odureru gonimiŋ. Goji ŋiŋigo botuyaŋuŋgone goine bomukuru nonde meo rua yaberu iŋi mitiga naremeŋ, ‘Go oi sosowo qaji yabende gogo sanaŋine bofukeru goinebi.’ Gio oi ba forebe Madegoji tinabiŋego mi sogueiŋgo ore kuririquraŋgo nareigoŋ. Nonde damaŋ oi muŋambe yo ware fukeme dimaku oŋu oŋga wosigo. ");
INSERT INTO mlh_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","“Gogo sanaŋinere fuŋne oi iŋi: Goji moakoŋ Anutu foriine fukege eru ŋi Yesu Kristo noŋ sore nunde wakiboŋ, ŋiŋigoji nokunde fuŋne oŋu mane mukunimiŋ. Gogo sanaŋine oŋu bofukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gio nareru ‘Baigoŋ,’ miku mitiga naremeŋ, nonji oi reŋgaru baku goku baforego. Kuririgoke goku tinabiŋego moreŋgo barariŋgaru misauebe kuririineke fukeya. ");
INSERT INTO mlh_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","“O Mama, nonji moreŋ so fukeko Sombuŋ kaeo oo gore keririŋgoo kuririquraŋke fureru goboŋ. Kuririquraŋ oi akoŋ muŋambe yo moke enarende fukeru keti nuko moke gore keririŋgoo kuririquraŋke fureru gobemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“O Mamane, goji moreŋ ŋiŋigo goine osoeru nonde meo rua yabeme, nonji gore tinabiŋe oi yoŋo barariŋgaru yaduru goboŋ. Yoŋoji gore biŋe fukebi goji oi nonde meo rua yabende yoŋoji gore Biŋe buŋo oi maneru sabareru gogobi. ");
INSERT INTO mlh_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Goji ya naremeŋ, oi sosowo goreone wareega, yoŋoji oi damaŋ yoo mane mukugobi. ");
INSERT INTO mlh_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Goji buŋo Biŋe naremeŋ, nonji oi kiŋariŋpune qaji yarebe maneru sabareku gogobi. Noŋ boke guru moreŋgo wakiboŋ, yoŋoji oi fofori mane mukugobi. Goji sore nunde fukeboŋ, yoŋoji oi oŋuakoŋ manesiŋ gagobi. ");
INSERT INTO mlh_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Noŋ yoŋore eru oŋga wosi garego. Maŋkekerisiere ŋiŋigo mutuine yoŋore so oŋga wosigoyoŋ, kufufuŋ nonde meo rua yabende maŋyaŋuŋ kerisieru gore biŋe fukegobi, yoŋore eru oŋga wosi garego. ");
INSERT INTO mlh_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ŋiŋigo sosowo nonde biŋe fukegobi, yoŋoji gore biŋe fukegobi eru ŋiŋigo gore biŋe fukegobi, yoŋoji nonde biŋe oŋuakoŋ fukegobi. Nakene kuririquraŋ rua yarebe ore paio dimaku eeboboyaŋuŋ ebi nonde tinabiŋeji sogueru saueeiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Noŋ moreŋgo gogone tariko goreo wapebemiŋ ore egoyoŋ, yoŋoji jikigaru moreŋgo gonimiŋ. O Mama Tiriine, goji tinago narende ore usuŋineji sa kipe yabende so pouganimiŋ. Nokuŋ moakoŋ fukeru gogobere, yoŋoji ore so moakoŋ fukeru gonimiŋ ore oŋga wosigo. ");
INSERT INTO mlh_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“Nonji yoŋoke moreŋgo go wapeboŋ, damaŋ oo tinabiŋego narende oiji sa kipe yaberu goboŋ. Biŋe Qurande buŋo moji foriineke fukeiŋ ore pega moakonji jibugaru misi korure biŋe fukeru joiserereŋ maneru goiŋ. Nonji siŋaŋ yabeboŋ ore yoŋoreone goineji so tiŋtuŋ eru jibugabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Goineji so jibugabuŋyoŋ, nonji muŋambe yo moreŋgo goku goreo wareiŋgo ore wareru buŋo yo migo: Nonde maŋ jeriji yoŋoreo petigako robi maŋyaŋuŋ puseko jerieru gonimiŋ. Oŋu fukeiŋgo ore oŋga wosigo. ");
INSERT INTO mlh_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nonji gore Biŋe buŋo qaji yarebe maneru gogobi. Nonji morende eebobo sembene oi so boyobeego, yoŋoji oŋuakoŋ oi so boyoberu ŋadi gaegobi. Ore eru moreŋgo maŋyaŋuŋ so kerisiebuŋ, yoŋoji rosi eŋareegobi. ");
INSERT INTO mlh_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Nonji moreŋgone oga yabebemiŋ ore so weu garegoyoŋ, Sembene Rauineone sabareku sa kipe yaberu gomiŋ ore oŋga wosigo. ");
INSERT INTO mlh_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nonji morende eebobo sembene ŋadi gaku oi so boyobe yoŋoji oŋuakoŋ oi ŋadi gaku so boyobeegobi. ");
INSERT INTO mlh_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Buŋo foriine oiji bagbagbaga yabeme gonimiŋ. Gore Biŋe buŋoji buŋo foriine yobu fukega. ");
INSERT INTO mlh_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Goji sore nunde moreŋ ŋiŋigo botuyaŋuŋgo wakiru gio ba gobe, nonji oŋuakoŋ oi sore yabebe moreŋ ŋiŋigo yoŋore botugo roiŋgaru ranimiŋ. ");
INSERT INTO mlh_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","O Mamane, yoŋoji buŋo foriinere so gogoyaŋuŋ sosowo use garenimiŋ ore eru bapi yaberu nakene gogo sosowo kisiŋga garego.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“O Mamane, nonji kiŋariŋpune yoŋore akoŋ eru so oŋga wosigoyoŋ, Biŋe buŋo misauebi ŋiŋigo manesiŋ nunimiŋ, yoŋore eru oŋuakoŋ oŋga wosigo. ");
INSERT INTO mlh_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mama goji noke qakatoru dimande nonji oŋuakoŋ goke qakatoru dimago. Ore so yoŋoji oŋuakoŋ nikoke qakatoru dimanimiŋ ore ‘manego. Gake sore nunde wakiboŋ, moreŋ ŋiŋigoji oi manesiŋ ganimiŋ ore eru yoŋoji sosowo moakoŋ fukeru gonimiŋ ore oŋga wosigo. ");
INSERT INTO mlh_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Niko moakoŋ fukeru gogobere, yoŋoji oŋuakoŋ moakoŋ fukeru gonimiŋ ore eru kuririgo rua naremiŋ, nonji oi yoŋore eru yare foreboŋ. ");
INSERT INTO mlh_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","“Nonji yoŋoke qakatoru dimabe goji noke qakatoru dimage. Ore so yoŋoji buŋoyaŋuŋ miku kikipe eru moakoŋ fukeru gonimiŋ ore oŋga wosigo. Moakoŋ fukeru dimabi moreŋ ŋiŋigoji fuŋnene iŋi mane taniŋganimiŋ: Goji manjoko enareku gomeŋ, ore so oi oŋuakoŋ manjoko eyareru goku noŋ sore nunde wakiboŋ. ");
INSERT INTO mlh_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O Mamane, goji moreŋ so bofukemeŋ, ronekoŋ damaŋ oo maŋgoji manjoko enareku kuririquraŋ enarende go wapeboŋ. Jiki ogopune naremeŋ, nonji yoŋo oŋuakoŋ kuririquraŋ oi ŋonenimiŋ ore manego. Ore eru nonji kae gobemiŋ, yoŋoji oo noke moko goniminde aŋi manego. ");
INSERT INTO mlh_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“O Mama posiine, moreŋ ŋiŋigo maŋyaŋuŋ so kerisiebuŋ, yoŋoji go so mane muku guru go wapebuŋyoŋ, nonji go soine akoŋ mane muku gugo. Gake sore numeŋ, nonde maŋkekerisie ogopuji oi mane foregobi. ");
INSERT INTO mlh_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nonji gore tina oi mitaniŋga yarebe maneru gobuŋ. Goji maŋgoji manjoko enareku gomeŋ, manjoko oiji maŋyaŋuŋgo peko manebi nonji yoŋoke qakatoru dimabe gonimiŋ ore jikigaru tinago mitaniŋga yareru gobemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuji buŋo oi miforeru kiŋariŋpuine oga yabeme siti bokeru rakaru obu tinaine Kidron petigaru aribe roperu kaesesu mo peya, oo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesu eru iŋore kiŋariŋpu yoŋoji jijiki oo tumaŋgaru gobuŋ. Ore eru Judas babae bateiŋgo eya, iŋoji oŋuakoŋ kaesesu oi soine maneya. ");
INSERT INTO mlh_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Soriŋ gio siŋaŋ eru Farisi (Kadi buŋore yameŋyameŋ) yoŋoji boji sorinde sa siŋaŋ (sikiriti) goine sore yabebi Judasji oi eru gawmande mamari ŋi kubu mo oga yabeme moko warebuŋ. Yoŋoji doi lambe eru tebe damuyaŋuŋ baru wareru kaesesugo wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Wapebi Yesuji ya sosowo oŋu fuke teiŋ, oi soine maneya ore eru pakereru totogo wareru iŋi weu yareya, “Ŋoŋo more baagobi?” ");
INSERT INTO mlh_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Weu yareme iŋi bokiriebuŋ, “Niŋo Yesu Nazaret rauine baagobeneŋ.” Bokiriebi iŋi yajiya, “Noŋ oi yo.” Judas babae bobo ŋi iŋoji oŋuakoŋ yoŋoke dimaya. ");
INSERT INTO mlh_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Noŋ oi yo.” Yesuji buŋo oŋu yajime ŋaŋadi raku moreŋgo rinduŋgaru waki yabeko. ");
INSERT INTO mlh_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Oŋu ebi moke weu yareya, “Ŋoŋo more baagobi?” Weu yareme mibuŋ, “Niŋo Yesu Nazaret rauine baagobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Oŋu mibi bokirieya, “Noŋ oi yo, ŋajibe manegobi. Ŋoŋo noŋ baa nugobi ine, ŋi yo soine boke yabebi ranimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Rone oŋga wosiru kiŋariŋpuine yoŋore buŋo mo iŋi yajiya, “Ŋiŋigo nonde meo rua yabende gogobi, nonji oi maŋgo eyareko gobe yoŋoreone moji mo so jibugaya.” Buŋo oiji foriineke fukeiŋ ore Yesuji minebobopuine yoŋore buŋo oŋu miya. ");
INSERT INTO mlh_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Oŋu miko Saimon Pitaji jigore siqo sogo baru goya, iŋoji oi goyoŋineone poreru soriŋ gio siŋaŋ qoruinere kiŋaŋ ŋi qaku kajeine furoine obe kemukume wakiya. Kiŋaŋqoqo ŋi oi tinaine Malkus. ");
INSERT INTO mlh_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Oŋu eko Yesuji Pita iŋi mitiga teya, “Go jigore siqo sogo oi moke ruande goyoŋgoo rakaine. Mamaneji joisererende popu obu dugborogboroke nonde biŋe qaya, oi soine maneru karieru mai gabemiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mamari siŋaŋyaŋunji miko mamari ŋi kubu eru Juda yoŋore mendi siŋaŋ (sikiriti) yoŋoji Yesu roru kipebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kipebi roru rone soriŋ gio siŋaŋ tinaine Anas iŋore pigo rabuŋ. Anasre kimo tinaine Kaiafas iŋoji soriŋ gio siŋaŋ qoruine fukeru gosa oo gio oi baku goya. ");
INSERT INTO mlh_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafasji rone Juda ŋiŋigo yoŋore uŋsowoŋ buŋo iŋi miya, “Ŋiŋigo kubu sosowo egu jibuga forenimiŋ ore ŋi moakonji niŋore eru komeko sagaiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yesu roru rabi Saimon Pita eru kiŋariŋ ogoine mo yokoji ŋadiyaŋuŋgo rabu. Raku ogoine oiji soriŋ gio siŋaŋ qoruine maneya ore eru soine afaine Yesu boyoberu morumboŋ pi sa maŋineo rakaya. ");
INSERT INTO mlh_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Iŋoji rakayayoŋ, Pitaji sa sakibe mendigo dimaya. Oŋu dimako kiŋariŋ ogoineji soriŋ gio siŋaŋ qoruine maneya, iŋoji sakibe rakaru mendi siŋaŋ ŋigo iŋoke buŋo ojime mendi rome Pita ogagaru sa maŋineo rakabu. ");
INSERT INTO mlh_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Rakaiŋgo ebire oo kiŋaŋqoqo ŋigo sa mendiine siŋaŋ gaya, iŋoji Pita ŋoneru iŋi weu teya, “Go fofori oŋuakoŋ ŋi iŋore kiŋariŋ yoŋoreone mo fukege me?” Oŋu weu teme maneru “Noŋ mata!” miya. ");
INSERT INTO mlh_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kiŋaŋ ŋi eru mendi siŋaŋ (sikiriti) yoŋoji munaŋinere eru misi ruabi jaku uerereŋ eko furaku dimabuŋ. Oŋu dimabi Pitaji oŋuakoŋ yoŋore botugo raru misi furaku dimaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Soriŋ gio siŋaŋ qoruine Anas iŋoji Yesu weu teru iŋi miya, “Go ŋiŋigo uruŋu qaji yareru kiŋariŋpugo mo mo oga yaperu goege?” ");
INSERT INTO mlh_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Oŋu miko iŋi bokirie teya, “Noŋ damaŋ so totogo ŋiŋigoine ŋiŋigoine qaji yareru goboŋ. Juda kufufuŋ sosowo niŋoji boji soriŋgo roperu oŋgawowosi pinoŋuŋ so tumaŋgaegobeneŋ, noŋ oo dimaku qaji yareru goboŋ. Biŋe buŋo soŋsoŋine mo so miboŋ. ");
INSERT INTO mlh_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nonji buŋo uruŋu ŋiŋigo qaji yareru gobe, wamore noŋ ore so weu narege? Nonji buŋo mikabe ŋiŋigo maneru gobuŋ, yoŋoji buŋonere koruŋ mane foregobi. Ore eru oi weu yarende sagaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Oŋu kerisie teyayoŋ, sorinde sa siŋaŋ (sikiriti) moji bembeŋgo dimaku Yesu mauineo qotimberu miya, “Soriŋ gio siŋaŋ qoruineji weu gareko go buŋo mosiine oŋuine wamore kerisie tege? Arambobogo tomiri.” ");
INSERT INTO mlh_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Oŋu miko iŋi bokirie teya, “Buŋo sembene minobo, oi nodunde sagaiŋyoŋ, buŋo foriine migo ine, wamore noŋ mo nuge?” ");
INSERT INTO mlh_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Oŋu bokirie teko Anasji Yesu soreru miko kipeine oŋuakoŋ meineo ŋeko ogaru soriŋ gio siŋaŋ qoruine Kaiafas iŋoreo rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pitaji misi furaku dimako goineji weuku iŋi ojibuŋ, “Go fofori oŋuakoŋ iŋore kiŋariŋpu yoŋoreone mo fukege me mata?” Oŋu ojikabi mugaru “Noŋ mata!” miya. ");
INSERT INTO mlh_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pitaji soriŋ gio siŋaŋ qoruinere kiŋaŋ ŋi qaku kajeine kemukuko wakiya, iŋore tife kiŋaŋqoqo ogoine moji oi maneru weuku ojiya, “O goji kaesesugo iŋoke moko gokabire ŋone gube me uruŋu?” ");
INSERT INTO mlh_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Oŋu ojime Pitaji moke mugako damaŋ oo akoŋ qoquji fuŋgaru oŋgako maneya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kae fufurere akoŋ Yesu Kaiafasre pigone ogaru wakiru Rom gawanare morumboŋ pigo rabuŋ. Juda yoŋoji maŋyaŋuŋ kejigaru bapeboriŋ egu fukekimiŋ ore manemeja maneru iŋi mibuŋ, “Ŋonemaiŋ kombande lama noiŋgo ore egu embimbiŋgakimiŋ.” Oŋu miku maneru yobiŋgaru gawanare morumboŋ pi maŋgo so ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ore eru gawana Pailotji sakibe wakiru ŋone yaberu iŋi weu yareya, “Ŋi yo iŋoji wamo baka bako buŋo miteku roru waregobi?” ");
INSERT INTO mlh_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Weu yareme bokiriebuŋ, “Ŋi oiji suroŋqoqo me sembene bobo ŋi mo so fukena ine, niŋoji mo yobu oi ogaru goreo so warenobeŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Oŋu bokiriebi Pailotji yajiya, “Ŋoŋo ŋoŋo-ŋaŋe buŋo koroineo ruame Kadi buŋoŋaŋunde so osoeru buŋoine mitariniŋ.” Oŋu yajiko maneru ojibuŋ, “Niŋoji ŋi mo komeinde buŋo mitarikimiŋ ore agi peko embimbiŋgagobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Juda yoŋoji oŋu ojibi Yesu iŋoyoŋe kome uruŋure komeinde buŋo oi barariŋgaru miya, oŋuine oiji foriineke fukeya. ");
INSERT INTO mlh_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailotji Juda yoŋore buŋo maneru moke morumboŋ pi maŋineo roperu Yesu oŋga teme wareme iŋi weu teya, “Go Juda yoŋore kiŋ koito fukege me mata?” ");
INSERT INTO mlh_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Oŋu weu teme kerisieru iŋi weuya, “Buŋo oi gakere maŋgoone mige me goineji nonde buŋo oŋu miku migoo ruabi mige?” ");
INSERT INTO mlh_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Oŋu weume Pailotji bokirieya, “Yei! Noŋ Juda ŋi fukeru Juda yoŋore buŋo kitiŋgaego me? Mata yobu! Noŋ Rom gawana gobe gakere ŋiŋigopugo eru soriŋ gio siŋaŋ yoŋoji oga guru wareru nonde meo rua gogobi. Goji wamo ya ege?” ");
INSERT INTO mlh_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Oŋu bokirieme miya, “Nonde qorumande fuŋne oi moreŋ yoo so pega. Nonji morende kiŋ-sa more kiŋ koito fukenobo ine, nonde osigidapuji soine pakereru nonde eru jigo qanobuŋ. Jigo qaku nonji Juda minebobo yoŋore meo egu rakabemiŋ ore yameŋ keku jigo qabi oga nuiŋgo embimbiŋganobuŋ. Oi embimbiŋganobuŋyoŋ, nonde morumbonde fuŋne oi kae mogo pega. Noŋ moreŋ ŋi koito so fukego.” ");
INSERT INTO mlh_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Buŋo oi miko Yesu iŋi weu teya, “Go jibu ŋi ofoŋ fuŋ mo fukege, oi foriine me mata?” Oŋu weu teme bokirieya, “Noŋ ŋi ofoŋ fuŋ mo fukego, oi gake mige. Nonji buŋo foriine kitiŋgaku mitaniŋgabemiŋ ore eru moreŋgo wakiru fukeboŋ. Sosowo yoŋoji buŋo foriinere mobeo gogobi, yoŋoji nonde buŋo kaje ruaru maneegobi.” ");
INSERT INTO mlh_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Oŋu bokirieme Pailotji igosisi eteru weuya, “Buŋo foriine oi uruŋu?” Oŋu weu teru moke Juda yoŋoreo rakaru korogo dimaku iŋi yajiya, “Nonji ŋi iŋore baka baaru mo so bofukego. ");
INSERT INTO mlh_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mo so bofukegoyoŋ, nonde eebobo mo iŋi peko manegobi: Gosa so ŋonemaiŋ kombaŋ damaŋgo witi pigone ŋi moakoŋ ŋoŋore piruebe wakiega, oi manegobi. Ore eru Juda ŋoŋore kiŋ koito soine ŋoŋore piruebe wakiiŋ me mata? Ore eru ŋoŋo aŋiŋaŋunji uruŋu manegobi?” ");
INSERT INTO mlh_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Oŋu yajime bokirieru iŋi oŋgabuŋ, “Mata, oi matayoŋ, Barabas piruende niŋoreo wakiiŋ!” Oŋu oŋgabuŋyoŋ, Barabas iŋoji suroŋqoqo ŋi fukeru jigo oyowo mo qabuŋ, ore qoru fukeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jojoraku oŋgabi Pailotji Yesu roru raru miko mamari ŋi yoŋoji ŋoŋoru joruinekeji qotiboti qabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mamari ŋi yoŋoji qotibotigaru igosisi iŋi etebuŋ: yoŋoji Yesu qaku nigiŋ joruineke roru puteru hendiŋ bobiaŋgaru qoruineo ketebi rakame mariku boboroŋ yojuŋiruke oi ketebi rakaya. ");
INSERT INTO mlh_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Oŋu eru bembeŋgo burugaru dimaku mibuŋ, “Ohowe ohowe! Juda yoŋore Kiŋ Koito, ohowe!” Oŋu miku mauineo kokoine qabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Oŋu igosisi etebuŋ Pailotji moke sakibe rakaru iŋi yajiya, “Maneniŋ! Nonji ŋi oi osoeru bakaine mo so bofukego. Ore eru oi moke roru ŋoŋore jiŋoo wakibe fuŋine oŋu mane mukuru ŋonenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Oŋu yajime Yesuji wakiru korogo dimako iŋi ŋonebuŋ: Goineji nigiŋ joruinekeji hendiŋ kiperu qoruineo keku mariku boboroŋ yojuŋiruineke ketebi dimako Pailotji iŋi yajiya, “Ŋoŋo ŋi foriine yo ŋoneniŋ!” ");
INSERT INTO mlh_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Oŋu yajime soriŋ gio siŋaŋ eru mendi siŋaŋ (sikiriti) yoŋo oi ŋoneru buŋo fofoineke oŋgaku mibuŋ, “Maripoŋgo qabi komenoŋ. Maripoŋgo qabi komenoŋ.” Oŋu mikabi Pailotji miyaŋuŋgo roku iŋi yajiya, “Nonji bakaine mo so bofukego. Ore eru ŋoŋo ŋoŋo-ŋaŋe akoŋ oi roru maripoŋgo qabi komena.” ");
INSERT INTO mlh_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Juda minebobo yoŋoji buŋo oi maneru yameŋ keku iŋi mibuŋ, “Niŋore Kadi buŋo pega. Buŋo ore so osoebeneŋ komeiŋ ore so fukega. Iŋoyoŋe mojiine ba ropeku ‘Anuture made fukego,’ miega. Ore eru komere biŋe fukeko sagaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Oŋu yameŋ keku mikabi Pailotji maneru moji sikiine pakereko gburugburu qame kokoi maneya. ");
INSERT INTO mlh_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Oŋu maneru Yesu roru moke morumboŋ pi maŋineo roperu iŋi weu teya, “Go urone?” Weu teyayoŋ, iŋoji mobeine mo so bokirieru buŋoine mataeme dimaya. ");
INSERT INTO mlh_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Buŋoine mataeme dimako iŋi ojiya, “Go nonde buŋo mobe mo bokiriemiŋ me mata? Nonji mitaribe pirue gunimiŋ me maripoŋgo gubi komemiŋ. Ore usuŋine oi nonde pega. Ore fuŋine manege me mata?” ");
INSERT INTO mlh_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Oŋu miko maneru iŋi bokirie teya, “Moji paibene usuŋ so egareya ine, go ŋi omaine goku ya enareiŋgo ore embimbiŋganoŋ. Ore eru ŋi mo moji noŋ gore meo rua nuga, iŋore agiburanji gore baka odureru soguine fukega.” ");
INSERT INTO mlh_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Oŋu bokirie teya ore eru Pailotji Yesu pirueko wakiiŋ ore yameŋ keko. Oŋu yameŋ keyayoŋ, Juda yoŋoji oŋga jojoraru iŋi mibuŋ, “Piruende wakiiŋ ine, Sisa-kiŋ koitore ogo so jikigaru fukeru gomiŋ. Moji nakenere maneme ropeko ‘Kiŋ ofoŋ fukego’ miga, iŋoji Sisa-kiŋ kiso etega.” ");
INSERT INTO mlh_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Oŋu mibi buŋo oi maneru mitigako Yesu roru sakibe wakibuŋ. Wakibi gawana Pailotji koro mo koji baru ramegabi peya, oo roperu buŋo mimitarire ŋeŋeo wakiru ŋeya. Koro ore tinaine Hibru buŋoo Gabata miku gobuŋ. Oi noŋunde buŋoo Koro koji ba rumagakiine. ");
INSERT INTO mlh_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Wakiru ŋeya, Juda ŋiŋigoji una oo ŋonemaiŋ kombaŋ ŋeiŋ ore jauebuŋ. Una oi fukeko una botuine bombeŋgako Pailotji ŋeŋeineo ŋeku Juda yoŋore iŋi yajiya, “Ŋoneniŋ, ŋoŋore kiŋ koito yo!” ");
INSERT INTO mlh_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Oŋu miko maneru oŋga jojorabuŋ, “Mataeiŋ! Mataeiŋ! Maripoŋgo qabi komenoŋ!” Oŋga jojorakabi iŋi miya, “Ŋoŋore kiŋ koitore buŋo mitaribe maripoŋgo ropeiŋ ore migobi me?” Oŋu miko soriŋ gio siŋaŋ yoŋoji kerisieru mibuŋ, “Sisa-kinji moakoŋ kiŋ koitonoŋuŋ fukega. Niŋore ŋi koito furuine mo so ŋega.” ");
INSERT INTO mlh_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Oŋu kerisieru mibi Pailotji Yesure buŋo mitariru maripoŋgo qabi komeiŋ ore meyaŋuŋgo ruaya. Meyaŋuŋgo ruame mamari ŋi yoŋoji Yesu roru siŋaŋ gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Siŋaŋ gabi iŋoyoŋunde maripoŋ iŋoyoŋe koboru siti petigaru sakibe rakaru moreŋ mo tinaine Qorusia miegobi, oo rabuŋ. Qorusia tina oi Hibru buŋoo Golgota miegobi. ");
INSERT INTO mlh_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Oo raru maripoŋgo qabuŋ eru iŋoke ŋi yoyoka mobemobe moko yaperu Yesu botuyakuŋgo ruabi dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Oŋu qabi Pailotji quraŋ quraŋgaru miko maripoŋgo Yesure qorugo paibe ruaru qabuŋ. Quraŋ oi iŋi quraŋgako dimaya, “Yesu Nazaret rauine, Juda yoŋore kiŋ koito yo.” ");
INSERT INTO mlh_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesu maripoŋgo qabuŋ, moreŋ oi siti bembeŋgo peko eru quraŋ oi buŋo yokaomo, Hibru, Latin eru Grik buŋoo quraŋgame dimaya. Ore eru Juda ŋiŋigo kokoineji odureru roware eru paibe piku quraŋ oi osebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Oŋu quraŋgako Juda yoŋore soriŋ gio siŋaŋ yoŋoji Pailot iŋi ojibuŋ, “‘Juda yoŋore kiŋ koito yo,’ oŋu so quraŋgayoŋ, iŋi quraŋga, ‘Iŋoyoŋunde Juda kiŋ Koitoyaŋuŋ ego, miya.’” ");
INSERT INTO mlh_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Oi maneru Pailotji buŋo iŋi bokirieya, “Buŋo quraŋga forego ore oi oŋu peine.” ");
INSERT INTO mlh_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mamari ŋi yoŋoji Yesu maripoŋgo qaki kambaŋ sakikomoŋ yareyaine roru ŋi 4 botuyaŋuŋgo boroiŋgaru 4 fukeko soyaŋuŋgo robuŋ. Oŋu robi marikuine peko robuŋyoŋ, oi iŋi ore soine so boroiŋgabuŋ: Oi sosowo akoŋ kambaŋ mobeine moakonji bakine. Kambaŋ mobeine mobeine so qodureru paibene rorerore gboduru babi yuku rarakaine peya. Ore eru oi egu sembeaiŋ ore boroiŋganimiŋgo embimbiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Embimbiŋgaru mimane eku iŋi mibuŋ, “Oi ketigabeneŋ so sagaiŋ. Ore eru soine ore qouŋ qabeneŋ rauine fukeiŋ.” Oŋu miku qouŋ qabi Biŋe buŋo mo foriineke fukeya. Buŋo oi iŋi quraŋgame pega, “Yoŋoji kambaŋ sakikomoŋne roru botuyaŋuŋgo boroiŋgaru soyaŋuŋgo roru marikunere qouŋ masiri ebi moji gbiŋ eiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu maripoŋgo qabi dimako ŋigo yo iŋiji kufuineo dimabuŋ: Yesure maŋgo, maŋgo gboine eru Klopasre ŋonuŋ tinaine Maria eru Maria Magdalane. ");
INSERT INTO mlh_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesuji maŋgoine eru yoro kiŋariŋine bembeŋgo dimabire ŋone yaperu maŋgoinere iŋi miya, “Maŋgone, go madego yo ŋoneru siŋaŋ gaku getireru goigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Oŋu miku kiŋariŋ oi iŋi ojiya, “Go maŋgogo yo ŋoneru siŋaŋ gaku getireru goigoŋ.” Oŋu miko maneru Yesure maŋgo damaŋ oo akoŋ ogame piineo raru moko gobu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesuji gioine sosowo baforeya, oi maneru oo Biŋe Qurande buŋo moji foriineke fukeiŋ ore iŋi miya, “Noŋ obure manego.” ");
INSERT INTO mlh_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Oo gonja mo wain obu jajaineke oiji puseru ŋeya. Oi ŋeko koe yaŋgbuŋ mo yaga kamasi oŋu oi roru wain obuo igokurugaru supesupe tifeine qondeŋgaru ruabi ropeko bibiineo ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ruabi wain obu jajaineke oi noku miya, “Oi tariga.” Oŋu miku gogoine bokeiŋgo ore ubeine kasigaru wakiko qoqotiine wapeko niniŋgaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yesuji niniŋgame Juda ŋiŋigoji una oo ŋonemaiŋ kombaŋ ŋeiŋ ore jauebuŋ. Ŋonemaiŋ Sabat kombaŋ oi kombaŋ damaŋ yasogo fukeya. Ore eru Juda minebobo yoŋo manemeja maneru iŋi mibuŋ, “Qoŋgbuŋ yoŋoji Sabat kombaŋ damaŋgo maripoŋgo dimakabi so sagaga.” Oŋu miku gawana Pailotreo raru iŋi weu tebuŋ, “Go soine mitarinde raru maripoŋgo yabebi, yoŋore qu sia qajibi qoŋgbuŋyaŋuŋ bomukubeneŋ wakinimiŋ?” ");
INSERT INTO mlh_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Weu tebi mitarime mamari ŋiji wapebuŋ. Waperu Yesuke maripoŋgo yapebuŋ, oi pipa komenimi ore rone yokoreone more qu sia qajiru aribe raru moreo oŋuakoŋ ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Oŋu ebuŋyoŋ, Yesureo waperu ŋonebi komeya. Oŋu ŋoneru siaine so qajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","So qajibuŋyoŋ, mamari ŋi yoŋoreone moji damu roru tambaraŋine qosuko oo akoŋ dari eru obu wakiya. ");
INSERT INTO mlh_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Oŋu ekabi moji ya oi jiŋoineji ŋoneya, iŋoji oi kitiŋgaku miku yo quraŋgame peko muŋambe yo osegobi. Buŋo kitiŋgaku miku quraŋgame pega, oi buŋo foriine fukega. Ŋoŋo oŋuakoŋ oi manesiŋ ganiminde maneru buŋo foriine manega ore so miga. ");
INSERT INTO mlh_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ya oi fukeya, oi Biŋe Qurande buŋo moji foriineke fukeiŋ ore fukeya. Buŋo oi iŋi, “Iŋore sia so qajiinebi.” ");
INSERT INTO mlh_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Eme Biŋe Qurande buŋo mo iŋi pega, “Ŋi igomuruŋgabuŋ, yoŋoji iŋore obe jiŋoyaŋuŋ piku ŋonenimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ore ŋadiineo Arimatia taoŋ rauine tinaine Josef wareya. Iŋoji Yesure kiŋariŋ fukeru goyayoŋ, Juda minebobo yoŋore eru kokoi maneru mamanesiŋine kesoŋgaru goya. Iŋoji wareru gawana Pailotreo raru Yesure qoŋgbuŋ bomukuiŋgo weu teya. Weu teme maneru mitarime wareru bomukuya. ");
INSERT INTO mlh_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ŋi tinaine Nikodemus rone Yesureo ubuo wareya, iŋoji oŋuakoŋ wareya. Wareru qoŋgbuŋ rauteiŋ ore jiji kouineke tinaine mor oi repa obuineke kerisiebuŋ, oi komoŋ mo yobiŋine 30 kilogram ore so furiine baru wareru Josef bapi gaya. ");
INSERT INTO mlh_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bapi garu moko Yesure qoŋgbuŋ bomukubu. Bomukuru juŋ jinaŋ kouine fiine roru qoŋgbuŋ sakiineo ruaru kambaŋ yagaŋine oiji foforibu. Juda ŋiŋigo niŋoji qoŋgbuŋnoŋuŋ oŋu eru bomogaru yaŋga yabe eegobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu maripoŋgo qabuŋ, moreŋ ore mobeineo kaesesu mo peya. Kaesesu oiji jiŋorunde ko kouŋ gariine mo gufubi dimaya. Oo qoŋgbuŋ mo so ruabi taine peya. ");
INSERT INTO mlh_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Taine fukeru bembeŋgo peko Juda ŋiŋigoji ŋonemaiŋ kombaŋ ŋeiŋ ore jauebi damaŋyaŋuŋ qondiŋgaya. Ore eru Yesure qoŋgbuŋ roru oo ruaru yoŋga yabe ebu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sabat kombaŋ ŋebi tariko Maria Magdala ŋigo iŋoji Sonda kae fufurere akoŋ wegi jiriŋ sineko jiŋoruŋgo raya. Raru jiŋoine pime rako ko soguine ŋoneko oiji kouŋ gugufuine ore siroŋgone igogabi wareru peya. ");
INSERT INTO mlh_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Oŋu ŋoneru oo akoŋ bokeru pipa raru Saimon Pita eru Yesure wombuŋ kiŋariŋ yokoreo wareru iŋi yasiya, “Ofonde qoŋgbuŋ jiŋoruŋgone roru raru uro ruabi pega, oi so manegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Oŋu yasime bokeru jiŋoruŋgo rabu. ");
INSERT INTO mlh_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Moko giniŋgaru rabuyoŋ, kiŋariŋ ogoineji giniŋgaru raru Pita odureru rone jiŋoruŋgo ropeya. ");
INSERT INTO mlh_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Roperu ko kouŋ gugufuine ore maŋineo so roperu siroŋgo omaine tiŋtiŋneku pime rako kambaŋine peperiŋgabuŋ, oi akoŋ peko ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Oi ŋoneme Saimon Pitaji oŋuakoŋ ŋadiineo waperu ko kouŋ maŋineo roperu kambaŋine peperiŋgabuŋ, oi akoŋ peko ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Oi ŋoneko eru qoruine kambaŋ mobeine moji peperiŋgaru komoŋ gabuŋ, oi goineji qajiru sakire kambaŋ oke so qodureru buine ruabi ŋeko ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Oŋu ŋoneme kiŋariŋ ogoineji rone jiŋoruŋgo wapeya, iŋoji oŋuakoŋ ko kouŋ maŋineo roperu ya oi ŋoneru manesiŋ gaya. ");
INSERT INTO mlh_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yesu gboreru komegone pakereiŋ, yokoji Biŋe Qurande buŋo oŋuine oi rone so mane taniŋgaru koŋkoŋ go wapebu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ŋe waperu oo akoŋ manesiŋ garu kirieru piyakuŋgo rabu. ");
INSERT INTO mlh_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Yokoji rabuyoŋ, Mariaji iŋoyoŋe akoŋ jiŋoruŋde ko kouŋ siroŋgo dimaku kuyoya. Oŋu kuyoku kouŋ gugufuine ore maŋineo tiŋtiŋneku pime raya. ");
INSERT INTO mlh_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Pime rako Sombuŋ mimerereŋ yoyoka marikuyakuŋ gbagbataeŋine ŋone yapeya. Yokoji Yesure qoŋgbuŋ peya, oo ŋebu. Moji qoruine peya, oo ŋeko moji kufuineo ŋeya. ");
INSERT INTO mlh_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Oŋu ŋeku iŋi ojibu, “Ŋigo, go wamore kuyoge?” Ojibire maneru miya, “Ofoŋnere qoŋgbuŋ roru raru uro ruabi pega, oi so manego.” ");
INSERT INTO mlh_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Oŋu miku kirieru Yesuji bembeŋgo dimako ŋoneyayoŋ, kamasiine oi so ŋone mukuru koŋkoŋ qaru dimaya. ");
INSERT INTO mlh_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Koŋkoŋ qaru dimako Yesuji iŋi weu teya, “Ŋigo, go wamore kuyoge? More baage?” Oŋu weu teme kaesesu siŋaŋineji dimaga me uruŋu, oŋuine manesuku iŋi ojiya, “O sogunene, go qoŋgbuŋine roru koboru mogo raru ruage ine, bio najinde raru robemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Oŋu ojime Yesuji tinaine oŋgaku “Maria!” miya. Oi oŋgaku miko iŋoreo kirieru Hibru buŋoo oŋgaku “Raboni!” miya. Oi noŋunde buŋoo “Qaqajine!” ");
INSERT INTO mlh_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Oŋu miko iŋi ojiya, “Noŋ Mamanereo so roperu yo dimago. Ore eru noŋ so keuwa nuyoŋ, nonde gbopu yoŋoreo raru biŋe iŋi yajiigoŋ: Nonji Mamane Anutu eru ŋoŋore Mama Anutureo kirieru ropebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Oŋu ojime Magdalane ŋigo Maria iŋoji kirieru raru kiŋariŋpuine iŋi yajiya, “Nonji Ofoŋ ŋonebe buŋo oŋu oŋu najiga.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sonda oo akoŋ ubu eko kiŋariŋ yoŋo joŋiŋgo tumaŋgaru Juda yoŋore kokoi maneru pi mendiine keku ki baku ŋebuŋ. Oŋu ŋebi Yesuji fukeru botuyaŋuŋgo dimaku iŋi yajiya, “Ogopune, womo ŋoŋoke peine!” ");
INSERT INTO mlh_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Oŋu miku meyokaine eru tambaraŋine yaduko ŋoneru jeriji maŋyaŋuŋ puseya. ");
INSERT INTO mlh_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Puseko moke iŋi yajiya, “Ogopune, womo ŋoŋoke peine! Mamaji noŋ sore nume oŋuakoŋ nonji ŋoŋo sore ŋabego.” ");
INSERT INTO mlh_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Oŋu miku bibi robuŋine pineku miya, “Ŋoŋo Moro Tiriine roniŋ. ");
INSERT INTO mlh_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ŋoŋo ŋiŋigo agiburaŋyaŋuŋ bokenimiŋ ine, oi Anuture jiŋoo posike foreiŋ. Ŋiŋigo agiburaŋyaŋuŋ so bokenimiŋ ine, oi Anuture jiŋoo so posikenimiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesuji kiŋariŋpuine oŋu fuke yareyayoŋ, kiŋariŋ 12 yoŋoreone mo tinaine Tomas, tinaine mo Didimus mibuŋ, iŋoji damaŋ oo botuyaŋuŋgo so goya. ");
INSERT INTO mlh_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomasji wareko kiŋariŋ goineji “Niŋo Ofoŋ ŋonegobeneŋ,” mibi maneru iŋi miya, “Jiŋoneji biriŋ ropuine meineo ŋoneru me sisineji tambaraŋineo bouabemiŋ ine, oi soine manesiŋ gabemiŋ. Noŋ nake oi so bouabemiŋ ine, buŋo akoŋ najibi oi so manesiŋ gabemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Oŋu miko sonda moakoŋ tariko kiŋariŋ yoŋoji Sonda oo moke pigo qodureru mendi keku ki baku Tomaske moko ŋebuŋ. Moko ŋekabi Yesuji moke fukeru botuyaŋuŋgo dimaku iŋi miya, “Ogopune, womo ŋoŋoke peine!” ");
INSERT INTO mlh_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Oŋu miku Tomas ojiya, “Go mego bofeŋgaru meyokane roru ŋoneru me sisigoji tambaraŋneo boua. Oŋu eru keta bokeru maŋyoyokago bokeru noŋ manesiŋ nuigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Oŋu ojime iŋi bokirieya, “O, go nonde Ofoŋ Anutune!” ");
INSERT INTO mlh_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Oŋu bokirieme iŋi ojiya, “Go ŋone nuge ore noŋ soine manesiŋ nugeyoŋ, ŋiŋigo so ŋone nuru jibu noŋ manesiŋ nuegobi, yoŋoji kiwaqawaineke fukegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuji gio usuŋ suŋsuŋineke baku gome mosi qoqowirie boakoŋ goine oi kiŋariŋ yoŋore jiŋo paio fukeyayoŋ, oi buk yoo so quraŋgaboŋ. ");
INSERT INTO mlh_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Buŋo goine quraŋgabe, oi iŋi ore quraŋgaboŋ: Yesuji Anuture Made fukeru Munaŋqoqo Rauine Kristo fukega, ŋoŋo buŋo oi manesiŋ garu oŋuine oo Yesure tinabiŋere eru gogo sanaŋine rauganimiŋ. Oŋu eru gonimiŋ ore nonji Bobiaŋ Biŋe quraŋ yo quraŋgabe ŋoŋoreo warega. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jiki Yesuji moke kiŋariŋ goine yoŋoreo fukeya. Taiberias obu joguŋ qaŋaŋineo oo iŋi fuke yareko: ");
INSERT INTO mlh_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Kiŋariŋ ŋi oŋuineji moko gobuŋ: Saimon Pita, Tomas tinaine mo Gbogbodo (Didimus) mibuŋ, Natanael ŋi oi Galili prowinsre taoŋ Kanaone eru Zebedire madeyoka yoyoka eru kiŋariŋ goine yoŋoreone yoyoka. ");
INSERT INTO mlh_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Moko gobi Saimon Pitaji yajiya, “Noŋ jembaeŋ porebemiŋgo rabemiŋ.” Oŋu miko goineji mibuŋ, “Niŋo soine goke moko rakimiŋ.” Oŋu miku bokeru ogâo roperu raru ubu oo jembaeŋ mo so furugabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jembaeŋ so poreru mo gobi kae fureme Yesuji mageŋgo dimaya. Dimayayoŋ, iŋore kamasi oi so ŋone mukubuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesuji dimaku oŋga yareya, “Ogopune, jembaeŋ mo furugagobi me mata?” Miko kerisieru “Mata!” mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“Mata!” mibi iŋi mitiga yareya, “Ŋoŋo simemeŋ-ŋaŋuŋ ogâ furoine oobe bokebi rakame soine jembaeŋ bofukenimiŋ.” Oi maneru simemeŋyaŋuŋ bokebi jembaeŋ boakoŋ rakaru pusebuŋ ore furugabeneŋ wapeiŋ miku embimbiŋgaru poreru wirikuŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Oŋu fukeko Yesure wombuŋ kiŋariŋ iŋoji Saimon Pita iŋi ojiya, “Oi Ofoŋ!” Oŋu miko Ofonde tina maneru kambaŋine akoŋ kiperu goya ore sakikomoŋine kiperu oo akoŋ obu joguŋgo riŋaru rakame. ");
INSERT INTO mlh_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yoŋoji mageŋ keririŋineo 100 mita ore so bembeŋgo raru gobuŋ. Ore eru Pitaji rakaru rako kiŋariŋ goine yoŋoji ogâ qaqaji qaku kitiŋgaku raru simemeŋ jembaeŋineke furugabi ogâ ŋadiineo wareya. ");
INSERT INTO mlh_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Oŋu wareru mageŋgo oderu oo ya iŋi ŋonebuŋ: Misi jako uuineo jembaeŋ jakiine eru poroŋ ŋeya. ");
INSERT INTO mlh_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Oi ŋonebi Yesuji iŋi yajiya, “Ŋoŋo muŋambe yo jembaeŋ furugagobi, oone goine roru yo wareniŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Oi miko Saimon Pitaji maneru ogâo roperu simemeŋ furugame mageŋgo ropeya. Ropeko foriine 153 ŋonebuŋ. Simemeŋ oi jembaeŋ soguine boakoŋ yoŋoji pusebuŋyoŋ, simemenji jibu so tiŋaya. ");
INSERT INTO mlh_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Foriine oi ŋonebi Yesuji iŋi yajiya, “Ŋoŋo wareru kae fufurere uqo noniŋ.” Oŋu miko maneru wareru “Oi Ofoŋnoŋuŋ,” oŋu mane mukubuŋyoŋ, kiŋariŋ yoŋoreone moji “Go moji?” oŋu weuiŋ ore maŋyobiŋ maneru so weuya. ");
INSERT INTO mlh_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","So weuyayoŋ, Yesuji raru poroŋ roru yareru jembaeŋ oŋuakoŋ boroiŋgaru yareya. ");
INSERT INTO mlh_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuji komegone pakereru kiŋariŋpuine fuke yareko ateine yokaomo fukeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kae fufurere uqo nobi tariko Yesuji Saimon Pita iŋi ojiya, “Saimon Jonde made, ogopugo yo yoŋoji noŋ maŋyaŋunji jojoko enareegobi, goji oi yadureru kokoine manjoko enareege me mata?” Oi maneru iŋi bokirieya, “O Ofoŋ, noŋ maŋneji manjoko egareego. Go nonde wombuŋ ogo fukege. Oi gake soine manege.” Oŋu bokirieme Yesuji ojiya, “Go nonde lamapu mendaine gume yaberu goigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Oŋu ojime ateine yoyoka weu teya, “Saimon Jonde made, go fofori manjoko enareege me mata?” Oi maneru iŋi bokirieya, “O Ofoŋ, noŋ gore enareega. Go nonde wombuŋ ogo fukege. Oi gake soine manege.” Oŋu bokirieme Yesuji ojiya, “Go nonde lamapu siŋaŋ yaberu goigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Oŋu ojime ateine yokaomo weu teya, “Saimon Jonde made, go fofori yorogoji nonde eru egareega me mata?” Oŋu weu teme manji jojokore weweuine moakoŋ oi akoŋ weuko ateine yokaomo fukeya ore Pitaji beusembe maneru kerisieru iŋi miya, “O Ofoŋ, go ya sosowo soine mane forege. Go wombuŋ ogone fukege. Goji gake oi fiine akoŋ manege.” Oŋu miko Yesuji ojiya, “Go nonde lamapu gume yaberu goigoŋ. ");
INSERT INTO mlh_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Nonji buŋo foriine yobu mo iŋi mibe mane: Goji jeŋoŋ goku gake sakikomoŋgo kiperu kadi oo me oo rabeminde aŋi manemiŋ ore so soine roware eru gomeŋ. Oŋu go wapemeŋyoŋ, ŋi qoruine fukemiŋ, damaŋ oo mego sinekande moji wareru kambaŋ sakikomoŋgo kipe guru kadi mogo so raiŋgo manemiŋ, oo oga guru raiŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuji kajeqouŋ buŋo oŋu miku Pita komeinde buŋo keroriine barariŋgaya. Iŋoji kome kamasiine mo komeko Anuture tinabiŋe sogueiŋ ore manesuku oi miya. Buŋo oi miku iŋore ojiya, “Go wareru noŋ boyobe nuru goigoŋ!” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pitaji Yesuke raru kerisieru Yesure wombuŋ kiŋarinji ŋadiyakuŋgo wareme ŋoneya. Kiŋariŋ iŋoji ŋonemaiŋ lama nobuŋ, oo qoruineji Yesure omoo roegaru miya, “Ofoŋ, gore babae ŋi oi moji?” ");
INSERT INTO mlh_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kiŋariŋ oiji ŋadiyakuŋgo wareko Pitaji oi ŋoneru Yesu iŋi weu teya, “Ofoŋ, kiŋariŋ yo iŋore uruŋu fukeiŋ?” ");
INSERT INTO mlh_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Weu teme iŋi ojiya, “Nonji iŋore gogo buru oŋu me oŋu ebemiŋ, oi gore manebu mata. Nonji iŋi maneru minobo, ‘Iŋoji so kome go ropeko nonji moreŋgo moke warebeminde damaŋgo jikigaru sakike go ropena,’ buŋo oi iŋore buŋo fukena. Go iŋore buŋo bokeru gogakere gogo bobiaŋgaru sisiŋaŋ eku nonde ŋadio wareru noŋ boyobe nuru goigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Buŋo oŋu miko goineji kosa maneru misauebi maŋkekerisie ogopunoŋuŋ yoŋore botugo buŋo oi iŋi mijibugabuŋ, “Kiŋariŋ oiji so komeiŋ.” Oŋu mijibugabuŋyoŋ, Yesuji jiŋoke tatariine tomiri go ropeiŋ ore so miyayoŋ, buŋo iŋi miya, “Nonji iŋore gogo buru oŋu me oŋu ebemiŋ, oi gore manebu mata. Nonji iŋi maneru minobo, ‘Iŋoji so komeru gome nonji moreŋgo moke warebeminde damaŋgo jikigaru sakike go ropena,’ buŋo oi iŋore buŋo fukena. Go iŋore buŋo bokeru gakere gogo bobiaŋgaru sisiŋaŋ eku goigoŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kiŋariŋ iŋoji ya oi jiŋoineji ŋoneru goku ore so oi kitiŋgaku mitaniŋgaru Bobiaŋ Biŋe yo quraŋgaya. Sosowo yoŋoji kiŋariŋ iŋore fuŋne manegobi ore eru soine kitiŋgaku iŋi miku gonimiŋ, “Iŋoji buŋo kitiŋgaku miya, oiji buŋo foriine yobu fukega.” ");
INSERT INTO mlh_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuji gio baku mosi qoqowirie goine boakoŋ oi oŋuakoŋ eba eku goya. Ore sundu moakoŋ moakoŋ oi sosowo poretiŋ quraŋganobeŋ ine, buk papia doduine doduine boakoŋ fukebi kantri so papia rouŋ pi (laibreri) sosowo oo ruabeneŋ puseru kekefoŋ eko buroine mo so sagana. Oŋu manesugo. ");
INSERT INTO mlh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tiofilus, Luk nonji sundune fuŋfuŋgaine quraŋgabe, oo Yesuji gio fuŋgaru baku roregaru ŋiŋigo qaji yareru goya, ore sundu sosowo burugaru ruabe ŋonemeŋ. ");
INSERT INTO mlh_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Yesuji gio baku sosore ŋi aposolpuine roosoeru qaji yareru goku Moro Tiriinere usuŋ paio gio banimiŋ ore mitiga yareya. Oi yareme Anutuji ogagame Sombuŋgo ropeya. Nonji sundune quraŋgaboŋ, oi oo quraŋga foreboŋ. Muŋambe oone sundu oi jikigaru quraŋgabemiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesuji joiserereŋ maneru komeru komegone pakereru una 40 moreŋgo jikigaru goya. Goku damaŋ oo aposolpuine ateine kokoine fuke yareru Anutu qorumaŋinere fuŋne jikigaru mitaniŋga yareru goya. Oŋu goku moge kamasi fuŋne fuŋne baku yaduya. Yoŋoji oi ŋoneru Yesuji gboreru goga, oi soine mane mukubuŋ. Moge ŋonebuŋ, yoŋoji oi kitiŋgaku miku munaŋ moge oŋuine dimagobi eru moji oi kepieiŋgo embimbiŋgaiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Damaŋ mogo yoŋoke moko goku iŋi mitiga yareru yajiya, “Ŋoŋo Jerusalem siti yo pipa so bokeinebi. Mamaneji ‘Yauŋ maŋyaŋuŋgo rua yabebemiŋ,’ miku buŋoine kipeme ŋajiboŋ, oi foriineke fukeiŋ. Ŋoŋoji ore eru odigaru goinebi. ");
INSERT INTO mlh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Rone Jonji ŋiŋigo meso omaineji rau yareru goyayoŋ, Anutuji damaŋ so joroko Moro Tiriine maŋ-ŋaŋuŋgo ruaru oo rau ŋareiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aposol yoŋoji damaŋ mogo tumaŋgabi Yesuji botuyaŋuŋgo fukeko iŋi weu tebuŋ, “Ofoŋ, goji damaŋ yoo me wamo damaŋgo Israel kantrire jokoroŋ oi moke quraŋgaru basanaŋgamiŋ?” ");
INSERT INTO mlh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Weu tebi iŋi yajiya, “Mamaji iŋoyoŋunde usuŋ paio gosa eru aua damaŋ burugaru ruame pega, oi ŋoŋoji manenimiŋ ore so mata. ");
INSERT INTO mlh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Oi matayoŋ, Moro Tiriineji wakiru maŋ-ŋaŋuŋgo rakaiŋ, iŋoji usuŋ ŋareme qowirieru nonde fuŋne kitiŋgaku miku goinebi. Oi Jerusalem sitio fuŋgaru Judia prowins sagaru Samaria prowinsgo raru roregaru jikigaru moreŋ qaŋaŋineo paibe yukube mobemobe rabi saga foreku raiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesuji buŋo oi miyare foreme Anutuji jiŋo paiyaŋuŋgo ro bapakareko kuanji wakiru komoŋ gako paibe ropeko ŋoneiŋgo ore pibi ropeko pikamaŋgaru oo baaru dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Oŋu ropeme qonikiŋgo paibe bibitatara eru dimakabi oo akoŋ ŋi yoyoka marikuyakuŋ gbagbataeŋine yokoji maŋfuŋyaŋuŋgo fukeru dimabu. ");
INSERT INTO mlh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Dimaku iŋi yajibu, “Galili ŋi ŋoŋo wamore qonikiŋgo paibe piku akoŋ dimagobi? Anutuji Yesu yo ŋoŋore botugone ogagaru Sombuŋ karorago paibe ropeko ŋonegobi, iŋoji kamasi oŋuakoŋ moke kirieru wakiiŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Oŋu yajibu aposol yoŋoji Jerusalem siti bembeŋgo tuku tinaine Oliwe yo tuku oone kirieru wakiru 1 kilomitare so wareru sitio wapebuŋ ");
INSERT INTO mlh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem waperu pi maŋine mo paiineo oo ŋeku gobuŋ, oo raru ropebuŋ. Ropebuŋ, yoŋore tina oi iŋi: Pita, Jon, Jeims eru Andru; Filip, Tomas, Bartolomyu eru Matyu, Jeims Alfiusre made, Saimon Zelot politik ŋi eru Judas Jeimsre made ");
INSERT INTO mlh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ŋi sosowo yoŋoji maŋmoakoŋ eru ŋigo yoŋoke yameŋ keku oŋga wosiru gobuŋ. Yoŋore botugo Yesu gbopuine eru maŋgoine Maria yoŋoji oŋuakoŋ gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Oŋga wosiru goku una mogo mamanesiŋ ŋiŋigo jareyaŋuŋ 120 ore so tumaŋgabi Pitaji botuyaŋuŋgo pakereru buŋo iŋi miya, ");
INSERT INTO mlh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ŋi ogopune, Yesu roru kipebuŋ, Judasji yoŋore kadi yaduya. Moro Tiriineji Judasre buŋo oi ronekoŋ kiŋ Deiwid maŋineo saŋu ruame miineji miko Miti kiki buk (Buk Song) oo quraŋgabi pega, oiji foriineke fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yesuji Judas roosoeko noŋunde qokogo mo gome gioine baiŋgo ore igodoŋgaru sosore ŋi qoruine aposol fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Judasji eebobo sembene eru furiine otebi roru oiji moreŋ rondiŋ mo furiine baya. Oi baku oo ubeine bopogaru qoruineji kerisieru moreŋgo igako beuine pougako ata beumaŋgoine kakaine gboine oi sosowo igajiri waperu wakiya. ");
INSERT INTO mlh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Oŋu fukeko Jerusalem ŋiŋigo sosowo ore biŋeine mane foreru moreŋ ore tinaine yoŋoyaŋunde buŋoo Akeldama mibuŋ. Oi noŋunde buŋoo Dari rondiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pitaji jikigaru iŋi yajiya, “Miti kiki (Buk Song) oo buŋo mo iŋi quraŋgabi pega, ‘Piine wambaine fukeru taine dimaiŋ. Oi moji rauine so fukeru gome pi akoŋ dimaiŋ,’ ‘Moji soine iŋore tife fukeru siŋaŋ gio baku dimaiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Ore eru niŋo ŋi mo roosoeru igodoŋgabeneŋ niŋoke minebobo fukeru munaŋ moge oŋuine dimaku Yesuji komegone pakereya, ore Biŋeine kitiŋgaku miku goko sagaiŋ. Jonji Yesu miti meso rau teme Ofonji damaŋ oo akoŋ tumoqoqoo raru gioine fuŋgaru baku niŋore moreŋgo roregaru ra wareru goko Anutuji botunoŋuŋgo akoŋ ogagaru ropeya. Ŋi damaŋ sosowo oo kubunoŋuŋgo moko go wapebeŋ, yoŋoreone mo roosoebeneŋ sagaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pitaji oŋu yajime ŋire baaru ŋi yoyoka tinayakuŋ mibuŋ. Mo tinaine Josef, tinaine mo Barsabas eru tinaine mo Jastus. Ŋi more tina Matias. ");
INSERT INTO mlh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tinayakuŋ miku iŋi oŋga wosiru mibuŋ, “O Ofoŋ, go ŋiŋigo maŋnoŋuŋ sosowo mane mukuge. Ore eru go ŋi yo yokoreone mo roosoege, oi noduigoŋ. ");
INSERT INTO mlh_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judasji kiko eru kasigaru wakiru aposol gio bokeru sembenere so sibirigaru rakaya, iŋore ŋeŋeo ŋi moji aposol fukeru dimaku sosore ŋire gio baku goiŋ. Buŋo oi foriine.” ");
INSERT INTO mlh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Oŋu miku yokore qouŋ (kas, lot) qabi Matias fukeya. Fukeko aposol 11 yoŋore botugo ŋeŋe mo otebi kubuyaŋuŋgo jikigaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yesuji komeya, damaŋ oone sonda 7 tariko una 50 oo bobosu damaŋ ware fukeko maŋkekerisie ŋiŋigo sosowo yoŋoji tumaŋgaru kombaŋ ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ŋebi Qonikiŋgone ya mo ututuŋ boribori oŋuine wakiko fonuŋ yasogo fukeko manebuŋ. Tembonji qaega, ore kamasi oŋuine fukeru wakiru pi ŋebuŋ, oi sosowo puseya. ");
INSERT INTO mlh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pi puseru ya oiji roiŋgaru saueru misi boruŋ oŋu qoruyaŋuŋ paiineo ropeko ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Oŋu fukeko Moro Tiriineji sosowo yoŋore maŋ puseko kantri goine yoŋore buŋo fuŋgaru mibuŋ. Moro Tiriineji boburoru buŋo saŋu ruaya ore so totogo mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Juda ŋiŋigo goineji Anutu araŋ baku kantri fuŋne fuŋne qonikiŋ rurumaŋgo ŋeku ragobi, oiji roiŋgaru raru goku Jerusalem kirieru warebuŋ, goine oŋuine yoŋoji sitio gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Oŋu goku fonuŋ yasogo oi maneru ŋiŋigo kubu kokoineji waperu tumaŋgabuŋ. Tumaŋgaru dimabi mamanesiŋ ŋiŋigoji buŋo furuine furuine mibuŋ, oi sosowo maneru bubu mane taniŋgaru ore eru popureru qiqu ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Qiqu eru waragaru iŋi mibuŋ, “Maneniŋ! Ŋi yo buŋoine buŋoine migobi, yoŋoji sosowo Galili ŋiŋigo fukegobi me? ");
INSERT INTO mlh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Niŋo kantri furuine furuine oo fukeru waperu gobeneŋ yoŋoji uruŋu eru goku sogueru kantrinoŋuŋ so buŋonoŋuŋ bubu mibi manegobeneŋ? ");
INSERT INTO mlh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Niŋo Partia ŋiŋigo, Midia ŋiŋigo eru Elam ŋiŋigo yo dimagobeneŋ. Niŋo goineji Mesopotemia gobeŋ. Goineji Judia gogobi eru goineji Kapadosia kaeo gobuŋ. Ŋiŋigo goineji Pontusre, goineji Eisia prowinsre fukegobeneŋ eru yoŋoji noŋunde buŋoo buŋo mibi manegobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","“Goineji Frigia moreŋ bokeru yo wareru gogobi. Goineji Pamfilia taoŋ bokebuŋ. Goineji Ijipt moreŋgo gobuŋ. Goineji Sairini moreŋ aribe Libia moreŋgo gobuŋ. Goine niŋo Rom siti yayaba yo wareru gogobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Niŋo goineji Juda ŋiŋigo fukeru gogobeneŋ eru goineji kantri goineo fukeru jiki Juda ŋiŋigo fukebeŋ. Oŋu dimagobeneŋ eru yoŋoji buŋo mibi niŋo buŋonoŋuŋ moakoŋ moakoŋ oi soine mane mukugobeneŋ. Niŋoreone goineji nu tinaine Krit bokeru koe petigaru warebuŋ. Goineji Arebia buŋo miegobi. Niŋo oŋuineji gogobeneŋyoŋ, yoŋoji jerieru Anutuji mosi qoqowirie ropekiine baya, ore fuŋine oi noŋunde buŋoo bubu mibi manegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Oŋu miku sosowo yoŋoji popureru manebi jibugako yoŋoyoŋe iŋi miku weweu ebuŋ, “Yo ore fuŋine oi uruŋu?” Oŋu weweu eku buŋo baaru mumutu dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Koŋkoŋ dimabuŋyoŋ, goineji igosisi eru iŋi mibuŋ, “Yoŋoji wain obu aŋiineke kokoine nogu manjibu fukegobi.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Oŋu mibi Pitaji aposol 11 yoŋoke moko pakereru dimaku sanaŋine oŋgaku ŋiŋigo kubu oi iŋi yajiya, “Ogopune, Juda ŋiŋigo eru ŋiŋigo sosowo Jerusalem gobuŋ, nonji ya fukega ore fuŋine mibe oi kaje ruaru maneniŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ŋoŋo goineji niŋore iŋi migobi, ‘Yoŋoji obu sanaŋine nobi maŋyaŋunji jijibu fukega.’ Oŋu manesuegobiyoŋ, niŋoji oŋuine so fukegobeneŋ. Yo kae fufurere 9 kilok fukega. Kaere oi obu uqo damaŋine mata. ");
INSERT INTO mlh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Matayoŋ, kajeqouŋ ŋi Joelji Biŋe buŋo iŋi miya, oiji foriineke fukega, ");
INSERT INTO mlh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Anutuji miga: Ofonde waware damanji bembeŋgaiŋ, nonji damaŋ oo Morone Tiriine kesebe ŋiŋigo sosowo yoŋore paio ropeiŋ. Roperu boburoru saga yabeme iŋi fukeiŋ: Ŋoŋore odumadepuji kajeqouŋ buŋoine buŋoine mienimiŋ. Ŋoŋore jeŋoŋ ŋiŋigopuji jiŋoyaŋuŋ kerisieme pororoine pororoine ŋoneenimiŋ. Ŋoŋore ŋiŋigo qoruine yoŋoji kubaŋ ŋoneenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Morone Tiriine kesebemiŋ, oi ŋi eru ŋigo nonde kiŋaŋ qaku gonimiŋ, yoŋore paio oŋuakoŋ ropeko kajeqouŋ buŋo mienimiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nonji mosi qoqowirie qonikiŋgo ruabe pibi paibe ropeko ŋonenimiŋ eru moreŋgo soi oi iŋi ŋonenimiŋ: Ya darike, misi boruŋ ropekiine eru ju rombuŋineke oi fukenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wegi jiŋoineji qisiri fukeko ayonji ojeru dari oŋuine fukeiŋ. Oŋu fukeko ore ŋadiineo Ofonde damaŋ yasogoji wareru fukeiŋ. Una oi kuriri eru biŋeroroineke. ");
INSERT INTO mlh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Uri yoŋoreone moji Ofonde tina oŋga wosiiŋ, Anutuji oi munaŋ qa teko qowirieiŋ.’ Joelji oŋu quraŋgame pega. ");
INSERT INTO mlh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“O Israel ŋiŋigo, ŋoŋo kaje ruaru buŋo yo maneniŋ: Anutuji Yesure gogo damaŋgo boburo teme goko mosi qoqowirie, soi eru eebobo qembibiineke oi ŋoŋore botugo moreŋgo totogo fukeya. Ŋoŋo oi soine manegobi. Anutuji ya oi fuke teru oŋuine oo Nazaret ŋi iŋore fuŋne kitiŋgaku miku ŋaduru goya. ");
INSERT INTO mlh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","“Anutuji ronekoŋ Yesure buŋo ronekoŋ kiperu mane mukugaru iŋi miya pega, ‘Munaŋqoqo Rauineji ŋi minebobo ŋoŋore meo wakiiŋ.’ “Buŋo ore so Anutuji Yesu so sabareko ŋoŋore meo wakiya. Oŋu wakiko ŋoŋo komeiŋ ore qabi kotu kantri gawman yoŋoji Mosesre Kadi buŋo so maneru jibu mitigabi meŋaŋunji Yesu qafagaru roru maripoŋgo qabi komeya. Komeyayoŋ, dariineji ŋoŋore paio ropeya pega. ");
INSERT INTO mlh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yesuji komeyayoŋ, komere nigiŋ gbediji wakiko kome Rauineji oi kiperu damaŋ joroine siŋaŋ gaiŋ ore embimbiŋgaya. Oi Anutureo so sagaya. Ore eru iŋoji oi kegboreru komere joiserereŋgone bomukuko pakereya. ");
INSERT INTO mlh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kiŋ Deiwidji Yesure iŋi miko pega, ‘Nonji tuturi eru egu rondiŋga nuiŋ ore Ofonji me furoneo goga. Iŋoji damaŋ so keririŋneo dimako sasakoine oŋu ŋoneru gogo. ");
INSERT INTO mlh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Oŋu goku komebemiŋyoŋ, komere kaeo rakabe so ŋadi nuiŋ. Goji gakere yoro ŋi gbagbataeŋine roosiŋine noŋ bomuku nunde jiŋoruŋgo peku so goregabemiŋ. Ore eru maŋneji jeri maneru mi bibineji saoreŋ kiki keku gogo. Sakineji oŋuakoŋ gboreru pakereiŋ ore eru odigaru oori eru gbiŋ qaku peiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Goji gogo sanaŋinere fuŋne nadunde mane mukubemiŋ. Nonji gore jiŋo maio damaŋ so gobe goji maŋne jeriji roru bofuseiŋ.’ Deiwidji Yesure oŋu miko pega. ");
INSERT INTO mlh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“O ogopune, Pita nonji moreŋfuŋ ŋasonoŋuŋ kiŋ Deiwidre fuŋne oi koimo paio totogo iŋi mitaniŋgabemiŋ: Deiwidji komeko yaŋgabi jiŋorunji muŋambe botunoŋuŋgo yo pega. ");
INSERT INTO mlh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Deiwidji kajeqouŋ ŋi fukeru goya, iŋoji iŋi maneya: Anutuji osigidapuine yoŋoreone mo roosoeru bofeŋgame iŋoyoŋe oŋuine ŋi ofonde ŋeŋeo ŋeiŋ. Anutuji buŋo oi kiperu mimipaŋ buŋoo misanaŋgaru goya. ");
INSERT INTO mlh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Moji ŋeiŋ, oi ronekoŋ ŋoneru maneya. Munaŋqoqo Rauine Kristo iŋoji komegone pakereiŋ, Deiwidji oi maneru iŋi miya, ‘Kristoji goku komeiŋyoŋ, komere kaeo rakame Anutuji oi so ŋadi game peiŋ. Iŋore saki fu oi so bokeme qoŋgbuŋineji jiŋoruŋgo so goregaiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Anutuji Yesu bogboreme pakereko oŋuine oiji buŋo oi foriineke fukeya. Niŋo sosowo oi jiŋo koruŋnoŋunji ŋoneru kitiŋgaku miku munaŋ moge oŋu dimagobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesuji pakereru goko Anutuji ogagame roperu me furoineo ŋega. Oo ŋeku Mamaineji Moro Tiriine soreiŋ ore mikipeya, iŋoji (mimipaŋ) oi maneru oi keseme wakiko foriine muŋambe yo fukeko ŋoneru manegobi. ");
INSERT INTO mlh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deiwidji Sombuŋgo so ropeya. Iŋoji iŋoyoŋe buŋo iŋi miko pega, ‘Anutuji Sombuŋ kae maŋgo nakene Ofonde iŋi mitigako maneya: Goji wareru me furoneo kuririquraŋ yo oo wakiru ŋe goigoŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Oŋu ŋe gokande nonji damaŋ botuineo yo oo kisopugo yoŋo ode odeparuku gbiŋ eyarebemiŋ. Gbiŋ eyarebe yoŋoji rondiŋgaru rakaru joiserereŋ maneru kuyoku kadi koji oŋu fukenimiŋ. Oŋu fukebi goji soine pakereru yoŋore paio oderu jerieru goigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“O Israel ŋiŋigo, ŋoŋo Yesu maripoŋgo qabi komeyayoŋ, Anutuji Yesu oi igodoŋgame Ofoŋ eru Munaŋqoqo Rauine Kristo fuke noreru goga. Israel kubu sosowo ŋoŋo ore fuŋine mane mukuinebi.” ");
INSERT INTO mlh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pitaji oŋu miko ŋiŋigo kubuji maneru maŋyaŋuŋ qopogame Pita eru aposol goine oi iŋi yajibuŋ, “Ŋi ogopunoŋuŋ, niŋo uruŋu ebeneŋ sagaiŋ?” ");
INSERT INTO mlh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Yajibi Pitaji iŋi yajime manebuŋ, “Ŋoŋo bio maŋ-ŋaŋuŋ kerisieniŋ. Moakoŋ moakoŋ maŋ-ŋaŋuŋ kerisiebuŋ ore so niŋoji Yesu Kristore tinao meso rau ŋarekimiŋ. Oi ŋarebeneŋ Anutuji agiburaŋ-ŋaŋuŋ jureru bokeru Moro Tiriinere yauŋ oi biŋe qa ŋareiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Anutuji Moro oi ŋareiŋ ore mikipeya, buŋo oi ŋoŋo-ŋaŋe eru ŋoŋore osigidapu ŋoŋore eru miya. Ŋoŋore eru goine joroineo raru gobi Anutu Ofoŋnoŋunji oŋga yabeiŋ, iŋoji mimipaŋ buŋo (promis) oi sosowo ŋoŋore eru oŋuakoŋ miku kipeme pega.” ");
INSERT INTO mlh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitaji oŋu yajiru jikigaru uŋsowoŋ buŋo goine kokoine oo maŋyaŋuŋ bapakareru iŋi miya, “Ŋiŋigo iŋgoŋmaŋgoŋine yo moreŋgo gobuŋ, Anutuji oi munaŋ qa yareko qowirienimiŋ ore manega. Yoŋoke joiserereŋ egu bofukenimiŋ ore bio maŋ-ŋaŋuŋ kerisieru ŋiŋigo kekesiine oi ruge ruaru boke yabeinebi.” ");
INSERT INTO mlh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pitaji oŋu miko ŋiŋigo jiŋoraraineji buŋoine maneru sabarebi miti meso rau yarebuŋ. Oi rau yarebi kufufuŋyaŋuŋ jikigabi jareyaŋunji una oo akoŋ 3,000 ore so sogueya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Maŋyaŋuŋ kerisiebuŋ, yoŋoji maŋmoakoŋ eru maŋyaŋuŋ kikipe eru damaŋ so ŋoŋone eku tumaŋgabi aposol yoŋoji Biŋe buŋo qaji yarebi tebu mokiine eru uqo munjaŋ moko nogu oŋgawowosi gio baku gobuŋ. Damaŋ so gogo oŋu gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Oŋu dimaku Anuture tinaji egu sembeaiŋ ore gburugburu qaku gobuŋ. Oŋu gobi Anutuji boburo yabeko aposol yoŋoji mineboboyaŋuŋ fukeru gio babi mosi qoqowirie soi furuine furuine fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Anutu manesiŋ gabuŋ, yoŋoji sosowo gogoyaŋuŋ moko goku mebo (tebe mariku) yayaŋuŋ sosowo qodureru moko baku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Oŋu baku goku moreŋ mebo yayaŋuŋ furiine banimiŋ ore ruabi furiine yarebi wareya, oi botuyaŋuŋgo basaqasa eru embimbiŋgabuŋ ore so boroiŋga eru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Oŋu qodureru goku jijiki maŋmoakoŋ eru damaŋ so boji soriŋgo tumaŋgaru gobuŋ. Poroŋ oi pi so bajiru noku gobuŋ eru uqo munjaŋyaŋuŋ oi kikoyaŋuŋ tomiri jeri paio ŋeku noku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Eeboboyaŋuŋ oŋu eru Anutu miteŋ garu gobi ŋiŋigo sosowo yoŋoji oi ŋone aŋi eyareku gobuŋ. Ŋone aŋi eyareku gobi kubuyaŋunji sogueme Ofonji damaŋ so ŋiŋigo goine qowirie yabeme maŋyaŋuŋ kerisieru qoqodure buruyaŋuŋgo jikigabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Juda yoŋoji iŋande so 3 kilok oŋga wosiebuŋ. Iŋande mogo Pita Jon yokoji oŋgawowosi damaŋ oo boji soriŋgo ropebire. ");
INSERT INTO mlh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ropebire oo ŋi mo maŋgo beu maŋgone demba fukeru ŋeku goya, oi koboru wareru boji sorinde sa mendiineo ruabuŋ. Ogopuineji una so wareru reŋgo koboru sa mendi tinaine Mendi Ŋoneaŋike mibuŋ, oo ruabi ŋeya. Ŋeru ŋiŋigo soriŋ kubaineo ropebuŋ, yoŋoji moneŋ yauŋ otenimiŋ ore karie yareru goya. ");
INSERT INTO mlh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Oŋu ruabi ŋeko Pita eru Jon yokoji boji soriŋgo ropeiŋgo mibire jiŋororopu ŋone yaperu oi oŋuakoŋ yaunde weu yateya. ");
INSERT INTO mlh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Weu yateme jiŋo maiineo piku ŋoneru Pitaji iŋi ojiya, “Go niko ŋone nope.” ");
INSERT INTO mlh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Oŋu ojime jiŋo kati ŋone dendeŋ yaperu ya mo meyakuŋgone narenimi ore odigaya. ");
INSERT INTO mlh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bibi tatarako Pitaji iŋi ojiya, “Nonde silwa me goul moneŋ so pegayoŋ, nonde ya mo pega, oi soine garebemiŋ: Go Nazaret ŋi Yesu, Munaŋqoqo Rau Kristore usuŋgo pakereru ra!” ");
INSERT INTO mlh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Oŋu ojiru meine furoineo baku bopeŋgame pakereya. Pakereme kufuine eru gbaku siaine oo akoŋ sanaŋgaya. ");
INSERT INTO mlh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Sanaŋgako pakereru riŋaru yokoke boji soriŋgo roperu oo raru wareru quraŋ qaku oderu Anutu miteŋ gaya. ");
INSERT INTO mlh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Oŋu ra wareru Anutu miteŋ garu ŋiŋigo kubu sosowo yoŋoji oi ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Oi ŋoneru iŋi mibuŋ, “Ŋi yo yauŋ otekimiŋ ore sorinde sa Mendi Ŋoneaŋikere bembeŋgo ŋeku karieku goya, iŋo.” Oŋu miku maneru “Sakiineji wamo ya fukega?” miku popureru meayaŋuŋ mukume waragabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Waragabi mijimimi ŋi oiji jijiki Pita Jon yokoke moko raru wareko ŋiŋigo kubu sosowo yoŋoji pipa maŋfuŋyaŋuŋgo wareru boji sorinde jokoroŋ maŋgo roperu kiŋ Solomonde kae jiŋo saraŋineo tumaŋgaru dimaku bibitatara ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Oŋu bibitatara ebi Pitaji ŋone yaberu fuŋgaru iŋi yajiya, “O Israel ogopune, ŋoŋo wamore ya yo ŋoneru popuregobi? Wamore niko piku bibitatara ŋone nopegobi? Ŋi yo oiji fiaru kadi raru warega, oi nikore tobiriji me Anuture Biŋe buŋo poretiŋ maneru boyobeegobere ore eru mata. Oŋu so manesuinebi. ");
INSERT INTO mlh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Noŋunde apa ŋaso Abraham, Aisak eru Jeikob yoŋore Anutuji Madeine Yesu kuririquraŋ oteme minebobo ropekiine fukeko foriine fukeme ŋonegobi. Ŋoŋo Yesu oi roru moreŋ siŋaŋ yoŋore meo ruabi gawana Pailotji pirueinde buŋo kiperu miyayoŋ, ŋoŋoji Yesu oi iŋore jiŋoo mugaru ŋadi gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“Ŋoŋo ŋi poretiŋ eru gbagbataeŋine oi ŋadi gaku ŋi qoqo ŋi mo pirueiŋ ore yameŋ keku oŋga jojoraku weubuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Oŋu oŋgaku weuku oŋuine oo gogore Rauji komeinde buŋo mibi komeya. Komeyayoŋ, Anutuji oi bogboreme komegone pakereya. Nikoji ya oi jiŋonokunji ŋoneru kitiŋgaku miku iŋore munaŋ moge oŋuine dimagobere. ");
INSERT INTO mlh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Oŋu dimaku Yesure tina manesiŋ gaku gogobere. Ŋi yo ŋoneru manegobi, oi tina ore usuŋineji basanaŋgame dimaga. Yesuji boburo nopeko mamanesiŋnokunji fukeko ore paio dimaku mitigabere kufu gbakuineji fiame ŋoŋo sosowo oi ŋonegobi. ");
INSERT INTO mlh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“O ogopune, Yesu komeiŋ ore yameŋ kebuŋ, ŋoŋoji oi qaqouma paio ebuŋ, oi manego. Ŋoŋo-ŋaŋe eru siŋaŋpuŋaŋunji oŋuakoŋ ya etebuŋ, ore fuŋine so mane mukuru kosa etebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Oŋu etebuŋyoŋ, ore mobeine Anutuji iŋi eya: Anutuji buŋoine ronekoŋ kajeqouŋ ŋiŋigopuine sosowo boburo yabeko ronekoŋ iŋi miku quraŋgabuŋ, ‘Anuture Munaŋqoqo Rau Kristoji joiserereŋ maneiŋ.’ Ore eru ŋoŋo oŋu etebi Anuture buŋo oiji foriineke fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ore eru bio maŋ-ŋaŋuŋ kerisieru Anutureo kirieru warebi agiburaŋ-ŋaŋuŋ jureru bokeiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","“Anutuji seŋgiŋbaŋgiŋ Rauine fukega. Ŋoŋo mo kosa egu gonimiŋ ore Anutuji Yesu ronekoŋ roosoeya. Ore eru ŋoŋo bio maŋ-ŋaŋuŋ kerisiebi Munaŋqoqo Rauine Kristo soreme ŋoŋoreo wareko iŋoke qakatobi gogoŋaŋunji gboreko seŋgiŋbaŋgiŋ damaŋ-ŋaŋuŋ ware fukeiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Anutuji ronere ronekoŋgo fuŋgaru buŋoine kajeqouŋ ŋiŋigopuine roosiŋine sosowo oi boburo yabeko ronekoŋ iŋi miku gobuŋ, ‘Anutuji Munaŋqoqo Rauine sabare teko Sombuŋ kaeo ŋeku goko ya sosowo moke burugaku gboreiŋ, damaŋ oo akoŋ soreme Sombuŋ bokeru wakiiŋ.’ Yesuji buŋo ore so wakiru niŋoreo wareya. ");
INSERT INTO mlh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosesji iŋi ŋajiya, ‘Ofoŋ Anutuji Juda kubu ŋoŋore botugone kajeqouŋ ŋi mo bogboreme pakereru Moses noŋ oŋuine fukeiŋ. Iŋoji ŋi yoŋaŋuŋ dimaku buŋo ŋajiiŋ, oi sosowo kaje ruaru maneru reŋgaru goinebi. ");
INSERT INTO mlh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Moji kajeqouŋ ŋi iŋore buŋo so reŋgaiŋ, Anuture kufufuŋ ŋoŋoji iŋore buŋo mitariru sibiri gainebi.’ ");
INSERT INTO mlh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kajeqouŋ ŋiŋigo Samuelreone fuŋgaru waperu buŋo mibuŋ, yoŋoji sosowo oŋuakoŋ kajeqouŋ buŋo damaŋ yoo foriineke fukega, oi ronekoŋ miku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Anutuji apa ŋasopunoŋuŋ yoŋoke jojofo buruine ruaru Abraham iŋi ojiya, ‘Gore osigidapu yoŋoreone moji fukeru pakereiŋ, Anutu nonji iŋore eru morende ŋiŋigo kubuine kubuine sosowo mifia ŋarebe seŋgiŋbaŋgiŋ fukenimiŋ.’ Anutuji jojofo buŋoine barariŋga noreme kajeqouŋ ŋiŋigoji oi jikigaru misanaŋgaru gobuŋ, oi ŋoŋore eru ruame pega. ");
INSERT INTO mlh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Anutuji Madeine bogboreme pakereko mifia ŋareiŋ ore soreme rone ŋoŋoreo wakiya. Ore eru bio muŋambe yo maŋ-ŋaŋuŋ kerisieru bubu gogoŋaŋunde kadi sembene ŋadi ganiŋ. Oŋu eru seŋgiŋbaŋgiŋ fukenimiŋ.” Oŋu miya. ");
INSERT INTO mlh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita eru Jon yokoji ŋiŋigo kubu oi buŋo oŋu yajibire soriŋ gio siŋaŋ yoŋoji, sorinde sa siŋaŋ qoruine eru Sadusi (Soriŋ giore yameŋyameŋ) yoŋoji pakereru jiŋoyakuŋgo wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kiŋariŋyokaineji ŋiŋigo kubu qaji yareru iŋi mibu, “Yesuji komegone pakereya. Ore so komebuŋ, yoŋoji oŋuakoŋ gboreru pakerenimiŋ.” Oŋu mibire maŋyaŋuŋ sembeako yokoreo wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Waperu ro yaperu kae ubu eya ore eru witi pigo rua yaperu mibuŋ, “Kae fureko buŋo koroineo rua yapekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Oŋu mibuŋyoŋ, Biŋe buŋoyakuŋ manebuŋ, yoŋoreone boakoŋ yobuji maŋyaŋuŋ kerisieru Yesu manesiŋ gabuŋ. Manesiŋ gabuŋ, yoŋore jareji sogueme 5,000 ore so fukeru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kae fureko siŋaŋyayabe ŋipuyaŋuŋ, Juda yoŋore minebobopu eru Kadi buŋore qaqaji yoŋoji Jerusalem tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tumaŋgaru soriŋ gio siŋaŋ qoruine tinaine Anas iŋoji botuyaŋuŋgo ŋeya. Oŋuakoŋ Kaiafas, Jon, Aleksander eru soriŋ gio siŋaŋ qoruinere garikiŋpu goine sosowo oi moko ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ŋebi Pita Jon oga yaperu jiŋoyaŋuŋgo rua yapebi dimabire iŋi weu yatebuŋ, “Ŋokoji uruŋu egobire? More tina mibire usunji kefaga teme qowiriega?” ");
INSERT INTO mlh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Weu yatebi Moro Tiriineji Pitare maŋ puseko dimaku iŋi yajiya, “Kantrire siŋaŋyayabe ŋi eru minebobopunoŋuŋ, maneniŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Niko ŋi demba uruŋu ogo babapi etebere kufuine gboreru fiame, muŋambe oŋu weu notegobi. ");
INSERT INTO mlh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ore eru ore mobeine oi soine mibe ŋoŋo eru Israel ŋiŋigo kufufuŋ sosowo manenimiŋ. Ŋoŋoji Nazaret ŋi Yesu, Munaŋqoqo Raunoŋuŋ maripoŋgo qabuŋyoŋ, Anutuji oi bogboreme komegone pakereya. Yesure tinare usunji ŋi yo bobiaŋgako ŋoŋore jiŋo maio fiaru dimaga. ");
INSERT INTO mlh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Buŋo mo oi iŋi, ‘Pi bobo ŋi yoŋoji oŋgiŋ otuŋ mo ŋadi gaku bokebuŋyoŋ, Anutuji oi sariko aeŋ otuŋ sanaŋine qoruine fukega.’ ");
INSERT INTO mlh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Yesu moakonji munaŋ qa norega. Tina mo oŋga wosibeneŋ oi embimbiŋganimiŋyoŋ, Yesure tinaji oi sagaga. Anutuji tina mo Qonikinde rurumaŋgo so nareme pega. Mata! Tina moakoŋ oi oŋgaku qowirieru Sombunde biŋe fukekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Oŋu miforeko kamasiyakuŋ ŋoneru iŋi mibuŋ, “Ŋi yoyoka yo yokoji mamane pigo so roperu jibu buŋo sanaŋine sanaŋine miku koimo dimaku ŋonemeqoti oŋuine fukegobire.” Oŋu miku qiqu eru waragaru fuŋneyakuŋ mane mukuru mibuŋ, “Fofori! Ŋi yoyoka yokoji Yesuke goku qowiriebu.” ");
INSERT INTO mlh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Fuŋneyakuŋ mane mukuru ŋi dembaji fiaru yokoke dimaya, oi ŋoneru buŋoyakuŋ kepieiŋgo embimbiŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Oi embimbiŋgaru soriŋ kaunsol kubu boke yaberu sakibe rakanimi ore mitigabi rakabire yoŋoyaŋekoŋ buŋo baaru uruŋu miki mimane ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Uruŋu miki mimane ebuŋ, “Niŋo ŋi yoyoka yo uruŋu eyatenobeŋ? Yokoji mitigabire mosi qoqowirie fuŋine mo fukeya, oi Jerusalem sosowo yoŋoji mane foregobi eru niŋo oi oŋuakoŋ mugaiŋgo embimbiŋgagobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Oi embimbiŋgagobeneŋyoŋ, ore buŋo ŋiŋigo botuyaŋuŋgo moke saueru egu raiŋ ore soine iŋi mitiga yatebeneŋ sagaiŋ, ‘Ŋoko Yesure tina miku buŋo moke so mini.’ Oŋu miku sanaŋine miku qomuku yatekabeneŋ wiriebire moji mo oi so maneiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Oŋu miku kipe yapebi ropebire iŋi mitiga yatebuŋ, “Ŋoko Yesure tina miku buŋo mo so jikigaru miku ŋiŋigo qaji yareni.” Oŋu miku agi sanaŋine rua yatebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Oŋu mitiga yatebuŋyoŋ, Pita Jon yokoji bokirieru iŋi yajibu, “Nikoji ŋoŋore mimiti reŋganimi ore Anuture buŋo bawakiru ruabere omaine egu fukeiŋ. Oi Anuture jiŋo maio sagaga me mata, oi ŋoŋo-ŋaŋe osoeru miku kipeinebi. ");
INSERT INTO mlh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Oŋu me oŋu miku kipenobuŋyoŋ, nikoji ya ŋoneru manebe, oi kesoŋgaru buŋo bokeru gonimi ore so mata.” ");
INSERT INTO mlh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Oŋu yajibire manebi ŋiŋigo sosowoji mosi qoqowirie fukeya, ore eru Anutu miteŋ gabi. Oŋu miteŋ gabuŋ ore eru “Mobeine uruŋu eyatenobeŋ?” miku kadi mo so bofukebuŋ. So bofukeru siŋaŋbobo buŋo sanaŋgaru miyateru boke yapebi wakibu. ");
INSERT INTO mlh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mosi qoqowirie fukeko ŋi demba fiaya, oi gosaine 40 odureru goya. Ore eru Anutu kokoine miteŋ garu gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Soriŋ gio siŋaŋ qoruine eru minebobo yoŋoji Pita eru Jon siŋaŋbobo buŋo miyateru boke yapebi yokoyokere ogopu yoŋoreo kirieru rabu. Raru buŋo sosowo mibuŋ, oi yajibire manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Oi yajibire maneru maŋmoakoŋ eru maŋyaŋuŋ qojugaru maruyaŋuŋ bofeŋgaku Anutu iŋi oŋga wowosi etebuŋ, “O Ofoŋ ropekiine sogo, goji Sombuŋ, moreŋ, koe eru ya sosowo oo pega, oi bofuke yaberu Rauyaŋuŋ fukege. ");
INSERT INTO mlh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Goji ronekoŋ gakere Moro Tiriine sorende wakiru gio ŋi Deiwid, niŋore ŋaso iŋore migo buŋogo ruande gore migo roku iŋi miya, ‘Maŋkekerisiere yauraine yoŋoji wamore fonuŋ kokoine baegobi? Kantriine kantriine yoŋoji uruŋu eru mamane omaine omaine manesuegobi? ");
INSERT INTO mlh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Morende kiŋ koitoine koitoine yoŋoji moreŋyaŋunde so wapeegobi. Ofoŋ muraŋine muraŋine yoŋoji qodureru tumaŋgaegobi. Oŋu roware eko Ofoŋ eru iŋore Munaŋqoqo Rauine igo yapeegobi.’ ");
INSERT INTO mlh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Fofori, buŋo ore so siti yoo fukeya. Go Madego Tiriine Yesu bofeŋgande Munaŋqoqo Raunoŋuŋ fukega. Iŋoji fukeko ŋi koito yoyoka Herod eru Pontius Pailot yokoji Rom gawman siŋaŋ fukeru noŋunde Israel ŋasopu yoŋoke qodureru tutumaŋ eru kiso etebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Go gake usuŋgo eru migore so iŋore ya fukeiŋ ore buŋoine miku ronekoŋ kiperu burugameŋ. Yoŋoji ya oi etebi buŋo buru sosowo oi oŋu foriineke fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“O Ofoŋ, niŋo go kiŋaŋ qa garebeneŋ muŋambe siŋaŋbobo buŋo naregobi, go oi ŋoneru kitiŋ nobende soine gore Biŋe buŋo ŋonemeqoti oŋuine koimo dimaku miku gokimiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Goji mego sinekande jibe ŋiŋigo oi Madego Tiriine Yesure tina usuŋineo fianimiŋ eru mosi qoqowirie moge furuine furuine fukeenimiŋ. Buŋo oi foriine.” ");
INSERT INTO mlh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Oŋu oŋga wosibi pi tumaŋgaru ŋebuŋ, moreŋ oi gburugburu itiriŋgako Moro Tiriineji sosowo maŋyaŋuŋ puseko raru ŋonemeqoti oŋuine koimo dimaku Anuture Biŋe buŋo miku gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Maŋkekerisie kubu yasogo yoŋoji maŋ mamanesu moakoŋ eru gobuŋ. Ya sosowo pe yareya, oi gore me nonde, oŋu so mibuŋyoŋ, yayaŋuŋ sosowo oi bodurebi moakoŋyaŋuŋ fukeko gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Oŋu gobi Anuture usunji kema yabeme sanaŋgabi aposol yoŋoji miine roku munaŋ moge oŋuine dimaku Ofoŋ Yesuji komegone gboreru pakereya, buŋo oi kitiŋgaku miku gobuŋ. Oŋu gobi Anutuji yauŋmoririine yasogo keseru yareme ŋiŋigoji araŋ ba yarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Oŋu gobi ore so botuyaŋuŋgo moji ya more so basiqasi baku embimbiŋgaru goya. Sosowo uqo gioine gioine eru piine piine ore rau fukebuŋ, yoŋoji oi furiine banimiŋ ore ruabuŋ. Oŋu ruabi furiine babi moneŋ wareko oi baku warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Baku wareru aposol yoŋore meo ruabi sosowo basiqasi eku embimbiŋgabuŋ ore so oi botuyaŋuŋgo boroiŋ yaberu gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ŋi mo tinaine Josef, aposol yoŋoji tinaine Barnabas mibuŋ, oi noŋunde buŋoo: Maŋ-kikitiŋ ŋi, iŋoji nu tinaine Saiprus oo fukeru sogueru soriŋ gio ŋi (Liwait) goya. ");
INSERT INTO mlh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Iŋoji oŋuakoŋ uqo gio moreŋine furiine banimiŋ ore ruame moneŋ wareme furiine oi baku aposol yoŋoreo wareru meyaŋuŋgo ruaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Oŋu eru gobuŋyoŋ, ŋi mo tinaine Ananaias ŋonuŋine tinaine Safaira yokoji gio moreŋyakunde mobe furiine banimiŋ ore ruabu. ");
INSERT INTO mlh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ruabire furiine wareko ŋiji moneŋ mobeine iŋoyoŋunde sabareku bosoŋgame ŋonuŋineji oi mane foreko mobeine mo roru wareru aposol yoŋore meo ruaya. ");
INSERT INTO mlh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Meyaŋuŋgo ruayayoŋ, Pitaji iŋi ojiya, “O Ananaias, go wamore Satan so igogande maŋgo pusega? Iŋoji maŋgo puseko goji esoigaru Moro Tiriine sinefuru eteru gakere morende moneŋ mobe sabareku sumuŋgage? ");
INSERT INTO mlh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Go ore rauine fukemeŋ, damaŋ oo oi gakere biŋe fukeya me? Gakere moreŋgo furiine babi furiine wareya, moneŋ oi gore biŋe fukeya me mata? Go wamore maŋgoo buŋo kiperu ya yo ege? Go buŋo ikoine miku oŋuine oo ŋiŋigo so eadu enobegeyoŋ, Anutu iŋoyoŋe eadu etege!” ");
INSERT INTO mlh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Oŋu ojime buŋo oi maneru rondiŋgaru wakiru moreŋgo rakaru komeya. Oŋu komeko ŋiŋigo sosowo ore biŋeine maneru sombuyaŋuŋ kokoine manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Komeko ŋi jeŋoŋ yoŋoji waperu qoŋgbuŋine roru komoŋ garu koboru raru yaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Aua yokaomo tariko ŋonuŋineji ya fukeya, oi so maneru wareya. ");
INSERT INTO mlh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Wareme Pitaji ŋonuŋine Safaira iŋi weu teya, “Ŋoko gio bobo moreŋ-ŋakuŋ mobeine furiine banimiŋ ore ruabire moneŋ wareya, oi ore so me mata? Oi najinde manebemiŋ!” Weu teme iŋi bokirieya, “Moneŋ oi fofori ore so wareya.” ");
INSERT INTO mlh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Oŋu bokirieme ojiya, “Ŋoko wamore maŋmoakoŋ eru Ofonde Moro Tiriine eadu etegobire? Mane, ŋoegoji komeko ŋiji roru raru yaŋgabi, yoŋoji mendi yo bombeŋgakabi fonuŋine manege. Yoŋoji go oŋuakoŋ komoŋ garu kobo garu ranimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Oŋu ojime oo akoŋ rondiŋgaru Pitare maŋfuŋgo rakaru komeya. Komeko ŋi jeŋoŋ yoŋoji waperu qoŋgbuŋine bofukeru roru koboru raru ŋoeinere qaŋaŋgo yaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yaŋ gabi maŋkekerisie kubu sosowo yoŋoji maneru waragabi biŋeine saueme sosowo maneru sombuyaŋuŋ kokoine manebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Oŋu ruabi Anuture usunji aposol dobe yabeko gio baku meyaŋuŋ ŋiŋigo paiyaŋuŋgo ruabi Anutuji soi mosi qoqowirie fuŋne fuŋne bako botuyaŋuŋgo kokoine fukeya. Ŋiŋigo Yesu manesiŋ gabuŋ, sosowo yoŋoji boji sorinde jokoroŋ maŋgo roperu kiŋ Solomonde kae jiŋo saraŋineo tumaŋgaru kubu moakoŋ fukeru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Oŋu tumaŋgaru gokabi ŋiŋigo goineji kokoiyaŋuŋ maneru ruruine eru moji yoŋoreo so jikigaya. Oŋu matayoŋ, ŋiŋigo kubu yoŋoji araŋ kokoine ba yareku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Oŋu tumaŋgaru gobuŋyoŋ, jibu ŋiŋigo boakoŋ yoŋoji kubuyaŋuŋ jikiga yareru gobuŋ. Ŋi eru ŋigo qokoine qokoine yoŋoji Yesu manesiŋ garu maŋyaŋuŋ kerisiebi kubuyaŋunji sogueru saueya. ");
INSERT INTO mlh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposol yoŋoji gio oŋu bakabi ŋiŋigo boakonji fiabuŋ. Oŋu fiabuŋ ore eru goineji jibe ŋiŋigo oga yaberu pepe gbaku koboru kadi qaŋaŋineo oŋuakoŋ ŋeŋe bobiaŋgaru moki ramegaru oo rua yaberu iŋi mibuŋ, “Pitaji wareru nodureiŋ, sasakoineji damaŋ oo yoŋoreone more paio ropeko fiana.” ");
INSERT INTO mlh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Oŋuakoŋ taoŋ eru kae Jerusalem siti roregaru ŋeku ragobi, yoŋoreone ŋiŋigo kubu kokoineji poreru warebuŋ. Oŋu wareru ŋiŋigo jibe bayabeya eru gemoji noŋguŋ bayareru bapeboriŋ eyarebuŋ, oi oga yaberu wareru wapebuŋ. Wapebi sosowo yoŋoji fiabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Oŋu eru gobi soriŋ gio siŋaŋ qoruineji eru iŋore ogopu Sadusi (Soriŋ giore yameŋyameŋ) pati kitiŋ gabuŋ, sosowo yoŋore maŋ rigaŋgame aari manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Aari maneeru aposol oga yaberu kiperu gawmande witi pigo rua yabebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Rua yabebuŋyoŋ, ubu oo pebi Ofonde mimerereŋ moji witi pi mendiine mendiine roru oga yaberu sakibe wakiru iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Maneniŋ, ŋoŋo raru boji soriŋgo roperu ŋiŋigo jiŋoyaŋuŋgo dimaku gogo gariinere fuŋne sosowo totogo yajiniŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Oŋu yajime kae fureme boji soriŋgo roperu dimaku Biŋe buŋo qaji yarebuŋ. Oŋu dimaku qaji yarebi soriŋ gio siŋaŋ qoruine eru ogopuine kitiŋ gabuŋ, yoŋoji roperu soriŋ kaunsol kubu eru Israel minebobopuyaŋuŋ kepore yabebi moko tumaŋgabuŋ. Tumaŋgaru dimaku kambanti goine aposol oga yabeiŋ ore sore yabebi witi pigo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Rabuŋyoŋ, oi oo so bofuke yaberu omaine kirieru sunduyaŋuŋ iŋi ruabuŋ, ");
INSERT INTO mlh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Niŋo fofori witi pigo roperu mendi sanaŋine kebi dimako ŋi joruyaŋuŋke yoŋoji mendi so dimabi ŋone yabegobeneŋ. Oi ŋone yabegobeneŋyoŋ, mendiine roru roperu oo ŋi mo so bofukegobeneŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Oŋu sunduyaŋuŋ ruabi sorinde sa siŋaŋ qoruine eru soriŋ gio siŋaŋ qoruine yoŋoji buŋo oi maneru maŋyaŋuŋ jibugako mibuŋ, “Opopoŋ! Muŋambe oŋu fukeru jiki moke qoqopuse eko uruŋu egu fukena?” ");
INSERT INTO mlh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Oŋu mibi moji waperu iŋi yajiya, “Maneniŋ, ŋi witi pigo rua yabebuŋ, yoŋoji boji soriŋgo dimaku ŋiŋigo Biŋe buŋo qaji yaregobi.” ");
INSERT INTO mlh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Oŋu yajiko sorinde sa siŋaŋ qoruineji kambanti oga yabeme rabuŋ. Raru “Ŋiŋigoji ko bokeru egu nobenimiŋ,” miku kokoi maneru wiriine akoŋ boji soriŋgo roperu aposol oga yaberu warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Oŋu oga yaberu wareru soriŋ kaunsol kubu yoŋore jiŋoo rua yabebi dimabi soriŋ gio siŋaŋ qoruineji iŋi weu yareya, ");
INSERT INTO mlh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ŋoŋo Yesure tina miku buŋo mo so qaji yareinebi. Niŋoji oŋu miku agi sanaŋine rua ŋarebeŋyoŋ, buŋo ore foriine uruŋu fukeya? Ŋoŋoji jibu jikigaru Yesure binaŋ qaji yarebi Jerusalem siti sosowo saga nobe foreme gogobeneŋ. Eme ŋi oiji komeru dariine keseme ŋoŋoji iŋi nojiegobi, ‘Iŋore buŋoji Juda niŋore paio roperu pega.’” ");
INSERT INTO mlh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Oŋu weu yareyayoŋ, Pita eru aposol goineji iŋi bokiriebuŋ, “Niŋoji ŋiŋigo ŋoŋore mimiti reŋgakimiŋ ore eru Anuture buŋo odurebeneŋ so sagaiŋ. Mata! ");
INSERT INTO mlh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Anutuji noŋunde apa ŋasopure ofoŋ fukega. Ŋoŋo Yesu yo ombuineo gbedigaru qabi komeyayoŋ, Anutuji oi bogboreme pakereya. ");
INSERT INTO mlh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Anutuji oi kegboreru ogagaru roperu iŋoyoŋunde me furoineo ruame ŋega. Paibe ŋeko Anutuji agiburaŋnoŋuŋ boke noreiŋgo ore igodoŋgame Ofoŋnoŋuŋ eru Munaŋqoqo Raunoŋuŋ fukega. Oŋuine fukeru Israel kufufuŋ qowirie nobeko maŋnoŋuŋ kerisiekimiŋ ore manega. ");
INSERT INTO mlh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Niŋo ya oi ŋoneru buŋo sosowo oi kitiŋgaku miku munaŋ mogeine fukeru dimagobeneŋ. Moro Tiriineji oŋuakoŋ buŋo oi kitiŋgaku miega. Anutuji Moro Tiriine ŋiŋigo miine reŋgateegobi, yoŋore maŋgo ruaru biŋe qa yarega.” ");
INSERT INTO mlh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pitaji buŋo oŋu bokirieme soriŋ kaunsol kubu yoŋoji manebi maŋyaŋuŋ siqoji keketi oŋu ketigaya. Ketigako maŋyaŋuŋ jo jako aposol yabebi komenimiŋ ore manebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Oŋu manebuŋyoŋ, Farisi (Kadi buŋore yameŋyameŋ) ŋi mo tinaine Gamaliel iŋoji soriŋ kaunsol kubu yoŋore botugo ŋeya. Iŋoji Kadi buŋore qaqaji ŋi goko ŋiŋigo sosowo araŋ ba tebi mineboboyaŋuŋ fukeya. Oŋu fukeru pakereru aposol oga yabebi sakibe rakaru kokiine mo odiganimiŋ ore mitigaya. ");
INSERT INTO mlh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Oŋu mitigako rakabi minebobo ogopuine iŋi yajiya, “Israel ŋipune, ŋoŋo ŋi yo uruŋu eyarenobuŋ, ore eru fiine akoŋ kokoiŋaŋuŋ maneru sisiŋaŋ-ŋaŋuŋ einebi. ");
INSERT INTO mlh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Rone yukube ŋi mo tinaine Teudas iŋoji pakereru ‘Nonji soguneŋaŋuŋ fukego,’ miko muŋambe gosa goine tariko gogobeneŋ. Teudasji oŋu miko ŋi 400 ore so iŋoke jikigaru kikipe eku gobuŋyoŋ, moji oi qame komeko goineji ŋipuine qotike tebuŋ, oi bapakare yabebi totiekabi rowareyaŋunji jaŋgaru matae foreya. ");
INSERT INTO mlh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Iŋore ŋadio Galili ŋi mo tinaine Judas fukeya. Iŋoji takis roninde ŋiŋigo tinayaŋuŋ quraŋgaru burugabuŋ, (sensus) damaŋ oo fukeya. Fukeru ŋiŋigo kepore yaberu bomunaŋ yabeya oyowo enimiŋ ore ogo babapipuine fukebuŋ. Oŋu fukebuŋyoŋ, oi oŋuakoŋ qabi komeko eru ogopuine qotike tebuŋ, goineji oi igodoŋgabi kokoi maneru totiebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Oŋu fukeko nonji iŋi ŋajibe maneniŋ: Ŋoŋo ŋi yo yoŋore sakio ya kosa so einebi. Yoŋoji gio yo babi roware fukega, oi moreŋ ŋiŋigo yoŋore mamane buruyaŋuŋ akoŋ fukega ine, oi jibugaru jaŋgaru mataeiŋ. Ore eru oi boke yabebi wakinimiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Oi mataeiŋyoŋ, Anuture mamane buruone fukena ine, ŋoŋoji roware oi kipeiŋgo ore embimbiŋganimiŋ. Ŋoŋo Anutu iŋoyoŋe igogaru kiso eteru egu gonimiŋ. Ŋoŋo-ŋaŋunde fuŋne oŋuine egu bofukenimiŋ ore kokoiŋaŋuŋ maneru sisiŋaŋ-ŋaŋuŋ einebi.” ");
INSERT INTO mlh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamalielji oŋu yajime kajeqouŋ buŋoine roru sabareku boyobebuŋ. Oi boyoberu aposol rua yabebi wapebi kambantire mibi ŋoru yabebuŋ. Ŋoru yabebi soriŋ kaunsol kubu yoŋoji aposol oi Yesure tina miku buŋo mo jikigaru egu miniminde agi sanaŋine rua yareru “Wakiru raniŋ,” mibuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Oŋu mibi soriŋ kaunsol kubu bokeru rabuŋ. Kadio raru iŋi mibuŋ, “Yesure tinare eru tinabiŋenoŋuŋ oŋu bojibugagobi, oi Anutuji manega. Iŋoji niŋo joiserereŋ oŋuine manekiminde so maneru ŋone nobeko soine sagaga.” Oŋu miku maŋyaŋunji ore eru fiame jeriebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jerieru gio jikigaru baku una so boji soriŋgo ropebi eru piine piine oo raru Biŋe buŋo qaji yareru gobuŋ. Yesuji Munaŋqoqo Rauine Kristo fukega, yoŋoji ore Bobiaŋ Biŋeine miku oo ŋiŋigo maŋyaŋuŋ bapakareru gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kiŋariŋ jareyaŋuŋji sogueru ropeme Juda ŋiŋigo kubu yoyoka fukeru gobuŋ. Goineji kantri goineone wareru Grik buŋo mibuŋ eru goineji yoŋoyaŋunde moreŋgo go waperu Arameik eru Hibru buŋo miegobi. Oŋu gobi damaŋ oo noigoi fukeya. Grik buŋo mibuŋ, yoŋoji iŋi mibi sembeaya, “Aposol yoŋoji damaŋ so uqo mebo boroiŋgaru noreegobiyoŋ, Grik buŋo mimi ŋigo koje niŋore uqo mebo mobeine oi mobeine sowo noreegobi. Sogokoŋ so boroiŋ gabi so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Oŋu mibuŋ ore eru aposol 12 yoŋoji kiŋariŋ kubu oi kepore yabebi tumaŋgabi iŋi yajibuŋ, “Niŋoji sakire gio baku uqo munjaŋ boroiŋga yareru Anuture Biŋe giore damaŋnoŋuŋ soine so sagako mande gionoŋunji egu wakiiŋ. Oi so sagaga. ");
INSERT INTO mlh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ore eru ogopunoŋuŋ, maneniŋ! Ŋoŋoji ŋoŋo-ŋaŋunde botugone gio babapi bofuke yabeinebi. Moro Tiriineji ŋi maŋyaŋuŋ puseko Anutuji maŋgboroŋine fuŋine mo yareme biŋeroro fiine baku dimagobi, ŋi oŋuine 7 roosoe yabeinebi. Oi roosoe yabebi gio oi yarekabi oi siŋaŋ garu baku gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yoŋoji oŋu gonimiŋyoŋ, niŋonoŋe damaŋ so sanaŋgaru oŋga wosiru Anuture Biŋe buŋo miine dimaku misaueku gokimiŋ. Gio oo damaŋ so dimakimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Oŋu yajibi kubu sosowo yoŋoji “Soine sagaga,” mibuŋ. Oŋu miku ŋi tinaine Stiwen roosoebuŋ. Stiwen oi Anutu sanaŋine manesiŋ gako Moro Tiriineji maŋine puseko goya. Jikigaru ŋi yoo roosoe yabebi: Filip, Prokorus, Nikanor, Timon, Parmenas eru Nikolas. Nikolas oi kotu kantrire siti tinaine Antiokia oo fukeru jiki Juda ŋi fukeru maŋine Kristoreo kerisieya. ");
INSERT INTO mlh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Oi roosoe yabebi aposol yoŋore jiŋo maio roperu rabi meyaŋuŋ qoruyaŋuŋgo ruaru oŋga wosiru mifia yabebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Anuture buŋo misauebi touŋmoririineke fukeko kiŋariŋ yoŋore jareji Jerusalem sitio sogueru saueya. Soriŋ gio siŋaŋ yoŋore kubuone boakoŋ yoŋoji oŋuakoŋ maŋyaŋuŋ kerisieru Yesu manesiŋ gabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Anuture yauŋmoririine eru usuŋine oiji gio babapi ŋi Stiwende maŋ puseko dimaku soi mosi qoqowirie sogo sogo oi ŋiŋigo botuyaŋuŋgo bako fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Oi fukeyayoŋ, Juda goineji pakereru Stiwen kiso etebuŋ. “Keŋgoroŋgaru warebuŋ, yoŋore oŋgawowosi pi kubu” yoŋore botugo Juda goineji Sairini eru Aleksandria Ijipt siti yoyoka oone kirieru wareru dimabuŋ. Ŋi oŋuji qodureru pakereru Silisia eru Eisia prowinsgone warebuŋ, yoŋore kubuone Juda ŋi goine oga yaperu moko Stiwenke gbedigaru noigoi eru migobobo mimane ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Oŋu mimane ebuŋyoŋ, Moro Tiriineji Stiwen boburogame maŋgboroŋ soguinere paio buŋoine bokirieru yajiya, oi Juda yoŋoji kepieiŋgo embimbiŋgaru wakibuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Embimbiŋgaru wakiru mimigaŋgaŋ eku raru ŋi goine bofukeru bapakare yaberu wareru iŋi mibuŋ, “Iŋoji igosisi buŋo miku oo Moses eru Anutu nifepupu eyateme manebeŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Oŋu miku raru ŋiŋigo kubu, yoŋore minebobo eru Kadi buŋore qaqaji yoŋore maŋgokaka buŋo mibi maŋyaŋuŋ jo jaya. Jo jako qojugaru wareru Stiwen poreru qafagaru roru soriŋ kaunsol kubu yoŋore jiŋo maio rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Raru ŋi goine oga yabebi waperu Stiwende sakigo buŋo ikoine ruaku iŋi kitiŋgaku mibuŋ, “Ŋi yo oiji boji soriŋnoŋuŋ eru Mosesre Kadi buŋo kiso eku so bokeegayoŋ, oi jikigaru miega. ");
INSERT INTO mlh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kiso eku iŋi miko manebeŋ, ‘Yesu, Nazaret ŋiji boji soriŋ yo ketotieme siŋsaŋ peiŋ eru Mosesji Kadi buŋo noreko pega, oi qopieiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Oŋu mibi soriŋ kaunsol kubure tutumaŋgo ŋebuŋ, oi sosowoji Stiwen poretiŋ pibi kamasiineji Sombuŋ mimerereŋ oŋuine fukeko ŋoneru manebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Stiwen buŋo koroineo ruabi dimako soriŋ siŋaŋ qoruineji iŋi weu teya, “Buŋo oi foriine me ikoine?” ");
INSERT INTO mlh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Weu teme mobeine iŋi bokirieya, “Ŋipune, mama kakagbopune, nonji iŋi ŋajibe maneniŋ: Noŋunde ŋaso Abrahamji Mesopotemia moreŋgo goko kuririquraŋ Rauine Anutu iŋoji fuke teme Mesopotemia bokeru Haran kaeo raru goya. ");
INSERT INTO mlh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Anutuji iŋi ojiya, ‘Go gakere kae moreŋgo eru tifepugo boke yaberu moreŋ mo gadubemiŋ, oo raru goigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Oŋu ojime maneru Kaldia moreŋ bokeru Haran kaeo raru goya. Oo gokame mamaineji komeme Anutuji soreko ŋoŋo damaŋ yoo yo gogobi, moreŋ yoo wareru fuŋgaru ŋeku goya. ");
INSERT INTO mlh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Moreŋ yoo ŋeku goko Anutuji moreŋ mobeine kokiine mo kufu seseinere so oi so biŋe qa teya. Moreŋ yo ore rauine so yobu fukeyayoŋ, Abrahamde osigida so fukeme Anutuji damaŋ oo akoŋ iŋore buŋo ronekoŋ iŋi mikipeya, ‘Nonji moreŋ yo oi go eru gore ŋadio osigidapugo fukenimiŋ, yoŋore yarebe ore rauine fukenimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Oŋu miku jikigaru buŋo iŋi miya, ‘Gore osigidapuji moreŋ mogo raru kotuine fukeru gonimiŋ. Kotuine fukeru gobi moreŋ ore rauine yoŋoji kipe yabebi rauyaŋunde kiŋaŋ omaine qaku gonimiŋ. Oŋu gobi eru ode yabebi gio yobiŋineke yobiŋineke mo babi furiine so ŋarebi gosa 400 ore so koŋkoŋ paio gonimiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Oŋu gonimiŋyoŋ, nonji jiki moreŋ ŋiŋigo kiŋaŋyaŋuŋ qaku gonimiŋ, oi buŋoo ruaru mitari ŋarebemiŋ.’ Anutuji jikigaru iŋi miya, ‘Oŋu fukeko osigidapugoji moreŋ oi bokeru moreŋ yoo kirieru wareru ohowe baku miteŋ nuru gonimiŋ.’ Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Anutuji Abraham oŋu ojiru moge iŋi enimiŋ ore miko maneya, ‘Ŋoŋo noke jojofo enimiŋ ore nonde soi moge keku ŋi sakiyaŋuŋ ketigaru goinebi.’ Ore so Abrahamji madeine Aisak fukeko una 8 tariko oo Anuture moge baku sakiine ketigaya. Aisakji madeine Jeikob bofukeru moge oi ketigako eru Jeikobji madepuine bofuke yaberu ore so keti yabeya. Jeikob madepuine 12 yoŋoji Israel niŋore apa ŋasopu fukebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Apa ŋasopunoŋunji gboyaŋuŋ Josef oi ŋadi gaku furiine banimiŋ ore ruabi goineji furiine baku roru Ijipt moreŋgo raru ruabi goya. Oo goyayoŋ, Anutuji iŋoke goya. ");
INSERT INTO mlh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Iŋoke goko koŋkoŋ fuŋne fuŋne paio ropeko maneya, sosowo oone bomukuya. Bomukuru yauŋmoririine oteme maŋgboroŋine fiine fukeya. Oi fukeme Ijipt kantrire farao kiŋ iŋore jiŋoo ropeko ŋoneme sagako ŋi koito igodoŋgako Ijipt kantri eru farao koitore morumboŋ pi yaine siŋaŋ yaberu goya. ");
INSERT INTO mlh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Siŋaŋ yabeko roro damaŋine wareru fukeko Ijipt sosowo eru Keinan moreŋ oi sagaya. Ore eru ŋiŋigo yoŋoji manebu yasogo maneru bakaqakamaŋ gobuŋ. Oŋu goku noŋunde ŋasopuji uqo munjaŋ bofukenimiŋ ore basiqasi ebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","“Oŋu basiqasi ebuŋ ‘Ijipt moreŋgo kurumbu koruŋ pega,’ oŋu mibi Jeikobji maneya. Oŋu maneru madepuine, noŋunde ŋasopu oi ate fuŋfuŋgaine sore yabeya oo rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Oŋu raru goku kirieru mamayaŋundeo warebuŋ. Jiki ateine mo moke rabi Josefji fuŋneine barariŋga yareko manebuŋ. Manebi farao kiŋ koitoji oŋuakoŋ tifeine ŋone yaberu fuŋneyaŋuŋ mane mukuya. ");
INSERT INTO mlh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mane mukuru Josefji buŋo ruaru mamaine Jeikob eru tifepuine sosowo oi kepore yabeko iŋoreo rabuŋ. Ŋiŋigo rabuŋ, yoŋore jare oi 75 fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Jeikob oŋu ogabi Ijipt moreŋgo raya. Raru goku oo komeya. Ŋasopunoŋunji oŋuakoŋ kome forebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kome forebi qoŋgbuŋyaŋuŋ roru koboru Keinan moreŋgo kirieru Sekem kaeo wareru yaŋga yabebuŋ. Ronekoŋ Abrahamji Sekem (Sikem) goku moreŋ mo ŋi tinaine Hamor iŋore osigidapu yoŋoreone monenji furiine baya, ore jiŋoruŋineji ko kouŋ gufuru oo rua yabebuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Stiwenji jikigaru iŋi miya, “Anutuji ronekoŋ jojofo buŋo Abraham oteya, oi foriineke fukeinde damaŋ bombeŋgaya. Bombeŋgaya, ore so Israel yoŋoji Ijipt moreŋgo fukeru saueru gobi kubuyaŋunji sogueru ropeya. ");
INSERT INTO mlh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sogueru ropeko farao kiŋ moji pakereru fuŋgaru Ijipt siŋaŋ yabeya. Farao kiŋ gariine iŋoji Josefre fuŋne so maneru goya. ");
INSERT INTO mlh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Iŋore fuŋne so maneru noŋunde kufufuŋ oi sinefuru paio eadu eru ŋasopunoŋuŋ eyareru bawaki yabeko gobuŋ. Oŋu gobi kiŋ koitoji Israel yoŋore mimiti sanaŋine iŋi ruaya, ‘Ŋoŋo koko madepuŋaŋuŋ memenda oi ro yaberu sakiineo raru obuo bokebi rakaru komenimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Mimiti oŋu ruame damaŋ oo akoŋ made mo tinaine Moses fukeya. Anutuji oi ŋoneru maneko sagaya. Moses fukeko maŋgo mamaineji oi kaiŋ yokaomo oŋu piyakuŋgo siŋaŋ gaku gobu. ");
INSERT INTO mlh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kaiŋ yokaomo oi tariko maŋgoineji roru sakiineo raru jambeo obu paiineo ruaru bosoŋgame. Bosoŋgaru rako farao kiŋ koitore oduji bofukeru roko madeine fukeko siŋaŋ garu goya. ");
INSERT INTO mlh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Oŋu goko Ijipt yoŋore mamane eru eebobo sosowo oi qaji tebuŋ ore so Ijipt yoŋore maŋgboroŋ ŋi soguine fukeya. Iŋoji buŋoine eru eeboboine oi usuŋ suŋsuŋ paiineo miku eru goya. ");
INSERT INTO mlh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses gosaine 40 tariko oo Israel kakagbopuine yoŋore prowinsgo raru ŋone yabeiŋgo manesuku buŋoine kiperu raya. ");
INSERT INTO mlh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Raru Ijipt ŋiji Israel ŋi mo iŋoke omaine yobu kekepari eru poreru ro furu eteru qame ŋoneya. Ŋoneru raru Israel ŋi oi bapi garu ŋadiineo raru geoine bokirieru Ijipt ŋi oi qaku qame komeya. ");
INSERT INTO mlh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Qako komeme Anutuji Mosesre roegaru Israel ŋiŋigo farao koitore meone bomuku yabeiŋgo ore usuŋ oteko wareya. Yoŋoji Moses ŋoneru fuŋneine oi soine mane taniŋgagobi, oŋu manesuyayoŋ, yoŋoji oi so mane taniŋgaru omaine mutu gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Kae fureko moke yoŋoreo rako Israel ŋi yoyokaji qoqo ebire ŋone yapeya. Ŋone yaperu esoigaru botuyakuŋgo womo fukeiŋ ore maneru iŋi yasiya, ‘Ŋi yoyoka, ŋoko kakagbo. Ŋokoŋake moakonji wamore oŋu sisibiri egobire?’ ");
INSERT INTO mlh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Oŋu yasiyayoŋ, ŋiji ogoine bosembea teya, iŋoji Moses joineke qopieru iŋi ojiya, ‘Go niŋore siŋaŋyayabe eru mimitari ŋi fukege me? Moji igodoŋ gume dimage? ");
INSERT INTO mlh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Go yane Ijipt ŋi qande komee, oŋuakoŋ noŋ nuiŋgo mige me?’ ");
INSERT INTO mlh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Oŋu weu teme buŋo ore eru Ijipt kantri bokeru sumuŋgaru Midian moreŋgo raru kotu goya. Oo goku ŋonuŋ roru madeyokaine yoyoka bofuke yapeko gobuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Stiwenji buŋo jikigaru iŋi miya, “Oŋu gobi gosa 40 tariko oo Mosesji moreŋ buroineo roregaru tuku tinaine Sainai ore fuŋineo gome Sombuŋ mimerereŋ moji fukeya. Oi yo sokokoŋ botuineo misi boruŋ fukeru so ja foreya, oo fuke teya. ");
INSERT INTO mlh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Oŋu fuke teme kamasi ore eru waragaru fuŋine ŋoneru mane mukuiŋ ore bembeŋgo rako Anutureone buŋo mo iŋi fukeko maneya, ");
INSERT INTO mlh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nonji gore apa ŋasopu yoŋore Anutu fukego. Nonji Abraham, Aisak, Jeikob yoŋore Ofoŋ go waperu gogo.’ Buŋo oŋu fukeko maneru maŋine fuŋgaru gburugburu qako oŋube piru ŋoneiŋgo kokoi maneya. ");
INSERT INTO mlh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Kokoi maneyayoŋ, Ofonji iŋi ojiya, ‘Moreŋ oderu dimage, oi moreŋ mokiine. Ore eru go kufu komoŋgo qomukuigoŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nonde ŋiŋigo kubupu Ijipt gogobi, oi eru ode yabebi pipiguguriŋ paio jogbasasanaŋ eru gogobi. Nonji oi ŋone mukuru gogo. Yoŋoji nakafe yabeko kuyoku kariegobi, nonji oi mane forego. Nonji yoŋore meone bomuku yabeiŋgo ore wakigo. Ore eru go muŋambe yo pakereru kadi sore gube Ijipt raigoŋ!’ Oŋu ojiya.” ");
INSERT INTO mlh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stiwenji buŋo jikigaru iŋi miya, “Yoŋoji Moses mugaru kikiraŋga teru iŋi ojibuŋ, ‘Go siŋaŋyayabe eru mimitari ŋi fukege me? Moji igodoŋga guko oŋu dimage?’ Oŋu mugaru ojibuŋyoŋ, Anutuji Moses oi soreme yoŋore ŋi koitoyaŋuŋ fukeya. Sombuŋ mimererenji yo sokokoŋgo boruŋ jako oo fuke teya, iŋoji Anuture biŋe buŋo oi baku wareru maŋine bapakareko bobomuku ŋiyaŋuŋ fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Israel bobomuku ŋiyaŋuŋ fukeru ŋiŋigopuine oi soi mosi qoqowirie fuŋne fuŋne baku Ijipt kantrione bomuku yabeme bokeru Koe Boboroŋ oo warebuŋ. Yukube warebi oo eru moreŋ buroineo oŋuakoŋ jikigaru soi mosi qoqowirie furuine furuine oi gosa 40:re maŋgo baku yaduko ŋoneru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mosesji ŋi koitoyaŋuŋ goku Israel kufufuŋ oi iŋi yajiya, ‘Anutuji Juda kubu ŋoŋore botugone kajeqouŋ ŋi mo roosoeru igodoŋgame noŋ oŋuine fukeiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Israel yoŋoji moreŋ buroineo wareru gobi ŋi koitoyaŋuŋ fukeru noŋunde apa ŋasopu yoŋoke goku kufufuŋyaŋuŋ siŋaŋ yabeya. Siŋaŋ yaberu tuku tinaine Sainai oo ropeme Sombuŋ mimerereŋ moji buŋo ojime maneru iŋoke goya. Oŋu goku Anutuji gogo sanaŋinere buŋoine jijiki ojime maneru goya, iŋoji buŋo oi ore so miko niŋore Biŋe fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Iŋoji ŋi koitoyaŋuŋ goyayoŋ, noŋunde apa ŋasopu yoŋoji buŋoine reŋga teiŋgo ore taki yabeme ŋadi gabuŋ. Ŋadi gaku kepieru maŋyaŋuŋ kerisieme Ijipt moreŋgo moke kirienimiŋ ore aŋi manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Oŋu maneru Moses kakaine Aron oi iŋi ojibuŋ, ‘Mosesji ŋi Koitonoŋuŋ fukeru Ijipt kantrione bomuku nobeko warebeŋ, iŋoji tukuo roperu kamasi uruŋu fukega, niŋo oi so manegobeneŋ. Oi so manegobeneŋ ore goji soine nemu gboŋ bande oiji minebobonoŋuŋ fukebi kufuyaŋuŋgo jikigaru rakimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Oŋu ojiru oo akoŋ goul roru oo nemu mo bulmakao madeinere kamasi babuŋ. Oi baku boji roru wareru eteme jebe rigaru ya meyaŋunji babuŋ, ore jeri eru miteŋ gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Oŋu ebuŋyoŋ, Anutuji oi ŋoneru takigame ŋadi yabeko Qonikinde bobuŋ Rau ohoweyaŋuŋ baku miteŋ yabenimiŋ ore boke yabeya. Kajeqouŋ ŋi Amosji buŋo mo quraŋgako Biŋe Quraŋgo pega, ore so iŋi ruabi, ‘O Israel ŋiŋigo, ŋoŋo moreŋ buroineo wareru gosa 40 ore so goku damaŋ oo joma boji rigaru pesiŋ goine roru wareru nareru gobuŋ me mata? ");
INSERT INTO mlh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Oi matayoŋ, ŋoŋoji nemu tinaine Molek iŋore kambaŋ seri ako oi kobobi eru nemu tinaine Refan iŋore bobuŋ sasako oi koboru wareru gobuŋ. Ŋoŋoji sasako nemu oi ohoweyakuŋ baku miteŋ yapenimiŋ ore babi biŋeŋaŋuŋ fukeya. Ore eru nonji yobe ŋabebe rosipuŋaŋuŋ wareru oga ŋabebi raru goku joroineo Babilon kantrire ŋadio roperu goinebi.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Apa ŋasopunoŋuŋ yoŋoji moreŋ buroineo wareru goku Anuture munaŋ moge bapakareru kambaŋ seri soriŋ baku koboru gobuŋ. Oi baku koboru Anutuji soriŋine banimiŋ ore Moses mitiga teku sasako sosoine odu teko ŋoneya, ore so babi dimaya. ");
INSERT INTO mlh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mosesji apa ŋasopunoŋuŋ siŋaŋ yabeko yoŋoji kambaŋ seri soriŋ oi koboru gobuŋ. Jiki Josuaji pakereru siŋaŋ yabeko osigidapuyaŋunji soriŋ oi biŋe qaku koboru jikigaru wareru goku kantri yoo wapebuŋ. Kantri yoo wapebi Anutuji moreŋ rauine kubuine kubuine yobe yabeme rabi moreŋyaŋuŋ sabareku robuŋ. Roru ŋeku gobi kiŋ Deiwid fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Iŋoji fukeru Anuture jiŋo maio yauŋmoririine bofukeru iŋi weu teya, ‘Anutu Jeikobre ofoŋ, goji soine minde nonji mitigabe niŋo gore boji soriŋ qoruine bakimiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Oŋu weu teyayoŋ, Solomonji mitigako Anuture boji soriŋ babuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Oi babuŋyoŋ, Ropekiine iŋoji ŋiji pi meyaŋunji babuŋ, oo so goga. Ore buŋoine kajeqouŋ ŋi moji iŋi quraŋgame pega, ");
INSERT INTO mlh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ofonji miga: Nonde morumboŋ toŋ ŋeŋene oi Sombuŋgo peko moreŋ oi kufunere kojiine fukeko oo oderu ŋego. Ŋoŋo nonde pi kamasi uruŋu babi sagana? Me pi uro bofuke nubi oo roperu ŋema neru gonobo? ");
INSERT INTO mlh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ya sosowo oi nake nakene meji bofuke yarebe, oi manegobi.’” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“O buŋoqoqo ŋiŋigo, ŋoŋore manji gigako yauraine fukegobi. Kajeŋaŋunji foŋgako so yobu untoga! Oi gigaga ore Anuture buŋo qomukuru kajeboji eegobi. Apa ŋasopuŋaŋunji Moro Tiriine kiso eteru gobi ŋoŋoji yoŋore so jikigaru oŋuakoŋ Moro Tiriine jijiki ŋadi gaegobi! ");
INSERT INTO mlh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ŋoŋore apa ŋasopuji kajeqouŋ ŋiŋigo afaine mata kekesuesue eyareme gobuŋ. Yoŋoreone moji sisikoŋkoŋ so bofukeya? Yoŋoji Ŋi Posiineji fukeiŋ ore kajeqouŋ buŋo mibi oi yabebi komebuŋ. Yoŋoji komebi Ŋi Posiineji iŋoyoŋe fukeko ŋoŋoji oi babae bateku qabi komeya. ");
INSERT INTO mlh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Anutuji mimerereŋpuine sore yabeme Sombuŋgone wakiru Kadi buŋo ŋarebi Biŋeŋaŋuŋ fukeyayoŋ, ŋoŋoji oi so reŋgaru boyoberu gobuŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiwenji buŋo oŋu miko soriŋ kaunsol yoŋoji manebuŋ, oi maŋyaŋuŋ siqoji keketi oŋu ketigaya. Ketigako maŋyaŋuŋ jo jako momuŋ kiru pakereru dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Oŋu ebuŋyoŋ, Moro Tiriineji Stiwende maŋ puseko jiŋoine Sombuŋgo pime ropeko Yesu Anuture kuririquraŋ maŋgo paibe Anuture me furoineo dimako ŋoneya. ");
INSERT INTO mlh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yesu ŋoneru miya, “Maneniŋ! Sombuŋ aŋgame Sombuŋ eru morende Ŋi foriineji Anuture me furoineo dimako ŋonego.” ");
INSERT INTO mlh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Oŋu miko maneru oŋga jojorabi fonuŋ yasogo pakereme kajeyaŋuŋ meyaŋunji bojigaru sosowoji riŋaru raru qafagaru robuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Oŋu roru taoŋ qaŋaŋineo furugaru raru sakibe ruaru koji fuŋgaru bokeru qabuŋ. Oŋu qabi goineji oi ŋoneru dimaku marikuyaŋuŋ qomukuru bonusuŋgaru ŋi jeŋoŋ Solre bembeŋgo ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Oŋu eru koji bokeru qaki akoŋ dimabi Stiwenji Anuture oŋga wosiru iŋi miya, “O Ofoŋ Yesu, go iirune roru sabare!” ");
INSERT INTO mlh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Oŋu miku rakaru dikanji keru oŋga jojoraru miya, “Ofoŋ, agiburaŋ yo egobi, ore yobiŋ yoŋore paio so ruaigoŋ!” Oŋu miku niniŋgaru komeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stiwen qabi komeya, oi Solji oŋuakoŋ maneme sagaya. Damaŋ oo akoŋ kekesuesue soguine fukeko Jerusalem sitire maŋkekerisie kubu rosi eyarebuŋ. Ore eru yoŋoji sosowo siti bokeru roiŋgaru Judia eru Samaria prowins yoyoka oi sagaru rabi aposol yoŋoji akoŋ yameŋ keku sitio gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ŋiŋigo Anutu araŋ baku ohowe baku gobuŋ, yoŋoreone goineji Stiwen komeya ore jiŋgeŋ keku kokoine kuyoku qoŋgbuŋine roru raru yaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yaŋgabuŋyoŋ, Solji maŋkekerisie kufufuŋ qaima eyareru piine piine roregaru roperu maŋkekerisie ŋi eru ŋigo furugaru oga yabeme boke yaberu wakibi miko witi pigo rua yabebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Maŋkekerisie ŋiŋigoji roiŋgaru moreŋ so ra wareru roregaru gobuŋ, yoŋoji Bobiaŋ Biŋe miku oo ŋiŋigo maŋyaŋuŋ bapakareru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipji Samaria prowinsre siti mogo rakaru Munaŋqoqo Rauine Kristore fuŋne mitaniŋga yareko manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Oi mitaniŋga yareru mosi qoqowirie bako qowirieko ŋiŋigo kubu yoŋoji oi ŋoneru buŋo miya, oi maŋmoakoŋ eru kaje ruaru maneru sabarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filipji gio bako Anuture usunji gemokaku kokoine oi ŋiŋigo maŋyaŋuŋgone yobe yabeya. Yobe yabeko buŋo sembeqambeine oŋgaku waperu rabuŋ. Gio bako ŋiŋigo boakoŋ mobeyaŋuŋ komekiine fukeru demba gobuŋ, oi fiabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Oŋu fukeko Samaria sitio jeribari ropekiine fukeru peya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jeribari peyayoŋ, Samaria siti oo kipe seroŋ ŋi mo tinaine Saimon goya. Iŋoji gosa goine agikeareko munaŋqoqo gio baku Samaria ŋiŋigo warega yabeko gobuŋ. Oŋu gobi “Ŋi ropekiine fukego,” miku iŋoyoŋunde maneko ropeya. ");
INSERT INTO mlh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ŋiŋigo ropekiine eru wakiqoqoine yoŋoji sosowo Saimonde buŋore kaje ruaru maneru iŋi miku gobuŋ, “Anuture usuŋ tinaine ‘Usuŋ yasogo,’ migobi, oiji ŋi iŋore maŋgo rakame pega.” ");
INSERT INTO mlh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Saimonji agikeareko munaŋqoqo gio oi damaŋ joroine bako ŋiŋigoji waragaru gobuŋ. Oŋu eko waragaru gobuŋ ore eru iŋoreo qakatoru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Oŋu gobuŋyoŋ, Filipji wareru Anuture qorumaŋgo ropeiŋgo ore Bobiaŋ Biŋe eru Yesu Kristo tinainere fuŋne oi mitaniŋga yareya. Oi mitaniŋga yareko ŋiŋigo kokoineji Biŋe buŋo manesiŋ garu maŋyaŋuŋ kerisiebi miti meso rau yareya. ");
INSERT INTO mlh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Oŋu ruabi Saimonji oŋuakoŋ buŋo oi manesiŋ gako miti meso rau tebi Filipre maŋfuŋgo wareru goku yobeya. Oŋu fukeme Filipji mosi qoqowirie soi yasogo yasogo bako fukeko oi ŋoneru waragaru goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria ŋiŋigoji Anuture Biŋe buŋo oŋu maneru roru sabarebuŋ, ore biŋeji saueru Jerusalem sitio rako aposol yoŋoji manebuŋ. Yoŋoji oi maneru Pita eru Jon roosoeru sore yapebi yoŋoreo rabu. ");
INSERT INTO mlh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Raru roperu yoŋore eru oŋga wosiru Moro Tiriineji maŋyaŋuŋgo rakaiŋ ore Ofoŋ weu tebu. ");
INSERT INTO mlh_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Fuŋne iŋi ore weu teru oŋga wosibu: Yoŋoji Ofoŋ Yesure tinao miti meso rau yarebuŋyoŋ, Moro Tiriineji yoŋoreone more maŋgo so rakame mo gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ore eru oŋga wosiru meyakuŋ qoruyaŋuŋgo ruabire Moro Tiriineji maŋyaŋuŋgo rakame robuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aposol yokoji meyakuŋ ŋiŋigo qoruyaŋuŋgo ruabire Anutuji ore so Moro Tiriine yoŋore maŋgo ruame Saimonji oi ŋoneru moneŋ roru wareru iŋi yasiya, ");
INSERT INTO mlh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ŋoko usuŋ oŋuine oi noŋ mo narebire roru mene uri yoŋore qoruo ruabemiŋ, Moro Tiriineji yoŋore maŋgo rakaiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Oŋu yasiyayoŋ, Pitaji iŋi ojiya, “Ae! Use! Goji Anuture yauŋ oi monenji furiine baiŋ ore mige. Ore eru go moneŋgoke misi korugo rakaigoŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Gore manji Anuture jiŋoo so poretiŋgaga. Ore eru go Biŋe buŋo yoore fori mo so yobu roigoŋ. ");
INSERT INTO mlh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Sembenegoone bio maŋgo kerisieru Ofoŋ oŋga wosinde iŋoji maŋmamanegore agiburaŋ oi bokena. ");
INSERT INTO mlh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gore manji jajabame beumoki oŋuine pougaru fuse garega. Agiburaŋgoji nigiŋ oŋuine qukarie gume quŋgage.” ");
INSERT INTO mlh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pitaji oŋu ojime kipe seroŋ ŋi Saimonji iŋi bokirie yateme, “Ŋoko nonde eru Ofoŋ oŋga wosibu buŋo migobire, ore fori mo so fuke narena.” ");
INSERT INTO mlh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aposol yokoji Ofonde Biŋe buŋo oi siti oo kitiŋgaku miku mitaniŋgaru boke yaberu rabu. Kadio raru Samaria prowinsre kaeine kaeine roregaru ŋiŋigo maŋyaŋuŋ Bobiaŋ Biŋe buŋoo bapakare yaberu goku Jerusalem sitio kirieru rabu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ofonde mimerereŋ moji Filip buŋo iŋi ojiya, “Go Jerusalem siti bokeru Saut obe raigoŋ. Moreŋ buroineo kadi eseine (raŋgbaŋine) Gaza taoŋgo rakaegobi, oo raigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Oŋu ojime Filipji afagaru bokeru raya. Raru Afrika ŋi moji moreŋineo kirieru rako kadio bofukeya. Iŋoji Etiopia kantrire kandasi kwinde muraŋ ropekiine fukeru ŋigo koitore morumboŋ pigo moneŋ eru mebo yaine siŋaŋ garu goya. Sakiinere yare eru Juda ŋi fukeiŋgo ore embimbiŋgayayoŋ, jibu Anuture ohowe baku miteŋ gaiŋgo ore Jerusalem sitio wareya. ");
INSERT INTO mlh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wareru moreŋineo kirieiŋgo ore kaneŋkuku keretao ropeme kaneŋkukuji porebi kadio raya. Oo raru kajeqouŋ ŋi Aisaiare buk qorumureru oseru ŋeya. ");
INSERT INTO mlh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Oŋu fukeko Moro Tiriineji Filip saŋu qa teru buŋo iŋi ojiya, “Go kaneŋkuku kereta ore qaŋaŋgo raru boyoberu raigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Moro Tiriineji oŋu ojime oo akoŋ giniŋgaru bembeŋgo raya. Raru ŋiji kajeqouŋ ŋi Aisaiare buk oone Biŋe buŋo oseko maneya. Maneru iŋi weu teya, “Buŋo osege, oi soine mane taniŋgage me mata?” ");
INSERT INTO mlh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Weu teko ojiya, “Moji so mitaniŋgako nake oi uruŋu mane taniŋganobo?” Oŋu ojime kaneŋkuku keretao ropeme moko ŋebu. ");
INSERT INTO mlh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Biŋe Quraŋ oseya, oi iŋi, “Ŋiji lama qaku ketigaiŋgo ore roru oga gagobi, oi ore so waigo fosikeru peya. Siŋaŋineji lama madeinere siki pudaji botigame keririŋineo niniŋgaru fonuŋine tomiri dimaga, iŋore so iŋoji so oŋga rurugaya. ");
INSERT INTO mlh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Roru waki tebi moji buŋo koroineo buŋore mobe so kitiŋgaku miko mo kosa mitaribuŋ. Moreŋgo gogoine oŋu oga tegabi komeya. Osigidapuine tomiri komeya. Ore eru moji tina buruine jiki so oseru miiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Muranji oi oseru Filip iŋi weu teya, “Kajeqouŋ ŋiji buŋo oi more miga? Oi iŋoyoŋunde me ŋi more miga? Go soine ore fuŋine naji.” ");
INSERT INTO mlh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Oŋu weu teme kajeqouŋ yoŋore Biŋe Quraŋgone fuŋgaru Yesure Bobiaŋ Biŋe oi fuŋneineke mitaniŋgako maneya. ");
INSERT INTO mlh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Oŋu mimane eku kadio raru obu bembeŋgo ropebire kwin muraŋineji ojiya, “Ŋone, obu jereŋine yo pega. Ore eru go soine miti meso rau nareigoŋ. Buŋo moji sabare guga me mata?” ");
INSERT INTO mlh_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Oŋu ojime Filipji miya, “Go buŋo gajigo, oi maŋgo sosowo Anutureo ruaru manesiŋ gage ine, oi soine ebemiŋ.” Miko buŋo iŋi bokirieya, “Yesu Kristoji Anuture Made fukega, nonji oi manesiŋ gago.” ");
INSERT INTO mlh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Oŋu bokirieru mitigako kaneŋkuku kereta kipebi yokomoko akoŋ obuo rakaru Filipji miti meso rauteya. ");
INSERT INTO mlh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Oi rauteko obuone wapebire Ofonde Moro Tiriineji Filip ogagame roperu jibugame kwin muraŋineji oi moke so ŋoneya. So ŋoneyayoŋ, jikigaru jeribari paio kae moreŋineo Etiopia raya. ");
INSERT INTO mlh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipji jibugaru raru taoŋ tinaine Asdod oo fukeko bofukebuŋ. Oo akoŋ jikigaru taoŋine taoŋine roregaru oo Bobiaŋ Biŋe buŋoji ŋiŋigo maŋyaŋuŋ bapakareru raru goku Sisaria taoŋgo wapeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Damaŋ botuine oo Solji manjo paio dimaku maŋ sakiine boruŋ igogako Ofonde kiŋariŋpuine yaberu yobe imo eru goya. Oŋu goku soriŋ gio siŋaŋ qoruine iŋoreo raya. ");
INSERT INTO mlh_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Iŋoreo raru iŋi bapakareru weuya, “Kadi gariine boyoberu gobuŋ, yoŋoreone goineji joroineo Damaskas sitio gogobi. Ore eru nonji soine aroo raru baa yaberu mo bofukebemiŋ, oi kiperu ogagaru Jerusalem sitio warebemiŋ. Damaskas sitio Juda niŋore oŋgawowosi pi siŋaŋ gaegobi, yoŋoji oi egu sabare yabenimiŋ ore mimitari quraŋ quraŋgaru narende roru raru yadubemiŋ.” Oŋu miko quraŋgako roru raya. ");
INSERT INTO mlh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kadio ragu ragu Damaskas siti bombeŋgaiŋgo eko ya mo pipa iŋi fukeya: Kuririquraŋ mo Sombuŋgone bobori oŋuine fukeru wakiru roregaya. ");
INSERT INTO mlh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Roregako rondiŋgaru moreŋgo rakaru peku fonuŋ mo maneko buŋo iŋi ojiya, “Sol Sol, go wamore kekesuesue paio enarege?” ");
INSERT INTO mlh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Oŋu ojiko Solji weu teru miya, “Ofoŋ, go moji?” Oŋu miko bokirieya, “Noŋ Yesu kekesuesue paio enareege, noŋ oi. ");
INSERT INTO mlh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Oi fukegoyoŋ, soine pakereru sitio raigoŋ. Oo raru wamo yago bamiŋ, moji ore biŋe gajiiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ŋi iŋoke rabuŋ, yoŋoji buŋoyaŋuŋ mataeme fosikeru dimabuŋ. Yoŋoji buŋo fonuŋ fofori manebuŋyoŋ, ŋi mo so ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Buŋo bokirieme Solji moreŋgone pakereyayoŋ, jiŋoine piku ya mo so ŋoneru qaŋgoqasa qaku dimaya. Oŋu dimako meineo roru Damaskas sitio ogagaru rabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Rakabi una yokaomo ore so qaŋgoqasa ŋeku obu me uqo mo so nogu mo ŋeya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskas sitio Yesure kiŋariŋ mo tinaine Ananaias goya. Ofonji qohoŋ odume iru ŋoneme “Ananaias!” oŋgaya. Tinaine oŋgame miya, “O Ofoŋ, noŋ yo ŋego.” ");
INSERT INTO mlh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Oŋu miko Ofonji iŋi ojiya, “Go pakereru kadi tinaine Kadi Poretiŋ miegobi, oo raigoŋ. Oo raru Judasre pigo roperu Tarsus ŋi tinaine Sol iŋore weuteigoŋ. Mane, iŋoji noŋ oŋga wosi nareru ŋega. ");
INSERT INTO mlh_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Oŋga wosiru ŋeku maŋineo qohoŋ iru mo iŋi ŋoneya: Ŋi tinaine Ananaiasji piinere maŋgo waperu jiŋoine moke piiŋ ore meine qoruineo baiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ofonji buŋo oŋu ojime iŋi bokirieya, “O Ofoŋ, ŋiŋigo kokoineji ŋi ore sunduine miforebuŋ maneboŋ. Iŋoji Jerusalem sitio gore kufufuŋpu gbagbataeŋine oi kokoine yaberu yobe imo eru goya. ");
INSERT INTO mlh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Soriŋ gio siŋaŋ qoruine yoŋoji maŋgo eku usuŋ otebi Damaskas siti yoo oŋuakoŋ gio oi akoŋ baiŋ ore wareya. Ŋiŋigo gore tina oŋga wosiegobeneŋ, iŋoji niŋo sosowo noreru kipe nobeiŋgo manega.” ");
INSERT INTO mlh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Oŋu bokirieyayoŋ, Ofonji iŋi ojiya, “Nonji ŋi oi roosoeru manebe buŋone osigaru nonde jigo qaku goiŋ. Oŋu goku moreŋine moreŋine roregaru nonde Biŋe misaueme Israel eru kotu kantri ŋiŋigoji maneenimiŋ. Buŋo koroine koroine oo porebi ŋi ofoŋ kokoine yoŋore jiŋoyaŋuŋgo roperu nonde Biŋe yajiko manenimiŋ. Ore eru jibu raigoŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Iŋoji tinane osigaru ore eru joiserereŋ kokoine maneiŋ. Nonji oore buru odubemiŋ ore manego.” ");
INSERT INTO mlh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Oŋu ojime Ananaiasji raru pi ore maŋgo roperu meyokaine Solre qorugo baru ojiya, “Sol ogone, kadi yasogoo warende Yesuji fuke gareya, Ofoŋ oiji sore nume warego. Gore jiŋoji moke tiŋame Moro Tiriineji maŋgo puseiŋ ore najime warego.” ");
INSERT INTO mlh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Oŋu ojime oo akoŋ ya garaineke kamasi oiji jiŋoineone rondiŋgaru waki foreko jiŋoine tiŋaya. Jiŋoine tiŋako pime tamaeko pakereya. Pakereru miko miti meso rau teya. ");
INSERT INTO mlh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Miti meso rau teko uqo nogu sanaŋgaya. Solji sanaŋgaru kiŋariŋ yoŋore botugo Damaskas sitio giobobo goine goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Gogu oone pakereru Juda yoŋore oŋgawowosi piine piine oo roperu Yesure fuŋne mitaniŋgaru ŋiŋigo maŋyaŋuŋ bapakareru iŋi yajiya, “Yesuji Anuture made fukega.” ");
INSERT INTO mlh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Oŋu yajiko maneru sosowo yoŋoji popureru waragaru mibuŋ, “Jerusalem sitio tina oi oŋga wosibi, ŋi yo oo oi yabe yobe imo eru goya me mata? Oŋuakoŋ yo oo wareya, oi niŋo kipe noberu oga noberu soriŋ gio siŋaŋ qoruine yoŋore meo rua nobeiŋgo wareya. Ore eru uruŋu qowirieru iŋoyoŋe Anuture buŋo oi akoŋ kitiŋgaku miega?” ");
INSERT INTO mlh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Oŋu mibuŋyoŋ, Anutuji Sol usuŋ suŋsuŋ oteko moke sanaŋgaru goya. Sanaŋgaru goku Juda ŋiŋigo Damaskas sitio gobuŋ, yoŋore maŋ bapakareru iŋi miku goya, “Yesuji fofori Anuture Munaŋqoqo Rauine Kristo fukega.” Buŋo oi misanaŋgaru fuŋine oduru goko yoŋoji qiqu qaku buŋo oi kepieiŋgo embimbiŋgaru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Giobobo kokoine tariko Juda yoŋoji tumaŋgaru buŋo gio baku Sol qabi komeiŋ ore soŋsoŋburu babuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Soŋsoŋburu babuŋyoŋ, ore biŋe oi Sol kajeineo rakame maneya. Solji Damaskas siti bokeiŋgo eko oo qabi komeiŋ ore siti sa mendigo iŋore una ubu jiŋo siŋaŋ rubaku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Oŋu rubaku gobuŋyoŋ, kiŋariŋpuineji ubu mogo jambe (simemeŋ) soguine roru niginji kiperu Sol jambeo ruaru siti sare kimboŋgo ruabi rakaru raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Solji raru Jerusalem sitio roperu Yesure kiŋariŋpu yoŋoke esoigaru jikigayayoŋ, sosowo yoŋoji Sol kiŋariŋ fukeru goya, oi so manesiŋ gabuŋ ore eru iŋore kokoi manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kokoi manebuŋyoŋ, ŋi tinaine Barnabas iŋoji ogo eteku siŋaŋ gaku ogagaru aposol yoŋoreo raru oduru sunduine iŋi mitaniŋga yareya, “Sol ŋi yo oiji kadio wareme Ofonji fuke teme ŋoneme buŋoine ojime eru jiki Yesure tina oi Damaskas sitio mitaniŋgaru maŋyaŋuŋ sanaŋine bapakareru goya.” ");
INSERT INTO mlh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Binaŋine oŋu mitaniŋga yareko yoŋoke jikigaru Jerusalem siti maŋineo roregaru koimo dimaku Ofonde tina totogo oŋgaku ŋiŋigo maŋbapakare sanaŋine eyareku goya. ");
INSERT INTO mlh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Oi eyareme goku Juda ŋiŋigo Grik buŋo maneru gobuŋ, yoŋoke mimane eku migoqara buŋo babokiri eyayoŋ, yoŋoji Sol yameŋ keku qabi komeiŋ ore manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Oi esoigabi ogopuineji Sol bofukeru ogagaru Sisaria taoŋgo raru dimaku sorebi iŋoyoŋe akoŋ jikigaru fufuke taoŋine tinaine Tarsus oo raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Solji maŋine kerisieme ore ŋadiineo maŋkekerisie kufufuŋ sosowo Judia, Galili eru Samaria prowins sagaru gobuŋ, yoŋoji womo bofukebi Moro Tiriineji oi basanaŋ yaberu kitiŋ yabeko gobuŋ. Oŋu qojugaku Ofonde buŋo egu odurenimiŋ ore kokoiyaŋuŋ maneru gio babi maŋkekerisie kufufuŋyaŋuŋ sogueru saueme gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitaji kaeine kaeine roregaru Yesure kufufuŋ gbagbataeŋine ŋone yaberu raru goku damaŋ mogo taoŋ tinaine Lida oo ropeya. ");
INSERT INTO mlh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Roperu oo ŋi mo tinaine Ainias bofukeya. Mobeine komekiine fukeko ŋeŋeo akoŋ peku gome gosa 8 tariya. ");
INSERT INTO mlh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pitaji oi bofukeru iŋi ojiya, “Ainias, Yesu Kristoji go bobiaŋ guga. Ore eru go pakereru ramegaripepego roru qojugaigoŋ.” Oŋu ojime oo akoŋ pakereya. ");
INSERT INTO mlh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Oŋu fukeme Lida eru Saron ŋiŋigo sosowo yoŋoji oi ŋoneru maŋyaŋuŋ kerisieru Ofonde qakatobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa taoŋgo kiŋariŋ ŋigo mo tinaine Tabita goya. (Tina oi Grik buŋoo Dorkas, noŋunde buŋoo megiŋ, Iŋklis buŋoo deer.) Iŋoji damaŋ so gio fiine fiine baku yauŋ boakoŋ boroiŋgaru ŋiŋigo wakiqoqoine bapi yaberu goya. ");
INSERT INTO mlh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pitaji kae oo gome Tabitaji damaŋ oo jibe fuke teko komeya. Komeko qoŋgbuŋine jureru roru pi maŋine mogo roperu ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida oi Jopa taoŋ bembeŋgo ŋeya. Ore eru Pitaji Lida goya, kiŋariŋ yoŋoji oi maneru ŋi yoyoka sore yapebi raru Pita iŋi weu tebire, “Go pipa warende nikoke Jopa taoŋgo rakimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Weu tebire oo akoŋ afagaru yokoke rabuŋ. Raru ropebi qoŋgbuŋ pi maŋgo peya oo ogagaru ropebuŋ. Ropebi ŋigo koje sosowo Pita roregaru kuyoku Dorkasji yoŋoke goku kambaŋ mariku gboduru yareya, oi odubuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Odubuŋyoŋ, Pitaji miko sosowo yoŋoji raka forebi dikanji keru oŋga wosiya. Oŋga wosi foreru qoŋgbuŋ mai garu iŋi ojiya, “Tabita, go pakere.” Oŋu ojime jiŋoine piku Pita ŋoneru pakereru ŋeya. ");
INSERT INTO mlh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ŋeko Pitaji meineo roru bopeŋgame pakereru dimaya. Dimako maŋkekerisie ogopuine eru ŋigo koje oŋga yareme ropebuŋ. Ropebi komegone gboreru pakereya, ŋigo oi jiŋo maiyaŋuŋgo ruame ŋonebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ore biŋe buŋo oi Jopa kae maŋineo pi so rako maneru ŋiŋigo kokoineji fuŋgaru Ofoŋ manesiŋ gabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pitaji Jopa oo giobobo goine jikigaru goku Saimonde pigo ŋeku peya. Ŋi oi kufu komoŋ banimiŋ ore bulmakao sakiine pujeku jureru bobiaŋgaru goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Taoŋ tinaine Sisaria oo mamari siŋaŋ kotuine mo tinaine Kornilius goya. Iŋoji mamari kubu mobeine mo tinaine “Italire mamari kubu” mibuŋ, oo mamari ŋi 100 yoŋore siŋaŋ goya. ");
INSERT INTO mlh_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Iŋoji garikiŋpuine sosowo yoŋoke Anutu araŋ baku ohowe baku miteŋ gaku gobuŋ. Oŋu gokabi Juda ŋiŋigo wakiqoqoine yoŋore yauŋ boakoŋ yareku Anutu jijiki oŋga wosiru goya. ");
INSERT INTO mlh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Iŋande mogo 3 kilok ore so fukeko Ofonji Kornilius qohoŋ odume iru mo ŋoneya. Iru oi poretiŋ ŋoneru oo Anuture mimerereŋ moji piineo ropeko ŋoneya. Mimerereŋ oiji roperu “Kornilius!” miku tinaine oŋgaya. ");
INSERT INTO mlh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Oŋu oŋgame mimerereŋ bibitatara eru sombuine maneru ojiya, “Sogunene, wamore yo warege?” Oŋu ojime bokirieya, “Go oŋga wosiru gokande buŋogo Anutureo ropeko maneko fiine fukega. Go ŋiŋigo wakiqoqoine yauŋine yauŋine boroiŋgaru yareege, oi Anutuji maneru sabareku gore manesuku sore nume warego. ");
INSERT INTO mlh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ore eru muŋambe yo kiŋaŋ ruande Jopa taoŋgo rako ŋi tinaine Saimon, tinaine mo Pita migobi, oi ogagaru wareinebi. ");
INSERT INTO mlh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Iŋoji joma sakiineji gio bobo ŋi tinaine Saimon iŋore pigo koe qaŋaŋgo goga.” ");
INSERT INTO mlh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Sombuŋ mimererenji Kornilius buŋo oŋu ojiru bokeru raya. Bokeru rako kiŋaŋqoqo yoyoka oŋga yateme warebu. Warebire ujeine mamari ŋi mo bembeŋgo yameŋ keku Anutu mokoyakuŋ araŋ baku gobu, oi oŋuakoŋ oŋgame wareya. ");
INSERT INTO mlh_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Warebi mimererende buŋo oi sosowo yajiru sore yabeme Jopa taoŋgo rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ŋi yoŋoji kadio rakabi kae fureme taoŋ bombeŋgabi una botuine oo Pitaji pi maŋine mo paibe oo roperu dimaku oŋga wosigaya. ");
INSERT INTO mlh_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dimaku oŋga wosiru uqore komeru ya noiŋgo ore maneru miko rigabuŋ. Rigabi damaŋ oo Ofonde kobiji qame ŋeku qohoŋ iru mo iŋi ŋoneya: ");
INSERT INTO mlh_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Sombunji aŋgame ya soguine mo wakiya. Ya oi kambaŋ yagaŋine soguinere kamasi oŋuine fukeya. Mimerereŋ yoŋoji ya ore guruine 4 oi roru kitiŋganobuŋ, ore kamasi oŋuine moreŋgo wakiya. ");
INSERT INTO mlh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ya ore maŋineo joma fuŋne fuŋne ŋebuŋ. Joma goineji kufu 4:ji oderu raegobi. Goineji beuyaŋunji peperu raegobi. Oŋuakoŋ weboine weboine sowoo fururu qaru raegobi, ya oŋuine oŋuine oi kambaŋ ore maŋgo moko wakibuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Wakibi oo mara mo fukeru buŋo iŋi ojiya, “Pita, go pakereru ya yo qaku rigaru noigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Oŋu ojiyayoŋ, Pitaji miya, “O Ofoŋ, oŋu mata yobu! Oi sowoineke. Noŋ damaŋ mogo ya wuwunuŋineke oi so noboŋ. Noŋ ore eru mamagi manego.” ");
INSERT INTO mlh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Oŋu ojime buŋo oiji moke fukeru iŋore miya, “Anutuji ya miku keririkeko pega, goji ore tinaine wuwunuŋineke oŋu so miigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ya oŋuine oi moke fukeko ateine yokaomo fukeya. Ateine yokaomo fukeko oo akoŋ kambaŋ oi moke porebi Sombuŋgo ropeya. ");
INSERT INTO mlh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pitaji qohoŋ iru oi ŋoneru ore fuŋinere qiqu qaku maneiŋgo maneru esegaru ŋeya. Oŋu ŋeko damaŋ oo akoŋ Korniliusji ŋi sore yabeme wareru Saimonde pi baaru ore weweu eku bofukeru waperu pi mendiineo dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Pi mendiineo dimaku iŋi miku weubuŋ, “Saimon tinaine mo Pita migobi, iŋoji pi yo oo goga me mata?” ");
INSERT INTO mlh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pitaji jikigaru qohoŋ iru ore fuŋinere maneru esegaru ŋeko Moro Tiriineji iŋi ojiya, “Mane, ŋi yokaomoji wareru go baa gugobi. ");
INSERT INTO mlh_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nonji ŋi oi sore yabebe yo waregobi. Ore eru muŋambe yo pakereru rakaru maŋyoka etaŋqataŋ bokeru yoŋoke raigoŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Oŋu ojime Pitaji ŋi yoŋoji rakaru yajiya, “Maneniŋ, ŋoŋo ŋi baagobi, nonji oi fukego. Ŋoŋo wamore waregobi?” ");
INSERT INTO mlh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yajime bokiriebuŋ, “Mamari siŋaŋ Kornilius oi ŋi poretiŋ fukega. Iŋoji Anutu ohowe baku miteŋ gaku goko Juda ŋiŋigo kubu sosowo yoŋoji araŋ ropekiine bateegobi. Anuture mimerereŋ tiriine moji fuke teru iŋi mitigako maneya, ‘Go kiŋaŋ eru Pita keporende pigoo roperu buŋo maŋineone miiŋ, oi kaje ruaru maneigoŋ.’” ");
INSERT INTO mlh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Oŋu bokiriebi furu yabeme pi maŋgo ropebi maŋgo eyareko aŋibaŋi ŋeku pebuŋ. Pebi kae fureme Pitaji pakereru yoŋoke raya. Jopa taoŋ oone ogo goine oga yabeme iŋoke moko rabuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Moko raru gioboboine moakoŋ peku raru goku Sisaria taoŋgo ropebuŋ. Ropebi Korniliusji yoŋore odigaru goya. Oŋu goku tifepuine eru ogopuine fiine oi kepore yabeko piineo tumaŋgaru ŋebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Roperu Pitaji pigo ropeiŋgo eko Korniliusji pakereru wakiru mijeri eteru kufuineo rakaru dabe teya. ");
INSERT INTO mlh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Dabe teyayoŋ, Pitaji meineo roru bopeŋgame pakereko iŋi ojiya, “Go pakere, noŋ oŋuakoŋ moreŋ ŋi fukego.” ");
INSERT INTO mlh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Oŋu ojime iŋoke mimane eku pi maŋgo ropebire ŋiŋigo kokoineji tumaŋgaru ŋebuŋ, oi ŋone yabeya. ");
INSERT INTO mlh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ŋone yaberu iŋi yajiko manebuŋ, “Ŋoŋo Juda ŋiŋigo niŋore fuŋne manegobi. Juda niŋo ŋiŋigo kotuine ŋoŋore pigo roperu ŋoŋoke aŋibaŋi ŋedima eere agi peko embimbiŋgaegobeneŋ. Oi embimbiŋgaegobeneŋyoŋ, Anutuji buŋoine mo naduru iŋi najiya, ‘Goji ŋiŋigo oi me oi yoŋore tina oi wuwunuŋ mamagiineke oŋu so miigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ore eru ŋoŋo kiŋaŋ eru kepore nubi nonji so qomuku wareru wapego. Waperu iŋi weugo: Ŋoŋo wamore kiŋaŋ ruaru kepore nugobi? Oi soine mibi manebemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Oŋu yajiko maneru Korniliusji bokirieya, “Noŋ iŋande mogo damaŋ yoo 3 kilok oo pineo ŋeku oŋgawowosi gio baku go wapebe muŋambe gioboboine 4 fukega. Oŋgawowosi gio baku goboŋ oo akoŋ ŋi mo sakikomoŋine kuririquraŋineke oiji fukeru maŋfuŋneo dimaya. ");
INSERT INTO mlh_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Maŋfuŋneo dimaku iŋi najiya, ‘Kornilius, go oŋga wosiru gokande buŋogo Anutureo ropeme maneko fiine fukega. Go yauŋine yauŋine ŋiŋigo wakiqoqoine boroiŋgaru yareege, oi Anutuji maneru sabareku gore manesuku sore nume warego. ");
INSERT INTO mlh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ore eru muŋambe yo kiŋaŋ ruande Jopa taoŋgo rako ŋi tinaine Saimon, tinaine mo Pita migobi, oi ogaru wareinebi. Iŋoji joma sakiineji gio bobo ŋi Saimon iŋore pi koe qaŋaŋgo ŋega.’ ");
INSERT INTO mlh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Oŋu najiya ore eru nonji oo akoŋ kiŋaŋ ruabe goreo warebuŋ. Goji buŋone maneru warege ore maŋne fiaga. Ofonji buŋo sosowo mimiŋ ore mitiga gareya, goji oi soine minde manekimiŋ. Niŋo sosowo muŋambe yo ore eru tumaŋgaru Anuture jiŋo maio yo ŋegobeneŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Korniliusji oŋu miko Pitaji fuŋgaru iŋi miya, “Aha! Anutuji ŋiŋigo goine so ŋoneaŋi yabeku goine so sure yabeegayoŋ, so moakonji osoe nobeega. Iŋore jiŋoo moji wuwunuŋineke so fukega. Nonji oi muŋambe yo fofori mane mukugo. ");
INSERT INTO mlh_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","“Oŋu matayoŋ, ŋiŋigo kubuine kubuine sosowo noŋunde botugo uri yoŋoreone moji Anutu ohowe baku miteŋ gaku eeboboineji kadi poretiŋ boyobega, iŋoji Anuture jiŋoo sagaga. ");
INSERT INTO mlh_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yesu Kristoji ŋiŋigo sosowo noŋunde Ofoŋ fukeru womo qa noreega, Anutuji Biŋe buŋoine oi Israel kufufuŋ niŋore ruame wareya. Biŋe oiji wareme niŋo ore Bobiaŋ Biŋeine mitaniŋgaru gogobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jonji ŋiŋigo maŋyaŋuŋ bapakareru iŋi miya, ‘Ŋoŋo bio maŋ-ŋaŋuŋ kerisiebi nonji miti meso rau ŋarebemiŋ.’ Oŋu miko ore ŋadiineo buŋo oi Galili prowinsgo fuŋgaru mibi saueru raru Judia prowinsgo roperu sosowo sagaya. Ŋoŋo oi mane foregobi. ");
INSERT INTO mlh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","“Anutuji Moro Tiriine Nazaret ŋi Yesure maŋgo keseme usuŋ biŋe gaku moreŋ so roregaru goya, oi iŋoke dimako raru ŋiŋigo ŋonemaiŋ eyareya. Sembene Rauineji ŋiŋigo tobiriineji kiperu furu yabeme rakabuŋ, iŋoji oi sosowo bobiaŋ yabe foreya. ");
INSERT INTO mlh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ya oi Juda niŋore moreŋgo eru Jerusalem sitio eba eku gokame yo botuineo gbedigaru qabi komeya. Niŋo oi sosowo ŋoneru kitiŋgaku miku munaŋ mogeine fukeru dimagobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Komeru peko gioboboine yokaomo fukeme Anutuji bogboreme pakereya. Pakereru ateine kokoine ŋiŋigo fuke yareya. ");
INSERT INTO mlh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","“Iŋoji ŋiŋigo kubu sosowo yoŋore so fukeyayoŋ, Anutuji ronekoŋ niŋo roosoe nobeko Yesuji komegone pakereru goya, damaŋ oo iŋoke buŋo mimane eku uqo munjaŋ nareŋgareŋ eku nogu gobeŋ, niŋore fukeko niŋo iŋore buŋo kitiŋgaku miku dimaegobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Oŋu dimabeneŋ Yesuji iŋi mitiga noreya, ‘Anutuji bapakare nuko nonji ŋiŋigo gogobi eru komebuŋ, yoŋore mimitari Rau fukego. Ore eru ŋoŋoji nonde fuŋnene oi ŋiŋigo kubu so yoŋoreo kitiŋgaku mitaniŋgaru goinebi.’ ");
INSERT INTO mlh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ŋiŋigo uri yoŋoji Yesu manesiŋ gaku tinaine oŋgaegobi, Anutuji buŋo oi maneru yoŋore agiburaŋ bokeru jureega. Ore fuŋine oŋu pega, oi kajeqouŋ ŋiŋigo sosowo yoŋoji kitiŋgaku mitaniŋgaru quraŋgabi pega.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitaji buŋo oŋu miku akoŋ dimako Moro Tiriineji ŋiŋigo kaje ruaru manebuŋ, yoŋore maŋgo rakaya. ");
INSERT INTO mlh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Anutuji Moro Tiriine yauŋine oi kotu ŋiŋigo yoŋore maŋgo oŋuakoŋ keseme rakaya, oi Pitare ogopuji ŋoneru popurebuŋ. Juda ŋiŋigo sakiyaŋuŋgo Anuture moge baku ketigabi maŋyaŋuŋ kerisieru Yesu manesiŋ garu Pita boyoberu wareru ŋebuŋ, yoŋoji popureru yoore eru waragabuŋ: ");
INSERT INTO mlh_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Yoŋoji kantri goine yoŋore buŋo furuine furuine fuŋgaru miku Anutu miteŋ gabuŋ. Ore eru waragabi Pitaji iŋi weu yareru miya, ");
INSERT INTO mlh_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Yoŋoji Moro Tiriine oi niŋoji ebeneŋ oŋuine sabareku biŋe gaegobi, oi manegobeneŋ. Ore eru oi soine miti meso rau yarekabeneŋ sagaiŋ. Oi ebeneŋ moji qomuku norena?” ");
INSERT INTO mlh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Oŋu miku mitiga yareko Pitare ogopuji dimaku Yesu Kristore tinao Kornilius garikiŋpuine miti meso rau yarebuŋ. Miti meso yarebi Pita sabarebi jikigaru giobobo goine yoŋoke goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kotu kantri yoŋoji oŋuakoŋ Anuture buŋo roru sabarebuŋ, ore sunduine oi aposol eru maŋkekerisie ogopuyaŋuŋ Judia prowins sagaru goku manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ore eru Pitaji Jerusalem sitio kirieru ropeme Juda sakiyaŋuŋgo Anuture moge baku ketigabi maŋyaŋuŋ kerisiebuŋ, yoŋoji mipemiriŋ eku mitebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Mi teru iŋi ojibuŋ, “Kotu kantri ŋi Anuture mogeke so gogobi, go wamore raru yoŋoke aŋibaŋi ŋeku uqo munjaŋ nomeŋ? Oi so sagaga.” ");
INSERT INTO mlh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Oŋu ojibi fuŋfuŋgaineone fuŋgaru ya fukeya, oi sosowo buruineke mitaniŋga yareru iŋi yajiya, ");
INSERT INTO mlh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nonji Jopa sitio goku oŋga wosibe Ofonde kobiji nuko ŋeku qohoŋ iru mo iŋi ŋoneboŋ: Sombunji aŋgame ya soguine mo wakiya. Ya oi kambaŋ yagaŋine soguinere kamasi oŋuine fukeya. Mimerereŋ yoŋoji ya ore guru 4 oo roku kitiŋganobuŋ, ore kamasi oŋuine nonde maŋfuŋgo akoŋ wakiru peya. ");
INSERT INTO mlh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Wakiru peko ya ore maŋineo poretiŋ ŋonebe joma fuŋne fuŋneji ŋebuŋ. Joma goine oi moreŋgo kufu 4:ji oderu raegobi. Goine rigaŋine joyaŋuŋke fukegobi. Goineji beuyaŋunji peperu raegobi. Oŋuakoŋ webo fuŋne fuŋne sowoo fururu qaru raegobi, ya oŋuine oi kambaŋ ore maŋineo moko wakibi ŋone yabeboŋ. ");
INSERT INTO mlh_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ŋone yabebe buŋo mo oŋuakoŋ fukeru iŋi najime maneboŋ, ‘Pita, go pakereru ya yo qaku rigaru no.’ ");
INSERT INTO mlh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Oŋu maneboŋyoŋ, nonji iŋi miboŋ, ‘O Ofoŋ, noŋ ore eru mamagiine manego. Ya sowo wuwunuŋineke oŋuine oi damaŋ mogo nonde mi bibigo so yoŋoya. Ore eru oi so yobu nobemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Oŋu mibe buŋo oiji moke Sombuŋgone fukeru iŋi najiya, ‘Anutuji ya miku keririkeko pega, goji ore tinaine wuwunuŋineke oŋu so miigoŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ya oŋuine oi ateine yokaomo fukeya. Oŋu fukeme ya sosowo oi moke porebi Sombuŋgo kirieru ropeya. ");
INSERT INTO mlh_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Roperu pikamaŋgaru damaŋ oo akoŋ Korniliusji Sisaria taoŋgone ŋi yokaomo sore yabeme nondeo warebuŋ, yoŋoji pi ŋebeŋ, ore mendigo dimabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","“Mendigo dimakabi Moro Tiriineji iŋi mitiga nareme maneboŋ, ‘Go maŋyoka etaŋqataŋ yoberu yoŋoke raigoŋ.’ Buŋo oi manebe maŋkekerisie ogopune 6 yoŋoji oŋuakoŋ Jopa bokeru noke Sisaria taoŋgo rabeŋ. Sisaria roperu mamari siŋaŋ iŋore pigo ropebeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ropekabeneŋ buŋo binaŋ iŋi ba noreya, ‘Mimerereŋ moji nonde pigo fukeko ŋonebe dimaku iŋi najiya: Go Jopa kaeo kiŋaŋ ruaru ŋi tinaine Saimon, tinaine mo Pita oi ogaru wareinebi. ");
INSERT INTO mlh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iŋoji wareru Biŋe buŋo miko go eru garikiŋpugoji oi manesiŋ garu maŋyaŋuŋ kerisiebi sosowo munaŋ qa yareko qowirieinebi.’ ");
INSERT INTO mlh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Sundu oi ba noreko nonji fuŋgaru Biŋe buŋo miboŋ. Oi mibe manebi Moro Tiriineji fuŋfuŋgaineo niŋore maŋgo rakaya, ore so kaje ruaru manebi yoŋore maŋgo oŋuakoŋ rakaya. ");
INSERT INTO mlh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Iŋoji rakame ŋonebe oo akoŋ Ofonde buŋo mo nonde mamaneo wapeme manesuboŋ. Buŋo oi iŋi, ‘Jonji obu omaineji rau ŋareyayoŋ, nonji Moro Tiriine maŋ-ŋaŋuŋgo ruaru oiji rau ŋarebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Niŋoji Ofoŋ Yesu Kristo manesiŋ gabeneŋ Anutuji yauŋine noreya, eru yoŋoji manesiŋ gabuŋ Anutuji yauŋine oi akoŋ yoŋore maŋgo oŋuakoŋ ruaya. Ore eru noŋ oŋuineji uruŋu Anutu usuŋ Rauine esoigaru igoga tenobo? Iŋoji oŋu eyareko nonji sabare teiŋgo embimbiŋgaboŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pitaji sunduine oŋu miko maneru maŋyaŋuŋ munaŋgako waigo fukeko Anutu miteŋ gaku iŋi mibuŋ, “Fofori, niŋo maŋnoŋuŋ kerisieru gogo sanaŋinere biŋe fukegobeneŋ manegobeneŋyoŋ, Anutuji kadi moakoŋ oi kotu kantri ŋiŋigo yoŋore oŋuakoŋ rua yareko pega. Oi muŋambe yo mane taniŋgaru mane mukugobeneŋ.” Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiwen qabi komeya ore eru sisikoŋkoŋ fukeko maŋkekerisie ŋiŋigoji roiŋgaru roregaru ra warebuŋ. Raru warebi goineji koe qaŋaŋineo Fonisia moreŋgo rabuŋ. Goineji koe petigaru nu tinaine Saiprus oo rabuŋ. Goineji Siria prowinsre siti tinaine Antiokia rabuŋ. Oŋu roiŋgaru rabuŋyoŋ, ŋiŋigo botuyaŋuŋgo Yesure Biŋe buŋo oi Juda ŋiŋigo akoŋ yajibi manebuŋ. Kotu kantri oi so yajibuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","So yajibuŋyoŋ, Saiprus eru Sairini ŋi goineji yoŋore botugo gobuŋ. Yoŋoji kotu moreŋgo sogueru Antiokia sitio waperu moreŋ rauine yoŋoke Grik buŋoo mimane eku Ofoŋ Yesure Bobiaŋ Biŋe oi oŋu Juda mata yoŋore oŋuakoŋ mitaniŋga yarebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Oi mitaniŋga yarebi Ofonji yoŋoke gome usuŋineji ŋiŋigo maŋyaŋuŋ bapakare yaberu kokoine yoŋoji Ofoŋ Yesu manesiŋ garu maŋyaŋuŋ kerisieru iŋoreo qakatobi kubuyaŋuŋ sogueru yasogo fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Oŋu fukeme ore biŋeji raru Jerusalem kufufuŋ yoŋore kajego rakame manebuŋ. Oi maneru Barnabas sorebi Antiokia sitio raya. ");
INSERT INTO mlh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Raru roperu Anutuji yauŋmoririine ŋiŋigo yareme fiabuŋ, oi jiŋoineji ŋoneru maneko ropeme jerieru uŋsowoŋine iŋi miya, “Ŋoŋo sosowo maŋ-ŋaŋuŋ qojugaru sanaŋgaru Ofoŋke qakatoru dimainebi.” ");
INSERT INTO mlh_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabasji ŋi fiine fukeko Moro Tiriineji maŋine puseko maŋyoka yoberu ŋadi gaku maŋine sosowo oiji Yesu manesiŋ gaku goya. Ore eru ŋiŋigo kokoineji maŋyaŋuŋ kerisieru Ofonde kubuo jikigabi sogueya. ");
INSERT INTO mlh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabasji Antiokia bokeru Sol baaiŋgo ore Tarsus taoŋgo raya. ");
INSERT INTO mlh_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Raru bofukeru ogame Antiokia sitio warebu. Wareru oo mokoyakuŋ gosa moakoŋ sosowo goku zioz gio baku maŋyaŋuŋ kerisiebuŋ, oi kubuine kubuine qaji yarebire ŋiŋigo kokoineji mamane roku maŋ wombuŋyaŋuŋgo ruabuŋ. Antiokia ŋiŋigoji fuŋfuŋgaine fuŋgaru kiŋariŋ tinayaŋuŋ Kristore ŋiŋigo (kristen, Kristore biŋe) miku gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Damaŋ oo kajeqouŋ ŋiŋigo goineji Jerusalem bokeru Antiokia sitio wakiru wapebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yoŋoreone mo tinaine Agabus oi pakereru Moro Tiriineji boburogame biŋe buŋo iŋi yajiya, “Roro yasogoji fukeru kaeine garebemiŋ sagaru peiŋ.” Oŋu miko ore so Sisa-kiŋ tinaine Klodius iŋore siŋaŋyayabe damaŋgo fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Oi fukeko kiŋariŋ yoŋoji qodureru maŋkekerisie ogopuyaŋuŋ Judia prowinsgo gobuŋ, oi kitiŋ yaberu qoqodure pesiŋ yasogo ruabi raiŋ ore buŋo kipebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Buŋo oi kipebi eru ore so fofori ruabuŋ. Yoŋoji moneŋ eru ya qojugaru Barnabas Sol yokore meo ruaru sore yapebi Jerusalem raru maŋkekerisie kufufuŋ yoŋore minebobopu ŋone yaberu yarebu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Damaŋ oo kiŋ Herodji maŋkekerisie kufufuŋ kekesuesue eyareiŋ ore maneru miko maŋkekerisie ŋiŋigo goine oga yaberu kipe yabebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kiŋ koitoji mitigako Jonde kakaine Jeims oi jigore siqo sogoji ketigabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Oŋu mitigako qabi komeko Juda ŋiŋigo goineji oi manebi fiine fukeko ŋoneya. Oi ŋoneru ore eru jikigaru miko Pita oŋuakoŋ roru kipebuŋ. Ya oi poroŋ yistine tomiri ore kombaŋ damaŋgo miko fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ore eru kiŋ koitoji iŋi miya, “Nonji ŋonemaiŋ kombaŋ tariko Juda yoŋore buŋo koroineo ruabemiŋ.” Oŋu miku mitigako witi pigo ruabuŋ. Ruabi mamari ŋi 16 yoŋoji botuyaŋuŋgo qoko 4 keku damaŋ qaqotiŋ ebi ŋi 4:ji una ubu jijiki dimaku siŋaŋ gaku gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita oŋu siŋaŋ gaku gobi witi pigo peyayoŋ, maŋkekerisie kufufuŋ yoŋoji jijiki iŋore eru Anutu yameŋ keku oŋga wosiru gobuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Oŋga wosiru gobi ŋonemaiŋ (Passover) kombaŋ tariko ubu oo mamari ŋi yoyokaji Pita gbedi (nigiŋ) yoyoka sanaŋine kipebire botuyakuŋgo kubaŋ peko eru ŋi joruyaŋuŋke goineji mendi ŋadiineo dimaku witi pi siŋaŋ babuŋ. Kiŋ Herodji kae fureme Pita ogagaru buŋo koroineo ruaiŋ ore manesuku buru ruame kubaŋ pebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kubaŋ pebuŋyoŋ, Ofonde mimerereŋ moji pipa fukeru Pitare keririŋgo dimako nigiŋ pire maŋine fure foreko Pitare tambaraŋineo qaku ojiya, “Go pipa pakere.” Oŋu ojime gbedi (nigiŋ) yoyokaji oo akoŋ Pitare meone mo qomukubu. ");
INSERT INTO mlh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Qomukubire mimererenji ojiya, “Bio kambaŋgo kiperu kufu komoŋgo ke.” Ojiko maneru oŋu eya. Oi eme jikigaru ojiko maneya, “Bio marikugo keru noŋ boyobe nuru ware.” ");
INSERT INTO mlh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Oŋu ojiko maneru pi maŋine bokeru boyobeya. Oi boyoberu rayayoŋ, mimererenji ya baya, oi fofori fukeya me mata, Pitaji ore eru maneko jijibu fukeya. Iŋoji kubaŋ peku kubaŋ ŋoneya, ore kamasi maneko fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pi maŋine bokeru mendi fuŋfuŋgaineo siŋaŋ baru dimabire, oi yatureru mendi mogo roperu yatureru petigaru raru witi pi sakiinere aeŋ dobuineo ropebu. Ropebire mendi yasogo sanaŋine oo iŋoyoŋe akoŋ mo aŋgame sakibe siti kadi siroŋgo rakabu. Rakaru kadi yasogo strit mo jikigaru rabire mimererenji pipa Pita bokeru jibugaya. ");
INSERT INTO mlh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jibugako Pitare maŋ tiŋame iŋi miya, “O Ofonji mimerereŋine soreme wareru Herodre meone bomuku nuga, oi manego. Juda ŋiŋigoji nonde sakigo ya fukeiŋ ore eru odigagobi, iŋoji ya sosowo oone nonde qoru kipega. Nonji muŋambe yo oi fofori mane mukugo.” ");
INSERT INTO mlh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Oŋu mane mukugo tamaeko Jonde maŋgo Mariare pigo obe raya. Jon iŋore tina mo Mak mibuŋ. Pi oo ŋiŋigo kokoineji tumaŋgaru Anutu oŋga wosiru gobuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Oŋu gobi Pitaji wareru korogo dimaku mendigo qaya. Mendigo qame kiŋaŋqoqo ŋigo tinaine Roda iŋoji wareru “Go moji?” miku weuya. ");
INSERT INTO mlh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Weuku dimaku Pitare maru mane mukuru “Ii-ia warege!” miku jerieru riŋaru mendi so roru pipa pi maŋineo roperu yajiya, “Pitaji wareru mendigo dimaga.” ");
INSERT INTO mlh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yajime maneru iŋore “Maŋgo jibukame mige,” mibuŋ. Mibuŋyoŋ, iŋoji qoru qaku “Buŋo foriine migo!” yajiya. Oŋu yajime mibuŋ, “Oi Pitare mimererenji dimaga.” ");
INSERT INTO mlh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Oŋu mimane ebuŋyoŋ, Pitaji mendi qaki akoŋ dimako roru ŋoneru popurebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Popurebi meineji soso eru kami enimiŋ ore miya. Miku Ofonji witi pigone ogaru sakibe wakiya, sundu oi yajiya, “Ŋoŋo biŋe yo bio bisop Jeims eru maŋkekerisie ogopunoŋuŋ goine oi yajibi maneinebi.” Oŋu yajiru boke yaberu kae mogo raya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kae fureko mamari ŋi yoŋoji Pita baaru “Uro kerekami keku jibugaru raga?” miku ore eru koŋkoŋ eru manebu soguine manebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodji oŋuakoŋ Pita bofukenimiŋ ore miko baaru esegaru so bofukebi ŋi joruyaŋuŋke Pitare siŋaŋ babuŋ, oi buŋo koroineo rua yaberu kokoine weu yareru mitariru ro yaberu yabebi komenimiŋ ore mitiga yareya. Ore ŋadiineo Judia prowins bokeru Sisaria taoŋgo rakaru oo goya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Fonisia prowinsre taoŋ tinayakuŋ Taia (Tiro) eru Saidon yoŋoji uqo gioyaŋuŋ banimiŋ ore embimbiŋgaru kiŋ Herodre kantri yoŋoreone uqo yayaŋuŋ furiine baku gobuŋ. Oŋu gobi Herodre maŋ rigaŋgame Taia Saidon rosi eyareru uqo munjaŋ yareniminde agi ruaya. Ore eru yoŋoji qodureru minebobopuyaŋuŋ sore yabebi qoko baku kiŋ Herod ŋoneiŋgo rabuŋ. Rakabi muraŋine tinaine Blastus morumboŋ piinere siŋanji oi rone ŋone yabeya. Ŋone yabeme ojibuŋ, “Niŋo buŋo miku posikekimiŋ womo fukeiŋ ore weu teiŋgo waregobeneŋ.” Oŋu ojiru miku bomiriŋ gabi yajiya, “Soine buŋoŋaŋuŋ basanaŋgaru ŋadiŋaŋuŋgo dimabemiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Oŋu yajime kiŋ koitoji buŋo bokirie yareiŋ ore damaŋ rau yareme oo tumaŋgabi iŋoyoŋunde saki basarigaru kiŋ ŋi koito marikuine keru morumboŋ ŋeŋeineo ŋeku jeri buŋo yajiya. ");
INSERT INTO mlh_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yajime ŋiŋigo kubu yoŋoji maneru iŋi miku oŋgabuŋ, “Buŋo oi Anuture buŋo. Oi moreŋ ŋire buŋo mata.” ");
INSERT INTO mlh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Oŋu oŋgabuŋyoŋ, kiŋ koitoji oŋu eru Anuture tinabiŋe mugaru so miteŋ gaku iŋoyoŋunde maneko ropeya. Ore eru Ofonde Sombuŋ mimerereŋ moji oo akoŋ qame umbenji ki ki raru kime komeya. ");
INSERT INTO mlh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Oŋu fukeyayoŋ, Anuture Biŋe buŋo oi miku gobi touŋmoririineke fukeru saueya. ");
INSERT INTO mlh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Antiokia siti yoŋoji Barnabas eru Sol kikitiŋ misin gio mo yatebuŋ, yokoji oi Jerusalem goku bomukubu. Oi bomukuru Jon tinaine mo Mak mibuŋ, oi ogaru moko Jerusalem bokeru Antiokia sitio kirieru warebuŋ. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokia sitio goineji maŋyaŋuŋ kerisieru maŋkekerisie kufufuŋ fukebi mineboboyaŋuŋ yo iŋiineji kajeqouŋ buŋo miku qaji yareru gobuŋ: Tinayaŋuŋ Barnabas eru Simeon tinaine mo Gogobu (Grik buŋoo Niger) eru Lusius (Sairini moreŋgone), Manaiŋ (iŋo koito gawana Herod iŋoke moko goku soguebu) eru Sol. ");
INSERT INTO mlh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Maŋkekerisie kufufuŋ yoŋoji Ofonde ohowe baku miteŋ gaku uqo sowo gobi oo Moro Tiriineji iŋi yajiya, “Nonji Barnabas eru Sol gio fuŋine mo banimi ore roosoe yapeboŋ. Ore eru ŋoŋoji oi mitariru sore yapebi rainebire.” ");
INSERT INTO mlh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Oŋu yajime oŋga wosinimiŋ ore uqo sowo goku meyaŋuŋ qoruyakuŋgo ruabi Ofonde usunji kefa yapeme sore yapebi rabu. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Moro Tiriineji oŋu sore yapeme moreŋ tinaine Selusia oo rakabu. Oo rakaru ogâo ropebire kambaŋ seri poreru gboromurebi gbinji kitiŋgako raru nu Saiprus ore wegi wawapeineo ropebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ropebi siti tinaine Salamis oo raru Juda ŋiŋigo yoŋore oŋgawowosi piine piine oo roperu Anuture Biŋe buŋo miku maŋ bapakare yabebu. Ŋi tinaine Jon oi oŋuakoŋ ogabire yokoke ra wareru ogo babapiyakuŋ goya. ");
INSERT INTO mlh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Oŋu goku nu sosowo roregaru petigaru aribe wegi rarakaineo Pafos sitio ropebuŋ. Oo roperu Juda ŋi tinaine Bar-Yesu bofukebuŋ. Iŋoji kipe seroŋ ŋi fukeru kajeqouŋ ŋi jijibuine goya. ");
INSERT INTO mlh_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kipe ŋi oi nu ore kiap tinaine Sergius Pol iŋore pigo ŋeku goya. Kiap oiji mamane-muku ŋi goya. Oŋu goku Anuture Biŋe buŋo maneiŋgo aŋi pe teko Barnabas Sol kepore yapeme iŋoreo warebu. ");
INSERT INTO mlh_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Warebu, Elimas, (kipe bobo ore tinaine Grik buŋoo oŋu miebuŋ,) iŋoji kiapji Anutu egu manesiŋ gaiŋ ore kiso eyateru kiap maŋine buŋoo bojibu baiŋ ore esoigaya. ");
INSERT INTO mlh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Esoigame Sol, tinaine mo Pol mibuŋ, Moro Tiriineji iŋore maŋ puseko Elimas poretiŋ ŋone mukuya. ");
INSERT INTO mlh_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ŋone mukuru iŋi miteya, “Yei! Eadu bobo ŋi, go Sembene Rauinere made fukege. Satanji maŋgo gufukopari sauesaueine egareko sakigo igo fuŋne fuŋne eru goege. Buŋo poretiŋ sosowore rosi fukeru Ofonde kadi poretiŋ boŋoriende kasigaega, oi bio bokemiŋ me? ");
INSERT INTO mlh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ore eru mane! Ofonji meine paigoo ruako usuŋineji kefaguko jiŋogo kobeko wegi tatama ŋoneiŋ ore embimbiŋgamiŋ. Iŋoji damaŋ baya ore so tiŋtuŋ qaku gomiŋ.” Mi teme oo akoŋ qisiriji paiineo wakiru kefagame dabu eme tiŋtuŋ qaku basiqasi eku ra wareru meineo banimiŋ ore weu teru meineo barubakamaŋ eya. ");
INSERT INTO mlh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ya oi fukeme kiapji oi ŋoneru Ofonde Biŋe buŋo mamaneinere waragaru manesiŋ gaya. Oŋu. ");
INSERT INTO mlh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Polji muraŋpuine yoŋoke Pafos moreŋ bokeru ogâo ropebi kambaŋ seri poreru gboromurebi gbinji kitiŋgako raru goku Pamfilia prowinsre siti tinaine Perga oo ropebuŋ. Oo roperu dimaku Jonji boke yaperu kirieru Jerusalem sitio wareya. ");
INSERT INTO mlh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kirieru wareyayoŋ, yokoji Perga siti bokeru jikigaru raru Pisidia prowinsre taoŋ tinaine Antiokia oo ropebu. Oo roperu Sabat kombaŋgo oŋgawowosi piyaŋuŋgo roperu ŋebu. ");
INSERT INTO mlh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ŋebire oŋgawowosi pire siŋaŋ yoŋoji Mosesre Kadi buŋo eru kajeqouŋ yoŋore Biŋe Quraŋ oseru kiŋaŋ ruabi wakiru iŋi weu yatebuŋ, “Ogoyokanoŋuŋ, ŋokoji buŋo mo kufufuŋ maŋnoŋuŋ bapakarenimi ore pega ine, oi soine mibire manekimiŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Oŋu weu yatebi Polji pakereru me bajiku iŋi miya, “Israel kotupunoŋuŋ eru moreŋ rauine niŋoke Anutu ohowe baku miteŋ gaegobi, ŋoŋo kaje ruaru maneniŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel ŋiŋigo kubu noŋunde ŋaso oi Anutu. Iŋoji fuŋqodupunoŋuŋ roosoe yabeko apa ŋasopunoŋunji Ijipt moreŋgo raru kotu fukeru gobuŋ. Anutuji damaŋ oo Israel ŋiŋigo kubu oi touŋmoriri yareme saueru tinabiŋeyaŋuŋke fukebuŋ. Oŋu fukebi Anutuji mosi qoqowirie baku usuŋine yaduru oo oga yabeme Ijipt kantri bokeru sakibe warebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","“Wareru goku moreŋ buroineo petigaru wareru eebobo sembene eba eku gobi Anutu maŋine rigaŋgame gosa 40 ore so maŋsembe maneru goya. ");
INSERT INTO mlh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Maneru goyayoŋ, jibu wareru goku Keinan moreŋgo wapebuŋ. Wapebi oo kufufuŋ kubu 7 yobe ketotie yaberu moreŋyaŋuŋ roku boroiŋgaru ŋasopunoŋuŋ rauine rauine fukenimiŋ ore biŋe qa yareya. ");
INSERT INTO mlh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Oŋu fukeme gosa 450 ore so raya. Ore ŋadiineo Anutuji mimitarire ŋi koitoine koitoine (Judge) bapakare yabeya. Oi bapakare yaberu go wapebi Samuelji fukeya. Iŋoji mimitarire ŋi koito tatariine fukeru kajeqouŋ ŋi goya. ");
INSERT INTO mlh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Samuelji fukeru gome damaŋ oo kiŋ koitore Anutu karieru weu tebi ŋi tinaine Sol yareya. Sol iŋoji Benjamin ŋaso yoŋoreone ŋi tinaine Kis iŋore made fukeya eru gosa 40 ore so kiŋ koitoyaŋuŋ goya. ");
INSERT INTO mlh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Oi goyayoŋ, Anutuji Sol qopieru tifeineo ŋi tinaine Deiwid kiŋ ŋi koitoyaŋuŋ fukeiŋ ore eru roosoeru igodoŋgaya. Igodoŋgaru fuŋine mitaniŋgaru iŋi miya, ‘Nonji Jesire made Deiwid bofukego. Iŋore maŋ osoeru manebe soine saga nuga. Iŋoji eeboboine sosowo oo nonde mi reŋgaru goiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Anutuji ronekoŋ Munaŋqoqo Rauine sore noreiŋgo ore miya, jojofo buŋo ore foriineji iŋi fukeya: Deiwidre osigidapu yoŋoreone ŋi tinaine Yesu fukeko Anutuji oi Israel kubu niŋore Munaŋqoqo Rau fukeru goiŋ ore igodoŋgaya. ");
INSERT INTO mlh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Yesuji so fukeko ronekoŋ oo Jonji wareru iŋi miku goya, ‘Ŋoŋo bio maŋ-ŋaŋuŋ kerisieniŋ. Maŋ-ŋaŋuŋ kerisiebi nonji miti meso rau ŋarebemiŋ.’ Oŋu miku Israel ŋiŋigo kubu sosowo maŋ bapakare yaberu goya. ");
INSERT INTO mlh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Oŋu goyayoŋ, iŋoji kaeoruŋ gioine ba foreiŋgo eru oo iŋi yajiya, ‘Ŋoŋo nonde uruŋu manesugobi? Ya manesugobi, nonji oi matayoŋ, maneniŋ, nonde ŋadio ŋi mo wareiŋ. Iŋoji wareme nonji iŋore keririŋgo wakiqoqoine gogo ore kopu kekereine ruberu kufu komoŋ nigiŋine pirueiŋ ore mane bibiebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“O ogopune, Abrahamde osigidapu eru moreŋ rauine ŋoŋoji niŋoke Anutu ohowe baku miteŋ gaegobi, Anutuji munaŋ qa noreiŋ ore Biŋe oi ruame niŋoreo warega. ");
INSERT INTO mlh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ore fuŋine oi iŋi: Jerusalem rauine eru siŋaŋpunoŋuŋ yoŋoji Yesure fuŋne so mane mukubuŋ. Kajeqouŋ yoŋore Biŋe Quraŋ Sabat kombaŋ so oseegobiyoŋ, ore fuŋine oi so mane taniŋgaegobi. Oŋu mutu gogobiyoŋ, jibu siŋaŋyayabe ŋipunoŋunji Yesu komeinde buŋo mitaribi kajeqouŋ ŋiŋigo yoŋore buŋo oi oŋuine oo foriineke fukeya. ");
INSERT INTO mlh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yoŋoji Yesu komere biŋe fukeiŋ ore so buŋo fuŋine baaru mo so bofukeru jibu ‘Kepieru!’ oŋgabuŋ. Oŋgaru Pailotji mitarime komeiŋ ore oŋgaku kariebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Iŋore buŋo sosowo quraŋgame pega, yoŋoji ore so ebi foriine fuke foreme Yesu yogone bomukuku wakiru jiŋoruŋgo raru ko kouŋ maŋgo ruabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ruabuŋyoŋ, Anutuji oi komegone bogboreme pakereya. ");
INSERT INTO mlh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Pakereme iŋoke Galili prowinsgone Jerusalem sitio warebuŋ, oi una giobobo kokoine fuke yareya. Ogopuine fuke yareya, yoŋoji damaŋ yoo ŋiŋigo botuyaŋuŋgo munaŋ moge oŋuine dimaku fuŋine kitiŋgaku mitaniŋgaru gogobi. ");
INSERT INTO mlh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Anutuji Juda apa ŋasopunoŋuŋ yoŋoke ya eiŋ ore buŋo miku kipeme niŋo yoŋore osigidapu fukebeneŋ buŋo raŋgbaŋine ore foriineji damaŋ yoo niŋore iŋi fukeya: Iŋoji Yesu bogboreme pakereru goga. Ore eru niŋoji ore Bobiaŋ Biŋe oi mitaniŋga ŋaregobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","“Anutuji Yesure buŋo miko Deiwidji maneme Miti kiki (Buk song) jare yoyoka oo iŋi quraŋgame pega, ‘Goji nakene made fukege, oi muŋambe ŋiŋigo yadube ŋone mukugobi.’ Iŋoji buŋo ore so Yesu bogboreme pakereya. ");
INSERT INTO mlh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yesu bogboreme komegone pakereru sanaŋgaru goku jiki moke so komeiŋ. Ore buŋoine Anutuji iŋi mime pega, ‘Noŋ yauŋmoririne kiŋ Deiwid oteru gobe gbagbataeŋine fukeru qaŋqaŋineke sanaŋgaru dimaya, ore so oi ŋoŋore mitari ŋarebemiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Deiwidji ore buŋo oi Miti kiki (Buk song) mogo oŋuakoŋ iŋi ruame pega, ‘Gakere yoro ŋi gbagbataeŋine oi so bokende komere yoŋgo so goregaiŋ.’ ");
INSERT INTO mlh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Niŋo kiŋ Deiwidre fuŋne manegobeneŋ: Iŋoji gogoine goku Anuture mi boyoberu gio oteya, oi ba foreru niniŋgame komeya. Komeko apa ŋasopuine yoŋore maŋfuŋgo yaŋgabi qoŋgbuŋineji peku goregaru mataeya. ");
INSERT INTO mlh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Deiwidji goregaru mataeyayoŋ, Anutuji ŋi bogboreme pakereya, iŋoji so goregaya. ");
INSERT INTO mlh_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Ŋi ogopune, ore eru buŋo yo maneniŋ: Anutuji Yesure eru agiburaŋ-ŋaŋuŋ bokeru jureiŋ. Niŋoji ore Biŋeine mitaniŋga ŋaregobeneŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Rone ‘Mosesre Kadi buŋo boyoberu oŋuine oo posiine fukekimiŋ,’ mibeŋyoŋ, oo oiji me oiji quŋgaru embimbiŋgaru gobeŋ. Oŋu gobeŋyoŋ, damaŋ yoo uri yoŋoji Yesu manesiŋ garu iŋoke qakatonimiŋ, Anutuji sosowo yoŋore buŋo mitarime posikenimiŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kajeqouŋ ŋiŋigoji buŋo miku quraŋgame pega, Anutuji ore so geoine bokirieme paiŋaŋuŋgo egu ropeiŋ ore kokoiŋaŋuŋ maneru sisiŋaŋ einebi. Buŋo oŋuine mo oi iŋi, ");
INSERT INTO mlh_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Nonji ŋoŋore gogo damaŋgo mosi qoqowirie fuŋine mo babemiŋ. Moji ore biŋe buŋo miko manenimiŋ, oi buŋo foriine fukeiŋ ore so manesiŋ ganobuŋ. Ore eru buŋo oi bawaki eru mipemiriŋ baegobi, ŋoŋo mo piku ŋoneru waragaru sibiriganimiŋ.’” ");
INSERT INTO mlh_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Polji oŋu miko Barnabaske oŋgawowosi pi bokeru wakibire goineji iŋi weu yatebuŋ, “Niŋo buŋo yo moke maneiŋgo manegobeneŋ. Ore eru oi Sabat kombaŋ mo paibe soine jikigaru mibire manenobeŋ.” ");
INSERT INTO mlh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Oŋgawowosi pigone wakiru roiŋgabi ŋiŋigo kokoineji Pol eru Barnabas ŋadiyakuŋgo boyobe yapebuŋ. Goineji Judaone fukebuŋ eru goineji kotu kantrione fukebuŋyoŋ, Juda yoŋoke jikigaru gobuŋ. Yoŋoji boyobe yapebi mimane eku uŋsowoŋ buŋo iŋi yarebu, “Anutuji yauŋmoriri ŋareya, oo qiŋ keru dimainebi.” ");
INSERT INTO mlh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabat kombaŋ mo wareru fukeya, oo taoŋ moreŋ ore ŋiŋigo oi qojugaru “Anuture Biŋe buŋo manekimiŋ,” miku waperu tumaŋgabuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Waperu tumaŋgabi Juda yoŋoji ŋiŋigo kubuine kubuine ŋone yaberu maŋyaŋuŋ rigaŋga foreya. Rigaŋga foreme Polre buŋo qaiŋgo ore migobobo eru noigoi miku igosisi eyatebuŋ. ");
INSERT INTO mlh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Oŋu eyatebi Pol Barnabas yokoji koimo sanaŋgaru dimaku buŋo iŋi mibu, “Anutuji gio noteya ore so Biŋeine rone Juda ŋiŋigo yajibeneŋ saganayoŋ, ŋoŋo oi ŋadi gaku kosa i