﻿USE sofia;
DROP TABLE IF EXISTS sofia.mle_vpl;
CREATE TABLE mle_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mle_vpl WRITE;
INSERT INTO mle_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kidiy duw, Jisas Krais, God dikidi Tasakwudidi Duw, dikidiy waraga duwadiy. Jisas dikidi waraga duw, David. David dikidi waraga duw, Aparam. ");
INSERT INTO mle_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aparam, Aysak dikidi asaay-ad. Aysak, Jakap dikidi asaay-ad. Jakap, Juwtawa dikidiy mwamugwawa nyamwusugw dayadi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juwta, Pirisawa Sira birakidi asaay-ad. Biraki amaay, Tama. Piris, Yisran dikidi asaay-ad. Yisran, Aram dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram, Aminatap dikidi asaay-ad. Aminatap, Nasan dikidi asaay-ad. Nasan, Salman dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salman, Bawas dikidi asaay-ad. Bawas diki amaay, Rayap. Bawas, Awpit dikidi asaay-ad. Awpit diki amaay, Ruwit. Awpit, Jisiy dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jisiy, Yisrayil dayadi yitaypika duw Davit, dikidi asaay-ad. Davit Salaman dikidi asaay-ad. Salaman diki amaay tayir Yuwraya diki taakw tikuw, Davit ata liydil diki taakw tilikikik. ");
INSERT INTO mle_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salaman, Riyapawam dikidi asaay-ad. Riyapawam, Apija dikidi asaay-ad. Apija, Asa dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, Jiyasapat dikidi asaay-ad. Jiyasapat, Jawram dikidi asaay-ad. Jawram, Yuwsaya dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yuwsaya, Jatam dikidi asaay-ad. Jatam, Ayas dikidi asaay-ad. Ayas, Yisikaya dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Yisikaya, Manasa dikidi asaay-ad. Manasa, Amas dikidi asaay-ad. Amas, Jawsaya dikidi asaay-adki taakw tikuw, Davit ata liydil diki taakw tilikikik. ");
INSERT INTO mle_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jawsaya, Jikanayawa dikidiy nyamwusugw dayadi asaay-ad. A nyaam Yisrayil dayadiy mama nibak, Bapilan jaka tipa kidiy duw, dayawa wariyakuw, kakilkuw, day abab Yisrayil jaka tipa kidiy duw taakw kwurin karaydadiy dayadi nimadi tip Bapilanaar. ");
INSERT INTO mle_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bapilanaar yikuw, Jikanaya, Siyaltiyal dikidi asaay-ad. Siyaltiyal, Sirapapal dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sirapapal, Apiyad dikidi asaay-ad. Apiyad, Aliyakim dikidi asaay-ad. Aliyakim, Asar dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asar, Satak dikidi asaay-ad. Satak, Akim dikidi asaay-ad. Akim, Aliyuwut dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aliyuwut, Aliyasa dikidi asaay-ad. Aliyasa, Matan dikidi asaay-ad. Matan, Jakap dikidi asaay-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakap, Jawsip dikidi asaay-ad. Jawsip diki taakw Maria. Maria, Jisas, God dikidi Tasakwudidi Duw diki amaaya. ");
INSERT INTO mle_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nyan nasiyibana Aparam duw nak, aw dikidi nyan Aysak duw vitiy, Aparam dikidi gwaal Jakap duw mugwul, Aparam dikidi warag Jawsip duw aliy. Atawada nasiyibana aka yin aw Aparam dikidi warag Davit ab sayna. Day abab duw tabatiy maan aliy-adiy. Atampik Davit maa nasiyibanaad duw nak, Davit dikidi nyan Salaman duw vitiy, Davit dikidi gwaal Riyapawam duw mugwul, Davit dikidi warag Apija duw aliy. Atawada nasiyibana aka yin aw Davit dikidi warag Jikanaya. A nyab Bapilan tipa kidiy duw Yisrayil tipa kidiy duw takwaam kwurin karaydadiy Bapilan tipaar. Day abab duw tabatiy maan aliy-adiy. A nyab nasiyibana aka aw yaan Jisas, day abab duw tabatiy maan aliy-adiy. ");
INSERT INTO mle_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria bas Jisas, God dikidi Tasakwudidi Duw, kitawa sapwiylid. Maria li Jawsipak wadaak, li duwawa maa ti. Li kip wiyaam kwaal dikik. Atawa kwalik, God dikidi Mawul dakuw, nyan ata bas yalaam yitakadid. ");
INSERT INTO mle_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maria li Jawsipak wadaak, kwaal wiyab dikik rikir. Jawsip di viyakita duwad. Aw di wukidil Maria yalawa tilik, aw mawulaar wukikuw, “Nikidi duw likim vaal yidil” waan, aw di likik wukid ata wap sayik-na. Alik di diki mawulab likim wapaak pakwun tad. ");
INSERT INTO mle_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","21","Ata ki javik wukin tidik, Yitaypika Duw God diki maaj kaldadi duw Jawsipak yiginim wadid “Jawsip, Davit dikidi waraga duw, min yaga-tikwa Mariaam kira-kirak. Kidi liki yalaam tinadi nyan, aad God dikidi Mawulaar yitakadidi Nyan-ad likim. Aw li duwa nyanad sapwiy-kilaad. Di dikidiy gwalugwa duw taakw dayadiy vaal yibwiykuw, nyigil-kidadiy. Alik Jisas asikiytak dikik.” Jisas maw maaj Nyigildi Duw-ad. ");
INSERT INTO mle_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Mwiya tayir Yitaypika Duw God diki maaj wasapwiydi duw maaj sukwudil ki javik. Di waad, “Ginyir taakw nak duwawa ti maarkuw, kip yalawa tikuw, duwa nyan sapwiy-kilaad. Adi nyinik Yimanuwal waan sikiytaka-kidanaad.” Adi si maw maaj kitawa wana: God nyanawa tinaad. Ki maaj aka bwutaay mwiya mwiyaba maaj tina. ");
INSERT INTO mle_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aw Jawsip jawiyakuw, adi God diki maaj kardadi duw wadil majib wukikuw, di Maria kiradil. ");
INSERT INTO mle_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Aw Jawsip likiwa kisab maa kwar. Kip kwurin kwadik, adi Nyan ata sapwiylid. Sapwiylik, Jawsip ata Jisas waan sikiytaka-did adi nyinik. ");
INSERT INTO mle_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Yirat, Juw dayadi yitaypika duw tidik, Maria Jisasaam sapwiylid Juwtiya tamiyaam rina tip, Bitliyimaam. Maria Jisas sapwiykuw, kwasa mwiy rilik, nuwukadiy lakwudiy duw waliy kawaar kwala tamiyab tikuw, Jiruwsalimaar yadiy. “Kwula sapwiylidi nyan, Juw dayadi yitaypika duw tikinaad, akidada?” Day ata bas sidiy. “Nyan diki tugwiy vibana walida waliy kawaar kwala tamiyaam tilik. Aw nyan lakwukuw taakw bwu sapwiylaad dim, alik kiril yanadiyan dikik gaba maaj sukwuk.” ");
INSERT INTO mle_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aw Yirat daya maaj wukikuw, ata pitaan warid. Di mawulaar wukikuw ata waad, “Kidi kwasadi nyan ginyir wuna tamiy kwurkinaad way.” Nuwukadiy Jiruwsalimaam kwadiy duw taakw dayabab pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yirat adiy sapakwa nyanugw pris awa God diki lo kalivadiy duw kwurjuwtakakuw, ata bas sididiy, “God dikidi Tasakwudidi Duw akim taakw sapwiy-kilaad?” ");
INSERT INTO mle_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Day ata wadaad, “Juwtiya wadana tamiyaam rina tip, Bitliyim, a tipaam sapwiy-kilaad. Tayir God diki maaj wasapwiydi duw nak ki God wadil maaj sukwudil, ");
INSERT INTO mle_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Juwtiya wadana tamiyaam rina kwasa tip, Bitliyimaam kwanadiy duw taakw, gwura kwasa tip kipa tip maa. A tipa kidi duw nak ginyir yitaypika duw tidik, van tikinaad wunadiy Yisrayil tipa kidiy duw takwak.’” ");
INSERT INTO mle_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Juw dayadi yitaypika duw Yirat, adiy lakwudiy duwawa pakwul vagaruwkuw, wadidiy, “Akasikir adi tugwiy taay vigwurid?” ");
INSERT INTO mle_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yirat daya maaj wukikuw, ata wadidiy, “Gwur Bitliyimaar awakw. Yikuw, a tipaam tikuw, ata adi nyinik miyawa tamiyaar dikik akwak. Dikim sitakirakuw, wunak sibinin may. Yakuw, wunak wagwur, wunabab wakwun dikik gaba maaj sukwu-kidiwun.” Wakuw, wayakidik, wakwudiy. ");
INSERT INTO mle_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Adiy maaj lakwudiy duw Yirat maaj wukin napakuw, ata wakwudiy Bitliyimaar. Yin tidaak, taay vidadi tugwiy waliy kawaar kwala tamiyaam tidik, aw kita adi tugwiy warin daya mwutamawa tad yin adi kwasadi nyan ridil tamiyaar yitaay tidaak. ");
INSERT INTO mle_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Day adi tugwiy vikuw, rakarak samasam tidiy. ");
INSERT INTO mle_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ata yala wiyaar wuladiy. Wulakuw, adi kwasadi nyinwa diki amaay, Maria, vidabir. Vikuw, kwatiyir kwatiyir vakirkuw, kwasadi nyinik gaba maaj sukwudiy. Gaba maaj sukwun napakuw, kariya-dadiy kwasabiy ata kasapwiykuw, dikik kwiydadiy gol, viyakita yaam yay-kwana kamnyaal kitika jaav liki si piragasin, viyakita yaam yay-kwana waliy guw liki si mir, adiy jaav dikik kwiydadiy. ");
INSERT INTO mle_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","God yiginim dayak wadidiy, “Gwur Yiratak sibinin yi-tikwa!” Diki majib wukikuw, nikidi yabir yidiy day dayadi tipaar. ");
INSERT INTO mle_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Day Bitliyim wapakuw, yidaak, Yitaypika Duw God diki maaj kardadi duw yiginim Jawsipak ata wadid, “Yirat wadi nyinim viyasipak kwaki-kinaad. Alik min ki tip awap. Kwasadi nyinwa diki amaywa kwurkuw, atabw Yijipaar. Yikuw, alim ada. Aw wun wuna wakituwadimin sibinin yakimina nyi.” ");
INSERT INTO mle_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aw yigin vikuw, Jawsip jayib nak rasikuw, adi nyinwa diki amaywa kwurkuw, nyidi gaan tilik, Yijipaar kwurin karaydibir. ");
INSERT INTO mle_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yikuw, alim rad. Ridik, Yirat ata kiyaad. Tayir God diki maaj wasapwiydi duw ki Yitaypika Duw God wadil maaj sukwudil God diki lapa nyigaam, “Wunadi Nyan Yijipaam kwadik, wun wuna watuwik, Yijip wapakuw, yakinaad.” ");
INSERT INTO mle_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yirat kavidil adiy lakwudiy duwak maa dikik sibinin yay. Alik di samasam yaal giraad, “Day wunak suwal takadiy,” wakuw. Alik vay sawdiy duwak maaj kwiydidiy. Kwiykuw, wadidiy, “Gwur Bitliyimawa walibab rinadiy tipaar yikuw, ababa duwa nyanugw, nabiy vitiy vitiy ti maarkinadiy nyanugw, abab aviyatupwuryak.” Aw di adiy lakwudiy duw wadaal maaj wukikuw, ata waad, “Adi nyan di nabiy vitiy maa ti nibway.” Alik atawa waad adiy vay sawdiy duwak. ");
INSERT INTO mle_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","God diki maaj wasapwiydi duw, Jirimaya, tayir ki maaj sukwudil God diki lapa nyigaam: “Kwudiy ata wukidaal Rama tipaam. Nimadib girataay yitaay kwurdaak, ata wukidiy. Rasil likidiy waraga taakw dayadiy nyanugw kiyadaak, alik girataay yitaay kwurkwanadiy dayak.” Ki maaj aka mwiya mwiyaba maaj tina. ");
INSERT INTO mle_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jawsip Yijip jaka tipaam kwadik, Yirat ata kiyaad. Kiyadik, God diki maaj kardadi duw Jawsipak yiginim ata wadid, ");
INSERT INTO mle_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Jisasaam viyasipak kwurdiy duw bwutaay kiyadiy. Aw min jaaw sibinin maay Yisrayil jaka tipaar kwasadi nyinwa diki amaay kwurkuw.” ");
INSERT INTO mle_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ata wadik, Jawsip rasikuw, Jisasawa diki amaay, Maria, kwurkuw, Yisrayil jaka tipaar yidiy. ");
INSERT INTO mle_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yikuw, Jawsip ata wukidil Akilas dikidi asaay Yirat diki tamiy kwurkuw, Juwtiya dayadi yitaypika duw ridil. Atawa wukikuw, Jawsip samasam yagaad Jisasawa Maria birakim a tamiyaam kwurin rirak. God yiginim Jawsipak maaj kwiyin napadik, day Galiliy tamiyaar yidiy. ");
INSERT INTO mle_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yikuw, Nasarit wadana tipaam ridiy. Tayir God diki maaj wasapwiydi duw ki maaj wadil, “Di Nasarit tipa kidi duw tikinaad.” Jisas Nasaritaam kwadik, ki maaj aka mwiya mwiyaba maaj tina. ");
INSERT INTO mle_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A nyi Jon Baptais kwiydidiy duw Juwtiya duw taakw kwu maardaal tamiyaam ritaay, God diki maaj bas wasapwiyid. ");
INSERT INTO mle_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Di duw takwak wadidiy, “God dikidi duw takwak van tikidadi nyi adika walibab tinaad. Aw li gwur diki tabaam tikir wakuw, gwur ata gwuradiy valik bwan akwiy.” ");
INSERT INTO mle_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tayir God diki maaj wasapwiydi duw, Aysaya, ki maaj sukwudil Jonak. Di ata waad, “Duw nak duw taakw kwu maardaal tamiyaam gaam sinaad, ‘Niki jaav niki jaav kwulapwun ada nimadi yitaypika duwak. Alik adi yaab tugwaam nakwaad.’” ");
INSERT INTO mle_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon dikidi wapwiy kamil yuwiyir apar kapar mwugiydaad. Sipapuwtuwawa jitakadid. Di kwalabag kitika jaav si lakis wawa kwudiyugw daya guwawa kad. ");
INSERT INTO mle_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jiruwsalim tipa kidiy duw takwawa miyawa Juwtiya tamiyaam ridiy duw takwawa, Jawtan bayibawa ridiy ababa tipaam ridiy duw taakw yadiy Jonak diki wasapwiydil maaj wukik. ");
INSERT INTO mle_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Duw taakw samasam wukikuw dayadiy valik, Godak dayadiy vaal wasapwiydaak, Jon ata baptais kwiydidiy Jawtan bayibim. ");
INSERT INTO mle_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon vidil nuwukadiy Parasiyawa Satuwsiy, abir bapa Godak gaba maaj sukwudiy duw, dikik yadiy baptais dayak kwiydikik. Di dayaam vikuw, ata wadidiy, “God duw takwak yaal girakidi nyi walibab tidalik, alik duw kapwiy yiy wapataka-dakib kabaay tabwu-kwadana pik wunak yanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","“Gwur gwuradiy yigwuradiy valik wukikuw, dayak bwan bwutaay kwiygwurik wakuw, viyakita yawiy akwur. Kwurgwur, aw ababa duw taakw vikuw, day wukikwadiy gwura maaj mwiya maaja. ");
INSERT INTO mle_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Mawulaam wagwura ‘Nyan Aparam dikidiy gwalugwa kidiy-adiyan. Alik nyan yara kwakinadiyan.’ Atawa wakigwura, aal mwiya suwala. Li God mawul warkida, di kidiy kabaak mwugiydik, Aparam dikidiy gwalugw tikinadiy. ");
INSERT INTO mle_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Ababa miy, adiy mwiy ri maarkinadiy, adiy miy God vilkuw, daan vakirdaak, yiyaar yakisawula-kidadiy. Kitawa God duw takwak kotiy-kidadiy. ");
INSERT INTO mle_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Li gwur bwan gwuradiy kupwaraap sapwurapa mawulak kwiykigwura, wun guwaar gwurak baptais kwatiya-kituwadiygwur. Duw nak wuna kwukir yakinaad. Adi duw mwiya yitaypika duw tikinaad. Aw wun yisadapik tinadiwun. Wun adi duw dikidiy jaav yatayat maa rav. Di baptais kwiy-kidadiygwur God dikidi Mawulawa yiyaar. ");
INSERT INTO mle_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Mwar viyalil nyi duw nak adiy kabasik kitika jaav, wit, pakwiyir tapwutaay, yakisuw-dakib. Mwar viyalik, adiy tika wit awa apa wit kapakap kapakap vakirdiy. Adi duw adiy tika wit kwurjuwtakakuw, kamnaagw takakwada wiyaar kwurin karaydidiy. Adiy apa wit kwurjuwtakakuw, yakisawula-didiy nyi gaan nyi gaan yanin tikwana yiyaar yiy yandakik. Atawa adi wuna kwukir yakinadi duw kwurkinaad viyakitawa kupwarapa duw takwaam.” Atawa Jon wadidiy. ");
INSERT INTO mle_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","A nyi Jisas Galiliy wapakuw, Jawtan bayibir yad Jon Baptais dikik kwiydikik. ");
INSERT INTO mle_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aw Jon maa wakuw a javik, Jisasak ata wadid, “Li min wunak baptais kwatiyak-nadimin. Li wun minak baptais kwatiya-kwatay maa rav wunaam.” ");
INSERT INTO mle_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aw Jisas Jonak ata wadid, “Jaaw, an God dikil majib kwurtik. God diki mawul baptais wunak kwatiya-minakik wana.” Jon Jisas diki majib wukikuw, baptais ata kwiydid. ");
INSERT INTO mle_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon Jisasak baptais kwiyin napadik, Jisas guwaam tikuw, ata warid. Wardik, God adawul tubw kajitakadid. Adawul tubw kajitakakuw, Jisas ata vidid God dikidi Mawul ata daad midakim kaytik di dikik. Dakuw, Jisas diki apiyim rad. ");
INSERT INTO mle_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Day ata ki God wadil maaj wukidaal, “Kad wunadi mawul yituwadi Nyanad. Wun rakarak tinadiwun dikik.” ");
INSERT INTO mle_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Atawa tikuw, God dikidi Mawul Jisasaam ata kwurin karaydid duw taakw kwu maardaal tamiyaar Satan dikim wasapwun vasibariyik kwurdikik. ");
INSERT INTO mle_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Alim nyi gaan duwamiy vitiy kwakuw, Jisas kikipaat ki maarkuw, ata kaam yisad. ");
INSERT INTO mle_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kaam yisalik, Satan ata yaad dikik. Yakuw, Jisasak ata wadid, “Li min mwiya God dikidi Nyan-adimin wakuw, kidiy kabakik wamin, bret tikwadiy kiminkikik.” ");
INSERT INTO mle_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aw Jisas Satanak ata wadid, “Atawa maa. Aw God diki lapa nyig kitawa wana, ‘Duw taakw bret-adikanim akis wapwan tikwanadiy. Aw God dikidiy ababa wakwadadiy majidanim wapwan tikidiy.’” ");
INSERT INTO mle_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Satan Jisasaam ata kwurin karaykuw Jiruwsalimaar, ap God dikidi gaba maja wiyaam takadid. ");
INSERT INTO mle_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Di Jisasak ata wadid, “Min mwiya God dikidi Nyan-adimin wakuw, atay vakirmin kiladi kupwaam. Aw God diki maaj wana, ‘God maaj kwiykidadiy dikidiy maaj kardadiy duwak minak. Aw day minak yarakara van tidaak, min kabakim maan taab viy maa.’” ");
INSERT INTO mle_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas Satanak ata wadid, “Atawa maa. Aw ki maaj ab God diki lapa nyigaam rina: ‘Min kidi Yitaypika Duw God, dim wasupwu-vasibariykin kwur-tikwa.’” ");
INSERT INTO mle_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Ata Satan Jisasaam kwurin kawardid nimadi nibwukir. Kawarkuw, kidi kupwaam ridiy ababa jaka tip simakadidiy. Dayadiy ap simakadid. Dayadiy ap Jisasak simakakuw, ata wadid, “Li min wunak vakirkuw, gaba maaj wunak sukwu-kimina, wun kidiy ababa jaka tip minak kwatiya-kituwadiy dayaam min van timinkikik.” ");
INSERT INTO mle_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisas Satanak ata wadid, “Satan, min agwutak! God diki lapa nyig ata wana: ‘Yitaypika Duw Godak gaba maaj asukw! Dikidanik yawiy akwur!’” ");
INSERT INTO mle_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jisas ki maaj wadik, Satan ata wapadid. Satan wapakuw yidik, God diki maaj kardadiy duw dakuw, Jisasak sugwiyaan kwurdaad. ");
INSERT INTO mle_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jon Baptais kwiydi duw Yiratak kipwu mwutaam yikuw wadik, Yirat dim kalabus ir kwusawula maaj Jisas ata wukidil. Wukikuw, Jisas Galiliy tamiyaar ata yad. ");
INSERT INTO mle_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Di diki tip Nasaritaam maa kwu. Nasarit wapakuw, di Galiliy mala araam ril tip Kapanim, arir yad. Kapanim wadana tip, Sipulanawa Naptaliy, abir tamiyaam ral. ");
INSERT INTO mle_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas atawa kwurdil tayir God diki maaj wasapwiydi duw, dikidi si Aysaya, diki sukwudil maaj ata mwiya mwiyaba maaj tilikikik. ");
INSERT INTO mle_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ki maaj kitawa wana: “Sipulanawa Naptaliy, abir tamiy mala Galiliy arawa Jawtan bayib, alim rinabir. Nuwukadiy jaka tipa kidiy duw alim rinadiy. ");
INSERT INTO mle_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A tamiyaam rinadiy duw taakw dayadiy mawul pakwun tidaak, jawjaay kwanadiy. Atawa kwadaak, dayak God diki nima lait ata kariyaan tina.” ");
INSERT INTO mle_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisas a tamiyaam kwakuw, ki maaj ata wadil a nyi, “Gwur gwuradiy kupwaraap sapwurapa mawul awap. God diki duw takwaam van tikida nyi aka walibab tina.” ");
INSERT INTO mle_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas Galiliy wadana ar mala araam tiytiyaan tad. Tikuw, ata duw vitiy vidibir, Sayman ginyir wakwadanaad Pita, dikidi nyamwus Adiruwawa. Bir kamiy nagirir kwaan kwurbir araam. Aal biriki yawiyal. ");
INSERT INTO mle_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas ata wadibir, “Bir wuna kwukib may! Yabir, wun birak kalivaaw. Bir duw kwur-kinabirbir wunadiy tidakikik tayir kamiy kwurbiril pik.” ");
INSERT INTO mle_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jaab nak bir birikidiy nagir wapakuw, Jisas diki kwukib yibir. ");
INSERT INTO mle_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisas kwasa yikuw, ata vidibir Sipatiy dikibir nyidiy Jamisawa Jon. Bir birikidi asaay Sipatiyawa jabiraam kwaan dayadiy nagir tap tipadadiy. ");
INSERT INTO mle_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jisas birakik wataydik, jaab ni birkidi asaywa jabir wapakuw, Jisas diki kwukib yibir. ");
INSERT INTO mle_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas ata Galiliy miyawa tamiyaam tiytiyaan tad. Tikuw, Juw dayadiy gaba maja wiyaam duw takwak kalivaan wadidiy, “Kitawa God duw takwak van tinaad.” Di adiy niki giviyib niki giviyibak kwadiy duw takwaam sipwutiydidiy. ");
INSERT INTO mle_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siriya jaka tipa kidiy duw taakw diki kwurdil yawiy maaj wukikuw, dayadiy giviyibak kwadiy duw taakw ata dikik kwurin karaydadiy sipwutiydikik. Nuwukadiy wudib mawulaar yidadiy, nuwukadiy as yidiy, nuwukadiy ap bwan kiyadiy, abab Jisas sipwutiydidiy. ");
INSERT INTO mle_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galiliy tamiya kidiy, Tip Tabatiy tipa kidiy, Jiruwsalim tipa kidiy, ababa Juwtiya tamiya kidiy, Jawtan bayib agika maka gikim ridiy duw taakw, day abab Jisas diki kwukib yidiy. ");
INSERT INTO mle_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Jisas adiy samasama duw taakw vikuw, di aba nibwukir warkuw, alim daan rad. Di dikidiy kalivadidiy duw diwa walibab ridaak, di ata kalivadidiy. ");
INSERT INTO mle_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Adiy duw taakw day dayadiy mawulaam wataay, ‘Nyan nyanada viyakita yawiy Godak kap kwurkwur maa rav. Aw God nyanawa sugwiyaan kwurdik, aal kwurkibana.’ Atawa wukikwanadiy duw taakw God dikidi gwalugw, aad dayakidaad. Alik day rakarak samasam tikwadiy. ");
INSERT INTO mle_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Adiy duw taakw day samasam wukikwanadiy day dayadiy yidadiy valwa kidi kupwaam rinadiy kupwarapa valik, God dayak yarakara kwurkidadiy. Alik adiy duw taakw rakarak samasam tikwadiy. ");
INSERT INTO mle_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Adiy duw taakw dayadiy mawul kwusidatakaan tikwanadiy, kidi kupwad miyawa dayakid tikinaad. Alik adiy duw taakw rakarak samasam tikwadiy. ");
INSERT INTO mle_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Adiy duw taakw day nyanyi viyakit tikir God dikidi gikim, God adiy duw taakw daya mawul wala jaav kwiykida dayak. Alik adiy duw taakw rakarak samasam tikwadiy. ");
INSERT INTO mle_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Adiy duw taakw day wukikwanadiy nuwukadiy duw takwak, God ab dayak wukikinaad. Alik adiy duw taakw rakarak samasam tikwadiy. ");
INSERT INTO mle_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Adiy duw taakw dayadiy mawul mwiyir tikwanadiy, ginyir day Godaam vikidanaad. Alik adiy duw taakw rakarak samasam tikwadiy. ");
INSERT INTO mle_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Adiy duw taakw nyidi nyidim tan nuwukadiy duw takwak God tasakwu-kidadiy ‘Adiy wunadiy nyanugw-adiy,’ wakuw. Alik adiy duw taakw rakarak samasam tikwadiy. ");
INSERT INTO mle_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Adiy duw taakw day God diki wadil yawiy kwurkuw, aw nuwukadiy duw taakw dayak sapis jikin jawjaay kwurdaak, ata God dikidi gwalugw, aad dayakidaad. Alik adiy duw taakw rakarak samasam tikwadiy. ");
INSERT INTO mle_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","“Gwur wuna kwukib yinadiygwurik. Alik day gwurak sapis jikin jawjaay kwurin, suwaal takaan kwur-kidanadiygwurik, wuna danik wakuw. Atawa gwurak kwurdaak, gwur rakarak ada. Aw ginyir adawul tipaam wulakuw, God gwurak viyakita jaav kwur-kidadiygwurik. Atampik tayir duw wunadiy maaj wasapwiydiy duwaam kwurdadiy.” ");
INSERT INTO mle_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Waliy kwas kwiyaam takadakib. Alik pwuk akis yaykwanadiy. Gwur atampik waliy kwas kaytik duw taakw daya nyidim tinadiygwur. Aw li waliy kwas wapwusakwulik, aw alik ginyir bay yiyi maa rav. Wapwusakwulik, day kip yakiyakikuw, duw taakw ata maan vasin tiytiyaan tikidana. ");
INSERT INTO mle_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gwur lait kitik kidi kupwaam kwanadiy duw takwak tikinadiygwurik. Abwa nibwukim rina tip takatipin ri maa. Ababa duw taakw likim vijibir tikwadana. ");
INSERT INTO mle_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","“Li gwur lam wapatakataay, yala vakaam akis vataka-kwagwura. Li gwur maliykaam vataka-kwagwura, miyawa wiyak kariyalikik. ");
INSERT INTO mle_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","“Atampik gwurabab maliykaam tan yawiy kwurgwur, nuwukadiy duw taakw vikwadiy. Gwuradiy viyakita yawiy vikuw, day ata gwuradi adawul kwanadi Asaay dikik yakisuw-kidanaad.” ");
INSERT INTO mle_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gwur kitawa wukitikwa, ‘Jisas dadil di Mawsis kwiydidiy God dikidiy maaj wasapwiydiy duw dayadiy majawa kaybwiyik.’ Atawa kwurik wun maa di. Aw wun datuwil dayadiy mwiya maw maaj wasapwiyik. ");
INSERT INTO mle_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","“Ki maaj awuk! Adawul tinadi tubwawa kidi kupw kip rikinabir, Mawsis dikidiy miyawa lo kwas maa. Aw yin adawul tipawa kidi kupw kwusikibira nyi dikidiy lo ata kwusikinadiy. ");
INSERT INTO mle_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Aw li duw nak lo nikik bwan kwiykuw, nuwukadiy duw takwak wakida, ‘Kal kwasa lo wa, alik jaaw bwan kwiynaak likik,’ adi duw God dikidi gwalugwum mwiya kwasaad tikinaad. Aw adi duw di ababa lo wab wukikida, nuwukadiy duw takwak wakida, ‘God dikidiy ababa lo wab wukinaak,’ waan aal adi duw yitaypik tikinaad God dikidi gwalugwum. ");
INSERT INTO mle_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Adiy God diki lo kalivanadiy duwawa Parasiy day yawiy samasam God diki lo wak kwurkwanadiy. Duw taakw dayadiy yawiy vikuw, wakwadanadiy, ‘Day mwiya viyakita duw-adiy,’ waan. Aw God dayadiy mawul lakwudadiy. Aw wun watuwadiygwur gwur dayaam kakil maarkigwura, gwur God dikidi gwalugwur wul maa.” ");
INSERT INTO mle_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gwur wukigwuril tayir duw wadiy, ‘Duwaam viyasipa-tikwa. Aw li gwur atawa kwurkigwura, kot im tikinadiygwurik.’ ");
INSERT INTO mle_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Aw wun watuwadiygwurik li duw nak wariya kwudiy wakinaad dikidi kapa duwak, adi duw kot im tikinaad. Aw li duw nak dikidi kapa duwak wakidaad, ‘Min kwam yiyi tikwanadi duw-adimin,’ waan, adi duw yitaypika kaunsil kot i tikinaad. Aw li duw nak dikidi kapa duwak kupwarapa sapis jikin kwurkinaad, adi duw yiy yanin tikwana tamiyaar yikinaad, ay maa? ");
INSERT INTO mle_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Aw gwuradiy vaal kwiyik Godak kabaka jabim tikuw, aw gwuradiy mawul gwuradiy gwalugwa duw takwaam vaal yigwuralik wukikuw, taay Godak kwiykigwuradiy jaav wapakuw mala kabaka jabawa, maay adiy duw takwak. Yikuw, maaj lakatiykuw dayawa, ginyir ata sibinin yakuw, Godak ata gwuradiy vaal akwiy. ");
INSERT INTO mle_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Aw li duw nak minaam kot ir karayik tidik, yabir yitaay tikuw, nyidi yabim adi duwawa min a maaj alakatiy. Bir mawul nak ada. Aw atawa adi duwawa lakatiy maarkimina, aw adi duw minaam karayin jas tabaam takadik, aw jas plisman tabaam takadik, aw plisman kalabus ir kwusawula-kidanadimin. ");
INSERT INTO mle_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","“Mwiya maaj a watuwa. Aw li min kalabus im kwaan yin jas wadidiy saan miyawa kwiykimina adi duwak ata kalabus kwusikinadimin. Aw saan dikik kway maarkimina, min kip kalabus ib kwayi-kinadimin yin mina dinau kwusikila nyab.” ");
INSERT INTO mle_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Gwur wukigwuril tayir wadaal, ‘Gwur nikidi duw diki takwaam vaal yan kwurtikwa.’ ");
INSERT INTO mle_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","“Li wun wuna watuwadiygwurik, li duw nak niki kipa takwaam vikuw, diki mawul likik visikiyakilik a takwak, aw a jaav diki mawulaam a takwak wukikida, adi duw bwutaay likim vaal yidaal diki mawulaar. ");
INSERT INTO mle_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Aw li gwuradiy mava makaam tinadiy mil gwuraam mwugiydaak, kupwarapa javik mawul wukikuw, adiy gwuradiy mava makaam tinadiy mil gwakuw, ata ayak. Aal viyakita agikim milada tikuw, adawul tipaar warkigwura. Aw li mil vitiykilib tikigwura aal kupwarapa yiy yanin nyanyi tikinadiy tipaar yikigwura, aal kupwarapa. ");
INSERT INTO mle_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","“Aw li gwuradiy mava taab gwuraam mwugiydaak, vaal yikuw, adiy mava taab viyalupwakuw, ata ayak. Aal viyakita agika tabada tikuw, adawul tipaar warkigwura. Aw li taab vitiykilib tikigwura, aw kupwarapa yiy yanin nya nyi tikinadiy tipaar yikigwura, aal kupwarapa.” ");
INSERT INTO mle_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tayir a maaj ab ata wadaal, ‘Li duw nak diki takwaam wapaak tikuw, adi duw likik takwaam wapakwadana lapa nyig sukwukwaad.’ ");
INSERT INTO mle_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","“Aw wun wuna watuwadiygwurik, li duw nak diki taakw nikidi duwaam vaal yi maarlik, di kipa kip likim wapakida, aw nikidi duw likim kirakuw, li ata vaal yikina dikim. Adi duw ab likim vaal yikida.” ");
INSERT INTO mle_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gwur wukigwuril tayir wadaal, ‘Li agwa jaav tayib nikidi duwak aban takaminil mayra sar yiminil Yitaypika Duw God dikidi saam, a jaav min akwur. Wapa-tikwa.’ ");
INSERT INTO mle_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","36","“Aw wun gwurak waaw. Gwur aban takakigwura javik, kitampika mayra sar saam watikwa, ‘Wun suwaal maa tak gwurak. Kidi adawul tipaam kwanadiy duw taakw bwutaay lakwudana,’ waan. Gwur adi tipak maa van ti. Adi tip aad God daan ridadi tipad. Watikwa, ‘Wun suwaal maa tak gwurak. Kidi kupwaam kwanadiy duw taakw bwutaay lakwudana,’ waan. Gwur kidi kupwak maa van ti. Kidi kupw aad God dikidi yin yaan tidadi kupwad. Gwur watikwa ‘Wun suwaal maa tak gwurak. Kidi nimadi tipa kidiy duw taakw day bwutaay lakwudana,’ waan. Nimadi God di van tinaad adi tipak. Alik gwur atawa watikwa. Gwur watikwa, ‘Wun suwaal maa tak gwurak. Li wuna maaj suwaal tikila, aal wuna gilakagila nab wamakawam tikina.’ Ay ‘Wuna wamakawama nab gilakagil tikina.’ Aw gwur gwura kap nab nak mwugiygwur, wamakawam ti maa, ay gilakagil ti maa. ");
INSERT INTO mle_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Aw li gwuradiy mawul ‘Ayiy’ wakir, aal gwur kip ‘Ayiy’ waan aw. Aw li gwuradiy mawul ‘Maa’ wakir, wa maagw aal kip ‘Maa’ waan aw. Nuwukadiy nimadiy maaj kipakip watikwa. Atampika maaj Satan dikidiy-adiy.” ");
INSERT INTO mle_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Gwur bwutaay wukigwuril ki tayir wadaal maaj, ‘Li duw nak wariyakuw, nikidi duw diki milaam viyadik, gwalik, aw adi duwaam maa diki mil awarabab gwa-kigwuraala. Li duw nak wariyakuw, nikidi duw diki wuk viyatikwiya-kida, awarabab adi duw diki wuk viyatikwiya-kigwuraala.’ ");
INSERT INTO mle_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","“Aw wun niki maaj watuwadiygwurik. Aw li duw gwuraam kupwaraap kwurdaak, gwur awarabab dayaam kupwaraap kwurtikwa. Aw li duw gwuradiy mava wasipaam yala tabaar viyapwadaak, agik ab kwiytaka-gwur viyapakwu-kwadiy. Aw gwur dayaam viyatikwa. ");
INSERT INTO mle_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","“Li duw nak kwusuw-gwuradiy wapwiyik wakuw, kot ir karaydik, aw minadi nikidi sapwun kwakiminadi wapwiy ab adi duwak akwiy. ");
INSERT INTO mle_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","“Aw li vay sawdi duw nak gwurak dikidiy jaav simiy nak kwurin karay-gwurkik wadik, aw gwur dikidiy jaav simiy vitiy yataan akaraay. ");
INSERT INTO mle_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","“Aw li duw nak gwura javik kwurik wadik, a jaav dikik akwiy. Aw li duw nak gwura javik basadika kwurik wakitadik, a jaav dikik akwiy.” ");
INSERT INTO mle_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Gwur bwutaay wukigwuril tayir ki maaj wadaal, ‘Gwuradiy mawul gwuradiy kapa duwak yikwadiy. Aw gwuradiy yaal gwuradiy mama nibak girakwadiy.’ ");
INSERT INTO mle_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","“Aw wun wuna watuwadiygwurik gwuradiy mawul gwuradiy mama nibak yikwadiy. Aw li duw taakw jawjaay gwuraam kwurdaak, Godak bas as adiy duw takwak. Atawa kwurkuw, gwuradi adawul tipaam kwanadi Asaay dikidiy nyanugw tikinadiygwurik. Aw di viyakita jaav kwurkwanaad adiy kupwarapawa viyakita duw takwak nakamwiyib dayak kwurkwanaad. Di mwugiydik, nyi day ababak si kwanaad. Waal ab day ababak jakwanaad. ");
INSERT INTO mle_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Adiy kupwarapa takis kwurkwanadiy duw dayadiy mawul yikwanadiy awarabab dayak mawul yikwadanalik. Gwur atampik kwakigwura, God viyakit kwurkinaad gwurak, ay maa? Suwana? Gwuradiy mawul yikwadiy ababa duw takwak. ");
INSERT INTO mle_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“Adiy haiden tikwanadiy duw taakw day, ‘Yara kwanadiygwur,’ wakwadana dayadiy kapa duw takwak. Aw li gwur gwuradiy kapa duw takwadikanik atampik kwurkigwura, a viyakita jaav kwurkigwura, ay maa? Suwana? Gwur, ‘Yara kwanadiygwur,’ aw ababa duw takwak. ");
INSERT INTO mle_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Gwuradi adawul tipaam kwanadi Asaay di mwiya viyakit tikwanaad. Gwur atampik ada.” ");
INSERT INTO mle_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Gwur yarakara awuk. Gwur viyakita yawiy kwurik Godak ay duw takwak tikuw, gwur duw taakw dayadiy mwutamaam tan adiy yawiy kwurtikwa vidakikik. Gwur atampika yawiy dayadiy mwutamaam vikuw rakarak tidakikik gwurak kwurkigwura, aw gwuradi adawul tipaam kwanadi Asaay gwurak viyakit kwar maa. ");
INSERT INTO mle_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","3","“Adiy duw, day viyuw tikala pik vitiy pasiranadiy duw, day jaav kwiydadiy saal yinadiy duw takwak Juw dayadiy gaba maja wiyawa yabim, rabw sikuw. Atawa kwurkuw, ababa duw taakw vikuw, day rakarak samasam tinadiy dayak. Gwur yara awuk. Adiy duw taakw viyakit kwurkuw dayak, God niki jaav dayak kway maa. Gwur jaav saal yinadiy duw takwak kwiyik tikuw, day kwurdana pik kwurtikwa. A yawiy pakwun akwur. Atawa kwurkuw, gwurawa kwanadiy duw taakw day laakw maa a javik. ");
INSERT INTO mle_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","“A yawiy pakwun kwurkuw, gwuradi Asaay gwura yawiy vikidaal. Vikuw, ginyir di viyakit gwurak kwurkida a yawiyik.” ");
INSERT INTO mle_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Adiy duw, day viyuw tikala pik vitiy pasiranadiy duw, Godak maaj bwulak, day Juw dayadiy gaba maja wiyawa nyidi yabim rasin tinadiy ababa duw taakw dayaam vidakikik. Adiy duw taakw rakarak samasam dayak tidaak, God niki jaav dayak kway maa. ");
INSERT INTO mle_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Aw gwur Godak maaj bwulak tikuw, day kwurdana pik kwurtikwa. Aw gwur yala wiyaar wulakuw, wiyig tipikuw, gwur Godak ata maaj abwul. Gwur dikim maa vi. Aw gwur kap kwakigwura, di gwuraam vikidadiygwurik. Gwuradiy maaj wukikuw, ginyir viyakit kwurkida gwurak adiy majik. ");
INSERT INTO mle_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","“Adiy haiden tikwanadiy duw day wukikwanadiy maaj samasam kipakip Godak wakuw, God dayadiy wadanadiy maaj wukikidaal. Aw gwur Godak maaj bwulak tikuw, day bwuladana pik samasama maaj kipakip watikwa Godak. Adiy gwuradi Asayik bas sigwuradiy jaav di bwutaay lakwudadiy. Alik gwur samasama kipakipa maaj dikik watikwa. ");
INSERT INTO mle_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","13","“Gwur kitawa Godak maaj aw: Nyanadi adawul tipaam kwanadi Asaay, nyanadiy mawul nyan minak pitaan warkwanadiyan. Min yakuw, ababa duw takwak van ada. Abab day adawul tipaam kwanadiy mina majib wukikwanadiy. Nyana mawul kidi kupwaam kwanadiy ababa duw taakw atampik mina majib wukikidiy. Nibwul kikibanadiy kikipaat nyanak akwutay. Li adiy nuwukadiy duw taakw nyanaam yidadiy valik bwutaay bwan kwiybanadiy, atampik minabab nyanadiy minak yibanadiy valik bwan akwiy. Min nyanawa walibab yarip tuwin ada, Satan nyanaam kakilik-dadiyan wasapwun vasibariyik kwurik. ");
INSERT INTO mle_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Aw li gwur bwan kwiykigwura nuwukadiy duw taakw gwuraam yidadiy valik, gwuradi adawul tipaam kwanadi Asaay dibab bwan kwiykida gwuradiy dikik yigwuradiy valik. ");
INSERT INTO mle_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","“Aw li gwur bwan kway maarkigwura nuwukadiy duw taakw gwuraam yidadiy valik, gwuradi adawul tipaam kwanadi Asaay dibab gwuradiy dikik yigwuradiy valik bwan kway maa.” ");
INSERT INTO mle_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","18","“Adiy duw, day viyuw tikala pik pasiranadiy duw, nuwukadiy nyi day kipaat akis kikwanadiy gaba maaj sukwuk Godak. Day wamakawama kupw dayadiy mwutamaam yitakataay, dayadiy mwutaam mwiya sarmabap tikwanadiy. Nuwukadiy duw taakw dayaam vikuw, wayapiy samasam dayak sidaak, God niki jaav dayak kway maa. Aw gwur kikipaat ki maarkuw Godak gaba maaj sukwuk tikuw, day kwurdana pik kwurtikwa. Gwur gwuradiy mwutaam guw kwurpirkuw, nab sarkuw, nuwukadiy duw taakw laakw maa gwur kamnaagw akis kikwanadiygwurik gaba maaj Godak sukwuk. Gwur Godaam maa vi. Aw atawa tigwur, God di kap lakwu-kidadiygwurik. Lakwukuw, ginyir di viyakit kwurkida gwurak.” ");
INSERT INTO mle_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","21","“Gwuradiy mawul gwuradiy niki jaav niki jaav ridana tamiyak nyanyi wuki-kwanadiy. Alik gwur gwurak samasama niki jaav niki jaav vagaruw-tikwa kidi kupwaam. Digawa wawraay adiy javim sukwutuw-kwadanadiy. Luwkuw kwurkwanadiy duw day wiy viyatugwa-taay, adiy jaav luwkuw kwurkwadanadiy. Alik tikuw, gwur gwurak niki jaav niki jaav avagaruw adawul tipaam. Alim digawa wawraay gwuradiy javim sukwutuw maa. Adiy luwkuw kwurkwanadiy duw gwuradiy javim luwkuw kwar maa.” ");
INSERT INTO mle_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","“Adiy nyanyi vigwuradiy jaav gwuraam van tikwanadiy. Aw li gwur nyanyi viyakita javim van tikigwura, aal gwuradiy mawul viyakit tikinadiy. Aw li gwur nyanyi kupwarapa javim van tikigwura, aal gwuradiy mawul kupwaraap tikinadiy. Aw li gwuradiy mawul kupwaraap tikinadiy, aal mwiya kupwaraapa.” ");
INSERT INTO mle_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Duw nak duw vitiyak yawiy kwurkwur a maa rav. Di nikidi duwak mawul yikuw, nikidi duwak maa wakinaad. Di nikidi duwak viyakita yawiy kwurkuw, nikidi duwak kupwarapa yawiy kwurkidaad. Atampik gwur Godawa sanak nakamwiyib yawiy kwurkwur maa rav. ");
INSERT INTO mle_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Alik tikuw watuwadiygwurik, kamnagwuk samasam wukitikwa. Gwuradiy kwusuw wapwiyak ab wukitikwa. Gwurabir mawulawa amwiy abir mwiya yitaypik kamnagwuwa kwusuw wapwiyik tinabir. Alik abir kwasabir javik samasam wukitikwa. ");
INSERT INTO mle_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Gwur wadiy wulin yin yaan tikwanadiy wapiyik av. Gwur mayim taba jaav sigwur, wardaak, ginyir ata yin lawdaak, kwurkuw, wiyaar kariya-gwuradiy kikir. Gwur kwur-kwagwura pik wapiy akis atampika yawiy kwurkwanadiy. Gwuradi adawul tipaam kwanadi Asaay di diki dayak van tikwadadiy. Aw li di kikipaat wapiyik kwiykida, di gwuraam wap maa. ");
INSERT INTO mle_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Aw li gwur samasam wukikigwura kiyakiyak, niki nyi nak gwur gwura sitay sitaay rav maa. ");
INSERT INTO mle_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Agwa javik gwur samasama kwusuw wapwiyik wuki-kwanadiygwurik? Gwur kip warkwanadiy mawayak av. Gwur nimadiy yawiy kwur-kwanadiygwurik gwuradiy wapwiy tipak. Aw adiy mawaay day gwur kwur-kwagwuradiy yawiy pik akis kwurkwanadiy. ");
INSERT INTO mle_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","“Tayir Juw dayadi yitaypika duw, Salaman, viyakita wapwiy kwusuwdidiy. Aw diki gilabadiy adiy mawaay dayadiy gilabadiy maa kakil. ");
INSERT INTO mle_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","“Adiy kip warkwanadiy mawaay nibwul kip tikuw, kwasa mwiy tikuw duw taakw dayaam gwakuw, yaam taka-kidanadiy. Aw li God adiy mawayak dayadiy gilabadiy sawtaka-kwadadiy, di gwurabab gwuradiy wapwiy kwiy-kidadiygwurik gwur dikik adiy mawayim yitaypik tigwuralik tikuw. Gwur kwasa mwiy dikik wukijibir tikwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","“Atawa tikuw, mawul warin wukiway, ‘Nyan agwa kikipaat kikinadiyan? Nyan agwa guw kikinadiyan? Nyan agwa wapwiy kwusuw-kinadiyan?’ wakuw. Adiy haiden tinadiy duw taakw atawa mawul warin wuki-kwanadiy. Aw gwur atawa wuki-tikwa. Aw gwuradi adawul tipaam kwanadi Asaay bwutaay lakwunaad gwuradiy mawul kwurik wadanadiy javik. ");
INSERT INTO mle_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","“Aw li yitaypik gwuradiy mawulaam takakigwura, God wadadiy majib wukikuw diki yawiy kwurkigwura, God ata kwiy-kidadiygwurik adiy nuwukadiy jaav. ");
INSERT INTO mle_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Adiy sir yakinadiy kupwarapa javik kip rikwadiy. Dayak nibwul wukitikwa. Nibwul yanadiy jaav adiy rivnadiy wukiwukik. Aal viyakit maa, adiy nuwukadiy nyi kupwarapa javik wukiwukik.” ");
INSERT INTO mle_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Aw li gwur kupwaraap waan wasapwun kwurkigwura nuwukadiy duw takwak, aw ginyir God di kupwaraap wakinaad gwurak. ");
INSERT INTO mle_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","“Gwur nuwukadiy duw takwak kupwarapa jaav viyakita jaav dayak kwurkigwura, atampik God ab kwur-kidadiygwur gwurak adiy nuwukadiy duw takwak kwurgwuradiy yawiyab vikuw. ");
INSERT INTO mle_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Gwur agwa javik nikidi duw diki yidil kwasa valik wagwura, aw gwur gwuradiy nimadiy valik akil wukigwura? ");
INSERT INTO mle_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","“Gwur nuwukadiy duw taakw dayadiy kwasadiy valik vikuw, wakigwuradiy, ‘Min kwasa vaal yiminal, alik wun sugwiyaan kwurik minak.’ Aw gwuradiy vaal mwiya nimadiy-adiy. Alik gwur atawa wakigwura, gwur viyuw tikala pik pasira-kigwura. Taay gwur bwan akwiy gwuradiy nimadiy valik. Kwiykuw, ginyir ata yin sugwiyaan akwur adi nikidi duw diki kwasa valik. ");
INSERT INTO mle_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nuwukadiy duw taakw kwasik yikwanadiy God diki maaj wukiwukik. Alik gwur dayak God diki maaj watikwa. Aw li gwur dayak God diki maaj wakigwura, day gwurak wariy-wariya as kaytik tikinadiy. Nuwukadiy duw taakw maa wakwanadiy God diki majik. Gwura maaj dayak bwalak til yakisawula-dadiy jaav kaytik. Kupwaam vakirkuw ridaak, adiy bwal dayadiy apiyim vasiyi vasiyaan tikwadana pik. Atampik adiy duw taakw vasiyi vasiyaan tikidana gwura majim.” ");
INSERT INTO mle_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Adiy Godak bas sikir wakigwuradiy jaav God gwurak kwiykidadiy. Adiy pakwun rinadiy javik gwur kwakikuw, adiy sitakira-kigwuradiy. Adiy wiyig dayaam viyakiti-kigwura, adiy wiyig gwurak sakwutaka-kidanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","“Ababa duw taakw dayadiy Godak bas sikidadiy jaav adiy kwurkidanadiy. Ababa duw taakw day adiy pakwun rinadiy javik kwakikuw, adiy sitakira-kidanadiy. Ababa duw taakw dayadiy viyakiti-kidanadiy wiyig adiy God dayak sakwutaka-kidadiy. ");
INSERT INTO mle_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Gwur asaay, li gwuradiy nyanugw gwurak yakuw bret kikir bas sidaak, gwur kabaak kwiy-kigwuradiy, ay? ");
INSERT INTO mle_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","“Day gwurak kamiy kikir bas sidaak, kabaay dayak kwiy-kigwuradiy kidakikik, ay? ");
INSERT INTO mle_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","“Gwur kupwarapa duw taakw-adiygwurik. Aw gwur gwuradiy nyanugwak viyakita jaav kwiy-kwanadiygwurik. Aw atawa kwurgwur, adawul tipaam kwanadi Asaay di gwuraam kakilkinaad dikik bas sigwuradiy jaav gwurak kwatiya-kidadiy. ");
INSERT INTO mle_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mawsis kwiydidiy lo wawa ababa God diki maaj wasapwiydiy duw dayadiy kalivadadiy majiwa dayadiy maw maaj, ‘Adiy jaav gwur duw takwak gwurak kwurdakik mawul yigwuradiy jaav, atampik nuwukadiy duw takwak akwur.’” ");
INSERT INTO mle_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Duw taakw kupwaraap tikidana tipaar yikwadanadi yaab, aad tupwiya wiyig tikuw, mwiya viyakitad. Alik samasama duw taakw yikwadanaad adi yabir. Duw taakw viyakit kwakidana tipaar yikwadanadi yaab, adi wiyig tupwiy maa ti. Kwasaadad. Nimadi yawiy kwurkuw, duw taakw yikwadanaad adi yabir. Alik duw taakw nakanak yikwadanadiy adi yabir. Aw gwur kwasadi yabir maay.” ");
INSERT INTO mle_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Gwur yarakara ada. Nuwukadiy duw day yakinadiy gwurak. Aw day God diki maaj wasapwiynadiy duw kaytik yakinadiy gwurak. Aw day suwaal takatak tikinadiy duw-adiy gwurak. Aw day gwurak yakuw, apaapap kwurkuw, gwur, ‘Kidiy God dikidiy viyakita duw-adiy,’ wakigwuradiy. Aw dayadiy mawul viyakita maa ti. Mwiya kupwarapa duw-adiy. ");
INSERT INTO mle_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","“Aw gwur dayadiy yawiy vikuw, dayadiy mawul ata lakwu-kigwuradiy. Balawiy wuw liki mwiya pik akis rikwana. Abagwaar ab kaam liki mwiya pik akis rikwana. ");
INSERT INTO mle_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","“Adi bapir bapir warkinadi miy nimaad tikuw, viyakita mwiy rikinaad. Adi ajikayin warkinadi miy nimaad tikuw, viyakita mwiy ri maa. ");
INSERT INTO mle_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","“Aw adi bapir bapir warkinadi miy nimaad tikuw, kupwarapa mwiy ri maa. Adi ajikayin warkinadi miy nimaad tikuw, viyakita mwiy ri maa. ");
INSERT INTO mle_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","“Adiy miy viyakita mwiy ri maarkinadiy, day adiy miy vilkuw, yaar yakisawula-kidanadiy. ");
INSERT INTO mle_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","“Atawa tikuw, adiy duw gwurak yakuw, gwur dayadiy yawiy vikuw, gwur lakwu-kigwuradiy day God diki maaj wasapwiy-nadiy duw maa. Suwaal takakwanadiy duw-adiy.” ");
INSERT INTO mle_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ababa duw taakw day wunak wakinadiy, ‘Min wunadi yitaypika duw-adimin’ adawul tipaar wul maa. Adiy duw taakw day wunadi Asaay diki majib wukikinadiy, dayada adawul tipaar wula-kinadiy. ");
INSERT INTO mle_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“God dikidi kot rikidadi nyi yadik, samasama duw taakw wunak wakidanadiwun, ‘Nyanadi yitaypika duw, nyan minadi saam God diki viyakita maaj wasapwiy-diyan. Minadi saam mawulaar yidiy wudib kwurin yakidiyan. Minadi saam nyan samasama nimadi yawiy kwurdiyan.’ ");
INSERT INTO mle_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Aw wun dayak ata wakituwadiy, ‘Gwur agwutak! Gwur kupwarapa vaal yidiy duw taakw-adiygwurik. Gwur Godak mwiyir wukijibir ti maargwuril alik wun gwuraam maa laakw!’” ");
INSERT INTO mle_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","“Lakwunadi duw nak dikidi wiy kabakim kwurdid. Ginyir nimadi waal jadik, guw ata warid. Warkuw, giviy yaan nimadi mwar viyaan adi wiyaam kwurdik, adi wiy kabakim tikuw, samab maa vakir. Ababa duw taakw day wuna maaj wukikuw, a majib wukikidana, day adi lakwunadi duw kaytik tikinadiy. ");
INSERT INTO mle_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Mawul wak maarin apar apar yawiy kwurnadi duw di dikidi wiy kwula yawiyim kwurdid. Ginyir nimadi waal jadik, guw ata warid. Warkuw, giviy yaan nimadi mwar viyaan adi wiyaam kwurdik, adi wiy kwula yawiyim tikuw, ata vakirid. Ababa duw taakw day wuna maaj wukikuw, a majib wak maarkidana, day adi mawul wak maarin apar apar yawiy kwurnadi duw kaytik tikinadiy.” ");
INSERT INTO mle_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisas kidiy maaj wakwusin napadik, adiy vagaruwdiy duw taakw ata pitaan wardiy diki wadil majik. Di samasam lakwukuw, apawa kalivadidiy. Adiy God diki lo kalivadiy duw, day atampik akis kalivayi-kwadiy. ");
INSERT INTO mle_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas mala abwa nibwukarib dadik, samasama duw taakw diki kwukib yadiy. ");
INSERT INTO mle_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lepa duw nak yakuw, Jisasak kwatiyir sikuw, ata wadid, “Mina mawul warlik, wuna sip sipwutiy-kimina.” ");
INSERT INTO mle_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisas taab ata dikim takakuw, ata wadid, “Wun minak sipwutiyik viyakit timinkikik.” Ata wadik, adi lepa duw diki sip viyakita mwiy tal. ");
INSERT INTO mle_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisas dikik ata wadid, “Min awuk. Kipa duw takwak wawayik ki minaam kwurtuwa javik. Aw yabiyib maay pris ak mina sip vidikikik. Tayir Mawsis gwurak wadidiy jaav akwiy pris ak Godak kwiydikik. Alik ababa duw taakw lakwu-kwadiy mina giviyib bwu kwusina wakuw.” ");
INSERT INTO mle_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Jisas Kapanam tipaar wuladik, Roma vay sawdiy duw duwamiy tabab dayadi sapakwa nyan dikik yikuw, ata Jisasak nimadib bas sidid, “Yitaypika duw, wunadi yawiy nyan dikidiy ap bwan kiyadak, wiyaam rinaad. Miyawa sip kagil yikwana.” ");
INSERT INTO mle_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisas ata wadid, “Wun yikuw, diki sip sipwutiy-kituwa.” ");
INSERT INTO mle_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Aw adi Roma vay sawdiy duw duwamiy tabab dayadi sapakwa nyan Jisasak ata wadid, “Atawa maa. Li min wuna wiyaar yiyi maa. Min nimadi sapakwa nyan-adimin. Kilib tan kipa majadika wamin, wunadi yawiy nyan diki giviyib kwusilikik. Wun wunabab sapakwa nyanugw wunaam van tikwanadiy. Daya majib wuki-kwanadiwun. Aw alik nuwukadiy duwaam van tikwanadiwun. Vay sawdi duw nikik, ‘Maay,’ watuwkikib, yikwanaad. Nikidi vay sawdi duwak, ‘May,’ watuwkikib, yakwanaad. Wunadi yawiy nyinik, ‘Ki yawiy akwur,’ watuwkikib, a yawiy kwurkwada. Minabab God diki majib wukikuw, diki ap kwurnadimin. Min alik kipa majida wamin, wunadi yawiy nyan diki giviyib kwusilikik.” ");
INSERT INTO mle_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Roma jaka tipa kidi duw wadil maaj Jisas wukikuw, pitaan warkuw, diki kwukib yadiy duw takwak ata wadidiy, “Kidi Roma jaka tipa kidi duw wunak samasam wukijibir tinaad. Yisrayil jaka tipa kidiy duw taakw nak wunak wukijibir kidi duw kaytik tidaak, wun samab maa vi. ");
INSERT INTO mle_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","12","“Gwur yarakara awuk! Yisrayil jaka tipa kidiy duw takwada God dikidi tipaar wul maa. Samasam kidi kupwa kidiy duw taakw dayabab wulakinadiy God dikidi tipaar. Wulakuw, Aparam Aysakawa Jakap day gwalugw nak tikuw, dayawa kamnaagw nakamwiyib kikinadiy. Aw samasama Yisrayil jaka tipa kidiy duw taakw wul maa dikidi tipaar. Aw God maa wakuw dayak, kawaar wayakidik, gaan kwusin tikina tamiyaam kwakinadiy. Alim kwaan girataay, dayadiy wuk vatikirikiyin kwurkinadiy.” ");
INSERT INTO mle_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jisas adi Roma vay sawdiy duw duwamiy tabab dayadi sapakwa nyan dikik ata wadid, “Min mina wiyaar maay. Aw wukijibir timina jaav mwiyir tikina wukijibir timina pik.” Ata wataay tidik, adi yawiy nyan diki giviyib jayib nak kwusil. ");
INSERT INTO mle_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas Pita diki wiyaar yin wardik, Pita diki nakim vidil sip kuwkuw nalik, jabim daan kwaal. ");
INSERT INTO mle_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisas liki tabaam wapwadik, kuwkuw nal sip ata yabiyib nikir tayil. Rasikuw, kamnaagw ata sukwulik yilidiy Jisasak. ");
INSERT INTO mle_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Giraab, nyi dadik, samasama duw taakw nuwuk wudib mawulaar yidadiy, nuwuk giviyib kwurdiy, Jisasak kwurin kariyadadiy. Samasam niki giviyib niki giviyib kwurdiy duw taakw Jisas sipwutiydidiy. Nuwukadiy duw taakw wudib mawulaar yidiy Jisas adiy wudibak, “Gwur agwutak!” wadik, tabwudiy. ");
INSERT INTO mle_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jisas atawa kwurdil, God diki maaj wasapwiydi duw, Aysaya, diki sukwudil maaj ata mwiya mwiyaba maaj tal. Aysaya ata waad: “Nyanadiy giviyib kwurin yakikuw, nyanadiy kupwarapa amwiy sipwutiy-didiyan.” ");
INSERT INTO mle_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas vidil, duw taakw samasam vagaluwdiy dikik. Alik dikidiy kalivadidiy duwak wadidiy, “Gwur jabiraar salin awul. Wulakuw, kalakiy agika maka araar vakiynaak.” ");
INSERT INTO mle_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wakuw wadik, God diki lo kalivadi duw nak Jisasak yakuw, ata waad, “Kaliva-kwanadi duw, wun mina kwukib yikir yikiminadiy tamiyaar.” ");
INSERT INTO mle_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aw Jisas adi duw diki mawul kwurkitaan vikir, dikik ata wadid, “Sapiy as kawaam sikwanadiy. Wapiy kwaat sitaay, si kwanadiy. Aw wun, duw taakw dayadi Mwaam, wun si kwa tamiy maa ti.” ");
INSERT INTO mle_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jisas kwukib yidi nikidi duw, Jisasak wadid, “Yitaypika duw, wunadi asaay kiyakiyab kwanaad. Alik wun yikir dikik kavin kwakir kawamiyaam takak.” ");
INSERT INTO mle_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisas ata wadid, “Min wuna kwukib ada. Wuna kwukib ti maarnadiy duw day kiyanadiy duw taakw kawamiyaam taka-kwadiy.” ");
INSERT INTO mle_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wakuw wadik, Jisas ata jabiraar salin wulaad. Aw dikidiy kalivadidiy duw day nakamwiyib yidiy. ");
INSERT INTO mle_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yibwun wapakuw, yidaak, jayib nak nimadi mwar ata yaad. Yakuw, ata mam kwasa jabiraam viyadaak, guw jabiraar wuladik, kapwuk ata kwuril. Aw Jisas di si kwaad. ");
INSERT INTO mle_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jisas dikidiy kalivadidiy duw day samasam yagakuw, yikuw Jisasak, warjawiyadaad. Warjawiyakuw, day ata wadaad, “Yitaypika duw, nyan aka kiyapakwu-kinadiyan!” ");
INSERT INTO mle_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisas dayak ata waad, “Gwur agwak yaga-nadiygwurik? Gwur wunak wukijibir maa ti?” Rapikuw, Jisas ata mamawa mwurik, “Akwus!” wadik, a ar kipa guw ral. ");
INSERT INTO mle_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dikidiy kalivadidiy duw ata pitaan warkuw, ata bwuladiy, “Kad aka tamiya kidi duwad? Wadi majib nima mamawa mwar abira bwutaay kwusinabir.” Dayadiy mawulaar ritaay, bas atawa sidiy. ");
INSERT INTO mle_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Day kalakiy agika maka araam tabirkuw, Gadara daya tamiyaam kawiydiy. Kawiykuw, duw vitiy bir dipwu kawamiyaam kwakuw, Jisasak ata yabir. Abir duw wudib mawulaar yidabir. Alik mwiya kupwarapabir. Bir kwabiril tamiyaar duw taakw akis yikwadaal. ");
INSERT INTO mle_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Abir duw Jisasak gaam sibirid, “Min God dikidi Nyan-adimin, min agwa jaav anaam kwurik? Ana kot rikita nyi maa nibway yay. Alik anaam yabiyib kupwaraap kwurwayik.” ");
INSERT INTO mle_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Abir duw mawulaar yidiy wudib day vidadiy adiy bwal walibab tan vas kidaak. Vikuw, day Jisasak nimadib bas sidaad, “Li min nyanaam wayakik tikuw, kidiy bwalaam wamin, nyan wulayaki-naak.” ");
INSERT INTO mle_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisas “Maay,” wadik, day ata abir duwaam wapakuw, adiy bwalaam wulayaki-diy. Adiy bwal abab gipakuw, daan nima dipwu wamwunir dadiy. Dakuw, guw kikuw, abab kiyapakwu-diy. ");
INSERT INTO mle_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Adiy bwalak van tidiy duw a jaav vikuw, tabwudiy daya tipaar. Tipaar wulakuw, day duw takwak wasapwiy-dadiy ababa jaav. Wadadiy, “Abir wudib mawulaar yidabir duw Jisas adiy wudib bwutaay wadik, yagakuw, nyanadiy bwalaar wulakuw, adiy bwal gipakuw, nima wamwun rina guwaam sakirakuw, guw kikuw, bwutaay abab kiyanadiy.” ");
INSERT INTO mle_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aw alik ababa duw taakw a tip wapakuw, Jisasak yidiy. Yikuw, day dikik ata nimadib bas sidaad, “Min ki tamiy awap!” wakuw wadiy. ");
INSERT INTO mle_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas jabiraar ata salin dakuw, suwulin araar vakiyid diki tip Kapanimaar. ");
INSERT INTO mle_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Vakiykuw, alim kwadik, nuwukadiy duw ap lupwun ridi duw bayim takakuw, kariyadaad Jisasak. Jisas wukidil day samasam wukijibir tidiy di bwunak kidi duwaam sipwutiy-kidaad wakuw. Alik di ap lupwudi duwak ata wadid, “Wunadi nyan, minadiy vaal wun yibwiy-tuwadiy.” ");
INSERT INTO mle_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nuwukadiy God diki lo kalivadiy duw day daya mawulaam wadiy, “Agwa javik kidi duw atawa wanaad? Godak wajibaynaad.” ");
INSERT INTO mle_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas dayadiy mawul vikuw, ata wadidiy, “Agwa javik gwur atawa kupwarapa mawul tinadiygwur? ");
INSERT INTO mle_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Agwa jaava kakilkina wun kwurkwurik, aw gwur vikuw, ‘Ayiy’ wakigwura a javik. Kidi ap lupwudi duwak wakituwad, ‘Minadiy vaal yibwiy-tuwadiy,’ ay ‘Min arap. Rapikuw, minadi baay kwurkuw, min maay.’ ");
INSERT INTO mle_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“Wun gwurak simaka-kituwa wun, duw taakw dayadi Mwaam, ki kupwaam ap kwurtuwaal duw taakw dayadiy valik yibwiy-tuwkik.” Di ap lupwudi duwak ata wadid, “Wun minak watuwa, arap! Minadi baay kwurkuw, maay mina wiyaar.” ");
INSERT INTO mle_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Rapikuw, adi duw diki wiyaar ata yad. ");
INSERT INTO mle_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Abab a jaav vikuw, pitadiy. Pitakuw, ata wadiy, “Wa! Tayir nyan atawa maa vi. God duwak kwiydaal apa mwiya nimaala.” Wakuw, day gaba maaj sukwudiy Godak. ");
INSERT INTO mle_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas adi tip wapakuw, yitaay tidik, takis saan kwurdi duw, Matiyuw opis im ridik Jisas vidid. Jisas dikik ata waad, “Wuna kwukib may.” Wakuw wadid, Matiyuw rasikuw, diki kwukib yad. ");
INSERT INTO mle_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ginyir Jisas kikipaat kidik Matiyuw diki wiyaam, dikidiy kalivadidiy duwawa samasam takis saan kwurdiy duw, nuwukadiy vaal yidiy duw ab alim jabim ridiy. ");
INSERT INTO mle_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nuwukadiy Parasiy bapa duw day vikuw Jisas takis saan kwurdiy duw nuwukadiy vaal yidiy duwawa kikipaat kad. Dikidiy kalivadidiy duwak bas sidadiy, “Agwa javik di takis saan kwurnadiy duwawa vaal yinadiy duwawa kikipaat kinaad?” ");
INSERT INTO mle_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Jisas daya maaj wukikuw, dayak ata wadidiy, “Giviyib kwurnadiy duw adika dokta ak yikwanadiy. Kip ti duw yiyi maa rav. Wun vaal yinadiy duwadiy danik yanadiwun dayak sugwiyaan kwurkuw, day dayadiy bwan dayadiy vaal kwiydakik. Atawa wun viyakita duwak maa yay. Ki God wadil maaj God diki lapa nyigaam rina. Di waad, ‘Wunak animal kabaka jabim gwuradiy valik dayada taka-tikwa. Gwur yikuw, nuwukadiy duw takwak awuk.’ Gwur yin ki God wadil maaj liki maw maaj awuk.” ");
INSERT INTO mle_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jon Baptais kwiydi duw, dikidiy kalivadidiy duw Jisasak yakuw, wadaad, “Nyan, Jon Baptais kwiydi duw dikidiy kalivadidiy duw, Parasiy dayadiywa nuwukadiy nyaam kikipaat akis kikwanadiyan gaba maaj sukwuk Godak. Agwa javik minadiy kaliva-minadiy duw atawa kwurin maarnadiy?” ");
INSERT INTO mle_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas dayak wadidiy, “Kapa nyanugw, duw taakw kiradil nyi kikipaat akis kikwanadiy? Si wana? Di dayawa kwakuw, day rakarak tikuw, atawa maa kwar. Ginyir yadaak, day taakw kiradil duw kwurin karaykuw, dayadiy mawul pakwun nadaak, adiy kapa nyanugw kikipaat ki maa a nyaam. ");
INSERT INTO mle_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Duw akis jaba wapwiyim tina tap aw kwula wapwiy kwurkuw, tipatip a maa rav. Aw a kwula wapwiy karyakin yikuw, adi tap ata nima tikina. ");
INSERT INTO mle_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Duw akis meme likidi sip jaab tidaak, kwula wain kwurkuw, adi sipaam vagavag maa rav. Adi sip wain awa wulwul maa rav. Alik wutak-na aw sipawa wain kupwaraap tikina. Duw kwula wain kwula meme sipaam vagakwanadiy.” Jisas kidiy waya maaj kitika maaj mugwul dayak wadidiy. ");
INSERT INTO mle_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas kidiy maaj watay tidik, Juw daya gaba maja wiya kidi sapakwa duw Jisasak yakuw, diki manwa vakirkuw, ata wadid, “Wuna kwasa takwa nyan bwutaay kiyana wayab. Aw min yakuw, lim taab takamin, rasilikik.” ");
INSERT INTO mle_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aw Jisas rasikuw, diwa yidik, Jisas dikidiy kalivadidiy duw nakamwiyib yidiy. ");
INSERT INTO mle_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Taakw nak waany wakwun tiya-lidiy nabiy tabatiy maan vitiy. Aw liki mawulaar ata waal, “Li wun taab dikidi wapwiy dikinim wapwa-kituwa, wun ata yara tikinawun.” Liki mawul warlik, Jisas yitaay tidik, li diki kwukir yakuw, Jisas dikidi wapwiyim ata tabaar kwasa kwasa yakitaay, wapwalid. ");
INSERT INTO mle_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wapwalik, Jisas tipatiyakwukuw, lim vikuw, ata wadil, “Wuna takwa nyan, yaga-tikwa. Nyin wunak wukijibir tinyinalik, alik nyina giviyib bwu kwusina.” Ata wadik, a taakw liki giviyib ata bwu kwusil. ");
INSERT INTO mle_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aw Jisas gaba maja wiya kidi sapakwa nyan diki wiyaar yin warkuw, vididiy samasama duw taakw, nuwukadiy kaany kwudiy, nuwukadiy giradiy. Alik pipiliy samasam takadiy. ");
INSERT INTO mle_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Vikuw, Jisas ata wadidiy, “Gwur abab awap kawaar! Kwasa nyan li maa kiy. Li kip si kwana!” Atawa wadik, day abab wajikuw, wajibaydiy dikik. ");
INSERT INTO mle_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Adiy duw taakw kawaar wayakidik, wakwudaak, Jisas kwasa nyan kwalil tamiyaar wulakuw, liki tabaam kaykitidik, li ata rasil. ");
INSERT INTO mle_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A tamiyaam kwadiy duw taakw abab ata wukidaal a javik. ");
INSERT INTO mle_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas a wiy wapakuw, yitaay tidik, mil kwakibir duw vitiy diki kwukir yibir. Yikuw, Jisasak gaam sibir, “Min nyanadi warag dayadi yitaypika duw Davit dikidi gwalugwa duw-adimin. Anak awuk!” ");
INSERT INTO mle_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas yala wiyaar wuladik, abir duw ata yabir dikik. Yabir, birakik bas sidibir, “Bir bira mawulaar wukijibir tinabirbirik wun birabir mil sipwutiy-tuwkik?” “Ayiy, yitaypika duw,” wabirid. ");
INSERT INTO mle_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jisas birakibir milaam wapwakuw, wadibir, “Bir wunak wukijibiran tibiralik, alik ki jaav wukibira pik tikina.” ");
INSERT INTO mle_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wakuw, wadik, jayib nak ata birabir mil mwiyir vibirbir. Jisas ata nimadib wadibir, “Ki birak kwurtuwa jaav nuwukadiy duw takwak wawayik!” ");
INSERT INTO mle_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ata wadik, Jisasaam wapakuw, abir duw abab a tamiyaam kwadiy duw takwak wasapwiy-biril a javik. ");
INSERT INTO mle_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Abir duw wapakuw yibir, nuwukadiy duw taakw duw kwurin Jisasak kariyadaad. Wudib adi duw diki mawulaar yidilik, alik maaj akis bwulakwaad. ");
INSERT INTO mle_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisas adi wudib kwurin yakidik, adi duw ata maaj bas bwulaad. Ababa duw taakw a jaav vikuw, pitaan wardiy. Warkuw, awarwa awarwa bas sitaay, ata wadiy, “Nyan kitampika jaav tayir van maa ti Yisrayil jaka tipaam!” ");
INSERT INTO mle_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aw adiy Parasiy bapa duw ata wadiy, “Satan dikik ap kwiydalik, alik kidiy kupwarapa wudib kwurin yakididiy.” ");
INSERT INTO mle_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aw Jisas ata miyawa nimadiy tipawa kwasadiy tipaar yad. Yikuw, Juw dayadiy gaba maja wiyaam maaj wasapwiydil God dikidi duw takwak van tikida nyak. Adiy niki giviyib niki giviyib kwurdiy duw taakw adiy duw taakw dayadiy amwiy kupwaraap-adiy, sipwutiy-didiy. ");
INSERT INTO mle_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jisas duw taakw samasam vikuw, dayadiy mawul jawjaay tidaak, di samasam wukid dayak. Di wukidil, day duw van ti maardadiy sipsip kaytik, day jawjaay yin yaan tidiy miyawa tamiyaam. ");
INSERT INTO mle_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wukikuw, Jisas dikidiy kalivadidiy duwak wadidiy, “Samasama kikipaat bwutaay rawnadiy mayim. Aw dayaam yin kwurin kariya duw maa. ");
INSERT INTO mle_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","“Aw alik gwur bas as adi maay duwak di duw wayakidikik adiy kamnaagw vagaruwtaka-dakik. Aw God wukikuw, duw wayakidik yikuw, duw taakw samasam kupwaraap ti maa.” ");
INSERT INTO mle_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas dikidiy kaliva-didiy duw tabatiy maan vitiy dayak gaam sididiy yadakikik dikik. Yadaak, dayak ap kwiydid mawulaar yinadiy wudib kwurin yakidakik. Di ap dayak kwiydidiy day ababa niki giviyib niki giviyib kwurdadiy duw taakw sipwutiy-dakik. ");
INSERT INTO mle_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kidiy duw tabatiy maan vitiy day Jisas dikidiy wayaki-didiy duw tidiy, dayadiy si: Taay Sayman sikiy-wadana Pita, dikidi nyamwus Adiruw, Jamisawa Jon Sipatiy dikibir nyidiy, ");
INSERT INTO mle_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","4","Pilipawa Batalamuw, Tomasawa Matiyuw takis saan kwurdi duw, Jamis Alpiyas dikidi nyinwa Tatiyas, ap samasam tidi wariya duw Sayman. Dayawa Juwtas Yiskariyat. Ginyir di Jisasaam kwiydid Jisas dikidiy mama nibak. ");
INSERT INTO mle_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas adiy tabatiy maan vitiya duw wayakidik, kidiy maaj wadidiy, “Samariya dayadiy tipawa nuwukadiy jaka tipa kidiy duw taakw dayadiy tamiyaar yitikwa. ");
INSERT INTO mle_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","“Aw gwur Yisrayil dayadiy tipaar maay. Yisrayil tipa kidiy duw taakw day kupwaraap tinadiy God diki maaj wukin maa ti. ");
INSERT INTO mle_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Yikuw, dayak ki maaj awasapwiy, ‘God diki duw takwak van tikidi nyi walibab tina.’ ");
INSERT INTO mle_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Adiy barik kwurnadiy duw taakw asipwutiy. Adiy kiyanadiy duw taakw akirapitak. Lepa tinadiy duw taakw asipwutiy. Adiy duw takwaam kwanadiy wudib kwurin ayak. Ap kip kwatiya-tuwadiygwur, aw alik gwur mawul war-tikwa saan kwurkwurik gwuradiy yawiyik. ");
INSERT INTO mle_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Gwur saan gwuraam kwurin karay-tikwa. ");
INSERT INTO mle_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","“Wadiy kwusuwin tigwuradiy javida, yaakiya. Nuwukadiy kwasabiy, kwusuw wapwiy, kwusuw waliy maan, kwala miy bag, kwurin karay-tikwa. Gwur adiy duw takwak yawiy kwurgwur, aw day niki jaav niki jaav kwiy-kidanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Tipaar yikuw, wulakuw, viyakita duw sitakirakuw, a tipaam kwa-kigwuradiy nyi diwa adakw. ");
INSERT INTO mle_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","“Wiyaar wulakuw, a wiyaam kwanadiy duw takwak, ‘Gwur yara adakw’ aw. ");
INSERT INTO mle_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","“Li a wiyaam kwanadiy duw taakw, ‘Ayiy’ wakuw, wadaak gwurak, adiy yara kwakinadiy. Aw li day gwurak, ‘Maa’ wakidana, gwurada yara kwa-kinadiygwur, aw day maa. ");
INSERT INTO mle_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Li wiyaam kwanadiy duw taakw, ay tipa kidiy duw taakw gwurawa gwuradiy majik maa wadaak, bwan dayak kwiykuw, manim tikinadiy kupw dayak aviyawarikitay day lakwu-dakik day kupwarapa jaav gwurawa Godak kwur-danaala. Viyawarikin napakuw, gwur dayaam ata awap. ");
INSERT INTO mle_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","“Gwur ki maaj yara awuk. Ginyir God dikidi nimadi kot rikidi nyi, di abir tayir ribir tip Satamawa Gamara, abir tipa kidiy vaal yidiy duw takwak maa wakidadiy. Aw li gwurak maa wakinadiy duw taakw adiy mwiya maa wayakiyaki-kidadiy!” ");
INSERT INTO mle_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisas niki maaj dikidiy kalivadidiy duwak wadidiy, “Gwur yara awuk! Kita aka wayakituwik, yikigwura ki yawiyik. Adiy sapiy as sipsip aam jawjaay kwurkwadanadiy. Atampik gwuraam adiy yikigwuradiy tipaam adiy yikigwuradiy tipa kidiy duw gwuraam jawjaay kwur-kidanadiygwurik. Gwur kabaay yiyi tamiyak vitaay taytaya yitaay yikwadana pik maay. Midakim rikwala pik, atampik ada. Midakim li mayim tin javim akis jaal dakwana. Atampik gwur yikuw, kupwarapa jaav kwurkwur mawul simsim titikwa. ");
INSERT INTO mle_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Gwur yarakara av. Adiy duw gwuraam kalakwukuw, dayadiy kot ir karay-kidanadiygwurik. Nuwukadiy gwuraam miyaar viyakidanadiygwurik dayadiy gaba maja wiyaam. ");
INSERT INTO mle_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“Aw gwur wunadiy kalivatuwadiy duw tigwuralik, day gwuraam kalakwutaay, karay-kidanadiygwurik kotir rigwurkikik dayadiy sapakwa duwawa yitaypika duwak. Gwur alik dayawa nuwukadiy jaka tipa kidiy duw takwak wuna viyakita maaj wasapwiy-kigwuradiy. ");
INSERT INTO mle_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","“Aw gwur wunadiy duw taakw tikuw, a javik kot im tikuw, bwulabwula majik wuki-tikwa. A nyi God di diki maaj kwiy-kidadiygwurik. Wakigwuradiy maaj adiy gwuradiy maaj maa. God gwuradi Asaay, dikidi Mawul gwura bwula-kigwura majiwa nakamwiyib bwulakinaad. ");
INSERT INTO mle_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ginyir duw dayadiy mamugwawa nyamwusugw kot ir karay-kidanadiy viyasipadakik. Asaay ab atawa kwur-kidanadiy dayadiy nyanugwaam. Nyanugw ab dayadiy amaay asayik maa wakuw, kot ir karay-kidanadiy viyasipadakik. ");
INSERT INTO mle_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","“Gwur wunadiy duw tigwuralik alik samasama duw taakw maa wakinadiy gwurak. Li duw wunak wukijibir tan yin kidiy kupwarapa jaav kwusidaak, adi duw God kwurkidaad. ");
INSERT INTO mle_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Day gwuraam kupwarapa jaav kwurdaak, aw gwur atabw niki tipaar. Wun mwiya maaj watuwa gwurak gwuradiy yawiy kwas maardaak ababa Yisrayil tipaam, aw wun, duw taakw dayadi Mwaam, ata sibinin yakidiwun. ");
INSERT INTO mle_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Gaba maaj kalivadadiy nyanugw aw dayadi gaba maaj dikim kakil-kakil maa. Atawa yawiy duw dayadi van tinadi duw dikim kakil-kakil maa. Li adiy nyanugw gaba maaj kaytik tikidana, aliba viyakita. Li adiy yawiy duw van tinadi duw kaytik tikidana aliba viyakita. Nyanabab atampik tinadiyan. Day sikiytaka-dadiwun, gwuradi van tinadi duw Biyilsipap adi taay wudibad. Gwur wuna kwukib yagwuralik alik day mwiya kupwarapa si sikiytaka-kidanadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Alik gwur yaga-tikwa. Ababa jaav adiyka pakwun rinadiy, ginyir abab maykaar warkinadiy. Ababa jaav sapwutakada rinadiy ginyir adiy jaav ababa duw taakw lakwu-kidanadiy. ");
INSERT INTO mle_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“Adiy jaav pakwun tan gwurak watuwadiy, ginyir gwur maliykaam tan ababa duw takwak wasapwiy-kigwuradiy nyidi tipaam tan. ");
INSERT INTO mle_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Gwur yaga-tikwa duwak. Day amwiyda viyasipa-kidanadiy, li kayik a maa. Li gwur Godak ayag. Di amwiywa kayik nakamwiyib bwunak kupwaraap kwurkidabir kupwarapa tamiyaam. ");
INSERT INTO mle_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Saan nak kwasadiy wapiy duwamiy nak duw yapiy-kwadanadiy kidakikik. Aw kwasa wapiy nak kip kupwaam vakirvakir maa. God, gwuradi Asaay, bwutaay lakwuda yaakiya wakuw. ");
INSERT INTO mle_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","“Gwuradiy abwaam tinadiy nab kas-adiy? God bwutaay lakwudadiy. ");
INSERT INTO mle_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","“Gwur kwasadiy wapiy maa. Gwur mwiya duw taakw-adiygwurik. Alik gwur wukitikwa. God, nyanadi Asaay, di gwurak yara van tikwanaad.” ");
INSERT INTO mle_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Li duw nak duw taakw mwutamaam tan dayak wakida, ‘Wun Jisas dikidi duw-adiwun’ waan, wunabab wunadi Asayik wakituwaad, ‘Adi duw wunadi duwad.’ ");
INSERT INTO mle_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","“Aw li duw nak duw taakw mwutamaam tan dayak wakida, ‘Wun Jisas dikidi duw maa’ waan, wunabab wunadi Asayik wakituwaad, ‘Adi duw wunadi duw maa.’” ");
INSERT INTO mle_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","36","“Wun kidi kupwaar datuwik, duw taakw dayadiy wariya mawul kwusidakik maa di. Wun datuwil day wariyadakik. Nuwukadiy wunak wukijibir tikinadiy alik nuwukadiy duwa nyan asaywa wariya-kinadiy, takwa nyan amaywa wariya-kinadiy, duw dayadiy taakw dayadiy kajalawa wariya-kinadiy. Adiy wiy nak duw taakw day rasikuw, day mwiya mam tikidiy wunak wukijibir tikidiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","38","“Aw li duw taakw dayadiy amaay asaay, duwa nyanugw takwa nyanugwak yikwadanadiy mawul dayadiy wunak yikwadanadiy mawulaam yitaypik tikidana, adiy duw taakw wuna gwalugwur samab wulawul maa. Li adiy duw taakw day dayadiy mawul yidadiy javik maa wakuw, aw day wuna danik wakuw nuwukadiy duw dayak kupwarapa jaav kwurdaak day wunak bwan kway maarkidana, adiy duw taakw, adiy wunadiy-adiy. ");
INSERT INTO mle_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Li wunak yawiy kwurkuw, aw wuna danik wakuw, kiyakinadiy, adiy nyanyi nyanyi wunawa kwakinadiy. Aw li day dayadiy sipa danik wukikuw, kiyakidiy, adiy nyanyi nyanyi kupwaraap tikidiy.” ");
INSERT INTO mle_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ki niki maaj Jisas dikidiy kalivadidiy duwak wadidiy, “Li duw gwurak wakaray kwurkidana, adiy wunak wakaray kwurdana pik kwurkidanaala. Li duw wunak wakaray kwurkidana, adiy wunaam wayakidi Asaay dikik wakaray kwurdana pik kwurkidanaala. ");
INSERT INTO mle_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","“Li duw God diki maaj wasapwiynadi duwak ‘Kad God diki maaj wasapwiynadi duwad’ wakuw, yarakara dikik kwurkwadana, adi duwad God diki maaj wasapwiynadi duw God dikik adawul tipaam kwiykida java pik dikibab God kwiykidaad. Li duw mwiya viyakita duwak ‘Kad mwiya viyakita duwad’ wakuw, yarakara dikik kwurkwadana, adi duwad mwiya viyakita duw God dikik adawul tipaam kwiykida java pik dikibab God kwiykidaad. ");
INSERT INTO mle_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Gwur ki maaj wukimar-tikwa. Li duw kipa duw takwak ‘Kad Jisas dikidi kalivadidi duwad’ wakuw, adi kupwaam nikil nikil guw kidikikik kwiykinaad, adi duw diki kwasa yawiy God wukimar maa. Adawul tipaam jaav kwiykinaad dikik.” Jisas dayak wadidiy maaj ata kwusidiy. ");
INSERT INTO mle_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas dikidiy kalivadidiy tabatiy maan vitiya duwak maaj waan napakuw, ata tip wapadil. Wapakuw, walibab ridiy tipaar yikuw, duw takwak maaj kalivaan wasapwiy-didiy. ");
INSERT INTO mle_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon Baptais kwiydi duw, kalabus im kwadik, Jisas kwurdidiy yawiy maaj ata wukidil. Wukikuw, dikidiy kalivadidiy duw Jisas Kraisak wayakidik, yidiy dikik bas sidakikik. ");
INSERT INTO mle_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Day Jisasak ata bas sidaad, “Min kidi kavin kwabanadi duw-adimin, ay nikidi duwak kavin kwakidiyan maa?” ");
INSERT INTO mle_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","6","Aw Jisas dayak ata wadidiy, “Gwur sibinin maay Jonak. Yikuw, kidiy vikuw wukigwuradiy jaav dikik aw. Adiy mil kwakidiy duw taakw, adiy maan kupwaraap tidiy duw taakw, adiy lepa tidiy duw taakw, adiy waan tipidiy duw taakw, adiy abab wun sipwutiyaki-tuwadiy. Adiy kiyadiy duw taakw kirapituwik rasidiy. God diki viyakita maaj saal yinadiy duw takwak wasapwiy-tuwadiy. Li adiy duw taakw mawul vitiy ti maarkuw, wunak wukijibir tikinadiy, adiy rakarak samasam tikinadiy. Bir yin Jonak kidiy yarik yituwadiy jaav yin dikik aw.” ");
INSERT INTO mle_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon dikidiy kalivadidiy duw Jisasaam wapakuw, yidaak Jonak, Jisas vagaruwdiy duw takwak wadidiy, “Gwur kipa tamiyaar yigwuril Jonak vikir, atata duwad waan wadiygwurik? Li di ap timaardi duw kwasa mwiya mwar viyalik adiy suw tagwaan kwakwadana pik? Atampika duw maa. ");
INSERT INTO mle_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","“Li gwur yigwuril viyakita wapwiy kwusuw ridi duw vikir yidiygwurik? Aw Jon atampika duw maa. Viyakita wapwiy kwusuw-kwanadiy duw viyakita wiyaam kwakwanadiy. ");
INSERT INTO mle_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Li gwur yigwuril God diki maaj wasapwiydi duw vikir yidiygwurik? Ayi, Jon di mwiya God diki maaj wasapwiynadi duw tinaad. Di ababa nuwukadiy God diki maaj wasapwiydiy duw kakildidiy. ");
INSERT INTO mle_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“God diki lapa nyigaam maaj wanaad dikidi Tasakwudidi Duwak Jon diki yawiyik. God wanaad: ‘Taay maaj kariyanadi duw wayakituwaad. Yin niki jaav niki jaav minak kwulapwu-kinaad.’ ");
INSERT INTO mle_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Wun mwiya maaj a gwurak wakituwa. Jon diki yawiy ababa tayir ki kupwaam kwadiy duw dayadiy yawiyim kakilna. Aw kita God dikidi gwalugwa duw taakw abab Jonak yitaypik tinanaad.” ");
INSERT INTO mle_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jisas ki maaj ab wadidiy, “Jon bas maaj wasapwiydik aw yaan kita ap tidiy duw day dayadiy mawulaar wadadiy yawiy kwurtuwkik. Aw atawa akis kwur-kwanadiwun. Wun ki yawiy kwurtuwa aw God duw takwaam van tidikikik diki mawul wadil pik. ");
INSERT INTO mle_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“Mawsis sukwudil lo wadidiy majiwa God diki maaj wasapwiydi duwawa aw yaan Jon day abab wasapwiydiy God dikidi duw takwaam van tikidi nyak. ");
INSERT INTO mle_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Aw gwur dayadiy majib wukijibir tikigwura, gwur lakwu-kigwura Yilayja taay yakuw, God dikidi Tasakwudidi duw ata yakinaad. Jonad di Yilayja. ");
INSERT INTO mle_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","“Duw waan tinaad di yarakara wukikwaad.” ");
INSERT INTO mle_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Jisas ata wadidiy, “Ki kupwaam kwanadiy duw taakw day kwasadiy nyanugw kitik. Day nyidi tipaam daan ritaay, nuwukadiy bapa kidiy nyanugw nikidiyik wasakiytaay kwadadiy, ‘Nyan kaagw sitaay, baagw tibakikib, aw gwur maa bag vas. Aw nyan gira-kwadanadiy baagw tibakikib, aw gwur maa gir.’ ");
INSERT INTO mle_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","19","“Jon yakuw, di gwuradiy kikwagwuradiy kikipatawa wain akis kikwanaad. Alik adiy nyanugw kaytika duw taakw wadana, ‘Kad wudib mawulaar yidalik, alik kwam yinaad.’ Aw wun, duw taakw dayadi Mwamad, yakuw, kikipatawa wain kikuw, day wadana, ‘Kidi duwab av! Bwal kaytik, kamnaagw kida kida kinaad. Ki kwam tikwadana guw samasam kikwanaad. Di takis kwurkwanadiy duwawa nuwukadiy kupwarapa duw taakw dayadi kapa duw-ad.’ Ginyir kidiy kwurtuwadiy ababa yawiyim vikuw, lakwu-kigwura God di wunawa tad.” Jisas atawa wadidiy. ");
INSERT INTO mle_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nuwukadiy tipaam Jisas samasama nimadiy yawiy kwurdidiy. Adiy tipa kidiy duw taakw dayadiy bwan kway maardiy dayadiy valik, alik Jisas dayak maa wakuw, wadidiy, ");
INSERT INTO mle_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","22","“Ginyir mwiya kupwaraap tikidiygwurik, Sarasinawa Bitsayta abir tipaam kwanadiy duw takwak. Li wun, abir haiden tip, Tayawa Saytan, adiy gwurak kwurtuwdiy nimadiy yawiy pik dayak kwurik-tuwa, day bwunak dayadiy valik samasam wukikuw, jaba wapwiy kwusuwkuw, kupw dayadiy sipaam yikuw, bwunak bwan dayadiy valik kwiyik-nadiy. Gwur awuk! Ginyir God dikidi nimadi kot im rikidi nyi, adiy Tayawa Saytan abir tipaam kwanadiy duw takwaam God kupwaraap kwurkidadiy. Aw gwuraam mwiya kupwaraap kwur-kidadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","24","“Aw gwur, Kapanam tipaam kwanadiy duw taakw, gwur wakwanadiygwurik, ‘Nyan adawul tipaar warkidiyan’. Aw gwur war maa. Gwur kupwarapa tipaar dakidiygwurik! Li wun adi tayir God yiy wapataka-didi tip, Satam, adiy gwurak kwurtuwdiy nimadiy yawiy pik dayak kwurik-tuwa, adi tip ki kupwaam kida rikik-da. Gwur yara awuk! Ginyir God dikidi nimadi kot im rikidi nyi, adiy Satam tipaam kwadiy duw taakw kupwaraap kwurkidadiy. Aw gwuraam mwiya kupwaraap God kwur-kidadiygwurik!” ");
INSERT INTO mle_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","A nyaam Jisas Godak ata wadid, “Wunadi Asaay, min yitaypik adawul tipawa kidi kupwak tinadimin. Wun minak rakarak tinadiwun wunadiy duw takwak kalivatuwadiy jaav dayadiy maw maaj samasam lakwunadiy duwak yipakwu-minalik. Aw dayadiy maw kwasa nyanugw kaytik tinadiy duw takwak simaka-minalik. Ayiy, Asaay, ki jaav min mina mawulaam rilik kwurmina.” ");
INSERT INTO mle_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jisas Godak waan napakuw, vagaluwdiy duw takwak ata wadidiy, “Wunadi Asaay diki mawulaam rinadiy jaav bwutaay abab wuna tabaam takadidiy. Duw nakab wun, God dikidi Nyinim, maa laakw. Aw wunadi Asaay di kap lakwu-dadiwun. Duw nakab wunadi Asayim maa laakw. Wun wunada, dikidi Nyan, dikim lakwutuwaad. Day adiy wun dayak adiy jaav simaka-tuwadiy, dayabab wunadi Asayim lakwu-danaad. ");
INSERT INTO mle_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Li gwur gwuradiy mawulaam samasam gwuradiy niki jaav niki javik wukikuw, gwuraam vaat samasam yidaak, wunak may. Yagwur, wunaam yaap ada. ");
INSERT INTO mle_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","“Gwur wunawa yawiy akwur. Kwurkuw, wun gwurak kalivaaw. Wuna mawul akis wariyi-kwana. Alik wunak yagwur, viyakit kwakinadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","“Aw wuna yawiy nima yawiy maa. Alik gwur wuna yawiy kwurkuw, gwuradiy mawul yaap tikidiy.” Jisas ata wadidiy. ");
INSERT INTO mle_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ginyir kwasa mwiy tikuw, Jisas wit (dayadiy mwiy kabasik kitik) rididi mayim tiytiyan tan Sapat nyi. Dikidiy kaliva-didiy duw kaam yisilik, aw day wit dayadiy mwiy kwurdadiy kikir. ");
INSERT INTO mle_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Adiy bapa Parasiy a jaav vikuw, Jisasak bas sidaad, “Min av! Agwa javik minadiy kaliva-minadiy duw nyana lo watipidada yawiy kwurdana?” ");
INSERT INTO mle_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Jisas dayak ata wadidiy, “Lapa nyigaam tayir Davit kwurdil jaav sukwudaal. Gwur maa vi? Di dikidiy duwawa kaam yisilik kikipaat kikir. Alik Davit God diki wiyaar wulakuw, Godak kwiydadiy bret kwurkuw, di dikidiy duwawa ata kidadiy. Aw nyana lo wana, ‘Pris dayadika adiy bret kikwadanadiy. Nuwukadiy duw taakw akis kikwadanadiy.’ Aw li gwur yaakiya wakwagwura Davit kwurdil yawiyik, agwa javik tikuw gwur maa wanadiygwur wunadiy kaliva-tuwadiy duw daya yawiyik? ");
INSERT INTO mle_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Aw gwur maa vi adiy pris Mawsis sukwudil lo liki majib wukikuw, yawiy kwurkwanadiy Sapat nyaam God dikidi wiyaam. Aw day gwuradi wagwur majik kwasik yinadiy, ay maa? ");
INSERT INTO mle_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Wun watuwadiygwurik nikidi kilim tinadi jaav God dikidi wiyaam yitaypik tinaad. ");
INSERT INTO mle_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Diki lapa nyigaam God wanaad, ‘Gwur yikuw, duw takwak sugwiyaan akwur. Wunak niki jaav niki jaav jaaw kwatiya-tikwa.’ Gwur ki God wadil maaj liki mwiya maw maaj gwur mwiyir maa laakw. Alik gwur maa wagwura adiy kupwarapa jaav kwar maarnadiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“Aw wun, duw taakw dayadi Mwamad, Sapatak van tikwanadiwun.” ");
INSERT INTO mle_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas a tip wapakuw, Juw daya gaba maja wiyaar ata wulaad. ");
INSERT INTO mle_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Duw nak diki baw taab bwu kiyaal alim rad. Nuwukadiy alim kwadiy duw dayadiy mawul wadiy, “Kipab Jisas kupwarapa jaav kwurdik, aw nyan nimadiy kot ir karay-kibanaad.” Alik day Jisasak bas sidaad, “Aw nyan duw nak Sapat nyaam diki giviyib ay diki kupwarapa amwiy sipwutiyik-banaad nyana lo maa wakina a javik? Ay maa?” ");
INSERT INTO mle_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisas ata wadidiy, “Aw gwura duw nak diki sipsip kawaam vakirkuw Sapat nyaam tilik, aw di dakuw, lim kaykitikuw, kawar-kidaal. ");
INSERT INTO mle_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","“Aw sipsip kip kwasa jaav-al, li duwad mwiya nimadi jaav-ad. Alik li wun duwaam viyakita jaav kwurtuwil Sapat nyaam, nyana lo yaakiya wana a javik.” ");
INSERT INTO mle_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jisas di baw taab bwu kiyadi duw ata wadid, “Mina taab akaynawul.” Kaynawuldik, diki taab ata viyakit tal diki niki taab kitik. ");
INSERT INTO mle_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Adiy Parasiy wakwukuw, day maaj ata lakatiydiy Jisasaam viyasipak. ");
INSERT INTO mle_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas a jaav wukikuw, a tip ata wapadil. A tip wapadik, duw taakw samasam diki kwukib ata yidiy. Adiy giviyib kwurdiy duw taakw dayadiy giviyib sipwutiy-didiy. ");
INSERT INTO mle_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Di kwasik yikuw, samasama duw taakw diki kwurdil yawiy wukidakik, alik di ata wadidiy, “Gwur nuwukadiy duw takwak watikwa a javik.” ");
INSERT INTO mle_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Atawa wadik, God diki maaj wasapwiydi duw Aysaya God diki lapa nyigaam sukwudil maaj ata mwiya mwiyaba maaj tal. Kitawa sukwudil: ");
INSERT INTO mle_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","God wanaad, “Gwur av. Kidi duw wunadi yawiy duw-ad. Di wunadi Tasakwu-tuwadi Duw-ad. Wuna mawul ab dikik yina. Wun dikik rakarak tinadiwun. Wun wunadi Mawul dikik kwiytuwik, di ata ababa jaka tipa kidiy duw takwak wasapwiy-kidadiy wunadi nimadi kot rikidi nyak. ");
INSERT INTO mle_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","“Aw di wariya maaj nimadib gaam san kwar maa. Nyidi tipaam tan gaam nimadib si maa. ");
INSERT INTO mle_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","“Adiy duw taakw dayadiy Godak wukijibir tikwanadiy mawul ap ti maarkwanadiy, adi Duw dayaam vasisad maa. Aw di dayaam sugwiyaan kwurdik, day ap tikidiy. Nuwukadiy kwasa mwiy Godak wukijibir tikwanadiy duw taakw day kwasa yakiy wakwujibir kwakwana yiy kaytik tikwanadiy. Duw yiy vajikiydik virkuw nima yiy tilikikik kaytik, adi Duw dayaam sugwiyaan kwurdik, Godak nima mawul wukijibir tikinadiy. Di atawa kwurkuw, Satanaam kakil-kinaad. ");
INSERT INTO mle_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","“Aw di atawa kwurdalik tikuw, alik ababa jaka tipa kidiy duw taakw dayadiy mawul dikik yikinadiy, ‘Di nyanak sugwiyaan kwur-kidadiyan’ wakuw.” Atawa Aysaya maaj wadil Jisasak. ");
INSERT INTO mle_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Day duw nak Jisasak ata kwurin karaydaad. Wudib adi duw diki mawulaar yidik, aw dikibir mil kwakibir. Maaj ab akis bwula-kwaad. Jisas adi duwaam sipwutiydik, dikibir mil vibir. Maaj ab bwulaad. ");
INSERT INTO mle_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Adiy vagaluwdiy duw taakw pitaan warkuw, ata wadiy, “Kidi duw God dikidi Tasakwudidi Duw, ay maa?” ");
INSERT INTO mle_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Adiy Parasiy a java maaj wukikuw, ata wadiy, “Adi yitaypika wudib, Biyilsipap, dikik ap kwiydik, di nuwukadiy mawulaam rinadiy wudib alik kwurin yaki-dadiy.” ");
INSERT INTO mle_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas dayadiy mawulaam wadadiy maaj lakwukuw, wadidiy, “Li gavman nak kapakap kajikuw, day dayada wariya-kidana, adi gavman vakir-kinaad. Li tip nak ay gwalugw nak kapakap kajikuw, day dayada wariya-kidana, adi tip ay adi gwalugw vakir-kinaad. ");
INSERT INTO mle_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Aw gwur wagwura Satan di dikidiy wudib duw dayadiy mawulaam ridaak, kwurin yakidadiy. Atawa li Satan dikidi gwalugw kapakap kajikuw, day dayada wariya-kidana, Satan dikidi gwalugw vakir-kinaad. ");
INSERT INTO mle_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Gwur wagwura Biyilsipap wunak ap kwiydik, wun adiy mawulaam rinadiy wudib kwurin yaki-tuwadiy. Aw gwura bapa duw dayabab mawulaam rinadiy wudib kwurin yaki-kwanadiy. Aw Biyilsipap dayak ap maa kway a yawiyik. Alik tikuw, sikidadaad ap dayak kwiynaad a yawiy kwurdakik? Day wakwadiy gwura maaj mwiya maaj, ay? Suwala maaja? ");
INSERT INTO mle_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Gwura wagwura maaj mwiya maaj maa. God dikidi Mawul wunak ap kwiydik, wun adiy mawulaam rinadiy wudib kwurin yituwadiy. Atawa tikuw, God dikidi duw takwaam van tikidi nyi gwura nyidim tina. ");
INSERT INTO mle_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Duw nak ap tinadi duw diki wiyaar wulakuw, dikidiy niki jaav niki jaav kwurkwurik, aw di maa rav. Taay, adi ap tinadi duwaam yaav jikuw, dikidiy wiyaam rinadiy jaav ata kwur-kidadiy. ");
INSERT INTO mle_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Adiy duw day wunawa yawiy kwar maarkinadiy, day wunadiy mama duw tidaal pik tikinadiy. Wun duw taakw vagaruwtaka-tuwadiy wunadiy gwalugwa duw taakw tidakikik. Aw wunadiy mama duw yakuw, viyayakidaak, adiy duw taakw kapakap kapakap tabwu-kinadiy. ");
INSERT INTO mle_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Mwiya maaj watuwadiygwurik. Li duw taakw vaal samasam yidaak, wajibayin sapis jikin samasam kwurdaak, God adiy javik yibwiy-kidadiy, adiy duw taakw dayadiy valik bwan kwiykuw, Godak adiy vaal wasapwiykuw. Aw li duw nak God dikidi Mawulak wajibayin sapis jikin kwurdaak, God diki vaal yibwiy maa. ");
INSERT INTO mle_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“Li duw nak kupwarapa maaj wakinaad wun duw taakw dayadi Mwamik, God adiy vaal yibwiy-kidadiy. Aw li duw nak kupwarapa maaj wakinaad God dikidi Mawulak, God adiy vaal yibwiy maa. Samab maa. Nabiy nabiy kip tikina.” ");
INSERT INTO mle_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Li viyakita miy viyakita mwiy rikwanaad. Li kupwarapa miy aad kupwarapa mwiy rikwanaad. Aw gwur dayadiy mwiyaam vikuw, aw gwur bwunak lakwukuw, wakinadiygwurik ki mwiy kidi miy dikil-al. ");
INSERT INTO mle_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Gwur kabaay kitika duw-adiygwurik. Gwur mwiya kupwaraap-adiygwurik. Gwur viyakita maaj bwula-bwul maa rav. Gwuradiy mawul kupwarapa tidanalik, alik kupwarapa maaj bwula-kwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Adiy viyakita duw taakw viyakita mawul tikwanadiy. Alik viyakita yawiy kwurin viyakita maaj bwulakwanadiy. Li adiy kupwarapa duw taakw kupwarapa mawul tikwanadiy. Alik kupwarapa yawiy kwurin kupwarapa maaj bwulakwanadiy. ");
INSERT INTO mle_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Wun gwurak watuwadiygwur ginyir God dikidi nimadi kot im ababa duw taakw day dayadiy ababa kwasa kwasadiy maaj dayadiy maw Godak wasapwiy-kidanadiy. ");
INSERT INTO mle_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","“Gwuradiy ababa majim wukikuw, God wakinaad, ‘Min viyakita duw-adimin’ ay, ‘Min kupwarapa duw-adimin.’” ");
INSERT INTO mle_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nuwukadiy God diki lo kalivadiy duwawa, Parasiy day Jisasak ata wadaad, “Kaliva-kwanadi duw, min God diki mawulaam rinadi yawiy nyanak asimak. Nyan adi yawiy vikuw, lakwu-kibana God minawa tinaad wakuw.” ");
INSERT INTO mle_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Jisas ata wadidiy, “Kita kwanadiy duw taakw mwiya kupwaraap-adiy. Day dayadiy bwan bwutaay Godak kwiydadiy. Wunak bas sigwura jaav gwurak wun simak maa. Aw jaav nak gwurak simaka-kituwa. God diki maaj wasapwiydi duw, Jawnas, tayir kwurdil java pik kwurkituwa. Jawna di mwiya nimadi kamiy yalaam nyawa gaan mugwul kwadidiy. Atampik wun, duw taakw dayadi Mwaam, nyawa gaan mugwul kidi kupw diki yalaam kwa-kituwadiy. ");
INSERT INTO mle_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Ginyir God dikidi nimadi kot im ababa Niniva tipa kidiy duw taakw rapikuw, Godak ki maaj wakidana gwurak: ‘Jawna God diki maaj nyanak wasapwiydik, nyan abab bwan kwiykuw nyanadiy valik, wukijibir tidiyan.’ Atawa adiy duw taakw wakidiy. Aw gwur, God diki lo kalivanadiy duwawa Parasiy, gwur maa wanadiygwur God diki majib wuki-wukik. Aw wun, ki maaj gwurak wasapwiy-nadi duw, Jawnaam yitaypik tinadiwun. ");
INSERT INTO mle_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Ginyir God dikidi nimadi kot im Sipa jaka tipa kil kwin Godak wakina gwurak, ‘Wun mwiya sika tamiyaam kwakuw, yalwun Salaman wadidiy viyakita maaj wukik.’ Aw wun, ki maaj gwurak wasapwiy-nadi duw, Salamanaam yitaypik tinadiwun. Aw gwur God diki maaj wuki-wukik kwasik yinadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","Jisas ki maaj dayak wadidiy, “Li kupwarapa wudib duwaam wapakuw, di yin yaan kipa tamiyaam kwakwa tamiyak vikir. Tamiy vi maarkuw, di ata wakinaad, ‘Wun sibinin yikinadiwun wun tayir kwakuw yatuwil tamiyaar.’ Wakuw, yidik, di vikinaad a tamiy vayukwukuw, maliykamaliy tikuw, kip rilik. Alik adi wudib sibinin yikuw, nuwukadiy kupwarapa wudib abitiy kwurin karaykidadiy a tamiyaar. Adiy nuwukadiy wudib day mwiya yitaypik adi wudibak tinadiy. Tayir kidi duw kupwaraap tad. Aw kita abitiya wudib yadaak, mwiya kupwaraap tiyakiyaki-kinaad. Atawa atampika jaav tikina kita kwanadiy duw takwaam.” ");
INSERT INTO mle_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas duw takwak maaj wataay tidik, diki amaywa dikidiy nyamwusugw yakuw, kawaam tidiy. Day maaj watakadaal dikik di yadikikik dayak. ");
INSERT INTO mle_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aw walibab tidiy duw taakw Jisasak ata wadaad, “Min awuk. Mina amaywa minadiy nyamwusugw kanakw adiyka kawaam tinadiy. Day minak maaj wakir wanadiy.” ");
INSERT INTO mle_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisas adiy duw takwak God dikidi gwalugwuk kalivaak, dayak ata wadidiy, “Sikalalaal wuna amaay? Sikanadiy-adiy wunadiy nyamwusugw?” ");
INSERT INTO mle_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jisas dikidiy kalivadidiy duwak taab simakakuw, ata wadidiy, “Gwur av wunakil amaywa wunadiy nyamwusugwuk. Day kilim tinadiy. ");
INSERT INTO mle_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","“Sikanadiy-adiy wunadi adawul tipaam kwanadi Asaay diki yawiyik wukikuw, kwurkinadiy adiy duw taakw dayadiy wunadiy nyamwusugw, jikwaraagw, amayugw tikinadiy.” Jisas ata wadidiy. ");
INSERT INTO mle_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A nyi, wiy wapakuw, Galiliyaar mala araam tikuw, Jisas adiy duw takwak kaliva-didiy. ");
INSERT INTO mle_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jisasawa duw taakw samasam vagaluwdiy. Alik di kwasa jabiraar warkuw, di a jabiraam guwaam kwaad day diki maaj mwiyir wakwudakik. Day samasama duw taakw adiyka a mala ara kupwaam ridiy. ");
INSERT INTO mle_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dayak samasama jaav kalivadidiy. Waya maaj kitik wadidiy. Di dayak wadidiy, “Gwur awuk ki maaj! Duw nak kabasik kitika jaav, wit, liki kadiy diki mayim yakik yad. ");
INSERT INTO mle_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Kadiy yakidik, nuwuk apiy yabim vakirdiy. Wapiy adiy kadiy vikuw, dakuw, kidadiy. ");
INSERT INTO mle_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","“Nuwukadiy kadiy kabaka ril kwasa kupw, a kupwaam vakirdiy. A kupw bag maa ti. Alik jayib ni saar warkuw, maj mwiyir maa kway. Aw nimadi nyi sidik, rik yikuw, kiyadiy. ");
INSERT INTO mle_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Nuwukadiy kadiy ramiy tidiy visawa vakirdiy. Ramiy til visawa nakamwiyib warkuw, yakiwulupwun ridiy. ");
INSERT INTO mle_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Nuwuk viyakita kupwaam vakirkuw, wardiy. Warkuw, day viyakita mwiy kwurdiy. Adiyka nuwuk mwiy mugwul ridiy, nuwuk mwiy kwasa samasam ridiy, aw nuwuk mwiy mwiya samasam ridiy.” ");
INSERT INTO mle_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jisas ata wadidiy, “Duw waan tinaad di yarakara wukikaad.” ");
INSERT INTO mle_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas ki maaj wakuw wadik, dikidiy kalivadidiy duw dikik yakuw, ata bas sidaad, “Agwa javik kidiy duw takwak waya maaj kitika majir waminadiy?” ");
INSERT INTO mle_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisas dayak wadidiy, “God simaka-didiygwur agwa jaav tayib pakwul atatawa di duw takwak van tikidadiy. Aw dayak maa. ");
INSERT INTO mle_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Duw taakw wuna maaj lakwudana, ginyir miyawa lakwu-kinadiy God dikidiy javik. Aw adiy duw taakw day wuna maaj laakw maardana, ginyir kip tikuw, saal yikidiy. ");
INSERT INTO mle_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Kidiy duw taakw mil vikwanadiy. Aw mwiya akis javim vikwanadiy. Day waan wukikwanadiy. Aw maaj mwiya akis lakwu-kwanadiy. Alik tikuw, wun dayak waya maaj kitika majir watuwadiy. ");
INSERT INTO mle_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Aw God diki maaj wasapwiydi duw, Aysaya, diki God diki lapa nyigaam sukwudil maaj mwiya mwiyaba dayak tina. Di ki God wadil maaj duw takwak wadidiy, ‘Gwur maaj wuki-kigwuraal ab laakw maa. Gwur vidika vikigwuraal ab vi maa.’ ");
INSERT INTO mle_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","“God Aysayak ata wadid adiy duw takwak, ‘Kidiy duw taakw dayadiy mawul bwu pakwudiy. Dayadiy waan bwu takatipi-dadiy. Dayadiy mil bwu tipidadiy. Atawa tikwanadiy, wunak tipatiyakwuk-dana, aw sipwutiyik-tuwadiy.’ God ata wadidiy dayak.” ");
INSERT INTO mle_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Aw God gwurak yarakara kwurnaad. Alik gwur mwiyir mil vikuw, waan ab mwiyir wuki-gwuradiy. ");
INSERT INTO mle_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","“Ki maaj awuk. Tayir God diki maaj wasapwiydiy duwawa dikidiy duw taakw day adiy vigwuradiy wunadiy kwurtuwadiy yawiy vikir kwurdadiy, aw day maa vi. Day wuki-gwuradiy kalivatuwadiy maaj wukik kwurdadiy, aw day maa wak. Day kip kiyadiy.” ");
INSERT INTO mle_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Gwur awuk kidi duw adiy kadiy wit yakidil liki maw maaj. ");
INSERT INTO mle_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Adiy duw taakw day maaj wukikuw God dikidi duw takwak van tikidadi nyak aw day maa laakw, adiy duw taakw day adiy apiy yabim vakirdiy kadiy wit kaytik tinadiy. Aw Satan yakuw, God diki maaj kwurdaal, dayadiy mawulaam kwalik. ");
INSERT INTO mle_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","“Atampik nuwukadiy duw taakw kabaak apiyim ril kupwaam yakididiy kadiy kitik tinadiy. Day God diki maaj wukikuw, kwurik rakarak tinadiy. Maaj mwiyir maa mawulaar yi. Alik simiy maa ti. Dayaam samasam kupwarapa jaav viyadaak, nuwukadiy duw taakw dayak wasupwudaak God diki majik, day ata bwan kwiy-kwanadiy God diki majik. ");
INSERT INTO mle_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Nuwukadiy duw taakw ramiy tina visawa vakirdiy kadiy kitik tinadiy. Day God diki maaj wukikuw, aw dayadiy mawulaam rinadiy majik samasam wukikuw, sanawa niki jaav niki jaav kwurik, kwanadiy. Adiy jaav yakuw, God diki majim yakiwulupwu-danadiy. Alik day mwiy maa ri. ");
INSERT INTO mle_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Nuwukadiy duw taakw adiy viyakita kupwaam vakirdiy kadiy wit kitik tinadiy. Day God diki maaj wukikuw, kwurkuw, day mwiy rinadiy. Nuwukadiy mwiy mugwul rinadiy. Nuwuk mwiy kwasa samasam rinadiy. Nuwuk mwiy mwiya samasam rinadiy. Atawa duw taakw God diki maaj kwur-kwanadiy.” ");
INSERT INTO mle_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas niki waya maaj kitika maaj dayak wadidiy. “Kitawa God duw takwak van tinaad. Di adi viyakita kadiy wit mayim yakidi duw kaytik-ad. ");
INSERT INTO mle_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","“Nyidi gaan tilik, ababa duw taakw si kwayik yakidaak, dikidi mama nib yakuw, adiy diki mayim yakididiy kadiy wit awa nuwukadiy kupwarapa kadiy wit kaytika pika jaav a mayim yakididiy. Kupwarapa wit yakin napakuw, adi mama nib a maay wapakuw, ata yad. ");
INSERT INTO mle_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Adiy kadiy ata abab mayim wardiy. Aw ginyir day yikuw, vidadiy nuwukadiy kupwarapa wit kaytika pika jaav nakamwiyib adiy viyakita wit awa wardiy. ");
INSERT INTO mle_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“A maay asaay duw dikidiy yawiy duw atawa vikuw, dikik yakuw, ata wadaad, ‘Sapakwa duw, min viyakita kadiy wit mina mayim yakiminidiy. Aw ata ata yikuw, kidiyay kupwarapa wit kaytika pika jaav nakamwiyib warnadiy?’ ");
INSERT INTO mle_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ata wadidiy, ‘Wunadi mama duw yakuw, adiy kupwarapa jaav yakididiy.’ Day ata dikik bas sidaad, ‘Aw min wukimina nyan yin adiy kupwarapa kadiy wit kaytika pika jaav gwakuw, yakinaak?’ ");
INSERT INTO mle_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","“Di dayak ata wadidiy, ‘Aw si wana? Atawa kwurkigwura, viyakita wit awa nakamwiyib kaygwa-kigwuradiy. Adiy viyakitawa kupwarapa wit kaytika pika jaav nakamwiyib warkwadiy. Ginyir dayadiy mwiy rik yidaak, wun ata wunadiy wit kwurlapwuka-kwanadiy duwak wakituwadiy: Gwur taay wadiy kupwarapa wit kaytika pika jaav gwakuw, kagwu mayim jitakakuw, yiyaar ayakisawul yiy yandikik. Ginyir adiy viyakita wit kwurjuwtakakuw, wunaki kamnaagw takakwatuwa wiyaam kariyaan atak.’” ");
INSERT INTO mle_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Jisas niki waya maaj kitika maaj wadidiy, “God duw takwak van tinaad sika mastat kitik. Ababa nuwukadiy kadiy nimadiyadiy, aw sika mastat mwiya kwasaala. Duw sika mastat kwurkuw, diki mayim sididiy. Ginyir kwasa mwiy simiy warkuw, mayim rinadiy javim kakilkinaad. Miy tidik, wapiy day dikidi ba miyaam kwaat taka-kwadanaad. Atampik God dikidi gwalugw taay kwasa tidik, aw ginyir mwiya nimaad tikinaad.” ");
INSERT INTO mle_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas niki waya maaj kitika maaj wadidiy, “God duw takwak van tinaad yis kitik. Taakw bret sukwulik yikir tikuw, li ata kwasa yis kwurkuw, plaua wa nakamwiyib kwurjuwtakakuw, kaybaybalakin kwurtaykib, ginyir a plaua wa yis wulkuw, mwiya nima tikina.” ");
INSERT INTO mle_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas vagaluwdiy duw takwak ababa jaav wadidiy waya maaj kitika majir. A waya maaj kitika majida dayak wadidiy. ");
INSERT INTO mle_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tayir God diki maaj wasapwiydi duw ki maaj wadil, “Wun dayak waya maaj kitika majir wakituwadiy. Adiy jaav day pakwun tinadiy God ki kupw yitakadidi nyi aw yaan kita wasapwiy-kituwadiy.” Jisas atawa dayak wadik, ki maaj ata mwiya mwiyaba maaj tal. ");
INSERT INTO mle_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas adiy vagaluwdiy duw taakw wapakuw, yala wiyaar wuladik, dikidiy kalivadidiy duw dikik yakuw, wadaad, “Nyan adiy kupwarapa wit kitika jaav wamina waya maaj kitika maaj liki maw wukik.” ");
INSERT INTO mle_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas dayak ata wadidiy, “Adi viyakita kadiy wit mayim yakididi duw aad wun-adiwun, duw taakw dayadi Mwaam. ");
INSERT INTO mle_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","“Adi maay kidi kupwad. Adiy viyakita kadiy wit day God dikidiy duw taakw-adiy. Adiy kupwarapa wit kitika jaav day Satan dikidiy duw taakw-adiy. Adi kupwarapa wit kitika jaav mayim yakidi duw, aad Satan-ad. Adiy wit kitiki-nadiy duw day God dikidiy maaj kardadiy duw-adiy. Kitiki-kidana nyi, aal kidi kupw kwusikidi nyal. ");
INSERT INTO mle_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","“Day adiy kupwarapa wit kitika jaav kwurjuw takakuw, yaar yakisawula-kidanadiy. Atawa kidi kupw kwusidik, wun wayakituwik, wunadiy maaj kardadiy duw kidi kupwaar dakidiy. Dakuw, kwur-kidanadiy adiy ababa vaal yikwanadiy duw takwawa adiy ababa jaav day mwugiy-danadiy duw taakw vaal yidakikik. Dayaam kwurkuw, yiyaar yakisawula-kidanadiy. ");
INSERT INTO mle_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","“God dikidiy duw taakw ki kupw wapakuw, God dikidi van tikidadi tipaar warkuw, day nyi baw tubwaar tikuw, wapakuw, mwiyir sikanaad, atampik tikinadiy. Gwur wuna maaj wukikuw, a majik awuk!” ");
INSERT INTO mle_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisas dayak ata wadidiy, “Duw nak nikidi duw diki kupwaam yitaay tikuw, jaav nak tayir pakwun tal vidil. A jaav mwiya samasama saan yapiy-kwadanaal. Vikuw, di kupw ata rimsuwdil. Rimsuwkuw, diki mawul rakarak samasam tikuw, diki wiyaar ata yad. Yikuw, dikidiy ababa jaav kwurkuw, nuwukadiy duw takwak kwiydikib, yapiydadiy. Yapiydadiy saan kwurkuw, ata yad adi kupwa duw diki kupw yapiyik. Atawa viyakita jaav God duw takwak van tinaad.” ");
INSERT INTO mle_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","“Duw nak yin yaan tinaad viyakita gilabadiy yapiyik. Mwiya viyakita gilabadiy sitakirakuw, di dikidiy ababa jaav kwurkuw, nuwukadiy duw takwak kwiydakib, yapiydadiy. Yapiydadiy saan kwurkuw, di a viyakita gilabadiy ata yapiydil. Atawa God dikidiy duw takwaam van tididiy.” ");
INSERT INTO mle_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","“Nagir kitik God duw takwaam van tinaad. Duw nagir kwurkuw, yala araam yakisakikuw, niki kamiy niki kamiy ata kwurdadiy. Nagir guwaam tidik, kawarkuw ata lagwun mala kupwaar kawardaad. Kawarkuw, daan rikuw, adiy kamiy ata kajidadiy. Adiy viyakita kamiy vakaar yakisawula-dadiy. Aw adiy kupwarapa kamiy kip yakiyaki-dadiy. ");
INSERT INTO mle_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Atampik kidi kupw kwusidik, God dikidiy maaj kardadiy duw wakwukuw, adiy kupwarapa duw taakw, day viyakita duw takwawa kwakwanadiy kwurkuw, yaar yakisawula-kidanadiy. Alim day girataay, wuk vatikirikiy-kinadiy.” ");
INSERT INTO mle_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas dikidiy kalivadidiy duwak ata bas sididiy, “Gwur kidiy watuwadiy maaj lakwu-gwuradiy?” “Ayiy,” ata wadiy. “Bwu lakwu-banadiy.” ");
INSERT INTO mle_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jisas ata wadidiy, “Adiy God diki lo kalivanadiy duw day wunadiy kaliva-tuwadiy duw tidaak, viyakita jaav kwurdadiy. Nuwukadiy taay pika viyakita jaav kwurnadiy. Nuwukadiy kwula pika jaav ab kwurnadiy. Ginyir adiy jaav lakwukuw, duw nuwukadiy duw takwak wasapwiy-danadiy.” ");
INSERT INTO mle_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas adiy waya maaj kitika maaj wakwusin napakuw, a tip ata wapadil. ");
INSERT INTO mle_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Wapakuw, di diki tipaar sibinin yad. Yikuw, daya gaba maja wiyaar wulakuw, adiy duw takwak kalivadidiy. Aw day diki maaj wukikuw, pitaan wardiy. Day ata bas sidiy, “Ata ata di kidiy jaav lakwu-didiy? Ata ata di God diki mawulaam rina yawiy kwurnaad? Aw di ki tipaba duw-ad. ");
INSERT INTO mle_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","“Di miya yawiy kwurkwanadi duw dikidi nyan-ad? Di Maria likidi nyan-ad? Jamis Jawsip Saymanwa Juwtas dikidiy nyamwusugw maa? Dikidiy jikwaraagw day abab kilim kwanadiy, ay maa? Akim di kidiy maaj kwurdidiy?” ");
INSERT INTO mle_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Day laakw maardalik diki ap liki maaw, alik day maa wadiy dikik. Jisas ata wadidiy, “Ababa tipa kidiy duw taakw God diki wasapwiydi duwak rakarak tinadiy. Aw diki tipa kidiywa diki gwalugw ki duw taakw atawa maa kwar.” ");
INSERT INTO mle_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A tipa kidiy duw taakw day dikik wukijibir ti maardalik, alik di samasama nimadiy yawiy alim maa kwar. ");
INSERT INTO mle_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ababa duw taakw wabagwudiy Jisas dikidiy kwurdidiy yawiyik. Alik Juw dayadi yitaypika duw, Yirat, adiy yawiy wukididiy. ");
INSERT INTO mle_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wukikuw, di dikidiy bapa duwak ata wadidiy, “Jon Baptais kwiydi duw tayir diki abw wun viyalupwa-tuwik, kiyaad. Aw kita bwutaay rasinaad kawamiyaam kwakuw. Alik ki nima ap dim rina.” ");
INSERT INTO mle_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Tayir Yirat kiradil Yirawtiyas, dikidi nyamwus Pilip diki taakw. Jon Baptais kwiydi duw Yiratak wadikalib, “God maa wanaad min minadi nyamwus diki taakw kiraminil.” Yirawtiyas pitaan warkuw Jonak, li dim viyasipak. Alik Yirawtiyas kwurik, Yirat duw wayakididiy Jon kwurin yaav jikuw mala wiyaam takadakik. Yirat Jonaam viyasipak waad. Aw adiy Juw tipa kidiy duw taakw day wadiy, “Jon di God diki maaj wasapwiydi duwad.” Alik Yirat di Jonaam viyasipa viyasipak yagaad. ");
INSERT INTO mle_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Yirat diki maaj kwadil nyi tilik, di kikipaat jabim takanadiy sapakwa nyanugw kidakikik. Yirawtiyas liki takwa nyan yaan baagw dayak tilik, Yirat rakarak samasam tad likik. Alik di basa kasab wadil, “Mwiya maaj watuwanyin. Agwa jaav nyina mawul kwurik walik, wun kwatiyaribaak tinadiwun.” ");
INSERT INTO mle_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aal nibwu taakw wakwukuw, liki amayik bas silil, “Agwa javik bas sikituwa?” Tayir Jon Yiratak kipwu mwutaam yikuw, mwiya maa waad di Yirawtiyas kira-kirak. Yirawtiyas a jaav wukil, alik liki takwa nyinik ata walil, “Baptais kwiydi duw diki abw.” Jayib ni a nibwu taakw sibinin yikuw Yiratak, dikik ata walid, “Baptais kwiydi duw, Jon, diki abw kita viyalupwakuw, marim takakuw, wunak akwutay.” ");
INSERT INTO mle_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yirat ata samasam wukid diki abanik. Di bwu takadil vagaluwdiy duw makab. Maaj lakatiykuw, alik ginyir maa rav warapiyik. Atawa tikuw, di yaakiya waad dikik walil majik. ");
INSERT INTO mle_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yirat vay sawdiy duwak ata wadidiy, “Jon Baptais kwiydi duw diki abw aviyalupw.” ");
INSERT INTO mle_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Viyalupwakuw, Jon diki abw marim takakuw, nibwu takwak kwiydil. Li ata kwurkuw, karayin liki amayik kwiylil. ");
INSERT INTO mle_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jon dikidiy kalivadidiy duw a jaav wukikuw, day yakuw, Jon diki amwiy kwurdaal. Kwurkuw, kawamiyaam takadaal. Takakuw, day ata Jisasak yidiy dikik ababa jaav wakir. ");
INSERT INTO mle_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas daya maaj wukikuw, a tip ata wapakuw, di kap yad kipa tamiyaar jabirasaay. Jisas a tip wapadil maaj wukikuw, samasama duw taakw diki kwukir manir nibwusaay yidiy dikik. ");
INSERT INTO mle_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas jabir wapakuw, adiy samasama vagaluwdiy duw takwaam vikuw, di samasam wukid dayak. Wukikuw, di dayadiy giviyib kwurdiy duw takwawa nyanugw sipwutiy-didiy. ");
INSERT INTO mle_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Giraab tilik, dikidiy kalivadidiy duw dikik yakuw, wadaad, “Kal kipa tamiya. Giraab bwu tina. Kidiy duw taakw tipaar awayak. Yin kikipaat mawiy yapiy-kwadiy day daya.” ");
INSERT INTO mle_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisas dayak ata wadidiy, “Wun dayaam tipaam wayak maa. Gwur gwura dayak kikipaat akwiy.” ");
INSERT INTO mle_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Day Jisasak ata wadaad, “Nyan kilim kikipaat samasam maa ri. Bret tabab, kamiy vitiyada rinadiy.” ");
INSERT INTO mle_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisas dayak ata wadidiy, “Adiy kikipaat wunak akaray.” ");
INSERT INTO mle_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Di adiy vagaluwdiy duw takwak ata wadidiy, “Gwur visim daan ada.” Wadik, day visim daan ridaak, Jisas adiy bret tababawa vitiya kamiy kwurkuw, adawul tipaar likituwkuw, Godak wayapiy sidid. Wayapiy sikuw, adiy bret kaysukwa-sukwakuw, kwiydidiy dikidiy kalivadidiy duwak adiy vagaluwdiy duw takwak kwiydakik. ");
INSERT INTO mle_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ababa duw taakw kikipaat kikuw, yaal wapwudiy. Jisas dikidiy kalivadidiy duw kayvisi-dadiy kipaat vagakuw, baniy tabatiy maan vitiy vagadaak, kapwudiy. ");
INSERT INTO mle_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","5000 duw adiy bret awa kamiy kidiy. Day takwawa nyanugw maa naas. ");
INSERT INTO mle_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Gwur jabiraar awar. Warkuw, gwur taay maay apika maka araar.” Wakuw, di ata vagaluwdiy duw taakw wayakididiy. ");
INSERT INTO mle_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","24","Wayakidik, yidaak, di nibwukir ata warid. Warkuw, Godawa maaj bwulaad. Gaan valik, Jisas kap kwaad kupwaam. Gaan valik, adi jabir nyidi araam tidik, mwar nimadib yin jabiraam saylik adi jabir payparapwud. ");
INSERT INTO mle_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Taay tapwuk wadidi gaan Jisas apiy ararib dayak yad. ");
INSERT INTO mle_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aw Jisas dikidiy kalivadidiy duw dim apiy guwarib yadik vikuw, samasam yagakuw, ata wadiy, “Kad apawul-ad?” Yagakuw, nimadib gaam sidiy. ");
INSERT INTO mle_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisas yabiyib dayak ata wadidiy, “Gwuradiy mawul yaga-tikwa. Wun Jisas-adiwun. Yaga-tikwa.” ");
INSERT INTO mle_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita Jisasak ata wadid, “Li min mwiya Jisas-adimin wakuw, wunak wamin, wunabab wakwun guwarib vasin yaaw minak.” ");
INSERT INTO mle_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisas Pitak ata wadid, “May.” Wadik, Pita ata jabiraam tikuw, guwaar sarin daad. Dakuw, apiy guwarib Jisasak ata yad. ");
INSERT INTO mle_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aw Pita di nima mwurawa mam yalik, di vikuw, yagaad mawulaar. Di ata kwasa kwasa guwaar daad. Aw di Jisasak gaam sidid, “Yitaypika Duw, wunak sugwiyaan akwur!” ");
INSERT INTO mle_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisas yabiyib dikidi taab kwusakakuw, Pita kaykitidid. ");
INSERT INTO mle_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bir ata jabiraar sarin warbir, mwar ata kwusir. ");
INSERT INTO mle_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jisas dikidiy kalivadidiy duw jabiraam kwakuw, gaba maaj sukwudiy Jisasak, “Min mwiya God dikidi Nyan-adimin!” wakuw. ");
INSERT INTO mle_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Day araar suwurkuw, Ginisaritaar yadiy. Alim day kawiydiy. ");
INSERT INTO mle_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","36","Alim duw taakw day Jisasaam vikuw, day “Kad Jisas-ad” wataay wadiy. Aw day maaj wayakidaal walibab ridiy tipaar aw ababa duw taakw day dayadiy giviyib kwurdiy duw taakw Jisasak kwurin kariya-dakik. Day ata jabir jabir bas sidaad diki wapwiyim kaykiti-dakik. Kaykitikuw, day ata viyakit tidiy. ");
INSERT INTO mle_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nuwukadiy Parasiyawa God diki lo kalivadiy duw day Jiruwsalim wapakuw, Jisasak yakuw, day dikik ata bas sidaad, ");
INSERT INTO mle_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Agwa javik minadiy kaliva-minadiy duw nyanadiy gwalugw dayadiy kalivadadiy lo wab wukimar-nadiy? Day taab jan maarkuw, kikipaat kinadiy.” ");
INSERT INTO mle_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas dayak ata wadidiy, “Gwur God dikidiy lo wapakuw, gwur gwuradiy lo-adika kwur-kwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“God ki lo gwurak kwiydil: Gwuradiy amaay asayik awuk. Niki majiwa: Sikadadaad amaay asayik sapis jikinaad, gwur adi duwaam aviyasip. ");
INSERT INTO mle_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Aw gwur kitawa kaliva-kwanadiygwur: ‘Li duw nak dikibir amaay asayik wakidabir. “Wun birak sugwiyaan kwar maa rav, wunadiy niki jaav God dikidiy tidakikik tasakwun tidanalik tikuw,” aal jaaw yaakiya atawa kwurkwaad.’ Duw atawa wakuw, gwur wakwanadiygwur di dikibir amaay asayik wukisir-kwaad. ");
INSERT INTO mle_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Atawa gwur wakwanadiygwur. Gwur God dikidiy lo wak maa wakuw, gwur gwuradiy lo wa danik kwur-kwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Viyuw tikala pik vitiy pasira-nadiygwur! God dikidi wasapwiydi duw, Aysaya, ki maaj wadik, mwiya maaj wadil gwurak. Di waad, ");
INSERT INTO mle_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘God wanaad kidiy duw taakw wunak sukwasukw wunak kwurin rakarak kipa majidanil tikinadiy. Aw dayadiy mawul wunak mwiyir maa yi. ");
INSERT INTO mle_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kipa gaba maaj sukwanadiy wunak. Agwak, day dayadiy lo kalivadaak, wanadiy, ‘Kidiy God dikidiy lo-adiy,’ wakuw.” ");
INSERT INTO mle_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas alik ababa duw takwak gaam sididiy day yadakikik dikik. Yadaak, dayak ata wadidiy, “Gwur abab wunadiy maaj wukikuw, adiy majib awuk. ");
INSERT INTO mle_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kawaam rinadiy jaav duw kikida, di kupwaraap ti maa. Duw daya mawulaam kwanadiy jaav wakwukuw, mwugiydaak, adiy duw kupwaraap tikinadiy.” ");
INSERT INTO mle_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jisas dikidiy kalivadidiy duw dikik yakuw, wadaad, “Adiy Parasiy day pitaan warnadiy mina wamina majik.” ");
INSERT INTO mle_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisas dayak ata wadidiy, “Wunadi adawul tipaam kwanadi Asaay di nimadi maay nak tinaad. Adi mayim kipa duw sikidadiy miy adiy miy gwakuw, God yakiyaki-kidadiy. ");
INSERT INTO mle_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Adiy Parasiyak wuki-tikwa. Day adiy mil kwakinadiy duw kaytik tikuw, day awarwa awarwa nikidi nikidi duw tabaam kaykitikuw, yikuw, nakamwiyib kawaar vakir-kwadiy.” ");
INSERT INTO mle_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita Jisasak ata bas sidid, “Jisas, nyanak aw mina wamina waya maaj kitika maaj liki maw.” ");
INSERT INTO mle_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","18","Jisas dayak ata wadidiy, “Gwurabab, gwur maa laakw? Adiy duw dayir kikwadanadiy kamnaagw yalaar dataay, ginyir wusawa diy tikwanadiy. Adiy maaj taay duw dayadiy mawulaam ritaay, ginyir duw dayir ata wakwunadiy. A jaav mwugiylik, duw kupwaraap tikinaad. ");
INSERT INTO mle_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","“Kidiy kupwarapa jaav duw dayadiy mawulaam ritaay, wakwukwanadiy. Duw viyaan, taakw niki taakw likidi duwaam vaal yaan, duw nikidi duw diki takwaam vaal yaan, yabim kwurbagwun, luwkuw kwurin, suwal kwurin, sapis jikin. ");
INSERT INTO mle_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","“Kidiy kupwarapa jaav mwugiydaak, duw kupwaraap tikinadiy. Aw adiy Parasiy wakwanadiy, gwur tik tinadiy tabaar kikuw, kupwaraap tikinadiygwur. Aw wun maa wanadiwun daya majik.” ");
INSERT INTO mle_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas dikidiy kalivadidiy duw kwurkuw, a tip wapakuw, Taya-awa Saytan, abir tipawa walibab ril tamiyaar ata yad. ");
INSERT INTO mle_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kana tamiy kil taakw, li Juw taakw maa, alim kwaal. Li Jisasak yakuw, nimadib dikik bas silid, “Yitaypika Duw, Davit dikidi gwalugwa duw, wunak awuk! Wudib wunaki takwa nyinim liki mawulaam ridik, jawjaay kwurda likim.” ");
INSERT INTO mle_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aw Jisas likik maaj maa wu. Dikidiy kalivadidiy duw dikik yakuw, bas sidaad, “Ki taakw nyana kwukib titaay, nima kwudiyir li gaam sina. Alik wayakimin, yikwa.” ");
INSERT INTO mle_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aw di dayak ata wadidiy, “Yisrayil jaka tipa kidiy duw taakw adiy jaaw yinadiy sipsip kitik tinadiy. Dayak sugwiyaan kwurik yinadiwun. Aw nuwukadiy jaka tipa kidiy duw takwak maa.” ");
INSERT INTO mle_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wakuw wadik, a taakw dikik yakuw, diki manwa vakirkuw, ata walid, “Wunak ab sugwiyaan akwur!” ");
INSERT INTO mle_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Juw nuwukadiy jaka tipa kidiy duw taakw sikiydadiy as-adiy. Alik Jisas ata wadil, “Nyanugw kikipaat nyan asak kwiykwiy maa.” ");
INSERT INTO mle_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Li ata walid, “Yitaypika duw, bwun jabim kwanadiy as dayadiy asaay daya kavisa kikipaat vakirkuw, kikwanadiy.” ");
INSERT INTO mle_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aw Jisas likik ata wadil, “Nyin nyina mawul samasama wukijibir wunak tina. A jaav nyin wun kwurtuwkik wanyina, wun kwurkituwa wanyina pik.” Atawa wadil nyi a taakw liki nyan liki mawulaam ridi wudib ata wapadil. ");
INSERT INTO mle_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas a tip wapakuw, mala Galiliy araar yad. Yikuw, nibwukir warkuw, alib daan rad. ");
INSERT INTO mle_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Duw taakw samasam dikik yadiy. Day niki giviyib niki giviyib kwurdiy duw taakw dayawa nakamwiyib kwurin kariyadadiy. Nuwukadiy maan kupwaraap-adiy, nuwukadiy mil kwakidiy, nuwukadiy ap bwan kiyadiy, nuwukadiy day maaj bwul maardiy. Kariyakuw, Jisas diki manwa takadaak, sipwutiy-didiy. ");
INSERT INTO mle_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ababa duw taakw day vikuw adiy maaj bwul maardiy duw taakw, day daya maaj bwuladiy. Adiy ap bwan kiyadiy duw taakw day yara tidiy. Adiy maan kupwaraap tidiy duw taakw day tiytiyaan tidiy. Adiy mil kwakidiy duw taakw day mwiyir vidadiy. Adiy jaav vikuw, day pitaan wardiy. Pitaan warkuw, day ata wadiy, “Yisrayil duw taakw dayadi God di mwiya viyakitad!” wakuw wadiy. ");
INSERT INTO mle_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A nyi samasama duw taakw vagaluwdiy. Dayaam kipaat maa ri. Alik Jisas dikidiy kalivadidiy duwak wataydik, yadiy. Yadaak, di ata wadidiy, “Wun kidiy duw takwak wukinadiwun. Day wunawa nyi mugwul kwadiy, aw day kikipaat maa. Li wun kamik tidaak wayaki-kituwa dayadiy tipaar, nuwuk yabim kamik kiyasikiy-kinadiy.” ");
INSERT INTO mle_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dikidiy kalivadidiy duw ata bas sidaad, “Ata ata kikipaat kwiykibanadiy? Kal kipa tamiya. Bret kilim maa ri.” ");
INSERT INTO mle_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Di ata bas sididiy, “Gwuraam bret kas rinadiy?” Day ata wadiy, “Bret abitiy, nuwukadiy kwasadiy kamiywa.” ");
INSERT INTO mle_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jisas duw takwak wadidiy, “Kupwaam daan ada!” Wadik, day ata daan ridiy. ");
INSERT INTO mle_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ridaak, Jisas adiy bret abitiy kamiywa kwurkuw, Godak wayapiy sikuw, kaysukwa-sukwakuw, ata dikidiy kalivadidiy duwak kwiydidiy. Day ata kwiydadiy adiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Day kikuw, yaal ruwdaak, adiy kavisa kipaat baniy abitiyim vagadaak, wapwurukwudiy. ");
INSERT INTO mle_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A nyi duw 4000 kikipaat kidiy. Takwawa nyanugw dayaam maa naas. ");
INSERT INTO mle_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisas adiy duw taakw ata wayakidik, yidiy. Yidaak, Jisas jabiraar salin dakuw, Makatan tamiyaar jabirasaay ata yad. ");
INSERT INTO mle_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nuwukadiy Parasiyawa Satuwsiy yakuw, Jisasawa maaj warjuwdiy. Day Jisasaam vasibariyik kwurdiy. Alik day dikik bas sidaad, “Min nyanak nimadi yawiy asimak aw mwiyir nyan lakwu-kinadiyan God yaakiya wanaad minak wakuw.” ");
INSERT INTO mle_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aw Jisas dayak ata wadidiy, “Nyi dakwada, nyikiy nyikiy tubw vikuw, wakwanadiygwurik, ‘Sir viyakita nyi tikina.’ ");
INSERT INTO mle_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","“Ganib, nyikiy nyikiy tubw vikuw, gwur wakwanadiygwurik, ‘Mwurwa waal yakinaad.’ Atawa gwur kidawur tubwaar kituw vikuw, bwunak lakwukuw, wakinadiygwur, ‘Ki nyi waal jakina. Ki nyi waal ji maa.’ Aw agwa javik gwur wunadiy yawiyik vikuw, dayadiy maw gwur maa laakw? ");
INSERT INTO mle_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Kita kwanadiy duw taakw day kupwaraap-adiy. Day maa laakw God dikidi yawiyik. Gwur wanadiygwurik wun God diki mawulaam rina yawiy kwurtuwkik gwurak. Aw atawa maa. Nima yawiy nak vikigwura. Tayir God diki nima yawiy Jawnak kwurdil pik vikigwura. Jawna di kiyadil pikada nimadi kamiy yalaam nyi mugwul gaan mugwul rikuw ata wakwud. Atampik kidi kupw yalaam nyi mugwul gaan mugwul kwakituwadiy.” Atawa dayak ki maaj wakuw, Jisas ata wapadidiy. ");
INSERT INTO mle_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas dikidiy kalivadidiy duw agika mala araam kawiykuw, day wukimar-dadiy bret ak. ");
INSERT INTO mle_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas dayak ata wadidiy, “Gwur wukir yarakara ada adiy Parasiyawa Satuwsiy daya yis ak.” ");
INSERT INTO mle_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dayaam bret maa ri. Alik day mawulaar wukidiy Jisas bret ak wanaad wakuw, day daya bwulabagwudiy diki majik. Day wadiy, “Nyanaam bret maa ri. Alik atawa wanaad.” ");
INSERT INTO mle_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","9","Jisas daya maaj wukidil. Alik di dayak bas sad, “Agwak, ‘Nyanaam bret maa ri,’ gwur gwura wataay bwulabagwu-nadiygwur? Gwur wunak wukijibir maa ti? Gwur maa laakw wun ap tinadiwun kamnaagw mwugiy-tuwik suwulik-nadiy. Kabaak gwura maka apaam rinadiy? Wukimar-gwura tayir wun bret tabab 5000 duwak kaysukwun kwiytuwdiy? Baniy kas kavisa bret vagaluwkuw, vagagwurdiy? ");
INSERT INTO mle_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Wun bret abitiy 4000 duwak kaysukwun kwiytuwdiy. Baniy kas kavisa bret vagaluwkuw, vagagwurdiy? ");
INSERT INTO mle_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“Wun gwurak bret ak maa wu. Agwa javik gwur laakw maarnadiygwurik wunadiy yawiy dayadiy mawuk? Gwur wukir yarakara ada adiy Parasiyawa Satuwsiy daya yis ak!” ");
INSERT INTO mle_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jisas atawa wadik, day ata lakwukuw, ata wadiy, “Di nyanak bret aam takadadiy yis ak maa wu. Di nyanak wanaad, ‘Gwur wukir yarakara ada adiy Parasiyawa Satuwsiy dayadiy kalivadanadiy majik.’” ");
INSERT INTO mle_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas Sisariya Pilipay tamiyaar yikuw, di dikidiy kalivadidiy duwak bas sididiy, “Duw taakw nikim nikim wataay, agwa sad wunak sikiy kwadanaad?” ");
INSERT INTO mle_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Day dikik ata wadaad, “Nuwuk wadiy min Jon Baptais kwiydi duw-adimin. Nuwuk wadiy min abir tayir kwabir God diki maaj wasapwiybir duw Yilayjawa Jirimaya nak-adimin. Nuwuk wadiy min nuwukadiy wasapwiydiy duw nak-adimin.” ");
INSERT INTO mle_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Di dayak ata bas sididiy, “Gwur gwura agwa sad wunak sikiy-kwagwurad?” ");
INSERT INTO mle_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sayman Pita dikik ata wadid, “Min Krais-adimin. God dikidi Tasakwudidi Duw-adimin. Min nyanyi kwakwanadi God dikidi Nyan-adimin.” ");
INSERT INTO mle_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisas Pitaak ata wadid, “Sayman, Jawna dikidi nyan, God sukwasukw kwurnaad minak. Duw minak ki jaav maa simak. Aw God di diki simaka-dadimin wuna mwiya maaw. ");
INSERT INTO mle_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Min Pita-dimin, minadi si maw maaj kabaak-ad. Aw wunadiy gwalugwa duw taakw adi apiy kabakim vagaruwtaka-kituwadiy. Ababa kupwa kidiy jaav dayadiy ap wunadi gwalugwum kakil-kakil rav maa. Aw wunadi gwalugw samab kwas maa kidi kupwaam. ");
INSERT INTO mle_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wun wuna ap minak kwatiya-kituwa. Min kwurkuw, kidi kupwaam watipi-kimina jaav wunabab watipi-kituwa. Kidi kupwaam yaakiya wakimina jaav wunabab yaakiya wakituwa.” ");
INSERT INTO mle_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Di dayak nimadib wadidiy, “Gwur nuwukadiy duw takwak watikwa wun God dikidi Tasakwudidi Duw-adiwun wakuw.” ");
INSERT INTO mle_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A nyi Jisas dikidiy kalivadidiy duwak ki jaav bas ata wadidiy, “Wun Jiruwsalimaar yikuw, wuna sip kagil samasam yikina. Sapakwa nyanugw, sapakwa nyanugw pris, God dikidiy lo kalivanadiy duw, abab bwan kwiykidiy wunak. Viyadaak, kiyakidiwun. Kiyakuw, nyi mugwul yidaak, God wunaam ata kirapitaka-kidadiwun.” ");
INSERT INTO mle_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita Jisas malaar kawarkuw, ata nimadib maa waad diki majik. Di ata wadid, “Yitaypika Duw, atawa ti maa! Day a jaav minaam kwur-dabaal!” ");
INSERT INTO mle_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas tipatiyakwukuw, Pitaak ata nimadib wadid, “Satan, wunaam awap! Min wuna yawiyik watipik kwur-minaala? Min duw mawula pik tinadimin. God mawula pik maa ti.” ");
INSERT INTO mle_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","25","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Duw taakw wuna kwukib yakir, aw yakidiy dayak sapis jikin, samasam kagil daya sipaar yikina, nuwukadiy kupwarapa jaav ab. Adiy jaav kwurkuw, wunak wukijibir tikuw, wuna danik wakuw, kiyakinadiy, day yara kwakinadiy nyanyi nyanyi. Aw li adiy duw taakw day wunak wukijibir ti maarkuw, day daya danik wukikuw, kiyakinadiy, adiy kupwaraap tikinadiy nyanyi nyanyi. ");
INSERT INTO mle_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Li duw nak kupwaam rinadiy ababa jaav kwurkinaad, di kiyadik, adiy jaav ata ata sugwiyaan kwurkidiy dikik? Agwa jaav yapiykuw, kwiykida di kiya marimarik? Di maa rav. ");
INSERT INTO mle_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Ginyir kwasa mwiy rikuw, duw taakw dayadi Mwaam God diki maaj kardadiy duwawa yakinadiwun wunadi Asaay dikidi nimadi kariyaan tikinaad apawa. Yakuw, wun ababa duw taakw dayadiy kidi kupwaam tan kwurdadiy yawiy vikuw, adiy kwurdadiy yawiyib yawiyib atampik kwiykituwadiy. Nuwukadiy viyakit tikidiy. Nuwukadiy kupwaraap tikidiy. ");
INSERT INTO mle_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Ki maaj awuk. Nuwukadiy kilim kwanadiy duw taakw day kiya maarkuw, kip kwaan, vikidana wunadiy duw takwak van tituwadi apak!” ");
INSERT INTO mle_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nyi abwun yidaak, Jisas, Pita Jamisawa dikidi nyamwus Jon, dayadika kwurin kawardidiy. Aluwur pik tidi nibwukir wardiy. ");
INSERT INTO mle_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Day dim vidaal, diki sip ata patiyakwul. Diki mwutaam nyi kaytik kariyaal. Dikidiy kwusuw-didiy wapwiy mwiya wamakawam kariyadiy. ");
INSERT INTO mle_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mawsisawa Yilayja maykaar wakwubir. Bir God diki maaj wasapwiybir duw-abir, tayir bwu kiyakuw adawul tipaam kwabir. Pita Jamisawa Jon ata day vidabir Jisasawa maaj bwulabirik. ");
INSERT INTO mle_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Vikuw, Pita Jisasak ata wadid, “Yitaypika Duw, aal viyakita nyan kilim kwabana. Maja wiy kwurnaak, nak minak, nak Mawsisak, nak Yilayjaak.” ");
INSERT INTO mle_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita wataay tidik, baw tubw wakwukuw, apiyim dayaam God diki majadika tubwaam wukidaad, “Kad wunadi wuna Mawul yilidi Nyan-ad. Wun rakarak tinadiwun dikik. Diki maaj awuk!” ");
INSERT INTO mle_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jisas dikidiy kalivadidiy duw a maaj wukikuw, day samasam yagaan pitaan warkuw, kupwaam vakirkuw, dayadiy mwutaam kupwaar kwakitadakuw, mil kwusikuw, kwadiy. ");
INSERT INTO mle_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisas dayak yakuw, taab dayaam wapwakuw, ata wadidiy, “Gwur arap. Yaga-tikwa.” ");
INSERT INTO mle_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Day kituw vikuw, nikidi duw day maa vi. Jisasadika vidaad. ");
INSERT INTO mle_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Day nibwukim dataay tikuw, Jisas dayak nimadib wadidiy, “Gwur ki vigwura javik kita nuwukadiy duw takwak wawayik. Ginyir duw taakw dayadi Mwaam kiyakuw, God kirapitaka-kidaad. A nyaam ki javik wakigwura.” ");
INSERT INTO mle_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jisas dikidiy kalivadidiy duw dikik ata bas sidaad, “Agwa javik God diki lo kalivanadiy wakwanadiy, ‘Yilayja taay yakuw, God dikidi Tasakwudidi Duw ata yakinaad?’” ");
INSERT INTO mle_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Jisas dayak ata wadidiy, “Ayiy. Yilayja taay yakinaad ababa jaav kwulapwuk. Aw wun watuwadiygwur Yilayja di bwutaay yaad. Yakuw, duw taakw dikim wak maarkuw, jawjaay kwurdaad dim. Dim kwurdaal pik atampik duw taakw dayadi Mwamim jawjaay kwurkidanaad.” ");
INSERT INTO mle_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas atawa wadik, dikidiy kalivadidiy duw ata lakwudaal, “Jisas nyanak Jon Baptais kwiydi duw dikik wanaad.” ");
INSERT INTO mle_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","16","Day nibwukim tikuw, dadaak, samasama vagaluwdiy duw takwak yidiy. Yikuw, duw nak Jisasak yakuw, kwatiyir sikuw, ata wadid, “Yitaypika duw, min wunadi nyinik awuk! Di as yikwanaad. Jaab samasam di yiywa gwaam vakir-kwanaad. Wun minadiy kaliva-minadiy duwak kwurin karaytuwaad day dikim sipwutiy-dakik. Aw day maa rav.” ");
INSERT INTO mle_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas a maaj wukikuw, dayak ata wadidiy, “Gwur bapa duw taakw wukijibiran maa ti. Nyi kas gwurak watuwik, wuna ap vikuw, lakwu-kigwura? Nyi kas wuna mawul yay dakina gwurak? Adi nyan wunak akaray.” ");
INSERT INTO mle_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisas wadik, adi nyan diki mawulaam kwadi wudib wapakuw, tabwud. Tabwukuw, adi nyan jayib ni ata yara kwaad. ");
INSERT INTO mle_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ginyir Jisas di kap kwadik, dikidiy kalivadidiy duw dikik yakuw, bas sidaad, “Agwa javik nyan kidi wudib kwurin yaki-yaki maarbanaad?” ");
INSERT INTO mle_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jisas ata wadidiy, “Gwur Godak nimadib wukijibir maa ti. Alik gwur maa rav. Gwur Godak kwasa mwiy wukijibir tikuw, gwur kidi nibwukik ‘Gwakuw maay!’ wakuw, di bwunak gwakuw, niki tamiyaar yikinaad. Atawa Godak wukijibir tikuw, samasama nimadiy yawiy kwur-kigwuradiy. Gwur kikipaat ki maarkuw, Godak bas sikuw, atampika yawiy kwurkigwuradiy.” ");
INSERT INTO mle_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Ginyir Jisas dikidiy kalivadidiy duw day vagaruwdaak Galiliy tamiyaam, Jisas wadidiy, “Ginyir adi duw nak duw taakw dayadiy Mwaam kwiykidanaad nuwukadiy duw daya tabaam. Adiy duw dim viyasipa-kidanaad. Kiyakuw, nyi mugwul yidaak, di ata rapikinaad.” Ki maaj wadik, Jisas dikidiy kalivadidiy duw samasam wukidiy. ");
INSERT INTO mle_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas dikidiy kalivadidiy duwawa Kapanim tipaar ata yidiy. Yikuw, God diki gaba maja wiy kidiy takis kwurdiy duw day Pitaak yakuw, ata bas sidaad, “Gwuradi kaliva-kwanadi duw di God diki gaba maja wiya takis yapiykwanaad, ay maa?” ");
INSERT INTO mle_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita, “Ayiy,” waad. Pita yala wiyaar wuladik, di a javik Jisasak wu maardik nibwaay, Jisas ata bas sidid, “Sayman, min wukimin ata ata? Sikadadiy-adiy takis kwiykwadiy ababa jaka tipa kidiy yitaypika duwak? Day dayadiy gwalugwa duw taakw, ay? Kipa duw taakw?” ");
INSERT INTO mle_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita Jisasak ata wadid, “Kipa duw taakw takis kwiykwanadiy dayak.” Jisas ata wadid, “Ay yaakiya, atawa tikuw, day dayadiy gwalugw takis akis kwiy-kwanadiy yitaypika duwak. Atawa tikuw, wun ata ata takis yapiy-kituwa wunadi Asaay dikidi wiyak? ");
INSERT INTO mle_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Jaaw, kupwaraap mawul tikik-nadiy. Alik min araar yikuw, sugw ayakisakw kamiyik. Taay sugwaar wulkimina kamiy liki dayim av. Saan alim vikimina. Aal rivikina wunaki takis awa minaki takis awa. Anabir takis ata ayapiy.” ");
INSERT INTO mle_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A nyi Jisas dikidiy kalivadidiy duw dikik yakuw, bas sidaad, “Sikadadaad mwiya yitaypika duw tikwanaad God dikidi gwalugwum?” ");
INSERT INTO mle_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jisas kwasadi nyinik wataydik, yidik, daya mwutamaam vatakadik, tidik, dikidiy kalivadidiy duwak ata wadidiy, ");
INSERT INTO mle_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Ki maaj awuk. Gwuradiy mawul kwasadiy nyanugw dayadiy mawula pik ti maarkidana, gwur God dikidi gwalugwuk vala-valak maa rav. ");
INSERT INTO mle_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","“Li adi kwasa nyan kaytik kidi kupwaam tikinaad, adi duw God dikidi gwalugwum yitaypik tikinaad. ");
INSERT INTO mle_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Sikadadaad wuna danik tikuw wunadi saam sukwasukw kwurkinaad kitampika nyinik, adi duw sukwasukw wunak kwurdil pik kwurkinaad.” ");
INSERT INTO mle_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kidiy wunak wukijibir tinadiy kwasanadiy nyanugw, aw duw nak yakuw mwugiydik, alik dayaam nak bwan wunak kwiykida, aw li taay duw adi duwaam nimadi kabaak diki kwaliyapaam yaav tuwtakakuw, guwaar yakikuw, kiyakwaad, aal viyakita, aw God dikim ginyir nimadi vaat kwiyik-daad. ");
INSERT INTO mle_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Duw taakw kupwa kidiy javik samasam wukikuw, day alik Godak bwan kwiykidiy. Wun samasam wukinadiwun atampika duw taakw. Aw li duw nak wunak wukijibir tikinadiy duw takwaam mwugiydik, wunak bwan kwiykidana, aw adi duw mwiya kupwaraap tiyakiyaki-kinaad. ");
INSERT INTO mle_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Li gwuradiy manwa taab mwugiydaak, gwur vaal yikuw, adi maan ay adi taab ata alupw! Aal gwur maan nak ay taab nak tikuw adawul tipaar wulakigwura, aal viyakita. Aw li maan vitiywa ay taab vitiywa yiy yana tipaar nabiy nabiy kwakigwura, aal kupwarapa. ");
INSERT INTO mle_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Li gwuradiy mil mwugiydaak, gwur vaal yikuw, a mil nak gwakuw, ayak! Aal gwur mil nak tikuw adawul tipaar wulakigwura, aal viyakita. Aw li min vitiywa yiy yana tipaar nabiy nabiy kwakigwura, aal kupwaraapa.” ");
INSERT INTO mle_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Gwur bwan kwiytikwa kidiy kwasadiy nyanugwak, ‘Kwasadiy nyanugw-adiy’ wakuw. Wun watuwadiygwur dayadiy dayak van tikwanadiy God diki maaj kardadiy duw nyanyi wunadi adawul tipaam kwanadi Asaay diki mwutamaam kwakwanadiy. Alik tikuw day dikik sukwupir maaj wakwadiy gwurak. ");
INSERT INTO mle_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Wun, duw taakw dayadi Mwaam, kidi kupwaar datuwil adiy Satan tabaam tinadiy duw taakw nyigirin kariyaak. ");
INSERT INTO mle_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Duw nak sipsip duwamiy tabab dayak van tinaad. Diki sipsip nak jaaw yilik, agwa jaav adi sipsip ak van tinadi duw kwurkinaad? Di adiy nuwukadiy sipsip duwamiy aliy sap tabatiy maan abwaliy vas tan kidaak, di dayaam wapakuw, jaaw yina sipsip ak kwakik yikinaad. ");
INSERT INTO mle_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","“Aal sipsip sitakirakuw, adi duw di rakarak samasam tikinaad aal jaaw yil sipsip ak. Aw adiy nuwukadiy sipsip duwamiy aliy sap tabatiy maan abwaliy atampik dayak rakarak ti maa. ");
INSERT INTO mle_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","“Atampik gwuradi adawul tipaam kwanadi Asaay adiy kwasadiy nyanugw day jaaw yiyak maa wanaad.” ");
INSERT INTO mle_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Li wunadi gwalugwa duw nak minaam vaal yidik, dikik yikuw, bir birada kap kwakuw, diki minak yidil vaal awasapwiy. Aw di diki valik wukikuw, ata bir mawul nak tikinabirbir. ");
INSERT INTO mle_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","“Aw di mina maaj wak maardik, nikibir gwalugwa duw vitiy kwurkuw, dikik maay. Yikuw, abir duw mina bwulakimina majik wukikinabir. Wukikuw, bir lakatiy-kibira mina majik dikik. God diki lapa nyig atawa wana. ");
INSERT INTO mle_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","“Aw di bira maaj wak maardik, wunadiy gwalugwa duw taakw vagaruwdaak, dayak a jaav awasapwiy. Aw di daya maaj wak maardik, di niki tipa kidi duw kaytik tikinaad gwurak. Di kupwarapa takis kwurkwanadi duw kaytik tikinaad gwurak.” ");
INSERT INTO mle_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Wun gwurak wunadiy gwalugwa duw taakw watuwadiygwur, adiy jaav gwur watipi-kigwura ki kupwaam God ab watipi-kida adawul tipaam. Adiy yaakiya wakigwuradiy jaav ki kupwaam God ab yaakiya wakinaad adawul tipaam. ");
INSERT INTO mle_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Niki jaav maa wakituwadiygwurik. Li duw vitiy bir mawul nak jaav nikik Godak bas sikibirik, wunadi adawul tipaam kwanadi Asaay a jaav birak kwurkida. ");
INSERT INTO mle_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","“Aw li duw vitiy mugwul vagaluwkuw ki yawiyik wunadi sawa apawa, wun daya nyidim tikidiwun. Alik God daya maaj wukikida.” Jisas atawa wadidiy. ");
INSERT INTO mle_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita Jisasak yakuw, ata bas sidid, “Yitaypika Duw, jaab kas wunadi gwalugwa duw wunaam vaal yidik, yin dikik yibwiy-kituwa? Jaab abitiy?” ");
INSERT INTO mle_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas Pitaak ata wadid, “Minak si wana jaab abitiy waan? Aw wun wanadiwun jaab duwamiyir duwamiyir minak yididiy vaal ayibwiy.” ");
INSERT INTO mle_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jisas Pita lakwudikik tikuw, ki maaj dikik wadil, “Kitawa God duw takwak van tinaad. Tayir yitaypika duw nak dikidiy yawiy kwurdiy duw dayadiy dikim kwurdadiy dinau vididiy. ");
INSERT INTO mle_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","25","“Van napadik, day duw nak kwurin kariyadaad dikik. Adi duw dikim dinau kwurdil saan mwiya nimaala. Aw adi dinau kwurdi duw vidil dikidiy saan maa rav. Alik dikidi masta ata dikidiy yawiy duwak wadidiy, ‘Gwur kidi duw, dikidiy nyanugw takwawa ababa jaav ayapiy nuwukadiy duwak. Saan kwurkuw, diki dinau ata kwusikwa. Kidi yawiy duw kipa yawiy kwurkinaad adi yapiy-kidadi duwak.’ ");
INSERT INTO mle_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ki maaj wukikuw, adi yawiy duw dikidi masta diki manwa kwatiyir vakirkuw, ata nimadib wadid, ‘Min wunak awuk! Wukikuw, nyi kwatiyamin, aw wunadiy dinau minak kwatiya-kituwadiy abab!’ ");
INSERT INTO mle_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Adi dikidi masta dikik samasam wukikuw, ata wadid, ‘Yaakiya, min maay! Wun mina dinau yibwiy-kituwa.’ ");
INSERT INTO mle_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Adi yawiy duw kawaar wakwukuw, di nikidi yawiy duw vidid. Adi duw dim dinau kwasa saan tidid. Aw di yikuw, adi nikidi yawiy duwaam kwaliyapaam kaybwukikuw, wadid, ‘Min kitaanabab wunadiy saan kwatiya-kiminadiy!’ ");
INSERT INTO mle_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Adi nikidi yawiy duw vakirkuw, ata nimadib wadid, ‘Min wunak awuk! Wukikuw, kavin ada. Wun ginyir kwatiya-kituwadiy minak.’ ");
INSERT INTO mle_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Aw li adi duw kwasik yad wadil majik. Kwasik yikuw, adi duw kwurkuw, kalabus ir kwusawuladid. ‘Min kilim kwaan minadiy dinau kwatiya-jibirakuw, ata wakwu-kinadimin.’ Wakuw wadid. ");
INSERT INTO mle_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Adiy nuwukadiy yawiy duw a jaav vikuw, samasam yaal giradiy. Day ata yidiy dayadi masta ak wakir adi duw kwurdidiy javik. ");
INSERT INTO mle_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","33","“Aw dayadi masta daya maaj wukikuw, adi yawiy duwak maaj wayakidil di yadikikik dikik. Yadik, ata wadid, ‘Min kupwarapa yawiy duw-adimin! Taay min wunak giramin, aw wun minak kip wapatuwadiy adiy ababa wunaam timinadiy ababa dinau. Wun minak wukituwil pik aw atampik akir kidi nikidi yawiy duwak wukiminil dikik? Aw min atawa maa kwar dikik.’ ");
INSERT INTO mle_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Dikidi masta wariya kwudiy wakuw dikik, dikim kwurkuw, wayakidik, kalabus ir yad. Kwaan vay sawdiy duw dikim jawjaay kwurkidanaad yin adiy dikidiy dinau sibinin kwiykida nyi tilik, ata kwusi-kinaad. ");
INSERT INTO mle_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Aw li gwur gwuradiy mawulaam gwuradiy gwalugwa duw dayadiy gwuraam yinadiy vaal yibwiy maarkigwura dayak, atampik adawul tipaam kwanadi wunadi Asaay gwurak kwur-kidadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas kidiy maaj wakwusin napakuw, Galiliy tamiy wapakuw, Juwtiya tamiyaar ata yad. Yikuw, Jawtan bayib libwukuw, apika gikir vakiyid. ");
INSERT INTO mle_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yidik, samasama duw taakw vagaluwdiy alim dikik. Yin vagaluwdaak, dayaam barik kwurdiy duw taakw di ata sipwutiy-didiy. ");
INSERT INTO mle_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nuwukadiy Parasiy yadiy Jisasak vasibariyik. Alik dikik bas sidaad, “Li duw diki taakw kipakip wapakida, aal yaakiya?” ");
INSERT INTO mle_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","6","Jisas dayak ata wadidiy, “Ki God diki lapa nyigaam rina maaj gwur van maa ti? Mwiya tayir God duw taakw yitakakuw, ata waad, ‘Wun duw taakw yitaka-tuwdiy. Alik duw dikibir amaay asayim wapakuw, di diki takwawa tikinaad. Bir ata nak tikinabir.’ Alik tikuw, ginyir bir vitiy ti maa. Amwiy nak kaytik tikinabir. Agwa jaav God bwu tuwtakada, duw gwutaka-diba!” ");
INSERT INTO mle_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Adiy Parasiy Jisasak ata bas sidaad, “Agwa javik mwiya tayir Mawsis ki maaj sukwudil God diki lapa nyigaam? ‘Duw diki takwaam wapaak tidik, aw di wapa-kwadanadiy lapa nyig likik kwiykuw, diki takwaam ata wapa-kwaad.’” ");
INSERT INTO mle_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas dayak ata wadidiy, “Gwur abab kabaak gwuradiy maka apaam rinadiygwur God diki mawulak ki javik. Alik Mawsis yaakiya waad gwur gwuradiy takwaam wapa-wapaak. Aw mwiya tayir atawa maa ti. ");
INSERT INTO mle_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","“Aw li duw diki taakw nikidi duwaam vaal yi maarlik, aw likidi duw likim kipakip wapakida, niki takwaam kirakida, adi duw diki ginya takwaam vaal yikinaad.” ");
INSERT INTO mle_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisas dikidiy kalivadidiy duw dikik ata wadaad, “Aw li duwawa taakw bir wa wamina maja pik tikibira, aal viyakita kip pasa duw pasa taakw tikibira.” ");
INSERT INTO mle_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Jisas dayak ata wadidiy, “Ababa duw gwurak wagwuril jaav kwurkwur maa rav. Adiy nuwukadiy duw God dayak ap kwiykuw, day ki jaav kwurkwadiy. Nuwukadiy duw taakw kira maa. Nuwukadiy duw dayadiy amaay sapwiydaak, dayadiy amwiy kupwaraap tidaak, alik taakw kirakir maa rav. Nuwakadiy duw dayadiy mad bwutaay kitikidaak, alik taakw kirakir maa rav. Nuwukadiy duw dayadiy mawul Godak diki yawiyda kwurik wakuw, alik day taakw kira maa. Adiy duw day kitawa kwurik ki maaj awuk.” ");
INSERT INTO mle_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","14","Nuwukadiy duw taakw dayadiy nyanugw kariyadadiy Jisasak dayaam taab takakuw Godak bas sidikikik. Aw Jisas dikidiy kalivadidiy duw a jaav vikuw, maa wadiy dayak. Jisas dayak ata wadidiy, “Nyanugw wunak yakwadiy. Watipi-tikwa! God dikidi gwalugw kitampika nyanugw dayakidaad.” ");
INSERT INTO mle_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Taab dayaam takakuw, ata wapadidiy. ");
INSERT INTO mle_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Duw nak Jisasak yakuw, dikik bas sidid, “Kalivanadi duw, viyakita jaav wun kwurkuw, nabiy nabiy yara kwakidiwun?” ");
INSERT INTO mle_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisas dikik ata wadid, “Agwa javik min wunak bas simina viyakita javik? Godadika di viyakit tinaad, nuwukadiy maa. Min nabiy nabiy kwakir wakuw, God dikidiy lo wab awuk.” ");
INSERT INTO mle_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Aw di Jisasak ata bas sidid, “Agwa lo wadiy?” Jisas dikik ata wadid, “Duwaam viyasipa-tikwa. Duw nikidi duw takwaam vaal yitikwa. Luwkuw kwurtikwa. Gwiyip kwur maaj watikwa. Amaay asaay biriki majib awuk. Gwur gwura sipak yarakara kwurgwura pik, gwur atawa akwur walibab kwanadiy duw takwak.” ");
INSERT INTO mle_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Adi badiy duw Jisasak ata wadid, “Kidiy waminadiy ababa lo wab wun wukikwanadiwun. Agwa jaav kip rina?” ");
INSERT INTO mle_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas dikik ata wadid, “Ki jaav kip rina. Min viyakit tikir wakuw, minadiy ababa jaav nuwukadiy duw takwak yapiykuw, adiy saan akwiy saal yinadiy duw takwak. Atawa kwurkimina, adawul tipaam nima jaav kwurkimina. Min ata wuna kwukib may.” ");
INSERT INTO mle_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Di a maaj wukikuw, diki maak vakiril. Di ata samasam wukid dikidiy niki jaav niki javik nuwukidiy duw takwak kwiy-kwiyik. Wukikuw, diki mawul pakwul. Ata Jisasaam wapadid. ");
INSERT INTO mle_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Atawa samasama jaav tinadi duw God dikidi gwalugwur vara-varak wukikida, dikim vaat yikina. ");
INSERT INTO mle_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","“Aw niki maaj watuwadiygwurik. Jaay tupwur kamil kwusawula-kwusawulak a nima yawiyal. Aw mwiya nima yawiy samasama jaav tinadi duw God dikidi gwalugwur vara-varak.” ");
INSERT INTO mle_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aw dikidiy kalivadidiy duw ki maaj wukikuw, day ata nimadib pitaan wardiy. Pitaan warkuw, ata wadiy, “Atawa tikuw, atata atata duw taakw God dikidi gwalugwur varakinadiy nabiy nabiy yara kwakir?” ");
INSERT INTO mle_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas dayak van napakuw, wadidiy, “Duw taakw day kap maa rav. Aw God rivnaad ababa jaav kwurkwurik.” ");
INSERT INTO mle_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita ata wadid Jisasak, “Awuk! Nyan ababa jaav bwutaay wapakuw, mina kwukib yanadiyan. Agwa jaav nyan kwur-kibanadiy?” ");
INSERT INTO mle_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisas dayak ata wadidiy, “Wun gwurak waaw. Ginyir miyawa jaav kwula jaav tikidana nyi, a nyi wun, duw taakw dayadi Mwaam, yitaypika tamiyaam daan rikuw, ababa duw takwaam kotiy ik, gwur wunadiy duw tabatiy maan vitiya duw, gwurabab daan rikigwura Yisrayil dayadiy gwalugw tabatiy maan vitiyaam kotiy ik. ");
INSERT INTO mle_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Abab day wunak wukijibiran tikuw, alik dayadiy wiy nyamwus mwaam jikwaar amaay asaay nyanugw kupw wapakidadiy wuna danik tikuw, God adiy duw takwak samasam nuwukadiy kwiykidadiy. Di wadik, day nabiy nabiy yara kwakidanadiy. ");
INSERT INTO mle_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Kita samasam day yitaypik tinadiy ginyir mwiya yisadayaki-kidiy. Aw kita samasam day yisadayaki-nadiy, ginyir day yitaypik tikidiy.” ");
INSERT INTO mle_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas dayak ata wadidiy, “Kitawa God duw takwak van tinaad. Ganbab duw rasikuw, yin adi mayim yawiy kwur duwak kwakibagwud. ");
INSERT INTO mle_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Di dayawa maaj lakatiykuw saan tabatiy nyi nak yawiyik dayak kwiydikik, di ata wayakididiy dikidi mayir yawiy kwurdakik. ");
INSERT INTO mle_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","“Ganib, nyi abaliy tilik, adi duw sibinin yikuw nyidi tipaar, di vididiy nuwukadiy duw day kip tidiy. Dayaam vikuw, di dayak wadidiy, ‘Gwurabab wunadi mayim yin yawiy kwurgwur, wun saan kwatiya-kituwadiygwurik.’ ");
INSERT INTO mle_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Aw day diki maaj wukikuw, yidiy yawiyik. Ginyir nyidi nyi tilik, nyi viyatakadik, taay kwurdil pik atampik kwurid. ");
INSERT INTO mle_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Nyi gilpik tidik, di nyidi tipaam vididiy nuwukadiy duw day kip tidaak, wadidiy, ‘Agwa javik gwur adi miyawa nyi kilim kip kwagwura?’ ");
INSERT INTO mle_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Day dikik ata wadaad, ‘Nyanak yawiy kwiykwiy duw maa.’ Di dayak ata wadidiy, ‘Gwurabab maay. Yin wunadi mayim yawiy akwur.’ ");
INSERT INTO mle_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Giraab kwusilik, adi maay duw dikidi yawiy van tidi duwak wadid, ‘Min gaam simin adiy mayim yawiy kwurnadiy duwak. Yadaak, dayadiy saan dayak akwiy. Min kwukir yinadiy duw dayak taay dayadiy saan akwiy. Adiy taay yinadiy duwak kwukir saan akwiy.’ ");
INSERT INTO mle_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Nyi gilpik tidik, yawiy kwurdiy duwak saan tabatiy tabatiy kwiydidiy. ");
INSERT INTO mle_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Adiy tayib yadiy duw vikuw, wukidiy mawulaar, ‘Nyan saan yitaypik kwurkinadiyan.’ Aw dayabab saan tabatiy tabatiy kwurdadiy. ");
INSERT INTO mle_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","“Day dayadiy saan kwurkuw, dayadiy mawul warkuw, adi maay asaay duwak wadaad, ‘Kidiy kwukir yanadiy duw nyi nak yawiy kwurkuw, min dayak saan tabatiy tabatiy kwiyminadiy. Aw nyan kidi nyi miyawa yawiy kwurbana. Nyidi nyi nimadi nyi nyanaam sikuw, aw min nyanak ab saan tabatiy tabatiy kwiy-minadiyan. A maa rav.’ ");
INSERT INTO mle_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","15","“Adi maay asaay duw dayaam duw nikik wadid, ‘Wunadi kapa duw, min awuk. Wun gwurak kwasa saan maa kwataay. Gwur wunawa maaj lakatiybana saan tabatiyak ki nyi liki yawiyik kwurkwurik, ay maa? Gwur gwuradiy saan kwurkuw, gwuradiy wiyaar maay. Li wun kidiy kwukir yanadiy duwak gwurak kwiytuwadiy sana pik kwiykituwa, aal wuna yawiya. Kidiy saan wunadiy-adiy. Wuna mawul wala yawiy kwurkituwa adiy sanak, aal wuna yawiya, ay maa? Gwur maa wagwura wun nima saan nuwukadiy duwak kwiytuwadiy? Ay maa?’ ");
INSERT INTO mle_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Atampik adiy duw taakw day taay God dikidi gwalugwur wuladiy day dayadiy saan kwukir kwurkidanadiy. Aw adiy kwukir God dikidi gwalugwur wulakinadiy duw taakw taay day dayadiy saan kwur-kidanadiy.” ");
INSERT INTO mle_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jiruwsalimaar warik tikuw, dikidiy kalivadidiy duw tabatiy maan vitiy nakamwiyib yitaay tikuw, nyidiy yabim tikuw, di dayak kap wadidiy, ");
INSERT INTO mle_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","“Wukigwura nyan Jiruwsalimaar warkibana. Warkuw, adi duw nak duw taakw dayadi Mwaam sapakwa nyanugw pris awa God diki lo kalivanadiy duwak kwiy-kidadiwun. Day kiyadikik wakinadiy. Wakuw, day wun niki jaka tipa kidiy bapa duwak kwiykidadiwun. Kwiykuw, day wunak wajibay-kinadiy. Wunaam ramiy rinadi miyaar viyakidanadiwun. Viyaan napakuw, wunaam ata viyasipadaak, kiyakinadiwun. Ginyir nyi mugwul yidaak, God wunaam ata kirapitaka-kidadiwun.” ");
INSERT INTO mle_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sipatiy dikibir duwa nyidiy, Jamisawa Jon, biraki amaay li likibir duwa nyidiy kwurkuw, Jisasak yakuw, dikik ab gwalikakuw, dikik ata walid, “Wun minak bas sikir jaav nikik.” ");
INSERT INTO mle_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisas likik ata bas sidil, “Agwa javik nyina mawul wana?” Li dikik ata walid, “Ginyir min ababa duw takwak van tikimina, a nyi min wakuw, wunabir duwa nyidiy nak mina mava tabaam nak mina akiy tabaam atawa tikinabir. Bir minawa duw takwak van tikir daan rikibira.” ");
INSERT INTO mle_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisas dayak ata wadidiy, “Gwur maa laakw wunak bas sigwura javik. Wunak kupwaraap yakinadiy jaav atampika jaav birabab kwur-kinabirbir rikir?” Bir ata wabirid, “An bwunak kwurkita.” ");
INSERT INTO mle_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jisas birakik ata wadibir, “Wunak yakinadiy jaav kitampik kwur-kinabirbir. Aw wunabir mava tabawa akiy tabaam rikinabir duw wun birakim tasakw maa. Aal wunadi Asaay diki yawiya. Ginyir di tasakwu-kidabir diki mawulaam rinabir duw.” ");
INSERT INTO mle_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jisas dikidiy nuwukadiy tabatiy duw a jaav wukikuw, wariya kwudiy wadiy Jamisawa Jonak. ");
INSERT INTO mle_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Alik Jisas dayak gaam sididiy yaan vagaruwdakik dikik. Day yakuw, di ata wadidiy, “Gwur lakwu-gwura ababa nuwukadiy jaka tip dayadiy van tinadiy duw ap kwurnadiy dayadiy duw takwak van tikuw. Aw dayadiy mawulaam van tikwanadiy. ");
INSERT INTO mle_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","“Gwur kitampik maa ti. Li duw nak gwuraam yitaypik tikir, God diki milaam di gwuradi yawiy duw tikwaad. ");
INSERT INTO mle_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","“Li gwuraam duw nak yitaypika duw tikir God diki milaam, aw nuwukadiyik kipa yawiy duw tikwaad. ");
INSERT INTO mle_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","“Atawa duw taakw dayadi Mwaam maa yi nuwukadiy duw taakw yawiy kwurdakik dikik. Di nuwukadiy duw takwak sugwiyaan kwurik yaad. Di yaad samasama duw taakw dayadiy vaal Godak kwiyik. Kiyakuw, di dayadiy vaal yapiy-kidadiy.” ");
INSERT INTO mle_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Day Jarikaw tip wapakuw, yidaak, duw taakw samasam Jisas kwukib yidiy. ");
INSERT INTO mle_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mil kwakibir duw vitiy mala yabim daan ribir. Bir ata maaj wukibir Jisas yataay tidik walibab. Wukikuw, nimadib ata gaam sikuw, ata wabir, “Yitaypika duw, Davit dikidi gwalugwa duw-adimin, anak min awuk!” ");
INSERT INTO mle_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nuwukadiy duw taakw birakik wariya kwudiy wakuw, wadabir, “Bir kaygan ada!” Aw bir wadaal majik maa wak. Bir ata mwiya nimadib Jisasak maa gaam sibirid, “Yitaypika duw, nyanadiy warag dayadi yitaypika duw Davit dikidi gwalugwa duw-adimin, anak min awuk!” ");
INSERT INTO mle_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas walibab tikuw, wadibir, “Birak agwa jaav kwurtuwkik birabir mawul wanabir?” ");
INSERT INTO mle_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bir Jisasak ata wabirid, “Yitaypika duw, an sipwutiy-minkik anabir mil.” ");
INSERT INTO mle_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas di birakik samasam wukikuw, diki taab birakibir milaam takadik, jayib nak vibirbir birakibir mil. Vikuw, bir ata diki kwukib yibir. ");
INSERT INTO mle_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Day Jiruwsalimaar yitaay tidaak, mala Aliv nibwukim ril tip, Bitpas, ata walibab tal. Tilik, dikidiy kalivadidiy duw vitiy wayakikuw, wadibir, “Bir yikuw, walibab rina kwasa tipaar maay. Yikuw, tipaar wulakuw, dagiy alim sitakira-kibiraal. Yaav tuwtakada miyaam tina likidi badiy dagiy wa. Bir raliykuw, kiril akaray. ");
INSERT INTO mle_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Li duw taakw birak bas sikidiy, ‘Agwa javik kwurbiraad?’ bir dayak aw, ‘Nyanadi sapakwa nyan di yawiy kwurdikik birakiwa. Yawiy kwusilik, yabiyib sibinin wayaki-kidabir.’” ");
INSERT INTO mle_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jisas atawa kwurdil tayir God diki maaj wasapwiydi duw God diki lapa nyigaam sukwudil maaj ata mwiya mwiyaba maaj tal. ");
INSERT INTO mle_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kitawa wana: “Gwur Jiruwsalim tipa kidiy duw takwak aw, ‘Gwuradi yitaypika duw gwurak yanaad. Di viyakita mawul tinaad. Aw di apiy dagiy bwunim rikuw, yanaad.’” ");
INSERT INTO mle_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Abir vitiya duw yikuw, Jisas wadil majib kwurbiril. ");
INSERT INTO mle_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bir abir amaay dagiywa likidi nyinwa kwurin kariyabirik. Kariyakuw, dayadiy wapwiy abir dagiy biraki bwunim takakuw, Jisas ata adi badiy dagiy bwunim warkuw, daan rad. Jiruwsalimaar ata bas yad. ");
INSERT INTO mle_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Duw taakw samasam dayadiy wapwiy yabim yapir takadadiy gilabadiy kaytik. Nuwukadiy duw taakw gagawa ba miy samasam kwurkuw, yabim takadadiy. ");
INSERT INTO mle_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Adiy taay Jisasak adiy kwukir abab rakarak tikuw, gaam sidiy, “Wayapiy as nyanadiy warag dayadi yitaypika duw Davit dikidi waraga duwak! God di mwiya viyakit-ad!” ");
INSERT INTO mle_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","11","Jisas Jiruwsalimaar wuladik, alim kwadiy ababa duw taakw pitaan warkuw, day daya wadiy, “Kidi duw sikanadaad?” Nuwukadiy duw taakw ata wadiy, “Kad God diki maaj wasapwiynadi duw Jisas-ad. Di Galiliy tamiyaam rina tip Nasarit tipa kid-ad.” ");
INSERT INTO mle_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Day Jiruwsalimaar wuladaak, Jisas God dikidi wiyaar ata wulaad. Adiy ababa yapiydiy duw takwak Jisas watipisakwu-didiy. Ababa Rom dayadiy sanawa God dikid wiya saan waripiydiy duw abab kaybalaki-didiy. Adiy vaal kwuryi-dadiy midakim wapiy yapiydiy duw dayadiy jaab dayadiy tikir wapayakidik, vakirdiy. ");
INSERT INTO mle_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Di dayak ata wadidiy, “God diki lapa nyigaam kitawa wanaad, ‘Ababa tipa kidiy duw taakw valakwadiy wunadi wiyaar wunak wayapiy sikir.’ Aw gwur gwura mwugiygwuril luwkuw kwurnadiy duw daya tamiya!” ");
INSERT INTO mle_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Adiy duw taakw dayadiy mil kwakidiy, adiy duw taakw dayadiy maan kupwarap-adiy, day abab Jisasak yakuw God dikidi wiyaam, di sipwutiy-didiy abab. ");
INSERT INTO mle_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Adiy sapakwa nyanugw pris awa God diki lo kalivadiy duw day Jisas dikidiy kwurdidiy viyakita yawiy vikuw, adiy nyanugw God dikidi wiyaam nimadib gaam sidaak, “God viyakit kwurkwaad Davit dikidi gwalugwa nyinik,” day alik tikuw, yaal giradiy. ");
INSERT INTO mle_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aw day Jisasak ata wadaad, “Aw min wukiminadiy adiy wadanadiy maaj?” Jisas dayak ata wadidiy, “Ayiy, wun bwu wukituwa. Aw gwur ki God diki lapa nyigaam rina maaj gwur maa vi? Aal kitawa wana: ‘Kwasadiy nyanugwawa adiy mwuny kan kwakinadiy, God mwugiy-dadiy day mwiyir wayapiy sidakikik.’” ");
INSERT INTO mle_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wakuw, dayab wapakuw, Jiruwsalim tip wapakuw, Bitaniy tipaar ata yad a gaan alim si kwakir. ");
INSERT INTO mle_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sira pik ganbab, Jisas Jiruwsalimaar sibinin yitaay tikuw, di ata kaam yisad. ");
INSERT INTO mle_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Di miy, si vik, vidid mala yabim tidik. Vikuw, adi miyak yikuw, dikidiy mwiy sitakirakuw kikir, di vidil adi miy mwiy samab maa ri. Gagadika rad. Vikuw, adi miyak ata wadid, “Min ginyir samab mwiy ri maa.” Jayib nak ata wadik, adi miy ata rik yad. ");
INSERT INTO mle_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jisas dikidiy kalivadidiy duw a jaav vikuw, pitaan warkuw, day dikik ata bas sidaad, “Ata ata kidi miy jayib nak rik yinaad?” ");
INSERT INTO mle_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas dayak ata wadidiy, “Ki maaj awuk! Aw li gwur gwuradiy mawul Godak wukijibir tikigwura, mawul vitiy ti maarkigwura, kidi miyak watuwik rik yida pik atampik gwurabab wagwur, rik yikinaad. Aw ki javadika maa, nuwukadiy jaav ab kwurkigwuradiy. Aw li gwur kidi nibwukik wakigwura, ‘Min rapikuw, yin guwaam avakir!’ atawa wakigwura majib wukikuw, gwakuw, yikinaad. ");
INSERT INTO mle_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Aw li gwur Godak wukijibir tikuw, dikik bas sikigwuradiy ababa jaav ata kwur-kigwuradiy.” ");
INSERT INTO mle_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas God dikidi wiyaar sibinin yakuw, adiy duw takwak kalivadik, adiy sapakwa nyanugw pris awa Juw dayadiy sapakwa nyanugw dikik yakuw, ata bas sidaad, “Agwa apa tikuw, kidiy jaav kwurminadiy? Minak ap kwiyid, sikadadaad?” ");
INSERT INTO mle_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","26","Jisas dayak ata wadidiy, “Wun jaav naka bas sikir gwurak. Aw wunak wakigwura wunak ap kwiydi duw ad wakituwaad gwurak. Sikadadaad Jonaam wayakid baptais kwiydikik? God-ad? Ay duw-adiy? Wunak aw!” Day awarwa awarwa maaj bwulabagwudiy. Day daya ata wadiy, “Nyan ata ata wakinadiyan? Aw li nyan, ‘God-ad’, waan wakibana, di nyanak, ‘Agwa javik gwur diki majib wukimar-gwuril?’ wakinaad. Aw li nyan, ‘Duw-adiy’, wakibana...” Day duw takwak yagadiy. Agwak, abab wukidiy Jon God diki maaj wasapwiydi duw-ad. ");
INSERT INTO mle_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Alik day Jisasak ata wadaad, “Nyan maa laakw.” Jisas dayak ata wadidiy, “Wunabab gwurak wu maa agwa apaar kidiy jaav kwurtuwadiy.” ");
INSERT INTO mle_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas ki waya maaj kitika maaj wadil dayak. “Aw gwur wukigwur ata ata ki majik? Duw nak di nyidiy vitiy tad. Di taay nyinik yikuw, wadid, ‘Wunadi nyan, wun min wuna mayim yin yawiy kwurminkik nibwul.’ ");
INSERT INTO mle_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Adi nyan dikidi asayik wadid, ‘Wun kwasik yinadiwun.’ Atawa wakuw, ginyir diki mawul warapiykuw, di ata dikidi asaay mayim yawiy kwurid. ");
INSERT INTO mle_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Adi duw dikidi vitiya nyinik yikuw, taay nyinik wadil maja pik wadid. Wadik, adi nyan di, ‘Ayiy’ waad. Wakuw, di mayir maa yi. ");
INSERT INTO mle_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Abir nyidiy, sikadadaad birakidi asaay majib wukid?” Day ata wadiy, “Adi taay nyanad.” Jisas dayak ata wadidiy, “Wun watuwadiygwurik adiy kupwarapa takis kwurkwanadiy duwawa adiy yabim kwurkwur tikwanadiy taakw, day taak God dikidi gwalugwur wulakinadiy. Aw gwur daya kwukir wulakigwura, ay gwur wul maa. ");
INSERT INTO mle_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Aw Jon Baptais kwiydi duw gwurak yakuw, ‘Gwuradiy mawul warapiykuw, God diki majib awuk!’ Wakuw wadik, gwur diki majib maa wak. Aw adiy kupwarapa takis kwurdiy duwawa adiy yabim kwurkwur tidiy taakw day Jon diki majib wukidiy. Aw gwur a jaav bwu vigwuril. Vikuw, gwur gwuradiy mawul warapiy maarkuw, diki majib wukimar-gwuril.” ");
INSERT INTO mle_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas dayak ata wadidiy, “Gwur niki waya maaj kitika maaj awuk. Duw nak bajigay si girap, diki mayim sididiy. Sikuw, kabaka yarip kaypwusidid. Di kaw ata vadid. Ginyir girap dayadiy mwiy alim manir vasi-kidanadiy dayadiy guw kwurkuw, kidakikik. Alawul pik tina wiy ata kwurdil apiy yaripaam van tidiy duwak. Yawiy kwurdiy duw daya tabaam ata takadid adi maay. Takakuw, sikaam ril jaka tipaar ata yad. ");
INSERT INTO mle_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Girap lawdaal nyi yawiy duw wayakididiy dayak diki am kwurdakik. ");
INSERT INTO mle_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Aw day adiy yawiy duwaam kalakwukuw, nak day viyadaad, nak day viyasipadaad, nak kabakir viyadaad. ");
INSERT INTO mle_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Ginyir maa adi maay asaay duw kwasa samasam nuwukadiy yawiy duw wayaki-didiy adi mayik van tidiy duwak. Aw day adiy yawiy duwaam tayir yidiy yawiy duwaam kwurdaal pik kwurdadiy. ");
INSERT INTO mle_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Atawa dayak kwurdaak, di dikidi nyan wayakidid adi mayik van tidiy duwak. Diki mawulaam waad, ‘Day wukikinadiy wunadi nyinik.’ ");
INSERT INTO mle_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Aw adiy duw adi nyinim vikuw, day daya wadiy, ‘Kidi duw maay asaay dikidi nyan-ad. Dim viyasipanaak. Dim viyasipakuw, kidi maay nyanadi maay tikinaad.’ ");
INSERT INTO mle_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Alik dim kayakitikuw, kawaar yakisakwukuw, viyasipa-daad.” ");
INSERT INTO mle_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisas dayak ata bas sididiy, “Adi maay asaay yakuw, agwa jaav kwurkinaad adiy mayik van tinadiy duwaam?” ");
INSERT INTO mle_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Day dikik ata wadaad, “Di yakuw, adiy kupwarapa duwaam viyasipakuw, adi maay nuwukadiy yawiy duwak ata kwiykinaad. Aw day diki am sikuw, yabiyib dikik kwiy-kidanaal.” ");
INSERT INTO mle_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas dayak ata wadidiy, “Gwur ki God diki lapa nyigaam rina maaj maa vi? Kitawa wana: ‘Adi kabaak, tayir wiy kwurdiy duw maa wadiy dikik, kita nimadi kabaak abwa tibawa rinaad. Nimadi Yitaypika Duw a jaav kwurdil. Nyan vikuw, ata paynadiyan.’ ");
INSERT INTO mle_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Alik wun watuwadiygwurik, tayir gwur Juw duw God diki yawiyik van tigwuril. Aw gwur diki yawiy jawjaay kwurgwuril. Alik tikuw, God di maa wakuw gwura yawiyik, a yawiy nuwukadiy jaka tipa kidiy duwak kwiykida. Aw adiy duw day dikik viyakita yawiy kwurkidiy. ");
INSERT INTO mle_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Adiy duw taakw day adi apiy kabakim vakir-kinadiy dayadiy ap bwan tukwiya-kidiy. Aw li adi kabaak dayadiy apiyim vakir-kidadiy, mwiya kwayupw kitik viyamwunyir-kidadiy. Aw wun adi kabaak-adiwun. Aw wun adi kabaak-adiwun.” ");
INSERT INTO mle_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","46","Adiy sapakwa nyanugw pris awa Parasiy Jisas wadil waya maaj wukikuw, day lakwudiy, “Jisas wadidiy waya maaj kitika maaj dayadiy maw nyan kwurbanadiy yawiyik maa wanaad.” Alik day Jisasaam kalakwuk. Aw day lakwudiy ababa duw taakw wadiy, “Jisasad God diki maaj wasapwiynadi duw-ad.” Day yagadiy adiy duw takwak. Alik day Jisasaam kalakwuk wukidaal maa rav. ");
INSERT INTO mle_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas maa ata waya maaj kitika majir duw takwak wadidiy. ");
INSERT INTO mle_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kitawa God duw takwak van tinaad. Yitaypika duw nak dikidi nyan taakw kiradil nyaam bayaki kikipaat jabim takadidiy dikik. ");
INSERT INTO mle_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","“Adi yitaypika duw dikidiy yawiy duw wayaki-didiy nuwukadiy duw takwak akiy wadakikik bayaki kikipatik. Aw day kwasik yidiy yiyak. ");
INSERT INTO mle_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Di nuwukadiy yawiy duw ata maa wayakididiy. Wayakikuw, wadidiy, ‘Gwur yikuw, adiy wun wunadiy watuwadiy duw takwak kitawa dayak aw, Wuna bayaki kikipaat bwutaay kwulapwu-tuwadiy. Wunadiy nimadiy bulmakau awa badiy bulmakau bwutaay viyasipakuw, aw ababa niki kikipaat niki kikipaat bwutaay kwulapwu-tuwadiy. Yaakiya, gwur may wunaki bayaki kikipatik.’ ");
INSERT INTO mle_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","Aw adiy dikidiy yawiy duw yikuw, wadidiy majib wadadiy. Aw day adiy maaj wukiwukik maa wakuw, day dayadiy niki yawiy niki yawiyik yidiy. Duw nak diki mayik yad. Duw nak diki stua ar yad. Aw nuwukadiy duw alib tikuw, adiy yitaypika duw wayakididiy dikidiy yawiy duwaam kaykitikuw, viyaan napakuw, viyasipa-dadiy. ");
INSERT INTO mle_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Adi nimadi yitaypika duw a jaav wukikuw, di yaal samasam giraad. Di ata dikidiy vay sawdiy duw wayakidik, yidiy adiy duwaam viyasipakuw, daya tip yiy wapwadakik. ");
INSERT INTO mle_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","9","Adi yitaypika duw dikidiy yawiy duwak gaam sikuw, yadaak, wadidiy dayak, ‘Wunaki bayaki kikipaat bwutaay kwulapwu-tuwik rina. Aw adiy yadakikik watuwadiy duw taakw maa wanadiy yayak. Alik wun kwasik yinadiwun day yayak. Aw kita gwur yabir yin yaan tikuw, ababa sitakira-kigwuradiy duw taakw wagwur, yakwadiy wunaki bayaki kikipaat kidakikik.’ ");
INSERT INTO mle_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Adiy yawiy duw yabir yikuw, samasama duw taakw, nuwukadiy viyakit-adiy, nuwukadiy kupwarap-adiy, sitakirakuw, kwurin karaykuw, adi bayaki kikipaat rinadi wiyaar kawuladaak, adi wiy miyawa wapwurakwud. ");
INSERT INTO mle_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Adi yitaypika duw wiyaar wuladik, vagaluwdiy duw takwak vikir, duw nak vidid di kipa wapwiy kwusuwdik. ");
INSERT INTO mle_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Adi yitaypika duw dikik ata wadid, ‘Wunadi kapa duw, wun viyakita wapwiy ababa duw takwak kwiytuwadiy bayaki kikipatik. Aw min ata ata kidiy kwusuw-danadiy wapwiy pik kwusuw maarkuw, kidi wiyaar valanadimin?’ Aw adi duw di maaj maa wu. Kip kaygan rad. ");
INSERT INTO mle_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Adi yitaypika duw dikidiy yawiy duwak ata wadidiy, ‘Gwur kidi duw dikidiy maan taab yaav jitakakuw, ayakisakw. Kawaar gaan van tina tamiyaam kwakwaad. A tamiyaam di kwataay, nimadib girataay, dikidiy wuk vatikirikiy-kwaad.’” ");
INSERT INTO mle_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas dayak ata wadidiy, “Ki maaj liki maaw kitawa wana: God samasama duw takwak akiy wadidiy day dikidi gwalugwur wuladakik. Samasam maa wakuw diki majik, alik day wul maa. Adiy tasakwudidiy duw takwadika day wulakinadiy dikidi gwalugwur.” ");
INSERT INTO mle_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Adiy Parasiy day diki maaj wukikuw, day Jisasaam wapakuw, yikuw, maaj ata lakatiydiy, “Ata ata maaj nyan Jisasaam wakuw, vasibariy-kibanaad?” ");
INSERT INTO mle_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","17","Maaj lakatiykuw, day ata nuwukadiy dayadiy kalivadadiy duwawa Juw dayadi yitaypika duw, Yirat, dikidiy bapa duwawa wayakidadiy Jisasak. Yikuw, day Jisasak ata wadaad, “Kalivanadi duw, nyan lakwunadiyan min viyakita duw-adimin. Ababa duw taakw rivriv tinadiy minak. Yitaypika duwak niki maaj maa, maaj nak. Min God diki maaj mwiyir kaliva-kwanadimin. Aw min nyanak aw. Nyan wukik, nyan takis Rom dayadi yitaypika duw, Sisaak, kwiynaak, ay maa? Nyana lo atata wana a javik?” ");
INSERT INTO mle_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","19","Jisas lakwudil day tikal vitiy tidiy. Alik di dayak ata wadidiy, “Gwur viyuw tikala pik pasira-nadiygwur. Agwa javik gwur gwiyip kwur-gwuradiwun? Takis yapiy-kwagwura saan wunak asimak.” Day saan nak dikik kariyadaal. ");
INSERT INTO mle_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kariyadaak, di dayak bas sididiy, “Kidi kayik mwutamawa si av. Sikanadaad?” ");
INSERT INTO mle_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Day ata wadaad, “Sisa dikibir-abir.” Jisas ata wadidiy, “Ay yaakiya, Sisa dikidiy jaav dikik akwiy. Aw God dikidiy jaav dikik akwiy.” ");
INSERT INTO mle_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Day a maaj wukikuw, ata pitaan warkuw, day Jisasaam wapakuw, ata yidiy. ");
INSERT INTO mle_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Niki bapa duw, si Satuwsiy, day dayadiy mawulaam wadiy duw kiyakuw, ginyir rap maa. A nyab nuwukadiy Jisasak ata yadiy. ");
INSERT INTO mle_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Day Jisasak ata wadaad, “Kalivanadi duw, Mawsis ki maaj sukwudil nyanak, ‘Duw kiyakuw, aw nyan maa, diki taakw kip kwaal, adi duw dikidi mwaam diki taakw kiraan tikida. Li ata nyanugw sapwiy-kiladiy likidi taay duw diki tamiy kwurdakik. ");
INSERT INTO mle_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Tayir abitiy nyamwus mwaam kilim tidiy. Dayadi mwaam taakw kirakuw, ata kiyaad. Aw di nyan maa ti. Kiyadik, dikidi nyamwus diki taakw kiradil maa. ");
INSERT INTO mle_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","“Atampik dikidi kwukiba nyamwus a taakw kirakuw, dibab kiyaad. Dibab nyan maa ti. Atampik day abab nyamwus, mwamugw likim kirakuw, abab kiyadiy. Nyanugw maa ti. ");
INSERT INTO mle_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","“Ginyir a taakw ata kiyaal. ");
INSERT INTO mle_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Ginyir God abab kiyanadiy duw taakw kirapitaka-kida nyaam, a taakw sikadi duw taakw tikina? Tayir duw abitiy kiradaal.” ");
INSERT INTO mle_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas dayak ata wadidiy, “Gwura maaj viyakit maa. God diki lapa nyigaam rina maaj gwur maa laakw. God diki ap ab gwur maa laakw. ");
INSERT INTO mle_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","“Ginyir God kiyanadiy duw taakw kirapitakadik, day adawul tipaam kwakinadiy, God diki maaj kardadiy duw kitik. Alik duw taakw kirakir maa. ");
INSERT INTO mle_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","“Ki kiyanadiy rapa majik gwur God diki lapa nyigaam rina maaj maa vi? God wadidiygwur, ‘Wun Aparam Aysakawa Jakap dayadi God-adiwun tikwanadiwun.’ Aw li God atawa waad adiy Mawsis diki tayir kwakuw kiyadiy duwak gwur lakwu-kigwura adiy duw kiyakuw, kwas maa. Dayadiy mawul kip kwakwanadiy. Alik God di kwakwanadiy duw taakw dayadi God-ad.” ");
INSERT INTO mle_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Adiy vagaluwdiy duw taakw wukikuw, day pitaan wardiy diki majik. ");
INSERT INTO mle_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Adiy Parasiy day wukikuw Jisas adiy Satuwsiyaam kakildidiy majik, day vagaluwkuw, Jisasak ata yadiy. ");
INSERT INTO mle_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Dayaam duw nak, God diki lo kalivadi duwad, di Jisasak bas sidid, “Kalivanadi duw, agwa lo wal ababa lo waam kakilna?” ");
INSERT INTO mle_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas dayak ata wadidiy, “‘Gwuradiy maan taab ap bwan mawul miyawa Yitaypika Duw gwuradi Godak yikwadiy.’ ");
INSERT INTO mle_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ki lo nuwukadiy lo waam yitaypik tina. ");
INSERT INTO mle_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ki ginyir lo atampik, ‘Gwur gwurak wuki-kwanadiygwur. Atawa walibab tinadiy duw takwak ab awuk.’ ");
INSERT INTO mle_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kibir lo Mawsis dikidiy lo wawa God diki maaj wasapwiydiy duw dayadiy kalivadadiy majiwa dayadiy maw-abir.” ");
INSERT INTO mle_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Adiy Parasiy day Jisasawa vagaluwun tidaak, Jisas ata bas sididiy, ");
INSERT INTO mle_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gwur wukigwura God dikidi Tasakwudidi Duwak ata ata lakwugwurad? Di sikidi gwalugwa nyan-ad?” Aw day dikik ata wadaad, “Di Davit dikidi gwalugwa nyan-ad.” ");
INSERT INTO mle_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisas dayak ata bas sididiy, “Agwa javik God dikidi Mawul mwugiydik, nyanadi warag dayadi yitaypika duw Davit sikiydid, ‘Yitaypika Duw-ad’? Aw Davit ki maaj wadil, ");
INSERT INTO mle_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“God wunadi Yitaypika Duwak wadid, ‘Kilim wuna mava tabaam daan ada. Rikuw, wun minadiy mama nibaam kakilkuw, min dayaam van tikiminadiy.’ ");
INSERT INTO mle_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Aw li Davit God dikidi Tasakwudidi Duw sikiydid, ‘Wunadi Yitaypika Duwad’ wakuw, ata ata di Davit dikidi waraga nyinda tikik-naad? Alik tikuw, adi duw Davit dikidi yitaypika duw-ad tinaad.” ");
INSERT INTO mle_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aw dayaam duw nak maaj awarab Jisasak maa rav. A nyab kariyarib day Jisasak niki jaav niki jaav bas sisak yagadiy. ");
INSERT INTO mle_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisas dikidiy kalivadidiy duwawa ababa duw takwak ata wadidiy, ");
INSERT INTO mle_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“God tasakwudil diki lo kalivanadiy duwawa Parasiy day Mawsis kwiydidiy lo dayadiy maaw kaliva-kwanadiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","4","“Gwur dayadiy kaliva-danadiy majib awuk. Aw kidiy duw day viyakita jaav kalivataay, aw day daya akis kaliva-kwadanadiy javib kwurkwanadiy. Alik gwur day kwurdana pik kwur-tikwa. Aw day dayadiy samasama lo-ab kwiy-danadiygwurik. Kidiy kwiydanadiy lo nimadiy vaat yinadiy gwuraam. Day adiy lo-aam akis kwurkwanadiy. Aw day sugwiyaan maa kway dayadiy lo kwurkwurik. ");
INSERT INTO mle_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Day God diki lo sukwukuw, adiy lo dayadiy tabawa maka apaam jikuw, simiy gilabadiy dayadiy nimadiy wapwiyim tipi-kwadanadiy ababa duw taakw vidakikik. ");
INSERT INTO mle_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Kikipaat bayaki nyi day taay wakwun rikwanadiy. Juw dayadiy gaba maja wiyaam day viyakita tikir kwurkwadanadiy. ");
INSERT INTO mle_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","“Day nyidi tipaam tiytiyaan tidakikib, duw taakw dayak yataay, wayapiy sitaay, ‘Kupwiyaay, kaliva-kwanadi duw,’ wataay wadakikib, rakarak tikwanadiy. ");
INSERT INTO mle_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Duw nak gwuradi kalivakwanadi duw tinaad. Gwur abab rivriv-adiygwurik. Alik gwur nikidi duwak nimadi si sikiytaka-tikwa. ");
INSERT INTO mle_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","“Adawul tipaam kwanadi God di kap gwuradi Asaay tinaad. Alik gwur nikidi duwak, ‘Nyanadi asaay,’ watikwa kidi kupwaam. ");
INSERT INTO mle_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“Gwuradi nimadi Yitaypika Duw di God dikidi Tasakwudidi Duw-ad. Alik nikidi duwak, ‘Nimadi Yitaypika Duwad,’ waan watikwa. ");
INSERT INTO mle_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Adi duw di yitaypik gwuraam tikida, di kipa yawiy gwurak kwurkwaad. ");
INSERT INTO mle_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","“Li adi duw di diki sipak wukikuw, di yitaypik tikir wakuw, adi duw ginyir kwasaad tikinaad. Aw adi duw di diki sipak wak maarkida, yitaypik tikir, ginyir God tasakwudik, adi duw yitaypik tikinaad.” ");
INSERT INTO mle_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Gwur God diki lo kalivanadiy duwawa Parasiy, mwiya kupwaraap gwurak tikina. Gwur viyuw tikala pik vitiy pasiranadiy duw-adiygwur! Samasama duw taakw day God dikidi gwalugwur wulak tikuw, aw day gwura majib wukikuw, alik day wulawul maa rav. Gwurabab wul maa. ");
INSERT INTO mle_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Gwur God diki maaj kalivanadiy duwawa Parasiy, mwiya kupwaraap tikina gwurak! Gwur viyuw tikala pik vitiy pasira-nadiygwur. Gwur apaapap kwurgwura apa, duw taakw daya mwutamaam Godak simiy maaj bwulagwura day, ‘Kidiy viyakita duw-adiy,’ gwurak wadakikik. Aw gwur suwaal takagwura tawtakw kwanadiy takwak dayadiy wiyawa niki jaav niki jaav luwkuw kwurik. ");
INSERT INTO mle_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Gwur God diki lo kalivanadiy duwawa Parasiy, mwiya kupwaraap tikina gwurak! Gwur viyuw tikala pik vitiy pasiranadiy duw-adiygwur! Gwur kupwawa guwaar yin yaan tibagwu-gwura duw nak sitakirakuw, di gwura bapaar wuladikik. Di Juw duw kitik tidik, gwur dikim kalivagwur, di Satan dikidi duw tikinaad. Dikidiy kupwarapa yawiy gwuradiy kupwarapa yawiyim ata kakil-kidadiy. ");
INSERT INTO mle_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Gwur adiy mil kwakinadiy duw nuwukadiy duwak yaab simaka-kwadana pik. Gwur nuwukadiy duw takwak kaliva-kwanadiygwurik, ‘Aw li day aban takakidana God dikidi wiy saam sikiykuw, jaaw a aban wapakwaad. Aw li day God dikidi wiyaam rinadiy gol jaav saam sikiykuw, day a aban mwiya mwiyab tilik, kwurkwadiy.’ ");
INSERT INTO mle_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“Gwur maa wak alik gwur maa laakw. Gwur alik jawjaay nuwukadiy duw takwak kaliva-kwanadiygwurik. Agwa jaav yitaypik tinaad? God dikidi wiy, ay? Dikidi wiyaam rinadiy gol adiy? Day God dikidi wiy watipidaad Godak. Alik ababa God dikidi wiyaam rinadiy jaav ab watipin tinadiy Godak. ");
INSERT INTO mle_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Gwur kaliva-kwanadiygwurik ab, ‘Aw li duw nak aban takakida God dikidi wiyaam tinadi kabaka jaab saam sikiykuw, jaaw a aban wapakwaad. Aw li di adi jabim rina Godak kwiydana jaav saam sikiykuw, a aban mwiya mwiyab tilik, kwurkwaad.’ ");
INSERT INTO mle_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Gwur maa wak alik gwur maa laakw. Gwur alik jawjaay nuwukadiy duw takwak kaliva-kwanadiygwurik. Agwa jaav yitaypik tinaad? God dikidi wiyaam tinadi kabaka jaab, ay? Adi jabim rina Godak kwiydana jaav? ");
INSERT INTO mle_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Day God dikidi wiyaam tinadi jaab watipidaad Godak. Alik ababa adi jabim rinadiy jaav ab watipin tinadiy Godak. Atawa tikuw, duw aban takakuw, God dikidi wiyaam tinadi kabaka jaab saam sikiykuw, di adi kabaka jabim rinadiy Godak kwiygwuradiy jaav ab saam sikiy-kinaad. ");
INSERT INTO mle_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Duw aban takakuw, God dikidi wiy saam sikiydik, di alim kwanadi God dikidi saam ab sikiy-kinaad. ");
INSERT INTO mle_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","“Aw li duw nak aban takakuw, adawul tip saam sikiykida, di alim tina God diki nima tikirwa a tikirim daan rinadi God biraki saam sikiy-kinaad.” ");
INSERT INTO mle_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Gwur God diki lo kalivanadiy duwawa Parasiy, mwiya kupwaraap tikina gwurak. Gwur viyuw tikala pik pasira-nadiygwurik. Gwuradiy miyawa javiwa ababa mayim sigwuradiy kikipatadiy, day mwiya kwasadiy tinadiy, day lawdaak, gwur am tabatiy sikuw, nak Godak kwiy-kwanadiygwurik. Atawa gwur yarakara kwurkuw, aw kidiy lo waam rinadiy jaav wukimar-gwuradiy: viyakita jaav duw takwak kwurin, mawul duw takwak wukin, mawul Godak wukijibir tan. Kidiy yitaypik tinadiy javik gwur maa wakwanadiygwur, nuwukadiy kwasadiy jaav kwurkwurik. Adiy kwasadiy jaav viyakit tinadiy. Aw gwur adiy yitaypik tinadiy jaav wukimar-tikwa. ");
INSERT INTO mle_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Gwur yarakara mwiya nimadi yawiy kwurkwanadiygwur, kidiy kwasadiy lo kwurkwurik. Aw gwur wukimar-gwura adiy yitaypik tinadiy lo waam dayaam kwurkwurik.” ");
INSERT INTO mle_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Gwur God diki lo kalivanadiy duwawa Parasiy, mwiya kupwaraap tikina gwurak! Gwur viyuw tikala pik pasira-nadiygwur! Gwur nimadi yawiy kwur-kwanadiygwurik nuwukadiy duw taakw vikuw, ‘Kidiy viyakita duw-adiy,’ wadakikik. Aw gwuradiy mawul viyakit maa, kupwaraap-adiy. Gwur gwuradiy sipak wukikuw, gwur nuwukadiy duw taakw dayadiy jaav luwkuw kwurin nuwukadiy kupwarapa yawiy kwur-kwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“Gwur Parasiy, gwur gwuradiy kwurgwuradiy yawiy dayadiy maw gwur maa laakw. Aw gwur taay gwuradiy mawul mwugiygwur viyakit tidaak, gwur ata viyakita yawiyadika kwur-kinadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Gwur God diki maaj kalivanadiy duwawa Parasiy, mwiya kupwaraap tikina gwurak! Gwur viyuw tikala pik vitiy pasira-nadiygwurik! Gwur kawamiy kitik tinadiygwurik. Apiy kawamiyaam day viyakita gilabadiy sawtakadadiy. Aw li apiy kawamiy duw taakw milaam viyakit titaay, yala kawamiy pwuk yaykinadiy duw taakw dayadiy amwiy rikwanadiy. ");
INSERT INTO mle_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","“Gwurabab atampik-adiygwurik. Adiy duw taakw dayadiy milaam viyakit tikwanadiygwurik. Aw gwuradiy mawul kupwaraap sapwurapa jaav kapwunadiy.” ");
INSERT INTO mle_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Gwur God diki lo kalivanadiy duwawa Parasiy, mwiya kupwaraap tikina gwurak! Gwur viyuw tikala pik vitiy pasira-nadiygwurik! Adiy God diki maaj wasapwiydiy duwawa nuwukadiy viyakita duw day tayir kiyadiy, gwur dayadiy kawamiy yarakara kwurkuw, gilabadiy sawtakagwur, tinadiy. ");
INSERT INTO mle_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","“Atawa kwurgwur, gwur wakwanadiygwurik, ‘Aw li nyan tayir nyanadiy warag kwadaal sikir kwakik-bana, nyan day God diki maaj wasapwiydiy duwaam viyasipadal pik akis kwurik-nadiyan.’ ");
INSERT INTO mle_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Gwur atawa wagwura, gwur adiy God diki maaj wasapwiydiy duwaam viyasipa-dadiy duw dayadiy warag-adiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","“Gwur gwuradiy waragaagw daya kupwarapa yawiy pik kwur-kwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Kabaay day adiy nimadiy kapwiy yiyak tabwu tabwu tamiyak vitaay, tabwu-kwanadiy. Aw samasam alim yiy yankwanadiy. Gwur adiy kabaay pik-adiygwurik yiy yanadi tipaam wap maa. ");
INSERT INTO mle_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Aw wun watuwadiygwurik ginyir wun God diki maaj wasapwiy-kinadiy duwawa lakwukinadiy duwawa kaliva-kwanadiy duwawa wayaki-kituwadiy gwurak. Gwur dayadiy kwukib kilbagwu-kigwuradiy niki tipaar niki tipaar. Nuwukadiy viyasipa-kigwuradiy. Nuwukadiy maap tinadiy miyaam katakigwuradiy. Nuwukadiy gwuradiy gaba maja wiyaam miyaar viyakigwuradiy. ");
INSERT INTO mle_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Gwur Yisrayil jaka tipa kidiy duw taakw atawa kwurkigwura, God kupwarapa jaav gwurak kwiykida. Mwiya tayir taay gwur adi viyakita duw Apil-aam viyasipakuw, nuwukadiy God diki maaj wasapwiydiy duwaam viyasipaan viyasipaan yin aw Barakaya dikidi nyan Sakaraya, di God dikidi nyidi wiyaam tidik, gwur dim viyasipa-gwurid. Gwur Yisrayil jaka tipa kidiy duw taakw atawa kwurgwur, God kupwarapa jaav gwurak kwiykida. ");
INSERT INTO mle_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Aw wun watuwadiygwurik God kupwaraapa jaav kwiykida kita kwanadiy duw takwak adiy ababa yidadiy valik.” ");
INSERT INTO mle_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas Jiruwsalim tipak kitay kitiy vikuw, ata waad, “O, Jiruwsalim tipa kidiy duw taakw, gwur bwutaay God diki maaj wasapwiydiy duw viyasipa-gwurdiy. God diki maaj karaydiy duw gwurak wayakidik, dayaam kabaak kwariyaki-gwurdiy viyasipak. Nyanyi wun gwurak amaay tapwuk likidiy nyanugwak likibir pipaar takatipitaay kwurin rikwala pik, atampik wun gwurak kwurik. Aw gwur maa wanadiygwurik wunak. ");
INSERT INTO mle_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","“Alik tikuw, God maa wanaad gwurak. Aw gwur kip kwakinadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","“Aw wun gwurak watuwadiygwurik gwur wunaam samab van ti maa. Aw ginyir gwur wakigwura, ‘Nyan God dikidi wayakididi duwak wayapiy sinadiyan,’ waan wakigwura nyi wun ata sibinin yakidiwun.” ");
INSERT INTO mle_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas God dikidi wiy wapaak tidik, dikidiy kalivadidiy duw dikik yadiy. Day God dikidi wiyaam tidiy wiy dikik simakak. ");
INSERT INTO mle_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jisas ata wadidiy, “Ayiy, kidiy wunak simaka-gwuradiy wiy, ginyir day kidiy wiy piradaak, adiy giliyim tinadiy kabaak yakisada-daak, kapakap kapakap tikidiy.” ");
INSERT INTO mle_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas Aliv wadadi nibwukim di dikida daan ridik, dikidiy kalivadidiy duw dim kap yin maak takadiy. Yikuw, day ata bas sidaad, “Nyanak aw, akasikir kidi jaav wakwu-kinaad? Nyanak aw agwa jaav taay wakwudik, nyan vikuw, lakwu-kibana min sibinin yakimina nyi walibab tilik, kidi kupw ata kwusikinaad?” ");
INSERT INTO mle_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisas dayak ata wadidiy, “Gwur yarakara ada nuwukadiy duw gwurak yaan gwiyip kwurik-nadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“Aw samasama duw yakuw, wunadi si kwurkuw, ‘Wun God dikidi Tasakwudidi Duw-adiwun’ wakuw, day dayak duw takwak samasam gwiyip kwurkidanadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Wariy walibab tidaak, dayadiy pipiliy wukikuw, yagaan kwurway. Sikaam tinadiy wariya maaj wukikuw, yagaan kwurway. Adiy jaav yaan maak takakinadiy. Aw ababa jaav kwusi-kidana nyi wayway nibway. ");
INSERT INTO mle_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Nikidi jaka tip yikuw, nikidi jaka tipawa wariya-kinadiy. Nikidi gavman yikuw, nikidi gavman awa wariyakinadiy. Kaam yasikiladiy nyi yakinadiy. Niki tip niki tipaam nanaaw yakinadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","“Aw kidiy jaav taakw liki taay yip kitik tikinadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Gwur wunadiy-adiygwurik. Alik ababa jaka tipa kidiy duw taakw day maa wakinadiy gwurak. Day gwuraam kalakwukuw, gwuraam jawjaay kwurkuw, ata viyasipa-kidanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","“A nyaam samasama duw taakw day bwan kwiykidiy wunak. Day nuwukadiy duw takwak mawul wartaay, viyasipakuw, dayadiy mama nib tabaam takakidanadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Ginyir samasama duw gwurak yakuw, suwaal takakinadiy, ‘Wun God diki maaj wasapwiynadi duw-adiwun,’ wataay wakidiy. Aw samasama duw taakw adiy duw dayadiy majik wukijibir tikinadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","“Satan mwugiydik, duw taakw samasam kupwaraap tidaak, dayadiy mawul nuwukadiy duw takwak yi maa. ");
INSERT INTO mle_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","“Sikadad bwan kway maarkinaad Godak yin diki kiyakida nyab, God adi duw nyigil-kidaad. ");
INSERT INTO mle_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Duw taakw kidi kupwaam rinadiy ababa tipaar yin yaan tibakwukuw, wuna viyakita maaj wasapwiykidana, ‘Kitawa God duw takwaam van tikinaad,’ waan. Ababa jaka tipa kidiy duw taakw ki maaj wukidaak, kidi kupw ata kwusikinaad.” ");
INSERT INTO mle_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ki maaj Jisas maa wadidiy, “Ginyir tip kupwaraap rikinadi jaav vikigwuraad. Adi jaav watipida God dikidi wiy tamiyaam tikinaad. Tayir God diki maaj wasapwiydi duw, Daniyil, ki javik waad.” Ki maaj vikuw, duw taakw ki jaav lakwu-kwadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“A nyaam Juwtiya tamiyaam kwakidiy duw taakw nibwukir tabwu-kwadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","“Duw aluwur maka kwaal wiyaam kwakuw, dadiba niki jaav niki jaav wulaan kwurik. ");
INSERT INTO mle_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","“Mayim kwakinadi duw di sibinin yidiba dikidi wapwiy kwurik. ");
INSERT INTO mle_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Yalawa tikidiy taakw, nyanugwak mwuny kwiy-kidiy takwawa, kupwiyayugw! Dayak wukinadiwun a nyaam. ");
INSERT INTO mle_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Gwur Godak bas as ki jaav yakik-na kwayugw ababa tamiy maripi-kidadiy nyaam ay Sapat nyaam. ");
INSERT INTO mle_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“A nyi mwiya kupwarapa nyi tikina. God yin takadil nyi ki kupw yaan aw kita atampik kupwarapa nyi maa ti. Ginyir ginyir atampik ti maa. ");
INSERT INTO mle_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Adiy nyi God bwutaay walib valubwu-didiy. Aw di atawa kwar maardik, duw nak kwa kwu maa. Di dikidiy tasakwu-didiy duw takwak wukididiy. Alik di walib valubwu-didiy adiy nyi. ");
INSERT INTO mle_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","“Li duw nak gwurak wakinaad, ‘Av! God dikidi Tasakwudidi Duw kilim kwanaad,’ aw li duw nak gwurak wakinaad, ‘Av! Alim kwakinaad,’ gwur wukiway. Adiy, ‘Wun God dikidi Tasakwudidi Duw-adiwun,’ adiy, ‘Wun God diki maaj wasapwiydi duw-adiwun,’ wakinadiy duw suwaal kwurik God dikidiy tasakwu-didiy duw takwak. Day God diki mawulaam rinadiy yawiy kitika yawiy kwurkinadiy a javik. ");
INSERT INTO mle_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Wun bwu watuwadiygwur taay ababa javik. Alik gwur yarakara awuk. ");
INSERT INTO mle_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Aw li duw taakw gwurak wakinadiy, ‘Gwur av! Di tamiyka tamiyaam kwanaad!’ gwur alir yitikwa. Aw li duw taakw gwurak wakinadiy, ‘Gwur av! Di ki yala wiyaam pakwun kwanaad!’ gwur daya majib wuki-tikwa. ");
INSERT INTO mle_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","“Aw duw taakw dayadi Mwaam di wulik kitik yakinaad. Ababa duw taakw dim vikidanaad. ");
INSERT INTO mle_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kiyanadiy jaav ridana tamiyaar gawiy adiy amwiy kikir dakwanadiy. Atampik kidi kupw kwusik tikida nyi wun God diki maaj kardadiy duwawa dakinadiwun.” ");
INSERT INTO mle_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ginyir adiy nyaam adiy mwiya kupwarapa nyi kwusidaak, nyi si maa, bap si maa. Tugwiy kwunigaar tubwaam tikuw, vakirkidiy. Ababa tubwaam tinadiy jaav yin yaan tikidiy. ");
INSERT INTO mle_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ababa tipa kidiy duw taakw day wunadi nimadi ap tubwaam vikuw, girakidiy. Day vikidanadiwun wun dayadi Mwaam. Wun tubwaar yakinadiwun mwiya nimadi apawa gilabadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","“Adawul tubwaam kwul puwdaak, wun wuna maaj kardadiy duw wayaki-kituwadiy ababa tipaar miyawa tamiyaam wunadiy tasakwu-tuwadiy duw taakw vagaruw-dakik.” ");
INSERT INTO mle_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Miy si vik di simaka-kidadiygwur ki javik. Ba miy kwany ridaak, lakwu-kinadiygwurik waal jakida nyi aka walibab tina. ");
INSERT INTO mle_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","“Kitampik gwur kidiy jaav vikuw, lakwukigwura duw taakw dayadi Mwaam yaan walibab tikinaad. ");
INSERT INTO mle_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Mwiya maaj watuwadiygwurik. Ki nyaam kwanadiy duw taakw kwas maa nibway, kidiy jaav wakwukuw, taay vikidanadiy. ");
INSERT INTO mle_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","“Adawul tubwawa kidi kupw kwusi-kinabir. Aw wuna maaj kwas maa.” ");
INSERT INTO mle_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Miyawa duw day maa laakw akasikir yakina nyi. Adawul tipaam kwanadiy maaj kardadiy duw dayabab maa laakw. God dikidi Nyan ab di maa laakw. Wunadi Asaay-dika lakwudaal a javik. ");
INSERT INTO mle_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Wun kidi kupwaar sibinin dakituwa nyi kidi kupwa kidiy duw taakw tayir Nawa kwadil nyi adiy duw taakw kwadaal pik atampik kwakidiy. ");
INSERT INTO mle_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","“Nimadi guw war maardik, ababa duw taakw kamnaagw kitaay, guw kitaay, duw takwaam kirataay, adiy jaav kwurbagwudiy yin Nawa dikidi nimadi jabira wiyaar wuladil nyab. ");
INSERT INTO mle_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","“Day atawa kwurdaak, dayadiy mawul adi guwak maa wak. Atawa kwadaak, nimadi guw warkuw, miyawa duw taakw maripidik, kiyadiy. Wun dakituwa nyi samasama duw taakw atampik tikidiy. ");
INSERT INTO mle_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Duw vitiy nakamwiyib mayim yawiy kwurkinabir. Aw wun yakuw, duw nak kwurkituwaad. Aw nikidi duw wapatuwik, kip kwakinaad. ");
INSERT INTO mle_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","“Taakw vitiy bir nakamwiyib kwaan sukwulik yikinabir. Aw wun yakuw, taakw nak kwurkituwaal. Aw niki taakw wapatuwik, kip kwakina. ");
INSERT INTO mle_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Gwur alik yarakara ada. Aw gwur maa laakw gwuradi Yitaypika Duw kidi kupwaar sibinin yakida nyi. ");
INSERT INTO mle_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Gwur yara awuk ki maaj. Aw li wiy asaay duw di adi luwkuw kwurkwanadi duw diki wiyaar yakida gaan di lakwukuw, a gaan kip van tikik-naad adi duwak diki wiyaar wulawulak. ");
INSERT INTO mle_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","“Atampik gwurabab nyanyi gwuradiy mawul kwulapwukuw, adakw. Aw gwur maa laakw wun kidi kupwaar sibinin yakituwa nyi.” ");
INSERT INTO mle_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Viyakita yawiy duw kitampika yawiy kwur-kwanaad dikidi sapakwa nyinik. Dikidi sapakwa nyan wadik, di nuwukadiy yawiy duwak van tikinaad. Di dayak yara van titaay, dayadiy kamnaagw kwiykwadadiy rabw sitaay. ");
INSERT INTO mle_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","“Adi yawiy duw atampik viyakita yawiy kwurdik, aw dikidi sapakwa nyan sibinin yakuw, di viyakita yawiy vikuw, adi yawiy duw rakarak tikinaad. ");
INSERT INTO mle_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","“Adi sapakwa nyan dikidi yawiy duwak ata wakinaad, ‘Aw min wuna sibinin yakituwa nyi min maa laakw. Aw wun kip yakuw, vituwa min viyakita yawiy kwurnadimin. Alik tikuw, min wunadiy ababa javik van tikiminadiy.’ ");
INSERT INTO mle_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","“Aw li adi yawiy duw kupwaraap tikida, di diki mawulaar wakida, ‘Wunadi yitaypika duw di sibinin yabiyib ya maa.’ Atawa wukikuw, di jawjaay kwurkinaad nuwukadiy yawiy duwak. Di duw tikwur-kwanadiy duwawa kwakuw, dayawa kamanagw kitaay, duw kwam yikwadiy guw kikinaad. ");
INSERT INTO mle_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","“Adi yawiy duw dikidi sapakwa nyan sibinin yakinaad nyi nak dikik. Aw adi yawiy duw di maa laakw a javik. ");
INSERT INTO mle_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","“Adi sapakwa nyan dikidi yawiy duw diki kupwarapa yawiy vikuw, di dikim mwiya nimadib viyakinaad. Viyaan napataka, di wayaki-kidaad kupwarapa tipaar. A tipaam di girataay, wuk vatikirikiy-taay, kwakinaad.” ");
INSERT INTO mle_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas dayak ata wadidiy, “Wuna sibinin dakituwa nyi kitawa tikina. Duw takwaam kirak tidil nyi niba taakw tabatiy dayadiy lam kwurkuw, day yidiy dikik kavin kwakir. ");
INSERT INTO mle_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","“Aw adiy taakw tabab day yarakara mawul maa wak. Aw adiy nuwukadiy taakw tabab day yarakara mawul wukidiy. ");
INSERT INTO mle_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","“Adiy yarakara mawul wukimardiy taakw day nuwukadiy lama guw dayawa ab maa karaay. ");
INSERT INTO mle_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","“Aw adiy yarakara mawul wukidiy taakw day nuwukadiy lama guw ab dayawa karaydadiy. ");
INSERT INTO mle_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Adi takwaam kirakida duw di yabiyib maa yay. Aw adiy niba taakw dayadiy mil rabwurabw nadidaak, day ata si kwadiy. ");
INSERT INTO mle_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nyidi gaan tilik, nuwukadiy duw taakw gaam sidiy, ‘Adi takwaam kirakida duw adaay yanaad. Gwur abab maay dikik yinaak.’ ");
INSERT INTO mle_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Adiy tabatiy niba taakw jawiyakuw, rasidiy. Rasikuw, day dayadiy lam wapataka-dadiy. ");
INSERT INTO mle_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Adiy yarakara mawul wukimardiy tababa taakw nuwukadiy yarakara mawul wukidiy takwak wadadiy, ‘Nyanadiy lam adiyka kiyan kiyan danadiy. Gwur nyanak kwasa lama guw akwutay.’ ");
INSERT INTO mle_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Adiy yarakara mawul wukidiy taakw ata wadadiy, ‘Aw li nyan gwurak lama guw kwatiya-kibana, gwurawa nyanaam mwiyir riv maa. Aw gwur stua ar maay. Yikuw, nuwukadiy ayapiy gwur gwurak.’ ");
INSERT INTO mle_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Aw adiy yarakara mawul wukimardiy niba taakw day stua ar yidiy lama guw yapiyik. Day yitaay tidaak, adi takwaam kirakida duw ata yaad. Yadik, adiy tababa niba taakw day kavin kwadiy dikik, day ata adi wiyaar diwa wuladiy bayaki kikipaat kidakikik. Yala wiyaar wuladaak, duw adi wiyig ata takatipidaad. ");
INSERT INTO mle_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ginyir adiy nuwukadiy niba taakw sibinin yakuw, ata gaam sidiy, ‘Sapakwa duw, sapakwa duw, min nyanak kidi wiyig asakw!’ ");
INSERT INTO mle_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Adi takwaam kirakida duw dayak ata wadidiy, ‘Wun gwuraam maa laakw.’” ");
INSERT INTO mle_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Gwur wuna sibinin dakituwa nyi gwur maa laakw. Alik gwur yarakara ada.” ");
INSERT INTO mle_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Wun sibinin dakuw, kitampik kwurkidiwun. Aw duw nak di sika tamiyaar yikir tikuw, dikidiy yawiy duwak wadik, yakuw, vagaluwdaak, di yawiy kwiydidiy kwurdakik. ");
INSERT INTO mle_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","“Di dayadiy mawul vikuw, dikidiy saan am sididiy. Nikidi duwak K5,000 kwiydidiy. Adi nikidi duwak K2,000 kwiydidiy. Adi nikidi duwak K1,000 kwiydidiy. Atawa dayak adiy saan kwiykuw, di ata yad sika tamiyaar. ");
INSERT INTO mle_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Saan kwiydidiy duw yidik, adi K5,000 kwurdi duw di adiy sanaar yawiy kwurkuw, nuwukadiy K5,000 kwurkuw, abab kwurjuwdil miyawa K10,000 ridiy dikim. ");
INSERT INTO mle_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","“Atampik adi K2,000 kwurdi duw di adiy sanaar yawiy kwurkuw, nuwukadiy K2,000 kwurkuw, abab kwurjuwdil miyawa K4,000 ridiy dikim. ");
INSERT INTO mle_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Aw li adi K1,000 kwurdi duw di kaw vakuw, adiy saan kawaam takakuw, kupw rimsuwdik, kwadiy. ");
INSERT INTO mle_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Bap samasam tikuw, dayadi sapakwa duw ata sibinin yaad. Yakuw, dikidiy yawiy duwak wadik, yakuw, vagaluwdiy. Aw di dikidiy sanak dayawa lakatiyik. ");
INSERT INTO mle_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Adi K5,000 kwurdi duw dikidi sapakwa duwak yakuw, wadid, ‘Sapakwa duw, min wunak K5,000 kwiyminidiy. Aw min av! Adiy sanaar yawiy kwurkuw, kwurtuwdiy nuwukadiy K5,000 kidiyka. Aw minadiy K10,000 kidiyka akwur.’ ");
INSERT INTO mle_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Dikidi sapakwa duw wukikuw, dikik ata wadid, ‘Min viyakita yawiy kwurnadimin. Min kwasa javik yarakara van tinadimin. Alik wun samasama jaav kwatiya-kituwadimin dayak van timinkikik. Min wunawa kwakuw, rakarak samasam tikimina.’ ");
INSERT INTO mle_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Adi K2,000 kwurdi duw dikidi sapakwa duwak yakuw, wadid, ‘Sapakwa duw, min wunak K2,000 kwiyminidiy. Aw min av! Adiy sanaar yawiy kwurkuw, kwurtuwdiy nuwukadiy K2,000 kidiyka. Aw minadiy K4,000 kidiyka akwur.’ ");
INSERT INTO mle_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Dikidi sapakwa duw wukikuw, dikik ata wadid, ‘Min viyakita yawiy kwurnadimin. Min kwasa javik yarakara van tinadimin. Alik wun samasama jaav kwatiya-kituwadimin dayak van timinkikik. Min wunawa kwakuw, rakarak samasam tikimina.’ ");
INSERT INTO mle_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","“Aw adi K1,000 kwurdi duw dikidi sapakwa duwak yakuw, wadid, ‘Wun bwutaay lakwutuwa min wasap wasap tikwanadi duw-adimin. Nuwukadiy duw taakw kadiy mayim sidaak, min mwiy kwur-kwaminadiy. Wun minak yagakuw, alik wun yikuw, adiy minadiy saan kawaam yipakwu-tuwdiy. Kidiyka nadiyka minadiy saan akwur.’ ");
INSERT INTO mle_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","“Adi dikidi sapakwa duw ata wadid, ‘Min kupwarapa sip sakwiy sakwiy yawiy tinadi duw-adimin! Min lakwumina wun nuwukadiy duw taakw mayim sikwadanadiy jaav kwur-kwanadiwun, ay? Min atawa lakwumina, agwa javik min wunadiy saan beng aam tak maarminil? Aw li min wunadiy saan beng aam takak-mina, aw kita nuwukadiy saan ab kwurik-tuwadiy.’ ");
INSERT INTO mle_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Adi sapakwa duw nikidi yawiy duwak ata wadid, ‘Wadiy K1,000 dikim kwurkuw, adi K10,000 kwurdi duwak akwiy.’ ");
INSERT INTO mle_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“‘Duw taakw day samasama jaav rikuw, ginyir nuwukadiy kwurkidanadiy. Mwiya samasam kwurkidanadiy. Aw adiy saal yinadiy duw taakw ginyir dayadiy kwasadiy jaav miyawa kwur-kituwadiy. ");
INSERT INTO mle_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“‘Gwur kidi kupwarapa yawiy duw kwurkuw, kawaar ayakisakw. Di gaan van tina tamiyaam kwataay, girataay, wuk vatikirikiytaay, kwakwaad.’” ");
INSERT INTO mle_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ginyir wun, duw taakw dayadi Mwaam, sibinin dakuw God dikidiy maaj kardadiy duwawa, wun miyawa duw taakw dayadi yitaypika duw tikinadiwun. Wun jas dayak tikidiwun. ");
INSERT INTO mle_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","“Abab kidi kupwa kidiy duw taakw wuna mwutamaam vagaluwdaak, wun kaja-kituwadiy. Kajakuw, bap vitiy tikinabir. Sipsip ak van tikwanadi duw sipsip awa meme kajakuw, sipsip nikidi bapaam, meme nikidi bapaam tibira pik, atampik adiy duw takwaam wun kajakuw, nuwukadiy wuna mava tabaam tikidiy. Nuwukadiy wuna akiy tabaam tikidiy. ");
INSERT INTO mle_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Dayaam kajakuw, wun adiy wuna mava tabaam tikinadiy duw takwak wakituwadiy, ‘Wunad Asaay di bwutaay viyakit kwurnaad gwurak. Aw gwur may. Di gwuradi tamiy bwutaay kwulapwudid gwurak. Di adi kupw yitakadil nyi adi tamiy tasakwudid gwur gwurak. ");
INSERT INTO mle_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","36","“‘Tayir wun kaam yasatuwkib, gwur kamnaagw wunak kwatiya-gwurdiwun. Wun guw kikir yasatuwkib, gwur guw wunak kwatiya-gwurdiwun. Wun kipa duw gwurak tituwkikib, gwur gwuradiy wiyaar karay-gwurdiwun. Aw wun kwusuw wapwiy ti maartuwkib, gwur kwusuw wapwiy kwatiya-gwurdiwun. Wun barik kwatuwkikib, gwur yataay wunak, van tidiygwurik. Wun kalabus im kwatuwkikib, gwur yataay wunak, vigwurdiwun.’ ");
INSERT INTO mle_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","39","“Adiy viyakita duw taakw wunak ata wakidanadiwun, ‘Yitaypika Duw, akasikir nyi nyan vibaak, min kamik tidimin? Timin, nyan kamnaagw kwatiya-badimin? Akasikir guw kikir timin, guw kwatiya-badimin? Akasikir min kipa duw kaytik timin, nyanadiy wiyaar karaybadimin? Akasikir min kwusuw wapwiy ti maarmin, kwatiya-badimin? Akasikir nyi min barik kwamin, ay kalabus im kwamin, yin jawbadimin?’ ");
INSERT INTO mle_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Wun dayak ata wakituwadiy, ‘Aw gwur kidiy jaav wunadiy gwalugwa duw takwak bwutaay kwurgwuridiy. Adiy dayak kwurgwuridiy jaav adiy wunak kwurna pik kwurgwuridiy.’ ");
INSERT INTO mle_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Aw wun adiy wuna akiy tabaam tikinadiy duw takwak wakituwadiy, ‘Gwur agwutak! God mwiyir maa wanaad gwurak! God nyanyi nyanyi yiy yanin tip kwulapwudid Satanawa dikidiy wudibak. Wunaam wapakuw, gwur adi tipaar maay! ");
INSERT INTO mle_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","43","“‘Tayir wun kamik tituwkikib, aw gwur wunak kikipaat maa kwatay. Wun guw kikir tituwkikib, aw gwur wunak guw maa kwatay. Wun kipa duw gwurak tituwkikib, aw gwur gwuradiy wiyaar wunaam maa karaay. Wun kwusuw wapwiy ti maartuwkib, aw gwur wunak kwusuw wapwiy maa kwatay. Wun barik kwatuwkikib, kalabus im kwatuwkikib, aw gwur akis wunak yin jawdiygwurik.’ ");
INSERT INTO mle_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Aw day wunak ata wakidanadiwun, ‘Yitaypika Duw, akasikir min kamik timin, guw kikir wamin, kipa duw kaytik timin, kwusuw wapwiy ti maarmin, barik kwamin, kalabus im kwamin, aw nyan minaam vikuw, minak sugwiyaan kwar maarbadimin?’ ");
INSERT INTO mle_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Aw wun dayak ata wakituwadiy, ‘Aw gwur kidiy jaav wunadiy gwalugwa duw takwak kwar maargwuril, aw aal gwur wunak sugwiyaan maa kwar.’ ");
INSERT INTO mle_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Alik tikuw, adiy kupwarapa duw taakw wun dayaam wayakikuw, day ata kupwaraap tikidiy nyanyi nyanyi. Aw adiy viyakita duw taakw wun dayak wakuw, day wunawa viyakit kwakidiy nyanyi nyanyi.” ");
INSERT INTO mle_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas kidiy maaj wakuw, dikidiy kalivadidiy duwak wadidiy, ");
INSERT INTO mle_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gwur lakwugwura nyi vitiy yakuw, nuwukadiy Juwawa nyan God Nyigirdidiy bayaki kikipaat kikibana. A nyaam, duw nak ata wunadiy mama nibak kwiy-kidadiwun day wunaam maap tinadi miyaam katadakik.” ");
INSERT INTO mle_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sapakwa nyanugw pris awa Juw dayadiy sapakwa nyanugw day vagaluwdiy Kayapas, Mwiya Yitaypika Pris diki wiyaam. ");
INSERT INTO mle_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Day maaj awarwa lakatiydiy, “Atatawa nyan pakwun yin Jisasaam kalakwukuw, viyasipa-kibanaad?” Ata wadiy. ");
INSERT INTO mle_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aw day wadiy, “Bayaki nyaam nyan atawa kwar maa, ababa duw taakw pitaan warik-nadiy.” ");
INSERT INTO mle_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas Jiruwsalim wapakuw, yikuw, adi tayir lepa tidi duw, Sayman, diki wiyaam kwaad Bitaniy tipaam. ");
INSERT INTO mle_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kikipaat kidik, taakw nak tukwul vaak yataan wulaal yala wiyaar. Adi tukwul vaak, yala vakaam, waliy guw tal. Saan samasam yapiy-kwadanaad. Li wulakuw, adi viyakita yaam yayda waliy guw Jisas abwaam kaykwatakalid. ");
INSERT INTO mle_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Jisas dikidiy kalivadidiy duw a jaav vikuw, mawul wardiy. Day nikim nikim bwuladiy, “Agwa javik tikuw, ki waliy guw kip yakila? Yawiyik ti wiy ata yapiy-kwadiy. Aad saan samasam yapiy-kwadanaad. Adiy saan saal yinadiy duwak kwiykwa.” ");
INSERT INTO mle_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas daya maaj lakwukuw, wadidiy, “Agwa javik tikuw, sapis jikigwura likik? Kal viyakita jaava wunak kwurla. ");
INSERT INTO mle_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","“Saal yinadiy duw nyanyi gwurawa kwakwanadiy. Aw wun gwurawa nyanyi kwu maa. ");
INSERT INTO mle_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","“Li waliy guw taay wunaam kaykwatakakuw, aw ginyir kawaam takakidanadiwun. A javik wunak kwurla. Wun kawamiyaam kwakituwalik wunaam kwulapwulaala. ");
INSERT INTO mle_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","“Mwiya maaj watuwadiygwurik. Ginyir God diki viyakita maaj kwiydaak ababa tipaam, day ki kwurla javik wakinadiy. Duw taakw wukimar maa likik.” ");
INSERT INTO mle_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Juwtas Yiskariyat, Jisas dikidiy tabatiy maan vitiya duw nak-ad, di sapakwa nyanugw pris ak yad. ");
INSERT INTO mle_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yikuw, wadidiy, “Aw wun Jisas gwurak kwatiya-kituwa, saan kwas kwiy-kigwuradiwun?” Aw day saan duwamiy nak sap tabatiy nasikuw, ata kwiydaad. (Nibwul adiy saan jilig tabatiy maan vitiy kitik). ");
INSERT INTO mle_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Juwtas Jisas dayak kwiy nyak ata kwaki-bagwud. ");
INSERT INTO mle_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Taay nyaam, Yis Maa Ti Bret bayaki kikipata nyaam, a nyi Jisas dikidiy kalivadidiy duw dikik bas sidaad, “Akim nyan yikuw, mina bayaki kikipaat kwulapwu-kinadiyan kiminkikik?” ");
INSERT INTO mle_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jisas ata wadidiy, “Nimadi tip Jiruwsalimaar yikuw, gwur duw nikik aw, ‘Kalivadidiy duw wanaad, Wuna nyi aka walibab tina. Wun wunadiy kaliva-tuwadiy duwawa God Nyigirdidiy Nyi bayaki kikipaat kikir mina wiyaam.’” ");
INSERT INTO mle_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jisas dikidiy kalivadidiy duw atawa kwurdaak, God Nyigirdidiy Nyi bayaki kikipaat ata kwulapwu-daad. ");
INSERT INTO mle_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Giraab kwusilik, Jisas dikidiy tabatiy maan vitiy duwawa daan ridiy bayaki kikipaat kikir. ");
INSERT INTO mle_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kikipaat kaan ridaak, Jisas ata wadidiy, “Mwiya maaj watuwadiygwurik. Gwura duw nak ginyir wunadiy mama nibak kwiykidadiwun.” ");
INSERT INTO mle_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dikidiy kalivadidiy duw pitaan warkuw, nakanak Jisasak bas sidaad, “Yitaypika Duw, wunak wanadimin?” wataay, wadaad. ");
INSERT INTO mle_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisas ata wadidiy, “Adi duw wunawa bret marir bwutaay kwusin daanda. Di wunadiy mama nibak dayadiy tabaam kwiykidadiwun. ");
INSERT INTO mle_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","“Wun, duw taakw dayadi Mwaam, kiyakinadiwun, tayir God diki lapa nyig walil pik. Aw duw taakw dayadi Mwaam mama nibak kwiy-kinadi duw kupwarapa jaav dikim warkidanaad. Li tayir amaay kidi duw sapwiy maarlik, aal viyakita dikik.” ");
INSERT INTO mle_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Juwtas ata waad, “Kalivanadi duw, min wunak wanadimin?” Jisas ata, “Ayiy,” wadid. ");
INSERT INTO mle_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Day kikipaat kidaak, Jisas bret kwurkuw, Godak wayapiy sidid. Jisas a bret kaysukwa-sukwakuw, dikidiy kalivadidiy duwak ata kwiydidiy. Di wadidiy, “Akwur. Kal wuna amwiya.” ");
INSERT INTO mle_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Jisas adakap ata kwurkuw, Godak wayapiy sidid. A adakap dayak kwiydik, di ata wadidiy, “Gwur abab ak. Kad wunadi nyikiy-ad. Kidi nyikiy ababa duw takwak simakadadiy God diki aban mwiya maaja. Samasama duw takwak wunadi nyikiy wakwu-kinaad God dayadiy vaal yibwiydikik. ");
INSERT INTO mle_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","“Wun gwurak waaw. Nuwuka wain wun gwurawa ki maa. Aw ginyir God diki van tidi tamiyaam nuwuk wain gwurawa kikidiwun.” ");
INSERT INTO mle_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Song nak tikuw, wiy wapakuw, day ata Aliv abwaar wardiy. ");
INSERT INTO mle_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas dikidiy kalivadidiy duwak ata waad, “Ki gaan gwur abab wunaam wapakuw, tabwu-kinadiygwur. God diki lapa nyig ata wana, ‘God sipsip van tinadiy duwaam viyadik, kiyakinaad. Kiyadik, sipsip kapakap kapakap tabwu-kinadiy.’ ");
INSERT INTO mle_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“God wunaam kirapitakadik, tayib yikinadiwun Galiliyaar gwurak.” ");
INSERT INTO mle_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita Jisasak ata wadid, “Li nuwukadiy tabwun wapakidadimin, wun minaam wap maa.” ");
INSERT INTO mle_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Aw Jisas dikik ata waad, “Pita, min awuk! Ki gaan tapwuk wadik, tayir wakidimin jaab mugwul, ‘Wun Jisasaam maa laakw’ wakuw.” ");
INSERT INTO mle_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita Jisasak maaj nimadib wadid, “Li wun minawa kiyakinadiwun ab, aw wun, ‘Jisasaam maa laakw,’ wu maa.” Dikidiy kalivadidiy duw day abab atawa wadiy. ");
INSERT INTO mle_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Day yidadi tamiy si Gitsimaniy alir yidaak, Jisas dikidiy kalivadidiy duwak ata wadidiy, “Kilim kavin ada. Wun Godawa maaj bwulak yikidiwun.” ");
INSERT INTO mle_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jisas Pitawa Sipatiy dikibir nyidiy kwurin karaydidiy. Di ata pitaan warkuw, samasam wukid di dikik. ");
INSERT INTO mle_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Di dayak ata wadidiy, “Wun wunak samasam wukinadiwun. Wukikuw, alik kiyak tinadiwun. Gwur kilim van ada wunawa.” ");
INSERT INTO mle_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Di kwasa yikuw, kupwaam vakirid Godawa maaj bwulaak. Vakirkuw, Godak bas sidid, “Asaay, wunadi Asaay, ababa jaav kwur-kwaminadiy. Aw kidiy wunak yakinadiy kupwarapa javadiy kwurin ayak. Aw wuna mawul maa, min mina mawul.” ");
INSERT INTO mle_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jisas yakuw, vididiy dikidiy kalivadidiy duw mugwul day si kwadiy. Dayak wajawiyakuw, Pitaak wadid, “Gwur ri maarin kwasa mwiya pik van titak? ");
INSERT INTO mle_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“Gwur van tan Godak maaj aw gwuraam vaal kakilik-na. Gwuradiy mawul yaakiya viyakita jaav kwurik, aw gwuradiy amwiy ap maa ti.” ");
INSERT INTO mle_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jaab vitiy warlik, Jisas maa ata yad Godak maaj bwulak. Di ata waad, “Wunadi Asaay, li kidiy wunak yakinadiy kupwarapa jaav wunaam wapaan yi maarkidana, a jaaw, yaakiya, kwurkituwadiy.” ");
INSERT INTO mle_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jisas dikidiy kalivadidiy duwak sibinin yakuw, vididiy si kwadaak. Dayadiy mil dibirin dibirin dadiy. ");
INSERT INTO mle_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jaab mugwul Jisas dayaam wapakuw, kwasa yikuw, Godak maaj wadid tayir wadidiy pik. ");
INSERT INTO mle_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jisas dikidiy kalivadidiy duwak sibinin yakuw, dayak wajawiyakuw, wadidiy, “Gwur si kwanadiygwur nibway? Ay yaakiya. Nyi aka walibab tina. Awuk! Duw nak yaan duw taakw dayadi Mwaam takakidaad vaal yinadiy duw daya tabaam. ");
INSERT INTO mle_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","“Gwur araap. Yinaak. Adi duw adi walibab tinaad.” ");
INSERT INTO mle_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wadik, Juwtas, Jisas dikidiy tabatiy maan vitiya duw nakad, dayak yaad. Juwtas wukin duw samasam yadiy. Wariya jaav kwurin kariyadadiy. Sapakwa nyanugw pris awa Juw dayadiy sapakwa nyanugw day wayakidaak, yadiy. ");
INSERT INTO mle_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jisasaam dayak kwiydi duw tayir wadidiy, “Mwutaam jipwu-kituwadi duw, adi duw gwur kwurik. Mwutaam jipwu-kituwadi duw adaanada ata akalakw.” ");
INSERT INTO mle_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Juwtas yadik, Jisasak yakuw, wadid, “Sapakwa duw, kupwiyaay.” Wakuw, mwutaam ata jipwudid. ");
INSERT INTO mle_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisas Juwtasak ata wadid, “Kapa duw, ki yawiyik yaminaala akwur.” Wakuw wadik, nuwukadiy duw yakuw, Jisasaam kaykitikuw, kalakwu-daad. ");
INSERT INTO mle_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jisasawa tidi duw wariya bag kaykitikuw, yitaypika pris dikidi yawiy duw diki waan viyalupwadil. ");
INSERT INTO mle_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisas ata wadid, “Wada minadi wariya bag kwusadamin diki tamiyab kwakwaad. Adiy wariya bagaar wariya-kwanadiy duw atampik wariya bagaar nuwukadiy duw dayaam viyadaak kiya-kinadiy. ");
INSERT INTO mle_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","“Min maa laakw wunadi Asayik bas sikuw, di yabiyib dikidiy samasama maaj kardadiy duw wayaki-kidadiy day wunak sugwiyaan kwurdakik? ");
INSERT INTO mle_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","“Aw ata ata God diki lapa nyigaam rina maaj maykaar wakwukina? Li wana day kidiy jaav kwurkidanadiy wakuw.” ");
INSERT INTO mle_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Vagaluwdiy duwak Jisas ata bas sididiy, “Wun jaal dayikwada duw-adiwun, gwur wariya jaav bag kwurkuw, wunaam kalakwuk yagwura? Nyi samasam God dikid wiyaam daan rituwdiy duw takwak kalivaan. Aw gwur wunaam maa kalakw. ");
INSERT INTO mle_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","“Wadiy wunaam kwur-gwuradiy jaav tayir God diki maaj wasapwiydiy duw God diki lapa nyigaam sukwudil maaj aka maykaar wakwuna.” Aw Jisas dikidiy kalivadidiy duw Jisas diki maaj wukikuw, dim wapakuw, day abab tabwudiy. ");
INSERT INTO mle_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Adiy Jisasaam kalakwudiy duw day Jisasaam kwurin karaydaad Mwiya Yitaypika Pris, Kayapas, diki wiyaar. Alim God diki lo kalivadiy duwawa Juw dayadiy sapakwa nyanugw vagaluwdiy. ");
INSERT INTO mle_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jisasawa nuwukadiy duw day taay yidaak, Pita kwasa kwukil yikuw, Mwiya Yitaypika Pris diki wiya yaripaar ata yad. Yala yaripaar wulakuw, Pita van tidiy duwawa daan rad. Di vikir agwa jaav day Jisasaam kwurkidanaad. ");
INSERT INTO mle_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sapakwa nyanugw pris awa ababa kaunsil duw day wukik nuwukadiy duw suwaal maaj wadiy Jisasak. Wukikuw, day ata, “Di kiyakwaad,” wakir a majik. Alik kavidiy. ");
INSERT INTO mle_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Duw samasam suwaal takadiy Jisasak aw day atampika maaj wawak maa rav. Duw vitiy ata yin wabir, “Kidi duw waad, ‘God dikidi wiy miyawa pira-kituwaad. Nyi vitiy yilik, wiy kwurkituwaad maa.’” ");
INSERT INTO mle_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mwiya Yitaypika Pris rapikuw, Jisasak bas sidid, “Kidiy duw minak sukwupirkuw wadana, aw min maaj maa ti?” ");
INSERT INTO mle_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aw Jisas kaygan tad. Maaj maa bwul. Adi Mwiya Yitaypika Pris ata Jisasak wadid maa, “Adawul nimadi God dikidi saam nyanak aw, min God dikidi Tasakwudidi Duw-adimin? God dikidi Nyan-adimin?” ");
INSERT INTO mle_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas ata wadid, “Ayiy, wamina maja pik. Aw wun minak waaw, ginyir gwur abab duw taakw dayadi Mwaam vikigwuraad, di ap samasam tinadi God diki mava tabaam mwiya yitaypika duw tamiyaam ridik. Gwur ata vikigwuraad, di adawul tubwaar yadik.” ");
INSERT INTO mle_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A maaj wukikuw, Mwiya Yitaypika Pris yaal samasam girakuw, di dikidi wapwiy kaypirikiykuw, nimadib ata wadidiy, “Di Godak wajibaynaad! Nyan niki maaj wukik maa. Gwur diki sapis jikidi maaj Godak bwu wukigwura. ");
INSERT INTO mle_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","“Gwur agwa jaav kwurik dikim?” Day abab maa wakuw dikik, alik, “Kiyakwaad” wakuw, wadiy. ");
INSERT INTO mle_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Adiy duw ata Jisas mwutamaam likasip satakaan taab kaygipwun viyaan kwurdaad. Aw nuwukadiy yala tabaar viyadaad. ");
INSERT INTO mle_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Adiy Jisasaam viyadiy duw ata bas sidaad, “Min God dikidi Tasakwudidi Duw-adimin. God minak ap bwu kwiydil miyawa jaav lakwu-minakik, ay? Alik tikuw, nyanak aw. Sikanadaad minaam viyanaad?” ");
INSERT INTO mle_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A nyi Pita kawaam mala wiyaam kwadik, Mwiya Yitaypika Pris diki yawiy kwurla taakw dikik yakuw, ata walid, “Minabab Jisas Galiliy tamiy kidawa kwadimin.” ");
INSERT INTO mle_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Li ata walik, di daya mwutamaam maa waad. Di ata waad, “Wun maa laakw wa wanyina maaj.” ");
INSERT INTO mle_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pita, yala yaripa wiyigaam wulakuw ridik, niki yawiy taakw dim vikuw, walibab tidiy duwak walidiy, “Kidi duw, di Jisas Nasarit tipa kidawa tikwanaad.” ");
INSERT INTO mle_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita ki majib maa wakuw, nimadib wadidiy, “Mwiya maaj watuwadiygwurik, wun kidi duw maa laakw.” ");
INSERT INTO mle_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kwasa rikuw, walibab tidiy duw Pitaak yakuw, wadaad, “Min Jisas dikidiy duw nak min-adimin. Nyan wa bwulamina bwula majib lakwu-banadimin. Min Galiliy tamiya kid-adimin.” ");
INSERT INTO mle_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pita ata kupwarapa maaj wakuw, wadidiy, “Wuna maaj mwiyir ti maarlik, God wunaam viyakwaad. Wun gwur wadi duw wun maa laakw.” Ata wadik, tapwuk ata waad. ");
INSERT INTO mle_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pita, Jisas tayir wadil maaj wukidil, “Tapwuk wadik, taay min jaab mugwul wakimina, ‘Wun Jisas maa laakw.’” Wukikuw, kawaar wakwukuw, Pita ata nimadib giraad. ");
INSERT INTO mle_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","2","Ganib tilik, ababa sapakwa nyanugw pris awa Juw dayadiy sapakwa nyanugw Jisasaam yaav jikuw, kwurin karaydaad Rom dayadi sapakwa duw, Paylatak. ");
INSERT INTO mle_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Juwtas, di Jisasaam dikidiy mama nibak kwiydidi duw, vidik, Jisasaam viyasipaak, aban takadaak, di samasam wukikuw, dikidiy kwurdidiy saan duwamiy nak sap tabatiy sibinin karaydidiy adiy sapakwa nyanugw pris awa Juw dayadiy sapakwa nyanugwak. ");
INSERT INTO mle_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Juwtas dayak wadidiy, “Wun Jisasaam kipakip gwurak kwatiya-tuwaad. Di simsim vaal maa ti. Alik vaal yidiwun.” Day wadiy, “Aal mina yawiya, nyana yawiy maa.” ");
INSERT INTO mle_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Juwtas adiy saan God dikidi wiyaar yakisawulakuw, di yikuw, yaav kwaliyapaam silikiykuw, bwutaay kiyaad. ");
INSERT INTO mle_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Adiy sapakwa nyanugw pris adiy saan kwurkuw, wadiy, “Kidiy sanaar duw yapiy-banaad kiyadikik. Alik kidiy saan God diki yawiyik kwar maa.” ");
INSERT INTO mle_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Maaj lakatiykuw, adiy saan kwurkuw, kupwa vaak kwurda duw diki kupw yapiydaal, nuwukadiy jaka tipa kidiy duw taakw daya kawamiy tilikikik. ");
INSERT INTO mle_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aw alik, “Nyikiy kupw,” wakwadana ki nyaar ab. ");
INSERT INTO mle_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jirimaya, God diki maaj wasapwiydi duw, ki God diki lapa nyigaam sukwudil maaj ata mwiya mwiyab tal. Kitawa sukwudil, “Adiy saan duwamiy nak sap tabatiy kwurdadiy. Yisrayil jaka tipa kidiy duw duwaam yapiyik tasakwudadiy saan-adiy. ");
INSERT INTO mle_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Day kupwa vaak kwurda duw diki kupw yapiydaal. Yitaypika Duw God wunak atawa wadidiwun kwurtuwkik.” ");
INSERT INTO mle_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas ata Rom dayadi taay maaj lakwudi gavman duw, Paylat, diki mwutamaam tad. Paylat Jisasak bas sidid, “Min Juw dayadi sapakwa nyan-adimin?” Jisas ata wadid, “Ayiy, wamina maja pik.” ");
INSERT INTO mle_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Adiy sapakwa nyanugw pris awa Juw dayadiy sapakwa nyanugw day maa wakuw Jisasak, alik sukwupir maaj kwiydaal Paylatak dikik. Aw Jisas dayadiy wadadiy jaav maa kwar. Aw di maaj maa wu adiy javik. Kip kaygan tad. ");
INSERT INTO mle_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Paylat Jisasak ata bas sidid, “Min awuk! Day samasama maaj sukwupirkuw, minak wanadiy. Min maaj maa?” ");
INSERT INTO mle_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jisas niki maaj maa wu. Alik Paylat diki mawul nikim nikim tal. ");
INSERT INTO mle_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ababa God Wapadidiy Nyi bayaki kikipata nyaam, Paylat kalabus im kwadi duw nak wapadid. Sikadad vagaluwdiy duw taakw bas sidadiy dikik, di ata wapadid dayak. ");
INSERT INTO mle_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Adi nabiy duw nak, dikidi si Barapas, kalabus im kwaad. Ababa duw taakw dikim lakwiyaki-daad. ");
INSERT INTO mle_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Duw taakw samasam vagaluwdaak, Paylat ata bas sididiy, “Sikadi duw gwurak kwatiyaaw? Barapas wapa-kituwaad, ay?” Jisas, adi wadanadi God dikidi Tasakwudidi Duw-ad wapa-kituwaad, ay? ");
INSERT INTO mle_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paylat wukidil sapakwa nyanugw pris awa Juw dayadiy sapakwa nyanugw dayadiy mawul kuwkuw nadaak Jisasak, day Jisas kwiydaad dikik. ");
INSERT INTO mle_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paylat kot aam kwadik, diki taakw ki maaj kwiylil dikik, “Wadi viyakita duwaam kupwarapa jaav dikim kwur-tikwa. Wun gaan dikik yigin vilwun. A yiginik samasam wukinawun.” ");
INSERT INTO mle_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Adiy sapakwa nyanugw pris awa Juw dayadiy sapakwa nyanugw vagaluwdiy duw takwak nimadib wadiy, day Paylatak bas sidakikik Barapasaam wapadikik dayak aw Jisasaam viyasipa-dikik. ");
INSERT INTO mle_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aw Paylat dayak bas sididiy maa, “Kibir duwaam, sikadaad gwurak kwatiya-kituwaad?” Aw day wadiy, “Barapas nyanak akwutay.” ");
INSERT INTO mle_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Agwa jaav kwurkinadiwun kidi wadanadi God dikidi Tasakwudidi Duw Jisasak?” Paylat ata bas sididiy. Day abab gaam sidiy, “Maap tinadi miyaam dim akat!” ");
INSERT INTO mle_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Paylat dayak ata bas sad, “Agwa kupwarapa jaav kwurdil?” Day mwiya nimadib gaam sidiy, “Maap tinadi miyaam dim akat!” ");
INSERT INTO mle_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Paylat dayadiy mawulaam warapiy warapiy maa rav vidil, aw dayadiy mawul wariyak mawul warin tidiy. Diki taab jankuw dayadiy mwutamaam, ata wadidiy, “Wun wunabir taab abira jantuwabir. Alik gwur vikuw, wukikigwura Jisas kiyakida vaal wuna yawiy maa. Aal gwura yawiya.” ");
INSERT INTO mle_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","26","Adiy vagaluwdiy duw taakw dikik ata wataykuw, wadaad, “Wa kiyakida vaal nyanadiy nyanugwawa nyanak yakwa.” Paylat Barapasaam wapadik dayak, di Jisas vay sawdiy duwak kwiydid ramiy tidi miyaar taay viyadakik aw ginyir maap tidi miyaam katadaad. ");
INSERT INTO mle_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Paylat dikidiy vay sawdiy duw day Jisas taay maaj lakwudi gavman duw dikid wiya yaripaar kwurin kawuladaad. Wulakuw, day gaam sidiy nuwukadiy vay sawdiy duwak day yadakikik dayak. ");
INSERT INTO mle_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","29","Day alataab kwurik Jisasaam. Alik taay kwusuwin tididiy wapwiy kaypwutiydaak, day yitaypika duw nyikiy nyikiy wapwiy kitika wapwiy rabwutaka-daad. Atawa day yitaypika duw abwa wawiy pik kwurkuw, diki abwaam kititakadaal. Aw a abwa wawiy ramiy til abwa wawiyim. Miy nak diki mava tabaam takadaal. Alataab kwurin kwatiyir sikuw dikik, day ata wadaad, “Juw dayad yitaypika duw, nabiy samasam kwakinadimin.” ");
INSERT INTO mle_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ata wakuw, diki sipaam likasip satakaan, adi miy kwurkuw, diki abwaam viyadaad. ");
INSERT INTO mle_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Taay apaapap kwurin naykuw, day nyikiy nyikiy wapwiy kaylapwiykuw, di diki wapwiy alib dim rabwutaka-daad. Day Jisas ata kwurin karaydaad maap tidi miyaam katadakik. ");
INSERT INTO mle_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kawaar yidaak, duw nak Sayman, Sayriniy tipa kid, vidaad. Vay sawdiy duw wadaak, Sayman di Jisas dikidi maap tidi miy yatadid. ");
INSERT INTO mle_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Day Jisas kwurkuw, tip si Juw daya kapa tipa majir Galgata, adi tipaar wakwudiy. Tip si maw maaj duw adakap kitika tamiya. ");
INSERT INTO mle_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Alim day wain awa nyigiy yina marasin biraay kitik kwiyik kidikikik dikim yil kagilik. Aw Jisas viyik kikitaan vikuw, kwasik yad. ");
INSERT INTO mle_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Day Jisas maap tidi miyaam ata katadaad. Katakuw, dikidiy wapwiy am sidadiy day dayadiy. Day jib kwadiy kwasadiy kabaak yakitaay tayaan, naydiy adiy wapwiy kwurik. ");
INSERT INTO mle_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Atawa kwurkuw, day daan rikuw, dikik van tidiy. ");
INSERT INTO mle_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jisas apiy abwawa maaj sukwupirkuw dikik sukwudaal, “JUW DAYADI YITAYPIKA DUWAD.” ");
INSERT INTO mle_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Luwkuw kwurin duw viyaan kwurbir duw day maap tibir miyaam katadabir Jisasawa, nak diki mava tabaam, nak diki akiy tabaam. ");
INSERT INTO mle_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Walibab tiytiyan tidiy duw Jisasak abwugar nayin wajibayin kwurdiy, “A! Min God dikidi wiy pirakanadi duw-adimin! Pirakakuw, nyi mugwul yidaak, kitampika wiy kwurkimina! Li, ‘Wun God dikidi Nyan-adiwun,’ wamina, yaakiya min mina kap kwurkuw, maap tinadi miy wapakuw, adiyid!” ");
INSERT INTO mle_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","43","Atawa sapakwa nyanugw pris awa God diki lo kalivadiy duwawa adiy Juw dayadiy sapakwa nyanugwawa day wadiy, “Di nuwukadiy duw taakw sugwiyaan kwurkwada. Aw di dikik maa rav. Li kidi duw Yisrayil dayadi Yitaypika Duw tida, aka maap tinadi miy wapakuw, dadik, aw nyan vikuw, dikik wukijibiran tikinadiyan. Di Godak wukijibir, God dikidi Nyan-ad wakuw, yaakiya, nyan vinaak God dim nyigil-kidaad ay maa.” ");
INSERT INTO mle_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Abir Jisasawa maap tibir miyaam katadabir duw ab wajibaybir Jisasak. ");
INSERT INTO mle_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nyidi nyi tidik, yin nyi tikitakiy-dik, miyawa tamiy gaan kitik tad. ");
INSERT INTO mle_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nyi tikitakiy-dik, Jisas di diki kapa tipa majir nimadib gaam sad, “Yilay, Yilay, lama sapaktaniy?” Ki maaj maw maaj, “Wunadi God, wunadi God, agwak min wunaam wapamina?” ");
INSERT INTO mle_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nuwukadiy walibab tidiy duw ata wadiy, “Awuk! Kidi duw God diki maaj wasapwiydi duw, Yilayjaak gaam sinaad.” ");
INSERT INTO mle_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Duw nak gipakuw, nyigiy yila wain diyuwim takadik, yavim takakuw, kwiydil Jisas kidikikik. ");
INSERT INTO mle_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aw nuwukadiy wadiy, “Ataada! Nyan vinaak God dikidi tayir kidi kupwaam kwadi maaj wasapwiydi duw Yilayja yakuw, di Jisas kwurin karda-kidaad, ay maa.” ");
INSERT INTO mle_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas nimadib gaam sikuw, ata kiyaad. ");
INSERT INTO mle_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nimadi wapwiy God dikidi wiyaam nyidi wiyaam mwiya kapaba tamiy takatipin tad. Tipa takaan aluwurib ap vitiy pirakiykuw, aluwurib daad. God atawa kwurdil miyawa duw takwak simakak day jaaw dikik yikwadiy. Nimadi nanaaw yakuw, kupw miyawa nayakitaay tayidik, kabaak wutatadiy. ");
INSERT INTO mle_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A nyi nuwukadiy kawamiy wutatadaak, God adiy kawamiyaam ridiy duw taakw day God dikidiy-adiy kirapitaka-didiy. ");
INSERT INTO mle_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Day adiy kawamiy wapakuw, yidaak, ginyir God Jisasaam kirapitakakuw, day Jiruwsalimaar yidiy. Alim duw taakw samasam vidadiy. ");
INSERT INTO mle_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Vay sawdiy duw duwamiy tabab dayak van tidi duw nuwukadiy vay sawdiy duwawa day Jisasak van tidiy adi nanaaw vikuw nuwukadiy javiwa, day pitaan samasam wardiy. Pitaan warkuw, ata wadiy, “Kidi duw God dikid mwiya duwa nyanad.” ");
INSERT INTO mle_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Samasama v 52 A nyi nuwukadiy kawamiy wuttaakw kwasa sikaam tan vidiy. Maria Maktala tipa kil, Maria Jamisawa Jawsis biraki amaay, Sipatiy dikibir nyidiy biraki amaay, adiy taakw dayawa tidiy. Tayir Jisas Galiliy wapakuw, day diki kwukib yadiy sugwiyaan kwurik dikik. ");
INSERT INTO mle_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Giraab tidik, Jawsip, Aramatiya tipa kid yad. Di saan samasam tidi duw-ad. Dibab Jisas dikidiy kalivadidiy duw nak-ad. ");
INSERT INTO mle_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Di Paylatak wulaan walibab tad Jisas amwiyik bas sikir. Paylat ata wadidiy, “Jisas diki amwiy Jawsipak akwiy.” ");
INSERT INTO mle_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aw Jawsip Jisas diki amwiy kwurkuw, rabwutakadil viyakita wamakawam wapwiyir. ");
INSERT INTO mle_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Rabwutakakuw, Jawsip Jisas diki amwiy di diki vadil kwula dipwu kabakim takadil. Di nima kabaak timilyikuw, ata dipwu kabaak diki daap tipin takadil. ");
INSERT INTO mle_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria, Maktala tipa kilwa niki Maria walibab daan rikuw, a jaav vibiril. ");
INSERT INTO mle_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","God Wapadidiy bayaki kikipaat kwulapwu-dana nyi tilik, sira pik, adiy sapakwa nyanugw pris awa Parasiy bapa duw day Paylatawa vagaluwkuw, wadaad, “Sapakwa duw, nyan wukibana adi suwaal takadidi duw Jisas, kidi kupwaam kwadik waad, ‘Wun kiyakuw, nyi mugwul yidaak, God wunaam kirapitaka-kidadiwun.’ ");
INSERT INTO mle_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","“Min maaj akwiy kidiy vay sawdiy duwak adi dipwu kabakim van tidakikik nyi mugwul. Aw adiy dikidiy kalivadidiy duw yakuw, dikidi amwiy luwkuw kwurkuw, yin tipa duw takwak suwaal takakuw, wakik-nadiy, ‘Jisasaam God bwutaay kirapitaka-daad.’ Jisas takadil suwaal, ‘God wunaam kirapitaka-kidadiwun,’ aal kupwaraapa. Aw li Jisas dikidiy kalivadidiy duw Jisas dikidi amwiy luwkuw kwurkuw, wakidana, ‘God Jisasaam bwutaay kirapitaka-daad,’ aal mwiya kupwaraap tikina.” ");
INSERT INTO mle_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paylat ata wadidiy, “Gwur gwuradiy vay sawdiy duw kwurkuw, yin adi dipwu kabakim gwur gwura van ada.” ");
INSERT INTO mle_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aw day yikuw, adi dipwu kabakim takatipikuw, ata vay sawdiy duw takadadiy van tidakikik. ");
INSERT INTO mle_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sapat nyi kwusilik, Saday ganiba gaan tilik, Maria Maktala tipa kilwa niki Mariawa, bir Jisas dikidi kawamiyaar ata yibir vikir. ");
INSERT INTO mle_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bir yibir nimadi nanaaw ata yaad. Yadik, God dikidi maaj kardadi duw adawul tip wapakuw, daad. Dakuw, adi dipwu kabakim takatipidaal nima kabaak ata vatimil sakiykuw, daan rad apiy kabakim. ");
INSERT INTO mle_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Dikidi maak wuliyik kaytik tad. Kwusuw-didiy wapwiy mwiya wamakawam sawun kaytik tidiy. ");
INSERT INTO mle_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Alim tidiy vay sawdiy duw a jaav vikuw, samasam yagakuw, gingin nakuw, vakirkuw, kiyadiy duw kaytik ridiy. ");
INSERT INTO mle_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Adi God diki maaj kardadi duw, abir takwak wadibir, “Bir yaga-tikwa. Wun bwutaay lakwutuwa bir maap tidi miyaam katadadi duw Jisasak kwaki-nabirbirik. ");
INSERT INTO mle_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","“Di kilim maa kwu. Bwutaay rapid gwurak tayir wadil maja pik. Bir may kiril. Av! Kwadil tamiy kika. ");
INSERT INTO mle_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“Yaakiya, bir yabiyib maay. Ki maaj aw dikidiy kalivadidiy duwak, ‘Jisas kiyakuw ridik, bwutaay rasinaad. Di taay gwurak Galiliyaar yikinaad. Alim vikigwuraad.’ Ki maaj aka birak watuwa, ay yaakiya.” ");
INSERT INTO mle_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ata wadik, ata jayib nak adi kawamiy wapakuw, tabwubir. Birkibir mawul vitiy katiy tibir. Tan warkuw maa, rakarak tibir. Ata gipabir Jisas dikidiy kalivadidiy duwak adi God diki maaj kardadi duw diki wadil maaj wakir. ");
INSERT INTO mle_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jayib nak Jisas biraki mwutamaam tikitayaan tikuw, wadibir, “Oy! Aka yabira?” Ata wadik, bir dikik yakuw, dikibir manwa vakirkuw, dikibir manim kaykitikuw, gaba maaj sukwubir dikik. ");
INSERT INTO mle_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisas ata wadibir, “Bir yaga-tikwa. Bir maay. Yikuw, wunadiy nyamwusugwuk aw, ‘Gwur Galiliyaar awakw. Wakwukuw, alim vikigwuradiwun.’” ");
INSERT INTO mle_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bir yitaay tibir nyidi yabim, nuwukadiy dipwu kabakik van tidiy vay sawdiy duw Jiruwsalimaar yikuw, sapakwa nyanugw pris ak wadiy adiy vidadiy ababa javik. ");
INSERT INTO mle_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Adiy sapakwa nyanugw pris awa Juw dayadiy sapakwa nyanugw day vagaluwkuw, maaj lakatiydiy. Maaj lakatiykuw, day saan samasam kwiydadiy adiy vay sawdiy duwak. ");
INSERT INTO mle_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kwiykuw, ata wadadiy, “Nuwukadiy duw takwak aw, ‘Nyidi gaan tilik, nyan si kwabaak, Jisas dikidiy kalivadidiy duw yakuw, dikidi amwiy luwkuw kwurdaad.’ ");
INSERT INTO mle_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“Li adi taay maaj lakwunadi gavman wukikida ki javik, nyan diwa maaj lakatiykuw, aw di gwuraam kotiy maa.” ");
INSERT INTO mle_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Adiy vay sawdiy duw saan kwurkuw, sapakwa nyanugw pris dayadiy wadadiy majib kwurdadiy. A nyi a maaj miyawa tamiy Juw wukidaal aw ki nyab wukijibir tidana. ");
INSERT INTO mle_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisas dikidiy tabatiy maan nak kalivadidiy duw dayak tayir wadil majib wukikuw, day Galiliyaam rina nibwukir yidiy. ");
INSERT INTO mle_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Day Jisasaam vikuw, ata dikik gaba maaj sukwudiy. Nuwukadiy mawul vitiy katiy tikuw, ata mawulaar wadiy, “Nyan lakwubana Jisas bwu kiyaad. Aw kad Jisas-ad, ay nikidi duw-ad?” ");
INSERT INTO mle_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas dayawa walibab tikuw, kidiy maaj dayak wadidiy, “God wunak bwutaay ap kwiykuw, aw alik adawul tipawa kidi tipak wun van tiyaki-nadiwun. ");
INSERT INTO mle_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","“Aw gwurak waaw, kidi kupw miyawa tamiyaar yikuw, ababa duw takwak awulakw. Aw day wunadiy kalivatuwadiy duw taakw tikwadiy. Aw baptais dayaam akwiy, aw day abab wunadi Asaay dikidiy-adiy, wun dikidi Nyan wunadiy-adiy, God dikidi Mawul dikidiy-adiy tidakikik. ");
INSERT INTO mle_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","“Dayak awulakw kidiy gwurak watuwadiy ababa maaj. Wulakwugwur dayadiy mawulab kwakwadiy. Wun gwurawa nyi gaan nyi gaan tikinadiwun. Atawa tituwik, kidi kupw ata kwusikinaad.” ");
INSERT INTO mle_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ki viyakita maaj Jisas Kraisak, God dikidi Nyanad. Taay ki viyakita maaj atawa wakwul. ");
INSERT INTO mle_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tayir God diki maaj wasapwiydi duw, dikidi si Aysaya, ki God dikidi Nyinik wadil maaj di sukwudil. God wanaad, “Awuk! Taay, maaj kariyanadi duw wayakituwaad. Yin niki jaav niki jaav minak kwulapwu-kinaad. ");
INSERT INTO mle_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Duw nak tamiyaka tamiyaam gaam sinaad, ‘Niki jaav niki jaav kwulapwun ada nimadi sapakwa duwak. Alik adi yaab tugwaam nakwaad.’” ");
INSERT INTO mle_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Alik duw nak, dikidi si Jon, tamiyaka tamiyaam warkuw, duw takwak baptais kwiydidiy. Dayak ki maaj kwiydidiy, “Gwuradiy mawul awarapiy. Warapiygwur, baptais kwatiya-kituwadiygwur. God gwuradiy vaal ata yibwiy-kidadiy.” ");
INSERT INTO mle_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Samasama Juwtiya tamiya kidiy duw takwawa Jiruwsalim tipa kidiy duw taakw wakwudiy Jon diki maaj wukik. Aw day dayadiy vaal wasapwiykuw, Jon ata baptais kwiydidiy Jawtan bayibim. ");
INSERT INTO mle_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon dikidi wapwiy kamil yuwiyir vildaad. Sipapuwtuwawa jitakadid. Di kwarbag kitika jaav si lakis wawa kwudiyugw daya guwawa kad. ");
INSERT INTO mle_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jon diki maaj, “Duw nak wuna kwukir yakinaad. Mwiya sapakwa duw, yitaypika duw-ad. Wun yisadapik tinadiwun. Wun kidi duw dikidiy jaav yatayat maa rav. ");
INSERT INTO mle_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","“Guwaam baptais bwu kwatiya-tuwadiygwur. Aw di God dikidi Mawulaam baptais kwiy-kidadiygwur.” ");
INSERT INTO mle_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A nyi Jisas Galiliyaam ridi tip Nasaritaam alim kwakuw, Jonak ata yaad. Jisas yadik, Jon baptais kwiydid Jawtan bayibim. ");
INSERT INTO mle_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kwiyin napadik, Jisas guwaam tikuw, ata warid. Wardik, vidik, jayib ni God nyamaliygaay kajatakadid. Nyamaliygaay kajatakakuw, God dikidi Mawul ata daad midakim kitik Jisasak. ");
INSERT INTO mle_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jisas ata ki God wadil maaj wukidil, “Min wuna mawul yinadi Nyan-adimin. Wun rakarak tinadiwun minak.” ");
INSERT INTO mle_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jayib ni adi Mawul mwugiydik, Jisas kipa tamiyaar ata yad. ");
INSERT INTO mle_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yikuw, nyi duwamiy vitiy alim kwadidiy. Nyanyi Satan Jisasak wasupwun vasibariyik ata kwurdid. Sapiy tidiy jaav kupwaam tiytiyaan tidiy adi tamiyaam. God dikidiy maaj kardadiy duw Jisasak sugwiyaan kwurdiy. ");
INSERT INTO mle_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Day Jonaam kalabus ir yakisawulakuw, Jisas ata Galiliyaar yad. Yikuw, di God diki viyakita maaj duw takwak wadidiy. ");
INSERT INTO mle_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Di dayak waad, “Nyi akaanaka. God diki duw takwak van tikida nyi walibab tina. Vaal yigwuradiy mawul wapakuw, ki viyakita majib wukijibir ada.” ");
INSERT INTO mle_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas ar si Galiliy, di mala arasaay yaad. Yakuw, Sayman-awa dikidi nyamwus Adiruw Jisas vidibir. Bir nagir yakisakwubir guwaar kamiy kwurik. Aal biraki yawiy-al. ");
INSERT INTO mle_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas ata wadibir, “Bir wuna kwukib may! Yakuw, wun kalivaaw. Bir duw kwurkinabirbir tayir kamiy kwurbiril pik.” ");
INSERT INTO mle_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jayib ni nagir wapakuw, Jisas diki kwukib yibir. ");
INSERT INTO mle_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jisas kwasa yikuw, ata vidibir Sipatiy dikibir nyidiy, Jamis-awa Jon. Bir biraki jabiraam kwabir biradiy nagir tap tipa-biridiy. ");
INSERT INTO mle_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas birakik wataydik, biradi asaay Sipatiyawa jabiraam kwadiy duwawa wapakuw, Jisas diki kwukib ata yibir. ");
INSERT INTO mle_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Day tip si Kapanamaar wuladiy. Juw daya yaap kwadadiy nyi, si Sapat, wuladik, Jisas Juw daya gaba maja wiyaar ata wulaad. Wulakuw, ata kalivadidiy. ");
INSERT INTO mle_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Day diki maaj wukikuw, pitaan wardiy. Agwak, di kalivadidiy lo kalivadiy duw kitik maa. Di niki maaj niki maaj lakwudi duw-ad. ");
INSERT INTO mle_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Duw nak gaba maja wiyaar ata wulaad. Adi duw tayir diki mawulaar wudib yidid. Di Jisasak nimadib gaam sidid, “Jisas Nasarit tipa kid, min agwa jaav kwurik nyanaam? Min nyanaam viyapakwuk? Wun bwutaay lakwu-tuwadimin. Min God dikidi nikidi kapaba duw-adimin!” ");
INSERT INTO mle_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisas nimadib adi wudibak ata wadid, “Kaygan ada! Min kidi duwaam ata awap!” ");
INSERT INTO mle_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Adi wudib mwugiydik, adi duw kupwaam vakirbagwun, gaam sibagwun, ata kwurkuw, adi wudib ata wapadid. ");
INSERT INTO mle_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ababa duw taakw ata pitaan wardiy ata walas kirasin ran bwuladiy, “Kal agwa jaava? Kwula jaav nyanak kalivada? Adiy wudib diki majib wukinadiy. Di ap tinadi duw-ad.” ");
INSERT INTO mle_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Galiliyaam rikuw, ababa duw taakw jayib ni wukidaal Jisas kwurdidiy jaav. ");
INSERT INTO mle_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas Juw daya gaba maja wiy wapadik, Saymanawa Adiruw biraki wiyaar yad. Jamisawa Jon diwa yibir. ");
INSERT INTO mle_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sayman diki nakim sip kuwkuw nalilik, alik jabim ral. Yabiyib Jisasak wadaad likik. ");
INSERT INTO mle_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Di wakwukuw, tabaam kaykitikuw, kirapitakadik, kuwkuw nal sip yabiyib nikir tayil. Li ata dayak kikipaat sukwulik yal. ");
INSERT INTO mle_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Giraab nyi dadik, samasama duw taakw nuwukadiy giviyib kwurdiy, nuwukadiy wudib mawulaar yidadiy, duw taakw Jisasak kwurin kariyadadiy. ");
INSERT INTO mle_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Adi tipa kidiy duw taakw abab wiya tipigwusim vagaluwdiy. ");
INSERT INTO mle_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Samasam niki giviyib niki giviyib kwurdiy duw taakw Jisas sipwutiydidiy. Nuwukadiy duw taakw wudib mawulaar yidadiy, Jisas adiy wudibak, “Gwur agwutak!” wadik, tabwudiy. Adiy wudib Jisas bwu vidaad. Alik Jisas watipididiy, “Maaj bwulaway!” wakuw. ");
INSERT INTO mle_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sira pik ganib gitigit nalik, Jisas di ata rapid. Rapikuw, wiy wapakuw, kipa tamiyaar ata yad. Yikuw, di Godak maaj bwulaad. ");
INSERT INTO mle_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sayman diwa kwadiy duwawa kwakiyin kwakiyaan tamiyaka tamiyaam ata tidiy. ");
INSERT INTO mle_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tikuw, ata vidaad Jisasaam. Vikuw, ata wadaad, “Nyan abab minak kwakibagwu-nadiyan.” ");
INSERT INTO mle_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jisas dayak ata waad, “Nyan aka niki tip niki tipaam tiytiyaan tikidiyan. Wun dayak ab God diki maaj wakir. Ki yawiyik wakwudiwun.” ");
INSERT INTO mle_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galiliy wadidi tamiyaar yad. Yikuw, niki tip niki tipaar yin yaan tad. Dayadiy gaba maja wiyaar wulakuw, God diki maaj kwiydidiy. Di duw mawulaar yidiy wudib kwurin yakididiy. ");
INSERT INTO mle_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lepa duw nak yakuw, Jisasak kwatiyir sikuw, nimadib bas sidid, “Mina mawul warlik, wuna sip sipwutiy-kimina.” ");
INSERT INTO mle_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas dikik wukikuw, taab ata dikim takakuw, ata wadid, “Wun minak sipwutiyik viyakit timinkikik.” ");
INSERT INTO mle_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ata wadik, yabiyib lepa giviyib wapalik, diki sip viyakita mwiy tal. ");
INSERT INTO mle_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisas dikik wayakik tikuw, aw taay nimadib wadid. ");
INSERT INTO mle_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Di wadid, “Min awuk! Kipa duw takwak wawayik. Yabiyib maay pris ak mina sip vidikikik. Tayir Mawsis wadidiygwur jaav akwiy Godak. Alik ababa duw taakw wukikwadiy mina giviyib aka bwu kwusina.” ");
INSERT INTO mle_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Adi duw Jisasaam wapakuw, yad. Yikuw, kipa duw takwak wadidiy Jisas diki lepa giviyib sipwutiydil. Samasam wadidiy a javik, alik Jisas niki tip niki tipaar yiyi maa rav. Kipa tamiyaam kwaad, Jisas. Niki tip niki tipa duw taakw yaan vagaluwdiy dikik. ");
INSERT INTO mle_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nuwukadiy nyi yidaak, Jisas sibinin Kapanamaar yadik, duw taakw wukidaal di wiyaam kwaad. ");
INSERT INTO mle_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wukikuw, samasama duw taakw wulaan vagaluwdiy. Adi wiyab wulayakidaak, wiy bwu jin yakid. Tipigwus kapwul. Agin maa ti. Jisas dayak God diki maaj ata wadil. ");
INSERT INTO mle_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ap lupwun ridi duw ata duw aliy yatakuw, kariyadaad. ");
INSERT INTO mle_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","A tamiy kapwiyakilik, adiy duw dim walibab karay karay suwaan yidiy Jisasak. Suwaan yidaak, apiy tabiyim agin kwurtakadaal Jisas ridilwa kituw kitad. Kwurtakakuw, adi ap lupwudi duw dikidi bayim tabik tabikim yaav tuwtakakuw, ata Jisas ridilwa, diki mala duwa, ata kwasa kwasa kwusadadaad. ");
INSERT INTO mle_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas wukidil day samasam wukijibir tidiy dikik. Alik di ap lupwudi duwak ata wadid, “Wunadi nyan, minadiy vaal wun yibwiytuwadiy.” ");
INSERT INTO mle_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Nuwukadiy God diki lo kalivadiy duw walibab ridaak, day daya mawulaam wadiy, “Agwa javik kidi duw atawa wanaad? Godak wajibaynaad. Duw vaal yibwiy yibwiy maa rav. Godadika atawa kwurkwaad.” ");
INSERT INTO mle_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Yabiyib Jisas dayadiy mawul vikuw, ata wadidiy, “Agwa javik gwur atawa mawul tinadiygwur? Agwa jaava kakilkina wun kwurkwurik, aw gwur vikuw, ayiy wakigwura a javik? Kidi ap lupwudi duwak wakituwaad, ‘Minadiy vaal yibwiy-tuwadiy’ ay ‘Min arap. Rapikuw, minadi baay yatakuw, min maay?’ ");
INSERT INTO mle_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“Wun gwurak simaka-kituwa wun, duw taakw dayadi Mwaam, ki kupwaam ap kwurtuwaal duw taakw dayadiy vaal yibwiyik.” ");
INSERT INTO mle_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Di ap lupwudi duwak ata wadid, “Wun minak watuwa, arap! Minadi baay kwurkuw, maay mina wiyaar.” ");
INSERT INTO mle_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jayib ni rapid. Rapikuw, dikidi baay kwurkuw, ata wakwukuw, ata yad. Abab a jaav vikuw, pitadiy. Pitakuw, day wadiy, “Wa! Tayir nyan atawa maa vi. God diki ap mwiya nimaala.” ");
INSERT INTO mle_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas alib yad Galiliy mala araar. Duw taakw dikik yadakilib kalivadidiy dayak. ");
INSERT INTO mle_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yitaay tidik, saan kwurdi duw, Alpiyas dikidi nyan Liyvay diki opis im ridik, Jisas vidid. Jisas dikik ata waad, “Wuna kwukib may.” Wakuw, Liyvay rasikuw, diki kwukib yad. ");
INSERT INTO mle_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ginyir, Jisas kikipaat kad Liyvay diki wiyaam. Jisas dikidiy kalivadidiy duwawa, samasam saan kwurdiy duw, vaal yidiy duw ab alim ridiy. Samasam kitampika duw Jisasawa ata yidiy. ");
INSERT INTO mle_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nuwukadiy God diki lo kalivadiy duw, day Parasiy bapa duw tidiy, day vidaad Jisas adiy saan kwurdiy duwawa vaal yidiy duwawa kikipaat kidik. Vikuw, dikidiy kalivadidiy duwak bas sidadiy, “Agwa javik di saan kwurnadiy duwawa vaal yinadiy duwawa kikipaat kinaad?” ");
INSERT INTO mle_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas daya maaj wukikuw, dayak ata waad, “Giviyib kwurnadiy duwadika dokta ak yikwanadiy, kip tin duw yiyi maa rav. Wun viyakita duwak maa yay. Wun vaal yinadiy duwadikanik yanadiwun.” ");
INSERT INTO mle_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nyi nak Jon, baptais kwiydi duw, dikidiy kalivadidiy duw, Parasiy dayadiywa, day kikipaat maa ki. Day dayadiy sukw. Nuwukadiy duw Jisasak yakuw, wadaad, “Jon, baptais kwiydi duw, dikidiy kalivadidiy duw, Parasiy dayadiywa nuwukadiy nyaam kikipaat akis kikwanadiy. Agwa javik minadiy kalivaminadiy duw atawa maa kwar?” ");
INSERT INTO mle_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas dayak wadidiy, “Kapa nyanugw, duw taakw kiradil nyi kikipaat akis kikwanadiy? Suwana. Di dayawa tidil atawa maa kwar. ");
INSERT INTO mle_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","“Ginyir yadaak, day taakw kiradil duw kwurin karaykuw, adiy kapa nyanugw kikipaat ki maa a nyaam. ");
INSERT INTO mle_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Duw akis jaba wapwiyim tina tap aw kwula wapwiy kwurkuw, tipatip a maa rav. Adi tap ata nima tikina. ");
INSERT INTO mle_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Duw akis meme dikidi sip jaab tidik, kwula wain kwurkuw, adi sipaam vagavag maa rav. Adi sip wain awa wulwul maa rav. Alik wutakina aw sipawa wain kupwaraap tikinabir. Duw kwula wain kwula meme sipaam vagakwanadiy.” ");
INSERT INTO mle_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jisas wit, dayadiy mwiy kabuw sik kitik tinadiy, ridadi mayim tiytiyaan tad Sapat nyaam. Dikidiy kalivadidiy duw diwa yikuw, wit dayadiy mwiy kwurdadiy. ");
INSERT INTO mle_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nuwukadiy Parasiy Jisasak bas sidaad, “Av! Agwa javik minadiy kalivaminadiy duw nyana lo watipidada yawiy kwurdana?” ");
INSERT INTO mle_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisas dayak ata bas sididiy, “Lapa nyigaam Davit diki kwurdil jaav sukwudaal. Gwur maa vi? Di dikidiy duwawa kaam yasalik kikipaat kikir. ");
INSERT INTO mle_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","“Alik Apayata Mwiya Yitaypika Pris tidik, day God diki wiyaar wulakuw, Godak kwiydadiy bret di kad. Nuwuk dikidiy duwak ata kwiydidiy kidakikik. Aw nyana lo wana, ‘Pris dayadika adiy bret kikwadanadiy. Nuwukadiy duw taakw akis kikwadanadiy.’” ");
INSERT INTO mle_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisas ata wadidiy, “God sugwiyaan kwurik duw takwak. Alik di tasakwudil Sapat dayak, aw duw taakw Sapatak a maa. ");
INSERT INTO mle_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","“Wun duw taakw dayadi Mwaam Sapatak van tikwanadiwun.” ");
INSERT INTO mle_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisas Juw daya gaba maja wiyaar wuladik, duw nak diki baw taab bwu kiyaal, alim rad. ");
INSERT INTO mle_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Duw Jisasak van kavin kwadiy, aal di adi duw diki taab sipwutiydikik Sapat nyaam. Day sukwupirkuw, dikik wakir a javik. ");
INSERT INTO mle_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Di baw taab bwu kiyadi duwak, “Min rapikuw, may!” wakuw wadid. ");
INSERT INTO mle_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Di dayak bas sididiy, “Agwa jaav nyana lo wala? Sapat nyaam viyakita yawiy kwuryikwadiyan? Ay kupwarapa yawiy kwuryikwadiyan? Sugwiyaan kwurik, ay viyasipak?” Day maaj maa bwul. ");
INSERT INTO mle_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas aw van aw van vikuw, dayak yaal giraad. Dayadiy maka apaam kabaak ridiy. Alik dayak diki mawul waril. Di adi duwak ata waad, “Mina taab akaynawur.” Kaynawurdik, diki taab viyakit tal. ");
INSERT INTO mle_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parasiy wakwukuw, yabiyib Juw dayadi yitaypika duw, Yirat, dikidi bapawa maaj bwuladadiy Jisasaam viyasipak. ");
INSERT INTO mle_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisas dikidiy kalivadidiy duwawa a tamiy wapakuw, Galiliy araar yidiy. Duw taakw samasamadiy diki kwukib yidiy. Galiliya kidiy, Juwtiya tipa kidiywa, Yituwmiya tipa kidiywa, Jawtan apika gikim kidiywa, Taya, Saytan tipa kidiywa ata yidiy. Samasam diki yawiyik wukikuw, ata yidiy dikik. ");
INSERT INTO mle_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jisas dikidiy kalivadidiy duwak wadidiy, “Gwur kwasa jabir kariyagwur tikwa kilim wunak, kidiy samasama duw taakw wunaam walibab kuwguwpa kuwguwpak-nadiy wunaam.” ");
INSERT INTO mle_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jisas samasama duw taakw sipwutiydidiy. Alik samasama giviyib kwurdiy duw taakw dikim walibab kuwguwpadaad diki sipaam taab takak. ");
INSERT INTO mle_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Duw dayadiy mawulaam yidiy wudib Jisasaam vikuw, day ata vakirdiy diki manwa ata gaam sidiy, “Min God dikidi Nyan-adimin.” ");
INSERT INTO mle_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wakuw, Jisas dayak watipididiy, “Kaygan ada! Watikwa, ‘Min God dikidi Nyan-adimin,’ wakuw.” ");
INSERT INTO mle_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Jisas kwasa nibwuk rilil tamiyaar wulakuw, mawulab tidiy duwak gaam sididiy yadakikik dikik. Day dikik yadaak, tabatiy maan vitiy tasakwudidiy. Di dayak ata waad, “Wun tasakwu-tuwadiygwur wunawa kwagwurkikik. Wayaki-kituwadiygwur wuna maaj kwiygwurkik. ");
INSERT INTO mle_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","“Wun gwurak ap kwiykituwa mawulaar yinadiy wudib kwurin yakigwurkik.” ");
INSERT INTO mle_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","18","Adiy tasakwudidiy duw dayadiy si kidiyka: Sayman Jisas sikiydid Pita, Sipatiy dikibir nyidiy Jamisawa Jon Jisas sikiydibir Bawanakis, maaw maaj ‘Yakalaw kitik kwakwanabir’, Adiruw, Pilip, Batalimuw, Matiyuw, Tomas, Alpiyas dikidi nyanad Jamis, Tatiyas, Sayman ap samasam tidi wariya duw. ");
INSERT INTO mle_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Dayawa Juwtas Yiskariyat tad. Ginyir di Jisas kwiydid Jisas dikidiy mamik. ");
INSERT INTO mle_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas wiyaar yidik, duw taakw samasam alib vagaluwdiy. Alik di dikidiy kalivadidiy duwawa kikipaat kiki maa rav. ");
INSERT INTO mle_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Duw taakw, “Di kwam yinaad,” wadalik tikuw, alik Jisas dikidiy gwalugwa duw a jaav wukikuw, day yadiy Jisas kwurin karayik. ");
INSERT INTO mle_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nuwukadiy Jiruwsalimaam kwadiy God diki lo kalivadadiy duw yakuw, ata wadiy, “Biyilsipap diki mawulaam rinaad. Kidi yitaypika wudib dikik ap kwiydik, di nuwukadiy mawulaam rinadiy wudib kwurin yakidadiy.” ");
INSERT INTO mle_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisas duw takwak gaam sididiy yadakikik dikik. Di ata waya maaj kitik wadidiy, “Satan di di kwurin yakinaad? Suwana. ");
INSERT INTO mle_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Li gavman nak kapakap kajakuw, tabik tabik viyatukwiyaan tikuw, adi gavman vakirkinaad. ");
INSERT INTO mle_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","“Li gwalugw nak kapakap kajakuw, tabik tabik mawulaar viyatukwiyakuw, adi gwalugw vakirkinaad. ");
INSERT INTO mle_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","“Atawa, li Satan di di wariyakuw, di ap ti maa. Vakirkinaad. ");
INSERT INTO mle_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Duw nak ap tinadi duw diki wiyaar wulakuw, dikidiy niki jaav niki jaav kwurkwurik, di maa rav. Taay, adi ap tinadi duwaam yaav jikuw, dikidiy wiyaam rinadiy jaav ata kwurkidadiy. ");
INSERT INTO mle_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Mwiya maaj watuwadiygwurik. Li duw taakw vaal samasam yidaak, wajibayin sapis jikin samasam kwurdaak, God adiy javik yibwiy-kidadiy. ");
INSERT INTO mle_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","“Li duw nak God dikidi Mawulak wajibayin sapis jikin kwurda, God diki vaal yibwiy maa. Nabiy nabiy kip tikina.” ");
INSERT INTO mle_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nuwukadiy duw wadiy, “Wudib diki mawulaar yinaad,” wakuw, alik Jisas ki maaj wadil. ");
INSERT INTO mle_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jisas diki amaay dikidiy nyamwusugwawa ata yakuw, kawaam tidiy. Day maaj watakadaal dikik yadikikik dayak. ");
INSERT INTO mle_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Duw taakw samasam kaypwusin kwurin ridaad. Day dikik ata wadiy, “Mina amaay minadiy nyamwusugwawa kawaam tinadiy. Day minaam vikir wanadiy.” ");
INSERT INTO mle_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisas dayak wadidiy, “Sikalalaal wuna amaay? Sikadadiy-adiy wunadiy nyamwusugw?” ");
INSERT INTO mle_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Di kaypwusin kwurin ridiy duw takwak aw van aw van wadidiy, “Av! Wunaki amaywa wunadiy nyamwusugw. ");
INSERT INTO mle_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“Sikadadiy God diki yawiyik wukikuw kwurkinadiy, day wuna amaay, wunadiy jikwaraagw tikinadiy.” ");
INSERT INTO mle_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Galiliy ar, mala araam tikuw, Jisas adiy duw takwak kalivadidiy. Jisasawa duw taakw samasam vagaluwdiy. Alik di kwasa jabiraar warkuw, di a jabiraam guwaam kwaad. Day samasam duw taakw adiyka a mala ara kupwaam ridiy. ");
INSERT INTO mle_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dayak samasama jaav kalivadidiy waya maaj kitik wadidiy. Di dayak wadidiy, ");
INSERT INTO mle_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Awuk ki maaj! Duw nak kabuw sik kitika jaav wit liki kadiy yakik yad. ");
INSERT INTO mle_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","“Kadiy yakidik, nuwuk yabim vakirdiy. Wapiy dakuw, kidadiy. ");
INSERT INTO mle_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","“Nuwukadiy kadiy kabakawa ril kwasa kupw, a kupwaam vakirdiy. A kupw bag maa ti. Alik jayib ni saal warkuw, maj mwiyir maa kway. Aw nimadi nyi sidik, rik yikuw, kiyadiy. ");
INSERT INTO mle_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Nuwukadiy kadiy ramiy tidiy visawa vakirdiy. Ramiy tidiy vas warkuw, yakiwulupwulidiy. Aw kadiy maa wakw. ");
INSERT INTO mle_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Nuwuk viyakita kupwaam vakirkuw, wardiy. Warkuw, day mwiy kwurdiy. Adiyka nuwuk mwiy mugwul ridiy. Nuwuk mwiy kwasa samasam ridiy. Nuwuk mwiy mwiya samasam ridiy. Atawa kwurdadiy.” ");
INSERT INTO mle_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas ata wadidiy, “Duw waan tinaad, di wukikwaad.” ");
INSERT INTO mle_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ginyir Jisas kap kwadik, dikidiy tabatiy maan vitiy duw nuwukadiywa dikik yakuw, bas sidaad a maaj maw maaj wukik. ");
INSERT INTO mle_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Di dayak wadidiy, “God simaka-didiygwur agwa jaav tayib pakwul atatawa di duw takwak van tikidadiy. Aw nuwukadiy duw taakw kidiy jaav lakwukwadiy waya maaj kitika majir. ");
INSERT INTO mle_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","“Alik ‘Day van van wak maa. Day wukin wukin laakw maa. Li atawa kwurkuw, Godak mawul wukikuw, di dayadiy vaal yibwiyik-dadiy.’” ");
INSERT INTO mle_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Di dayak bas sididiy, “Gwur ki waya maaj kitika maaj maa wak? Gwur atata nuwukadiy waya maaj kitika maaj wuki-kinadiygwur? ");
INSERT INTO mle_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Adi kadiy yakidi duw, aad God diki maaj wasapwiydi duw kitik tinaad. Adiy kadiy God diki maaj kitik tina. ");
INSERT INTO mle_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Nuwukadiy nyi God diki maaj yabim vakirnadiy. Aw adiy duw taakw wukidaak, Satan yabiyib yakuw, God diki maaj kwurdil dayadiy mawulaam kwalik. ");
INSERT INTO mle_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Atampik nuwukadiy duw taakw kabaak apiyim ril kupwaam yakididiy kadiy kitik tinadiy. God diki maaj wukikuw, kwurik rakarak tinadiy. ");
INSERT INTO mle_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","“Maaj mwiyir maa mawulaar yi. Alik simiy maa ti. Dayaam samasam kupwarapa jaav viyadaak, nuwukadiy duw taakw dayak wasupwudaak God diki majik, day ata bwan kwiydiy God diki majik. ");
INSERT INTO mle_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","“Nuwukadiy duw taakw ramiy tina visawa vakirdiy kadiy kitik tinadiy. Day God diki maaj wukikuw, aw dayadiy mawulaam rinadiy majik samasam wukikuw, sanawa niki jaav niki jaav kwurik wuki-kwanadiy. Dayadiy mawul ababa niki jaav niki javik yinadiy. Adiy jaav yakuw, God diki majim yakiwulupwu-dadiy. Alik day mwiy maa ri. ");
INSERT INTO mle_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Nuwukadiy duw taakw adiy viyakita kupwaam vakirdiy kadiy kitik tinadiy. Day God diki maaj wukikuw, kwurkuw, day mwiy rinadiy. Nuwukadiy duwamiy nak sap tabatiy rinadiy. Nuwukadiy duwamiy mugwul, nuwukadiy duwamiy tabab rinadiy. ");
INSERT INTO mle_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Di dayak bas sididiy, “Gwur lait kwurkuw, yala vakaam takagwura? Japakapaam vitaka-gwura? Jabim maa tak? ");
INSERT INTO mle_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","“Ababa jaav pakwun rinadiy, ababa jaav rabwutakaan rinadiy, ginyir adiy jaav maykaar wakwu-kidiy. ");
INSERT INTO mle_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“Duw waan tinaad, di wukikwaad.” ");
INSERT INTO mle_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Di dayak ata wadidiy, “Maaj wukikuw, yara awuk! Am san kwiy-kigwuradiy, atampik kwurkigwuradiy. Aw aywanib warapiy kwurkigwuradiy. ");
INSERT INTO mle_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","“Duw taakw wuna maaj lakwudana, ginyir miyawa lakwu-kinadiy God dikidiy javik. Aw adiy duw taakw day wuna maaj laakw maardana, ginyir kip tikuw, saal yikidiy.” ");
INSERT INTO mle_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas ata waad, “Kitawa God duw takwak van tinaad. Atampik duw nak kadiy yakididiy kupwaam. ");
INSERT INTO mle_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","“Gaan si kwadik, nyi rapikuw, nyanyi nyanyi kubwurin warnadiy. ");
INSERT INTO mle_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","“Kupw li kap mwugiylik, adiy kadiy wardaak, mwiy kwurkidadiy. Taay saal warid. Warkuw, mig ata kwaad. Kwakuw, ginyir mwiy ata rik yad. ");
INSERT INTO mle_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","“Mwiy rik yidaak, duw nima waliy kaam kwurkuw, kitiki-didiy. Mwiy kwurda nyi aka.” ");
INSERT INTO mle_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas ata waad, “Agwa jaav kitik God duw takwak van tinaad? Agwa waya maaj kitika maaj wakibana diki yawiyik? ");
INSERT INTO mle_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Di sika mastat kitik. Ababa nuwukadiy sak nimadiy-adiy, aw sika mastat mwiya kwasaala. Duw sika mastat kwurkuw, kupwaam sikwanaad. ");
INSERT INTO mle_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","“Ginyir kwasa mwiy simiy warkuw, mayim rinadiy javim kakil-kinaad. Ba mastat nimadiy-adiy. Aw wapiy day diki ba miya lagwum kwaat taka-kwanadiy.” ");
INSERT INTO mle_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas samasam waya maaj kitika majir wadidiy. Maaj lakwudaak, maaj kwiydidiy. ");
INSERT INTO mle_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Di waya maaj kitika majadika dayak kwiydidiy. Jisas dikidiy kalivadidiy duw dayawa kwadik, kidiy maaj daya maw maaj ata kwiydidiy. ");
INSERT INTO mle_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A nyi giraab tidik, dikidiy kalivadidiy duwak ata waad, “Kilakiy agika maka araar vakiynaak.” ");
INSERT INTO mle_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jisas kwasa jabiraam tikuw, duw vagaluwdiy tamiy wapakuw, kwasa jabiraar karaydaad. Nuwukadiy kwasadiy jabir diwa yidiy. ");
INSERT INTO mle_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yibwun wapakuw, yidaak nimadi mwar ata yaad. Yakuw, ata mam kwasa jabiraam viyadaak, guw jabiraar wuladik, kapwuk ata kwuril. ");
INSERT INTO mle_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas mala jabiraam kibwu tikirim si kwaad. Ata day wajawiya-daad. Wajawiyakuw, day ata wadaad, “Yitaypika duw, nyan aka kiyapakwu-kinadiyan. Min nyanak maa wak, nyan aka kiyakinadiyan?” ");
INSERT INTO mle_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisas ata rapid. Rapikuw, di “Kaygwakwa!” mwurik ata wakuw, mamak “Yitikwa!” ata waad. Alik mamawa mwar maa yi. ");
INSERT INTO mle_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jisas dayak ata waad, “Gwur agwak yaga-nadiygwurik? Gwur wunak wukijibir maa ti?” ");
INSERT INTO mle_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dikidiy kalivadidiy duw pitaan warkuw, ata bwuladiy, “Kad aka tamiya kidi duwad? Wadi majib nima mamawa mwar abira bwutaay kwusinabir.” ");
INSERT INTO mle_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kilakiy agika maka araam tabirkuw, Girasin day tamiyaar kawiydiy. ");
INSERT INTO mle_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisas jabir wapadik, duw nak dipwu kawamiyaam kwakuw, dikik yaad. Adi duw wudib diki mawulaar yidiy. ");
INSERT INTO mle_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Di dipwu kawamiya tipaam kwakwaad. Tipa duw dim kalakwu kalaakw maa rav. Aw makwaay sen maa rav. ");
INSERT INTO mle_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tayir dim sen manwa tabaam jidaak, di kap kaytikididiy. Day dim kalakwu kalaakw maa rav. ");
INSERT INTO mle_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Alik kawamiya tipawa nibwukim kwabagwud. Nyanyi nyi gaan “Ay” yan, gaam san, di diki sipaam kabakir viyadil. ");
INSERT INTO mle_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jisas sikaam tidik, adi wudib mawulaar yidadi duw Jisasaam vikuw, gipin yad dikik. Yikuw, adi duw Jisasawa walibab vakirkuw, kwatiy lupwusikuw, ata rad. Rikuw, ata nimadib gaam sad Jisasak. ");
INSERT INTO mle_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“Jisas, nimadi God dikidi Nyan-adimin. Agwa javik yanadimin wunak? Wun minak bas sinadiwun God diki mwutamaam jawjaay kwur-tikwa wunak.” ");
INSERT INTO mle_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jisas bwu wadid, “Wudib, min awap wadi duwaam!” Alik wudib diki mawulaar yidadi duw atawa waad. ");
INSERT INTO mle_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jisas ata bas sidid, “Minadi si ataanad?” Wudib ata waad, “Nyan samasam-adiyan. Alik Aywa Samasamad wunadi si.” ");
INSERT INTO mle_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jisasak nimadib bas sidid, “Min nyanak aya watipi-wayik ki tamiyak.” ");
INSERT INTO mle_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Walibab agika nibwukim bwal samasam kwaan kidiy. ");
INSERT INTO mle_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ababa wudib day ata nimadib Jisasak bas sidaad, “Min wamin, kidiy bwalak nyan abab wulayakinaak.” ");
INSERT INTO mle_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisas “Aal yaakiya,” wadik, day ata adi duwaam wapakuw, bwalaam wulayakidiy. Adiy bwal abab gipikuw, daan nima dipwu wamwunir dadiy. Ata abab adiy bwal dakuw, duwamiyir duwamiyir tabab (2000) kiyapakwudiy. ");
INSERT INTO mle_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Adiy bwalak van tidiy duw a jaav vikuw, tabwudiy. Tabwukuw, day nimadi tipawa kwasadiy tipaam kwadiy duw takwak a jaav wasapwiydadiy. Adiy duw taakw ata yadiy a jaav vikir. ");
INSERT INTO mle_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Day Jisasak yakuw, vidaad adi tayir wudib mawulaar yidadi duw. Wapwiy kwusuwkuw, di diki viyakita mawulawa rad. Ridik, day vikuw, yagadiy. ");
INSERT INTO mle_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nuwukadiy duw taakw tayir vikuw, ata wadadiy kwukir yadiy duw takwak agwa jaav Jisas kwurdidiy adiy bwalawa adi wudib mawulaar yidadi duwak. ");
INSERT INTO mle_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Day wukikuw, Jisasak nimadib bas sidaad, “Min ki tamiy awap!” ");
INSERT INTO mle_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Alik jabiraar wakwudik, adi tayir wudib mawulaar yidadi duw Jisasak nimadib bas sidid, “Wun minawa yikir.” ");
INSERT INTO mle_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aw Jisas dikik ay waan maa wu. Aw Jisas ata wadid, “Min maay! Mina wiyaar yikuw, minadiy gwalugwa duwak aw. Ata wamin, wukikwadiy God sukwasukw minak tikuw, agwa jaav di minak kwurdidiy.” ");
INSERT INTO mle_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Alik tipa si Tabatiy Tip, a tamiyaar kidi duw sibinin yad. Dayak wadik agwa jaav Jisas dikik kwurdid, ata day pitadiy. ");
INSERT INTO mle_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas jabiraar agika mala araar sibinin yidik, yibwunim kwadik, duw taakw samasam dikik alim vagaruwkuw, kaypwusin kwurin tidaad. ");
INSERT INTO mle_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Duw nak gaba maja wiya kidi sapakwa duw, dikidi si Jayras, di yakuw, ata vidid Jisasaam. Vikuw, dikik yakuw, diki manwa ata vakirid. ");
INSERT INTO mle_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ata wadid, nimadib wadid, “Wuna kwasa takwa nyan aka kiyakina. Min yakuw, lim taab takamin, yaakiya wakuw, kwakwa.” ");
INSERT INTO mle_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jisas diwa yad. Samasama duw taakw diwa nakamwiyib yidiy. ");
INSERT INTO mle_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dayawa kwaal taakw nak wany wakwun tiyalidiy nabiy tabatiy maan vitiy. ");
INSERT INTO mle_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nyanyi a taakw samasam dokta-ak yilidiy. Samasam kagil kwiydaal, aw likidiy saan kwusiyaal dayak. Aw liki giviyib maa kwas. Nyanyi wany wakwun tiyaal. ");
INSERT INTO mle_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Day Jisas diki yawiyik bwuladaak, li ata wukilil. Alik Jisas kwukir yaal. Yakuw, Jisas dikidi wapwiyim ata tabaar kwasa kwasa yakitaay, wapwalid. ");
INSERT INTO mle_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Agwak, ata liki mawulaar ata waal, “Li wun taab dikidi wapwiydikanim wapwa-kituwa, wun ata yara tikinawun.” ");
INSERT INTO mle_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ata yabiyib likim wakwudi wany jibwud. Li li kap wukilil liki giviyib kwusil. ");
INSERT INTO mle_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aw Jisas wukidil diki ap wapalid. Ata yabiyib Jisas tipatiyakwud. Tipatiyakwukuw, ata waad, “Wunadi wapwiyim sikala wapwana?” ");
INSERT INTO mle_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dikidiy kalivadidiy duw ata wadiy, “Min vimina nimadi bapa duw taakw minaam kwutagildana, aw min wamina, ‘Sikala wunaam wapwana?’”. ");
INSERT INTO mle_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aw Jisas ata kitay kitiy vad, “Sikala wunaam wapwana?” wakuw. ");
INSERT INTO mle_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A taakw li bwu wukilil liki giviyib bwu kwusil. Alik dikik yaal. Yagakuw, gingin nakuw, Jisasawa walibab vakirkuw, ata wasapwiylidiy ababa jaav dikik. ");
INSERT INTO mle_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas ata wadil, “Wuna nyan, nyin wunak wukijibiran tinanyin. Alik yara tinanyin. Nyin maay! Nyin yara maay! Nyina giviyib aka kwusina.” ");
INSERT INTO mle_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas ata tan maaj kwiydik, ata nuwukadiy Jayras diki wiyaam kwadiy duw yadiy. Yakuw, ata wadiy Jayrasak, “Mina nyan aka bwu kiyana. Niki yawiy kwiyway kidi kalivanadi duwak.” ");
INSERT INTO mle_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aal Jisas waan maa kway. Ata wadid Jayrasak, “Min yagaway! Wunak wukijibir ada!” ");
INSERT INTO mle_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pita, Jamis, Jamis dikidi nyamwus Jon, adiy duw mugwuladika Jisasawa yidiy. Nuwukadiy Jisas watipididiy. ");
INSERT INTO mle_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jayras diki wiyaar yin wakwudaak, Jisas duw taakw alim vididiy. Adiy duw taakw samasam girataay, wanib yidiy. ");
INSERT INTO mle_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Di wiyaar wardik, bas sididiy, “Agwa javik nimadib giranadiygwur? A kwasa nyan maa kiy, kip si kwana,” ata wadidiy. ");
INSERT INTO mle_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Day ata dikik wajibaydiy. Alik dayak ata wadik, kawaar wakwudiy. Jisas a nyan likibir amaay asaywa, adiy duw mugwulawa ata wuladiy kwasa nyan rilil tamiyaar. ");
INSERT INTO mle_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Liki tabaam ata kaykitidik, ata wadil, “Talita kuwmiy.” Nyana tipa maaj maw maaj atawa tikwana, “Kwasa nyan, wun nyinak wanadiwun, arap!” ");
INSERT INTO mle_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jayib ni a nyan rapikuw, ata tiytiyal. Likidiy nabiy tabatiy maan vitiy. Day adiy vagaluwdiy duw taakw ata pitadiy a javik. ");
INSERT INTO mle_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisas watipididiy a javik niki duwak wawak. Di wadidiy kipaat likik kwiydakik. ");
INSERT INTO mle_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas a tip wapakuw, diki tipaar ata yad. Dikidiy kalivadidiy duw diwa yidiy. ");
INSERT INTO mle_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sapat nyaam duw taakw kalivadidiy dayadi gaba maja wiyaam. Samasama duw taakw alim kwadiy. Day diki maaj wukikuw, ata pitaan wardiy. Day ata wadiy, “Akim di kidiy maaj kwurdidiy? Atata di kidiy jaav lakwudidiy? Atata di God diki mawulaam rina yawiy kwurnaad? ");
INSERT INTO mle_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Di miya yawiy kwuryikwadi duw-ad, Maria likidi nyan-ad? Jamis, Jawsis, Juwtasawa Sayman dikidiy nyamwusugw, ay maa? Dikidiy jikwaraagw kilim kwanadiy, ay maa?” Day maa wadiy dikik. ");
INSERT INTO mle_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisas ata wadidiy, “Ababa tipa kidiy duw taakw God diki maaj wasapwiydi duwak rakarak tinadiy. Aw diki tipa kidiy, diki gwalugw, diki wiyaam kwanadiy duw taakw atawa akis kwurkwanadiy.” ");
INSERT INTO mle_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A tipaam di God diki mawulaam ril yawiy kwurkwur maa. Aw di diki taab giviyib kwurdiy duw takwaam jaab nakanak takadidiy taab. Takakuw, sipwutiydidiy. ");
INSERT INTO mle_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Day wukijibir maa ti dikik. Alik di pitaan warid dayak. Jisas ata ababa walibab ridiy tipaar yin duw taakw kalivadidiy. ");
INSERT INTO mle_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Di gaam sad dikidiy tabatiy maan vitiy duwak yadakikik dikik. Yakuw, day vitiy vitiy wayakididiy. Di ap kwiydidiy dayak wudib yakidakik. ");
INSERT INTO mle_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Di dayak ata waad, “Gwur waliybagwu-kinadiygwur, samasama jaav yataway, kwala miydika. Kikipaat, kwasabiy, saan gwuradiy kwasabiyim, adiy jaav yataway. Maan gwuradiy manim taka-kwagwura. Wapwiy nak yaakiya, vitiy kwurway.” ");
INSERT INTO mle_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Di dayak ata waad, “Tipaar wulakuw, wiy nak alim adakw. Niki wiy niki wiyaar yiwayik. ");
INSERT INTO mle_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","“Li gwur nuwukadiy tipaar wulagwur, adiy tipa kidiy duw taakw maa wadaak gwurak gwuradiy majik, a tip awap. Taay gwur manim tikina kupw ayak dayak. Vikuw, day wukikwadiy gwurak kwurdaal kupwarapa javik.” ");
INSERT INTO mle_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jisas dikidiy kalivadidiy duw ata wakwudiy. Wakwukuw, day duw takwak wasapwiydadiy. Dayadiy maaj: “Gwuradiy bwan akwiy gwuradiy valik.” ");
INSERT INTO mle_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Day duw taakw dayadiy mawulaar yidiy wudib kwurin yakidadiy. Gwaar samasama giviyib kwurdiy duw takwaam takakuw, sipwutiydadiy. ");
INSERT INTO mle_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ababa duw taakw wabagwudiy Jisasak. Alik Juw dayadi yitaypika duw, Yirat, adiy yawiy wukididiy. Nuwukadiy duw taakw wadiy, “Jon, baptais kwiydi duw, God bwu rapinaad. Alik ki nima ap dim rina.” ");
INSERT INTO mle_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nuwukadiy wadiy, “Adi duw Yilayja-ad.” Nuwukadiy wadiy, “Di God diki maaj wasapwiydi duw-ad. Tayir mwiya nimadiy wasapwiydiy duw kitik-ad.” ");
INSERT INTO mle_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yirat adiy maaj wukidik, ata waad, “Di Jon, baptais kwiydi duw-ad. Tayir wun diki makiy lupwatuwil, aw kita rapinaad.” ");
INSERT INTO mle_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Tayir Yirat kiradil Yiratiyas, dikidi mwaam Pilip diki taakw. Jon, baptais kwiydi duw, Yiratak wadakilib, “God maa wanaad min minadi mwaam diki taakw kiramina.” Yiratiyas pitaan warkuw Jonak, li dim viyasipak. Alik Yiratiyas kwurik, Yirat duw wayakididiy Jon kwurin yaav jikuw, kalabus im takadakik. ");
INSERT INTO mle_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yirat yagaad Jonak. Di wukidil Jon viyakita duw-ad, nikidi kapaba duw-ad. Alik mwiyir van tad dikik. Aw Yiratiyas maa rav Jonaam viyasipak. Yirat Jon diki maaj wukik. Aw nyanyi a maaj wukikuw, di ata pitaan warid. ");
INSERT INTO mle_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ginyir kitawa Yiratiyas liki mawulaam tikuw, duw Jonaam viyasipadid. Yirat diki mak kwadil nyi tilik, di kikipaat jabim takadidiy gavman sapakwa nyanugw, vay sawdiy duw dayadiy van tidiy duw, Galiliy tamiy sapakwa nyanugw, adiy duwak. ");
INSERT INTO mle_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yiratiyas liki niba takwa nyan yaan baagw dayak tilik, day abab rakarak tidiy likik. Alik Yirat likik ata waad, “Agwa jaav nyin kwurik? Wunak wakuw, a jaav kwatiya-kituwa nyinak.” ");
INSERT INTO mle_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Di aban takadil, “Mwiya maaj watuwanyin. Agwa jaav nyina mawul kwurik walik, wun kwatiyaribak tinadiwun. Li nyin wunadiy van tituwadiy jaav tabik kwurik, adiy kwur-kinyinadiy.” ");
INSERT INTO mle_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aal niba taakw wakwukuw, liki amayik bas silil, “Agwa javik bas sikituwa?” Amaay ata waal, “Baptais kwiydi duw Jon diki abw.” ");
INSERT INTO mle_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jayib ni a niba taakw sibinin yikuw Yiratak, dikik ata walid, “Baptais kwiydi duw Jon diki abw kita marim takakuw, wunak akwutay.” ");
INSERT INTO mle_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yirat ata samasam wukid diki abanik. Di bwu takadil vagaluwdiy duw makab. Maaj lakatiykuw, alik ginyir maa rav warapiyik. ");
INSERT INTO mle_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Atawa tikuw, vay sawdi duw wayakidid Jon diki abw kwurdikik. Vay sawdi duw wapakuw, kalabus ir yikuw, Jon diki makiy viyalupwadil. ");
INSERT INTO mle_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Viyalupwakuw, Jon diki abw marim takakuw, niba takwak kwiydil. Li ata kwurkuw, karayin liki amayik kwiylil. ");
INSERT INTO mle_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jon dikidiy kalivadidiy duw a jaav wukikuw, day yakuw, Jon diki amwiy kwurdaal. Kwurkuw, kawamiyaam takadaal. ");
INSERT INTO mle_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Adiy wayakididiy duw sibinin yadiy Jisasak. Yakuw, day Jisasak yarik yidiy ababa yawiy day kwurdiy, ababa jaav day kalivadadiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Duw taakw samasamadiy yin yaan tidiy. Alik day kipaat kiki maa rav. Alik Jisas dayak ata waad, “Kipa tamiyaar yinaak, nyan kap. Yikuw, yaap rikidiyan.” ");
INSERT INTO mle_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Day kap kipa tamiyaar yidiy jabiraar. ");
INSERT INTO mle_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tip wapadaak, duw taakw samasam vikuw, wukidiy dayak. Ababa tipa kidiy duw taakw manir gipikuw, kakildadiy dayaam. Kakilkuw, day taay wakwudiy. ");
INSERT INTO mle_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas jabir wapakuw, adiy samasam vagaluwdiy duw takwaam vikuw, di samasam wukid dayak. Day sipsip kitik tidiy, duw maa van ti dayak. Di ata kalivadidiy samasama jaav dayak. ");
INSERT INTO mle_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Giraab tilik, dikidiy kalivadidiy duw dikik yakuw, wadaad, “Kal kipa tamiya. Giraab bwutaay tina. Kidiy duw taakw awayak. Yin kipaat mawiy yapiykwadiy niki tip niki tipaam.” ");
INSERT INTO mle_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisas dayak ata waad, “Gwur gwura dayak kipaat akwiy.” Day ata bas sidaad, “Min atata, nyan yikibana jilig duwamiy nak kwurkuw, bret yapiyik day kidakikik?” ");
INSERT INTO mle_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jisas dayak bas sididiy, “Bret kas gwuraam rinadiy? Yin av.” Day van tikuw, dikik wadiy, “Bret tabab, kamiy vitiy.” ");
INSERT INTO mle_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jisas vagaluwdiy duw takwak ata wadidiy, “Gwur kajakuw, kilib kapakap kapakap daan ada ki wasakawasa visim.” ");
INSERT INTO mle_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Day ata daan ridiy bapaar bapaar nuwuk duwamiy tabab, nuwuk duwamiy vitiy sap tabatiy. ");
INSERT INTO mle_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jisas adiy bret tababawa kamiy vitiy kwurkuw, adawur tipaar rikituwkuw, Godak wayapiy sidid. Wayapiy sikuw, adiy bret kaysukwa sukwakuw, kwiydidiy dikidiy kalivadidiy duwak adiy vagaluwdiy duw takwak kwiydakik. Abir kamiy ab di kaylupwakuw, duw takwak ata kwiydidiy. ");
INSERT INTO mle_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ababa duw taakw kipaat kikuw, yaal kapwudiy. ");
INSERT INTO mle_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jisas dikidiy kalivadidiy duw kavisa-dadiy kipaat vagakuw, baniy tabatiy maan vitiy vagadaak, kapwudiy. ");
INSERT INTO mle_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","5000 duw adiy bret kidiy. ");
INSERT INTO mle_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jayib ni dikidiy kalivadidiy duwak wadidiy, “Gwur jabiraar awar! Warkuw, gwur taay maay agika maka araam rina tip Bitsaytaar.” Wakuw, di ata vagaluwdiy duw taakw wayakididiy. ");
INSERT INTO mle_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Dayaam wapakuw, di nibwukir warid. Warkuw, Godawa maaj bwulad. ");
INSERT INTO mle_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gaan valik, adi jabir nyidi araam tidik, Jisas kap kwaad kupwaam. ");
INSERT INTO mle_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Di vidil mwar nimadib yin jabiraam sayil. Aw day yapwur yapwur gwus kadiy. Alik taay tapwuk wadidi gaan di apiy ararib dayak yad. ");
INSERT INTO mle_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Di dayaam gwutakak, aw day dim apiy guwarib yadik vikuw, day wadiy, “Kad apawul-ad?” Wakuw, nimadib gaam sidiy. ");
INSERT INTO mle_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Day Jisasaam vikuw, samasam yagadiy. Aw di yabiyib dayak ata waad, “Gwuradiy mawul yagadaba. Wun Jisas-adiwun. Yaga-tikwa.” ");
INSERT INTO mle_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Di ata jabiraar warid dayawa. Warkuw, mwar ata kwusil. Day ata pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Dayadiy mawul pakwudiy. Alik day maa laakw adiy bret ak tayir Jisas kaysukwa-didiy. ");
INSERT INTO mle_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Day araar suwulkuw, Ginisarit-aar yadiy. Alim jabir yaav tuwtakadiy. ");
INSERT INTO mle_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jabir wapadaak, jayib ni duw taakw Jisasaam vikuw, day ata, “Kad Jisas-ad” wataay wadiy. ");
INSERT INTO mle_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Day ata gipidiy niki tip niki tipaar. Day agwa tipaam Jisas kwaad wukikuw, giviyib kwurdiy duw taakw bayim takakuw, Jisasak ata kariya-dadiy. ");
INSERT INTO mle_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jisas kwasa tipaar, nima tipaar, duw vitiy mugwul rida tipaar yikuw, duw taakw giviyib kwurdiy nyidi tipaam takakuw, day jabir jabir bas sidaad diki wapwiyim kaykitidakik. Kaykitikuw, day ata viyakit tidiy. ");
INSERT INTO mle_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Parasiy nuwukadiy Juwawa dayadiy gwalugw kalivadadiy lo, adiy lo wab kwadiy. Day lo walil pik, taab jaan maarin, kikipaat akis kikwadiy. Atawa takwaam yapiydadiy kikipaat day jaan maarda, adiy day ki maa. Dayadiy gwalugw kalivadadiy lo samasam adiy lo wab kwadiy. Alik day adakap, vaak, maar, jaab jandadiy, lo walil pik. Parasiy nuwuk God diki lo kalivadiy duwawa, Jiruwsalim wapakuw, Jisas dikik tipisagwadi-daad. Day vidadiy nuwuk Jisas dikidiy kalivadidiy duw kikipaat kidiy tik tidiy tabaar. Day maa jaan dayadiy gwalugw kalivadadiy lo walil pik. ");
INSERT INTO mle_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Adiy Parasiyawa God diki lo kalivadiy duw Jisasak bas sidaad, “Agwa javik minadiy kaliva-minadiy duw nyanadiy gwalugw dayadiy kalivadadiy lo wab sarnadiy? Day kipaat kinadiy tik tinadiy tabaar.” ");
INSERT INTO mle_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisas dayak wadidiy, “Viyuw tilaka pik vitiy pasira-gwura. Tayir mwiya maaj Aysaya wadil gwurak. Di God diki maaj sukwudil, ‘Kidiy duw taakw wunak sukwasukw kwurin, rakarak kipa majidanir tikinadiy. Aw dayadiy mawul wunak mwiyir maa yi. ");
INSERT INTO mle_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kipa gaba maaj sukwunadiy wunak. Agwak, day dayadiy lo kalivadaak, wanadiy, “Kidiy God dikidiy lo-adiy.” ’ ");
INSERT INTO mle_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gwur God dikidiy lo wapakuw, gwur gwuradiy lo wadika kwur-kwanadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Di ata wadidiy, “Samasam lakwu-nadiygwur God dikidiy lo wapa-wapak, gwuradiy lo kwur-kwurik. ");
INSERT INTO mle_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“Mawsis ki maaj wadidiygwur, ‘Gwuradiy amaay asayik awuk.’ Niki majawa, ‘Sikadadaad amaay asayik sapis jikinaad, gwur adi duwaam aviyasip.’ ");
INSERT INTO mle_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Aw gwur kitawa kaliva-kwanadiygwur: ‘Li duw nak dikibir amaay asayik wakidabir, “Wun birak sugwiyaan kwar maa rav, wunadiy niki jaav God dikidiy tidakikik tasakwun tidanalik tikuw,” all jaaw yaakiya atawa kwurkwaad. Duw atawa wakuw, gwur watipi-gwuraad dikibir amaay asayik sugwiyaan kwurkwurik. ");
INSERT INTO mle_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","“Gwuradiy gwalugw dayadiy lo kwurkuw, nuwukadiy duw takwak kaliva-gwuradiy. Alik maa wanadiygwur God diki majik. Samasam kitampika jaav kwur-kwanadiygwur.” ");
INSERT INTO mle_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas alib ababa duw takwak gaam sididiy day yadakikik dikik. Yadaak, dayak ata wadidiy, “Gwur abab wunadiy maaj wukikuw, adiy majib awuk. ");
INSERT INTO mle_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Kawaam rinadiy jaav duw kikida, di kupwaraap ti maa. Duw daya mawulaam kwanadiy jaav wakwukuw, mwugiydaak, adiy duw kupwaraap tikinadiy. ");
INSERT INTO mle_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Duw waan tinaad di wukikwaad.” ");
INSERT INTO mle_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas adiy vagaluwdiy duw taakw dayaam wapaan wiyaar wuladik, dikidiy kalivadidiy duw dikik bas sidaad adiy waya maaj kitika majik. ");
INSERT INTO mle_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Di dayak ata wadidiy, “Gwurabab, gwur maa laakw? Kawaam rinadiy jaav duw kikida, adiy jaav mwugiydaak, adi duw kupwaraap ti maa. ");
INSERT INTO mle_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","“Adiy jaav duw diki mawulaar yiyi maa rav. Diki yalaar wulakinadiy. Wulakuw, aw diyawa yikidadiy.” Ki majir Jisas duw takwak simaka-didiy ababa kikipaat jaaw kikwadiy. ");
INSERT INTO mle_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nuwukadiy maaj ab wadidiy, “Duw daya mawulaam rinadiy jaav wakwukuw, mwugiydaak, adiy duw kupwaraap tikinadiy. Kidiy kupwarapa jaav duw dayadiy mawulaam ritaay, wakwu-kwanadiy. ");
INSERT INTO mle_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","“Mawul kupwaraap tan, yabim kwurbagwun, luwkuw kwurin, duw viyaan, taakw niki taakw likidi duwaam vaal yan, duw nikidi duw diki takwaam vaal yan, duw dikidiy niki jaav niki jaav mawul yan kwurik, nikim nikim jaal daan, gwiyip kwurin, liyin kwurbagwun, mawul kuwkuw naan, sapis jikin, waan taam lakw maarin, kwam tan. ");
INSERT INTO mle_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","“Kidiy kupwarapa jaav duw dayadiy mawulaam rinadiy. Adiy jaav wakwukuw, mwugiydaak, adiy duw kupwaraap tikinadiy.” ");
INSERT INTO mle_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas a tip wapakuw, Taya walibab ril tamiyaar ata yad. Wiyaar wulakuw, di kwasik yad duw taakw day wukiwukik di alim kwadik, aw di pawkwun kwakwak maa rav. ");
INSERT INTO mle_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Taakw nak, wudib liki takwa nyan liki mawulaar yad. A taakw wukikuw Jisas a tipaar bwu yad, yabiyib dikik yakuw, vakiril diki manwa. ");
INSERT INTO mle_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Li niki tipa taakwa. Liki tip Panisiya, Siriya tamiyaam. A taakw nimadib bas silid Jisasak di liki takwa nyan liki mawulaar yidi wudib kwurin yakidikik. ");
INSERT INTO mle_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Juw nuwukadiy jaka tipa kidiy duw taakw sikiydadiy as-adiy. Alik Jisas ata wadil, “Taay nyanugwak kikipaat kwiynaak. Nyanugw kikipaat asak nyan kwiykwiy maa.” ");
INSERT INTO mle_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Li ata walid, “Yitaypika duw, bwun jabim kwanadiy as nyanugw daya kavisa kipaat kikwanadiy.” ");
INSERT INTO mle_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jisas likik ata waad, “Nyin atawa wakuw, nyina wiyaar maay. Adi nyina takwa nyan liki mawulaar yidi wudib bwu wapadil.” ");
INSERT INTO mle_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Liki wiyaar yilik, liki jabim ral nyan vilil adi wudib bwu wapadil. ");
INSERT INTO mle_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas Taya walibab ril tamiy wapakuw, yin Saytan, Tip Tabatiy ril tamiyaar wakwud. A tamiy wapakuw, Galiliy araar wakwud. ");
INSERT INTO mle_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nuwukadiy duw duw nak dikik kwurin kariyadaad diki taab dim takadikik. Adi duw waan tikal tipid. ");
INSERT INTO mle_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jisas adi duwawa, bir kap, nuwukadiy duw taakw wapakuw, kwasa yikuw, Jisas dikibir duwa taab niki wanim nak, niki wanim nak gwardibir. Kwasa likasip satakakuw, adi duw dikid tikalaam takadil. ");
INSERT INTO mle_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Adawur tipaar sinawurkuw, “A!” gaam sikuw, adi duwak “Yipata,” wakuw wadid. Maw maaj, “Minabir waan tugwaam nakwabir!” ");
INSERT INTO mle_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jayib ni dikibir waan tugwaam nabir. Dikid tikal viyakit tan, maaj viyakit bwulaad. ");
INSERT INTO mle_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisas ababa duw taakw watipididiy day nuwukadiy duw takwak wasapwiy wasapwiyik a javik. Jisas dayak watipin kwadikilib, day wasapwiyin, Jisas dayak watipin kwadikilib, day wasapwiyin. ");
INSERT INTO mle_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ababa duw taakw pitaan wardiy. Day wabagwudiy, “Ababa yawiy viyakit kwurdidiy. Waan tipidi duw waan wukin, kwaliyaap takatipidi duw maaj bwulaan, Jisas mwugiydik, ata viyakit tidiy.” ");
INSERT INTO mle_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A nyi samasama duw taakw vagaluwdiy. Dayaam kipaat maa ri. Alik Jisas dikidiy kalivadidiy duwak wataydik, yadiy. Yadaak, di ata wadidiy, ");
INSERT INTO mle_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","3","“Wun kidiy duw takwak wukinadiwun. Day wunawa nyi mugwul kwadiy, day kikipaat maa. Nuwuk sikaam yadiy. Li wun kamik tidaak wayaki-kituwa dayadiy tipaar, nuwuk yabim kamik kiyasikiy-kinadiy.” ");
INSERT INTO mle_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dikidiy kalivadidiy duw ata bas sidaad, “Atata kikipaat kwiykibanadiy? Kal kipa tamiya. Bret kilim maa ri.” ");
INSERT INTO mle_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Di ata bas sididiy, “Gwuraam bret kas rinadiy?” Day ata wadiy, “Bret abitiy.” ");
INSERT INTO mle_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jisas duw takwak wadidiy, “Kupwaam daan ada!” Wadik, day ata daan ridiy. Ridaak, Jisas bret abitiy kwurkuw, Godak wayapiy sikuw, kaysukwa sukwakuw, ata dikidiy kalivadidiy duwak kwiydidiy. Day ata kwiydadiy adiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dayaam nuwuk kwasadiy kamiy ab ridiy. Jisas Godak wayapiy sikuw, ata wadidiy dikidiy kalivadidiy duwak, “Kamiy dayak akwiy!” ");
INSERT INTO mle_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Day kikuw, yaal ruwdaak, adiy kavisa kipaat baniy abitiyaam vagadaak, wapwulukwudiy. ");
INSERT INTO mle_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A nyi duw taakw 4000 kwadiy. Jisas ata wayakidik, yidiy. ");
INSERT INTO mle_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jayib ni dikidiy kalivadidiy duwawa jabiraar wulakuw, Dalmanuwta tipaar ata yidiy. ");
INSERT INTO mle_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nuwukadiy Parasiy yakuw, Jisasawa maaj warjuwdiy. Day Jisasaam vasibariyik kwurdiy. Alik day dikik bas sidaad, “God diki mawulaam rina yawiy asimak nyanak.” ");
INSERT INTO mle_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisas diki mawul pakwulik, dayak ata waad, “Agwak ki nyaam tinadiy duw taakw God diki mawulaam rina yawiy vikir? Mwiya maaj watuwadiygwurik. Ki nyaam tinadiy duw taakw God diki mawulaam rina yawiy akis vikidana.” ");
INSERT INTO mle_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Di ata wapadidiy. Wapakuw, jabiraar wulakuw, niki mala araar ata yitaay yidiy. ");
INSERT INTO mle_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Dikidiy kalivadidiy duw wukimardiy bret kwurkwurik, aw bret nak ral jabiraam. ");
INSERT INTO mle_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas nimadib di waya maaj kitika maaj wadidiy, “Gwur wukir yarakara ada Parasiy daya yis awa Yirat diki yis ak.” ");
INSERT INTO mle_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dayaam bret maa ri. Alik day daya bwulabagwudiy diki majik. Day wadiy, “Nyanaam bret maa ri, alik atawa wanaad.” ");
INSERT INTO mle_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas daya maaj wukidil. Alik di dayak bas sididiy, “Agwak, ‘Nyanaam bret maa ri,’ gwur gwura wataay bwulabagwu-nadiygwur? Gwur maa wak. Gwur maa laakw. Kabaak gwura maka apaam rinadiy? ");
INSERT INTO mle_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","“Mil tinadiygwur, gwur maa vi? Waan tinadiygwur, gwur maa wak? Wukimar-gwuril tayir wun bret tabab 5000 duwak kaysukwun kwiytuwdiy? Baniy kas kavisa bret vagaluwkuw, vaga-gwurdiy?” Day wadaad, “Tabatiy maan vitiy.” ");
INSERT INTO mle_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jisas bas sididiy, “Wun bret abitiy 4000 duwak kaysukwun kwiytuwdiy. Baniy kas kavisa bret vagaruwkuw, vagagwurdiy?” “Abitiy,” wadiy. ");
INSERT INTO mle_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Di dayak ata waad, “Gwur maa wak?” ");
INSERT INTO mle_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Day Bitsayta tipaar wakwudiy. Wakwukuw, nuwukadiy duw mil tipidi duw Jisasak kwurin kariyadaad. Day Jisasak wadaad, “Kidi mil tipidi duw taab takaminkik.” ");
INSERT INTO mle_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas mil tipidi duw diki tabaam kaykitikuw, kwurin karaydid mala tipaar. Jisas adi duw dikibir milaam likasip sakuw, dikibir taab dim takakuw, bas sidid, “Niki jaav niki jaav mwiyir viminadiy?” ");
INSERT INTO mle_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Di sinawurkuw, ata waad, “Wun duw vituwadiy, day miy kitik tiytiyaan tinadiy.” ");
INSERT INTO mle_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas alib dikibir taab adi duw dikibir milaam takadibir. Adi duw vivikuw, dikibir mil tugwaam nabir. Ababa jaav mwiyir vididiy. ");
INSERT INTO mle_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisas ata wayakidid diki wiyaar. Wadid, “Tipaar yiway.” ");
INSERT INTO mle_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas dikidiy kalivadidiy duwawa rapikuw, Sisariya Pilipay adi tamiyaam ridiy tipaar yidiy. A yidaal nyi bas sididiy, “Duw taakw nikim nikim wataay agwa sad wunak sikiy-kwadanaad?” ");
INSERT INTO mle_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Day dikik ata wadaad, “Nuwuk wadiy min Jon baptais kwiydi duw-adimin, nuwuk wadiy Yilayja-adimin, nuwuk min God diki maaj wasapwiydi duw nak-adimin.” ");
INSERT INTO mle_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Di dayak ata bas sididiy, “Gwur gwura agwa sad wunak sikiy-kwagwuraad?” Pita dikik wadid, “Min Krais-adimin, God dikidi Tasakwudidi Duw-adimin.” ");
INSERT INTO mle_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Di dayak nimadib wadidiy, “Gwur nuwukadiy duwak watikwa ki javik.” ");
INSERT INTO mle_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas ata dayak kalivadidiy, “Duw taakw dayadi Mwaam diki sip kagil samasam yikina. Sapakwa nyanugw, sapakwa nyanugw pris God diki lo kalivanadiy duwawa, abab bwan kwiykidiy dikik. Viyasipadaak, kiyakida. Kiyakuw, nyi mugwul yidaak, di ata rasikinaad.” ");
INSERT INTO mle_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Dayak ki maaj maykaar wasapwiydil. Alik Pita Jisas malaar kawulakuw, ata nimadib maa waad diki majik. ");
INSERT INTO mle_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jisas tipatiyakwukuw, dikidiy kalivadidiy duwaam van, ata Pitaak nimadib wadid, “Satan, wunaam awap! Min duw mawula pik tinadimin. God mawula pik maa ti.” ");
INSERT INTO mle_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jisas vagaluwdiy duw takwawa dikidiy kalivadidiy duwak gaam sididiy yadakikik dikik. Yakuw, di dayak ata waad, “Abab day wuna kwukib yakir, day maa wakwadiy day daya mawulak. Atawa wakuw, dayadiy maap tinadiy miy yatakuw, wuna kwukib yakwadiy. ");
INSERT INTO mle_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Sikadadaad kwasik yinaad kiyakiyak, di kiyakinaad. Aw sikanadaad wunawa wuna viyakita majik wukijibir tikuw, kiyakuw, aw di yara kwakinaad. ");
INSERT INTO mle_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Li duw nak kupwaam rinadiy ababa jaav kwurkinaad, di kiyadik, adiy jaav atata sugwiyaan kwurkidiy dikik? ");
INSERT INTO mle_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","“Agwa jaav yapiykuw kwiykida aw mwiyir kiy marmarik? Di maa rav. ");
INSERT INTO mle_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Ki nyaam kwanadiy duw taakw vaal samasam yinadiy. Day maa wak Godak. Sikadadaad dayawa kwanadi duw maa waan wap saykinaad wunawa wuna majik, ginyir duw taakw dayadi Mwaam maa wakinaad adi duwak. A nyaam God diki maaj kardadiy duwawa di yakinaad dikid Asaay dikidi mwiya nimadi apawa.” ");
INSERT INTO mle_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas vagaluwdiy duw takwak ata wadidiy, “Mwiya maaj watuwadiygwur. Nuwuk kilim kwanadiy duw taakw taay God nima apawa duw takwak van tikida nyi vikidana, ginyir kiyakinadiy.” ");
INSERT INTO mle_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nyi abwun yidaak, Jisas Pita, Jamis, Jon dayadika kwurin kawardidiy. Aluwur pik tidi nibwukir wardiy. Day dim vidaak, diki sip ata patiyakwul. ");
INSERT INTO mle_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Dikidiy wapwiy ata kariyadiy. Aw mwiya wamakawam tidiy. Kupwaam tidiy duw wapwiy jandik, atawa wamakawam titi maa. ");
INSERT INTO mle_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mawsisawa Yilayja maykaar wakwubir. Bir God diki maaj wasapwiybir duw-abir, tayir bwu kiyabir. Pita Jamisawa Jon ata vidabir Jisasawa maaj bwula-birik. ");
INSERT INTO mle_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Vikuw, Pita Jisasak ata wadid, “Sapakwa duw, aal viyakita nyan kilim kwabana. Basadika wiy kwurnaak, nak minak, nak Mawsisak, nak Yilayjaak.” ");
INSERT INTO mle_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Day yagadiy. Alik Pita di maa laakw agwa maaj wawak. ");
INSERT INTO mle_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Baw tubw wakwukuw, apiyim dayaam God diki majadika tubwaam wukidaad, “Kad wunadi wuna mawul yilidi Nyan-ad. Diki maaj awuk!” ");
INSERT INTO mle_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jayib ni day kituw vidiy. Vikuw, nikidi duw day maa vi. Jisasadika vidaad. ");
INSERT INTO mle_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Day nibwukim dataay tikuw, Jisas dayak nimadib wadidiy, “Gwur ki vigwural javik kita nuwukadiy duw takwak wawayik. Ginyir duw taakw dayadi Mwaam kiyakuw, God kirapitaka-kidaad. A nyaam ki javik wakigwura.” ");
INSERT INTO mle_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Alik day wukin tidaal aw day daya wadiy, “Ki kiyakuw God kirapitaka-dadi duw maaj, aal atata kila?” ");
INSERT INTO mle_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Day ata Jisasak bas sidaad, “Agwa javik God diki lo kalivanadiy duw wakwanadiy, ‘Yilayja taay yakuw, God dikidi Tasakwudidi Duw ata yakinaad?’” ");
INSERT INTO mle_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisas dayak ata wadidiy, “Ayiy. Yilayja taay yakinaad ababa jaav kwulapwuk. Agwa javik God diki lapa nyig wana, duw taakw dayadi Mwaam kagil samasam yikina diki sipaam, aw duw taakw dikik maa wakidiy wakuw? ");
INSERT INTO mle_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","“Aw wun watuwadiygwur Yilayja bwu yaad. Yakuw, duw taakw dikik dayadiy mawul yidiy kupwarapa jaav kwurdaad, God diki lapa nyig walil pik.” ");
INSERT INTO mle_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Day nuwukadiy Jisas dikidiy kalivadidiy duwak wakwudiy. Wakwukuw, day vidadiy samasama duw taakw vagaluwdiy dayak. Nuwukadiy God diki lo kalivadiy duw maaj warjuwdiy Jisas dikidiy kalivadidiy duwawa. ");
INSERT INTO mle_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jayib ni duw taakw Jisasaam vikuw, pitaan warkuw, day dikik gipidiy diki tabaam kwurik. ");
INSERT INTO mle_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas dayak ata bas sididiy, “Agwa jaav gwur dayawa warjuw-gwura?” ");
INSERT INTO mle_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Vagaluwdiy duw takwawa duw nak ata wadid, “Kaliva-kwanadi duw, wunadi nyan diki dayim wudib takatipidid. Alik wun kwurin kariyatuwaad minak. ");
INSERT INTO mle_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","“Adi wudib dim viyakwanaad. Kwurkuw, kupwaar yakisada-kwadanaad. Kwudiyugw dayir wakwukuw, wuk vatikirikiykuw, gingin nakwanaad. Wun minadiy kalivaminadiy duwak bas situwadiy day adi wudib kwurin yakidakik. Aw day maa rav.” ");
INSERT INTO mle_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas a maaj wukikuw, dayak ata wadidiy, “Gwur bapa duw taakw wukijibiran maa ti. Nyi kas gwurawa kwakinadiwun? Nyi kas wuna mawul yay dakina gwurak? Adi nyan wunak akaray.” ");
INSERT INTO mle_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Adi nyan day ata kariyadaad dikik. Adi wudib Jisasaam vikuw, jayib ni adi nyan pitaad. Pitakuw, kupwaam vakirbagwukuw, kwudiyugw diki dayir wakwud. ");
INSERT INTO mle_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisas adi nyan dikidi asayik bas sidid, “Nabiy kas atawa tad?” Di ata waad, “Kwasaad tidilib atawadika kwurid. ");
INSERT INTO mle_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Adi wudib jaab samasam yaam takadid, guwaar yakidid dim viyasipak. Li min rivi-nadimin, nyanak wukikuw, sugwiyaan akwur nyanak.” ");
INSERT INTO mle_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisas ata waad, “Agwa jaav wunak wamina, ‘Li min rivi-nadimin?’ Duw wukijibiran tikida Godak, ababa jaav kwurkwadiy.” ");
INSERT INTO mle_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jayib ni adi nyan dikidi asaay ata waad, “Wukijibiran tinadiwun, aw maa rav. Sugwiyaan kwurminkik wunak wukijibir titak.” ");
INSERT INTO mle_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas ata vididiy nuwukadiy dikidiy kalivadidiy duw gipin vagaluwdiy dikik, aw nimadib wudibak wadid, “Min wanwa dayim takatipidi wudib, min awakw wadi nyinim! Wakwukuw, diki mawulaar ginyir sibinin warway!” ");
INSERT INTO mle_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Gaam sikuw, nyan kupwaam yakibagwukuw, ata wapadid. Wapakuw, adi nyan kiyanadi duw kitik rad. Duw taakw wadiy, “Di bwu kiyaad.” ");
INSERT INTO mle_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Aw Jisas nyan diki tabaam kwurkuw, kirapitakadik, adi nyan ata rapid. ");
INSERT INTO mle_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ginyir Jisas wiyaar wuladik, dikidiy kalivadidiy duw day kap diwa kwakuw, dikik ata wadaad, “Atata nyan kidi wudib kwurin yakiyak maa rav?” ");
INSERT INTO mle_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisas ata wadidiy, “Taay Godak beten kuw, gwur ata wudib yaki-kinadiygwur. Niki yawiy niki yawiy, a maa rav.” ");
INSERT INTO mle_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","A tip wapakuw, Galiliy-aam tiytiyaan tidiy. Jisas dikidiy kalivadidiy duwak kalivak. Alik di kwasik yad nuwukadiy duw taakw diki kwadadi tamiy wukik. Di dikidiy kalivadidiy duwak ata waad, “Ginyir day duw taakw dayadi Mwaam kwiykidanaad nuwukadiy duw daya tabaam. Adiy duw dim viyasipa-kidanaad. Kiyakuw, nyi mugwul yidaak, di ata rapikinaad.” ");
INSERT INTO mle_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Day maa wak kidiy majik, aw day yagadiy dikik bas sisak. ");
INSERT INTO mle_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Day Kapanam-aar wakwukuw, wiyaar wulakuw, Jisas dikidiy kalivadidiy duwak bas sididiy, “Yabir yakuw, agwa maaja bwulagwura?” ");
INSERT INTO mle_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Day maaj maa. Aw yabim day daya bwuladiy sikanadaad dayaam yitaypika duw tikinaad. ");
INSERT INTO mle_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisas daan rikuw, wataydidiy dayak dikik yadakikik. Yakuw, dayak wadidiy, “Sikadadaad yitaypika duw tikinaad, taay kwasaad tikwaad. Sugwiyaan yawiy kwurkwaad nuwukadiy duw takwak.” ");
INSERT INTO mle_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Di kwasa nyan kwurkuw, daya nyidim vatakadid. Taab wapwusikuw, dayak wadidiy. ");
INSERT INTO mle_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sikadadaad wunadi saam sukwasukw kwurkinaad kitampika nyinik, adi duw sukwasukw kwurkinaad wunak. Sikanadaad sukwasukw kwurkinaad wunak, aw wunadika maa, wunadi Asaywa nakab sukwasukw kwurkinaad. Asaay wayakidik, wun kilir yadiwun.” ");
INSERT INTO mle_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon dikik ata wadid, “Kaliva-kwanadi duw, duw nak vibaad. Di mawulaar yidiy wudib yakididiy minadi saam. Adi duw nyanawa maa kwu. Alik nyan watipibaad.” ");
INSERT INTO mle_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisas ata wadid, “Adi duw watipi-tikwa. Sikanadaad God diki mawulaam rina yawiy kwurnaad wunadi saam, ginyir kupwarapa maaj wunak wu maa. ");
INSERT INTO mle_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","“Sikadadaad nyanak maa wu maarkinaad, aad nyanadi kapa duw-ad. ");
INSERT INTO mle_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Mwiya maaj watuwadiygwur. Sikadadaad wukikuw gwur Krais dikidiy duw-adiygwur, alik guw kwiy-kidadiygwur kigwurkikik, aw God viyakit kwurkidaad dikik.” ");
INSERT INTO mle_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisas waad, “Kidiy wunak wukijibir tinadiy kwasadiy nyanugw, aw duw nak yakuw mwugiydik, alik dayaam nak bwan wunak kwiykida, aw li taay duw adi duwaam nimadi kabaak diki kwaliyapaam yaav tuwtakakuw, guwaar yakikuw, kiyakwaad, aal viyakita. ");
INSERT INTO mle_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Li gwuradiy taab mwugiy-daak, gwur vaal yikuw, adi taab ata alupw! Aal gwur taab maa, jaaw yaakiya. Aw li gwur taab vitiy tikuw, aw yiy yana tipaar nabiy nabiy kwakigwura, aal kupwarapa. ");
INSERT INTO mle_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","“A yiy day wabwubwup maa rav. ");
INSERT INTO mle_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Li gwuradiy maan mwugiydaak, gwur vaal yikuw, adi maan ata alupw! Aal gwur maan nak tikuw, adawur tipaar wulakigwura, aal viyakita. Aw li maan vitiywa yiy yana tipaar nabiy nabiy kwakigwura, aal kupwarapa. ");
INSERT INTO mle_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","“Yiy yana tipaam kawiy nabiy nabiy duw taakw dayadiy kwiy kikwanadiy. Adi yiy nabiy nabiy yankida. Kwas maa. ");
INSERT INTO mle_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Li gwuradiy mil mwugiydaak, gwur vaal yikuw, a mil nak gwakuw, ayak! Aal gwur mil nak tikuw, adawur tipaar wulakigwura, aal viyakita. Aw li mil vitiywa yiy yana tipaar nabiy nabiy kwakigwura, aal kupwarapa. ");
INSERT INTO mle_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“Yiy yana tipaam kawiy nabiy nabiy duw taakw dayadiy kwiy kikwanadiy. Adi yiy nabiy nabiy yankida. Kwas maa. ");
INSERT INTO mle_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Waliy kwas kwiyaam takadakib. Alik pwuk akis yay-kwanadiy. Atampik nyanaam yiy tikina. ");
INSERT INTO mle_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Waliy kwas viyakita jaava. Aw li waliy kwas wakwusakwulik, atata mwugiygwur viyakit tikina? Gwur bay yikwana waliy kwas kitik ada. Atawa tikuw, gwur yara kwakinadiygwur nuwukadiy duw takwawa.” ");
INSERT INTO mle_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas Kapanam wapakuw, Juwtiya tamiyaar daad. Dakuw, Jawtan bayib libwukuw, apika gikir vakiyid. Yadik, samasama duw taakw vagaluwdiy alim dikik. Yaan vagaruwdaak, nyanyi kalivadidiy. ");
INSERT INTO mle_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nuwukadiy Parasiy yadiy Jisasak vasibariyik. Alik dikik bas sidiy, “Li duw diki taakw wapakida, aal yaakiya?” ");
INSERT INTO mle_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Di dayak wadidiy, “Agwa maaj Mawsis gwuradiy gwalugwuk wadil?” ");
INSERT INTO mle_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Day ata wadiy, “Mawsis yaakiya waad. Aal duw diki takwaam wapak tidik, aw di wapa-kwadanadiy lapa nyig likik kwiykuw, diki takwaam ata wapakwaad.” ");
INSERT INTO mle_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisas dayak ata waad, “Gwur abab kabaak gwuradiy maka apaam rinadiygwur. Alik maaj wudiya bwu kwiydidiy. ");
INSERT INTO mle_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Mwiya tayir God ababa jaav yitakadik, alib kariyarib kitaan ab, ‘God duw taakw yitakadidiy. ");
INSERT INTO mle_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Alik duw dikibir amaay asaay wapakuw, di diki takwawa tikinaad. ");
INSERT INTO mle_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bir nak tikinabir.’ “Ginyir vitiy ti maa. Amwiy nak tikinabir. ");
INSERT INTO mle_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","“Agwa jaav God bwu tuwtakada, duw gwutaka-diba.” ");
INSERT INTO mle_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ginyir wiyaam kwadaak, dikidiy kalivadidiy duw dikik bas sidiy ki javik. ");
INSERT INTO mle_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Di ata wadidiy, “Sikadad diki taakw wapakuw, niki taakw kirakuw, aal taay takwak vaal yinaad. ");
INSERT INTO mle_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","“Taakw likidi duw wapakuw, nikidi duwak yin laan rikuw, aal taay duwak vaal yina.” ");
INSERT INTO mle_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nuwukadiy duw taakw dayadiy nyanugw kariyadadiy Jisasak dayaam taab takadikik. Aw Jisas dikidiy kalivadidiy duw a jaav vikuw, maa wadiy dayak. ");
INSERT INTO mle_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisas a jaav vikuw, pitaan warkuw, wariya kwudiy waad dikidiy kalivadidiy duwak. Di wadidiy, “Nyanugw wunak yakwadiy. Watipi-tikwa! God dikidi gwalugw kitampika nyanugw dayakid-ad. ");
INSERT INTO mle_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Mwiya maaj watuwadiygwurik. Sikanadiy rakarak ti maarkidiy God dayaam van tidikikik kwasa nyan dikik rakarak tikwadana pik, adi duw maa rav God dikidi gwalugwur valavalak.” ");
INSERT INTO mle_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jisas kwasadiy nyanugw nakanak diki tabaam kwurkuw, dayaam taab takadidiy. Di ata wadidiy, “God gwurak sukwasukw kwurkinaad.” ");
INSERT INTO mle_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ginyir, yabir yikuw, duw nak dikik gipin yaad. Yakuw, kwatiyir sikuw, Jisasak bas sidid, “Viyakita kalivanadi duw, agwa jaav wun kwurkuw, nabiy nabiy kwakidiwun?” ");
INSERT INTO mle_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas ata wadid, “Agwa javik wunak, ‘Viyakita-adimin,’ wanadimin? Godadika mwiya viyakit tinaad, nuwukadiy maa. ");
INSERT INTO mle_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“God diki lo maaj bwu wukimina, ‘Duw viyasipa-tikwa. Duw nikidi duw takwaam vaal yitikwa. Luwkuw kwur-tikwa. Gwiyip kwur maaj watikwa. Suwaal kwurin nikidi duw niki jaav niki jaav kwur-tikwa. Amaay asaay biriki majib awuk.’” ");
INSERT INTO mle_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Di Jisasak ata wadid, “Kalivakwanadi duw, wun kwasadi nyan tituwalib, wun adiy majib wukidiwun.” ");
INSERT INTO mle_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas adi duwaam vikuw, diki mawul yal dikik. Di ata wadid, “Niki jaav kip rina. Minadiy ababa jaav nuwukadiy duw takwak yapiykuw, adiy saan akwiy saal yinadiy duw takwak. Atawa kwurkimina adawur tipaam samasama jaav kwurkiminadiy. Atawa kwurkuw, wuna kwukib may.” ");
INSERT INTO mle_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A maaj wukikuw, diki maak vakiril. Di ata samasam wukid dikidiy niki jaav niki javik. Wukikuw, diki mawul pakwul. Ata Jisasaam wapadid. ");
INSERT INTO mle_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas aw van aw van vikuw, dikidiy kalivadidiy duwak ata waad, “Samasama jaav tinadi duw God dikidi gwalugwur valavalak wukikida, dikim vaat yikina.” ");
INSERT INTO mle_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Adiy kalivadidiy duw pitaan wardiy diki majik. Jisas alib wadidiy, “Wunadiy nyanugw, aal nima yawiya duw God dikidi gwalugwur warik. ");
INSERT INTO mle_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","“Jaay tupwur kamil kwusawula kwusawulak a nima yawiyal. Aw mwiya nima yawiya samasama jaav tinadi duw God dikidi gwalugwur valavalak.” ");
INSERT INTO mle_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Day ata nimadib pitaan wardiy. Pitaan warkuw, ata wadiy, “Atawa tikuw, atata atata duw taakw God dikidi gwalugwur valakinadiy?” ");
INSERT INTO mle_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas dayak van napakuw, wadidiy, “Duw maa rav, aw God rivinaad ababa jaav kwurik.” ");
INSERT INTO mle_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita ata wadid Jisasak, “Awuk! Nyan ababa jaav bwutaay wapakuw, mina kwukib yanadiyan.” ");
INSERT INTO mle_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jisas ata waad, “Kal mwiya maaj watuwadiygwurik. Sikanadaad wunak wukijibiran tikuw, dikidiy wiy, nyamwus, mwaam, jikwaar, amaay, asaay, nyanugw, kupw, wapadidiy wunawa wuna viyakita majik, di samasam nuwukadiy wiy, nyamwus, mwaam, jikwaar, amaay, nyanugw, kupw ki kupwaam kwurkidadiy. A nyi nuwukadiy duw jawjaay kwurkinadiy dikik. Di atawa tikuw, aw ginyir nabiy nabiy yara kwakinaad. ");
INSERT INTO mle_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Kita samasam day yitaypik tinadiy ginyir mwiya yisadayaki-kinadiy. Aw kita samasam day yisadayaki-nadiy ginyir day yitaypik tikinadiy.” ");
INSERT INTO mle_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jiruwsalimaar warik tidaak, yabasaay yidiy, Jisas taay nuwukadiy diki kwukir. Kalivadidiy duw pitaan wardiy. Nuwukadiy duw taakw, day kwukib, day yagadiy. Jisas dikidiy tabatiy maan vitiy duw kwurkuw, gwutakaan yin walibab ril tamiyaam, wadidiy ababa jaav nuwukadiy duw ginyir dikik kwurkidana. ");
INSERT INTO mle_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Di ata waad, “Wukigwura, nyan Jiruwsalimaar warkibana. Warkuw, adi duw nak duw taakw dayadi Mwaam sapakwa nyanugw pris awa God diki lo kalivanadiy duwak kwiykidadiwun. Day kiyadikik wakinadiy. Wakuw, day wun niki jaka tipa kidiy bapa duwak kwiy-kidanadiwun. ");
INSERT INTO mle_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","“Kwiydaak, day wunak wajibay-kidanadiwun. Wunaam likasip sataka-kidanadiwun. Wunaam ramiy tinadi miyaar viya-kidanadiwun. Viyaan napakuw, wunaam ata viyasipadaak, kiyakinadiwun. Ginyir nyi mugwul yidaak, wun rapikinadiwun.” ");
INSERT INTO mle_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jamisawa Jon, Sipatiy dikibir nyidiy, bir ata Jisasak yabir. Bir wabirid, “Kaliva-kwanadi duw, jaav nak an kwurminkik anak.” ");
INSERT INTO mle_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisas birak ata wadibir, “Agwa jaav bir kwurtuwkik birak.” ");
INSERT INTO mle_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bir ata wabirid, “Ginyir min ababa duw taakw dayadi yitaypika duw tikimina, an nak mina mava tabaam nak mina akiy tabaam, atawa an daan ritik.” ");
INSERT INTO mle_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisas birak ata wadibir, “Bir maa laakw wunak bas sibira javik. Wunak kupwaraap yakinadiy jaav kitampika jaav birabab kwurkinabirbir, likir? Wun kwurkituwa baptais kitampik kwurkinabirbir?” Jisas wukidil ginyir duw jawjaay kwurkuw dikik, viyasipa-kidanaad. Alik atawa wadibir. ");
INSERT INTO mle_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bir ata wabirid, “An bwunak kwurkita.” Jisas birakik ata wadibir, “Wunak yakinadiy jaav, kitampik kwurkinabirbir. Wun kwurkituwa baptais kitik, birabab kwurkinabirbir. ");
INSERT INTO mle_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“Aw wunabir mava tabawa akiy tabaam rikinabir duw wun kwar maa. God diki yawiya. Ginyir di tasakwu-kidabir diki mawulaam rinabir duw.” ");
INSERT INTO mle_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dikidiy nuwukadiy tabatiy duw a jaav wukikuw, wariya kwudiy wadiy Jamisawa Jonak. ");
INSERT INTO mle_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Alik Jisas dayak gaam sididiy yaan vagaluwdakik dikik. Day yakuw, di ata wadidiy, “Gwur wukigwura ababa nuwukadiy jaka tip dayadiy van tinadiy duw ap kwurnadiy, dayadiy duw takwak van tikuw. Aw dayadiy mawulaam van tikwanadiy. ");
INSERT INTO mle_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Gwur kitampik maa ti. Li duw nak gwuraam yitaypik tikir, di gwuradi yawiy duw tikwaad. ");
INSERT INTO mle_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","“Li gwuraam duw nak yitaypika duw tikir, aw di nuwukadiyik kipa yawiy duw tikwaad. ");
INSERT INTO mle_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","“Atawa duw taakw dayadi Mwaam maa yi nuwukadiy duw taakw yawiy kwurdakik dikik. Di nuwukadiy duw takwak sugwiyaan kwurik yaad. Di yaad samasama duw taakw dayadiy valik kiyak. Kiyakuw, di dayadiy vaal yapiy-kidadiy.” ");
INSERT INTO mle_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Day Jarikaw a tipaar yadiy. Day ata Jarikaw wapakuw, Jisas dikidiy kalivadidiy duwawa samasama duw taakw diwa yidiy. Timayis dikidi nyan, Batimayis, di mala yabim rad. Mil tipidi duw-ad. Atawa ritaay, sanak wasukwud. ");
INSERT INTO mle_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Di ata wukidil, Jisas Nasarit tipa kid yanaad wakuw. Wukidik, “Jisas, Davit dikidi gwalugwa duwadimin, wunak awuk!” ata gaam sad. ");
INSERT INTO mle_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Samasama duw dikik wariya kwudiy wakuw wadaad, “Min kaygan ada!” Aw di ata nimadib gaam sad, “Davit dikidi gwalugwa duw-adimin, wunak awuk!” ");
INSERT INTO mle_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisas walibab tikuw, tawtaykuw, ata wadid, “Gwur wagwur walib yakwaad.” Day ata mil tipidi duwak wadaad, “Yaakiya, min arap! Di minak wataynaad.” ");
INSERT INTO mle_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jayib ni diki rabwudidi wapwiy wapakuw, rapikuw, Jisasak ata yaad. ");
INSERT INTO mle_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisas ata wadid, “Minak agwa jaav kwurtuwakik?” Mil tipidi duw ata waad, “Sapakwa duw, wunabir mil sipwutiy-minakik.” ");
INSERT INTO mle_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas ata waad, “Min maay! Min wukijibiran timin, alik minabir mil abirka yara tinabir.” Ata jayib ni vidibir, dikibir mil. Vikuw, ata Jisasak kwukib yad yabir. ");
INSERT INTO mle_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Day yikuw, Jiruwsalim walibab tidiy. Tikuw, kwasabir tip vitiy ribir, birakibir si Bitpasawa Bitaniy. Mala nibwukim ribir. Adi nibwuk si Aliv. ");
INSERT INTO mle_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jisas dikidiy kalivadibir duw vitiy wadibir, “Alaay tipaar maay! Yikuw, tipaar wulakuw, dagiy alim sitakira-kibiraad. Yaav tuwtakada, tinaad. Badiy dagiy ad. Dim duw maa ri nibway. Raliykuw, kilir kwurin akaray. ");
INSERT INTO mle_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Li duw taakw birak bas sikidiy, ‘Agwa javik kwurbiraad?’ wakuw, bir dayak aw, ‘Nyanadi yitaypika duw yawiy kwurdikik dim. Yawiy kwusilik, yabiyib sibinin wayakikidaad.’” ");
INSERT INTO mle_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bir yikuw, a dagiy ata vibirid. Mala yabim taga wiyaam tuwtakadaak, tad. Ata vikuw, raliybirid. ");
INSERT INTO mle_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Alim tidiy duw taakw birakik bas sidabir, “Wadi dagiy agwa jaav kwurik raliy-biraad?” ");
INSERT INTO mle_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bir Jisas diki maaj wabiridiy. Wabir, yaakiya wadiy. ");
INSERT INTO mle_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ata adi dagiy kariyabirid. Jisasak kwiykuw, ata birakidiy wapwiy dagiy bwunim takabiridiy. Takakuw, Jisas ata warin ridid dagiy bwunim. ");
INSERT INTO mle_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Duw taakw samasam dayadiy wapwiy yabim yapirtaka-dadiy. Nuwukadiy duw taakw gagawa ba miy samasam kwurkuw, yabim takadadiy. ");
INSERT INTO mle_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Adiy taay Jisasak, adiy kwukir, abab rakarak tikuw, gaam sidiy, “A! God viyakit kwurkwanaad kidi God dikidi saam yanadi duwak! ");
INSERT INTO mle_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Kidi duw nyanak van tikidadiyan nyanadi warag Davit kitik! God yara kwurkwaad dikik! God di mwiya viyakit-ad!” ");
INSERT INTO mle_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas Jiruwsalimaar ata wulaad. Wulakuw, God dikidi wiyaar wulaad. Wiyaar wulakuw, adiy wiyaam tidiy jaav ata jawdidiy. Vitaay tidik, ata kaylapwul. Kaylapwulik, ata wakwun yad Bitaniy-aar dikidiy tabatiy maan vitiy duwawa. ");
INSERT INTO mle_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sira pik Bitaniy-aam kwakuw, sibinin yadaak, Jisas kaam yasad. ");
INSERT INTO mle_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Di miy, si vik vidid. Gaag samasam rad. Kwasa sikaam tad. Di adi miy diki mwiy kikir. Yikuw, vidid gagadika rad. Mwiy ri nyi maa nibway. ");
INSERT INTO mle_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Adi miyak ata wadid, “Duw ni ginyir minadiy mwiy kwurin ki maa.” Dikidiy kalivadidiy duw diki maaj wukidaal. ");
INSERT INTO mle_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Day Jiruwsalimaar wuladaak, Jisas God dikidi wiyaar wulaad. Adiy abab yapiydiy duw takwak Jisas watipisakwu-didiy. Ababa saan warapiydiy duw dayadiy jaab abab kaybilaki-didiy. Midakim wapiy yapiydadiy duw dayadiy tikir wapayakidik, vakirdiy. ");
INSERT INTO mle_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jisas ata wadidiy, “Niki jaav niki jaav yataway God dikidi wiyaam.” ");
INSERT INTO mle_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jisas duw takwak ata kalivadidiy. Di wadidiy, “Gwur maa wak God diki maaj lapa nyigaam rina maaj, ‘Ababa tipa kidiy duw taakw valakwadiy wunadi wiyaar Godak maaj bwulak.’ Aw gwur gwura mwugiy-gwuril luwkuw kwurnadiy duw daya tamiya.” ");
INSERT INTO mle_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sapakwa nyanugw pris, God diki lo kalivadiy duwawa a jaav wukikuw, day Jisasaam viyak kwakibagwudiy. Ababa duw taakw paydiy diki majik. Alik adiy sapakwa nyanugw pris, God diki lo kalivadiy duwawa yagadiy Jisasak. ");
INSERT INTO mle_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nyi tipwudik, duw gaan wakwala pik, Jisas dikidiy kalivadidiy duwawa ata adi tip wapadaad. ");
INSERT INTO mle_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Niki nyi ganib yabir yikuw, vidaal adi miy vik bwu rik yad. Gaag, ba miy, maja miy miyawa bwutaay rik yad. ");
INSERT INTO mle_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita wukikuw, Jisasak ata wadid, “Sapakwa duw, av! Adi watipi-minidi miy bwutaay rik yad.” ");
INSERT INTO mle_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisas ata wadidiy, “Godak wukijibir ada. ");
INSERT INTO mle_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Mwiya maaj watuwadiygwurik. Li duw nak kidi nibwukik wakida, ‘Arap! Guwaam avakir!’ aw mawul vitiy ti maarkuw, wukijibiran tikida, ad vakir-kinaad guwaam. ");
INSERT INTO mle_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“Alik watuwadiygwur, Godak wakigwura nyi agwa jaav bas sikigwura, dikik mwiyir wukijibir tikigwura, adiy jaav kwiykidadiygwur. Aw adiy jaav bwutaay gwuradiy-adiy. ");
INSERT INTO mle_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Gwur Godak maaj bwulak tikuw, aal kupwarapa mawul tikigwura nikidi duwak, taay a jaav awap. Ata gwuradi adawur tipaam kwanadi Asaay gwuradiy mawulaam rinadiy vaal di yibwiy-kidadiy. ");
INSERT INTO mle_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Li gwur nuwukadiy duw taakw dayadiy gwuraam yidadiy vaal yibwiy maarkigwura, ata God gwuradiy vaal yibwiy maa.” ");
INSERT INTO mle_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Day ata sibinin yadiy Jiruwsalimaar. Jisas, God dikidi wiy yala wiyaam tiytiyaan tidik, sapakwa nyanugw pris awa God diki lo kalivadiy duw sapakwa nyanugw dikik yadiy. ");
INSERT INTO mle_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Day dikik bas sidiy, “Agwa apa tikuw, kidiy jaav kwur-minadiy? Minak ap kwiyid, sikanadaad?” ");
INSERT INTO mle_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas dayak ata wadidiy, “Wun jaav naka bas sikir gwurak. Aw wunak wakigwura, wunak ap kwiydi duwad wakituwaad gwurak. ");
INSERT INTO mle_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","“Sikanadaad Jonaam wayakid baptais kwiydikik? Godad? Ay duwadiy? Wunak aw!” ");
INSERT INTO mle_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","32","Day awarwa awarwa maaj bwulabagwudiy. Day daya ata wadiy, “Nyan atata atata wakinadiyan? Aw li nyan, ‘God-ad,’ waan wakibana, di nyanak, ‘Agwa javik gwur diki majib wak maargwuril?’ wakinaad. Aw li nyan, ‘Duw-adiy,’ wakibana,...” Day duw takwak yagadiy. Agwak, abab wukidiy Jon God diki maaj wasapwiydi duw-ad. ");
INSERT INTO mle_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Alik day Jisasak ata wadaad, “Nyan maa wak.” Jisas dayak ata wadidiy, “Wunabab gwurak wu maa, agwa apak kidiy jaav kwurtuwadiy.” ");
INSERT INTO mle_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas dayak waya maaj kitika maaj ata wadidiy. Di dayak wadidiy, “Duw nak, bajagay si girap dikidi mayim sididiy. Sikuw, kabaka yarip kaypwusidid. Di kaw ata vadid. Ginyir girap dayadiy mwiy alim manir vasi-kidanadiy. Kwasa wiy ata kwurdil apiy yaripaam van tidiy duwak. Yawiy kwurdiy duw daya tabaam ata takadid adi maay. Takakuw, sikaam ril tipaar ata yad. ");
INSERT INTO mle_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Girap lawdaal nyi, yawiy duw nak wayakidid dayak diki am kwurdikik. ");
INSERT INTO mle_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","“Aw day dim kaykitikuw, viyaan napakuw, wayakidaak, ata yad tabadika. ");
INSERT INTO mle_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Adi maay asaay nuwukadi yawiy duw ata wayakidid. Aw day diki abwaam viyakuw, jawjaay kwurdiy dikik. ");
INSERT INTO mle_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Nuwukadi yawiy duw wayakidik, day viyasipadaad. Nuwukadiy wayakikuw, nuwuk viyadadiy, nuwuk viyasipadadiy. ");
INSERT INTO mle_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ginyir nikidi duw maa ti. Dikidi mawul yididi nyan-ad, didika. Di ata wayakidid dikid mayim yawiy kwurdiy duwak. Diki mawulaam waad, ‘Day wukikinadiy wunadi nyinik.’ ");
INSERT INTO mle_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Aw adiy yawiy duw day daya wadiy, ‘Kidi duw maay asaay dikidi nyan-ad. Dim viyasipanaak. Dim viyasipakuw, kidi maay nyanadi maay tikinaad.’ ");
INSERT INTO mle_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","“Alik dim kaykitikuw, viyasipakuw, diki amwiy kawaar yakisakwudaal.” ");
INSERT INTO mle_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisas ata bas sad, “Agwa jaav adi maay asaay kwurkinaad? Di yakuw, adiy duwaam viyasipakuw, adi maay nuwukadiy yawiy duwak ata kwiykidaad. ");
INSERT INTO mle_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","“Ki God diki lapa nyigaam rina maaj vigwura, ay maa? ‘Adi kabaak, tayir wiy kwurdiy duw maa wadiy dikik, Kita nimadi kabaak abwa tibawa rinaad. Yitaypika Duw a jaav kwurdil, nyan vikuw, ata paynadiyan.’” ");
INSERT INTO mle_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Juw dayadiy sapakwa nyanugw lakwudaal Jisas dayadiy yawiyik a waya maaj kitika majir wadidiy. Alik day dim kalakwuk. Aw day vagaluwdiy duw takwak yagadiy. Alik Jisasaam wapakuw, ata yidiy. ");
INSERT INTO mle_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nuwukadiy Parasiyawa nuwukadiy Yirat bapa duw wayakidadiy Jisasak diki majik vasibariyik. ");
INSERT INTO mle_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Day yakuw, dikik ata wadaad, “Kalivanadi duw, nyan lakwu-nadiyan min viyakita duw-adimin. Ababa duw taakw rivriv tinadiy minak. Yitaypika duwak niki maaj maa, maaj nak. Min God diki maaj mwiyir kaliva-kwanadimin. Nyan takis Rom dayadi yitaypika duw Sisak kwiynaak? Ay maa? Nyana lo atata wana a javik?” ");
INSERT INTO mle_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jisas lakwudil day tikal vitiy tidiy. Alik di dayak ata wadidiy, “Agwa javik gwur gwiyip kwur-gwuradiwun? Saan wunak akwutay wun vikir.” ");
INSERT INTO mle_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Day nak dikik kariyakuw, di dayak bas sididiy, “Kidi kayik mwutamawa si av. Sikadadaad?” Day ata wadaad, “Siysa dikibir-abir.” ");
INSERT INTO mle_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jisas ata wadidiy, “Yaakiya, Siysa dikidiy jaav dikik akwiy. Aw God dikidiy jaav dikik akwiy.” Day a maaj wukikuw, ata pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Niki bapa duw, si Satuwsiy, day dayadiy mawulaam wadiy duw kiyakuw, ginyir rap maa. Nuwukadiy Jisasak ata yadiy. ");
INSERT INTO mle_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Day dikik wadaad, “Kalivanadi duw, Mawsis ki maaj sukwudil nyanak, ‘Duw kiyakuw, aw nyan maa, diki taakw kip kwaal, adi duw dikidi mwaam diki taakw kiraan tikida. Li ata nyanugw sapwiy-kiladiy likidi taay duwak.’ ");
INSERT INTO mle_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Tayir abitiy nyamwus mwaam tidiy. Dayadi mwaam taakw kirakuw, ata kiyaad aw di nyan maa ti. ");
INSERT INTO mle_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","“Ginyir duw a taakw kirakuw, ata kiyaad. Dibab nyan maa ti. Aliba nyamwus a taakw kirakuw, ata kiyaad. ");
INSERT INTO mle_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","“Atawa adiy duw abitiy kiradaal. Aw day abab nyan ti maarkuw kiyadiy. Aw daya kwukib a taakw ab kiyaal. ");
INSERT INTO mle_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Ginyir God abab kiyanadiy duw taakw kirapitaka-kida nyaam, a taakw sikadi duw taakwa? Tayir duw abitiy kiradaal.” ");
INSERT INTO mle_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas dayak ata wadidiy, “Gwura maaj viyakit maa. God diki lapa nyigaam rina maaj gwur maa laakw. God diki ap ab gwur maa laakw. ");
INSERT INTO mle_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","“Ginyir God kiyanadiy duw taakw kirapitakadik, day adawur tipaam kwakinadiy God diki maaj kardadiy duw kitik. Alim duw taakw kirakir maa. ");
INSERT INTO mle_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Ki kiyanadiy duw rapa majik gwur Mawsis lapa nyigaam sukwudil maaj kwasadi miyaam yadi yiyak vigwura? Ay maa vi? A nyaam God Mawsisak wadid, ‘Wun Aparam Aysakawa Jakap dayadi God-adiwun tikwanadiwun.’ ");
INSERT INTO mle_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“Aw di God atawa waad kiyadiy duwak. Di waad day bwu kwanadiy. Alik God di kwakwanadiy duw taakw dayadi God-ad. Gwura maaj alik maa mwiyir ti.” ");
INSERT INTO mle_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","God diki lo kalivadi duw nak yakuw, di wukidil day maaj warjuwdiy. Aw di wukidil Jisas dayak viyakita maaj wadidiy. Di Jisasak ata bas sidid, “Agwa lo-al ababa lo-aam kakilna?” ");
INSERT INTO mle_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Jisas dikik ata waad, “Ki lo taay lo-a, ‘Gwur Yisrayil tipa kidiy duw taakw awuk! God nyanadi Yitaypika Duw, di nak-ad. Aywa maa. Gwuradiy maan taab, ap bwan, mawul miyawa Yitaypika Duw gwuradi Godak yikwadiy.’ ");
INSERT INTO mle_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Ki lo ginyir lo-a, ‘Gwur gwurak wuki-kwanadiygwur, atawa walibab tinadiy duwak ab awuk.’ Nuwukadiy lo kibir lo-aam kakil kakil maa rav.” ");
INSERT INTO mle_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","God diki lo kalivadi duw Jisasak ata waad, “Aal viyakita. Kalivanadi duw, mwiya maaj waminaala. God di nak-ad, nikidi god maa ti. ");
INSERT INTO mle_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","“Duw dayadiy maan taab, ap bwan, mawul miyawa Godak yikwadiy. Duw day dayak wukikwanadiy atawa walibab tinadiy duwak ab wukikwadiy. Kibir jaav abab Godak yaam takakwanadiy javim, viyasipa-kwanadiy Godak javim kakilnabir.” ");
INSERT INTO mle_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas wukidil diki maaj viyakita maaja. Alik wadid, “Min God dikid gwalugw walibab wulaan tinadimin.” Ababa duw taakw a maaj wukikuw, yagadiy. Alik nuwukadiy javik maa bas si, yagakuw. ");
INSERT INTO mle_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas God dikidi wiyaam kalivadik, di duw takwak bas sididiy, “Atata atata God diki lo kalivanadiy duw wakwanadiy God dikidi Tasakwudidi Duw, Davit dikidi gwalugwa duwadika tikinaad? ");
INSERT INTO mle_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“God dikidi Mawul mwugiydik, Davit ki maaj wadil: God wunadi Yitaypika Duwak wadid, ‘Kilim wuna mava tabaam daan ada. Rikuw, wun kwurkuw, minadiy mama duw apiy baw manim tiytiyaan tikinadimin.’” ");
INSERT INTO mle_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Davit sikiydid, ‘Wunadi Yitaypika Duw.’ Alik atata Davit gwalugwa duwadika tinaad?” Alim vagaluwdiy duw taakw samasamadiy rakarak tidiy diki majik. ");
INSERT INTO mle_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Di dayak kalivadik, di wadidiy, “Gwur yarakara van ada God diki lo kalivanadiy duwak. Day nimadiy wapwiy luwkuwkuw, tiytiyaan tikir. Duw taakw vagaruwdadi tamiyaam day wukik abab wayapiy sidadiy dayak. ");
INSERT INTO mle_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","“Day sapakwa nyanugw tikir kwurkwadadiy gaba maja wiyaam. Kikipaat bayaki nyi taay wakwun rikwanadiy. ");
INSERT INTO mle_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Day simiy gaba maaj apaapap sikwanadiy Godak. Aw adiy tawtakwak kidiy duw gwiyip kwurkuw, dayadiy niki jaav niki jaav luwkuw kwurkwadanadiy. Alik ginyir God diki kotim tidaak, God dayak jawjaay kwurkuw, daya kagil kakilkina.” ");
INSERT INTO mle_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas saan Godak kwiydadi tamiy walibab ridik, di duw taakw saan takadadiy vididiy. Saan samasam tidiy duw taakw saan samasam takadadiy. ");
INSERT INTO mle_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Taakw ni, likidi duw bwu kiyaad, likim saan aywa maa. Li yakuw, vitiy kwasabir saan, toea nak kitik, takalibir. ");
INSERT INTO mle_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Jisas dikidiy kalivadidiy duwak gaam sididiy yadakikik dikik. Yakuw, di dayak wadidiy, “Mwiya maaj watuwadiygwur. Ki taakw takalibir saan, ababa nuwukadiy duw taakw dayadiy takadanadiy sanaam kakilnabir. Dayaam saan samasam rinadiy. Aw day dayadiy kip rinadiy saan takanadiy. Aw ki taakw, likim saan aywa maa. Aw likidiy ababa jaav takalidiy. Likibir kikipaat yapiy saan takalibir.” ");
INSERT INTO mle_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas God dikid wiy wapakuw, dikidi kalivadidi duw Jisasak wadid, “Kaliva-kwanadi duw, av! Kidiy nimadiy kabaak viyakit-adiy. Kidiy wiy ab viyakit-adiy.” ");
INSERT INTO mle_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisas ata wadid, “Kidiy nimadiy wiy viminadiy? Day kidiy wiy piradaak, adiy giliyim tinadiy kabaak yakisadakuw, kapakap kapakap tikidiy.” ");
INSERT INTO mle_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas Aliv wadadi nibwukim rad. Rikuw, God dikid wiyak vad. Atawa di diki daan ridik, Pita, Jamis, Jon, Adiruw, duw aliy, dim kap yin maak takadiy. ");
INSERT INTO mle_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Day bas sidaad, “Nyanak aw akasikir kidi jaav wakwu-kinaad? Nyanak aw agwa jaav taay wakwudik, nyan vikuw, lakwu-kibana kidi jaav ata wakwu-kinaad?” ");
INSERT INTO mle_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisas dayak wasapwiydidiy, “Gwur yarakara ada, nuwukadiy duw gwurak yaan gwiyip kwurik-nadiy. ");
INSERT INTO mle_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","“Samasama duw yakuw, wunadi si kwurkuw, ‘Wun God dikidi Tasakwudidi Duw-adiwun’ wakuw, duw takwak samasam gwiyip kwurkidanadiy. ");
INSERT INTO mle_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Wariy walibab tidaak, dayadiy pipiliy wukikuw, yagaan kwurway. Sikaam tinadiy wariya maaj wukikuw, yagaan kwurway. Adiy jaav yaan maak takakinadiy. Aw ababa jaav kwusikila nyi wayway nibway. ");
INSERT INTO mle_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","“Nikidi jaka tip yikuw, nikidi jaka tipawa wariya-kinadiy. Nikidi gavman yikuw, nikidi gavman awa wariya-kinadiy. Niki tip niki tipaam nanaaw yakinadiy. Kaam yasa-kiladiy nyi yakinadiy. Kidiy jaav taakw liki taay yip kitik tikinadiy. ");
INSERT INTO mle_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Gwur gwura yara awuk. Duw gwuraam kalakwukuw, kotiy ik karay-kidadiygwur. Gaba maja wiyaam viyakidadiygwur. Wunak gwur van tinadiy duw yitaypika duwawa daya yaligim tikuw, dayak wuna viyakita maaj wasapwiy-kigwura. ");
INSERT INTO mle_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","“Taay, duw wuna viyakita maaj ababa duw takwak wasapwiy-kwadiy. ");
INSERT INTO mle_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Day gwuraam kalakwukuw, kotiy ik karaykuw, gwur yaga-gwuraba agwa jaav wakigwura. A nyaam God gwurak kwiykida maaj aw. Gwur gwura maa, God dikidi Mawul a maaj wasapwiy-kinaad. ");
INSERT INTO mle_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Duw dayadiy nyamwus mwaam kwiy-kidanadiy mwiya mwiyab viyadakik. Asaay dayadiy nyanugw atampik. Nyanugw amaay asayik mawul kupwaraap tilik, kwiy-kidanadiy mwiya mwiyab viyadakik. ");
INSERT INTO mle_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","“Gwur wunadiy-adiygwur, alik abab dayadiy mawul kupwaraap tikinadiy gwurak. Sikanadaad bwan kway maarkinaad Godak, yin diki kiyakida nyaam God adi duw kwurkidaad.” ");
INSERT INTO mle_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ginyir tip kupwaraap rikinadi jaav vikigwuraad. Adi jaav watipida tamiyaam tikinaad.” Ki maaj vikuw, duw taakw ki jaav lakwu-kwadiy. “A nyaam Juwtiya tamiyaam kwakinadiy duw taakw nibwukir tabwu-kwadiy. ");
INSERT INTO mle_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Duw alawur maka kwar wiyaam kwakuw, dadiba niki jaav niki jaav wulaan kwurik. ");
INSERT INTO mle_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","“Mayim kwakinadi duw di wiyaar wuladiba dikid wapwiy kwurik. ");
INSERT INTO mle_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Yalawa tikinadiy taakw, nyanugwak mwuny kwiykinadiy takwawa kupwiyayugw, dayak wukinadiwun a nyaam. ");
INSERT INTO mle_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Gwur Godak bas as ki jaav yakik-na kwayugw ababa tamiy maripa-kidadiy nyaam. ");
INSERT INTO mle_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“A nyi mwiya kupwarapa nyi tikina. God yitakadil nyi ki kupw yaan aw kita atampik kupwarapa nyi maa ti. Ginyir ginyir atampik ti maa. ");
INSERT INTO mle_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Adiy nyi God bwutaay walib varubwu-didiy. Aw di atawa kwar maardik, duw nak kwakwu maa. Di dikidiy tasakwudidiy duw takwak wukididiy. Alik di walib varubwu-didiy adiy nyi.” ");
INSERT INTO mle_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Li duw nak gwurak wakinaad, ‘Av! God dikidi Tasadwudidi Duw kilim kwanaad,’ aw duw nak gwurak wakinaad, ‘Av! Alim kwanaad,’ gwur wukiway. ");
INSERT INTO mle_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Adiy ‘Wun God dikidi Tasakwudidi Duw-adiwun,’ adiy ‘Wun God diki maaj wasapwiydi duw-adiwun’ wakinadiy duw, suwaal kwurik God dikidiy tasakwudidiy duw takwak. Day God dikidiy mawulaam rinadiy yawiy kitika yawiy kwurkinadiy a javik. ");
INSERT INTO mle_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","“Alik tikuw, gwur yarakara ada! Wun bwu watuwadiygwur taay ababa javik.” ");
INSERT INTO mle_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“Ginyir adiy nyaam adiy mwiya kupwarapa nyi kwusidaak, nyi si maa, bap si maa. Tugwiy, kwungar tubwaam tikuw, vakirkidiy. Ababa tubwaam tinadiy jaav yin yaan tikidiy. ");
INSERT INTO mle_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Duw taakw dayadi Mwaam day ata vikidanaad. Di tubwaar yakinaad mwiya nimadi apawa. Wav samasam yikinaad. ");
INSERT INTO mle_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","“Di dikidiy maaj kardadiy duw wayaki-kidadiy ababa tipaar miyawa tamiyaam dikidiy tasakwudidiy duw taakw vagaruwdakik.” ");
INSERT INTO mle_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Miy si vik di simaka-kidadiygwur ki javik. Ba miy kwany ridaak, lakwu-kinadiygwur waal jakida nyi aka walibab tina. ");
INSERT INTO mle_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","“Kitampik gwur kidiy jaav vikuw, lakwu-kigwura duw taakw dayadi Mwaam yaan walibab tikinaad. ");
INSERT INTO mle_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Mwiya maaj watuwadiygwurik. Ki nyaam kwanadiy duw taakw kwas maa nibway, kidiy jaav wakwukuw, taay vikidanadiy. ");
INSERT INTO mle_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","“Adawur tipawa ki kupw kwusikinabir. Aw wuna maaj kwas maa.” ");
INSERT INTO mle_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Miyawa duw day maa laakw akasikir yakina, ki nyi. Adawur tipaam kwanadiy maaj kardadiy duw, day maa wak. God dikidi Nyan ab, di maa wak. Wunadi Asaydika lakwu-naad a javik. ");
INSERT INTO mle_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Gwur yarakara ada. Gwur maa laakw akasikir a nyi yakina. ");
INSERT INTO mle_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Kitampik duw nak diki wiy wapakuw, niki tipaar vikir. Taay di dikidiy yawiy kwurdiy duw tasakwudidiy day van kwadakikik dikidiy javik. Day dayadiy yawiy kwurkwadiy. Di dikidi van tidi duwak ata waad, ‘Min yarakara ada.’ ");
INSERT INTO mle_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Gwur maa laakw ki wiyak kidi asaay diki sibinin yakida nyi. Giraab, ay? Nyidi gaan, ay? Tapwuk bas wadik, ay? Ganbab yakinaad? Gwur alik yarakara ada. ");
INSERT INTO mle_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","“Di yakuw, vikidadiygwur. Si kwa-gwurba. ");
INSERT INTO mle_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Ki watuwa maaj gwurak wun ababa duw takwak watuwadiyik: Yarakara ada!” ");
INSERT INTO mle_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nyi vitiy kip ribir ababa Juw Duw Takwaam God Nyigildidiy Nyawa Yis Maa Ti Bret bayaki kikipaat kikinadiy. Ababa sapakwa nyanugw pris awa God diki lo kalivadiy duw day kwakidiy atatawa Jisasaam kalakwukuw, viyasipak. ");
INSERT INTO mle_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Day wadiy, “Bayaki nyaam nyan atawa kwar maa, ababa duw taakw pitaan warik-nadiy.” ");
INSERT INTO mle_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas lepa duw Sayman diki wiyaam kwaad Bitaniy tipaam. Kikipaat kidik, taakw nak tukwur vaak yataan wulaal yala wiyaar. Adi tukwur vaak, yala vakaam waliy guw, si nat, tal. Saan samasam yapiy-kwanadiy. Li viyawutakuw, adi viyakita yaam yayna waliy guw Jisas diki abwaam kaykwatakalid. ");
INSERT INTO mle_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Nuwuk a jaav vikuw, mawul wardiy. Nikim nikim bwuladiy, “Agwa javik tikuw, ki waliy guw kip yakila? Yapiyik ti wiy yapiy-kwadiy. Jilig duwamiy nak sap tabatiy yapiy-kwadanaad. Adiy saan kwiykwa saal yinadiy duwak.” A takwak wariya kwudiy wadaal. ");
INSERT INTO mle_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisas ata waad, “Li kip rikwa. Agwa javik tikuw, sapis jikigwura likik? Kal viyakita jaava wunak kwurla. ");
INSERT INTO mle_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","“Saal yinadiy duw nyanyi gwurawa kwakwanadiy. Aw gwur sukwasukw kwurkwagwura mawul warkigwura nyaam. Wun gwurawa nyanyi kwu maa. ");
INSERT INTO mle_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","“Li rivina yawiya wunak kwurla. Li waliy guw taay wunaam kaykwatakakuw, aw ginyir kawaam taka-kidanadiwun, a javik. ");
INSERT INTO mle_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Mwiya maaj watuwadiygwurik. Ginyir viyakita maaj kwiydaak ababa tipaam, day ki kwurla javik wakinadiy. Duw taakw wukimar maa likik.” ");
INSERT INTO mle_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Juwtas Yiskariyat, Jisas dikidiy tabatiy maan vitiya duw nak-ad. Di sapakwa nyanugw pris ak yad Jisas dayak kwiyik. ");
INSERT INTO mle_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Day rakarak tidiy diki maaj wukikuw. Day maaj lakatiydiy dikik saan kwiyik. Juwtas Jisas dayak kwiy nyak ata kavin kwaad. ");
INSERT INTO mle_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Taay nyaam, Yis Maa Ti Bret bayaki nyaam, day sipsip nyanugw viyasipadadiy God Nyigildidiy Nyi bayaki kikipatik. A nyi Jisas dikidiy kalivadidiy duw dikik bas sidaad, “Akim nyan yikuw, mina bayaki kikipaat kwulapwu-kinadiyan kiminkikik?” ");
INSERT INTO mle_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jisas duw vitiy tasakwukuw, ata wadibir ki maaj, “Bir tipaar awul. Duw nak tukwur vakaam guw yatanaad sitakira-kibiraad. ");
INSERT INTO mle_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","“Bir adi duw kwukib maay. Yin av agwa wiya wulakida. A wiy asaay duwak bas as, ‘Kalivanadi duw wanaad, “Wiy akim kwana, a wiyaam wun wunadiy kalivatuwadiy duwawa God Nyigildidiy Nyi bayaki kikipaat kikibana?” ’ ");
INSERT INTO mle_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","“Di alawurir kwana wiy simaka-kidabirbir. Wiy bwutaay kwulapwudik, tina. Alim bir niki jaav niki jaav kwulapwun ada nyanak.” ");
INSERT INTO mle_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kalivadibir duw dim wapakuw, tipaar wulakuw, Jisas tayir wadidiy jaav ata vibiridiy. Bir God Nyigildidiy Nyi bayaki kikipaat ata kwulapwu-biridiy. ");
INSERT INTO mle_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Giraab kwusilik, Jisas dikidiy tabatiy maan vitiy duwawa yaad. ");
INSERT INTO mle_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kipaat ran kidaal, Jisas ata waad, “Mwiya maaj watuwadiygwurik. Gwura duw nak ginyir wunadiy mama nibak kwiykidadiwun. Di wunawa kipaat kinaad.” ");
INSERT INTO mle_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Day pitaan warkuw, nakanak Jisasak bas sidaad, “Wunak wanadimin?” wataay wadaad. ");
INSERT INTO mle_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisas ata wadidiy, “Di wunawa bret marir kwusadada. ");
INSERT INTO mle_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Wun, gwuradi Mwaam, kiyakinadiwun tayir God diki lapa nyig walil pik. Aw gwuradi Mwaam mama nibak kwiykinadi duw kupwarapa jaav dikim warkidanaad. Li tayir amaay kidi duw sapwiy maarlik, aal viyakita dikik.” ");
INSERT INTO mle_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Day kikipaat kidaak, Jisas bret kwurkuw, Godak wayapiy sidid. Jisas a bret kaysukwa sukwakuw, dikidiy kalivadidiy duwak kwiydidiy. Di wadidiy, “Akwur. Kal wuna amwiya.” ");
INSERT INTO mle_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Adakap kwurkuw, Godak wayapiy sidid. A adakap dayak kwiydik, day a wain nakanak kidaal. ");
INSERT INTO mle_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Di ata wadidiy, “Kad wunadi nyikiy-ad. Kidi nyikiy ababa duw takwak simaka-dadiy God diki aban mwiya maaja. Samasama duw takwa danik wunadi nyikiy wakwu-kinaad. ");
INSERT INTO mle_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“Mwiya maaj watuwadiygwurik. Nuwuk wain ki maarkituwa. Aw ginyir God diki van tida tamiyaam ata kwula wain kikinadiwun.” ");
INSERT INTO mle_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Song nak tikuw, wiy wapakuw, Aliv abwaar wardiy. ");
INSERT INTO mle_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas dayak ata waad, “Gwur abab wunaam wapakuw, tabwu-kinadiygwur. God diki lapa nyig ata wana, ‘God sipsip van tinadiy duwaam viyadik, kiyakinaad. Kiyadik, sipsip kapakap kapakap tabwu-kinadiy.’ ");
INSERT INTO mle_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“God wunaam kirapitakadik, wun tayib yikinadiwun Galiliy-aar gwurak.” ");
INSERT INTO mle_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita wadid, “Li nuwukadiy tabwun wapa-kidadimin ab, wun minaam wap maa.” ");
INSERT INTO mle_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisas dikik ata waad, “Mwiya maaj watuwadiminik. Ki gaan tapwuk jaab vitiy wadik, tayir wakimina jaab mugwul, ‘Wun Jisasaam maa laakw.’” ");
INSERT INTO mle_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita Jisasak maaj nimadib wadid, “Li wun minawa kiyatuw ab, aw wun wu maa, ‘Wun Jisasaam maa laakw.’” Day abab atawa wadiy. ");
INSERT INTO mle_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Day yadadi tip, si Gitsimaniy, alir yadaak, Jisas dikidiy kalivadidiy duwak ata wadidiy, “Kilim kavin ada. Wun Godawa maaj bwulak yikidiwun.” ");
INSERT INTO mle_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jisas Pita, Jamis, Jon ata kwurin karaydidiy. Di ata pitaan warkuw, samasam wukid di dikik. ");
INSERT INTO mle_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Di dayak ata waad, “Wun wunak samasam wukinadiwun. Wukikuw, alik kiyak tinadiwun. Gwur kilim van ada.” ");
INSERT INTO mle_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Di kwasa yikuw, kupwaam vakirid. Vakirkuw, Godak bas sidid, “Adiy jaav warkidana nyi wunaam gwutaka-kimina way?” ");
INSERT INTO mle_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Di wadid, “Asaay, wunadi Asaay, ababa jaav bwunak kwur-kwaminadiy. Aw kidiy wunak yakinadiy kupwarapa javadiy kwurin ayak. Aw wuna mawul maa, mina mawul.” ");
INSERT INTO mle_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jisas yakuw, vididiy dikidiy kalivadidiy duw mugwul si kwadiy. Pitak wadid, “Sayman, si kwanadimin? Min ri maarin kwasa mwiya pik van titak? ");
INSERT INTO mle_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Gwur van tan Godak maaj aw, gwuraam vaal kakilik-na. Gwuradiy mawul yaakiya viyakita jaav kwurik. Aw gwuradiy amwiy ap maa ti.” ");
INSERT INTO mle_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Alib kwasa yikuw, Godak maaj wadid tayir wadil pik. ");
INSERT INTO mle_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dikidiy kalivadidiy duwak sibinin yakuw, vididiy si kwadaak. Dayadiy mil dibirin dibirin dadiy. Day wap saykuw, maa rav Jisasak wawak. ");
INSERT INTO mle_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jaab mugwul dayak yaad. Yakuw, wadidiy, “Gwur si kwanadiygwur nibway? Yaakiya, nyi akaanaka. Awuk! Duw nak yaan gwuradi Mwaam kwiykidaad vaal yinadiy duw daya tabaam. ");
INSERT INTO mle_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gwur arap. Yinaak. Adi duw walibab tinaad.” ");
INSERT INTO mle_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wadik, Juwtas, Jisas dikidiy tabatiy maan vitiya duw nakad dayak yaad. Juwtas wukin duw samasam yadiy. Wariya jaav kwurin kariya-dadiy. Sapakwa nyanugw pris, God diki lo kalivadiy duw, sapakwa nyanugw, day wayakidaak, yadiy. ");
INSERT INTO mle_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jisasaam dayak kwiydi duw tayir wadidiy, “Mwutaam jipwu-kituwadi duw, adi duw gwur kwurik. Kalakwukuw, yarakara akaraay.” ");
INSERT INTO mle_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Juwtas yadik, Jisasak yakuw, wadid, “Yitaypika Duw.” Wakuw mwutaam jipwud. ");
INSERT INTO mle_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Adiy duw yakuw, dim kaykitikuw, kalakwudaad. ");
INSERT INTO mle_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Walibab tidi duw bag kaylupwakuw, Mwiya Yitaypika Pris dikidi yawiy duw diki waan viyalupwadil. ");
INSERT INTO mle_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisas ata bas sididiy, “Wun jaal dayikwadi duw-adiwun, gwur bag kwurkuw wunaam kalakwuk, ay? ");
INSERT INTO mle_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","“Nyi samasam God dikidi wiyaam kwakwatuwa duw takwak kalivaan. Aw gwur wunaam maa kalaakw. Aw God diki lapa nyigaam rina maaj maykaar wakwukwa.” ");
INSERT INTO mle_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dikidiy kalivadidiy duw abab dim wapakuw, ata tabwudiy. ");
INSERT INTO mle_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Badiy duw nak, wapwiy rabwukuw, Jisas diki kwukib yad. ");
INSERT INTO mle_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Adiy duw kalakwuk kwurdaak dim, wapwiy wapaan duwadika tabwud. ");
INSERT INTO mle_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Day Jisasaam kwurin karaydaad Mwiya Yitaypika Pris diki wiyaar. Sapakwa nyanugw pris, sapakwa duwadiy, God diki lo kalivadiy duwawa alim vagaluwdiy. ");
INSERT INTO mle_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jisasawa nuwukadiy duw day taay yidaak, Pita kwasa kwukir yikuw, Mwiya Yitaypika Pris dikid wiya yaripaar ata wulaad. Wulakuw, van tidiy duwawa daan rad diki sip yiyaam takasawulak. ");
INSERT INTO mle_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sapakwa nyanugw pris awa abab kaunsil duw day wukik nuwukadiy duw suwaal maaj wadiy Jisasak. Wukikuw, day ata, “Di kiyakwaad,” wakir a majik. Aw atampika maaj sitakira-sitakir maa rav. ");
INSERT INTO mle_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Duw samasam suwaal takadiy Jisasak. Dayadiy maaj nak maa. Kapakap tidiy. ");
INSERT INTO mle_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nuwukadiy duw rapikuw, ki suwaal maaj takadaal Jisasak. ");
INSERT INTO mle_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ki wadil maaj wukibaal, ‘Kidi Godak duw kwurdiy wiy, aad pira-kituwaad. Pirakuw, nyi mugwul yidaak, duw akis kwurkwanadiy wiy nak kwurkituwaad.’” ");
INSERT INTO mle_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Adiy duw ab dayadiy maaj kapakap tidiy. ");
INSERT INTO mle_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mwiya Yitaypika Pris daya nyidim rapikuw, Jisasak bas sidid, “Kidiy duw minak sukwupirkuw wadaak, aw min maaj maa ti?” ");
INSERT INTO mle_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jisas kaygan tad. Maaj maa bwul. Alib Mwiya Yitaypika Pris Jisasak bas sidid, “Min God dikidi Tasakwudidi Duw-adimin? God dikidi Nyan-adimin?” ");
INSERT INTO mle_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas wadid, “Wun-adiwun tikwanadiwun. Gwur abab duw taakw dayadi Mwaam vikigwuraad, di ap samasam tinadi God diki mava tabaam ridik. Gwur vikigwuraad, di adawur tubwaar yadik.” ");
INSERT INTO mle_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A maaj wukikuw, Mwiya Yitaypika Pris di dikidi wapwiy kaypirikiykuw, ata wadidiy, “Nyan niki maaj wukik maa. ");
INSERT INTO mle_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“Gwur diki sapis jikidi maaj Godak bwu wukigwura. Gwur agwa jaav kwurik dikim?” Day abab maa wakuw dikik, alik, “Kiyakwaad,” wakuw wadiy. ");
INSERT INTO mle_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nuwukadiy duw ata Jisasaam likasip sataka-daad. Dikibir milaam wapwiy jikuw, taab kaygipikuw, viyadaad. Viyakuw, day dikik ata bas sidaad, “Sikanadaad minaam viyanaad?” Van tidiy duw Jisasaam kwurkuw, yala tabaar viyadaad. ");
INSERT INTO mle_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita aladaam mala wiyaam kwadik, Mwiya Yitaypika Pris diki yawiy kwurla taakw nak yaal. ");
INSERT INTO mle_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita yiyaam sip takasawuladik, a taakw dim vikuw, li ata walid, “Minabab Jisas Nasarit tipa kidawa kwadimin.” ");
INSERT INTO mle_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Di maa wakuw, ata waad, “Wun maa laakw. Wun maa wak nyin wanyina jaav.” Wakuw, di ata wakwud tipigwusir. Jayib ni tapwuk waad. ");
INSERT INTO mle_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yawiy taakw Pitaam alim vilik, alib walibab kwadiy duw takwak ata waal, “Kidi duw Jisas dikidiy duw nak-ad.” ");
INSERT INTO mle_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita alib, “Maa,” waad. Kwasa rikuw, walibab kwadiy duw Pitaak ata wadaad, “Min Jisas dikidiy duw nak-adimin. Minabab Galiliy tamiya kidi duw-adimin.” ");
INSERT INTO mle_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita ata waad, “Wuna maaj mwiyir ti maarlik, God wunaam viyakwaad. Wun gwur wadi duw maa wak.” ");
INSERT INTO mle_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Atawa wadik, tapwuk jaab vitiy ata waad. Pita Jisas tayir wadil maaj wukidil, “Tapwuk jaab vitiy wadik, taay min jaab mugwul wakimina, ‘Wun Jisas maa wak.’” Wukikuw, Pita giraad. ");
INSERT INTO mle_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ganib tilik, sapakwa nyanugw pris, sapakwa nyanugwawa, God diki lo kalivadiy duwawa, kaunsil duwawa ata vagaluwdiy. Day nikim nikim bwuladiy. Bwulakuw, day Jisasaam yaav jikuw, kwurin karaykuw, Paylatak kwiydaad. ");
INSERT INTO mle_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paylat Jisasak bas sidid, “Min Juw dayad Yitaypika Duw-adimin?” Jisas ata wadid, “Min atawa wamina.” ");
INSERT INTO mle_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sapakwa nyanugw pris samasama maaj sukwupirkuw, wadaad dikik. ");
INSERT INTO mle_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Alik Paylat alib Jisasak bas sidid, “Min awuk! Day samasama maaj sukwupirkuw, minak wanadiy. Min maaj maa?” ");
INSERT INTO mle_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jisas niki maaj maa wu. Alik Paylat diki mawul nikim nikim tal. ");
INSERT INTO mle_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ababa God Wapadidiy Nyi bayaki nyaam Paylat kalabus im kwadi duw nak wapadid. Sikadadaad vagaluwdiy duw taakw bas sididiy dikik, di ata wapadid dayak. ");
INSERT INTO mle_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A nyi duw nak, dikidi si Barapas, kalabus im kwaad nuwukadiy gavman aam viyadiy duwawa. Viyadaak kiyadiy. ");
INSERT INTO mle_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Duw taakw vagaruwdaak, Paylat tayir pik kwurda jaav dayak kwurdakik. ");
INSERT INTO mle_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Paylat wukidil sapakwa nyanugw pris dayadiy mawul kuwkuw nadaak Jisasak, day Jisas kwiydaad dikik. Alik di duw takwak bas sididiy, “Gwur Juw dayadi Yitaypika Duw wapatuwkik?” ");
INSERT INTO mle_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Adiy sapakwa nyanugw pris vagaruwdiy duw takwak nimadib wadiy day Paylatak bas sidakikik Barapasaam wapadikik dayak. ");
INSERT INTO mle_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Paylat alib vagaruwdiy duw takwak bas sididiy, “Agwa jaav kwurkinadiwun adi sikiygwura Juw dayad Yitaypika Duwak?” ");
INSERT INTO mle_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Day dikik gaam sidiy nimadib, “Maap takadadi miyaam dim akat!” ");
INSERT INTO mle_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Paylat dayak ata bas sad, “Agwa kupwarapa jaav kwurdil?” Day mwiya nimadib gaam sidiy, “Maap takadadi miyaam dim akat!” ");
INSERT INTO mle_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paylat vagaluwdiy duw taakw daya mawulab tikuw, di Barapasaam wapadid dayak. Di Jisas vay sawdiy duwak kwiydid ramiy tidi miyaar taay viyakuw, ginyir maap tidi miyaam katadakik. ");
INSERT INTO mle_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Day Jisas taay maaj lakwudi gavman duw dikid wiya yaripaar kwurin kawuladaad. Wulakuw, gaam sidiy nuwukadiy vay sawdiy duwak day yadakikik dayak. ");
INSERT INTO mle_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Day alatab kwurik Jisasaam. Alik day yitaypika duw nyikiy nyikiy wapwiy kitika wapwiy rabwutaka-daad. Atawa day yitaypika duw abwa wawiy pik kwurkuw, diki abwaam kititakadaal. Aw a abwa wawiy ramiy til abwa wawiya. ");
INSERT INTO mle_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Day dikik gaam sidiy, “Juw dayadi Yitaypika Duw, nabiy samasam kwakinadimin!” ");
INSERT INTO mle_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Diki abwaam miyaar viyadakib. Diki sipaam likasip satakaan, alatab kwurin kwatiyir sidiy dikik. ");
INSERT INTO mle_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Taay apaapap kwurin naykuw, day nyikiy nyikiy wapwiy kaylapiykuw, diki wapwiy alib dim rabwutakadaad. Day Jisas ata kwurin karaydaad maap tidi miyaam katataka-dakik. ");
INSERT INTO mle_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yidaak, duw nak Sayman, Sayriyniy tipa kid, Aliksada-wa Ruwpas birakid asaay, maay tamiy wapakuw, walibab yaad. Vay sawdiy duw wadaak, Sayman di Jisas dikidi maap tidi miy yatadid. ");
INSERT INTO mle_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Day Jisas kwurkuw, tip si Galgata, a tipaar wakwudiy. Tip si maaw maaj, duw adakap kitika tamiya. ");
INSERT INTO mle_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Alim day wain-awa marasin si mir kwiyik kidikikik. Aw Jisas di maa waad. ");
INSERT INTO mle_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Day Jisas maap tidi miyaam katadaad. Katakuw, dikidiy wapwiy am sidadiy day daya. Day jib kwadiy kwasadiy kabaak yakitaay tayaan naydiy adiy wapwiy kwurik. ");
INSERT INTO mle_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ganib, nyi abaliy tidik, maap tidi miyaam katadaad. ");
INSERT INTO mle_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jisasak maaj sukwupirkuw, sukwudaal, “JUW DAYADI YITAYPIKA DUW.” ");
INSERT INTO mle_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Luwkuw kwurin, duw viyaan kwurbir duw day maap tibir miyaam katadabir Jisasawa, nak diki mava tabaam, nak diki akiy tabaam. ");
INSERT INTO mle_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Alik God diki lapa nyigaam rina maaj maykaar wakwul, “Day wukidaal di vaal yidi duw kitik.” ");
INSERT INTO mle_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Walibab tiytiyaan tidiy duw Jisasak abwagab nayin wajibayin kwurdiy, “A! Min God dikidi wiy pira-kinadi duw-adimin! Pirakuw, nyi mugwul yidaak, kitampika wiy kwurkimina! ");
INSERT INTO mle_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","“Yaakiya, min mina kap kwurkuw, maap tinadi miy wapakuw, adiyid!” ");
INSERT INTO mle_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Atawa sapakwa nyanugw pris awa God diki lo kalivadiy duw day daya wadiy, “Di nuwukadiy duw takwak sugwiyaan kwurkwaad. Aw di dikik maa rav. ");
INSERT INTO mle_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Kidi God Tasakwudidi Duw, Yisrayil Yitaypika Duw, maap tinadi miy wapakuw, nyan vikuw, wukijibiran kwa-kinadiyan dikik.” Abir Jisasawa maap tibir miyaam katadabir duw ab wajibaybir Jisasak. ");
INSERT INTO mle_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nyidi nyi tidik, yin nyi tikitakiydik, miyawa tamiy gaan kitik tad. ");
INSERT INTO mle_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nyi tikitakiydik, Jisas nimadib gaam sad, “Yilay Yilay, lama sapaktanay?” Ki maaj maaw maaj, “Wunadi God, wunadi God, agwak min wunaam wapamina?” ");
INSERT INTO mle_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nuwukadiy walibab tidiy duw ata wadiy, “Awuk! Di God diki maaj wasapwiydi duw Yilayja-ak gaam sinaad.” ");
INSERT INTO mle_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Duw nak gipakuw, nyigiy yina wain diyuwum takadik, yavim takakuw, kwiydil Jisas kidikikik. Di waad, “Atada! Vinaak Yilayja yakuw, di Jisas kwurin karda-kidaad, ay maa.” ");
INSERT INTO mle_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisas nimadib gaam sikuw, ata kiyaad. ");
INSERT INTO mle_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nimadi wapwiy God dikidi wiyaam nyidi wiyaam tad. Tipitakaan, alawurib ap vitiy wutakuw, alawurib daad. ");
INSERT INTO mle_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Vay sawdiy duw duwamiy tabab dayak van tidi duw walibab tikuw, vidil atata Jisas gaam sikuw, kiyaad. Di ata waad, “Kidi duw God dikidi mwiya duwa Nyan-ad.” ");
INSERT INTO mle_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nuwukadiy taakw kwasa sikaam tan vidiy. Salawmiy, Maria Maktala tipa kil, Maria adi ginyir Jamisawa Jasis biraki amaay, adiy taakw mugwul dayawa tidiy. ");
INSERT INTO mle_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tayir Jisas Galiliyaam tikuw, day diki kwukib yidiy sugwiyaan kwurik. Samasam tayir Jisasawa Jiruwsalimaar yadiy taakw alim tidiy. ");
INSERT INTO mle_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Giraab tidik, Jasip Aramatiya tipa kid yaad. Di viyakita sukw kwadi kaunsil duw-ad. Di kavin kwaad God dikidi ababa duw takwak van tikidadiy nyak. Bayakik kwulapwu nyi yadik, sir Sapat, Jasip yaag maarkuw, di Paylatak wulaan walibab tad Jisas amwiyik bas sikir. ");
INSERT INTO mle_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paylat wukidik Jisas bwu kiyaad wakuw, ata pitaan warid. Di vay sawdiy duw duwamiy tabab dayak van tidi duwak gaam sidid. Di wukik Jisas bwu kiyaad, ay maa kiy. ");
INSERT INTO mle_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Adi duw dikik, “Jisas bwu kiyaad” wadik, Paylat Jasipak, “Diki amwiy kwurkidimin,” wakuw wadid. ");
INSERT INTO mle_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jasip viyakita wamakawam wapwiy yapiykuw, Jisas diki amwiy kwurin kardadil. Kardakuw, rabwutakakuw, dipwu kabakim ata takadil. Jasip nima kabaak timilyikuw, ata dipwu kabaak diki dap tipitakadil. ");
INSERT INTO mle_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Maktala tipa kil Maria Jasis diki amaywa Jisas diki amwiy takadil tamiy vibiril. ");
INSERT INTO mle_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sapat nyi bwu yilik, Maria Maktala tipa kil, Maria Jamis amaay, Salawmiy-wa day viyakita yaam yayir waliy guw yapiydaal. ");
INSERT INTO mle_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sande ganbab, nyi wardik, day adi dipwu kabakir yidiy. ");
INSERT INTO mle_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Day yitaay tikuw, day daya wadiy, “Sikanadaad adi nimadi dipwum rinadi kabaak timilyaki-naad nyanak?” ");
INSERT INTO mle_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Adi kabaak mwiya nimaad-ad. Abw sinawurkuw, day vidaad adi kabaak bwutay vatimilsakiydaak, malaam rad. ");
INSERT INTO mle_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dipwu kabakir wuladaak, day badiy duw vidaad mava tabaam tikuw. Diki kwusuw wapwiy wamakawama tidiy. Vikuw, yagakuw, pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Di dayak ata waad, “Gwur yaga-tikwa. Gwur maap tidi miyaam katadadi Jisas Nasarit tipa kid vikir. Di kilim maa kwu. Bwutaay rapid. Av! Takadadi tamiy kika. ");
INSERT INTO mle_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“Maay! Ki maaj aw dikidiy kalivadidiy duwawa Pitaak, ‘Di taay gwurak Galiliy-aar yikinaad. Alim vikigwuraad tayir gwurak wadil pik.’” ");
INSERT INTO mle_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Day pitaan warin, yagakuw, ata tabwudiy. Day yagadiy. Alik day niki duwak maa wu a javik. ");
INSERT INTO mle_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas kiyakuw ridik, Sande ganbab ata rapid. Rapikuw, di taay Maria Maktala tipa kil likik di di simakadil. A taakw tayir wudib abitiy liki mawulaam yikuw ridaak, Jisas yakididiy. ");
INSERT INTO mle_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Li Jisasawa tayir kwadiy duwak yikuw, waal dayak. Adiy duw Jisasak wukikuw, giraan tidiy. ");
INSERT INTO mle_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria dayak ata walidiy, “Jisas bwu rapinaad. Wun vituwaad.” Day maa wak liki majik. ");
INSERT INTO mle_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ginyir Jisas dikibir kalivadibir duw vitiy, tip wapakuw, yibir. Jisas birim wakwun maak takaad niki mwutaam tad. ");
INSERT INTO mle_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bir tipaar sibinin yikuw, a jaav nuwukadiyik wabiril. Aw day biraki majib maa wak. ");
INSERT INTO mle_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kwukir, dikidiy kalivadidiy duw tabatiy maan nak kikipaat kidaak, Jisas dayak wakwud. Kwasa wariya kwudiy wadidiy. Agwak, day maa wukin ti, “Di di” wakuw. Aw day nuwukadiy dim vididiy duw taakw dayadiy maaj ab maa wak. ");
INSERT INTO mle_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Di dayak ata waad, “Ababa tipaar yikuw, wuna Viyakita Maaj awasapwiy ababa duw takwak. ");
INSERT INTO mle_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","“Sikanadaad wukijibir tikuw, baptais kwurkuw, adi duw God kwurkidaad. Sikadanadiy-adiy wukin ti maarkinadiy, God maa wakinaad adiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Godak wukijibir tikinadiy duw taakw kidiy diki mawulaam rinadiy yawiy kwurkidanadiy. Wunadi saam day mawulaar yinadiy wudib yakikidiy. Niki kwudiy niki kwudiy wakidiy. ");
INSERT INTO mle_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","“Aal kabaay tabaar kaykitikuw, aw duw kiya-kwadana guw kikuw, day kupwaraap ti maa. Day taab giviyib kwurda duwaam takadaak, a giviyib kwusikina.” ");
INSERT INTO mle_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yitaypika Duw Jisas dayawa bwulakuw, God dim kwurkuw, adawur tipaar kawardid. Kawarkuw, di God diki mava tabaam rad. ");
INSERT INTO mle_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jisas dikidiy kalivadidiy duw niki tip niki tipaar yin yaan Viyakita Maaj wasapwiydaal. Yitaypika Duw dayawa yawiy kwurid. Di dayak God diki mawulaam rinadiy yawiy kwiydidiy. Alik nuwukadiy wukidiy daya maaj mwiya maaja. Yaakiya, atawa tina. ");
INSERT INTO mle_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Dia Tiyapalis, tayir duw samasam day maaj sukwu-dadiy Jisas nyana nyidim kwurdil yawiyik. Day adiy tayir jaav vidadiy duw taakw dayadiy nyanak wasapwiyin wadadiy maaj wukikuw, day ata adiy jaav sukwu-dadiy. ");
INSERT INTO mle_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yitaypika duw, alik tikuw, wun yarakara wukikuw, wun samasama duw takwak bas situwdiy adiy jaav dayadiy maaw wukik. Wukikuw, wuna mawul wukituwil wun kidiy ababa jaav lapa nyigaam sukwu-kituwa minak, aal viyakita. ");
INSERT INTO mle_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Wun atawa kwurkuw, min wuna sukwutuwil maaj vikuw, min ata lakwu-kimina aal minak kalivadaal maaj mwiya maaj tina, suwaal maa. ");
INSERT INTO mle_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yirat, Yisrayil jaka tipa yitaypika duw tidil sikir, pris nak, Sakaraya, alim tad. Sakaraya dikidi nimadi gwalugw Aran, diki kwasa gwalugw Apiyja. Adiy gwalugwa duw day abab pris tidiy. Sakaraya diki taakw liki si Yilisapit. Likidi gwalugw ab pris yawiy kwurdiy. ");
INSERT INTO mle_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bir vitiykilib God diki milaam yarakara tibir. Bir God dikidiy lo wa majib wukibir. Aw bir simsim vaal maa yi. ");
INSERT INTO mle_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Yilisapit li gwaaj kwaal. Alik bir nyan maa ti. Bir bwutaay apaan apaaw-abir. ");
INSERT INTO mle_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Wik nak day Apiyja gwalugw tasakwudaad God dikidi wiyaam pris yawiy kwurdikik. Nyi nak Sakaraya yawiy kwurdik God dikidi wiyaam, day tasakwudaad a nyi di kap viyakita yaam yaykwana yakiy takadikik Godak yala wiyaam. ");
INSERT INTO mle_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Di a viyakita yaam yaykwaal yakiy takadik Godak, samasama Juw duw taakw day kawaam vagaluwkuw, Godak maaj bwuladiy a nyi. ");
INSERT INTO mle_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakaraya atawa kwurdik, God diki maaj kardadi duw nak di maykaar wakwukuw, rasin tad mava yaam yayil yakiy rilil kabaka jabawa. ");
INSERT INTO mle_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aw Sakaraya dikim vikuw, pitaan warkuw, yagaad. ");
INSERT INTO mle_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aw adi maaj kardadi duw dikik ata wadid, “Sakaraya, min yaga-tikwa! Godak wamina maaj bwu wukida. Alik mina taakw, Yilisapit, duwa nyanad sapwiy-kilaad. Adi sapwiy-kiladi nyinik Jon asikiytak. ");
INSERT INTO mle_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","“Yilisapit adi duwa nyan sapwiylik, minawa samasama duw taakw rakarak samasam tikidiygwurik a javik. ");
INSERT INTO mle_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","“Amaay dim sapwiylik, God di dikidi Mawul diki mawulaar wuladik, ata wapwurukwu-kinaad. Di duw tikwul-kwanadi guw kidiba. Di nimaad tikuw, di yitaypika duw tikinaad God dikidi gikim. ");
INSERT INTO mle_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Adi nyan di adiy Godak bwan kwiydiy Yisrayil jaka tipa kidiy duw taakw di mwugiydik, dayadi Yitaypika Duw Godak sibinin yakidiy. ");
INSERT INTO mle_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","“Di ap samasam tikinaad God diki maaj wasapwiydi duw, Yilayja, kitik. Di mwugiydik, asaay dayadiy mawul dayadiy nyanugwak yikinadiy maa. Di taay yikuw, di Yitaypika Duw dikidiy duw taakw kwulapwu-kidadiy dikik.” ");
INSERT INTO mle_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","God diki maaj kardadi duw diki maaj wukikuw, Sakaraya dikik ata wadid, “Ata ata ki javik lakwu-kituwa? Wun wuna takwawa bwutaay apaan apaaw tikuw, ata ata wamina jaav mwiya mwiyab tikina?” ");
INSERT INTO mle_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","God diki maaj kardadi duw Sakarayak ata wadid, “Wun Gapriyil-adiwun. Wun God diki mwutamaam tikwanadiwun. God di diki wayakidalik danadiwun ki viyakita maaj minak wakir. ");
INSERT INTO mle_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","“Wuna maaj suwaal maa. God wakida nyi ki minak watuwa jaav mwiya mwiyab tikina. Yaakiya, min wuna majik wukijibir maa ti. Alik tikuw, min maaj bwul maa. Aw ginyir yin minak watuwa jaav tikila nyaam, min ata maaj bwula-kinadimin maa.” ");
INSERT INTO mle_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Adiy kawaam kavin kwadiy duw taakw day dayadiy mawulaar wadiy, “Sakaraya di nimadi simiy yala wiyaam kwanaad. Agwa jaav kwurnaad?” ");
INSERT INTO mle_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ginyir di ata wakwud. Wakwukuw, dayak maaj maa bwul. Alik day lakwukuw, wadiy, “Kad di yigin vinaad yala wiyaam!” Maaj bwulaak kwurdil, maa rav. Alik tabaar simaka-didiy dayak. ");
INSERT INTO mle_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ginyir Sakaraya dikidiy yawiy nyi God dikidi wiyaam kwusidaak, di diki wiyaar ata yad. ");
INSERT INTO mle_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ginyir diki taakw Yilisapit yalawa tikuw, li kip kwalidiy bap tabab wiyaam. ");
INSERT INTO mle_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Li liki mawulaar ata waal, “Tayir wun gwaaj kwatuwil, duw taakw wunak sapis jikin wadaalwun. Alik wun wap sayilwun. Aw Yitaypika Duw wunak wukikuw, alik kitawa sugwiyaan kwurdiwun.” ");
INSERT INTO mle_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Yilisapit nyan bap abwun yalab tidik, God diki maaj kardadi duw Gapriyil wayakidik, Galiliy tamiyaam rina tip, Nasaritaar daad. ");
INSERT INTO mle_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dakuw, di niba taakw, liki si Maria, likik yad. Li duwawa si maa kwu. Li duwak wadaak, wiyaam kip kwaal. Likik wadadi duw, Jawsip-ad. Di Yisrayil yitaypika duw, Davit, dikidi waraga duw-ad. ");
INSERT INTO mle_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Adi God diki maaj kardadi duw likik yikuw, ata wadil, “Kupwiyaay, yara kwananyin? Nyanadi Yitaypika Duw God, di nyinawa kwakwanaad. Aw di nyinak yarakara kwurik.” ");
INSERT INTO mle_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria li diki wadil maaj wukikuw, li aal wadil maaw maaj laakw maarkuw, alik mawulaar samasam wukil. ");
INSERT INTO mle_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Adi God diki maaj kardadi duw Mariak wadil, “Maria, nyin yaga-tikwa. God diki mawul nyinak rakarak tina. ");
INSERT INTO mle_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nyin yalawa tikinanyin. Tikuw, nyin duwa nyanad sapwiy-kinyinad. Aw nyin adi nyinik Jisas asikiytak. ");
INSERT INTO mle_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Di yitaypika duw tidik, duw taakw wakinadiy, ‘Di nimadi God dikidi Nyan-ad.’ God wadik, di yitaypika duw dikidi waraga duw, Davit, kitik tikinaad. Tikuw, di Jakap dikidiy gwalugwak van tikinaad nyanyi nyanyi. Ki diki yawiy kwas maa.” ");
INSERT INTO mle_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria God diki maaj kardadi duwak ata bas silid, “Ki wamina maaj ata ata tikina? Wun duwak maa laan ri.” ");
INSERT INTO mle_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Adi God diki maaj kardadi duw likik ata wadil, “God dikidi Mawul nyinaam dakuw, God dikidi ap nyinaam rikinaad. Alik di mwugiydik, nyin yalawa tikinanyin. Ginyir nyi kidi sapwiy-kinyinadi nyinik duw taakw wakinadiy, ‘Kidi nyan mwiya viyakit-ad. Di God dikidi Nyan-ad tinaad.’ ");
INSERT INTO mle_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","“God rivinaad ababa jaav kwurkwurik. Aw nyin nyina raaw Yilisapitak awuk. Day wadaal, ‘Li gwaaj kwana taakwa.’ Aw li apaaw tikuw, yalawa tina. Yalawa tikuw, likidiy yalawa tilidiy bap kita abwun kwanadiy.” ");
INSERT INTO mle_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Diki maaj wukikuw, Maria ata walid, “Yaakiya, wun God diki yawiy taakw tinawun. Alik tikuw, wa wunak wamina jaav jaaw God wunaam kwurkwaad.” Wakuw walik, God diki maaj kardadi duw likim ata wapadil. ");
INSERT INTO mle_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kwasa rikuw, Maria likidiy jaav kwulapwukuw, yabiyib nibwukim daan ridaal Juwtiya tamiyaar ril tipaar yal. ");
INSERT INTO mle_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yikuw, li Sakaraya diki wiyaar wulakuw, Yilisapitak ata wayapiy silil. ");
INSERT INTO mle_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Yilisapit Maria liki silil wayapiy wukikuw, adi Yilisapit yalaam tidi nyan ata yitaay tayaad. God dikidi Mawul Yilisapit liki mawulaam ata kapwudik, li Mariak nimadib walil, “God di nyinak mwiya yarakara kwurnaad! Nyinak kwurda pik nuwukadiy takwak maa kwar! Nyinadi sapwiy-kinyinadi nyinik God dikik ab yarakara kwurnaad. ");
INSERT INTO mle_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","“Nyin Yitaypika Duw diki amaay-nyin. Agwa javik nyin wuna wiyaar yananyin wunak vikir? ");
INSERT INTO mle_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","“Nyina wunak sinyinil wayapiy wukituwik, wuna yalaam tinadi nyan di rakarak tikuw, yitaay tayanaad. ");
INSERT INTO mle_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","“Nyinak Yitaypika Duw God wadil maaj nyin wukijibir tinanyin. Alik nyin rakarak tikinanyin!” Yilisapit ata walil. ");
INSERT INTO mle_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Maria ata waal, “Wuna mawul rakarak tina Godak. God wun diki yawiy taakw tituwik, wunak wukinaad. Wunadi God wunak sugwiyaan kwurdilwun. Alik wun rakarak tinawun dikik. Nimadi ap samasam tinadi God wunak nimadiy jaav kwurdidiy. Alik ki nyab karayrib duw taakw wakidiy, ‘God viyakita jaav Mariak kwurdil.’ God di mwiya viyakit tikwanaad. ");
INSERT INTO mle_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Adiy duw taakw day yarakara Godak wukikwanadiy, dayak God nima mawul wukikinaad. Ki nyab karayrib God atawa kwurkinaad. ");
INSERT INTO mle_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","God di nima ap tikwanaad nimadiy yawiy kwurkwurik. Adiy duw taakw day dayadiy sipak sakwar sakwar wukitaay, rakarak tidiy, adiy di mwugiydik, day jawjaay tabwukidiy. ");
INSERT INTO mle_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Di mwugiydik, adiy jaka tipa kidiy sapakwa duw kipa kwasadiy tidaak, a kwusida-takaan tidiy duw taakw di mwugiydik, yitaypik tidiy. ");
INSERT INTO mle_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Adiy saal yidiy duw takwak viyakita jaav kwiydidiy. Adiy niki jaav niki jaav tidiy duw taakw, di dayak wayakidik, day kip saal yaan tidiy. ");
INSERT INTO mle_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Tayir God Aparamawa nyanadiy waraga duw takwak wadidiy, ‘Wun Yisrayil jaka tipa kidiy duw takwak wukikuw, ki nyab karayrib wun gwurak sugwiyaan kwur-kituwadiygwurik.’ Aw God diki wadil abanik wukin kariyakuw, di adiy dikik yawiy kwurdiy Yisrayil jaka tipa kidiy duw takwak sugwiyaan kwurdidiy.” Maria ata waal. ");
INSERT INTO mle_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria li Yilisapitawa bap mugwul kaam kwakuw, li liki wiyaar sibinin ata yal. ");
INSERT INTO mle_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ginyir Yilisapit liki yalaam tidi nyan ata yip viyaad. Viyadik, li duwa nyan ata sapwiylid. ");
INSERT INTO mle_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yilisapit likidiy gwalugwa duw takwawa walibab kwadiy duw taakw day wukidaal li duwa nyan sapwiylid, day rakarak tidiy liwa. Day ata wadiy, “God di mwiya viyakita jaav kwurid Yilisapitak.” ");
INSERT INTO mle_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Rakarak tikuw, nyi abitiy yidaak, nyi abamugwul tilik, day vagaluwdiy adi nyan diki sip lupwak God dikidi gwalugwa duw tidikikik. Lupwakuw, day dikidi asaay si, Sakaraya, sikiytakak. Aw diki amaay walidiy, “Adi si maa! Dikidi si Jon-ad.” ");
INSERT INTO mle_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Day likik ata wadaal, “Dikidi asaay dikidi gwalugwum duw nakab Jon wa si maa kwu!” ");
INSERT INTO mle_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sakaraya dikibir waan tipibir maaj bwula maardilik tikuw, day dikik tabaar bas sidaad diki mawul agwa sad adi nyinik sikiytaka-kidaad. ");
INSERT INTO mle_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Di lapa nyig tabaar bas sididiy kwiydakik dikik. Ata kwurkuw, sukwudil, “Dikidi si Jon-ad.” Day vikuw, pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jayib nak Sakaraya bas ata maaj bwulaad. Di Godak ata wayapiy sidid. ");
INSERT INTO mle_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","66","A tipaam kwadiy duw taakw wukikuw, samasam yagadiy. Ababa Juwtiya nibwuk ridadiy tamiyaam ridiy tipa kidiy duw taakw day wukikuw adiy javik, day dayadiy mawulaar wukikuw, wadiy, “Ginyir agwa jaaval adi nyinim tikina?” Day abab lakwudiy God diki ap dikim tal. Alik atawa wadiy. ");
INSERT INTO mle_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","God dikidi Mawul Jon dikidi asaay, Sakaraya, diki mawulaar wapwurukwukuw, di ki God diki maaj ata wasapwiydil. ");
INSERT INTO mle_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yitaypika Duw, Yisrayil jaka tipa kidiy duw taakw dayadi Godak may! Wayapiy sinaak! Di daad nyanak sugwiyaan kwurik. Kwurkuw, nyanaam nyigil-didiyan Satan tabaam tibaak. ");
INSERT INTO mle_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","God tasakwudid ap tinadi Nyigildi Duw nyanak sugwiyaan kwurdikik. Adi duw di God dikidi yawiy duw, Davit, dikidi waraga duw tinaad. ");
INSERT INTO mle_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Tayir God mwugiydik, diki maaj wasapwiydiy duw ki maaj wadaal, ‘Nyanadiy mama nibawa nyanak yaal giraan tinadiy duw, day nyanaam dayadiy tabaam takak kwurdaak, God nyigil-kidadiyan.’ ");
INSERT INTO mle_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","God nyanadiy waraga duw takwak wadidiy, ‘Wun gwurak yarakara wuki-kidiwun.’ Nyanadi warag Aparamak takadil aban God di maa wukimar. ");
INSERT INTO mle_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Aw kitawa di Aparamak wadid, ‘Gwuradiy mama nib day gwuraam dayadiy tabaam takak kwurdaak, wun yabiyib yakuw, nyigil-kituwadiygwurik tayir watuwil pik. Alik gwur wuna danik yawiy kwurkuw, adiy gwuradiy mama nibak yaag maa. Atawa kwakigwura, gwur gwuradiy ababa kidi kupwaam kwakigwuradiy nyi wuna majib wukikuw, mwiya viyakit kwaya-kinadiygwurik wuna milaam.’” ");
INSERT INTO mle_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sakaraya dikidi kwasadi nyan Jonak ata wadid, “Min, wunadi nyan, ginyir duw taakw wakidanadimin, ‘Mwiya nimadi God diki maaj wasapwiynadi duw-adimin,’ waan. Min taay yikuw, ababa jaav kwulapwu-kidimin kwukir yakidi Yitaypika Duwak. ");
INSERT INTO mle_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Min dikidiy duw takwak wakiminadiy di dayadiy vaal yibwiykuw, dayaam nyigil-kidadiy. ");
INSERT INTO mle_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Duw taakw day vaal yikwanadiy. Alik day kiyakuw, vaat kwurkidiy. Aw God nyanak samasam wukikuw, dikidi Tasakwudidi Duw tayir adawur tipaam kwakuw, God dim kidi kupwaar wayakidik, dakinaad nyanak. Di nyanaam nyigiltaka, kwusida-takaan tikwana mawul likidi yabim takadadiyan.” Sakaraya ki maaj wadil. ");
INSERT INTO mle_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Adi nyan, Jon, viyakita mawulawa ap yiwarin duw tikuw, samasama jaav ata lakwudidiy. Di ata kipa tamiyaam kwaad. Kwakuw, ginyir di Yisrayil jaka tipa kidiy duw takwak yad God diki maaj dayak wasapwiyik. ");
INSERT INTO mle_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Adiy nyaam Rom dayadi yitaypika duw, Akastas, maaj wayakidil adiy ababa Rom van tidadiy tamiyaam ridiy duw takwak. Di miyawa duw takwawa nyanugw dayadiy si kwurik. ");
INSERT INTO mle_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tayir day a yawiy maa kwar. A yawiy bas kwurdaal nyi Kwariyniyas wadadi duw a sikir Siriya jaka tipak van tad Roma gavman ak. ");
INSERT INTO mle_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ababa duw taakw day dayadiy gwalugw dayadiy maaw tipab sibinin yidiy dayadiy si kwiyik. ");
INSERT INTO mle_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jawsip dikidi waraga duw, Yisrayil dayadi yitaypika duw Davit-ad. Davit diki maaw tip Bitliyam-al. Alik Jawsip Galiliy tamiyaam rina tip Nasarit wapakuw, arir yad. ");
INSERT INTO mle_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","6","Di diki kirakida taakw Maria-wa, birkibir si kwiyik yibir. Aw Maria yalawa tilik, bir Bitliyimaam kwabir, li adi nyan sapwiyik kwurlik. ");
INSERT INTO mle_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Saan yapiytaay si kwakwadadi wiy kapwudilik, alik Maria bulmakau kwadaal wiyaar wulakuw, alim likidi taay duwa nyan sapwiykuw, kwasadiy wapwiy kwurkuw, adi nyinim jibirkuw, bulmakau kamnaagw kikwadanadi gwusigaam takalid. ");
INSERT INTO mle_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A gaan nuwukadiy sipsip ak van tidiy duw day mala tipawa dayadiy sipsip ak van tidiy sapiy as dayaam vativatik. ");
INSERT INTO mle_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","God diki maaj kardadi duw nak dayak dakuw, nimadi lait dayaam ata kariyaad. Kariyadik, a jaav vikuw, day lakwukuw God dikidi ap vikuw, ata samasam yagadiy. ");
INSERT INTO mle_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aw adi God diki maaj kardadi duw dayak ata wadidiy, “Gwur yaga-tikwa. Awuk! Wun gwurak viyakita maajal kariya-tuwa. Ababa duw taakw a maaj wukikuw, rakarak samasam tikidiy. ");
INSERT INTO mle_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","“Nibwul Davit diki tipaam taakw nak gwuradi Nyigil-kinadi Duw sapwiylaad. Di God dikidi Tasakwudidi Duw tinaad. Yitaypika Duw-ad. ");
INSERT INTO mle_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“Kitawa gwur lakwu-kigwura wuna maaj mwiya maaj tina. Gwur a tipaar wulakuw, adi nyinim vikigwuraad diki amaay dim kwasadiy wapwiyir jibirkuw, bulmakau kamnaagw kikwadana gwusigaam kwadik.” ");
INSERT INTO mle_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jayib nak samasam adawur tipa kidiy day adi God diki maaj kardadi duwawa walibab maykaar wakwukuw, day abab wayapiy sidiy Godak. ");
INSERT INTO mle_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Day ata wadiy, “Adawur tipaam kwanadi Godak wayapiy sinaak. Adiy kidi kupwaam kwanadiy duw taakw dayaam God rikarik kwurkuw, aal kwusida-takaan tikwana mawul kwiydadiy!” ");
INSERT INTO mle_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Adiy God diki maaj kardadiy duw wapakuw, adawur tipaar sibinin wardaak, adiy sipsip ak van tidiy duw ata wadiy, “Nyan may! Bitliyimaar yinaak! Yikuw, a Yitaypika Duw nyanak wadil jaav vinaak.” ");
INSERT INTO mle_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Day Bitliyimaar gipakuw, Mariawa Jawsip sitakirakuw, day adi nyinim vidaad, bulmakau kamnaagw kikwadana gwusigaam kwadik. ");
INSERT INTO mle_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Adiy sipsip ak van tidiy duw adi nyinim vikuw, day nuwukadiy duw takwak wadadiy adi God diki maaj kardadi duw diki wadil maaj adi nyinik. ");
INSERT INTO mle_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Abab day adiy sipsip ak van tidiy duw daya wadaal maaj wukikuw, ata pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria ababa maaj wukikuw, liki mawulaar wukilidiy. ");
INSERT INTO mle_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Adiy sipsip ak van tidiy duw dayadiy sipsip ak sibinin yitaay titaay, day Godak wayapiy sitaay, rakarak tidiy. Aw adiy ababa God diki maaj kardadi duw wadidiy jaav adiy wukidadiy javib atampik vidadiy. ");
INSERT INTO mle_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nyi abitiy yidaak, nyi abamugwul tilik, adi nyan diki sip ata lupwadaal di God dikidi gwalugwa duw tidikikik. Lupwakuw, dikidi si Jisas sikiytaka-daad. Adi nyan amaay yalaam ri maardik nibway, God diki maaj kardadi duw tayib dikidi si sikiytakadid. ");
INSERT INTO mle_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bap nak yilik, Mariawa Jawsip Jiruwsalimaar yibir. Maria duwa nyan sapwiykuw, li liki sip kwulapwuk mwiyir tikir God diki milaam Mawsis diki lo walil pik. Bir Jisas birikiwa kwurin karaybirid Yitaypika Duw Godak kwiyik diki yawiyik. ");
INSERT INTO mle_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yitaypika Duw God diki lo kitawa waal, “Ababa taay taakw sapwiy-kidanadiy duwa nyanugw adiy day tasakwu-kidanadiy God dikidiy-adiy.” ");
INSERT INTO mle_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yitaypika Duw God diki lo kitawaan ab waal, “Gwur midakim vitiy ay badiy midakim kitika wapiy vitiy pris ak akwiy di a wapiy viyasipakuw, Godak kwiydikik.” Mariawa Jawsip a jaav ata kwurbiril. ");
INSERT INTO mle_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A sikir duw nak dikidi si Simiyan Jiruwsalimaam kwaad. Di viyakita Godak wukidi duw-ad. Di kavin kwaad God Yisrayil jaka tipa kidiy duw takwak nyigilkida nyak. God dikidi Mawul Simiyanawa kwaad. ");
INSERT INTO mle_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tayir God dikidi Mawul Simiyanak wadid, “Min kiy maarkuw, kip kwakuw, vikiminaad God dikidi Tasakwudidi Duwad.” ");
INSERT INTO mle_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","God dikidi Mawul mwugiydik, Simiyan God dikidi wiyaar ata yad. Mariawa Jawsip adi kwasadi nyan Jisas, God dikidi wiyaar kwurin karay-birid God dikidi tidikikik tasakwuk God diki lo walil pik. Aw Simiyan God dikidi wiyaar wulakuw, adi nyan dikibir tabaam kaykitikuw, Godak wayapiy sidid. Di kitawa waad, ");
INSERT INTO mle_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Wuna mawul aka viyakit tina. Tayir wunak takaminil aban aka bwutaay mwiyir tina ya. Alik tikuw, wun aka rakarak tinadiwun kiya-kiyak. ");
INSERT INTO mle_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Wun wunabir kapa milaar bwutaay vituwaad kidi nyanaam Nyigil-kinadi Duw. ");
INSERT INTO mle_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kidi nyan nyanak kwatiya-minaad ababa tamiya kidiy duw taakw dayadiy milaam. ");
INSERT INTO mle_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Gaan van tikwanadiy yabik kariyaan tikwana lait kaytik, atawa kidi nyan nuwukadiy jaka tipa kidiy duw takwak mina mawulawa minadiy yawiy simaka-kidadiy. Day vikuw, day minadiy Yisrayil jaka tipa kidiy duw takwak wayapiy sikidanadiy.” ");
INSERT INTO mle_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Adi nyan dikibir amaay asaay Simiyan Jisasak wadil maaj wukikuw, ata pitaan warbir. ");
INSERT INTO mle_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simiyan di Godak bas sidid di dayak sukwasukw kwurdikik. Godak bas sikuw, Mariak ata wadil, “God kidi nyinik tasakwudid di mwugiydik, samasam Yisrayil jaka tipa kidiy duw taakw miyawa rimaki-dakik, aw samasam dayak sugwiyaan kwurdik, day viyakit tidakikik. Di God diki mawulawa yawiy duw takwak simakadik, samasam day maa wakidiy dikik. Atawa wadaak, abab dayadiy mawulaam rinadiy jaav ata lakwu-kidanadiy. Aw nyin adiy dikim kupwaraap kwur-kidanadiy jaav vikuw, nyina mawul kapakap kapakap tikina.” ");
INSERT INTO mle_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","God diki maaj wasapwiyil taakw, liki si Ana, likidi asaay Asa gwalugwa duw Panuwal-ad. Li alim tal. Li mwiya apaawa. Tayir li duwawa nabiy abitiy kwakuw, likidi duw ata kiyaad. Kiyadik, li nabiy duwamiy aliy sap aliy kip tawtakw kwayalidiy. God dikidi wiya tamiy li samab maa wap. Li nyi gaan kwataay, nuwukadiy nyi kikipaat ki maarin Godak gaba maaj sukwun tal. ");
INSERT INTO mle_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A nyi Mariawa Jawsip bir Jisasawa God dikidi wiyaam kwabir, Ana wulakuw, Godak ata wayapiy silid adi nyinik. Li Jiruwsalim tipa kidiy duw takwak ata walidiy adi nyan God dikidi Tasakwudidi Duw tad. Tayir God aban takadil di ginyir duw nak wayaki-kida dayaam nyigil-dikik. ");
INSERT INTO mle_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bir ababa Yitaypika Duw God diki lo walidiy yawiy kwurkwusin napakuw, bir Jisasaam kwurkuw, bir ata sibinin yibir Galiliy tamiyaam dayakil kwadaal rina tip Nasaritaar. ");
INSERT INTO mle_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Adi nyan ata ap yiwarid apawa. God dikim viyakit kwurdik, di samasama jaav lakwudidiy. ");
INSERT INTO mle_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ababa nabiy Jisas dikibir amaay asaay bir Jiruwsalimaar yikwabir God Juw Duw Takwaam Nyigildidiy Nyi bayaki kikipaat kikir. ");
INSERT INTO mle_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aw Jisas dikidiy nabiy tabatiy maan vitiy tidaak, bir a bayaki kikipatik Jisasawa yibir tayir yibiril pik. ");
INSERT INTO mle_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Adiy bayaki kikipata nyi kwusidaak, day abab dayadiy tipaar sibinin yidiy. Aw Jisas di kip Jiruwsalimaam kwaad. Aw Jisas alim kwadil, dikibir amaay asaay bir maa laakw. ");
INSERT INTO mle_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bir wukibir, “Di nyanadiy bapa duw takwawa yinaad.” Atawa wukikuw, bir kip yin tibir nyi nak. Yikuw, nyidi yabim si kwakir tikuw, bir dikik ata kwakibagwubir adiy birakidiy birakiwa yidiy gwalugwa duw takwawa kapa duw takwaam. ");
INSERT INTO mle_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bir dikim sitakir maarkuw, bir dikik ata kwakiyibir Jiruwsalimaar. ");
INSERT INTO mle_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bir Jiruwsalimaar yikuw, nyi mugwula yawaam bir ata sitakira-birid God dikidi wiyaam kwadik. Di kalivadiy duw daya nyidim daan rad. Dayadiy maaj wukitaay, niki jaav niki jaav bas sididiy dayak. ");
INSERT INTO mle_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Abab day diki maaj wukikuw, day pitaan wardiy dikidiy wadidiy majik. ");
INSERT INTO mle_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Dikibir amaay asaay dim vikuw, ata pitaan warkuw, diki amaay ata walid, “Wunadi nyan, min agwa javik atawa kwur-minabiran? Minadi asaywa wun an minak samasam wukikuw, an minak kwakibagwu-nabiran.” ");
INSERT INTO mle_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Di ata wadibir, “Agwa javik bir wunak kwakibagwu-nabirbirik? Bir maa laakw wun wunadi asaay wiyaam kwakik-tuwal?” ");
INSERT INTO mle_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aw bir maa laakw diki wadil majik. ");
INSERT INTO mle_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aw Jisas birakiwa Nasaritaar ata yad. Alim kwakuw, di biraki majib wukid. Aw li diki amaay kidiy ababa javik li kip mawulaar wukijibir tal. ");
INSERT INTO mle_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas di apawa mawul lakwu-wardik, Godawa duw dikim vikuw, yaakiya wadiy dikik. ");
INSERT INTO mle_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Taypiriyas nabiy tabatiy maan tabab Rom dayadi yitaypika duw tidik, Pantiyas Paylat Juwtiya tamiyak van tad Roma gavman ak. Yirat di Galiliy tamiyaam kwadiy duw dayadi yitaypika duw tad. Yirat dikidi mwaam, Pilip, di Yituwriyawa Tirakaniytas abir tamiyaam kwadiy duw dayadi yitaypika duw tad. Laysaniyas di Apilan tamiyaam kwadiy duw dayadi yitaypika duw tad. Anasawa Kayapas bir Juw dayabir yitaypika pris tibir. A nyaam Jon, Sakaraya dikidi nyan, di kipa tamiyaam kwadik, God dikik wadid, “Min yin wuna maaj awasapwiy duw takwak.” ");
INSERT INTO mle_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon di Jawtan bayibawa walibab ridiy tipaar yin yaan yibagwutaay, duw takwak wadidiy, “Gwur gwuradiy yigwuradiy valik bwan akwiy. Kwiykuw, baptais kwurkuw, God gwuradiy vaal yibwiy-kidadiy.” ");
INSERT INTO mle_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tayir God diki maaj wasapwiydi duw, Aysaya, ki maaj sukwudil Jon diki yawiyik. Di waad: “Duw nak kipa tamiyaam gaam sinaad, ‘Niki jaav niki jaav kwulapwun ada Yitaypika Duwak. Alik adi yaab tugwaam nakwaad. ");
INSERT INTO mle_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Adiy nibwukawa kwasadiy badaw vagwur, sapap sapap rikwadiy. Adiy kaw daan rinadiy tamiy kupw rimsuwgwur, viyasapilam nan rikwadiy. Adiy tamay wulaan wakwun rinadiy yaab vasakwugwur, sapap sapap rikwadiy. Adiy yabim warin daan rinadiy kupw yarakara mwugiygwur, sapap sapap rikwadiy. ");
INSERT INTO mle_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Atawa kwurgwur gwuradiy kwakwagwuradiy yabik, miyawa duw taakw ata vikidanaad ata ata God dayaam sugwiyaan kwurkidadiy.’” ");
INSERT INTO mle_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Duw taakw samasam Jonak yadiy dayak baptais kwiydikik. Dayaam vikuw, wadidiy, “God duw takwak yaal girakida nyi walibab tidalik, alik duw kapwiy yiy wapataka-dakib kabaay tabwu-kwadana pik wunak yanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","“Gwur gwuradiy yigwuradiy valik wukikuw, aw dayak bwan bwutaay kwiygwurdiy wakuw, viyakita yawiy akwur. Kwurgwur, aw ababa duw taakw vikuw, day lakwu-kidiy gwura maaj mwiya maaja. Mawulaam wagwura, ‘Nyan Aparam dikidi gwalugwa kidiy-adiyan. Alik nyan yara kwakinadiyan. God dikidiy duw taakw tikuw, di nyanaam kotiy maa.’ Atawa wakigwura, aal mwiya suwaala. Li God mawul warkida, di bwunak kidiy kabaak mwugiydik, Aparam dikidiy gwalugw tikinadiy. ");
INSERT INTO mle_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Ababa miy, adiy mwiy ri maarkinadiy, adiy miy God vilkuw, daan vakirdaak, yiyaar yakisawula-kidadiy. Atawa God kavin kwanaad gwuraam kotiy ik.” ");
INSERT INTO mle_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Adiy duw taakw Jon diki maaj wukikuw, pitaan warkuw, dikil ata bas sidaad, “Nyan agwa jaav kwurkidiyan?” ");
INSERT INTO mle_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Di dayak ata wadidiy, “Duw kwusuw wapwiy vitiy tikuw, adi kwusuw wapwiy ti maardi duwak nak akwiy! Kikipaat tidiy duw am sikuw, kipaat ti maardiy duw takwak akwiy!” ");
INSERT INTO mle_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nuwukadiy takis saan kwurkwanadiy duw dikik yakuw baptais kwurik, ata bas sidaad, “Kalivakwanadi duw, nyan agwa jaav kwurkidiyan.” ");
INSERT INTO mle_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Di dayak ata wadidiy, “Gwur gavman tasakwu-danadiy sanada akwur. Nuwukadiy kipa saan gwur gwurak kwur-tikwa.” ");
INSERT INTO mle_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nuwukadiy vay sawdiy duw dayabab bas sidaad, “Nyan agwa jaav kwurkidiyan?” Di dayak ata wadidiy, “Gwur kipa duw takwak gwur gwuradiy ap simaka-tikwa day gwurak yagakuw, saan kwiydakik. Gwur dayak suwaal taka-tikwa adiy saan kwurkwurik. Gwur gwurak gavman kwiydadiy sanadika akwur.” ");
INSERT INTO mle_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Adiy duw taakw Jon diki maaj wukikuw, dayadiy mawul warkuw, day ata wadiy, “Kidi duw di God dikidi Tasakwudidi Duw, ay maa?” ");
INSERT INTO mle_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aw Jon dayak ata wadidiy, “Wun gwaar gwurak baptais kwatiya-tuwadiygwur. Aw nikidi duw yakinaad. Adi duw mwiya yitaypika duw tinaad. Aw wun yisadapik tinadiwun. Alik wun adi duw dikidiy jaav yatayat maa rav. Adi duw baptais kwiy-kidadiygwur God dikidi Mawulawa yiyaar. ");
INSERT INTO mle_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Mwar viyalil nyaam duw nak adiy kabasik kitika jaav wit pakwiyir tapwutaay, yakisuwdakib. Mwar viyalik, adiy tika kabasikawa apa kabasik kapakap kapakap vakirdiy. Adiy duw adiy tika kabasik kwurjuwtakakuw, kamnaagw takakwada wiyaar kwurin karaydadiy. Adiy apa kabasik kwurjuwtakakuw, nyi gaan nyi gaan yanin tikwana yiyaar yakisawula-dadiy yiy yandakik. Atawa God viyakitawa kupwarapa duw takwaam kwurkidadiy.” ");
INSERT INTO mle_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Niki majir niki majir Jon duw takwak God diki viyakita maaj wasapwiy-didiy. ");
INSERT INTO mle_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yirat, Juw dayadi yitaypika duw, di dikidi mwaam diki taakw, Yiratiyas, kiradil. Di samasama nuwukadiy kupwarapa yawiy ab kwurdidiy. Alik Jon maa waad dikik. ");
INSERT INTO mle_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aw Jon maa wakuw wadik, Yirat niki kupwarapa yawiy kwurdil. Di Jonaam kalabus ir kwusawuladid. ");
INSERT INTO mle_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Aw tayir Yirat Jonaam kalabus ir kwusawul maardik nibway, Jon ababa duw takwak baptais kwiyin napakuw, Jisasak ata baptais kwiydid. Jisas Godak maaj bwulataay tidik, God adawur tubw ata kajatakadid. Adawur tubw kajatakakuw, God dikidi Mawul ata daad midakim kaytik Jisasak. Jisas ata ki God wadil maaj wukidil, “Min wunadi mawul yituwadi Nyan-adimin. Wun rakarak tinadiwun minak.” ");
INSERT INTO mle_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Jisas diki yawiy bas kwurdil dikidiy nabiy duwamiy nak sap tabatiy tidiy. Duw taakw lakwudaal di Jawsip dikidi nyan-ad. Jawsip dikidi asaay, Yilay. Yilay dikidi asaay, Matat. Matat dikidi asaay, Liyvay. Liyvay dikidi asaay, Milkay. Milkay dikidi asaay, Janay. Janay dikidi asaay, Jawsip. Jawsip dikidi asaay, Matatayas. Matatayas dikidi asaay, Amas. Amas dikidi asaay, Nam. Nam dikidi asaay, Aslay. Aslay dikidi asaay, Nakay. Nakay dikidi asaay, Maat. Maat dikidi asaay, Matatayas. Matatayas dikidi asaay, Siman. Siman dikidi asaay, Jawsik. Jawsik dikidi asaay, Juwta. Juwta dikidi asaay, Jawnan. Jawnan dikidi asaay, Risa. Risa dikidi asaay, Sirapapal. Sirapapal dikidi asaay, Siyaltiyal. Siyaltiyal dikidi asaay, Niray. Niray dikidi asaay, Milkay. Milkay dikidi asaay, Atay. Atay dikidi asaay, Kasam. Kasam dikidi asaay, Almatam. Almatam dikidi asaay, Aya. Aya dikidi asaay, Jasuwa. Jasuwa dikidi asaay, Yiliyasa. Yiliyasa dikidi asaay, Jawrim. Jawrim dikidi asaay, Matat. Matat dikidi asaay, Liyvay. Liyvay dikidi asaay, Simiyan. Simiyan dikidi asaay, Juwta. Juwta dikidi asaay, Jawsip. Jawsip dikidi asaay, Janam. Janam dikidi asaay, Aliyakim. Aliyakim dikidi asaay, Maliya. Maliya dikidi asaay, Mina. Mina dikidi asaay, Matata. Matata dikidi asaay, Natan. Natan dikidi asaay, Davit. Davit dikidi asaay, Jisiy. Jisiy dikidi asaay, Awpit. Awpit dikidi asaay, Bawas. Bawas dikidi asaay, Salman. Salman dikidi asaay, Nasan. Nasan dikidi asaay, Aminatap. Aminatap dikidi asaay, Atmin. Atmin dikidi asaay, Anay. Anay dikidi asaay, Yisran. Yisran dikidi asaay, Piris. Piris dikidi asaay, Juwta. Juwta dikidi asaay, Jakap. Jakap dikidi asaay, Aysak. Aysak dikidi asaay, Aparam. Aparam dikidi asaay, Tara. Tara dikidi asaay, Naar. Naar dikidi asaay, Sirak. Sirak dikidi asaay, Riyuw. Riyuw dikidi asaay, Pilik. Pilik dikidi asaay, Yipa. Yipa dikidi asaay, Sila. Sila dikidi asaay, Kaynan. Kaynan dikidi asaay, Apakasat. Apakasat dikidi asaay, Sim. Sim dikidi asaay, Nawa. Nawa dikidi asaay, Lamak. Lamak dikidi asaay, Mituwsala. Mituwsala dikidi asaay, Yinak. Yinak dikidi asaay, Jarat. Jarat dikidi asaay, Mayalalil. Mayalalil dikidi asaay, Kaynan. Kaynan dikidi asaay, Yinas. Yinas dikidi asaay, Sit. Sit dikidi asaay, Atam. Atam dikidi asaay, God. ");
INSERT INTO mle_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","God dikidi Mawul Jisasaam wapwurukwudik, Jawtan bayib wapadid. God dikidi Mawul ata Jisasaam kwurin karaydid duw taakw kwu maardaal tamiyaar. Alim nyi duwamiy vitiy Satan dikim vasibariyik kwurdid. Adiy nyi duwamiy vitiy yidaak, Jisas kikipaat ki maarkuw, ata kaam yasad. ");
INSERT INTO mle_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kaam yasadik, Satan Yisasak yakuw, ata wadid, “Li min mwiya God dikidi Nyan-adimin wakuw, ki kabakik wamin bret suwul-likik.” ");
INSERT INTO mle_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas dikik ata wadid, “Atawa maa. Aw God diki maaj kitawa wana, ‘Duw taakw bret-adikanir akis kwaya-kwanadiy.’” ");
INSERT INTO mle_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satan Jisasaam kwurin nibwukir kawarkuw, jayib ni ababa kidi kupwaam ridiy jaka tip simakadidiy. ");
INSERT INTO mle_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Satan simakaan napakuw, ata wadid, “Kidiy ababa jaka tipawa duw taakw dayadiy javiwa miyawa wuna tabaam rinadiy, God yaakiya wakuw. Wuna mawul yaakiya wakinadi duwak kwiy-kituwadiy dayaam van tidikikik. Aw li min wunak kwatiyir sikuw, gaba maaj sukwukimina, kidiy ababa jaav minak kwatiya-kituwadimin.” ");
INSERT INTO mle_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas Satanak wadid, “God diki maaj wana: ‘God minadi Yitaypika Duw, dikik gaba maaj asukw. Diki danik yawiy akwur!’” ");
INSERT INTO mle_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","10","Satan Jisasaam ata kwurin karaykuw Jiruwsalimaar, apiy God dikidi gaba maja wiyaam takadid. Takakuw, ata wadid, “Min mwiya God dikidi Nyan-adimin wakuw, atay vakirmin kiladi kupwaar. Aw God diki maaj wana: ‘God maaj kwiykidadiy dikidiy maaj kardadiy duw minak, aw day minak yarakara van tikidanadimin kupwaraap tikik-nadimin wakuw.’ ");
INSERT INTO mle_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Niki maaj ab wana: ‘Dayadiy tabaar minaam kaykitidaak, aw min kabakim maan taab viy maa.’” ");
INSERT INTO mle_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisas Satanak ata wadid, “Atawa maa. Aw ki maaj ab God diki lapa nyigaam rina: ‘Min kidi Yitaypika Duw minadi God, dim wasapwun vasibariyik kwur-tikwa.’” ");
INSERT INTO mle_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan dikidi Jisasaam wasapwun vasibariyik kwurdidiy yawiy yin kwusidaak, Jisasaam Satan wapadid, ginyir sibinin yakuw, wasapwun vasibariyik kwurik maa wukin tikuw. ");
INSERT INTO mle_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","God dikidi Mawul ap Jisasak kwiydik, Jisas Galiliyaar ata sibinin yad. Sibinin yidik, abab a tamiya kidiy duw taakw day dayak Jisasak bwulabagwudiy. ");
INSERT INTO mle_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Di dayak Juw dayadiy gaba maja wiyaam kalivadik, day abab wayapiy sidaad. ");
INSERT INTO mle_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Jisas di kwasa nyan tikuw, ap yiwardil tip Nasarit, a tipaar yad. Ababa Sapat nyi Jisas Juw dayadiy gaba maja wiyaar yikwaad. Alik Sapat nyi yalik, di ata dayadi gaba maja wiyaar yad. Wiyaar wulakuw, di ata rasin tad God diki lapa nyigaam rina maaj wakir. Day ata God diki maaj wasapwiydi duw, Aysaya, diki sukwudil lapa nyig dikik kwiydaak, di ata ki maaj kwalil tamiy sitakirakuw, dayak ki maaj ata wadil: ");
INSERT INTO mle_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Yitaypika Duw God tasakwu-didiwun diki viyakita maaj wasapwiy-tuwkik saal yinadiy duw takwak. Alik God dikidi Mawul wunaam tikwanaad. God wayaki-didiwun adiy vaal tabaam kwanadiy duw takwak wakuw, dayaam takatipin tinadi vaal likidi yaab wapadakik, adiy mil kwakinadiy duw takwak wakuw, day mwiyir vidakikik, adiy duw taakw nuwukadiy duw jawjaay kwurnadiy dayaam, dayak wakuw, day yara kwadakikik, adiy ababa duw takwak watuwkikik God diki yarakara duw takwak kwurkida nyi aka tina wakuw.” ");
INSERT INTO mle_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas lapa nyig takatipikuw, gaba maja wiya duwak sibinin kwiykuw, ata daan rad adiy duw takwak kalivaak. Daan ridik, adi gaba maja wiyaam ridiy ababa duw taakw day dikik vivikadiy. ");
INSERT INTO mle_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Di dayak ata wadidiy, “Kita, ki nyi, wun kidiy maaj gwurak watuwik, adiyka mwiya mwiyaba maaj aka tina.” ");
INSERT INTO mle_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ababa duw taakw a maaj wukikuw, day ata pitaan wardiy. Pitaan warkuw, dayadiy mawul samasam wukidiy diki wadil viyakita majik. Day ata wadiy, “Kad Jawsip dikidi nyan-ad, ay maa?” ");
INSERT INTO mle_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Di dayak ata wadidiy, “Ki wakwagwura kwasa maaj, ‘Dokta, mina giviyib min mina asipwutiy,’ wun lakwutuwa gwur wunak wakigwuradiwun. Niki maaj ab wakigwuradiwun. Gwur wakigwura, ‘Nyan minadiy Kapanam tipaam kwurminidiy nimadiy yawiy bwu wukibadiy. Aw min atampika yawiy ki min minakil tipaam akwur.’ ");
INSERT INTO mle_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Aw wun watuwadiygwurik God diki maaj wasapwiydiy duw day dayadiy kapa tipa kidiy duw taakw kwasik yikwanadiy dayadiy maaj wukiwukik. ");
INSERT INTO mle_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","“Gwur wunak awuk. Tayir God diki maaj wasapwiydi duw, Yilayja, kwadik, tawtakw kwadiy taakw samasam Yisrayil jaka tipaam kwadiy. A sikir waal maa ji nabiy mugwul tabikalib nak. Atawa tikuw, ababa duw taakw dayadiy maay rik yidaak, day kamik kwadiy. God Yilayja maa wayak adiy Yisrayil jaka tipa kidiy tawtakw kwadiy takwak sugwiyaan kwurdikik. Aw di Yilayja wayakidid niki jaka tipa kil tawtakw kwaal takwak likik sugwiyaan kwurdikik. Li Saydan jaka tipaam ril tip Salapat alim kwaal. ");
INSERT INTO mle_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Ginyir God diki maaj wasapwiydi duw, Yilaysa, kwayadik, Yisrayil jaka tipaam lepa giviyib kwurdiy duw taakw samasam kwadiy. Aw Yilaysa di dayaam maa sipwutiy. Di duw nak sipwutiydid. Adi duw Siriya jaka tipa kidi duw Nayman-ad.” ");
INSERT INTO mle_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ababa gaba maja wiyaam kwadiy duw taakw Jisas wadil maaj wukikuw, day lakwukuw, Jisas dayak kipwu mwutaam yikuw, yaal giradiy dikik. ");
INSERT INTO mle_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","Day rasikuw, Jisasaam kaykitikuw, lakwun kalakwudaad mala tipaam ridi abwa nibwukir. Day Yisasaam giraril yakisadak kwurdaal, aw day maa rav. Jisas daya nyidim tiytiyaan tikuw, ata wapadidiy. ");
INSERT INTO mle_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dayaam wapakuw, Jisas Galiliyaam ril tip Kapanam a tipaar ata yaad. Alim Sapat nyaam duw takwak kalivadidiy. ");
INSERT INTO mle_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Di apawa kalivadidiy. Alik day diki maaj wukikuw, pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Duw nak adi gaba maja wiyaam kwaad. Adi duw tayir diki mawulaar wudib yidid. Di Jisasak nimadib gaam sidid, “Jisas Nasarit tipa kid, min agwa jaav kwurik nyanaam? Min nyanaam viyapakwuk? Wun bwutaay lakwu-tuwadimin. Min God dikidi viyakita kapaba duw-adimin!” ");
INSERT INTO mle_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisas nimadib adi wudibak ata wadid, “Min kaygan ada! Min kidi duwaam ata awap!” Adi wudib mwugiydik, adi duw kupwaar ata vakirid. Vakirkuw, adi wudib adi duwaam jawjaay kwar maarkuw, wapadid. ");
INSERT INTO mle_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ababa duw taakw a jaav vikuw, pitaan warkuw, day daya wadiy, “Kidi duw diki maaj ata ata? Di duw taakw dayadiy mawulaam rinadiy wudibak apawa wadik, day ata wapadanadiy!” ");
INSERT INTO mle_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A tamiyaam kwadiy duw taakw abab ata wukidaal Jisas kwurdil yawiyik. ");
INSERT INTO mle_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas daya gaba maja wiy wapakuw, Sayman diki wiyaar ata yad. Sayman diki nakim barik kwaal liki sip kuwkuw nalik. Alik day Jisasak wadaad likik. ");
INSERT INTO mle_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jisas daya maaj wukikuw, liki si kwalil tamiyaar yikuw, liki si kwalil jabawa tikuw, di nimadib li liki giviyibak wadik, jayib nak liki sip ata nikir tayil. Taylik, rasikuw, dayak kikipaat ata sukwulik yal. ");
INSERT INTO mle_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Giraab nyi dadik, Sapat nyi kwusilik tikuw, alik duw taakw ababa niki giviyib niki giviyib kwurdiy duw taakw kwurin karaykuw Jisasak, di taab dayaam takakuw, abab sipwutiydidiy. Di samasama duw taakw dayadiy mawulaam ridiy wudib kwurin yakikuw, day nimadib gaam sidiy, “Min God dikidi Nyan-adimin,” wakuw. ");
INSERT INTO mle_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Adiy wudib lakwudiy Jisas di God dikidi Tasakwudidi Duw-ad, alik Jisas watipi-didiy duw takwak wawak a javik. ");
INSERT INTO mle_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sirapik, ganib gitigit nalik, Jisas a tip wapakuw, tamiyka tamiyaar yad Godawa maaj bwulak. Yidik, ababa duw taakw kwakiyin kwakiyan tikuw, ata sitakira-daad. Dikik yikuw, day wadaad, “Min nyanawa adakw. Nuwukadiy tipaar yitikwa.” ");
INSERT INTO mle_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aw Jisas dayak ata wadidiy, “Wun nuwukadiy tipaam ab duw takwak Viyakita Maaj wasapwiy-kidiwun ata ata God duw takwak van tinaad. Ki yawiyik God wayakidik, dadiwun.” ");
INSERT INTO mle_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Atawa tikuw, Jisas Juwtiya miyawa tamiyaam titaay, dayadiy gaba maja wiyaam God diki Viyakita Maaj wasapwiyid. ");
INSERT INTO mle_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nyi nak Jisas Ginisarit mala araam tidik, duw taakw day dikik wapwan wapwan vagaluwdiy diki wadil God diki maaj wukik. ");
INSERT INTO mle_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisas vidibir jabir vitiy lagwusuwdaak, yawiyaam ribir. Adiy kamiy kwurdiy duw bwutaay abir jabir wapakuw, dayadiy nagir guwaam kawusak wakwudiy. ");
INSERT INTO mle_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas ata salin daad jabir nikim. A jabir aal Sayman dikila. Jisas ata Saymanak bas sidid kwasa mwiy guwaar wapasakwu-dikik. Jisas ata a jabiraan daan rikuw, vagaluwdiy duw takwak kalivadidiy. ");
INSERT INTO mle_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jisas diki maaj wakwusin napakuw, Saymanak ata wadid, “Ki jabir wapasakwu-min tipwukina tamiyaar kwasa wakwukwa. Wakwulik, minawa minadiy kapa nyanugwawa gwuradiy nagir ayakisad kamiy kwurik.” ");
INSERT INTO mle_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aw Sayman dikik ata wadid, “Sapakwa duw, nyan miyawa gaan yawiy kwurdiyan kamiyik. Aw samab kamiy maa kwar. Aw li min yarakara wakimina, nyan kidiy nagir tawkibanadiy gwaam.” ");
INSERT INTO mle_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Day ata adiy nagir gwaar kwusada-dadiy. Kwusadakuw, kamiy samasam miyawa nagir kapwudaak, adiy nagir takwuk kwurdiy. ");
INSERT INTO mle_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Aw day ata niki jabiraam kwadiy duwak taab viyataka-dadiy yadakikik dayak sugwiyaan kwurdakik. Day yakuw, abir jabir vitiykilib kamiy kwurtakadaak, wapwurukwukuw, gwaar tipik kwurbir. ");
INSERT INTO mle_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aw Sayman Pita a jaav vikuw, Jisas diki manwa kwatiyir kwatiyir vakirkuw, ata wadid, “Yitaypika duw, wun vaal yinadi duw-adiwun! Alik min wunaam awap!” ");
INSERT INTO mle_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saymanawa diwa kwadiy duw day dayadiy kwurdadiy kamiy vikuw, ata pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saymanawa yawiy kwurbir duw Sipatiy dikibir nyidiy, Jamisawa Jon, birabab pitaan warbir. Jisas Saymanak ata wadid, “Min yaga-tikwa. Ki nyab karayrib duw kwurkidimin wunadiy tidakikik kidiy kamiy kwurmina pik.” ");
INSERT INTO mle_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Day dayabir jabir yawiyaar lagwusuwkuw, ababa jaav wapakuw, Jisas kwukib ata yidiy. ");
INSERT INTO mle_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisas niki tipaam kwadik, duw nak, lepa giviyib dim kwurlik, diki sip miyawa pwusal, alim kwaad. Di Jisasaam vikuw, kupwaam vakirkuw, nimadib wadid, “Yitaypika Duw, mina mawul warlik, wuna sip sipwutiy-kimina.” ");
INSERT INTO mle_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisas taab ata dikim takakuw, ata wadid, “Wun minak sipwutiyik viyakit timinkikik.” Ata wadik, adi lepa duw diki sip viyakita mwiy tal. ");
INSERT INTO mle_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisas dikik ata wadid, “Kipa duw takwak wawayik ki javik. Aw yirib maay pris ak mina sip vidikikik. Tayir Mawsis gwurak wadidiy jaav akwiy pris ak God kwiydikik. Alik ababa duw taakw lakwu-kwadiy mina giviyib aka bwu kwusina.” ");
INSERT INTO mle_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aw adi duw Jisas diki kipa duw takwak wawayik wadil majib maa wak. Di samasama duw takwak Jisas kwurdil yawiyik wasapwiydik, duw taakw samasam adi duw diki maaj wukikuw, Jisasak yadiy di dayadiy giviyib sipwutiy-dikik. ");
INSERT INTO mle_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nuwukadiy nyi di duw taakw kwu maardadiy tamiyaar yikuw, alim Godawa maaj bwulaad. ");
INSERT INTO mle_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nyi nak Jisas di duw takwak kalivadik, nuwukadiy Parasiyawa God diki lo kalivadiy duwawa alim ridiy Jisas diki maaj wukik. Day ababa Galiliyawa Juwtiya tamiyaam ridiy tipawa Jiruwsalim tipa kidiy. Yitaypika Duw God diki ap Jisasawa tilik, Jisas giviyib kwurdiy duw takwaam sipwutiy-didiy. ");
INSERT INTO mle_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nuwukadiy duw ap lupwun ridi duw bayim takakuw, kariyadaad Jisasak. Day adi duw kariyakuw, Jisas mwutamawa takak kwurdaal, maa rav. ");
INSERT INTO mle_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Samasama duw taakw vagaluwkuw, yaab takatipidaal. Alik tikuw, apiy wiyaar kawarkuw, apiy wiyaam tap kajatakakuw, adi rididi bayim tabik tabikim yaav jitakakuw, Jisasawa vagaluwdiy duw taakw daya nyidir kwusadataka-daad Jisas diki mwutamawa. ");
INSERT INTO mle_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aw Jisas di rikuw, adiy duw day wukijibir tidiy di bwunak adi duwaam sipwutiy-kidaad wakuw, ap lupwudi duwak ata wadid, “Kapa duw, minadiy vaal wun yibwiy-tuwadiy.” ");
INSERT INTO mle_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Adiy God diki lo kalivadiy duwawa Parasiy day dayak ata ritaay wasakiy saladiy, “Kidi duw sikanadaad? Agwa javik di Godak sapis jikin kwurnaad? God didika duw taakw dayadiy vaal yibwiykwaad. Kipa duw yibwiy yibwiy maa rav.” ");
INSERT INTO mle_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","24","Jisas di lakwudil dayadiy mawulaar ritaay, bwuladadiy maaj. Alik di dayak ata wadidiy, “Gwur agwa javik gwuradiy mawulaar ritaay, atawa bwulabagwu-nadiygwurik? Agwa jaava kakilkina wun kwurkwurik, aw gwur vikuw, yaakiya wakigwura a javik wuna maaj mwiya maaj waan wakuw? Kidi ap lupwudi duwak wakituwaad, ‘Minadiy vaal yibwiy-tuwadiy,’ ay ‘Min arap! Rapikuw, minadi baay kwurkuw, min tiytiyaan ada?’ Wun aka simaka-kituwadiygwur wun duw taakw dayadi Mwaam ap tikwanadiwun kidi kupwaam duw taakw dayadiy vaal yibwiy-yibwiyik.” Wakuw wadik, di adi ap lupwudi duwak ata wadid, “Wun minak watuwa aras! Minadi baay kwurkuw, maay mina wiyaar!” ");
INSERT INTO mle_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jayib nak adi duw rasikuw dayadiy mwutamaam, di dikidi daan rididi baay kwurkuw, Godak wayapiy sin sin diki wiyaar ata yad. ");
INSERT INTO mle_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Day abab a jaav vikuw, pitaan warkuw, yagakuw, Godak wayapiy sidiy. Day wadiy, “Wa! Nibwul vibana jaav talab talab akis viy-kwadaal!” ");
INSERT INTO mle_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ginyir Jisas wakwukuw, takis saan kwurdi duw dikidi si Liyvay vidid diki opis im ridik. Jisas ata wadid, “Wuna kwukib may.” ");
INSERT INTO mle_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Liyvay rasikuw, dikidiy ababa jaav wapakuw, Jisas diki kwukib ata yad. ");
INSERT INTO mle_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Liyvay nima bayaki kikipaat diki wiyaam mwugiydil Jisasak. Samasama takis saan kwurdiy duwawa nuwukadiy vaal yidiy duw birakiwa nakamwiyib daan ridiy kikipaat kikir. ");
INSERT INTO mle_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nuwukadiy Parasiyawa God diki lo kalivadiy duwawa, day adiy Parasiy bapa duw tidiy, day Jisas dikidiy kalivadidiy duwak wasupwu-dadiy, “Agwa javik gwur kikipaat kan guw kan takis saan kwur-kwanadiy duwawa nuwukadiy vaal yinadiy duwawa?” ");
INSERT INTO mle_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisas dayak ata wadidiy, “Adiy giviyib kwar maarnadiy duw akis dokta ak yikwanadiy. Adiy giviyib kwurkwanadiy duwadika dokta ak yikwanadiy. ");
INSERT INTO mle_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“Wun adiy ‘Wunaam vaal maa ri’ wakwanadiy duw takwak maa yay day dayadiy bwan kwiydakik dayadiy valik. Wun adiy vaal yikwanadiy duw takwak yanadiwun day dayadiy yikwadanadiy valik bwan kwiydakik.” ");
INSERT INTO mle_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nuwukadiy duw taakw Jisasak yakuw, wadaad, “Jon Baptais kwiynadi duw, dikidiy kalivadidiy duwawa adiy Parasiy dayadiy kalivadanadiy duwawa nuwukadiy nyi kikipaat akis kikwadanadiy gaba maaj sukwuk Godak. Aw agwa javik tikuw, minadiy kaliva-minadiy duw nyanyi kikipaat kan guw kikwanadiy?” ");
INSERT INTO mle_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aw Jisas dayak ata wadidiy, “Duw taakw kiradil nyaam dikidiy kapa nyanugw dikik rakarak tikuw, gwur nikil kikipaat watipi-kigwuradiy di dayawa kwadik? Gwur atawa kwur-kwur maa rav! ");
INSERT INTO mle_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","“Nyi yakina taakw kiranadi duw di dayawa tidik, nuwukadiy duw yakuw, kalakwukuw, kwurin karay-kidanaad. A nyaam dikidiy kapa nyanugw dayadiy mawul pakwum nadaak, kikipaat ki maa.” ");
INSERT INTO mle_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisas ki waya maaj kitika maaj wadidiy, “Duw kwula wapwiy kwurkuw, kwasa kitikikuw, jaba wapwiyim tipatip maa rav. Aw atawa kwurkida, kwula wapwiy karyakin yikuw, abir wapwiy rivriv ti maa. Aw atawa kwurkuw, dikibir wapwiy kupwaraap tikinabir. ");
INSERT INTO mle_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Aw duw akis meme likidi sip jaab tidaak, kwula wain kwurkuw, adi sipaam vagavag maa rav. Adi sip wain awa wulawul maa rav, alik wutak-na aw sipawa wain kupwaraap tikinabir. ");
INSERT INTO mle_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","“Duw kwula wain kwula meme sipaam vagakwanadiy. ");
INSERT INTO mle_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Duw tayir mwugiy-dadiy wain kwurkuw, kwasik kwula wain kikak, ‘Tayir mwugiy-dadiy wain viyakit-adiy,’ wakuw.” ");
INSERT INTO mle_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jisas kon ridadi mayim tiytiyan tad Sapat nyaam. Yitaay tidaak, dikidiy kalivadidiy duw nuwukadiy kon dayadiy mwiy kwurkuw, tabaar gajikuw, kidadiy. ");
INSERT INTO mle_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nuwukadiy Parasiy a jaav vikuw, wadadiy, “Nyana lo atampika yawiy Sapat nyaam kwurkwurik maa wana. Agwa javik tikuw, gwur atawa kwur-nadiygwurik?” ");
INSERT INTO mle_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Jisas dayak ata wadidiy, “Lapa nyigaam Davit kwurdil jaav sukwudaal gwur likim maa laakw? Di dikidiy duwawa kaam yasadaak, kikipaat kikir. Alik Davit God dikidi wiyaar wulakuw, pris Godak kwiydadiy bret dikik kwiykuw, di dikidiy duwak nuwukadiy kwiykuw, day diwa ata kidadiy. Aw nyana lo wana, ‘Pris dayadika adiy bret kikwadanadiy. Nuwukadiy duw taakw akis kikwadanadiy.’ Aw li gwur yaakiya wakwagwura Davit diki kwurdil yawiyik, agwa javik tikuw gwur maa wanadiygwur wunadiy kalivatuwadiy duw daya yawiyik?” ");
INSERT INTO mle_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisas dayak ata wadidiy, “Wun, duw taakw dayadi Mwaam, Sapat nyak van tikwanadiwun. Alik tikuw, adiy yaakiya watuwadiy yawiy jaav duw taakw kwurkwadiy Sapat nyaam.” ");
INSERT INTO mle_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Niki Sapat nyaam Jisas Juw daya gaba maja wiyaar wulakuw, vagaluwdiy duw takwak kalivadidiy. Duw nak, diki mava baw taab bwu kiyaal, alim rad. ");
INSERT INTO mle_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nuwukadiy Gpd diki lo kalivadiy duwawa Parasiy day Jisasak van kavin kwadiy aal di adi duw diki taab sipwutiydakik Sapat nyaam. Day sukwupirkuw, dikik wakir a javik. ");
INSERT INTO mle_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aw Jisas dayadiy mawul lakwukuw, adi baw taab kiyadi duwak ata wadid, “Min aras. Rasikuw, min kiril may.” Adi duw rasikuw, Jisasak yikuw, diwa tad. ");
INSERT INTO mle_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jisas dayak ata wadidiy, “Wun gwurak kwasa maaj bas sikir. Agwa yawiy nyana lo yaakiya wana nyan kwurkwurik Sapat nyaam? Nyan sugwiyaan kwurik duw takwak, ay? Jawjaay dayak kwurkibanadiy, ay? Kiyak kwurnadiy duw taakw sipwutiy-kibanadiy, ay? Duw takwaam viyasipa-kibanadiy, ay?” ");
INSERT INTO mle_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jisas vagaluwdiy duw takwak kitay kitiy vikuw, adi baw taab kiyadi duwak ata wadid, “Min mina kupwarapa taab amwugiysakw.” Di atawa mwugiysakwudik, diki taab ata viyakit tal. ");
INSERT INTO mle_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aw adiy God diki lo kalivadiy duwawa Parasiy a jaav vikuw, dayadiy mawul kuwkuw nakuw, day daya wadiy, “Nyan agwa jaav kwurkibanaad Jisasaam?” wakuw. ");
INSERT INTO mle_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Adiy nyaam Jisas nibwukir warid maaj bwulak Godawa. Miyawa gaan maaj bwulaad. ");
INSERT INTO mle_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ganbab kariyalik, dikidiy kalivadidiy duwak gaam sididiy day yadakikik dikik. Dikik yadaak, tabatiy maan vitiy tasakwu-didiy. Adiy duw di sikiydidiy dikidiy wayakididiy duwadiy. ");
INSERT INTO mle_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Dayadiy si kidiyka: Sayman Jisas sikiydid Pita, dikidi nyamwus Adiruw, Jamisawa Jon, Pilipawa Batalimuw, Matiyuwawa Tomas, Alpiyas dikidi nyan Jamisawa Sayman di gavman ak wariyak yikwada duw-ad, Jamis dikidi nyan Juwtasawa Juwtas Yiskariyat. Adi Juwtas Yiskariyat, ginyir Jisas dikidiy mama nib dayadiy tabaam takadid. ");
INSERT INTO mle_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nibwukim tikuw, dayawa dakuw, Jisas dikidiy samasama kalivadidiy duwawa visapilayakikuw sapap sapap ril tamiyaam vagaluwdiy. Samasama Juwtiya tamiya kidiy duw taakw, nuwukadiy Jiruwsalim tipa kidiy, nuwukadiy abir nabis im ribir tip Tayawa Saytan tipa kidiy, alim vagaluwdiy. ");
INSERT INTO mle_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Day Jisasak yadiy di dayadiy giviyib sipwutiy-dikik. Adiy wudib mawulaar yidiy day abab dikik yadaak, sipwutiy-didiy. ");
INSERT INTO mle_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ababa duw taakw day lakwudaal Jisas diki ap duw taakw dayadiy giviyib sipwutiy-lidiy. Alik tikuw, day diki sipaam wapwan kwurdakib, dayadiy giviyib sipwutiydiy. ");
INSERT INTO mle_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas dikidiy kalivadidiy duwak kitay kitiy vikuw, wadidiy, “Gwur saal yikwanadiy duw taakw, God dikidi gwalugw gwurakid-ad. Alik tikuw, gwur rakarak ada. ");
INSERT INTO mle_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Gwur kita kaam yasikwanadiy duw taakw ginyir gwuradiy yaal rivikidiy. Alik tikuw, gwur rakarak ada. Gwur kita girakwanadiy duw taakw ginyir waji-kidiygwur. Alik tikuw, gwur rakarak ada. ");
INSERT INTO mle_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Duw taakw dayadi Mwaam diki danik duw taakw maa wakuw gwurak, bwan kwiyin gwurak, sapis jikin kwurin gwurak, ‘Gwur kupwarapa duw taakw-adiygwurik’ waan wadaak, gwur rakarak ada. ");
INSERT INTO mle_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Adiy gwuradiy maa wakinadiy duw taakw dayadiy gwalugwadiy duw taakw tayir atawa kwurdiy God diki maaj wasapwiydiy duwaam. Aw li day gwurak atawa kwurdaak, God ginyir adawur tipaam adiy dikidiy diki maaj wasapwiydiy duwak kwurkida pik viyakit kwur-kidadiygwurik a javik. Alik tikuw, gwuradiy mawul rakarak ada miyawa. ");
INSERT INTO mle_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Gwur saan samasam tikwanadiy duw taakw, kita gwur bwutaay viyakita mwiy kwanadiygwurik. Aw mwiya kupwaraap tikina gwurak ginyir. ");
INSERT INTO mle_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Gwur kita kikipaat samasam kikwanadiy duw taakw, ginyir mwiya kupwaraap tikina gwurak. Gwur kaam yasan tikidiygwurik. Gwur kita waji-kwanadiy duw taakw, ginyir mwiya kupwaraap tikina gwurak. Gwur giraan tikidiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ababa duw taakw sukwasukw kwurdaak gwurak, gwurakil yarakara ada. Aw ginyir mwiya kupwaraap tikina gwurak. Tayir dayadiy gwalugwa duw taakw atawa kwurdiy adiy suwaal takadiy duwak day apap apap kwurdiy day God diki maaj wasapwiydiy duw titak.” ");
INSERT INTO mle_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jisas niki maaj dayak wadidiy, “Gwur wuna maaj wukinadiy duw taakw, wun gwurak waaw. Gwuradiy mawul gwuradiy mama nibak yikwadiy. Adiy duw taakw day maa wakwanadiy gwurak, gwur viyakita yawiy akwur dayak. ");
INSERT INTO mle_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Aw li duw yanuw gwuraam kwurdik, gwur Godak bas as di viyakit kwurkida dikik. Aw li duw jawjaay gwuraam kwurdik, gwur Godak bas as dikik. ");
INSERT INTO mle_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Aw li duw taab kaygipakuw gwuradiy wasa apaam viyadik, jaaw niki wasa ap ab akwiy viyadikik. Aw li duw gwuradiy apiyir kwusuwgwuradiy wapwiy kaypwutiykuw kwurdaak, awaraar kwusuw-gwuradiy wapwiy ab jaaw kwurkwaad. ");
INSERT INTO mle_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Aw li duw taakw gwuradiy javik kwurik bas sidaak, jaaw adiy jaav dayak akwiy. AW li duw taakw gwuradiy jaav kwurdaak, gwur dayak wasipi-tikwa sibinin kwiydakik. ");
INSERT INTO mle_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Gwur nuwukadiy duw taakw gwuraam yarakara kwurdakik wukigwura pik, atampik nuwukadiy duw takwak akwur. ");
INSERT INTO mle_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Vaal yikwanadiy duw taakw dayadiy mawul adiy dayak mawul yikwanadiy duw takwak awarab yikwanadiy. Aw li gwuradiy mawul adiy gwurak mawul yikwanadiy duw takwadikanik wuki-kigwura, agwa javik God gwurak rikarik kwur-kidadiygwurik? ");
INSERT INTO mle_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Vaal yikwanadiy duw taakw adiy dayak viyakit kwurkwanadiy duw takwak viyakit kwurkwanadiy. Aw li gwur atampik kwurkigwura, agwa javik God gwurak rikarik kwur-kidadiygwurik? ");
INSERT INTO mle_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Vaal yikwanadiy duw taakw day dayadiy jaav nuwukadiy vaal yikwanadiy duw takwak basadika kwiy-kwadanadiy ginyir maa dayak atampika javib sibinin kwiydakik. Aw li gwur gwuradiy jaav basadika kwiy-kigwuradiy adiy duw takwadikanik gwur lakwu-gwuradiy ginyir gwurak sibinin maa kwatiya-kidanadiygwurik, agwa javik God gwurak rikarik kwur-kidadiygwurik? ");
INSERT INTO mle_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","“Atawa maa! Gwuradiy mawul gwuradiy mama nibak yikuw, dayak yarakara akwur. Gwuradiy jaav nuwukadiy duw takwak basadika kwiykuw, ginyir wuki-tikwa adiy jaav sibinin kwur-kwurik. Atawa kwurkigwura, mwiya nimadi God ginyir gwuradiy saam yakisuwtaka-kidadiy, ‘Gwur wunadiy nyanugwa yawiy pik kwurgwuradiy,’ wakuw. Gwuradi adawur tipaam kwanadi Asaay dikik wukimar-kwanadiy vaal yikwanadiy duw takwak wukikwanaad. Di kip rikarik kwur-kwanaad dayak. Gwur diki pik dayak awuk.” ");
INSERT INTO mle_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jisas niki maaj wadidiy, “Aw li gwur maa waan wasapwun kwur maarkigwura nuwukadiy duw takwaam, God atawa kwar maa gwuraam. Aw li gwur duw taakw gwuraam yidadiy vaal yibwiy-kigwura, God ab atawa kwurkinaad gwurak. ");
INSERT INTO mle_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Nuwukadiy duw takwak kwiygwura pik, atampik God ab gwurak kwatiya-kidadiygwurik. Aw God gwurak sibinin kwatiyadik, di gwurak kwasa am kwatay maa. Mwiya nima am gwurak kwatiya-kidadiygwurik. Aw li nuwukadiy duw takwak mugwula jaav kwiykigwura, God ab atampik ab kwiy-kidadiygwurik. Aw li nuwukadiy duw takwak samasama jaav kwiykigwura, God ab atampik ab kwiy-kidadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisas niki waya maaj kitika maaj wadidiy, “Mil kwakinadi duw nikidi mil kwakinadi duwaam maa rav yaab simaka-simakak. Aw li di atawa kwurkida, bir vitiykilib kawaar vakir-kinabir. ");
INSERT INTO mle_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Gaba maja duw kalivadadiy nyanugw aw dayadi gaba maja duw dikim kakil-kakil maa. Aw adiy nyanugw skul kwusikuw, day dayadi gaba maja duw kaytik tikidiy. ");
INSERT INTO mle_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","“Gwur agwa javik nikidi duw diki yidil kwasa valik wagwura, aw gwur gwuradiy nimadiy valik akil wukigwura? Gwur nuwukadiy duw taakw dayadiy kwasadiy valik vikuw, wakigwuradiy, ‘Min kwasa vaal yiminal. Alik wun sugwiyaan kwurik minak.’ Gwuradiy vaal mwiya nimadiy-adiy. Alik gwur atawa wakigwura, gwur viyuw tikala pik pasira-kigwura. Taay gwur bwan akwiy gwuradiy nimadiy valik. Kwiykuw, ginyir ata yin sugwiyaan akwur adi nikidi duw diki kwasa valik. Alik tikuw, gwur gwuradiy nikim nikim wuki-kwagwuradiy mawul alakatiy.” ");
INSERT INTO mle_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Atampik viyakita miy akis kupwarapa mwiy kwurkwanaad. Aw kupwarapa miy viyakita mwiy akis kwurkwanaad. ");
INSERT INTO mle_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","“Duw miy dayadiy mwiyaam vitaay, yabiyib lakwu-kwadadiy, ‘Kidiy miy viyakitadiy, kidiyay miy kupwaraap-adiy,’ waan. Duw akis lap liki mwiy balawiy miyaam kwurkwanadiy. Duw akis radayman dayadiy mwiy kapira bajigayaam kwurkwanadiy. ");
INSERT INTO mle_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Duw miy dayadiy mwiyaam vitaay, lakwu-kwanadiy adiy miy viyakit-adiy, ay kupwaraap-adiy. Atampik, duw nuwukadiy duw taakw dayadiy kwur-danadiy yawiywa majib vikuw, lakwu-kwadanadiy dayadiy mawul viyakit-adiy, ay kupwaraap-adiy. Duw day dayadiy mawulaam rikwanadiy javadiy day dayadiy bwula-kwadanadiy majir wakwu-kwanadiy.” ");
INSERT INTO mle_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Agwa javik tikuw, gwur sikiy-gwuradiwun ‘Yitaypika Duw, Yitaypika Duw,’ waan aw gwur wun wakwatuwadiy majib akis wuki-kwanadiygwurik? ");
INSERT INTO mle_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Wun gwurak simakaaw adi wunak yanadi wuna watuwadiy majib wuki-kwanadi duw dikil mil mwutaam. ");
INSERT INTO mle_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Di adi wiy kwurdi duw kaytik-ad. Adi duw wiy kwurik tikuw, di nimadi kaw vad. Dikidiy paaw kabakim tikuw, ap samasam tad. Aw ginyir nimadi guw warkuw, adi wiyaam giviy yakuw saylik, adi wiy maa vakir. Aw adi duw adi wiy yarakara kwurdid. ");
INSERT INTO mle_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Aw adi duw di wuna maaj wukikuw, a majib wukimarkida, di kwula yawiyim wiy kwurdi duw kaytik-ad. Adi wiy dikidiy paaw apiyim kaw vakuw kwurdik, ginyir nimadi guw warkuw, giviy yakuw adi wiyaam saylik, adi wiy yabiyib ata vakirkuw, miyawa tukwiyakwiyad.” ");
INSERT INTO mle_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas adiy duw takwak maaj wakwusin napakuw, dayaam wapakuw, Kapanam tipaar yad. ");
INSERT INTO mle_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rom jaka tipa kidiy vay sawdiy duw duwamiy tabab dayadi sapakwa nyan dikidi mawul yilidi yawiy duw kiya-kiyab kwaad. ");
INSERT INTO mle_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Adi sapakwa nyan Jisas diki yawiy maaj wukidil. Wukikuw, Juw dayadiy sapakwa nyanugw wayakididiy Jisasak bas sidakikik di yakuw, adi dikidi yawiy duw diki giviyib sipwutiy-dikik. ");
INSERT INTO mle_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Day Jisasak yikuw, yarakara wadaad, “Kidi duw diki mawul nyanadiy jaka tipa kidiy duw takwak yikwana. Di gaba maja wiy nak kwurdid nyanak. Alik tikuw, nyanadiy mawul wanadiy min yikuw, dim sugwiyaan kwurminkik.” ");
INSERT INTO mle_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","8","Jisas daya maaj wukikuw, dayawa ata yad. Jisas adi vay sawdiy duw duwamiy tabab dayadi sapakwa nyan diki wiyawa walibab yataay tidik, di dikidiy kapa nyanugw Jisasak wayakididiy dikik wadakikik, “Nimadi duw, wun viyakita duw maa. Alik tikuw, min wuna wiyaar vara-tikwa. Kilib tan kipa majida wamin wunadi yawiy duw diki giviyib kwusilikik. Wun wunabab sapakwa nyanugw wunaam van tikwanadiy. Daya majib wukikwanadiwun. Aw nuwukadiy duwaam van tikwanadiwun. Vay sawdi duw nikik ‘Maay’ watuwkikib, yikwanaad. Nikidi vay sawdi duwak ‘May’ watuwkikib, yakwanaad. Wunadi yawiy duwak ‘Ki yawiy akwur’ watuwkikib, a yawiy kwurkwada. Minabab God diki majib wukikuw, diki ap kwurnadimin. Min alik kipa majida wamin, wunadi yawiy duw diki giviyib kwusilikik.” ");
INSERT INTO mle_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Adi Rom jaka tipa kidi duw wadil maaj Jisas wukikuw, pitaan warkuw, tipatiyakwukuw, diki kwukib yadiy duw takwak ata wadidiy, “Kidi Roma jaka tipa kidi duw wunak samasam wukijibir tinaad. Yisrayil jaka tipa kidiy duw taakw nak wunak wukijibir kidi duw kaytik tidaak, wun samab maa vi.” ");
INSERT INTO mle_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Adiy maaj karaydiy duw day sibinin wiyaar yikuw, vidaal adi yawiy duw diki giviyib ata miyawa kwusil. ");
INSERT INTO mle_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ginyir kwasa mwiy tikuw, Jisas Nayin wadaal tipaar yad. Dikidiy kalivadidiy duwawa nuwukadiy duw takwawa nakamwiyib yidiy. ");
INSERT INTO mle_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","A tip likidi kabaka yarip takatipawa walibab yidik, di ata vididiy bapa duw taakw kiyadi duw yataan karaydaad kawamiyaam takak. Adi kiyadi duw tawtakw kwaal taakw likidi naka mwiya nyanad. A tipa kidiy duw taakw samasam liwa yidiy. ");
INSERT INTO mle_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yitaypika Duw Jisas atawa vikuw, di likik samasam wukikuw, ata wadil, “Nyin gira-tikwa.” ");
INSERT INTO mle_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jisas atawa wakuw, adi duwaam yataan karaydadi bayir yikuw, kaykitidik, adi duwaam yataan karaydiy duw ata tawtaykuw, tidiy. Tidaak, Jisas adi kiyadi duwak wadid, “Badiy duw, min wuna majib awuk! Min aras!” ");
INSERT INTO mle_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Adi duw ata rasikuw, maaj ata bwulaad. Jisas ata diki amayik sibinin kwiydid. ");
INSERT INTO mle_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ababa duw taakw a jaav vikuw, pitaan warkuw, day ata Godak wayapiy sidaad. Sikuw, day ata wadiy, “God diki maaj wasapwiynadi duw nak, nimadi duw, nyana nyidim tinaad.” Day ki maaj ab wadaal, “Nabiy nabiy God pakwun tad. Aw nibwul di dikidiy duw takwak yanaad dayak sugwiyaan kwurik!” ");
INSERT INTO mle_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ababa Juwtiya tamiyawa nuwukadiy tamiya kidiy duw taakw Jisas atawa kwurdil yawiy maaj wukidaal. ");
INSERT INTO mle_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Jon dikidiy kalivadidiy duw Jisas kwurdidiy yawiy maaj Jonak yarik yidaad. Jon duw vitiy wataydik, yabirik, wayakidibir Yitaypika Duw Jisasak dikik bas sibirkikik, “Min kidi God diki maaj walidi kavin kwabanadi Duw-adimin, ay nikidi duwak kavin kwakidiyan maa?” wakuw. ");
INSERT INTO mle_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Abir duw Jisasak yikuw, ata wabirid, “Jon, baptais kwiynadi duw, wayaki-dabiran minak bas sitakikik. Min adi Duw tayir di duw takwak wasapwiydidiy ginyir yakinaad waan wadid, min-adimin? Ay nikidi duwak kavin kwakidiyan?” ");
INSERT INTO mle_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A nyi Jisas samasama niki giviyib niki giviyib kwurdiy duw taakw dayadiy giviyib sipwutiy-didiy. Adiy mawulaar yidadiy wudib duw taakw sipwutiy-didiy, di adiy mil kwakidiy duw taakw mwugiydikib, mil mwiyir vidadiy. Atawa kwurdidiy. ");
INSERT INTO mle_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","23","Aw Jisas dayak ata wadidiy, “Gwur sibinin maay Jonak. Yikuw, kidiy vikuw, wukigwuradiy jaav dikik aw. Adiy mil kwakidiy duw taakw, adiy maan kupwaraap tidiy duw taakw, adiy lepa tidiy duw taakw, adiy waan tipidiy duw taakw, adiy abab wun sipwutiyaki-tuwadiy. Adiy kiyadiy duw taakw kirapituwik, rasidiy. God diki viyakita maaj saal yinadiy duw takwak wasapwiy-tuwadiy. Li adiy duw taakw mawul vitiy ti maarkuw, wunak wukijibir tikinadiy, adiy rakarak samasam tikinadiy. Bir yin Jonak kidiy yarik yituwadiy jaav dikik aw.” ");
INSERT INTO mle_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon dikidiy kalivadidiy duw Jisasaam wapakuw, yidaak Jonak, Jisas vagaluwdiy duw takwak wadidiy, “Gwur tamiyka tamiyaar yigwuril Jonak vikir, atata duwad waan wadiygwurik? Li di ap ti maardi duw kwasa mwiya mwar viyalik, adiy suw tagwan kwakwadana pik? Atampika duw maa. ");
INSERT INTO mle_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Li gwur yigwuril viyakita wapwiy kwusuw ridi duw vikir yidiygwurik? Aw Jon atampika duw maa. Viyakita wapwiy kwusuw-kwanadiy duw viyakita wiyaam yarakara kwakwanadiy. ");
INSERT INTO mle_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Li gwur yigwuril God diki maaj wasapwiydi duw vikir yidiygwurik? Ayiy. Jon di mwiya God diki maaj wasapwiynadi duw tikwanaad. Di ababa nuwukadiy God diki maaj wasapwiydiy duwaam kakildadiy. ");
INSERT INTO mle_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","“Diki lapa nyigaam God ki maaj dikidi Tasakwudidi Duwak wanaad Jon diki yawiyik: ‘Taay maaj kariyadi duw wayaki-kituwaad. Yin niki jaav niki jaav minak kwulapwu-kinaad.’ ");
INSERT INTO mle_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Wun mwiya maaja gwurak watuwa. Jon di ababa tayir kidi kupwaam kwadiy duwaam yitaypik-ad. Aw kita God dikidi van tinadi tamiyaam yisadapika duw di Jonaam yitaypik tinaad.” ");
INSERT INTO mle_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","30","Ababa duw takwawa takis kwurdiy duwawa day ki maaj wukikuw, tayir baptais kwurkuw Jon diki tabaar, Godak wayapiy sidaad, “Diki maaj mwiyir tina,” wakuw wadiy. Aw adiy Parasiyawa God diki lo kalivadiy duw day kwasik yidiy Jon diki baptais kwurkwurik, God dayak wadil majik bwan kwiykuw. ");
INSERT INTO mle_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Jisas ata wadidiy, “Kidi kupwaam kwanadiy duw taakw kwasadiy nyanugw kitik dayadiy mawul kapakap tikwanadiy. Day nyidi tipaam daan ritaay, nuwukadiy bapa kidiy nyanugw dikidiyik wasakiytaay kwadadiy, ‘Nyan kaagw sitaay baagw tibakikib, aw gwur maa baagw vas. Aw nyan gira-kwadanadiy baagw tibakikib, aw gwur maa gir.’ ");
INSERT INTO mle_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","34","“Jon yakuw, di gwuradiy kikwagwuradiy kikipatawa wain akis kikwanaad. Alik adiy nyanugw kaytik gwur wagwura, ‘Kad wudib mawulaar yidalik, alik kwam yinaad.’ Aw wun, duw taakw dayadi Mwaamad, yakuw, kikipatawa wain kikuw, day wadana, ‘Kidi duwak av! Bwal kaytik kamnaagw kida kida kinaad. Ki kwam tikwadana guw samasam kikwanaad. Di takis kwurkwanadiy duwawa nuwukadiy kupwarapa duw taakw dayadi kapa duw-ad.’ ");
INSERT INTO mle_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Aw adiy duw taakw day God dikidi tasakwudil yabik mayaakw kwakuw, day ata lakwu-kidana adi yaab mwiyir tikwanadi yaab-ad.” ");
INSERT INTO mle_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parasiy nak, dikidi si Sayman, Jisasak akiy kwiytakadil diki wiyaar yakuw, kamnaagw kidikikik diwa. Jisas diki wiyaar yikuw, wulakuw, daan rad kikipaat kikir. ");
INSERT INTO mle_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Vaal samasam yilil taakw a tipaam kwaal. Li ata Jisas adi Parasiy diki wiyaam kamnaagw kidil maaj wukilil. Wukikuw, li ata adi viyakita yaam samasama yay-kwanadi waliy guw kwadidi kaany kwurkuw, yaal Jisasak. ");
INSERT INTO mle_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Li yakuw, Jisas diki kwukim titaay, giraal. Giralidi laagw dakuw, Jisas dikibir manim vakirdik, ata likidi nibir ata vagitilid. Vagitin napakuw, dikibir maan jipwulibir. Jipwun napakuw, adi yaam yaydi waliy guw ata dikibir manim kaykwataka-lid. ");
INSERT INTO mle_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Adi Jisasaam waan kariyadi Parasiy a jaav vikuw, di diki mawulaar ata waad, “Li kidi duw mwiya God diki maaj wasapwiynadi duw tikik-da, di bwunak lakwuk-da ki dim kaykitina taakw liki mawul. Di lakwuk-da ki taakw vaal yiyi tikwana taakw-al,” waan. ");
INSERT INTO mle_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas dikik ata wadid, “Sayman, wun minak kwasa maaj wakir.” Di Jisasak ata wadid, “Kaliva-nadi duw, jaaw, min wunak aw.” ");
INSERT INTO mle_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisas dikik ata wadid, “Duw vitiy bir duw nikim dinau tibir. Duw nak K500 dinau tididiy. Aw nikidi duw K50 dinau tad. ");
INSERT INTO mle_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","“Ginyir abir duw adi duwak dim dinau tibiridiy saan sibinin kwiykwiyik vibiril maa rav birakim. Atawa tikuw, adi duw birabir dinau ak yaakiya wadibir. Aw birakim sikada duwad adi duwak mawul yitaypik yikinaad?” ");
INSERT INTO mle_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sayman Jisasak ata wadid, “Wun wukituwa adi nima dinau kwurdi duwad.” Jisas ata wadid, “Mwiya maajal wamina.” ");
INSERT INTO mle_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jisas a takwak tipatiyakwukuw, Saymanak ata wadid, “Min ki taakw viminal? Wun mina wiyaar varatuwa, min wunak guw maa kwatay wunabir maan jantuwkik nyana sukw wala pik. Aw li wunabir maan likidi mila lugwur jankuw, likidi nibir vagiti-labir. ");
INSERT INTO mle_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","“Aw li min wuna mwutamaam maa jipw. Aw li ki taakw wiyaar varatuwik, li wunabir manim jipwun kwalibir. ");
INSERT INTO mle_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“Aw min wun varatuwik, aliv miy dikidi mwiy guw min wuna abwaam maa tak. AW li viyakita yaam yayna waliy guw wunabir manim takana. ");
INSERT INTO mle_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Alik tikuw, minak watuwadimin, ki taakw liki wunak samasam wukin tikwala mawul simaka-laala likidiy samasama vaal bwu yibwiyin tinadiy. Aw li adi duw kwasa vaal God yibwiykida, adi duw Godak diki mawul kwasa mwiy yikina.” ");
INSERT INTO mle_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jisas a takwak ata wadil, “Nyinadiy vaal bwutaay yibwiyin tinadiy.” ");
INSERT INTO mle_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nuwukadiy Jisasawa jabim daan ridiy duw day dayak ata bwulasakiy-salataay, wadiy, “Kidi duw vaal yibwiy-kwanaad, ay? Kad sikanadaad?” ");
INSERT INTO mle_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aw Jisas a takwak ata wadil, “Nyin wunak wukijibir tinanyin. Alik nyin mwiyir mwiya mwiyab tinanyin God diki mwutamaam. Alik tikuw, nyin yara maay.” ");
INSERT INTO mle_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ginyir Jisas niki tip niki tipaar yibagwutaay, God diki viyakita maaj atata di duw takwaam van tinaad duw takwak wasapwiy-didiy. Dikidiy tabatiy maan vitiya duw diwa yidiy. ");
INSERT INTO mle_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Dayawa nuwukadiy taakw yidiy. Adiy taakw nuwukadiy tayir Jisas dayadiy mawulaar yidadiy wudib kwurin yakididiy, nuwukadiy dayadiy giviyib sipwutiy-didiy. Adiy taakw day dayadiy sanaar kikipatawa niki jaav niki jaav yapiydadiy Jisasawa dikidiy kalivadidiy duwak. Nak Maria, day wadaal Maktalin. Tayir Jisas di wudib abitiy liki mawulaam ridaak, kwurin yakididiy. Nak ab Jawana, likidi laan Suwsa, di Juw dayadi yitaypika duw Yirat dikidiy niki jaav niki javik van tad. Suwsanawa samasama nuwukadiy taakw dayawa yidiy. ");
INSERT INTO mle_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Niki tipa niki tipa kidiy duw taakw Jisasak yakuw, samasama duw taakw vagaluwkuw, Jisas ki waya maaj kitika maaj dayak wadidiy, ");
INSERT INTO mle_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Duw nak kabasik kitika jaav, wit liki kadiy yakik yad diki mayim. Kadiy yakidik, nuwuk yabim vakirdiy. Alim tiytiyaan tidiy duw taakw apiyim vasin tibagwudadiy. Adiy kadiy apiy yabim ridaak, wapiy dakuw, adiy kadiy kidadiy. ");
INSERT INTO mle_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","“Nuwukadiy kadiy kabaka ril kwasa kupw, a kupwaam vakirdiy. A kupw bag maa ti. Alik jayib nak saal warkuw, maj mwiyir maa kway. Kupw ginyir rik yilik, ata kiyadiy. ");
INSERT INTO mle_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Nuwukadiy kadiy ramiy tidiy visawa vakirdiy. Ramiy til visawa nakamwiyib warkuw, yakiwulupwun ridiy. ");
INSERT INTO mle_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“Nuwukadiy viyakita kupwaam vakirkuw, wardiy. Warkuw, day viyakita mwiy kwurdiy. Day mwiy mwiya samasam ridiy.” Jisas ki maaj wakwusin napakuw, ata wadidiy, “Duw waan tinaad, di wukikwaad.” ");
INSERT INTO mle_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas dikidiy kalivadidiy duw dikik yadiy a waya maaj kitika maaj liki maaw wukik. ");
INSERT INTO mle_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisas dayak ata wadidiy, “God tasakwudil gwur lakwu-gwurkik agwa jaav tayib pakwul atatawa di duw takwak van tikidadiy. Aw kipa duw takwak maa. Adiy duw taakw mil vikwanadiy, aw mwiyir akis lakwu-kwanadiy. Alik tikuw, wun dayak waya maaj kitika majir watuwadiy.” ");
INSERT INTO mle_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ki waya maaj kitika maaj liki maaw kitawa wana. Adiy kadiy wit aal God diki maaj-al. ");
INSERT INTO mle_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Adiy duw taakw day God diki maaj wukikuw, aw Satan yakuw, a maaj kwurdil dayadiy mawulaam kwalik. Di kwasik yinaad day God diki majib wukikuw, God dayaam nyigil-nyigilik. Atampika duw taakw day adiy apiyim yabim vakirdiy kadiy wit kaytik-adiy. ");
INSERT INTO mle_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Atampik nuwukadiy duw taakw kabaak apiyim ril kupwaam yakididiy kadiy kitik tinadiy. Day God diki maaj wukikuw, rakarak tinadiy kwurkwurik. AW God diki maaj dayadiy mawulaar mwiyir maa wul. Alik tikuw, day dikik wukijibir tikuw, ginyir nuwukadiy duw taakw dayaam jawjaay kwurdaak, day ata bwan kwiy-kinadiy Godak. ");
INSERT INTO mle_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Nuwukadiy duw taakw ramiy tina visawa vakirdiy kadiy kitik tinadiy. Day God diki maaj wukikuw, aw dayadiy mawulaam rinadiy majik samasam wukikuw, sanawa niki jaav niki jaav kwurik kwanadiy. Adiy jaav yakuw, God diki majib yakiwulupwu-dadiy. Alik day mwiy maa ri. ");
INSERT INTO mle_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Nuwukadiy duw taakw adiy viyakita kupwaam vakirdiy kadiy kitik tinadiy. Atampika duw taakw God diki viyakita maaj dayadiy viyakita mawulaam kwurik. A majib yarakara kaykitin kwakuw, ginyir viyakita mwiy kwurkina.” ");
INSERT INTO mle_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisas duw takwak ata wadidiy, “Gwur lam wapatakakuw, yala vakaam taka-kwagwura? Japakapaam taka-kwagwura? Atawa akis kwur-kwanadiygwurik. Gwur nyidi wiyaam vataka-kwagwura. Aw adiy wiyaar warkidiy duw takwak kariyaan tilik, mwiyir vikidana. ");
INSERT INTO mle_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ababa pakwun rinadiy jaav, ababa rabwutakaan rinadiy jaav, ginyir adiy jaav maykaar wakwukidiy. ");
INSERT INTO mle_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Gwur yarakara wukigwuradiy majik. Duw taakw wuna maaj lakwudana, ginyir miyawa lakwukidiy God dikidiy javik. Aw adiy duw taakw day wuna maaj laakw maardana, ginyir kip tikuw, saal yikidiy. Atampika duw taakw day ‘Wun Godaam bwu lakwutuwaad’ waan, atampika mawul ab ata kwusikina.” ");
INSERT INTO mle_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisas diki amaywa dikidiy nyamwusugw yadiy Jisasaam vikir. Aw dikik yikir kwurdaal, maa rav. A tamiyaam samasama duw taakw vagaluwun ridiy. ");
INSERT INTO mle_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Duw nak Jisasak ata wadid, “Min awuk. Mina amaywa minadiy nyamwusugw kinaakw adiyka kawaam tinadiy. Day minaam vikir wanadiy.” ");
INSERT INTO mle_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisas adiy duw takwak God dikidi gwalugwuk kalivaak tikuw, dayak ata wadidiy, “Adiy duw taakw day God diki maaj wukikuw, a majib wukikidana, adiy duw taakw day wuna amaywa wunadiy nyamwusugw tikinadiy.” ");
INSERT INTO mle_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nyi nak Jisas jabiraar salin dakuw dikidiy kalivadidiy duwawa, di dayak ata wadidiy, “Kilakiy agika maka araar vakiynaak.” Wakuw wadik, day ata wapasakwudiy vakiyik. ");
INSERT INTO mle_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Vakiytaay tidaak, Jisas ata si kwaad. Si kwadik, nimadi mwar ata yaad araar. Yakuw, a jabiraam mam saylik, guw ata wulaal yala jabiraar. Wulalik, a jabir ata tipik kwuril. ");
INSERT INTO mle_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jisas dikidiy kalivadidiy duw dikik yikuw, ata wajawiyadaad. Day dikik ata wadaad, “Yitaypika Duw, Yitaypika Duw, nyan aka kiyapakwu-kinadiyan!” Jisas rasikuw, abir mwurwa mamak apawa wadik, jayib nak kwusibir. A ar ata miyawa kipa guw ral. ");
INSERT INTO mle_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jisas dayak ata wadidiy, “Agwa javik tikuw, gwur wukijibir ti maargwura wunak?” Aw day pitaan warkuw, yagadiy. Day dayak ata awarwa bwulasakiy-salataay, bwuladiy, “Kidi duw ataatanaad? Wada majib nima mamwa mwar abira bwutaay kwusinabir!” ");
INSERT INTO mle_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","A ar kipa guw rilik, day ata Girasin daya tamiyaar vakiydiy. A tamiy Galiliy tipawa agika gikim ral. ");
INSERT INTO mle_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisas kawiykuw, kupwaar salin wardik, a tipa kidi duw nak dikik yaad. Wudib adi duw diki mawulaar yidaad. Di nabiy nabiy wapwiy kwusuwun maa ti. Di diki wiyaam maa kwu. Nyanyi di kawamiya dipwu kabakim kwayad. ");
INSERT INTO mle_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Adi duw Jisasaam vikuw, nimadib gaam sikuw, Jisas diki mwutamawa yagaar yagaar vakirkuw, simakak di Jisasaam yisadapik tidilik, alik ata nimadib Jisasak wadid, “Jisas, min Nimadi God dikidi Nyan-adimin, agwa jaav min wunaam kwurik? Min wunaam kupwaraap kwur-tikwa!” ");
INSERT INTO mle_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jisas adi duw diki mawulaar yidi wudibak wadid adi duwaam wapakuw, wakwudikik. Alik adi wudib atawa Jisasak wadid. Tayir duw adi duw dikidiy manwa taab waliy yavaar jidaad. Aw adi wudib mwugiydikib, di adiy waliy yaav kaytikitaay, tamiyka tamiyaar tabwuyikwaad. ");
INSERT INTO mle_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas dikik ata bas sidid, “Minadi si ataanad?” Wudib mwiya samasam adi duwaam wuladaad. Alik di Jisasak ata wadid, “Wunadi si Samasam-ad.” ");
INSERT INTO mle_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Adiy wudib Jisasak ata wadaad, “Min nyanaam kupwarapa tamiyaar wayaki-yakik.” ");
INSERT INTO mle_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Adi duw mawulaar yidiy wudib day vidadiy adiy bwal agika nibwukim tan vas kidaak. Vikuw, day Jisasak yarakara bas sidaad, “Li min nyanaam wayakik tikuw, kidiy bwalaam wamin, nyan wulayakinaak.” ");
INSERT INTO mle_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jisas “Maay” wadik, day ata adi duwaam wapakuw, adiy bwalaam wulayakidiy. Adiy bwal abab gipakuw, daan nima dipwu wamwunir dadiy. Dakuw, guw kikuw, abab kiyapakwudiy. ");
INSERT INTO mle_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Adiy bwalak van tidiy duw a jaav vikuw, tabwudiy. Tabwukuw, day nimadi tipawa kwasadiy tipaam kwadiy duw takwak a jaav wasapwiy-dadiy. ");
INSERT INTO mle_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Adiy duw taakw ata yadiy a jaav vikir. Day Jisasak yakuw, vidaad adi tayir wudib mawulaar yididi duw. Wapwiy kwusuwkuw, di diki viyakita mawulawa rad Jisas dikibir manwa. Ridik, day vikuw, yagadiy. Day lakwudaal mwiya nimadi apaar Jisas atawa kwurdid. ");
INSERT INTO mle_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A jaav vidiy duw nuwukadiy duw takwak yarik yidadiy Jisas adi wudib yidadi duwaam sipwutiydil maaj. ");
INSERT INTO mle_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ababa Girasin tamiya kidiy duw taakw a jaav wukikuw, day samasam yagakuw, Jisasak yakuw, yarakara wadaad di dayaam wapakuw yidikikik. Wakuw wadaak, Jisas diki jabiraar salin dakuw, dayaam ata wapadidiy. ");
INSERT INTO mle_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Aw di dayaam wapaak tikuw, adi wudib wapadadi duw Jisasak nimadib bas sidid, “Min wamin, wun minawa yaaw.” Aw Jisas dikik ata wadid, “Min mina tipaar yikuw, duw takwak awasapwiy God minaam kwurdil yawiyik.” Adi duw ata miyawa tipaar yitaay, Jisas dikik kwurdil yawiy maaj wadidiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas niki agika maka araar vakiykuw, kawiydik, duw taakw samasam kavin kwadiy dikik wayapiy sikir. ");
INSERT INTO mle_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","A tipa kidiy Juw daya gaba maja wiya sapakwa duw Jayras, yakuw, Jisas dikibir manwa vakirkuw, dikik bas sidid sugwiyaan kwurdikik. Nimadib wadid, “Wuna kwasa takwa nyan, likidiy nabiy tabatiy maan vitiy tinadiy, kiya-kiyab kwana wuna wiyaam. Min wunawa may likim sipwutiy-minkik.” Jisas Jayras diki wiyaar yitaay tidik, duw taakw samasam dim kayway walakwudaad. ");
INSERT INTO mle_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dayawa kwaal taakw nak wany wakwun tiyalidiy nabiy tabatiy maan vitiy. Jaab samasam a taakw dokta ak yilidiy. Aw likidiy saan kwusiyakidiy dayak. Aw liki giviyib maa kwas, nyanyi wany wakwun tiyal. ");
INSERT INTO mle_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A taakw vagaluwdiy duw takwaam tilik, Jisas diki kwukir ata yaal. Yakuw, Jisas dikidi wapwiyim ata tabaar kwasa kwasa yakitaay, wapwalid. Wapwalik, ata yabiyib likim wakwudi wany jibwud. ");
INSERT INTO mle_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisas ata bas sad, “Wunadi wapwiyim sikadadaad wapwanaad?” Aw abab maa wadiy. Pita Jisasak ata wadid, “Yitaypika Duw, samasama duw taakw minawa kaypwusin tinadiy. Agwa javik tikuw atawa bas sinadimin?” ");
INSERT INTO mle_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aw Jisas ata waad, “Nak wunaam wapwanaad. Wun lakwutuwa ap wunaam wapakuw wakwulik.” ");
INSERT INTO mle_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A taakw ata wukilil Jisas bwutaay lakwudil liki kwurlil jaav. Alik tikuw, li Jisasak yakuw, dikibir manwa vakiril gingin nakuw. Alim ababa duw taakw dayadiy mwutamaam walid dikidi wapwiyim kaykitilil maaw majawa aal liki giviyib kwusililwa. ");
INSERT INTO mle_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisas ata wadil, “Wuna nyan, nyin wunak wukijibiran tinanyin. Alik yara tinanyin. Nyin maay! Nyin yara maay! Nyina giviyib aka kwusina.” ");
INSERT INTO mle_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas a takwak wataay tidik, duw nak Jayras diki wiyaam kwakuw, maaj karaydil Jayrasak. Di yakuw, Jayrasak ata wadid, “Mina takwa nyan bwutaay kiyana. Alik tikuw, niki yawiy kaliva-kwanadi duwak yawiy kwiy-tikwa.” ");
INSERT INTO mle_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas ki maaj wukikuw, Jayrasak ata wadid, “Min yaga way! Wunak wukijibir ada! Mina takwa nyan liki giviyib ata kwusikina.” ");
INSERT INTO mle_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisas wiyaar yikuw, di maa waad kipa duw a wiyaar wula-wulak. Aw di yaakiya waad Pita Jamisawa Jon a nyan likibir amaay asaay dayada wuladakik diwa. ");
INSERT INTO mle_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A wiyaam samasama duw taakw girataay, a nyinik wukidiy. Aw Jisas dayak ata wadidiy, “Gwur gira-tikwa. Ki nyan li maa kiy. Li kipa si kitik kwana.” ");
INSERT INTO mle_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Day lakwudaal a nyan bwu kiyaal. Alik tikuw, Jisasak rik kwurtaay, wajidaad dayak wadil maaj wukikuw. ");
INSERT INTO mle_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jisas a nyan kwalil tamiyaar yikuw, liki tabaam kaykitikuw, ata wadil, “Kwasa nyan, nyin aras!” ");
INSERT INTO mle_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Liki mawul sibinin yalik, li ata rasil. Rasilik, Jisas dayak ata wadidiy likik kamnaagw kwiydakik. ");
INSERT INTO mle_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Likibir amaay asaay pitaan warkuw, rakarak tibir. Aw Jisas birakik wadibir, “Ki kwurtuwa yawiy maaj nuwukadiy duw takwak wayi waya wayik.” ");
INSERT INTO mle_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas dikidiy kalivadidiy duw tabatiy maan vitiy, dayak gaam sididiy yadakikik dikik. Yadaak, dayak ap kwiydidiy duw taakw mawulaar yidiy wudib kwurin yakidakik. Di ap dayak kwiydidiy day ababa niki giviyib niki giviyib kwurdadiy duw taakw sipwutiy-dakik. ");
INSERT INTO mle_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kwiykuw, ata wayakididiy God dikidi gwalugwuk wasapwiy-dakik. Wasapwiytaay, adiy duw taakw dayadiy giviyib sipwutiy-dakik. ");
INSERT INTO mle_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Di dayak ata wadidiy “Gwur waliybagwu-kinadiygwur samasama jaav yataway. Kwalamiy, kikipaat, kwasabiy, saan, adiy jaav yataway. Wapwiy nak yaakiya, vitiy kwurway. ");
INSERT INTO mle_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Tipaar wulakuw, wiy nak alim adakw. Niki wiy niki wiyaar yiwayik adiy wiyaam kwakir, adi taay kwagwura asaay duw gwurak pitaan warkuw yaal girak-naad. ");
INSERT INTO mle_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Aw li gwur nuwukadiy tipaar wulagwur, adiy tipa kidiy duw taakw maa wadaak gwurak, a tip awap. Taay gwur manim tikina kupw ayak dayak. Vikuw, day wukikwadiy Godawa gwurak kwurdaal kupwarapa javik.” ");
INSERT INTO mle_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Adiy maaj waan napadik, day dim wapakuw, niki tip niki tipaar yibagwutaay, God diki viyakita maaj wasapwiytaay, giviyib kwurdiy duw taakw sipwutiydadiy. ");
INSERT INTO mle_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Yirat, Galiliy tamiy dayadi yitaypika duw, Jisas kwurdil yawiy maaj wukidil. Nuwukadiy duw taakw wadiy, “Jon, baptais kwiydi duw, tayir bwu kiyaad, aw kita bwutaay rasinaad.” Nuwukadiy wadiy, “Adi tayir God diki maaj wasapwiydi duw, Yilayja, maykaar yanaad.” Aw nuwuk wadiy, “Adiy mwiya tayir kiyadiy God diki maaj wasapwiydiy duw nak sibinin yanaad.” Aw Yirat adiy maaj wukikuw, diki mawul jawjaay tal. ");
INSERT INTO mle_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yirat waad, “Tayir wun Jon diki abw viyalupwatuwil. Aw kidi yawiy kwurnadi duw sikadadaad?” Wakuw, di wukid Jisasaam vikir. ");
INSERT INTO mle_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisas dikidiy wayakididiy duw dikik sibinin yakuw, adiy kwurdadiy yawiy maaj dikik yarik yidaad. Wukikuw, Jisas ata kwurin karakwu-didiy Bitsayta wadaal tipaar day dayada. ");
INSERT INTO mle_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Samasama duw taakw a jaav wukikuw, diki kwukib ata yidiy. Jisas dayaam vikuw, di dayak wayapiy sikuw, wadidiy God duw takwak van tididiy yawiyik. Adiy giviyib tidiy duw taakw di sipwutiydidiy. ");
INSERT INTO mle_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nyi gil pik ridadik, Jisas dikidiy tabatiy maan vitiya duw dikik yakuw, wadaad, “Giraab bwutaay tina. Kal kipa tamiya. Kidiy duw taakw awayak. Yin kikipaat mawiyawa si kwa tamiyak kwakibagwu-kwadiy.” ");
INSERT INTO mle_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Aw Jisas dayak wadidiy, “Gwur gwura dayak kikipaat akwiy.” Day dikik ata wadaad, “Nyanaam bret tabab kamiy vitiyada rinadiy.” Alim duw 5000 vagaluwdiy. Day takwawa nyanugw maa nas. Alik day Jisasak wadaad, “Min nyan kikipaat yapiybakik kidiy ababa duw takwak, ay?” Aw Jisas dayak ata wadidiy, “Adiy duw takwak aw day kupwaam daan rikwadiy tukwiyaar tukwiyaar duwamiy vitiy sap tabatiy duwamiy vitiy sap tabatiy.” ");
INSERT INTO mle_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dikidiy kalivadidiy duw wadil majib wukikuw, adiy duw takwak wadaak, atawa daan ridiy. ");
INSERT INTO mle_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisas adiy bret tababawa vitiya kamiy kwurkuw, adawul tipaar likituwkuw, Godak wayapiy sidid. Wayapiy sikuw, adiy bret awa kamiy kaysukwasukwakuw, kwiydidiy dikidiy kalivadidiy duwak adiy vagaluwdiy duw takwak kwiydakik. ");
INSERT INTO mle_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ababa duw taakw kikipaat kikuw, yaal wapwadiy. Jisas dikidiy kalivadidiy duw kipasa-dadiy kipaat vagakuw, baniy tabatiy maan vitiy vagadaak, kapwudiy. ");
INSERT INTO mle_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nyi nak Jisas kap kwaan Godak maaj wadik, dikidiy kalivadidiy duw dikik yadaak, di dayak ata bas sididiy, “Duw taakw nikim nikim wataay, agwa sad wunak sikiy-kwadanaad?” ");
INSERT INTO mle_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Day dikik ata wadaad, “Nuwuk wadiy min Jon baptais kwiydi duw-adimin. Aw nuwuk wadiy min Yilayja-dimin, aw nuwuk wadiy min God diki maaj wasapwiydi duw nak tayir kiyakuw, kita bwutaay rasinadimin.” ");
INSERT INTO mle_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jisas dayak ata bas sididiy, “Gwur gwura agwa sad wunak sikiy-kwagwuraad?” Pita dikik ata wadid, “Min Krais-adimin, God dikidi Tasakwudidi Duw-adimin.” ");
INSERT INTO mle_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Aw di dayak nimadib wadidiy, “Gwur nuwukadiy duwak watikwa ki javik.” ");
INSERT INTO mle_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Atawa wakuw, di dayak maa ata wadidiy, “Wun, duw taakw dayadi Mwaam, wuna sip kagil samasam yikina. Sapakwa nyanugw, sapakwa nyanugw pris God diki lo kalivanadiy duwawa, abab bwan kwiykidiy wunak. Wunaam viyasipadaak, kiya-kinadiwun. Kiyakuw, nyi mugwula yawaam God ata wunaam kirasitaka-kidadiwun.” ");
INSERT INTO mle_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","24","Jisas day ababak ata wadidiy, “Aw li duw taakw wuna kwukib yakir, day dayadiy sipa danik maa wakuw, aw nuwukadiy duw taakw dayak sapis jikin kwurkidanadiy, aw samasama kagil daya sipaar yikina, nuwukadiy kupwarapa jaav ab. Aw adiy jaav nyanyi kwurkuw, wunak wukijibir tikuw, wuna danik wakuw kiyakinadiy, day yara kwakinadiy nyanyi nyanyi. Aw li adiy duw taakw day wunak wukijibir ti maarkuw day daya danik wukikuw kiyakinadiy, adiy kupwaraap tikinadiy nyanyi nyanyi. ");
INSERT INTO mle_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Li duw nak kupwaam rinadiy ababa jaav kwurkinaad, di kiyadik, adiy jaav ata ata sugwiyaan kwurkidiy dikik? Agwa jaav yapiykuw, kwiykida di kiya marimarik? Di maa rav. ");
INSERT INTO mle_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Aw li duw nak maa waan wap saykida wunawa wuna majik, ginyir duw taakw dayadi Mwaam yakuw dakida mwiya nimadi apawa, dikidi asaay dikidi mwiya nimadi apawa, God diki maaj kardadiy viyakita duw day daya mwiya nimadi apawa, di awarabab wakinaad adi duwak. ");
INSERT INTO mle_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Wun mwiya maaj watuwadiygwurik. Nuwuk kilim kwanadiy duw taakw kiya maarkuw, kip kwakuw, God duw takwak van tikidi nyi vikidana. Aw ginyir ata kiyakidiy.” ");
INSERT INTO mle_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ki maaj waan napakuw, Sande nak kaam yilik, Jisas di Pita Jonawa Jamis kwurkuw, dikiwa karaydidiy nibwukir. Di Godak maaj bwulak. ");
INSERT INTO mle_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Di Godak maaj bwulataay tidik, diki mwutaam miyawa patiyakwukuw, diki wapwiy mwiya wamakawam tal. ");
INSERT INTO mle_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mawsisawa Yilayja adawul tipaam kwakuw ata maykaar wakwubir. Bir God diki maaj wasapwiybir duwabir mwiya tayir. Bir Jisasawa maaj bwulaan tibir. ");
INSERT INTO mle_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bir kariyaan tibir God dikidi nimadi apawa. Bir Jisasawa maaj bwulabir diki Jiruwsalimaam yin kiyakida yawiyik God wadil pik. ");
INSERT INTO mle_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aw Pitawa nikibir duw day si kwadiy. Aw li day jawiyakuw, vidaal Jisas dikidi kariyaan tididi apawa diwa tibir duw. ");
INSERT INTO mle_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Vikuw, Pita Jisasak ata wadid, “Yitaypika Duw, aal viyakita nyan kilim kwabana. Basadika wiy kwurnaak, nak minak, nak Mawsisak, nak Yilayjaak.” Pita pitaan warid, aw di maa laakw agwa maaj wawak. Alik atawa waad. ");
INSERT INTO mle_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Di atawa wataay tidik, baw tubw nak apiyir yakuw, day kwadal tamiy miyawa takatipilik, day ata samasam yagadiy. ");
INSERT INTO mle_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","God diki majadika tubwaam wukidaad, “Kad wunadi tasakwutuwadi Nyan-ad. Diki maaj awuk!” ");
INSERT INTO mle_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A maaj kwusilik, day ata vidaad Jisas di dikida kap tidik. Aw day kipa duw takwak maa yarik yi aal vidaal javik a nyaam. ");
INSERT INTO mle_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sirapik tilik, day nibwukim tikuw, dadaak, samasama duw taakw Jisasak yadiy. ");
INSERT INTO mle_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Vagaluwdiy duw takwaam duw nak Jisasak ata wataydid, “Kalivakwanadi Duw, wun minak bas sikir min wunadi nyinik wukiminkik. Wunadi nyinir nakadi mwiyad. Wudib dim viyadik, nimadib gaam sikuw, as yitaay, kwudiyugw dayir wakwul. Adi wudib kwasik yikwanaad dim wapa wapaak. Atawa kwurdakib, wunadi nyinim jawjaay kwurkwadaad. ");
INSERT INTO mle_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","“Wun minadiy kalivaminadiy duwak bas situwadiy day adi wudib kwurin yakidakik. Aw day maa rav.” ");
INSERT INTO mle_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisas a maaj wukikuw, vagaluwdiy duw takwak ata wadidiy, “Gwur bapa duw taakw wukijibir maa ti. Simiy kas nyi gwurawa kwakituwadiy? Simiy kas nyi wuna mawul yayidakina gwurak gwur Godak wukijibir ti maarkuw?” Jisas adi duwak ata wadid, “Minadi nyan wunak akaray!” ");
INSERT INTO mle_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Adi duw dikidi nyan Jisasak karaydik, adi wudib adi nyinim viyadik, kupwaam vakirkuw, adi nyan ata timilbagwud. Aw Jisas adi wudibak wadid, “Min agwutak!” Wakuw, adi nyan sipwutiyin napakuw, Jisas ata dikidi asayik sibinin kwiydid. ");
INSERT INTO mle_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Ababa duw taakw a jaav vikuw, pitaan wardiy God dikidi nimadi apak. Ababa duw taakw pitataay wardaak Jisas dikidiy yawiyik, di dikidiy kalivadidiy duwak ata wadidiy, “Ki gwurak wakituwa maaj wukimar-wayik. God yaakiya wadik, duw nak duw taakw dayadi Mwaam dikidiy mama nib dayadiy tabaam takakidaad.” ");
INSERT INTO mle_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","God a maaj liki maaw yipakwudil dayak day lakwu maardakik. Alik day maa laakw a maaj liki maaw. Aw day yagadiy Jisasak bas sisak a maaj liki mawuk. ");
INSERT INTO mle_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisas dikidiy kalivadidiy duw awarwa maaj warjuwdiy dayaam sikadaad yitaypik tad. ");
INSERT INTO mle_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Jisas daya mawul bwutaay lakwudil. Alik di kwasadi nyan nak kariyakuw, diki malawa vatakadik, tidik, dayak ata wadidiy, “Sikadadaad sugwiyaan kwurkinaad kitampika nyinik wuna danik wakuw, adi duw sugwiyaan kwurkinaad wunak kwurdil pik. Sikadadaad wunak sugwiyaan kwurkinaad, adi duw wunaam wayakidi Godak sugwiyaan kwurdil pik kwurkinaad. Adi duw di yaakiya wakida yisadapika duw kitika yawiy kwurik gwura nyidim, adi duw yitaypik God diki milaam tinaad.” ");
INSERT INTO mle_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon Jisasak ata wadid, “Yitaypika Duw, nyan duw nak vibaad. Di mawulaar yidiy wudib yakididiy minadi saam. Adi duw nyanawa maa kwu. Alik nyan watipibanaad.” ");
INSERT INTO mle_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aw Jisas Jonak ata wadid, “Adi duw watipi-tikwa. Sikadadaad gwurak maa wu maarkinaad, ad gwuradi kapa duw-ad.” ");
INSERT INTO mle_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","God Jisasaam adawur tipaar kawarik tida nyi walibab tilik, Jisas diki mawul waal di Jiruwsalimaar yikir. Alik di Galiliy tamiy wapadil. ");
INSERT INTO mle_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Galiliy tamiy wapakuw, Samariya tamiya kidiy duw daya tip nak alir Jisas duw wayakididiy day alim wiy kwulapwudakik dikik. ");
INSERT INTO mle_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jisas Jiruwsalimaar yikir tidalik, alik tikuw, Samariya tamiya kidiy duw taakw maa wakuw Jiruwsalim tipawa Yisrayil jaka tipa kidiy duw takwak, aw a tipa kidiy duw taakw maa wadiy dikik. ");
INSERT INTO mle_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aw Jisas dikibir kalivadibir duw Jamisawa Jon a jaav vikuw, ata wabirid, “Yitaypika Duw, min an watik yiy tubwaar dakuw, ki tipa kidiy duw taakw miyawa yiy yanyaki-kwadiy?” ");
INSERT INTO mle_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Aw Jisas tipatiyakwukuw, maa waad biraki majik. ");
INSERT INTO mle_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aw day niki tipaar ata yidiy. ");
INSERT INTO mle_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Daya tip wapakuw, nyidi yabir yitaay tidaak, duw nak Jisasak ata wadid, “Wun mina kwukib yikir yikiminadiy tamiyaar.” ");
INSERT INTO mle_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aw Jisas adi duw diki mawul kwurkitaan vikir, dikik ata wadid, “Sapiy as kawaam si kwanadiy. Wapiy kwaat sitaay, si kwanadiy. Aw wun, duw taakw dayadi Mwaam, wun si kwa tamiy maa ti.” ");
INSERT INTO mle_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisas nikidi duwak ata wadid, “Min wuna kwukib may.” Aw adi duw dikik ata wadid, “Yitaypika Duw, wunadi asaay kiya-kiyak kwanaad. Alik wun kavin kwakir dikim kawamiyaam takak.” ");
INSERT INTO mle_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisas ata wadid, “Wuna kwukib ti maarnadiy duw day kiyanadiy duw taakw kawamiyaam takakwadiy. Aw min yin duw takwak awasapwiy God dikidi duw takwak van tidi yawiyik.” ");
INSERT INTO mle_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nikidi duw Jisasak ata wadid, “Wun mina kwukib yikidiwun. Aw taay wun wuna tipaar yaaw. Wun wuna wiyaam kwanadiy duw takwak ‘Yara adakw!’ waan waaw.” ");
INSERT INTO mle_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisas dikik ata wadid, “Viyakita yawiy kwurkwanadiy duw akis viyapaypukwun vikwanadiy. Adiy viyapaypukwun vikwanadiy duw day God dikidi gwalugwuk yawiy kwurkwur maa rav.” ");
INSERT INTO mle_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ginyir Yitaypika Duw Jisas nuwukadiy duw duwamiy mugwul sap tabatiy maan vitiy (72) tasakwukuw, wayakididiy day vitiy vitiy taay yidakikik adiy di yikir tididiy tipaar. ");
INSERT INTO mle_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Di dayak ata wadidiy, “Mayim rinadiy kamnaagw samasam lawnadiy. Aw adiy kamnaagw kwur duw aywa maa. Adiy lawnadiy kamnaagw duw taakw kaytik tinadiy. Aw adiy kamnaagw kwur duw day God dikidiy yawiy duw kaytik-adiy. Gwur alik adi maay asaay duw, Godak, bas as di samasama yawiy duw wayakidikik adiy kamnaagw kwurdakik gwurawa. ");
INSERT INTO mle_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Kita aka wayakituwik, yikidiygwur ki yawiyik. Adiy sapiy as badiy sipsip aam jawjaay kwurkwadanadiy. Atampik gwuraam adiy yikigwuradiy tipaam adiy yikigwuradiy tipa kidiy duw gwuraam jawjaay kwurkidanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Saan, kwasabiywa waliy maan karay-tikwa. Nyidi yabim tawtaay tayaan, duw takwawa tiwayik dayak wayapiy sikir. ");
INSERT INTO mle_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Wiyaar wulakuw, a wiyaam duw takwak, ‘Gwur yara adakw’ aw. ");
INSERT INTO mle_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","“Li a wiyaam kwanadi duw di yara kwanadi duw tikida, yaakiya, mina dikik wayapiy sikigwura maaj mwiya mwiyab tikina dikim. Aw li atampika duw a wiyaam kwu maarkida, gwura dikik wayapiy sikigwura maaj mwiyir ti maa dikim. ");
INSERT INTO mle_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Gwur wiy nakamwiyaam adakw. Niki wiy niki wiyaar yitikwa. Kwakuw, kwiykidanadiy kikipatawa guw ak. Adiy jaav kwurkigwuradiy gwura yawiyik. ");
INSERT INTO mle_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Gwur tipaar wulagwur, a tipa kidiy duw taakw gwurak rakarak tikuw, gwurak kwiykidanadiy kipaat jaaw kip ak. ");
INSERT INTO mle_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","“Gwur a tipa kidiy giviyib kwurnadiy duw taakw dayadiy giviyib asipwutiy. Gwur dayak aw, ‘Kita God bas duw takwak kapaba yabir van tikwanaad. Aw kidi God van tidadi yaab gwurawa walibab tinaad.’ ");
INSERT INTO mle_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","“Aw li gwur tipaar wulagwur, a tipa kidiy duw taakw day maa wadaak gwurak, gwur a tipa yabir yikuw, dayak aw, ‘Nyan maa wabana gwurak. Alik gwura tipa kupw nyanadiy manim tidanalik, alik gwurak viyawarakitaya-banadiy gwur lakwugwurakik God maa wanaad gwurak. Aw gwur ki javik alaakw. God dikidi gwalugw bwutaay gwurawa walibab tinaad, aw gwur kwasik yinadiygwur wula-wulak.’ ");
INSERT INTO mle_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ginyir God dikidi nimadi kot rikidi nyi di Satam tipa kidiy duw takwak maa wakidadiy. Aw adiy gwurak maa wakidiy duw takwak di mwiya maa wayakiyaki-kidadiy.” ");
INSERT INTO mle_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jisas niki maaj ata wadidiy, “Ginyir mwiya kupwaraap tikidiy gwurak Sarasinawa Bitsayta abir tipaam kwanadiy duw takwak. Li wun abir haiten tip, Tayawa Saytan, adiy gwurak kwurtuwadiy yawiy pik dayak kwurik-tuwa, day bwunak dayadiy valik wukikuw, daan rikuw, jaba wapwiy kwusuwkuw, kupw dayadiy sipaam yikuw, bwunak bwan dayadiy valik kwiyik-danadiy. ");
INSERT INTO mle_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Ginyir God dikidi nimadi kot im rikidi nyi adiy Tayawa Saytan abir tipaam kwanadiy duw takwaam God kupwaraap kwurkidadiy. Aw gwuraam mwiya yitaypik kupwarapa jaav kwur-kidadiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Aw gwur Kapanam tipaam kwanadiy duw taakw, gwur wakwanadiygwurik, ‘Nyan adawur tipaar warkidiyan,’ aw gwur war maa. God mwugiydik, gwur kupwarapa tipaar dakidiygwurik!” ");
INSERT INTO mle_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Li duw gwura maaj wukikida, di wuna maaj wukidil pik wukikinaad. Aw li duw maa wakida gwurak, adi duw maa wadil pik wakinaad wunak. Aw li di maa wakida wunak, di maa wakinaad wunaam wayakida Godak.” ");
INSERT INTO mle_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ginyir adiy duw duwamiy mugwul sap tabatiy maan vitiy (72) sibinin yakuw, Jisasak ata yarik yidaad, “Yitaypika Duw, adiy kupwarapa wudib nyan dayak minadi saam wabaak, day nyanadiy majib wukikuw, duw takwaam ata wapadadiy!” ");
INSERT INTO mle_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisas dayak ata wadidiy, “Gwur atawa kwurgwur, wun Satan vituwid aluwurim tikuw, wulik kaytik vakirdik. ");
INSERT INTO mle_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“Gwur awuk. Wun ap bwutaay gwurak kwatiyatuwa. Alik tikuw, gwur jaaw kabaywa takit dayadiy apiyim vasikigwura, day gwuraam jawjaay kwurkwur rav maa. Gwur Satan diki miyawa apaam vasisada-kigwuraala. Atawa tikuw, jaav nakab gwuraam kakil-kakil rav maa. ");
INSERT INTO mle_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Gwur kip rakarak ti-tikwa adiy wudib gwuradiy majib wukidanalik, aw gwur kip rakarak ada gwuradiy si God tasakwudidiy dikidi gwalugwum tidakikik.” ");
INSERT INTO mle_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A nyi God dikidi Mawul mwugiydik, Jisas mwiya rakarak tad. Tikuw, Godak ata wadid, “Asaay, min adawul tipa kidiywa kidi kupwa kidiy duw takwawa miyawa jaav dayadi Yitaypika Duw tikwanadimin. Wun minak rakarak tinadiwun wunadiy duw takwak kalivatuwadiy jaav dayadiy maaw maaj samasam lakwunadiy duwak yipakwu-minalik. Aw dayadiy maaw adiy minadiy majik kip mayaakw kwakwanadiy kwasadiy nyanugw kaytik tinadiy duw takwak simaka-minalik. Ayiy, Asaay, a jaav min mina mawulaam rilik, kwurmina.” ");
INSERT INTO mle_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jisas Godak waan napakuw, vagaluwdiy duw takwak ata wadidiy, “Wunadi Asaay diki mawulaam rinadiy jaav bwutaay abab wuna tabaam takadidiy. Duw nakab wun God dikidi Nyinim maa laakw. Aw wunadi Asaay di kap lakwudadiwun. Duw nakab wunadi Asayim maa laakw. Wun wunada, dikidi Nyan, dikim lakwutuwaad. Aw day adiy wun dayak adiy jaav simakatuwadiy, dayabab wunadi Asayim lakwudanaad.” ");
INSERT INTO mle_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Jisas dikidiy kalivadidiy duwak tipatiyakwukuw, day dayak kap wadidiy, “Wun gwurak watuwa God diki maaj wasapwiydiy duwawa yitaypika duwawa day vigwuradiy jaav vikir kwurdadiy, aw day maa vi. Day wukigwuradiy maaj wukik kwurdadiy, aw day maa wak. Day kip kiyadiy. God yarakara gwurak kwurdalik, alik kidiy jaav vigwuradiy.” ");
INSERT INTO mle_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","God diki lo kalivadi duw nak Jisasak ata yaad. Di Jisasaam vasibariyik kwurik. Alik tikuw, di Jisasak ata bas sidid, “Kalivakwanadi duw, agwa jaav wun kwurkuw, nyanyi nyanyi Godawa yara kwakidiwun?” ");
INSERT INTO mle_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisas dikik ata wadid, “Ata ata God diki maaj wana? Min likim vikuw, agwa maaw majal lakwumina?” ");
INSERT INTO mle_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Adi duw Jisasak ata wadid, “‘Gwuradiy maan taab, ap bwan, mawul miyawa Yitaypika Duw gwuradi Godak yikwadiy.’ Aw niki maaj wana, ‘Gwur gwurak wukikwanadiygwur, atawa gwuradiy kapa duw takwak ab awuk.’” ");
INSERT INTO mle_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas dikik ata wadid, “Mina maaj mwiya maaja. Min atawa kwurkimina, min yara kwakidimin nyanyi nyanyi.” ");
INSERT INTO mle_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Di adi duw alim vagaluwdiy duw taakw day dikik viyakita mawul tidakikik, alik Jisasak bas sikuw, wadid, “Wunawa walibab tinadi duw, sikadadaad?” ");
INSERT INTO mle_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas ki maaj dikik ata wadil, “Juw nak Jiruwsalim wapakuw, Jirikawaar dadik, luwkuw kwurkwadiy duw dim viyakuw, day dikidiy ababa jaav luwkuw kwurkuw, day ata wapadaad, kiyakiyab ridik. ");
INSERT INTO mle_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“A nyaam pris nak adi yabir tiytiyaan tad. Tikuw, adi duwaam vikuw, di kip agika maka yabir yad. ");
INSERT INTO mle_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Kwasa mwiy tikuw, nikidi God dikidi wiyaam yawiy kwurdi duw, Liyvay gwalugwa duw nak adi yabirab yaad. Dibab adi duwaam vikuw, di kip agika maka yabir yilib yad. ");
INSERT INTO mle_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Aw adiy Juw maa wadadiy Samariya tamiya kidi duw nak adi yabir ata tiytiyaan tad. Di adi duwaam vikuw, diki mawul samasam wukil adi duwak. ");
INSERT INTO mle_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","“Wukikuw, adi duwak yikuw, di gwaarwa wain guw dikidiy viyadadiy papim takadidiy. Takakuw, banis ata jididiy. Jikuw, di adi duw di dikidi donki bwunim takakuw, karaydid yapiytaay si kwakwadanadi wiyaar. Adi wiyaar wulakuw, di adi duwaam van kwadid. ");
INSERT INTO mle_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Sirapik nuwukadiy saan kwurkuw, adi wiyaam van tidi duwak kwiykuw, ata wadid, ‘Min kidi duwaam van ada. Aw li kidiy saan rav maardaak mina yawiyik, aw wun sibinin yakuw, nuwukadiy saan minak kwatiya-kituwadiy.’” ");
INSERT INTO mle_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas adi God diki lo kalivadi duwak ata wadid, “Min wukimina ata ata, adiy duw mugwul sikadadaad di kapa duw yawiy pik kwurid adi luwkuw kwurkwanadiy duw viyadadi duwak?” ");
INSERT INTO mle_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Di Jisasak ata wadid, “Adi dikik wukidi duwad.” Jisas ata wadid, “Min yin atampik akwur!” ");
INSERT INTO mle_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas dikidiy kalivadidiy duwawa yitaay tidaak, day tip nikir wuladiy. A tipaam taakw nak, Mata, li wayapiy silid likidi wiyaar wula-dikik dayawa kamnaagw kidikikik. ");
INSERT INTO mle_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jisas liki wiyaar wulakuw, Mata liki jikwaar Maria, li Jisas dikibir manwa daan ral dikidiy maaj wukik. ");
INSERT INTO mle_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Aw Mata samasama yawiy kwuril. Alik li kwasik yal Mariak. Kwasik yikuw, Jisasak yikuw, ata walid, “Yitaypika Duw, min maa wak wuna jikwaar wunaam wapalik, kidiy yawiy kap kwurtuwalik? Wamin, li yakuw, wunak sugwiyaan kwurkwa!” ");
INSERT INTO mle_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","42","Yitaypika Duw Jisas likik ata wadil, “Mata, Mata, yin samasama javik wukikwananyin. Jaav nak rivina. Maria li ki viyakita jaav tasakwula. Alik tikuw, wun likim watip maa. Li wuna maaj wukikwa.” ");
INSERT INTO mle_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nyi nak Jisas tip nikim tikuw, Godak maaj bwulaad. Bwulaan napadik, dikidiy kalivadidiy duw nak dikik yakuw, wadid, “Yitaypika Duw, nyanak kalivaminakik Godak maaj bwula-bwulak God diki maaj wasapwiydi duw, Jon, dikidiy kalivadidiy duwak kalivadil pik.” ");
INSERT INTO mle_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","4","Jisas ata dikidiy kalivadidiy duwak ata wadidiy, “Gwur kitawa Godak maaj aw: ‘Asaay, nyanadiy mawul wakwanadiy duw taakw minadi saam yakisuw-dakik. Min yakuw, ababa duw takwak van ada. Ababa nyi kikibanadiy kikipaat nyanak akwutay. Adiy nuwukadiy duw taakw nyanaam yidadiy vaal bwutaay yibwiy-kwabana pik atampik minabab nyanadiy minaam yibanadiy vaal ayibwiy. Min nyanawa walibab yarip tuwun ada vaal nyanaam kakilik-ladiyan.’” ");
INSERT INTO mle_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Aw li gwuraam duw nak dikidi kapa duwak yikuw nyidi gaan, dikik wakida, ‘Wunadi kapa duw nak yabisaay wayab wunak yanaad. Aw wunaam kamnaagw maa ri dikik kwiykwiyik. Alik tikuw, wunak bret mugwul basadika akwutay.’ ");
INSERT INTO mle_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Aw li dikidi kapa duw yala wiyaam kwakuw, dikik wasakwukuw wadik, ‘Min wunak wa-tikwa. Wiyig bwutaay takatipituwaad. Aw wun wunadiy nyanugwawa si kwanadiwun. Wun ras maa minak jaav kwatiyak.’ ");
INSERT INTO mle_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Aw wun gwurak watuwa adi duw dikidi kapa duw ab tikuw ras maa dikik, aw li di dikidi kapa duw dikidi wiyigaam viyada viyadik, adi duw si kwakir tikuw, di rasikuw, kwurik wadidiy jaav abab kwiykidadiy dikik. ");
INSERT INTO mle_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Wun gwurak watuwa aw li gwurak God jaav kwiydikik wakuw, bas sida bas sida as dikik. Aw li gwur jaav nak sitakirik kwakiyin kwakiyaan tikuw, a jaav ata sitakira-kigwura. Duw wiyigaam viyakwada pik, gwur atampik Godak bas sida sida as. Bas sikuw, God wiyig sakwutaka-kidaad gwurak. ");
INSERT INTO mle_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","“Adiy ababa duw taakw day Godak bas sikidiy, bas sikidanadiy jaav adiy kwurkidanadiy. Adiy duw taakw kwaki-kidanadiy jaav adiy sitakira-kidanadiy. Adiy duw taakw viyakidanadiy wiyig God sakwutaka-kidadiy dayak. ");
INSERT INTO mle_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Gwur asaay, gwuradiy duwa nyanugw kamiy kikir bas sidaak gwurak, aw dayak kabaay kwiykigwuradiy, ay? ");
INSERT INTO mle_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","“Aw li day gwurak bwad kikir bas sidaak gwurak, gwur dayak takit kwiykigwuradiy, ay? ");
INSERT INTO mle_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","“Gwur vaal yikwanadiy duw gwuradiy nyanugwak wukikuw, viyakita jaav dayak kwiykwagwuradiy. Aw adawul tipaam kwanadi Asaay dikidiy nyanugwak mwiya samasam wuki-kwanaad gwur gwuradiy nyanugwak wuki-kwagwuradiy mawulaam kakilkuw. Aw di dikidi Mawul adiy dikik bas sikidiy duw takwak kwiykidaad.” ");
INSERT INTO mle_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Duw wudib diki mawulaar yidik, di maaj akis bwulayikwaad. Jisas adi wudib kwurin yakidik, adi duw ata maaj bwulaad. Ababa vagaluwdiy duw taakw a jaav vikuw, ata pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aw nuwukadiy duw wadiy, “Kidi duw adi yitaypika wudib, Biyilsipap, dikik ap kwiydik, di nuwukadiy mawulaam rinadiy wudib alik kwurin yakididiy.” ");
INSERT INTO mle_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aw nuwukadiy duw Jisasaam vasibariyik kwurik, bas sidaad di nimadi yawiy dayak simaka-dikik day ata lakwuk God yaakiya waad dikik. ");
INSERT INTO mle_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jisas dayadiy mawulaam wadadiy maaj wukikuw, wadidiy, “Li gavman nak niki baap niki bapaar kapakap kajikuw, day dayada wariya-kidana, adi gavman vakirkinaad. Li gwalugw nak niki baap niki bapaar kapakap kajikuw, day dayada wariyakidana, adi gwalugw ata vakirkinaad. ");
INSERT INTO mle_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“Aw gwur wagwura Satan dikidiy wudib duw mawulaam ridaak, diki apaar wun kwurin yaki-tuwadiy. Atawa li Satan dikidi gwalugw niki baap niki bapaar kapakap kajikuw, day dayada wariyakidana, Satan dikidi gwalugw ata vakirkinaad. ");
INSERT INTO mle_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Gwur wagwura adi yitaypika wudib, Biyilsipap, wunak ap kwiydik, wun adiy mawulaam rinadiy wudib kwurin yakituwadiy. Aw gwura bapa duw dayabab mawulaam rinadiy wudib kwurin yaki-kwanadiy. Sikadadaad ap dayak kwiynaad a yawiy kwurdakik? Day wakidiy gwura maaj suwala maaj-al. ");
INSERT INTO mle_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“Gwura maaj mwiya maaj maa. God ap wunak kwiydik, wun adiy mawulaam rinadiy wudib kwurin yakituwadiy. Alik tikuw, God dikidi duw takwaam van tikidi nyi gwura nyidim bwutaay tina wun Satanaam kakil-tuwalik tikuw. ");
INSERT INTO mle_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ap samasam tikwanadiy duw diki wiyak van tikida wariya javiwa, adiy dikidiy niki jaav niki jaav yara rikidiy. ");
INSERT INTO mle_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","“Aw li nikidi ap mwiya samasam tikwanadi duw yakuw, adi nikidi duwaam viyakuw, dim kakilkuw, dikidiy wariya jaav kwurkuw, dikidiy niki jaav niki jaav karaykuw, dikidiy kapa duwak am sikidadiy. ");
INSERT INTO mle_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Adiy duw day wunawa yawiy kwar maarkinadiy, day wunadiy mama duw tikinadiy. Wun duw taakw vagaruwtaka-tuwadiy wunadiy gwalugwa duw taakw tdakikik. Aw wunadiy mama duw yakuw, viyayakidaak, adiy duw taakw kapakap kapakap tabwu-kinadiy.” ");
INSERT INTO mle_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","26","Jisas ki maaj dayak wadidiy, “Li kupwarapa wudib duwaam wapakuw, di yin yaan kipa tamiyam kwakwa tamiyak vikir. Tamiy vi maarkuw, di ata wakinaad, ‘Wun sibinin yikinadiwun wun tayir kwakuw yatuwil tamiyaar.’ Wakuw yidik, di vikinaad a tamiy vayakwum nakuw, maliykamaliy rilik. Alik adi wudib sibinin yikuw, nuwukadiy kupwarapa wudib abitiy kwurin karaykidadiy a tamiyaar. Adiy nuwukadiy wudib dayadiy ap duw takwaam jawjaay kwurkwurik mwiya yitaypik adi taay wudibak tinadiy. Tayir kidi duw kupwaraap tad. Aw kita abitiya wudib yadaak, mwiya kupwaraap tiyakiyaki-kinaad.” ");
INSERT INTO mle_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas ki maaj wataay tidik, taakw nak adiy vagaluwdiy duw takwaam tikuw, Jisasak ata wasakwulid, “Minaam sapwiykuw, mwuny minak kwur taakw, a taakw li rakarak tikwaal!” ");
INSERT INTO mle_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aw Jisas ata wadidiy, “Aw adiy God diki maaj wukikuw, a majib lakwu lakwu tikwanadiy duw taakw, adiy duw taakw mwiya rakarak samasam tikwadiy!” ");
INSERT INTO mle_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Duw taakw samasam Jisasawa vagaluwdaak, di dayak ata wadidiy, “Kita kwanadiy duw taakw day mwiya kupwaraap-adiy. Wunak bas sigwura wunadi yawiy gwurak wun simak maa. Jaav nak gwurak simakakituwa. God dik maaj wasapwiydi duw, Jawna, tayir kwurdil java pik kwurkituwa. ");
INSERT INTO mle_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","“Mwiya tayir God dikidi ap Niniva tipa kidiy duw takwak simakadid Jawnaar. Di kiyadil pik adi nimadi kamiy yalaam nyi mugwul rikuw, ata maa wakwud. Atampik God dikidi ap simaka-kidaad kita kwanadiy duw takwak dayadi Mwamir. ");
INSERT INTO mle_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Ginyir God dikidi nimadi kot im Sipa jaka tipa kidil kwin Godak wakina gwurak, ‘Wun mwiya sika tamiyaam kwakuw, yalwun Salaman wadidiy viyakita maaj wukik.’ Aw wun, ki maaj gwurak wasapwiynadi duw, Salamanaam yitaypik tinadiwun. Aw gwur God diki maaj wukiwukik kwasik yidiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Ginyir God dikidi kot im Niniva tipa kidiy duw taakw ab Godak wakidiy gwurak, ‘Nyan Jawna wadil maaj wukikuw, bwan kwiydiyan nyanadiy valik.’ Aw wun, ki maaj gwurak wasapwiynadi duw, Jawnaam yitaypik tinadiwun. Aw gwur God diki maaj wukiwukik kwasik yinadiygwurik!” ");
INSERT INTO mle_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Duw taakw lam wapatakataay, yala vakaam ay japakapaam akis vatakakwanadiy. Aw day maliykaam vataka-kwadana, miyawa wiyak kariyalikik a wiyaar wula-kidiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Aw li gwur niki niki javim viyakita milaar van tikigwura, aal gwuradiy mawul viyakit tikinadiy. Aw li gwur niki jaav niki javir kupwarapa milaar van tikigwura, aal gwuradiy mawul kupwaraap tikinadiy. ");
INSERT INTO mle_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Gwur yarakara ada kupwaraap tikik-nadiygwur. ");
INSERT INTO mle_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","“Aw li gwuradiy mawul viyakit tikidana, kupwaraap ti maarin, kwurkigwuradiy yawiy duw taakw dayadiy mwutamaam lam kaytik kariyakidiy.” ");
INSERT INTO mle_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas maaj wakwusin napadik, Parasiy nak Jisasak bas sidid di diki wiyaam kamnaagw kidikikik. Wiyaar wulakuw, Jisas ata daan rad kamnaagw kikir. ");
INSERT INTO mle_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aw adi Parasiy vidil Jisas di taay maa taab jaan daya lo walil pik kamnaagw kikir tikuw. Di ata pitaan warid. ");
INSERT INTO mle_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jisas dikik ata wadid, “Gwur Parasiy bapa duw nimadiy yawiy kwur-kwanadiygwurik atampika lo kwurkwurik nuwukadiy duw taakw vikuw, ‘Kidiy viyakita duw-adiy,’ wadakikik. Aw gwuradiy mawul viyakit maa, kupwaraap-adiy. Gwur gwuradiy sipak wukikuw, gwur nuwukadiy duw taakw dayadiy jaav luwkuw kwurin nuwukadiy kupwarapa yawiy kwurkwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","“Gwur kwam tinadiy duw-adiygwurik! Gwur maa laakw gwuradiy sip yitakadi God di gwuradiy mawul ab yitakadidiy? ");
INSERT INTO mle_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","“Viyakita mawulawa gwuradiy niki jaav niki jaav saal yinadiy duw takwak akwiy. Gwur atawa kwurkuw, gwuradiy mawul tugwaam nakinadiy God diki milaam. ");
INSERT INTO mle_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Gwur Parasiy, mwiya kupwaraap tikina gwurak. Ababa mayim sigwuradiy kikipaat, adiy day mwiya kwasadiy tinadiy ab, day lawdaak, gwur yarakara am tabatiy sikuw, nak Godak kwiykwanadiygwurik. Atawa gwur yarakara kwurkuw, viyakita jaav duw takwak kwurin mawul Godak yan, adiy yitaypika jaav gwur akis kwur-kwanadiygwurik. Aw adiy kwasadiy yawiy kwurkuw, aal viyakita. Aw kidiy yitaypika yawiyim kwurkwurik mawul wukimar-tikwa. ");
INSERT INTO mle_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Gwur Parasiy, mwiya kupwaraap tikina gwurak. Gwur Juw dayadiy gaba maja wiyaam viyakita tikir kwurik. Gwur nyidi tipaam tiytiyaan tigwurkikib, duw taakw gwurak yataay, wayapiy sitaay, ‘Kupwiyaay, kalivakwanadi duw,’ wataay wadakikib, gwur rakarak tikwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Duw taakw jawjaay mawulaar wuki-kwadanalik, ‘Kidiy Parasiy God dikidiy duw tikuw, viyakita yawiy kwurkwanadiy,’ wakuw, alik day gwuradiy yawiy pik kwurkwanadiy. Aw day atawa kwurtaykib, vaal yikwanadiy Godak. Alik tikuw, gwur dayadiy yidanadiy vaal dayadiy maaw vaal gwur kwur-kwagwuradiy.” ");
INSERT INTO mle_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lo kalivadiy duw nak Jisasak ata wadid, “Kalivakwanadi duw, min atawa wamina, nyanak ab sapis jikin waminaala!” ");
INSERT INTO mle_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisas dikik ata wadid, “Mwiya kupwaraap tikina gwur lo kalivanadiy duwak ab! Gwur samasama lo duw takwak kwiy-kwagwuradiy day adiy lo wab wukidakik. Aw adiy kwiygwuradiy lo nimadiy vaat yinadiy dayaam. Aw gwur dayak sugwiyaan akis kwurkwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Mwiya kupwaraap tikina gwurak! Adiy tayir gwuradiy waragaagw viyasipa-dadiy God diki maaj wasapwiydiy duw, dayadiy kawamiyaam gwur yarakara gilabadiy sawtaka-gwuradiy. ");
INSERT INTO mle_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","“Gwur gilabadiy sawtakagwura adiy gwuradiy waragaagw viyasipadadiy God diki maaj wasapwiydiy duw dayadiy kawamiyaam. Atawa kwurkuw, gwur simakagwura gwur yaakiya wagwura gwuradiy waragaagw dayadiy kwurdadiy yawiyik. ");
INSERT INTO mle_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Alik tikuw, God lakwun tidik waad, ‘Wuna maaj wasapwiy-kinadiy duwawa wuna maaj karaykinadiy duwawa wayaki-kituwadiy Yisrayil jaka tipa kidiy duw takwak. Nuwukadiy day viyasipa-kidanadiy. Aw nuwukadiy day jawjaay kwurkidanadiy dayaam.’ ");
INSERT INTO mle_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","“God kidi kupw yitakadil nyab kariyarib gwuradiy waraga duw God diki maaj wasapwiydiy duwaam viyasipadadiy. Tayir, taay day Apilaam viyasipakuw, nuwukadiy God diki maaj wasapwiydiy duwaam day viyasipaan viyasipaan yin aw Sakaraya. Di God dikidi nyidi wiyaam tidik, day dim viyasipadaad. Aw wun gwurak watuwa, gwur kita kwanadiy duw taakw, dayadiy vaal pik kwurkigwura God gwuraam kupwaraap kwur-kidadiygwurik gwuradiy warag dayadiy valik ab tikuw. ");
INSERT INTO mle_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mwiya kupwaraap tikina gwur lo kalivanadiy duwak! Gwur God diki maaj liki mwiya maaw maa laakw. Samasama duw taakw day a maaj liki maaw wukik kwurdakib, aw gwur a maaj liki mwiya maaw takatipi-kwagwura dayak gwur gwura kapa mawulaar dayak kalivataay!” ");
INSERT INTO mle_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jisas a tip wapadik, adiy lo kalivadiy duwawa Parasiy day maa wadiy Jisas diki majiwa yawiyik. Alik tikuw, day samasama jaav bas sidiy dikik. Day ata kavin kwadiy Jisas di kupwarapa maaj wadik, day dim kwurkuw, kotiy ir karayik a majik. ");
INSERT INTO mle_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mwiya samasama duw taakw vagaluwdaak, day dayadiy apiy manim vasin tidiy. Jisas ki taay maaj dikidiy kalivadidiy duwak bas wadidiy, “Gwur wukir yarakara ada adiy Parasiy daya yis ak. Daya suwala majik watuwala. ");
INSERT INTO mle_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Ababa jaav adiyka pakwun rinadiy, ginyir abab maykaar warkinadiy. Ababa jaav sapwutakadaak rinadiy, ginyir adiy jaav abab duw taakw lakwuyaki-kidanadiy. ");
INSERT INTO mle_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","“Adiy jaav gwur kwasa kwasa wagwuradiy pakwun tan, ginyir ababa duw taakw adiy jaav wukikidanadiy.” ");
INSERT INTO mle_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Wunadiy kapa nyanugw, wun gwurak watuwadiygwurik gwur duwak yaga-tikwa. Day amwiydika viyasipa-kidanadiy. Viyasipakuw, ginyir day niki jaav gwuraam kwurkwur rav maa. ");
INSERT INTO mle_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","“Wun gwurak simakakituwaad yagakigwuradi duw. Gwur Godak ayag. Di duw takwaam viyasipakuw, di ap tikuw, bwunak yiy yanin tamiyaar yakiyakik. ");
INSERT INTO mle_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Saan nak kwasadiy wapwiy duwamiy nak duw yapiy-kwadanadiy kidakikik. Aw God di akis mawul wukimar-kwanaad adiy kwasadiy wapiyik. ");
INSERT INTO mle_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","“Gwuradiy abwaam tinadiy nab kas-adiy? God atampik kwasadiy jaav ab bwu lakwuya-dadiy. Aw gwur kwasadiy wapiy maa. Gwur mwiya duw taakw-adiygwurik. Alik tikuw, gwur wuki-tikwa. God nyanadi Asaay, di gwurak yara van tikwanaad.” ");
INSERT INTO mle_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Li duw nak duw taakw mwutamaam tan dayak wakida, ‘Wun Jisas dikidi duw-adiwun’ waan, wun, duw taakw dayadi Mwaam, wunabab God dikidiy maaj kardadiy duw mwutamaam wakituwadiy, ‘Adi duw wunadi duw-ad.’ ");
INSERT INTO mle_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","“Aw li duw nak duw taakw mwutamaam tan dayak wakida, ‘Wun Jisas dikidi duw maa’ waan, wunabab God diki maaj kardadiy duw mwutamaam wakituwadiy, ‘Adi duw wunadi duw maa.’ ");
INSERT INTO mle_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Aw duw taakw, duw taakw dayadi Mwamik sapis jikin kwurkidana, God atampika vaal bwunak sipwutiykida. Aw li God dikidi Mawulak sapis jikin kwurkidana, a vaal aal God di samab sipwutiy maa. ");
INSERT INTO mle_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Gwur wunadiy duw taakw, aw li a javik tikuw, day gwuraam karay-kidanadiygwurik dayadiy gaba maja wiyaar dayadiy tamiya kidiy yitaypika duwawa, dayadiy sapakwa nyanugwak gwuraam kotiy ik, aw gwur kot im tikuw, bwula bwula majik wuki-tikwa. ");
INSERT INTO mle_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","“Aw a nyi God dikidi Mawul gwuradiy bwula-kigwuradiy maaj kaliva-kidadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Vagaluwdiy duw taakw daya nyidim duw nak alim tikuw, Jisasak ata wadid, “Kaliva-kwanadi duw, min wunadi mwamik wamin, anadi asaay kiyakuw, wapadidiy jaav wunak nuwuk am saan kwiykwaad.” ");
INSERT INTO mle_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aw Jisas dikik ata wadid, “Sikadadaad wunaam tasakwud atampika yawiy birak kwurtuwkik?” ");
INSERT INTO mle_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jisas adiy vagaluwdiy duw takwak ata wadidiy, “Gwur yarakara van ada nuwukadiy duw taakw dayadiy javik mawul yikwayik kwurik. Duw taakw dayadiy samasama niki jaav niki jaav maa rav mwugiy-mwugiyik dayadiy mawul viyakit tidakikik.” ");
INSERT INTO mle_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jisas ki waya maaj kitika maaj di dayak ata wadidiy, “Saan samasam tidi duw diki mayim sididiy jaav mwiya samasam ridiy. ");
INSERT INTO mle_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","18","“Di dikik ata waad, ‘Wuna mayim tinadiy mwiy samasam-adiy. Aw wunadiy bay wiy maa rav dayadiy mwiy takatakak. Agwa jaav kwurkidiwun? Aw kitawa kwur-kidiwun. Wun wunadiy bay wiy kaybwiykuw, nuwukadiy nimadiy bay wiy kwur-kituwadiy. Kwurkuw, dayaam kidiy mayim rinadiy javiwa nuwukadiy jaav ab mwiyir taka-kituwadiy. ");
INSERT INTO mle_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“‘Atawa kwurkuw, wun wunak wakidiwun, Kidiy jaav nabiy samasam wunaam rivikidiy. Jaaw, wun wuna sipak wuki-kidiwun. Wun kamnaagw kan guw kan sakwar sakwar kwakidiwun.’ ");
INSERT INTO mle_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Aw God dikik ata waad, ‘Min kwam yinadi duw-adimin. Ki gaan min kiya-kinadimin. Kiyamin, minadiy niki jaav niki jaav si kwurkidiy?’” ");
INSERT INTO mle_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jisas dayak ata wadidiy, “Atampik adiy duw taakw day dayadiy sipak samasama jaav vagaluwnadiy, aw God dikidi gikim day saal yinadiy duw taakw-adiy.” ");
INSERT INTO mle_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Alik tikuw, watuwadiygwurik, kamnagwuk samasam wuki-tikwa. Gwuradiy kwusuw wapwiyik ab wuki-tikwa. Gwuraam vaat yikik-nabir. Gwurabir mawulawa amwiy abir mwiya yitaypik kamnagwawa kwusuw wapwiyik tinabir. Aw li God gwuradiy mawulawa amwiy gwurak kwiykuw, di mwiyir kamnagwawa kwusuw wapwiy gwurak kwiy-kidadiy. Alik abir kwasabir javik samasam wuki-tikwa. ");
INSERT INTO mle_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Gwur wadiy wulin yin yan tikwanadiy wapiyik av. Gwur mayim taba jaav sigwur, wardaak, ginyir ata yin lawdaak, kwurkuw, wiyaar kariya-gwuradiy kikir. Gwur kwur-kwagwura pik wapiy akis atampika yawiy kwurkwanadiy. God di diki dayak van tikwadadiy. Aw li di kikipaat wapiyik kwiykida, aw di mwiyir gwurak van tikinaad. ");
INSERT INTO mle_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Aw li gwur samasam wuki-kigwura kiyakiyak, niki nyi nak gwur gwura sitay sitaay rav maa. Aw a jaav nima jaav maa God kwurkwurik. ");
INSERT INTO mle_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Aw li gwur atampika jaav kwurkwur rav maarlik, agwa javik nuwukadiy javik wukinadiygwurik? ");
INSERT INTO mle_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Gwur kip warkwanadiy mawayak av. Gwur nimadi yawiy kwur-kwanadiygwurik gwuradiy wapwiy tipak. Aw adiy mawaay day gwur kwur-kwagwuradiy yawiy pik akis kwurkwanadiy. Tayir Juw dayadi yitaypika duw, Salaman, viyakita wapwiy kwusuw-didiy. Aw diki gilabadiy adiy mawaay dayadiy gilabadiyim maa kakil. ");
INSERT INTO mle_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","“Adiy kip warkwanadiy mawaay nibwul kip tikuw, kwasa mwiy tikuw, duw taakw dayaam gwakuw yiyaam taka-kidanadiy. Aw li God adiy mawayak dayadiy gilabadiy sawtaka-kwadadiy, di gwurabab gwuradiy wapwiy mwiyir kwiy-kidadiygwurik. Gwur kipa kwasa mwiydika Godak wukijibir tikwanadiygwurik! ");
INSERT INTO mle_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","“Atawa tikuw, mawul warin wukiway, ‘Nyan agwa kikipaat kikidiyan? Nyan agwa guw kikidiyan?’ Adiy haiden tinadiy duw taakw atawa mawul wuki-kwanadiy. Aw gwur atawa wuki-tikwa. Aw gwuradi Asaay bwutaay lakwu-dadiy adiy saal yigwuradiy javik. ");
INSERT INTO mle_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","“Aw yitaypika jaav gwuradiy mawulaam takakigwura God dikidi gwalugwum tikir, yaakiya, di adiy nuwukadiy jaav ab gwurak ata kwiykidadiy.” ");
INSERT INTO mle_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Wuna kwasa bapa duw, gwuradi Asaay rakarak tinaad gwur dikidi gwalugwum tigwurkikik di gwuraam van tidikikik. Alik tikuw, gwur yaga-tikwa. ");
INSERT INTO mle_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Gwuradiy ababa jaav awarapiy sanak. Adiy saan kwurkuw, saal yinadiy duw takwak akwiy. Kidi kupwaam gwuradiy kwasabiy takwudaak, luwkuw duw luwkuw kwurdaak, wawraay sukwutuwdaak, gwuradiy niki jaav niki jaav jaaw yikidiy. Atawa kwurkuw, adawul tipaam gwurak God sibinin kwiykida yara kwagwurkikik. ");
INSERT INTO mle_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","“Gwuradiy mawul gwuradiy niki jaav niki jaav ridana tamiyak nyanyi wuki-kwanadiy.” ");
INSERT INTO mle_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Yawiy duw dayadi sapakwa duw, duw taakw kiradil bayaki kikipatik yidik, day kavin kwadiy diki sibinin yakida nyak. Gwur atampik gwuradiy wapwiy kaybwutiysuwkuw, vasikirikikuw, lam wapatakakuw, gwur kavin ada yawiyik. Aw adi sapakwa duw sibinin yakuw, di wiyigaam viyadik, dikidiy yawiy duw kavin kwakuw, yabiyib dikik wiyig sikwutaka-kidanaad. ");
INSERT INTO mle_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","“Adiy yawiy duw dayadi sapakwa duw sibinin yakuw, vidil day kip dikik kavin kwadiy, day rakarak samasam tikwadiy. Aw wun gwurak watuwa, adi sapakwa duw atawa vikuw, di dikidi wapwiy kaybwutiysuwkuw, dayak kikipaat sukwulik yikuw, kwiydik, day jabim daan ran kikidiy. ");
INSERT INTO mle_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","“Aw li adi sapakwa duw nyidi gaan yakuw, ay taay tapwuk wadik yakuw, vidik adiy dikidiy yawiy duw kip kavin kwadiy dikik, aw adiy yawiy duw mwiya rakarak tikwadiy. ");
INSERT INTO mle_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Gwur yara awuk ki maaj. Aw li wiy asaay duw di adi luwkuw kwurkwanadi duw diki wiyaar yakida gaan di lakwuk-da, a gaan kip van tikik-naad adi duwak diki wiyaar wulawulak. ");
INSERT INTO mle_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","“Atampik gwurabab nyanyi gwuradiy mawul kwulapwu-jibirin adakw. Aw gwur maa laakw wun, duw taakw dayadi Mwaam, kidi kupwaar sibinin dakituwadi nyi.” ");
INSERT INTO mle_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita Jisasak ata wadid, “Yitaypika Duw, waal wamina waya maaj kitika maaj nyanak wanadimin, ay? Ababa duw takwak wanadimin?” ");
INSERT INTO mle_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yitaypika Duw Jisas dayak ata wadidiy, “Agwa yawiy viyakita yawiy duw kwurkinaad dikidi sapakwa nyinik? Di atawa kwurkinaad. Dikidi sapakwa nyan wadik, di nuwukadiy yawiy duwak van tikinaad. Di dayak yara van titaay, dayadiy kamnaagw dayak kwiykinaad dayadiy kamnaagw kikwadana sikir. ");
INSERT INTO mle_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","“Adi yawiy duw atampik viyakita yawiy kwurdik, aw dikidi sapakwa nyan sibinin yakuw, di viyakita yawiy vikuw, adi yawiy duw rakarak tikinaad. ");
INSERT INTO mle_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","“Adi sapakwa nyan dikidi yawiy duwak ata wakinaad, ‘Aw min wuna sibinin yakituwa nyi min maa laakw. Aw wun kip yakuw, vituwa min viyakita yawiy kwurnadimin. Alik tikuw, min wunadiy ababa javik van tikiminadiy.’ ");
INSERT INTO mle_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Aw li adi yawiy duw kupwaraap tikida, di diki mawulaar wakida, ‘Wunadi yitaypika duw di sibinin yabiyib yay maa.’ Atawa wukikuw, di jawjaay kwurkinaad nuwukadiy yawiy duw takwaam. Di duw tikwul-kwanadiy duwawa kwakuw, dayawa kamnaagw kitaay, duw kwam yikwadiy guw kikinaad. ");
INSERT INTO mle_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","“Adi yawiy duw dikidi sapakwa nyan sibinin yakinaad nyi nak dikik. Aw adi yawiy duw di laakw maa a javik. Adi sapakwa nyan dikidi yawiy duw diki kupwarapa yawiy vikuw, di dikim mwiya nimadib viya-kidaad. Viyaan napataka, di wayaki-kidaad kupwarapa tipaar nuwukadiy kupwarapa duw takwawa kwadikikik. ");
INSERT INTO mle_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Adi yawiy duw dikidi sapakwa duw kwurdikik wadil jaav lakwukuw, aw li di kwasik yikida a yawiy kwurkwurik, dikidi sapakwa duw dim nimadib viyakidaad. ");
INSERT INTO mle_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Aw li adi yawiy duw dikidi sapakwa duw kwurdikik wadil jaav laakw maarkuw, aw di niki yawiy kwurkida, dikidi sapakwa duw dim kwasa nimadib viyakidaad. Adiy duw taakw God dayak samasama yawiy kwiydadiy, dayabab day samasama yawiy sibinin dikik kwiykwadiy. Aw adi duw God dikik mwiya samasama yawiy kwiydadiy, dibab dim mwiya samasama yawiy sibinin Godak kwiykwaad.” ");
INSERT INTO mle_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Wun God dikidi Mawul wayaki-kituwaad. Di yawiy kwurkinaad yiy kaytik, aw wun kidi kupwaar yatuwil ki yawiyik. Wuna mawul wana God dikidi Mawul bwutaay ki yawiy kwurik-da basa kasab. ");
INSERT INTO mle_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","“Aw taay kagil samasam wuna sipaar yakidiy. Kidiy ababa kagil yin kwusidaak, wuna mawul ata wiyaw nakina. ");
INSERT INTO mle_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Wun kidi kupwaar datuwil duw taakw dayadiy wariya mawul kwusidakik maa. Wun datuwilik alik nuwukadiy duw taakw wunak wukijibir tikuw, aw nuwukadiy duw taakw wunak wukijibir ti maarkidana, day ata kapakap kapakap tikidiy. ");
INSERT INTO mle_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Alik tikuw, wiy nikim kwakidiy duw taakw dayadiy mawul kajakuw, mugwul niki bapaam, vitiy niki bapaam, atawa tikidiy. ");
INSERT INTO mle_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“Asayugw maa wakidiy dayadiy duwa nyanugwak. Aw duwa nyanugw maa wakidiy dayadiy asayik. Amayugw maa wakidiy dayadiy takwa nyanugwak. Aw takwa nyanugw maa wakidiy dayadiy amayik. Duw dayadiy taakw maa wakidiy dayadiy kajarik. Aw kajaar maa wakidiy dayadiy duwa nyanugw dayadiy takwak. Atawa dayadiy mawul kajakuw, kapakap kapakap tikidiy.” ");
INSERT INTO mle_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","55","“Gwur baw tubw nyi dakwada tamiyaam tidik vikuw, wakwadiygwurik, ‘Waal jakina,’ waan. Wakuw wagwur, waal ata jakina. Waliy viyalikib, wakwadiygwurik, ‘Waal ji maa,’ waan. Wakuw wagwur, waal ata ji maa. ");
INSERT INTO mle_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“Gwur viyuw tikala pik pasiranadiy duw taakw-adiygwurik. Gwur kidawa tubwaar kituw vikuw, kidi kupwaam tinadiy javim vikuw, bwunak lakwukuw wakidiygwurik, ‘Ki nyi waal jakina. Ki nyi waal ji maa.’ Aw agwa javik tikuw gwur wunadiy yawiyik vikuw, dayadiy maaw laakw maargwuradiy?” ");
INSERT INTO mle_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Gwur gwura viyakita jaav alakatiy kwurkwurik. ");
INSERT INTO mle_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Aw li duw nak minaam kotiy ir karayik tidik, yabir yitaay tikuw, nyidi yabim adi duwawa min a maaj alakatiy. Bir mawul nak ada. Aw li atawa adi duwawa lakatiy maarkimina, aw adi duw minaam karayin jas tabaam takadik, aw jas plisman tabaam takadik, aw plisman kalabus ir kwusawula-kidanadimin. ");
INSERT INTO mle_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","“Mwiya maaja watuwa. Aw min kalabus im kwaan yin jas wadidiy saan miyawa kwiykimina adi duwak, ata kalabus kwusi-kinadimin. Aw saan dikik kway maarkimina, min kip kalabus im kwayi-kinadimin yin mina dinau kwusikila nyab.” ");
INSERT INTO mle_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A nyi nuwukadiy duw Jisasak yakuw, day dikik yarik yidaad nuwukadiy Galiliya tamiya kidiy duw day Godak vaal kwurdaak, Paylat vay sawdiy duw wayakidik dayaam viyasipa-dadiy. ");
INSERT INTO mle_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisas dayak ata bas sididiy, “Day adiy Galiliy tamiya kidiy duwaam atawa viyasipakuw, gwur wukigwura adiy duw dayadiy vaal ababa nuwukadiy Galiliy tamiya kidiy duw dayadiy valim kakil-danadiy? ");
INSERT INTO mle_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“Atawa maa! Wun gwurak watuwa li gwur gwuradiy valik bwan kway maarkigwura, gwur abab kupwaraap kwurkigwura daya pik. ");
INSERT INTO mle_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Gwur wukigwura aluwur pik tidi kabaka wiy Saylawum tamiyaam vakirkuw, duw taakw tabatiy maan abamugwulaam vakirkuw viyasipa-didiy. Aw gwur wukigwura adiy kiyadiy duw taakw dayadiy vaal nuwukadiy Jiruwsalimaam kwanadiy duw taakw dayadiy valim kakildanadiy? Ay? ");
INSERT INTO mle_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","“Atawa maa! Wun gwurak watuwa, li gwur gwuradiy valik bwan kway maarkigwura, gwur abab kupwaraap kwurkigwura daya pik.” ");
INSERT INTO mle_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jisas ki waya maaj kitika maaj ata wadidiy, “Duw nak dikidi maay duwak wadid miy si vik sidikikik dikidi mayim. Ginyir di yaad mwiy rirak vikir adi miyaam. Aw samab maa mwiy ri. ");
INSERT INTO mle_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","“Vikuw, di dikidi maay duwak wadid, ‘Nabiy mugwul wun kilir yatuwa mwiy rirak vikir kidi miyaam. Aw samab maa mwiy ri. Yaakiya, kidi miy avil. Di kip tan gaaj yikinaad.’ ");
INSERT INTO mle_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Aw adi mayim yawiy kwurdi duw adi maay asaay duwak ata wadid, ‘Sapakwa duw, wapamin kip tikwaad kidi nabiyda. Tidik, wun yaan vakuw, bulmakau dayadiy diy kariyakuw, takakituwadiy dikidi mawum. ");
INSERT INTO mle_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","“‘Aw li kidi miy mwiy rikida nikidi nabiy, ay yaakiya. Aw li mwiy ri maarkida, a jaaw nibwu vilkiminaad.’” ");
INSERT INTO mle_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sapat nyi nak Jisas Juw dayadi gaba maja wiyaam tan, duw takwak kaliva-didiy. ");
INSERT INTO mle_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Alim taakw nak kwaal. Wudib nak liki mawulaar yikuw, di mwugiydik, li giviyib nabiy tabatiy maan abamugwul kwayalidiy. Likidi bwan kwudikidik, aw li sinawurin titak akis rivikwaal. ");
INSERT INTO mle_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas likim vikuw, likik wataykuw, ata wadil, “Nyina giviyib aka bwu akwusina!” ");
INSERT INTO mle_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Di dikibir taab likim takadik, jayib nak ata sinawurkuw rasin tal. Rasin tikuw, li ata Godak wayapiy silid. ");
INSERT INTO mle_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Adi gaba maja wiyak van tidi duw vikuw, di wukikuw Jisas a taakw sipwutiydil Sapat nyaam, di yaal giraad Jisasak. Alik tikuw, vagaluwdiy duw takwak wadidiy, “Nyi abwun-adiy yawiy nyi. Gwuradiy giviyib sipwutiyin kwurik, gwur adiy nyaam may. Aw Sapat nyaam maa!” ");
INSERT INTO mle_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yitaypika Duw Jisas adi duwawa adiy diki mawula pik tidiy duw takwak ata wadidiy, “Gwur viyuw tikala pik pasira-nadiygwur! Sapat nyaam gwuradiy bulmakau awa donki daya wiyaam kwadaak, gwur yitaay dayadiy yaav raliykuw, kawaar kwurin karay-kwagwuradiy guw kidakikik. ");
INSERT INTO mle_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","“Aw ki taakw li Aparam diki gwalugwa taakwal. Aw Satan lim kalakwun kwadil nabiy tabatiy maan abamugwul. Alik tikuw, wun ki taakw Satan tabaam tilik, wun Sapat nyaam nyigil-nyigil maa rav, ay maa?” ");
INSERT INTO mle_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas dikidiy mama duw day diki wadil maaj wukikuw, wap saydiy. Aw ababa nuwukadiy duw taakw day rakarak tidiy Jisas diki kwurdil viyakita yawiyik. ");
INSERT INTO mle_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Jisas adiy duw takwak ata wadidiy, “Agwa jaav kaytik God duw takwak van tinaad? Agwa javir wakituwaad lakwu-gwurkik? God diki yawiy sika mastat kitik nimaad warkwanaad. Duw adiy kwasa kwasadiy sika mastat kwurkuw, diki mayim sididiy. Ginyir warkuw, miy tidik, wapiy day dikidiy baw miyaam kwaat taka-kwadanaad. Atampik God duw takwak van tikwanaad.” ");
INSERT INTO mle_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Jisas dayak bas sididiy maa, “Agwa jaav kaytik God duw takwak van tinaad? Agwa javir wakituwaad lakwu-gwurkik? God duw takwak van tinaad yis kaytik. Diki yawiy yis kaytik nimaad warkwanaad. Taakw bret sukwulik yikir tikuw, li ata kwasa yis kwurkuw, plaua wa nakamwiyib kwurjuwtakakuw, kaybaybalakin kwurlikib, ginyir a plaua wa yis wulkuw, mwiya nima tikina.” ");
INSERT INTO mle_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas Jiruwsalimaar yikir tikuw, di adiy samasama tiparib wulayid. Adiy tipa kidiy duw takwak kaliva-didiy. ");
INSERT INTO mle_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Duw nak Jisasak ata bas sidid, “Yitaypika Duw, duw taakw aywa maa God dikidi gwalugwur wulakidiy?” Jisas vagaluwdiy duw takwak ata wadidiy, “Duw taakw viyakita kwakidanadi tipaar yikwanadi yaab adi wiyig tipwiy maa ti. Kwasaad-ad. Aw gwur wagwura viyakita yawiy akwur adi wiyigaar wulawulak. Aw wun gwurak watuwadiygwurik samasama duw taakw adi wiyigaar wulak kwurkidana, aw dayaam rav maa. ");
INSERT INTO mle_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Adi wiy asaay duw rasikuw, adi wiyig ata takatipi-kidaad. Takatipidik, gwur nyidim nuwukadiy duw taakw kawaam tigwur, adi wiyigaam viyataay, wakigwuraad, ‘Yitaypika Duw, nyanak kidi wiyig asakwutak!’ Aw di gwurak ata wakinaad, ‘Wun gwuraam maa laakw. Gwur akim tikuw, yanadiygwurik?’ ");
INSERT INTO mle_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Wakuw wadik, gwur ata wasawulakuw, wakigwuraad, ‘Nyan minawa nakamwiyib kamnaagw kan guw kidiyan. Aw min mina nyana tipaam kalivaminadiyan!’ ");
INSERT INTO mle_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Gwur atawa wagwur, di gwurak maa wakinaad, ‘Wun gwuraam maa laakw. Gwur akim tikuw, yanadiygwurik? Gwur wunaam agwutak! Vaal yiyi tikwanadiy duw taakw-adiygwurik!’ ");
INSERT INTO mle_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Gwur vikuw Aparam Aysak Jakapawa nuwukadiy God diki maaj wasapwiydiy duwawa day God dikidi tipaam kwadaak, gwuraam God watipidik, gwur kawaam titaay, girataay, wuk vatikirikiy-kidiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","“Kidi kupw miyawa tamiya kidiy duw taakw God dikidi tipaar yakuw, day jabim daan rikidiy kamnaagw kikir. ");
INSERT INTO mle_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Kita samasam day yitaypik tinadiy, ginyir mwiyir yisadayaki-kidiy. Aw kita nuwuk day yisadayaki-nadiy, ginyir day yitaypik tikidiy.” ");
INSERT INTO mle_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A nyi nuwukadiy Parasiy Jisasak yakuw, dikik ata wadaad, “Juw dayadi yitaypika duw Yirat, di minaam viyasipaak wanaad. Alik min ki tip awap.” ");
INSERT INTO mle_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisas dayak ata wadidiy, “Gwur yikuw, adi yarakara suwaal kwurkwanadi duwak aw: ‘Nibwulawa sir wun mawulaar yidiy wudib kwurin yakikituwadiy. Yakikuw, adiy giviyib kwurnadiy duw taakw sipwutiy-kidiwun. Yaakiya, muw wuna yawiy kwusikina.’ ");
INSERT INTO mle_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Nibwulawa sirwa muw wun yabisaay yikidiwun. Ababa God diki maaj wasapwiydiy duw day kipa tamiyaam dayaam viyasipa viyasip a maa rav. Aw day Jiruwsalimadanim viyasipa-kwadanadiy. ");
INSERT INTO mle_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","35","“O Jiruwsalim tipa kidiy duw taakw, gwur bwutaay God diki maaj wasapwiydiy duw viyasipa-gwuridiy. Diki maaj karaydiy duw gwurak wayakidik, dayaam kabaak kwariyaki-gwuridiy viyasipak. Nyanyi wun gwurak amaay tapwuk likidiy nyanugwak likibir pipaar takatipitaay kwurin rikwala pik, atampik wun gwurak kwurik. Aw gwur maa wanadiygwurik wunak. Alik tikuw, God maa wanaad gwurak. Aw gwur kip kwakwanadiygwurik. Aw wun gwurak watuwadiygwurik, gwur wunaam samab van ti maa. Aw ginyir gwur wakigwura, ‘Nyan God dikidi wayakididi duwak wayapiy sinadiyan,’ wun ata sibinin yakidiwun.” ");
INSERT INTO mle_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sapat nyi nak Jisas di sapakwa nyan Parasiy diki wiyaar yad kikipaat kikir. Nuwukadiy duw day dikik mila sukw kwurdiy aw li di dayadiy lo watipidadiy yawiy kwurkwurik. ");
INSERT INTO mle_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Atawa van ridaak, dikidiy manwa taab wulda duw Jisasak yaad. ");
INSERT INTO mle_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisas adiy lo lakwudiy duwawa Parasiyak wadidiy, “Nyana lo ata ata wana giviyib kwurnadiy duw taakw dayadiy giviyib sipwutiy-sipwutiyik Sapat nyaam? Yaakiya wana, ay maa?” ");
INSERT INTO mle_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aw day dikik samab maaj maa wu. Atawa tikuw, Jisas adi maan taab wulda duw dikidiy maan taab sipwutiykuw, wayakidik yad. ");
INSERT INTO mle_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jisas dayak ata wadidiy, “Aw li gwuradiy duwa nyanugw ay bulmakau vakirdaak guw rilil kawaar Sapat nyaam, gwur ata ata, lagwun kawarik-gwuradiy, ay maa Sapat nyi tilik?” ");
INSERT INTO mle_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aw day dikik wawak wukidaal maa rav. ");
INSERT INTO mle_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas ata vidil nuwukadiy duw day yitaypika duw dayadiy tikirim daan rikir kwurdalik, di ki waya maaj kitika maaj dayak wadidiy: ");
INSERT INTO mle_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Aw li nuwukadiy duw gwurak duw takwaam kirakida bayaki kikipatik yin kigwurkikik bas sidaak, gwur yikuw, yitaypika duw dayadiy tikirim daan rikir kwur-tikwa. Aw li gwur atawa kwurkigwura, nikidi duw di yitaypik minaam yakida, adi bayaki kikipatik van tinadi duw gwurak wakidadiygwurik, ‘Kidi duw waal min rimina tamiyaam rikinaad.’ Atawa wadik, gwur samasam wap saykuw, rasikuw, yikuw, yisadapika duw tikirim daan rikidiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Aw day gwurak bas sidaak bayaki kikipatik yin kigwurkikik, gwur yikuw, yisadapika duw tikir kwurkuw, daan ada. Gwur atawa kwurkigwura, adi bayaki kikipatik van tinadi duw gwuraam vikuw, yakuw, wakidadiygwurik, ‘Kapa duw, min wunawa may yitaypika duw tikir kwurik.’ Atawa wadik, gwur yisuw pik tikidiygwurik adiy vagaluwdiy duw taakw milaam. ");
INSERT INTO mle_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Ababa duw taakw day dayak yisuw pik tikir yawiy kwurkidiy, aw God mwugiydik, adiy duw taakw yisada pik tikidiy. Aw ababa duw taakw day yaakiya wakidiy day yisada pik tikir, aw God mwugiydik, atampika duw taakw day yitaypik tikidiy.” ");
INSERT INTO mle_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisas adi dikim waan kamnaagw kidikikik karaydi duwak ata wadid, “Aw li min nuwukadiy duwaam waan kariyaak mina wiyaar kamnaagw kidakikik tikuw, min minadiy kapa nyanugw, min minadiy mwaam nyamwusugw, min minadiy gwalugwa duw, min minawa walibab kwanadiy saan samasam tinadiy duwaam waan kariya-tikwa. Aw li min atampika duwaam waan karaykimina, awarabab day minaam waan karay-kidanadimin dayadiy wiyaar. ");
INSERT INTO mle_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Min bayaki kikipaat jabim takak tikuw, adiy saal yinadiy duw taakw, adiy duw taakw dayadiy ap bwan maan taab kupwaraa tinadiy, adiy duw taakw dayadiy mil tipinadiy, atampika duw taakw waan akaray. ");
INSERT INTO mle_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","“Atampika duw taakw minaam awarab waan karay karay rav maa. Aw alik tikuw, God minaam viyakit kwurkidadimin dikidiy viyakita duw taakw day kiyakuw ridaak, kirapitakakida nyaam.” ");
INSERT INTO mle_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A jabim ran kamnaagw kidi duw nak a maaj wukikuw, Jisasak ata wadid, “Adiy duw taakw day daan rikidiy kikipaat kikir God dikidi duw takwaam van tikidadi tipaam, day mwiya rakarak tikwadiy!” ");
INSERT INTO mle_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisas dikik ata wadid, “Duw nak di nimadi bayaki kikipaat kwiyik tikuw, samasama duw takwak akiy kwiytaka-didiy yadakikik. ");
INSERT INTO mle_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","“Adi bayaki kikipaat kwulapwun ridik, adi duw dikidi yawiy duw wayakidik, yad adiy tayir akiy takadidiy duw takwaam waan kariyaak, dayak, ‘May, ababa jaav bwutaay kwulapwun rinadiy,’ waan wadikikik. ");
INSERT INTO mle_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Aw day abab kwasik yidiy adi bayaki kikipatik yiyak. Alik tikuw, duw nak yawiy duwak wadid, ‘Wun kupw yapiytuwaad. Alik wun wunadi kupwak vikir yikidiwun. Alik tikuw, wun yiyi rav maa.’ ");
INSERT INTO mle_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Aw nikidi duw ata waad, ‘Wun yawiy bulmakau tabatiy yapiytuwadiy. Alik tikuw, wun dayaam mwugiykitaan vikir kwakidiwun. Alik tikuw, wun yiyi rav maa.’ ");
INSERT INTO mle_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Aw nikidi duw ata waad, ‘Wun wayab taakw kiranadiwun. Alik tikuw, wun yiyi rav maa.’ ");
INSERT INTO mle_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Adi yawiy duw sibinin yikuw, dikidi sapakwa nyinik adiy wadadiy majib majib wadid. Aw adi wiy asaay duw adiy maaj wukikuw, di yaal samasam giraad. Girakuw, di dikidi yawiy duwak ata wadid, ‘Min yabiyib maay adiy kidi tip dikidiy nimadiy yabawa kwasadiy yabir. Yikuw, adiy saal yinadiy duw taakw, adiy duw taakw dayadiy ap bwan maan taab kupwaraap tinadiywa, adiy mil kwakidiy, abab kwurkuw, akaray.’ ");
INSERT INTO mle_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Kwasa mwiy tikuw, adi yawiy duw dikidi sapakwa nyinik ata wadid, ‘Sapakwa duw, waminadiy yawiy bwutaay kwurtuwadiy, tamiy kip rinadiy.’ ");
INSERT INTO mle_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Aw adi sapakwa duw dikidi yawiy duwak ata wadid, ‘Min adiy kipa tamiyaar yinadiy yabiwa mayir yikuw, sitakira-kiminadiy kipa duw taakw kwurin akaray. Kariyamin, kidi wunadi wiy wapwurukwu-kwaad. ");
INSERT INTO mle_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“‘Aw minak watuwadimin adiy taay yadakikik watuwadiy duw taakw day samab kidiy wunadiy kikipatim ki maa!’” ");
INSERT INTO mle_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Duw taakw samasam Jisasawa yitaay tidaak, di dayak tipatiyakwukuw, wadidiy, “Aw li duw taakw day wunadiy kaliva-tuwadiy duw taakw tikir wakuw, aw day dayadiy amaay, asaay, nyanugw, taakw, mwamugw, nyamwusugw, aw day dayadiy kapa sipak ab yikwadanadiy mawul dayadiy wunak yidanadiy mawulaam yitaypik tikidana, ata day wunadiy kaliva-tuwadiy duw taakw samab ti maa. ");
INSERT INTO mle_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Aw adiy duw taakw kwasik yikinadiy nuwukadiy duw taakw dayaam kupwaraap kwurkidanadiy jaav kwurkwurik wuna danik wakuw, adiy duw taakw wunadiy kalivatuwadiy duw taakw ti maa. ");
INSERT INTO mle_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Aw li gwuraam duw nak wiy kwurik tikuw, di taay adi wiyak saan kwas kwurkidadiy yapiy-yapiyik. Atawa wukikuw, dikidiy ababa saan nasikuw, di ata lakwukida dikidiy saan rivikinadiy, ay maa. ");
INSERT INTO mle_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","“Aw li di atawa kwar maarkida, adi kwurkidadi wiy di mwiyir kwurkwusim maa. Atawa tikuw, nuwukadiy duw taakw day diki kwurdil yawiyim vitaay, rik kwurtaay, wajikidanaad dikik, ‘Kidi duw di diki yawiy kwurkwusi-kwurkwus maa rav!’ wataay wakidiy. ");
INSERT INTO mle_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Aw li tip nak dayadi yitaypika duw di wukidil nikidi tip dayadiy vay sawdiy duw yanadiy aw di dayawa wariyaak, a tipa kidiy vay sawdiy duw dikidiy vay sawdiy duwaam kakildiy. Alik tikuw, di wukitaytayad, ‘Nyan dayaam kakil-kibanadiy, ay nyan rav maa?’ ");
INSERT INTO mle_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","“Aw di wukidil di dayawa wariy-wariyak rav maarlik, aw day sikab yataay tidaak, di duw wayaki-kidadiy a tipa kidi yitaypika duwak adi wariy kwusidikik. Kwusikuw, kip yarakara kwakir.” ");
INSERT INTO mle_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jisas dayak ata wadidiy, “Atampik, gwur wunadiy kalivatuwadiy duw taakw tikir, taay gwur yarakara awuk. Gwuradiy ababa jaav wapakuw, wunadiy kalivatuwadiy duw taakw tigwurkikik gwuradiy mawul ata yidabaal maa adiy javik.” ");
INSERT INTO mle_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Gwur yarakara awuk. Waliy kwas ad viyakitad. Aw li waliy kwas wakwukwusidik, aw alik ginyir bay yiyi rav maa. ");
INSERT INTO mle_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","“Wakwukwusidik, ginyir adi waliy kwusim yawiy nakab kwurkwur rav maa. Alik day kip yakiyaki-kidanaad. Gwur adiy waan tinadiy, gwur awuk. Gwur adi atampika waliy kwas kaytik tikik-nadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nyi nak samasama takis kwurdiy duw nuwukadiy vaal yidiy duwawa Jisasak yadiy diki maaj wukik. ");
INSERT INTO mle_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nuwukadiy Parasiyawa God diki lo kalivadiy duw vikuw, maa wadiy a javik. Alik day yaal girakuw, day dayak wadiy, “Sa! Kidi duw yaakiya wanaad vaal yinadiy duw taakw dikik yadakikik. Aw di dayawaanab kikipaat kinaad!” ");
INSERT INTO mle_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Day atawa wadaak, alik tikuw Jisas ki waya maaj kitika maaj dayak ata wadidiy. ");
INSERT INTO mle_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Li gwuraam duw nak di sipsip duwamiy tabab (100) tikuw, aw nak jaaw yilik, di, ‘Jaaw yikwa,’ wakida? Aw si wana? Sipsip duwamiy aliy sap tabatiy maan abaliy (99) di dayaam wapakuw, kipa tamiyaam di kwakiyin kwakiyaan tikinaad a sipsip ak. ");
INSERT INTO mle_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","“Adi duw a sipsip sitakirakuw, di rakarak tikuw, sipsip diki kubwum takakuw, tipaar kariya-kidaal. Tipaar wakwukuw, tipa duw takwawa gwalugwa duw takwak gaam sikidadiy day yadakikik dikik. Di dayak ata wakidadiy, ‘Wun wuna jaaw yil sipsip bwutaay sitakira-tuwaal. Alik gwur wunawa nakamwiyib rakarak ada!’ ");
INSERT INTO mle_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Atawa adawur tipaam kwanadiy day rakarak tinadiy adiy duwamiy aliy sap tabatiy maan abaliy (99) vaal ri maarnadiy viyakitadiy duw takwak day mwiyir tinadiy God diki milaam. Aw li vaal yinadi duw nak diki vaal yidil mawul wapakida, aw day mwiy rakarak samasam tikinadiy dikik.” ");
INSERT INTO mle_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Atawa taakw nak likim apa kabaak tabatiy rinadiy. Liki saan nak jaaw yilik, agwa jaav kwurkila? Li lam wapatakakuw, liki wiy vayukwubagwukuw, li ata kwakiyin kwakiyaan tikina a sanak. ");
INSERT INTO mle_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","“Li a saan sitakirakuw, tipa duw takwawa gwalugwa duw takwak gaam sikiladiy yadakikik likik. Li ata wakiladiy, ‘Wunakil jaaw yil saan bwutaay sitakira-tuwaal. Alik gwur wunawa rakarak ada!’ ");
INSERT INTO mle_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Atawa God diki maaj kardadiy duw rakarak tikinadiy duw nikik di diki vaal yikwadadi mawul wapadik.” ");
INSERT INTO mle_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas maa ata wadidiy, “Duw nak di duwa nyidiy vitiy tad. ");
INSERT INTO mle_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","“Adi kwasada pika nyan dikidi asayik ata wadid, ‘Asaay, ginyir min kiyakimina, minadiy jaav wun nuwuk kwur-kituwadiy. Alik tikuw, wun wuna yaay kita kwurik.’ Dikidi asaay yaakiya wakuw, adiy dikidiy niki jaav niki jaav abir dikibir nyidiyik ata kajadidiy. ");
INSERT INTO mle_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ginyir nuwukadiy nyi yidaak, adi duw dikidi kwasada pika nyan dikidiy ababa jaav warapiy-didiy sanak. Adiy saan kwurkuw, di dikidi asaay diki wiy ata wapadil. Wapakuw, di nikidi sika tamiyaam ridi jaka tipaar yad. Yikuw, adi tipaam di dikidiy saan kip yakiyaki-didiy kupwarapa javik. ");
INSERT INTO mle_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Dikidiy miyawa saan kwusidaak, dikidi kwadidi jaka tip miyawa kamik tidiy. Aw dikidiy miyawa jaav kwusidaak, di kip kwaad. ");
INSERT INTO mle_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Atawa kwakuw, adi duw di ata yad adi tipa kidi sapakwa duwak yawiy kwurik. Adi sapakwa duw ata wayakidid diki kupwaar dikidiy bwalak van tidikikik. ");
INSERT INTO mle_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","“Dikik duw nakab kamnaagw maa kway. Alik tikuw, di kaam samasam yasikuw, di adiy bwal kidadiy kamnaagw kikir wukid diki yaal wapwurukwu-likik. ");
INSERT INTO mle_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","19","Atawa kwakuw, diki mawul wukin kariyakuw, di dikik ata waad, ‘Wun wunadi asaay dikidiy yawiy duw yarakara kwataay, mwiya samasama kamnaagw kikwanadiy. Aw wun kilim yarakara maa kwu. Wun kiyakidiwun kamik! Ay yaakiya, wun wunadi asayik yikidiwun. Yikuw, wun dikik ata wakituwaad, Asaay, wun vaal yidiwun minawa Godak. Alik tikuw, wun maa rav minadi nyan titak. Wun minadi yawiy duw kaytik tikidiwun minak.’ ");
INSERT INTO mle_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Atawa wukikuw, di ata rasikuw, sibinin yad dikidi asayik. Sikab yidi yabir yataay tidik, dikidi asaay ata dim vidid. Vikuw, diki mawul dikidi nyinik samasam wukikuw, dikik ata gipiyid. Yikuw, dim kalakwukuw, ata mwutamaam jipwudid. ");
INSERT INTO mle_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Dikidi nyan dikik ata wadid, ‘Asaay, wun vaal yidiwun Godawa minak. Alik tikuw, wun maa rav minadi nyan titak. Wun minadi yawiy duw kaytik tikidiwun minak.’ ");
INSERT INTO mle_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Aw dikid asaay dikidiy yawiy duwak wataydik, yadaak, wadidiy, ‘Wun kidi wunadi nyinim yakisuwtakak. Alik tikuw, gwur yikuw, wuna wiyaam rinadi viyakita wapwiy kwurkuw, kariyakuw, dim akwusuwtak! Ring diki tabaam takakuw, su akwusuwtak dikibir manim! ");
INSERT INTO mle_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","“‘Atawa kwurkuw, viyakita karuwka karuw badiy bulmakau kwurkuw, aviyasip. Viyasipagwur, nimadi bayaki kikipaat kinaak! ");
INSERT INTO mle_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","“‘Tayir kidi wunadi nyan kiyadi duw kitik maak pakwun tad. Aw kita di bwutaay sibinin yanaad.’ Wakuw wadik, day ata adi bayaki kikipaat kidaad.” ");
INSERT INTO mle_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Aw adi duw dikidi taay nyan mayim tikuw, sibinin yataay tikuw, wiyawa walibab kwurkuw, adi baagw dikidi pipiliy wukidid. ");
INSERT INTO mle_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","“Wukikuw, di yawiy duw nikik wataydik, yadik, ata bas sidid, ‘Agwa jaav kwurnadiy wiyaam?’ ");
INSERT INTO mle_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Dikik ata wadid, ‘Minadi nyamwus bwutaay sibinin yanaad. Alik tikuw, minadi asaay dikik rakarak tikuw, viyakita badiy bulmakau nak viyasipada.’ ");
INSERT INTO mle_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Aw di a maaj wukikuw, di yaal girakuw, wiyaar wulawulak kwasik yad. Alik tikuw, dikidi asaay wakwukuw dikidi nyinik, ata bas sidid wiyaar wuladikik. ");
INSERT INTO mle_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","30","“Aw di dikidi asayik ata wadid, ‘Min awuk! Nabiy samasam wun minak nimadi yawiy kwurtuwa. Wun minadiy majib lakwu-lakwub tikwanadiwun. Aw min wunak badiy meme nakab maa kwatay wunadiy kapa nyanugwawa kituwkikik. Aw kidi minadi nyan minadiy niki jaav niki jaav kip yakiyaki-didiy adiy yabim kwurkwur tikwanadiy takwak. Aw di sibinin yadik, min dikik viyakita karuwka karuw badiy bulmakau viyasipa-minaad!’ ");
INSERT INTO mle_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","32","“Dikidi asaay dikik ata wadid, ‘Wunadi nyan, min nyanyi wunawa kwakwanadimin. Kidiy wunadiy ababa jaav adiy minadiy-adiy. Aw minadi nyamwus tayir di yijibwud. Aw di kiyadi duw kaytik maak pakwukuw, tad. Aw di bwutaay sibinin yanaad nyanak. Alik tikuw, nyan bayaki kikipaat kan rakarak tinaak dikik.’” ");
INSERT INTO mle_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas dikidiy kalivadidiy duwak wadidiy, “Duw nak van tad saan samasam tidi duw dikidiy javik. Di ata wukidil dikidiy javik van tidi duw dikidiy saan kip yakiyaki-didiy. ");
INSERT INTO mle_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Atawa wukikuw, adi duwak wadik, yadik, ata wadid, ‘Wun bwutaay wukituwaal min wunadiy saan kip yakiyaki-minadiy. Aal mwiya maaj-al? Min wunadiy ababa jaav sanawa dinau nasikuw, lapa nyigaam sukwukuw, min wunak akaray. Kariyakuw, min ata kwusikidimin mina yawiyik.’ ");
INSERT INTO mle_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Adi sapakwa duw dikidiy javik van tidi duw di dikik ata waad, ‘Wunadi sapakwa duw wunaam adi kwasik yinaad wun diki yawiyim van titak. Agwa yawiy kwurkinadiwun? Wun ap maa ti adiy yaan mawiy vavak. Aw wun wap saynadiwun adiy nuwukadiy kipa duw takwak bas sisak kamnagwawa sanak wunak kwiydakik. ");
INSERT INTO mle_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“‘Wun kwurkituwa yawiy bwu lakwutuwa. Wun kitawa kwurkuw, nuwukadiy duw day wunadiy kapa duw tikuw, day rakarak tikidiy wun dayadiy wiyaar wulatuwkik.’ ");
INSERT INTO mle_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","6","“Atawa wukikuw, ababa duw day dinau tidiy dikidi sapakwa duwak di dayak wadik, dikik yadaak, di taay duwak ata wadid, ‘Min dinau kas wunadi sapakwa duwaam timinadiy?’ Adi duw dikik, ‘Wun aliv wel 44 dram duwamiy nak kwurtuwdiy.’ Wakuw wadik, adi van tidi duw dikik ata wadid, ‘Mina dinau sukwumina lapa nyig kika. Daan rikuw, yabiyib mina dinau awarapiy. Min dram tabatiy asukw.’ ");
INSERT INTO mle_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Di nikidi duwak ata bas sidid, ‘Min dinau kas timinadiy?’ Adi duw dikik ata wadid, ‘Bek kabasik 1000.’ Adi van tidi duw ata wadid, ‘Mina dinau sukwumina lapa nyig kika. Daan rikuw, yabiyib mina dinau awarapiy. Min bek 800 asukw.’ ");
INSERT INTO mle_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Adi sapakwa duw di lakwukuw dikidiy javik van tidi duw di adiy nuwukadiy duwak sugwiyaan kwurdidiy day dikik rakarak tidakikik, di ata waad, ‘Ka! Kidi kupwarapa duw viyakita yawiy kwurkwanaad di diki sipak viyakit kwurdakik!’ Kupwak wuki-kwanadiy duw day nima yawiy kwurkwanadiy nuwukadiy duw takwak sugwiyaan kwurik day dayadiy kapa sipak wukikuw. Day God dikidiy nyanugwaam kakil-kwadanadiy atampika yawiyik.” ");
INSERT INTO mle_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Aw gwur viyakita yawiy akwur gwuradiy sanawa kidi kupwa kidiy niki jaav niki javir. Nuwukadiy duw takwak sugwiyaan kwurgwur, day gwuradiy kapa nyanugw tikidiy. Atawa kwurgwurik, ginyir gwur kiyakuw, adawur tipaar wulakigwura, alim adiy duw taakw gwurak wayapiy sikidanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Adiy duw taakw day kwasa yawiyik yarakara kwurkwanadiy, ginyir day nima yawiy kwurkidana, a yawiy ab yarakara kwurkidana. Aw adiy duw taakw day kwasa yawiyik jawjaay kwurkwanadiy, ginyir day nima yawiy kwurkidana, a yawiy ab jawjaay kwurkidana. ");
INSERT INTO mle_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","“Aw li gwur kidi kupwa kidiy javir jawjaaya yawiy kwurkigwura, God gwurak ata ata dikidiy mwiyir tikwanadiy jaav kwiykida dayaam van tigwurkikik? ");
INSERT INTO mle_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","“Kidi kupwa kidiy jaav day gwur gwuradiy jaav maa, God dikidiy-adiy. Aw li adiy kupwa kidiy javiwa jawjaay kwurkigwura, ata ata God gwurak nuwukadiy jaav kwiykidadiy day gwuradiy tidakikik nyanyi nyanyi? ");
INSERT INTO mle_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Yawiy duw nak duw vitiyak yawiy kwurkwur a maa rav. Di nikidi duwak mawul yikuw, nikidi duwak maa wakinaad. Di nikidi duwak viyakita yawiy kwurkuw, nikidi duwak kupwarapa yawiy kwurkidaad. Atampik, gwur Godawa sanak nakamwiyib yawiy kwurkwur a maa rav.” ");
INSERT INTO mle_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aw adiy Parasiy Jisas wadidiy ababa maaj wukikuw, day dikik rik kwurtaay, wajidaad, dayadiy mawul sanak yikwadanalik tikuw. ");
INSERT INTO mle_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisas dayak ata wadidiy, “Gwur viyakita yawiy kwurkwanadiygwur duw taakw dayadiy mwutamaam day ‘Kidiy mwiya viyakita duw-adiy,’ wadakikik gwurak. Aw God gwuradiy mawul vikuw, di bwutaay lakwudadiy gwuradiy kwurgwuradiy yawiy dayadiy maaw. Alik di maa wanaad gwurak. ");
INSERT INTO mle_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mawsis kidi kupwaam kwadil nyi aw yaan Jon baptais kwiydi duw kwadil nyi, ababa duw taakw day Mawsis sukwudil lo wawa ababa God diki maaj wasapwiydiy duw dayadiy majiwa adiy majib wukidiy. Aw adiy lo dayaam van tidadiy. Aw kita wun duw takwak wasapwiykuw, God dayak van tinadi sukw, ababa duw taakw dikidi gwalugwur wulawulak nima yawiy kwurkwanadiy. ");
INSERT INTO mle_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Adawur tinadi tubwawa kidi kupw kwusikinabir aw God dikidiy miyawa lo kwas maa. ");
INSERT INTO mle_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Aw li duw nak diki taakw wapakuw, niki taakw kirakida, di vaal yikinaad likim. Aw li duw nak dikidi duw diki wapadil taakw kirakida, di a takwaam vaal yikinaad.” ");
INSERT INTO mle_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Duw nak, di saan tidi duw, di viyakita wapwiy di kwusuwtaay, nyanyi bayaki kikipaat kad. ");
INSERT INTO mle_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","“Aw nuwukadiy duw day saal yidi duw, dikidi si Lasaras, dim yatataay, adi saan samasam tidi duw dikidi kabaka yaripaam tidi wiyigawa takayi-kwadaad. Lasaras diki miyawa sipaam kwiyaak pwusidiy. As yitaykikib, dikidiy kwiyakim biyasi-dadiy. Lasaras adi duw dikidiy kupwaam vakirdiy kavisa kipaat kwurin kikir. ");
INSERT INTO mle_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ginyir adi saal yidi duw kiyadik, God diki maaj kardadiy duw dakuw, yataan karaydaad Aparamawa tidikikik. Aw adi saan samasam tidi duw kiyadik, nuwukadiy duw kawamiyaam takadaad. ");
INSERT INTO mle_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Adi saan samasam tidi duw kiyakwanadiy vaal yidiy duw taakw dayadi tipaam tikuw, kagil samasam diki sipaam yilik, kituw vikuw sikaam Aparam, Lasaras dikiwa walibab tidik, vidibir. ");
INSERT INTO mle_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Atawa vikuw, di Aparamak ata gaam sidid, ‘Wunadi taay waraga duw, wun kidi yiyaam tikuw, kagil samasam wuna sipaam yina! Alik tikuw, min wunak wukikuw, min Lasaras wunak awayak diki taab guwaam takakuw, wuna tikalaam takadikik!’ ");
INSERT INTO mle_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Aw Aparam dikik ata wadid, ‘Wunadi nyan, min awuk. Min adi kupwaam kwaminil, min minadiy viyakita jaav abab kwurminidiy. Aw Lasaras di maa. Kupwarapa javada kwurdidiy. Aw kita di viyakita mwiy kilim kwanaad. Aw min alim jawjaay kwanadimin. ");
INSERT INTO mle_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“‘Nimadi yaan nyana nyidim rinaad. Alik tikuw, kilim kwanadiy duw taakw day gwuradi tipaar yikir, yi yaab maa. Aw gwuradi tipaam kwanadiy duw taakw day kilir yakir, atampik ya yaab maa.’ ");
INSERT INTO mle_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Di Aparamak ata wadid, ‘Wunadi asaay wiyaam wunadiy nyamwus mamugw tabab kwanadiy. Min Lasaras dayak awayak di dayak yikuw, kidi wun kwatuwadi tipak yarik yikwaad aw day kilir yakik-nadiy.’ ");
INSERT INTO mle_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Aparam ata wadid, ‘Atawa maa. Dayaam Mawsisawa God diki maaj wasapwiydiy duw dayadiy maaj rinadiy. Day adiy duw dayadiy maaj wukikwadiy.’ ");
INSERT INTO mle_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Aw adi duw Aparamak wadid, ‘Wunadi taay waraga duw, adiy maaj maa rav. Aw li kiyadi duw rasikuw, dayak yikuw, wakida, aal rivikina. Aw day bwunak dayadiy valik bwan kwiykidiy.’ ");
INSERT INTO mle_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aparam dikik ata wadid, ‘Aw li day Mawsisawa God diki maaj wasapwiydiy duw dayadiy majib wak maarkidana, adi kiyakuw rasikinadi duw diki maaj ab wak maa.’” ");
INSERT INTO mle_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Niki jaav niki jaav duw takwaam yakuw, mwugiydaak, adiy duw taakw ata vaal yikidiy. Aw adiy jaav mwugiykinadi duw, mwiya kupwaraap tikina dikik. ");
INSERT INTO mle_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","“Aw li duw nak yakuw, kidiy ap ti maarnadiy duw takwaam mwugiydik aw daya duw nak bwan wunak kwiykida, adi vaal yidakikik mwugiydi duw taay diki kwaliyapaam nuwukadiy duw nimadi kabaak tuwtakakuw, guwaar yakidaak kiyakida, aal viyakita. God mwiya nimadi vaat dikim ginyir kwiyik-daad. ");
INSERT INTO mle_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Aw li duw vaal yidik, dikik gwur diki yidil vaal awasapwiy. Aw li di bwan kwiykida diki valik, gwur ata diki vaal asipwutiy. ");
INSERT INTO mle_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“Aw li nyi nak gwuraam di jaab abitiy kaam ab vaal yikuw, gwurak yaan wakida, ‘Wun wuna minaam yituwal valik samasam wukinadiwun, alik wuna vaal sipwutiy-minakik,’ wakuw wadik, gwur diki yidil vaal asipwutiy.” ");
INSERT INTO mle_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisas dikidiy wayakidiy duw Yitaypika Duw Jisasak ata wadaad, “Min nyanak sugwiyaan akwur nyan minak mwiyir wukijibir tibakikik.” ");
INSERT INTO mle_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yitaypika Duw Jisas dayak ata wadidiy, “Aw li gwur kwasa mwiy, sika mastat kitik, wunak wukijibir tikigwura, gwur bwunak kidi nimadi miyak, ‘Min mina kap gwakuw, solwara am daan ada!’ wakuw, adi miy gwura majib ata wukikinaad.” ");
INSERT INTO mle_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","“Aw li gwuraam duw nak minadi yawiy duw mina mayim yawiy kwurkuw, ay minadiy sipsip ak van tikuw, giraab tilik, diki yawiy kwusidik, wiyaar wuladik, min dikik ata wakiminaad, ‘Min yakuw, minadiy kamnaagw ak’? Min samab atawa wu maa dikik. Aw min wakiminaad, ‘Min wunadiy kamnaagw akwulaapw. Niki wapwiy kwusuwkuw, adiy kamnagwuwa guw wunak akaray. Wun kan napatuwik, min ata nibwu gany kikidimin.’ ");
INSERT INTO mle_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Adi yawiy duw mina majib wukikuw, min dikik wayapiy sikiminaad kwurdil yawiyik, ay? Min samab atawa wu maa. ");
INSERT INTO mle_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Gwurabab atampik yawiy akwur. God gwurak kwiydadiy yawiy kwurkuw, gwur aw, ‘Nyan kipa yawiy duw-adiyan. Nyanak kwiydidiy yawiyda kwurbanadiy.’” ");
INSERT INTO mle_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jiruwsalimaar yitaay tidik, dikidi yididi yaab abir tamiy Samariyawa Galiliy awarwa awarwa waraar yad. ");
INSERT INTO mle_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Jisas tip nikir wulak tiyadik, lepa duw tabatiy dikik yadiy. Day sikaam tikuw, Jisasak gaam sidaad, “Jisas! Sapakwa Duw! Min nyanak awuk!” ");
INSERT INTO mle_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas dayaam vikuw, ata wadidiy, “Gwur maay. Yikuw, gwuradiy sip pris ak asimak day vidakikik bwu sipwutiyin tinadiy wakuw.” Day diki majib wukikuw, adiy pris ak yitaay tidaak, dayadiy sip ata sipwutiydiy. ");
INSERT INTO mle_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aw dayaam duw nak diki sip sipwutiyin tilik vikuw, Jisasak sibinin yakuw, Godak wayapiy sidid. ");
INSERT INTO mle_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Di Jisas dikibir manwa vakirkuw, ata Jisasak wayapiy sidid. Aw adi duw di Samariya tamiya kidi duw-ad. ");
INSERT INTO mle_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Jisas walibab tidiy duw takwak ata wadidiy, “Wun duw tabatiy sipwutiy-tuwadiy. Aw adiy nuwukadiy abaliy akim tinadiy? Agwa javik tikuw, kidi niki tamiya kidi duwadika sibinin yanaad Godak wayapiy sikir.” ");
INSERT INTO mle_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jisas adi duwak ata wadid, “Min rapikuw, maay. Min wunak wukijibir timinalik, alik min bwutaay miyawa sipwutiyin tinadimin.” ");
INSERT INTO mle_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Nuwukadiy Parasiy Jisasak bas sidaad, “Akasikir God yakinaad duw takwak van tikir?” Jisas dayak ata wadidiy, “God adi jaav gwurak simaak maa gwur lakwu-gwurkik. God kidi yawiy bwutaay bas kwurdid gwuradiy nyidim. Alik tikuw, ginyir duw taakw wu maa, ‘Kidaanada kilim kwanaad!’ Ay ‘Adaanada alim kwanaad!’ waan.” ");
INSERT INTO mle_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Ginyir gwuradiy mawul yikidiy wun, duw taakw dayadi Mwaam, gwurawa nyi nak tituwkikik. Aw atawa ti maa. ");
INSERT INTO mle_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Day gwurak wakidanadiygwurik, ‘Gwur av! Kinaay alayim kwanaad!’ Ay, ‘Gwur av! Ki daanada kilim kwanaad!’ Aw gwur yikuw, dayadiy kwukib gipayi-tikwa. ");
INSERT INTO mle_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","“Aw wun sibinin yakituwa, gwur a javik mawul vitiy katiy ti maa. Adi wulik miyawa tubwaam kariya-kwada pik kariyakida, duw taakw dayadi Mwaam ata yakinaad. Alik tikuw, wun atawa sibinin yatuwik, miyawa duw taakw a javik mwiyir lakwukidiy. ");
INSERT INTO mle_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","26","“Aw taay kita kwanadiy duw taakw day dikik bwan kwiykuw, diki sipaam kagil samasam kwurkinaad. Wun kidi kupwaar sibinin dakituwa nyi kidi kupwa kidiy duw taakw tayir Nawa kwadil nyi adiy duw taakw kwadaal pik atampik kwakidiy. ");
INSERT INTO mle_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","“Adiy nyaam ababa duw taakw kamnaagw kitaay, guw kitaay, duw takwaam kirataay, adiy jaav kwurbagwudiy yin Nawa dikidi nimadi jabira wiyaar wuladil nyab. A nyaam nimadi guw warkuw, miyawa duw taakw guw kikuw, kiyapakwudiy. ");
INSERT INTO mle_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Atampik Aparam dikidi nyamwus dikidi nyan, Lat, kwadil nyaam. Ababa duw taakw kikipaat kitaay, niki jaav niki jaav yapiytaay, niki jaav niki jaav mayim sitaay, wiy kwurtaay, atawa kwurbagwudiy. ");
INSERT INTO mle_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","“Lat, Satam tip wapadil nyaam yiywa yaan bwiyadiy kabaak tubwaam waal kaytik vakirkuw, ababa duw taakw kiyayakidiy. ");
INSERT INTO mle_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Atampik tikina duw taakw dayadi Mwaam maykaar wakwukida nyaam. A sikir duw taakw day laakw maarkidana Jisas diki sibinin yakida nyi walibab tikina, day kip dayadiy kapa yawiy kwurkidiy. ");
INSERT INTO mle_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Duw aluwur maka kwaal wiyaam kwakuw, dadiba niki jaav niki jaav wulaan kwurik. Mayim kwakinadi duw di sibinin yidiba dikidiy jaav kwurik. ");
INSERT INTO mle_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","“Gwur Lat diki taakw kwurlil javik awuk. Li liki tipaar tipatiyakwukuw kitaay vikuw, ata kiyaal. ");
INSERT INTO mle_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Li wunak yawiy kwurkuw, aw wuna danik wakuw kiyakinadiy, adiy nyanyi nyanyi wunawa kwaya-kinadiy. Aw li day dayadiy sipa danik wukikuw kiyakidiy, adiy nyanyi nyanyi kupwaraap tikidiy. ");
INSERT INTO mle_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","36","“Wun gwurak watuwadiygwurik, wun sibinin yakituwa nyaam duw vitiy wiy nikim si kwabir, nak kwurkuw, aw nak wapakituwaad. Taakw vitiy bir nakamwiyig kwaan sukwulik yikinabir. Aw wun yakuw, taakw nak kwurkituwaal. Aw niki taakw wapatuwik, kip kwakina. Duw vitiy nakamwiyib mayim yawiy kwurkinabir. Aw wun yakuw, duw nak kwurkituwaad. Aw nikidi duw wapatuwik, kip kwakinaad.” ");
INSERT INTO mle_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jisas adiy maaj wakuw, dikidiy kalivadidiy duw dikik ata bas sidaad, “Yitaypika Duw, akim kidi jaav tikinaad?” Jisas dayak ata wadidiy, “Kiyanadiy jaav ridana tamiyaar gawiy adiy amwiy kikir dakwanadiy. Atampik kidi kupw kwusik tikida nyi wun yabiyib dakinadiwun adiy wapakituwadiy duw takwaam kotiy ik.” ");
INSERT INTO mle_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas adiy duw takwak waya maaj kitika majir wadidiy. Di dayak kalivak day kip Godak niki jaav niki javik sida siyidiy aw day dayadiy sip sakwiy-dabaal. Day atawa bas sidaak, God adiy jaav dayak kwiykidadiy. ");
INSERT INTO mle_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Di dayak ata wadidiy, “Tip nikim jas nak kwaad. Adi jas di Godak akis yagayikwaad. Aw di duw takwak akis wukiyikwaad. ");
INSERT INTO mle_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“A tipaam kwaal tawtakw kwaal taakw nyanyi adi jas ak yataay, dikik wayikwalid, ‘Min wunaam jawjaay kwurnadi duw diki vaal alakatiy!’ ");
INSERT INTO mle_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","“Bap samasam adi jas kwasik yad likim sugwiyaan kwurkwurik. Aw ginyir ata di dikik waad, ‘Wun akis Godak yagakwanadiwun. Aw wun duw takwak ab akis wukikwanadiwun. Aw li ki tawtakw kwana taakw li atampik nyanyi wunak yataay, maaj bwulataay, bwulakikib, kwam tikidiwun. Alik tikuw, wuna sip sakwiyna. Wun jaaw liki maaj yabiyib lakatiy-kituwa!’” ");
INSERT INTO mle_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jisas dayak ata wadidiy, “Gwur adi kupwarapa jas diki maaj awuk. ");
INSERT INTO mle_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","“Aw li God dikidiy duw taakw day dikik bas sida sikidana di dayak sugwiyaan kwurdikik, di yabiyib sugwiyaan kwurkidadiy. Aw wun, duw taakw dayadi Mwaam, sibinin yakituwa kidi kupwaar, wunak wukijibir tikinadiy duw taakw sitakira-kituwadiy, ay maa?” ");
INSERT INTO mle_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisas di lakwudil nuwukadiy duw taakw day dayadiy mawulaar wukidiy, ‘Wun viyakit tinadiwun God diki milaam.’ Wakuw, dayadiy bwan kwiydadiy nuwukadiy duw takwak. Alik ki waya maaj kitika maaj dayak wadidiy. ");
INSERT INTO mle_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Di dayak wadidiy, “Duw vitiy God dikidi wiyaar wulabir Godak maaj bwulak. Nikidi duw Parasiy-ad, aw nikidi duw takis kwurkwanadi duw-ad. ");
INSERT INTO mle_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","12","“Adi Parasiy kap kwasa sikaam tikuw, Godak kitawa maaj bwulaad, ‘Ababa nuwukadiy duw day suwaal kwurtaay, nuwukadiy duw taakw dayadiy jaav kwurik, day kupwarapa yawiy kwurkwanadiy, day vaal yikwanadiy nuwukadiy takwaam. Alik tikuw, wun wayapiy sinadiwun minak wun dayadiy kwurkwadanadiy kupwarapa yawiy pik akis kwurkwanadiwun. Wun kidi kupwarapa takis saan kwurkwanadi duw kaytik maa. Alik tikuw, wun minak wayapiy sinadiwun. Nyi vitiy vitiy ababa wik wun kamnaagw akis kikwanadiwun gaba maaj minak sukwuk titaay. Wunadiy ababa kwurkwatuwadiy saan ab tabatiy sikuw, nak minak kwatiya-kwatuwa.’” ");
INSERT INTO mle_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Aw adi takis saan kwurkwanadi duw sikaam tikuw, di wap saykuw, samab maa adawur tipaar kituw vi. Di diki mapiyim viyataay, ata waad, ‘God, wun kupwarapa vaal yikwanadi duw-adiwun. Alik min wunak awuk!’” ");
INSERT INTO mle_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jisas adiy duw takwak ata wadidiy, “Wun gwurak watuwadiygwurik kidi duw, adi Parasiy maa, di yad diki wiyaar God dikimilaam mwiyir tikuw. Aw adiy duw taakw day dayadiy sipak wukikuw, day yitaypik tikir wakuw, adiy duw taakw God tasakwudik, ginyir yisadapik tikidiy. Aw adiy duw taakw day dayadiy sipak wak maarkida yitaypik tikir, ginyir God tasakwudik, adiy duw taakw yitaypik tikidiy.” ");
INSERT INTO mle_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nuwukadiy duw taakw dayadiy nyanugw kariyadadiy Jisasak dayaam taab takakuw, sukwasukw kwurdikik. Aw Jisas dikidiy kalivadidiy duw a jaav vikuw, maa wadiy dayak. ");
INSERT INTO mle_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Nyanugw wunak yakwadiy. Watipi-tikwa! God dikidi gwalugw kitampika nyanugw dayakid-ad. ");
INSERT INTO mle_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Mwiya maaj watuwadiygwurik. Sikadadiy rakarak ti maarkidiy God dayaam van tidikikik kwasa nyan dikik rakarak tikwadana pik, adiy duw rav maa God dikidi gwalugwur varavarak.” ");
INSERT INTO mle_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juw dayadi yitaypika duw nak Jisasak ata bas sidid, “Viyakita kalivanadi duw, agwa jaav wun kwurkuw, nabiy nabiy kwakinadiwun?” ");
INSERT INTO mle_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisas ata wadid, “Agwa javik wunak ‘Viyakit-adimin’ wanadimin? Godadika mwiya viyakit tikwanaad. Nuwukadiy maa. Duw taakw atawa Godak sikiy-kwadanaad. Aw agwa javik tikuw, min atawa viyakit waan sikiy-minadiwun? ");
INSERT INTO mle_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“God diki maaj bwu lakwumina, ‘Duw nikidi duw takwaam vaal yi-tikwa. Duw viyasipa-tikwa. Luwkuw kwur-tikwa. Gwiyip kwur maaj wa-tikwa. Amaay asaay biraki majib awuk.’” ");
INSERT INTO mle_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Di Jisasak ata wadid, “Wun kwasadi nyan tituwarib, wun adiy majib wukidiwun.” ");
INSERT INTO mle_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas diki maaj wukikuw, ata wadid, “Niki jaav kip rina. Minadiy ababa jaav nuwukadiy duw takwak yapiykuw, adiy saan akwiy saal yinadiy duw takwak. Atawa kwurkimina, adawur tipaam samasama jaav kwurkiminadiy. Atawa kwurkuw, wuna kwukib may.” ");
INSERT INTO mle_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aw di a maaj wukikuw, di samasam wukid dikidiy niki jaav niki javik. Di kwasik yad adiy jaav wapa-wapak. Wukikuw, diki mawul pakwul. ");
INSERT INTO mle_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas di vikuw adi duw diki mawul pakwul, dikidiy kalivadidiy duwak ata wadidiy, “Aal mwiya nima yawiya, aw samasama jaav tinadi duw God dikidi gwalugwur varavarak. ");
INSERT INTO mle_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","“Gwur ki maaj wakwagwura: ‘Jaay tupwur kamil kwusawula-kwusawulak a nima yawiy-al.’ Aw wun watuwadiygwurik samasama jaav tinadi duw God dikidi gwalugwur varavarak, dayadiy niki jaav niki javiwa sanak wukikuw, aal mwiya nima yawiya.” ");
INSERT INTO mle_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aw abab diki maaj wukikuw, ata wadaad, “Atawa tikuw, atata atata duw taakw God dikidi gwalugwur varakinadiy?” ");
INSERT INTO mle_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aw Jisas dayak ata wadidiy, “Duw maa rav. Aw God rivinaad ababa jaav kwurkwurik.” ");
INSERT INTO mle_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita ata wadid Jisasak, “Awuk! Nyan ababa jaav bwutaay wapakuw, mina kwukib yanadiyan.” ");
INSERT INTO mle_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jisas dayak ata wadidiy, “Mwiya maaj gwurak watuwadiygwurik, abab day wunak wukijibir tikuw, alik dayadiy wiy, taakw, nyamwus mwaam, amaay asaay, nyanugw kip wapakidadiy wuna danik tikuw, God adiy duw takwak samasam nuwukadiy kwiykidadiy kidi kupwaam kwadaak. Di wadik, day nabiy yara kwakidanadiy adawur tipaam.” ");
INSERT INTO mle_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas dikidiy tabatiy maan vitiya duw malaar karaykuw, ata wadidiy, “Gwur awuk. Nyan Jiruwsalimaar warkibana. Warkuw, adiy ababa jaav tayir God diki maaj wasapwiydiy duw diki lapa nyigaam sukwudadiy duw taakw dayadi Mwamik ata mwiya mwiyaba maaj tikidiy. ");
INSERT INTO mle_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","“Alim adiy sapakwa nyanugw pris awa God diki lo kalivanadiy duw day wun niki jaka tipa kidiy bapa duwak kwiykidanadiwun. Kwiydaak, day wunak wajibay-kidanadiwun. Wunaam jawjaay kwurkuw, likasip sataka-kidanadiwun. Wunaam ramiy tinadi miyaar viya-kidanadiwun. Viyaan napakuw, wunaam ata viyasipadaak, kiyakinadiwun. Ginyir nyi mugwul yidaak, wun ata rapikinadiwun.” ");
INSERT INTO mle_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aw day Jisas wadidiy maaj dayadiy maaw maa laakw. God a maaj liki maaw maaj yipakwudil dayak. Alik tikuw, day maa laakw Jisas wadidiy maaj dayadiy maaw. ");
INSERT INTO mle_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas di Jarikaw tipaar walibab yataay tidik, mil kwakidi duw nak di mala yabim ritaay, yin yaan tidiy duw takwak bas sididiy day saan dikik kwiydakik. ");
INSERT INTO mle_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Samasama duw taakw dayadiy pipiliy wukikuw, di bas sididiy, “Agwa jaav kwurnadiygwurik?” ");
INSERT INTO mle_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Day ata wadaad, “Jisas Nasarit tipa kid, aad yanaad.” ");
INSERT INTO mle_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Di Jisasak nimadib ata gaam sidid, “Jisas, nyanadiy warag dayadi yitaypika duw Davit dikidi gwalugwa duw-adimin. God dikidi Tasakwudidi Duw-adimin. Min wunak awuk!” ");
INSERT INTO mle_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Adiy diki mwutamaam tidiy duw taakw dikik ata wadaad, “Min kaygan ada!” Aw di ata mwiya nimadib gaam sad, “Davit dikidi gwalugwa duw-adimin, God dikidi Tasakwudidi Duw-adimin, min wunak awuk!” ");
INSERT INTO mle_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Jisas yakuw, tawtaykuw, ata duw takwak wadidiy, “Adi duw wunak akaray.” Di walibab yadik, Jisas ata bas sidid, “Min agwa jaav kwurtuwkik minaam?” Adi mil kwakidi duw Jisasak ata wadid, “Yitaypika Duw, wunabir mil sipwutiy-minkik.” ");
INSERT INTO mle_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aw Jisas dikik ata wadid, “Minabir mil mwiyir vikiminabir. Min wunak wukijibir tikuw, alik sipwutiyin tinadimin.” ");
INSERT INTO mle_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jayib nak dikibir mil mwiyir vidibir. Vikuw, Jisas kwukib yikuw, Godak wayapiy sidid. Aw ababa duw taakw ab a jaav vikuw, Godak wayapiy sidaad. ");
INSERT INTO mle_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas Jarikaw tipaar wulakuw, di yabirib yirib yad. ");
INSERT INTO mle_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Saan samasam tidi duw nak, dikidi si Sakiyas, alim kwaad. Di adiy takis saan kwurdiy duw dayadi yitaypika duw tad. ");
INSERT INTO mle_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Di ata Jisasaam vikir kwurdil, di maa rav. Samasama duw taakw alim vagaluwdiy. Aw di pakapav tidi duw tikuw, Jisasaam maa vi. ");
INSERT INTO mle_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Alik tikuw, di tayir gipiyid. Yikuw, mala Jisas yidil yabim tidi miyaar warid Jisasaam vikir. ");
INSERT INTO mle_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas walibab tikuw, kituw Sakiyasaam vikuw, wadid, “Min yabiyib adiyid. Wun nibwul mina wiyaam kwakinadiwun.” ");
INSERT INTO mle_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiyas yapwur yapwur dakuw, di rakarak tikuw, Jisasak wayapiy sidid diki wiyaar yidikikik. ");
INSERT INTO mle_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ababa duw taakw a jaav vikuw, day yaal girakuw, day dayak wadiy, “Kidi duw a daanada vaal yikwanadi duw wiyaam kwanaad!” ");
INSERT INTO mle_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aw Sakiyas dayadiy mwutamaam tikuw, Yitaypika Duw Jisasak ata wadid, “Yitaypika Duw, min awuk! Wunadiy ababa jaav kajakuw, tabik saal yinadiy duw takwak kwiykituwadiy! Aw li wun nuwukadiy duw taakw suwaal kwurtuwa dayadiy sanawa niki jaav niki jaav kwurik yaakiya, wun dayadiy sanawa jaav jaab aliy sibinin kwiy-kituwadiy.” ");
INSERT INTO mle_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisas adiy duw takwak wadidiy adi duwak, “Nibwul God nyigil-dadiy kidi Aparam dikidi gwalugwa duwawa dikidiy wiya kidiy duw taakw. ");
INSERT INTO mle_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","“Wun, duw taakw dayadi Mwaam, kidi kupwaar datuwil kawaam kwanadiy duw taakw sitakirakuw, dayaam nyigilkuw, God dikidi gwalugwur kapirak.” ");
INSERT INTO mle_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisas Jiruwsalimaar warik. Alik tikuw, duw taakw wukidiy God dayaam van tikidadi nyi ada walibab tad. Alik tikuw, day Jisas wadil maaj wukitaay tidaak, di ki waya maaj kitika maaj dayak ata wadil. ");
INSERT INTO mle_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aw di dayak wadidiy, “Sapakwa duw nak sikaam tidi jaka tipaar yad day dim yitaypika duw tasakwudaak, diki tipaar sibinin yadikikik. ");
INSERT INTO mle_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Taay di yikir tikuw, dikidiy tabatiy yawiy duwak wadik, yadaak, di ata K20 dayak nakanak nakanak kwiydidiy. Kwiykuw, di ata wadidiy, ‘Gwur kidiy sanaar yawiy kwurkuw, nuwukadiy saan akwur.’ ");
INSERT INTO mle_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Adi duw diki tipa kidiy duw taakw day maa wadiy dikik. Alik tikuw, day duw wayakidadiy dikidi yididi jaka tipaar wadakikik, ‘Nyan kwasik yinadiyan kidi duw nyanadi van tikinadi duw titak nyanak.’ ");
INSERT INTO mle_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Aw adi sapakwa duw yitaypika duw tikuw, sibinin yakuw, adiy saan kwiydidiy yawiy duwak gaam sididiy day yadakikik dikik. Aw di lakwuk adiy kwiydidiy sanaar kwurdadiy yawiyik. ");
INSERT INTO mle_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Taay yawiy duw yakuw, wadid, ‘Yitaypika duw, min wunak K20 kwiy-minidiy. Aw wunadiy sanaar yawiy kwurkuw, nuwukadiy saan kwurtuwdiy. Alik min kidiy K200 kidiyay rinadiy.’ ");
INSERT INTO mle_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Dikidi yitaypika duw wukikuw, dikik ata wadid, ‘Min viyakita yawiy kwurnadimin. Min kwasa javik yarakara van tidimin. Alik wun tasakwu-tuwadimin tip tabatiyak van timinkikik.’ ");
INSERT INTO mle_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nikidi yawiy duw yakuw, wadid, ‘Yitaypika duw, min wunak K20 kwiy-minidiy. Aw wun adiy sanaar yawiy kwurkuw, nuwukadiy saan kwurtuwdiy. Alik min kidiy K100 kidiyay rinadiy.’ ");
INSERT INTO mle_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Dikidi yitaypika duw ata wadid, ‘Wun tasakwu-tuwadimin tip tababak van timinkikik.’ ");
INSERT INTO mle_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Aw nikidi yawiy duw yakuw, wadid, ‘Yitaypika duw, min minadiy K20 kidiyay rinadiy. Wun adiy saan wapwiyim yipakwu-tuwik, ridiy. Wun bwutaay lakwutuwa min wasap wasap tikwanadi duw-adimin. Min nuwukadiy duw taakw dayadiy jaav kip kwur-kwanadimin. Aw nuwukadiy duw taakw kadiy mayim sidaak, min dayadiy mwiy kwur-kwaminadiy. Alik wun yagadiwun minak.’ ");
INSERT INTO mle_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","“Adi yitaypika duw dikik ata wadid, ‘Min kupwarapa yawiy duw-adimin! Wun min minadiy waminadiy majir kotiy-kituwadimin. Min lakwumina wun wasap wasap tikwanadi duw-adiwun titaay, nuwukadiy duw taakw dayadiy jaav kip kwur-kwatuwadiy, aw nuwukadiy duw taakw mayim sikwadanadiy taba jaav kip kwur-kwatuwadiy. Agwa javik tikuw, min atawa lakwun tikuw, wunadiy saan beng taka maarminidiy? Aw li min wunadiy saan beng takak-mina, aw kita nuwukadiy saan ab kwurik-tuwadiy.’ ");
INSERT INTO mle_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Walibab tidiy duwak ata wadidiy, ‘Kidi duw kariyadadiy K20 kwurkuw, adi K200 kariyanadi yawiy duwak akwiy.’ ");
INSERT INTO mle_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Aw day dikik ata wadaad, ‘Yitaypika duw, kidi duw di K200 bwutaay kwurdadiy!’ ");
INSERT INTO mle_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","27","“‘Adiy duw taakw day samasama jaav rikuw, adiy javir viyakita yawiy kwurkuw, ginyir nuwukadiy kwurkidanadiy. Mwiya samasam kwurkidanadiy. Aw adiy saal yinadiy duw taakw, day viyakita yawiy kwar maarkuw dayadiy kwasadiy javir, ginyir dayadiy kwasadiy jaav miyawa kwurkituwadiy. Aw adiy duw day kwasik yinadiy wun dayaam van tituwkikik, wunak akaray. Kariyakuw, wuna mwutamaam viyasipagwur, kiyakidiy.’” ");
INSERT INTO mle_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas ki maaj waan napakuw, di ata yad dikidiy kalivadidiy duw daya tayir Jiruwsalimaar. ");
INSERT INTO mle_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Di Bitpasawa Bitaniy abir Aliv wadana nibwukawa ribir tip walibab yikuw, di dikibir kalivadibir duw vitiy wayakidibir. ");
INSERT INTO mle_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Di birakik ata wadibir, “Alaay tipaar maay! Yikuw, tipaar wulakuw, donki alim sitakira-kibiraad. Yaav tuwtakada miyaam tinaad. Badiy donki-ad. Dim duw maa ri nibway. Raliykuw, kiril kwurin akaray. ");
INSERT INTO mle_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“Aw li duw taakw birak bas sikidiy, ‘Agwa javik adi donki raliy-biraad?’ wakuw, bir dayak aw, ‘Nyanadi Yitaypika Duw di yawiy kwurik dim.’” ");
INSERT INTO mle_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wayakidibir duw yikuw, adi donki vibirid Jisas wadil pik. ");
INSERT INTO mle_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Adi donki dikidi yaav raliytaay tibirik, donki asaay duw atawa vikuw, wadabir, “Agwa javik wadi donki raliy-biraad?” ");
INSERT INTO mle_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aw bir ata wabiridiy, “Nyanadiy Yitaypika Duw yawiy kwurik dim wadalik.” ");
INSERT INTO mle_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Adiy donki asaay duw yaakiya wadaak, bir adi donki Jisasak karaykuw, birikidiy wapwiy donki bwunim takakuw, Jisas apiy wapwiyim takabirid. ");
INSERT INTO mle_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Di apiy donki saay yidik, duw taakw day dayadiy wapwiy yabim takadadiy gilabadiy kaytik di dayadiy apiyir yidikikik. ");
INSERT INTO mle_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jisas di Jiruwsalimawa walibab tikuw, Aliv nibwukir yaab dadidi tamiyaam, dikidiy samasama kalivadidiy duw taakw ata rakarak tikuw, day nimadib wayapiy sidiy Godak vidadiy nimadiy yawiyik. ");
INSERT INTO mle_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Day wadiy, “God sukwasukw kwurkwaad kidi dikidi saam yanadi Yitaypika Duwak! Adawur tipaam kwakwanadi God diki nyanak wariyak wardil mawul aka bwu kwusina. Alik tikuw, nyan dikik nimadib wayapiy sinaak!” ");
INSERT INTO mle_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nuwukadiy Parasiy a jaav vikuw, day Jisasak ata wadaad, “Kaliva-kwanadi duw, min minadiy kaliva-minadiy duw takwak wamin, kawrakwu-kwadiy!” ");
INSERT INTO mle_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisas dayak ata wadidiy, “Wun gwurak watuwadiygwurik, aw li day kawrakwu-kidana, yaakiya, kidiy kabaak adiy gaam sikidiy ki javik.” ");
INSERT INTO mle_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Jisas Jiruwsalimaar walibab yitaay, tip vikuw, a tipa kidiy duw takwak samasam wukikuw, ata giraad. Di ata waad, “Aw li gwur kitaan ab lakwuk-gwura mawul nak Godawa kwakwak! Aw adiy gwuraam pakwun tinadiy jaav gwur maa rav lakwu-lakwuk. ");
INSERT INTO mle_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","“Gwur maa laakw God gwurak yadi nyi gwuraam sugwiyaan kwurik. Alik tikuw, ginyir nyi yakinadiy gwuradiy mama nib gwurak yakuw, day kabir-kidanadiygwurik. Gwuraam kabirkuw, nimadi yanawa kupwa yaripaar gwuradi tip miyawa takatipi-kidanaad. Atawa kwurkuw, ginyir tip wulakuw, day miyawa tip, nyanugw, taakw, duw, miyawa sipakwutaka-kidanadiy. Sipakwutakakuw, miyawa yaripawa wiyaam tinadiy kabaak kapakap kapakap tikidiy.” ");
INSERT INTO mle_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas Jiruwsalimaar wuladik, God dikidi wiya tamiyaar ata wulaad. Adiy ababa yapiydiy duw takwak Jisas watipasakwu-didiy. ");
INSERT INTO mle_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Di dayak ata wadidiy, “God diki lapa nyigaam kitawa wanaad, ‘Ababa tipa kidiy duw taakw varakwadiy wunadi wiyaar wunak maaj bwuladakik.’ Aw gwur gwura mwugiy-gwuril luwkuw kwurdiy duw daya tamiy tilikikik!” ");
INSERT INTO mle_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ababa nyi God dikidi wiyaam Jisas duw takwak kalivadidiy. Aw adiy sapakwa nyanugw pris awa God diki lo kalivadiy duwawa duw taakw dayadiy sapakwa nyanugw day Jisasaam viyasipak. ");
INSERT INTO mle_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ababa duw taakw day diki maaj wukik. Alik tikuw, adiy sapakwa nyanugw day Jisasaam viyasipak maa rav. ");
INSERT INTO mle_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Nyi nak Jisas God dikidi wiyaam tikuw, God diki viyakita maaj duw takwak kalivadik, nuwukadiy sapakwa nyanugw pris awa God diki lo kalivadiy duwawa Juw dayadiy sapakwa nyanugw dikik yakuw, bas sidaad, “Nyanak aw agwa apa tikuw, kidiy jaav kwurminadiy? Minak ap kwiyid, sikadadaad?” ");
INSERT INTO mle_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Di dayak ata wadidiy, “Wunabab jaav nak gwurak bas saw. Sikadadaad Jonaam wayakid baptais kwiydikik? God-ad? Ay duw-adiy?” ");
INSERT INTO mle_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","6","Aw day awarwa awarwa maaj bwulabagwudiy. Day daya ata wadiy, “Nyan ata ata wakinadiyan? Aw li nyan ‘God-ad,’ waan wakibana, di nyanak ‘Agwa javik gwur diki majib wukimar-gwuril?’ wakinaad. Aw li nyan ‘Duw-adiy’ wakibana, ababa duw taakw day wukikuw Jon God diki maaj wasapwiydi duw tad, day nyanaam viyasipa-kidanadiyan kabakir.” ");
INSERT INTO mle_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Alik day Jisasak ata wadaad, “Nyan maa laakw.” ");
INSERT INTO mle_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jisas dayak ata wadidiy, “Wunabab gwurak wu maa agwa apaar kidiy jaav kwurtuwadiy.” ");
INSERT INTO mle_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas ki waya maaj kitika maaj vagaluwdiy duw takwak wadidiy, “Duw nak bajigay si girap diki mayim sididiy. Sikuw, yawiy kwurdiy duw daya tabaam ata takadid adi maay. Takakuw, sikaam ril jaka tipaar ata yad. ");
INSERT INTO mle_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Girap lawdaal nyi yawiy duw nak wayakidid dayak diki am kwurdikik. Aw day adi yawiy duwaam viyakuw, wayakidaak, kip yad. ");
INSERT INTO mle_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Di nikidi yawiy duw dayak wayakikuw, day dibab dim viyakuw, jawjaay kwurkuw, wayakidaak, kip yad. ");
INSERT INTO mle_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Adi maay asaay duw mugwula duw dayak wayakikuw, day dibab dim kupwaraap kwurkuw, day yakisakwu-daad kawaar. ");
INSERT INTO mle_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Adi maay asaay duw ata waad, ‘Agwa jaav kwurkidiwun? Wuna mawul yilidi nyan wayaki-kituwaad dayak. Day wukikinadiy dikik.’ ");
INSERT INTO mle_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Aw adiy duw adi nyinim vikuw, day daya wadiy, ‘Kidi duw maay asaay dikidi nyanad. Dim viyasipanaak. Dim viyasipakuw, kidi maay nyanadi maay tikinaad.’ ");
INSERT INTO mle_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“Alik day dim viyasipakuw, diki amwiy kawaar yakisakwudaal.” Jisas adi waya maaj kitika maaj wakwusin napakuw, di adiy vagaluwdiy duw takwak ata bas sididiy, “Day atawa kwurkuw, adi maay asaay duw agwa jaav kwurkidadiy dayaam? ");
INSERT INTO mle_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Di dayak yikuw, di adiy yawiy duwaam viyasipa-kidadiy. Dayaam viyasipakuw, adi maay nuwukadiy duw daya tabaam takakidaad.” Ababa duw taakw a maaj wukikuw, day ata wadiy, “Atawa tiliba!” ");
INSERT INTO mle_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisas dayaam vikuw, ata wadidiy, “Ki God diki lapa nyigaam rina maaj atata wana ki javik? ‘Adi kabaak tayir wiy kwurdiy duw maa wadiy dikik, kita nimadi kabaak abwa tibawa rinaad.’ ");
INSERT INTO mle_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Adiy duw taakw day adi apiy kabakim vakirkinadiy, dayadiy ap bwan tikwiyakidiy. Aw li adi kabaak adiy duw taakw apiyim vakir-kidadiy, viyamwunyir-kidadiy adiy mwiya kwayupw kaytik. Aw wun adi kabaak-adiwun.” ");
INSERT INTO mle_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Adiy God diki lo kalivadiy duwawa sapakwa nyanugw pris day lakwudaal Jisas dayadiy yawiyik a bajigay mayim yawiy kwurdiy duw waya maaj kitika majir duw takwak wadidiy. Alik a nyi day dim kalakwuk kwurdiy. Aw day adiy vagaluwdiy duw takwak yagakuw, alik day maa rav. ");
INSERT INTO mle_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Alik tikuw, day kip mila sukw kwurin kwadiy dikim kalakwu-kalakwu viyakita nyak. Alik day saan nuwukadiy duwak kwiydadiy adiy duw Jisas diki majik vasibariy-dakik, viyakita duw kaytik apap apap tikuw. Atawa wukikuw, day Jisas Rom tipa kidi dayaam van tidi duw diki tabaam takak. ");
INSERT INTO mle_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Adiy saan kwurdiy duw Jisasak bas sidaad, “Kalivanadi duw, nyan lakwu-nadiyan min viyakita duw-adimin. Mwiyir tikwana maaj kaliva-kwanadimin. Ababa duw taakw rivriv tinadiy minak. Yitaypika duwak niki maaj maa, maaj nak. Min God diki maaj mwiyir kaliva-kwanadimin. ");
INSERT INTO mle_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“Aw nyan takis Rom dayadi yitaypika duw, Sisa, dikik kwiynaak? Ay maa? Nyana lo ata ata wana javik?” ");
INSERT INTO mle_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Jisas lakwudil day tikal vitiy tidiy. Alik di dayak ata wadidiy, “Saan wunak asimak.” Day saan dikik kariyakuw, di dayak ata bas sididiy, “Kidi kayik mwutamawa si av. Sikadadaad?” Day ata wadaad, “Rom dayadi yitaypika duw, Sisa, dikibir-abir.” ");
INSERT INTO mle_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jisas ata wadidiy, “Ay yaakiya, Sisa dikidiy jaav dikik akwiy. Aw God dikidiy jaav dikik akwiy.” ");
INSERT INTO mle_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Adiy duw diki maaj wukikuw, ata pitaan wardiy. Day dikim vasibariyik kwurik duw taakw dayadiy mwutamaam, aw day maa rav. Alik day ata bwula maaj maa ti. ");
INSERT INTO mle_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Niki bapa duw, Satuwsiy, day dayadiy mawulaam wadiy duw kiyakuw, ginyir rap maa. ");
INSERT INTO mle_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Nuwukadiy Jisasak yakuw, dikik wadaad, “Kalivanadi duw, Mawsis ki maaj sukwudil nyanak: ‘Duw kwiyakuw, aw nyan maa, diki taakw kip kwaal, adi duw dikidi mwaam diki taakw kiraan tikida. Li ata nyanugw sapwiy-kiladiy likidi taay duwak.’ ");
INSERT INTO mle_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Tayir abitiy nyamwus mwaam tidiy. Dayadi mwaam taakw kirakuw, ata kiyaad. Aw di nyan maa ti. ");
INSERT INTO mle_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","“Ginyir duw a taakw kirakuw, ata kiyaad. Dibab nyan maa ti. ");
INSERT INTO mle_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","“Aliba nyamwus a taakw kirakuw, ata kiyaad. Atampik day abab nyamwus mwamugw likim kirakuw, abab kiyadiy. Nyanugw maa ti. ");
INSERT INTO mle_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","“Ginyir a taakw ata kiyaal. ");
INSERT INTO mle_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Ginyir God ababa kiyanadiy duw taakw kirapitaka-kida nyaam, a taakw sikada duw taakwa? Tayir duw abitiy kiradaal.” ");
INSERT INTO mle_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisas dayak ata wadidiy, “Kidi kupwaam kwakwanadiy duw taakw kira-kwadanadiy. ");
INSERT INTO mle_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","“Aw adiy duw God tasakwu-didiy day kiyakuw ridaak, kirapitaka-kidadiy, ginyir day God kirapitaka-kidadiy taakw akis kira-kidanadiy. ");
INSERT INTO mle_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","“God dayaam kirapitaka-kidalik, day dikidiy nyanugw tikidiy. Day God diki maaj kardadiy duw kaytik kwakidiy. Day Godawa kwakuw, ginyir day kiy maa. ");
INSERT INTO mle_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Mawsis sukwudil maaj mwiyir simaka-lidiygwur duw taakw kiyakuw ridaak, God ata kirapitaka-kidadiy. Kwasada miyaam yanil yiy sukwudil majim di waad, ‘Yitaypika Duw God di Aparam dikidi God-ad, Aysak dikidi God-ad, Jakap dikidi God tikwanaad.’ ");
INSERT INTO mle_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","“Aw li Mawsis atawa waad adiy tayir kiyadiy duwak, God di kiyadiy duw taakw dayadi God maa. Dayadiy mawul kip kwadaak, alik di kwakwanadiy duw taakw dayadi God-ad. Day abab kip kwakwanadiy Godawa. Atawa tikilalik, nyan rivinadiyan lakwu-lakwuk nyan kiyakuw, God ata kirapitaka-kidadiyan dikiwa kwabakikik.” Jisas atawa wadidiy adiy Satuwsiy bapa duwak. ");
INSERT INTO mle_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nuwukadiy God diki lo kalivadiy duw Jisas wadil maaj wukikuw, ata wadaad, “Kalivanadi duw, min yarakara bwula-nadimin!” ");
INSERT INTO mle_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wakuw, day abab yagakuw, dikik ginyir basab maa si. ");
INSERT INTO mle_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisas dayak ata wadidiy, “Atata atata God diki lo kalivanadiy duw wakwanadiy God dikidi Tasakwudidi Duw, Davit dikidi gwalugwa duwadika tikinaad waan? ");
INSERT INTO mle_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","“God diki lapa nyigaam rina maaj, si Sam, Davit di diki waad, ‘God wunadi Yitaypika Duwak wadid, “Kilim wuna mava tabaam daan ada. Rikuw, wun minadiy mama nibaam kakilkuw, min dayaam van tikiminadiy.” ’ ");
INSERT INTO mle_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Aw li Davit God dikidi Tasakwudidi Duw sikiydid, ‘Wunadi Yitaypika Duw-ad’, wakuw, ata ata di Davit dikidi waraga nyinda tikik-naad? Alik tikuw, adi duw Davit dikidi yitaypika duw ab tinaad.” ");
INSERT INTO mle_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ababa duw taakw kip Jisas wadidiy majik wukin ridaak, Jisas dikidiy kalivadidiy duwak ata wadidiy, ");
INSERT INTO mle_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gwur yarakara van ada God diki lo kalivanadiy duwak. Day nimadiy wapwiy kwusuwkuw, tiytiyan tikir. Duw taakw vagaruwdadi tamiyaam day wukik abab wayapiy sidadiy dayak. Juw dayadiy gaba maja wiyaam day sapakwa nyanugw dayadiy tikir kwurdadiy. Kikipaat bayaki nyi taay wakwun rikwanadiy. ");
INSERT INTO mle_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“Day simiy maaj Godak bwula-kwanadiy duw taakw dayadiy milaam apaapap titaay, ‘Viyakita duw-adiy,’ wataay wadakikik. Aw atawa kwurtaay dayadiy mawul warkwanadiy adiy tawtakwak gwiyip kwurtaay, dayadiy niki jaav niki jaav luwkuw kwurik. Alik God diki kot im tidaak, God dayak jawjaay kwurkuw, daya kagil kakil-kina.” ");
INSERT INTO mle_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Adiy saan samasam tidiy duw taakw day Godak saan takakwadana tamiyaam titaay, God dikidi wiyaam saan takadaak, Jisas di yarakara vididiy dayak. ");
INSERT INTO mle_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Di ata saal yil tawtakw kwaal taakw vidil. Li kwasabir saan vitiy, toea nak kaytik, takalibir. ");
INSERT INTO mle_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Di dikidiy kalivadidiy duwak ata wadidiy, “Mwiya maaj watuwadiygwur. Ki taakw takalibir saan, ababa nuwukadiy duw taakw dayadiy takadanadiy sanaam kakil-nabir. Dayaam saan samasam rinadiy. Aw day dayadiy kip rinadiy saan takanadiy. Aw ki taakw, likim saan aywa maa. Aw likidiy ababa jaav takalidiy. Likibir kikipaat yapiy saan takalibir.” ");
INSERT INTO mle_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Nuwukadiy dikidiy kalivadidiy duw titaay, wadiy God dikidi wiyaam tinadiy viyakita kabakawa Godak kwiydadiy javik day alim kaytaka-dadiy gilabadiy tidakikik. Aw Jisas dayak ata wadidiy, “Kita kidiy jaav vigwuradiy. Aw ginyir gwuradiy mama nib yakuw, kidi God dikidi wiy piradaak, adiy kabaak yakisadadaak, kapakap kapakap tikidiy!” ");
INSERT INTO mle_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jisas dikidiy kalivadidiy duw dikik ata bas sidaad, “Kalivanadi duw, akasikir kidi jaav wakwukinaad? Agwa jaav taay wakwudik, nyan vikuw, lakwukibana kidi jaav ata wakwukinaad?” ");
INSERT INTO mle_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Di dayak ata wadidiy, “Gwur yarakara ada nuwukadiy duw gwurak yaan gwiyip kwurik-nadiy. Aw samasama duw yakuw, wunadi si kwurkuw, ‘Wun God dikidi Tasakwudidi Duw-adiwun,’ wakuw, ay ‘God dikidi Tasakwudidi Duw ada sibinin yakinaad!’ Wakuw wadaak, aw gwur atampika duw dayadiy kwukib yi-tikwa. ");
INSERT INTO mle_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Gwur maaj wukikuw, jaka tip nak nikidi jaka tipawa wariyadaak, jaka tip nikim bap nak nikidi bapawa wariyadaak, gwur yaga-tikwa. Adiy jaav taay yadaak, ginyir ababa jaav kwusikidana nyi ata yakina.” ");
INSERT INTO mle_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Di dayak ata wadidiy, “Nikidi jaka tip yikuw, nikidi jaka tipawa wariyakinadiy. Nikidi gavman yikuw, nikidi gavman awa wariyakinadiy. ");
INSERT INTO mle_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","“Kaam yasakiladiy nyi yakinadiy. Niki tip niki tipaam nanaaw yakinadiy. Kiyawaliy miyawa tamiyaar yakina. Nimadiy wayiga-kinadiy jaav adawur tubwaam vikigwuradiy. Aw gwur yaga-tikwa. ");
INSERT INTO mle_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Kidiy jaav wakw maardaak nibway, taay day gwuraam kalakwukuw, jawjaay kwur-kidanadiygwurik. Day kotiy-kidanadiygwur dayadiy gaba maja wiyaam. Day kalabus im kwusawula-kidanadiygwurik. Day gwuraam kalakwutaay, karay-kidanadiygwurik kotiy ir rigwurkikik dayadiy sapakwa duwawa yitaypika duwak. Gwur wunadiy kalivatuwadiy duw tigwuralik, day kidiy jaav gwuraam kwur-kidanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","“Adiy nyaam gwur mwiyir wuna viyakita maaj adiy duwak wasapwiy-kigwuradiy. ");
INSERT INTO mle_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","“Aw gwur kot im tikuw, bwula bwula majik wuki-tikwa. Adiy nyaam wun gwurak viyakita majawa mawul kwatiyatuwik, gwuradiy mama nib abab samab gwuraam kakil-kakil rav maa majik. ");
INSERT INTO mle_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Gwur gwuradiy amaay, asaay, mamugw, nyamusugw, gwalugwa nyanugw, kapa nyanugw, day gwuraam kotiy ir karay-kidanadiygwurik. Aw gwuradiy nuwukadiy adiy kot a duw tasakwu-kidanadiy gwuraam viyasipa-dakik. ");
INSERT INTO mle_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","“Wun wunadiy duw tigwuralik, alik samasama duw taakw maa wakinadiy gwurak. ");
INSERT INTO mle_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","“Aw li gwur apawa tikigwura, bwan wunak kway maarkuw, gwur viyakit kwakidiygwurik wunawa nyanyi nyanyi. Aw adiy duw taakw day rav maa gwuraam a javim watip watipik. Samab maa.” ");
INSERT INTO mle_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ginyir vikuw gwur vay sawdiy duw Jiruwsalimaam kabirkuw, tidaak, gwur lakwukigwura, kwasa mwiy tikuw, day Jiruwsalim miyawa sapakwutaka-kidanaad. ");
INSERT INTO mle_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","“A nyaam God di tasakwudil day Jiruwsalimaam jawjaay kwurkidanaad. Alik tikuw, Juwtiya tamiyaam kwakidiy duw taakw nibwukir tabwukwadiy. Adiy Jiruwsalimaam kwakidiy duw taakw Jiruwsalim tip wapakwadiy. Adiy kawaam kwakidiy duw taakw yala tipaar wuladabaal. Atawa tikidanalik, God diki lapa nyigaam rina maaj mwiya mwiyab tikina. ");
INSERT INTO mle_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Yalawa tikidiy taakw, nyanugwak mwuny kwiykidiy takwawa, kupwiyayugw! Dayak wukinadiwun a nyaam. God yaal girakuw, alik di jawjaay kidiy Yisrayil jaka tipa kidiy duw takwaam kwurkidadiy. ");
INSERT INTO mle_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","“Nuwukadiy duw taakw nyanugw gwuradiy mama nib viyasipa-kidanadiy. Aw nuwukadiy dayaam kalakwukuw, ababa jaka tipaar kwurin karaykidanadiy. Day Jiruwsalimaam miyawa sapakwutaka-kidanaad. Aw adiy nuwukadiy jaka tipa kidiy duw taakw day Jiruwsalimaam ata vasisada kwakidiy yin God tasakwudil nyab.” ");
INSERT INTO mle_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Duw taakw nimadiy nyawa bapawa tugwiyaam wakwu-kinadiy jaav vikidanadiy. Kidi kupwaam solwara am mwiya nimadiy mam yakidiy. Ababa kidi kupwaam kwakidiy duw taakw adiy jaav vikuw, dayadiy pipiliy wukikuw, yagakuw, mawul vitiy vitiy tikidiy. ");
INSERT INTO mle_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","“Ababa tubwaam tinadiy jaav yin yaan tikidiy. Duw taakw vikuw, samasam pitaan warkuw, wakidiy, ‘Ka! Agwa jaav nyanak yakina?’ ");
INSERT INTO mle_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Day ata vikidanadiwun, wun dayadi Mwaam. Wun tubwaar yakinadiwun mwiya nimadi apawa gilabadiy. ");
INSERT INTO mle_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Akidiy jaav bas yadaak, gwur rasikuw, kituw av. Kwasa mwiy tikuw, wun kwurkituwadiygwur. Alik tikuw, gwur rakarak ada!” ");
INSERT INTO mle_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisas dikidiy kalivadidiy duwak ki waya maaj kitika maaj wadidiy, “Vik wadana miyawa nuwukadiy miyak av. ");
INSERT INTO mle_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","“Ba miy kwany ridaak, lakwu-kinadiygwurik waal jakida nyi aka walibab tina. ");
INSERT INTO mle_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","“Kitampik, gwur kidiy jaav vikuw, lakwukigwura God miyawa duw takwaam van tikidadi nyi aka walibab tikinaad. ");
INSERT INTO mle_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Mwiya maaj watuwadiygwurik. Ki nyaam kwanadiy duw taakw kwas maa nibway, kidiy jaav wakwukuw, taay vikidanadiy. ");
INSERT INTO mle_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","“Adawur tubwawa kidi kupw kwusikinabir. Aw wuna maaj kwas maa.” ");
INSERT INTO mle_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Gwurakil yarakara akwur! Bayaki kikipaat kitaay, duw tikwulkidanadiy guw kitaay, kidi kupwa kidiy javik wukitaay, gwur atawa kwur-tikwa, wuna yakituwa nyi ata gwuraam mabir kaytik yakik-na. ");
INSERT INTO mle_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","“Wuna yakituwa nyi ata yabiyib yakina kidi kupwaam kwakidiy miyawa duw takwak. ");
INSERT INTO mle_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","“Gwur nyanyi yarakara awuk! Nyanyi Godak bas as di ap gwurak kwiydikik adiy jaav gwuraam kakilik-nadiy. Atawa kwurkuw, gwur mwiyir tikidiygwurik adiy kupwarapa javim. Atawa tikuw, gwur ata duw taakw dayadi Mwaam diki mwutamaam tikidiygwurik.” ");
INSERT INTO mle_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ababa nyi Jisas God dikidi wiyaam titaay, duw takwak kalivadidiy. Aw ababa gaan di Aliv wadadi nibwukir warid alim kwakir. ");
INSERT INTO mle_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mwiya ganbab ababa duw taakw God dikidi wiyaar yikwadiy Jisas dikidiy wadidiy maaj wukik. ");
INSERT INTO mle_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Yis Maa Ti Bret bayaki kikipaat day sikiy-kwadanaad God Juw Duw Takwaam Nyigildidiy Nyi, walibab yalik, adiy sapakwa nyanugw pris awa God diki lo kalivadiy duw, day Jisasaam viyasipak kwurdaad. Aw day adiy duw takwak yagadiy, ‘Day pitaan warik-nadiy nyanak,’ wakuw. ");
INSERT INTO mle_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","4","Juwtas, sikiykwadanaad Yiskariyat, Jisas dikidiy tabatiy maan vitiya duw nak, Satan diki mawulaam mwugiydik, di yikuw, maaj lakatiydidiy sapakwa nyanugw pris awa vay sawdiy duw dayadiy sapakwa nyanugw ata ata di Jisas dayadiy tabaam takatakak. ");
INSERT INTO mle_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Day rakarak tidiy diki maaj wukikuw. Day maaj lakatiydiy dikik saan kwiyik. ");
INSERT INTO mle_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juwtas yaakiya wakuw daya majik, aw di ata kavin kwaad Jisas dayak yipakwun kwiy yabik. ");
INSERT INTO mle_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yis Maa Ti Bret bayaki kikipata nyaam, day sipsip a nyanugw viyasipadadiy God Juw duw takwaam Nyigildidiy Nyi bayaki kikipatik. ");
INSERT INTO mle_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Alik tikuw, Jisas Pitawa Jon wayakidibir daya God Juw duw takwaam Nyigildidiy Nyi bayaki kikipaat kwulapwu-birakik. ");
INSERT INTO mle_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aw bir dikik ata wabirid, “Akim an nyanadi kikipaat kwulapwu-kituwaad?” ");
INSERT INTO mle_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Di birakik ata wadibir, “Bir awuk! Bir yikuw, Jiruwsalim tipaar wulakuw, duw nak tukwul vakaam guw yatanaad sitakira-kibiraad. Bir diki kwukib yikuw, wulakida wiyaar awul. ");
INSERT INTO mle_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","“A wiy asaay duwak bas as, ‘Kalivanadi duw wanaad, “Wiy akim kwana a wiyaam wun wunadiy kalivatuwadiy duwawa God Juw duw takwaam Nyigildidiy Nyi bayaki kikipaat kikibana?” ’ ");
INSERT INTO mle_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","“Di alawurim kwakina wiy simaka-kidabirbir. Wiy bwutaay kwulapwudik, tina. Alim bir niki jaav niki jaav kwulapwun ada nyanak.” ");
INSERT INTO mle_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bir yikuw, Jisas tayir wadidiy jaav ata vibiridiy. Bir God Juw duw takwaam Nyigildidiy Nyi bayaki kikipaat ata kwulapwu-biridiy. ");
INSERT INTO mle_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kikipaat kikidana nyi tilik, Jisas dikidiy wayakididiy duwawa jabim daan rad kikipaat kikir. ");
INSERT INTO mle_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Di dayak ata wadidiy, “Ginyir kagil samasam wuna sipaam yikina. Aw wuna mawul samasam wana wun taay God Juw duw takwaam Nyigildidiy Nyi bayaki kikipaat gwurawa nakamwiyib kikir. ");
INSERT INTO mle_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","“Aw wun gwurak watuwadiygwur wun kidi kupwaam ginyir kidi bayaki kikipaat samab ki maa. Aw ginyir God duw takwaam van tikidadi tipaam kidi bayaki kikipaat diki maaw maykaar wakwudik, wun kidi bayaki kikipaat maa ata kikituwaad.” ");
INSERT INTO mle_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Jisas adakap kwurkuw, Godak wayapiy sikuw, dayak ata wadidiy, “God ki adakapaam rinadi wain nakanak ak. Wun gwurak waaw wun nuwukadiy wain ki maa. Aw God dikidi duw takwak van tikidadi nyi yakida, wun ata wain kikidiwun maa.” ");
INSERT INTO mle_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jisas bret kwurkuw, Godak wayapiy sidid. Jisas a bret kaysukwasukwakuw, dikidiy kalivadidiy duwak ata kwiydidiy. Di dayak ata wadidiy, “Kal wunaki amwiya. Gwurak kwatiya-kituwala. Wunak wukitaay, gwur atawa nyanyi akwur.” ");
INSERT INTO mle_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Day dayadi bayaki kikipaat kikuw, Jisas atawa adakap kwurkuw, wadidiy, “Ki wain wunadi nyikiyad. Wunadi nyikiy wakwukuw, gwurak simaka-kidadiygwur God diki kwula aban mwiya maajal.” ");
INSERT INTO mle_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Di dayak ata wadidiy, “Adi wunadiy mama nibak wunaam kwiykinadi duw di wunawa ki daanada kidi jabim rinaad. ");
INSERT INTO mle_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","“Wun, duw taakw dayadi Mwaam, kinadiwun tayir God diki lapa nyig walil pik. Aw gwuradi Mwaam mama nibak kwiykinadi duw kupwarapa jaav dikim warkidanaad!” ");
INSERT INTO mle_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Day dayak awarwa bwulasakiy saladiy, “Sikadadaad atawa kwurkinaad?” ");
INSERT INTO mle_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Day dayak awarwa maaj warjuwdiy, “Nyan nyanaam sikadadaad yitaypik tikinaad?” wakuw. ");
INSERT INTO mle_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aw Jisas dayak ata wadidiy, “Nuwukadiy jaka tipa kidiy yitaypika duw ap tikwanadiy dayadiy duw takwak van tidakikik. Adiy van tinadiy duw day dayadiy duw takwak tasakwu-kwadanadiy day adiy van tinadiy duwak sikiy-kwadanadiy, ‘Duw takwak sukwasukw kwurkwanadi duw-adiy.’ ");
INSERT INTO mle_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Aw gwur atawa ti maa. Adi duw di gwuraam yitaypik tinaad, di yisadapik tikwaad. Aw adi duw di gwuraam van tinaad, di yawiy duw kaytik tikwaad gwurak. ");
INSERT INTO mle_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Aw haiden duw daya nyidim agwa duw yitaypik tinaad? Nyidi valim kip rinadi duw, ay? Adi diki val gwus kanadi duw? Adi valim kip rinadi duw, di yitaypik tinaad. Aw nyan atawa maa. Aw wun gwurawa yawiy duw kaytik tinadiwun. ");
INSERT INTO mle_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Duw taakw wunaam jawjaay kwurdaak, gwur wunaam maa wap. ");
INSERT INTO mle_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","“Wunadi Asaay tasakwu-didiwun wun duw takwak van tituwkikik. Atampik, wun tasakwu-tuwadiygwurik. Gwur wuna van ti tikituwa tamiyaam kamnaagw kan guw kan wuna jabim daan rikuw, yitaypika duw tikirim daan rikuw, Yisrayil kidiy tabatiy maan vitiya gwalugwuk van tigwurkikik.” ");
INSERT INTO mle_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas Sayman Pitaak ata wadid, “Sayman, Sayman, min awuk! God yaakiya waad Satan gwuraam abab vasibariyik kwurdikik. Duw rika tip birakuw, guwaam kaybisikuw, di viyakita guwada kwurkuw, adiy sim tip ata kip yakikwadanadiy tapwukawa asak. Adiy sim tip yaki-kwadana pik gwurak ab Satan atawa yakiya yakiyakik-kinadiygwurik gwur kapakap kapakap tikuw, jawjaay tigwurkikik. ");
INSERT INTO mle_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","“Aw Sayman, wun Godak bwutaay bas situwid mina wunak wukijibir timina mawul vakir maarlikik. Aw ginyir min wunak bwan kwiykuw, sibinin wunak yakuw, min minadiy wunak wukijibir tinadiy kapa duwak ap akwiy.” ");
INSERT INTO mle_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aw Pita Jisasak ata wadid, “Yitaypika Duw, aw li day minaam ab kalakwukuw, kalabus ir karaykidana, wun minawa nakamwiyib yikidiwun. Aw li day minaam ab viyasipa-kidana, yaakiya, wunabab nakamwiyib minawa kiyakidiwun!” ");
INSERT INTO mle_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas Pitaak ata wadid, “Pita, wun minak waaw. Ki gaan taay tapwuk wu maardik nibway, taay min jaab mugwul wakidimin, ‘Wun Jisasaam maa laakw,’ waan. Min kitawa waminik, taay tapwuk ata ginyir wakinaad.” ");
INSERT INTO mle_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas dayak ata wadidiy, “Tayir niki tip niki tipaar wayakituwik, ‘Gwur sanawa waliy manawa kwasabiy karay-tikwa,’ wakuw, gwur saal yidiygwur niki jaav niki javik?” Day dikik ata wadaad, “Maa.” ");
INSERT INTO mle_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Jisas dayak ata wadidiy, “Aw kita watuwadiygwur duw di saan ay kwasabiy tinaad, adiy jaav kwurkwaad. Aw li duw di wariya jaav ti maarkuw, dikidi wapwiy duw yapiykuw, saan kwurkuw, wariya jaav yapiykwaad. Aw wun gwurak watuwadiygwur God diki maaj wana, ‘Day wakidiy, “Di vaal yikwanadi duw tinaad.” ’ Ki wunak wana maaj mwiya mwiyab tikwaal. Ababa wuna sukwudadiy maaj God diki lapa nyigaam aka mwiyir wakwuna. Alik tikuw, ki maaj mwiya mwiyab tikwaal.” ");
INSERT INTO mle_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dikidiy kalivadidiy duw ata wadaad, “Min av! Yitaypika Duw, kilim wariya bag vitiy rinabir!” Day diki maaj liki maaw maaj laakw maardalik tikuw, alik di dayak ata wadidiy, “Agwak! Gwuradiy maaj kawurakwum nakwadiy.” ");
INSERT INTO mle_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas Jiruwsalim tip wapakuw, yikwada pik Aliv nibwukir yad. Dikidiy kalivadidiy duw diki kwukib yidiy. ");
INSERT INTO mle_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yidil tamiyaam tikuw, dikidiy kalivadidiy duwak wadidiy, “Gwur Godak bas as di sugwiyaan gwurak kwurdikik ata vaal gwuraam kakilik-ladiygwurik.” ");
INSERT INTO mle_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Jisas dayaam wapakuw, duw kabaak kwartay-kwadana simiy pik yikuw, kwatiyir sikuw, Godak ata wadid, “Asaay, min yaakiya wakuw, kidiy wunak yakinadiy kupwarapa jaav kwurin ayak. Aw wuna mawul maa, min mina mawul waladiy yawiy akwur.” ");
INSERT INTO mle_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Adawur tipa kidi God diki maaj kardadi duw nak wakwukuw, Jisasak ap kwiydid. ");
INSERT INTO mle_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Diki mawul kapakap kapakap tilik, mwiya nimadib Godak maaj wadid. Atawa wadik, wag nyikiy kaytik kupwaar vatikid. ");
INSERT INTO mle_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Godak waan napakuw, dikidiy kalivadidiy duwak yikuw, vidil day si kwadiy, dayadiy mawul samasam wukikuw Jisas dikidiy maaj yawiywa sukwak. ");
INSERT INTO mle_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Di dayak wajuwiyakuw, ata wadidiy, “Agwa javik tikuw, gwur si kwanadiygwurik? Gwur arap! Rapikuw, Godak bas as di gwurak sugwiyaan kwurdikik ata vaal gwuraam kakilik-ladiygwurik.” ");
INSERT INTO mle_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas maaj bwulataay tidik, samasama duw taakw dikik yadiy. Dikidi tabatiy maan vitiya kalivadidiy duw nak, Juwtas, di taay wakwudik, day diki kwukib yadiy. Juwtas Jisasawa walibab yaad diki mwutamaam jipwuk. ");
INSERT INTO mle_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aw Jisas dikik ata wadid, “Juwtas, min duw taakw dayadi Mwaam diki mwutamaam jipwukuw, atawa dikidiy mama nib tabaam takakiminaad?” ");
INSERT INTO mle_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jisasawa tidiy dikidiy kalivadidiy duw day adiy duw kwurik yadaal yawiy lakwukuw, Jisasak wadaad, “Yitaypika Duw, nyan min jaaw kidiy duwaam wariya bagaar viyanaak?” ");
INSERT INTO mle_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aw daya duw nak yitaypika pris dikidi yawiy duwaam wariya bagaar yakidik, aw diki waan viyalupwadil. ");
INSERT INTO mle_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aw li Jisas dayak ata wadidiy, “Yaakiya, gwur atawa kwur-tikwa!” Wakuw, adi yawiy duw wanim taab takakuw, sipwutiydid. ");
INSERT INTO mle_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jisas dikik yadiy sapakwa nyanugw pris awa God dikidi wiya vay sawdiy duw dayadiy sapakwa nyanugwawa Juw dayadiy sapakwa nyanugwak wadidiy, “Wun jaal dayikwadi duw-adiwun, gwur wariya jaav kwurkuw, wunaam kalakwuk yagwura? ");
INSERT INTO mle_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","“Nyi samasam wun gwurawa God dikidi wiyaam daan rituwadiy. Aw gwur wunaam maa kalaakw. Gwura nyi aka. Kita Satan apawa van tinaad.” ");
INSERT INTO mle_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Day Jisasaam kalakwukuw, kwurin karaydaad yitaypika pris diki wiyaar. Aw Pita daya kwukir kwasa sikaam yad. ");
INSERT INTO mle_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Adiy vay sawdiy duw yitaypika pris wiya yaripaar wulakuw, yiy sakatakadaal. Pita dayawa wulakuw, daan rad mala yiyaam. ");
INSERT INTO mle_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aw badiy yawiy taakw nak Pitaam vikuw, mala yaam ridik, yarakara dikik visimwulkuw, ata waal, “Kidi duw ab Jisasawa tad!” ");
INSERT INTO mle_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Di maa wakuw, ata wadil, “Taakw, wun adi duwaam maa laakw!” ");
INSERT INTO mle_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ginyir kwasa mwiy tikuw, duw nak Pitaam vikuw, ata wadid, “Minabab dayawa tidimin!” Aw Pita ata wadid, “Wun maa!” ");
INSERT INTO mle_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ginyir kwasa mwiy maa tikuw, nikidi duw nimadib wadidiy, “Ayiy, kidi duw di Galaliy tamiya kidi duwad. Di Jisasawa tad!” ");
INSERT INTO mle_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita dikik ata wadid, “Mina wamina maaj wun maa laakw!” Jayib nak Pita atawa wataay tidik, tapwuk ata waad. ");
INSERT INTO mle_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yitaypika Duw Jisas kwasa sikaam tidik, tipatiyakwukuw, Pitaam vidik, Pita ata wukin kariyadil tayir Jisas dikik wadil maaj, “Ki gaan tapwuk wadik, taay min jaab mugwul wakimina, ‘Wun Jisasaam maa laakw.’” ");
INSERT INTO mle_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wukikuw, wiya yarip kawaar wakwukuw, ata mwiya nimadib giraad. ");
INSERT INTO mle_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Adiy Jisasaam kaykitin tidiy duw day dikik wajibayin kwurtaay, viyadaad. ");
INSERT INTO mle_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Day dikibir mil wapwiyir takatipikuw, dim viyan napakuw, bas sidaad, “God minak ap bwu kwiydil miyawa jaav lakwu-minakik, ay? Alik tikuw, min nyanak aw sikadadaad minaam viyanaad?” ");
INSERT INTO mle_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Day nuwukadiy samasama kupwarapa maaj dikik wadaad. ");
INSERT INTO mle_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ganib tilik, Juw dayadiy sapakwa nyanugwawa sapakwa nyanugw pris awa God diki lo kalivadiy duw day vagaluwkuw, vay sawdiy duw ata Jisas kwurin karaydaad adiy Juw dayadi nimadi kaunsil ak. ");
INSERT INTO mle_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","69","Day ata bas sidaad, “Nyanak aw, min God dikidi Tasakwudidi Duw-adimin, ay maa?” Di dayak ata wadidiy, “Aw li wun gwurak atawa wakituwa, gwur wakinadiygwur wuna maaj mwiya maaj maa. Aw li wun gwurak jaav nak bas sikituwa, gwur wunak maaj wu maa. Kwasa tikuw, duw taakw dayadi Mwaam ap samasam tikwanadi God diki mava tabaam rikinaad.” ");
INSERT INTO mle_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Day abab dikik ata wadaad, “Aw min mwiya God dikidi Nyan-adimin?” Di dayak ata wadidiy, “Wagwura pik wun-adiwun.” ");
INSERT INTO mle_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Di atawa wadik, day wadiy, “Nyan nikidi duw sukwupir yaka maaj wukik maa! Aw di diki ki maaj wada!” ");
INSERT INTO mle_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Adiy kaunsil duw abab rasikuw, Jisasaam kwurin karaydaad Paylatak. Aw Paylat, Roma jaka tipa kidi duw tikuw, di a tamiya kidiy duw takwaam van tididiy Roma gavman ak. ");
INSERT INTO mle_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Paylatak yikuw, kipa sukwupir maaj dikik wadaad Jisasak. Day wadaad, “Kidi duw nyanadiy duw takwak jawjaay kalivadidiy. Di dayak wakwadidiy, ‘Gwur takis saan Rom dayadi yitaypika duwak kwiy-tikwa,’ waan wakwadidiy. Di dayak wakwadidiy, ‘Wun Krais, Yitaypika Duw-adiwun.’” ");
INSERT INTO mle_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Paylat Jisasak bas sidid, “Min Juw dayadi yitaypika duw-adimin?” Jisas ata wadid, “Ayiy, wamina pik wun-adiwun.” ");
INSERT INTO mle_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Paylat adiy sapakwa nyanugw pris awa nuwukadiy duwak ata wadidiy, “Wun kidi duwaam simsim vaal dim maa sitakir.” ");
INSERT INTO mle_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aw day dikik mwiya nimadib ata wadaad, “Di miyawa Juwtiya tamiyaam duw takwak kalivakuw, day abab wariyak tikwanadiy. Taay Galiliy tamiyaam atawa bas duw takwak kalivakuw, aw kita kidi kilir yanaad!” ");
INSERT INTO mle_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","7","Paylat dayadiy maaj wukikuw, ata bas sididiy, “Kidi duw Galiliya tamiya kid-ad, ay?” Paylat ata lakwudil Jisas di Yirat van tidi tamiya kid-ad. Aw Yirat Jiruwsalimaam kwadik, Paylat Jisas ata Yiratak wayakidid. Aw Yirat Juw dayadi yitaypika duw tikuw, Roma gavman yaakiya waad di kip di dikidiya tamiya kidiy duw takwak van tidikikik. ");
INSERT INTO mle_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mwiya talab Yirat di Jisasaam vikir. Alik di Jisasaam vikuw, di rakarak tad. Di Jisas kwurdidiy yawiy wukididiy. Alik tikuw, di vikir Jisas nimadiy yawiy kwurdik. ");
INSERT INTO mle_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aw Yirat Jisasak bas samasam sidid. Aw Jisas samab maaj maa wu dikik. ");
INSERT INTO mle_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Adiy sapakwa nyanugw pris awa God diki lo kalivadiy duw day tayir wakwukuw, Yiratak nimadib kipa sukwupir maaj Jisasak warjuwtakadaad. ");
INSERT INTO mle_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yiratawa dikidiy vay sawdiy duw Jisasak rik kwurtaay, wajibayin kwurkuw, viyakita simiy tidi wapwiy Jisasaam jitakakuw, Paylatak sibinin wayakidaad. ");
INSERT INTO mle_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tayir Yiratawa Paylat bir mama nib tibir. Aw a nyi bir ata kapa duw tibir. ");
INSERT INTO mle_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paylat adiy sapakwa nyanugw pris awa nuwukadiy duw taakw dayadiy sapakwa nyanugwak gaam sididiy day yadakikik dikik. ");
INSERT INTO mle_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Day dikik yadaak, di dayak ata wadidiy, “Gwur kidi duw wunak kwurin karaykuw, wagwuradiwun di duw takwak jawjaay kalivadidiy. Aw wun bwutaay bas situwaad gwuradiy mwutamaam. Aw wun samab maa sitakir adiy wagwuradiy di yididiy vaal. ");
INSERT INTO mle_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","“Aw Yirat ab di adiy vaal dim maa sitakir. Alik di kip wayakidaad nyanak. Di samab vaal maa yi nyan dim viyasipa-viyasipak. ");
INSERT INTO mle_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","“Alik tikuw, wun wunadiy vay sawdiy duw dim viyadaak, kip wayaki-kituwaad.” ");
INSERT INTO mle_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ababa God Juw duw takwaam Nyigildidiy bayaki kikipata Nyi Paylat di dayak kalabus im kwadi duw nak wayakiyi-kwadidiy. ");
INSERT INTO mle_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Aw day abab nakamwiyib gaam sidiy dikik, “Jisasaam aviyasip! Aw Barapas nyanak kip awayak!” ");
INSERT INTO mle_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aw Barapas di taay yikuw, Roma gavman awa wariyakuw, Jiruwsalimaam di duw nak viyasipadalik tikuw, alik kalabus im kwaad abir javik tikuw. ");
INSERT INTO mle_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","21","Paylat di Jisasaam wapak tikuw, di dayak maa wadidiy. Aw day ata nimadib gaam sidiy, “Dim maap tinadi miyaam akat! Dim maap tinadi miyaam akat!” ");
INSERT INTO mle_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aw Paylat dayak jaab mugwula yawaam wadidiy, “Aw di agwa vaala yidil? Wun samab maa sitakir dim viyasipa vaal. Alik tikuw, wun wunadiy vay sawdiy duw dim viyadaak, kip wayaki-kituwaad.” ");
INSERT INTO mle_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aw day kip nimadib gaam sidiy di Jisasaam maap tidi miyaam katadikik. Aw daya maaj ata kakilil. ");
INSERT INTO mle_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Paylat ata yaakiya waad daya wadaal majik. ");
INSERT INTO mle_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Adi gavman awa wariyakuw, duwaam viyasipakuw, kalabus im kwadi duw Paylat ata kip wapadid dayak daya wadaal pik. Aw li di Jisas dikidiy vay sawdiy duwak kwiydid day dim maap tidi miyaam katadakik adiy duw taakw wadaal pik. ");
INSERT INTO mle_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Day ata Jisas kwurin karaydaad. Day yitaay tikuw, Sayriyniy tipa kidi duw, Sayman, maay tamiy wapakuw, walibab yaad. Adiy Roma vay sawdiy duw dim kalakwukuw, wasipidaad. Wasipikuw, maap tidi miy diki sugwaam takadaad. Takadaak, adi maap tidi miy Jisas kwukib yataan karaydid. ");
INSERT INTO mle_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Duw taakw samasam Jisas kwukib yidiy. Dayawa nuwukadiy taakw yikuw, Jisasak samasam wukikuw, day nimadib giradiy. ");
INSERT INTO mle_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas dayak tipatiyakwukuw, ata wadidiy, “Jiruwsalim kidiy taakw, gwur wunak gira-tikwa. Gwur gwurawa gwuradiy nyanugwak agir. ");
INSERT INTO mle_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","“Ginyir duw taakw wakidiy, ‘Adiy taakw day gwaaj kwanadiy, adiy taakw day nyanugw sapwiy maarkuw, mwuny dayak kway maar kwanadiy, day rakarak tikwadiy! Day mawul kapakap kapakap ti maa kidiy mwiya kupwarapa nyaam dayadiy nyanugwak wak maarkuw.’ ");
INSERT INTO mle_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Adiy nyaam duw taakw mwiya jawjaay kwakuw, dayadiy mawul wakidiy nimadiy nibwuk pakwukuw, dayaam taykiti-dakik. ");
INSERT INTO mle_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Wun vaal maa yi. Aw li day kitawa wunaam kip kwurdanadiwun, mwiya jawjaay adiy vaal yinadiy Jiruwsalim tipa kidiy duw takwaam kwurkidanadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Adiy Roma vay sawdiy duw vaal yibir duw vitiy kwurdabir Jisasawa viyasipak. ");
INSERT INTO mle_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sikiykwadana duw adakap kitika tamiyaar yikuw, alim day Jisas maap tidi miyaam katidaad. Abir vaal yibir duw ata katidabir, nak Jisas diki mava tabaam, nak diki akiy tabaam. ");
INSERT INTO mle_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisas ata waad dikidi asayik, “Asaay, min kidiy duw dayadiy vaal kwurin ayak. Day mwiyir maa laakw ki kwurdana jaav.” Adiy vay sawdiy duw day jib kwadiy kwasadiy kabaak yakitay tayaan, naydiy dikidiy wapwiy kwurik. ");
INSERT INTO mle_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Duw taakw alim van tidiy. Adiy Juw dayadiy sapakwa nyanugw day dikik rik kwurtaay, wajibaydakib. Day ata wadiy, “Di nuwukadiy duw taakw nyigil-didiy. Aw li di Krais, God dikidi Tasakwudidi Duw tinaad wakuw, ata di dikim nyigil-kwaad!” ");
INSERT INTO mle_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Adiy vay sawdiy duw ab dikik rik kwurkuw, dikik yikuw, nyigiy yil wain kwiydaad kidikikik. ");
INSERT INTO mle_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kwiykuw, day ata wadaad, “Aw li min Juw dayadi yitaypika duw timina, min mina sugwiyaan akwur!” ");
INSERT INTO mle_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jisas apiy abwawa maaj kitawa sukwukuw dikik, vatakadaal: “KIDI DUW JUW DAYADI YITAYPIKA DUWAD.” ");
INSERT INTO mle_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Abir vaal yibir duw nak Jisas diki agikawa maap tidi miyaam tikuw, di Jisasak kupwarapa maaj wadid. Di ata wadid, “Min God dikidi Tasakwudidi Duw-adimin, ay? Yaakiya, min atawa timina, yaakiya ata anawa minaam anyigil!” ");
INSERT INTO mle_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Aw adi nikidi vaal yidi duw diki wadil majik maa wakuw, wadid, “Min Godak maa yag? Min di kiyakida pik kiyakinadimin. Aw an vaal yikuw, atawa kiyakita, aal rivina. Aw kidi duw di simsim vaal maa yi.” ");
INSERT INTO mle_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Di Jisasak ata wadid, “Jisas, min ginyir apawa minadiy duw takwak van tikir yakuw, wunak awuk.” ");
INSERT INTO mle_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisas ata wadid, “Wun a mwiya maaj watuwadimin. Nibwul min wunawa viyakita tipaam kwakinadimin.” ");
INSERT INTO mle_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Nyidi nyi tidik, yin nyi tikitakiydik, nyi si maardilik miyawa tamiy kip gaan kaytik tad. God dikidi wiyaam nimadi wapwiy nyidi wiyaam mwiya kapaba tamiy takatipin tad. Tikuw, ap vitiy pirikiyid. God atawa kwurdil miyawa duw takwak simakak day jaaw dikik yikwadiy. ");
INSERT INTO mle_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisas nimadib ata gaam sad, “Asaay, wuna mawul minabir tabaam takatuwaal!” Atawa wakuw, ata kiyaad. ");
INSERT INTO mle_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Vay sawdiy duw duwamiy tabab dayadi sapakwa duw adiy jaav vikuw, Godak wayapiy sikuw, ata waad, “Mwiya mwiyab kidi duw di samab vaal maa yi!” ");
INSERT INTO mle_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Adiy duw taakw day vagaluwdiy a jaav vikir. Aw day a jaav vikuw, sibinin yidiy dayadiy wiyaar dayadiy mawul kapakap kapakap titaay mapiyim viyataay. ");
INSERT INTO mle_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dikidiy kapa nyanugwawa adiy Galiliy tamiyaam tikuw, diki kwukib yadiy bapa taakw day kwasa sikaam titaay, adiy jaav vidadiy. ");
INSERT INTO mle_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Juw daya wadana tip Aramatiya, a tipa kidi duw Jawsip, di viyakita duwad. Di kavin kwaad God duw takwak van tikidi nyak. Di Juw dayadi kaunsil duw nak tikuw, di maa waad, nuwukadiy kaunsil duw Jisasaam viyasipak wadaak. ");
INSERT INTO mle_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Adi duw Paylatak yad Jisas dikidi amwiyik bas sikir. ");
INSERT INTO mle_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Paylat yaakiya wadik, Jisas dikidi amwiy maap tidi miyaam tidik, Jawsip kwurkuw, kardadid. Kardakuw, di adi amwiy ata wapwiyir kaydapidid. Di Jisas dikidi amwiy kwula dipwu kabakim ata takadid. Tayir adi dipwu kabakim day nikidi amwiy maa tak. ");
INSERT INTO mle_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A nyi Fraide giraab tilik, Sapat nyi ata bas walibab tikir kwuril. ");
INSERT INTO mle_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Adiy Galiliy tamiyab tikuw, Jisas kwukib yadiy bapa taakw, day Jawsipawa yikuw, Jisas dikidi amwiy takadidi kawamiy vidaad. ");
INSERT INTO mle_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vikuw, day dayadiy wiyaar sibinin yikuw, day amwiyim takakwadanadiy marasin kwulapwu-dadiy Jisas dikidi amwiyim takak Sapat nyi kwusilik. Aw day ata yaap kwadiy God diki lo walil pik. ");
INSERT INTO mle_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande mwiya ganbab adiy kwulapwudadiy marasin kwurkuw, adi kawamiyaar yidiy. ");
INSERT INTO mle_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yikuw, day vidaal adi dipwu kabakim takatipidadi nimadi kabaak vatimilsakiykuw, malaam ridik. ");
INSERT INTO mle_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Day dipwu kabakir ata wulakuw, day Jisas dikidi amwiy maa vi. ");
INSERT INTO mle_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Day pitaan wartaay tidaak a javik, duw vitiy jayib nak ata wakwubir dayawa walibab. Birakidiy kwusuw-biridiy wapwiy miyawa kariyadiy. ");
INSERT INTO mle_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","7","Adiy taakw day samasam yagakuw, day makiy gwalikidaak abir duw dayak ata wabiridiy, “Agwa javik gwur kidiy kiyanadiy duw dayaki tamiyaam kwaki-nadiygwurik adi kip kwanadi duwak? Di kilim maa kwu. God bwutaay kirapitakadaad. Gwur lakwugwura di Galiliyaam tikuw, gwurak wadil maaj? Di wadidiygwur, ‘Day duw taakw dayadi Mwaam vaal yikwanadiy duw tabaam takadaak, maap tinadi miyaam katidaak, kiyakuw ridik, nyi mugwula yawaam God kirapitaka-kidaad.’” ");
INSERT INTO mle_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Adiy taakw ata wukin kariyadadiy, adiy tayir wadidiy maaj. ");
INSERT INTO mle_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wukikuw, day adi kawamiy wapakuw, sibinin yikuw, day adiy Jisas dikidiy kalivadidiy tabatiy maan naka duwawa nuwukadiy duw takwak yarik yidadiy. ");
INSERT INTO mle_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Adiy taakw adiy Maria Maktala tipa kil, Jawanawa Maria, Jamis dikil amaay. Daywa nuwukadiy taakw adiy jaav Jisas dikidiy wayakididiy duwak yarik yidadiy. ");
INSERT INTO mle_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aw adiy duw day wukidiy adiy taakw wadadiy maaj mwiya maaj maa wakuw, alik day maa wak. ");
INSERT INTO mle_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aw li Pita rasikuw, adi kawamiyaar gipiyid. Di kwakitan dakuw, adi kawamiyaam Jisas dikidi wapwiyda vidid. Niki jaav maa vi. Vikuw, di ata diki wiyaar sibinin mawul vitiy katiy tikuw yad. ");
INSERT INTO mle_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A nyi dayaam duw vitiy Yimayas wadana tipaar yidiy. A tip Jiruwsalimawa kwasa sikaam ral. ");
INSERT INTO mle_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bir yitaay tibirik, bir awarwa bwulasakiy salabir adiy ababa javik. ");
INSERT INTO mle_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bir atawa bwulataay tibirik, Jisas di diki walibab wakwukuw, nakamwiyib yidiy. ");
INSERT INTO mle_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bir dim vikuw, aw bir mwiyir maa laakw dikim. ");
INSERT INTO mle_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","18","Jisas birakik ata wadibir, “Agwa jaaval awarwa awarwa bwulasakiy salataay, wayibira?” Bir ata tawtaykuw, sarmabap tibir. Biraki duw nak, dikidi si Kiliyapas, ata bas sidid, “Ababa kipa Jiruwsalimaam kwanadiy duw taakw adiy jaav lakwudanadiy. Aw li min duw nak maa laakw kidiy jaav?” ");
INSERT INTO mle_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Di ata bas sidibir, “Agwa jaava?” Bir ata wabirid, “Adi Nasarit tipa kidi duw, Jisas, dim kwurdadiy jaav. Adi duw di God diki maaj wasapwiydi duw nak-ad. Aw dikidiy kwurdidiy yawiyawa kalivadidiy maaj mwiya yitaypik tidiy duw takwawa God dayadiy milaam. ");
INSERT INTO mle_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","“Nyanadiy sapakwa nyanugw pris awa nyanadiy sapakwa nyanugw Jisas Roma tipa kidiy duwak kwiydaad day dim viyasipadakik. Aw day maap tidi miyaam katadaad. ");
INSERT INTO mle_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Nyanadiy mawul wadiy God wayakidid nyan Yisrayil duw takwaam nyigildikik Roma gavman daya tabaam tibaak. A jaav kwurdaal nyab, nyi mugwul aka wana nibwulawa. ");
INSERT INTO mle_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","“Nuwukadiy nyanadiy bapa taakw wadaak jaav nikik, pitaan warnadiyan. Mwiya ganbab day Jisas diki kawamiyaar yikuw, sibinin yakuw nyanak, wadanadiyan day dikidi amwiy maa vi. Aw day nyanak wadanadiyan day God diki maaj kardabir duw vitiy vidanabir. Aw bir dayak wabiradiy, ‘Jisas di kip kwanaad rasikuw,’ wakuw. ");
INSERT INTO mle_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“Nuwukadiy day nyanawa kwanadiy diki kawamiyaar yinadiy. Aw day adiy taakw wadana pik vidanaad. Aw day dim maa vi.” ");
INSERT INTO mle_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jisas birikik ata wadibir, “Bir maa laakw? Birabir mawul pakwun tikuw, adiy God diki maaj wasapwiydiy duw dayadiy maaj bir kwasa kwasa wukijibir tinabirbir! ");
INSERT INTO mle_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","“Day wadiy taay kupwarapa jaav God dikidi Tasakwudidi Duwaam yadaak, ginyir God ata kirapitakadik, di viyakita tipaar wuladik, abab day dikik wayapiy sikidanaad.” ");
INSERT INTO mle_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Taay Mawsis sukwudidiy majawa ababa nuwukadiy God diki maaj wasapwiydiy duw dayadiy sukwudadiy maaj Jisas ata abir duwak kalivadibir ababa dikik wadadiy maaj dayadiy maaw. ");
INSERT INTO mle_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Yibiril tipaar walibab kwurdaak, Jisas di kip yirib yikir kwurid. Aw li abir duw atawa vikuw, bir dikik ata wabirid, “Nyi ada gil pik ridanaad. Gaan aka kwusik tina. Alik tikuw, min anawa adakw ki gaan.” Wakuw wabirik, di biraki majib wukikuw, birikiwa kwakir nakamwiyib yad. ");
INSERT INTO mle_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Birikiwa yikuw, biraki wiyaar wulakuw, jabim daan ridiy. Kikipaat kikir ridaak, Jisas bret kwurkuw, kaysukwa-sukwakuw, Godak wayapiy sikuw, birikik kwiydibir kibirkikik. ");
INSERT INTO mle_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Atawa kwurdik, bir ata jayib nak lakwubirid. Bir lakwubirik, jayib nak di marid. ");
INSERT INTO mle_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mardik, bir birikik ata wasakiy salabir, “Di nakamwiyib yabir anawa maaj bwulayakuw, di God diki maaj anak kalivadik, anabir mawul rakarak tinabir, ay?” ");
INSERT INTO mle_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Jayib nak rasikuw, Jiruwsalimaar sibinin yibir. Yikuw, bir Jisas dikidiy kalivadidiy duw tabatiy maan nak nuwukadiy duw takwawa sitakira-biridiy, day wataay tidiy, “Yitaypika Duw di bwutaay mwiya mwiyab rasinaad! Di Saymanak bwutaay maykaar wakwunaad!” ");
INSERT INTO mle_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Abir duw dayak ata wabiridiy biradiy yabim wukin vibiridiy javiwa Yitaypika Duw bret kwurkuw, kaysukwakuw, bir ata dikim lakwubiridiy maaj. ");
INSERT INTO mle_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bir dayak yarik yitaay tibirik, Jisas di diki dayadiy nyidim wakwukuw, rasin tad. Dayak ata wadidiy, “Kwusidatakaan tikwana mawul gwuraam rawun kwakwa!” ");
INSERT INTO mle_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aw day dim vikuw, yagakuw, pitaan wardiy, “Kad apawul-ad,” wakuw. ");
INSERT INTO mle_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","39","Aw di dayak ata wadidiy, “Gwur agwa javik yaga-nadiygwurik? Yagakuw, niki mawul niki mawul wukibagwu-nadiygwurik? Gwur av wunabir tabawa wunabir manik! Adiy jaay katadadiy kaar vikuw, lakwu-kigwura wun wun-adiwun tinadiwun. Wun sipaam kaykitin av. Vikuw, alaakw apawul kwiyawa ap akis tikwanaad wuna pik.” ");
INSERT INTO mle_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wakuw, di dikibir manwa dikibir taab dayak ata simakadidiy. ");
INSERT INTO mle_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Day rakarak samasam tikuw, dim mwiyir laakw maarkuw, wukibagwudiy. Alik day maa rav dim wukijibir titak. Alik tikuw, di dayak ata bas sididiy, “Gwuraam kamnaagw maa ri?” ");
INSERT INTO mle_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Day yaam tuwdaal kamiy kwurkuw, dikik kwiykuw, di a kamiy kwurkuw, kidil dayadiy mwutamaam. ");
INSERT INTO mle_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jisas dayak ata wadidiy, “Tayir wun gwurawa tikuw, wun watuwadiygwur Mawsis diki lo awa ababa God diki maaj wasapwiydiy duw sukwudadiy majiwa, yitaypika duw Davit sukwudidiy song wakwadana Sam, dayadiy ababa wunak wadadiy maaj mwiya mwiyab tikwadiy.” ");
INSERT INTO mle_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jisas mwugiydik, God diki lapa nyigaam rinadiy maaj dayadiy maaw ata maykaar wakwudiy dayak. Day ata mwiya lakwudadiy dayadiy maaw. ");
INSERT INTO mle_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Di dayak ata wadidiy, “Adiy lapa nyig wanadiy kagil samasam God dikidi Tasakwudidi Duw diki sipaam yilik, kiyakuw rikuw, God ata kirapitakakidaad nyi mugwula yawaam. ");
INSERT INTO mle_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","“Dikidi saam duw taakw nuwukadiy duw takwak wasapwiykwadiy day dayadiy valik wukikuw, bwan kwiydaak adiy valik, God ata yibwiykidadiy dayadiy vaal. Ki yawiy bas taay Jiruwsalimaam kwurkuw, day ata nuwukadiy miyawa jaka tipaar yikwadiy. ");
INSERT INTO mle_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Gwur gwura kidiy ababa jaav bwutaay vigwuradiy. ");
INSERT INTO mle_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Tayir wunadi asaay aban takadil. Ginyir di dikidi Mawul gwurak wayaki-kidaad waad. Wun wuna gwurak wayaki-kituwaad. Aw li taay gwur kavin adakw Jiruwsalimaam yin diki adawur tip wapakida nyak ap gwurak kwiyik.” ");
INSERT INTO mle_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisas taay tip wakwukuw, karaydidiy Bitaniy tip tamiyawa. Yikuw, alim di dikibir taab kirasikuw, di Godak bas sidid di yarakara kwurdikik dayaam. ");
INSERT INTO mle_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Di dayak Godak bas sitaay tidik, di dayaam wapakuw, God ata kwurin kawardid adawur tipaar. ");
INSERT INTO mle_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Day gaba maaj sukwukuw dikik, day rakarak tikuw, ata sibinin Jiruwsalimaar yidiy. ");
INSERT INTO mle_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Day nyanyi God dikidi wiyaam kwataay, Godak wayapiy sidiy. ");
INSERT INTO mle_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mwiya bas God kidi kupw yitak maardil sikir, Jisas Krais, sikiybanaad Maaj-ad wataay, bwutaay tad. Kidi Maaj di nakamwiyib Godawa kwaad. Aw di dibab God-ad. Aw bir nakamwiyib rivriv-abir. ");
INSERT INTO mle_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mwiya basa kasab kidi Maaj nakamwiyib Godawa kwayad. ");
INSERT INTO mle_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kidi Majir God kidi kupwawa miyawa jaav yitakadidiy. Kidi Majir God yitak maar jaav nakab maa ti. ");
INSERT INTO mle_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kidi Maaj adaanada duw taakw nyanyi viyakita mwiy kip kwakwadanadi maaw-ad. Ganim kariya-kwanadi lait kitik tad. Di simaka-kwadadiyan kidi viyakita mwiy kwakibanadi yaab. ");
INSERT INTO mle_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Aal gaan kariyakwana lait a pik, dibab dikidi viyakita yaab simakakwadaad, adiy vaal yiyi tikwanadiy duw taakw dayadiy nyidim titaay. Aw day samab akis rivikwanadiy dim kakil kakilik. ");
INSERT INTO mle_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aw ginyir God duw nak tasakwudid, Jon, diki maaj wasapwiydi duw tidikikik. ");
INSERT INTO mle_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jon diki yawiy aal adiy miyawa duw takwak titaay, kitawa dayak kalivadikik adi yakida duwak, “Di lait kaytik tikinaad,” wataay, aw day mwiyir diki majib wukikuw, wukijibir tidakikik. ");
INSERT INTO mle_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aw Jon di diki adi lait kaytik tikinadi duw maa. Aw di adi lait kaytik tikinadi duwak duw takwak kalivaak yaad. ");
INSERT INTO mle_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Adi kidi kupwaar dadi duw di ad mwiya mwiyaba lait. Aw di adiy miyawa duw takwak kariyaan tikwanaad. ");
INSERT INTO mle_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kidi kupw kidi Majir God yitakadid. Aw di kidi kupwaar dadik, adiy kwadiy duw taakw day samab dim maa vikirakiy. ");
INSERT INTO mle_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Di dikidi kapa jaka tipaar yidil. Aw di dikidiy kapa tipa duw taakw mayaakw maa kwu dikik. ");
INSERT INTO mle_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aw nuwukadiy duw taakw dikik mayaakw kwakuw, di wadidiy majib wukijibir tidalik, alik ti tasakwudidiy, adiy duw takwada, rivikidiy God dikidiy nyanugw tikir. ");
INSERT INTO mle_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ata ata day God dikidiy nyanugw tidakikik wakwukwanadiy? Taakw dayaam sapwiydaak, atawa maa. Duw taakw kirakuw, dayawa nakamwiyib nyan tikwadanalik, atawa maa. Aw duw ay taakw mawul maa. Kal aal God di diki kapaba mawulaar day dikidiy nyanugw tidakikik wakwukwanadiy. ");
INSERT INTO mle_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kidi Maaj ada bwutaay mwiya mwiyaba duw suwulid. Suwulkuw, ada nyana nyidim tad. Nyana nyidim tidik, nyan aal mwiya viyakita ap ata vibaal, di dikid Asaay di dikidi nakamwiya Nyinib tidik, God diki sukwasukw tikwana mawulawa diki mwiyir tikwana maaj ab dim tibir. ");
INSERT INTO mle_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon yarik yididiy God dikidi Nyinik kitawa wadidiy duw takwak: “Bas wun wadiwun, ‘Adi wuna kwukir yakinadi duw di mwiya yitaypik tinaad wunaam. Aw di kip kwayad wuna amaay wunaam sapwiy maarlil sikir.’” ");
INSERT INTO mle_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Aw adi Maaj di nyana danik tikuw, jaab samasam sukwasukw kwurdidiyan. ");
INSERT INTO mle_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","God di diki lo Mawsisaar kwiydil. Aw diki sukwasukw tikwana mawulawa mwiyir tikwana maaj Jisas Kraisaar kwurdidiyan. ");
INSERT INTO mle_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Duw nakab Godaam maa vi. Aw di dikidi Nyinir nakamwiy di dikid Asaaywa kwaad. Aw di diki pik-ad. Aw di nyanak yarik yididiyan dikid Asayik. ");
INSERT INTO mle_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Adiy Juw dayadiy yitaypika duw, Jiruwsalimaam kwadiy, day adiy pris awa Liyvay dikidiy waragaagw wayakidadiy Jonak dikik bas sidakikik, “Min sikadadadimin?” waan. ");
INSERT INTO mle_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aw Jon dayak nimadib kitawa wadidiy, “Wun God dikidi Tasakwudidi Duw maa.” ");
INSERT INTO mle_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aw day dikik maa ata bas sidaad kitawa, “Aw min sikadadadimin? Min God dikidi wasapwiydi duw, Yilayja-adimin?” Aw Jon dayak wadidiy, “Wun Yilayja maa.” Aw day ata maa bas sidaad, “Min adi God dikidi diki maaj wasapwiynadi Duw tayir di abwan takadil wayakik nyanak?” Aw Jon ata dayak wadidiy, “Wun adi duw maa.” ");
INSERT INTO mle_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Adiy pris Jonak ata maa wadaad, “Nyanak ata aw, min ata ata-nadimin? Aw nyan sibinin yikuw, adiy nyanaam wayakinadiy duwak yarik yikibanaala. Alik min nyanak awasapwiy.” ");
INSERT INTO mle_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dayak Jon maa wadidiy, “Mwiya tayir God dikidi diki maaj wasapwiydi duw Aysaya ki wuna yawiy maaj wadil. Di kitawa waad, ‘Duw nak kipa duw taakw ri maarkidana kipa tamiyka tamiyaam titaay, gaam sikinaad. Aw di adi ginyir yakinadi Yitaypika Duw dikidi yakidadi yaab kwulapwu-kidaad.’” ");
INSERT INTO mle_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Adiy maaj karaydiy duw, Parasiy wadadiy bapa kidiy duw wayakidadiy. Aw day ata Jonak bas sidaad, “Aw min God dikidi Tasakwudidi Duw ti maarkuw, awarabab Yilayja ay adi God dikidi diki maaj wasapwiydi duw ti maarkuw, agwa javik duw takwaam guwaam baptais kwiyminadiy?” ");
INSERT INTO mle_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon dayak ata maa wadidiy, “Wun duw takwaam guwaar baptais kwiytuwadiy day God dikidi yabir bas yikuw. Aw wadi gwuradiy nyidim laakw maar kwagwuradi duw, wuda rasin tinaad. Aw diki yawiy wuna yawiyim yitaypik tinaad. ");
INSERT INTO mle_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","“Di wuna kwukir yakinaad. Aw di mwiya yitaypik tinaad wunaam. Aw wun mwiyir ab maa rav dikidiy jaav yataan karay karayik.” ");
INSERT INTO mle_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kal Bitaniy wadaal tipaam mwugiydaal. A tip nyi warkwadawa Jawtan bayibawa ral. A tamiyaam Jon di duw takwaam titaay baptais kwiydidiy. ");
INSERT INTO mle_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sirapik Jon vidid Jisas yadik dikik. Yadik, adiy alim vagaluwdiy miyawa duw takwak, ata wadidiy, “Gwur av! Kidi duw di adiy duw taakw dayadiy valik Godak kwiykwadanadiy badiy duwa sipsip kaytik-ad. Aw li di kidi kupwa kidiy miyawa tamiyaam kwanadiy duw taakw dayadiy vaal kwurin yakikidadiy. ");
INSERT INTO mle_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“Wun kidi duwak bwuladiwun adiy watuwadiy, ‘Duw nak ada wuna kwukir yanaad. Di mwiya yitaypik tinaad wunak. Aw di kip kwaad wuna amaay wunaam sapwiy maarlil nyab.’ ");
INSERT INTO mle_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","“Bas wun dim laakw maartuwil, wun yakuw, guwaar duw takwaam baptais kwiydiwun aw mwiyir Yisrayil jaka tipa kidiy duw taakw diki mwiya maaw lakwudakik di wakwukuw.” ");
INSERT INTO mle_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon ata dayak wadidiy, “Wun vituwid God dikidi Mawul bawul midakim kaytik adawur tipab tikuw, dakuw, diki apiyim daan ridik. ");
INSERT INTO mle_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“Aw wun dim samab maa laakw. Aw adi wunaam duw takwak guwaar baptais kwiytuwkik wayakidi God wunak wadidiwun, ‘Min vikiminaad wunadi Mawul dakuw, duw nak diki apiyim daan ridik. Aw adi duw, di duw takwaam wunadi Mawulaar baptais kwiykidadiy dayadiy mawul warapiydakik.’” ");
INSERT INTO mle_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jon maa ata dayak wadidiy, “Aw a jaav aka bwutaay vituwa. Van napakuw, watuwadiygwurik kidi duw God dikidi Nyan-ad.” ");
INSERT INTO mle_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sirapik maa Jon a tipab kwaad. Adiy kalivadidiy duwa kidiy duw vitiy kip diwa kwabir. ");
INSERT INTO mle_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jon maa vidik, Jisas kwutagir-yakin yidik, birikik ata wadibir, “Av! Wadaay duw di mwiya adiy duw taakw day dayadiy valik Godak kwiydadiy badiy duwa sipsip kaytik-ad. Aw God wayakidid.” ");
INSERT INTO mle_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Adiy kalivadidiy duw kidiy duw vitiy dikiwa kwabir, atawa wadil maaj wukin napakuw, bir ata dim wapakuw, Jisas kwukib yibir. ");
INSERT INTO mle_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas tipatiyakwukuw, vidil diki kwukib yibirik, ata bas sidibir, “Bir agwa javik?” Bir ata dikik wabirid, “Rapay, min akim kwakinadimin?” Ki “Rapay” waan wabiril kwasa maaj liki mwiya maaw maaj “Kalivakwanadi duw” tina. ");
INSERT INTO mle_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jisas birikik ata wadibir, “May! Yakuw, av.” Bir ata dikiwa nakamwiyib yibir. Yikuw, ata vibiril di kwadil tamiy. Bir diwa yibiril, kwasa ganib-al. Nyi 10 klok tidil-al. Aw bir adi miyawa nyi dikiwa kwabirid. ");
INSERT INTO mle_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Abir Jon wadil maaj wukikuw, Jisas kwukib yibir vitiya duw nak Adiruw-ad, Simon Pita waan wakwadanadi duw dikidi nyamwus-ad. ");
INSERT INTO mle_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aw Adiruw jayib nak sitakiradid dikidi mwaam, Simon. Sitakirakuw, ata yarik yidid, “Nyan bwutaay Krais sitakira-banaad.” Ki kwasa maaj “Krais” liki maaw aal God dikidi Tasakwudidi Duw. ");
INSERT INTO mle_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Atawa yarik yan napakuw, Simonaam ata kwurin karaydid Jisasak. Jisas Simonaam vikuw, ata wadid, “Min Jon dikidi nyan, Simon-adimin. Nibwulab kiraayrib sikiy-kidanadimin ‘Siypas’ waan.” Kidi si Siypas Pita waan sikiykwadanadi sawa rivriv-ad. Kapab maa. Kidi Pita waan sikiykwadanadi si diki mwiya maaw “nimadi kabaak” waan. ");
INSERT INTO mle_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Sirapik Jisas ata Galiliy tamiyaar yikir wukid. Di ata sitakiradid Bitsayta tipa kidi duw, Pilip. Pitawa dikidi nyamwus Adiruw birabab a tipa kibirabir. Pilipaam sitakiran napakuw, Jisas dikik ata wadid, “Wunawa may!” ");
INSERT INTO mle_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aw Pilip Nataniyilaam sitakirakuw, ata wadid, “Nyan bwutaay vibanaad, adi Mawsis God diki lo rilil lapa nyigaam sukwudil majiwa adiy God diki maaj wasapwiydiy duw God diki lapa nyigaam sukwudadiy maaj bwuladadi duw. Di Jisasad, adi Nasarit tipa kidi duw, Jawsip dikidi nyanad.” ");
INSERT INTO mle_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyil Pilipak ata bas sidid, “Ata ata mwiyir Nasarit tipaam viyakita jaav yakina?” Aw Pilip dikik ata wadid, “May! Ata yakuw, av.” ");
INSERT INTO mle_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisas vidik Nataniyil dikik yataay tidik, dikik ki maaj ata wadil, “Kidaanada mwiya mwiyaba Yisrayil jaka tipa kidi duw. Di samab akis gwiyip kwurkwanaad.” ");
INSERT INTO mle_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Aw Nataniyil ata Jisasak bas sidid, “Min ata ata wunaam lakwu-minadiwun?” Aw Jisas ata wadid, “Wun vituwadimin adi vik wakwadanadi miy min diki lagwum daan rimina, Pilip minak gaam si maarda sikir.” ");
INSERT INTO mle_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aw Nataniyil Jisasak ata wadid, “Gaba maja duw, min God dikidi Nyan-adimin! Min-adimin, Yisrayil jaka tipa kidi Yitaypika Duw!” ");
INSERT INTO mle_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aw Jisas Nataniyilak ata wadid, “Aka wukijibir timina minak yarik yituwalik aal vik wakwadanadi miy diki lagwum daan riminik vituwalik tikuw, ay? Aw vikiminadiy ki javim maa mwiya yitaypik tikinadiy jaav.” ");
INSERT INTO mle_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jisas dayak maa ata wadidiy, “Gwurak mwiya mwiyaba maajal watuwa, gwur vikigwuraad adawur tip kajidik, adi God di dikidiy diki maaj kardadiy duw warin daan wunak tidaak, adi duw taakw dayadi Mwaam.” ");
INSERT INTO mle_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Nyi vitiy kwusibirik, Kana wadaal tip Galiliy tamiyaam duw nak taakw kiraad. Alik day Jisas diki amaywa dikidiy kalivadidiy duwak wapawap sidadiy yadakikik, yakuw adi duw taakw kiradik vidakikik. ");
INSERT INTO mle_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Aw day abir duwawa takwak bayaki kikipaat kwurdiy. Adiy bayaki kikipaat kwurdiy duw taakw day adiy wain wakwadanadiy guw miyawa kikwusidadiy. Kikwusidaak, aw Jisas diki amaay dikik ata walid, “Dayadiy miyawa wain bwutaay kwusinadiy.” ");
INSERT INTO mle_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisas ata diki amayik ata wadil, “Amaay, wunak wa-tikwa. Wun wuna yawiy kap kwurkidiwun. Kita wunakil duw takwak wunaki ap simaka nyi maa nibway ti.” ");
INSERT INTO mle_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aw Jisas diki amaay ata walidiy adiy yawiy duwak, “Kip kwurlib akwur di wakidadiy yawiyib.” ");
INSERT INTO mle_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aw Juw duw taakw day dayakil gaba maja yawiyik talab kwuryadaal atawa, sip janyikwadaal yawiy. Aw a yawiyik nimadiy vaak abwun alim tidiy. Adiy vaak dayadiy nimadiy adiy nimadiy kupwa vaak kaytikadiy. ");
INSERT INTO mle_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas adiy yawiy duwak wadidiy guw tuwdakik adiy vakaam. Aw day ata tuwdaak, ababa vaak guwawa wapwurukwun tidiy. ");
INSERT INTO mle_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","10","Aw Jisas ata dayak wadidiy, “Wadiy vakaam tinadiy guw tuwkuw, kwurin karaykuw, adaay bayaki kikipatik van tinadi duwak akwiy.” Aw adiy yawiy duw Jisas wadil pik day adiy vakaam tidiy guw tuwkuw, ata kwurkuw karaydadiy adi duwak. Karayin kwiydaak, di kwurkuw ata kikitadid adi karaydadi wain suwuldi kipa guw. Aw adi duw samab maa laakw adi wain yadil tamiy. Aw adiy vakaam tidiy guw kwurkuw kariyadiy yawiy duw day bwutaay lakwudaal adi wain kwurdaal tamiy. Aw adi bayaki kikipatik van tidi duw ata wataydid adi taakw kiradi duwak. Wataykuw, ata wadid, “Miyawa duw taakw dayak mwiya basa kasab adi mwiya viyakita wain kwiykwadanadiy. Aw ginyir adiy duw wain samasam kidaak, dayadiy mawul pakwudaak, ata ginyir adi kwasa viyakit tikwanadi wain kwiykwadanadiy. Aw min kidi mwiya viyakit nyanak basa kasab kwatiya maarkuw, aw ada kwatiya-minaad!” ");
INSERT INTO mle_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kidi Jisas dikidi mwiya basa kwurdidi nimadi yawiy aal Galiliy wadaal tamiyawa ril kwasa tip Kanaam. Aw ata simakadidiy dikidi ap, aw adiy di dikidiy kalivadidiy duw ata dikik wukijibir tidaad. ");
INSERT INTO mle_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ginyir Jisas diki amaywa dikidiy nyamwusugwawa adiy dikidiy kalivadidiy duwawa ata Kapanayam wadaal tipaar wakwudiy. A tipaam nuwukadiy nyi alim kwadadiy. ");
INSERT INTO mle_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aw adi Juw duw takwaam God Nyigildidiy bayaki kikipata Nyi walibab tidilik tikuw, Jisas ata adi bayaki kikipatik yad Jiruwsalimaar. ");
INSERT INTO mle_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yikuw, adi God dikidi wiyaar kwusapwiyin wulakuw, alim vididiy adiy duw bulmakau awa sipsip awa bawul midakim kaytika wapiy titaay takw takadaak. Adiy saan warapiydiy duw ab vididiy daan ridaak jabim sanawa. Duw taakw adiy animal awa wapiy yapiykuw, Godak ata kwiydadiy dayadiy valik vaal kwurik. Adiy saan warapiydiy duw nuwukadiy jaka tipa kidiy saan God dikidi wiya kidiy sanawa warapiy-dadiy. ");
INSERT INTO mle_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aw Jisas atawa vikuw, yaal samasam girakuw, jikiy kwurkuw, adi jikiyir adiy bulmakau awa adiy nuwukadiy jaav viyayaki-didiy God dikidi yala wiyaam tidaak. Viyayakin napakuw, adiy animal awa dayadiy dayak van tidiy duw nakamwiyib tabwuwakwudaak, adiy saan warapiydiy duw ridadiy jaab ata wabalakididiy. Wabalakidik, adiy dayadiy saan ata miyawa tamiyaar yikit-akitadiy. ");
INSERT INTO mle_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jisas ata adi bawul midakim kaytika wapiy warapiydiy duwak ata wadidiy, “Wadiy bawul midakim kawaar kwurin akarakw. Kidi wunadi Asaay dikidi wiy takwa tipanig mwugiy-tikwa!” ");
INSERT INTO mle_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aw ata dikidiy kalivadidiy duw ata wukin kariyadaal aal kitawa God diki lapa nyigaam ril maaj: “God, minadi wiy di mwiy viyakitad. Minadi wiyak wuna mwiya samasam wukinadiwun. Di wuna mawulaam kapwun kwanaad.” ");
INSERT INTO mle_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aw adiy Juw dayadiy yitaypika duw ata Jisasak bas sidaad, “Minak sikadadaad wanaad atawa kwurminkik? Nyanak ata asimak nimadi yawiy aw nyan vikuw, wanaak, ‘Bwu rivinadimin atawa kwurmina,’ waan.” ");
INSERT INTO mle_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aw Jisas ata dayak wadidiy, “Kidi God dikidi wiy miyawa pirakuw, nyi mugwula yawaam ata miyawa sibinin kwurkituwaad.” ");
INSERT INTO mle_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aw day maa Jisasak bas sidaad, “Atata atata kidi wiy kipa nyaar mugwulaar sibinin kwurkiminaad? Kidi wiy nabiyir nabiyir duwamiy vitiy sap abwun kwurdadi wiy-ad.” ");
INSERT INTO mle_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aw Jisas wadil di adi God dikidi wiyak maa bwul. Di diki kapa amwiyik bwuladilal. Kiyakuw, rikuw, nyi mugwula yawaam rasikidalik. ");
INSERT INTO mle_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aw ginyir Jisas kiyakuw ridik, God kirapitakadik, adiy Jisas di dikidiy kalivadidiy duw ata wukin kariyadaal ki Jisas wadil maaj. Aw a nyab ata wukijibir tidiy adiy God diki lapa nyigaam Jisas diki kiyadik God dim kirapitakakida nyak walidiy majib. ");
INSERT INTO mle_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas di kip Jiruwsalimab kwakuw, aal God Juw duw takwaam Nyigildidiy bayaki kikipata Nyaam samasama duw taakw adiy Jisas kwurdidiy nimadiy yawiy van napakuw, ata day dikik wukijibir tidiy, ‘God dikidi Nyan-ad,’ wakuw. ");
INSERT INTO mle_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Aw Jisas di miyawa duw taakw dayadiy mawul dayadiy maaw bwutaay lakwudidiy. Alik tikuw, duw nakab di dikik adiy duw taakw dayadiy mawulak wasapwiy wasapwiy day maa rav. Aw di duw taakw dayadiy mawul warapiy-kwadana lakwudilik, Jisas di adiy duw takwak di diki maaw samab maa yarik yi. ");
INSERT INTO mle_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Duw nak, dikidi si Nikadimas, Juw dayadi yitaypika duw nakad. Parasiy dayadi bapa kidi duwad. ");
INSERT INTO mle_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Gaan nak Nikadimas Jisasak yad. Yakuw, dikik ata bas sidid, “Kalivakwanadi duw, nyan bwutaay lakwu-banadimin min God nyanak wayakididi duwadimin. Duw nakab wadiy kwurminadiy nimadiy yawiy pik, aw God dikidi ap kwur maarik-da, di samab kwurkwur maa rav.” ");
INSERT INTO mle_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Aw Jisas ata dikik wadid, “Wun minak mwiya mwiyab maajal wakituwa. Tayir duw taakw dayadiy amaay sapwiydaal pik God mwugiydik, day dikidi gwalugwur wulakidiy. Aw nikidi yaab maa ti duw taakw dikidi gwalugwur wulawulak.” ");
INSERT INTO mle_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikadimas Jisasak maa bas sidid, “Atata atata nimadi duw maa kwasa nyan kaytik suwulkinaad? Ata ata jaab nakab maa diki amaay yalaar maa wulakinaad? Ay? Jaab nakab maa ginyir sapwiykilaad? Ay?” ");
INSERT INTO mle_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas maa dikik ata wadid, “Mwiya maaj minak watuwadimin. Aw li duw guwaar baptais kwur maarkida, God dikidi Mawulaar baptais kwur maarkida, di samab wul maa adi God van tidadi tipaar. ");
INSERT INTO mle_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","“Aw li adi mwiya taakw sapwiykiladi duw, di mwiya duw taakw amwiy kwurkida. Kwurkuw, mwiya duw tikinaad. Aw li adi God dikidi Mawul mwugiykidadiy, duw taakw day kwulakakwula mawul kwurkuw, ata day mwiya kwulakakwula duw taakw suwulkuw, kwakinadiy. ");
INSERT INTO mle_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Minak atawa watuwalik pitaan wartikwa, ‘Aw li adi kwasa nyan kaytik ti maarkinadi duw ay taakw, di ay li samab riv maa wulawulak adi God duw takwaam van tidadi tipaar.’ ");
INSERT INTO mle_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Mwar tamiy nak akis viyakwana. Miyawa tamiyaar viyayi viyayakwana. Aw min li viyakwala pipiliyda wukikwamina, aw min viyakwala tamiyawa yikwala tamiy samab akis lakwukwamina. Atampik tikwanaad, duw takwak God dikidi Mawul dayak kwula mawul lawtaka-kwada.” ");
INSERT INTO mle_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Aw Nikadimas Jisasak ata wadid, “Ata ata atawa tikina?” ");
INSERT INTO mle_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Aw Jisas dikik ata wadid, “Min Yisrayil jaka tipa kidiy duw taakw dayadiy mwiya yitaypika gaba maja duw nak minadimin. Aw min samab ki jaav maa laakw?” ");
INSERT INTO mle_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aw Jisas maa ata wadid, “Wun minak mwiya mwiyaba maajal watuwa. Wunawa wunadiy kalivatuwadiy bapa duw bwula-kwabanadiy jaav, nyan lakwu-kwabanadiy jaavadiy. Nyan bwutaay kapa milaar vibadiy jaavadiy. Aw gwur Juw duw taakw samab nyanadiy majib wukijibir ti maa. ");
INSERT INTO mle_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","“Aw li gwur wunadiy gwurak kidi kupwaam rinadiy javik gwurak watuwik, aw wukijibir ti maarkigwura, aw ata ata wukijibir tikinadiygwur adawur tipaam rinadiy javik gwurak wakituwa? ");
INSERT INTO mle_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Kidi kupwaam kwanadiy duw taakw nakab maa adawur tipaar warkuw, God diki rida mil mwutaam van ti. Aw wun duwaar nak, gwuradi Mwaam, kidi kupwaar dadiwun adawur tipaam tikuw. Aw wun bwunak wakituwadiygwurik God diki rida sukwawa diki mil mwutaam. ");
INSERT INTO mle_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Mwiya tayir Mawsis di tamiyka tamiyaam tidil sikir, di adi kapa ar viyataka-dadi kabaay aad miyaar kirasikuw, vatakadid aw adiy God wadil majik wukijibir tidiy duw taakw adi kabaay kayikak kituw vikuw, kiy maardakik mwiya kabaay dayaam vatadaak. ");
INSERT INTO mle_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","“Alik tikuw, adiy miyawa duw taakw wunak wukijibir tikidiy, day nyanyi nyanyi Godawa kwakidiy. ");
INSERT INTO mle_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Aw God miyawa duw takwak samasam wukikuw, mawul yididiy. Atawa yidilik tikuw, di kwiydid di dikidi mwiya mwiyaba nakamwiya Nyan aw mwiyir adiy dikik wukijibir tikidiy duw taakw Godak kajikuw ti-yaay, dikiwa nyanyi nyanyi kip kwaya-kidiy. ");
INSERT INTO mle_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Aw God wun, dikidi Nyan, kidi kupwaar wayakidik dadiwun duw takwak. Jas kaytik tituwkikik maa wayak. Aw wun mwiyir dayaam nyigil-tuwkik wayakididiwun. ");
INSERT INTO mle_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“God di adiy dikidi Nyinik wukijibir tikidiy duw takwaam kotiy maa. Aw adiy dikidi nakamwiya Nyinik wukijibir ti maardiy duw taakw wukijibir ti maardalik tikuw, alik God bwutaay tasakwudidiy adiy duw taakw kupwaraap kwayadakik. ");
INSERT INTO mle_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“A danik tikuw, God dayaam kupwaraap kwurkidadiy. Adiy kupwarapa jaav kwurjibir tikwanadiy duw taakw dayadiy yikwadanadiy vaal gaan van tikwanadiy. Aw wun lait kaytik dadiwun. Aw adiy kupwarapa jaav kwurjibir tikwanadiy duw taakw dayadiy mawul ganik yitaay, aw lait ak kwasik yikwanadiy. ");
INSERT INTO mle_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","“Adiy vaal yiyi tikwanadiy duw taakw day wunak kwasik yikwanadiy. Aw lait mwugiylik, adiy ganim tikwanadiy jaav maykaar wakwukwanadiy. Day dayadiy vaal maliykaar wakwu-wakwuk kwasik yikwanadiy. Alik day wunak kwasik yitaay, bwan kwiykwadanadiwun. ");
INSERT INTO mle_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","“Aw adiy duw taakw day viyakita yawiyda kwurkwanadiy, day wunak yakwanadiy. Aw wun mwiyir adiy nuwukadiy duw takwak simaka-kituwadiy kidiy duw taakw day mwiya God diki majib wuki-wukib tikwanadiy waan.” Kidiy ababa maaj Nikadimasak wadidiy maajadiy adi Parasiy bapa kidi duwak. ");
INSERT INTO mle_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kidiy jaav kwusidaak, Jisas di dikidiy kalivadidiy duwawa ata Juwtiya tamiyaar yididiy. Yikuw, alib dayawa nuwukadiy nyi kwadidiy. Aw dikidiy kalivadidiy duw a tamiya kidiy nuwukadiy duw takwaam ab baptais kwiydadiy Jisas dayaam tasakwudik. ");
INSERT INTO mle_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon ab Salim wadaal tipawa walibab ril tip, Aynan, a tipaam duw takwaam titaay baptais kwiydidiy, aw a tamiyaam samasama guw rililik tikuw. ");
INSERT INTO mle_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","A sikir day Jonaam kalabus ir kwusawula maardaak, kip tad. ");
INSERT INTO mle_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Juw duw nak Jon dikidiy kalivadidiy duwawa titaay, dayawa maaj bwulasakiy salataay, wadidiy, “Ki Jisas duw takwak kwiydi baptais, Jon dikidiy duw takwak kwiykwadi baptais im yitaypik tina.” ");
INSERT INTO mle_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aw adiy Jon dikidiy kalivadidiy duw dikik yikuw, ata wadaad, “Gaba maja duw, min lakwuminaad adi minawa Jawtan bayib agika gikim tidi duw, adi waminidi duw, ‘Di Godab danaad,’ waan. Kita ada di duw takwaam baptais kwiynaad. Aw miyawa duw taakw adiyka minaam wapakuw, dikik yinadiy.” ");
INSERT INTO mle_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aw Jon dayak ata wadidiy, “Duw nakab God dim tasakwu maardik a jaav kwurdikik, di samab kwar maa. ");
INSERT INTO mle_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Aw gwur lakwugwuradiy adiy watuwidiy maaj, ‘Wun God dikidi Tasakwudidi Duw maa, aw God wayaki-didiwun diki tayir yikuw, dikidi yakidadi yaab kwulapwutuwkik.’ ");
INSERT INTO mle_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Aal duw kirakida taakw aal dikilal, nikidi duw dikil maa. Aw adi duw dikidi nawiy duw dim vikuw, wukidik a taakw kirakida, di mwiya rakarak samasam tikinaad dikik. Atampik adiy duw taakw Jisasak yidanalik, wun mwiya mwiyab rakarak samasam tinadiwun. ");
INSERT INTO mle_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","“Aw di mwiya yitayaki-kinaad wunak, aw wun dikik yisadayaki-kinadiwun.” ");
INSERT INTO mle_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jon dikidiy kalivadidiy duwak ata wadidiy, “Adi adawur tipab danadi duw di miyawa duw takwak mwiya yitaypikad. Wun kidi kupwa kidi duw-adiwun. Alik kidi kupwa jaav lakwuyaki-tuwadiy. Di adawur tipa kidad. Alik adawur tipa kidiy jaav miyawa lakwuyaki-dadiy. Alik tikuw, di mwiya yitaypikad wunak. ");
INSERT INTO mle_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","“Di duw takwak kaliva-kwadadiy adiy vikuw wukididiy javadiy. Aw day diki majik mayaakw akis kwayakwanadiy. ");
INSERT INTO mle_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","“Adiy God diki majik wukikuw wukijibir tikinadiy duw taakw, day adiy nuwukadiy duw takwak simakakidanadiy, ‘God diki maaj aal mwiya mwiyaba maaj tikwana,’ waan. ");
INSERT INTO mle_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","“Kidi Jisas God wayakidid. Aw God dikidi Mawul miyawa dikik kwiydilik tikuw, alik di ad God diki maaj bwulakwanaad. ");
INSERT INTO mle_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Aw Asaay di dikidi Nyinik mawul samasam yikuw, bwutaay ababa jaav diki tabaam takadidiy. ");
INSERT INTO mle_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Adiy duw taakw day God dikidi Nyinik wukijibir tikidiy, nyanyi nyanyi viyakita mwiy Godawa kwayakinadiy. Aw adiy duw taakw God dikidi Nyinik mayaakw kwa maarkidiy, day Godawa kwu maa. Aw God diki yaal girakwana mawul dayawa nyanyi nyanyi tikina.” ");
INSERT INTO mle_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Adiy Parasiy wadadiy bapa duw adiy Jisasak yadaak, baptais kwiydidiy duw taakw adiy Jonak yadaak baptais kwiydidiy duw takwaam kakildil maaj ata wukidaal. ");
INSERT INTO mle_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aw Jisas di duw takwaam baptais maa kway. Adiy dikidiy kalivadidiy duwada baptais kwiydiy duw takwaam. ");
INSERT INTO mle_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","Jisas atawa duw taakw di kwurdil yawiyik wadaal maaj wukikuw, di maa wakuw day dim yakisuwtakadakik aw adiy Parasiy dayadiy mawul warik-nadiy a javik. Ata Juwtiya tamiy wapadil. Wapakuw, Galiliy tamiyaar sibinin yad maa. Adi di yididi yaab Samariya tamiyarib yad. ");
INSERT INTO mle_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Adi yabirib yikuw, di Samariya tamiyaam ril tipaar wulaad. A tip liki si Sikar-al. A tip mwiya tayir Juw dayadi warag Jakap dikidi nyan Jawsipak kwiydil kupwawa walibab ral. ");
INSERT INTO mle_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Adi mwiya tayir Jakap kip kwakuw, vadidi makuw ab kip rad. Aw Jisas nimadi yaab yadilik, diki sip sakwiyil. Alik tikuw, yaap rad daan adi mala makuwa. Mwiya giraabal kwasa gaan varugwadim nalilal. ");
INSERT INTO mle_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jisas di kap kwaad. Aw adiy dikidiy kalivadidiy duw tipaar yidiy kamnaagw yapiyik. Aw Samariya tamiya kil taakw adi makuwur yaal guw tuwik. Yalik, Jisas likik ata wadil, “Wunak guw kwatiyanyin, guw kaw.” ");
INSERT INTO mle_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A taakw Jisasak ata walid, “Min Juw duwadimin. Wun Samariya kil taakw-awun. Aw agwa javik tikuw wunak bas siminawun guw minak kiminkikik kwatiyatuwkik?” Aw li Jisasak ata walil, aw adiy Juw tamiya kidiy duw taakw adiy Samariya kidiy duw takwak bwal as kaytik kwakwanadiy wataay wakwadanadiy. Aw adiy Juw tamiya kidiy duw taakw adiy Samariya kidiy duw taakw dayak wakwadanadiy adi kapab simsim guw kamnaagw-adiy adi kapab akis kwurin kikwanadiy. Subw yikwadanadiy dayak. ");
INSERT INTO mle_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aw Jisas likik ata wadil, “Aw li nyin mwiyir vikuw, lakwuk-nyina aal God duw takwak kwiydil jaav, aal lakwuk-nyinadiwun wunaam. Lakwukuw, bas sikik-nyinadiwun guwak aw wun ata guw kwatiyak-tuwanyin di nyinaam mwugiydik, nyanyi nyanyi viyakita mwiy kwanyinkikik.” ");
INSERT INTO mle_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","12","Aw li dikik ata walid, “Nimadi duw, min vaak samab maa kwurin ri. Kidi makuw kaw danaad. Aw akim duw takwaam viyakita mwiy nyanyi nyanyi kwadakikik mwugiy-kwanadi guw tuwkuw, kwiykiminadiy kidakikik? Aw nyanadi waraga duw, Jakap, kidi makuw kwiydid nyanak. Diwa dikidiy nyanugw taakw bulmakau awa sipsip kidi makuwub guw kwurtaay, kidiy. Aw min wanadimin, ‘Wun Jakapaam yitaypik tinadiwun,’ waan? Aw min nikidi kapaba guw nyanak kwatiyak wanadimin, ay?” ");
INSERT INTO mle_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","Jisas likik ata wadil, “Adiy kidi makuwum guw tuwtaay kikidiy duw taakw day ginyir maa guw kikir yisada yisa-kinadiy. Aw li adiy duw taakw wun dayak kwiykituwadi guwaam kwurkuw kikidiy, day ginyir guw kikir samab yas maa. Adi makuwum wartaay, wapwurukwun rikwanadi guw kaytik kil maa. Aw ad kidi wun kwiykituwadi guwad. Aw duw taakw dayadiy mawulaam mwugiydikib, day kip nyanyi nyanyi viyakita mwiy kwakidiy Godawa.” ");
INSERT INTO mle_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aw a taakw li wukil Jisas kipa guwak wanaad wakuw, dikik ata maa dikik ata maa walid, “Nimadi duw, wunak adi guw akwutay. Kwatiyaminik, aw wun ginyir guw kikir yisada yas maa. Awarab wun kidi makuwur guw tuwik varada var maa.” ");
INSERT INTO mle_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aw Jisas likik ata wadil, “Maay! Yikuw, nyinadi lanik wakuw, may sibinin kiril.” ");
INSERT INTO mle_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","“Wun laan maa ri,” a taakw ata walid Jisasak. Aw Jisas ata wadil, “Mwiya maajal wanyina, ‘Wun laan maa ri,’ waan. Nyin laan tababak rilnyin. Aw adi kita rinyinadi duw, di mwiya nyinadi laan maa. Wunak wanyina maaj mwiya maajal.” ");
INSERT INTO mle_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","20","Aw a taakw Jisasak maa ata walid, “Nimadi duw, adiy pakwun rinadiy wun kwurtuwidiy ababa jaav lakwuyaki-minadiy. Wun wukituwa min God dikidi diki maaj wasapwiykwanadi duwadimin. Ay? Wunadiy waraga duw taakw Samariya tamiya kidiy Godak kidi nibwukim gaba maaj sukwuyikwadiy. Aw gwur Juw duw taakw gwur wakwanadiygwurik nyan Samariya tamiya kidiy duw taakw Jiruwsalimaar yabakikik alim Godak gaba maaj sukwubakik.” ");
INSERT INTO mle_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","Aw Jisas a takwak ata wadil, “Nyin wun watuwa majib wukijibir ada. Nyinak watuwanyin, ginyir duw taakw samab nyanadi Asaay Godak tamiy nikim ay kidi nibwukim ay Jiruwsalimaam gaba maaj sakw maa. Aw day miyawa tamiyaam gaba maaj sukwukidiy dikik. Gwur Samariya tamiya kidiy duw taakw gwur samab maa laakw adi gaba maaj sukwu-kwagwuradi Godaam. Aw nyan Juw duw taakw nyan mwiya mwiyab lakwubanaad kidi gaba maaj sukwu-kwabanadi God. Alik tikuw, adi miyawa duw takwaam Nyigilkinadi Duw Juw duw takwab yanaad. Nyi yakina, aw akaanaka kita, duw taakw yarakara nyanadi Asayik gaba maaj sukwukidana nyi. Adiy duw taakw-adiy God mawul yikwadadiy dikik gaba maaj sukwudakik. God di mwar kaytikad. Duw taakw dikim samab akis vikwadanaad. Alik tikuw, nyanadiy dikik sukwu-kibanadiy gaba maaj mawulaar sukwukuw, aw mwiya mwiyab tikwadiy.” ");
INSERT INTO mle_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aw a taakw ata Jisasak walid, “Wun lakwutuwa God Tasakwudidi Duw, wakwadanaad Krais, dakinaad. Aw di dakuw, miyawa jaav simakayaki-kidadiyan yarakara.” ");
INSERT INTO mle_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aw Jisas likik ata wadil, “Wun-adiwun, adi duw kika nyinawa tan bwula-nadiwun.” ");
INSERT INTO mle_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jisas likiwa atawa bwulataay tidik, adiy kamnagwuk tipaar wuladiy dikidiy kalivadidiy duw ata sibinin yadiy. Yakuw, pitaan wardiy Jisas a takwawa tan maaj bwuladilik. Aw daya duw nakab a takwak bas maa si, “Agwa javik yananyinik?” waan. Aw daya duw nakab Jisasak ab bas maa si, “Agwa javik likiwa maaj bwulanadimin?” waan. ");
INSERT INTO mle_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Aw a taakw ata adi likidi guw tuwlidi vaak adi mala makuwa wapalik ridik, ata tipaar yapwur yapwur gipayil. Yikuw, alim kwadiy miyawa duw takwak ata yarik yilidiy. “Gwur may! Yakuw av adiy wun mwugiy-kwatuwidiy miyawa jaav wasapwiynadi duwaam. Aw atawa wadalik tayir wunaam vi maarkuw, adi duw kipab God Tasakwudidi Duwad way?” ");
INSERT INTO mle_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aw adiy duw taakw ata tip wapakuw, Jisasak yidiy abab. ");
INSERT INTO mle_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A taakw sibinin tipaar yikuw, adiy duw takwak wataay tilik, Jisas dikidiy kalivadidiy duw dikik wadaad, “Gaba Maja Duw, kamnaagw ak,” waan. ");
INSERT INTO mle_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aw Jisas dayak ata wadidiy, “Wunaam kamnaagw rina kikak aw gwur maa laakw a kamnagwum.” ");
INSERT INTO mle_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aw adiy dikidiy kalivadidiy duw ata day dayak awarwa awarwa ritaay bwulasakiy saladiy, “Nuwukadiy duw taakw dikik yakuw, kamnaagw kwiydanaad?” ");
INSERT INTO mle_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aw Jisas maa dayak ata wadidiy, “God diki kupwaar wayakididiwun. Wayakikuw, kwurtuwkik wadil yawiy kwurkwusi-kinadiwun. Wuna kamnaagw kaytik akaanaka. ");
INSERT INTO mle_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Kamnaagw mayim san napataay, gwur wakwanadiygwurik, ‘Bap aliy yakuw, yin kwusidaak, ata nyan dayadiy mwiy kwurkibanadiy.’ Aw wun gwurak watuwadiygwurik, yarakara av wadiy Samariya tamiya kidiy yanadiy duw takwak. Day adiy mayim sigwuradiy kamnaagw kaytik-adiy. Day adiya bwutaay mwiyir nimadiy tinadiy dayaam kwurkwurik. ");
INSERT INTO mle_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Adiy wunak yawiy kwurtaay duw takwaam kwurjuw-kinadiy wunadiy tidakikik, day kipakip maa yawiy kwar. Adiy kwurkigwuradiy duw taakw day nyanyi nyanyi Godawa nakamwiyib kwakinadiy. Atawa kwurtaay, aal wunaki viyakita maaj nuwukadiy duw takwak titaay, wasapwiykinadiy duw taakw day aal kadiy mwiy mayim sikwanadiy duw taakw kaytikadiy. Aw adiy duw taakw wunab wukijibir tidakikik mwugiykinadiy duw taakw, day adiy lawnadiy mwiy mayim tidaak kwurkwanadiy duw taakw kaytikadiy. Aw day nakamwiyib rakarak tikinadiy. ");
INSERT INTO mle_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Kil kitawa wagwura maaj aal mwiya maajal. Gwur wakwanadiygwurik, ‘Nikidi duw mayim taba jaav sidik, nikidi duw adiy mwiya mwiy kwurkinaad.’ ");
INSERT INTO mle_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","“Aw wun wayakituwidiygwurik wunak duw taakw vagaruw-gwurkik. Adiy mayim warkwanadiy jaav dayadiy mwiy vagaruw-kwadana pik, gwur vagaruw-gwuridiy. Aw nuwukadiy duw taakw bwutaay mwiya basa kasab wuna maaj wasapwiydaal, adiy duw takwak day adiy mayim kadiy sina pik sidadiy. Aw gwur maa kwar a yawiy. Aw day atawa kwurdaal yawiy, gwuraam sugwiyaan kwur-lidiygwurik gwuradiy yawiyik.” ");
INSERT INTO mle_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Adiy Samariya tamiya kidiy duw taakw day samasam Jisasak ata wukijibir tidiy, aw a taakw dayak adiy li kwuryi-kwalidiy miyawa jaav Jisas wasapwiydilik tikuw, aw li yin dayak yarik yililik tikuw. ");
INSERT INTO mle_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Aw adiy Samariya tipa kidiy duw taakw yakuw, dikik yarakara bas sidaad dayawa kwadakikik. Aw Jisas ata dayawa nyi vitiy alib kwadibir. ");
INSERT INTO mle_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","42","Aw samasama duw taakw day Jisasak wukijibir tidiy aw di diki bwuladidiy maja danik. Aw day a takwak ata wadaal, “Nyan aka mwiya maajal wukikuw, wukijibir tinadiyan, aw nyin wanyinalik tikuw maa. Nyan nyana bwutaay wukikuw, lakwubanaad di adi kidi kupwa kidiy duw takwaam Nyigil-kinadi Duwad.” ");
INSERT INTO mle_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Aw Jisas alim kwadik nyi vitiy kwusibirik, ata dayaam wapakuw, Galiliy tamiyaar yad maa. ");
INSERT INTO mle_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mwiya basa kasab Jisas waad, “Adiy God dikidiy diki maaj wasapwiy-kwanadiy duw adiy day dayadiy kapa tamiya kidiy duw taakw dayadiy majib mayakw akis kwakwanadiy.” Alik tikuw, di lakwudil a tamiya kidiy duw taakw day dim yakisuwtaka maa. ");
INSERT INTO mle_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jisas Galiliy tamiyaar wakwud. A tamiya kidiy duw taakw tayir day Jiruwsalimaar adi Duw Takaam God Wapadidiy Bayaki Kikipatik yikuw, alim vidadiy adiy Jisas kwurdidiy yawiy. Alik tikuw, Jisas a tamiyaar wakwudik, day dim vikuw, rakarak samasam titaay, wayapiy sidaad. ");
INSERT INTO mle_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aw Jisas ata sibinin yad Galiliy tamiyaam ril tip Kanaar. Aw tayir a tipaam di kipa guw mwugiydik, wain suwulid. Aw a sikir Kapanam wadil tipaam gavman ak yawiy kwurdi mwiya yitaypika duw dikidi nyan barik kwaad. ");
INSERT INTO mle_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aw adi gavman ak yawiy kwurdi mwiya yitaypika duw Jisas Juwtiya tamiy wapakuw, Galiliy tamiyaar yadil maaj wukikuw, ata yad Jisasak. Yikuw, dikik wadid, “Wunadi nyan ada kiyakiyab kwanaad. Alik wun min yiminkikik Kapanam tipaar. Yikuw, diki giviyib sipwutiy-minkik.” ");
INSERT INTO mle_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aw Jisas kipwu mwutaam yikuw, ata waad, “Gwur ababa duw taakw, li gwur wunadiy nimadiy yawiy vi maarkigwur, samab wuna majik gwur wukijibir ti maa.” ");
INSERT INTO mle_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Aw adi gavman ak yawiy kwurdi nimadi duw Jisasak ata wadid, “Yitaypika duw, min wunawa may, aw wunadi nyan kiyak-naad.” ");
INSERT INTO mle_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Aw Jisas dikik ata wadid, “Min kip maay! Minadi nyan kiy maa.” Aw adi duw Jisas diki wadil majib wukijibir tikuw, ata yad. ");
INSERT INTO mle_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Aw adi duw nyidi yabir diki wiyaar yitaay tidik, adiy dikidiy yawiy duw dikik yikuw, ata wadaad, “Minadi nyan bwutaay viyakit tinaad.” ");
INSERT INTO mle_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aw dayak ata bas sididiy, “Akasikir wunadi nyan viyakit tinaad?” Aw day dikik ata wadaad, “Nal nyi kwasa tikitakiydik, diki sip ata nikir tayil.” ");
INSERT INTO mle_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aw adi nyan asaay ata lakwudil di mwiya aal Jisas dikik, “Minadi nyan kiy maa,” wadil nyabal. Atawa di lakwukuw, ata Jisasak wukijibir tad, dikidiy nyanugw takwawa diki wiyaam kwadiy miyawa duw taakw ab. ");
INSERT INTO mle_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kibir taay Jisas dikibir kwurdibir nimabir yawiy diki mwiya maaw simakak, Juwtiya tamiy wapakuw, sibinin yin Galiliy tamiyaar wulakuw. ");
INSERT INTO mle_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ginyir adiy Juw duw taakw day gaba maja bayaki kikipaat mwugiydaal Jiruwsalimaam. Aw Jisas di Jiruwsalimaar warid. ");
INSERT INTO mle_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jiruwsalimaam di adi nimadi kabaka yaripaam tidi wiyigawa, day sikiykwadana “sipsip a wiyig” wataay, a tamiyawa tukwa ar ral. A tukwa ar Juw duw taakw sikiykwadana “Bitsayta” wataay. Aw mala arawa kwasadiy wiy tabab tawsada-dadiy. ");
INSERT INTO mle_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Mwiya samasama duw taakwadiy adiy tawsada-dadiy wiyaam ridiy. Nuwukadiy mil kwakidiy, nuwukadiy ap bwan kupwaraap tidiy, nuwukadiy miyawa sip bag saydiyadiy. Aw day abab kavin kwadiy a guw kibwiyasuw-likik. Aw nuwukadiy nyi yidakikib Yitaypika Duw God dikidiy diki maaj kardadi duw nak dataay, a guwaam mwugiydikib, kibwiyasuw-likib, aw adi mwiya tayib guwaar dakwanadi duw ay taakw diki giviyib jayib nak sipwutiykwana. ");
INSERT INTO mle_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Adiy alim ridiy duw taakw daya duw nak dim kupwarapa giviyib kwurlik, nabiyir nabiyir duwamiy nak sap tabatiy maan abamugwul kwayadidiy. ");
INSERT INTO mle_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas vidid alim daan kwadik, aw di bwutaay lakwudid adi duw atawa barik kwayadidiy nabiy. Aw Jisas ata dikik bas sidid, “Min viyakit maa tikir mawul warnadimin?” ");
INSERT INTO mle_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aw adi duw Jisasak ata wadid, “Yitaypika Duw, wun kapa nyanugw maa ti wunaam bas ki guw kibwiyasuwlik, wunaam likim takatakak. Aw wun dakir kwurkwatuwadiy, nuwukadiy duw taakw wunaam kakiltaay, tayib dakwanadiy.” ");
INSERT INTO mle_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aw Jisas dikik ata wadid, “Aras! Rasikuw, wadi minadi baay kwurkuw, maay!” ");
INSERT INTO mle_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","10","Aw adi duw ata jayib nak diki giviyib kwusilik, dikidi si kwadidi baay kwurkuw, ata rasikuw, yad. Ki jaav Sapat nyaam atawa kwurdil, Jisas. Aw adiy Juw dayadiy yitaypika duw adi duwak ata bas sidaad, “Kal min Sapat nyal. Agwa javik wadi baay yatanadimin ki nyawa? Min atawa kwurminil nyana lo waam sarnadimin.” ");
INSERT INTO mle_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aw adi Jisas sipwutiydidi duw adiy Juw dayadiy yitaypika duwak ata wadidiy, “Adi wunaam sipwutiynadi duw, ‘Wadi baay kwurkuw, maay!’ wadalik.” ");
INSERT INTO mle_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aw day ata bas sidaad, “Sikadadaad minak wanaad, ‘Minadi baay kwurkuw, maay!’ waan?” ");
INSERT INTO mle_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Aw Jisas adi duwaam sipwutiydik, kwasa samasama duw taakw vagaluwin tidiy. Aw Jisas adi duwaam sipwutiyin napakuw, adiy duw taakw daya nyidi nyidirib pakwun pakwun wakwud. Alik tikuw, adi duw samab maa laakw Jisasaam. ");
INSERT INTO mle_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aw ginyir Jisas vidik adi sipwutiydidi duw God dikidi wiyaam tidik, Jisas adi duwak ata wadid, “Aka bwutaay viyakit tinadimin. Aw ginyir ab vaal yiwayik aw minak aal minaam til java pik maa mwiya yitaypik minaam tikik-na.” ");
INSERT INTO mle_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aw adi duw ata Jisasaam wapakuw, yikuw adiy Juw dayadiy yitaypika duwak yarik yididiy, “Adi wunaam sipwutiydi duw Jisasad,” wakuw wadidiy. ");
INSERT INTO mle_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Aw Jisas adi duwaam Sapat nyaam diki giviyib sipwutiydilik tikuw, adiy Juw dayadiy yitaypika duw Jisasaam ata jawjaay kwurdaad. ");
INSERT INTO mle_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Aw Jisas dayak ata wadidiy, “Wunadi Asaay di nyi nakab akis kip kwakwanaad. Sapat nyaam ab yawiy kwurkwanaad. Alik wunabab atawa kwurkinadiwun diki pik.” ");
INSERT INTO mle_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aw adiy Juw dayadiy yitaypika duw Jisas atawa wadil maaj wukikuw, day miyawa yaal giradiy. Dikim mwiya mwiyab viyasipak aw day mawulaar wukidaal Jisas di dayakil Sapat lo bwutaay sardil adi duwaam atawa kwurdilik tikuw. Awarab di kitawa wadil, “God wunadi Asaayad,” wakuw, aw di ad bwutaay mwiya Godawa rivriv tinaad, wakuw wukidiy. ");
INSERT INTO mle_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Aw Jisas dayak ata wadidiy, “Wun gwurak mwiya mwiyab watuwadiygwurik, wun wuna kapa mawulaar jaav nakab akis kwurkwanadiwun. Wun vituwik wun wunadi Asaay kwurda jaaval, a javib kwurkwanadiwun. Wunadi Asaay kwurda niki jaav niki jaav wun dikidi Nyan ab kwurkidiwun a jaav. ");
INSERT INTO mle_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","“Aw Asaay wun dikidi Nyinik mawul yikuw, adiy di kwurkwadadiy miyawa yawiy simaka-kwadadiwun. Aw di simaka-kidadiwun ki javik mwiya yitaypik tikina jaav, aw gwur adiy yawiyib vikigwura, mwiya mwiyab pitaan warkinadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","“Aw Asaay di kiyadiy duw takwaam sibinin dayadiy kwakidanadiy mawul rawtakadil pik, atampik wun dikidi Nyan ab sibinin dayadiy kwakidanadiy mawul rawtakakituwadiy adiy mawul yikituwadiy duw takwaam. ");
INSERT INTO mle_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Aw Asaay di diki akis duw takwaam kotiy-kwanaad. Aw di bwutaay tasakwu-didiwun wun di dikidi Nyan jas tikuw, duw takwaam kotiy tuwkik. ");
INSERT INTO mle_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","“Aw God atawa tasakwudil dikidi Nyan atawa yawiy kwurdik, aw duw taakw dikidi Asayik yakisuwtaka-kwadana pik, dikidi Nyinik ab yakisuwtaka-kidanaad. Aw li adiy duw taakw day God dikidi Nyinik yakisuwtaka maarkidiy, aw day dikidi Asayik ab yakisuwtaka maa. ");
INSERT INTO mle_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Wun gwurak mwiya maaj watuwadiygwurik, adiy wuna majib wukikuw, lakwu-lakwub tikuw, adi wunaam wayakidi Godak wukijibir tikidiy, God bwutaay tasakwudidiy dikiwa nakamwiyib nyanyi nyanyi kwayadakik. Aw day adi God dikidi nimadi kot im ti maa. Aw bwutaay di tayib tasakwudidiy day miyawa dikik kajakuw ti maa. Aw day dikiwa viyakita mwiy nyanyi nyanyi kwayikinadiy. ");
INSERT INTO mle_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Wun mwiya mwiyaba maajal watuwadiygwurik, nyi yakina, aw akaanaka tina, adiy kiyadiy duw taakw wun, God dikidi Nyan, wuna maaj wukikidana. Aw wukin napakuw, ata day nyanyi nyanyi viyakita mwiy kwayikinadiy. ");
INSERT INTO mle_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","“Aw Asaay di duw taakw dayadiy mawul mwiya maaw tidalik tikuw, aw di bwutaay tasakwudid di dikidi Nyan ab miyawa duw taakw dayadiy mawul mwiya maaw tidikikik. ");
INSERT INTO mle_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","“Aw wun, duw taakw dayadi Mwaam tituwalik tikuw, God tasakwudidiwun dayadi jas tikuw, dayadiy maaj wukituwkik. ");
INSERT INTO mle_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","“Ginyir nimadib gaam situwik, adiy kiyadiy duw taakw dayadiy kawamiyaam kwaan wukikuw, ata dayadiy kawamiy wapakidanadiy. Wapakuw, aw adiy duw taakw kip nyi bap van kwadaal sikir viyakita yawiyda kwurdiy, day rasikuw, nyanyi nyanyi Godawa viyakita mwiy kwayikinadiy. Aw adiy vaal yiyi tidiy duw taakw day rasidaak, God ata tasakwukidadiy dikik kajakuw, nyanyi nyanyi kupwaraap kwayadakik.” ");
INSERT INTO mle_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisas adiy Juw dayadiy sapakwa nyanugwak ata wadidiy, “Wun wuna kapa mawulaar kap ki yawiy kwurkwur maa rav. Wun duw takwaam God di diki wada pik kotiy kwatuwadiy yarakara. Aw wun wuna kapa mawulaar wukikwatuwadiy jaav akis kwurkwanadiwun. Aw li wunaam wayakidi Asaay diki mawul wukikwaladiy jaav kwurkwatuwalik tikuw, alik adiy duw takwaam kotiy kwatuwadiy maaj adiy mwiyir tikwanadiy maajadiy. ");
INSERT INTO mle_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","“Aw li wun wuna kapa sipak gwurak kalivak-tuwa, aal gwur bwunak mwiyir wakik-nadiygwurik, ‘Dikidiy maaj adiy kipa maaj-adiy,’ waan. Aw li wun wunadi Asaay wun wuna danik tikuw bwuladalik, wun lakwutuwa diki maaj mwiya mwiyaba maajal. Suwaal maaj maa. ");
INSERT INTO mle_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Tayir gwur Jonak duw wayakigwurdiy wunak bas sidakikik, aw di mwiya mwiyaba maajal wadil gwurak. ");
INSERT INTO mle_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Aw wun saal maa yi duw wuna danik tikuw maaj bwula-bwulak. Aw kidiy maaj watuwadiygwurik, aal Jon wadil maaj, aw aal diki majib wunak wukijibir tikigwura, aw God mwiyir gwuraam nyigil-kidadiygwur. ");
INSERT INTO mle_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","“Jon di adiy yiy yankwanadiy Tiliy lam kaytik tad. Aw adiy dayak yikwanadiy kwarbag nyanyagway kaytik, gwur dikik kipa kwasa mwiy yidiygwur diki maaj wukik. ");
INSERT INTO mle_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jon diki maaj wuna danik tikuw bwulaad. Aw jaav naka mwiya yitaypik tina. Wun kwurtuwadiy yawiy, adiy wunadi Asaay kwurtuwkik kwiydidiy yawiyadiy. Day wuna danik mwiyir simakadaal aw wunad Asaay wunaam wayaki-didiwun. ");
INSERT INTO mle_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","“Aw adi wunaam wayakid Asaay dibab wuna danik maaj bwulakwanaad. Diki bwula kwudiy gwur samab maa wak. Diki mil mwutaam gwur samab maa vi. Aw gwur adi God wayakididi duwak wukijibir ti maargwuralik tikuw, alik God diki maaj gwuradiy mawulaam akis rawun kwakwana. ");
INSERT INTO mle_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Nyanyi gwur God diki lapa nyigaam vitaay, aw gwur wakwanadiygwurik, adiy maaj simaka-kidanadiyan nyanyi nyanyi Godawa viyakita mwiy kwayagwurkik wakuw. Aal mwiya maajal. Aw God diki lapa nyig li wuna danik bwulakwana. Aw gwur a jaav maa sitakir nibway. ");
INSERT INTO mle_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","“Aw li gwur wunak varavarak kwasik yikwanadiygwurik, aw wun gwuraam mwugiytuwik, viyakita mwiy Godawa nyanyi nyanyi kwayagwurkik. ");
INSERT INTO mle_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Aw wun gwurak gwur wunak wayapiy sigwurkikik maa wu. ");
INSERT INTO mle_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","“Aw wun bwutaay lakwutuwadiy gwuradiy mawul. Wun bwutaay lakwutuwadiygwurik gwur mwiyir mawulaar maa Godak mawul yi. ");
INSERT INTO mle_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","“Wunad Asaay gwurak wayakididiwun, aw gwur wunak mayakw maa kwu. Aw li nikidi duw di diki kap yadik, adi duwak ata gwur mayakw kwakigwuraad. ");
INSERT INTO mle_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“Gwur rakarak tikwanadiygwurik nuwukadiy duw taakw gwuraam yakisuwtaka-dakik. Aw gwur akis kwakikwanadiygwurik adi nakamwiya Godak di gwuraam sukwasukw kwurdikik. Aw li gwur atawa kwurgwura, ata ata gwur Godak wukijibir tikidiygwurik? ");
INSERT INTO mle_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Aw gwur wakwanadiygwurik, ‘Nyan Mawsis diki majib lakwu-lakwub tikwabanalik tikuw, alik nyan Godawa nyanyi nyanyi viyakita mwiy kwakinadiygan.’ Aw li gwur atawa mawulaar wukigwura, jawjaay wuki-kwanadiygwurik. Aw wun maa, Mawsis di diki sukwupir maaj gwuradiy yawiyik wakinaad Godak gwur God dikidi nimadi kot im tigwurkikik tikuw. ");
INSERT INTO mle_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","“Mawsis di wunak maaj sukwudil, aw aka God diki lapa nyigaam rina. Alik tikuw, li gwur mwiyir Mawsis diki majik wukijibir tikik-gwura, aal wunak ab wukijibir tikik-nadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","“Aw li gwur aal diki sukwudil majik wukijibir ti ti maarkigwura, aw ata ata wuna majik ab wukijibir tikidiygwurik?” ");
INSERT INTO mle_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ginyir Jisas ata sibinin Galiliy agika gikir suwulin vakiyid. Aw a ar day sikiykwadana maa “Taypiriyas” waan. ");
INSERT INTO mle_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aw adiy duw taakw day adiy Jisas kwurdidiy nimadiy yawiy duw takwaam dayadiy giviyib sipwutiyin kwurdik, day atawa vikuw, aw mwiya samasama duw taakwadiy diki kwukib yidiy. ");
INSERT INTO mle_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Adi Juw Duw Takwaam God Nyigildidiy Bayaki Kikipata Nyi walibab tad. Aw a sikir Jisas di dikidiy kalivadidiy duwawa abwa nibwukir warkuw, daan ridiy. ");
INSERT INTO mle_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Aw Jisas kitay kitiy vikuw, vididiy, mwiya samasama duw taakw dikik yadaak. Aw Pilipak ata bas sidid, “Akim wadiyay yanadiy duw takwaam mwiyir rivikinadiy kamnaagw yapiykinadiyan?” ");
INSERT INTO mle_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Aw Jisas di bwutaay lakwudil adiy duw takwak kwurkida jaav kamnaagw dayak kwiyik tikuw. Aw Jisas di Pilip diki mawulaam kwurkitaan vikir wadil aal. ");
INSERT INTO mle_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aw Pilip Jisasak kitawa wadid, “Wadiyay yanadiy duw takwak kwurik-banadiy kamnaagw jilig duwamiy nak tikik-na. Aw li adiy atawa kwurik-banadiy kamnaagw mwiyir akis dayaam ab rivik-nadiy.” ");
INSERT INTO mle_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Aw Jisas dikidiy kalivadidiy duwa kidi duw nak, Adiruw, Simon Pita dikidi nyamwus, ata wadid, “Nyan nakad bret tabab kamiy vitiy kwurkuw yanaad. Aw mwiyir kidiy samasama duw takwaam adiy mugwula kamnaagw rivikinadiy?” ");
INSERT INTO mle_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aw Jisas dayak ata wadidiy, “Yin wagwurik abab daan rikwadiy.” Aw a tamiyaam samasama vas wardiy. Alik daan ridiy apiy visim. Aw adiy vagaluwdiy miyawa duwada nasidaal, 5000-adiy. ");
INSERT INTO mle_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisas adiy bret kwurkuw, ata Godak wayapiy san napakuw, ata am sididiy adiy duw takwak. Abir kamiyik ab atawa kwurdibir. Miyawa duw taakw abab rivyakidiy. ");
INSERT INTO mle_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aw Jisas dikidiy kalivadidiy duwak ata wadidiy, “Wadiy kavisadanadiy kamnaagw miyawa avagaluw! Simsim ab kip ridaba.” ");
INSERT INTO mle_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Aw day ata nugwutakadadiy adiy duw taakw kavisadadiy kamnagwu kidiy, aw kibiy tabatiy maan vitiy wapwurukwudiy. ");
INSERT INTO mle_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aw adiy alim kwadiy miyawa duw taakw adi Jisas kwurdidi nimadi yawiyim vikuw, ata wadiy, “Kad adi kavin kwayabanadi God dikidi diki maaj nyanak wasapwiykinadi Duwad. Ay maa?” ");
INSERT INTO mle_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aw Jisas di bwutaay lakwudidiy day dim mwugiyik dayadi yitaypika duw tidikikik wukidadiy mawul. Alik di maa wakuw dayadiy wukidadiy mawulak ata dayaam wapakuw, di kap warid abwa badawaar. ");
INSERT INTO mle_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Nyi giripidik, Jisas dikidiy kalivadidiy duw ata dadiy araar. Dakuw, dayaki jabir kwurkuw, ata a ararib sibinin suwulin vakiydiy Kapanam tipaar. Aw gaan varugwadim nalil ab Jisas dayak samab maa maak tak. ");
INSERT INTO mle_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A gaan mwar viyadik, mam ata nimadib yal. ");
INSERT INTO mle_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aw adiy Jisas dikidiy kalivadidiy duw ata vakiytaay tidiy nyidi ararib. Vakiytaay tikuw, a ar liki nyidi nyidib kwurdaak, Jisas apiy guwarib rasin tiyadik, day ata vidaad. Aw day atawa vikuw, day mwiya samasam yagadiy. ");
INSERT INTO mle_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jisas dayak ata wadidiy, “Wun-adiwun. Yagatikwa!” ");
INSERT INTO mle_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aw day lakwukuw, di mwiya Jisasad wakuw, ata day abab yaakiya wadiy Jisas dayaki jabiraar salin wardikik. Aw day atawa wadaak, aal yikir kwurdaal tamiy ata jayib nak walibab tal. ");
INSERT INTO mle_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sira pik adiy a ar agika gikim kwadiy samasama duw taakw vidaal kipa jabiral nak yibwunim kip kwalik. Aw day bwutaay lakwudaal Jisas di dikidiy kalivadidiy duwawa jabiraar maa nakamwiyib vakiy. ");
INSERT INTO mle_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aw nuwukadiy Taypiriyas tipa kidiy jabir ata aal Yitaypika Duw Jisas wayapiy san napakuw, mwiya samasama duw takwak kamnaagw kwiydil tamiyawa walibab kawiydiy. ");
INSERT INTO mle_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aw adiy duw taakw vidaal Jisas alim ti maardik, adiy di kalivadidiy duw ab alim ti maardaak, day ata dakuw, day adiy jabiraar salin warkuw, Kapanam tipaar kwakivakiydiy Jisasak. ");
INSERT INTO mle_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aw adiy duw taakw ata a ar agika gikim Jisasaam sitakiradaad. Sitakirakuw, dikik ata wadaad, “Gaba Maja Duw, akasikir varanadimin?” ");
INSERT INTO mle_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aw Jisas dayak ata wadidiy, “Wun gwurak mwiya mwiyab watuwadiygwurik, gwur adiy wun kwurtuwdiy nimadiy yawiy vikuw, gwur samab wunak kwak maa. Aw gwur nal aal kikipaat samasam kikuw, yaal wapwurukwu-gwuril pikak varanadiygwur, ay? ");
INSERT INTO mle_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","“Gwur mawulaar wukitikwa kipa kamnagwadikanik. Kidi kupwa kamnaagw pwusakwanadiy. Alik gwur kip yawiy akwur nyanyi nyanyi Godawa viyakita mwiy kwakwak. Adi jaav mwiya kamnaagw kaytikad. Samab kupwaraap tikuw, kwas maa. Aw wun, duw taakw dayadi Mwaam, ki jaav kwatiya-kituwa gwurak. Asaay God bwutaay tasakwudidiwun ki yawiy kwurtuwkik.” ");
INSERT INTO mle_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aw adiy duw taakw ata Jisasak bas sidaad, “Aw nyan ata ata kwurkuw, adiy God wadidiy yawiyda kwurkinadiyan?” ");
INSERT INTO mle_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aw Jisas dayak ata wadidiy, “Kitawa kwurgwurkik God wanaad: Adi di wayakididi duwak wukijibir tigwurkik.” ");
INSERT INTO mle_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Aw day ata Jisasak maa wadaad, “Mwiya tayir nyanadiy waraga duw taakw tamiyka tamiyaam kwadaal sikir day aal mana wadaal kamnagwur kidaal God dayak kwiydikib. Aw aal God diki lapa nyigaam walil pik, ‘Adawur tipa kidiy kamnaagw Mawsis kwiydidiy kidakikik.’ Aw min mina kidi kupwa kidiy kamnagwada kwiyminadiyan kibakikik. Agwa nimadi yawiy kwurminik aw mwiyir nyan vikuw, minab wukijibir tibakikik, lakwukuw God minak yaakiya wanaad? Ata ata kwurkinadimin?” ");
INSERT INTO mle_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","Aw Jisas dayak ata wadidiy, “Mwiya mwiyab watuwadiygwurik, aal Mawsis dayak kwiydil kamnaagw aal adawur tipa kil mwiya mwiyaba kamnaagw maa. Wun wunad Asayad mwiya mwiyaba adawur tipa kil kamnaagw kwiynaad. Adi God kwiydidi kamnaagw ad mwiya duwad. Adawur tipab tikuw, kidi kupwaar daad aw mwiyir miyawa tamiya kidiy duw taakw yara mwiy Godawa nyanyi nyanyi nakamwiyib kwadakikik.” ");
INSERT INTO mle_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aw day Jisasak ata wadaad, “Yitaypika Duw, nyanak atampika kamnaagw kwatiyaminkik aw nyan mwiyir likib kwurtaay kinaak.” ");
INSERT INTO mle_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aw Jisas dayak ata wadidiy, “Wun adi duw takwak mwiyir nyanyi nyanyi kwadakikik mwugiykwanadi kamnaagw-adiwun. Adiy wunak yakinadiy duw taakw day samab ginyir kaam yas maa. Adiy wunak wukijibir tikinadiy duw taakw day samab guw kikir ginyir ginyir kwal yas maa. ");
INSERT INTO mle_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Aw wun gwurak mwiya lakatiyakin watuwdiygwurik wun wunak, aw gwur vigwurdiy kwurtuwdiy yawiyik, aw gwur kwasik yikinadiygwurik wunak wukijibir titak. ");
INSERT INTO mle_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","38","“Adiy miyawa duw taakw, adiy wunad Asaay wunadiy tidakikik kwatiya-didiy duw taakw, day wunak yakinadiy. Aw wun adawur tipab tikuw, datuwilik tikuw, wun kwurkidiwun adi wunaam wayakidi Asaay kwurtuwkik wakida jaav. Aw wun wuna kapa mawulaar jaav nakab kwar maa. Alik tikuw, wun samab bwan kway maa adiy wunak yakir kwurkinadiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","“Wunaam wayakidi Asaay wunak wadil jaav aal kitawaanal: Aw wun yarakara kip kaykiti-jibir tituwkikik adiy wunak kwiydidiy duw takwaam, aw nakab jaaw yidakikik maa, waad. Dayaam kaykiti-jibir tan aw yin kidi kupw kwusikida nyab ata kirasi-kituwadiy aw day ata mwiyir nyanyi nyanyi viyakita mwiy kwadakikik. ");
INSERT INTO mle_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","“Ayiy, aal wun wunad Asaay di diki mawula. Adiy adi di dikidi Nyinik vikuw, dikik wukijibir tikinadiy duw taakw nyanyi nyanyi viyakita mwiy kwadakikik. Aw aal kidi kupw kwusikida nyaam wun adiy duw taakw kirasitaka-kituwadiy aw mwiyir nyanyi nyanyi viyakita mwiy kwadakikik.” ");
INSERT INTO mle_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Aw Jisas kitawa wadilik tikuw, “Wun-adiwun adi adawur tipab tikuw, dadi kamnaagw,” alik adiy Juw duw taakw atawa wadil maaj wukikuw, ata ritaay, day dayak wasakiy saladiy. ");
INSERT INTO mle_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Aw day ata wadiy, “Kidi duw, Jisasad, Jawsip dikidi nyanad. Di maa, ay? Nyan bwutaay lakwubanabir dikibir amaywa asaay. Aw atawa tikuw, aw kita maa ata ataanal wada, ‘Wun adawur tipab tikuw, dadiwun,’ waan?” ");
INSERT INTO mle_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","44","Aw Jisas dayak ata wadidiy, “Kip kaygan ada. Awarwa awarwa maaj gwur gwurak warjuw-tikwa. Duw taakw nakab day daya mawulaar wunak ya maa. Aw li wunadi wayakidi Asaay dayaam mwugiydik aal yaak, day yakinadiy wunak, aw wun kirasitaka-kituwadiy kidi kupw kwusikida nyaam. ");
INSERT INTO mle_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“God dikidiy diki maaj wasapwiydiy duw God diki lapa nyigaam sukwudaal, ‘Ginyir God miyawa duw takwak kaliva-kidadiy.’ Alik adiy wunad Asaay majib wukikinadiy, adiy duw taakw-adiy lakwukinadiy mwiyir adiy di kalivakidadiy miyawa jaav. Aw adiy duw taakw wunak yakinadiy. ");
INSERT INTO mle_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Aw wun nuwukadiy duw taakw bwutaay wunad Asayim vidaad maa wu. Aw adi kidi kupwaar God wayakididi duwada bwutaay vidid Asayim. ");
INSERT INTO mle_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Wun gwurak mwiya mwiyaba maaj watuwadiygwurik, adiy wuna majib wukikuw, lakwu-lakwub tikinadiy duw taakw, God bwutaay tasakwudidiy dikiwa nyanyi nyanyi yara mwiy kwayadakik. ");
INSERT INTO mle_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Wun adi kamnaagw-adiwun duw takwaam mwugiytuwik, viyakita mwiy nyanyi nyanyi kwayakinadiy. ");
INSERT INTO mle_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","“Gwuradiy waraga duw taakw mana wadaal kamnagwur kidaal tamiyka tamiyaam kwadaal sikir. Aw day bwutaay miyawa kiyayakidiy. ");
INSERT INTO mle_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“Aw adiy duw taakw adawur tipab tikuw daal kamnaagw kikidiy, aw ginyir day samab kajaan ti maa Godawa. ");
INSERT INTO mle_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Wun, adi adawur tipab tikuw dadi duw, wun duw takwaam mwugiytuwik, nyanyi nyanyi kwayakinadiy. Wunaki amwiy aal kamnaagw kaytikal. Aw adiy a kamnaagw kikidiy duw taakw kwayakinadiy nyanyi nyanyi. Wun duw takwak ki wun wunaki kapa amwiy kwiytuwadiy dayaki kamnaagw tilikikik. Aw wun atawa kwurtuwa aw mwiyir adiy miyawa tamiyaam kwakidiy duw taakw mwiyir viyakita mwiy nyanyi nyanyi kwayadakik.” ");
INSERT INTO mle_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jisas atawa bwuladik, adiy Juw duw taakw ata day dayak ritaay, vwulasakiy salataay, ata bas sidiy, “Ata ataanal kidi duw wada di diki kapa amwiy liki kwiy nyanak kwiykida kibakikik?” ");
INSERT INTO mle_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aw Jisas maa dayak ata wadidiy, “Wun gwurak mwiya mwiyaba maajal watuwa. Aw li gwur duw taakw dayadi Mwaam diki amwiy liki kwiyawa nyikiy kwurkuw, ki maarkigwura, God samab gwuraam tasaakw maa nyanyi nyanyi viyakita mwiy kwagwurkikik. ");
INSERT INTO mle_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","“Adiy duw taakw, wunaki amwiy liki nyikiywa kwiy kwurkuw kikinadiy duw taakw, God tasakwukidadiy dikiwa nakamwiyib viyakita mwiy nyanyi nyanyi kwayadakik. Adiy duw taakw wun kidi kupw kwusidik, kirasitaka-kituwadiyadiy. ");
INSERT INTO mle_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Wunaki amwiy kwiyawa nyikiy, abirka-nabirka mwiya mwiyaba kamnagwuwa guw duw taakw kwurkuw, kikidanabir. ");
INSERT INTO mle_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","“Adiy duw taakw wunaki amwiy liki kwiyawa nyikiy kwurkuw kikinadiy, day adiy wunawa nakamwiyib tikinadiy aw wun dayadiy mawulaam rawun kwakinadiwun. ");
INSERT INTO mle_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Wunadi nyanyi nyanyi kwayakwanad Asaay di wayakididiwun aw di mwugiydalik tikuw, alik wunabab nyanyi nyanyi kwayakwanadiwun. Atampik adiy wunaki amwiy kikinadiy duw taakw ab wun wuna mwugiykituwadiy dayabab nyanyi nyanyi kwayadakik. ");
INSERT INTO mle_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","“Wun-adiwun, adi mwiya mwiyaba adawur tipab tikuw dadi kamnaagw. Adi kamnaagw, adiy gwuradiy waraga duw taakw kitaay kiyadadiy kamnaagw kaytik maa. Aw kidi kamnaagw kikinadiy duw taakw day nyanyi nyanyi kwajibir kwakinadiy.” ");
INSERT INTO mle_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kidiy maaj Jisas duw takwak kalivadidiy Kapanam tipaam tidi Juw dayadi gaba maja wiyaam. ");
INSERT INTO mle_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Samasam dikidiy kalivadidiy duw adiy Jisas kalivadidiy maaj wukikuw wadiy, “Kidiy kalivadadiy maaj dayadiy mwiya maaw duw nakab lakwu-lakwuk maa rav.” ");
INSERT INTO mle_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Aw day aal Jisas atawa kalivadil majik ritaay, awarwa awarwa bwulasakiy saladaak, aw Jisas di bwutaay lakwudil aw dayak ata wadidiy, “Ata ata ki kalivatuwa maaj gwuraam saal viyana? Alik yaal giranadiygwurik, ay? ");
INSERT INTO mle_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","“Aw atawa wukikigwura adiy wun kalivatuwadiy maaj wukin napakuw, aw ata ata wukikinadiygwurik kidi duw taakw dayadi Mwaam kidi kupw wapakuw, wartuwik adawur tikuw datuwidi tipaar? ");
INSERT INTO mle_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","64","“God dikidi Mawul duw takwaam mwugiydikib, nyanyi nyanyi kip kwakwanadiy. Aw li duw taakw day dayadiy kapa mawulaar day samab maa rav day dayaam mwugiy-mwugiyik viyakita mwiy nyanyi nyanyi kwakwak. Adiy gwurak kalivatuwadiy maaj simaka-kidanadiygwur adi nyanyi viyakita mwiy kway yaab. Aw gwura nuwuka duw samab maa adiy gwurak watuwadiy majik wukijibir ti.” Aw Jisas atawa wadil, aal diki yawiy bas kwurdil nyab di bwutaay lakwudidiy adiy diki majik wukijibir tikinadiy duw takwawa adi dim dikidiy mama nib tabaam takakinadi duwawa. ");
INSERT INTO mle_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jisas adiy duw takwak ata wadidiy, “Gwura nuwuka duw taakw samab wunak maa wukijibir ti. Alik tikuw, watuwadiygwurik, God di dika duw takwaam mwugiydik, wunak adiy yakik-nadiy. Aw day daya kap wunak yayi aal day samab maa rav.” ");
INSERT INTO mle_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aw Jisas atawa wadik, samasam adiy tayir dikik wukijibir tiyadiy duw taakw dikik bwan kwiykuw, ata wapadaad. ");
INSERT INTO mle_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aw day dim wapadaak, Jisas ata adiy di diki kalivadidiy dikidiy tabatiy maan vitiya duwak ata bas sididiy, “Ata ata, gwurabab wunaam wapakigwuradiwun?” ");
INSERT INTO mle_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Aw Simon Pita Jisasak ata wadid, “Yitaypika Duw, aw nyan minaam wapakuw, aw nyan sikik yikinadiyan? Min-adimin duwaar nak, aal duw takwaam nyanyi nyanyi kip kwayadakik mwugiykwana maaj kwiykwanadi duw. Aw kita nyan aka wukijibir tinadiyan minab. Aw nyan lakwubanadimin, min mwiya mwiyaba adi God di dikidi Tasakwudidi Duw-adimin.” ");
INSERT INTO mle_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Aw Jisas dayak ata wadidiy, “Wun wuna tasakwutuwadiygwurik, gwura tabatiy maan vitiya duw, aw gwura duw nakad Satan dikidi gikim tinaad.” ");
INSERT INTO mle_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Aw Jisas atawa dayak wadidi duw Juwtasad, Simon Yiskariyat dikidi nyanad. Aw kidi Juwtas Jisas dikidiy tabatiy maan vitiya kalivadidiy duwab tidil, di diki ginyir Jisasaam takadid dikidiy mama nib dayadiy tabaam. ");
INSERT INTO mle_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Aw ginyir Jisas ata Galiliy wadaal tamiyaar yad. Yikuw, alim tiytiyaan titaay, yawiy kwurid. Aw Juwtiya tamiy wapadil. Adiy Juw dayadiy yitaypika duw dikim viyasipaak kwurdalik tikuw, alik kwasik yad a tamiyaar yiyak. ");
INSERT INTO mle_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Adiy Juw duw taakw dayadi bayaki kikipata nyi, day wakwadanaad Basadika Wiy Bayaki Kikipaat, aad ata walibab tad. ");
INSERT INTO mle_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Aw Jisas di dikidiy kapa nyamwusugw ab samab dikik akis wukijibir tikwadaad. Alik tikuw, day atawa dikik sapis yikidaad, “Min ki tip wapakuw, Juwtiya tamiyaar maay! Aw mwiyir minadiy min kalivaminadiy duw mwiyir vikwadiy wadiy min titaay kwurkwaminadiy yawiy. Duw nakab, diki yawiy nuwukadiy duw taakw vidakikik wataay, aw di akis pakwur pakwur kwurkwanaad. Aw min atampika yawiy kwurkwaminalik tikuw, maay Juwtiya tamiyaar aw mwiyir miyawa duw taakw minaam lakwudakik.” ");
INSERT INTO mle_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aw Jisas dayak ata wadidiy, “Wunaki ap simakakituwa nyi aal maa nibway ti. Aw li gwur gwuradiy mawul yikir wukidakib, jaaw yikwanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","“Aw miyawa duw taakw day gwurak samab kwasik yi maa. Aw li wun day titaay kwurdanadiy kupwarapa yawiyik dayak wasapwiytuwkib, alik wunak day mwiya kwasik yikidanadiwun. ");
INSERT INTO mle_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","“Gwur jaaw maay adi bayaki kikipatik! Wunaki adi bayaki kikipatik yikituwa nyi maa nibway ti. Alik tikuw, wun kita yi maa.” ");
INSERT INTO mle_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Atawa dayak ki maaj waan napakuw, di kip Galiliy tamiyab kwaad. ");
INSERT INTO mle_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aw adiy Jisas dikidiy nyamwusugw ata day yidiy adi bayaki kikipatik. Yidaak, aw Jisas di ginyir yad. Aw di pakwun pakwun yad. Maykaar maa yi. ");
INSERT INTO mle_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aw adiy Juw dayadiy yitaypika duw adi bayaki kikipatim titaay Jisasak kwakiyi kwakiyataay, bas sidiy, “Di akadada?” wataay. ");
INSERT INTO mle_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Aw adiy alim vagaluwin ridiy duw taakw kwasa kwasa ritaay, ata bwulasakiy saladiy Jisasak. Nuwukadiy wadiy, “Di mwiy viyakita duwad.” Aw nuwukadiy wadiy, “Maa, di viyakita duw maa. Di duw takwak suwaal titaay, takakwanaad.” ");
INSERT INTO mle_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Aw adiy miyawa duw taakw day mwiya samasam yagadiy adiy Juw duw taakw dayadiy yitaypika duwak. Alik tikuw, day Jisasak kwasa kwasa ritaay, day dayak bwulasakiy saladiy. ");
INSERT INTO mle_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aw adiy bayaki kikipata nyi tabikarib ridaak, Jisas ata adi God dikidi wiyaar wulakuw, adiy duw takwak titaay, ata kalivadidiy. ");
INSERT INTO mle_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aw adiy Juw duw taakw dayadiy yitaypika duw pitaan warkuw, Jisas dikidiy duw takwak kalivadidiy majik ata wadiy, “Kidi duw skul ab maa ri. Ata ata lakwuyakidadiy kidiy miyawa jaav?” ");
INSERT INTO mle_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aw Jisas dayak ata wadidiy, “Kidiy kalivatuwadiy maaw maaj wunadiy maa. Wunaam wayakidi God di kidiy kalivatuwadiy maaw maaj wunak kwatiyadik kaliva-kwatuwadiy. ");
INSERT INTO mle_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","“Aw li adiy duw taakw day mwiya mwiyab kidiy God wadadiy yawiy kwurik tikinadiy, day bwunak lakwu-kidanadiy kidiy wun kalivatuwadiy jaav aw day God dikidiy-adiy ay wun wuna kapa majir watuwadiy. ");
INSERT INTO mle_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Aw li duw nak nuwukadiy duw taakw dikidi saam yakisuwtaka-dakik, aw di diki mawul waladiy jaav wakwadadiy. Aw li adi nikidi duw aad adi dikim wayakidi duw diki danik bwulakwanaad. Aw di atawa bwulakwada aw mwiyir duw taakw adi dikim wayakidi duw dikidi saam yakisuwtaka-dakik. Adaan ada adi duwad diki maaj mwiya maaja, suwaal maaj maa. ");
INSERT INTO mle_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Aw gwurak Mawsis God diki lo kwiydil, ay? Aw gwura duw samab akis a lo majib wuki-wukib tikwanadiygwurik. Alik tikuw agwa javik gwur wunaam viyasipak tinadiygwurik, ‘Di Mawsis diki lo sardadiy,’ waan?” ");
INSERT INTO mle_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aw adiy vagaluwdiy miyawa duw taakw atawa Jisas wadil maaj wukikuw, ata wadaad, “Min kwam tinadimin way. Sikadadiy-adiy minaam viyasipak tinadiy?” ");
INSERT INTO mle_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","23","Aw Jisas dayak ata wadidiy, “Wun yawiyal kwurtuwa Sapat nyaam. Wun duw dayaki giviyib aal sipwutiytuwa. Alik gwur mwiya pitaan warnadiygwurik. Aw gwurabab yawiy kwurnadiygwurik. Mawsis wadidiygwurik gwuradiy nyanugw dayadiy sipa bany lupwagwurkik aw mwiyir God dikidiy tidakikik, adiy tayir kwadiy gwuradiy waraga duw taakw kwurdaal pik. Aw duwa nyanugw dayadiy sipa bany lupwak tikwagwura Sapat nyi tilikik ab gwur mwugiy-kwanadiygwurik, aal yaak, rivi-kwanadiygwurik. Aw gwur atawa kwurtaay, aw agwa javik wunak yaal girakwanadiygwurik kidi duw Sapat nyaam diki giviyib sipwutiytuwalik? ");
INSERT INTO mle_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","“Kipakip watikwa, ‘Adi duw jaal danaad,’ waan dikim yarakara lakwu-maarin tikuw. Aw gwur vigwura wunaam wun jaav nakab maa saar.” ");
INSERT INTO mle_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nuwukadiy Jiruwsalimaam kwadiy duw taakw wadiy, “Kidi adi viyasipaak kwurdanadi duwad, ay maa? ");
INSERT INTO mle_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","“Gwur av! Kidiy miyawa duw taakw dayadiy nyidim tan bwulada, aw daya duw nak samab maa dim watip! Kidiy nyanadiy yitaypika duw mwiyir lakwudanaad di mwiya God dikidi di diki Tasakwudidi Duwad way? ");
INSERT INTO mle_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","“Aw adi God dikidi Tasakwudidi Duw yakida, duw nakab di yakida tamiy samab laakw maa. Aw nyan bwutaay lakwubanaad kidi duw diki yada tamiy. Aw ata ata tikuw, di God dikidi di diki Tasakwudidi Duw tinaad?” ");
INSERT INTO mle_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aw Jisas dayak kalivataay tidik God dikidi wiyaam, dayak ata nimadib wadidiy, “Ata ata, gwur mwiya mwiyab wunaam lakwu-gwuradiwun? Ata ata, gwur wun tikuw yatuwil tamiy mwiyir lakwugwura? Aw wun wuna kap kipakip maa yi. Adi wunaam wayakidi duw di ad mwiya maaw mwiyir tikwanadiy javik. Aw gwur samab dikim maa laakw. ");
INSERT INTO mle_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","“Aw wun bwutaay lakwutuwaad. Wun dikib tikuw, dadiwun. Aw di diki wayakididiwun. Alik tikuw, wun bwutaay lakwuyaki-tuwaad.” ");
INSERT INTO mle_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aw Jisas atawa bwuladik, aw adiy Juw dayadiy yitaypika duw ata dikim kalakwuk titaay wadiy. Aw aal God diki Jisasaam kalakwukuw viyasipadakik tasakwudil nyi walibab ti maarilik, alik day maa rav dim kalakwuk kwurdaal. ");
INSERT INTO mle_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aw adiy vagaluwdiy samasama duw taakw Jisasak wukijibir tikuw, ata wadiy, “Aw God dikidi Tasakwudidi Duw yakida, di kidi duw kaytik nimadiy yawiy pik kakilin kwurkinaad, ay?” ");
INSERT INTO mle_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aw adiy Parasiy duw adiy vagaluwdiy duw taakw atawa wadaal maaj wukikuw, aw day ata dayadiy vay sawdiy nuwukadiy duw wayakidadiy yin Jisasaam kalakwudakik. ");
INSERT INTO mle_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Aw Jisas dayak ata wadidiy, “Wun gwurawa kwasamwiy kwakituwa. Kwakuw, ata wapakituwadiygwurik. Wapakuw, adi wunaam wayakidi Godak maa sibin-kidiwun. ");
INSERT INTO mle_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","“Yituwik, aw gwur wunak kwakikigwura, samab wunaam sitakir maa. Aw gwur samab rav maa ki wun yikituwa tamiyaar yayak.” ");
INSERT INTO mle_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aw adiy Juw dayadiy yitaypika duw day dayak titaay ata bwulasakiy saladiy, “Di akarir, yidik nyan dim sitakir maarkibanaad? Di adiy Juw duw taakw kwadana Grik jaka tipaar yikinaad, ay? Yikuw, dayak titaay kalivakidadiy? ");
INSERT INTO mle_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Di wada, ‘Gwur wunaam sitakirak kwurik kwurkigwura, aw gwur rav maa.’ Aw niki maaj kitawa maa wada, ‘Gwur yiyi rav maa wuna kwakituwa tamiyaar.’ Aal ata ataana atawa wada?” ");
INSERT INTO mle_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","38","Adi nimadi bayaki kikipaat dikidi kwusikidadi nyi, ad dayak nimadi nyi tikwanaad. Aw adi nyaam Jisas rasikuw, nimadib adiy vagaluwdiy miyawa duw takwak wadidiy, “Adiy duw taakw guw kikir yisanadiy, day wunak yakwadiy. Yakuw, wunaam guw kwurkuw, kikwadiy. Adi wun kwiykituwadi guwak God diki lapa nyigaam rina maaj kitawana: ‘Adiy wunak wukijibir tikinadiy duw taakw guw kaytik dayadiy mawulaam ritaay kip warjibir tikuw, adi guw yisayis tikwanadiy duw takwaam mwugiydik, day kikidana, aal day nyanyi nyanyi kip kwayakwana mawul kwurkuw, kwakinadiy.’” ");
INSERT INTO mle_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas dayak wadil aw adiy dikik wukijibir tikuw, aal kwurkidana God dikidi Mawulak, bwuladil aal. A nyi God Jisasaam maa nibway adawur tipaar kwurin kawaar apawa kwadikikik, aw di dikidi Mawul duw takwak maa kway nibway. ");
INSERT INTO mle_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Adiy miyawa vagaluwdiy duw taakw samasam Jisas atawa wadil maaj wukikuw, day ata wadiy, “Kidi duw di mwiya mwiyaba adi God dikidi diki maaj wasapwiy-kwanadi Duw-ad.” ");
INSERT INTO mle_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Aw nuwukadiy duw taakw wadiy, “Di God dikidi di diki Tasakwudidi Duwad.” Aw nuwukadiy wadiy, “God Tasakwukidadi Duw di Galiliy tamiyab var maa. God diki lapa nyigaam rina maaj wana di Davit dikidi gwalugwa kidi duw tikinaad, aw diki amaay Bitliyim tipaam sapwiykilaad, aal Davit diki kwadil tipaam.” ");
INSERT INTO mle_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Atawa adiy duw taakw titaay wukiyi-wukiyadiy Jisasak. ");
INSERT INTO mle_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nuwukadiy duw taakw day Jisasaam kalakwuk kwurdiy aw day mwiyir maa rav dim kalakwuk. ");
INSERT INTO mle_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aw adiy vay sawdiy duw ata sibinin yidiy adiy dayaam wayakidiy yitaypika pris awa Parasiyak. Yin dayaam maak takadaak, adiy Parasiy ata dayak bas sidadiy, “Agwa javik dim kwurjibir karay maargwuraad?” ");
INSERT INTO mle_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aw adiy vay sawdiy duw dayak ata wadadiy, “Duw nakab akis kidi duw bwulada maja pik bwulakwanadiy!” ");
INSERT INTO mle_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","48","Aw adiy Parasiy duw ata dayak bas sidadiy, “Ata ata, gwuraam ab jawjaay kalivadidiygwurik? Aw gwur maa laakw gwuradiy yitaypika duwawa Parasiy duw nakab diki majib wukijibir tidik, ay? ");
INSERT INTO mle_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Adiy miyawa vagaluwdiy duw taakw day samab maa laakw Mawsis diki lo liki mwiya maaw. Atawa tikuw, day kidi duw diki majik wukijibir tinadiy. Alik God dayaam kupwaraap kwurkidadiy.” Atawa adiy Parasiy adiy vay sawdiy duwak yaal girakuw, wajibaydadiy. ");
INSERT INTO mle_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Nikadimas di Parasiy bapa kidi duw nakad. Di ad tayir Jisasak vikir yad. Aw di adiy nuwukadiy Parasiy duwak wadidiy, “Aal nyanak God kwiydil lo wana nyan kipakip duwaam tasakw tasakw vaal yiyi duw tidikikik, aal nyan maa rav. Li taay nyan diki maaj wukikuw, aal kwurdil jaav lakwukuw, aal yaak.” ");
INSERT INTO mle_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aw day dikik ata wadaad, “Minabab Galiliy tamiya kid-adimin kidi duw kaytik? Min God diki lapa nyig yarakara av. Atawa vikuw, min lakwukimina God dikidi maaj wasapwiydiy duw samab Galiliy tamiyab akis varakwanadiy.” ");
INSERT INTO mle_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Aw ginyir day atawa waan napadik, miyawa duw taakw day dayadiy wiyaar wiyaar yikit-akitadiy. Aw Jisas di Aliv wadadi nibwukir warid. ");
INSERT INTO mle_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Aw sira pik mwiya ganbab Jisas maa ata sibinin yad God dikidi wiyaar. Aw adiy miyawa duw taakw ata vagaluwin ridaak, aw di dayadiy nyidim daan rikuw, ata dayak ritaay kalivadidiy maa. ");
INSERT INTO mle_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aw adiy God diki lo kalivadiy duwawa adiy Parasiy taakw nak kwurkuw kariyadaal. Kariyakuw, mwugiydaal dayadiy mwutamawa rasin tilikikik. Aw day vidaal niki taakw likidi duwawa titaay vaal yilik. ");
INSERT INTO mle_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Aw day atawa a takwaam mwugiykuw, day ata Jisasak bas sidaad, “Gaba Maja Duw, ki taakw vibaal niki taakw likidi duwawa titaay, vaal yilik. ");
INSERT INTO mle_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","“Aw Mawsis nyanak kwiydil lo kitawa wana, nyan kitampika taakw aal viyasipabakik kabakir kwartayin. Aw li min ata ata wakinadimin?” ");
INSERT INTO mle_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aw day atawa wadaal, day Jisasaam vasibariyik aw mwiyir day dim kalakwuk. Aw Jisas di kip kwakitadakuw, dikidi tabaar baw yawiyim sukwudil maaj. ");
INSERT INTO mle_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Aw day kip dikik tan bas sidaak, Jisas sinawurkuw, ata dayak wadidiy, “Aw li gwura duw nak, adi samab vaal yi maarkwanadi duw, di taay likim kabakir viyakwaad.” ");
INSERT INTO mle_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Atawa waan napakuw, ata maa kupwaar kwakitadakuw, maa ata sukwudil maaj. ");
INSERT INTO mle_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aw day Jisas atawa wadil maaj wukikuw, ata day abab gwutakadiy, duw nak ata duw nak ata. Adi mwiya dayak yitaypik tad di mwiya taay gwutakaad. Aw day abab Jisasaam wapadaak a takwawa Jisas bir kap tibir adiy nuwukadiy duw taakw nyidim. ");
INSERT INTO mle_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aw Jisas sinawurkuw, ata a takwak bas sidil, “Akidiy adiyka, adiy duw? Duw nakab tinaad ki valik maaj nyinawa warjuwkinaad?” ");
INSERT INTO mle_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Aw dikik ata walid, “Duw nakab maa ti, Yitaypika Duw.” Aw Jisas likik ata wadil, “Yaakiya, wun wunabab ki valik maaj maa nyinawa warjuw warjuwik. Maay! Yikuw, samab ginyir ginyir vaal yiwayik.” ");
INSERT INTO mle_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aw Jisas maa adiy God dikidi wiyaam vagaluwdiy duw takwak ata wadidiy, “Kidi kupwaam kwanadiy duw taakw gaan kaytik jawjaay kwanadiy. Aw wun nyi kaytik dayak yadiwun yaab dayak mwiyir simakak. Aw adiy wuna kwukib yakinadiy duw taakw day samab ganim tiya maa.” ");
INSERT INTO mle_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Aw adiy Parasiy wadadiy bapa duw atawa wadil maaj wukikuw, Jisasak ata wadaad, “Min mina kapa sipak bwulanadimin. Alik tikuw, nyan mina majik samab wukijibir ti maa.” ");
INSERT INTO mle_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aw Jisas dayak ata wadidiy, “Aw li wun wunak ab bwulakituwa, aal wun watuwa maaj aal mwiya maaja, suwaal maaj maa. Aw wun wuna bwutaay lakwutuwa aal wun wuna tikuw datuwil tipab. Awarab wun lakwutuwa ginyir yikituwa tamiy ab. Aw gwur samab maa laakw wun tikuw datuwil tamiyawa aw yikituwa tamiy ginyir. ");
INSERT INTO mle_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","“Gwur kidi kupwa duw taakw viyakita duw takwawa kupwarapa duw taakw jaaw kip tasakwu-kwagwuradiy. Aw wun samab akis atawa duw takwaam tasakwukwanadiwun. ");
INSERT INTO mle_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","“Aw li wun duw takwaam kupwarapa duw taakw, viyakita duw taakw tidakikik tasakwuk-tuwa, aw wun mwiyir mwiya mwiyab tasakwuk-tuwadiy viyakita duw taakw, kupwarapa duw taakw tidakikik, aw adi wunaam wayakidi Asaay wunawa titaay sugwiyaan kwurkwadadiwun. ");
INSERT INTO mle_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Gwuraki lo kitawa wakwana, ‘Aw aal duw ay taakw vitiy bir vikuw bwulakibira maaj rivriv tilik, aal yaakiya biraki maaj ata mwiya maaj tikina.’ ");
INSERT INTO mle_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","“Atampik wun wunabab wun wunak bwulanadiwun. Aw adi wunaam wayakidi wunadi Asaay dibab wuna danik maaj bwulanaad.” ");
INSERT INTO mle_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aw day ata dikik bas sidaad, “Akid adi minadi Asaay?” Aw Jisas dayak wadidiy, “Aw gwur mwiyir wunaam lakwuk-gwura, wunadi Asayim ab mwiyir lakwuk-gwuraad. Aw gwur samab wunawa wunadi Asayim ab maa laakw.” ");
INSERT INTO mle_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas ki maaj wadil adiy duw takwak aal duw taakw saan Godak takakwadana tamiyaam titaay duw takwak kalivadil nyi. Duw nakab Jisasaam a nyaam maa kalaakw. Aw aal God tasakwudil nyi maa nibway ti dim viyasipadakik. Alik tikuw, day samab maa rav dim kalakwu-kalakwuk. ");
INSERT INTO mle_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aw Jisas jaab nakab maa ata wadidiy, “Aw wun ginyir yikituwa, gwur wunaam sitakirak aw gwur samab rav maa aal wun yikituwa tamiyaar yiy ak. Aw gwur Godawa kajikuw, tikuw, nyanyi nyanyi kupwarapa tipaam kwaya-kinadiygwurik. Kupwiyayugw! Aw gwur samab aal wun kwakituwa tamiyaam kwamugwuk.” ");
INSERT INTO mle_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aw adiy Juw dayadiy yitaypika duw ata day dayak wadiy, “A! Di wanaad, ‘Gwur ki wun yikituwa tamiyaar yi maa,’ waan. Ata ata atawa wada? Di diki way kap viyasipakuw, kiyakinaad?” ");
INSERT INTO mle_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Aw Jisas dayak ata wadidiy, “Gwur kidi kupwa kidiy duw-adiygwurik. Aw wun adawur tipa kidi duw-adiwun. Aw nyan kapakap kapakap-adiyan. Rivriv maa ti. ");
INSERT INTO mle_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","“Alik tikuw, watuwadiygwurik wadiy gwuradiy valik tikuw, God kajakidadiygwurik dikiwa titak. Kajakuw, ata mwugiydik, nyanyi nyanyi kupwarapa tipaam kwayakidiygwurik. God atawa kwurkidadiygwurik, aw gwur wunak wukijibir ti maargwuralik wunadiwun, adi duw gwurak adi watuwid.” ");
INSERT INTO mle_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","26","Aw day ata Jisasak maa bas sidaad, “Min sikadadadimin?” Aw Jisas dayak ata wadidiy, “Wun gwurak wayakwatuwadiygwurik wun wuna mil mwutamak. Aw mwiya kipa jaav kidiyka kip rinadiy gwurak kalivakituwadiy gwuradiy vaal simakak. Adi wunaam wayakidi Asaay di suwaal akis kwurkwanaad. Aw adiy wun duw takwak titaay kalivakwatuwadiy jaav, adiy di diki wunak wadidiy javib javib-adiy.” ");
INSERT INTO mle_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aw day samab maa laakw aal Jisas di dikidi Asaay Godak titaay bwuladidiy majim. ");
INSERT INTO mle_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aw Jisas dayak ata wadidiy, “Ginyir wunaam, duw taakw dayadi Mwamim, maap tikinadi miyaam kataan napadaak vatakasuw-kigwuradiwun. Yaakiya, ata mwiyir lakwukigwuradiwun, wun-adiwun, adi duw. Aw ata miyawa lakwukigwuradiwun wun wuna kapa mawulaar akis jaav kwurkwanadiwun. Aw adi wun wunadi Asaay wadidiy javib javib kwurkwanadiwun. ");
INSERT INTO mle_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","“Aw adi wunaam wayakidi wun wunadi Asaay di nyanyi nyanyi wunawa tikwanaad. Aw wun adiy rakarak tikwadadiy yawiyda kwurkwatuwalik, di samab akis wapakwadadiwun kap tituwkikik.” ");
INSERT INTO mle_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aw adiy Jisas wadidiy maaj wukidiy samasama duw taakw day dikik kip wukijibir tidiy. ");
INSERT INTO mle_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","Aw Jisas ata adiy diki majik wukijibir tidiy Juw duw takwak wadidiy, “Aw li gwur kidiy kalivatuwadiy majib lakwu-lakwub tikigwura, aal gwur mwiya mwiyab wun wunadiy duw taakw tikinadiygwurik. Aw gwur aal mwiyir tikwana maaj mwiyir lakwukigwura. Aw a mwiyir tikwana maaj li liki mwugiylik adiy kupwaraap sapwurapa gwuraam kalakwun van tikwanadiy jaav ata kajataka-kiladiygwurik.” ");
INSERT INTO mle_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aw Jisas dayak ata wadilik tikuw, day dikik ata wadaad, “Nyan Aparam dikidiy waraga duw taakw-adiyan. Aw nyan samab akis adiy nyanadiy mama nib dayadiy tabaam tikwanadiyan. Aw ata ataana wa wamina, ‘Adiy kupwaraap sapwurapa jaav day samab gwuraam van ti maa,’ waan?” ");
INSERT INTO mle_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Aw Jisas dayak ata wadidiy, “Adiy vaal yiyi tikwanadiy miyawa duw taakw, adiy dayadiy vaal dayaam van tikwadanadiy. ");
INSERT INTO mle_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","“Aw adi nikidi duwak yawiy kwurkwanadi duw di adi duw dikidi gwalugwa kidi duw maa. Di kipa yawiy duwad. Aw dikidi sapakwa duw dim jaaw wapakwaad. Aw adi gwalugwa kidi nyan, adaanada mwiya adi gwalugwa kidi nyan. Aw di ad adi gwalugwum nyanyi kwayakinaad. ");
INSERT INTO mle_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","“Aw li wun God dikidi Nyan wun wuna gwuraam nyigil-kituwadiygwurik a vaal tabaam tigwur, aw alik ginyir ginyir a vaal samab gwuraam van ti maa. Aw li wun atawa kwurkituwa gwuraam, ginyir gwur adi kipa yawiy duw kaytik ti maa. Gwur adi mwiya nyan kaytik tikidiygwur. ");
INSERT INTO mle_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Wun bwutaay lakwutuwadiygwurik Aparam dikidiy waraga duw taakw tigwura. Aw li gwur wunaam viyasipak tinadiygwurik, aw kidiy wun kalivatuwadiy javik wukijibir ti maargwuralik, alik. ");
INSERT INTO mle_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","“Aw wun watuwadiygwurik adiy wun wunad Asaay wadadiy javib javib. Aw gwur adiy gwur gwurad asaay wadadiy jaav-adiy kwurkwagwuradiy.” ");
INSERT INTO mle_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aw day Jisasak ata wadaad, “Nyanadi waraga duw, Aparam, adaanada nyanadi asaay.” Aw Jisas dayak ata maa wadidiy, “Aw li gwur mwiya mwiyab Aparam dikidiy mwiya nyanugw tikik-gwura, aal gwur adiy di kwurdidiy yawiy pik gwurabab kwurik-nadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","41","“Wun adiy God wunak wadidiy mwiya majib mwiya majib gwurak yarik yikwatuwadiygwurik. Aw gwur wunaam viyasipak kwurkwanadiygwurik. Aw Aparam di atawa maa kwar. Gwur gwuradi mwiya asaay dikidi majib wukijibir tigwuralik, atawa alik kwurkwanadiygwurik.” Aw day Jisasak ata wadaad, “God dikida adaanada nyanadi mwiya asaay. Nyan mwiya dikidiy mwiya mwiyaba nyanugw-adiyan. Nyan kipa yaba nyanugw maa.” ");
INSERT INTO mle_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aw Jisas dayak ata wadidiy, “Aw li God di mwiya gwuradi asaayad wakuw, aal wunak ab gwur mawul ay. Aw wun Godab tikuw, dakuw, kika tituwa. Wun wuna kap maa di kiril. Di diki wayakididiwun. ");
INSERT INTO mle_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“Aw gwur agwa javik kidiy wun kalivatuwadiy majik lakwu-lakwub ti maarnadiygwurik? Aw gwur mwiyir lakwu-lakwub ti maargwura, gwur apap wuna majik wukiwukik kwasik yinadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Ayiy. Gwur Satan dikidiy nyanugw-adiygwurik. Gwur dikidiy-adiygwurik, aw gwur adi gwuradi asaay, Satan, kwurgwurkik wakwadadiy yawiy kwur-kwanadiygwurik. Bas kidi kupw God yitakadik ridik, aw Satan diki kwurdil yawiy, aal duwaam viyasipaad. Aal diki yawiya. Di suwaal takatak tikwanaad. Di a yawiy liki mwiya maawad. Aal diki yawiya, aw dikim simsim viyakita yawiy ab maa ri. ");
INSERT INTO mle_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Aw wun mwiya mwiyab watuwadiygwurik. Aw wuna maaj gwuradiy vaal simakaladiy. Alik tikuw, gwur wunadiy majik lakwu-lakwub maa ti. ");
INSERT INTO mle_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Aw li gwura duw nakab vaal yituwik ab vikuw, a vaal aw kita wadik, aw nyan abab wukinaak. Aw li gwurak mwiya maaj watuwik, aw agwa javik wunak wukijibir ti maarnadiygwurik? ");
INSERT INTO mle_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","“Adiy God dikidiy nyanugw tikwanadiy duw taakw day God diki majib lakwu-lakwub tikwanadiy. Aw gwur God dikidiy nyanugw maa. Alik gwur kidiy watuwadiy majik gwur samab maa wak.” ");
INSERT INTO mle_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aw adiy Juw duw taakw Jisasak ata wadaad, “Aw li nyan wakibana, ‘Min Samariya tamiya kidi nib-adimin,’ waan, ay, ‘Kupwarapa wudib mina mawulaam yidadimin,’ waan, aal mwiya maajal. Ay maa?” ");
INSERT INTO mle_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aw Jisas dayak ata wadidiy, “Wun wuna mawulaam kupwarapa wudib maa ri. Wun wunadi Asayik wayapiy situwkikib, aw gwur wunaam vasisadak kwurkwagwuradiwun. ");
INSERT INTO mle_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Aw wun wuna sipak kap akis kwakikwanadiwun duw taakw wunak wayapiy sidakikik. Aw nikidi duw, God, di diki duw takwak kwaki-kwanaad wunak wayapiy sidakikik. Aw di diki adiy wunak wajibay-kwanadiy duw takwaam kotiy kidadiy. ");
INSERT INTO mle_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","“Wun mwiya mwiyab watuwadiygwurik adiy wuna majib lakwu-lakwub tikinadiy duw taakw day samab kiy maa.” ");
INSERT INTO mle_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Aw adiy Juw duw taakw dayadiy yitaypika duw Jisasak ata bas sidaad, “Aw kita nyan aka ya mwiya mwiyab lakwubana wudib minaki mawulaam wadika wulaan rawun kwanaad. Aparam di bwu kiyaad, aw adiy God dikidiy diki maaj wasapwiydiy duw ab bwu kiyayakidiy. Aw min wanadimin kitawa, adiy minaki majib lakwu-lakwub tikinadiy miyawa duw taakw day kip nyi bap van kwayakinadiy nyanyi waan. Aw nyanadi warag Aparam bwu kiyaad. Aw min wukimina min Aparamim yitaypik tinadimin, ay? Aw adiy God diki maaj wasapwiydiy dikidiy miyawa duw ab bwu miyawa kiyayakidiy. Aw min wanadimin adiy miyawa wunaki majib wuki-wukib tikinadiy duw taakw adiy nyanyi kip nyi bap van kwayakinadiy, waan. Aw min wukimina min ata ata duw-adimin?” ");
INSERT INTO mle_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisas dayak ata wadidiy, “Aw li wun wuna kapa sipak titaay bwulayi bwulayak-tuwa, aal samab wunadi si simsim si akis rivik-naad. Aw adi wunadi saam yakisuw takanadi duw, aad wunad Asayad. Di ad adi wagwuraad, ‘Nyanadi Godad,’ waan. ");
INSERT INTO mle_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","“Aw gwur samab dikim lakwun maa ti. Aw wun aad lakwutuwaad. Aw li wun gwurak kitawa wakik-tuwa, ‘Wun dikim maa laakw,’ waan, aal wun mwiya suwaal takatak gwura pik tikik-nadi duw tikik-nadiwun. Aw wun lakwutuwaad, aw dikidiy majib lakwu-lakwub tikwanadiwun. ");
INSERT INTO mle_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Gwuradi asaay, gwuradi waraga duw Aparam, di bwutaay lakwudil wunakil kidi kupwaar dakir tituwil nyi. Aw di atawa lakwukuw, di rakarak samasam tad.” ");
INSERT INTO mle_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aw adiy Juw duw Jisasak ata wadaad, “Min nabiy duwamiy vitiy sap tabatiy maa nibway ti. Aw ata ata min Aparam-im viminid?” ");
INSERT INTO mle_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aw Jisas dayak ata wadidiy, “Aparam diki amaay ab dikim sapwiy maarlil nyab, wun kip kwayadiwun.” ");
INSERT INTO mle_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aw adiy Juw duw atawa Jisas wadil maaj wukikuw, day yaal samasam girakuw, ata kabaak nugwudadiy Jisasaam kabakir viyasipak. Aw Jisas di kip pakwukuw, adi God dikidi wiy ata wapakuw, daya nyidi nyidirib wakwud. ");
INSERT INTO mle_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas di yabir yitaay tikuw, di vidid mil kwakidi duw. Adi duw di bas diki amaay sapwiylil nyab dikibir mil atawa kwakijibir tibir. ");
INSERT INTO mle_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aw adiy Jisas dikidiy kalivadidiy duw Jisasak ata bas sidaad, “Gaba Maja Duw, agwa javik kidi duw diki amaay sapwiylil nyab mil kwakid? Aw aal di diki valik tikuw, ay dikibir amaywa asaay birikibir valik tikuw, atawa tad basa kasab diki amaay sapwiylil nyab, ay?” ");
INSERT INTO mle_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aw Jisas dayak ata wadidiy, “Di mil kwakidil aw di diki valik ay dikibir amaywa asaay valik tikuw maa. Aw di atawa mil kwakidil aw mwiyir God di diki ap duw takwak simakak tikuw. ");
INSERT INTO mle_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","“Aw kip nyi tilik duw taakw yawiy kwurkwanadiy, aw gaan tilik duw taakw akis yawiy kwurkwanadiy. Atampik nyanabab tinadiyan. Nyi yakina nyan rav maa God diki yawiy kwurkwurik. Alik tikuw, kitanabab yapwur yapwur adi wunaam wayakidi God nyanak kwiydidiy yawiy kwurnaak kip viyakita nyi tila nyab. Nyi kaytik gaan van tikina tamiyaam lamada pik wun yawiy samasam kwurkinadiwun kip kidi kupwaam tikituwa nyab, duw taakw dayadiy mawulaam kajatakak.” ");
INSERT INTO mle_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Atawa Jisas waan napakuw, di kupwaam likasip satakakuw, bala kalakiy mwugiykuw, ata adi mil kwakidi duw dikibir milaam takadil. ");
INSERT INTO mle_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Bala kalakiy adi duw dikibir milaam takaan napakuw, ata wadid, “Maay! Yikuw, minaki mwutaam tukwa araam ajaan,” wakuw. Day dayaki kapa tipa majir a tukwa ar sikiykwadana Saylam waan. Aw liki si maaw maaj “Gwur maay!” Aw adi duw ata yad. Yikuw, diki mwutaam a tukwa araam janin napakuw, ata sibinin yaad. Aw dikibir mil ata mwiyir vidibir ya. ");
INSERT INTO mle_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aw adiy adi duw di dikidiy kapa tipa duw taakw dikim vikuw, lakwudaad di adi duwad sanak wasakwukwanaad ritaay. Aw day dayak ritaay awarwa awarwa bas sidiy, “Di adi daan ritaay, sanak wasakwukwanadi duwad, ay? Di maa?” ");
INSERT INTO mle_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nuwukadiy duw taakw wadiy, “Di ad, adi duwad way.” Aw nuwukadiy wadiy, “Maa, kad nikidi duwad. Diki pik rivriv tinaad.” Aw day atawa titaay bwula-bagwudiy, aw adi mil kwakidik Jisas sipwutiydidi duw dayak ata wadidiy, “Wun nikidi duw maa, wun-adiwun. Adi tayir mil kwakidi duw-adiwun.” ");
INSERT INTO mle_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aw adiy duw taakw ata bas sidaad, “Aw ata ata min mwugiykuw, mil vinadimin?” ");
INSERT INTO mle_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aw dayak ata wadidiy, “Adi Jisas wakwadanadi duw di bala kalakiy wunabir milaam mwugiyin napakuw, wayaki-didiwun Saylam tukwa araar yiguwkikik, yikuw mwutaam jantuwkik. Alik tikuw, wun yidiwun. Yikuw, wuna mwutaam jankuw, ata mwiyir vituwabir, wunabir mil.” ");
INSERT INTO mle_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aw day ata bas sidaad, “Akid ada, adi duw?” Aw di dayak ata wadidiy, “Wun maa laakw.” ");
INSERT INTO mle_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aw day ata adi mil kwakidik Jisas sipwutiydidi duw ata kwurkuw, karaydaad adiy Parasiy bapa duwak. ");
INSERT INTO mle_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sapat nyaam Jisas bala kalakiy kwurkuw, adi duw dikibir mil sipwutiydibir. ");
INSERT INTO mle_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Aw adiy Parasiy duw adi duwak ata maa bas sidaad, “Ata ata mil viminabir?” wakuw. Aw di ata wadidiy adiy Parasiy bapa duwak, “Di bala kalakiy kwurkuw, wunabir milaam takadik, aw wun wuna mwutaam jankuw, ata wunabir mil vituwabir.” ");
INSERT INTO mle_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Aw adiy Parasiy bapa duw nuwukadiy ata wadiy, “Kidi duw di Sapat lo waam sarnaad. Alik tikuw, di Godab maa di.” Aw nuwukadiy wadiy, “Ata ata vaal yikwanadiy duw atampika kidiy kwurdadiy yawiy pik kwurkinadiy? Alik nyan mawulaar wukibana di Godab daad.” Atawa waan napakuw, day ata abab kajadiy. ");
INSERT INTO mle_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Alik tikuw, adiy Parasiy bapa duw ata adi duwak bas sidaad, “Aw min wanadimin di mwugiydik, mil viminabir, waan. Aw min ata ata wukiminaad, di sikadadaad?” Aw adi duw ata wadidiy, “Wun wukituwa di God dikidi diki maaj wasapwiykwanadi duwad.” ");
INSERT INTO mle_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aw adiy Juw duw taakw dayadiy yitaypika duw day kwasik yidiy adi duwak wukijibir titak, “Di mil kwakid tayir aw kita ada vinaad,” wawak. Alik tikuw, day adi duwaam laakw maarkuw, day maaj kwiytakadaal dikibir amaywa asaay yabirkikik. ");
INSERT INTO mle_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Aw dikibir amaywa asaay yabirik, ata bas sidabir, “Kad biradi nyanad? Aw bir wakibira bas diki amaay sapwiylil nyab di mil kwakijibir tad waan? Aw ata ata kita mil vinaad?” ");
INSERT INTO mle_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","21","Aw abir dikibir amaywa asaay ata wabiridiy, “Ayiy, di anadi nyanad. Aw wun diki amaay dikim sapwiytuwil nyab mil kwakid an bwutaay lakwutaad. Aw an samab maa laakw kita mil vida. Aw an dikibir amaywa asaay an samab maa laakw si dikim mwugiydaak mil vinaad. Gwur dikik bas as. Di bwutaay duwad ya. Kwasa nyan maa. Di bwunak wakidadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aw adi duw dikibir amaywa asaay atawa bwulabiril, aw bir adiy Parasiy bapa duwak yagabir, aw day kitawa wadalik, “Aw li agwa duw ay taakw wakidana, ‘Jisas di God dikidi Tasakwudidi Duwad,’ waan, adiy duw taakw samab Juw dayadiy gaba maja wiyaar wul maa.” ");
INSERT INTO mle_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Aw adi duw dikibir amaywa asaay atawa wadadiy maaj wukikuw, ata wabiridiy, “Di duwad. Dikik bas as,” wakuw. ");
INSERT INTO mle_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Alik tikuw, jaab vitiya yay ata maa adiy Juw bapa duw adi mil kwakidik Jisas sipwutiydidi duwak ata gaam sidaad dayak maa yadikikik. Yadik, ata day dikik wadaad, “Mayra saal yikidimin Godak, min mwiya mwiyaba majida bwulakidimin wakuw. Aw nyan kidi duw ada bwutaay lakwubanaad. Jisas di vaal yiyi tikwanadi duwad.” ");
INSERT INTO mle_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aw adi duw dayak ata wadidiy, “Wun samab dim maa lakwun ti di likil vaal yiyi tikwanadi duwad, ay di mwiya viyakita duwad. Jaav nak lakwutuwa. Tayir wun mil kwakijibir tiyatuwik, aw kita aka mil mwiyir vituwabir.” ");
INSERT INTO mle_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aw day dikik ata bas sidaad, “Aw ata ata mwugiydidimin? Ata ata mwugiydik min mil viminadimin?” ");
INSERT INTO mle_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Adi duw dayak ata wadidiy, “Wun bwutaay a javik watuwadiygwurik. Aw gwur maa wak. Aw agwa javik tikuw, ginyir wukik maa wanadiygwurik? Aw gwur dikidiy kalivadadiy duw tikir, ay?” ");
INSERT INTO mle_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","29","Aw day dikik sapis jikin kwurkuw, wadaad, “Min-adimin dikidi kalivadadi duw. Aw nyan maa. Nyan Mawsis dikidiy kalivadidiy duw-adiyan. Nyan bwutaay lakwubaal God Mawsisak maaj wadil. Aw adi duw di tikuw yadil tamiy nyan samab maa laakw.” ");
INSERT INTO mle_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Adi duw dayak ata wadidiy, “Mwiya mwiyab gwur dikim samab maa laakw? Ay? Di mwugiydik, wun mil mwiyir vinadiwun. Aw gwur jaav samasam lakwukwanadiy duw ata ataana wagwura, ‘Nyan di yadi tamiy maa laakw,’ waan? ");
INSERT INTO mle_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","“Nyan lakwubana God di akis adiy vaal yikwanadiy duw takwak dayadiy majik wukikwanaad. Aw di adiy diki majik wukitaay, lakwu-lakwub tikwanadiy duw taakw dayadiy majib wukikwanaad. ");
INSERT INTO mle_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","“God bas kidi kupw yitakadidi nyab aw kita nyan samab wukin maa ti duw nak bas diki amaay sapwiylik, mil kwakin tidik, aw dikim nikidi duw mwugiydik, ginyir mil vidil maaj. ");
INSERT INTO mle_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","“Aw li kidi duw di Godab di maarkuw, aw ata ata di wunabir mil sipwutiydibir?” ");
INSERT INTO mle_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Adiy Juw dayadiy sapakwa nyanugw atawa wadil maaj wukikuw, dikik ata wadaad, “Min yaba nyan-adimin. Mina pika duw nyanaam walakw walaakw min maa rav.” Day atawa dikik wakuw, ata yakisakwudaad kawaar dayadi gaba maja wiyaam tidik. ");
INSERT INTO mle_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas di adi duwaam adiy Juw dayadiy sapakwa nyanugw dikim atawa kwurdaal maaj wukikuw, di adi duwaam sitakirakuw, ata bas sidid, “Min duw taakw dayadi Mwamik wukijibir tinadimin?” ");
INSERT INTO mle_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Adi duw Jisasak ata bas sidid, “Yitaypika Duw, wunak aw sikadadaad aw wun dikik wukijibir taw.” ");
INSERT INTO mle_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisas dikik ata wadid, “Min bwutaay viminaad. Di ad ada kita minawa tan maaj bwulanaad.” ");
INSERT INTO mle_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Aw adi duw Jisas diki mwutamawa kwatiyir kwatiyir sikuw, ata wayapiy sidid, “Yitaypika Duw, wun aka minak wukijibir tinadiwun,” wakuw. ");
INSERT INTO mle_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisas dikik ata wadid, “Wun kidi kupwaar datuwil miyawa duw takwaam kajaak baap vitiy tibirkikik. Adiy duw taakw samab Godaam lakwu maarin tinadiy, wun mwugiytuwik, ata mwiyir lakwu-kidanaad. Day adiy mil kwusinadiy duw taakw kaytik tinadiy. Aw adiy duw taakw day wakwanadiy, ‘Nyan Godaam samasam lakwubanaad,’ waan, wun mwugiytuwik, day kajaan tikinadiy Godaam. Day adiy mwiyir vikwanadiy duw taakw kaytik-adiy, aw day ginyir mil kwakikidiy.” ");
INSERT INTO mle_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nuwukadiy Parasiy duw dikiwa walibab ridiy, Jisas atawa wadil maaj wukikuw, ata bas sidaad, “Min nyanak wanadimin, ay? Min wanadimin nyan mil kwakikwanadiy duw kaytik-adiyan, waan?” ");
INSERT INTO mle_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisas dayak ata wadidiy, “Aw li gwur mil kwakikwanadiy duw kaytik tikuw, ‘Godaam nyan samasam maa laakw,’ wakuw, God di bwunak gwuradiy vaal yibwiy-kidadiy. Aw li gwur wakwanadiygwurik, ‘Nyan Godaam samasam lakwubanaad,’ waan, gwur atawa wakwagwuralik tikuw, gwuradiy vaal kip rikinadiy. God di dayaam yibwiy yibwiy maa.” ");
INSERT INTO mle_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Jisas adiy vagaluwdiy duw takwak ata wadidiy, “Sipsip day kabaka yaripaam gaan sikir kwusawuladakib, kwakwanadiy. Adi dayak van tikwanadi duw dayak takatiparib wulakwanaad. Aw li adi takatiparib wula maarkwanadi duw, aw di apiy yaripaar warkuw wulakwanaad, adi duw aad luwkuw kwurkwur tikwanadi duwad. ");
INSERT INTO mle_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","“Adi sipsip ak van tikwanadi duw yadik, adi wiyigak van tikwanadi duw ata sakwutaka-kwadaad dikik. Aw adi duw di dikidiy sipsip ak dayadiy saam sikiyin wajaliydik, day diki kwudiy wukikuw, ata dikik yadaak, di ata kwurin kawaar kalakwu-kwadadiy. ");
INSERT INTO mle_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","“Di dayaam kawaar kalakwukuw, di ata daya tayir yikwanaad. Yidik, aw day diki kwudiy bwutaay lakwu-kwadanalik tikuw, alik day diki kwukib ata yikwanadiy. ");
INSERT INTO mle_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","“Day samab nikidi duw kwukib yi maa. Aw day adi duw diki bwula kwudiy lakwu maarkwadanalik, alik day dikik tabwukinadiy.” ");
INSERT INTO mle_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas adiy duw takwak pakwun tidiy maaj wadil, aw day di dayak wadil maaj maa laakw. ");
INSERT INTO mle_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","AW day lakwu maardalik tikuw, Jisas maa ata dayak wadidiy, “Wun gwurak mwiya mwiyab maajal watuwa. Wun wiyig kaytik-adiwun. Adiy sipsip wulaan wakwun adi kabaka yaripaar tidana pik tinadiwun. Wunadiy duw taakw adiy sipsip kaytik tinadiy. ");
INSERT INTO mle_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","“Adiy nuwukadiy wunak tayir yadiy duw day adiy luwkuw kwurdiy duwadiy. Day adiy sipsip ak gwiyip kwurik yadiy. Aw adiy sipsip dayadiy majik maa wak. ");
INSERT INTO mle_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","“Adiy sipsip adi takatiparib wulakuw yara kwakwak, aw adi takatiparib maa vas kikir wakwukwadana pik, adiy duw taakw day yakidiy wuna danik aw day viyakita mwiy nyanyi nyanyi Godawa yara kwakidiy. Wun wiyig kaytik-adiwun. ");
INSERT INTO mle_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Adiy luwkuw duw yadana day luwkuw kwurik, day duwaam viyasipaak, day jawjaay kwurik. Adiy jaav kwurik yakwanadiy. Aw wun yatuwa aw mwiyir duw taakw Godawa nyanyi nyanyi kwaan, rakarak samasam tidakikik. ");
INSERT INTO mle_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Wun adi sipsip ak galab yarakara kwurkwanadi duw kaytik-adiwun. Adi viyakita sipsip ak galab kwurkwanadi duw, di akis yagakwanaad dikidiy sipsip ak kiyakiyak. Atampik wunabab wunadiy duw takwak kwurkidiwun. ");
INSERT INTO mle_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","“Adi sanak yawiy kwurkwanadi duw, di adi sipsip ak galab kwurkwanadi duw kaytik maa. Aw adiy sipsip di dikidiy maa. Di kipa sanak yawiy kwurkwanadi duwad. Alik tikuw, di dayaam galab akis kwurkwanaad. Di adi nimadi sapiy as vidik, adi duw diki sipak wukikuw, adiy sipsip wapakuw, tabwukwanaad. Adi nimadi sapiy as ata yakuw, adiy sipsip aam vatadik, ata adiy sipsip abab kapakap kapakap miyawa tamiyaar tabwukwanadiy. ");
INSERT INTO mle_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Wunadi Asaay di mwiya mwiyab wunaam lakwudadiwun. Aw wunabab dikim mwiya mwiyab lakwutuwaad. Atampik wun mwiya mwiyab wun wunadiy duw takwaam lakwutuwadiy. Wun adi galab sipsip ak yarakara kwurkwanadi duw kaytik, wun daya danik kiyakidiwun. ");
INSERT INTO mle_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“Samasama duw taakw, day Yisrayil jaka tipa kidiy duw taakw maa, dayabab wunadiy-adiy. Wun yikuw, vagaluw-kituwadiy adiy nuwukadiy jaka tipa kidiy duw taakw. Vagaluwtuwik, day wuna majib lakwu-lakwub tikidiy. Day wunadiy Yisrayil jaka tipa kidiy duw takwawa nakamwiyib tidaak, wun dayak ababak van tikituwadiy. ");
INSERT INTO mle_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Wun wunadiy duw takwak mawul yinadiwun. Daya danik kiyak yaakiya watuwa aw kiyakuw rasikituwalik tikuw, wunadi Asaay wunak mawul samasam yikwanaad a javik. ");
INSERT INTO mle_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","“Duw nakab wunaam viyasip viyasip maa rav wun sip kway maartuwik dikik. Aw wun lakwukuw, wunaki kiyakituwa nyi tilik, aal yaakiya, aal sip kwiykinadiwun wunaam jaaw viyasipadakik. Wun ap tinadiwun atawa kwurkwurik. Wunaam viyasipaan napadaak, wun ap tinadiwun ginyir rasirasik. Aw wunad Asaay bwutaay tasakwudidiwun atawa kwurtuwkik.” ");
INSERT INTO mle_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jisas atawa bwulaan napadik, adiy Juw dikik maaj wukikuw, day dayak ata bwulasakiy bwulasapiradiy diki majik. ");
INSERT INTO mle_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aw samasama duw taakw wadiy, “Kupwarapa wudib diki mawulaar yinaad. Di kwam tinaad. Agwa javik dikik waan takaan rinadiygwurik?” ");
INSERT INTO mle_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aw nuwukadiy wadiy, “Adi wudib mawulaar yikwadanadi duw atampika maaj akis bwulakwanaad. Ata ata kupwarapa wudib mil kwakinadi duw diki mil sipwutiykinaad, ay?” ");
INSERT INTO mle_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tayir Juw duw taakw dayadiy waraga duw mama nibaam kakilkuw, viyayakikuw, ata day God dikidi wiyak watipidadiy. Nabiy nabiy Juw duw taakw a javik wukin kariyataay, bayaki kikipaat takakwanadiy. A bayaki kikipaat takakwadana sikir nikirda taykwana bapa. A bayaki kikipata sikir tad maa Jiruwsalimaam. ");
INSERT INTO mle_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","24","God dikidi wiya tamiy day sikiykwadaad Salaman dikidi veranda, a tamiyaam Jisas tiytiyaan tidik, adiy Juw duw dikim vagaluwkuw, bas sidaad, “Simiy kas minak nyan wukin tikidiyan, ‘Min sikidadadimin,’ wataay? Kitaanabab nyanak awasapwiy mwiya mwiyab. Min mwiya God dikidi Tasakwudidi Duw, ay?” ");
INSERT INTO mle_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aw Jisas dayak ata wadidiy, “Wun bwutaay watuwadiygwurik. Aw gwur wunak wukijibir maa ti. Wunadi Asaay tasakwudidiy diki apaar adiy kwurtuwadiy yawiy. Adiy yawiy gwurak simaka-danadiygwur a javik. ");
INSERT INTO mle_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","“Aw gwur wunadiy duw maa. Alik tikuw, gwur wunak wukijibir maa ti. ");
INSERT INTO mle_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","“Adiy sipsip kaytik adi dayak galab kwurkwanadi duw diki majib wukikwadana pik, atampik wunadiy duw taakw wuna majib lakwu-lakwub tikwanadiy. ");
INSERT INTO mle_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","“Wun mwugiytuwik, day nyanyi nyanyi Godawa kwakidiy. Aw day dikim kajaan ti maa. Wuna tabaam tidaak, Satanawa dikidiy duw samab dayaam nyigil maa. ");
INSERT INTO mle_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","30","“Wunawa wunad Asaay an mwiya mwiyab rivriv tikwanabiran. Alik tikuw, adiy ababa duw taakw wunadi Asaay wunak kwiykuw, diki ap miyawa Satanawa duw dayadiy apaam yitaypik tidalik tikuw, alik day wunadiy duw takwaam samab nyigil nyigil day rav maa wunad Asaay diki tabaam tidaak.” ");
INSERT INTO mle_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Adiy Juw duw Jisas wadil maaj wukikuw, day yaal samasam girakuw, jaab vitiya yay day dikim viyasipak, kabaak nugwudiy. ");
INSERT INTO mle_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisas dayak wadidiy, “Wun bwutaay samasama viyakita yawiy gwura mwutamaam kwurtuwdiy, wunadi Asaay kwurtuwkik kwatiyadidiy yawiy. Kidiy viyakita yawiy agwa yawiyik wunaam kabakir viyasipaak kwurgwuradiwun, ay?” ");
INSERT INTO mle_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Adiy Juw Jisasak sibinin ata wadaad, “Nyan minaam kabakir viyasipaak minadiy kwurminadiy viyakita yawiyik maa. Min sapis jikin waminalik Godak tikuw, alik a javik nyan minaam viyasipaak. Min kipa duwadimin, aw min mina wanadimin, ‘Wun God-adiwun,’ waan.” ");
INSERT INTO mle_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Aw Jisas dayak ata wadidiy, “Nyan lakwubana aal God diki lapa nyig bwulala maaj aal mwiya mwiyaba maaja. God diki lapa nyigaam aal gwura lo kitawa wana, ‘Gwur God kaytik-adiygwur,’ waan. ");
INSERT INTO mle_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“Aw God tasakwudidiwun. Tasakwukuw, kidi kupwaar wayakidik dadiwun. Aw ata atanik tikuw, wagwuradiwun, ‘Min Godak sapis jikinadimin,’ waan, wun God dikidi Nyan-adiwun waan watuwalik? ");
INSERT INTO mle_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Aw li wun God diki viyakita yawiy kwar maartuwik, aal gwur wunak wukijibir titikwa ata. ");
INSERT INTO mle_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","“Aw li wun God dikidiy yawiy kwurtuwik, li gwur wunak ata wukijibir tikir wakuw, aal kip kidiy kwurtuwadiy yawiy av. Vikuw, kip dayak wukijibir ada. Aw day gwuraam sugwiyaan kwurdaak, lakwukigwuraad Asaayim. Aw an nakamwiyib rivriv-abiran.” ");
INSERT INTO mle_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Aw Jisas atawa ki maaj wadik, day ata maa yaal giradiy. Girakuw, ata maa dikim kalakwuk kwurdaad. Aw Jisas di kip dayaam wapakuw, wakwud. ");
INSERT INTO mle_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aw Jisas ata sibinin vakiyid maa Jawtan bayibarib, aal Jon duw takwaam titaay baptais kwiydil tamiyaar. Vakiykuw, ata alib kwaad. ");
INSERT INTO mle_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mwiya samasama duw taakw dikik ata yadiy. Day awarwa awarwa titaay wadiy, “Jon di nimadiy yawiy maa kwar. Aw adiy kidi duwak titaay wadidiy miyawa maaj adiy mwiya mwiyab maajadiy.” ");
INSERT INTO mle_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Samasama duw taakwadiy Jisas kwadaal tamiyaar yikuw, wukijibir tidiy Jisasak. ");
INSERT INTO mle_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lasaras wadadi duw di Bitaniy tipa kidad. Di aad barik kwaad. Bitaniy tip aal Mariyawaliki mwaam Mata biraki tipa. ");
INSERT INTO mle_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ki Maria li aal Yitaypika Duw Jisas dikibir manim yaam samasam yaykwanadi waliy gwaar kaykwatakakuw, likidi nibir vagitil aal. Adi barik kwadi duw, Lasaras aad likidi duwa maagw-ad. ");
INSERT INTO mle_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Aw Lasaras dikibir jikwara vitiy Mariawa Mata ata maaj kwiytakabiril Jisasak, “Adi mawul yikwaminadi duw ada barik kwanaad,” wakuw. ");
INSERT INTO mle_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aw Jisas biraki kwiytakabiril akiy maaj wukikuw, ata adiy vagaluwin tidiy duw takwak wadidiy, “Ki diki giviyib di kiyadikik maa yi. Aw aal diki giviyib kip duw takwaam mwugiylik, aw day Godak wayapiy sikinadiy. Aw li mwugiylik, duw taakw God dikidi Nyinik ab wayapiy sikidanaad.” ");
INSERT INTO mle_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas di Matawa Lasaras biraki nyamwus dayak mawul samasam yikwadidiy. ");
INSERT INTO mle_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Aw di wukikuw Lasaras barik kwadil akiy maaj, di yabiyib maa yi. Di kip a tipab kwaad nyi vitiy. ");
INSERT INTO mle_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nyi vitiy yibirik, Jisas ata adiy dikidiy kalivadidiy duwak wadidiy, “Nyan may! Juwtiya tamiyaar sibinin yinaak maa,” wakuw. ");
INSERT INTO mle_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Aw adiy dikidiy kalivadidiy duw atawa Jisas wadil maaj wukikuw, Jisasak ata wadaad, “Simiy maa, nagisal, minaam adiy Juw duw kabakir viyasipak kwurdaal. Aw agwa javik tikuw maa aril yikir wanadimin?” ");
INSERT INTO mle_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisas dayak ata wadidiy, “Aw gwur bwutaay lakwugwura, nyi sikwadadiy ganbab sitaay aw yin galaab gilpi-kwada. Aw li duw nyi tiytiyakida, di samab vasipinyguw maa. ");
INSERT INTO mle_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","“Aw li duw gaan tiytiyakida, aw nyi maa ti, alik di vasipinyguw-kinaad. Aw wunaki kiyakituwa nyi maa nibway ti. Alik tikuw, day wunaam viyasip maa.” ");
INSERT INTO mle_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas ata dayak wadidiy, “Nyanadi kapa duw Lasaras, di ada si kwanaad. Aw wun yikuw, wajawiyakituwaad.” ");
INSERT INTO mle_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aw adiy dikidiy kalivadidiy duw ata wadiy, “Aw li kipa si kwakida, Yitaypika Duw, di viyakit tikinaad. Alik tikuw, nyan dikik yin wajawiya-baba.” ");
INSERT INTO mle_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas di wadil maaw maaj aal Lasaras kiyadilik. Aw dikidiy kalivadidiy duw di wadilik wadiy, “Di kipa si kwadalik wanaad,” wakuw. ");
INSERT INTO mle_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Aw day atawa wukidalik tikuw, Jisas ata yarakara wadidiy, “Lasaras bwutaay kiyanaad,” wakuw wadidiy. ");
INSERT INTO mle_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","“Aw wun wukituwa aal mwiya viyakita gwura danik tikuw, wun Lasaras wukin kwu maartuwil di bas barik tidil sikir. Aw aal kwurkituwa jaav li sugwiyaan kwurkiladiygwurik wunak wukijibir tigwurkikik. May ya yinaak.” ");
INSERT INTO mle_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, adi vitiy kisa nyan, adiy Jisas kalivadidiy kapa nawiy duwak ata wadidiy, “May, nyan jaaw abab gaba maja duwawa nakamwiyib yinaak. Yikuw, jaaw kiyanaak dikiwa nakamwiyib.” ");
INSERT INTO mle_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lasaras kawamiyaam gividaak kwadik, nyi aliya yawaam Jisas ata yad. Yikuw, a tipaam vidil Lasaras dim bwutaay gividaad. ");
INSERT INTO mle_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Aw Bitaniy tip sikaam maa ri. Walibab Jiruwsalimawa ral. Aw mwiya samasama Juw duw takwadiy varadiy Bitaniy tipaar Mariawa Mataam kwurin rikir, aw birakidi duw maagw kiyadilik tikuw. ");
INSERT INTO mle_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aw Jisas yataay tidil maaj wukikuw, Mata ata li wakwul dikim sitakirak. Aw Maria li kip wiyab ral. ");
INSERT INTO mle_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","22","Aw Mata ata Jisasak walid, “Aw li min kip kilib kwakik-mina, Yitaypika Duw, aal rivik-na, anadi duwa maagw akis kiyak-naad. Aw wun bwu lakwutuwa, kitaanab God bwunak kwiykidadimin dikik bas niki jaav niki javik sikimina.” ");
INSERT INTO mle_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisas ata likik wadil, “Nyinadi duwa maagw rasikuw maa kwakinaad.” ");
INSERT INTO mle_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Li dikik ata walid, “Ayiy, wun bwutaay wukituwa ginyir kidi kupw kwusikida nyi God ata karasitaka-kidaad aw mwiyir dikiwa kwadikikik.” ");
INSERT INTO mle_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Jisas likik ata wadil, “Wun duw takwaam mwugiytuwik, rasikinadiy. Wun mwugiytuwik, Godawa nyanyi nyanyi kwayakinadiy. Adiy duw taakw wunak wukijibir tikinadiy, aw li day kiyakidanaal ab, day Godawa kip nyanyi nyanyi kwayakinadiy. Aw li adiy atawa kip kwakuw wunak wukijibir tikinadiy duw taakw day samab Godawa kajakuw kwusirib kwas maa. Ata ata ki majik wukijibir tinanyin?” ");
INSERT INTO mle_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aw Mata ata Jisasak walid, “Ayiy, Yitaypika Duw, wun wukijibir tinawun. Wun wukijibir tituwa min adi God di dikidi Tasakwudidi Duw-adimin. God di dikidi Nyanadimin, aw min kidi kupwaar dadimin.” ");
INSERT INTO mle_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Atawa Mata waan napakuw, li ata sibinin yikuw liki nyamwus Mariaak, kwasa kwasa walil, “Adi Gaba Maja Duw kinaay ada bwutaay yanaad. Di nyinak bas sinaad dikik yinyinkikik.” ");
INSERT INTO mle_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","30","Aw Maria atawa walil maaj wukikuw, ata yabiyib pwiyiryak rasikuw, ata dikik yal. Jisas di tipaar maa nibway wul. Di kip aal taay Mata yikuw dim sitakiralil tamiyab tad. ");
INSERT INTO mle_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Aw adiy a wiyaam Mariaam kwurin ridiy Juw duw taakw vidaak li rasikuw yabiyib wakwulilik, day wadiy, “Li adi kawamiyaam kwaan girak wakwuna.” Alik day liki kwukib yidiy. ");
INSERT INTO mle_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria yikuw, aal Jisas tidil tamiyaar wakwukuw, dikim vikuw, li ata dikibir manwa vakiril. Vakirkuw, ata walid, “Yitaypika Duw, aw li min kilib kwakik-mina, wunadi duwa maagw akis kiyak-naad.” ");
INSERT INTO mle_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas vidik li giralik, adiy liwa liki kwukib yadiy Juw duw taakw ab giradaak, diki mawul dayak samasam wukil. ");
INSERT INTO mle_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Atawa wukikuw, dayak ata bas sididiy, “Akim givigwurid?” Aw day dikik ata wadaad, “Yitaypika Duw, may. Yakuw av.” ");
INSERT INTO mle_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aw Jisas ata giraad. ");
INSERT INTO mle_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Adiy Juw duw taakw vidaak giradik, ata wadiy, “Av diki Lasarasak wukida mawulak.” ");
INSERT INTO mle_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aw nuwukadiy duw taakw wadiy, “Di adi mil kwakidi duw dikibir mil sipwutiydibir. Di maa? Aw Lasaras kip tidik kiy maarkuw nibway, di tayib yakik-da dim bwunak sipwutiyik-daad.” ");
INSERT INTO mle_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas atawa wadadiy maaj wukikuw, di mwiya samasam wukid. Atawa wukikuw, ata yad Lasaras dikidi kawamiyaar. Adi kawamiy dipwu kabaakad, day daya vadaad. Aw mwiya nimadi kabakir takatipidaad adi kawamiyaam. ");
INSERT INTO mle_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas ata adiy duw takwak wadidiy adi takatipidadi kabaak timildakik. Aw adi kiyadi duw diki jikwaar Mata, Jisasak ata walid, “Yitaypika Duw, nyi aliy aka dim rimsuwbaak kwada. Kupwarapa yaam warkina,” wakuw walid. ");
INSERT INTO mle_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aw Jisas likik ata wadil, “Aw li nyin wunak wukijibir tikinyina, nyin vikinyinaad God nimadi yawiy kwurdik. Bwutaay watuwanyinik, ay?” ");
INSERT INTO mle_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","Aw ata day adi nimadi kabaak timildaad. Adi kabaak timilin napadaak, Jisas kituw vikuw adawur tubwaar, ata waad, “Asaay, minak wayapiy sinadiwun aw min wuna maaj wukiminalik. Wun bwu lakwutuwa min wuna maaj bwu wukimina. Wun minak aka bwulanadiwun aw kidiy duw taakw mwiyir vikuw lakwudakik, aw day mwiyir wukijibir tidakikik min mina wunaam wayaki-mindiwun.” ");
INSERT INTO mle_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Atawa waan napakuw, di nimadib ata gaam sikuw, ata waad, “Lasaras, min aras!” ");
INSERT INTO mle_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Adi kiyadi duw ata pwiyiryak rasid. Rasikuw, ata wakwud. Taay dikim kawamiyaam takadaal, day diki amwiyim nimadiy wapwiy kaydapidaad. Aw di wakwudil adi kawamiyib tikuw, dikim kaydapidadiy wapwiy kip tidiy dikibir tabawa manwa diki miyawa mwutamaam. Aw Jisas ata adiy walibab tidiy duwak wadidiy, “Adiy diki sipaam tinadiy wapwiy raliygwurik, yikwaad.” ");
INSERT INTO mle_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Adiy samasama Juw duw taakw Mariyaam kwurin rikir yadiy Jisas atawa kwurdil yawiy vikuw, day dikik wukijibir tidiy. ");
INSERT INTO mle_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aw nuwukadiy kip sibinin yidiy. Yikuw, adiy Parasiy duwak yarik yidadiy aal Jisas kwurdil yawiy maaj. ");
INSERT INTO mle_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Yarik yidaal maaj wukin napakuw, adiy Parasiyawa adiy yitaypika pris nakamwiyib adi Juw dayadiy kaunsil awa vagaluwkuw, ata wadiy, “Kidi duw di samasama nimadiy yawiy adiy kwurdadiy. Aw li nyan kip wapabaak, kwurjibir kwurjibir tikida, miyawa duw taakw adiyka dikik wukijibir tikinadiy. Aw day atawa dikik wukijibir tikidana, aw adiy Roma gavman dayadiy yitaypika duw day pitaan warkinadiy. Warkuw, aw day yakuw, kidi God dikidi gaba maja wiyawa nyanadi jaka tip miyawa ada saar kwurkuw, jawjaay kwurkidanaad.” ");
INSERT INTO mle_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Daya duw nak ad Kayapasad. Adi nabiy day dim tasakwudaad Mwiya Yitaypika Pris tidikikik. Nuwukadiy ababa pris ak yitaypik tad. Di dayak ata wadidiy, “Gwur mwiya kwam tinadiygwurik, ay? Aw gwur maa laakw aal mwiya viyakital duw nak kiyakida kidiy kidi jaka tipa kidiy miyawa duw takwak aw adiy Roma vay sawdiy duw miyawa duw takwaam viyasipa-yaay?” ");
INSERT INTO mle_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayapas atawa bwuladil, di diki kapa mawulaar maa bwul. Atawa wadil, Jisas di kiyakinaad miyawa Juw duw takwa danik tikuw, God aal diki mawulaam sisuwdik, ginyir mwiya mwiyab tikina javik atawa wadila. ");
INSERT INTO mle_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jisas di adiy Juw duw takwadikanik tikuw, kiy maa, aw mwiyir kidi miyawa kupwa kidiy tamiyaam adiy duw taakw nakamwiyib God dikidi gwalugwum vagaluwdakik, alik tikuw kiyakinaad. ");
INSERT INTO mle_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aw ata a nyab karayrib day Jisasaam viyasipaak, ata aban titaay takadiy. ");
INSERT INTO mle_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Atawa aban takadalik tikuw, Jisas di samab maa tiytiyaan ti samasama Juw duw taakw kwadadiy tamiyaar. Aw di adiy tamiyaar tiytiya-yaay, di aal Yipirayim wadaal jaka tipaar yad. Aal duw taakw kwu maardaal tamiyawa walibab ral. A tipaam di dikidiy kalivadidiy duwawa nakamwiyib kwadiy. ");
INSERT INTO mle_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Adi Juw duw takwaam God Nyigildidiy bayaki kikipata Nyi walibab tidik, niki tipa niki tipa kidiy samasama duw taakw yadiy Jiruwsalimaar. Bas day gaba maaj sukwuk dayadiy vaal God diki mwutamaam sipwutiyik mwiyir tikir. ");
INSERT INTO mle_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Aw adiy duw taakw day Jisasak titaay kwakiyi-kwakiyadiy. Aw day God dikidi wiyaam vagaluwun rikuw, ata day dayak ritaay, awarwa awarwa bas sidiy. Day wadiy, “Ata ata min wukimina, Jisas di kidi bayaki kikipatik yakinaad? Ay maa?” ");
INSERT INTO mle_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aw adiy yitaypika pris awa Parasiy bwutaay maaj kwiydadiy adiy duw takwak. Kwiykuw, wadadiy aw li daya duw ay taakw nakab aal Jisas kwada tamiy lakwukuw, dayak yarik yidakikik aw day dikim kalakwuk. ");
INSERT INTO mle_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nyi abwun kip ridiy adi God Juw duw takwaam Nyigildidiy bayaki kikipata Nyi. Jisas ata Bitaniy tipaar yad, Lasaras kwadil tipa. Di ad adi kiyadik Jisas kirapitakadidi duw. ");
INSERT INTO mle_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aw day Jisas diki danik tikuw, kamnaagw adiy sukwulik yidadiy. Jisas wukin jabim kamnaagw kikir Lasaras daan ridik, Mata li kamnaagw am sal. ");
INSERT INTO mle_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria ata kwurlid viyakita yaam samasam yaykwanadi waliy guw aw day wakwadanaad Nat. Adakapaam kapwukwanadi guw kaytikad. Kwurkuw, ata kaykwatakalid Jisas dikibir manim. Kaykwatakaan napakuw, ata dikibir maan likidi nibir vagitilibir. Aw miyawa wiy adi waliy guw dikidi yaamada yayin tad. ");
INSERT INTO mle_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Aw Jisas dikidiy kalivadidiy duwa kidi duw nak, Juwtas Yiskariyat, aw di ad ginyir Jisas dikidiy mama nib tabaam takadid. Aw di atawa Maria Jisasaam kwurlil yawiy vikuw, ata waad, “Duw taakw wadi waliy guw yapiykwadanaad saan jiligaar jiligaar, duwamiy mugwul. Aw adiy saan kwurkuw, mwiyir adiy saal yikwanadiy duw takwak kwiyik-ladiy. Aw li agwa javik atawa kwurlaad?” ");
INSERT INTO mle_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aw di atawa bwuladil di samab akis adiy saal yikwanadiy duw takwak galab kwuryikwaad. Di atawa wadil aw di adiy Jisasawa dikidiy kalivadidiy duw dayadiy saan di galab kwurdidiy. Aw di dayadiy nuwukadiy saan di dikik kwurdidiy. ");
INSERT INTO mle_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","8","Aw Jisas dikik ata wadid, “Likik watikwa. Aw li atawa kwurla, aw wun kawamiyaam kwakituwalik tikuw, kwurjibirala yawiya. Aw li min adiy saal yikwanadiy duw takwawa nakamwiyib kwurin kwayataay, min nibwu sugwiyaan kwuril. AW wun minawa simiy kwu maa.” ");
INSERT INTO mle_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mwiya samasama Juw duw taakw wukidaal Jisas ada Bitaniy tipaam kwanaad. Atawa day wukikuw, ata yidiy aril, aw day Jisas di dikanik tikuw maa, aw day vikir Lasarasaam ab, adi kiyadik Jisas kirapitakadidi duwaam. ");
INSERT INTO mle_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Aw adiy yitaypika pris atawa maaj wukikuw, day ata maaj lakatiydiy Lasarasaam ab viyasipaak. Aw mwiya samasama Juw duw takwadiy Jisas Lasarasaam kiyadik kirapitakadil maaj wukikuw, aw day adiy yitaypika pris ak bwan kwiykuw, aw day Jisasak wukijibir tikir kwurdalik tikuw. ");
INSERT INTO mle_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sira pik adiy Jiruwsalimaam adi God Juw Duw Takwak Wapadidiy Bayaki Kikipata kamnaagw kikir yadiy duw taakw ata wukidaal, “Jisas ada Jiruwsalimaar yanaad,” wadaal maaj. ");
INSERT INTO mle_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wukikuw, day ata adiya miyawa tipa gay kwurkuw, wakwudiy Jisasaam sitakirak, kitawa gaam sitaay: “Wayapiy as Godak! God kidi duwak sukwasukw kwurkwaad! Adi Yitaypika Duw God dikidi saam yanaad. God sukwasukw kidi Yisrayil jaka tipa kidi yitaypika duwak kwurkwaad!” wataay wadiy. ");
INSERT INTO mle_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas donki wakwadanadi jaav sitakirakuw, diki apiy bwunim daan ridid, aw aal God diki lapa nyig walil pik. ");
INSERT INTO mle_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Gwur yagatikwa, Jiruwsalim jaka tipa kidiy duw taakw. Av! Gwuradi yitaypika duw ada yanaad badiy donki apiy bwunim daan rikuw.” ");
INSERT INTO mle_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Aal nyab Jisas dikidiy kalivadidiy duw samab maa laakw aal maaj liki mwiya maaw. Aw ginyir Jisas kiyadik, God dikim kirasitakadik, adawur tipaar wardik, ata ya lakwudaal. “Aal God diki lapa nyig kil walil maaj aka bwutaay mwiya mwiyaba maaj tina,” wakuw wadiy. ");
INSERT INTO mle_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Adiy miyawa duw taakw vidaak Lasaras kiyakuw kawamiyaam kwadik, Jisas gaam sikuw dim kirapitakadik, aw day adiy nuwukadiy duw takwak wasapwiydadiy a javik. ");
INSERT INTO mle_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Aw adiy duw taakw kwurdidi nimadi yawiy maaj wukikuw, adi danik tikuw, wakwudiy Jisasaam sitakirak. ");
INSERT INTO mle_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Aw adiy Parasiy vidaak miyawa duw taakw Jisasak yidaak, ata ritaay daya dayak bwuladiy, “Av! Miyawa duw taakw adiyka Jisas kwukib yinadiy. Aw nyan samab maa rav jaav nakab kwurkwurik.” ");
INSERT INTO mle_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nuwukadiy Grik jaka tipa kidiy duw taakw ab ridiy adi bayaki kikipata nyi Jiruwsalimaar Godak gaba maaj sukwuk yidiy duw taakw dayadiy nyidim. ");
INSERT INTO mle_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aw day Pilipak yidiy. Di Bitsayta tipa kidad Galiliy tamiyawa. Dikik yikuw, ata bas sidaad, “Yitaypika duw, nyan Jisasak dim vikir.” ");
INSERT INTO mle_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Aw Pilip Adiruwak yikuw, ata yarik yidid. Yikuw, bir nakamwiyib Jisasak ata wabirid. ");
INSERT INTO mle_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Aw Jisas birkik ata wadibir, “Yaakiya, nyi aka tina ya. God mwugiydik, duw taakw dayadi Mwamik wayapiy sikidana. ");
INSERT INTO mle_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","“Wun watuwadiygwurik mwiya maaj, aw li kadiy mwiy nak kip rikila, si maarin, likida kip rikina. Aw li mayim sikuw, kwusikuw, saar warkuw li mwiya samasama kadiy-adiy maa kwurkiladiy. ");
INSERT INTO mle_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Aw li adiy duw ay taakw day daya kapa sipak mawul yikinadiy, day kajakidiy Godawa. Aw li adiy day dayadiy kapa sipadanik mawul yi maarkinadiy kidi kupwaam, wunak mawul yitaypik wukikinadiy, day viyakita mwiy Godawa nyanyi nyanyi kwayakidiy. ");
INSERT INTO mle_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","“Adiy duw taakw day wunak yawiy kwurkinadiy, day wuna kwukib yakwadiy. Aw day atawa kwurkidana, day wunawa kwakinadiy adawur tipaam. Aw wunad Asaay sukwasukw kwurkidadiy adiy wunak yawiy kwurkwanadiy duw takwaam.” ");
INSERT INTO mle_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisas ata dayak wadidiy, “Ki wunaki mawul mwiya samasam wukina. Alik ata ata wakinadiwun? Jaaw waaw Godak, ‘Asaay ki wuna sipaar kagil yikila nyi wunak yaliba,’ waan waaw? Suwana! Akaanaka, wun kidi kupwaar datuwil mwiya maaw.” ");
INSERT INTO mle_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aw Jisas ata Godak wadid, “Asaay, duw takwaam dayadiy mawulaam sisuwminik, minadi saam yakisuw taka-kwadiy.” Aw Jisas atawa waan napadik, adiy vagaluwdiy miyawa duw taakw adawur tipaam maaj aal wukidaal kitawa walik. “Tayir duw taakw dayadiy mawulaam wun wuna sisuwtuwik, day wunadi saam yakisuw takadaad. Aw kitaan ab atawa wun kwurkituwadiy.” ");
INSERT INTO mle_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aw adiy a maaj wukidiy duw taakw day ata wadiy, “Kasaal dakwada kwudiy pik wanaad.” Aw nuwukadiy wadiy, “God diki maaj kardadi duwad dikik wanaad.” ");
INSERT INTO mle_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Aw Jisas dayak ata wadidiy, “Ki kwudiy dala wuna danik tikuw maa. Gwur gwura danik tikuw, alik dana. ");
INSERT INTO mle_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Akaanaka tina God miyawa duw takwaam kotiy kida nyi adiy wunak wukijibir ti maarkinadiyim. Di kakil-kidaad Satanaam, adi duw takwaam van tikwanadi duw. ");
INSERT INTO mle_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","“Aw day wunaam adi maap tikinadi miyaam kataan napakuw, vatakasuwdaak, kupwaam tituwik, ata ya sisuwkituwadiy miyawa tamiya kidiy duw taakw dayadiy mawulaam wunak wukijibir tidakikik.” ");
INSERT INTO mle_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Aw Jisas dayak atawa wadil di dayak simakak aal diki kiyakida kiyak. ");
INSERT INTO mle_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Aw adiy vagaluwdiy miyawa duw taakw dikik wataykuw, ata wadaad, “Nyan God diki lapa nyig walil maaj lakwubana aal adi God Tasakwukidadi Duw di kiy maa. Di kip viyakita mwiy nyanyi nyanyi kwayakinaad. Aw ata ataanal wa wamina maaj ‘Duw taakw dayadi Mwamim maap tikinadi miyaam katakuw, vatakasuwdaak, tikinaad,’ waan? Di sikadadaad, adi duw taakw dayadi Mwaam?” ");
INSERT INTO mle_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aw Jisas dayak ata wadidiy, “Kwasa mwiy wun gwurawa gwuradiy nyidim tikidiwun nyi kaytik. Wun kaliva-kituwadiygwurik God dikidi viyakita yaab. Aw adi yabib gwur kaykiti-jibir ada, aw ata Satan gwuraam van tikik-dadiygwurik gaan kaytik. Aw adiy duw taakw day ganim tiytiyakuw, aw day laakw maarkwadana pik yiyi yabik. Atampika duw taakw adiy Satan dikidi yabib kaykiti-jibir tikwanadiy. ");
INSERT INTO mle_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","“Wun lam kaytik-adiwun. Ganim kariyaan tinadiwun. Wun kitanabab gwurawa kwatuwik, kip wukijibir ada. Wunak atawa wukijibir tikigwura, gwur viyakita mwiy kwakidiygwurik wunadiy duw taakw tikuw.” Atawa Jisas ki maaj dayak waan napakuw, ata dayak gwutakaad. Yikuw, ata pakwud aw ginyir dikim vi maardakik. ");
INSERT INTO mle_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aw dayadiy mwutamaam adiy nimadiy yawiy kwurdidiy ab day samab dikik maa wukijibir ti. ");
INSERT INTO mle_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Atawa tidaak, aal maaj God diki maaj wasapwiydi duw, Aysaya, bas wadil maaj ata mwiya mwiyab tal. Di kitawa waad: “Yitaypika Duw God, duw nakab maa ki nyan duw takwak kalivakwabana mwiya mwiyaba majik wukijibir ti. Day bwutaay vidana minaki ap aw day samab maa wukijibir ti a javik.” ");
INSERT INTO mle_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Agwa javik tikuw adiy Juw duw taakw day adi God Tasakwudidi Duwak wukijibir ti maardaala? Aw day mwiyir dikik wukijibir ti maardaal maaw, aw tayir Aysaya kitawa waad: “God dayadiy mil wabupwu-didiy aw day mwiyir vi maardakik. Awarab dayadiy mawul sitipi-didiy aw day mwiyir laakw maardakik. ‘Ata day wunak tipatiyakwuk-daak, wun sipwutiyik-tuwadiy,’ wakuw.” ");
INSERT INTO mle_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tayir Aysayak God simakadid adi Jisas dikidi kwurkidadi nimadi apawa gilabadiy. Alik tikuw, atawa bwuladilal Jisasak tikuw. ");
INSERT INTO mle_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Aw mwiya samasama Juw yitaypika duwadiy Jisasak wukijibir tidiy. Aw day adiy Parasiyak yagadiy, ata nyanaam God dikidi gaba maja wiyak watipik-danadiyan wakuw. Day samab maa wasapwiy nuwukadiy duw takwak, “Nyan Jisasak wukijibir tinadiyan,” waan. ");
INSERT INTO mle_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aw dayak mwiya yitaypik til jaav aal duw taakw dayak majir wayapiy sidaal aw God dayak wayapiy si-yaay. Alik day atawa kwurdaal. ");
INSERT INTO mle_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","45","Aw Jisas dayak nimadib ata wadidiy, “Adiy duw taakw wunak wukijibir tinadiy, day wunadanik maa wukijibir ti. Day adi wunaam kidi kupwaar wayakidi Asayik ab wukijibir tinadiy. Adiy wunaam lakwunadiy duw taakw daya wunaam lakwuda pik adi wunaam wayakidi Asayim ab lakwudana pik lakwudanaad. ");
INSERT INTO mle_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","“Wun kidi kupwaar nyi kaytik dadiwun adiy wunak wukijibir tikinadiy duw taakw day Satan tabaam ti maardakik aal ganim kwana pik nyanyi nyanyi. ");
INSERT INTO mle_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Wun samab kotiy maa adiy wuna maaj wukikuw, wukijibir ti maarkinadiyim. Wun maa di kidi kupwaar duw takwaam kotiy ik. Aw wun awarir dayaam sugwiyaan kwurik dadiwun, aw mwiyir Godawa viyakita mwiy nyanyi nyanyi kwayadakik. ");
INSERT INTO mle_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","“Aal kidi kupw kwusikida nyaam adiy wuna majik bwan kwiykwanadiy miyawa duw taakw wuna majik wukiwukik kwasik yitaay, day adi God dikidi nimadi kot im tikinadiy. Adi kot im aal dayak watuwil maaj a maajal jas kaytik tikuw, dayaam kotiy kina. ");
INSERT INTO mle_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Aw atawa tikila. Wun wuna kapa majir akis maaj bwula-kwanadiwun. Wun adi wunaam wayakidi wunad Asaay bwutaay wakituwadiy majib majib wadidiwun. Alik adiy maaj-adiy wakwatuwadiy. ");
INSERT INTO mle_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","“Wun lakwutuwa aal adiy duw taakw God diki majib lakwu-lakwub tikinadiy, day viyakita mwiy nyanyi nyanyi dikiwa nakamwiyib kwayakinadiy. Alik tikuw, wun duw takwak kaliva-kwatuwadiy adiy wunadi Asaay wunak kalivatuwkik wadidiy majib majib.” ");
INSERT INTO mle_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Adi Juw duw takwaam God Nyigildidiy bayaki kikipata Nyi tikir tilik, adiy Juw duw taakw kikidana nyi, aw Jisas di bwutaay lakwudil aal diki ganir nakal kidi kupwaam kwakuw dikidi Asayik sibinkida. ");
INSERT INTO mle_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Jisasawa dikidiy kalivadidiy duw daan rikuw, kamnaagw kidiy. Satan bwutaay tasakwu-jibiradid Juwtasaam, Sayman Yiskariyat dikidi nyinim, Jisasaam kwiydikik dikidiy mama nib tabaar. Jisas bwu lakwudil dikidi Asaay ababa jaav bwutaay diki tabaam takayakididiy. Awarab di lakwudil di kidi kupwaar daad Godab tikuw, aw maa sibinin Godak warkida nyi aka walibab tina. Di mwiya mawul yikwadadiy dikidiy kalivadidiy duwak. Di dayak mawul yaan tidil yin diki kiyadil nyab. ");
INSERT INTO mle_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aw day jabim rikuw, Jisas ata rasid. Rasikuw, dikidi apiyim kwusuwkwadadi wapwiy ata raliydid. Raliykuw, taul kwurkuw, ata diki yipagayaam jibirdil. ");
INSERT INTO mle_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Guw ata kwurdid. Kwurkuw, wukisakiydid adakapaar. Wukisakiykuw, ata dikidiy kalivadidiy duw dayadiy maan jandidiy. Jankuw, aw a diki yipagayaam kaygwajidi taul kwurkuw, ata dayadiy maan vagiti-didiy. Aw aal kipa yawiy duw taakw daya yawiyal. ");
INSERT INTO mle_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pitaak yidik, aw Pita ata wadid Jisasak, “Min wunabir maan jankiminabir, Yitaypika Duw, ay?” ");
INSERT INTO mle_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisas dikik ata wadid, “Min kita samab maa laakw ki kwurtuwa jaav liki maaw. Aw ginyir ata lakwukimina ki kwurtuwa yawiy liki maaw.” ");
INSERT INTO mle_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“Aw min samab wunabir manim janmugwuk!” Pita ata wadid. Ata Jisas ata dikik wadid, “Aw li wun minabir maan jan maarkituwa, min samab wunadi kalivakituwadi duw ti maa, wukimina?” ");
INSERT INTO mle_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aw Pita dikik ata wadid, “Yitaypika Duw, yaakiya, ata wunabir maandika jantikwa. Nakamwiyib wuna abwawa taab ab ajaan!” ");
INSERT INTO mle_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Aw Jisas dikik ata wadid, “Adiy yarakara guw yakwukidiy, dayadiy sip tik ti maa. Aw day akis maa ginyir guw yakwukwanadiy. Day kipa maandika jankwanadiy. Gwur abab gwuraam tik maa ti. Aw duwaar nakad kip tikawa tinaad.” ");
INSERT INTO mle_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas di bwu lakwudid adi dim dikidiy mama nib tabaam takakinadi duw. Alik tikuw, wadilal “Gwur abab tik maa ti. Aw duwaar nakad kip tikwawa tinaad,” waad. ");
INSERT INTO mle_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas dayadiy maan jankwusin napakuw, yaakiya ata dikidi kaypwutiydidi apiyim kwusuwkwadadi wapiy ata maa sibinin kwusuwkuw, ata sibinin yikuw, daan maa rad jabim ridil tamiyab. Daan rikuw, ata dikidiy kalivadidiy duwak bas sididiy, “Ata ata, ki gwurak kwurtuwa yawiy liki maaw lakwugwura? ");
INSERT INTO mle_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Gwur sikiy-kwagwuradiwun ‘Gaba Maja Duw’ aw ‘Yitaypika Duw,’ wataay. Aal yaak, aal mwiyir sikiy-kwanadiygwurik. Aw wun wun-adiwun. ");
INSERT INTO mle_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","“Aw wun, gwuradi Yitaypika Duw tikuw, Gaba Maja Duw tikuw, gwuradiy maan jantuwadiy. Alik tikuw, aal viyakital gwurabab awarwa awarwa gwuradiy maan ab atawa jankigwura, mawul kwusida-takaan titaay. ");
INSERT INTO mle_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","“Aw wun, gwuradi Yitaypika Duw, ki yisada pik tikwanadi duw kwurkwada yawiy kwurtuwa, aal wun gwurak simakatuwala gwurabab atawa tigwurkikik. ");
INSERT INTO mle_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","“Wun gwurak mwiya mwiyab watuwadiygwurik, adi yawiy kwurkwanadi duw nikidi duwak, di yitaypik akis tikwanaad adi dikik yawiy kwurdikik kwiykwanadi duwaam. Awarab adi akiy niki tipaar karaykwanadi duw di adi dikik a akiy maaj karaydikik wayakikwanadi duwaam akis yitaypik tikwanaad. ");
INSERT INTO mle_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","18","“Li gwurak kidi kalivatuwadi yabib lakwukigwura, lakwukuw kwurkigwura, ata gwur viyakita mwiy kwa-kinadiygwurik. Aw gwura duw nak viyakita mwiy kwu maa. Wun bwu lakwutuwadiy adiy tasakwutuwadiy wunadiy tidakikik. Aw gwura duw nak mwugiykuw, ki God diki lapa nyigaam rina maaj ata mwiya mwiyab tikina. Ki maaj kitawa wana: ‘Adi wuna kamnaagw kikinadi duw di wunak bwan kwiykinaad.’ Aw adi duw ab tasakwutuwid wunaad tidikikik. ");
INSERT INTO mle_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Wun gwurak ki jaav kita watuwadiygwurik, yabiyib ti maarlik. Aw li a jaav mwiyir tilik, ginyir ata gwur wukijibir tikinadiygwurik wun adi God dikidi Tasakwudidi Duwadiwun, wakuw, aal tayir duw takwak wayatuwil pik. ");
INSERT INTO mle_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Wun mwiya mwiyaba maaja gwurak watuwa, adiy wun wayaki-kituwadiy duw wuna yawiy kwurdakik, aw adiy duw taakw dayak mayaakw kwakidana pik, aal day wunak ab mayaakw kwanapik kwakidanaala. Aw adiy duw taakw atawa wunak mayaakw kwakinadiy pik kwakidiy, aal day adi wunaam wayakidi wunadi Asayik ab mayaakw kwanapik kwakidanaala.” ");
INSERT INTO mle_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Atawa Jisas waan napakuw ki maaj, diki mawul mwiya samasam wukil. Atawa wukikuw, ata di dayak mwiya mwiyab wadidiy, “Wun mwiya maaj watuwadiygwurik, gwura duw nak wunaam wunadiy mama nib tabaar kwiykidadiwun.” ");
INSERT INTO mle_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Aw adiy dikidiy kalivadidiy duw ata awarwa awarwa ritaay, vidiy daya dayak. Day samab maa laakw adi Jisas wadidi duwaam. ");
INSERT INTO mle_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aw wunadiwun, adi Jisas mawul samasam yikwadadi duw, wun dikiwa walibab ridiwun. ");
INSERT INTO mle_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Aw Sayman Pita ata wunak mil yikuw wadidiwun dikik bas situwkikik, “Sikadadaad adi waminadi duw?” waan. ");
INSERT INTO mle_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aw wun Jisasak walibab sisakiykuw, ata bas situwid, “Sikadadaad, Yitaypika Duw, adi waminadi duw?” ");
INSERT INTO mle_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Aw Jisas wunak ata wadidiwun, “Wun tabikariba naagw kwurkuw, kidiy kamnaagw guwaam bwusikuw, kwiykituwadi duw, adaanada. Di ad wunaam wunadiy mama nib tabaam takakinaad.” Aw di ata a tabikariba naagw kwurkuw, adiy kamnaagw guwaam bwusikuw, ata kwiydil Juwtasak, Sayman Yiskariyat dikidi nyanad. ");
INSERT INTO mle_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Aw Jisas aal tabikariba naagw Juwtasak kwiydil, aw dikik simakak di bwutaay lakwudil di ad dim takakinaad dikidiy mama nib tabaar. Aw Satan ata yakuw, Juwtas mawulaam rawdid. Aw Jisas Juwtasak ata wadid, “Yabiyib maay! Yikuw, wa kwurik mawul yimina yawiy akwur yabiyib!” ");
INSERT INTO mle_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Aw Jisas atawa Juwtasak wadil maaj liki maaw maaj, aw adiy nakamwiyib jabim daan ridiy duw day samab maa laakw. ");
INSERT INTO mle_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Juwtas di adiy day dayadiy sanak galab kwurkwanaad. Aw alik tikuw, nuwukadiy Jisas dikidiy kalivadidiy duw ritaay, wukidiy, “Jisas di Juwtasak wayakidaad kidi bayaki kikipata kamnaagw yapiydikik, ay adiy saal yikwanadiy duw takwak saan kwiydikik way wayakidaad.” ");
INSERT INTO mle_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Aw Juwtas aal tabikariba naagw kwurkuw, di ata jayib nak ganika gaan kawaar wakwud. ");
INSERT INTO mle_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Aw Juwtas dayaam wapakuw, wakwudik kawaar, Jisas ata dayak wadidiy, “Yaakiya, akaanaka ya tina. Kwasa mwiy tikuw, God dikidi ap wunak, duw taakw dayadi Mwamik, takakida. Duw taakw wunadiy kwurkituwadiy jaav lakwukuw, day ata Godak nimadib wayapiy sikidanaad. ");
INSERT INTO mle_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","“Atawa mwugiytuwik, duw taakw Godak gaba maaj sukwudaak, yaakiya God ata wunaam, duw taakw dayadi Mwamim kawarkidadiwun apawa dikiwa nakamwiyib tituwkikik. Di a yawiy aka yabiyib kwurkida. ");
INSERT INTO mle_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Wunadiy mawul yituwadiy nyanugw, wun gwurawa mwiya simiy kwu maa. Gwur wunak kwaki-kinadiygwurik. Aw gwurak aka kita watuwadiygwurik aal tayir nuwukadiy Juw duw takwak watuwil majib: gwur rav maa ki wun yikituwa tamiyaar yiyak. ");
INSERT INTO mle_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Kita gwurak mwiya kwula walakwu maajal watuwa. KI gwurak wun mawul yikwatuwa pik, atampik gwurabab gwur gwurak awarwa awarwa mawul ay nakamwiyib. ");
INSERT INTO mle_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","“Aw li gwur atawa awarwa awarwa mawul yikigwura, aw ata adiy gwuraam vikinadiy nuwukadiy duw taakw ata yabiyib lakwu-kidanadiygwurik gwur wunadiy kalivatuwadiy duw-adiygwurik.” ");
INSERT INTO mle_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sayman Pita ata bas sidid, “Yitaypika Duw, aka maka tipaar yikinadimin?” Aw Jisas dikik ata wadid, “Kita min samab wuna kwukib ya maa. Aw ginyir aal yikinadimin wun kwakituwa tamiyaar.” ");
INSERT INTO mle_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Aw Pita ata Jisasak wadid, “Yitaypika Duw, agwa javik tikuw, wun kita minawa yi maarkidiwun? Wun minak kiyaribak aal tinadiwun.” ");
INSERT INTO mle_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aw Jisas dikik ata wadid, “Ki mwiyab min wuna danik kiyaribak tinadimin, ay? Aw minak mwiya mwiyab watuwadimin, sir ganbab taay tapwuk wu maardik, min jaab mugwul wakinadimin, ‘Wun dim maa laakw,’ waan.” ");
INSERT INTO mle_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Aw Jisas dikidiy kalivadidiy duwak ata wadidiy, “Gwur aya samasam mawul wukitikwa. Gwur kip Godak wukijibir tikuw, wunak ab wukijibir ada. ");
INSERT INTO mle_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","“Wunadi Asaay wiyaam kwakwa tamiy samasam-adiy. Aw li adiy God dikidiy nyanugw day kwakwa tamiy rav maarik-la, aal bwunak wakik-tuwadiygwurik. Aw kita wun aka warkuw, gwurak tamiy kwulapwu-kinadiwun. ");
INSERT INTO mle_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","“Aal tamiy kwulapwu-kwusin napakituwa gwurak, yaakiya, ata sibinin dakinadiwun gwuraam kawarik wunawa nakamwiyib kwagwurkikik aal kwakituwa tamiyaam. ");
INSERT INTO mle_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","“Aw gwur bwu lakwugwura aal yikituwa tamiy, aw gwur bwutaay lakwugwuraad adi tamiyaar yiyi yaab.” ");
INSERT INTO mle_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aw Jisas atawa waan napadik, Tomas ata bas sidid Jisasak, “Nyan samab maa laakw min yikimina tamiy, alik aw nyan ata ata lakwu-kinadiyan arir yikibanadi yaab?” ");
INSERT INTO mle_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aw Jisas dikik ata wadid, “Wun wun-adiwun, yaab adawur tipaar warwarik. Aw wun mwiya maaw adiy mwiyir mwiyirda tikwanadiy jaav. Awarab wun wunadiwun duw takwaam mwugiytuwik Godawa yarakara kwayakidiy. Alik tikuw, aw duw taakw wunak ya maarkidiy, day Godak warwar rav maa. Nikidi yaab maa ti. ");
INSERT INTO mle_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","“Aw li gwur wunaam lakwuk-gwura, aal wunadi Asayim ab lakwuk-gwuraad. Ki nyab karayrib gwur lakwu-kigwuraad, dim vikirakiykuw.” ");
INSERT INTO mle_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Aw Pilip dikik ata wadid, “Yitaypika Duw, nyanak asimak minadi Asayim. Nyan dikim vikir. Aw nyan dim vikibana, nyan ginyir ginyir minak samab niki jaav niki javik bas si maa.” ");
INSERT INTO mle_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Aw Jisas dikik ata wadid, “Wun gwurawa mwiya nimadi simiyad tituwid. Aw min, Pilip, samab maa laakw wunaam? Duw taakw wuna mil mwutaam vidana pik atampik wunadi Asayim ab wunaam vinapik vidanaad. Aw agwa javik tikuw, bas sinadimin, ‘Nyanak minadi Asaay asimak,’ waan? ");
INSERT INTO mle_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","“Aw Pilip, min mwiyir wukijibir tinadimin wuna majik aal watuwalik minak kitawa, ‘Wunawa Asaay an nakamwiyib tikwanabiran,’ waan? Aal watuwil maaj aal wun wuna kapa maaj maa. Aal wun wunadi Asayib daal. Di wunaam rawun kwakwanaad. Di wuna mawulaam sisuwdikib kwurkwatuwadiy adiy yawiy. ");
INSERT INTO mle_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Kip wunak wukijibir ada kitawa watuwik gwurak, ‘Wunawa wunadi Asaay an nakamwiyib tikwanabiran.’ Aw li gwur wuna majib wukijibir ti maarkuw ab, adiy vigwurkikib kwurkwatuwadiy nimadiy yawiyik tikuw wunak wukijibir ada. ");
INSERT INTO mle_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Wun gwurak mwiya mwiyab watuwadiygwur, adiy wunak wukijibir tikidiy duw taakw, day kidiy wun kwurkwatuwadiy yawiy pika yawiyadiy kwurkidanadiy. Aw wun Asayik warkituwalik, aw God dikidi Mawul dayak wayakikituwaad dayak sugwiyaan kwurdikik. Alik aw day adiy wun kwurkwatuwadiy nimadiy yawiyim ab day kakilkuw, mwiya yitaypika nimadiy yawiyadiy kwurkidanadiy. ");
INSERT INTO mle_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","“Alik tikuw, Godak bas as gwuraam sugwiyaan kwurtuwkik. Adiy wun gwurak kwurtuwkik bas sikigwuradiy jaav, adiy kwurkituwadiy gwurak. Aw wun atawa kwurkituwa, aw mwiyir duw taakw mawulaam sisuwtuwik, Godak wayapiy sikidanaad. ");
INSERT INTO mle_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","“Alik tikuw, gwur Godak bas sikuw niki jaav niki javik, aw li gwur wunak wukijibir tikuw, a jaav kwurkituwa gwurak.” ");
INSERT INTO mle_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Aw Jisas ata maa dikidiy kalivadidiy duwak wadidiy, “Aw li gwur mwiyir wunak mawul yikigwura, aal kidiy gwurak kwurgwurkik watuwadiy javib lakwu-lakwub tikidiygwur. ");
INSERT INTO mle_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","“Wunab atawa lakwu-lakwub tikigwura, wun Asayik bas sikituwaad aw dikidi Mawul gwurak kwiykidaad, aw mwiyir gwurak nyanyi nyanyi sugwiyaan kwurdikik. ");
INSERT INTO mle_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","“God dikidi Mawul mwugiydik, gwur ata adiy mwiyir tikwanadiy jaav lakwu-kigwuradiy. Adiy kipa duw taakw Godaam laakw maardalik tikuw, aw diki mil mwutaam vi maardalik tikuw, alik day dikik maa rav mayaakw kwakwak. Aw di nyanyi gwuradiy mawulaam rawun kwadalik tikuw, aw gwur alik lakwu-kwagwuraad. ");
INSERT INTO mle_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Aw wun kap kwagwurkikik gwuraam wap maa. Wun sibinin maa yakinadiwun gwurak. ");
INSERT INTO mle_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Kipa kwasaala, adiy wunak wukijibir ti maarkwanadiy duw taakw day wunaam samab vi maarkidana. Aw gwur aal vikigwuradiwun. Aw wun Godawa nyanyi nyanyi kwayatuwalik tikuw, alik wun mwugiy-kituwadiygwurik gwurabab nyanyi nyanyi Godawa kwaya-gwurkik. ");
INSERT INTO mle_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","“A nyaam ata lakwukigwura Asaywa wun an nakamwiyib tikwanabiran. Awarab gwurawa wun nyan nakamwiyib tikwanadiyan. Wun gwuraam rawun tinadiwun aw gwur wunaam rawun tinadiygwur. ");
INSERT INTO mle_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Adiy wunak mawul yikwanadiy duw taakw, day adiy wun wakwatuwadiy majib wukitaay, lakwu-lakwub tikwanadiy. Wunadi Asaay adiy wunak mawul yikwanadiy duw takwak mawul yikwanaad. Aw wun wun ab dayak mawul yikuw, dayadiy mawulaam rawun kwataay, mwugiytuwik day wunaam lakwu-kidanadiwun.” ");
INSERT INTO mle_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Juwtas, aad nikidi Juwtasad, adi Jisas dikidiy mama nib tabaam takadi Juwtas Yiskariyat maa. Di ata Jisasak bas sidid, “Yitaypika Duw, ata ata nyana danik mwugiymin nyan lakwu-kibanadimin, aw adiy kipa duw taakw day ata ata minaam laakw maarkidanadimin?” ");
INSERT INTO mle_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas dikik ata wadid, “Adiy wunak mawul yikidiy duw taakw day wuki-wukib tikidiy wuna majib. Aw adiy duw takwak wunadi Asaay mawul yikidadiy. Aw an nakamwiyib dayak yikuw, dayab rawun kwakinabiran. ");
INSERT INTO mle_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","“Aw adiy duw taakw wunak mawul yi maarkwanadiy, day akis wuna majib lakwu-lakwub tikwanadiy. Gwur alaakw ki gwurak watuwa maaj, aal wunaki maaj maa. Aal adi wunaam wayakidi Asaay dikib dana maajal. ");
INSERT INTO mle_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Kidiy maaj watuwadiy kip gwurawa tituwa sikir. ");
INSERT INTO mle_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","“Asaay dikidi Mawul wayakikidaad gwuraam sugwiyaan kwurdikik. Di wuna tamiy kwurkuw, di miyawa jaav kaliva-kidadiygwur. Kalivakuw, gwuradiy mawulaam sisuwkidadiygwur adiy gwurak watuwadiy miyawa javib wukin kariyagwurkik. ");
INSERT INTO mle_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Aw wun gwuraam wapakuw, ata gwuradiy mawulaam mwugiy-kituwadiy kwusida-takaan tidakikik. Atampika mawul, aal wun wuna kwiykituwa mawula gwurak. Adiy Godaam laakw maarkwanadiy duw taakw, day atampika mawul ti maa. Mawul samasam wukiway. Awarab yagaway. ");
INSERT INTO mle_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Kip ki gwurak watuwa majib wukijibir adakw. Wun aka gwuraam wapakituwadiygwur. Wapakuw, aw wun sibinin maa yakinadiwun gwurak. Aw li gwur mwiya mwiyab wunak mawul yikigwura, aal gwur kip rakarak tikinadiygwur aw wun wunadi Asayik yikituwalik. Aw di wunaam mwiya yitaypik tinaad. Aw wun gwuraam wapakuw, God di diki ap gwurak kwatiyakida. ");
INSERT INTO mle_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Wun gwurak yabiyib ti maardaak kidiy maaj watuwadiygwur, aw ginyir mwiyir tidaak, ata gwur wunak wukijibir tikigwuradiwun. ");
INSERT INTO mle_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Nyi simiy maa ti gwurak nuwukadiy maaj wawak. Satan, adiy Godaam laakw maarin tinadiy duw takwaam van tikwanadi duw, adi wunaam wunadiy mama nib tabaam takakinadi duw diki mawulaam rawkuw, ada yabiyib yakinaad. Aw Satan yanaad wunaam kakilik. Aw di ap maa ti, wunaam kakil-kakilik. ");
INSERT INTO mle_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","“Aw wun miyawa jaav kwurkwatuwadiy adiy wunadi Asaay kwurtuwkik wadidiy yawiy aw mwiyir adiy Godaam laakw maarin tidiy duw taakw lakwudakik wun Asayik mwiyir mawul yikwatuwaad. May ya! Ki tamiy wapanaak.” ");
INSERT INTO mle_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Wun adi mwiya mwiyaba girap bajigay kaytik-adiwun. Aw wunadi Asaay di maay asaay duw kaytik-ad. ");
INSERT INTO mle_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","“Adiy wunaam mwiya mwiy kwar maarkwanadiy ba bajigay di kitikitaay, yakiyaki-kwadadiy. Aw adiy mwiy kwurkwanadiy ba bajigayda di yarakara kwulapwu-kwadadiy aw mwiyir day viyakita mwiy kwurkuw, mwiy samasam ridakikik. ");
INSERT INTO mle_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Atampik wunaki maaj bwu sugwiyaan kwurlidiygwurik mwiya viyakita mwiy tigwurkikik. ");
INSERT INTO mle_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","“Gwur mwiya mwiyab wunawa duw nak kaytik ada. Aw wunabab mwiya mwiyab gwurawa duw nak kaytik tikinadiwun. Ba bajigay di dikida kap akis mwiy kwurkwanaad. Aw mwiy kwurkwanaad, adi bajigay dikidi mwiya mawum tikuw. Atampik, aw li gwur wunawa nakamwiyib ti maarkigwura, gwur samab God diki mawula pik viyakita yawiy kwar maa adiy mwiy samasam kwur-kwanadiy ba bajigay kitik tikuw. ");
INSERT INTO mle_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Wun adi girap bajigay kaytik-adiwun. Aw gwur adiy dikidiy ba bajigay kaytik-adiygwurik. Aw li gwur wunawa nakamwiyib tigwurik, aw wun gwurawa nakamwiyib tituwik, aw gwur God diki mawul walil pik kwur-kigwuradiy. Wun gwurawa ti maarkituwa, gwur samab God diki mawul walil pik kwar maa. ");
INSERT INTO mle_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","“Adi maay asaay duw di adiy mwiy kwar maarkwanadiy ba bajigay sakwun napataay, di kawaar yakisakwu-kwadadiy. Aw yin rik yidaak, ata vagaluwtaka-kwadadiy. Vagaluwtakataay, ata yiy wapataka-kwadadiy yandakik. Atampik God kwurkidadiy adiy wunawa nakamwiyib ti maarkinadiyim. ");
INSERT INTO mle_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Aw li gwur mwiya mwiyab wunawa nakamwiyib tigwur, aw ki wunaki maaj gwuradiy mawulaam kwalik, ata Godak bas as adiy kwurik mawul wuki-kibwuradiy niki jaav niki javik. Aw di adiy dikik bas sikigwuradiy jaav kwiykidadiy gwurak. ");
INSERT INTO mle_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","“Aw li gwur wunadiy kalivatuwadiy duw-adiygwurik, gwur God diki mawul walil pik kwur-kinadiygwurik. Alik tikuw, yawiy duw takwaam mwugiy-kiladiy wunadi Asayik wayapiy sidakikik. ");
INSERT INTO mle_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Wun mwiya mawul yituwadiygwurik wunadi Asaay wunak mawul yikwada pik. Bwan samab kwiywayik wunaki gwurak mawul samasam yikwana mawulak. ");
INSERT INTO mle_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","“Aw li gwur wunaki majib wuki-wukib tikigwura, aal gwur samab bwan kway maa wunaki gwurak mawul samasam yikwana mawulak. Wun wunadi Asaay majib wuki-wukib titaay, diki mawul yiyi tikwana mawulab rawun kwakwanadiwun. Aw wun akis dikik bwan kwiy-kwanadiwun. Alik gwurabab atawa ada. ");
INSERT INTO mle_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Aw wun watuwadiygwurik kidiy jaav aw mwiyir ki wun kwiytuwa rakarak tikwana mawul gwuradiy mawulaam rawun kwalikikik, aw gwur mwiya mwiyab rakarak tigwurkikik. ");
INSERT INTO mle_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Ki gwurak walakwutuwa maaj aal awarwa awarwa mawul yigwurkikik. Gwurak mawul yikwatuwa pik, atampik gwurabab yigwurkikik watuwadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","“Aw li duw nak rakarak tikida kiyak ab dikidiy kapa nyanugwa danik tikuw, diki dayak yikida mawul miyawa nuwukadiy duw takwak yikwadanadiy mawulaam yitaypik tikina. ");
INSERT INTO mle_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Aw li gwur, kidiy wun watuwadiy majib wuki-wukib tikigwura, gwur wunadiy kapa nyanugw-adiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Wun gwurak kipa yawiy duw sikiy maa ya. Kipa yawiy duw day akis lakwu-kwadanadiy adiy dayadiy yitaypika duw kwur-kwadanadiy yawiy. Aw li wun gwurak wunadiy kapa nyanugw sikiy-kwatuwadiygwurik, gwur wunadiy kapa nyanugw-adiygwurik, aw wun miyawa wunadi Asaay simaka-didiwun jaav gwurak wasapwiy-yakituwalik tikuw. ");
INSERT INTO mle_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Aw gwur wunaam maa tasaakw gwuradi yitaypika duw tituwkikik. Awar wun wuna tasakwu-tuwadiygwurik wunadiy kapa nyanugw tigwurkikik. Wun bwutaay tasakwu-tuwadiygwurik adiy God mawul yikidadiy viyakita yawiyda kwurgwurkik. Aw adiy kwurkigwuradiy yawiy dayadiy mwiy nyanyi kip kwaya-kidiy. Kwas maa. Atawa kwur-kigwuralik tikuw, alik adiy wunadi saam sikiyin wunadi Asayik bas sikigwuradiy jaav di kwiy-kidadiy gwurak. ");
INSERT INTO mle_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“Kip ki gwurak kwiytuwa majib wukijibir tikuw awarwa awarwa mawul ay. Samab mawul wukimar-wayik a javik. Kip likib kaykitijibir ada.” ");
INSERT INTO mle_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Adiy God dikidi gwalugwum ti maarkinadiy duw taakw day gwurak mama nib tikinadiy. Aw gwur bwu lakwugwura day tayir wunak ab atawa tidiy. ");
INSERT INTO mle_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","“Aw li gwur daya pik tikik-gwura, aal yaak, wakik-danadiygwurik, ‘Nyanadiy kapa nyanugw,’ waan. Aw li kita wun bwutaay tasakwu-tuwadiygwurik dayadiy nyidim, alik gwur kita dayadiy kapa wiy maa. Alik tikuw, day gwuraam maam yikidanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Lakwugwura aal gwurak watuwil maaj. Wun wadiwun gwurak, ‘Adi kipa yawiy duw akis yitaypik tikwanaad dikidi yitaypika duwaam.’ Alik tikuw, aw li day wunaam jawjaay kwurkidana, gwuraam ab jawjaay kwur-kidanadiygwurik. Aw li day wuna majib wuki-wukib tikidana, gwuradiy majik ab wuki-wukib tikinadiy. ");
INSERT INTO mle_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","“Adiy duw taakw day adi wunaam kidi kupwaar wayakidi Asayim day maa laakw. Alik tikuw, atawa kwur-kidanadiygwurik aw wunadiy tikigwuralik tikuw. ");
INSERT INTO mle_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Aw li wun dakuw, dayak kalivakuw, simak maarik-tuwa, ‘Wun God dikidi Tasakwudidi Duw-adiwun,’ waan, aal yaak, aal wakik-nadiy, ‘Nyan maa laakw ki jaav,’ waan. Aw kita day samab atawa bwula-bwul maa rav, wun atawa watuwalik tikuw. Alik daya yidaal vaal kip dayawa rina. ");
INSERT INTO mle_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","“Adiy duw taakw wunaam dayadi mama nib tituwkikik tasakwu-kinadiy, wunadi Asayim ab tasakwu-danaala dayadi mama nib tidikikik. ");
INSERT INTO mle_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","“Aw li wun nimadiy yawiy kwar maarik-tuwa dayadiy nyidim, adiy talab talab duw kwurya maardadiy yawiy, aal yaak, day wakik-dana, ‘Nyan maa laakw ad sikadi duwad,’ waan. Aw day bwutaay vidadiy adiy kwurtuwdiy nimadiy yawiy. Aw day atawa kwurkuw, day mama nib-adiy wunawa wunadi Asayik. ");
INSERT INTO mle_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“God di diki lo lapa nyigaam tayib day sukwadaal ki maaj. ‘Day wunak kipakip yaal giradadiwun.’ Alik tikuw, aw a maaj aka kita mwiya mwiyab tina ya. ");
INSERT INTO mle_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Aad wunadi Asaywa tikwanadi Mawul wun kwiykituwaad gwurak. Di aad mwiya adiy mwiyir mwiyirda tikwanadiy jaav dayakid maaw-ad. Di sugwiyaan kwurkidadiygwurik aal diki yawiyal. Di wunadi Asaywa kwakuw, wun wayaki-kituwaad gwurak, gwurak di wunak yarik yidikikik. ");
INSERT INTO mle_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","“Bas kidi kupwaam God diki yawiy kwurtuwik, wunawa nakamwiyib tidiygwur. Alik tikuw, gwurabab duw takwak yitaay, gwur dayak wunak yarik ay.” ");
INSERT INTO mle_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Kidiy jaav kidiyka kitaan ab gwurak wajibira-tuwadiy aw ginyir gwur wunaam bwan kwiyik-gwuradiwun wakuw. ");
INSERT INTO mle_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","“Ginyir gwuraam day watipi-kidanadiygwurik dayadiy gaba maja wiyak. Nyi yakina gwuraam viyasipataay, wakidana ‘Nyan viyakita yawiy Godak kwurnadiyan,’ waan. ");
INSERT INTO mle_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","“Aw day adiy jaav gwuraam kwur-kidanadiygwurik. Aw day maa laakw wunawa wunadi Asayim samab laakw maardalik, alik atawa kwur-kidanadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","“Aw wun kidiy maaj wajibira-tuwadiygwur, aw aal gwuraam kidiy jaav kwurkidana nyi yalik, aw wukin kariya-gwurkik kidiy gwurak watuwadiy majik. Tayir wun gwurawa kwatuwilik tikuw, alik wun kidiy jaav gwurak maa yarik yi. Aw kidiy yarik yituwadiy jaav gwurak yakidana nyi wun gwurawa kwu maa. Alik watuwadiygwur kidiy jaav.” ");
INSERT INTO mle_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Aw wun aka adi wunaam kidi kupwaar wayakidi Asayik sibin-kinadiwun. Aw gwur duw nakab maa wunak bas si, ‘Min akarir yikinadimin,’ waan. ");
INSERT INTO mle_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","“Aw kitawa gwurak watuwalik tikuw wun aka wapa-kituwadiygwurik wunadi Asayik yikir. Alik tikuw, gwuradiy mawul adiyka wukinadiy samasam. ");
INSERT INTO mle_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Aw mwiya mwiyab watuwadiygwurik, aw li wun gwuraam wapakuw yikituwa, aal gwurak viyakit tikina. Aw li wun gwuraam wapakuw, yi maarkituwa, aal God dikidi Mawul di gwuraam yaan sugwiyaan kwar maa. Aw li wun yikituwa aal gwurak ata wayaki-kituwaad. ");
INSERT INTO mle_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Aw adi God dikidi Mawul dakida, di yarakara simaka-kidadiy adiy Godaam laakw maarnadiy duw taakw dayadiy vaal. Di simaka-kidadiy viyakita mwiy yarakara tidakikik God diki milaam. Di simaka-kidadiy God jawjaay kwurkidadiy adiy diki milaam viyakit ti maarkwanadiy duw takwaam. ");
INSERT INTO mle_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","“Aw day wunak wukijibir ti maarkwadanalik, alik day mwiyir maa laakw vaal liki mwiya maaw. ");
INSERT INTO mle_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","“Aw wun wunadi Asayik yikituwalik tikuw, alik gwur ginyir wuna mil vi maa. Aw God dikidi Mawul ata simaka-kidadiy duw taakw mwiyir God diki milaam yarakara kwakwa sukw. ");
INSERT INTO mle_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","“Aw God bwutaay adiy dikim laakw maarkwanadiy duw takwaam van tikwanadi duw Satanaam tasakwudid nyanyi nyanyi kupwarapa tamiyaam kwayadikik. Awarab God atawa rivriv jawjaay kwurkidadiy adiy Satan dikidiy tikinadiy duw takwaam ab. ");
INSERT INTO mle_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Gwurak wakir wukituwadiy maaj mwiya kipa jaav-adiy. Aw gwur gwurak watuwadiy majik samasam wukigwuralik tikuw, alik gwur mwiyir rav maa dayaam yarakara lakwu-lakwuk. ");
INSERT INTO mle_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","“Aw adi God dikidi Mawul, adi miyawa mwiyir mwiyirda tikwanadiy jaav dayadi mwiya maaw, gwurak yakinaad. Di sugwiyaan kwur-kidadiygwurik adiy mwiyir mwiyirda tikwanadiy jaav miyawa lakwuyaki-gwurkik. Di gwurak di diki kapa wuki-kidadiy jaav wu maa. Di adiy God wadidiy javida wakidadiygwurik. Di yarik yikidadiygwurik adiy ginyir yakinadiy javik ab. ");
INSERT INTO mle_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","“Aw di wakidadiygwurik adiy dikik wakituwadiy javib javib. Aw di gwuradiy mawulaam sisuw-kidadiygwurik wunak gaba maaj sakwu-gwurkik. ");
INSERT INTO mle_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","“Adiy miyawa wunadi Asaay dikidiy tinadiy jaav adiy wunadiy-adiy. Alik a javik tikuw, wun gwurak bwu watuwadiygwurik God dikidi Mawul adiy dikik kwiy-kituwadiy jaav gwurak yarik yikidadiy.” ");
INSERT INTO mle_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jisas dikidiy kalivadidiy duwak ata wadidiy, “Kipa kwasa mwiya wunaam vi maarkigwura. Aw kwasa mwiy tikuw, wun yatuwik, ata maa vikigwuradiwun.” ");
INSERT INTO mle_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Aw nuwukadiy dikidiy kalivadidiy duw nuwukadiyik ata wadadiy, “Ki wada maaj liki maaw ata ataanal di nyanak wadaal, ‘Kipa kwasaala vi maarkigwura wunaam, aw kwasa mwiy tikuw, ata maa vikigwuradiwun,’ waan? Kitawaan ab wanaad, ‘Aw wun wunadi Asayik yikituwalik tikuw, kipa kwasa mwiy tikuw,’ waan. Wada maaj liki maaw maaj ata ataanal?” Day awarwa awarwa titaay bas sidiy, “Nyan samab maa laakw ki bwulada maaj liki maaw maaj.” ");
INSERT INTO mle_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Aw Jisas di bwu lakwudil dikik bas sikir tidaal. Alik tikuw, ata wadidiy, “Wun watuwa kipa kwasa mwiya wunaam vi maarkigwura, aw ginyir kipa kwasa mwiy tikuw, ata maa vikigwuradiwun. Akaanaka a majik bas sigwura awarwa awarwa titaay? ");
INSERT INTO mle_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","“Wun gwurak mwiya mwiyab watuwadiygwurik, bas gwur gwuradiy mawul vaat yikuw, gira-kwanadiygwurik kiyatuwik. Aw a nyaam adiy Godaam laakw maarkwanadiy duw taakw day mwiya rakarak samasam tikinadiy. Aw ginyir God wunaam kirasitakadik, gwur maa ata gwuradiy mawul warapiykuw, maa ata mwiya mwiyab rakarak tikinadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Aw taakw liki yalaam nyan yip viyadik, li samasam wukikwana aal liki kagil kwurkila nyi walibab tilalik. Aw adi nyan maak kwadik, li a kagilik wukimarkuw, li adi nyinik ata rakarak mwiya samasam tikwana. ");
INSERT INTO mle_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","“Atawa tikinadiygwurik. Gwurabab kita gwuradiy mawul adiyka vaat yan tinadiy. Aw ginyir gwurak maak yaan takatuwik, gwur ata maa rakarak samasam tikinadiygwurik. Atawa tigwur, duw nakab adiy gwuradiy rakarak tikigwuradiy mawulaam rav maa mwugiy-mwugiyik kwusidakik. ");
INSERT INTO mle_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Aal nyi yakila, gwur wunak bas si maa ya jaav nak mwiyak ab. Wun mwiya mwiyab watuwadiygwurik, aw a nyaam aw gwur wunak wukijibir tikigwuralik, dikik wunadi saam bas sikigwuradiy jaav wunadi Asaay di kwiy-kidadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","“Tayir ab aw yaan kita gwur wunadi saam wunadi Asayik akis bas sikwagwuraad jaav nikik ab gwurak kwiydikik. Aw wunak wukijibir tigwuralik tikuw, bas as dikik. Aw di ata kwiy-kidadiygwurik aal dikik bas sikigwura jaav, aw gwur mwiyir rakarak tigwurkikik, a jaav kwurkuw.” ");
INSERT INTO mle_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Wun adiy majik gwurak pakwun tinadiy majir wayatuwdiygwurik. Aw ginyir gwurak yarik yikituwa wunadi Asayik mwiyir lakwu-kigwuradiy majir. Kipa pakwun tinadiy majir wu maa ya. ");
INSERT INTO mle_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","“Aw a nyaam gwur wunak wukijibir tikigwuralik tikuw, gwur gwura kap Godak bas sikigwuraad gwur gwuradiy kapa sipak. Aw aal yawiy gwurak wun kwar maa ya, talab gwurak kwuryatuwil pik. ");
INSERT INTO mle_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","“Aw gwur wunak mawul yitaay, wukijibir tikwagwuralik God kidi kupwaar wayaki-didiwun wataay, aw alik Asaay di diki mawul gwurak samasam yikwanaad. Alik tikuw, di adiy dikik bas sikigwuradiy mwiyir kwiy-kidadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","“Ayiy, wun mwiya mwiyab kidi kupwaar wun wunadi Asayib tikuw, dadiwun. Aw wun kidi kupw wapakuw, aka maa sibin-kidiwun wunadi Asayik.” ");
INSERT INTO mle_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","30","Aw Jisas ki maaj waan napadik, dikidiy kalivadidiy duw dikik ata wadaad, “Min kita pakwun tinadiy majir maa ya bwul. Alik tikuw, wadiy bwula-minadiy maaj adiyka ya vikirakiy-banadiy. Kita nyan aka lakwubana min miyawa jaav lakwuyaki-minadiy. Aw min miyawa jaav lakwuyaki-minalik tikuw, alik duw taakw dayadiy mawulaam rikwanadiy maaj day minak adiy jaav bas si maardakib nibway, aw min adiy jaav bwu lakwu-minadiy. Aw kidiy miyawa javik tikuw, nyan aka wukijibir tibana min Godab tikuw, dadimin waan.” ");
INSERT INTO mle_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Aw Jisas dayak ata wadidiy, “Aw kita gwur mwiya mwiyab wunak wukijibir tinadiygwur, ay? ");
INSERT INTO mle_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“Gwur awuk! Nyi aka ya walibab tina gwur yagakuw, wunaam wapakuw, tabwu-kigwura kapakap kapakap gwur gwuradiy tipaar tipaar. Viyamaygwur, wun kap tikinadiwun. Aw wun mwiya mwiyab kap ti maa, aw wunadi Asaay di wunawa tikwanaad. ");
INSERT INTO mle_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Wun bwutaay watuwadiygwurik kidiy maaj, aw gwur wunawa nakamwiyib tikuw aw gwuradiy mawul kip kwusida-takaan tidakikik. Adiy Godak wukijibir ti maardiy duw taakw gwuraam jawjaay kwur-kidanadiygwurik. Aw gwuradiy mawul kip apawa tikwadiy. Titaay, rakarak ada, aw wun bwutaay kakil-tuwadiy miyawa Satan kidi kupwaam kwurin tidadiy dikidiy ap.” ");
INSERT INTO mle_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas ki maaj wakwusin napakuw, di ata kituw adawur tipaar vikuw, Godak ata wadid, “Asaay, yaakiya, nyi aka bwu tina. Min duw takwak wunaki ap simakakuw, awarab minadi ap simaka-kituwaad. ");
INSERT INTO mle_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","“Min bwu tasakwumindiwun miyaw tuw takwaam van tituwkikik, aw wun mwiyir adiy wunadiy tikinadiy duw takwaam mwugiytuwik viyakita mwiy nyanyi nyanyi minawa kwayadakik. ");
INSERT INTO mle_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","“Aw akaanaka mwiya maaw duw taakw viyakita mwiy minawa nyanyi nyanyi kwayakidana: Day lakwukwadiy minaam minadimin mwiya mwiyaba God. Aw wunaam ab lakwukwadiy aw min mina wunaam kidi kupwaar wayakimindiwun. ");
INSERT INTO mle_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Wunaam kidi kupwaar wayakiminik, aw wun duw takwaam mwugiytuwdiy minadi sak wayapiy sidakikik. Aw kita adiy kwurtuwkik kwiyminidiy yawiy adiyka bwutaay kwurkwusituwadiy. ");
INSERT INTO mle_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","“Wunadi Asaay, kita amwugiy mwiy yitaypik tituwkikik minawa aw tayir kidi kupw yitakaminik titil pik.” ");
INSERT INTO mle_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kidiy wunak kwiyminidiy duw taakw adiy minaam laakw maardiy duw takwawa tidaak, wun bwu mwugiytuwdiy minaam lakwudakik. Day minadiy tidalkil, aw min mwugiymindiy wuna kwukib yidakikik. Aw day mina majib lakwu-lakwub tikwanadiy. ");
INSERT INTO mle_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","“Kita aka lakwudana adiy wunadiy ap adiy min minab yadiy-adiy. ");
INSERT INTO mle_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","“Aw wun kwiytuwdiy aal wunak kwiyminil maaj aw day bwu kwurdana. Day bwu lakwudana aal mwiya mwiyaba wun minab tikuw, dadiwun. Aw day wukijibir tikwanadiy, ‘God di diki Jisasaam kidi kupwaar wayakidid,’ wataay. ");
INSERT INTO mle_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Alik wun daya danik tikuw, minak bas situwadimin aw wun minak adiy minaam laakw maarnadiy duw takwak tikuw maa bas si. Aw wun minak kidiy min mina wunak kwatiya-minidiy duwa danik tikuw, bas situwadimin. Aw day minadiy-adiy. ");
INSERT INTO mle_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","“Adiy wunak yakinadiy miyawa duw taakw minadiy-adiy. Aw day nuwukadiy duw takwaam mwugiydakib, wunak gaba maaj sukwukinadiy. ");
INSERT INTO mle_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Mwiya mwiyab wun kidi kupw ada wapakuw, minak sibin-kinadiwun. Aw kidiy wunak wukijibir tinadiy duw taakw day kip kidi kupwab kwakinadiy. Alik dayaam galab akwur minakil aal wunak kwiyminil apaar, aw kidi kupwa vaal ata dayaam kakilik-ladiy. Atawa kwurmin, aw day mwiya mwiyab mawul nak kwakwadiy an kwata pik. ");
INSERT INTO mle_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“Aw wun dayawa tiytiyatuwdiy sikir wun yarakara galab kwurtuwdiy, aal wunak kwiyminil apaar. Wun yarakara galab kwurtuwalik, alik daya duw nakab maa wunak bwan kway. Aw adi min mina lapa nyig waladi duwada wunak bwan kwiyid. Aw di diki kap tasakwudil jawjaay tidikikik aw aal mina lapa nyigaam rina maaj mwiya mwiyab tilikikik. ");
INSERT INTO mle_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Wun kidi kupwaam tikuw, kita watuwadiy kidiy maaj aw ki dayak kwiytuwa rakarak tikwana mawul kip dayadiy mawulab rawun kwayalikik. Aw aka wun yakinadiwun minak. ");
INSERT INTO mle_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Wun bwutaay kwiytuwdiy minaki maaj aw day aal maaj kwurkuw, day wuna pik kapab tinadiy adiy minaam laakw maarnadiy duw takwak. Aw adiy minaam laakw maarnadiy duw taakw dayaam bwu tasakwudanadiy dayadiy mama nib tidakikik. ");
INSERT INTO mle_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Asaay, wun minak maa bas si adiy minaam lakw adiy minaam laakw maarnadiy duw taakw daya nyidim dayaam nyigil-minkik, aw minak wun bas situwa dayaam yarakara galab kwurminkik, ata dayaam Satan kakilik-dadiy wakuw. ");
INSERT INTO mle_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","“Aw wun adiy minaam laakw maarnadiy duw taakw dayakid maa. Atampik wunak wukijibir ti duw taakw ab dayak tinadiy. ");
INSERT INTO mle_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","“Dayadiy mawulaam sisuwminik minaki majir, aw day minadi gikim mwiyir tikwadiy. Minaki maaj adiy mwiyir mwiyirda tikwanadiy jaav dayakil mwiya maawa. ");
INSERT INTO mle_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","“Tayir min wayaki-minidiwun adiy minaam laakw maardiy duw takwak. Atampik wun adiykw wayakituwadiy adiy minaam laakw maarnadiy duw taakw dayadiy nyidir. ");
INSERT INTO mle_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","“Daya danik tikuw, wunaki miyawa sip aka minak kwiytuwa aw mwiyir dayabab atawa minak dayadiy miyawa sip kwiydakik.” ");
INSERT INTO mle_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Wun minak dayada sugwiyaan kwurminkik maa wu, aw adiy ginyir wunak wukijibir tikinadiy duw takwaam ab sugwiyaan kwurminkik kidiy duw dayak yarik yidaak wunak. ");
INSERT INTO mle_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","“Asaay, dayadiy mawulaam sugwiyaan kwurminkik bas situwadimin mawul nak tidakikik, aw mwiya mwiyab anawa rawun tidakikik ki an nakamwiyib rawun tita pik. Aw day atawa mwiya mwiyab mawul nak tikidana, aw adiy minaam laakw maarkinadiy duw taakw dayaam vikuw, a javik day ata wukijibir tikinadiy min wunaam kidi kupwaar wayakiminidiwun, wakuw. ");
INSERT INTO mle_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Wun bwu kwiytuwdiy aal wunak tayir kwiyminil apab dayak aw day mwiyir mawul nak tidakikik an tita pik. ");
INSERT INTO mle_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","“Aw wun dayadiy mawulaam kwatuwik, aw min wuna mawulaam kwaminik, nyan abab ata mwiya mwiyab mawul nak tikidiyan. Aw mwiyir lakwu-kidanadiwun, adiy minaam laakw maarnadiy duw taakw, min wunaam wayakimindiwun kidi kupwaar. Awarab mwiyir lakwu-kidiy min mawul yikwanadimin adiy wunak wukijibir tikwanadiy duw takwak aal wunak mawul yikwamina pik. ");
INSERT INTO mle_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Asaay, min kidiy duw taakw wunak kwatiya-minidiy, alik wun mawul yituwadiy wunawa nakamwiyib aal kwakituwa tipab kwadakikik, aw mwiyir vidakikik aal wunaki nima ap. Ki ap a wunak kwatiyaminil, aw min wunak mawul yikuw aal bas kidi kupw yitak maarminil sikir. ");
INSERT INTO mle_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Asaay, min miyawa mwiya viyakit-adimin. Aw mwiya samasama kmidi kupwa kidiy duw taakw minaam samab maa laakw. Aw wun bwutaay lakwutuwadimin. Aw adiy wunak wukijibir tikwanadiy duw taakw day bwu lakwudana min kidi kupwaar wayakiminidiwun. ");
INSERT INTO mle_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","“Wun bwutaay mwugiytuwdiy minaam lakwudakik aw wun kip atawada kwurjibir tikituwadiy, aw minaki mawul yiyi tikwana mawul wunak aw mwiyir dayadiy mawulaam ab rawun kwalikikik. Aw wunabab dayadiy mawulaam rawun kwakidiwun.” ");
INSERT INTO mle_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas Godak bas san napakuw, di dikidiy kalivadidiy duwawa ata Kitiran bayib sarkuw, aw viyakita mawayawa miy wardaal tamiyaar yidiy. Aw Jisas dikidiy kalivadidiy duwawa ata wuladiy a tamiyaar. ");
INSERT INTO mle_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Talab nyanyi nyanyi Jisas yikwaad a tamiyaar dikidiy kalivadidiy duwawa nakamwiyib. Alik Juwtas, adi Jisasaam kwiykinaad dikidiy mama nib tabaar, di bwu lakwudil a tamiy. ");
INSERT INTO mle_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Alik tikuw, ata adiy yitaypika pris awa Parasiy adiy Roma kidiy vay sawdiy duwawa God dikidi wiya kidiy vay sawdiy duw wayakidaak, Juwtas dayaam kwurkuw, ata karaydidiy a Jisasawa dikidiy kalivadidiy duw kwadaal tamiyaar. Lam awa tuwaaywa wariya javiwa dayawa nakamwiyib kwurin karaydadiy. ");
INSERT INTO mle_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Aw Jisas di bwu lakwudil adiy dikik yakinadiy miyawa jaav. Alik tikuw, di dayadiy mwutamaar sarin wakwukuw, ata bas sididiy, “Sikadadaad kwaki-gwuraad?” ");
INSERT INTO mle_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Jisasak, adi Nasarit tipa kidik kwakinadiyan,” wakuw, ata wadaad. “Wun-adiwun, adi kwaki-gwuradi duw,” Jisas dayak ata wadidiy. Aw adi Juwtas, dikim dikidiy mama nib tabaam takadi duw, dibab alim tad dayawa rasin nakamwiyib. ");
INSERT INTO mle_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisas dayak, “Wun-adiwun,” waan wadik dayak, day ata kwukir kwukir sibinkuw, kupwaam vakirdiy. ");
INSERT INTO mle_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Aw Jisas ata maa bas sididiy, “Sikadadaad kwaki-gwuraad?” Aw dikik wadaad maa, “Jisasak, Nasarit tipa kidik kwaki-nadiyan.” ");
INSERT INTO mle_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisas dayak ata wadidiy, “Wun bwu watuwadiygwurik wun di-adiwun waan. Aw li gwur wunak kwaki-nadiygwurik wakuw, wadiy wunadiy kaliva-tuwadiy duw wapagwurik yikwadiy ata.” ");
INSERT INTO mle_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aw di atawa wadil aw aal kitawa wadil maaj mwiya mwiyab tilikikik! “Wun adiy wunak kwatiya-minidiy duw, wuna samab daya duw nakab maa takayak.” ");
INSERT INTO mle_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aw Sayman Pita di wariya bag kwasadi wurim vagadik kwaad. Aw di ata adi wariya bag jardid. Jarkuw, di adi Mwiya Yitaypika Pris dikidi yawiy duw diki agika mava waan kitikidil. Adi yawiy duw dikidi si Malkas-ad. ");
INSERT INTO mle_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aw Jisas Pitaak ata wadid, “Wadi bag sibinin atak kwada tamiyab. Min wukimina ki wunadi Asaay wunak kwurtuwkik tasakwudil kagil min sitipi-kimina wunak ya maarlikik, ay?” ");
INSERT INTO mle_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Adiy vay sawdiy bapa duw aw dayadi yitaypika duwawa adiy Juw dayadiy vay sawdiy duwawa yakuw, ata kalakwukuw, yaav jitakadaad Jisas dikibir tabaam. ");
INSERT INTO mle_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yaav jitakaan napakuw, day ata kwurkuw, taay Anasak karaydaad. Di Kayapas dikidi nakim-ad. Aw adi nabiy day Kayapas tasakwu-daad di Mwiya Yitaypika Pris tidikikik. ");
INSERT INTO mle_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tayir Kayapas Jisasak adiy Juw dayadiy yitaypika duwak wadidiy kitawa, “Aal viyakita duw nak kiyakida kidiy miyawa Yisrayil jaka tipa kidiy duw takwa danik tikuw.” ");
INSERT INTO mle_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pitawa wun an Jisas kwukib yibiran dikim kwurkuw karaydaak. Aw wunaam adi Mwiya Yitaypika Pris bwu lakwu-didiwun. Alik wun Jisasawa mwiyir wuladiwun adi dikidi wiyak tipidadi kabaka yariparib day Jisasaam kwurin kawuladaak. ");
INSERT INTO mle_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita di kip kawab tad adi yaripa wiyigawa. Alik wun wakwudiwun maa kawaar. Wakwukuw, aal adi wiyigak van til takwa nyinik ata bas situwil. Bas situwik, li ata “Jaaw akarawul,” walidiwun Pitaam kwurin kawula-tuwkik. ");
INSERT INTO mle_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aw aal takwa nyan Pitaak ata bas silid, “Min kidi duw dikidiy kalivadidiy duw nak min-adimin, ay?” Pita likik ata wadil, “Wun maa. Suwana.” ");
INSERT INTO mle_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Aw aal gaan nikir samasam tayil. Alik tikuw, adiy yawiy duwawa taakw adiy God dikidiy wiyak vay sawdiy duw yiy takakuw, mala yaam takasawulaan tidiy. Pita ab ata yakuw, dayawa nakamwiyib mala yaam takasawulaan tad diki sipak. ");
INSERT INTO mle_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Aw adi Mwiya Yitaypika Pris ata Jisasak bas sidid dikidiy kalivadidiy duwawa adiy duw takwak kaliva-kwadidiy javik. ");
INSERT INTO mle_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Aw Jisas dikik ata wadid, “Wun maaj pakwur pakwur akis bwula-kwanadiwun. Wun miyawa duw taakw mwutamaam titaay bwuladiwun. Juw dayadiy gaba maja wiyawa God dikidi wiyaam adiy miyawa Juw duw taakw vagaluwdakib, wun duw takwak pakwur pakwur akis niki jaav niki javik kaliva-kwatuwadiy. ");
INSERT INTO mle_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","“Aw agwa javik tikuw wunak bas siminadiwun. Adiy wun kalivatuwik wukidiy duw takwak bas as. Day lakwu-danadiy adiy dayak watuwdiy maaj.” ");
INSERT INTO mle_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Aw Jisas atawa wadik, adiy God dikidi wiyak vay sawdiy duw nak ata yala kaynarakuw, viyapawsakiykuw, ata wadid, “Akaanaka, atawa wakwanadiy Mwiya Yitaypika Prisak? Atawa bwula-wayik!” ");
INSERT INTO mle_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aw Jisas dikik ata wadid, “Aw li wun bwulatuwa maaj adi Mwiya Yitaypika Prisak saal viyalik, kidiy miyawa duw takwak yarik yiminik wukikwadiy. Aw li wun atawa bwulatuwa maaj rivilik, aw agwa javik tikuw, viyapaw-minadiwun?” ");
INSERT INTO mle_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Aw Jisas atawa wadik, Anas ata wayakidid Kayapasak adi Mwiya Yitaypika Prisak, kip taba yaviwa tidik. ");
INSERT INTO mle_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita di kip alib tad takasawulaan a yiyab. Aw nuwukadiy dikiwa nakamwiyib tidiy duw taakw dikik ata bas sidaad, “Min kidi duw dikidiy kalivadidiy duw nak min-adimin, ay?” Aw Pita ata maa wadiy dayak, “Wun maa. Suwana. Wun dikidi kalivadidi duw maa.” ");
INSERT INTO mle_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Aw adi Mwiya Yitaypika Pris dikidi yawiy duw nak, di adi Pita waan taay kitikididi duw dikidi gwalugwa duwad. Aw di Pitaak ata bas sidid, “Aw wun vituwadimin nakamwiyib mawayawa miy wardaal tamiyaam kidi duwawa timinik, ay?” ");
INSERT INTO mle_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita ata maa waad, “Wun maa!” Wadik, jayib nak tapwuk ata waad. ");
INSERT INTO mle_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Aw day ata Jisasaam kwurkuw karaydaad, Kayapas wiyaam tidik, a tamiyak yitaypik ridi Roma kidi yitaypika duwak. Aal takwutaakw nalil ganibal. Aw adiy Juw duw maa a diki wiyaar wul, aw aal dayaki lo maa wakwana niki jaka tipa kidi duw wiyaar wula-wulak. Aw day diki wiyaar wulak-dana, Nyi aal a dayaki lo wak tikuw, akis adi God Juw duw takwaam Nyigildidiy bayaki kikipaat kikik-danaad. ");
INSERT INTO mle_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Alik tikuw, Paylat ata wakwud kawaar. Wakwukuw, ata dayak bas sididiy, “Agwa vaalal kidi duwak wagwura kwurdik?” ");
INSERT INTO mle_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aw day Paylatak ata wadaad, “Nyan akis dikim kipakip minak kwurin kariyak-banaad, aw li di vaal yi maardik.” ");
INSERT INTO mle_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aw Paylat dayak ata wadidiy, “Gwur gwura kap dikim kwurkuw, akaray. Gwur gwura dikim kotiy in akwur, gwur gwura lo waar.” Aw adiy Juw duw dikik ata wadaad, “Aw adiy Roma kidiy yitaypika duw nyanak mayaakw kwu maaduwaam viyasipa-bakik aal yidil valik tikuw.” ");
INSERT INTO mle_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kil Juw duw atawa kwurdaal aw aal Jisas wadil maaj mwiya mwiyab tilikikik aal dim viyasipa-kidanadi yabik: “Day maap tikinadi miyaam viyasipa-kidanadiwun,” wakuw wadalik. Aw Roma jaka tipa kidiy duw, day duw maap tidiy miyaam viyasipa-kwadadiy, aw Juw duw maa. ");
INSERT INTO mle_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Aw Paylat ata maa diki wiyaar sibinkuw wulaad. Wulakuw, ata maa wasakwudidiy Jisasaam dikik kwurin kawula-dakik. Aw Jisas dikik wuladik, Paylat ata bas sidid, “Min mwiya Juw duw taakw dayadi yitaypika duw-adimin, ay?” ");
INSERT INTO mle_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Aw Jisas dikik ata wadid, “Min kidi gwuradi Roma yitaypika duw, Sisa, kaytika duwak bwulanadimin? Ay min kidi Juw duw taakw kavikwadanadi yitaypika duwa pika duwak wanadimin, ay?” ");
INSERT INTO mle_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aw Paylat Jisasak ata wadid, “Min wukimina wun Juw duw-adiwun wakuw. Alik atawa waminadiwun, ay? Adiy min minadiy kapa jaka tipa kidiy duwawa yitaypika pris adiy wunak minaam kwurkuw kariyanadiy. Agwa vaala yiminil?” ");
INSERT INTO mle_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aw Jisas ata wadid, “Adi wun van tituwadi tamiy aad kidi kupwaam maa ri. Aw li wun kidi kupwaam van tikik-tuwa, aal adiy wunadiy bapa duw bwunak Juw duwawa wariyak-nadiy adiy wunaam kalakwudaal nyi wunak sugwiyaan kwurik. Aw adi wun van tikwatuwadi tamiy kidi kupwaam maa ri.” ");
INSERT INTO mle_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Paylat Jisasak ata bas sidid, “Aw min yitaypika duw-adimin, ay?” Aw Jisas dikik ata wadid, “Wa wamina maja pik. Wunaki amaay wunaam sapwiylik, kidi kupwaam maak kwadiwun ki yawiyik. A yawiy aal duw takwak kalivaak aal mwiyir mwiyirda tikwana majik. Aw adiy a maaj lakwu-kwanadiy duw taakw day wuna majib wuki-wukib tikwanadiy.” ");
INSERT INTO mle_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Aw Paylat ata maa Jisasak bas sidid, “Aw aal agwa jaaval, aal mwiyir mwiyirda tikwana maaj?” Jisasak atawa bas san napakuw, Jisas sibinin wadil majik kavin ti maarkuw, Paylat ata kawaar wakwukuw, adiy Juw duw takwak wakuw, ata wadidiy, “Wun samab kidi duwaam kotiy kotiy maaw maaj maa sitakir. ");
INSERT INTO mle_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Aw aal gwur gwuraki talaba sukw a gwur Juw duw taakw adiy miyawa God Juw duw takwaam Nyigildidiy bayaki kikipata Nyaam wun duw nak kalabus kwusidikik wapakwatuwaad. Ata ata, aw jaaw wapaaw kidi gwur Juw duw taakw gwuradi yitaypika duwaam kip yidikikik?” ");
INSERT INTO mle_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aw day nimadib dikik gaam sikuw, ata wadaad, “Nyan maa wanadiyan dikik, aw nyan Barapas wapaminkik wanadiyan!” Aw Barapas di nuwukadiy duwaam viyasipataay, dayadiy jaav luwkuw kwurdi duw-ad. ");
INSERT INTO mle_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Paylat ata adiy vay sawdiy duwak wadidiy. Day ata Jisasaam yala wiyaar karaykuw ramiy tidi miy kitika javir viyadaad. ");
INSERT INTO mle_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Dikim viyaan napakuw, ata dikik yitaypika duw dayadiy abwaam takakwadanadiy wapwiy pik balawiy kaytika ramiy til bajigayaar viyatikwurkuw, diki abwaam katatakadaad. Katatakakuw, ata nyikiy nyikiy yitaypika duw kwusuw-kwadanadiy wapwiy kwurkuw, dikim kwusuw-takadaad. ");
INSERT INTO mle_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Atawa dikim mwugiyin napakuw, dikik yikuw, ata wadaad, “Juw dayadi Yitaypika Duw, kip nyi bap van adakw.” Atawa dikik wajibaykuw, ata yala tabaar viyapaw-daad. ");
INSERT INTO mle_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Aw Paylat maa ata kawaar wakwukuw, ata adiy vagaluwdiy miyawa duw takwak wadidiy, “Gwur awuk.” Wun ada gwurak kalakwu-tuwaad. Aw gwur alaakw. Wun dikim yidil vaal samab maa sitakir. ");
INSERT INTO mle_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Alik tikuw, Jisas ata kawaar wakwud abir ramiy til bajigayawa adi wapwiy kwusuw-jibir. Aw day dikim kwusuwtaka-dabir yitaypika duw kaytik tidik rik kwurik. Aw Paylat dayak ata wadidiy, “Av! Kidaanada ya, adi duw.” ");
INSERT INTO mle_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aw adiy yitaypika pris awa God dikidi wiya kidiy vay sawdiy duw Jisasaam vikuw, ata day nimadib wasakwukuw, ata wadiy, “Dikim maap tinadi miyaam akat! Dikim maap tinadi miyaam akat!” Aw Paylat dayak ata wadidiy, “Wun dikim di yidil vaal samab maa sitakir. Alik tikuw, aal gwur gwura yawiya. Gwur gwura karayin dikim maap tinadi miyaam akat!” ");
INSERT INTO mle_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aw adiy Juw duw taakw ata Paylatak wasakwukuw, wadaad, “Wadi duw di waad, ‘Wun God dikidi Nyan-adiwun,’ waan. Aw di atawa wadilik tikuw, aw nyanaki lo di kiyadikik wana. Atawa wadil maaj, aal maa rav.” ");
INSERT INTO mle_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Aw day wadaak, “Jisas di waad di God dikidi Nyan-ad wakuw,” Paylat di mwiya samasam yagaad atawa wadaal maaj wukikuw. ");
INSERT INTO mle_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Paylat di samasam yagakuw, di ata sibinin wulaad maa di diki wiyaar. Wulakuw, di lakwuk Jisas God dikidi Nyan-ad ay maa. Jisasak ata bas sidid, “Min aka tamiyab tikuw, yadimin?” Wakuw, aw Jisas simsim maaj samab maa dikik wu. ");
INSERT INTO mle_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aw Paylat ata dikik wadid, “Aw min wunak maaj bwul maa, ay? Min maa laakw wun ap tinadiwun minaam kip yiminkikik wakituwa? Awarab wun ap tinadiwun minaam wunadiy vay sawdiy duwak maap tinadi miyaam katadakik wakituwa?” ");
INSERT INTO mle_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Aw Jisas Paylatak ata wadid, “Wa minaam tina ap wunaam niki jaav niki jaav kwurik, aal minak God kwiydil apal. Alik tikuw, aw adi wunaam minak kwurin kariya-nadi duw diki vaal mwiya yitaypik tina mina valim.” ");
INSERT INTO mle_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Aw Paylat atawa Jisas wadil maaj wukikuw, di ata Jisasaam kip yidikikik ran wukid. Aw adiy Juw duw dikik nimadib wasakwukuw, ata wadaad, “Aw li adi ‘Wun yitaypika duw,’ waan wakinadi duw, atampika duw aad Rom yitaypika duw dikidi mama duwad. Aw kidi duw di aal jaav bwu kwurdil tayir. Alik aw li min kidi duw mwugiyminik kip yikik-da, aal min adi Roma yitaypika duw dikidi kapa duw ti maa.” ");
INSERT INTO mle_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Aw Paylat atawa wadaal maaj wukikuw, kawaar Jisasaam kwurin kalakwukuw, ata daan rad maaj wuki-kwanadi duw (jas) dikil tikirim, aal kabaka jaab wakwadana tamiyaam. Aw Juw duw taakw dayaki kapa tipa majir sikiy-kwadana “Gapata” waan. ");
INSERT INTO mle_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ganbab tilik, adi God Juw duw takwaam Nyigildidiy bayaki kikipata Nyaam ata Paylat adiy vagaluwdiy miyawa Juw duw takwak wadidiy, “Kidaanada, gwuradi yitaypika duw!” ");
INSERT INTO mle_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aw day dikik ata maa wasakwudaad, “Aviyasip! Aviyasip! Dikim maap tinadi miyaam akat!” wakuw wadaad. Aw Paylat dayak ata maa bas sididiy, “Gwur gwuradi yitaypika duwab maap tinadi miyaam katatuwkik? Jaaw wanadiygwurik, ay?” Aw adiy yitaypika pris dikik ata wadaad, “Nyanadi yitaypika duw, aad Roma kidi yitaypika duwad. Adaanada, dikida duw nak nyanadi yitaypika duw.” ");
INSERT INTO mle_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aw Paylat ata kwiydidiy wadaala jaav aw Jisasaam maap tidi miyaam katadakik. Aw adiy vay sawdiy duw ata Jisasaam kwurkuw, karaydaad. ");
INSERT INTO mle_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Dikim kwurkuw, karaydaak, aw Jisas di diki yatadid adi dikim katakidanadi maap tidi miy. Aw day ata yin aal duw diki abw wakwadana tamiyaar wakwudiy. Aw Juw duw taakw day dayaki kapa tipa majir sikiy-kwadana “Galkata” waan. ");
INSERT INTO mle_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","A tamiyaam ata adi maap tidi miyaam katadaad Jisasaam. Katakuw, kupwaam tikiykuw, vatakasuw-daak, tad. A nyab nikibir duw vitiy-abir katadabir maap tibir miyaam. Katakuw, Jisas diki agika agikim tikiydaak, tibir. Aw Jisas birkibir nyidim tad. ");
INSERT INTO mle_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Aw Paylat duw nak tasakwudid ki maaj lapa nyigaam sukwukuw, Jisas dikidi katadaak tididi maap tidi miyaam vatakadik tal. Kitawa: JISAS NASARIT TIPA KIDI DUW, JUW DUW TAAKW DAYADI YITAYPIKA DUW. Atawa sukwudil. ");
INSERT INTO mle_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Aw aal Jisasaam maap tidi miyaam katadaal tamiy sik maa. Juw dayaki tip Jiruwsalimawa walibab ral. Alik samasama Juw duw taakw vidaal aal Paylat dikidi duw lapa nyigaam sukwukuw, Jisas dikidi maap tidi miyaam kaytakadil maaj. Kidiy tipa majir sukwudil: Yipiruw, Latinawa Grik. ");
INSERT INTO mle_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Aal atawa Paylat di wadidi duw sukwudil maaj adiy yitaypika pris vikuw, day Paylatak ata wadaad, “Min, ‘Juw duw taakw dayadi yitaypika duw,’ waan sukwu-tikwa. Aw min kitawa asukw, ‘Kidi duw di waad, “Wun Juw duw taakw dayadi yitaypika duw-adiwun,” ’ waan. Atawa asukw.” ");
INSERT INTO mle_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Aw Paylat dayak ata wadidiy, “Aal sukwutuwa maaj, aal bwu sukwutuwa. Kip tikwa.” ");
INSERT INTO mle_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jisasaam adiy vay sawdiy duw dikim maap tidi miyaam kataan napakuw, vatakasuwkuw, ata dikidiy kwusuwdidiy wapwiy ata am aliy sidadiy day dayab rivin. Dikidi apiyim kwusuwdidi nimadi wapwiy ab kaypwutiy-daad. Aw adi wapwiy maa takasakiy. Di kipa nimaad tad. ");
INSERT INTO mle_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aw adiy vay sawdiy duw day dayak awarwa awarwa ata titaay wasakiy saladiy, “Nyan dikidi wapwiy kip kaypirikiy-yaay, aw nyan jib kwanadiy kwasadiy kabaak yakitay tayan naynaak adi wapwiy duw nak kwurkwurik.” Aw day atawa kwurdaal ki God diki lapa nyigaam rina maaj mwiya mwiyab tilikikik. “Day wunadiy wapwiy kwurik am sidadiy. Aw wunadi apiyim kwusuw-tuwadi nimadi wapwiy kwurik day jib kwanadiy kwasadiy kabaak yakitay tayan naydiy.” ");
INSERT INTO mle_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas dikidi maap tidi miyawa tidiy adiy di diki amaywa liki nyamwus Maria, Kilapas diki takwawa, Maria Maktala, day-adiy ridiy. ");
INSERT INTO mle_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Aw Jisas diki amaywa wun dikidi mwiya kapa nyan, alim titik, diki amayik ata wadil, “Amaay, wadi nyinawa tinadi duw, wun ada tasakwu-tuwaad nyinadi nyan kaytik tidikikik.” ");
INSERT INTO mle_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aw ata wunak wadidiwun, “Li wunaki amaay, aw li kita aka minaki amaay kaytik tilikikik kwatiyatuwa likik van timinkikik.” Aw a nyab karayrib ata wun wuna kwurjibir karaytuwik, wunawa wuna wiyab kwaal ya. ");
INSERT INTO mle_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas atawa waan napakuw, di bwu lakwudil adiy di kwurdidiy miyawa yawiy adiyka bwu ya kwusiyakidiy wakuw. Alik aal God diki lapa nyigaam rina maaj mwiya mwiyab tilikikik tikuw, di ata waad, “Wun guw kikir yasinadiwun,” wakuw. ");
INSERT INTO mle_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Alim vaak nyigiy yidi wain guwawa tuwdaak, tal. Aw day vay sawdiy duw riv kitika jaav kwurkuw adi vakaam tidi nyigiy yidi wain guwaam buwsikuw, yisap wadadi amasuw kitika javim katatakaan napakuw ata kirasisuw-daal Jisas diki dayir. ");
INSERT INTO mle_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Aw Jisas adi guw kikitaan napakuw, ata waad, “Yaakiya, wunadiy yawiy adiyka bwu kwusinadiy.” Atawa wakuw, di makiy gwarikikuw, ata kiyaad. ");
INSERT INTO mle_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Aw adiy Juw ata Paylatak bas sidaad dayak mayaakw kwadik, aw day adiy maap tidiy miyaam katadadiy duwaam dayadiy maan viyatukwiyak yabiyib kiyadakik. A nyi Fraide tilila. Alik tikuw, aw day kwasik yidiy adiy dayadiy amwiy kip adiy maap tidiy miyab Sapat nyaam titak, aw aal tikina Sapat aal dayak mwiya yitaypika. ");
INSERT INTO mle_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aw adiy vay sawdiy duw yikuw, ata abir Jisasawa nakamwiyib viyasipadabir duw ata birkibir maan viyatukwiya-dabir. ");
INSERT INTO mle_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Aw day Jisasaam yakuw dikibir maan viyatukwiyak, aw day vidaal di bwu kiyaad. Alik tikuw, day dikibir maan maa kaytukwiy. ");
INSERT INTO mle_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Aw vay sawdiy duw nak Jisas diki wasa yalab viyir viyadik, jayib nak nyikiywa guw ata wakwud. ");
INSERT INTO mle_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Aw wun wuna, Jon, wun wunabir milaar adiy jaav vituwdiy atawa tidaak. Aw ki sukwutuwil maaj aal mwiya mwiyaba maaj-al. Aw wun sukwutuwil aw gwur wukijibir tigwurkikik. ");
INSERT INTO mle_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","God diki lapa nyig waal! “Dikidiy amwiy ap nakab tukwiy maa.” Awarab li waal, “Duw taakw dikim vikidanaad adi viyir viyadadim.” Alik tikuw, adiy miyawa jaav diki sipaar yidiy. ");
INSERT INTO mle_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Aw Jawsip, Aramataya tamiya kidi duwad, di Jisas dikidi kalivadidi duwad. Aw di akis wasapwiy yikwadidiy nuwukadiy duw takwak atawa tikwadalik, aw di adiy Juw duw taakw dayadiy yitaypika duwak yagakuw. Aw Jisas kiyaan napadik, Jawsip Paylatak yikuw, bas sidid di Jisas dikidi amwiy kwurik. Aw Paylat, “Min jaaw yin akwur,” wadik, di ata yikuw, kardadid adi maap tidi miyaam tidik. ");
INSERT INTO mle_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Adi tayir gaan Jisasaam vikir yidi duw, Nikadiymas, dibab nakamwiyib Jawsip wukin yad Jisas dikidi amwiy kwulapwuk. Di miy vitiy birkibir kamnyaarir mwugiydadi yaam samasam yaykwadi jaav ab kwurjibir karaydid. Aw adi jaav, aad nimadi yuwiy naagw vata pik yad. ");
INSERT INTO mle_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Aw bir ata Jisas dikidi amwiy kardakuw, adi yaam samasam yayda jaav dikidi amwiyim takakuw, nimadi wapwiy dikidi amwiyim kaygwaygwadi-birid. Akaanaka, atawa kwurkwanadiy Juw duw taakw kiya-kwanadiy duw takwaam dayadiy amwiy kawamiyaam rimsuwik titway. ");
INSERT INTO mle_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Maay nak tal aal Jisasaam maap tidi miyaam katadaal tamiyawa. Aal mawayawa miy wardaal tamiyaam kawamiy nak rad. Tayir dipwu kabakim vadaad. Adi dipwu kabakim ridi kawamiy tayir kiyadiy duw taakw nakab day maa tak. Di kipa kwula kawamiy-ad. ");
INSERT INTO mle_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Aw aal Juw duw taakw dayaki Sapat nyab walibab tililik tikuw, aw adiy kawamiy walibab ridilik, alik Jisas dikidi amwiy alib rimsuw-birid. ");
INSERT INTO mle_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande tilik mwiya ganbab kip gaan van tilik, Maria Maktala li yaal adi Jisas dikidi amwiyim rimsuw-dadi kawamiyaar. Yikuw, vilil aal dikidi kawamiyak takatipidaal mwiya nima kabaak bwu timilin wakwun ral kapab. ");
INSERT INTO mle_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Atawa vikuw, li ata gipiyal. Sayman Pitawa wunak yakuw ata walibiran, “Kipa duw bwutaay kipa tamiyaar karaydaad nyanadi Yitaypika Duw dikidi amwiy kawamiyaam kwadik. Aw nyan ata ata sitakira-kibanaad?” ");
INSERT INTO mle_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Atawa walil maaj wukikuw, ata an Pita wukin gipibiran Jisas dikidi amwiy kwadidi kawamiyaar. ");
INSERT INTO mle_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","5","An nakamwiyib gipitil aw wun Pitaam kakilkuw, wun tayib yikuw, adi dikidi kawamiyaam tidiwun. Tikuw, wun kwakitadataka dikidi kwadidi kawamiyaar kitawur vidiwun. Adi dikidi amwiyim kaygwadidadi wapwiyda vituwid. Aw wun maa wul adi yala dipwu kabakir. ");
INSERT INTO mle_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Aw Sayman Pita wuna kwukir yakuw, di aad wulaad adi dipwu kabaka kawamiyaar. Wulakuw, di vididiy adiy wapwiy ridiy. Aw adi tayir Jisas diki abwaam jibirdadi wapwiy yarakara kaydavikuw, kapakap rad. ");
INSERT INTO mle_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Aw wun, adi kawamiyaar taay yadi duw, wunabab kwukir ata adi dipwu kabakir wulakuw, adiy jaav vikuw, wun ata wukijibir tidiwun Jisas bwu rasid. ");
INSERT INTO mle_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Aal nyi nyan samab maa laakw aal God diki lapa nyigaam rilil maaj aal walil Jisas di kiyadiy duw taakw nyidim rikuw di rasikuw, kwakinaad nyi bap van. ");
INSERT INTO mle_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Atawa adiy jaav vikuw, an ata sibinin yibiran maa an anaki kwatil wiyaar. ");
INSERT INTO mle_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Aw an adi kawamiy wapakuw sibinin yitik, Maria li sibinin yikuw, adi kawamiy kawaam titaay giraal. Girataay, li ata adi dipwu kabakir kitawur vikir kwakitadaal. ");
INSERT INTO mle_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Vikuw, li vilibir God diki maaj kardadiy duw vitiy ribir aal Jisas dikidi amwiy taay takadadi kawamiyaam wamakawama wapwiy kwusuwtaka. Aw nak tayir Jisas diki abw takadil tamiyawa, nak dikibir maan kwusidadil tamiyawa ribir. ");
INSERT INTO mle_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aw bir ata bas sibiril, “Nyin agwa javik gira-nanyinik?” Aw li birakik ata walibir, “Kipa duw wunadi Yitaypika Duw dikidi amwiy kwurkuw, kipa tamiyaar karaydaad. Aw wun maa laakw dikidi amwiy takadaal tamiy. Alik giranawun.” ");
INSERT INTO mle_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Aw li atawa wakuw, tipatiyakwukuw, ata vilid Jisas liki kwukim tidik. Aw li samab dim maa vikirakiy. ");
INSERT INTO mle_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aw Jisas likik ata bas sidil, “Nyin agwa javik titaay gira-nyanyinik? Sikadadaad titaay kwaki-nyinad?” Aw Maria li mawulaar wukil, “Kad mayim yawiy kwurkwanadi duwad,” wakuw. Li ata dikik walid, “Sapakwa duw, aw li min dikidi amwiy kwurkuw karayminid wakuw, min wunak waminik aal takaminil tamiy, aw wun karayik dikidi amwiy.” ");
INSERT INTO mle_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Aw Jisas likik ata “Maria,” wadik, li ata tipatiyakwukuw, dikik ata walid day dayakil Juw duw taakw kapa tipa majir, “Rapanay” waan. Aw aal maaj liki maaw aal Gaba Maja duwa wakwadanaala. ");
INSERT INTO mle_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Aw Jisas likik ata wadil, “Nyin wunaam kaykitijibir ti maa aw wun nyinawa tituwkikik. Aw wun maa nibway war wunadi Asayik diwa kwakir. Aw nyin kita sibinin maay wunadiy kaliva-tuwdiy duwak, adiy kita sikiy-tuwadiy wunadiy nyamwusugwuk. Dayak aw wun wunadi Asayik sibinin warkinadiwun gwurabab gwuradi Asayad. Wunadi Godak gwurabab gwuradi Godad wakuw.” ");
INSERT INTO mle_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Aw Maria Maktala ata sibinin yikuw, Jisas dikidiy kalivadidiy duwak yarik yilidiy, “Wun bwu vituwaad Yitaypika Duw Jisasaam.” Aw adiy dayak walikikik wadidiy miyawa maaj ab ata dayak yarik yilidiy. ");
INSERT INTO mle_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Aal Sande ab gaan kwusilik, Jisas dikidiy kalivadidiy duw ata nakamwiyib vagaluwdiy wiy nak. Aw day adiy Juw duw taakw dayadiy yitaypika duwak yagakuw, aw aal kwadaal wiy wiyig kwatatipi-dabir. Aw Jisas di yakuw, kip dayadiy nyidim wakwukuw, ata tad. Atawa tikuw, dayak wayapiy sididiy, “Gwuradiy mawul kwusida-takaan ada,” wakuw. ");
INSERT INTO mle_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Atawa waan napakuw, ata simaka-didiy dikibir maap tidi miyaam katadabir tabawa dikim viyir kapira-daal wasa yaal. Aw ata ya dikidiy kalivadidiy duw dayadi Yitaypika Duw Jisas makaam vikuw, lakwukuw kiyakuw rikuw rasidik, day mwiya rakarak samasam tidiy. ");
INSERT INTO mle_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Aw Jisas dayak jaab nakab ata maa wadidiy, “Gwuradiy mawul kwusida-takaan ada. Aw wunadi Asaay wayaki-didiwun diki yawiy kwurtuwkik. Atampik wunabab aka kita wunaki yawiy kwurgwurkik wayaki-tuwadiygwurik.” ");
INSERT INTO mle_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Dayak ata waan napakuw, dayaam ata wuriba sawulakuw, ata wadidiy, “God dikidi Mawul akwur!” ");
INSERT INTO mle_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Di ata wadidiy, “Adiy wakik-gwuradiy duw taakw dayadiy vaal bwu kwusinadiy waan wakigwuradiy duw taakw, God dayadiy vaal yibwiy-kidadiy. Aw adiy wakigwuradiy duw taakw dayadiy vaal maa kwas, kip rinadiy waan, God adiy duw taakw dayadiy vaal yibwiy maa. Kip rikinadiy.” ");
INSERT INTO mle_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Aw adi vitiy kisa nyan wakwadanadi duw, Tomas, Jisas dikidiy kalivadidiy tabatiy maan vitiya duw nak, di maa ri dayawa aal Jisas dayak yaan maak takadil gaan. ");
INSERT INTO mle_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Alik tikuw, nuwukadiy Jisas dikidiy kalivadidiy duw dikik yarik yidaad, “Nyan bwutaay vibanaad nyanadi Yitaypika Duw Jisas.” Aw Tomas dayak ata wadidiy, “Aw li wun adiy dikim maap tidi miyaam tidik katadadiy taab dayadiy kaar vi maarkuw, aw wunadi duwa taab dayaam kwusawul maarkituwa, wun taab aal viyir kapiradaal diki wasa yalaar tipwul kwusawula maarkituwa, aal wun ata gwura majik wukijibir ti maa.” ");
INSERT INTO mle_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Niki Sande gaan ata maa vagaluwdiy wiyaam. Aal gaan Tomas ab nakamwiyib rad dayawa. Wiyig kwatatipikuw, aw Jisas ata maa kip wakwukuw dayaki nyidim, ata tad. Tikuw, dayak ata wadidiy, “Gwuradiy mawul kip kwusida-takaan ada.” ");
INSERT INTO mle_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomasak ata wadid, “Wunabir tabak av. Minadi taab kidiy yayir katadadiy dayadiy karir akwusawul. Minadi taab akwusawul wunaki viyir kapirasawula-daal wasa yalaar. Samab wunak mawul vitiy katiy ti-wayik. Kip wukijibir ada.” ");
INSERT INTO mle_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ata Jisasak wadid, “Wunadi Yitaypika Duw. Wunadi God.” ");
INSERT INTO mle_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Aw Jisas dikik ata wadid, “Aw min atawa wunaam vikuw aka wukijibir timina, ay? Aw adiy wunaam dayadiy kapa milaar vi maarkuw wukijibir tikinadiy duw taakw, adiy duw taakw mwiya rakarak tikinadiy.” ");
INSERT INTO mle_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas kipa java viyakita yawiy dikidiy kalivadidiy duw dayadiy mwutamaam titaay kwurdidiy. Aw ki lapa nyigaam wun maa ababa maaj viyapiryak. ");
INSERT INTO mle_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Aw kidiy jaav sukwutuwadiy aw mwiyir gwur wukijibir tigwurkikik Jisas di God dikidi Tasakwudidi Duwad, God di dikidi Nyanad, wakuw. Aw dikik wukijibir tikigwuralik tikuw, gwur kip nyanyi viyakita mwiy Godawa nakamwiyib kwaya-kinadiygwurik. ");
INSERT INTO mle_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ginyir nyan dikidiy kalivadidiy duw Taypiriyas araam kwadiyan. Kwabaak, jaab nakab ata Jisas maa nyanak wakwud. Di kitawa kwurid nyanak wakwukuw. ");
INSERT INTO mle_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sayman Pitawa Tomas, adi vitiy kisa nyinwa Nataniyil, Galiliy tamiyaam ril tip Kana tipa kidad, Sipatiy dikibir nyidiywa, nikibir vitiya duwawa Jisas dikidiy kalivadidiy duwawa kidiy duw ab nyan abab nakamwiyib alim kwadiyan. ");
INSERT INTO mle_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Aw Sayman Pita nyanak ata wadidiyan, “Wun nagirir kamiy kwurik yikinadiwun.” Aw nyan ata wabaad, “Nyanabab minawa yakinadiyan.” Ata nyan abab dakuw jabir kwurkuw, ata wakwudiyan gwus kan araar. Aw nyan adi miyawa gaan nyan simsim kamiy samab maa kwar. ");
INSERT INTO mle_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sira pik ganib nyi wardik, Jisas di mala arawa rasin tad. Aw nyan samab maa dikim vikirakiy. ");
INSERT INTO mle_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aw di ata nyanak wasakwu-didiyan, “Kapa nyanugw, kamiy kwurnadiygwurik?” Aw nyan dikik ata wabaad, “Samab maa.” ");
INSERT INTO mle_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aw di nyanak ata wadidiyan, “Wadi gwuradi nagir waal gwuraki jabir mava maka gikir guwaar ayakisakw! Aw gwur kamiy ata kwur-kinadiygwurik.” Aw nyan ata adi nagir yakisakwubaad. Yakisakwubaak, kamiy mwiya samasam adi nagirir wuladiy. Alik nyan mwiyir maa rav jabiraar kawurik kwurbaal. ");
INSERT INTO mle_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aw wun ata Pitak watuwid, “Nyanadi Yitaypika Duwad kinawul.” Aw Pita di simsim wapwiy maa samab kwusuw diki yawiyik. Atawa watuwil maaj wukikuw, “Di Yitaypika Duw Jisas-ad rasin tinaad mala araam,” wakuw, di yapwur yapwur wapwiy jan napakuw, ata di yapwur yapwur di yabiyib Jisasaam sitakirak tikuw, di ata guwaam sakirakuw, pwiyawulaad. ");
INSERT INTO mle_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Aw nyan Jisas dikidiy kalivadidiy duw nyan adi kamiywa nagir ararib guwaar lagwun kawulakuw, wulaan tabirdiyan. Aw nyan sikaam maa kwu, aal yibwunwa walibab kwadiyan. Kwasa tipakwu ril tamiyaam kwaan nagir yakisakwubaala. ");
INSERT INTO mle_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Aw nyan kawiykuw vibaal yiy sakil sakil nakuw, rilik. Kamiywa nuwukadiy bret ab ridiy. ");
INSERT INTO mle_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Aw Jisas nyanak ata wadidiyan, “Nuwukadiy kwurgwuradiy kamiy akaray.” ");
INSERT INTO mle_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aw Sayman Pita ata jabiraar gipin dakuw, adiy nimadiy kamiywa wapwurukwun ridi nagir lagwudik, wulaan tabirdik, aw adiy kamiy miyawa nasibaal adiyka 153-adiy. Aw day mwiya samasam tidaal ab aw adi nagir samab maa takw. ");
INSERT INTO mle_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Aw Jisas nyanak ata wadidiyan yin kamnaagw kibakikik. Aw nyan abab bwu lakwubaal di nyanadi Yitaypika Duw-ad. Aw nyan yagadiyan dikik bas sisak, “Min mwiya mwiyab min-adimin?” waan. ");
INSERT INTO mle_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Aw Jisas ata yakuw, adiy bret kwurkuw, kwatiya-didiyan kibakikik. Adiy kamiy ab ata kwurkuw kwatiya-didiyan. ");
INSERT INTO mle_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisas kiyakuw ridik, God kirapitakadik, nyanak diki maak takadil jaab mugwula yaaw aka. ");
INSERT INTO mle_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kamnaagw kikwusikuw ribaak, Jisas Sayman Pitak ata bas sidid, “Sayman, Jon dikidi nyan, min wunak kidiy nuwukadiy wunadiy kaliva-tuwadiy duw dayadiy wunak yidanadiy mawulaam minaki wunak yimina mawul dayadiy mawulaam kakilna?” Aw Pita dikik ata wadid, “Ayiy, Yitaypika Duw, aw wun minadi kapa nyan-adiwun.” Aw Jisas dikik ata wadid, “Adiy badiy sipsip ak galab kwurtaay, dayak kamnaagw yakwiya-kwanadi duwa pik, atampik minabab ki wunaki maaj adiy wunak wukijibir tikinadiy duw takwak akaliv.” ");
INSERT INTO mle_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jaab vitiya yay Jisas maa Pitaak bas sidid, “Sayman Pita, Jon dikidi nyan, min mwiyir mawul yiminadiwun?” Aw Pita ata wadid, “Ayiy, Yitaypika Duw, min bwu lakwu-minadiwun wun minadi kapa nyan-adiwun.” Aw Jisas Pitaak ata wadid, “Adi sipsip ak galab kwurkwanadi duw kaytik, adiy wunak wukijibir tikinadiy duw takwaam galab akwur.” ");
INSERT INTO mle_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jaab mugwula yaw ata maa Jisas bas sidid, “Sayman, Jon dikidi nyan, min mwiya wunadi kapa nyan-adimin, ay?” Aw Pita ata ya sarmabap tad aw Jisas dikik jaab mugwula yaw bas sidilik, “Min mwiya wunadi kapa nyan-adimin?” waan. Aw Pita ata Jisasak wadid, “Yitaypika Duw, min ababa jaav miyawa lakwuyaki-minadiy. Aw min lakwu-minadiwun, wun minadi kapa nyan-adiwun.” Aw Jisas dikik ata wadid, “Adi kamnaagw sipsip ak yakwiya-kwanadi duw kaytik, adiy wunak wukijibir tikinadiy duw takwak wunaki maaj akaliv. ");
INSERT INTO mle_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Wun mwiya mwiyab watuwadimin, kip badiy kwamina sikir min minadiy wapwiy kwusuwkuw, min mina yikir mawul warkwamina tamiyab tiytiyaan tikwadimin. Aw ginuir apaan tikimina, min kip minabir taab kwusakwu-minik, nuwukadiy yaav jikuw, ata kwurin karay-kidanadimin aal yikir mawul war maarkimina tamiyaar.” ");
INSERT INTO mle_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Aw Jisas di atawa Pitaak simakak wadila aw day dikim viyasipa-kidanadi yaab. Aw di kiyakuw, duw takwaam sisuwdik, Godak gaba maaj sukwu-kidanalik. Aw Jisas Pitaak ata wadid, “Kip wunadi kalivatuwadi duw tijibir ada.” ");
INSERT INTO mle_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita tipatiyakwukuw, vididiwun birki kwukib yituwik. Wun, adi Jisas dikidi kalivadidi mawul yikwadadi duw-adiwun. Aw wun-adiwun, tayir day Jisasaam viyasip maardaak nibway, dikiwa walibab ridiwun, nyan dikidiy dikidiy kalivadidiy duw nakamwiyib kamnaagw kitaay rikuw, dikik bas situwil, “Sikadadaad minaam minadiy mama nib tabaam takakinaad?” waan. ");
INSERT INTO mle_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Aw Pita wunaam vikuw, ata di Jisasak bas sidid, “Yitaypika Duw, agwa jaava kidi duwak yakina?” ");
INSERT INTO mle_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Aw Jisas dikik ata wadid, “Aw li wuna mawul walik di kip nyanyi nyanyi nyi bap van kwadikikik wakituwa aw yin wun kidi kupwaar sibinin yakituwa nyab, aw aal minaki yawiya, ay? Min kip wunadi kalivatuwadi duw ada.” ");
INSERT INTO mle_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aw ata kipa kipa maajal miyawa adiy Jisas kwukib yadiy duw wadiy wun kiy maa waan. Aw Jisas di wun kiy maa waan maa wu. Aw di kip kitawa waad, “Aw di kip nyanyi nyanyi nyi bap van kwadikikik wakituwa aw yin wun kidi kupwaar sibinin yakituwa nyab, aw aal minaki yawiya, ay?” ");
INSERT INTO mle_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wun-adiwun, adi Jisas bwuladidi dikidi kalivadidi duw, aw wun wuna kapa milaar vituwdiy adiy miyawa jaav. Vikuw, lapa nyigaam sukwutuwdiy aw gwur lakwu-kinadiygwurik kidiy maaj mwiya mwiyaba maaj-adiy. ");
INSERT INTO mle_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kipa java yawiyadiy Jisas kwurya-didiy. Aw li nyan ababa dikidiy kwurdidiy yawiy maaj sukwukibana nak ata nak ata, aal kipa java lapa nyig kwusi-kinadiy dikidiy yawiy majidanik. Aw wun wukituwa kidi kupwaam rinadiy miyawa duw taakw akis rivik-nadiy a yawiyik. ");
INSERT INTO mle_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Kupwiyaay Tiyapilas, wuna maaj awuk. Taay sukwutuwil lapa nyigaam kidiy jaav watuwdiy. Agwa javadiy Jisas bas kwurdidiy. Agwa javadiy di duw takwak kalivadidiy. Kidiy jaav kwurdidiy yin God adawur tipaar kirapitakakuw, kawardid. Aw taay God dikidi Mawul diki mawulaam sisuwdik, Jisas maaj kwiydil dikidiy diki maaj karaydiy duwak. ");
INSERT INTO mle_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisas kiyakuw ridik, God dim kirapitakakuw, di nyi duwamiy vitiy kwaan jaab samasam dayak maak takadidiy. Di dayak jaab samasam niki jaav niki jaav simaka-dilik, alik day wukidiy di mwiyir kip kwaad. Di dayak yakuw, di wadidiy ata ata God duw takwak van tikinaad. ");
INSERT INTO mle_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Vagaruwdaak, Jisas wadidiy, “Jiruwsalim wapatikwa. Kilim kavin ada wunadi Asaay dikidi takadidi abanik. Tayir watuwdiygwur dikik. Jon guwaar baptais kwiyid. Aw nyi aywa maa God dikidi Mawulaam baptais kwiykida gwurak.” ");
INSERT INTO mle_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Adiy vagaluwdiy duw dikik bas sidaad, “Yitaypika Duw, a nyi nyan nyana Yisrayil duw tayir tibal pik kap tikidiyan ay?” ");
INSERT INTO mle_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Di dayak ata wadidiy, “Aal gwura jaav maa. Wunadi Asaay, di kap diki mawul warlik, adiy nyi wakidadiy. ");
INSERT INTO mle_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","“Aw God dikidi Mawul yakuw, gwuradiy mawulaar wulakida, ap ata tikinadiygwur. Ap tikuw, wuna maaj wasapwiy-kigwura Jiruwsalim tipa kidiyik taay, ata ababa Juwtiyawa Samariya abir tamiya kidiyik, ata yin kidi kupw miyawa tamiya kidiyik. Atawa wuna maaj ababa duw takwak wasapwiy-kigwuradiy.” ");
INSERT INTO mle_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jisas ki maaj wakuw, God dim kirapitakakuw, kawardid adawur tipaar. Day vidaak, gilagawur wuladik, day Jisasaam maa vi. ");
INSERT INTO mle_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kituw vijibil tidaal ab, jayib ni duw vitiy, birim wamakawama wapwiy tibir, dayak wakwubir. Wakwun nyidim tibir. ");
INSERT INTO mle_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bir wabiridiy, “Gwur Galiliy tamiya kidiy duw, agwa javik gilagawuk van tinadiygwur? Jisas ada adawur tipaar warnaad. Bwu vigwuraad. Aw warda pik ginyir sibinin maa dakinaad.” ");
INSERT INTO mle_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Day ata a nibwuk si Aliv wapakuw, Jiruwsalimaar sibinin dadiy. Jiruwsalim sik maa, walibab rinaad. ");
INSERT INTO mle_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jiruwsalimaar wakwukuw, day daya kwadaal apiyim kwal kwasa wiyaar wardiy. Adiy duw dayadiy si: Pita, Jon, Jamis, Adiruw, Pilip, Tomas, Batalimuw, Matiyuw, Jamis Alpiyas dikidi nyanad, Sayman day sikiydaad, “Ap samasam tinadi duw,” Juwtas Jamis dikidi nyanad. ");
INSERT INTO mle_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Day jaab samasam vagaluwdiy Jisas dikidiy nyamwusugwawa, diki amaywa, nuwukadiy takwawa. Day mawul nak tikuw, Godawa maaj bwuladiy. ");
INSERT INTO mle_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nyi nak duw duwamiy abwun vagaluwdaak, Pita rapikuw, maaj kwiydidiy. ");
INSERT INTO mle_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Di dayak wadidiy, “Gwur wunadiy gwalugwa duw taakw, gwurak waaw. Tayir God dikidi Mawul Davit diki mawulaam sisuwdik, Davit maaj sukwudil Juwtas Yiskariyat-ak. Di waad ginyir Juwtas nuwukadiy duwak sugwiyaan kwurdik, day Jisasaam kalakwu-kidanaad wakuw. God wadik, ki sukwudil maaj aal bwu maykaar wakwul. ");
INSERT INTO mle_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","“Tayir Jisas Juwtas tasakwudik, di nyanawa God diki yawiy kwurdil.” ");
INSERT INTO mle_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Juwtas diki kwurdil kupwarapa yawiyik day saan kwiydaal. Kupw nak yapiydil a sanaar. Alim kupwaam vakirdik, diki yaal ap vitiy wutakuw, nyamabaam ridiy jaav maykaar wakwudiy. ");
INSERT INTO mle_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ababa Jiruwsalimaam kwadiy duw taakw a jaav wukikuw, a kupw liki si sikiytakadaal Akiltama waan. Maaw maaj, “Nyikiy ril kupw-al.” ");
INSERT INTO mle_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita ata wadidiy maa, “Davit sukwudil lapa nyigaam, day sikiydaal Sam (maaw maaj ‘Godak song aam rakarak tinadiyan,’) ki maaj sukwudil, ‘Diki wiy kip tikina. Nikidi duw alim kwu maa.’ Niki maaj ab sukwudil, ‘Nikidi duw diki tamiy kwurkida.’ ");
INSERT INTO mle_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Alik tikuw, nikidi duw tasakwunaak nyanawa tibagwukuw duw takwak wasapwiyik God Jisasaam kirapitakadid wakuw. Jisas nyanawa kidi kupwaam kwadik, Jon duw takwak baptais kwiydil nyaam, aw yin God Jisasaam adawur tipaar kawarda nyaam nuwukadiy duw nyanawa yin yaan tidiy. Aw kidi bapa duwaam duw nak tasakwunaak.” ");
INSERT INTO mle_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Day duw vitiy tasakwudabir. Duw nak, Jasip Basapas nikidi si Jastas, aw nikidi duw Matayas. ");
INSERT INTO mle_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Day ata Godak bas sidaad, “Yitaypika Duw, min ababa duw dayadiy mawul lakwu-kwaminadiy. Alik nyanak asimak agwa duwad min tasakwu-minaad Juwtas diki tamiy kwurdikik. Juwtas, di Jisas dikidi diki maaj karaydi duw tidik, diki yawiy wapakuw, kupwarapa tipaar yad.” ");
INSERT INTO mle_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Sikirip vitiy, simiy pik nak, pav pik nak, tabaam yipakwun kwurin tidibir. Jasip nak kaylupwudid. Aw Matayas nak kaylupwudid. Matayas simiy pika sikirip kaylupwukuw, di kakilid. Kakilkuw, nuwukadiy tabatiy maan nak duwawa di Jisas dikidi diki maaj karaydi duw ata tad. ");
INSERT INTO mle_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Juw daya bayaki nyi, si Pentikos, a nyaam ababa Jisasak wukijibir tidiy duw taakw vagaluwdiy. ");
INSERT INTO mle_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Day nimadi kwudiy nimadi mwar kitik wukidaad tubwaam. Wukidaak, jaab nak adi kwudiy dakuw, yala wiyaar wulaad. Wuladik, daya ridaal wiy ata kapwud. ");
INSERT INTO mle_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Day van ridaak, nibiy yiy kitika jaav kwaliya kwaliyakikuw, dayaam nakanak daan ridiy. ");
INSERT INTO mle_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","God dikidi Mawul dayadiy mawulaar wuladik, dayadiy mawul ata wapwurukwudiy. Wapwurukwukuw, God dikidi Mawul ap dayak kwiykuw, day ata niki kwudiy niki kwudiyir ata bwuladiy. ");
INSERT INTO mle_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A nyaam Godak wukijibir tidiy Juw Jiruwsalimaam kwadiy. Kidiy duw day niki jaka tip niki jaka tipa kidiy-adiy. ");
INSERT INTO mle_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kidi nimadi kwudiy wukikuw, duw taakw samasamadiy yaan vagaluwdiy. Day daya kapa tipa maaj wukikuw, day pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Pitaan warkuw, day ata wadiy, “Kidiy niki maaj niki maaj bwulanadiy duw day abab Galiliy tamiya kidiy duw-adiy. ");
INSERT INTO mle_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","“Ata ata day maaj bwuladaak, nyan nyana kapa tipa maaj wukinadiyan? ");
INSERT INTO mle_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","“Nyan nyanadiy jaka tip samasam-adiy. Patiya, Mitiya, Yilam, Misapatamiya, Juwtiya, Kapadasiya, Pantas, Asiya, Pirikiya, Pabiliya, Yijip, Sayriyniy walibab ril tamiya Lipiy-aam, Romawa. Kirit jaka tipa kidiy, Arapiya jaka tipa kidiy, mwiya Juwawa niki jaka tipa kidiy day Juw dayadiy sukw kwurdanadiy, aw nyan abab nyan nyana kapa tipa majir wukinadiyan God dikidiy nimadiy yawiyik.” ");
INSERT INTO mle_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Day abab pitaan warkuw, day samasam wukidiy. Day daya kap awarwa bas sidiy, “Kidi jaav ata ata wanaad?” ");
INSERT INTO mle_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aw nuwukadiy duw day sapis jikin kwurdadiy Jisasak wukijibir tidiy duwak. Day wadiy, “A! Kidiy duw guw kikuw, duw tikwulnadiy.” ");
INSERT INTO mle_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita nuwukadiy tabatiy maan naka duwawa rapikuw, di ki maaj nimadib wasapwiydil vagaruwdiy duw takwak, “Gwur Juw duw taakw, gwur abab Jiruwsalimaam vagaluwnadiy duw taakw, wuna maaj awuk. ");
INSERT INTO mle_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Nyan abab duw maa tikwul. Aw kita kip ganib tina nyi abaliyaam tinaad. (Nibwul God duw takwak dikidi Mawul kwiydaad.) ");
INSERT INTO mle_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","“Tayir God diki maaj wasapwiydi duw, si Jawil, ki maaj wadil ki javik: ");
INSERT INTO mle_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God wanaad, “Kwukir rikinadiy nyaam kidiy jaav taay kwurtuwik, ginyir kidi kupw kwusikinaad. Wun wunadi Mawul kwiytuwik, di ababa duw taakw dayadiy mawulaar wulakinaad. Di dayadiy mawulaar wulakuw, gwuradiy duwa nyanugwawa takwa nyanugw wuna mawulaam rinadiy maaj wasapwiy-kidanadiy. Gwuradiy badiy duw wunadiy simaka-kituwadiy jaav vikidanadiy. Gwuradiy apaan duw dayak kwiytuwik yigin vikidanadiy. ");
INSERT INTO mle_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A nyaam wunadi Mawul kwiytuwik wunadiy yawiy duw takwak ab, dayadiy mawulaar wulakinaad. Dayadiy mawulaar wulakida, day wuna mawulaam rinadiy maaj wasapwiy-kidanadiy. ");
INSERT INTO mle_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Adawur tubwawa kidi rinadi kupwawa abirakim wuna mawulaam rinadiy nimadiy yawiy adiyka kwurkituwadiy. Nyikiywa yiyawa nimadi yakiywa a nyaam tikidiy. ");
INSERT INTO mle_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wun watuwik, nyi kwusikuw, gandika tikina. Wun watuwik, bap nyikiy nyikiy tikina. Atawa tikuw, Yitaypika Duw diki yakida viyakita nyi aka walibab tikina. ");
INSERT INTO mle_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Agwa duw taakw gwuradi Yitaypika Duw wunak, gaam sikidiy, adiy duw takwadika kwurkituwadiy.” ’ ");
INSERT INTO mle_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Yisrayil duw taakw, ki maaj awuk. Jisas Nasarit tipa kid gwurawa kwadik, di duw taakw sipwutiydidiy. Nuwukadiy nimadiy yawiy ab kwurdidiy. Gwur dikidiy kwurdidiy yawiy vikuw, gwur wukigwura God ap kwiydid adiy yawiy kwurdikik. ");
INSERT INTO mle_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","“Tayir God diki mawulaam tikuw, di yaakiya waad Jisas yadikikik gwuradiy tabaar. Gwuradiy tabaar yadik, gwur yaakiya wagwur, Roma gavman dikidiy kupwarapa vay sawdiy duw maap tida miyaam katadaad. Aw gwur alik viyasipagwurid. ");
INSERT INTO mle_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","“Jisas kiyakuw, atawa riri maa rav. Aw God Jisas diki kiyak yidil kagil wukikuw, kiyakuw ridik, ata kirapitakadid. ");
INSERT INTO mle_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Tayir Davit ki maaj wadil dikik: ‘Wun wukituwil Yitaypika Duw di nyanyi nyanyi wunawa tikwanaad. Di walibab tikwanaad yagak-nadiwun. ");
INSERT INTO mle_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wuna mawul rakarak tina ki javik. Alik wuna majik rakarak tinadiwun. Wun wukinadiwun wun kiyakuw, wun yara kwakinadiwun. Alik wun kiya-kiyak yaag maa. ");
INSERT INTO mle_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Wunaki mawul, min wap maa kiyanadiy duw taakw daya tipaam kwakwak. Min wamina mina viyakita yawiy duw diki amwiy pwuk yaay maa kawamiyaam. ");
INSERT INTO mle_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Min simaka-kiminadiy agwa javadiy wun kwurkuw, minawa nyanyi nyanyi kwakwak. Min wunawa kwaminalik, alik wun rakarak samasam tikinadiwun.’ ");
INSERT INTO mle_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Gwalugwa duw, gwur awuk. Wun gwurak mwiyir watuwadiygwur nyanadi warag Davit-ak. Di dikik maa wu. Aw di kiyadik, day diki amwiy kawamiyaam takadaal. Dikidi kawamiy kidika nyana nyidim rinaad. ");
INSERT INTO mle_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","“Davit God diki maaj wasapwiydi duw tad. God aban takadil dikik. God wadid ginyir dikidi gwalugwa duw nak duw takwaam van tikinaad di diki Davit kitik. ");
INSERT INTO mle_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","“Davit God diki kwurkida yawiy lakwudil. Di lakwudil God dikidi Tasakwudidi Duw kiyakuw ridik, God kirapitaka-kidaad. God Jisasaam maa wap kiyanadiy duw taakw daya tipaam. Aw diki amwiy pwuk maa yaay. ");
INSERT INTO mle_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Kidi Jisas kiyadik, God kirapitakadid. Nyan abab ki jaav vibaal. ");
INSERT INTO mle_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“God Jisasaam kwurin kawardik, di God diki mava tabaam rinaad kita. God dikidi Mawul Jisasak kwiydid, tayir lakatiydil maaj kitik. Aw kita Jisas God dikidi Mawul kwiydid nyanak. Kita wukikuw, adika vigwuraad. ");
INSERT INTO mle_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","“Davit di adawur tipaar atawa maa war. Aw di ki maaj wadil: ‘God wunadi Yitaypika Duwak wadid, “Min wuna mava tabaam daan ada. Wun minadiy mama nibaam kakilkuw, day yawiy kwurkinadiy minak.” uuuu’ ");
INSERT INTO mle_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Yisrayil tipa kidiy duw taakw, awuk! Kidi Jisas gwur viyasipakuw maap tidi miyaam, dikik God ki maaj wadil, ‘Min wunadi Tasakwutuwadi Duw-adimin. Duw taakw dayadi Yitaypika Duw-adimin.’” Pita wakuw, wadidiy. ");
INSERT INTO mle_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Day ki maaj wukikuw, mawul wukitay tayan ridiy. Day Pitawa nuwukadiy Jisas diki maaj karaydiy duwak wadadiy, “Gwalugwa duw, agwa jaav kwurkinadiyan?” ");
INSERT INTO mle_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita dayak wadidiy, “Gwur nakanak gwuradiy valik bwan kwiykuw, baptais akwur Jisas dikidi saam, God gwuradiy vaal kwurin yakidikik. Gwur atawa kwurgwur, God dikidi Mawul ata kip kwiykidaad gwurak. ");
INSERT INTO mle_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ki aban God takadil dikidiy tasakwudidiy duw takwak, gwurawa, gwuradiy nyanugwak, aw abab sika tipaam kwanadiy duw takwak ab.” ");
INSERT INTO mle_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita diki mawulaam ridiy niki maaj niki maaj wadidiy. Di dayak wadidiy, “Yarakara van ada kupwaraap tikik-nadiygwur kidi kupwarapa bapa duw takwawa.” ");
INSERT INTO mle_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dayaam duw taakw samasam diki maaj wukijibir tikuw, baptais kwurdiy. A nyaam duw taakw 3000 (duwamiyir duwamiyir) bas Kristen tikir wakwudiy. ");
INSERT INTO mle_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Adiy duw taakw alim kwadiy Jisas dikidiy diki maaj karaydiy duw dayadiy kalivadadiy maaj wukik. Day mawul nak tikuw, kipaat nakamwiyib kidiy. Jisasak wukijibir tikuw, day Godawa maaj bwuladiy. ");
INSERT INTO mle_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jisas dikidiy diki maaj karaydiy duw God diki mawulaam ridiy viyakita yawiy kwurkuw, ababa duw taakw ata pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ababa Jisasak wukijibir tidiy duw taakw nakamwiyib kwadiy. Ababa jaav dayadiy javadiy, day dayadiy. ");
INSERT INTO mle_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Day dayadiy niki jaav niki jaav yapiyin, saan kwurin, niki jaav niki jaav ti maardiy duw takwak kwiydadiy. ");
INSERT INTO mle_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Nyanyi God dikidi wiyaam nakamwiyib vagaruwun, rakarak tikuw, day dayadiy wiyaam kikipaat kan nakamwiyib day rakarak samasam tikuw Godak, day dikik nyanyi wayapiy sidaad. Nuwukadiy duw taakw dayadiy mawul viyakit tidiy dayak. Ababa nyi God dikidiy tasakwudidiy duw taakw Jisasak wukijibir tikuw, dayawa nakamwiyib kwurjuwdiy. ");
INSERT INTO mle_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nyanyi, nyi mugwulaam tidik, Juw duw taakw God dikidi wiyaar yikwadiy beten ik. Nyi nak, nyi mugwulaam tidik, Pitawa Jon bir God dikidi wiyaar warbir. ");
INSERT INTO mle_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bir vibirid duw nak yataan kariyadaad, dikibir maan kupwaraap tibir. Amaay sapwiylik, dikibir maan atawadika tibir. Nyanyi day adi duw kariyakuw, wiyig si Viyakita Wiyig, a wiyig walibab tilil tamiyaam takadaad. Takadaak, di God dikidi wiyaar wuladiy duw takwak sanak bas sididiy. ");
INSERT INTO mle_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pitawa Jon birim vidik, di birakik bas sidibir bir kwasa jaav kwiybirkik dikik. ");
INSERT INTO mle_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bir dim vikuw, Pita ata wadid, “Min anak av!” ");
INSERT INTO mle_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Di birakik ata vivikaan rad. Diki mawulaar kitawa wukid, “Wunak kwasa jaav kwatiya-kibira way,” wakuw. ");
INSERT INTO mle_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita dikik ata wadid, “Wunaam saan maa ri. Aw niki jaav kwatiya-kituwadimin. Jisas Krais, Nasarit tipa kid, diki apaam watuwadimin, min rapin, tiytiyaan ada!” ");
INSERT INTO mle_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita diki mava tabaam kaykitikuw, kirapitakadik, jayib nak adi duw kwaramin apawa maan ap ata tibir. ");
INSERT INTO mle_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Rapin tikuw, manir ata tiytiyaan tibagwud. Di birakiwa God dikidi wiyaar wulaad. Tiytiyaan salin warin daan kwurtaay, di nimadib waad, “God di mwiya viyakitad. Wunak sipwutiyid!” ");
INSERT INTO mle_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ababa duw taakw vidaad tiytiyaan titaay, Godak wayapiy sidikikib. ");
INSERT INTO mle_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Day vikuw, ata wukidiy tayir di Viyakita Wiyig tilil tamiyaam rikwaad duw takwak bas sikir sanak. Day lakwukuw di bwu yara tad, day ata pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pitawa Jonaam maka tabaam kaykitidik, ababa duw taakw gipikuw, yaan vagaluwdiy dayak Soloman Diki Varanda am. Day abab pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita dayaam vikuw, wadidiy, “Yisrayil jaka tipa kidiy duw, agwak gwur pitaan warnadiygwur ki javik? Gwur agwa javik anak vivikaan tinadiygwur? Gwur wukigwura an anabir apaar ki jaav kwurta? Ay, an mwiya viyakita duw tikuw, ki jaav kwurta? Atawa akis tikwanaad. Jisas diki apaam kidi duw kita tiytiyaan tinaad. ");
INSERT INTO mle_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","“Aparam, Aysak, Jakap, nyanadiy nuwukadiy waraga duwawa dayadi God ki jaav kwurdil dikidi yawiy duw, Jisas, mwiya nimaadad gwurak simakak. Jisas gwur dikidiy mama nibak dayadiy tabaam takagwurid. Paylat di Jisasaam wapak. Aw gwur maa wagwurid Paylatak Jisasaam wapadikik. ");
INSERT INTO mle_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“Kidi maa wagwuridi duw, di mwiyir tinadi duw, viyakitad. Aw gwur maa wakuw Jisasak, gwur Paylatak bas sigwurid di duwaam viyasipadi duw wapadikik. ");
INSERT INTO mle_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","“Aw gwur mawul kwiydi duwaam bwutaay viyasipagwurid. Di kiyakuw ridik, God ata kirapitakadid. Kirapitakakuw, a jaav ata vitil. ");
INSERT INTO mle_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Jisas di diki apaar kidi duw di sipwutiy-daad. Gwur kidi duw bwu lakwugwuraad. Kidi duw Jisasak wukijibiran tidalik, alik kita yara kwanaad gwuradiy milaam abab. ");
INSERT INTO mle_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Gwalugwa duw, wun lakwu-nadiwun gwur gwuradiy sapakwa nyanugwawa Jisasaam kupwaraap kwurgwura, gwur mwiyir maa lakwun ti. ");
INSERT INTO mle_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","“Mwiya tayir God diki maaj wasapwiydiy duw diki maaj wadaal God dikidi Tasakwudidi Duw diki sipaar nima kagil yikina. Atawalik, adiy maaj maykaar wakwudiy. ");
INSERT INTO mle_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","“Gwur alik wukikuw gwuradiy valik, bwan akwiy. Gwuradiy mawul warapiykuw, God gwuradiy vaal yibwiy-kidadiy. Atawa tikuw, God diki ap gwurak kwiykuw, di ginyir Jisas, dikidi Tasakwudidi Duw wayakidik, dakinaad gwurak. ");
INSERT INTO mle_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“Kita di adawur tipaam kwanaad. Di Godak kavin kwanaad. Taay God ababa jaav kwula javadika kwurkidadiy. Jisas ata dakinaad. Mwiya tayir God dikidiy maaj wasapwiydiy mwiyir tidiy duw wadiy a javik. ");
INSERT INTO mle_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Mawsis ki maaj wadil: ‘Yitaypika Duw, gwuradi God, di wayaki-didiwun. Atawa nikidi duw, diki maaj wasapwiydi duw, ginyir wayaki-kidaad gwurak. Di gwuradi tipa kidi duw tikinaad. Gwurak abab wasapwiy-kidadiy maaj awuk. ");
INSERT INTO mle_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Day diki maaj wak maarkidana, aw adiy duw taakw nyidib kajakuw, God dayaam viyakwusi-kidadiy. Nuwuk dikidiy gwalugwa duw tikinadiy.’ ");
INSERT INTO mle_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“God diki maaj wasapwiydiy duw Samuwil-awa day diki kwukir abab wadiy kidiy kwabanadiy nyak. ");
INSERT INTO mle_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Gwur adiy duw dayadiy warag-adiygwur. God aban takadidiy gwuradiy waragak, aw adiy jaav gwuradiy-adiy nakamwiyib. Di Aparamak wadid, ‘Wun sukwasukw kwurkinadiwun ababa kupwaam tikinadiy duwak minadi gwalugw daya danik.’ ");
INSERT INTO mle_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“God alik dikidi Yawiy Duw tasakwukuw, di wayakidid taay gwurak sukwasukw kwurdikik. Di gwurak sugwiyaan kwurkinaad gwur bwan gwuradiy valik kwiygwurkik.” ");
INSERT INTO mle_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pitawa Jon duw takwak kip maaj waan tibir, nuwukadiy pris awa God dikid wiy vay sawdiy duw dayadi sapakwa nyinwa, nuwukadiy adiy bapa Juw Satuwsiy-awa, day birakik yadiy. ");
INSERT INTO mle_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bir duw takwak kalivabiridiy Jisas kiyakuw ridik, God kirapitakadid. Alik ababa duw taakw kiyakidana, atawa God kirapitaka-kidadiy wakuw. Adiy yadiy birakik duw wariya kwudiy wadiy Pitawa Jonak a majik. ");
INSERT INTO mle_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Day birim kalakwukuw, kalabus ir kwusawula-dabir. Giraab kwusik tal. Alik kalabus im kwusawuladaak, ribir. Yaakiya, sir ganib kwusikinabir. ");
INSERT INTO mle_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aw duw taakw samasamadiy biraki maaj wukikuw, Jisasak wukijibir tidiy. Jisasak wukijibir tidiy duw aka 5000 tidiy. ");
INSERT INTO mle_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sira pik Juw dayadiy sapakwa nyanugwawa gaba maja wiy sapakwa nyanugwawa God diki lo kalivadiy duwawa Jiruwsalimaam vagaluwdiy. ");
INSERT INTO mle_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Day vagaluwdiy yitaypika pris Anas, Kayapas, Jon, Aliksada, nuwukadiy Anas dikidiy gwalugwa duwawa. ");
INSERT INTO mle_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pitawa Jon bir nyidi nyidim tibir, van ridabir. Day ata bas sidabir birakik, “Bir siki apaam kwurbiril ki jaav? Sikidi saam kwurbiril ki jaav?” ");
INSERT INTO mle_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","10","God dikidi Mawul Pitaam bwutaay kapwud. Pita ata wadidiy, “Duw taakw dayadiy sapakwa nyanugw, gaba maja sapakwa nyanugw, li gwur anak bas sigwura kidi maan kupwaraap tilik sipwutiyin tinadi duwak aw ata ata an yara mwugiytid, gwur awuk. Yisrayil duw taakw ab abab wukikwadiy kidi duw kilim mwiyir tinaad Jisas Krais Nasarit tipa kid, diki apaar. Kidi Jisas tayir gwur maap tidi miyaam katagwurid. Aw God di kirapitakadid, kawaam kwadik. ");
INSERT INTO mle_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“God diki maaj Jisasak wana: ‘Adi kabaak tayir gwur wiy kwurnadiy duw maa wagwura dikik, kita kabaka giliy dikidi taay bapa kabaak di adi nimadi maan kabaak-ad.’ ");
INSERT INTO mle_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Jisas didika sugwiyaan kwurkwaad nyanak. Aw nikidi duw maa. God bwu tasakwudil adiy duw taakw day yara kwakwak, Jisasak bas sikwadiy a javik.” ");
INSERT INTO mle_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Vagaluwdiy duw day vidabir Pitawa Jon bir maa yaag. Bir dayak nimadib wabir. Day wukidiy bir kipa duwabir, tayir bir skul im maa ti. Aw day wukidiy tayir bir yin yaan tibagwubir Jisasawa. ");
INSERT INTO mle_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Day vidaad adi tayir maan kupwaraap tidi duw di bwu yara tad. Di Pitawa Jon birwa tad. Aw day maaj maa wu. ");
INSERT INTO mle_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Day, “Kawaar maay,” wadaak, wakwubir. Wakwukuw, maaj awarwa awarwa bwuladiy. ");
INSERT INTO mle_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Day dayaam bas sidiy, “Nyan kibir duwaam agwa jaav kwurkidiyan? Ababa Jiruwsalimaam kwanadiy duw taakw bwutaay lakwudana kibir duw ki nima jaav bwu kwurbiril. Nyan akw si maa. ");
INSERT INTO mle_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","“Kipa duw taakw wukik-dana ki jaav, alik kibir duw watipinaak nuwukadiy duw takwak Jisasak wawak.” ");
INSERT INTO mle_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Day gaam sidaak, bir sibinin yabir. Sibinin yakuw, day birakik watipidabir, “Bir nuwukadiyik maaj waan kalivaan kwurway Jisasak,” waan. ");
INSERT INTO mle_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","20","Aw Pitawa Jon ata wabiridiy, “Li an God diki maaj wapakita aw gwura maaj kwurkwurik, God yaakiya wakinaad anak, ay? Gwur wukigwura agwa maaj lakwukida? An maaj yipaakw maa. An maaj jaaw wasapwiy-kinabiran ababa javik vitidiy javiwa wukitidiy jaav.” ");
INSERT INTO mle_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Adiy Kaunsil day ata nima maaja wadaak birakik, day ata wapadabir. Day kupwaraap kwurik kwurdabir birim. Aw day maa rav. Ababa duw taakw rakarak tidiy Godak di adi maan kupwaraap tidi duw kirapitaka-dilik tikuw. ");
INSERT INTO mle_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kidi duw God dim bwutaay sipwutiydid dikidiy nabiy duwamiy vitiy kakildidiy. ");
INSERT INTO mle_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bir wapakuw, yibir birakidiy kapa nyanugwak. Dayak Kaunsil daya maaj abab wabiridiy. ");
INSERT INTO mle_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Biraki maaj day wukikuw, nakamwiyib Godak wadaad, “Yitaypika Duw, min adawur tip yitakaan, kidi kupw yitakaan solwara ab, abab dayaam kwanadiy jaav yitakaminidiy. ");
INSERT INTO mle_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","“Mwiya tayir minadi Mawul, nyanadi warag, minadi yawiy duw Davit diki mawulaar wulakuw, di ki maaj wadil: ‘Agwa javik nuwukadiy tipa kidiy duw wariya kwudiy wanadiy? Agwa javik nyana tipa kidiy duw dayadiy mawul niki jaav niki jaav kwurik wakuw, aw maa rav? ");
INSERT INTO mle_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Niki tip niki tip dayadiy yitaypika duwawa sapakwa nyanugwawa vagaluwkuw, day Godawa dikidi Tasakwudidi Duwaam wariyak?’ ");
INSERT INTO mle_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ki maaj bwu maykaar wakwuna. Aw Yiratawa Pantiyas Paylatawa, Yisrayil tipa kidiywa, nuwukadiy tipa kidiywa ki tipaam vagaluwdiy. Vagaluwkuw, day kupwaraap kwurik minadi Viyakita Yawiy Duw, minadi Tasakwu-minidi Duw Jisasak. ");
INSERT INTO mle_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","“Tayir waminilik min mina wamin, day adiy jaav kwurdadiy. ");
INSERT INTO mle_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Yitaypika Duw, daya wariya kwudiy wukikuw, sugwiyaan akwur nyanak. Nyan alik mina maaj nimadib wakibana, yaag maa. ");
INSERT INTO mle_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","“Minaki ap nyanak kwatiyamin, giviyib kwurkinadiy duw nyan sipwutiy-kibanadiy. Adiy mina nimadiy yawiy ab kwurkibanadiy minadi Viyakita Yawiy Duw Jisas dikidi saam.” ");
INSERT INTO mle_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ki maaj wakuw, dayadi kwadadi wiy yitay yataay tad. God dikidi Mawul dayadiy mawulaam wulaan wapwurukwukuw, day abab ata God diki maaj nimadib wasapwiydaal. Day maa yaag. ");
INSERT INTO mle_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ababa Jisasak wukijibir tidiy duw taakw day mawul nak tidiy. Duw nak maa wu, “Wunadiy javadiy wunadika.” Ababa jaav dayadiy-adiy. ");
INSERT INTO mle_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","God diki ap Jisas dikidiy wayakididiy duwak kwiydik, nuwukadiy duw taakw wukidaal God Yitaypika Duw Jisas kirapitakadid. God dayak sukwasukw kwurid. ");
INSERT INTO mle_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Dayaam duw nakab saal maa yi. Sikadad kupw tad, wiy tad, day yapiykuw, saan kwurkuw, Jisas dikidiy wayakididiy duwak kwiydadiy. Day ata adiy saan niki jaav niki jaav ti maardiy duwak am san kwiydadiy. ");
INSERT INTO mle_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Liyvay bapa duw nak, Saypiris tipa kid, dikidi si Jasip, Jisas dikidiy wayakididiy duw sikiydaad Banapas. Maaw maaj “Sugwiyaan kwurdi nyanad.” ");
INSERT INTO mle_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Di diki kupw yapiykuw, saan kwurkuw, Jisas dikidiy wayakididiy duwak kwiydidiy niki jaav niki jaav ti maardiy duwak kwiydakik. ");
INSERT INTO mle_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Aw nikidi duw, dikid si Ananayas, diki taakw liki si Sapayra. Diki niki kupw yapiykuw, saan kwurdidiy. ");
INSERT INTO mle_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nuwukadiy saan di di kwurdidiy. Nuwuk Jisas dikidiy wayakididiy duwak kwiydidiy niki jaav niki jaav ti maardiy duwak kwiydakik. Di dayak wadidiy, “Kupw yapiytuwadiy saan, abab, Godak kwiytuwadiy.” Diki taakw yaakiya waal diki kwurdil suwalik. ");
INSERT INTO mle_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita ata wadid, “Ananayas, agwa javik min yaakiya wamin, Satan mina mawulaam kapwudik, di mwugiydik, min suwaal kwurmina God dikidi Mawulak kidiy sanak? Agwa javik nuwuk min mina kwurminadiy? ");
INSERT INTO mle_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","“Tayir min minaki kupw aal min minakila. Duw mina kupw yapiykuw, min saan kwurkuw, adiy saan ab min minadiy-adiy. Agwa javik min mawul warna ki suwaal kwurik? Min duwak maa, Godak suwaal kwurminaad!” ");
INSERT INTO mle_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananayas ki maaj wukikuw, di vakirkuw, kiyaad. Abab adi jaav wukikuw, samasam yagadiy. ");
INSERT INTO mle_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Badiy duw rapikuw, wapwiy kwurkuw, diki amwiyim jibirkuw, day yatakuw, kwurin karaykuw, kawamiyaam takadaad. ");
INSERT INTO mle_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ginyir aua mugwul yidaak, diki taakw ata wulaal. Li maa wak adi javik. ");
INSERT INTO mle_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita likik ata waad, “Wunak aw. Nyinadi duw ki nyanak kwiydil saan ki kupwak miyawa kwurdil saan?” Li ata walid, “Ayiy, aka, miyawa.” ");
INSERT INTO mle_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita alik wadil, “Agwa javik Yitaypika Duw dikidi Mawulak atawa kwurbirbir ki jaav wukiwukik? Awuk! Adiy duw nyinadi duw kawamiyaam takakuw, yanadiy. Nyinabab aka yataan karay-kidananyin.” ");
INSERT INTO mle_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jayib nak li diki manwa vakirkuw, kiyaal. Badiy duw wulaan vikuw, bwutaay kiyana wakuw, day yatakuw, kwurin karaykuw, likidi duw manwa kawamiyaam takadaal. ");
INSERT INTO mle_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ababa Kristen duw taakw, nuwukadiy ab, day adi jaav wukikuw, samasam yagadiy. ");
INSERT INTO mle_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jisas dikidiy wayakididiy duw, duw taakw daya nyidim God diki mawulaam ridiy nimadiy niki yawiy niki yawiy adiy kwurdadiy. Ababa Jisasak wukijibir tidiy duw taakw Salaman diki varanda am vagaluwdiy. ");
INSERT INTO mle_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ababa kipa duw taakw wadiy, “Day viyakita duw taakw-adiy,” wakuw. Aw day yagadiy, dayawa yaan vagaluw-vagaluwuk. ");
INSERT INTO mle_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aw samasamadiy, duw ab taakw ab, Jisasak wukijibir tikuw, day Kristen bapaar wuladiy. ");
INSERT INTO mle_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Day dayadiy giviyib kwurdiy duw taakw yabir yataan karaydadiy. Alim wapwiyim takadadiy aw mwiyir Pita tiytiyaan tidik, diki laagw dayaam daan kwalik, day viyakit tidakikik. ");
INSERT INTO mle_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Samasam Jiruwsalim walibab ridiy tipa kidiy duw taakw day dayadiy giviyib kwurdiy duw taakw, nuwukadiy wudib dayadiy mawulaar wuladadiy duw taakw ab yataan kwurin karaydiy Jisas dikidiy wayakididiy duwak day ata sipwutiydakik. ");
INSERT INTO mle_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aw yitaypika pris awa, diwa kwadiy duwawa, adiy Jiruwsalimaam kwadiy Satuwsiy bapa duw, dayadiy mawul maa wadiy Jisas dikidiy wayakididiy duwak. ");
INSERT INTO mle_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Day ata dayaam kalakwukuw, kalabus im kwusawuladaak, ridiy. ");
INSERT INTO mle_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","A gaan God diki maaj kardadi duw kalabus a wiyig kajatakadik, di kwurin kalakwu-didiy kawaar. ");
INSERT INTO mle_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Di ata wadidiy, “Gwur maay God dikidi wiyaar. God dikidi wiyaar wulakuw, ki maaj awasapwiy duw takwak, day yara kwakwadiy Jisasak wukijibir tikuw.” ");
INSERT INTO mle_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Day diki majib wukikuw, aw ganbab God dikidi wiyaar wulakuw, duw takwak kalivadadiy. Yitaypika pris awa diwa kwadiy duw yadaak, day ababa Kaunsil duwawa Yisrayil sapakwa nyanugwak day yaan vagaruwdakik gaam sidiy. Yaan vagaluwkuw, day maaj wadaak, yala kalabus im ridiy duw yadakikik dayak. ");
INSERT INTO mle_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Adiy plisman kalabus ir yikuw, day Jisas dikidiy wayakididiy duw maa vi. Day sibinin yikuw, Kaunsilak maaj wadiy. ");
INSERT INTO mle_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nyan kalabus im wulakuw, nyan vibana abab wiyig kirkir nanadiy. Ababa van tinadiy duw day wiyig walibab tinadiy. Aw nyan wiyig kajatakakuw, nyan vibana duw yala wiyaam maa kwu.” ");
INSERT INTO mle_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","God dikidi wiy vay sawdiy duw dayadi sapakwa nyinwa, abab sapakwa nyanugw pris wukikuw, day samasam wukidiy a javik. Day dayaam bas sidiy, “Adiy duw akim?” ");
INSERT INTO mle_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Duw nak ata wulakuw, dayak ata wadidiy, “Awuk! Adiy kalabus im kwusawula-gwurdiy duw day aka God dikidi wiyaam kwanadiy. Day duw takwak kalivanadiy.” ");
INSERT INTO mle_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Vay sawdiy duwawa dayadi sapakwa nyinwa yikuw, day Jisas dikidiy wayakididiy duw kwurin kariyadadiy. Day dayaam maa viy. Aw day duw takwak yagadiy, “Nyanaam viyak-danadiyan,” wakuw. ");
INSERT INTO mle_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Day kwurin kariyakuw, Kaunsil daya nyidim alim tidiy. Yitaypika Pris bas sididiy, “Nyan gwurak nimadib wabadiygwur, ‘Gwur maaj wasapwiyway adiy duw takwak Jisasak.’ Gwur maa wakuw nyana majik, gwura maaj ababa Jiruwsalimaam kwanadiy duw takwak kaliva-gwuradiy. Gwur dayak wagwura, ‘Adiy Kaunsil duw Jisasaam viyasipadaad.’” ");
INSERT INTO mle_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita nuwukadiy Jisas dikidiy wayakidiy duwawa dayak ata wadadiy, “Nyan God diki majib wukin tikwanadiyan, duw maa. ");
INSERT INTO mle_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","“Gwur wagwur, day Jisasaam maap tidi miyaam katadaad. Di kiyakuw ridik, nyanadiy warag dayadi God ata kirapitakadid. ");
INSERT INTO mle_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","“God dim kirapitakakuw, adawur tipaar kawardid. God Jisasaam kawarkuw, diki mava tabaam takadik, rinaad. God ata tasakwudid di duw taakw dayadi Yitaypika Duw tidakikik. Li Yisrayil duw taakw dayadiy valik wukikuw, God tasakwudid di sugwiyaan kwurkidadiy dayak, aw di dayadiy vaal yibwiydikik. ");
INSERT INTO mle_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","“Nyan, God dikidi Mawulawa, nyan kidiy jaav vibadiy. God di dikidi Mawul kip kwiyda diki majib wukin tikwanadiy duw takwak.” ");
INSERT INTO mle_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Adiy Kaunsil duw a maaj wukikuw, mawul samasam wardiy dayaam viyasipak. ");
INSERT INTO mle_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","35","Parasiy nak, dikidi si Gamaliyil, ata rapid. Di God diki lo kalivayi-kwaad. Ababa duw taakw wadiy di viyakita duw tad. Di rapikuw, wadidiy, “Kidiy duw kwurin akaraakw.” Wakuw, di Kaunsil duwak ata wadidiy, “Gwur Yisrayil duw, gwur yarakara wukin tikuw, taay awuk. ");
INSERT INTO mle_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","“Tayir Tiyuwtas rapikuw, ‘Wun ap samasam tinadi duw-adiwun,’ wakuw, duw duwamiyir duwamiyir (400) diki kwukib yidiy. Aw gavman dim viyasipadaak, dikidiy duw tabwudiy. Aw diki yawiy aka bwu kwusil. ");
INSERT INTO mle_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Ginyir, gavman duw takwaam nasidadiy nyaam, nikidi duw, Galiliy tipa kid Juwtas ata rapid. Dibab rapikuw, nuwukadiy duw diki kwukib ata yidiy. Di kiyadik, dikidiy duw ab tabwudiy. ");
INSERT INTO mle_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Atampik kita wun watuwa gwurak, gwur kupwaraap kwurway kidiy duwak. Aw li dayadiy yawiy day dayadiy yawiyadika, aal kwusikina. ");
INSERT INTO mle_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","“Aw li dayadiy yawiy God dikidiy-adiy, gwur maa rav ki yawiy ab mwugiygwur kwusi-likik. Atawa kwurkigwura, Godaam viyakigwuraad!” ");
INSERT INTO mle_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Day diki majib wukikuw, gaam sidiy Jisas dikidiy wayakididiy duwak day sibinin yadakikik dayak. Sibinin yadaak, dayaam viyakuw, wadadiy, “Gwur watikwa duw takwak Jisasak.” Day ata wapadadiy. ");
INSERT INTO mle_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kaunsilaam wapakuw, day rakarak tidiy God yaakiya wadilik kupwarapa jaav dayaam yadakikik Jisas diki danik tikuw. ");
INSERT INTO mle_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ababa nyi, God dikidi wiyaam, nuwukadiy duw taakw dayadiy wiyaam, day duw takwak kalivadadiy. Day wasapwiydadiy Jisas God dikid Tasakwudidi Duw tad. ");
INSERT INTO mle_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A nyaam, Jisas dikidiy bapa duw taakw samasam tikuw, Grik kwudiy wadiy Juw day Yibiruw kwudiy wadiy Juwak wariya kwudiy wadiy. Ababa nyi day sanawa kikipatawa kwiydadiy niki jaav niki jaav ti maardiy duw takwak. Adiy Grik kwudiy wadiy Juw day wadiy, “Nyanadiy taakw, tawtakw kwanadiy, day kwurdadiy jaav aywa maa.” ");
INSERT INTO mle_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jisas dikidiy tabatiy maan vitiy wayakididiy duw alik ababa Jisas dikidiy bapa duwak gaam sidiy day vagaruwdakik. Day vagaluwkuw, dayak wadadiy, “Nyan God diki maaj kaliva-kwanadiyan. Aw ki yawiy wapakuw saan yawiy kwurkwur, aal kupwaraapa. ");
INSERT INTO mle_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","“Gwalugwa duw, gwur duw abitiy, samasam lakwunadiy duw God dikidi Mawul dayadiy mawulaam wapwurukwu-didiy duw, atasakw. Kidiy duw gwur tasakwu-gwur, nyan ata wakinadiyan day van tidakikik ki yawiyik. ");
INSERT INTO mle_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","“Nyan nyana kwurkibana yawiy nyanyi God diki maaj duw takwak kalivakidiyan beten wa.” ");
INSERT INTO mle_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ababa vagaluwdiy duw rakarak tidiy daya majik. Kidiy duw day ata tasakwudadiy. Stivin, di samasam wukijibir tad Jisasak. Aw God dikidi Mawul diki mawulaam wapwurukwud. Pilip, Parakaras, Nikana, Timan, Paminas, Nikalas. Aw Nikalas di Antiyak tipa kidi duwad. Tayir di Juw dayadiy sukw kwurdidiy. ");
INSERT INTO mle_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kidiy duw day Jisas dikidiy wayakididiy duwak kwurin karaydadiy. Karaykuw, Godak beten in napakuw, dayadiy taab dayaam ata takadadiy day dayadiy yawiyik yarakara kwurdakik. ");
INSERT INTO mle_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Duw taakw samasam God diki maaj wukidaal. Jiruwsalimaam duw taakw samasamadiy Jisasak wukijibir tidiy. Adiy pris ab samasamadiy Jisasak wukijibir tidiy. ");
INSERT INTO mle_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God sukwasukw kwurdik Stivinaam, ap dikik kwiydik, di God dikidiy mawulaam ridiy nimadiy yawiy, duw taakw daya nyidim kwurdidiy. ");
INSERT INTO mle_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aw nuwukadiy duw maa wadiy dikik. Adiy duw day Sayriyniy-awa Aliksadiriya, abir tipa kidiy Juw, gaba maja wiy nakaam vagaluwdiy. A gaba maja wiy liki si Friman. Kidiy duw Silisiya-wa Asiya tipa kidiy Juwawa day maaj warjuwdiy Stivin wukin. ");
INSERT INTO mle_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","God dikidi Mawul Stivinak viyakita maaj kwiydik, aw day dim kakil-kakil maa rav a majik. ");
INSERT INTO mle_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","A javik wukikuw, day ata saan kwiydadiy nuwukadiy duwak day wadakikik, “Nyan wukibaal kidi duw di kupwarapa sapis jikid Mawsisawa Godak.” ");
INSERT INTO mle_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Daya maaj wukikuw, duw takwawa, sapakwa nyanugwawa, God diki lo kalivadiy duwawa dayadiy mawul wardiy. Day Stivinak yakuw, dim kalakwukuw, Kaunsilak kwurin karaydaad. ");
INSERT INTO mle_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","14","Kwurin karaykuw, nuwukadiy duw day ata kwurin karaydadiy suwaal takadakik Stivinak. Day wadiy, “Nyan wukibaal kidi duw nyanyi kupwarapa sapis jikid God dikidi wiyawa Mawsis diki lo wak. Nyan ki wadil maaj wukibaal, ‘Kidi Jisas, Nasarit tipa kid, God dikidi wiy takwukinaad. Di Mawsis nyanak kalivadadiy sukw warapiy-kidadiy.’” ");
INSERT INTO mle_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ababa Kaunsil duw wukidiy Stivin diki maak vikuw, God diki maaj kaldadi duw maka pikad. ");
INSERT INTO mle_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yitaypika pris Stivinak bas sidid, “Ki maaj, mwiya maaja?” ");
INSERT INTO mle_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Stivin ata wadidiy, “Gwalugwa duw, sapakwa nyanugwa, wuna maaj awuk! Mwiya tayir nyanadi warag, Aparam, Misapatamiya tamiyaam kwaad. Di Aran tipaar maa nibway yi. Aw viyakita ap tinadi God dikik wakwudik, ata wadid, ‘Min minadiy gwalugwa duw takwawa mina tipawa wapaan niki simakakituwa tipaar maay.’ ");
INSERT INTO mle_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Aw Aparam Kaltiya tip wapakuw, Aranaar ata yikuw, alim kwaad. Aparam dikidi asaay kiyadik, God wakuw, kidi nyana kwabanadi tipaar ata yaad. ");
INSERT INTO mle_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“God Aparamak kupw maa nibway kway. Kwasa mwiyib maa. Aw di aban takadil Aparamak. Di wadid, ‘Ginyir kidi kupw, miyawa minak minadi gwalugwuk kwiykituwaad.’ Aw a nyi Aparam nyan maa ti. ");
INSERT INTO mle_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Niki maaj ab Aparamak wadid, ‘Ginyir minadiy gwalugwa duw taakw nuwukadiy duw daya tipaam kwakinadiy. Alim kipa kipa yawiy kwurkinadiy kalabus im kwanadiy duw kitik. Dayak van tikidiy duw kupwaraap kwurkidiy dayaam nabiy duwamiyir duwamiyir (400). ");
INSERT INTO mle_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","‘Aw adiy dayak van tikidiy duw takwaam kupwaraap kwurkituwadiy. Minadiy gwalugwa duw taakw a tip wapakuw, kidi tipaar sibinin yakuw, kilim gaba maaj sukwukidiy wunak.’ ");
INSERT INTO mle_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Aparamak God aban takadid. A maaj wukin tikuw, Aparamawa dikidiy gwalugwa duw day duwa nyanugw kaam sukwudadiy dayadiy sipaam kipa duw takwak simakadakik day God dikidiy-adiy. Aparam diki taakw Aysak-aam sapwiylik, nyi abamugwul yidaak, Aparam kaam sukwudid diki sipaam. Atawa Aysak Jakapaam ata kaam sukwudid. Ginyir Jakap dikidiy duwa nyanugw tabatiy maan vitiy, nyanadiy warag, kaam sukwudidiy. ");
INSERT INTO mle_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Nyanadiy warag kupwarapa mawul wardiy dayadi nyamwus Jasipak. Niki tipa duw dikidiy mamugwuk saan kwiykuw, Jasip day kwurdaad. Day kwurin karaydaad Yijip jaka tipaar kipa kipa yawiy kwurdikik. Aw God diwa nyanyi tad. Para di Yijip dayadi yitaypika duwad tad. Jasip diki nyidim tikuw, God sugwiyaan kwurid Jasipak. Alik Para yaakiya wadid Jasipak. Di wukidil Jasip lakwudi duwad. Wukikuw, di Jasip tasakwudid dikidi ginyir duw ababa Yijip jaka tipa kidiy duw takwak van tidikikik diki wiyaam yawiy kwurdiy duw takwak ab. ");
INSERT INTO mle_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ginyir Yijipawa Kanan, abir tipaam kwadiy duw taakw kamnagwuk kupwaraap tidiy. Nyanadiy warag kikipaat kwurik kwurdaal aw day maa rav. ");
INSERT INTO mle_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","“Aw Jakap di wukidil kikipaat Yijipaam ridiy, nyanadiy warag alir taay wayakidik, yidiy. ");
INSERT INTO mle_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Ginyir jaab vitiy yidaak, Jasip dayak wadidiy, ‘Wun Jasip-adiwun.’ Para Jasip dikidiy nyamwusawa, mamugwawa, asaywa ata wukididiy. ");
INSERT INTO mle_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Jasip maaj wayakidik dikidi asayik, dikidi bapa duw taakw Yijipaar ata yidiy. Duw taakw duwamiy mugwul sap tabatiy maan tabab (75) yidiy. ");
INSERT INTO mle_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Jakap Yijipaar yikuw, ginyir nyanadiy waragawa alim kiyadiy. ");
INSERT INTO mle_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","“Dayadiy pwus Sikim-aar kwurin karaykuw, alim dipwu kabakim takadadiy. A tipaam tayir dayadiy gwalugw dayadiy pwus takadadiy. A dipwu kabaak tayir Aparam yapiydil Amar dikidi bapa duwak sanaar. ");
INSERT INTO mle_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tayir God Aparamak aban takadil day a tip wapakidana. A nyi maykaar wakwun walibab tilik, nyanadiy Yijipaam kwadiy warag adiy samasamadiy. ");
INSERT INTO mle_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","“Jasip kiyadik, ginyir nikidi yitaypika duw Yijipaam van tad. Di Jasipaam maa laakw. ");
INSERT INTO mle_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","“Di suwaal takakuw, jawjaay kwurid nyanadiy waragak. Di dayak maa wayakid. Di lo dayak kwiydidiy day dayadiy kwasadiy nyanugw kawaam takakwadiy kiyadakik. ");
INSERT INTO mle_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“A nyaam Mawsis diki amaay dim sapwiylid. Di wav yidi kwasa nyanad. Amaay asaay dikik van tibiridiy bap mugwul biraki wiyaam. ");
INSERT INTO mle_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","“Day mala bayibim ata takadaad. Takakuw, Para diki takwa nyan dim vikuw, kwurin karaylid liki wiyaar. Karaykuw, ‘Wunadi nyanad,’ waal. ");
INSERT INTO mle_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","“Day Mawsisaam Yijip dayadiy sukw kalivadaak, di niki maaj niki maaj lakwud. Di nimadiy yawiy kwurdidiy. ");
INSERT INTO mle_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mawsis dikidiy nabiy duwamiy vitiy tidaak, di dikidiy bapa duwak, Yisrayil, dayak vikir. ");
INSERT INTO mle_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","“Yikuw, di vidid Yijip duw nak Yisrayil duwaam jawjaay kwurdid. Vikuw, di ata sugwiyaan kwurik adi Yisrayil duwak. Sugwiyaan kwurkuw, di adi Yijip duwaam ata viyasipadid. ");
INSERT INTO mle_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","“Mawsis diki mawulaam wukidil, ‘Wunadiy bapa duw wukikidana, “Mawsis yaan sugwiyaan kwurkinaad nyanak. Aw God wadik, Mawsis nyanak sugwiyaan kwurdik, nyan kidiy Yijip jaka tipa kidiyim kakilkuw, ki tip wapakibana.” uuuu’ Aw day atawa maa wukin ti. ");
INSERT INTO mle_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Sira pik Mawsis vidibir Yisrayil duw vitiy bir kap viyabir. Aw di birim takatipidibir. Takatipikuw, di wadibir, ‘Bir gwalugwa duw-abirbir. Agwa javik bir bira jawjaay kwurnabirbir?’ ");
INSERT INTO mle_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","28","“Taay wariyadi duw Mawsisaam wapataykuw, ata wadid, ‘Sikadadaad minaam tasakwud nyanak van timinkikik jas kitik? Min wunaam viyasipak nal min Yijip jaka tipa kidi duwaam viyasipaminil pik?’ ");
INSERT INTO mle_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Diki maaj wukikuw, Mawsis ata tabwud. Yijip wapakuw, Mitiyan tamiyaam kwaad niki tipa kidi duw kaytik. Alim taakw kirakuw, li duwa nyidiy vitiy sapwiylibir. ");
INSERT INTO mle_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nabiy duwamiy vitiy yidaak, kipa tamiy nibwuk si Saynay walibab ril tamiy, alim God diki maaj kardadi duw maykaar wakwud Mawsisak yiy yanil kwasa miyaam. ");
INSERT INTO mle_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","“Mawsis dim vikuw, pitaan wardik, a miyaar yad vikir. Aw di Yitaypika Duw maajal wukidil. ");
INSERT INTO mle_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Di wadid, ‘Wun minadiy warag dayadi God-adiwun. Aparam, Aysak, Jakap dayadi God-adiwun.’ Diki maaj wukikuw, Mawsis samasam yagaad. Dikim maa vi. ");
INSERT INTO mle_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“God dikik ata wadid, ‘Min ki timina kupw watipituwal, kapaba kupwa. Alik minabir su wa maan akaypwutiy. ");
INSERT INTO mle_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","‘Wun vituwil adiy Yijip jaka tipa kidiy duw day jawjaay kwurdiy wunadi bapa duw takwak. Bwutaay wukituwadiy dayadiy gir. Alik kita wun kupwaar daan dayaam nyigilik. Min arap ya. Min Yijipaar wayaki-kituwadimin.’ ");
INSERT INTO mle_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Kidi Mawsis tayir Yisrayil duw taakw maa wadiy dikik. Day bas sidaad, ‘Sikadadaad minaam tasakwud nyanak van timinkikik jas kitik?’ Kidi Mawsis God wayakidid dayak van tan sugwiyaan kwurdikik. Adi vididi yiy yanil kwasa miyaam God diki maaj kardadi duw sugwiyaan kwurid dikik. ");
INSERT INTO mle_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","“Day Yijipaam kwakuw, Mawsis adiy duw taakw ata kwurin karaydidiy. Yijipawa Nyikiy Nyikiy wakwadana solwara wa kipa tamiyaam God diki mawulaam ridiy nimadiy yawiy Mawsis kwurdidiy nabiy duwamiy vitiy. ");
INSERT INTO mle_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Kidi Mawsis Yisrayil duw takwak wadidiy, ‘God wayaki-didiwun gwurak. Atawa ginyir God wadik, duw nak gwura gwalugwa duw diki maaj wasapwiy-kinadi duw tikinaad gwurak.’ ");
INSERT INTO mle_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Yisrayil duw taakw kipa tamiyaam vagaruwdaak, Mawsis dayawa tad. Nibwuk si Saynay warkuw, God diki maaj kardadi duw maaj dikik wadid nyanak kwiydikik. Adiy maaj sugwiyaan kwurdadiyan nyan yara kwabakikik. ");
INSERT INTO mle_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nyanadiy warag maa wakuw dikik, day Yijipaar sibinin yikir. ");
INSERT INTO mle_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Day dikid mwaam Aranak wadaad, ‘Mawsis akim kwanaad? Nyan maa laakw. Min kayik asukw nyanak. Nyan tiytiyaan tikibana, adiy kayik taay yikidiy.’ ");
INSERT INTO mle_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Aran dayak van tidik, day ata kayik sukwudaad badiy bulmakau kitik. Kayik sukwukuw, kipaat kwiydaad dikik di dayak sukwasukw kwurdikik. Day rakarak tikuw daya yawiyik, day kipaat jabim takakuw, baagw tidiy. ");
INSERT INTO mle_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“God di dayak bwan ata kwiydidiy. Bap, nyi, tugwiy, kwungar, adiy javik God mayaakw kwaad day gaba maaj sukwu-sukwuk. God diki lapa nyigaam, diki maaj wasapwiydiy duw daya sukwudaal lapa nyigaam ki maaj rina: ‘Yisrayil duw taakw gwur kipa tamiyaam kwakuw, gwur bulmakau, sipsip, meme viyasipakuw, adiy jaav gwur wunak maa kwatay. ");
INSERT INTO mle_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Adi suwala god Molok, diki kwasa bay wiy gwur yatataay karaygwuril. Adi suwala god Kipan diki tugwiy kayik sukwugwuril. Abir sukwugwurbir kayikak gaba maaj sukwugwuril. Atawa kwurgwur, wun wayakikuw, yin Bapilan sitaay alim rikinadiygwur.’ ");
INSERT INTO mle_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“God Mawsisak simakadid diki wapwiy wiy kwurdakik. God diki majib Mawsis wadik, day kwurdaad. Nyanadiy warag kipa tamiyaam kwakuw, God duw takwak maaj wadidiy wapwiy wiy yala wiyaam. ");
INSERT INTO mle_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","“Ginyir Jasuwa, wariyak van tidi yitaypika duw, di van tidik, day kidi kupwaam kwadiy duwawa wariyadiy. Adiy duw God viyayakikuw, nyanadiy warag kilim kwadiy. God dikidi wapwiy wiy dayawa karaydaad. Adi wiy kilim kwaad yin Davit diki kwadil sikir. ");
INSERT INTO mle_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“God dikik rakarak tad. Tikuw, Davit dikik bas sidid wiy kwurik Jakap dikidi Godak. ");
INSERT INTO mle_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","“Aw di maa. Dikidi nyan Salaman adi wiy kwurdid Godak. ");
INSERT INTO mle_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Aw mwiya nimadi God duw dayadiy kwurdadiy wiyaam akis rikwanaad. God diki maaj wasapwiydi duw ki maaj wadid: ");
INSERT INTO mle_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Adawur tip wunadi tikir kitik, Aw kupw wunabir maan wapaan rituwa. Agwa wiyad kwurgwuraad wunak? Akim wun yaap rikidiwun? ");
INSERT INTO mle_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wun wuna ababa jaav yitakatuwdiy. Ay maa?’” ");
INSERT INTO mle_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stivin atawa wakuw, adiy Kaunsil duwak ata wadidiy, “Gwur gwuradiy maka apaam kabaak rinadiygwur. Gwuradiy mawul haiden duw dayadiy mawul kitik tinadiygwur. Dayabab maa wadiy God dikidi Mawulak. ");
INSERT INTO mle_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","“Tayir ababa God dikidiy maaj wasapwiydiy duwaam gwuradiy warag jawjaay kwurdadiy. Tayir day, ‘Ginyir God dikidi Viyakita Yawiy Duw yakinaad,’ wadaak, day viyasipa-dadiy. Aw gwur God dikidi Viyakita Yawiy Duw, Jisas, dikidiy mama nibak kwiygwurid day dim viyasipa-dakik. ");
INSERT INTO mle_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","“God diki maaj kardadiy duw God diki lo kwiydaad gwur gwurak. Aw gwur lo kwurkuw, aw gwur a lo-aam sargwuril.” ");
INSERT INTO mle_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Adiy Kaunsil duw Stivin diki maaj wukikuw, dayadiy mawul wardaak, dayadiy wuk vatikirikiy-dadiy. ");
INSERT INTO mle_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aw Stivin God dikidi Mawul diki mawulaam kapwudik, adawur tipaar ata kituw vad. Kituw vikuw, di God diki apawa gilabadiy vidibir. God diki mava tabaam Jisas rasin tad. ");
INSERT INTO mle_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stivin ata waad, “Av! Wun vituwaad adawur tip kajatakaan tinaad. Duw taakw dayadi Mwaam God diki mava tabaam rasin tinaad!” ");
INSERT INTO mle_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Day diki maaj wukikuw, waan takatipin napakuw, gaam sikuw, day ata gipidiy dikik. ");
INSERT INTO mle_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Day dim kaykitikuw, kwurin kalakwudaad. Mala tipawa day alim yakiyakikuw, kabaak dikik kwalyaki-dadiy dim viyasipak. Adiy Stivin diki majik maa wadiy duw dayadiy alakwur kwadiy wapwiy kaypwutiykuw, badiy duw, dikidi si Sol, diki manwa walibab takadadiy. ");
INSERT INTO mle_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Day Stivinaam kabaak kwalyakidaak, di Jisasak gaam sidid, “Yitaypika Duw Jisas, wunadi mawul akwur!” ");
INSERT INTO mle_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Di vakirkuw, kwatiyir sikuw, nimadib gaam sad, “Yitaypika Duw, ki valik min dayaam jawjaay kwurway!” Wakuw, di ata kiyaad. ");
INSERT INTO mle_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sol yaakiya waad day Stivinaam viyasipa-dakik. Nuwukadiy Godak wukijibir tidiy duw Stivin dikidi pwus kawamiyaam takadaad. Day nimadib giradiy dikik. Stivinaam viyadaal nyaam adiy duw bas adiy Jiruwsalimaam kwadiy Kristen duw takwaam jawjaay kwurdadiy. Ababa Kristen tabwudiy Juwtiyawa Samariya abir tamiyaar. Jisas dikidiy wayakididiy duwadika Jiruwsalimaam kwadiy. ");
INSERT INTO mle_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Aw Sol ababa Kristen duw takwaam jawjaay kwurdidiy. Di ababa wiyaar wulakuw, Kristen duw taakw sitakirakuw, kalakwukuw, kalabus ir kwusawula-didiy. ");
INSERT INTO mle_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ababa Kristen niki tip niki tipaar tabwukuw, day Jisas diki viyakita maaj wasapwiydaal. ");
INSERT INTO mle_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip Samariya nimadi tipaar yikuw, a tipa kidiy duw takwak wasapwiydidiy God dikidi Tasakwudidi Duwak. ");
INSERT INTO mle_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ababa duw taakw diki maaj yara wukidaal. Dikidiy God diki mawulaam ridiy kwurdidiy yawiy vidadiy. ");
INSERT INTO mle_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Aw di wadik, duw taakw dayadiy mawulaam ridiy wudib nimadib gaam sitaay, pwutiydiy. Nuwukadiy dayadiy maan taab kiyadiy, nuwukadiy kupwaraap tidiy, pirigidiy, adiy duw taakw di sipwutiy-didiy. ");
INSERT INTO mle_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Di atawa kwurdilik tikuw, alik a tipa kidiy duw taakw rakarak tidiy. ");
INSERT INTO mle_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","A tipaam duw nak, dikidi si Sayman, kwaad. Di yanuw kwuryikwadi duw-ad. Tayir ababa duw taakw diki yawiy vikuw, pitaan wardiy. Di wadidiy, “Wun sapakwa nyan-adiwun,” wakuw. ");
INSERT INTO mle_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ababa duw taakw, sapakwa nyanugwawa, kipa nyanugwawa dikik sukwasukw yara van tidaad. Day wadiy, “Di God diki ap si Nima Ap kwurnaad.” ");
INSERT INTO mle_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Day dikidiy yawiy nyi samasam vikuw, day wukidiy dikik. ");
INSERT INTO mle_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aw Pilip wasapwiydidiy Jisasak. Di kalivadidiy atata ginyir God duw takwak van tikinaad. Day diki maaj wukijibir tikuw, di baptais kwiydidiy adiy duw takwaam. ");
INSERT INTO mle_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sayman, dibab Pilip diki maaj wukijibir tad. Di baptais kwurkuw, Pilip diki kwukir yad. Di Pilip dikidiy nimadiy kwurdidiy yawiy vikuw, di ata pitaan warid. ");
INSERT INTO mle_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jiruwsalimaam kwadiy Jisas dikidiy wayakididiy duw day wukikuw adiy Samariya tipa kidiy duw taakw God diki maaj kwurdaal, day Pitawa Jon wayakidabir dayak. ");
INSERT INTO mle_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bir yakuw, Godak bas sidaad di dikidi Mawul kwiydikik adiy Jisasak wukijibir tidiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Adiy duw taakw baptais bwu kwurdiy Yitaypika Duw, Jisas, dikidi saam. God dikidi Mawul day maa nibway kwar. ");
INSERT INTO mle_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pitawa Jon birakidiy taab dayaam takakuw, God dikidi Mawul dayadiy mawulaar wulaad. ");
INSERT INTO mle_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Sayman vidil Pitawa Jon birakidiy taab duw takwaam takakuw, day God dikidi Mawul ata kwurdaad. Di saan birakik kwurin karaykuw, wadibir, “Kidi ap wunak akwutay. Wun yapiyik. Aw adi ap wun kwurkuw, nuwukadiy duw takwaam taab takaaw day God dikidi Mawul kwurkidanaad.” ");
INSERT INTO mle_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Aw Pita dikik ata waad, “Ka! Min wukimina min God dikidi kip kwiydidi Mawul yapiykiminaad sanaar, ay? Atawa wukiminalik, min minadiy sanawa kupwaraap tikimina. ");
INSERT INTO mle_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","“Aal kwurta yawiy min kwurkwur maa rav. God bwu wukida mina mawul kupwaraap tina. ");
INSERT INTO mle_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","“Mina mawul warapiykuw, ki wamina javik Yitaypika Duwak bas as, aw di mina vaal yibwiydikik. ");
INSERT INTO mle_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","“Mina mawulak wukinabiran. Min anak nyigiy sinadimin. Min vaal tabaam tinadimin.” ");
INSERT INTO mle_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sayman ata Pitawa Jonak wadibir, “Bir Godak bas as wunak aw adiy waminadiy jaav wunaam yakik-nadiy.” ");
INSERT INTO mle_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bir mawulaam ridiy majawa Yitaypika Duw diki majawa duw takwak wakuw, bir ata sibinin yibir Jiruwsalimaar. Bir sibinin yikuw, Samariyawa ridiy samasama tipaam Jisas diki maaj wasapwiy-biridiy. ");
INSERT INTO mle_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","God diki maaj kardadi duw Pilipak wadid, “Min rapikuw, kwulapwukuw, avakiy Jiruwsalim wapakuw, yin Gasa adi kwanadi yabir.” Adi yaab kipa tamiyaam kwaad. ");
INSERT INTO mle_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Pilip rapikuw, ata yad. Adi yabir duw nak yitaay tad diki tipaar. Di Yitiyapiya jaka tipa kidi sapakwa nyan tad. A tipak van til taakw liki si Kandis, likidiy sanawa niki jaav niki javik di van tad. Di Jiruwsalimaar wulakuw, Godak gaba maaj sukwud. Gaba maaj sukwukuw, di ata diki tipaar sibinin yad kupwaam ril valasaay. Yin ritaay, God diki maaj wasapwiydi duw si Aysaya, diki God diki lapa nyigaam sukwudil maaj vidil yitaay tikuw. ");
INSERT INTO mle_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","God dikidi Mawul Pilipak wadid, “Min yin walibab ada dikiwa.” ");
INSERT INTO mle_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilip ata gipid adi duwak. Gipikuw, yin walibab tikuw, di wukidil di Aysaya diki sukwudil maaj vitaay wadil. Pilip wukikuw, ata bas sidid, “Ki vitaay waminal maaj li lakwumina?” ");
INSERT INTO mle_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Di Pilipak wadid, “Ata ata ki maaj lakwu-kituwa? Li duw nak maaw maaj wunak wu maarkida, aw wun maa rav.” Di ata Pilipak wadid di dikiwa kupwa valaam wuladikik. ");
INSERT INTO mle_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Diki vidil maaj kika: “Sipsip kitik day kwurin karaydaad viyasipadakik. Di badiy sipsip duw diki yuwiy vildaal kitik di kwudiy maa wu. Aw di maaj maa. ");
INSERT INTO mle_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Day dim jawjaay kwurdaad. Aw day suwaal kot ridaad dikik. Di kwadil, kwadiy duw taakw dayadiy kupwarapa kwurdadiy yawiy duw nasinas maa rav. Day dim viyasipadaak, aw di ki kupwaam maa kwu.” ");
INSERT INTO mle_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Adi sapakwa nyan Pilipak bas sidid, “Wunak aw. Sikadadaad Aysaya wadid? Di dikik? Ay nikidi duwak?” ");
INSERT INTO mle_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pilip ata kalivadid adi duwak. Diki vidil maaj liki maaw taay kalivakuw, viyakita maaj Jisasak ata wadid. ");
INSERT INTO mle_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bir yabir yikuw, bir guw ril tamiyaar wakwubir. Wakwukuw, adi sapakwa nyan Pilipak wadid, “Guw kika rina. Min kita baptais wunak kwiy-kiminadiwun. Ay maa?” ");
INSERT INTO mle_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilip bas sidid, “Min Jisasak wukijibir tinadimin mina mawul ab, miyawa?” Di Pilipak, “Ayiy. Wun wukijibir tinadiwun Jisas Krais di God dikidi Nyanad tinaad.” Wakuw, Pilip yaakiya wadid. ");
INSERT INTO mle_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Diki kupwaam gipil valaam val kwurda duwak wadid di kupwa val kawiydikik. Kawiydik, di Pilipawa guwaar dakuw, Pilip baptais kwiydid. ");
INSERT INTO mle_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bir guw wapakuw, warkuw, God dikidi Mawul Pilipaam niki tipaar kwurin karaydid. Adi sapakwa nyan ginyir Pilipaam maa vi. Di rakarak tikuw, diki tipaar ata yad. ");
INSERT INTO mle_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilip di wakwud Astat tipaam. Wakwukuw, niki tip niki tipaam Jisas diki viyakita maaj wasapwiydil. Ginyir di yikuw, Sisariyaar alir wakwud. ");
INSERT INTO mle_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Sol di wayayikwaad, “Wun adiy Jisasak wukijibir tidiy duw takwaam viyasipa-kituwadiy.” Wakuw, di yitaypika pris ak yad lapa nyigak bas sikir ababa Damaskas tipaam kwadiy Juw dayadiy gaba maja wiyaam vagaluwdiy duwak. Adiy lapa nyigaam maaj wadadiy di Jisas dikidi yabir yidiy duw taakw di sitakirakuw, kwurin karaydikik Jiruwsalimaar. ");
INSERT INTO mle_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol Damaskas-aar yidik, a tipaam walibab tidik, nimadi lait daad wulik kitik walibab. ");
INSERT INTO mle_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Di kupwaam vakirkuw, di maaj wukidil, “Sol, Sol, agwa javik min wunak jawjaay kwurnadimin?” ");
INSERT INTO mle_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","6","Sol ata bas sidid, “Yitaypika Duw, min si?” Wadik, “Wun Jisas-adiwun. Min wunak jawjaay kwurmina. Min rapikuw, Damaskas-aar maay. Tipaar wulakuw, alim duw nak minak wakinaad agwa javadiy min kwur-kiminadiy.” ");
INSERT INTO mle_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Solawa yidiy duw day pitaan warkuw, maaj maa. Aw day majadika wukikuw, day duwaam maa vi. ");
INSERT INTO mle_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol rapikuw, dikibir mil kitay kitiy vidil. Aw dikibir mil tipibir. Alik day diki tabaam kaykitikuw, kwurin karaydaad Damaskasaar. ");
INSERT INTO mle_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nyi mugwul dikibir mil kip tibir. Di kipaat guw maa ki. ");
INSERT INTO mle_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskasaam Jisasak wukijibir tidi duw nak kwaad. Dikidi si Ananayas. Di yigin vidil. A yiginim Yitaypika Duw Jisas dikik wadid, “Ananayas.” Di Jisasak wadid, “Yitaypika Duw, kilim kwanadiwun.” ");
INSERT INTO mle_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jisas dikik ata wadid, “Min rapikuw, adi yabir maay. Adi yaab dikidi si Sapasapap yinadi yaabad. Alim Juwtas diki wiyaam min bas as Tasas tipa kidi duwak dikidi si Sol. Di beten in kwanaad. ");
INSERT INTO mle_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","“Yiginim duw nak vidid. Adi duw dikidi si Ananayas, dikik yakuw, taab dim takadibir di vidikikik maa dikibir mil.” ");
INSERT INTO mle_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananayas Jisasak wadid, “Yitaypika Duw, duw samasamadiy adi duwak wadadiwun. Di jawjaay kwurdidiy minadiy Jiruwsalimaam kwanadiy duw takwaam. ");
INSERT INTO mle_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","“Aw kita, sapakwa nyanugw pris yaakiya wadaak, di Damaskasaar yanaad ababa Kristen duw takwaam kalakwuk.” ");
INSERT INTO mle_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","16","Jisas dikik ata wadid, “Min maay! Wun adi duw tasakwu-tuwaad di yawiy kwurdikik wunak. Di Yisrayil duw takwak, nuwukadiy tipa kidiy duw takwak, niki tip niki tipa yitaypika duwak, adiyik wakidadiy wunak. Aw wun simaka-kituwaad duw taakw jawjaay dim kwurkidana wuna danik tikuw.” ");
INSERT INTO mle_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananayas Solak ata yad. Wiyaar wulakuw, dikibir taab Solaam takadibir. Di Solak wadid, “Gwalugwa duw Sol, Yitaypika Duw kidi yabim viminadi Jisas wayaki-didiwun minak. Kita minabir mil abirka vikiminabir. God dikidi Mawul mina mawulaam wapwurukwu-kinaad.” ");
INSERT INTO mle_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wakuw, jayib ni bwaaw rak kitika jaav dikibir milaam tikuw, vakirbir. Vakirbir, Sol abir mil ata vidibir. Di ata rapikuw, baptais kwurid. ");
INSERT INTO mle_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kikipaat kikuw, ap ata wapwaad. Sol nyi mugwul aliy atawa Damaskasaam kwadiy Jisasak wukijibir tidiy duw takwawa kwadidiy. ");
INSERT INTO mle_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sol Juw dayadiy gaba maja wiyaar wulakuw, duw takwak wasapwiydidiy Jisasak. Di dayak wadidiy, “Jisas di God dikidi Nyan-ad.” ");
INSERT INTO mle_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Abab diki maaj wukikuw, day ata pitaan warkuw, day daya bas sidiy, “Kidi duw Jiruwsalimaam Kristen duw takwaam viyasipadidiy. Ay maa? Aw di kilir yaad adiy Kristen duw taakw kalakwukuw, kwurin karayik Jiruwsalimaar sapakwa nyanugw pris ak. Ay maa?” ");
INSERT INTO mle_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol diki maaj nima maaja. Ababa maaj kwiydidiy dayak. Di simakadidiy Jisas di God dikidi Tasakwudidi Duwad. Ababa Damaskas-aam kwadiy Juw day diki maaj kakil-kakil maa rav. ");
INSERT INTO mle_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Nuwukadiy nyi yidaak, adiy Juw vagaluwdiy. Day Solaam viyasipak. Nyanyi, nyi gaan, day kavin kwadiy dikik ababa kabaka yaripaam tidiy wiyigaam. Nuwukadiy duw Solak wadaad a javik. ");
INSERT INTO mle_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Aw gaan nak Solawa kwadiy duw dim kwurin karaykuw, baniyim takakuw, yaav tuwtakakuw, kabaka yaripaam tipagwusir kwusin dadaad kawaar. ");
INSERT INTO mle_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jiruwsalimaar ata yad. Di nuwukadiy Jisasak wukijibir tidiy duwawa vagaruwuk. Aw day yagakuw dikik, day maa wukin ti di Jisasak wukijibir tad. ");
INSERT INTO mle_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Banapas di sugwiyaan kwurik dikik. Di kwurin karaydid nuwukadiy Jisas dikidiy wayakididiy duwak. Di dayak ata wadidiy Sol yabim Yitaypika Duw Jisasaam vikuw, Jisas dikik maaj ata wadid. Di dayak wadidiy Damaskasaam Sol nimadib duw takwak wasapwiydidiy Jisasak. ");
INSERT INTO mle_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wakuw, day yaakiya wadaad Sol dayawa kwadikikik. Sol Jiruwsalimaam yin yaan tibagwukuw, duw takwak wasapwiydidiy Jisasak. ");
INSERT INTO mle_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Di Grik daya tipa maaj wadiy Juwawa warjuwdidiy. Aw day dim viyasipak. ");
INSERT INTO mle_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Adiy Kristen duw a jaav wukikuw, day Sol kwurin karaydaad Sisariyaar. A tipaar dakuw, Tasasaar ata wayakidaad. ");
INSERT INTO mle_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ababa Juwtiyawa Galiliyawa Samariya tamiyaam kwadiy Kristen duw taakw ata yara kwadiy. Wariyaan ab maa kwar dayaam. Aw duw taakw samasam Jisasak wukijibir tidiy. God dikidi Mawul dayak sugwiyaan kwurkuw, day ata Godak wukin tidiy. ");
INSERT INTO mle_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita niki tip niki tipaar yibagwud. Nyi nak di Lita tipaar ata yad alim kwadiy duw taakw vikir. ");
INSERT INTO mle_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Alim duw nak dikidi si Yiniyas vidid. Dikidiy ap bwan kiyadiy. Nabiy abamugwul di jabim kip rididiy. ");
INSERT INTO mle_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita ata wadid, “Yiniyas, Jisas Krais sipwutiy-kidadimin. Min arap! Rapikuw, minadi baay akwulaapw!” Jayib ni Yiniyas ata rapid. ");
INSERT INTO mle_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ababa Litawa Saran abir tipa kidiy duw taakw a jaav vikuw, day Jisasak wukijibir tidiy. ");
INSERT INTO mle_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Niki tip Japa alim taakw nak, liki si Tapita, kwaal. Li Jisasak wukijibir tal. Grik daya majim liki si Dakas. Nyanyi li viyakita yawiy kwurlidiy. Li sugwiyaan kwurlidiy nuwukadiy saal yidiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A nyaam li giviyib kwurkuw, bwutaay kiyaal. Liki pwus day guwaar jankuw, aluwum apiy kwaal kwasa wiyaam takadaal. ");
INSERT INTO mle_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Japa Lita walibab ril tamiyaam tal. Japaam kwadiy Kristen duw day Pita Litaam kwaad wukikuw, day duw vitiy wayakidabir dikik. Bir dikik ata wabirid, “Min rapikuw, gipin anawa may!” ");
INSERT INTO mle_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Alik tikuw, Pita rapin kwulapwukuw, birwa yad. Dakas liki wiyaar wulakuw, day kwurin kawardaad aluwur maka kwaal kwasa wiyaar. Ababa tawtakw kwadiy taakw Pitawa vagaluwdiy. Day giradiy. Day dikik simakadadiy adiy wapwiy Dakas tipalidiy dayawa kwakuw. ");
INSERT INTO mle_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita wadik, duw taakw kawaar wakwudiy. Wakwukuw, di Godak beten id. Beten kuw, pwusak ata wadil, “Tapita, nyin arap!” Likibir mil ata vikuw, Pitaam vikuw, ata rapin ral. ");
INSERT INTO mle_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita lim kaykitidik liki tabaam, ata rapin tal. Rapikuw, Pita Kristen duw takwawa tawtakw kwadiy takwak gaam sikuw, ata kwiydil dayak. ");
INSERT INTO mle_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ababa Japaam kwadiy duw taakw a jaav wukikuw, samasam Yitaypika Duw Jisasak wukijibir tidiy. ");
INSERT INTO mle_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita nyi samasam Japaam kwadidiy Saymanawa. Sayman di sipa bulmakau yawiy kwurid. ");
INSERT INTO mle_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Duw nak dikidi si Kaniliyas, Sisariya tipaam kwaad. Di Roma gavman dayadi amiy sapakwa nyanad. Di duw duwamiy tabab dayak van tad. Adiy bapa vay sawdiy duw dayadi si “Yitaliy Baap.” ");
INSERT INTO mle_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Di gaba maaj sukwud Godak. Di dikidiy takwawa nyanugwawa Godak wukijibir tidiy. Di Godak beten jibir tad. Adiy saal yidiy Juw dayak sugwiyaan kwurdidiy. ");
INSERT INTO mle_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Giraab nyi mugwul tidik, di yigin vidil. Di vidid God dikidi maaj kardadi duw dikik yakuw. Di Kaniliyasak wadid, “Kaniliyas!” ");
INSERT INTO mle_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kaniliyas dim vikuw, yagaad. Di wadid, “Yitaypika Duw, min agwa jaav kwurik?” God diki maaj kardadi duw dikik ata wadid, “Minadiy beten awa viyakita yawiy nuwukadiy duw takwak God vikuw, mayaakw kwadidiy. Di minak wukinaad. ");
INSERT INTO mle_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","“Min duw awayak Japa tipaar. Alim duw nak, Sayman, dikidi nikidi si Pita, nikidi Saymanawa kwanaad. Adi nikidi Sayman di sipa bulmakau yawiy kwurkwanaad. Diki wiy mala solwara am kwana. Day Sayman Pitaak wakidanaad, dayawa yadikikik minak.” ");
INSERT INTO mle_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Adi God diki maaj kardadi duw a maaj wakuw, ata yad. Kaniliyas ata gaam sad yawiy duw vitiy, vay sawdi duwawa day yadakikik dikik. Adi vay sawdi duw di Godak wukijibir tidi duw tad. Di nyanyi Kaniliyasak yawiy kwurid. ");
INSERT INTO mle_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kaniliyas ababa jaav dayak wakuw, di ata wayakididiy Japaar. ");
INSERT INTO mle_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Sira pik day yaan Japawa walib kwadaak, nyidi nyi tidik, Pita aluwurim kwaal wiyaar beten ik warid. ");
INSERT INTO mle_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Di kaam yasalik tikuw, kikipaat kikir. Day kikipaat sukwulik yidaak, di yigin vidil. ");
INSERT INTO mle_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pita kituw vidil adawur tip kajatakaan tad. Tikuw, nimadi wapwiy, kibiy kitika jaav, kupwaar daad. ");
INSERT INTO mle_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yala wapwiyim niki animal niki animal, niki kabaay niki kabaay, niki wapiy niki wapiy ridiy. ");
INSERT INTO mle_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pita maaj ata wukidil, “Pita, min rapikuw, kidiy jaav viyasipaan ak!” ");
INSERT INTO mle_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Aw Pita ata wadid, “Yitaypika Duw, wun atawa kwar maa. Nyana lo maa wakuw adiy kwiyak, nyan akis kikwanadiyan.” ");
INSERT INTO mle_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Maaj di ata wukidil maa, “Adiy javik God yaakiya wanaad, min dayak maa watikwa kikak.” ");
INSERT INTO mle_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jaab mugwul atawa bir maaj awarwa bwulakuw, adiy jaav adawur tipaar sibinin wardiy. ");
INSERT INTO mle_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita samasam wukid a vidil yigin liki mawuk. Wukikuw, Kaniliyas dikidiy wayakididiy duw Sayman diki wiy sitakirakuw, day alada mala wiyigawa tidiy. ");
INSERT INTO mle_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Day gaam san bas san kwurdiy, “Duw nak, dikidi si Sayman Pita, ki wiyaam kwanaad?” ");
INSERT INTO mle_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","20","Pita a yigin liki maaw wukin tidik, God dikidi Mawul dikik ata wadid, “Awuk! Duw mugwul kilim tinadiy. Day minak yanadiy. Min rapikuw, adiyid dayak. Min dayawa yiyak yagatikwa. Aw wun wuna wayaki-tuwadiy minak.” ");
INSERT INTO mle_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita dakuw, dayak ata wadidiy, “Adi kwaki-gwuradi duw, wun kika. Agwa javik gwur wunak yanadiygwurik?” ");
INSERT INTO mle_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Day ata wadaad, “Duw nak, dikidi si Kaniliyas, di vay sawdiy duw duwamiy tababak van tinadi duwad, di wayakidik, nyan yanadiyan minak. Di viyakita duwad. Di Godak wukijibir tikwanaad. Ababa Juw day wakwanadiy di viyakita duwad. God diki maaj kardadi duw nak dikik wadid di minak bas sikida min diki wiyaar yiminkikik. Aw di mina maaj wukik.” ");
INSERT INTO mle_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pita dayak wadidiy day diwa kwadakikik gaan. Sira pik dikidiy jaav kwulapwudik, di dayawa yad. Nuwukadiy Japaam kwadiy Kristen duw dayawa yidiy. ");
INSERT INTO mle_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Muwa pik day Sisariyaar wakwudiy. Alim Kaniliyasawa, dikidiy gwalugwa duwawa, kapa duwawa, kavin kwadiy Pitaak. Tayir Kaniliyas dayak wadidiy diki wiyaam vagaruwdakik. ");
INSERT INTO mle_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita wiyaar wuladik, Kaniliyas dikik yakuw, diki manwa vakirkuw, wadid, “Min wunadi yitaypika duw-adimin.” ");
INSERT INTO mle_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aw Pita dim kirapitakakuw, wadid, “Min arap! Wunabab duw-adiwun.” ");
INSERT INTO mle_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita Kaniliyas-awa ata maaj bwulaan bwulaan wiyaar wulabir. Wulakuw, Pita adiy samasama vagaluwdiy duw vididiy. ");
INSERT INTO mle_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Di dayak ata wadidiy, “Gwur abab wukinadiygwur Juw dayadiy lo watipidiy Juw nuwukadiy tipa kidiy duwawa vagaruw-vagaruwuk, ay dayadiy wiyaar wula-wulak. God wunak wadidiwun, ‘Agwa javik yaakiya watuwadiy, min maa watikwa adiy javik!’ ");
INSERT INTO mle_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","“Alik Kaniliyas maaj wayakidik wunak, wun maaj maa. Alik yanadiwun. Agwa javik maaj wayakimina wunak? Wun wukik.” ");
INSERT INTO mle_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kaniliyas ata waad, “Tayir nyi aliya yawaam nyi kita mugwulaam tidil pik, wuna wiyaam beten-adiwun. Jayib ni duw nak wunawa tad. Dikidiy wapwiy kariyadiy lait kitik. ");
INSERT INTO mle_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Maykaar wakwukuw, wunak ata waad, ‘Kaniliyas, God mina beten bwu wukida. Minadiy viyakita yawiy nuwukadiy duw takwak wukin tinaad. ");
INSERT INTO mle_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","“‘Min maaj awayak Japaar duw nikik. Dikibir si Sayman Pita. Di nikidi Sayman diki wiyaam kwanaad. Adi nikidi Sayman sipa bulmakau yawiy kwurkwanaad. Di mala solwara am kwanaad.’ ");
INSERT INTO mle_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Diki maaj wukikuw, jayib ni wun maaj wayakituwil minak. Min nyanak yamina, aal viyakita. Kita nyan abab kilim kwanadiyan God diki milaam. Aw God minak kwiydil maaj nyanak awasapwiy.” ");
INSERT INTO mle_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita dayak ata wadidiy, “Kita bwu wukinadiwun ababa duw taakw rivriv tikwanadiy Godak. ");
INSERT INTO mle_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","“Ababa jaka tipa kidiy duw taakw day Godak wukikuw, viyakita yawiy kwurkuw, adiy duwak God mayaakw kwakidadiy. ");
INSERT INTO mle_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","“Diki Yisrayil duw takwak wayakidil maaj bwu wukigwura. Ki viyakita maaj wana Jisas Krais ababa duw taakw dayadi Yitaypika Duwad. Alik day mawul nak tikinadiy Godawa. ");
INSERT INTO mle_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","“Tayir Jon baptais kwur maaj wadik, ki maaj bas maykaar wakwul Galiliy tamiyaam. Aw kita, gwur wukigwura ababa Juwtiya tamiyaam kwanadiy duw taakw ki maaj bwu wukidaal. Gwur wukigwura ki maaj Jisas Nasarit tipa kidik wadil. God dim tasakwudik, dikidi Mawulawa ap ata kwiydid. God dikiwa tikuw, di yin yaan tibagwud viyakita yawiy kwurik. Adiy Satan jawjaay kwurdidiy duw taakw di sipwutiy-didiy. ");
INSERT INTO mle_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Jisas kwurdidiy yawiy Jiruwsalimaam nuwukadiy Juw dayadiy tipawa nyan vikuw, wabanadiygwur. Day dim miyaam katakuw, viyasipadaad. ");
INSERT INTO mle_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","“Kiyakuw, nyi mugwul yidaak, God dim kirapitakakuw, simakadid nyanak. Ababa duw takwak maa. Nyanadiy duw taakw God tasakwu-didiydika. Di rapidik, nyan dikiwa kikipaat, guw kidiyan. ");
INSERT INTO mle_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“God wadidiyan nyan duw takwak wasapwiy-bakik di Jisas bwu tasakwudid di jas tikinaad ababa duw takwak, nuwukadiy kiyadiywa, nuwukadiy kip kwanadiywa. ");
INSERT INTO mle_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","“Tayir God diki maaj wasapwiydiy duw abab dikidiy kwurkidadiy yawiy maaj wadiy. Day wadiy ababa duw taakw dikik wukijibir tikuw, diki apaam dayadiy vaal yibwiy-kidadiy.” ");
INSERT INTO mle_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita maaj waan tidik, God dikidi Mawul adiy maaj wukidiy duw takwaam daad. ");
INSERT INTO mle_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Adiy Pitawa yadiy Juwa Kristen vikuw, pitaan wardiy God dikidi kip kwiydidi Mawul nuwukadiy tipa kidiy duw takwaam ab kwiydid. ");
INSERT INTO mle_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Day wukidaal adiy niki maaj niki maaj bwuladiy. “God diki ap nimaala. Di mwiya viyakitaad,” wakuw wadiy. Pita ata wadidiy, “Kidiy duw taakw God dikidi Mawul bwu kwurdadiy nyana pik. Aw li God atawa kwurdil, sikadadaad baptais kwur guw watipi-kinaad kidiy duw takwak, ay?” ");
INSERT INTO mle_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Di ata yaakiya waad day baptais kwur-kwurik Jisas dikidi saam. Baptais kwurkuw, adiy duw taakw bas sidaad di dayawa titak nuwukadiy nyi. ");
INSERT INTO mle_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","God dikidiy wayakididiy duwawa, nuwukadiy Juwtiya tamiyaam kwadiy Kristen duwawa, day abab wukidiy nuwukadiy jaka tipa kidiy duw taakw God diki maaj kwurdaal. ");
INSERT INTO mle_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Aw Pita Jiruwsalimaar wardik, duw baap nak, day wadiy, “Ababa Kristen duw day dayadiy sipaam kaam sukwukwadiy.” Day Pitaak wariya kwudiy wadaad. ");
INSERT INTO mle_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Day wadaad, “Min niki jaka tipa kidi duw diki wiyaam kwadimin. Min dayawa kikipaat kidimin. Agwa javik atawa kwurdimin? Adiy duw day dayadiy sipaam kaam maa sakw!” ");
INSERT INTO mle_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Pita ata yarik yididiy ababa javik. “Japa tipaam Godak beten kuw, wun yigin vituwil. Wun nimadi wapwiy kitika jaav vituwid. Adi nimadi wapwiy, kibiy kitika jaav, wunak dakuw, walibab tad. ");
INSERT INTO mle_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","“Wun yala wapwiy vikuw, wun vituwdiy yakwiya dadiy animal awa, sapiy tidiy animal awa, kabaywa, wapiywa. ");
INSERT INTO mle_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“Wun maaj ata wukituwil, ‘Pita, min rapikuw, kidiy jaav viyasipaan ak!’ ");
INSERT INTO mle_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Aw wun ata watuwid, ‘Yitaypika Duw, wun atawa kwar maa. Nyana lo maa wakuw adiy kwiyak, nyan akis kikwanadiyan.’ ");
INSERT INTO mle_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Maaj ata wukituwil maa, ‘Adiy javik God yaakiya wanaad, min dayak maa watikwa kikak.’ ");
INSERT INTO mle_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Jaab mugwul an atawa maaj awarwa bwulakuw, adi jaav adawur tipaar sibinin warid. ");
INSERT INTO mle_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Yigin vikuw, jayib ni Kaniliyas wayakididiy duw mugwul Sisariya tip wapakuw, ata wakwudiy wun kwatuwil wiyaar. ");
INSERT INTO mle_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","“God dikidi Mawul wunak ata waad, ‘Min dayak daan dayawa yiyak yagatikwa.’ Kidiy gwalugwa duw abwun wunawa Sisariya tipaar yidiy. Yikuw, nyan abab Kaniliyas diki wiyaar wuladiyan. ");
INSERT INTO mle_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","14","“Kaniliyas nyanak ata yarik yididiyan di vidid God diki maaj kardadi duw nak diki wiyaam tad. Vikuw, Kaniliyasak wadid, ‘Min maaj awayak Japa tipaar duw nikik, dikidi si Sayman Pita. Di yakuw, maaj minak wakida. A majib wukikuw, min kupwaraap ti maa. Mina wiyaam kwanadiy duw taakw nyanugw, dayabab yara kwakinadiy.’ ");
INSERT INTO mle_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Bas a maaj wakuw, God dikidi Mawul dayak daad tayir nyanak dadil pik. ");
INSERT INTO mle_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","“Yitaypika Duw diki maaj ata wukituwil. Tayir di wadidiyan, ‘Jon guwawa baptais kwiyid. Aw ginyir gwur baptais kwurkigwura God dikidi Mawulaar.’ ");
INSERT INTO mle_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","“Tayir nyan wukijibir tidiyan Yitaypika Duw, Jisas Kraisak, God di dikidi Mawul kip kwiydid nyanak. Atampik kita di dikidi Mawul niki jaka tipa kidiy duw takwak bwu kwiydid. Aw li di atawa kwurdil, ata ata Godak wun watipik-tuwaad?” ");
INSERT INTO mle_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Day diki maaj wukikuw, ginyir day maaj maa. Aw day rakarak tidiy Godak. Day wadiy, “God yaakiya waad niki jaka tipa kidiy duw taakw ab day dayadiy valik wukikuw, yara kwakinadiy.” ");
INSERT INTO mle_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Adiy Juw Stivinaam viyasipadaak, day ata jawjaay kwurdiy ababa Kristen duw takwaam. Adiy Kristen ata tabwudiy nuwukadiy jaka tipaar. Nuwukadiy sika tamiyaar tabwudiy, Panisiya, Saypiris, Sayriyniy. Alim Juw duw takwadikanik day God diki maaj wasapwiy-dadiy. ");
INSERT INTO mle_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Aw nuwukadiy Saypiris-awa Sayriyniy, abir tipa kidiy Kristen Antiyak tipaar yikuw, day niki jaka tipa kidiy duw takwak wasapwiy-dadiy Viyakita Maaj Yitaypika Duw Jisasak. ");
INSERT INTO mle_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yitaypika Duw di diki ap dayak kwiykuw, day wasapwiydaak, duw taakw samasamadiy wukijibir tidiy dikik. ");
INSERT INTO mle_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jiruwsalimaam kwadiy Kristen day a jaav wukikuw, day Banapas wayakidaad Antiyakaar. ");
INSERT INTO mle_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Antiyakaar wakwukuw, di vidil God dayak sukwasukw kwurdidiy. Di rakarak tikuw, di dayak wadidiy day wukijibir tidakikik dayadiy mawul ab miyawa, day Jisasak wukimar maa. ");
INSERT INTO mle_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banapas di viyakita duw tad. God dikidi Mawul diki mawulaam wapwurukwud. Di nimadib Godak wukijibir tad. Alik duw taakw samasamadiy wukijibir tidiy Yitaypika Duwak. ");
INSERT INTO mle_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","26","Banapas ata Tasas tipaar yad Solaam sitakirak. Di Sol sitakirakuw, di kwurin karaydid Antiyakaar. Nabiy nak a tipa kidiy Kristen samasam vagaluwdaak, bir kaliva-biridiy. A tipaam nuwukadiy duw taakw taay Jisasak wukijibir tidiy duw taakw sikiydadiy Kristen wakuw. ");
INSERT INTO mle_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A sikir nuwukadiy God diki maaj wasapwiydiy duw Jiruwsalim wapakuw, Antiyakaar dadiy. ");
INSERT INTO mle_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Duw nak, dikid si Akapas, rapikuw, God dikidi Mawul dikik simakakuw, di dayak wasapwiydidiy ginyir kikipaat ri maa ababa tipaam. Ginyir, Kilatiyas Rom daya yitaypika duw tidik, Akapas wasapwiydil jaav maykaar wakwul. ");
INSERT INTO mle_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ababa Kristen duw taakw day dayadiy mawul warkuw, dayadiy saan am sikuw, adiy saan vagaruwdadiy Juwtiya tamiyaam kwadiy Kristenak sugwiyaan kwurik. ");
INSERT INTO mle_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Saan vagaruwkuw, adiy saan day Banapasawa Solak kwiydadiy Juwtiya Kristen dayadiy sapakwa nyanugwak kwiybirkik. ");
INSERT INTO mle_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","A nyaam Juw dayadi yitaypika duw, Yirat jawjaay kwurdidiy Kristen duw takwaam. ");
INSERT INTO mle_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Di wadik, day Jon dikidi mwaam, Jamis, diki abw wariya bagaar viyalupwadaal. Viyalupwadaak, kiyaad. ");
INSERT INTO mle_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yirat wukidil adiy Juw rakarak tidiy a javik, di waad day Pitaam kalakwukuw, kalabus im kwusawula-dakik. A nyaam day Yis Maa Ti Bret bayaki kikipaat kidiy. ");
INSERT INTO mle_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Day Pitaam kalakwukuw, kalabus im kwusawuladaad. Yirat waad baap aliy vay sawdiy duw van tidakikik Pitaak. Niki baap duw aliy, nuwuk alib niki baap duw aliy, nuwuk alib baap duw aliy, nuwuk alib baap duw aliy tidiy. Yirat diki mawul adiy Juw God Wapadidiy Nyi bayaki kikipaat kikuw, di Pita kwurin karaykidaad dayak. ");
INSERT INTO mle_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita kip kwadik kalabus im, ababa Kristen duw taakw Godak apawa bas sidiy diki danik. ");
INSERT INTO mle_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Sira pik Yirat Pitaam kwurin karayik adiy Juw dayadiy mwutamaam kotiy kuw viyasipak. Aw gaan Pita di si kwaad van tibir duw biraki nyidim. Day dikidiy manwa tabaam jidadiy sen aar. Nuwukadiy van tidiy duw kalabusa wiyig walibab tidiy. ");
INSERT INTO mle_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Aw God diki maaj kardadi duw maykaar wakwudik, ata yala kalabus im kariyaad nyi kitik. Di Pitaam wasiyalaam viyadid. Pita jawiyakuw, adi maaj kardadi duw Pitaak wadid, “Min yabiyib arap!” Jayib ni adiy sen day daya raliykuw, ata vakirdiy. ");
INSERT INTO mle_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","God diki maaj kardadi duw ata wadid, “Min sipapuwtuw jikuw, minabir maan akwusuw.” Pita atawa kwurdik, maaj kardadi duw ata wadid, “Minadi wapwiy kwusuwkuw, wunawa may.” ");
INSERT INTO mle_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita diki kwukib yikuw, kawaar yibir. Aw di maa laakw adi maaj kardadi duw mwiyir tad. Diki mawul ata waal, “Yigin vinadiwun.” ");
INSERT INTO mle_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wiyig vitiy tibiril tamiyaam duw walib van tidiy. Abir wiyig wapakuw, bir ain wiyigaar wakwubir. Adi wiyigaar duw kawaar wakwuyi-kwadiy. Wakwutaay, yidiy tipaar. Adi wiyig kap rapwiyaan tad. Tidik, bir kawaar wakwubir. Bir yabir yikuw, jayib ni adi God diki maaj kardadi duw wapadid Pita. ");
INSERT INTO mle_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pita a jaav lakwukuw, ata waad, “Kita aka lakwutuwa Yitaypika Duw di diki maaj kardadi duw wayakidid wunak. Di nyigildidiwun Yirat tabaam rituw. Adiy bapa Juw wunaam jawjaay kwurkwur maa.” ");
INSERT INTO mle_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Atawa lakwukuw, di Jon Mak diki amaay, Maria, liki wiyaar ata yad. Alim duw taakw samasam vagaluwkuw, beten diy Pitaak. ");
INSERT INTO mle_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita wiyigaam viyadik, yawiy taakw liki si Rawta wiyigaar yal. ");
INSERT INTO mle_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Li Pita diki maaj wukikuw, rakarak tal. Nimalib rakarak tilik, li wiyig maa rapwiy. Li nuwukadiyik gipikuw, walidiy, “Pita kawaam tinaad,” wakuw. ");
INSERT INTO mle_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Day liki maaj wukikuw, ata wadaal, “Nyin kwam tinanyin.” Li, “Wuna maaj mwiya maaja,” wakuw, day wadiy, “Aal dikidi kayikad tinaad.” ");
INSERT INTO mle_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Aw Pita wiyigaam viyajibir tad. Day ata wiyig rapwiyakuw, Pitaam vikuw, pitaan wardiy. ");
INSERT INTO mle_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita wiyaar wulakuw, diki taab ata kwusuwdil dayadiy maaj watipik. Di dayak ata waad ata ata di kalabus im rikuw, Yitaypika Duw nyigildid. Wakuw, di ata wadidiy, “Ki jaav Jamisawa nuwukadiy gwalugwa duwak yarik ay.” Di dayaam ata wapakuw, niki tamiyaar yad. ");
INSERT INTO mle_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ganbab adiy van tidiy duw day kwam yina pik tidiy, Pitaam vi maarkuw. ");
INSERT INTO mle_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yirat waad day Pitaak kwakidakik. Aw day Pitaam maa sitakir. Yirat van tidiy duw kalakwukuw, dayak bas sikuw, di waad day abab kiyadakik. Yirat Juwtiya wapakuw, Sisariya tipaar daad alim kwakir. ");
INSERT INTO mle_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Yirat di wariya kwudiy waad Tayawa Saytan tipa kidiy duw takwak. Aw day vagaluwkuw, yadiy Yirataam vikir. Taay day Yirat diki wiyak van tidi duw, dikidi si Bilastas, dikik yidiy. Di yaakiya wadik daya majik, day Yiratak yidiy diki wariya kwudiy kwusilikik. Day dayadiy kikipaat yapiyi-kwadiy Yirat diki tamiyaam alik day diki dayak yidil wariya mawul kwusilikik tikuw bas sidaad. ");
INSERT INTO mle_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nyi nak Yirat tasakwukuw, dikidiy aw kwadiy wapwiy kwusuwtaka-didiy. Yitaypika tikirim daan rikuw, maaj duw takwak kwiydidiy. ");
INSERT INTO mle_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Diki maaj kwusilik, abab gaam sidiy dikik, “Ki maaj duw diki maaj maa, god nak diki maaja!” ");
INSERT INTO mle_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Di rakarak tidik daya majik, di maa wu, “Wun God maa ti.” Atawa tikuw, God diki maaj kardadi duw wayakidik, di Yirataam viyadik, gwaab diki yalaam ran vatadaak, kiyaad. ");
INSERT INTO mle_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Aw duw taakw samasam God diki maaj wukikuw, dikik wukijibir tidiy. ");
INSERT INTO mle_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banapasawa Sol biraki yawiy kwusilik, Jiruwsalimaar ata sibinin yabir. Jon Mak birkiwa yad. ");
INSERT INTO mle_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiyak tipa kidiy Kristen dayadiy nyidim God diki maaj wasapwiydiy duwawa, kalivadiy duwawa tidiy. Dayadiy si, Banapasawa, Simiyan dikidi kipa si Gilasipawa, Luwsiyas Sayriyniy tipa kidawa, Manayin Yirit Antiypas dikidi san duwawa, Solawa. ");
INSERT INTO mle_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","A tipa kidiy Kristen vagaruwkuw, day kikipaat maa ki. Day Godak beten adika tidiy. Tidaak, God dikidi Mawul wadidiy, “Banapas-awa Sol atasakw wuna kwiykituwa yawiyik birakik.” ");
INSERT INTO mle_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Day kikipaat maa ki. Godak beten kuw, dayadiy taab birakim takadabir bir birakidiy yawiyik yarakara kwurbirkik. Ata wayakidaak, yibir. ");
INSERT INTO mle_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","God dikidi Mawul wayakidik, Banapasawa Sol Siluwsiya tipaar dabir. Alim jabir kwurkuw, yin kawiybir solwara am ril ailan im liki si Saypiris. ");
INSERT INTO mle_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saypiris-aam ril tip si Salamis, alim bir Juw dayadiy gaba maja wiyaam God diki maaj wasapwiybiril, Jon Mak sugwiyaan kwurid birakik. ");
INSERT INTO mle_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Day a ailan liki apika malaar yidiy. Alim, tipa si Papwus, alim duw nak sitakira-daad. Adi duw di yanuw lakwudi duwad. Dikidi si BaJisas. Grik daya majim dikidi si Yilimas. Aw di Juw bapa duw tad. Di suwaal kwurid, “Wun God diki maaj wasapwiydi duw-adiwun,” wakuw. ");
INSERT INTO mle_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Saypiris-aam kwadiy duw taakw dayadi yitaypika duw dikidi si Sisiyas Polas. Di niki jaav niki jaav lakwudi duwad. Di Yilimas dikidi kapa duwad. Aw Sisiyas Polas maaj wayakidil Banapas-awa Solak. Di God diki maaj wukik. ");
INSERT INTO mle_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Aw Yilimas maa waad birakik. Di maa waad adi yitaypika duw wukijibir titak Jisasak. ");
INSERT INTO mle_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Sol, day sikiydaad Pol, God dikidi Mawul diki mawulaam kapwudik, adi yanuw kwuryi-kwadi duwaam vikuw, ata wadid, “Min Satan dikidi nyan-adimin. Min maa wamina ababa viyakita javik. Suwaal kwurin kupwarapa jaav mina mawulaam wapwurukwu-nadiy. Nyanyi min God dikidiy yawiyik jawjaay kwurkwanadimin. Agwak? ");
INSERT INTO mle_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","“Aw kita God minaam jawjaay kwurdik, minabir mil tipikinabir. Min nyamil vi maa. Atawadika tikidimin yin nuwukadiy nyaam.” Pol a maaj wadik, jayib ni Yilimas dikibir milaam baw yakuw, ata tipibir. Tipibir, di yin yaan tibagwud duw diki tabaam kaykitikuw, kwurin karaydikik. ");
INSERT INTO mle_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","A jaav vikuw, adi yitaypika duw God diki majik pitaan warkuw, wukijibir tad. ");
INSERT INTO mle_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol nuwukadiy duwawa jabir kwurkuw, Papwus wapakuw, Pabiliya alim ril tipaar yidiy, si Pika. Aw alim Jon Mak dayaam wapakuw, di kap Jiruwsalimaar sibinin yad. ");
INSERT INTO mle_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Polawa Banapas Pika wapakuw, Pasitiyan alim ril tip Antiyak alim tiytiyan tibir. Alim Sapat nyaam Juw daya gaba maja wiyaar wulakuw, daan ribir. ");
INSERT INTO mle_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Gaba maja wiya sapakwa nyanugw Mawsis sukwudil lo-awa God dikidiy maaj wasapwiydiy duw dayadiy sukwudadiy maaj God diki lapa nyigaam vikuw, wadadiy. Wakuw day maaj wayakidaal birakik, “Gwalugwa duw, li bira mawulaam maaj rilik wasapwiyik duw takwak dayadiy mawul ap tidakikik, nyan ki maaj dayak wabirkikik.” ");
INSERT INTO mle_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol rapikuw, taab kwusuwkuw, maaj ata wadidiy, “Gwur Yisrayil jaka tipa kidiy duw, gwur nuwukadiy jaka tipa kidiy Godak wukijibir tinadiy duw, wuna maaj awuk. ");
INSERT INTO mle_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","“Tayir God nyanadiy warag tasakwu-didiy dikidiy tidakikik. Day niki tipa bapa duw takwadiy tidiy Yijip jaka tipaam. Aw God mwugiydik, day ap samasam tidiy. God di dikidi nimadi ap simakakuw, kwurin karaydidiy niki tamiyaar. ");
INSERT INTO mle_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","“Nabiy duwamiy vitiy kipa tamiyaam tan jaal dadiy Godak. Aw di amaay kitik dayak van tad. ");
INSERT INTO mle_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","“Kanan tamiyaam bapa duw taakw abitiy kwusitakadik, di a kupw nyanadiy waragak kwiydidiy. Nabiy 450 (duwamiyir duwamiyir) alim ata ridadiy. ");
INSERT INTO mle_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Alim rikuw, God van tidiy duw ata tasakwudidiy dayaam, yin diki maaj wasapwiydi duw Samyuwil diki sikir. ");
INSERT INTO mle_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“A sikir day Godak bas sidiy day dayadi yitaypika duw di dayak van tidikikik. Bas sidaak, God Bijamin gwalugwa duw, Kiyis dikidi nyan Sol dayak kwiydid dayak van tidikikik nabiy duwamiy vitiy. ");
INSERT INTO mle_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","“Aw God maa wadik Solak, di Davit dayak kwiydid dayadi yitaypika duw tidikikik. God di dayak maaj wadil Davitak, ‘Jisiy dikidi nyan, Davit, di wuna majib wukikinaad. Wun rakarak tinadiwun dikik.’ ");
INSERT INTO mle_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“God aban takadil, ginyir Davit dikidi gwalugwa duw, Jisas, Yisrayil duw taakw nyigil-kidadiy. Ki maaj bwutaay maykaar wakwul. ");
INSERT INTO mle_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Jisas yi maardi nibway, Jon ababa Yisrayil duw takwak wasapwiydidiy day dayadiy bwan kwiykuw dayadiy valik, baptais kwurkwadiy. ");
INSERT INTO mle_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","“Jon diki yawiy ata kwusik kwuril di ata waad, ‘Gwur wukigwura wun agwa duw-adiwun? Gwur duw nikik kavin kwakwanadiygwur. Wun adi duw maa. Awuk! Di wuna kwukir yakinaad, mwiya sapakwa nyanad. Wun kwasaad tinadiwun. Alik wun kidi duw dikidiy jaav yatayat maa rav.’ ");
INSERT INTO mle_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Gwalugwa duw, Aparam dikidiy waraga duw ababa niki jaka tipa kidiy Godak wukijibir tinadiy duw, kidi God nyigil-didiyan maaj nyanak wayakidil. ");
INSERT INTO mle_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","“Jiruwsalimaam kwanadiy duw takwawa, dayadiy sapakwa nyanugwawa, day maa laakw Jisas di dayadi Nyigildi Duw tad. Ababa Sapat nyaam day God dikidiy maaj wasapwiydiy duw dayadiy God diki lapa nyigaam sukwudadiy maaj wukidaal. Aw day adiy maaj dayadiy maaw maaj day maa laakw. Day maa wadaak Jisasak, adiy maaj dayadiy maaw maaj maykaar wakwudiy. ");
INSERT INTO mle_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","“Day maa sitakir Jisasaam viyadadiy vaal. Aw day Paylatak bas sidaad di Jisasaam kip viyasipadikik. ");
INSERT INTO mle_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Day God diki lapa nyigaam walidiy jaav dim kwurkuw, maap tidi miyaam tidik, nikibir duw dikidi pwus kwurkuw, dipwu kabakim takabirid. ");
INSERT INTO mle_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","“Aw God dim kirapitakadid. ");
INSERT INTO mle_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","“Taay diwa Galiliy aw Jiruwsalimaar yidiy duw taakw God Jisasaam kirapitakakuw, day nyi samasam vidaad. Kita adiy duw taakw Yisrayil duw takwak wasapwiydadiy a javik. ");
INSERT INTO mle_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“An kilim kwata God diki viyakita maaj gwurak kwiyik. Adiy jaav tayir God nyanadiy waragak aban takadidiy di ginyir kwurkidadiy, di dikidi nyan Jisas nyanak kwiykuw, bwu kwurdidiy nyanak. Ki sukwudil maaj buk si Sam sapta vitiyaam alim rina: ‘Min wunadi Nyan-adimin. Nibwul wun minadi Asaay tinadiwun.’ ");
INSERT INTO mle_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Nikibir maaj ab God waad Jisas kiyakuw ridik, di kirapitaka-kidaad. Di maa wanaad dikidi pwus pwuk yayik. Taay maaj wana: ‘Adiy viyakita jaav tayir Davitak kwiytuwdiy, adiy minak ab kwiy-kituwadiy.’ ");
INSERT INTO mle_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Niki Sam im rina maaj wana: ‘Min maa wakimina minadi viyakita yawiy duw dikidi pwus pwuk yaykinaad.’ ");
INSERT INTO mle_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Diwa kwadiy duw takwak Davit God diki yawiy kwurdil. Aw di kiyakuw, day dikidi pwus dikidiy waragawa walibab kawaam takadaak, pwuk yayid. ");
INSERT INTO mle_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","“Aw adi nikidi duw, Jisas, kiyakuw ridik, God dim kirapitakadik, dikidi pwus pwuk maa yaay. ");
INSERT INTO mle_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Gwalugwa duw, gwur abab yara awuk. Adi duw gwuradiy vaal yibwiy-kwaad. Adiy duw taakw dikik wukijibir tikuw, di dayadiy vaal abab yibwiy-kidadiy. Mawsis diki lo atawa maa ti. Maa rav. ");
INSERT INTO mle_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","“Gwur alik yarakara ada. Ki God diki maaj wasapwiydi duw wadil jaav gwuraam maykaar wakwuk-na. ");
INSERT INTO mle_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Gwur sapis jikin kwurkwanadiygwur. Ginyir gwur pitaan warkuw, ata kupwaraap tikinadiygwur. Gwuraam yawiy kwurtuwadiy gwur kwagwura kupwaam. Li duw nak a javik gwurak wakida, aw gwur diki majik lakwu-lakwub ti maa.’” ");
INSERT INTO mle_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Polawa Banapas adiy Juw daya gaba maja wiy wapabir, ababa duw taakw birakik wadabir, “Alaay Sapat bir ki maaj alib nyanak aw.” ");
INSERT INTO mle_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Gaba maja wiy wapakuw, Juwawa nuwukadiy jaka tipa kidiy duw taakw day Juw dayadiy sukw kwurdadiy, samasam biraki kwukib yidiy. Bir nimadib wabiridiy, God sukwasukw kwurid gwurak. “Gwur diki maaj wapatikwa,” wakuw. ");
INSERT INTO mle_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Niki Sapat yilik, a tipa kidiy duw taakw abab vagaluwdiy God diki maaj wukik. ");
INSERT INTO mle_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Aw adiy Juw a jaav vikuw, day nyigiy sidiy Polawa Banapasak. Day nikim nikim maaj bwuladiy. Day sapis jikin kwurdaad Polaam. ");
INSERT INTO mle_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Aw Polawa Banapas bir kaygan maa kwu. Nimadib wabir, “God waad gwur taay diki maaj wukikwagwura. Aw gwur diki majik maa wagwura nyanyi nyanyi yara kwakwak, aal gwura yawiya. Aw kita an nuwukadiy jaka tipa kidiy duw takwak yikinabiran God diki maaj dayak wasapwiyik.” ");
INSERT INTO mle_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","“Yitaypika Duw ki maaj nyanak kwiydil: ‘Wun tasakwu-tuwadiygwur nuwukadiy bapa duwak kariyaan tigwurkikik. Gwur ababa jaka tipa kidiy duw takwak sugwiyaan kwurgwur day yara kwadakikik nyanyi.’” ");
INSERT INTO mle_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Adiy nuwukadiy jaka tipa duw taakw a jaav wukikuw, rakarak tidiy. Day rakarak tidiy Yitaypika Duw diki majik, “Aal viyakita maaja,” wakuw. Adiy duw taakw God tasakwudidiy day yara kwakinadiy nyanyi ata wukijibir tidiy dikik. ");
INSERT INTO mle_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Yitaypika Duw diki maaj a tamiyaam ridiy tip abab wukidaal. ");
INSERT INTO mle_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Aw adiy Juw bira majik maa wakuw, suwaal kwurdiy. Nuwukadiy Godak gaba maaj sukwudiy jaka tipa kidiy sapakwa takwawa adi nimadi tipa kidiy sapakwa nyanugw adiy Juw daya suwala maaj wukikuw, jawjaay kwurdiy Polawa Banapasak. Day ata watipidabir bir daya tipaam kwakwak. ");
INSERT INTO mle_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bir a tip wapakuw, rikwun tibirbir maan kaypwutiykuw, adiy sim kupw viyapwuti-biridiy. Adiy duw taakw tipak watipidabir alik. Kwurkuw, bir ata Aykaniyam tipaar yibir. ");
INSERT INTO mle_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aw Antiyak tipaam kwadiy Kristen rakarak tidaak, God dikidi Mawul dayadiy mawulaam wapwurukwud. ");
INSERT INTO mle_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aykaniyam a tip alim ab Polawa Banapas Juw daya gaba maja wiyaar wulakuw, duw takwak maaj ata kwiybiridiy. Samasamadiy Juwawa Grik biraki majik wukijibir tidiy. ");
INSERT INTO mle_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Aw adiy wukijibir ti maardiy Juw suwala maaj wakuw nuwukadiy tipa kidiy duw takwak, adiy duw taakw maa wadiy birakik. ");
INSERT INTO mle_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Aw Polawa Banapas nyi samasam a tipaam kwabir. Bir maa yaag. Nimadib maaj wasapwiybiril. Yitaypika Duw birakik ap kwiykuw, bir nimadiy yawiy kwurbiridiy. Di atawa kwiykuw, duw taakw ata wukidiy di yaakiya waad birakidiy yawiyik. ");
INSERT INTO mle_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A tipaam kwadiy duw taakw day mawul vitiy tidiy. Nuwukadiy yaakiya wadiy Juw daya majik. Aw nuwukadiy yaakiya wadiy biraki majik. ");
INSERT INTO mle_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nuwukadiy Juwawa nuwukadiy tipa kidiy duwawa dayadiy sapakwa nyanugwawa jawjaay kwurik birakim. Day kabakir viyak kwurdabir. ");
INSERT INTO mle_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Aw bir a jaav wukikuw, ata tabwubir Laykawniya tamiy alim ribir tip Listira-wa Dipiy abir tipaar. Abir tipawa walibab rinadiy tip ab bir viyakita maaj ata wasapwiybiril. ");
INSERT INTO mle_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listiraam duw nak, dikibir maan kupwaraap tibir, rad. Diki amaay sapwiylik, atawadika tad. Di tiytiyaan akis tiykwaad. ");
INSERT INTO mle_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Di Pol diki maaj wukidil. Wukikuw, di diki mawulaar wukid, “Kidi duw wadik, wun tiytiyaan tikinadiwun,” wakuw. Pol wukikuw adi duw dikik wukijibir tad, di dikik vivikaan tidik, nimadib ata wadid, “Min rapikuw, minabir manir rapin ada!” Aw adi maan kupwaraap tidi duw yabiyib rapikuw, tiytiyaan tad. ");
INSERT INTO mle_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Adiy walibab vagaluwdiy duw taakw Pol diki yawiyim vikuw, ata wataay tayadiy daya kapa tipa majir, “Nyanadiy god samasam tinadiy. Vitiy, duw kitik nyanak danabir!” ");
INSERT INTO mle_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banapas day sikiydaad Suwus. Pol di maaj wasapwiydil. Alik day sikiydaad Yimis. ");
INSERT INTO mle_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Adiy suwala god nak, dikidi si Suwus, diki gaba maja wiy tip walibab ral. A gaba maja wiya sapakwa nyan, nuwukadiy duwa bulmakau awa mawaay kwurkuw, a tipa yarigim til wiyigaar karaydidiy. Diwa ababa duw taakw adiy jaav Polawa Banapasak kwiyik, “Bir nyanabir god-abir,” wakuw. ");
INSERT INTO mle_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Aw Polawa Banapas a jaav lakwukuw, birakidiy wapwiy kaypirikiykuw, daya nyidi nyidirib gipikuw, gaam sibir, “Gwur duw, agwak ki jaav kwurgwura? An mwiya duw-abiran gwura pik. An kilir yanabiran gwurak viyakita maaj wasapwiyik. Gwur kidiy kupwarapa jaav wapakuw, adi mwiya Godak wukijibir ada! Di nabiy nabiy kwakwanaad. Mwiya tayir di adawur tip, kidi kupw, solwara wa dayaam rinadiy ababa jaav yitakadidiy. ");
INSERT INTO mle_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","“Tayir di yaakiya waad ababa duw taakw day dayadiy sukw kwurkwurik. ");
INSERT INTO mle_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","“Aw nyanyi di simaka-didiygwur di kwanaad dikidiy viyakita yawiyir. Di gwurak waal wayaki-kwanaad gwuradiy mayim sigwuradiy jaav wardakik. Di gwurak kikipaat kwiykwanaad, gwuradiy mawul rakarak tidakikik.” ");
INSERT INTO mle_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Day ofa kwiyik tikuw, bir ki maaj wabirik, nima yawiy kwurbir watipik dayak. ");
INSERT INTO mle_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Aw nuwukadiy Pasitiya tamiyaam ribir tip Antiyakawa Aykaniyam-aam kwadiy Juw yakuw, day suwala maaj wadiy adiy vagaluwdiy duw takwak Polawa Banapasak. Adiy vagaluwdiy duw taakw daya maaj wukijibir tikuw, mawul warkuw, kabakir Polaam viyadaad. Day wukidaal di bwu kiyanaad wakuw, dikidi pwus mala tipaar lagwun karaydaad. ");
INSERT INTO mle_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Aw a tipa kidiy Kristen vagaluwdaak Polak, di ata rapid. Rapikuw, tipaar ata sibinin yad. Sira pik di Banapasawa Dipiy tipaar yibir. ");
INSERT INTO mle_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Dipiyaar yikuw, God diki viyakita maaj wasapwiykuw, duw taakw samasamadiy Jisasak wukijibir tidiy. Bir ata Listira tipaar yikuw, ginyir Aykaniyam tipaar yikuw, ginyir Pisitiya tamiyaam ril tip Antiyak a tipaar yibir. ");
INSERT INTO mle_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Adiy tipaam kwadiy Kristen bir ap kwiybiridiy. Bir dayak kalivabiridiy, “Gwur mwiyir Godak wukijibir ada. Taay day jawjaay kwurkida nyanaam, aw ginyir nyan God dikidi van tidadi tipaar wulakidiyan.” ");
INSERT INTO mle_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ababa tipa bapa Kristen gwalugwa duw takwaam sapakwa nyanugw tasakwu-biridiy. Day kikipaat maa ki. Godak bir bas sidika sibir adiy sapakwa nyanugwak. Bir wabiridiy, “Gwur Godak wukijibir tigwur, di gwuraam yara van tikidadiygwur.” ");
INSERT INTO mle_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisitiya tamiyaar yaan napakuw, Pabiliya tipaar wakwubir. ");
INSERT INTO mle_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pika tipaam God diki maaj wasapwiybir. Wasapwiykuw, bir ata Ataliya tipaar dabir. ");
INSERT INTO mle_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Alim jabir kwurkuw, Antiyak tipaar yibir. Tayir Antiyakaam kwadiy Kristen Godak bas sikuw, Polawa Banapas wayakidabir biraki yawiyik. Ki yawiy aka bwu kwusil. ");
INSERT INTO mle_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiyak-aam wulakuw, bir a tipa kidiy Kristen gwalugwa duw takwawa vagaluwkuw, bir yarik yibiridiy ababa jaav God kwurdidiy birakiwa. Bir wabiridiy God kwurkuw, nuwukadiy tipa kidiy duw taakw dikik wukijibir tidiy. ");
INSERT INTO mle_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Alim bir nyi samasam kwabir adiy a tipa kidiy Kristenawa. ");
INSERT INTO mle_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nuwukadiy Juwtiya tamiya kidiy duw Antiyakaar yakuw, day maaj kwiydadiy Jisas dikidiy gwalugwa duwak. Day wadiy, “Gwur gwuradiy sipaam kaam sakw maarkigwura Mawsis diki lo wadil pik, God gwuraam kwar maa.” ");
INSERT INTO mle_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Aw Polawa Banapas dayawa day awarwa awarwa maaj warjuwun majir wariyadiy. Atawa wariyakuw, a tipa kidiy Kristen yaakiya wadiy Polawa Banapas nuwukadiy Antiyak Kristen duwawa Jiruwsalimaar yidakikik God dikidiy wayakididiy duwawa Kristen sapakwa nyanugwawa ki maaj lakatiydakik. ");
INSERT INTO mle_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antiyak Kristen wayakikuw, day ata yidiy. Antiyak wapakuw, Paniysiya-wa Samariya abir tamiyaar yikuw, day abir tamiyaam kwadiy Kristenak wadadiy ata ata nuwukadiy jaka tipa kidiy duw taakw Godak wukijibir tidiy. Adiy Kristen a jaav wukikuw, rakarak tidiy. ");
INSERT INTO mle_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jiruwsalimaam wulakuw, Kristen-awa God dikidiy wayakididiy duwawa, a tipa kidiy Kristen sapakwa nyanugwawa, dayak rakarak tidiy yadakikik. Day ata Jiruwsalim Kristenak wadiy adiy jaav God kwurdidiy dayawa. ");
INSERT INTO mle_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Aw nuwukadiy duw, day Parasiy bapa duw day Kristen tidiy, rapikuw, wadiy, “Nyan kidiy nuwukadiy jaka tipa kidiy Kristenak wakwanadiyan day daya sipaam kaam sukwukwadiy, Mawsis diki lo-ab wukikuw.” ");
INSERT INTO mle_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","God dikidiy wayakididiy duwawa, Kristen sapakwa nyanugwawa vagaluwdiy ki maaj lakatiyik. ");
INSERT INTO mle_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Aw day maaj samasam bwulakuw, Pita rapikuw, wadidiy, “Wunadiy gwalugwa duw, gwur abab lakwu-nadiygwur tayir God gwurak tasakwu-didiwun diki viyakita maaj wasapwiy-tuwkik nuwukadiy jaka tipa kidiy duw takwak, aw day wukikuw, dikik wukijibir tidakikik. ");
INSERT INTO mle_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","“God ababa duw taakw dayadiy mawul lakwu-kwanaad. Di bwu yaakiya wakuw dayak, dikidi Mawul bwutaay kwiydid nyanak kwiydidi pik. ");
INSERT INTO mle_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","“Di nyanak kapab, dayak kapab maa kwar. Dayak ab day dayadiy valik wukikuw, yibwiydidiy. ");
INSERT INTO mle_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","“Agwa javik gwur Godak vasibariyik kwur-nadiygwurik nimadiy yawiy dayak kwiykuw? Nyanadiy warag nyanabab kidiy yawiy kwurkwur maa rav. ");
INSERT INTO mle_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","“Aw nyan kita wukijibir tibaak, God nyanak sukwasukw kwurkuw, di nyigil-dadiyan. Atawa nuwukadiy tipa kidiy duw taakw ab nyigil-dadiy.” ");
INSERT INTO mle_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Adiy vagaluwdiy duw day maaj maa bwul. Aw day lakwudaal Banapasawa Pol bir wabiridiy niki yawiy niki yawiy God kwurdidiy birak, nuwukadiy jaka tipa kidiy duw taakw daya nyidim tibir. ");
INSERT INTO mle_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Maaj wakuw, Jamis ata waad, “Gwalugwa duw, gwur maaj awuk! ");
INSERT INTO mle_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","“Sayman kita wanaad atata God bas nuwukadiy jaka tipa kidiy duw takwak yakuw, daya nyidim bapa duw nak kwurdidiy di diki. ");
INSERT INTO mle_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","“God dikidiy maaj wasapwiydiy duw day maaj nak. Ki maaj God diki lapa nyigaam rina. ");
INSERT INTO mle_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Yitaypika Duw wanaad, Ginyir sibinin yakidiwun. Davit dikidiy gwalugwa duw taay vakirkidiy jaba wiy kitik. Ginyir wun yakuw, kirapitaka-kituwadiy. Wun yara kwurkituwadiy dayak. Aw day viyakit tikidiy tayir tidaal pik. ");
INSERT INTO mle_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Atawa kwurkuw, nuwukadiy duw taakw wun, dayadi Yitaypika Duwaam, sitakira-kidanadiwun. Nuwukadiy jaka tipa kidiy duw taakw ab wun tasakwu-tuwadiy wunadiy-adiy. ");
INSERT INTO mle_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tayir Yitaypika Duw ki maaj wadil. Aw kita di di wada.’” ");
INSERT INTO mle_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jamis nuwuka maaj wadidiy, “Wuna mawul atawa wana: Adiy nuwukadiy jaka tipa kidiy duw taakw mawul warapiykuw, Godak wukijibir tikuw, nyan dayak yawiy samasam kwiybaba. ");
INSERT INTO mle_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","“Aw kidiy jaav lapa nyigaam sukwunaak dayak: ‘Gwur suwala god ak kwiydadiy kwiy kitikwa. Aw gwur duw taakw kipa yabim vaal yiyi yaan kwurtikwa. Aw adiy animal day kwaliyapaam kaybwukwadaak, kitikwa. Aw nyikiy ab kitikwa. ");
INSERT INTO mle_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","“Day Mawsis diki lo nabiy samasam ababa Sapat gaba maja wiyaam wadaal. Ababa tipaam day diki maaj wasapwiydaal. Alik day adiy jaav lakwu-kwanadiy.” ");
INSERT INTO mle_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Adiy God dikidiy wayakididiy duwawa, sapakwa nyanugwawa, ababa Kristen yaakiya wadiy day nuwukadiy duw tasakwukuw, day wayaki-kidanadiy Polawa Banapas-awa Antiyakaar. Duw vitiy tasakwudabir, Juwtas Basapas-awa Saylas. Bir daya nyidim tibir sapakwa nyidiy. ");
INSERT INTO mle_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Day lapa nyig kwiydaal birakiwa. Ki lapa nyig waal: “Ababa nuwukadiy jaka tipa kidiy gwalugwa duw, gwur Antiyakawa Siriyawa, Silisiyaam kwanadiygwur wakuw, nyan Jiruwsalimaam kwanadiy Jisas dikidiy wayakinadiy duwawa, sapakwa nyanugwawa nyan gwuradiy gwalugwa duw wayapiy sinadiyan gwurak. ");
INSERT INTO mle_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Nyan wukibana nuwukadiy duw, nyana nyidim tikuw, gwurak yikuw, nuwukadiy maaj wadaak gwurak, gwur pitaan warkuw, gwuradiy mawul jawjaay tinadiy. Nyan dayak atawa maa wu. ");
INSERT INTO mle_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","“Atawa tikuw, nyan vagaluwkuw, yaakiya wanadiyan maaj wayakibanabir duw tasakwukuw, yibirkikik gwurak. Bir nyanabir kapa duw Banapasawa Pol yikinabir. ");
INSERT INTO mle_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","“Nuwukadiy duw birim viyasipak, bir maa yaag. Bir yin yaan tibagwubir nyanadi Yitaypika Duw Jisas Krais diki yawiy kwurik. ");
INSERT INTO mle_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","“Kibir wayakibanabir duw, Juwtasawa Saylas, bir gwurak wakibira kidiy lapa nyigaam sukwubanadiy maaj. ");
INSERT INTO mle_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","“Aw God dikidi Mawul nyanawa yaakiya wadik, nyan gwurak nimadiy yawiy kwatay maa. Gwur kidiy majadika awuk. ");
INSERT INTO mle_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","“Adiy suwala god ak kwiydadiy kwiy ata kwurin kiwayik. Gwur nyikiy kitikwa. Adiy animal day kwaliyapaam kaybwukidaak, kitikwa. Gwur kipa yabim vaal yiyi yiya-wayik. Kidiy jaav kwar maarkigwura, yara kwakinadiygwur. Gwur yara adakw.” ");
INSERT INTO mle_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Day adiy duw wayakikuw, Antiyakaar yidiy. Yikuw, a tipa kidiy Kristenak gaam sidiy vagaruwdakik. Day vagaluwkuw, lapa nyig dayak kwiydaal. ");
INSERT INTO mle_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Adiy duw taakw lapa nyigaam ril viyakita maaj wukikuw, rakarak samasam tidiy. ");
INSERT INTO mle_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juwtasawa Saylas, God diki maaj wasapwiybir duw tibir. Aw bir maaj samasam dayak wasapwiy-biridiy ap dayak kwiyik dayadiy mawul yara tidakikik. ");
INSERT INTO mle_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","35","Bir nyi samasam dayawa tikuw, day birakik wayakidaak, yibir. Day, “Yara maay,” wakuw Jiruwsalimaam kwadiy Kristenak, yibir. Aw Polawa Banapas nuwukadiy nyi Antiyakaam kwabiridiy. Nuwukadiy duwawa bir God dikidiy maaj kalivaan wasapwiyin kwiybiridiy dayak. ");
INSERT INTO mle_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ginyir nuwukadiy nyi yidaak, Pol Banapasak wadid, “An yin vitik adiy gwalugwa duw taakw ababa tipaam tayir an yikuw, God diki maaj wasapwiy-tidiy tipak. Day yara kwanadiy? Ay maa?” ");
INSERT INTO mle_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","38","Banapas diki mawul Jon Mak birakiwa yidikikik. Aw Pol maa waad. Di waad tayir Mak birakiwa yikuw, di yirib maa yi. Yikuw nyidib Pabiliyaam, alim wapadibir. ");
INSERT INTO mle_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bir awarwa maaj warjuwkuw, ata gwutakabir. Banapas Mak kwurkuw, ata Saypirisaar yibir jabirasaay. ");
INSERT INTO mle_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Aw Pol Saylas tasakwukuw, a tipa kidiy gwalugwa duw taakw God diki tabaam takadabir. Takadaak, bir ata dayaam wapabir. ");
INSERT INTO mle_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bir Siriyawa Silisiya abir tamiyaam yibagwubir ap kwiyik abir tamiyaam kwadiy Kristenak. ");
INSERT INTO mle_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol Dipiyawa Listira abir tipaar yad. Listiraam Kristen duw nak, dikidi si Timotiy, sitakiradid. Diki amaay, Juw taakw nak, libab Jisasak wukijibir tal. Aw dikidi asaay Grik jaka tipa kidi duw tad. ");
INSERT INTO mle_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ababa Listirawa Aykaniyam abir tipaam kwadiy Kristen gwalugwa duw taakw wadiy Timotiy di viyakita duwad. ");
INSERT INTO mle_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol diki mawul waal Timotiy diwa yidikikik. Taay di Timotiy diki sipaam kaam sukwudid. Pol lakwudil Juw kwadiy ababa yikidadiy tipaam. Adiy Juw lakwudiy Timotiy dikidi asaay Grik jaka tipa kidi duwad. Alik di ata kaam sukwudid. ");
INSERT INTO mle_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ababa tipaar wakwukuw, day a tipa kidiy Kristenak adiy Jiruwsalimaam kwadiy Jisas wayakididiy duwawa sapakwa nyanugwawa sukwudadiy maaj adiy kwiydadiy. Day wadadiy, “Kidiy majib awuk.” ");
INSERT INTO mle_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Adiy tipa kidiy Kristen ap kwurkuw, nimadib Godak wukijibir tidiy. Ababa nyi nuwukadiy duw taakw Godak wukijibir tidiy. ");
INSERT INTO mle_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","God dikidi Mawul dayak wadidiy, “Kita gwur yin Asiya tamiya kidiy duw takwak wuna maaj wasapwiy-tikwa.” Wakuw, day Pirikiya-wa Galasiya abir tamiyaar yidiy. ");
INSERT INTO mle_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Day Misiya tamiy walibab yikuw, day Patiniya tamiyaar wulak. Aw Jisas dikidi Mawul watipididiy. ");
INSERT INTO mle_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Atawa tikuw, day Misiya tamiyaar valakuw, Tirawas tipaar dadiy. ");
INSERT INTO mle_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Gaan nak Pol yigin vidil. Di duw nak, Masataniya tamiya kidi duw, vidid. Adi duw rapin tikuw, wasakwudid, “Min Masataniy-aar may. Yakuw, sugwiyaan akwur nyanak!” ");
INSERT INTO mle_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol yigin vikuw, nyanadiy jaav ata kwulapwu-badiy Masataniyaar yikir. Aw nyan wukibaal God diki mawul nyan diki Viyakita Maaj a tamiya kidiy duw takwak wasapwiy-bakik. ");
INSERT INTO mle_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tirawasaam jabir kwurkuw, nyan ata Samatiras tipaar yikuw, sira pik Niyapalis tipaam yin kawiydiyan. ");
INSERT INTO mle_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Niyapalis wapakuw, alawuraam ril tip Pilipayaar wuladiyan. Pilipay nimadi tip Masataniya ridil tamiyaam. Roma gavman duw a tipaam kwadiy. Nyan alim nuwukadiy nyi kwadiyan. ");
INSERT INTO mle_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sapat nyaam nyan tip wapakuw, mala bayibir yidiyan. Alim nyan wukibaal nuwukadiy Juw vagaruw-kinadiy beten ik. Yikuw, nuwukadiy takwaam vikuw, nyan daan ran dayawa maaj bwuladiyan. ");
INSERT INTO mle_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nyana maaj wukil taakw nak, liki si Litiya. Li Tayatayra tipa kil taakw-al. Li nyikiy nyikiy wapwiy yawiy kwuril. Li Godak beten rikwaal. Yitaypika Duw liki mawulaam kwurdik, li Pol diki majik wukilil. ");
INSERT INTO mle_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Wukikuw, likiwa wiy ni ridiy baptais kwurdiy. Baptais kwurkuw, li nyanak ata waal, “Li gwur lakwugwura wun mwiyir wukijibir tinawun Yitaypika Duwak, gwur yin wuna wiyaam adakw.” Nyanak wap apaal. Alik nyan likiwa yidiyan. ");
INSERT INTO mle_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nyi nak nyan beten tamiyaar yitaay tibaak, kipa yawiy taakw nak nyanak yaal. A taakw wudib nak liki mawulaam kwaad. Adi wudib mawulaam kwurdikib, maaj wasapwiy-lidiy agwa javadiy ginyir maykaar wakwukinadiy. Nuwukadiy duw taakw adiy jaav wukik, saan kwiydadiy likim van tidiy duwak. ");
INSERT INTO mle_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Li Polawa nyana kwukir yakuw, gaam sal, “Kidiy duw mwiya nimadi God dikidiy yawiy duw tinadiy. Day gwurak wataynadiy ata ata God nyigil-kidadiygwur.” ");
INSERT INTO mle_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Li nyi samasam atawa kwurkuw, Pol mawul warkuw, di tipatiyakwukuw, adi wudibak wariya kwudiy wadid, “Jisas Krais dikidi saam watuwadimin, min ki takwaam wapakuw, apwutiy!” Jayib ni adi wudib ata wapadil. ");
INSERT INTO mle_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A taakw likidiy van tidiy duw day wukikuw li viyakit tilik, day nuwukadiy saan kwar maa liki yawiyik, day ata Polawa Saylasaam kalakwukuw, vagaluw yikwadaal tamiyaar kwurin karaydabir a tipa kidiy sapakwa nyanugwak. ");
INSERT INTO mle_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Day kwurkuw, jas ak kwurin karaydabir. Adiy jas ak wadadiy, “Kibir duw Juw tinabir. Bir jaal dabir nyana tipaam. ");
INSERT INTO mle_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","“Adiy jaav bir kaliva-biradiyan nyana lo maa wana dayak. Aw nyan Roma duw taakw-adiyan. Alik nyan adiy jaav akis kwurkwanadiyan!” ");
INSERT INTO mle_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Adiy vagaluwdiy duw ab maa wadiy birakik. Adiy jas birakidiy wapwiy kaypwutiydaak, day yaakiya wadiy day birim viyakidanabir jikiyir. ");
INSERT INTO mle_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Birim nimadib viyakuw, day ata kalabus ir yakisawula-dabir. Day kalabus im ridiy duwak van tidiy duwak wadaad, “Min kibir duwaam yara van ada!” ");
INSERT INTO mle_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ki maaj wukikuw, di tipitaydaal yala wiyaam takadibir. Takakuw, birakidiy maan mwiya aykwar kwusawulakuw, yaav jidibir. ");
INSERT INTO mle_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nyidi gaan Polawa Saylas bir Godak maaj wakuw, song ribir. Nuwukadiy kalabus im ridiy duw wukidabir. ");
INSERT INTO mle_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Jayib ni nimadi nanaaw viyadik, adi wiy yitaay yataay tad. Tikuw, ababa wiyig rapwiyaan kalabus im ridiy duwab sen vakirin ata kwurdiy. ");
INSERT INTO mle_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kalabus im ridiy duwaam van tidi duw jawiyakuw, vidil ababa wiyig rapwiyaan tidiy, diki mawul waal ababa kalabus im ridiy duw bwutaay tabwudiy wakuw. Di wukikuw, tuwum kwadi wariya bag kwurkuw, di di kap viyalupwakuw kiyak kwurik. ");
INSERT INTO mle_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Aw Pol a jaav vikuw, nimadib gaam sidid dikik, “Min kap atawa viyalupwa-tikwa! Nyan kilim kwanadiyan abab.” ");
INSERT INTO mle_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kalabusim ridiy duwaam van tidi duw ata gaam sidil tuwayik. Tuwaay kwurkuw, gipikuw, nimadib yagakuw, Polawa Saylas birakibir manwa vakirid. ");
INSERT INTO mle_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Vakirkuw, ata kwurin kalakwudibir kawaar. Di ata wadibir, “Bir wunak aw. Wun agwa jaav kwurkuw, God wunaam nyigil-kidadiwun?” ");
INSERT INTO mle_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bir ata wabir, “Min wukijibir ada Yitaypika Duw Jisasak. Atawa kwurkimina, God nyigil-kidadimin minadiy wiy nak kwadiywa.” ");
INSERT INTO mle_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bir God diki maaj dayak ata wabiridiy diwa kwadiyik ab. ");
INSERT INTO mle_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","A nyaam nyidi gaan tidik, guw kwurkuw, di birakibir sipaam tidiy kwiyak ata jandidiy. Jankuw, bir baptais ata kwiybirid. Day diki wiyaam kwadiy dayabab baptais kwurdiy. ");
INSERT INTO mle_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Baptais kwurkuw, Polawa Saylas kwurin karaykuw diki wiyaar, kikipaat ata kwiydibir. Di adiy diwa kwadiy ab Godak wukijibir tikuw, rakarak samasam ridiy. ");
INSERT INTO mle_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ginyir ganib tilik, adiy jas maaj wayakidaal plisman ik kalabus ir. Day wadiy, “Abir duw wapaminkik.” ");
INSERT INTO mle_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Daya maaj wukikuw, kalabus im ridiy duwak van tidi duw Polak ata wadid, “Adiy jas maaj wayakidaal minawa Saylas biraam wapatuwkik. Yaakiya, bir aka yikibira. Yara maay.” ");
INSERT INTO mle_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Aw Pol adiy plisman ik nimadib wadidiy, “Atawa maa. An dayaam vaal maa yi. Day a jaav wukikuw, kip viyadabiran samasama duw taakw dayadiy milaam. Aw an Rom tipa kibir duw-abiran. Aw day kalabus ir yakisawula-dabiran. Aw kita day anaam yipakwun wayakik. Aal maa rav. Day daya yaan kwurin kalakwu-kidanabiran kawaar.” ");
INSERT INTO mle_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Adiy plisman biraki maaj jas ak karaydaal. Adiy jas wukikuw Polawa Saylas bir Rom tipa kibir duwabir, day yagadiy. ");
INSERT INTO mle_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Day ata Polawa Saylasak wulakuw, birakik sukwasukwa maaj wadabir. Day ata birim kwurin kalakwudabir kawaar. Kawaar wakwukuw, day ata bas sidika sidabir bir daya tip wapabirkik. ");
INSERT INTO mle_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Polawa Saylas kalabus wapakuw, Litiya liki wiyaar yibir. Alim Kristen gwalugwa duwawa vagaluwkuw, dayak maaj kwiybiridiy dayadiy mawul yara tidakikik. Maaj kwiykuw, bir ata yibir. ");
INSERT INTO mle_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Polawa Saylas Pilipay tip wapakuw, yin Abipalis Apalaniya abir tip wapakuw, yin Tisalanika tipaar ata wakwubir. Juw dayadi gaba maja wiy alim kwaad. ");
INSERT INTO mle_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol dayadi gaba maja wiyaar wulakuw Sapat nyaam, di diki sukwa pikaar wulayi-kwaad. Alim Sapat mugwul di dayak God diki lapa nyigaam rina maaj kalivadidiy. ");
INSERT INTO mle_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Di dayak wadidiy, “Kidiy maaj simaka-dadiygwur God dikidi Tasakwudidi Duw diki sipaam kagil yilik, kiyakuw ridik, God ata kirapitakadid. Kidi Jisas, wun bwutaay watuwadiygwur dikik. Di God dikidi Tasakwudidi Duw tinaad.” ");
INSERT INTO mle_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nuwukadiy Juw duw taakw yaakiya wakuw diki majik, day mawul nak Polawa Saylas birakiwa tidiy. Samasam Godak wukijibir tidiy Grik, sapakwa takwawa, dayabab wukijibir tidiy diki majik. ");
INSERT INTO mle_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Aw a tipa kidiy Juw day mawulaar wasupw supwakuw, adiy kip kwadiy kupwarapa duw kwurin karaydadiy. Day a tipa kidiy duw takwak gaam sidaak, day Jasan diki wiyaam viyadaal Polawa Saylas kwurin karaydakik vagaluwdiy duw takwak. ");
INSERT INTO mle_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Aw day birikim sitakir maarkuw, Jasanawa nuwukadiy Kristen gwalugwa duw liyin karaydadiy a tipa kidiy sapakwa nyanugwak. Day nimadib watay-dadiy, “Abir duw bir ababa tipaam jawjaay kwurkwanabir. Aw kita bir nyana tipaar yakuw, Jasan di yaakiya wanaad bir diki wiyaam kwabirkikik. Aw day abab maa wakuw nyanadi yitaypika duw diki lo-ak, ata wakwanadiy nikidi duw, Jisas, di yitaypika duw tikwanaad.” ");
INSERT INTO mle_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ki maaj wukikuw, ababa vagaluwdiy duw taakw sapakwa nyanugwawa dayadiy mawul warkuw, wariya kwudiy wadiy. ");
INSERT INTO mle_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Adiy sapakwa nyanugw wakuw, Jasan nuwukadiy duwawa kot yapiykuw, day yaakiya wadiy dayaam kugwayakidaak kip yidakikik. ");
INSERT INTO mle_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Gaan tilik, Kristen gwalugwa duw day Polawa Saylas wayakidabir tip si Biriya, a tipaar. Biriyaam wulakuw, bir a tipa kidiy Juw dayadi gaba maja wiyaar wulabir. ");
INSERT INTO mle_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Day Biriyaam kwadaal, a tipa kidiy duw biraki majik waan takaan ridiy. Tayir 