﻿USE sofia;
DROP TABLE IF EXISTS sofia.mkw_vpl;
CREATE TABLE mkw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mkw_vpl WRITE;
INSERT INTO mkw_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Na mbandukulu Nzambi yidikaka zulu na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ntoto vwandaka ya kuyilama ve, mpe yawu vwandaka ya mpamba. Maza vwandaka fuka nyonso, mpe kitombe vwandaka fuka maza ya kusunda. Mpeve ya Nzambi vwandaka pepa na zulu ya maza. ");
INSERT INTO mkw_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Na yina, Nzambi tubaka: «Bika ti nsemo kutalana», mpe nsemo talanaka. ");
INSERT INTO mkw_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nzambi talaka ti nsemo vwandaka mbote, mpe yandi kabulaka nsemo na kitombe. ");
INSERT INTO mkw_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nzambi bokilaka nsemo «ntangu», mpe yandi bokilaka kitombe «mpimpa». Bwisi yilaka, mpe bwisi kutsyaka. Yawu vwandaka ni kilumbu ya ntete. ");
INSERT INTO mkw_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nzambi tubaka: «Bika ti kisika ya mpamba kuvwanda na kati-kati ya maza mutindu muludi, samu na kukabula maza na bandambu zole.» ");
INSERT INTO mkw_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Nzambi yidikaka kisika ya mpamba mutindu muludi yina kabulaka maza: Maza ya nkaka na zulu ya muludi, maza ya nkaka na yisi. Mpe yawu salamaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nzambi bokilaka muludi yango zulu. Bwisi yilaka, mpe bwisi kutsyaka. Yawu vwandaka ni kilumbu ya zole. ");
INSERT INTO mkw_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nzambi tubaka: «Bika ti maza yina kele na yisi ya muludi kuvwanda kisika mosi, samu ti kisika ya kuyuma kutalana.» Mpe yawu salamaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nzambi bokilaka kisika ya kuyuma «ntoto», mpe yandi bokilaka maza yina vwandaka kisika mosi «mubu». ");
INSERT INTO mkw_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nzambi tubaka: «Bika ti ntoto kumenisa matiti ya mutindu na mutindu: Matiti ya konso mutindu yina ke pesaka bambuma ya kukunda, na bayinti ya konso mutindu yina ke butaka bambutu yina ke vwandaka na mikokodi.» Mpe yawu salamaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ntoto basisaka matiti ya mutindu na mutindu: Matiti ya konso mutindu yina ke pesaka bambuma ya kukunda, na bayinti ya konso mutindu yina ke butaka bambutu yina ke vwandaka na mikokodi. Nzambi talaka ti yawu vwandaka mbote. ");
INSERT INTO mkw_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Bwisi yilaka, mpe bwisi kutsyaka. Yawu vwandaka ni kilumbu ya tatu. ");
INSERT INTO mkw_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Nzambi tubaka: «Bika ti bima yina ke lezimaka kuvwanda na muludi ya zulu samu na kukabulaka mpimpa na ntangu. Yawu ke vwanda bidimbu samu na kuzabisaka bilumbu, bamvula, na bantangu ya mikembo. ");
INSERT INTO mkw_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Bika ti bima yina banda na kulezimaka na muludi ya zulu samu na kupesaka nsemo na ntoto.» Mpe yawu salamaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ni mutindu yina Nzambi yidikaka bima zole ya nene yina ke lezimaka samu na kukyenzulaka. Mosi ya kulutila nene, samu na kukyenzulaka na ntangu, mpe ya nkaka ya fyoti, samu na kukyenzulaka na mpimpa. Yandi yidikaka mpe bambwetete. ");
INSERT INTO mkw_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nzambi tulaka bima yina na muludi ya zulu, samu na kupesaka nsemo na ntoto, ");
INSERT INTO mkw_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","samu na kuyalaka na mpimpa mpe na ntangu, mpe samu na kukabulaka mpimpa na ntangu. Nzambi talaka ti yawu vwandaka mbote. ");
INSERT INTO mkw_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Bwisi yilaka, mpe bwisi kutsyaka. Yawu vwandaka ni kilumbu ya yiya. ");
INSERT INTO mkw_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Nzambi tubaka: «Bika ti maza kufuluka na bima nyonso ya moyo yina ke zingaka na kati ya maza, bika mpe ti bandeke yina ke banda na kutambulaka na muludi ya zulu kuvwanda.» ");
INSERT INTO mkw_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nzambi yidikaka bibulu ya nene ya nsisi ya mubu, na bima nyonso ya nkaka ya moyo yina ke zingaka, mpe ke tambulaka na maza, mutindu kele makanda ya bawu. Yandi yidikaka mpe bandeke nyonso mutindu kele makanda ya bawu. Nzambi talaka ti yawu vwandaka mbote. ");
INSERT INTO mkw_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nzambi sakumunaka bawu mutindu yayi: «Beno butana, beno kuma mingi, beno fulusa mubu. Bika mpe ti bandeke kukuma mingi na ntoto.» ");
INSERT INTO mkw_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Bwisi yilaka, mpe bwisi kutsyaka. Yawu vwandaka ni kilumbu ya tanu. ");
INSERT INTO mkw_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Nzambi tubaka: «Bika ti ntoto kubasisa makanda ya mutindu na mutindu ya bibulu: Bibulu ya bwala, bibulu ya fyoti-fyoti, na bibulu ya mfinda mutindu kele makanda ya bawu.» Mpe yawu salamaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nzambi yidikaka bibulu ya mfinda ya mutindu na mutindu, bibulu ya bwala ya mutindu na mutindu, na bibulu ya fyoti-fyoti mutindu kele makanda ya bawu. Nzambi talaka ti yawu vwandaka mbote. ");
INSERT INTO mkw_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Nzambi tubaka: «Beto yidika muntu na kifwani ya beto, yandi kuvwanda mutindu beto, yandi kuyala bambisi ya mubu, bandeke ya zulu, bibulu ya bwala, na ntoto nyonso, mpe na banyama ya fyoti-fyoti nyonso yina ke tambulaka na ntoto.» ");
INSERT INTO mkw_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nzambi yidikaka muntu na kifwani ya yandi. Na kifwani ya Nzambi, yandi yidikaka muntu. Yandi yidikaka bawu kento na bakala. ");
INSERT INTO mkw_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nzambi sakumunaka bawu mpe tubaka: «Beno butana, beno kuma mingi, beno fulusa ntoto mpe beno yala yawu. Beno yala bambisi ya mubu, bandeke ya zulu, mpe bibulu nyonso yina ke tambulaka na ntoto.» ");
INSERT INTO mkw_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nzambi tubaka: «Mu ke na kupesa beno matiti nyonso ya ntoto yina ke butaka bambuma ya kukunda, na bayinti nyonso yina ke butaka bambuma. Ni yawu ke vwanda madya ya beno. ");
INSERT INTO mkw_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Samu na bibulu nyonso yina kele na ntoto, bandeke ya zulu, mpe bima nyonso yina kele moyo mpe ke tambulaka na ntoto, mu me pesa bawu matiti nyonso mutindu madya.» Mpe yawu salamaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nzambi talaka ti bima nyonso yina yandi yidikaka vwandaka mbote mingi. Bwisi yilaka, mpe bwisi kutsyaka, yawu vwandaka ni kilumbu ya sambanu. ");
INSERT INTO mkw_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ni mutindu yina salamaka zulu na ntoto, na bima nyonso yina kele na yawu. ");
INSERT INTO mkw_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nzambi manisaka kisalu ya yandi nyonso mpe yandi pemaka na kilumbu ya nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nzambi sakumunaka kilumbu ya nsambwadi mpe yandi salaka ti yawu kuvwanda kilumbu ya longo, samu ti ni na kilumbu yina yandi pemaka na manima ya kumanisa kisalu ya yandi nyonso, ya kuyidika bima nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Tala mutindu salamaka zulu na ntoto, ntangu Nzambi yidikaka yawu. Na ntangu yina, Yave Nzambi yidikaka zulu na ntoto, ");
INSERT INTO mkw_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ata mwa yinti mosi vwandaka ntete ve na ntoto, mpe ata dititi mosi menaka, samu ti Yave Nzambi vwandaka me nokisa ntete ve mvula, mpe ata muntu vwandaka samu na kusala bilanga. ");
INSERT INTO mkw_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kasi ya vwandaka na kisika mosi yina vwandaka basisa maza na yisi ya ntoto, mpe maza yina vwandaka mwangana na ntoto nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yave Nzambi bakaka fundu-fundu ya ntoto, mpe yandi yidikaka muntu na yawu. Yandi fulaka mupepe ya luzingu na mbombo ya muntu, mpe muntu kumaka muntu ya moyo. ");
INSERT INTO mkw_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Na manima, Yave Nzambi kundaka bilanga ya bayinti, kuna na lweka ya esete, na kizunga ya Edeni, mpe yandi tulaka kuna muntu yina yandi yidikaka. ");
INSERT INTO mkw_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yave Nzambi menisaka bayinti ya mutindu na mutindu, yina vwandaka kitoko na kutala mpe bambuma ya yawu vwandaka mbote na kudya. Yandi tulaka na kati-kati ya bilanga, yinti ya luzingu mpe yinti yina ke pesaka mayela samu na kuzaba yimbi na mbote. ");
INSERT INTO mkw_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Nzadi mosi bandaka na kizunga ya Edeni mpe vwandaka bolisa bilanga ya bayinti. Katuka kuna, nzadi yango kabukaka na bandambu yiya. ");
INSERT INTO mkw_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nkumbu ya maza ya ntete vwandaka Pisone, ni yawu ke zungidilaka yinsi nyonso ya Avila. Yinsi yango kele na wolo, ");
INSERT INTO mkw_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","wolo mosi ya mfunu mingi. Kuna vwandaka mpe na maaka ya yinti ya nsunga ya bedeliyume, na matadi ya ntalu ya onise. ");
INSERT INTO mkw_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nkumbu ya nzadi ya zole vwandaka Ngiyone. Ni yawu ke zungidilaka yinsi nyonso ya Kuse. ");
INSERT INTO mkw_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nkumbu ya nzadi ya tatu kele Tingele. Ni yawu ke lutaka na esete ya Asule. Nzadi ya yiya vwandaka Efalate. ");
INSERT INTO mkw_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yave Nzambi bakaka muntu mpe yandi tulaka yandi na kati ya bilanga ya Edeni samu na kusalaka bilanga mpe na kukebaka yawu. ");
INSERT INTO mkw_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yave Nzambi pesaka muntu Musiku yayi: «Nge lenda kudya ya nge bambuma ya bayinti nyonso yina kele na bilanga, ");
INSERT INTO mkw_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kasi nge fwana kudya ve bambuma ya yinti yina ke pesaka luzabu ya yimbi na mbote, samu ti kilumbu yina nge ke kudya yawu, kaka kufwa nge ke kufwa!» ");
INSERT INTO mkw_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Na manima, Yave Nzambi tubaka: «Ya kele mbote ve ti muntu kuvwanda kaka yandi mosi. Mu fwana kuyidikila yandi kisadisi yina me fwanana na yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Yave Nzambi bakaka ntoto na kuyidika bibulu na bandeke ya mutindu na mutindu. Yandi nataka yawu na mantwala ya muntu samu na kutala wapi mutindu muntu ke bokila yawu. Mpe konso kibulu kuzwaka nkumbu yina muntu pesaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Muntu pesaka bankumbu na bibulu nyonso ya bwala na ya mfinda, mpe na bandeke nyonso. Kasi yandi talaka ve kisadisi yina fwananaka na yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Na yina, Yave Nzambi lalisaka muntu pongi mosi ya ngolo, mpe yandi katulaka yandi lubanzi mosi. Na manima, yandi kangaka musuni na kisika yina. ");
INSERT INTO mkw_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Na lubanzi yina yandi bakaka na muntu, Yave Nzambi yidikaka kento mosi, mpe yandi nataka kento yango na sika ya bakala. ");
INSERT INTO mkw_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ntangu bakala talaka kento yango, yandi lookaka: «Tala mbala yayi mukwa ya mikwa ya munu, mpe musuni ya musuni ya munu. Ba ke bokila yandi kento, samu ti yandi me katuka na bakala.» ");
INSERT INTO mkw_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ni yawu yina, bakala ke bika tata mpe mama ya yandi, samu na kwenda zinga kintwadi na kento ya yandi, mpe bawu ke kuma nzutu mosi. ");
INSERT INTO mkw_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Kento na bakala vwandaka ve ya kuvwata binkuti na nzutu, kasi bawu vwandaka tala nsoni ve, bawu na bawu. ");
INSERT INTO mkw_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Na kati ya bibulu nyonso ya mfinda yina Yave Nzambi yidikaka, ni nyoka lutilaka mayela ya kuvuna. Na yina, yandi yufulaka kento: «Ya kele ya tsyelika ti Nzambi zabisaka beno ti: “Beno fwana kudya ve bambuma nyonso ya bayinti ya bilanga”?» ");
INSERT INTO mkw_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kento vutulaka na nyoka: «Ve! Beto lenda kudya ya beto bambuma yina kele na bilanga. ");
INSERT INTO mkw_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kasi, samu na bambuma ya yinti yina kele na kati-kati ya bilanga, Nzambi tubaka: “Beno fwana kudya yawu ve, mpe beno kusimba yawu ve, kana beno sala yawu, beno ke kufwa.”» ");
INSERT INTO mkw_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nyoka vutulaka na kento: «Ve! Beno ke kufwa ve! ");
INSERT INTO mkw_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nzambi tubaka mutindu yina samu ti yandi zaba mbote ti, kilumbu yina beno ke kudya yawu, meso ya beno ke funguka, beno ke kuma mutindu banzambi yina ke na mayela ya kuzaba yimbi na mbote.» ");
INSERT INTO mkw_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kento talaka ti bambuma ya yinti yina vwandaka mbote na kudya, kitoko na kutala, mpe mbote na kupesa mayela ya kuswasikisa. Na yina, yandi bakaka mbuma mosi mpe yandi kudyaka yawu. Na manima ya kudya yawu, yandi pesaka yawu mpe na bakala ya yandi yina vwandaka na yandi kuna. Bakala ya yandi mpe kudyaka yawu. ");
INSERT INTO mkw_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Mbala mosi, meso ya bawu fungukaka, bawu bakulaka ti bawu nyonso zole vwandaka banzutu mpamba. Bawu bakaka makasa ya yinti ya fike mpe bawu yidikaka na yawu bilele ya kufukila. ");
INSERT INTO mkw_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Na nkokila, ntangu mwa mupepe ya madidi vwandaka fula, bawu kuwaka makelele ya Yave Nzambi yina vwandaka tambula na kati ya bilanga ya bayinti. Na yina, kento na bakala ya yandi, bawu kwendaka bumbama ntama ya Yave Nzambi, na kati-kati ya bayinti ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yave Nzambi bokilaka bakala mpe yufulaka yandi: «Wapi sika nge kele?» ");
INSERT INTO mkw_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Bakala vutulaka: «Mu me kuwa nge na kutambula na kati ya bilanga ya bayinti, mu me kuzwa boma samu ti mu kele nzutu mpamba, ni yawu yina, mu me bumbama!» ");
INSERT INTO mkw_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yave Nzambi yufulaka dyaka yandi: «Nani me zabisa nge ti nge kele nzutu mpamba? Nge me kudya mbuma ya yinti yina mu yiminaka nge na kudya?» ");
INSERT INTO mkw_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Bakala vutulaka: «Ni kento yina nge pesaka munu, ni yandi me pesa munu mbuma ya yinti yina, mpe mu me kudya yawu!» ");
INSERT INTO mkw_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Na yina, Yave Nzambi yufulaka kento: «Samu na yinki nge me sala mutindu yina?» Kento vutulaka: «Ni nyoka me vuna munu! Ni yawu yina, mu me kudya yawu!» ");
INSERT INTO mkw_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yave Nzambi tubaka na nyoka: «Samu ti nge me sala mutindu yina, mu me siinga nge na kati ya bibulu nyonso. Nge ke banda na kusyelumukaka na ntoto, nge ke banda na kudyaka fundu-fundu, bilumbu nyonso ya luzingu ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mu ke tula kitantu na kati ya nge na kento, na kati ya bana ya nge na bana ya yandi. Bawu ke kosona nge yintu, nge, nge ke tatika bawu na kinkoso.» ");
INSERT INTO mkw_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Yandi tubaka na kento: «Nge ke banda na kutalaka mpasi mingi, ntangu nge ke vwanda na kivumu. Ni na mpasi nge ke banda na kubutilaka. Zaba ti, nge ke banda na kuvwandaka kaka na nsatu ya bakala ya nge, kasi bakala ya nge ke banda na kuyalaka nge.» ");
INSERT INTO mkw_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Yandi tubaka na Adami: «Nge me kuwa mambu ya kento ya nge, nge me kudya mbuma yina mu yiminaka nge. Na yina, mu ke siinga ntoto samu na nge. Ni na mpasi nge ke banda na kuzwaka madya, bilumbu nyonso ya luzingu ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ntoto ke menisila nge bayinti ya bansende mpe bansolokoto. Nge ke banda na kudyaka bima yina ke menaka na bilanga. ");
INSERT INTO mkw_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Nge ke banda na kuzwaka madya na mutoki ya kizizi ya nge, tii kilumbu yina nge ke vutuka na ntoto, sika ba bakaka nge. Ya tsyelika nge kele fundu-fundu, ni na fundu-fundu nge ke vutuka.» ");
INSERT INTO mkw_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Bakala pesaka kento ya yandi nkumbu Eva, samu ti ni yandi kele mama ya bantu nyonso yina kele moyo. ");
INSERT INTO mkw_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yave Nzambi yidikilaka Adami na kento ya yandi binkuti na bampusu ya bibulu, mpe yandi lwatisaka bawu yawu. ");
INSERT INTO mkw_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yave Nzambi tubaka: «Tala! Muntu me kuma mutindu mosi na beto, yandi me zaba yimbi na mbote. Yandi fwana kubaka ve mbuma yina ke pesaka luzingu. Samu ti kana yandi kudya yawu, yandi ke zinga bamvula na bamvula!» ");
INSERT INTO mkw_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ni yawu yina, Yave Nzambi bingisaka muntu na bilanga ya Edeni, samu ti yandi kwenda sala bilanga, ntoto yina ba bakaka na kuyidikila yandi. ");
INSERT INTO mkw_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Na manima ya kubingisa muntu, Yave Nzambi tulaka bakeluba ya kusimba bambele ya mvita ya tiya, na lweka ya esete ya bilanga ya Edeni, samu na kukengidila nzila yina ke kwendaka na yinti ya luzingu. ");
INSERT INTO mkw_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adami vukanaka na kento ya yandi Eva. Eva kuzwaka kivumu mpe yandi butaka Kayini. Eva tubaka: «Mu me buta muntu na lusalusu ya Yave.» ");
INSERT INTO mkw_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Na manima, yandi butaka dyaka mpangi ya yandi Abele. Ntangu bawu kulaka, Abele kumaka muvungi ya mameme, Kayini kisadi-bilanga. ");
INSERT INTO mkw_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Na manima ya bilumbu, Kayini bakaka bima yina yandi kuzwaka na bilanga ya yandi, mpe yandi kwendaka pesa yawu munkayulu na Yave. ");
INSERT INTO mkw_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abele mpe bakaka bana ya ntete ya bibulu ya yandi mpe na mafuta ya bawu, yandi pesaka yawu munkayulu na Yave. Yave yangalalaka na Abele, mpe yandi ndimaka munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kasi Yave yangalalaka ve na Kayini, mpe yandi ndimaka ve munkayulu ya yandi. Na yina, Kayini dasukaka mpe kangaka mbunzu. ");
INSERT INTO mkw_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yave tubaka na Kayini: «Samu na yinki nge me dasuka? Mpe samu na yinki nge me kanga mbunzu? ");
INSERT INTO mkw_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kana nge sala mbote, nge ke vumbula yintu. Kana nge sala ve mbote, zaba ti disumu kele ya kulala na mwelo ya nge mutindu kibulu ya nsisi. Yawu ke na nsatu ya kuyala nge, kasi nge, nge fwana kuyala yawu.» ");
INSERT INTO mkw_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Na manima, Kayini sololaka na leki ya yandi Abele. Ntangu bawu kumaka na bilanga, Kayini nwanisaka leki ya yandi Abele, mpe kufwaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yave yufulaka Kayini: «Wapi leki ya nge Abele?» Kayini vutulaka: «Mu zaba ya munu ve. Ni munu ke kebaka leki ya munu?» ");
INSERT INTO mkw_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yave tatamanaka na kutuba: «Samu na yinki nge me sala mutindu yina? Mu ke na kuwa ndinga ya menga ya leki ya nge yina ke na kuyawula na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kubanda bubu yayi, nge ke vwanda ya kusiingwa samu na menga ya leki ya nge, menga yina ntoto me fungula yinwa samu na kumina yawu. Na yina, ba ke bingisa nge. ");
INSERT INTO mkw_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ntangu nge ke sala bilanga, ntoto ke buta mbote ve. Nge ke banda na kwendaka tambula kidi-kidi mpe kuyenga-yenga na yinza ya muvimba.» ");
INSERT INTO mkw_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayini zonzaka na Yave: «Kitumbu yina nge me pesa munu me lutila dema na kunata. ");
INSERT INTO mkw_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mutindu bubu yayi nge me bingisa munu na ntoto yayi, mu ke vwanda ya kubumbama na meso ya nge, mu ke banda na kwendaka tambula kidi-kidi mpe kuyenga-yenga bisika nyonso. Muntu ni muntu yina ke kutana na munu ke kufwa munu.» ");
INSERT INTO mkw_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yave zonzaka na yandi: «Kana muntu kufwa nge, lufwa ya nge ke futama bambala nsambwadi.» Na yina, Yave tulaka kidimbu na Kayini samu ti, muntu ni muntu yina ke kutana na Kayini kufwa yandi ve. ");
INSERT INTO mkw_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Na yina, Kayini kwendaka vwanda na yinsi yina ba ke bokilaka Node, na esete ya Edeni, ntama na Yave. ");
INSERT INTO mkw_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayini vukanaka na kento ya yandi, mpe kento ya yandi kuzwaka kivumu. Yandi butaka mwana ya bakala yina bawu pesaka nkumbu Enoke. Kayini tungaka mbanza mpe yandi pesaka yawu nkumbu ya mwana ya yandi Enoke. ");
INSERT INTO mkw_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoke butaka Ilade, Ilade butaka Mewuyayele, Mewuyayele butaka Metusayele, mpe Metusayele butaka Lameke. ");
INSERT INTO mkw_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameke kwelaka bakento zole. Ya ntete vwandaka Ada, ya zole Sila. ");
INSERT INTO mkw_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada butaka Yabale: Ni Yabale vwandaka nkooko ya bantu yina ke zingaka na bayinzo ya lele mpe ke yundulaka bibulu. ");
INSERT INTO mkw_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Nkumbu ya mpangi ya yandi vwandaka Yubale. Ni Yubale vwandaka nkooko ya bantu yina ke sikaka nsambi mpe dituutu. ");
INSERT INTO mkw_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila mpe butaka Tubale-Kayini. Tubale-Kayini vwandaka kisadi-bisengo. Yandi vwandaka yidika konso kisalulu ya kisengo na ya kisengo ya mbwaki. Nkumbu ya kibusi ya Tubale-Kayini vwandaka Naama. ");
INSERT INTO mkw_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameke tubaka na bakento ya yandi mutindu yayi: «Ada mpe Sila, beno kuwa munu! Bakento ya munu, beno fungula makutu na kuwa mambu ya munu. Mu me kufwa muntu samu ti yandi me lwalisa munu. Mu me kufwa ntwenya samu ti yandi me bula munu. ");
INSERT INTO mkw_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kana lufwa ya Kayini ke futama bambala nsambwadi, lufwa ya Lameke ke futama bambala makumi nsambwadi na nsambwadi.» ");
INSERT INTO mkw_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adami vukanaka dyaka na kento ya yandi Eva. Eva butaka mwana ya bakala. Yandi pesaka yandi nkumbu Sete, samu ti yandi tubaka: «Nzambi me pesa munu mwana ya nkaka na kisika ya Abele, yina Kayini kufwaka.» ");
INSERT INTO mkw_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sete mpe butaka mwana ya bakala, yandi pesaka yandi nkumbu Enose. Ni na ntangu yina, bantu bandaka na kusambila Nzambi na Nkumbu ya Yave. ");
INSERT INTO mkw_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Yayi ni mukanda ya bankumbu ya bana ya Adami. Ntangu Nzambi yidikaka muntu, yandi yidikaka muntu na kifwani ya Nzambi. ");
INSERT INTO mkw_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Yandi yidikaka kento na bakala. Yandi sakumunaka bawu mpe yandi bokilaka bawu bantu na kilumbu yina yandi yidikaka bawu. ");
INSERT INTO mkw_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ntangu Adami lungisaka bamvula nkama na makumi tatu (130), yandi butaka mwana yina vwandaka mutindu yandi, na kifwani ya yandi. Yandi pesaka yandi nkumbu Sete. ");
INSERT INTO mkw_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Na manima ya mbutukulu ya Sete, Adami zingaka bamvula bankama nana (800). Adami butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adami zingaka bamvula bankama yivwa na makumi tatu (930) mpe yandi kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ntangu Sete lungisaka bamvula nkama na tanu (105), yandi butaka Enose. ");
INSERT INTO mkw_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Na manima ya mbutukulu ya Enose, Sete zingaka bamvula bankama nana na nsambwadi (807). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sete zingaka bamvula bankama yivwa na kumi na zole (912), mpe yandi kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ntangu Enose lungisaka bamvula makumi yivwa, yandi butaka Kenane. ");
INSERT INTO mkw_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Na manima ya mbutukulu ya Kenane, Enose zingaka bamvula bankama nana na kumi na tanu (815). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enose zingaka bamvula bankama yivwa na tanu (905), mpe yandi kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ntangu Kenane lungisaka bamvula makumi nsambwadi, yandi butaka Maalalele. ");
INSERT INTO mkw_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Na manima ya mbutukulu ya Maalalele, Kenane zingaka bamvula bankama nana na makumi yiya (840). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenane zingaka bamvula bankama yivwa na kumi (910), mpe yandi kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ntangu Maalalele lungisaka bamvula makumi sambanu na tanu, yandi butaka Yelede. ");
INSERT INTO mkw_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Na manima ya mbutukulu ya Yelede, Maalalele zingaka bamvula bankama nana na makumi tatu (830). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Maalalele zingaka bamvula bankama nana na makumi yivwa na tanu (895), mpe yandi kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ntangu Yelede lungisaka bamvula nkama na makumi sambanu na zole (162), yandi butaka Enoke. ");
INSERT INTO mkw_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Na manima ya mbutukulu ya Enoke, Yelede zingaka bamvula bankama nana (800). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ntangu Yelede lungisaka bamvula bankama yivwa na makumi sambanu na zole (962), yandi kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ntangu Enoke lungisaka bamvula makumi sambanu na tanu, yandi butaka Metusela. ");
INSERT INTO mkw_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoke vwandaka tambula kintwadi na Nzambi. Na manima ya mbutukulu ya Metusela, yandi zingaka bamvula bankama tatu (300). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoke zingaka bamvula bankama tatu na makumi sambanu na tanu (365). ");
INSERT INTO mkw_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoke tambulaka kintwadi na Nzambi. Na manima, yandi zimbanaka, samu ti Nzambi bakaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ntangu Metusaleme lungisaka bamvula nkama na makumi nana na nsambwadi (187), yandi butaka Lameke. ");
INSERT INTO mkw_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Na manima ya mbutukulu ya Lameke, Metusaleme zingaka bamvula bankama nsambwadi na makumi nana na zole (782). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusaleme zingaka bamvula bankama yivwa na makumi sambanu na yivwa (969), mpe yandi kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ntangu Lameke lungisaka bamvula nkama na makumi nana na zole (182), yandi butaka mwana ya bakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Yandi pesaka mwana yina nkumbu Nowa, samu na kutuba ti: «Yandi yayi ke bomba beto samu na bisalu ya beto, mpe mpasi yina beto fwana kutala, samu na kusala ntoto yina Yave siingaka.» ");
INSERT INTO mkw_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Na manima ya mbutukulu ya Nowa, Lameke zingaka bamvula bankama tanu na makumi yivwa na tanu (595). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameke zingaka bamvula bankama nsambwadi na makumi nsambwadi na nsambwadi (777), mpe yandi kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ntangu Nowa lungisaka bamvula bankama tanu (500), yandi butaka Seme, Ame na Yafete. ");
INSERT INTO mkw_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bantu bandaka kukuma mingi na ntoto, mpe bawu butaka bana ya bakento. ");
INSERT INTO mkw_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Bana ya Nzambi yina ke zingaka na zulu talaka ti bana ya bakento ya bantu vwandaka kitoko mingi, mpe ba kwelaka bayina ba soolaka na kati ya bakento yina. ");
INSERT INTO mkw_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Na yina, Yave tubaka: «Kiwumunu yina mu pesaka na bantu, yawu ke zingila na bawu bantangu nyonso ve. Samu ti kilumbu kele yina bawu ke kufwa kwandi. Kubanda bubu yayi, luzingu ya muntu ke luta ve bamvula nkama mosi na makumi zole.» (120) ");
INSERT INTO mkw_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mambu yayi salamaka na ntangu ya ba-Nefilime mpe yawu zingilaka tii na bantangu yina landaka. Ba-Nefilime zingaka na ntoto ntangu bana ya Nzambi kwizaka vukana na bana ya bakento ya bantu, mpe bawu butaka bana. Bana yango yina butukaka, ni bawu vwandaka binwani ya ngolo ya ntangu ya ntama, mpe bankumbu ya bawu vwandaka nsangu. ");
INSERT INTO mkw_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yave talaka ti konso kilumbu, yimbi vwandaka bwelama na ntoto. Konso kilumbu, mayindu ya bantu vwandaka kaka ya kukangama na kusala yimbi. ");
INSERT INTO mkw_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yave nyongaka na yina yandi salaka muntu na ntoto. Dyambu yina talisaka yandi mpasi mingi na ntima. ");
INSERT INTO mkw_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yave tubaka: «Mu ke katula bantu yina mu yidikaka na ntoto, ya vwanda bantu, ya vwanda bibulu ya nene to ya fyoti, ya vwanda bandeke. Mu ke na kunyonga samu na yinki mu yidikaka kwandi bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kasi Yave vwandaka yangalala na Nowa. ");
INSERT INTO mkw_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nowa vwandaka ve mutindu bantu ya ntangu ya yandi. Yandi, yandi vwandaka muntu ya kusungama, muntu ya ntima ya mbote. Yandi vwandaka tambula kintwadi na Nzambi. Yayi ni mukanda ya bankumbu ya bana ya Nowa. ");
INSERT INTO mkw_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowa butaka bana tatu: Seme, Ame, na Yafete. ");
INSERT INTO mkw_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Na meso ya Nzambi, yinza ya muvimba bebaka. Kaka mambu ya yimbi vwandaka talana bisika nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ntangu Nzambi talaka yinza, yinza talanaka ya kubeba. Bantu nyonso vwandaka ya kufuluka na bifu ya yimbi. ");
INSERT INTO mkw_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ni yawu yina, Nzambi tubaka na Nowa mutindu yayi: «Mu me baka nzengolo ya kufwa bantu nyonso. Ni bawu bantu me sala ti ntoto ya muvimba kufuluka na yimbi. Mu ke bebisa bawu mbala mosi na ntoto nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Baka bayinti ya ngolo, nge yidika ya nge nzaza. Sala bivinga mingi na kati ya yawu. Nge tula yawu guludon na kati mpe na ngaanda. ");
INSERT INTO mkw_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nge sala yinda ya yawu ya Bakude bankama tatu (300), nene ya yawu Bakude makumi tanu, mpe mutela ya yawu Bakude makumi tanu. ");
INSERT INTO mkw_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Nge yidikila yawu muludi. Kasi nge fwana kubika mwasi Kude mosi na kati-kati ya muludi yina na bibaka ya nzaza. Mwelo ya nzaza ke vwanda na kibaka mosi. Nge ke sala nzaza nyonso na bibandu tatu. ");
INSERT INTO mkw_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Munu, mu ke fulusa yinza nyonso na maza. Mpe maza yina ke kufwa kima ni kima yina ke wumunaka. Nyonso na ntoto ke manisa na kufwa. ");
INSERT INTO mkw_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kasi mu ke sala ngwisani na nge. Beno ke kota na nzaza, nge na kento ya nge, mpe bana ya nge na bakento ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nge ke baka bima ya konso mutindu yina ke wumunaka. Nge ke kotisa yawu zole-zole na nzaza, ya nkento na ya mbakala, samu ti yawu tatamana na kuzinga na nge. ");
INSERT INTO mkw_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Bandeke ya konso mutindu, mpe bibulu ya konso mutindu, ya nene na ya fyoti-fyoti, bawu ke kwiza zole-zole pene-pene ya nge, samu ti bawu kufwa ve. ");
INSERT INTO mkw_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Nge, nge fwana yonzika bima ya mutindu na mutindu, yina ba ke kudyaka. Ni yawu ke vwanda madya ya beno, na nge na bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Mpe Nowa salaka nyonso yina Nzambi tumisaka yandi. Ni mutindu yina yandi salaka. ");
INSERT INTO mkw_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yave tubaka na Nowa: «Kota na nzaza, nge na dikanda ya nge. Samu ti na mbandu yayi, kaka ni nge mu me tala muntu ya kudedama na meso ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Nge ke baka bibulu nsambwadi ya nkento mpe bibulu nsambwadi ya mbakala na kati ya bibulu ya kuvedila ya konso mutindu. Na kati ya bibulu yina kele ya kuvedila ve, nge ke baka mosi ya nkento mpe mosi ya mbakala, ya konso mutindu. ");
INSERT INTO mkw_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Mutindu mosi mpe na kati ya bandeke: nge ke baka nsambwadi ya nkento mpe ya mbakala ya konso mutindu, samu ti yawu kuzimbana ve na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Samu ti kaka bilumbu nsambwadi me bikana, munu, mu ke nokisa mvula na ntoto nyonso, mpimpa na ntangu, bilumbu makumi yiya ya muvimba. Mu ke kufwa bima nyonso yina mu salaka na ntoto yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Mpe Nowa salaka nyonso mutindu Yave tumisaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowa vwandaka na bamvula bankama sambanu (600) ntangu maza kwizaka dyamisa ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nowa kotaka na nzaza, yandi na kento ya yandi, mpe bana ya yandi na bakento ya bawu, samu na kukima maza yina. ");
INSERT INTO mkw_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Na bibulu ya kuvedila, na yina kele ve ya kuvedila, na bandeke, na bibulu ya fyoti-fyoti yina ke tambulaka na ntoto, ");
INSERT INTO mkw_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","bawu nyonso, zole-zole, ya nkento na ya mbakala, bawu kwizaka na sika ya Nowa na kati ya nzaza, mutindu Nzambi tumisaka. ");
INSERT INTO mkw_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Na manima ya bilumbu nsambwadi, maza dyamisaka ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ntangu Nowa kwizaka lungisa bamvula nkama sambanu (600), na kilumbu yina ya kumi na nsambwadi ya ngonda ya zole, maza ya yisi ya ntoto basikaka na ngolo, banela ya mazulu mpe fungukaka. ");
INSERT INTO mkw_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mvula bandaka na kunoka na ntoto. Yawu tatamanaka na kunoka bilumbu makumi yiya ya muvimba, mpimpa na ntangu. ");
INSERT INTO mkw_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ni na kilumbu yina Nowa kotaka na kati ya nzaza, na kento ya yandi, mpe na bana ya yandi: Seme, Ame, na Yafete, na bakento ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nowa kotaka mpe na bibulu ya mutindu na mutindu, ya mfinda na ya bwala, bibulu ya fyoti-fyoti, bandeke ya konso mutindu, mpe bima ya moyo yina kele na mapapu. ");
INSERT INTO mkw_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Na bima ya konso mutindu yina ke wumunaka, zole-zole kwizaka na sika ya Nowa, na kati ya nzaza. ");
INSERT INTO mkw_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Bima ya konso mutindu yina ke wumunaka vwandaka kwiza kota, nkento na mbakala, mutindu Nzambi tumisaka yawu na Nowa. Na manima, Yave kangaka mwelo ya nzaza. ");
INSERT INTO mkw_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mvula ya nene salaka bilumbu makumi yiya kaka kunoka na kunoka. Maza kumaka mingi ya kulutila, mpe yawu nangunaka nzaza na zulu ya ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Maza tatamanaka na kubwelama, yawu kumaka mingi na ntoto, mpe nzaza vwandaka kwenda yangama na zulu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Maza kwizaka kuma mingi ya kulutila, tii na kudyamisa myongo yina me lutila nene na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Bansongi ya myongo yango kwizaka dyama na Bakude kumi na tanu na kati ya maza. ");
INSERT INTO mkw_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ni kuna bima nyonso ya moyo, yina ke zingaka na ntoto kufwaka: bandeke, bibulu ya bwala mpe ya mfinda, bima nyonso ya fyoti-fyoti yina ke tambulaka na ntoto, na bantu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Bima nyonso yina vwandaka wumuna, nyonso yina vwandaka na ntoto kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ni mutindu yina Nzambi katulaka nyonso yina vwandaka moyo na ntoto: kubanda na bantu tii na bibulu ya nene mpe ya fyoti-fyoti, tii na bandeke. Nzambi kufwaka bawu nyonso na ntoto. Kaka Nowa bikanaka, yandi na bayina vwandaka na yandi na kati ya nzaza. ");
INSERT INTO mkw_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Maza vwandaka ya kufuluka na ntoto tii bilumbu nkama mosi na makumi tanu (150). ");
INSERT INTO mkw_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nzambi bambukilaka Nowa moyo, na bibulu nyonso ya bwala mpe ya mfinda yina vwandaka kintwadi na yandi na kati ya nzaza. Yandi fidisaka kitembo na zulu ya maza, mpe maza bandaka na kukuluka. ");
INSERT INTO mkw_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Maza ya yisi ya ntoto bikaka na kubasika. Banela ya dizulu kangamaka, mpe mvula bikaka na kunoka. ");
INSERT INTO mkw_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Na manima ya bilumbu nkama mosi na makumi tanu (150), maza bandaka na kuyuma malembe-malembe. ");
INSERT INTO mkw_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Na kilumbu ya kumi na nsambwadi ya ngonda ya nsambwadi, nzaza kwendaka kangama na myongo ya kizunga ya Alalate. ");
INSERT INTO mkw_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Maza tatamanaka na kukawuka tii na ngonda ya kumi. Na kilumbu ya ntete ya ngonda yina ya kumi, bansongi ya myongo kwizaka talana. ");
INSERT INTO mkw_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Na manima ya bilumbu makumi yiya, Nowa fungulaka nela yina yandi salaka na nzaza. ");
INSERT INTO mkw_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Yandi bikaka nkwankwa kukwenda. Nkwankwa basikaka, yawu kwendaka, mpe vutukaka bambala mingi tii kukawuka ya maza na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Na manima, yandi bikaka dibembe kukwenda, samu na kutala kana maza kulukaka na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kasi dibembe yango kuzwaka ve kisika ya kutentama. Ni yawu yina, yawu vutukaka na sika ya Nowa, kuna na nzaza, samu ti maza vwandaka ntete na zulu ya ntoto nyonso. Nowa lambulaka diboko na kubaka yawu mpe kukotisa yawu na nzaza. ");
INSERT INTO mkw_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Yandi vingilaka dyaka bilumbu nsambwadi ya nkaka. Na manima, yandi bikaka dyaka dibembe kudumuka na ngaanda ya nzaza. ");
INSERT INTO mkw_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Na nkokila dibembe yango vutukaka na sika ya yandi. Yawu vwandaka na kintala ya yinti ya olive na yinwa. Ni mutindu yina Nowa zabaka ti maza vwandaka me kuluka na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nowa vingilaka dyaka bilumbu nsambwadi ya nkaka. Na manima, yandi bikaka dibembe kukwenda, kasi yawu vutukaka dyaka ve na nzaza. ");
INSERT INTO mkw_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Na kilumbu ya ntete ya ngonda ya ntete, na mvula yina Nowa lungisaka bamvula bankama sambanu na mosi (601), maza sikaka na ntoto. Nowa katulaka muludi ya nzaza, mpe yandi talaka ti ntoto vwandaka me yuma. ");
INSERT INTO mkw_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Na kilumbu ya makumi zole na nsambwadi ya ngonda ya zole, ntoto vwandaka ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nzambi zonzaka na Nowa mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Basika na nzaza, nge, na kento ya nge, na bana ya nge, na bakento ya bana ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bibulu nyonso yina kele kintwadi na nge, konso mutindu ya bandeke, konso mutindu ya bibulu ya nene na ya fyoti-fyoti yina ke tambulaka na ntoto, basisa bawu nzila mosi na nge. Bawu fwana kutambula na ntoto, kubutana, mpe kukuma mingi.» ");
INSERT INTO mkw_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nowa basikaka na bana ya yandi, na kento ya yandi, mpe na bakento ya bana ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Makanda na makanda ya bibulu nyonso, bibulu ya fyoti-fyoti, bandeke nyonso, mpe makanda na makanda ya nyonso yina ke tambulaka na ntoto, bawu basikaka na nzaza. ");
INSERT INTO mkw_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nowa yidikaka kiyokolo ya minkayulu samu na Yave. Yandi bakaka mosi-mosi na konso mutindu ya bibulu ya kuvedila, na konso mutindu ya bandeke ya kuvedila, mpe yandi yokaka yawu mutindu minkayulu ya kuyoka na zulu ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yave kuwaka nsunga ya kitoko mpe kanisaka mutindu yayi: «Mu ke siinga dyaka ve ntoto samu na muntu. Ya tsyelika, ntima ya muntu kele ya kukangama na yimbi kubanda buntwenya ya yandi. Mu ke kufwa dyaka ve nyonso yina kele moyo mutindu mu me sala yawu. ");
INSERT INTO mkw_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","«Bantangu nyonso yina ntoto ke zingila, kukunda bambuma mpe kuyonzika yawu, madidi mpe tiya, ntangu ya bamvula mpe ntangu ya madidi ya ngolo, mpimpa na ntangu, yawu ke manisa ve.» ");
INSERT INTO mkw_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nzambi sakumunaka Nowa na bana ya yandi. Yandi tubaka na bawu: «Beno butana, beno kuma mingi, mpe beno fulusa ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Konso kibulu ya ntoto, konso ndeke ya dizulu, konso kima yina ke tambulaka na ntoto, bambisi nyonso ya mubu, yawu ke banda na kukimaka beno. Yawu ke banda na kutalaka beno boma. Yawu me pesama na maboko ya beno. ");
INSERT INTO mkw_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nyonso yina ke tambulaka mpe kele moyo, yawu ke vwanda madya ya beno, mutindu beno ke kudyaka ndunda. Mu me pesa beno yawu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Kasi beno fwana kudya ve musuni yina kele ntete na mwela ya yawu, yawu zola kutuba musuni yina ke ntete na menga ya yawu. ");
INSERT INTO mkw_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mutindu mosi mpe menga ya beno, yina kele mwela ya beno, mu ke yufula yawu na konso kibulu, mu ke yufula yawu mpe na muntu. Mu ke yufula menga ya muntu na muntu yina ke kufwa mpangi ya yandi muntu. ");
INSERT INTO mkw_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","«Muntu yina ke mwangisa menga ya muntu, ni muntu mpe ke mwangisa menga ya yandi. Samu ti Nzambi yidikaka muntu na kifwani ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Na yina me tadila beno, beno butana, beno kuma mingi. Beno fulusa ntoto, mpe beno kuma mingi na ntoto.» ");
INSERT INTO mkw_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Nzambi tubaka na Nowa na bana ya yandi: ");
INSERT INTO mkw_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Munu, mu ke na kusala ngwisani ya munu na beno, na bayina nyonso ke butuka na manima ya beno, ");
INSERT INTO mkw_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na bima nyonso ya moyo yina kele kintwadi na beno: ya vwanda ndeke, ya vwanda kibulu ya bwala, ya vwanda konso kibulu ya mfinda, yina kele kintwadi na beno, na bayina nyonso yina me basika na nzaza, na konso kibulu ya ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mu ke sala ngwisani ya munu na beno: mu ke kufwa dyaka ve ata kima ya moyo na maza ya mingi. Bamvula ya nene yina lenda dyamisa ntoto ke noka dyaka ve.» ");
INSERT INTO mkw_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nzambi tubaka dyaka: «Yayi ni kidimbu yina mu me tula na kati-kati ya munu na beno, mpe na konso kima ya moyo yina kele kintwadi na beno, na bambandu nyonso yina ke kwiza. Kidimbu yina ke bambula moyo na ngwisani ya munu na beno. ");
INSERT INTO mkw_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mu me tula mukyama ya munu na matuti. Yawu ke kuma kidimbu ya ngwisani na kati ya munu na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ntangu mu ke basisa matuti na dizulu, mukyama ke talana na dituti, ");
INSERT INTO mkw_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mu ke bambuka moyo na ngwisani ya munu na beno, mpe na konso kima ya moyo. Mpe maza ke fuluka dyaka ve samu na kufwa bantu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mukyama ke vwanda na dituti, mpe mu ke tala yawu samu na kubambuka moyo na ngwisani ya mankululu na munu Nzambi na konso kima ya moyo yina kele na ntoto.» ");
INSERT INTO mkw_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nzambi tubaka na Nowa: «Yayi ni kidimbu ya ngwisani yina mu me sala na kati ya munu na bayina nyonso kele na ntoto.» ");
INSERT INTO mkw_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Bana ya Nowa yina basikaka na nzaza vwandaka: Seme, Ame na Yafete. Seme vwandaka tata ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ni na bana tatu yayi ya Nowa katukaka bantu yina mwanganaka na yinza. ");
INSERT INTO mkw_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa, yina vwanda kisadi-bilanga, bandaka na kusala bilanga ya bayinti ya vinu. ");
INSERT INTO mkw_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kilumbu mosi, Nowa kunwaka vinu. Yandi kolaka mpe bikanaka kipene na kati ya yinzo ya yandi ya lele. ");
INSERT INTO mkw_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ame, tata ya Kaana talaka kimpene ya tata ya yandi, mpe yandi kwendaka zabisa yawu na bampangi ya yandi zole, yina vwandaka na ngaanda. ");
INSERT INTO mkw_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Na yina, Seme na Yafete bakaka kiyunga. Bawu tulaka yawu na zulu ya magembo ya bawu, mpe bawu bandaka na kutambula na kwendaka vutuka manima. Bawu kwendaka fuka kimpene ya tata ya bawu. Mutindu bizizi ya bawu vwandaka tala kisika ya nkaka, bawu talaka ve kimpene ya tata ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ntangu ngolo ya malafu manisaka yandi, Nowa kuwaka mambu yina mwana-nsuka ya yandi salaka. ");
INSERT INTO mkw_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nowa tubaka: «Mu me siinga Kaana! Bika ti yandi kuvwanda muntu ya mansukina na mindongo ya bampangi ya yandi!» ");
INSERT INTO mkw_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nowa tubaka dyaka: «Nkembo na Yave, Nzambi ya Seme! Bika ti Kaana kuvwanda mundongo ya Seme! ");
INSERT INTO mkw_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Bika ti Nzambi kupesa Yafete ntoto ya nene. Bika ti Yafete kuzinga na kati ya bayinzo ya lele ya Seme, mpe Kaana kuvwanda mundongo ya Yafete!» ");
INSERT INTO mkw_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Na manima ya ntangu yina maza kwizaka fulusa yinza, Nowa zingaka dyaka bamvula bankama tatu na makumi tanu (350). ");
INSERT INTO mkw_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nowa zingaka bamvula bankama yivwa na makumi tanu (950), mpe yandi kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Na manima ya ntangu yina maza kwizaka dyamisa yinza, bana ya Nowa, Seme, Ame na Yafete butaka bana. Yayi ni mukanda ya bankumbu ya bana ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Bana ya Yafete ni: Ngomele, Mangonge, Mede, Yavane, Tubale, Meseke na Tilase. ");
INSERT INTO mkw_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Bana ya Ngomele ni: Asekenaze, Lifate na Tongalema. ");
INSERT INTO mkw_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Bana ya Yavane ni: Elisa, Talesise, Kitime na Lodanime. ");
INSERT INTO mkw_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ni na bawu butukaka bantu yina mwanganaka na bayinsi yina kele pene-pene ya mubu. Bawu kabukaka na bayinsi mutindu vwandaka bandinga ya bawu, mpe bawu kabukaka makanda na makanda mutindu vwandaka bifumba ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Bana ya Ame ni: Kuse, Miselayime, Pute mpe Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Bana ya Kuse ni: Seba, Avila, Sabeta, Layema, Sabeteka. Bana ya Layema ni: Saba na Dedane. ");
INSERT INTO mkw_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuse butaka mpe Nimelode. Nimelode vwandaka kinwani ya ntete ya kufuluka na ngolo awa na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yandi vwandaka kikubudi ya nene na meso ya Yave. Ni yawu yina, bantu ke tubaka: «Vwanda kikubudi ya nene na meso ya Yave mutindu Nimelode.» ");
INSERT INTO mkw_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kimfumu ya yandi bandaka na bambanza yayi: Babele, Eleke, Akade na Kalene na yinsi ya Sineyale. ");
INSERT INTO mkw_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Na manima, yandi katukaka na yinsi yina, yandi kwendaka na Asule. Yandi tungaka mbanza Ninive, mbanza Leyobote-Ile mpe mbanza Kala, ");
INSERT INTO mkw_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","mpe Lesene yina kele mbanza ya nene na kati-kati ya Ninive mpe Kala. ");
INSERT INTO mkw_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Miselayime butaka ba-Lude, ba-Eyiname, ba-Leyabe, ba-Nafetuwa, ");
INSERT INTO mkw_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ba-Patelose, ba-Kaseluwa na ba-Kafetole. Ni ba-Kaseluwa butaka ba-Filiseti. ");
INSERT INTO mkw_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kaana butaka Sidone, mwana ya yandi ya ntete. Yandi butaka mpe Ete, ");
INSERT INTO mkw_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ba-Yebuse, ba-Amoli, ba-Ngilengazi, ");
INSERT INTO mkw_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ba-Ivi, ba-Aleki, ba-Sini, ");
INSERT INTO mkw_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ba-Alevade, ba-Semali na ba-Yamate. Na manima, bifumba ya ba-Kaanani mwanganaka bisika mingi. ");
INSERT INTO mkw_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Bandilu ya yinsi ya ba-Kaanani vwandaka banda katuka Sidone tii na Ngaza na kutalisa na Ngelale mpe na lweka ya Sodome, Ngomole, Adema mpe na lweka ya Seboyime tii na Lesa. ");
INSERT INTO mkw_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ni bawu yina vwandaka bana ya Ame, mutindu vwandaka makanda ya bawu mpe bandinga ya bawu, bantu na bantu na yinsi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seme mpe butaka bana. Ni yandi vwandaka nkooko ya bana nyonso ya Ebele. Seme vwandaka yaya ya Yafete. ");
INSERT INTO mkw_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Bana ya Seme ni: Elame, Asule, Alepakesade, Lude mpe Alame. ");
INSERT INTO mkw_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Bana ya Alame ni: Wuse, Wule, Ngetele mpe Mase. ");
INSERT INTO mkw_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alepakesade butaka Sela, mpe Sela butaka Ebele. ");
INSERT INTO mkw_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebele butaka bana zole. Ya ntete nkumbu ya yandi Pelenge, samu ti ni na ntangu ya Ebele bantu ya ntoto kabukaka. Nkumbu ya mwana ya yandi ya zole vwandaka Yoketane. ");
INSERT INTO mkw_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoketane butaka Alemodade, Selefe, Yasalemawete, Yela, ");
INSERT INTO mkw_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Yadolame, Wuzale, Dikela, ");
INSERT INTO mkw_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obale, Abimayele, Saba, ");
INSERT INTO mkw_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofile, Avila, Yobabe. Bawu nyonso yina vwandaka bana ya Yoketane. ");
INSERT INTO mkw_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ntoto ya bawu bandaka na Mesa tii na Sefale, myongo yina kele na esete. ");
INSERT INTO mkw_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ni bawu yina vwandaka bana ya Seme, mutindu vwandaka makanda ya bawu mpe bandinga ya bawu, bantu na bantu na yinsi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Yina ni bifumba ya bana ya Nowa, mutindu vwandaka makanda ya bankumbu ya bawu, mpe bayinsi ya bawu. Ni na bawu butukaka bantu nyonso yina mwanganaka na yinza, na manima ya ntangu yina maza dyamisaka yinza. ");
INSERT INTO mkw_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bantu nyonso ya yinza vwandaka zonza kaka ndinga mosi mpe bawu vwandaka sadila bampova mosi. ");
INSERT INTO mkw_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ntangu bawu telamaka na kukwenda na Esete, bawu talaka kizunga mosi ya yinsi ya Sineyale, mpe bawu vwandaka kuna. ");
INSERT INTO mkw_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Bawu zonzaka bawu na bawu: «Beto sala bibiliki, mpe beto yoka yawu.» Bawu bakaka bibiliki na poto-poto yina kele mutindu guludon samu na kutunga. ");
INSERT INTO mkw_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Bawu tubaka: «Beto tunga mbanza, mpe yinzo mosi ya mutela ya yinda yina fwana kukuma tii na dizulu, samu ti beto zabana na ntoto. Na mutindu yina, beto ke vwanda ve ya kumwangana na yinza nyonso, kasi beto ke vwanda kisika mosi.» ");
INSERT INTO mkw_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yave kulumukaka na kutala mbanza na yinzo ya mutela ya yinda yina bantu vwandaka tunga. ");
INSERT INTO mkw_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mpe Yave tubaka: «Tala mutindu bantu yayi kele muntu mosi, ba ke na kuzonza ndinga mosi! Yayi kaka mbandukulu ya mavanga ya bawu! Yina bawu me banda mutindu yayi, ata dyambu mosi ve lenda kukabikisa bawu na kuyidika nyonso yina bawu zola kuyidika. ");
INSERT INTO mkw_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Beto kwenda vwanzikisa dinga ya bawu, samu ti bawu kuwisana dyaka ve bawu na bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yave bingisaka bawu kuna, mpe mwangisaka bawu na ntoto ya muvimba. Na yina, ntungulu ya mbanza yango sukaka na nzila. ");
INSERT INTO mkw_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ni yawu yina, ba ke bokilaka mbanza yina «Babele», samu ti ni kuna Yave vwanzikisaka ndinga ya bantu samu ti bawu kuwisana dyaka ve bawu na bawu. Ni kuna mpe Yave mwangisaka bawu na yinza nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Yayi ni mukanda ya bankumbu ya bana ya Seme. Ntangu maza dyamisaka yinza, bamvula zole lutaka, mpe Seme butaka Alepakesade. Na ntangu yina, Seme lungisaka bamvula nkama. ");
INSERT INTO mkw_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Na manima ya mbutukulu ya Alepakesade, Seme zingaka dyaka bamvula bankama tanu (500). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ntangu Alepakesade lungisaka bamvula makumi tatu na tanu, yandi butaka Sela. ");
INSERT INTO mkw_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Na manima ya mbutukulu ya Sela, Alepakesade zingaka dyaka bamvula bankama yiya na tatu (403). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ntangu Sela lungisaka bamvula makumi tatu, yandi butaka Ebele. ");
INSERT INTO mkw_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Na manima ya mbutukulu ya Ebele, Sela zingaka dyaka bamvula bankama yiya na tatu (403). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ntangu Ebele lungisaka bamvula makumi tatu na yiya, yandi butaka Pelenge. ");
INSERT INTO mkw_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Na manima ya mbutukulu ya Pelenge, Ebele zingaka dyaka bamvula bankama yiya na makumi tatu (430). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ntangu Pelenge lungisaka bamvula makumi tatu, yandi butaka Lewu. ");
INSERT INTO mkw_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Na manima ya mbutukulu ya Lewu, Pelenge zingaka dyaka bamvula bankama zole na yivwa (209). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ntangu Lewu lungisaka bamvula makumi tatu na zole, yandi butaka Selunge. ");
INSERT INTO mkw_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Na manima ya mbutukulu ya Selunge, Lewu zingaka dyaka bamvula bankama zole na nsambwadi (207). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ntangu Selunge lungisaka bamvula makumi tatu, yandi butaka Nawole. ");
INSERT INTO mkw_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Na manima ya mbutukulu ya Nawole, Selunge zingaka dyaka bamvula bankama zole (200). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ntangu Nawole lungisaka bamvula makumi zole na yivwa, yandi butaka Tela. ");
INSERT INTO mkw_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Na manima ya mbutukulu ya Tela, Nawole zingaka dyaka bamvula nkama na kumi na yivwa (119). Yandi butaka dyaka bana ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ntangu Tela lungisaka bamvula makumi nsambwadi, yandi butaka Abalami, Nawole mpe Alane. ");
INSERT INTO mkw_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Yayi ni mukanda ya bankumbu ya bana ya Tela. Tela butaka Abalami, Nawole na Alane. Alane butaka Loti. ");
INSERT INTO mkw_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Alane kufwaka tekila tata ya yandi Tela, na mbanza ya Ule na yinsi ya Kalede, yinsi ya dikanda ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abalami kwelaka Salayi, mpe Nawole kwelaka Mileka. Mileka na Yiseka vwandaka bana ya Alane. ");
INSERT INTO mkw_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salayi vwandaka na mwana ve, yandi vwandaka kisita. ");
INSERT INTO mkw_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela bakaka mwana ya yandi Abalami na mutekolo ya yandi Loti, mwana ya Alane. Yandi nataka mpe Salayi, kento ya mwana ya yandi Abalami. Bawu bikaka mbanza ya Ule na yinsi ya Kalede, samu na kukwenda na yinsi ya Kaana. Bawu kumaka na mbanza Yalane, mpe zingaka kuna. ");
INSERT INTO mkw_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela kufwaka na bamvula bankama zole na tanu (205) na mbanza ya Alane. ");
INSERT INTO mkw_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yave tubaka na Abalami: «Katuka na yinsi ya nge, bika dikanda ya nge mpe yinzo ya tata ya nge. Kwenda na yinsi yina mu ke lakisa nge. ");
INSERT INTO mkw_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mu ke sala ti dikanda ya nge kuvwanda nene, mu ke sakumuna nge, mpe mu ke sala ti nkumbu ya nge kuvwanda nsangu. Bantu ke kuzwa lusakumunu na nkumbu ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mu ke sakumuna bayina ke sakumuna nge, mpe mu ke siinga muntu yina ke siinga nge. Na nge, makanda nyonso ya ntoto ke kuzwa lusakumunu.» ");
INSERT INTO mkw_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Mutindu Yave zabisaka yandi, Abayami kwendaka na Loti, mwana yina bikaka leki ya yandi Alane. Abalami vwandaka na bamvula makumi na tanu, ntangu yandi bikaka mbanza Alane. ");
INSERT INTO mkw_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abalami kwendaka kintwadi na kento ya yandi Salayi, na Loti, na yinsi ya Kaana. Bawu nataka bimvwama ya bawu nyonso, na bisadi ya bawu yina ba sumbaka na mbanza Alane. Bawu kwendaka kuma na Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abalami tambulaka yinsi nyonso tii na kisika yina vwandaka yinti ya telembente, kisika yina vwandaka yinti yina ba ke bokilaka Mole, na mbanza Siseme. Na ntangu yina, ni ba-Kaanani vwandaka zinga na yinsi ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yave talanaka na Abalami mpe tubaka na yandi: «Mu ke pesa yinsi yayi na bana ya nge, mpe na bayina nyonso ke butuka na manima ya bawu.» Abalami yidikaka kiyokolo ya minkayulu, samu na Yave yina monikinaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Na manima, Abalami katukaka na kisika yina, mpe yandi kwendaka na mongo yina kele na esete ya Betele. Yandi tungaka difokola na kati-kati ya mbanza ya Ayi na mbanza Betele, Ayi na esete, Betele na wesete. Kuna, yandi yidikaka kiyokolo ya minkayulu samu na Yave. Mpe yandi sambilaka Yave. ");
INSERT INTO mkw_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Na manima, Abalami tatamanaka na kwenda kisika na kisika, na lweka ya Nengeve. ");
INSERT INTO mkw_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nsatu kotaka na yinsi. Ni yawu yina, Abalami kwendaka vwanda na Ngipiti, samu ti nsatu vwandaka ngolo mingi na yinsi. ");
INSERT INTO mkw_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ntangu bawu kumaka pene-pene ya Ngipiti, Abalami tubaka mutindu yayi na kento ya yandi Salayi: «Tala, mu zaba ti nge ke kento mosi ya kitoko. ");
INSERT INTO mkw_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ntangu bantu ya Ngipiti ke tala nge, bawu ke tuba ti yayi ni kento ya yandi. Na yina, bawu ke kufwa munu, mpe bawu ke bika nge. ");
INSERT INTO mkw_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ya kele mbote ti nge tuba na bawu ti nge ke kibusi ya munu, samu ti ba sadila munu mambu ya mbote samu na nge. Na yina, bawu ke bika na kufwa munu samu na nge.» ");
INSERT INTO mkw_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ntangu Abalami kumaka na Ngipiti, bantu ya Ngipiti talaka ti kento ya yandi vwandaka kitoko mingi. ");
INSERT INTO mkw_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Bamfumu yina ke salaka na Falawo talaka kento yango, mpe bawu kwendaka zonzila kitoko ya kento yina na sika ya Falawo. Na yina, ba bakaka kento ya Abalami, ba nataka yandi na yinzo ya Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mpe ba sadilaka Abalami mambu ya mbote samu na Salayi. Ba pesaka Abalami bangombe, mameme, bankombo, basamo, bambuluku ya nkento na ya mbakala. Ba pesaka yandi mpe bisadi ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kasi Yave pesaka bimbevo ya nene na Falawo mpe na bantu ya yinzo ya yandi samu na Salayi, kento ya Abalami. ");
INSERT INTO mkw_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Na yina, Falawo bokilaka Abalami mpe yandi tubaka: «Wapi mambu nge me sala munu? Samu na yinki nge zabisaka munu ve ti Salayi ke kento ya nge? ");
INSERT INTO mkw_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Samu na yinki nge tubaka na munu ti yandi ke kibusi ya nge? Mu bakaka yandi mutindu kento ya munu. Kento ya nge yandi yayi. Baka yandi mpe beno kwenda!» ");
INSERT INTO mkw_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Mpe Falawo tumisaka bantu ya yandi na kubasisa Abalami na Ngipiti, yandi na kento ya yandi, mpe bima nyonso yina vwandaka ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abalami katukaka na yinsi ya Ngipiti, mpe kwendaka na yinsi ya Nengeve kintwadi na kento ya yandi, na Loti, mpe na bima ya yandi nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abalami vwandaka na bimvwama mingi: bibulu, palata na wolo. ");
INSERT INTO mkw_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Yandi kwendaka kisika na kisika, katuka Nengeve tii na Betele, tii na kisika yina yandi vwandaka ntete, kati-kati ya Betele na Ayi, ");
INSERT INTO mkw_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","na kisika yina, yandi yidikaka kiyokolo ya minkayulu, samu na Yave. Kuna, Abalami sambilaka Yave na Nkumbu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti, yina vwandaka kwenda kintwadi na Abalami, yandi mpe, yandi vwandaka na mameme, bankombo, bangombe na mafokola. ");
INSERT INTO mkw_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Yinsi yina lendaka kulungisa ve bansatu ya luzingu ya bawu na kisika mosi. Samu ti bimvwama ya bawu vwandaka ya kulutila mingi, mpe bawu lendaka zinga ve kisika mosi. ");
INSERT INTO mkw_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Mindondo basikaka na kati ya mivungi ya bibulu ya Abalami na mivungi ya bibulu ya Loti. Na ntangu yina, ba-Kaanani na ba-Pelizi vwandaka zinga na yinsi. ");
INSERT INTO mkw_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Na yina, Abalami tubaka na Loti: «Bika ti mindondo kuvwanda ve na kati ya munu na nge, mpe na kati ya mivungi ya munu na ya nge. Samu ti beto kele dikanda mosi. ");
INSERT INTO mkw_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Yinsi nyonso kele na mantwala ya nge. Beto fwana kukabwana. Kana nge ke kwenda na lubakala, munu mu ke kwenda na lumoso. Kana nge ke kwenda na lumoso, munu mu ke kwenda na lubakala.» ");
INSERT INTO mkw_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti vumbulaka yintu mpe talaka kizunga nyonso ya Yolodani, yina vwandaka yamba maza mingi. Tekila Yave kumwangisa bambanza ya Sodome na Ngomole, kizunga nyonso yina ya Yolodani tii na mbanza ya Soyale vwandaka mutindu bilanga ya Yave, mutindu yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Loti soolaka ya yandi kizunga nyonso ya Yolodani, mpe yandi kwendaka na esete. Ni mutindu yina bawu kabukaka muntu-muntu na nzila ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abalami zingaka na yinsi ya Kaana, mpe Loti na bambanza ya kizunga ya Yolodani. Yandi vwandaka kwenda tunga mafokola ya yandi tii na kukuma na mbanza ya Sodome. ");
INSERT INTO mkw_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Bantu ya Sodome vwandaka na mavanga ya yimbi, mpe ya kusumuka mingi na ntwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Na manima ya kukabuka ya Loti na Abalami, Yave tubaka na Abalami mutindu yayi: «Vumbula yintu ya nge, tala kubanda kisika yina nge kele, na node, na sude, na esete tii na wesete. ");
INSERT INTO mkw_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Yinsi nyonso yina nge ke na kutala, mu ke pesa nge yawu mankululu, na bana ya nge, mpe na bayina nyonso ke butuka na manima ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mu ke funisa bana ya nge, mpe bayina ke butuka na manima ya bawu, mutindu munyenge. Kana muntu lenda na kutanga munyenge, yandi lenda tanga mpe bana ya nge, na bayina ke butuka na manima ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Telama! Tambula na yinsi nyonso, na yinda ya yawu mpe na bunene ya yawu, samu ti mu ke pesa nge yawu.» ");
INSERT INTO mkw_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abalami kwizaka tunga mafokola ya yandi, mpe yandi zingaka kuna na bayinti ya nene ya Mamele, yina kele na mbanza ya Ebelone. Mpe kuna, yandi yidikaka kiyokolo ya minkayulu samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ntangu vwandaka yala bantinu yayi: Amelafele ya Sineyale, Aleyoke ya Elasale, Kedolelawomele ya Elame, Tideyale ya Ngoyime, ");
INSERT INTO mkw_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","mvita salamaka. Bantinu yina nwanisaka bantinu yayi: Bela ya Sodome, Bilesa ya Ngomole, Sinabe ya Adema, Semebele ya Seboyime mpe ntinu ya Bela, Bela yina ba ke bokilaka mpe Soyale. ");
INSERT INTO mkw_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bawu nyonso kwendaka vukana na mudimba ya Sidime, yina ba ke bokilaka mpe mubu ya kufwa. ");
INSERT INTO mkw_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Bawu salaka bamvula kumi na zole na yisi ya lutumu ya ntinu Kedolelawomele. Kasi, na mvula ya kumi na tatu, bawu balukilaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Na mvula ya kumi na yiya, Kedolelawomele kwizaka na bantinu yina vwandaka kintwadi na yandi. Bawu nungaka ba-Lefayi kuna na Asetalote-Kalenayime, ba-Zuzime kuna na Ame, ba-Emi kuna na Sawe ya Kileyatayime. ");
INSERT INTO mkw_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Bawu nungaka ba-Woli kuna na Seyile, mongo ya bawu tii na Ele-Palane, pene-pene ya yinsi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Bawu vutukaka na Ene-Misepate yina ba ke bokilaka mpe Kadese. Bawu nungaka ba-Amaleke. Bawu nungaka yinsi ya ba-Amaleke. Bawu nungaka mpe ba-Amoli yina vwandaka zinga kuna na Asasone-Tamale. ");
INSERT INTO mkw_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Na yina, bantinu ya Sodome, ya Ngomole, ya Adema, ya Seboyime mpe ntinu ya Bela, Bela yina ba ke bokilaka mpe Soyale, bawu yidikaka milonga ya binwani na mudimba ya Sidime, samu na kunwanisa ");
INSERT INTO mkw_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","bantinu yayi: Kedolelawomele ya Elame, Tideyale ya Ngoyime, Amelafele ya Sineyale, Aleyoke ya Elasale. Bantinu yiya yayi nwanisaka bantinu nyonso tanu. ");
INSERT INTO mkw_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mudimba ya Sidime vwandaka ya kufuluka na mabulu yina ke basikilaka guludon. Bantinu ya Sodome na ya Ngomole kimaka, bawu kwendaka kubwa na kati ya mabulu yina. Bayina vuukaka kimaka na mongo. ");
INSERT INTO mkw_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Bayina nungaka bakaka bimvwama nyonso ya bantu ya Sodome mpe Ngomole. Ba bakaka mpe madya nyonso, na manima, ba kwendaka. ");
INSERT INTO mkw_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Loti, mwana-nkazi ya Abalami vwandaka zinga na Sodome. Ba bakaka mpe yandi na bimvwama ya yandi mpe ba nataka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kasi muntu mosi kimaka, yandi kwendaka pesa nsangu na sika ya Abalami. Abalami vwandaka mu-Ebeleyo. Yandi vwandaka zinga pene-pene ya bayinti ya nene ya Mamele, ya mu-Amoli. Mamele vwandaka mpangi ya Esekole na Anele. Bawu tatu vwandaka na ngwisani na Abayami. ");
INSERT INTO mkw_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ntangu Abalami kuwaka ti ba me bwila mwana-nkazi ya yandi, mpe ba me nata yandi, yandi kutikisaka bantu bankama tatu na kumi na nana (318), bayina butamaka na bantu yina vwandaka na yisi ya lutumu ya yandi. Bawu landaka bambeni tii na mbanza Dane. ");
INSERT INTO mkw_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Na yina, Abalami na bisadi ya yandi kabukaka na bankonga, samu na kunwanisa bambeni na mpimpa. Yandi nwanisaka bawu mpe yandi nungaka bawu. Mpe yandi landaka bawu tii na Oba, na node ya Damase. ");
INSERT INTO mkw_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Yandi bakaka bimvwama nyonso yina bambeni botolaka. Yandi vutukaka na Loti na bimwvama ya yandi, na bakento mpe bantu ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Na manima ya kununga Kedolelawomele na bantinu yina vwandaka na yandi, Abalami vutukaka. Ntinu ya Sodome kwizaka bwabana yandi na mudimba ya Sawe, yina ba ke bokilaka mudimba ya Ntinu. ");
INSERT INTO mkw_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melekisedeke, ntinu ya Saleme, natinaka Abalami mampa na vinu. Melekisedeke vwandaka nganga-Nzambi ya Nzambi ya Kulutila Kuzangama. ");
INSERT INTO mkw_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Yandi sakumunaka Abalami mutindu yayi: «Bika ti Nzambi ya Kulutila Kuzangama yina yidikaka zulu na ntoto kusakumuna nge! ");
INSERT INTO mkw_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Nkembo na Nzambi ya Kulutila Kuzangama, yina me yekula bambeni ya nge na maboko ya nge.» Abalami pesaka yandi dime ya bima nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Na yina, ntinu ya Sodome tubaka na Abalami: «Baka ya nge bimvwama kasi pesa munu bantu.» ");
INSERT INTO mkw_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abalami tubaka na ntinu ya Sodome: «Mu me nanguna diboko na ntadisi ya Yave, Nzambi ya Kulutila Kuzangama, yina yidikaka zulu na ntoto, samu na kudya ndefi ti, ");
INSERT INTO mkw_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mu ke baka ata kima na maboko ya nge, ya vwanda singa ya kutungila to singa ya dipapa. Mu zola ve ti nge kwenda tuba ti: “Ni munu me mvwamisa Abalami.” ");
INSERT INTO mkw_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Munu mosi, mu ke baka ata kima. Mu me ndima kaka yina me kudya bantwenya yina me vwanda na munu na muzingu. Samu na bantu yina kwendaka na munu: Anele, Esekole mpe Mamele, bawu mosi ke baka kikunku ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Na manima, mambu ya Yave kuminaka Abalami na kati ya lumoni. Yave tubaka mutindu yayi: «Abalami! Kuvwanda ve na boma, mu kele kinwanunu yina ke kebaka nge, mpe mu ke pesa nge musendo ya kulutila.» ");
INSERT INTO mkw_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abalami vutulaka: «Yave Mfumu ya munu, yinki nge ke pesa munu? Mu ke kufwa ata kubika mwana, muntu yina ke byadila bimvwama ya munu, ni Elyezele ya mbanza ya Damase.» ");
INSERT INTO mkw_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abalami tubaka dyaka: «Nge pesaka munu ve bweso ya kubuta. Ni kisadi ya munu Elyezele muntu ke bikana na bimvwama ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Na yina, Yave tubaka na yandi mutindu yayi: «Ni yandi ve ke vwanda kibyadi ya nge, kasi ni mwana yina nge mosi ke buta, muntu ke bikana na bimvwama ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Na manima, Yave basisaka Abalami na ngaanda. Yandi tubaka na yandi: «Tala na zulu, meka ntete na kutanga bambwetete nyonso yina, kana nge ke lenda.» Mpe yandi tubaka dyaka: «Dikanda ya nge ke vwanda ya mingi mutindu bambwetete yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abalami kwikilaka na Yave, mpe Yave ndimaka yandi mutindu muntu ya kudedama, samu na kiminu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Yave tubaka na Abalami: «Ni munu Yave, yina basisaka nge na mbaza ya Ule na yinsi ya Kalede, samu na kupesa nge yinsi yayi nge kele, samu ti yawu kukuma ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abalami vutulaka: «Yave, Mfumu ya munu, yinki ke lakisa ti yinsi yayi ke vwanda ya munu?» ");
INSERT INTO mkw_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yave tubaka na Abalami: «Natina munu mwana ya ngombe ya nkento ya bamvula tatu, na nkombo ya nkento ya bamvula tatu, na dimeme ya mbakala ya bamvula tatu, na kiduka mosi mpe dibembe mosi ya ntwenya.» ");
INSERT INTO mkw_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abalami nataka bibulu yina nyonso. Yandi zengaka konso kibulu na kati-kati, mpe yandi tulaka bibuku nyonso mutindu ti konso kibuku kutalasana na kibuku ya nkaka. Kasi yandi zengaka ve bandeke. ");
INSERT INTO mkw_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Bakoko-mbele kwizaka na kudya bibulu yango, kasi Abalami bingisaka bawu. ");
INSERT INTO mkw_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Na nkokila, Abalami lalaka pongi mosi ya ngolo. Mpimpa ya nene kubwaka mpe yandi kuzwaka boma ya ngolo. ");
INSERT INTO mkw_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Nzambi tubaka na Abalami: «Nge fwana kuzaba ti bana ya nge ke zinga na yinsi ya nzenza, ba ke kuma bandongo, mpe ba ke talisa bawu mpasi, bamvula bankama yiya (400). ");
INSERT INTO mkw_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kasi mu ke fundisa yinsi yina ke kumisa bawu bandongo, mpe ba ke basika kuna na bimvwama mingi. ");
INSERT INTO mkw_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Samu na nge, mu ke sala ti nge nuna kununa mosi ya kyese, mpe nge kufwa na kizunu. ");
INSERT INTO mkw_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Na yina me tadila bana ya nge, kaka ni mbandu ya yiya ke vutuka kwaku, samu ti masumu ya ba-Amoli me yela ntete ve, na kubingisa bawu na yinsi yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ntangu bwisi yilaka, na kati ya mpimpa, kima mosi yina vwandaka basika tiya na mulinga, lutaka na kuyoka bibuku ya bibulu. ");
INSERT INTO mkw_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Na kilumbu yina, Yave salaka ngwisani na Abalami mutindu yayi: «Mu me pesa yinsi yayi na dikanda ya nge, kubanda na nzadi ya Ngipiti tii na nzadi ya nene ya Efalate, ");
INSERT INTO mkw_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","yawu kele yinsi ya ba-Keni, na ba-Kenizi, na ba-Kwademone, ");
INSERT INTO mkw_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na ba-Iti, na ba-Pelizi, na ba-Lefayi, ");
INSERT INTO mkw_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na ba-Amoli, na ba-Kaanani, na ba-Ngilengazi, na ba-Yebuse.» ");
INSERT INTO mkw_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Salayi, kento ya Abayami, butilaka ve Abalami mwana. Salayi vwandaka na mundongo mosi ya kento, muntu ya Ngipiti, nkumbu ya yandi Angale. ");
INSERT INTO mkw_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Salayi tubaka na Abalami: «Yave me sala ti mu vwanda ve na bana. Vukisa mfulu na Angale, mundongo ya munu. Ya lenda vwanda ti yandi butila munu mwana.» Abalami ndimaka mambu ya Salayi. ");
INSERT INTO mkw_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Salayi, kento ya Abalami, bakaka Angale, kisadi ya yandi ya mu-Ngipiti, mpe pesaka yandi na Abalami mutindu kento ya yandi. Abalami lutisaka bamvula kumi kuna na yinsi ya Kaana, tekila dyambu yayi kusalama. ");
INSERT INTO mkw_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abalami vukanaka na Angale, mpe Angale kumaka na kivumu. Na manima, Angale vwandaka zitisa dyaka ve Salayi, mpe yandi bandaka tala yandi mutindu kima ya mpamba. ");
INSERT INTO mkw_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ni yawu yina, Salayi tubaka na Abalami: «Nkadulu ya yimbi ya Angale na ntwala ya munu ke kubwa na zulu ya yintu ya nge. Ni munu mosi pesaka nge mundongo ya munu. Kasi ntangu yandi me tala ti yandi me kuma na kivumu, yandi ke na kuzitisa dyaka ve munu, mpe yandi ke na kutala munu mutindu kima ya mpamba. Bika ti Yave kuzenga dyambu yayi na kati ya nge na munu.» ");
INSERT INTO mkw_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abalami vutulaka na Salayi: «Angale kele mundongo ya nge, yandi kele na yisi ya lutumu ya nge. Sala mutindu nge zola.» Na yina, Salayi nyokolaka Angale, mpe Angale kimaka na yinsi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mbazi ya Yave kutanaka Angale pene-pene ya mukelo ya maza na yinsi ya kuyuma yina ke na nzila ya Sule. ");
INSERT INTO mkw_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mbazi tubaka mutindu yayi: «Angale, mundongo ya Salayi, wapi sika nge me katuka, mpe wapi sika nge ke na kukwenda?» Angale vutulaka: «Mu ke na kukima Salayi, mfumu ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mbazi ya Yave tubaka na Angale: «Vutuka na sika ya mfumu ya nge, mpe vwanda ya kutumama na yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mbazi ya Yave zonzaka dyaka na Angale: «Mu ke sala ti dikanda yina ke butuka na nge kuvwanda na bantu mingi. Mpe ata muntu ve ke lenda kutanga bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mbazi ya Yave tatamanaka na kutuba ti: «Tala, nge ke na kivumu, mpe nge ke buta mwana ya bakala yina nge ke pesa nkumbu Isemayele, samu ti Yave me kuwa bidilu ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Isemayele ke vwanda mutindu mbuluku ya mfinda. Yandi ke nwanisa bantu nyonso mpe bantu nyonso ke nwanisa yandi. Isemayele ke zinga yandi mosi, yandi ke zinga ve kisika mosi na bampangi ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Angale pesaka Yave yina sololaka na yandi nkumbu yayi: «Nge kele Nzambi yina ke na kutala munu.» ");
INSERT INTO mkw_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ni yawu yina, ba pesaka dibulu ya maza nkumbu: «Dibulu ya maza ya Layayi-loyi», yina zola kutuba: Yandi yina kele Moyo mpe ke na kutala munu. Yawu kele na kati-kati ya babwala Kadese na Belede. ");
INSERT INTO mkw_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Angale butilaka Abalami mwana ya bakala. Abalami pesaka mwana yina nkumbu Isemayele. ");
INSERT INTO mkw_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abalami vwandaka na bamvula makumi nana na sambanu ntangu Angale butilaka yandi Isemayele. ");
INSERT INTO mkw_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ntangu Abalami kumaka na bamvula makumi yivwa na yivwa, Yave talanaka na yandi, mpe tubaka na yandi mutindu yayi: «Mu kele Nzambi-Mpungu. Dyatila mutindu mu zola, mpe vwanda ya kusungama. ");
INSERT INTO mkw_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mu ke na kusala ngwisani ya munu na kati ya nge na munu. Mu ke funisa dikanda ya nge, samu ti ya kukuma nene mingi.» ");
INSERT INTO mkw_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abalami fukamaka kizizi na ntoto. Nzambi tatamanaka na kuzonza na yandi, na kutuba mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Ngwisani ya munu na nge ni yayi: Nge ke vwanda tata ya makanda mingi. ");
INSERT INTO mkw_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ba ke bokila dyaka nge ve na nkumbu ya Abalami. Nkumbu ya nge me kuma Abalayami, samu ti mu ke kumisa nge tata ya makanda mingi ya bantu. ");
INSERT INTO mkw_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mu ke sala ti nge kubuta bana mingi, yina ke kuma makanda mingi, mpe bantinu mingi ke butuka na nge. ");
INSERT INTO mkw_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mu ke sala ngwisani ya munu na kati ya munu na nge, mpe na bayina nyonso ke butuka na manima ya nge. Ngwisani yayi ya mankululu ke sala ti munu, mu kuvwanda Nzambi ya nge, mpe Nzambi ya bayina ke butuka na manima ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Yinsi nyonso yayi ya Kaana, kisika nge me kwiza vwanda na bunzenza, mu ke pesa nge yawu. Yawu ke vwanda mvwilu ya nge ya bantangu nyonso. Bana yina ke butuka na manima ya nge, mu ke vwanda Nzambi ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nzambi zonzaka dyaka na Abalayami: «Beno fwana zitisa ngwisani ya munu, nge, bana ya nge, mpe bayina nyonso ke butuka na manima ya bawu, mbandu ni mbandu. ");
INSERT INTO mkw_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Tala mutindu beno fwana kusadila ngwisani ya munu, nge na bana yina ke butuka na manima ya nge: Babakala nyonso na kati-kati ya beno fwana kuzengisa bubakala ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kuzengisa bubakala ya beno ke vwanda kidimbu ya ngwisani na kati-kati ya munu na beno. ");
INSERT INTO mkw_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Beno ke zenga bubakala ya bana nyonso ya babakala, ntangu bawu ke lungisa bilumbu nana, na konso mbandu. Ata ya vwanda bandongo yina ke butuka na yinzo ya nge, ata ya vwanda bayina beno ke sumba na banzenza, bayina kele ve bantu ya dikanda ya beno. ");
INSERT INTO mkw_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ba fwana kuzenga bubakala ya mundongo yina me butuka na yinzo ya nge, to yina nge me sumba na mbongo ya nge. Kidimbu yina ke vwanda na banzutu ya beno, samu na kulakisa ti ngwisani ya munu ke zingila bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Samu na bakala yina ba me zenga bubakala ve, ba fwana kukatula yandi na dikanda ya yandi. Samu ti yandi me lungisa ve mambu yina ngwisani ya munu me tumisa na kusala. ");
INSERT INTO mkw_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","«Nzambi zonzaka dyaka na Abalayami: “Kubokila dyaka ve kento ya nge na nkumbu ya Salayi. Samu ti nkumbu ya yandi me kuma Saala. ");
INSERT INTO mkw_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mu ke sakumuna yandi, mpe yandi ke butila nge mwana ya bakala. Mu ke sakumuna yandi, mpe yandi ke buta makanda mingi, bantinu ya makanda ke butuka na yandi.”» ");
INSERT INTO mkw_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abalayami fukamaka kizizi na ntoto, mpe yandi sekaka. Yandi tubaka na yisi ya ntima yandi ti: «Muntu ya bamvula nkama (100) lenda buta dyaka? Saala mpe yina me kuma na bamvula makumi yivwa, yandi lenda buta dyaka?» ");
INSERT INTO mkw_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abalayami lombaka na Nzambi: «Bika ti Isemayele kuzinga na yisi ya lusakumunu ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nzambi vutulaka na Abalayami: «Ve! Saala ke butila nge mwana ya bakala. Nge ke pesa yandi nkumbu Isaaki. Mu ke sala ngwisani ya munu na yandi, mutindu ngwisani ya mankululu, samu na bana yina ke butuka na manima ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Samu na Isemayele, mu me kuwa ndombolo ya nge. Mu ke sakumuna yandi. Mu ke sala ti yandi kubuta mingi mpe dikanda yina yandi ke buta kukuma ya mingi ya kulutila. Yandi ke buta bamfumu kumi na zole. Mu ke sala ti dikanda yina yandi ke buta kuvwanda ya nene. ");
INSERT INTO mkw_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kasi ngwisani ya munu, mu ke sala yawu na Isaaki, mwana yina Saala ke buta na mvula yina ke kwiza, kaka na ntangu ya mutindu yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ntangu Nzambi manisaka kuzonza na Abalayami, yandi bikaka yandi, mpe yandi kwendaka. ");
INSERT INTO mkw_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kaka na kilumbu yina, Abalayami vukisaka Isemayele na bandongo ya yandi nyonso yina butukaka na yinzo ya yandi, na bayina yandi sumbaka na mbongo ya yandi. Yandi zengaka bubakala ya bawu mutindu Nzambi tumisaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abalayami vwandaka na bamvula makumi yivwa na yivwa, ntangu ba zengaka bubakala ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Mwana ya yandi Isemayele vwandaka na bamvula kumi na tatu, ntangu ba zengaka yandi bubakala. ");
INSERT INTO mkw_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ba zengaka Abalayami na Isemayele bubakala kilumbu mosi, ");
INSERT INTO mkw_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","kintwadi na bantu nyonso ya yinzo ya Abalayami, bandongo yina butukaka na yinzo ya yandi, mpe bayina yandi sumbaka na banzenza. ");
INSERT INTO mkw_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kilumbu mosi, na ntangu ya midi, Yave talanaka na Abalayami pene-pene ya bayinti ya nene ya Mamele. Abalayami vwandaka ya kuvwanda na mwelo ya yinzo ya yandi ya lele. ");
INSERT INTO mkw_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Mbala mosi, yandi talaka bantu tatu ya kutelama na mwa mantwala. Na nswalu-nswalu, yandi kwendaka yamba bawu. Yandi fukamaka kizizi na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Mpe yandi zonzaka na mosi na bawu: «Mulemvo ya nge mfumu, sadila munu lemvo na kundima kukota na yinzo ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ba ke natina beno mwa maza ya kusukudila makulu. Mpe beno pema ya beno na yisi ya yinti yayi. ");
INSERT INTO mkw_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mu ke natina beno mwa kima ya kudya, samu na kubwela ngolo na nzutu, tekila beno tatamana na kulanda nzila ya beno. Na yina, kulutila ya beno pene-pene ya yinzo ya munu kisyelo ya beno, kuvwanda ve ya mpamba.» Bantu yango vutulaka: «Mambu ve. Sala mutindu nge me zonza.» ");
INSERT INTO mkw_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abalayami kwendaka nswalu na yinzo na kuzabisa na Saala mutindu yayi: «Baka mbangu Baseya tatu ya faline ya kitoko, nge yidika kiputi samu ti nge sala mampa.» ");
INSERT INTO mkw_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Na manima, Abalayami kwendaka mbangu na kisika yina vwandaka bibulu ya yandi, samu na kubaka mwana ya ngombe ya mbote, mpe ya mafuta. Yandi pesaka yawu na kisadi ya yandi, samu na kulamba yawu nswalu-nswalu. ");
INSERT INTO mkw_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ntangu mbisi kuyaka, Abalayami bakaka yawu, na folomaze mpe miliki ya kilo, yandi kwendaka tudila bawu yawu. Ba bandaka na kudya, mpe Abalayami telamaka pene-pene ya bawu na yisi ya yinti. ");
INSERT INTO mkw_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Bawu yufulaka yandi: «Wapi kento ya nge Saala?» Abalayami vutulaka: «Yandi kele na kati ya yinzo.» ");
INSERT INTO mkw_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mosi na bawu tubaka dyaka: «Na mvula yina ke kwiza, mu ke vutuka awa kaka na ngonda yayi, mpe Saala ke buta mwana ya bakala.» Saala yango vwandaka na manima ya Abalayami, na mwelo ya yinzo, mpe yandi vwandaka kuwa. ");
INSERT INTO mkw_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abalayami na Saala vwandaka me nuna mingi, bawu kumaka biboba. Na bamvula yina kumaka na Saala, yandi lendaka buta dyaka ve. ");
INSERT INTO mkw_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Saala sekaka na yisi ya ntima. Yandi tubaka: «Munu, mu me nuna mutindu yayi, mu ke lenda dyaka kuyangalala na bakala? Awa mfumu ya munu mpe me kuma kiboba!» ");
INSERT INTO mkw_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yave tubaka na Abalayami: «Yinki Saala ke na kuseka? Wapi mutindu yandi lenda tuba ti: “Munu, mu me nuna mutindu yayi, mu lenda kubuta mwana”? ");
INSERT INTO mkw_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nge ke na kubanza ti ya ke na dyambu yina Yave lenda kulembana? Ntangu mu ke vutuka awa, na mvula yina ke kwiza, kaka na ngonda yayi, Saala ke buta mwana ya bakala.» ");
INSERT INTO mkw_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saala kumaka na boma, yandi tubaka: «Ve! Mu me seka ve.» Kasi Yave tubaka: «Ve! Nge me seka.» ");
INSERT INTO mkw_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Na manima, bantu yango telamaka, bawu bakaka nzila ya kukwenda na Sodome. Abalayami kwendaka fidisa bawu. ");
INSERT INTO mkw_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yave vwandaka me kanisa mutindu yayi: «Mu ke bumba Abalayami mambu yina mu ke na kusala? ");
INSERT INTO mkw_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ve. Abalayami fwana kuvwanda tata ya dikanda ya nene mpe ya ngolo. Mpe samu na yandi, mu ke sakumuna makanda nyonso ya ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mu soolaka Abalayami samu ti yandi kutumisa bana ya yandi mpe bayina ke butuka na manima, na kulanda nzila ya Yave. Bawu ke sadila ludedomo na mambu ya kusungama. Ni kuna mpe, munu Yave, mu ke sadila yandi mambu yina mu sadilaka yandi nsilulu.» ");
INSERT INTO mkw_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Na yina, Yave tubaka na Abalayami: «Kuyawula yina ba ke na kuyawula samu na Sodome na Ngomole me lutila, masumu ya bawu kele ya nene mingi. ");
INSERT INTO mkw_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ni yawu yina, mu fwana kukulumuka kuna, samu na kwenda tala munu mosi, kana mambu yina ba ke na kuyawula samu na bawu kele ya tsyelika.» ");
INSERT INTO mkw_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Bantu zole na kati ya bawu kwendaka na Sodome. Abalayami bikanaka kuna na ntadisi ya Yave. ");
INSERT INTO mkw_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abalayami belamaka mpe tubaka: «Mfumu, ya tsyelika nge ke kufwa kwandi muntu ya kudedama kintwadi na muntu ya yimbi? ");
INSERT INTO mkw_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kana bantu makumi tanu ya kudedama ke zingaka na mbanza yina, ya tsyelika nge ke mwangisa kwandi mbanza yango? Nge lenda lemvokila yawu ve, samu na makumi tanu ya bantu yina kele ya kudedama? ");
INSERT INTO mkw_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ve! Nge lenda kusala mutindu yina ve. Muntu ya kudedama kufwa mutindu mosi na muntu ya yimbi? Zuzi ya yinza nyonso lenda kusala ve lufundusu na ludedomo nyonso?» ");
INSERT INTO mkw_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yave vutulaka: «Kana mu tala bantu makumi tanu ya kudedama na Sodome, mu ke lemvokila mbanza nyonso samu na bantu yina.» ");
INSERT INTO mkw_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abalayami tubaka dyaka: «Mfumu, mulemvo ya nge, mu zola kuzonza na nge, munu yina kele kaka ntoto, mpe bombi ya mpamba. ");
INSERT INTO mkw_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kana bantu tanu me kondwa na kati ya makumi tanu yina, nge ke mwangisa kwandi mbanza nyonso samu na bantu tanu?» Mfumu vutulaka: «Ve, mu ke mwangisa ve mbanza yina, kana mu me tala bantu makumi yiya na tanu ya kudedama.» ");
INSERT INTO mkw_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abalayami tubaka dyaka: «Kana bantu kaka makumi yiya kele ya kudedama kuna.» Mfumu tubaka: «Ve, samu na makumi yiya ya bantu, mu ke mwangisa ve mbanza.» ");
INSERT INTO mkw_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abalayami tubaka dyaka: «Mulemvo ya nge Mfumu, kudasuka ve kana mu tubaka dyaka. Ya lenda vwanda ti, kaka makumi tatu ya bantu ya kudedama kele kuna.» Mfumu tubaka: «Kana mu tala bantu makumi tatu ya kudedama kuna, mu ke sala kima ve.» ");
INSERT INTO mkw_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abalayami tubaka: «Mulemvo ya nge Mfumu, bika ti mu tuba dyaka. Kana ba kele kaka makumi zole.» Mfumu vutulaka: «Mu ke mwangisa ve mbanza samu na makumi zole ya bantu yina.» ");
INSERT INTO mkw_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abalayami tubaka: «Mulemvo ya nge Mfumu, kudasuka ve. Mu ke zonza ya mbala ya nsuka. Kana ba kele kaka kumi.» Mfumu vutulaka: «Mu ke mwangisa ve mbanza samu na kumi ya bantu.» ");
INSERT INTO mkw_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Na manima ya kusolola na Abalayami, Yave kwendaka, mpe Abalayami vutukaka ya yandi na yinzo. ");
INSERT INTO mkw_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Na nkokila, bambazi zole kumaka na Sodome. Loti vwandaka ya kuvwanda na mwelo ya mbanza. Ntangu Loti talaka bawu, yandi telamaka na kwenda bwabana bawu mpe yandi fukamaka kizizi na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Loti tubaka: «Mulemvo ya beno bamfumu ya munu, beno kwiza na yinzo ya kisadi ya beno, beno sukula makulu, beno lutisa mpimpa kuna, mpe mbasi na suka-suka, beno ke landa nzila ya beno.» Bawu vutulaka: «Ve, beto ke lala ya beto na ngaanda, na kisika yina bantu ke yonzamaka.» ");
INSERT INTO mkw_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kasi Loti bondilaka bawu mingi, mpe bawu kwendaka na yinzo ya yandi. Yandi salaka mukembo, yandi lambaka madya na mampa yina vwandaka ve na levule. Yandi pesaka bawu yawu mpe bawu kudyaka. ");
INSERT INTO mkw_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ntete bawu lala, bantu ya Sodome zungaka yinzo ya Loti, kubanda na bantwenya tii na biboba. Bantu nyonso vwandaka kuna. ");
INSERT INTO mkw_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Bawu bokilaka Loti mpe bawu yufulaka yandi: «Wapi bantu yina me kwiza na sika ya nge na mpimpa yayi? Basisa bawu awa, samu ti beto vukisa mfulu na bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti basikaka na ngaanda mpe yandi kangaka mwelo ya yinzo ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Yandi tubaka na bawu: «Mulemvo ya beno bampangi ya munu. Beno sala ve yimbi. ");
INSERT INTO mkw_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Beno tala, mu ke na bandumba zole yina me zaba ntete ve babakala. Mu ke natina beno bawu, mpe beno ke sala bawu mambu nyonso yina beno zola. Kasi beno sala ve yimbi na bantu yayi, samu ti bawu kele banzenza yina mu me yamba na yinzo ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bawu tubaka na Loti: «Katuka kuna! Nge ke nzenza mpe nge zola kufundisa beto? Beto ke talisa nge mpasi ya kulutila na bawu.» Bawu nungunaka Loti na ngolo, mpe bawu belamaka na mwelo samu na kumwangisa yawu. ");
INSERT INTO mkw_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kasi bantu zole yina lambulaka maboko samu na kubenda Loti na kati ya yinzo, mpe bawu kangaka mwelo ya yinzo. ");
INSERT INTO mkw_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Mpe bawu salaka ti meso ya bantu nyonso yina vwandaka na mwelo ya yinzo kufwa, kubanda na bantwenya tii na bantu ya kukula. Bawu vwandaka lenda dyaka ve na kutala mwelo ya yinzo. ");
INSERT INTO mkw_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Babakala zole yina yufulaka Loti: «Ba nani dyaka kele bantu ya dikanda ya nge awa? Ya vwanda babokilo, ya vwanda bana ya bakento mpe ya babakala. Nyonso yina kele ya nge, nge fwana basisa yawu na mbanza yayi. ");
INSERT INTO mkw_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Beto ke mwangisa mbanza yayi, samu ti kuyawula yina ba ke na kuyawula samu na yawu me lutila nene na meso ya Yave. Ni yawu yina, Yave me tumisa beto samu na kwiza mwangisa yawu.» ");
INSERT INTO mkw_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Loti basikaka samu na kwenda zonza na babokilo ya yandi, bayina zolaka kwela bana ya yandi ya bakento. Mpe yandi tubaka na bawu: «Beno basika mbangu na mbanza yayi, samu ti Yave ke mwangisa yawu.» Kasi bawu vwandaka banza ti yandi vwandaka sakana. ");
INSERT INTO mkw_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Na suka-suka, bambazi tubaka na Loti: «Telama, baka kento ya nge mpe bandumba zole ya nge yina kele awa. Beno basika na mbanza samu ti beno kufwa ve na kitumbu yina ke pesama na mbanza yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Loti vwandaka lutisa ntangu na kubasika. Na yina, bantu zole yina simbaka yandi na maboko, na kento ya yandi na bandumba zole ya yandi, samu ti Yave vwandaka tadila bawu kyadi. Na yina, ba kwendaka bika bawu na ngaanda ya mbanza. ");
INSERT INTO mkw_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ntangu ba vwandaka basisa bawu na mbanza, ba tubaka na Loti: «Kima samu na kuvuukisa luzingu ya nge. Kutala ve na manima, kutelama ve na kizunga yayi ya Yolodani. Kima na zulu ya mongo samu ti nge kufwa ve.» ");
INSERT INTO mkw_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loti vutulaka: «Ve Mfumu, mulemvo ya nge!» ");
INSERT INTO mkw_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nge me sala kisadi ya nge mambu ya mbote. Nge me lakisa munu luzolo mingi, samu ti nge me vuukisa luzingu ya munu. Kasi mongo kele ntama mingi, mu ke lenda ve na kukuma kuna tekila mpasi kubwidila munu, mpe mu lenda kufwa. ");
INSERT INTO mkw_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tala mbanza yayi yina kele pene-pene awa, mu lenda kwenda bumbama kuna. Mbanza yango ke kaka ya fyoti. Mulemvo ya nge, bika ti mu kwenda kuna, samu ti mu vuukisa luzingu ya munu. Nge me tala ve ti mbanza yango kele ya fyoti? ");
INSERT INTO mkw_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mbazi tubaka na Loti: «Mu me fwila dyaka nge kyadi, mu ke mwangisa ve mbanza yina nge me tuba. ");
INSERT INTO mkw_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kima mbangu mpe nge kwenda bumbama kuna. Samu ti, mu ke sala kima ve kana nge me kuma ntete kuna ve. Ni yawu yina, ba pesaka mbanza yina nkumbu Soyale.» ");
INSERT INTO mkw_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ntangu Loti kumaka na Soyale, ntangu basikaka. ");
INSERT INTO mkw_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Mpe Yave nokisaka mvula ya sufe mpe ya tiya na mbanza Sodome mpe Ngomole. Tiya yina katukaka na zulu na sika ya Yave. ");
INSERT INTO mkw_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yandi mwangisaka bambanza yina mpe kizunga nyonso. Yandi mwangisaka mpe bantu nyonso ya bambanza yina na bima nyonso yina ke menaka na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kasi kento ya Loti talaka na manima, mpe yandi kumaka kiteki ya mungwa. ");
INSERT INTO mkw_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Na suka-suka, Abalayami kwendaka na kisika yina yandi vwandaka solola na Yave. ");
INSERT INTO mkw_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Yandi talaka na lweka ya Sodome mpe Ngomole mpe na kizunga nyonso ya Yolodani. Yandi talaka mulinga yina vwandaka basika kuna, mutindu mulinga ya tiya ya kulutila. ");
INSERT INTO mkw_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ntangu Nzambi mwangisaka bambanza ya kizunga yina, yandi bambukaka moyo na Abalayami. Yandi vuukisaka Loti ntangu yandi mwangisaka bambanza yina, kisika vwandaka zinga Loti. ");
INSERT INTO mkw_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti katukaka na mbanza Soyale. Yandi yulukaka mongo samu na kwenda zinga kuna na bana ya yandi zole ya bakento, samu ti yandi vwandaka na boma ya kuzinga na Soyale. Ni yawu yina, yandi kwendaka zinga na kati ya ntadi ya nene na bana ya yandi zole ya bakento. ");
INSERT INTO mkw_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kilumbu mosi, mwana ya kuluntu tubaka na leki ya yandi: «Tata ya beto me kuma kiboba mpe ata muntu lenda kwela beto na yinsi yayi, mutindu ya ke salamaka bisika nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kwiza beto nwikisa tata ya beto vinu. Na manima, beto vukisa mfulu na yandi, samu ti beto pesa tata ya beto bana.» ");
INSERT INTO mkw_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Na mpimpa ya kilumbu yina, bawu nwikisa tata ya bawu vinu, mpe mwana ya kuluntu kwendaka vukisa mfulu na tata ya yandi. Mutindu tata vwandaka na yisi ya malafu, yandi zabaka ata fyoti ve ntangu mwana kwizaka lala na yandi, mpe ntangu mwana kwendaka. ");
INSERT INTO mkw_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kilumbu yina landaka, yaya tubaka na leki ya yandi: «Mazono mu vukisaka mfulu na tata ya beto. Mpimpa yayi mpe, beto nwikisa dyaka yandi vinu. Kwenda vukisa mfulu na yandi, samu ti beto pesa tata ya beto bana.» ");
INSERT INTO mkw_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Na mpimpa yina, ba nwikisaka dyaka tata ya bawu vinu. Leki kwendaka vukisa mfulu na tata ya yandi, Tata zabaka ata fyoti ve ntangu mwana kwizaka lala na yandi, mpe ntangu mwana kwendaka. ");
INSERT INTO mkw_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Na yina, bana zole ya Loti ya bakento kuzwaka bivumu ya tata ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yaya butaka mwana ya bakala. Yandi pesaka yandi nkumbu Mowabe. Ni Mowabe kele nkooko ya ba-Mowabe tii bubu yayi. ");
INSERT INTO mkw_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Leki mpe butaka mwana ya bakala. Yandi pesaka yandi nkumbu Bene-Ami. Ni Bene-Ami kele nkooko ya ba-Amone tii bubu yayi. ");
INSERT INTO mkw_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abalayami katukaka na kisika yina samu na kukwenda na Nengeve. Yandi kwendaka zinga na kati-kati ya mbanza Kadese mpe mbanza Sule. Na manima, yandi kwendaka zinga mwa bilumbu na mbanza Ngelale. ");
INSERT INTO mkw_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Na yina me tadila Saala kento ya yandi, Abalayami vwandaka tuba ti yandi kele kibusi ya munu. Na yina, Abimeleke ntinu ya Ngelale fidisaka bantu ya yandi samu ti bawu natina yandi Saala. ");
INSERT INTO mkw_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kasi, Nzambi kwizaka monikina Abimeleke na mpimpa, na kati ya ndosi mpe yandi zabisaka yandi: «Nge ke kufwa samu na kento yina nge me baka, samu ti yandi kele kento ya kukwela.» ");
INSERT INTO mkw_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mutindu Abimeleke vwandaka me vukana ntete ve na Saala, yandi tubaka: «Mfumu nge ke kufwa kwandi bantu ya kusungama? ");
INSERT INTO mkw_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abalayami yandi mosi tubaka na munu ti Saala kele kibusi ya yandi. Saala mpe tubaka ti Abalayami kele nkazi ya yandi. Mu salaka mambu nyonso na ntima ya mbote mpe mu salaka ve yimbi.» ");
INSERT INTO mkw_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Na yina, Nzambi pesaka yandi mvutu na kati ya ndosi mutindu yayi: «Munu mpe mu zaba ti nge salaka mambu nyonso na ntima ya mbote. Ni munu mosi me sala ti, nge sala ve disumu na mantwala ya munu. Ni yawu yina, mu me bika ve ti nge simba yandi. ");
INSERT INTO mkw_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Na yina, vutula kento yina na sika ya bakala ya yandi malu-malu yayi. Abalayami kele mumbikudi. Yandi ke sambidila nge samu ti nge kufwa ve. Zaba ti, kana nge vutula ve yandi, kaka kufwa nge ke kufwa, nge na bantu ya nge nyonso.» ");
INSERT INTO mkw_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleke vumbukaka na suka-suka. Yandi bokilaka bantu nyonso yina ke salaka na yandi. Yandi zabisaka bawu mambu nyonso yina, mpe bantu nyonso kumaka na boma mingi. ");
INSERT INTO mkw_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimeleke bokilaka Abalayami mpe yandi yufulaka yandi: «Yayi wapi mambu nge me sala beto? Wapi yimbi yina mu me sala nge, samu ti nge bwisa munu mpe yinsi ya munu na disumu ya nene yayi? Nge me sala munu mambu yina ba ke salaka ve. ");
INSERT INTO mkw_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleke tubaka na Abalayami: “Yinki kuzwaka nge na kusala mutindu yina?”» ");
INSERT INTO mkw_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abalayami vutulaka: «Mu vwandaka banza ti bantu ya kwaku ke ve na boma ya Nzambi, mpe ba lenda kufwa munu samu na kento ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ya tsyelika, Saala kele mpe kibusi ya munu. Yandi kele mwana ya tata ya munu, kasi yandi kele ve mwana ya mama ya munu. Mpe yandi kumaka kento ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ntangu Nzambi vwandaka kwenda nata munu ntama na yinzo ya tata ya munu, mu tubaka na Saala mutindu yayi: “Bisika nyonso yina beto ke kwenda, lakisa munu luzolo ya nge na kutuba ti mu kele nkazi ya nge.”» ");
INSERT INTO mkw_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimeleke bakaka bangombe, mameme, bankombo, mpe bisadi ya bakento na ya babakala, yandi pesaka yawu na sika ya Abalayami. Mpe Abimeleke vutulaka Saala na bakala ya yandi Abalayami. ");
INSERT INTO mkw_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleke tubaka: «Yinsi ya munu yawu yayi. Kwenda zinga ya nge kisika ni kisika yina nge zola.» ");
INSERT INTO mkw_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Mpe yandi tubaka na Saala: «Mu ke na kupesa funda mosi ya mbongo ya bisengo na sika ya nkazi ya nge, samu na kulakisa na bantu nyonso yina kele na nge ti nge salaka ata dyambu ya yimbi. Na yina, bantu nyonso ke zitisa nge.» ");
INSERT INTO mkw_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abalayami sambilaka Nzambi mpe Nzambi nyakisaka Abimeleke, na kento ya yandi, mpe bisadi ya yandi ya bakento. Na yina, bawu bandaka dyaka na kubuta. ");
INSERT INTO mkw_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Samu ti, Yave kangaka mabuta ya bakento nyonso yina vwandaka zinga na yinzo ya Abimeleke samu na Saala, kento ya Abalayami. ");
INSERT INTO mkw_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yave lakisaka bumbote ya yandi na Saala mutindu yandi zonzaka na yandi. Yandi lungisaka mambu nyonso yina yandi sadilaka Saala nsilulu. ");
INSERT INTO mkw_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saala kuzwaka kivumu ntangu Abalayami vwandaka me kuma kiboba, mpe yandi butaka mwana ya bakala na ntangu yango yina Nzambi zabisaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Mwana yina Saala butaka, Abalayami pesaka yandi nkumbu Isaaki. ");
INSERT INTO mkw_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abalayami zengaka bubakala ya Isaaki, ntangu Isaaki lungisaka bilumbu nana, mutindu Nzambi tumisaka Abalayami na kusala. ");
INSERT INTO mkw_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abalayami vwandaka na bamvula nkama (100) ntangu mwana ya yandi Isaaki butukaka. ");
INSERT INTO mkw_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saala tubaka mutindu yayi: «Nzambi me sala ti munu mpe mu seka na kyese, mpe bantu nyonso yina ke kuwa dyambu yayi, ke seka kintwadi na munu.» ");
INSERT INTO mkw_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Yandi zonzaka dyaka: «Nani lendaka tuba na Abalayami ti munu, Saala, mu ke pesa mabene na bana? Kasi awa mu me butila yandi mwana ya bakala, na buboba ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mwana kulaka, mpe yandi bikaka mabene. Kilumbu Isaaki bikaka mabene, Abalayami salaka mukembo ya nene. ");
INSERT INTO mkw_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Saala talaka ti mwana ya Angale, yina kento ya Ngipiti butilaka Abalayami, vwandaka seka. ");
INSERT INTO mkw_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Na yina, yandi zabisaka Abalayami: «Bingisa mundongo ya kento na mwana ya yandi, samu ti mwana ya mundongo yayi fwana kubyadila ve difwa kintwadi na mwana ya munu, Isaaki.» ");
INSERT INTO mkw_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Dyambu yayi talisaka Abalayami mpasi mingi na ntima, samu ti Isemayele mpe vwandaka mwana ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kasi, Nzambi tubaka na Abalayami: «Kunyonga ve samu na mundongo ya kento na mwana ya yandi. Ndima kusala nyonso yina Saala me zabisa nge na kusala. Samu ti ni na Isaaki nge ke kuzwa bana mutindu mu pesaka nge nsilulu. ");
INSERT INTO mkw_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kasi samu na mwana ya mundongo ya kento, mu ke pesa yandi mpe dikanda, samu ti yandi kele mwana ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Na suka-suka ya kilumbu yina landaka, Abalayami pesaka na Angale dimpa na saki ya mpusu ya kibulu ya kufuluka na maza. Yandi pesaka mwana na Angale, mpe yandi bingisaka Angale. Angale kwendaka yenga-yenga na yinsi ya kuyuma ya Beele-Seba. ");
INSERT INTO mkw_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ntangu maza manisaka na saki ya mpusu ya kibulu, yandi bikaka mwana na yisi ya mwa yinti. ");
INSERT INTO mkw_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Mpe yandi kwendaka vwanda mwa ntama, kisika yina sukaka dyonga yina ba kubulaka na munani, mpe yandi tubaka: «Mu zola ve kutala lufwa ya mwana ya munu na meso.» Yandi vwandaka ya kuvwanda mwa ntama, mpe yandi vwandaka dila mingi. ");
INSERT INTO mkw_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nzambi kuwaka bidilu ya mwana, mpe katuka na dizulu, mbazi ya Nzambi bokilaka Angale. Yandi yufulaka: «Angale, samu na yinki nge ke na kudila? Kuvwanda ve na boma, samu ti Nzambi me kuwa ndinga ya mwana, katuka kisika yina mwana kele, Nzambi me kuwa bidilu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Telama, kwenda baka mwana mpe nge simba yandi mbote. Samu ti mu ke pesa yandi dikanda ya nene.» ");
INSERT INTO mkw_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Nzambi fungulaka Angale meso, mpe Angale talaka dibulu ya maza. Angale kwendaka fulusa saki ya mpusu ya kibulu na maza, mpe yandi nwikisaka mwana maza. ");
INSERT INTO mkw_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nzambi vwandaka keba mwana. Mwana kulaka mpe kwendaka zinga na yinsi ya kuyuma. Yandi kumaka kikubudi ya nene. ");
INSERT INTO mkw_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Isemayele zingaka na yinsi ya kuyuma yina ba ke bokilaka Palane. Mama ya yandi kwelisaka yandi na kento mosi ya yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kaka na ntangu yina, Abimeleke na Pikole, mfumu ya binwani ya Abimeleke, kwizaka tuba na Abalayami mutindu yayi: «Nzambi kele na nge na nyonso yina nge ke na kusala.» ");
INSERT INTO mkw_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Na yina, kudya ndefi na nkumbu ya Nzambi ti, nge ke sala munu yimbi ve, ya vwanda bana ya munu, to bayina nyonso ke butuka na manima ya bawu. Mutindu mu me lakisa nge bumbote, nge mpe ke sala mutindu mosi samu na munu, mpe samu na yinsi yayi, kisika nge me zinga na bunzenza. ");
INSERT INTO mkw_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abalayami vutulaka: «Mu ke kudya ndefi.» ");
INSERT INTO mkw_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mpe Abalayami sembaka Abimeleke samu na mambu ya dibulu ya maza yina bisadi ya yandi botolaka. ");
INSERT INTO mkw_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleke tubaka: «Mu zaba ve nani salaka dyambu yina. Nge mosi mpe, nge zabisaka munu yawu ve. Munu mosi mpe, kaka ni bubu yayi mu me kuwa yawu.» ");
INSERT INTO mkw_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Na manima, Abalayami pesaka Abimeleke bangombe, mameme na bankombo. Mpe bawu zole salaka ngwisani. ");
INSERT INTO mkw_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Na kati ya nkonga ya mameme ya yandi, Abalayami tulaka bana ya mameme nsambwadi na lweka. ");
INSERT INTO mkw_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Na yina, Abimeleke tubaka na Abalayami: «Samu na yinki nge me tula mameme nsambwadi yayi na lweka?» ");
INSERT INTO mkw_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Yandi vutulaka: «Mu me katula mameme nsambwadi yayi samu na kupesa nge yawu mutindu kidimbu yina ke lakisa ti, ni munu timunaka dibulu yina ya maza.» ");
INSERT INTO mkw_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ni yawu yina, ba pesaka kisika yina nkumbu Beele-Seba (yina zola kutuba dibulu ya maza ya mameme nsambwadi to dibulu ya ndefi). Samu ti ni kuna bawu zole kudyaka ndefi. ");
INSERT INTO mkw_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Abalayami na Abimeleke salaka ngwisani kuna na Beele-Seba. Na manima, Abimeleke na Pikole mfumu ya binwani ya Abimeleke, bawu vutukaka na yinsi ya ba-Filiseti. ");
INSERT INTO mkw_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Kuna na Beele-Seba, Abalayami kundaka yinti mosi yina ba ke bokilaka tamalise, mpe yandi sambilaka Nzambi na Nkumbu ya Yave, Nzambi ya bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abalayami zingaka bantangu mingi na yinsi ya ba-Filiseti. ");
INSERT INTO mkw_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Na manima ya mambu yina, Nzambi mekaka Abalayami. Nzambi zonzaka na yandi: «Abalayami!» Abalayami vutulaka: «Munu yandi yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nzambi tubaka: «Baka mwana ya nge Isaaki, mwana ya nge mosi kaka yina nge ke zolaka mingi. Kwenda na yandi na yinsi ya Moliya, mpe kuna nge ke pesa yandi mutindu munkayulu, na mongo yina mu ke lakisa nge.» ");
INSERT INTO mkw_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Na suka-suka, Abalayami kubikaka mbuluku ya yandi mpe yandi kwendaka na bisadi zole, na mwana ya yandi Isaaki. Yandi zengaka bankuni ya kuyokila munkayulu, mpe yandi kwendaka na kisika yina Nzambi tubaka na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Na kilumbu ya tatu, Abalayami talaka mongo yina na ntama. ");
INSERT INTO mkw_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abalayami tubaka na bisadi ya yandi: «Beno vwanda awa na mbuluku. Munu na mwana, beto ke kwenda kuna na kusambila Nzambi. Na manima, beto ke vutukila beno.» ");
INSERT INTO mkw_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abalayami bakaka bankuni ya kuyokila Munkayulu, mpe yandi tulaka yawu na yintu ya mwana ya yandi Isaaki. Yandi mosi bakaka tiya na mbele. Ntangu bawu zole vwandaka tambula, ");
INSERT INTO mkw_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaaki bokilaka tata ya yandi mpe tubaka: «Tata!» Abalayami vutulaka: «Ee, mwana ya munu.» Isaaki yufulaka yandi: «Beto kele awa na tiya mpe na bankuni, kasi wapi sika kele dimeme ya munkayulu?» ");
INSERT INTO mkw_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abalayami vutulaka: «Mwana ya munu, Nzambi yandi mosi ke tala dimeme yina yandi ke pesa samu na munkayulu.» Na manima, bawu nyonso zole tatamanaka na kulanda nzila ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ntangu bawu kumaka na kisika yina Nzambi lakisaka yandi, Abalayami yidikaka kiyokolo ya munkayulu, mpe yandi tulaka bankuni na zulu ya yawu. Yandi kangaka mwana ya yandi Isaaki basinga, mpe yandi tulaka mwana na zulu ya bankuni na kiyokolo ya munkayulu. ");
INSERT INTO mkw_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Na manima, Abalayami bakaka mbele mpe nangunaka diboko samu na kufwa mwana ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kasi mbazi ya Yave bokilaka Abalayami katuka na dizulu mpe tubaka: «Abalayami, Abalayami!» Abalayami vutulaka: «Munu yandi yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mbazi ya Yave tubaka: «Kufwa ve mwana, mpe kusala yandi dyambu mosi ya yimbi ve. Ntangu yayi, mu me zaba ti, nge ke zitisaka Nzambi, samu ti nge me manga ve na kupesa munu mwana ya nge kaka mosi.» ");
INSERT INTO mkw_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","«Abalayami vumbulaka yintu, mpe yandi talaka dimeme mosi ya mbakala, yina vwandaka na mampoka ya kukangama na kati-kati ya mwa bayinti. Abalayami kwendaka baka dimeme yango mpe yandi pesa yawu mutindu Munkayulu ya Kuyoka, na kisika ya mwana ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abalayami pesaka kisika yina nkumbu: “Yave ke tala”. Ni yawu yina, bantu ke tubaka bubu yayi ti: “Na zulu ya mongo Yave ke talanaka.”» ");
INSERT INTO mkw_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Katuka na dizulu, mbazi ya Yave bokilaka Abalayami na mbala ya zole ");
INSERT INTO mkw_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","mpe tubaka: «Mu me kudya ndefi na nkumbu ya munu mosi. Samu ti nge me sala dyambu ya mutindu yina, na kuyimina ve munu mwana ya nge kaka mosi, munu Yave, mu ke na kutuba, ");
INSERT INTO mkw_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mu ke sakumuna nge ya kulutila, mu ke funisa dikanda ya nge samu ti yawu kuma na bantu mingi mutindu bambwetete ya dizulu mpe munyenge ya kumu ya mubu. Bantu ke butuka na dikanda ya nge, bawu ke baka bambanza ya mitantu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Samu na bawu, mu ke sakumuna makanda nyonso ya ntoto, samu ti nge me tumama na munu.» ");
INSERT INTO mkw_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abalayami vutukaka na kisika yina bikanaka bisadi ya yandi. Bawu nyonso kwendaka na bwala ya Beele-Seba, kisika yina Abalayami vwandaka zinga. ");
INSERT INTO mkw_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Na manima ya mambu yina, Abalayami kuwaka ti, Mileka mpe butaka bana na Nawole, mpangi ya Abalayami. ");
INSERT INTO mkw_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Mwana ya ntete ni Wuse. Baleki ya Wuse ni Buze mpe Kemwele, tata ya Alame, ");
INSERT INTO mkw_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesede, Azo, Piledase, Yidelafe, Betwele. ");
INSERT INTO mkw_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Yina ni bana nana yina Mileka butaka na Nawole, mpangi ya Abalayami. Betwele ni tata ya Lebeka. ");
INSERT INTO mkw_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nawole vwandaka na kento ya nkaka, nkumbu ya yandi Lewuma. Kento yina mpe butaka bana. Bana yina ni: Teba, Ngayame, Tayase na Maaka. ");
INSERT INTO mkw_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saala zingaka bamvula nkama na makumi zole na nsambwadi (127). ");
INSERT INTO mkw_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Yandi kufwaka na yinsi ya Kaana, na Kilyate-Aleba, yina ba ke bokilaka mpe Ebelone. Abalayami dilaka Saala mpe yandi salaka kivwandu ya lufwa ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abalayami bikaka nzutu ya kento ya yandi, mpe yandi kwendaka tala ba-Iti, yandi tubaka na bawu: ");
INSERT INTO mkw_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Mu kele nzenza, mpe mu ke kaka na mwa bilumbu na kati-kati ya beno. Beno pesa munu kisika yina ke vwanda ya munu mosi, samu na kukunda kento ya munu yina me bika munu.» ");
INSERT INTO mkw_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ba-Iti vutulaka na Abalayami mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Mfumu ya beto, kuwa beto. Nge kele mfumu yina Nzambi me sakumuna na kati-kati ya beto. Kunda kento ya nge na kisika yina me lutila kitoko na kati ya bandyamu ya beto. Ata muntu na kati beto lenda yimina nge ndyamu ya yandi, samu na kukunda kento ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abalayami telamaka mpe fukama na mantwala ya ba-Iti, bantu ya yinsi. ");
INSERT INTO mkw_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Yandi tubaka na bawu mutindu yayi: «Kana ya tsyelika beno me ndima ti mu kunda kento ya munu awa, beno zonzila samu na munu na sika ya Efelone, mwana ya Sowale. ");
INSERT INTO mkw_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Beno tuba na yandi, samu ti yandi pesa munu ntadi ya yandi ya Makepela, yina kele na nsuka ya bilanga ya yandi. Yandi tekisa munu yawu na ntalu ya yawu, na meso ya beno, samu ti yawu kuvwanda kisika ya munu ya kukundaka bantu ya dikanda ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efelone, mu-Iti, vwandaka ya kuvwanda na kati-kati ya ba-Iti. Yandi vutulaka na Abalayami na meso ya ba-Iti nyonso yina kwizaka na mwelo ya mbanza, yandi tubaka: ");
INSERT INTO mkw_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Ve, mfumu ya munu, kuwa munu. Mu me pesa nge bilanga na ntadi yina ke kuna. Mu me pesa nge yawu, na meso ya bantu ya yinsi ya munu. Kunda kento ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Na yina, Abalayami fukamaka na mantwala ya bantu nyonso ya yinsi. ");
INSERT INTO mkw_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Na meso ya bantu nyonso, Abalayami zonzaka na Efelone mutindu yayi: «Mu zola ti nge kuwa munu. Mu ke pesa nge ntalu ya mbongo ya bilanga yina. Ndima ti mu pesa nge yawu, mpe na manima, mu ke kunda kento ya munu kuna.» ");
INSERT INTO mkw_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Kasi Efelone vutulaka na Abalayami mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Mfumu ya munu, kuwa munu! Ntoto ya Basekele bankama yiya (400) ya palata, yawu kele yinki na meso ya nge na munu? Kunda kento ya nge!» ");
INSERT INTO mkw_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abalayami ndimaka mpe yandi tezaka Basekele bankama yiya (400) ya palata na meso ya ba-Iti, mutindu lombaka Efelone. Yandi tezaka mbongo yango na mutindu bantu vwandaka sadila samu na kusumba mpe kutekisa na yinsi yina. ");
INSERT INTO mkw_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Bilanga ya Efelone, yina kele na Makepela, na kisika yina ke talasanaka na Mamele, bilanga nyonso na ntadi yina kele na kati, na bayinti nyonso, ");
INSERT INTO mkw_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ya kumaka mvwilu ya Abalayami, na meso ya bana ya Ete, mpe ya bantu nyonso yina kwizaka na mwelo ya mbanza. ");
INSERT INTO mkw_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Na manima, Abalayami kundaka kento ya yandi Saala na yinsi ya Kaana, na ntadi yina kele na kati ya bilanga ya Makepela, na kisika yina ke talasanaka na Mamele, yina ba ke bokilaka mpe Ebelone. ");
INSERT INTO mkw_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Bilanga na ntadi yina vwandaka na kati vwandaka dyaka ve ya ba-Iti. Yawu kumaka mvwilu ya Abalayami, samu na kukundaka bantu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abalayami kumaka kiboba, mpe yandi vwandaka me nuna mingi. Yave sakumunaka yandi na mambu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kilumbu mosi, Abalayami tubaka na kuluntu ya bisadi ya yandi, yina vwandaka ntwadisi ya yinzo ya yandi: «Tula diboko ya nge na yisi ya dibunda ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Mpe kudya ndefi na Nkumbu ya Yave, Nzambi ya mazulu na ntoto ti, nge ke kwedila ve mwana ya munu kento ya mu-Kaanani, na kati ya bakento ya yinsi yayi, kisika mu ke na kuzingaka. ");
INSERT INTO mkw_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kasi, ni na yinsi ya munu mpe na kati ya dikanda ya munu, nge ke kwenda baka kento samu na mwana ya munu Isaaki.» ");
INSERT INTO mkw_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kisadi vutulaka: «Yinki mu ke sala kana kento yango ndima ve na kukwiza kwaku? Mu ke vutula mwana ya nge na yinsi yina nge katukaka?» ");
INSERT INTO mkw_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abalayami vutulaka: «Ve, kumeka ata fyoti ve na kuvutula mwana ya munu kuna! ");
INSERT INTO mkw_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yave, Nzambi ya mazulu yina basisaka munu na yinsi ya dikanda ya munu, na yinzo ya tata ya munu, yandi kudyaka ndefi yayi: “Mu ke pesa yinsi yayi na bana ya nge”. Ni Nzambi yina mpe ke fidisa mbazi ya yandi na mantwala ya nge, samu ti nge kuzwa kento mosi kuna, samu na mwana ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kana kento yina ndima ve na kukwiza na nge, nge ke vwanda ve na mambu samu na ndefi yina mu me tumisa nge na kudya. Kasi kuvutula ata fyoti ve mwana ya munu kuna.» ");
INSERT INTO mkw_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Na yina, kisadi tulaka diboko ya yandi na yisi ya dibunda ya mfumu ya yandi Abalayami. Mpe yandi kudyaka ndefi samu na dyambu yina. ");
INSERT INTO mkw_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Na manima, kisadi bakaka basamo kumi na kati ya basamo ya mfumu ya yandi. Yandi bakaka mpe bima nyonso ya ntalu ya mfumu ya yandi. Yandi telamaka mpe kwendaka na Mezopotami, na mbanza ya Nawole. ");
INSERT INTO mkw_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ntangu kisadi kumaka na dibulu yina kele pene-pene ya mbanza, yandi vwandisaka basamo. Ya vwandaka me kuma nkokila, ntangu yina bakento ke kwendaka teka maza. ");
INSERT INTO mkw_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kisadi sambilaka mutindu yayi: «Yave, Nzambi ya mfumu ya munu Abalayami, sala ti mu sala mbwabanu ya mbote. Na kusala mutindu yina, nge ke lakisa bumbote ya nge na mfumu ya munu Abalayami. ");
INSERT INTO mkw_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tala, mu me telama pene-pene ya dibulu ya maza. Bandumba ya mbanza ke na kubasika na kwiza teka maza. ");
INSERT INTO mkw_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Bika ti ndumba yina mu ke tuba ti kulula diyuki ya nge samu ti mu kunwa maza, mpe kana yandi vutula: “Kunwa, na manima mu ke nwikisa mpe basamo ya nge”, mu ke zaba ti, ni kento yina nge me soola samu na kisyelo ya nge Isaaki. Na yina, mu ke zaba ti, nge me lakisa bumbote ya nge na mfumu ya munu Abalayami.» ");
INSERT INTO mkw_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Kisadi vwandaka me manisa ntete ve na kusambila mpe Lebeka kwizaka basika na diyuki ya yandi na zulu ya digembo. Lebeka vwandaka mwana ya Betwele, mutekolo ya Mileka. Mileka vwandaka kento ya Nawole, mpangi ya Abalayami. ");
INSERT INTO mkw_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Lebeka vwandaka ndumba mosi ya kitoko mingi, mpe yandi vwandaka me zaba ntete ve babakala. Yandi kulumukaka na dibulu ya maza mpe fulusaka diyuki ya yandi. Na manima, yandi vutukaka. ");
INSERT INTO mkw_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kisadi ya Abalayami kwendaka mbangu samu na kubwabana yandi mpe yandi tubaka: «Mulemvo ya nge, pesa munu mwa maza ya kunwa na diyuki ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Lebeka tubaka: «Mfumu ya munu, kunwa ya nge.» Lebeka kululaka diyuki ya yandi na nswalu nyonso samu na kupesa kisadi yina maza. ");
INSERT INTO mkw_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ntangu yandi manisaka na kupesa kisadi yina maza, yandi tubaka: «Mu ke teka mpe maza samu na basamo ya nge tii ntangu bawu nyonso ke manisa na kunwa.» ");
INSERT INTO mkw_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Na nswalu nyonso, yandi sekulaka maza ya diyuki ya yandi na kisika yina bibulu ke kunwaka maza. Yandi kwendaka mbangu na kwenda teka dyaka maza na dibulu samu na basamo nyonso ya kisadi yina. ");
INSERT INTO mkw_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kisadi ya Abalayami vwandaka tala Lebeka swii. Yandi vwandaka yufula yandi mosi na yisi ya ntima: «Yave ke na kusala ti mambu ya nzyetolo ya munu kubonga to yawu kubonga ve?» ");
INSERT INTO mkw_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ntangu basamo manisaka na kunwa maza, kisadi ya Abalayami pesaka na Lebeka kinzembele ya wolo mpe milunga zole ya wolo ya maboko. Mulunga yina vwandaka ya Beka mosi. Milunga ya maboko mpe vwandaka ya Beka mosi. ");
INSERT INTO mkw_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Na manima, yandi tubaka: «Zabisa munu nge ke mwana ya nani? Mulemvo ya nge, na yinzo ya tata ya nge, beto lenda kuzwa kisika ya kulala samu na kulutisa mpimpa?» ");
INSERT INTO mkw_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Lebeka vutulaka: «Mu kele mwana ya Betwele, mpe mutekolo ya Mileka na Nawole.» ");
INSERT INTO mkw_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Yandi tubaka dyaka: «Na yinzo ya beto, matiti ya kuyuma mpe madya ya kudikisa bibulu kele mingi, kisika ya kulala mpe kele.» ");
INSERT INTO mkw_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kisadi ya Abalayami fukamaka mpe kubwaka kizizi na ntoto na ntadisi ya Yave. ");
INSERT INTO mkw_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Yandi tubaka: «Nkembo na Yave, Nzambi ya mfumu ya munu Abalayami. Yandi me bika ve na kulakisa bumbote mpe kukwikama ya yandi na mfumu ya munu. Yave me twadisa munu na nzila tii na yinzo ya bampangi ya mfumu ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mwana ya kento kimaka mbangu na yinzo samu na kwenda zabisa mambu yina na mama ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Lebeka vwandaka na nkazi mosi, nkumbu ya yandi Labane. Labane basikaka mpe kimaka mbangu na dibulu ya maza, kisika muntu yina vwandaka. ");
INSERT INTO mkw_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labane talaka kinzembele na milunga ya maboko na kibusi ya yandi. Yandi kuwaka mpe ntangu kibusi ya yandi Lebeka vwandaka zonza ti: «Muntu yina me tuba na munu mutindu yayi, mutindu yayi.» Na yina, Labane kwendaka na sika ya muntu yango. Muntu yango vwandaka ya kutelama na basamo ya yandi pene-pene ya dibulu ya maza. ");
INSERT INTO mkw_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labane tubaka: «Kwiza na sika ya beto, nge ke muntu yina Yave sakumunaka. Samu na yinki nge me vwanda na ngaanda? Mu me kubika kisika na yinzo samu na nge, mpe kisika samu na basamo ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Na yina, kisadi ya Abalayami kwendaka na yinzo ya Labane. Labane kululaka mifuna yina vwandaka na zulu ya basamo. Yandi pesaka basamo matiti ya kuyuma mpe madya. Yandi pesaka mpe maza ya kusukula makulu na kisadi yina mpe bantu yina vwandaka na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Na manima, ba pesaka bawu madya. Kasi kisadi tubaka: «Mu ke kudya ve kana mu zonza ntete ve mambu yina mu ke na yawu.» Labane vutulaka: «Zonza ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kisadi tubaka: «Mu ke kisadi ya Abalayami. ");
INSERT INTO mkw_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yave sakumunaka mingi mfumu ya munu. Yandi me sala ti mfumu ya munu kuvwanda muntu ya nene. Yave me pesa yandi mameme, bankombo, basamo, bambuluku mpe bangombe, wolo na palata, mpe bisadi ya bakento na ya babakala. ");
INSERT INTO mkw_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Mpe Saala, kento ya mfumu ya munu, butaka mwana ya bakala na yandi, na buboba ya yandi. Ni na mwana yina, mfumu ya munu me pesa mvwilu ya yandi nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Na yina, mfumu ya munu tumisaka munu na kudya ndefi ti mu fwana kukwedila ve mwana ya yandi kento ya mu-Kaanani, na kati ya bakento ya yinsi, kisika yandi ke na kuzingaka. ");
INSERT INTO mkw_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Yandi tubaka na munu: “Kudya ndefi ti nge ke kwenda na sika ya dikanda ya munu, na sika ya bantu ya yinzo ya tata ya munu, mpe kuna, nge ke kuzwa kento samu na mwana ya munu.” ");
INSERT INTO mkw_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mu tubaka na mfumu ya munu: “Yinki mu ke sala kana kento yango ndima ve na kukwiza kwaku?” ");
INSERT INTO mkw_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Yandi vutulaka na munu: “Mu ke tambulaka na ntadisi ya Yave Nzambi ya munu. Yandi ke fidisa mbazi ya yandi na mantwala ya nge, samu ti nge sala nzyetolo ya mbote. Mpe nge ke kwedila mwana ya munu kento na kati ya dikanda ya munu, na kati ya bantu ya yinzo ya tata ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kana nge kuma na sika ya dikanda ya munu, nge ke kuzwa ve nsiingulu samu na ndefi yina. Kana bawu ba pesa nge ve kento, nge ke kuzwa ve nsiingulu samu na ndefi yina.” ");
INSERT INTO mkw_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Bubu yayi, ntangu mu kumaka na dibulu ya maza, mu sambilaka mutindu yayi: “Yave, Nzambi ya mfumu ya munu Abalayami, sala ti mambu ya nzyetolo yayi mu ke na kusala kubonga. ");
INSERT INTO mkw_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tala, mu me telama pene-pene ya dibulu ya maza. Mu ke tuba na ndumba yina ke basika na kwiza teka maza: mulemvo ya nge, pesa munu mwa maza ya kunwa na diyuki ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kana yandi vutula: Kunwa ya nge, mu ke teka mpe maza samu na basamo ya nge. Ni kuna, mu ke zaba ti, yayi ni kento yina Yave me soola samu na mwana ya mfumu ya munu.” ");
INSERT INTO mkw_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Mu vwandaka me manisa ntete ve na kusambila na yisi ya ntima, Lebeka kwizaka basika na diyuki ya yandi na zulu ya digembo. Yandi kulumukaka na dibulu mpe yandi tekaka maza. Mu tubaka na yandi: “Mulemvo ya nge, pesa munu mwa maza ya kunwa.” ");
INSERT INTO mkw_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Yandi kululaka diyuki ya yandi na nswalu mpe yandi tubaka: “Kunwa ya nge, mu ke pesa mpe basamo ya nge maza.” Mu kunwaka mpe yandi pesaka mpe basamo maza. ");
INSERT INTO mkw_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Mu yufulaka yandi: “Nge ke mwana ya nani?” Yandi vutulaka: “Mu kele mwana ya Betwele, mpe mutekolo ya Mileka na Nawole.” Na yina, mu tulaka yandi kinzembele na mbombo mpe milunga na maboko. ");
INSERT INTO mkw_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Mu fukamaka mpe mu kubwaka kizizi na ntoto, na ntadisi ya Yave. Mu tondaka Yave, Nzambi ya mfumu ya munu Abalayami. Yandi me twadisa munu na nzila ya mbote na kwiza kuzwa ndumba ya mpangi ya mfumu ya munu, samu na mwana ya yandi ya bakala. ");
INSERT INTO mkw_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ntangu yayi, beno zabisa munu kana beno zola kulakisa luzolo mpe kukwikama ya beno na mfumu ya munu. Kana beno zola ve, beno zabisa munu samu ti mu kwenda ya munu kisika ya nkaka.» ");
INSERT INTO mkw_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labane na Betwele vutulaka: «Dyambu yayi me katuka na Yave, beto kele ve na dyambu ya kuzonza. ");
INSERT INTO mkw_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lebeka yandi yayi na mantwala ya nge. Baka yandi mpe nata yandi, samu ti yandi kuvwanda kento ya mwana ya mfumu ya nge mutindu Yave me tuba yawu.» ");
INSERT INTO mkw_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ntangu kisadi ya Abalayami kuwaka mambu yina, yandi kubwaka kizizi na ntoto na ntadisi ya Yave. ");
INSERT INTO mkw_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kisadi basisaka bima ya wolo, bima ya palata mpe binkuti, yandi pesaka yawu na Lebeka. Yandi pesaka mpe bima ya ntalu na nkazi ya Lebeka mpe na mama ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Na manima, kisadi ya Abalayami na bantu yina vwandaka na yandi kudyaka mpe kunwaka, bawu lalaka kuna. Na suka ntangu bawu vumbukaka, kisadi ya Abalayami tubaka: «Beno bika ti mu vutuka na sika ya mfumu ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mama mpe nkazi ya Lebeka tubaka: «Bika ti Lebeka kuvwanda dyaka na beto mwa bilumbu kumi. Na manima, yandi lenda kwenda.» ");
INSERT INTO mkw_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kasi kisadi ya Abalayami vutulaka: «Beno lutisa munu ntangu ve, Yave me sala ti nzyetolo ya munu kuluta mbote. Beno bika ti mu vutuka na sika ya mfumu ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Na yina, bawu vutulaka: «Beto bokila ndumba yandi mosi, samu na kuyufula dibanza ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Bawu bokilaka Lebeka mpe ba yufulaka yandi: «Nge zola kukwenda na bakala yayi?» Lebeka vutulaka: «Ee, mu ke kwenda na yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Bawu bikaka kibusi ya bawu Lebeka na kento yina vwandaka keba yandi. Bawu kwendaka kintwadi na kisadi ya Abalayami mpe bantu yina kwizaka na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bawu sakumunaka Lebeka na kutuba: «Nge kibusi ya beto, bika ti nge vwanda mama ya mafunda na mafunda ya bantu. Bika ti bana ya nge kubotola bambanza ya bambeni ya bawu!» ");
INSERT INTO mkw_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Na yina, Lebeka na bandumba yina vwandaka bisadi ya yandi, bawu yulukaka na zulu ya basamo, mpe bawu landaka kisadi ya Abalayami. Ni mutindu yina, kisadi ya Abalayami kwendaka na Lebeka. ");
INSERT INTO mkw_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ntangu mambu yayi vwandaka salama, Isaaki kwendaka zinga na kizunga ya Nengeve. Yandi katukaka na dibulu ya maza yina ba vwandaka bokila Layayi-Loyi. ");
INSERT INTO mkw_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Na nkokila, Isaaki basikaka samu na kwenda tambula na kati ya bilanga. Yandi vumbulaka yintu mpe yandi talaka basamo yina vwandaka kwiza. ");
INSERT INTO mkw_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ntangu Lebeka talaka Isaaki, yandi kulumukaka na samo. ");
INSERT INTO mkw_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Mpe yandi yufulaka na kisadi ya Abalayami: «Muntu yina ke na kati ya bilanga mpe ke na kwizaka bwabana beto, ya ke nani?» Kisadi vutulaka: «Yandi kele mfumu ya munu. Na yina, Lebeka fukaka kizizi ya yandi na kitambala.» ");
INSERT INTO mkw_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kisadi ya Abalayami zabisaka na Isaaki mambu nyonso yina yandi salaka. ");
INSERT INTO mkw_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Na manima, Isaaki nataka Lebeka na yinzo ya lele, yina bikaka Saala. Yandi bakaka Lebeka mpe Lebeka kumaka kento ya yandi. Isaaki zolaka Lebeka mpe yandi kuzwaka mbombolo na lufwa ya mama ya yandi Saala. ");
INSERT INTO mkw_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abalayami kwelaka dyaka kento ya nkaka, nkumbu ya yandi Ketula. ");
INSERT INTO mkw_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketula butaka na Abalayami bana yayi: Zimelane, Yokesane, Medane, Midyane, Yisebake mpe Suwa. ");
INSERT INTO mkw_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokesane butaka Saba na Dedane. Bana ya Dedane vwandaka ba-Asuli, ba-Letusi mpe ba-Lewumi. ");
INSERT INTO mkw_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Bana ya Midyane ni: Eyifa, Efele, Enoke, Abida mpe Eleda. Bawu nyonso yina vwandaka bana ya Ketula. ");
INSERT INTO mkw_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abalayami pesaka mvwilu ya yandi nyonso na Isaaki. ");
INSERT INTO mkw_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Abalayami pesaka mpe bima na bana yina yandi butaka na bakento ya yandi ya nkaka. Ntangu yandi vwandaka ntete moyo, yandi fidisaka bana yina ntama na mwana ya yandi Isaaki, na yinsi ya ntama kuna na esete. ");
INSERT INTO mkw_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abalayami zingaka bamvula nkama mosi na makumi nsambwadi na tanu (175), ");
INSERT INTO mkw_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","mpe yandi kufwaka. Abalayami lutisaka bamvula mingi ya kyese na buboba ya yandi, na manima yandi kufwaka. Yandi kwendaka vukana na bankooko ya yandi yina kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Bana ya yandi Isaaki mpe Isemayele tulaka yandi na ndyamu, na kati ya ntadi ya Makepela. Ntadi yango vwandaka na bilanga ya Efelone, mwana ya Sowale, mu-Iti, na kisika yina ke talasanaka na Mamele. ");
INSERT INTO mkw_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ba tulaka Abalayami na ndyamu na kisika yina yandi tulaka kento ya yandi Saala, na bilanga yina Abalayami sumbaka na ba-Iti. ");
INSERT INTO mkw_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Na manima ya lufwa ya Abalayami, Nzambi sakumunaka mwana ya yandi Isaaki. Isaaki vwandaka zinga pene-pene ya dibulu ya maza ya Layayi-Loyi. ");
INSERT INTO mkw_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Yayi ni mukanda ya bankumbu ya bana ya Isemayele, mwana yina Abalayami butaka na Angale, mu-Ngipiti, kisadi ya Saala. ");
INSERT INTO mkw_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Yayi ni mukanda ya bankumbu ya bana ya Isemayele, mutindu bawu butukilaka: Nebayote mwana ya ntete ya Isemayele, Kedale, Adebeyele, Mibesame, ");
INSERT INTO mkw_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misema, Duma, Masa, ");
INSERT INTO mkw_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adade, Tema, Yetule, Nafise mpe Kedema. ");
INSERT INTO mkw_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Yina ni bana ya Isemayele. Konso muntu na bawu vwandaka mfumu ya dikanda. Bawu pesaka bankumbu ya bawu na babwala mpe na bisika yina bawu tungaka bayinzo ya bawu ya lele. ");
INSERT INTO mkw_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isemayele zingaka bamvula nkama na makumi tatu na nsambwadi (137) mpe mwela ya yandi katukaka. Yandi kufwaka mpe kwendaka vukana na bankooko ya yandi yina kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Bana ya Isemayele vwandaka zinga na kizunga yina kele na kati-kati ya mbanza Avila na mbanza Sule. Sule kele pene-pene na Ngipiti, na nzila yina ke kwendaka na Asule. Bawu vwandaka zinga ve kisika mosi na bampangi ya bawu, bana ya nkaka ya Abalayami. ");
INSERT INTO mkw_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Yayi ni mukanda ya bankumbu ya bana ya Isaaki, mwana ya Abalayami. Abalayami butaka Isaaki. ");
INSERT INTO mkw_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ntangu Isaaki lungisaka bamvula makumi yiya, yandi kwelaka Lebeka, kibusi ya Labane, mwana ya Betwele, mu-Alame ya Mezopotami. ");
INSERT INTO mkw_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaaki sambilaka Yave samu na kento ya yandi yina vwandaka kisita. Yave kuwaka lusambulu ya Isaaki mpe kento ya yandi Lebeka kuzwaka kivumu. ");
INSERT INTO mkw_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Bana vwandaka tutana na kati ya kivumu ya Lebeka. Mpe Lebeka tubaka: «Samu na yinki dyambu ya mutindu yayi me kumina munu?» Yandi kwendaka yufula luzolo ya Yave. ");
INSERT INTO mkw_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mpe Yave tubaka na yandi: «Bayinsi zole ke na kati ya kivumu ya nge. Makanda zole ke basika na kivumu ya nge. Mosi na kati ya bawu ke lutila ngolo na mpangi mpe kuluntu ke sadila leki.» ");
INSERT INTO mkw_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ntangu ya kubuta lungaka, mpe ba talaka ti Lebeka vwandaka na mapasa na kivumu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mwana ya ntete yina basikaka vwandaka mbwaki. Nzutu ya yandi vwandaka ya kufuluka na mika mutindu mpusu ya kibulu. Ba pesaka yandi nkumbu Esawu. ");
INSERT INTO mkw_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Na manima, mpangi ya yandi mpe basikaka. Yandi vwandaka ya kusimba kinkoso ya Esawu. Ba pesaka yandi nkumbu Yakobi. Isaaki vwandaka na bamvula makumi sambanu, ntangu Lebeka butaka bana yina. ");
INSERT INTO mkw_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Bana kulaka. Esawu vwandaka kikubudi ya nene, yandi vwandaka na kifu ya kwendaka na mfinda. Yakobi vwandaka muntu ya kuzuna, yandi vwandaka vwanda mingi na yinzo. ");
INSERT INTO mkw_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaaki zolaka mingi Esawu, samu ti yandi vwandaka zola kudya mbisi ya mfinda. Kasi Lebeka vwandaka zola mingi Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kilumbu mosi, Yakobi vwandaka lamba supu. Kaka na ntangu yango, Esawu katukaka na bilanga, mpe yandi vwandaka me lemba. ");
INSERT INTO mkw_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esawu tubaka na Yakobi: «Mu me lemba mingi. Pesa munu supu yayi ya mbwaki mu kudya». Ni yawu yina, ba pesaka Esawu nkumbu Edome. ");
INSERT INTO mkw_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobi vutulaka: «Tekisa ntete munu bukuluntu ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawu tubaka: «Mu ke na kufwa na nsatu, yinki mu ke sala na bukuluntu?» ");
INSERT INTO mkw_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Na yina, Yakobi tubaka: «Kudya ndefi malu-malu yayi.» Esawu kudyaka ndefi, yandi tekisaka bukuluntu ya yandi na Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Na yina, Yakobi pesaka Esawu dimpa na supu ya bankasa. Esawu kudyaka mpe kunwaka. Na manima, yandi telamaka mpe yandi kwendaka. Esawu talaka ti bukuluntu ya yandi vwandaka kima ya mpamba. ");
INSERT INTO mkw_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nsatu mosi kotaka na yinsi. Nsatu yango ni yina ve vwandaka na ntangu ya Abalayami. Isaaki kwendaka na mbanza Ngelale na sika ya Abimeleke, ntinu ya ba-Filiseti. ");
INSERT INTO mkw_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yave monikinaka Isaaki mpe yandi tubaka: «Kukwenda ve na Ngipiti, kasi zinga na yinsi yina mu ke tuba na nge. ");
INSERT INTO mkw_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Zinga na bunzenza na yinsi yayi, mu ke vwanda na nge mpe mu ke sakumuna nge. Samu ti, ni na nge mpe na bana ya nge, mu ke pesa bayinsi nyonso yayi. Mu ke lungisa ndefi yina mu salaka na tata ya nge Abalayami. ");
INSERT INTO mkw_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mu ke sala ti bana ya nge kukuma mingi mutindu bambwetete ya mazulu. Mu ke pesa bana ya nge bayinsi nyonso yayi. Na bana ya nge, makanda nyonso ya ntoto ke kuzwa lusakumunu, ");
INSERT INTO mkw_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","samu ti Abalayami kuwaka mambu ya munu. Yandi landaka bantumunu ya munu, misiku ya munu, bansalulu ya misiku ya munu, mpe banzengolo ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaaki bandaka na kuzinga na mbanza Ngelale. ");
INSERT INTO mkw_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ntangu bantu ya bwala yina vwandaka pesa yandi byuvu samu na kento ya yandi, Isaaki vwandaka vutula: «Yandi kele kibusi ya munu.» Isaaki vwandaka na boma ya kutuba ti yandi kele kento ya munu. Yandi vwandaka kima ti bantu ya yinsi yina kufwa yandi, samu ti Lebeka vwandaka kitoko mingi. ");
INSERT INTO mkw_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaaki lutisaka bilumbu mingi kuna. Kilumbu mosi, Abimeleke, ntinu ya ba-Filiseti vwandaka tala na nela ya yandi, yandi talaka Isaaki yina vwandaka sakana na kento ya yandi Lebeka. ");
INSERT INTO mkw_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Na yina, Abimeleke bokilaka Isaaki mpe tubaka: «Ya tsyelika, kento yayi kele kento ya nge. Samu na yinki nge tubaka ti yandi kele kibusi ya nge?» Isaaki vutulaka: «Mu vwandaka na boma ti ba kufwa munu samu na yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleke tubaka: «Yinki nge me sala beto? Nge zolaka natina beto mambu! Samu ti fyoti kaka bikanaka, mpe mosi na kati ya bantu ya yinsi zolaka vukisa mfulu na kento ya nge!» ");
INSERT INTO mkw_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Na yina, Abimeleke pesaka Musiku yayi na bantu nyonso: «Muntu yina ke sala yimbi na bakala yayi to na kento ya yandi, ba fwana kufwa yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaaki salaka bilanga na yinsi yina. Na mvula yina, yandi yonzikaka bambuma ya kulutila bambala nkama, samu ti Yave sakumunaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Yandi kumaka mvwama. Bimvwama ya yandi vwandaka tatamana na kubwelama, mpe yandi kumaka mvwama ya nene. ");
INSERT INTO mkw_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Isaaki vwandaka na bangombe, mameme, bankombo, mpe bisadi mingi. Ba-Filiseti vwandaka tala Isaaki musoki. ");
INSERT INTO mkw_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Bawu zikaka mabulu nyonso ya maza yina bisadi ya Abalayami timunaka ntangu yandi vwandaka ntete moyo. Ba-Filiseti fulusaka mabulu nyonso na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleke tubaka na Isaaki: «Katuka na yinsi ya beto. Samu ti nge me kuma muntu ya ngolo kulutila beto.» ");
INSERT INTO mkw_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaaki katukaka kuna. Yandi kwendaka telemisa bayinzo ya yandi ya lele na mudimba ya Ngelale mpe yandi zingaka kuna. ");
INSERT INTO mkw_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaaki timunaka dyaka mabulu ya maza yina tata ya yandi Abalayami bikaka, samu ti ba-Filiseti zikaka yawu na manima ya lufwa ya Abalayami. Isaaki pesaka dyaka mabulu yango bankumbu yina tata ya yandi pesaka ntete. ");
INSERT INTO mkw_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Bisadi ya Isaaki kwendaka timuna dibulu na mudimba, mpe kuna bawu talaka dibulu ya maza ya mbote. ");
INSERT INTO mkw_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mivungi ya mbanza Ngelale swanaka na mivungi ya Isaaki. Mivungi ya Ngelale vwandaka tuba: «Maza yayi kele ya beto!» Na yina, Isaaki pesaka dibulu yango nkumbu Eseke, samu ti ba swanaka samu na yawu. ");
INSERT INTO mkw_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Bisadi ya Isaaki kwendaka timuna dibulu ya nkaka ya maza. Kasi ba swanisaka dyaka bawu, samu na dibulu yina. Na yina, Isaaki pesaka yawu nkumbu Sitena. ");
INSERT INTO mkw_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isaaki katukaka kuna, mpe yandi tumisaka ti ba timuna dibulu ya nkaka ya maza. Na mbala yayi, ba swanisaka bawu ve. Na yina, Isaaki pesaka dibulu yina nkumbu Lewobote. Samu ti Isaaki tubaka: «Ntangu yayi, Yave me pesa beto kisika ya kusadila. Na yina, beto ke butana na ntoto yayi». ");
INSERT INTO mkw_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Na manima, Isaaki katukaka kuna mpe yandi kwendaka na bwala Beele-Seba. ");
INSERT INTO mkw_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Na mpimpa yina, Yave monikinaka Isaaki mpe yandi tubaka: «Mu kele Nzambi ya tata ya nge Abalayami. Kuvwanda na boma ve samu ti, mu kele na nge. Samu na kisyelo ya munu Abalayami, mu ke sakumuna nge, mpe mu ke sala ti bana ya nge kubutana mingi.» ");
INSERT INTO mkw_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Na yina, Isaaki yidikaka kiyokolo ya minkayulu kuna. Mpe yandi sambilaka Yave na Nkumbu ya yandi. Kuna, yandi yidikaka yinzo ya yandi ya lele. Mpe bisadi ya yandi timunaka dibulu ya maza na kisika yina. ");
INSERT INTO mkw_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleke na ndiku ya yandi Awuzate, mpe Pikole mfumu ya binwani ya Abimeleke, bawu kwendaka na Ngelale samu na kwenda tala Isaaki. ");
INSERT INTO mkw_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaaki tubaka na bawu: «Samu na yinki beno me kwiza tala munu? Beno ke yinaka munu mpe beno bingisaka munu na yinsi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Bawu vutulaka: «Beto me tala ti Yave kele na nge. Ni yawu yina, beto me tala ti yawu kele mbote ti nge na beto, beto kudya ndefi. Beto fwana kusala ngwisani na nge. ");
INSERT INTO mkw_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Kudya ndefi ti nge ke sala ve beto yimbi, samu ti beto mpe beto salaka nge yimbi ve. Beto sadilaka nge kaka mambu ya mbote. Beto bikaka nge kwenda na kizunu. Ntangu yayi, nge kele muntu yina Yave me sakumuna.» ");
INSERT INTO mkw_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaaki salaka mukembo samu na bawu, bawu kudyaka mpe kunwaka. ");
INSERT INTO mkw_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Na suka-suka, bawu vumbukaka. Bawu kudyaka bandefi muntu na muntu na sika ya mpangi ya yandi. Na manima, Isaaki pesaka bawu nzila samu ti bawu kwenda, mpe bawu katukaka kuna na kizunu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kaka na kilumbu yina, bisadi ya Isaaki kwizaka pesa yandi bansangu ya dibulu ya maza yina bawu vwandaka timuna. Bawu tubaka na yandi: «Beto me kuzwa maza.» ");
INSERT INTO mkw_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaaki pesaka dibulu yina nkumbu Sibeya. Ni yawu yina, tii na kilumbu ya bubu yayi, nkumbu ya mbanza yina kele Beele-Seba. ");
INSERT INTO mkw_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ntangu Esawu lungisaka bamvula makumi yiya, yandi kwelaka Yewudite, mwana ya Beeli, mu-Iti. Yandi kwelaka mpe Basemate, mwana ya Elone, mu-Iti. ");
INSERT INTO mkw_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Isaaki na Lebeka talaka mpasi mingi samu na bakento nyonso zole yayi. ");
INSERT INTO mkw_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaaki kumaka kiboba, yandi vwandaka tala dyaka mbote ve. Yandi bokilaka Esawu mwana ya yandi ya ntete mpe yandi tubaka na yandi mutindu yayi: «Mwana ya munu!» Esawu vutulaka: «Munu yandi yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaaki tubaka: «Nge mosi ke na kutala ti mu me kuma kiboba, mpe mu zaba ve kilumbu yina mu ke kufwa. ");
INSERT INTO mkw_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Mu zola ti, malu-malu yayi, nge baka bisalulu ya nge ya mbingu: kinatunu ya nge ya madyonga na munani ya nge. Nge kwenda na mfinda, nge kwenda kufwa kibulu samu na munu. ");
INSERT INTO mkw_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Nge kwiza lambila munu madya ya kitoko yina mu ke zolaka. Nge natina munu yawu, mu kudya yawu, samu ti mu sakumuna nge ntete mu kufwa.» ");
INSERT INTO mkw_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ntangu Isaaki vwandaka zonza na mwana ya yandi Esawu, Lebeka kuwaka mambu nyonso. Esawu kwendaka na mfinda, samu na kufwa kibulu mpe kunata yawu. ");
INSERT INTO mkw_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Lebeka tubaka na mwana ya yandi Yakobi: «Mu me kuwa mutindu tata ya nge me zabisa na mpangi ya nge Esawu: ");
INSERT INTO mkw_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Natina munu kibulu mpe lambila munu madya ya kitoko. Mu ke kudya yawu mpe mu ke sakumuna nge, na ntadisi ya Yave ntete mu kufwa.” ");
INSERT INTO mkw_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Na yina, nge mwana ya munu, kuwa munu, mpe sala mutindu mu ke tumisa nge. ");
INSERT INTO mkw_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kwenda bakila munu bana zole ya bankombo ya kitoko na kati ya mpaka. Mu ke lambila tata ya nge madya ya kitoko yina yandi ke zolaka. ");
INSERT INTO mkw_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Nge ke natina tata ya nge yawu. Yandi ke kudya yawu, samu ti yandi sakumuna nge ntete yandi kufwa.» ");
INSERT INTO mkw_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakobi tubaka na mama ya yandi Lebeka: «Nge zaba ti mpangi ya munu Esawu ke na miika mingi na nzutu, kasi munu, mu ke ve na yawu. ");
INSERT INTO mkw_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kuzaba ve kana tata ke simba munu na nzutu, yandi ke tala ti mu ke na kuseka yandi. Na yina, mu ke kuzwa nsiingulu kasi lusakumunu ve.» ");
INSERT INTO mkw_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mama ya yandi tubaka: «Mwana ya munu, bika ti nsiingulu yina kubwa na munu. Kasi kuwa kaka mambu yina mu ke na kuzabisa nge. Kwenda bakila munu bana zole ya bankombo.» ");
INSERT INTO mkw_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yakobi kwendaka baka bana yango ya bankombo mpe yandi nataka yawu na sika ya mama ya yandi. Mama lambaka madya ya kitoko yina Isaaki vwandaka zola. ");
INSERT INTO mkw_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Na manima, Lebeka bakaka binkuti ya mwana ya yandi ya ntete Esawu. Yandi soolaka na yinzo, binkuti yina lutilaka kitoko. Yandi lwatisaka yawu mwana ya yandi Yakobi, leki ya Esawu. ");
INSERT INTO mkw_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Yandi kangaka Yakobi mpusu ya mwana ya nkombo na maboko mpe na laka, bisika yina vwandaka ve na miika. ");
INSERT INTO mkw_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Lebeka pesaka mwana ya yandi Yakobi madya ya kitoko na mampa yina yandi lambaka. ");
INSERT INTO mkw_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakobi kwendaka na sika ya tata ya yandi mpe yandi tubaka: «Tata!» Tata vutulaka: «Ee mwana ya munu! Nge ni nani?» ");
INSERT INTO mkw_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobi tubaka na tata ya yandi: «Ni munu Esawu, mwana ya nge ya ntete. Mu me sala mutindu nge tumisaka munu. Mulemvo ya nge, vumbuka, vwanda nge kudya kibulu yina mu me kufwa, samu ti nge sakumuna munu.» ");
INSERT INTO mkw_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaaki yufulaka mwana ya yandi: «Wapi mutindu nge me sala na kuzwa yawu malu-malu yayi?» Yakobi vutulaka: «Yave, Nzambi ya nge me tudila munu yawu na nzila.» ");
INSERT INTO mkw_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Na yina, Isaaki tubaka na Yakobi: «Mwana ya munu, belama awa mu simba nge, samu ti mu zaba kana ni nge mwana ya munu Esawu to ve.» ");
INSERT INTO mkw_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobi belamaka na tata ya yandi Isaaki yina simbaka yandi mpe yandi tubaka: «Ndinga yayi mu ke na kuwa kele ya Yakobi, kasi maboko kele ya Esawu!» ");
INSERT INTO mkw_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaaki zabaka ve ti ya vwandaka Yakobi, samu ti maboko ya Yakobi vwandaka na miika mingi mutindu maboko ya mpangi ya yandi Esawu. Mpe Isaaki sakumunaka Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isaaki yufulaka: «Ya tsyelika yayi ni nge mwana ya munu Esawu?» Yakobi vutulaka: «Ee, ni munu.» ");
INSERT INTO mkw_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaaki tubaka: «Sadila munu madya, mu kudya kibulu yina mwana ya munu me kuzwa, samu ti mu sakumuna nge. Yakobi pesaka tata ya yandi madya mpe Isaaki kudyaka. Yandi pesaka mpe yandi vinu, Isaaki kunwaka.» ");
INSERT INTO mkw_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Tata ya yandi Isaaki tubaka na yandi: «Mwana ya munu, belama awa mpe nge fiba munu.» ");
INSERT INTO mkw_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakobi belamaka mpe fibaka tata ya yandi Isaaki. Isaaki kuwaka nsunga ya binkuti ya yandi mpe Isaaki sakumunaka yandi na kutuba: «Ya tsyelika, nsunga ya mwana ya munu kele mutindu nsunga ya bilanga yina Yave me sakumuna. ");
INSERT INTO mkw_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","«“Bika ti Nzambi kupesa nge kinoko ya mazulu, ntoto kubuta bambuma mingi, bambuma mingi ya faline na vinu ya malu-malu. ");
INSERT INTO mkw_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Bika ti makanda ya bantu kusadila nge, bantu ya bayinsi ya nkaka kufukimina nge! Vwanda mfumu ya bampangi ya nge! Bika ti bana ya mama ya nge kufukimina nge! Bika ti muntu yina ke siinga nge, yandi kuzwa nsiingulu. Bika ti muntu yina ke sakumuna nge, yandi kuzwa lusakumunu!”» ");
INSERT INTO mkw_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaaki manisaka na kusakumuna Yakobi. Kaka na ntangu yina Yakobi bikaka tata ya yandi, mpangi ya yandi Esawu, yina katukaka na mbingu kwizaka kuma. ");
INSERT INTO mkw_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esawu mpe lambaka madya ya kitoko. Yandi natinaka yawu tata ya yandi, mpe yandi tubaka ya yandi: «Tata ya munu, vumbuka nge kudya kibulu yina mwana ya nge me kuzwa, samu ti nge sakumuna munu.» ");
INSERT INTO mkw_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tata ya yandi Isaaki yufulaka: «Nge ni nani?» Yandi vutulaka: «Ni munu Esawu, mwana ya nge ya ntete.» ");
INSERT INTO mkw_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaaki bandaka na kutekita mingi mpe yandi tubaka: «Nani me kwenda kubula kibulu mpe me natina munu yawu? Mu me kudya yawu ntete nge kwiza. Mu me sakumuna yandi, mpe yandi ke vwanda na lusakumunu.» ");
INSERT INTO mkw_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ntangu Esawu kuwaka mambu yina tata ya yandi zonzaka, yandi lookaka na ngolo mpe ya salaka yandi mpasi mingi na ntima. Yandi tubaka na tata ya yandi: «Tata, sakumuna munu mpe.» ");
INSERT INTO mkw_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaaki vutulaka: «Mpangi ya nge vwandaka me kwiza vuna munu awa, mpe yandi me baka lusakumunu ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu tubaka: «Nkumbu ya Yakobi me bonga na yandi samu ti, yandi me vuna munu bambala zole! Ya ntete, yandi bakaka munu bukuluntu. Na mbala yayi, yandi me laba lusakumunu ya munu!» Esawu tubaka dyaka: «Tata, nge me bikana ve na lusakumunu ya nkaka samu na munu?» ");
INSERT INTO mkw_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaaki tubaka na Esawu: «Tala, mu me tula yandi mfumu ya nge, bampangi ya yandi nyonso ke vwanda bisadi ya yandi. Mu me pesa yandi bambuma ya faline na vinu ya malu-malu. Nge mwana ya munu, yinki dyaka mu ke sala samu na nge?» ");
INSERT INTO mkw_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu tubaka na tata ya yandi: «Tata, lusakumunu nyonso vwandaka na nge kaka ni yina? Tata, sakumuna munu mpe.» Mpe Esawu bandaka na kudila na ngolo. ");
INSERT INTO mkw_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Na yina, tata ya yandi Isaaki tubaka na yandi: «Nge ke zinga ntama na ntoto yina ke pesaka madya. Kinoko ya mazulu ke kubwa ve na bilanga ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nge ke banda na kuzwaka madya ya nge na mbele ya nge ya mvita. Nge ke vwanda kisadi ya leki ya nge. Ntangu nge ke banda na kwendaka tambula bisika ya mutindu na mutindu, nge ke katula kizitu ya leki ya nge na zulu ya yintu ya nge. Na yina, nge ke kuzwa kimpwanza.» ");
INSERT INTO mkw_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esawu bandaka na kuyina Yakobi samu na lusakumunu yina Yakobi kuzwaka na sika ya tata ya bawu. Na yina, yandi tubaka na yisi ya ntima: «Kilumbu ya lufwa ya tata ya munu ke dyaka ntama ve. Mpe na manima, mu ke kufwa Yakobi.» ");
INSERT INTO mkw_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ba zabisaka Lebeka mambu yina mwana ya yandi ya ntete Esawu vwandaka tuba. Na yina, Lebeka bokilaka Yakobi, mwana ya yandi ya zole, mpe yandi tubaka na yandi: «Yaya ya nge Esawu zola kuvutula nge yimbi, yandi ke na kusosa na kufwa nge. ");
INSERT INTO mkw_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mwana ya munu kuwa munu! Kima malu-malu yayi na sika ya nkazi ya munu Labane, na mbanza Alane. ");
INSERT INTO mkw_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nge ke zinga kuna tii ntangu nkele ya yaya ya nge ke manisa. ");
INSERT INTO mkw_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ntangu nkele ya yaya ya nge ke manisa mpe yandi ke zimbana mambu yina nge me sala yandi, mu ke fidisa muntu na kwiza baka nge kuna. Mu zola ve kuwombisa bana ya munu nyonso zole na kilumbu mosi.» ");
INSERT INTO mkw_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lebeka tubaka na Isaaki: «Mu ke dyaka ve na kilengi ya luzingu samu na babokilo ya munu yayi ya ba-Iti. Luzingu ke vwanda dyaka ve mfunu samu na munu, kana Yakobi mpe kwela kento na kati ya bandumba ya yinsi ya ba-Iti mutindu bawu yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaaki bokilaka Yakobi, yandi sakumunaka yandi mpe pesaka yandi ntumunu yayi: «Nge ke kwela ve kento na kati ya bandumba ya yinsi ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Baka nzila, kwenda na Mezopotami na sika ya Betwele, tata ya mama ya nge. Kuna, nge ke kwela kento na kati ya bandumba ya Labane, nkazi ya mama ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bika ti Nzambi-Mpungu kusakumuna nge, nge buta bana mingi mpe nge kuma nkooko ya makanda mingi. ");
INSERT INTO mkw_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Bika ti yandi kupesa lusakumunu ya Abalayami, na nge mpe na bana ya nge, samu ti yinsi yina Nzambi pesaka na Abalayami, yinsi yina nge ke na kuzinga na bunzenza, yawu kukuma ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaaki fidisaka Yakobi na yinsi ya Mezopotami na sika ya Labane, mwana ya Betwele, mu-Alame. Labane vwandaka nkazi ya Lebeka, Lebeka mama ya Yakobi na Esawu. ");
INSERT INTO mkw_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esawu talaka ti Isaaki sakumunaka Yakobi mpe yandi fidisaka yandi na Mezopotami samu na kwenda kuzwa kento kuna. Mpe ti, na kusakumuna Yakobi, yandi pesaka Yakobi ntumunu yayi: «Nge ke kwela ve kento na kati ya bandumba ya yinsi ya Kaana.» ");
INSERT INTO mkw_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yandi talaka mpe ti Yakobi tumamaka na tata mpe mama ya yandi, mpe yandi kwendaka na Mezopotami. ");
INSERT INTO mkw_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Na yina, Esawu bakulaka ti tata ya yandi Isaaki ke zolaka ve bandumba ya yinsi ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Mpe Esawu kwendaka na sika ya Isemayele, mwana ya Abalayami. Kuna, Esawu kwelaka dyaka kento ya nkaka, nkumbu ya yandi Mayalate. Mayalate vwandaka mwana ya Isemayele mpe kibusi ya Nebayote. ");
INSERT INTO mkw_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobi katukaka na Beele-Seba samu na kukwenda na Alane. ");
INSERT INTO mkw_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Yandi kumaka na kisika mosi, mpe yandi lutisaka mpimpa kuna, samu ti bwisi vwandaka me yila yimeni. Yandi bakaka ditadi mosi na kati ya matadi yina vwandaka kuna, yandi tentikaka yintu ya yandi na zulu ya yawu mpe yandi lalaka pongi. ");
INSERT INTO mkw_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Yandi lotaka ndosi yayi: Yandi talaka kikada yina vwandaka ya kutelama kubanda na ntoto tii na zulu. Bambazi ya Nzambi vwanda yuluka mpe kulumuka na yawu. ");
INSERT INTO mkw_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yandi talaka Yave vwandaka ya kutelama na mantwala ya yandi. Mpe Yave tubaka na yandi: «Mu kele Yave, Nzambi ya nkooko ya nge Abalayami mpe Nzambi ya Isaaki. Ntoto yayi, kisika nge kele ya kulala, mu ke pesa yawu na nge mpe na bana ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Bana ya nge ke kuma mingi mutindu fundu-fundu ya ntoto. Beno ke mwangana na node, na sude, na wesete mpe na esete. Na nge, mpe na bana ya nge, makanda nyonso ya ntoto ke kuzwa lusakumunu. ");
INSERT INTO mkw_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mu kele na nge, mpe mu ke bumba nge bisika nyonso yina nge ke kwenda. Mu ke vutula nge na ntoto yayi mpe mu ke bika nge ve. Mu ke lungisa mambu nyonso yayi mu ke na kuzabisa nge.» ");
INSERT INTO mkw_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ntangu Yakobi vumbukaka na pongi, yandi tubaka: «Ya tsyelika, Yave kele na kisika yayi, kasi munu, mu vwandaka zaba ve!» ");
INSERT INTO mkw_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yandi kumaka na boma mpe tubaka: «Kisika yayi kele kisika ya nsisi. Kisika yayi kele kaka Yinzo ya Nzambi, mwelo ya mazulu!» ");
INSERT INTO mkw_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Na suka-suka, Yakobi vumbukaka. Yandi bakaka ditadi yina yandi tentikaka yintu ya yandi. Yandi tedimisaka yawu samu ti yawu kukuma ditadi ya kubyekwa. Yandi bulumunaka yawu mafuta. ");
INSERT INTO mkw_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ni yawu yina, yandi pesaka kisika yina nkumbu Betele. Nkumbu ya mbanza yina vwandaka ntete Luze. ");
INSERT INTO mkw_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakobi salaka nsilulu yayi: «Kana Nzambi kele na munu, mpe kana yandi keba munu na nzila yayi mu ke na kukwenda, kana yandi pesa munu madya ya kudya na binkuti ya kulwata, ");
INSERT INTO mkw_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kana mu vutuka na yinzo ya tata ya munu na kizunu nyonso, Yave ke kuma Nzambi ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ditadi yayi mu me telemisa mpe mu me byeka, ke kuma Yinzo ya Nzambi. Mpe mu ke pesa nge dime ya bima nyonso yina nge ke pesa munu.» ");
INSERT INTO mkw_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobi telamaka samu na kukwenda na yinsi ya bantu yina ke zingaka na esete. ");
INSERT INTO mkw_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Yandi talaka dibulu mosi ya maza na kati ya matiti. Bankonga tatu ya mameme na bankombo vwandaka pema pene-pene ya dibulu yango, samu ti ni kuna ba vwandaka nwikisa bawu maza. Ba vwandaka kanga dibulu yango na ditadi ya nene. ");
INSERT INTO mkw_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Bankonga nyonso ya mameme na bankombo vwandaka vukana kuna. Na yina, ba vwandaka nengumuna ditadi samu na kunwikisa bibulu maza. Mpe na manima, ba vwandaka vutula dyaka ditadi samu na kukanga dibulu. ");
INSERT INTO mkw_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobi yufulaka mivungi: «Bampangi ya munu, wapi kisika beno me katuka?» Bawu vutulaka: «Beto me katuka na Alane.» ");
INSERT INTO mkw_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakobi yufulaka bawu: «Beno zaba Labane, mwana ya Nawole?» Bawu vutulaka: «Ee, beto zaba yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakobi tubaka: «Yandi kele mbote?» Bawu vutulaka: «Yandi kele mbote. Tala Lasele, mwana ya yandi ya kento ke na kukwiza na mameme na bankombo.» ");
INSERT INTO mkw_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakobi tubaka: «Ntangu ke ntete mingi. Ntangu ya kukutikisa bibulu me lunga ntete ve. Beno nwikisa bawu maza, na manima beno vutula bawu ba kwenda kudya.» ");
INSERT INTO mkw_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bawu vutulaka: «Beto lenda sala ve mutindu yina kana beto me kutikisa ntete ve bibulu nyonso. Na manima, beto ke nengumuna ditadi mpe beto ke nwikisa bibulu maza.» ");
INSERT INTO mkw_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakobi vwandaka me manisa ntete ve na kusolola na bawu mpe Lasele kwizaka na bibulu ya tata ya yandi. Lasele vwandaka muvungi. ");
INSERT INTO mkw_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ntangu Yakobi talaka Lasele, mwana ya mama-nkazi ya yandi Labane, na mameme na bankombo ya Labane, Yakobi belamaka mpe nengumunaka ditadi yina vwandaka kanga dibulu. Yandi nwikisaka maza na bibulu ya Labane, nkazi ya mama ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakobi fibaka Lasele, mpe yandi bandaka na kudila na ngolo. ");
INSERT INTO mkw_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakobi zabisaka Lasele ti yandi kele muntu ya dikanda ya tata ya yandi, yandi kele mwana ya Lebeka. Na yina, Lasele kimaka mbangu na kwenda zabisa yawu na sika ya tata ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ntangu Labane kuwaka nsangu ya Yakobi, mwana ya kibusi ya yandi, yandi kimaka mbangu na kwenda bwabana yandi. Bawu bumbasanaka mpe Labane fibaka yandi. Yandi nataka Yakobi na yinzo ya yandi. Na manima, Yakobi zabisaka Labane mambu nyonso yina kuminaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labane tubaka na Yakobi: «Ya tsyelika nge kele muntu ya dikanda ya munu, beto na nge kele menga mosi.» Mpe Yakobi lutisaka ngonda ya muvimba na sika ya Labane. ");
INSERT INTO mkw_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labane tubaka na Yakobi: «Ata ti nge kele muntu ya dikanda ya munu, nge ke sadila munu kisalu ya mpamba? Zabisa munu yikwa mu ke futa nge.» ");
INSERT INTO mkw_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labane vwandaka na bana zole ya bakento. Nkumbu ya kuluntu vwandaka Leya. Nkumbu ya leki vwandaka Lasele. ");
INSERT INTO mkw_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya vwandaka na meso ya nsoni, kasi Lasele vwandaka kitoko mingi. ");
INSERT INTO mkw_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobi zolaka Lasele mpe yandi tubaka na Labane: «Mu ke sadila nge bamvula nsambwadi samu na kukwela mwana ya nge Lasele, leki ya Leya.» ");
INSERT INTO mkw_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labane vutulaka: «Ya kele mbote ti mu pesa nge yandi, kasi na muntu ya nkaka ve. Vwanda awa na sika ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakobi sadilaka Labane bamvula nsambwadi, samu na kukwela Lasele. Yakobi talaka bamvula yina mutindu mwa bilumbu, samu ti yandi zolaka mingi Lasele. ");
INSERT INTO mkw_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Na manima, Yakobi tubaka na Labane: «Ntangu me lunga, pesa munu kento ya munu. Mu zola kuvwanda na yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Na yina, Labane bokilaka bantu nyonso ya bwala mpe yandi salaka mukembo ya makwela. ");
INSERT INTO mkw_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Na nkokila, Labane bakaka mwana ya yandi Leya mpe yandi nataka yandi na sika ya Yakobi. Mpe Yakobi vukisaka mfulu na Leya. ");
INSERT INTO mkw_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labane pesaka Zilepa, kisadi ya yandi ya kento na sika ya mwana ya yandi Leya, samu ti Zilepa kuvwanda kisadi ya Leya. ");
INSERT INTO mkw_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kasi na suka, Yakobi pamukaka na kutala ti ya vwandaka ni Leya. Na yina, Yakobi tubaka na Labane: «Yayi wapi mambu nge me sala munu? Ya kele ve samu na Lasele mu me sadila nge? Samu na yinki nge me vuna munu?» ");
INSERT INTO mkw_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labane vutulaka: «Beto kele ve na kifu ya kukwelisaka leki kana yaya me kwela ntete ve. ");
INSERT INTO mkw_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Manisa lumingu nyonso ya mukembo ya makwela na Leya. Na manima, beto ke pesa dyaka nge Lasele, mpe nge ke sadila dyaka munu bamvula nsambwadi.» ");
INSERT INTO mkw_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobi ndimaka na kumanisa lumingu nyonso ya mukembo ya makwela na Leya. Na manima, Labane pesaka mwana ya yandi Lasele na sika ya Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labane pesaka Bila, kisadi ya yandi ya kento, na sika ya mwana ya yandi Lasele, samu ti Bila kuvwanda kisadi ya Lasele. ");
INSERT INTO mkw_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakobi vukisaka mpe mfulu na Lasele, mpe yandi zolaka Lasele kulutila Leya. Yakobi sadilaka dyaka Labane bamvula nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yave talaka ti Yakobi vwandaka zola mingi ve Leya. Na yina, yandi salaka ti Leya kuvwanda na mabuta, kasi Lasele kuvwanda kisita. ");
INSERT INTO mkw_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya kuzwaka kivumu, mpe yandi butaka mwana ya bakala. Yandi pesaka mwana nkumbu Lubene, samu ti yandi tubaka: «Yave me tala mpasi ya munu. Ntangu yayi, bakala ya munu ke zola munu.» ");
INSERT INTO mkw_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leya kuzwaka dyaka kivumu, mpe yandi butaka mwana ya bakala. Yandi tubaka: «Yave me tala ti bakala ya munu ke zolaka munu mingi ve. Ni yawu yina, yandi me pesa munu mwana yayi mpe.» Leya pesaka mwana yina nkumbu Simewone. ");
INSERT INTO mkw_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leya kuzwaka dyaka kivumu mpe yandi butaka mwana ya bakala. Yandi tubaka: «Na mbala yayi, bakala ya munu ke kangama na munu, samu ti mu me buta na yandi bana tatu ya babakala. Leya pesaka mwana nkumbu Levi.» ");
INSERT INTO mkw_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Leya kuzwaka dyaka kivumu mpe yandi butaka mwana ya bakala. Yandi tubaka: «Na mbala yayi, mu ke kembila Yave.» Ni yawu yina, yandi pesaka mwana nkumbu Yuda. Mpe yandi bikaka na kubuta. ");
INSERT INTO mkw_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ntangu Lasele talaka ti yandi vwandaka buta ve, yandi kumaka na kimbanda na mpangi ya yandi Leya. Na yina, yandi tubaka na Yakobi: «Pesa munu bana, kana ve mu ke kufwa.» ");
INSERT INTO mkw_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobi dasukilaka Lasele mpe yandi tubaka: «Ni munu Nzambi yina me yimina nge mabuta?» ");
INSERT INTO mkw_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Lasele tubaka dyaka: «Tala, kisadi ya munu Bila yandi yayi. Kwenda vukisa mfulu na yandi, samu ti yandi butila munu bana. Na mutindu yina, munu mpe mu ke vwanda na bana.» ");
INSERT INTO mkw_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Lasele pesaka kisadi ya yandi ya kento Bila, na sika ya Yakobi. Yakobi vukisaka mfulu na Bila. ");
INSERT INTO mkw_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila kuzwaka kivumu mpe yandi butilaka Yakobi mwana ya bakala. ");
INSERT INTO mkw_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Na yina, Lasele tubaka: «Nzambi me baka nzengolo ya mbote samu na munu. Yandi me kuwa lusambulu ya munu, mpe yandi me pesa munu mwana ya bakala.» Ni yawu yina, Lasele pesaka mwana nkumbu Dane. ");
INSERT INTO mkw_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bila, kisadi ya kento ya Lasele kuzwaka dyaka kivumu, mpe yandi butilaka Yakobi mwana ya zole ya bakala. ");
INSERT INTO mkw_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Lasele tubaka: «Mu me nwana mvita ya ngolo na mpangi ya munu na lulendo ya Nzambi mpe mu me nunga.» Lasele pesaka mwana yina nkumbu Nafetali. ");
INSERT INTO mkw_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ntangu Leya talaka ti yandi vwandaka buta dyaka ve, yandi bakaka kisadi ya yandi ya kento Zilepa, yandi pesaka Zilepa na sika ya Yakobi, samu ti yandi kuvwanda kento ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilepa, kisadi ya Leya, butaka na Yakobi mwana ya bakala. ");
INSERT INTO mkw_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya tubaka: «Yayi kele bweso!» Mpe yandi pesaka mwana nkumbu Ngade. ");
INSERT INTO mkw_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilepa, kisadi ya Leya, butaka dyaka na Yakobi mwana ya zole ya bakala. ");
INSERT INTO mkw_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya tubaka: «Kyese mingi samu na munu! Bakento nyonso ke tuba ti mu kele kento ya kyese.» Mpe Leya pesaka mwana nkumbu Asele. ");
INSERT INTO mkw_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kilumbu mosi, na ntangu yina ba ke lokotaka bambuma ya faline, Lubene kwendaka na bilanga mpe yandi kuzwaka bambuma yina ba ke bokilaka mandalangone. Yandi nataka yawu na sika ya mama ya yandi, Leya. Lasele tubaka na Leya: «Pesa munu mwa ndambu ya mandalangone ya mwana ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya vutulaka: «Nge bakaka bakala ya munu, ya me lunga ve? Nge zola kubaka mpe mandalangone ya mwana ya munu?» Na yina, Lasele tubaka: «Pesa munu mwa ndambu ya bamandalangone ya mwana ya nge, mpe Yakobi ke lala na nge na mpimpa ya bubu yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Na nkokila, ntangu Yakobi katukaka na bilanga, Leya kwendaka bwabana yandi. Mpe Leya tubaka na Yakobi: «Bubu yayi nge ke lala na munu, samu ti mu me pesa bamandalangone ya mwana ya munu samu na kuzwa nge. Na mpimpa yina, Yakobi lalaka na Leya.» ");
INSERT INTO mkw_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nzambi kuwaka lusambulu ya Leya. Yandi kuzwaka kivumu mpe yandi butaka mwana ya tanu ya bakala na Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya tubaka: «Nzambi me pesa munu difuta, samu ti mu pesaka bakala ya munu na sika ya kisadi ya munu ya kento.» Leya pesaka mwana nkumbu Isakale. ");
INSERT INTO mkw_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya kuzwaka dyaka kivumu mpe yandi butaka mwana ya bakala na Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leya tubaka: «Nzambi me pesa munu dikabu ya kitoko. Na mbala yayi, bakala ya munu ke zitisa munu, samu ti mu me buta na yandi bana sambanu ya babakala.» Na yina, yandi pesaka mwana nkumbu Zabulone. ");
INSERT INTO mkw_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Na manima, Leya butaka mwana ya kento mpe yandi pesaka yandi nkumbu Dina. ");
INSERT INTO mkw_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nzambi bambukilaka Lasele moyo, yandi kuwaka lusambulu ya Lasele mpe yandi fungulaka yandi mabuta. ");
INSERT INTO mkw_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Lasele kuzwaka kivumu mpe yandi butaka mwana ya bakala. Yandi tubaka: «Nzambi me kuula munu na dyambu yina vwandaka talisa munu nsoni.» ");
INSERT INTO mkw_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Lasele pesaka mwana nkumbu Yosefi. Samu ti yandi tubaka: «Bika ti Yave kubwela munu mwana ya nkaka ya bakala.» ");
INSERT INTO mkw_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ntangu Lasele butaka Yosefi, Yakobi tubaka na Labane: «Bika munu, mu vutuka na yinsi ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Pesa munu bakento mpe bana ya munu samu ti mu kwenda ya munu. Ni samu na bawu mu sadilaka nge. Nge mosi, nge me zaba mbote kisalu yina mu sadilaka nge.» ");
INSERT INTO mkw_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labane vutulaka na Yakobi: «Kana nge tala yawu mbote, kukwenda ntete ve. Banzambi ya munu me zabisa munu ti, Yave me sakumuna munu samu na nge.» ");
INSERT INTO mkw_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Labane tubaka dyaka: «Zabisa munu yikwa mu ke futa nge, mpe mu ke futa nge.» ");
INSERT INTO mkw_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobi vutulaka: «Nge mosi, nge zaba wapi mutindu mu me sadila nge. Nge me zaba mpe wapi mutindu me kuma bibulu ya nge samu na munu. ");
INSERT INTO mkw_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ntete mu kuma na sika ya nge, bimvwama ya nge vwandaka ndambu. Kasi, yawu me kuma mingi samu na munu. Yave me sakumuna nge kubanda kilumbu yina mu tulaka makulu ya munu na yinzo ya nge. Kasi, wapi ntangu mu ke banda na kusala samu na dikanda ya munu mosi?» ");
INSERT INTO mkw_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labane tubaka: «Wapi difuta mu ke pesa nge?» Yakobi vutulaka: «Nge ke pesa munu kima ve. Kasi, kana nge ndima mambu yina mu ke zabisa nge, mu ke vutukila na kudikila mpe kukeba mameme na bankombo ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Bubu yayi mu ke luta na kati-kati ya bibulu ya nge nyonso, mu ke katula konso dimeme ya ndombe, yina kele na matodi-matodi mpe yina kele na banzila-nzila. Mu ke katula mpe konso nkombo ya nkento yina kele na matodi-matodi mpe yina kele na banzila-nzila. Ni yawu ke vwanda difuta ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Na bilumbu yina ke kwiza, nge ke kwiza tala munu samu na kuzaba kana mu me sadila ludedomo na difuta yina mu me kuzwa. Kana nge kwiza tala mameme ya ndombe yina kele ve na matodi-matodi mpe yina kele ve na banzila-nzila na sika ya munu, zaba ti mu me laba yawu. Kana nge tala mpe bankombo ya nkento yina kele ve na matodi-matodi mpe yina kele ve na banzila-nzila, zaba ti mu me laba yawu. ");
INSERT INTO mkw_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labane tubaka: «Mambu ve! Beto ke sala mutindu nge me tuba.» ");
INSERT INTO mkw_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Kaka na kilumbu yina, Labane katulaka bankombo ya mbakala yina vwandaka na matodi-matodi mpe yina vwandaka na banzila-nzila. Yandi katulaka mpe bankombo ya nkento ya matodi-matodi mpe yina vwandaka na banzila-nzila ya mpembe. Yandi katulaka mpe mameme nyonso ya ndombe mpe yandi pesaka yawu na bana ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Na manima, Labane bikaka Yakobi, yandi kwendaka ntama na kisika yina ba lenda sala bilumbu tatu na kukuma. Yakobi vwandaka dikila bibulu ya Labane yina bikanaka. ");
INSERT INTO mkw_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakobi zengaka bintala ya maza ya mu-pepeli, ya mu-amande na ya pelatane. Yandi yubulaka ndambu ya bampusu ya yawu, samu ti yawu kuvwanda na banzila-nzila ya mpembe. ");
INSERT INTO mkw_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yandi bakaka bintala yina yandi yubulaka bampusu. Yandi tulaka yawu na mantwala ya bibulu, na kati ya bima yina ba vwandaka tudila bibulu maza ya kunwa. Samu ti bibulu vwandaka sala makwela ya bawu na ntangu ya kwiza kunwa maza. ");
INSERT INTO mkw_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Bibulu vwandaka sala makwela ya bawu na mantwala ya bintala yina. Mpe bawu vwandaka buta bana yina vwandaka na banzila-nzila mpe ya matodi-matodi ya fyoti na ya nene. ");
INSERT INTO mkw_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobi katulaka mameme. Yandi talisaka yawu na lweka ya bibulu yina vwandaka na banzila-nzila mpe bibulu nyonso yina vwandaka ya ndombe na kati ya bibulu ya Labane. Na kusala mutindu yina, Yakobi kumaka na bibulu ya yandi mosi. Yandi vukisaka dyaka yawu ve na bibulu ya Labane. ");
INSERT INTO mkw_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Konso ntangu yina bibulu ya nene vwandaka sala makwela ya bawu, Yakobi vwandaka tula bintala na mantwala ya bawu, na kati ya bima yina ba vwandaka tudila bawu maza. Mpe bawu vwandaka sala makwela ya bawu na mantwala ya bintala yina. ");
INSERT INTO mkw_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Kasi samu na bibulu yina vwandaka ya kukonda, Yakobi vwandaka tula ve bintala. Na yina, bibulu ya kukonda vwandaka ya Labane, mpe bibulu ya nene vwandaka ya Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yakobi kumaka na bimvwama mingi ya kulutila. Yandi kumaka na mameme mpe bankombo mingi. Yandi kumaka mpe na bisadi ya bakento na ya babakala, basamo mpe bambuluku. ");
INSERT INTO mkw_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobi kuwaka mambu yina vwandaka tuba bana ya Labane. Bawu vwandaka tuba: «Yakobi me baka bima nyonso yina vwandaka ya tata ya beto. Ni na bima ya tata ya beto yandi me kuzwa bimvwama ya yandi nyonso.» ");
INSERT INTO mkw_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakobi talaka ti nkadulu ya Labane na sika ya yandi vwandaka dyaka ve mutindu yawu vwandaka ntete. ");
INSERT INTO mkw_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Na yina, Yave tubaka na Yakobi: «Vutuka na yinsi ya bankooko ya nge, na sika ya dikanda ya nge. Mu ke vwanda na nge.» ");
INSERT INTO mkw_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakobi tumisaka ba kwenda bokila Lasele mpe Leya na bilanga, kisika yina vwandaka mameme na bankombo ya Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yandi zabisaka bawu: «Mu ke na kutala ti nkadulu ya tata ya beno na sika ya munu ke dyaka ve mutindu yawu vwandaka ntete. Kasi Nzambi ya tata ya munu me vwanda na munu. ");
INSERT INTO mkw_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Beno me zaba beno mosi ti mu me sadila tata ya beno na ngolo ya munu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Kasi tata ya beno vwandaka vuna munu, yandi sobaka difuta ya munu bambala kumi, kasi Nzambi bikaka ve ti yandi sala munu yimbi. ");
INSERT INTO mkw_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ntangu yandi vwandaka tuba: “Bibulu nyonso ya matodi-matodi ke vwanda difuta ya nge”, bibulu nyonso vwandaka buta bana ya matodi-matodi. Ntangu yandi vwandaka tuba: “Bibulu nyonso ya banzila-nzila ke vwanda difuta ya nge”, bibulu nyonso vwandaka buta bana yina vwandaka na banzila-nzila. ");
INSERT INTO mkw_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nzambi me baka bibulu ya tata ya beno mpe yandi me pesa munu yawu. ");
INSERT INTO mkw_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ntangu bibulu vwandaka sala makwela ya bawu, mu salaka ndosi yayi: Bibulu yina vwandaka kwenda sala makwela na bibulu ya nkento ya bawu vwandaka na banzila-nzila mpe na matodi-matodi ya fyoti na ya nene. ");
INSERT INTO mkw_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mbazi ya Nzambi bokilaka munu na kati ya ndosi: “Yakobi!” Mu vutulaka: “Munu yandi yayi!” ");
INSERT INTO mkw_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Mpe yandi tubaka: “Tala, bibulu nyonso yina ke na kusala makwela na bibulu ya nkento, ba ke na banzila-nzila mpe matodi-matodi ya fyoti na ya nene. Samu ti mu me tala mambu nyonso yina Labane me sala nge. ");
INSERT INTO mkw_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mu kele Nzambi ya Betele, kisika yina nge bulumunaka mafuta na ditadi yina nge telemisaka mutindu kidimbu, mpe nge salaka munu nsilulu. Ntangu yayi, katuka na yinsi yayi mpe vutuka na sika ya dikanda ya nge.”» ");
INSERT INTO mkw_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Na yina, Lasele na Leya vutulaka: «Beto ke dyaka ve na ata kikunku na mvwilu ya dikanda ya tata ya beto. ");
INSERT INTO mkw_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Yandi ke na kutala beto mutindu banzenza, samu ti yandi tekisaka beto mpe yandi manisaka na kudya mbongo ya beto. ");
INSERT INTO mkw_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Bimvwama nyonso yina Nzambi katulaka na maboko ya tata ya beto, yawu kele ya beto na bana ya beto. Ntangu yayi, sala mambu nyonso yina Nzambi me zabisa nge na kusala.» ");
INSERT INTO mkw_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakobi telamaka mpe yulukisaka bana na bakento ya yandi na zulu ya basamo. ");
INSERT INTO mkw_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Yandi kwendaka na bibulu ya yandi nyonso mpe bimvwama nyonso yina yandi kuzwaka na Mezopotami, samu na kuvutuka na sika ya tata ya yandi Isaaki, na yinsi ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labane kwendaka zenga miika ya mameme na bankombo ya yandi. Na manima ya yandi, Lasele labaka banzambi ya biteki ya tata ya yandi Labane. ");
INSERT INTO mkw_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobi sadilaka mayela, yandi zabisaka ve Labane, mu-Alame ti, yandi ke na kukwenda ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yandi kimaka na bima nyonso yina vwandaka ya yandi. Yandi sabukaka nzadi ya Efalate mpe yandi kwendaka na kizunga ya myongo ya Ngalaade. ");
INSERT INTO mkw_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Na manima ya bilumbu zole, ba zabisaka Labane ti Yakobi kimaka. ");
INSERT INTO mkw_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Labane bakaka bantu ya yandi. Bawu landaka Yakobi mpe bawu salaka bilumbu nsambwadi na nzila. Bawu kwendaka kuzwa yandi na kizunga ya myongo ya Ngalaade. ");
INSERT INTO mkw_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kasi na mpimpa, Nzambi kwizaka monikina Labane, mu-Alame, na kati-kati ya ndosi mpe yandi tubaka: «Sala keba, kuzonza ata dyambu ve na Yakobi.» ");
INSERT INTO mkw_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labane kwendaka kuta Yakobi. Yakobi yidikaka yinzo ya yandi ya lele na zulu ya mongo. Labane na bantu ya yandi mpe yidikaka bayinzo ya bawu ya lele na mongo ya Ngalaade. ");
INSERT INTO mkw_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Na yina, Labane tubaka na Yakobi: «Yinki nge me sala? Nge me sala mayela ya kukwenda ata kuzabisa munu. Mpe nge me nata bana ya munu mutindu bantu yina ba me kanga na mvita! ");
INSERT INTO mkw_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Samu na yinki nge me kima na mansweki, nge me sadila mayela ya kumanga na kuzabisa munu? Kana nge zabisaka munu, mu zolaka sala ti, nge kwenda na nsayi nyonso, na kati ya mikunga mpe na muningu ya bangoma na bansambi. ");
INSERT INTO mkw_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nge me bikila munu ve ntangu ya kufiba bana na batekolo ya munu. Na mbala yayi, nge me sala dyambu ya buzoba! ");
INSERT INTO mkw_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mu lenda sala beno yimbi. Kasi na mpimpa, Nzambi ya tata ya beno me tuba na munu ti: “Sala keba, kuzonza ata dyambu ve na Yakobi.” ");
INSERT INTO mkw_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mu zaba ti, nge ke na kwendaka samu ti, nge vwandaka na nsatu mingi ya kuvutuka na yinzo ya tata ya nge. Kasi, samu na yinki nge me laba banzambi ya munu?» ");
INSERT INTO mkw_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobi vutulaka na Labane: «Mu vwandaka na boma. Mu vwandaka banza ti nge ke botola munu bana ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kasi, kana nge tala banzambi ya nge na sika ya muntu mosi na kati ya beto, muntu yina fwana kufwa. Na mantwala ya bampangi ya beto, tala na kati ya bima ya munu mpe baka yina kele ya nge. Yakobi vwandaka zaba ve ti ni Lasele labaka banzambi yina. ");
INSERT INTO mkw_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labane kotaka na yinzo ya lele ya Yakobi, yandi kotaka na yinzo ya lele ya Leya, yandi kotaka mpe na yinzo ya lele ya bisadi zole ya bakento, kasi yandi talaka kima ve. Ntangu yandi basikaka na yinzo ya lele ya Leya, yandi kwendaka kota na yinzo ya lele ya Lasele. ");
INSERT INTO mkw_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Na kutala mbote, ni Lasele labaka banzambi yango ya biteki. Yandi bumbaka yawu na yisi ya kima yina ba ke vwandilaka na zulu ya samo. Yandi vwandaka ya kuvwanda na zulu ya yawu. Kasi Labane sosaka na kati ya yinzo ya lele ya Lasele, yandi talaka ve biteki ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Lasele tubaka na tata ya yandi: «Mfumu ya munu, kudasuka ve kana mu me telama ve na mantwala ya nge, samu ti mu ke na menga.» Labane sosaka banzambi ya yandi ya biteki, mpe yandi talaka yawu ve. ");
INSERT INTO mkw_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakobi dasukaka. Yandi bandaka na kuswanisa Labane mpe yandi tubaka: «Wapi yimbi mpe wapi disumu yina mu me sala samu ti, nge landa munu mutindu yayi? ");
INSERT INTO mkw_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ntangu nge me sosa na kati ya bima ya munu nyonso, wapi kima ya yinzo ya nge, nge me tala kuna? Lakisa yawu na mantwala ya bantu ya nge mpe na mantwala ya bantu ya munu, samu ti bawu, ba zengila beto mambu yayi. ");
INSERT INTO mkw_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Mu me vwanda na nge bamvula makumi zole. Ata kilumbu mosi ve, kivumu ya dimeme ya mbakala to ya nkombo ya nge basikaka. Mpe mu kudyaka ve ata dimeme mosi na kati ya bibulu ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mu vwandaka natina nge ve dimeme to nkombo yina bibulu ya mfinda me kufwa. Ni munu mosi vwandaka futa yawu. Nge vwandaka futisa munu mpe konso kibulu yina ba vwandaka laba na mpimpa to na ntangu. ");
INSERT INTO mkw_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Na ntangu, mu vwandaka tala mpasi mingi na tiya. Mpe na mpimpa, mu vwandaka kufwa na madidi, mpe mu vwandaka lembana na kuzwa pongi. ");
INSERT INTO mkw_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Mu me zinga na sika ya nge bamvula makumi zole. Mu me sadila nge bamvula kumi na yiya, samu na kukwela bana ya nge zole. Mpe mu me sadila nge bamvula sambanu samu na mameme na bankombo ya nge. Bambala kumi, nge sobaka difuta ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kana Nzambi ya tata ya munu Isaaki, Nzambi ya Abalayami, Nzambi yina ke tekitisaka tata ya munu Isaaki, kana yandi vwandaka ve na munu, nge zolaka vutula munu maboko mpamba. Kasi, Nzambi talaka kunyokola yina nge vwandaka nyokola munu mpe mpasi ya kisalu yina mu vwandaka sala. Ni yawu yina, na mpimpa, yandi mosi me kwiza zenga mambu yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labane tubaka na Yakobi: «Bakento yayi kele bana ya munu, bana ya bawu kele bana ya munu, bibulu yayi kele bibulu ya munu. Bima nyonso yayi nge ke na kutala kele ya munu. Yinki dyaka mu lenda sala bubu yayi, samu na bana ya munu to samu na bana yina bawu me buta? ");
INSERT INTO mkw_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ntangu yayi, beto sala ngwisani nge na munu. Beto ke tula kidimbu yina ke vwanda mutindu kimbangi ya ngwisani ya nge na munu.» ");
INSERT INTO mkw_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakobi bakaka ditadi, mpe yandi telemisaka yawu mutindu kidimbu. ");
INSERT INTO mkw_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Na manima, Yakobi tubaka na bantu ya yandi: «Beno lokota matadi.» Bawu lokotaka matadi mpe bawu yidikaka kikunku ya matadi. Na manima, bawu kudyaka na zulu ya matadi yango. ");
INSERT INTO mkw_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labane pesaka kisika yina nkumbu Yengale-Sayaduta, mpe Yakobi pesaka yawu nkumbu Ngalede. ");
INSERT INTO mkw_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labane tubaka: «Kubanda bubu yayi, kikunku ya matadi yayi kele mbangi ya nge na munu.» Ni yawu yina, ba pesaka kisika yina nkumbu Ngalede. ");
INSERT INTO mkw_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Bawu pesaka dyaka kisika yango nkumbu Misepa samu ti Labane tubaka dyaka: «Bika ti Yave kukengidila nge na munu bantangu nyonso yina beto ke talana ve. ");
INSERT INTO mkw_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kana nge nyokola bana ya munu, mpe kana nge kwela dyaka bakento ya nkaka, ni muntu ve ke vwanda mbangi. Kasi sala ya nge keba, ni Nzambi yandi mosi ke vwanda mbangi ya nge na munu.» ");
INSERT INTO mkw_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Na manima, Labane tubaka na Yakobi: «Tala kikunku ya matadi yayi, mpe ditadi yina mu me telemisa mutindu kidimbu. Mu me tula yawu na kati-kati ya nge na munu. ");
INSERT INTO mkw_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kikunku yayi ya matadi kele mbangi. Ditadi yayi ya kutelama mutindu kidimbu, yawu mpe kele mbangi na dyambu yayi: Mu ke luta ve kikunku yayi ya matadi, na kwiza na lweka ya nge samu na kusala nge yimbi. Nge mpe, nge ke luta ve yawu na kukwiza na lweka ya munu samu na kusala munu yimbi. ");
INSERT INTO mkw_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Bika ti Nzambi ya Abalayami, mpe Nzambi ya Nawole kuvwanda bazuzi na kati-kati ya nge na munu. Ya vwandaka Nzambi ya bankooko ya bawu.» Yakobi kudyaka ndefi na nkumbu ya Nzambi yina vwandaka tekitisa tata ya yandi Isaaki. ");
INSERT INTO mkw_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakobi pesaka Nzambi munkayulu kuna na mongo. Yandi bokilaka bantu ya yandi samu na kudya. Bawu kudyaka mpe bawu lutisaka mpimpa kuna na zulu ya mongo. ");
INSERT INTO mkw_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Labane vumbukaka na suka-suka. Yandi fibaka bana ya yandi na batekolo ya yandi. Yandi sakumunaka bawu mpe na manima, yandi vutukaka na bwala ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobi vwandaka landa nzila ya yandi, mpe bambazi ya Nzambi kwizaka bwabana yandi. ");
INSERT INTO mkw_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ntangu Yakobi talaka bawu, yandi tubaka: «Yayi kele kisika ya nkonga ya bambazi ya Nzambi.» Mpe yandi pesaka kisika yango nkumbu Maanayime. ");
INSERT INTO mkw_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakobi fidisaka bantu, samu ti bawu tekila na sika ya mpangi ya yandi Esawu, kuna na kizunga ya Edome, na yinsi ya Seyile. ");
INSERT INTO mkw_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Yakobi tumisaka bawu mutindu yayi: «Beno kwenda tuba na mfumu ya munu Esawu ti, kisadi ya nge Yakobi me tuba mutindu yayi: “Mu kwendaka zinga ntangu mingi na bunzenza, na sika ya Labane. Mu me vwanda kuna tii bubu yayi. ");
INSERT INTO mkw_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mu ke na bangombe, bambuluku, mameme na bankombo, bisadi ya bakento na ya babakala. Mu me fidisa bantu na kwiza zabisa nge yawu, samu ti nge mfumu ya munu, nge yamba munu mbote.”» ");
INSERT INTO mkw_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Bantu yina vutukaka na sika ya Yakobi mpe bawu tubaka: «Beto me kwenda tala mpangi ya nge Esawu. Yandi mpe ke na kukwiza na bankama yiya (400) ya bantu samu na kubwabana nge.» ");
INSERT INTO mkw_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakobi kumaka na boma mingi mpe ntima ya yandi vwandaka dyaka ve na kizunu. Na yina, yandi kabulaka na bankonga zole bantu yina vwandaka na yandi, na mameme, bankombo, bangombe mpe basamo. ");
INSERT INTO mkw_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yakobi tubaka na yisi ya ntima: «Kana Esawu nwanisa mpe nunga nkonga mosi, nkonga ya nkaka lenda vuuka.» ");
INSERT INTO mkw_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Na manima, Yakobi sambilaka mutindu yayi: «Nzambi ya nkooko ya munu Abalayami, Nzambi ya tata ya munu Isaaki, Yave, ni nge tubaka na munu ti: “Vutuka na yinsi ya nge, na sika ya dikanda ya nge. Mu ke sadila nge mambu ya mbote.” ");
INSERT INTO mkw_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Mu kele muntu ya mfunu mingi ve samu na kuzwa bumbote ya nge ya kulutila mpe kukwikama ya nge, munu kisadi ya nge. Mu vwandaka kaka na mwa yinti na maboko ntangu mu sabukaka nzadi yayi ya Yolodani. Kasi, bubu yayi, mu me kuma na bankonga zole ya muvimba. ");
INSERT INTO mkw_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mulemvo ya nge, kuula munu na maboko ya mpangi ya munu Esawu! Mu kele na boma ti yandi kwiza kufwa munu, bamama na bana ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nge tubaka na munu mutindu yayi: “Mu ke sadila nge mambu ya mbote. Mu ke sala ti bana ya nge kukuma mingi mutindu munyenge ya mubu. Mpe ba ke lenda ve na kutanga lutangu ya bawu.”» ");
INSERT INTO mkw_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yakobi lutisaka mpimpa yina kuna. Na kati ya bima yina yandi vwandaka na yawu, yandi katulaka ndambu samu na kupesa dikabu na mpangi ya yandi Esawu: ");
INSERT INTO mkw_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Bankombo ya nkento: bankama zole (200), bankombo ya mbakala: makumi zole, mameme ya nkento: bankama zole (200), mameme ya mbakala: makumi zole, ");
INSERT INTO mkw_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","basamo ya nkento na bana yina bawu vwandaka nwikisa mabene: makumi tatu, bangombe ya nkento: makumi yiya, bangombe ya mbakala: kumi, bambuluku ya kento: makumi zole, bampunda ya mbakala: kumi. ");
INSERT INTO mkw_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakobi pesaka nkonga mosi-mosi ya bibulu na maboko ya bisadi ya yandi. Yandi tubaka na bawu: «Beno luta na mantwala ya munu. Konso nkonga kutambula mwa ntama na bampangi. Beno vwanda ve pene-pene na bampangi.» ");
INSERT INTO mkw_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Na kisadi ya ntete, Yakobi pesaka lutumu yayi: «Ntangu mpangi ya munu, Esawu, ke kutana na nge, kana yandi yufula nge: “Nani kele mfumu ya nge? Wapi kisika nge ke na kukwenda? Nkonga yina ke na kutambula na mantwala ya nge kele ya nani?” ");
INSERT INTO mkw_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nge ke vutula mutindu yayi: “Yawu kele ya kisyelo ya nge Yakobi. Yawu kele dikabu yina yandi me fidisa na nge mfumu ya munu, Esawu. Yandi mosi ke na kukwiza na manima ya beto.”» ");
INSERT INTO mkw_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Yakobi pesaka kaka lutumu yina na kisadi ya zole, na ya tatu, mpe na bantu nyonso yina vwandaka tambula na manima ya bibulu. Yandi tubaka na bawu: «Ni mutindu yina beno ke zonza na Esawu ntangu beno ke kutana na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Beno ke zabisa mpe yandi mutindu yayi: “Yandi mosi kisadi ya nge Yakobi ke na kukwiza na manima ya beto.”» Yakobi vwandaka tuba na yisi ya ntima ya yandi: «Mu ke lembisa ntima ya Esawu na dikabu yina ke na kutekila. Na manima, munu mosi mu ke talana na meso ya yandi. Mu ke na kivuvu ti, yandi ke yamba munu mbote.» ");
INSERT INTO mkw_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Dikabu yina yandi kubikaka tekilaka. Yandi mosi, yandi bikanaka na mpimpa yina, kuna na kisika yina bawu kwendaka vwanda. ");
INSERT INTO mkw_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kaka na mpimpa yina, Yakobi telamaka mpe bakaka bakento ya yandi zole, na bisadi ya yandi zole ya bakento, mpe bana ya yandi kumi na mosi. Yandi sabukaka na bawu muzumba ya Yaboke, na kisika yina maza vwandaka mingi ve. ");
INSERT INTO mkw_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yandi bakaka bawu, yandi sabulaka bawu. Yandi sabulaka mpe bima ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yakobi bikanaka yandi mosi. Muntu mosi nwanaka na yandi mpimpa nyonso tii na suka-suka. ");
INSERT INTO mkw_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ntangu bawu vwandaka nwana, muntu yango talaka ti yandi vwandaka lenda ve na kununga Yakobi. Na yina, yandi bulaka Yakobi na dibunda. Mpe mukwa ya dibunda ya Yakobi kwabukaka na kisika yina yawu ke vukanaka na luketo. ");
INSERT INTO mkw_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Muntu yango tubaka: «Bika mu kwenda samu ti bwisi ke na kutsya.» Yakobi vutulaka: «Mu ke bika nge ve, kana nge sakumuna munu ve.» ");
INSERT INTO mkw_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Muntu yango tubaka: «Nkumbu ya nge nani?» Yandi vutulaka: «Nkumbu ya munu Yakobi.» ");
INSERT INTO mkw_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Muntu yango tubaka dyaka: «Nkumbu ya nge ke vwanda dyaka ve Yakobi, kasi, ya me kuma Isayeli. Samu ti, nge me nwana na Nzambi mpe na bantu, mpe nge me nunga.» ");
INSERT INTO mkw_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobi yufulaka yandi: «Mulemvo ya nge, zabisa munu nkumbu ya nge.» Muntu yina vutulaka: «Samu na yinki nge ke na kuyufula nkumbu ya munu?» Na yina, muntu yango sakumunaka Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakobi pesaka kisika yina nkumbu Penyele, samu ti yandi tubaka: «Mu me talasana na Nzambi, kasi mu me kufwa ve.» ");
INSERT INTO mkw_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ntangu Yakobi sabukaka muzumba ya Yaboke, na kisika ya Penwele, ntangu vwandaka me basika. Yandi vwandaka tambula mbote ve samu na dibunda ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Ni yawu yina, tii bubu yayi, bantu ya Isayeli ke kudyaka ve musisa yina ke vukisaka luketo na dibunda. Samu ti, ni na kisika yina ba bulaka Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobi talaka Esawu yina vwanda kwiza na babakala bankama yiya (400). Na yina, yandi pesaka bana ya yandi na maboko ya Leya, na ya Lasele, mpe na maboko ya bisadi ya yandi zole ya bakento. ");
INSERT INTO mkw_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yandi tulaka bisadi ya bakento na bana ya bawu na mantwala. Na manima ya bawu, yandi tulaka Leya na bana ya yandi. Na manima ya Leya, yandi tulaka Lasele na Yosefi. ");
INSERT INTO mkw_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Kasi yandi mosi, yandi lutaka na mantwala ya bawu nyonso. Yandi kubwaka kizizi na ntoto bambala nsambwadi tii ntangu yandi kumaka pene-pene ya mpangi ya yandi, Esawu. ");
INSERT INTO mkw_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esawu kwendaka mbangu samu na kubwabana Yakobi. Bawu bumbasanaka, Esawu fibaka Yakobi mpe bawu zole bandaka na kudila. ");
INSERT INTO mkw_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ntangu Esawu talaka bakento mpe bana, Yandi yufulaka: «Yayi ni ba nani?» Yakobi vutulaka: «Yayi ni bana yina Nzambi, na bumbote ya yandi, me pesa na kisyelo ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Bisadi ya bakento belamaka na bana ya bawu mpe bawu fukamaka. ");
INSERT INTO mkw_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya na bana ya yandi mpe belamaka, bawu fukamaka. Na manima, Lasele na Yosefi belamaka, bawu mpe fukamaka. ");
INSERT INTO mkw_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esawu tubaka: «Yinki nge zola sala na nkonga nyonso yina mu me bwabana?» Yakobi vutulaka: «Yawu kele samu ti, mfumu ya munu kuyamba munu mbote.» ");
INSERT INTO mkw_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esawu tubaka dyaka: «Ve mpangi ya munu, vwanda na bima ya nge. Mu kele na bimvwama mingi.» ");
INSERT INTO mkw_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Na yina, Yakobi tubaka: «Mulemvo ya nge, kana nge me yamba munu mbote, ndima mpe dikabu yina mu ke na kupesa nge. Ya tsyelika, mu me tala kizizi ya nge mutindu muntu me tala kizizi ya Nzambi. Mpe nge me yamba munu mbote. ");
INSERT INTO mkw_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ndima dikabu yayi mu ke na kupesa nge, samu ti ni Nzambi me pesa munu yawu na bumbote ya yandi. Mpe mu ke na bima nyonso.» Yakobi tatamanaka na kubondila Esawu, mpe Esawu ndimaka. ");
INSERT INTO mkw_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esawu tubaka: «Beto telama, beto kwenda. Mu ke kwenda nzila mosi na nge.» ");
INSERT INTO mkw_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakobi vutulaka: «Mfumu ya munu, nge zaba ti bana ya munu ke na ngolo mingi ve. Mu kele mpe na mameme, bankombo na bangombe yina ke ntete na kupesaka bana mabene. Kana beto kwika bawu na kutambula ata kilumbu mosi ya muvimba, bibulu nyonso ke manisa na kufwa. ");
INSERT INTO mkw_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mulemvo ya nge mfumu ya munu, tekila ya nge. Munu kisadi ya nge, mu ke tambula malembe-malembe. Mu ke landa ndyatulu ya nkonga yina ke vwanda na mantwala ya munu, mpe ndyatulu ya bana, tii ntangu yina mu ke kuma na sika ya nge, mfumu ya munu, kuna na Seyile.» ");
INSERT INTO mkw_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawu tubaka: «Mu ke bikila nge ndambu ya bantu ya munu.» Yakobi vutulaka: «Mfumu ya munu, samu na yinki? Kuyamba yina nge me yamba munu na bumbote me lunga.» ");
INSERT INTO mkw_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kaka na kilumbu yina, Esawu bakaka nzila mpe yandi vutukaka na Seyile. ");
INSERT INTO mkw_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kasi Yakobi kwendaka na Sukote. Yandi tungaka yinzo ya yandi na bayinzo ya mileba samu na bibulu ya yandi. Ni yawu yina, ba pesaka kisika yina, nkumbu Sukote. ");
INSERT INTO mkw_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakobi kumaka mbote na mbanza Sekeme, yina kele na yinsi ya Kaana. Yandi vwandaka me katuka na Mezopotami. Kaka na ntangu yina yandi kwizaka kuma, yandi yidikaka yinzo ya yandi ya lele na kisika yina ke talasanaka na mbanza. ");
INSERT INTO mkw_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yandi sumbaka ntoto yina, kisika yina yandi vwandaka me yidika yinzo ya yandi ya lele. Na yina, yandi pesaka mbongo nkama (100) ya bisengo na sika ya bana ya Amole, tata ya Sekeme. ");
INSERT INTO mkw_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kuna, yandi yidikaka kiyokolo ya minkayulu. Yandi pesaka kisika yango nkumbu «Ele-Nzambi ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Kilumbu mosi, Dina, ndumba yina Leya butaka na Yakobi, basikaka samu na kwenda tala bandumba ya yinsi. ");
INSERT INTO mkw_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sekeme, mwana ya Amole, mu-Ivi yina vwandaka mfumu ya yinsi yina, yandi nataka Dina na ngolo mpe vukisaka mfulu na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ntima ya yandi kangamaka na Dina, mwana ya Yakobi. Yandi zolaka mwana ya kento, mpe yandi salaka nyonso samu ti Dina kuzola yandi. ");
INSERT INTO mkw_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Na yina, Sekeme tubaka na tata ya yandi, Amole: «Kwedila munu ndumba yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobi kuwaka ti, Sekeme sumunaka mwana ya yandi ya kento Dina. Kasi, mutindu bana ya yandi ya babakala vwandaka na bilanga na bibulu, yandi zonzaka ata dyambu tii ntangu yina bawu vutukaka. ");
INSERT INTO mkw_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Amole, tata ya Sekeme, kwendaka tala Yakobi samu na kusolola na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ntangu bana ya Yakobi katukaka na bilanga, bawu kuwaka mambu yina salamaka. Mambu yina talisaka bawu mpasi mingi na ntima, mpe bawu dasukaka mingi, samu ti, Sekeme salaka mambu ya busafu na Isayeli, na kuvukisa mfulu na ngolo na mwana ya Yakobi. Dyambu ya mutindu yayi ke salamaka ve! ");
INSERT INTO mkw_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amole tubaka na bawu mutindu yayi: «Mwana ya munu, Sekeme, me zola mingi mwana ya beno ya kento. Mulemvo ya beno, beno pesa Sekeme mwana ya beno samu ti, yandi kwela yandi. ");
INSERT INTO mkw_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Beto tungeno kintwadi na kwendaka kwelasana beto na beno. Beno ke banda na kukwelisa beto bana ya beno, beno mpe ke banda na kukwela bana ya beto. ");
INSERT INTO mkw_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Beno ke zinga kintwadi na beto. Beto ke pesa beno kimpwanza ya kusala nyonso yina beno zola, na yinsi ya beto. Beno ke tunga ya beno, beno ke sala mumbungu, beno ke kuzwa mvwilu mutindu beno zola.» ");
INSERT INTO mkw_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekeme tubaka na tata mpe bampangi ya Dina ya babakala: «Kana beno tala yawu mbote, mu ke pesa beno nyonso yina beno ke lomba munu. ");
INSERT INTO mkw_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Beno lenda lomba munu ntalu mingi ya makwela mpe bima ya mutindu na mutindu. Mu ke pesa beno nyonso yina beno ke lomba munu. Kasi, beno pesa munu mwana ya beno ya kento na makwela.» ");
INSERT INTO mkw_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Bana ya Yakobi pesaka mvutu ya luvunu na Sekeme mpe na tata ya yandi, Amole, samu ti Sekeme sumunaka kibusi ya bawu, Dina. ");
INSERT INTO mkw_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Bawu tubaka: «Beto lenda kwelisa ve kibusi ya beto na muntu yina ba me zenga ve bubakala. Ya ke dyambu ya nsoni samu na beto. ");
INSERT INTO mkw_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kana beno zola ti beto ndima, beno fwana kuvwanda mutindu beto. Babakala nyonso fwana kuzengisa bubakala ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Na manima, beto ke kwelisa beno bana ya beto, mpe beto ke kwela bana ya beno. Beto ke zinga kintwadi na beno, mpe beto ke vwanda muntu mosi. ");
INSERT INTO mkw_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kana beno kuwa beto ve, kana beno manga na kuzengisa bubakala, beto ke baka mwana ya beto ya kento, mpe beto ke kwenda ya beto.» ");
INSERT INTO mkw_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Amole na mwana ya yandi, Sekeme, bawu talaka ti ya vwandaka dyambu ya mbote. ");
INSERT INTO mkw_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Na yina, mwana ya bakala lutisaka dyaka ve ntangu na kusadila mambu yina ba zabisaka yandi. Samu ti, yandi zolaka mingi mwana ya Yakobi. Sekeme vwandaka muntu ya kulutila mfunu na kati ya dikanda ya tata ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Amole na mwana ya yandi, Sekeme, bawu kwendaka na mwelo ya mbanza ya bawu, kisika yina bantu ke yonzamaka. Mpe bawu tubaka na bantu ya mbanza ya bawu mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Bantu yayi ke na mabanza ya mbote na beto. Bika ti bawu kuvwanda na yinsi ya beto, mpe bawu sala mumbungu mutindu bawu zola. Yinsi kele ya yawu nene. Beto lenda kwela bana ya bawu, bawu mpe ba lenda kwela bana ya beto. ");
INSERT INTO mkw_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kasi bawu na kundima na kuvwanda kintwadi na beto mpe kuvwanda muntu mosi, babakala nyonso ya beto fwana kuzengisa ntete bubakala ya bawu, samu na kuvwanda mutindu mosi na bawu. ");
INSERT INTO mkw_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Bibulu nyonso ya bawu mpe mvwilu ya bawu, yawu ke vwanda ya beto. Beto ndima kaka mambu yina bawu me tuba, samu ti, bawu zinga kintwadi na beto.» ");
INSERT INTO mkw_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bantu nyonso yina vwandaka na mwelo ya mbanza, kisika yina bantu ke yonzamaka, bawu ndimaka mambu yina tubaka Amole na mwana ya yandi, Sekeme. Na yina, babakala nyonso ya mbanza zengisaka bubakala ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Na manima ya bilumbu zole, babakala nyonso ya mbanza yina vwandaka ntete na kati ya mpasi. Bana zole ya Yakobi, Simewone na Levi, bampangi ya Dina ya babakala, bawu kotaka na kizunu nyonso na mbanza, muntu na muntu na mbele ya yandi ya mvita. Bawu kufwaka babakala nyonso ya mbanza yina. ");
INSERT INTO mkw_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Bawu kufwaka mpe Amole na mwana ya yandi, Sekeme. Bawu bakaka Dina na yinzo ya Sekeme mpe bawu kwenda na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Bana ya Yakobi kwendaka botola bima ya bantu yina kufwaka. Bawu bakaka mpe bima nyonso ya mbanza. Samu ti, ba sumunaka kibusi ya bawu, Dina. ");
INSERT INTO mkw_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Bawu bakaka mameme, bankombo, bangombe, mbuluku na bima yina vwandaka na mbanza mpe yina vwandaka na bilanga. ");
INSERT INTO mkw_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bawu bakaka bakento, bana, na bimvwama nyonso ya bawu, mpe bima nyonso yina vwandaka na bayinzo ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Na yina, Yakobi tubaka na Simewone mpe Levi: «Beno me sosila munu mambu. Mu me kuma muntu ya yimbi na meso ya ba-Kaanani, ya ba-Pelizi, bantu ya yinsi yayi. Munu, mu kele ve na bantu mingi. Bawu ke vukana samu na kwiza nwanisa munu, mpe bawu ke nunga munu. Mu ke kufwa, munu na dikanda ya munu nyonso.» ");
INSERT INTO mkw_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Simewone na Levi vutulaka: «Beto ke ndima ti ba baka kibusi ya beto mutindu kento ya ndumba?» ");
INSERT INTO mkw_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kilumbu mosi, Nzambi tubaka na Yakobi: «Baka nzila, kwenda na Betele nge zinga kuna. Yidika kuna kiyokolo ya minkayulu na Nzambi yina kwizaka monikina nge, ntangu nge vwandaka kima mpangi ya nge, Esawu.» ");
INSERT INTO mkw_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Na yina, Yakobi tubaka na dikanda ya yandi mpe na bantu nyonso yina vwandaka na yandi: «Beno katula banzambi ya nzenza yina kele na kati-kati ya beno. Beno vedisa banzutu ya beno mpe beno soba binkuti ya beno.» ");
INSERT INTO mkw_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Beto ke telama na kukwenda na Betele. Kuna, mu ke yidika kiyokolo ya minkayulu na Nzambi yina pesaka munu mvutu ntangu yina mu vwandaka na mpasi. Yandi vwandaka na munu na bisika yina mu vwandaka tambula. ");
INSERT INTO mkw_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Na yina, bawu pesaka na Yakobi banzambi ya nzenza yina vwandaka na bawu, na binzembele yina vwandaka na makutu ya bawu. Yakobi kundaka yawu na yisi ya yinti ya telembente yina vwandaka pene-pene na Sekeme. ");
INSERT INTO mkw_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Bawu kwendaka. Mpe Nzambi salaka ti, bantu ya bambanza yina vwandaka pene-pene na bawu, kuvwanda na boma mingi. Na yina, ata muntu ve landaka bana ya Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobi na bantu nyonso yina vwandaka na yandi, bawu kumaka na Luze, yina ba ke bokilaka mpe Betele, kuna na yinsi ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Kuna, Yakobi yidikaka kiyokolo ya minkayulu. Mpe yandi pesaka kisika yina nkumbu Ele-Betele, samu ti, ni kuna Nzambi monikinaka yandi ntangu yina yandi vwandaka kima mpangi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debola, kento yina vwandaka keba Lebeka kufwaka. Ba tulaka yandi na ndyamu, kuna na banda ya Betele na yisi ya yinti ya nene. Ni yawu yina, ba pesaka yinti yina nkumbu «Yinti ya bidilu.» ");
INSERT INTO mkw_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Nzambi monikinaka dyaka Yakobi ntangu yandi katukaka na Mezopotami, mpe yandi sakumunaka Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nzambi tubaka na yandi: «Nkumbu ya nge kele Yakobi. Kasi ba ke bokila dyaka nge ve na nkumbu ya Yakobi, nkumbu ya nge me kuma Isayeli. Ni mutindu yina, Nzambi pesaka yandi nkumbu Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nzambi tubaka na yandi: «Mu kele Nzambi-Mpungu. Buta bana mingi, mpe beno kuma mingi. Nge ke vwanda nkooko ya yinsi mpe ya makanda mingi. Bantinu ke butuka na dikanda ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Yinsi yina mu pesaka na Abalayami mpe Isaaki, mu ke pesa nge yawu. Mu ke pesa yawu mpe na bana ya nge yina ke kwiza na manima ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Nzambi bikaka Yakobi na kisika yina yandi sololaka na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobi telemisaka ditadi mutindu kidimbu na kisika yina Nzambi sololaka na yandi. Yawu vwandaka ditadi ya kutelama mutindu kidimbu. Yandi bulumunaka yawu mafuta mpe vinu mutindu munkayulu. ");
INSERT INTO mkw_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakobi pesaka nkumbu ya Betele na kisika yina Nzambi sololaka na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakobi na dikanda ya yandi, bawu katukaka na Betele. Ntangu bawu kumaka ntama ve na Efalata, Lasele butaka. Kubuta ya yandi vwandaka ya mpasi. ");
INSERT INTO mkw_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mutindu mpasi lutilaka yandi ntangu yina yandi vwandaka buta, kibutisi ya yandi tubaka na yandi: «Kuvwanda ve na boma, nge me kuzwa dyaka mwana ya bakala.» ");
INSERT INTO mkw_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Lasele kumaka pene-pene ya lufwa. Ntete yandi kufwa, Lasele pesaka mwana nkumbu Bene-Oni, kasi tata ya yandi pesaka yandi nkumbu Bezame. ");
INSERT INTO mkw_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Lasele kufwaka mpe ba tulaka yandi na ndyamu, kuna na nzila ya Efalata, mbanza yina ba ke na kubokilaka Betelemi. ");
INSERT INTO mkw_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobi telemisaka ditadi mutindu kidimbu na ndyamu ya Lasele. Tii bubu yayi, ni yawu kele ditadi ya kutelama na ndyamu ya Lasele mutindu kidimbu. ");
INSERT INTO mkw_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isayeli kwendaka yidika yinzo ya yandi ya lele kuluta Mingedale-Edele. ");
INSERT INTO mkw_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ntangu yina Isayeli vwandaka zinga na yinsi yina, Lubene vukisaka mfulu na Bila, kento ya nkaka ya tata ya yandi, Yakobi. Mpe Isayeli kuwaka dyambu yina. Isayeli vwandaka na bana kumi na zole ");
INSERT INTO mkw_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Bana ya Leya ni: Lubene, mwana ya ntete ya Yakobi, Simewone, Levi, Yuda, Isakale na Zabulone. ");
INSERT INTO mkw_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Bana ya Lasele ni Yosefi na Bezame. ");
INSERT INTO mkw_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bana ya Bila, kisadi ya Lasele ya kento ni Dane na Nafetali. ");
INSERT INTO mkw_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Bana ya Zilepa, kisadi ya Leya ya kento ni Ngade na Asele. Yina ni bana ya Yakobi yina yandi butaka na Mezopotami. ");
INSERT INTO mkw_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobi kumaka na sika ya tata ya yandi Isaaki na Mamele, pene-pene ya Kilyate-Aleba, yina ba ke bokilaka Ebelone. Ni kuna, Abalayami na Isaaki zingaka na bunzenza. ");
INSERT INTO mkw_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaaki zingaka bamvula nkama na makumi nana (180), ");
INSERT INTO mkw_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaaki lutisaka bamvula mingi na buboba ya yandi, na manima, yandi kufwaka. Yandi kwendaka vukana na bankooko ya yandi yina kufwaka. Bana ya yandi Esawu na Yakobi tulaka yandi na ndyamu. ");
INSERT INTO mkw_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Yayi ni mukanda ya bankumbu ya bana ya Esawu, yina ba ke bokilaka mpe Edome. ");
INSERT INTO mkw_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu kwelaka bakento ya yandi na kati ya bandumba ya yinsi ya Kaana. Ya vwandaka: Ada, mwana ya Elone mu-Iti, Owolibama, mwana ya Ana, mutekolo ya Sibewone mu-Ivi. ");
INSERT INTO mkw_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Yandi kwelaka mpe Basemate, mwana ya Isemayele. Basemate vwandaka kibusi ya Nebayote. ");
INSERT INTO mkw_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada na Esawu butaka Elifaze. Basemate butaka Lewele. ");
INSERT INTO mkw_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Owolibama butaka Yewuse, Yayelame na Kola. Yina ni bana Esawu butaka na yinsi ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esawu bakaka bakento ya yandi, bana ya yandi ya bakento na ya babakala mpe bantu nyonso yina vwandaka zinga na yinzo ya yandi. Yandi bakaka mpe bibulu ya yandi nyonso, na mvwilu nyonso yina yandi kuzwaka na yinsi ya Kaana. Yandi kwendaka na yinsi ya nkaka, ntama na kisika yina vwandaka mpangi ya yandi Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Yandi kwendaka ya yandi samu ti, mvwilu ya bawu vwandaka me kuma ya kulutila. Bawu lendaka vwanda dyaka ve kisika mosi. Yinsi yina bawu vwandaka zinga na bunzenza vwandaka me kuma fyoti samu na bibulu ya bawu ya mingi-mingi. ");
INSERT INTO mkw_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ni yawu yina, Esawu, yina ba ke bokilaka Edome, kwendaka zinga na mongo ya Seyile. ");
INSERT INTO mkw_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Yayi ni mukanda ya bankumbu ya bana ya Esawu, nkooko ya ba-Edome, bayina vwandaka zinga na mongo ya Seyile. ");
INSERT INTO mkw_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Bana ya Esawu ni: Elifaze, mwana yina yandi butaka na kento ya yandi Ada, Lewele mwana yina yandi butaka na kento ya yandi Basemate. ");
INSERT INTO mkw_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Bana ya Elifaze ni: Temane, Omale, Sefo, Ngayetame na Kenaze. ");
INSERT INTO mkw_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timena vwandaka dikangu ya Elifaze, mwana ya Esawu. Timena butaka na yandi Amaleke. Yina ni bana ya Ada, kento ya Esawu. ");
INSERT INTO mkw_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Bana ya Lewele ni: Nayate, Zela, Sama na Miza. Yina ni bana ya Basemate, kento ya Esawu. ");
INSERT INTO mkw_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Owolibama, mwana ya Ana, mpe mutekolo ya Sibewone, vwandaka mpe kento ya Esawu. Yandi butaka na Esawu bana yayi: Yewuse, Yayelame mpe Kola. ");
INSERT INTO mkw_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Yayi ni bamfumu ya makanda yina Esawu butaka: Bana ya Elifaze mwana ya ntete ya Esawu ni: Mfumu Temane, mfumu Omale, mfumu Sefo, mfumu Kenaze, ");
INSERT INTO mkw_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","mfumu Kola, mfumu Ngayetame, mfumu Amaleke. Yina ni bana ya Elifaze yina vwandaka zinga na yinsi ya Edome. Bawu ni batekolo ya Ada, kento ya Esawu. ");
INSERT INTO mkw_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Bana ya Lewele, mwana ya Esawu ni: Mfumu Nayate, mfumu Zela, mfumu Sama, mfumu Miza. Yina ni bamfumu yina butaka Lewele, bayina vwandaka zinga na Edome. Bawu ni batekolo ya Basemate, kento ya Esawu. ");
INSERT INTO mkw_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Bana ya Owolibama, kento ya Esawu ni: Mfumu Yewuse, mfumu Yayelame, mfumu Kola. Yina ni bamfumu yina Owolibama, kento ya Esawu, butaka. Owolibama vwandaka mwana ya Ana. ");
INSERT INTO mkw_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Yina ni bana ya Esawu, bayina vwandaka bamfumu ya makanda ya bawu. Esawu, ni yandi ba ke bokilaka mpe Edome. ");
INSERT INTO mkw_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Yayi ni bana ya Seyile, mu-Woli, bayina vwandaka zinga ntete na yinsi yina: Lotane, Sobale, Sibewone, Ana, ");
INSERT INTO mkw_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disone, Esele mpe Disane. Bawu ni bamfumu ya ba-Woli, bana ya Seyile, kuna na yinsi ya Edome. ");
INSERT INTO mkw_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Bana ya Lotane ni Oli mpe Emane. Kibusi ya Lotane vwandaka Timena. ");
INSERT INTO mkw_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Bana ya Sobale ni: Alevane, Manayate, Ebale, Sefo mpe Oname. ");
INSERT INTO mkw_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Bana ya Sibewone ni Aya mpe Ana. Ni Ana bakulaka yinto ya maza ya tiya na yinsi ya kuyuma, ntangu yandi vwandaka kwenda dikila bambuluku ya tata ya yandi, Sibewone. ");
INSERT INTO mkw_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Bana ya Ana ni Disone, mwana ya yandi ya bakala na Owolibama, mwana ya yandi ya kento. ");
INSERT INTO mkw_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Bana ya Disane ni: Emedane, Esebane, Yitelane mpe Kelane. ");
INSERT INTO mkw_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Bana ya Esele ni: Bilane, Zavane mpe Akane. ");
INSERT INTO mkw_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Bana ya Disane ni: Wuse mpe Alane. ");
INSERT INTO mkw_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Yayi ni bamfumu ya makanda ya ba-Woli: Mfumu Lotane, mfumu Sobale, mfumu Sibewone, mfumu Ana, ");
INSERT INTO mkw_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","mfumu Disone, mfumu Esele, mfumu Disane. Yina ni bamfumu ya makanda ya ba-Woli na yinsi ya Seyile. ");
INSERT INTO mkw_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Yayi ni bantinu yina yalaka yinsi ya Edome ntete ti bantinu kubanda na kuyala bana ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, mwana ya Bewole, kumaka ntinu ya Edome. Nkumbu ya mbanza ya yandi vwandaka Dinaba. ");
INSERT INTO mkw_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela kufwaka. Yobabe, mwana ya Zela, muntu ya mbanza Bosela, kumaka ntinu na kisika ya Bela. ");
INSERT INTO mkw_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabe kufwaka. Usame, muntu ya yinsi ya ba-Temane, kumaka ntinu na kisika ya Yobabe. ");
INSERT INTO mkw_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Usame kufwaka. Adade, mwana ya Bedade, kumaka ntinu na kisika ya Usame. Ni Adade nungaka Midyane na yinsi ya Mowabe. Nkumbu ya mbanza ya Adade vwandaka Avite. ");
INSERT INTO mkw_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Adade kufwaka. Samela, muntu ya mbanza Maseleka, kumaka ntinu na kisika ya Adade. ");
INSERT INTO mkw_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samela kufwaka. Sawule, muntu ya Lewobote-Naale, kumaka ntinu na kisika ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawule kufwaka. Baale-Anane, mwana ya Akebole, kumaka ntinu na kisika ya Sawule. ");
INSERT INTO mkw_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baale-Anane, mwana ya Akebole, kufwaka. Yadale kumaka ntinu na kisika ya Baale-Anane. Nkumbu ya mbanza ya yandi vwandaka Pawu. Nkumbu ya kento ya yandi vwandaka Metabeele. Metabeele vwandaka mwana ya Matelede, mpe mutekolo ya Mezayabe. ");
INSERT INTO mkw_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Yayi ni bankumbu ya bamfumu ya Esawu, mutindu vwandaka bifumba ya bawu mpe bisika yina bawu vwandaka: Mfumu Timena, mfumu Aleva, mfumu Yetete, ");
INSERT INTO mkw_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","mfumu Owolibama, mfumu Ela, mfumu Pinone, ");
INSERT INTO mkw_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","mfumu Kenaze, mfumu Temane, mfumu Mibesale, ");
INSERT INTO mkw_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","mfumu Mangedyele, mfumu Ilame. Ni bawu vwandaka bamfumu ya ba-Edome ntangu ba-Edome vwandaka zinga na yinsi yina kumaka mvwilu ya bawu. Esawu kele nkooko ya ba-Edome. ");
INSERT INTO mkw_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobi zingaka na yinsi ya Kaana, yinsi yina tata ya yandi kwendaka vwanda mutindu nzenza. ");
INSERT INTO mkw_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Nongo ya bana ya Yakobi ni yayi: Yosefi vwandaka na bamvula kumi na nsambwadi. Yandi vwandaka muvungi ya mameme na bankombo kintwadi na bampangi ya yandi. Yandi vwandaka ntwenya, kintwadi na bana ya Bila mpe Zilepa, bakento ya tata ya yandi. Yandi vwandaka kumisa na tata ya yandi yimbi yina bampangi ya yandi vwandaka sala. ");
INSERT INTO mkw_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isayeli vwandaka zola Yosefi kulutila bana ya yandi nyonso, samu ti yandi butaka Yosefi na buboba ya yandi. Isayeli yidikilaka yandi kinkuti ya kitoko mingi, ya mutindu ya yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Bampangi ya yandi talaka ti tata ya bawu vwandaka zola yandi kulutila bawu nyonso. Ni yawu yina, bawu bandaka na kuyina yandi, mpe bawu lendaka dyaka ve na kuzonzisa yandi na kizunu. ");
INSERT INTO mkw_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kilumbu mosi Yosefi lotaka ndosi. Yandi zabisaka yawu na bampangi ya yandi, mpe bawu yinaka dyaka yandi kulutila. ");
INSERT INTO mkw_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yandi tubaka na bawu ti: «Beno kuwa ntete ndosi yayi mu me lota. ");
INSERT INTO mkw_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Beto vwandaka kanga bifunda ya matiti ya bambuma ya faline na kati ya bilanga. Mbala mosi kifunda ya munu vumbukaka mpe telamaka. Bifunda ya beno zungidilaka mpe fukiminaka yina ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Bampangi ya yandi vutulaka: «Yinki! Nge ke yala beto, mpe nge ke vwanda mfumu ya beto?» Bawu lutilaka dyaka kuyina yandi samu na bandosi ya yandi, mpe samu na mambu yina yandi vwandaka zonza. ");
INSERT INTO mkw_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yosefi lotaka dyaka ndosi ya nkaka, mpe yandi zabisaka yawu na bampangi ya yandi mutindu yayi: «Beno tala! Mu me lota dyaka ndosi: ntangu na ngonda, na bambwetete kumi na mosi, vwandaka fukimina munu.» ");
INSERT INTO mkw_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yandi zabisaka yawu na tata ya yandi na bampangi ya yandi. Tata ngalaka yandi mpe tubaka ti: «Yayi mpe wapi ndosi nge me lota? Munu, na mama ya nge, na bampangi ya nge, beto ke kwiza fukimina nge?» ");
INSERT INTO mkw_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Bampangi ya Yosefi fulukaka na musoki na ntwala ya yandi, kasi tata ya yandi bumbaka dyambu yina na ntima. ");
INSERT INTO mkw_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Bampangi ya Yosefi kwendaka dikila mameme na bankombo ya tata ya bawu na kizunga ya Sekeme. ");
INSERT INTO mkw_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isayeli tubaka na Yosefi: «Bampangi ya nge kele na kudikila mameme na bankombo na kizunga ya Sekeme. Mu ke na kufidisa nge na sika ya bawu.» Yosefi ndimaka: «Ee! Mu ke kwenda.» ");
INSERT INTO mkw_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Isayeli tubaka: «Kwenda tala kana bampangi ya nge, kele ya bawu mbote kuna, na mameme na bankombo mpe kana bawu kele mbote, mpe natina munu nsangu.» Isayeli fidisaka Yosefi katuka dibenga ya Ebelone, mpe Yosefi kwizaka kuma na kizunga ya Sekeme. ");
INSERT INTO mkw_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Muntu mosi talaka yandi na kuyenga-yenga na matiti, mpe muntu yina yufulaka yandi: «Yinki nge ke na sosaka?» ");
INSERT INTO mkw_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yandi ti: «Mu ke na sosaka bampangi ya munu. Zabisa munu wapi sika ba ke na kudikila bibulu ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Muntu yina vutulaka: «Bawu me katuka kwaku. Samu ti mu kuwaka bawu na kuzonza ti: “Beto kwendeno na kizunga ya Dotane.”» Yosefi landaka bampangi ya yandi, mpe yandi kwendaka kuta bawu na kizunga ya Dotane. ");
INSERT INTO mkw_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Bawu talaka yandi na ntama. Mpe, tekila yandi kuma pene-pene na bawu, bawu salaka mfundu samu na kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Bawu tubaka bawu na bawu: «Tala muntu ya bandosi, yandi yayi ke na kukwiza. ");
INSERT INTO mkw_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ntangu ni yayi! Beto kufwa yandi, mpe beto losa yandi na kati ya dibulu mosi, na mabulu yayi ba timunaka samu na kuzwaka maza ya mvula. Beto ke tuba ti kibulu mosi ya nsisi me kudya yandi. Na manima, beto ke tala yinki bandosi ya yandi ke kuma.» ");
INSERT INTO mkw_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Lubene kuwaka dyambu yina, mpe yandi sosaka na kukuula Yosefi na maboko ya bawu. Yandi tubaka ti: «Beto kufwa yandi ve.» ");
INSERT INTO mkw_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Samu na kukuula Yosefi na maboko ya bawu, mpe kuvutula yandi na sika ya tata ya yandi, Lubene tubaka ti: «Beno kufwa ve muntu. Kasi beno losa kwandi yandi na kati ya dibulu yayi kele na yinsi ya kuyuma, yina ba timunaka samu na kuzwaka maza ya mvula. Beno kufwa yandi ve.» ");
INSERT INTO mkw_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ntangu Yosefi kwizaka kuma na sika ya bampangi ya yandi, bawu botolaka yandi kinkuti ya yandi, kinkuti yina ya kitoko mingi, ya mutindu ya yandi mosi, yina yandi vwandaka ya kuvwata. ");
INSERT INTO mkw_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Bawu bakaka yandi, mpe bawu losaka yandi na kati ya dibulu. Ata kima vwandaka na dibulu yango, maza vwandaka ve na kati ya yawu. ");
INSERT INTO mkw_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Na manima, bawu vwandaka samu na kudya. Bawu vumbulaka meso mpe bawu talaka nkonga mosi ya bantu ya mumbungu, ba-Isemayele, yina katukaka na yinsi ya Ngalaade, mpe vwandaka kwenda na yinsi ya Ngipiti. Bibulu ya bawu, yina ba ke bokilaka samo, vwandaka nata maaka ya nsunga ya mutindu na mutindu. ");
INSERT INTO mkw_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda tubaka na bampangi ya yandi ti: «Wapi ndandu kele na kufwa mpangi ya beto mpe kubumba lufwa ya yandi? ");
INSERT INTO mkw_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Beto tekisa kwandi yandi na ba-Isemayele, kasi beto kusimba yandi na kusala yandi yimbi ve. Samu ti yandi kele mpangi ya beto, beto kele menga mosi.» Bampangi ya yandi kuwaka mambu yina. ");
INSERT INTO mkw_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Bantu ya mumbungu ya yinsi ya Midyane lutilaka kuna. Bawu bendaka Yosefi, mpe basisaka yandi na dibulu. Bawu tekisaka yandi na ba-Isemayele, na ntalu ya makumi zole ya bikunku ya palata. Ba-Isemayele nataka Yosefi na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ntangu Lubene vutukaka na dibulu yango, Yosefi vwandaka dyaka ve na kati ya yawu. Lubene pasulaka binkuti ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Yandi vutukaka na sika ya bampangi ya yandi, mpe tubaka: «Mwana kele ve kuna! Munu, wapi sika mu ke kwenda?» ");
INSERT INTO mkw_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Bawu bakaka kinkuti ya Yosefi. Na manima ya kufwa nkombo mosi ya mbakala, bawu bolisaka kinkuti yango na menga ya nkombo yina. ");
INSERT INTO mkw_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bawu fidisaka na tata ya bawu kinkuti ya Yosefi, mpe bawu tubaka: «Beto me kuzwa yayi. Tala ntete kana yawu kele ve kinkuti ya mwana ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yandi talaka mbote kinkuti yango mpe yandi tubaka ti: «Yawu kele kinkuti ya mwana ya munu. Kibulu mosi ya nsisi me kudya yandi. Ba me pasula Yosefi na bitini.» ");
INSERT INTO mkw_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakobi pasulaka binkuti ya yandi, mpe yandi vwataka saki na luketo. Yandi kotaka na bufwidi ya mwana ya yandi na bilumbu mingi. ");
INSERT INTO mkw_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bana ya yandi nyonso ya babakala na ya bakento vukanaka na kubomba yandi, kasi yandi mangaka ba bomba yandi. Yandi tubaka: «Ni na kati ya kifwidi mu ke kulumuka na sika ya mwana ya munu, kuna na yinsi ya bantu ya kufwa.» Mpe yandi tatamanaka kudila mwana ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ba-Midyane tekisaka Yosefi na yinsi ya Ngipiti na Potifale, yina vwandaka muntu ya mfunu na kimfumu ya Falawo, mpe mfumu ya bankebi. ");
INSERT INTO mkw_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Na ntangu yina, Yuda bikaka bampangi ya yandi, yandi kwendaka zinga na sika ya muntu mosi ya bwala Adulame, nkumbu ya yandi Ila. ");
INSERT INTO mkw_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kuna, Yuda talaka mwana mosi ya kento, ya mu-Kaanani, nkumbu ya yandi Suwa. Yandi bakaka yandi na makwela. Mpe yandi vukisaka mfulu na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Na yina, Suwa kuzwaka kivumu mpe yandi butaka mwana ya bakala. Yandi pesaka mwana yina nkumbu Ele. ");
INSERT INTO mkw_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Yandi kuzwaka dyaka kivumu mpe yandi butaka mwana ya bakala. Yandi pesaka mwana yina nkumbu Onane. ");
INSERT INTO mkw_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Yandi butaka dyaka mwana ya bakala. Yandi pesaka mwana yina nkumbu Sela. Ntangu Suwa butaka Sela, Yuda vwandaka na bwala Kezibe. ");
INSERT INTO mkw_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda kwedilaka mwana ya yandi ya ntete Ele kento. Nkumbu ya kento yina vwandaka Tamale. ");
INSERT INTO mkw_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ele, mwana ya ntete ya Yuda, salaka yimbi na meso ya Yave. Ni yawu yina, Yave salaka ti yandi kufwa. ");
INSERT INTO mkw_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Na yina, Yuda tubaka na Onane: «Vukisa mfulu na kento yina mpangi ya nge me bika. Sala mutindu kinkulu ke na kulomba na munzadi, samu ti, nge butila mpangi ya nge bana.» ");
INSERT INTO mkw_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kasi, Onane zabaka ti bana yina ke vwanda ve bana ya yandi. Na yina, ntangu yina yandi vwandaka vukisa mfulu na kento yina bikaka mpangi ya yandi, yandi vwandaka losa maluma ya yandi na ntoto, samu ti yandi butila ve mpangi ya yandi bana. ");
INSERT INTO mkw_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Mambu yina yandi vwandaka sala vwandaka yimbi na meso ya Yave. Ni yawu yina, Yave salaka ti yandi mpe kufwa. ");
INSERT INTO mkw_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Na yina, Yuda tubaka na bokilo ya yandi Tamale: «Mutindu nge me kuma mufwidi, kwenda zinga na sika ya tata ya nge tii ntangu yina mwana ya munu, Sela, ke kula.» Yuda vwandaka tuba na yisi ya ntima: «Ya kele mbote ve ti Sela mpe kufwa mutindu bampangi ya yandi.» Tamale kwendaka zinga na sika ya tata ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bilumbu mingi lutaka mpe mwana ya Suwa, yina vwandaka kento ya Yuda, kufwaka. Ntangu bufwidi manisaka, Yuda kwendaka kuna na Timena, na sika ya bantu yina vwandaka zenga miika ya mameme ya yandi. Yandi kwendaka kintwadi na nkundi ya yandi Ila, mu-Adulame. ");
INSERT INTO mkw_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ba zabisaka Tamale mutindu yayi: «Bokilo ya nge ke na kukwenda kuna na Timena samu na kuzenga miika ya mameme ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamale katulaka binkuti ya yandi ya bufwidi. Yandi fukilaka kitambala tii na nzutu mpe yandi kwendaka vwanda na mwelo ya Enayime, na nzila ya Timena. Tamale salaka mutindu yina samu ti, yandi talaka ti, Sela vwandaka me kula, mpe ba kwelisaka ve yandi na Sela. ");
INSERT INTO mkw_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ntangu Yuda talaka Tamale, yandi banzaka ti, ya ke kento ya ndumba, samu ti, Tamale fukaka kizizi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yuda kwendaka solola yandi ata kuzaba ti ya vwandaka ni bokilo ya yandi. Yuda tubaka: «Mu kele na nsatu ya nge.» Tamale vutulaka: «Kana mu basika na nge, yinki nge ke pesa munu?» ");
INSERT INTO mkw_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda vutulaka: «Mu ke fidisa nge mwana ya nkombo». Tamale tubaka: «Simbisa munu kima yina mu ke simba tii ntangu nge ke fidisa munu mwana yango ya nkombo.» ");
INSERT INTO mkw_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda yufulaka: «Yinki mu ke simbisa nge?» Tamale tubaka: «Pesa munu kinyemo ya nge na singa ya yawu mpe yinti yina ke na nge na diboko.» Yuda pesaka yandi yawu, mpe yandi kwendaka vukisa mfulu na Tamale. Tamale kuzwaka kivumu. ");
INSERT INTO mkw_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamale telamaka mpe kwendaka ya yandi. Yandi katulaka kitambala yina vwandaka na yandi, mpe yandi lwataka dyaka binkuti ya yandi ya bufwidi. ");
INSERT INTO mkw_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda tumisaka nkundi ya yandi, yina kele mu-Adulame, samu na kunatina kento yina mwana ya nkombo mpe ti yandi baka bima yina yandi simbisaka Tamale. Kasi muntu yina talaka yandi ve. ");
INSERT INTO mkw_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Muntu yina yufulaka bantu ya kisika yina: «Wapi kento ya kindumba yina vwandaka na nzila ya Enayime?» Bawu vutulaka: «Awa beto kele ve na kento ya kindumba.» ");
INSERT INTO mkw_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Yandi vutukaka mpe tubaka na Yuda: «Mu me tala yandi ve mpe bantu ya kisika yina me zabisa munu ti kuna, bawu kele ve na kento ya kindumba.» ");
INSERT INTO mkw_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda tubaka: «Yandi bumba ya yandi bima yina, mu zola ve ti bantu safula beto, mu me fidisa yandi mwana ya nkombo, kasi nge me tala yandi ve.» ");
INSERT INTO mkw_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Na manima ya bangonda tatu, bantu kwizaka zabisa Yuda: «Bokilo ya nge, Tamale, me sala kindumba mpe yandi me kuzwa kivumu.» Yuda tubaka: «Beno basisa yandi mpe beno yoka yandi!» ");
INSERT INTO mkw_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kaka na ntangu yina bantu vwandaka nata yandi, yandi tumisaka bantu yina na kutuba na bokilo ya yandi mutindu yayi: «Muntu ya kuzwa bima yayi, ni yandi me pesa munu kivumu. Mulemvo ya beno, beno sosa kuzaba kinyemo na singa ya yawu mpe yinti yayi kele ya nani?» ");
INSERT INTO mkw_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda me tala mbote bima mpe yandi tubaka: «Yandi kele ya kusungama kulutila munu, samu ti, mu kwelisaka yandi ve na mwana ya munu Sela.» Na manima, Yuda basikaka dyaka ve na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Na ntangu ya kubuta, ba talaka ti yandi vwandaka na mapasa na kivumu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Mwana mosi basisaka ntete diboko ya yandi. Kibutisi simbaka diboko ya mwana mpe yandi kangaka yandi singa ya mbwaki na diboko yango mpe yandi tubaka: «Ni yandi yayi kele mwana ya ntete.» ");
INSERT INTO mkw_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kasi mwana vutulaka diboko na kati mpe mpangi ya yandi basikaka ntete. Na yina, kibutisi tubaka: «Wapi mutindu nge me kuzwa nzila!» Mpe ba pesaka yandi nkumbu Pelese. ");
INSERT INTO mkw_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Na manima, mpangi ya yandi yina vwandaka na singa ya mbwaki na diboko basikaka mpe ba pesaka yandi nkumbu Zela. ");
INSERT INTO mkw_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ba-Isemayele yina nataka Yosefi na yinsi ya Ngipiti, tekisaka yandi na Potifale, mosi na bantu ya Ngipiti. Potifale vwandaka muntu yina Falawo vwandaka sadila kivuvu, mpe mfumu ya bankebi ya ntinu. ");
INSERT INTO mkw_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yave vwandaka na Yosefi, ni yawu yina mambu ya yandi nyonso vwandaka simba. Yosefi vwandaka vwanda na yinzo ya mfumu ya yandi Potifale, mu-Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifale bakulaka ti Yave vwandaka na Yosefi, mpe Yave vwandaka sala ti mambu nyonso yina Yosefi vwandaka sala kusimba. ");
INSERT INTO mkw_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yosefi kuzwaka lemvo na Potifale yina tulaka yandi ntwadisi ya yinzo ya yandi, mpe na bimvwama nyonso ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ntangu Yosefi bandaka kukengidila yinzo ya Potifale mpe bima ya yandi nyonso, Yave sakumunaka yinzo ya Potifale, mu-Ngipiti samu na Yosefi. Yave sakumunaka bima nyonso ya Potifale: Na yina vwandaka na yinzo, na yina vwandaka na bilanga ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ni yawu yina, Potifale bikaka bima nyonso ya yandi na maboko ya Yosefi, mpe yandi vwandaka sala dyaka kima mosi ve, kaka madya yina yandi vwandaka kudya. Yosefi vwandaka na nzutu ya kitoko, na kizizi ya kitoko na kutala. ");
INSERT INTO mkw_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Na manima ya mwa bilumbu, kento ya mfumu ya Yosefi, bandaka kuzola yandi. Mpe yandi zonzaka na Yosefi: «Kwiza vukisa mfulu na munu.» ");
INSERT INTO mkw_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yosefi mangaka, mpe zonzaka na kento ya mfumu ya yandi: «Mfumu ya munu tulaka munu ntwadisi ya bima ya yandi nyonso. Yandi ke salaka dyaka ata kima mosi ve na yinzo. ");
INSERT INTO mkw_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Na yinzo yayi, ya kele ve na muntu yina me lutila munu bumfumu, mpe yandi me yimina munu kima mosi ve, kaka nge kento ya yandi. Wapi mutindu mu lenda sala dyambu ya yimbi ya mutindu yayi, mpe kusala disumu na meso ya Nzambi?» ");
INSERT INTO mkw_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Konso kilumbu, Kento yango vwandaka zonza na Yosefi na kulala na yandi, mpe na kuvukisa mfulu na yandi. Kasi Yosefi vwandaka manga. ");
INSERT INTO mkw_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kilumbu mosi, Yosefi kotaka na yinzo samu na kusala kisalu ya yandi. Bisadi ya yinzo vwandaka ve. ");
INSERT INTO mkw_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kento ya Potifale simbaka yandi na kinkuti mpe zonzaka na yandi: «Kwiza vukisa mfulu na munu.» Kasi Yosefi bikilaka yandi kinkuti na maboko mpe kimaka na ngaanda ya yinzo. ");
INSERT INTO mkw_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ntangu kento talaka ti Yosefi kimaka na ngaanda mpe bikilaka yandi kinkuti na maboko, ");
INSERT INTO mkw_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","yandi lookaka mpe bokilaka bisadi ya yinzo na kuzonza na bawu: «Oo! Beno kwiza, beno tala: mu-Ebeleyo yayi yina bakala ya munu natinaka beto ke na zola kusakinina beto. Yandi me kwiza sosa kuvukisa mfulu na munu, kasi mu me looka na ngolo. ");
INSERT INTO mkw_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ntangu yandi me kuwa kulooka ya munu na kubokila, yandi me bika kinkuti ya yandi na lweka ya munu, mpe yandi me kima na ngaanda ya yinzo.» ");
INSERT INTO mkw_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kento yango bumbaka kinkuti ya Yosefi pene-pene ya yandi tii ntangu yina bakala ya yandi vutukaka na yinzo. ");
INSERT INTO mkw_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Yandi zabisaka yandi mambu kaka yina na kuzonza: «Mundongo ya mu-Ebeleyo, yina nge natinaka beto, me kwiza pene-pene ya munu, samu na kusakinina munu. ");
INSERT INTO mkw_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kasi ntangu mu lookaka mpe bokilaka, yandi bikaka kinkuti ya yandi na lweka ya munu, mpe yandi kimaka na ngaanda ya yinzo.» ");
INSERT INTO mkw_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mfumu ya Yosefi kuwaka mambu yina kento ya yandi zabisaka yandi, dyambu yina Yosefi zolaka sala yandi. Mpe yandi kuzwaka nkele ya kulutila. ");
INSERT INTO mkw_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Mfumu yina kangisaka Yosefi mpe tulaka yandi na kati ya boloko yina ba kangaka mpe bankole ya ntinu. Yosefi vwandaka kuna na boloko, ");
INSERT INTO mkw_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","kasi Yave vwandaka na yandi. Yave lakisaka bumbote ya yandi na kusala ti Yosefi kuzwa lemvo na meso ya mfumu ya boloko. ");
INSERT INTO mkw_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Mfumu yango pesaka kimfumu ya bankole nyonso ya boloko na maboko ya Yosefi. Ni yandi vwandaka twadisa bisalu nyonso yina bankole vwandaka sala. ");
INSERT INTO mkw_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mfumu ya boloko vwandaka tala dyaka ve bisalu yina yandi pesaka na Yosefi, samu ti Yave vwandaka na Yosefi mpe yandi vwandaka sala ti mambu ya yandi nyonso kusimba. ");
INSERT INTO mkw_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Na manima ya mambu yina, mfumu yina vwandaka na kisalu ya kutudilaka ntinu malafu, na mfumu yina vwandaka na kisalu ya kuyokilaka ntinu mampa, bawu salaka disumu na mantwala ya Mfumu ya bawu, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Falawo, ntinu ya Ngipiti, dasukilaka bawu zole. ");
INSERT INTO mkw_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Yandi kangisaka bawu mpe yandi tulaka bawu na boloko yina vwandaka twadisa kuluntu ya boloko. Ni na kati ya boloko yina vwandaka mpe Yosefi. ");
INSERT INTO mkw_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mfumu ya boloko pesaka bawu Yosefi mutindu kisadi, samu na kusadilaka bawu. Bawu zingilaka mwa mingi na boloko. ");
INSERT INTO mkw_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kilumbu mosi na mpimpa, kuna na boloko, kuluntu yina ke tadilaka malafu ya ntinu mpe kuluntu ya bantu yina ke yokaka mampa ya ntinu ya Ngipiti, bawu zole lotaka bandosi. Ndosi na ndosi vwandaka na mbangululu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Na suka, Yosefi kwizaka tala bawu, mpe yandi kutaka bawu na kati ya manyongo. ");
INSERT INTO mkw_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yandi yufulaka bawu: «Samu na yinki beno kele ve ya kuyangalala bubu yayi?» ");
INSERT INTO mkw_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Bawu vutulaka: «Mosi na mosi na beto me kuzwa ndosi, kasi muntu kele ve, yina ke bangudila beto yawu.» Yosefi vutulaka na bawu: «Kaka ni Nzambi lenda kubangula bandosi. Mu me lomba na beno na kuzonzila munu bandosi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kuluntu yina ke tadilaka mambu ya malafu zabisaka ndosi ya yandi na Yosefi. Yandi tubaka mutindu yayi: «Na ndosi ya munu, mu talaka yinti ya vinu vwandaka na mantwala ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Yinti yina vwandaka na bintala tatu. Yina basisaka makasa ya malu-malu, bifulu ya yawu basikaka, mpe yawu butaka bambuma ya vinu ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mu vwandaka na mbungu ya Falawo na diboko. Mu bukaka bambuma ya vinu, mu kamunaka yawu na kati ya mbungu, mpe mu pesaka yawu na Falawo.» ");
INSERT INTO mkw_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosefi vutulaka na yandi: «Bangululu ya ndosi ya nge yawu yayi: Bintala tatu ke na kulakisa bilumbu tatu. ");
INSERT INTO mkw_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Na manima ya bilumbu tatu, Falawo ke vumbula yintu ya nge. Yandi ke vutula nge na kisalu ya nge, mpe nge ke banda na kupesaka dyaka yandi mbungu na diboko, mutindu nge vwandaka sala yawu. ");
INSERT INTO mkw_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ntangu mambu nyonso ke vwanda mbote samu na nge, bambuka moyo ti mu vwandaka na nge. Sadisa munu na kuzonzila munu na Falawo, samu ti yandi basisa munu na boloko yayi. ");
INSERT INTO mkw_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ba katulaka munu na ngolo na yinsi ya ba-Ebeleyo, mpe awa mu me sala dyambu ya yimbi ve samu ti ba tula munu na boloko.» ");
INSERT INTO mkw_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ntangu mfumu ya bantu yina ke yokaka mampa kuwaka ti mbangululu ya ndosi yina Yosefi pesaka, vwandaka ya mbote samu na mpangi ya yandi, yandi tubaka na Yosefi: «Munu mpe mu lotaka mutindu yayi: mu vwandaka nata bitunga tatu ya mampa na zulu ya yintu. ");
INSERT INTO mkw_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kitunga ya zulu vwandaka na mampa ya mutindu na mutindu yina Falawo ke zolaka, kasi bandeke vwandaka kwiza kudya yawu na kati ya kitunga, na zulu ya yintu ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosefi vutulaka na yandi: «Bangululu ya ndosi ya nge yawu yayi: bitunga tatu ke na kulakisa bilumbu tatu. ");
INSERT INTO mkw_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Na manima ya bilumbu tatu, Falawo ke katula yintu ya nge na nzutu. Ba ke ledika nzutu ya nge na yinti, mpe bandeke ke kwiza doda yawu.» ");
INSERT INTO mkw_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Bilumbu tatu lutaka, Falawo sadisaka mukembo ya mbutukulu ya yandi. Yandi salaka mukembo ya nene, yandi bokilaka bantu nyonso yina ke salaka na yandi. Na mantwala ya bawu, yandi basisaka mfumu yina ke tadilaka mambu ya malafu na mfumu yina ke tadilaka mambu ya kulamba mampa. ");
INSERT INTO mkw_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Yandi vutulaka mfumu ya malafu na kisalu ya yandi, samu na kupesaka dyaka Falawo mbungu na maboko. ");
INSERT INTO mkw_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kasi yandi ledikaka mfumu ya bantu yina ke yokaka mampa. Yawu salamaka mutindu Yosefi bangulaka. ");
INSERT INTO mkw_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kasi, mfumu ya malafu bambukilaka Yosefi moyo ve, mpe zimbanaka yandi. ");
INSERT INTO mkw_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Na manima ya bamvula zole, Falawo lotaka ndosi. Yandi vwandaka ya kutelama na lweka ya nzadi ya Nile. ");
INSERT INTO mkw_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Yandi talaka bangombe nsambwadi ya nkento ya kitoko mpe ya mafuta, vwandaka basika na kati ya nzadi, mpe bandaka kudya matiti yina vwandaka pene-pene ya nzadi ya Nile. ");
INSERT INTO mkw_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Na manima, bangombe nsambwadi ya nkento ya nkaka ya yimbi mpe ya kukonda vwandaka basika na kati ya nzadi, mpe yawu kwizaka vwanda pene-pene ya bangombe yina ya ntete, na lweka ya nzadi ya Nile. ");
INSERT INTO mkw_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bangombe yina ya yimbi mpe ya kukonda kudyaka bangombe nsambwadi ya mafuta. Ni na ntangu yina Falawo vumbukaka. ");
INSERT INTO mkw_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Yandi lalaka dyaka, mpe yandi lotaka ndosi ya zole. Yandi talaka bayintu nsambwadi ya bambuma ya faline, ya nene mpe ya kitoko, yina basikaka na kititi kaka mosi ya mbuma ya faline. ");
INSERT INTO mkw_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Na manima, yandi talaka mpe bayintu nsambwadi dyaka basikaka. Yawu vwandaka ya kukonda mpe ya kuyuma na mupepe yina ke katukaka na yinsi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bayintu ya bambuma ya faline ya kukonda minaka bayintu nsambwadi ya bambuma ya faline ya nene mpe ya mbote. Na yina, Falawo vumbukaka mpe bakulaka ti yandi lotaka ndosi. ");
INSERT INTO mkw_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Na suka, ntima ya Falawo vwandaka kwama. Yandi tumisaka ti ba bokila banganga na bantu nyonso ya ndwenga ya Ngipiti. Yandi zabisaka bawu bandosi ya yandi, kasi ata muntu mosi lendaka na kubangudila yandi yawu. ");
INSERT INTO mkw_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Na yina, mfumu yina vwandaka na kisalu ya kutudilaka ntinu malafu, zabisaka na Falawo: «Mfumu, mu zola kufungula masumu ya munu bubu yayi. ");
INSERT INTO mkw_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kilumbu mosi, nge dasukilaka munu na mfumu ya bantu yina ke yokaka mampa, mpe nge tulaka beto na boloko na yisi ya lutumu ya kuluntu ya binwani. ");
INSERT INTO mkw_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Beto lotaka bandosi na mpimpa kaka mosi. Ndosi na ndosi na mbangululu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Na kati ya boloko, ya vwandaka na ntwenya mosi ya mundongo ya mu-Ebeleyo, yandi vwandaka sadila kuluntu ya boloko. Beto zonzilaka yandi bandosi ya beto, mpe yandi pesaka na konso ndosi mbangululu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Mambu nyonso salamaka kaka mutindu yandi zonzaka. Ba vutulaka munu na kisalu ya munu, mpe ba ledikaka mfumu ya bantu yina ke yokaka mampa.» ");
INSERT INTO mkw_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Falawo, ntinu ya Ngipiti, tumisaka ba bokila Yosefi. Na nswalu ba kwendaka basisa yandi na boloko. Ba katulaka yandi mandefo, mpe ba vwatisaka yandi kinkuti ya nkaka. Mpe yandi kwendaka na mantwala ya Falawo. ");
INSERT INTO mkw_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falawo tubaka na Yosefi: «Mu me lota ndosi, kasi ya kele ve na muntu yina lenda bangudila munu yawu. Ba me zabisa munu ti nge, nge lenda bangula bandosi yina ba ke zonzilaka nge.» ");
INSERT INTO mkw_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosefi vutulaka na Falawo mutindu yayi: «Ni munu ve. Ni Nzambi lenda pesa nge mvutu ya mbote.» ");
INSERT INTO mkw_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Falawo, ntinu ya Ngipiti, tubaka na Yosefi: «Mu lotaka ndosi. Ya vwandaka mutindu yayi: “Mu telamaka na lweka ya nzadi ya Nile. ");
INSERT INTO mkw_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Mu talaka bangombe nsambwadi ya nkento ya kitoko mpe ya mafuta, yina vwandaka basika na kati ya nzadi, mpe bandaka kudya matiti yina vwandaka pene-pene ya nzadi ya Nile. ");
INSERT INTO mkw_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mpe bangombe nsambwadi ya nkaka ya nzutu fyoti, ya kukonda, mpe ya yimbi, vwandaka basika na kati ya nzadi, mpe yawu kwizaka vwanda pene-pene ya bangombe yina ya ntete. Mu me talaka ntete ve bangombe ya mutindu yayi na yinsi nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bangombe nsambwadi ya yimbi mpe ya kukonda kudyaka bangombe ya mafuta. ");
INSERT INTO mkw_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kasi na manima ya kudya yawu, ata kima mosi lakisaka ti ba me kudya yawu. Bangombe ya nzutu fyoti vwandaka kaka ya yimbi mutindu yawu vwandaka ntete. Ni na ntangu yina mu vumbukaka. ");
INSERT INTO mkw_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Mu talaka dyaka na ndosi, bayintu nsambwadi ya bambuma ya faline, ya nene mpe ya kitoko, yina basikaka na kititi kaka mosi. ");
INSERT INTO mkw_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mpe mu talaka dyaka bayintu nsambwadi ya nkaka basikaka. Yawu vwandaka ya kukonda mpe ya kuyuma na mupepe yina ke katukaka na yinsi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Bayintu nsambwadi ya bambuma ya faline yina ya kukonda minaka bayintu ya mbote. Mu zabisaka bandosi yango na banganga, kasi ata muntu mosi lendaka ve na kubangudila munu yawu.» ");
INSERT INTO mkw_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosefi tubaka na Falawo, ntinu ya Ngipiti mutindu yayi: «Bandosi nyonso zole kele na mbangululu kaka mosi. Nzambi ke na kulakisa na Falawo mambu yandi ke salama. ");
INSERT INTO mkw_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bangombe nsambwadi ya mbote mpe bayintu nsambwadi ya bambuma ya faline ya mbote, ke na kulakisa bamvula nsambwadi. Yawu kele kwandi ndosi mosi. ");
INSERT INTO mkw_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bangombe nsambwadi ya kukonda na ya yimbi mpe bayintu nsambwadi ya kukonda na mupepe yina ke katukaka na yinsi ya kuyuma, ke na kulakisa bamvula nsambwadi ya nsatu ya nene. ");
INSERT INTO mkw_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Yawu kele mutindu mu me zonza na nge: Nzambi me zabisa nge mambu yina yandi ke sala. ");
INSERT INTO mkw_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Na bamvula nsambwadi yina ke kwiza, madya ke vwanda mingi na yinsi nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Na manima, ke kwiza bamvula nsambwadi ya nsatu ya nene, mpe kwaku na Ngipiti, bantu ke zimbana bamvula nsambwadi yina ya madya ya mingi. Nsatu ya nene ke bebisa yinsi. ");
INSERT INTO mkw_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bantu ke zimbana bamvula nsambwadi ya madya ya mingi, samu ti nsatu ke vwanda ya kulutila. ");
INSERT INTO mkw_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kana ndosi yango kwizaka bambala zole na Falawo, ntinu ya Ngipiti, ya kele ti ni Nzambi bakaka nzengolo, mpe yandi ke lungisa yawu na nswalu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ntangu yayi, bika ti Falawo kusoola muntu mosi ya mayela mpe ya ndwenga, mpe yandi kupesa muntu yango luyalu ya yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Bika ti Falawo kutula bamfumu ya fyoti na yinsi. Bawu banda na kukatulaka kikunku mosi na kati ya bikunku tanu, ya bima nyonso yina ntoto ya Ngipiti ke pesa mutindu madya na bamvula nsambwadi ya madya ya mingi. ");
INSERT INTO mkw_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Bika ti bawu kuyonzika madya nyonso ya bamvula ya mbote ke kwiza. Bawu kubumba bambuma ya faline, mpe bima ya kudya na bambanza yina kele na yisi ya lutumu ya Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ya ke vwanda madya ke bumbama samu na yinsi, samu na bamvula nsambwadi ya nsatu ya nene yina ke na kukwiza na yinsi ya Ngipiti. Na yina, nsatu ke bebisa ve yinsi.» ");
INSERT INTO mkw_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Malongi ya Yosefi talanaka ya mbote na Falawo, mpe na bisadi nyonso ya Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Falawo zabisaka bawu mutindu yayi: «Muntu yayi kele ya kufuluka na mpeve ya Nzambi. Wapi kisika beto lenda kuzwa muntu ya nkaka mutindu yandi?» ");
INSERT INTO mkw_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Falawo tubaka na Yosefi: «Samu ti, ni Nzambi me lakisa nge mambu nyonso yina, ya kele ve na muntu ya nkaka yina ke na mayela mpe na ndwenga mutindu nge! ");
INSERT INTO mkw_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ni nge ke vwanda mfumu ya yinzo ya munu, mpe bantu ya munu nyonso ke zitisa nge. Mu ke lutila nge kaka na buntinu ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ntangu yayi, mu me pesa nge luyalu ya Ngipiti nyonso.» ");
INSERT INTO mkw_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Falawo katulaka nela ya kinyemo ya kintinu na musapi ya yandi, mpe yandi tulaka yawu na musapi ya Yosefi. Yandi vwatisaka Yosefi balele ya lino ya mbote, mpe yandi tulaka Yosefi musanga ya wolo na laka. ");
INSERT INTO mkw_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Yandi yulukisaka Yosefi na kipusu-pusu ya kilandi ya yandi, mpe yandi lookaka na mantwala ya Yosefi mutindu yayi: «Beno lutisa!» Ni mutindu yayi Falawo, ntinu ya Ngipiti pesaka Yosefi luyalu ya yinsi nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Falawo tubaka dyaka na Yosefi mutindu yayi: «Mu kele Falawo, ntinu ya Ngipiti, kasi na yinsi nyonso ya Ngipiti, ya kele ve na muntu yina lenda nanguna diboko ya yandi to dikulu ya yandi kondwa muswa ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Falawo, ntinu ya Ngipiti, pesaka na Yosefi nkumbu ya Safanate-Paneya, mpe pesaka yandi kento, Asenate, mwana ya Poti-Fela, nganga-Nzambi ya mbanza One. Yosefi salaka nzyetolo ya luyalu na yinsi nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosefi vwandaka na bamvula makumi tatu ntangu ba nataka yandi na sika ya Falawo, ntinu ya Ngipiti. Yosefi bikaka Falawo, mpe kwendaka tambula bwala nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Na ntangu ya bamvula nsambwadi ya madya mingi, ntoto pesaka madya mingi. ");
INSERT INTO mkw_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yosefi yonzikaka madya nyonso na bamvula nsambwadi yina landilaka na yinsi ya Ngipiti. Yandi bumbaka madya yango na kati ya bambanza. Na konso mbanza, yandi bumbaka madya yina katukaka na bilanga ya pene-pene. ");
INSERT INTO mkw_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yosefi bumbaka bambuma ya faline mingi. Yawu vwandaka mingi mutindu munyenge ya mubu, mpe ba bikaka kwandi na kutanga dyaka yawu. Samu ti ba lendaka ve na kutanga yawu. ");
INSERT INTO mkw_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tekila mvula yina nsatu bandaka, Asenate, kento ya Yosefi, butaka bana zole. Asenate vwandaka mwana ya Poti-Fela, nganga-nzambi ya mbanza One. ");
INSERT INTO mkw_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosefi pesaka nkumbu na mwana ya ntete Manase, mpe yandi tubaka: «Nzambi me sala ti mu zimbana bampasi ya munu nyonso na dikanda nyonso ya tata ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Yandi pesaka na mwana ya zole nkumbu Efalayime, mpe yandi tubaka: «Nzambi me pesa munu bana na yinsi yina mu vwandaka tala mpasi mingi.» ");
INSERT INTO mkw_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Bamvula nsambwadi ya madya ya mingi kwizaka manisa na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Mpe bamvula nsambwadi ya nsatu ya nene kwizaka banda, mutindu Yosefi zonzaka. Nsatu ya nene vwandaka na bayinsi nyonso, kasi na Ngipiti nyonso madya vwandaka. ");
INSERT INTO mkw_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ntangu bantu nyonso ya Ngipiti bandaka kutala nsatu, bawu lookaka na sika ya Falawo yandi pesa bawu madya. Falawo vutulaka na bantu nyonso ya Ngipiti: «Beno kwenda tala Yosefi. Beno sala mutindu yandi ke zabisa beno.» ");
INSERT INTO mkw_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ntangu nsatu ya nene yalaka yinsi nyonso, Yosefi zibulaka bayinzo yina ba bumbaka madya, samu na kutekisa mbuma ya faline na bantu ya Ngipiti. Nsatu kumaka mingi na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bantu ya bayinsi nyonso vwandaka kwiza na Ngipiti na kusumba madya na Yosefi, samu ti nsatu vwandaka na yinza ya muvimba. ");
INSERT INTO mkw_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobi kuwaka ti bambuma ya faline kele na yinsi ya Ngipiti, yandi tubaka na bana ya yandi: «Samu na yinki beno me vwandaka ya beno awa kaka na kutalasanaka? ");
INSERT INTO mkw_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mu me kuwa ti bambuma ya faline kele na Ngipiti. Beno kwenda kuna, mpe beno sumbila beto yawu, samu ti beto zinga, beto kufwa ve na nsatu.» ");
INSERT INTO mkw_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Na yina, kumi ya bampangi ya Yosefi kwendaka sumba bambuma ya faline na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kasi Yakobi fidisaka ve Bezame, leki ya Yosefi samu ti yandi kwenda na bayaya ya yandi. Samu ti yandi tubaka: «Mu kele na boma ti dyambu ya yimbi kukumina yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Bana ya Isayeli kwizaka sumba bambuma ya faline na Ngipiti, nzila mosi na bisumbi ya nkaka yina vwandaka kwenda kuna. Samu ti nsatu ya nene vwandaka na yinsi ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosefi vwandaka mfumu ya nene na yinsi ya Ngipiti. Ni yandi vwandaka twadisa kisalu ya kutekisaka bambuma ya faline na bantu nyonso ya yinsi. Bampangi ya Yosefi kwizaka fukama kizizi na ntoto na mantwala ya Yosefi. ");
INSERT INTO mkw_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosefi talaka bampangi ya yandi, mpe zabaka bawu. Yandi salaka ti bampangi ya yandi kuzaba yandi ve. Yandi zonzila bawu na ngolo nyonso: «Wapi sika beno me katuka?» Bawu vutulaka: «Beto me katuka na yinsi ya Kaana, mpe beto me kwiza sumba bima ya kudya.» ");
INSERT INTO mkw_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosefi zabaka bawu, kasi bawu vwandaka zaba dyaka yandi ve. ");
INSERT INTO mkw_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yosefi bambukaka moyo na bandosi yina yandi lotaka samu na bawu. Mpe yandi tubaka na bawu: «Beno kele bambeni yina me kwiza samu na kuzaba lebakana ya yinsi ya beto.» ");
INSERT INTO mkw_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bawu vutulaka: «Ve mfumu ya munu! Bisadi ya nge me kwiza kaka samu na kusumba bima ya kudya. ");
INSERT INTO mkw_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Beto nyonso kele bana ya tata mosi, mpe beto kele ya kudedama. Beto bisadi ya nge, beto kele ve bambeni yina me kwiza samu na kuzaba wapi mutindu beto lenda dyata kimfumu ya yinsi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosefi vutulaka: «Ve! Luvunu! Beno me kwiza samu na kusosa kuzaba lembakani ya yinsi ya beto.» ");
INSERT INTO mkw_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Bawu tubaka dyaka: «Beto bisadi ya nge, beto kele kumi na zole, bana ya tata mosi na yinsi ya Kaana. Bubu yayi, leki ya beto kele na tata ya beto, mpangi ya beto mosi kufwaka.» ");
INSERT INTO mkw_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosefi vutulaka: «Ni yina mu zabisaka beno, ti beno kele bambeni. ");
INSERT INTO mkw_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Tala mutindu ke vwandila ntontolo ya beno: Ya tsyelika, na nkumbu ya Falawo, ntinu ya Ngipiti, beno ke basika ve na yinsi yayi tekila ti leki ya beno kwiza kwaku. ");
INSERT INTO mkw_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Beno fidisa mosi na kati ya beno na kwenda baka yandi mpe, ba ya nkaka, ke bikana na boloko. Ni kuna mu ke zaba kana mambu yina beno me zabisa munu kele ya tsyelika. Kana ya kele mutindu yina ve, na nkumbu ya Falawo, ntinu ya Ngipiti, beno kele ya tsyelika bambeni.» ");
INSERT INTO mkw_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yosefi tulaka bawu nyonso na boloko bilumbu tatu. ");
INSERT INTO mkw_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Na kilumbu ya tatu, Yosefi tubaka na bawu: «Tala mutindu beno ke sala, samu na kuvwanda moyo. Mu ke zitisaka Nzambi. ");
INSERT INTO mkw_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kana beno kele bantu ya kudedama, beno ndima ti mosi na beno kubikana na boloko yayi beno kele. Ba ya nkaka kunata bambuma ya faline na makanda ya beno, yina kele na kufwa nsatu. ");
INSERT INTO mkw_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mpe beno natina munu leki ya beno. Ni kuna mu ke zaba ti yina beno me tuba kele ya tsyelika, mpe beno ke kufwa ve.» Ni mutindu yina bawu salaka. ");
INSERT INTO mkw_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Bawu tubaka bawu na bawu mutindu yayi: «Ya tsyelika! Beto me kuzwa masembo samu na mpangi ya beto. Beto talaka mpasi ya yandi ntangu yandi vwandaka lomba beto mulemvo, kasi beto wilaka yandi ve. Ni yawu yina, mpasi yayi kele na kukuminaka beto.» ");
INSERT INTO mkw_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Mpe Lubene vutulaka na bawu: «Mu zabisaka beno ti: “Beno sala ve yimbi na mwana yayi”, kasi beno wilaka munu ve. Awa beto ke na kufuta masumu ya lufwa ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Bawu zabaka ve ti Yosefi vwandaka kuwa mambu yina bawu vwandaka zonza. Samu ti, ya vwandaka na mubangudi yina vwandaka sadisa bawu na kuzonzaka na Yosefi. ");
INSERT INTO mkw_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yosefi bikaka bawu mpe kwendaka dila na mansweki. Ntangu Yosefi vutukilaka bawu, yandi zonzaka na bawu ti, yandi ke kanga Simewone, mpe yandi kangaka yandi na meso ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Na manima, Yosefi pesaka ntumunu na bisadi ya yandi na kufulusa basaki ya bawu na bambuma ya faline, mpe na kuvutula mbongo ya mosi-mosi na saki ya yandi. Yandi pesa mpe bawu madya ya kudya na nzila. Ni mutindu yina ba salaka samu na bawu. ");
INSERT INTO mkw_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Bawu tulaka basaki ya madya ya bawu na zulu ya bambuluku ya bawu, mpe bawu kwendaka. ");
INSERT INTO mkw_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ntangu bawu kumaka na kisika ya kulutisila mpimpa, mosi na bawu zibulaka saki ya yandi samu na kupesa madya na mbuluku ya yandi, mpe yandi talaka mbongo ya yandi na kati ya saki. ");
INSERT INTO mkw_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Yandi tubaka na bampangi ya yandi: «Ba me vutula mbongo ya munu, yawu yayi na kati ya saki ya munu!» Bawu pamukaka mpe boma kuzwaka bawu. Bawu tubaka bawu na bawu mutindu yayi: «Yayi yinki Nzambi me sala beto?» ");
INSERT INTO mkw_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ntangu bawu kumaka na sika ya tata ya bawu Yakobi, na yinsi ya Kaana, bawu zabisaka yandi mambu nyonso yina kuminaka bawu. Bawu tubaka: ");
INSERT INTO mkw_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Muntu yina kele mfumu ya yinsi, me zonzila beto na ngolo nyonso. Yandi me zonza ti beto kele bambeni yina me kwiza samu na kuzaba lembakani ya yinsi ya beto. ");
INSERT INTO mkw_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Beto vutulaka na yandi: “Beto kele ve bambeni, kasi bantu ya kudedama. ");
INSERT INTO mkw_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Beto vwandaka kumi na zole, bana ya tata mosi. Mpangi ya beto mosi kufwaka, bubu yayi leki ya beto kele na tata ya beto na yinsi ya Kaana.” ");
INSERT INTO mkw_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Muntu yango, mfumu ya yinsi, tubaka na beto mutindu yayi: “Beno bikila munu mpangi ya beno mosi, ni kuna mu ke zaba kana beno kele ya kudedama. Mpe beno baka yina me fwanana, samu na kunatina makanda ya beno, yina kele na kufwa nsatu. ");
INSERT INTO mkw_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Na yina, beno natina munu leki ya beno, ni kuna mu ke zaba ti beno kele ve bambeni, kasi bantu ya kudedama. Na manima, mu ke vutula mpangi ya beno, mpe mu ke bika beno kusala mumbungu na yinsi ya munu mutindu beno zola.”» ");
INSERT INTO mkw_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bawu vwandaka basisa madya na basaki ya bawu. Mpe na saki ya konso muntu, bawu vwandaka kuta saki ya yandi ya mbongo. Ntangu bawu talaka mbongo yango, bawu kuzwaka boma na Yakobi tata ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Mpe tata ya bawu, Yakobi, tubaka na bawu mutindu yayi: «Beno me zimbisa munu bana zole: Yosefi na Simewone kele dyaka ve. Mpe beno zola baka dyaka munu Bezame! Mambu nyonso yayi ke na kubwa ni na zulu ya munu!» ");
INSERT INTO mkw_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Lubene tubaka na tata ya yandi: «Nge lenda kufwa bana ya munu zole, kana mu vutula ve Bezame. Pesa yandi na maboko ya munu, mpe mu ke vutula yandi na sika ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakobi vutulaka: «Ve! Mwana ya munu ke kwenda na beno ve. Yaya ya yandi me kufwa, kaka ni yandi me bikana na munu. Mu me kuma kiboba, kana dyambu ya yimbi kumina yandi na nzila, mu ke kufwa na manyongo, samu na beno.» ");
INSERT INTO mkw_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nsatu ya nene vwandaka tatamana na kulutila dyaka na yinsi. ");
INSERT INTO mkw_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ntangu bawu manisaka na kudya bambuma ya faline yina bawu sumbaka na Ngipiti, Yakobi tubaka na bana ya yandi mutindu yayi: «Beno vutuka kuna, beno kwenda sumbila beto mwa bima ya kudya.» ");
INSERT INTO mkw_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda vutulaka na yandi: «Muntu yina zabisaka beto ti, mu ke yamba beno ve, kana leki ya beno kele ve na beno. ");
INSERT INTO mkw_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kana nge ndima ti leki ya beto kukwenda na beto, kuna beto ke kwenda sumbila nge bima ya kudya. ");
INSERT INTO mkw_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kana nge zola ve, zaba ti beto ke kwenda ve. Samu ti muntu yango zabisaka beto: “Mu ke yamba beno ve, kana beno kwiza ve na leki ya beno.”» ");
INSERT INTO mkw_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isayeli vutulaka: «Samu na yinki beno me sala munu yimbi na kuzonza na muntu yina ti, beno kele na mpangi ya nkaka?» ");
INSERT INTO mkw_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Bawu vutulaka: «Ni yandi muntu yufulaka beto byuvu na yina me tadila beto mpe dikanda ya beto. Yandi yufulaka beto mutindu yayi: “Tata ya beno kele ntete moyo? Beno kele na mpangi ya nkaka?” Beto vutulaka bamvutu na byuvu ya yandi. Beto lendaka zaba ve ti yandi zolaka tuba ti: “Beno nata leki ya beno”.» ");
INSERT INTO mkw_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda zonzaka na tata ya yandi Isayeli: «Bika ti mwana kukwenda na munu. Beto kwenda kana beto zola vwanda moyo mpe beto kufwa ve, beto, na nge, mpe na bana ya beto. ");
INSERT INTO mkw_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mu me bula ntulu na kuvutula yandi, ni na munu nge ke yufula yandi. Kana mu vutula ve yandi na nge, mu ke talana muntu ya yimbi na mantwala ya nge luzingu ya munu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kana beto me lutisa ve ntangu mingi awa, beto zolaka kwenda mpe kuvutuka ata bambala zole.» ");
INSERT INTO mkw_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tata ya bawu Isayeli tubaka na bawu: «Kana ya kele mutindu yina, beno sala mutindu yayi: “Beno tula na basaki ya beno bima ya kitoko ya yinsi ya beto, samu na kupesa dikabu na muntu yina. Beno baka mwa ndambu ya maaka ya nsunga ya mutindu na mutindu, na ndambu ya mafuta ya nyosi, mafuta yina ba ke bokilaka ladanyome, ndambu ya bankandi, na bambuma ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Beno nata mbongo ya nkaka, mpe beno zimbana ve na kuvutula mbongo yina bawu tulaka na basaki ya beno. Yawu lenda vwanda ti ba zimbanaka. ");
INSERT INTO mkw_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Beno baka mpangi ya beno, mpe beno vutuka na sika ya muntu yina. ");
INSERT INTO mkw_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Bika ti Nzambi-Mpungu kusimba ntima ya yandi, samu ti yandi tadila beno kyadi, mpe yandi bika Bezame na mpangi ya beno ya nkaka kuvutuka na beno! Na yina me tadila munu, mu ke bikana kwandi na mwana ve mutindu ti mu butaka ve.” » ");
INSERT INTO mkw_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Bana ya Yakobi bakaka dikabu, bawu bakaka mpe mbongo ya nkaka mpe leki ya bawu Bezame. Bawu kwendaka na Ngipiti. Ntangu bawu kumaka, bawu kwendaka talana na mantwala ya Yosefi. ");
INSERT INTO mkw_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ntangu Yosefi talaka Bezame na bampangi ya yandi, yandi tubaka na ntwadisi ya yinzo ya yandi mutindu yayi: «Nata bantu yayi na yinzo ya munu, kufwa kibulu mosi mpe lamba yawu. Bawu ke kudya na munu na midi.» ");
INSERT INTO mkw_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ntwadisi yango salaka yina Yosefi tumisaka yandi, mpe yandi nataka bantu yina na yinzo ya Yosefi. ");
INSERT INTO mkw_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Bawu kuzwaka boma na kukota na yinzo ya Yosefi, mpe bawu tubaka bawu na bawu mutindu yayi: «Ni samu na mbongo yina ba tulaka na basaki ya beto, ntangu beto kwizaka na mbala ya ntete. Bawu me kotisa beto kwaku samu na kusala beto yimbi. Bawu ke baka bambuluku ya beto, mpe ke kumisa beto mindongo ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Bampangi ya Yosefi kwendaka pene-pene ya kisadi ya yandi na mwelo ya yinzo, mpe bawu zabisaka yandi mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Mulemvo ya nge mfumu, ntete-ntete beto kwizaka kwaku na kusumba bima ya kudya. ");
INSERT INTO mkw_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ntangu beto vwandaka vutuka, beto kumaka na kisika ya kulutisila mpimpa. Kuna beto fungulaka basaki ya beto. Ntangu beto fungulaka yawu, beto talaka mbongo ya mosi-mosi na beto na kati ya saki, mpe yawu vwandaka ya kulunga. Ni yawu yina, beto me kwiza na yawu. ");
INSERT INTO mkw_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Beto me nata mpe mbongo ya nkaka ya kusumbila bima ya kudya. Beto zaba ve nani tulaka yawu na basaki ya beto.» ");
INSERT INTO mkw_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ntwadisi ya yinzo ya Yosefi vutulaka: «Beno vwanda swii, mpe beno vwanda ve na boma. Ni Nzambi ya beno, mpe Nzambi ya tata ya beno, ni yandi tulaka kimvwama na basaki ya beno. Kasi mbongo yina beno nataka, mu bakaka yawu.» Na manima, yandi basisaka Simewone, mpe nataka yandi na kisika yina bampangi ya yandi vwandaka. ");
INSERT INTO mkw_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ntwadisi ya yinzo ya Yosefi kotisaka bawu na kati ya yinzo ya Yosefi. Ba natinaka bawu maza ya kusukudila makulu mpe madya ya bambuluku ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Bawu kubikaka dikabu na kuvingilaka ti Yosefi kukwiza na midi, samu ti ba zabisaka bawu ti, bawu ke kudya na Yosefi. ");
INSERT INTO mkw_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ntangu Yosefi kumaka na yinzo ya yandi, bampangi ya yandi pesaka yandi dikabu yina vwandaka na bawu, mpe na manima, bawu fukamaka na mantwala ya yandi kizizi na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosefi yufulaka bawu: «Beno kele mbote? Tata ya beno ya kiboba yina beno zonzilaka munu, yandi kele mbote? Yandi kele ntete moyo?» ");
INSERT INTO mkw_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Bawu vutulaka: «Kisadi ya nge, tata ya beto, kele mbote, yandi kele ntete moyo.» Bawu yinamaka mpe fukamaka kizizi na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yosefi talaka Bezame mpangi ya yandi ya mama mosi mpe yandi tubaka: «Ni yandi leki ya beno yina beno zonzilaka munu?» Yandi tubaka dyaka: «Mwana ya munu, bika ti Nzambi kulakisa nge bumbote ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosefi talaka kyadi na ntima ntangu yandi talaka mpangi ya yandi, mpe yandi kuzwaka nsatu ya kudila. Mbala mosi yandi telamaka mpe kwendaka dila na kivinga ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ntangu yandi manisaka na kudila, yandi sukulaka kizizi ya yandi mpe yandi basikaka na kivinga ya yandi. Yandi kangaka ntima mpe tubaka: «Beno kabula madya.» ");
INSERT INTO mkw_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ba tudilaka Yosefi madya na mesa ya yandi mosi, mpe bampangi ya yandi na mesa ya nkaka. Mutindu mosi bantu ya Ngipiti yina vwandaka na yinzo ya Yosefi, bawu mpe na mesa ya nkaka. Samu ti bantu ya Ngipiti vwandaka kudya ve madya kisika mosi na ba-Ebeleyo. Yawu kele dyambu ya nganzi samu na bantu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Bampangi ya Yosefi vwandilaka na mantwala ya yandi. Ba vwandisaka bawu na mulonga, kubanda na mwana ya ntete tii na mwana ya mansukina. Samu na yawu, bawu vwandaka talasana na kupamuka nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yosefi tumisaka ba tudila bawu madya yina vwandaka na mesa ya yandi. Kasi madya ya Bezame lutilaka ya bawu nyonso bambala tanu. Bawu kunwaka mpe bawu yangalalaka. ");
INSERT INTO mkw_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Na manima, Yosefi tumisaka ntwadisi ya yinzo ya yandi, yandi tubaka mutindu yayi: «Fulusa basaki ya bantu yayi na bima ya kudya yina bawu lenda nata, mpe vutula mbongo ya mosi-mosi na kati ya saki ya yandi, mpe tula yawu na zulu ya bima yina ya kudya. ");
INSERT INTO mkw_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tula na kati ya saki ya leki ya bawu mbungu ya munu ya palata, na mbongo ya yandi ya madya.» Ntwadisi ya yinzo ya Yosefi salaka mutindu Yosefi tubaka na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Na suka-suka ya kilumbu yina landaka, ntangu bwisi kutsyaka, ba pesaka bawu luve ya kukwenda, bawu na bambuluku ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Bawu basikaka na mbanza. Bawu kumaka ntete ntama ve, Yosefi tubaka na ntwadisi ya yinzo ya yandi: «Telama nge landa bantu yina, nge kwenda kuzwa bawu, mpe nge yufula bawu: “Samu na yinki beno me vutula yimbi na bumbote yina ba me sadila beno? ");
INSERT INTO mkw_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Samu na yinki beno me laba mbungu yina mfumu ya munu ke nwininaka mpe ke tadilaka mambu yina ke kwiza? Mambu beno me sala kele yimbi!”» ");
INSERT INTO mkw_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yandi kwendaka kuzwa bawu mpe yandi zabisaka na bawu mambu nyonso yina. ");
INSERT INTO mkw_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bawu vutulaka na yandi: «Mfumu ya beto, samu na yinki nge me tuba dyambu ya mutindu yina? Zaba ti beto bisadi ya nge, beto lenda sala dyambu ya mutindu yina ve! ");
INSERT INTO mkw_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ntangu beto kumaka na Kaana, beto talaka mbongo na kati ya basaki ya beto. Mpe ntangu beto vutukaka kwaku, beto vutulaka nge yawu. Na yina, wapi mutindu beto lenda laba dyaka palata to wolo na yinzo ya mfumu ya nge? ");
INSERT INTO mkw_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kana beno kuzwa mbungu yina na mosi na kati na beto, beno kufwa yandi! Mpe beto bayina ke bikana, beno ke kumisa beto bandongo ya nge mfumu ya beto.» ");
INSERT INTO mkw_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ntwadisi ya yinzo ya Yosefi vutulaka: «Bika ti yawu kusalama mutindu beno me zonza. Kasi beno zaba ti, na muntu yina beto ke kuzwa mbungu yango, yandi zaba ti, yandi ke kuma mundongo ya beto, kasi ba ya nkaka ke vwanda na kimpwanza.» ");
INSERT INTO mkw_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Na nswalu, mosi-mosi tulaka saki ya yandi na ntoto mpe fungulaka yawu. ");
INSERT INTO mkw_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ntwadisi ya yinzo ya Yosefi sosaka na basaki ya bawu nyonso, kubanda na saki ya yaya ya ntete mpe yandi sukaka na saki ya leki. Kasi mbungu talanaka na saki ya Bezame. ");
INSERT INTO mkw_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Dyambu yina salaka bampangi ya Yosefi kyadi, mpe bawu pasulaka bilele ya bawu. Mosi-mosi vutulaka saki ya yandi na zulu ya mbuluku mpe bawu vutukaka na mbanza. ");
INSERT INTO mkw_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda na bampangi ya yandi kumaka na yinzo ya Yosefi. Yosefi vwandaka ntete kuna na yinzo. Bawu fukamaka kizizi na ntoto na mantwala ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosefi tubaka na bawu: «Yayi wapi mambu beno me sala? Beno zaba ve ti muntu mutindu munu, mu kele na lulendo ya kuzaba mambu yina ke kwiza?» ");
INSERT INTO mkw_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda vutulaka: «Mfumu ya munu, yinki beto lenda zonza? Wapi dyambu beto lenda tuba dyaka na kuzwa mpemba na meso ya nge? Samu ti Nzambi me talisa yimbi ya beto na pwelele. Beto bawu yayi mindongo ya nge, kintwadi na mpangi yina vwandaka na mbungu yango.» ");
INSERT INTO mkw_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yosefi vutulaka: «Ve! Mu lenda sala mutindu yina ve. Kaka yandi yina vwandaka na mbungu muntu ke vwanda mundongo ya munu. Kasi samu na beno, beno lenda vutuka na kizunu na sika ya tata ya beno.» ");
INSERT INTO mkw_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda kwendaka pene-pene ya Yosefi mpe tubaka na yandi: «Mulemvo ya nge mfumu ya munu, pesa na munu kisadi ya nge, luve ya kuzabisa nge mwa dyambu mosi. Kasi kudasukila ve munu, kisadi ya nge. Mu zaba ti nge kele kwandi mutindu Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mfumu ya beto, nge yufulaka beto bisadi ya nge kana beto kele na tata to leki ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Beto vutulaka na mfumu ya munu ti: “Beto kele na tata ya kiboba, na mwana yina yandi butaka na buboba ya yandi. Tata ya beto ke zolaka yandi mingi samu ti yandi me bikana yandi mosi na kivumu ya mama ya yandi. Yaya ya yandi kufwaka.” ");
INSERT INTO mkw_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nge tubaka na beto: “Beno natina munu yandi, mu kele na nsatu ya kutala yandi.” ");
INSERT INTO mkw_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Beto vutulaka na nge mfumu ti: “Mwana yina lenda bika ve tata ya yandi, samu ti tata ya yandi lenda kufwa kana mwana yina bika yandi.” ");
INSERT INTO mkw_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Nge tubaka dyaka na beto: “Kana beno kwiza ve na leki ya beno, beno zaba ti mu ke yamba dyaka beno ve.” ");
INSERT INTO mkw_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Mpe ntangu beto vutukaka na sika ya tata ya beto, kisadi ya nge, beto zabisaka yandi nyonso yina nge, mfumu ya beto, nge tubaka na beto. ");
INSERT INTO mkw_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Mpe ntangu yandi zabisaka na beto na kuvutuka kwaku samu na kusumba mwa ndambu ya bima ya kudya, ");
INSERT INTO mkw_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","beto vutulaka na yandi ti: “Ve! Beto lenda vutuka kuna ve, kana leki ya beto kwenda na beto ve. Kuna, beto lenda vutuka. Samu ti, mfumu ke yamba beto ve, kana leki ya beto kuvwanda ve na beto.” ");
INSERT INTO mkw_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tata ya beto, kisadi ya nge, tubaka na beto: “Beno me zaba ti, kento ya munu, Lasele, butilaka munu kaka bana zole. ");
INSERT INTO mkw_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mosi me zimbanaka, mpe mu banza ti ba kudyaka yandi na kibulu ya nsisi, samu ti mu ke talaka dyaka yandi ve. ");
INSERT INTO mkw_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Mpe beno zola baka dyaka yandi yayi me bikanaka na munu! Kana dyambu ya yimbi kumina yandi, beno zaba ti mu ke kufwa na manyongo nyonso, mpe lufwa ya munu ke kubwa na bayintu ya beno.” ");
INSERT INTO mkw_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Na yina, wapi mutindu mu lenda vutuka na sika ya tata ya munu kana mwana yayi kele ve na beto? Luzingu ya yandi kele ya kukangama na mwana yayi. ");
INSERT INTO mkw_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Kana yandi tala mwana yayi ve, yandi ke kufwa na manyongo nyonso. Mpe lufwa ya yandi ke kubwa na bayintu ya beto. ");
INSERT INTO mkw_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na yina, na mantwala ya tata, mu ndimaka kizitu ya mwana na yintu ya munu. Mu tubaka ti kana mu vutuka ve na yandi, mu ke futa masumu na mantwala ya tata ya munu luzingu ya munu nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ntangu yayi, mulemvo ya nge, bika ti munu kisadi ya nge, mu bikana kwaku na kisika ya mwana yayi mutindu mundongo ya nge, mfumu ya munu. Samu ti, yandi kuvutuka na sika ya tata kintwadi na bayaya ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mu lenda vutuka ve na sika ya tata ya munu kana mwana yayi kele ve na munu. Samu ti, mu zola ve kutala na meso, yimbi yina ke kumina tata ya munu.» ");
INSERT INTO mkw_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosefi lendaka ve na kukanga ntima na mantwala ya bantu nyonso yina vwandaka pene-pene ya yandi. Na yina, yandi lookaka: «Beno basisa bantu ya munu nyonso.» Yandi bikanaka kaka yandi mosi na bampangi ya yandi. Ni kuna yandi zabisaka bawu ti ni yandi Yosefi, mpangi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yosefi dilaka na ngolo, bantu ya Ngipiti kuwaka, mpe nsangu kumaka tii na yinzo ya Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosefi tubaka na bampangi ya yandi: «Ni munu Yosefi! Tata ya munu kele ntete moyo?» Kasi bampangi ya yandi lendaka ve na kuvutula mvutu samu ti, bawu vwandaka na boma na mantwala ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yosefi tubaka na bampangi ya yandi: «Beno belama pene-pene na munu.» Bawu belamaka, mpe Yosefi tubaka: «Ni munu Yosefi, mpangi ya beno, yina beno tekisaka samu ti ba nata munu na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kasi beno kunyonga ve mpe beno tala ve ntima mpasi na yina beno tekisaka munu, samu ti, ba nataka munu na yinsi yayi. Ni Nzambi muntu fidisaka munu kwaku na mantwala ya beno samu ti, mu vuukisa luzingu ya beno. ");
INSERT INTO mkw_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yayi me kuma bamvula zole yina nsatu kotaka na yinsi yayi, mpe bamvula tanu dyaka me bikana, yina beto ke lenda ve na kusaba ntoto, mpe kuyonzika madya. ");
INSERT INTO mkw_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ni yawu yina, Nzambi me fidisa munu na mantwala ya beno samu na kukubikila beno bima ya kudya na yinsi yayi, mpe kukeba beno moyo, beno na makanda ya beno. ");
INSERT INTO mkw_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ni beno ve bantu fidisaka munu kwaku, kasi ni Nzambi. Mpe yandi me sala ti mu vwanda muntu ya nene na kati ya luyalu ya Falawo, ntinu ya Ngipiti. Nzambi me sala munu mfumu ya yinzo ya kimfumu ya Falawo, mpe ntwadisi ya yinsi nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Beno kwenda nswalu na sika ya tata ya munu, mpe beno zabisa yandi mutindu yayi: “Mwana ya nge Yosefi me tuba: Nzambi me tula munu mfumu ya Ngipiti nyonso, kwiza na sika ya munu, kuvingila dyaka ve. ");
INSERT INTO mkw_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nge ke zinga na kizunga ya Ngosene pene-pene na munu. Kuna nge ke zinga na bana ya nge, mitekolo ya nge, mameme, bankombo, bangombe ya nge, na bimvwama ya nge nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kwaku mu ke pesa nge nyonso, samu ti nge kondwa kima ve, nge na dikanda ya nge, na nyonso yina kele ya nge. Samu ti nsatu ke zingila dyaka bamvula tanu.”» ");
INSERT INTO mkw_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","«Beno mosi ke na kutala na meso ya beno, mpangi ya munu Bezame mpe ke na kutala ti ni munu Yosefi ke na kuzonza na beno. ");
INSERT INTO mkw_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Beno kwenda zabisa na tata ya munu, bunene ya bumfumu yina mu me kuma na yawu, kwaku na yinsi ya Ngipiti, mpe nyonso yina beno me tala awa. Beno sala mbangu na kunata yandi kwaku.» ");
INSERT INTO mkw_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yosefi bumbasanaka na leki ya yandi Bezame, mpe bawu zole dilaka. ");
INSERT INTO mkw_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yosefi fibaka bampangi ya yandi nyonso na kudila. Ni kuna bampangi ya yandi kuzwaka ngolo ya kusolola na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Nsangu wakanaka na yinzo ya Falawo ti bampangi ya Yosefi me kwiza. Falawo na bisadi ya yandi, yangalalaka na nsangu yina. ");
INSERT INTO mkw_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Mpe Falawo tubaka na Yosefi: «Tuba na bampangi ya nge na kusala mutindu yayi: “Beno fulusa bambuluku ya beno na bima ya kudya mpe beno kwenda na yinsi ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Beno baka tata ya beno na makanda ya beno, mpe beno vutuka na sika ya munu. Mu ke pesa beno kizunga yina me lutila kitoko na yinsi ya Ngipiti, mpe beno ke kudya bima yina me lutila mbote.” ");
INSERT INTO mkw_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Na yina me tala nge, zabisa bawu mutindu yayi: “beno baka bapusu-pusu ya yinsi ya Ngipiti ya kunatina bakento ya beno, na bana ya beno, mpe na tata ya beno. Na manima, beno vutuka kwaku. ");
INSERT INTO mkw_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Beno kunyonga ve samu na bima ya beno yina ke bikana kuna. Samu ti, bima yina me lutila kitoko na yinsi ya Ngipiti ke vwanda ya beno.» ");
INSERT INTO mkw_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Bana ya Isayeli salaka mutindu ba zabisaka bawu. Yosefi pesaka bawu bapusu-pusu mutindu vwandaka ntumunu ya Falawo, na madya ya kudya na nzila. ");
INSERT INTO mkw_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yandi pesaka na mosi-mosi na bawu kinkuti ya ntalu, kasi na Bezame yandi pesaka bankama tatu (300) ya mbongo na binkuti tanu ya ntalu. ");
INSERT INTO mkw_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yandi fidisaka mpe na tata ya yandi bambuluku ya mbakala kumi ya kufuluka na bima ya kitoko ya Ngipiti, mpe bambuluku ya nkento kumi ya kufuluka na bambuma ya faline na mampa, mpe na bima ya nkaka ya kudya na nzila samu na tata ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yandi tubaka na bawu: «Beno kuswana ve na nzila.» Yandi bikaka bawu mpe bawu kwendaka. ");
INSERT INTO mkw_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Bawu bikaka Ngipiti, bawu kumaka na yinsi ya Kaana, na sika tata ya bawu Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Mpe bawu tubaka na yandi: «Yosefi ke ntete moyo, ni yandi muntu kele mfumu ya nene ya yinsi nyonso ya Ngipiti.» Yakobi vwandaka mutindu ti yandi kuwaka bawu ve, samu ti yandi vwandaka kwikila ve na mambu yina bawu vwandaka zabisa yandi. ");
INSERT INTO mkw_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Bawu zabisaka yandi mambu nyonso yina Yosefi tubaka na bawu. Na manima, yandi talaka bapusu-pusu yina Yosefi fidisaka samu na kunata yandi. Ntangu tata ya bawu Yakobi talaka nyonso yina, yandi kwikilaka mpe yandi kuzwaka ngolo. ");
INSERT INTO mkw_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isayeli, yina ba ke bokilaka mpe Yakobi, tubaka: «Ya me lunga! Mwana ya munu Yosefi ke ntete moyo! Mu zola kwenda tala yandi tekila mu kufwa.» ");
INSERT INTO mkw_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isayeli kwendaka na bima ya yandi nyonso, mpe yandi kwizaka kuma na Beele-Seba. Kuna, yandi pesaka minkayulu na Nzambi ya tata ya yandi, Isaaki. ");
INSERT INTO mkw_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Na mpimpa, Nzambi monikinaka Isayeli na lumoni mpe yandi tubaka: «Yakobi! Yakobi!» Yakobi vutulaka: «Munu yandi yayi.» ");
INSERT INTO mkw_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nzambi tubaka: «Mu kele Nzambi, Nzambi ya tata ya nge. Kuvwanda ve na boma na kukwenda na yinsi ya Ngipiti, samu ti, ni kuna mu ke sala ti, nge kuma dikanda ya nene. ");
INSERT INTO mkw_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Munu, mu ke kwenda kintwadi na nge na yinsi ya Ngipiti. Ni munu mpe ke basisa nge kuna. Yosefi ke kanga nge meso ntangu nge ke kufwa.» ");
INSERT INTO mkw_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakobi katukaka na Beele-Seba. Bana ya Isayeli nataka tata ya bawu Yakobi, na bakento ya bawu, mpe na bana ya bawu, na bapusu-pusu yina Falawo, ntinu ya Ngipiti, fidisaka samu na kunata bawu. ");
INSERT INTO mkw_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Bawu nataka mpe bibulu ya bawu, na bimvwama nyonso yina bawu kuzwaka na yinsi ya Kaana. Yakobi kwendaka na yinsi ya Ngipiti na dikanda ya yandi nyonso: ");
INSERT INTO mkw_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","bana ya yandi ya babakala, na ya bakento, na batekolo ya yandi ya babakala na ya bakento kintwadi na yandi. Yandi nataka dikanda ya yandi nyonso na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yayi ni bankumbu ya bana ya Isayeli, bayina kwendaka na Ngipiti, Yakobi na bana ya yandi. Lubene mwana ya ntete ya Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Bana ya Lubene ni: Enoke, Palu, Eselone na Kalemi. ");
INSERT INTO mkw_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Bana ya Simewone ni: Yemwele, Yamine, Oyade, Yakine, Sowale na Sawule, yina vwandaka mwana ya kento ya mu-Kaanani. ");
INSERT INTO mkw_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Bana ya Levi ni: Ngelesone, Keyate mpe Melali. ");
INSERT INTO mkw_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Bana ya Yuda ni: Ele, Onane, Sela, Pelese na Zela. Ele na Onane kufwaka na yinsi ya Kaana. Pelese vwandaka na bana zole: Eselone na Amule. ");
INSERT INTO mkw_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Bana ya Isakale ni: Tola, Puwa, Yobe na Simelone. ");
INSERT INTO mkw_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Bana ya Zabulone ni: Selede, Elone na Yaleele. ");
INSERT INTO mkw_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yina ni bana yina Leya butaka na Yakobi kuna na Mezopotami, ata kutanga mwana ya yandi ya kento, Dina. Bana nyonso ya Leya na batekolo ya yandi, bakento na babakala, bawu vwandaka na lutangu ya makumi tatu na tatu. ");
INSERT INTO mkw_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Bana ya Ngade ni: Sefone, Angi, Suni, Esebone, Eli, Alodi na Aleli. ");
INSERT INTO mkw_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Bana ya Asele ni: Yimena, Yiseva, Yisevi, Belya na kibusi ya bawu Sela. Bana ya Belya ni Ebele na Malekyele. ");
INSERT INTO mkw_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Yina ni kumi na sambanu ya bana na batekolo ya Yakobi na Zilepa. Zilepa kele kisadi ya kento yina Labane pesaka na mwana ya yandi Leya. ");
INSERT INTO mkw_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Bana ya Lasele, kento ya Yakobi, ni Yosefi na Bezame. ");
INSERT INTO mkw_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Bana yina Yosefi butaka na Ngipiti na Asenate, mwana ya Poti-fela, nganga-Nzambi ya mbanza One, ni Manase na Efalayime. ");
INSERT INTO mkw_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bana ya Bezame ni: Bela, Bekele, Asebele, Ngela, Naamane, Eyi, Lose, Mupime, Wupime na Alede. ");
INSERT INTO mkw_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yina ni kumi na yiya ya bana na batekolo ya Lasele na Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwana ya Dane ni Yusime. ");
INSERT INTO mkw_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Bana ya Nafetali ni: Yaseele, Nguni, Yesele na Sileme. ");
INSERT INTO mkw_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yina ni bana na batekolo ya Bila, kisadi ya kento yina Labane pesaka na mwana ya yandi, Lasele. Yina ni bana nsambwadi ya Bila na Yakobi. ");
INSERT INTO mkw_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Bantu nyonso yina kwendaka na Yakobi na yinsi ya Ngipiti, bana na batekolo ya yandi, vwandaka makumi sambanu na nsambwadi, ata kutanga bakento ya bana ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Na Ngipiti, Yosefi butaka bana zole. Lutangu ya bantu nyonso ya dikanda ya Yakobi, bayina kwendaka na Ngipiti, vwandaka makumi nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobi fidisaka Yuda na sika ya Yosefi, samu ti Yuda lakisa Yosefi nzila ya kukwenda na Ngosene na sika ya Yakobi. Yakobi na bantu ya yandi kumaka na Ngosene. ");
INSERT INTO mkw_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosefi kubikaka kipusu-pusu ya yandi ya mvita. Yandi yulukaka na yawu mpe yandi kwendaka na Ngosene, samu na kubwabana tata ya yandi, Isayeli. Kaka na ntangu yina Yosefi talaka tata ya yandi, Yosefi bwidilaka tata ya yandi na nzutu, yandi zingaka maboko na laka ya tata ya yandi mpe yandi dilaka mingi. ");
INSERT INTO mkw_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isayeli tubaka na Yosefi: «Ntangu yayi, mu lenda kufwa ya munu, samu ti mu me tala kizizi ya nge, mpe nge ke ntete moyo.» ");
INSERT INTO mkw_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yosefi tubaka na bampangi ya yandi mpe na dikanda nyonso ya tata ya yandi: «Mu ke kwenda zonzila Falawo, mu ke tuba na yandi ti, bampangi ya munu na dikanda nyonso ya tata ya munu, bayina vwandaka na yinsi ya Kaana, bawu me kwiza na sika ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Bawu kele mivungi ya bibulu, bawu ke yunduluka mameme na bankombo. Bawu me kwiza na bibulu ya bawu, bangombe, mameme na bankombo. Bawu me nata bima nyonso yina kele ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ntangu Falawo ke bokila beno mpe ke yufula beno ti yinki beno ke salaka, ");
INSERT INTO mkw_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","beno ke vutula ti beto bisadi ya nge, beto ke yundulaka bibulu, kubanda buntwenya ya beto tii ntangu yayi, mutindu vwandaka mpe bankooko ya beto. Na yina, beno ke zinga na kizunga yayi ya Ngosene, samu ti, bantu ya Ngipiti ke talaka nganzi mivungi nyonso ya mameme na bankombo.» ");
INSERT INTO mkw_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yosefi kwendaka zabisa Falawo, yandi tubaka: «Tata ya munu na bampangi ya munu me katuka na yinsi ya Kaana. Ntangu yayi bawu kele na kizunga ya Ngosene. Bawu me kwiza na bangombe ya bawu, na mameme, na bankombo, na bima nyonso ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Na kati ya bampangi ya yandi, Yosefi bakaka bawu tanu, mpe yandi lakisaka bawu na sika ya Falawo. ");
INSERT INTO mkw_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Falawo yufulaka bampangi ya Yosefi: «Wapi kisalu yina beno ke salaka?» Bawu vutulaka: «Beto bisadi ya nge, beto kele mivungi ya mameme na bankombo, mutindu vwandaka bankooko ya beto.» ");
INSERT INTO mkw_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Bawu tubaka na Falawo: «Beto me kwiza zinga na bunzenza na yinsi yayi, samu ti nsatu ya nene me kuma na yinsi ya Kaana, mpe matiti ya kudikila bibulu ke dyaka ve. Mulemvo ya nge, pesa beto muswa ya kuzinga na kizunga ya Ngosene.» ");
INSERT INTO mkw_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Falawo tubaka na Yosefi: «Tata ya nge na bampangi ya nge me kwiza na sika nge.» ");
INSERT INTO mkw_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Yinsi nyonso ya Ngipiti kele na maboko ya nge. Kwenda tula tata ya nge na bampangi ya nge na kizunga yina me lutila mbote. Bawu kwenda vwanda na kizunga ya Ngosene. Kana na kati ya bawu, nge zaba bayina me zaba mbote-mbote kisalu, tula bawu bamfumu ya bibulu ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yosefi nataka tata ya yandi Yakobi, mpe yandi lakisaka yandi na sika ya Falawo. Na yina, Yakobi sakumunaka Falawo. ");
INSERT INTO mkw_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Falawo yufulaka Yakobi: «Nge me kuma na bamvula yikwa?» ");
INSERT INTO mkw_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobi vutulaka na Falawo mutindu yayi: «Mu me kuma na bamvula nkama na makumi tatu (130). Mpe konso ntangu, mu vwandaka kwenda zinga na bayinsi ya bunzenza. Luzingu ya munu me vwanda ve ya yinda, yawu me vwanda ya mpasi. Yawu me fwanana ata fyoti ve na yinda ya luzingu ya bankooko ya munu, luzingu ya kwendaka tambula na bayinsi ya bunzenza.» ");
INSERT INTO mkw_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakobi sakumunaka dyaka Falawo, mpe yandi basikaka na yinzo ya Falawo. ");
INSERT INTO mkw_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yosefi pesaka tata ya yandi na bampangi ya yandi kisika ya kuzinga. Yandi pesaka bawu ntoto na kati ya kizunga yina me lutila mbote na yinsi ya Ngipiti, na ntoto yina kele pene-pene na mbanza Lamesese, mutindu Falawo tumisaka yawu. ");
INSERT INTO mkw_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosefi vwandaka pesa madya na tata ya yandi, na bampangi ya yandi, mpe na bantu nyonso ya dikanda ya tata yandi, mutindu vwandaka lutangu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Madya vwandaka dyaka ve na yinsi nyonso samu ti, nsatu vwandaka me kuma ya kulutila. Na yinsi ya Ngipiti mpe na yinsi ya Kaana, bantu vwandaka tala mpasi mingi na nsatu. ");
INSERT INTO mkw_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosefi kutikaka mbongo nyonso ya bantu ya Ngipiti mpe ya bantu ya Kaana, mbongo yina ba vwandaka sumbila bambuma ya faline. Yandi nataka yawu na yinzo ya Falawo. ");
INSERT INTO mkw_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ntangu mbongo ya bantu ya Ngipiti mpe ya bantu ya Kaana manisaka, bantu nyonso ya Ngipiti kwendaka tala Yosefi mpe bawu tubaka: «Pesa beto madya, nge zola ti beto kufwa na mantwala ya nge samu ti mbongo ke dyaka ve?» ");
INSERT INTO mkw_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosefi vutulaka: «Mutindu beno ke dyaka ve na mbongo, beno pesa munu bibulu ya beno mpe mu ke pesa beno madya.» ");
INSERT INTO mkw_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Na yina, bawu nataka bibulu ya bawu na sika ya Yosefi. Yosefi pesaka bawu madya mpe bawu pesaka Yosefi bangombe, bampunda, mameme, bankombo na bambuluku. Ni mutindu yina ba salaka na mvula yina: Yosefi pesaka bawu madya, mpe bawu pesaka yandi bibulu nyonso ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mvula yina manisaka. Na mvula yina landaka, bawu kwendaka na sika ya Yosefi, mpe bawu tubaka na yandi: «Mfumu ya beto, beto ke bumba ve nge yawu: Beto ke dyaka ve na mbongo mpe bibulu ya beto nyonso me kumaka yimeni ya nge. Yina me bikana na beto na kupesa nge, kaka ni banzutu ya beto na bantoto ya beto. ");
INSERT INTO mkw_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nge zola ti beto kufwa na mantwala ya nge, mpe ti bantoto ya beto kubikana ya mpamba? Sumba beto na bantoto ya beto na kupesa beto madya, mpe beto ke kuma bandongo ya Falawo, bantoto ya beto mpe ke kuma ya yandi. Pesa beto bambuma ya kukunda samu ti, beto kufwa ve, beto zinga. Mpe bantoto ya beto ke bikana ve ya mpamba.» ");
INSERT INTO mkw_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Na yina, Yosefi sumbilaka Falawo bantoto nyonso ya Ngipiti. Bantu nyonso ya Ngipiti tekisaka bantoto ya bawu, samu ti nsatu lutilaka. Kubanda ntangu yina, yinsi nyonso kumaka mvwilu ya Falawo. ");
INSERT INTO mkw_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yosefi kitulaka bantu bandongo ya Falawo, na bisika nyonso ya yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kasi, Yosefi sumbaka ve bantoto ya banganga-nzambi, samu ti banganga-nzambi vwandaka kuzwa kikunku ya madya ya bawu na sika ya Falawo mpe bawu vwandaka zinga na yawu. Ni yawu yina, bawu tekisaka ve bantoto ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosefi tubaka na bantu: «Bubu yayi, mu me sumba beno na bantoto ya beno mpe beno me kuma mvwilu ya Falawo. Bambuma yawu yayi, beno lenda kunda bilanga ya beno. ");
INSERT INTO mkw_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Na ntangu ya kuyonzika bambuma, beno ke pesa kikunku ya tanu na sika ya Falawo. Na bikunku yiya yina ke bikana, beno ke kuzwa bambuma ya kukunda na ya kudya na bayinzo ya beno, beno na bana ya beno.» ");
INSERT INTO mkw_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Bawu tubaka: «Mfumu, nge me vuukisa beto mpe nge me sadila beto mambu ya mbote. Na yina, beto me ndima na kuvwanda bandongo ya Falawo.» ");
INSERT INTO mkw_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ni yawu yina, Yosefi basisaka Musiku samu na mambu yina me tadila bantoto ya Ngipiti. Musiku yango ke ntete tii bubu yayi. Yawu ke na kutuba ti: Na ntangu ya kuyonzika bambuma, kikunku ya tanu fwana kupesama na sika ya Falawo. Kaka bantoto ya banganga-nzambi kele ve mvwilu ya Falawo. ");
INSERT INTO mkw_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Bantu ya Isayeli zingaka na yinsi ya Ngipiti na kizunga ya Ngosene. Bawu kuzwaka bamvwilu mingi. Bawu butanaka mpe bawu kumaka mingi. ");
INSERT INTO mkw_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobi zingaka na Ngipiti bamvula kumi na nsambwadi. Luzingu ya yandi nyonso salaka bamvula nkama na makumi yiya na nsambwadi (147). ");
INSERT INTO mkw_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ntangu bilumbu ya lufwa ya Isayeli kumaka pene-pene, yandi bokilaka mwana ya yandi Yosefi, mpe yandi tubaka na yandi: «Kana nge zola munu, tula diboko ya nge na yisi ya dibunda ya munu mpe tuba na munu ti, nge ke lakisa munu luzolo ya nge mpe kukwikama ya nge: Mulemvo ya nge, kukunda munu ve awa na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ntangu mu ke kufwa, nge ke katula munu na Ngipiti mpe nge ke kwenda tula munu na ndyamu ya bankooko ya munu.» Yosefi vutulaka: «Mu ke sala mutindu nge me tuba.» ");
INSERT INTO mkw_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobi tubaka dyaka: «Kudya ndefi samu na dyambu yayi.» Na yina, Yosefi kudyaka ndefi, mpe Isayeli fukamaka na lweka yina vwandaka yintu ya mfulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Na manima ya mambu yina lutaka, ba tubaka na Yosefi ti, tata ya nge ke na kimbevo. Yosefi bakaka bana ya yandi zole Manase na Efalayime. ");
INSERT INTO mkw_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ba zabisaka na Yakobi ti: «Mwana ya nge Yosefi ke na kwizaka samu na kutala nge.» Isayeli salaka ngolo ya kuvumbuka mpe yandi vwandaka na mfulu. ");
INSERT INTO mkw_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobi tubaka na Yosefi: «Nzambi-Mpungu monikinaka munu kuna na Luze, na yinsi ya Kaana mpe yandi sakumunaka munu. ");
INSERT INTO mkw_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Yandi tubaka na munu: “Mu ke pesa nge mabuta, mu ke sala ti nge buta bana mingi, mu ke sala ti nge vwanda nkooko ya makanda ya mingi ya bantu. Mu ke pesa yinsi yayi na bana ya nge. Yawu ke vwanda mvwilu ya bawu ya bantangu nyonso.”» ");
INSERT INTO mkw_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Bana zole yina nge me buta kwaku na Ngipiti ntete mu kwiza na sika ya nge, bawu ke vwanda bana ya munu. Efalayime na Manase ke vwanda bana ya munu mutindu Lubene na Simewone. ");
INSERT INTO mkw_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kasi, bana yina nge ke buta na manima ya bawu, bawu ke vwanda bana ya nge. Bawu ke kuzwa difwa ya bawu na manima ya bampangi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ntangu mu katukaka na Mezopotami, Lasele kufwaka na mantwala ya munu na nzila, kuna na yinsi ya Kaana, ntama mingi ve na mbanza Efalata. Ni kuna mu kundaka yandi na nzila ya Efalata, mbanza yina ba ke bokilaka mpe Betelemi. ");
INSERT INTO mkw_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isayeli talaka bana ya Yosefi mpe yandi tubaka: «Yayi ba nani?» ");
INSERT INTO mkw_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosefi vutulaka na tata ya yandi: «Yayi ni bana ya munu, bana yina Nzambi me pesa munu awa na Ngipiti.» Yakobi tubaka: «Nata bawu pene-pene ya munu samu ti, mu sakumuna bawu.» ");
INSERT INTO mkw_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Meso ya Isayeli vwandaka tala dyaka mbote ve samu na buboba. Yosefi belimisaka bana ya yandi, mpe Isayeli bumbasanaka na bawu mpe yandi fibaka bawu. ");
INSERT INTO mkw_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Na manima, Isayeli tubaka na Yosefi: «Mu vwandaka banza ti mu ke tala dyaka ve kizizi ya nge, kasi Nzambi me sala ti mu tala mpe bana ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yosefi katulaka bana na nkata ya tata ya yandi. Yandi fukamaka kizizi na ntoto. ");
INSERT INTO mkw_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yosefi simbaka bana ya yandi zole. Efalayime vwandaka na diboko ya bakala ya Yosefi, na lweka ya diboko ya kento ya Isayeli. Manase vwandaka na diboko ya kento ya Yosefi, na lweka ya diboko ya bakala ya Isayeli. Yosefi belimisaka bawu na Isayeli mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Isayeli lambulaka diboko ya yandi ya lubakala, yandi tulaka yawu na zulu ya yintu ya Efalayime yina vwandaka leki. Yandi tulaka diboko ya yandi ya lumoso na zulu ya yintu ya Manase. Na kutala mbote, ni Manase vwandaka mwana ya ntete. Kasi, Isayeli sobisaka maboko na kutula diboko ya yandi ya lumoso na zulu ya yintu ya Manase. ");
INSERT INTO mkw_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Isayeli sakumunaka Yosefi mutindu yayi: «Nzambi yina, batata ya munu Abalayami na Isaaki tambulaka na ntadisi ya yandi, Nzambi yina vwandaka Muvungi ya munu ya bantangu nyonso tii bubu yayi, ");
INSERT INTO mkw_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","mbazi yina vwandaka kuula munu na bampasi nyonso, bika ti yandi kusakumuna bana yayi! Bika ti nkumbu ya munu mpe nkumbu ya batata ya munu Abalayami na Isaaki, yawu kuzimbana ve samu na bana yayi! Bika ti bawu kubutana mpe bawu kukuma mingi na kati ya yinsi!» ");
INSERT INTO mkw_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosefi talaka yimbi samu ti tata ya yandi tulaka diboko ya yandi ya lubakala na zulu ya yintu ya Efalayime. Na yina, yandi kukatula diboko ya lubakala ya tata ya yandi na zulu ya Efalayime, samu na kutula yawu na zulu ya yintu ya Manase. ");
INSERT INTO mkw_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yosefi tubaka na tata ya yandi: «Tata, kusala mutindu yina ve! Ni yandi yayi kele mwana ya ntete. Tula diboko ya nge ya lubakala na zulu ya yintu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kasi, tata ya yandi mangaka mpe yandi kutuba: «Mwana munu, mu zaba. Mu zaba ti yandi mpe ke kuma dikanda ya nene, yandi mpe ke vwanda muntu ya nene. Kasi, leki ya yandi ke lutila yandi mpe bana ya yandi ke kuma makanda mingi.» ");
INSERT INTO mkw_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Na kilumbu yina, yandi sakumunaka bawu mutindu yayi: «Bantu ya Isayeli ke banda na kutangunaka bankumbu ya beno samu na kusakumuna bantu. Ba ke tuba: “Bika ti Nzambi kusala na nge mutindu yandi salaka na Efalayime mpe na Manase!”» Na kusala mutindu yina, Isayeli tulaka Efalayime na mantwala ya Manase. ");
INSERT INTO mkw_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Isayeli tubaka na Yosefi: «Mu ke dyaka ntama ve na lufwa, kasi Nzambi ke vwanda na beno. Yandi ke vutula beno na yinsi ya bankooko ya beno. ");
INSERT INTO mkw_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Munu, mu me pesa nge ntoto ya Sekeme. Yawu kele kikunku ya kulutila na bikunku ya bampangi ya nge. Mu nwanisaka ba-Amoli na mbele ya muzingu mpe na munani ya mvita, samu na kuzwa ntoto yina.» ");
INSERT INTO mkw_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakobi bokilaka bana ya yandi mpe yandi zabisaka bawu mutindu yayi: «Beno vukana kisika mosi mpe mu ke zabisa beno mambu yina ke kumina beno na bilumbu yina ke kwiza. ");
INSERT INTO mkw_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Beno vukana kisika mosi mpe beno kuwa, beno bana ya Yakobi. Beno kuwa Isayeli, tata ya beno. ");
INSERT INTO mkw_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Lubene, nge ni mwana ya munu ya ntete, mbuma ya ntete ya mabuta ya munu. Ntangu mu vwandaka ntete na ngolo ya munu nyonso. Nge me lutila bampangi ya nge nyonso Nge me lutila na buzitu mpe na ngolo. ");
INSERT INTO mkw_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nge kele mutindu maza ya mwila yina me luta ndilu, mpe nge ke lutila dyaka bampangi ya nge ve nge vukisaka mfulu na kento ya tata ya nge, na kusala mutindu yina, nge sumunaka mfulu ya munu. ");
INSERT INTO mkw_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Simewone na Levi ke bampangi, kiwisa ya bawu kele samu na kusala yimbi. ");
INSERT INTO mkw_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mu ke kota ve na mfundu ya bawu. Mu ke vukana ve na bawu. Na nkele ya bawu, bawu kufwaka bantu. Na kilengi ya bawu, bawu zengaka misisa ya makulu ya bangombe. ");
INSERT INTO mkw_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nkele ya bawu kuvwanda ya kusiingwa, yawu kele ya yimbi! Kudasuka ya bawu kuvwanda ya kusiingwa! Yawu ke na kyadi ve. Mu ke tula nkabwani na bana ya bawu na yinsi ya Yakobi, mu ke mwangisa bawu na yinsi ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«Yuda, bampangi ya nge ke kembila nge. Nge ke yala bambeni ya nge. Bampangi ya nge ke fukama na mantwala ya nge. ");
INSERT INTO mkw_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda kele mutindu nkosi ya ntwenya yina me katuka na kufwa bibulu. Yandi ke fukamaka mpe ke lalaka mutindu nkosi, mutindu nkosi ya kento: nani ke lenda na kutelemisa yandi? ");
INSERT INTO mkw_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mukawa ya kintinu ke katuka ve na dikanda ya Yuda. Yinti ya lutumu yina kele na kati-kati ya makulu yandi, ke katuka ve tii ntangu Silo ke kwiza, bantu nyonso ke tumama na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yandi ke kanga mbuluku ya yandi na yinti ya vinu, yandi ke kanga mwana ya mbuluku ya yandi na yinti ya mbote ya vinu. Yandi ke sukula binkuti ya yandi na vinu, kiyunga ya yandi na maza ya bambuma ya vinu. ");
INSERT INTO mkw_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Meso ya yandi ke kuma mbwaki samu na vinu, meno ya yandi ke kuma mpembe samu na miliki. ");
INSERT INTO mkw_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Zabulone ke zinga na kumu ya mubu. Yandi ke vwanda na kisika yina babwatu ya nene ke telamaka. Yinsi ya yandi ke yalumuka tii na mbanza Sidone. ");
INSERT INTO mkw_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Isakale kele mbuluku yina kele na ngolo, yina ke lalaka na kati-kati ya bampaka. ");
INSERT INTO mkw_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Yandi talaka ti, kisika ya kupema vwandaka mbote yinsi yina vwandaka kitoko. Yandi betamaka samu na kutula bizitu na digembo. Yandi kotaka na kisalu ya bundongo. ");
INSERT INTO mkw_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Dane ke fundisa bantu ya yandi mutindu kifumba mosi ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Bika ti Dane kuvwanda nyoka yina kele na nzila, yandi kuvwanda mutindu mpidi yina ke tatikaka bikodya ya mpunda samu na kubwisa kinati ya yawu na manima. ");
INSERT INTO mkw_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«Mu me sala kivuvu ya munu na mpulusu ya Yave. ");
INSERT INTO mkw_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«Ngade, nkonga ya binwani ke na kunwanisa yandi, kasi ni yandi me baluka na kunwanisa mpe kulanda bawu. ");
INSERT INTO mkw_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asele, ntoto ya yandi ke buta madya mingi. Yandi ke pesa madya yina me lunga na ntinu. ");
INSERT INTO mkw_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«Nefetali kele nkabi yina ke na kimpwanza. Yawu ke na kubuta bana ya kitoko. ");
INSERT INTO mkw_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«Yosefi kele mutwikila ya yinti yina ke butaka bambuma, mutwikila ya yinti yina ke butaka pene-pene ya yinto. Bintala ya yawu ke lutila bibaka ya lupangu na yinda. ");
INSERT INTO mkw_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ba me sombola yandi, ba me losila yandi madyonga, bambeni ya yandi, bikubudi-madyonga. ");
INSERT INTO mkw_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Kasi, yandi me simba mbote munani ya yandi ya mvita, maboko ya yandi ke kaka ngolo, na lulendo ya Nzambi ya Yakobi, Muvungi, Ditadi ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Na Nkumbu ya Nzambi ya tata ya nge, bika ti yandi kusadisa nge! Na Nkumbu ya Nzambi-Mpungu, bika ti yandi kusakumuna nge, na balusakumunu ya mvula yina ke katukaka na zulu, na balusakumunu ya maza yina ke katukaka na yisi ya ntoto, na balusakumunu ya kubuta mingi ya bakento na bibulu. ");
INSERT INTO mkw_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Balusakumunu yina tata ya nge ke na kupesa, yawu me lutila balusakumunu ya myongo yina kele katuka ntama, yawu me lutila bimvwama ya myongo ya fyoti yina kele katuka ntama. Bika ti yawu kulumuka na zulu ya yintu ya Yosefi, na mbunzu ya muntu yina ba me byeka na kati ya bampangi ya yandi! ");
INSERT INTO mkw_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Bezame kele yimbwa ya mfinda yina ke pasulaka musuni. Na suka, yandi ke kudyaka kibulu yina yandi me kufwa. Na nkokila, yandi ke kabulaka bibulu yina yandi me kuzwa.» ");
INSERT INTO mkw_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yina ni bifumba kumi na zole ya Isayeli. Ni mambu yina tata ya bawu zonzaka na bawu samu na kusakumuna bawu. Yandi pesaka na konso muntu lusakumunu yina fwanakanaka na yandi. ");
INSERT INTO mkw_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yakobi pesaka bana ya yandi ntumunu yayi: «Ntangu mu ke kwenda vukana na bankooko ya munu yina kufwaka, beno ke tula munu na ndyamu, kisika mosi na batata ya munu, na ntadi yina kele na bilanga ya Efelone, mu-Iti. ");
INSERT INTO mkw_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ni ntadi yina kele na kati ya bilanga ya Makepela, na kisika yina ke talasanaka na Mamele, kuna na yinsi ya Kaana. Abalayami sumbaka bilanga yina na sika ya Efelone, mu-Iti, samu na kutulaka bantu ya yandi kuna. ");
INSERT INTO mkw_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ni kuna ba tulaka Abalayami na kento ya yandi Saala. Ni kuna ba tulaka Isaaki na kento ya yandi Lebeka. Munu mpe, ni kuna mu tulaka Leya. ");
INSERT INTO mkw_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ba sumbaka bilanga na ntadi yina kele na kati ya yawu na sika ya bana ya Ete.» ");
INSERT INTO mkw_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ntangu Yakobi manisaka na kupesa bantumunu na bana ya yandi, yandi lalaka dyaka, mpe yandi vutulaka mwela. Yandi kwendaka vukana na bankooko ya yandi yina kufwaka. ");
INSERT INTO mkw_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosefi kwendaka kubwa na nzutu ya tata ya yandi. Yandi bandaka na kudila mpe na kufiba yandi na kizizi. ");
INSERT INTO mkw_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yosefi tumisaka minganga ya yandi na kuyumisa nzutu ya tata ya yandi na manganga. Minganga tulaka nzutu ya Isayeli manganga. ");
INSERT INTO mkw_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Bawu salaka bilumbu makumi yiya samu na kuyumisa mvumbi. Bantu ya Ngipiti dilaka Isayeli bilumbu makumi nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ntangu bilumbu ya kyadi manisaka, Yosefi tubaka na bantu yina vwandaka sala na yinzo ya Falawo: «Mulemvo ya beno, kana beno zola munu, beno kwenda tuba na Falawo mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Tata ya munu tubaka na munu dyambu yayi, samu ti mu kudila yawu ndefi, yandi tubaka: “Mu me kuma pene-pene na lufwa. Tuba na munu ti, nge ke tula munu na ndyamu yina mu timunaka na yinsi ya Kaana.” Ni yawu yina, mu ke na kulomba na nge na kupesa munu muswa ya kwenda tula tata ya munu kuna. Na manima mu ke vutuka.» ");
INSERT INTO mkw_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Falawo vutulaka: «Kwenda tula tata ya nge na ndyamu, mutindu yandi didisaka nge ndefi.» ");
INSERT INTO mkw_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Na yina, Yosefi kwendaka tula tata ya yandi na ndyamu. Yandi vwandaka na bisadi nyonso ya Falawo, bakuluntu ya yinzo ya Falawo na bamfumu nyonso ya yinsi ya Ngipiti, ");
INSERT INTO mkw_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","dikanda nyonso ya Yosefi, bampangi ya yandi mpe dikanda nyonso ya tata ya yandi, bawu nyonso kwendaka. Kaka bakento na bana ya fyoti bikanaka kuna na kizunga ya Ngosene, na bangombe na mameme na bankombo. ");
INSERT INTO mkw_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Yosefi kwendaka na bipusu-pusu ya mvita mpe nyonso yina ke kwendaka na yawu. Nkonga ya bantu vwandaka ya nene mingi. ");
INSERT INTO mkw_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Bawu kumaka na Ngolene-Atade, kisika yina kele na lweka ya nkaka ya nzadi ya Yolodani. Ni kuna bawu salaka matanga ya nene ya nzikulu. Yosefi kotaka kifwidi ya tata ya yandi bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ba-Kaanani yina vwandaka zinga na yinsi yina, bawu talaka matanga yango ya nzikulu kuna na Ngolene-Atade. Bawu tubaka: «Ya kele kifwidi ya nene samu na yinsi ya Ngipiti!» Ni yawu yina, ba pesaka kisika yina nkumbu Abele-Miselayime, yina zola kutuba «Kifwidi ya Ngipiti.» Kisika yango kele na lweka ya nkaka ya nzadi ya Yolodani. ");
INSERT INTO mkw_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Bana ya Yakobi salaka, samu na tata ya bawu, mambu yina yandi tumisaka bawu na kusala. ");
INSERT INTO mkw_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Bawu nataka nzutu ya tata ya bawu na yinsi ya Kaana mpe bawu tulaka yandi na ndyamu, na ntadi ya bilanga ya Makepela, bilanga yina Abalayami sumbaka na Efelone, mu-Iti, samu na kutulaka bantu ya yandi. Bilanga yango vwandaka na kisika yina ke talasanaka na Mamele. ");
INSERT INTO mkw_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Na manima ya kutula tata ya yandi na ndyamu, Yosefi vutukaka na Ngipiti na bampangi ya yandi, na bayina nyonso kwendaka na yandi, na nzikulu ya tata ya yandi. ");
INSERT INTO mkw_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ntangu bampangi ya Yosefi talaka ti tata ya bawu me kufwa, bawu tubaka: «Kuzaba ve kana Yosefi ke baka beto mutindu bambeni ya yandi mpe kana yandi ke vutula beto yimbi nyonso yina beto salaka yandi.» ");
INSERT INTO mkw_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Na yina, bawu fidisaka muntu na kwenda zabisa Yosefi mutindu yayi: «Ntete tata ya nge kufwa, yandi pesaka ntumunu yayi: ");
INSERT INTO mkw_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Beno ke tuba na Yosefi ti, mulemvo ya nge, lemvokila yimbi ya bampangi ya nge, na disumu ya bawu. Bawu salaka nge yimbi. Kasi ntangu yayi, mulemvo ya nge, lemvokila yimbi ya bisadi ya Nzambi ya tata ya nge.”» Ntangu ba zabisaka Yosefi mambu yina, yandi bandaka na kudila. ");
INSERT INTO mkw_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Bawu mosi bampangi ya Yosefi, kwendaka na sika ya yandi. Bawu fukiminaka yandi mpe bawu tubaka: «Beto kele bandongo ya nge.» ");
INSERT INTO mkw_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kasi Yosefi tubaka: «Beno vwanda ve na boma. Beno ke na kubanza ti mu ke baka kisika ya Nzambi? ");
INSERT INTO mkw_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Beno kanisaka na kusala munu yimbi, kasi Nzambi kanisaka na kusala mambu ya mbote, samu na kulungisa mambu yina ke na kusalama bubu yayi. Yawu me salama samu na kuvuukisa luzingu ya dikanda ya nene ya bantu. ");
INSERT INTO mkw_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Na yina, beno vwanda ve na boma. Mu ke sadisa beno, na bana ya beno na kupesaka beno, bima yina beno ke vwanda na yawu nsatu.» Yandi kindisaka bawu mpe yandi zonzilaka bawu na luzolo nyonso. ");
INSERT INTO mkw_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosefi zingaka na yinsi ya Ngipiti yandi na dikanda nyonso ya tata ya yandi. Yandi zingaka bamvula nkama na kumi (110). ");
INSERT INTO mkw_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yosefi talaka mbutukulu ya bana na batekolo ya mwana ya yandi Efalayime. Yosefi kulisaka bana ya Makile, mwana ya Manase. ");
INSERT INTO mkw_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yosefi tubaka na bampangi ya yandi: «Mu me kuma pene-pene ya lufwa. Ya tsyelika, Nzambi ke sadila beno mambu ya mbote. Yandi ke basisa beno na yinsi yayi, samu na kunata beno na yinsi yina yandi kudyaka ndefi na kupesa na Abalayami, na Isaaki mpe na Yakobi.» ");
INSERT INTO mkw_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Na manima, Yosefi didisaka bana ya Isayeli ndefi, yandi tubaka: «Beno kudya ndefi ti, ntangu Nzambi ke sadila beno mambu ya mbote, beno ke baka mikwa ya munu mpe beno ke nata yawu.» ");
INSERT INTO mkw_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yosefi kufwaka na bamvula nkama na kumi (110). Ba yumisaka nzutu ya yandi mpe ba tulaka yawu na sanduku, kuna na Ngipiti.");
INSERT INTO mkw_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yayi ni bankumbu ya bana ya Isayeli bayina kwizaka na Ngipiti kintwadi na Yakobi. Konso muntu kwizaka na dikanda ya yandi: ");
INSERT INTO mkw_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Lubene, Simewone, Levi, Yuda, ");
INSERT INTO mkw_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakale, Zabulone, Bezame, ");
INSERT INTO mkw_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dane, Nefetali, Ngade, Asele. ");
INSERT INTO mkw_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Bayina butukaka na Yakobi vwandaka makumi nsambwadi. Na ntangu yina, Yosefi tekilaka na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yosefi na bampangi ya yandi nyonso mpe bantu nyonso ya mbandu yina manisaka na kufwa. ");
INSERT INTO mkw_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Na manima, bana ya Isayeli butanaka, bawu kumaka mingi, bawu butanaka mingi-mingi, mpe bawu vwandaka lutila na kukuma ngolo. Bawu manisaka na kufuluka na yinsi yina. ");
INSERT INTO mkw_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Na manima, ntinu ya nkaka yina zabaka ve Yosefi bandaka na kuyala na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Yandi tubaka na bantu ya yandi: «Beno tala, bana ya Isayeli me lutila na kukuma mingi mpe bawu me kuma na ngolo, kulutila beto. ");
INSERT INTO mkw_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Beto sadila bawu mayela, samu ti bawu tatamana ve na kukuma mingi. Samu ti, kana mvita kumina beto, bawu lenda vukana na bambeni ya beto, samu na kunwanisa beto, mpe na manima, bawu ke katuka ya bawu na yinsi yayi.» ");
INSERT INTO mkw_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Na yina, ba tudilaka bawu bamfumu ya bisalu ya ngolo, samu na kutalisa bawu mpasi, na kukwika bawu bisalu ya mpasi. Ni mutindu yina ba vwandaka tungila Falawo bambanza Pitome na Lamesese, samu na kubumbilaka madya. ");
INSERT INTO mkw_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Kasi ata ti ba vwandaka lutisa na kutalisa bana ya Isayeli mpasi, bana ya Isayeli vwandaka lutila dyaka na kubutana mpe na kukuma mingi. Bantu ya Ngipiti kumaka na boma ya bana ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Na yina, bantu ya Ngipiti kotisaka bana ya Isayeli na bundongo ya ngolo. ");
INSERT INTO mkw_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Bawu salaka ti luzingu ya bana ya Isayeli kuvwanda luzingu mosi ya ndudi, samu na bisalu ya ngolo yina ba vwandaka kwika bawu: kulamba kibuma, kuyidika bibiliki, kusala bisalu nyonso ya bilanga. Ni bisalu nyonso yayi ya ngolo ba vwandaka kwika bawu na kusala. ");
INSERT INTO mkw_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ya vwandaka na bakento zole ya ba-Ebeleyo yina ke butisaka. Bankumbu ya bawu vwandaka Sifela mpe ya nkaka Puwa. Ntinu ya Ngipiti zonzaka na bawu. ");
INSERT INTO mkw_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Yandi tubaka: «Ntangu beno ke butisa bakento ya ba-Ebeleyo, beno tala mwana kana yandi kele kento to bakala. Kana yandi kele mwana ya bakala, beno fwana kufwa yandi. Kana yandi kele mwana ya kento, beno bika yandi moyo.» ");
INSERT INTO mkw_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kasi bibutisi yango vwandaka na boma ya Nzambi, mpe bawu salaka ve mutindu ntinu ya Ngipiti tubaka na bawu. Bawu vwandaka bika bana ya babakala kuzinga. ");
INSERT INTO mkw_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Na yina, ntinu ya Ngipiti bokilaka bibutisi yina, mpe yandi tubaka na bawu: «Samu na yinki beno ke na kusala mutindu yina? Samu na yinki beno ke na kubika bana ya babakala kuzinga?» ");
INSERT INTO mkw_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Bibutisi vutulaka na Falawo, ntinu ya Ngipiti: «Bakento ya ba-Ebeleyo kele ata fyoti ve mutindu bakento ya bantu ya Ngipiti. Mutindu bawu ke na ngolo mingi, bawu ke butaka tekila kibutisi kwiza kuma.» ");
INSERT INTO mkw_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Bantu ya Isayeli vwandaka lutila na kukuma mingi mpe na ngolo ya kulutila. Nzambi salaka mambu ya mbote na bibutisi yina. ");
INSERT INTO mkw_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Mutindu bibutisi yina vwandaka na boma ya Nzambi, Nzambi pesaka bawu bana mingi. ");
INSERT INTO mkw_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Na yina, Falawo, ntinu ya Ngipiti, pesaka ntumunu na bantu ya yandi nyonso mutindu yayi: «Bana nyonso ya ba-Ebeleyo yina ke butuka ya babakala, beno losa bawu na nzadi ya Nile. Kasi beno bika bana nyonso ya bakento kuzinga.» ");
INSERT INTO mkw_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Bakala mosi ya kifumba ya Levi kwelaka ndumba mosi ya kifumba yina. ");
INSERT INTO mkw_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ndumba yango kuzwaka kivumu mpe butaka mwana ya bakala. Mutindu yandi talaka ti mwana vwandaka kitoko, yandi bumbaka yandi bangonda tatu. ");
INSERT INTO mkw_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mutindu yandi talaka ti yandi lendaka tatamana ve na kubumba mwana yina, yandi bakaka kitunga yina ba yidikilaka na batwandu. Yandi lengaka yawu guludon na kole. Yandi tulaka mwana na kati ya yawu, mpe yandi tulaka kitunga yango na kati-kati ya matiti, na kumu ya nzadi ya Nile. ");
INSERT INTO mkw_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kibusi ya mwana yina telamaka mwa ntama samu na kutala yinki ke kumina mwana. ");
INSERT INTO mkw_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mwana ya Falawo ya kento kulumukaka na kwenda yobila na nzadi ya Nile. Bisadi ya yandi vwandaka kwenda tambula na kumu ya nzadi. Na ntangu yina, mwana ya Falawo talaka kitunga na kati-kati ya matiti, mpe yandi tumisaka mosi na bisadi ya yandi na kwenda baka yawu. ");
INSERT INTO mkw_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Yandi fungulaka yawu mpe yandi talaka mwana. Ya vwandaka mwa mwana ya bakala. Mwana yango vwandaka dila. Mwana ya Falawo talaka mwana kyadi mpe yandi tubaka: «Ya kele mwana ya ba-Ebeleyo!» ");
INSERT INTO mkw_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Na yina, kibusi ya mwana belamaka na kwiza tuba na mwana ya Falawo mutindu yayi: «Nge zola ti mu kwenda sosila nge, na kati ya bakento ya ba-Ebeleyo, kento yina ke keba mwana yayi mpe ke pesila nge yandi mabene?» ");
INSERT INTO mkw_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mwana ya Falawo vutulaka: «Ee! Kwenda.» Na yina, ndumba kwendaka bokila mama ya mwana. ");
INSERT INTO mkw_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mwana ya Falawo tubaka na kento yina: «Nata mwana yayi, kulisa munu yandi, mpe mu ke futa nge.» Kento yina bakaka mwana mpe kwendaka kulisa mwana. ");
INSERT INTO mkw_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ntangu mwana kulaka, kento yina nataka mwana na sika ya mwana ya Falawo. Mwana ya Falawo bakilaka mwana yina mutindu mwana ya yandi. Mwana ya Falawo pesaka mwana nkumbu Moyize, samu ti yandi tubaka: «Mu basisaka yandi na maza.» ");
INSERT INTO mkw_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Na manima ya bamvula, Moyize kulaka. Kilumbu mosi yandi kwendaka na sika ya bampangi ya yandi ba-Ebeleyo, mpe yandi talaka bisalu ya ngolo yina ba vwandaka sadisa bawu. Kuna, yandi talaka bakala mosi ya mu-Ngipiti, yina vwandaka bula bakala mosi ya mu-Ebeleyo, mosi na bampangi ya yandi ya ba-Ebeleyo. ");
INSERT INTO mkw_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moyize talaka na lweka mosi mpe na lweka ya nkaka. Mutindu yandi talaka ti muntu vwandaka ve, yandi kufwaka mu-Ngipiti yina, mpe yandi bumbaka yandi na yisi ya ntoto. ");
INSERT INTO mkw_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kilumbu yina landaka, Moyize basikaka dyaka. Yandi talaka babakala zole ya ba-Ebeleyo yina vwandaka swana. Moyize tubaka na muntu yina vwandaka ve na mpemba: «Samu na yinki nge ke na kubula mpangi ya nge?» ");
INSERT INTO mkw_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Kasi muntu yina vutulaka: «Nani me tula nge mfumu mpe zuzi samu na kufundisa beto? Yinki, nge zola kufwa munu mutindu nge me kufwa mu-Ngipiti yina?» Moyize kumaka na boma. Yandi tubaka na yisi ya ntima: «Dyambu yayi me zabana!» ");
INSERT INTO mkw_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ntangu Falawo ntinu ya Ngipiti kuwaka mambu yina, yandi sosaka na kufwa Moyize. Kasi Moyize kimaka yinzo ya Falawo, mpe kwendaka na yinsi ya Midyane. Ntangu yandi kumaka kuna, yandi kwendaka vwanda pene-pene ya dibulu ya maza. ");
INSERT INTO mkw_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Nganga-Nzambi ya Midyane vwandaka na bana nsambwadi ya bakento. Bawu kwizaka teka maza na dibulu yina, mpe kufulusa bidikulu na maza ya kunwikisa bibulu ya tata ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kasi mivungi ya bibulu kwizaka bingisa bana yina ya bakento. Ni kuna Moyize telamaka mpe nwaninaka bana yango, mpe yandi nwikisaka bibulu ya bawu maza. ");
INSERT INTO mkw_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Bawu vutukaka na sika ya tata ya bawu Lewele. Lewele tubaka na bawu: «Samu na yinki bubu yayi beno me vutuka mbangu?» ");
INSERT INTO mkw_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Bawu vutulaka: «Bakala mosi ya mu-Ngipiti me kuula beto na maboko ya mivungi ya bibulu. Ni yandi me tekila beto maza, mpe yandi me nwikisa mpe bibulu ya beto maza.» ");
INSERT INTO mkw_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Lewele tubaka na bana ya yandi: «Wapi kisika yandi kele? Samu na yinki beno me bika bakala yina kuna? Beno kwenda bokila munu yandi, yandi kwiza kudya.» ");
INSERT INTO mkw_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moyize ndimaka na kuvwanda na yinzo ya Lewele. Mpe Lewele kwelisaka Moyize mwana ya yandi Sipola. ");
INSERT INTO mkw_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipola butaka mwana ya bakala. Moyize pesaka yandi nkumbu Ngelesome, yina zola kutuba «Nzenza», samu ti yandi tubaka: «Mu me kwiza zinga na yinsi ya bunzenza.» ");
INSERT INTO mkw_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Na manima ya bamvula mingi, ntinu ya yinsi ya Ngipiti kwizaka kufwa. Bana ya Isayeli vwandaka yawula mpe kulooka na yisi ya bundongo. Kulooka ya bawu samu na nsatu ya lusalusu na bundongo ya bawu wakanaka tii na sika ya Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nzambi kuwaka bidilu ya bawu, mpe yandi bambukaka moyo na ngwisani ya yandi na Abalayami, na Isaaki, mpe na Yakobi. ");
INSERT INTO mkw_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nzambi talaka bana ya Isayeli, mpe yandi talaka mbote-mbote dyambu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moyize vwandaka dikila mameme na bankombo ya bokilo ya yandi Yetelo, yina vwandaka nganga-Nzambi ya Midyane. Kilumbu mosi, yandi nataka bibulu yango kuluta yinsi ya kuyuma. Yandi kwizaka kuma na mongo ya Nzambi, mongo yina ba ke bokilaka Olebe. ");
INSERT INTO mkw_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Kuna, mbazi ya Yave talanaka na yandi na mulaka ya tiya na kati-kati ya divunda. Moyize talaka ti divunda vwandaka lema, kasi yawu vwandaka nyenga ve. ");
INSERT INTO mkw_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moyize tubaka na yisi ya ntima: «Mu ke lutila na manima na kwenda tala dyambu yayi ya ngitukulu, samu na yinki divunda ke na kuya ve.» ");
INSERT INTO mkw_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Yave talaka ti Moyize lutilaka na manima samu na kutala. Nzambi bokilaka Moyize na kati-kati ya divunda, mpe tubaka: «Moyize! Moyize!» Moyize vutulaka: «Munu yandi yayi.» ");
INSERT INTO mkw_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nzambi tubaka: «Kubelama awa ve. Katula mapapa na makulu ya nge, samu ti kisika yayi nge kele, ya kele ntoto ya longo.» ");
INSERT INTO mkw_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Nzambi tubaka dyaka: «Mu kele Nzambi ya tata ya nge, Nzambi ya Abalayami, Nzambi ya Isaaki, Nzambi ya Yakobi.» Moyize fukaka kizizi ya yandi, samu ti yandi vwandaka na boma na kutalisa meso ya yandi na Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yave tubaka: «Mu me tala mbote bankwamusu ya bantu ya munu yina kele na Ngipiti. Mu me kuwa mpe bidilu yina ba ke na kudilisa bawu na bayina ke na kunyokola bawu. Mu zaba bampasi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Mu me kulumuka samu na kukuula bawu na maboko ya bantu ya Ngipiti. Mu zola basisa bawu na yinsi ya Ngipiti, na kunata bawu na yinsi ya mbote mpe ya nene, yinsi ya kufuluka na miliki, na mafuta ya nyosi. Ni yinsi ya ba-Kaanani, ya ba-Yiti, ya ba-Amoli, ya ba-Pelizi, ya ba-Yivi, na ya ba-Yebuse. ");
INSERT INTO mkw_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Awa bidilu ya bana ya Isayeli me wakana tii na sika ya munu. Mu me tala mpe mutindu ya kunyokola yina bantu ya Ngipiti ke na kunyokolaka bawu. ");
INSERT INTO mkw_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Na yina, kwenda, mu ke na kufidisa nge na sika ya Falawo, ntinu ya Ngipiti. Basisa bantu ya munu, bana ya Isayeli, na Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moyize tubaka na Nzambi: «Nani mu kele na kukwenda na sika ya Falawo, ntinu ya Ngipiti, mpe na kubasisa bana ya Isayeli na yinsi ya Ngipiti?» ");
INSERT INTO mkw_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nzambi pesaka yandi mvutu yayi: «Mu ke vwanda na nge. Mpe kidimbu yina ke lakisa ti ni munu me fidisa nge, ni yayi: Ntangu nge ke basisa bana ya Isayeli na Ngipiti, beno ke sadila munu, Nzambi, na mongo yayi.» ");
INSERT INTO mkw_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moyize tubaka na Nzambi: «Kana mu kwenda na sika ya bana ya Isayeli, mpe mu tuba na bawu ti: “Nzambi ya batata ya beno me fidisa munu na sika ya beno”, kana bawu yufula munu: “Nkumbu ya yandi nani?” Yinki mu ke vutula na bawu?» ");
INSERT INTO mkw_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nzambi vutulaka na Moyize: «MU KELE YINA MU KELE.» Mpe yandi tubaka dyaka: «Nge ke zonza mutindu yayi na bana ya Isayeli: MU KELE me fidisa munu na sika ya beno.» ");
INSERT INTO mkw_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nzambi tubaka dyaka na Moyize: «Nge ke zonza mutindu yayi na bana ya Isayeli: “Yave, Nzambi ya batata ya beno, Nzambi ya Abalayami, Nzambi ya Isaaki, Nzambi ya Yakobi, me fidisa munu na sika ya beno.” Yayi ni nkumbu ya munu ya bantangu nyonso. Ni na nkumbu yayi ba ke banda na kusambilaka munu na bambandu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Kwenda, kwenda kutikisa bakuluntu ya Isayeli mpe tuba na bawu: “Yave, Nzambi ya batata ya beno, Nzambi ya Abalayami, ya Isaaki, mpe ya Yakobi, yandi me talana na munu. Yandi me tuba: Mu me telama na kusadisa beno na yina me tadila mambu ba ke na kusala beno na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mu me tuba mutindu yayi: Mu ke basisa beno na Ngipiti, kisika yina beno kele na kati ya kyadi, samu na kunata beno na yinsi ya ba-Kaanani, ya ba-Yiti, ya ba-Amoli, ya ba-Pelizi, ya ba-Yivi na ba-Yebuse, yinsi ya kufuluka na miliki na mafuta ya nyosi.”» ");
INSERT INTO mkw_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Bakuluntu ya Isayeli ke wila nge. Mpe nge ke kwenda, nge na bawu, na sika ya ntinu ya Ngipiti. Beno ke zonza na yandi ti: “Yave, Nzambi ya ba-Ebeleyo, me talana na beto. Na yina, pesa beto muswa ya kukwenda na yinsi ya kuyuma. Beto ke dyata bilumbu tatu na kwenda pesa minkayulu na Yave, Nzambi ya beto.” ");
INSERT INTO mkw_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Munu, mu zaba mbote-mbote ti ntinu ya Ngipiti ke pesa ve beno muswa ya kukwenda, ata ti ba me kwika yandi yawu na ngolo. ");
INSERT INTO mkw_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ni yawu yina, mu ke nanguna diboko ya munu samu na kubula yinsi ya Ngipiti na mambu nyonso ya ngitukulu yina mu ke sala kuna. Na manima, yandi ke bika beno kwenda. ");
INSERT INTO mkw_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Mu ke sala ti bantu ya Ngipiti kulakisa beno bumbote ya bawu. Mpe ntangu beno ke basika na yinsi ya bawu, beno ke basika maboko mpamba ve. ");
INSERT INTO mkw_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Konso mu-Isayeli ya kento ke lomba na kento ni kento ya mu-Ngipiti yina ke vwandaka na sika ya yandi, to pene-pene ya yinzo ya yandi, bima ya palata, na bima ya wolo, na binkuti. Beno ke pesa yawu na bana ya beno ya babakala mpe ya bakento. Ni mutindu yina, beno ke botola bimvwama ya yinsi ya Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moyize tubaka na Yave: «Kasi bawu ke kwikila munu ve, mpe bawu ke wila munu ve. Bawu ke tuba: “Yave me talana ve na nge.”» ");
INSERT INTO mkw_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yave tubaka na yandi: «Yinki ke na nge na diboko?» Moyize vutulaka: «Yinti.» ");
INSERT INTO mkw_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yave tubaka: «Losa yawu na ntoto.» Yandi losaka yawu na ntoto, mpe yinti kitukaka nyoka. Moyize kimaka na mantwala ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yave tubaka na Moyize: «Lambula diboko ya nge, mpe simba nyoka yina na mukila.» Moyize lambulaka diboko, mpe simbaka nyoka. Nyoka kitukaka dyaka yinti na diboko ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yave tubaka: «Ni yawu ke lakisa bawu ti munu Yave, Nzambi ya bankooko ya bawu, Nzambi ya Abalayami, Nzambi ya Isaaki, mpe Nzambi ya Yakobi me talana na nge.» ");
INSERT INTO mkw_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yave tubaka dyaka na yandi: «Tula diboko na ntulu ya nge.» Yandi tulaka diboko na ntulu ya yandi, mpe na manima, yandi katulaka diboko. Diboko ya yandi fulukaka na bwazi ya mutindu ntinta ya mpembe ya kulutila. ");
INSERT INTO mkw_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yave tubaka na yandi: «Vutula diboko na ntulu ya nge.» Moyize vutulaka diboko na ntulu ya yandi, mpe yandi katulaka diboko ya yandi na ntulu. Diboko ya yandi vutukaka mbote mutindu yawu ke vwandilaka. ");
INSERT INTO mkw_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Na yina, Yave tubaka: «Kana ba kwikila nge ve, kana bawu ndima nge ve na kidimbu ya ntete, bawu ke kwikila nge na kidimbu ya zole. ");
INSERT INTO mkw_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kana ba kwikila ve na kidimbu ya zole yina, kana ba wila nge ve, nge ke baka maza ya nzadi ya Nile, nge ke mwangisa yawu na ntoto. Maza yina nge ke baka na nzadi ke kituka menga na ntoto.» ");
INSERT INTO mkw_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moyize tubaka na Yave: «Mulemvo ya nge Mfumu, mu kele ve na kinzonzi ya mbote. Mu ke vwandaka ve na yawu tii ntangu yayi nge ke na kuzonza na kisadi ya nge, mu ke na yawu ve. Mu kele na yinwa dema, na ludimi ya dema.» ");
INSERT INTO mkw_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yave tubaka na yandi: «Nani pesaka muntu yinwa? Nani ke salaka ti muntu kuvwanda dibaba to yandi kuwa ve? Nani ke salaka ti muntu kutala to kuvwanda mpofo? Ni munu ve Yave? ");
INSERT INTO mkw_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ntangu yayi, kwenda, mu ke sala ti nge zonza mbote, mpe mu ke longisa nge yina nge fwana kutuba.» ");
INSERT INTO mkw_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moyize tatamanaka na kutuba: «Mulemvo ya nge Mfumu, fidisa muntu ya nkaka yina nge zola.» ");
INSERT INTO mkw_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Yave dasukilaka Moyize, mpe tubaka: «Nge kele ve na mpangi na nkumbu Aloni, mu-Levi? Mu zaba ti yandi ke zonzaka mbote. Yandi ke na kukwiza na kubwabana nge. Ntangu yandi ke tala nge, yandi ke yangalala na ntima. ");
INSERT INTO mkw_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Nge ke zabisa yandi mambu yina yandi ke zonza. Mpe munu, mu ke vwanda na yinwa ya nge, mpe na yinwa ya yandi. Mu ke longisa beno yina beno fwana kusala. ");
INSERT INTO mkw_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Yandi ke zonza na bantu nyonso na kisika ya nge. Yandi ke vwanda yinwa ya nge, mpe nge ke vwanda mutindu nzambi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Yinti yayi, baka yawu na diboko ya nge. Nge ke sadila bimangu na yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moyize vutukaka na sika ya bokilo ya yandi Yetelo, mpe yandi tubaka na Yetelo: «Mulemvo ya nge, mu zola kwenda ya munu, mpe kuvutuka na sika ya bampangi ya munu na Ngipiti, samu na kutala kana bawu ke ntete moyo.» Yetelo tubaka na Moyize: «Kwenda na kizunu!» ");
INSERT INTO mkw_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yave tubaka na Moyize kuna na yinsi ya Midyane: «Kwenda ya nge, vutuka ya nge na yinsi ya Ngipiti, samu ti bantu nyonso yina vwandaka sosa lufwa ya nge, bawu me manisa na kufwa.» ");
INSERT INTO mkw_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moyize bakaka kento ya yandi na bana ya yandi. Yandi tulaka bawu na zulu ya mbuluku, mpe yandi vutukaka na yinsi ya Ngipiti. Yandi bakaka yinti ya Nzambi na diboko. ");
INSERT INTO mkw_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yave tubaka na Moyize: «Tala, mu me pesa nge lulendo nyonso ya kusala bimangu. Mutindu nge ke na kuvutuka na yinsi ya Ngipiti, nge ke sala yawu na mantwala ya Falawo, ntinu ya Ngipiti. Kasi munu, mu ke kanga ntima ya yandi, mpe yandi ke bika ve ti bana ya Isayeli kukwenda. ");
INSERT INTO mkw_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Nge ke tuba na Falawo: Yave me tuba mutindu yayi: “Isayeli kele mwana ya munu, mwana ya munu ya ntete. ");
INSERT INTO mkw_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Mu me tuba na nge: Bika ti mwana ya munu kwenda sadila munu. Kasi nge ke na kumanga na kubika yandi. Na yina, mu ke kufwa mwana ya nge ya ntete.”» ");
INSERT INTO mkw_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Kasi na nzila, ntangu ba vwandaka na kisika ya kulutisa mpimpa, Yave kwizaka bwabana Moyize, mpe zolaka kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ni yawu yina, Sipola bakaka ditadi ya meno, mpe zengaka mpusu ya bubakala ya mwana ya yandi. Na mpusu ya nzutu ya bubakala yina, yandi simbaka bubakala ya Moyize mpe tubaka: «Nge kele bakala ya munu ya menga.» ");
INSERT INTO mkw_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Mpe Yave bikaka Moyize. Sipola tubaka «Bakala ya munu ya menga», samu na nzengolo ya bubakala. ");
INSERT INTO mkw_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yave tubaka na Aloni: «Kwenda bwabana Moyize na yinsi ya kuyuma.» Aloni kwendaka kuta mpangi ya yandi na mongo ya Nzambi, mpe bawu bumbasanaka. ");
INSERT INTO mkw_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moyize zabisaka na Aloni mambu nyonso yina Yave pesaka yandi na kuzonza, mpe bimangu nyonso yina Yave tumisaka yandi na kusala. ");
INSERT INTO mkw_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ntangu bawu kumaka na Ngipiti, Moyize na Aloni kwendaka kutikisa bakuluntu nyonso ya bana ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aloni zabisaka bawu mambu nyonso yina Yave tubaka na Moyize, mpe yandi salaka bimangu na meso ya bantu nyonso ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Bantu nyonso kwikilaka mpe ba bakulaka ti Yave vwandaka sadisa bana ya Isayeli, mpe ti yandi talaka mpasi ya bawu. Bawu fukamaka, mpe sambilaka. ");
INSERT INTO mkw_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Na manima, Moyize na Aloni kwendaka na sika ya Falawo. Bawu tubaka: «Yave, Nzambi ya Isayeli ke na kutuba: “Bika ti bantu ya munu kwenda, samu ti bawu kusadila munu mukembo na yinsi ya kuyuma.”» ");
INSERT INTO mkw_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Falawo, ntinu ya Ngipiti, tubaka: «Nani kele Yave, samu ti mu wila yandi, na kubika Isayeli kukwenda? Mu zaba ve Yave, mpe mu ke bika mpe ve ti bana ya Isayeli kukwenda.» ");
INSERT INTO mkw_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Bawu tubaka: «Nzambi ya beto ba-Ebeleyo me kwiza talana na beto. Pesa beto nzila beto kwenda, beto tambula bilumbu tatu na yinsi ya kuyuma, samu na kukwenda pesa minkayulu na Yave, Nzambi ya beto. Beto zola ve ti yandi kufwa beto na kiyoolo to na mvita.» ");
INSERT INTO mkw_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ntinu ya Ngipiti tubaka na Moyize na Aloni: «Beno Moyize na Aloni, samu na yinki beno zola ti bana ya Isayeli kusala dyaka ve bisalu ya bawu? Beno kwenda na bisalu ya beno ya bundongo!» ");
INSERT INTO mkw_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Falawo, ntinu ya Ngipiti tubaka: «Yinki! Ni na ntangu yayi, yina bantu yayi me kuma mingi-mingi na yinsi, beno zola ti bawu kubika bisalu ya bawu ya bundongo?» ");
INSERT INTO mkw_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Kaka na kilumbu yina, Falawo, ntinu ya Ngipiti, pesaka ntumunu na bantu ya Ngipiti yina vwandaka kengidila bana ya Isayeli na bisalu ya bawu ya bundongo, mpe na bantu ya Isayeli yina vwandaka twadisa bisalu. Ntumunu yango ni yayi: ");
INSERT INTO mkw_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Beno pesa dyaka ve matiti ya nyanga na bana ya Isayeli samu na kusala bibiliki, mutindu beno vwandaka sala na ntama. Bawu ke banda na kwendaka lokota yawu bawu mosi. ");
INSERT INTO mkw_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Na yina, beno ke kwika bawu na kusala lutangu ya bibiliki yina bawu vwandaka sala ntete, beno ke kulula yawu ve. Samu ti bawu kele na bubolo, ni yawu yina, ba ke na kulooka na kutuba ti beto kwenda pesa minkayulu na Nzambi ya beto. ");
INSERT INTO mkw_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Beno fulusa bawu na bisalu, samu ti bawu kusala mingi, mpe bawu kuwa dyaka ve mambu ya luvunu.» ");
INSERT INTO mkw_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Bantu yina vwandaka kengidila bana ya Isayeli na bisalu ya bawu ya bundongo na bantu ya Isayeli yina vwandaka twadisa bisalu, kwendaka zonza na bantu: «Falawo me tuba ti ba ke pesa dyaka ve beno matiti ya nyanga. ");
INSERT INTO mkw_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Beno kwenda sosa beno mosi matiti ya nyanga kisika yina beno lenda kuzwa yawu. Kasi ba ke kulula ata kima na bisalu ya beno.» ");
INSERT INTO mkw_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Na yina, bana ya Isayeli mwanganaka na yinsi nyonso ya Ngipiti, samu na kulokota matiti ya bilanga na kusadila yawu mutindu matiti ya nyanga. ");
INSERT INTO mkw_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Bantu yina vwandaka kengidila vwandaka kwika bawu na kusala mbangu-mbangu. Ba vwandaka tuba mutindu yayi: «Beno fwana kumanisa bisalu ya beno ya konso kilumbu mutindu beno vwandaka sala yawu, ntangu ba vwandaka pesa beno matiti ya nyanga.» ");
INSERT INTO mkw_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Bantu ya Falawo yina vwandaka kengidila bisalu vwandaka bula bantu ya Isayeli yina vwandaka twadisa bisalu, bantu yina bawu mosi soolaka. Bawu vwandaka tuba na bawu: «Samu na yinki beno me lungisa ve lutangu ya bibiliki yina beno zolaka sala mazono na bubu yayi, mutindu beno vwandaka sala ntete?» ");
INSERT INTO mkw_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Bantu ya Isayeli yina vwandaka twadisa bisalu kwendaka nyonga na sika ya Falawo, ntinu ya Ngipiti, mpe bawu tubaka: «Samu na yinki nge ke na kusala mutindu yina na beto bisadi ya nge? ");
INSERT INTO mkw_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ba ke na kupesaka dyaka beto ve matiti ya nyanga, kasi ba ke na kutumisa na beto na kusala bibiliki mpe ba ke na bula dyaka beto. Ni bantu ya nge ke na kusala yimbi!» ");
INSERT INTO mkw_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Falawo, ntinu ya Ngipiti tubaka: «Beno ke na bubolo! Ya tsyelika bantu ya bubolo! Ni yawu yina, beno ke na kutuba ti: “beto zola kwenda pesa minkayulu na Yave!” ");
INSERT INTO mkw_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ntangu yayi, beno kwenda sala! Ba ke pesa beno ve matiti ya nyanga, kasi beno fwana kulungisa lutangu ya bibiliki yina beno ke salaka.» ");
INSERT INTO mkw_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Bantu ya Isayeli yina vwandaka twadisa bisalu talaka ti bawu kumaka na mpasi, samu ti ba zabisaka na bawu ti bawu ke kulula ve lutangu ya bibiliki ya konso kilumbu. ");
INSERT INTO mkw_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ntangu bawu basikaka na yinzo ya Falawo, ntinu ya Ngipiti, bawu kwendaka na sika ya Moyize na Aloni yina vwandaka vingila bawu. ");
INSERT INTO mkw_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Bawu tubaka na Moyize na Aloni: «Bika ti Yave tala mambu ya yimbi yina beno me sala, mpe ti yandi kufundisa beno na mambu yayi. Samu na beno, beto me kuma bantu ya kulutila yimbi na meso ya Falawo, ntinu ya Ngipiti, na bantu yina ke salaka na yandi. Beno me fungula nzila samu ti bawu kufwa beto.» ");
INSERT INTO mkw_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Na manima, Moyize tubaka dyaka na Yave: «Mfumu, samu na yinki nge ke na kutalisa bantu yayi mpasi? Mpe samu na yinki nge me fidisa kwandi munu? ");
INSERT INTO mkw_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kubanda ntangu yina mu kwendaka na sika ya Falawo, ntinu ya Ngipiti, samu na kuzonza na nkumbu ya nge, Falawo ke na kutalisa bantu yayi mpasi, mpe nge me kuula ata fyoti ve bantu ya nge.» ");
INSERT INTO mkw_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yave tubaka na Moyize: «Nge ke tala yinki mu ke sala na Falawo, ntinu ya Ngipiti. Na lulendo ya munu yandi ke bika bawu ba kwenda. Ni lulendo ya munu ke sala ti yandi kubingisa bawu na yinsi ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nzambi zonzaka na Moyize. Yandi tubaka na yandi: «Ni munu Yave. ");
INSERT INTO mkw_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mu talanaka na Abalayami, na Isaaki mpe na Yakobi mutindu Nzambi-Mpungu. Kasi mu zabanaka ve na sika ya bawu na nkumbu ya munu ya Yave. ");
INSERT INTO mkw_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mu salaka mpe ngwisani ya munu na bawu samu na kupesa bawu yinsi ya Kaana. Bawu zingaka kuna mutindu banzenza. ");
INSERT INTO mkw_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Mu me kuwa bidilu ya bana ya Isayeli, samu na mpasi yina bantu ya Ngipiti ke na kutalisa bawu na yisi ya bundongo. Mu me bambuka mpe moyo na ngwisani ya munu. ");
INSERT INTO mkw_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ni yawu yina, tuba na bana ya Isayeli ti: “Ni munu Yave. Mu ke katula beno na bisalu ya ngolo ya Ngipiti, mu ke kuula beno na bundongo yina bawu kotisaka beno, mu ke nwanina beno na ngolo ya munu, mpe mu ke pesa bawu bitumbu. ");
INSERT INTO mkw_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mu ke baka beno mutindu bantu ya munu, mpe mu ke vwanda Nzambi samu na beno. Beno ke zaba ti mu kele Yave, Nzambi ya beno, yina ke katula beno na bisalu ya ngolo ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mu ke kotisa beno na yinsi yina mu kudyaka ndefi na kupesa na Abalayami, na Isaaki mpe na Yakobi. Munu Yave, mu ke pesa beno yawu, mpe yawu ke vwanda ya beno.”» ");
INSERT INTO mkw_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ni mutindu yina Moyize kwendaka zonza na bana ya Isayeli, kasi bawu wilaka yandi ve. Bawu vwandaka lenda dyaka ve na kuvibidila, samu ti bampasi ya bisalu ya bawu lutilaka. ");
INSERT INTO mkw_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Kwenda zonza na Falawo, ntinu ya Ngipiti, yandi bika bana ya Isayeli kubasika na yinsi ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Kasi Moyize tubaka na Yave mutindu yayi: «Kana bana ya Isayeli me wila munu ve, ata fyoti, wapi mutindu Falawo, ntinu ya Ngipiti ke wila munu, munu yina ke na yinwa ya dema?» ");
INSERT INTO mkw_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yave zonzaka na Moyize na Aloni. Yandi zabisaka bawu mambu nyonso yina bawu fwana kusala samu na bana ya Isayeli, mpe samu na Falawo, ntinu ya Ngipiti, samu ti bana ya Isayeli kubasika na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Yayi ni bankumbu ya bamfumu ya makanda. Bana ya Lubene, mwana ya ntete ya Isayeli: Enoke mpe Palu, Eselone mpe Kaleme. Yina ni bankooko ya makanda yina butukaka na Lubene. ");
INSERT INTO mkw_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Bana ya Simewone: Yemwele, Yamine, Oyade, Yakine, Sowale mpe Sawule, mwana ya mu-Kaanani. Yina ni bankooko ya makanda yina butukaka na Simewone. ");
INSERT INTO mkw_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Yayi ni mukanda ya bankumbu ya bankooko ya Levi, mutindu bawu butamaka. Ngelesone, Keyate mpe Melali. Levi zingaka bamvula nkama na makumi tatu na nsambwadi (137). ");
INSERT INTO mkw_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Bana ya Ngelesone: Libeni mpe Simeyi na makanda ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Bana ya Keyate: Amelame, Yiseyale, Ebelone mpe Uzyele. Keyate zingaka bamvula nkama na makumi tatu na tatu (133). ");
INSERT INTO mkw_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Bana ya Melali: Mayeli mpe Musi. Yina ni bankooko ya makanda yina butukaka na Levi, mutindu bawu butamaka. ");
INSERT INTO mkw_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amelame kwelaka Yokebede kibusi ya tata ya yandi. Yokebede butilaka yandi Aloni mpe Moyize. Amelame zingaka bamvula nkama na makumi tatu na nsambwadi (137). ");
INSERT INTO mkw_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Bana ya Yiseyale: Kole, Nefenge mpe Zikeli. ");
INSERT INTO mkw_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Bana ya Uzyele: Misayele, Elesafane mpe Siteli. ");
INSERT INTO mkw_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aloni kwelaka Eliseba, mwana ya Aminadabe kibusi ya Nayesone. Eliseba butilaka yandi Nadabe, Abiwu, Eleyazale mpe Itamale. ");
INSERT INTO mkw_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Bana ya Kole: Asile, Elekana mpe Abyasafe. Yina ni bankooko ya makanda yina butukaka na Kole. ");
INSERT INTO mkw_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleyazale mwana ya Aloni kwelaka ndumba mosi ya Putyele. Yandi butilaka yandi Pinase. Yina ni bamfumu ya makanda ya ba-Levi na makanda ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ni na Aloni mpe Moyize yina Yave tubaka: «Beno basisa bantu ya Isayeli na yinsi ya Ngipiti. Bawu ke sala mutindu mukangu ya binwani.» ");
INSERT INTO mkw_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ni Moyize na Aloni yina kwendaka zonza na sika ya Falawo, ntinu ya Ngipiti na kubasisa bana ya Isayeli na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ntangu yina Yave zonzaka na Moyize kuna na Ngipiti, ");
INSERT INTO mkw_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Yave tubaka: «Ni munu Yave. Kwenda zabisa na Falawo, ntinu ya Ngipiti, mambu nyonso yina mu ke na kuzabisa nge.» ");
INSERT INTO mkw_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Kasi na mantwala ya Yave, Moyize vutulaka: «Mu ke na yinwa ya dema, wapi mutindu Falawo, ntinu ya Ngipiti ke wila munu?» ");
INSERT INTO mkw_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Kasi Yave tubaka na Moyize: «Tala, mu me kumisa nge Nzambi na mantwala ya Falawo, ntinu ya Ngipiti, mpe mpangi ya nge Aloni ke vwanda mumbikudi ya nge. ");
INSERT INTO mkw_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Nge, nge ke zonza na mpangi ya nge Aloni nyonso yina mu ke tumisa nge, mpe yandi ke zonza yawu na Falawo, samu ti yandi bika bana ya Isayeli kubasika na yinsi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Kasi munu, mu ke kanga ntima ya Falawo. Mu ke lakisa bidimbu na bimangu ya munu ya mingi na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Kasi Falawo, ntinu ya Ngipiti ke tumama ve na beno. Mu ke lambula diboko ya munu na yinsi ya Ngipiti, samu na kusemba Ngipiti mutindu me fwanana. Mpe mu ke basisa bantu ya munu na Ngipiti, bantu ya Isayeli na bankonga mutindu binwani. ");
INSERT INTO mkw_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Na yina, bantu ya Ngipiti ke zaba ti mu kele Yave, ntangu mu ke lambula diboko ya munu na Ngipiti, mpe mu ke basisa bana ya Isayeli na kati ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moyize na Aloni salaka mbote-mbote mambu yina Yave tumisaka bawu. Ni mutindu yina bawu salaka. ");
INSERT INTO mkw_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moyize vwandaka na bamvula makumi nana, mpe Aloni bamvula makumi nana na tatu, ntangu bawu kwendaka zonza na Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yave tubaka na Moyize mpe na Aloni: ");
INSERT INTO mkw_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Kana Falawo, ntinu ya Ngipiti, tuba na beno: Beno sala kimangu! Nge Moyize, nge ke tuba na Aloni: Baka yinti ya nge, losa yawu na mantwala ya Falawo, ntinu ya Ngipiti. Yinti ke kituka nyoka.» ");
INSERT INTO mkw_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Na yina, Moyize na Aloni kwendaka na sika ya Falawo, ntinu ya Ngipiti mpe bawu salaka mutindu Yave tumisaka bawu. Aloni losaka yinti ya yandi na mantwala ya Falawo, ntinu ya Ngipiti, mpe na mantwala ya bantu yina ke salaka na Falawo, ntinu ya Ngipiti. Yinti yango kitukaka nyoka. ");
INSERT INTO mkw_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kasi Falawo, ntinu ya Ngipiti mpe bokilaka bantu ya ndwenga na banganga. Bantu ya bampandu ya Ngipiti, bawu mpe, bawu salaka mutindu mosi na bampandu ya bawu: ");
INSERT INTO mkw_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","mosi na mosi na bawu losaka yinti ya yandi mpe bayinti ya bawu kitukaka banyoka. Kasi yinti ya Aloni minaka bayinti ya bawu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kasi Falawo, ntinu ya Ngipiti kangaka ntima ya yandi. Yandi mangaka na tumama na Moyize mpe na Aloni. Yawu salamaka mutindu Yave tubaka. ");
INSERT INTO mkw_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yave tubaka na Moyize: «Falawo, ntinu ya Ngipiti, ke na kusala yintu ngolo mpe yandi ke na kumanga na kubika bantu ya munu na kukwenda. ");
INSERT INTO mkw_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Na suka-suka, nge ke kwenda na sika ya Falawo, ntinu ya Ngipiti, ntangu yina yandi ke basikaka samu na kukwenda na nzadi ya Nile. Nge ke vingila yandi na kumu ya maza. Na diboko ya nge, nge ke vwanda na yinti yina kitukaka nyoka. Ntangu yandi ke kuma, ");
INSERT INTO mkw_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","nge ke tuba na yandi: “Yave, Nzambi ya ba-Ebeleyo, me fidisa munu na kuzabisa nge ti bika bantu ya munu, samu ti ba kwenda sadila munu na yinsi ya kuyuma.” Kasi tii ntangu yayi, nge me manga na kuwa. ");
INSERT INTO mkw_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yave ke na kutuba: “kidimbu yayi mu ke na kusala ke lakisa nge ti mu kele Yave”. Munu, mu ke bula maza ya nzadi ya Nile na yinti yayi ke na munu na maboko, mpe maza ke kituka menga. ");
INSERT INTO mkw_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Bambisi ya maza ya Nile ke kufwa. Nzadi ke banda na kubasika nsunga ya yimbi. Bantu ya yinsi ya Ngipiti ke lenda dyaka ve na kunwa maza ya Nile.» ");
INSERT INTO mkw_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yave tubaka dyaka na Moyize: «Zonza na Aloni na kubaka yinti ya yandi, yandi kulambula yawu na kutalisa yawu na bamaza nyonso ya yinsi ya Ngipiti: bamwila, bamaza ya fyoti-fyoti, bizinga, bamaza nyonso ya Ngipiti. Maza nyonso ke kituka menga. Menga ke vwanda na yinsi nyonso ya Ngipiti tii na kati ya bitekolo yina ba yidikaka na yinti to na matadi.» ");
INSERT INTO mkw_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moyize na Aloni salaka mutindu Yave tumisaka bawu. Yandi lambulaka yinti mpe bulaka maza ya nzadi ya Nile, na mantwala ya Falawo, ntinu ya Ngipiti, mpe ya bantu yina ke salaka na Falawo, ntinu ya Ngipiti. Maza nyonso ya nzadi ya Nile kitukaka menga. ");
INSERT INTO mkw_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Bambisi yina vwandaka na nzadi ya Nile kufwaka. Nzadi ya Nile kumaka na nsunga ya yimbi. Bantu ya yinsi Ngipiti vwandaka lenda dyaka ve na kunwa maza ya nzadi. Yinsi nyonso ya Ngipiti vwandaka menga na menga. ");
INSERT INTO mkw_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kasi bantu ya bampandu ya Ngipiti mpe salaka mutindu mosi na bampandu ya bawu. Na yina, Falawo, ntinu ya Ngipiti, kangaka ntima ya yandi. Yandi mangaka na kutumama na Moyize mpe na Aloni. Yawu salamaka mutindu Yave tubaka. ");
INSERT INTO mkw_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Falawo, ntinu ya Ngipiti, pesaka bawu manima mpe yandi vutukaka na yinzo ya yandi, ata kutula ntima na mambu yina vwandaka me salama. ");
INSERT INTO mkw_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Bantu nyonso ya yinsi ya Ngipiti timunaka mabulu pene-pene ya nzadi ya Nile, samu na kuzwa maza ya kunwa, samu ti bawu vwandaka lenda dyaka ve na kunwa maza ya nzadi ya Nile. ");
INSERT INTO mkw_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Bilumbu nsambwadi ya muvimba lutaka, katuka ntangu yina Yave pesaka kitumbu yina na nzadi ya Nile. ");
INSERT INTO mkw_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Na manima ya mambu yina, Yave tubaka na Moyize: «Kwenda na sika ya Falawo, ntinu ya Ngipiti, mpe tuba na yandi: “Yave me tuba mutindu yayi: Bika ti bantu ya munu kukwenda, samu ti bawu kusadila munu. ");
INSERT INTO mkw_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Kana nge manga na kubika ba kwenda, munu, mu ke pesa yinsi ya nge nyonso kitumbu. Mu ke nokisa mvula ya bampangu. ");
INSERT INTO mkw_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Nzadi nyonso ya Nile ke fuluka na bampangu. Bampangu ke katuka na Nile na kwiza kota na yinzo ya nge. Yawu ke kota na kivinga yina nge ke lalaka. Yawu ke fuluka na zulu ya mfulu ya nge. Yawu ke kota mpe na bayinzo ya bantu yina ke salaka na nge. Yawu ke kota na bayinzo ya bantu ya nge. Yawu ke kota na kati ya bifuule tii na kati ya banzungu yina ba ke lambilaka. ");
INSERT INTO mkw_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Bampangu ke fuluka na zulu ya nge, na zulu ya bantu yina ke salaka na nge tii na zulu ya bantu ya nge nyonso.”» ");
INSERT INTO mkw_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yave tubaka dyaka na Moyize: «Zonza na Aloni: “baka yinti ya nge, lambula na kutalisa yawu na bamaza nyonso ya yinsi ya Ngipiti: bamwila, bamaza ya fyoti-fyoti na bizinga. Basisa bampangu samu ti yawu fuluka na yinsi nyonso ya Ngipiti.”» ");
INSERT INTO mkw_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aloni lambulaka diboko ya yandi na zulu ya bamaza nyonso ya yinsi ya Ngipiti. Bampangu basikaka mpe yawu fulukaka na yinsi nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kasi bantu ya bampandu mpe salaka mutindu mosi na bampandu ya bawu. Bawu basisaka bampangu na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ni na ntangu yina Falawo, ntinu ya Ngipiti, bokilaka Moyize na Aloni, mpe yandi zabisaka bawu: «Beno sambila Yave, yandi katula bampangu yayi na munu mpe na bantu ya munu. Na manima, mu ke bika bantu ya Isayeli, samu ti ba kwenda pesa Yave minkayulu.» ");
INSERT INTO mkw_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Moyize tubaka na Falawo, ntinu ya Ngipiti: «Mutindu nge zola, zabisa munu ntangu yina nge zola ti mu sambila Yave samu na nge, samu na bantu yina ke salaka na nge, mpe samu na bantu ya nge nyonso, samu ti yandi katula bampangu na sika ya nge mpe na bayinzo ya nge. Bampangu ke bikana kaka na kati ya nzadi ya Nile.» ");
INSERT INTO mkw_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Falawo, ntinu ya Ngipiti vutulaka: «Sala yawu mbasi». Moyize tubaka: «Bika ti yawu kusalama mutindu nge me tuba, samu ti nge zaba ti ya kele ve na muntu yina me fwanana na Yave, Nzambi ya beto. ");
INSERT INTO mkw_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Bampangu ke bika nge, yawu ke bika bayinzo ya nge. Yawu ke bika bantu yina ke salaka na nge. Yawu ke bika bantu ya nge nyonso. Bampangu ke bikana kaka na kati ya nzadi ya Nile.» ");
INSERT INTO mkw_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Moyize na Aloni basikaka na sika ya Falawo, ntinu ya Ngipiti. Moyize zangulaka ndinga na kusambila Yave, samu na bampangu yina Yave fidisaka samu na Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Yave salaka mutindu Moyize lombaka. Bampangu kufwaka na bayinzo, na bangaanda mpe na bilanga. ");
INSERT INTO mkw_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ba kutikisaka yawu na bikunku. Yinsi nyonso vwandaka basika nsunga ya yimbi. ");
INSERT INTO mkw_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kasi ntangu Falawo, ntinu ya Ngipiti, talaka ti mambu vwandaka me yilama, yandi kangaka dyaka ntima ya yandi. Yandi mangaka ya yandi na kutumama na Moyize mpe na Aloni. Yawu salamaka mutindu Yave tubaka. ");
INSERT INTO mkw_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Yave tubaka na Moyize: «Zonza na Aloni: “lambula yinti ya nge mpe bula fundu-fundu ya ntoto. Fundu-fundu ya ntoto ke kituka bangungu na yinsi nyonso ya Ngipiti”.» ");
INSERT INTO mkw_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Moyize na Aloni tumamaka. Aloni lambulaka diboko ya yandi mpe bulaka fundu-fundu ya ntoto na yinti ya yandi. Fundu-fundu ya ntoto kitukaka bangungu. Bangungu yango mwanganaka na zulu ya bantu mpe na zulu ya bibulu. Na yinsi nyonso ya Ngipiti, fundu-fundu nyonso ya ntoto kitukaka bangungu. ");
INSERT INTO mkw_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Bantu ya bampandu mekaka na kubasisa bangungu na bampandu ya bawu, kasi bawu lembanaka. Mutindu bangungu vwandaka na zulu ya bantu mpe na zulu ya bibulu, ");
INSERT INTO mkw_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","bantu ya bampandu tubaka na Falawo, ntinu ya Ngipiti: «Yayi kele lulendo ya Nzambi!» Kasi Falawo, ntinu ya Ngipiti, kangaka ntima ya yandi. Yandi tumamaka ve na Moyize na Aloni. Yawu salamaka mutindu Yave tubaka. ");
INSERT INTO mkw_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yave tubaka na Moyize: «Mbasi na suka-suka, nge ke telama na kukwenda na sika ya Falawo, ntinu ya Ngipiti, ntangu yina yandi ke basikaka na kukwenda na nzadi. Nge ke zabisa yandi ti Yave ke na kutuba mutindu yayi: “Bika bantu ya munu samu ti bawu sadila munu. ");
INSERT INTO mkw_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Kana nge bika ve ti bantu ya munu kwenda, mu ke fidisa nge banzinzi yina ke tatikaka. Mu ke fidisa yawu na bantu ya nge, na bantu yina ke salaka na nge tii na bayinzo ya nge. Bayinzo ya bantu ya yinsi ya Ngipiti ke fuluka na banzinzi yina ke tatikaka, mpe ntoto ya yinsi nyonso ke fuluka na yawu. ");
INSERT INTO mkw_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Kasi na kilumbu yango, mu ke pesa ve kitumbu yina na kizunga ya Ngosene, kisika yina kele bantu ya munu. Ata nzinzi mosi yina ke tatikaka ke vwanda kuna, samu nge ndima ti, munu Yave, mu kele na kati ya yinsi. ");
INSERT INTO mkw_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Mu ke kuula bantu ya munu na bampasi yina ke kumina bantu ya nge. Kimangu yayi ke salama mbasi.”» ");
INSERT INTO mkw_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yave salaka mutindu yina. Mukangu mosi ya banzinzi yina ke tatikaka kwizaka kota na yinzo ya Falawo, ntinu ya Ngipiti. Yawu kotaka na yinzo ya bantu yina ke salaka na Falawo mpe na kati ya yinsi nyonso ya Ngipiti. Yinsi nyonso bebaka mingi na banzinzi yina ke tatikaka. ");
INSERT INTO mkw_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Falawo, ntinu ya Ngipiti, bokilaka Moyize na Aloni mpe yandi tubaka na bawu: «Beno kwenda pesa Nzambi ya beno minkayulu, kasi beno sala yawu na yinsi yayi.» ");
INSERT INTO mkw_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Moyize vutulaka: «Ve, ya kele mbote ve, samu ti minkayulu yina beto ke pesa na Yave, Nzambi ya beto, kele nganzi samu na bantu ya Ngipiti. Kana beto pesa na meso ya bantu ya Ngipiti minkayulu yina bawu ke talaka ti yawu kele nganzi, bawu ke bula ve beto matadi? ");
INSERT INTO mkw_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Beto ke tambula bilumbu tatu na yinsi ya kuyuma mpe beto ke pesa minkayulu na Yave, Nzambi ya beto, na mutindu yina yandi ke zabisa beto yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Falawo, ntinu ya Ngipiti tubaka: «Mu ke bika ti beno kwenda na yinsi ya kuyuma, samu na kupesa Yave Nzambi ya beno minkayulu. Kasi beno kwenda ntama mingi ve. Beno sambila samu na munu.» ");
INSERT INTO mkw_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Moyize vutulaka: «Kaka na ntangu yina mu ke basika na yinzo ya nge, mu ke sambila Yave. Mbasi banzinzi yina ke tatikaka ke bika nge. Bawu ke bika bantu yina ke salaka na nge na bantu ya nge. Kasi kuvuna dyaka ve! Kumanga dyaka ve ti bantu ya Isayeli kwenda pesa Yave minkayulu.» ");
INSERT INTO mkw_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Na yina, Moyize basikaka na sika ya Falawo, ntinu ya Ngipiti, mpe yandi sambilaka Yave. ");
INSERT INTO mkw_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Yave salaka mutindu Moyize lombaka. Banzinzi yina ke tatikaka bikaka Falawo, ntinu ya Ngipiti. Yawu bikaka bantu yina ke salaka na yandi. Yawu bikaka bantu ya Falawo. Ata nzinzi mosi bikanaka. ");
INSERT INTO mkw_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Na mbala yayi mpe, Falawo, ntinu ya Ngipiti, kangaka dyaka ntima ya yandi. Yandi mangaka na kubika ti bantu ya Isayeli kukwenda. ");
INSERT INTO mkw_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Yave tubaka na Moyize: «Kwenda na sika ya Falawo mpe zabisa yandi ti, Yave Nzambi ya ba-Ebeleyo, ke na kutumisa nge mutindu yayi: “Bika bantu ya munu, samu ti ba kwenda sadila munu. ");
INSERT INTO mkw_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kana nge manga dyaka na kubika ti bawu kwenda, kana nge tatamana na kusimbidila bawu, ");
INSERT INTO mkw_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Yave ke balukila bibulu ya nge yina ke na kati ya matiti. Yandi ke balukila bampunda, bambuluku, basamo, bangombe, mameme na bankombo. Kiyoolo ya ngolo ke kuzwa bawu. ");
INSERT INTO mkw_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yave ke sala luswaswanu na yina me tadila bibulu ya bantu ya Isayeli, na bibulu ya bantu ya Ngipiti. Ata kibulu mosi ve ya bana nyonso ya Isayeli ke kufwa!”» ");
INSERT INTO mkw_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yave kubikaka ntangu yina yandi ke sadila mambu yina, ntangu yandi tubaka: «Mbasi, Yave ke sala dyambu yayi na yinsi.» ");
INSERT INTO mkw_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Mpe na kilumbu yina landaka, Yave salaka dyambu yango: Bibulu nyonso ya bantu ya Ngipiti kufwaka mpe ata kibulu mosi ve ya bana ya Isayeli kufwaka. ");
INSERT INTO mkw_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Falawo, ntinu ya Ngipiti, fidisaka bantu na kwenda kuzwa bansangu. Bawu zabisaka yandi ti ata kibulu mosi ve ya bana ya Isayeli kufwaka. Kasi Falawo, ntinu ya Ngipiti, kangaka dyaka ntima ya yandi. Yandi mangaka na kubika ti bantu ya Isayeli kukwenda. ");
INSERT INTO mkw_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yave tubaka na Moyize na Aloni: «Beno baka bombi na kati ya kifuule ya nene, beno fulusa maboko. Moyize ke losa yawu na zulu, na mantwala ya Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Bombi yango ke mwangana na yinsi nyonso ya Ngipiti mutindu fundu-fundu. Yawu ke basisa mawumbu yina ke buta bamputa ya mafinya na bantu mpe na bibulu, na yinsi nyonso ya Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Moyize na Aloni bakaka bombi ya kifuule. Bawu kwendaka telama na mantwala ya Falawo, ntinu ya Ngipiti. Moyize losaka bombi yango na zulu, mpe yawu basisaka mawumbu yina butaka bamputa ya mafinya na sika ya bantu mpe na bibulu. ");
INSERT INTO mkw_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Bantu ya bampandu lendaka ve na kwiza talana na mantwala ya Moyize samu na bamputa yina. Samu ti bawu mpe, bawu kuzwaka bamputa mutindu bantu nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kasi Yave salaka ti Falawo, ntinu ya Ngipiti, kukanga ntima ya yandi. Falawo, ntinu ya Ngipiti, tumamaka ve na Moyize na Aloni. Yawu salamaka mutindu Yave tubaka na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yave tubaka na Moyize: «Mbasi na suka-suka, nge ke telama na kukwenda na sika ya Falawo, ntinu ya Ngipiti. Nge ke zabisa yandi ti, Yave Nzambi ya ba-Ebeleyo, ke na kutuba mutindu yayi: “Bika bantu ya munu kukwenda samu na kusadila munu. ");
INSERT INTO mkw_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Samu ti na mbala yayi, mu ke fidisa bimbevo na bampasi ya konso mutindu. Mu ke fidisa yawu na nge mosi, na bantu yina ke salaka na nge, mpe na bantu ya nge, samu ti, nge zaba ti, ya kele ve na muntu yina me fwanana na munu na yinza nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kana mu lambulaka diboko ya munu samu na kufidisa beno kiyoolo, nge na bantu ya nge, beno zolaka zimbana na ntoto yayi. ");
INSERT INTO mkw_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Kasi kana mu me bika ti nge zinga dyaka, ya kele samu na kulakisa nge ngolo ya munu, mpe samu ti nkumbu ya munu kuzabakana na yinza nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Kana nge tatamana na kukanga bantu ya munu nzila, mpe nge bika ve ti bawu kwenda, ");
INSERT INTO mkw_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","mbasi, kaka na ngunga yayi, mu ke nokisa mvula ya ngolo ya matadi mutindu yawu me salamaka ntete ve na yinsi yayi ya Ngipiti, katuka mbandukulu ya yawu tii ntangu yayi. ");
INSERT INTO mkw_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ntangu yayi, baka bibulu ya nge na bima ya nge nyonso yina kele na matiti, bumbisa yawu na kisika ya mbote. Konso muntu to kibulu yina ke vwanda na bilanga, kana bawu vutuka ve na yinzo, mvula ya matadi ke bwidila bawu, mpe bawu ke kufwa.”» ");
INSERT INTO mkw_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Na kati ya bantu yina vwandaka sala na Falawo, ntinu ya Ngipiti, ya vwandaka na bayina talaka ti mambu ya Yave vwandaka ya mfunu. Bawu bumbisaka bisadi ya bawu mpe bibulu ya bawu na kati ya bayinzo. ");
INSERT INTO mkw_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Kasi bayina talaka ti mambu ya Yave vwandaka kaka mambu ya mpamba, bawu bikaka bisadi ya bawu mpe bibulu ya bawu na kati ya matiti. ");
INSERT INTO mkw_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yave tubaka na Moyize: «Nanguna diboko ya nge na zulu. Bika ti mvula ya matadi kunoka na yinsi nyonso ya Ngipiti. Bika ti yawu kunoka na zulu ya bantu, na zulu ya bibulu mpe na zulu ya bilanga nyonso ya yinsi ya Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moyize nangunaka yinti ya yandi na zulu. Yave wakisaka bidumu mpe yandi nokisaka mvula ya matadi. Banzasi vwandaka kubwa mingi na ntoto. Yave nokisaka mvula ya matadi na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mvula ya matadi nokaka na banzasi. Mvula ya nsisi ya mutindu yina me salamaka ntete ve na yinsi nyonso ya Ngipiti, kubanda ntangu yina Ngipiti kumaka yinsi. ");
INSERT INTO mkw_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Na yinsi nyonso ya Ngipiti, mvula ya matadi bebisaka bima nyonso yina vwandaka ve na kati ya babwala, ya vwanda bantu to bibulu. Mvula yango bebisaka bikuni mpe bayinti nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kaka ni na Ngosene, kisika yina vwandaka bana ya Isayeli mvula ya matadi nokaka ve. ");
INSERT INTO mkw_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Na yina, Falawo bokilaka Moyize na Aloni, yandi tubaka na bawu: «Na mbala yayi, mu me sala disumu. Ni Yave kele ya kudedama. Munu na bantu ya munu beto me sala yimbi. ");
INSERT INTO mkw_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Beno sambila Yave samu na kusukisa bidumu ya Nzambi na mvula ya matadi. Mu ke bika beno kwenda. Mu ke simbidila dyaka beno ve.» ");
INSERT INTO mkw_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moyize vutulaka: «Ntangu mu ke basika na mbanza, mu ke nanguna maboko na sika ya Yave. Bidumu ke dingama, mvula ya matadi ke manisa, samu ti, nge zaba ti, ntoto kele ya Yave. ");
INSERT INTO mkw_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Kasi mu zaba ti nge na bantu yina ke salaka na nge, beno ke banda ve na kuzitisaka Yave, Nzambi.» ");
INSERT INTO mkw_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Bikuni yina vwandaka me fula mpe yina vwandaka me basisa bambuma bebaka. ");
INSERT INTO mkw_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Kasi bikuni ya nkaka bebaka ve, samu ti bikuni yango vwandaka me fula ntete ve, mpe vwandaka me basisa ntete ve bambuma. ");
INSERT INTO mkw_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moyize basikaka na sika ya Falawo, ntinu ya Ngipiti, mpe na mbanza. Yandi nangunaka maboko na sika ya Yave. Bidumu dingamaka mpe mvula ya matadi manisaka. Mvula mpe bikaka na kunoka na yinsi. ");
INSERT INTO mkw_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ntangu Falawo, ntinu ya Ngipiti, talaka ti mvula bikaka na kunoka, bidumu dingamaka mpe mvula ya matadi manisaka, yandi tatamanaka na kusala masumu: Yandi kangaka ntima ya yandi, yandi na bantu yina ke salaka na yandi. ");
INSERT INTO mkw_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ntima ya Falawo, ntinu ya Ngipiti, vwandaka kaka ya kukangama. Yandi bikaka ve ti bana ya Isayeli kukwenda. Yawu salamaka mutindu Yave tubaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yave tubaka na Moyize: «Kwenda na sika ya Falawo, ntinu ya Ngipiti, samu ti ni munu kangaka ntima ya yandi, yandi na bantu yina ke salaka na yandi. Kwenda samu na kulakisa bimangu ya munu na kati-kati ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ya kele mpe samu ti nge zabisa na bana ya nge mpe na batekolo ya nge mutindu mu me sakinina bantu ya Ngipiti, mpe mutindu mu me lakisa bimangu ya munu na kati-kati ya bawu. Na yina, beno ke bakula ti mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moyize na Aloni kwendaka na sika ya Falawo, ntinu ya Ngipiti, mpe bawu tubaka na yandi: «Yave, Nzambi ya ba-Ebeleyo, me tuba mutindu yayi: “Tii wapi ntangu nge ke manga na kukuluka na mantwala ya munu? Bika ti bantu ya munu kukwenda, samu ti ba kwenda sadila munu. ");
INSERT INTO mkw_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kana nge manga ti bantu ya munu kukwenda, mbasi mu ke fidisa makonko na yinsi ya nge. ");
INSERT INTO mkw_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Yawu ke fuluka na yinsi tii ntoto nyonso ya yinsi ke talana dyaka ve. Yawu ke kudya nyonso yina bikanaka, nyonso yina mvula ya matadi bikaka. Yawu ke manisa na kudya makasa ya bayinti nyonso ya beno yina ke na kumena na bilanga. ");
INSERT INTO mkw_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Yawu ke fuluka na bayinzo ya nge. Yawu ke fuluka na bayinzo ya bantu nyonso yina ke salaka na nge. Yawu ke fuluka na bayinzo ya bantu nyonso ya Ngipiti. Batata ya nge na bankooko ya nge me talaka ntete ve dyambu ya mutindu yina, katuka ntangu yina ba kumaka na ntoto yayi tii na kilumbu ya bubu yayi.”» Moyize basikaka na yinzo ya Falawo, ntinu ya Ngipiti, mpe yandi vutukaka ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Bantu yina ke salaka na Falawo tubaka na Falawo, ntinu ya Ngipiti: «Tii wapi ntangu muntu yayi ke vwanda mutambu samu na beto? Bika ti bantu ya yandi ba kwenda. Bika ti ba kwenda sadila Yave, Nzambi ya bawu. Nabunu nge zaba ti Ngipiti ke na kufwa?» ");
INSERT INTO mkw_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Na yina, ba tumisaka Moyize na Aloni na kuvutuka na sika ya Falawo, ntinu ya Ngipiti. Falawo tubaka na bawu: «Beno kwenda! Beno sadila Yave, Nzambi ya beno. Kasi ni banani ke kwenda?» ");
INSERT INTO mkw_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moyize vutulaka: «Beto ke kwenda na bana ya beto, mpe na biboba ya beto. Beto ke kwenda na bana ya beto ya babakala mpe ya bakento, na Bibulu ya fyoti na ya nene, samu ti na beto, yawu kele mukembo samu na Yave.» ");
INSERT INTO mkw_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kasi Falawo, ntinu ya Ngipiti tubaka na bawu: «Kana mu bika beno kwenda na bana ya beno, bika ti Yave kuvwanda na beno! Beno ke na kutala ve beno mosi ti beno ke na mabanza ya yimbi? ");
INSERT INTO mkw_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Yawu ke salama mutindu yina ve! Kaka ni babakala ke kwenda. Beno kwenda sadila Yave, samu ti ni mutindu yina beno ke na kusosa.» Na manima, ba bingisaka bawu na ntwala ya Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yave tubaka na Moyize: «Lambula diboko ya nge na yinsi ya Ngipiti samu na kubokila makonko: Yawu kuvwanda na zulu ya yinsi ya Ngipiti! Yawu kudya matiti nyonso ya yinsi. Yawu kudya nyonso yina mvula ya matadi bikaka.» ");
INSERT INTO mkw_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moyize lambulaka yinti ya yandi na yinsi ya Ngipiti, mpe Yave fidisaka kitembo ya esete na yinsi, na kilumbu yina nyonso mpe na mpimpa nyonso. Na suka kitembo ya esete vwandaka me nata makonko. ");
INSERT INTO mkw_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Makonko mwanganaka na yinsi nyonso ya Ngipiti, mpe yawu vwandaka na bisika nyonso. Makonko ya mingi-mingi ya mutindu yina vwandaka me talana ntete ve, mpe yawu ke talana dyaka ve. ");
INSERT INTO mkw_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Makonko fukaka yinsi nyonso, mpe ntoto kumaka ndombe. Makonko kudyaka matiti nyonso ya yinsi, mpe bambuma nyonso ya bayinti yina bikanaka na manima ya mvula ya matadi. Ata dikasa mosi ve bikanaka dyaka na bayinti, mpe na bilanga ya yinsi nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Na yina, Falawo, ntinu ya Ngipiti, bokilaka Moyize na Aloni na nswalu nyonso. Yandi tubaka na bawu: «Mu me sala disumu na mantwala ya Yave, Nzambi ya beno, mpe na mantwala ya beno. ");
INSERT INTO mkw_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kasi beno lemvokila disumu ya munu mbala yayi dyaka. Beno sambila Yave, Nzambi ya beno, samu ti yandi katula kwandi munu kitembo yayi ya lufwa.» ");
INSERT INTO mkw_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moyize basikaka na yinzo ya Falawo, ntinu ya Ngipiti. Yandi sambilaka Yave. ");
INSERT INTO mkw_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Na yina, Yave telemisaka mupepe ya ngolo ya wesete. Mupepe yango nataka makonko, mpe losaka yawu na Mubu ya Batwandu. Ata dikonko mosi ve bikanaka na yinsi nyonso ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Kasi, Yave salaka ti Falawo, ntinu ya Ngipiti, kukanga dyaka ntima ya yandi. Falawo, ntinu ya Ngipiti, bikaka ve ti bana ya Isayeli kukwenda. ");
INSERT INTO mkw_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yave tubaka na Moyize: «Nanguna diboko ya nge na zulu. Bika ti kitombe kuvwanda na yinsi ya Ngipiti, kitombe mosi ya ngolo yina ba ke lenda ata fyoti ve na kutala kima!» ");
INSERT INTO mkw_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moyize nangunaka diboko ya yandi na zulu, mpe kitombe mosi ya ngolo kotaka na yinsi nyonso ya Ngipiti, bilumbu tatu ya muvimba. ");
INSERT INTO mkw_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Na bilumbu tatu yina, muntu lendaka tala mpangi muntu ve. Konso muntu vwandaka kaka na kisika yina yandi vwandaka. Kasi bana nyonso ya Isayeli vwandaka na nsemo na bisika yina bawu vwandaka zinga. ");
INSERT INTO mkw_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Na yina, Falawo, ntinu ya Ngipiti, bokilaka Moyize mpe yandi tubaka na yandi: «Beno kwenda! Beno sadila Yave. Kaka bangombe ya beno, na mameme mpe bankombo ya beno fwana kubikana. Kasi bana ya beno lenda kwenda na beno.» ");
INSERT INTO mkw_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moyize vutulaka: «Kana ya kele mutindu yina, ni nge ke pesa beto minkayulu ya kupesa na Yave Nzambi ya beto, na minkayulu ya kuyokila yandi? ");
INSERT INTO mkw_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Mukangu nyonso ya beto ya bibulu ke kwenda na beto, mpe ata kibulu mosi ve ke bikana! Samu ti ni na kati ya yawu beto ke baka bibulu ya kupesa minkayulu na Yave, Nzambi ya beto. Tekila beto kuma kuna, beto mosi, beto me zaba ntete ve yinki na kati ya bibulu yina, beto ke pesa na Yave, samu na kusadila yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kasi, Yave salaka ti Falawo, ntinu ya Ngipiti, kukanga ntima ya yandi. Falawo, ntinu ya Ngipiti, bikaka ve ti bawu kukwenda. ");
INSERT INTO mkw_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Falawo, ntinu ya Ngipiti, tubaka na Moyize: «Basika! Kumeka dyaka ve na kwiza talana na mantwala ya munu. Kilumbu yina nge ke kwiza talana dyaka na mantwala ya munu, nge ke kufwa!» ");
INSERT INTO mkw_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moyize vutulaka: «Kaka mutindu nge me tuba! Mu ke kwiza talana dyaka ve na mantwala ya nge!» ");
INSERT INTO mkw_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yave tubaka na Moyize: «Mu ke fidisa mpasi mosi ya mansukina na Falawo mpe na yinsi ya Ngipiti. Na manima, yandi ke bika ti beno kwenda. Ntangu yandi ke bika ti beno kwenda, ya ke vwanda kubingisa yandi ke bingisa beno ya mankululu na yinsi yayi. ");
INSERT INTO mkw_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Zonza na bantu ya Isayeli na kulomba bima ya wolo mpe ya palata na bantu ya Ngipiti. Bakala kulomba na mpangi ya yandi bakala, mpe kento kulomba na mpangi ya yandi kento.» ");
INSERT INTO mkw_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yave salaka ti bantu ya Isayeli kuzwa lusalusu ya bantu ya Ngipiti. Moyize yandi mosi vwandaka muntu ya nene na yinsi ya Ngipiti, na mantwala ya bantu yina vwandaka sala na Falawo, ntinu ya Ngipiti, mpe na mantwala ya bantu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moyize tubaka na Falawo, ntinu ya Ngipiti: «Yave me tuba mutindu yayi: “Na kati-kati ya mpimpa, mu ke luta na kati ya yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Bana nyonso ya ntete ya babakala ya yinsi ya Ngipiti ke kufwa, kubanda na mwana ya ntete ya Falawo, ntinu ya Ngipiti, yina ke ya kuvwanda na kiti ya yandi ya kintinu, tii na mwana ya ntete ya kento yina kele kisadi ya mpamba, yina ke salaka na kinikunu ya bambuma. Konso mwana ya ntete ya kibulu mpe ke kufwa. ");
INSERT INTO mkw_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Bidilu ya nene ke wakana na yinsi nyonso ya Ngipiti. Bidilu ya mutindu yina me wakanaka ntete ve, mpe yawu ke wakana dyaka ve. ");
INSERT INTO mkw_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Kasi na sika ya bana nyonso ya Isayeli, ata yimbwa ke lola ve samu na muntu to samu na kibulu. Na yina, beno ke zaba ti munu Yave, mu ke na kusala luswaswanu na yina me tadila Ngipiti na Isayeli.”» ");
INSERT INTO mkw_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Na yina, Moyize tatamanaka na kutuba: «Bantu nyonso yina ke salaka na nge ke kwiza, mpe bawu ke fukuma na mantwala ya munu. Bawu ke tuba: “Basika, nge na bantu ya nge nyonso yina ke na kulandaka nge.” Na manima kuna, mu ke basika.» Moyize basikaka na nkele nyonso na yinzo ya Falawo, ntinu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yave tubaka na Moyize: «Falawo, ntinu ya Ngipiti, ke tumama ve na beno, samu ti bimangu ya munu kuvwanda ya mingi na yinsi ya Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moyize na Aloni salaka bimangu nyonso yina na mantwala ya Falawo, ntinu ya Ngipiti. Kasi Yave kangaka ntima ya Falawo, ntinu ya Ngipiti. Falawo, ntinu ya Ngipiti, bikaka ve ti bana ya Isayeli ba basika na yinsi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yave tubaka na Moyize na Aloni na yinsi ya Ngipiti: ");
INSERT INTO mkw_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Ngonda yayi ke vwanda ngonda ya ntete samu na beno. Ni yawu beno ke tula na mbandukulu ya mvula. ");
INSERT INTO mkw_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Beno zonza na mukangu nyonso ya Isayeli mutindu yayi: Na kilumbu ya kumi ya ngonda yayi, konso dikanda ke baka dimeme to nkombo mosi na konso yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kana lutangu ya bantu ya dikanda kele fyoti samu na kudya kibulu mosi, bantu yango fwana kuvukana na bantu ya yinzo ya mpangi yina kele pene-pene, mutindu kele lutangu ya bantu ya kudikila. Beno ke soola kibulu ya kufwanana mutindu kele kitezo yina konso muntu lenda kudya. ");
INSERT INTO mkw_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Yawu ke vwanda kibulu ya mbakala yina kele ve na kifuma, yina kele na mvula mosi. Beno ke baka yawu na kati ya mameme to bankombo. ");
INSERT INTO mkw_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Beno ke tula yawu na lweka tii na kilumbu ya kumi na yiya ya ngonda yayi. Na kati ya mukangu nyonso ya Isayeli, ba ke zenga balaka ya bibulu yina, na nkokila, tekila ntangu kudyama. ");
INSERT INTO mkw_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Beno ke baka menga ya kibulu, beno ke kusa yawu na makunzi zole ya mwelo, mpe na dibaya ya zulu ya mwelo, na konso yinzo yina ba ke kudya kibulu. ");
INSERT INTO mkw_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Beno ke kudya mbisi yango na mpimpa yina. Beno ke kudya yawu ya kuyoka, na mampa yina kele ve na levule, mpe na ndunda ya ndudi. ");
INSERT INTO mkw_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Beno ke kudya ve mbisi ya nkunzu to yina ba me lambila na maza. Kasi kaka yina ba me yoka na tiya, na yintu nyonso, na makulu, mpe na bima yina kele na kati ya kivumu. ");
INSERT INTO mkw_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Beno ke bumba ata ndambu ve samu na kilumbu yina ke landa. Mbisi yina ke kuma tii na suka, beno ke yoka yawu. ");
INSERT INTO mkw_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Beno ke kudya yawu mutindu yayi: mukaba na luketo, mapapa na makulu, mpe yinti na maboko. Beno ke kudya yawu na mbangu nyonso. Yawu kele Paki ya Yave. ");
INSERT INTO mkw_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«Mu ke tambula na yinsi ya Ngipiti na mpimpa yina, mpe mu ke kufwa konso mwana ya ntete ya bakala ya yinsi ya Ngipiti, kubanda na bantu tii na bibulu. Mu ke fundisa binzambi-nzambi nyonso ya Ngipiti. Mu kele Yave. ");
INSERT INTO mkw_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Menga yina ke vwanda na myelo ya bayinzo ya beno ke vwanda kidimbu samu na beno. Ntangu mu ke tala menga, mu ke luta na zulu ya beno. Kitembo ya lufwa ke kuzwa beno ve ntangu mu ke semba yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«Kilumbu yina ke vwanda samu na beno kilumbu ya kubambuka moyo. Bantangu nyonso, na kilumbu yina, beno ke sala mukembo yayi samu na Yave. Yawu kele musiku ya bantangu nyonso samu na konso mbandu: beno ke sala mukembo yayi. ");
INSERT INTO mkw_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«Mpe dyaka, na bilumbu nsambwadi, beno ke kudya mampa yina ba me funisa ve. Katuka kilumbu ya ntete, beno ke katula levule na kati ya bayinzo ya beno. Samu ti kubanda na kilumbu ya ntete tii na kilumbu ya nsambwadi, konso muntu yina ke kudya dimpa yina ke na levule, ba ke katula yandi na mukangu ya bantu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Na kilumbu ya ntete, beno ke sala lukutakanu ya longo. Na kilumbu ya nsambwadi mpe, beno ke sala lukutakanu ya longo. Na bilumbu zole yina, beno ke sala ata kisalu mosi ve, kasi beno ke lamba kaka madya ya kitezo ya konso muntu. ");
INSERT INTO mkw_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Beno ke sala mukembo ya mampa yina kele ve na levule, samu na kubambuka moyo ya kilumbu yina mu basisaka mikangu ya beno na yinsi ya Ngipiti. Beno ke zitisa kilumbu yango na konso mbandu. Yawu kele musiku ya bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Na ngonda yango ya ntete, na nkokila ya kilumbu ya kumi na yiya, beno ke kudya mampa yina kele ve na levule tii na nkokila ya kilumbu ya makumi zole na mosi. ");
INSERT INTO mkw_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Na bilumbu nsambwadi, levule kuvwanda ve na bayinzo ya beno. Kana muntu me kudya kima yina ke na levule, ya vwanda nzenza to mu-Isayeli, ba fwana kukatula yandi na mukangu ya bantu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Beno kudya ata kima ve yina kele na levule. Bisika nyonso yina beno ke vwanda, beno kudya mampa yina ba me funisa ve.» ");
INSERT INTO mkw_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Na yina, Moyize bokilaka bakuluntu nyonso ya Isayeli, mpe yandi zonzaka na bawu: «Beno kwenda baka mameme to bankombo samu na makanda ya beno, mpe beno zenga bawu balaka samu na mukembo ya Paki. ");
INSERT INTO mkw_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Beno ke baka kintala ya mukwisa, mpe beno ke bondika yawu na kati ya menga ya kibulu yina kele na dibola. Beno kusa menga yango na dibaya ya zulu ya myelo, mpe na makunzi zole ya myelo ya kukotila. Ata muntu mosi ve kubasika na yinzo ya yandi tekila bwisi kutsya, ");
INSERT INTO mkw_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","samu ti Yave ke tambula na yinsi ya Ngipiti samu na kusemba yinsi ya Ngipiti. Yandi ke tala menga na dibaya ya zulu ya myelo, mpe na makunzi zole ya myelo. Na yina, yandi ke luta na zulu ya beno. Yandi ke bika ve ti mbazi yina ke pesaka lufwa kukota na bayinzo ya beno, samu na kutalisa beno mpasi. ");
INSERT INTO mkw_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Beno ke zitisa nyonso yina. Yawu kele ntumunu samu na nge, mpe samu na bana ya nge, bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ntangu beno ke kota na yinsi yina Yave ke pesa beno mutindu yandi zonzaka, beno fwana kusadilaka mukembo yayi. ");
INSERT INTO mkw_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ntangu bana ya beno ke yufula beno: “Yinki zola kutuba mukembo yayi beno ke na kusala?” ");
INSERT INTO mkw_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Beno ke vutula: “Yawu kele munkayulu ya Paki samu na Yave. Yandi lutaka na zulu ya bayinzo ya bana ya Isayeli kuna na yinsi ya Ngipiti. Ntangu yandi talisaka Ngipiti mpasi, yandi kuulaka bayinzo ya beto”.» Na yina, bana ya Isayeli fukamaka, mpe sambilaka. ");
INSERT INTO mkw_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Bawu telamaka mpe vutukaka. Bawu salaka mbote-mbote mutindu Yave tumisaka na Moyize mpe na Aloni. Ni mutindu yina bawu salaka. ");
INSERT INTO mkw_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Na kati-kati ya mpimpa, Yave salaka ti konso mwana ya ntete ya bakala ya yinsi ya Ngipiti kufwa, kubanda na mwana ya ntete ya bakala ya Falawo, ntinu ya Ngipiti, yina fwanaka vwanda na kiti ya kintinu, tii na mwana ya ntete ya bakala ya muntu yina kele ya kukangama na boloko, mpe na konso bana ya ntete ya bibulu. ");
INSERT INTO mkw_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Falawo, ntinu ya Ngipiti, telamaka na mpimpa yina, yandi na bantu yina ke salaka na yandi, na bantu nyonso ya Ngipiti. Bidilu ya nene wakanaka na yinsi ya Ngipiti samu ti ata yinzo mosi ve kondwaka mvumbi. ");
INSERT INTO mkw_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Kaka na mpimpa yina, yandi bokilaka Moyize na Aloni, mpe yandi tubaka: «Beno telama, beno basika na kati ya bantu ya munu, beno na bana ya Isayeli. Beno kwenda, beno kwenda sadila Yave mutindu beno zonzaka. ");
INSERT INTO mkw_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Beno baka mpe bangombe ya beno, mameme na bankombo ya beno mutindu beno zonzaka. Beno kwenda mpe beno lombila munu lusakumunu.» ");
INSERT INTO mkw_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Bantu ya yinsi ya Ngipiti vwandaka tumisa bantu ya Isayeli na kubasika na mbangu-mbangu, mpe na kubika yinsi ya bawu, samu ti bantu ya Ngipiti vwandaka zonza ti kana bawu basika ve, beto ke kufwa beto nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ni yawu yina, bantu ya Isayeli kuzwaka mpe ve ntangu ya kuvimbisa biputi ya mampa. Bawu bakaka mpe biyunga ya bawu samu na kukanga bipaki ya bawu, mpe bawu tulaka yawu na magembo. ");
INSERT INTO mkw_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Bana ya Isayeli salaka mutindu Moyize tubaka. Bawu lombaka na bantu ya Ngipiti bima ya wolo, bima ya palata, mpe na binkuti. ");
INSERT INTO mkw_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yave salaka ti bantu ya Isayeli kuzwa lusalusu ya bantu ya Ngipiti. Bantu ya Ngipiti pesaka bantu ya Isayeli nyonso yina ba lombaka. Ni mutindu yina bantu ya Isayeli bakaka bimvwama nyonso ya bantu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Bana ya Isayeli katukaka na mbanza Lamesese na kukwenda na mbanza Sukote. Lutangu ya bantu vwandaka keba ve mafunda bankama sambanu (600 000) ya babakala yina lendaka nwana na kwendaka tambula, kutanga ve bakento, na bana mpe biboba. ");
INSERT INTO mkw_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Bawu kwendaka mpe na bantu mingi ya bandinga ya nkaka. Bawu nataka bangombe, mameme na bankombo, yina salaka mukangu ya nene ya bibulu. ");
INSERT INTO mkw_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Bana ya Isayeli lambaka bagato yina vwandaka ve na levule na kiputi yina katukaka na bawu na Ngipiti, yina vwandaka ve ya kuvimba. Samu ti na ntangu ba bingisaka bawu na Ngipiti, bawu kuzwaka ve ntangu ya kukubika madya ya nzyetolo ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Lutangu ya bamvula yina bana ya Isayeli lutisaka na yinsi ya Ngipiti vwandaka bankama yiya na makumi tatu (430). ");
INSERT INTO mkw_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Na manima ya bamvula bankama yiya na makumi tatu (430), na kilumbu yina, mikangu nyonso ya dikanda ya Yave basikaka na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Yave salaka mpimpa ya muvimba na kubasisaka bawu na yinsi ya Ngipiti. Mpimpa yina kele mpimpa ya Yave. Yawu fwana kuvwanda mpe mpimpa ya kulala ve, samu na bana nyonso ya Isayeli, na bambandu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yave tubaka na Moyize na Aloni: «Beno tala, bansalulu ya kulanda samu na mukembo ya Paki ni yayi: Ata nzenza mosi ke kudya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mundongo yina ba me sumba na mbongo ke banda na kudya yawu kaka na manima ya kuzengisa bubakala ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ata nzenza mosi ve ya mwa ntangu to kisadi yina ba ke futaka lenda kudya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Beno kudya musuni na kati ya yinzo, mpe beno basisa yawu na ngaanda ve. Beno kubuka ve mikwa ya kibulu. ");
INSERT INTO mkw_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Mukangu nyonso ya Isayeli fwana kukembila mukembo yayi. ");
INSERT INTO mkw_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Kana nzenza yina ke vwandaka na yinzo ya nge zola kukembila Paki samu na Yave, bika ti babakala nyonso ya yinzo ya yandi kuzengisa ntete bubakala ya bawu. Na manima, yandi lenda sala mukembo yango. Yandi ke vwanda mutindu mwana ya Isayeli. Kasi ata muntu mosi ve yina ba me zenga ve bubakala lenda kudya yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","«Musiku ya mukembo yayi ke vwanda kaka mosi, samu na bana ya Isayeli mpe samu na banzenza yina ke zingaka na beno.» ");
INSERT INTO mkw_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Bana nyonso ya Isayeli salaka mutindu yina. Bawu salaka mbote-mbote mutindu Yave tumisaka na Moyize na Aloni na kusala. ");
INSERT INTO mkw_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ni na kilumbu yina, Yave basisaka bana ya Isayeli na yinsi ya Ngipiti, mutindu mukangu ya binwani. ");
INSERT INTO mkw_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yave tubaka dyaka na Moyize mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Byekila munu konso mwana ya ntete, ya vwanda na bantu to na bibulu. Konso mwana ya ntete yina ke butuka na kati ya bana ya Isayeli, yandi ke vwanda ya munu.» ");
INSERT INTO mkw_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moyize tubaka na bantu ya Isayeli: «Beno bambuka moyo na kilumbu yayi yina beno me basika na yinsi ya Ngipiti, yinsi yina beno vwandaka na bundongo. Samu ti Yave me sadila lulendo ya yandi na kubasisa beno kuna. Na kilumbu yango, beno ke kudya ve mampa yina ba me funisa. ");
INSERT INTO mkw_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Beno me basika bubu yayi, yawu kele kilumbu ya ngonda Abibe. ");
INSERT INTO mkw_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ntangu Yave ke kotisa beno na yinsi ya ba-Kaanani, ya ba-Yiti, ya ba-Amoli, ya ba-Yivi mpe ba-Yebuse, yinsi ya kufuluka na miliki na mafuta ya nyosi, yinsi yina Yave kudyaka ndefi na kupesa yawu na bankooko ya beno, beno ke sala mukembo yayi na ngonda yayi. ");
INSERT INTO mkw_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Bilumbu nsambwadi, beno ke kudya mampa yina kele ve na levule. Na kilumbu ya nsambwadi, ya ke vwanda mukembo samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Na bilumbu nsambwadi yina, beno ke kudya mampa yina kele ve na levule. Ata kima mosi ve yina ba me funisa fwana kutalana na sika ya beno, ata levule fwana kutalana na sika ya beno, na yinsi nyonso ya beno. ");
INSERT INTO mkw_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Na kilumbu yina, beno ke tuba na bana ya beno mutindu yayi: “Beto ke na kusala yawu samu na mambu yina Yave salaka samu na beto, na ntangu yina beto basikaka na Ngipiti.” ");
INSERT INTO mkw_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Kusala mukembo yayi ke vwanda mutindu kidimbu na zulu ya maboko ya beno mpe mutindu kinyemo na zulu ya bambunzu ya beno. Samu ti Musiku ya Yave kuvwanda na kati ya bayinwa ya beno. Samu ti Yave me sadila lulendo ya yandi na kubasisa beno na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Na konso mvula, beno ke zitisa bansalulu yayi na ntangu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Yave ke kotisa beno na yinsi ya ba-Kaanani mutindu yandi kudyaka ndefi na beno mpe na bankooko ya beno. Ntangu yandi ke pesa beno yawu, ");
INSERT INTO mkw_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","beno ke pesa na sika ya Yave konso mwana ya ntete ya mbakala yina ke butuka na mama ya yandi. Beno ke pesa mpe bana nyonso ya ntete ya mbakala ya bibulu: bawu nyonso kele ya Yave. ");
INSERT INTO mkw_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Beno ke yingisa konso mwana ya ntete ya mbakala ya mbuluku na dimeme to na nkombo. Kana beno yingisa yawu ve, beno ke mwangisa yawu dikosi. Konso mwana ya ntete yina me butuka na kati ya bantu ya beno, beno ke yingisa yandi. ");
INSERT INTO mkw_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Na bilumbu yina ke kwiza, kana bana ya beno yufula beno: “samu yinki beno ke na kusala yawu?” Beno ke vutula na bawu mutindu yayi: “ni Yave sadilaka lulendo ya yandi na kubasisa beto na Ngipiti, yinsi ya bundongo. ");
INSERT INTO mkw_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Mutindu Falawo, ntinu ya Ngipiti, vwandaka sala yintu ngolo na kubika beto, Yave kufwaka konso mwana ya ntete ya yinsi ya Ngipiti, kubanda na bantu tii na bibulu. Ni yawu yina, beto ke pesaka munkayulu na Yave, konso mwana ya ntete ya mbakala ya kibulu, mpe beto ke kuulaka bana ya beto ya ntete ya babakala.” ");
INSERT INTO mkw_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Bansalulu yayi ke vwanda mutindu kidimbu na zulu ya maboko ya beno. Yawu ke vwanda mutindu kinyemo na zulu ya bambunzu ya beno. Samu ti Yave me sadila lulendo ya yandi na kubasisa beno na Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ntangu Falawo, ntinu ya Ngipiti, bikaka bantu ya Isayeli ba kwenda, Nzambi natinaka bawu ve na nzila ya yinsi ya ba-Filiseti, ata ti ni yawu lutilaka nkufi. Nzambi tubaka: «Ya kele mbote ve ti bantu ya Isayeli kutala boma ya bamvita mpe ti bawu sosa na kuvutuka na Ngipiti!» ");
INSERT INTO mkw_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ni yawu yina, Nzambi nataka bantu ya Isayeli na nzila ya yinsi ya kuyuma yina ke talisaka na Mubu ya batwandu. Bantu ya Isayeli basikaka na Ngipiti mutindu mukangu ya binwani. ");
INSERT INTO mkw_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ntangu bawu basikaka, Moyize bakaka mikwa ya Yosefi, samu ti Yosefi tumisaka bana ya Isayeli na kudya ndefi, yandi tubaka na bawu: «Nzambi ke sadisa beno. Beno kudya ndefi ti beno ke katula mikwa ya munu kwaku, mpe beno ke kwenda na yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Bawu katukaka na mbanza Sukote, mpe bawu kwendaka vwanda na mbanza Etame, na ndilu ya yinsi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yave yandi mosi vwandaka tambula na mantwala ya bawu. Na ntangu, na dituti ya nene ya kutelama, samu na kunataka bawu. Na mpimpa, na mulaka ya tiya ya kutelama, samu na kukyenzulaka bawu, samu ti bawu kutambula mpimpa na ntangu. ");
INSERT INTO mkw_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Na ntangu, dituti ya nene ya kutelama vwandaka katuka ve na mantwala ya bantu ya Isayeli, mutindu mosi mpe na mpimpa, samu na mulaka ya tiya ya kutelama. ");
INSERT INTO mkw_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yave tubaka na Moyize mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Zonza na bana ya Isayeli ba vutuka mpe ba kwiza sala kivwandu ya bawu na mantwala ya kisika ya nkumbu Pi-Ayilote, na kizunga yina kele na kati-kati, katuka bwala Mingedole tii na mubu. Ya kele na mantwala ya bwala Baale-Sefone, mbombo na mbombo na bwala yina. Ni na kisika yina beno ke sala kivwandu ya beno, pene-pene ya mubu. ");
INSERT INTO mkw_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Falawo, ntinu ya Ngipiti, ke zonza mutindu yayi samu na bana ya Isayeli: “Bantu yayi ke na kuyenga-yenga na yinsi. Yinsi ya kuyuma me zungidila bawu!” ");
INSERT INTO mkw_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Mu ke kanga ntima ya Falawo, ntinu ya Ngipiti. Yandi ke landa bana ya Isayeli. Samu na Falawo, ntinu ya Ngipiti, na binwani ya yandi nyonso, mu ke lakisa bunene ya munu. Na yina, bantu ya Ngipiti ke zaba ti mu kele Yave.» Bana ya Isayeli salaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ba zabisaka na Falawo, ntinu ya Ngipiti, ti bantu ya Isayeli kimaka. Na yina, Falawo na bisadi ya yandi sobaka mabanza samu na bantu ya Isayeli. Bawu tubaka: «Yayi yinki beto me sala? Beto me bika ti bantu ya Isayeli kukwenda mpe kubika bisalu yina ba vwandaka sadila beto!» ");
INSERT INTO mkw_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Falawo, ntinu ya Ngipiti, kubikaka kipusu-pusu ya yandi ya mvita, mpe yandi kwendaka kintwadi na binwani ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Yandi bakaka bankama sambanu (600) ya bapusu-pusu ya mvita ya kulutila mbote, na bapusu-pusu nyonso ya nkaka ya mvita ya yinsi ya Ngipiti. Bantu tatu-tatu vwandaka na kati ya konso kipusu-pusu ya mvita. ");
INSERT INTO mkw_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yave kangaka ntima ya Falawo, ntinu ya Ngipiti. Falawo, ntinu ya Ngipiti, landaka bana ya Isayeli yina vwandaka me basika na kimpwanza nyonso na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Bantu ya Ngipiti landaka bana ya Isayeli. Bampunda nyonso, bapusu-pusu ya mvita ya Falawo, na bayina ke kwendaka na kati ya yawu, na binwani nyonso, bawu belamaka na bana ya Isayeli. Bana ya Isayeli vwandaka pene-pene ya mubu, ntama mingi ve na kisika ya nkumbu Pi-Ayilote, mbombo na mbombo na bwala Baale-Sefone. ");
INSERT INTO mkw_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Falawo, ntinu ya Ngipiti, kumaka pene-pene. Bana ya Isayeli vumbulaka meso, mpe bawu talaka ti bantu ya Ngipiti vwandaka landa bawu na manima. Na yina, bawu kuzwaka boma mingi. Bana ya Isayeli lookaka na sika ya Yave. ");
INSERT INTO mkw_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Bawu tubaka na Moyize: «Na Ngipiti bandyamu vwandaka ve, samu ti nge nata beto na kwiza kufwa na yinsi ya kuyuma yayi? Yayi yinki nge me sala beto na kubasisa beto na yinsi ya Ngipiti? ");
INSERT INTO mkw_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Beto tubilaka nge yawu mbote-mbote na Ngipiti ti bika beto, beto sadila ya beto bantu ya Ngipiti! Samu ti na beto, kusadila bantu ya Ngipiti me lutila mbote na kukwiza kufwa na yinsi ya kuyuma.» ");
INSERT INTO mkw_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moyize zonzaka na bantu ya Isayeli mutindu yayi: «Beno vwanda na boma ve. Beno telama, beno tala mutindu Yave ke kuula beno bubu yayi, samu ti bantu ya Ngipiti yina beno ke na kutala bubu yayi, beno ke tala dyaka bawu ata fyoti ve. ");
INSERT INTO mkw_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yave ke nwanina beno. Beno, beno vwanda kaka swii.» ");
INSERT INTO mkw_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yave tubaka na Moyize: «Samu na yinki nge ke na lookaka na sika ya munu? Zonza na bana ya Isayeli na kukwenda. ");
INSERT INTO mkw_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Kasi nge, nanguna yinti ya nge, lambula diboko ya nge na zulu ya mubu, mpe kabula yawu. Bana ya Isayeli ke tambula na ntoto ya kuyuma na kati-kati ya mubu. ");
INSERT INTO mkw_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Munu, mu ke kanga bantima ya bantu ya Ngipiti, samu ti bawu landa bana ya Isayeli. Samu na Falawo, ntinu ya Ngipiti, na binwani ya yandi nyonso, na bapusu-pusu ya yandi ya mvita, na bayina ke kwendaka na kati ya yawu, mu ke lakisa bunene ya munu. ");
INSERT INTO mkw_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Na yina, ntangu mu ke lakisa bunene ya munu samu na Falawo, ntinu ya Ngipiti, na bapusu-pusu ya yandi ya mvita, na bayina ke kwendaka na kati ya yawu, bantu ya Ngipiti ke zaba ti mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Na yina, mbazi ya Nzambi yina vwandaka tambula na mantwala ya bana ya Isayeli lutaka na manima ya bawu. Dituti ya nene ya kutelama mpe katukaka na mantwala ya bawu mpe yawu lutaka na manima. ");
INSERT INTO mkw_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Yawu kwizaka telama na kati-kati ya bantu ya Ngipiti na bana ya Isayeli. Yawu tulaka kitombe na lweka ya bantu ya Ngipiti, kasi yawu vwandaka kyenzula lweka ya bana ya Isayeli. Ni yawu yina, na mpimpa nyonso, bantu ya lweka yayi lendaka belama ve na lweka ya kaka. ");
INSERT INTO mkw_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Na yina, Moyize lambulaka diboko ya yandi na zulu ya mubu. Yave fulaka mupepe ya ngolo na mubu mpimpa ya muvimba. Mupepe yango katukaka na esete. Maza kabukaka na bandambu zole, mpe mubu kumaka ya kuyuma na kati-kati. ");
INSERT INTO mkw_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Bana ya Isayeli kotaka na nzila ya kuyuma na kati-kati ya mubu. Na lubakala mpe na lumoso, maza kumaka mutindu bibaka. ");
INSERT INTO mkw_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Bantu ya Ngipiti bandaka na kulanda bana ya Isayeli. Bampunda nyonso ya Falawo, ntinu ya Ngipiti, na bapusu-pusu ya yandi ya mvita, mpe bayina ke kwendaka na kati ya yawu, bawu kotaka na kati-kati ya mubu, na manima ya bana ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Na suka-suka, ntangu mwa mpimpa vwandaka ntete, Yave talaka bantu ya Ngipiti katuka dituti ya nene, ya kutelama, mpe na mulaka ya tiya ya kutelama. Yandi tulaka mvwanzi na kati ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Yave kangaka makalu ya bapusu-pusu ya bawu, mpe bapusu-pusu yango kumaka mpasi na bawu na kunata. Na yina, bantu ya Ngipiti tubaka: «Beto kima bana ya Isayeli! Ni Yave ke na kunwanisa Ngipiti samu na bawu!» ");
INSERT INTO mkw_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yave tubaka na Moyize: «Lambula diboko ya nge na zulu ya mubu, samu ti maza kuvutukila bantu ya Ngipiti, na bapusu-pusu ya bawu ya mvita, mpe na bayina ke kwendaka na kati ya yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moyize lambulaka diboko ya yandi na zulu ya mubu. Na suka-suka, mubu vutukaka na kisika yina yawu ke vwandaka. Bantu ya Ngipiti vwandaka kima na kubwabana yawu, kasi Yave dyamisaka bawu na kati ya mubu. ");
INSERT INTO mkw_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Maza vutukaka, yawu fukaka bapusu-pusu ya mvita, na bayina ke kwendaka na kati ya yawu, na binwani nyonso ya Falawo, ntinu ya Ngipiti, bayina vwandaka landa bana ya Isayeli na kati ya mubu. Ata muntu mosi vuukaka. ");
INSERT INTO mkw_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Kasi bana ya Isayeli vwandaka me luta na nzila ya kuyuma na kati-kati ya mubu. Na lubakala mpe na lumoso, maza kumaka mutindu bibaka. ");
INSERT INTO mkw_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Kilumbu yina, Yave kuulaka Isayeli na maboko ya bantu ya Ngipiti. Bantu ya Isayeli talaka bantu ya Ngipiti ya kufwa na kumu ya mubu. ");
INSERT INTO mkw_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Bantu ya Isayeli talaka lulendo yina Yave lakisaka na mantwala ya yinsi ya Ngipiti, mpe bawu zitisaka Yave. Bawu tulaka kiminu ya bawu na Yave, mpe na kisadi ya yandi Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Moyize na bana ya Isayeli yimbilaka Yave mukunga. Mu ke yimbila samu na Yave. Yandi me lakisa bunene ya yandi. Bampunda mpe bayina ke nataka yawu, yandi me losa bawu na mubu. ");
INSERT INTO mkw_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ngolo ya munu ni Yave, ni yandi mu ke yimbidila. Yandi me vuukisa munu. Yandi kele Nzambi ya munu, mu ke kembila yandi. Yandi kele Nzambi ya tata ya munu, mu ke zangula yandi. ");
INSERT INTO mkw_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yave kele muntu ya bamvita, Yave ni nkumbu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Bapusu-pusu ya mvita ya Falawo, binwani ya yandi nyonso, yandi me losa bawu na mubu. Binwani ya yandi ya ngolo, yandi me dyamisa bawu na mubu, na Mubu ya Batwandu. ");
INSERT INTO mkw_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Maza ya nene me fuka bawu. Bawu me dyama mutindu matadi. Bawu me kulumuka tii na yisi. ");
INSERT INTO mkw_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yave, diboko ya nge ya lubakala kele ya lulendo. Yave, diboko ya nge ya lubakala me nika mbeni. ");
INSERT INTO mkw_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Na bunene ya nge ya kulutila nge ke nungaka mitantu ya nge. Nge ke fungulaka tiya ya nkele ya nge, yawu ke nyengisaka bawu mutindu nyanga. ");
INSERT INTO mkw_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Na ngolo ya mupepe ya nge, maza me vukana kisika mosi. Bimpo ya maza me kuma mutindu bibaka. Maza me kuba na kati-kati ya mubu. ");
INSERT INTO mkw_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mbeni tubaka: «Mu ke landa bawu, mu ke kuzwa bawu, mu ke kuzwa kimvwama ya bawu mu ke fuluka na yawu. Mu ke baka mbele ya mvita, mu ke bwila bawu.» ");
INSERT INTO mkw_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nge fulaka mupepe ya nge, mubu fukaka bawu. Bawu dyamaka mutindu kisengo, mutindu kokote na kati ya maza ya nene. ");
INSERT INTO mkw_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Nani na kati ya binzambi-nzambi kele mutindu nge, Yave? Nani kele ya kulezima na bulongo mutindu nge? Nge yina kele ya nsisi, nge yina me lunga na kuzwa masiika, nge yina ke salaka mambu ya ngitukulu? ");
INSERT INTO mkw_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nge me lambula diboko ya nge ya lubakala, ntoto me mina mitantu ya beto. ");
INSERT INTO mkw_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Na kukwikama nyonso, nge me twadisa bantu, bantu yina nge me kuula. Na lulendo ya nge, nge me twadisa bawu, tii na kisika ya nge ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Bantu ya bayinsi ya nkaka me kuwa. Bawu me kuwa nsangu ya dyambu yayi, bawu me tekita. Boma ya kulutila simbaka bantu yina ke zingaka na Filiseti. ");
INSERT INTO mkw_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Bamfumu ya Edome me kufwa na boma. Binwani ya Mowabe me kufwa na kutekita. Ba-Kaanani ke dyaka ve na ngolo. ");
INSERT INTO mkw_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Boma mpe nsisi me kuzwa bawu. Yave, na mantwala ya lulendo ya diboko ya nge, bawu me kuma mababa mutindu matadi, tii na ntangu yina bantu ya nge me manisa na kuluta, bayina me kuma bantu ya nge. ");
INSERT INTO mkw_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nge ke nata bawu, nge ke tula bawu na mongo, mongo yina kele mvwilu ya nge, kisika yina nge Yave nge kubikaka na kuzinga. Yinzo ya longo yina maboko ya nge, nge Mfumu, ke yidika. ");
INSERT INTO mkw_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yave, nge ke yalaka seko, nge ke yalaka bantangu nyonso! ");
INSERT INTO mkw_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ntangu bampunda ya Falawo, ntinu ya Ngipiti, bapusu-pusu ya yandi ya mvita na bayina ke kwendaka na kati ya yawu, bawu kotaka na mubu, Yave vutulaka maza ya mubu na zulu ya bawu. Kasi bana ya Isayeli vwandaka me tambula na ntoto ya kuyuma na kati-kati ya mubu. ");
INSERT INTO mkw_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Mumbikudi Milyame, kibusi ya Aloni bakaka ngoma ya fyoti. Yandi vwandaka sika ngoma mpe vwandaka bina. Bakento nyonso salaka mutindu yandi. ");
INSERT INTO mkw_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Na kati ya mukunga, Milyame vutulaka na bawu mutindu yayi: Beno yimbila samu na Yave. Yandi me lakisa bunene ya yandi. Bampunda mpe bayina ke nataka yawu, yandi me losa bawu na mubu. ");
INSERT INTO mkw_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moyize twadisaka bantu ya Isayeli. Bawu katukaka na Mubu ya Batwandu mpe bawu bakaka nzila yina ke kwendaka na yinsi ya kuyuma yina ba ke bokilaka Sule. Bawu tambulaka bilumbu tatu na yinsi ya kuyuma ata kutala maza. ");
INSERT INTO mkw_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Bawu kumaka na Mala, kisika mosi yina vwandaka na maza. Kasi bawu lendaka ve na kunwa maza yango, samu ti yawu vwandaka ndudi. Ni yawu yina, ba ke bokilaka yawu Mala. Yawu zola kutuba: «Ndudi.» ");
INSERT INTO mkw_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Bantu ya Isayeli bandaka na kuvunguta. Bawu yufulaka Moyize: «Yinki kwandi beto ke kunwa?» ");
INSERT INTO mkw_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moyize sambilaka Yave mpe Yave lakisaka yandi yinti mosi. Moyize bakaka yinti yango, yandi losaka yawu na maza mpe maza kumaka ya mbote. Ni kuna Yave pesaka bawu bandongosolo mpe bansalulu ya misiku. Ni kuna mpe yandi mekaka bawu. ");
INSERT INTO mkw_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Yandi tubaka: «Kana beno tumama na ndinga ya Yave, Nzambi ya beno, kana beno sadila ludedomo na meso ya yandi, kana beno tula dikutu ya beno na kuwa misiku, kana beno zitisa bansalulu ya misiku ya yandi, mu ke fidisa beno ve ata kimbemvo mosi na bimbemvo yina mu fidisaka na bantu ya Ngipiti, samu ti ni munu Yave ke nyakisaka beno.» ");
INSERT INTO mkw_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Na manima, bantu ya Isayeli kumaka na kisika yina ba ke bokilaka Elime. Ya vwandaka kuna na bamwila kumi na zole mpe makumi nsambwadi ya maba. Ni kuna bantu ya Isayeli salaka kivwandu ya bawu, pene-pene ya maza. ");
INSERT INTO mkw_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Mukangu nyonso ya bana ya Isayeli bikaka Elime. Bawu kwendaka na yinsi ya kuyuma yina ba ke bokilaka Sine. Sine kele na kati-kati ya Elime na Sinayi. Ya vwandaka na kilumbu ya kumi na tanu, na ngonda ya zole katuka kilumbu yina bawu basikaka na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Kuna na yinsi ya kuyuma, mukangu nyonso ya bana ya Isayeli bandaka na kuvungutila Moyize na Aloni. ");
INSERT INTO mkw_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Bana ya Isayeli zonzaka na bawu: «Samu na yinki Yave kufwaka kwandi beto ve na yinsi ya Ngipiti! Kuna beto vwandaka vukana pene-pene ya banzungu ya ngombe mpe beto vwandaka yukuta na kudya mampa! Beno me basisa beto na kunata beto na yinsi ya kuyuma, samu na kufwa mukangu nyonso yayi na nsatu!» ");
INSERT INTO mkw_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yave tubaka na Moyize: «Katuka na zulu, mu ke nokisa mvula ya mampa samu na beno. Konso kilumbu bantu ke banda na kwendaka lokota mampa yina me lunga na kudya na kilumbu. Ni mutindu yina mu ke meka bawu. Mu ke tala kana bawu ke tumama na misiku ya munu to bawu ke tumama ve? ");
INSERT INTO mkw_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Na kilumbu ya sambanu, ntangu ba ke lamba yina ba me lokota na kilumbu yina, yawu ke vwanda kikunku ya kulutila bambala zole na yina ba ke lokotaka konso kilumbu.» ");
INSERT INTO mkw_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Na yina, Moyize na Aloni tubaka na bana nyonso ya Isayeli: «Na nkokila yayi, beno ke zaba ti ni Yave me basisa beno na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Mbasi na suka, beno ke tala nkembo ya Yave. Yandi me kuwa kuvunguta yina beno ke na kuvungutila Yave, samu ti beto, beto kele banani, samu ti beno vungutila beto?» ");
INSERT INTO mkw_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moyize tubaka: «Yave ke pesa beno mbisi ya kudya na nkokila. Yandi ke pesa beno mpe mampa ya kudya mpe ya kuyukuta na suka. Samu ti Yave me kuwa kuvunguta yina beno ke na kuvungutila yandi. Beto, beto kele banani, samu ti beno kuvungutila beto? Ya tsyelika, ni beto ve beno ke na kuvungutila, kasi ni Yave beno ke na kuvungutila.» ");
INSERT INTO mkw_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moyize tubaka na Aloni: «Zonza na mukangu nyonso ya bana ya Isayeli: “Beno belama na mantwala ya Yave. Samu ti yandi me kuwa kuvunguta ya beno.”» ");
INSERT INTO mkw_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ntangu Aloni vwandaka zonza na mukangu nyonso ya bana ya Isayeli, bawu balukaka na kutala na lweka ya yinsi ya kuyuma. Na mpamukunu, nkembo ya Yave talanaka na kati ya dituti. ");
INSERT INTO mkw_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yave zonzaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Mu me kuwa kuvunguta yina bana ya Isayeli ke na kuvungutila munu. Tuba na bawu: “Na nkokila yayi beno ke kudya mbisi. Mbasi na suka, beno ke yukuta na kudya mampa. Beno ke zaba ti mu kele Yave, Nzambi ya beno.”» ");
INSERT INTO mkw_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Kaka na nkokila yina, bandeke kwizaka kuna. Yawu fulusaka kisika nyonso yina bantu ya Isayeli yidikaka kivwandulu ya bawu. Na suka mpe, kinoko vwandaka na balweka nyonso ya kivwandu yina. ");
INSERT INTO mkw_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ntangu kinoko yina katukaka, na ntoto ya yinsi ya kuyuma talanaka bima mosi yina vwandaka mutindu mwa bambuma ya fyoti-fyoti mutindu maza ya mpembe. ");
INSERT INTO mkw_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Bana ya Isayeli talaka yawu mpe bawu yufulaka bawu na bawu: «Yayi kele yinki?» Bawu yufulaka mutindu yina samu ti bawu vwandaka zaba ve yinki ya vwandaka. Moyize tubaka na bawu: «Ya kele mampa yina Yave me pesa beno na kudya. ");
INSERT INTO mkw_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Beno tala yinki Yave me tumisa: “Konso muntu kulokota yina yandi lenda kudya. Ya ke vwanda Womele mosi na muntu mosi. Konso muntu ke baka yina me fwanana, samu na lutangu ya bantu nyonso yina kele na yinzo ya yandi.”» ");
INSERT INTO mkw_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Bana ya Isayeli salaka mutindu yina. Ba ya nkaka lokotaka mingi, ba ya nkaka lokotaka ndambu. ");
INSERT INTO mkw_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ntangu ba tezaka bikunku na Womele, ba talaka ti bayina vwandaka na mingi bakaka ve ya kulutila mpe bayina bakaka ndambu vwandaka kondwa kima ve. Konso muntu bakaka yina lungaka na kudya. ");
INSERT INTO mkw_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moyize zabisaka bawu: «Mane yayi, ata muntu ke bumba yawu tii na suka.» ");
INSERT INTO mkw_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Bantu ya nkaka wilaka ve Moyize. Bawu bumbaka yawu tii na suka. Mpe yawu butaka bantunga, yawu bandaka na kubasika nsunga. Na yina, Moyize dasukilaka bawu. ");
INSERT INTO mkw_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Konso suka bawu vwandaka lokota yawu. Konso muntu vwandaka lokota yina yandi lendaka kudya na kilumbu. Kasi ntangu ntangu vwandaka kuma ngolo, yawu vwandaka sulumuka. ");
INSERT INTO mkw_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Na kilumbu ya sambanu, bawu lokotaka keba ve Bawomele zole na muntu, kikunku ya kulutila bambala zole na kikunku yina ba ke lokotaka konso kilumbu. Bamfumu nyonso ya mukangu kwendaka zabisa yawu na sika ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Yandi zabisaka bawu: «Ni mutindu yina Yave tumisaka na kusala. Mbasi ke vwanda saba, kilumbu yina kele ya kubyekwa samu na Yave. Beno lamba yina beno ke lamba. Beno tokisa yina beno ke tokisa. Ya nkaka yina ke bikana, beno bumba yawu tii mbasi na suka.» ");
INSERT INTO mkw_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Bawu bumbaka yina bikanaka tii na suka mutindu moyize tumisaka. Na mbala yayi, yawu basisaka ve bantunga, mpe yawu basikaka ve nsunga ya yimbi. ");
INSERT INTO mkw_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moyize tubaka: «Beno kudya yawu bubu yayi, samu ti kilumbu ya bubu yayi kele Saba ya Yave. Bubu yayi beno ke tala ve yawu kuna na ngaanda ya kivwandu. ");
INSERT INTO mkw_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Beno ke lokota yawu na kati ya bilumbu sambanu, kasi kilumbu ya nsambwadi ya kele saba, kilumbu ya kupema. Mane ke vwanda ve.» ");
INSERT INTO mkw_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Na kilumbu yango ya nsambwadi, ya vwandaka na bantu ya nkaka na kati ya bantu ya Isayeli, bayina basikaka samu na kulokota mane, kasi bawu kuzwaka yawu ve. ");
INSERT INTO mkw_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yave tubaka na Moyize: «Tii wapi ntangu beno ke manga na kutumama na bantumunu ya munu mpe na misiku ya munu? ");
INSERT INTO mkw_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Beno fwana zaba ti Yave me pesa beno saba. Ni yawu yina, na kilumbu ya sambanu, yandi ke na kupesa beno madya ya bilumbu zole. Na yina, beno vwanda konso muntu na kisika ya yandi. Ata muntu kubasika ve na yinzo ya yandi na kilumbu ya nsambwadi.» ");
INSERT INTO mkw_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Na yina, bantu ya Isayeli pemaka na kilumbu ya nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Bantu ya Isayeli pesaka madya yina nkumbu ya mane. Yawu vwandaka mutindu mbuma ya koleyande. Yawu vwandaka mpembe mpe kitoko na kudya mutindu bima yina ba me lamba na mafuta ya nyosi. ");
INSERT INTO mkw_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moyize tubaka: «beno tala yinki Yave me tumisa: “ba bumba Womele mosi ya mane samu na bambandu yina ke kwiza na manima ya beno. Bawu mpe, bawu ke tala mampa yina mu me pesa beno na kudya na yinsi ya kuyuma, na ntangu yina mu me basisa beno na yinsi ya Ngipiti.”» ");
INSERT INTO mkw_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moyize tubaka na Aloni: «Baka diyuki. Tula Womele mosi ya mane na kati, mpe tula yawu na mantwala ya Yave. Ba ke bumba yawu samu na bambandu yina ke kwiza na manima ya beto.» ");
INSERT INTO mkw_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Mutindu Yave tumisaka yawu na Moyize, Aloni kwendaka tula diyuki yango na mantwala ya matadi ya ngwisani, samu na kubumba yawu. ");
INSERT INTO mkw_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Bana ya Isayeli salaka bamvula makumi yiya na kudyaka mane tii na ntangu yina bawu kumaka na yinsi yina vwandaka zinga bantu. Bawu vwandaka kudya mane tii na ntangu yina bawu kumaka na ndilu ya yinsi ya Kaana. ");
INSERT INTO mkw_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Womele kele kikunku mosi na kati ya bikunku kumi ya Efa. ");
INSERT INTO mkw_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Mukangu nyonso ya bana ya Isayeli katukaka na yinsi ya kuyuma yina ba ke bokilaka Sine. Bawu vwandaka kwenda luta kisika na kisika tii bawu kwendaka sala kivwandu ya bawu na kisika yina ba ke bokilaka Lefidime, mutindu Yave tumisaka bawu. Kasi maza ya kunwa vwandaka ve kuna. ");
INSERT INTO mkw_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Na yina, bantu ya Isayeli bandaka na kuswanisa Moyize. Bawu tubaka: «Pesa beto maza ya kunwa!» Moyize zonzaka na bawu: «Samu na yinki beno ke na kuswanisa munu? Samu na yinki beno ke na kusombola mpe Yave?» ");
INSERT INTO mkw_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Kuna, bantu ya Isayeli vwandaka na mpwila ya maza. Bawu vwandaka vungutila Moyize. Bawu vwandaka tuba: «Samu na yinki nge me katula beto na Ngipiti? Ya kele samu na kufwa beto na nsatu ya maza, na bana na bibulu ya beto?» ");
INSERT INTO mkw_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Na yina, Moyize lookaka na sika ya Yave: «Yinki mu ke sala samu na bantu yayi? Fyoti kaka me bikana mpe bawu ke kufwa munu na matadi!» ");
INSERT INTO mkw_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yave tubaka na Moyize: «Kwenda, telama na mantwala ya bantu ya Isayeli. Baka ndambu ya bakuluntu ya Isayeli, baka mpe yinti yina nge sadilaka na nzadi ya Nile, mpe kwenda. ");
INSERT INTO mkw_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mu ke vwanda na mantwala ya nge, kuna na zulu ya ditadi, na mongo ya Olebe. Nge ke bula ditadi, yawu ke basisa maza mpe bantu ke kunwa yawu.» Moyize salaka mutindu yina na mantwala ya bakuluntu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mpe yandi pesaka kisika yina nkumbu ya Masa, yina zola kutuba «Kusombola», mpe Meliba, yina zola kutuba «Kuswana», samu ti bana ya Isayeli swanisaka Moyize, mpe bawu sombolaka Yave na kutuba: «Yave kele na kati-kati ya beto to yandi kele ve?» ");
INSERT INTO mkw_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Bantu ya Amaleke kwizaka nwanisa bantu ya Isayeli kuna na Lefidime. ");
INSERT INTO mkw_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Na yina, Moyize tubaka na Yeswa: «Soodila beto babakala yina lenda nwana. Mbasi beno ke kwenda nwana na bantu ya Amaleke. Munu, mu ke vwanda ya kutelama na zulu ya mongo, na yinti ya Nzambi na diboko.» ");
INSERT INTO mkw_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yeswa salaka mutindu Moyize zonzaka, samu na kwenda nwana na bantu ya Amaleke. Kaka na ntangu yina mpe, Moyize, Aloni mpe Wule yulukaka na zulu ya mongo. ");
INSERT INTO mkw_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ntangu Moyize vwandaka nanguna diboko na zulu, bantu ya Isayeli vwandaka lutila ngolo. Kasi ntangu yandi vwandaka kulula diboko samu na kupema, bantu ya Amaleke vwandaka lutila ngolo. ");
INSERT INTO mkw_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ntangu mosi, maboko ya Moyize vwandaka me lemba. Na yina, ba tudilaka yandi ditadi mpe yandi vwandilaka yawu. Aloni simbaka diboko ya Moyize samu na kusyamisa yawu. Wule mpe simbaka diboko ya nkaka ya Moyize. Na yina, maboko nyonso zole ya Moyize vwandaka ya kusyama tii na ntangu yina ntangu dyamaka. ");
INSERT INTO mkw_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yeswa nungaka Amaleke na bantu ya yandi na mvita. ");
INSERT INTO mkw_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yave tubaka na Moyize: «Sonika mambu yayi na dibuku, samu ti ba zimbana yawu ve. Zabisa mbote-mbote na Yeswa ti mu ke manisa ba-Amaleke nyonso, mpe ata muntu na ntoto ke bambukila dyaka bawu moyo.» ");
INSERT INTO mkw_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Na yina, Moyize yidikaka kiyokolo ya minkayulu. Yandi pesaka kiyokolo yango nkumbu Yave-Nisi. Yawu zola kutuba: «Yave, kidimbu ya nungunu.» ");
INSERT INTO mkw_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Yandi tubaka: «Mutindu ba-Amaleke me meka na kunanguna diboko, samu na kunwanisa kiti ya kintinu ya Yave, mvita ke tatamana na kuvwanda na kati ya Yave na ba-Amaleke bambandu na bambandu.» ");
INSERT INTO mkw_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetelo, yina vwandaka nganga-Nzambi ya yinsi ya Midyane mpe bokilo ya Moyize, kuwaka mambu yina Nzambi salaka, samu na Moyize mpe Isayeli, bantu ya yandi. Yandi kuwaka ti Yave basisaka bantu ya Isayeli na Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Yetelo, bokilo ya Moyize, kwendaka kintwadi na Sipola, kento ya Moyize, yina yandi vutulaka ntete na yinzo ya bibuti ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Yetelo kwendaka mpe na bana zole ya Moyize. Mwana mosi vwandaka na nkumbu Ngelesome. Yawu zola kutuba «Nzenza na bisika yina». Samu ti Moyize tubaka: «Mu me kwiza zinga na yinsi ya bunzenza.» ");
INSERT INTO mkw_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Mwana ya nkaka vwandaka nkumbu Elyezele. Yawu zola kutuba «Nzambi ya munu kele kisadisi ya munu». Samu ti Moyize tubaka: «Nzambi ya tata ya munu me sadisa munu. Yandi me kuula munu na mvita ya Falawo, ntinu ya Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ntangu Yetelo, bokilo ya Moyize, kwendaka na sika ya Moyize, yandi kwendaka kintwadi na kento mpe bana ya Moyize, kuna na yinsi ya kuyuma, kisika yina Moyize salaka kivwandu ya yandi, na mongo ya Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yandi tumisaka ti ba kwenda zabisa na Moyize mutindu yayi: «Ni munu Yetelo bokilo ya nge, yina ke na kukwiza na sika ya nge kintwadi na kento mpe bana ya nge zole ya babakala.» ");
INSERT INTO mkw_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moyize basikaka na kwenda bwabana bokilo ya yandi. Yandi fukamaka mpe fibaka yandi. Bawu pesanaka bansangu mpe bawu kwendaka kota na yinzo ya lele. ");
INSERT INTO mkw_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moyize zabisaka na bokilo ya yandi mambu nyonso yina Yave salaka na Falawo, ntinu ya Ngipiti, mpe na yinsi ya Ngipiti, samu na Isayeli. Moyize zabisaka yandi mpe bampasi nyonso yina bawu bwabanaka na nzila, mpe wapi mutindu Yave kuulaka bawu. ");
INSERT INTO mkw_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetelo yangalalaka na mambu nyonso ya mbote yina Yave salaka samu na Isayeli, na kukuula bawu na maboko ya bantu ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Mpe Yetelo tubaka: «Nkembo na Yave yina me kuula beno na maboko ya bantu ya Ngipiti, mpe na maboko ya Falawo, ntinu ya Ngipiti! Nkembo na yandi yina me kuula bantu ya Isayeli na maboko ya bantu ya Ngipiti! ");
INSERT INTO mkw_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ntangu yayi, mu me zaba ti Yave kele nene kulutila banzambi nyonso: Yandi me lakisa yawu na ntangu bantu ya Ngipiti vwandaka kwamisa bantu ya Isayeli na lunangu nyonso.» ");
INSERT INTO mkw_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Na yina, Yetelo, bokilo ya Moyize, pesaka na Nzambi munkayulu ya bibulu ya kuyoka, mpe minkayulu ya nkaka. Aloni mpe bakuluntu nyonso ya Isayeli kwendaka kudya madya na mantwala ya Nzambi, kintwadi na bokilo ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Na kilumbu yina landaka, Moyize vwandaka samu na kufundisa bantu. Bantu vwandaka na mantwala ya Moyize kubanda na suka tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ntangu bokilo ya Moyize talaka nyonso yina Moyize vwandaka sala samu na bantu. Yandi tubaka: «Yinki nge ke na kusala samu na bantu yayi? Samu na yinki nge ke na kusala kisalu yayi nge mosi? Samu na yinki bantu nyonso me vwandaka na mantwala ya nge, kubanda na suka tii na nkokila?» ");
INSERT INTO mkw_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moyize vutulaka na bokilo ya yandi: «Bantu yayi ke na kukwiza na sika ya munu, samu na kusosa luzolo ya Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kana bantu me kuzwa mambu, bawu ke kwiza na sika ya munu. Mu ke yidika mambu ya bawu. Mu ke zabisa bawu mpe banzengolo ya Nzambi mpe misiku ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Bokilo ya yandi vutulaka: «Nsalulu ya nge kele ya mbote ve. ");
INSERT INTO mkw_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Nge ke lemba mingi, nge na bantu yayi ke na kwizaka na sika ya nge. Kisalu yayi me lutila nene samu na nge. Nge lenda sala yawu kaka nge mosi ve. ");
INSERT INTO mkw_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ntangu yayi, kuwa munu. Mu ke na kupesa nge malongi, bika ti Nzambi kuvwanda na nge. Vwanda kimonikisi ya bantu na mantwala ya Nzambi. Nataka nge mosi mambu ya bantu na mantwala ya Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Nge ke lakisa bantu banzengolo ya Nzambi mpe misiku ya yandi. Nge ke zabisa bawu nzila yina bawu fwana kudyatila, mpe mambu yina bawu fwana kusala. ");
INSERT INTO mkw_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Na yina me tadila mambu ya nkaka, nge ke soola bantu ya buzitu yina ke zitisaka Nzambi. Nge ke soola bayina kele ya kukwikama, bayina ke ndimaka ve madeso ya bana. Tula bawu mfumu ya funda mosi ya bantu, mfumu ya nkama ya bantu, mfumu ya makumi tanu ya bantu, mpe mfumu ya kumi ya bantu. ");
INSERT INTO mkw_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ni bawu ke fundisa bantu konso ntangu. Bawu ke natina nge mambu yina me lutila mfunu. Kasi mambu ya nkaka, ni bawu mosi ke yidika yawu. Na kusadila mutindu yina, dema ya kisalu ya nge ke kuluka. Bawu ke kabula kisalu na nge. ");
INSERT INTO mkw_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kana nge sala mutindu yina, mpe kana Nzambi pesila nge yawu lutumu, nge ke lemba ve. Mpe bantu nyonso yayi ke vutuka mbote na bisika ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moyize kuwaka mambu ya bokilo ya yandi. Yandi sadilaka nyonso yina bokilo ya yandi tubaka. ");
INSERT INTO mkw_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Na kati ya Isayeli nyonso, Moyize soolaka bantu ya buzitu. Yandi tulaka bawu bamfumu ya funda mosi ya bantu, bamfumu ya nkama ya bantu, bamfumu ya makumi tanu ya bantu, mpe bamfumu ya kumi ya bantu. ");
INSERT INTO mkw_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Bawu vwandaka fundisa bantu konso ntangu. Mambu ya kulutila mfunu, ba vwandaka nata yawu na sika ya Moyize. Kasi mambu ya nkaka, bawu vwandaka yidika yawu bawu mosi. ");
INSERT INTO mkw_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Na manima, Moyize bikaka bokilo ya yandi kuvutuka na yinsi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Bana ya Isayeli kumaka na Sinayi, yinsi ya kuyuma. Ya vwandaka na ngonda ya tatu, katuka kilumbu yina bawu basikaka na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ntangu bawu katukaka na kisika yina ba ke bokilaka Lefidime, bawu kumaka na Sinayi, yinsi ya kuyuma. Bawu salaka kivwandu ya bawu kuna, na yinsi ya kuyuma, mbombo na mbombo na mongo. ");
INSERT INTO mkw_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moyize yulukaka na mongo na kubwabana Nzambi. Yave bokilaka yandi na mongo. Yave tubaka na yandi: «Nge ke zonza mutindu yayi na dikanda ya Yakobi, mpe nge ke pesa malongi yayi na bana ya Isayeli: ");
INSERT INTO mkw_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Beno me tala beno mosi mambu yina mu me sala na yinsi ya Ngipiti. Mu me nanguna beno na zulu ya mapapu ya mbemba, mpe mu me nata beno na sika ya munu. ");
INSERT INTO mkw_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ntangu yayi, kana beno kuwa munu, kana beno keba ngwisani ya munu, beno ke vwanda mvwilu ya munu mosi na mantwala ya makanda nyonso, samu ti ntoto nyonso kele ya munu. ");
INSERT INTO mkw_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Beno ke vwanda samu na munu dikanda ya banganga-Nzambi ya kintinu, bantu yina mu me tula na lweka samu na munu.” Ni mambu yayi nge ke tuba na bana ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moyize vutukaka. Yandi bokilaka bakuluntu ya Isayeli. Yandi zabisaka bawu mambu nyonso yina Yave tumisaka yandi. ");
INSERT INTO mkw_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Bantu nyonso ya Isayeli vutulaka na kintwadi: «Mambu nyonso yina Yave me tuba, beto ke sala yawu.» Moyize kwendaka zabisaka na Yave mambu ya bantu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Na yina, Yave tubaka na Moyize: «Mu ke kwiza na sika ya nge ya kubumbama na kati ya dituti ya nene, samu ti bantu ya Isayeli kuwa na ntangu yina mu ke zonza na nge. Na yina, ba ke tula kiminu ya bawu na nge bantangu nyonso.» Moyize zabisaka na Yave mambu ya bantu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yave tubaka na Moyize: «Kwenda na sika ya bantu ya Isayeli. Zabisa bawu na kuvwanda ya kuvedila bubu yayi mpe mbasi. Bawu kusukula mpe binkuti ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Bawu kuvwanda ya kukubama na kilumbu ya tatu, samu ti na kilumbu ya tatu, Munu Yave, mu ke kulumuka na mongo ya Sinayi, na meso ya bantu nyonso ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Tula bandilu na balweka nyonso ya mongo samu na bantu ya Isayeli. Tuba na bawu: “Beno keba na kuyuluka mongo. Beno simba yawu ve. Muntu ni muntu yina ke simba yawu, kaka kufwa ba ke kufwa yandi!” ");
INSERT INTO mkw_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Muntu yina ke simba mongo, ata muntu ke simba yandi, kasi ba ke kufwa yandi na matadi to na madionga. Ya vwanda kibulu to muntu, ba ke bika ve yandi moyo. Ntangu muningu ya mpungi ke wakana, ba ya nkaka ke yuluka na mongo.» ");
INSERT INTO mkw_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moyize kulumukaka dyaka mongo. Yandi kwendaka na sika ya bantu ya Isayeli. Yandi zabisaka bawu na kuvwanda ya kuvedila, mpe bawu sukulaka binkuti ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Moyize tubaka na bantu ya Isayeli: «Beno vwanda ya kukubama na bilumbu tatu. Ata muntu ke vukisa mfulu na kento.» ");
INSERT INTO mkw_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Na kilumbu ya tatu, na suka-suka, na zulu ya mongo, bidumu wakanaka, balusyemo talanaka, dituti ya nene talanaka, muningu ya mpungi wakanaka na ngolo mingi. Bantu nyonso yina vwandaka kuna na kivwandu, bawu vwandaka tekita na boma. ");
INSERT INTO mkw_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Na yina, Moyize basisaka bawu na kivwandu, samu na kwenda bwabana Nzambi. Bawu kwendaka telama na yisi ya mongo. ");
INSERT INTO mkw_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mongo nyonso ya Sinayi fulukaka na mulinga, samu ti Yave kulumukaka na zulu ya yawu, na kati ya tiya. Mulinga yango vwandaka nanguka mutindu mulinga ya kifuule ya nene. Mongo nyonso vwandaka ningana na ngolo. ");
INSERT INTO mkw_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Muningu ya mpungi vwandaka lutila na kuwakana. Moyize vwandaka zonza, mpe Nzambi vwandaka vutudila yandi. ");
INSERT INTO mkw_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ntangu Yave kulumukaka na mongo ya Sinayi, na nsongi ya mongo yina, yandi bokilaka Moyize na nsongi ya mongo, mpe Moyize yulukaka kuna. ");
INSERT INTO mkw_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yave tubaka na Moyize: «Kulumuka, kwenda kebisa bantu na kuzabisa bawu ti bawu kubelama ve kidi-kidi na munu Yave, samu na kutala. Kana ve, mingi na kati ya bawu ke kufwa. ");
INSERT INTO mkw_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Banganga-Nzambi yina ke belama na munu Yave, bawu fwana kuvwanda ya kuvedila, samu ti mu balukila bawu ve.» ");
INSERT INTO mkw_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moyize tubaka na Yave: «Bantu lenda yuluka mongo ya Sinayi ve. Samu ti nge mosi, nge me kebisa beto ti: “Tula bandilu na balweka nyonso ya mongo, mpe zonza ti mongo yayi kele ya longo.”» ");
INSERT INTO mkw_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yave tubaka na yandi: «Kulumuka mpe nge yuluka na Aloni. Kasi banganga-Nzambi na bantu ya nkaka, bawu kuyuluka ve na sika ya munu Yave, samu ti mu balukila bawu ve.» ");
INSERT INTO mkw_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moyize kulumukaka na sika ya bantu ya Isayeli. Yandi zonzaka na bawu. ");
INSERT INTO mkw_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Mpe Nzambi bandaka na kuzonza mambu nyonso yayi: ");
INSERT INTO mkw_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Mu kele Yave Nzambi ya nge, yina me basisa nge na yinsi ya Ngipiti, kisika nge vwandaka na bundongo.» ");
INSERT INTO mkw_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Kuvwanda ve na banzambi ya nkaka na mantwala ya munu.» ");
INSERT INTO mkw_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Kuyidika ve kiteki ya kusambila. Ata kifwani ya bima yina kele kuna na zulu, to yina kele na yisi awa na ntoto, to yina kele na maza kuna na yisi ya ntoto. ");
INSERT INTO mkw_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Kufukimina yawu ve, mpe kusambila yawu ve, samu ti munu Yave, Nzambi ya nge, mu kele Nzambi yina kele na kimbanda. Masumu ya batata, mu ke futisaka yawu na bana ya bawu tii na mbandu ya tatu, mpe na mbandu ya yiya ya bayina ke yinaka munu. ");
INSERT INTO mkw_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kasi mu ke salaka mambu ya mbote tii na funda ya bambandu na bayina ke zolaka munu, mpe ke kebaka misiku ya munu.» ");
INSERT INTO mkw_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Kusadila ve Nkumbu ya munu Yave, Nzambi ya nge na mutindu ya yimbi, samu ti munu Yave, mu ke sembaka bayina ke sadilaka Nkumbu ya munu na mutindu ya yimbi.» ");
INSERT INTO mkw_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Kuzimbana ve na kuzitisa kilumbu ya Saba mutindu kilumbu ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Nge ke sala bilumbu sambanu. Nge ke sala bisalu ya nge nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Kasi kilumbu ya nsambwadi kele Saba samu na Yave, Nzambi ya nge. Kusala ve ata kisalu mosi na kilumbu yina, ya vwanda nge, ya vwanda mwana ya nge ya bakala to ya kento, ya vwanda kisadi ya nge ya kento to ya bakala, ya vwanda bibulu ya nge, ya vwanda nzenza yina ke vwandaka na bwala ya nge, ");
INSERT INTO mkw_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","samu ti na bilumbu sambanu, Yave salaka zulu, ntoto, mubu, mpe nyonso yina kele na kati ya yawu. Kasi yandi pemaka na kilumbu ya nsambwadi. Ni yawu yina, Yave sakumunaka kilumbu ya saba, mpe yandi soolaka yawu, samu ti yawu kuvwanda kilumbu ya yandi mosi.» ");
INSERT INTO mkw_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Zitisa tata na mama ya nge, samu ti luzingu ya nge kuvwanda yinda na yinsi yina munu Yave, Nzambi ya nge, ke na kupesa nge.» ");
INSERT INTO mkw_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Kufwa muntu ve.» ");
INSERT INTO mkw_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Kusala kinsunza ve.» ");
INSERT INTO mkw_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Kulaba ve.» ");
INSERT INTO mkw_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Kutuba ve kimbangi ya luvunu na mpangi ya nge.» ");
INSERT INTO mkw_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Kuzinina ve yinzo ya mpangi ya nge. Kuzinina ve kento ya mpangi ya nge. Kuzinina ve kisadi ya yandi ya bakala to ya kento. Kuzinina ve ngombe ya yandi to mbuluku ya yandi. Kuzinina ve kima ni kima yina kele ya mpangi ya nge.» ");
INSERT INTO mkw_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Na yina, bantu nyonso vwandaka kuwa bidumu, na muningu ya mpungi. Bawu vwandaka tala mpe mongo na mulinga ya yawu, na balusyemo. Na kutala nyonso yina, bawu vwandaka tekita, mpe bawu telamaka ntama na yawu. ");
INSERT INTO mkw_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Bawu tubaka na Moyize: «Zonza na beto nge mosi, beto ke kuwa. Kasi Nzambi kuzonza na beto ve, kana ve, beto ke kufwa.» ");
INSERT INTO mkw_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Kasi Moyize tubaka na bawu: «Beno vwanda ve na boma, samu ti kana Nzambi me kwizila mutindu yayi, ya ke samu na kumeka beno, samu ti beno kuvwanda na boma ya yandi, mpe beno kusala ve masumu.» ");
INSERT INTO mkw_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Na yina, Moyize belamaka na dituti, kisika vwandaka Nzambi, kasi bantu vwandaka ya bawu mwa ntama. ");
INSERT INTO mkw_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yave tubaka na Moyize: «Nge ke zabisa na bana ya Isayeli mutindu yayi: “Beno me tala beno mosi mutindu mu me zonzila beno katuka na mazulu. ");
INSERT INTO mkw_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Na yina, beno ke yidika ve binzambi-nzambi ata ya wolo to ya palata samu na kusambila. Beno ke yidika yawu ve. ");
INSERT INTO mkw_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Na konso kisika yina mu ke talana na beno, beno ke sadila ntoto, samu na kuyidikila munu kiyokolo ya minkayulu ya kuyoka, mpe minkayulu ya kiwisa na minkayulu ya bangombe, mameme na bankombo. Ni kuna mu ke kwiza sakumuna beno. ");
INSERT INTO mkw_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kasi, kana beno baka matadi samu na kuyidikila munu kiyokolo ya minkayulu, beno fwana kubaka ve matadi yina ba me bongisaka mbote-mbote, samu ti kana beno sadila bambele ya beno samu na kubongisa yawu, beno ke safula yawu. ");
INSERT INTO mkw_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Beno kusadila ve bikada samu na kuyuluka na kiyokolo ya minkayulu, samu ti bimpene ya beno kutalana ve.”» ");
INSERT INTO mkw_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«Tala, misiku ya nkaka yina nge ke zabisa na bawu ni yayi: ");
INSERT INTO mkw_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ntangu nge ke sumba mu-Ebeleyo samu ti yandi kuvwanda mundongo ya nge, yandi ke sadila nge bamvula sambanu. Na mvula ya nsambwadi, yandi ke kwenda ya yandi na kimpwanza. Yandi ke futa ata kima ve. ");
INSERT INTO mkw_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kana yandi kwizaka kaka yandi mosi, yandi ke kwenda kaka yandi mosi. Kana yandi vwandaka na kento ya yandi, kento ya yandi mpe ke kwenda na yandi. ");
INSERT INTO mkw_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kana ni mfumu ya yandi pesaka yandi kento, mpe kento yango me butila yandi bana ya bakento to ya babakala, kento na bana ke kuma mvwilu ya mfumu yina. Yandi mundongo, yandi ke kwenda kaka yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Kasi kana mundongo tuba ti mu ke zolaka mfumu ya munu, kento ya munu mpe bana ya munu, mu zola ve kuvwanda na kimpwanza, ");
INSERT INTO mkw_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","mfumu ya yandi ke nata yandi na ntadisi ya Nzambi. Mfumu ke belemisa mundongo na dikunzi ya mwelo to na dibaya ya mwelo. Mfumu ke tobola yandi dikutu na muntuma. Na yina, mundongo yayi ke sadila mfumu yina seko. ");
INSERT INTO mkw_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Ntangu muntu ke tekisa mwana ya yandi ya kento mutindu kisadi, mwana yina ke katuka ve na bundongo mutindu ke katukilaka bandongo ya nkaka ya babakala. ");
INSERT INTO mkw_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kana mfumu ya yandi sumbaka yandi samu ti yandi kuvwanda kento ya yandi, kasi mfumu ke na kuzola dyaka kento yango ve, mfumu yina ke bika ti ba kuula kento yango. Kasi mfumu yina kele ve na muswa ya kutekisa kento yango na banzenza. Ya kele mbote ve na kuyekula yandi mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kana yandi sumbaka ndumba yina samu na kupesa yandi na sika ya mwana ya yandi ya bakala, yandi fwana kusala na mwana yina ya kento mutindu yandi fwanaka sala samu na bana ya yandi mosi ya bakento. ");
INSERT INTO mkw_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kana mfumu yina baka dyaka kento ya nkaka, yandi ke katula ata kima ve na kento ya ntete yina, ya vwanda na yina me tadila madya, bilele mpe luve ya yandi ya bukento ya makwela. ");
INSERT INTO mkw_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kana yandi sadila ve mutindu yina, na yina me tadila mambu tatu yina, kento lenda kuzwa ya yandi kimpwanza ata kufuta mbongo.» ");
INSERT INTO mkw_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Muntu yina ke bula muntu ya nkaka tii na kufwa yandi, ba fwana kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kana muntu yina vwandaka ve na dibanza ya kufwa yandi, kasi Nzambi me bika ti yandi kufwa na nkuba yina, mu ke lakisa nge kisika yina muntu yango ke kwenda bumbama. ");
INSERT INTO mkw_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Kasi, kana muntu, na luzolo ya yandi mosi, me kufwa muntu ya nkaka na mayela, ata ti yandi kwenda bumbama na kiyokolo ya munu ya minkayulu, nge ke kwenda katula yandi kuna, samu na kufwa yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Muntu yina ke bula tata ya yandi to mama ya yandi, kaka kufwa ba fwana kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Muntu yina ke laba muntu ya nkaka, ata ti yandi me tekisa muntu yango, to ba me kuta muntu yango na sika ya muntu yina me laba yandi, ba fwana kufwa muntu yina me laba. ");
INSERT INTO mkw_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Muntu yina ke siinga tata to mama ya yandi, kaka kufwa ba fwana kufwa yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«Kana bantu ke na kuswana, mosi na bawu me bula mpangi ditadi to dikofi yina ke sala ti mpangi yango kufwa ve, kasi yandi kota yinzo, ");
INSERT INTO mkw_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kana na manima, yandi kuzwa ngolo ya kutelama, kubasika na ngaanda mpe kutambula na yinti na maboko, muntu yina me bula yandi ke kuzwa ve kitumbu. Kasi yandi ke futa mpangi yina samu na kuvwandisa yina yandi me vwandisa yandi na yinzo, mpe yandi ke sadisa yandi na kubeluka.» ");
INSERT INTO mkw_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Kana muntu baka kikoti mpe yandi bula mundongo ya yandi ya kento to ya bakala, kana mundongo yango kufwa na maboko ya yandi, ba ke futisa yandi lufwa yina. ");
INSERT INTO mkw_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Kasi, kana mundongo yina kuzinga dyaka kilumbu mosi to bilumbu zole, mfumu yina ke kuzwa ve kitumbu, samu ti mundongo yina kele mvwilu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Kana bantu ke na kuswana, kana bawu tutana na kento yina ke na kivumu, mpe mwana kubasika samu na kututana yina, mpe kana dikubu ya nkaka salama ve, bantu yina me tutana na kento yango ke futa kikodi. Kikodi yango ni bakala ya kento ke zenga kikodi yina ba ke futa yandi, na meso ya banzonzi. ");
INSERT INTO mkw_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Kasi, kana dikubu me salama, nge ke futisa luzingu ya muntu na luzingu ya muntu, ");
INSERT INTO mkw_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","disu na disu, dinu na dinu, diboko na diboko, dikulu na dikulu, ");
INSERT INTO mkw_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kuyoka na kuyoka, kulwalisa na kulwalisa, mputa na mputa.» ");
INSERT INTO mkw_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Kana muntu bula disu ya mundongo ya yandi ya kento to ya bakala mpe disu me kufwa, yandi ke bika ti mundongo yina kukatuka na bundongo samu na disu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kana yandi bula mundongo ya yandi ya kento to ya bakala na kukatula yandi dinu, yandi ke bika ti mundongo yina kukatuka na bundongo samu na dinu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Kana ngombe, na mampoka ya yandi, bula muntu, ya vwanda kento to bakala mpe muntu yango me kufwa, ba ke kufwa ngombe yina na matadi mpe ba ke kudya ve mbisi ya yawu. Muntu ya ngombe yina ke kuzwa ve kitumbu. ");
INSERT INTO mkw_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kana ngombe yina vwandaka na kifu ya kubulaka bantu mampoka, mpe ti ba zabisaka yawu na muntu ya yawu, kasi yandi vwandaka kengidila yawu ve, kana ngombe yango kufwa muntu ya kento to ya bakala, ba ke kufwa ngombe yina na matadi. Ba ke kufwa mpe muntu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kasi, kana ba tumisa na muntu ya ngombe na kufuta kikodi, yandi fwana kupesa nyonso yina ba ke tumisa yandi, samu na kukuula luzingu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kana ngombe kufwa ndumba to ditoko, ba ke sala kaka mutindu mosi. ");
INSERT INTO mkw_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kana ngombe kufwa mundongo ya kento to ya bakala, ba ke futisa muntu ya ngombe yina Basekele makumi tatu ya mbongo ya palata mpe ba ke kufwa ngombe yango na matadi.» ");
INSERT INTO mkw_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Kana muntu me fungula dibulu ya maza mpe me bika yawu mwasi to kana yandi me timuna dibulu ya maza mpe yandi me kanga ve yawu, kana ngombe to mbuluku kubwa na kati ya dibulu yina, ");
INSERT INTO mkw_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","muntu ya dibulu ke futa ntalu ya kibulu yina na muntu ya yawu, mpe yandi ke baka kibulu yango ya kufwa.» ");
INSERT INTO mkw_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«Kana ngombe ya muntu kufwa ngombe ya muntu ya nkaka na mampoka ya yandi, bantu ya kuzwa bangombe yina ke tekisa ngombe ya moyo. Bawu ke kabula mbongo. Bawu ke kabula mpe ngombe ya kufwa. ");
INSERT INTO mkw_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Kana ya kele ya kuzabakana ti ngombe yina ke na kifu ya kubulaka bangombe ya nkaka mampoka ya yandi, kasi muntu ya yawu vwandaka kengidila yawu ve, muntu yina ke pesa ngombe ya moyo na kufuta ngombe yina me kufwa. Na yina, yandi ke baka ngombe yina me kufwa.» ");
INSERT INTO mkw_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","«Kana muntu me laba ngombe, dimeme to nkombo, kana yandi zenga yawu laka to kana yandi tekisa yawu, yandi ke futa bangombe tanu kana yandi me laba ngombe. Yandi ke futa mameme yiya kana yandi me laba dimeme to yandi ke futa bankombo yiya kana yandi me laba nkombo.» ");
INSERT INTO mkw_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Kana muntu bwila muyibi yina ke na kulaba, kana yandi bula muyibi yina mpe ti muyibi yango kufwa, lufwa ya muyibi yina ke vwanda ve na yintu ya muntu yina me kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kana ba bwila muyibi yina na ntangu, lufwa ya muyibi yango ke kubwa na yintu ya muntu yina ke kufwa yandi. Kasi, kana ba kufwa ve muyibi yango, yandi ke futa kikodi. Kana yandi kele ve na kima ya kufutila kikodi, ba ke tekisa yandi samu na muyibi ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","«Kana ba simba muyibi yina me laba ngombe, mbuluku, dimeme to nkombo mpe bibulu yango ke ntete moyo, muyibi yina ke futa bibulu zole-zole samu na konso kibulu.» ");
INSERT INTO mkw_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","«Ntangu muntu ke kwenda dikila bibulu ya yandi na bilanga ya yandi to na bilanga ya yandi ya bayinti ya vinu, kana yandi fidisa bibulu yango na bilanga ya muntu ya nkaka, yandi ke futa kikodi. Yandi ke futila kikodi yango na madya ya kulutila kitoko ya bilanga ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«Ntangu muntu ke tula tiya, kana tiya yango kuzwa matiti ya bansende yina ke fidisa tiya na kuyoka matiti ya bambuma ya faline yina ba me zenga to yina ba me zenga ntete ve, to kana tiya yina yoka bilanga, muntu yina me tula tiya yango ke futa kikodi.» ");
INSERT INTO mkw_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«Ntangu muntu ke bumbisa mbongo to bima ya nkaka na sika ya mpangi ya yandi, kana ba laba yawu kuna na yinzo ya mpangi yina, muyibi ya yawu ke futa kikodi kana bima yango me talana. Kikodi yina ke vwanda ya bima zole-zole, samu na konso kima yina yandi me laba. ");
INSERT INTO mkw_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kana ba kuzwa ve muyibi yina, muntu ya yinzo ke kwenda talana na ntadisi ya Nzambi, samu na kudya ndefi ti yandi me baka ve bima ya mpangi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Kana bantu zole ke na kuswana samu na ngombe, mbuluku, dimeme to nkombo, kinkuti to kima yina me zimbana, mpe bawu zole ke na kutuba: “Yayi ke kima ya munu!” Dyambu yina ke kuma tii na mantwala ya Nzambi. Muntu yina Nzambi ke tuba ti ni yandi me vuna, yandi ke futa mpangi ya yandi bima zole samu na kima yina yandi ke na kunwanina.» ");
INSERT INTO mkw_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«Ntangu muntu ke pesa kibulu na sika ya mpangi ya yandi samu na kukeba yawu, ya vwanda mbuluku, ngombe, dimeme, nkombo, to kibulu ya nkaka, kana yawu kufwa to yawu zengana kinama, to kana ba me baka yawu mpe ata muntu me zaba nani me baka yawu, ");
INSERT INTO mkw_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","mpangi yina fwana kudya ndefi na Nkumbu ya Yave ti ni yandi ve me tula maboko na kibulu ya mpangi. Muntu ya kibulu ke ndima ndefi ya mpangi, mpe mpangi yina ke futa ve kikodi. ");
INSERT INTO mkw_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Kasi, kana ba me laba kibulu yina na sika ya yandi, yandi ke futa kikodi na sika ya muntu ya kibulu yina. ");
INSERT INTO mkw_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Kana ba pasulaka kibulu yango na kibulu ya nsisi, yandi fwana kulakisa yawu mutindu kimbangi mpe kuna yandi ke futa ve kikodi, samu na kibulu yina ba me pasula.» ");
INSERT INTO mkw_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","«Ntangu muntu ke defa kibulu na sika ya mpangi ya yandi, kana kibulu yango zengana kinama to yawu kufwa na ntangu muntu ya yawu kele kuna ve, muntu yina me defa kibulu yango ke yingisa yawu. ");
INSERT INTO mkw_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kana dyambu yina kubwa na meso ya muntu ya kibulu yina, muntu yina me defa yawu ke futa kima ve. Kana yandi ke na kufutila kibulu yina, kaka ni ntalu ya kufutila yawu yandi ke futa.» ");
INSERT INTO mkw_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","«Ntangu bakala ke basika na ndumba yina me zaba ntete ve babakala mpe yina kele ve na nsilulu ya makwela, kana yandi vukisa mfulu na yandi, bakala yango ke pesa bima nyonso ya makwela, samu ti ndumba yina kuma kento ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Kana tata ya ndumba yina manga na kupesa mwana ya yandi na bakala yina, bakala yina ke futa ntalu ya mbongo yina ba ke kwedilaka ndumba yina me zaba ntete ve babakala.» ");
INSERT INTO mkw_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","«Nge ke bika ve ti ndoki ya kento kuzinga.» ");
INSERT INTO mkw_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«Muntu yina ke sala makwela na kibulu, kaka kufwa ba fwana kufwa yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«Muntu yina ke pesa minkayulu na banzambi ya nkaka, kana kaka na Yave ve, kaka kufwa ba fwana kufwa yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«Kutalisa ve nzenza mpasi mpe kunyokola yandi ve, samu ti beno mpe, beno vwandaka banzenza na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Beno talisa ve mpasi na ata mufwidi ya kento to nsaana. ");
INSERT INTO mkw_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Kana nge talisa bawu mpasi mpe bawu looka na sika ya munu, mu ke kuwa mbote kulooka ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Mu ke dasuka mpe mu ke kufwa beno na bamvita. Bakento ya beno ke kuma mifwidi mpe bana ya beno ke kuma bansaana.» ");
INSERT INTO mkw_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","«Kana nge defisa mbongo na mosi ya bantu ya munu, mputu yina kele na sika ya beno, kusala yandi ve mutindu ke salaka bidefisi-mbongo. Kulomba yandi ve ndandu na zulu ya mfuka yina.» ");
INSERT INTO mkw_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«Kana nge baka kiyunga ya mpangi ya nge samu na mfuka, vutula yandi yawu ntete nkokila kuma, ");
INSERT INTO mkw_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","samu ti divunga mosi yina ke na yandi, kaka ni kiyunga yina ke fukaka nzutu ya yandi. Kana ve, yinki yandi ke fukila? Kana yandi looka na sika ya munu, mu ke kuwa yandi mbote, samu ti mu kele Nzambi yina ke talaka kyadi.» ");
INSERT INTO mkw_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","«Beno finga Nzambi ve. Beno kusiinga ve mfumu ya bantu ya beno.» ");
INSERT INTO mkw_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«Beno lutisa ve ntangu na kupesa munu madya ya beno ya ntete ya bilanga na bambuma ya beno ya ntete ya vinu.» «Beno ke pesa munu konso mwana ya ntete ya bakala na kati ya bana ya beno, samu ti bawu kuvwanda ya munu.» ");
INSERT INTO mkw_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«Beno sala mutindu mosi samu na bangombe ya beno mpe samu na mameme na bankombo ya beno. Mwana ya ntete ke vwanda bilumbu nsambwadi na mama ya yandi. Na kilumbu ya nana, beno ke pesa munu yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","«Na ntadisi ya munu, beno vwanda bantu yina ba me tula na lweka samu na munu. Beno kudya ve mbisi ya kibulu yina kibulu ya nsisi me kufwa na kati ya matiti. Beno losa yawu na bayimbwa.» ");
INSERT INTO mkw_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Na balufundusu, kumwangisa ve bansangu ya luvunu. Kusala ve kimbangi ya luvunu samu na kusadisa muntu ya yimbi. ");
INSERT INTO mkw_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ata ti bantu nyonso me wisana samu na kusala yimbi, kulanda bawu ve. Na kati ya lufundusu, ata ti bantu nyonso me wisana samu na kutengimisa ludedomo, kukota ve na mfundu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ntangu nge ke fundisa mputu, kusosa ve na kunungisa yandi na mutindu ya kufwanakana ve.» ");
INSERT INTO mkw_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Kana nge tala ngombe to mbuluku yina mbeni ya nge me zimbisa, natina yandi yawu na nswalu. ");
INSERT INTO mkw_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ntangu nge ke tala ti mbuluku ya muntu yina ke yinaka nge, yawu me kubwa samu na mufuna, kubika yawu ve. Sadisa muntu yango na kutelemisa mbuluku ya yandi na nswalu.» ");
INSERT INTO mkw_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Na lufundusu ya mputu, kutengimisa ve nzengolo. ");
INSERT INTO mkw_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kubelama ata fyoti ve na konso dyambu ya luvunu. Kuzengila ve lufwa na muntu yina me zaba ata dyambu to muntu yina kele ya kudedama, samu ti mu ke kondwa ve na kusemba muntu ya yimbi. ");
INSERT INTO mkw_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Kundima ve madeso ya bana, samu ti madeso ya bana ke kangaka meso ya bayina vwandaka tala mbote. Yawu ke bebisaka lufundusu ya bantu ya kudedama.» ");
INSERT INTO mkw_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Kutalisa ve nzenza mpasi. Beno zaba beno mosi wapi mutindu kele luzingu ya bunzenza, samu ti beno vwandaka banzenza na yinsi ya Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Na bamvula sambanu, konso mvula, nge ke sala bilanga ya nge mpe nge ke yonzika bambuma. ");
INSERT INTO mkw_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Kasi na mvula ya nsambwadi, nge ke bika bilanga yango samu na kupemisa yawu. Bamputu ya yinsi ya nge ke kwiza kudya mpe bibulu ya mfinda ke kwiza kudya madya yina ke bikana. Nge ke sala mutindu mosi samu na bilanga ya nge ya bayinti ya vinu mpe ya olive.» ");
INSERT INTO mkw_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«Nge ke sala bisalu ya nge na bilumbu sambanu, kasi kilumbu ya nsambwadi nge ke pema, samu ti ngombe na mbuluku ya nge kupema, bana ya kisadi ya nge ya kento na banzenza mpe kupema, samu na kuzwa dyaka ngolo.» ");
INSERT INTO mkw_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Beno sadila mbote mambu nyonso yina mu me tuba na beno. Beno kutanguna ve bankumbu ya banzambi ya nkaka. Bankumbu ya bawu kuwakana ata fyoti ve na bayinwa ya beno.» ");
INSERT INTO mkw_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Na konso mvula, beno ke sadila munu mikembo tatu. ");
INSERT INTO mkw_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Beno ke sala Mukembo ya Mampa yina kele ve na Levule. Na ntangu ya yawu, na ngonda Abibe, beno ke sala bilumbu nsambwadi na kudyaka mampa yina kele ve na levule. Beno ke kudya yawu mutindu mu tumisaka beno, samu ti ni na ngonda yina beno basikaka na yinsi ya Ngipiti. Beno ke kwiza talana ve na ntadisi ya munu maboko mpamba. ");
INSERT INTO mkw_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Beno ke sala mpe Mukembo ya Kubuka Bambuma, bambuma ya ntete ya bilanga ya beno. Na nsuka ya mvula, beno ke sala mpe Mukembo ya Kuyonzika yawu. Beno ke sala yawu na ntangu yina beno ke yonzikaka madya ya bilanga ya beno. ");
INSERT INTO mkw_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Na yina, konso mvula, babakala nyonso ke kwiza talana bambala tatu na ntadisi ya Yave, Mfumu.» ");
INSERT INTO mkw_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Ntangu beno ke pesa munkayulu, beno kupesa ve munu menga ya kuvukana na kima yina ba me funisa. Mafuta ya bibulu ya minkayulu yina beno ke pesa na minkembo ya munu, yawu fwana kukuma ve tii na suka ya kilumbu yina ke landa.» ");
INSERT INTO mkw_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","«Beno nata na Yinzo ya Yave, Nzambi ya beno, madya ya ntete-ntete ya bilanga ya beno. Beno lambila ve mbisi ya mwana ya nkombo na miliki ya mama ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Munu, mu ke fidisa beno mbazi ya munu na mantwala ya beno, samu na kwendaka kengidila beno na nzila, mpe samu na kukotisa beno na kisika yina mu kubikilaka beno. ");
INSERT INTO mkw_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Beno sala keba na ntadisi ya yandi. Beno tumama na yandi. Beno fwemisa yandi ve. Yandi ke lemvokila ve yimbi ya beno, samu ti yandi ke sala na nkumbu ya munu. ");
INSERT INTO mkw_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kana beno tumama na yandi, kana beno sadila nyonso yina mu ke tuba na beno, mu ke vwanda mbeni ya bambeni ya beno, mutantu ya mitantu ya beno.» ");
INSERT INTO mkw_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","«Mbazi ya munu ke tambula na mantwala ya beno. Yandi ke twadisa beno na kukwenda na yinsi ya ba-Amoli, ba-Yiti, ba-Pelizi, na yinsi ya ba-Kaanani, ba-Yivi, mpe na yinsi ya ba-Yebuse. Mu ke manisa na kufwa bawu. ");
INSERT INTO mkw_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Beno kufukama ve na mantwala ya banzambi ya bawu. Beno kusadila yawu ve. Beno kusala ve mutindu bawu ke salaka. Beno mwangisa biteki ya banzambi ya bawu, mpe beno kumwangisa matadi ya bawu yina bawu telemisaka mutindu bidimbu, mpe byekaka samu na kusambidilaka. ");
INSERT INTO mkw_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Beno ke sadila Yave, Nzambi ya beno. Yandi ke sakumuna madya mpe maza ya beno. Yandi ke katula bimbemvo na kati-kati ya beno. ");
INSERT INTO mkw_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Na yinsi ya beno, ata kento ke katuka kivumu mpe ata kento ke vwanda kisita. Mu ke sala ti beno kuvwanda na luzingu ya yinda.» ");
INSERT INTO mkw_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«Mikangu ya bantu ke kuma na boma ya kulutila ntangu ba ke kuwa ti beno ke na kukwiza. Bisika nyonso yina beno ke kota, mu ke sala ti bantu kukuma kidi-kidi. Mu ke sala ti bambeni nyonso ya beno kukima na mantwala ya beno. ");
INSERT INTO mkw_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mu ke fidisa banyosi samu na kubingisa ba-Yivi, ba-Kaanani mpe ba-Yiti, tekila beno kuma kuna. ");
INSERT INTO mkw_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mu ke bingisa bawu kaka na mvula mosi ve, samu ti yinsi kuvwanda ve kaka ntoto ya kukondwa bantu, mpe bibulu ya mfinda kukuma ve mingi, samu na kunwanisa beno. ");
INSERT INTO mkw_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mu ke bingisa bawu ndambu-ndambu tii ntangu yina beno ke kuma mingi samu na kufulusa yinsi. ");
INSERT INTO mkw_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mu ke pesa beno yinsi kubanda na mubu ya batwandu tii na Mubu ya ba-Filiseti, mpe kubanda na yinsi ya kuyuma tii na nzadi ya Efalate. Samu ti, mu ke yekula bantu ya yinsi na maboko ya beno, beno ke bingisa bawu na mantwala ya beno. ");
INSERT INTO mkw_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Beno kusala ve ngwisani na bawu to na banzambi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Bawu ke zinga ve na yinsi ya beno. Kana ve, bawu ke sala ti beno sumuka na ntadisi ya munu. Yawu lenda sala ti beno sadila banzambi ya bawu. Yawu ke mutambu samu na beno.» ");
INSERT INTO mkw_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yave tubaka na Moyize: «Yuluka na mongo, kwenda na sika ya munu Yave, nge na Aloni, Nadabe na Abiwu mpe makumi nsambwadi ya bakuluntu ya Isayeli. Ntangu beno ke kuma mwa pene-pene, beno ke fukama. ");
INSERT INTO mkw_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Na manima, kaka nge mosi Moyize ke belama na munu. Ba ya nkaka ke belama ve. Bantu ya Isayeli ke yuluka ve na nge na mongo.» ");
INSERT INTO mkw_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moyize kwendaka zabisa na bantu ya Isayeli mambu nyonso, mpe misiku yina Yave tubaka. Bantu nyonso vutulaka na Moyize mutindu yayi: «Beto ke sadila mambu nyonso yina Yave me tuba.» ");
INSERT INTO mkw_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moyize sonikaka mambu nyonso yina Yave tubaka. Yandi telamaka na suka-suka, mpe kuna na yisi ya mongo, yandi yidikaka kiyokolo ya minkayulu. Yandi bakaka matadi kumi na zole yina yandi telemisaka mutindu bidimbu, samu na bifumba kumi na zole ya bantu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Na manima, yandi tumisaka mwa ndambu ya bantwenya ya Isayeli na kupesa na Yave minkayulu ya kuyoka, mpe na kupesa yandi bangombe mutindu minkayulu ya kiwisa. ");
INSERT INTO mkw_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moyize bakaka ndambu ya menga mpe yandi tulaka yawu na bandonga ya nene. Ndambu ya menga yina bikanaka, yandi mwangisaka yawu na zulu ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Yandi bakaka dibuku ya ngwisani mpe yandi tangaka yawu na mantwala ya bantu ya Isayeli. Bawu tubaka: «Beto ke tumama na mambu nyonso yina Yave me tuba mpe beto ke sadila yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moyize bakaka menga, yandi mwangaka yawu na zulu ya bantu mpe yandi tubaka: «Yayi ni menga ya ngwisani yina Yave me sala na beno mutindu kele mambu nyonso yayi.» ");
INSERT INTO mkw_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Na manima, Moyize yulukaka na mongo, yandi na Aloni, Nadabe, Abiwu na makumi nsambwadi ya bakuluntu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ntangu bawu kumaka, bawu talaka Nzambi ya Isayeli. Na yisi ya makulu ya yandi, ya vwandaka mutindu matadi yina ba ke bokilaka safile, yina vwandaka lezima mutindu ke lezimaka zulu na kuvedila ya yawu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Nzambi salaka ve yimbi na bakuluntu ya Isayeli yina. Bawu talaka Nzambi mpe bawu kudyaka mpe kunwaka. ");
INSERT INTO mkw_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yave tubaka na Moyize: «Yuluka dyaka na mongo, na sika ya munu mpe vwanda kuna. Mu ke pesa nge matadi yina mu me sonika Musiku mpe bantumunu, samu ti nge longisa yawu na bantu.» ");
INSERT INTO mkw_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Na yina, Moyize telamaka na kilandi ya yandi Yeswa. Bawu yulukaka na mongo ya sika ya Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Tekila Moyize kukwenda, yandi tubaka na bakuluntu ya Isayeli: «Beno vingila beto awa tii ntangu yina beto ke vutukila beno. Aloni na Wule kele na beno kintwadi, muntu yina kele na dyambu, yandi kuzabisa yawu na sika ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ntangu Moyize yulukaka na mongo, dituti fukaka mongo. ");
INSERT INTO mkw_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Nkembo ya Yave kwizaka vwanda na zulu ya mongo ya Sinayi, mpe dituti fukaka mongo yina bilumbu sambanu. Na kilumbu ya nsambwadi, Yave bokilaka Moyize na kati-kati ya dituti. ");
INSERT INTO mkw_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Na meso ya bana ya Isayeli, nkembo yango ya Yave vwandaka talana mutindu tiya na zulu ya mongo, yina ke nyengisaka nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moyize kotaka na kati ya dituti na kutatamana na kwendaka yuluka mongo. Yandi vwandaka kaka kuna na mongo, bilumbu makumi yiya, mpimpa na ntangu. ");
INSERT INTO mkw_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Zabisa na bana ya Isayeli ba katula munu makabu na kati ya mvwilu ya bawu. Beno ke baka dikabu ya munu na konso muntu yina ke pesa yawu na ntima ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Makabu yina beno ke ndima na kubaka ke vwanda ni yayi: wolo, palata, bisengo ya mbwaki, ");
INSERT INTO mkw_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","balele ya ntinta ya dizulu mpe ya mwa mbwaki to ya mbwaki ya kulutila, balele ya mbote, balele ya mpusu ya nkombo ya nkento, ");
INSERT INTO mkw_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","bampusu ya mbwaki ya mameme ya mbakala, bampusu ya bambisi ya nene ya mubu, bayinti ya akasya, ");
INSERT INTO mkw_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mafuta samu na mwinda, bima yina ke pesaka nsunga samu na mafuta ya mbyekolo mpe ya mananasi ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","matadi ya onise na matadi ya nkaka ya ntalu, samu na Efode na peketolale, bikunti yina nganga-Nzambi ya ntete ke banda na kulwataka. ");
INSERT INTO mkw_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Bawu ke tungila munu Yinzo ya longo mpe mu ke kwiza zinga na kati-kati ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Mu ke lakisa nge mutindu Yinzo yango ke vwandila. Mu ke lakisa nge mpe mutindu ke vwandila bima nyonso yina beno ke tula na kati. Mutindu mu ke lakisa nge, kaka ni mutindu yina beno ke sala.» ");
INSERT INTO mkw_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Nge ke yidikila munu sanduku. Yawu ke vwanda ya mabaya ya yinti ya akasya. Yinda ya yawu ke vwanda ya Bakude zole na ndambu. Nene ya yawu ke vwanda ya Bakude zole na ndambu. Mutela ya yawu ke vwanda ya Kude mosi na ndambu. ");
INSERT INTO mkw_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Nge ke tula yawu wolo ya mbote na kati mpe na ngaanda. Bandilu ya yawu nyonso ke vwanda ya wolo. ");
INSERT INTO mkw_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Nge ke sulumuna wolo samu na kuyidikila yawu milunga yiya ya wolo. Nge ke tula milunga yango na bansongi nyonso yiya. Zole ke vwanda na lweka mosi mpe zole dyaka na lweka ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Nge ke yidika bayinti zole na yinti ya akasya. Nge ke tula yawu wolo. ");
INSERT INTO mkw_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Nge ke kotisa bayinti yango na kati ya milunga yango yina ke na balweka ya sanduku. Ni na bayinti yina ba ke banda na kunaguninaka sanduku. ");
INSERT INTO mkw_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Bayinti yina ke banda na kuvwandaka kaka na kati ya milunga ya sanduku. Ba ke katula yawu ve. ");
INSERT INTO mkw_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Na kati ya sanduku, nge ke tula matadi ya ngwisani yina mu ke pesa nge.» ");
INSERT INTO mkw_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Nge ke yidika kitapu ya wolo ya mbote na sanduku yina. Yinda ya yawu ke vwanda ya Bakude zole na ndambu. Nene ya yawu ke vwanda ya Kude mosi na ndambu. ");
INSERT INTO mkw_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Nge ke yidika bakeluba zole ya wolo ya ngolo. Nge ke tula yawu na bansongi nyonso zole ya kitapu. ");
INSERT INTO mkw_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Nge ke yidika keluba mosi na nsongi mosi ya kitapu. Nge ke yidika mpe keluba mosi dyaka na nsongi ya nkaka ya kitapu. Beno ke sala ti bakeluba nyonso zole na kitapu kuvwanda kaka kima mosi. ");
INSERT INTO mkw_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Bakeluba ke talisa mapapu ya bawu na zulu. Mapapu yango ke fuka kitapu, kisika ya kupesilaka minkayulu ya menga. Bakeluba ke vwanda ya kutalasana. Bizizi ya bakeluba ke talisa na kitapu. ");
INSERT INTO mkw_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Na kati ya sanduku yango, nge ke tula matadi ya ngwisani yina mu ke pesa nge. Nge ke tula kitapu na zulu ya sanduku. ");
INSERT INTO mkw_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ni kuna mu ke bwabana nge. Mu ke solola na nge na zulu ya kitapu, na kati-kati ya bakeluba yina kele na zulu ya sanduku yango ya ngwisani. Ni kuna mpe mu ke pesa nge bantumunu ya munu nyonso, samu na bana ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Nge ke yidika mesa. Nge ke yidikila yawu na mabaya ya yinti ya akasya. Yinda ya yawu ke vwanda ya Bakude zole. Nene ya yawu ke vwanda ya Kude mosi. Mutela ya yawu ke vwanda ya Kude mosi na ndambu. ");
INSERT INTO mkw_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Nge ke tula yawu wolo ya mbote. Bandilu ya yawu nyonso ke vwanda ya wolo: ");
INSERT INTO mkw_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","nge ke yidikila yawu ndilu ya Topale mosi. Na zulu ya ndilu yina, nge ke bongisa yawu na kutula dyaka ndilu ya nkaka ya wolo. Bandilu nyonso ke zungidila mesa. ");
INSERT INTO mkw_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Nge ke yidikila yawu milunga yiya ya wolo. Nge ke tula milunga na bansongi nyonso yiya ya makulu ya mesa. ");
INSERT INTO mkw_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Milunga yina ke vwanda pene-pene ya bandilu yango. Ni yawu ke yamba bayinti ya kunanguninaka mesa. ");
INSERT INTO mkw_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Bayinti yango, nge ke yidikila yawu na mabaya ya yinti ya akasya. Nge ke tula yawu wolo. Ni na yawu ba ke banda na kunanguninaka mesa. ");
INSERT INTO mkw_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Mesa yango, nge ke yidikila yawu bandonga, bakopo, bandonga ya fyoti, bambungu, samu na minkayulu ya vinu. Nge ke yidikila yawu na wolo ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Na zulu ya mesa yina, nge ke banda na kutulaka mampa yina ke pesama. Konso ntangu, mampa ke kondwa ve na mantwala ya munu.» ");
INSERT INTO mkw_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Nge ke yidika kitentokolo ya minda, ya wolo ya mbote. Kitentokolo yango ke vwanda ya wolo ya ngolo. Dikulu ya yawu, maboko ya yawu, mwa bambungu ya yawu, makolo ya yawu na bifulu ya yawu, nyonso ke vwanda kaka kima mosi. ");
INSERT INTO mkw_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Bintala sambanu ke vwanda ya kubasika na balweka ya yawu: bintala tatu-tatu na konso lweka ya kitentokolo ya minda. ");
INSERT INTO mkw_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Konso kintala ke vwanda na mwa bambungu tatu mutindu kifulu ke na kufunguka, na makolo mpe bifulu. Ni mutindu yina ke vwandila bintala nyonso sambanu ya kitentokolo ya minda. ");
INSERT INTO mkw_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na zulu ya yinti ya kati-kati ya kitentokolo ya minda, ya ke vwanda na mwa bandonga yiya mutindu kifulu ke na kufunguka, na makolo mpe bifulu. ");
INSERT INTO mkw_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Na yisi ya bintala zole ya ntete, ya ke vwanda na dikolo mosi. Dikolo mosi ke vwanda na bintala zole ya nkaka, dikolo mosi mpe na bintala zole ya nsuka. Bintala nyonso sambanu ya kitentokolo ya minda ke vwandila mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Makolo ya yawu na bintala ya yawu ke vwanda kaka kima mosi. Nyonso ke vwanda ya kuyilama na wolo ya ngolo, wolo ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Nge ke yidika minda nsambwadi. Ba ke tula yawu na zulu ya kitentokolo samu ti yawu kukyenzulaka na mantwala. ");
INSERT INTO mkw_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Bisimbulu ya minda mpe bima ya bombi ya yawu ke vwanda ya kuyilama na wolo ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ba ke sadila Talente mosi ya wolo ya mbote, samu na kuyidika kitentokolo ya minda na bima ya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Tala mpe sala mutindu kele kifwani yina ba me lakisa nge awa na mongo.» ");
INSERT INTO mkw_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Nge ke tunga Yinzo. Nge ke tungila yawu na balele kumi ya lino ya mbote. Nge ke vukisa yawu na mavunga ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Nge ke tunga bakeluba na zulu ya balele yina. Yawu ke vwanda kisalu ya bantu yina ke salaka yawu na bunkete nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Yinda ya konso lele ke vwanda ya makumi zole na nana ya Bakude, mpe nene ya yawu ke vwanda ya Bakude yiya. Balele nyonso ke vwanda yinda mosi mpe nene mosi. ");
INSERT INTO mkw_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Balele tanu ke vwanda ya kuvukana. Balele tanu ya nkaka mpe ke vwanda ya kuvukana. ");
INSERT INTO mkw_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Nge ke kanga basinga ya lino ya ntinta ya dizulu na ndilu ya nsuka ya balele tanu ya ntete. Nge ke sala mpe mutindu mosi na ndilu ya ntete ya balele tanu ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Nge ke kanga basinga makumi tanu na ndilu ya nsuka ya balele tanu ya ntete. Nge ke kanga mpe basinga makumi tanu na ndilu ya nsuka ya balele tanu ya nkaka. Basinga nyonso ke talasana. ");
INSERT INTO mkw_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Nge ke yidika bisimbulu makumi tanu ya wolo. Ni na bisimbulu yina nge ke vukisila balele tanu ya ntete na balele tanu ya nkaka, mpe muludi nyonso ke vukana. ");
INSERT INTO mkw_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«Nge ke tunga balele na mika ya bankombo samu na kufuka dyaka Yinzo yina. Nge ke sala yawu kumi na mosi. ");
INSERT INTO mkw_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Yinda ya konso lele ke vwanda ya Bakude makumi tatu, mpe nene ya yawu ke vwanda ya Bakude yiya. Balele nyonso ke vwanda yinda mosi mpe nene mosi. ");
INSERT INTO mkw_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Nge ke vukisa ntete balele tanu. Nge ke vukisa dyaka balele sambanu yina ke bikana. Nge ke sala ti na lele ya sambanu, ndambu ya nkaka kuvwanda mutindu ti yawu kele ya kubwa na mantwala ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Nge ke tula basinga makumi tanu ya kukangilaka na ndilu ya nsuka ya balele tanu ya ntete. Nge ke tula mpe basinga makumi tanu na ndilu ya ntete ya balele sambanu yina ke bikana. ");
INSERT INTO mkw_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Nge ke yidika makumi tanu ya bisimbulu ya kisengo ya mbwaki. Ni na mwa bisengo yina nge ke kanga basinga, samu na kuvukisa balele, mpe Yinzo nyonso ke vwanda ya kuvukana. ");
INSERT INTO mkw_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Balele ya muludi ke vwanda na yinda ya kulutila Yinzo na mwa ndambu. Ndambu ya balele ke kubwa na manima ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Na yinda ya Yinzo, balele ya muludi ke lutila na Kude mosi na konso lweka ya Yinzo samu na kufuka yawu. ");
INSERT INTO mkw_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Samu na kufuka dyaka Yinzo, nge ke sadila bampusu ya bankombo ya mbakala yina nge ke tula tinta ya mbwaki. Nge ke tula dyaka bampusu ya bambisi ya nene ya mubu na zulu ya yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«Nge ke yidika mabaya ya bayinti ya akasya samu na kusimba Yinzo. Mabaya yango ke vwanda ya kutelama mutindu kibaka. ");
INSERT INTO mkw_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Yinda ya dibaya mosi ke vwanda ya Bakude kumi. Nene ya yawu ke vwanda ya Kude mosi na ndambu. ");
INSERT INTO mkw_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Na yisi ya konso dibaya ke vwanda na bansongi zole ya kutelama mutindu mosi. Ni mutindu yina nge ke sala samu na mabaya nyonso ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Na mabaya yina ya Yinzo, makumi zole ke vwanda na lweka ya sude ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Nge ke yidika makumi yiya ya bisengo ya palata. Bisengo yina ke vwanda na yisi ya mabaya, samu na kukotisa bansongi nyonso zole ya dibaya. Ya ke vwanda bisengo zole na konso dibaya. ");
INSERT INTO mkw_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Na lweka ya nkaka ya Yinzo, lweka ya node, nge ke tula mpe mabaya makumi na zole. ");
INSERT INTO mkw_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Nge ke yidika mpe makumi yiya ya bisengo ya palata. Ya ke vwanda bisengo zole na yisi ya konso dibaya. ");
INSERT INTO mkw_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Samu na manima ya Yinzo, na lweka ya wesete, nge ke sala mabaya sambanu. ");
INSERT INTO mkw_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Nge ke bwela mabaya zole samu na bansongi ya manima ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Mabaya sambanu yina ke vwanda ya kuvukana na mabaya yina kele na bansongi kubanda na yisi tii na zulu. Nge ke sadila mulunga samu na kuvukisa yawu. Na bansongi nyonso zole, mabaya yango ke vwandila mutindu mosi. ");
INSERT INTO mkw_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Na yina, lutangu ya mabaya ke vwanda nana. Bisengo ya yawu ya palata ke vwanda kumi na sambanu. Bisengo zole samu na yisi ya konso dibaya.» ");
INSERT INTO mkw_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«Nge ke yidika bayinti tanu ya akasya samu na kusimba mabaya ya mbanzi, ya lweka mosi ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Nge ke yidika bayinti tanu samu na kusimba mabaya ya mbanzi ya lweka ya nkaka ya Yinzo. Nge ke yidika bayinti tanu samu na mabaya ya manima ya Yinzo, na lweka ya wesete. ");
INSERT INTO mkw_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Yinti ya mosi ya mfunu ke kota na kati ya mabaya, kubanda na dibaya ya nsongi ya manima tii na dibaya ya nsongi ya mantwala ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Nge ke tula wolo na mabaya. Milunga yina ke yamba bayinti ya bambanzi ke vwanda ya wolo. Nge ke tula wolo na bayinti ya balweka. ");
INSERT INTO mkw_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Nge ke yidika Yinzo mutindu kele kifwani yina ba me lakisa nge yawu awa, na zulu ya mongo.» ");
INSERT INTO mkw_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Nge ke yidika lele. Nge yidikila yawu na basinga ya lino ya mbote, ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Nge ke tunga bakeluba na zulu ya yawu. Yawu ke vwanda kisalu ya bantu yina ke salaka yawu na bunkete nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Nge ke tula lele ya mwelo ya kulelama na makunzi ya akasya. Makunzi yango ke vwanda yiya mpe nge ke tula wolo na makunzi yina. Nge ke tula mwa bisimbulu ya wolo samu na kusimba lele. Makunzi ke vwanda ya kutelama na zulu ya bisengo yiya ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Lele yango ke vwanda ya kukangama na yisi ya mwa bisimbulu yina.» «Ni kuna na manima ya lele nge ke tula Sanduku ya Ngwisani. Ni lele yina ke kabula kisika ya longo na kisika ya kulutila longo samu na beno. ");
INSERT INTO mkw_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Nge ke tula kitapu, kisika ya kupesilaka minkayulu ya menga, na zulu ya Sanduku ya Ngwisani, na kati ya kisika ya kulutila longo. ");
INSERT INTO mkw_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Nge ke tula mesa na kisika ya longo, na lweka ya node ya Yinzo. Kitentokolo ya minda ke vwanda na mantwala ya mesa, na lweka ya sude ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Samu na mwelo ya Yinzo, nge ke yidika lele na basinga ya lino ya mbote. Nge ke yidikila yawu na basinga ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Ya ke vwanda kisalu ya bantu yina ke tungaka na maboko. ");
INSERT INTO mkw_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Nge ke yidika makunzi tanu ya akasya samu na lele yina. Nge ke tula wolo na makunzi yango, mpe nge ke tula yawu bisimbulu ya wolo. Samu na makunzi yina, nge ke yidika bisengo tanu na kisengo ya mbwaki yina nge ke sulumuna na tiya.» ");
INSERT INTO mkw_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Nge ke yidika kiyokolo ya minkayulu. Nge ke yidikila yawu na mabaya ya yinti ya akasya. Yinda mpe nene ya yawu ke vwanda ya Bakude tanu na balweka nyonso. Mutela ya yawu ke vwanda ya Bakude tatu. ");
INSERT INTO mkw_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Na bansongi ya yawu nyonso yiya, nge ke yidika mampoka. Mampoka yango ke vwanda kaka kima mosi na yawu. Nge ke tula na zulu ya yawu kisengo ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Nge ke yidika bandonga samu na bombi mpe mafuta, bapele, bakopo, misoma na bandonga. Nge ke yidikila bisalulu nyonso yina na kisengo ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Nge ke yidika kitalaka ya kisengo ya mbwaki mutindu mpwasa. Nge ke tula yawu milunga yiya ya kisengo ya mbwaki na bansongi nyonso yiya. ");
INSERT INTO mkw_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Nge ke tula yawu na balweka ya kitalaka ya kiyokolo ya minkayulu, kubanda na yisi tii na kati-kati ya dibulu ya kiyokolo ya minkayulu, samu na kukotisaka bayinti. ");
INSERT INTO mkw_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Nge ke yidika bibuku ya bayinti ya akasya samu na kiyokolo ya minkayulu. Nge ke tula yawu kisengo ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ba ke kotisa bayinti yango na kati ya milunga. Bayinti yina ke vwanda na balweka nyonso zole ya kiyokolo ya minkayulu, samu na kunanguninaka yawu. ");
INSERT INTO mkw_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Na yina, kiyokolo yango, nge ke yidikila yawu na mabaya. Na kati-kati ya yawu ke vwanda mpamba mutindu dibulu. Ba ke yidika yawu mutindu kele kifwani yina mu me lakisa nge awa na zulu ya mongo.» ");
INSERT INTO mkw_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Nge ke yidika ngaanda ya kati ya lupangu. Samu na kuyidika ngaanda yina, nge ke tula balele ya lino ya mbote. Yinda ya balele yango ke vwanda ya Bakude nkama (100) samu na lweka ya ntete. ");
INSERT INTO mkw_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Yawu ke vwanda na makumi zole ya makunzi, na makumi zole ya bisengo ya yawu na yisi, ya kuyilama na bisengo ya mbwaki. Bisimbulu mpe mwa bayinti ya yawu ke vwanda ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Yawu ke vwandila mutindu mosi mpe samu na lweka ya node. Nge ke tula Bakude nkama (100). Yawu ke vwanda na makumi zole ya makunzi, na makumi zole ya bisengo ya yawu na yisi, ya kuyilama na bisengo ya mbwaki. Bisimbulu mpe mwa bayinti ya yawu ke vwanda ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Na yina me tadila nene ya lupangu, na lweka ya wesete, nge ke tula balele na Bakude makumi tanu. Yawu ke vwanda na makunzi kumi mpe bisengo ya yawu kumi na yisi. ");
INSERT INTO mkw_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Na nene ya lupangu, na lweka ya esete, ya ke vwanda mpe na Bakude makumi tanu. ");
INSERT INTO mkw_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Na lweka mosi ya nkotolo, ya ke vwanda na balele ya Bakude kumi na tanu. Yawu ke vwanda na makunzi tatu mpe bisengo ya yawu tatu na yisi. ");
INSERT INTO mkw_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Na lweka ya nkaka ya nkotolo, ke vwanda na balele ya Bakude kumi na tanu. Yawu ke vwanda na makunzi tatu mpe bisengo ya yawu tatu na yisi. ");
INSERT INTO mkw_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Samu na mwelo ya lupangu, nge ke tula lele ya Bakude makumi zole. Lele yango ke vwanda ya basinga ya lino ya mbote, ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Ya ke vwanda kisalu ya bantu yina ke tungaka na maboko. Lele yina ke vwanda na makunzi yiya mpe bisengo ya yawu yiya na yisi. ");
INSERT INTO mkw_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Makunzi nyonso ya lupangu ke vwanda na bisengo ya yawu ya mbwaki na yisi, na bisimbulu ya kuyilama na palata. Yawu ke vwanda mpe na mwa bayinti ya yawu ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Na yina, ngaanda ya lupangu ke vwanda na yinda ya Bakude nkama (100). Nene ya yawu ke vwanda ya Bakude tanu. Mutela ya balele ya lino ya mbote ke vwanda ya Bakude tanu. Bisengo ya yisi ya makunzi ke vwanda ya kusalama na kisengo ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Mpe, bima nyonso yina ba ke sadila na kati ya Yinzo ke vwanda ya kuyilama na bisengo ya mbwaki. Ya vwanda makunzi ya Yinzo, ya vwanda makunzi ya lupangu, nyonso ke vwanda ya kuyilama na bisengo ya mbwaki.» ");
INSERT INTO mkw_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Samu na minda, nge Moyize, nge ke tumisa bana ya Isayeli na kunatinaka nge, mafuta ya olive ya kulutila kitoko, samu ti minda vwanda ya kulema bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aloni na bana ya yandi ke tula kitentokolo ya minda na kati ya Yinzo ya Mbwabanu, na mantwala ya lele yina ke bumbaka Sanduku ya Ngwisani. Minda ke banda na kunamaka kubanda nkokila tii na suka, na mantwala ya munu Yave. Ntumunu yayi, bana ya Isayeli ke sadila yawu bambandu na bambandu.» ");
INSERT INTO mkw_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«Na kati ya bantu ya Isayeli, baka pene-pene ya nge, mpangi ya nge Aloni na bana ya yandi Nadabe, Abiwu, Eleyazale na Itamale, samu ti bawu kusala kisalu ya bunganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Nge ke yidikila mpangi ya nge Aloni binkuti ya longo mutindu bidimbu ya nkembo mpe ya bumfumu. ");
INSERT INTO mkw_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Nge ke zonza na bantu nyonso ya mayela, bayina mu me fulusa na mpeve ya ndwenga. Bawu ke yidika binkuti yina Aloni ke lwata ntangu ba ke byeka yandi, samu ti yandi kusala kisalu ya bunganga-Nzambi samu na munu. ");
INSERT INTO mkw_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Binkuti yina ba ke yidika ni yayi: peketolale, efode, dizwela, kiyunga ya kutunga na maboko, yimpu ya kinganga-Nzambi mpe mukaba. Ba ke yidika binkuti ya longo samu na mpangi ya nge Aloni mpe samu na bana ya yandi. Bawu ke banda na kulwataka yawu, samu na kusala kisalu ya bunganga-Nzambi samu na munu. ");
INSERT INTO mkw_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Bayina ke tunga yawu na maboko ke sadila basinga ya wolo, ya lino ya ntinta ya dizulu, ya mbwaki, ya mbwaki ya kulutila mpe ya lino ya mbote.» ");
INSERT INTO mkw_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Ba ke yidika efode. Ba ke yidikila yawu na basinga ya wolo, na lino ya ntinta ya dizulu, ya mbwaki, ya mbwaki ya kulutila, mpe na lino ya mbote. Ya ke vwanda kisalu ya bantu yina ke salaka yawu na bunkete nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Efode yango ke vwanda na basinga zole ya magembo, ya kutungama na balweka ya yawu. Ni basinga yina ke vukisa bitini zole ya efode. ");
INSERT INTO mkw_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mukaba yina ke vwanda na zulu ya efode ke vwanda kaka kima mosi na efode. Yawu mpe ke vwanda mutindu yayi: basinga ya wolo ya lino ya ntinta ya dizulu, ya mbwaki, ya mbwaki ya kulutila, mpe ya lino ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Nge ke baka matadi zole ya ntalu yina ba ke bokilaka onise mpe na zulu ya yawu, nge ke sonika bankumbu ya bana ya Yakobi. ");
INSERT INTO mkw_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Bankumbu sambanu ke vwanda na zulu ya ditadi ya ntete ya ntalu, bankumbu sambanu ya nkaka na zulu ya ditadi ya zole ya ntalu mutindu kele mbutukulu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Nge ke sonika bankumbu ya bana ya Yakobi na zulu ya matadi nyonso zole. Yawu ke vwanda kisalu ya muntu yina ke sadilaka matadi ya ntalu. Yandi ke fikula yawu mutindu ba ke yidikaka kinyemo. Nge ke tula matadi yango na kati ya bisimbulu ya wolo. ");
INSERT INTO mkw_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Nge ke tula matadi nyonso zole ya ntalu na basinga ya magembo ya efode, samu na kusala kidimbu ya bifumba kumi na zole ya bana ya Isayeli. Na yina Aloni ke nata bankumbu ya bawu na zulu ya magembo ya yandi, na mantwala ya munu Yave, samu ti mu kubambukilaka bawu moyo. ");
INSERT INTO mkw_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ntangu nge ke yidika bisimbulu yango ya wolo, ");
INSERT INTO mkw_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","nge ke yidikila yawu mwa bampanga zole ya wolo ya mbote. Nge ke yidika yawu mutindu ba ke kangaka bansuki ya maboko. Nge ke kanga mwa bampanga yina na bisimbulu yango.» ");
INSERT INTO mkw_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Nge ke yidika peketolale ya lufundusu. Yawu ke vwanda kisalu ya bantu yina ke salaka yawu na bunkete nyonso. Nge ke yidika peketolale kaka mutindu mosi na efode: na basinga ya wolo ya lino ya ntinta ya dizulu, ya mbwaki, ya mbwaki ya kulutila mpe ya lino ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ntangu ba ke futika yawu, balweka ya yawu nyonso ke vwanda mutindu mosi. Yinda ya yawu ke vwanda ya Epane mosi, nene ya yawu mpe ke vwanda ya Epane mosi. ");
INSERT INTO mkw_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Nge ke kotisa na kati ya peketolale, matadi ya ntalu na milonga yiya. Mulonga ya ntete: saledwane, topaze mpe emelode. ");
INSERT INTO mkw_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Mulonga ya zole: esekalebukele, lazulite mpe zasepe. ");
INSERT INTO mkw_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Mulonga ya tatu: opale, angate, mpe ametisete. ");
INSERT INTO mkw_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Mulonga ya yiya: kelizolite, onise mpe zasepe. Matadi nyonso yina ke vwanda na kati ya bisimbulu ya yawu ya wolo. ");
INSERT INTO mkw_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Nge ke sonika na zulu ya konso ditadi ya ntalu, nkumbu ya mosi na mosi ya bana kumi na zole ya Yakobi. Ya ke vwanda ya kusonama mutindu kinyemo. Konso ditadi ke vwanda na nkumbu mosi ya kifumba na kati ya bifumba kumi na zole ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Nge ke yidika mwa bampanga ya wolo ya mbote samu na peketolale. Nge ke yidika yawu mutindu ba ke kangaka bansuki ya maboko. ");
INSERT INTO mkw_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Nge ke yidika milunga zole ya wolo samu na peketolale. Nge ke tula yawu na bansongi zole ya peketolale. ");
INSERT INTO mkw_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Nge ke kanga mwa bampanga zole yina ya wolo na milunga zole na bansongi ya peketolale. ");
INSERT INTO mkw_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Nge ke kanga mpe bansongi nyonso zole ya nkaka na mwa bampanga yango, na bisimbulu yina kele na basinga ya magembo ya efode, na mantwala. ");
INSERT INTO mkw_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Nge ke yidika dyaka milunga zole ya wolo. Nge ke tula yawu na bansongi zole ya nkaka ya peketolale, na lweka ya kati yina ke vukanaka na efode. ");
INSERT INTO mkw_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Nge ke yidika dyaka milunga zole ya wolo. Nge ke tula yawu na yisi ya basinga ya magembo ya efode, na mantwala, pene-pene ya kisika yina ba tungaka yawu. Milunga yango ke vwanda na zulu ya mukaba ya efode. ");
INSERT INTO mkw_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ba ke kanga milunga ya peketolale mpe milunga ya efode na singa ya ntinta ya dizulu, samu na kukanga peketolale na mukaba ya efode. Na yina, peketolale ke katuka ve na kisika ya yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«Konso ntangu yina Aloni ke banda na kukotaka na kivinga ya longo, yandi ke lwata na ntulu ya yandi, bankumbu ya bana ya Yakobi yina kele ya kusonama na peketolale ya lufundusu. Yawu ke vwanda kidimbu ya kubambukilaka bawu moyo konso ntangu, na mantwala ya munu Yave. ");
INSERT INTO mkw_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Na kati ya peketolale ya lufundusu, nge ke tula bima ya longo yina ba ke bokilaka Ulime mpe Tumime. Yawu ke vwanda na ntulu ya Aloni ntangu yandi ke banda na kukwizaka na mantwala ya munu Yave. Bantangu nyonso, Aloni ke lwata na ntulu ya yandi bima yina yandi ke sadila samu na kuzaba luzolo ya munu Yave, samu na bana ya Yakobi.» ");
INSERT INTO mkw_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Nge ke yidika dizwela. Ni na zulu ya yawu nganga-Nzambi ke lwatila efode. Dizwela nyonso ke vwanda ya ntinta ya dizulu. ");
INSERT INTO mkw_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Yawu ke vwanda na dibulu na kati-kati samu na kukotisaka yintu. Ba ke futika bandilu ya dibulu yango mpe kutunga yawu. Ya ke vwanda kisalu ya muntu yina ke yidikaka balele na singa. Yandi ke tunga yawu mbote-mbote samu ti yawu kupasuka ve. ");
INSERT INTO mkw_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Na ndilu ya yisi ya dizwela, nge ke sala bifwani ya bambuma ya ngelenadine, ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Na kati-kati ya bambuma yina, nge ke tula mwa bangunga ya wolo, na ndilu nyonso ya yisi ya dizwela. ");
INSERT INTO mkw_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Mwa ngunga mosi ya wolo, kifwani ya mbuma mosi ya ngelenadine. Mwa ngunga mosi ya wolo, kifwani ya mbuma mosi ya ngelenadine. Ni mutindu yina nge ke sala na ndilu nyonso ya yisi ya dizwela. ");
INSERT INTO mkw_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aloni ke lwata dizwela yina, samu na kusalaka kisalu ya yandi ya bunganga-Nzambi. Ba ke kuwa makelele ya bangunga ntangu yandi ke kota na kivinga ya longo, na mantwala ya munu Yave, mpe ntangu yandi ke basika. Na yina, yandi ke kufwa ve.» ");
INSERT INTO mkw_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Nge ke yidika mwa kisengo ya wolo ya mbote. Nge ke sonika na zulu ya yawu mutindu ba ke salaka na kinyemo, mutindu yayi: “Ya kubyekwa na Yave”. ");
INSERT INTO mkw_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Nge ke sadila singa ya ntinta ya dizulu na kukanga mwa kisengo yango na yimpu ya kinganga-Nzambi, na mbunzu. ");
INSERT INTO mkw_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Yawu ke vwanda na mbunzu ya Aloni. Na yina, Aloni ke nata yimbi yina bana ya Isayeli ke sala ntangu bawu ke pesa munu minkayulu, mpe na yina me tadila bima nyonso ya longo yina ba ke pesa. Mwa kisengo yina ke banda na kuvwandaka kaka na mbunzu ya yandi na mantwala ya munu, samu ti mu ndima yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Nge ke yidikila Aloni kinkuti ya lino. Nge ke yidika yimpu ya kinganga-Nzambi ya lino. Nge ke yidika mpe mukaba ya lino. Ya ke vwanda kisalu ya muntu yina ke tungaka mbote na maboko.» ");
INSERT INTO mkw_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«Samu na bana ya Aloni, nge ke yidikila bawu mpe binkuti. Nge ke yidikila bawu mikaba, na bayimpu ya banganga-Nzambi, bidimbu ya nkembo mpe ya bumfumu.» ");
INSERT INTO mkw_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","«Nge ke lwatisa yawu mpangi ya nge Aloni na bana ya yandi. Nge ke dukula bawu mafuta, nge ke pesa bawu luve ya kusadila munu. Ni mutindu yina nge ke byeka bawu mpe bawu ke sadila munu kisalu ya bunganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Nge ke yidikila bawu mibati samu na kubumba bimpene ya bawu. Mibati yango ke banda na luketo tii na mabunda. ");
INSERT INTO mkw_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aloni na bana ya yandi ke lwata yawu ntangu bawu ke kota na Yinzo ya Mbwabanu. Bawu ke lwata yawu mpe na ntangu yina bawu ke belama na kiyokolo ya minkayulu, samu na kusala kisalu ya bawu, na kivinga ya longo. Na yina, bawu ke sala ve yimbi mpe bawu ke kufwa ve. Ya ke vwanda ntumunu ya bantangu nyonso samu na Aloni mpe samu na bambandu ya yandi yina ke kwiza.» ");
INSERT INTO mkw_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Tala mutindu nge ke sala na kubyeka Aloni mpe bana ya yandi ya babakala, samu ti bawu kusadila munu kisalu ya bunganga-Nzambi.» «Nge ke baka ngombe ya mbakala na mameme ya mbakala zole ya mbakala yina kele ve na bifuma. ");
INSERT INTO mkw_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Nge ke baka mampa yina kele ve na levule, na bagato ya kiputi ya faline yina ba me vukisa na mafuta, kasi ba ke funisa yawu ve. Nge ke baka mpe bagalete yina ba me funisa ve, yina ba me pakula mafuta. Nge ke sadila yawu na faline ya kitoko. ");
INSERT INTO mkw_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Nge ke tula yawu na kitunga mosi. Ni na kati ya kitunga yina nge ke pesila yawu. Nge ke nata mpe ngombe na mameme nyonso zole ya mbakala.» ");
INSERT INTO mkw_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«Nge ke nata Aloni na bana ya yandi ya babakala na mwelo ya Yinzo ya Mbwabanu. Nge ke yobisa bawu na maza. ");
INSERT INTO mkw_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Nge ke baka bikunti. Nge ke lwatisa Aloni kinkuti, dizwela, efode na peketolale. Nge ke kanga yandi yawu na mukaba ya efode. ");
INSERT INTO mkw_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Nge ke tula yandi yimpu ya kinganga-Nzambi na yintu. Nge ke tula kidimbu ya longo na zulu ya yimpu ya kinganga-Nzambi yina. ");
INSERT INTO mkw_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Nge ke baka mafuta ya mbyekolo, nge ke dukula yandi yawu na yintu mpe nge ke byeka yandi. ");
INSERT INTO mkw_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Nge ke tumisa bana ya Aloni ya babakala na kubelama. Nge ke lwatisa bawu binkuti. ");
INSERT INTO mkw_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Nge ke lwatisa Aloni na bana ya yandi mikaba. Nge ke tula bawu bayimpu ya bunganga-Nzambi na bayintu. Kisalu ya bunganga-Nzambi ke vwanda ya bawu. Ya kele ntumunu ya seko.» «Nge ke pesa Aloni mpe bana ya yandi luve ya kusadila munu. ");
INSERT INTO mkw_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Nge ke nata ngombe ya mbakala na mantwala ya Yinzo ya Mbwabanu. Aloni mpe bana ya yandi ke tentika maboko ya bawu na zulu ya yintu ya ngombe yango. ");
INSERT INTO mkw_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Nge ke zenga laka ya ngombe yango na mantwala ya Yave, kuna na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Nge ke baka menga ya ngombe. Na musapi ya nge, nge ke tula menga yina na zulu ya mampoka ya kiyokolo ya minkayulu. Menga yina ke bikana, nge ke mwanga yawu na kivwandulu ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Nge ke baka mafuta nyonso yina kele ya kuvukana na misopo, na mbala ya kivumu mpe na luketo. Nge ke yoka yawu na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Kasi mbisi ya ngombe, mpusu ya yawu na matufi yina kele na kati ya misopo, nge ke yoka yawu na tiya, ntama na kivwandu. Ya kele Munkayulu ya mulemvo.» ");
INSERT INTO mkw_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«Na manima, nge ke baka dimeme ya mbakala ya ntete. Aloni na bana ya yandi ke tentikaka maboko ya bawu na zulu ya yintu ya dimeme yango. ");
INSERT INTO mkw_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Nge ke zenga yawu laka. Nge ke mwanga menga ya yawu na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Nge ke sasa dimeme yango. Nge ke sukula misopo na makulu. Nge ke tula yawu na zulu ya bitini ya mbisi mpe na zulu ya yintu ya dimeme yina. ");
INSERT INTO mkw_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Nge ke yoka yawu na dimeme nyonso na kiyokolo ya minkayulu. Yawu kele Munkayulu ya Kuyoka ya nsunga ya mbote yina ke yangidikaka Yave, madya yina ba ke yokaka na tiya samu na Yave.» ");
INSERT INTO mkw_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«Na manima, nge ke baka dimeme ya zole. Aloni na bana ya yandi ke tentika maboko ya bawu na zulu ya yintu ya dimeme yango. ");
INSERT INTO mkw_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Nge ke zenga yawu laka. Nge ke baka menga ya yawu. Nge ke tula menga yina na zulu ya kitini ya banda ya dikutu ya lubakala ya Aloni, mpe ya bana ya yandi. Nge ke tula dyaka yawu na musapi ya nene ya maboko ya bawu ya lubakala, mpe na musapi ya nene ya makulu ya bawu ya lubakala. Nge ke mwanga menga na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Nge ke baka menga yina kele na zulu ya kiyokolo ya minkayulu, nge ke baka mpe mafuta ya mbyekolo. Nge ke mwanga yawu na nzutu ya Aloni mpe na binkuti ya yandi. Nge ke sala mutindu mosi mpe, na bana ya yandi mpe na bikunti ya bawu. Na yina, Aloni, bana ya yandi mpe bikunti ya bawu nyonso ke vwanda ya kubyekwa. ");
INSERT INTO mkw_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Nge ke baka mafuta ya dimeme yina ya zole. Nge ke baka yawu na: mukila, misopo, mbala ya kivumu, luketo mpe na kito ya manima ya lubakala. Ya kele dimeme ya mbyekolo. ");
INSERT INTO mkw_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Na kati ya kitunga ya mampa yina kele ve na levule, kitunga yina ba tulaka na mantwala ya Yave, nge ke baka dimpa na gato yina ke na mafuta na galete. ");
INSERT INTO mkw_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Nge ke tula yawu nyonso na maboko ya Aloni mpe ya bana ya yandi. Nge ke pesa yawu na Yave mutindu ba ke sadilaka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Na manima, nge ke baka dyaka yawu na maboko ya bawu. Mpe nge ke yoka yawu kintwadi na Munkayulu ya Kuyoka. Yawu kele munkayulu ya nsunga ya mbote yina ke yangidikaka Yave, madya yina ba ke yokaka na tiya samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Nge ke baka ntulu ya dimeme ya mbyekolo, yina kele samu na Aloni. Nge ke pesa yawu na Yave mutindu ba ke sadilaka na mantwala ya Yave. Kikunku yina ke vwanda ya nge.» ");
INSERT INTO mkw_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«Nge ke pesa ntulu ya dimeme mpe kito ya dikulu ya lubakala ya dimeme mutindu ba ke sadilaka na mantwala ya Yave, yawu kele ya Aloni na bana ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Kikunku yina ke vwanda ya Aloni na bana ya yandi. Ya kele ntumunu ya seko. Ba ke katula yawu na kati ya minkayulu yina bana ya Isayeli ke pesa munu. Yawu ke vwanda kikunku yina bana ya Isayeli ke katula na kati ya minkayulu ya kiwisa yina ba ke pesa. Yawu kele kikunku ya Yave.» ");
INSERT INTO mkw_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Na manima ya lufwa ya Aloni, binkuti ya yandi ya longo ke pesama na bana ya yandi. Bawu ke lwata yawu na kilumbu ya bawu ya mbyekolo, kilumbu yina ba ke pesa bawu luve ya kusala kisalu ya bawu ya bunganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Na kati ya bana ya Aloni, nganga-Nzambi yina ke yingana na manima ya yandi ke lwata binkuti yango bilumbu nsambwadi, ntangu yandi ke kota na Yinzo ya Mbwabanu, samu na kusala kisalu ya yandi na kati ya kivinga ya longo.» ");
INSERT INTO mkw_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Ntangu nge ke baka dimeme ya zole yina ya mbyekolo, nge ke lamba mbisi ya yawu na kisika mosi ya longo na kati ya ngaanda ya lupangu. ");
INSERT INTO mkw_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aloni na bana ya yandi ke kudya mbisi ya dimeme yango na mampa yina ke bikana na kitunga. Bawu ke kudya yawu kuna na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Kaka ni bawu ke kudya minkayulu yina ke pesama, samu ti ba pesa bawu luve ya kusala kisalu ya bawu ya bunganga-Nzambi, mpe ba byeka bawu. Ata muntu ya nkaka lenda kudya yawu ve, samu ti yawu kele bima ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kana mbisi yina ya munkayulu ya mbyekolo mpe mampa yina kuma tii na suka ya kilumbu yina ke landa, nge ke yoka yawu na tiya. Ba ke kudya yawu ve, samu ti yawu kele bima ya longo.» ");
INSERT INTO mkw_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«Nge ke sala nyonso samu na Aloni mpe na bana ya yandi mutindu mu me tumisa nge. Na kupesa bawu luve ya kusala kisalu ya bawu, yawu ke sala bilumbu nsambwadi.» ");
INSERT INTO mkw_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","«Konso kilumbu, nge ke pesa ngombe ya mbakala mutindu Munkayulu ya mulemvo, samu na kukatula masumu. Nge ke katula masumu na kiyokolo ya minkayulu ntangu nge ke sala nyonso yina me fwanana samu na kukatula masumu. Na manima, nge ke dukula yawu mafuta samu na kubyeka yawu. ");
INSERT INTO mkw_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Na bilumbu nsambwadi ya mbyekolo, nge ke sala nyonso yina me fwanana samu na kukatula masumu na kiyokolo ya minkayulu, mpe nge ke byeka yawu. Na yina, kiyokolo ya minkayulu ke vwanda ya longo mingi mpe nyonso yina ke simba yawu ke kuma ya longo.» ");
INSERT INTO mkw_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Konso kilumbu, nge ke banda na kupesaka na kiyokolo ya minkayulu, bana zole ya mameme ya mvula mosi, bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Nge ke pesa mwana mosi ya dimeme na suka, mwana ya nkaka ya dimeme na nkokila. ");
INSERT INTO mkw_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Na mwana ya ntete ya dimeme, nge ke tula kikunku mosi na kati ya bikunku kumi ya Efa ya kiputi ya faline ya kitoko, yina ba me balula na bikunku yiya na kati ya bikunku kumi ya Yine ya mafuta ya kitoko. Nge ke tula mpe munkayulu ya bikunku yiya na kati ya bikunku kumi ya Yine ya vinu. ");
INSERT INTO mkw_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Na mwana ya nkaka ya dimeme, yina nge ke pesa na nkokila, nge ke sala mutindu mosi na munkayulu ya suka. Nge ke tula Munkayulu ya madya ya bilanga na munkayulu ya vinu. Yawu kele munkayulu ya nsunga ya mbote yina ke yangidikaka Yave, madya yina ba ke yokaka na tiya samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ya kele Munkayulu ya Kuyoka, ya kupesaka bilumbu nyonso, na bambandu ya beno nyonso. Beno ke banda na kupesaka yawu kuna na mwelo ya Yinzo ya Mbwabanu, na mantwala ya munu Yave. Ni na kisika yina mu ke banda na kubwabanaka beno samu na kuzonza na nge.» ");
INSERT INTO mkw_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","«Ni kuna mu ke banda na kubwabanaka bana ya Isayeli. Kisika yina ke vwanda ya kubyekwa na nkembo ya munu. ");
INSERT INTO mkw_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Mu ke byeka Yinzo ya Mbwabanu mpe kiyokolo ya minkayulu. Mu ke byeka Aloni na bana ya yandi, samu ti bawu kusadila munu kisalu ya bunganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mu ke zinga na kati-kati ya bana ya Isayeli. Mu ke vwanda Nzambi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Na yina, bawu ke zaba ti mu kele Yave, Nzambi ya bawu, munu yina basisaka bawu na yinsi ya Ngipiti, samu ti mu zinga na kati-kati ya bawu.» «Mu kele Yave, Nzambi ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Nge ke yidika Mesa ya kuyokilaka maaka ya nsunga ya mbote. Nge ke yidikila yawu na mabaya ya yinti ya akasya. ");
INSERT INTO mkw_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Yinda mpe nene ya yawu ke vwanda ya Kude mosi na balweka nyonso. Mutela ya yawu ke vwanda ya Bakude zole. Mampoka ya yawu ke vwanda kaka kima mosi na yawu. ");
INSERT INTO mkw_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Nge ke tula yawu nyonso wolo ya mbote, na balweka ya yawu mpe na mampoka ya yawu. Zulu ya yawu mpe ndilu ya yawu ke vwanda ya wolo. ");
INSERT INTO mkw_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Nge ke yidika milunga zole ya wolo na yisi ya ndilu, na lubakala mpe na lumoso. Nge ke sala yawu na balweka nyonso zole yina, samu na kukotisaka bayinti ya kunanguninaka yawu. ");
INSERT INTO mkw_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Nge ke yidika bayinti na mabaya ya akasya. Nge ke tula yawu wolo. ");
INSERT INTO mkw_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Nge ke bika mesa yina ya kuyokilaka maaka ya nsunga ya mbote na mantwala ya lele yina ke bumbaka Sanduku ya Ngwisani na kitapu ya yawu. Ni kuna mu ke banda na kubwabanaka nge. ");
INSERT INTO mkw_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ni kuna Aloni ke banda na kuyokilaka maaka ya nsunga ya mbote. Yandi ke banda na kuyokaka yawu konso suka ntangu yandi ke kwizaka yidika minda. ");
INSERT INTO mkw_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Na konso nkokila mpe, Aloni ke banda na kuyokaka maaka ya nsunga ya mbote, ntangu yandi ke kwizaka namisa minda. Bantangu nyonso, mpe na bambandu nyonso ya beno, beno ke banda na kuyokaka maaka ya nsunga ya mbote na mantwala ya munu, Yave. ");
INSERT INTO mkw_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kuna na mesa ya maaka ya nsunga ya mbote, beno fwana kuyoka ve: maaka ya nkaka yina kele ve ya kufwanakana, Munkayulu ya Kuyoka, Munkayulu ya madya ya bilanga, mpe munkayulu ya vinu. ");
INSERT INTO mkw_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Mbala mosi na mvula, Aloni ke banda na kusalaka nyonso yina me fwanana, samu na kukatula masumu na zulu ya mesa yina ya maaka ya nsunga ya mbote. Yandi ke kusa menga na zulu ya mampoka ya mesa, menga ya kibulu yina me pesama samu na mulemvo ya masumu. Yawu ke banda na kusalamaka mbala mosi na mvula, na bambandu nyonso ya beno. Mesa yayi kele kima ya longo mingi samu na munu Yave.» ");
INSERT INTO mkw_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yave tubaka dyaka na Moyize mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Ntangu nge ke sala lutangusu ya bana ya Isayeli, konso muntu ya Isayeli ke futa mpaku, samu na nkudulu ya luzingu ya yandi mosi, ntangu yina ba ke tanga yandi. Na yina, kiyoolo mosi ve ke kuzwa bawu na ntangu ya lutangusu yango. ");
INSERT INTO mkw_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Konso muntu yina ke kota na lutangusu fwana kupesila mutindu yayi: ndambu ya Sekele, mutindu kele Sekele yina ba ke sadilaka na Yinzo ya longo, yawu kele ya Bangela makumi zole. Mpaku ya mwa kisengo yina ya palata ke pesama samu na munu Yave. ");
INSERT INTO mkw_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Konso muntu yina ke kwiza na lutangusu yina, kubanda bamvula makumi zole tii na zulu, fwana kufuta mpaku ya Yave. ");
INSERT INTO mkw_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Mvwama ke futa ve mbongo ya kulutila. Mputu mpe ke futa ve mbongo yina kele fyoti na mbongo ya bisengo. Bawu ke futa mpaku yina ya Yave, samu na nkudulu ya luzingu ya bawu mosi. ");
INSERT INTO mkw_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Na yina, ntangu nge ke lokota mbongo yango ya bisengo samu na nkudulu, na sika ya bana ya Isayeli, nge ke sadila yawu samu na bansatu ya Yinzo ya Mbwabanu. Yawu ke vwanda kidimbu yina mu ke bambukilaka bana ya Isayeli moyo, na mantwala ya munu Yave, samu na nkudulu ya luzingu ya bawu mosi.» ");
INSERT INTO mkw_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Nge ke yidika ndonga ya nene. Nge ke yidikila yawu na kisengo ya mbwaki, na kivwandulu ya yawu ya kisengo ya mbwaki samu na kuvedisilaka nzutu. Nge ke tula yawu na kati-kati ya Yinzo ya Mbwabanu na kiyokolo ya minkayulu. Nge ke tula maza na kati. ");
INSERT INTO mkw_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aloni na bana ya yandi ke sadila maza yina samu na kusukulaka maboko mpe makulu. ");
INSERT INTO mkw_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Tekila bawu kota na Yinzo ya Mbwabanu, bawu ke yobila maza yina, samu ti bawu kufwa ve. Bawu ke sala mutindu mosi ntangu bawu ke belama na kiyokolo ya minkayulu samu na kusala kisalu, mpe samu na kuyoka madya yina ba ke yokaka kuna samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Bawu ke sukula maboko na makulu samu ti bawu kufwa ve. Yawu kele ntumunu ya bantangu nyonso samu na Aloni mpe samu na bana ya yandi na bambandu nyonso ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yave tubaka dyaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Baka mananasi ya nsunga ya mbote ya kulutila: bakilo tanu ya mananasi yina ba ke bokilaka mile, yina ke tangaka mutindu maza, bakilo zole na ndambu ya mananasi yina ba ke bokilaka sinamome, bakilo zole na ndambu ya mananasi yina ba ke bokilaka kanele, ");
INSERT INTO mkw_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","bakilo tanu ya mananasi yina ba ke bokilaka kase. Nge ke fwanikisa yawu na Sikele yina ba ke sadilaka na Yinzo ya longo. Nge ke baka mpe Yine mosi ya mafuta ya olive. ");
INSERT INTO mkw_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Nge ke sadila mananasi nyonso yina samu na kuyidika mafuta ya longo. Kuvukisa mananasi yina, ya kele kisalu ya bisadi-mananasi. Ni yawu ke vwanda mafuta ya mbyekolo ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ni na mafuta yina nge ke sadila samu na kubyekaYinzo ya Mbwabanu, Sanduku ya Ngwisani, ");
INSERT INTO mkw_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","mesa ya mampa na bisalulu ya yawu nyonso, kitentokolo ya minda na bisalulu ya yawu, mesa ya maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kiyokolo ya minkayulu na bisalulu ya yawu nyonso mpe ndonga ya nene na kivwandulu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ni mutindu yina nge ke byeka yawu mpe yawu ke vwanda ya longo mingi. Nyonso yina ke simba yawu ke kuma ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Na manima, nge ke dukula Aloni mpe bana ya yandi ya babakala mafuta. Nge ke byeka bawu samu ti bawu kusadila munu kisalu ya bunganga-Nzambi.» ");
INSERT INTO mkw_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","«Nge ke tuba na bana ya Isayeli mutindu yayi: “Mafuta yayi ke vwanda mafuta ya longo ya mbyekolo ya bantu na sika ya munu. Yawu ke vwandila mutindu yina na bambandu nyonso ya beno. ");
INSERT INTO mkw_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Muntu ya nkaka ve ke pakula yawu na nzutu. Muntu ve ke yidika mafuta ya mutindu yina, samu ti ya kele mafuta ya longo. Yawu fwana kuvwanda ya longo samu na beno. ");
INSERT INTO mkw_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kana muntu yidika mafuta ya mutindu yayi to yandi pakula yawu na nzutu ya muntu yina kele ve nganga-Nzambi, ba ke katula yandi na kimvuka ya bantu ya Isayeli.”» ");
INSERT INTO mkw_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yave tubaka dyaka na Moyize: «Baka maaka ya nsunga ya mwa bayinti yayi: setolakese, ambele, ngalebanume ya nsunga ya mbote mpe maaka ya nsunga ya kitoko. Nge ke tula yawu nyonso na bitezo mosi. ");
INSERT INTO mkw_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Nge ke yidika maaka ya nsunga ya mbote. Yawu kele kisalu ya bisadi-mananasi. Yawu ke vwanda ya kuvukana na mungwa. Yawu ke vwanda ya kuvedila mpe ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Nge ke nika ndambu ya yawu. Nge ke tula yawu na kivinga ya longo, na mantwala ya Sanduku ya Ngwisani, kisika yina mu ke banda na kwizaka bwabana nge. Yawu ke vwanda samu na beno kima ya longo mingi. ");
INSERT INTO mkw_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Beno kuyidika ve maaka ya nsunga ya mbote ya mutindu mosi na yayi samu na beno mosi. Beno bakila yawu mutindu kima ya kubyekwa kaka na munu, Yave. ");
INSERT INTO mkw_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Muntu yina ke yidika maaka ya mutindu mosi na yayi, samu na kuwa nsunga ya yawu, ba ke katula yandi na kimvuka ya bantu ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yave tubaka na Moyize mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Tala, mu me bokila Besalele, mwana ya Uli, mutekolo ya Wule, muntu ya kifumba ya Yuda, na nkumbu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Mu me fulusa yandi na mpeve ya munu Nzambi, na ndwenga na mayela mpe luzabu ya kusala mbote bisalu ya mutindu na mutindu: ");
INSERT INTO mkw_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","kuzaba na kuyidika bima, kusadila wolo, kusadila palata, kusadila kisengo ya mbwaki, ");
INSERT INTO mkw_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kuzaba na kupasula matadi ya ntalu mpe kusadila yawu, kusadila mabaya, mpe kuzaba na kusala bisalu ya mutindu na mutindu. ");
INSERT INTO mkw_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Mu me pesa yandi mpe kisadisi, Owolyabe, mwana ya Ayisamake ya kifumba ya Dane. Mu me pesa ndwenga mpe na bantu ya nkaka, mayela ya kusala, samu ti bawu kusala mbote na ludedomo nyonso yina mu me tumisa nge na: ");
INSERT INTO mkw_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Yinzo ya Mbwabanu, Sanduku ya Ngwisani, kitapu yina kele na zulu ya Sanduku ya Ngwisani mpe bisalulu nyonso ya Yinzo ya Mbwabanu, ");
INSERT INTO mkw_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","mesa ya mampa mpe bisalulu ya yawu, kitentokolo ya wolo ya mbote ya minda mpe bisalulu ya yawu, mesa ya kuyokilaka maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kiyokolo ya minkayulu mpe bisalulu ya yawu nyonso, ndonga ya nene mpe kivwandulu ya yawu, ");
INSERT INTO mkw_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","binkuti ya minkembo, binkuti ya longo ya nganga-Nzambi Aloni, binkuti yina ke lwata bana ya yandi ya babakala, samu na kusala kisalu ya bunganga-Nzambi, ");
INSERT INTO mkw_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mpe mafuta ya mbyekolo na maaka ya nsunga ya mbote samu na kivinga ya longo. Bawu ke sala mutindu kele mambu nyonso yina mu me tumisa nge.» ");
INSERT INTO mkw_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yave tubaka dyaka na Moyize mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Zonza na bana ya Isayeli: “Na zulu ya nyonso yina, beno zitisa basaba ya munu. Yawu kele kidimbu na kati-kati ya beno na munu na bambandu nyonso ya beno, samu ti beno zaba ti mu kele Yave mpe ti beno kele bantu yina mu me tula na lweka, samu ti beno vwanda mvwilu ya munu. ");
INSERT INTO mkw_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Beno zitisa kilumbu ya saba. Yawu kele ya longo samu na beno. Muntu yina ke sumuna yawu, kaka kufwa ba fwana kufwa yandi. Muntu ni muntu yina ke sala kisalu na kilumbu yina, ba ke katula yandi na kimvuka ya bantu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Beno ke sala bisalu ya beno na bilumbu sambanu. Kasi kilumbu ya nsambwadi kele kilumbu ya saba, kilumbu ya kupema, kilumbu ya kubyekwa na munu Yave. Muntu ni muntu yina ke sala na kilumbu ya saba, kaka kufwa ba fwana kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Bana ya Isayeli ke zitisa kilumbu ya saba. Bawu fwana kukembilaka Saba na bambandu nyonso ya bawu. Ya kele mutindu kidimbu ya ngwisani ya bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ya ke vwanda kidimbu ya bantangu nyonso na munu na bana ya Isayeli, samu ti na bilumbu sambanu, Yave yidikaka zulu na ntoto, mpe na kilumbu ya nsambwadi, yandi bikaka kisalu, yandi pemaka.» ");
INSERT INTO mkw_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Na manima ya kumanisa na kuzonza na Moyize, kuna na mongo ya Sinayi, Nzambi pesaka Moyize matadi zole ya ngwisani. Na matadi yina, Nzambi sonikaka yandi mosi na musapi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Bantu ya Isayeli talaka ti Moyize vwandaka zingila mingi na kukulumuka mongo. Na yina, bawu kwendaka yonzama na sika ya Aloni mpe bawu tubaka na yandi: «Yidikila beto nzambi yina ke twadisa beto, samu ti Moyize, muntu yina me basisa beto na yinsi ya Ngipiti, beto zaba ve yinki me kumina yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aloni vutulaka na bawu: «Kana ni mutindu yina, beno baka binzembele ya wolo yina kele na makutu ya bakento ya beno, ya bana ya beno ya babakala mpe ya bana ya beno ya bakento. Beno natina munu yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Bantu nyonso ya Isayeli katulaka binzembele ya wolo yina vwandaka na makutu ya bawu. Bawu nataka yawu na sika ya Aloni. ");
INSERT INTO mkw_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aloni bakaka wolo yina. Yandi sulumunaka yawu na tiya, yandi tutaka yawu na kisengo, samu na kuyidika kiteki ya mwana ya ngombe. Na manima, bantu tubaka: «Bantu ya Isayeli, nzambi ya nge yina basisaka nge na Ngipiti yandi yayi!» ");
INSERT INTO mkw_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ntangu Aloni talaka dyambu yina, yandi tungaka kiyokolo ya minkayulu na mantwala ya kiteki yina. Yandi lookaka mutindu yayi: «Mbasi ke vwanda kilumbu ya mukembo samu na Yave!» ");
INSERT INTO mkw_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Na kilumbu yina landaka, bawu vumbukaka na suka-suka. Bawu pesaka minkayulu ya kuyoka. Bawu pesaka mpe minkayulu ya kiwisa. Na manima, bawu vwandaka samu na kudya mpe kunwa. Mpe bawu telamaka samu na kuyangalala. ");
INSERT INTO mkw_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Kaka na ntangu yina mpe, Yave tubaka na Moyize: «Kwenda, kulumuka na nswalu, samu ti bantu ya nge yina nge basisaka na yinsi ya Ngipiti, bawu ke na kusala masumu ya nene.» ");
INSERT INTO mkw_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","«Na kusala mutindu yina, bawu me bika na nswalu nzila yina mu lakisaka bawu. Bawu me yidika mwana ya ngombe na bisengo ya kusulumuka. Bawu me fukama na mantwala ya yawu. Bawu me pesa yawu minkayulu mpe bawu me tuba: “Bantu ya Isayeli, nzambi ya nge yina basisaka nge na Ngipiti yandi yayi!”.» ");
INSERT INTO mkw_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yave tubaka dyaka na Moyize: «Mu ke na kutala ti bantu yayi kele bantu ya yintu ngolo. ");
INSERT INTO mkw_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ntangu yayi, bika ti munu mosi mu sala. Mu ke dasukila bawu. Mu ke manisa na kufwa bawu. Kasi mu ke sala ti dikanda ya nge kuvwanda nene.» ");
INSERT INTO mkw_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moyize sosaka na kulembisa ntima ya Yave, Nzambi ya yandi. Yandi tubaka: «Yave, samu na yinki nge ke na kudasukila bantu ya nge, yina nge basisaka na yinsi ya Ngipiti, na lulendo ya nge ya nene? Nge sadilaka ve ngolo ya nge samu na bawu? ");
INSERT INTO mkw_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kana nge sala mutindu yina, bantu ya Ngipiti ke tuba: “Ni samu na kutalisa bawu mpasi, kufwa bawu na myongo, kumanisa na kufwa bawu mpe kuzimbisa bawu na ntoto, yandi vwandaka me basisa bawu na Ngipiti”! Na yina, bika nkele ya nge ya kulutila. Bika na kutalisa bantu ya nge mpasi. ");
INSERT INTO mkw_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Bambuka moyo na bisyelo ya nge Abalayami, Isaaki mpe Yakobi, bayina nge diilaka ndefi na nkumbu ya nge mosi na kutuba: “Mu ke sala ti beno kuma mingi mutindu bambwetete ya mazulu. Mu ke pesa na makanda ya beno yinsi nyonso yina mu zonzilaka. Yawu ke vwanda mvwilu ya bawu ya bantangu nyonso.”» ");
INSERT INTO mkw_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Na yina, Yave bikaka dibanza yina yandi kuzwaka ya kutalisa bantu ya yandi mpasi. ");
INSERT INTO mkw_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Na manima, Moyize kulumukaka mongo na matadi nyonso zole ya ngwisani na maboko. Konso ditadi vwandaka ya kusonama na balweka nyonso zole. ");
INSERT INTO mkw_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Matadi yina, ni Nzambi yidikaka yawu. Bisono yina, ya vwandaka bisono ya Nzambi, yina yandi sonikaka na zulu ya matadi. ");
INSERT INTO mkw_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ntangu Yeswa vwandaka kulumuka na Moyize, yandi kuwaka makelele yina bantu vwandaka sala, yandi tubaka na Moyize: «Makelele ya mvita ke na kuwakana na kivwandu ya bantu ya beto.» ");
INSERT INTO mkw_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moyize vutulaka: «Ve, ya kele ve makelele ya mikunga ya bantu yina me nunga. Ya kele mpe ve makelele ya mikunga ya bantu yina ba me nunga. Kasi ya kele makelele ya mikunga ya kidi-kidi mu ke na kuwa!» ");
INSERT INTO mkw_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ntangu Moyize vwandaka belama na kivwandu, yandi talaka kiteki ya wolo ya mwana ya ngombe mpe bantu yina vwandaka bina. Na yina, Moyize dasukaka. Yandi losaka matadi yina vwandaka na yandi na maboko. Yandi mwangisaka yawu na yisi ya mongo. ");
INSERT INTO mkw_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Moyize bakaka kiteki yango yina ba yidikaka. Yandi yokaka yawu na tiya. Yandi nikaka yawu tii yawu kumaka fundu-fundu. Yandi mwangisaka yawu na zulu ya maza mpe yandi nwikisaka bana ya Isayeli maza yango. ");
INSERT INTO mkw_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moyize yufulaka na Aloni: «Yinki bantu yayi me sala nge tii na kukotisa bawu na disumu yayi ya nene?» – ");
INSERT INTO mkw_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aloni vutulaka: «Mfumu ya munu, kudasuka ve. Nge mosi nge zaba ti bantu yayi ke kwendaka ve ntama na kusala yimbi. ");
INSERT INTO mkw_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bawu me kwiza zabisa munu: “Yidikila beto nzambi yina ke twadisa beto, samu ti Moyize yina basisaka beto na yinsi ya Ngipiti, beto zaba ve yinki me kumina yandi”. ");
INSERT INTO mkw_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Mu yufulaka bawu: “Na kati ya beno, banani kele na wolo?” Na mbala mosi, bawu katulaka binzembele yina vwandaka na bawu, mpe bawu pesaka munu yawu. Mu tulaka yawu na tiya. Ni kuna kiteki ya mwana ya ngombe yayi salamaka.» ");
INSERT INTO mkw_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moyize talaka ti bantu ya Isayeli kumaka na muvusu, samu ti Aloni bikaka ti bawu kukuma na muvusu ya mutindu yina. Na yina, Moyize talaka ti mitantu ya yandi lendaka talisa yandi nsoni. ");
INSERT INTO mkw_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moyize kwendaka telama na nkotolo ya kivwandu. Yandi tubaka: «Bayina kele bantu ya Yave, bawu kwiza na sika ya munu!» Na yina, bana nyonso ya Levi kwizaka yonzama na sika ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Moyize tubaka na bawu: «Yave, Nzambi ya Isayeli ke na kutuba: “Konso muntu na kati ya beno kubaka mbele ya yandi ya mvita. Beno tambula na kati ya kivwandu nyonso, beno lutila na konso mwelo. Beno kufwa bampangi ya beno, bandiku ya beno, mpe bamfinangani ya beno.”» ");
INSERT INTO mkw_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Na yina, bana ya Levi salaka mutindu Moyize zonzaka. Na kilumbu yina, keba ve mafunda tatu (3 000) ya bantu kufwaka na kati ya bantu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moyize tubaka: «Bubu yayi, beno me kuzwa luve ya kukota na kisalu ya Yave. Na kati ya dyambu yayi, konso muntu na kati ya beno me kufwa mwana to mpangi. Ni yawu yina, Yave me pesa beno lusakumunu bubu yayi.» ");
INSERT INTO mkw_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Na kilumbu yina landaka, Moyize tubaka na bantu ya Isayeli: «Beno me sala disumu ya nene. Ntangu yayi, mu ke yuluka na mongo na sika ya Yave. Mu zaba ve kana mu lenda sala nyonso yina me fwanana samu na mulemvo ya disumu ya beno.» ");
INSERT INTO mkw_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Na yina, Moyize vutukaka na sika ya Yave, mpe yandi tubaka: «Bantu yayi me sala disumu ya nene. Bawu me yidika nzambi ya bawu ya wolo. ");
INSERT INTO mkw_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ntangu yayi, lemvokila disumu ya bawu. Kana ve, katula kwandi nkumbu ya munu na kati ya dibuku ya nge, dibuku yina nge sonikaka.» ");
INSERT INTO mkw_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yave vutulaka na Moyize: «Muntu yina mu ke katula nkumbu na dibuku ya munu, ni muntu yina me sala disumu na ntadisi ya munu. ");
INSERT INTO mkw_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ntangu yayi, kwenda. Nata bantu na kisika yina mu me zonzila nge. Mbazi ya munu ke tambula na mantwala ya nge. Kasi kilumbu kele, yina mu ke pesa bawu kitumbu, samu na disumu ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Na yina, Yave pesaka bantu ya Isayeli kitumbu, samu ti bawu yidikaka kiteki ya mwana ya ngombe ya wolo, mwana ya ngombe yina Aloni yidikaka. ");
INSERT INTO mkw_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yave tubaka na Moyize: «Kwenda, nge na bantu yina nge basisaka na Ngipiti. Katuka awa samu na kukwenda na yinsi yina mu salaka nsilulu na Abalayami, na Isaaki mpe na Yakobi ntangu mu kudyaka ndefi na kutuba ti: “Mu ke pesa yawu na bana ya nge”. ");
INSERT INTO mkw_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mu ke fidisa mbazi ya munu na mantwala ya beno. Mu ke bingisa ba-Kaanani, ba-Amoli, ba-Yiti, ba-Pelizi, ba-Yivi na ba-Yebuse. ");
INSERT INTO mkw_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Beno kwenda na yinsi ya kufuluka na miliki na mafuta ya nyosi. Munu, mu ke kwenda ve na beno. Kana ve, mu lenda manisa na kufwa beno na nzila, samu ti beno kele bantu ya yintu ngolo.» ");
INSERT INTO mkw_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ntangu bantu ya Isayeli kuwaka mambu yayi ya kyadi, bawu kotaka kifwidi. Muntu ve lwataka binzembele to bampanga ya yandi, ");
INSERT INTO mkw_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","samu ti Yave tubaka na Moyize: «Zonza na bantu ya Isayeli: “Beno kele bantu ya yintu ngolo. Kana mu meka na kukwenda na beno, mu ke manisa na kufwa beno. Ntangu yayi, beno katula binzembele to bampanga ya beno. Na manima, mu ke tala yinki mu ke sala beno”.» ");
INSERT INTO mkw_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Na yina, bana ya Isayeli vwandaka lwata dyaka ve binzembele na bampanga ya bawu kubanda na kilumbu yina bawu katukaka na mongo ya Olebe. ");
INSERT INTO mkw_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moyize kwendaka baka yinzo mosi ya lele mpe yandi kwendaka tula yawu mwa ntama na kivwandu. Yandi bokilaka yawu Yinzo ya Mbwabanu. Konso muntu yina vwandaka na nsatu ya kuzaba luzolo ya Yave, yandi vwandaka kwenda kuna na Yinzo yango ya Mbwabanu. Yinzo yango vwandaka mwa ntama na kivwandu. ");
INSERT INTO mkw_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Konso ntangu yina Moyize vwandaka kwenda na Yinzo yina ya Mbwabanu, bantu nyonso ya Isayeli vwandaka telama, konso muntu na mantwala ya yinzo ya yandi. Bawu vwandaka tala Moyize tii ntangu yandi vwandaka kota na Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ntangu Moyize vwandaka kota na kati ya Yinzo ya Mbwabanu, dituti ya tiya ya kutelama vwandaka kulumuka mpe yawu vwandaka telama na mwelo ya Yinzo ya Mbwabanu. Na yina, Yave vwandaka zonza na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Bantu nyonso vwandaka tala dituti ya tiya yina vwandaka telama na mwelo ya Yinzo ya Mbwabanu. Na yina, bawu vwandaka telama. Bawu vwandaka fukama, konso muntu na mwelo ya yinzo ya yandi ya lele. ");
INSERT INTO mkw_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yave vwandaka solola na Moyize kizizi na kizizi, mutindu muntu ke sololaka na mpangi muntu. Na manima, Moyize vwandaka vutuka na kivwandu. Kasi kilandi ya yandi, ntwenya Yeswa, mwana ya Nune, vwandaka bikana na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moyize tubaka na Yave: «Nge ke na kutuba na munu ti: “Basisa bantu yayi”. Kasi nge ke na zabisa munu ve nani nge ke fidisa kintwadi na munu. Kasi nge me tuba: “Mu zabila nge na nkumbu ya nge mpe ni na sika ya nge mu ke na kulakisa bumbote ya munu”. ");
INSERT INTO mkw_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ntangu yayi, mulemvo ya nge, kana ya tsyelika ti nge ke na kulakisa munu bumbote ya nge, lakisa munu banzila ya nge. Na yina, mu ke zaba nge mbote mpe mu ke tala bumbote ya nge. Zaba ti bantu yayi kele bantu ya nge.» ");
INSERT INTO mkw_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yave vutulaka: «Munu mosi mu ke kwenda na nge. Kutala ve ntima mpasi.» ");
INSERT INTO mkw_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moyize tubaka na Yave: «Kana nge mosi nge kwenda ve na beto, bika na kutumisa kwandi beto na kukatuka awa. ");
INSERT INTO mkw_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Yinki ke lakisa ti nge me lakisa bumbote ya nge na munu mpe na bantu ya nge? Ya kele ve ni kukwenda yina nge ke kwenda na beto? Ya kele ve ni kuswasikisa yina nge ke swasikisa beto na bantu nyonso ya nkaka yina kele na ntoto?» ");
INSERT INTO mkw_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yave vutulaka na Moyize: «Mambu yina nge me zonza, mu ke sala mpe yawu, samu ti mu zabila nge na nkumbu ya nge mpe mu zola kulakisa nge bumbote ya munu.» ");
INSERT INTO mkw_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Na yina, Moyize tubaka: «Mulemvo ya nge, lakisa munu nkembo ya nge.» ");
INSERT INTO mkw_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yave vutulaka: «Mu ke lakisa nge bumbote ntangu mu ke luta na mantwala ya nge. Mu ke samuna Nkumbu ya munu Yave na mantwala ya nge. Mu ke lakisa bumbote ya munu na muntu yina mu zola kulakisa bumbote ya munu. Mu ke tala kyadi na muntu yina mu zola kutala kyadi.» ");
INSERT INTO mkw_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Kasi Yave tubaka dyaka: «Nge ke lenda ve na kutala kizizi ya munu, samu ti ya lenda salama ve ti muntu kutala kizizi ya munu mpe kuzinga dyaka. ");
INSERT INTO mkw_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Tala kisika yayi yina kele pene-pene na munu. Nge ke telama kuna, na zulu ya ditadi. ");
INSERT INTO mkw_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ntangu nkembo ya munu ke luta, mu ke tula nge na kati ya dibulu ya ditadi. Mu ke fuka nge na diboko ya munu tii ntangu yina mu ke manisa na kuluta. ");
INSERT INTO mkw_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Na manima, mu ke katula diboko ya munu. Nge ke tadila munu na manima. Kasi kizizi ya munu ke talana ve.» ");
INSERT INTO mkw_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yave tubaka na Moyize: «Yidika matadi zole ya mutindu mosi na ya ntete. Mu ke sonika na zulu ya matadi yango mambu yina vwandaka na matadi ya ntete yina nge mwangisaka. ");
INSERT INTO mkw_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kubama samu na mbasi na suka. Na suka-suka, nge ke yuluka na zulu ya mongo ya Sinayi. Vwanda kuna na mantwala ya munu, na nsongi ya mongo. ");
INSERT INTO mkw_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ata muntu ke kwenda na nge. Ata muntu ya nkaka ke vwanda na mongo. Ata kibulu mosi ve ke kwiza kudya pene-pene ya mongo yina, ya vwanda dimeme, nkombo to ngombe!» ");
INSERT INTO mkw_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","«Tekila yandi kwenda, Moyize yidikaka matadi zole mutindu matadi ya ntete. Na suka-suka ya kilumbu yina landaka, yandi yulukaka na mongo ya Sinayi, mutindu Yave tumisaka yandi. Yandi nataka matadi nyonso zole yango. ");
INSERT INTO mkw_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yave kulumukaka na dituti, yandi telamaka kuna pene-pene ya Moyize. Yandi zonzaka Nkumbu ya Yave. ");
INSERT INTO mkw_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yave lutaka na mantwala ya Moyize na kwendaka zonza: “Yave, Yave, Nzambi yina ke talaka kyadi mpe yina ke lemvokilaka, yina ke dasukaka na mbangu ve, yina ke ya kufuluka na luzolo mpe kukwikama, ");
INSERT INTO mkw_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","yina ke vwandaka ya kukwikama na funda mosi (1 000) ya bambandu ya bantu, yina ke vibidilaka na kutala yimbi, kondwa kutumama, mpe masumu ya bantu. Kasi yandi ke bikaka ve na kupesa kitumbu na muntu yina me sala yimbi. Masumu ya batata, yandi ke futisaka yawu na bana ya bawu mpe na batekolo ya bawu, tii na mbandu ya tatu mpe na mbandu ya yiya.”» ");
INSERT INTO mkw_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","«Na nswalu nyonso, Moyize fukamaka mpe kubwaka kizizi na ntoto. ");
INSERT INTO mkw_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Moyize tubaka: “Mfumu, kana ya tsyelika nge me lakisa munu bumbote ya nge, mulemvo ya nge Mfumu, kwenda na beto. Ya tsyelika, bantu yayi kele bantu ya yintu ngolo. Kasi lemvokila yimbi ya beto mpe masumu ya beto. Sala ti beto kuvwanda mvwilu ya nge.”» ");
INSERT INTO mkw_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yave tubaka na Moyize: «Munu mosi mu ke sala ngwisani. Na mantwala ya bantu ya nge nyonso, mu ke sala mambu ya ngitukulu yina me salamaka ntete ve na ntoto nyonso mpe na bayinsi nyonso. Bantu nyonso yina kele na nge ke tala mavanga ya munu Yave. Mavanga ya nsisi yina mu ke sala na nge.» ");
INSERT INTO mkw_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","«Beno sala keba na yina mu ke na kutumisa beno bubu yayi. Mu ke bingisa na mantwala ya beno ba-Amoli, ba-Kaanani, ba-Yiti, ba-Pelizi, ba-Yivi na ba-Yebuse. ");
INSERT INTO mkw_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Beno keba, beno sala ve ngwisani na bantu ya bayinsi, bisika yina beno ke na kukwenda. Bawu lenda vwanda mutambu samu na beno. ");
INSERT INTO mkw_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Beno ke mwangisa biyokolo ya bawu ya minkayulu. Beno ke mwangisa matadi ya bawu yina ba telemisaka mutindu bidimbu. Beno ke zenga makunzi ya bawu ya longo ya nzambi ya bawu Asela. ");
INSERT INTO mkw_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Beno kufukimina ve nzambi ya nkaka, kana kaka munu ve, samu ti nkumbu ya munu kele “Yave”, mu kele Nzambi ya Kimbanda, ni yawu yina nkumbu ya munu kele “Yave ya Kimbanda”. ");
INSERT INTO mkw_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Kusala ve ngwisani na bantu ya bayinsi yina, kana ve, ntangu bawu ke sambila banzambi ya bawu mpe bawu ke pesa bawu minkayulu, bawu lenda kubokila beno na kudya na bawu minkayulu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kana beno sala mutindu yina, bana ya beno ya babakala lenda kukwela bana ya bawu ya bakento. Mpe ntangu bana ya bawu ya bakento ke sambila banzambi ya bawu, bawu lenda kusala ti bana ya beno mpe kusambila banzambi ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Beno kuyidika ve banzambi na bisengo ya kusulumuka.» ");
INSERT INTO mkw_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Konso mvula, beno ke banda na kusalaka Mukembo ya Mampa yina kele ve na levule. Mukembo yango ke vwanda ya bilumbu nsambwadi, na ntangu ya yawu, na ngonda ya ntete. Na mukembo yina, beno ke kudya mampa yina ba funisaka ve mutindu mu me tumisa beno, samu ti ni na ngonda yina beno basikaka na yinsi ya Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Konso mwana ya ntete yina ke butuka ya bakala, yandi kele ya munu. Mutindu mosi mpe na bana ya mbakala ya ntete ya bibulu ya beno nyonso, ya vwanda bana ya bangombe, ya vwanda bana ya bankombo to bana ya mameme. ");
INSERT INTO mkw_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Kasi mwana ya ntete ya mbuluku, beno ke kuula yawu. Na yina, beno ke tula nkombo to dimeme na kisika ya yawu. Kana beno kuula yawu ve, beno ke zenga laka ya mwana ya mbuluku yina.» «Beno fwana kukuula konso mwana ya ntete na kati ya bantu ya beno. «Ata muntu ke kwiza na mantwala ya munu maboko mpamba.» ");
INSERT INTO mkw_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Beno ke sala bisalu ya beno na bilumbu sambanu. Kasi kilumbu ya nsambwadi beno ke pema. Ata ya vwanda na ntangu ya kuyonzika to na ntangu ya kukunda, beno ke pema.» ");
INSERT INTO mkw_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Beno ke banda na kusalaka Mukembo ya Balumingu na ntangu ya kuyonzika bambuma ya ntete ya faline. Beno ke banda na kusalaka mpe Mukembo ya Kuyonzika, na nsuka ya mvula.» ");
INSERT INTO mkw_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","«Konso mvula, babakala nyonso ke kwiza talana bambala tatu na ntadisi ya Yave Mfumu, Nzambi ya Isayeli, ");
INSERT INTO mkw_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","samu ti mu ke bingisa bantu ya bayinsi yina, bisika beno ke na kukwenda. Mu ke kumisa yinsi ya beno nene. Ata muntu ke meka na kwiza botola yinsi ya beno na ntangu yina beno ke kwiza talana bambala tatu na mvula, na ntadisi ya munu Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Beno kupesa munu ve munkayulu ya kibulu, ya kuvukana na kima yina kele na levule. Mbisi ya munkayulu ya Mukembo ya Paki fwana kukuma ve tii na suka ya kilumbu yina ke landa. ");
INSERT INTO mkw_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Beno nata na Yinzo ya Yave, Nzambi ya beno, madya ya ntete-ntete ya bilanga ya beno. Beno lambila ve mbisi ya mwana ya nkombo na miliki ya mama ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yave tubaka na Moyize: «Sonika mambu yina, samu ti ni na mambu yayi mu ke na kusala ngwisani ya munu na nge mpe na bantu ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moyize vwandaka kuna na Yave bilumbu makumi yiya, mpimpa na ntangu. Yandi kudyaka ata madya, yandi kunwaka mpe ata maza ve. Yandi sonikaka na zulu ya matadi, mambu ya ngwisani, misiku kumi. ");
INSERT INTO mkw_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Na manima, Moyize kulumukaka na mongo ya Sinayi. Ntangu yandi kulumukaka na mongo, yandi vwandaka na matadi zole ya ngwisani na maboko. Moyize vwandaka zaba ve ti kizizi ya yandi vwandaka lezima, samu na kusolola yina yandi vwandaka me solola na Yave. ");
INSERT INTO mkw_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ntangu Aloni na bana nyonso ya Isayeli talaka Moyize, kizizi ya yandi vwandaka lezima. Na yina, bawu kumaka na boma ya kubelama na yandi. ");
INSERT INTO mkw_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moyize bokilaka bawu. Na yina, Aloni na bamfumu nyonso ya mukangu kwizaka na sika ya Moyize, mpe Moyize zonzaka na bawu. ");
INSERT INTO mkw_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Na manima, bana nyonso ya Isayeli manisaka na kubelama. Yandi zabisaka bawu bantumunu nyonso yina Yave pesaka yandi na mongo ya Sinayi. ");
INSERT INTO mkw_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ntangu Moyize manisaka na kuzonza na bawu, yandi fukaka kizizi ya yandi na lele. ");
INSERT INTO mkw_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Konso ntangu yina Moyize vwandaka kwenda na mantwala ya Yave, samu na kuzonza na yandi, yandi vwandaka katula lele na kizizi tii na ntangu yina yandi vwandaka basika. Ntangu yandi vwandaka me basika, yandi vwandaka zonza na bana ya Isayeli bantumunu yina yandi vwandaka me kuzwa. ");
INSERT INTO mkw_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Konso ntangu mpe, bana ya Isayeli vwandaka tala kizizi ya Moyize. Bawu vwandaka tala ti yawu ke na kulezimaka. Na yina, Moyize vwandaka fuka dyaka kizizi ya yandi tii ntangu yina yandi vwandaka vutuka na kuzonza na Yave. ");
INSERT INTO mkw_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moyize yonzikaka mukangu nyonso ya bana ya Isayeli. Yandi zonzaka na bawu: «Mutindu ya kusadila mambu yina Yave tumisaka ni yayi: ");
INSERT INTO mkw_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“Beno ke sala bisalu ya beno na bilumbu sambanu. Kasi kilumbu ya nsambwadi ke vwanda kilumbu yina Yave tulaka na lweka samu na yandi. Ya kele saba, kilumbu ya kupema samu na Yave. Konso muntu yina ke sala kisalu na kilumbu yina, ba ke kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kisika ni kisika yina beno ke zinga, beno kunamisa ve tiya na bayinzo ya beno na kilumbu ya saba.”» ");
INSERT INTO mkw_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moyize tubaka dyaka na mukangu nyonso ya bana ya Isayeli: «Mutindu ya kusadila mambu yina Yave tumisaka ni yayi: ");
INSERT INTO mkw_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Beno ke katudila Yave makabu na kati ya mvwilu ya beno. Konso muntu ya ntima ya mbote ke nata dikabu na Yave, yina yandi ke katula na mvwilu ya yandi. Ya vwanda: wolo, palata, bisengo ya mbwaki, ");
INSERT INTO mkw_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","lino ya ntinta ya dizulu, ya mbwaki to ya mbwaki ya kulutila, lino ya kitoko, mika ya nkombo, ");
INSERT INTO mkw_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","bampusu ya mameme ya mbakala, yina ba me sala ntinta ya mbwaki, bampusu ya bambisi ya nene ya mubu, bayinti ya akasya, ");
INSERT INTO mkw_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mafuta samu na minda, makasa ya nsunga ya mbote yina ba ke yidikilaka mafuta ya mbyekolo mpe mananasi ya kuyoka, ");
INSERT INTO mkw_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","matadi yina ba ke bokilaka onise mpe matadi ya nkaka ya ntalu samu na efode mpe peketolale yina nganga-Nzambi ya ntete ke banda na kulwataka. ");
INSERT INTO mkw_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Bayina nyonso na kati ya beno, yina kele na mayela ya kusala bisalu, bika ti bawu kwiza sala nyonso yina Yave me tumisa, ");
INSERT INTO mkw_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","samu na Yinzo: muludi ya yawu ya balele, bisimbulu ya yawu, mabaya ya yawu, bayinti ya yawu, makunzi ya yawu mpe bima yina ke simba yawu na yisi, ");
INSERT INTO mkw_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","sanduku na bisimbulu ya yawu, kitapu ya sanduku, lele yina ke kabulaka bivinga, ");
INSERT INTO mkw_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","mesa ya mampa na bisimbulu ya yawu, bisalulu ya yawu nyonso mpe mampa yina ke pesamaka na Nzambi, ");
INSERT INTO mkw_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","kitentokolo ya minda mpe bisalulu ya yawu, minda ya yawu mpe mafuta ya kunamisinaka minda. ");
INSERT INTO mkw_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Mesa ya kuyokilaka maaka ya nsunga ya mbote na bisimbulu ya yawu, mafuta ya mbyekolo, mananasi yina ba ke yokaka, lele ya mwelo ya Yinzo, ");
INSERT INTO mkw_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kiyokolo ya minkayulu na kitalaka ya yawu ya kisengo ya mbwaki, bisimbulu ya yawu mpe bisalulu ya yawu nyonso, ndonga ya nene mpe kivwandulu ya yawu, ");
INSERT INTO mkw_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","balele ya lupangu na makunzi ya yawu, bisimbulu ya yawu ya yisi mpe lele ya mwelo ya lupangu, ");
INSERT INTO mkw_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","binko ya basinga ya Yinzo mpe ya lupangu na basinga ya yawu, ");
INSERT INTO mkw_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","binkuti ya banganga-Nzambi samu na kisalu ya Yinzo ya longo, binkuti ya longo ya Aloni, nganga-Nzambi ya ntete, mpe binkuti yina bana ya yandi ke banda na kulwataka, samu na kusalaka kisalu ya bunganga-Nzambi.» ");
INSERT INTO mkw_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Na manima, mukangu nyonso ya bana ya Isayeli katukaka na mantwala ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Na yina, bayina nyonso vwandaka na bantima ya mbote mpe mpeve ya kukabula, bawu kwizaka pesa na Yave makabu yina ba bakaka na bamvwilu ya bawu, samu na kuyidika Yinzo ya Mbwabanu, samu na bisalu ya yawu nyonso, mpe samu na binkuti ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bakento mpe babakala kwizaka. Bayina nyonso vwandaka na bantima ya mbote nataka bima mutindu binzembele, milunga, bampanga, bima ya wolo ya mutindu na mutindu. Bawu kwizaka pesa yawu mutindu ba ke sadilaka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Bayina nyonso yina vwandaka na basinga ya ntinta ya dizulu mpe ya mbwaki, basinga ya mbwaki ya kulutila, basinga ya lino, basinga ya mika ya bankombo, bampusu ya mameme, yina ba tulaka ntinta ya mbwaki, bampusu ya bambisi ya nene ya mubu, bawu nataka yawu. ");
INSERT INTO mkw_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bayina nyonso bakaka na mvwilu ya bawu palata to bisengo ya mbwaki, bawu nataka makabu na Yave. Bayina vwandaka na bayinti ya akasya, bawu nataka yawu samu na bisalu nyonso ya kusala. ");
INSERT INTO mkw_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Bakento nyonso yina zabaka na kuyidika basinga, bawu yidikaka yawu na maboko ya bawu, mpe bawu nataka yawu, ya vwandaka: basinga ya ntinta ya dizulu, ya mbwaki, ya mbwaki ya kulutila, mpe ya lino. ");
INSERT INTO mkw_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Bakento nyonso ya ntima ya mbote, yina zabaka na kuyidika basinga na mika ya bankombo, bawu yidikaka yawu mpe. ");
INSERT INTO mkw_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Bamfumu ya mikangu nataka matadi ya onise mpe matadi ya nkaka ya ntalu samu na efode mpe peketolale. ");
INSERT INTO mkw_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Bawu nataka mpe makasa ya nsunga ya mbote, mpe mafuta samu na kunamisinaka minda, samu na kuyidikila mafuta ya mbyekolo mpe mananasi ya kuyokaka. ");
INSERT INTO mkw_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Bakento na babakala yina vwandaka na bantima ya mbote, nataka bima ya kusadila bisalu nyonso yina Yave tumisaka na yinwa ya Moyize. Bana ya Isayeli nyonso nataka makabu na luzolo ya bawu mosi na Yave. ");
INSERT INTO mkw_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moyize tubaka na bana ya Isayeli: «Beno tala! Yave me bokila Besalele mwana ya Uli, mutekolo ya Wule, muntu ya kifumba ya Yuda, na nkumbu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Yandi me fulusa yandi na mpeve ya Nzambi, samu ti yandi kuvwanda na ndwenga, mayela mpe luzabu ya kusala mbote bisalu ya mutindu na mutindu: ");
INSERT INTO mkw_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","kuzaba na kuyidika bima, kusadila wolo, kusadila palata, kusadila kisengo ya mbwaki, ");
INSERT INTO mkw_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kuzaba na kupasula matadi ya ntalu mpe kusadila yawu, kusadila mabaya, mpe kuzaba na kusala bisalu ya mutindu na mutindu. ");
INSERT INTO mkw_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Yandi me pesa yandi mpe munkayulu ya kulongisa kisalu yina, mutindu yandi pesaka na Owolyabe, mwana ya Ayisamake ya kifumba ya Dane. ");
INSERT INTO mkw_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Yandi me fulusa bawu na ndwenga ya kusala bisalu ya kupasula matadi ya ntalu, kufikula mabaya, kutunga na maboko balele ya ntinta ya dizulu, ya mbwaki, ya mbwaki ya kulutila, mpe balele ya lino. Bawu lenda sala bisalu ya maboko ya konso mutindu, mpe kuyidika kima ni kima. ");
INSERT INTO mkw_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Na yina, Besalele, Owolyabe na bantu nyonso yina Yave pesaka ndwenga na mayela ya kusala bisalu ya Yinzo ya longo, bawu bandaka na kusala mutindu Yave tumisaka yawu.» ");
INSERT INTO mkw_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moyize bokilaka Besalele, Owolyabe na bantu nyonso yina Yave pesaka ndwenga ya kusala bisalu mpe bayina nyonso yina ndimaka na kuyekula bantima ya bawu na kisalu. ");
INSERT INTO mkw_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Bawu bakaka na sika ya Moyize makabu nyonso yina bana ya Isayeli katulaka na bamvwilu ya bawu, samu na kupesa yawu na kisalu ya Yinzo ya longo. Konso suka, bantu vwandaka tatamana na kunata na sika ya Moyize makabu na luzolo ya bawu mosi. ");
INSERT INTO mkw_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Na yina, bantu nyonso ya ndwenga bayina vwandaka sala bisalu ya Yinzo ya longo, bawu bikaka bisalu ya bawu mosi, yina bawu vwandaka sala ntete. ");
INSERT INTO mkw_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Bawu kwizaka tuba na Moyize: «Bantu ke na kunata makabu ya kulutila lutangu ya bima yina me fwanana samu na bisalu yina Yave tumisaka.» ");
INSERT INTO mkw_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Na yina, Moyize tumisaka ti ba mwangisa nsangu yayi na kivwandu nyonso: «Beno nyonso, bakento na babakala, ata muntu ke nata dyaka makabu samu na Yinzo ya longo!» Ni mutindu yina ba yiminaka bantu na kunata dyaka makabu. ");
INSERT INTO mkw_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Bima yina ba yonzikaka lutilaka lutangu ya bima yina ba vwandaka na yawu nsatu, samu na kusala bisalu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Bisadi nyonso yina vwandaka na ndwenga ya kisalu, bandaka na kutunga Yinzo ya longo na kuyidika bima yayi: balele kumi ya lino ya mbote, ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Bawu tungaka bakeluba na zulu ya yawu. Yawu vwandaka kisalu ya bantu yina ke salaka yawu na bunkete nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Balele nyonso vwandaka yinda mosi mpe nene mosi. Yinda ya yawu vwandaka ya Bakude nana mpe nene ya yawu vwandaka ya Bakude yiya. ");
INSERT INTO mkw_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ba vukisaka balele tanu na lweka mosi mpe balele tanu na lweka ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ba tulaka basinga ya kukangila ya ntinta ya dizulu na ndilu ya nsuka ya balele tanu ya ntete. Ba salaka mpe mutindu mosi na ndilu ya nsuka ya balele tanu ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ba tulaka basinga makumi tanu ya kukangila, na ndilu ya nsuka ya balele tanu ya ntete. Ba tulaka mpe basinga makumi tanu ya kukangila, na ndilu ya ntete ya balele tanu ya nkaka. Basinga nyonso vwandaka talasana. ");
INSERT INTO mkw_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ba yidikaka bisimbulu makumi tanu ya wolo. Ni na bisimbulu yina ba vukisilaka balele tanu ya ntete na balele tanu ya nkaka, mpe muludi nyonso vukanaka. ");
INSERT INTO mkw_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ba yidikaka balele na mika ya bankombo samu na muludi ya nkaka ya Yinzo. Ba salaka yawu kumi na mosi. ");
INSERT INTO mkw_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Yinda ya konso lele vwandaka ya Bakude makumi tatu. Nene ya konso lele vwandaka ya Bakude yiya. Balele nyonso kumi na mosi vwandaka na nene mosi mpe yinda mosi. ");
INSERT INTO mkw_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ba vukisaka ntete balele tanu. Ba vukisaka dyaka balele sambanu ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ba tulaka basinga makumi tanu ya kukangila, na ndilu ya nsuka ya balele tanu ya ntete. Ba tulaka mpe basinga makumi tanu ya kukangila, na ndilu ya ntete ya balele sambanu ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ba yidikaka makumi tanu ya bisimbulu ya kisengo ya mbwaki. Ni na bisimbulu yina ba kangilaka basinga samu na kuvukisa balele, mpe muludi nyonso vukanaka. ");
INSERT INTO mkw_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Samu na kufuka dyaka Yinzo, ba sadilaka bampusu ya bankombo ya mbakala mpe bampusu ya bambisi ya nene ya mubu na zulu ya yawu. Ba tulaka tinta ya mbwaki na bampusu yina ya bankombo. ");
INSERT INTO mkw_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Samu na bibaka, ba yidikaka mabaya ya bayinti ya akasya samu na Yinzo. Mabaya yango vwandaka ya kutelama. ");
INSERT INTO mkw_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Yinda ya dibaya mosi vwandaka ya Bakude kumi. Nene ya yawu vwandaka ya Kude mosi na ndambu. ");
INSERT INTO mkw_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Na yisi ya konso dibaya, ya vwandaka na bansongi zole ya kutelama mutindu mosi. Ni mutindu yina ba salaka samu na mabaya nyonso ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Na yina, ba yidikaka mabaya samu na Yinzo. Mabaya makumi zole na lweka ya sude ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ba yidikaka makumi yiya ya bisengo ya palata. Ba tulaka bisengo yina na yisi ya mabaya. Bisengo zole na konso dibaya, samu na kukotisa bansongi nyonso zole ya dibaya. ");
INSERT INTO mkw_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Na lweka ya nkaka ya Yinzo, lweka ya node, ba tulaka mpe mabaya makumi na zole. ");
INSERT INTO mkw_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ba tudilaka yawu makumi yiya ya bisengo ya palata. Bisengo zole na yisi ya konso dibaya. ");
INSERT INTO mkw_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Samu na manima ya Yinzo, na lweka ya wesete, ba tulaka mabaya sambanu. ");
INSERT INTO mkw_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ba bwelaka mabaya zole samu na bansongi ya manima ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Mabaya yango vwandaka ya kuvukana na mabaya yina kele na bansongi kubanda na yisi tii na zulu. Ba sadilaka mulunga samu na kuvukisa yawu mbote. Na bansongi nyonso zole, mabaya yango vwandaka mutindu mosi. ");
INSERT INTO mkw_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Na yina, lutangu ya mabaya vwandaka nana na kibaka ya manima. Bisengo ya yawu ya palata vwandaka kumi na sambanu. Bisengo zole na yisi samu na konso dibaya. ");
INSERT INTO mkw_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ba yidikaka bayinti tanu ya akasya samu na kusimba mabaya ya mbanzi ya lweka mosi ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Ba yidikaka bayinti tanu samu na kusimba mabaya ya mbanzi ya lweka ya nkaka ya Yinzo. Ba yidikaka bayinti tanu samu na mabaya ya manima ya Yinzo, na lweka ya wesete. ");
INSERT INTO mkw_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ba tulaka yinti ya mfunu yina ke kotaka na kati ya mabaya, kubanda na dibaya ya nsongi ya manima tii na dibaya ya nsongi ya mantwala ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ba tulaka wolo na mabaya. Milunga yina ke yambaka bayinti ya bambanzi vwandaka mpe ya wolo. Ba tulaka wolo na bayinti ya balweka. ");
INSERT INTO mkw_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ba yidikaka lele. Ba yidikilaka yawu na basinga ya lino ya mbote, ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Ba tungaka bakeluba na zulu ya yawu. Yawu vwandaka kisalu ya bantu yina ke salaka yawu na bunkete nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Samu na lele, ba salaka makunzi yiya ya akasya. Ba tulaka wolo na makunzi yango. Makunzi yango vwandaka na mwa bisimbulu ya wolo, mpe ba yidikilaka yawu bisengo yiya ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Samu na mwelo ya Yinzo, ba yidikaka lele. Ba yidikilaka yawu na basinga ya lino ya mbote, ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Ya vwandaka kisalu ya bantu yina ke tungaka na maboko. ");
INSERT INTO mkw_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ba bakaka makunzi tanu ya akasya samu na lele yina. Ba tulaka wolo na makunzi yango, mpe ba tulaka yawu bisimbulu ya wolo. Ba tulaka mwa yimpu ya wolo na zulu ya konso dikunzi na mwa bayinti ya yawu. Ba yidikaka samu na yisi ya makunzi yina, bisengo tanu na kisengo ya mbwaki yina ba sulumunaka na tiya. ");
INSERT INTO mkw_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalele yidikaka sanduku. Yandi yidikilaka yawu na mabaya ya bayinti ya akasya. Yinda ya yawu vwandaka ya Bakude zole na ndambu. Nene ya yawu vwandaka ya Kude mosi na ndambu mpe mutela ya yawu vwandaka ya Kude mosi na ndambu. ");
INSERT INTO mkw_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Besalele tulaka yawu wolo ya mbote na kati tii na ngaanda. Bandilu ya yawu nyonso, yandi tulaka yawu wolo. ");
INSERT INTO mkw_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Yandi sulumunaka wolo samu na kuyidikila yawu milunga yiya ya wolo. Yandi tulaka milunga yango na bansongi nyonso yiya. Zole na lweka mosi mpe zole dyaka na lweka ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Yandi yidikaka bayinti zole na yinti ya akasya mpe yandi tulaka yawu wolo. ");
INSERT INTO mkw_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Yandi kotisaka bayinti yango na milunga yina vwandaka na balweka ya sanduku, samu na kunanguninaka sanduku. ");
INSERT INTO mkw_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Besalele yidikaka mpe kitapu ya wolo ya mbote, kisika ya kupesilaka minkayulu ya menga. Yinda ya yawu vwandaka ya Bakude zole na ndambu, nene ya yawu vwandaka ya Bakude zole na ndambu. ");
INSERT INTO mkw_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Yandi yidikaka bakeluba zole ya wolo ya ngolo mpe yandi tulaka yawu na bansongi nyonso zole ya kitapu. ");
INSERT INTO mkw_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Yandi tulaka keluba mosi na nsongi ya ntete, keluba ya nkaka na nsongi ya nkaka. Bakeluba nyonso zole mpe kitapu vwandaka kaka kima mosi. ");
INSERT INTO mkw_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Bakeluba vwandaka talisa mapapu ya bawu na zulu. Mapapu yango fukaka kitapu, kisika ya kupesilaka minkayulu ya menga. Bakeluba vwandaka ya kutalasana. Bizizi ya bakeluba vwandaka ya kutalisa na kitapu. ");
INSERT INTO mkw_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Besalele yidikaka mesa ya mampa. Yandi yidikilaka yawu na mabaya ya yinti ya akasya. Yinda ya yawu vwandaka ya Bakude zole. Nene ya yawu vwandaka ya Kude mosi, mpe mutela ya yawu vwandaka ya Kude mosi na ndambu. ");
INSERT INTO mkw_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Yandi tulaka yawu wolo ya mbote. Bandilu ya yawu nyonso, yandi tulaka yawu wolo. ");
INSERT INTO mkw_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Mesa yango, yandi yidikila yawu ndilu ya Topale mosi. Na zulu ya ndilu yina, yandi bongisaka yawu na kutula dyaka ndilu ya nkaka ya wolo. Bandilu nyonso zungidilaka mesa. ");
INSERT INTO mkw_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Yandi yidikilaka yawu milunga yiya ya wolo. Yandi tulaka milunga yango na bansongi nyonso yiya ya makulu ya mesa. ");
INSERT INTO mkw_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Milunga yango vwandaka pene-pene ya bandilu yango. Ni yawu yambaka bayinti ya kunanguninaka mesa. ");
INSERT INTO mkw_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Bayinti yango, yandi yidikilaka yawu na mabaya ya yinti ya akasya. Yandi tulaka yawu wolo. Ni na yawu ba bandaka na kunanguninaka mesa. ");
INSERT INTO mkw_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Mesa yango, yandi yidikilaka yawu bandonga, bakopo, bandonga ya fyoti, bambungu samu na minkayulu ya vinu. Yandi yidikilaka yawu na wolo ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Yandi yidikaka kitentokolo ya minda ya wolo ya mbote. Kitentokolo yango, yandi yidikilaka yawu na wolo ya ngolo. Dikulu ya yawu, maboko ya yawu, mwa bandonga ya yawu, makolo ya yawu ya nkaka na bifulu ya yawu, nyonso vwandaka kaka kima mosi. ");
INSERT INTO mkw_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Bintala sambanu vwandaka ya kubasika na balweka ya yawu: bintala tatu-tatu na konso lweka ya kitentokolo ya minda. ");
INSERT INTO mkw_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Konso kintala vwandaka na mwa bambungu tatu mutindu kifulu ke na kufunguka, na makolo mpe bifulu. Ni mutindu yina vwandaka bintala nyonso sambanu ya kitentokolo ya minda. ");
INSERT INTO mkw_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na zulu ya yinti ya kati-kati ya kitentokolo ya minda, ya vwandaka na mwa bandonga yiya mutindu kifulu ke na kufunguka, na makolo mpe bifulu. ");
INSERT INTO mkw_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Na yisi ya bintala zole ya ntete, ya vwandaka na dikolo mosi. Dikolo mosi vwandaka na bintala zole ya nkaka, dikolo mosi mpe na bintala zole ya nsuka. Bintala nyonso sambanu ya kitentokolo ya minda vwandaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Makolo ya yawu na bintala ya yawu vwandaka kaka kima mosi. Nyonso vwandaka ya kuyilama na wolo ya ngolo, wolo ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Yandi yidikaka minda nsambwadi ya yawu. Yandi yidikaka mpe bisimbulu ya minda mpe bima ya bombi ya yawu ke vwanda ya kuyilama na wolo ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Yandi sadilaka Talente mosi ya wolo ya mbote, samu na kuyidika kitentokolo ya minda na bima ya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Besalele yidikaka mesa ya kuyokilaka maaka ya nsunga ya mbote. Yandi yidikilaka yawu na mabaya ya yinti ya akasya. Yinda mpe nene ya yawu vwandaka ya Kude mosi na balweka nyonso. Mutela ya yawu vwandaka ya Bakude zole. Mampoka ya yawu vwandaka kaka kima mosi na yawu. ");
INSERT INTO mkw_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Yandi tulaka yawu nyonso wolo ya mbote, na balweka ya yawu, mpe na mampoka ya yawu. Zulu ya yawu mpe ndilu ya yawu vwandaka ya wolo. ");
INSERT INTO mkw_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Yandi yidikaka milunga zole ya wolo na yisi ya ndilu, na lubakala mpe na lumoso. Yandi salaka yawu na balweka nyonso zole yina, samu na kukotisaka bayinti ya kunanguninaka yawu. ");
INSERT INTO mkw_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Yandi yidikaka bayinti na mabaya ya akasya. Yandi tulaka yawu wolo. ");
INSERT INTO mkw_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Yandi yidikaka mafuta ya mbyekolo ya longo mpe mananasi ya nsunga ya mbote. Kuvukisa mananasi yina, ya vwandaka kisalu mutindu ya bisadi-mananasi. ");
INSERT INTO mkw_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Besalele yidikaka kiyokolo ya minkayulu. Yandi yidikilaka yawu na mabaya ya yinti ya akasya. Bandilu ya yawu vwandaka ya Bakude zole na balweka nyonso. Mutela ya yawu vwandaka ya Bakude tatu. ");
INSERT INTO mkw_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Na bansongi ya yawu nyonso yiya, yandi yidikaka mampoka. Mampoka yango vwandaka kaka kima mosi na yawu. Yandi tulaka na zulu ya yawu kisengo ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Yandi yidikaka bisalulu nyonso ya kiyokolo ya minkayulu: bapele, bambungu, misoma, bima ya bombi. Yandi salaka biteko nyonso yina na kisengo ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Yandi yidikaka kitalaka ya kisengo ya mbwaki mutindu mpwasa. Yandi salaka yawu milunga ya mbwaki na bansongi nyonso yiya. Yandi tulaka yawu na balweka ya kitalaka ya kisengo ya mbwaki ya kiyokolo ya minkayulu kubanda na yisi tii na kati-kati ya dibulu ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Yandi tulaka yawu milunga yiya na bansongi nyonso yiya ya kitalaka ya kisengo ya mbwaki, samu na kukotisaka bayinti. ");
INSERT INTO mkw_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Yandi yidikaka bayinti na mabaya ya akasya. Yandi tulaka yawu kisengo ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Yandi kotisaka bayinti yango na kati ya milunga. Bayinti yina vwandaka na balweka nyonso zole ya kiyokolo ya minkayulu, samu na kunanguninaka yawu. Na yina, kiyokolo yango, yandi yidikilaka yawu na mabaya. Na kati-kati ya yawu vwandaka mpamba mutindu dibulu. ");
INSERT INTO mkw_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Yandi yidikaka ndonga ya nene. Yandi yidikilaka yawu na kisengo ya mbwaki mpe kivwandulu ya yawu na kisengo ya mbwaki. Na kuyidika yawu, yandi sadilaka bitala-tala ya bisengo ya mbwaki yina pesaka bakento yina vwandaka sala kisalu ya bawu na nkotolo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Yandi yidikaka bima ya kuzungisa lupangu nyonso. Samu na kuyidika ngaanda, yandi salaka balele ya lino ya mbote. Samu na lweka ya sude, yinda ya yawu vwandaka ya Bakude nkama (100). ");
INSERT INTO mkw_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Yawu vwandaka na makumi zole ya makunzi mpe makumi zole ya bisengo ya yawu na yisi, ya kuyilama na bisengo ya mbwaki. Bisimbulu mpe mwa bayinti ya yawu vwandaka ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Samu na lweka ya node, yinda vwandaka mpe na Bakude nkama (100). Yawu vwandaka na makumi zole ya makunzi, na makumi zole ya bisengo ya yawu na yisi, ya kuyilama na bisengo ya mbwaki. Bisimbulu mpe mwa bayinti ya yawu vwandaka ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Na lweka ya wesete, ya vwandaka na balele ya Bakude makumi tanu. Yawu vwandaka na makunzi kumi mpe bisengo ya yawu kumi na yisi. Bisimbulu ya makunzi na mwa bayinti ya yawu vwandaka ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Na lweka ya esete, ya vwandaka na Bakude makumi tanu. ");
INSERT INTO mkw_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Na lweka mosi ya nkotolo, ya vwandaka na balele ya Bakude kumi na tanu. Yawu vwandaka na makunzi tatu mpe bisengo ya yawu tatu na yisi. ");
INSERT INTO mkw_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Na lweka ya nkaka ya nkotolo, na lumoso mpe na lubakala, ya vwandaka na balele ya Bakude kumi na tanu. Yawu vwandaka na makunzi tatu mpe bisengo ya yawu tatu na yisi. Na yina, ya vwandaka na balele na balweka nyonso zole ya nkotolo. ");
INSERT INTO mkw_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Balele nyonso yina zungaka lupangu vwandaka ya lino ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Bisengo ya yisi ya makunzi vwandaka ya bisengo ya mbwaki. Bisimbulu ya makunzi na mwa bayinti ya yawu vwandaka ya kusalama na palata. Bayimpu ya makunzi vwandaka ya palata. Makunzi nyonso ya lupangu vwandaka ya kuvukana na mwa bayinti ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Lele ya mwelo ya ngaanda vwandaka ya basinga ya lino ya mbote, ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Ya vwandaka kisalu ya bantu yina ke tungaka na maboko. Nene ya lele yango vwandaka ya Bakude makumi zole. Mutela ya yawu vwandaka ya Bakude tanu, mutindu balele nyonso ya lupangu. ");
INSERT INTO mkw_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Makunzi ya yawu yiya mpe bisimbulu ya yawu ya yisi vwandaka ya kisengo ya mbwaki. Bisimbulu ya yawu na mwa bayinti ya yawu vwandaka ya palata. Bayimpu ya yawu mpe vwandaka ya palata. ");
INSERT INTO mkw_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Binko nyonso ya basinga ya Yinzo ya longo mpe ya lupangu vwandaka ya kisengo ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Yayi ni lutangu ya bisengo yina ba sadilaka samu na kutunga Yinzo ya longo, kisika yina ba bumbaka dibuku ya ngwisani. Na lutumu ya Moyize, ba-Levi salaka na lutwadusu ya Itamale, mwana ya nganga-Nzambi Aloni, samu na kusala lutangu yayi. ");
INSERT INTO mkw_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besalele mwana ya Uli, mutekolo ya Wule, muntu ya kifumba ya Yuda, salaka mambu nyonso yina Yave tumisaka na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Yandi vwandaka kintwadi na Owolyabe, mwana ya Ayisamake, ya kifumba ya Dane, yina vwandaka kisadi-matadi ya ntalu, kifikudi, kitungi-bilele ya lino ya mbote, ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. ");
INSERT INTO mkw_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Lutangu ya wolo yina bantu ya Isayeli pesaka samu na kutunga Yinzo ya longo vwandaka Basekele bankama nsambwadi na makumi tatu (730) mpe Batalente makumi zole na yivwa. Ba fwanikisaka yawu na Sekele yina ba vwandaka sadila na Yinzo ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Lutangu ya palata yina ba yonzikaka vwandaka Batalente nkama mpe Basekele funda Mosi na bankama nsambwadi na makumi nsambwadi na tanu (1 775). Ba fwanikisaka yawu na Sekele yina ba vwandaka sadila na Yinzo ya longo. Ba yonzikaka nyonso yina ntangu ba salaka lutangusu ya bantu nyonso ya kimvuka. ");
INSERT INTO mkw_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ya zola kutuba ti bantu nyonso yina vwandaka na bamvula makumi zole to bamvula ya kulutila, bayina sonikisaka bankumbu ya bawu, ba vwandaka babakala mafunda sambanu na tatu na bankama tanu, na makumi tanu (603 550). Mosi-mosi na bawu pesaka Beka mosi ya palata, ndambu ya Sekele mosi mutindu ba vwandaka tezila na Yinzo ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ba sadilaka Batalente nkama (100) ya palata samu na kuyidika bisimbulu ya yisi ya makunzi ya Yinzo ya longo mpe ya lele yina vwandaka na kati. Bisimbulu vwandaka nkama (100) samu na Batalente, konso kisimbulu Talente mosi. ");
INSERT INTO mkw_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Na bakilo kumi na nsambwadi na bangalame bankama nsambwadi na makumi tanu (750) yina bikanaka, ba yidikaka bayimpu yina vwandaka na zulu ya makunzi, bisimbulu mpe mwa bayinti yina vwandaka vukisa makunzi nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Bisengo nyonso ya mbwaki yina bantu ya Isayeli pesaka, salaka Batalente makumi nsambwadi mpe Basekele mafunda zole na bankama yiya (2 400). ");
INSERT INTO mkw_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Na bakilo ya kisengo ya mbwaki yayi, ba yidikaka: bisimbulu ya yisi ya makunzi yina vwandaka na mwelo ya Yinzo ya Mbwabanu, kiyokolo ya kisengo ya mbwaki ya minkayulu na mutalaka ya yawu ya kisengo ya mbwaki mpe bisalulu nyonso ya kiyokolo, ");
INSERT INTO mkw_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","bisimbulu ya yisi ya makunzi ya lupangu, bisimbulu ya yisi ya mwelo ya lupangu, binko ya basinga nyonso ya Yinzo mpe ya lupangu. ");
INSERT INTO mkw_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ba bakaka lino ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila, ba yidikaka bikunti ya kusadilaka na kati ya Yinzo ya longo mpe ba yidikaka bikunti ya longo ya Aloni mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ba yidikaka efode. Ba yidikilaka yawu na basinga ya wolo, na lino ya ntinta ya dizulu, ya mbwaki, ya mbwaki ya kulutila, mpe na lino ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Samu na kuzwa basinga ya wolo, ba lengulaka bambele ya wolo mpe ba zengaka yawu mutindu basinga mpe ba kotisaka yawu na lele ya ntinta ya dizulu, ya mbwaki mpe ya lino ya mbote. Ya vwandaka kisalu ya bantu yina ke salaka yawu na bunkete nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Efode yango ba yidikilaka yawu basinga zole ya magembo, ya kutungama na balweka ya yawu. Ni basinga yina vwandaka vukisa bitini zole ya efode. ");
INSERT INTO mkw_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Mukaba yina vwandaka na zulu ya efode vwandaka kaka kima mosi na efode. Yawu mpe vwandaka mutindu yayi: basinga ya wolo ya lino ya ntinta ya dizulu, ya mbwaki, ya mbwaki ya kulutila, mpe ya lino ya mbote, mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ba kubikaka matadi ya ntalu yina ba ke bokilaka onise, ba sonikaka bankumbu ya bana ya Isayeli mutindu kinyemo mpe ba tulaka yawu na kati ya mwa bisimbulu ya wolo. ");
INSERT INTO mkw_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ba tulaka matadi nyonso zole ya ntalu na basinga ya magembo ya efode, samu na kubambukaka moyo ya bifumba kumi na zole ya bana ya Isayeli, mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ba tungaka peketolale ya lufundusu. Yawu vwandaka kisalu ya bantu yina ke salaka yawu na bunkete nyonso. Ba tungaka peketolale kaka mutindu mosi na efode: na basinga ya wolo ya lino ya ntinta ya dizulu, ya mbwaki, ya mbwaki ya kulutila mpe ya lino ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ntangu ba futikaka yawu, balweka ya yawu nyonso vwandaka mutindu mosi. Yinda ya yawu vwandaka ya Epane mosi, nene ya yawu mpe vwandaka ya Epane mosi. ");
INSERT INTO mkw_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ba kotisaka na kati ya peketolale, matadi ya ntalu na milonga yiya. Mulonga ya ntete: saledwane, topaze mpe emelode. ");
INSERT INTO mkw_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Mulonga ya zole: esekalebukele, lazulite mpe zasepe. ");
INSERT INTO mkw_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Mulonga ya tatu: opale, angate mpe ametisete. ");
INSERT INTO mkw_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Mulonga ya yiya: kelizolite, onise mpe zasepe. Matadi nyonso yina vwandaka na kati ya bisimbulu ya yawu ya wolo. ");
INSERT INTO mkw_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ba sonikaka na zulu ya konso ditadi ya ntalu, nkumbu ya mosi na mosi ya bana kumi na zole ya Yakobi. Ya vwandaka ya kusonama mutindu kinyemo. Konso ditadi vwandaka na nkumbu mosi ya kifumba na kati ya bifumba kumi na zole ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ba yidikaka mwa bampanga ya wolo ya mbote samu na peketolale. Ba yidikaka yawu mutindu ba ke kangaka bansuki ya maboko. ");
INSERT INTO mkw_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ba yidikaka bisimbulu zole mpe mwa milunga zole ya wolo samu na peketolale. Ba tulaka yawu na bansongi zole ya peketolale. ");
INSERT INTO mkw_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ba kangaka mwa bampanga zole yina ya wolo na milunga zole na bansongi ya peketolale. ");
INSERT INTO mkw_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ba kangaka mpe bansongi nyonso zole ya nkaka ya mwa bampanga yango na bisimbulu yina kele na basinga ya magembo ya efode, na mantwala. ");
INSERT INTO mkw_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ba yidikaka dyaka milunga zole ya wolo. Ba tulaka yawu na bansongi zole ya nkaka ya peketolale, na lweka ya kati yina ke vukanaka na efode. ");
INSERT INTO mkw_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ba yidikaka dyaka milunga zole ya wolo. Ba tulaka yawu na yisi ya basinga ya magembo ya efode, na mantwala, pene-pene ya kisika yina ba tungaka yawu. Milunga yango vwandaka na zulu ya mukaba ya efode. ");
INSERT INTO mkw_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ba kangaka milunga ya peketolale mpe milunga ya efode na singa ya ntinta ya dizulu, samu na kukanga peketolale na mukaba ya efode. Na yina, peketolale vwandaka katuka ve na kisika ya yawu. Bawu salaka mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ba tungaka dizwela. Ni na zulu ya yawu nganga-Nzambi vwandaka lwatila efode. Dizwela nyonso vwandaka ya ntinta ya dizulu. Ya vwandaka kisalu ya bantu yina ke tungaka mbote. ");
INSERT INTO mkw_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Dizwela yango vwandaka na dibulu na kati-kati samu na kukotisaka yintu. Ba futikaka bandilu ya dibulu yango mpe ba tungaka yawu. Ba tungaka yawu mbote-mbote samu ti yawu kupasuka ve. ");
INSERT INTO mkw_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ba tungaka ndilu nyonso ya yisi ya dizwela, ba tulaka bifwani ya bambuma ya ngelenadine ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Ba bongisaka yawu mpe na basinga ya lino ya mbote. ");
INSERT INTO mkw_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Na kati-kati ya bambuma yina, ba tulaka mwa bangunga ya wolo, na ndilu nyonso ya yisi ya dizwela. ");
INSERT INTO mkw_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Na yisi ya ndilu ya dizwela, ba tulaka mwa ngunga mosi ya wolo, kifwani ya mbuma mosi ya ngelenadine, mwa ngunga mosi ya wolo, kifwani ya mbuma mosi ya ngelenadine, samu na kusala kisalu mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Bisadi-balele yidikaka binkuti ya yinda ya lino samu na Aloni mpe samu na bana ya yandi. Ya vwandaka kisalu ya bantu yina ke tungaka mbote. ");
INSERT INTO mkw_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ba yidikaka mpe yimpu ya lino ya mbote ya nganga-Nzambi ya ntete mpe bayimpu ya lino ya mbote ya banganga-Nzambi ya nkaka, mpe mibati ya lino. ");
INSERT INTO mkw_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ba yidikaka basinga ya luketo mutindu nsuki ya maboko ya lino ya mbote, ba vukisaka yawu na lino ya mbote ya ntinta ya dizulu, ya mbwaki mpe ya mbwaki ya kulutila. Ya vwandaka kisalu ya bantu yina ke tungaka mbote. Ba salaka mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Na kumanisa, ba yidikaka mwa kisengo ya wolo ya mbote. Ba sonikaka na zulu ya yawu mutindu ba ke salaka na kinyemo, mutindu yayi: «Ya kubyekwa na Yave.» ");
INSERT INTO mkw_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Kidimbu yango ba kangaka yawu na singa ya ntinta ya dizulu na zulu ya yimpu ya kinganga-Nzambi, mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ni mutindu yayi ba manisaka na kukubika bima nyonso ya ntungulu ya Yinzo, Yinzo ya Mbwabanu. Bantu ya Isayeli salaka kisalu, bawu salaka nyonso mutindu Yave tumisaka yawu na yinwa ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Bantu ya Isayeli natinaka Moyize bima nyonso ya Yinzo: Balele ya Yinzo, bima ya kutungila yawu, bisimbulu, mabaya, bayinti ya fyoti, makunzi mpe bisimbulu ya yisi ya makunzi. ");
INSERT INTO mkw_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","- Bampusu ya bankombo ya mbakala ya tinta ya mbwaki samu na muludi, bampusu ya bambisi ya nene ya mubu samu na muludi, mpe lele yina ke kabulaka bivinga. ");
INSERT INTO mkw_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","- Sanduku ya ngwisani na bayinti ya kunanguninaka yawu, mpe kitapu ya yawu, kisika ya kupesilaka minkayulu ya menga. ");
INSERT INTO mkw_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","- Mesa ya mampa na bisalulu ya yawu mpe mampa ya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","- Kitentokolo ya wolo ya mbote, minda ya yawu, bisalulu ya yawu mpe mafuta samu na minda. ");
INSERT INTO mkw_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","- Mesa ya wolo, kisika ba ke yokilaka maaka ya nsunga ya mbote, mafuta ya mbyekolo, mpe maaka yina ba ke yokaka. - Lele ya mwelo ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","- Kiyokolo ya minkayulu ya kisengo ya mbwaki, bayinti ya kunanguninaka yawu mpe bisalulu ya yawu mpe mutalaka ya yawu ya kisengo ya mbwaki. - Ndonga ya nene mpe kivwandulu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","- Balele ya lupangu na makunzi ya yawu mpe bisimbulu ya yisi ya makunzi, lele ya mwelo ya lupangu na basinga nyonso mpe binko ya basinga nyonso. - Bisalulu nyonso samu na Yinzo ya longo, Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","- Binkuti ya banganga-Nzambi samu na kisalu ya Yinzo ya longo. - Binkuti ya longo ya Aloni, nganga-Nzambi ya ntete. - Binkuti yina bana ya yandi ke banda na kulwataka, samu na kusalaka kisalu ya bunganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Bantu ya Isayeli salaka mutindu Yave tumisaka yawu na yinwa ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ntangu Moyize talaka ti bima nyonso vwandaka me kubama mutindu Yave tumisaka yandi yawu, yandi sakumunaka bantu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Na kilumbu ya ntete ya ngonda ya ntete, nge ke tunga Yinzo ya longo, Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ni kuna nge ke tula Sanduku ya Ngwisani. Nge ke bumba yawu na manima ya lele yina ke kabulaka bisika ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Na lweka ya nkaka ya lele yina, nge ke nata mesa ya mampa yina ke pesama samu na munu, nge ke kubika yawu kuna. Nge ke nata mpe kitentokolo ya minda mpe nge ke namisa minda ya yawu. ");
INSERT INTO mkw_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Nge ke tula mesa ya wolo ya kuyokilaka maaka ya nsunga ya mbote na mantwala ya lele yina ke bumbaka Sanduku ya Ngwisani. Nge ke tula mpe lele na mwelo ya Yinzo ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Nge ke tula kiyokolo ya minkayulu na mantwala ya nkotolo ya Yinzo ya lele, Yinzo ya Mbwabanu, na kati ya ngaanda ya lupangu. ");
INSERT INTO mkw_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Nge ke tula ndonga ya nene. Yawu ke vwanda na kati-kati ya Yinzo ya Mbwabanu na kiyokolo ya minkayulu mpe nge ke fulusa yawu na maza. ");
INSERT INTO mkw_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Nge ke zungisa lupangu nyonso na balele mpe nge ke tula lele mosi na mwelo ya lupangu.» ");
INSERT INTO mkw_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Nge ke baka mafuta ya mbyekolo mpe nge ke byeka Yinzo ya longo na bima ya yawu nyonso. Ntangu nge ke byeka yawu mpe bima ya yawu nyonso, yawu ke vwanda ya longo. ");
INSERT INTO mkw_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Nge ke kusa kiyokolo ya minkayulu mafuta yina, mpe nge ke byeka yawu na bisalulu ya yawu nyonso. Na yina, kiyokolo ya minkayulu ke vwanda ya longo mingi. ");
INSERT INTO mkw_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Nge ke kusa ndonga ya nene mpe kivwandulu ya yawu mafuta. Na yina yawu ke vwanda ya kubyekwa.» ");
INSERT INTO mkw_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Nge ke nata Aloni mpe bana ya yandi na mwelo ya Yinzo ya Mbwabanu, nge ke yobisa bawu na maza mutindu yawu ke salamaka, ");
INSERT INTO mkw_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","nge ke lwatisa Aloni binkuti ya longo, nge ke kusa yandi mafuta mpe nge ke byeka yandi, samu ti yandi sala kisalu ya bunganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Na manima, nge ke lwatisa bana ya Aloni binkuti ya yinda, ");
INSERT INTO mkw_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","nge ke kusa bawu mpe mafuta mutindu tata ya bawu, samu ti bawu kusala kisalu ya munu. Na yina, mbyekolo ya bawu ke sala ti bawu na bana ya bawu kukuma banganga-Nzambi ya seko, bambandu na bambandu.» ");
INSERT INTO mkw_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moyize salaka kisalu, yandi salaka nyonso mutindu Yave tumisaka yandi. ");
INSERT INTO mkw_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Na kilumbu ya ntete ya ngonda ya ntete, na mvula ya zole yina bantu ya Isayeli basikaka na Ngipiti, Yinzo ya longo telamaka. ");
INSERT INTO mkw_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moyize salaka ti ba telemisaka yawu mutindu yayi: ba tulaka bisimbulu ya yisi, ba tulaka mabaya ya yawu, ba tulaka mwa bayinti ya yawu mpe ba telemisaka makunzi ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ba yalumunaka miludi ya Yinzo ya lele na zulu ya Yinzo ya longo tii na muludi ya nsuka, mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Yandi bakaka matadi ya Misiku kumi, yandi tulaka yawu na kati ya Sanduku ya Ngwisani. Yandi tulaka bayinti ya kunanguninaka sanduku mpe yandi kangaka kitapu, kisika ya kupesilaka minkayulu ya menga, na zulu ya sanduku. ");
INSERT INTO mkw_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ba nataka sanduku na kisika ya kulutila longo. Ba tulaka lele yina ke kabulaka kisika ya longo na kisika ya kulutila longo, samu na kubumba Sanduku ya Ngwisani mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ba tulaka mesa ya mampa na kati ya Yinzo ya Mbwabanu na lweka ya node ya Yinzo, na mantwala ya lele yina ke kabulaka kisika ya longo na kisika ya kulutila longo, ");
INSERT INTO mkw_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","mpe ni kuna ba tulaka mampa yina pesamaka na Yave, mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ba tulaka kitentokolo ya minda kuna, na kati ya kisika ya longo, yawu vwandaka talasana na mesa ya mampa na lweka ya sude ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ba namisaka minda na mantwala ya Yave mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ba tulaka mesa ya wolo ya kuyokilaka maaka ya nsunga ya mbote na kati ya Yinzo ya Mbwabanu, na mantwala ya lele yina ke kabulaka kisika ya longo na kisika ya kulutila longo. ");
INSERT INTO mkw_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Kuna, ba yokaka maaka ya nsunga ya mbote mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ba tulaka lele na nkotolo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ba tulaka kiyokolo ya minkayulu na mantwala ya nkotolo ya Yinzo ya Mbwabanu, na ngaanda, na kati ya lupangu. Ba pesaka Munkayulu ya Kuyoka mpe Munkayulu ya madya ya bilanga mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ba tulaka ndonga ya nene. Ba tulaka yawu na kati-kati ya Yinzo ya Mbwabanu na kiyokolo ya minkayulu mpe ba fulusaka yawu na maza, samu na kuvedisaka banzutu. ");
INSERT INTO mkw_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moyize, Aloni mpe bana ya Aloni, vwandaka sukula maboko na makulu ya bawu kuna. ");
INSERT INTO mkw_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Konso ntangu, tekila bawu kukota na kisika ya longo to kukwenda na kiyokolo ya minkayulu, bawu vwandaka na kifu ya kusukula banzutu mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ba zungisaka lupangu nyonso na balele mpe ba tulaka lele mosi na mwelo ya lupangu. Na manima ya mwelo yango ya lupangu, ni kuna vwandaka kiyokolo ya minkayulu. Na yina, Moyize manisaka bisalu nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Na manima, dituti kwizaka fuka Yinzo ya Mbwabanu mpe nkembo ya Yave fulukaka na Yinzo nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moyize lendaka ve na kukota na Yinzo ya Mbwabanu, samu ti dituti vwandaka kaka kuna, mpe nkembo ya Yave fulukaka na Yinzo nyonso. ");
INSERT INTO mkw_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Konso ntangu yina bantu ya Isayeli vwandaka tala ti dituti me nanguka na zulu ya Yinzo ya Mbwabanu, bawu vwandaka landa nzyetolo ya bawu na kwendaka luta kisika na kisika. ");
INSERT INTO mkw_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Kasi, kana dituti me nanguka ve, bawu mpe vwandaka kwenda ve, bawu vwandaka vingila kilumbu yina dituti ke nanguka. ");
INSERT INTO mkw_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Na ntangu, nkembo ya Yave vwandaka talana na dituti ya kutelama na zulu ya Yinzo ya Mbwabanu, mpe na mpimpa, yawu vwandaka talana na tiya ya nene ya kutelama, na meso ya bantu ya Isayeli, ntangu bawu vwandaka kwenda luta kisika na kisika.");
INSERT INTO mkw_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yave bokilaka Moyize katuka Yinzo ya Mbwabanu. Yandi tubaka na yandi ");
INSERT INTO mkw_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","na kutuba na bana ya Isayeli mutindu yayi: «Ntangu muntu mosi na kati ya beno ke pesa munkayulu ya kibulu na Yave, yandi fwana kubaka yawu na kati ya bangombe to mameme to bankombo.» ");
INSERT INTO mkw_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","«Kana yandi baka ngombe samu na kupesa yawu mutindu Munkayulu ya Kuyoka, yandi ke pesa kibulu ya mbakala, kibulu yina kele ve na kifuma. Yandi ke nata yawu na mwelo ya Yinzo ya Mbwabanu, na mantwala ya Yave, samu ti Yave kundima yawu. ");
INSERT INTO mkw_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Yandi ke tentika diboko ya yandi na zulu ya yintu ya kibulu yina ba ke yoka. Mpe Yave ke ndima yawu mutindu munkayulu samu na kukatula masumu. ");
INSERT INTO mkw_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Yandi ke zenga laka ya ngombe ya mbakala na mantwala ya Yave. Bana ya Aloni, banganga-Nzambi ke lakisa menga na Yave, mpe ba ke mwanga yawu na balweka nyonso ya kiyokolo ya minkayulu, yina kele na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Yandi ke katula mpusu, mpe yandi ke saasa kibulu yina ba ke yoka. ");
INSERT INTO mkw_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Bana ya Aloni, banganga-Nzambi ke namisa tiya na kiyokolo ya minkayulu, mpe ba ke tula bankuni na tiya yina. ");
INSERT INTO mkw_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Bana ya Aloni, banganga-Nzambi ke baka bitini ya mbisi, yintu na mafuta. Bawu ke tula yawu na zulu ya bankuni yina kele na tiya, na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Muntu yina nataka munkayulu ke sukula misopo mpe makulu ya yawu na maza. Na manima, nganga-Nzambi ke yoka nyonso na kiyokolo ya minkayulu. Yawu kele Munkayulu ya Kuyoka, madya yina ba ke yokaka na tiya. Nsunga ya yawu ke yangidikaka Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Kana muntu ke pesa Yave munkayulu ya kibulu ya kuyoka mutindu dimeme to nkombo, yandi fwana kupesa kibulu ya mbakala yina kele ve na kifuma. ");
INSERT INTO mkw_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Yandi ke zenga laka ya yawu pene-pene ya kiyokolo ya minkayulu, na lweka ya node, na mantwala ya Yave. Bana ya Aloni, banganga-Nzambi ke mwanga menga ya kibulu yango na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Yandi ke saasa kibulu nyonso, yandi ke katula yintu mpe mafuta. Nganga-Nzambi ke tula bitini nyonso ya mbisi na zulu ya bankuni yina ke na tiya, na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Yandi ke sukula misopo mpe makulu ya yawu na maza. Na manima, nganga-Nzambi ke pesa nyonso na Yave, mpe yandi ke yoka yawu na kiyokolo ya minkayulu. Yawu kele Munkayulu ya Kuyoka, madya yina ba ke yokaka na tiya. Nsunga ya yawu ke yangidikaka Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Kana muntu ke pesa Yave munkayulu ya bandeke ya kuyoka, yandi fwana kupesa biduka to bana ya mabembe. ");
INSERT INTO mkw_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Nganga-Nzambi ke nata yawu na kiyokolo ya minkayulu. Yandi ke dokona yawu laka. Yandi ke yoka yintu na kiyokolo ya minkayulu. Yandi ke mwanga menga na lweka mosi ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Yandi ke katula kifundu na bansala ya yawu mpe yandi ke losa yawu pene-pene ya kiyokolo ya minkayulu, na lweka ya esete, na kisika yina ba ke tulaka bombi ya mafuta. ");
INSERT INTO mkw_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Yandi ke pasula ndeke na kati-kati ya mapapu, kasi yandi ke kabula yawu ve. Nganga-Nzambi ke yoka yawu na zulu ya bankuni yina kele na zulu ya tiya, na kiyokolo ya minkayulu. Yawu kele Munkayulu ya Kuyoka, madya yina ba ke yokaka na tiya. Nsunga ya yawu ke yangidikaka Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Kana muntu ke pesa Munkayulu ya madya ya bilanga na Yave, dikabu ya yandi fwana kuvwanda faline ya kitoko. Yandi ke mwangisa mafuta na zulu ya yawu, yandi ke tula mpe maaka ya nsunga ya mbote. ");
INSERT INTO mkw_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Yandi ke nata yawu na sika ya bana ya Aloni, banganga-Nzambi. Yandi ke baka diboko ya kufuluka ya faline yango na mafuta ya yawu, na maaka nyonso ya nsunga ya mbote. Nganga-Nzambi ke yoka yawu na kiyokolo ya minkayulu, samu na kubambukaka moyo. Yawu kele madya yina ba ke yokaka na tiya. Nsunga ya yawu ke yangidikaka Yave. ");
INSERT INTO mkw_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ndambu ya Munkayulu ya madya ya bilanga yina ke bikana, kele ya Aloni na bana ya yandi. Yawu kele kikunku ya longo mingi, samu ti yawu me katuka na madya yina ba me yoka na tiya samu na Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«Kana dikabu yina nge ke pesa kele Munkayulu ya madya ya bilanga yina ba me yoka na kifuule, yawu fwana kuvwanda bagato ya kusalama na kiputi ya faline ya kitoko yina ba me vukisa na mafuta, kasi ba ke funisa yawu ve. Yawu lenda vwanda mpe bagalete ya kusalama na kiputi ya faline ya kitoko yina ba me vukisa ve na mafuta, kasi ba me pakula mafuta na zulu ya yawu, mpe ba me funisa yawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kana dikabu yina nge ke pesa kele Munkayulu ya madya ya bilanga yina ba me kalinga na kikalungulu, yawu fwana kuvwanda ya kiputi ya faline ya kitoko yina ba me vukisa na mafuta. Ba ke funisa yawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Nge ke zenga yawu na bandambu mingi, nge ke mwangisa mafuta na zulu ya yawu. Yawu kele Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kana ya kele Munkayulu ya madya ya bilanga yina ba me kalinga na kikalungulu, yawu fwana kuvwanda ya kiputi ya faline ya kitoko yina ba me vukisa na mafuta. ");
INSERT INTO mkw_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Nge ke nata dikabu yina nge me kubika samu na Yave. Nge ke pesa yawu na nganga-Nzambi. Yandi ke nata yawu na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Nganga-Nzambi ke baka na dikabu yina ndambu samu na kubambukaka moyo. Mpe yandi ke yoka yawu na kiyokolo ya minkayulu. Ya kele madya yina ba ke yokaka na tiya. Nsunga ya yawu ke yangidikaka Yave. ");
INSERT INTO mkw_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ndambu ya Munkayulu ya madya ya bilanga yina ke bikana kele ya Aloni na bana ya yandi. Yawu kele kikunku ya longo mingi, samu ti yawu me katuka na madya yina ba me yoka na tiya samu na Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«Minkayulu nyonso ya madya ya bilanga yina beno ke pesa na Yave, ba ke funisa yawu ve. Beno ke yoka ve kima yina ba me funisa to yina kele na mafuta ya nyosi, na kati ya madya yina ba ke yokaka na tiya samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Beno lenda kupesa yawu na Yave mutindu munkayulu ya bambuma ya ntete ya bilanga. Kasi ba ke yoka yawu ve na kiyokolo ya minkayulu mutindu mananasi ya nsunga ya mbote.» ");
INSERT INTO mkw_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","«Nge fwana kutula mungwa na konso Munkayulu ya madya ya bilanga yina nge ke pesa. Nge ke zimbana ve na kutula mungwa ya ngwisani ya Nzambi ya nge na munkayulu ya nge ya madya ya bilanga. Nge ke tula mungwa na konso dikabu ya nge.» ");
INSERT INTO mkw_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«Kana nge ke pesa na Yave munkayulu ya bambuma ya ntete ya bilanga, yawu fwana kuvwanda bambuma ya kukalinga na tiya, bambuma ya faline yina ba me yonzika malu-malu yayi mpe ba me nika. Ni yawu ke vwanda munkayulu ya ntete ya madya ya nge ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Nge ke tula mafuta na zulu ya yawu mpe maaka ya nsunga ya mbote. Yawu kele Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Nganga-Nzambi ke yoka ndambu ya bambuma ya kunika, mafuta mpe maaka nyonso ya nsunga ya mbote, samu na kubambukaka moyo. Yawu kele madya yina ba ke yokaka na tiya samu na Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Kana muntu ke pesa Munkayulu ya Kiwisa, kana yawu kele ngombe, yandi fwana kupesa ngombe ya nkento to ya mbakala yina kele ve na kifuma. Yandi ke nata yawu na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Yandi ke tentika diboko ya yandi na zulu ya yintu ya kibulu yina yandi me nata. Yandi ke zenga yawu laka na mwelo ya Yinzo ya Mbwabanu. Bana ya Aloni, banganga-Nzambi, ke mwanga menga na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Na munkayulu yina ya kiwisa, yandi ke katula madya yina yandi ke yoka samu na Yave. Bima yina yandi ke katula ni yayi: mafuta yina ke fukaka misopo, mafuta nyonso yina ke ya kuvukana na misopo, ");
INSERT INTO mkw_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","bambuma zole yina ke vwandaka na kati ya luketo, na mafuta yina ke ya kuvukana na yawu, mafuta yina ke ya kukangama na yisi ya mukongo, mbala ya kivumu yina yandi ke katula pene-pene ya bambuma yina ke vwandaka na yisi ya mukongo. ");
INSERT INTO mkw_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Bana ya Aloni ke yoka yawu na kiyokolo ya minkayulu, kintwadi na Munkayulu ya Kuyoka yina ke na zulu ya bankuni ya kulema. Ya kele madya yina ba ke yokaka na tiya. Nsunga ya yawu ke yangidikaka Yave. ");
INSERT INTO mkw_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Kana muntu ke pesa Yave dimeme to nkombo mutindu Munkayulu ya Kiwisa, yandi fwana kupesa kibulu ya nkento to ya mbakala yina kele ve na kifuma. ");
INSERT INTO mkw_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kana yandi ke pesa munkayulu ya dimeme, yandi ke nata dimeme yina na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Yandi ke tentika diboko ya yandi na zulu ya yintu ya kibulu yina yandi me nata. Yandi ke zenga yawu laka na mwelo ya Yinzo ya Mbwabanu. Bana ya Aloni, banganga-Nzambi, ke mwanga menga na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Na kati ya munkayulu yina ya kiwisa, yandi ke baka bitini yayi samu na kuyokila yawu Yave: mafuta, mukila nyonso kubanda pene-pene ya mukongo, mafuta yina ke fukaka misopo, mafuta nyonso yina ke ya kuvukana na misopo, ");
INSERT INTO mkw_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","bambuma zole yina ke vwandaka na kati ya luketo, na mafuta yina ke ya kuvukana na yawu, mafuta yina ke ya kukangama na yisi ya mukongo, mbala ya kivumu yina yandi ke katula pene-pene ya bambuma yina ke vwandaka na yisi ya mukongo. ");
INSERT INTO mkw_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Nganga-Nzambi ke yoka yawu na kiyokolo ya minkayulu. Ya kele madya yina ba me yoka na tiya samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Kana muntu ke pesa munkayulu ya nkombo, yandi ke nata nkombo yina na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Yandi ke tentika diboko ya yandi na zulu ya yintu ya kibulu yina yandi me nata. Yandi ke zenga yawu laka na mwelo ya Yinzo ya Mbwabanu. Bana ya Aloni, banganga-Nzambi, ke mwanga menga na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Na kati ya munkayulu yina, bima ni yayi yandi ke baka ya kuyoka na tiya samu na Yave: mafuta yina ke fukaka misopo, mafuta nyonso yina ke ya kuvukana na misopo, ");
INSERT INTO mkw_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","bambuma zole yina ke vwandaka na kati ya luketo, na mafuta yina ke ya kuvukana na yawu, mafuta yina ke ya kukangama na yisi ya mukongo, mbala ya kivumu yina yandi ke katula pene-pene ya bambuma yina ke vwandaka na yisi ya mukongo. ");
INSERT INTO mkw_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Nganga-Nzambi ke yoka yawu na kiyokolo ya minkayulu. Ya kele madya yina ba me yoka na tiya. Nsunga ya yawu ke yangidikaka. «Mafuta nyonso ya kibulu kele ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Yayi ke bansalulu ya bantangu nyonso samu na beno, na bambandu nyonso, na bisika nyonso yina beno ke zinga: beno kudya ve mafuta mpe menga ya kibulu.» ");
INSERT INTO mkw_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","na kuzabisa bana ya Isayeli mutindu yayi: «Kana muntu me sala disumu na luzolo ya yandi mosi ve na kusala mosi na mambu nyonso yina bantumunu ya Yave yiminaka na kusala, beno ke sala mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«Kana nganga-Nzambi yina ba byekaka, ni yandi me sala disumu, yimbi ya disumu ya yandi ke bwidila bantu nyonso. Samu na disumu yina yandi me sala, yandi ke pesa na Yave ngombe ya mbakala yina kele ve na kifuma, samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Yandi ke nata ngombe ya mbakala na mantwala ya Yave, na mwelo ya Yinzo ya Mbwabanu. Yandi ke tentika diboko ya yandi na zulu ya yintu ya ngombe. Mpe yandi ke zenga yawu laka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Nganga-Nzambi yina ba byekaka ke baka menga ya ngombe yina. Yandi ke kota na yawu na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Nganga-Nzambi ke tula musapi ya yandi na kati ya menga. Yandi ke mwanga menga yina bambala nsambwadi na mantwala ya Yave, na lele yina ke bumbaka kivinga ya kulutila longo, na lweka ya kivinga ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Menga yina, nganga-Nzambi ke kusa yawu mpe na mampoka ya kiyokolo ya mananasi yina kele na mantwala ya Yave, na kati ya Yinzo ya Mbwabanu. Menga yina ya ngombe, yina ke bikana, yandi ke mwangisa yawu na kivwandulu ya kiyokolo ya minkayulu, yina kele na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Yandi ke baka mafuta nyonso ya ngombe yina yandi me pesa samu Munkayulu ya mulemvo: mafuta yina ke fukaka misopo, mafuta nyonso yina kele ya kuvukana na misopo, ");
INSERT INTO mkw_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","bambuma zole yina ke vwandaka na yisi ya mukongo, na mafuta yina ke ya kuvukana na yawu, mafuta yina ke ya kukangama na yisi ya mukongo, mbala ya kivumu yina yandi ke katula pene-pene ya bambuma yina ke vwandaka na yisi ya mukongo, ");
INSERT INTO mkw_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","kaka mutindu mosi ba ke katulaka yawu na ngombe ya Munkayulu ya Kiwisa. Nganga-Nzambi ke yoka yawu na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Kasi mpusu ya ngombe na misuni ya yawu nyonso, yintu ya ngombe, makulu ya yawu, misopo na matufi, ");
INSERT INTO mkw_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","nyonso yina ke bikana na kati ya ngombe yango, yandi ke basisa yawu ntama na kivwandu. Yandi ke nata yawu na kisika mosi ya Kuvedila, kisika yina ba ke kwendaka mwangisa bombi ya mafuta. Yandi ke yoka yawu na tiya ya bankuni. Ni na kisika yina ba ke mwangisaka bombi ya mafuta yandi ke yoka yawu.» ");
INSERT INTO mkw_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«Kana ni mukangu nyonso ya Isayeli me sala disumu na luzolo ya bawu mosi ve, na kusala mosi na mambu nyonso yina bantumunu ya Yave yiminaka na kusala, mpe dyambu me zabana ve na nkonga nyonso, yimbi ya disumu ya bawu ke bwidila bawu. ");
INSERT INTO mkw_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ntangu disumu yina bawu me sala ke kwiza zabana, nkonga nyonso ke pesa na Yave ngombe ya mbakala samu na Munkayulu ya mulemvo. Bawu ke nata yawu na mantwala ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Bakuluntu ya bantu ya Isayeli ke tentika maboko ya bawu na zulu ya yintu ya ngombe, na mantwala ya Yave. Mpe ba ke zenga ngombe yango laka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Nganga-Nzambi yina ba byekaka ke nata menga ya ngombe yango na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Nganga-Nzambi ke tula musapi ya yandi na kati ya menga. Yandi ke mwanga menga yina bambala nsambwadi na mantwala ya Yave, na lele yina ke bumbaka kivinga ya kulutila longo, na lweka ya Kivinga ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Menga yina, nganga-Nzambi ke kusa yawu mpe na mampoka ya kiyokolo ya mananasi yina kele na mantwala ya Yave, na kati ya Yinzo ya Mbwabanu. Menga yina ya ngombe, yina ke bikana, yandi ke mwangisa yawu na kivwandulu ya Kiyokolo ya minkayulu, yina kele na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Yandi ke baka mafuta nyonso ya ngombe, mpe yandi ke yoka yawu na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Yandi ke sala na ngombe yina mutindu yandi salaka na ngombe yina yandi pesaka na Munkayulu ya mulemvo ya yandi mosi. Ni mutindu mosi yandi ke sala. Nganga-Nzambi ke sala kisalu samu na kukatula disumu ya bantu. Mpe Yave ke lemvokila bawu. ");
INSERT INTO mkw_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Nganga-Nzambi ke nata ngombe ntama na kivwandu. Yandi ke yoka yawu mutindu yandi yokaka ngombe yina tekilaka. Ya kele Munkayulu ya mulemvo ya dikanda ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«Kana ni mfumu mosi ya dikanda me sala disumu na luzolo ya yandi mosi ve, na kusala mosi na mambu nyonso yina bantumunu ya Yave, Nzambi ya yandi, yiminaka na kusala, yimbi ya disumu ya yandi ke bwidila yandi. ");
INSERT INTO mkw_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Kana ba me zabisa yandi disumu yina yandi me sala, yandi ke nata munkayulu ya nkombo ya mbakala, yina kele ve na kifuma. ");
INSERT INTO mkw_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Yandi ke tentika diboko ya yandi na zulu ya yintu ya nkombo. Yandi ke zenga laka ya nkombo na kisika yina ba ke kufwaka bibulu yina ba ke pesaka mutindu minkayulu ya kuyoka. Yandi ke kufwa yawu kuna na mantwala ya Yave. Ya kele Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Nganga-Nzambi ke baka na musapi ya yandi menga ya kibulu ya Munkayulu ya mulemvo. Yandi ke kusa yawu na mampoka ya Kiyokolo ya minkayulu. Menga yina ke bikana, yandi ke mwangisa yawu na kivwandulu ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Mafuta nyonso ya kibulu, yandi ke yoka yawu na kiyokolo ya minkayulu, mutindu mafuta ya Munkayulu ya Kiwisa. Nganga-Nzambi ke sala kisalu samu na mulemvo ya disumu ya mfumu ya dikanda. Mpe Yave ke lemvokila yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«Kana muntu ni muntu ya dikanda ya Isayeli me sala disumu na luzolo ya yandi mosi ve, na kusala mosi na mambu yina bantumunu ya Yave yiminaka na kusala, yimbi ya disumu ya yandi ke bwidila yandi. ");
INSERT INTO mkw_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Kana ba me zabisa yandi disumu yina yandi me sala, yandi ke nata munkayulu ya nkombo ya nkento, yina kele ve na kifuma, samu na disumu yina yandi me sala. ");
INSERT INTO mkw_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Yandi ke tentika diboko ya yandi na zulu ya yintu ya kibulu ya Munkayulu ya mulemvo. Yandi ke zenga yawu laka na kisika yina ba ke kufwaka bibulu yina ba ke pesaka mutindu minkayulu ya kuyoka. ");
INSERT INTO mkw_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Nganga-Nzambi ke baka na musapi ya yandi menga ya kibulu ya Munkayulu ya mulemvo. Yandi ke kusa yawu na mampoka ya kiyokolo ya minkayulu. Menga yina ke bikana, yandi ke mwangisa yawu na kivwandulu ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Yandi ke katula mafuta nyonso ya kibulu mutindu ba katulaka mafuta ya kibulu yina ba pesaka na Munkayulu ya Kiwisa. Nganga-Nzambi ke yoka yawu na kiyokolo ya minkayulu. Nsunga ya yawu ke yangidika Yave. Nganga-Nzambi ke sala kisalu samu na mulemvo ya disumu ya muntu yina. Mpe Yave ke lemvokila yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«Kana muntu yina kunata dimeme samu na Munkayulu ya mulemvo ya disumu ya yandi, yandi fwana kunata dimeme ya nkento, yina kele ve na kifuma. ");
INSERT INTO mkw_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Yandi ke tentika diboko ya yandi na zulu ya yintu ya kibulu ya Munkayulu ya mulemvo. Samu na kupesa yawu mutindu Munkayulu ya mulemvo, yandi ke zenga yawu laka na kisika yina ba ke kufwaka bibulu yina ba ke pesaka mutindu minkayulu ya kuyoka. ");
INSERT INTO mkw_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Nganga-Nzambi ke baka na musapi ya yandi menga ya kibulu ya Munkayulu ya mulemvo. Yandi ke kusa yawu na mampoka ya kiyokolo ya minkayulu. Menga yina ke bikana, yandi ke mwangisa yawu na kivwandulu ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Yandi ke katula mafuta nyonso ya kibulu mutindu ba katulaka mafuta ya dimeme ya Munkayulu ya Kiwisa. Nganga-Nzambi ke yoka yawu na kiyokolo ya minkayulu, kintwadi na madya yina ba me yoka samu na Yave. Nganga-Nzambi ke sala kisalu samu na mulemvo ya disumu ya muntu yina. Mpe Yave ke lemvokila yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«Kana muntu me sala disumu mutindu yayi: yandi me kudya ndefi ya nsiingulu samu na bayina kele bambangi na dyambu yina me kubwa, ba me bokila bawu na kwiza tuba kimbangi, kana muntu yango talaka mambu yina kubwaka to kana yandi zaba yawu, kasi kana yandi manga ya yandi na kuzabisa yawu, disumu ya yandi ke vwanda na yintu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«Kana na kati ya kondwa kuzaba, muntu me simba kima ni kima yina ke ya kuvedila ve: kibulu ya kufwa yina kele ya kuvedila ve, ya vwanda ya mfinda to ya bwala, ya vwanda ya fyoti-fyoti yina ke kwendaka tambula na ntoto, muntu yina ke dyaka ve ya kuvedila. Yandi me sumuka.» ");
INSERT INTO mkw_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","«Kana na kati ya kondwa kuzaba, muntu me simba kima ya kuvedila ve ya muntu, yandi ke kuma ya kuvedila ve. Na ntangu yandi ke zaba yawu, yandi ke kuma ya kusumuka.» ");
INSERT INTO mkw_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«Kana na kati ya kondwa kuzaba, na kwendaka zonzaka kidi-kidi, muntu me kudya ndefi samu na kuyidika dyambu ni dyambu ya yimbi to ya mbote, na ntangu yandi ke zaba yawu, yandi ke kuma ya kusumuka.» ");
INSERT INTO mkw_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«Kana muntu me sumuka na mosi na mambu yina, yandi fwana kufungula disumu yina yandi me sala. ");
INSERT INTO mkw_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Na manima, yandi ke natina Yave dimeme ya nkento to nkombo ya nkento, samu na kikodi na disumu yina yandi me sala. Yandi ke pesa yawu mutindu Munkayulu ya mulemvo. Nganga-Nzambi ke sala kisalu samu na mulemvo ya disumu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«Kana muntu kele ve na lubaku samu na kuzwa dimeme to nkombo ya kupesa kikodi na disumu yina yandi me sala, yandi lenda nata na Yave biduka zole to mabembe zole. Mosi ke vwanda Munkayulu ya mulemvo, ya nkaka ke vwanda Munkayulu ya Kuyoka. ");
INSERT INTO mkw_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Yandi ke nata yawu na sika ya nganga-Nzambi. Nganga-Nzambi ke pesa ntete yina ke vwanda Munkayulu ya mulemvo. Yandi ke dokona yawu laka, kasi yandi ke katula ve yintu. ");
INSERT INTO mkw_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Yandi ke mwanga menga ya yawu na lweka mosi ya kiyokolo ya minkayulu. Menga yina ke bikana, yandi ke mwangisa yawu na kivwandulu ya Kiyokolo ya minkayulu. Ya kele Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ndeke ya nkaka, yandi ke sala yawu Munkayulu ya Kuyoka mutindu kele nsalulu ya misiku. Nganga-Nzambi ke sala kisalu samu na mulemvo ya disumu ya yandi. Yave ke lemvokila yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«Kana muntu me lenda ve na kuzwa biduka zole to mabembe zole, yandi ke nata kikunku mosi na kati ya bikunku kumi ya Efa ya faline ya kitoko samu na disumu yina yandi me sala. Yandi ke pesa yawu mutindu Munkayulu ya mulemvo. Yandi ke tula ve mafuta na zulu ya yawu. Yandi ke tula mpe ve Maaka ya nsunga ya mbote. Ya kele Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Yandi ke nata yawu na sika ya nganga-Nzambi. Nganga-Nzambi ke baka diboko ya kufuluka ya faline yango samu na kubambuka moyo. Mpe yandi ke yoka yawu na kiyokolo ya minkayulu, kintwadi na madya yina ba me yoka samu na Yave. Ya kele Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Nganga-Nzambi ke sala kisalu samu na mulemvo ya disumu yina yandi me sala. Mpe Yave ke lemvokila yandi. Nyonso yina ke bikana ke vwanda madya ya nganga-Nzambi, mutindu ya ke vwandaka na yina me tadila Munkayulu ya madya ya bilanga.» ");
INSERT INTO mkw_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Kana muntu me sala busafu, na luzolo ya yandi mosi ve, na kusala disumu na mambu yina me tadila bima ya longo ya Yave, muntu yina ke nata na Yave dimeme ya mbakala yina kele ve na kifuma samu na kikodi. Yandi ke baka dimeme yina na kati ya bibulu ya yandi. Ntalu ya yawu ke vwanda ya Sekele ya palata mutindu ba ke tezilaka na Yinzo ya longo. Yandi ke pesa yawu mutindu Munkayulu ya kikodi. ");
INSERT INTO mkw_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Yandi ke futa kima ya Yinzo ya longo yina yandi me sadila disumu. Mpe yandi ke bwela kibuku mosi na kati ya bibuku tanu ya ntalu ya kima yina. Yandi ke pesa nyonso yina na nganga-Nzambi. Na dimeme ya mbakala yina ya Munkayulu ya kikodi, nganga-Nzambi ke sala kisalu samu na mulemvo ya disumu ya muntu yango. Mpe Yave ke lemvokila yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Kana na kati ya kondwa kuzaba, muntu me sala disumu na kusala mosi na mambu nyonso yina bantumunu ya Yave yiminaka na kusala, yandi me sumuka. Disumu ya yandi ke vwanda na yintu ya yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Yandi ke nata na sika ya nganga-Nzambi dimeme ya mbakala yina kele ve na kifuma. Yandi ke baka dimeme yina na kati ya bibulu ya yandi. Ntalu ya yawu ke vwanda mutindu ba zengaka samu na minkayulu ya kikodi. Nganga-Nzambi ke sala kisalu samu na mulemvo ya disumu yina muntu me sala kondwa kuzaba. Mpe Yave ke lemvokila yandi. ");
INSERT INTO mkw_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ya kele Munkayulu ya kikodi. Ya tsyelika, muntu yina vwandaka me sumuka na ntadisi ya Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«Kana muntu me sala disumu mpe yandi me sala yimbi ya mingi na ntadisi ya Yave: ya vwanda ti yandi me vuna mpangi ya yandi yina ba kele yinsi mosi na mambu me tadila kima yina ba bumbisaka na sika ya yandi, to kima yina yandi defaka, to mpe kima yina yandi labaka, ya vwanda ti yandi bakaka na ngolo kima ya mpangi ya yandi, ");
INSERT INTO mkw_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","ya vwanda mpe ti yandi lokotaka kima mosi yina zimbanaka, kasi yandi me manga kundima yawu, ya vwanda ti yandi me kudya ndefi ya luvunu na dyambu ni dyambu yina muntu lenda sala mutindu disumu, ");
INSERT INTO mkw_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","kana yandi me sala disumu ya mutindu yina, yimbi ya disumu ya yandi ke bwidila yandi. Yandi fwana kuvutula kima yina yandi labaka, to yina yandi bakaka na ngolo, to yina ba bumbisaka na yandi, to yina vwandaka ya kuzimbana mpe yandi lokotaka, ");
INSERT INTO mkw_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","to nyonso yina yandi diilaka ndefi ya luvunu. Yandi ke vutula kima nyonso ya muvimba. Mpe yandi ke bwela kibuku mosi na kati ya bibuku tanu ya ntalu ya kima yina. Yandi ke pesa nyonso na muntu ya yawu, kilumbu yina yandi ke bakula ti yandi me sala yimbi. ");
INSERT INTO mkw_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Samu na kikodi na Yave, yandi ke nata na nganga-Nzambi dimeme ya mbakala, yina kele ve na kifuma. Yandi ke baka dimeme yina na kati ya bibulu ya yandi. Ntalu ya yawu ke vwanda mutindu ba zengaka samu na minkayulu ya kikodi. ");
INSERT INTO mkw_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Nganga-Nzambi ke sala kisalu samu na mulemvo ya disumu ya muntu yina, na mantwala ya Yave. Ata wapi mutindu vwandaka disumu yina yandi salaka, Yave ke lemvokila yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","na kupesa bantumunu yayi na Aloni mpe na bana ya yandi: «Yayi ni Musiku yina me tadila Munkayulu ya Kuyoka: Munkayulu ya kuyoka ke vwanda na tiya mpimpa nyonso tii suka, na kiyokolo ya minkayulu. Tiya yina kele na kiyokolo ya minkayulu ke tatamana na kulema. ");
INSERT INTO mkw_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Nganga-Nzambi ke lwata kinkuti ya yandi ya lino. Mpe yandi ke lwata mibati ya lino na nzutu ya yandi. Yandi ke baka bombi ya mafuta yina me bikana na manima ya kuyoka munkayulu na kiyokolo ya minkayulu. Yandi ke tula yawu pene-pene ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Yandi ke katula binkuti yina me vwanda na yandi samu na kulwata ya nkaka. Mpe yandi ke nata bombi ya mafuta ntama na kivwandu. Yandi ke nata yawu na Kisika mosi kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Tiya yina kele na kiyokolo ya minkayulu ke lema kaka. Yawu fwana kufwa ve. Konso suka, nganga-Nzambi fwana tulaka bankuni na tiya yina. Yandi ke tula Munkayulu ya Kuyoka na zulu ya bankuni. Mpe na zulu ya munkayulu, yandi ke yoka mafuta ya bibulu yina ba me pesa mutindu minkayulu ya kiwisa. ");
INSERT INTO mkw_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Tiya ke lema konso ntangu na kiyokolo ya minkayulu. Yawu fwana kufwa ve.» ");
INSERT INTO mkw_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","«Yayi ni Musiku yina me tadila Munkayulu ya madya ya bilanga: Ni bana ya Aloni ke banda na kupesaka yawu na Yave, na mantwala ya Kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Na munkayulu yina, nganga-Nzambi ke baka diboko ya kufuluka ya faline ya kitoko na mafuta ya yawu, na maaka nyonso ya nsunga ya mbote yina kele na zulu ya munkayulu. Nganga-Nzambi ke yoka yawu na kiyokolo ya minkayulu, samu na kubambuka moyo. Nsunga ya yawu ke yangidikaka Yave. ");
INSERT INTO mkw_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Ndambu yina ke bikana, Aloni na bana ya yandi ke kudya yawu. Ba ke kudya yawu ata levule na kati. Ni na kisika mosi ya longo, na ngaanda ya Yinzo ya Mbwabanu ba ke kudya yawu. ");
INSERT INTO mkw_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ba ke lamba yawu ata kutula levule na kati. Yina ni kikunku mu me pesa bawu na kati ya madya yina ba me yokila munu. Yawu kele ya longo mingi, mutindu mosi na kikunku yina ke katukaka na minkayulu ya mulemvo, to na minkayulu ya kikodi. ");
INSERT INTO mkw_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Kaka bana ya babakala ya dikanda ya Aloni lenda kudya yawu. Yawu kele bansalulu ya bantangu nyonso, na bambandu nyonso. Kikunku yina me katuka na madya yina ba me yoka na tiya samu na Yave, yawu kele ya bawu. Konso muntu yina ke simba yawu fwana kuvwanda ya longo.» ");
INSERT INTO mkw_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«Dikabu yina Aloni na bana ya yandi ke banda na kupesaka Yave, kubanda kilumbu yina ba ke byeka bawu ni yayi: na konso kilumbu, kikunku mosi na kati ya bikunku kumi ya Efa ya faline ya kitoko mutindu Munkayulu ya madya ya bilanga, ndambu na suka, ndambu na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ba ke vukisa faline yina na mafuta. Ba ke kalinga yawu na kikalungulu. Nge ke nata bibuku ya yawu ya kuya samu na kupesa yawu mutindu Munkayulu ya madya ya bilanga. Nsunga ya yawu ke yangidikaka Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","«Na kati ya bana ya Aloni, nganga-Nzambi yina ba ke byeka samu na kuzwa kifulu ya Aloni, yandi ke sala mutindu mosi. Ba ke yoka yawu nyonso. Ya kele bansalulu ya bantangu nyonso samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Konso Munkayulu ya madya ya bilanga yina nganga-Nzambi ke pesa, yawu kele ya kuyoka yawu nyonso. Ba fwana kudya yawu ve.» ");
INSERT INTO mkw_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","na kupesa bantumunu yayi na Aloni mpe na bana ya yandi: «Yayi ni Musiku yina me tadila Munkayulu ya mulemvo: Ba ke zenga laka ya kibulu yina me pesama mutindu Munkayulu ya mulemvo, na kisika yina ba ke kufwaka bibulu ya minkayulu ya kuyoka, na mantwala ya Yave. Ya kele munkayulu ya longo mingi. ");
INSERT INTO mkw_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Nganga-Nzambi yina ke pesa munkayulu yango ya mulemvo, ni yandi ke kudya yawu. Yandi ke kudya yawu na kisika mosi ya longo, na ngaanda ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Konso muntu yina ke simba mbisi ya munkayulu yango fwana kuvwanda ya longo. Kana menga ya yawu me kubwa na kinkuti, nge ke sukula didoti ya menga yina na kisika mosi ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ba ke pasula kinzu yina ba me lambila mbisi yango. Kana nzungu yina ba me lambila yawu kele ya kisengo ya mbwaki, ba ke sukula yawu mbote-mbote na maza. ");
INSERT INTO mkw_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Kaka babakala yina kele na kati ya makanda ya banganga-Nzambi ke kudya yawu. Yawu kele kima ya longo mingi. ");
INSERT INTO mkw_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kasi kibulu yina ba me kufwa samu na Munkayulu ya mulemvo, kana ba me nata menga ya yawu na kati ya Yinzo ya Mbwabanu kuna na kivinga ya longo, na kusala kisalu samu na mulemvo ya masumu, kibulu yango, ba fwana kudya yawu ve. Ba ke yoka yawu na tiya.» ");
INSERT INTO mkw_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«Yayi ni Musiku yina me tadila Munkayulu ya kikodi: Ya kele munkayulu mosi ya longo mingi. ");
INSERT INTO mkw_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ba ke kufwa kibulu ya Munkayulu ya kikodi na kisika yina ba ke kufwaka bibulu ya minkayulu ya kuyoka. Na manima ba ke mwanga menga ya kibulu yango na balweka nyonso ya Kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ba ke pesa bitini ya yawu nyonso ya mafuta, mukila, mafuta yina ke fukaka misopo, ");
INSERT INTO mkw_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","bambuma zole yina ke vwandaka na yisi ya mukongo, na mafuta yina ke ya kuvukana na yawu, mafuta yina ke ya kukangama na luketo, mbala ya kivumu yina yandi ke katula pene-pene ya bambuma yina ke vwandaka na yisi ya mukongo. ");
INSERT INTO mkw_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Nganga-Nzambi ke yoka yawu na kiyokolo ya minkayulu. Ya kele madya yina ba ke yokaka na tiya samu na Yave. Yawu kele Munkayulu ya kikodi. ");
INSERT INTO mkw_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kaka babakala yina kele na makanda ya banganga-Nzambi ke kudya yawu. Ba ke kudya yawu na kisika mosi ya longo. Yawu kele ya longo mingi. ");
INSERT INTO mkw_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Munkayulu ya kikodi kele kaka mutindu mosi na Munkayulu ya mulemvo. Musiku kele kaka mosi samu na nyonso zole. Mbisi kele ya nganga-Nzambi yina me sala kisalu samu na kukatula masumu.» ");
INSERT INTO mkw_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","«Kana muntu me nata kibulu mutindu Munkayulu ya Kuyoka, mpusu ya kibulu yina kele ya nganga-Nzambi yina me sala kisalu. ");
INSERT INTO mkw_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Konso Munkayulu ya madya ya bilanga yina ba me yoka na kifuule, to yina ba me lamba na nzungu, to mpe yina ba me kalinga na kikalungulu, ya kele ya nganga-Nzambi yina me sala kisalu. ");
INSERT INTO mkw_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Konso Munkayulu ya madya ya bilanga yina ba me vukisa na mafuta, to yina ba me vukisa ve na mafuta, ya kele ya bana nyonso ya Aloni. Bawu nyonso ke kuzwa mutindu mosi.» ");
INSERT INTO mkw_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«Yayi ni Musiku yina me tadila Munkayulu ya Kiwisa, yina ba me pesa na Yave: ");
INSERT INTO mkw_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kana muntu ke na kupesa yawu samu na kuvutula matondo, yandi ke pesa bima yayi kintwadi na munkayulu ya matondo: bagato yina ba me vukisa faline ya kitoko na mafuta, kasi ba me funisa ve, bagalete yina ba me funisa ve, yina ba me pakula mafuta, bagato yina ba me vukisa mbote-mbote faline ya kitoko na mafuta. ");
INSERT INTO mkw_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Na zulu ya bagato, yandi ke pesa mpe mampa yina ba me funisa, samu ti yawu kukwenda nzila mosi na Munkayulu ya Kiwisa yina yandi me pesa na kuvutula matondo. ");
INSERT INTO mkw_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Yandi ke pesa na Yave kikunku mosi-mosi ya konso munkayulu. Bikunku yango ke vwanda ya nganga-Nzambi yina me mwanga menga ya Munkayulu ya Kiwisa. ");
INSERT INTO mkw_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Mbisi ya kibulu ya Munkayulu ya Kiwisa yina ba me pesa samu na kuvutula matondo, ba ke kudya yawu kaka na kilumbu yina ba me pesa yawu. Ba ke bumba ata ndambu ve samu na mbasi na suka. ");
INSERT INTO mkw_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«Kana muntu me pesa Munkayulu ya Kiwisa samu na kulungisa nsilulu to samu na luzolo ya yandi mosi, ba ke kudya mbisi ya yawu na kilumbu yina ba me pesa munkayulu yango. Ndambu yina ke bikana, ba lenda kudya yawu kilumbu yina ke landa. ");
INSERT INTO mkw_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Mbisi yina ke bikana na manima ya bilumbu zole, ba ke yoka yawu na tiya. ");
INSERT INTO mkw_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kana ba kudya mbisi ya Munkayulu ya Kiwisa na manima ya bilumbu zole, Yave ke ndima munkayulu yina ve. Munkayulu yango ke vwanda ya mpamba. Mbisi yina ke vwanda dyaka ve ya mbote. Muntu yina ke kudya yawu, yimbi ya yandi ke vwanda na yintu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Mbisi yina me botana na konso kima ya Kuvedila ve, ba ke kudya yawu ve. Ba ke losa yawu na tiya. «Kaka bayina ke ya kuvedila lenda kudya mbisi ya munkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Kana muntu kele ya kuvedila ve, mpe yandi me kudya mbisi ya Munkayulu ya Kiwisa, yina me pesama na Yave, ba ke katula muntu yina na kati ya dikanda ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kana muntu me simba kima ya kuvedila ve, to kima ya kuvedila ve ya muntu, to kibulu ya kuvedila ve, to mpe konso kima ya nganzi ya kuvedila ve, mpe muntu yango me kudya mbisi ya Munkayulu ya Kiwisa, yina me pesama na Yave, ba ke katula muntu yina na kati ya dikanda ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","na kupesa bantumunu yayi na bana ya Isayeli: «Konso mafuta ya ngombe, to ya dimeme, to ya nkombo, beno kudya yawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mafuta ya kibulu yina me kufwa yawu mosi, to yina ba me kufwa na kibulu ya nkaka, ba lenda sadila yawu kisalu ni kisalu. Kasi beno kudya yawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Samu ti konso muntu yina me kudya mafuta ya kibulu yina me pesama mutindu madya yina ba me yoka na tiya samu na Yave, muntu yina ke kudya yawu, ba ke katula yandi na kati ya dikanda ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Na konso kisika yina beno ke zinga, beno kudya ve menga. Ya vwanda menga ya ndeke to menga ya kibulu. ");
INSERT INTO mkw_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Konso muntu yina ke kudya menga ni menga, ba ke katula yandi na kati ya dikanda ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","na kupesa dyaka bantumunu yayi na bana ya Isayeli: «Kana muntu ke pesa Yave Munkayulu ya Kiwisa, yandi fwana kunatina Yave kikunku ya yandi, yina yandi ke katula na kati ya munkayulu yango ya kiwisa. ");
INSERT INTO mkw_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Yandi ke nata yandi mosi mafuta mutindu madya yina ba me yoka na tiya samu na Yave. Yandi ke nata yawu kintwadi na ntulu ya kibulu. Ntulu yango yandi ke pesa yawu na mutindu ba ke sadilaka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Nganga-Nzambi ke yoka mafuta na Kiyokolo ya minkayulu. Ntulu ke vwanda ya Aloni na bana ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Beno ke katula mpe kito ya manima ya lubakala ya bibulu ya minkayulu ya beno ya kiwisa. Beno ke pesa yawu na nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Kito yango kele kikunku ya mwana ya Aloni yina me nata menga mpe mafuta ya kibulu ya Munkayulu ya Kiwisa na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ntulu yina ba ke pesaka na mutindu ba ke sadilaka na mantwala ya Yave, mpe kito yina ba ke katulaka, mu me baka yawu na sika ya bana ya Isayeli, na kati ya minkayulu ya bawu ya kiwisa. Mpe mu me pesa yawu na nganga-Nzambi Aloni mpe na bana ya yandi. Yayi ke bansalulu ya bantangu nyonso samu na bana ya Isayeli na kupesaka na nganga-Nzambi Aloni mpe na bana ya yandi kikunku yina.» ");
INSERT INTO mkw_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Yina ni kikunku ya Aloni mpe kikunku ya bana ya yandi na kati ya madya yina ba ke yokaka na tiya samu na Yave, kubanda kilumbu yina ba kotisaka bawu na kisalu ya bunganga-Nzambi ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ni kikunku yina Yave tumisaka bana ya Isayeli na kupesaka bawu kubanda kilumbu yina yandi ke byeka bawu. Ya kele bansalulu ya bantangu nyonso samu na bawu, bambandu nyonso. ");
INSERT INTO mkw_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Yina ni misiku yina me tadila Munkayulu ya Kuyoka, Munkayulu ya madya ya bilanga, Munkayulu ya mulemvo, Munkayulu ya kikodi, munkayulu ya mbyekolo na bunganga-Nzambi, Munkayulu ya Kiwisa. ");
INSERT INTO mkw_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Yave pesaka yawu na Moyize, na mongo ya Sinayi, kilumbu yina yandi tumisaka bana ya Isayeli na kupesa minkayulu ya bawu na Yave, kuna na yinsi ya kuyuma ya Sinayi. ");
INSERT INTO mkw_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Bokila Aloni, na bana ya yandi ya babakala. Baka binkuti ya bunganga-Nzambi, na mafuta ya mbyekolo. Baka na ngombe ya mbakala ya kupesa samu na Munkayulu ya mulemvo. Baka mpe mameme zole ya mbakala, na kitunga ya mampa yina ba funisaka ve. ");
INSERT INTO mkw_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Kutikisa mukangu nyonso ya bantu ya Isayeli na mwelo ya Yinzo ya Mbwabanu.» ");
INSERT INTO mkw_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moyize salaka mutindu Yave tumisaka yandi na kusala. Mukangu nyonso yonzamaka na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moyize tubaka na mukangu nyonso mutindu yayi: «Yayi ni mambu yina Yave me tumisa na kusala.» ");
INSERT INTO mkw_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moyize tubaka na Aloni na bana ya yandi na kubelama. Mpe yandi yobisaka bawu na maza. ");
INSERT INTO mkw_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Yandi lwatisaka Aloni kinkuti. Yandi tulaka yandi mukaba na luketo. Yandi lwatisaka dyaka yandi dizwela, mpe yandi lwatisaka yandi efode na zulu. Yandi kangaka yandi basinga ya efode na mukongo. ");
INSERT INTO mkw_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Yandi lwatisaka yandi peketolale na ntulu. Na kati ya peketolale yango, yandi tulaka bima ya longo yina ba ke bokilaka Ulime mpe Tumime. ");
INSERT INTO mkw_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Yandi lwatisaka yandi yimpu ya kinganga-Nzambi. Yandi tulaka kifulu ya wolo na zulu ya yimpu yango, na lweka ya mbunzu ya yandi. Kifulu yina, ni kidimbu ya mbyekolo, mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moyize bakaka mafuta ya mbyekolo, yandi kusaka yawu na Yinzo ya Mbwabanu mpe na bima nyonso yina vwandaka na kati ya Yinzo yango. Ni mutindu yina yandi byekaka yawu. ");
INSERT INTO mkw_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Yandi mwangaka mafuta yango bambala nsambwadi na Kiyokolo ya minkayulu. Yandi kusaka mafuta na kiyokolo ya minkayulu, na bisalulu ya yawu nyonso, na ndonga ya nene mpe na kivwandulu ya ndonga yango, samu na kubyeka yawu. ");
INSERT INTO mkw_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Yandi mwangisaka mafuta ya mbyekolo na zulu ya yintu ya Aloni. Yandi dukulaka yandi mafuta samu na kubyeka yandi. ");
INSERT INTO mkw_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moyize tumisaka bana ya babakala ya Aloni na kubelama. Yandi lwatisaka bawu binkuti. Yandi tulaka bawu mikaba na luketo. Yandi lwatisaka bawu bayimpu ya bunganga-Nzambi mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Moyize tumisaka ba nata ngombe ya mbakala samu na Munkayulu ya mulemvo. Aloni na bana ya yandi tentikaka maboko ya bawu na zulu ya yintu ya ngombe yango. ");
INSERT INTO mkw_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moyize zengaka yawu laka. Mpe yandi bakaka menga ya yawu. Na musapi ya yandi, yandi tulaka menga yina na mampoka ya kiyokolo ya minkayulu, na balweka nyonso, samu na kuvedisa kiyokolo ya minkayulu. Yandi mwangisaka menga yina bikanaka na kivwandulu ya kiyokolo ya minkayulu. Yandi byekaka kiyokolo ya minkayulu samu na kuvedisa yawu. ");
INSERT INTO mkw_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moyize bakaka mafuta nyonso yina kele ya kuvukana na misopo, na mbala ya kivumu, na bambuma zole yina kele na yisi ya mukongo mpe mafuta ya yawu. Moyize yokaka yawu na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Kasi nyonso yina bikanaka na ngombe yango: mpusu, misuni, na matufi yina kele na kati ya misopo, yandi yokaka yawu na tiya, ntama na kivwandu, mutindu Yave tumisaka na Moyize na kusala. ");
INSERT INTO mkw_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Yandi bakaka dimeme ya mbakala ya kupesa mutindu Munkayulu ya Kuyoka. Aloni na bana ya yandi tentikaka maboko ya bawu na zulu ya yintu ya dimeme yango. ");
INSERT INTO mkw_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moyize zengaka laka ya yawu. Mpe yandi mwangaka menga ya yawu na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Moyize saasaka dimeme yango. Yandi yokaka bitini ya mbisi, na yintu, na mafuta. ");
INSERT INTO mkw_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Yandi sukulaka misopo na makulu na maza. Yandi yokaka yawu na dimeme nyonso na kiyokolo ya minkayulu. Yawu vwandaka Munkayulu ya Kuyoka, nsunga ya yawu yangidikaka Yave. Ni madya yina ba ke yokaka na tiya samu na Yave, mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Yandi tumisaka ba nata dimeme ya zole ya mbakala. Ya kele dimeme samu na mbyekolo na bunganga-Nzambi. Aloni na bana ya yandi tentikaka maboko ya bawu na zulu ya yintu ya dimeme. ");
INSERT INTO mkw_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moyize kufwaka yawu. Yandi bakaka menga ya yawu, mpe yandi tulaka menga yina na zulu ya dikutu ya lubakala ya Aloni. Yandi tulaka dyaka yawu na musapi ya nene ya diboko ya yandi ya lubakala, mpe na musapi ya nene ya dikulu ya yandi ya lubakala. ");
INSERT INTO mkw_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Moyize tumisaka bana ya Aloni na kubelama. Yandi tulaka menga na zulu ya makutu ya bawu ya lubakala. Yandi tulaka dyaka menga na misapi ya nene ya maboko ya bawu ya lubakala, mpe na misapi ya nene ya makulu ya bawu ya lubakala. Yandi mwangaka mpe menga na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Na manima Moyize bakaka bima yayi na dimeme yango: mafuta, mukila, na mafuta nyonso yina ke ya kuvukana na misopo, mbala ya kivumu, na bambuma zole yina ke vwandaka na yisi ya mukongo mpe mafuta ya yawu, na kito ya manima ya lubakala. ");
INSERT INTO mkw_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Na kati ya kitunga ya mampa yina kele ve na levule, yina vwandaka na mantwala ya Yave, Moyize bakaka gato mosi yina kele ve na levule, na gato mosi ya kusalama na mafuta, na galete mosi. Yandi tulaka yawu na zulu ya bitini ya mafuta mpe kito ya manima ya lubakala ya dimeme. ");
INSERT INTO mkw_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Yandi tulaka nyonso na maboko ya Aloni, mpe na maboko ya bana ya yandi. Yandi tumisaka bawu na kupesa yawu na Yave na mutindu ba ke sadilaka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Na manima, Moyize bakaka dyaka yawu na maboko ya bawu. Mpe yandi yokaka yawu kintwadi na Munkayulu ya Kuyoka, na kiyokolo ya minkayulu. Ya vwandaka munkayulu ya mbyekolo na bunganga-Nzambi. Nsunga ya yawu yangidikaka Yave. Ya vwandaka madya yina ba ke yokaka na tiya samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moyize bakaka ntulu ya dimeme yango ya mbyekolo, mpe yandi pesaka yawu na Yave na mutindu ba ke sadilaka na mantwala ya Yave. Yina ni kikunku ya Moyize mutindu Yave tumisaka yandi yawu. ");
INSERT INTO mkw_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moyize bakaka mafuta ya mbyekolo na menga yina vwandaka na kiyokolo ya minkayulu. Yandi mwangaka yawu na zulu ya Aloni mpe na binkuti ya yandi. Moyize mwangaka yawu mpe na zulu ya bana ya Aloni mpe na binkuti ya bawu. Ni mutindu yina yandi byekaka Aloni mpe binkuti ya yandi, na bana ya Aloni na bikunti ya bawu. ");
INSERT INTO mkw_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moyize tubaka na Aloni mpe bana ya yandi: «Beno lamba mbisi ya dimeme yina ya zole na mwelo ya Yinzo ya Mbwabanu. Ni kuna beno ke kudya yawu na mampa yina kele na kati ya kitunga ya mbyekolo, mutindu kele ntumunu yina mu pesaka na beno, ti ni Aloni na bana ya yandi ke kudya yawu. ");
INSERT INTO mkw_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ndambu yina ke bikana na mbisi na mampa, beno ke yoka yawu na tiya. ");
INSERT INTO mkw_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Beno ke vwanda kaka kuna na mwelo ya Yinzo ya Mbwabanu bilumbu nsambwadi. Beno ke katuka ve kuna tekila bilumbu nyonso ya mbyekolo ya beno na bunganga-Nzambi kumanisa. Samu ti mbyekolo na bunganga-Nzambi ke baka bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Mambu yayi me salama bubu yayi, ya kele mambu yina Yave tumisaka na kusala samu ti Yave kukatula masumu ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Beno ke vwanda bilumbu nsambwadi mpimpa na ntangu na mwelo ya Yinzo ya Mbwabanu. Na manima beno ke sala kisalu ya Yave, mpe beno ke kufwa ve. Yina ni ntumunu mu kuzwaka.» ");
INSERT INTO mkw_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aloni na bana ya yandi salaka mambu nyonso yina Yave tumisaka na yinwa ya Moyize na kusala. ");
INSERT INTO mkw_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Na kilumbu ya nana, Moyize bokilaka Aloni na bana ya yandi, na bakuluntu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Yandi tubaka na Aloni: «Baka mwana ya ngombe mosi ya mbakala ya kupesa samu na Munkayulu ya mulemvo. Baka mpe dimeme mosi ya mbakala ya kupesa samu na Munkayulu ya Kuyoka. Bibulu nyonso zole kuvwanda ve na bifuma. Nata yawu na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Tuba na bana ya Isayeli mutindu yayi: “Beno baka nkombo mosi ya mbakala ya kupesa samu na Munkayulu ya mulemvo. Beno baka mpe mwana mosi ya ngombe na mwana mosi ya dimeme, nyonso zole ya mvula mosi, kondwa kifuma, ya kupesa samu na Munkayulu ya Kuyoka. ");
INSERT INTO mkw_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Beno baka mpe ngombe mosi ya mbakala na dimeme mosi ya mbakala ya kupesa Yave samu na Munkayulu ya Kiwisa. Beno baka mpe faline ya kuvukana na mafuta, ya kupesa samu na Munkayulu ya madya ya bilanga. Samu ti bubu yayi Yave ke talana na beno.”» ");
INSERT INTO mkw_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ba bakaka mpe ba nataka na mantwala ya Yinzo ya Mbwabanu bima yina Moyize tumisaka na kunata. Mukangu nyonso belamaka. Bawu kwizaka telama na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moyize tubaka: «Yayi ni mambu yina Yave me tumisa beno na kusala, samu ti nkembo ya yandi kutalana na beno.» ");
INSERT INTO mkw_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Na manima, Moyize tubaka na Aloni: «Belama na kiyokolo ya minkayulu. Pesa munkayulu ya nge ya mulemvo, na munkayulu ya nge ya kuyoka. Sala kisalu samu na kukatula masumu ya nge mpe ya bantu nyonso. Pesa mpe minkayulu yina bantu me nata. Sala kisalu samu na kukatula masumu ya bawu, mutindu Yave tumisaka na kusala.» ");
INSERT INTO mkw_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aloni belamaka na kiyokolo ya minkayulu. Yandi zengaka laka ya mwana ya ngombe ya kupesa samu na Munkayulu ya mulemvo ya masumu ya yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Bana ya yandi pesaka yandi menga ya yawu. Yandi tulaka musapi ya yandi na menga yango mpe Aloni tulaka yawu na mampoka ya kiyokolo ya minkayulu. Menga yina bikanaka, yandi mwangisaka yawu na kivwandulu ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Yandi yokaka na kiyokolo ya minkayulu mafuta ya kibulu yango, bambuma yina ke vwandaka na yisi ya mukongo, mbala ya kivumu, mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Yandi yokaka mbisi na mpusu na tiya, ntama na kivwandu. ");
INSERT INTO mkw_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aloni zengaka laka ya dimeme ya mbakala ya Munkayulu ya Kuyoka. Mpe bana ya yandi pesaka yandi menga ya dimeme yango. Yandi mwangaka yawu na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Na manima, bawu pesaka yandi yintu na bitini ya kibulu ya Munkayulu ya Kuyoka yina ba saasaka. Yandi yokaka yawu na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Yandi sukulaka misopo na makulu. Yandi yokaka yawu kintwadi na Munkayulu ya Kuyoka na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Na manima, Aloni pesaka na Yave munkayulu ya mukangu nyonso. Yandi bakaka nkombo ya mbakala yina bantu nataka samu na Munkayulu ya mulemvo. Yandi zengaka yawu laka, mpe yandi pesaka yawu mutindu Munkayulu ya mulemvo, mutindu yandi salaka na kibulu ya ntete. ");
INSERT INTO mkw_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Yandi pesaka Munkayulu ya Kuyoka. Yandi salaka yawu mutindu kele nsalulu ya misiku. ");
INSERT INTO mkw_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Yandi pesaka Munkayulu ya madya ya bilanga. Yandi bakaka diboko ya kufuluka ya faline ya kitoko, mpe yandi yokaka yawu na kiyokolo ya minkayulu, kintwadi na munkayulu yina ba ke yokaka konso suka. ");
INSERT INTO mkw_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Yandi kufwaka ngombe ya mbakala mpe dimeme ya mbakala yina bantu nataka samu na Munkayulu ya Kiwisa. Bana ya Aloni pesaka yandi menga ya bibulu yango. Yandi mwangaka yawu na balweka nyonso ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Bawu pesaka yandi mpe bitini ya mafuta ya ngombe na ya dimeme: mukila, mafuta yina ke fukaka misopo, bambuma yina ke vwandaka na yisi ya mukongo, mbala ya kivumu. ");
INSERT INTO mkw_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Bawu tulaka bitini ya mafuta yina na zulu ya bantulu ya bibulu nyonso zole. Mpe Aloni yokaka bitini ya mafuta na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aloni pesaka bantulu yina na kito ya manima ya lubakala na mutindu ba ke sadilaka na mantwala ya Yave. Yandi salaka yawu mutindu Moyize tumisaka yandi na kusala. ");
INSERT INTO mkw_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aloni nangunaka maboko ya yandi samu na kusakumuna bantu nyonso. Na manima ya kupesa Minkayulu ya mulemvo, Minkayulu ya kuyoka, mpe Minkayulu ya kiwisa, Aloni kulumukaka. ");
INSERT INTO mkw_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moyize na Aloni kotaka na kati ya Yinzo ya Mbwabanu. Ntangu bawu basikaka, bawu sakumunaka bantu nyonso. Mpe nkembo ya Yave talanaka na bantu nyonso. ");
INSERT INTO mkw_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Tiya mosi basikaka na mantwala ya Yave, mpe yawu kwendaka yoka minkayulu ya kuyoka, na bitini ya mafuta yina vwandaka na kiyokolo ya minkayulu. Mukangu nyonso talaka yawu. Bawu salaka milolo ya nsayi, mpe bawu kubwaka bizizi na ntoto. ");
INSERT INTO mkw_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadabe na Abiwu, bawu zole bana ya Aloni, bawu bakaka konso muntu kiyokolo ya yandi ya maaka ya nsunga ya mbote. Bawu tulaka tiya na kati, mpe bawu tulaka maaka ya nsunga ya mbote. Bawu nataka na mantwala ya Yave tiya ya nzenza yina Yave tumisaka bawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Tiya basikaka na mantwala ya Yave, mpe ya yokaka bawu. Bawu kufwaka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moyize tubaka na Aloni: «Yave tubaka mbote ti: «“Bayina ke belama na munu, bawu fwana kuzitisa bulongo ya munu. Bawu fwana kupesa munu nkembo na meso ya bantu nyonso.”» Aloni vwandaka swii. ");
INSERT INTO mkw_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moyize bokilaka Misayele na Elesafane, bana ya Uzyele, mama-nkazi ya Aloni. Yandi tubaka na bawu: «Beno kwiza katula banzutu ya bampangi ya beno na mantwala ya Yinzo ya longo. Beno nata yawu ntama na kivwandu.» ");
INSERT INTO mkw_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Bawu kwizaka baka banzutu yango na binkuti yina ba vwandaka ya kuvwata, mpe ba nataka yawu ntama na kivwandu, mutindu tubaka Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moyize tubaka na Aloni mpe na bana ya Aloni Eleyazale na Itamale: «Beno bika ve ti bansuki ya beno kuvwanda ya kumwangana. Beno pasula mpe ve binkuti ya beno. Samu ti beno lenda kufwa, mpe nkele ya Yave lenda bwidila mukangu nyonso. Ni bampangi ya beno, dikanda nyonso ya Isayeli ke dila bayina Yave me yoka na tiya. ");
INSERT INTO mkw_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Beno katuka ve na mwelo ya Yinzo ya Mbwabanu, samu ti beno kufwa ve. Samu ti mafuta ya mbyekolo na Yave kele na zulu ya beno.» Aloni na bana ya yandi salaka mutindu Moyize tubaka. ");
INSERT INTO mkw_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Yave tubaka na Aloni: ");
INSERT INTO mkw_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Nge na bana ya nge, beno kunwa ve vinu to malafu ya nkaka ya ngolo, ntangu beno ke kota na Yinzo ya Mbwabanu, samu ti beno kufwa ve. Ya kele bansalulu ya bantangu nyonso samu na beno, bambandu nyonso. ");
INSERT INTO mkw_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ya ke samu ti beno kuzaba na kuswasikisa bima yina kele ya longo na bima yina kele ya longo ve, bima yina kele ya kuvedila na bima yina kele ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Mpe samu ti beno kulongisa bana ya Isayeli misiku nyonso yina Yave pesaka bawu na nzila ya Moyize.» ");
INSERT INTO mkw_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moyize tubaka na Aloni mpe na bana yina bikanaka na yandi, Eleyazale na Itamale: «Beno baka ndambu ya madya ya bilanga yina me bikana na kati ya madya yina ba me yoka na tiya samu na Yave. Beno kudya yawu ata levule, pene-pene ya Kiyokolo ya minkayulu. Samu ti ya kele kima ya longo mingi. ");
INSERT INTO mkw_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Beno ke kudya yawu na kisika mosi ya longo. Samu ti ya kele kikunku ya nge mpe ya bana ya nge na kati ya madya yina ba ke yokaka na tiya samu na Yave. Yina ni ntumunu mu kuzwaka. ");
INSERT INTO mkw_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ntulu yina ba ke pesaka na mutindu ba ke sadilaka na mantwala ya Yave, mpe kito yina ba ke katulaka, beno ke kudya yawu na kisika mosi ya kuvedila, nge mosi na bana ya nge ya babakala mpe ya bakento. Samu ti ya kele kikunku ya nge mpe ya bana ya nge, yina me pesama na beno na kati ya minkayulu ya kiwisa, yina bana ya Isayeli ke pesaka. ");
INSERT INTO mkw_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Kito yina ba ke katulaka, mpe ntulu yina ba ke pesaka na mutindu ba ke sadilaka na mantwala ya Yave, bawu ke nata yawu kintwadi na mafuta ya kuyoka, samu na kupesa nyonso na mutindu ba ke sadilaka na mantwala ya Yave. Na manima, yawu me kuma ya nge mpe ya bana ya nge. Ya kele bansalulu ya bantangu nyonso samu na beno mutindu Yave tumisaka yawu.» ");
INSERT INTO mkw_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moyize sosaka wapi sika kwendaka nkombo ya mbakala, yina ba pesaka samu na Munkayulu ya mulemvo. Yandi kwizaka bakula ti ba yokaka yawu. Na yina, yandi kuzwaka nkele samu na bana ya Aloni yina bikanaka, Eleyazale na Itamale. Yandi tubaka na bawu: ");
INSERT INTO mkw_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Samu na yinki beno me kudya ve mbisi ya Munkayulu ya mulemvo na kisika ya longo? Ya kele kima ya longo mingi. Yave pesaka beno yawu samu ti beno kubaka kizitu ya masumu ya bantu nyonso, mpe beno kusala kisalu na mantwala ya Yave samu na kukatula masumu yina. ");
INSERT INTO mkw_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ba me nata ve menga ya yawu na kati ya kivinga ya longo. Ni yawu yina ya lungaka ti beno kudya yawu na kisika mosi ya longo, mutindu mu tumisaka beno.» ");
INSERT INTO mkw_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aloni vutulaka na Moyize: «Ni bubu yayi bawu me pesa munkayulu ya bawu ya mulemvo, na munkayulu ya bawu ya kuyoka na mantwala ya Yave. Na manima ya mambu yayi yina me kwiza bwidila munu, kana mu zolaka kudya Munkayulu ya mulemvo na kilumbu ya bubu yayi, Yave zolaka tala yawu mbote?» ");
INSERT INTO mkw_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Moyize kuwaka mvutu yina. Yandi talaka ti yawu vwandaka mvutu mosi ya mbote. ");
INSERT INTO mkw_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yave tubaka na Moyize mpe na Aloni ");
INSERT INTO mkw_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","na kuzonza na bana ya Isayeli mutindu yayi: «Na kati ya bibulu nyonso yina kele na ntoto, beno lenda kudya ");
INSERT INTO mkw_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","bibulu yina kele na bikodya ya kukabuka na bandambu zole, mpe ke vutulaka na yinwa madya yina vwandaka na kati ya kivumu samu na kudya dyaka yawu. Ni yina beno lenda kudya. ");
INSERT INTO mkw_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Kasi na kati ya bibulu yina kele na bikodya ya kukabuka na bandambu zole, to yina ke vutulaka na yinwa madya yina vwandaka na kati ya kivumu samu na kudya dyaka yawu, bibulu yina beno lenda kudya ve ni yayi: - Samo, samu ti yawu ke vutulaka na yinwa madya yina vwandaka na kati ya kivumu samu na kudya dyaka yawu, kasi yawu kele ve na bikodya ya kukabuka na bandambu zole. Samo kele kibulu yina kele ya Kuvedila ve samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","- Nsibisi, samu ti yawu kele ve na bikodya ya kukabuka na bandambu zole, ata ti yawu ke vutulaka na yinwa madya yina vwandaka na kati ya kivumu samu na kudya dyaka yawu. Nsibisi kele kibulu yina kele ya kuvedila ve samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","- Mboloko, samu ti yawu kele ve na bikodya ya kukabuka na bandambu zole, ata ti yawu ke vutulaka na yinwa madya yina vwandaka na kati ya kivumu samu na kudya kudya yawu. Mboloko kele kibulu yina kele ya kuvedila ve samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","- Ngulu, samu ti yandi ke vutulaka ve na yinwa madya yina vwandaka na kati ya kivumu samu na kudya dyaka yawu, ata ti yandi kele na bikodya ya kukabuka na bandambu zole. Ngulu kele kibulu yina kele ya kuvedila ve samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Beno kudya ve mbisi ya bibulu yina. Beno simba mpe ve yawu ya kufwa. Yawu kele ya kuvedila ve samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«Na kati ya bambisi nyonso yina ke zingaka na kati ya maza, bambisi yina beno lenda kudya ni yayi: konso mbisi yina kele na matolo na makalu, ya vwanda na mubu to na mizumba. Yina, beno lenda kudya yawu. ");
INSERT INTO mkw_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Kasi beno fwana kutala nganzi nyonso yina kele ve na matolo na makalu na kati ya nyonso yina ke kwendaka tambula mpe ke zingaka na mubu mpe na mizumba. ");
INSERT INTO mkw_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Yina ya kele nganzi samu na beno. Beno kudya mbisi ya yawu ve. Bambisi yango ya kufwa ke vwanda nganzi samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Nyonso yina ke zingaka na kati ya maza, yina kele ve na matolo mpe na makalu, ya kele nganzi samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«Na kati ya bandeke, ni yayi beno fwana kutala nganzi, beno lenda kudya yawu ve, ya kele nganzi: koko-mbele, ndeke ya nkaka yina kele mutindu mbemba, mbemba ya mubu, ");
INSERT INTO mkw_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","bimbembe, na bandeke ya nkaka mutindu kele makanda ya bawu, ");
INSERT INTO mkw_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","konso mutindu ya bankwankwa, ");
INSERT INTO mkw_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","bango-nuni, bimfutu, bandeke ya mubu, konso mutindu ya bakoko-mbele, ");
INSERT INTO mkw_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","bimfutu ya mutindu ya nkaka, bandeke yina ke kotaka na maza, bandeke yina ke dilaka mutindu nyawu, ");
INSERT INTO mkw_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","bimfutu yina ke kumaka ve nene, bimfutu ya yinsi ya kuyuma, bambemba ya mutindu ya nkaka, ");
INSERT INTO mkw_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","bandeke ya madyanga, konso mutindu ya bangongo, bankusu mpe bangembo.» ");
INSERT INTO mkw_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«Konso kibulu ya fyoti-fyoti yina kele na mapapu mpe ke tambulaka na makulu yiya, ya ke nganzi samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Kasi na kati ya mwa bibulu ya fyoti yina kele na mapapu mpe ke tambulaka na makulu yiya, beno lenda kudya yina kele na makulu ya kudumukina na ntoto. ");
INSERT INTO mkw_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Na kati ya bibulu yina, bibulu yina beno lenda kudya ni yayi: konso mutindu ya makonko, konso mutindu ya bambele-mbele, konso mutindu ya banzenze. ");
INSERT INTO mkw_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Kasi konso kibulu ya fyoti yina kele na mapapu mpe ke tambulaka na makulu yiya, ya kele nganzi samu na beno.» ");
INSERT INTO mkw_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«Bibulu yayi lenda sala ti beno kuvwanda ya kuvedila ve. Konso muntu yina ke simba yawu ya kufwa, yandi ke vwanda ya Kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Konso muntu yina ke nanguna yawu ya kufwa, yandi fwana kusukula binkuti ya yandi. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Konso kibulu yina kele na bikodya ya kukabuka ve na bandambu zole, na yina ke vutulaka ve na yinwa madya yina vwandaka na kati ya kivumu samu na kudya dyaka yawu, yawu kele ya kuvedila ve samu na beno. Konso muntu yina ke simba yawu, yandi ke vwanda ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Bibulu nyonso ya makulu yiya yina kele ve na bikodya, ya kele ya kuvedila ve samu na beno. Muntu yina ke simba yawu ya kufwa, yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Muntu yina ke nanguna yawu ya kufwa, yandi fwana kusukula binkuti ya yandi. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. Bibulu yina kele ya kuvedila ve samu na beno.» ");
INSERT INTO mkw_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«Na kati ya bibulu ya fyoti-fyoti yina ke kwendaka tambula na ntoto, yina kele ya kuvedila ve samu na beno ni yayi: bankumbi, bampuku, konso mutindu ya bisyalala ya nene, ");
INSERT INTO mkw_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","mitindu ya nkaka ya bisyalala na balungwenya. ");
INSERT INTO mkw_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ni bibulu yina kele ya kuvedila ve samu na beno, na kati ya mwa bibulu ya fyoti-fyoti yina ke kwendaka tambula. Konso muntu yina ke simba yawu ya kufwa, yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Kana kibulu mosi na kati ya yawu me kufwa mpe me kubwa na zulu ya konso kima, kima yina me kuma ya kuvedila ve. Ya vwanda kima ya kusalama na yinti, ya vwanda kilele, to mpusu ya kibulu, to ngoto, to mpe kima ni kima yina ba ke sadilaka. Ba ke sukula kima yango na maza, mpe yawu ke vwanda ya kuvedila ve tii na nkokila. Na manima, yawu ke vwanda ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kana yawu me kubwa na kati ya kiteko ya kusalama na ntoto, kima ni kima yina kele na kati ya kiteko yina ke vwanda ya kuvedila ve. Mpe ba fwana kupasula kiteko yango. ");
INSERT INTO mkw_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Kana maza yina vwandaka na kati ya kiteko yango me kubwa na zulu ya kima ni kima yina ba ke kudyaka, kima yina me kuma ya kuvedila ve. Kana ya kele kima ni kima yina ba ke kunwaka, yina kele na kati ya kiteko ni kiteko, kima yina me kuma ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Kana kibulu ya kufwa me kubwa na zulu ya konso kima, kima yina me kuma ya kuvedila ve. Kana ya kele kifuule to diziku, beno mwangisa yawu. Yawu kele ya kuvedila ve. Yawu fwana kuvwanda ya kuvedila ve samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Kasi kana ya kele mukelo to dibulu ya maza, maza yina ke vwanda kaka ya kuvedila. Kasi muntu yina ke katula kibulu ya kufwa na kati, yandi ke vwanda ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kana mosi ya bibulu ya kufwa me kubwa na zulu ya bambuma ya kukuna, bambuma yango ke vwanda kaka ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Kasi kana ba me tulaka maza na kati ya bambuma, mpe kibulu yina ya kufwa me kubwa na kati, bambuma yango ke vwanda ya kuvedila ve samu na beno.» ");
INSERT INTO mkw_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«Kana kibulu mosi na kati ya bibulu yina beno ke kudyaka me kufwa, muntu yina ke simba yawu, ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Muntu yina ke kudya mbisi ya yawu fwana kusukula binkuti ya yandi. Yandi ke vwanda ya kuvedila ve tii na nkokila. Muntu yina ke nanguna kibulu yina ya kufwa, yandi fwana kusukula binkuti ya yandi, mpe yandi ke vwanda ya kuvedila ve tii na nkokila.» ");
INSERT INTO mkw_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«Mwa bibulu nyonso ya fyoti-fyoti yina ke tambulaka na ntoto, ya kele nganzi. Beno kudya yawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Beno kudya ve ata kibulu ya fyoti-fyoti, ya vwanda yina ke tambulaka na kivumu, to yina ke tambulaka na makulu yiya, to mpe yina kele na makulu ya mingi. Ya kele nganzi. ");
INSERT INTO mkw_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Beno kukikumisa ve nganzi samu na mwa bibulu ya fyoti-fyoti yina. Beno kukuma ve ya kuvedila ve samu na yawu. Kana ve, beno ke vwanda ya kuvedila ve samu na yawu. ");
INSERT INTO mkw_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Samu ti munu, mu kele Yave Nzambi ya beno, beno kuma bantu ya longo. Beno kuvwanda bantu ya longo, samu ti mu kele ya longo. Beno kuvwanda ve bantu ya kuvedila ve, samu na mwa bibulu ya fyoti-fyoti yina ke tambulaka na ntoto. ");
INSERT INTO mkw_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Samu ti munu, mu kele Yave, yina basisaka beno na yinsi ya Ngipiti samu na kuvwanda Nzambi ya beno. Beno kuvwanda bantu ya longo, samu ti mu kele ya longo.» ");
INSERT INTO mkw_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Yina ni Musiku yina me tadila bibulu, na bandeke, na bima nyonso ya moyo yina ke tambulaka na maza, na mwa bibulu ya fyoti-fyoti yina kele na ntoto. ");
INSERT INTO mkw_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ya kele samu na kukabula bibulu ya kuvedila na yina kele ya kuvedila ve, bibulu yina ba lenda kudya na yina ba lenda kudya ve. ");
INSERT INTO mkw_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","na kuzonza na bana ya Isayeli mutindu yayi: «Kana kento yina ke na kivumu me buta mwana ya bakala, yandi ke vwanda ya kuvedila ve bilumbu nsambwadi. Yandi ke vwanda ya kuvedila ve mutindu na ntangu yandi ke talaka menga. ");
INSERT INTO mkw_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Na kilumbu ya nana, ba ke zenga bubakala ya mwana. ");
INSERT INTO mkw_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Na manima, kento yango ke sala bilumbu makumi tatu na tatu na kuvedisa nzutu ya yandi na yina me tadila menga yina basikaka yandi. Yandi fwana kusimba ve ata kima mosi ya longo. Yandi lenda kwenda mpe ve na Yinzo ya longo, tii na ntangu ke manisa bilumbu nyonso ya kuvedisa nzutu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","«Kana yandi me buta mwana ya kento, yandi ke vwanda ya kuvedila ve balumingu zole, mutindu na ntangu yandi ke talaka menga. Na manima, yandi ke sala bilumbu makumi sambanu na sambanu na kuvedisa nzutu ya yandi samu na menga yina basikaka yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«Ntangu bilumbu ya kuvedisa nzutu ke manisa, ya vwanda samu na mwana ya bakala to samu na mwana ya kento, mama ke kwenda na sika ya nganga-Nzambi na mwelo ya Yinzo ya Mbwabanu. Yandi ke nata dimeme ya mvula mosi samu na Munkayulu ya kuyoka. Yandi ke nata mpe dibembe to kiduka samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Nganga-Nzambi ke nata yawu na mantwala ya Yave. Mpe yandi ke sala kisalu samu na kuvedisa kento yina. Mpe kento yango ke kuma ya kuvedila na yina me tadila menga yina basikaka yandi.» Yina ni Musiku yina me tadila kento yina me buta mwana ya bakala to ya kento. ");
INSERT INTO mkw_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","«Kana kento yango me lembana na kuzwa dimeme, yandi ke nata biduka zole to mabembe zole ya fyoti. Mosi samu na Munkayulu ya Kuyoka, ya nkaka samu na Munkayulu ya mulemvo ya masumu. Nganga-Nzambi ke sala kisalu samu na kuvedisa yandi. Mpe yandi ke kuma ya kuvedila.» ");
INSERT INTO mkw_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yave tubaka na Moyize mpe Aloni: ");
INSERT INTO mkw_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Kana muntu me kuzwa diwumbu na mpusu ya yandi, to kana yandi me kuzwa lota, to kana yandi me kuzwa mputa yina lenda kuma kimbevo ya mpusu, ba ke nata muntu yina na sika ya nganga-Nzambi Aloni, to na sika ya mosi na bana ya yandi, banganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Nganga-Nzambi ke tala mbote-mbote kisika yina kele kimbevo. Kana yandi me tala ti na kisika yango mika me kuma mpembe, mpe kisika yango me sala mwa dibulu na mpusu, zaba ti ya kele kimbevo ya bwazi. Nganga-Nzambi ke tala yawu mbote-mbote, mpe yandi ke tuba ti muntu yina kele ya Kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kana ya ke na didoti ya mpembe na mpusu, mpe ya me sala mwa dibulu ve, mika mpe me kuma ve mpembe, nganga-Nzambi ke tula mbevo yina na kisika ya yandi mosi, bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Na kilumbu ya nsambwadi, nganga-Nzambi ke tala dyaka yandi mbote-mbote. Kana yandi tala ti mputa me soba ve, ya me mwangana na mpusu ve, yandi ke bumba dyaka muntu yango na kisika ya yandi mosi, bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Na kilumbu ya nsambwadi, nganga-Nzambi ke tala dyaka yandi mbote-mbote. Kana mputa me yuma, kasi yawu me mwangana ve na mpusu, nganga-Nzambi ke tuba ti muntu yango kele ya kuvedila. Ya kele kaka lota ya mpamba. Muntu yango ke sukula binkuti ya yandi. Mpe yandi ke vwanda ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Kasi kana muntu yango kwendaka talana na nganga-Nzambi, mpe nganga-Nzambi tubaka ti yandi kele ya kuvedila, kana lota yango ke ntete na kumwanganaka na mpusu, muntu yina ke kwenda talana dyaka na sika ya nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Nganga-Nzambi ke tala yandi mbote-mbote. Kana lota me mwangana na mpusu, nganga-Nzambi ke tuba ti muntu yina kele ya kuvedila ve. Yawu kele na bwazi.» ");
INSERT INTO mkw_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Kana muntu me kuzwa kimbevo ya bwazi, ba ke nata yandi na sika ya nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Nganga-Nzambi ke tala yandi mbote-mbote. Kana nganga-Nzambi tala diwumbu ya mpembe, kana diwumbu yina me kumisa mika mpembe, mpe kana musuni ke na kutalana, ");
INSERT INTO mkw_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ya kele kimbevo ya bwazi yina ke manisaka ve. Nganga-Nzambi ke tuba ti muntu yango kele ya kuvedila ve. Nganga-Nzambi ke bika kwandi na kubumba yandi na kisika ya yandi mosi. Yandi kele ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kana ya ke na kutalana na meso ya nganga-Nzambi ti bwazi me basisa mawumbu na mpusu nyonso ya muntu yango, kubanda na makulu tii na yintu, ");
INSERT INTO mkw_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Nganga-Nzambi ke tala yandi mbote-mbote. Kana bwazi me mwangana na nzutu nyonso, yandi ke tuba ti kimbevo yina ke salaka ve ti muntu kuvwanda ya kuvedila ve. Muntu yina kele ya yandi ya kuvedila samu ti nzutu ya yandi nyonso me kuma mpembe. ");
INSERT INTO mkw_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Kasi kilumbu yina mputa ke funguka, mpe musuni ya yandi ke banda na kutalana, muntu yina ke vwanda ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Nganga-Nzambi ke tala bisika yina musuni ke na kutalana. Mpe yandi ke tuba ti muntu yango kele ya kuvedila ve. Musuni ya kufunguka kele ya kuvedila ve. Ya kele bwazi. ");
INSERT INTO mkw_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Kana musuni ya kufunguka yina me kuma dyaka mpembe, muntu yango ke kwenda dyaka na sika ya nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Nganga-Nzambi ke tala yandi mbote-mbote. Kana nganga-Nzambi tala ti mputa me kuma mpembe, yandi ke tuba ti mputa yina ke salaka ve ti muntu kuvwanda ya kuvedila ve. Muntu kele ya yandi ya kuvedila.» ");
INSERT INTO mkw_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Kana muntu vwandaka na diwumbu, mpe diwumbu yango manisaka, ");
INSERT INTO mkw_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","kasi mwa mbuma ya mpembe to didoti ya mwa mbwaki me basika na kisika yina vwandaka diwumbu, muntu yina ke kwenda talana na sika ya nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Nganga-Nzambi ke tala yandi mbote-mbote. Kana mwa dibulu ke na kusalama kuna, mpe mika me kuma mpembe, nganga-Nzambi ke tuba ti muntu yina kele ya kuvedila ve. Ya kele kimbemvo ya bwazi yina ke na kubasikila na didoti ya diwumbu. ");
INSERT INTO mkw_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Kana nganga-Nzambi tala ti mika ya mpembe kele ve na kati ya didoti, mwa dibulu mpe kele ve, mputa ke na kuyuma, yandi ke bumba muntu yina na kisika ya yandi mosi, bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kana didoti me mwangana na mpusu, nganga-Nzambi ke tuba ti muntu yina kele ya kuvedila ve. Ya kele kimbevo ya bwazi. ");
INSERT INTO mkw_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Kasi kana didoti me soba ve, yawu me mwangana ve, yawu kele kaka didoti ya diwumbu. Nganga-Nzambi ke tuba ti muntu yina kele ya kuvedila.» ");
INSERT INTO mkw_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Kana muntu me kuya mpusu ya yandi na tiya, kana didoti ya mwa mbwaki to ya mpembe me basika na kisika yina kuyaka, ");
INSERT INTO mkw_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","nganga-Nzambi ke tala mbote-mbote kisika yango. Kana mika me kuma mpembe na kati ya didoti yina, mpe mwa dibulu me salama na kisika yango, ya kele bwazi ke na kuyilama na kisika yina kuyaka. Nganga-Nzambi ke tuba ti muntu yina kele ya kuvedila ve. Ya kele kimbevo ya bwazi. ");
INSERT INTO mkw_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Kasi ntangu nganga-Nzambi ke tala yawu, kana na kati ya didoti mika kele ve mpembe, mwa dibulu mpe kele ve, mputa kele ya kuyuma, nganga-Nzambi ke bumba yandi na kisika ya yandi mosi, bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Na kilumbu ya nsambwadi, nganga-Nzambi ke tala yandi mbote-mbote. Kana didoti me mwangana na mpusu ya nzutu, nganga-Nzambi ke tuba ti muntu yina kele ya kuvedila ve. Ya kele kimbevo ya bwazi. ");
INSERT INTO mkw_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Kasi kana didoti me soba ve, yawu me mwangana ve na mpusu ya nzutu, kana yawu me yuma, ya kele kaka kuvimba ya tiya. Nganga-Nzambi ke tuba ti muntu yango kele ya kuvedila. Ya kele didoti yina bikaka tiya.» ");
INSERT INTO mkw_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Kana muntu mosi ya bakala to ya kento me kuzwa kimbevo na mpusu ya yandi, na zulu ya yintu to na mubanga, ");
INSERT INTO mkw_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","nganga-Nzambi ke tala mbote-mbote kimbevo yango. Kana mwa dibulu me salama na kisika yina kele kimbevo, kana mika yina kele kuna me kuma ya fyoti-fyoti, mpe mwa mbwaki, nganga-Nzambi ke tuba ti muntu yina kele ya kuvedila ve. Ya kele makoko. Ya kele bwazi ya yintu to ya mubanga. ");
INSERT INTO mkw_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kasi ntangu nganga-Nzambi ke tala kimbevo yango ya makoko, kana yawu me sala ve mwa dibulu, kana bansuki mpe ke dyaka ndombe ve, nganga-Nzambi ke bumba muntu yango na kisika ya yandi mosi, bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Na kilumbu ya nsambwadi, nganga-Nzambi ke tala dyaka kimbevo yango mbote-mbote. Kana makoko me mwangana ve, mika me kuma ve mwa mbwaki, ya me sala mpe ve mwa dibulu, ");
INSERT INTO mkw_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","muntu yango ke katula bansuki ya yandi. Kasi yandi ke katula ve bansuki na kisika yina kele makoko. Na manima, nganga-Nzambi ke bumba dyaka yandi na kisika ya yandi mosi, bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Na kilumbu ya nsambwadi, nganga-Nzambi ke tala mbote-mbote makoko yango. Kana makoko me mwangana ve na mpusu ya nzutu, kana mwa dibulu kele ve, nganga-Nzambi ke tuba ti muntu yango kele ya kuvedila. Yandi ke sukula binkuti ya yandi. Mpe yandi ke vwanda ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Kasi kana nganga-Nzambi tubaka ti muntu yango kele ya kuvedila, kana na manima kuna, makoko me mwangana na mpusu ya nzutu, ");
INSERT INTO mkw_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","nganga-Nzambi ke tala dyaka yandi mbote-mbote. Kana makoko me mwangana na mpusu ya nzutu, nganga-Nzambi ke sosa dyaka ve mika ya mwa mbwaki. Muntu yina kele ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Kana yandi tala ti na meso ya yandi, makoko me vwanda kaka mutindu mosi, mika ya ndombe mpe me mena, ya ke na kulakisa ti muntu yina me nyaka. Yandi kele ya kuvedila. Mpe nganga-Nzambi ke tuba ti muntu yina kele ya kuvedila.» ");
INSERT INTO mkw_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Kana muntu mosi ya bakala to ya kento kele na madoti ya mpembe na mpusu ya nzutu ya yandi, ");
INSERT INTO mkw_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","nganga-Nzambi ke tala yandi mbote-mbote. Kana madoti kele mpembe ya mingi ve, ya kele kaka mwa kimbevo ya mpamba. Muntu yina kele ya yandi ya kuvedila.» ");
INSERT INTO mkw_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Kana bakala me katuka bansuki, mpe yandi me kuma na divenda, yandi kele kaka ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Kana ni bansuki ya lweka ya mbunzu me katuka, yandi kele na divenda ya mbunzu. Yandi kele kaka ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Kasi kana divenda ya dikosi to ya mbunzu me kuma mwa mbwaki na bamputa, ya kele bwazi ke na kubanda na divenda ya dikosi to ya mbunzu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Nganga-Nzambi ke tala yawu mbote-mbote. Kana yandi tala na divenda ya dikosi to ya mbunzu diwumbu ya mwa mbwaki yina kele mutindu bwazi ya mpusu, ");
INSERT INTO mkw_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","muntu yango kele na kimbevo ya bwazi. Yandi kele ya kuvedila ve. Nganga-Nzambi ke tuba ti muntu yina kele ya kuvedila ve. Kimbevo kele na yintu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Muntu yina kele na kimbevo ya bwazi fwana kulwata binkuti ya kupasuka. Yandi ke bika bansuki ya yandi ya kumwangana. Yandi ke fuka mandefo ya yandi. Mpe yandi ke banda na kwendaka looka mutindu yayi: “Ya kuvedila ve! Ya kuvedila ve!” ");
INSERT INTO mkw_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Bilumbu nyonso yina yandi ke vwanda na kimbevo yina, yandi ke vwanda ya kuvedila ve. Yandi ke zinga na kisika ya yandi mosi, ntama na kivwandu.» ");
INSERT INTO mkw_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Kana mbungi me basika na binkuti yina ba yidikaka na mika ya mameme to na lino, ");
INSERT INTO mkw_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","to kana mbungi me basika na bilele yina ba yidikaka na mika ya mameme to na lino, na mpusu ya kibulu to na kima yina ba yidikaka na mpusu ya kibulu, ");
INSERT INTO mkw_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","kana mbungi yango kele na ntinta ya maza ya saka-saka, to kana ya kele mwa mbwaki, ya kele mutindu ya mbungi. Mpe ba fwana kulakisa mbungi yina na nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Nganga-Nzambi ke tala mbote-mbote mbungi yango. Na manima yandi ke tula kima yina kele na mbungi yango na kisika ya yawu mosi, bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Na kilumbu ya nsambwadi, nganga-Nzambi ke tala dyaka mbote-mbote mbungi yango. Kana yawu me mwangana na kima yina, mbungi yina lenda manisa dyaka ve. Yawu kele ya yimbi. Kima yina kele ya Kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Nganga-Nzambi ke yoka kinkuti yango, to lele yina ba yidikaka na mika ya mameme to na lino, to kima yina ba yidikaka na mpusu ya kibulu. Ba fwana kuyoka kima yina, samu ti mbungi yina lenda katuka ve. ");
INSERT INTO mkw_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Kasi kana nganga-Nzambi tala ti mbungi me mwangana ve na kinkuti, to na divunga yina ba yidikaka na mika ya mameme to na lino, to na kima yina ba yidikaka na mpusu ya kibulu, ");
INSERT INTO mkw_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","nganga-Nzambi ke tumisa ba sukula kima yina me kuma na mbungi. Na manima, yandi ke tula dyaka yawu na kisika ya yawu mosi, bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Nganga-Nzambi ke tala dyaka mbote-mbote kima yango na manima ya kusukula yawu. Kana mbungi me soba ve, mpe yawu me mwangana ve, kima yina kele ya kuvedila ve. Ba fwana kuyoka yawu na tiya. Ata ti mbungi yango kele na zulu to na yisi. ");
INSERT INTO mkw_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Kasi kana nganga-Nzambi tala ti na manima ya kusukula kima yango, mbungi me banda na kumanisa, nganga-Nzambi ke zenga ndambu yina kele na mbungi na kinkuti, to na kilele, to na mpusu ya kibulu. ");
INSERT INTO mkw_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Kasi kana na bilumbu yina ke landa, mbungi basika dyaka na kinkuti, to na kilele, to na kima ni kima yina ba yidikaka na mpusu ya kibulu, mbungi yango me banda dyaka. Ba fwana kuyoka kima yina kele na mbungi. ");
INSERT INTO mkw_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","«Kana ba me sukula kima yina vwandaka na mbungi, ya vwanda kinkuti, ya vwanda kilele, ya vwanda kima yina ba yidikaka na mpusu ya kibulu, ba fwana kusukula dyaka yawu na mbala ya zole, samu ti ya vwanda ya kuvedila.» ");
INSERT INTO mkw_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Yina ni Musiku yina me tadila mbungi na zulu ya binkuti yina ba yidikaka na mika ya mameme mpe na lino, to na bima yina ba yidikaka na bampusu ya bibulu. Musiku yayi ke sadisa na kuzaba kana kima kele ya kuvedila to ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Yayi ni Musiku yina me tadila muntu ya bwazi, na kilumbu yina ba ke vedisa yandi. Ba ke nata yandi na sika ya nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Nganga-Nzambi ke kwenda ntama na kivwandu. Kana nganga-Nzambi tala ti muntu ya bwazi me beluka na kimbevo ya yandi ya bwazi, ");
INSERT INTO mkw_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","nganga-Nzambi ke tumisa ba nata samu na muntu yango yina ba ke vedisa, bandeke zole ya moyo, ya kuvedila, kibuku ya yinti ya sedele, singa ya mbwaki na kibuku ya kintala ya mukwisa. ");
INSERT INTO mkw_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Nganga-Nzambi ke tumisa ba zenga laka ya ndeke ya ntete na zulu ya kinzu yina kele na maza ya mukelo na kati ya yawu. ");
INSERT INTO mkw_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Nganga-Nzambi ke baka ndeke yina ya zole, na kibuku ya yinti ya sedele, na singa ya mbwaki, na kibuku ya kintala ya mukwisa. Yandi ke bondika yawu na kati ya menga ya ndeke yina ba me kufwa na zulu ya maza yina kele na kati ya kinzu. ");
INSERT INTO mkw_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Nganga-Nzambi ke mwanga menga bambala nsambwadi na muntu yina ba ke na kuvedisa na kimbevo ya bwazi. Na manima, yandi ke tuba ti muntu yango kele ya kuvedila. Mpe yandi ke bika ndeke yina ya moyo kukwenda ya yawu. ");
INSERT INTO mkw_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Muntu yina ba ke na kuvedisa ke sukula binkuti ya yandi. Yandi ke katula bansuki ya yandi nyonso, yandi ke yobila maza. Mpe yandi ke vwanda ya kuvedila. Na manima, yandi ke vutuka na kivwandu. Kasi yandi ke zinga bilumbu nsambwadi na ngaanda ya yinzo ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Na kilumbu ya nsambwadi, yandi ke katula bansuki ya yandi nyonso: bansuki ya yintu, mandefo, na bansuki yina ke vwandaka na zulu ya meso. Yandi ke bikana dyaka ve na bansuki. Yandi ke sukula binkuti ya yandi, mpe yandi ke yobila maza. Na manima, yandi ke vwanda ya kuvedila.» ");
INSERT INTO mkw_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«Na kilumbu ya nana, muntu yango ke baka mameme zole, yina kele ve na kifuma, na dimeme mosi ya nkento, ya mvula mosi, yina kele ve na kifuma. Yandi ke baka bakilo yivwa ya faline ya kitoko ya kuvukana na mafuta. Yandi ke baka mpe Longe mosi ya mafuta. Yina ni Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Nganga-Nzambi yina ke na kuvedisa ke baka muntu yango yina yandi ke na kuvedisa. Yandi ke tula yandi, na minkayulu ya yandi, na mantwala ya Yave, na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Nganga-Nzambi ke baka dimeme mosi. Ni dimeme yina ke vwanda Munkayulu ya kikodi. Yandi ke baka mpe Longe ya mafuta. Yandi ke zungisa yawu na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Yandi ke zenga dimeme yina laka na kisika yina yandi ke kufwaka bibulu ya minkayulu ya mulemvo na bibulu ya Minkayulu ya kuyoka, na kisika ya longo. Kibulu ya Munkayulu ya kikodi, na kibulu ya Munkayulu ya mulemvo, ya kele kikunku ya nganga-Nzambi. Ya kele kima ya longo mingi. ");
INSERT INTO mkw_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Nganga-Nzambi ke baka menga ya kibulu ya Munkayulu ya kikodi. Yandi ke tula yawu na zulu ya dikutu ya lubakala ya muntu yina ba ke na kuvedisa. Yandi ke tula mpe na musapi ya yandi ya nene ya diboko ya lubakala, mpe na musapi ya nene ya dikulu ya lubakala. ");
INSERT INTO mkw_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Nganga-Nzambi ke baka Longe ya mafuta, mpe yandi ke sekula yawu na diboko ya lumoso ya yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Yandi ke tula musapi ya diboko ya yandi ya lubakala na kati ya mafuta yango yina kele na diboko ya yandi ya lumoso. Na musapi yina, yandi ke mwanga mafuta bambala nsambwadi na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Na mafuta yina ke bikana na diboko, nganga-Nzambi ke tula mwa ndambu na zulu ya dikutu ya lubakala ya muntu yina ba ke na kuvedisa. Nganga-Nzambi ke tula mwa ndambu ya mafuta mpe na musapi ya nene ya diboko ya lubakala, mpe na musapi ya nene ya dikulu ya lubakala. Yandi ke tula mpe mwa ndambu ya mafuta na zulu ya menga ya kibulu ya Munkayulu ya kikodi. ");
INSERT INTO mkw_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Nganga-Nzambi ke tula mafuta yina me bikana na diboko ya yandi na yintu ya muntu yina ba ke na kuvedisa. Yandi ke sala kisalu samu na kuvedisa muntu yina, na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Na manima, nganga-Nzambi ke pesa Munkayulu ya mulemvo. Yandi ke sala kisalu samu na kuvedisa muntu yina na masumu ya yandi. Na manima, yandi ke zenga laka ya kibulu ya Munkayulu ya Kuyoka. ");
INSERT INTO mkw_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Nganga-Nzambi ke yoka yawu na kiyokolo ya minkayulu, kintwadi na Munkayulu ya madya ya bilanga. Nganga-Nzambi ke sala kisalu samu na kuvedisa muntu yango, mpe muntu yango ke kuma ya kuvedila.» ");
INSERT INTO mkw_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Kana muntu yina ba ke na kuvedisa kele mputu, mpe yandi lenda kuzwa ve dikabu ya mutindu yina, muntu yango ke baka kaka mwana mosi ya dimeme ya mbakala. Mwana ya dimeme yina ni Munkayulu ya kikodi. Ba ke pesa yawu na mutindu ba ke sadilaka na mantwala ya Yave, samu na kuvedisa muntu yina. Yandi ke pesa bakilo tatu ya faline ya kitoko ya kuvukana na mafuta, na Longe mosi ya mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Yandi ke baka mpe biduka zole to mabembe zole, mutindu kele lubaku ya yandi. Mosi ke vwanda samu na Munkayulu ya mulemvo. Ya nkaka ke vwanda samu na Munkayulu ya Kuyoka. ");
INSERT INTO mkw_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Na kilumbu ya nana, yandi ke nata minkayulu yina na sika ya nganga-Nzambi, na mwelo ya Yinzo ya Mbwabanu, na mantwala ya Yave, samu na kuvedisa yina ba ke vedisa yandi. ");
INSERT INTO mkw_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Nganga-Nzambi ke baka mwana ya dimeme yina ya Munkayulu ya kikodi, na Longe mosi ya mafuta. Nganga-Nzambi ke pesa yawu na mutindu ba ke sadilaka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Nganga-Nzambi ke zenga laka ya dimeme yina ya Munkayulu ya kikodi. Yandi ke baka menga ya munkayulu yina ya kikodi, mpe yandi ke tula yawu na zulu ya dikutu ya lubakala ya muntu yina ba ke na kuvedisa. Yandi ke tula yawu mpe na musapi ya yandi ya nene ya diboko ya lubakala, mpe na musapi ya nene ya dikulu ya lubakala. ");
INSERT INTO mkw_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Nganga-Nzambi ke sekula mafuta na diboko ya yandi mosi ya lumoso. ");
INSERT INTO mkw_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Na musapi ya diboko ya yandi ya lubakala, nganga-Nzambi ke mwanga mafuta yina kele na diboko ya yandi mosi ya lumoso, bambala nsambwadi na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Nganga-Nzambi ke tula mafuta yina kele na diboko ya yandi na zulu ya dikutu ya lubakala ya muntu yina ba ke na kuvedisa. Yandi ke tula mafuta yina mpe na musapi ya yandi ya nene ya diboko ya lubakala, mpe na musapi ya yandi ya nene ya dikulu ya lubakala. Yandi ke tula mafuta yango na bisika yina yandi tulaka ntete menga ya kibulu ya Munkayulu ya kikodi. ");
INSERT INTO mkw_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mafuta yina me bikana na diboko, nganga-Nzambi ke tula yawu na yintu ya muntu yina ba ke na kuvedisa. Nganga-Nzambi ke sala kisalu samu na kuvedisa muntu yina na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Nganga-Nzambi ke baka kiduka mosi na kati ya biduka nyonso zole, to dibembe mosi na kati ya mabembe nyonso zole, mutindu kele lubaku ya muntu yina. ");
INSERT INTO mkw_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Mutindu kele lubaku ya muntu yango, nganga-Nzambi ke pesa ya nkaka samu na Munkayulu ya mulemvo, ya nkaka samu na Munkayulu ya Kuyoka, kintwadi na Munkayulu ya madya ya bilanga. Nganga-Nzambi ke sala, samu na muntu yina ba ke na kuvedisa, kisalu samu na kuvedisa yandi, na mantwala ya Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Yina ni Musiku yina me tadila muntu me vwanda na kimbevo ya mpusu, yina kele na lubaku ya fyoti samu na kuzwa bima yina me fwanana samu na kuvedisa yandi. ");
INSERT INTO mkw_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yave tubaka na Moyize mpe na Aloni: ");
INSERT INTO mkw_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Mu ke pesa beno yinsi ya Kaana samu ti yawu kuvwanda ya beno. Ntangu beno ke kota na yinsi yango, kana mu me tula didoti ya mbungi na bibaka ya yinzo, ");
INSERT INTO mkw_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","muntu ya kuzwa yinzo yina ke kwenda zabisa yawu na nganga-Nzambi mutindu yayi: “Didoti mosi ke na kutalana na yinzo ya munu.” ");
INSERT INTO mkw_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Nganga-Nzambi ke tumisa ba basisa bima nyonso yina vwandaka na kati ya yinzo yango, ntete ti yandi nganga-Nzambi kukota na kati, samu na kutala mbote-mbote didoti yango. Yawu ke sala ti ata kima mosi ya yinzo yina kukuma ve ya kuvedila ve. Na manima, nganga-Nzambi ke kota na yinzo samu na kutala mbote-mbote yinzo. ");
INSERT INTO mkw_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Nganga-Nzambi ke tala mbote-mbote didoti yango. Kana yandi tala ti, na bibaka ya yinzo, didoti yango kele na mwa mabulu yina kele na ntinta ya maza ya saka-saka, to ntinta ya mwa mbwaki, ");
INSERT INTO mkw_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","nganga-Nzambi ke basika na yinzo. Mpe ntangu yandi ke kuma na mwelo ya yinzo, yandi ke kangisa yinzo yango bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Na kilumbu ya nsambwadi, nganga-Nzambi ke vutuka na kwiza kutala. Kana didoti me mwangana na bibaka, ");
INSERT INTO mkw_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","nganga-Nzambi ke tumisa ba katula matadi yina me kuzwa didoti. Ba ke losa yawu na ngaanda ya mbanza, na kisika mosi ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Yandi ke tumisa ba kwaka bibaka nyonso ya kati ya yinzo. Fundu-fundu yina ke kubwa, ba ke losa yawu na ngaanda ya mbanza, na kisika mosi ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Na manima, ba ke baka matadi ya nkaka samu na kutula yawu na kisika yina vwandaka matadi ya ntete. Ba ke baka mpe ntoto ya nkaka samu na kulenga dyaka yinzo. ");
INSERT INTO mkw_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Kana didoti me basika dyaka na yinzo na manima ya kukatula matadi, mpe ya kulenga dyaka yinzo, ");
INSERT INTO mkw_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Nganga-Nzambi ke vutuka dyaka kuna. Kana yandi tala ti didoti me mwangana na yinzo, zaba ti ya kele mbungi yina lenda manisa ve na yinzo. Yinzo yina kele ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ba ke mwangisa yinzo nyonso. Matadi, na muludi, na fundu-fundu nyonso ya yinzo, ba ke nata yawu na ngaanda ya mbanza, na kisika mosi ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","«Konso muntu yina ke kota na yinzo yango na ntangu yawu ke vwanda ya kukangama, yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Konso muntu yina ke lala na yinzo yango, yandi fwana sukula binkuti ya yandi. Konso muntu yina ke kudya na yinzo yango, yandi fwana sukula binkuti ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Kana nganga-Nzambi me kwiza na yinzo, mpe yandi me tala ti didoti me mwangana ve kubanda ntangu yina ba lengaka dyaka yinzo yango, nganga-Nzambi ke tuba ti yinzo yina kele ya kuvedila. Yimbi manisaka ya yawu.» ");
INSERT INTO mkw_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","«Samu na kuvedisa yinzo, nganga-Nzambi ke baka bandeke zole, na kibuku ya yinti ya sedele, na singa ya mbwaki, na kibuku ya kintala ya mukwisa. ");
INSERT INTO mkw_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Nganga-Nzambi ke zenga laka ya ndeke ya ntete na zulu ya kinzu yina kele na maza ya mukelo na kati ya yawu. ");
INSERT INTO mkw_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Nganga-Nzambi ke baka kibuku ya yinti ya sedele, na kibuku ya kintala ya mukwisa, na singa ya mbwaki, na ndeke yina ya zole. Yandi ke bondika yawu na kati ya menga ya ndeke yina ba me kufwa mpe na kati ya maza yina ya mukelo. Yandi ke mwanga yawu na yinzo bambala nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Yandi ke vedisa yinzo na menga ya ndeke, na maza ya mukelo, na ndeke ya moyo, na kibuku ya yinti ya sedele, na kibuku ya kintala ya mukwisa, na singa ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Yandi ke bika ndeke ya moyo kukwenda ya yawu na ngaanda ya mbanza. Yandi ke sala kisalu samu na kuvedisa yinzo. Mpe yinzo ke kuma ya kuvedila.» ");
INSERT INTO mkw_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Yina ni Musiku yina me tadila bwazi ya mutindu na mutindu, makoko, ");
INSERT INTO mkw_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","mbungi ya binkuti mpe ya bayinzo, ");
INSERT INTO mkw_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","mawumbu, lota, madoti ya mpembe. ");
INSERT INTO mkw_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Musiku yina ke longisa kana muntu to kima kele ya kuvedila to ya kuvedila ve. Yawu kele Musiku yina me tadila bwazi mpe mbungi. ");
INSERT INTO mkw_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yave tubaka na Moyize mpe na Aloni ");
INSERT INTO mkw_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","na kuzonza na bana ya Isayeli mutindu yayi: «Kana bakala me kuzwa kimbevo na nzutu ya yandi ya bubakala, kana yawu me banda kubasika maza, bakala yina me kuma ya Kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Maza yina ke na kubasika na nzutu ya yandi lenda vwanda ya maza-maza, to ya kukangama mutindu mafinya. Nyonso kele ya kuvedila ve. Mpe bima yango ke salaka ti muntu yina kuvwanda ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Na yina, konso mfulu yina ke lalila bakala yina bima yango ke na kubasika, ya ke kuma ya kuvedila ve. Konso kima yina yandi ke vwandila, ya ke kuma ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Konso muntu yina ke simba mfulu yina fwana kusukula binkuti ya yandi. Yandi fwana kuyobila maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Kana bakala yina ke na kubasika bima na nzutu ya yandi ya bubakala me vwandila kima, konso muntu yina ke vwanda na zulu ya kima yango fwana kusukula binkuti ya yandi. Yandi fwana kuyobila maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Kana bakala ke na kubasika bima na nzutu ya yandi ya bubakala, konso muntu yina ke simba nzutu ya yandi fwana kusukula binkuti. Yandi fwana kuyobila maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Kana bakala yina ke na kubasika bima na nzutu ya yandi ya bubakala me lobodila muntu ya kuvedila mante, muntu yina fwana kusukula binkuti ya yandi. Yandi fwana kuyobila maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Kana bakala ke na kubasika bima na nzutu ya yandi ya bubakala, konso kyandu ya kibulu yina yandi me vwandila ke vwanda ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Kana kima vwandaka na yisi ya bakala yina ke na kubasika bima na nzutu ya yandi ya bubakala, konso muntu yina ke simba kima yango, yandi ke vwanda ya kuvedila ve tii na nkokila. Muntu yina me nata kima ya mutindu yina fwana kusukula binkuti ya yandi. Yandi fwana kuyobila maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Kana bakala yina ke na kubasika bima na nzutu ya yandi ya bubakala me sukula maboko ya yandi ve ntete ti yandi kusimba muntu, muntu yina yandi me simba fwana kusukula binkuti ya yandi. Yandi fwana kuyobila maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Kana bakala yina ke na kubasika bima na nzutu ya yandi ya bubakala me simba kima yina ba yidikaka na ntoto, ba fwana kumwangisa kima yina. Kana kima yango ba yidikaka yawu na kibuku ya yinti, ba fwana kusukula yawu na maza. ");
INSERT INTO mkw_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«Kana kimbevo ya bakala yina vwandaka basika bima na nzutu ya yandi ya bubakala me manisa, yandi ke vingila bilumbu nsambwadi na kuvwanda ya kuvedila. Mpe yandi ke sukula binkuti ya yandi. Yandi ke yobila na maza ya mukelo. Mpe yandi ke vwanda ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Na kilumbu ya nana, yandi ke baka biduka zole to mabembe zole ya ntwenya. Yandi ke kwenda na yawu na mantwala ya Yave, na mwelo ya Yinzo ya Mbwabanu. Mpe yandi ke pesa yawu na nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Nganga-Nzambi ke pesa ndeke mosi na nyonso zole samu na Munkayulu ya mulemvo. Ndeke ya nkaka yandi ke pesa yawu samu na Munkayulu ya kuyoka. Nganga-Nzambi ke sala, na mantwala ya Yave, kisalu samu na kuvedisa bakala yina na kimbevo ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«Kana bakala me basika maluma, yandi fwana kusukula nzutu ya yandi nyonso na maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Konso kilele to mpusu ya kibulu yina me bwidila maluma, ba fwana kusukula yawu. Yawu ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","«Kana bakala me vukisa mfulu na kento, bawu fwana kuyobila maza. Bawu ke vwanda ya kuvedila ve tii na nkokila.» ");
INSERT INTO mkw_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Kana kento ke na kubasika menga samu ti yandi me tala menga, yandi ke vwanda ya kuvedila ve bilumbu nsambwadi, samu na menga. Konso muntu yina ke simba yandi ke vwanda ya Kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Kana kento ke ya kuvedila ve samu ti yandi me tala menga, konso mfulu yina yandi ke lalila, yawu ke vwanda ya kuvedila ve. Konso kima yina yandi ke vwandila, yawu ke vwanda ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Konso muntu yina ke simba mfulu ya kento yina, yandi fwana kusukula binkuti ya yandi. Yandi fwana kuyobila maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Kana kento yina me vwandila kima, konso muntu yina ke simba kima yango, yandi fwana kusukula binkuti ya yandi. Yandi fwana kuyobila maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kana kima kele na zulu ya mfulu yina kento yango me vwandila, to na zulu ya kyandu yina yandi me vwandila, muntu yina ke simba kima yango, yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kana bakala me vukisa mfulu na kento yina, mpe menga ya kento yango me kuzwa yandi, bakala yina ke vwanda ya kuvedila ve bilumbu nsambwadi. Konso mfulu yina bakala yina ke lalila, yawu ke vwanda ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Kana kento ke na kubasika menga bilumbu mingi, kasi yandi me tala ve menga, to kana menga ke na kutatamana na kubasika kulutila bilumbu ya yandi ya menga, kento yina ke vwanda ya kuvedila ve bilumbu nyonso yina menga yango ke na kubasika yandi. Yandi ke vwanda ya kuvedila ve mutindu ntangu yandi ke vwandaka ya kuvedila ve ntangu yandi ke talaka menga. ");
INSERT INTO mkw_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ntangu menga yango ke na kubasika yandi, konso mfulu yina yandi ke lalila ke vwanda mutindu yawu ke vwandaka ntangu yandi ke vwandaka ya kuvedila ve samu ti yandi me tala menga. Konso kima yina yandi ke vwandila, yawu ke vwanda ya kuvedila ve mutindu ntangu yandi ke talaka menga. ");
INSERT INTO mkw_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Konso muntu yina ke simba mfulu yina to kima yina, yandi ke vwanda ya kuvedila ve. Yandi fwana kusukula binkuti ya yandi. Yandi fwana kuyobila maza. Mpe yandi ke vwanda ya kuvedila ve tii na nkokila. ");
INSERT INTO mkw_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Kana menga yina vwandaka basika na kento me manisa, kento yina ke vingila bilumbu nsambwadi. Na manima, yandi ke vwanda ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Na kilumbu ya nana, yandi ke baka biduka zole to mabembe zole ya ntwenya. Yandi ke kwenda na yawu na sika ya nganga-Nzambi, na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Nganga-Nzambi ke pesa ndeke mosi na kati ya nyonso zole samu na Munkayulu ya mulemvo. Ndeke ya nkaka yandi ke pesa yawu samu na Munkayulu ya kuyoka. Nganga-Nzambi ke sala, na mantwala ya Yave, kisalu samu na kuvedisa kento yina na kimbevo ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«Beno ke tuba na bana ya Isayeli na kuvwandaka ya bawu na lweka, ntangu bawu ke vwandaka ya kuvedila ve. Na yina bawu ke kufwa ve samu ti bawu kele ya kuvedila ve mpe bawu me sumuna yinzo ya munu yina mu ke vwandaka na kati-kati ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Yina ni Musiku yina me tadila bakala yina ke na kubasika bima na nzutu ya yandi ya bubakala, to bakala yina me kuma ya kuvedila ve samu ti maluma me basika yandi. ");
INSERT INTO mkw_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Yawu me tadila mpe kento yina kele ya kuvedila ve samu ti yandi me tala menga, muntu yina ke na kubasika maza na nzutu ya yandi ya bukento to ya bubakala, mpe bakala yina me vukisa mfulu na kento yina kele ya kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Na manima ya lufwa ya bana zole ya Aloni, bayina kufwaka ntangu bawu belamaka na mantwala ya Yave, Yave zonzaka na Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yave tubaka na Moyize mutindu yayi: «Zabisa na mpangi ya nge Aloni, yandi kukotaka ve makota-kota na kivinga ya kulutila longo, na manima ya lele yina ke bumbaka yawu. Kuna na kivinga ya kulutila longo, kele na kitapu ya Sanduku ya Ngwisani, na zulu ya Sanduku ya Ngwisani. Kana yandi kota kuna makota-kota, yandi lenda kufwa ntangu mu ke talana na kati ya dituti, na zulu ya kitapu ya Sanduku ya Ngwisani.» ");
INSERT INTO mkw_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«Na kukota na kivinga ya kulutila longo, Aloni ke baka bima yayi: ngombe ya ntwenya ya mbakala samu na Munkayulu ya mulemvo, mpe dimeme ya mbakala samu na Munkayulu ya kuyoka. ");
INSERT INTO mkw_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Yandi ke lwata kinkuti ya longo ya lino mpe mibati ya lino. Yandi ke lwata mukaba ya lino mpe yimpu ya lino ya bunganga-Nzambi. Yina ni binkuti ya longo yina yandi ke lwata na manima ya kusukula nzutu ya yandi na maza. ");
INSERT INTO mkw_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Mukangu ya Isayeli ke pesa yandi bankombo zole ya mbakala samu na Munkayulu ya mulemvo. Bawu ke pesa yandi mpe dimeme mosi ya mbakala samu na Munkayulu ya Kuyoka.» ");
INSERT INTO mkw_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","«Aloni ke pesa ngombe ya mbakala samu na Munkayulu ya mulemvo ya masumu ya yandi mosi. Yandi ke sala kisalu samu na kukatula masumu ya yandi mosi mpe ya bantu ya yinzo ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Yandi ke baka bankombo nyonso zole, mpe yandi ke tula yawu na mantwala ya Yave, na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aloni ke bula dzeke samu na kuzaba, na kati ya bankombo nyonso zole, wapi yina kele ya Yave, mpe wapi yina kele ya Azazele. ");
INSERT INTO mkw_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Nkombo yina dzeke ke soola samu na Yave, Aloni ke nata yawu, mpe yandi ke pesa yawu samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Nkombo yina dzeke ke soola samu na Azazele, ba ke tula yawu ya moyo na mantwala ya Yave. Ba ke sala kisalu na zulu ya nkombo yina samu na kukatula masumu. Mpe ba ke fidisa yawu na sika ya Azazele, na yinsi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Aloni ke pesa ngombe ya mbakala samu na Munkayulu ya mulemvo ya masumu ya yandi mosi. Yandi ke sala kisalu samu na kukatula masumu ya yandi mosi, mpe ya bantu ya yinzo ya yandi. Yandi ke zenga laka ya ngombe ya Munkayulu ya mulemvo ya masumu ya yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Yandi ke baka kiyokolo ya maaka ya nsunga ya mbote. Yandi ke fulusa yawu na makala ya tiya yina yandi ke baka na kiyokolo ya minkayulu, na mantwala ya Yave. Yandi ke baka maboko zole ya kufuluka na fundu-fundu ya maaka ya nsunga ya mbote. Yandi ke nata yawu na kivinga ya kulutila longo. ");
INSERT INTO mkw_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Yandi ke tula fundu-fundu ya maaka ya nsunga ya mbote na tiya, na mantwala ya Yave, samu ti mulinga ya yawu kufuka kitapu ya Sanduku ya ngwisani. Na kati ya sanduku yina kele na Matadi ya ngwisani. Na kusala mutindu yina, Aloni ke kufwa ve. ");
INSERT INTO mkw_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Yandi ke baka menga ya ngombe, na musapi ya yandi, yandi ke mwanga yawu na zulu ya kitapu ya Sanduku ya Ngwisani, na lweka ya esete. Yandi ke mwanga mpe menga bambala nsambwadi na mantwala ya kitapu ya Sanduku ya Ngwisani. ");
INSERT INTO mkw_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Yandi ke kufwa nkombo ya mbakala yina me pesama mutindu Munkayulu ya mulemvo ya masumu ya bantu. Yandi ke nata menga ya nkombo yina na kivinga ya kulutila longo. Yandi ke sala na menga yina mutindu yandi salaka na menga ya ngombe. Yandi ke mwanga yawu na zulu ya kitapu ya Sanduku ya ngwisani, mpe na mantwala ya Sanduku ya ngwisani. ");
INSERT INTO mkw_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Yandi ke sala kisalu samu na kuvedisa kivinga ya longo samu na kondwa Kuvedila ya bana ya Isayeli, na yimbi ya bawu, na masumu nyonso ya bana ya Isayeli. Yandi ke sala mutindu mosi samu na Yinzo ya Mbwabanu, yina ke vwandaka na sika ya bawu, na kati-kati ya kondwa kuvedila ya bawu. ");
INSERT INTO mkw_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ntangu Aloni ke kota na kivinga ya kulutila longo samu na kusala kisalu samu na kukatula masumu, ata muntu mosi ve ke vwanda na Yinzo ya Mbwabanu, tii ntangu yina Aloni ke basika. Aloni ke sala kisalu samu na kukatula masumu ya yandi mosi, na ya bantu ya yinzo ya yandi, na ya mukangu nyonso ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Aloni ke basika na kukwiza na kivinga ya longo, mpe yandi ke kwenda na Kiyokolo ya minkayulu, yina kele na mantwala ya Yave. Yandi ke sala kisalu na Kiyokolo ya minkayulu, samu na kuvedisa yawu. Yandi ke baka ndambu ya menga ya ngombe mpe ya nkombo, yandi ke tula yawu na balweka nyonso ya mampoka ya Kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Na musapi ya yandi, yandi ke mwanga menga bambala nsambwadi na Kiyokolo ya minkayulu. Yandi ke vedisa yawu na kondwa kuvedila ya bana ya Isayeli. Mpe yandi ke byeka yawu. ");
INSERT INTO mkw_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Ntangu Aloni ke manisa na kusala kisalu samu na kuvedisa kivinga ya longo, mpe Yinzo ya Mbwabanu, mpe Kiyokolo ya minkayulu, yandi ke nata nkombo ya mbakala ya moyo. ");
INSERT INTO mkw_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aloni ke tentika maboko ya yandi zole na zulu ya yintu ya nkombo ya moyo. Mpe yandi ke fungula masumu nyonso ya bana ya Isayeli, na bafoti nyonso ya bawu, na yimbi nyonso ya bawu. Yandi ke tula yawu na zulu ya yintu ya nkombo. Mpe yandi ke pesa nkombo yango na muntu yina ba kubikaka samu na kunata yawu na yinsi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Nkombo yina ke baka kizitu ya masumu nyonso ya bawu mpe yandi ke nata yawu na kisika yina bantu lenda kuma ve.» «Ba ke fidisa nkombo yango na yinsi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Na manima, Aloni ke kota na Yinzo ya Mbwabanu. Yandi ke katula binkuti ya lino yina yandi lwataka na kukota na kivinga ya kulutila longo. Mpe yandi ke bika yawu kuna. ");
INSERT INTO mkw_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Yandi ke sukula nzutu ya yandi na maza na kisika mosi ya longo. Mpe yandi ke lwata binkuti ya yandi ya nkaka. Na manima, yandi ke basika samu na kwenda pesa Munkayulu ya Kuyoka ya yandi mosi, mpe Munkayulu ya Kuyoka ya bantu. Yandi ke sala kisalu samu na kukatula masumu ya yandi mosi mpe ya bantu. ");
INSERT INTO mkw_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Yandi ke yoka na Kiyokolo ya minkayulu mafuta ya bibulu yina me pesama samu na mulemvo ya masumu.» ");
INSERT INTO mkw_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Muntu yina nataka nkombo ya Azazele fwana kusukula binkuti ya yandi, mpe kusukula nzutu ya yandi na maza. Na manima, yandi ke vutuka na kivwandu. ");
INSERT INTO mkw_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ngombe na nkombo yina pesamaka samu na kukatula masumu, ba ke nata yawu ntama na kivwandu. Ni bibulu yina ba nataka menga ya yawu na kivinga ya kulutila longo samu na kusala kisalu samu na kukatula masumu. Mpusu ya bibulu yina, na mbisi ya yawu, na matufi ya yawu, ba ke losa yawu na tiya. ");
INSERT INTO mkw_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Muntu yina ke yoka yawu fwana kusukula binkuti ya yandi. Mpe yandi fwana kusukula nzutu ya yandi na maza. Na manima, yandi ke kota na kivwandu.» ");
INSERT INTO mkw_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Yina kele bansalulu yina beno ke banda na kusadilaka bantangu nyonso. Na ngonda ya nsambwadi, na kilumbu ya kumi, beno ke mina-nsoki, beno ke sala ata kisalu, ya vwanda muntu ya yinsi, to nzenza yina ke vwandaka na sika ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Samu ti na kilumbu yina, ba ke sala kisalu samu na kukatula masumu nyonso ya beno, samu na kuvedisa beno. Beno ke vwanda ya kuvedila na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ya ke vwanda kilumbu ya Saba samu na beno, kilumbu ya kupema. Beno ke mina nsoki. Ya kele bansalulu ya bantangu nyonso.» ");
INSERT INTO mkw_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","«Nganga-Nzambi yina ba byekaka, yina yinganaka tata ya yandi na kifulu ya nganga-Nzambi ya ntete, ni yandi ke sala kisalu samu na kukatula masumu. Yandi ke lwata binkuti ya lino ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Yandi ke sala kisalu samu na kuvedisa kivinga ya longo, mpe Yinzo ya Mbwabanu, mpe Kiyokolo ya minkayulu. Yandi ke sala kisalu samu na kukatula masumu ya banganga-Nzambi, na ya bantu nyonso ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","«Yina kele bansalulu ya konso ntangu samu na beno. Beno fwana salaka mutindu yina mbala mosi na mvula, samu na kukatula masumu nyonso ya bana ya Isayeli.» Aloni salaka mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yave zabisaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","na kutuba na Aloni, na bana ya yandi, mpe na bana nyonso ya Isayeli mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","«Kana muntu ya Isayeli kufwa ngombe, to dimeme, to nkombo, ya vwanda na kivwandu, to ntama na kivwandu, ");
INSERT INTO mkw_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","kana yandi kunata yawu ve na mwelo ya Yinzo ya Mbwabanu samu na kupesa yawu na Yave, na mantwala ya Yinzo ya Yave, menga yina yandi me mwangisa kele na zulu ya yintu ya yandi. Yandi me mwangisa menga. Ba fwana kukatula muntu yina na lutangu ya bantu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Na mutindu yina, bana ya Isayeli ke bika na kufwaka bibulu ya minkayulu ya bawu kisika ni kisika. Kasi bawu ke banda na kunataka yawu na Yave, na mwelo ya Yinzo ya Mbwabanu, na mantwala ya nganga-Nzambi. Bawu ke banda na kupesaka yawu na Yave samu na Minkayulu ya kiwisa. ");
INSERT INTO mkw_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Nganga-Nzambi ke mwanga menga na Kiyokolo ya minkayulu ya Yave, na mwelo ya Yinzo ya Mbwabanu. Na manima, yandi ke yoka mafuta. Nsunga ya yawu ke yangidika Yave. ");
INSERT INTO mkw_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Bana ya Isayeli ke pesa dyaka ve minkayulu ya bawu na banzambi ya luvunu yina kele na bifwani ya bankombo. Bawu ke na kubikaka munu samu na kusadila banzambi yina. Bansalulu yayi ke vwanda ya bantangu nyonso samu na bawu, na bambandu nyonso.» ");
INSERT INTO mkw_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«Nge ke tuba na bawu: kana muntu ya dikanda ya Isayeli, to nzenza yina ke zingaka na sika ya bawu me pesa Munkayulu ya kuyoka, to munkayulu ya nkaka, ");
INSERT INTO mkw_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","kana yandi me nata yawu ve na mwelo ya Yinzo ya Mbwabanu samu na kupesa yawu na Yave, muntu yina ba fwana kukatula yandi na lutangu ya bantu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«Kana muntu ya dikanda ya Isayeli, to nzenza yina ke zingaka na sika ya bawu me kudya menga, ya vwanda menga ni menga, mu ke balukila muntu yina me kudya menga. Mpe mu ke katula yandi na lutangu ya bantu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Samu ti luzingu ya bima nyonso ya moyo kele na kati ya menga. Mu me pesa beno luve ya kusadila yawu na Kiyokolo ya minkayulu, samu na kukatula masumu ya beno. Menga ke salaka ti beno kuzwa mulemvo ya masumu, samu ti luzingu kele na kati ya menga. ");
INSERT INTO mkw_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ni samu na yawu mu me tuba na bana ya Isayeli: “Ata muntu mosi na kati ya beno kudya menga ve. Nzenza yina ke na kuzinga na sika ya beno mpe fwana kudya ve menga.”» ");
INSERT INTO mkw_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«Kana muntu mosi na kati ya bana ya Isayeli, to nzenza yina ke zingaka na sika ya bawu me kwenda na mbingu, mpe yandi me kufwa kibulu to ndeke yina ba ke kudyaka, muntu yina fwana kumwangisa menga ya yawu na ntoto. Mpe yandi fwana kufuka menga yango na ntoto. ");
INSERT INTO mkw_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Samu ti luzingu ya bima nyonso ya moyo kele na kati ya menga. Ni yawu yina mu me tuba na bana ya Isayeli: “Beno kudya ve menga ya ata kibulu. Samu ti luzingu ya konso kima ya moyo, ni menga ya yawu. Konso muntu yina ke kudya menga, ba ke katula yandi na lutangu ya bantu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«Na kati ya bana ya Isayeli to banzenza yina ke zingaka na sika ya bawu, konso muntu yina ke kudya kibulu yina me kufwa yawu mosi, to kibulu yina mpangi kibulu me kufwa, muntu yina fwana kusukula binkuti ya yandi. Yandi ke yobila maza. Mpe yandi ke vwanda ya Kuvedila ve tii na nkokila. Na manima, yandi ke vwanda ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Kana yandi sukula ve binkuti ya yandi, kana yandi sukula ve nzutu ya yandi, disumu ya yandi ke vwanda na zulu ya yintu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","na kuzabisa na bana ya Isayeli mutindu yayi: «Mu kele Yave, Nzambi ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Beno sala ve mutindu ba ke salaka na yinsi ya Ngipiti, kisika yina beno vwandaka zinga. Beno kusala mpe ve mutindu ba ke salaka na Kaana, kisika yina mu ke na kunata beno. Beno landa ve bansalulu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Beno landa misiku ya munu. Beno sadila bansalulu ya misiku ya munu. Beno landa yawu. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","«Beno sadila misiku ya munu mpe bansalulu ya misiku ya munu. Muntu yina ke sadila yawu ke zinga na nzila ya yawu. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«Bakala kuvukisa ve mfulu na kento yina bawu kele dikanda mosi. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«Kuvukisa ve mfulu na mama ya nge. Ya kele kusafula tata ya nge. Yandi kele mama ya nge: kuvukisa ve mfulu na yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«Kuvukisa ve mfulu na kento ya nkaka ya tata ya nge. Ya kele kusafula tata ya nge.» ");
INSERT INTO mkw_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«Kuvukisa ve mfulu na kibusi ya nge: mwana ya tata ya nge to mwana ya mama ya nge, ya vwanda yina me butuka na yinzo ya makwela to yina me butuka na ngaanda.» ");
INSERT INTO mkw_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«Kuvukisa ve mfulu na mutekolo ya nge, ya vwanda yina me buta mwana ya nge ya bakala to mwana ya nge ya kento. Ya kele kusafula nzutu ya nge mosi.» ");
INSERT INTO mkw_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«Kuvukisa ve mfulu na mwana yina tata ya nge me buta na kento ya nkaka. Yandi kele mwana ya tata ya nge, yandi kele kibusi ya nge.» ");
INSERT INTO mkw_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«Kuvukisa ve mfulu na kibusi ya tata ya nge. Yandi kele muntu ya dikanda ya tata ya nge.» ");
INSERT INTO mkw_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","«Kuvukisa ve mfulu na mpangi ya mama ya nge. Yandi kele muntu ya dikanda ya mama ya nge.» ");
INSERT INTO mkw_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«Kusafula ve mpangi ya tata ya nge na kuvukisa mfulu na kento ya yandi. Kento yina kele mama ya nge.» ");
INSERT INTO mkw_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«Kuvukisa ve mfulu na kento ya mwana ya nge. Yandi kele bokilo ya nge. Kuvukisa ve mfulu na yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","«Kuvukisa ve mfulu na kento ya mpangi ya nge. Ya kele kusafula mpangi ya nge.» ");
INSERT INTO mkw_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«Kuvukisa ve mfulu na kento mpe na mwana ya yandi ya kento. Kuvukisa ve mfulu na mutekolo ya yandi, mwana ya mwana ya yandi ya bakala to ya kento. Ya kele dyambu ya nsoni mingi. Bawu kele dikanda mosi.» ");
INSERT INTO mkw_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«Kukwela ve mpangi ya kento ya nge kana kento ya nge ke ntete moyo, samu ti nge ke kotisa kimbanda ntangu nge ke vukisa mfulu na mpangi ya kento ya nge.» ");
INSERT INTO mkw_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«Kuvukisa ve mfulu na kento, kana yandi kele na menga. Yandi kele ya kuvedila ve.» ");
INSERT INTO mkw_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«Kuvukisa ve mfulu na kento ya mpangi ya nge ya yinsi mosi. Samu ti yawu ke sala ti nge vwanda ya kuvedila ve.» ");
INSERT INTO mkw_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«Kupesa ve mwana ya nge mutindu munkayulu na nzambi Moloke. Ya kele kusafula nkumbu ya Nzambi ya nge. Munu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«Kuvukisa ve mfulu na mpangi bakala, mutindu ba ke vukisaka mfulu na kento. Ya kele nganzi.» ");
INSERT INTO mkw_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«Kuvukisa ve mfulu na kibulu. Samu ti yawu ke sala ti nge vwanda ya Kuvedila ve. Kento mpe lenda kuvukisa ve mfulu na kibulu. Ya kele vwanzi ya nsisi.» ");
INSERT INTO mkw_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«Beno kukuma ve ya kuvedila ve na kusadila ata dyambu mosi na mambu nyonso yina. Samu ti bantu ya bayinsi yina mu ke na kubingisa na mantwala ya beno, bawu kumaka ya Kuvedila ve samu na mambu nyonso yina. ");
INSERT INTO mkw_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Yinsi mpe me kuma ya kuvedila ve samu na yawu. Mu me futisa yinsi yango yimbi ya yandi, mpe yawu me luka bantu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","«Beno, beno fwana kusadila misiku mpe bansalulu ya misiku ya munu. Beno kusala ata mosi na mambu yina ya nganzi, ya vwanda beno, ya vwanda nzenza yina ke zingaka na sika ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Yina ni mambu nyonso ya nganzi yina vwandaka sadila bantu ya yinsi, bayina vwandaka zinga kuna tekila beno. Ni yawu yina yinsi me kuma ya Kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Beno kusala dyaka ve ti yinsi yango kuvwanda dyaka ya Kuvedila ve, samu ti yawu kuluka beno ve, mutindu yawu me luka bantu yina vwandaka zinga kuna tekila beno. ");
INSERT INTO mkw_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Bantu nyonso yina ke sala mosi na mambu yina ya nganzi, ba ke katula bawu na lutangu ya bantu ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","«Beno landa bantumunu ya munu. Beno kusadila ve bansalulu ya nganzi yina bantu vwandaka sadila tekila beno kwiza, samu ti beno kuvwanda ve ya Kuvedila ve. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","na kuzabisa na mukangu nyonso ya bana ya Isayeli mutindu yayi: «Beno kuvwanda ya longo. Samu ti munu, Yave Nzambi ya beno, mu kele ya longo!» ");
INSERT INTO mkw_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","«Konso muntu na kati ya beno fwana kuzitisa tata ya yandi na mama ya yandi. Yandi fwana mpe kuzitisa basaba ya munu. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«Beno sambila ve banzambi ya luvunu. Beno yidika ve banzambi ya biteki na bisengo ya kusulumuka. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«Ntangu beno ke pesa na Yave Minkayulu ya kiwisa, beno landa misiku, samu ti Yave kundima yawu. ");
INSERT INTO mkw_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Mbisi ya kibulu yina me pesama mutindu munkayulu, beno ke kudya yawu kaka na kilumbu yina ba me kufwa yawu to na kilumbu yina ke landa. Mbisi yina ke bikana na manima ya bilumbu zole, ba ke losa yawu na tiya. ");
INSERT INTO mkw_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kana ba me kudya yawu na manima ya bilumbu zole, Yave ke ndima yawu ve. Mbisi yina ke dyaka ve ya mbote. ");
INSERT INTO mkw_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Muntu yina ke kudya yawu, disumu ya yandi ke vwanda na zulu ya yintu ya yandi, samu ti yandi me sumuna kima ya longo ya Yave. Ba ke katula yandi na lutangu ya bantu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«Ntangu ya kuyonzika bambuma ya bilanga na yinsi ya beno, beno kuyonzika ve bambuma yina kele na ndilu ya bilanga. Beno vutuka ve na kwenda lokota bambuma yina bikanaka na bisika yina beno vwandaka me yonzika yimeni. ");
INSERT INTO mkw_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Beno vutuka mpe ve na bilanga ya bayinti ya vinu samu na kwenda buka bambuma yina bikanaka, to na kwenda lokota bambuma yina kubwaka na ntoto. Beno bikila yawu bamputu na banzenza. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«Beno kulaba ve. Muntu kuvuna to kusadila ve mayuya na mpangi ya yandi yina ba kele yinsi mosi. ");
INSERT INTO mkw_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Beno kudya ve bandefi ya luvunu na nkumbu ya munu. Yina kele kuvweza nkumbu ya Nzambi ya nge. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«Kusalisa ve mpangi ya nge kisalu ya mpamba. Kulaba ve yandi. Difuta ya muntu yina me sadila nge kisalu fwana kulala ve na sika ya nge. ");
INSERT INTO mkw_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Kuzonza ve mambu ya nsiingulu na muntu yina kele na makutu ya kufwa. Kutula ve na mantwala ya mpofo kima yina lenda bwisa yandi. Zitisa Nzambi ya nge. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«Na kati ya balufundusu ya beno, beno sala ve mambu ya kondwa kudedama. Kunungisa ve mputu mpe kupesa ve mpemba na muntu ya mfunu. Kasi fundisa mpangi ya nge yina beno kele yinsi mosi na ludedomo nyonso. ");
INSERT INTO mkw_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Kukwenda vunina ve bampangi ya nge mambu. Kuzonza ve mambu ya luvunu na mpangi samu ti ba kufwa yandi. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«Kuyina ve mpangi ya nge na yisi ya ntima. Kasi kukima ve na kusemba yandi, samu ti nge kuzwa ve disumu samu na yandi. ");
INSERT INTO mkw_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Kuvutula ve yimbi na muntu yina me sala nge yimbi. Kukangila ve mpangi ya nge nkele. Zola mpangi ya nge mutindu nge mosi. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«Beno landa bansalulu ya munu. Kukwelisa ve bibulu ya makanda zole ya kuswaswana. Kukuna ve bambuma ya makanda zole ya kuswaswana na kati ya bilanga mosi. Kulwata ve kinkuti yina ba yidikaka na basinga ya mitindu zole ya kuswaswana.» ");
INSERT INTO mkw_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«Kana bakala me vukisa mfulu na kento yina kele mundongo, kana kento yango wisanaka ntete na muntu ya nkaka samu na kukwelana na yandi, kasi nabunu ba futila yandi mbongo samu na kukuula yandi na bundongo, to nabunu ba pesa yandi kimpwanza ya kukwenda ya yandi, ba fwana kupesa bakala yina kitumbu. Kasi ba ke kufwa bawu ve, samu ti kento yina vwandaka ntete mundongo. ");
INSERT INTO mkw_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Bakala yango ke nata dimeme ya mbakala na Yave. Yandi ke nata yawu na mwelo ya Yinzo ya Mbwabanu, samu na Munkayulu ya kikodi na yimbi yina yandi me sala. ");
INSERT INTO mkw_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Nganga-Nzambi ke sala kisalu samu na kukatula masumu ya bakala yina. Yandi ke sala kisalu yango na dimeme yango ya mbakala na mantwala ya Yave. Mpe bakala yango ke kuzwa mulemvo ya masumu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«Ntangu beno ke kota na yinsi ya Kaana, mpe beno ke kuna bayinti ya bambuma ya kudya ya mutindu na mutindu, beno ke tala yawu mutindu bambuma yina ba yiminaka. Yawu ke vwanda bambuma yina ba yiminaka samu na beno, bamvula tatu. Beno ke kudya yawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Na mvula ya yiya, beno ke baka bambuma nyonso yina, beno ke tula yawu na lweka samu na Yave. Beno ke sala yawu na kati ya mukembo ya nene yina ba ke salaka samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Na mvula ya tanu, beno lenda banda na kudya bambuma ya bayinti yango. Na mutindu yina, bayinti ya beno ke banda na kubuta mingi. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«Beno kudya ve kibulu na kisika yina beno me mwangisa menga ya yawu. Beno kusadila ve mikisi to bunganga samu na kuzaba mambu yina ke kwiza. ");
INSERT INTO mkw_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Beno kuteba ve bandilu ya bansuki ya beno. Kuteba ve balweka ya mandefo ya nge. ");
INSERT INTO mkw_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Beno kulwalisa ve banzutu samu ti muntu me kufwa. Beno kusala ve bansamba na banzutu ya beno. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«Kusumuna ve mwana ya nge ya kento na kutumisa yandi na kusala kindumba, samu ti yinsi kubeba ve na kinsuza, mpe yawu kufuluka ve na mambu ya nsoni. ");
INSERT INTO mkw_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Beno zitisa basaba ya munu mpe beno zitisa Yinzo ya munu ya longo. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«Beno kwendaka tala ve bantu yina ke sololaka na bantu ya kufwa, to bayina ke sadilaka bampeve samu na kuzaba mambu. Beno sosa bawu ve, samu ti beno kuvwanda ve ya kuvedila ve samu na bawu. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«Telama na buzitu na ntadisi ya kiboba. Vumina muntu ya kununa. Zitisa Nzambi ya nge. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«Kana nzenza me kwiza zinga na yinsi ya beno, beno kutalisa yandi mpasi ve. ");
INSERT INTO mkw_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Nzenza yina me kwiza zinga na yinsi ya beno, bakila yandi mutindu muntu ya yinsi. Zola yandi mutindu nge mosi. Samu ti beno mpe beno vwandaka banzenza na yinsi ya Ngipiti. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«Beno kusala mayuya ve, ya vwanda na bamfundusu, ya vwanda na kuteza yinda, ya vwanda na kuteza bakilo, ya vwanda na kuzonga bima. ");
INSERT INTO mkw_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Beno vwanda na bipezolo ya kulunga, Efa ya kulunga, bayine ya kulunga. Mu kele Yave, Nzambi ya beno. Ni munu basisaka beno na yinsi ya Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","«Beno keba misiku nyonso ya munu na bansalulu nyonso ya munu. Mpe beno sadila yawu. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","na kuzabisa na bana ya Isayeli mutindu yayi: «Kana muntu na kati ya bana ya Isayeli, to na kati ya banzenza yina ke zingaka na sika ya beno, yandi me pesa mosi na bana ya yandi mutindu munkayulu na nzambi Moloke, kaka kufwa ba fwana kufwa muntu yina. Bantu ya yinsi ke kufwa yandi na matadi. ");
INSERT INTO mkw_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Munu mpe, mu ke balukila muntu yina. Mpe mu ke katula yandi na lutangu ya bantu ya yandi, samu ti yandi me pesa mosi na bana ya yandi mutindu munkayulu na nzambi Moloke. Yandi me sumuna Yinzo ya munu ya longo. Mpe yandi me safula nkumbu ya munu ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kana bantu ya yinsi me kanga meso ya bawu na mantwala ya muntu yina me pesa mosi na bana ya yandi na nzambi Moloke, kana bawu kufwa muntu yina ve, ");
INSERT INTO mkw_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","munu mosi mu ke balukila muntu yina mpe dikanda ya yandi. Mu ke katula yandi na lutangu ya bantu ya yandi, yandi na bantu nyonso yina vukanaka na yandi na kukipesa na nzambi Moloke.» ");
INSERT INTO mkw_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«Kana muntu kwenda tala bayina ke sololaka na bantu ya kufwa to bayina ke talaka mambu, ya kele kusambila banzambi ya nkaka. Mu ke balukila muntu yina, mpe mu ke katula yandi na lutangu ya bantu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","«Beno kuma bantu ya longo, beno vwanda bantu ya longo, samu ti mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","«Beno landa bansalulu ya munu, mpe beno sadila yawu. Ni munu Yave ke na kubyeka beno.» ");
INSERT INTO mkw_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«Kana muntu me siinga tata to mama ya yandi, ba fwana kufwa yandi. Yandi me siinga tata ya yandi to mama ya yandi, ni yandi mosi me sosa lufwa ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«Kana bakala me sala kinsuza na kento ya kukwela, kana yandi me sala kinsuza na kento ya mpangi ya yandi, ba fwana kufwa kento na bakala yina me sala kinsuza.» ");
INSERT INTO mkw_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","«Kana bakala me vukisa mfulu na kento ya tata ya yandi, yandi me safula tata ya yandi. Ba fwana kufwa bawu nyonso zole. Ni bawu mosi me sosa lufwa ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","«Kana bakala me vukisa mfulu na kento ya mwana ya yandi, ba fwana kufwa bawu nyonso zole. Bawu me sala vwanzi mosi ya nsisi. Ni bawu mosi me sosa lufwa ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","«Kana bakala me vukisa mfulu na mpangi bakala mutindu ba ke salaka na kento, bawu nyonso zole me sala dyambu ya nganzi. Ba fwana kufwa bawu. Ni bawu mosi me sosa lufwa ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","«Kana bakala me kwela kento na mama ya kento yina, ya kele busafu. Ba ke losa bawu na tiya, yandi na bakento nyonso zole, samu ti mambu yina ya nsoni mingi kutalana dyaka ve na kati ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«Kana bakala me vukisa mfulu na kibulu, ba fwana kufwa bakala yina. Ba fwana kufwa mpe kibulu yango.» ");
INSERT INTO mkw_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","«Kana kento me vukisa mfulu na kibulu, ba fwana kufwa kento yina mpe kibulu yango. Bawu fwana kufwa. Ni bawu mosi me sosa lufwa ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«Kana bakala me baka kibusi ya yandi yina kele mwana ya tata ya yandi to mwana ya mama ya yandi, kana yandi kuvukisa mfulu na yandi, ya kele dyambu ya nsoni ya kulutila. Ba fwana kukatula bawu nyonso zole na lutangu ya bantu ya bawu. Bakala yango me vukisa mfulu na kibusi ya yandi, disumu ya yandi ke vwanda na zulu ya yintu ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","«Kana bakala me vukisa mfulu na kento yina kele na menga, ba ke katula bawu zole na lutangu ya bantu ya bawu, samu ti bawu nyonso zole me vukisa mfulu ntangu kento ke na kutala menga.» ");
INSERT INTO mkw_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«Kuvukisa ve mfulu na kibusi ya mama ya nge, to na kibusi ya tata ya nge. Ya kele kuvukisa mfulu na kibuti ya nge. Bayina ke sala mutindu yina, disumu ya bawu ke vwanda na zulu ya bayintu ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","«Kana bakala me vukisa mfulu na kento ya mpangi ya tata ya yandi, yandi me safula mpangi ya tata ya yandi. Disumu yina ke vwanda na zulu ya yintu ya yandi na kento yango. Bawu ke buta ve tii lufwa ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","«Kana bakala me kwela kento ya mpangi ya yandi, ya kele dyambu ya kuvedila ve. Bakala yina me safula mpangi ya yandi. Bawu zole ba ke buta bana ve.» ");
INSERT INTO mkw_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«Beno tumama na misiku ya munu nyonso na bansalulu nyonso ya munu, mpe beno sadila yawu. Na yina yinsi ke luka beno ve, yinsi yina mu ke na kunata beno, samu ti beno kuzinga kuna. ");
INSERT INTO mkw_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Beno kusadila ve bansalulu ya makanda ya bantu yina mu ke bingisa na mantwala ya beno. Bawu ba sadilaka mambu nyonso yina. Ni yawu yina mu me yina bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mu me tuba na beno ti: «“Ni beno ke baka yinsi ya bawu samu ti yawu kuvwanda ya beno. Ni munu mosi ke pesa beno yawu. Ya kele yinsi ya kufuluka na miliki mpe na mafuta ya nyosi.”» Mu kele Yave, Nzambi ya beno. Ni munu me kabula beno na makanda ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Beno fwana kusala luswaswanu na kati ya bibulu ya kuvedila na yina kele ya Kuvedila ve, na kati ya bandeke ya kuvedila na yina kele ya kuvedila ve. Beno kuvwanda ve nganzi na kusimbaka bima yina kele ya kuvedila ve: bibulu, bandeke, to bima nyonso ya fyoti-fyoti yina ke tambulaka na ntoto. Bima nyonso yina mu tulaka yawu na lweka mpe mu tubaka ti yawu kele ya kuvedila ve samu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","«Beno vwanda ya longo samu na munu, samu ti, munu Yave, mu kele ya longo. Mu me kabula beno na makanda ya nkaka samu ti beno kuvwanda bantu ya munu.» ");
INSERT INTO mkw_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«Kana ya vwanda na muntu mosi ya kento to ya bakala yina ke sololaka na bantu ya kufwa, to yina ke talaka mambu, ba fwana kufwa yandi. Ba ke kufwa yandi na matadi. Ni yandi mosi me sosa lufwa ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yave tubaka na Moyize na kuzabisa na banganga-Nzambi, bana ya Aloni, mutindu yayi: «Nganga-Nzambi fwana kusimba ve mvumbi ya muntu ya dikanda ya yandi. Kana ve, yandi ke kuma ya Kuvedila ve. ");
INSERT INTO mkw_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Yandi lenda simba kaka mvumbi ya mama ya yandi, ya tata ya yandi, ya mwana ya yandi ya bakala to ya kento, mpe ya mpangi ya yandi ya bakala. ");
INSERT INTO mkw_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Na yina me tadila lufwa ya kibusi ya nganga-Nzambi yina me zaba ntete ve babakala mpe kele ntete na yisi ya lutumu ya dikanda ya yandi, samu ti ba me kwela yandi ntete ve, nganga-Nzambi ke na luve ya kuma ya kuvedila ve samu na mvumbi ya kibusi yango. ");
INSERT INTO mkw_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Nganga-Nzambi kele mfumu na kati ya dikanda ya yandi. Ni yawu yina yandi fwana kuvwanda ve ya kuvedila ve samu na kusumuna ve bulongo ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«Banganga-Nzambi lenda zenga ve bansuki ya bawu. Bawu lenda katula mpe ve mandefo ya balweka, to kusala bansamba na banzutu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Bawu fwana kuvwanda ya longo samu na Nzambi ya bawu. Mpe bawu fwana kusafula ve nkumbu ya Nzambi ya bawu. Samu ti ni bawu kele na muswa ya kunataka madya ya kuyoka na tiya samu na Yave. Yawu kele madya ya Nzambi ya bawu. Bawu fwana kuvwanda bantu ya longo.» ");
INSERT INTO mkw_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","«Nganga-Nzambi lenda kwela ve kento ya kindumba, to kento yina basikaka ntete na bakala ya nkaka. Nganga-Nzambi lenda kwela ve kento yina ba katulaka na makwela. Samu ti nganga-Nzambi kele muntu ya longo samu na Nzambi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Nge fwana kutalaka nganga-Nzambi mutindu muntu ya longo, samu ti ni yandi ke nataka madya na sika ya Nzambi ya nge. Yandi fwana kuvwanda muntu ya longo samu na nge, samu ti munu Yave, mu kele Nzambi ya longo. Ni munu ke na kubyeka beno.» ");
INSERT INTO mkw_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","«Kana mwana ya nganga-Nzambi ya kento me sumuka na kindumba, yandi me sumuna tata ya yandi. Ba fwana kulosa mwana yina na tiya.» ");
INSERT INTO mkw_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«Nganga-Nzambi ya ntete, ni yandi kele kuluntu ya banganga-Nzambi. Ba bulumunaka mafuta ya mbyekolo na yintu ya yandi. Ba byekaka yandi samu na kulwata binkuti ya longo. Ni yawu yina yandi lenda bika ve ti bansuki ya yandi kuvwanda ya kumwangana. Yandi lenda mpe ve kupasula binkuti ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Yandi fwana kubelama ve na mvumbi. Yandi fwana kukuma ve ya kuvedila ve, ya vwanda samu na tata ya yandi, ya vwanda samu na mama ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Yandi fwana katuka ve na Yinzo ya longo, samu ti yandi kusumuna ve Yinzo ya longo ya Nzambi ya yandi, samu ti ba byekaka yandi na mafuta ya mbyekolo samu na Nzambi ya yandi. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","«Nganga-Nzambi lenda kwela kaka kento yina me zaba ntete ve babakala. ");
INSERT INTO mkw_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Yandi lenda kwela ve mufwidi, to kento yina ba katulaka na makwela, to kento yina basikaka ntete na bakala ya nkaka, to kento ya kindumba. Yandi ke baka kento mosi ya dikanda ya yandi, yina me zaba ntete ve babakala, ");
INSERT INTO mkw_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","samu ti yandi kukotisa ve menga ya kuvedila ve na kati ya dikanda ya yandi. Ni munu Yave ke na kubyeka yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","na kuzabisa na Aloni mutindu yayi: «Na bambandu nyonso, ata muntu mosi na kati ya bana ya nge ke belama samu na kupesa madya na Nzambi ya nge, kana muntu yina kele na kifuma. ");
INSERT INTO mkw_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Muntu ve yina kele na kifuma ke belama: ya vwanda kifuma ya meso, ya vwanda kifuma ya makulu, ya vwanda kifuma ya mbombo, ya vwanda ti kinama mosi ya nzutu ya yandi me lutila ya nkaka na yinda, ");
INSERT INTO mkw_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Ya vwanda ti dikulu to diboko zenganaka, ");
INSERT INTO mkw_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ya vwanda nkunki to mutela ya nkufi mingi, ya vwanda didoti na disu, ya vwanda makwanza, ya vwanda lota, ya vwanda ti bambanga ya yandi ke ya kumwangana. ");
INSERT INTO mkw_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Na kati ya bana ya nganga-Nzambi Aloni, ata muntu mosi yina kele na kifuma ke belama samu na kuyokila Yave madya. Yandi kele na kifuma, ni yawu yina yandi ke belama ve samu na kupesa madya na Nzambi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Yandi lenda ya yandi kudya madya ya Nzambi ya yandi, ya vwanda ya longo to ya longo mingi. ");
INSERT INTO mkw_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Kasi yandi fwana kuma ve na lele yina ke bumbaka kivinga ya kulutila longo. Yandi lenda mpe kubelama ve na Kiyokolo ya minkayulu, samu ti yandi kele na kifuma. Yandi fwana kusumuna ve bisika ya munu ya longo. Ni munu Yave ke na kubyeka bawu.» ");
INSERT INTO mkw_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moyize tubaka mambu yina na Aloni, na bana ya yandi, na bana nyonso ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Zabisa na Aloni mpe na bana ya yandi na wapi ntangu ba fwana kusalaka keba na bima ya longo yina bana ya Isayeli ke pesaka munu, samu ti bawu kusafula ve nkumbu ya munu ya longo. Mu kele Yave. ");
INSERT INTO mkw_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Zabisa bawu mutindu yayi: «Na bambandu nyonso yina ke kwiza, kana muntu mosi na dikanda ya banganga-Nzambi kele ya kuvedila ve, mpe yandi me belama na minkayulu ya longo yina bana ya Isayeli me pesa na Yave, ba fwana kukatula muntu yina na kisalu ya munu. Mu kele Yave. ");
INSERT INTO mkw_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Konso muntu ya dikanda ya Aloni, yina kele na kimbevo ya mpusu, to konso kimbevo na nzutu ya yandi ya bubakala, yandi lenda kudya ve bima ya longo tii ntangu yandi ke vwanda ya Kuvedila. Mutindu mosi mpe samu na nganga-Nzambi yina me simba muntu yina kumaka ya kuvedila ve samu ti yandi simbaka mvumbi, to nganga-Nzambi yina basikaka maluma, ");
INSERT INTO mkw_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","to nganga-Nzambi yina kumaka ya kuvedila ve samu ti yandi simbaka mwa kibulu ya fyoti-fyoti yina ke sala ti muntu kukuma ya Kuvedila ve, to samu ti yandi simbaka muntu yina kumaka ya kuvedila ve, na nzila ya mutindu na mutindu. ");
INSERT INTO mkw_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Nganga-Nzambi yina me simba bima ya mutindu yina ke vwanda ya kuvedila ve tii na nkokila. Yandi lenda kudya ve bima ya longo tii ntangu yina yandi ke sukula nzutu ya yandi na maza. ");
INSERT INTO mkw_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ntangu ntangu ke dyama, yandi ke vwanda ya kuvedila. Mpe yandi lenda kudya bima ya longo, samu ti yina ni madya ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Yandi lenda kudya ve kibulu yina me kufwa yawu mosi, to yina mpangi kibulu me kufwa. Kana ve, yandi ke vwanda ya kuvedila ve samu na yawu. Mu kele Yave. ");
INSERT INTO mkw_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«Banganga-Nzambi fwana kulanda bantumunu ya munu samu ti bawu kuzwa ve mambu na disumu yina me tadila dyambu ya madya. Kana bawu kusumuna yawu, bawu ke kufwa. Ni munu Yave ke na kubyeka bawu. ");
INSERT INTO mkw_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«Muntu yina kele nganga-Nzambi ve, yandi lenda kudya ve madya ya longo. Muntu yina me kwiza na bunzenza na sika ya nganga-Nzambi, to mpe kisadi ya nganga-Nzambi, bawu lenda kudya ve madya longo. ");
INSERT INTO mkw_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Kasi kana nganga-Nzambi me sumba mundongo na mbongo, mundongo yina lenda kudya madya ya longo. Mundongo yina mpe me butuka na yinzo ya nganga-Nzambi lenda kudya. ");
INSERT INTO mkw_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kana nganga-Nzambi me kwelisa mwana ya yandi ya kento na muntu yina kele ve nganga-Nzambi, mwana yango lenda kudya dyaka ve yina ba me katula na bima ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Kana mwana ya nganga-Nzambi kele mufwidi, to ba katulaka yandi na makwela ata kubuta bana, mpe yandi vutukaka na yinzo ya tata ya yandi samu na kuzinga kuna mutindu yandi vwandaka tekila yandi kukwela, mwana yina mpe lenda kudya madya mosi na tata ya yandi. Ata muntu mosi yina kele nganga-Nzambi ve lenda kudya madya yango. ");
INSERT INTO mkw_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","«Kana muntu me kudya bima ya longo kondwa kuzaba, yandi fwana kufuta na nganga-Nzambi bima yina yandi me kudya. Mpe yandi ke bwela kikunku mosi na kati ya bikunku tanu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","«Banganga-Nzambi fwana kusumuna ve bima ya longo yina bana ya Isayeli ke katulaka samu na kupesa na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Kana bawu kudya yawu ntangu bawu kele ve ya kukubama, bawu ke tula na yintu ya bana ya Isayeli yimbi yina ke lomba ti ba pesa munu kikodi samu na yawu. Ni munu Yave ke na kubyeka yawu.» ");
INSERT INTO mkw_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","na kuzonza na Aloni na bana ya yandi, mpe na bana nyonso ya Isayeli: «Kana muntu mosi ya dikanda ya Isayeli, to nzenza yina ke zingaka na Isayeli zola kupesa Yave Munkayulu ya kuyoka na luzolo ya yandi mosi, to samu na kulungisa nsilulu, ");
INSERT INTO mkw_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","kana yandi zola ti Yave kundima munkayulu yina, yandi fwana kubaka kibulu ya mbakala yina kele ve na kifuma na kati ya bangombe, mameme, to bankombo. ");
INSERT INTO mkw_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Konso kibulu yina kele na kifuma, beno kupesa yawu ve, samu ti Yave ke ndima yawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kana muntu zola kupesa na Yave ngombe, dimeme, to nkombo mutindu Munkayulu ya kiwisa, na luzolo ya yandi mosi to samu na kulungisa nsilulu, kibulu yina fwana kuvwanda ve na kifuma, samu ti Yave kundima yawu. Kibulu yango fwana kuvwanda na ata kifuma. ");
INSERT INTO mkw_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Beno pesa ve Yave kibulu yina kele na meso ya kufwa, to yina kele na kinama ya kubeba, to yina kele na mputa, to mpe yina kele na kimbevo na mpusu ya nzutu ya yandi. Beno kupesa yawu ve mutindu madya ya kuyoka na tiya, na Kiyokolo ya minkayulu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Kibulu yina kele na kinama mosi ya kulutila yinda to nkufi, nge lenda pesa yawu mutindu munkayulu ya luzolo ya nge mosi, ya vwanda ngombe, dimeme, to nkombo. Kasi Yave lenda ndima yawu ve mutindu munkayulu samu na kulungisa nsilulu. ");
INSERT INTO mkw_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Beno pesa ve na Yave munkayulu ya kibulu yina kele na bambanga ya kukota, to ya kumwangana, to ya kukatuka, to ya kuzengana. Beno kusala mutindu yina ve na yinsi ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Beno kundima ve bibulu ya mutindu yina na maboko ya banzenza samu na kupesa yawu mutindu madya na Nzambi ya beno. Bibulu ya kubeba muntindu nyonso yina kele na bifuma, Yave ke ndima beno yawu ve.» ");
INSERT INTO mkw_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yave zonzaka dyaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Na manima ya kubutuka ya mwana ya ngombe, to mwana ya dimeme, to mpe mwana ya nkombo, beno fwana kubika mwana yina kuvwanda na mama ya yandi bilumbu nsambwadi. Kubanda na kilumbu ya nana, Yave lenda ndima yawu mutindu munkayulu ya madya yina ba ke yokaka na tiya. ");
INSERT INTO mkw_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Beno kufwa ve kaka na kilumbu mosi ngombe na mwana ya yandi, to dimeme na mwana ya yandi, to mpe nkombo na mwana ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«Ntangu beno ke pesa na Yave munkayulu ya matondo, beno fwana kupesa yawu na mutindu yina me fwanana samu ti Yave kundima yawu. ");
INSERT INTO mkw_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Beno kudya kibulu yango kaka na kilumbu yina. Beno kubika ve mbisi ya nkaka kukuma tii na suka. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Beno tumama na bantumunu ya munu, mpe beno sadila yawu. Mu kele Yave. ");
INSERT INTO mkw_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Beno safula ve nkumbu ya munu ya longo, samu ti mu vwanda Nzambi ya longo na kati-kati ya bana ya Isayeli. Ni munu Yave ke na kubyeka beno. ");
INSERT INTO mkw_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ni munu basisaka beno na yinsi ya Ngipiti samu na kuvwanda Nzambi ya beno. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","na kuzabisa na bana ya Isayeli mutindu yayi: «Yayi ni balukutakanu samu na mikembo ya Yave, balukutakanu yina ke sala ti beno kutikisa bantu, ya kele balukutakanu ya longo.» ");
INSERT INTO mkw_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«Bilumbu ya kusala bisalu kele sambanu. Kasi kilumbu ya nsambwadi kele Saba, kilumbu ya kupema, kilumbu ya lukutakanu ya longo. Beno ke sala ata kisalu mosi ve. Ya kele Saba samu na Yave, na bisika nyonso yina beno ke zinga.» ");
INSERT INTO mkw_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«Yayi ni balukutakanu ya mikembo ya Yave, balukutakanu ya longo yina beno ke sala na bantangu ya yawu.» ");
INSERT INTO mkw_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","«Na ngonda ya ntete, na kilumbu ya kumi na yiya na nkokila, ya ke vwanda Paki samu na Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","«Kaka na ngonda yina, na kilumbu ya kumi na tanu, ya ke vwanda mukembo ya mampa yina ba me funisa ve samu na Yave. Beno ke sala bilumbu nsambwadi na kudyaka mampa yina ba me funisa ve. ");
INSERT INTO mkw_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Kilumbu ya ntete ya lumingu yina, beno ke vwanda na lukutakanu ya longo. Beno ke sala ata kisalu mosi ve na bisalu nyonso yina beno ke salaka bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Bilumbu nsambwadi, beno ke pesa na Yave madya yina ba ke yokaka na tiya. Na kilumbu yina ya nsambwadi, ya ke vwanda lukutakanu ya longo. Beno ke sala ata kisalu mosi ve na bisalu nyonso yina beno ke salaka bantangu nyonso.» ");
INSERT INTO mkw_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","na kuzabisa na bana ya Isayeli mutindu yayi: «Ntangu beno ke kota na yinsi yina mu ke na kupesa beno, ntangu beno ke yonzika bambuma ya ntete yina beno ke kuna na yinsi yango, beno ke nata na sika ya nganga-Nzambi madya ya ntete ya bima yina beno ke yonzika. ");
INSERT INTO mkw_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Nganga-Nzambi ke pesa yawu na mutindu ba ke sadilaka na mantwala ya Yave, samu ti Yave kundima beno. Yandi ke pesa yawu mutindu yina na kilumbu yina ke landa Saba. ");
INSERT INTO mkw_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Na kilumbu yina beno ke pesa madya yango, beno ke pesa Yave Munkayulu ya kuyoka ya mwana ya dimeme ya mvula mosi, yina kele ve na kifuma. ");
INSERT INTO mkw_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Beno ke pesa yawu ya kuvukana na Munkayulu ya madya ya bilanga ya bikunku zole na kati ya bikunku kumi ya Efa ya kiputi ya faline ya kitoko yina ba me vukisa na mafuta. Yawu kele madya ya kuyoka na tiya samu na Yave. Nsunga ya yawu ke yangidikaka Yave. Kaka na ntangu yina mpe, beno ke pesa munkayulu ya malafu ya Yine mosi ya vinu. ");
INSERT INTO mkw_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Tekila kilumbu yina beno ke nata munkayulu na Nzambi ya beno, beno kudya ve bambuma yina ya malu-malu, ya vwanda mampa, to bambuma ya kukalinga, to bambuma ya nkunzu. Ya kele bansalulu ya bantangu nyonso, samu na bambandu nyonso, na bisika nyonso yina beno ke zinga.» ");
INSERT INTO mkw_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«Kilumbu yina ke landa Saba, ni kilumbu yina beno ke nata madya ya kupesa mutindu ba ke salaka na mantwala ya Yave. Kubanda na kilumbu yina, beno ke tanga balumingu nsambwadi ya muvimba. ");
INSERT INTO mkw_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Beno ke tanga bilumbu makumi tanu tii kilumbu yina ke landa Saba ya nsambwadi. Na kilumbu yango, beno ke pesa na Yave munkayulu ya malu-malu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Na bisika nyonso yina beno ke vwanda, beno ke baka mampa zole ya kwenda pesa mutindu munkayulu mutindu ba ke salaka na mantwala ya Yave. Ba ke lambila mampa yina na bikunku zole na kati ya bikunku kumi ya Efa ya faline ya kitoko samu na konso dimpa. Ba ke funisa yawu. Ni yina ke vwanda minkayulu ya madya ya beno ya ntete samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Na zulu ya mampa yina, beno ke nata bana nsambwadi ya mameme, yina kele ve na kifuma, na ngombe mosi ya mbakala, na mameme zole ya mbakala. Bibulu yina ke vwanda minkayulu ya kuyoka samu na Yave. Munkayulu ya madya ya bilanga na munkayulu ya malafu ke vwanda madya ya kuyoka na tiya. Nsunga ya yawu ke yangidikaka Yave. ");
INSERT INTO mkw_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Beno ke pesa nkombo ya mbakala mutindu Munkayulu ya mulemvo, mpe bana zole ya mameme ya mvula mosi, samu na Munkayulu ya Kiwisa. ");
INSERT INTO mkw_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Nganga-Nzambi ke pesa bibulu yina mutindu ba ke salaka na mantwala ya Yave. Yandi ke sala yawu mbala mosi na mampa yina salamaka na faline ya bambuma ya ntete. Ba ke byeka yawu samu na Yave, mpe yawu ke vwanda ya nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Kaka na kilumbu yina, beno ke sala lukutakanu. Ya ke vwanda lukutakanu ya longo: Beno ke sala ata kisalu mosi ve na bisalu nyonso yina beno ke salaka bantangu nyonso. Ya kele bansalulu ya bantangu nyonso, na bambandu nyonso ya beno, na bisika nyonso yina beno ke zinga.» ");
INSERT INTO mkw_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«Ntangu ya kuyonzika bambuma ya bilanga ya yinsi ya beno, beno kuyonzika ve bambuma yina kele na ndilu ya bilanga. Beno vutuka ve na kwenda lokota yina bikanaka na bisika yina beno vwandaka me yonzika yimeni. Beno ke bika yawu samu na bamputu mpe banzenza. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","na kuzabisa na bana ya Isayeli mutindu yayi: «Na ngonda ya nsambwadi, kilumbu ya ntete ke vwanda kilumbu ya kupema. Ya ke vwanda kilumbu yina ba ke bambuka moyo, mpe kilumbu ya kusala milolo ya nsayi. Na kilumbu yango ya nsambwadi ke vwanda lukutakanu ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Beno ke sala ata kisalu mosi ve na bisalu nyonso yina beno ke salaka bantangu nyonso. Mpe beno ke pesa na Yave madya yina ba ke yokaka na tiya.» ");
INSERT INTO mkw_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Na ngonda yina ya nsambwadi, kilumbu ya kumi ke vwanda kilumbu ya nene ya kukatula masumu. Beno ke vwanda na lukutakanu ya longo. Beno ke mina-nsoki, mpe beno ke pesa na Yave madya yina ba ke yokaka na tiya. ");
INSERT INTO mkw_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Na kilumbu yina, beno ke sala ata kisalu ve, samu ti ya ke kilumbu yina ba ke katula masumu ya beno na mantwala ya Yave, Nzambi ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Konso muntu yina ke Mina-nsoki ve na kilumbu yina, ba ke katula yandi na lutangu ya bantu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Konso muntu yina ke sala kisalu ni kisalu na kilumbu yina, mu ke katula yandi na kati ya bantu ya yandi mpe yandi ke kufwa. ");
INSERT INTO mkw_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Beno ke sala ata kisalu mosi ve. Yina kele bansalulu ya bantangu nyonso, samu na bambandu nyonso ya beno, na bisika nyonso yina beno ke zinga. ");
INSERT INTO mkw_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Kilumbu yina ke vwanda Saba samu na beno, kilumbu ya kupema. Beno ke mina nsoki. Kubanda na nkokila ya kilumbu ya yivwa ya ngonda tii na nkokila ya kilumbu yina ke landa.» ");
INSERT INTO mkw_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","na kuzabisa na bana ya Isayeli mutindu yayi: «Kubanda na kilumbu ya kumi na tanu na ngonda ya nsambwadi, beno ke kembila mukembo ya mileba samu na Yave, bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Na kilumbu ya ntete ke vwanda lukutakanu ya longo. Beno ke sala ata kisalu mosi ve na bisalu nyonso yina beno ke salaka bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Na bilumbu nsambwadi yina, beno ke pesa na Yave madya yina ba ke yokaka na tiya. Na kilumbu ya nana, beno ke sala lukutakanu ya longo. Na kilumbu yina mpe, beno ke pesa na Yave madya yina ba ke yokaka na tiya. Ya ke kilumbu ya lukutakanu ya nene samu na Yave. Beno ke sala ata kisalu mosi ve na bisalu nyonso yina beno ke salaka bantangu nyonso.» ");
INSERT INTO mkw_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«Yina ni balukutakanu ya mikembo ya Yave yina beno ke sala. Ya kele balukutakanu ya longo samu na kupesa na Yave madya yina ba ke yokaka na tiya, na minkayulu ya kuyoka, na minkayulu ya madya ya bilanga, na minkayulu ya kiwisa, na minkayulu ya malafu. Konso munkayulu ke pesama na ntangu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Beno ke vukisa minkayulu nyonso yina na minkayulu yina ba ke pesaka na basaba ya Yave, na yina ba ke pesaka samu na kulungisa nsilulu, na nyonso yina ba ke pesaka Yave na luzolo muntu yandi mosi.» ");
INSERT INTO mkw_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«Na kilumbu ya kumi na tanu ya ngonda ya nsambwadi, na manima ya kuyonzika madya ya bilanga, beno ke sala mukembo ya Yave na bilumbu nsambwadi. Kilumbu ya ntete ke vwanda kilumbu ya kupema. Kilumbu ya nana mpe ke vwanda kilumbu ya kupema. ");
INSERT INTO mkw_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Na kilumbu ya ntete, beno ke baka bambuma ya kitoko ya bayinti, mandala, bintala ya bayinti yina kele na makasa mingi mpe yina ke menaka pene-pene ya mizumba. Mpe beno ke yangalala na mantwala ya Yave Nzambi ya beno bilumbu nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Konso mvula, beno ke sala mukembo yayi samu na Yave, bilumbu nsambwadi. Yina kele bansalulu ya bantangu nyonso, na bambandu nyonso ya beno. Beno ke sala mukembo yayi na ngonda ya nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Beno ke vwanda bilumbu nsambwadi na kati ya mileba. Bantu nyonso ya yinsi ya Isayeli ke vwanda na kati ya mileba, ");
INSERT INTO mkw_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","samu ti bambandu ya beno yina ke landa, kuzaba ti mu vwandisaka bana ya Isayeli na kati ya mileba ntangu mu basisaka bawu na yinsi ya Ngipiti. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ni mutindu yina Moyize zabisaka na bana ya Isayeli mambu yina me tadila balukutakanu ya mikembo ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Tumisa bana ya Isayeli na kunatinaka nge mafuta ya olive ya kulutila kitoko, samu ti minda kulema ntangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aloni ke tula minda na kati ya Yinzo ya Mbwabanu, na mantwala ya lele yina ke bumbaka Sanduku ya ngwisani, samu ti minda yina kulema na mantwala ya Yave kubanda na nkokila tii na suka. Yina kele bansalulu ya bantangu nyonso samu na bambandu nyonso ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aloni ke tula minda yango na mantwala ya Yave, na zulu ya kitentokolo ya minda, ya wolo ya mbote, samu ti yawu kulemaka mpimpa nyonso.» ");
INSERT INTO mkw_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Baka faline ya kitoko nge sala mampa kumi na zole. Konso dimpa ke vwanda na bikunku zole na kati ya bikunku kumi ya Efa. ");
INSERT INTO mkw_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Tula yawu na bikunku zole. Mampa sambanu na konso kikunku. Yawu ke vwanda na mesa ya wolo ya mbote, na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Nge ke tula maaka ya nsunga ya mbote na konso kikunku. Ya ke vwanda na zulu ya mampa samu na kubambukaka moyo, mutindu madya yina ba me yoka na tiya samu na Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","«Konso kilumbu ya Saba, ba ke tula mampa yina na mantwala ya Yave, na bantangu nyonso. Mampa yina ke katuka na maboko ya bana ya Isayeli. Yayi kele ngwisani ya bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Mampa yango ke vwanda ya Aloni na bana ya yandi. Bawu ke kudya yawu na kisika mosi ya longo. Yawu ke vwanda samu na bawu madya mosi ya longo, na kati ya minkayulu yina ba ke yokaka na tiya samu na Yave. Ya kele bansalulu ya bantangu nyonso.» ");
INSERT INTO mkw_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Kento mosi ya Isayeli butaka mwana na bakala mosi ya Ngipiti. Kilumbu mosi, na kati-kati ya bana ya Isayeli, mwana yango swanaka na muntu mosi ya Isayeli kuna na kivwandu. ");
INSERT INTO mkw_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Nkumbu ya mama ya mwana yango vwandaka Selomite, mwana ya Dibeli, ya dikanda ya Dane. Mwana yango zonzilaka Nkumbu ya Yave na mutindu ya yimbi, mpe yandi fingaka Nzambi. Na yina, ba nataka yandi na sika ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ba bumbaka yandi mbote-mbote na kisika mosi na kuvingilaka ti Yave pesa nzengolo samu na yandi. ");
INSERT INTO mkw_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Muntu yina me finga Nzambi, nata yandi ntama na kivwandu. Bantu nyonso yina kuwaka yandi na kufinga, ba ke tentika maboko ya bawu na zulu ya yintu ya yandi. Mpe mukangu nyonso ya Isayeli ke kufwa yandi na matadi.» ");
INSERT INTO mkw_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tuba na bana ya Isayeli mutindu yayi: «Kana muntu me finga Nzambi, disumu ya yandi ke kubwa na zulu ya yintu ya yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Muntu yina ke zonzila Nkumbu ya Yave na mutindu ya yimbi, ba fwana kufwa yandi. Mukangu nyonso ya Isayeli ke kufwa yandi na matadi. Ya vwanda nzenza, ya vwanda muntu ya yinsi, yandi fwana kufwa samu ti yandi me zonzila Nkumbu ya Yave na mutindu ya yimbi.» ");
INSERT INTO mkw_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«Kana muntu me kufwa mpangi muntu, yandi mpe ba fwana kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Kana muntu me kufwa kibulu ya mpangi muntu, yandi fwana kuyingisa kibulu ya moyo na kisika ya kibulu yina yandi me kufwa.» ");
INSERT INTO mkw_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","«Kana muntu me lwalisa mpangi muntu, yandi mpe ba fwana kulwalisa yandi mutindu mosi. ");
INSERT INTO mkw_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Kana muntu buka mpangi kinama, yandi mpe ba fwana kubuka yandi kinama. Kana muntu tobola mpangi disu, yandi mpe ba fwana kutobola yandi disu. Kana muntu katula mpangi dinu, yandi mpe ba fwana kukatula yandi dinu. Ba ke vutula yandi yimbi ya mutindu yandi me sala na mpangi.» ");
INSERT INTO mkw_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","«Muntu yina ke kufwa kibulu, yandi fwana kuyingisa kibulu ya nkaka. Kasi muntu yina ke kufwa muntu, kaka kufwa ba fwana kufwa yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","«Misiku ke vwanda kaka mosi: samu na banzenza mpe samu na bantu ya yinsi. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moyize zonzaka mambu yina na bana ya Isayeli. Mwana yango yina zonzilaka nkumbu ya Nzambi na mutindu ya yimbi, ba nataka yandi ntama na kivwandu. Mpe ba kufwaka yandi na matadi. Bana ya Isayeli salaka mutindu Yave tumisaka Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Kuna na mongo ya Sinayi, Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","na kuzabisa na bana ya Isayeli mutindu yayi: «Ntangu beno ke kota na yinsi yina mu ke na kupesa beno, beno ke pemisa ntoto. Ya ke vwanda mvula ya Saba samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Bamvula sambanu, beno ke kuna bilanga ya beno, beno ke zenga bintala ya bayinti ya beno ya vinu samu na kubongisa yawu. Beno ke yonzika bambuma ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Kasi na mvula ya nsambwadi, ya ke vwanda Saba. Ba fwana kupemisa ntoto. Ya ke Saba samu na Yave. Beno ke kuna ve bilanga ya beno. Beno ke zenga mpe ve bintala ya bayinti ya bilanga ya beno ya vinu. ");
INSERT INTO mkw_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Beno ke yonzika ve bima yina me mena yawu mosi na manima ya nyonzokolo. Beno ke yonzika mpe ve bambuma ya vinu na bayinti ya vinu yina beno zengaka ve bintala, samu ti mvula yina ke vwanda mvula ya kupema samu na ntoto. ");
INSERT INTO mkw_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Kasi beno lenda kudya bima yina ntoto ke menisa na mvula yina ya kupema, nge, na mindongo ya nge ya babakala na ya bakento, na bisadi ya nge, na banzenza yina ke na kuzinga mwa bilumbu na sika ya beno, ");
INSERT INTO mkw_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","na bibulu ya beno ya bwala, na bibulu yina kele na yinsi ya beno. Madya nyonso yina ntoto ke pesa ni yina beno ke kudya.» ");
INSERT INTO mkw_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«Beno ke tanga bamvula nsambwadi bambala nsambwadi. Lutangu ya bamvula nyonso yina ke sala makumi yiya na yivwa. ");
INSERT INTO mkw_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Na manima, na ngonda ya nsambwadi, na kilumbu ya kumi, beno ke wakisa muningu ya mpungi mpe kusala milolo. Ya ke vwanda kilumbu ya katula masumu. Beno ke wakisa muningu ya mpungi na yinsi nyonso. ");
INSERT INTO mkw_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Beno ke byeka longo mvula yina ya makumi tanu. Beno ke samuna na yinsi nyonso ti bantu nyonso me kuzwa kimpwanza. Yawu ke vwanda Mvula ya Kuyangalala samu na beno. Konso muntu na kati ya beno ke vutuka na ntoto ya yandi. Konso muntu ke vutuka na sika ya dikanda ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mvula yina ya makumi tanu ke vwanda Mvula ya Kuyangalala samu na beno. Beno ke kuna bilanga ve. Beno ke yonzika ve bambuma yina menaka yawu mosi. Beno ke yonzika ve bambuma ya vinu ya bayinti yina ba zengaka ve bintala. ");
INSERT INTO mkw_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Yina kele Mvula ya Kuyangalala. Yawu ke vwanda ya longo samu na beno. Na mvula yina, beno ke kudya bima yina bilanga ke pesa.» ");
INSERT INTO mkw_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«Na Mvula ya Kuyangalala yina, konso muntu ke vutuka na ntoto ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Kana muntu me sumba to yandi me tekisa ntoto na mpangi muntu yina bawu kele yinsi mosi, bawu kuvunasana ve na kusalasana yimbi. ");
INSERT INTO mkw_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ntangu nge ke sumba, nge fwana kutanga bamvula yina me luta kubanda na Mvula ya Kuyangalala. Muntu yina ke tekisila nge fwana kutala lutangu ya bamvula ya nyonzokolo yina me bikana na kukuma na Mvula ya Kuyangalala yina ke landa. ");
INSERT INTO mkw_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Kana bamvula ya nyonzokolo yina me bikana kele ya mingi, nge ke sumba na ntalu ya mingi. Kana bamvula ke mingi ve, nge ke sumba na ntalu ya fyoti. Ni lutangu ya bamvula ya nyonzokolo ba ke na kutekisila nge. ");
INSERT INTO mkw_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Kuvuna ve mpangi muntu yina beno kele yinsi mosi. Zitisa Nzambi ya nge, samu ti mu kele Yave Nzambi ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Beno landa bansalulu ya misiku ya munu. Beno keba mpe beno sadila misiku ya munu. Na yina beno ke zinga na kati ya ntomosono na yinsi. ");
INSERT INTO mkw_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ntoto ke pesa bambuma ya kulunga. Beno ke kudya mpe beno ke yukuta. Mpe beno ke zinga luzingu mosi ya mbote.» ");
INSERT INTO mkw_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","«Bantangu ya nkaka beno lenda yufula mutindu yayi: “Yinki beto ke kudya na mvula ya nsambwadi, samu ti beto ke kuna kima ve, beto ke yonzika mpe kima ve?” ");
INSERT INTO mkw_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mu me sala ti lusakumunu ya munu kuvwanda ya mingi samu na beno na mvula yina ya sambanu. Mpe yawu ke sala ti beno kuzwa bambuma ya bamvula tatu. ");
INSERT INTO mkw_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Na mvula ya nana, beno ke kuna bilanga ya beno. Mpe beno ke kudya bambuma ya mvula ya ntete tii na mvula ya yivwa. Beno ke kudya bambuma ya ntama tii ntangu bambuma ya mvula ya yivwa ke kuma.» ");
INSERT INTO mkw_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«Beno lenda tekisa ve ntoto ya mankululu, samu ti ntoto ke ya munu. Mpe beno, beno kele kaka banzenza na ntoto ya munu. Beno kele bantu yina ke zinga kaka na mwa ntangu fyoti na ntoto ya munu. ");
INSERT INTO mkw_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Na yina, na yinsi nyonso ya beno, beno ke pesa na muntu yina tekisaka ntoto ya yandi muswa ya kukuula dyaka yawu.» ");
INSERT INTO mkw_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","«Kana mpangi ya nge muntu yina beno kele yinsi mosi me kuma mputu, mpe yandi me tekisa ndambu ya ntoto ya yandi, mosi na bampangi ya yandi yina ke na muswa ya kukuula ntoto yango lenda kwiza. Yandi lenda kuula ntoto yina mpangi ya yandi me tekisa. ");
INSERT INTO mkw_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kana muntu kele ve na mpangi yina ke na muswa ya kukuula ntoto yango, kasi yandi mosi yandi me kuzwa nyonso ya kulunga samu na kukuula yawu, ");
INSERT INTO mkw_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","yandi ke tanga bamvula nyonso yina me luta kubanda ntangu yina yandi tekisaka yawu. Mpe yandi ke futa na muntu yina sumbaka ntoto yango ntalu ya bamvula yina me bikana na kukuma na Mvula ya Kuyangalala. Na manima, yandi lenda vutukila ntoto ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Kana yandi kuzwa ve nyonso ya kulunga samu na kufuta muntu yina sumbaka ntoto ya yandi, ntoto yango ke vwanda kaka ya muntu yina sumbaka yawu tii na Mvula ya Kuyangalala. Na mvula yina ya kilengi, yandi ke vutukila ntoto ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«Na bambanza yina ba tungaka na kati ya lupangu, kana muntu me tekisa yinzo ya yandi ya kuvwandila, muswa ya kukuula yinzo yango ke zingila kaka mvula mosi, kubanda ntangu yina yandi tekisaka yawu. ");
INSERT INTO mkw_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kana ba me kuula ve yinzo yina tii ntangu mvula ya muvimba ke lunga, yinzo yango ke vwanda ya mankululu ya muntu yina me sumba yawu, yandi na bana ya yandi. Ba ke vutula ve yawu ata na Mvula ya Kuyangalala. ");
INSERT INTO mkw_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Bayinzo yina kele na babwala yina kele ve na kati ya lupangu, beno ke bakila yawu mutindu ntoto na yina me tadila mambu ya kukuula. Ba lenda kuula yawu. Na Mvula ya Kuyangalala, konso yinzo yina ba tekisaka ke vutuka na maboko ya muntu yina tekisaka yawu.» ");
INSERT INTO mkw_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«Kasi na yina me tadila ba-Levi, bawu kele bantangu nyonso na muswa ya kukuula bayinzo ya bawu yina kele na bambanza ya bawu. ");
INSERT INTO mkw_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Kana muntu mosi na kati ya ba-Levi me kuula yinzo ya mu-Levi ya nkaka na kati ya mbanza ya ba-Levi, muntu yango fwana kubasika na yinzo yango na Mvula ya Kuyangalala. Yinzo ke vutukila na kuvwanda ya muntu ya yawu, samu ti mvwilu ya ba-Levi na kati-kati ya bana ya Isayeli, ni bayinzo yina. ");
INSERT INTO mkw_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Kasi bilanga yina me zungidila bambanza ya ba-Levi, ba lenda kutekisa yawu ve, samu ti yawu kele mvwilu ya bantangu nyonso ya ba-Levi.» ");
INSERT INTO mkw_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«Kana mpangi ya nge muntu yina beno kele yinsi mosi me kuma mputu, mpe yandi ke dyaka ve na lubaku ya kulunga, nge fwana kusadisa yandi. Sala mutindu mosi mpe samu na konso muntu yina me kwiza zinga kaka na mwa ntangu fyoti na yinsi ya nge, samu ti yandi kulenda na kuzinga na sika ya nge. ");
INSERT INTO mkw_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Kusosa ve na kuzwa ndandu ya mutindu na mutindu na sika ya yandi. Zitisa Nzambi, mpe mpangi ya nge ke kuzwa luve ya kuzinga na sika ya nge. ");
INSERT INTO mkw_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kana nge me defisa yandi mbongo, kulomba ve ndandu na zulu ya mbongo yina. Kana nge me pesa yandi madya, kusosa ve ti yandi vutula nge yawu na ndandu na zulu. ");
INSERT INTO mkw_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mu kele Yave Nzambi ya beno. Ni munu basisaka beno na yinsi ya Ngipiti, samu na kupesa beno yinsi ya Kaana, mpe na kuvwanda Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«Kana mpangi ya nge muntu yina beno kele yinsi mosi, yandi me kuma mputu, mpe yandi me kukitekisa na sika ya nge mutindu kisadi, kupesa yandi ve kisalu ya mundongo. ");
INSERT INTO mkw_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Bakila yandi mutindu kisadi yina ba ke futaka, to mutindu nzenza yina me kwiza vwanda na sika ya nge. Yandi ke sadila nge tii na Mvula ya Kuyangalala. ");
INSERT INTO mkw_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Na mvula yango, yandi ke katuka na yinzo ya nge, yandi na bana ya yandi. Yandi ke vutuka na sika ya dikanda ya yandi mpe yandi ke vutukila ntoto ya batata ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Samu ti bana ya Isayeli kele bisadi ya munu, yina mu basisaka na yinsi ya Ngipiti. Ba lenda tekisa bawu mutindu bandongo ve. ");
INSERT INTO mkw_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kuyala bawu na ngolo ve. Nge fwana kuzitisa Nzambi ya nge.» ");
INSERT INTO mkw_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","«Kana beno kele na nsatu ya bandongo ya babakala to ya bakento, beno fwana kusumba bawu na sika ya makanda ya bantu yina me zungidila beno. ");
INSERT INTO mkw_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Beno lenda sumba bawu mpe na sika ya banzenza yina ke na kuvwandaka na sika ya beno. Beno lenda sumba mpe na kati ya bana ya bawu yina me butuka na yinsi ya beno. Bawu yina ke vwanda ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Beno ke bika bawu mutindu difwa na maboko ya bana ya beno. Ya ke vwanda mvwilu yina beno ke bikila bawu. Beno ke keba bawu mutindu bandongo ya bantangu nyonso. Kasi na yina me tadila bampangi ya beno bana ya Isayeli, ata mosi na beno lenda yala mpangi ya yandi na ngolo.» ");
INSERT INTO mkw_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«Kana nzenza to muntu yina me kwiza zinga kaka na mwa ntangu fyoti na sika ya beno, yandi me kuma mvwama, kana mpangi ya nge yina beno kele yinsi mosi me kuma mputu, mpe ti yandi me kwenda kukitekisa na maboko ya nzenza yina ya mvwama to na maboko ya muntu mosi ya dikanda ya mvwama yango, ");
INSERT INTO mkw_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","muswa kele ya kukuula yandi na manima ya kukitekisa ya yandi. Mosi na bampangi ya yandi lenda kuula yandi. ");
INSERT INTO mkw_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Kana ve, mpangi ya tata ya yandi lenda kuula yandi, to mwana ya mpangi ya tata ya yandi. Kana yandi mosi kele na nyonso ya kulunga, yandi lenda kukikuula yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Yandi na muntu yina sumbaka yandi, ba ke tanga bamvula, kubanda ntangu yina yandi kukitekisaka tii na Mvula ya Kuyangalala. Ntalu ke vwandila mutindu ke vwanda lutangu ya bamvula. Ba ke tangila yawu mutindu ba ke tangilaka difuta ya kisadi na kilumbu mosi ya kisalu. ");
INSERT INTO mkw_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kana bamvula yina me bikana ke ntete mingi, yandi ke vutula, samu na nkuudulu ya yandi, kikunku ya nene na kati ya ntalu yina ba sumbilaka yandi. ");
INSERT INTO mkw_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Kana bamvula yina me bikana ke kaka fyoti, yandi ke sala lutangu ya yawu. Mpe yandi ke vutula, samu na nkuudulu ya yandi, ntalu yina me fwanana na bamvula yina. ");
INSERT INTO mkw_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ntangu nyonso yina yandi ke vwanda na sika ya mfumu ya yandi, yandi ke vwanda mutindu kisadi yina ba ke futaka. Beno lenda bika ve ti mfumu yina kuyala yandi na ngolo. ");
INSERT INTO mkw_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Kana ba me kuula yandi ve na banzila yina, yandi ke kuzwa kimpwanza na Mvula ya Kuyangalala, yandi na bana ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ya tsyelika bana ya Isayeli kele bisadi ya munu. Bawu kele bisadi ya munu samu ti mu basisaka na yinsi ya Ngipiti. Mu kele Yave, Nzambi ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Beno kuyidika ve banzambi ya luvunu. Beno kuyidika ve biteki. Beno kutelemisa ve matadi ya kubyekwa. Beno kutula ve na yinsi ya beno matadi yina ba me bongisa samu ti beno kusambilaka yawu. Mu kele Yave, Nzambi ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Beno kuzitisa basaba ya munu. Beno kuzitisa Yinzo ya munu ya longo. Mu kele Yave. ");
INSERT INTO mkw_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Kana beno landa bansalulu ya munu, kana beno keba bantumunu ya munu mpe ti beno sadila yawu, ");
INSERT INTO mkw_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","mu ke nokisina beno bamvula na ntangu ya yawu. Ntoto ke pesa madya ya yawu. Mpe bayinti ke pesa bambuma ya yawu. ");
INSERT INTO mkw_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Beno ke tatamana na kututaka bambuma ya faline samu na kukabula yawu na matiti ya yawu tii ntangu yina beno ke banda na kuyonzika bambuma ya bayinti ya vinu. Beno ke tatamana na kuyonzika bambuma ya vinu tii ntangu yina beno ke banda dyaka kukuna bambuma ya faline. Beno ke kudya mpe beno ke yukuta. Mpe beno ke zinga luzingu mosi ya mbote na yinsi ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Mu ke tula kizunu na yinsi. Ata muntu ke kwamisa beno ntangu beno ke lala pongi. Mu ke sala ti bibulu ya nsisi kuzimbana na yinsi ya beno. Mpe bamvita ke vwanda ve na yinsi ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Beno ke kimisa bambeni ya beno. Mpe beno ke nunga bawu na bambele ya beno ya mvita. ");
INSERT INTO mkw_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Bantu tanu na kati ya beno ke kimisa bambeni nkama (100). Bantu nkama (100) ke kimisa mafunda kumi (10 000) ya bambeni. Beno ke nunga bambeni ya beno na bambele ya beno ya mvita. ");
INSERT INTO mkw_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Mu ke sadila beno bumbote, mpe mu ke sala ti beno kubutana mingi. Mu ke keba Ngwisani ya munu na beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Beno ke kudya na ntangu ya yinda, bambuma yina beno yonzikaka. Beno ke katula mpe bambuma yina ya ntama samu na kuzwa kisika ya kutula yina ya malu-malu. ");
INSERT INTO mkw_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Mu ke kwiza zinga na kati-kati ya beno. Mpe mu ke manga beno ve. ");
INSERT INTO mkw_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mu ke tambula na kati-kati ya beno. Mu ke vwanda Nzambi ya beno, mpe beno, beno ke vwanda bantu ya munu. ");
INSERT INTO mkw_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mu kele Yave, Nzambi ya beno. Ni munu basisaka beno na yinsi ya Ngipiti, samu ti beno kuvwanda dyaka ve bandongo ya bantu ya Ngipiti. Mu zengaka basinga ya bundongo ya beno. Mpe mu salaka ti beno kutambula na kimpwanza nyonso.» ");
INSERT INTO mkw_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Kana beno tumama ve, kana beno kusadila ve bantumunu nyonso yina, ");
INSERT INTO mkw_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","kana beno kutumama ve na bansalulu ya misiku ya munu, kana beno manga bantumunu ya munu, kana beno kusadila ve misiku ya munu nyonso, kana beno kufwa Ngwisani ya munu, ");
INSERT INTO mkw_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","mu ke sala beno mutindu yayi: «Mu ke sala beno mambu ya nsisi, mu ke fidisa beno bimbevo yina ba ke belusaka ve, na mabawu. Yawu ke lembisa meso ya beno mpe ke bebisa luzingu ya beno. Bisalu yina beno ke sala ya kukuna bilanga ke vwanda bisalu ya mpamba. Ni bambeni ya beno ke kudya bambuma ya kisalu ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Mu ke balukila beno. Mpe bambeni ya beno ke nunga beno. Bayina ke yinaka beno ke yala beno. Beno ke banda na kukima kasi ata muntu ke na kulanda beno.» ");
INSERT INTO mkw_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Na zulu ya nyonso yina, kana beno tumama ve na munu, mu ke semba beno samu na masumu ya beno, kusemba mosi ya kulutila ngolo bambala nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Mu ke sukisa ngolo ya beno yina beno ke na kusadila mayama. Mu ke kitula zulu ya beno mutindu kisengo, mpe ntoto ya beno mutindu kisengo ya mbwaki. ");
INSERT INTO mkw_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Beno ke lembisa banzutu ya beno kaka mpamba. Ntoto ya beno ke buta ve. Bayinti ya yinsi ke pesa bambuma ve.» ");
INSERT INTO mkw_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«Kana beno manga munu, mpe ti beno kutumama ve na munu, mu ke semba beno samu na masumu ya beno, kusemba mosi ya kulutila ngolo bambala nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mu ke fidisa beno bibulu ya mfinda. Bawu ke kufwa bana ya beno, bawu ke kufwa bibulu ya beno ya bwala, mpe bawu ke sala ti lutangu ya bantu ya beno kukuma fyoti. Bantu ke tambula dyaka ve na banzila ya beno.» ");
INSERT INTO mkw_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Kana beno soba ve na masembo ya munu, kana beno tatamana na kumanga munu, ");
INSERT INTO mkw_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","munu mpe, mu ke manga beno: mu ke semba beno samu na masumu ya beno, kusemba mosi ya kulutila ngolo bambala nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Mu ke natina beno bamvita samu na kufutisa beno yimbi yina beno me sala na ngwisani ya munu. Ntangu beno ke kima samu na kwenda bumbama na bambanza, mu ke fidisa beno biyoolo. Beno ke kubwa na lulendo ya bambeni ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Mu ke pesa dyaka beno ve madya. Bakento kumi ke yokila mampa ya beno na kifuule mosi kaka. Ba ke kabudila beno mampa yango na mwa bibuku ya fyoti-fyoti. Beno ke kudya, kasi beno ke yukuta ve.» ");
INSERT INTO mkw_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Kana na nyonso yina beno tumama na munu ve, kana beno tatamana na kumanga munu, ");
INSERT INTO mkw_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","munu mpe mu ke manga beno. Mpe na nkele nyonso, mu ke semba beno samu na masumu ya beno, kusemba mosi ya kulutila ngolo bambala nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Beno ke kudya bana ya beno ya babakala. Beno ke kudya mpe bana ya beno ya bakento. ");
INSERT INTO mkw_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Mu ke mwangisa bisika ya beno ya lusambulu yina kele na zulu ya myongo. Mu ke bebisa bisika ya beno ya kuyokilaka maaka ya nsunga ya mbote. Mu ke tula bamvumbi ya beno na zulu ya biteki ya beno yina mu ke mwangisa. Mu ke yina beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mu ke mwangisa bambanza ya beno. Mu ke bebisa bisika ya beno ya longo. Mu ke kuwa dyaka ve nsunga ya Minkayulu ya beno yina ke yangidikaka munu. ");
INSERT INTO mkw_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Munu mosi mu ke mwangisa yinsi ya beno. Mpe bambeni ya beno yina ke kwiza vwanda kuna, ba ke pamuka. ");
INSERT INTO mkw_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Mu ke natina beno bamvita. Mpe mu ke mwangisa beno na bayinsi ya nzenza. Yinsi ya beno ke beba. Bambanza ya beno ke mwangana.» ");
INSERT INTO mkw_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","«Yinsi ya beno ke kuzwa basaba ya yandi ntangu nyonso yina yawu ke vwanda ya kumwangana, ntangu yina beno ke vwanda na bayinsi ya bambeni ya beno. Na ntangu yango, yinsi ya beno ke pema mingi, samu na kuzwa basaba ya yandi nyonso yina beno yiminaka yawu. ");
INSERT INTO mkw_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ntangu nyonso yina yinsi ke vwanda ya kumwangana, yawu ke vwanda na Saba, Saba yina yawu vwandaka lembana na kuzwa ntangu beno vwandaka zinga kuna.» ");
INSERT INTO mkw_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«Bayina na kati ya beno ke bikana na bayinsi ya bambeni ya beno, mu ke fulusa bawu na boma. Makelele ya mpamba ya dikasa yina me kubwa, bawu ke kima yawu. Bawu ke kima mutindu ba ke kimaka mbeni yina kele na mbele ya mvita. Bawu ke kubwa ata ti ba ke na kulanda bawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ata ti ba ke na kulanda bawu ve, bawu ke kwenda kubwa bawu mosi na zulu ya bampangi, mutindu ntangu ba ke kimaka na mantwala ya bambeni yina kele na bambele ya mvita. Beno ke lenda ve na kutelama na mantwala ya bambeni ya beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Beno ke manisa na kufwa na bayinsi ya nzenza. Bayinsi ya bambeni ya beno ke manisa beno. ");
INSERT INTO mkw_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Bayina na kati ya beno ke bikana na bayinsi ya bambeni ya beno, ba ke kwamuswa na kati ya masumu ya bawu. Bawu ke kwamuswa na kati ya masumu ya batata ya bawu mpe.» ");
INSERT INTO mkw_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«Na yina, bayina na kati ya beno ke bikana na bayinsi ya bambeni ya beno, bawu ke fungula masumu ya bawu na ya batata ya bawu, yimbi yina bawu salaka munu, mpe kumanga yina bawu mangaka munu. ");
INSERT INTO mkw_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Bawu ke bakula ti munu mpe mu mangaka bawu, mpe mu nataka bawu na yinsi ya bambeni ya bawu. Na yina bawu ke kuluka samu na bantima ya bawu ya yimbi. Mpe bawu ke ndima masembo ya yimbi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Na yina, mu ke bambuka moyo na Ngwisani ya munu na Yakobi, na ngwisani ya munu na Isaki, mpe na ngwisani ya munu na Abalayami. Mu ke bambukila yinsi ya bawu moyo. ");
INSERT INTO mkw_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Bawu ke bika yinsi ya bawu. Yinsi yango ke pema ntangu bawu ke vwanda ve kuna. Bawu ke futa yimbi ya bawu samu ti bawu losaka bantumunu ya munu, mpe bawu mangaka bansalulu ya misiku ya munu. ");
INSERT INTO mkw_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Kasi ntangu bawu ke vwanda na yinsi ya bambeni ya bawu, mu ke losa bawu ve. Mu ke yina bawu ve, mu ke manisa na kufwa bawu ve. Mu ke kufwa ve ngwisani ya munu na bawu. Mu kele Yave, Nzambi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Mu ke bambuka moyo na Ngwisani ya munu na bankooko ya bawu, bayina mu basisaka na yinsi ya Ngipiti, na meso ya bayinsi nyonso, samu na kuvwanda Nzambi ya bawu. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Yina ni bansalulu ya misiku, bantumunu, mpe misiku yina Yave salaka na kati ya yandi na bana ya Isayeli, kuna na mongo ya Sinayi, mpe yina yandi pesaka na Moyize. ");
INSERT INTO mkw_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yave tubaka na Moyize ");
INSERT INTO mkw_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","na kuzabisa na bana ya Isayeli mutindu yayi: «Kana muntu me sala nsilulu ya kupesa muntu na Yave, muntu yina me sala nsilulu yango lenda futa mbongo samu na kulungisa nsilulu yina. Yandi ke futa ntalu yina ba zengaka na yina me tadila kupesa muntu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ya kele mutindu yayi: «Samu na muntu ya bakala ya bamvula makumi zole tii makumi sambanu, lutangu ya mbongo kele Basekele makumi tanu ya palata, mutindu ba ke tezilaka na Yinzo ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Kana ya ke kento, ntalu ya mbongo kele Basekele makumi tatu ya palata.» ");
INSERT INTO mkw_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","«Samu na bana yina ke na bamvula kubanda na bamvula tanu tii na bamvula makumi zole, ntalu kele Basekele makumi zole ya palata samu na mwana ya bakala, Basekele kumi ya palata samu na mwana ya kento.» ");
INSERT INTO mkw_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","«Samu na bana yina ke na bamvula kubanda na ngonda mosi tii na bamvula tanu, ntalu kele Basekele tanu ya palata samu na mwana ya bakala, Basekele tatu ya palata samu na mwana ya kento.» ");
INSERT INTO mkw_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","«Samu na muntu yina ke na bamvula kubanda na makumi sambanu tii na zulu, ntalu kele Basekele kumi na tanu ya palata samu na bakala, Basekele kumi ya palata samu na kento.» ");
INSERT INTO mkw_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","«Kana muntu yina me sala nsilulu me lutila bumputu samu na kuzwa mbongo yina, yandi ke nata muntu yina yandi me sadila nsilulu na sika ya nganga-Nzambi. Nganga-Nzambi ke zengila yandi ntalu mutindu kele lubaku ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«Kana nsilulu yina muntu me sala, ya me tadila kibulu yina ba lenda pesa mutindu Munkayulu na Yave, kibulu yango yina yandi ke pesa na Yave ke kuma ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Yandi lenda kusoba yawu ve. Yandi lenda kuyingisa yawu na kibulu ya nkaka ve, kibulu ya yimbi na kisika ya kibulu ya mbote, to kibulu ya mbote na kisika ya kibulu ya yimbi. Kana yandi sala mutindu yina, bibulu nyonso zole ke kuma ya longo.» ");
INSERT INTO mkw_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","«Kana nsilulu yina muntu me sala, ya me tadila kibulu ya Kuvedila ve yina ba lenda pesa ve mutindu munkayulu na Yave, yandi fwana kunata kibulu yango na mantwala ya nganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Nganga-Nzambi ke zenga ntalu ya kibulu yango. Yandi ke tala mutindu kele kibulu yango, kana yawu kele ya mbote to ya yimbi. Ba ke landa ntalu yina nganga-Nzambi ke zenga. ");
INSERT INTO mkw_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kana muntu ya yawu zola kuula yawu, yandi ke bwela kibuku ya tanu ya ntalu yina ba zengaka.» ");
INSERT INTO mkw_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«Kana muntu me pesa yinzo ya yandi na Yave, nganga-Nzambi ke zenga ntalu ya yinzo yango. Yandi ke tala mutindu kele yinzo yango, kana yawu kele ya mbote to ya yimbi. Ba ke landa ntalu yina nganga-Nzambi ke zenga. ");
INSERT INTO mkw_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kana muntu ya yinzo zola kukuula yawu, yandi ke bwela na zulu ya ntalu yina nganga-Nzambi ke zenga, kikunku mosi na kati ya bikunku tanu ya ntalu yango. Mpe yinzo yango ke kuma dyaka ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«Kana muntu me pesa ndambu ya bilanga ya yandi na Yave mutindu munkayulu, ba ke zenga ntalu ya yawu mutindu kele bima yina ba ke kuna na bilanga yango. Ya ke vwanda Basekele makumi tanu ya palata samu na Omele mosi ya bambuma ya oloze. ");
INSERT INTO mkw_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kana muntu me pesa bilanga yango kaka na Mvula ya Kuyangalala, ntalu ya yawu ke vwanda kaka mutindu ya kele. ");
INSERT INTO mkw_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Kana yandi me pesa yawu na manima ya Mvula ya Kuyangalala, nganga-Nzambi ke kulula ntalu ya yawu. Yandi ke tala bamvula yikwa me bikana na kukuma na Mvula ya Kuyangalala yina ke kwiza.» ");
INSERT INTO mkw_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","«Kana muntu yina me pesa bilanga yango zola kukuula yawu, yandi ke bwela na zulu ya ntalu yina nganga-Nzambi ke zenga kikunku mosi na kati ya bikunku tanu ya ntalu yango. Na manima, bilanga yango ke kuma dyaka ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","«Kana yandi kuula ve bilanga yango, kasi ba tekisa yawu na muntu ya nkaka, yandi mosi yandi lenda kuula dyaka yawu ve. ");
INSERT INTO mkw_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Na yina, na Mvula ya Kuyangalala, bilanga yango ke kuma kima ya longo, mpe yawu ke vwanda ya mankululu kima ya Yave. Yawu ke kuma mvwilu ya nganga-Nzambi.» ");
INSERT INTO mkw_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«Kana muntu me pesa na Yave bilanga yina yandi kuzwaka ve mutindu difwa, kasi yandi mosi sumbaka yawu, ");
INSERT INTO mkw_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","nganga-Nzambi ke zenga ntalu ya bilanga yina mutindu kele lutangu ya bamvula yina me bikana na kukuma na Mvula ya Kuyangalala yina ke kwiza. Muntu ya bilanga yango ke futa, kaka na kilumbu yina, ntalu yina ba me zenga. Mbongo yango ke vwanda ya longo samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Na Mvula ya Kuyangalala, bilanga yango ke vutuka na muntu yina tekisaka yawu, yina kuzwaka yawu mutindu difwa.» ");
INSERT INTO mkw_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","«Bantalu nyonso, ba ke zenga yawu mutindu ba ke tezilaka na Yinzo ya longo. Sekele mosi kele Bangela makumi zole.» ");
INSERT INTO mkw_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«Muntu lenda pesa ve na Yave mwana ya ntete ya kibulu, samu ti yawu kele ya ngana ya Yave. Ya vwanda ngombe, to nkombo, to dimeme. Bana yango ya ntete ke vwandaka ya Yave. ");
INSERT INTO mkw_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kana ya ke mwana ya kibulu ya Kuvedila ve, muntu ya yawu lenda kuula yawu na ntalu yina nganga-Nzambi zengaka. Mpe yandi ke bwela na zulu ya ntalu yina kikunku mosi na kati ya bikunku tanu ya ntalu yango. Kana yandi kuula yawu ve, ba ke tekisa yawu na ntalu yina nganga-Nzambi zengaka.» ");
INSERT INTO mkw_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«Kima ni kima yina muntu me pesa ya mankululu na Yave, ba lenda tekisa to kukuula dyaka yawu ve. Ya vwanda muntu, ya vwanda kibulu, ya vwanda bilanga ya yandi. Bima nyonso yina ba me pesa ya mankululu na Yave, ya me kuma ya longo mingi samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Muntu yina ba me pesa ya mankululu na Yave, ba lenda kuula yandi ve. Ba fwana kufwa yandi.» ");
INSERT INTO mkw_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«Badime nyonso ya bima ya bilanga, ya vwanda bambuma ya ntoto, ya vwanda bambuma ya bayinti, ya ke ya Yave. Ya ke bima ya longo samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kana muntu zola kukuula mwa ndambu ya dime ya yandi, yandi ke bwela na zulu ya ntalu yina nganga-Nzambi zengaka kikunku mosi na kati ya bikunku tanu ya ntalu ya mwa ndambu ya kikunku mosi na kati ya kumi ya yandi. ");
INSERT INTO mkw_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Na yina me tadila bangombe, na mameme, na bankombo, muntu ya yawu ke lutisa bibulu ya yandi na mulonga. Yandi ke tuula dime. Yawu ke vwanda ya Yave. Yawu ke kituka ya longo. ");
INSERT INTO mkw_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Yandi ke sosa ve na kuzaba kana kibulu yango ke ya mbote to ya yimbi. Yandi lenda yingisa ve kibulu mosi na kisika ya kibulu ya nkaka. Kana yandi yingisa kibulu na kibulu ya nkaka, bibulu nyonso zole ke vwanda ya longo. Ba lenda kuula ata mosi na nyonso zole ve.» ");
INSERT INTO mkw_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Yina ni bantumunu yina Yave pesaka na Moyize samu na bana ya Isayeli, kuna na mongo ya Sinayi.");
INSERT INTO mkw_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Na kilumbu ya ntete ya ngonda ya zole, na mvula ya zole, na manima ya kubasika ya bantu ya Isayeli na yinsi ya Ngipiti, kuna na yinsi ya kuyuma ya Sinayi, Yave zonzaka na Moyize, na Yinzo ya Mbwabanu. Yandi tubaka mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Beno sala lutangusu ya mukangu nyonso ya bana ya Isayeli mutindu kele bifumba ya bawu mpe mutindu kele makanda ya bawu. Beno sonika bankumbu ya babakala nyonso mosi-mosi. ");
INSERT INTO mkw_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Nge na Aloni, beno sala lutangusu ya babakala nyonso yina lenda vwanda binwani, bayina kele na bamvula kubanda makumi zole tii na zulu. Beno tanga bawu na kati ya konso nkonga ya binwani ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Beno ke vwanda na mfumu mosi-mosi ya konso dikanda. ");
INSERT INTO mkw_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Bankumbu ya bantu yina ke vwanda na beno ni yayi: samu na kifumba ya Lubene: Elisule, mwana ya Sedewule. ");
INSERT INTO mkw_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Samu na kifumba ya Simewone: Selumyele, mwana ya Sulisadayi. ");
INSERT INTO mkw_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Samu na kifumba ya Yuda: Nasone, mwana ya Aminadabe. ");
INSERT INTO mkw_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Samu na kifumba ya Isakale: Netanele, mwana ya Suwale. ");
INSERT INTO mkw_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Samu na kifumba ya Zabulone: Elyabe, mwana ya Elone. ");
INSERT INTO mkw_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Samu na bana ya Yosefi: Elisama, mwana ya Amiwude samu na kifumba ya Efalayime, Ngamelyele mwana ya Pedasule samu na kifumba ya Manase. ");
INSERT INTO mkw_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Samu na kifumba ya Bezame: Abidane, mwana ya Ngidewoni. ");
INSERT INTO mkw_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Samu na kifumba ya Dane: Ayezele, mwana ya Amisadayi. ");
INSERT INTO mkw_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Samu na kifumba ya Asele: Pangyele, mwana ya Okelane. ");
INSERT INTO mkw_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Samu na kifumba ya Ngade: Elyasafe, mwana ya Dewele. ");
INSERT INTO mkw_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Samu na kifumba ya Nafetali: Ayila, mwana ya Enane.» ");
INSERT INTO mkw_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ni bawu bantu yina ba bokilaka na kati ya mukangu ya bantu ya Isayeli. Ni bawu vwandaka bamfumu ya bifumba ya bawu. Ni bawu vwandaka mpe bamfumu ya bankonga ya binwani ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moyize na Aloni vukanaka na bantu yina ba bakaka bankumbu. ");
INSERT INTO mkw_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Na kilumbu ya ntete ya ngonda ya zole, bawu kutikisaka mukangu nyonso. Bawu sonikisaka bankumbu ya babakala nyonso ya Isayeli, bayina vwandaka na bamvula kubanda na makumi zole tii na zulu. Bawu salaka yawu mutindu kele mbutukulu ya bawu, dikanda mosi-mosi mpe kivumu mosi-mosi. ");
INSERT INTO mkw_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Moyize salaka bawu lutangusu kuna na yinsi ya kuyuma ya Sinayi. Yandi salaka yawu mutindu Yave tumisaka yandi yawu. ");
INSERT INTO mkw_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Na yina me tadila lutangusu ya bana ya Lubene, mwana ya ntete ya Isayeli, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Bantu yina ba tangaka na kifumba ya Lubene vwandaka mafunda makumi yiya na sambanu, na bankama tanu (46 500). ");
INSERT INTO mkw_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Na yina me tadila lutangusu ya bana ya Simewone, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Bantu yina ba tangaka na kifumba ya Simewone vwandaka mafunda makumi tanu na yivwa, na bankama tatu (59 300). ");
INSERT INTO mkw_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Na yina me tadila lutangusu ya bana ya Ngade, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Bantu yina ba tangaka na kifumba ya Ngade vwandaka mafunda makumi yiya na tanu na bankama sambanu, na makumi tanu (45 650). ");
INSERT INTO mkw_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Na yina me tadila lutangusu ya bana ya Yuda, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Bantu yina ba tangaka na kifumba ya Yuda vwandaka mafunda makumi nsambwadi na yiya, na bankama sambanu (74 600). ");
INSERT INTO mkw_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Na yina me tadila lutangusu ya bana ya Isakale, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Bantu yina ba tangaka na kifumba ya Isakale vwandaka mafunda makumi tanu na yiya na bankama yiya (54 400). ");
INSERT INTO mkw_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Na yina me tadila lutangusu ya bana ya Zabulone, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Bantu yina ba tangaka na kifumba ya Zabulone vwandaka mafunda makumi tanu na nsambwadi na bankama yiya (57 400). ");
INSERT INTO mkw_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Na yina me tadila lutangusu ya bana ya Yosefi, mwana ya Efalayime, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Bantu yina ba tangaka na kifumba ya Efalayime vwandaka mafunda makumi yiya na bankama tanu (40 500). ");
INSERT INTO mkw_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Na yina me tadila lutangusu ya bana ya Manase, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Bantu yina ba tangaka na kifumba ya Manase vwandaka mafunda makumi tatu na zole, na bankama zole (32 200). ");
INSERT INTO mkw_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Na yina me tadila lutangusu ya bana ya Bezame, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Bantu yina ba tangaka na kifumba ya Bezame vwandaka mafunda makumi tatu na tanu, na bankama yiya (35 400). ");
INSERT INTO mkw_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Na yina me tadila lutangusu ya bana ya Dane, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Bantu yina ba tangaka na kifumba ya Dane vwandaka mafunda makumi sambanu na zole, na bankama nsambwadi (62 700). ");
INSERT INTO mkw_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Na yina me tadila lutangusu ya bana ya Asele, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Bantu yina ba tangaka na kifumba ya Asele vwandaka mafunda makumi yiya na mosi na bankama tanu (41 500). ");
INSERT INTO mkw_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Na yina me tadila lutangusu ya bana ya Nafetali, ba tangaka dikanda mosi-mosi mpe kivumu mosi-mosi mutindu kele mbutukulu ya bawu. Ba tangaka bankumbu ya babakala ya bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani. ");
INSERT INTO mkw_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Bantu yina ba tangaka na kifumba ya Nafetali vwandaka mafunda makumi tanu na tatu na bankama yiya (53 400). ");
INSERT INTO mkw_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Yina ni bayina ba tangaka na lutangusu yina salaka Moyize na Aloni kintwadi na babakala kumi na zole, bamfumu ya bifumba ya Isayeli. Ya vwandaka muntu mosi-mosi samu na konso kifumba. ");
INSERT INTO mkw_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Bayina nyonso ba tangaka na kati na bana ya Isayeli na konso dikanda, bayina vwandaka na bamvula kubanda na makumi zole tii na zulu, bayina lendaka vwanda binwani, ");
INSERT INTO mkw_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","bawu vwandaka mafunda bankama sambanu na tatu, na bankama tanu na makumi tanu (603 550). ");
INSERT INTO mkw_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ba salaka ve lutangusu ya kifumba ya ba-Levi mutindu yawu salamaka samu na bifumba ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Samu ti Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Kusala ve lutangusu ya kifumba ya ba-Levi. Kutanga ve bawu kintwadi na bana ya nkaka ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Pesa bawu kisalu ya Yinzo ya Ngwisani, na bisalulu ya yawu nyonso, mpe bima nyonso ya yawu. Ni bawu ke banda na kunataka Yinzo ya Mbwabanu mpe bisalulu ya yawu nyonso. Bawu ke banda na kusalaka kuna mpe na kuzingaka pene-pene na yawu, na balweka nyonso. ");
INSERT INTO mkw_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Na ntangu ya kukwenda, ba-Levi ke katula Yinzo ya Mbwabanu samu na kunata yawu na kivwandu ya nkaka, kisika yina ba ke kwenda tula dyaka yawu. Muntu yina kele ve muntu ya dikanda ya Levi, kana yandi belama na Yinzo yina, ba ke kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Bana ya Isayeli ke zinga konso bantu na kivwandu ya bawu, mutindu kele bankonga ya binwani ya bawu, pene-pene ya kidimbu ya yinsi ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ba-Levi ke zinga pene-pene na Yinzo ya Ngwisani, na balweka nyonso. Na yina, nkele ya munu Nzambi ke bwidila ve mukangu ya bana ya Isayeli. Kiyeko ya Yinzo ya Ngwisani mpe lukengolo ya yawu kele na maboko ya ba-Levi.» ");
INSERT INTO mkw_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Bana ya Isayeli salaka nyonso mutindu Yave tumisaka yawu na Moyize. Bawu salaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yave tubaka na Moyize mpe Aloni mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Bana ya Isayeli ke sala kivwandu ya bawu konso bantu pene-pene ya kidimbu ya nkonga ya yandi ya binwani, na kidimbu ya dikanda ya yandi. Bawu ke sala kivwandu ya bawu ya kutalasana na Yinzo ya Mbwabanu, mpe na balweka nyonso ya yawu. ");
INSERT INTO mkw_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Bayina ke vwanda na lweka ya esete, bawu ke vwanda pene-pene ya kidimbu ya kivwandu ya bantu ya Yuda. Bawu ke vwandila mutindu kele bankonga ya binwani ya bawu. Mfumu ya bana ya Yuda ni Nasone, mwana ya Aminadabe. ");
INSERT INTO mkw_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Nkonga nyonso ya binwani ya Yuda yina ba tangaka kele mafunda makumi nsambwadi na yiya, na bankama sambanu (74 600) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Kifumba ya Isakale ke sala kivwandu ya bawu pene-pene ya bantu ya Yuda. Mfumu ya bana ya Isakale ni Netanele, mwana ya Suwale. ");
INSERT INTO mkw_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Nkonga nyonso ya binwani ya Isakale yina ba tangaka kele mafunda makumi tanu na yiya na bankama yiya (54 400) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Yina ke landa, ni kifumba ya Zabulone. Mfumu ya bana ya Zabulone ni Elyabe, mwana ya Elone. ");
INSERT INTO mkw_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Nkonga nyonso ya binwani ya Zabulone yina ba tangaka kele mafunda makumi tanu na nsambwadi, na bankama yiya (57 400) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Babakala nyonso ya kivwandu ya Yuda yina ba tangaka kele mafunda nkama mosi na makumi nana na sambanu na bankama yiya (186 400), mutindu kele bankonga ya bawu ya binwani. Ni bawu ke vwanda mukangu ya ntete na kukwenda. ");
INSERT INTO mkw_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Bayina ke vwanda na lweka ya sude, bawu ke vwanda pene-pene ya kidimbu ya bantu ya kivwandu ya Lubene. Bawu ke vwandila mutindu kele bankonga ya binwani ya bawu. Mfumu ya bana ya Lubene ni Elisule, mwana ya Sedewule. ");
INSERT INTO mkw_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Nkonga nyonso ya binwani ya Lubene yina ba tangaka kele mafunda makumi yiya na sambanu na bankama tanu (46 500) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Bantu ya kifumba ya Simewone ke sala kivwandu ya bawu pene-pene ya bantu ya Lubene. Mfumu ya bana ya Simewone ni Selumyele, mwana ya Sulisadayi. ");
INSERT INTO mkw_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Nkonga nyonso ya binwani ya Simewone yina ba tangaka kele mafunda makumi tanu na yivwa na bankama tatu (59 300) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Yina ke landa, ni kifumba ya Ngade. Mfumu ya bana ya Ngade ni Elyasafe, mwana ya Dewele. ");
INSERT INTO mkw_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Nkonga nyonso ya binwani ya Ngade yina ba tangaka kele mafunda makumi yiya na tanu na bankama sambanu na makumi tanu (45 650) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Babakala nyonso ya kivwandu ya Lubene yina ba tangaka kele nkama mosi na makumi tanu na mosi ya mafunda na bankama yiya na makumi tanu (151 450), mutindu kele bankonga ya bawu ya binwani. Ni bawu ke vwanda mukangu ya zole na kukwenda. ");
INSERT INTO mkw_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Na manima, ba-Levi ke baka Yinzo ya Mbwabanu na kukwenda na yawu. Ba ke vwanda na kati-kati ya bifumba ya nkaka. Bantu ke kwendila mutindu kele ndandanu ya bivwandu ya bawu. Bawu ke landasana mutindu ke vwandila bidimbu ya bankonga ya binwani ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Bayina ke vwanda na lweka ya wesete, bawu ke vwanda pene-pene ya kidimbu ya bantu ya kivwandu ya Efalayime. Bawu ke vwandila mutindu kele bankonga ya binwani ya bawu. Mfumu ya bantu ya Efalayime ni Elisama, mwana ya Amiwude. ");
INSERT INTO mkw_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Nkonga nyonso ya binwani ya Efalayime yina ba tangaka kele mafunda makumi yiya na bankama tanu (40 500) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Pene-pene ya bawu ke vwanda kifumba ya Manase. Mfumu ya bana ya Manase ni Ngamelyele, mwana ya Pedasule. ");
INSERT INTO mkw_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Nkonga ya binwani ya Manase yina ba tangaka kele mafunda makumi tatu na zole na bankama zole (32 200) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Yina ke landa, ni kifumba ya Bezame. Mfumu ya bana ya Bezame ni Abidane, mwana ya Ngidewoni. ");
INSERT INTO mkw_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Nkonga ya binwani ya Bezame yina ba tangaka kele mafunda makumi tatu na tanu na bankama yiya (35 400) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Babakala nyonso ya kivwandu ya Efalayime yina ba tangaka kele mafunda nkama mosi na nana, na nkama mosi (108 100), mutindu kele bankonga ya bawu ya binwani. Ni bawu ke vwanda mukangu ya tatu na kukwenda. ");
INSERT INTO mkw_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Bayina ke vwanda na lweka ya node, bawu ke vwanda pene-pene ya kidimbu ya kivwandu ya bantu ya Dane. Bawu ke vwandila mutindu kele bankonga ya binwani ya bawu. Mfumu ya bana ya Dane ni Ayezele, mwana ya Amisadayi. ");
INSERT INTO mkw_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Nkonga ya binwani ya Dane yina ba tangaka kele mafunda makumi sambanu na zole na bankama nsambwadi (62 700) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Pene-pene ya bawu ke vwanda kifumba ya Asele. Mfumu ya bana ya Asele ni Pangyele, mwana ya Okelane. ");
INSERT INTO mkw_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Nkonga ya binwani ya Asele yina ba tangaka kele mafunda makumi yiya na mosi na bankama tanu (41 500) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Yina ke landa, ni kifumba ya Nafetali. Mfumu ya bana ya Nafetali ni Ayila, mwana ya Eyinane. ");
INSERT INTO mkw_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Nkonga ya binwani ya Nafetali yina ba tangaka kele mafunda makumi tanu na tatu na bankama yiya (53 400) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Babakala nyonso ya kivwandu ya Dane yina ba tangaka kele mafunda nkama mosi na makumi tanu na nsambwadi, na bankama sambanu (157 600), mutindu kele bankonga ya bawu ya binwani. Ni bawu ke vwanda mukangu ya mansukina na kukwenda. Bawu ke kwenda mutindu ke vwandila bidimbu ya bankonga ya binwani ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Yayi ni lutangu ya bana ya Isayeli yina ba tangaka mutindu kele makanda ya bawu. Bayina nyonso ba tangaka na kati ya bivwandu, mutindu kele bankonga ya binwani ya bawu kele mafunda bankama sambanu na tatu, na bankama tanu na makumi tanu (603 550) ya babakala. ");
INSERT INTO mkw_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ba tangaka ve ba-Levi kintwadi na bana ya nkaka ya Isayeli, mutindu vwandaka ntumunu yina Yave pesaka na Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Bana ya Isayeli salaka nyonso mutindu Yave tumisaka na Moyize. Bawu salaka bivwandu ya bawu, konso bantu na kidimbu ya bawu ya yinsi. Bawu vwandaka kwenda tambula konso bantu mutindu kele bifumba ya bawu, mutindu kele makanda ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Yayi ni mukanda ya bankumbu ya bantu ya dikanda ya Moyize mpe Aloni na ntangu yina Yave zonzaka na Moyize kuna na mongo ya Sinayi. ");
INSERT INTO mkw_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Bankumbu ya bana ya Aloni ni yayi: Nadabe mwana ya ntete, Abiwu, Eleyazale mpe Itamale. ");
INSERT INTO mkw_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Yina ni bankumbu ya bana ya Aloni, banganga-Nzambi yina ba byekaka, bayina kuzwaka luve ya kukota na kisalu ya bunganga-Nzambi. ");
INSERT INTO mkw_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Kasi Nadabe mpe Abiwu kufwaka na mantwala ya Yave na yinsi ya kuyuma ya Sinayi, samu ti bawu nataka tiya ya kufwanana ve na ntadisi ya Yave. Bawu vwandaka ve na bana ya babakala. Kaka Eleyazale mpe Itamale salaka kisalu ya bunganga-Nzambi na meso ya tata ya bawu Aloni. ");
INSERT INTO mkw_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Belemisa kifumba ya Levi mpe tula bawu na lutwadusu ya nganga-Nzambi Aloni, samu ti bawu kusadisa yandi na kisalu. ");
INSERT INTO mkw_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ba ke sala kisalu samu na yandi mpe samu na mukangu nyonso ya Isayeli na mantwala ya Yinzo ya Mbwabanu. Bawu ke sala bisalu yina me tadila Yinzo. ");
INSERT INTO mkw_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Bawu ke sala bisalu yina me tadila bisalulu nyonso ya Yinzo ya Mbwabanu. Bawu ke sadila bana ya Isayeli na kusalaka bisalu yina me tadila Yinzo. ");
INSERT INTO mkw_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Na yina, nge ke pesa ba-Levi na sika ya Aloni mpe bana ya yandi. Ba-Levi ke pesama ya muvimba na yandi, na nkumbu ya bana ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Nge ke sala ti ni Aloni mpe bana ya yandi ke sala kisalu ya bunganga-Nzambi. Muntu yina kele ve muntu ya dikanda ya Levi, kana yandi belama na Yinzo, ba ke kufwa yandi.» ");
INSERT INTO mkw_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yave zonzaka na Moyize, yandi tubaka: ");
INSERT INTO mkw_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Tala, munu, mu me soola ba-Levi na kati ya bana ya Isayeli na kisika ya bana nyonso ya ntete ya babakala, bana nyonso ya Isayeli yina ke butuka ya ntete na bamama ya bawu. Ba-Levi kele ya munu. ");
INSERT INTO mkw_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Samu ti konso mwana ya ntete kele ya munu. Kilumbu yina mu salaka ti bana nyonso ya ntete ya yinsi ya Ngipiti kufwa, mu bakaka bana nyonso ya ntete ya Isayeli, ya vwanda ya bantu mpe ya bibulu ya bawu. Mu kele Yave.» ");
INSERT INTO mkw_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yave tubaka na Moyize na yinsi ya kuyuma ya Sinayi: ");
INSERT INTO mkw_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Sala lutangusu ya bana ya Levi na konso dikanda mpe na konso kivumu. Sala lutangusu ya babakala nyonso kubanda na bayina ke na ngonda mosi tii na zulu.» ");
INSERT INTO mkw_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Na yina, Moyize salaka lutangusu ya ba-Levi mutindu Yave tumisaka yandi yawu. ");
INSERT INTO mkw_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Bana ya Levi ni yayi: Ngelesone, Keyate mpe Melali. ");
INSERT INTO mkw_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Bana ya Ngelesone mutindu kele makanda ya bawu ni yayi: Libeni na Simeyi. ");
INSERT INTO mkw_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Bana ya Keyate mutindu kele makanda ya bawu ni yayi: Amelame, Isale, Ebelone mpe Uzyele. ");
INSERT INTO mkw_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Bana ya Melali mutindu kele makanda ya bawu ni yayi: Mayeli mpe Musi. Yina ni makanda ya ba-Levi mutindu kele bivumu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ngelesone vwandaka nkooko ya ba-Libeni mpe ya ba-Simeyi. Yina ni makanda ya ba-Ngelesone. ");
INSERT INTO mkw_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Bantu yina ba tangaka na kati ya ba-Ngelesone nyonso vwandaka mafunda nsambwadi na bankama tanu (7 500) ya babakala kubanda na bayina vwandaka na ngonda mosi tii na zulu. ");
INSERT INTO mkw_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Makanda ya ba-Ngelesone salaka kivwandu ya bawu na manima ya Yinzo, na lweka ya wesete. ");
INSERT INTO mkw_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Mfumu ya dikanda ya ba-Ngelesone ni Elyasafe, mwana ya Layele. ");
INSERT INTO mkw_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Na yina me tadila Yinzo ya Mbwabanu, bana ya Ngelesone vwandaka na kiyeko ya Yinzo: lele yina ke fukaka muludi ya Yinzo, lele ya mwelo ya Yinzo ya Mbwabanu, ");
INSERT INTO mkw_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","balele ya bibaka ya lupangu, lele ya mwelo ya lupangu, balweka nyonso ya ngaanda ya Yinzo, balweka nyonso ya kiyokolo ya minkayulu, basinga nyonso, mpe kiyeko ya kutelemisaka mpe kukatulaka Yinzo yango. ");
INSERT INTO mkw_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Keyate vwandaka nkooko ya ba-Amelame, ya ba-Isale, ba-Ebelone mpe ya ba-Uzyele. Yina ni makanda ya ba-Keyate. ");
INSERT INTO mkw_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Lutangu ya babakala nyonso salaka mafunda nana na bankama sambanu (8 600) kubanda na bayina vwandaka na ngonda mosi tii na zulu. Ni bawu kuzwaka kiyeko ya Yinzo ya longo. ");
INSERT INTO mkw_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Makanda ya ba-Keyate salaka kivwandu ya bawu na lweka sude ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Mfumu ya makanda ya ba-Keyate ni Elisafane, mwana ya Uzyele. ");
INSERT INTO mkw_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Bawu vwandaka na kiyeko ya: sanduku, mesa, kitentokolo ya minda, biyokolo, bisalulu yina ba ke sadilaka na Yinzo, lele ya kati-kati mpe kiyeko ya kutulaka mpe kukatulaka bima yina. ");
INSERT INTO mkw_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Mfumu ya ntete ya ba-Levi ni Eleyazale, mwana ya nganga-Nzambi Aloni. Kisalu ya yandi ni kutwadisa bantu yina vwandaka na kiyeko ya Yinzo ya longo. ");
INSERT INTO mkw_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Melali vwandaka nkooko ya ba-Maali mpe ya ba-Musi. Yina ni makanda ya ba-Melali. ");
INSERT INTO mkw_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Bantu yina ba tangaka na kati ya ba-Melali nyonso vwandaka mafunda sambanu na bankama zole (6 200) ya babakala, kubanda na bayina vwandaka na ngonda mosi tii na zulu. ");
INSERT INTO mkw_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mfumu ya makanda ya ba-Melali ni Sulyele, mwana ya Abiyayile. Bawu salaka kivwandu ya bawu na lweka ya node ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Bana ya Melali kuzwaka kiyeko ya: mabaya ya Yinzo, bayinti ya yawu, makunzi ya yawu, bisimbulu ya yawu ya yisi, bisalulu nyonso ya yawu. Bawu vwandaka mpe na kiyeko ya kutulaka mpe kukatulaka bima nyonso yina. ");
INSERT INTO mkw_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Ba vwandaka mpe na kiyeko ya: makunzi yina ke zungidilaka lupangu nyonso, bisimbulu ya yawu ya yisi, binko ya yawu mpe basinga ya yawu. ");
INSERT INTO mkw_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moyize, Aloni mpe bana ya yandi salaka kivwandu ya bawu na lweka ya esete, na mantwala ya Yinzo ya Mbwabanu. Ba vwandaka na kiyeko ya kisalu ya bunganga-Nzambi na nkumbu ya bana ya Isayeli. Muntu yina kele ve nganga-Nzambi, kana yandi belama na Yinzo, ba ke kufwa yandi. ");
INSERT INTO mkw_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lutangu ya ba-Levi yina Moyize na Aloni tangaka mutindu vwandaka ntumunu ya Yave, vwandaka mafunda makumi zole na zole (22 000) ya babakala kubanda na bayina vwandaka na ngonda mosi tii na zulu. Ba salaka lutangusu yina mutindu kele makanda ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yave tubaka na Moyize: «Sala lutangusu ya bana nyonso ya ntete ya babakala ya bana ya Isayeli, kubanda na bayina ke na ngonda mosi tii na zulu. Sonika bankumbu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Na manima, tula na lweka ba-Levi samu ti ba kuvwanda ya munu, munu Yave, na kisika ya bana nyonso ya ntete ya bana ya Isayeli. Tula mpe na lweka samu na munu bibulu ya ba-Levi na kisika ya bibulu nyonso ya ntete ya bana ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moyize salaka lutangusu ya bana nyonso ya ntete ya bana ya Isayeli mutindu Yave tumisaka yandi yawu. ");
INSERT INTO mkw_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Lutangu ya bana nyonso ya ntete ya babakala yina ba tangaka mpe sonikaka bankumbu, yawu salaka mafunda makumi zole na zole na bankama zole na makumi nsambwadi na tatu (22 273) ya babakala, kubanda na bayina vwandaka na ngonda mosi tii na zulu. ");
INSERT INTO mkw_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Baka ba-Levi na kisika ya bana nyonso ya ntete ya babakala na kati ya bana ya Isayeli. Baka mpe bibulu ya ba-Levi na kisika ya bibulu ya bawu. Ba-Levi kele ya munu. Mu kele Yave. ");
INSERT INTO mkw_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Lutangu ya bana ya ntete ya bana ya Isayeli me lutila lutangu ya ba-Levi na bankama zole na makumi nsambwadi na tatu (273). Na kukuula bawu yina, ");
INSERT INTO mkw_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","nge ke futa Basekele tanu samu na konso muntu. Mbongo yango, ba ke teza yawu mutindu ba ke tezilaka na kitezolo ya Yinzo ya longo, yawu kele ya Bangela makumi zole. ");
INSERT INTO mkw_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Nge ke pesa mbongo yina na Aloni mpe na bana ya yandi samu na kukuula bana ya ntete yina vwandaka na zulu ya lutangu ya ba-Levi.» ");
INSERT INTO mkw_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moyize bakaka mbongo ya nkudulu na maboko ya bayina vwandaka na zulu ya lutangu ya ba-Levi. ");
INSERT INTO mkw_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Mbongo yina yandi bakaka na maboko ya bana ya ntete ya bana ya Isayeli vwandaka Basekele funda mosi na bankama tatu na makumi sambanu na tanu (1 365) ya palata, mutindu vwandaka Sekele yina ba ke sadilaka na Yinzo ya longo. ");
INSERT INTO mkw_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Na ntumunu ya Yave, Moyize pesaka mbongo ya nkudulu na Aloni mpe na bana ya Aloni mutindu Yave tumisaka yandi yawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yave zonzaka na Moyize mpe na Aloni, yandi tubaka: ");
INSERT INTO mkw_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Sala lutangusu ya bana ya Keyate na kati ya bana ya Levi. Sala yawu dikanda mosi-mosi mpe kivumu mosi-mosi, ");
INSERT INTO mkw_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","kubanda na bayina ke na bamvula makumi tatu tii na makumi tanu. Tanga bayina nyonso lenda sala na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Kisalu ya bana ya Keyate na kati ya Yinzo ya Mbwabanu ni yayi: bawu ke na kiyeko ya bima ya kulutila longo. ");
INSERT INTO mkw_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ntangu bantu ya Isayeli ke telama na kukwenda, Aloni na bana ya yandi ke kwiza katula lele yina ke kabulaka kisika ya kulutila longo na kisika ya longo. Na lele yina, bawu ke fuka Sanduku ya Ngwisani. ");
INSERT INTO mkw_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Na zulu ya yawu, bawu ke tula bampusu ya mbisi ya nene ya mubu, mpe na zulu ya yawu, bawu ke yalumuna lele ya ntinta ya dizulu. Mpe ba ke tula bayinti yina ba ke nanguninaka sanduku. ");
INSERT INTO mkw_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Bawu ke yalumuna lele ya ntinta ya dizulu na zulu ya mesa ya mampa ya longo, mpe na zulu ya yawu, bawu ke tula bandonga, bakopo, bandonga ya fyoti, bambungu samu na minkayulu ya vinu. Ba ke tula mpe mampa yina ba fwana kupesaka munu bantangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Na zulu ya nyonso yina, ba ke yalumuna lele ya mbwaki ya kulutila mpe ba ke fuka nyonso na bampusu ya mbisi ya nene ya mubu. Mpe ba ke tula bayinti ya kunanguninaka mesa. ");
INSERT INTO mkw_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Bawu ke baka lele ya ntinta ya dizulu mpe bawu ke fuka kitentokolo ya minda, minda ya yawu, bima ya bombi ya yawu mpe mwa bandonga ya yawu ya mafuta yina ba ke sadilaka. ");
INSERT INTO mkw_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Bawu ke fuka yawu na bisalulu ya yawu nyonso na bampusu ya mbisi ya nene ya mubu. Na manima, ba ke tula yawu na zulu ya kipoyi. ");
INSERT INTO mkw_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Bawu ke yalumuna lele ya ntinta ya dizulu na zulu ya mesa ya wolo, kisika ba ke yokilaka maaka ya nsunga ya mbote. Ba ke fuka yawu na bampusu ya mbisi ya nene ya mubu. Mpe ba ke tula bayinti ya kunanguninaka yawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ba ke baka bisalulu nyonso yina ba ke sadilaka na kati ya Yinzo ya longo, ba ke tula yawu na lele ya ntinta ya dizulu mpe ba ke fuka yawu na bampusu ya mbisi ya nene ya mubu. Na manima, ba ke tula yawu na zulu ya kipoyi. ");
INSERT INTO mkw_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ba ke katula bombi ya mafuta ya kiyokolo ya minkayulu, mpe ba ke yalumuna lele ya ntinta ya dizulu na zulu ya kiyokolo. ");
INSERT INTO mkw_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Na zulu ya lele yina, ba ke tula bisalulu yina ba ke sadilaka kisalu ya longo: bima ya kuyokilaka maaka ya nsunga ya mbote, misoma, bapele, mwa bambungu ya kutudilaka bombi na mafuta, bisalulu nyonso ya kiyokolo ya minkayulu. Na zulu ya bima yina, ba ke fuka bampusu ya mbisi ya nene ya mubu. Mpe ba ke tula bayinti ya kunanguninaka kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ntangu Aloni na bana ya yandi ke manisa na kufuka Yinzo ya longo mpe bisalulu nyonso ya Yinzo ya longo, bana ya Keyate ke kwiza baka bima yina samu na kunata yawu. Kasi bawu ke simba ve Yinzo ya longo, samu ti kana ba simba yawu, ba lenda kufwa. Yina ni kisalu ya bana ya Keyate na Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleyazale, mwana ya nganga-Nzambi Aloni ke vwanda na kiyeko ya: mafuta samu na minda, maaka ya nsunga ya mbote, munkayulu ya konso ntangu ya madya ya bilanga mpe mafuta ya mbyekolo. Eleyazale ke vwanda na kiyeko ya Yinzo nyonso ya longo na bima ya yawu nyonso, bima ya longo na bisalulu ya yawu.» ");
INSERT INTO mkw_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yave tubaka dyaka na Moyize mpe na Aloni mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Beno katula ve makanda ya ba-Keyate na kati ya ba-Levi. ");
INSERT INTO mkw_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Beno sala mutindu yayi samu na bawu, samu ti bawu kufwa ve na ntangu ba ke belama na bima ya kulutila longo. Aloni na bana ya yandi ke kwiza tula bawu muntu-muntu na kisalu ya yandi, mpe yandi ke pesa muntu-muntu kiyeko ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Na yina, ba ke kwiza tala ata fyoti ve bima ya longo, kana ve, ya ke vwanda lufwa ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Sala mpe lutangusu ya bana ya Ngelesone mutindu kele makanda ya bawu mpe bivumu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Tanga bawu kubanda na bayina ke na bamvula makumi tatu tii na bayina ke na bamvula makumi tanu. Tanga bayina nyonso lenda sala kisalu na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Kisalu yina makanda ya ba-Ngelesone ke sala, kiyeko ya bawu ni yayi: ");
INSERT INTO mkw_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ba ke nata lele yina ke fukaka kivinga ya kulutila longo mpe kivinga ya longo. Ba ke baka mpe lele ya bampusu ya mameme ya mbakala mpe lele ya bampusu ya mbisi ya nene ya mubu, yina ke fukaka nyonso. Ba ke baka mpe lele yina kele na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Balele ya lupangu mpe lele ya mwelo ya lupangu, balele yina ke zungidilaka Yinzo ya longo mpe kiyokolo ya minkayulu, basinga ya yawu mpe bisalulu ya yawu nyonso. Bawu ke sala bisalu nyonso yina me tadila bima yina. ");
INSERT INTO mkw_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Bantu ya Ngelesone ke sala bisalu ya bawu nyonso na lutwadusu ya Aloni mpe ya bana ya yandi, na yina me tadila kiyeko ya kunata bima mpe ya kusala bisalu ya bawu. Beno ke zabisa bawu bima yina ba fwana kunata. ");
INSERT INTO mkw_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Yina ni bisalu ya makanda ya ba-Ngelesone kuna na Yinzo ya Mbwabanu. Bawu ke sala bisalu ya bawu na lutwadusu ya Itamale, mwana ya nganga-Nzambi Aloni.» ");
INSERT INTO mkw_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Sala lutangusu ya bana ya Melali mutindu kele makanda ya bawu mpe bivumu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Tanga bawu kubanda na bayina ke na bamvula makumi tatu tii na bayina ke na bamvula makumi tanu. Tanga bayina nyonso lenda sala kisalu na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Kiyeko ya bawu ya kunata bima mpe ya kusala bisalu ya bawu na Yinzo ya Mbwabanu ni yayi: mabaya ya Yinzo, bayinti ya yawu, makunzi ya Yinzo, bisimbulu ya yisi ya makunzi, ");
INSERT INTO mkw_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","makunzi yina ke zungidilaka lupangu, bisimbulu ya yawu ya yisi, binko, basinga ya yawu, bisalulu ya yawu nyonso, mpe bima nyonso yina ba ke sadilaka samu na yawu. Beno ke zabisa bawu bankumbu ya bima yina ba fwana kunata. ");
INSERT INTO mkw_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Yina ni bisalu ya makanda ya ba-Melali kuna na Yinzo ya Mbwabanu. Bawu ke sala bisalu ya bawu na lutwadusu ya Itamale, mwana ya nganga-Nzambi Aloni.» ");
INSERT INTO mkw_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moyize, Aloni na bamfumu ya mukangu salaka lutangusu ya ba-Keyate. Ba salaka yawu dikanda mosi-mosi mpe kivumu mosi-mosi. ");
INSERT INTO mkw_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ba tangaka bawu kubanda na bayina ke na bamvula makumi tatu tii na bayina ke na bamvula makumi tanu. Bayina nyonso lenda sala kisalu na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Bantu yina ba tangaka na kati ya ba-Keyate nyonso vwandaka mafunda zole na bankama nsambwadi na makumi tanu (2 750) ya babakala, mutindu kele makanda ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Yina ni lutangu ya bantu ya makanda ya Keyate, bayina vwandaka sala bisalu na Yinzo ya Mbwabanu. Moyize na Aloni tangaka bawu mutindu kele ntumunu yina Yave pesaka na yinwa ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ba tangaka bana ya Ngelesone mutindu kele makanda ya bawu mpe bivumu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Ba tangaka bawu kubanda na bayina ke na bamvula makumi tatu tii na bayina ke na bamvula makumi tanu, bayina nyonso lendaka sala kisalu na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Babakala yina ba tangaka na kati ya bana ya Ngelesone nyonso vwandaka mafunda zole na bankama sambanu na makumi tatu (2 630), mutindu kele makanda ya bawu mpe mutindu kele bivumu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Yina ni lutangu ya bantu ya makanda ya Ngelesone, bayina vwandaka sala bisalu na Yinzo ya Mbwabanu. Moyize na Aloni tangaka bawu mutindu kele ntumunu ya Yave. ");
INSERT INTO mkw_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ba tangaka bana ya Melali mutindu kele makanda ya bawu mpe mutindu kele bivumu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Ba tangaka bawu kubanda na bayina ke na bamvula makumi tatu tii na bayina ke na bamvula makumi tanu, bayina nyonso lendaka sala kisalu na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Babakala yina ba tangaka na kati ya bana ya Melali vwandaka mafunda tatu na bankama zole (3 200), mutindu kele makanda ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Yina ni lutangu ya bana ya makanda ya Melali, bayina vwandaka sala bisalu na Yinzo ya Mbwabanu. Moyize na Aloni tangaka bawu mutindu kele ntumunu yina Yave pesaka na yinwa ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Moyize, Aloni mpe bamfumu ya mukangu tangaka ba-Levi nyonso mutindu kele makanda ya bawu mpe mutindu kele bivumu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Ba tangaka bawu kubanda na bayina ke na bamvula makumi tatu tii na bayina ke na bamvula makumi tanu, bayina nyonso lendaka sala kisalu na kati ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Babakala nyonso yina ba tangaka na kati ya ba-Levi vwandaka mafunda nana na bankama tanu na makumi nana (8 580). ");
INSERT INTO mkw_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ba tangaka bawu mutindu kele ntumunu yina Yave pesaka na yinwa ya Moyize. Ba zabisaka bawu bisalu yina ba fwana kusala mpe bima yina ba fwana kunata. Ba tangaka bawu mutindu kele ntumunu yina Yave pesaka na Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Pesa ntumunu na bana ya Isayeli na kubingisa na kivwandu bantu nyonso yina kele na kimbevo ya mpusu, konso muntu yina ke na kimbevo ya kwendaka basika maza na nzutu ya yandi ya bukento to ya bubakala mpe konso muntu yina kele ve ya kuvedila samu ti yandi me simba mvumbi. ");
INSERT INTO mkw_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ya vwanda bakento to babakala, beno fwana kutula bawu na ngaanda ya kivwandu. Beno ke tula bawu na ngaanda ya kivwandu samu ti bawu kusumuna ve kivwandu ya bawu, kisika yina mu ke na kuzinga na kati-kati ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Bana ya Isayeli salaka mutindu yina. Bawu tulaka bawu na ngaanda ya kivwandu. Bana ya Isayeli salaka mutindu Yave tubaka na Moyize.» ");
INSERT INTO mkw_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Zonza na bana ya Isayeli mutindu yayi: Kana muntu ya bakala to ya kento me sala yimbi na mpangi muntu, yandi me sala yimbi ya mingi na ntadisi ya Yave. Na yina, yimbi ya disumu ya yandi ke bwidila yandi. ");
INSERT INTO mkw_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Yandi ke fungula disumu yina yandi me sala. Yandi ke futa na mpangi ya yandi kima yina yandi me sadila yimbi. Kasi yandi ke bwela na zulu ya kima yango kikunku mosi na bikunku tanu ya kima yina. ");
INSERT INTO mkw_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Kana muntu yina ba me sala yimbi me kufwa, mpe ti yandi kele ve na muntu yina ba lenda futa kima yango, ba ke pesa kima yango na Yave, ba ke pesa yawu na nganga-Nzambi. Ba ke bwela nkombo ya mbakala samu na mulemvo. Ba ke sadila nkombo na kusala nyonso yina me fwanana samu na kukatula disumu ya muntu yina. ");
INSERT INTO mkw_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Bikunku nyonso yina ba ke katula na zulu ya bima ya longo yina bana ya Isayeli ke pesa na Yave, yawu kele ya nganga-Nzambi yina ba me pesa bima yango. ");
INSERT INTO mkw_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Nganga-Nzambi ke baka bima ya longo yina ba ke pesa. Yandi ke baka kima ni kima yina konso muntu ke pesa na nganga-Nzambi.» ");
INSERT INTO mkw_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Zonza na bana ya Isayeli mutindu yayi: Kana kento ya makwela ke na mavanga ya yimbi mpe yandi kele ve ya kukwikama na bakala ya yandi, ");
INSERT INTO mkw_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kana bakala ya nkaka basika na kento yina, bakala ya yandi ata kuzaba, kana yandi sumuka na mansweki ata muntu kuzaba ve mpe ba me simba yandi ve, ");
INSERT INTO mkw_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","kana mpeve ya kimbanda me simba bakala ya yandi na kusadila kento ya yandi kimbanda, samu ti kento ya yandi yina me sumuka, to kana mpeve ya kimbanda me simba bakala ya yandi na kusadila kento ya yandi kimbanda, kasi kento yango me sumuka ya yandi ve, ");
INSERT INTO mkw_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","bakala yina ke nata kento ya yandi na sika ya nganga-Nzambi. Yandi ke nata dikabu ya kikunku mosi na kati ya bikunku kumi ya Efa ya faline ya oloze samu na yandi. Yandi ke tula ve mafuta na faline yina. Yandi ke tula mpe ve maaka ya nsunga ya mbote. Yawu kele Munkayulu ya madya ya bilanga samu na kimbanda. Yawu kele Munkayulu ya madya ya bilanga samu na kubambuka moyo na yimbi. ");
INSERT INTO mkw_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Nganga-Nzambi ke belemisa kento yango mpe ke telemisa yandi na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Yandi ke baka maza ya longo na kiteko ya kusalama na ntoto. Yandi ke baka fundu-fundu ya ntoto ya Yinzo ya longo mpe yandi ke tula yawu na kati ya maza yango. ");
INSERT INTO mkw_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Nganga-Nzambi ke telemisa kento yina na mantwala ya Yave. Yandi ke fungula yandi bansuki. Yandi ke tula na maboko ya kento yango Munkayulu ya madya ya bilanga samu na kubambuka moyo na yimbi, Munkayulu ya madya ya bilanga samu na kimbanda. Yandi mosi nganga-Nzambi ke simba na diboko ya yandi maza ya ndudi yina ke nataka nsiingulu. ");
INSERT INTO mkw_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Nganga-Nzambi ke diidisa kento yina ndefi. Yandi ke tuba mutindu yayi: “Kana bakala mosi ve me vukisa mfulu na nge, kana nge me sumuka ve na kubasika na bakala ya nkaka na ntangu yina nge kele na yinzo ya makwela, bika ti maza yayi ya ndudi yina ke nataka nsiingulu, bika ti yawu kulakisa ti nge me sala dyambu ve, ");
INSERT INTO mkw_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","kasi kana nge me sumuka na kubasika na bakala ya nkaka na ntangu yina nge kele na yinzo ya makwela, kana bakala ya nkaka me vukisa mfulu na nge”. ");
INSERT INTO mkw_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Nganga-Nzambi ke diidisa kento yina ndefi ya nsiingulu. Yandi ke tuba na kento mutindu yayi: “Bika ti Yave kupesa nge nsiingulu ya ndefi yayi na kati ya bantu ya nge. Bika ti Yave kukanga mabuta ya nge. Yandi kuvimbisa kivumu ya nge. ");
INSERT INTO mkw_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Bika ti maza yayi yina ke nataka nsiingulu kukota na nzutu ya nge, samu ti yawu kuvimbisa kivumu ya nge mpe yawu kukanga mabuta ya nge!” Kento ke ndima: “Ameni! Ameni!”» ");
INSERT INTO mkw_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«Nganga-Nzambi ke sonika bansiingulu yina na kati ya dibuku mpe yandi ke kusuna yawu na maza ya ndudi. ");
INSERT INTO mkw_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Yandi ke nwikisa kento maza ya ndudi yina ke nataka nsiingulu. Maza yina ya nsiingulu ke kota na nzutu ya kento na ndudi ya yawu nyonso. ");
INSERT INTO mkw_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Nganga-Nzambi ke baka na maboko ya kento Munkayulu ya madya ya bilanga samu na kimbanda. Nganga-Nzambi ke pesa munkayulu yango muntindu ba ke sadilaka na mantwala ya Yave. Na manima, yandi ke nata yawu na kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Nganga-Nzambi ke baka na diboko mwa ndambu ya munkayulu ya kubambuka moyo, mpe yandi ke yoka yawu na kiyokolo ya minkayulu. Na manima, yandi ke nwikisa kento maza. ");
INSERT INTO mkw_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ntangu yandi ke manisa na kunwikisa kento maza, kana kento vwandaka me sumuka mpe kana yandi vwandaka me vuna bakala ya yandi, maza yina ke nataka nsiingulu ke kota na nzutu ya yandi na ndudi ya yawu nyonso. Kivumu ya yandi ke vimba, mabuta ya yandi ke kangama. Mpe kento yina ke kuma kidimbu ya nsiingulu na kati-kati ya bantu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Kasi kana kento sumukaka ya yandi ve, kana yandi kele ya kuvedila, yandi ke talana ti yandi me sala dyambu ve. Mabuta ya yandi ke kangama ve.» ");
INSERT INTO mkw_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«Yina ni Musiku na yina me tadila kimbanda. Yawu me tadila kento yina me sumuka na kubasika na bakala ya nkaka na ntangu yina yandi kele na yinzo ya makwela. ");
INSERT INTO mkw_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Yawu me tadila mpe bakala yina me kuzwa mpeve ya kimbanda, yandi me sadila kento ya yandi kimbanda. Bakala yina ke telemisa kento ya yandi na mantwala ya Yave, mpe nganga-Nzambi ke sadila kento yango mambu nyonso ya Musiku yayi. ");
INSERT INTO mkw_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Na yina, bakala ke talana ti yandi kele ve muntu ya yimbi. Kasi yimbi nyonso ke vwanda na kento ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Zonza na bana ya Isayeli mutindu yayi: kana muntu ya bakala to ya kento me sala nsilulu ya bunazile na kukituula na lweka samu na Yave, ");
INSERT INTO mkw_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","yandi kumanga vinu mpe malafu. Yandi kunwa ve vinu ya ngayi to malafu ya ngayi. Yandi kunwa ve malafu yina ba me yidikila na bambuma ya vinu. Yandi kudya ve bambuma ya vinu, ya vwanda ya maza to ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ntangu nyonso yina yandi ke vwanda na kati ya bunazile, yandi ke kudya ata kima yina me katuka na mbuma ya vinu, kubanda na bambuma ya kati ya mbuma ya vinu tii na mpusu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ntangu nyonso yina yandi ke vwanda na kati ya nsilulu ya bunazile, yandi ke katula ve bansuki to mandefo ya yandi. Yandi ke vwanda ya longo tii na nsukunu ya ntangu yina yandi zengaka ya kuvwanda na lweka samu na Yave. Yandi ke bika ti bansuki ya yandi kukula ya yawu. ");
INSERT INTO mkw_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Na kati ya bilumbu nyonso yina yandi zengaka ya kuvwanda na lweka samu na Yave, yandi kubelama ve na mvumbi. ");
INSERT INTO mkw_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ya vwanda na lufwa ya tata ya yandi, ya mama ya yandi, ya mpangi ya yandi to ya kibusi ya yandi, yandi fwana kusumuka ve na kubelama na banzutu ya bawu. Samu ti na yintu ya yandi, yandi ke na kidimbu ya muntu yina me kuma na lweka samu na Nzambi ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","«Ntangu nyonso yina yandi ke vwanda na kati ya bunazile, yandi ke vwanda ya longo samu na Yave. ");
INSERT INTO mkw_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Kana na mpamukunu muntu kufwa pene-pene ya yandi, yawu ke sumuna kidimbu ya yandi ya bunazile yina kele na yintu ya yandi. Na yina, yandi ke katula bansuki ya yandi na kilumbu ya yandi ya kukivedisa, kilumbu ya nsambwadi. ");
INSERT INTO mkw_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Na kilumbu ya nana, yandi ke nata biduka zole to mabembe zole na sika ya nganga-Nzambi, na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Nganga-Nzambi ke pesa mosi na bandeke yina samu na Munkayulu ya mulemvo. Yandi ke pesa ndeke ya nkaka samu na Munkayulu ya Kuyoka. Yandi ke sala kisalu samu na kukatula disumu yina muntu yango me sala na kubotana na mvumbi. Kaka na kilumbu yina, mu-nazile ke byeka yintu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Yandi ke kukituula dyaka na lweka samu na Yave samu na ntangu yina yandi zengaka ntete. Na kusala yawu, yandi ke nata mwana ya dimeme ya mbakala ya mvula mosi samu na Munkayulu ya kikodi. Bilumbu yina yandi vwandaka me sala na bunazile me kuma ya mpamba, samu ti yawu vwandaka me sumuka.» ");
INSERT INTO mkw_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«Musiku yina me tadila bunazile kele mutindu yayi. Kilumbu yina yandi ke lungisa bilumbu yina yandi zengaka na kumanisa bunazile ya yandi, ba ke nata yandi na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Mpe muntu yango ke nata na Yave minkayulu yayi: mwana ya mbakala ya dimeme ya mvula mosi yina kele ve na kifuma samu na Munkayulu ya Kuyoka, mwana ya kento ya dimeme ya mvula mosi yina kele ve na kifuma samu na Munkayulu ya mulemvo, dimeme mosi ya mbakala yina kele ve na kifuma samu na Munkayulu ya Kiwisa, ");
INSERT INTO mkw_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","kitunga mosi ya mampa yina kele ve na levule, bagato ya kiputi ya faline ya kitoko yina ba me vukisa na mafuta mpe bagalete yina kele ve na levule, yina ba me pakula mafuta, Munkayulu ya madya ya bilanga na munkayulu ya vinu. ");
INSERT INTO mkw_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Nganga-Nzambi ke nata nyonso yina na mantwala ya Yave. Yandi ke pesa Munkayulu ya mulemvo mpe Munkayulu ya Kuyoka. ");
INSERT INTO mkw_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Yandi ke pesa mpe na Yave dimeme yina ya mbakala samu na Munkayulu ya Kiwisa. Yandi ke pesa mpe kitunga yina ya mampa yina kele ve na levule. Nganga-Nzambi ke pesa mpe Munkayulu ya madya ya bilanga mpe munkayulu ya vinu. ");
INSERT INTO mkw_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Na ntangu yina, mu-nazile ke zenga bansuki ya yintu ya yandi ya bunazile kuna na mwelo ya Yinzo ya Mbwabanu. Yandi ke baka bansuki ya yandi ya bunazile, yandi ke tula yawu na tiya yina ke na kulema na yisi ya Munkayulu ya Kiwisa. ");
INSERT INTO mkw_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nganga-Nzambi ke baka digembo ya dimeme ya mbakala yina me kuya yimeni. Yandi ke baka na kati ya kitunga gato mosi yina kele ve na levule mpe galete yina kele ve na levule. Nganga-Nzambi ke tula yawu na maboko ya mu-nazile kana mu-nazile yina me manisa na kuzenga bansuki ya yandi ya bunazile. ");
INSERT INTO mkw_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Na manima, nganga-Nzambi ke pesa yawu mutindu ba ke sadilaka na mantwala ya Yave. Ya kele kima ya longo. Yawu kele ya nganga-Nzambi mutindu mosi mpe ntulu ya mbisi ya munkayulu yina ba me pesa muntindu ba ke sadilaka na mantwala ya Yave, na kito yina ba ke katulaka. Na manima, mu-nazile lenda kunwa dyaka vinu.» ");
INSERT INTO mkw_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«Yina ni Musiku yina me tadila mu-nazile yina me sala nsilulu. Yina ni minkayulu yina yandi ke pesa na Yave samu na bunazile ya yandi, kutanga ve minkayulu ya nkaka yina yandi lenda pesa na luzolo ya yandi mosi. Yandi ke sadila banzengolo nyonso yina me tadila bunazile yina yandi me sadila nsilulu, mutindu kele Musiku yina me tadila bunazile.» ");
INSERT INTO mkw_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Zonza na Aloni na bana ya yandi: Na kusakumuna bana ya Isayeli, beno ke zonza mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«Bika ti Yave kusakumuna beno mpe yandi kukeba beno! ");
INSERT INTO mkw_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Bika ti Yave kukyenzudila beno kizizi ya yandi, mpe yandi kusadila beno bumbote ya yandi! ");
INSERT INTO mkw_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Bika ti Yave kubalula kizizi ya yandi na sika ya beno, mpe yandi kupesa beno kizunu. ");
INSERT INTO mkw_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ni mutindu yina bawu ke tula nkumbu ya munu na kati ya bana ya Isayeli, mpe munu, mu ke sakumuna bawu.» ");
INSERT INTO mkw_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Kilumbu yina Moyize manisaka na kutelemisa Yinzo, yandi kusaka yawu mafuta. Yandi byekaka yawu, yawu na bisalulu ya yawu nyonso. Yandi salaka muntindu mosi samu na kiyokolo ya minkayulu na bisalulu ya yawu. Yandi kusaka yawu mafuta mpe yandi byekaka yawu. ");
INSERT INTO mkw_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Na yina, bamfumu ya Isayeli, bamfumu ya makanda ya Isayeli pesaka minkayulu ya bawu. Ya vwandaka bamfumu ya bifumba, bayina vwandaka na kiyeko ya kusala lutangusu. ");
INSERT INTO mkw_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Bawu nataka minkayulu ya bawu na mantwala ya Yave: bapusu-pusu sambanu yina vwandaka na mwa miludi mpe bangombe kumi na zole. Pusu-pusu mosi-mosi vwandaka samu na bamfumu zole-zole, mpe ngombe mosi-mosi samu na mfumu mosi-mosi. Bawu nataka yawu na mantwala ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yave tubaka na Moyize mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Baka minkayulu ya bawu, samu na kusadila yawu na bisalu yina me tadila Yinzo ya Mbwabanu. Nge ke pesa yawu na ba-Levi samu na kunata yawu.» ");
INSERT INTO mkw_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moyize bakaka bapusu-pusu na bangombe mpe yandi pesaka yawu na ba-Levi. ");
INSERT INTO mkw_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Yandi pesaka bapusu-pusu zole na bangombe yiya na sika ya bana ya Ngelesone samu na kunata yawu. ");
INSERT INTO mkw_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Yandi pesaka bapusu-pusu yiya na bangombe nana na sika ya bana ya Melali samu na kunata yawu. Bana ya Melali vwandaka sala na lutwadusu ya Itamale, mwana ya nganga-Nzambi Aloni. ");
INSERT INTO mkw_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Kasi yandi pesaka kima ve na bana ya Keyate, samu ti bawu vwandaka na kiyeko ya bima ya longo, mpe ba fwanaka nata yawu na magembo. ");
INSERT INTO mkw_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kilumbu ya kukusa mafuta na kiyokolo ya minkayulu, bamfumu ya makanda nataka makabu samu na mukembo ya mbyekolo. Bawu nataka makabu ya bawu na mantwala ya kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yave tubaka na Moyize: «Bamfumu ke kwiza, kasi bawu fwana kukwiza mosi-mosi na kilumbu, samu na kupesa makabu ya bawu samu na mbyekolo ya kiyokolo ya minkayulu.» ");
INSERT INTO mkw_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Muntu yina pesaka munkayulu ya yandi kilumbu ya ntete, ya vwandaka ni Nasone, mwana ya Aminadabe muntu ya kifumba ya Yuda. ");
INSERT INTO mkw_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata Basekele makumi nsambwadi, na mutindu ba vwandaka tezila na Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Nasone, mwana ya Aminadabe. ");
INSERT INTO mkw_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Na kilumbu ya zole, Netanele, mwana ya Suwale, mfumu ya kifumba ya Isakale kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu kele Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Netanele, mwana ya Suwale. ");
INSERT INTO mkw_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Na kilumbu ya tatu, ni Elyabe, mwana ya Elone, mfumu ya kifumba ya Zabulone kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Elyabe, mwana ya Elone. ");
INSERT INTO mkw_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Na kilumbu ya yiya, ni Elisule, mwana ya Sedewule, mfumu ya bana ya Lubene kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu kele Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Elisule, mwana ya Sedewule. ");
INSERT INTO mkw_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Na kilumbu ya tanu, ni Selumyele, mwana ya Sulisadayi, mfumu ya bana ya Simewone kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Yandi pesaka ndonga mosi ya palata Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Selumyele, mwana ya Sulisadayi. ");
INSERT INTO mkw_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Na kilumbu ya sambanu, ni Elyasafe, mwana ya Dewele, mfumu ya bana ya Ngade kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Elyasafe, mwana ya Dewele. ");
INSERT INTO mkw_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Na kilumbu ya nsambwadi, ni Elisama, mwana ya Amiwude, mfumu ya kifumba ya Efalayime kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu ba Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Elisama, mwana ya Amiwude. ");
INSERT INTO mkw_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Na kilumbu ya nana, ni Ngamelyele, mwana ya Pedasule, mfumu ya bana ya Manase kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Ngamelyele, mwana ya Pedasule. ");
INSERT INTO mkw_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Na kilumbu ya yivwa, ni Abidane, mwana ya Ngidewoni, mfumu ya bana ya Bezame kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Abidane, mwana ya Ngidewoni. ");
INSERT INTO mkw_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Na kilumbu ya kumi, ni Ayezele, mwana ya Amisadayi, mfumu ya bana ya Dane kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Ayezele, mwana ya Amisadayi. ");
INSERT INTO mkw_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Na kilumbu ya kumi na mosi, ni Pangyele, mwana ya Okelane, mfumu ya bana ya Asele kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya Basekele makumi nsambwadi, mutindu Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Pangyele, mwana ya Okelane. ");
INSERT INTO mkw_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Na kilumbu ya kumi na zole, ni Ayila, mwana ya Eyinane, mfumu ya bana ya Nafetali kwizaka pesa munkayulu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Yandi pesaka ndonga mosi ya palata ya Basekele nkama na makumi tatu (130), mwa mbungu mosi ya palata ya Basekele makumi nsambwadi, mutindu Sekele yina ba ke sadilaka na Yinzo ya longo. Bima nyonso zole yina vwandaka ya kufuluka na kiputi ya faline ya kitoko yina ba vukisaka na mafuta, samu na Munkayulu ya madya ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Yandi pesaka mpe kopo ya wolo ya bangalame nkama na kumi (110) ya kufuluka na maaka ya nsunga ya mbote, ");
INSERT INTO mkw_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ngombe mosi ya mbakala, dimeme mosi ya mbakala, mwana mosi ya dimeme ya mvula mosi samu na Munkayulu ya Kuyoka, ");
INSERT INTO mkw_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","nkombo mosi ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Yandi pesaka samu na Munkayulu ya Kiwisa bangombe zole, mameme tanu ya mbakala, bankombo tanu ya mbakala, mpe bana tanu ya mameme yina me lungisa mvula mosi. Nyonso yina ni munkayulu ya Ayila, mwana ya Eyinane. ");
INSERT INTO mkw_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Nyonso yina ni minkayulu ya bamfumu ya Isayeli samu na mbyekolo ya kiyokolo ya minkayulu, kilumbu yina ba kusaka yawu mafuta. Nyonso yina ba pesaka vwandaka: bandonga kumi na zole ya palata, mwa bambungu kumi na zole ya palata mpe bakopo kumi na zole ya wolo. ");
INSERT INTO mkw_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Palata ya konso ndonga vwandaka sala Basekele nkama na makumi tatu (130). Palata ya konso mwa mbungu vwandaka sala Basekele makumi nsambwadi. Bisalulu nyonso yina salaka Basekele mafunda zole na bankama yiya (2 400) ya palata, mutindu Sekele yina ba vwandaka tezila na Yinzo ya longo. ");
INSERT INTO mkw_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Wolo ya konso kopo vwandaka sala Basekele kumi na mutindu ba vwandaka tezila na Sekele ya Yinzo ya longo. Wolo ya bakopo nyonso kumi na zole yina vwandaka ya kufuluka na maaka ya nsunga ya mbote salaka Basekele nkama na makumi zole (120). ");
INSERT INTO mkw_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Bibulu nyonso samu na minkayulu ya kuyoka vwandaka: bangombe kumi na zole ya mbakala, mameme kumi na zole ya mbakala, bana ya mameme kumi na zole ya mvula mosi, mpe minkayulu ya bawu ya bilanga. Ya vwandaka mpe na bankombo ya mbakala kumi na zole samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Bibulu nyonso samu na Munkayulu ya Kiwisa vwandaka: bangombe makumi zole na yiya, makumi ya mameme ya mbakala, makumi ya bankombo ya mbakala, makumi ya bana ya mameme yina vwandaka me lungisa mvula mosi. Nyonso yina ni minkayulu samu na mbyekolo ya kiyokolo ya minkayulu, kilumbu yina ba kusaka yawu mafuta. ");
INSERT INTO mkw_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ntangu Moyize kotaka na Yinzo ya Mbwabanu samu na kusolola na Yave, yandi vwandaka kuwa ndinga yina vwandaka zonzila yandi. Ndinga yango vwandaka wakana na zulu ya kitapu, na kati-kati ya bakeluba zole yina kele na zulu ya Sanduku ya Ngwisani. Yandi vwandaka zonzila yandi. ");
INSERT INTO mkw_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yave tubaka na Moyize mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Zonza na Aloni, tuba na yandi mutindu yayi: Ntangu nge ke yidika minda nsambwadi, nge ke tula yawu na zulu ya kitentokolo samu ti yawu banda na kukyenzulaka mantwala ya kitentokolo ya minda.» ");
INSERT INTO mkw_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aloni salaka mutindu yina. Yandi kwendaka tula minda na zulu ya kitentokolo samu ti yawu kukyenzulaka mantwala ya kitentokolo ya minda mutindu Yave tumisaka na Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Kitentokolo yango ya minda vwandaka mutindu yayi: yawu nyonso vwandaka ya kusalama na wolo yina ba tutaka. Kubanda na dikulu tii na bifulu, yawu nyonso vwandaka ya wolo yina ba tutaka. Ba yidikaka kitentokolo ya minda mutindu kele kifwani yina Yave lakisaka na Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Baka ba-Levi na kati-kati ya bana ya Isayeli mpe vedisa bawu. ");
INSERT INTO mkw_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Samu na kuvedisa bawu, nge ke sala mutindu yayi: nge ke mwanga bawu maza yina ke vedisaka. Bawu ke katula bansuki nyonso ya banzutu ya bawu. Bawu ke sukula binkuti ya bawu. Na yina, bawu ke kuma ya kuvedila. ");
INSERT INTO mkw_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Na manima, bawu ke baka ngombe mosi ya mbakala mpe munkayulu ya yawu ya madya ya bilanga: kiputi ya faline ya kitoko yina ba me vukisa na mafuta. Nge, nge ke baka ngombe ya nkaka ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Nge ke nata ba-Levi na mantwala ya Yinzo ya Mbwabanu mpe nge ke kutikisa mukangu nyonso ya bana ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Nge ke nata ba-Levi na mantwala ya Yave. Bana ya Isayeli ke tentika bawu maboko. ");
INSERT INTO mkw_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Na yina, ba-Levi yina yandi me baka na kati-kati ya bana ya Isayeli, Aloni ke pesa bawu na Yave na mutindu ba ke sadilaka na mantwala ya Yave, samu na kusala kisalu ya Yave. ");
INSERT INTO mkw_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Ba-Levi ke tentika maboko ya bawu na zulu ya bayintu ya bangombe zole ya mbakala. Nge ke pesa ngombe mosi samu na Munkayulu ya mulemvo mpe nge ke pesa ya nkaka mutindu Munkayulu ya Kuyoka na sika ya Yave samu na kukatula masumu ya ba-Levi. ");
INSERT INTO mkw_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Belemisa ba-Levi na mantwala ya Aloni na bana ya yandi. Nge ke pesa bawu na Yave na mutindu ba ke sadilaka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ni mutindu yina nge ke baka ba-Levi na kati-kati ya bana ya Isayeli, samu na kutula bawu na lweka. Na yina, bawu ke vwanda ya munu. ");
INSERT INTO mkw_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Na manima, ba-Levi ke kwiza banda kisalu na Yinzo ya Mbwabanu. Ni mutindu yina nge ke vedisa bawu, mpe nge ke pesa bawu na Yave na mutindu ba ke sadilaka na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Bawu kele ya kupesama yimeni na munu na nkumbu ya bana ya Isayeli. Mu me baka bawu na kisika ya bana ya ntete, bana nyonso ya Isayeli bayina me butuka ya ntete na bivumu ya bamama ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Samu ti konso mwana ya ntete yina kele bakala na kati ya bana ya Isayeli kele ya munu, ya vwanda ya bantu mpe ya bibulu. Kilumbu yina mu salaka ti bana nyonso ya ntete yina vwandaka babakala na yinsi ya Ngipiti kufwa, mu tulaka na lweka samu na munu bana nyonso ya ntete yina kele babakala na Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Mu bakaka ba-Levi na kisika ya bana nyonso ya ntete yina kele babakala na kati-kati ya bana ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Mu me pesa yimeni ba-Levi na sika ya Aloni na bana ya yandi na nkumbu ya bana ya Isayeli. Mu me pesa bawu samu ti bawu kusala kisalu na Yinzo ya Mbwabanu na nkumbu ya bana ya Isayeli. Ni bawu ke sala kisalu samu na kukatula masumu ya bana ya Isayeli. Na yina, yimbi ke bwidila ve bana ya Isayeli yina ke belama na Yinzo ya longo.» ");
INSERT INTO mkw_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moyize na Aloni na mukangu nyonso ya bana ya Isayeli salaka na ba-Levi mambu nyonso yina Yave tumisaka Moyize na kusala samu na ba-Levi. Ni mutindu yina bana ya Isayeli salaka samu na bawu. ");
INSERT INTO mkw_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ba-Levi kukivedisaka mpe bawu sukulaka binkuti ya bawu. Aloni pesaka bawu na Yave na muntindu ba ke sadilaka na mantwala ya Yave, mpe yandi salaka kisalu samu na kukatula masumu ya bawu mpe samu na kuvedisa bawu. ");
INSERT INTO mkw_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Na manima, ba-Levi kwizaka banda kisalu ya bawu na Yinzo ya Mbwabanu, na lutwadusu ya Aloni na bana ya yandi, mutindu Yave tumisaka na Moyize na yina me tadila ba-Levi. Ni mutindu yina yandi salaka samu na bawu. ");
INSERT INTO mkw_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yave tubaka dyaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Yina me tadila ba-Levi ni yayi: ba-Levi yina kele na bamvula kubanda na makumi zole na tanu tii na zulu, bawu lenda sala na Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Kasi ntangu bawu ke lungisa bamvula makumi tanu, bawu ke sala dyaka ve. Na yina, bawu ke bika kisalu. ");
INSERT INTO mkw_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Bawu ke sadisa bampangi ya bawu na bisalu ya bawu na Yinzo ya Mbwabanu, kasi bawu mosi ke sala ata kisalu mosi ve. Ni mutindu yina nge ke sadila samu na ba-Levi, na yina me tadila kisalu ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Na ngonda ya ntete ya mvula ya zole yina landaka kubasika ya bana ya Isayeli na yinsi ya Ngipiti, Yave zonzaka na Moyize kuna na yinsi ya kuyuma ya Sinayi. Yandi tubaka mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Bana ya Isayeli fwana kusala mukembo ya Paki na ntangu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Beno sala mukembo yango na ntangu ya yawu. Yawu ke vwanda na kilumbu ya kumi na yiya ya ngonda yayi, na nkokila. Beno ke sala yawu mutindu kele bansalulu nyonso mpe banzengolo nyonso ya yawu. ");
INSERT INTO mkw_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moyize zonzaka na bana ya Isayeli na kusala mukembo ya Paki. ");
INSERT INTO mkw_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Na yina, bana ya Isayeli salaka mukembo ya Paki, na kilumbu ya kumi na yiya ya ngonda ya ntete, na nkokila. Bawu salaka yawu kuna na yinsi ya kuyuma ya Sinayi. Bana ya Isayeli salaka nyonso yina Yave tumisaka na Moyize.» ");
INSERT INTO mkw_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Kasi ya vwandaka na bantu yina vwandaka ve ya kuvedila samu ti bawu simbaka mvumbi. Na kilumbu yina, bawu vwandaka ve na luve ya kembila Paki. Kaka na kilumbu yango, bawu kwendaka talana na meso ya Moyize na Aloni. ");
INSERT INTO mkw_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Bawu tubaka na Moyize: «Beto kele ya kusumuka samu ti beto me simba mvumbi. Samu na yinki beto ke kuzwa ve luve ya kupesa munkayulu ya beto na sika ya Yave, na ntangu ya yawu, kintwadi na bana ya Isayeli?» ");
INSERT INTO mkw_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moyize tubaka na bawu: «Beno telama awa mpe beno vingila. Mu ke kwenda kuwa yinki Yave ke tumisa samu na beno.» ");
INSERT INTO mkw_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Zonza na bana ya Isayeli mutindu yayi: Kana muntu na kati ya beno kele ya kuvedila ve samu ti yandi me simba mvumbi, to kana yandi kele ntama na nzyetolo, ya vwanda bubu yayi to na bambandu yina ke kwiza, yandi lenda kembila mukembo ya Paki samu na munu Yave. ");
INSERT INTO mkw_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ni na kilumbu ya kumi na yiya ya ngonda ya zole bawu ke sala mukembo yango, na nkokila. Bawu ke kudya mbisi ya Paki na mampa yina kele ve na levule mpe ndunda ya ndudi. ");
INSERT INTO mkw_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Bawu ke bika ata ndambu ve tii mbasi na suka. Bawu ke buka ve ata mukwa mosi ya yawu. Bawu ke sala mukembo yina mutindu kele bansalulu nyonso yina me tadila Paki. ");
INSERT INTO mkw_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Kana muntu kele ya yandi ya kuvedila mpe yandi kele ve na nzyetolo kasi yandi me manga na kukembila Paki, ba ke katula yandi na mukangu ya bantu ya yandi. Samu ti yandi me pesa ve munkayulu ya Yave na ntangu ya yawu. Na yina, disumu ya yandi ke vwanda na yintu ya yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Kana nzenza yina kele na kati ya beno kukembila mukembo ya Paki ya Yave kintwadi na beno, yandi fwana kulanda bansalulu mpe banzengolo nyonso yina me tadila Paki. Bansalulu ke vwanda kaka mosi samu na beno nyonso, ya vwanda samu na banzenza to samu na bantu ya yinsi.» ");
INSERT INTO mkw_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Kilumbu yina ba telemisaka Yinzo ya longo, dituti kwizaka fuka Yinzo, Yinzo ya Ngwisani. Kubanda na nkokila tii na suka, yawu bakaka kifwani ya tiya na zulu ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Konso ntangu, ya vwandilaka mutindu yina. Dituti vwandaka fuka Yinzo. Na mpimpa, dituti yango vwandaka baka kifwani ya tiya. ");
INSERT INTO mkw_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Konso ntangu yina dituti vwandaka katuka na zulu ya Yinzo ya longo, bana ya Isayeli mpe vwandaka kwenda. Kisika ni kisika yina dituti vwandaka telama, bana ya Isayeli mpe vwandaka sala kivwandu ya bawu kuna. ");
INSERT INTO mkw_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Bana ya Isayeli vwandaka kwenda na ntumunu ya Yave. Bawu vwandaka sala mpe kivwandu ya bawu na ntumunu ya Yave. Bawu vwandaka zingila na kivwandu ya bawu ntangu nyonso yina dituti vwandaka na zulu ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kana dituti kuzingila na zulu ya Yinzo, bana ya Isayeli vwandaka sala kisalu ya Yave. Bawu vwandaka katuka ve kuna. ");
INSERT INTO mkw_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kana dituti kusala kaka mwa bilumbu na zulu ya Yinzo, bawu vwandaka sala kivwandu ya bawu na ntumunu ya Yave. Bawu vwandaka katuka kuna mpe na ntumunu ya Yave. ");
INSERT INTO mkw_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kana dituti kuvwanda kaka kubanda na nkokila tii na suka, mpe kana na suka yina yawu kukatuka, bawu vwandaka telama na kukwenda. Kana dituti kukatuka na manima ya kilumbu mosi, mpimpa na ntangu, bawu vwandaka telama mpe kukwenda. ");
INSERT INTO mkw_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kana dituti kutelama na zulu ya Yinzo bilumbu zole, ngonda mosi, to mvula mosi, bana ya Isayeli vwandaka sala kivwandu ya bawu kuna. Bawu vwandaka katuka ve kuna. Kasi kana dituti kukatuka, bawu mpe vwandaka telama na kukwenda. ");
INSERT INTO mkw_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Bana ya Isayeli vwandaka sala kivwandu ya bawu na ntumunu ya Yave. Bawu vwandaka kwenda mpe na ntumunu ya Yave. Bawu vwandaka sala kisalu ya Yave mutindu vwandaka ntumunu yina Yave pesaka na yinwa ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yave tubaka na Moyize mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Yidikisa bampungi zole ya palata yina ba tutaka. Nge ke yidikisa yawu na kisengo ya kukoba. Ni yawu nge ke sadila na kubokilaka mukangu nyonso mpe na zabisaka ntangu ya kukatula kivwandu. ");
INSERT INTO mkw_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ntangu ba ke wakisa muningu ya bakulumenta nyonso zole, mukangu nyonso ke yonzama na sika ya nge, kuna na mwelo ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kana ba wakisa kaka muningu ya kulumenta mosi, bantwadisi, bamfumu ya bifumba ya Isayeli ke kwiza yonzama pene-pene ya nge. ");
INSERT INTO mkw_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ntangu beno ke wakisa muningu ya mvita, bayina ke na kivwandu ya lweka ya esete ke telama na kukwenda. ");
INSERT INTO mkw_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ntangu beno ke wakisa muningu ya mvita na mbala ya zole, bayina ke na kivwandu ya lweka ya sude ke telama na kukwenda. Ba ke wakisa muningu ya mvita samu na kukwenda. ");
INSERT INTO mkw_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Beno ke wakisa mpe muningu ya bampungi samu na kuyonzika mukangu. Kasi beno ke wakisa ve muningu ya mvita samu na yawu.» ");
INSERT INTO mkw_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","«Kaka ni bana ya Aloni, banganga Nzambi ke wakisa muningu ya bampungi. Ya kele ntumunu ya konso ntangu samu na beno, bambandu nyonso.» ");
INSERT INTO mkw_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«Ntangu beno ke vwanda na yinsi ya beno, kana bambeni me kwiza nwanisa beno mpe beno me kota na mvita, beno ke wakisa muningu ya bampungi samu na mvita. Yawu ke sala ti Yave, Nzambi ya beno kubambukila beno moyo, mpe beno ke vuuka na maboko ya bambeni ya beno. ");
INSERT INTO mkw_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Na bilumbu ya beno ya kyese, ya vwanda ya balukutakanu ya minkembo ya Yave, ya vwanda ya bilumbu ya ntete ya ngonda, beno ke wakisa muningu ya bampungi na kupesaka minkayulu ya beno ya kuyoka mpe minkayulu ya kiwisa. Yawu ke vwanda kidimbu ya kubambukilaka beno moyo na mantwala ya Nzambi ya beno. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Na kilumbu ya makumi zole ya ngonda ya zole, na mvula ya zole na manima ya kubasika na yinsi ya Ngipiti, dituti katukaka na zulu ya Yinzo ya longo. ");
INSERT INTO mkw_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Bana ya Isayeli telamaka na kubika yinsi ya kuyuma ya Sinayi, bawu vwandaka kwenda kisika na kisika. Dituti kwendaka telama na yinsi ya kuyuma ya Palane. ");
INSERT INTO mkw_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ya vwandaka na mbala ya ntete bawu kwendaka na ntumunu yina Yave pesaka na yinwa ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Bayina vwandaka pene-pene kidimbu ya yinsi ya kivwandu ya Yuda kwendaka ba ya ntete, mutindu vwandaka bankonga ya binwani ya bawu. Mfumu ya nkonga ya binwani ya bana ya Yuda ni Nasone, mwana ya Aminadabe. ");
INSERT INTO mkw_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Mfumu ya nkonga ya binwani ya bana ya Isakale ni Netanele, mwana ya Suwale. ");
INSERT INTO mkw_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Mfumu ya nkonga ya binwani ya bana ya Zabulone ni Elyabe, mwana ya Elone. ");
INSERT INTO mkw_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ba katulaka Yinzo ya longo. Bana ya Ngelesone na bana ya Melali telamaka na kukwenda. Bawu bakaka Yinzo yango mpe bawu nataka yawu. ");
INSERT INTO mkw_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Bayina vwandaka pene-pene kidimbu ya yinsi ya kivwandu ya Lubene kwendaka, mutindu vwandaka bankonga ya binwani ya bawu. Mfumu ya nkonga ya binwani ya bana ya Lubene ni Elisule, mwana ya Sedewule. ");
INSERT INTO mkw_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Mfumu ya nkonga ya binwani ya bana ya Simewone ni Selumyele, mwana ya Sulisadayi. ");
INSERT INTO mkw_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Mfumu ya nkonga ya binwani ya bana ya Ngade ni Elyasafe, mwana ya Dewele. ");
INSERT INTO mkw_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Na manima, ba-Keyate telamaka na kukwenda. Bawu bakaka bima ya longo ya Yinzo mpe bawu nataka yawu. Ba vwandaka telemisa Yinzo tekila ba-Keyate kukuma. ");
INSERT INTO mkw_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Bayina vwandaka pene-pene kidimbu ya yinsi ya kivwandu ya Efalayime kwendaka, mutindu vwandaka bankonga ya binwani ya bawu. Mfumu ya nkonga ya binwani ya bana ya Efalayime ni Elisama, mwana ya Amiwude. ");
INSERT INTO mkw_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Mfumu ya nkonga ya binwani ya bana ya Manase ni Ngamelyele, mwana ya Pedasule. ");
INSERT INTO mkw_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Mfumu ya nkonga ya binwani ya bana ya Bezame ni Abidane, mwana ya Ngidewoni. ");
INSERT INTO mkw_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Bayina vwandaka pene-pene kidimbu ya yinsi ya kivwandu ya Dane kwendaka, mutindu vwandaka bankonga ya binwani ya bawu. Mfumu ya nkonga ya binwani ya bana ya Dane ni Ayezele, mwana ya Amisadayi. Ni bawu vwandaka mukangu ya mansukina na kukwenda, na manima ya bankonga nyonso. ");
INSERT INTO mkw_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Mfumu ya nkonga ya binwani ya bana ya Asele ni Pangyele, mwana ya Okelane. ");
INSERT INTO mkw_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Mfumu ya nkonga ya binwani ya bana ya Nafetali ni Ayila, mwana ya Enane. ");
INSERT INTO mkw_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ni mutindu yina bana ya Isayeli landasanaka na nkwendolo ya bawu, mutindu vwandaka bankonga ya binwani ya bawu. Ni mutindu yina bawu kwendilaka. ");
INSERT INTO mkw_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moyize tubaka na Obabe, mwana ya bokilo ya yandi Lewele muntu ya Midyane mutindu yayi: «Beto ke na kukwenda na kisika yina Yave zonzilaka ntangu yandi tubaka ti: “Mu ke pesa beno yawu.” Kwenda kintwadi na beto mpe beto ke sala nge mambu ya mbote. Samu ti Yave salaka nsilulu ya kusala mambu ya mbote na Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Obabe vutulaka: «Ve! Mu ke kwenda ve, mu ke vutuka ya munu na yinsi ya munu, na sika ya dikanda ya munu.» ");
INSERT INTO mkw_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moyize tubaka dyaka na yandi: «Mulemvo ya nge, kubika beto ve. Samu ti nge me zaba mbote bisika yina beto lenda sala bivwandu ya beto na kati ya yinsi ya kuyuma. Ni nge ke vwanda mulakisi-nzila samu na beto. ");
INSERT INTO mkw_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kana nge kwenda na beto, beto ke sala ti nge mpe nge kuzwa mbote yina Yave ke sadila beto.» ");
INSERT INTO mkw_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Bana ya Isayeli bikaka mongo ya Yave mpe bawu kwendaka. Bawu tambulaka bilumbu tatu. Bayina vwandaka nata Sanduku ya Ngwisani ya Yave tekilaka na mantwala. Bawu salaka bilumbu tatu na kwendaka sosa kisika ya kupema. ");
INSERT INTO mkw_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Na ntangu, kana bawu me bika yimeni kivwandu ya bawu, dituti ya Yave vwandaka na zulu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ntangu sanduku vwandaka kwenda, Moyize vwandaka tuba: «Yave, telama! Bika ti bambeni ya nge kumwangana! Bika ti bayina ke yinaka nge, ba kima na mantwala ya nge!» ");
INSERT INTO mkw_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ntangu ba vwandaka telemisa sanduku, Moyize vwandaka tuba: «Yave, vutuka na sika ya makumi ya mafunda ya bankonga ya nge ya binwani ya Isayeli!» ");
INSERT INTO mkw_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Kilumbu mosi, bana ya Isayeli vwandaka yawula mingi na ntadisi ya Yave. Ntangu Yave kuwaka kuyawula yina, yandi dasukaka. Tiya ya Yave lemaka na kati ya bawu mpe yokaka mwa ndambu ya nsuka ya kivwandu. ");
INSERT INTO mkw_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Bantu lookaka na sika ya Moyize. Moyize sambilaka Yave mpe tiya kufwaka. ");
INSERT INTO mkw_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ba pesaka kisika yina nkumbu Tabela, yina zola kutuba «tiya ya nene», samu ti tiya ya Yave lemaka na kati ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Na kati ya bana ya Isayeli, ya vwandaka na nkonga ya bantu yina vwandaka zyeta na bawu. Bawu vwandaka ya kufuluka na bansatu ya mutindu na mutindu. Na yina, bawu mosi bana ya Isayeli bandaka dyaka na kudila. Bawu vwandaka tuba: «Aa! Nani ke pesa kwandi beto mbisi ya kudya? ");
INSERT INTO mkw_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Beto ke na kubambuka moyo na bambisi ya maza yina beto vwandaka kudya na Ngipiti ya pamba, na bakonkombe, bapaseteke, bapwalo, ba-onyon mpe ba-aye. ");
INSERT INTO mkw_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Kasi na ntangu yayi, beto ke na kufwa nsatu, ata kima mosi ke dyaka ve. Kaka ni mane ke na kutalana na meso ya beto.» ");
INSERT INTO mkw_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mane kele mutindu bambuma ya yinti yina ba ke bokilaka koleyande. Yawu kele na kifwani ya mwa yinti ya bedelyume. ");
INSERT INTO mkw_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Bana ya Isayeli vwandaka mwangana na kwendaka lokota yawu. Ba vwandaka nika yawu na matadi to kututa yawu na bitutulu. Ba vwandaka lamba yawu na banzungu to kusadila yawu bagalete. Na kati ya yinwa, yawu vwandaka mutindu biskwi yina ba me lamba na mafuta. ");
INSERT INTO mkw_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Na mpimpa, ntangu kinoko vwandaka kubwa na kivwandu, mane mpe vwandaka kubwa. ");
INSERT INTO mkw_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moyize kuwaka bantu vwandaka dila, muntu-muntu na dikanda ya yandi, na mwelo ya yinzo ya yandi. Na yina, Yave dasukaka mingi, mpe Moyize talaka yawu yimbi. ");
INSERT INTO mkw_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Yandi tubaka na Yave: «Samu na yinki nge ke na kutalisa munu mpasi, munu kisadi ya nge? Samu na yinki mu me kuzwa ve bumbote na meso ya nge? Samu na yinki nge me pesa kwandi munu kiyeko ya bantu nyonso yayi? ");
INSERT INTO mkw_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ni munu muntu nataka kivumu ya bantu yayi nyonso? Ni munu muntu butaka bawu samu ti nge tuba na munu ti: “Nata bawu na ntulu mutindu mama ke natinaka mwana yina ke ntete na mabene”? Mu nata bawu tii na yinsi yina nge salaka nsilulu ya kupesa na bankooko ya bawu? ");
INSERT INTO mkw_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Wapi kisika mu ke kuzwa mbisi ya kupesa na bantu nyonso yayi? Samu ti bawu ke na kwizaka dila na sika ya munu na kutubaka: “Pesa beto mbisi yina beto ke kudya!” ");
INSERT INTO mkw_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Munu mosi, mu ke lenda ve na kunata bantu nyonso yayi. Bawu me lutila dema samu na munu. ");
INSERT INTO mkw_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Samu ti nge ke na kubakila munu mutindu yayi, mulemvo ya nge, kufwa kwandi munu. Kana nge me lakisa munu bumbote ya nge, kubika ve ti mpasi ya mutindu yayi kukwamisa dyaka munu.» ");
INSERT INTO mkw_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yave tubaka na Moyize: «Kutikisa samu na munu makumi ya babakala na kati ya bakuluntu ya Isayeli. Ya fwana kuvwanda bayina nge me zaba ti ba kele bakuluntu, mpe bisoniki. Nata bawu na Yinzo ya Mbwabanu. Bawu kutelama kuna kintwadi na nge. ");
INSERT INTO mkw_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Mu ke kulumuka kuna mpe mu ke mokana na nge. Mu ke baka mwa ndambu ya mpeve yina kele na zulu ya nge mpe mu ke tula yawu na zulu ya bawu, samu ti bawu kunata kintwadi na nge kiyeko ya bantu. Na yina, nge ke vwanda dyaka ve nge mosi na kunata yawu. ");
INSERT INTO mkw_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Zonza na bantu mutindu yayi: beno vwanda ya kuvedila samu na kilumbu ya mbasi. Beno ke kudya mbisi, samu ti beno me dila na ntadisi ya Yave ntangu beno vwandaka tuba: “Nani ke pesa beto mbisi ya kudya? Beto vwandaka ya beto mbote na Ngipiti!” Yave ke pesa beno mbisi mpe beno ke kudya yawu.» ");
INSERT INTO mkw_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","«Beno ke kudya yawu kaka na kilumbu mosi ve, to na bilumbu zole, bilumbu tanu, bilumbu kumi, to bilumbu makumi zole. ");
INSERT INTO mkw_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Kasi beno ke kudya yawu ngonda ya muvimba, tii ntangu yawu ke basika beno na bambombo, tii ntangu yina beno ke yina yawu. Samu ti beno mangaka Yave yina kele na kati-kati ya beno mpe beno me dila na ntadisi ya yandi ntangu beno vwandaka tuba: “Samu na yinki beto me basika kwandi na yinsi ya Ngipiti?”» ");
INSERT INTO mkw_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moyize vutulaka: «Bantu yayi me zungidila munu kele mafunda bankama sambanu (600 000) ya binwani yina ke nwanaka na kwendaka tambula na makulu. Mpe nge ke na kutuba ti nge ke pesa bawu mbisi yina bawu ke kudya ngonda ya muvimba! ");
INSERT INTO mkw_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ba ke kufwa samu na bawu mameme, bankombo na bangombe samu ti yawu kulungila bawu? Ba ke kutikisa samu na bawu bambisi nyonso ya mubu samu ti yawu kulungila bawu?» ");
INSERT INTO mkw_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yave vutulaka na Moyize: «Nge ke na kubanza ti diboko ya Yave kele nkufi? Ntangu yayi, nge ke tala kana mambu yayi mu ke na kutubila nge ke salama, to yawu ke salama ve.» ");
INSERT INTO mkw_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moyize basikaka mpe kwendaka zonza na bantu mambu yina Yave tubaka. Yandi kutikisaka makumi ya bakuluntu ya Isayeli. Yandi telemisaka bawu na balweka nyonso ya Yinzo. ");
INSERT INTO mkw_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yave kulumukaka na kati ya dituti mpe zonzaka na Moyize. Yandi bakaka mwa ndambu ya mpeve yina vwandaka na zulu ya Moyize, mpe yandi tulaka yawu na zulu ya makumi ya bakuluntu yango. Kaka na ntangu yina mpeve bwidilaka bawu, bawu bandaka na kututuka. Kasi bawu tatamanaka ve. ");
INSERT INTO mkw_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ya vwandaka na bantu zole yina bikanaka na kivwandu. Mosi, nkumbu ya yandi vwandaka Eledade mpe ya nkaka, Medade. Mpeve kwendaka bwidila bawu. Samu ti bawu mpe ba vwandaka na lutangu ya bayina ba sonikaka, kasi bawu kwendaka ve na Yinzo ya longo. Bawu bandaka na kututuka kuna na kivwandu. ");
INSERT INTO mkw_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ditoko mosi kimaka mbangu na kwenda zabisa na Moyize ti: «Eledade na Medade ke na kututuka kuna na kivwandu.» ");
INSERT INTO mkw_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yeswa mwana ya Nune, yina vwandaka kilandi ya Moyize kubanda buntwenya, yandi lookaka: «Moyize, mfumu ya munu, kabikisa bawu!» ");
INSERT INTO mkw_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moyize vutulaka: «Nge ke na kusala kimbanda samu na munu? Ya zolaka vwanda mbote kana bantu nyonso ya Yave vwandaka mimbikudi, kana Yave tulaka mpeve ya yandi na zulu ya bawu nyonso!» ");
INSERT INTO mkw_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Na manima, Moyize vutukaka na kivwandu, yandi na bakuluntu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Yave fidisaka mupepe yina nataka bandeke katuka na mubu. Yawu kwizaka bwisa yawu na kivwandu nyonso mpe na balweka nyonso ya yawu. Na balweka nyonso, nge fwana kutambula kilumbu ya muvimba samu na kukuma tii na ndilu ya kisika yina kubwaka bandeke yango. Bandeke vwandaka ya kutentasana na kitezo ya Bakude zole. ");
INSERT INTO mkw_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Na kilumbu ya muvimba yina, na mpimpa mpe na kilumbu yina landaka, bantu vwandaka lokota bandeke. Kitezo ya kulutila fyoti yina muntu lendaka lokota vwandaka ya Ba Omele kumi. Bawu tandaka bandeke yango na ngaanda ya kivwandu, na balweka nyonso. ");
INSERT INTO mkw_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Mbisi vwandaka ntete na bayinwa, bawu vwandaka nabunu ba mina yawu, Yave dasukilaka bawu. Yave pesaka bantu kiyoolo ya ngolo. ");
INSERT INTO mkw_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ba pesaka kisika yina nkumbu Kibelote-Atava, yina zola kutuba «Mpyema ya bizola-zola». Samu ti ni na kisika yina ba kundaka bantu yina vwandaka bizola-zola mingi. ");
INSERT INTO mkw_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Bantu ya Isayeli bikaka Kibelote-Atava samu na kukwenda na Aselote. Bawu kwendaka pema na Aselote. ");
INSERT INTO mkw_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Milyame na Aloni vungutilaka Moyize na yina me tadila mu-Kuse yina yandi kwelaka. Samu ti kento yina Moyize kwelaka vwandaka mu-Kuse. ");
INSERT INTO mkw_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Bawu tubaka na Moyize: «Kaka ni na yinwa ya Moyize Yave ke zonzaka? Yandi ke zonzaka mpe ve na bayinwa ya beto?» Yave kuwaka yawu. ");
INSERT INTO mkw_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Moyize vwandaka muntu mosi ya kukuluka mingi, kulutila bantu nyonso ya ntoto. ");
INSERT INTO mkw_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Na mpamukunu, Yave tubaka na Moyize, Aloni mpe Milyame: «Beno tatu beno kwiza pene-pene ya Yinzo ya Mbwabanu.» Bawu kwendaka bawu nyonso tatu. ");
INSERT INTO mkw_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Yave kulumukaka na kati ya dituti ya kutelama. Yandi kwizaka telama na mwelo ya Yinzo ya longo. Yandi bokilaka Aloni mpe Milyame, mpe bawu nyonso zole belamaka. ");
INSERT INTO mkw_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Yave tubaka na bawu: «Beno kuwa mbote mambu yina mu ke zonza na beno! Kana na kati-kati ya beno ya kele na mumbikudi ya Yave, ni na kati ya lumoni munu mu ke kwiza talana na yandi. Ni na kati ya ndosi mu ke kwiza zonzila yandi. ");
INSERT INTO mkw_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Kasi na yina me tadila kisadi ya munu Moyize, ya kele mutindu yina ve. Yandi kele muntu ya kukwikama na kusala kisalu ya munu na yinzo nyonso ya munu. ");
INSERT INTO mkw_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mu ke sololaka na yandi kizizi na kizizi. Mu ke talanaka na yandi mpe mu ke zonzilaka yandi na pwelele nyonso. Yandi ke talaka mutindu munu Yave mu ke talanaka. Kasi samu na yinki beno me vwanda ve na boma ya kuzonza yimbi samu na kisyelo ya munu Moyize?» ");
INSERT INTO mkw_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Yave dasukilaka bawu, mpe yandi kwendaka ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Dituti katukaka na zulu ya Yinzo. Milyame kumaka ya kufuka na kimbevo ya mpusu. Yandi nyonso kumaka mpembe ya kulutila. Aloni balukaka na kutala Milyame. Milyame vwandaka me fuluka yandi nyonso na kimbevo ya mpusu. ");
INSERT INTO mkw_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Na yina, Aloni tubaka na Moyize: «lemvokila beto mfumu ya munu, mulemvo ya nge, kufutisa ve beto disumu yina beto me sala. Beto me sadila buzoba. ");
INSERT INTO mkw_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mulemvo ya nge, kubika ve ti Milyame kuvwanda mutindu mwana yina me butuka ya kufwa, yina vwandaka me banda na kubola na kati ya kivumu ya mama ya yandi.» ");
INSERT INTO mkw_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moyize lookaka na sika ya Yave mutindu yayi: «Nzambi, mulemvo ya nge, nyakisa yandi!» ");
INSERT INTO mkw_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yave tubaka na Moyize: «Kana tata ya yandi lobolaka yandi mante na kizizi, yandi zolaka vwanda ve na nsoni bilumbu nsambwadi? Ba bingisa yandi na kivwandu, yandi kuvwanda dyaka ve na kati ya kivwandu bilumbu nsambwadi! Na manima, beno ke ndima dyaka yandi na kati ya beno.» ");
INSERT INTO mkw_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ba tulaka Milyame na ngaanda ya kivwandu, yandi salaka bilumbu nsambwadi kuna. Bana ya Isayeli kwendaka ve tekila bawu kundima dyaka Milyame na kati ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Na manima, bawu katukaka na Aselote mpe bawu kwendaka sala kivwandu ya bawu na yinsi ya kuyuma ya Palane. ");
INSERT INTO mkw_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Fidisa babakala na kwenda tala mbote-mbote na mansweki yinsi ya Kaana yina mu ke na kupesa na bana ya Isayeli. Beno fidisa muntu mosi-mosi ya konso kifumba. Bawu nyonso fwana kuvwanda bamfumu na kati ya bantu ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moyize fidisaka babakala yango katuka yinsi ya kuyuma ya Palane mutindu vwandaka ntumunu ya Yave. Babakala yango nyonso vwandaka bamfumu ya bantu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Bankumbu ya bawu ni yayi: Samu na kifumba ya Lubene: Samuwa, mwana ya Zakule. ");
INSERT INTO mkw_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Samu na kifumba ya Simewone: Safate, mwana ya Oli. ");
INSERT INTO mkw_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Samu na kifumba ya Yuda: Kalebe, mwana ya Yefune. ");
INSERT INTO mkw_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Samu na kifumba ya Isakale: Ingale, mwana ya Yosefi. ");
INSERT INTO mkw_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Samu na kifumba ya Efalayime: Oseya, mwana ya Nune. ");
INSERT INTO mkw_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Samu na kifumba ya Bezame: Paleti, mwana ya Lafu. ");
INSERT INTO mkw_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Samu na kifumba ya Zabulone: Ngadyele, mwana ya Sodi. ");
INSERT INTO mkw_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Samu na kifumba ya Yosefi, kifumba ya Manase: Ngadi, mwana ya Susi. ");
INSERT INTO mkw_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Samu na kifumba ya Dane: Amyele, mwana ya Ngemali. ");
INSERT INTO mkw_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Samu na kifumba ya Asele: Setule, mwana ya Mikayele. ");
INSERT INTO mkw_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Samu na kifumba ya Nafetali: Nabi, mwana ya Vofesi. ");
INSERT INTO mkw_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Samu na kifumba ya Ngade: Ngewele, mwana ya Maki. ");
INSERT INTO mkw_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Yina ni bankumbu ya babakala yina Moyize fidisaka na kwenda tala mbote-mbote na mansweki yinsi ya Kaana. Moyize pesaka nkumbu ya Yeswa na Oseya mwana ya nune. ");
INSERT INTO mkw_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moyize fidisaka babakala yango na kwenda tala yinsi ya Kaana. Yandi tubaka na bawu: «Beno lutila na kizunga ya Nengeve, beno ke yuluka kizunga ya myongo. ");
INSERT INTO mkw_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Beno ke tala yinsi mutindu yawu kele. Beno ke tala mutindu ya bantu yina ke zingaka kuna, kana bawu ke na ngolo to ve. Beno ke tala kana bawu kele mingi to ve. ");
INSERT INTO mkw_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Beno ke tala wapi mutindu kele yinsi yina bawu ke vwandaka. Kana yawu kele ya mbote to ya yimbi. Beno ke tala mutindu kele bambanza yina bawu ke vwandaka. Kana yawu kele kaka bivwandu ya mpamba to yawu kele ya kutungama na bibaka ya lukengolo. ");
INSERT INTO mkw_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Beno tala wapi mutindu kele yinsi. Kana yawu kele ntoto ya madya to ve. Kana yawu kele na bayinti to ve. Beno vwanda na ngolo. Beno nata bambuma ya yinsi. Yayi ni ntangu ya bambuma ya ntete ya vinu.» ");
INSERT INTO mkw_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Na manima, bawu kwendaka mpe bawu talaka yinsi, kubanda na yinsi ya kuyuma ya Sine tii na Leyobe, na nkotolo ya Amate. ");
INSERT INTO mkw_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ba lutilaka na Nengeve tii na Ebelone kisika vwandaka Ayimane, Sesayi mpe Talemayi. Bawu nyonso bana ya Anake. Mbanza Ebelone kutungama bamvula nsambwadi tekila mbanza ya Sowane ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Bawu kumaka tii na muzumba ya Esekole. Kuna, bawu zengaka kintala mosi ya yinti ya vinu, kikanka mosi ya bambuma ya vinu mpe bawu nataka yawu. Bawu bakaka mpe bambuma ya bangelenade mpe ya fike. Bawu natinaka bambuma yina na bayinti, bantu zole-zole na yinti mosi. ");
INSERT INTO mkw_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ba pesaka kisika yina nkumbu ya Muzumba ya Esekole, yina zola kutuba: muzumba ya kikanka, samu ti bana ya Isayeli zengaka kikanka ya bambuma ya vinu kuna. ");
INSERT INTO mkw_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Na manima ya bilumbu makumi yiya, bantu yina kwendaka tala mbote-mbote na mansweki yinsi ya kaana vutukaka. ");
INSERT INTO mkw_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ntangu bawu vutukaka, bawu kwendaka na sika ya Moyize, Aloni mpe mukangu nyonso ya bana ya Isayeli, kuna na Kadese, yinsi ya kuyuma ya Palane. Bawu pesaka bawu bansangu yina bawu nataka. Bawu pesaka yawu mpe na mukangu nyonso ya bana Isayeli, mpe bawu lakisaka bawu bambuma ya yinsi. ");
INSERT INTO mkw_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ba zonzaka mutindu yayi: «Beto kwendaka na yinsi yina nge fidisaka beto. Ya tsyelika, ya kele yinsi yina me fuluka na mafuta ya nyosi na miliki. Bambuma ya yawu, yawu yayi. ");
INSERT INTO mkw_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Kasi bantu yina ke vwandaka na yinsi yango kele na ngolo mingi. Bambanza ya bawu kele ya kutungama na bibaka ya lukengolo mpe yawu kele nene mingi. Beto vwandaka me tala mpe bana ya Anake kuna. ");
INSERT INTO mkw_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ba-Amaleke vwandaka zinga na Nengeve. Ba-Iti, ba-Yebuse mpe ba-Amoli vwandaka zinga na kizunga ya myongo. Ba-Kaanani vwandaka zinga pene-pene ya mubu mpe na kumu ya nzadi ya Yolodani.» ");
INSERT INTO mkw_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalebe kangisaka bantu yinwa na meso ya Moyize. Yandi tubaka mutindu yayi: «Beto kwendeno, beto bakeno yinsi yango. Beto ke nunga!» ");
INSERT INTO mkw_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kasi bantu yina kwendaka tala yinsi kintwadi na Kalebe, bawu tubaka na yandi: «Beto lenda kwenda nwanisa bantu yina ve, samu ti bawu me lutila beto ngolo!» ");
INSERT INTO mkw_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Na mantwala ya bana ya Isayeli, bawu bandaka na kuzonzila yinsi mutindu bawu tadilaka yawu na mansweki. Bawu tubaka: «Yinsi yango, beto me tambula na kati ya yawu samu na kutala yawu mbote-mbote na mansweki. Yawu kele yinsi mosi yina ke kudyaka bayina ke zingaka kuna. Bantu nyonso yina beto talaka kuna, bawu kele bantu ya mitela ya yinda. ");
INSERT INTO mkw_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Beto talaka kuna ba-Nefilime, bana ya Anake yina kele mosi ya ba-Nefilime. Beto vwandaka kukitala beto mosi mutindu mwa makonko. Bawu mpe vwandaka tala beto mutindu yina.» ");
INSERT INTO mkw_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mukangu nyonso ya Isayeli bandaka na kulooka. Bawu lutisaka mpimpa ya muvimba na kudila. ");
INSERT INTO mkw_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Bantu nyonso ya Isayeli vungutilaka Moyize mpe Aloni. Mukangu nyonso ya Isayeli vwandaka tuba na bawu: «Ya vwandaka kwandi mbote ti beto kufwa na yinsi ya Ngipiti. Ya vwandaka kwandi mbote ti beto kufwa na yinsi ya kuyuma yayi! ");
INSERT INTO mkw_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Samu na yinki Yave ke na kunata beto na yinsi yina, kisika ba ke kufwa beto na mvita? Bakento ya beto na bana ya beto, ba ke botola bawu. Ya me lutila ve kwandi mbote ti beto vutuka na yinsi ya Ngipiti?» ");
INSERT INTO mkw_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Bawu vwandaka zonza bawu na bawu: «Beto soola mfumu ya nkaka, mpe beto vutukeno ya beto na yinsi ya Ngipiti.» ");
INSERT INTO mkw_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Moyize mpe Aloni kubwaka bizizi na ntoto, na mantwala ya mukangu nyonso ya bana ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Na kati ya bayina kwendaka tala mbote-mbote yinsi yina na mansweki, ya vwandaka na Yeswa, mwana ya Nune mpe Kalebe, mwana ya Yefune. Bawu pasulaka binkuti ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Bawu tubaka na mukangu nyonso ya bana ya Isayeli: «Yinsi yango, beto me tambula na kati ya yawu samu na kutala yawu mbote-mbote na mansweki. Yawu kele yinsi mosi ya mbote mingi. ");
INSERT INTO mkw_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kana Yave me yangalala na beto, yandi ke kotisa beto na yinsi yango, mpe yandi ke pesa beto yawu. Ya kele yinsi yina me fuluka na miliki na mafuta ya nyosi. ");
INSERT INTO mkw_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Kasi beno balukila ve Yave. Beno vwanda ve na boma ya bantu ya yinsi yina. Beto ke nunga bawu kaka na mbala mosi. Samu ti banzambi yina vwandaka keba bawu me bika bawu. Kasi Yave kele na beto. Beno vwanda ve na boma.» ");
INSERT INTO mkw_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mukangu nyonso vwandaka zonza ti ba kufwa bawu na matadi. Kasi na mbala mosi, nkembo ya Yave talanaka kuna na Yinzo ya Mbwabanu, na meso ya bana nyonso ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yave tubaka na Moyize: «Tii wapi ntangu bantu yayi ke safula munu? Mu ke na kulakisa bimangu mingi na kati-kati ya bawu, kasi tii wapi ntangu bawu ke tatamana na kumanga na kutula kiminu ya bawu na munu? ");
INSERT INTO mkw_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mu ke fidisa bawu kiyoolo, mpe mu ke katula bawu mvwilu nyonso. Kasi nge, mu ke sala ti nge kubuta dikanda yina me lutila bawu nene mpe ngolo.» ");
INSERT INTO mkw_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moyize vutulaka na Yave: «Bantu ya Ngipiti kuwaka ti nge sadilaka lulendo ya nge na kubasisa bantu yayi na yinsi ya Ngipiti. ");
INSERT INTO mkw_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Mpe ba zabisaka yawu na bantu ya yinsi yayi ya Kaana. Bantu ya Kaana kuwaka ti nge Yave, nge kele na kati-kati ya bantu yayi ya Isayeli. Bawu kuwaka ti nge Yave, nge ke talanaka na bawu kizizi-na-kizizi. Bawu kuwaka ti dituti ya nge ke vwandaka na bawu. Bawu kuwaka ti nge ke tambulaka na mantwala ya bawu, na ntangu, na dituti ya nene ya kutelama, mpe na mpimpa, na mulaka ya tiya ya kutelama. ");
INSERT INTO mkw_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Bubu yayi, kana nge kufwa bantu yayi na mbala mosi, bantu ya bayinsi ya nkaka yina me kuwa nsangu ya nge ke tuba: ");
INSERT INTO mkw_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“Yave lendaka ve na kukotisa bantu yayi na yinsi yina yandi kudyaka ndefi na kupesa bawu. Ni yawu yina, yandi me kufwa bawu nyonso na yinsi ya kuyuma.” ");
INSERT INTO mkw_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ntangu yayi, mulemvo ya nge, bika ti lulendo ya Mfumu kutalana na bunene ya yawu nyonso mutindu nge tubaka yawu ti: ");
INSERT INTO mkw_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","“Yave ke na mvibudulu, mpe kukwikama ya yandi kele ya nene. Yandi ke lemvokilaka foti mpe yimbi. Yandi ke sembaka muntu yina me sala yimbi. Masumu ya batata, yandi ke futisaka yawu na bana ya bawu tii na mbandu ya tatu, mpe na mbandu ya yiya.” ");
INSERT INTO mkw_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Mulemvo ya nge, lemvokila yimbi ya bantu yayi, mutindu kele kukwikama ya nge ya nene. Lemvokila bawu mutindu nge ke lemvokilaka bawu kubanda na yinsi ya Ngipiti tii kwaku.» ");
INSERT INTO mkw_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yave vutulaka: «Mu me lemvokila bawu mutindu nge me lomba. ");
INSERT INTO mkw_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Kasi mu me kudya ndefi na nkumbu ya munu mosi, na nkembo ya munu Yave yina me fuluka na ntoto nyonso. ");
INSERT INTO mkw_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Na kati ya bantu nyonso yina me tala nkembo ya munu, na bimangu yina mu salaka na yinsi ya Ngipiti mpe na yinsi ya kuyuma, bayina me sombola munu yimeni bambala kumi, mpe me tumama ve na munu, ");
INSERT INTO mkw_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","na kati ya bantu nyonso yina, ata mosi ke tala yinsi yina mu sadilaka nsilulu mpe yina mu diilaka ndefi na kupesa na bankooko ya bawu. Ata mosi na kati ya bayina me safula munu ke tala yinsi yango. ");
INSERT INTO mkw_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Kasi kisadi ya munu Kalebe, ni mpeve ya nkaka me twadisa yandi. Yandi me tumama na munu. Na yina, mu ke kotisa yandi na yinsi yina yandi vwandaka me kwenda tala. Bana ya yandi ke baka yinsi yango mutindu mvwilu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Ba-Amaleke na ba-Kaanani ke zingaka na mudimba yayi.) Mbasi, beno ke vutuka na yinsi ya kuyuma, na nzila ya mubu ya Batwandu.» ");
INSERT INTO mkw_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yave tubaka na Moyize mpe Aloni mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Tii wapi ntangu mukangu yayi ya yimbi ke tatamana na kuvungutila munu? Mu me kuwa mutindu bantu ya Isayeli me vungutila munu. ");
INSERT INTO mkw_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Tuba na bawu: “Yave ke na kutuba: Mu me kudya ndefi na nkumbu ya munu mosi. Mu ke sadila beno mutindu beno mosi me zonza na ntadisi ya munu. ");
INSERT INTO mkw_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Beno ke kufwa na yinsi yayi ya kuyuma. Beno bayina nyonso ba tangaka mpe ba sonikaka bankumbu kubanda na bayina kele na bamvula makumi zole tii na zulu, beno bayina me vungutila munu. ");
INSERT INTO mkw_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Beno ke kota ve na yinsi yina mu diilaka ndefi, ntangu mu nangunaka diboko na kutuba ti mu ke tula beno kuna. Kaka Kalebe, mwana ya Yefune mpe Yeswa, mwana ya Nune ke kota na yinsi yina. ");
INSERT INTO mkw_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Kasi bana ya beno yina beno tubaka ti bawu ke kubwa na maboko ya bambeni ya beno, mu ke nata bawu mpe bawu ke zaba yinsi yina beno me manga. ");
INSERT INTO mkw_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Kasi beno, beno ke kufwa na yinsi yayi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Bana ya beno ke vwanda mivungi na yinsi ya kuyuma bamvula makumi yiya. Ba ke tala bampasi samu na kondwa kukwikama ya beno. Yawu ke vwandila mutindu yina tii ntangu beno nyonso ke manisa na kufwa na yinsi ya kuyuma. ");
INSERT INTO mkw_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Mutindu kele lutangu ya bilumbu yina beno salaka na kutala mbote-mbote yinsi na mansweki, yawu zola kutuba ti beno mpe ke lungisa bamvula makumi yiya na kutalaka mpasi. Ya ke vwanda mvula mosi samu na kilumbu mosi. Na yina, beno ke zaba kubalukila munu kele yinki. ");
INSERT INTO mkw_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ni mutindu yina munu Yave me zonza. Ni mutindu yina mu ke sala na mukangu nyonso yayi ya yimbi yina me balukila munu. Bawu nyonso ke kufwa na yinsi yayi ya kuyuma. Bawu ke manisa na kufwa kwaku.» ");
INSERT INTO mkw_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Babakala yina Moyize fidisaka na kwenda tala mbote-mbote yinsi na mansweki, bayina na ntangu ba vutukaka, salaka ti mukangu nyonso ya bantu kuvungutila Moyize samu na mambu ya yimbi yina bawu zonzaka na yina me tadila yinsi yango, ");
INSERT INTO mkw_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","babakala yango yina zonzaka mambu ya yimbi na yina me tadila yinsi, bawu kufwaka na kiyoolo na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Na kati ya bantu nyonso yina kwendaka tala mbote-mbote yinsi na mansweki, kaka ni Yeswa, mwana ya Nune mpe Kalebe, mwana ya Yefune bikanaka moyo. ");
INSERT INTO mkw_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moyize tubaka mambu nyonso yayi na bana nyonso ya Isayeli. Na yina, bantu kotaka na kifwidi ya nene. ");
INSERT INTO mkw_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Bawu telamaka na suka-suka samu na kuyuluka na nsongi ya mongo. Bawu vwandaka zonza mutindu yayi: «Beto bawu yayi, beto ke yuluka na kisika yina Yave zonzilaka. Ya tsyelika, beto me sala disumu!» ");
INSERT INTO mkw_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moyize tubaka na bawu: «Samu na yinki beno ke na kutumama ve na ntumunu ya Yave? Ya ke simba ve. ");
INSERT INTO mkw_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Beno yuluka kuna ve. Yave kele ve kintwadi na beno. Beno kwenda kubwa ve na maboko ya bambeni ya beno. ");
INSERT INTO mkw_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ba-Amaleke mpe ba-Kaanani kele kuna na mantwala ya beno. Ba ke kufwa beno na mvita. Mutindu beno me bika Yave, Yave mpe ke vwanda ve kintwadi na beno.» ");
INSERT INTO mkw_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Bana ya Isayeli salaka yintu ngolo. Bawu yulukaka na nsongi ya mongo. Kasi Moyize na Sanduku ya Ngwisani ya Yave bikaka ve kivwandu. ");
INSERT INTO mkw_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Na yina, ba-Amaleke mpe ba-Kaanani yina vwandaka zinga na mongo yango, bawu kulumukaka. Bawu kufwaka bana ya Isayeli mpe bawu sasaka bawu tii na bwala Olema. ");
INSERT INTO mkw_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Zonza na bana ya Isayeli mutindu yayi: ntangu beno ke kota na yinsi yina beno ke zinga, yinsi yina mu ke na kupesa beno, ");
INSERT INTO mkw_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","beno ke pesa na Yave minkayulu. Beno ke pesa minkayulu yina ba ke yokaka na tiya, ya vwanda minkayulu ya kuyoka, ya vwanda minkayulu yina beno ke pesaka na luzolo ya beno mosi, to samu na kulungisa nsilulu, to samu na balukutakanu ya mikembo ya beno. Na yina, beno ke baka bangombe, mameme to bankombo samu ti yawu kupesa nsunga yina ke yangidikaka Yave. ");
INSERT INTO mkw_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Muntu yina ke pesa dikabu ya yandi na Yave, yandi ke pesa mpe Munkayulu ya madya ya bilanga. Yawu ke vwanda kikunku mosi na kati ya bikunku kumi ya Efa ya faline ya kitoko yina ba me vukisa bikunku yiya na kati ya bikunku kumi ya Yine ya mafuta. ");
INSERT INTO mkw_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Nge ke pesa dyaka bikunku yiya na kati ya bikunku kumi ya Yine ya vinu kintwadi na Munkayulu ya Kuyoka to munkayulu ya nkaka samu na konso dimeme. ");
INSERT INTO mkw_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Samu na konso nkombo ya mbakala, nge ke pesa bakilo ya faline ya kitoko yina ba me vukisa na bikunku tatu na kati ya bikunku kumi ya Yine ya mafuta, mutindu munkayulu ya bilanga. ");
INSERT INTO mkw_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Nge ke pesa mpe bikunku tatu na kati ya bikunku kumi ya Yine ya vinu samu na munkayulu ya vinu. Nge ke pesa madya yina mpe nsunga ya yawu ke yangidika Yave. ");
INSERT INTO mkw_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Kana nge me pesa na Yave mwana ya ngombe ya mbakala, ya vwanda samu na Munkayulu ya Kuyoka, to samu na munkayulu ya kulungisa nsilulu, to samu na Munkayulu ya Kiwisa, ");
INSERT INTO mkw_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","nge ke pesa, kintwadi na mwana ya ngombe yina ya mbakala, Munkayulu ya madya ya bilanga ya bikunku tatu na kati ya bikunku kumi ya Efa ya faline ya kitoko yina ba me vukisa na ndambu ya Yine ya mafuta. ");
INSERT INTO mkw_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Nge ke pesa mpe ndambu mosi ya Yine ya vinu. Yawu kele madya yina ba me yoka na tiya. Nsunga ya yawu ke yangidikaka Yave. ");
INSERT INTO mkw_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ni mutindu yina beno ke sala samu na konso ngombe ya mbakala, konso dimeme ya mbakala, konso mwana ya dimeme, mpe konso nkombo. ");
INSERT INTO mkw_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ni mutindu yina beno ke sala samu na bibulu nyonso yina beno ke pesa, mutindu kele lutangu ya yawu. ");
INSERT INTO mkw_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Konso muntu ya Isayeli ke landa bansalulu yayi ntangu yandi ke pesa minkayulu yina ba ke yokaka na tiya, yina nsunga ya yawu ke yangidikaka Yave. ");
INSERT INTO mkw_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Na bambandu nyonso ya beno, nzenza yina ke zingaka na kati ya beno to nzenza yina kele na kati ya beno samu na mwa ntangu, kana yandi pesa munkayulu yina ba ke yokaka na tiya, yina nsunga ya yawu ke yangidikaka Yave, yandi fwana kusala yawu na mutindu beno mpe ke sadila yawu. ");
INSERT INTO mkw_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Bansalulu ke vwanda kaka mosi samu na mukangu nyonso, samu na beno, mpe samu na banzenza yina ke vwanda na kati-kati ya beno. Ya kele bansalulu ya bantangu nyonso, samu na bambandu nyonso ya beno. Ya ke vwandila kaka mutindu mosi samu na nzenza mpe samu na beno na mantwala ya Yave. ");
INSERT INTO mkw_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Musiku ke vwanda kaka mosi. Bansalulu ya misiku mpe ke vwanda kaka mosi, samu na beno mpe samu na banzenza yina ke vwanda na kati-kati ya beno.» ");
INSERT INTO mkw_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yave tubaka na Moyize na kuzonza ");
INSERT INTO mkw_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","na bana ya Isayeli mutindu yayi: «Ntangu beno ke kuma na yinsi yina mu ke nata beno, ");
INSERT INTO mkw_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ntangu beno ke kudya mampa ya yinsi yina, beno ke katula kikunku ya Yave. ");
INSERT INTO mkw_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ntangu beno ke lamba mampa ya beno, beno ke katudila munu gato na kati ya kiputi ya ntete. Beno ke katudila munu yawu mutindu ba ke katudilaka munu kikunku na kisika yina ba ke kabulaka bambuma na matiti ya yawu. ");
INSERT INTO mkw_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Na kusalaka mutindu yina, beno ke pesa kikunku ya ntete ya kiputi ya beno na Yave. Yawu ke vwandila mutindu yina na bambandu nyonso ya beno.» ");
INSERT INTO mkw_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Kana beno me sala yimbi yina beno me kanisa ve, na kutumama ve na bantumunu yina Yave pesaka na Moyize, ");
INSERT INTO mkw_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","nyonso yina Yave tumisaka beno na yinwa ya Moyize, katuka kilumbu yina Yave pesaka bantumunu yango, mpe na bambandu nyonso ya beno, ");
INSERT INTO mkw_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","kana yimbi yango me salama, mpe mukangu ya bantu me zaba ve ti bawu me sala yimbi, mukangu nyonso ke pesa ngombe ya mbakala samu na Munkayulu ya Kuyoka. Nsunga ya yawu ke yangidikaka Yave. Ba ke pesa yawu kintwadi na munkayulu ya yawu ya madya ya bilanga mpe munkayulu ya vinu mutindu kele ntumunu ya yawu. Bawu ke pesa mpe dimeme ya mbakala samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Nganga-Nzambi ke sala kisalu samu na kukatula masumu ya mukangu nyonso ya bana ya Isayeli. Mpe Yave ke lemvokila bawu. Ya tsyelika ya vwandaka yimbi ya kukanisa ve, mpe bawu me pesa munkayulu yina ba ke yokaka na tiya samu na Yave. Bawu me pesa munkayulu samu na kukatula masumu na ntadisi ya Yave, samu na yimbi ya bawu yina bawu kanisaka ve. ");
INSERT INTO mkw_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Yave ke lemvokila mukangu nyonso ya bana ya Isayeli, mpe banzenza yina kwizaka zinga mwa ntangu fyoti na kati-kati ya bawu. Ya tsyelika, na dyambu yina, bantu nyonso salaka yimbi yina bawu kanisaka ve na kusala. ");
INSERT INTO mkw_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kana kaka muntu mosi me sala yimbi yina yandi kanisaka ve, yandi fwana kupesa munu nkombo ya mvula mosi samu na Munkayulu ya mulemvo. ");
INSERT INTO mkw_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Nganga-Nzambi ke sala na mantwala ya Yave kisalu samu na kukatula disumu ya muntu yina me sala yimbi yina yandi kanisaka ve. Ntangu nganga-Nzambi ke sala kisalu yina, Yave ke lemvokila yandi. ");
INSERT INTO mkw_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Na yina me tadila yimbi yina muntu me kanisa ve na kusala, Musiku ke vwanda kaka mosi, ya vwanda samu na muntu ya Isayeli to samu na nzenza yina zinga mwa ntangu fyoti na kati-kati ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Kasi kana muntu ya Isayeli to nzenza me sala yimbi yina yandi kanisaka yandi mosi na kusala, yandi me finga Yave. Ba fwana kukatula yandi na kati ya bantu ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Yandi me zitisa ve mambu ya Yave mpe yandi me sumuna Musiku ya yandi. Ba ke katula yandi na kimvuka ya bantu ya Isayeli, mpe disumu ya yandi ke vwanda na zulu ya yintu ya yandi mosi. ");
INSERT INTO mkw_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ntangu bana ya Isayeli vwandaka na yinsi ya kuyuma, ba talaka muntu mosi yina vwandaka lokota bankuni kilumbu ya Saba. ");
INSERT INTO mkw_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Bantu yina talaka yandi na ntangu yina yandi vwandaka lokota bankuni, bawu nataka yandi na mantwala ya Moyize, Aloni mpe mukangu nyonso ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ba bumbaka yandi ntete na mwa kisika mosi, samu ti ba vwandaka me kuzwa ntete ve ntumunu na kuzaba yinki ba ke sala yandi. ");
INSERT INTO mkw_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Yave tubaka na Moyize: «Ba fwana kufwa muntu yina. Mukangu nyonso ke kufwa yandi na kubula yandi matadi na ngaanda ya kivwandu.» ");
INSERT INTO mkw_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Mukangu nyonso nataka yandi na ngaanda ya kivwandu mpe bawu bulaka yandi matadi. Yandi kufwaka mutindu Yave tumisaka yawu na Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Zonza na bana ya Isayeli ti bawu na bana ya bawu na bambandu yina ke kwiza, bawu fwana kutula bitende na bansongi ya binkuti ya bawu. Bawu tula singa ya ntinta ya dizulu na bitende yina, na nsuka ya biyunga ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Beno ke banda na kulwataka binkuti yina ke na bitende na nsuka ya yawu. Ntangu beno ke tala bitende yina, beno ke bambuka moyo na bantumunu nyonso ya Yave, samu na kusadila yawu. Beno ke landa ve bansatu ya ntima ya beno, mpe ya meso ya beno yina lenda nata beno na kusadila kindumba na banzambi ya nkaka. ");
INSERT INTO mkw_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Na yina, beno ke bambuka moyo na bantumunu nyonso ya munu mpe beno ke sadila yawu. Beno ke vwanda bantu ya longo samu na munu Nzambi ya beno. ");
INSERT INTO mkw_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mu kele Yave, Nzambi ya beno. Ni munu basisaka beno na Ngipiti samu na kuvwanda Nzambi ya beno. Mu kele Yave, Nzambi ya beno.» ");
INSERT INTO mkw_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Mu-Levi mosi na nkumbu ya Kole, mwana ya Isale, ya dikanda ya Keyate bakaka bana tatu yayi ya Lubene: Datane, Abilame mwana ya Elyabe mpe One mwana ya Pelete. ");
INSERT INTO mkw_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Bawu kintwadi na bankama zole na makumi tanu (250) ya bana ya Isayeli ya nkaka, bawu balukilaka Moyize. Ya vwandaka bamfumu ya mukangu, bimonikisi ya mukangu, bantu ya buzitu. ");
INSERT INTO mkw_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Bawu kwendaka zunga Moyize mpe Aloni. Bawu zonzaka na bawu: «Ya me lunga! Bantu nyonso ya mukangu ya Isayeli kele ya longo, mpe Yave kele na kati-kati ya bawu. Samu na yinki beno ke na kulakisa ti ni beno me lutila mukangu nyonso ya Yave?» ");
INSERT INTO mkw_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ntangu Moyize kuwaka mambu yina, yandi kubwaka kizizi na ntoto. ");
INSERT INTO mkw_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Yandi tubaka na Kole mpe na nkonga ya yandi mutindu yayi: «Mbasi na suka, Yave ke lakisa nani kele ya yandi, mpe nani kele ya longo. Yandi ke bika ti muntu yango kubelama na ntadisi ya yandi. Muntu yina Yave me soola, ni muntu yina Yave ke bika ti yandi kubelama na yandi. ");
INSERT INTO mkw_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Tala, beno sala mutindu yayi: Kole, nge na nkonga ya nge, beno baka bima ya kuyokilaka maaka ya nsunga ya mbote. ");
INSERT INTO mkw_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Mbasi beno ke tula tiya na kati ya yawu. Beno ke tula na tiya yina maaka ya nsunga ya mbote, na mantwala ya Yave. Muntu yina Yave ke soola, ni yandi kele ya longo. Ya me lunga mutindu yina, beno bana ya Levi!» ");
INSERT INTO mkw_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moyize tubaka dyaka na Kole: «Beno bana ya Levi, beno kuwa! ");
INSERT INTO mkw_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Yave Nzambi ya Isayeli soolaka beno na kati ya mukangu ya Isayeli. Yandi me sala ti beno kubelamaka na yandi samu na kusalaka kisalu ya Yinzo ya Yave. Yandi me sala ti beno kusala kisalu ya beno na nkumbu ya mukangu nyonso. Beno ke na kutala ti ya me lunga ve? ");
INSERT INTO mkw_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Yave me bika ti beno kubelamaka na yandi, nge na bampangi ya nge nyonso bana ya Levi kintwadi na nge. Awa beno ke na kusosa dyaka na kuvwanda na kisalu ya bunganga-Nzambi! ");
INSERT INTO mkw_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ni yawu yina, nge na nkonga ya nge, beno ke na kusadila Yave mfundu ya yimbi. Aloni kele nani samu ti beno kuvungutila yandi?» ");
INSERT INTO mkw_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moyize fidisaka ba bokila Datane mpe Abilame, bana ya Elyabe. Kasi bawu vutulaka: «Beto ke kwiza ve! ");
INSERT INTO mkw_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Nge katulaka beto yimeni na yinsi yina kele ya kufuluka na miliki mpe mafuta ya nyosi, samu na kwiza kufwa beto na yinsi ya kuyuma. Ya me lunga na nge ve? Nge zola mpe kuyala beto? ");
INSERT INTO mkw_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ve! Ya kele ve yinsi ya kufuluka na miliki mpe na mafuta ya nyosi yina nge me nata beto. Ya kele ve bilanga mpe bilanga ya bayinti ya vinu nge me pesa beto samu ti yawu kuvwanda ya beto. Nge ke na kubanza ti bantu yayi ke na meso ya kufwa? Beto ke kwenda ya beto ve!» ");
INSERT INTO mkw_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moyize dasukaka mingi. Yandi tubaka na Yave: «Kutala minkayulu ya bawu ve. Mu me baka ata kima mosi ya bawu, ata mbuluku mosi ve. Mu me sala ve ata yimbi na mosi na bawu!» ");
INSERT INTO mkw_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moyize tubaka na Kole: «Nge na nkonga ya nge, beno ke belama mbasi na mantwala ya Yave, kintwadi na Aloni. ");
INSERT INTO mkw_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Muntu-muntu ke baka kima ya yandi ya kuyokilaka maaka ya nsunga ya mbote. Beno ke tula maaka ya nsunga ya mbote na kati ya yawu. Beno ke nata yawu na mantwala ya Yave. Bima yango ya kuyokilaka maaka ya nsunga ya mbote ke vwanda bankama zole na makumi tanu (250). Nge na Aloni mpe, beno ke vwanda muntu-muntu na kima ya yandi ya kuyokilaka maaka ya nsunga ya mbote.» ");
INSERT INTO mkw_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Kole na nkonga ya yandi bakaka muntu-muntu kima ya yandi ya kuyokilaka maaka ya nsunga ya mbote. Ba tulaka tiya na kati. Ba tulaka maaka ya nsunga ya mbote na tiya yango. Ba kwizaka telama na mwelo ya Yinzo ya Mbwabanu kintwadi na Moyize mpe Aloni. ");
INSERT INTO mkw_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kole kutikisaka mukangu nyonso ya Isayeli kuna na mwelo ya Yinzo ya Mbwabanu samu na kusukisa Moyize mpe Aloni. Na mpamukunu, nkembo ya Yave talanaka na mukangu nyonso. ");
INSERT INTO mkw_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Yave tubaka na Moyize mpe Aloni mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Beno kabuka na nkonga ya bantu yayi, samu ti mu ke manisa bawu nyonso kaka na mbala mosi.» ");
INSERT INTO mkw_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Kasi Moyize mpe Aloni kubwaka bizizi na ntoto. Bawu sambilaka mutindu yayi: «Nzambi, nge Nzambi yina ke simbaka kiwumunu ya nyonso yina ke zingaka, nge ke dasukila mukangu nyonso ya bantu samu ti muntu mosi me sala disumu?» ");
INSERT INTO mkw_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Zonza na mukangu ya Isayeli mutindu yayi: Beno katuka na balweka nyonso na bayinzo ya Kole, ya Datane mpe ya Abilame. Beno vwanda ntama na bayinzo ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moyize telamaka na kukwenda na sika ya Datane mpe Abilame. Bakuluntu ya Isayeli landaka yandi. ");
INSERT INTO mkw_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Moyize tubaka na mukangu nyonso: «Beno katuka na bayinzo ya bantu yayi ya yimbi. Beno simba ata kima mosi ve yina kele ya bawu. Kana ve, beno mpe, beno ke kufwa samu na masumu ya bawu.» ");
INSERT INTO mkw_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Bantu nyonso katukaka pene-pene ya balweka nyonso ya bayinzo ya Kole, Datane mpe Abilame. Datane mpe Abilame basikaka na bayinzo ya bawu, mpe telamaka na mwelo ya bayinzo ya bawu, na bakento ya bawu, na bana ya bawu mpe batekolo ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moyize tubaka: «Na dyambu yina ke salama awa, beno ke zaba ti ni Yave fidisaka munu na kusala bimangu nyonso yayi. Mu ke na kusala ve na ngolo ya munu mosi. ");
INSERT INTO mkw_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kana bantu yayi kufwa mutindu ke kufwaka bantu nyonso, kana bawu kuzwa mambu yina ke bwidilaka bantu nyonso, ya ke lakisa ti ya kele ve ni Yave fidisaka munu. ");
INSERT INTO mkw_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Kasi kana Yave sala dyambu ya ngitukulu, kana ntoto kuzibuka samu na kumina bawu mpe nyonso yina kele ya bawu, mpe ti bawu kukulumuka ya moyo na yinsi ya bantu ya kufwa, beno ke zaba ti bantu yayi me safula Yave.» ");
INSERT INTO mkw_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Kaka na ntangu yina Moyize manisaka na kuzonza mambu nyonso yina, ntoto zibukaka na yisi ya makulu ya Datane mpe Abilame. ");
INSERT INTO mkw_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Ntoto zibulaka yinwa ya yandi mpe minaka bawu, bawu na makanda ya bawu nyonso. Yawu minaka bantu nyonso ya Kole mpe mvwilu nyonso ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Bawu kulumukaka ya moyo na yinsi ya bantu ya kufwa. Bawu na nyonso yina kele ya bawu. Ntoto fukaka bawu, mpe bawu zimbanaka na kati ya mukangu ya Isayeli. ");
INSERT INTO mkw_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Na kulooka yina bantu yango vwandaka looka, bantu nyonso ya Isayeli yina vwandaka pene-pene na bawu bandaka na kukima na kwendaka tuba: «Ntoto kumina beto ve!» ");
INSERT INTO mkw_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Tiya mosi katukaka na sika ya Yave. Yawu yokaka mpe nyengisaka babakala bankama zole na makumi tanu (250) yina nataka maaka ya nsunga ya mbote. ");
INSERT INTO mkw_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yave tubaka na Moyize mutindu yayi: ");
INSERT INTO mkw_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Zonza na Eleyazale, mwana ya nganga-Nzambi Aloni na kukatula bima ya kuyokilaka maaka ya nsunga. Yandi kumwangisa tiya, samu ti bima yina kele ya longo. ");
INSERT INTO mkw_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Bantu yina me sala masumu mpe me kufwa samu na yawu, beno ke baka bima ya bawu ya kuyokilaka maaka ya nsunga ya mbote mpe beno ke tuta yawu samu na kuyidika bisengo ya kubongisila kiyokolo ya minkayulu. Ya tsyelika bima yango yina, ba pesaka yawu na Yave. Mpe yawu kele ya longo. Yawu ke vwanda kidimbu samu na bana ya Isayeli.» ");
INSERT INTO mkw_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Nganga-Nzambi Eleyazale bakaka biyokolo ya kisengo ya mbwaki yina nataka bantu yina kufwaka na tiya. Ba tutaka biyokolo yango ya maaka na kuyidika bisengo samu na kubongisa kiyokolo ya minkayulu. ");
INSERT INTO mkw_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Yawu ke sala ti bana ya Isayeli kubambuka moyo ti muntu yina kele ve ya kubyekwa, muntu yina kele ve muntu ya dikanda ya Aloni, yandi lenda kwiza yoka ve maaka ya nsunga ya mbote na mantwala ya Yave. Kana ve mambu yina me bwidila Kole na nkonga ya yandi ke bwidila yandi, mambu yina Yave tubaka na Aloni na yinwa ya Moyize. ");
INSERT INTO mkw_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Kilumbu yina landaka, mukangu nyonso ya Isayeli bandaka dyaka na kuvungutila Moyize mpe Aloni. Bawu vwandaka tuba: «Ni beno me kufwa bantu ya Yave!» ");
INSERT INTO mkw_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mukangu ya bantu yonzamaka samu na kutelemina Moyize mpe Aloni. Ntangu bawu balukaka na lweka ya Yinzo ya Mbwabanu, bawu talaka ti dituti fukaka Yinzo ya Mbwabanu, mpe nkembo ya Yave talanaka. ");
INSERT INTO mkw_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Moyize mpe Aloni kwendaka na mantwala ya Yinzo ya Mbwabanu. ");
INSERT INTO mkw_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«Beno vwanda ntama ya mukangu ya bantu yayi, samu ti mu ke manisa bawu nyonso kaka na mbala mosi.» Moyize mpe Aloni kubwaka bizizi na ntoto. ");
INSERT INTO mkw_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moyize tubaka na Aloni: «Baka kiyokolo ya nge ya maaka. Sadila yawu na kubaka tiya na kiyokolo ya minkayulu. Tula maaka ya nsunga ya mbote na tiya yango. Kwenda nswalu na sika ya mukangu ya bantu mpe sala nyonso yina me fwanana samu na kukatula masumu ya bawu. Samu ti nkele me basika na mantwala ya Yave. Kiyoolo me banda yimeni!» ");
INSERT INTO mkw_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aloni bakaka kiyokolo ya yandi ya maaka mutindu Moyize zabisaka yandi. Yandi kimaka mbangu na kukwenda na kati-kati ya mukangu ya bantu. Kiyoolo vwandaka me banda na kutalana na bantu. Aloni yokaka maaka ya nsunga ya mbote mpe yandi salaka nyonso yina me fwanana samu na mulemvo ya masumu ya bawu. ");
INSERT INTO mkw_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Yandi telamaka na kati-kati ya bantu yina vwandaka me kufwa mpe bantu yina vwandaka ntete moyo mpe kiyoolo manisaka. ");
INSERT INTO mkw_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Kiyoolo yango kufwaka mafunda kumi na yiya na bankama nsambwadi (14 700) ya bantu ata kutanga bayina kufwaka na kati ya dyambu ya Kole. ");
INSERT INTO mkw_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Na manima, Aloni vutukaka na sika ya Moyize, kuna na mwelo ya Yinzo ya Mbwabanu. Kiyoolo vwandaka me manisa. ");
INSERT INTO mkw_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Yave tubaka na Moyize: ");
INSERT INTO mkw_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«Zonza na bana ya Isayeli na kupesa nge yinti mosi-mosi na konso kifumba, yawu ke vwanda bayinti kumi na zole. Nge ke sonika nkumbu ya konso kifumba na zulu ya yinti ya yawu. ");
INSERT INTO mkw_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Nge ke sonika nkumbu ya Aloni na zulu ya yinti ya kifumba ya Levi. Ya ke vwanda yinti mosi-mosi samu na konso mfumu ya kifumba. ");
INSERT INTO mkw_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Nge ke tula bayinti yango na kati ya Yinzo ya Mbwabanu, na mantwala ya Sanduku ya Ngwisani, kisika yina mu ke bwabanaka beno. ");
INSERT INTO mkw_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Yinti ya muntu yina mu ke soola, ni yina ke mena. Mu ke sala ti bana ya Isayeli bika na kuvungutilaka dyaka beno.» ");
INSERT INTO mkw_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Moyize zonzaka mambu yina na bana ya Isayeli. Bamfumu ya bawu nyonso natinaka yandi yinti mosi-mosi samu na konso kifumba. Bayinti yango vwandaka kumi na zole. Yinti ya Aloni vwandaka na kati-kati ya bayinti ya bawu nyonso. ");
INSERT INTO mkw_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Moyize tulaka bayinti nyonso na mantwala ya Yave, na kati ya Yinzo ya Ngwisani, na kisika ya kulutila longo. ");
INSERT INTO mkw_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Kilumbu yina landaka, Moyize kotaka na kati na Yinzo, na kisika ya kulutila longo. Yandi talaka ti yinti ya Aloni, yina vwandaka samu na kifumba ya Levi, vwandaka me mena. Yawu basisaka mwa yintu, bifulu mpe bambuma ya ba-amande. ");
INSERT INTO mkw_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Moyize katulaka bayinti nyonso na mantwala ya Yave mpe yandi lakisaka yawu na sika ya bana nyonso ya Isayeli. Bawu talaka yawu mpe konso muntu bakaka yinti ya yandi. ");
INSERT INTO mkw_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Yave tubaka dyaka na Moyize: «Vutula yinti ya Aloni na mantwala ya Sanduku ya Ngwisani, samu na kubumba yawu mutindu kidimbu samu na bayina zola kutumama ve. Na yina, nge ke kabikisa bawu na kuvungutila munu Yave. Mpe bawu ke kufwa ve.» ");
INSERT INTO mkw_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Moyize salaka mutindu Yave tumisaka yandi. Yandi salaka mutindu yina. ");
INSERT INTO mkw_vpl VALUES ("NU17_27","005_17_27","NUM","