﻿USE sofia;
DROP TABLE IF EXISTS sofia.mksNT_vpl;
CREATE TABLE mksNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mksNT_vpl WRITE;
INSERT INTO mksNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ña̱ yóho cúú qui̱vi̱ na̱ na̱sa̱cuu tásáhnu jícó Jesucristo, mé a̱ na̱quixi chi̱chi David xi̱hín chi̱chi Abraham: ");
INSERT INTO mksNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham na̱sa̱cuu tátá Isaac ta Isaac na̱sa̱cuu tátá Jacob ta Jacob na̱sa̱cuu tátá Judá xi̱hín java ga̱ ñani da. ");
INSERT INTO mksNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá na̱sa̱cuu tátá Fares xi̱hi̱n Zara ta náná ndíví da̱ yóho na̱sa̱naní ña̱ Tamar. Ta Fares na̱sa̱cuu tátá Esrom ta Esrom na̱sa̱cuu tátá Aram. ");
INSERT INTO mksNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ta Aram na̱sa̱cuu tátá Aminadab ta Aminadab na̱sa̱cuu tátá Naasón ta Naasón na̱sa̱cuu tátá Salmón. ");
INSERT INTO mksNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ta Salmón na̱sa̱cuu tátá Booz, da̱ cúú ja̱hyi ñá naní Rahab. Booz na̱sa̱cuu tátá Obed ta Obed yóho na̱sa̱cuu da ja̱hyi ñá naní Rut cán. Ta mé Obed yóho na̱sa̱cuu tátá Isaí. ");
INSERT INTO mksNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ta Isaí na̱sa̱cuu tátá rey David ta rey David yóho na̱sa̱cuu tátá Salomón, da̱ cúú ja̱hyi ñá na̱sa̱cuu ñájíhí Urías nu̱ cuítí cán. ");
INSERT INTO mksNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ta Salomón na̱sa̱cuu tátá Roboam ta Roboam na̱sa̱cuu tátá Abías ta Abías yóho na̱sa̱cuu tátá Asa. ");
INSERT INTO mksNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ta Asa na̱sa̱cuu tátá Josafat ta Josafat na̱sa̱cuu tátá Joram ta Joram na̱sa̱cuu tátá Uzías. ");
INSERT INTO mksNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ta Uzías na̱sa̱cuu tátá Jotam ta Jotam na̱sa̱cuu tátá Acaz ta Acaz na̱sa̱cuu tátá Ezequías. ");
INSERT INTO mksNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ta Ezequías na̱sa̱cuu tátá Manasés ta Manasés na̱sa̱cuu tátá Amón ta Amón na̱sa̱cuu tátá Josías. ");
INSERT INTO mksNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ta Josías na̱sa̱cuu tátá Jeconías xi̱hi̱n java ga̱ ñani da. Ta na̱sa̱cuu da tiempo tá na̱tiin soldado na̱ Israel já na̱sa̱ndaca ñahá da̱ na̱ cán ñuu Babilonia. ");
INSERT INTO mksNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ta tá na̱sanduu na̱ Israel ñuu Babilonia cán já na̱cacu Salatiel ta tátá Salatiel na̱sa̱cuu Jeconías. Ta Salatiel na̱sa̱cuu tátá Zorobabel. ");
INSERT INTO mksNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ta Zorobabel na̱sa̱cuu tátá Abiud ta Abiud na̱sa̱cuu tátá Eliaquim ta Eliaquim na̱sa̱cuu tátá Azor. ");
INSERT INTO mksNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ta Azor na̱sa̱cuu tátá Sadoc ta Sadoc na̱sa̱cuu tátá Aquim ta Aquim na̱sa̱cuu tátá Eliud. ");
INSERT INTO mksNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ta Eliud na̱sa̱cuu tátá Eleazar ta Eleazar na̱sa̱cuu tátá Matán ta Matán na̱sa̱cuu tátá Jacob. ");
INSERT INTO mksNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ta Jacob na̱sa̱cuu tátá José, da̱ na̱sa̱cuu yíi̱ María. Ta María cúú ñá na̱sa̱cuu náná Jesucristo, mé a̱ na̱chindahá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ña̱ cán quéa̱ ja̱nda̱ tá na̱casáhá cácu ja̱hyi Abraham ja̱nda̱ quia̱hva na̱xi̱nu̱ co̱o a qui̱ví na̱casáhá cácu ja̱hyi David já na̱ya̱ha u̱xu̱ co̱mi̱ generación. Ta tá quia̱hva na̱casáhá cácu ja̱hyi David ja̱nda̱ quia̱hva na̱tiin na̱ Babilonia na̱ Israel já ñéhe ñahá na̱ cua̱ha̱n na̱ na̱ya̱ha inga u̱xu̱ co̱mi̱ generación. Ta na̱ya̱ha inga u̱xu̱ co̱mi̱ generación nani na̱sa̱nduu na̱ Israel ñuu Babilonia ja̱nda̱ quia̱hva na̱xi̱nu̱ co̱o qui̱vi̱ na̱ca̱cu Jesús, mé a̱ na̱chindahá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Joho na̱sahi̱in tá na̱cacu Jesucristo: Mé María, ñá cacuu náná Jesús cán sa̱ na̱sa̱ha̱n ñá tu̱hun ñá ña̱ tanda̱ha̱ ñá xi̱hín José. Joo tá cáma̱ní coo da xi̱hi̱n ñá já na̱canda̱a̱ ini da ña̱ ñúhu ja̱hyi ñá. Ta ña̱ yóho na̱sa̱cuu a ña̱ na̱caja ínima̱ yi̱i̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ta José, da̱ cacuu yíi̱ María cán cúú dá da̱ cája ndinuhu ña̱ nda̱a̱. Ta na̱ca̱hán da̱ ña̱ na̱sahi̱in ñá xi̱hín inga da̱ta̱a joo co̱ó na̱xeen da ca̱ha̱n núu da sa̱ha̱ ñá nu̱ú ña̱yivi. Sa̱há ña̱ cán quéa̱ na̱sacu ini da jándacoo je̱hé da̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ta nani cáhvi ini da sa̱há ña̱ caja da a̱nda̱ jáví na̱quixi in sa̱ni nu̱ dá ta na̱nda̱ca̱ náha̱ in táto̱ Ndióxi̱ nu̱ dá. Ta tañu mé sa̱ni cán na̱ca̱ha̱n xi̱hi̱n dá. Já na̱cachi a já: —José, da̱ na̱quixi chi̱chi David, a̱ cáyi̱hví tohún tanda̱hún xi̱hi̱n María ja̱n jáchi̱ na̱caja ínima̱ yi̱i̱ Ndióxi̱ ña̱ ñúhu ja̱hyi ñá. ");
INSERT INTO mksNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ta tá sa̱ na̱cacu ja̱hyi María já chica̱a̱n ndó qui̱vi̱ á ná cananí a̱ Jesús jáchi̱ jáca̱cu a ña̱yivi nu̱ú cua̱chi tá ná candeé ini na mé á —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tócó ndihi ña̱ yóho na̱ya̱ha ña̱ ná xi̱nu̱ co̱o nu̱ú tu̱hun Ndióxi̱ ña̱ na̱ca̱hyí in profeta sa̱nahá ndiva̱ha cán ta já na̱cachi da̱ cán já: ");
INSERT INTO mksNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Va̱xi qui̱vi̱ cañuhu ja̱hyi in ñá tacú, ñá a̱ ñáha coo ta̱a xi̱hín. Ta tá sa̱ na̱cacu ja̱hyi ñá cán já cacu na qui̱vi̱ á cananí a̱ Emanuel. Ta tu̱hun yóho cúni̱ cachi a: íin Ndióxi̱ xo̱ho̱. ");
INSERT INTO mksNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ta tá na̱ndicáxí ini José já na̱caja da tá íin na̱cachi táto̱ Ndióxi̱ cán xi̱hi̱n dá. Ta já na̱tanda̱ha̱ dá xi̱hi̱n María. ");
INSERT INTO mksNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Joo co̱ó na̱sahi̱in da xi̱hín ña̱ tá quia̱hva íin in da̱ta̱a xi̱hi̱n ñájíhí da̱ ja̱nda̱ quia̱hva cacu ja̱hyi María. Ta tá na̱cacu a cán já na̱sacu José qui̱vi̱ á cananí a̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ta na̱cacu Jesús in ñuu naní Belén ña̱ ndáca̱a̱n estado Judea. Ta mé tiempo cán na̱sacomí rey Herodes cuéntá sa̱há nación Israel. Ta mé tañu já na̱xi̱nu̱ co̱o java na̱ ndi̱chí ñuu Jerusalén. Mé na̱ ndi̱chí yóho cúú ná na̱ jácuaha xi̱hín qui̱mi ta na̱quixi na chí nu̱ cána ca̱ndii. ");
INSERT INTO mksNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ta tá na̱xi̱nu̱ co̱o na ñuu Jerusalén já na̱nda̱ca̱ tu̱hún na̱ ña̱yivi já na̱cachi na já: —Ndájá íin da̱ loho na̱cacu viti ja̱n, da̱ cacuu rey nu̱ú na̱ Israel. Jáchi̱ na̱xini nde̱ na̱queta qui̱mi nu̱ú nde̱ ta xi̱hi̱n rí yóho sa̱ na̱canda̱a̱ ini nde̱ ña̱ sa̱ na̱cacu da. Ta viti va̱xi nde̱ yóho caja cáhnu nde̱ da̱ —na̱cachi na̱ ndi̱chí cán ndáca̱ tu̱hún na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ta tá na̱xini jo̱ho rey Herodes ña̱ yóho já na̱casáhá da̱ ndíhi ndiva̱ha ini da ta quia̱hva já na̱casáhá ndíhi ini tócó ndihi ña̱yivi ñuu Jerusalén cán. ");
INSERT INTO mksNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sa̱há ña̱ cán quéa̱ na̱cana rey Herodes cán tócó ndihi na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés cán. Ta já na̱nda̱ca̱ tu̱hún da̱ na̱ sa̱ha̱ ndá ñuu cúú nu̱ cáchí tu̱hun Ndióxi̱ cacu da̱ na̱sa̱ha̱n Ndióxi̱ tu̱hun a chindahá a̱ cacomí a̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Já na̱cachi na̱ cán já xi̱hi̱n dá: —Ñuu Belén, ña̱ ndáca̱a̱n estado Judea cán cúú nu̱ú cáchí tu̱hun Ndióxi̱ cacu da jáchi̱ quia̱hva já na̱ca̱hyí in profeta sa̱nahá tá na̱cachi da já: ");
INSERT INTO mksNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Va̱tí ñuu Belén, ña̱ ndáca̱a̱n estado Judea, cúú á in ñuu loho ndiva̱ha tañu ñuu náhnu cán joo íin sa̱há a̱, jáchi̱ tañu ña̱yivi ñuu cán ndindita in da̱ cacomí cuéntá sa̱há na̱ Israel, na̱ cúú cuéntá Ndióxi̱, já na̱ca̱hyí in profeta sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tá na̱ndihi já na̱cana xóo rey Herodes na̱ ndi̱chí cán ta já na̱nda̱ca̱ tu̱hún da̱ na̱ cán sa̱ha̱ ndá qui̱vi̱ na̱na̱ha̱ qui̱mi cán mé rí nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A̱nda̱ já na̱chindahá da̱ na̱ ñuu Belén. Já na̱cachi da já xi̱hi̱n ná: —Cuáhán ndo̱ ñuu Belén cán ta nda̱ca̱ tu̱hún va̱ha ndó ndaja cáa sa̱há ta̱a loho na̱cacu ja̱n. Ta tá sa̱ na̱ndiñehe ndó a̱ já quixi ndó ca̱xi tu̱hun ndó xi̱hín i̱ já ná cu̱hu̱n ri ye̱he̱ va caja cáhnu i̱ ña̱ —na̱cachi Herodes xi̱hín na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ta xi̱hín ña̱ yóho na̱quee na̱ ndi̱chí cua̱ha̱n tucu na. Ta qui̱mi, rí na̱xini na nu̱ cuítí cán já ndáca̱ tucu rí na̱ cua̱ha̱n na̱. Ta tá na̱xi̱nu̱ rí chí nu̱ú íin mé a̱ loho cán a̱nda̱ já na̱sa̱ca̱ndichi rí. ");
INSERT INTO mksNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ta cáji̱i̱ ndiva̱ha ini na tá xíni̱ na̱ mé qui̱mi cán. ");
INSERT INTO mksNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tá na̱ndihi já na̱qui̱hvi na ini vehe já na̱xini na mé a̱ loho cán xi̱hín María, náná a̱. Ta já na̱caxítí na̱ nu̱ á ta já na̱caja cáhnu na ña̱. Ta tá na̱ndihi já na̱suná na̱ yuhú sa̱to̱ ñéhe na ta já na̱jo̱co̱ na̱ jiu̱hu̱n cuáán nu̱ú a̱ xi̱hín ju̱sa va̱ha xi̱hín in ña̱ támi sáhan naní mirra nu̱ mé a̱ loho cán. ");
INSERT INTO mksNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tá na̱ndihi já na̱quixi in sa̱ni nu̱ ná ta xi̱hi̱n mé sa̱ni cán na̱cachi Ndióxi̱ xi̱hi̱n ná ña̱ ná a̱ ndícó co̱o na chí nu̱ íin rey Herodes. Sa̱há ña̱ cán quéa̱ na̱ndijama na íchi̱ cuánúhu̱ ná ñuu na. ");
INSERT INTO mksNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ta tá sa̱ na̱quee na̱ ndi̱chí cán cua̱ha̱n na̱ já na̱quixi in sa̱ni nu̱ú José ta na̱nda̱ca̱ náha̱ in táto̱ Ndióxi̱ nu̱ dá. Já cáchí a̱ já xi̱hi̱n dá: —Cuándaco̱ún ndiquehe ña̱ loho ja̱n xi̱hín María, náná a̱ ta cunún cu̱hu̱n xi̱hi̱n ná chí ñundáhyi̱ nación Egipto. Ta cán coún xi̱hi̱n ná ja̱nda̱ quia̱hva ná ca̱xi tu̱hun i̱ xu̱hu̱n. Jáchi̱ caca nuu Herodes ndinducú da̱ ña̱ loho ja̱n ña̱ cahní ñahá da̱ —na̱cachi táto̱ Ndióxi̱ cán xi̱hín José. ");
INSERT INTO mksNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A̱nda̱ já na̱ndaco̱o José já na̱quehe da Jesús xi̱hín María, náná a̱ já na̱queta ñuú na̱ cua̱ha̱n na̱ chí Egipto. ");
INSERT INTO mksNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ta cán na̱sa̱nduu na ja̱nda̱ quia̱hva na̱xi̱hi̱ Herodes. Tócó ndihi ña̱ yóho na̱ya̱ha já ná xi̱nu̱ co̱o nu̱ú tu̱hun na̱cachi Ndióxi̱ sa̱nahá tá na̱ca̱hyí in profeta já: “Na̱sahi̱in ja̱hyi i̱ nación Egipto ta na̱cana i̱ da̱ ná ndicó co̱o da”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ta ndaja coo na̱xini Herodes cán ña̱ na̱jándahvi na̱ ndi̱chí cán da̱ sa̱há ña̱ co̱ó na̱xi̱nu̱ ga̱ na̱ nu̱ dá. Ña̱ cán quéa̱ a̱ ju̱ú quia̱hva na̱xo̱jo̱ ini da. Ta chí na̱sahnda da chuun ña̱ ná cahní ndihi na ta̱a va̱lí, na̱ i̱vi̱ cui̱a̱ chí ni̱nu̱, mé na̱ ndúu ñuu Belén xi̱hín ñuu válí cátáhan xi̱hi̱n á. Jáchi̱ sa̱ na̱ca̱xi tu̱hun na̱ ndi̱chí cán xi̱hi̱n dá ña̱ na̱xini na mé qui̱mi a̱nda̱ tátu̱hun i̱vi̱ cui̱a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ta tá na̱ndihi na̱xi̱hi̱ na̱ va̱lí yóho já na̱xi̱nu̱ co̱o nu̱ú tu̱hun na̱ca̱hyí profeta Jeremías sa̱nahá ndiva̱ha tá na̱ca̱hyí da̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ñuu Ramá ja̱ndá joho ndáhví tácu̱ cáyuhú cóhó ñáñáha̱ sácu ñá. Ta ñá sácu yóho cúú ñá Raquel. Sácu ñá sa̱há ja̱hyi ñá. Ta co̱ cúni̱ ñá ndi̱co ini ñá jáchi̱ na̱xi̱hi̱ ja̱hyi ñá, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Joo tá sa̱ na̱xi̱hi̱ Herodes já na̱quixi tucu sa̱ni nu̱ú José nu̱ íin da nación Egipto cán. Ta na̱nda̱ca̱ náha̱ in táto̱ Ndióxi̱ nu̱ dá já cáchí a̱ já xi̱hi̱n dá: ");
INSERT INTO mksNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Cuándaco̱ún ta ndiquehe Jesús xi̱hi̱n María, náná a̱ ta cuáhán ndicó co̱o xi̱hi̱n ná chí ñundáhyi̱ Israel. Jáchi̱ sa̱ na̱xi̱hi̱ va na̱ ndúcú cahní ña̱ loho ja̱n —cáchí táto̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A̱nda̱ já na̱ndico̱o José ta ñéhe da Jesús xi̱hi̱n María, náná a̱ cua̱ha̱n na̱ ndícó co̱o na chí ñundáhyi̱ Israel. ");
INSERT INTO mksNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Joo tá na̱ñehe da tu̱hun ña̱ na̱ndicojo Arquelao chuun cacuu da rey nu̱ Herodes, tátá da̱ já na̱yi̱hví José cu̱hu̱n da̱ chí estado Judea. Ta sa̱há ña̱ sa̱ na̱ca̱xi tu̱hun táto̱ Ndióxi̱ tañu sa̱ni nu̱ dá sa̱há ña̱ cán quéa̱ na̱ndijama da íchi̱ ta cua̱ha̱n da̱ chí estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ta na̱xi̱nu̱ co̱o na in ñuu naní Nazaret nu̱ú na̱sa̱nduu na. Ta xi̱hín ña̱ yóho na̱xi̱nu̱ co̱o nu̱ú tu̱hun na̱ca̱hyí na̱ profeta sa̱nahá ña̱ cacuu Jesús da̱ ñuu Nazaret. ");
INSERT INTO mksNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mé tiempo cán Juan, da̱ jácandúta̱ ña̱yivi na̱xi̱nu̱ da̱ yucú íchí cuéntá estado Judea cán. Ta na̱casáhá jána̱ha̱ da̱ ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Já cáchí da̱ já xi̱hi̱n ná: —Xíní ñúhú jándacoo ndó ña̱ núu cája ndó ta ndicó co̱o ini ndó nu̱ Ndióxi̱ jáchi̱ sa̱ na̱cayati qui̱vi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi —cáchí da̱ xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mé Juan yóho cúú dá da̱ na̱ca̱ha̱n profeta Isaías sa̱ha̱ tá na̱ca̱hyí da̱ já: Va̱xi qui̱vi̱ tá ca̱ha̱n cóhó in da tañu yucú íchí ta cachi da já xi̱hín ña̱yivi: “Caja tia̱hva ndó íchi̱ nu̱ú quixi xitoho í, ta cuná ndó in íchi̱ nda̱cú nu̱ mé á ña̱ ná ndi̱hvi a ínima̱ ndo̱”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ta jáhma̱ na̱sa̱ndixi Juan yóho na̱sa̱cuu a ña̱ na̱cava̱ha na xi̱hi̱n íji̱ camello ta na̱sa̱ndi̱co̱ in nií jáhndá tóco̱ da̱. Ta na̱xixi da ti̱ca xi̱hín ñu̱ñu̱ yúcú. ");
INSERT INTO mksNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ta na̱queta ña̱yivi ndúu ñuu Jerusalén xi̱hín na̱ ndúu estado Judea xi̱hín na̱ ndúu ñundáhyi̱ yati yu̱ta Jordán cán na̱sa̱a̱ na̱ nu̱ Juan taa jo̱ho na nu̱ cáha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ta tá na̱na̱hma̱ na̱ cua̱chi na nu̱ Ndióxi̱ já na̱jácandúta̱ Juan na̱ ini yu̱ta Jordán. ");
INSERT INTO mksNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Joo tá na̱xini Juan ña̱ ja̱nda̱ joho xínu̱ co̱o cua̱há na̱ fariseo xi̱hín na̱ saduceo nu̱ dá ña̱ ná jácandúta̱ da̱ na̱ já na̱casáhá xójo̱ ndiva̱ha ini da ta já na̱cachi da já xi̱hi̱n ná: —Mé ndó cúú ndó tátu̱hun co̱o jáchi̱ cúú ndó na̱ quini. Cáhán ndo̱ ña̱ a̱ jándoho ga̱ Ndióxi̱ ini ndó sa̱há cua̱chi ndó tá ná candúta̱ ndo̱ va̱tí cája tá cája ndó cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xíní ñúhú caja ndó ña̱ va̱ha já ná cuni ña̱yivi ña̱ mé a̱ nda̱a̱ táhyí na̱jándicoo ndó ña̱ núu na̱sacaja ndó jihna. ");
INSERT INTO mksNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ta a̱ cáhán ndo̱ ña̱ jáca̱cu Ndióxi̱ ndo̱hó sa̱há ña̱ cúú ndó na̱ na̱quixi chi̱chi Abraham. Jáchi̱ co̱ó sa̱ha̱ toho ña̱ ja̱n nu̱ Ndióxi̱ tá co̱ jándacoo ndó cua̱chi ndó. Jáchi̱ mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ ja̱nda̱ yu̱u̱ ndúu nu̱ ñúhu̱ ja̱n cuu caja Ndióxi̱ ña̱ ná nduu a ña̱yivi quixi chi̱chi Abraham. ");
INSERT INTO mksNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mé ndó cúú ndó tátu̱hun in yíto̱, dó sa̱ na̱tiin na hacha cua̱ha̱n na̱ cahnda na. Ta tócó ndihi yíto̱, dó co̱ sáhan cui̱hi va̱ha nu̱u̱, ta̱hnda̱ do̱ ta que̱e dó nu̱ ñúhu̱ ca̱yi̱ do̱. Quia̱hva já caja ri Ndióxi̱ xi̱hi̱n ndó tá co̱ cúni̱ ndó ndicó co̱o ini ndó nu̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mé a̱ nda̱a̱ cája ndúta̱ i̱ ndóhó xi̱hín ticui̱í ta xi̱hín ña̱ yóho náha̱ ña̱ na̱ndicó co̱o ini ndó nu̱ Ndióxi̱. Joo va̱xi inga da ta da̱ cán cúú da̱ jándicutú ínima̱ ndo̱ xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱ ta ña̱ cán cacuu a tátu̱hun ñúhu̱ cáyi̱. Ta da̱ cán íin cua̱ha̱ chága̱ ndée dá a̱ ju̱ú ga̱ ye̱he̱. Ta chí co̱ó sa̱há i̱ ndica xítí i̱ nu̱ dá ña̱ ndaxí i̱ correa ndu̱sa̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mé da̱ va̱xi cán ca̱xi da ña̱yivi va̱ha tañu ña̱yivi quini. Cúú á tátu̱hun in da̱ta̱a tá jáxi̱xi da trigo xi̱hi̱n pala já ná quee xe̱he̱ á já cacu va̱ha da ña̱. Ta xe̱he̱ na̱cana cán cu̱hu̱n a̱ ca̱yi̱ a̱ xi̱hi̱n ñúhu̱ i̱ta̱ ña̱ a̱ ndáhva̱ toho —cáchí Juan xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na̱quee Jesús chí estado Galilea cua̱ha̱n yu̱ta Jordán nu̱ ndáca̱a̱n Juan jácandúta̱ dá ña̱yivi ña̱ ná jácandúta̱ da̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Joo nu̱ cuítí co̱ó na̱xeen toho Juan jácandúta̱ dá Jesús. Ña̱ cán quéa̱ na̱cachi da já xi̱hín Jesús: —Yóhó cúú da̱ ndítahan jácandúta̱ ye̱he̱. Ta cáa joho va̱sún yóho ña̱ ná jácandúta̱ i̱ yo̱hó —na̱cachi Juan cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Já na̱nducú nehe Jesús tu̱hun nu̱ dá já na̱cachi a já xi̱hi̱n dá: —Cande̱hé. Quia̱hva já ndítahan coo ña̱ yóho viti jáchi̱ ndítahan nu̱ yo̱ jáxi̱nu̱ co̱o i̱ tócó ndihi ña̱ nda̱a̱ ña̱ na̱sacu ini Ndióxi̱ coo —na̱cachi a. Xi̱hín ña̱ yóho na̱candúsa Juan ta chí na̱jácandúta̱ dá Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ta tá na̱ndihi na̱candúta̱ Jesús já na̱queta ini ticui̱í cán. A̱nda̱ já na̱nu̱na̱ indiví ta na̱xini Jesús na̱nuu ínima̱ yi̱i̱ Ndióxi̱ ja̱tá ta na̱saca̱a tá quia̱hva cáa in ndija̱ta. ");
INSERT INTO mksNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tá na̱ndihi já na̱xini jo̱ho a cáha̱n in a indiví ta já cáchí a̱ cán já: —Yóhó cúún ja̱hyi ma̱ní i̱ ta cáji̱i̱ ndiva̱ha ini i̱ xu̱hu̱n —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tá na̱ndihi já ndáca ínima̱ yi̱i̱ Ndióxi̱ Jesús cua̱ha̱n chí yucú íchí nu̱ú co̱ ndúu ña̱yivi já ná coto ndojó tiñáhá sa̱cua̱ha̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ta cán na̱sahi̱in a ti̱xi i̱vi̱ jícó qui̱vi̱. Ñuú ta ndiví co̱ó na̱xixi a ta tá na̱ndihi já na̱xi̱nu̱ jo̱co nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Já na̱cayati tiñáhá sa̱cua̱ha̱ nu̱ú Jesús ña̱ coto ndojó ñahá ri̱ já na̱cachi rí já xi̱hi̱n á: —Tá ta̱ jivi ndusa ja̱hyi Ndióxi̱ cúún cahnda chuun ña̱ ná nduu yu̱u̱ yóho pan —na̱cachi rí cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n rí: —Já cáchí tu̱hun Ndióxi̱: “A̱ ju̱ú pan cuití cuxu ña̱yivi já catacu na, va̱ha. Xíní ñúhú ri a caja na ña̱ sáhndá tu̱hun Ndióxi̱ nu̱ ná já quéa̱ cuu catacu na nu̱ Ndióxi̱” —na̱cachi Jesús xi̱hi̱n rí. ");
INSERT INTO mksNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tá na̱ndihi já ndáca tiñáhá sa̱cua̱ha̱ cán Jesús cua̱ha̱n xi̱hi̱n rí ñuu Jerusalén, ña̱ yi̱i̱ cán ta já na̱jándaa rí a̱ nu̱ jícó ji̱ni̱ veñu̱hu cáhnu ndáca̱a̱n cán. ");
INSERT INTO mksNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ta já na̱cachi rí já xi̱hi̱n á: —Tá ta̱ jivi ndusa ja̱hyi Ndióxi̱ cúún jácana mún chí ni̱nu̱ jáchi̱ já cáchí tu̱hun Ndióxi̱: Cahnda Ndióxi̱ chuun nu̱ táto̱ mé á ña̱ ná candaa na yo̱hó. Ta ndinehe ndáha̱ na̱ yo̱hó, já quéa̱ ná a̱ ndícue̱he̱ sa̱hu̱n tá ná cachihin sa̱hu̱n xi̱hín yu̱u̱, já cáchí tu̱hun Ndióxi̱ —na̱cachi rí xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ta já na̱nducú nehe Jesús tu̱hun nu̱ rí já na̱cachi a já xi̱hi̱n rí: —Cáchí tucu tu̱hun Ndióxi̱ já: “A̱ cóto ndojó tohún Ndióxi̱, xitohún” —na̱cachi Jesús xi̱hi̱n ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ta tá na̱ndihi já ndáca tucu tiñáhá sa̱cua̱ha̱ cán Jesús na̱sa̱ha̱n xi̱hi̱n rí in ji̱ni̱ yúcu̱ jícó ndiva̱ha. Ta já na̱na̱ha̱ rí ndaja táhan ñuu ndúu ñuyíví nu̱ á ta na̱jána̱ha̱ rí tócó ndihi ña̱ náhnu ndúu cán nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ta já na̱cachi tucu rí já xi̱hín Jesús: —Tócó ndihi ña̱ yóho quia̱hva i̱ nu̱u̱n tá ná caxítún nu̱ú i̱ caja cáhnún ye̱he̱ —na̱cachi rí quini cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n rí: —Satanás, cuáhán caxoo jáchi̱ já cáchí tu̱hun Ndióxi̱: “In túhún Ndióxi̱, xitohún ndítahan caja cáhnún ta in túhún mé á ndítahan caja ndívún nu̱u̱n” —na̱cachi Jesús xi̱hi̱n rí cán. ");
INSERT INTO mksNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tá na̱ndihi já na̱caxoo tiñáhá sa̱cua̱ha̱ cán cua̱ha̱n ri̱. Ta já na̱xi̱nu̱ java táto̱ Ndióxi̱ chindeé na̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tá na̱ne̱hé Jesús tu̱hun ña̱ na̱chica̱a̱n na̱ Juan, da̱ jácandúta̱ ña̱yivi veca̱a já na̱quee a cán cua̱ha̱n chí estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Joo co̱ó na̱cando̱o a ñuu Nazaret chí na̱quee a cua̱ha̱n coo a chí ñuu Capernaum ña̱ ndáca̱a̱n yuhú tañu̱hú, dó ndáca̱a̱n ñundáhyi̱ cuéntá na̱ na̱quixi chi̱chi Zabulón xi̱hín na̱ na̱quixi chi̱chi Neftalí. ");
INSERT INTO mksNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tócó ndihi ña̱ yóho na̱ya̱ha ña̱ ná xi̱nu̱ co̱o nu̱ú tu̱hun na̱ca̱hyí profeta Isaías sa̱nahá tá na̱ca̱hyí da̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ña̱yivi ndúu ñundáhyi̱ Zabulón xi̱hín na̱ ndúu ñundáhyi̱ Neftalí, ña̱ ñúhu inga xoo yu̱ta Jordán yati yuhú tañu̱hú, ta jári na̱ ndúu Galilea, mé estado nu̱ ndúu ña̱yivi, na̱ co̱ cúú chi̱chi Israel, ");
INSERT INTO mksNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","mé na̱ cán na̱sa̱nduu na nu̱ú naá ndiva̱ha ta viti na̱xini na in ña̱ha yéhe̱ ndiva̱ha. Jándiye̱he̱ á nu̱ ná ña̱ ná a̱ quíví na̱, joo catacu na a̱nda̱ ama cáa qui̱vi̱ nu̱ íin Ndióxi̱, na̱ca̱hyí Isaías sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ta chí mé tiempo já na̱casáhá Jesús cáha̱n ndojó a̱ nu̱ú ña̱yivi ta já cáchí a̱ já xi̱hi̱n ná: —Xíní ñúhú jándacoo ndó cua̱chi cája ndó ta ndicó co̱o ini ndó nu̱ Ndióxi̱ jáchi̱ sa̱ na̱cayati qui̱ví cacomí a̱ cuéntá sa̱há ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tá xíca Jesús cua̱ha̱n yuhú tañu̱hú Galilea, na̱ndine̱hé a̱ i̱vi̱ ta̱a, da̱ cúú ñani. In da naní Simón ta cáha̱n na̱ Pedro xi̱hi̱n dá. Ta da̱ inga cán naní da̱ Andrés. Ndíví da̱ yóho cúú dá da̱ tává ti̱yacá ta ñúhu na jácana na ñúnu̱ ná ini tañu̱hú cán. ");
INSERT INTO mksNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Já na̱cachi a já xi̱hi̱n ndíví da̱: —Naha quíi̱ ndó candi̱co̱ ndó ye̱he̱ caca tuun ndó xi̱hín i̱. Tává ndó ti̱yacá viti joo caja i̱ ña̱ ná cuu tavá ndo̱ ña̱yivi tañu cua̱chi —cáchí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ta chí i̱vi̱ la̱á na̱jándacoo da ñúnu̱ da̱ ta na̱ndi̱co̱ da̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ta nani xíca Jesús cua̱ha̱n chága̱ chí nu̱u̱ já na̱xini a inga i̱vi̱ tucu ta̱a, da̱ cúú ñani. In da̱ naní Jacobo ta inga da naní Juan, da̱ cúú ja̱hyi Zebedeo. Ta ndíví mé da̱ yóho ñúhu da ini barco da̱ xi̱hi̱n tátá da̱ ndája va̱ha da ñúnu̱ dá. Ta na̱cana Jesús ndíví da̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ta chí i̱vi̱ la̱á na̱jándacoo da barco da̱ xi̱hi̱n tátá da̱ ta na̱casáhá xíca tuun da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Níí cúú estado Galilea na̱xi̱ca nuu Jesús cáha̱n tu̱hun va̱ha nu̱ú ña̱yivi ini veñu̱hu in in ñuu cán. Cáxi tu̱hun a nu̱ ná ña̱ sa̱ na̱ndindaa qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi ñuyíví. Ta na̱ndaja va̱ha Jesús na̱ quíhvi̱ tá nu̱ú cue̱he̱ ndóho na. ");
INSERT INTO mksNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ta níí cúú ñundáhyi̱ cuéntá Siria na̱ndicui̱ta nuu tu̱hun sa̱há ña̱ cája Jesús. Sa̱há ña̱ cán quéa̱ néhe na na̱ quíhvi̱, na̱ ndóho tá nu̱ú cue̱he̱ va̱xi na nu̱ á ña̱ ná ndaja va̱ha mé á na̱ ta néhe na na̱ ñúhu ínima̱ quini ini xínu̱ na̱ nu̱ á ta ndijáá na̱ xíhi̱ yi̱hí xi̱hín na̱ quíhvi̱ sa̱ha̱ néhe na va̱xi na nu̱ú Jesús. Ta na̱ndaja va̱ha mé á na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ta cua̱há ndiva̱ha ña̱yivi ndíco̱ na̱ Jesús. Cúú ná na̱ na̱quixi estado Galilea xi̱hín na̱ ndúu u̱xu̱ ñuu cuéntá Decápolis xi̱hín na̱ ñuu Jerusalén xi̱hín na̱ estado Judea xi̱hín na̱ na̱quixi ñundáhyi̱ chí xoo oriente nu̱ ndáca̱a̱n yu̱ta Jordán cán. ");
INSERT INTO mksNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tá na̱xini Jesús ña̱ ndíco̱ cua̱há ndiva̱ha ña̱yivi mé á já na̱ndaa ji̱ni̱ yúcu̱ ta já na̱sa̱co̱o a cán. Ta na̱cayati na̱ xíca tuun xi̱hi̱n á nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ta já na̱casáhá jána̱ha̱ nu̱ tócó ndihi na̱ ndúu cán já na̱cachi a já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ta̱hví na̱cuu ña̱yivi tá ndícuni na xíní ñúhú na̱ ña̱ chindeé Ndióxi̱ na̱ jáchi̱ na̱ cán cúú na̱ cacomí Ndióxi̱ cuéntá sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ʼTa̱hví na̱cuu na̱ ndúu cuéha̱ jáchi̱ na̱ cán cúú na̱ quia̱hva Ndióxi̱ tu̱hun ndéé ini. ");
INSERT INTO mksNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ʼTa̱hví na̱cuu na̱ co̱ ndíñehe jícó mé jáchi̱ na̱ cán cúú na̱ ñe̱he̱ táhvi̱ ndiquehe na ña̱ na̱sa̱ha̱n Ndióxi̱ tu̱hun a quia̱hva nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ʼTa̱hví na̱cuu na̱ xíca̱ ini caja ña̱ cúni̱ Ndióxi̱. Na̱ cán cúú na̱ caja Ndióxi̱ ña̱ ná xi̱nu̱ nu̱ú ña̱ cúu ini na. ");
INSERT INTO mksNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ʼTa̱hví na̱cuu na̱ cándáhví ini sa̱há ña̱yivi jáchi̱ na̱ cán cacuu na candáhví ri ini Ndióxi̱ sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ʼTa̱hví na̱cuu na̱ co̱ ndáca̱a̱n quini ínima̱ jáchi̱ na̱ cán cúú na̱ cuni Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ʼTa̱hví na̱cuu na̱ ndíhi ini ña̱ ná coo va̱ha na xi̱hín ña̱yivi jáchi̱ na̱ cán cúú na̱ cáchí Ndióxi̱ cúú ná ja̱hyi mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ʼTa̱hví na̱cuu na̱ ndóho ini sa̱há ña̱ cája na ña̱ sáhndá Ndióxi̱ nu̱ ná caja na jáchi̱ na̱ cán cúú na̱ cacomí Ndióxi̱ cuéntá sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ʼTa̱hví na̱cuu ndó tá cána̱há ña̱yivi xi̱hi̱n ndó ta cája xíxi na xi̱hi̱n ndó sa̱há ña̱ cándeé ini ndó ye̱he̱. Ta ta̱hví na̱cuu ndó tá jácojo na cua̱chi jíquí ja̱ta̱ ndó sa̱há ña̱ cándeé ini ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ʼXíní ñúhú caji̱i̱ ndiva̱ha ini ndó ta coo va̱ha ini ndó jáchi̱ ndiquehe ndó in ña̱ va̱ha ndiva̱ha caja Ndióxi̱ indiví. Xíní ñúhú ndicu̱hu̱n ini ndó ña̱ quia̱hva já na̱caja xíxi na xi̱hín na̱ profeta, na̱ na̱sa̱nduu sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ʼMé ndó cúú ndó tátu̱hun ñi̱i̱ yívi na. Sa̱ xíni̱ ndó ña̱ cája ñi̱i̱ ña̱ ná ndiha̱ji̱ ña̱ha xíxi ndó. Ta quia̱hva já cája ndó xi̱hín ña̱yivi ñuyíví. Joo tá ná ndihi ña̱ o̱hva̱ ñi̱i̱ cán a̱ cúu ga̱ ndicó co̱o a caho̱hva̱ tucu a sa̱há ña̱ cán quéa̱ ja̱ndá cui̱ta va íchi̱ cua̱ni̱ nihni ña̱yivi ña̱ jáchi̱ co̱ó chuun toho a. ");
INSERT INTO mksNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ʼJári mé ndó cúú ndó tátu̱hun ñúhu̱ jándiye̱he̱ nu̱ú ña̱yivi ndúu ñuyíví. Ta mé ñúhu̱ cán cúú á tátu̱hun in ñuu cánúu ja̱ta̱ in yucú jícó ta a̱ cúu toho ndáca̱a̱n je̱hé a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jáchi̱ co̱ chíñúhu̱ ná in lámpara ta tá nu̱ ndíhí já chíje̱hé na̱ ña̱ ti̱xi in sa̱to̱. Ña̱ cája na xi̱hi̱n á quéa̱ chínúu jícó na̱ ña̱ já ná jándiye̱he̱ a̱ nu̱ tócó ndihi na̱ ndúu vehe. ");
INSERT INTO mksNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Quia̱hva já xíní ñúhú ndi̱hi ini ndó caja va̱ha ndó ña̱ ná cacuu ndó tátu̱hun in ñúhu̱ cáyi̱ nu̱ú ña̱yivi. Jáchi̱ tá ná cuni na ña̱ va̱ha cája ndó já quéa̱ cuu caja cáhnu na Ndióxi̱, tátá yo̱, ña̱ íin indiví. ");
INSERT INTO mksNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ʼA̱ ju̱ú ca̱hán ndó ña̱ na̱quixi i̱ ñuyíví yóho ña̱ cacu xóo i̱ ña̱ na̱sahnda ley Moisés xi̱hín ña̱ na̱jána̱ha̱ na̱ profeta, va̱ha. Co̱ váxi toho i̱ cacu xóo i̱ ña̱. Va̱xi i̱ nu̱ ndó jáxi̱nu̱ co̱o i̱ tócó ndihi ña̱ cáchí mé ley já ná na̱ha̱ i̱ nu̱ ndó ndía̱ cúú ndusa ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ a̱ ndíhi sa̱ha̱ mé ley nani íin indiví xi̱hín ñuyíví yóho. Ni in túhún toho tu̱hun, a̱ ndíhi sa̱ha̱ ja̱nda̱ quia̱hva ná ya̱ha tócó ndihi ña̱ ndítahan ya̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sa̱há ña̱ cán quéa̱ ndá na̱ co̱ cúni̱ caja ña̱ sáhndá ley Moisés va̱tí cúú á ña̱ loho ndiva̱ha ta ni co̱ cúni̱ na̱ jána̱ha̱ na̱ ña̱yivi ña̱ ná caja na ña̱ cáchí a̱ já quéa̱ cacuu na in na̱ co̱ó cua̱ha̱ sa̱ha̱ tañu na̱ cacomí Ndióxi̱ cuéntá sa̱ha̱. Joo na̱ cája ña̱ cáchí mé ley ta jána̱ha̱ na̱ ña̱yivi ña̱ ná caja na ña̱, mé na̱ cán cacuu na na̱ cáhnu ndiva̱ha tañu na̱ cacomí Ndióxi̱ cuéntá sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ná caja cuití va ndó tá quia̱hva cája na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo já quéa̱ a̱ cu̱ú ndi̱hvi ndó nu̱ú cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ʼMé ndó sa̱ xíni̱ ndo̱ ña̱ na̱cachi Moisés xi̱hi̱n tásáhnu jícó ndo̱ sa̱nahá tá na̱cachi da já: “A̱ cáhní ndó ndi̱i jáchi̱ ndá na̱ ná cahní ndi̱i tandaa qui̱vi̱ caja vií jutixia sa̱ha̱ ná.” ");
INSERT INTO mksNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Joo ye̱he̱ cáchí i̱ xi̱hi̱n ndó viti ña̱ ndá na̱ ná caja cue̱he̱ xi̱hín ñani táhan na tandaa qui̱vi̱ caja vií jutixia sa̱ha̱ ná. Ta jári na̱ cána̱há xi̱hín ñani táhan na, á cáchí na̱ cúú ná ña̱yivi ta̱chi̱ já va̱xi qui̱vi̱ tá candichi na nu̱ juéxe̱ cáhnu ta cuu cu̱hu̱n na̱ indayá sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ʼSa̱há ña̱ cán quéa̱ tá ta̱ ñéhe ndó in ña̱ha cua̱ha̱n ndó jo̱co̱ ndó nu̱ náa̱ Ndióxi̱ ta nani cua̱ha̱n ndo̱ cán ndicu̱hu̱n ini ndó ña̱ íin in ñani táhan ndó ta co̱ cúní táhan va̱ha na xi̱hi̱n ndo̱ ");
INSERT INTO mksNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","já quéa̱ mé ja̱n yati nu̱ náa̱ ndítahan jándacoo tóo ndó ña̱ ñéhe ndó jo̱co̱ ndó ja̱n. Ta ndítahan quee ndó cu̱hu̱n ndó ndique táhan máni̱ ndó xi̱hín ñani táhan ndó cán. Ta tá ná ndihi já cuu ndicó co̱o tucu ndó nu̱ náa̱ Ndióxi̱ jo̱co̱ ndó ña̱ na̱jándacoo ndó ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ʼTá sácú in na sa̱ha̱ ndó cu̱hu̱n ndó veca̱a ta cúni̱ na̱ candaca na ndo̱hó cu̱hu̱n ndó nu̱ juéxe̱, xíní ñúhú nducú ndó ndá quia̱hva ndique táhan máni̱ ndó xi̱hi̱n ná nani núná nu̱ ndó caja ndó ña̱. Já quéa̱ ná a̱ ndíquia̱hva na̱ cán ndo̱hó ndáha̱ juéxe̱ jáchi̱ cuu ndiquia̱hva juéxe̱ cán ndo̱hó ndáha̱ na̱ policia ta chica̱a̱n na̱ ndo̱hó veca̱a. ");
INSERT INTO mksNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mé a̱ nda̱a̱ cáchí i̱ xi̱hi̱n ndó ña̱ cañuhu ndó cán ja̱nda̱ quia̱hva ná cha̱hvi ndó tócó ndihi jiu̱hún yícá ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ʼMé ndó sa̱ xíni̱ ndó ña̱ na̱sahnda ley Moisés chuun sa̱nahá ta já na̱cachi a já: “Coto a̱ cóo ndó xi̱hi̱n ñájíhí á yíi̱ ñani táhan ndó.” ");
INSERT INTO mksNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Joo ye̱he̱ cáchí i̱ xi̱hi̱n ndó viti ña̱ ndá da̱ sánde̱hé in ñáñáha̱ ta cáhvi núu ini da xi̱hi̱n ñá já quéa̱ cómí tá cómí da̱ cua̱chi nu̱ Ndióxi̱ jáchi̱ cúú á tátu̱hun sa̱ íin da xi̱hi̱n ñá. ");
INSERT INTO mksNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ʼÑa̱ cán quéa̱ cáchí i̱ xi̱hi̱n ndó ña̱ tá nduchú núú cuáha ndó quéa̱ jándacava ndo̱hó nu̱ú cua̱chi, tavá ndó ña̱ jácana xícá ndó ña̱ ná cu̱hu̱n a̱ jáchi̱ va̱ha chága̱ ña̱ ná ndihi sa̱há in nduchú núú ndó a̱ ju̱ú ga̱ ña̱ ná cu̱hu̱n in níí yiquí cu̱ñu ndó ini indayá. ");
INSERT INTO mksNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ta tá ndahá cuáha ndó quéa̱ caja ña̱ ná ndacava ndó nu̱ú cua̱chi, chitúhu̱n ndó ña̱ ta jácana xícá ndó ña̱ ná cu̱hu̱n a̱ jáchi̱ va̱ha chága̱ ná ndihi sa̱ha̱ ndáha̱ ndo̱ a̱ ju̱ú ga̱ ña̱ ná cu̱hu̱n níí yiquí cu̱ñu ndó ini indayá. ");
INSERT INTO mksNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ʼTa mé ndó sa̱ xíni̱ ndó ña̱ na̱sahnda ley Moisés chuun sa̱nahá já cáchí a̱ já: “Ndá da̱ cúni̱ jándacoo ñájíhí da̱ ndítahan cava̱ha da in tutu quia̱hva da nu̱ ña̱ ta sa̱ íin va̱ha va cuu jándacoo da ña̱.” ");
INSERT INTO mksNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Joo ye̱he̱ cáchí i̱ xi̱hi̱n ndo̱ viti ña̱ ni in túhún toho ta̱a co̱ ndítahan jándacoo da ñájíhí da̱. Jáchi̱ ndá da̱ jándacoo ñájíhí da̱ cája da ña̱ ná caja ñá cua̱chi tá ná tanda̱ha̱ tucu ñá. Jári da̱ tánda̱ha̱ xi̱hi̱n ñá cómí ri da̱ cua̱chi nu̱ Ndióxi̱. Joo tá ná canda̱a̱ ini da ña̱ íin ñájíhí da̱ xi̱hín inga da̱ta̱a já quéa̱ cuu ndusa jándacoo da ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ʼMé ndó sa̱ xíni̱ ndó ña̱ na̱sahnda ley Moisés chuun sa̱nahá já cáchí a̱ já: “Xíní ñúhú jáxi̱nu̱ co̱o ndó tócó ndihi ña̱ na̱sa̱ha̱n ndó tu̱hun ndó caja ndó tá tává ndo̱ qui̱vi̱ Ndióxi̱.” ");
INSERT INTO mksNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Joo ye̱he̱ cáchí i̱ xi̱hi̱n ndó viti ña̱ ná quia̱hva ndó tu̱hun ndó nu̱ú ña̱yivi joo a̱ tává ndó qui̱ví ni in ña̱ha. A̱ tává ndó qui̱ví indiví jáchi̱ indiví cúú nu̱ íin coo Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ta ni a̱ tává ndo̱ qui̱ví ñundáhyi̱ jáchi̱ ñundáhyi̱ cúú nu̱ sáni̱ mé á ta ni a̱ tává ndo̱ qui̱ví ñuu Jerusalén jáchi̱ cúú á ñuu na̱ca̱xi Ndióxi̱, mé á cúú á rey cáhnu ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ta ni a̱ tává ndó qui̱ví yiquí jíní ndó tá sáhan ndó tu̱hun ndó nu̱ú ña̱yivi jáchi̱ co̱ ndéé ndó ndaja yaa ndó á ndaja tu̱ún ndó ni in túhún ijí ji̱ni̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tá sáhan ndó tu̱hun ndó nu̱ú ña̱yivi xíní ñúhú cachi ndó: “A̱ja̱n, caja i̱ ña̱.” Á tá co̱ó xíní ñúhú cachi ndó: “U̱hu̱n, a̱ cu̱ú caja i̱ ña̱.” Jáchi̱ tá cachi ndó inga tu̱hun já caja ndó ña̱ cúni̱ ña̱ quini. ");
INSERT INTO mksNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ʼMé ndó sa̱ xíni̱ ndó ña̱ na̱sahnda ley Moisés chuun sa̱nahá já cáchí a̱ já: “Tá quia̱hva cája ña̱yivi xu̱hu̱n quia̱hva já caja ri yóhó va xi̱hi̱n ná. Ta tá ná cani in da nduchú núún já quéa̱ ndítahan cani mún nduchú núú da̱. Tá ná tavá da̱ nu̱hún já ndítahan nu̱u̱n tavá ri yóhó va nu̱hú da̱”, cáchí ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Joo ye̱he̱ cáchí i̱ xi̱hi̱n ndo̱ viti: A̱ cája i̱hvi̱ ndó xi̱hín ña̱yivi, na̱ cája núu xi̱hi̱n ndo̱. Ta ndá na̱ ná cani in xoo sa̱jóho ndó, cata ñee ndó inga xoo sa̱jóho ndó nu̱ ná ña̱ ná cani na a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ta tá cúni̱ in na candaca na ndo̱hó cu̱hu̱n ndó nu̱ juéxe̱ sa̱há ña̱ cúni̱ na̱ candaa na cotó ndo̱ já quéa̱ quia̱hva ndó ña̱ nu̱ ná ta ja̱nda̱ cotó ndéé ndo̱ quia̱hva ndó nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ta tá va̱xi in soldado nu̱ ndó ta tá cahnda da chuun ña̱ ná cojo ndó ña̱ha da in kilometro, xíní ñúhú cojo ndó ña̱ a̱nda̱ i̱vi̱ kilometro cu̱hu̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ta ndá na̱ ná ca̱ca̱ in ña̱ha nu̱ ndó quia̱hva ndó ña̱ nu̱ ná. Ta ndá na̱ xíca̱ tóo ña̱ha nu̱ ndó, quia̱hva tóo ndó ña̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ʼMé ndó sa̱ xíni̱ ndo̱ ña̱ na̱sahnda ley Moisés chuun sa̱nahá já cáchí a̱ já: “Qui̱hvi̱ ini ndó na̱ xíní táhan va̱ha xi̱hi̱n ndó ta candají ndó na̱ co̱ cúní táhan xi̱hi̱n ndo̱”, cáchí ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Joo ye̱he̱ cáchí i̱ xi̱hi̱n ndo̱ viti: Ndítahan qui̱hvi̱ ini ndó na̱ co̱ cúní táhan xi̱hi̱n ndó. Ta ca̱ha̱n va̱ha ndó xi̱hín na̱ cána̱há xi̱hi̱n ndó. Ta caja va̱ha ndó xi̱hín na̱ cándají ndo̱hó. Ta ca̱ca̱ ta̱hví ndó nu̱ Ndióxi̱ sa̱há na̱ cája xíxi xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jáchi̱ xi̱hín ña̱ yóho náha̱ ña̱ cúú ndó ja̱hyi Ndióxi̱, tátá yo̱, mé á íin indiví. Ta mé á cája ña̱ ná cana ca̱ndii ja̱tá ña̱yivi quini xi̱hín ja̱tá ña̱yivi va̱ha. Ta mé á jácuun ja̱vi̱ ja̱tá ña̱yivi nda̱a̱ xi̱hín ja̱tá na̱ co̱ cája va̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","A̱ cáhán ndo̱ ña̱ caja Ndióxi̱ cua̱há ña̱ma̱ni̱ xi̱hi̱n ndo̱ tá quíhvi̱ ini cuití ndó na̱ quíhvi̱ ini ndóhó va jáchi̱ ja̱nda̱ ña̱yivi quini, na̱ játaca jiu̱hún cuéntá impuesto cája na já. ");
INSERT INTO mksNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ta a̱ cáhán ndo̱ ña̱ na̱caja ndó cua̱há ña̱ va̱ha tá ná ca̱ha̱n Ndióxi̱ cuití ndó xi̱hín ñani táhan ndó jáchi̱ ja̱nda̱ ña̱yivi co̱ xíni̱ Ndióxi̱ cája na já. ");
INSERT INTO mksNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Xíní ñúhú caja nda̱a̱ ndó xi̱hi̱n tócó ndihi ña̱yivi tá quia̱hva cája nda̱a̱ Ndióxi̱, tátá yo̱, mé a̱ íin indiví —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Já na̱cachi tucu Jesús já: —A̱ ndúcú ndó caja va̱ha ndó nu̱ú ña̱yivi sa̱há ña̱ ná cuni táhyí na̱ ña̱ cája ndó já cando̱o va̱ha ndó nu̱ ná. Jáchi̱ tá ná caja ndó já co̱ó toho ña̱ha ñe̱hé táhvi̱ ndó nu̱ Ndióxi̱, tátá ndo̱ íin indiví. ");
INSERT INTO mksNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Sa̱há ña̱ cán quéa̱ tá chíndeé ndó ña̱yivi, na̱ ndíma̱ní ña̱ha nu̱u̱, a̱ cáca nuu ndó ca̱ha̱n lánda̱ ndó ña̱ nu̱ú ña̱yivi tá quia̱hva cája na̱ co̱ cúú ná tá quia̱hva ndáa na. Jáchi̱ na̱ cán sáhan na ña̱ha nu̱ú na̱ nda̱hví ini veñu̱hu xi̱hín nu̱ tácá ña̱yivi íchi̱ já ná cuu cuni táhyí tócó ndihi ña̱yivi ña̱ va̱ha cája na. Jáchi̱ na̱ cán cúni̱ na̱ ña̱ ná caja cáhnu ña̱yivi na. Mé a̱ nda̱a̱ cáchí i̱ xi̱hi̱n ndó ña̱ sa̱ ya̱hvi na cúú mé ña̱ cája cáhnu ña̱yivi na. ");
INSERT INTO mksNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ña̱ ndítahan caja ndó tá chíndeé ndó na̱ ndíma̱ní ña̱ha nu̱u̱ quéa̱ caja ndó ña̱ ná a̱ cánda̱a̱ ini ni in ña̱yivi ña̱ cája ndó ");
INSERT INTO mksNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta xíní ñúhú caja je̱hé ndó ña̱. Ta Ndióxi̱, tátá ndo̱ sánde̱hé a̱ ña̱ va̱ha cája ndó xi̱hín ña̱yivi ta mé á quéa̱ cha̱hvi a sa̱há ña̱ cája ndó ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ʼTá xíca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ a̱ cája ndó tá quia̱hva cája na̱ co̱ cúú ná tá quia̱hva ndáa na jáchi̱ cátóó na̱ candita na veñu̱hu xi̱hi̱n cáyé ña̱ ca̱ca̱ ta̱hví na̱ nu̱ Ndióxi̱ ña̱ ná cuni táhyí ña̱yivi na. Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ sa̱ ya̱hvi na cúú mé ña̱ xíní ña̱yivi na. ");
INSERT INTO mksNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Joo ndóhó, tá xíca̱ ta̱hví ndó nu̱ Ndióxi̱, tátá ndo̱ íin indiví ndítahan qui̱hvi ndó ini vehe ndó ta chicaji tuun ndó yéhé a̱ ta ja̱n cuu ca̱ca̱ ta̱hví je̱hé ndo̱ nu̱ Ndióxi̱. Jáchi̱ ja̱n íin Ndióxi̱, tátá ndo̱ xi̱hi̱n ndo̱ taa joho a nu̱ cáha̱n ndo̱ ta caja mé á ña̱ma̱ni̱ xi̱hi̱n ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ʼTa tá xíca̱ ta̱hví ndó nu̱ Ndióxi̱, a̱ cáha̱n tucu tucu ndó mé tu̱hun ña̱ co̱ó sa̱ha̱ jáchi̱ ña̱yivi, na̱ co̱ xíni̱ Ndióxi̱ cán cája na já. Ta cáhán na̱ táa jo̱ho Ndióxi̱ na̱ sa̱há ña̱ cua̱ha̱ cáha̱n na̱ joo a̱ ju̱ú ña̱ nda̱a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Joo a̱ cája ndó tá quia̱hva cája na̱ cán jáchi̱ Ndióxi̱, tátá ndo̱ sa̱ xíni̱ va mé á ndá quéa̱ xíní ñúhú ndo̱ ja̱nda̱ tá cáma̱ni̱ ca̱ca̱ ndó ña̱ nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ña̱ yóho quéa̱ ndítahan cachi ndó tá xíca̱ ta̱hví ndó nu̱ Ndióxi̱: Tátá Ndióxi̱, ña̱ íin indiví, cáhnu ná cacuu qui̱vi̱ ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ná tandaa quíi̱ qui̱vi̱ cacomí ndó cuéntá sa̱há nde̱. Ta ná coo tá íin cúni̱ mé ndó coo ñuyíví yóho tá quia̱hva íin indiví cája ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Quia̱hva ndó nu̱ú nde̱ ña̱ ndíma̱ní nu̱ú nde̱ cuxu nde̱ in in qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Caja cáhnu ini ndó sa̱há cua̱chi nde̱ tá quia̱hva cája cáhnu ini mé nde̱ sa̱há ña̱ núu cája ña̱yivi xi̱hín nde̱. ");
INSERT INTO mksNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ta a̱ quiáhva ndó ña̱ma̱ni̱ ña̱ ná coto ndojó tiñáhá sa̱cua̱ha̱ nde̱he̱ já ná a̱ cája nde̱ cua̱chi nu̱ ndó. Jáchi̱ cómí ndó cuéntá sa̱ha̱ tócó ndihi ña̱yivi, ta cúú cája ndó tócó ndihi ña̱ha, ta cáhnu cúú mé ndó a̱nda̱ ama cáa qui̱vi̱. Já ná coo, quia̱hva já cachi ndó tá xíca̱ ta̱hví ndó nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ʼJáchi̱ tá cája cáhnu ini ndó sa̱há ña̱ núu cája inga na xi̱hi̱n ndo̱ já quéa̱ caja cáhnu ri ini Ndióxi̱, tátá ndo̱, mé a̱ íin indiví sa̱há ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ta tá co̱ cúni̱ ndo̱ caja cáhnu ini ndó sa̱há ña̱ núu na̱caja inga na xi̱hi̱n ndó já quéa̱ a̱ cája cáhnu ini Ndióxi̱ sa̱há cua̱chi cája ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ʼTá cajuhun ndó a̱ cája ndó tá quia̱hva cája na co̱ cúú ná tá quia̱hva ndáa na. Na̱ cán cúni̱ na̱ ña̱ ná cuni táhyí tócó ndihi ña̱yivi ña̱ xíjuhun na sa̱há ña̱ cán quéa̱ cája cue̱ha̱ nu̱u̱ na̱ já ná ndiñehe jícó ñahá na̱. Mé a̱ nda̱a̱ cáchí i̱ xi̱hi̱n ndo̱ ña̱ sa̱ ya̱hvi na cúú ña̱ xíní ña̱yivi na. ");
INSERT INTO mksNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Joo ndóhó, tá ná cajuhun ndó ndítahan cuchú nu̱ú ndo̱ ta ndaja vií ndó mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Já quéa̱ ná a̱ cúní ña̱yivi ña̱ xíjuhun ndó ta in túhún Ndióxi̱, tátá ndo̱, mé a̱ íin tuun xi̱hi̱n ndó cánda̱a̱ ini ña̱ mé a̱ nda̱a̱ xíjuhun ndó ta mé á quéa̱ cha̱hvi a sa̱há ña̱ cája ndó ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ʼA̱ ndúcú ndó játaca cua̱há ndiva̱ha ndó ña̱ cuícá canduu nu̱ ndo̱ ñuyíví yóho jáchi̱ yóho cúú nu̱ quíhvi ti̱quijí ña̱ha ndó jándihi rí sa̱há ta já tíví ndihi ña̱ha ndó. Ta jári cuu qui̱hvi ta̱a cui̱hná caja cuíhná da̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Va̱ha chága̱ ná játaca ndó ña̱ va̱ha indiví jáchi̱ cán co̱ó qui̱hvi toho ti̱quijí jándihi rí sa̱há ña̱ha ndó. Ta mé cán ni in ña̱ha co̱ tíví ta ni ta̱a cui̱hná a̱ cúu ndi̱hvi caja cuíhná. ");
INSERT INTO mksNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jáchi̱ nu̱ú na̱ndaja tútú ndo̱ ña̱ ndáya̱hvi nu̱ ndó, cán coo ri ínima̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ʼNduchú núú yo̱ cúú á tátu̱hun in lámpara jándiye̱he̱ nu̱ yó já xíní yo̱ nu̱ xíca í. Ta tá tívi va̱ha nduchú núú yo̱ já cuu cande̱hé va̱ha í nu̱ xíca í. ");
INSERT INTO mksNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Joo tá co̱ tívi nduchú núú yó já quéa̱ xíca yó nu̱ naá ndiva̱ha. Ta tá cáhán yo̱ ña̱ cúú yó na̱ xíca nu̱ yéhe̱ ndiva̱ha ta cáa ví yó cája í cua̱chi já quéa̱ cúú yó tátu̱hun na̱ xíca nu̱ naá ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ʼNi in túhún ña̱yivi a̱ cúu caja chúun nu̱ú i̱vi̱ xitoho na jáchi̱ candají na̱ in xitoho na ta inga xitoho na qui̱hvi̱ ini chága̱ na̱. Á tá co̱ó ta caja ndíví va̱ha na chuun nu̱ú in xitoho na ta inga na̱ cán a̱ cája chúun va̱ha na nu̱u̱. Ta quia̱hva já íin ri xi̱hi̱n ndóhó va jáchi̱ a̱ cu̱ú caja cáhnu ndó Ndióxi̱ tá chínúu ndó ínima̱ ndó ja̱tá jiu̱hún ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ʼCande̱hé ndo̱ ña̱ cáha̱n i̱ xi̱hi̱n ndó yóho: A̱ ndícani ini ndó sa̱há ña̱ cuxu ndó ta ni sa̱há ña̱ coho ndó ña̱ catacu ndó in in qui̱vi̱. Ta ni a̱ ndícani ini ndó sa̱ha̱ jáhma̱ candixi ndó. Jáchi̱ tá tácú ndo̱, ña̱ ja̱n cúú ña̱ cáhnu chága̱ a̱ ju̱ú ga̱ ña̱ cuxu ndó. Ta íin chága̱ sa̱ha̱ yiquí cu̱ñu ndó a̱ ju̱ú ga̱ jáhma̱ ndíxi ndó ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cande̱hé ndó laa ndáchí nu̱ táchi̱ ja̱n: rí ja̱n ni co̱ xútu rí ta ni a̱ vája sáhan rí jáquee rí ta ni co̱ yáca̱ ri̱ nu̱ táán va̱ha ri̱ nu̱ni̱ ri̱. Ta Ndióxi̱, tátá ndo̱, mé a̱ íin indiví sáhan ña̱ xíxi rí ja̱n nu̱ ri̱. Á co̱ xíni̱ ndó ña̱ íin chága̱ sa̱ha̱ mé ndó a̱ ju̱ú ga̱ laa cán. Sa̱há ña̱ cán quéa̱ quia̱hva mé á ña̱ xíní ñúhú ndó catacu ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ta co̱ó sa̱ha̱ toho ña̱ ndícani na̱há ini ndó jáchi̱ a̱ cu̱ú ndaja jícó ndó mé ndó java metro chága̱ sa̱há ña̱ ndicani ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ʼTa ni co̱ ndítahan ndicani ini ndó sa̱ha̱ jáhma̱ candixi ndó. Cande̱hé ndo̱ ndá quia̱hva ndató sáhnu itá yúcu̱. Mé ita ja̱n ni co̱ cája chúun a ta ni co̱ cáva̱ha jáhma̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Joo mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ñúchí chága̱ ita yóho na̱caja Ndióxi̱ a̱ ju̱ú ga̱ jáhma̱ va̱ha ndiva̱ha na̱sa̱ndixi rey Salomón sa̱nahá, da̱ na̱sahi̱in cua̱há ña̱ha cuícá. ");
INSERT INTO mksNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Cande̱hé ndó ndaja ndáa va̱ha Ndióxi̱ yu̱cu̱ ita va̱tí íin tóo a viti ta ita̱a̱n cáyi̱ a jándihi sa̱há. Ndaja ga̱ ví caja Ndióxi̱ xi̱hi̱n ndóhó ña̱ quia̱hva mé á tócó ndihi ña̱ xíní ñúhú ndó catacu ndó. Joo mé ndó co̱ cándúsa ndó ña̱ candaa mé á ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ña̱ cán quéa̱ a̱ ndícani ini ndó sa̱ha̱ ndá ña̱ cuxu ndó á sa̱há ña̱ coho ndó á sa̱há ña̱ candixi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Jáchi̱ na̱ co̱ xíni̱ íchi̱ cuéntá Ndióxi̱, na̱ cán cúú na̱ ndícani cua̱há ini sa̱ha̱ tócó ndihi ña̱ yóho. Joo cúú ndó cuéntá Ndióxi̱, tátá ndo̱ íin indiví ta xíni̱ va̱ha mé á ña̱ ndíma̱ní nu̱ ndó catacu ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Joo ndítahan nu̱ ndó ndiquia̱hva ndó mé ndó ndáha̱ Ndióxi̱ ña̱ ná cacomí mé á cuéntá sa̱ha̱ ndó ta já quia̱hva mé á ña̱ ndíma̱ní nu̱ ndo̱ catacu ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","A̱ ndícani ini ndó sa̱há ña̱ quixi nu̱ ndó inga qui̱ví ita̱a̱n jáchi̱ Ndióxi̱ cuití va xíni̱ a̱ ndía̱ va̱xi nu̱ ndó qui̱ví ita̱a̱n ta co̱ó sa̱há ndicani ini ndó sa̱há ña̱ ndoho ndó ita̱a̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ʼA̱ cánde̱hé ndaa ndó ña̱yivi já ná a̱ cánde̱hé ndaa Ndióxi̱ ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jáchi̱ tá quia̱hva cája ndó xi̱hín inga ña̱yivi quia̱hva já caja ri Ndióxi̱ xi̱hi̱n ndóhó va. Sa̱há ña̱ cán quéa̱ tá quia̱hva sánde̱hé ndaa ndó ña̱yivi quia̱hva já caja ri Ndióxi̱ xi̱hi̱n mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Jáchi̱ ndá cuéntá quéa̱ sánde̱hé ndó ña̱ núu cája ñani táhan ndó ta co̱ sánde̱hé ndo̱ ndá quia̱hva náhnu chága̱ ña̱ núu cája mé ndó. Cúú á tátu̱hun ndáca̱a̱n in xe̱he̱ loho nduchú núú ñani táhan ndó nani ndáca̱a̱n in yíto̱ ndúhu̱ cáhnu ini nduchú núú ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ta tá a̱ cu̱ú cuni ndó yitó cáhnu ndáca̱a̱n ini nduchú núú mé ndó ndaja caja ndó cachi ndó xi̱hín ñani táhan ndó: “Ñani i̱, ná tavá loho i̱ xe̱he̱ ndáca̱a̱n nduchú núún ja̱n.” ");
INSERT INTO mksNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jándahvi ndó mé ndó xi̱hín ña̱ cája ndó. Xíní ñúhú tavá ndó yitó cáhnu ndáca̱a̱n nduchú núú mé ndó ja̱n já ná nu̱na̱ nu̱ ndó cuni va̱ha ndó já ná cuu tavá ndó xe̱he̱ loho ndáca̱a̱n nduchú núú ñani táhan ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ʼA̱ quiáhva ndó ña̱ yi̱i̱ cuéntá Ndióxi̱ nu̱ú ña̱yivi quini. Jáchi̱ tá cája ndó já cúú á tátu̱hun tá ná quia̱hva ndó ña̱ha yi̱i̱ nu̱ú ti̱na ta tia̱hva náá ndicó co̱o rí tiin rí ndo̱hó. Ta jári cúú á tátu̱hun tá ná quia̱hva ndó ña̱ha ya̱hvi ndiva̱ha tátu̱hun perla nu̱ cóchí jáchi̱ cuu cua̱ni̱ nihni rí ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ʼNdá ña̱ha ndíma̱ni̱ nu̱ ndó xíní ñúhú ca̱ca̱ ndó ña̱ nu̱ Ndióxi̱ ta já quia̱hva mé á ña̱ nu̱ ndo̱. Ndinducú ndó ña̱ cúni̱ ndo̱ ta ñe̱he̱ ndó ña̱ caja Ndióxi̱. Cúú á tátu̱hun catí ndáha̱ ndo̱ yéhé ta já nu̱na̱ yéhé nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jáchi̱ na̱ xíca̱ in ña̱ha, na̱ cán cúú na̱ ñéhe̱ va. Ta na̱ ndúcú ña̱ha, na̱ cán cúú na̱ ndíñe̱he̱ ña̱. Ta na̱ cátí ndáha̱ yéhé, na̱ cán cúú na̱ ndínu̱na̱ yéhé nu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ʼTa ndá ndó, na̱ ndúu ja̱hyi ta tá xíca̱ ja̱hyi ndó pan cuxu a nu̱ ndo̱, ama cuéhé ri ndó quia̱hva ndó yu̱u̱ nu̱ á ña̱ ná caxí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ta ama ná quia̱hva ri ndó in co̱o nu̱ á caxi tá xíca̱ ti̱yacá nu̱ ndó cuxu a. Co̱ cája ndó já. ");
INSERT INTO mksNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Cande̱hé ndó. Va̱tí mé ndó cúú ndó ña̱yivi cája cua̱chi joo xíni̱ va̱ha ndó quia̱hva ndó ña̱ va̱ha nu̱ú ja̱hyi ndó. Ndaja ga̱ ví cája Ndióxi̱, tátá ndo̱, mé a̱ íin indiví xi̱hi̱n ndo̱. Quia̱hva mé á ña̱ va̱ha nu̱ ndo̱ tá ná ca̱ca̱ ndó ña̱ nu̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ʼCande̱hé ndó. Tá quia̱hva cúni̱ ndó caja ña̱yivi xi̱hi̱n ndo̱ quia̱hva já ndítahan caja ri ndóhó va xi̱hi̱n ná jáchi̱ ña̱ yóho quéa̱ sáhndá ley Moisés xi̱hín ña̱ na̱ca̱hyí na̱ profeta caja ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ʼCúú á tátu̱hun íin i̱vi̱ yéhé. In yéhé cúú á ña̱ táhán ndiva̱ha ta xíní ñúhú ndinducú ndó ndi̱hvi ndó cán. Jáchi̱ inga yéhé cúú á ña̱ ndíca̱ ndiva̱ha nu̱ú ndi̱hvi na cu̱hu̱n indayá. Ta cua̱há ndiva̱ha ña̱yivi cúú na̱ xíca íchi̱ ndíca̱ cua̱ha̱n na̱ indayá nu̱ú ndihi sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Joo ña̱ cúú íchi̱ ña̱ ndáca ña̱yivi yéhé táhán nu̱ ndíhvi na indiví cúú á ichí táhán ndiva̱ha ta yáncá ndiva̱ha caca nuu í nu̱ á. Ta chá ndiva̱ha cúú na̱ ndíhvi cán. ");
INSERT INTO mksNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ʼCuéntá coo ndó xi̱hín na̱ tu̱hún, na̱ cáchí cáha̱n na̱ cuéntá Ndióxi̱ ja̱n. Jáchi̱ uun ndiva̱ha cása̱a̱ na̱ nu̱ ndo̱. Joo cúú ná tátu̱hun ndiva̱hyí quini ndiva̱ha va̱tí náha̱ na̱ tátu̱hun ndicachi loho. ");
INSERT INTO mksNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Cúú ndicuni ndó na̱ xi̱hín ña̱ cája na. Jáchi̱ ña̱yivi quini co̱ cája va̱ha toho na. Cúú á tátu̱hun tá a̱ cu̱ú cuun uva nu̱ú to̱híñú ta ni a̱ cu̱ú jáquee ndó titó ñu̱hú nu̱ú to̱híñú. ");
INSERT INTO mksNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ña̱ cán quéa̱ tócó ndihi yitó va̱ha ndinuhu cui̱hi va̱ha cuití cúun nu̱ do̱. Joo yitó quini ndinuhu cui̱hi quini cuití cúun nu̱ do̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Dó cúú yitó va̱ha cán a̱ cúu toho cana cui̱hi quini nu̱ do̱ ta ni yitó quini cán a̱ cúu cuun cui̱hi va̱ha nu̱ do̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ta tócó ndihi yíto̱, dó co̱ cána cui̱hi va̱ha nu̱u̱, ta̱hnda̱ do̱ ta que̱e dó nu̱ cándaha ñúhu̱ ña̱ ca̱yi̱ do̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sa̱há ña̱ cán quéa̱ xi̱hín ña̱ cája ña̱yivi já cuu ndicuni ndó á cúú ná ña̱yivi va̱ha á cúú ná na̱ quini. ");
INSERT INTO mksNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ʼA̱ ju̱ú ndihi toho na̱ cáchí cúú ye̱he̱ xitoho na cu̱hu̱n na̱ nu̱ú cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. Na̱ cája ña̱ sáhndá Ndióxi̱, tátá i̱, mé a̱ íin indiví na̱ cán cuití cúú na̱ cacomí mé á cuéntá sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jáchi̱ tá ná xi̱nu̱ co̱o qui̱vi̱ caja vií Ndióxi̱ sa̱há ña̱yivi já quéa̱ casáhá ca̱ha̱n cua̱há ndiva̱ha ña̱yivi xi̱hín i̱ ta já cachi na já: “Jesús, mé ndó cúú xitoho nde̱ ta xi̱hín qui̱vi̱ mé ndó na̱xi̱ca nuu nde̱ cáha̱n nde̱ tu̱hun Ndióxi̱ xi̱hín ña̱yivi ta xi̱hín qui̱vi̱ mé ndó na̱tavá nde̱ rí quini na̱sa̱ñuhu ínima̱ ña̱yivi ta xi̱hín qui̱vi̱ mé ndó na̱caja cua̱há ndiva̱ha nde̱ ña̱ xitúhún”, cachi na xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ta a̱nda̱ já nducú ñehe e̱ tu̱hun nu̱ ná já cachi i̱ já xi̱hi̱n ná: “Co̱ xíni̱ toho i̱ yo cúú ndóhó. Caxoo ndó nu̱ú i̱ jáchi̱ ndinuhu ña̱ quini cája ndó”, cachi i̱ xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ʼNdá na̱ xíni̱ jo̱ho ña̱ cáha̱n i̱ ta cája na ña̱, na̱ cán cúú ná tátu̱hun in da̱ta̱a, da̱ íin xíní túni̱ ta na̱cava̱ha da vehe da ja̱ta̱ in tóto̱. ");
INSERT INTO mksNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ta tá na̱xi̱nu̱ ja̱vi̱ já na̱sahnu yu̱ta ta na̱xi̱nu̱ ta̱chi̱ quíni ja̱tá vehe cán joo co̱ó na̱ndicava vehe da jáchi̱ tóyíí cándichi vehe da ja̱ta̱ tóto̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Joo na̱ xíni̱ jo̱ho nu̱ cáha̱n i̱ ta co̱ cája na ña̱, na̱ cán cúú ná tátu̱hun in da̱ta̱a, da̱ co̱ xíní túni̱ ta na̱cava̱ha da vehe da nu̱ú ñu̱tí. ");
INSERT INTO mksNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tá na̱ndihi já na̱xi̱nu̱ ja̱vi̱ já na̱sahnu yu̱ta ta na̱xi̱nu̱ ta̱chi̱ quíni ja̱tá vehe cán. A̱nda̱ já na̱ndicava vehe da ta chí na̱ndihi sa̱ha̱ chí uun —na̱cachi Jesús jána̱ha̱ ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ta tá na̱ndihi na̱ca̱ha̱n Jesús ña̱ yóho já tócó ndihi ña̱yivi na̱catóntó na̱ xíni̱ jo̱ho na ndá quia̱hva jána̱ha̱ mé á ");
INSERT INTO mksNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","jáchi̱ tá jána̱ha̱ mé á nu̱ ná cáha̱n tá quia̱hva cáha̱n in da̱ íin sa̱ha̱ cahnda chuun ta co̱ cáha̱n toho a tá quia̱hva cája na̱ jána̱ha̱ ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tá na̱nuu Jesús ja̱ta̱ yúcu̱ nu̱ú na̱sa̱núu a cán já ndíco̱ cua̱há ndiva̱ha ña̱yivi ja̱tá cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ta ndaja coo já na̱cayati in da̱ta̱a, da̱ ndóho cue̱he̱ táhyi̱ nu̱ á. Ta já na̱caxítí da̱ nu̱ á já na̱cachi da já xi̱hi̱n á: —Cuu ndaja va̱ha ndó ye̱he̱, xitoho i̱ tá cúni̱ ndó —na̱cachi da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tá na̱ndihi já na̱cani ndaa ndáha̱ Jesús da̱ já na̱cachi a já xi̱hi̱n dá: —Cúni̱ ña̱ ná ndiva̱hún ña̱ cán quéa̱ na̱ndiva̱hún viti —cáchí a̱ xi̱hi̱n dá. Tá na̱cachi Jesús já chí i̱vi̱ la̱á na̱ndindaa cue̱he̱ táhyi̱ na̱ndoho da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Cande̱hé. A̱ cáxi tu̱hun tohún ña̱ yóho xi̱hín ni in túhún ña̱yivi. Cuáhán nda̱cún na̱hu̱n mún nu̱ú ju̱tu̱. Ta ndítahan jo̱cún ña̱ha nu̱ Ndióxi̱ tátu̱hun sáhndá ley Moisés sa̱nahá caja na̱ sa̱ na̱ndiva̱ha. Já ná canda̱a̱ ini tócó ndihi ña̱yivi ña̱ sa̱ na̱ndindaa va cue̱he̱ na̱sandohún —na̱cachi Jesús xi̱hín da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tá na̱ndi̱hvi Jesús ñuu Capernaum já na̱cayati in da̱ sáhndá chuun nu̱ú soldado na̱quixi ñuu Roma nu̱ Jesús jáchi̱ cúni̱ da̱ ca̱ca̱ da̱ in ña̱ma̱ni̱ nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Já na̱cachi da já xi̱hi̱n á: —Á co̱ cúni̱ ndó caja ndó ña̱ma̱ni̱ ndaja va̱ha ndó mozo i̱, da̱tacú jáchi̱ cándúhu̱ da̱ vehe quíhvi̱ da̱ na̱xi̱hi̱ tu̱chu yiquí cu̱ñu da ta a̱ ju̱ú quia̱hva cáhi̱hvi̱ yiquí cu̱ñu da —na̱cachi da̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Já na̱cachi Jesús já xi̱hi̱n dá: —Va̱ha va, cu̱hu̱n i̱ ndaja va̱ha i̱ da̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A̱nda̱ já na̱cachi tucu da̱ sáhndá chuun nu̱ú soldado cán já xi̱hín Jesús: —Cande̱hé ndó. Co̱ó sa̱ha̱ toho ye̱he̱ ña̱ ná ndi̱hvi ndó vehe e̱. Joo cahnda cuití ndó chuun ja̱nda̱ nu̱ íin ndó yóho ta já ndiva̱ha va mozo i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jáchi̱ ndúu java na̱ náhnu chága̱ sáhndá chuun nu̱ú i̱. Ta ndúu ri soldado sáhndá ri ye̱he̱ va chuun nu̱u̱. Ta tá chíndahá i̱ in da ña̱ ná cu̱hu̱n da̱ nu̱ cúni̱ mí i̱ cu̱hu̱n da̱ ta cua̱ha̱n da̱. Ta tá sáhndá i̱ chuun nu̱ú inga da̱ ña̱ ná quixi da̱ nu̱ú i̱ ta va̱xi da nu̱ú i̱. Ta tá sáhndá i̱ chuun nu̱ mozo i̱ ña̱ ná caja da ña̱ sáhndá i̱ ta cája da ña̱ —na̱cachi da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tá na̱xini jo̱ho Jesús ña̱ yóho já na̱catóntó a̱ já na̱cachi a já xi̱hín na̱ ndíco̱ cua̱ha̱n cán: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ a̱ ñáha cuni i̱ tañu na̱ Israel in da̱ cándeé cáhnu na̱há ini Ndióxi̱ tá quia̱hva cándeé cáhnu ini da̱ yóho Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Cande̱hé ndo̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ quixi ña̱yivi ndijáá níí cúú sa̱ha̱ ñuyíví ta caco̱o na cuxu na xi̱hín Abraham ta xi̱hín Isaac ta xi̱hín Jacob indiví nu̱ íin Ndióxi̱ cómí a̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Joo cua̱há na̱ Israel, na̱ na̱nditahan nu̱u̱ coo cán a̱ cóo toho na̱ cán. Ña̱ caja Ndióxi̱ xi̱hín na̱ cán quéa̱ cui̱ta̱ na̱ ja̱ta̱ véhe cu̱hu̱n na̱ nu̱ú naá ndiva̱ha. Ta cán cuacu ndiva̱ha na ja̱nda̱ quia̱hva chicáhñá mé nu̱hu̱ ná —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tá na̱ndihi já na̱ca̱ha̱n tucu Jesús xi̱hín da̱ sáhndá chuun nu̱ú soldado cán já na̱cachi a já xi̱hi̱n dá: —Cuanúhu̱ vehún. Na̱ndiva̱ha mosún tá quia̱hva cúnu̱n jáchi̱ na̱candúsún ye̱he̱ —na̱cachi Jesús xi̱hi̱n dá. Chí mé hora já na̱ndiva̱ha mozo da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na̱sa̱ha̱n Jesús vehe Pedro ta tá na̱xi̱nu̱ a̱ cán cándúhu̱ ñá cúú xo̱jo Pedro quíhvi̱ ña̱ jáchi̱ chíca̱a̱n cáhni̱ ndeé ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A̱nda̱ já na̱tiin Jesús ndáha̱ ñá quíhvi̱ cán ta chí na̱ndindaa cáhni̱ ña̱. Ta já na̱ndaco̱o ñá cán cája ndíví ñá nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ta tá na̱cuaá já ñéhe cua̱há ndiva̱ha na na̱ quíhvi̱ xi̱hín na̱ ñúhu ínima̱ quini ini nu̱ú Jesús. Ta xi̱hín in túhún tu̱hun na̱ca̱ha̱n mé á na̱tavá ínima̱ quini ñúhu ínima̱ ña̱yivi ta jári na̱ndaja va̱ha mé á tócó ndihi na̱ quíhvi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ta tócó ndihi ña̱ yóho na̱ya̱ha já ná xi̱nu̱ co̱o nu̱ú tu̱hun ña̱ na̱ca̱hyí profeta Isaías tá na̱cachi da já: “Mé á na̱ndiquehe ndihi a ña̱ cávitá iní ta na̱xojo ndihi a cue̱he̱ yo̱”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tá na̱xini Jesús ña̱ a̱ ju̱ú quia̱hva cándíhi táhan ña̱yivi ndúu na xi̱hi̱n á já na̱sahnda chuun ña̱ ná co̱jo̱ cava na inga xoo tañu̱hú cán. ");
INSERT INTO mksNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Joo na̱cayati in da̱ jána̱ha̱ ley Moisés nu̱ á já na̱cachi da já xi̱hi̱n á: —Maestro, cúni̱ candi̱co̱ i̱ ndo̱hó ndá na̱cuu nu̱ú cu̱hu̱n ndo̱ —na̱cachi da xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já xi̱hi̱n dá: —Ndicuii cúú rí ta va̱ti̱ íin cáva̱ ñúhu rí. Ta laa cúú rí ta va̱ti̱ íin táca̱ ñúhu rí. Joo ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi, chí ni nu̱ú cu̱ju̱ mí i̱ co̱ó va —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ta inga da sa̱ xíca xi̱hi̱n á na̱cachi da já xi̱hi̱n á: —Maestro, quia̱hva jihna ndó ña̱ma̱ni̱ nu̱ú i̱ ña̱ ná cu̱hu̱n i̱ jándu̱xu̱ tátá i̱ já quixi i̱ candi̱co̱ i̱ ndo̱hó —na̱cachi da xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Já na̱cachi Jesús já xi̱hi̱n dá: —Xíní ñúhú candi̱cún ye̱he̱ viti jáchi̱ ná cu̱hu̱n mé ña̱yivi, na̱ a̱ ñáha ca̱cu ndaa ínima̱ jándu̱xu̱ na̱ ndi̱i ja̱n —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ta ndaja coo na̱qui̱hvi Jesús ini in barco ta cátahan na̱ xíca tuun xi̱hi̱n á cán cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ta nani xíca na nu̱ú tañu̱hú cán cua̱ha̱n na̱ ta in náá cuití na̱xi̱nu̱ in ta̱chi̱ quíni ndiva̱ha nu̱ú tañu̱hú cán. Ta a̱ ju̱ú quia̱hva ndeé na̱casáhá ndíco̱jo̱ ticui̱í cán ja̱nda̱ quia̱hva na̱ndichutú ticui̱í ini barco cán. Joo cándúhu̱ Jesús ini barco quíji̱ va. ");
INSERT INTO mksNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A̱nda̱ já ndáva na̱ xíca tuun xi̱hi̱n á cán na̱sa̱ha̱n na̱ ndíñehe na ña̱. Já na̱cayuhú na̱ já cáchí na̱ xi̱hi̱n á: —Chindeé ndó nde̱he̱, xitoho nde̱. Jáchi̱ cáco̱o barco ca̱há tañu̱hú cua̱ha̱n do̱ —na̱cachi na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Ndá cuéntá quéa̱ yíhví na̱há ndo̱. Ndá cuéntá quéa̱ co̱ cándeé ini ndó ye̱he̱ —na̱cachi a. Já na̱ndaco̱o a ta jána̱ni a ta̱chi̱ quíni cán xi̱hín tañu̱hú cán ta já na̱catáji̱ uun tócó ndihi a cán. ");
INSERT INTO mksNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tá na̱xini na̱ xíca tuun xi̱hi̱n á cán ña̱ yóho já na̱catóntó na̱ ta na̱casáhá ndáca̱ tu̱hún táhan na já cáchí xi̱hi̱n táhan na já: —Ta ndá da̱ cúú da̱ta̱a yóho ña̱ ja̱nda̱ ta̱chi̱ xi̱hín tañu̱hú cándúsa nu̱ cáha̱n da̱ —cáchí xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tá na̱xi̱nu̱ co̱o Jesús inga xoo tañu̱hú cán nu̱ íin ñundáhyi̱ cuéntá Gadara já na̱queta i̱vi̱ da̱ ñúhu ínima̱ quini ini tañu nu̱ ndúxu̱ ndi̱i. Ta na̱cayati da nu̱ú Jesús. Ndíví mé da̱ ñúhu ínima̱ quini ini yóho cúú dá tátu̱hun quíti̱, rí cue̱he̱ ndiva̱ha. Sa̱há ña̱ cán quéa̱ ni in túhún ña̱yivi a̱ cu̱ú ya̱ha chí íchi̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tá na̱xini da Jesús já na̱casáhá da̱ cáyuhú da̱ nu̱ á já cáchí da̱ já xi̱hi̱n á: —Ndá cuéntá quéa̱ va̱sún qui̱hvi nuún xi̱hín nde̱, Jesús, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱. Á va̱sún jándoho ya̱chún ini nde̱ tá cáma̱ní yi̱i̱ ndindaa tiempo ndoho ini nde̱ —na̱cachi rí quini cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ta ndaja coo yati cán na̱sa̱nduu cua̱há ndiva̱ha cóchí xíxáhan rí. ");
INSERT INTO mksNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ta mé rí quini ñúhu ini ndíví da̱ta̱a cán na̱xi̱ca̱ ta̱hví ri̱ nu̱ Jesús já cáchí ri̱ já xi̱hi̱n á: —Tá ta̱ ná tavún nde̱he̱ ini da̱ yóho, quia̱hva ña̱ma̱ni̱ nu̱ú nde̱ ña̱ ná cu̱hu̱n nde̱ ndi̱hvi nde̱ ini cóchí ndúu cáa —na̱cachi rí xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n rí: —Cuáhán ndó, dá já. Chí na̱queta rí quini cán ini ndíví da̱ta̱a cán já na̱sa̱ha̱n rí na̱ndi̱hvi rí ini cóchí cán. Ta chí i̱vi̱ la̱á xínu tócó ndihi cóchí cán cua̱ha̱n rí núu rí nu̱ ndáyi yuhú tañu̱hú cán. Ta na̱jáque̱ta nuu rí mé rí ini tañu̱hú chí na̱candaa rí ticui̱í já na̱xi̱hi̱ ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ta chí a̱ ju̱ú quia̱hva na̱yi̱hví da̱ ndáá cóchí chí na̱xinu ndiva̱ha da cua̱ha̱n da̱. Ta tá na̱xi̱nu̱ da̱ ñuu já na̱casáhá da̱ ndícani da ndaja cáa ña̱ na̱ya̱ha xi̱hi̱n ndíví da̱ na̱sa̱ñuhu ínima̱ quini ini cán. ");
INSERT INTO mksNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A̱nda̱ já na̱queta tócó ndihi ña̱yivi ñuu cán cua̱ha̱n na̱ cande̱hé na̱ Jesús. Ta tá na̱xini na mé á já na̱xi̱ca̱ ta̱hví na̱ nu̱ á ña̱ ná quee a cu̱hu̱n a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tá sa̱ na̱ya̱ha tócó ndihi ña̱ yóho já na̱ndaa Jesús ja̱tá in barco ta já na̱xo̱jo̱ cava inga xoo tañu̱hú cán ja̱nda̱ quia̱hva na̱xi̱nu̱ co̱o a ñuu mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ta cán ñéhe na in da̱ quíhvi̱, da̱ na̱xi̱hi̱ tu̱chu sa̱ha̱ ta cándúhu̱ da̱ nu̱ yívi̱ loho ñéhe na na̱casa̱a̱ na̱ nu̱ á. Ta tá na̱xini Jesús ndá quia̱hva cándeé ini da̱ cán mé á já na̱cachi a já xi̱hín da̱ quíhvi̱ cán: —Cande̱hé, ja̱hyi a. A̱ ndícani toho inún jáchi̱ cája cáhnu ini i̱ sa̱há cua̱chún viti —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Java táhan da̱ jána̱ha̱ ley Moisés na̱casáhá da̱ cáhán da̱ já: “Mé da̱ yóho ndája núu da Ndióxi̱ xi̱hín tu̱hun cáha̱n da̱ jáchi̱ ni in túhún toho ña̱yivi a̱ cu̱ú caja cáhnu ini sa̱há cua̱chi.” ");
INSERT INTO mksNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Joo sa̱ na̱canda̱a̱ ini Jesús ña̱ cáhvi ini da̱ cán sa̱há ña̱ cán quéa̱ na̱nda̱ca̱ tu̱hún a̱ da̱ já na̱cachi a já xi̱hi̱n dá: —Ndá cuéntá quéa̱ cáhvi núu ini ndó sa̱há ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Á cáhán ndo̱ ña̱ i̱hvi̱ chága̱ cachi i̱ xi̱hín da̱ yóho: “Na̱caja cáhnu ini i̱ sa̱há cua̱chún viti.” Á tá co̱ó ta cachi i̱ xi̱hi̱n dá: “Cuándaco̱o ta cuáhán.” ");
INSERT INTO mksNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Cande̱hé va̱ha ndo̱ ná na̱ha̱ i̱ nu̱ ndo̱ ña̱ íin sa̱há i̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi caja cáhnu ini i̱ sa̱há cua̱chi cája ña̱yivi ñuyíví yóho —na̱cachi Jesús xi̱hi̱n dá. Tá na̱ndihi já na̱ndica̱ha̱n tucu a xi̱hín da̱ na̱xi̱hi̱ tu̱chu sa̱ha̱ cán: —Ta viti cáha̱n i̱ xu̱hu̱n cuándaco̱o ndiquehe xi̱to lohún ta cuanúhu̱ vehún —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chí i̱vi̱ la̱á na̱ndaco̱o da̱ quíhvi̱ cán ta já na̱quee da cuanúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tá na̱xini ña̱yivi ndúu cán ña̱ na̱caja Jesús yóho já na̱yi̱hví na̱ ta na̱casáhá cája cáhnu na Ndióxi̱ sa̱há ña̱ na̱sa̱ha̱n ndée̱ mé á nu̱ú ña̱yivi ña̱ ná cuu caja na ña̱ xitúhún. ");
INSERT INTO mksNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tá na̱ndihi já na̱quee Jesús cua̱ha̱n ta nani xíca cua̱ha̱n já na̱xini a in da̱ta̱a naní Mateo, da̱ íin coo nu̱ sáco̱o da̱ játaca jiu̱hún cuéntá impuesto. Ta na̱cana Jesús da̱ já na̱cachi a já xi̱hi̱n dá: —Naha quíi̱ candi̱cún ye̱he̱. A̱nda̱ já na̱nda̱ca̱ ndichi Mateo ta na̱casáhá ndíco̱ da̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tá na̱ndihi já íin coo Jesús xíxi a vehe da̱ cán ta cán na̱xi̱nu̱ co̱o cua̱há táhan na̱ játaca jiu̱hún cuéntá impuesto xi̱hín java ga̱ ña̱yivi cája cua̱chi. Na̱saco̱o na xíxi na xi̱hín Jesús ta cán ndúu coo ri na̱ xíca tuun xi̱hín a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ta tá na̱xini na̱ fariseo ña̱ ndúu na̱ cán xíxi na xi̱hín Jesús já na̱casáhá na̱ ndáca̱ tu̱hún na̱ na̱ xíca tuun xi̱hín Jesús cán já: —Ndá cuéntá quéa̱ xíxi xitoho ndó xi̱hín na̱ játaca jiu̱hún cuéntá impuesto ta xi̱hín java ga̱ na̱ cája cua̱chi —na̱cachi na̱ fariseo cán. ");
INSERT INTO mksNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Joo tá na̱xini jo̱ho Jesús ña̱ yóho já na̱cachi a já xi̱hín na̱ fariseo cán: —Ña̱yivi íin va̱ha co̱ xíní ñúhú toho na da̱ cája tátá ñahá joo na̱ quíhvi̱, na̱ cán cúú na̱ xíní ñúhú da̱ cája tátá ñahá. ");
INSERT INTO mksNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ta ye̱he̱ co̱ó va̱xi toho i̱ cana i̱ na̱ sa̱ íin va̱ha. Va̱xi i̱ cana i̱ ña̱yivi, na̱ cája cua̱chi ña̱ ná jándacoo na cua̱chi cája na. Xíní ñúhú cu̱hu̱n ndo̱ jácuaha va̱ha ndó ña̱ cúni̱ cachi tu̱hun Ndióxi̱ tá cáchí a̱ já: “Ña̱ cúni̱ quéa̱ ná candáhví ini ndó ña̱yivi jáchi̱ va̱ha chága̱ ña̱ yóho a̱ ju̱ú ga̱ ña̱ ná jo̱co̱ ndó quíti̱ nu̱ú i̱”, cáchí tu̱hun Ndióxi̱ —cáchí Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tá na̱ndihi na̱ xíca xi̱hi̱n Juan, da̱ jácandúta̱ ña̱yivi cán na̱xi̱nu̱ co̱o na nu̱ Jesús. Já na̱casáhá ndáca̱ tu̱hún na̱ mé á já na̱cachi na já xi̱hi̱n á: —Ndáva̱ha co̱ xíjuhun toho na̱ xíca xi̱hi̱n yóhó nani cua̱há ndiva̱ha xíjuhun mé nde̱ xi̱hín na̱ fariseo —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Á cáhán ndo̱ canduu cuéha̱ na̱ ndúu in vicó tánda̱ha̱ nani íin mé da̱ tánda̱ha̱ cán xi̱hi̱n ná. U̱hu̱n. Jáchi̱ cáji̱i̱ ini na. Joo xi̱nu̱ co̱o qui̱ví candaa na da̱ tánda̱ha̱ cán a̱nda̱ jáví casáhá cajuhun na. Ta cáchí i̱ xi̱hi̱n ndo̱ ña̱ va̱xi qui̱vi̱ candaa na ye̱he̱ nu̱ú na̱ yóho ta a̱nda̱ jáví casáhá na̱ xíca tuun xi̱hín i̱ cajuhun na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ta na̱sacu Jesús inga quia̱hva nu̱ ná já cáchí a̱ já: —Ama ná jándaha ña̱yivi jahmá yatá xi̱hín in túhu̱n jáhma̱ sa̱á jáchi̱ tá na̱ndihi ndíndi̱í a̱, sáhndá chága̱ ví a̱ jahmá yatá cán ta jándacáhnu chága̱ ví a̱ yávi̱ ña̱ na̱ndicahmá na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ta ni co̱ táán na̱ vino sa̱á ini vóso̱ níi̱ yatá jáchi̱ jáca̱hndi̱ mé vino cán níi̱ ta cui̱ta̱ mé vino cán ta tíví vóso̱ níi̱ cája dó. Sa̱há ña̱ cán quéa̱ ndítahan taán yo̱ vino sa̱á ini vóso̱ nií sa̱á ná a̱ ndíhi sa̱ha̱ vino xi̱hi̱n vóso̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ta nani cáha̱n Jesús cándichi a na̱xi̱nu̱ co̱o in da̱ sáhndá chuun nu̱ú na̱ Israel. Já na̱caxítí da̱ nu̱ á ta já na̱cachi da já xi̱hi̱n á: —Ja̱cá na̱xi̱hi̱ uun ñá loho cúú ja̱hyi jíhí i̱ joo tá ná caja ndó ña̱ma̱ni̱ quixi ndó vehe e̱ ta chinúu ndó ndáha̱ ndó ja̱ta̱ ña̱ já nditacu tucu ñá —na̱cachi da̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A̱nda̱ já na̱quee Jesús cua̱ha̱n xi̱hín da̱ cán ta ndáca na̱ xíca tuun xi̱hi̱n á cán cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ta ndaja coo cán íin in ñáñáha̱, ñá ndíta̱hví ni̱i̱ ñá ti̱xi u̱xu̱ i̱vi̱ cui̱a̱. Ta na̱cayati ñá chí ja̱ta̱ Jesús já na̱cani ndaa ndáha̱ ñá yuhú jáhma̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jáchi̱ na̱ca̱hán ña̱: “Tá ná cani ndaa cuití ndáha̱ í jáhma̱ Jesús já ndiva̱ha í”, na̱ca̱hán ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Joo na̱ndicoto nihni játá Jesús nu̱ ñá ta tá na̱xini a ñá já na̱cachi a já xi̱hi̱n ña̱: —A̱ cáyi̱hví tohún, ja̱hyi a. Na̱ndiva̱hún jáchi̱ na̱candúsún ye̱he̱ —na̱cachi Jesús xi̱hi̱n ñá. Ta chí mé hora já na̱ndiva̱ha ñá. ");
INSERT INTO mksNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ta tá na̱xi̱nu̱ co̱o Jesús vehe da̱ sáhndá chuun nu̱ú na̱ Israel cán já na̱xini a ña̱ sa̱ ndúu música cán ña̱ ná cu̱hu̱n na̱ jándu̱xu̱ na̱ ja̱hyi da̱ cán. Ta na̱xini a ja̱ndá joho sácu cóhó ña̱yivi ndúu na. ");
INSERT INTO mksNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ta chí já na̱cachi a já xi̱hi̱n tócó ndihi na̱ cán: —Cuáhán queta ndó ja̱ta̱ véhe. Jáchi̱ co̱ó na̱xi̱hi̱ toho ñá loho yóho. Quíji̱ cuití va ñá —na̱cachi Jesús xi̱hín ña̱yivi ndúu cán. Joo na̱casáhá na̱ cán sácu̱ ndaa ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ta chí na̱tavá Jesús na̱ ja̱ta̱ véhe. Ta tá na̱cayati a nu̱ ñá cán já na̱tiin a ndáha̱ ñá chí i̱vi̱ la̱á na̱ndaco̱o ñá. ");
INSERT INTO mksNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ta níí cúú ñundáhyi̱ cán na̱ndicui̱ta nuu tu̱hun sa̱há ña̱ na̱caja Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tá na̱quee Jesús cua̱ha̱n já ndíco̱ i̱vi̱ da̱ cua̱á ja̱tá cua̱ha̱n da̱ já na̱casáhá cáyuhú cóhó da̱ já cáchí da̱ já xi̱hi̱n á: —Jesús, da̱ na̱quixi chi̱chi David caja ndó ña̱ma̱ni̱ candáhví loho ini ndó nde̱he̱ —cáchí da̱ cáyuhú da̱ ja̱tá Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ta ndaja coo na̱qui̱hvi Jesús ini in vehe ta já na̱cayati ndíví da̱ cua̱á cán nu̱ á. Já na̱casáhá ndáca̱ tu̱hún a̱ da̱ cán já na̱cachi a já xi̱hi̱n dá: —Á cáhán ndo̱ ña̱ cuu caja i̱ jándiye̱he̱ nu̱u̱ ndo̱ —na̱cachi Jesús xi̱hín da̱ cán. —A̱ja̱n, xitoho nde̱. Cándúsa nde̱ ña̱ cuu caja ndó ña̱ —na̱cachi ndíví da̱ cua̱á cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tá na̱ndihi já na̱cani ndaa ndáha̱ Jesús nduchú núú da̱ cán ta já na̱cachi a já xi̱hi̱n ndíví da̱ cán: —Ná coo tá quia̱hva cúni̱ ndo̱ jáchi̱ cándeé ini ndó ye̱he̱ —cáchí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tá na̱ndihi já na̱casáhá sánde̱hé ndíví da̱ cua̱á cán. Ta na̱sahnda Jesús chuun nu̱ dá ña̱ ná a̱ cáxi tu̱hun da nu̱ú ña̱yivi sa̱há ña̱ na̱caja mé á xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Joo tá ja̱cá na̱queta uun da̱ cán já na̱casáhá da̱ ndícani da nu̱ú ndijáá ña̱yivi ndúu ñundáhyi̱ cán sa̱há ña̱ na̱caja Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nani na̱quee da̱ cua̱á cán cua̱ha̱n da̱ já na̱sa̱a̱ java ña̱yivi nu̱ Jesús ñéhe na in da̱ níhi̱, da̱ ndáca̱a̱n ínima̱ quini ini. ");
INSERT INTO mksNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ta tá na̱tavá Jesús ínima̱ quini ini da̱ cán chí i̱vi̱ la̱á na̱casáhá cáha̱n da̱. Ta a̱ ju̱ú quia̱hva na̱catóntó ña̱yivi ta já cáchí na̱ já: —Ni in túhún tañu co̱ó na̱xini nde̱ in ña̱ha tátu̱hun ña̱ yóho ñundáhyi̱ Israel —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Joo na̱ fariseo cán na̱casáhá cáchí na̱ já: —Rí cúú tiñáhá sa̱cua̱ha̱ nu̱ rí quini sáhan rí ndée̱ rí nu̱ú Jesús yóho ña̱ ná tavá a̱ ínima̱ quini ini ña̱yivi —na̱cachi na̱ fariseo cán. ");
INSERT INTO mksNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ndijáá ñuu náhnu xi̱hín ñuu válí na̱xi̱ca nuu Jesús jána̱ha̱ tu̱hun Ndióxi̱ ini veñu̱hu na̱ cán. Ta na̱ca̱xi tu̱hun a tu̱hun va̱ha xi̱hín ña̱yivi ña̱ sa̱ na̱cayati qui̱ví cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. Ta na̱ndaja va̱ha mé á tá nu̱ú cue̱he̱ ndóho ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ta tá na̱xini Jesús ña̱yivi cua̱ha̱ cán já na̱ta̱hvi̱ ini a sa̱ha̱ ná jáchi̱ ndóho ini na ta cávitá ini na tátu̱hun ndicachi, rí co̱ó da̱ candaa ñahá. ");
INSERT INTO mksNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hín a̱ cán: —Mé á nda̱a̱ ndúu cua̱há ndiva̱ha ña̱yivi, na̱ cúni̱ cuni jo̱ho tu̱hun Ndióxi̱ joo chá cuití na̱ cúni̱ cu̱hu̱n na̱ ca̱ha̱n na̱ ña̱ xi̱hín ña̱yivi. Cúú á tátu̱hun íin cua̱há ndiva̱ha níi̱ ña̱ xíní ñúhú jáquee joo ndíma̱ní ña̱yivi jáquee na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sa̱há ña̱ cán quéa̱ xíní ñúhú ca̱ca̱ ta̱hví ndó nu̱ Ndióxi̱ ña̱ ná chindahá mé á chága̱ na̱ cája chúun cuéntá mé á —cáchí Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tá na̱ndihi já na̱cana Jesús ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hi̱n á cán. Ta já na̱sa̱ha̱n ndée̱ nu̱ ná ña̱ ná cuu tavá na̱ ínima̱ quini ini ña̱yivi. Ta na̱sa̱ha̱n ndée̱ nu̱ ná ña̱ ná ndaja va̱ha na tá nu̱ú cue̱he̱ ndóho ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ña̱ yóho cúú qui̱vi̱ ndíhu̱xu̱ i̱vi̱ na̱ cúú apóstol xíca tuun xi̱hi̱n á cán: Da̱ nu̱ cuítí cán naní da̱ Simón ta cáha̱n ri na Pedro xi̱hi̱n dá. Ta inga da̱ cán cúú Andrés ñani da. Ta inga da cúú Jacobo xi̱hín ñani da, Juan. Ndíví da̱ yóho cúú dá ja̱hyi Zebedeo. ");
INSERT INTO mksNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Tañu na̱ cán ndáca̱a̱n ri Felipe xi̱hín Bartolomé xi̱hi̱n Tomás xi̱hi̱n Mateo, da̱ na̱játaca jiu̱hún cuéntá impuesto. Ta cán ndáca̱a̱n ri Jacobo, da̱ cúú ja̱hyi Alfeo xi̱hi̱n Lebeo, da̱ cáha̱n ri na Tadeo xi̱hi̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ta cán ndáca̱a̱n ri Simón, da̱ na̱xi̱ca cuéntá na̱ cananista xi̱hi̱n Judas Iscariote, mé da̱ na̱ji̱có túhún Jesús tá nu̱ ndíhí cán. ");
INSERT INTO mksNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tá na̱chindahá Jesús ndíhu̱xu̱ i̱vi̱ na̱ cán já na̱cachi a já xi̱hi̱n ná: —Coto a̱ cúhu̱n ndó chí ñuu ña̱yivi tóho̱, na̱ co̱ cúú na̱ Israel. Ta ni a̱ quíhvi ndó ñuu ñúhu chí estado Samaria. ");
INSERT INTO mksNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Va̱ha chága̱ ná cu̱hu̱n ndó ca̱ha̱n ndó tu̱hun Ndióxi̱ xi̱hín na̱ Israel jáchi̱ cúú ná tátu̱hun ndicachi, rí na̱ndiñúhú. ");
INSERT INTO mksNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cuáhán ndó ca̱xi tu̱hun ndó xi̱hi̱n ná ña̱ sa̱ na̱cayati qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ta ndaja va̱ha ndó na̱ quíhvi̱ ta jánditacu ndó ndi̱i ta ndaja va̱ha ndó na̱ ndóho cue̱he̱ táhyi̱. Ta tavá ndó rí quini ñúhu ínima̱ ña̱yivi. Ta a̱ quéhe ndó ya̱hvi sa̱há ña̱ cája ndó jáchi̱ co̱ó na̱xeen ndó ndée̱ ñéhe ndó ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","A̱ cáñehe toho ndó ni jiu̱hu̱n cuáán ni jiu̱hu̱n cúxú ni jiu̱hún ca̱a cuáhá caca nuu ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ta ni a̱ cáñehe ndó yátí cu̱hu̱n ndó íchi̱. Ta ni a̱ cáñehe ndó inga naha jáhma̱ ndó cu̱hu̱n xi̱hi̱n ndo̱. Ta ni a̱ cáñehe ndó inga ndu̱sa̱ ndó cu̱hu̱n ndo̱. Ta ni garróté a̱ cáñehe ndó cu̱hu̱n ndo̱. Jáchi̱ nditahan nu̱ú ña̱yivi quia̱hva na ña̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ʼTá ná xi̱nu̱ co̱o ndó in ñuu cáhnu á ñuu loho, xini ñúhú ndinducú ndó in ña̱yivi, na̱ cuu candeé ini ndó ta vehe na̱ ja̱n canduu ndó ja̱nda̱ quia̱hva ná xi̱nu̱ qui̱ví quee ndó cu̱hu̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ta tá ná xi̱nu̱ co̱o ndó vehe ja̱n ca̱ha̱n Ndióxi̱ ndó xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta tá ná ndiquehe va̱ha ña̱yivi vehe ja̱n ndo̱hó já quéa̱ cachi ndó xi̱hi̱n ná ña̱ ná coo va̱ha ini na. Joo tá co̱ cúni̱ na̱ ndíquehe va̱ha na ndo̱hó já quéa̱ a̱ cáha̱n ndo̱ xi̱hi̱n ná ña̱ ná coo va̱ha ini na. ");
INSERT INTO mksNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ta tá co̱ cúni̱ na̱ ndiquehe va̱ha na ndo̱hó ta ni co̱ cúni̱ na̱ cuni jo̱ho na nu̱ cáha̱n ndo̱ já quéa̱ cuáhán queta ndó vehe ja̱n á ñuu ja̱n ta catí ndó ña̱ yácá sa̱ha̱ ndó já ná na̱ha̱ ña̱ cua̱ha̱n cua̱chí na̱ cán ja̱ta̱ mé va na. ");
INSERT INTO mksNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jáchi̱ mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ná xi̱nu̱ co̱o qui̱vi̱ caja vií Ndióxi̱ sa̱há ña̱yivi ndúu ñuyíví já quéa̱ jándoho chága̱ Ndióxi̱ ini ña̱yivi ñuu ja̱n a̱ ju̱ú ga̱ tá quia̱hva na̱jándoho a ini na̱ ñuu Sodoma xi̱hín ñuu Gomorra sa̱nahá sa̱há ña̱ co̱ó na̱ndiquehe na ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ʼCande̱hé ndo̱. Ye̱he̱ chíndahá i̱ ndo̱hó cu̱hu̱n ndó tañu ña̱yivi quini. Cúú ndó tátu̱hun ndicachi válí tañu ndiva̱hyí ña̱ cán quéa̱ xíní ñúhú cuéntá va̱ha coo ndó tá quia̱hva cája co̱o̱. Ta xíní ñúhú coo mánsó ndo̱ tá quia̱hva cája ndija̱ta. ");
INSERT INTO mksNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cuéntá coo ndó jáchi̱ tiin na ndo̱hó ta ndiquia̱hva na ndo̱hó ndahá na̱ jutixia. Ta cani na ndo̱hó ini veñuhu. ");
INSERT INTO mksNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta sa̱ha̱ mí i̱ cañehe na ndo̱hó cu̱hu̱n ndó nu̱ú na̱ cúú gobernador á nu̱ú na̱ cómí cuéntá sa̱há in nación. Ta já ná cuu ndicani ndó sa̱há i̱ nu̱ú na̱ cán ta xi̱hín nu̱ú na̱ tóho̱, na̱ co̱ cúú na̱ Israel. ");
INSERT INTO mksNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Joo a̱ ndícani ini ndó sa̱ha̱ ndá tu̱hun ca̱ha̱n ndó tá ná ndiquia̱hva ña̱yivi ndo̱hó ndahá na̱ cán. Jáchi̱ tá ná ndindaa hora ca̱ha̱n ndó xi̱hi̱n ná já quéa̱ quia̱hva mé va Ndióxi̱ tu̱hun nu̱ ndó ña̱ ná cuu ca̱ha̱n ndó sa̱há i̱ nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Jáchi̱ a̱ ju̱ú ji̱ni̱ mé ndó quixi ña̱ ca̱ha̱n ndo̱. Ínima̱ yi̱i̱ Ndióxi̱ cacuu ña̱ quia̱hva tócó ndihi ña̱ ca̱ha̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ʼTa java ta̱a ji̱có túhún da̱ ñani da ta java da ji̱có túhún da̱ ja̱hyi da ña̱ ná cahní ñahá na̱. Ta java na ndicui̱ta na cani táhan na xi̱hi̱n tátá na̱ ña̱ ná cahní ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta ndaja táhan ña̱yivi ndúu ñuyíví yóho candají na̱ ndo̱hó sa̱há ye̱he̱. Joo ndá na̱ ná candi̱co̱ tuun íchi̱ mí i̱ ja̱nda̱ ná xi̱nu̱ qui̱vi̱ quivi na, na̱ cán cacuu na̱ ca̱cu ndaa ínima̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tá ná ndicui̱ta na caja xíxi na xi̱hi̱n ndó in ñuu já cunu ndó cu̱hu̱n ndó inga ñuu. Jáchi̱ mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá sa̱ xi̱nu̱ co̱o tucu ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi já a̱ ñáha caca nuu ndó ndijáá ñuu ndáca̱a̱n ñundáhyi̱ Israel. ");
INSERT INTO mksNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ʼCande̱hé ndo̱. Ni in túhún toho da̱ xíca jácuaha tia̱hva chága̱ da̱ nu̱ mé dá jána̱ha̱ ñahá cán. Ta ni in túhún mozo co̱ cúú dá da̱ cáhnu chága̱ nu̱ú xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","In da̱ jácuaha ndítahan caji̱i̱ íní da̱ tá sa̱ xíni̱ ndihi da ña̱ xíni̱ maestro da̱. Ta da̱ cúú mozo ndítahan caji̱i̱ ini da tá ná xi̱nu̱ da̱ cacuu da̱ cáhnu tátu̱hun xitoho da. Cande̱hé ndo̱. Tá ná cachi ña̱yivi xi̱hín da̱ cúú xitoho ndó ña̱ cúú da̱ Beelzebú, rí cúú tiñáhá sa̱cua̱ha̱ ndaja ga̱ ví cachi na xi̱hi̱n ndóhó. ");
INSERT INTO mksNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ʼCande̱hé ndo̱. A̱ cáyi̱hví toho ndó ña̱yivi jáchi̱ ni in túhún toho ña̱ha cája ña̱yivi a̱ cúu coo je̱hé nahá jáchi̱ va̱xi qui̱vi̱ tá ndáca náha̱ nu̱ á. Ta va̱tí cáha̱n je̱hé ña̱yivi tu̱hun joo va̱xi qui̱vi̱ tá canda̱a̱ ini ña̱yivi sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ña̱ cáha̱n ye̱he̱ xi̱hi̱n ndó nu̱ú naá xíní ñúhú ca̱ha̱n ndó ña̱ ndiví táhyí nani yéhe̱ ca̱ndii. Ta ña̱ cáha̱n je̱hé e̱ xi̱hi̱n ndo̱ xíní ñúhú ndaa ndó ji̱ni̱ véhe cayuhú ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A̱ cáyi̱hví toho ndó ña̱yivi, na̱ cuu caja cahní yiquí cu̱ñu ndó jáchi̱ ni in ña̱ha a̱ cúu caja na xi̱hi̱n ínima̱ ndo̱. Ndióxi̱ quéa̱ xíní ñúhú cayi̱hví ndo̱ jáchi̱ mé á cuu jándihi a sa̱ha̱ yiquí cu̱ñu ndó ta cuu jácana mé á ínima̱ ndo̱ ini indayá a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ʼCande̱hé ndo̱. Laa válí ndáchí ri̱ nu̱ táchi̱ ta núu ndiva̱ha jícó na̱ ri̱. Joo ni in rí cán co̱ cúyu nu̱ ñúhu̱ ña̱ quivi rí tá co̱ sáhan Ndióxi̱, tátá ndó ña̱ma̱ni̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ta viti caja ndó cuéntá xi̱hi̱n mé ndó. Ja̱nda̱ ijí ji̱ni̱ ndó ja̱n ndáhvi tá in tá in a nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ña̱ cán quéa̱ a̱ cáyi̱hví toho ndó jáchi̱ ndíya̱hvi chága̱ ndo̱ nu̱ Ndióxi̱ a̱ ju̱ú ga̱ cua̱há ndiva̱ha laa válí. ");
INSERT INTO mksNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ʼNdá na̱ cáxi tu̱hun nu̱ú ña̱yivi ña̱ cua̱ha̱n na̱ cuéntá mí i̱ já quéa̱ cachi mí i̱ sa̱há na̱ nu̱ Ndióxi̱, tátá i̱, mé a̱ íin indiví, ña̱ mé a̱ nda̱a̱ cúú ndusa na̱ cán cuéntá mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Joo ndá na̱ ná cachi xi̱hín ña̱yivi ña̱ co̱ xíni̱ toho na ye̱he̱ já quéa̱ ni ye̱he̱ a̱ ndícuni toho i̱ na̱ ña̱ cúú ná cuéntá mí i̱ nu̱ Ndióxi̱, tátá i̱, mé a̱ íin indiví. ");
INSERT INTO mksNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ʼA̱ cáhán toho ndó ña̱ na̱xi̱nu̱ i̱ ñuyíví yóho caja i̱ ña̱ ná coo va̱ha ini ña̱yivi. Co̱ cája i̱ já. Jáchi̱ ña̱ va̱xi ye̱he̱ caja i̱ quéa̱ ná cahnda java táhan na. ");
INSERT INTO mksNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Va̱xi i̱ jácani táhan i̱ da̱ta̱a xi̱hi̱n tátá da̱ sa̱há ye̱he̱. Ta va̱xi i̱ jácani táhan i̱ in ñáñáha̱ xi̱hi̱n náná ña̱ sa̱há ye̱he̱. Ta va̱xi i̱ jácani táhan i̱ ñá cúú sa̱nu xi̱hín xo̱jo ñá sa̱há ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta ndaja vehe mé ña̱yivi ndicui̱ta na cani táhan na sa̱há ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ʼTa ndá na̱ cúni̱ chága̱ tátá na̱ á náná na̱ a̱ ju̱ú ga̱ ye̱he̱ já quéa̱ co̱ó sa̱ha̱ toho na cacuu na cuéntá mí i̱. Ta ndá na̱ quíhvi̱ ini chága̱ ja̱hyi yií na̱ á ja̱hyi jíhí na̱ a̱ ju̱ú ga̱ ye̱he̱ já quéa̱ co̱ó sa̱ha̱ toho na cacuu na cuéntá mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ndá na̱ co̱ cúni̱ ndoho ini sa̱há ña̱ candi̱co̱ na̱ ye̱he̱ ta co̱ íin tia̱hva na quivi na sa̱há i̱ já quéa̱ co̱ó sa̱ha̱ toho na cacuu na cuéntá mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jáchi̱ ndá na̱ cátóó coo chága̱ na̱ ñuyíví yóho, na̱ cán cúú na̱ ndihi sa̱ha̱. Joo na̱ sáhan ndeé ini quivi sa̱há i̱, na̱ cán cúú na̱ ñe̱he̱ táhvi̱ na̱ catacu na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ʼNdá na̱ ndíquehe va̱ha ndo̱hó, ndíquehe va̱ha ri na ye̱he̱ va. Ta ndá na̱ ndíquehe va̱ha ye̱he̱, ndíquehe va̱ha ri na Ndióxi̱, mé a̱ na̱chindahá ye̱he̱ va̱xi i̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ndá na̱ ndíquehe va̱ha in profeta va̱xi cuéntá Ndióxi̱ já quéa̱ tá quia̱hva coo ya̱hvi ndiquehe profeta cán quia̱hva já coo ri ya̱hvi ndiquehe na̱ cán. Ta ndá na̱ ndíquehe in ta̱a va̱ha sa̱há ña̱ cúú dá ña̱yivi va̱ha já quéa̱ ndiquehe na̱ cán ya̱hvi na tá quia̱hva cáa ya̱hvi ndiquehe ta̱a va̱ha cán. ");
INSERT INTO mksNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta ndá na̱ ná quia̱hva ña̱ha va̱tí in yáxi̱ ticui̱í nu̱ú in na̱ cúú ja̱hyi i̱ yóho sa̱há ña̱ ndíco̱ na̱ íchi̱ cuéntá mí i̱, mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ cha̱hvi Ndióxi̱ sa̱há ña̱ma̱ni̱ cája na xi̱hi̱n ná —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tá na̱ndihi na̱na̱ha̱ Jesús nu̱ú na̱ xíca tuun xi̱hi̱n á cán ña̱ ndítahan caja na já na̱quee a cua̱ha̱n jána̱ha̱ nu̱ú ña̱yivi ta cáxi tu̱hun a tu̱hun Ndióxi̱ nu̱ú ña̱yivi ndúu ñundáhyi̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mé tiempo já na̱sandaca̱a̱n Juan veca̱a, mé dá cúú dá da̱ jácandúta̱ ña̱yivi. Ta cán na̱ñe̱he̱ dá tu̱hun sa̱há ña̱ náhnu cája Jesús. A̱nda̱ já na̱chindahá da̱ java na̱ xíca xi̱hi̱n dá nu̱ á ");
INSERT INTO mksNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ña̱ ná nda̱ca̱ tu̱hún na̱ Jesús á jivi ndusa cúú á Cristo, mé a̱ chindahá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi, á ndítahan candati na inga ga̱ quixi. ");
INSERT INTO mksNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tá na̱ndihi na̱nda̱ca̱ tu̱hún da̱ cán Jesús sa̱há ña̱ yóho já na̱cachi Jesús já xi̱hi̱n ná: —Cuáhán ndó ndicani ndó nu̱ Juan tócó ndihi ña̱ na̱xini ndó cája i̱ xi̱hi̱n tócó ndihi ña̱ na̱xini jo̱ho ndó cáha̱n i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ta ndicani ndó nu̱ dá ña̱ ndínu̱na̱ nu̱ú na̱ cua̱á ta ndícaca na̱ rénco̱ cája i̱. Ta ndaja va̱ha i̱ na̱ ndóho cue̱he̱ táhyi̱. Ta jándinu̱na̱ i̱ jo̱ho na jóho̱ já ná cuni jo̱ho na. Ta jánditacu u̱ ndi̱i. Ta cáxi tu̱hun i̱ tu̱hun Ndióxi̱ nu̱ú na̱ nda̱hví já ná cuu ca̱cu ndaa ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ta̱hví na̱cuu na̱ co̱ jándacoo ña̱ cándeé ini na ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tá na̱quee na̱ na̱chindahá Juan cán cua̱ha̱n na̱ já na̱casáhá Jesús cáha̱n xi̱hín ña̱yivi já cáchí a̱ já xi̱hi̱n ná: —Ndía̱ na̱ca̱hán ndo̱ cuni ndó tá na̱queta ndó na̱sa̱ha̱n ndó sánde̱hé ndo̱ Juan yucú íchí cán. A̱ ju̱ú da̱ cán cúú ta̱a láhá já quíji nuu da tátu̱hun quíji nuu in tóyo̱ó cája ta̱chi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ndía̱ na̱queta ndó cande̱hé ndó. A̱ ju̱ú da̱ cán cúú ta̱a ndíxi jahmá lánda̱ ndiva̱ha. Sa̱ xíni̱ va̱ha ndó ña̱ co̱ ndúu toho da̱ ndíxi jahmá lánda̱ yucú íchí. Ndá da̱ ndíxi jahmá lánda̱ cúú da̱ ndúu vehe rey cuití va. ");
INSERT INTO mksNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ndía̱ na̱sa̱ha̱n ndó cande̱hé ndó cán. Á co̱ó na̱sa̱ha̱n ndó cuni jo̱ho ndó nu̱ cáha̱n in da̱ cúú profeta nu̱ ndo̱. Mé a̱ nda̱a̱ da̱ cán cúú dá in profeta ta íin chága̱ sa̱ha̱ dá a̱ ju̱ú ga̱ inga profeta na̱sanduu sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jáchi̱ mé Juan cúú dá da̱ cáha̱n tu̱hun Ndióxi̱ sa̱ha̱ tá cáchí a̱ já: Chindahá i̱ in da̱ cánu̱ú cu̱hu̱n nu̱ mún, já ná caja tia̱hva da íchi̱ nu̱ú quisún, já na̱ca̱hyi̱ a̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cande̱hé ndo̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Tañu tócó ndihi ña̱yivi co̱ó ga̱ inga profeta cáhnu chága̱ a̱ ju̱ú ga̱ Juan, mé da̱ jácandúta̱ ña̱yivi. Joo ndá na̱ sa̱ na̱ndiquia̱hva mé ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná, va̱tí cúú ná na̱ co̱ó sa̱ha̱, na̱ cán cúú na̱ cáhnu chága̱ a̱ ju̱ú ga̱ Juan. ");
INSERT INTO mksNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ʼJa̱nda̱ qui̱ví na̱xi̱nu̱ Juan, da̱ jácandúta̱ ña̱yivi ta ja̱nda̱ viti ñúhú ndíhi ndiva̱ha ini ña̱yivi ndiquia̱hva na mé ná ndáha̱ Ndióxi̱. Ta na̱ sáhan tu̱hun ndeé ini, na̱ cán cúú na̱ ñe̱he̱ táhvi̱ cacomí Ndióxi̱ cuéntá sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ja̱nda̱ tá cáma̱ni̱ xi̱nu̱ Juan tócó ndihi ña̱ na̱ca̱hyí na̱ profeta xi̱hín ña̱ na̱ca̱hyí Moisés cáha̱n ña̱ va̱xi qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ta tá cúni̱ ndo̱ candúsa ndó ña̱ na̱ca̱hyí na̱ cán sa̱nahá já cuu canda̱a̱ ini ndó ña̱ Juan cúú dá da̱ na̱ca̱ha̱n na̱ cán sa̱ha̱ tá na̱cachi na ña̱ ndítahan quixi tucu profeta Elías ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na̱ íin jo̱ho, ná cuni jo̱ho na. ");
INSERT INTO mksNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ʼNá ca̱ha̱n i̱ xi̱hi̱n ndó ndaja íin ña̱yivi ndúu tiempo viti. Cúú ná tátu̱hun na̱ va̱lí sáco̱o sájíquí na̱ nu̱ú ya̱hvi ta cáyuhú na̱ nu̱ú java ga̱ na̱ va̱lí ndúu cán ta já cáchí na̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Na̱tiví nde̱ tótíví nu̱ ndo̱ joo co̱ó na̱xeen ndó cata sáhá ndo̱. Ta na̱xita cuéha̱ ndiva̱ha nde̱ nu̱ ndo̱ ta ni co̱ó na̱sacu ndó.” ");
INSERT INTO mksNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Quia̱hva já íin ña̱yivi ndúu tiempo viti jáchi̱ tá na̱quixi Juan, da̱ jácandúta̱ ña̱yivi ta na̱xijuhun da ta ni co̱ó na̱xihi da vino joo na̱cachi ndó sa̱ha̱ dá ña̱ ndáca̱a̱n ínima̱ quini ini da. ");
INSERT INTO mksNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ta tá na̱xi̱nu̱ ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta xíxi i̱ pan ta xíhi i̱ vino já na̱casáhá cáchí ndó sa̱há i̱ ña̱ cúú u̱ in ta̱a nde̱hé ndiva̱ha ta xíhi ndiva̱ha i̱. Ta cáchí ndó ña̱ cátóó ndiva̱ha i̱ cacuu amigo na̱ cája cua̱chi xi̱hín na̱ játaca jiu̱hún cuéntá impuesto. Joo na̱ cúni̱ cánda̱a̱ ini ña̱ nda̱a̱, na̱ cán cúú na̱ cánda̱a̱ ini ña̱ cája Juan ta cája ri ye̱he̱ ña̱ nda̱a̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tá na̱ndihi já na̱casáhá Jesús jána̱ni a ña̱yivi ndúu ndíjáá ñuu nu̱ú na̱caja cua̱ha̱ chága̱ mé á ña̱ xitúhún. Jáchi̱ va̱tí na̱caja cua̱ha̱ mé á ña̱ xitúhún nu̱ ná co̱ó na̱ndicó co̱o ini na nu̱ Ndióxi̱. Ña̱ cán quéa̱ na̱cachi Jesús já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Ndáhví na̱há na̱cuu ndó, na̱ ñuu Corazín. Ta ndáhví na̱há na̱cuu ndó, na̱ ñuu Betsaida. Cua̱há ndiva̱ha ña̱ náhnu na̱caja i̱ nu̱ ndo̱ joo co̱ó na̱xeen ndó ndicó co̱o ini ndó jándacoo ndó cua̱chi ndó. Sa̱nahá na̱jándihi Ndióxi̱ sa̱há ñuu Tiro xi̱hín sa̱há ñuu Sidón sa̱há cua̱chi na. Tá ná sa̱ha̱n i̱ caja i̱ ña̱ náhnu nu̱ú na̱ cán tá quia̱hva na̱caja i̱ nu̱ mé ndó, sa̱ na̱jándacoo va na cán cua̱chi na, nduu. Ta chí i̱vi̱ la̱á nda̱ca̱ ndixi na jahmá ndi̱i ta jácu̱yu na ya̱a̱ yiquí jíní na̱, nduu. Jáchi̱ xi̱hín ña̱ yóho jána̱ha̱ na̱ ña̱ na̱ndicó co̱o ini na sa̱há cua̱chi na. ");
INSERT INTO mksNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ tá ná xi̱nu̱ qui̱ví caja vií Ndióxi̱ sa̱há ña̱yivi já ndoho chága̱ ini mé ndó, na̱ ñuu ja̱n a̱ ju̱ú ga̱ tá quia̱hva na̱ndoho ini ña̱yivi na̱sanduu ñuu Tiro xi̱hín ñuu Sidón sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ta viti cáha̱n i̱ xi̱hi̱n ndó, na̱ ndúu ñuu Capernaum. Ja̱nda̱ indiví cúni̱ ndó cu̱hu̱n ndó joo sa̱há ña̱ sáá ini ndó cu̱hu̱n ndó ja̱nda̱ indayá, caja Ndióxi̱. Jáchi̱ tá ná caja i̱ ña̱ xitúhún nu̱ú ña̱yivi ñuu Sodoma tá quia̱hva na̱caja i̱ nu̱ ndóhó ta ni a̱ ndíhi sa̱há ñuu cán, nduu. ");
INSERT INTO mksNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ná xi̱nu̱ qui̱ví caja vií Ndióxi̱ sa̱há ña̱yivi já ndoho chága̱ ini mé ndó, na̱ ñuu ja̱n a̱ ju̱ú ga̱ tá quia̱hva na̱ndoho ini ña̱yivi na̱sanduu ñuu Sodoma sa̱nahá —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mé tiempo cán na̱ca̱ha̱n Jesús já na̱cachi a já: —Cája cáhnu i̱ ndo̱hó, tátá Ndióxi̱, ña̱ cúú xitoho tócó ndihi ña̱ha ndúu indiví xi̱hín ñuyíví. Jáchi̱ na̱jána̱ha̱ ndó ña̱ ndíchí ndiva̱ha nu̱ú ña̱yivi, na̱ co̱ó cua̱há sa̱ha̱ nu̱ú java ga̱ na̱. Ta na̱caja ndó ña̱ ná a̱ cu̱ú canda̱a̱ ini na̱ ndi̱chí xi̱hín na̱ tácu̱ ini ña̱ha mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Já na̱caja ndó jáchi̱ já na̱sacu ini ndó caja ndó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","A̱nda̱ já na̱cachi a já xi̱hín na̱ ndúu cán: —Na̱ndiquia̱hva tátá i̱ tócó ndihi ña̱ha ndahá i̱ ña̱ ná cacomí i̱ cuéntá sa̱há. Ta ni in túhún toho ña̱yivi co̱ xíni̱ va̱ha na ye̱he̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱. Mé Ndióxi̱, tátá i̱ cuití va xíni̱ va̱ha ye̱he̱. Ta ni in túhún toho na̱ co̱ xíni̱ va̱ha na yo cúú tátá i̱. In túhún ye̱he̱, da̱ cúú ja̱hyi a xíni̱ va̱ha i̱ yo cúú mé á. Ta ye̱he̱ cúú da̱ ca̱xi ndá ña̱yivi jána̱ha̱ i nu̱u̱ sa̱há Ndióxi̱, tátá i̱ já ná canda̱a̱ va̱ha ini na yo cúú mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Naha ndihi ndó nu̱ú i̱, na̱ sa̱ na̱canaá cája chúun. Taxi ndó ña̱ ndójo ndó ja̱n nu̱ú i̱ ta já ye̱he̱ caja i̱ ña̱ ná ndiquehe ndée̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ye̱he̱ cúni̱ ña̱ ná ndiquia̱hva ndó mé ndó ndahá i̱. Ta ña̱ yóho cúú á tátu̱hun in yúcú chínúu na sa̱há ji̱qui̱ ti̱ndi̱qui̱. Ta xíní ñúhú catia̱hva ndó caja ndó tá quia̱hva cája ye̱he̱. Jáchi̱ co̱ó cama ji̱ní i̱ xi̱hín ña̱yivi ta cúú u̱ ta̱a manso ndiva̱ha. Quia̱hva já caja ndó já ñe̱he̱ íní ndo̱ ndiquehe ndée̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Jáchi̱ yúcú chínúu i̱ ja̱ta̱ ndo̱ xi̱hín ña̱ha jácojo i̱ ja̱ta̱ ndo̱ cúú á ña̱ cama ñúhú la̱á —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ta ndaja coo in qui̱vi̱ ndíquehe ndée̱ ña̱yivi xíca Jesús cua̱ha̱n tañu nu̱ú na̱xutu na trigo. Ta sa̱há ña̱ cuíco na̱ xíca tuun xi̱hín Jesús sa̱há ña̱ cán quéa̱ na̱casáhá na̱ túhún na̱ java yu̱cu̱ ji̱ni̱ trigo cán ta tává na̱ trigo sáxí na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tá na̱xini na̱ fariseo ña̱ yóho já na̱casáhá na̱ cáha̱n cua̱chí na̱ nu̱ú Jesús. Já cáchí na̱ já: —Cande̱hé. Na̱ xi̱ca tuun xu̱hu̱n ja̱n cája na chuun ña̱ co̱ ndítahan caja ña̱yivi qui̱vi̱ ndíquehe ndée̱ yó —na̱cachi na xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Á a̱ ñáha toho cahvi ndó nu̱ú tu̱hun Ndióxi̱ nu̱ cáha̱n sa̱há ña̱ na̱caja David sa̱nahá tá na̱cuico da xi̱hín na̱ xíca xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ña̱ na̱caja da quéa̱ na̱qui̱hvi da ini veñu̱hu Ndióxi̱ ta na̱xixi da pan ña̱ yi̱i̱. Ta ni nu̱ mé dá ta ni nu̱ú na̱ xíca xi̱hi̱n dá cán co̱ cáni a nu̱u̱ cuxu na pan cán. In túhún ju̱tu̱ cuití va cáni a nu̱u̱ cuxu na pan cán. ");
INSERT INTO mksNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ta á a̱ ñáha toho cahvi ndó ña̱ na̱ca̱hyí Moisés nu̱ ley tá na̱ca̱hyí da̱ ña̱ co̱ cája toho ju̱tu̱ cua̱chi nu̱ Ndióxi̱ va̱tí cája chúun da veñu̱hu qui̱vi̱ ndíquehe ndée̱ ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ íin chága̱ sa̱há i̱, da̱ cándichi yóho a̱ ju̱ú ga̱ sa̱há veñu̱hu nu̱ cája cáhnu na Ndióxi̱ ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mé ndó co̱ cánda̱a̱ toho ini ndó ña̱ cúni̱ cachi tu̱hun Ndióxi̱ tá cáchí a̱ já: “Ye̱he̱ cúni̱ ña̱ ná candáhví ini ndó ña̱yivi jáchi̱ va̱ha chága̱ ña̱ yóho a̱ ju̱ú ga̱ ña̱ ná jo̱co̱ ndó quíti̱ nu̱ú i̱”, cáchí tu̱hun Ndióxi̱. Jáchi̱ tá ná canda̱a̱ ini ndó tu̱hun yóho, nduu ta a̱ chíca̱a̱n toho ndó cua̱chi ja̱tá ña̱yivi, na̱ co̱ó cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Cande̱hé ndó. Ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi, íin sa̱há i̱ cahnda i̱ chuun sa̱há qui̱vi̱ ndíquehe ndée̱ ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tá na̱ndihi já na̱quee Jesús cua̱ha̱n já na̱ndi̱hvi a veñu̱hu mé ñuu cán. ");
INSERT INTO mksNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta cán na̱sa̱ndaca̱a̱n in da̱ta̱a, da̱ na̱hi̱chi̱ ndáha̱. Ta sa̱há ña̱ ndúcú na̱ fariseo ndúu cán ndá quia̱hva caja na já ná cuu chica̱a̱n na̱ cua̱chi ja̱tá Jesús sa̱há ña̱ cán quéa̱ na̱nda̱ca̱ tu̱hún na̱ mé á já na̱cachi na já: —Á sáhan Ndióxi̱ ña̱ma̱ni̱ ndaja va̱hún na̱ quíhvi̱ qui̱vi̱ ndíquehe ndée̱ yo̱ —na̱cachi na̱ cán xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Cande̱hé ndó. Tá íin in ndicachi loho ja̱na̱ ndo̱ ta tá ná ndicava rí ini in táhvi̱ qui̱vi̱ ndíquehe ndée̱ yo̱, ama ná a̱ cúhu̱n ndó tavá ndó ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ta ndíya̱hvi chága̱ ña̱yivi a̱ ju̱ú ga̱ ndicachi. Ña̱ cán quéa̱ sáhan Ndióxi̱ ña̱ma̱ni̱ cája í ña̱ va̱ha qui̱vi̱ ndíquehe ndée̱ yo̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tá na̱ndihi na̱cachi a já xi̱hín da̱ta̱a, da̱ na̱hi̱chi̱ ndáha̱ cán já: —Jándaca̱a̱ ndáhu̱n —na̱cachi a xi̱hi̱n dá. Tá na̱jándaca̱a̱ da̱ ndáha̱ dá já na̱ndiva̱ha ndáha̱ dá. Ta cáa tá quia̱hva cáa inga ndáha̱ da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Joo tá na̱queta na̱ fariseo cán já na̱casáhá na̱ jándique táhan na tu̱hun na ña̱ cahní na̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tá na̱ñe̱he̱ Jesús tu̱hun ña̱ ndúcú na̱ cán cahní ñahá na̱ já na̱quee a cua̱ha̱n va ta cua̱há ndiva̱ha ña̱yivi ndíco̱ ja̱tá cua̱ha̱n. Ta ndaja táhan na̱ quíhvi̱ na̱ndaja va̱ha Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ta na̱sahnda Jesús chuun nu̱ú na̱ sa̱ na̱ndiva̱ha cán ña̱ ná a̱ cáxi tu̱hun na̱ nu̱ú ña̱yivi yo cúú mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tócó ndihi ña̱ yóho na̱ya̱ha já ná xi̱nu̱ co̱o nu̱ú tu̱hun na̱ca̱hyí profeta Isaías tá na̱ca̱hyí da̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yóho íin da̱ cája chúun cuéntá mí i̱, mé dá na̱ca̱xi i̱. Quíhvi̱ ndiva̱ha ini i̱ da̱ ta cáji̱i̱ íní i̱ xi̱hín ña̱ cája da. Ta jáchutu ndaa i̱ ínima̱ dá xi̱hi̱n ínima̱ yi̱i̱ mí i̱, ña̱ ná jána̱ha̱ da̱ nu̱ú ña̱yivi ndúu ñuyíví ndá quia̱hva cája vií i̱ sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ta ni a̱ cáha̱n cua̱chi toho da ta ni a̱ cáyuhú cóhó da̱, já quéa̱ a̱ cúni jo̱ho ña̱yivi xíca cállé nu̱ cáha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tá quia̱hva a̱ jácuachi toho da ndo̱o̱, dó sa̱ na̱ta̱hnu̱, quia̱hva já a̱ jácuachi toho da ña̱yivi, na̱ cávitá ini. Ta quia̱hva já ni a̱ ndáhvá toho da tití ñúhu̱ loho, ña̱ sa̱ cúni̱ nda̱hva̱ ja̱nda̱ quia̱hva ná quee va̱ha ña̱ nda̱a̱ xi̱hín ña̱ i̱hvi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ta ndaja táhan ña̱yivi ndúu níí cúú ñuyíví tandaa candeé ini na mé dá, na̱ca̱hyí Isaías sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Java ña̱yivi ñéhe na in da̱ cua̱á ta cúú dá da̱ níhi̱ jáchi̱ ndáca̱a̱n rí quini ini da. Ta tá na̱ndaja va̱ha Jesús da̱ já na̱sande̱hé da̱ ta na̱ndica̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tá na̱xini ña̱yivi ndúu cán ña̱ yóho já na̱catóntó ndiva̱ha na já na̱casáhá ndáca̱ tu̱hún táhan na já cáchí na̱ já: —Á a̱ ju̱ú da̱ yóho cúú da̱ na̱quixi chi̱chi rey David —cáchí xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tá na̱xini jo̱ho na̱ fariseo ña̱ cáha̱n ña̱yivi cán já na̱casáhá cáchí mé na̱ fariseo cán já: —Ta̱a yóho cúú tává da̱ rí quini ñúhu ini ña̱yivi jáchi̱ mé Beelzebú, rí cúú tiñáhá sa̱cua̱ha̱ nu̱ rí quini cán sáhan rí ndée̱ rí nu̱ dá cája da ña̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ta sa̱ xíni̱ va Jesús ña̱ cáhvi ini na̱ cán sa̱há ña̱ cán quéa̱ na̱cachi a já xi̱hi̱n ná: —Tá sáhndá java táhan ña̱yivi ndúu in nación ta ndúu na cua̱ha̱ táhndá já cásáhá cáni táhan ndaja táhan mé va na já cama chá ndihi sa̱há nu̱ ndúu na̱ cán. Ta quia̱hva já ya̱ha ri xi̱hín in ñuu á in vehe tá sáhndá java táhan ndaja táhan mé ná já quéa̱ jándihi na sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ta quia̱hva já yáha xi̱hín Satanás, rí cúú tiñáhá sa̱cua̱ha̱. Ta tá ná tavá rí inga rí quini ini ña̱yivi á tá ná cani táhan ndaja táhan mé rí já quéa̱ ndihi sa̱ha̱ ndée̱ ña̱ cómí ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mé ndó cáchí ndo̱ ña̱ tává i̱ rí quini ini ña̱yivi xi̱hi̱n ndée̱ Beelzebú, rí cúú tiñáhá sa̱cua̱ha̱. Joo tá mé a̱ nda̱a̱ cúú ndusa ña̱ cáchí ndo̱ sa̱há i̱ ja̱n, ndáchí quéhe na̱ cúú cuéntá mé ndó ja̱n ndée̱ tavá na̱ rí quini ini ña̱yivi. Ama ná cachi ndó ña̱ tává ndo̱ rí quini xi̱hi̱n ndée̱ tiñáhá sa̱cua̱ha̱. Ña̱ yóho náha̱ ña̱ co̱ cáhvi nda̱a̱ ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Cande̱hé ndo̱. Ye̱he̱ tává i̱ ínima̱ quini ini ña̱yivi xi̱hi̱n ndée̱ ínima̱ yi̱i̱ Ndióxi̱. Ta xi̱hín ña̱ yóho náha̱ cáxí a̱ ña̱ sa̱ na̱xi̱nu̱ co̱o qui̱vi̱ cacomí Ndióxi̱ cuéntá sa̱ha̱ ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ʼCande̱hé ndo̱. Sácú u̱ in quia̱hva nu̱ ndo̱. Ni in da̱ta̱a a̱ cúu ndi̱hvi da caja cuíhná da̱ ña̱ha vehe in da̱ ndacú joo tá ná cató da̱ da̱ ndacú cán já cuu quehe da ña̱ha da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ʼNdá na̱ co̱ó cua̱ha̱n xoo i̱, cúú ná na̱ co̱ cúní ye̱he̱. Jáchi̱ ndá na̱ co̱ chíndeé ye̱he̱ xi̱hín ña̱ cája i̱, cúú ná na̱ sájí nuu nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ʼÑa̱ cán quéa̱ cáchí i̱ xi̱hi̱n ndo̱ ña̱ caja cáhnu ini Ndióxi̱ sa̱ha̱ tá nu̱ú cua̱chi cája ña̱yivi xi̱hín sa̱ha̱ tá nu̱ú tu̱hun quini cáha̱n na̱. Joo tá ná ca̱ha̱n núu na sa̱ha̱ ínima̱ yi̱i̱ Ndióxi̱ já quéa̱ a̱ cája cáhnu toho ini Ndióxi̱ sa̱há ña̱ na̱caja na. ");
INSERT INTO mksNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Caja cáhnu ini Ndióxi̱ ja̱nda̱ sa̱ha̱ ndá na̱ ná cana̱há xi̱hín ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi joo tá ná cana̱há na̱ xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱ já quéa̱ a̱ cája cáhnu toho ini Ndióxi̱ sa̱ha̱ ná ni nani tácú na̱ ndúu na ñuyíví yóho ta ni tá cu̱hu̱n na̱ cavií sa̱ha̱ ná nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ʼXíní ñúhú jánde̱e ndó yitó va̱ha ña̱ ná cuun cui̱hi va̱ha nu̱ do̱. Jáchi̱ tá ná jánde̱e ndó yitó núu já quéa̱ cui̱hi núu cuun nu̱ do̱. Jáchi̱ xi̱hín cui̱hi cúun nu̱ú in yíto̱ cuu ndicuní ndá yíto̱ cúú dó. ");
INSERT INTO mksNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mé ndó cúú ndó tátu̱hun co̱o jáchi̱ cúú ndó na̱ quini sa̱há ña̱ cán quéa̱ cáha̱n ndó tu̱hun quini ta a̱ cu̱ú cana tu̱hun va̱ha yúhu̱ ndo̱. Jáchi̱ yúhu̱ ña̱yivi cána tócó ndihi ña̱ na̱ndicutú ñúhu ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","In ta̱a va̱ha cáha̱n da̱ ndinuhu ña̱ va̱ha jáchi̱ ndinuhu ña̱ va̱ha ñúhu ínima̱ dá. Ta in ta̱a quini cáha̱n da̱ ndinuhu ña̱ núu jáchi̱ ña̱ núu quéa̱ ndáca̱a̱n ínima̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ná ndindaa qui̱ví caja vií Ndióxi̱ sa̱há ña̱yivi ndúu ñuyíví a̱nda̱ jáví ndiquia̱hva ña̱yivi cuéntá nu̱ Ndióxi̱ sa̱há ndaja táhan tu̱hun núu na̱ca̱ha̱n na̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Jáchi̱ sa̱ha̱ mé tu̱hun na̱ca̱ha̱n ndó ja̱n caja vií Ndióxi̱ sa̱ha̱ ndo̱. Ta xi̱hín ña̱ ja̱n cachi Ndióxi̱ ña̱ á íin cua̱chi ndó á co̱ó cua̱chi ndó —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Java na̱ fariseo xi̱hín na̱ jána̱ha̱ ley Moisés na̱ca̱ha̱n na̱ xi̱hín Jesús já na̱cachi na já xi̱hi̱n á: —Maestro, cúni̱ nde̱ ña̱ ná caja ndó in ña̱ha xitúhún nu̱ú nde̱ já ná cuni nde̱ —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Já na̱nducú ñehe Jesús tu̱hun nu̱ú na̱ cán já na̱cachi a já xi̱hi̱n ná: —Ña̱yivi quini, na̱ co̱ cúni̱ cándúsa Ndióxi̱, na̱ yóho cúú na̱ cúni̱ cuni ña̱ xitúhún. Joo a̱ cúní toho na ña̱. Ña̱ cuni ndusa na quéa̱ ña̱ ndoho i̱ tá quia̱hva na̱ndoho Jonás, da̱ na̱sacuu profeta sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jáchi̱ tá quia̱hva na̱sa̱ndaca̱a̱n Jonás u̱ni̱ qui̱vi̱ xi̱hín u̱ni̱ ñuú ti̱xi ti̱yacá cáhnu tá na̱cocó rí da̱ quia̱hva já ndaca̱a̱n ri ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ti̱xi ñundáhyi̱ u̱ni̱ qui̱vi̱ xi̱hín u̱ni̱ ñuú. ");
INSERT INTO mksNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ta ña̱yivi na̱sanduu Nínive sa̱nahá cán ndacui̱ta na chica̱a̱n na̱ cua̱chi ja̱ta̱ ndó tá ná xi̱nu̱ qui̱ví caja vií Ndióxi̱ sa̱há cua̱chi ña̱yivi ndúu viti. Jáchi̱ mé na̱ na̱sanduu ñuu Nínive cán na̱jándacoo na cua̱chi cája na tá na̱ca̱ha̱n Jonás xi̱hi̱n ná ña̱ na̱cachi Ndióxi̱ coo. Ta ye̱he̱ íin chága̱ sa̱há i̱ a̱ ju̱ú ga̱ Jonás joo co̱ cándúsa ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jári tá ná xi̱nu̱ qui̱vi̱ caja vií Ndióxi̱ sa̱há cua̱chi ña̱yivi ndúu tiempo viti a̱nda̱ já ndacui̱ta in ñá na̱sacomí cuéntá sa̱há ña̱yivi ndúu chí xoo sur sa̱nahá ta chica̱a̱n ñá cua̱chi ja̱tá ña̱yivi ndúu tiempo viti. Jáchi̱ mé ñá cán va̱tí na̱sahi̱in xícá ndiva̱ha ñá nu̱ rey Salomón sa̱nahá na̱sa̱ha̱n ñá cuni jo̱ho ñá tu̱hun ndíchí cáha̱n da̱. Ta ye̱he̱ íin chága̱ sa̱há i̱ a̱ ju̱ú ga̱ Salomón joo co̱ cándúsa ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ʼTá quéta in ínima̱ quini ini in da̱ta̱a já quée rí cua̱ha̱n rí xíca nuu rí ndijáá yucú íchí ndínducú rí nu̱ú cando̱o rí. Ta tá co̱ ndíñe̱he̱ rí ña̱ já cásáhá cáhvi ini rí já: ");
INSERT INTO mksNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Coho ndicó co̱o tucú ini da nu̱ú na̱sa̱ndaca̱a̱n í cán jáchi̱ cúú á tátu̱hun vehé”, cáhán ri̱. Ta tá xínu̱ co̱o rí ini da̱ cán já sánde̱hé ri̱ ña̱ íin vií va ini da̱ cán tá quia̱hva vií ini vehe tá na̱ti̱hvi̱ á ta na̱nda̱ca̱ ndójó va̱ha tócó ndihi ña̱ha ini a. ");
INSERT INTO mksNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","A̱nda̱ já quée tucu mé rí quini cán cua̱ha̱n rí quehe rí u̱sa̱ ga̱ rí quini chága̱ a̱ ju̱ú ga̱ mé rí já xínu̱ ndihi rí ndi̱hvi rí ini da̱ta̱a cán. Ta mé da̱ cán ndiquini chága̱ da̱ a̱ ju̱ú ga̱ tá na̱sandaca̱a̱n in tála̱á rí ini da. Quia̱hva já ndoho ri ña̱yivi quini ndúu tiempo viti —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nani cáha̱n yi̱i̱ va Jesús xi̱hín ña̱yivi já na̱xi̱nu̱ co̱o náná Jesús xi̱hín ñani a ña̱ ná ca̱ha̱n na̱ xi̱hi̱n á cúni̱ na̱. Joo na̱cando̱o na ndíta na ja̱ta̱ véhe. ");
INSERT INTO mksNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Já na̱sa̱ha̱n in na cáxi tu̱hun na nu̱ú Jesús já cáchí na̱ já xi̱hi̱n á: —Ja̱ta̱ véhe cáa íin nánún xi̱hín ñanún ta ca̱ha̱n na̱ xu̱hu̱n cúni̱ na̱ —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Joo na̱nducú ñehe Jesús tu̱hun nu̱ú na̱ cán já na̱cachi a já xi̱hi̱n ná: —Cáha̱n i̱ xi̱hi̱n ndó ndá na̱ cúú ndusa náná i̱ xi̱hín ñani i̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A̱nda̱ já na̱na̱ha̱ ndáha̱ mé á na̱ xíca tuun xi̱hi̱n á cán já na̱cachi a já: —Na̱ yóho cúú ná tátu̱hun náná i̱ xi̱hín ñani i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Jáchi̱ ndá na̱ cája ña̱ cúni̱ Ndióxi̱, tátá i̱, mé a̱ íin indiví, na̱ cán cúú ná tátu̱hun ñani i̱ xi̱hín quia̱hva i̱ xi̱hi̱n náná i̱ —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sa̱ mé qui̱vi̱ já na̱queta Jesús vehe cán já na̱sa̱ha̱n na̱saco̱o a yati yuhú tañu̱hú cán. ");
INSERT INTO mksNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ta sa̱há ña̱ na̱taca cua̱há ndiva̱ha ña̱yivi nu̱ á sa̱há ña̱ cán quéa̱ na̱ndaa mé á ja̱tá in barco loho ta na̱saco̱o a ja̱tá do̱ cán nani ndúu ña̱yivi ñu̱tí yuhú tañu̱hú cán. ");
INSERT INTO mksNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A̱nda̱ já na̱casáhá jána̱ha̱ cua̱há ña̱ha nu̱ ná ta na̱sacu a quia̱hva nu̱ ná já na̱cachi a já xi̱hi̱n ná: —In da̱ sátá tata na̱quee da cua̱ha̱n da̱ cata da ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ta tá sátá da̱ ña̱ cua̱ha̱n da̱ já na̱cu̱yu java ña̱ íchi̱ ta cán na̱xi̱nu̱ laa ta na̱saxí rí ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ta java ña̱ na̱cu̱yu a tañu yu̱u̱ nu̱ú co̱ó cua̱ha̱ ñúhu̱. Ta cama chá na̱ndu̱ta̱ mé tata jáchi̱ co̱ cúná ñúhu̱ nu̱ú na̱cu̱yu a. ");
INSERT INTO mksNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Joo tá na̱queta ca̱ndii já na̱jáhi̱chi̱ ñahá sa̱há ña̱ co̱ó cua̱ha̱ yóho̱ a̱ chí na̱ndihi sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ta java tata na̱cu̱yu tañu tohíñú ta tá na̱sahnu tohíñú cán já na̱nditáha̱ ndihi a na̱caja tohíñú. ");
INSERT INTO mksNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ta java tata na̱cu̱yu a nu̱ ñuhú va̱ha ta já na̱sa̱ha̱n cua̱há ña̱ha ña̱ jáquee na nu̱ á. Java ña̱ na̱sa̱ha̱n in ciento a̱ nu̱ú in in tata ta java ña̱ na̱sa̱ha̱n u̱ni̱ jícó u̱xu̱ a̱ ta java ña̱ na̱sa̱ha̱n o̱co̱ u̱xu̱ a̱ nu̱ú in in tata. ");
INSERT INTO mksNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na̱ íin jo̱ho, ná cuni jo̱ho na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na̱ xíca tuun xi̱hín Jesús cán na̱cayati na nu̱ á já na̱casáhá ndáca̱ tu̱hún na̱ mé á ndá cuéntá quéa̱ jána̱ha̱ mé á xi̱hín quia̱hva cuití va nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ña̱ co̱ó na̱canda̱a̱ ini ndó jihna ña̱ cán cánda̱a̱ ini ndó viti jáchi̱ na̱suná Ndióxi̱ xíní túni̱ ndo̱ cánda̱a̱ ini ndó ndá quia̱hva cacomí mé á cuéntá sa̱há ña̱yivi. Joo na̱ a̱ ñáha cacomí Ndióxi̱ cuéntá sa̱ha̱, na̱ cán cúú na̱ sácú u̱ quia̱hva nu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jáchi̱ ndá na̱ sa̱ íin ña̱ha nu̱u̱, ñe̱he̱ táhvi̱ na̱ coo chága̱ ña̱ha nu̱ ná. Joo na̱ co̱ á ña̱ha nu̱u̱, ja̱nda̱ ña̱ chá íin nu̱ ná ndindaa. ");
INSERT INTO mksNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sa̱há ña̱ cán quéa̱ cáha̱n i̱ xi̱hín ndinuhu quia̱hva xi̱hi̱n mé ndó jáchi̱ va̱tí sánde̱hé na̱ joo cúú ná tátu̱hun na̱ co̱ tívi nu̱u̱. Ta va̱tí xíni̱ jo̱ho na joo cúú ná tátu̱hun na̱ jóho̱ jáchi̱ co̱ cánda̱a̱ ini na ña̱ cáha̱n i̱ xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ta xi̱hín ña̱ yóho xínu̱ co̱o nu̱ú tu̱hun na̱cachi profeta Isaías sa̱nahá ndiva̱ha tá na̱cachi da já: Va̱tí xíni̱ jo̱ho na joo cúú ná tátu̱hun na̱ jóho̱ jáchi̱ co̱ cánda̱a̱ ini na ña̱ cáha̱n i̱ xi̱hi̱n ná. Ta va̱tí sánde̱hé na̱ joo cúú ná tátu̱hun na̱ co̱ tívi nu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Jáchi̱ na̱ndaji xíní túni̱ tócó ndihi ña̱yivi ñuu yóho. Ta ndájí tuun jo̱ho na ta ndájí tuun nduchú núú na̱. Ña̱ cán quéa̱ a̱ cu̱ú cuni jo̱ho na, ta ni a̱ cu̱ú cande̱hé na̱, ta ni a̱ cu̱ú canda̱a̱ ini na ña̱ xíni̱ jo̱ho na. Ta xi̱hín ña̱ yóho co̱ ndícó co̱o na nu̱ú i̱ ña̱ ná ndaja va̱ha i̱ na̱, na̱ca̱hyí Isaías sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ʼJoo ta̱hví na̱cuu ndó jáchi̱ cánda̱a̱ ini ndó ña̱ sánde̱hé ndó xi̱hín ña̱ xíni̱ jo̱ho ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ cua̱há ndiva̱ha na̱ profeta xi̱hín cua̱há ndiva̱ha ña̱yivi va̱ha na̱xi̱ca̱ ini na cuni na ña̱ xíní ndó yóho viti joo co̱ó na̱xini na ña̱ ta na̱xi̱ca̱ ini na cuni jo̱ho na ña̱ xíni̱ jo̱ho ndó yóho joo co̱ó na̱xini jo̱ho na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ʼCuni jo̱ho ndó ña̱ cúni̱ cachi quia̱hva na̱sacu u̱ sa̱há da̱ sátá tata cán. ");
INSERT INTO mksNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ña̱yivi, na̱ xíni̱ jo̱ho tu̱hun va̱ha sa̱há ña̱ sa̱ na̱cayati qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi joo co̱ cánda̱a̱ ini na ña̱, na̱ cán cúú ná tátu̱hun tata ña̱ na̱cu̱yu íchi̱ cán. Jáchi̱ xínu̱ tiñáhá sa̱cua̱ha̱ ta tává ri̱ tu̱hun Ndióxi̱ cán ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ta tata ña̱ na̱cu̱yu tañu yu̱u̱ cán náha̱ ndá quia̱hva íin ña̱yivi, na̱ cáji̱i̱ ndiva̱ha ini ndíquehe tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Joo sa̱há ña̱ co̱ ñéhe̱ íní yóho̱ a̱ cu̱hu̱n cúná a̱ sa̱há ña̱ cán quéa̱ chá tiempo cuití va cándúsa na tu̱hun Ndióxi̱. Jáchi̱ tá cásáhá ndóho ini na sa̱há tu̱hun Ndióxi̱ chí jándacoo va na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ta tata ña̱ na̱cu̱yu tañu tohíñú cán náha̱ ndá quia̱hva íin ña̱yivi, na̱ xíni̱ jo̱ho tu̱hun Ndióxi̱ joo co̱ jándacoo na íchi̱ na̱xi̱ca na jihna. Ta cásáhá ndícani ini na sa̱há ña̱ha ñuyíví yóho ta cásáhá na̱ cátóó na̱ canduu cua̱há ña̱ha cuícá nu̱ ná ta cásáhá ndícají ini na caja na ña̱ núu. Sa̱há ña̱ cán quéa̱ cúú á tátu̱hun tata ña̱ co̱ cána ña̱ha jáquee na nu̱u̱ jáchi̱ co̱ó na̱sahnu na xi̱hín tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Joo tata ña̱ na̱cu̱yu nu̱ú ñuhú va̱ha cán náha̱ ndá quia̱hva íin ña̱yivi, na̱ xíni̱ jo̱ho tu̱hun Ndióxi̱ ta cánda̱a̱ ini na ña̱ ta cája na ña̱ cáji̱i̱ ini Ndióxi̱ xi̱hi̱n. Java na cúú ná tátu̱hun yu̱cu̱ trigo ña̱ na̱sa̱ha̱n in ciento a̱ nu̱ú in in tata. Ta java na cúú ná tátu̱hun tata ña̱ na̱sa̱ha̱n u̱ni̱ jico u̱xu̱ a̱ nu̱ú in in tata. Ta java na cúú ná tátu̱hun tata ña̱ na̱sa̱ha̱n o̱co̱ u̱xu̱ a̱ nu̱ú in in a —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","A̱nda̱ já na̱sacu Jesús inga quia̱hva nu̱ú ña̱yivi ndúu cán já na̱cachi a já xi̱hi̱n ná: —Tá ná casáhá cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi já cacuu a tátu̱hun tá na̱xutu in da̱ta̱a trigo ña̱ va̱ha nu̱ ñúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Joo tá sa̱ ndúu ndihi na quíji̱ na̱ já na̱xi̱nu̱ co̱o in da̱ co̱ cúní táhan xi̱hi̱n dá ta na̱chihin da tata yu̱cu̱ quini tañu trigo cán já na̱quee da cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ta tá na̱sahnu trigo cán ta na̱casáhá cána yóco̱ a̱ já na̱ndu̱ta̱ ri yu̱cu̱ quini cán. ");
INSERT INTO mksNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A̱nda̱ já na̱sa̱ha̱n na̱ cája chúun cán cáha̱n na̱ xi̱hín xitoho na já na̱cachi na já: “Cande̱hé ndo̱. Tata va̱ha quéa̱ na̱chihin ndó nu̱ ñúhu̱ ndo̱ joo co̱ cánda̱a̱ ini nde̱ ndáchí na̱quixi yu̱cu̱ quini na̱nana xi̱hi̱n á yóho”, na̱cachi na̱ cán xi̱hín xitoho na. ");
INSERT INTO mksNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A̱nda̱ já na̱nducú ñehe da̱ cán tu̱hun nu̱ ná já na̱cachi da já xi̱hi̱n ná: “Ndá da̱ co̱ cúní ye̱he̱, da̱ cán cúú da̱ na̱caja ña̱ yóho”, na̱cachi da. A̱nda̱ já na̱cachi na̱ cája chúun nu̱ dá cán já xi̱hi̱n dá: “Á co̱ cúni̱ ndó ña̱ ná qui̱hvi nde̱ tuhun ndihi nde̱ yu̱cu̱ quini cáa tañu trigo”, na̱cachi na xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A̱nda̱ já na̱cachi da já xi̱hi̱n ná: “Ná coo mé á jáchi̱ tia̱hva náá nani túhun ndó yu̱cu̱ quini ja̱n cuu tuhun ndó yu̱cu̱ trigo xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Va̱ha chá ná quia̱hva í ña̱ma̱ni̱ cuahnu a xi̱hi̱n trigo ja̱nda̱ quia̱hva ná ndindaa tiempo jáqueé trigo. Ta tá sa̱ jáqueé já cahnda i̱ chuun nu̱ú na̱ jáquee ña̱ ná tavá xóo na yu̱cu̱ quini jihna ñúhú ta ná cató na̱ ña̱ tá nuhni tá nuhni ña̱ ná chica̱a̱n ñúhu̱ ná ña̱. Ta a̱nda̱ jáví ná játaca na trigo taán va̱ha na ini yáca̱ ña̱ha i̱”, na̱cachi da —cáchí Jesús sácú a̱ quia̱hva nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ta na̱sacu Jesús inga quia̱hva nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Tá ná xi̱nu̱ co̱o qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi já cúú á tátu̱hun in ndíqui̱ mostaza ña̱ chíhin in da̱ta̱a nu̱ ñúhu̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Cúú á ndíqui̱ loho chága̱ nu̱ tócó ndihi ndíqui̱ válí íin ñuyíví. Joo sáhnu a ja̱nda̱ quia̱hva ndúu a in yíto̱, dó cáhnu nu̱ ndíhi yíto̱ nu̱ xínu̱ co̱o laa cáva̱ha rí cho̱ho̱ ri̱ nu̱ ndáha̱ do̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ta na̱sacu Jesús inga quia̱hva nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Tá ná cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi já cacuu a tátu̱hun tá cává táhan in ñáñáha̱ u̱ni̱ táhndá náhnu harina xi̱hín loho yusá na̱xa̱a̱ ña̱ ná jánañu a tócó ndihi mé yúsa̱ cán —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Xi̱hín ndinuhu quia̱hva cuití na̱jána̱ha̱ Jesús tócó ndihi ña̱ yóho nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Já na̱caja Jesús ña̱ ná xi̱nu̱ co̱o nu̱ú ña̱ na̱cachi in da̱ profeta sa̱nahá tá na̱cachi da já: Xi̱hín ndinuhu quia̱hva cuití va ca̱ha̱n i̱ xi̱hín ña̱yivi, ta ca̱ha̱n i̱ sa̱há ña̱ha na̱sahi̱in je̱hé nu̱ ná ja̱nda̱ mé sa̱ha̱ tá cáma̱ní ca̱va̱ sáhá sa̱há ñuyíví —cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tá na̱ndihi na̱ndinda̱yí Jesús ña̱yivi cua̱ha̱ ndúu cán já na̱qui̱hvi a ini vehe. A̱nda̱ já na̱cativi na̱ xíca tuun xi̱hín a̱ cán nu̱ á já na̱cachi na já xi̱hi̱n á: —Ná ndicani ndó nu̱ú nde̱ ndía̱ cúni̱ cachi quia̱hva na̱sacu ndó sa̱há yu̱cu̱ quini na̱nana tañu trigo cán —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Da̱ xútu tata va̱ha cúú ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ta ñúhu̱ nu̱ xútu u̱ tata cúú á ña̱yivi ñuyíví. Ta tata va̱ha cán cúú á yuhú nu̱ú na̱ cómí Ndióxi̱ cuéntá sa̱ha̱. Ta yu̱cu̱ quini cán cúú á yuhú nu̱ú ña̱yivi quini, na̱ cúú cuéntá rí quini. ");
INSERT INTO mksNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ta da̱ co̱ cúní táhan xi̱hín i̱ na̱sa̱ha̱n da̱ na̱xutu da yu̱cu̱ quini nu̱ ñúhu̱ cán ta cúú dá yuhú nu̱ú tiñáhá sa̱cua̱ha̱. Ta tiempo jáquee na̱ cán cúú á tá ná xi̱nu̱ co̱o qui̱ví caja vií Ndióxi̱ sa̱há ña̱yivi ndúu ñuyíví. Ta na̱ xíca jáquee cán cúú ná táto̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ta tá quia̱hva na̱caja na̱ cán xi̱hín yu̱cu̱ quini tá na̱játaca na ña̱ ta na̱chica̱a̱n ñúhu̱ na̱ ña̱ quia̱hva já ya̱ha ri xi̱hín ña̱yivi ñuyíví yóho tá ná tandaa qui̱ví ndihi sa̱há ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ta ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi chindahá i̱ táto̱ mí i̱ ña̱ ná cahnda java táhan na na̱ cómí i̱ cuéntá sa̱ha̱ xi̱hín na̱ co̱ cúú cuéntá mí i̱. Jáchi̱ na̱ cán jáca̱ha̱n na̱ inga na caja na cua̱chi xi̱hín java ga̱ na̱ cája ña̱ núu. ");
INSERT INTO mksNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ta jáque̱ta nuu i̱ na̱ ini indayá ta cán cuacu na a̱nda̱ quia̱hva chicáhñá nu̱hu̱ na̱ jáchi̱ ndóho ndiva̱ha ini na. ");
INSERT INTO mksNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ta a̱nda̱ já na̱ cája ña̱ cúni̱ Ndióxi̱ ndiyi̱hvi̱ ndaa na tá quia̱hva yéhe̱ ca̱ndii nu̱ú cacomí Ndióxi̱ cuéntá sa̱ha̱ ná, mé á cúú á tátá na̱. Ndá na̱ íin jo̱ho, ná cuni jo̱ho na. ");
INSERT INTO mksNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ʼTá ná cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi cacuu a tátu̱hun ña̱ yáha xi̱hín in da̱ta̱a tá ndíñe̱he̱ dá in sa̱tó jiu̱hún ña̱ ndáca̱a̱n je̱hé in ñundáhyi̱. Ta tá na̱ndihi já chíja̱hvi tucu da ña̱ xi̱hi̱n ñúhu̱. Ta já cávatá ndiva̱ha da cu̱hu̱n da̱ ji̱có da̱ tócó ndihi ña̱ cómí da̱ ña̱ ná cueen da ñundáhyi̱ nu̱ú na̱ndu̱xu̱ mé sa̱tó jiu̱hún cán. ");
INSERT INTO mksNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ʼTá ná cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi cacuu a tátu̱hun tá xíca nuu in da̱ cája nda̱hvi̱ ndúcú da̱ jíqui̱ sándacu na ña̱ ya̱hvi ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ta tá ndítahan da in jíqui̱ ya̱hvi ndiva̱ha já cua̱ha̱n da̱ ji̱có da̱ ndihi ña̱ha cómí da̱ ña̱ ná cueen da jíqui̱ ya̱hvi ndiva̱ha cán. ");
INSERT INTO mksNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ʼTa tá ná cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi cacuu a tátu̱hun in ñúnu̱ jácana na nu̱ú tañu̱hú ta já tíin na tá nu̱ú ti̱yacá. ");
INSERT INTO mksNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ta tá sa̱ na̱chutú ñúnu̱ cán já tává na̱ ti̱yacá cán yuhú tañu̱hú ta cán sáco̱o na ndácahnda java na ri̱. Ta rí va̱ha cán táán va̱ha na ini to̱yi̱cá na̱ joo rí núu cán xíta̱ ri̱ cája na. ");
INSERT INTO mksNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Quia̱hva já ya̱ha ri xi̱hín ña̱yivi tá ná ndihi sa̱há ñuyíví. Jáchi̱ queta táto̱ Ndióxi̱ ndacahnda java na̱ va̱ha tañu na̱ quini. ");
INSERT INTO mksNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ta ña̱yivi quini cán chica̱a̱n na̱ ini indayá ta cán cuacu na ja̱nda̱ quia̱hva chicáhñá nu̱hu̱ na̱ jáchi̱ ndóho ndiva̱ha ini na —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tá na̱ndihi já na̱nda̱ca̱ tu̱hún Jesús na̱ já na̱cachi a já: —Á cánda̱a̱ ini ndó tócó ndihi ña̱ cáha̱n i̱ yóho —cáchí a̱. —A̱ja̱n, cánda̱a̱ ini nde̱ ña̱ —na̱cachi na̱ cán xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Tá jácuaha in da̱ jána̱ha̱ ley Moisés sa̱há ndaja ndiquia̱hva da mé dá ndáha̱ Ndióxi̱ cacomí a̱ cuéntá sa̱ha̱ dá já cúú dá tátu̱hun in da̱ta̱a, da̱ íin ña̱ha ini vehe. Ta xíni̱ va̱ha da tavá da̱ ña̱ha da á cúú á ña̱ sa̱á á ña̱ yatá —cáchí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tá na̱ndihi na̱jána̱ha̱ Jesús xi̱hín quia̱hva yóho já na̱quee a cuanúhu̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tá na̱xi̱nu̱ a̱ ñuu mé á já na̱casáhá jána̱ha̱ ini veñu̱hu cán. Ta ja̱ndá joho cátóntó ña̱yivi ñuu cán já cáchí na̱ já: —Ta ndájá na̱catia̱hva na̱há ri da̱ yóho ña̱ xíni̱ da̱. Ta ndaja cája da ña̱ha xitúhún yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Á a̱ ju̱ú da̱ yóho cúú ja̱hyi da̱ cája chúun xi̱hi̱n yíto̱. Á a̱ ju̱ú náná da̱ yóho cúú María. Ta ñani da cúú Jacobo xi̱hín José xi̱hín Simón xi̱hín Judas viti. ");
INSERT INTO mksNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ta sa̱ mé ñuu yóho ndúu ri quia̱hva da ja̱n. Ndájá na̱catia̱hva na̱há da̱ ña̱ jána̱ha̱ da̱ nu̱ yo̱, dá já —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ta chí co̱ó na̱xeen na candúsa ñahá na̱. Sa̱há ña̱ cán quéa̱ na̱cachi a já xi̱hi̱n ná: —Va̱tí tócó ndihi ña̱yivi cája cáhnu na in profeta joo na̱ vehe da xi̱hín na̱ ñuu da co̱ cándúsa na da̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta co̱ó na̱caja cua̱há Jesús ña̱ xitúhún ñuu cán jáchi̱ co̱ó na̱candúsa toho ña̱yivi cán mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mé tiempo cán na̱xini jo̱ho Herodes, da̱ cúú gobernador cán ña̱ ndítúhún na̱ sa̱há Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A̱nda̱ já na̱cachi da já xi̱hi̱n mozo da̱: —Á a̱ ju̱ú Jesús cúú á Juan, da̱ na̱jácandúta̱ ña̱yivi ta viti na̱nditacu tucu da. Sa̱há ña̱ cán quéa̱ íin ndée̱ da̱ cája da tócó ndihi ña̱ cája da yóho —cáchí Herodes. ");
INSERT INTO mksNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Jáchi̱ ja̱nda̱ mé sa̱ha̱ na̱tiin Herodes Juan na̱cató ñahá da̱ ta na̱chica̱a̱n da̱ da̱ veca̱a. Ta na̱caja da ña̱ yóho sa̱há Herodías, ñá na̱sacuu ñájíhí Felipe, ñani da. ");
INSERT INTO mksNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jáchi̱ mé Juan na̱jána̱ni ñahá da̱ sa̱há ña̱ íin Herodes xi̱hi̱n ña̱ ta já na̱cachi da: —Co̱ ndítahan coún xi̱hi̱n ñájíhí ñanún —na̱cachi Juan xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ta ja̱nda̱ já na̱nducú Herodes cahní da̱ Juan joo a̱ cu̱ú caja da ña̱ jáchi̱ yíhví da̱ ña̱yivi sa̱há ña̱ cándúsa na ña̱ cúú Juan in profeta na̱chindahá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Joo in tañu nani ndáca̱a̱n Juan veca̱a já na̱cava̱ha Herodes víco̱ sa̱há qui̱vi̱ na̱cacu da. Ta na̱nda̱ca̱ ndíchí ñá cúú ja̱hyi Herodías cán na̱xita sáhá ña̱ nu̱ ndíhi na̱ ndúu víco̱ cán. Ta a̱ ju̱ú quia̱hva na̱caji̱i̱ ini Herodes xi̱hín ña̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sa̱há ña̱ cán quéa̱ qui̱vi̱ Ndióxi̱ tává da̱ tá sáhan da tu̱hun da nu̱ ñá cán ña̱ quia̱hva da nu̱ ña̱ ndá ña̱ cúni̱ mé ñá ca̱ca̱ ñá nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tá na̱ndihi na̱nda̱ca̱ tu̱hún jihna ñá náná ña̱ já ndáva ñá na̱sa̱ha̱n ñá nu̱ Herodes já cáchí ña̱ já xi̱hi̱n dá: —Viti ñúhú cúni̱ ña̱ ná quia̱hva ndó yiquí jíní Juan, da̱ jácandúta̱ ña̱yivi nu̱ú i̱ ini in co̱ho̱ cáhnu —na̱cachi ñá xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tá na̱cachi ñá já xi̱hi̱n Herodes já na̱cacuéha̱ ndiva̱ha ini da. Joo sa̱há ña̱ sa̱ na̱tavá da̱ qui̱vi̱ Ndióxi̱ tá na̱sa̱ha̱n da̱ tu̱hun dá nu̱ ñá cán ta sa̱há ña̱ cúni̱ da̱ cando̱o va̱ha da nu̱ú na̱ ndúu víco̱ xi̱hín da̱ cán sa̱há ña̱ cán quéa̱ na̱sahnda da chuun ña̱ ná quia̱hva na ña̱ nu̱ ñá. ");
INSERT INTO mksNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chí na̱sahnda da chuun ña̱ ná chitúhu̱n ná yiquí jíní Juan ini veca̱a cán. ");
INSERT INTO mksNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ta já na̱chica̱a̱n na̱ yiquí jíní da̱ ini in co̱ho̱ cáhnu já na̱sa̱ha̱n na̱ ña̱ nu̱ ñá cán. A̱nda̱ já na̱ndiquia̱hva ñá cán ña̱ ndáha̱ náná ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","A̱nda̱ jáví na̱xi̱nu̱ na̱ na̱xi̱ca xi̱hi̱n Juan cán já na̱sa̱ha̱n na̱ na̱ndiquehe na yiquí cu̱ñu da ta na̱jándu̱xu̱ na̱ da̱. Ta já na̱sa̱ha̱n na̱ na̱ca̱xi tu̱hun na ña̱ yóho nu̱ú Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tá na̱xini jo̱ho Jesús sa̱ha̱ Juan já na̱quee xóo a ini in barco loho cua̱ha̱n nu̱ú co̱ ndúu ña̱yivi. Joo tá na̱xini jo̱ho ña̱yivi ña̱ cua̱ha̱n Jesús já na̱quee na ñuu na ndíco̱ na̱ cua̱ha̱n sáhá na̱ nu̱ íin a. ");
INSERT INTO mksNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ta tá na̱nuu Jesús barco cán já na̱xini a cua̱há ndiva̱ha ña̱yivi ta na̱ta̱hvi̱ ini a sa̱ha̱ ná. Ta chí na̱ndaja va̱ha mé á na̱ quíhvi̱ na̱quixi tañu na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ta tá sa̱ cáhini cua̱ha̱n já na̱cayati na̱ xíca tuun xi̱hín a̱ cán nu̱ á. Já cáchí na̱ já xi̱hi̱n á: —Sa̱ na̱hini va ta a̱ ju̱ú xoo nu̱ ndúu ña̱yivi quéa̱ yóho. Ndinda̱yí ndó ña̱yivi ná cu̱hu̱n na̱ ñuu válí yati ja̱n já ná cueen na ña̱ cuxu na —na̱cachi na̱ cán xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A̱nda̱ já na̱cachi a já xi̱hi̱n ná: —Co̱ xíní ñúhú toho quee na cu̱hu̱n na̱. Mé ndó quia̱hva ndó ná cuxu na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A̱nda̱ já na̱cachi tucu na̱ cán já xi̱hi̱n á: —Co̱ mé ña̱ha va cuxu na yóho. U̱hu̱n víxí pan xi̱hín i̱vi̱ la̱á ti̱yacá cuití va íin yóho —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Ta̱xi ndó a̱ chóho —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A̱nda̱ já na̱sahnda Jesús chuun ña̱ ná ndaca nduu ndihi na̱ cán nu̱ú yu̱cu̱. A̱nda̱ já na̱tiin a ndíhu̱hu̱n pan xi̱hi̱n ndíví ti̱yacá cán já na̱sande̱hé a̱ chí indiví já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱. Tá na̱ndihi já na̱sahnda java pan ta na̱sa̱ha̱n ña̱ nu̱ú na̱ xíca tuun xi̱hi̱n á cán ta na̱ cán na̱ndicahnda na ña̱ nu̱ú ña̱yivi cua̱ha̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ta tócó ndihi na na̱xixi na ja̱nda̱ quia̱hva na̱chutú na̱. Ta tá na̱ndihi na̱xixi na já na̱játaca na ña̱ na̱cando̱o cán ta na̱jáchutú na̱ u̱xu̱ i̱vi̱ to̱yi̱cá xi̱hín ña̱ na̱cando̱o cán. ");
INSERT INTO mksNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ta tócó ndihi na̱ na̱xixi cán na̱sa̱cuu na tátu̱hun u̱hu̱n mil ta̱a. Co̱ cáha̱n sa̱há na̱ji̱hí xi̱hín na̱ va̱lí. ");
INSERT INTO mksNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ta tá na̱ndihi já na̱caja Jesús ña̱ ná ndi̱hvi na̱ xíca tuun xi̱hi̱n á cán ini in barco ña̱ ná cu̱hu̱n cuéé na̱ inga xoo tañu̱hú cán nani cando̱o tóo mé á jándinda̱yí a̱ ña̱yivi cua̱ha̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ta tá sa̱ na̱jándu̱ta̱ tócó ndihi ña̱yivi já na̱ndaa mé á yúcu̱ cua̱ha̱n ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱. Tá na̱ndihi já na̱cuaá ta in túhún mé á ndáca̱a̱n xíca̱ ta̱hví a̱ nu̱ Ndióxi̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ta ndaja coo barco loho, dó cándojó na̱ xíca tuun xi̱hi̱n á cán sa̱ na̱xi̱nu̱ co̱o dó ja̱nda̱ ma̱hñú tañu̱hú cua̱ha̱n do̱. Ta ndíco̱jo̱ ndiva̱ha tañu̱hú jáchi̱ xoo cua̱ha̱n na̱ va̱xi ta̱chi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Joo tátu̱hun sa̱ cua̱ha̱n tívi já xíca sáhá Jesús cua̱ha̱n nu̱ú tañu̱hú na̱xi̱nu̱ a̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ta tá na̱xini na xíca sáhá Jesús va̱xi a nu̱ú tañu̱hú cán já na̱catóntó na̱. Ta na̱casáhá na̱ cáyuhú cóhó na̱ sa̱há ña̱ yíhví na̱ já cáchí na̱ já: —Ínima̱ quéa̱ va̱xi yóho —cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Joo i̱vi̱ la̱á na̱ndica̱ha̱n Jesús xi̱hi̱n ná já cáchí a̱ já: —Ndacú coo ini ndó jáchi̱ ye̱he̱ va cúú u̱. A̱ yíhví toho ndó —na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A̱nda̱ já na̱cachi Pedro já xi̱hín Jesús: —Xitoho i̱, tá ta̱ jivi cúú mé ndó cahnda ndó chuun ña̱ ná cuu sa̱a̱ i̱ nu̱ ndo̱ ta ná caca i̱ nu̱ú tañu̱hú —na̱cachi da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ta já cáchí Jesús já: —Naha quíi̱ —cáchí a̱ xi̱hi̱n dá. A̱nda̱ já na̱nuu Pedro barco cán ta na̱casáhá xíca sáhá da̱ nu̱ú tañu̱hú cua̱ha̱n da̱ nu̱ú Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Joo tá na̱xini da ta̱chi̱ ndeé xícó nu̱ú tañu̱hú cán já na̱yi̱hví da̱. Chí i̱vi̱ la̱á na̱casáhá quéta nuu da cua̱ha̱n da̱ ini tañu̱hú. Já na̱cayuhú cóhó da̱ já cáchí da̱ já xi̱hín Jesús: —Chindeé ndó ye̱he̱, xitoho i̱ —na̱cachi da xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ta cama chá na̱tiin Jesús ndáha̱ da̱ ta já na̱cachi a já xi̱hi̱n dá: —Ndá cuéntá quéa̱ co̱ cándeé chága̱ inún ye̱he̱ ta na̱casáhá cáhvi i̱vi̱ joho inún —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ta tá na̱ndaa ndíví na̱ ja̱ta̱ barco já na̱catáji̱ ta̱chi̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A̱nda̱ já na̱caja cáhnu na̱ ñúhu ini barco cán Jesús já cáchí na̱ já xi̱hi̱n á: —Mé a̱ nda̱a̱ táhyí cúú jivi ndusa ndó in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ —na̱cachi na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ta já na̱xi̱ca loho ga̱ na̱ nu̱ú tañu̱hú cán já na̱xi̱nu̱ co̱o na ñundáhyi̱ Genesaret. ");
INSERT INTO mksNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ta tá na̱ndicuni ña̱yivi ndúu cán mé á já na̱chindahá na̱ chuun na̱sa̱ha̱n nu̱ú ndaja táhan ña̱yivi ndúu ndijáá ñundáhyi̱ cán. Já ñéhe ndihi na na̱ quíhvi̱ na̱casa̱a̱ na̱ nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ta na̱ quíhvi̱ cán na̱xi̱ca̱ ta̱hví na̱ nu̱ á ña̱ ná quia̱hva ña̱ma̱ni̱ cani ndaa ndáha̱ ná yuhú jahmá níhnu a ta tócó ndihi na̱ na̱cani ndaa ndáha̱ jahmá a̱ na̱ndiva̱ha na. ");
INSERT INTO mksNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ndaja coo java na̱ fariseo xi̱hín java na̱ jána̱ha̱ ley Moisés ndúu ñuu Jerusalén cán na̱cayati na nu̱ú Jesús já na̱casáhá cáchí na̱ já xi̱hi̱n á: ");
INSERT INTO mksNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Ndáva̱ha co̱ cája na̱ xíca tuun xu̱hu̱n ña̱ na̱cachi tásáhnu jícó yo̱ caja na. Ndáva̱ha xíxi na tá cáma̱ni̱ ndahá na̱ tá quia̱hva sáhndá ley caja na —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já: —Ta jári ndóhó va, ndá cuéntá quéa̱ jándacoo ndó ña̱ sáhndá Ndióxi̱ nu̱ ndó caja ndó. Ta ña̱ cája ndó quéa̱ ndíco̱ ndó costumbre mé va ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jáchi̱ sáhndá Ndióxi̱ chuun já cáchí a̱ já: “Caja cáhnún tátún xi̱hi̱n nánún.” Ta jári cáchí a̱: “Ndá na̱ ná chíca̱a̱n cháhan ja̱ta̱ tátá na̱ á náná na̱, ndítahan quivi na”, cáchí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Joo ndóhó, jána̱ha̱ ndó nu̱ú ña̱yivi ña̱ cuu ca̱ha̱n na̱ já xi̱hi̱n tátá na̱ á náná na̱: “A̱ cu̱ú chindeé e̱ ndo̱hó jáchi̱ sa̱ na̱sacu xoo i̱ ña̱ha i̱ quia̱hva i̱ ña̱ nu̱ Ndióxi̱”, cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tá ná cachi na ña̱ yóho já quéa̱ co̱ ndúsa̱ ga̱ chindeé na̱ tátá náná na̱. Quia̱hva joho cája ndó ta sácu xóo ndó ña̱ na̱sahnda Ndióxi̱ chuun nu̱ ndo̱ ta ndája ndó a̱ tátu̱hun in ña̱ha ña̱ co̱ó sa̱ha̱. Jáchi̱ ndíco̱ cáhnu ndó ña̱ na̱jándacoo tásáhnu jícó ndo̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Co̱ cúú ndó tá quia̱hva ndáa ndó. Mé a̱ nda̱a̱ na̱ca̱ha̱n profeta Isaías sa̱ha̱ ndo̱ sa̱nahá tá na̱ca̱hyí da̱ ña̱ na̱cachi Ndióxi̱: ");
INSERT INTO mksNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yuhú ni̱nu uun na cája cáhnu na ye̱he̱. Ta co̱ cája cáhnu na ye̱he̱ xi̱hín ndinuhu ínima̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ta mé a̱ uun quéa̱ cája cáhnu na ye̱he̱, jáchi̱ ña̱ jána̱ha̱ na̱ nu̱ú ña̱yivi cuití va cúú á ña̱ quíxi ji̱ni̱ mé va na, na̱cachi profeta Isaías sa̱nahá ndiva̱ha —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tá na̱ndihi já na̱cana Jesús tócó ndihi ña̱yivi ndúu cán já na̱cachi a já xi̱hi̱n ná: —Cuni jo̱ho va̱ha ndó ña̱ cáha̱n i̱ xi̱hi̱n ndó ta ná canda̱a̱ ini ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A̱ ju̱ú ña̱ha xíxi ña̱yivi ndája quini ínima̱ ná. Tu̱hun quini quéta yúhu̱ ná ña̱ ja̱n quéa̱ cája quini ñahá —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tá na̱ndihi já na̱cayati na̱ xíca tuun xi̱hín Jesús cán nu̱ á já na̱cachi na já xi̱hi̱n á: —Chí a̱ váha mé na̱cuu ini na̱ fariseo tá na̱xini jo̱ho na ña̱ na̱cachi ndó ja̱n —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ña̱yivi, na̱ co̱ ndíquehe va̱ha tu̱hun Ndióxi̱ cúú ná tátu̱hun in yíto̱, dó co̱ó na̱jánde̱e Ndióxi̱, tátá i̱ ña̱ íin indiví. Sa̱há ña̱ co̱ cúú dó cuéntá mé á já tandaa qui̱vi̱ ña̱ tuhun mé á do̱ a̱nda̱ yóho̱ do̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sa̱há ña̱ cán quéa̱ co̱ ndítahan ndicani ini ndó sa̱há na̱ ja̱n jáchi̱ na̱ cua̱á va cúú ná. Ta a̱ cúu toho caja in da̱ cua̱á candaca da inga da̱ cua̱á cu̱hu̱n da̱ jáchi̱ ndíví já da̱ ndacava da yávi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tá na̱ndihi já na̱cachi Pedro já xi̱hín Jesús: —Ndicani loho ndó nu̱ú nde̱ ndaja cáa ña̱ cáchí ndo̱ ña̱ co̱ cája quini toho ña̱ xíxi ña̱yivi mé ná jáchi̱ co̱ cánda̱a̱ ini nde̱ ña̱ —na̱cachi Pedro xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Já na̱cachi Jesús já xi̱hi̱n ná: —Á co̱ó toho xíní túni̱ ri ndóhó va, va̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Jáchi̱ co̱ cánda̱a̱ ini ndó ña̱ tócó ndihi ña̱ha xíxi ña̱yivi a̱ cu̱ú caja quini a na̱. Jáchi̱ ña̱ xíxi ña̱yivi co̱ xínu̱ a̱ ini ínima̱ ná joo xínu̱ co̱o ña̱ ti̱xi va na já queta tucu a yiquí cu̱ñu na. ");
INSERT INTO mksNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ña̱ cuu ndaja quini ña̱yivi cúú ña̱ quíxi ínima̱ ná tátu̱hun tu̱hun cáha̱n na̱ xi̱hín ña̱ cája na. ");
INSERT INTO mksNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Jáchi̱ chí ínima̱ ña̱yivi quíxi ña̱ cáhvi núu ini na tátu̱hun ña̱ cáhvi ini na cahní na̱ ndi̱i. Ta sa̱ mé cán quíxi ña̱ cáhvi ini in da̱ta̱a coo da xi̱hi̱n ñájíhí ñani táhan da á xi̱hín in ñá co̱ cúú ñájíhí da̱. Ta sa̱ mé cán quíxi ña̱ ndiáva̱ íní da̱ caja cuíhná da̱. Ta sa̱ mé cán quíxi ña̱ cáva̱ha jíquí da̱ tu̱hun sa̱há ñani táhan da ta jári quíxi ña̱ cána̱há da̱ xi̱hi̱n Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tócó ndihi ña̱ cáhvi núu ini ña̱yivi caja na, ña̱ yóho quéa̱ ndája quini a na̱. Joo co̱ cáquini toho ña̱yivi sa̱há ña̱ co̱ ndáhá na̱ tá cáma̱ni̱ cuxu na tá quia̱hva íin costumbre na —na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tá na̱ndihi já na̱quee Jesús cua̱ha̱n chí ñundáhyi̱ cuéntá Tiro xi̱hi̱n cuéntá Sidón cán. ");
INSERT INTO mksNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ta nu̱ xíca cua̱ha̱n cán na̱queta in ñáñáha̱ ñundáhyi̱ Canaán nu̱ á já cáyuhú ña̱ já cáchí ña̱ já xi̱hi̱n á: —Xitoho i̱, da̱ na̱quixi chi̱chi David caja ndó ña̱ma̱ni̱ candáhví loho ini ndó ye̱he̱. Chindeé ndó ja̱hyi jíhí i̱ jáchi̱ rí quini ndáca̱a̱n ini ñá —na̱cachi ñáñáha̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Joo ni in túhún tu̱hun co̱ó na̱nducú ñehe Jesús nu̱ ña̱. A̱nda̱ já na̱cativi na̱ xíca tuun xi̱hín a̱ cán nu̱ á já na̱cachi na já xi̱hi̱n á: —Ta̱xi ndó ñá ja̱n ná quee ñá cu̱hu̱n ña̱ jáchi̱ cáyuhú ña̱ ndácaa ñá ja̱ta̱ yó va̱xi ñá —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A̱nda̱ já na̱cachi Jesús xi̱hi̱n ñáñáha̱ cán já: —Na̱chindahá Ndióxi̱ ye̱he̱ va̱xi i̱ nu̱ú ña̱yivi Israel cuití va, mé na̱ cúú tátu̱hun ndicachi, rí na̱ndiñúhú —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A̱nda̱ já ndáva ñá cán na̱xi̱nu̱ co̱o ñá na̱caxítí ña̱ nu̱ Jesús já cáchí ña̱ já xi̱hi̱n á: —Caja ndó ña̱ma̱ní chindeé loho ndó ye̱he̱, xitoho i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ñá: —A̱ váha toho candaa i̱ pan ndahá na̱ va̱lí ta já cana i̱ ña̱ nu̱ú ti̱na —na̱cachi Jesús xi̱hi̱n ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A̱nda̱ já na̱cachi ñá cán já xi̱hín Jesús: —Mé a̱ nda̱a̱ cáha̱n ndo̱ joo a̱nda̱ ti̱na, rí ndúu ti̱xi mesa xíxi rí ña̱ jácu̱yu ja̱hyi xitoho rí —na̱cachi ñá cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ñá: —Mé a̱ nda̱a̱ cándeé cáhnu inún Ndióxi̱. Ná coo a tá quia̱hva cúni̱ mún —na̱cachi Jesús xi̱hi̱n ñá. Chí mé hora já na̱ndiva̱ha ja̱hyi jíhí ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tá na̱ndihi já na̱quee Jesús cua̱ha̱n já na̱xi̱nu̱ co̱o a yati yuhú tañu̱hú Galilea. Já na̱ndaa in ji̱ni̱ yúcu̱ ta cán na̱saco̱o a. ");
INSERT INTO mksNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ta já na̱casáhá na̱taca cua̱há ndiva̱ha ña̱yivi já ñéhe na na̱ quíhvi̱ sa̱ha̱ xi̱hín na̱ cua̱á xi̱hín na̱ níhi̱ xi̱hín na̱ rénco̱ ndáha̱. Ta cua̱há ga̱ nu̱ú na̱ quíhvi̱ ñéhe na na̱casa̱a̱ na̱ na̱chinduu na na̱ nu̱ Jesús. Ta na̱ndaja va̱ha mé á na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ta xi̱hín ña̱ yóho a̱ ju̱ú quia̱hva na̱catóntó na̱ tá na̱xini na ña̱ na̱casáhá ndíca̱ha̱n na̱ níhi̱. Ta na̱catóntó na̱ tá na̱xini na ña̱ na̱ndiva̱ha ndahá na̱ rénco̱ ta ndícaca va̱ha na̱ quíhvi̱ sa̱ha̱ ta quia̱hva já na̱ndiva̱ha ri na̱ cua̱á. Ta na̱casáhá na̱ cája cáhnu na Ndióxi̱, mé a̱ cómí cuéntá sa̱há na̱ Israel. ");
INSERT INTO mksNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A̱nda̱ já na̱cana Jesús na̱ xíca tuun xi̱hi̱n á já na̱cachi a já xi̱hi̱n ná: —Táhnda̱ ndiva̱ha ini i̱ sa̱há ña̱yivi yóho jáchi̱ sa̱ na̱xi̱nu̱ u̱ni̱ qui̱vi̱ ndúu na xi̱hín i̱ ta chí co̱ó ga̱ ña̱ cuxu na. Ta co̱ cúni̱ chindahá i̱ na̱ nu̱hu̱ na̱ vehe na jáchi̱ cáma̱ni̱ cuxu na ta tia̱hva náá cuitá na̱ ta cu̱yu na íchi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A̱nda̱ já na̱cachi na̱ xíca tuun xi̱hín a̱ cán já: —Co̱ó toho ñuu yati va ta ni mí, a̱ cu̱ú quia̱hva í ña̱ cuxu na jáchi̱ co̱ó toho ña̱yivi ndúu yóho nu̱ú cueén ña̱ cuxu na —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Já na̱cachi Jesús já: —Ndaja pan cómí ndo̱. Já na̱cachi na̱ cán já: —U̱sa̱ pan xi̱hín java tiya̱cá válí. ");
INSERT INTO mksNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","A̱nda̱ já na̱sahnda Jesús chuun ña̱ ná caco̱o ndihi ña̱yivi nu̱ ñúhu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ta já na̱tiin a ndíhu̱sa̱ pan cán xi̱hín java tiya̱cá válí cán já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱. Ta já na̱sahnda java ña̱ ta na̱sa̱ha̱n ña̱ nu̱ú na̱ xíca tuun xi̱hi̱n á cán ña̱ ná ndicahnda na ña̱ nu̱ú ña̱yivi cua̱ha̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ta na̱xixi tócó ndihi na ja̱nda̱ quia̱hva na̱chutú ti̱xi na. Ta tá na̱jánditaca na ña̱ na̱cando̱o cán já na̱chutú u̱sa̱ to̱yi̱cá xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ta na̱ na̱xixi cán cúú ná co̱mi̱ mil ta̱a ta co̱ cáha̱n sa̱há na̱ji̱hí xi̱hín na̱ va̱lí. ");
INSERT INTO mksNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ta tá na̱ndihi na̱ndinda̱yí Jesús ña̱yivi já na̱ndi̱hvi a ini barco já na̱xi̱nu̱ co̱o a ñundáhyi̱ cuéntá Magdala. ");
INSERT INTO mksNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ta ndaja coo na̱xi̱nu̱ co̱o na̱ fariseo xi̱hín na̱ saduceo nu̱ Jesús. Ta sa̱há ña̱ cúni̱ na̱ coto ndojó cuití ñahá na̱ sa̱há ña̱ cán quéa̱ na̱xi̱ca̱ na̱ nu̱ á ña̱ ná caja in ña̱ xitúhún cuéntá indiví já ná canda̱a̱ ini na á mé a̱ nda̱a̱ cúú á ña̱ na̱chindahá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Tá na̱hini já cáchí ndo̱ já: “Tiempo va̱ha ndiva̱ha cacuu a jáchi̱ ndíyéhe̱ cuáhá indiví”, cáchí ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta naha cáchí ndo̱ já: “Viti ndusa quéa̱ cuun ndeé ndiva̱ha ja̱vi̱ jáchi̱ íin vícó ndiva̱ha ta íin vi̱co̱ cuáhá indiví”, cáchí ndo̱. Co̱ cúú ndó tá quia̱hva ndáa ndó. Ndá cuéntá quéa̱ tia̱hva ndó ndicuni ndó ndá quéa̱ coo tá sánde̱hé ndó indiví joo co̱ tiáhva ndó ndicuni ndó ndá tiempo cúú á viti. ");
INSERT INTO mksNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ña̱yivi quini, na̱ co̱ cúni̱ candúsa Ndióxi̱, na̱ cán cúú na̱ xíca̱ ña̱ ná caja i̱ ña̱ xitúhún nu̱ ná. Joo ni in túhún toho ña̱ha xitúhún a̱ cája ga̱ i̱ nu̱ ná. In túhún ña̱ cande̱hé na̱ cacuu a ña̱ tandaa qui̱vi̱ ndoho i̱ tá quia̱hva na̱ndoho profeta Jonás sa̱nahá ndiva̱ha —na̱cachi Jesús xi̱hi̱n ná. Já na̱quee a cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ta ndaja coo na̱xi̱nu̱ co̱o a inga xoo tañu̱hú xi̱hín na̱ xíca tuun xi̱hi̱n á cán ta na̱ndindójó na̱ cán cañehe na pan cuxu na. ");
INSERT INTO mksNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tá na̱ndihi já na̱cachi Jesús já xi̱hi̱n ná: —Cande̱hé ndo̱. Cuéntá coo ndó xi̱hín na̱ fariseo ta xi̱hín na̱ saduceo ja̱n jáchi̱ ña̱ jána̱ha̱ na̱ cúú á tátu̱hun yúsa̱ na̱xa̱a̱ ña̱ cává táhan na xi̱hi̱n harina cáva̱ha na pan —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Joo na̱ xíca tuun xi̱hi̱n á cán ndítúhún xi̱hi̱n táhan na ña̱ na̱cachi Jesús já sa̱há ña̱ co̱ó pan ñéhe na cua̱ha̱n xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ta tá na̱canda̱a̱ ini Jesús ña̱ cáha̱n na̱ já na̱cachi a já xi̱hi̱n ná: —Ndá cuéntá quéa̱ co̱ cándeé cáhnu ini ndó ye̱he̱ ta cáha̱n ndo̱ ña̱ cáchí i̱ ña̱ yóho xi̱hi̱n ndo̱ sa̱há ña̱ co̱ ñéhe ndó pan va̱xi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","A̱ ñáha cánda̱a̱ ini ndó. Ndítahan ndicu̱hu̱n ini ndó ña̱ na̱ndaja cua̱há i̱ u̱hu̱n víxí pan tá na̱xixi u̱hu̱n mil ta̱a. Ta sa̱ xíni̱ ndó ndaja to̱yi̱cá na̱jáchutú ndo̱ xi̱hín ña̱ na̱cando̱o cán. ");
INSERT INTO mksNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ta ndítahan ndicu̱hu̱n ini ndó ña̱ na̱caja i̱ xi̱hín u̱sa̱ pan tá na̱ndicahnda i̱ ña̱ na̱xixi co̱mi̱ mil ta̱a ta sa̱ xíni̱ ndó ndaja to̱yi̱cá na̱jáchutú ndo̱ xi̱hín ña̱ na̱cando̱o cán. ");
INSERT INTO mksNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ndá cuéntá quéa̱ co̱ cánda̱a̱ toho ini ndó ña̱ co̱ó na̱cachi i̱ ña̱ yóho xi̱hi̱n ndó sa̱há ña̱ co̱ó pan ñéhe ndó va̱xi ndó. Joo na̱cachi i̱ ña̱ cuéntá coo ndó xi̱hín na̱ fariseo ta xi̱hín na̱ saduceo jáchi̱ ña̱ jána̱ha̱ na̱ cúú á tátu̱hun yusá na̱xa̱a̱ ña̱ cává táhan na xi̱hín harina cáva̱ha na pan —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tá na̱cachi Jesús ña̱ yóho já na̱canda̱a̱ ini na̱ xíca tuun xi̱hi̱n á cán ña̱ a̱ ju̱ú toho sa̱há yusá na̱xa̱a̱ cáha̱n Jesús sa̱ha̱. Ña̱ cúni̱ Jesús cachi a xi̱hi̱n ná quéa̱ cuéntá va̱ha ná coo na xi̱hín ña̱ jána̱ha̱ na̱ fariseo xi̱hín na̱ saduceo. ");
INSERT INTO mksNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tá na̱xi̱nu̱ co̱o Jesús ñundáhyi̱ Cesarea cuéntá Filipo já na̱nda̱ca̱ tu̱hún a̱ na̱ xíca tuun xi̱hi̱n á cán já na̱cachi a já xi̱hi̱n ná: —Ndá da̱ cáchí ña̱yivi cúú ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Já na̱cachi na̱ cán já: —Java na cáchí na̱ ña̱ cúú ndó Juan, da̱ na̱caja ndúta̱ ña̱yivi. Ta java na cáchí na̱ ña̱ cúú ndó profeta Elías. Ta java na cáchí na̱ ña̱ cúú ndó profeta Jeremías. Ta java na cáchí na̱ ña̱ cúú ndó in táhan profeta na̱sa̱nduu sa̱nahá —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ta ndóhó ri, ndá da̱ cáchí ndó cúú u̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A̱nda̱ já na̱nducú ñehe Simón Pedro tu̱hun nu̱ Jesús já na̱cachi da já xi̱hi̱n á: —Mé ndó cúú Cristo, ña̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. Ta cúú ndó in túhún ji̱ni̱ já ja̱hyi Ndióxi̱, mé a̱ tácú íin indiví —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já xi̱hi̱n dá: —Ta̱hví na̱há cúún, Simón, ja̱hyi Jonás jáchi̱ ni in túhún ña̱yivi co̱ó na̱ca̱xi tu̱hun ña̱ yóho xu̱hu̱n. In túhún tátá i̱, mé a̱ íin indiví na̱na̱ha̱ ña̱ yóho nu̱u̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta quia̱hva joho cáchí ri ye̱he̱ sa̱ha̱ yóhó: Yo̱hó cúún Pedro ta qui̱vu̱n cúni̱ cachi a tóto̱. Ta cúún tátu̱hun yu̱u̱ ndúhu̱ sa̱há in vehe nu̱ú cava̱ha i̱ veñu̱hu mí i̱ jáchi̱ yóhó caca nuún ca̱hu̱n sa̱há i̱ nu̱ú ña̱yivi já ná quee va̱ha na xi̱hín tiñáhá sa̱cua̱ha̱ já ná a̱ cúhu̱n na̱ indayá. ");
INSERT INTO mksNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ta caja i̱ xu̱hu̱n ña̱ ná cuu ndicanún nu̱ú ña̱yivi ndaja ndiquia̱hva na mé ná ndáha̱ i̱ cacomí i̱ cuéntá sa̱ha̱ ná. Cacuu a tátu̱hun quia̱hva i̱ yáví nu̱u̱n ña̱ ná cunún íchi̱ nu̱ú ndi̱hvi ña̱yivi cacomí i̱ cuéntá sa̱ha̱ ná. Tá co̱ sáhu̱n ña̱ma̱ni̱ ná ndi̱hvi ña̱yivi cán já quéa̱ a̱ quiáhva toho i̱ ña̱ma̱ni̱ nu̱ ná. Joo tá sáhu̱n ña̱ma̱ni̱ nu̱ ná ndi̱hvi na̱ cán já quéa̱ quia̱hva ri ye̱he̱ ña̱ma̱ni̱ nu̱ ná —cáchí a̱ xi̱hi̱n Pedro. ");
INSERT INTO mksNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A̱nda̱ já na̱sahnda Jesús chuun nu̱ú na̱ xíca tuun xi̱hi̱n á cán ña̱ ná a̱ cáxi tu̱hun na xi̱hín ni in túhún ña̱yivi ña̱ cúú mé á Cristo, mé á na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ta ja̱nda̱ mé qui̱vi̱ já na̱casáhá Jesús cáxi tu̱hun a xi̱hín na̱ xíca tuun xi̱hi̱n á ña̱ ndítahan nu̱ á cu̱hu̱n a̱ ñuu Jerusalén. Ta mé cán ndoho ndiva̱ha ini a ndahá na̱ sa̱cua̱ha̱ veñu̱hu xi̱hín ndahá na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín ndahá na̱ jána̱ha̱ ley Moisés. Ta caja xíxi ri na̱ cán va xi̱hi̱n á ta cahní ñahá na̱. Joo tá ná xi̱nu̱ u̱ni̱ qui̱vi̱ nditacu tucu a. ");
INSERT INTO mksNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","A̱nda̱ já na̱tavá xóo Pedro Jesús já na̱casáhá da̱ jána̱ni ñahá da̱ já na̱cachi da já xi̱hi̱n á: —Ama ná ya̱ha ña̱ yóho xi̱hi̱n ndó, xitoho i̱. Ná a̱ quiáhva toho Ndióxi̱ ña̱ma̱ni̱ ndoho ndó já —na̱cachi Pedro xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Joo na̱ca̱va̱ nu̱u̱ Jesús sánde̱hé a̱ nu̱ Pedro ta já cáchí a̱ já xi̱hi̱n dá: —Cuáhán quee Satanás, rí cúú tiñáhá sa̱cua̱ha̱. Tá quia̱hva íin na sájí nuu nu̱ ná quia̱hva já íún nu̱ú i̱. Jáchi̱ co̱ cáhvi inún tá quia̱hva cáhvi ini Ndióxi̱ joo cáhvi inún tá quia̱hva cáhvi ini ña̱yivi cuéntá ñuyíví yóho —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hín a̱ cán: —Ndá na̱ cúni̱ candi̱co̱ ye̱he̱ ndítahan nu̱ ná ndi̱hi chága̱ ini na sa̱há ye̱he̱ a̱ ju̱ú ga̱ sa̱ha̱ mé ná. Ta ndítahan coo tia̱hva na ndoho ini na sa̱há ye̱he̱. Ta co̱ó caja toho a ná quivi na sa̱há i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jáchi̱ ndá na̱ catóó coo chága̱ ñuyíví yóho ndihi sa̱ha̱ ná. Joo ndá na̱ sáha̱n ndeé ini quivi sa̱há i̱ xi̱hín sa̱há tu̱hun Ndióxi̱, ñe̱he̱ táhvi̱ ná catacu na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Va̱tí ná quee va̱ha in na ñuyíví yóho ta cómí na̱ tócó ndihi ña̱ha ñuyíví yóho joo ndá chuun quéa̱ tá nu̱ ndíhí ndihi sa̱ha̱ ná indayá. Jáchi̱ ni in ña̱ha a̱ cu̱ú cha̱hvi in na sa̱ha̱ ínima̱ ná ña̱ ná a̱ cúhu̱n na̱ indayá. ");
INSERT INTO mksNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jáchi̱ ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi quixi tucu u̱ xi̱hi̱n ndée̱ Ndióxi̱, tátá i̱ ta xi̱hi̱n ndée̱ táto̱ Ndióxi̱. Mé tiempo cán náha̱ ndaja cáhnu cúú ye̱he̱. A̱nda̱ já cha̱hvi i̱ nu̱ú in in ña̱yivi sa̱há ña̱ha na̱caja na nani na̱sa̱nduu na ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ java na ndúu yóho a̱ quíví toho na ja̱nda̱ quia̱hva ná xi̱nu̱ qui̱vi̱ cuni na quixi tucu ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi cacomí i̱ cuéntá sa̱há na̱ cúú cuéntá mí i̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tá na̱ya̱ha i̱ñu̱ qui̱vi̱ já na̱ndaa Jesús in yucú jícó ta ndáca táhan Pedro xi̱hi̱n Jacobo xi̱hín ñani da Juan cua̱ha̱n na̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ta nu̱ táhyí mé na̱ cán na̱ndija̱ma quia̱hva cáa. Ta a̱ ju̱ú quia̱hva na̱ndiyéhe̱ nu̱u̱ á tá quia̱hva ndíyéhe̱ ca̱ndii. Ta jáhma̱ ndíxi a na̱ndiyaa ca̱chi̱ ña̱ ta chí a̱ ju̱ú quia̱hva yéhe̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ta ndaja coo na̱nda̱ca̱ náha̱ Moisés xi̱hi̱n Elías ta na̱casáhá ndítúhún da̱ xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","A̱nda̱ já na̱ndica̱ha̱n Pedro xi̱hín Jesús já na̱cachi da já xi̱hi̱n á: —Va̱ha cúu ndúu nde̱ yóho, xitoho nde̱. Tá cúni̱ ndó cava̱ha nde̱ u̱ni̱ vehe ti̱yahvá válí. In a coo mé ndó ta inga coo Moisés ta inga coo Elías —cáchí Pedro. ");
INSERT INTO mksNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ta nani cáha̱n Pedro na̱nuu in vi̱co̱ ja̱ta̱ ná ta na̱ca̱va̱ nuu a na̱. Ta a̱ ju̱ú quia̱hva ndató yéhe̱ a̱. Ta tañu vi̱co̱ cán na̱xini jo̱ho na ña̱ cáha̱n in a ta já cáchí a̱ já: —Da̱ yóho cúú ja̱hyi ma̱ní i̱ ta cáji̱i̱ ini i̱ xi̱hi̱n dá. Cuni jo̱ho ndó nu̱ cáha̱n da̱ —na̱cachi mé a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tá na̱xini jo̱ho na̱ xíca tuun xi̱hín Jesús cán ña̱ cáha̱n yóho já na̱caxítí na̱ ja̱nda̱ quia̱hva na̱xi̱nu̱ nu̱u̱ ná nu̱ ñúhu̱. Ta a̱ ju̱ú quia̱hva ná yi̱hví na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A̱nda̱ já na̱cayati Jesús nu̱ ná ta na̱cani ndaa ndáha̱ na̱ já na̱cachi a já xi̱hi̱n ná: —Cuándaco̱o ndó. A̱ cáyi̱hví toho ndó —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ta tá na̱ndiñehe na̱ cán nu̱u̱ ná já na̱xini na ña̱ íin in túhún ji̱ni̱ mé va Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ta tá na̱nuu na ji̱ni̱ yúcu̱ cán já na̱sahnda Jesús chuun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —A̱ cáxi tu̱hun ndó ña̱ na̱xini ndó yóho nu̱ú ni in ña̱yivi ja̱nda̱ quia̱hva ná nditacu tucu ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Já na̱cachi na̱ cán já xi̱hi̱n á: —Ndáva̱ha cáchí na̱ jána̱ha̱ ley Moisés ña̱ ndítahan quixi jihna ñúhú profeta Elías —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Já na̱cachi Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ jihna ñúhú quixi Elías ta ndaja va̱ha ndihi da ña̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Joo mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ sa̱ na̱quixi va Elías joo co̱ó na̱xeen na ndicuni na da̱. Ta na̱caja na tá quia̱hva cúni̱ mé ná xi̱hi̱n dá. Ta quia̱hva já jándoho ri na ini ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","A̱nda̱ jáví na̱canda̱a̱ ini na̱ xíca tuun xi̱hín Jesús cán ña̱ cáha̱n Jesús sa̱ha̱ Juan, da̱ na̱jácandúta̱ ña̱yivi tá na̱cachi a ña̱ sa̱ na̱quixi va Elías. ");
INSERT INTO mksNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ta tá sa̱ na̱nuu na ta na̱xi̱nu̱ co̱o na nu̱ ndúu cua̱há ña̱yivi cán já na̱xi̱nu̱ co̱o in da̱ta̱a ta já na̱caxítí da̱ nu̱ Jesús. Já na̱cachi da já xi̱hi̱n á: ");
INSERT INTO mksNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Candáhví loho ini ndó ja̱hyi i̱, xitoho i̱ jáchi̱ xíhi̱ yi̱hí da̱ ta ndóho ndiva̱ha ini da. Ta cua̱há tañu ndícava da nu̱ ñúhu̱ i̱ta̱ á ini ticui̱í. ");
INSERT INTO mksNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ta ñéhe e̱ da̱ na̱casa̱a̱ i̱ nu̱ú na̱ xíca tuun xi̱hi̱n ndó yóho joo co̱ó na̱cuu ndaja va̱ha na da̱ —na̱cachi da̱ xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A̱nda̱ já na̱cachi Jesús já: —Ndáhví na̱há na̱cuu ndó jáchi̱ sa̱ cua̱há ndiva̱ha qui̱vi̱ íin i̱ xi̱hi̱n ndo̱ ta a̱ ñáha candeé ini ndó ye̱he̱. Cúú ndó ña̱yivi quini ndiva̱ha chí co̱ ndeé ga̱ ini i̱ xi̱hín ña̱ cája ndó. Taxi ndó ta̱a loho ja̱n chóho —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","A̱nda̱ já na̱jána̱ni Jesús rí quini ndáca̱a̱n ini da̱ loho cán. Chí na̱queta rí cua̱ha̱n ri̱ ta mé hora já na̱ndiva̱ha da̱ loho cán. ");
INSERT INTO mksNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tá na̱ndihi já na̱ca̱ha̱n je̱hé na̱ xíca tuun xi̱hín Jesús cán xi̱hi̱n á já na̱cachi na já: —Ndáva̱ha co̱ó na̱cuu caja nde̱ tavá nde̱ ínima̱ quini na̱sa̱ndaca̱a̱n ini da̱ loho ja̱n —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Já na̱cachi Jesús já xi̱hi̱n ná: —Co̱ó na̱cuu caja ndó jáchi̱ co̱ cándeé cáhnu ini ndó ye̱he̱. Mé a̱ nda̱a̱ cáchí i̱ xi̱hi̱n ndó, loho tíín ndiva̱ha cáa in ndíqui̱ mostaza joo ndúu dó in yíto̱ cáhnu. Tá cándeé loho ini ndó ye̱he̱ viti va̱xi qui̱vi̱ candeé chága̱ ini ndó ye̱he̱. A̱nda̱ jáví cuu caja ndó in ña̱ha i̱hvi̱ ndiva̱ha tátu̱hun ña̱ cuu cachi ndó xi̱hín in yúcu̱ ña̱ ná caxoo a ta chí caxoo ndusa ña̱. Tócó ndihi ña̱ha cuu caja ndó tá ná candeé ini ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Joo tá cúni̱ ndó tavá ndó ínima̱ quini tátu̱hun rí yóho xíní ñúhú cajuhun ndó ta ca̱ca̱ ta̱hví ndó nu̱ Ndióxi̱ —cáchí Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ta ndaja coo xíca tútú ndihi na̱ xíca tuun xi̱hi̱n Jesús cán cua̱ha̱n na̱ xi̱hi̱n á chí estado Galilea. Ta já na̱ndicani Jesús nu̱ú na̱ cán ña̱ tandaa qui̱vi̱ ndiquia̱hva ña̱yivi mé á ndáha̱ na̱ cahní ñahá, mé a̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta na̱cachi a xi̱hi̱n ná ña̱ tá sa̱ ná ya̱ha u̱ni̱ qui̱vi̱ já nditacu tucu a. Tá na̱cachi Jesús ña̱ yóho xi̱hín na̱ xíca tuun xi̱hi̱n á cán já na̱cacuéha̱ ndiva̱ha ini na. ");
INSERT INTO mksNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tá na̱xi̱nu̱ co̱o Jesús ñuu Capernaum xi̱hín na̱ xíca tuun xi̱hi̱n á já na̱xi̱nu̱ co̱o na̱ játaca jiu̱hún impuesto cuéntá veñu̱hu nu̱ Pedro. Já na̱cachi na já xi̱hi̱n dá: —Á co̱ cháhvi toho Jesús, da̱ jána̱ha̱ ndo̱hó ja̱n jiu̱hún impuesto cuéntá veñu̱hu ñuu Jerusalén —na̱cachi na xi̱hi̱n Pedro. ");
INSERT INTO mksNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A̱nda̱ já na̱cachi Pedro já: —Cháhvi a ña̱ —na̱cachi da. A̱nda̱ já na̱ndi̱hvi Pedro ini vehe nu̱ ndáca̱a̱n Jesús joo jihna ñúhú na̱ndica̱ha̱n Jesús xi̱hi̱n dá já na̱cachi a já: —Ndía̱ cáhvi inún, Simón. Yo já ndítahan nu̱u̱ cha̱hvi jiu̱hún cuéntá impuesto nu̱ú na̱ sáhndá chuun ñuyíví yóho. Á na̱ ñuu mé ná á na̱ ñuu tóho̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Já na̱cachi Pedro já: —Na̱ tóho̱ va sá cháhvi jiu̱hún cája na —na̱cachi Pedro. Já na̱cachi tucu Jesús já: —Sa̱há ña̱ cán quéa̱ mé na̱ ñuu co̱ cháhvi toho na. ");
INSERT INTO mksNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Joo mí co̱ cúni̱ yo̱ ña̱ ná ndicui̱ta na xo̱ho̱ sa̱há ña̱ cán quéa̱ cu̱hún tañu̱hú. Ta mé cán tavún ti̱yacá. Ta rí nu̱ cuítí ná tavún ja̱n cande̱hún yúhu̱ rí jáchi̱ ja̱n nditáhún in jiu̱hún ca̱a. Ta cañehe a cu̱hu̱n cha̱hvún sa̱ha̱ mún ta sa̱ha̱ mí i̱ jáchi̱ queta va —na̱cachi Jesús xi̱hi̱n Pedro. ");
INSERT INTO mksNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mé tañu já na̱cayati na̱ xíca tuun xi̱hi̱n Jesús nu̱ á já na̱casáhá ndáca̱ tu̱hún ñahá na̱ já na̱cachi na já xi̱hi̱n á: —Yo já cacuu da̱ cáhnu chága̱ tá ná tandaa qui̱vi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi —na̱cachi na xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A̱nda̱ já na̱cana Jesús in da̱ loho já na̱sacandichi a da̱ ma̱hñú java na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Já na̱cachi a já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ndítahan ndaja núu ndó mé ndó ta nduu ndó tátu̱hun na̱ va̱lí já cuu cacomí Ndióxi̱ cuéntá sa̱ha̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Na̱ cúni̱ cacuu na̱ cáhnu chága̱ tá cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi ndítahan nduu na tátu̱hun in na̱ co̱ó sa̱ha̱ ta já nduu na tátu̱hun ta̱a loho yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ta ndá na̱ ná ndiquehe in a̱loho tátu̱hun da̱ yóho sa̱há ña̱ cúni̱ na̱ ye̱he̱, na̱ cán cúú na̱ ndíquehe ri na ye̱he̱ viti. ");
INSERT INTO mksNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ʼTa ndá na̱ ná jándacava in na̱ nda̱hví, na̱ cándeé ini ye̱he̱ nu̱ú cua̱chi ja̱nda̱ va̱ha chága̱ ná candi̱co̱ in yu̱ú yo̱jó ji̱co̱ ná ta ná ndihi sa̱há na̱ ca̱há tañu̱hú. ");
INSERT INTO mksNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ndáhví na̱há na̱cuu ña̱yivi ñuyíví yóho jáchi̱ mé a̱ nda̱a̱ íin cua̱há ndiva̱ha ña̱ núu ñuyíví yóho. Ña̱ cán quéa̱ ndácava cua̱há ña̱yivi nu̱ú cua̱chi joo ndáhví na̱há na̱cuu na̱ jándacava inga na nu̱ú cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ʼSa̱há ña̱ cán quéa̱ tá ndáha̱ ndo̱ á sa̱ha̱ ndo̱ jándacava ndo̱hó nu̱ú cua̱chi, chitúhu̱n ndó a̱ ta jácana xícá ndó ña̱ ná cu̱hu̱n a̱. Jáchi̱ va̱ha chága̱ ná cu̱hu̱n rénco̱ ndó á lu̱ndu̱ ndó indiví a̱ ju̱ú ga̱ ña̱ ná cu̱hu̱n níí yiquí cu̱ñu ndó indayá nu̱ cáyi̱ ñúhu̱ i̱ta̱ a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ta tá nduchú núú ndo̱ jándacava ndo̱hó nu̱ú cua̱chi, tavá ndó ña̱ ta jácana xícá ndó ña̱ ná cu̱hu̱n a̱. Jáchi̱ va̱ha chága̱ ná cu̱hu̱n ndó indiví xi̱hín in túhún nduchú núú ndo̱ a̱ ju̱ú ga̱ ña̱ ná cu̱hu̱n ndó xi̱hi̱n ndíví nduchú núú ndo̱ indayá nu̱ cáyi̱ ñúhu̱ i̱ta̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ʼCoto a̱ quéhe núu ndó ni in na̱ cúú cuéntá mí i̱ jáchi̱ cáchí i̱ xi̱hi̱n ndó ña̱ táto̱ Ndióxi̱, mé na̱ ndáá na̱ cán níí tiempo ndíta na nu̱ Ndióxi̱, tátá i̱ indiví. ");
INSERT INTO mksNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jáchi̱ ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi na̱quixi i̱ jáca̱cu u̱ ña̱yivi, na̱ cája cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ʼCuni jo̱ho ndó ná ca̱ha̱n i̱ xi̱hi̱n ndo̱: Tá cómí in da̱ta̱a in ciento ndicachi ta tá ndíñúhú in rí já quéa̱ ña̱ cája da quéa̱ jándacoo da co̱mi̱ jíco sa̱hu̱n co̱mi̱ rí cán yúcu̱ ta já quee da cu̱hu̱n da̱ ndinducú da̱ mé rí na̱ndiñúhú cán. ");
INSERT INTO mksNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta tá ndiñe̱he̱ dá ri̱ caji̱i̱ chága̱ ini da sa̱ha̱ rí na̱ndiñúhú cán a̱ ju̱ú ga̱ sa̱há co̱mi̱ jíco sa̱hu̱n co̱mi̱ rí sa̱ ndúu nu̱ dá cán. ");
INSERT INTO mksNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ta quia̱hva já ndoho ri Ndióxi̱, tátá i̱ jáchi̱ co̱ cúni̱ mé á ña̱ ná ndihi sa̱há ni in na̱ cándeé ini mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ʼTá cája quini ñani táhan ndó xi̱hi̱n ndo̱ já quéa̱ tavá xóo ndó da̱ ta ca̱ha̱n ndó xi̱hi̱n dá ña̱ ná ndicuni da ña̱ a̱ váha toho cája da. Ta tá ná ta̱hvi̱ ini da sa̱há cua̱chi cája da já quéa̱ sa̱ na̱ndiquehe táhan ma̱ni̱ tucu ndó xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Joo tá co̱ cúni̱ da̱ cuni jo̱ho da nu̱ cáha̱n ndo̱ já quéa̱ ndítahan nu̱ ndó cana ndó in á i̱vi̱ chága̱ ñani táhan ndó já ná cacuu na testigo sa̱há ña̱ cáha̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ta tá co̱ cúni̱ da̱ cuni jo̱ho da nu̱ cáha̱n na̱ cán xi̱hi̱n dá já quéa̱ ndítahan cu̱hu̱n ndó nu̱ tócó ndihi na̱ cúú cuéntá Jesús tácá veñu̱hu. Ta tá co̱ cúni̱ da̱ cuni jo̱ho da nu̱ cáha̱n ndihi na̱ cán xi̱hi̱n dá já quéa̱ ndítahan caja ndó xi̱hi̱n dá tá quia̱hva cája ndó xi̱hín in da̱ tóho̱, da̱ co̱ cándúsa Ndióxi̱ á in da̱ játaca jiu̱hún cuéntá impuesto. ");
INSERT INTO mksNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ʼMé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tócó ndihi ña̱ha ná ca̱tó ndo̱ ñuyíví yóho candi̱co̱ a̱ ja̱nda̱ indiví. Ta tócó ndihi ña̱ ná ndaxí ndo̱ ñuyíví yóho ja̱nda̱ indiví nda̱xi̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ʼTa jári cáha̱n i̱ ña̱ yóho xi̱hi̱n ndó. Tá jándique táhan tu̱hun i̱vi̱ ndó ñuyíví yóho ta tá mé a̱ nda̱a̱ in cúú ndó sa̱há ña̱ xíca̱ ta̱hví ndó nu̱ Ndióxi̱, mé á íin indiví já quéa̱ quia̱hva tátá i̱ ña̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jáchi̱ nu̱ ndúu i̱vi̱ á u̱ni̱ na̱ ta tácá na̱ cuéntá mí i̱ já quéa̱ tañu na̱ cán ndaca̱a̱n i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ta ndaja coo na̱cayati Pedro ndáca̱ tu̱hún da̱ Jesús já na̱cachi da já: —Xitoho i̱, ndaja tañu xíní ñúhú caja cáhnu ini i̱ sa̱há ñani táhan i̱ tá cája núu da xi̱hín i̱. Á ndítahan nu̱ú i̱ caja cáhnu ini i̱ sa̱ha̱ dá ja̱nda̱ u̱sa̱ tañu —na̱cachi da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Já na̱cachi Jesús já xi̱hi̱n dá: —A̱ ju̱ú ja̱nda̱ u̱sa̱ tañu cuití ndítahan caja cáhnu inún sa̱há ñani táhún. Va̱ha ja̱nda̱ co̱mi̱ ciento co̱mi̱ jíco u̱xu̱ tañu ndítahan nu̱u̱n caja cáhnu inún sa̱há ñani táhún. ");
INSERT INTO mksNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ʼCáchí i̱ ña̱ yóho xi̱hi̱n ndó jáchi̱ tá cómí Ndióxi̱ cuéntá sa̱há ña̱yivi cúú á tátu̱hun ña̱ na̱ya̱ha xi̱hín in rey tá na̱casáhá da̱ játaca da cuéntá nu̱ú na̱ yícá nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mé tañu já ñéhe na in da̱ yícá cua̱há millón nu̱ dá na̱casa̱a̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ta sa̱há ña̱ co̱ó na̱cuu cha̱hvi da ña̱ yícá da̱ sa̱há ña̱ cán quéa̱ na̱sahnda rey chuun ña̱ ná ji̱có na̱ mé dá xi̱hi̱n ñájíhí da̱ xi̱hi̱n ja̱hyi válí da̱ ta ja̱nda̱ ña̱ha da viti ña̱ ná cuu ndiquehe rey cán cuéntá da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","A̱nda̱ já na̱caxítí da̱ yícá cán nu̱ mé rey já na̱casáhá xíca̱ ta̱hví da̱ já cáchí da̱ já: “Caja ndó ña̱ma̱ni̱, xitoho i̱ candati tóo chága̱ ndó ye̱he̱, ndáhví i̱, já cha̱hvi ndihi i̱ ña̱ yícá i̱ nu̱ ndo̱”, na̱cachi da xíca̱ ta̱hví da̱ nu̱ rey cán. ");
INSERT INTO mksNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A̱nda̱ já na̱candáhví ini rey cán da̱ ta na̱caja cáhnu ini a sa̱ha̱ tócó ndihi ña̱ yícá da̱ já na̱janí a̱ da̱ cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ʼTa tá na̱queta da̱ yícá cán cua̱ha̱n da̱ já na̱ndique táhan da xi̱hín inga da̱ cúú mozo. Ta mé mozo cán yícá da̱ loho va nu̱ú da̱ cán. Ta já na̱casáhá da̱ ndáca̱ yi̱hí da̱ cuéntá nu̱ú da̱ cúú mozo jácua̱hnú ñahá da̱. Já cáchí da̱ já: “Cha̱hvún ña̱ yícún nu̱ú i̱”, cáchí da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A̱nda̱ já na̱ndacava xítí mé da̱ cúú mozo cán nu̱ dá já na̱casáhá xíca̱ ta̱hví da̱ nu̱ dá já cáchí da̱ já xi̱hi̱n dá: “Cajún ña̱ma̱ni̱ candati tóo chágu̱n ye̱he̱, ndáhvi i̱, já cha̱hvi ndihi i̱ ña̱ yícá i̱ nu̱u̱n”, na̱cachi da̱ cúú mozo cán. ");
INSERT INTO mksNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Joo co̱ó na̱xeen da ta ña̱ na̱caja da quéa̱ na̱sa̱ha̱n da̱ na̱chica̱a̱n da̱ da̱ cúú mozo cán veca̱a ja̱nda̱ quia̱hva ná cuu cha̱hvi ndihi da ña̱ yícá da̱ nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ta tá na̱xini java ga̱ na̱ cúú mozo cán ña̱ yóho já na̱ndihi̱hvi̱ ndiva̱ha ini na ta chí ndáva na na̱sa̱ha̱n na̱ na̱ca̱xi tu̱hun na nu̱ mé rey cán ndaja cáa ña̱ na̱cuu. ");
INSERT INTO mksNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","A̱nda̱ já xójo̱ ndiva̱ha ini mé rey cán chí na̱cana da da̱ na̱sa̱yi̱cá cán já na̱cachi da já xi̱hi̱n dá: “Mozo quini ndiva̱ha cúú yóhó. Cua̱há ndiva̱ha jiu̱hún na̱sa̱yi̱cún nu̱ú i̱ joo na̱caja cáhnu ini i̱ sa̱ha̱ tócó ndihi a jáchi̱ na̱xi̱ca̱ ta̱hvún nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Quia̱hva já ndítahan ri nu̱ yóhó va caja cáhnu inún sa̱há ña̱ yícá ñani táhún nu̱u̱n jáchi̱ já na̱caja i̱ xu̱hu̱n”, na̱cachi rey cán. ");
INSERT INTO mksNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ta sa̱há ña̱ xójo̱ ndiva̱ha ini mé rey cán xi̱hi̱n dá sa̱há ña̱ cán quéa̱ na̱ndiquia̱hva da da̱ yícá cán ndáha̱ na̱ jácaxáhan ñahá cán ja̱nda̱ quia̱hva ná cha̱hvi da sa̱ha̱ tócó ndihi ña̱ yícá da̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Já na̱cachi tucu Jesús já: —Quia̱hva já caja ri Ndióxi̱, tátá i̱, mé a̱ íin indiví xi̱hi̱n ndóhó va tá co̱ cája cáhnu ini ndó sa̱há ñani táhan ndó xi̱hín ndinuhu ini ndó —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tá na̱ndihi na̱cachi Jesús ña̱ yóho já na̱quee a estado Galilea já na̱xi̱nu̱ co̱o a estado Judea, ña̱ íin inga xoo yu̱ta Jordán cán. ");
INSERT INTO mksNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ta a̱ ju̱ú quia̱hva cua̱há ña̱yivi na̱ndi̱co̱ ja̱tá ta na̱ndaja va̱ha mé á na̱ quíhvi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Joo ndaja coo java na̱ fariseo na̱cayati na nu̱ Jesús sa̱há ña̱ coto ndojó ñahá na̱ cúni̱ na̱. Já na̱cachi na já xi̱hi̱n á: —Á núná nu̱ú in da̱ta̱a jándacoo da ñájíhí da̱ sa̱ha̱ ndá ña̱ na̱cuu —na̱cachi na̱ fariseo cán. ");
INSERT INTO mksNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A̱nda̱ já na̱cachi Jesús já: —Á a̱ ñáha cahvi ndó tu̱hun Ndióxi̱ nu̱ cáchí a̱ ña̱ ja̱nda̱ mé sa̱ha̱ tá na̱cava̱ha Ndióxi̱ ña̱yivi nu̱ cuítí já na̱cava̱ha da̱ta̱a ta na̱cava̱ha ñáñáha̱. ");
INSERT INTO mksNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ta na̱cachi tucu a ña̱ ndítahan nu̱ú da̱ta̱a jándacoo da tátá da̱ xi̱hi̱n náná da̱ já ndique táhan da̱ xi̱hi̱n ñájíhí da̱. Já xi̱nu̱ ndíví na̱ cán cacuu na tátu̱hun in víxí yiquí cu̱ñu na. ");
INSERT INTO mksNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sa̱há ña̱ cán quéa̱ co̱ cúú ga̱ na̱ i̱vi̱ yiquí cu̱ñu sa̱há ña̱ na̱nduu na tátu̱hun in túhún yiquí cu̱ñu na. Sa̱há ña̱ cán quéa̱ co̱ ndítahan nu̱ú da̱ cán janí táhan da ña̱ na̱jácatáhan Ndióxi̱ tá na̱tanda̱ha̱ ná —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","A̱nda̱ já na̱nda̱ca̱ tu̱hún tucu na̱ cán Jesús já na̱cachi na já: —Joo já cachi ndó xi̱hín nde̱: ndá cuéntá quéa̱ na̱sahnda ri Moisés chuun ña̱ cuu cava̱ha in da̱ta̱a in tutu quia̱hva da nu̱ ñájíhí da̱ ta xi̱hín ña̱ cán cuu jándacoo da ña̱ —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Já na̱cachi Jesús já: —Sa̱há ña̱ táhyí ndiva̱ha ínima̱ ndo̱ sa̱há ña̱ cán quéa̱ sáhan Moisés ña̱ma̱ni̱ nu̱ ndó ña̱ cuu cava̱ha ndó tutu quia̱hva ndó nu̱ ñájíhí ndo̱ ña̱ ná jándacoo ndó ña̱. Joo tá na̱cava̱ha Ndióxi̱ ña̱yivi nu̱ cuítí co̱ó na̱cacúni̱ toho a coo ña̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cuni jo̱ho ndó ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Tá ná jándacoo in da̱ta̱a ñájíhí da̱ ta co̱ cúú á sa̱há ña̱ na̱caja ñá cua̱chi xi̱hín inga ta̱a ta tá tánda̱ha̱ dá xi̱hín inga ñá já quéa̱ cája da cua̱chi nu̱ Ndióxi̱. Ta quia̱hva já íin ri cua̱chi da̱ ná tanda̱ha̱ xi̱hi̱n ñá na̱cando̱o cán —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tá na̱xini jo̱ho na̱ xíca tuun xi̱hín Jesús cán ña̱ yóho já na̱cachi na já: —Tá ta̱ quia̱hva já cáa ja̱nda̱ va̱ha chága̱ ná a̱ tánda̱há ña̱yivi, dá já —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Já na̱cachi Jesús já: —A̱ ju̱ú ndihi ña̱yivi canda̱a̱ ini ña̱ cáha̱n i̱ yóho. Ndinuhu na̱ ndínu̱na̱ xíní túni̱ cája Ndióxi̱, na̱ cán cúú na̱ cánda̱a̱ ini ña̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ndúu java da̱ta̱a ta a̱ cu̱ú tanda̱ha̱ da̱ jáchi̱ já na̱cacu da ta já ta̱a cúú mé va da. Ta java da a̱ cu̱ú tanda̱ha̱ da̱ jáchi̱ já na̱caja ña̱yivi xi̱hi̱n ná ta já ta̱a cúú mé va na. Ta java da a̱ tánda̱ha̱ da̱ jáchi̱ cúni̱ da̱ ndiquia̱hva níí da̱ mé dá nu̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ dá. Ta ndá ndó, na̱ ndínu̱na̱ xíní túni̱, canda̱a̱ ini ndó ña̱ yóho —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tá na̱ndihi já ñéhe na java na̱ va̱lí na̱casa̱a̱ na̱ nu̱ Jesús ña̱ ná chinúu a ndahá a̱ ji̱ni̱ ná ta já ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱ sa̱ha̱ ná. Joo ndaja coo na̱ xíca tuun xi̱hi̱n á cán na̱casáhá na̱ cája cue̱he̱ na̱ xi̱hín na̱ ndáca na̱ va̱lí cán. ");
INSERT INTO mksNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Já na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán já: —Quia̱hva ndó ña̱ma̱ni̱ ná quixi na̱ va̱lí nu̱ú i̱ ta a̱ cájí nuu ndó nu̱ ná jáchi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi tá ná caja na tá quia̱hva cája na̱ va̱lí yóho —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tá na̱ndihi já na̱chinúu Jesús ndáha̱ á ji̱ní na̱ va̱lí cán. A̱nda̱ já na̱quee a cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ta ndaja coo na̱xi̱nu̱ in da̱ta̱a nu̱ íin Jesús ta na̱nda̱ca̱ tu̱hún ñahá da̱ já na̱cachi da já: —Maestro, mé ndó cúú ndó ta̱a va̱ha ña̱ cán quéa̱ ndáca̱ tu̱hún i̱ ndo̱hó ndía̱ ndítahan caja i̱ já ná ñe̱he̱ táhvi̱ i̱ cu̱hu̱n i̱ indiví coo i̱ a̱nda̱ ama cáa qui̱vi̱ —na̱cachi da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Já na̱cachi Jesús já xi̱hi̱n dá: —Ndá cuéntá quéa̱ cáchún xi̱hín i̱ ña̱ cúú u̱ da̱ va̱ha. Ni in túhún toho ña̱yivi co̱ cúú ná na̱ va̱ha ñuyíví yóho. In túhún Ndióxi̱ cuití va quéa̱ va̱ha. Tá cúnu̱n catacún nu̱ íin mé á já quéa̱ xíní ñúhú cajún ña̱ sáhndá tu̱hun Ndióxi̱ —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Já na̱cachi da̱ cán já: —Ndá cúú mé ña̱ ndítahan caja i̱ —na̱cachi da. Já na̱cachi Jesús já xi̱hi̱n dá: —Coto a̱ cáhnún ndi̱i. Coto a̱ cóún xi̱hi̱n ñájíhí á yíi̱ ñani táhún. Coto a̱ cája cuíhnún. Coto a̱ cáhu̱n ña̱ tu̱hún sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ndítahan caja cáhnún tátún xi̱hi̱n nánún. Ta ndítahan qui̱hvi̱ inún ñani táhún tá quia̱hva quíhvi̱ inún mún —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Já na̱cachi da̱ yúta̱ cán já xi̱hi̱n á: —Ja̱nda̱ ta̱a loho na̱sacuu u̱ na̱casáhá i̱ cája i̱ tócó ndihi ña̱ sáhndá Ndióxi̱ caja i̱. Ndía̱ cúú ga̱ ndítahan caja i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Já na̱cachi Jesús já xi̱hi̱n dá: —Tá ta̱ cúnu̱n cacuún in ta̱a nda̱cú nu̱ Ndióxi̱ cuáhán ji̱cún tócó ndihi ña̱hún ja̱n ta ndacahndún jiu̱hún ja̱n nu̱ú na̱ nda̱hví já ñe̱he̱ táhvu̱n coo cua̱há ña̱hún indiví. Ta tá na̱ndihi já quisún candi̱cún ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tá na̱xini jo̱ho da̱ yúta̱ cán ña̱ yóho já na̱quee cuéha̱ ndiva̱ha da cua̱ha̱n da̱ jáchi̱ da̱ cui̱cá ndiva̱ha cúú dá. ");
INSERT INTO mksNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A̱nda̱ já na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán já: —Mé a̱ nda̱a̱ ná cachi i̱ xi̱hi̱n ndó ña̱ ndaja yáncá ndiva̱ha cáa já ndiquia̱hva na̱ cui̱cá mé ná ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jáchi̱ ja̱nda̱ cama chága̱ cuu ya̱ha in camello ini in yávi̱ sa̱há yítu̱cú a̱ ju̱ú ga̱ ña̱ ná ndiquia̱hva in da̱ cui̱cá mé dá ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ dá —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tá na̱xini jo̱ho na̱ xíca tuun xi̱hín Jesús cán ña̱ yóho já na̱catóntó ndiva̱ha na ta na̱nda̱ca̱ tu̱hún táhan na já cáchí na̱ já: —Ndá na̱ cúú na̱ cuu ca̱cu ndaa ínima̱, dá já —cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Na̱ndicoto nihni Jesús nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Ni in na a̱ cúu caja ña̱ yóho joo Ndióxi̱ quéa̱ cuu caja ña̱ jáchi̱ ni in ña̱ha co̱ íhvi̱ toho nu̱ Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","A̱nda̱ já na̱cachi Pedro já: —Joo nde̱he̱, na̱jándacoo ndihi nde̱ ña̱ha na̱sacomí nde̱ ta ndíco̱ nde̱ ndo̱hó. Ndía̱ ñe̱he̱ táhvi̱ nde̱ caja ndó —na̱cachi Pedro xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Mé a̱ nda̱a̱ ná cachi i̱ xi̱hi̱n ndo̱. Tá ná tandaa qui̱vi̱ nduu sa̱á tócó ndihi ña̱ha já caco̱o ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi nu̱ú ndicáhnu ndiva̱ha i̱. Ta cán caco̱o ri ndóhó, na̱ na̱xi̱ca tuun xi̱hín i̱ nu̱ú u̱xu̱ i̱vi̱ táyi̱ va̱ha. Ta cán caja vií ndó sa̱há ndíhu̱xu̱ i̱vi̱ táhndá na̱ na̱quixi chi̱chi Israel. ");
INSERT INTO mksNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta ndá na̱ na̱jándacoo vehe na á ñani na á quia̱hva na á tátá na̱ á náná na̱ á ñájíhí na̱ á ja̱hyi na á ñundáhyi̱ na̱ sa̱há ye̱he̱, na̱ cán cúú na̱ ñe̱he̱ ná cua̱ha̱ chága̱ ví ña̱ha. Ta ja̱tá ña̱ cán ñe̱he̱ táhvi̱ ná catacu na nu̱ Ndióxi̱ a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ta ndúu cua̱há na̱ íin sa̱ha̱ ñuyíví yóho viti joo va̱xi qui̱vi̱ cacuu na na̱ co̱ó sa̱ha̱ nu̱ Ndióxi̱. Ta ndúu cua̱há na̱ co̱ó sa̱ha̱ ñuyíví yóho viti joo va̱xi qui̱vi̱ cacuu na na̱ íin sa̱ha̱ nu̱ Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Já na̱cachi Jesús já sácú a̱ quia̱hva: —Nu̱ú cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi cúú á tátu̱hun ña̱ yóho: Íin in da̱ta̱a naha chá na̱quee da cua̱ha̱n da̱ nducú da̱ mozo caja chúun da cahnda da uva nu̱ ñúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta na̱cando̱o da cha̱hvi da in jiu̱hún ca̱a naní denario in qui̱vi̱. Ta já na̱chindahá da̱ mé mozo cán cua̱ha̱n da̱ caja chúun da nu̱ ñúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tá na̱ndihi já na̱quee tucu da̱ xi̱hín ña̱ha ñúhu̱ cán tátu̱hun ca̱a i̱n naha já na̱nditahan da java da̱ ndúu núná uun nu̱ú ya̱hvi. ");
INSERT INTO mksNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Já na̱cachi mé da̱ xi̱hín ña̱ha ñúhu̱ cán já: “Cuáhán ri ndóhó va cahnda ndó uva nu̱ ñúhu̱ i̱ ta já cha̱hvi i̱ ndo̱hó tá quia̱hva ndítahan nu̱ ndó quehe ndó”, na̱cachi da. Já na̱quee mozo cán cua̱ha̱n da̱ jáquee da nu̱ ñúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ta tá na̱cuu ca̱xi̱vi̱ já na̱queta tucu da̱ xi̱hín ña̱ha ñúhu̱ cán cua̱ha̱n da̱ ta na̱tiin da java ga̱ da̱ caja chúun xi̱hi̱n dá. Ta tá na̱cuu ca̱a u̱ni̱ na̱tiin chága̱ da̱ da̱ jáquee nu̱ ñúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ta tá na̱cuu tátu̱hun ca̱a u̱hu̱n sa̱hini na̱queta tucu da ta nu̱ú ya̱hvi cán na̱xini chága̱ da̱ da̱ ndúu núná uun. Já na̱cachi da já xi̱hín da̱ ndúu cán: “Ndá cuéntá quéa̱ sa̱ na̱cuu ndiví yaa ndúu ndó yóho”, na̱cachi da̱ xi̱hín da̱ ndúu cán. ");
INSERT INTO mksNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ta na̱nducú ñehe da̱ cán tu̱hun já cáchí da̱ já: “Co̱ cája chúun nde̱ jáchi̱ co̱ó na̱ quíxi ndúcú nde̱ caja chúun nde̱”, na̱cachi da̱ cán. A̱nda̱ já na̱cachi da̱ xi̱hín ña̱ha ñúhu̱ cán já: “Cuáhán ri ndóhó va cahnda ndó uva nu̱ ñúhu̱ i̱. Ta já cha̱hvi i̱ ndo̱hó tá quia̱hva ndítahan nu̱ ndó quehe ndó”, na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ʼTa tá sa̱ na̱cuaá já na̱cachi da xi̱hín ña̱ha ñúhu̱ cán xi̱hín da̱ cómí chuun nu̱ mozo cán ña̱ ná cana da da̱ cúú mozo cán já ná quehe ya̱hvi da sa̱há chuun na̱caja da. Ta da̱ na̱qui̱hvi na̱caja chúun nu̱ ndíhí cán, da̱ cán cúú da̱ jihna ñúhú ná quehe ya̱hvi. Tá na̱ndihi cán ná quehe ya̱hvi da̱ na̱qui̱hvi nu̱ cuítí. ");
INSERT INTO mksNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","A̱nda̱ já na̱casa̱a̱ da̱ na̱qui̱hvi caja chúun ca̱a u̱hu̱n sa̱hini já na̱quehe in in da̱ cán in denario. ");
INSERT INTO mksNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ta ndaja coo tá na̱cani a nu̱ú da̱ na̱qui̱hvi caja chúun ja̱nda̱ naha cán quehe ya̱hvi da já quéa̱ na̱ca̱hán da̱ ña̱ cua̱ha̱ chága̱ jiu̱hún ndiquehe da nu̱ú da̱ na̱qui̱hvi ca̱a u̱hu̱n sa̱hini cán. Joo quia̱hva já in denario na̱quehe ri in in da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sa̱há ña̱ cán quéa̱ na̱casáhá da̱ cáha̱n cua̱chí da̱ xi̱hín da̱ xi̱hín ña̱ha ñúhu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Já na̱cachi da já: “Da̱ na̱ndai cuu caja chúun nu̱ ndíhí cuíí yóho in hora cuití na̱caja chúun da. Ta tá quia̱hva na̱cha̱hvi ndó nde̱he̱, da̱ na̱caja chúun ndiví yaa nu̱ ndíta̱hyí quia̱hva já na̱cha̱hvi ri ndó nu̱ú da̱ cáa va”, na̱cachi da cáha̱n cua̱chí da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","A̱nda̱ já na̱cachi da̱ xi̱hín ña̱ha ñúhu̱ cán xi̱hín in táhan mozo cán já: “Cande̱hé, amigo. Co̱ cája quini toho i̱ xu̱hu̱n. Á a̱ ju̱ú in denario na̱cando̱o i̱ cha̱hvi i̱ nu̱u̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Júhun ña̱ ndítahan quehún ta cuanúhu̱n. Jáchi̱ cúni̱ cha̱hvi i̱ nu̱ú da̱ na̱caja chúun in hora cuití va tá quia̱hva na̱cando̱o i̱ cha̱hvi i̱ nu̱ yóhó. ");
INSERT INTO mksNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Jáchi̱ núná nu̱ú i̱ caja i̱ ña̱ cúni̱ mí i̱ xi̱hín jiu̱hún i̱. Ta co̱ ndítahan cahi̱hvi̱ inún sa̱há ña̱ va̱ha ini i̱”, na̱cachi da̱ xi̱hín ña̱ha ñúhu̱ cán xi̱hín da̱ cáha̱n cua̱chí cán —na̱cachi Jesús sácú a̱ quia̱hva. ");
INSERT INTO mksNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ta na̱cachi tucu a já: —Sa̱há ña̱ cán quéa̱ ndúu cua̱há na̱ íin sa̱ha̱ ñuyíví yóho viti joo va̱xi qui̱vi̱ cacuu na na̱ co̱ó sa̱ha̱ nu̱ Ndióxi̱. Ta ndúu cua̱há na̱ co̱ó sa̱ha̱ ñuyíví yóho viti joo va̱xi qui̱vi̱ cacuu na na̱ íin sa̱ha̱ nu̱ Ndióxi̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ta tá sa̱ na̱quee tucu Jesús cua̱ha̱n chí Jerusalén já íchi̱ cán na̱tavá xóo a ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hi̱n á cán já na̱cachi a já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Cande̱hé ndo̱. Yóho ndáa í cua̱ha̱n yó chí Jerusalén nu̱ú ndiquia̱hva na ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ndahá na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín nu̱ú na̱ jána̱ha̱ ley Moisés. Ta na̱ cán cúú na̱ cacu ini sa̱há ndaja quivi i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A̱nda̱ já ndiquia̱hva na ye̱he̱ ndahá na̱ tóho̱ ña̱ ná cua̱cu̱ ndaa na ye̱he̱. Ta cani na ye̱he̱ ta já cata caa na ye̱he̱ ndi̱ca crúxu̱ joo tá ná ya̱ha u̱ni̱ qui̱vi̱ já nditacu tucu u̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","A̱nda̱ já na̱cayati ñájíhí Zebedeo, ñá cúú náná Jacobo xi̱hi̱n Juan nu̱ú Jesús. Ta ndáca ñá ndíví ja̱hyi ñá na̱casa̱a̱ ñá na̱caxítí ña̱ nu̱ á jáchi̱ cúni̱ ñá ca̱ca̱ ñá in ña̱ma̱ni̱ nu̱ú Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ña̱: —Ndá quéa̱ cúni̱ ndó —na̱cachi a. Já na̱cachi ñá cán já: —Ña̱ cúni̱ quéa̱ ná caja ndó ña̱ma̱ni̱ cahnda ndó chuun ña̱ ná caco̱o in in ja̱hyi i̱ xoo jíi̱n ndó. In da xoo cuáha ta in da xoo íti jíi̱n ndó indiví tá ná cacomí ndó cuéntá sa̱há ña̱yivi —na̱cachi ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ñá: —Co̱ cánda̱a̱ ini ndó ña̱ xíca̱ ndó nu̱ú i̱ —na̱cachi a. A̱nda̱ já na̱cachi a já xi̱hi̱n Jacobo xi̱hi̱n Juan cán: —Á cuu ndoho ini ndó tá quia̱hva nditahan nu̱ú i̱ ndoho ini i̱. Jáchi̱ ña̱ va̱xi nu̱ú i̱ ndoho ini i̱ cúú á tátu̱hun coho i̱ in yáxi̱ ndutá o̱va̱. Á íin tia̱hva ndó ndoho ini ndó tá quia̱hva ndítahan nu̱ú i̱ ndoho ini i̱ a̱nda̱ quia̱hva ná quivi i̱ —na̱cachi Jesús xi̱hi̱n ndíví da̱ cán. —Cuu caja nde̱ ña̱ —na̱cachi ndíví da̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A̱nda̱ já na̱cachi tucu a já xi̱hi̱n dá: —Mé a̱ nda̱a̱ tandaa qui̱vi̱ coho ndó ña̱ o̱va̱ ñúhu in yáxi̱, mé ña̱ coho i̱. Ta tandaa qui̱vi̱ ndoho ndiva̱ha ini ndó tá quia̱hva ndoho ini i̱ a̱nda̱ quia̱hva ná quivi i̱. Joo sa̱há ña̱ xíca̱ ndó caco̱o in ndó xoo cuáha i̱ ta in ndó xoo íti i̱ a̱ ju̱ú ye̱he̱ cúú dá cuu quia̱hva i̱ ña̱ nu̱ ndo̱. Jáchi̱ sa̱ na̱ndica̱xi Ndióxi̱ na̱ ñe̱he̱ táhvi̱ caco̱o cán —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Joo ndaja coo tá na̱xini jo̱ho ndíhu̱xu̱ chága̱ na̱ xíca tuun xi̱hín Jesús cán ña̱ yóho já na̱casáhá na̱ xójo̱ ini na xi̱hi̱n ndíví da̱ cúú ñani cán. ");
INSERT INTO mksNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","A̱nda̱ já na̱cana Jesús tócó ndihi na̱ xíca tuun xi̱hín a̱ cán já na̱cachi a já xi̱hi̱n ná: —Sa̱ xíni̱ ndó ndaja cája na̱ sáhndá chuun nu̱ú ña̱yivi ndúu ñuyíví yóho. Ña̱ cája na quéa̱ jácandíhi na ña̱yivi ta cája na tá quia̱hva cúni̱ mé ná. ");
INSERT INTO mksNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Joo co̱ ndítahan coo ña̱ cán tañu mé ndó jáchi̱ ndá da̱ cúni̱ cacuu da̱ cáhnu chága̱ tañu ndó xíní ñúhú cacuu da in da̱ cája chúun cuéntá ndihi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ta ndá da̱ cúni̱ cacuu da̱ nu̱ cuítí tañu ndóhó ndítahan cacuu da da̱ cája ndíví nu̱ú ndihi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jáchi̱ ni ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi co̱ó na̱quixi i̱ ñuyíví yóho ña̱ ná caja ndíví ña̱yivi nu̱ú i̱. Ña̱ na̱quixi i̱ caja i̱ quéa̱ caja ndíví i̱ nu̱ ná ta ndiquia̱hva i̱ mí i̱ quivi i̱ já ná cuu ca̱cu ndaa ínima̱ cua̱há ña̱yivi ná a̱ cúhu̱n na̱ indayá —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ta tá na̱queta Jesús ñuu Jericó xi̱hín na̱ xíca tuun xi̱hi̱n á cán já ndíco̱ cua̱há ndiva̱ha ña̱yivi ja̱tá cása̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ta ndaja coo yati jíi̱n íchi̱ cán na̱sa̱nduu coo i̱vi̱ da̱ cua̱á ta tá na̱xini joho da ña̱ yáha Jesús cua̱ha̱n já na̱casáhá ndíví da̱ cáyuhú da̱ já cáchí da̱ já: —Jesús, da̱ na̱quixi chi̱chi David, caja ndó ña̱ma̱ni̱ candáhví loho ini ndó nde̱he̱ —cáchí da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A̱nda̱ já na̱casáhá cája cue̱he̱ ña̱yivi xi̱hi̱n ndíví da̱ cua̱á cán ña̱ ná catáji̱ yúhu̱ dá. Joo ví ga̱ ví cáyuhú da̱ já cáchí da̱ já: —Jesús, da̱ na̱quixi chi̱chi David, caja ndó ña̱ma̱ni̱ candáhví loho ini ndó nde̱he̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A̱nda̱ já na̱nda̱ca̱ ndichi Jesús já na̱cana ndíví da̱ cua̱á cán. Ta já na̱nda̱ca̱ tu̱hún a̱ da̱ já na̱cachi a já xi̱hi̱n dá: —Ndía̱ cúni̱ ndó ña̱ ná caja i̱ xi̱hi̱n ndo̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Já na̱cachi ndíví da̱ cua̱á cán já: —Cande̱hé nde̱ cúni̱ nde̱, xitoho. ");
INSERT INTO mksNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A̱nda̱ já na̱candáhví ini Jesús da̱ ta na̱cani ndaa ndáha̱ á nu̱u̱ dá. Chí i̱vi̱ la̱á na̱nu̱na̱ nu̱ú da̱ cua̱á cán ta na̱casáhá da̱ ndíco̱ da̱ ja̱tá Jesús cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ta tá sa̱ ja̱ chá xi̱nu̱ co̱o na̱ ñuu Jerusalén já na̱xi̱nu̱ na̱ in ñuu loho naní Betfagé yati jíi̱n yúcu̱ naní olivo. Ta cán na̱sahnda Jesús chuun nu̱ú i̱vi̱ táhan da̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Já na̱cachi a já xi̱hi̱n dá: —Cuáhán ndó ñuu loho ja̱n ta tá ná xi̱nu̱ co̱o ndó ja̱n ndiñe̱he̱ ndo̱ in búrro̱ jíhí ndíco̱ ndaa rí ta xi̱hi̱n mé rí ja̱n cándichi inga búrro̱ loho. Ndaxí ndó ri̱ ta cañehe ndó ndíví ri̱ quixi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ta ndá na̱ ná ca̱ha̱n xi̱hi̱n ndo̱ já quéa̱ cachi ndó xi̱hi̱n ná ña̱ xíní ñúhú xitoho ndó ri̱ joo tá ná ndihi chuun rí já nducú ñehe tucu da ri̱, já cachi ndó xi̱hi̱n ná —na̱cachi Jesús xi̱hi̱n ndíví da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tócó ndihi ña̱ yóho na̱ya̱ha já ná xi̱nu̱ co̱o nu̱ú ña̱ na̱ca̱hyí in da̱ profeta já: ");
INSERT INTO mksNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Joho cachi ndó xi̱hín na̱ ñuu Jerusalén: “Cande̱hé ndo̱. Ndáhví uun cáa da̱ cómí cuéntá sa̱ha̱ ndó. Va̱xi da nu̱ ndo̱ ta canúu da ja̱ta̱ búrro̱ jíhí, ja̱hyi in rí ndiójo, canúu da va̱xi da nu̱ ndo̱”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ta ndíví da̱ xíca tuun xi̱hín Jesús cán na̱sa̱ha̱n da̱ na̱caja da tá íin na̱sahnda Jesús chuun nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Já ñéhe da búrro̱ jíhí cán xi̱hi̱n búrro̱ loho, ja̱hyi rí na̱xi̱nu̱ na̱ nu̱ú Jesús. A̱nda̱ já na̱chojó na̱ cotó ndéé na̱ ja̱ta̱ ri̱ ta na̱ndaa Jesús ja̱ta̱ ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ta mé cua̱há ña̱yivi ndúu cán na̱casáhá na̱ chínduu na cotó ndéé na̱ íchi̱ mé nu̱ú ya̱ha Jesús cán. Ta java na na̱casáhá na̱ sáhndá na̱ ndahá yíto̱ ta chínduu na do̱ íchi̱ mé nu̱ú ya̱ha Jesús cu̱hu̱n a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ta ña̱yivi cua̱ha̱n chí nu̱u̱ ta jári na̱ va̱xi chí ja̱ta̱ na̱casáhá na̱ cáyuhú na̱ já cáchí na̱ já: —Cája cáhnu í da̱ na̱quixi chi̱chi David yóho. Ndicáhnu na̱há ná cacuu da̱ cómí cuéntá sa̱ha̱ yo̱ jáchi̱ cúú dá da̱ va̱xi yuhú nu̱u̱ Ndióxi̱. Cáhnu ná cacuu Ndióxi̱ —cáchí ña̱yivi cua̱ha̱ cán cáyuhú na̱ cása̱ha̱n na̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ta tá na̱ndi̱hvi Jesús ñuu Jerusalén cán tócó ndihi ña̱yivi na̱casáhá cátóntó ndiva̱ha na. Já cáchí xi̱hi̱n táhan na já: —Ndá da̱ cúú da̱ yóho —cáchí xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Java táhan na̱ cán cáchí na̱: —Da̱ yóho cúú in profeta, da̱ ñuu Nazaret cuéntá estado Galilea —cáchí xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","A̱nda̱ já na̱ndi̱hvi Jesús veñu̱hu cáhnu cán já na̱casáhá táxí ndihi a na̱ ndúu jícó xi̱hín na̱ ndúu xéen cán. Ta na̱xi̱có ñehe a mesa na̱ ndúu ndíjama jiu̱hún cán ta na̱xi̱có ñehe a táyi̱ sáco̱o na̱ ndúu jícó ndija̱ta. ");
INSERT INTO mksNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Já na̱casáhá cáchí a̱ já xi̱hín ndihi na̱ cán já: —Já cáchí tu̱hun Ndióxi̱ já: “Vehe mí i̱ cacuu a vehe nu̱ú quixi na ca̱ca̱ ta̱hví na̱ nu̱ Ndióxi̱”, cáchí tu̱hun Ndióxi̱. Joo ndóhó na̱ndai cuu ndó yóho caja cuíhná ndo̱ nu̱ú ña̱yivi —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tá na̱ndihi já na̱cayati java na̱ cua̱á xi̱hín java na̱ rénco̱ nu̱ á ini mé veñu̱hu cáhnu cán ta na̱ndaja va̱ha mé á na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Joo xójo̱ ndiva̱ha ini na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés tá na̱xini na ña̱ xitúhún na̱caja mé á ta tá na̱xini joho na ña̱ cája cáhnu na̱ va̱lí cán mé á tá cáchí na̱ já: “Cája cáhnu í da̱ na̱quixi chi̱chi David.” Sa̱há ña̱ cán quéa̱ xójo̱ ini na ");
INSERT INTO mksNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ta já na̱cachi na já xi̱hín Jesús: —Á xíni̱ jo̱hún ña̱ cáha̱n na̱ va̱lí yóho —na̱cachi na xi̱hín Jesús. Já na̱cachi Jesús já: —A̱ja̱n, xíni̱ jo̱ho i̱ ña̱ cája cáhnu na Ndióxi̱. Á co̱ó na̱cahvi ndó tu̱hun Ndióxi̱ nu̱ cáchí a̱ já: Ja̱nda̱ na̱ va̱lí ta ja̱nda̱ na̱ chíchí na̱caja Ndióxi̱ xi̱hi̱n ná, ña̱ ná cuu caja cáhnu na mé á, cáchí tu̱hun Ndióxi̱ —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A̱nda̱ já na̱jándacoo a na̱ já na̱queta ja̱tá ñuu cán cua̱ha̱n chí ñuu Betania ta cán na̱sahi̱in a. ");
INSERT INTO mksNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ta inga qui̱ví ita̱a̱n tá na̱ndicó co̱o a cua̱ha̱n chí Jerusalén já na̱casáhá cuíco a cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ta yuhú íchi̱ cán na̱xini a cándichi in ti̱tó ñu̱hú. Ta chí na̱sa̱ha̱n sánde̱hé a̱ á íin cui̱hi nu̱ do̱ caxí a̱. Joo co̱ó ña̱ha ná ndiñe̱he̱ a̱. Ndáha̱ uun dó cán cuití va íin. A̱nda̱ já na̱cachi a já xi̱hi̱n do̱: —Ni in túhún ga̱ tañu a̱ cána cui̱hi nu̱ yóhó —na̱cachi a xi̱hi̱n do̱. Chí i̱vi̱ la̱á na̱hi̱chi̱ ti̱tó ñu̱hú cán. ");
INSERT INTO mksNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tá na̱xini na̱ xíca tuun xi̱hín Jesús cán ña̱ yóho já na̱catóntó na̱ já cáchí na̱ já: —Ndá cuéntá quéa̱ na̱hi̱chi̱ ti̱tó ñu̱hú cán i̱vi̱ tu̱hun —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ta na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ná candeé ini ndó ye̱he̱ ta ni loho co̱ cáhvi i̱vi̱ joho ini ndó já quéa̱ cuu caja ndó ña̱ náhnu chága̱ nu̱ú ña̱ na̱caja i̱ yóho. Ta ja̱nda̱ cuu cachi ndó xi̱hín in yúcu̱: “Caxoo ta cuáhán jáque̱tún mún ini tañu̱hú”, ta chí já ndusa coo. ");
INSERT INTO mksNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ta tá ná candeé ini ndó ye̱he̱ nani xíca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ ta co̱ cáhvi i̱vi̱ joho ini ndó já quéa̱ ñe̱he̱ ndó ña̱ xíca̱ ndo̱ nu̱ á —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tá na̱ndihi já na̱ndi̱hvi Jesús ini veñu̱hu cáhnu cán ta nani jána̱ha̱ tu̱hun Ndióxi̱ nu̱ú na̱ ndúu cán na̱xi̱nu̱ na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ sa̱cua̱ha̱ nu̱ú na̱ Israel cán nu̱ á. Já na̱cachi na já xi̱hi̱n á: —Yo já sáhan ña̱ma̱ni̱ nu̱u̱n cajún ña̱ cájún yóho —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já: —Ta ná nda̱ca̱ tu̱hún ri ye̱he̱ va ndo̱hó ta tá ná nducú ñehe ndó tu̱hun nu̱ú i̱ a̱nda̱ já ca̱xi tu̱hun i̱ nu̱ ndó yo já na̱sa̱ha̱n ña̱ma̱ni̱ nu̱ú i̱ caja i̱ ña̱ cája i̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ta viti cachi ndó xi̱hín i̱ yo já na̱chindahá Juan ña̱ ná quixi da caja ndúta̱ dá ña̱yivi. Á Ndióxi̱ na̱chindahá da̱ á ña̱yivi na̱chindahá ñahá —na̱cachi Jesús ndáca̱ tu̱hun a na̱. Já na̱casáhá ndítúhún xi̱hi̱n táhan na já cáchí na̱ já: —Tá ná cachí ña̱ Ndióxi̱ quéa̱ na̱chindahá Juan ta já nducú ñehe Jesús tu̱hun nu̱ yo̱ já cachi da xo̱ho̱: “Ndá cuéntá quéa̱ co̱ó na̱xeen ndó candúsa ndó da̱, dá já”, cachi Jesús xo̱ho̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ta tá ná cachí ña̱ ña̱yivi cúú na̱ na̱chindahá Juan já yi̱hví yo̱ ña̱ ndicui̱ta ña̱yivi xi̱hi̱n yo̱. Jáchi̱ tócó ndihi na cándúsa na ña̱ na̱quixi Juan jáya̱ha da ña̱ na̱ca̱ha̱n Ndióxi̱ nu̱ú ña̱yivi —cáchí na̱ ndítúhún xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sa̱há ña̱ cán quéa̱ na̱cachi na já xi̱hín Jesús: —Co̱ xíni̱ toho nde̱ yo já na̱chindahá Juan. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ta ni ye̱he̱ a̱ cáxi tu̱hun i̱ nu̱ ndo̱ yo já na̱sa̱ha̱n ña̱ma̱ni̱ nu̱ú i̱ caja i̱ ña̱ yóho —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","A̱nda̱ já na̱cachi tucu Jesús xi̱hín na̱ cán já: —Cuni jo̱ho ndó ña̱ na̱ya̱ha in tañu. Íin in da̱ta̱a ta na̱sahi̱in i̱vi̱ ja̱hyi ta̱a da. Ta na̱sa̱ha̱n da̱ nu̱ú in táhan da̱ cán já na̱cachi da já xi̱hi̱n dá: “Ja̱hyi a, cuáhán caja chúun lohún nu̱ ñuhú i̱ nu̱ cáa tó uva”, na̱cachi da xi̱hín ja̱hyi da. ");
INSERT INTO mksNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Já na̱cachi ja̱hyi da já xi̱hi̱n dá: “A̱ cúhu̱n toho i̱ jáchi̱ co̱ xíca̱ ini i̱ cu̱hu̱n i̱”, na̱cachi da. Joo tá na̱ndihi na̱cahvi ini da ña̱ a̱ váha ná cuu ini da chí já na̱quee da cua̱ha̱n da̱ caja chúun da nu̱ ñúhu̱ tátá da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ta jári na̱sa̱ha̱n tátá da̱ cáha̱n da̱ xi̱hín inga ja̱hyi da ta quia̱hva já na̱sahnda ri da chuun nu̱ú da̱ cán. Ta da̱ cán na̱cachi da já xi̱hi̱n tátá da̱: “Ajan. Cu̱hu̱n i̱”, cáchí da̱. Joo tá na̱ndihi co̱ó na̱sa̱ha̱n toho da. ");
INSERT INTO mksNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ta viti cachi ndó xi̱hín i̱ ndá da̱ cúú da̱ na̱caja ña̱ cúni̱ tátá da̱ —na̱cachi Jesús. Já na̱cachi na̱ cán: —Da̱ nu̱ cuítí. A̱nda̱ já na̱cachi tucu Jesús já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ íin chága̱ sa̱há na̱ játaca jiu̱hún cuéntá impuesto xi̱hín na̱ji̱hí xíca ji̱i̱ ña̱ ná cacomí Ndióxi̱ cuéntá sa̱ha̱ ná a̱ ju̱ú ga̱ ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jáchi̱ na̱quixi Juan, da̱ jácandúta̱ ña̱yivi na̱jána̱ha̱ da̱ ndo̱hó ndaja ndítahan caja ndó ta co̱ó na̱xeen ndó candúsa ndó da̱. Joo na̱ játaca jiu̱hún cuéntá impuesto xi̱hín na̱ji̱hí xíca ji̱i̱ na̱candúsa na ña̱ na̱ca̱ha̱n da̱. Ta va̱tí na̱xini ndó ña̱ yóho joo co̱ó na̱xeen ndó ndija̱ma ndó ña̱ cája ndó jáchi̱ co̱ó na̱xeen ndó candúsa ndó mé Juan. ");
INSERT INTO mksNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ʼCuni jo̱ho ndó ná cacu u̱ inga quia̱hva nu̱ ndo̱. Na̱sahi̱in in da̱ta̱a ta na̱jánde̱e cua̱ha̱ dá tó uva nu̱ ñúhu̱ dá. Ta na̱sacu da in corra yíto̱ nu̱ do̱. Ta na̱cava̱ha da in nu̱ú cu̱hni̱ mé uva cán ña̱ cava̱ha vino. Ta na̱cava̱ha da in nu̱ jícó canúu da já cuu candaa da tócó ndihi dó cán. ʼA̱nda̱ já na̱sa̱ha̱n ndojó da̱ ñúhu̱ dá nu̱ú java na caja chúun na ña̱. Ta já na̱quee da cua̱ha̱n xícá da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ta tá na̱xi̱nu̱ tiempo jáquee na já na̱chindahá da̱ java mozo da̱ ña̱ ná cu̱hu̱n na̱ nu̱ú na̱ ndúu cája chúun ñúhu̱ da̱ cán ña̱ ná ndiquia̱hva na nu̱ dá ña̱ cáni nu̱ dá ndiquehe da sa̱ha̱ ñúhu̱ dá ña̱ na̱sa̱ha̱n ndojó da̱ nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Joo ndaja coo na̱ cája chúun nu̱ ñúhu̱ cán na̱tiin na in táhan da̱ cúú mozo da̱ cán ta na̱cani na da̱. Ta inga táhan da cán na̱sahní na̱. Ta inga táhan da̱ cán na̱ndicui̱ta ñee na xi̱hín yu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Joo mé da̱ xi̱hín ña̱ha ñúhu̱ cán na̱chindahá cua̱ha̱ chága̱ da̱ mozo da̱ na̱sa̱ha̱n da̱ nu̱ ñúhu̱ dá. Ta tá quia̱hva na̱caja na xi̱hi̱n mé java mozo na̱sa̱ha̱n nu̱ cuítí cán quia̱hva já na̱caja ri na̱ xi̱hi̱n tócó ndihi mozo cán. ");
INSERT INTO mksNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ʼTá na̱ndihi já na̱sacu ini da̱ xi̱hín ña̱ha ñúhu̱ cán chindahá da̱ ja̱hyi da jáchi̱ na̱ca̱hán da̱: “Cája i̱ cuéntá coo toní ñúhú na̱ xi̱hín ja̱hyi i̱”, na̱ca̱hán da̱ xi̱hín ña̱ha ñúhu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Joo tá na̱xini na̱ cája chúun ndojó ñúhu̱ cán ña̱ va̱xi da̱ cúú ja̱hyi da̱ xi̱hín ña̱ha ñúhu̱ cán já na̱cachi xi̱hi̱n táhan na já: “Cande̱hé ndo̱. Yóho va̱xi da̱ cúú ja̱hyi xitoho í. Ta tá ná xi̱nu̱ qui̱vi̱ quivi xitoho í ta da̱ yóho cacuu da ndicojo chuun sa̱ha̱ ñúhu̱ yóho. Cóho̱ cahní yó da̱ já ná cando̱o ñúhu̱ yóho ndáha̱ mí”, na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ña̱ cán quéa̱ na̱tiin na da̱ ta na̱tavá na̱ da̱ ja̱nda̱ yuhú cútu̱ ta cán na̱sahní na̱ da̱ —na̱cachi Jesús sácú a̱ quia̱hva. ");
INSERT INTO mksNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús na̱ ndúu cán já na̱cachi a já: —Ndía̱ cáhán ndo̱ caja da̱ xi̱hín ña̱ha ñúhu̱ yóho xi̱hín na̱ cája chúun nu̱ ñúhu̱ dá —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","A̱nda̱ já na̱cachi na̱ cán já xi̱hín Jesús: —Ña̱ caja da̱ quéa̱ cahní da̱ na̱ quini, mé na̱ na̱caja chúun tóo nu̱ ñúhu̱ da̱ cán. Ta já ndiquia̱hva ndojó da̱ ñúhu̱ da̱ nu̱ú java ga̱ na̱ ña̱ ná caja chúun na nu̱ á. Ta tá jáquee na ndiquia̱hva na nu̱ dá ña̱ cáni nu̱ dá ndiquehe da sa̱ha̱ ñúhu̱ dá —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Já na̱cachi Jesús já xi̱hín na̱ cán: —Á a̱ ñáha cahvi ndó tu̱hun Ndióxi̱ nu̱ cáchí a̱: Mé yu̱u̱ ña̱ na̱jácana da̱ cáva̱ha vehe, ña̱ cán cúú ña̱ na̱nduu yu̱u̱ ndúhu̱ sa̱há vehe ña̱ íin chága̱ sa̱ha̱. Ña̱ yóho quéa̱ na̱caja Ndióxi̱, ta cúú á in ña̱ha cáhnu ndiva̱ha nu̱ yo̱, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ña̱ cán quéa̱ cáha̱n i̱ xi̱hi̱n ndó ña̱ cacu xoo Ndióxi̱ ndo̱hó ña̱ ná a̱ cácomí ga̱ mé á cuéntá sa̱ha̱ ndo̱. Ta quia̱hva mé á ña̱ma̱ni̱ nu̱ú java ga̱ ña̱yivi ña̱ ná ndi̱hvi na nu̱ú cacomí Ndióxi̱ cuéntá sa̱ha̱ ná, mé na̱ ndiquia̱hva na nu̱ á ña̱ cáni nu̱ á ndiquehe a. ");
INSERT INTO mksNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ta cáchí i̱ xi̱hi̱n ndó ña̱ ye̱he̱ cúú u̱ tátu̱hun mé yu̱u̱ cáha̱n i̱ sa̱ha̱. Ta ndá na̱ ná ndicava ja̱tá yu̱u̱ cán chí chachi xéhé na̱. Quia̱hva já ndihi sa̱há ña̱yivi tá co̱ cúni̱ na̱ candúsa na ye̱he̱. Ta tá mé yu̱u̱ cán ná ya̱ha ndicava ja̱tá in na já ca̱ji̱ ndi̱hi̱ ñahá. Quia̱hva já ndihi sa̱há ña̱yivi ini indayá tá co̱ cúni̱ na̱ candúsa na ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tá na̱xini jo̱ho na̱ cúú sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ fariseo cán ña̱ yóho, na̱canda̱a̱ táhyí ini na ña̱ sa̱ha̱ mé ná cáha̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sa̱há ña̱ cán quéa̱ na̱nducú na̱ tiin na mé á joo co̱ó na̱cuu caja na sa̱há ña̱ na̱yi̱hví na̱ ña̱yivi jáchi̱ cándúsa ña̱yivi cán ña̱ cáha̱n Jesús cuéntá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tá na̱ndihi já na̱casáhá tucu Jesús jána̱ha̱ ña̱yivi xi̱hín ndinuhu quia̱hva. Já cáchí a̱ já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Nu̱ú cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi cúú á tátu̱hun ña̱ na̱ya̱ha xi̱hín in rey tá na̱cava̱ha da in víco̱ ña̱ tanda̱ha̱ ja̱hyi ta̱a da. ");
INSERT INTO mksNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na̱chindahá da̱ mozo da̱ ña̱ ná cu̱hu̱n da̱ cana da na̱ ndítahan quixi. Joo co̱ó na̱xeen na quixi na mé víco̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A̱nda̱ já na̱chindahá chága̱ da̱ mozo da̱ ña̱ ná ca̱xi tu̱hun da nu̱ú na̱ ndítahan quixi cán ña̱ sa̱ na̱caja ndíví da̱ ña̱ cuxu na. Sa̱ na̱xi̱hi̱ ti̱ndi̱qui̱ xi̱hín java ga̱ quíti̱, rí na̱ndaha. Sa̱ na̱candíví ndihi ña̱ha cuéntá víco̱ tánda̱ha̱ sa̱há ña̱ cán quéa̱ ná quixi na. Ña̱ yóho cúú chuun na̱ta̱hnda̱ nu̱ mozo cán cachi da xi̱hín na̱ ndítahan quixi cán. ");
INSERT INTO mksNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Joo co̱ ndáa na̱ cán cu̱hu̱n na̱. In táhan da̱ cán na̱quee da cua̱ha̱n da̱ cande̱hé da̱ nu̱ ñúhu̱ dá. Ta inga da na̱quee da cua̱ha̱n da̱ caja nda̱hvi̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ta java ga̱ na̱ cán na̱tiin na mozo mé rey cán ta na̱caja xíxi na xi̱hi̱n dá ja̱nda̱ quia̱hva na̱sahní ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A̱nda̱ já na̱xo̱jo̱ ndiva̱ha ini rey cán sa̱há ña̱ cán quéa̱ na̱chindahá da̱ soldado da̱ ña̱ ná cu̱hu̱n na̱ cahní na̱ na̱ na̱sahní ndi̱i cán ta ná chica̱a̱n ñúhu̱ dá ñuu na. ");
INSERT INTO mksNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A̱nda̱ já na̱cachi tucu rey cán já xi̱hín java ga̱ mozo da̱: “Sa̱ na̱candíví tócó ndihi ña̱ha ña̱ coo víco̱ joo na̱ na̱cana i̱ cán co̱ó sa̱ha̱ toho na quixi na víco̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ña̱ cán quéa̱ cuáhán ndó ndijáá cáyé náhnu ta ndá ña̱yivi na̱cuu cana ndó na̱ ná quixi na víco̱ tánda̱ha̱ yóho”, na̱cachi rey cán na̱sahnda da chuun nu̱ mozo da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A̱nda̱ já na̱quee mozo da̱ na̱sa̱ha̱n na̱ ndijáá cáyé ta ndaja cáa mé ña̱yivi na̱játaca na. Ña̱yivi va̱ha xi̱hín na̱ quini viti na̱taca na̱caja na. Ta já na̱jácutú na̱ vehe nu̱ú coo víco̱ tánda̱ha̱ cán xi̱hín ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ʼA̱nda̱ já na̱ndi̱hvi rey nu̱ ñúhu na̱ cán já na̱xini da ndáca̱a̱n in da̱ta̱a, da̱ co̱ ndíxi jáhma̱ ña̱ ndíxi na̱ ndúu víco̱ tánda̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ta na̱cayati mé rey nu̱ dá já na̱cachi da já xi̱hi̱n dá: “Amigo, ndaja na̱cajún na̱qui̱hvún yóho tá co̱ ndíxi tohún jáhma̱ ña̱ ndíxi na̱ ndúu víco̱ tánda̱ha̱”, na̱cachi rey xi̱hín da̱ cán. Joo co̱ó na̱nducú ñehe da tu̱hun nu̱ rey. ");
INSERT INTO mksNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","A̱nda̱ já na̱sahnda rey chuun nu̱ mozo da̱. Já na̱cachi da já xi̱hi̱n ná: “Cató ndó ndáha̱ dá xi̱hín sa̱ha̱ dá. Ta jácana ndó da̱ chí ja̱ta̱ nu̱ú naá yávi̱. Cán cuacu ndiva̱ha da a̱nda̱ quia̱hva cahñá nu̱hu̱ da̱”, cáchí da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jáchi̱ cua̱há ndiva̱ha cúú ná na̱cana Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ joo chá cúú ná ndíquia̱hva na ndáha̱ mé á ña̱ ná cuu ca̱xi a na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tá na̱ndihi já na̱quee na̱ fariseo na̱sa̱ha̱n na̱ jándique táhan na tu̱hun na ndaja caja na coto ndojó na̱ Jesús xi̱hín tu̱hun cáha̱n mé á já ná cuu jácojo na cua̱chi ja̱tá. ");
INSERT INTO mksNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ña̱ cán quéa̱ na̱chindahá na̱ java na̱ cuéntá mé ná xi̱hín java na̱ cuéntá Herodes nu̱ú Jesús já na̱cachi na já xi̱hi̱n á: —Maestro, xíni̱ nde̱ ña̱ ndinuhu ña̱ nda̱a̱ cáha̱n mé ndó. Ta cánda̱a̱ ini nde̱ ña̱ jána̱ha̱ ndó ña̱ nda̱a̱ sa̱ha̱ íchi̱ cuéntá Ndióxi̱. Ta co̱ quéhe̱ ndó cuéntá tá cáha̱n núu ña̱yivi sa̱ha̱ ndo̱. Ta cánda̱a̱ ini nde̱ ña̱ tá cáha̱n ndó sa̱há in ña̱ha cája ña̱yivi cúú á sa̱há ña̱ sánde̱hé ndó ja̱nda̱ ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sa̱há ña̱ cán quéa̱ cúni̱ nde̱ canda̱a̱ ini nde̱ ndía̱ cachi ndó sa̱há ña̱ yóho: Á ndítahan nu̱ú nde̱ cha̱hvi nde̱ jiu̱hún cuéntá impuesto nu̱ú da̱ cómí cuéntá sa̱há ñuu Roma. Á cha̱hvi nde̱ ña̱ á a̱ cháhvi toho nde̱ ña̱ —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Joo sa̱ na̱canda̱a̱ ini Jesús ña̱ cáhvi núu ini na sa̱há ña̱ cán quéa̱ na̱cachi a já xi̱hi̱n ná: —Co̱ cúú ndó tá quia̱hva ndáa ndó jáchi̱ cúni̱ ndó coto ndojó cuití ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jána̱ha̱ ndó in táhan jiu̱hún ña̱ cháhvi ndó impuesto ja̱n nu̱ú i̱ —na̱cachi Jesús. A̱nda̱ já na̱sa̱ha̱n na̱ in jiu̱hún ca̱a naní denario nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tá na̱xini Jesús ña̱ yóho já na̱cachi a já xi̱hi̱n ná: —Yo na̱hná ta yo qui̱vi̱ quéa̱ ndáa nu̱ á —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Já na̱cachi na̱ cán já xi̱hi̱n á: —Ñéhe a na̱hná xi̱hín qui̱ví da̱ cómí cuéntá sa̱há ñuu Roma —na̱cachi na. A̱nda̱ já na̱cachi tucu Jesús já: —Ndiquia̱hva ndó ña̱ cúú ña̱ha da̱ cómí cuéntá sa̱há ñuu Roma ja̱n nu̱ dá. Ta ndiquia̱hva ndó ña̱ cúú ña̱ha Ndióxi̱ nu̱ á —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tá na̱xini jo̱ho na̱ cán ña̱ yóho já na̱catóntó na̱ ta na̱jándacoo na a̱ na̱quee na cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta sa̱ mé qui̱vi̱ já na̱sa̱ha̱n java na̱ saduceo ca̱ha̱n na̱ xi̱hín Jesús. Ta mé na̱ saduceo yóho co̱ cándúsa na ña̱ nditacu tucu na̱ sa̱ na̱xi̱hi̱. Sa̱há ña̱ cán quéa̱ na̱nda̱ca̱ tu̱hún na̱ Jesús já cáchí na̱ já xi̱hi̱n á: ");
INSERT INTO mksNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, nu̱ ley na̱ca̱hyí Moisés sa̱nahá na̱ta̱hnda̱ chuun ta cáchí a̱ já: “Tá tánda̱ha̱ in da̱ta̱a xi̱hi̱n ñájíhí da̱ ta tá xíhi̱ da̱ ta co̱ó ja̱hyi da cácu já quéa̱ ndítahan nu̱ú ñani da tanda̱ha̱ dá xi̱hi̱n ñá cuáa̱n na̱cando̱o cán. Ta já ná coo ja̱hyi da̱ cán xi̱hín yuhú nu̱ú ñani da”, cáchí ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ta viti cuni jo̱ho ndó ná cacu nde̱ in quia̱hva nu̱ ndó. Tañu mé nde̱ yóho na̱sa̱nduu u̱sa̱ ñani. Ta da̱ nu̱ cuítí cán na̱tanda̱ha̱ dá xi̱hín in ñáñáha̱. Tá na̱ndihi já na̱xi̱hi̱ da̱. Joo sa̱há ña̱ co̱ó ja̱hyi da na̱cacu xi̱hi̱n ñájíhí da̱ sa̱há ña̱ cán quéa̱ na̱ndiquehe ñani da, da̱ chí i̱vi̱ ja̱ta̱ dá ñá cuáa̱n cán. ");
INSERT INTO mksNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ta quia̱hva já na̱ndoho ri da̱ chí i̱vi̱ cán jáchi̱ na̱xi̱hi̱ da̱ ta co̱ó ja̱hyi da na̱cacu xi̱hi̱n ña̱. Ta ja̱nda̱ ndíhu̱sa̱ ñani cán na̱tanda̱ha̱ xi̱hi̱n ña̱ ta ndíhu̱sa̱ da̱ na̱xi̱hi̱ ta ni in da co̱ó na̱cacu ja̱hyi xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ta tá nu̱ ndíhí na̱xi̱hi̱ ri ñáñáha̱ cán va. ");
INSERT INTO mksNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ta viti cachi ndó xi̱hín nde̱ tá ná xi̱nu̱ qui̱ví nditacu tucu ndi̱i, ndá da̱ cacuu ndusa yíi̱ ñá cán jáchi̱ ndíhu̱sa̱ ñani cán na̱tanda̱ha̱ xi̱hi̱n ñá ñuyíví yóho —na̱cachi na̱ saduceo cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A̱nda̱ já na̱cachi Jesús já: —A̱ váha toho cáhán ndo̱ jáchi̱ co̱ xíni̱ ndó ndaja cáha̱n tu̱hun Ndióxi̱ ta ni co̱ xíni̱ ndó ndá quia̱hva cáhnu cúú ndée̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Jáchi̱ mé qui̱vi̱ tá ná nditacu tucu ndi̱i a̱ tánda̱ha̱ ga̱ ná ta ni a̱ quiáhva na ja̱hyi jíhí na̱ tanda̱ha̱ ná. Cacuu na tátu̱hun táto̱ Ndióxi̱ ndúu indiví ta co̱ tánda̱ha̱ na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Joo sa̱ xíni̱ yo̱ ña̱ nditacu tucu ndi̱i. Á a̱ ñáha cahvi ndó tu̱hun Ndióxi̱ nu̱ cáchí a̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ye̱he̱ cúú Ndióxi̱ ña̱ cája cáhnu Abraham ta ye̱he̱ cúú Ndióxi̱ ña̱ cája cáhnu Isaac ta ye̱he̱ cúú Ndióxi̱ ña̱ cája cáhnu Jacob viti”, na̱cachi a. Ta ña̱ yóho cúni̱ cachi a ña̱ tácú yi̱i̱ va Abraham xi̱hín Isaac xi̱hín Jacob va̱tí sa̱ na̱xi̱hi̱ yiquí cu̱ñu na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tá na̱xini jo̱ho ña̱yivi ndúu cán ña̱ yóho já na̱catóntó na̱ xi̱hín ña̱ jána̱ha̱ Jesús nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tá na̱ñe̱hé na̱ fariseo tu̱hun ña̱ na̱quee va̱ha Jesús na̱sa̱hnu̱ a̱ nu̱ú na̱ saduceo já na̱nditútú ndihi na. ");
INSERT INTO mksNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ta in táhan mé da̱ cán, da̱ jána̱ha̱ ley Moisés na̱nda̱ca̱ tu̱hún da̱ Jesús jáchi̱ cúni̱ da̱ coto ndojó da̱ mé á. Já na̱cachi da já: ");
INSERT INTO mksNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, ndía̱ cúú ña̱ cáhnu chága̱ sáhndá ley Moisés caja í —na̱cachi da̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Já na̱cachi Jesús já xi̱hi̱n dá: —Ña̱ cáhnu chága̱ nu̱ ley Moisés cúú ña̱ yóho: “Ndítahan qui̱hvi̱ ini ndó Ndióxi̱, xitoho ndó xi̱hi̱n tócó ndihi ínima̱ ndó ta xi̱hín ndinuhu ini ndó ta xi̱hi̱n tócó ndihi xíní túni̱ ndo̱.” ");
INSERT INTO mksNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ña̱ yóho cúú ley nu̱ cuítí ta cúú á ña̱ cáhnu chága̱ nu̱ tócó ndihi ley. ");
INSERT INTO mksNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ta tá quia̱hva íin ña̱ nu̱ cuítí yóho quia̱hva já íin ri ña chí i̱vi̱ va ta cáchí a̱ já: “Xíní ñúhú qui̱hvi̱ ini ndó ñani táhan ndó tá quia̱hva quíhvi̱ ini ndó mé ndó.” ");
INSERT INTO mksNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ta ja̱ta̱ ndíví ña̱ yóho tíin tócó ndihi ley Moisés xi̱hín ña̱ na̱jána̱ha̱ na̱ profeta sa̱nahá —na̱cachi Jesús xi̱hín na̱ fariseo cán. ");
INSERT INTO mksNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ta nani na̱nditútú ndihi na̱ fariseo ndúu na nu̱ Jesús cán já na̱nda̱ca̱ tu̱hún a̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Já na̱cachi a já xi̱hi̱n ná: —Ndía̱ cáhvi ini ndó sa̱ha̱ Cristo. Ndá chi̱chi cáhán ndo̱ va̱xi a —na̱cachi Jesús xi̱hi̱n ná. Já na̱cachi na̱ cán já: —Va̱xi a chi̱chi David, da̱ na̱sa̱cuu rey sa̱nahá —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","A̱nda̱ já na̱cachi tucu Jesús já xi̱hi̱n ná: —Tá ta̱ mé a̱ nda̱a̱ va̱xi Cristo chi̱chi David ndá cuéntá quéa̱ na̱cachi da ña̱ cúú á xitoho da. Jáchi̱ na̱chutú nda̱a̱ ínima̱ David xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱ tá na̱ca̱hyí da̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Já na̱cachi Ndióxi̱ xi̱hín xitoho i̱: “Caco̱o xoo cuáha i̱ yóho ja̱nda̱ quia̱hva ná caja i̱ ña̱ ná cacomún cuéntá sa̱há na̱ co̱ cúní yo̱hó”, na̱cachi Ndióxi̱, na̱cachi David. ");
INSERT INTO mksNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ndáva̱ha cáchí na̱ ña̱ va̱xi Cristo chi̱chi David tá ta̱ sa̱ mé David na̱cachi da ña̱ cúú á xitoho da —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ta chí ni in na co̱ó na̱cuu caja nducú ñehe na tu̱hun nu̱ á. Ta ja̱nda̱ mé qui̱vi̱ já ni in ga̱ na̱ co̱ó na̱sa̱ha̱n ndeé ini nda̱ca̱ tu̱hún chága̱ na̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n tócó ndihi ña̱yivi ta xi̱hín na̱ xíca tuun xi̱hi̱n á cán já: ");
INSERT INTO mksNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Na̱ jána̱ha̱ ley xi̱hín na̱ fariseo cúú ná na̱ ndítahan nu̱u̱ ndicani na ña̱ cúni̱ cachi ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ña̱ cán quéa̱ xíní ñúhú caja ndó tócó ndihi ña̱ jána̱ha̱ na̱ nu̱ ndo̱. Joo a̱ cája toho ndó tá quia̱hva cája mé ná jáchi̱ co̱ cája na ña̱ jána̱ha̱ mé va na. ");
INSERT INTO mksNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Jáchi̱ cája na ña̱ ná coo i̱hvi̱ ndiva̱ha ley ja̱nda̱ quia̱hva co̱ ndeé ini ña̱yivi cája na ña̱. Joo mé ná ni loho tíín co̱ chíndeé ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ta cája na tócó ndihi ña̱ha ña̱ ná cuni ña̱yivi na jáchi̱ cátóó na̱ candi̱co̱ listoni náhnu ji̱ni̱ ná xi̱hín ji̱co̱ ndáha̱ ná nu̱ ndáa̱ tu̱hun Ndióxi̱. Ta cátóó na̱ coo lánda̱ chága̱ yuhú jáhma̱ ná a̱ ju̱ú ga̱ java ga̱ ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ta tá cua̱ha̱n na̱ víco̱ cátóó na̱ coo na nu̱ú va̱ha cuití va. Ta tá quíhvi na veñu̱hu cátóó na̱ caco̱o na nu̱ sáco̱o na̱ íin chága̱ sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ta cátóó na̱ ña̱ ná ca̱ha̱n toní ñúhú ndiva̱ha ña̱yivi xi̱hi̱n ná tá xíca nuu na nu̱ú ya̱hvi. Ta chí a̱ ju̱ú quia̱hva cátóó na̱ ña̱ ná cachi ña̱yivi ʼmaestroʼ xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ʼJoo ndóhó co̱ ndítahan nu̱ ndó nducú ndó ña̱ ná ca̱ha̱n ña̱yivi ʼmaestroʼ xi̱hi̱n ndo̱. Jáchi̱ in ñani cúú ndihi ndó ta in túhún cúú maestro ndo̱, mé á cúú Cristo. ");
INSERT INTO mksNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ta a̱ cáha̱n ndo̱ tátá cáhnu xi̱hín ni in ña̱yivi ñuyíví yóho jáchi̱ in túhún Ndióxi̱ cúú á tátá ndo̱ ta mé á íin a indiví. ");
INSERT INTO mksNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ta a̱ ndúcú ndo̱ ña̱ ná ca̱ha̱n ña̱yivi ʼjefeʼ xi̱hi̱n ndó jáchi̱ in túhún la̱á va cúú jefe ndo̱, mé a̱ cúú Cristo. ");
INSERT INTO mksNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ndá da̱ cúú da̱ cáhnu chága̱ tañu ndó xíní ñúhú da̱ cája chúun da sa̱há ndihi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jáchi̱ ndá na̱ ndíñehe jícó mé, jánuu ndáha̱ Ndióxi̱ na̱. Joo ndá na̱ jánuu ndáha̱ mé nu̱ Ndióxi̱, jándiñehe jícó mé á na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ʼNdáhví na̱cuu ndó, na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo jáchi̱ co̱ cúú ndó tá quia̱hva ndáa ndó. Jáchi̱ sájí nuu ndó nu̱ú ña̱yivi já ná a̱ cu̱ú cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. Ta ni ndóhó co̱ ndíquia̱hva ndó mé ndó ndáha̱ Ndióxi̱ ná cacomí a̱ cuéntá sa̱ha̱ ndo̱. Ta cája ndó ña̱ ná a̱ cúu canda̱a̱ ini ña̱yivi ndaja caja na ndiquia̱hva na mé ná ndáha̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ndáhví na̱há na̱cuu ndó, na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo jáchi̱ co̱ cúú ndó tá quia̱hva ndáa ndó. Jáchi̱ cándaa ndó vehe na̱ji̱hí cuáa̱n ta tá na̱ndihi cua̱há ndiva̱ha xíca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ jáchi̱ cúni̱ ndó jája̱hvi ndó nu̱ú ña̱ núu cája ndó. Sa̱há ña̱ cán quéa̱ cáchí i̱ xi̱hi̱n ndó ña̱ ndóhó cacuu ndó na̱ ndoho chága̱ ini, caja Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ʼNdáhví na̱há na̱cuu ndó, na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo jáchi̱ co̱ cúú ndó tá quia̱hva ndáa ndó. Jáchi̱ a̱ ju̱ú quia̱hva xíca nuu ndó ndúcú ndo̱ in tála̱á ña̱yivi ña̱ ná candi̱co̱ na̱ ña̱ jána̱ha̱ ndo̱. Ta tá sa̱ na̱ndaja ndó na̱ cuéntá mé ndó já cája chága̱ na̱ cua̱chi ja̱nda̱ cáni a nu̱ ná ndoho chága̱ ini na̱ indayá a̱ ju̱ú ga̱ mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ʼNdáhví na̱há na̱cuu ndó jáchi̱ cúú ndó tátu̱hun na̱ cua̱á ndáca inga na̱ cua̱á. Jáchi̱ jána̱ha̱ ndó ña̱yivi ña̱ tá sáhan na tu̱hun na nu̱ú inga ña̱yivi nani tává na̱ qui̱vi̱ veñu̱hu cáhnu já quéa̱ co̱ ndúsa̱ jáxi̱nu̱ co̱o na tu̱hun na. Joo cáchí ndo̱ ña̱ tá tává na̱ qui̱vi̱ jiu̱hu̱n cuáán ndáca̱a̱n veñu̱hu cáhnu já quéa̱ ndúsa̱ jáxi̱nu̱ co̱o na tu̱hun na, já cáchí ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Joo tóntó ndiva̱ha ndó ta cúú ndó tátu̱hun na̱ cua̱á viti. Jáchi̱ co̱ cánda̱a̱ ini ndó ña̱ íin chága̱ sa̱há veñu̱hu cáhnu a̱ ju̱ú ga̱ sa̱há jiu̱hu̱n cuáán jáchi̱ mé jiu̱hu̱n cuáán cúú á cuéntá Ndióxi̱ sa̱há ña̱ ndáca̱a̱n ini veñu̱hu cáhnu ña̱ cúú cuéntá mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ta inga tucu ña̱ jána̱ha̱ ndó nu̱ú ña̱yivi cúú ña̱ yóho: Tá sáhan in na tu̱hun na nu̱ú ña̱yivi nani tává na̱ qui̱vi̱ nu̱ náa̱ Ndióxi̱ já quéa̱ co̱ ndúsa̱ jáxi̱nu̱ co̱o na tu̱hun na. Joo cáchí ndo̱ ña̱ tá tává ña̱yivi qui̱vi̱ ña̱ sájo̱co̱ na̱ cánúu nu̱ náa̱ cán já quéa̱ ndúsa̱ jáxi̱nu̱ co̱o na tu̱hun na, já cáchí ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Joo tóntó ndiva̱ha ndó ta cúú ndó tátu̱hun na̱ cua̱á. Jáchi̱ íin chága̱ sa̱há nu̱ náa̱ cán a̱ ju̱ú ga̱ sa̱há ña̱ sájo̱co̱ na̱ cánúu nu̱ náa̱ jáchi̱ ña̱ sájo̱co̱ na̱ cán cúú á cuéntá Ndióxi̱ sa̱há ña̱ cánúu a nu̱ náa̱ cuéntá mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sa̱há ña̱ cán quéa̱ ndá na̱ tává qui̱vi̱ nu̱ náa̱ já quéa̱ tává ndihi ri na qui̱vi̱ tócó ndihi ña̱ sájo̱co̱ na̱ cánúu nu̱ náa̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ta ndá na̱ tává qui̱vi̱ veñu̱hu cáhnu já quéa̱ tává ri na qui̱vi̱ Ndióxi̱ jáchi̱ cán íin mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ta ndá na̱ tává qui̱vi̱ indiví já quéa̱ tává ri na qui̱vi̱ Ndióxi̱ xi̱hín qui̱vi̱ nu̱ sáco̱o a sáhndá a̱ chuun. ");
INSERT INTO mksNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ʼNdáhví na̱há na̱cuu ndó, na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo jáchi̱ co̱ cúú ndó tá quia̱hva ndáa ndó. Mé ndó cáva̱ha ndó u̱xu̱ táhndá ña̱ jáquee ndó ñundáhyi̱ ndo̱ ta sáhan ndó in táhndá ña̱ nu̱ Ndióxi̱. Já cája ndó a̱nda̱ yu̱cu̱ válí ña̱ támi sáha̱n tátu̱hun menta xi̱hín anís xi̱hi̱n comino. Joo co̱ cája ndó ña̱ íin chága̱ sa̱ha̱ ña̱ sáhndá ley Moisés. Jáchi̱ co̱ cája ndó ña̱ nda̱a̱ ta co̱ cándáhví ini ndó ña̱yivi ta co̱ cándeé ini ndó Ndióxi̱ tá quia̱hva sáhndá ley caja ndó. Mé a̱ nda̱a̱ xíní ñúhú cája ndó tócó ndihi ña̱ yóho joo a̱ jándacoo ndó ña̱ jóco̱ ndó nu̱ Ndióxi̱ in táhndá nu̱ú u̱xu̱ táhndá ña̱ ñéhe̱ ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mé ndó cúú ndó tátu̱hun na̱ cua̱á ndáca inga na̱ cua̱á. Jáchi̱ ndinuhu ini ndó cája ndó ña̱ co̱ó cua̱há sa̱ha̱ cuéntá ley Moisés joo sácú xoo ndó ña̱ íin chága̱ sa̱ha̱ nu̱ Ndióxi̱ caja ndó. Cúú ndó tátu̱hun in da̱ ndíhi ini da tavá da̱ in ndicama loho ndáca̱a̱n tásá da̱ ná a̱ cócó da̱ ri̱. Joo co̱ íhvi̱ toho nu̱ dá cocó da̱ in camello. ");
INSERT INTO mksNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ʼNdáhví na̱há na̱cuu ndó, na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo jáchi̱ co̱ cúú ndó tá quia̱hva ndáa ndó. Jáchi̱ ndíhi ini ndó caja ndó costumbre ña̱ ndícata ndó ja̱ta̱ vaso xi̱hín ja̱tá co̱ho̱ joo ña̱ ñúhu ini a cán na̱játaca cuíhná ndo̱ sa̱há ña̱ ndiáva̱ ndiva̱ha ini ndó ña̱ núu. ");
INSERT INTO mksNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ndáhví na̱há na̱cuu ndó, na̱ fariseo jáchi̱ cúú ndó tátu̱hun na̱ cua̱á. Ña̱ ndítahan caja ndó nu̱ cuítí quéa̱ ndaja vií ndó ínima̱ ndó já cacuu ndó tátu̱hun in vaso á in co̱ho̱ sa̱ na̱ndicata va̱ha na jáchi̱ na̱ndivií ini a xi̱hín ja̱tá viti. ");
INSERT INTO mksNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ʼNdáhví na̱há na̱cuu ndó, na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo jáchi̱ co̱ cúú ndó tá quia̱hva ndáa ndó. Cúú ndó tátu̱hun vehe válí ndíta camasanto nu̱ táán na̱ ndi̱i. Ndató jándicuchu na ja̱tá joo chí ini a a̱ ju̱ú quia̱hva quini sáha̱n jáchi̱ ndinuhu lásá ndi̱i ñúhu ini a. ");
INSERT INTO mksNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Quia̱hva já cúú mé ndó jáchi̱ ndáa ndó tátu̱hun ña̱yivi va̱ha ndiva̱ha. Joo mé a̱ nda̱a̱ co̱ cúú ndó tá quia̱hva ndáa ndó jáchi̱ ndinuhu ña̱ núu ndáca̱a̱n ínima̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ʼNdáhví na̱há na̱cuu ndó, na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo jáchi̱ co̱ cúú ndó tá quia̱hva ndáa ndó. Cáva̱ha ndó vehe válí ndíta camasanto nu̱ú cañuhu lásá na̱ na̱sa̱cuu profeta sa̱nahá ta jácacutú ndó nu̱ú na̱ndu̱xu̱ na̱ na̱caja nda̱a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ta cáchí ndo̱ já: “Ta tá na̱sanduu nde̱ tiempo na̱sa̱nduu tásáhnu jícó yo̱ sa̱nahá ta chí a̱ chíndeé toho nde̱ na̱ na̱sahní profeta, na̱ na̱sa̱nduu sa̱nahá”, cáchí ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ta xi̱hín ña̱ yóho náha̱ táhyí a̱ ña̱ na̱quixi ndó chi̱chi na̱ na̱sahní profeta sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Cuáhán ndo̱ jáxi̱nu̱ co̱o ndó mé cua̱chi na̱casáhá cája tásáhnu jícó ndo̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ʼMé ndó cúú ndó tátu̱hun co̱o jáchi̱ cája ndó tá quia̱hva cája co̱o. A̱ cu̱ú ca̱cu ndaa ínima̱ ndó ta chí tandaa qui̱vi̱ cu̱hu̱n ndó indayá nu̱ ndoho ndiva̱ha ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sa̱há ña̱ cán quéa̱ ye̱he̱ chindahá i̱ java profeta nu̱ ndo̱ xi̱hín java na̱ ndi̱chí xi̱hín java na̱ jána̱ha̱ tu̱hun Ndióxi̱ nu̱ ndo̱. Joo java na cahní ndó na̱ ta java na cata caa ndó na̱ ndi̱ca crúxu̱ ta java na cani ndó na̱ ini veñu̱hu ta java na taxí ndó na̱ tá ñuu tá ñuu. ");
INSERT INTO mksNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ña̱ cán quéa̱ ca̱ca̱ Ndióxi̱ cuéntá nu̱ ndó sa̱ha̱ tócó ndihi ña̱yivi nda̱a̱, na̱ na̱sahní ndo̱ sa̱nahá. Ca̱ca̱ mé á cuéntá sa̱ha̱ Abel, da̱ na̱sacuu da̱ nda̱a̱ ja̱nda̱ quia̱hva na̱xi̱nu̱ co̱o a nu̱ú ca̱ca̱ mé á cuéntá sa̱há Zacarías, da̱ na̱sacuu ja̱hyi Berequías. Mé da̱ yóho na̱sahní ndó ini veñu̱hu tañu nu̱ náa̱ xi̱hín nu̱ú yi̱i̱ ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ca̱ca̱ Ndióxi̱ cuéntá sa̱ha̱ tócó ndihi ndi̱i ja̱n nu̱ú ña̱yivi ndúu tiempo viti. ");
INSERT INTO mksNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ʼNdáhví na̱há na̱cuu ndó, na̱ ndúu ñuu Jerusalén. Jáchi̱ sáhní ndó na̱ profeta. Ta ndicui̱ta ndó cáni ndó na̱ xi̱hín yu̱u̱ na̱ na̱chindahá Ndióxi̱ nu̱ ndó. Cua̱há ndiva̱ha tañu cúni̱ jándataca ndihi i̱ ndo̱hó joo co̱ó na̱xeen ndó cuni jo̱ho ndó. Cúú á tá quia̱hva cája nduxú tá játaca rí ja̱hyi válí ri̱ ti̱xi ndi̱xi̱ rí. ");
INSERT INTO mksNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ta viti cuni jo̱ho ndó ña̱ cáha̱n i̱ xi̱hi̱n ndo̱. Va̱xi qui̱vi̱ tá ja̱ni̱ ndáha̱ mé vehe ndó cando̱o a. ");
INSERT INTO mksNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ta mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ a̱ cúní ga̱ ndó ye̱he̱ ja̱nda̱ quia̱hva ná xi̱nu̱ co̱o qui̱vi̱ cachi ndó: “Cáhnu na̱há ná cacuu da̱ va̱xi cuéntá Ndióxi̱, xitoho í”, cachi ndó —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ta tá sa̱ na̱quee Jesús veñu̱hu cáhnu Jerusalén cán cua̱ha̱n já na̱cativi na̱ xíca tuun xi̱hi̱n á nu̱ á ta na̱casáhá na̱ cáha̱n na̱ xi̱hi̱n á ndá quia̱hva cáa veñu̱hu cán. ");
INSERT INTO mksNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Joo na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ja̱nda̱ ni in yu̱u̱ yóho a̱ cándo̱o ja̱tá inga yu̱u̱ jáchi̱ va̱xi qui̱vi̱ tá ndita̱ni̱ ndihi ña̱ yóho —na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","A̱nda̱ já na̱quee Jesús cua̱ha̱n chí yúcu̱ nu̱ cáa yitó olivo xi̱hín na̱ xíca tuun xi̱hi̱n á. Ta nani ndúu na̱ cán na̱cativi na̱ xíca tuun xi̱hi̱n á nu̱ íin coo a cán já na̱casáhá ndáca̱ tu̱hún xóo na a̱ já na̱cachi na já xi̱hi̱n á: —Cúni̱ nde̱ ña̱ ná ca̱xi tu̱hun ndó xi̱hín nde̱ ndá ama coo tócó ndihi ña̱ yóho. Ta ndaja coo tá ná xi̱nu̱ co̱o qui̱ví quixi tucu ndó ñuyíví yóho. Ta ndaja coo tá ná ndihi sa̱ha̱ ñuyíví —na̱cachi na̱ xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Já na̱cachi Jesús já: —Cuéntá coo ndó ná a̱ jándahvi ni in na ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Jáchi̱ cua̱há ndiva̱ha na quixi na cuéntá mí i̱ ta ca̱ha̱n na̱ ña̱ tu̱hún tá cachi na já xi̱hi̱n ndo̱: “Ye̱he̱ cúú Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi”, cachi na. Ta xi̱hín ña̱ yóho cua̱há ndiva̱ha ña̱yivi jándahvi na. ");
INSERT INTO mksNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ta ja̱ndá joho ñe̱he̱ ndó tu̱hun ña̱ ndicui̱ta ña̱yivi cani táhan na yóho á cáa. Joo a̱ cáyi̱hví toho ndó jáchi̱ já ndítahan coo. Joo ña̱ yóho co̱ cúni̱ cachi a ña̱ na̱xi̱nu̱ co̱o qui̱ví nu̱ ndíhí. ");
INSERT INTO mksNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jáchi̱ ña̱yivi ndúu in nación ndicui̱ta na cani táhan na xi̱hín na̱ ndúu inga nación. Ta quixi ta̱ma̱ ta quixi cue̱he̱ ta ndaja táhan quixi a táan. ");
INSERT INTO mksNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ta ña̱ yóho cacuu a tondóhó ña̱ casáhá jihna ñúhú va̱xi nu̱ú ña̱yivi jáchi̱ cáma̱ni̱ xi̱nu̱ co̱o nu̱ú ndoho chága̱ ini na. ");
INSERT INTO mksNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ʼA̱nda̱ já tiin na ndo̱hó ta ndiquia̱hva na ndo̱hó ndahá na̱ co̱ cúni̱ ndo̱hó já ná caja xíxi na xi̱hi̱n ndo̱. Ta cahní na̱ ndo̱hó ta tócó ndihi ña̱yivi ndúu ñuyíví candají na̱ ndo̱hó sa̱há ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ta mé tañu já cua̱ha̱ ná jándacoo na ña̱ candeé ini na ye̱he̱ ta ndaja táhan mé ná candají táhan na ta ndaja mé ná ji̱có túhún táhan na. ");
INSERT INTO mksNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ta quixi cua̱há ndiva̱ha na̱ tu̱hún ta cachi na cúú ná profeta cuéntá Ndióxi̱ joo jándahvi na cua̱há ndiva̱ha ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ta sa̱há ña̱ ndicua̱há ndiva̱ha ña̱ núu ñuyíví yóho sa̱há ña̱ cán quéa̱ jándacoo cua̱há ña̱yivi ña̱ quíhvi̱ ini táhan na. ");
INSERT INTO mksNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Joo ndá na̱ ná candi̱co̱ tuun íchi̱ mí i̱ ja̱nda̱ ná xi̱nu̱ qui̱vi̱ quivi na, na̱ cán cacuu na ca̱cu ndaa ínima̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta níí cúú ñuyíví ndicui̱ta nuu tu̱hun va̱ha cáha̱n sa̱há ye̱he̱ já ná canda̱a̱ ini ña̱yivi ndá quia̱hva cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. A̱nda̱ jáví ndihi sa̱ha̱ ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ʼNa̱ cáhvi tutu ná canda̱a̱ ini na ña̱ cáha̱n. Sa̱nahá na̱ca̱hyí profeta Daniel sa̱há in ña̱ quini ña̱ játi̱ví ñahá. Tá ná cuni ndó ña̱ xínu̱ co̱o ña̱ yóho nu̱ú yi̱i̱ cuéntá Ndióxi̱ ");
INSERT INTO mksNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","já quéa̱ ndá na̱ ndúu estado Judea xíní ñúhú cunu na cu̱hu̱n na̱ chí yúcu̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ta ndá na̱ cándójó ji̱ni̱ véhe, co̱ ndítahan nuu na tavá na̱ ndá ña̱ha vehe na. ");
INSERT INTO mksNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ta ndá na̱ ndúu yúcu̱, ná a̱ ndícó co̱o na vehe na ndiquehe na jáhma̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ndáhví na̱cuu na̱ji̱hí, na̱ ñúhu ja̱hyi mé qui̱vi̱ já. Ta ndáhví na̱cuu na̱ji̱hí na̱ néhe ndaa na̱ va̱lí táhan ña̱ chíchí yi̱i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ca̱ca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ ña̱ ná a̱ cácuu a̱ tiempo vi̱xi tá ná cunu ndó cu̱hu̱n ndo̱. Ta ca̱ca̱ ta̱hví ndo̱ nu̱ á ña̱ ná a̱ cácuu a qui̱vi̱ ndíquehe ndée̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jáchi̱ qui̱ví ndoho ndiva̱ha ini ña̱yivi cacuu a cán. Jáchi̱ ja̱nda̱ tá na̱ca̱va̱ sáhá sa̱ha̱ ñuyíví co̱ó na̱ndoho ini na tá quia̱hva ndoho ini na mé qui̱vi̱ já. Ta tá ná ya̱ha ña̱ ja̱n, a̱ ndícó co̱o ga̱ ña̱ ndoho ini na quia̱hva já. ");
INSERT INTO mksNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ta tá ná a̱ ndája cuítí Ndióxi̱ tiempo cán ni in ña̱yivi a̱ cúu cacu ndaa. Joo sa̱há na̱ sa̱ na̱ca̱xi mé á sa̱há na̱ cán ndaja cuítí mé á tiempo cán. ");
INSERT INTO mksNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ʼTa tá ná cachi in na xi̱hi̱n ndó: “Cande̱hé ndo̱. Yóho íin Cristo, da̱ na̱chindahá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi.” Á tá ná cachi na: “Cande̱hé ndo̱. Cáa íin da”, cachi na, já quéa̱ a̱ cándúsa toho ndó na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Jáchi̱ quixi cua̱há na̱ jándahvi ndo̱hó ta ndaja na mé ná tátu̱hun Cristo. Joo a̱ ju̱ú Cristo cúú ná. Ta quixi cua̱ha̱ ná ta cachi na ca̱ha̱n na̱ cuéntá Ndióxi̱ ta jári caja na cua̱há ndiva̱ha ña̱ náhnu xi̱hín ña̱ xitúhún ña̱ ná jándahvi na ña̱yivi. Ta ja̱nda̱ na̱ sa̱ na̱ca̱xi Ndióxi̱ jándahvi na tá ná cuu caja na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cande̱hé ndo̱ jáchi̱ sa̱ na̱ca̱xi tu̱hun ya̱chi̱ ndihi i̱ ña̱ yóho xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ña̱ cán quéa̱ tá ná cachi na xi̱hi̱n ndo̱: “Cande̱hé ndo̱. Yucú íchí cáa íin Cristo.” Já quéa̱ a̱ cúhu̱n ndó ja̱n. Á tá ná cachi na xi̱hi̱n ndo̱: “Cande̱hé ndo̱. Ini vehe yóho ndáca̱a̱n da̱ cúú Cristo.” A̱ cándúsa ndó na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jáchi̱ tá quia̱hva yéhe̱ tása quéta xoo nu̱ cána ca̱ndii ta xójo̱ cava indiví quia̱hva já queta ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mé nu̱ candúhu̱ yiquí cu̱ñu ndi̱i cán cacuu nu̱ú ndicutú tiyo̱có canduu rí. ");
INSERT INTO mksNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ʼTa i̱vi̱ la̱á tá ja̱cá na̱ya̱ha qui̱ví ndoho na̱há ini na̱ cán já canaá nu̱ú ca̱ndii ta ni a̱ ndíye̱he̱ ga̱ yo̱o̱ ta ja̱nda̱ indiví quee qui̱mi cu̱yu rí nu̱ ñúhu̱ ta ja̱nda̱ indiví ña̱ na̱cava̱ha Ndióxi̱ ndiquiji nuu. ");
INSERT INTO mksNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","A̱nda̱ já ndaca náha̱ ña xitúhún indiví já canda̱a̱ ini ña̱yivi ña̱ va̱xi ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. Ta ndaja táhan ña̱yivi ndúu níí cúú sa̱há ñuyíví nda̱hyi̱ cóhó na̱ ta já cuni na ye̱he̱ quixi i̱ tañu vi̱co̱ indiví xi̱hi̱n tócó ndihi ndeé e̱ ta cuni na ndá quia̱hva cáhnu cúú ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ta já chindahá i̱ táto̱ mí i̱ ña̱ ná tiví cóhó na̱ trompeta já ná nditaca tócó ndihi na̱ na̱ca̱xi i̱ tañu tócó ndihi ñuu ja̱nda̱ níí cúú sa̱ha̱ ñuyíví ta ja̱nda̱ níí cúú sa̱há indiví. ");
INSERT INTO mksNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ʼJácuaha ndó ña̱ cúni̱ cachi mé quia̱hva sácú u̱ nu̱ ndó sa̱há yíto̱ ti̱tó ñu̱hú. Jáchi̱ tá yúta̱ ndáha̱ dó cán ta já va̱xi núma̱ válí do̱ já canda̱a̱ ini ndó ña̱ sa̱ na̱cayati tiempo ihní. ");
INSERT INTO mksNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Quia̱hva já cuu canda̱a̱ ini ndó ña̱ tá ná cuni ndó ña̱ sa̱ cúú tócó ndihi ña̱ na̱cachi i̱ xi̱hi̱n ndo̱ yóho já cuu canda̱a̱ cáxí ini ndó ña̱ sa̱ na̱cayati tiempo quixi tucu ye̱he̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ya̱ha tócó ndihi ña̱ yóho ta a̱nda̱ jáví quivi na̱ ndúu tiempo viti. ");
INSERT INTO mksNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ta ndihi sa̱ha̱ indiví xi̱hín ñuyíví joo a̱ ndíhi toho sa̱há tu̱hun na̱ca̱ha̱n i̱ xi̱hi̱n ndo̱ yóho jáchi̱ coo tá coo tá quia̱hva na̱cachi i̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ʼJoo ni in túhún toho ña̱yivi co̱ xíni̱ na̱ ndá qui̱vi̱ á ndá hora ya̱ha ña̱ yóho. Ni mé táto̱ Ndióxi̱ ndúu indiví co̱ xíni̱ na̱ ndá qui̱vi̱ coo ña̱ yóho. Ta ni ye̱he̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ co̱ xíni̱ ndá qui̱ví coo ña̱ yóho. In túhún Ndióxi̱, tátá i̱ quéa̱ xíni̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tá quia̱hva na̱ya̱ha tiempo tá na̱sahi̱in Noé sa̱nahá quia̱hva já ya̱ha ri tá ná tandaa qui̱ví quixi tucu ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jáchi̱ mé tiempo cán tá cáma̱ní cuun ja̱vi̱ quíni cán já cáxixi ña̱yivi ta cáxihi na ta tánda̱ha̱ ná ndúu na ja̱nda̱ quia̱hva na̱qui̱hvi Noé ini barco cáhnu cán. ");
INSERT INTO mksNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ta co̱ó na̱quehe na cuéntá ja̱nda̱ quia̱hva na̱xi̱nu̱ co̱o ja̱vi̱ quíni cán ta na̱jánaá dó sa̱há ndihi na. Quia̱hva já a̱ quéhe na cuéntá sa̱ha̱ ndá qui̱vi̱ quixi ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mé tiempo já canduu i̱vi̱ da̱ta̱a xútu da ta in da ndindita cu̱hu̱n xi̱hín i̱ ta inga da cando̱o va. ");
INSERT INTO mksNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ta canduu i̱vi̱ na̱ji̱hí ndíco na ta in ñá ndindita cu̱hu̱n xi̱hín i̱ ta inga ñá cando̱o va. ");
INSERT INTO mksNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ʼXíní ñúhú coo tia̱hva va̱ha ndó jáchi̱ co̱ xíni̱ ndó ndá qui̱vi̱ quixi tucu xitoho ndó. ");
INSERT INTO mksNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Xíní ñúhú canda̱a̱ va̱ha ini ndó ña̱ tá xíni̱ in da̱ta̱a ndá hora cúni̱ qui̱hvi ta̱a cui̱hná vehe da já quéa̱ a̱ cúju̱ toho da jáchi̱ candaa va̱ha da vehe da já ná a̱ quíhvi da̱ cui̱hná vehe da. ");
INSERT INTO mksNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sa̱há ña̱ cán quéa̱ ndítahan canduu tia̱hva ri ndóhó va. Jáchi̱ xi̱nu̱ co̱o ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi mé hora tá co̱ cáhán ndo̱ xi̱nu̱ co̱o i̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ʼMé ndó ndítahan nu̱ ndó cacuu ndó tátu̱hun in da̱ ndíchí ji̱ni̱, da̱ cája chúun va̱ha nu̱ú xitoho da. Ta na̱jándacoo xitoho da chuun ndáha̱ dá ña̱ ná quia̱hva da cuxu na̱ java ga̱ cúú mozo xi̱hín da̱ cán. A̱nda̱ já na̱quee xitoho da cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ta̱hví na̱cuu mé mozo cán tá xínu̱ co̱o xitoho da ta ndítahan da̱ cája chuun yi̱i̱ va da ña na̱cando̱o nu̱ dá caja da. ");
INSERT INTO mksNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ quia̱hva xitoho da̱ cán chuun nu̱ dá ña̱ ná cacomí da̱ cuéntá sa̱ha̱ tócó ndihi ña̱ha cómí xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Joo tá cásáhá da̱ cája núu da ta cáhán da̱ ña̱ cayáncá ndiva̱ha xitoho da ndicó co̱o da. ");
INSERT INTO mksNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ta sa̱há ña̱ cán quéa̱ cásáhá da̱ cája xíxi da xi̱hín java ga̱ na̱ cúú mozo xi̱hi̱n dá. Ta já cáa ga̱ da̱ cásáhá xíxi da ta xíhi da ta já xíni da. ");
INSERT INTO mksNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ta ndaja coo xi̱nu̱ co̱o xitoho mozo cán mé qui̱vi̱ co̱ cáhán da̱ ña̱ xi̱nu̱ co̱o da. ");
INSERT INTO mksNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A̱nda̱ jáví jándoho quini xitoho da̱ cán ini da jáchi̱ co̱ cúú dá tá quia̱hva cáa da. Ta ndítahan ndoho da tá quia̱hva ndoho tócó ndihi na̱ cája já mé nu̱ú cuacu ndiva̱ha na ja̱nda̱ quia̱hva cáhñá nu̱hu̱ ná —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Já cáchí tucu Jesús já: —Tá ná xi̱nu̱ co̱o qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi já cacuu a tá quia̱hva na̱ya̱ha xi̱hín u̱xu̱ na̱ji̱hí, na̱ tacú tá na̱sa̱ha̱n na̱ vicó tánda̱ha̱. Tá na̱quehe na candil ña̱ ñúhu sítí ini já cua̱ha̱n na̱ ndique táhan na xi̱hín da̱ tánda̱ha̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","U̱hu̱n táhan na̱ tacú cán cúú ná na̱ tácu̱ ini ta u̱hu̱n na̱ cán cúú ná na̱ co̱ tácu̱ toho ini. ");
INSERT INTO mksNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ndíhu̱hu̱n na̱ co̱ tácu̱ ini cán na̱tiin na candil ña̱ha na cua̱ha̱n na joo co̱ó na̱quehe chága̱ na̱ sítí ña̱ jácutú tucu na candil tá sa̱ cúni̱ nda̱hva̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Joo na̱ tácu̱ ini cán ñéhe na candil ña̱ha na ta ñéhe ri na yúyú sítí cua̱ha̱n na̱ ña̱ jácutú na̱ candil tá sa̱ cúni̱ nda̱hva̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ta ndaja coo na̱casáhá cáyáncá mé da̱ tánda̱ha̱ cán sa̱há ña̱ cán quéa̱ na̱naá ini ndihi na ta na̱qui̱ji̱ va na. ");
INSERT INTO mksNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Joo tá na̱cuu yati java ñuú já tácu̱ cáyuhú java na já cáchí na̱ já: “Cande̱hé ndo̱. Sa̱ va̱xi da̱ tánda̱ha̱. Cuáhán queta ndó ndiquehe ndó da̱”, cáchí na̱ cáyuhú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Já na̱ndaco̱o tócó ndihi na̱ tacú cán ta na̱casáhá na̱ cája ndíví na̱ candil ña̱ha na. ");
INSERT INTO mksNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A̱nda̱ já na̱casáhá ndíhu̱hu̱n na̱ co̱ tácu̱ ini cán cáha̱n na̱ xi̱hín ndíhu̱hu̱n na̱ tácu̱ ini cán já cáchí na̱ já xi̱hi̱n ná: “Caja ndó ña̱ma̱ni̱ quia̱hva loho ndó sítí ndo̱ nu̱ú nde̱ jáchi̱ sa̱ na̱ndihi sítí nde̱ ta ja̱lóho cúni̱ nda̱hva̱ candil ña̱ha nde̱”, cáchí na̱ co̱ tácu̱ ini cán. ");
INSERT INTO mksNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Já na̱nducú ñehe ndíhu̱hu̱n na̱ tácu̱ ini cán tu̱hun nu̱ ná já cáchí na̱ já: “A̱ cúu toho caja nde̱ quia̱hva nde̱ sítí nu̱ ndó jáchi̱ tia̱hva náá ndima̱ni̱ dó nu̱ mé nde̱. Va̱ha chága̱ cuáhán mé ndó nu̱ cáyahvi dó cueen ndó do̱”, na̱cachi na̱ tácu̱ ini cán xi̱hi̱n ná. Já na̱quee na̱ co̱ tácu̱ toho ini cán cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Joo nani na̱quee ndíhu̱hu̱n na̱ co̱ tácu̱ ini cán cua̱ha̱n na̱ cueen na sítí na̱ já na̱xi̱nu̱ da̱ tánda̱ha̱ cán ta na̱ndi̱hvi ndíhu̱hu̱n na̱ji̱hí tácu̱ ini cán ini vehe nu̱ íin vicó tánda̱ha̱ cán ta na̱ndaji yéhé. ");
INSERT INTO mksNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tá na̱ndihi já na̱ndai cuu ndíhu̱hu̱n na̱ na̱sa̱ha̱n na̱xeen sítí cán já cátí ndáha̱ ná yéhé ta cáyuhú na̱ já cáchí na̱ já: “Cuná loho ndó yéhé nu̱ú nde̱, xitoho”, cáchí na̱ cáyuhú na̱ ndíta na ja̱ta̱ véhe. ");
INSERT INTO mksNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A̱nda̱ já na̱nducú ñehe da̱ tánda̱ha̱ cán tu̱hun nu̱ ná já cáchí da̱ já xi̱hi̱n ná: “Co̱ xíni̱ toho i̱ yo cúú ndóhó”, na̱cachi da̱ cán xi̱hi̱n ná —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Já na̱cachi tucu Jesús já: —Sa̱há ña̱ cán quéa̱ xíní ñúhú cuéntá va̱ha coo ri ndóhó va jáchi̱ co̱ xíni̱ ndó ndá hora xi̱nu̱ co̱o qui̱ví cacomí Ndióxi̱ cuéntá sa̱ha̱ ndo̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ta já cáchí tucu Jesús já: —Tá ná xi̱nu̱ co̱o qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi já cacuu a tátu̱hun ña̱ na̱ya̱ha xi̱hín in da̱ta̱a. Tá na̱xi̱nu̱ co̱o qui̱ví quee da cu̱hu̱n xícá da̱ já na̱cana da java da̱ cája chúun xi̱hi̱n dá. Ta já na̱ndiquia̱hva da jiu̱hún da̱ ndahá da̱ cán ña̱ ná candaa da ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ta tá quia̱hva tia̱hva in in da cañehe da jiu̱hún quia̱hva já na̱sa̱ha̱n xitoho da nu̱ dá. In táhan da̱ cán na̱sa̱ha̱n xitoho da u̱hu̱n mil nu̱ dá ña̱ ná candaa da ña̱. Ta inga da̱ cán na̱ñe̱he̱ i̱vi̱ mil. Ta inga da̱ cán na̱ñe̱he̱ in mil. A̱nda̱ já na̱quee xitoho da cua̱ha̱n xícá da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ta ndaja coo da̱ na̱ndiquia̱hva xitoho u̱hu̱n mil ndáha̱ cán na̱caja da nda̱hvi̱ xi̱hín jiu̱hún xitoho da ta já na̱ñe̱he̱ dá inga u̱hu̱n mil chága̱ ja̱tá. ");
INSERT INTO mksNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ta jári da̱ na̱sa̱ha̱n xitoho i̱vi̱ mil nu̱ cán na̱caja da nda̱hvi̱ xi̱hín jiu̱hún cán ta na̱ñe̱he̱ dá inga i̱vi̱ mil ja̱tá. ");
INSERT INTO mksNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Joo da̱ na̱sa̱ha̱n xitoho in mil nu̱ cán na̱tiin da jiu̱hún xitoho da ta já na̱sa̱ha̱n da̱ na̱caan da in yávi̱ ta já na̱jándu̱xu̱ da̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ʼTa tá sa̱ na̱ya̱ha cua̱ha̱ tiempo já na̱ndicó co̱o xitoho mozo cán. Ta já na̱casáhá cája vií da̱ cuéntá xi̱hín da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ta já na̱xi̱nu̱ da̱ na̱ñe̱he̱ u̱hu̱n mil cán nu̱ú xitoho da ta já na̱ndiquia̱hva da inga u̱hu̱n mil ña̱ na̱ñe̱he̱ dá ja̱tá jiu̱hún cán nu̱ú xitoho da. Ta já cáchí da̱ já xi̱hín xitoho da: “Cande̱hé ndo̱ u̱hu̱n mil na̱sa̱ha̱n ndó nu̱ú i̱. Joo yóho íin inga u̱hu̱n mil na̱ñe̱hé e̱ ja̱tá”, na̱cachi da xi̱hín xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A̱nda̱ já na̱cachi xitoho da já xi̱hi̱n dá: “Va̱ha ndiva̱ha na̱cajún. Mozo va̱ha ndiva̱ha cúú yóhó jáchi̱ chá va na̱sa̱ha̱n i̱ nu̱u̱n ta va̱ha na̱caja chúún ña̱. Sa̱há ña̱ cán quéa̱ caja i̱ ña̱ ná cacomún cuéntá sa̱há cua̱ha̱ chága̱ ña̱ha. Ta viti cuu coún xi̱hín i̱ ta já ná caji̱i̱ chága̱ inún”, na̱cachi xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tá na̱ndihi já na̱xi̱nu̱ co̱o ri da̱ na̱ndiquehe i̱vi̱ mil cán nu̱ú xitoho da. Já na̱cachi da já xi̱hín xitoho da: “I̱vi̱ mil na̱sa̱ha̱n ndó nu̱ú i̱ joo yóho íin inga i̱vi̱ mil na̱ñe̱hé e̱ ja̱tá”, na̱cachi da xi̱hín xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A̱nda̱ já na̱cachi xitoho da já xi̱hi̱n dá: “Va̱ha ndiva̱ha na̱cajún. Mozo va̱ha cúú yóhó jáchi̱ chá va na̱sa̱ha̱n i̱ nu̱u̱n ta na̱caja chúun va̱hún ña̱. Sa̱há ña̱ cán quéa̱ caja i̱ ña̱ ná cacomún cuéntá sa̱há cua̱ha̱ chága̱ ña̱ha. Ta viti cuu coún xi̱hín i̱ ta já ná caji̱i̱ chága̱ inún”, na̱cachi xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Joo tá na̱xi̱nu̱ co̱o ri da̱ na̱ñe̱he̱ in mil ndahá xitoho cán já na̱casáhá cáchí da̱ já xi̱hín xitoho da: “Cande̱hé ndo̱, xitoho i̱. Sa̱ cánda̱a̱ va̱ha ini i̱ ña̱ cúú ndó in ta̱a ndacú ndiva̱ha tu̱hun. Ta va̱tí co̱ xútu ndó nu̱ú in ñúhu̱ joo jáquee tá jáquee ndó nu̱ á. Ta játaca ndó ña̱ nu̱ú co̱ó na̱xutu ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sa̱há ña̱ cán quéa̱ na̱yi̱hví vi̱ ta na̱sa̱ha̱n i̱ na̱jándu̱xu̱ u̱ jiu̱hún na̱sa̱ha̱n ndó nu̱ú i̱ ti̱xi ñúhu̱. Joo yóho íin jiu̱hún ndo̱ ndiquehe ndó ña̱”, na̱cachi da̱ cán xi̱hín xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A̱nda̱ já na̱cachi xitoho da já xi̱hi̱n dá: “Co̱ cúún in mozo va̱ha nu̱ú i̱. Cúún da̱ júsá ndiva̱ha. Sa̱ cánda̱a̱ va̱ha inún ña̱ jáquee e̱ nu̱ ñúhu̱ ña̱ co̱ xútu u̱, ");
INSERT INTO mksNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ña̱ cán quéa̱ ndá cuéntá quéa̱ co̱ó na̱sa̱ha̱n tóún jiu̱hún i̱ banco já ná ndiquehe e̱ ji̱qui̱ á nu̱ú na̱ cán tá ná ndicó co̱o i̱, nduu”, na̱cachi xitoho da̱ cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","A̱nda̱ já na̱cachi da xi̱hín java na̱ ndúu cán: “Candaa ndó in mil ja̱n ndahá da̱ ja̱n ta quia̱hva ndó ña̱ nu̱ú da̱ sa̱ cómí u̱xu̱ mil ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jáchi̱ da̱ cája chúun va̱ha ñe̱he̱ chága̱ ví da̱ ña̱ha já quéa̱ ná coo cua̱há chága̱ nu̱ dá. Joo da̱ co̱ cája chúun va̱ha ja̱nda̱ ña̱ chá cómí da̱ ndindaa ndáha̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ta mozo a̱ váha toho ja̱n tiin ndó da̱ jácana ndó da̱ nu̱ú naá ja̱ta̱ véhe ja̱n. Cán cúú nu̱ ndáhyi̱ nda̱á ña̱yivi ja̱nda̱ quia̱hva cáhñá nu̱hu̱ ná sa̱há ña̱ ndóho ndiva̱ha ini na”, na̱cachi xitoho da, —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Já na̱cachi tucu Jesús já: —Tá ná xi̱nu̱ qui̱ví quixi ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta quixi i̱ xi̱hi̱n tócó ndihi na̱ cúú táto̱ Ndióxi̱. A̱nda̱ já caco̱o i̱ nu̱ sáco̱o na̱ sáhndá chuun ta já ndicáhnu ndiva̱ha i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ta nditaca ña̱yivi ndúu ndíjáá ñuyíví nu̱ú i̱. Ta já casáhá i̱ ndicahnda java táhan i̱ na̱ tá quia̱hva cája in da̱ ndáá ndicachi tá sáhndá java da ndicachi xi̱hín ti̱júhu̱ ña̱ ná a̱ cáva táhan rí. ");
INSERT INTO mksNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ta já chinduu u̱ ña̱yivi cuéntá mí i̱, na̱ cúú tátu̱hun ndicachi cán xoo cuáha i̱. Ta xoo íti i̱ chinduu u̱ na̱ co̱ cúú cuéntá mí i̱, na̱ cúú tátu̱hun ti̱júhu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ta sa̱há ña̱ cúú u̱ da̱ cómí cuéntá sa̱há ña̱yivi sa̱há ña̱ cán quéa̱ cachi i̱ já xi̱hín na̱ ndúu xoo cuáha i̱ cán já: “Cuáya̱ha ndó ná cacomí Ndióxi̱, tátá i̱ cuéntá sa̱ha̱ ndo̱ jáchi̱ cúú ndó na̱ na̱caja cua̱há mé á ña̱ma̱ni̱ xi̱hi̱n. Jáchi̱ ja̱nda̱ tá cáma̱ní ca̱va̱ sáhá sa̱ha̱ ñuyíví sa̱ na̱sacu tia̱hva mé á nu̱ú canduu ndó ña̱ cacomí a̱ cuéntá sa̱ha̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Jáchi̱ na̱sa̱ha̱n ndó na̱xixi i̱ tá na̱cuico i̱. Ta na̱sa̱ha̱n ndó ticui̱í nu̱ú i̱ tá na̱hi̱chi̱ ini i̱. Ta na̱ndiquehe va̱ha ndó ye̱he̱ tá na̱sacuu u̱ da̱ tóho̱ na̱xi̱nu̱ i̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ta na̱jasá ndo̱ jáhma̱ nu̱ú i̱ tá co̱ ñéhé e̱ ña̱ cándixi i̱. Ta tá na̱saquíhvi̱ já na̱chindeé ndó ye̱he̱. Ta tá na̱sa̱ndaca̱a̱n i̱ veca̱a já na̱xito nihni ndó ye̱he̱.” ");
INSERT INTO mksNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","A̱nda̱ já nda̱ca̱ tu̱hún java na̱ na̱caja va̱ha ta já cachi na já xi̱hín i̱: “Ndá tañu quéa̱ na̱xini nde̱ ña̱ cuíco ndó, xitoho nde̱ ta já na̱sa̱ha̱n nde̱ ña̱ xíxi ndó. Ta ndá tañu na̱xini nde̱ ña̱ íchi̱ ndó ticui̱í ta já na̱sa̱ha̱n nde̱ ticui̱í nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ta ndá tañu na̱sacuu ndó da̱ tóho̱ ta na̱ndiquehe va̱ha nde̱ ndo̱hó. Ta ndá tañu na̱xini nde̱ ña̱ cáma̱ní jáhma̱ candixi ndó ta na̱jasá nde̱ ña̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ta ndá tañu quéa̱ na̱xini nde̱ ña̱ quíhvi̱ ndo̱ ta na̱chindeé nde̱ ndo̱hó. Ta ndá tañu na̱sa̱ndaca̱a̱n ndó veca̱a ta na̱xito nihni nde̱ ndo̱hó.” ");
INSERT INTO mksNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A̱nda̱ já cachi ye̱he̱, da̱ cómí cuéntá sa̱há ña̱yivi já xi̱hi̱n ná: “Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ tá na̱caja ndó a̱ xi̱hín na̱ cúú cuéntá mí i̱, na̱ co̱ó sa̱ha̱ nu̱ú ña̱yivi ñuyíví já cúú á tátu̱hun na̱caja ndó a̱ xi̱hi̱n mí i̱”, cachi i̱ xi̱hín na̱ ndúu xoo cuáha i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ʼA̱nda̱ já casáhá cachi i̱ já xi̱hín na̱ ndúu xoo íti i̱ cán já: “Caxoo ndó nu̱ú i̱ jáchi̱ cúú ndó na̱ na̱cata̱vi̱ cháhan ta cu̱hu̱n ndó indayá cañuhu ndó a̱nda̱ ama cáa qui̱vi̱. Jáchi̱ ña̱ ja̱n cúú ña̱ na̱sacu tia̱hva Ndióxi̱ ndaca̱a̱n tiñáhá sa̱cua̱ha̱ xi̱hi̱n táto̱ mé rí. ");
INSERT INTO mksNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Jáchi̱ co̱ó na̱sa̱ha̱n ndó ña̱ xíxi i̱ tá na̱cuico i̱ ta ni co̱ó na̱sa̱ha̱n ndó ticui̱í nu̱ú i̱ coho i̱ tá na̱hi̱chi̱ ini i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Da̱ tóho̱ cúú u̱ na̱xi̱nu̱ co̱o i̱ tañu ndó ta co̱ó na̱ndiquehe va̱ha ndó ye̱he̱. Ta na̱ndima̱ni̱ i̱ ña̱ candixi i̱ ta co̱ó na̱sa̱ha̱n ndó in jáhma̱ loho nu̱ú i̱. Na̱saquíhvi̱ ta na̱sa̱ndaca̱a̱n i̱ veca̱a ta co̱ó na̱xito nihni ndó ye̱he̱”, cachi i̱ xi̱hín na̱ ndúu xoo íti i̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","A̱nda̱ já nducú ñehe ri na̱ cán tu̱hun nu̱ú i̱ já cachi na já xi̱hín i̱: “Ndá tañu quéa̱ na̱xini nde̱ ña̱ cuíco ndó ta ndá tañu quéa̱ na̱xini nde̱ ña̱ íchi̱ ini ndó ticui̱í ta ndá tañu na̱sacuu ndó da̱ tóho̱ ta ndá tañu na̱ndima̱ni̱ jáhma̱ ndo̱ ta ndá tañu na̱sahi̱in quíhvi̱ ndo̱ ta ndá tañu na̱sa̱ndaca̱a̱n ndó veca̱a ta co̱ó na̱chindeé nde̱ ndo̱hó”, cachi na̱ ndúu xoo íti i̱ cán xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","A̱nda̱ já cachi i̱ já xi̱hín na̱ co̱ cúú cuéntá mí i̱ já: “Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ta̱ co̱ó na̱caja ndó xi̱hín ñani táhan ndó, na̱ co̱ó sa̱ha̱ nu̱ú ña̱yivi ñuyíví já quéa̱ co̱ó na̱caja ndó ña̱ xi̱hín ye̱he̱”, cachi i̱ xi̱hín na̱ co̱ cúú cuéntá mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ta já ya̱ha ndihi na̱ cán cu̱hu̱n ná indayá a̱nda̱ ama cáa qui̱vi̱. Ta na̱ na̱caja va̱ha cán ya̱ha na nu̱ Ndióxi̱ catacu na a̱nda̱ ama cáa qui̱vi̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tá na̱ndihi na̱ca̱ha̱n Jesús tócó ndihi ña̱ yóho xi̱hín ña̱yivi cán já na̱cachi a xi̱hín na̱ xíca tuun xi̱hi̱n á cán já: ");
INSERT INTO mksNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Sa̱ cánda̱a̱ ini ndó ña̱ ti̱xi i̱vi̱ qui̱vi̱ coo vicó pascua ta já ndiquia̱hva na ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ndahá na̱ cata caa ye̱he̱ ndi̱ca crúxu̱ —na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A̱nda̱ já na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu na̱ndique táhan na yéhé Caifás, da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ta na̱jándique táhan tu̱hun na ndá quia̱hva caja na tiin je̱hé na̱ Jesús ña̱ ná cahní ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Já cáchí xi̱hi̱n táhan na já: —Joo a̱ tíin toho í da̱ tañu mé víco̱ jáchi̱ tia̱hva náá ndiva̱a̱ ña̱yivi —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ta ndaja coo íin Jesús ñuu Betania vehe Simón, da̱ cáha̱n na̱ xi̱hi̱n: ta̱a na̱ndoho cue̱he̱ táhyi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Já na̱xi̱nu̱ in ñáñáha̱ nu̱ á ta cáñee in yúyú ña̱ alabastro ndáha̱ ña̱. Ta ini mé yúyú cán ñúhu perfume, dó ya̱hvi ndiva̱ha. Ta já na̱xi̱nu̱ ñá na̱jácu̱yu ñá do̱ ji̱ni̱ Jesús nani íin coo a nu̱ mesa cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tá na̱xini na̱ xíca tuun xi̱hín Jesús cán ña̱ yóho já na̱casáhá na̱ xójo̱ ini na já cáchí na̱ já: —Ndá cuéntá quéa̱ tíví uun perfume ya̱hvi ndiva̱ha yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Jáchi̱ cuu ji̱có yó do̱ ta já quehé cua̱há jiu̱hún sa̱ha̱ do̱, nduu ta já cuu jasá yo̱ jiu̱hún cán nu̱ú na̱ nda̱hví —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ta na̱canda̱a̱ ini Jesús ña̱ cáhvi ini na̱ cán ña̱ cán quéa̱ na̱casáhá cáchí a̱ já xi̱hi̱n ná: —Ndá cuéntá quéa̱ cája cue̱he̱ ndó xi̱hi̱n ñáñáha̱ ja̱n jáchi̱ ña̱ va̱ha quéa̱ na̱caja ñá yóho xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jáchi̱ na̱ nda̱hví níí tiempo canduu na tañu ndó joo ye̱he̱ a̱ cóo tuun toho i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jáchi̱ tá na̱jácu̱yu ñá perfume yiquí cu̱ñu i̱ já na̱caja tia̱hva ñá ye̱he̱ ná coo tia̱hva vi̱ tá ná casa̱a̱ qui̱ví ndu̱xu̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ níí cúú ñuyíví nu̱ú caca nuu ña̱yivi ca̱ha̱n na̱ tu̱hun va̱ha sa̱há i̱ ndicani na ña̱ na̱caja ñá yóho xi̱hín i̱ já ndicu̱hu̱n ini na sa̱ha̱ ña̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ta ndaja coo in táhan da̱ u̱xu̱ i̱vi̱ xíca tuun xi̱hín Jesús, da̱ naní Judas Iscariote na̱sa̱ha̱n da̱ ca̱ha̱n da̱ xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ta já cáchí da̱ já xi̱hi̱n ná: —Ndaja quia̱hva ndó nu̱ú i̱ tá ná ndiquia̱hva i̱ Jesús nu̱ ndo̱ —na̱cachi Judas xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán. A̱nda̱ já na̱sa̱ha̱n na̱ o̱co̱ u̱xu̱ jiu̱hu̱n cúxú nu̱ dá sa̱há Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ta sa̱ mé nani já na̱casáhá Judas ndúcú da̱ ndaja cuu caja da ndiquia̱hva da Jesús ndáha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mé qui̱ví nu̱ú víco̱ xíxi na pan, ña̱ co̱ quée yusá na̱xa̱a̱ xi̱hi̱n cán já na̱xi̱nu̱ na̱ xíca tuun xi̱hín Jesús cán nu̱ á. Já na̱cachi na já xi̱hi̱n á: —Ndáchí cúni̱ ndó cu̱hu̱n nde̱ caja ndíví nde̱ cajíni ndó vicó pascua —na̱cachi na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Cuáhán ndó ñuu ja̱n ta ja̱n cuni ndó in da̱ta̱a ta já cachi ndó já xi̱hi̱n dá: “Da̱ jána̱ha̱ nde̱he̱ cáchí xu̱hu̱n: Cu̱hu̱n i̱ vehe ndó cajíni i̱ vicó pascua xi̱hín na̱ xíca tuun xi̱hín i̱ jáchi̱ sa̱ na̱ndindaa tiempo cu̱hu̱n i̱ viti” —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Já na̱quee na̱ cán na̱sa̱ha̱n na̱ na̱caja na tá íin na̱sahnda Jesús nu̱ ná ta cán na̱caja ndíví na̱ ña̱ cajíni na vicó pascua. ");
INSERT INTO mksNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ta ndaja coo tá na̱cuaá já na̱saco̱o Jesús nu̱ mesa xi̱hín ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hín a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ta nani xíjíni na já na̱casáhá cáchí a̱ já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ in táhan ndó, na̱ xíca tuun xi̱hín i̱ cacuu da̱ ji̱có túhún ye̱he̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A̱nda̱ já na̱casáhá na̱ cán cácuéha̱ ndiva̱ha ini na já na̱casáhá tá in tá in na ndáca̱ tu̱hún na̱ Jesús já cáchí na̱ já xi̱hi̱n á: —Á ye̱he̱ cacuu da̱ ji̱có túhún ndo̱, xitoho i̱ —cáchí na̱ ndáca̱ tu̱hún ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Da̱ na̱qui̱hvi ndáha̱ ini co̱ho̱ xíxi i̱, da̱ cán cúú da̱ ji̱có túhún ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ye̱he̱ cúú da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta ndítahan nu̱ú i̱ quivi i̱ tá íin cáchí tu̱hun Ndióxi̱. Joo ndáhví na̱há na̱cuu da̱ ji̱có túhún ye̱he̱. Ja̱nda̱ va̱ha chága̱ ná a̱ cácu da, nduu —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A̱nda̱ já na̱ndica̱ha̱n Judas, mé da̱ ji̱có túhún ñahá cán já na̱cachi da já xi̱hín Jesús: —Xitoho i̱, á ye̱he̱ cúú da̱ ji̱có túhún ndo̱ —na̱cachi da̱ xi̱hi̱n á. —Jivi mún cúú dá —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ta nani xíxi na ndúu na na̱tiin Jesús pan já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱. Tá na̱ndihi já na̱sahnda java ña̱ ta na̱ndicahnda ña̱ nu̱ú na̱ xíca tuun xi̱hi̱n á cán. Ta já na̱cachi a já xi̱hi̱n ná: —Júhun ndó jáchi̱ ña̱ yóho cúú tátu̱hun yiquí cu̱ñu i̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tá na̱ndihi já na̱tiin a in vaso nu̱ ñúhu tó uva já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱ já na̱cachi a já xi̱hín na̱ xíca tuun xi̱hi̱n á cán já: —Coho ndihi ndó dó ñúhu ini vaso yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Jáchi̱ dó yóho cúú dó tátu̱hun ni̱í i̱, dó cui̱ta sa̱há cua̱há ña̱yivi já ná ndoo cua̱chi na. Tá ná cui̱ta ni̱í i̱ já canda̱a̱ ini ndó ña̱ na̱jáxi̱nu̱ co̱o Ndióxi̱ tu̱hun a na̱sa̱ha̱n sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ a̱ cóho ga̱ i̱ tó uva ja̱nda̱ quia̱hva ná xi̱nu̱ co̱o qui̱ví coho tucu u̱ inga dó va̱ha chága̱ xi̱hi̱n ndo̱ tá ná xi̱nu̱ qui̱ví cacomí Ndióxi̱, tátá i̱ cuéntá sa̱há ña̱yivi —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ta tá na̱ndihi na̱xita na in canto já na̱quee na cua̱ha̱n na̱ yúcu̱ yitó olivo. ");
INSERT INTO mksNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ta já na̱cachi Jesús já xi̱hi̱n ná: —Mé ñuú viti jándacoo ndihi ndó ye̱he̱ cu̱hu̱n ndó sa̱há ña̱ ndoho i̱. Já cáchí tu̱hun Ndióxi̱ já: “Cahní i̱ da̱ ndáá ndicachi ta xi̱hín ña̱ yóho ndicui̱ta nuu ndicachi ja̱na̱ dá cu̱hu̱n ri̱”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Joo tá sa̱ ná nditacu tucu u̱ já cu̱hu̱n jihna ñúhú ye̱he̱ estado Galilea a̱nda̱ já cu̱hu̱n mé ndó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A̱nda̱ já na̱nducú ñehe Pedro tu̱hun nu̱ á já na̱cachi da já xi̱hi̱n á: —Va̱tí ná jándacoo tócó ndihi na mé ndó sa̱há ña̱ ndoho ndó joo a̱ jándacoo toho i̱ ndo̱hó —na̱cachi da xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xu̱hu̱n ña̱ mé ñuú viti tá cáma̱ni̱ cana chéle já chije̱hé tu̱hún ña̱ xínu̱n ye̱he̱ u̱ni̱ táhndá —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","A̱nda̱ já na̱cachi tucu da já: —Va̱tí ná quivi i̱ xi̱hi̱n ndo̱ joo a̱ chíje̱hé tu̱hun toho i̱ sa̱há ña̱ xíni̱ i̱ mé ndó —na̱cachi da xi̱hín Jesús. Ta quia̱hva já na̱cachi tócó ndihi java ga̱ na̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","A̱nda̱ já na̱xi̱nu̱ co̱o Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán in nu̱ú naní a̱ Getsemaní. Já na̱cachi a já xi̱hi̱n ná: —Yóho caco̱o ndó nani ná cu̱hu̱n i̱ cáa ca̱ca̱ ta̱hví i̱ nu̱ Ndióxi̱ —cáchí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta ndáca Pedro xi̱hi̱n ndíví da̱ cúú ja̱hyi Zebedeo cua̱ha̱n xi̱hi̱n á. Ta já na̱casáhá cácuéha̱ ndiva̱ha ini a ta a̱ ju̱ú quia̱hva táhvi̱ ini a. ");
INSERT INTO mksNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A̱nda̱ já na̱cachi a já: —A̱ ju̱ú quia̱hva cácuéha̱ ini i̱ chí quivi i̱ cúu ini i̱. Yóho candati tóo ndó ye̱he̱ ta coto a̱ cúju̱ ndo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ta já na̱quee mé á na̱sa̱ha̱n loho chága̱ chí nu̱u̱ já na̱caxítí a̱ ja̱nda̱ quia̱hva na̱xi̱nu̱ taan nu̱ ñúhu̱. Ta já cáchí a̱ já: —Tátá Ndióxi̱, tá ta̱ ná cuu caja ndó ña̱ma̱ni̱ ña̱ ná a̱ ndóho i̱ ña̱ i̱hvi̱ ndiva̱ha va̱xi nu̱ú i̱ ndoho i̱. Joo ná coo tá íin cúni̱ mé ndó ta ná a̱ cóo toho ña̱ cúni̱ ye̱he̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tá na̱ndihi já na̱ndicó co̱o a nu̱ú na̱jándacoo a na̱ xíca tuun xi̱hi̱n á cán ta já na̱ndiñe̱he̱ á na̱ quíji̱ na̱ ndúu na. A̱nda̱ já na̱cachi a já xi̱hi̱n Pedro: —Á co̱ó na̱cuu candita ndó ni in hora. ");
INSERT INTO mksNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xíní ñúhú coo tia̱hva ndó ta ca̱ca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ já ná a̱ cóto ndojó rí quini ndo̱hó. Jáchi̱ ínima̱ ña̱yivi cúni̱ a̱ ndinducú a̱ Ndióxi̱ joo yiquí cu̱ñu na co̱ íin tia̱hva caja ña̱ cúni̱ Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A̱nda̱ já na̱quee tucu Jesús táhndá i̱vi̱ cua̱ha̱n tucu a ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱ já cáchí a̱ já: —Tátá Ndióxi̱, tá ta̱ a̱ cúu va caja ndó ña̱ma̱ni̱ ná a̱ ndóho ini i̱ ña̱ ja̱n já ná coo tá íin cúni̱ mé ndó coo —cáchí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tá na̱ndihi já na̱ndicó co̱o tucu a nu̱ ndúu na̱ xíca tuun xi̱hi̱n á cán ta na̱ndiñe̱he̱ á na̱ quíji̱ tucu na ndúu na jáchi̱ na̱quehe a̱ ma̱hnú na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Já na̱quee tucu a na̱sa̱ha̱n xíca̱ ta̱hví a̱ nu̱ Ndióxi̱ táhndá u̱ni̱ ta sa̱ mé tu̱hun cán na̱ca̱ha̱n tucu a. ");
INSERT INTO mksNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","A̱nda̱ já na̱quixi tucu a nu̱ ndúu na̱ xíca tuun xi̱hi̱n á cán já na̱cachi a já xi̱hi̱n ná: —Va̱tí cúni̱ ndó cu̱ju̱ ndó ta va̱tí cúni̱ ndó ndiquehe ndée̱ ndó joo a̱ cúu caja ndó ña̱ viti. Jáchi̱ sa̱ na̱xi̱nu̱ co̱o hora ndiquia̱hva na ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ndahá ña̱yivi cája cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Cuáhán ndacoo ndó ná co̱ho̱. Jáchi̱ sa̱ va̱xi da̱ ji̱có túhún ye̱he̱ —cáchí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ta nani cáha̱n yi̱i̱ va Jesús já na̱xi̱nu̱ Judas, da̱ cúú in táhan u̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hi̱n á cán. Ta ndáca da cua̱há ña̱yivi, ñéhe na machítí xi̱hi̱n yíto̱ viti. Ta na̱ cán cúú ná na̱ na̱quixi cuéntá na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hi̱n cuéntá na̱ sa̱cua̱ha̱ veñu̱hu. ");
INSERT INTO mksNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ta mé Judas, da̱ ndiquia̱hva ñahá cán sa̱ na̱cando̱o da xi̱hín na̱ cán ña̱ tatí yúhu̱ dá sa̱jóho Jesús jáchi̱ na̱cachi da já xi̱hi̱n ná: —Ndá da̱ ná tatí yuhú u̱ sa̱jóho, da̱ cán cúú dá tiin ndó —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chí i̱vi̱ la̱á na̱cativi da nu̱ Jesús já na̱ca̱ha̱n Ndióxi̱ dá xi̱hi̱n á ta já na̱tatí yúhu̱ dá sa̱jóho mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Cama chá cajún ña̱, amigo. A̱nda̱ já na̱cayati na nu̱ Jesús ta na̱tiin tuun na a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Joo in táhan da̱ xíca tuun xi̱hín Jesús cán, na̱tavá da̱ machítí da̱ ta já na̱chitúhu̱n da̱ in jo̱ho da̱ cúú mozo nu̱ú da̱ sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Chica̱a̱n va̱ha machítí ja̱n jáchi̱ ndá na̱ sáhní xi̱hi̱n machítí, xi̱hi̱n machítí quivi ri na̱ cán va. ");
INSERT INTO mksNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Á co̱ cánda̱a̱ inún ña̱ cuu ca̱ca̱ ta̱hví i̱ nu̱ Ndióxi̱, tátá i̱ ña̱ ná chindahá mé á cua̱ha̱ ndiva̱ha táto̱ mé á ña̱ ná chindeé na̱ ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Cuu caja i̱ ña̱ joo xíní ñúhú ya̱ha tá ya̱ha ña̱ na̱ca̱hyi̱ nu̱ú tu̱hun Ndióxi̱ ndoho i̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ta já na̱cachi Jesús já xi̱hín na̱ na̱xi̱nu̱ tiin ñahá cán: —Cája ndó xi̱hín i̱ tátu̱hun cája na xi̱hín ta̱a cui̱hná jáchi̱ na̱queta ndó va̱xi ndó tiin ndó ye̱he̱ xi̱hín machítí ta xi̱hi̱n yíto̱ viti. Ta ndijáá níí qui̱vi̱ na̱sahi̱in i̱ xi̱hi̱n ndo̱ ini veñu̱hu cáhnu jána̱ha̱ i̱ tu̱hun Ndióxi̱ nu̱ ndo̱ ta ni in tañu co̱ó na̱tiin ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Joo tócó ndihi ña̱ yóho yáha ña̱ já ná xi̱nu̱ co̱o ña̱ na̱ca̱hyí na̱ profeta sa̱há i̱ ini tu̱hun Ndióxi̱ sa̱nahá —cáchí a̱. Tá na̱ndihi já na̱xinu ndihi na̱ xíca tuun xi̱hín Jesús cán cua̱ha̱n na̱ ta na̱jándacoo na mé á. ");
INSERT INTO mksNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tá na̱tiin na̱ cán Jesús já ñéhe na a̱ cua̱ha̱n na̱ nu̱ú Caifás, da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱. Ta cán sa̱ na̱nditútú na̱ jána̱ha̱ ley Moisés ndúu na xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu. ");
INSERT INTO mksNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Joo ndaja coo na̱sa̱ndi̱co̱ xícá Pedro Jesús a̱nda̱ quia̱hva na̱xi̱nu̱ da̱ yéhé vehe da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán. Ta já na̱ndi̱hvi da na̱saco̱o da nu̱ ndúu soldado cán sánde̱hé da̱ ndá quéa̱ caja na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ta na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hi̱n tócó ndihi na̱ cómí cuéntá sa̱há na̱ Israel na̱taca na cán ndúcú na̱ cua̱chi jácojo na ja̱tá Jesús já ná cuu cahní ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Joo co̱ó na̱ñe̱he̱ ná cua̱chi jíquí ña̱ cuu chinúu na ja̱ta̱ mé á va̱tí na̱xi̱nu̱ co̱o cua̱há na̱ na̱ca̱ha̱n ña̱ tu̱hún sa̱há. A̱nda̱ jáví na̱xi̱nu̱ co̱o i̱vi̱ ga̱ da̱ cáha̱n ña̱ tu̱hún sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Já na̱cachi da já: —Na̱xini jo̱ho nde̱ na̱cachi da̱ ja̱n já: “Jándita̱ni̱ i̱ veñu̱hu cáhnu cán ta jácandichi tucu u̱ ña̱ ti̱xi u̱ni̱ qui̱ví”, cáchí da̱ —na̱cachi na̱ cán chíca̱a̱n na̱ cua̱chi ja̱tá Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A̱nda̱ já na̱nda̱ca̱ ndichi da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán já cáchí da̱ já xi̱hín Jesús: —Á chí a̱ ndúcú ñehún tu̱hun nu̱ú nde̱ sa̱há cua̱chi jácojo na ja̱tu̱n —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Joo ni in tu̱hun co̱ó na̱nducú ñehe Jesús nu̱ dá. A̱nda̱ já na̱cachi da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán já xi̱hi̱n á: —Tavún qui̱vi̱ Ndióxi̱, ña̱ tácú íin indiví ta cachún xi̱hín nde̱ á jivi ndusa yóhó cúún Cristo, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱, da̱ na̱chindahá mé á cacomí cuéntá sa̱há ña̱yivi —na̱cachi da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já: —A̱ja̱n, jivi ye̱he̱ cúú u̱ da̱ cáchí ndó ja̱n. Ta viti ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ va̱xi quivi tá cuni ndó ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi caco̱o i̱ xoo cuáha Ndióxi̱, mé á íin cua̱ha̱ ndée̱. Ta já cuni ndó ye̱he̱ ndicó co̱o i̱ ñuyíví yóho tañu vi̱co̱ tá ná quixi i̱ chí indiví —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tá na̱xini jo̱ho da̱ sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán ña̱ yóho já na̱ndatá da̱ jáhma̱ dá ña̱ ná canda̱a̱ ini ña̱yivi ña̱ xójo̱ ini da. Ta já na̱cachi da já: —Ndája núu da̱ yóho Ndióxi̱. Co̱ó chicuu chága̱ yó ña̱yivi ná ca̱ha̱n na̱ xi̱hi̱n yo̱ jáchi̱ sa̱ na̱xini jo̱ho ndihí ña̱ na̱cana̱há da̱ yóho xi̱hi̱n Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ta ndaja xíní ndó caja í xi̱hi̱n dá viti —na̱cachi da. A̱nda̱ já na̱cachi ndihi na̱ cán já: —Íin cua̱chi da̱ ja̱n ta ndítahan cu̱hu̱n da̱ quivi da —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ta já na̱casáhá na̱ xíhnu ndaa na tóji̱í na̱ nu̱ á. Ta na̱casáhá túxú na̱ yi̱quí a̱. Ta java na cáni ja̱hndá nu̱u̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ta já cáchí na̱ já xi̱hi̱n á: —Ca̱ha̱n xi̱hín nde̱ yo na̱cani yo̱hó tá ta̱ mé a̱ nda̱a̱ cúún Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi —cáchí na̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ta ndaja coo íin coo Pedro yuhú yéhé da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán. Já na̱cativi in ñáñáha̱, ñá cája chúun mé vehe cán. Já na̱casáhá cáchí ña̱ já xi̱hi̱n dá: —Yóhó cúún in táhan da̱ xíca tuun xi̱hín Jesús, da̱ estado Galilea —na̱cachi ñá cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Joo ndaja coo na̱chije̱hé tu̱hun Pedro nu̱ ndíhi na̱ cán ña̱ xíni̱ da̱ Jesús. Já cáchí da̱ já: —Co̱ xíni̱ toho i̱ ndá sa̱ha̱ cáhu̱n —na̱cachi da xi̱hi̱n ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ta tá sa̱ na̱queta da yéhé cán já na̱xini inga ñáñáha̱ da̱ já na̱casáhá cáchí ña̱ já xi̱hi̱n tócó ndihi na̱ ndúu cán: —Na̱xini i̱ na̱xi̱ca tuun da̱ yóho xi̱hín Jesús, da̱ ñuu Nazaret cán —na̱cachi ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ta já na̱casáhá tucu Pedro chíje̱hé tu̱hun da ña̱ xíni̱ da̱ Jesús ta na̱tavá da̱ qui̱vi̱ Ndióxi̱ já cáchí da̱ já: —Co̱ xíni̱ toho i̱ ndá da̱ cúú da̱ ja̱n —na̱cachi Pedro xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chá va na̱ya̱ha ña̱ yóho ta na̱cayati java na̱ ndúu cán nu̱ Pedro. Já na̱cachi na já xi̱hi̱n dá: —Mé a̱ nda̱a̱ táhyí jivi táhan na̱ xíca tuun xi̱hín Jesús cúú ri yóhó va jáchi̱ cáhu̱n tátu̱hun cáha̱n na̱ cán —na̱cachi na xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","A̱nda̱ já na̱casáhá Pedro cána̱há da̱ ta na̱tavá da̱ qui̱vi̱ Ndióxi̱ ña̱ co̱ xíni̱ da̱ Jesús. Já cáchí da̱ já: —Co̱ xíni̱ toho i̱ ndá da̱ cúú da̱ ja̱n —na̱cachi da. Tá na̱cachi da já chí i̱vi̱ la̱á na̱cana chéle. ");
INSERT INTO mksNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","A̱nda̱ já na̱ndicu̱hu̱n ini Pedro ña̱ na̱ca̱ha̱n Jesús xi̱hi̱n dá tá na̱cachi a xi̱hi̱n dá: “Tá cáma̱ní cana chéle sa̱ chíje̱hé tu̱hún ña̱ xínu̱n ye̱he̱ u̱ni̱ tañu.” A̱nda̱ já na̱queta da ja̱ta̱ véhe ta a̱ ju̱ú quia̱hva sácu da jáchi̱ cácuéha̱ ndiva̱ha ini da. ");
INSERT INTO mksNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tá na̱ti̱vi inga qui̱ví ita̱a̱n já na̱ndique táhan ndihi na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu ña̱ nditúhún na̱ ndá quia̱hva jácojo na cua̱chi ja̱tá Jesús já ná cuu cahní ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sa̱há ña̱ cán quéa̱ na̱cató na̱ mé á ta ñéhe na a̱ cua̱ha̱n na̱ ndiquia̱hva na mé á nu̱ Pilato, da̱ cúú gobernador ñuu cán. ");
INSERT INTO mksNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ta ndaja coo na̱xini Judas, da̱ na̱ji̱có túhún Jesús ña̱ na̱sacu ini na̱ cán cahní na̱ Jesús. Já na̱cahvi ini da sa̱há ña̱ núu na̱caja da chí ndáva da cua̱ha̱n da̱ nducú ñehe da ndího̱co̱ u̱xu̱ jiu̱hu̱n cúxú nu̱ú na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín nu̱ú na̱ sa̱cua̱ha̱ veñu̱hu. ");
INSERT INTO mksNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Já na̱cachi da já xi̱hín na̱ cán: —Cua̱chi cáhnu ndiva̱ha quéa̱ na̱caja i̱ jáchi̱ na̱ji̱có túhún i̱ in da̱ co̱ó cua̱chi. Já na̱cachi na̱ cán já xi̱hi̱n dá: —Co̱ sáhní toho nde̱ mé nde̱ sa̱há ña̱ yóho. Mún xíni̱ ndá quéa̱ na̱cajún —na̱cachi na̱ cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A̱nda̱ já na̱cuihna Judas jiu̱hún cán ini veñu̱hu cáhnu. Ta já na̱queta da na̱sa̱ha̱n da̱ na̱cata caa da mé dá já na̱sahní da̱ mé dá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ta já na̱játaca na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ jiu̱hún cán já na̱cachi xi̱hi̱n táhan na já: —A̱ váha toho ña̱ ná chica̱a̱n yó jiu̱hún yóho ini sa̱to̱ nu̱ táán na̱ jiu̱hún jóco̱ na̱ nu̱ Ndióxi̱ jáchi̱ ndi̱i na̱xi̱hi̱ sa̱há ña̱ yóho —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ta tá sa̱ na̱nditúhún va̱ha xi̱hi̱n táhan na já na̱xeen na in ñúhu̱ xi̱hín jiu̱hún cán. Mé ñúhu̱ cán naní a̱ ñúhu̱ da̱ cáva̱ha ña̱ha xi̱hín ñundáhyi̱. Ta ñúhu̱ cán cacuu a nu̱ jándu̱xu̱ na̱ na̱ tóho̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sa̱há ña̱ cán quéa̱ na̱sacu na qui̱vi̱ ñúhu̱ cán ña̱ cananí a̱ yójo̱ nu̱ú na̱xi̱ta̱ ni̱i̱. Ta já naní a̱ ja̱nda̱ viti. ");
INSERT INTO mksNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ta xi̱hín ña̱ yóho na̱xi̱nu̱ co̱o nu̱ú ña̱ na̱ca̱hyí profeta Jeremías sa̱nahá tá na̱cachi da já sa̱há Jesús: “Na̱tiin na ndího̱co̱ u̱xu̱ jiu̱hu̱n cúxú jáchi̱ ña̱ ja̱n na̱sacuu ya̱hvi na̱sacu na̱ Israel cha̱hvi na sa̱ha̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ta xi̱hi̱n mé jiu̱hún cán na̱xeen na ñúhu̱ naní a̱ ñúhu̱ da̱ cáva̱ha ña̱ha xi̱hín ñundáhyi̱ jáchi̱ quia̱hva já na̱sahnda Ndióxi̱ chuun nu̱ú i̱ caja i̱”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ta ndaja coo cándichi Jesús nu̱ Pilato, da̱ cúú gobernador. Ta já na̱casáhá da̱ cán ndáca̱ tu̱hún ñahá da̱ já cáchí da̱ já xi̱hi̱n á: —Á mé a̱ nda̱a̱ cúún in rey, da̱ cómí cuéntá sa̱há na̱ Israel. —A̱ja̱n. Jivi ndusa cúú u̱ tá quia̱hva cáchí ndó ja̱n —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ta na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu na̱chica̱a̱n na̱ cua̱chi ja̱tá Jesús joo ni in tu̱hun co̱ó na̱nducú ñehe a nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","A̱nda̱ já na̱cachi Pilato já xi̱hín Jesús: —Á co̱ xíni̱ jo̱ho tohún ndaja cua̱há nu̱ú cua̱chi jácojo na ja̱tu̱n —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Joo ni in túhún tu̱hun co̱ó na̱nducú ñehe Jesús nu̱ dá. Chí cátóntó ndiva̱ha da̱ cúú gobernador sa̱há ña̱ co̱ cáha̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tañu mé víco̱ pascua na̱sahi̱in costumbre da̱ cúú gobernador cán sá ja̱ní da̱ in táhan da̱ ndáca̱a̱n veca̱a. Ndá da̱ cúni̱ ña̱yivi ja̱ní da̱, da̱ cán cúú da̱ jání da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mé tañu já na̱sandaca̱a̱n in da̱ naní Barrabás veca̱a. Níí cúú na̱xi̱ta nuu tu̱hun sa̱há da̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ta tá na̱taca ndihi ña̱yivi já na̱nda̱ca̱ tu̱hún Pilato na̱ já na̱cachi da já xi̱hi̱n ná: —Yo cúni̱ ndo̱ ña̱ ná janí i̱. Á Barrabás janí i̱ á Jesús, da̱ cáchí na̱ cúú Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. Yo janí i̱ cúni̱ ndo̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Na̱cachi Pilato ña̱ yóho xi̱hi̱n ná jáchi̱ sa̱ cánda̱a̱ va̱ha ini da ña̱ sa̱há ña̱ cáhi̱hvi̱ ini na xi̱hín Jesús sa̱há ña̱ cán quéa̱ na̱ndiquia̱hva na mé á nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ta nani íin coo da nu̱ sáco̱o da̱ sáhndá da̱ chuun vechúun cán já na̱chindahá ñájíhí da̱ tu̱hun nu̱ dá já na̱cachi ñá já: “A̱ quíhvi ndáhu̱n Jesús jáchi̱ cúú dá in ta̱a nda̱a̱. Ñuú a̱nda̱ véhe na̱sa̱ní i̱ na̱caja Jesús ta ndícani ndiva̱ha ini i̱ sa̱há”, na̱cachi ñá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Joo ndaja coo na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu cán na̱jáca̱ha̱n na̱ ña̱yivi ña̱ ná ca̱ca̱ na̱ nu̱ Pilato ña̱ ná janí da̱ Barrabás ta ná cahní da̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A̱nda̱ já na̱cachi da̱ cúú gobernador cán já xi̱hi̱n ná: —Yo cúni̱ ndó ña̱ ná janí i̱. A̱nda̱ já na̱cachi na̱ cán já: —Barrabás ja̱n va janí ndó —na̱cachi na xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A̱nda̱ já na̱cachi tucu Pilato já xi̱hi̱n ná: —Ndía̱ cúni̱ ndó caja i̱ xi̱hín Jesús, da̱ cáchí ndo̱ cúú Cristo. A̱nda̱ já na̱cachi tócó ndihi na̱ cán já: —Cata caa ndó da̱ ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A̱nda̱ já na̱cachi tucu Pilato já xi̱hi̱n ná: —Ndá cua̱chi na̱caja da, va̱ha —na̱cachi da xi̱hi̱n ná. Joo xi̱hín ña̱ yóho ví ga̱ ví na̱casáhá cáyuhú na̱ já cáchí na̱ já: —Cata caa ndó da̱ ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ta tá na̱xini Pilato ña̱ co̱ yáa̱ na̱ cán ta ví ga̱ ví ndíva̱a̱ na̱ já na̱tiin da ticui̱í ta na̱ndahá da̱ nu̱ ndíhi ña̱yivi cán ta já na̱cachi da já xi̱hi̱n ná: —Xi̱hín ña̱ yóho jána̱ha̱ i̱ nu̱ ndo̱ ña̱ co̱ó cua̱chi toho ndójo i̱ sa̱ha̱ ndá ña̱ ná caja ndó xi̱hín da̱ yóho jáchi̱ co̱ó cua̱chi toho da̱ yóho. Ja̱ta̱ mé ndó ná cu̱hu̱n ndihi va —na̱cachi da xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A̱nda̱ já na̱cachi tócó ndihi na̱ cán já: —Va̱ha ná candojo nde̱ cua̱chi ta ja̱nda̱ ja̱hyi nde̱ viti ná candojo na cua̱chi sa̱há ña̱ ná quivi da —na̱cachi na̱ cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A̱nda̱ já na̱janí Pilato Barrabás. Ta tá na̱ndihi na̱jácaxáhan na Jesús já na̱ndiquia̱hva da a̱ ndáha̱ ná ña̱ ná cata caa na a̱ ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","A̱nda̱ já ñéhe soldado cuéntá gobernador cán Jesús yuyéhé vechúun. Já na̱játaca soldado cán java ga̱ táhan da ta cán na̱ca̱va̱ toyi̱vi̱ da̱ mé á ndúu da. ");
INSERT INTO mksNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tá na̱ndihi já na̱tavá na̱ jáhma̱ á. A̱nda̱ já na̱chinúu na in jahmá cuáhá túu̱n ja̱tá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ta já na̱chinúu na in ti̱yi̱vi̱ íñu̱ ji̱ni̱ á. Ta na̱chiñee na in ndo̱o̱ ndahá cuáha. Ta já na̱casáhá na̱ cáxítí na̱ nu̱ á já sácu̱ ndaa i̱chi̱ ñahá na̱ já cáchí na̱ já xi̱hi̱n á: —Cáhnu na̱há ná cacuu yóhó, da̱ cúú rey nu̱ú na̱ Israel —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ta na̱casáhá xíhnu ndaa na tóji̱í na̱ nu̱u̱ á. Ta já cándaa na ndo̱o̱ cán ndáha̱ á ta cáni na yiquí jíní a̱ xi̱hi̱n do̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ta tá sa̱ na̱ndihi na̱sa̱cu̱ ndaa ñahá na̱ já na̱candaa na jáhma̱ na̱chinúu na ja̱tá cán ta na̱jácandixi tucu na a̱ xi̱hi̱n jáhma̱ mé á. A̱nda̱ já ñéhe na a̱ cua̱ha̱n na̱ cata caa na a̱ ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ta tá ñéhe na Jesús cua̱ha̱n na̱ cata caa na a̱ já na̱nditahan na in da̱ naní Simón, da̱ ñuu Cirene. Ta na̱caja ndúsa̱ na̱ xi̱hi̱n dá ña̱ ná ndicojo da crúxu̱ nu̱ú cata caa na Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ta na̱xi̱nu̱ co̱o na xi̱qui̱ naní Gólgota. Tu̱hun yóho cúni̱ cachi a: nu̱ ndúu lásá yiquí jíní ndi̱i. ");
INSERT INTO mksNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mé cán na̱sa̱ha̱n na̱ vino nu̱ á, dó na̱cava táhan xi̱hín ña̱ o̱va̱ ña̱ ná coho a do̱. Joo tá na̱xito ndojó a̱ do̱ co̱ó na̱xeen toho a coho a do̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ta tá sa̱ na̱ndihi na̱cata caa na a̱ ndi̱ca crúxu̱ já na̱quehe na jáhma̱ á na̱ndicahnda nu̱ táhan na. Joo jihna ñúhú na̱sajíquí na̱ sa̱há ta da̱ na̱quee va̱ha cán, da̱ cán na̱ndiquehe jáhma̱ á. Xi̱hín ña̱ yóho na̱xi̱nu̱ co̱o nu̱ú ña̱ na̱ca̱hyí profeta sa̱nahá tá na̱ca̱hyí da̱ já: “Na̱ndicahnda nu̱ táhan mé ná cotó níhnu i̱ ta já na̱sajíquí na̱ sa̱há cotó ma̱á i̱ ta da̱ na̱quee va̱ha cán na̱ndiquehe da ña̱”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ta já na̱saco̱o soldado cán ndúu na ndáá ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta ji̱ní ndi̱ca crúxu̱ cán na̱ca̱hyí na̱ ndá sa̱ha̱ na̱cata caa na a̱ já cáchí a̱ já: “Da̱ yóho cúú Jesús, da̱ cúú rey nu̱ú na̱ Israel.” ");
INSERT INTO mksNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ta sa̱ mé já na̱cata caa ri na i̱vi̱ ta̱a cui̱hná xi̱hín Jesús: in da xoo cuáha ta inga da xoo íti. ");
INSERT INTO mksNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chí cáva̱ ji̱ni̱ mé ña̱yivi yáha cán cána̱há na̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ta já cáchí na̱ já: —Yóhó cáchún jándita̱ni̱ veñu̱hu cáhnu cán ta ti̱xi u̱ni̱ víxí qui̱vi̱ cáchún jácandichi tucún ña̱. Tá ta̱ mé a̱ nda̱a̱ cúún ja̱hyi Ndióxi̱ jáca̱cu mún ta cuáhán nuu ndi̱ca crúxu̱ ja̱n —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ta quia̱hva já na̱caja ri na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu. Sácu̱ ndaa na̱ a̱ já cáchí na̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Na̱jáca̱cu da java ga̱ ña̱yivi ta viti chí a̱ cu̱ú caja da jáca̱cu da mé dá. Tá ta̱ mé a̱ nda̱a̱ cúú dá rey nu̱ú na̱ Israel, ná nuu da ndi̱ca crúxu̱ viti ñúhú já ná candúsa nde̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Cándeé ini da Ndióxi̱ ta cáchí da̱ cúú da̱ ja̱hyi Ndióxi̱ já quéa̱ ná quixi Ndióxi̱ chindeé a̱ da̱ tá ta̱ mé a̱ nda̱a̱ quíhvi̱ ini a da̱ —na̱cachi na̱ cán cána̱há na̱ xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Quia̱hva já cána̱há ri ndíví ta̱a cui̱hná tácaa in in xoo jíi̱n á cán xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tá na̱xi̱nu̱ co̱o caxi̱vi̱ nda̱a̱ na̱canaá níí cúú ñuyíví ta ja̱nda̱ ca̱a u̱ni̱ sa̱hini já na̱casáhá na̱ndiye̱he̱ tucu. ");
INSERT INTO mksNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ta sa̱ mé hora já na̱cayuhú cóhó Jesús já na̱cachi a já: —Elí, Elí, lama sabactani —ña̱ yóho cúni̱ cachi a: Ndióxi̱ mí i̱, Ndióxi̱ mí i̱, ndáva̱ha na̱jándacoo ndáha̱ ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ta java na̱ ndíta cán tá na̱xini jo̱ho na tu̱hun cáchí a̱ já na̱cachi na já: —Cána da profeta Elías —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","I̱vi̱ la̱á xínu in da na̱sa̱ha̱n da̱ na̱chindaxi da in ti̱co̱to̱ ini vino iyá. Ta na̱cató da̱ ña̱ nu̱ú in yitó ndo̱o̱ já na̱chiñee da do̱ yati yúhu̱ Jesús ña̱ ná coho a do̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Joo na̱ java ndíta cán na̱cachi na já xi̱hi̱n dá: —Cóho̱ cande̱hé yo̱ á quixi Elías jáca̱cu a da̱ —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A̱nda̱ já na̱cayuhú cóhó tucu Jesús já na̱xi̱hi̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ta ndaja coo na̱ndatá java nda̱a̱ jahmá ndeé ña̱ sájí nuu nu̱ú yi̱i̱ ndiva̱ha veñu̱hu cáhnu ñuu Jerusalén cán. Ja̱nda̱ ji̱ni̱ á ta ja̱nda̱ sa̱há na̱nda̱ta̱. Ta mé hora já na̱ta̱an ta ndijáá yu̱u̱ tóto̱ ndúu cán na̱nda̱ta̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ta na̱nu̱na̱ cáva̱ nu̱ na̱sa̱ñuhu na̱ na̱xi̱hi̱ ta cua̱há ña̱yivi, na̱ na̱sa̱cuu cuéntá Ndióxi̱ na̱nditacu tucu na. ");
INSERT INTO mksNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ta tá sa̱ na̱nditacu tucu Jesús já na̱xi̱nu̱ na̱ na̱queta cáva̱ cán ñuu Jerusalén ta cua̱há ndiva̱ha ña̱yivi na̱xini ñahá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ta da̱ cúú sa̱cua̱ha̱ nu̱ú soldado cuéntá Roma xi̱hi̱n da̱ ndáá Jesús xi̱hín da̱ cán tá na̱xini da ña̱ na̱ta̱an ta na̱xini da java ga̱ ña̱ na̱ya̱ha cán já na̱casáhá yíhví ndiva̱ha da. Já na̱cachi da já: —Mé a̱ nda̱a̱ táhyí cúú da̱ yóho in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ta mé cán na̱sa̱ndita cua̱há na̱ji̱hí sánde̱hé xícá na̱ Jesús. Mé na̱ cán cúú na̱ na̱caja ndíví ñahá nu̱ Jesús tá na̱ndi̱co̱ na̱ mé á na̱quixi na ja̱nda̱ estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tañu na̱ji̱hí cán na̱sa̱ndaca̱a̱n María, ñá ñuu Magdala xi̱hi̱n María, ñá cúú náná Jacobo xi̱hi̱n José. Ta cán na̱sa̱ndaca̱a̱n ri ñá cúú náná ndíví da̱ cúú ja̱hyi Zebedeo. ");
INSERT INTO mksNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ta ndaja coo na̱sahi̱in in da̱ cui̱cá naní José, da̱ ñuu Arimatea. Mé da̱ yóho na̱sa̱cuu da in táhan da̱ na̱sa̱xi̱ca tuun xi̱hín Jesús. Ta tá sa̱ na̱cuaá já na̱xi̱nu̱ da̱ ");
INSERT INTO mksNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","na̱sa̱ha̱n da̱ ca̱ha̱n nda̱hví da̱ xi̱hi̱n Pilato ña̱ ná ndiquia̱hva da yiquí cu̱ñu Jesús nu̱ dá. A̱nda̱ já na̱sahnda Pilato chuun ña̱ ná ndiquia̱hva na ña̱ nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ta já na̱chitiví José cán yiquí cu̱ñu Jesús xi̱hín in jáhma̱ va̱ha ña̱ vií. ");
INSERT INTO mksNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ta já na̱chica̱a̱n da̱ yiquí cu̱ñu Jesús ini in yávi̱ ña̱ sa̱á ndáca̱a̱n ndi̱ca cáva̱ ña̱ ja̱cá na̱caán da̱ cuéntá mé dá. Ta tá na̱ndihi já na̱chija̱hví da̱ yuhú cáva̱ cán xi̱hín in yu̱u̱ jáhndá cáhnu ta já na̱quee da cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ta nu̱ yéhé mé cáva̱ cán na̱sa̱nduu coo María, ñá ñuu Magdala xi̱hín inga ñá naní María cán. ");
INSERT INTO mksNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ta ndaja coo sa̱ na̱ndihi na̱caja ndíví na̱ ña̱ha cuéntá qui̱vi̱ ndíquehe ndée̱ na̱. Ta inga qui̱ví ita̱a̱n na̱játaca táhan na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ fariseo já na̱sa̱ha̱n na̱ nu̱ Pilato. ");
INSERT INTO mksNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Já na̱cachi na já xi̱hi̱n dá: —Va̱xi nde̱ nu̱ ndo̱ ca̱ca̱ loho nde̱ ña̱ma̱ni̱ nu̱ ndó. Jáchi̱ ndícu̱hu̱n ini nde̱ ña̱ tá na̱sa̱tacu Jesús, da̱ na̱xi̱ca jándahvi ña̱yivi cán na̱cachi da ña̱ tá sa̱ ná ya̱ha u̱ni̱ qui̱vi̱ já nditacu tucu da. ");
INSERT INTO mksNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ña̱ cúni̱ nde̱ quéa̱ ná chindahá loho ndó na̱ cu̱hu̱n candaa nu̱ú na̱chica̱a̱n na̱ yiquí cu̱ñu da̱ cán ja̱nda̱ quia̱hva ná ya̱ha u̱ni̱ qui̱vi̱. Jáchi̱ tia̱hva náá xi̱nu̱ co̱o na̱ na̱xi̱ca tuun xi̱hi̱n dá ñuú ta caja cuíhná na̱ yiquí cu̱ñu da. Ta já casáhá cachi na xi̱hín ña̱yivi ñuu ña̱ na̱nditacu tucu Jesús tañu na̱ na̱xi̱hi̱. Ta xi̱hín ña̱ yóho jándahvi chága̱ na̱ ña̱yivi a̱ ju̱ú ga̱ jihna —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","A̱nda̱ já na̱cachi Pilato já: —Cañehe ndó in táhndá soldado. Cuáhán ndó candaa ndó nu̱ ndáca̱a̱n da̱ tá quia̱hva xíni̱ mé ndó caja ndó —cáchí Pilato xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","A̱nda̱ já na̱quee na̱ cán na̱sa̱ha̱n na̱ já na̱chicají va̱ha chága̱ na̱ nu̱ ndáca̱a̱n yiquí cu̱ñu Jesús cán. Ta na̱sacu na sello yu̱u̱ jáhndá cán ta já na̱sacu na soldado ña̱ ná candaa da ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tá sa̱ na̱ya̱ha qui̱vi̱ ndíquehe ndée̱ ná ta na̱ti̱vi inga qui̱ví ita̱a̱n já na̱xi̱nu̱ María, ñá ñuu Magdala xi̱hín inga María cán sánde̱hé na̱ nu̱ú na̱chica̱a̱n na̱ yiquí cu̱ñu Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","In naá cuití na̱ta̱an ndeé ndiva̱ha. Na̱ya̱ha ña̱ yóho jáchi̱ na̱nuu in táto̱ Ndióxi̱ indiví. Ta na̱játiví a̱ yu̱u̱ jáhndá na̱saja̱hvi nu̱ú na̱sa̱ndaca̱a̱n yiquí cu̱ñu Jesús cán. Ta já na̱saco̱o a ja̱tá. ");
INSERT INTO mksNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ta yéhe̱ mé táto̱ Ndióxi̱ cán tá quia̱hva yéhe̱ tasa. Ta jáhma̱ ndíxi a cúú á jahmá yaa ca̱chi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ta a̱ ju̱ú quia̱hva ná yi̱hví soldado ndúu cán na̱caja táto̱ Ndióxi̱ chí na̱casáhá quíji ni̱nu da. Ta já na̱cu̱yu da nu̱ ñúhu̱ tátu̱hun ndi̱i na̱xi̱hi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Joo ndaja coo táto̱ Ndióxi̱ cán na̱ndica̱ha̱n xi̱hín na̱ji̱hí cán já na̱cachi a já xi̱hi̱n ná: —A̱ cáyi̱hví toho ndó. Sa̱ xíni̱ va̱ha i̱ ña̱ ndínducú ndo̱ Jesús, ña̱ na̱cata caa na ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Co̱ó toho a̱ cán íin yóho jáchi̱ sa̱ na̱nditacu tucu a tá quia̱hva na̱cachi mé á xi̱hi̱n ndo̱. Naha ndó cande̱hé ndo̱ nu̱ú na̱sahi̱in a já cuni ndó ña̱ co̱ó ga̱ íin nu̱ú na̱sacu na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ta cama ndó cu̱hu̱n ndó ca̱xi tu̱hun ndó xi̱hín da̱ na̱xi̱ca tuun xi̱hi̱n á ña̱ sa̱ na̱nditacu tucu Jesús tañu na̱ sa̱ na̱xi̱hi̱. Ta viti cánu̱ú mé á cua̱ha̱n estado Galilea. Ta tá cu̱hu̱n ndó cán já cuni ndó a̱. Ta ndicu̱hun ini ndó ña̱ na̱cachi i̱ xi̱hi̱n ndo̱ —na̱cachi táto̱ Ndióxi̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","A̱nda̱ já na̱quee mé na̱ji̱hí cán mé nu̱ú na̱sa̱ndaca̱a̱n yiquí cu̱ñu Jesús. Ta va̱tí yíhví na̱ joo cávatá ndiva̱ha na ta sa̱há ña̱ cán quéa̱ xínu na cua̱ha̱n na̱ ca̱xi tu̱hun na ña̱ yóho nu̱ú na̱ na̱xi̱ca tuun xi̱hín Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ta nani cua̱ha̱n na̱ i̱vi̱ la̱á sa̱ íin va Jesús xi̱hi̱n ná. Já na̱cachi a já xi̱hi̱n ná: —Ndióxi̱ ná coo xi̱hi̱n ndo̱. A̱nda̱ já na̱cayati na̱ cán nu̱ á já na̱numi na sa̱há ta na̱caja cáhnu na a̱. ");
INSERT INTO mksNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A̱nda̱ já na̱cachi tucu Jesús já xi̱hi̱n ná: —A̱ cáyi̱hví toho ndó. Cuáhán ndo̱ ca̱xi tu̱hun ndó xi̱hín na̱ cúú cuéntá mí i̱ ña̱ ná cu̱hu̱n na̱ estado Galilea jáchi̱ cán cuni na ye̱he̱ —na̱cachi Jesús xi̱hín na̱ji̱hí cán. ");
INSERT INTO mksNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ta nani xínu na̱ji̱hí cán cua̱ha̱n na̱ já ndáva java soldado, da̱ na̱sa̱ndaa nu̱ú na̱sa̱ndaca̱a̱n Jesús cán na̱xi̱nu̱ da̱ ñuu Jerusalén já na̱ca̱xi tu̱hun da ña̱ na̱cuu nu̱ú na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱. ");
INSERT INTO mksNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A̱nda̱ já na̱játaca táhan na̱ sa̱cua̱ha̱ cán xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu já na̱jándique táhan na tu̱hun na ta já na̱sa̱ha̱n cua̱há ndiva̱ha na jiu̱hún nu̱ú na̱ soldado cán. ");
INSERT INTO mksNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Já na̱cachi na já xi̱hín soldado cán: —Coto a̱ cáha̱n ndó ña̱ na̱nditacu Jesús. Ña̱ cachi ndó cúú ña̱ yóho: “Na̱ na̱xi̱ca tuun xi̱hi̱n á cán, na̱ cán cúú na̱ na̱quixi ñuú ta na̱caja cuíhná na̱ yiquí cu̱ñu a nani na̱qui̱ji̱ nde̱”, já cachi ndó xi̱hi̱n ndá na̱ ná nda̱ca̱ tu̱hún ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ta a̱ cáyi̱hví toho ndó tá ná canda̱a̱ ini da̱ cúú gobernador sa̱há ña̱ yóho jáchi̱ ca̱ha̱n mé nde̱ xi̱hi̱n dá ta chindeé nde̱ ndo̱hó ña̱ ná a̱ cája da ni in ña̱ha xi̱hi̱n ndo̱ —na̱cachi na̱ sa̱cua̱ha̱ cán xi̱hi̱n soldado. ");
INSERT INTO mksNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A̱nda̱ já na̱quehe da̱ cúú soldado cán jiu̱hún ta na̱caja da tá quia̱hva na̱sahnda na̱ sa̱cua̱ha̱ cán chuun nu̱ dá. Ta xi̱hín ña̱ yóho na̱ndicui̱ta nuu tu̱hun sa̱há ña̱ na̱ya̱ha cán. Ta cáha̱n na̱ Israel cán sa̱há ña̱ yóho ja̱nda̱ qui̱vi̱ víti. ");
INSERT INTO mksNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Joo ndíhu̱xu̱ in na̱ na̱xi̱ca tuun xi̱hín Jesús cán na̱sa̱ha̱n na̱ chí Galilea. Já na̱ndaa na in ji̱ni̱ yúcu̱ tá quia̱hva na̱sahnda mé Jesús chuun nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ta tá na̱xini na mé á já na̱caja cáhnu na a̱. Joo java na cáhvi i̱vi̱ joho ini na jáchi̱ co̱ cándúsa na ña̱ na̱nditacu tucu a. ");
INSERT INTO mksNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","A̱nda̱ já na̱cayati Jesús nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Na̱sa̱ha̱n Ndióxi̱ ndée̱ nu̱ú i̱ caja i̱ ña̱ náhnu ndiva̱ha indiví xi̱hín ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sa̱há ña̱ cán quéa̱ cuáhán ndo̱ jána̱ha̱ ndo̱ nu̱ú ña̱yivi ndúu ndijáá ñuyíví ndaja caja na caca va̱ha na íchi̱ cuéntá mí i̱. Ta caja ndúta̱ ndó na̱ xi̱hín qui̱vi̱ Ndióxi̱, tátá i̱ ta xi̱hín qui̱ví ye̱he̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi mé á ta xi̱hín qui̱vi̱ ínima̱ yi̱i̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ta jána̱ha̱ ndó na̱ ña̱ ná caja na tócó ndihi ña̱ na̱sahnda i̱ nu̱ ndó caja ndó. Ta mé a̱ nda̱a̱ coo i̱ xi̱hi̱n ndo̱ ndijáá níí qui̱vi̱ ja̱nda̱ quia̱hva ná xi̱nu̱ co̱o qui̱vi̱ ndihi sa̱ha̱ ñuyíví. Já ná coo —na̱cachi Jesús.");
INSERT INTO mksNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Quia̱hva jo̱ho na̱ca̱va̱ sáhá tu̱hun va̱ha cáha̱n sa̱ha̱ Jesucristo, mé a̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sa̱nahá na̱ca̱hyí profeta Isaías ña̱ na̱ca̱ha̱n Ndióxi̱ xi̱hín ja̱hyi a. Já cáchí a̱ já: Chindahá i̱ in da̱ canu̱ú cu̱hu̱n nu̱ mún, ña̱ ná ca̱xi tu̱hun da nu̱ú ña̱yivi sa̱ha̱ yóhó ta já ndaja ndacú da̱ íchi̱ nu̱ú ya̱hún. ");
INSERT INTO mksNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ta ca̱ha̱n cóhó da̱ tañu yucú íchí ta cachi da já xi̱hín ña̱yivi: “Caja tia̱hva ndó íchi̱ nu̱ú quixi xitoho í ta cuná ndó in íchi̱ nda̱cú nu̱ mé á ña̱ ná ndi̱hvi a ínima̱ ndo̱”, na̱ca̱hyí Isaías. ");
INSERT INTO mksNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ta ndaja coo íin Juan yucú íchí ta na̱casáhá cája ndúta̱ dá ña̱yivi. Ta cáxi tu̱hun da xi̱hi̱n ná ña̱ tá cúni̱ na̱ caja cáhnu ini Ndióxi̱ sa̱há cua̱chi na já ndítahan nu̱ ná ndicó co̱o ini na ta já candúta̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Chí na̱quixi cua̱há ndiva̱ha ña̱yivi estado Judea xi̱hín ñuu Jerusalén taa jo̱ho na nu̱ cáha̱n da̱ ta tá náhma̱ na̱ cua̱chi na já na̱caja ndúta̱ dá na̱ ini yu̱ta Jordán. ");
INSERT INTO mksNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ta na̱sa̱ndixi mé Juan yóho jáhma̱ ña̱ na̱cava̱ha na xi̱hi̱n íji̱ camello ta na̱sa̱ndi̱co̱ in níi̱ jáhndá tóco̱ dá. Ta na̱xixi da ti̱ca xi̱hín ñu̱ñu̱ yúcú. ");
INSERT INTO mksNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tá cáxi tu̱hun da nu̱ú ña̱yivi já cáchí da̱ já: —Ja̱tá ye̱he̱ va̱xi in da̱ íin cua̱ha̱ chága̱ ndée̱ dá a̱ ju̱ú ga̱ ye̱he̱ chí co̱ó sa̱há i̱ ndi̱ca̱ xítí i̱ nu̱ dá ña̱ ndaxí i̱ correa ndu̱sa̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ye̱he̱ na̱jácandúta̱ i̱ ndo̱hó xi̱hín ticui̱í joo mé da̱ cán cúú da̱ jándicutú ínima̱ ndó xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱ —na̱cachi Juan xi̱hín ná. ");
INSERT INTO mksNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mé tiempo já na̱quee Jesús ñuu Nazaret ña̱ ndáca̱a̱n estado Galilea. Na̱xi̱nu̱ a̱ nu̱ íin Juan ta na̱jácandúta̱ Juan Jesús ini yu̱ta Jordán cán. ");
INSERT INTO mksNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ta tá na̱quee Jesús ticui̱í cán já na̱xini a na̱ndinu̱na̱ indiví ta na̱nuu ínima̱ yi̱i̱ Ndióxi̱ ja̱ta̱ mé á. Ta cáa ínima̱ yi̱i̱ Ndióxi̱ yóho tá quia̱hva cáa in ndija̱ta. ");
INSERT INTO mksNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ta na̱xini jo̱ho na cáha̱n in a indiví ta já cáchí a̱ já: —Yóhó cúún ja̱hyi máni̱ i̱ ta cáji̱i̱ ndiva̱ha ini i̱ xu̱hu̱n. ");
INSERT INTO mksNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","I̱vi̱ la̱á na̱sa̱ha̱n ínima̱ yi̱i̱ Ndióxi̱ ndáca Jesús yucú íchí nu̱ co̱ó ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ta cán na̱sahi̱in a i̱vi̱ jico qui̱vi̱ ta mé tiñáhá sa̱cua̱ha̱ na̱xito ndojó rí a̱. Ta cán ndúu quití quini joo na̱xi̱nu̱ java táto̱ Ndióxi̱ chindeé na̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tá na̱ndihi na̱chica̱a̱n na̱ Juan veca̱a já na̱sa̱ha̱n Jesús estado Galilea ca̱xi tu̱hun a nu̱ú ña̱yivi tu̱hun va̱ha sa̱ha̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Já cáchí a̱ já xi̱hi̱n ná: —Sa̱ na̱xi̱nu̱ tiempo viti ta na̱cayati qui̱vi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi. Ña̱ ndítahan nu̱ ndo̱ quéa̱ jándacoo ndó cua̱chi cája ndó ta candúsa ndó tu̱hun va̱ha ña̱ cuu jáca̱cu ndo̱hó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","In tañu xíca Jesús cua̱ha̱n yati yu̱hú tañu̱hú Galilea. Ta na̱xini a in da naní Simón xi̱hín Andrés, da̱ cúú ñani. Ndíví mé da̱ yóho cúú dá da̱ tává ti̱yacá ta ñúhu da jácana da ñúnu̱ dá ini tañu̱hú. ");
INSERT INTO mksNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na̱casáhá cáchí Jesús já xi̱hi̱n dá: —Naha quíi̱ ndó candi̱co̱ ndó ye̱he̱ caca tuun ndó xi̱hín i̱. Tává ndó ti̱yacá viti joo caja i̱ ña̱ ná cuu tavá ndó ña̱yivi tañu cua̱chi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ta chí i̱vi̱ la̱á na̱jándacoo da ñúnu̱ dá ta na̱ndi̱co̱ da̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A̱nda̱ já na̱xi̱ca loho ga̱ Jesús chí nu̱u̱ já na̱xini a Jacobo xi̱hín ñani da Juan, da̱ cúú ja̱hyi Zebedeo. Ndíví da̱ yóho ñúhu da ini barco ndája va̱ha da ñúnu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na̱cana Jesús ndíví da̱ yóho ta chí na̱jándacoo da tátá da̱, Zebedeo cán ini barco xi̱hín java ga̱ da̱ cája chúun xi̱hi̱n dá ta já na̱casáhá xíca tuun da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na̱xi̱nu̱ co̱o Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á ñuu Capernaum. Ta tá na̱tandaa qui̱vi̱ ndíquehe ndée̱ ña̱yivi já na̱qui̱hvi Jesús ini veñu̱hu ta na̱casáhá jána̱ha̱ na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ta na̱catóntó tócó ndihi ña̱yivi sa̱há tu̱hun cáha̱n mé á jáchi̱ na̱jána̱ha̱ mé á tátu̱hun in da̱ íin sa̱ha̱ cahnda chuun ta co̱ cáha̱n tátu̱hun na̱ jána̱ha̱ ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ini mé veñu̱hu cán na̱sa̱ndaca̱a̱n in da̱ta̱a, da̱ ndáca̱a̱n ínima̱ quini ini. Na̱casáhá cáyuhú rí cán já cáchí ri̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús, da̱ ñuu Nazaret. Ndá cuéntá quéa̱ quíhvi nuún xi̱hín nde̱. Á va̱sún jándihún sa̱há nde̱. Sa̱ xíni̱ va̱ha i̱ yo̱hó ta cánda̱a̱ cáxí ini i̱ ña̱ cúún in da̱ yi̱i̱ na̱chindahá Ndióxi̱ —na̱cachi rí cán. ");
INSERT INTO mksNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ta na̱casáhá Jesús jána̱ni a rí quini ndáca̱a̱n ini da̱ cán. Já na̱cachi a já: —Caji yúhu̱n ta janí da̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ta tá quéta rí quini ndáca̱a̱n ini da̱ cán na̱sahní yi̱hí rí da̱ ta cáyuhú cóhó ri̱ já na̱queta rí ini da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na̱catóntó tócó ndihi ña̱yivi chí na̱casáhá ndáca̱ tu̱hún táhan na já cáchí na̱ já: —Ndía̱ quéa̱ yóho. Ta ndá na̱quixi tu̱hun sa̱á jána̱ha̱ da̱ yóho jáchi̱ cáha̱n da̱ xi̱hi̱n rí quini tátu̱hun in da̱ sáhndá chuun ta chí cándúsa rí quee rí cu̱hu̱n ri̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ta chí cama chá na̱ndicui̱ta nuu tu̱hun sa̱ha̱ Jesús níí cúú estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tá na̱quee na veñu̱hu já cua̱ha̱n Jesús xi̱hín Jacobo xi̱hín Juan vehe Simón xi̱hín ñani da, Andrés. ");
INSERT INTO mksNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ta ndaja coo cándúhu̱ ñá cúú xo̱jo Simón nu̱ú xi̱to na̱chica̱a̱n cáhni̱ ndeé ña̱. Ta tá na̱xi̱nu̱ co̱o na̱ cán já na̱ca̱xi tu̱hun na nu̱ú Jesús ña̱ quíhvi̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A̱nda̱ já na̱cayati Jesús nu̱ ña̱ ta na̱tiin a ndáha̱ ña̱ já na̱ndiñehe a ña̱ chí i̱vi̱ la̱á na̱ndindaa cáhni̱ á ña̱. A̱nda̱ já na̱casáhá cája ndíví ña̱ ña̱ cuxu na. ");
INSERT INTO mksNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tá na̱que̱ta nuu ca̱ndii ta na̱cuaá já ñéhe ndihi ña̱yivi na̱ quíhvi̱ xi̱hín na̱ ñúhu ínima̱ quini ini na̱casa̱a̱ na̱ nu̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ta tócó ndihi na̱ ñuu na̱ndai cuu na yuyéhé nu̱ íin Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na̱ndaja va̱ha Jesús cuahá ña̱yivi, na̱ ndóho tá nu̱ú cue̱he̱. Ta na̱tavá a̱ cua̱há ínima̱ quini ini ña̱yivi. Joo co̱ó na̱sa̱ha̱n Jesús ña̱ma̱ni̱ nu̱ rí quini ña̱ ná ca̱ha̱n rí jáchi̱ xíni̱ rí yo cúú Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta naha inga qui̱ví ita̱a̱n tá cáma̱ní yi̱í ti̱vi na̱ndaco̱o Jesús ta na̱quee a ñuu cua̱ha̱n nu̱ú co̱ó ña̱yivi ña̱ ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tá na̱ndaco̱o Simón xi̱hín java ga̱ da̱ xíca tuun xi̱hi̱n Jesús já na̱xini na ña̱ co̱ó a̱ íin chí na̱quee na cua̱ha̱n na̱ ndinducú na̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ta tá na̱ndiñehe ñahá na̱ já cáchí na̱ já xi̱hi̱n á: —Tócó ndihi ña̱yivi ndínducú na̱ ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Joo cáchí Jesús já xi̱hi̱n ná: —Cóho̱ java ga̱ ñuu yati yóho ña̱ ná jána̱ha̱ i̱ tu̱hun va̱ha nu̱ú na̱ cán viti jáchi̱ sa̱há ña̱ yóho va̱xi i̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ta chí na̱xi̱ca nuu Jesús níí cúú estado Galilea cáha̱n tu̱hun va̱ha ini veñu̱hu in in ñuu cán ta tává a̱ ínima̱ quini ndáca̱a̱n ini ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ta ndaja coo na̱cayati in da̱ta̱a ndóho cue̱he̱ táhyi̱ nu̱ú Jesús ta na̱caxítí da̱ nu̱ á já na̱casáhá cáchí da̱ já: —Cuu ndaja va̱ha ndó ye̱he̱ tá cúni̱ ndó —cáchí da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ta na̱ta̱hvi̱ ini Jesús sa̱ha̱ dá. A̱nda̱ já na̱cani ndaa ndáha̱ á da̱. Já cáchí a̱ já: —Cúni̱ ña̱ ná ndiva̱hún ña̱ cán quéa̱ na̱ndiva̱hún viti —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tá na̱cachi a já chí i̱vi̱ la̱á na̱ndindaa cue̱he̱ táhyi̱ ña̱ na̱ndoho da̱ cán. Já na̱ndivií yiquí cu̱ñu da. ");
INSERT INTO mksNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tá na̱ndihi na̱jándinda̱yí Jesús da̱ ta na̱sahnda chuun nu̱ dá já cáchí a̱ já xi̱hi̱n dá: ");
INSERT INTO mksNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Cande̱hé. A̱ cáhu̱n xi̱hín ni in túhún toho ña̱yivi ña̱ na̱caja i̱ xu̱hu̱n. Cuáhán nda̱cún na̱hu̱n mún nu̱ú ju̱tu̱. Ta ndítahan jo̱cún ña̱ha nu̱ Ndióxi̱ tátu̱hun na̱sahnda ley Moisés sa̱nahá caja na̱ sa̱ na̱ndiva̱ha. Já ná canda̱a̱ ini tócó ndihi ña̱yivi ña̱ sa̱ na̱ndindaa va cue̱he̱ na̱sandohún —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Joo tá na̱quee da cua̱ha̱n da̱ na̱casáhá da̱ ndícani da nu̱ú ndihi ña̱yivi ña̱ na̱ndaja va̱ha Jesús da̱ sa̱há ña̱ cán quéa̱ co̱ó na̱cuu ga̱ ndi̱hvi tívi Jesús ni in ñuu. Ja̱tá ñuu nu̱ú co̱ ndúu ña̱yivi na̱sahi̱in a ta ja̱nda̱ mé cán xínu̱ co̱o ña̱yivi, na̱ quíxi nu̱ú ndijáá ñuu xíto nihni na mé á. ");
INSERT INTO mksNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tá na̱ya̱ha chá qui̱vi̱ já na̱ndicó co̱o tucu Jesús ñuu Capernaum. Ta na̱canda̱a̱ ini ña̱yivi ña̱ íin a vehe. ");
INSERT INTO mksNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta chí cama chá na̱nditútú cua̱há ña̱yivi chí co̱ váti̱ ga̱ yuyéhé cándita na. Já na̱casáhá cáxi tu̱hun Jesús tu̱hun Ndióxi̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","A̱nda̱ já na̱xi̱nu̱ co̱o co̱mí ta̱a ta ñéhe da in da̱ na̱xi̱hi̱ tu̱chu sa̱ha̱. Na̱sa̱a̱ da̱ nu̱ íin Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Joo na̱xini da ña̱ a̱ cu̱ú xi̱nu̱ da̱ yati nu̱ íin Jesús sa̱há cua̱há ña̱yivi chútú nda̱a̱ nu̱ íin a cán. Chí na̱ndaa da ji̱ni̱ véhe ta na̱casáhá da̱ súná da̱ ji̱ni̱ véhe mé xoo nu̱ íin Jesús. Ta mé cán na̱jánuu da xi̱to loho nu̱ cándúhu̱ da̱ quíhvi̱ chí yávi̱ ji̱ni̱ véhe cán. ");
INSERT INTO mksNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tá na̱xini Jesús ña̱ cándeé ini da̱ cán mé á já cáchí a̱ já xi̱hi̱n mé da̱ quíhvi̱ cán: —Cande̱hé, ja̱hyi a. Sa̱ na̱caja cáhnu ini i̱ sa̱há cua̱chún viti —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Joo java na̱ jána̱ha̱ ley Moisés ndúu coo cán na̱casáhá cáhán na̱: ");
INSERT INTO mksNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ndá cuéntá quéa̱ ndája núu da Ndióxi̱ xi̱hín tu̱hun cáha̱n da̱. Jáchi̱ ni in túhún toho ña̱yivi a̱ cu̱ú caja cáhnu ini sa̱há cua̱chi. In túhún ji̱ni̱ Ndióxi̱ quéa̱ cuu caja cáhnu ini sa̱há cua̱chi”, na̱ca̱hán na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Joo sa̱ na̱canda̱a̱ ini Jesús ña̱ cáhvi ini na̱ cán chí na̱cachi a já xi̱hi̱n ná: —Ndáva̱ha cáhán ndo̱ já. ");
INSERT INTO mksNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Á cáhán ndó ña̱ i̱hvi̱ chága̱ cachi i̱ xi̱hín da̱ yóho: “Na̱caja cáhnu ini i̱ sa̱ha̱ cua̱chún viti.” Á tá co̱ó ta cachi i̱ xi̱hi̱n dá: “Cuándaco̱o, ndiquehe xi̱tún ta caca nuún.” ");
INSERT INTO mksNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Cande̱hé va̱ha ndó ná na̱ha̱ i̱ nu̱ ndo̱ ña̱ íin sa̱há i̱, da̱ na̱chindahá Ndióxi̱ nduu u̱ ña̱yivi caja cáhnu ini i̱ sa̱há cua̱chi cája ña̱yivi ñuyíví yóho —na̱cachi Jesús xi̱hi̱n ná. A̱nda̱ já na̱cachi a xi̱hi̱n mé da̱ na̱xi̱hi̱ tu̱chu sa̱ha̱ cán: ");
INSERT INTO mksNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ta viti cáha̱n i̱ xu̱hu̱n cuándaco̱o ndiquehe xi̱to lohún ta cuanúhu̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chí i̱vi̱ la̱á na̱ndaco̱o mé da̱ quíhvi̱ cán ta na̱ndiquehe da xi̱to loho da já na̱quee da cua̱ha̱n da̱ nu̱ú ndihi na̱ ndúu cán. A̱nda̱ já na̱catóntó tócó ndihi na ta na̱casáhá cája cáhnu na Ndióxi̱ já cáchí na̱ já: —Ni in túhún tañu co̱ó na̱xini nde̱ in ña̱ha cáhnu tátu̱hun ña̱ yóho —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tá na̱ndihi já na̱sa̱ha̱n tucu Jesús yuhú tañu̱hú cán ta tá na̱cayati cua̱há ña̱yivi nu̱ á já na̱casáhá jána̱ha̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nani xíca Jesús cua̱ha̱n na̱ya̱ha nu̱ íin in da̱ naní Leví, ja̱hyi Alfeo. Ta íin coo da nu̱ sáco̱o da̱ játaca jiu̱hún cuéntá impuesto. Ta cáchí a̱ já xi̱hi̱n dá: —Naha quíi̱ candi̱cu̱n ye̱he̱. A̱nda̱ já na̱nda̱ca̱ ndichi Leví ta na̱ndi̱co̱ da̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tá na̱ndihi na̱sa̱ha̱n Jesús vehe Leví ta na̱sa̱co̱o a xíxi a xi̱hín cua̱há da̱ játaca jiu̱hún cuéntá impuesto xi̱hín java ga̱ na̱ cája cua̱chi. Ta sa̱ mé cán na̱sa̱nduu ri java da̱ xíca tuun xi̱hi̱n Jesús xíxi da tañu na̱ cán jáchi̱ cua̱há ña̱yivi ndíco̱ na̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Joo na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo tá na̱xini na íin coo Jesús xíxi a xi̱hín na̱ cán na̱casáhá cáchí na̱ já xi̱hín da̱ xíca tuun xi̱hín Jesús: —Ndá cuéntá quéa̱ xíxi xitoho ndó xi̱hín na̱ játaca jiu̱hún cuéntá impuesto ta xi̱hín java ga̱ na̱ cája cua̱chi —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tá na̱xini jo̱ho Jesús ña̱ yóho na̱casáhá cáchí a̱ já: —Ña̱yivi íin va̱ha co̱ xíní ñúhú toho na da̱ cája tátá ñahá joo na̱ quíhvi̱, na̱ cán cúú na̱ xíní ñúhú da̱ cája tátá ñahá. Ta ye̱he̱ co̱ó va̱xi toho i̱ cana i̱ na̱ sa̱ íin va̱ha. Va̱xi i̱ cana i̱ ña̱yivi, na̱ cája cua̱chi ña̱ ná jándacoo na cua̱chi cája na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","In tañu tá xíjuhun na̱ xíca xi̱hi̱n Juan xi̱hín na̱ xíca xi̱hín na̱ fariseo na̱xi̱nu̱ co̱o java ña̱yivi nu̱ Jesús ta na̱casáhá ndáca̱ tu̱hún na̱ mé á já cáchí na̱ já: —Ndáva̱ha co̱ xíjuhun toho na̱ xíca tuun xi̱hi̱n yóhó joo xíjuhun mé nde̱, na̱ xíca xi̱hi̱n Juan xi̱hi̱n na̱ xíca xi̱hín na̱ fariseo —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ta na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já: —Á cáhán ndo̱ xíjuhun na̱ ndúu víco̱ tánda̱ha̱ nani íin mé da̱ tánda̱ha̱ cán xi̱hi̱n ná. U̱hu̱n. Jáchi̱ cáji̱i̱ íní na̱ nani íin mé da̱ tánda̱ha̱ xi̱hi̱n ná. Chí a̱ cu̱ú toho cajuhun na. ");
INSERT INTO mksNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Joo xi̱nu̱ qui̱vi̱ candaa na mé da̱ tánda̱ha̱ ta a̱nda̱ jáví casáhá cajuhun na. Ta cáchí i̱ xi̱hi̱n ndó ña̱ va̱xi qui̱vi̱ candaa na ye̱he̱ nu̱ú na̱ yóho ta a̱nda̱ jáví casáhá na̱ xíca tuun xi̱hín i̱ cajuhun na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ta na̱sacu Jesús inga quia̱hva nu̱ ná já cáchí a̱ já: —Ama ná jándaha ña̱yivi jahmá yatá xi̱hín in túhu̱n jáhma̱ sa̱á jáchi̱ tá na̱ndihi ndíndií a̱, sáhndá chága̱ ví a̱ jahmá yatá cán ta jándacáhnu chága̱ ví a̱ yávi̱ ña̱ na̱ndicahmá na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ta ni co̱ táán na̱ vino sa̱á ini vóso̱ níi̱ yatá jáchi̱ jáca̱hndi̱ mé vino cán níi̱ ta cui̱ta̱ mé vino cán ta tíví vóso̱ níi̱ caja dó sa̱há ña̱ cán quéa̱ ndítahan taán na̱ vino sa̱á ini vóso̱ nií sa̱á —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","In qui̱vi̱ ndíquehe ndée̱ ña̱yivi nani xíca Jesús cua̱ha̱n tañu nu̱ú na̱xutu na trigo xi̱hín na̱ xíca tuun xi̱hi̱n á já na̱casáhá túhun na yu̱cu̱ ji̱ni̱ trigo. ");
INSERT INTO mksNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tá na̱xini na̱ fariseo ña̱ cája na já na̱cachi na já xi̱hín Jesús: —Cande̱hé. Ndáva̱ha cája na̱ xíca tuun xu̱hu̱n chuun ña̱ co̱ ndítahan caja na qui̱vi̱ ndíquehe ndée̱ yo̱ —na̱cachi na̱ fariseo. ");
INSERT INTO mksNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Á a̱ ñáha cahvi ndó nu̱ú tu̱hun Ndióxi̱ nu̱ cáha̱n sa̱há ña̱ na̱caja David sa̱nahá tá na̱cuico mé dá xi̱hín na̱ xíca xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ña̱ na̱caja David quéa̱ na̱qui̱hvi da veñu̱hu Ndióxi̱ tá na̱sa̱cuu Abiatar da̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱. Já na̱xixi da pan yi̱i̱ ña̱ in túhún ju̱tu̱ cúú da̱ ndítahan nu̱ú cuxu ña̱ cán, nduu. Joo na̱xixi David ña̱ ta na̱sa̱ha̱n da̱ ña̱ nu̱ú java ga̱ na̱ xíca xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ta na̱cachi tucu Jesús já xi̱hi̱n ná: —Cande̱hé ndo̱. Co̱ó na̱cava̱ha Ndióxi̱ ña̱yivi ndoho ini na sa̱há qui̱vi̱ ndíquehe ndée̱ ná jáchi̱ na̱sacu ini a cava̱ha in qui̱vi̱ já ná cuu ndíquehe ndée̱ ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ña̱ cán quéa̱ ye̱he̱ va, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi íin sa̱há i̱ cahnda i̱ chuun sa̱há qui̱vi̱ ndíquehe ndée̱ ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na̱qui̱hvi tucu Jesús ini veñu̱hu ta cán na̱sa̱ndaca̱a̱n in da̱ta̱a, da̱ na̱hi̱chi̱ ndáha̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ta na̱casáhá nání na̱ fariseo Jesús sánde̱hé na̱ á ndaja va̱ha mé á da̱ cán qui̱vi̱ ndíquehe ndée̱ ná já ná cuu chica̱a̱n na̱ cua̱chi ja̱tá. ");
INSERT INTO mksNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A̱nda̱ já cáchí Jesús xi̱hín da̱ na̱hi̱chi̱ ndáha̱ cán já: —Cuándaco̱o ta candichi ma̱hñú yóho —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A̱nda̱ já na̱nda̱ca̱ tu̱hún a̱ na̱ java cán já cáchí a̱ já xi̱hi̱n ná: —Ndía cáchí ley ndítahan caja í mé qui̱vi̱ ndíquehe ndée̱ ña̱yivi. Á chindeé yó ña̱yivi á caja í ña̱ núu xi̱hi̱n ná. Á jáca̱cú na̱ á cahní yó na̱ —na̱cachi Jesús. Joo ni in túhún tu̱hun co̱ó na̱ca̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na̱casáhá xójo ini Jesús sánde̱hé a̱ nu̱ ná. Joo táhvi̱ tucu ini a sa̱ha̱ ná jáchi̱ cúú ná ña̱yivi sáá ini. Ta cáchí a̱ xi̱hi̱n mé da̱ta̱a, da̱ na̱hi̱chi̱ ndáha̱ cán: —Jándaca̱a̱ ndáhu̱n. Tá na̱jándaca̱a̱ da̱ ndáha̱ dá i̱vi̱ la̱á na̱ndiva̱ha ndáha̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tá na̱ndihi na̱quee na̱ fariseo veñu̱hu já na̱casáhá na̱ jándique táhan na tu̱hun na xi̱hín na̱ cuéntá Herodes ña̱ cahní na̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Joo na̱sa̱ha̱n Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á yuhú tañu̱hú ta cua̱há ndiva̱ha ña̱yivi estado Galilea na̱ndi̱co̱ na̱ na̱sa̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tá na̱canda̱a̱ ini ña̱yivi ña̱ náhnu cája Jesús, na̱quixi cua̱há na̱ estado Judea xi̱hín na̱ ñuu Jerusalén xi̱hín na̱ ñundáhyi̱ Idumea xi̱hín na̱ inga xoo yu̱ta Jordán xi̱hín java na̱ ndúu ñuu válí jíi̱n ñuu Tiro xi̱hín Sidón jáchi̱ cande̱hé na̱ Jesús cúni̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sa̱há ña̱ yóho quéa̱ na̱xi̱ca̱ Jesús ña̱ma̱ni̱ nu̱ú na̱ xíca tuun xi̱hi̱n á ña̱ ná cacu tia̱hva na in barco nu̱ú ndaca̱a̱n mé á ña̱ ná a̱ cándíhi ña̱yivi cua̱ha̱ cán ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jáchi̱ cua̱há ndiva̱ha ña̱yivi na̱ndaja va̱ha mé á. Sa̱há ña̱ cán quéa̱ tócó ndihi na̱ quíhvi̱ cáti na ja̱tá ña̱ cani ndaa ndáha̱ ná mé á cúni̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ta tá na̱xini na̱ ñúhu ínima̱ quini ini cán Jesús i̱vi̱ la̱á ndícava xítí na̱ nu̱ á ta cásáhá cáyuhú cóhó na̱ já cáchí rí quini ndáca̱a̱n ini na̱ cán já: —Yóhó cúún da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Joo jána̱ni Jesús rí cán já sáhndá a̱ chuun nu̱ ri̱ ña̱ ná a̱ cáxi tu̱hun rí yo cúú mé á. ");
INSERT INTO mksNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tá na̱ndihi já na̱quee xóo Jesús na̱sa̱ha̱n in xi̱qui̱ ta tá na̱ndihi na̱cana mé á java na̱ xíca xi̱hi̱n á cán, mé na̱ cúni̱ a̱ ca̱xi a ta na̱xi̱nu̱ na̱ cán nu̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ta tañu na̱ cán na̱ndica̱xi Jesús u̱xu̱ i̱vi̱ da̱ caca tuun xi̱hi̱n á ta tá na̱ndihi já na̱chindahá mé á da̱ cu̱hu̱n da̱ ca̱ha̱n da̱ tu̱hun Ndióxi̱ xi̱hín ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ta na̱caja mé á ña̱ cuu ndaja va̱ha da na̱ quíhvi̱ ta cuu cahnda da chuun nu̱ rí quini ña̱ ná quee rí ini ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ña̱ yóho cúú qui̱ví u̱xu̱ i̱vi̱ da̱ na̱ndica̱xi Jesús caca tuun xi̱hi̱n á: Simón, da̱ na̱sacu tucu a qui̱vi̱ cananí Pedro ");
INSERT INTO mksNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","xi̱hi̱n Jacobo xi̱hín ñani da, da̱ naní Juan, ja̱hyi Zebedeo. Ndíví da̱ yóho na̱sacu a qui̱vi̱ cananí Boanerges ta mé tu̱hun yóho cúni̱ cachi a cúú dá tátu̱hun ja̱hyi in tasa ña̱ cána indiví. ");
INSERT INTO mksNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Na̱ca̱xi a Andrés xi̱hi̱n Felipe xi̱hi̱n Bartolomé xi̱hi̱n Mateo xi̱hi̱n Tomás xi̱hi̱n Jacobo, da̱ cúú ja̱hyi Alfeo xi̱hi̱n Tadeo xi̱hi̱n Simón, da̱ na̱xi̱ca cuéntá na̱ cananista ");
INSERT INTO mksNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","xi̱hi̱n Judas Iscariote, mé da̱ na̱ji̱có túhún Jesús tá nu̱ ndíhí. A̱nda̱ já na̱qui̱hvi Jesús ini in vehe xi̱hín na̱ xíca tuun xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ta inga tucu na̱chutú cua̱há ña̱yivi nu̱ íin a ja̱nda̱ a̱ cu̱ú cuxu a xi̱hín na̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ta tá na̱ñe̱hé na̱ vehe Jesús tu̱hun sa̱há ña̱ yóho i̱vi̱ la̱á na̱quixi na ña̱ cañehe na mé á cu̱hu̱n a̱ cúni̱ na̱ jáchi̱ na̱cata̱chi̱ Jesús cáhán na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jári na̱ jána̱ha̱ ley Moisés, na̱ na̱quixi Jerusalén na̱casáhá cáha̱n na̱ já cáchí na̱ já: —Ta̱a yóho ndáca̱a̱n Beelzebú ini da, rí cúú sa̱cua̱ha̱ nu̱ rí quini. Ta xi̱hi̱n ndée̱ mé rí cán tává da̱ rí quini ini ña̱yivi —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","A̱nda̱ já na̱cana Jesús ña̱yivi já na̱sacu a in quia̱hva nu̱ ná ja cáchí a̱ já xi̱hi̱n ná: —A̱ cu̱ú tavá tiñáhá sa̱cua̱ha̱ mé rí. ");
INSERT INTO mksNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jáchi̱ tá sáhndá java táhan na ndúu in ñuu ta cáni táhan ndaja táhan mé va na já quéa̱ a̱ ñéhe̱ íní na̱ coo nahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ta tá cásáhá sáhndá java táhan na̱ ndúu in vehe ta cáni táhan na já a̱ cu̱ú ga̱ canduu nahá na̱ mé vehe cán. ");
INSERT INTO mksNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ta quia̱hva já tá ná casáhá rí quini ndúu ndáha̱ tiñáhá sa̱cua̱ha̱ cáni táhan rí xi̱hi̱n mé va rí ja̱nda̱ quia̱hva sáhndá java táhan rí já quéa̱ a̱ cu̱ú canduu nahá ri̱ jáchi̱ ndihi sa̱ha̱ ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ʼSácú u̱ inga quia̱hva nu̱ ndo̱. Ni in da̱ta̱a a̱ cu̱ú ndi̱hvi da caja cuíhná da̱ ña̱ha vehe in da̱ ndacú cán joo tá ná cató da̱ da̱ ndacú já cuu quehe da ña̱ha da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ʼMé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Ndióxi̱ cuu caja cáhnu ini a sa̱ha̱ tá nu̱ú cua̱chi cája ña̱yivi xi̱hín sa̱ha̱ tá nu̱ú tu̱hun quini cáha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Joo tá ná ca̱ha̱n núu na sa̱ha̱ ínima̱ yi̱i̱ Ndióxi̱ já quéa̱ a̱ cája cáhnu ini Ndióxi̱ sa̱há ña̱ na̱caja na ta a̱nda̱ ama cáa qui̱vi̱ candojo na cua̱chi sa̱há —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Na̱cachi a ña̱ yóho̱ xi̱hín na̱ cán jáchi̱ cáchí na̱ ña̱ ndáca̱a̱n ínima̱ quini ini a. ");
INSERT INTO mksNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tá na̱ndihi na̱xi̱nu̱ náná Jesús xi̱hín ñani a nu̱ íin a joo na̱cando̱o na ja̱ta̱ véhe. Ta na̱chindahá na̱ in na na̱sa̱ha̱n na̱cana ñahá. ");
INSERT INTO mksNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ta na̱ ndúu coo xi̱hi̱n Jesús cáchí na̱ já xi̱hi̱n á: —Ja̱ta̱ véhe cáa íin nánún xi̱hín ñanún ta ndínducú na̱ yo̱hó —cáchí na̱ xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ yo já cúú tátu̱hun náná i̱ xi̱hín ñani i̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A̱nda̱ já na̱sande̱hé a̱ nu̱ú na̱ ndúu coo ti̱yi̱vi̱ xi̱hi̱n á cán já cáchí a̱ já xi̱hi̱n ná: —Na̱ yóho cúú ná tátu̱hun náná i̱ xi̱hi̱n ñani i̱. ");
INSERT INTO mksNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Jáchi̱ ndá na̱ cája ña̱ cúni̱ Ndióxi̱, na̱ cán cúú ná tátu̱hun ñani i̱ xi̱hín quia̱hvá i̱ xi̱hi̱n náná i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na̱casáhá tucu Jesús jána̱ha̱ ña̱yivi yuhú tañu̱hú ta na̱taca cua̱há ña̱yivi nu̱ íin a̱ cán. A̱ ju̱ú quia̱hva cua̱ha̱ cúú ná sa̱há ña̱ cán quéa̱ na̱qui̱hvi Jesús ini in barco, dó cándichi yuhú tañu̱hú cán. Ta na̱saco̱o a cán ta tócó ndihi ña̱yivi na̱nda̱ca̱ ndita na nu̱ú ñu̱tí yuhú tañu̱hú cán. ");
INSERT INTO mksNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Já na̱jána̱ha̱ cua̱há ña̱ha nu̱ú na̱ cán ta na̱sacu a quia̱hva nu̱ ná já cáchí a̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Cuni jo̱ho ndó ña̱ yóho: In da̱ sátá tata na̱quee da cua̱ha̱n da̱ cata da ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ta tá sátá da̱ ña̱ cua̱ha̱n da̱ na̱cu̱yu java ña̱ íchi̱ ta na̱xi̱nu̱ laa ta na̱saxí rí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ta java ña̱ na̱cu̱yu a tañu yu̱u̱ nu̱ú co̱ó cua̱ha̱ ñúhu̱. Ta cama chá na̱ndu̱ta̱ mé tata cán jáchi̱ co̱ cúná ñúhu̱ nu̱ú na̱cu̱yu a. ");
INSERT INTO mksNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Joo tá na̱queta ca̱ndii já na̱jáhi̱chi̱ a̱ ña̱ sa̱há ña̱ co̱ó cua̱ha̱ yóho̱ a̱ chí na̱ndihi sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ta java tata na̱cu̱yu a tañu tohíñú ta tá na̱sahnu tohíñú cán já na̱nditáha̱ ndihi a na̱caja tohíñú chí co̱ó na̱sa̱ha̱n mé tata cán ndá ña̱ha jáquee na nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ta java tata na̱cu̱yu a nu̱ú ñuhú va̱ha. Na̱ndu̱ta̱ mé tata cán ta na̱sahnu a já na̱sa̱ha̱n cua̱há ña̱ha ña̱ jáquee na nu̱ á. Java ña̱ na̱sa̱ha̱n o̱co̱ u̱xu̱ a̱ nu̱ú in in tata ta java ña̱ na̱sa̱ha̱n u̱ni̱ jico u̱xu̱ a̱ ta java ña̱ in ciento a̱ nu̱ú in in tata. ");
INSERT INTO mksNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","A̱nda̱ já na̱cachi tucu Jesús já xi̱hi̱n ná: —Na̱ íin jo̱ho, ná cuni jo̱ho na —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tá na̱cando̱o Jesús xi̱hi̱n mé na̱ u̱xu̱ i̱vi̱ xíca tuun xi̱hi̱n á cán xi̱hín java ga̱ na̱ ndíco̱ ñahá cán já na̱casáhá ndáca̱ tu̱hún na̱ Jesús ña̱ ndía̱ cúni̱ cachi a xi̱hín quia̱hva na̱sacu a nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta cáchí a̱ já xi̱hi̱n ná: —Ña̱ co̱ó na̱canda̱a̱ ini ndó jihna ña̱ cán cánda̱a̱ ini ndó a̱ viti jáchi̱ na̱suná Ndióxi̱ xíní túni̱ ndo̱ cánda̱a̱ ini ndó ndá quia̱hva cacomí mé á cuéntá sa̱há ña̱yivi. Joo na̱ a̱ ñáha cacomí Ndióxi̱ cuéntá sa̱ha̱, na̱ cán cúú na̱ sácú u̱ quia̱hva nu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Já quéa̱ va̱tí sánde̱hé na̱ joo cúú ná tátu̱hun na̱ co̱ tívi nu̱u̱ ta va̱tí xíni̱ jo̱ho na joo cúú ná tátu̱hun na̱ jóho̱ jáchi̱ co̱ cánda̱a̱ ini na ña̱ cáha̱n i̱ xi̱hi̱n ná. Ta sa̱há ña̱ cán quéa̱ co̱ ndícó co̱o na nu̱ Ndióxi̱ ta ni mé á co̱ cája cáhnu ini sa̱há cua̱chi na. ");
INSERT INTO mksNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ta já cáchí tucu a já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Ta tá co̱ cánda̱a̱ ini ndó quia̱hva, ña̱ na̱sacu u̱ yóho ndaja caja ndó canda̱a̱ ini ndó java ga̱ quia̱hva ña̱ cachi i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mé da̱ sátá tata cán cúú dá tátu̱hun da̱ xíca cáha̱n tu̱hun Ndióxi̱ xi̱hín ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Java ga̱ ña̱yivi cúú ná tátu̱hun tata ña̱ na̱cu̱yu íchi̱. Táa jo̱ho na tu̱hun Ndióxi̱ ta tá na̱ndihi na̱xini jo̱ho na ña̱ já va̱xi tiñáhá sa̱cua̱ha̱ ta cája rí xi̱hi̱n ná ña̱ ndíndójó na̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ta java ña̱yivi cúú ná tátu̱hun tata ña̱ na̱cu̱yu tañu yu̱u̱ jáchi̱ táa jo̱ho na tu̱hun Ndióxi̱ ta cáji̱i̱ ini na ndíquehe na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ta tá quia̱hva ndiává yu̱cu̱ sa̱há ña̱ co̱ ñúhu cúná yóho̱ a̱ quia̱hva já ndóho ña̱yivi tá casáhá ndicui̱ta ña̱yivi cája xíxi na xi̱hi̱n ná. Ta tá cásáhá ndóho ini na sa̱há tu̱hun Ndióxi̱ ña̱ na̱xini jo̱ho na̱ cán chí i̱vi̱ la̱á jándacoo va na ña̱ cándeé ini na Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ta java na cúú ná tátu̱hun tata ña̱ na̱cu̱yu tañu tohíñú jáchi̱ táa jo̱ho na tu̱hun Ndióxi̱ ");
INSERT INTO mksNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","joo ndícani ndiva̱ha ini na sa̱há ña̱ha ñuyíví yóho. Cátóó ndiva̱ha na ña̱ha cuícá chí jándahvi na mé ná xi̱hín ña̱ cán ta xíca̱ ini na coo tócó ndihi ña̱ha nu̱ ná. Ta cáva nuu táhan ña̱ha ñuyíví yóho xi̱hín tu̱hun Ndióxi̱ ini ínima̱ ná sa̱há ña̱ cán quéa̱ cávitá ini na ta co̱ sáhnu na xi̱hín tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Joo ndúu java na̱ xíni̱ jo̱ho tu̱hun Ndióxi̱ ta cándúsa na ña̱. Ta cája chúun va̱ha na xi̱hi̱n á ta já cuahnu na xi̱hi̱n á. Cúú ná tátu̱hun tata na̱cu̱yu nu̱ ñuhú va̱ha. Java na cúú ná tátu̱hun tata ña̱ na̱sa̱ha̱n o̱co̱ u̱xu̱ a̱ nu̱ú in in a. Ta java na cúú ná tátu̱hun ña̱ na̱sa̱ha̱n u̱ni̱ jico u̱xu̱ a̱ ta java na cúú ná tátu̱hun ña̱ na̱sa̱ha̱n in ciento a̱ nu̱ú in in tata —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ta cáchí tucu Jesús xi̱hi̱n ná: —Co̱ó toho chuun lámpara tá chíca̱a̱n í ña̱ ti̱xi sa̱to̱ á ti̱xi xi̱to jáchi̱ chuun ña̱ quéa̱ cánúu ña̱ nu̱ jícó já ná jándiye̱he̱ ña̱ nu̱ yo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ni in túhún toho ña̱ha a̱ cu̱ú coo je̱hé jáchi̱ xi̱nu̱ qui̱vi̱ já ndáca náha̱ nu̱ á. Ta ni in tu̱hun na̱ca̱ha̱n je̱hé ña̱yivi a̱ cu̱ú coo je̱hé nahá jáchi̱ xi̱nu̱ qui̱vi̱ já canda̱a̱ ini tócó ndihi ña̱yivi sa̱há tu̱hun na̱sahi̱in je̱hé cán. ");
INSERT INTO mksNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na̱ íin jo̱ho, ná cuni jo̱ho na —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ta cáchí tucu a já xi̱hi̱n ná: —Cande̱hé va̱ha ndó ña̱ taa jo̱ho ndó. Tá quia̱hva cája ndó xi̱hín ña̱yivi quia̱hva já caja Ndióxi̱ xi̱hi̱n ndo̱ joo chága̱ ví caja mé á xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jáchi̱ da̱ sa̱ íin ña̱ha nu̱u̱, ñe̱he̱ táhvi̱ dá coo chága̱ ña̱ha nu̱ dá joo da̱ co̱ó ña̱ha nu̱u̱, ja̱nda̱ ña̱ chá íin nu̱ dá ndindaa —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ta cáchí tucu Jesús já: —Tá ndíquia̱hva ña̱yivi mé ná ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná já cúú á tátu̱hun in da̱ta̱a na̱chihin tata. ");
INSERT INTO mksNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tá na̱ndihi yáha qui̱vi̱ ta quíji̱ da̱ ta ndáco̱o da já yáha qui̱vi̱ xi̱hín ñuú. Ta já ndúta̱ mé tata cán ta sáhnu a joo mé da̱ na̱chihin a cán co̱ xíni̱ da̱ ndaja sáhnu a. ");
INSERT INTO mksNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sáhnu a jáchi̱ chuun nu̱ mé ñúhu̱ quéa̱ caja ña̱ ná cuahnu ña̱ cán. Jihna ñúhú ndúta̱ mé yu̱cu̱ trigo já cana yóco̱ a̱ ta nu̱ mé yóco̱ a̱ cán ndícutú nda̱a̱ ndíqui̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ta tá na̱chi̱chi mé ndíqui̱ a̱ cán já quée na cua̱ha̱n na̱ jáquee na ña̱ jáchi̱ na̱xi̱nu̱ co̱o qui̱vi̱ jáquee na ña̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ta cáchí tucu Jesús já: —Viti sácú u̱ inga quia̱hva nu̱ ndo̱ já ná cánda̱a̱ ini ndó ndá quia̱hva caja Ndióxi̱ xi̱hín ña̱yivi tá casáhá a̱ cómí a̱ cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Cúú á tátu̱hun in ndíqui̱ mostaza ña̱ chíhin na nu̱ú ñundáhyi̱. Cúú á ndíqui̱ loho chága̱ nu̱ tócó ndihi ndíqui̱ válí íin ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Joo tá na̱ndihi na̱chihin na a̱ na̱sahnu a ta na̱nduu a in yíto̱, dó cáhnu nu̱ ndíhi yíto̱. Ta xi̱hi̱n ndahá náhnu dó sácú do̱ cáti̱ ta ja̱nda̱ laa ndíquehe ndée̱ ri̱ nu̱ cáti̱ do̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na̱jána̱ha̱ Jesús tu̱hun Ndióxi̱ nu̱ ná. Ta na̱sacu cua̱há quia̱hva nu̱ ná tátu̱hun ña̱ yóho ja̱nda̱ quia̱hva xínu̱ nu̱ mé ná cánda̱a̱ ini na. ");
INSERT INTO mksNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Xi̱hi̱n mé quia̱hva cuití va na̱jána̱ha̱ Jesús nu̱ú ña̱yivi joo tá na̱cando̱o Jesús xi̱hi̱n mé na̱ xíca tuun xi̱hi̱n á já ndícani cáxí ndihi a ña̱ha nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tá na̱cuaá mé qui̱vi̱ cán já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Cóho̱ inga xoo tañu̱hú yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A̱nda̱ já na̱jándacoo na ña̱yivi já na̱quee na cua̱ha̱n na̱ xi̱hín Jesús ini mé barco nu̱ú sa̱ ndáca̱a̱n mé á. Ta ndáca táhan java ga̱ barco cua̱ha̱n dó xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ta ndaja coo na̱xi̱nu̱ in ta̱chi̱ quíni ndiva̱ha. Ta na̱casáhá ndíco̱jo̱ tañu̱hú ndíhvi dó ini barco já na̱casáhá ndícutú ticui̱í ini mé barco cán. ");
INSERT INTO mksNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ta chí xoo ja̱ta̱ mé barco cán cándúhu̱ Jesús quíji̱ a̱ ta cánúu ji̱ni̱ á ja̱tá ña̱ yíhi ji̱ni̱ ná. Já na̱jándacáxí ini na mé á ta cáchí na̱ já xi̱hi̱n á: —Maestro. Chí co̱ sáhní a̱ mé á ña̱ cúni̱ ndihi sa̱ha̱ yo̱ jáchi̱ sáco̱o barco ca̱há ticui̱í cua̱ha̱n do̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","A̱nda̱ já na̱ndaco̱o Jesús ta na̱casáhá jána̱ni a ta̱chi̱ xi̱hín tañu̱hú viti já cáchí a̱ já: —Catáji̱ ndo̱. Já na̱jáya̱a̱ ta̱chi̱. Já na̱cando̱o táji̱ níí mé cán. ");
INSERT INTO mksNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A̱nda̱ já na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á: —Ndáva̱ha na̱yi̱hví na̱há ndo̱. Ndáva̱ha co̱ cándeé ini ndó ye̱he̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A̱ ju̱ú quia̱hva na̱yi̱hví mé na̱ cán já na̱casáhá cáha̱n xi̱hi̱n táhan na: —Ndá da̱ cúú da̱ta̱a yóho ña̱ ja̱nda̱ ta̱chi̱ xi̱hín tañu̱hú cándúsa nu̱ cáha̱n da̱ —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A̱nda̱ já na̱xi̱nu̱ na̱ inga xoo mé tañu̱hú cán nu̱ íin ñundáhyi̱ cuéntá Gadara. ");
INSERT INTO mksNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ta tá na̱nuu Jesús barco cán já na̱quee in da̱ta̱a camasanto já na̱xi̱nu̱ da̱ nu̱ú Jesús. Mé da̱ yóho cúú dá da̱ ndáca̱a̱n ínima̱ quini ini. ");
INSERT INTO mksNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ta íin va da nu̱ ndúxu̱ ndi̱i ta ni in na a̱ cu̱ú cató na̱ da̱ ni xi̱hi̱n cadena a̱ cu̱ú cató na̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Va̱tí cua̱há tañu sa̱ na̱cató na̱ sa̱ha̱ dá xi̱hi̱n ndáha̱ dá joo sáhndá da̱ cadena ta jácuachi da ña̱ ta ni in na a̱ cu̱ú caja xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ñuú ta ndiví xíca nuu da yúcu̱ xi̱hín nu̱ ndúxu̱ ndi̱i cáyuhú da̱ xíca nuu da ta jándicue̱he̱ da̱ mé dá xi̱hín yu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Joo tá na̱xini xícá da̱ Jesús, ni̱hi chá na̱sa̱ha̱n da̱ na̱xi̱nu̱ da̱ nu̱ íin a já na̱ndicava xítí da̱ nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ta cáyuhú cóhó da̱ já cáchí da̱ já xi̱hi̱n á: —Ndá cuéntá quéa̱ va̱sún qui̱hvi nuún xi̱hín i̱. Yóhó cúún Jesús, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱, ña̱ cáhnu ndiva̱ha. Xíca̱ ta̱hví i̱ nu̱u̱n ña̱ ná a̱ jándohún ini i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Na̱cachi da ña̱ yóho xi̱hi̱n Jesús jáchi̱ na̱casáhá sáhndá mé á chuun nu̱ rí quini cán já cáchí a̱ já: —Ínima̱ quini, janí da̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús mé rí quini cán já cáchí a̱ já: —Ndaja nanún. A̱nda̱ já na̱nducú ñehe da̱ cán tu̱hun nu̱ á já na̱cachi da já xi̱hi̱n á: —Legión naní nde̱ jáchi̱ cua̱ha̱ cúú nde̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ndáhví mé xíca̱ ta̱hví da̱ cán nu̱ Jesús ña̱ ná a̱ tává xícá a̱ rí quini cu̱hu̱n ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ta ndaja coo xíca nuu cua̱ha̱ cóchí xíxáhan rí yati yúcu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sa̱há ña̱ cán quéa̱ na̱xi̱ca̱ ta̱hví mé ínima̱ quini cán nu̱ Jesús já cáchí ri̱ já: —Chindahá nde̱he̱ ná cu̱hu̱n nde̱ ndi̱hvi nde̱ cóchí cáa. ");
INSERT INTO mksNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A̱nda̱ já na̱sa̱ha̱n Jesús ña̱ma̱ni̱ ta chí na̱quee ínima̱ quini na̱sa̱ñuhu ini da̱ cán já na̱ndi̱hvi rí ini cóchí xíca nuu cán. Ta tócó ndihi cóchí yóho xínu rí cua̱ha̱n rí na̱nuu rí nu̱ ndáyi já na̱jáque̱ta nuu rí mé rí ini tañu̱hú chí na̱candaa rí ticui̱í já na̱xi̱hi̱ rí. Tátu̱hun i̱vi̱ mil cóchí na̱ndihi sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ta ndaja coo mé da̱ ndáá cóchí cán na̱yi̱hví da̱ chí xínu da cua̱ha̱n da̱ ca̱xi tu̱hun da ña̱ na̱ya̱ha yóho nu̱ú ña̱yivi ñuu Gadara xi̱hín nu̱ú java ga̱ na̱ ndúu yati cán. Na̱quee cua̱há ña̱yivi mé cán cande̱hé na̱ ña̱ na̱cuu. ");
INSERT INTO mksNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tá na̱xi̱nu̱ co̱o na nu̱ íin Jesús na̱xini na íin coo da̱ na̱sa̱ñuhu cua̱ha̱ rí quini ini cán. Sa̱ na̱nda̱ca̱ ndixi da jáhma̱ ta sa̱ na̱ndicáxí táhyí ini da. Chí na̱yi̱hví na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ta na̱ na̱xini ña̱ na̱caja Jesús cán na̱casáhá na̱ ndícani na nu̱ú ña̱yivi ña̱ na̱ndoho da̱ta̱a, da̱ na̱sa̱ñuhu rí quini ini cán xi̱hín ña̱ na̱ndoho cóchí viti. ");
INSERT INTO mksNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","A̱nda̱ já na̱casáhá na̱ xíca̱ ta̱hví na̱ nu̱ Jesús ña̱ ná quee a cu̱hu̱n a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tá sa̱ cua̱ha̱n ndíhvi Jesús ini mé barco cán já na̱xi̱nu̱ da̱ na̱sa̱ñuhu rí quini ini cán já na̱casáhá da̱ xíca̱ ta̱hví da̱ nu̱ á ña̱ ná quia̱hva ña̱ma̱ni̱ nu̱ dá cu̱hu̱n da̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Joo co̱ó na̱sa̱ha̱n Jesús ña̱ma̱ni̱ nu̱ dá já na̱cachi a xi̱hi̱n dá: —Cuanúhu̱ vehún ta ndicani nu̱ú na̱ vehún ndaja náhnu ña̱ha na̱caja Ndióxi̱ xu̱hu̱n ta ndaja na̱ta̱hvi̱ ini a sa̱hu̱n —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Já na̱quee da cua̱ha̱n da̱ ta na̱casáhá da̱ ndícani da nu̱ú ña̱yivi ndúu java ñuu cuéntá Decápolis tócó ndihi ña̱ na̱caja Jesús xi̱hi̱n dá. Chí cátóntó na̱ táa jo̱ho na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tá na̱ndihi na̱ndi̱hvi Jesús ini mé barco cán já na̱xi̱nu̱ co̱o a inga xoo tañu̱hú nu̱ú na̱quixi a. Ta cán na̱nditútú cua̱há ña̱yivi nu̱ á mé yuhú tañu̱hú cán. ");
INSERT INTO mksNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Já na̱xi̱nu̱ in da̱ naní Jairo, da̱ sáhndá chuun veñu̱hu. Tá na̱xini da Jesús na̱caxítí da̱ sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ta ndáhví mé na̱xi̱ca̱ ta̱hví da̱ nu̱ á já cáchí da̱ já: —Xíhi̱ ja̱hyí i̱ viti ñúhú. Caja ndó ña̱ma̱ni̱ ná co̱ho̱ vehe chinúu ndó ndáha̱ ndó ja̱ta̱ ña̱ ná ndiva̱ha ñá já ná catacu ñá —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","A̱nda̱ já na̱quee Jesús cua̱ha̱n xi̱hi̱n dá. Chí cándíhi táhan mé ña̱yivi ndíco̱ na̱ ja̱tá cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ta tañu ña̱yivi cán ndáca̱a̱n in ñá quíhvi̱. Sa̱ na̱xi̱nu̱ u̱xu̱ i̱vi̱ cui̱a̱ ndíta̱hví ni̱i̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na̱ndoho ndiva̱ha ini ñá nu̱ú na̱ cája tátá ña̱yivi ta sa̱ na̱játi̱ví ndihi ñá jiu̱hún ña̱ cátátá ña̱ cúni̱ ña̱. Joo a̱ cu̱ú ndiva̱ha ñá ta ja̱nda̱ cája ndeé chága̱ ví a̱ xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tá na̱xini jo̱ho ñá sa̱ha̱ Jesús já cua̱ha̱n ñá cayati ñá chí ja̱tá tañu tócó ndihi ña̱yivi cua̱ha̱n ja̱ta̱ mé a̱ cán. Ta na̱cani ndaa ndáha̱ ñá jáhma̱ á ");
INSERT INTO mksNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","jáchi̱ na̱ca̱hán ña̱: “Tá ná cani ndaa cuití ndahá yo̱ jáhma̱ á já ndava̱ha í”, na̱ca̱hán ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","I̱vi̱ la̱á na̱hi̱chi̱ ni̱i̱ ñá. Na̱xini cáxí ña̱ na̱ndiva̱ha ñá ta cua̱ha̱n va cue̱he̱ na̱ndoho ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jári Jesús i̱vi̱ la̱á na̱canda̱a̱ ini a ña̱ na̱ndiva̱ha in ña̱yivi na̱caja ndée̱ mé á. Já na̱casáhá sánde̱hé a̱ chí ja̱ta̱ tañu ña̱yivi. Já na̱casáhá ndáca̱ tu̱hún á na̱ já cáchí a̱ já: —Ndá ndó na̱cani ndaa ndáha̱ jahmá i̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta na̱nducú ñehe mé na̱ xíca tuun xi̱hi̱n á cán tu̱hun nu̱ á já cáchí na̱ já xi̱hi̱n á: —Sánde̱hé va̱ha mé ndó ndá quia̱hva cándíhi táhan ña̱yivi va̱xi na xi̱hi̱n ndo̱ ta cáa ga̱ mé ndó ndáca̱ tu̱hún ndó ndá na̱ na̱cani ndaa ndáha̱ jáhma̱ ndo̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Joo cáva̱ nuu nu̱u̱ Jesús sánde̱hé a̱ ndá na̱ na̱cani ndaa ndáha̱ jáhma̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ta mé ñá na̱ndiva̱ha cán tá na̱canda̱a̱ ini ñá ña̱ na̱ya̱ha já na̱casáhá quíji ni̱nu ñá sa̱há ña̱ yíhví ña̱. Já na̱xi̱nu̱ ñá na̱saxítí ña̱ nu̱ Jesús. A̱nda̱ já na̱casáhá ña̱ ndícani ñá nu̱ á ndaja cáa ña̱ na̱caja ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ña̱: —Ja̱hyi a, na̱ndiva̱hún jáchi̱ na̱candúsún ye̱he̱. Cuanúhu̱ ta a̱ ndícani ga̱ inún jáchi̱ na̱ndindaa cue̱hu̱n —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Cáha̱n yi̱i̱ va Jesús xi̱hi̱n ñá cán tá na̱xi̱nu̱ java na na̱quixi vehe mé da̱ sáhndá chuun veñu̱hu cán já na̱cachi na já xi̱hi̱n dá: —Sa̱ na̱xi̱hi̱ va ja̱hyi ndó. A̱ jáqui̱hvi̱ ga̱ ndó da̱ xíca jána̱ha̱ ña̱yivi ja̱n —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Joo na̱caja Jesús tátu̱hun co̱ xíni̱ jo̱ho a nu̱ú na̱ca̱ha̱n na̱. Na̱casáhá cáchí a̱ já xi̱hín da̱ sáhndá chuun veñu̱hu cán: —A̱ cáyi̱hví tohún. Candúsa cuití vún ye̱he̱ —cáchí a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta co̱ó na̱sa̱ha̱n Jesús ña̱ma̱ni̱ nu̱ú na̱ cua̱ha̱ ndúu cán cu̱hu̱n na̱ xi̱hi̱n á. Na̱ na̱sa̱ha̱n cuití xi̱hi̱n á cúú Pedro xi̱hi̱n Jacobo xi̱hi̱n Juan, da̱ cúú ñani Jacobo. ");
INSERT INTO mksNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tá na̱xi̱nu̱ na̱ vehe mé da̱ sáhndá chuun veñu̱hu cán já na̱xini a ndíváá ña̱yivi sácu ndiva̱ha na cáyuhú na̱ ndúu na cán. ");
INSERT INTO mksNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Já na̱qui̱hvi a vehe ta já cáchí a̱ já: —Ndáva̱ha ndíváá na̱há ndo̱ ta sácu cua̱ha̱ ndo̱. Ta co̱ó na̱xi̱hi̱ toho ñáloho yóho joo quíji̱ cuití va ñá —na̱cachi a xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Joo na̱casáhá na̱ sácu̱ ndaa na a̱. A̱nda̱ já na̱tavá Jesús tócó ndihi ña̱yivi ja̱ta̱ véhe. Na̱ na̱qui̱hvi xi̱hi̱n á na̱sa̱cuu tátá náná ña̱ xi̱hín na̱ xíca tuun xi̱hi̱n á. Ta na̱cayati a nu̱ cándúhu̱ mé ñáloho cán. ");
INSERT INTO mksNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Já na̱tiin a ndáha̱ ña̱ ta na̱casáhá cáchí a̱ já xi̱hi̱n ña̱: —Talita, cumi —na̱cachi a. Mé tu̱hun yóho cúni̱ cachi a: Ñáloho cáha̱n i̱ xu̱hu̱n cuándaco̱o. ");
INSERT INTO mksNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","I̱vi̱ la̱á na̱ndaco̱o ñáloho, ñá ndaca̱a̱n u̱xu̱ i̱vi̱ cui̱a̱ ta na̱casáhá ña̱ xíca nuu ñá. Já na̱catóntó tócó ndihi ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Joo na̱sahnda Jesús chuun nu̱ú na̱ ndúu cán ña̱ ná a̱ cáxi tu̱hun na ña̱ na̱ya̱ha yóho nu̱ú java ga̱ ña̱yivi. Ta na̱sahnda a chuun nu̱ ná ña̱ ná quia̱hva na ña̱ cuxu mé ñáloho cán. ");
INSERT INTO mksNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na̱quee Jesús cuanúhu̱ á ñuu a. Já na̱quee na̱ xíca tuun xi̱hi̱n á cua̱ha̱n na̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tá na̱xi̱nu̱ qui̱vi̱ ndíquehe ndée̱ ná já na̱casáhá Jesús jána̱ha̱ ña̱yivi ini veñu̱hu cán. Ta cua̱há ña̱yivi na̱xini jo̱ho nu̱ú na̱ca̱ha̱n ta chí na̱catóntó na̱ ta ndáca̱ tu̱hún xi̱hi̱n táhan na já cáchí na̱ já: —Ndájá na̱catia̱hva na̱há da̱ yóho ña̱ jána̱ha̱ dá nu̱ yo̱. Ndá na̱quixi ña̱ ndíchí ji̱ni̱ dá. Ndá na̱quixi ña̱ha xitúhún cája da. ");
INSERT INTO mksNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Á a̱ ju̱ú da̱ yóho cúú da̱ cája chúun xi̱hi̱n yíto̱, da̱ cúú ja̱hyi María. Ta ñani da cúú Jacobo xi̱hi̱n José xi̱hi̱n Judas xi̱hi̱n Simón. Ta quia̱hva̱ da̱ ja̱n ndúu ñuu yóho xi̱hi̱n mí —cáchí na̱ ndáca̱ tu̱hún táhan na. Ta chí co̱ó na̱xeen na candúsa ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sa̱há ña̱ cán quéa̱ na̱cachi Jesús já xi̱hi̱n ná: —Va̱tí tócó ndihi ña̱yivi cája cáhnu na in profeta joo na̱ vehe da xi̱hín na̱ ñuu da co̱ cándúsa na da̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chí co̱ó na̱cuu caja Jesús ña̱ náhnu nu̱ú na̱ cán. Java va na̱ quíhvi̱ cuití va na̱chinúu a ndahá ji̱ni̱ ná já na̱ndaja va̱ha a na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ta chí na̱catóntó Jesús sa̱há ña̱ co̱ cándúsa na mé á. Sa̱há ña̱ cán quéa̱ na̱quee Jesús cua̱ha̱n jána̱ha̱ ña̱yivi java ga̱ ñuu válí ndúu yati cán. ");
INSERT INTO mksNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tá na̱jánditaca Jesús ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hi̱n á cán já na̱chindahá a̱ na̱ tá i̱vi̱ tá i̱vi̱ cañehe táhan na cu̱hu̱n na̱. Ta na̱sa̱ha̱n ndée̱ nu̱ ná ña̱ ná cuu tavá na̱ ínima̱ quini ñúhu ini ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ta na̱sahnda a chuun nu̱ ná ña̱ ná a̱ cáñehe toho na ña̱ha cu̱hu̱n na̱ íchi̱. In túhún ña̱ cuu cañehe na cu̱hu̱n na̱ cúú in garrote, dó tiin ndaa na. Joo a̱ cu̱ú cañehe na ni yátí ni pan ni jiu̱hún. ");
INSERT INTO mksNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ndítahan cayihi na ndu̱sa̱ ta in túhún cotó na̱ ndítahan candixi na cu̱hu̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ta na̱cachi a já xi̱hi̱n ná: —Tá ná xi̱nu̱ co̱o ndó in vehe, canduu ndó mé vehe ja̱n a̱nda̱ quia̱hva xi̱nu̱ qui̱ví quee ndó cu̱hu̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ta ndá ñuu co̱ cúni̱ na̱ ndiquehe va̱ha na ndo̱hó ta ni co̱ cúni̱ na̱ taa jo̱ho na nu̱ cáha̱n ndo̱ já quéa̱ cuáhán queta ndó cu̱hu̱n ndo̱ ta catí ndó ña̱ yácá sa̱ha̱ ndo̱ já ná na̱ha̱ ña̱ cua̱ha̱n cua̱chi na̱ cán ja̱ta̱ mé va na. Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ná xi̱nu̱ qui̱vi̱ caja vií Ndióxi̱ sa̱há ña̱yivi ndúu ñuyíví já quéa̱ jándoho chága̱ Ndióxi̱ ini ña̱yivi ñuu ja̱n sa̱há ña̱ co̱ó na̱ndiquehe na ndo̱hó a̱ ju̱ú ga̱ tá quia̱hva na̱jándoho a ini na̱ ñuu Sodoma xi̱hi̱n Gomorra sa̱nahá —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A̱nda̱ já na̱quee mé na̱ xíca tuun xi̱hi̱n á cua̱ha̱n na̱ ca̱xi tu̱hun na nu̱ú ña̱yivi ña̱ ndítahan nu̱ ná ndicó co̱o ini na jándacoo na cua̱chi cája na. ");
INSERT INTO mksNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ta na̱tavá cua̱ha̱ ná ínima̱ quini na̱sa̱ñuhu ini ña̱yivi ta tá na̱xo̱jo̱ na̱ sítí ji̱ní ña̱yivi quíhvi̱ já na̱ndiva̱ha na. ");
INSERT INTO mksNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na̱ñe̱he̱ Herodes, mé da̱ cómí cuéntá sa̱há ña̱yivi cán tu̱hun sa̱há Jesús jáchi̱ níí cúú na̱ndicui̱ta nuu tu̱hun sa̱há. Ta já cáchí Herodes já sa̱ha̱ Jesús: —Á a̱ ju̱ú Jesús cúú á Juan, da̱ na̱jácandúta̱ ña̱yivi ta viti na̱nditacu tucu da. Sa̱há ña̱ cán quéa̱ íin ndée̱ da̱ cája da tócó ndihi ña̱ cája da̱ yóho —cáchí da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ta java na cáchí na̱ já: —Á a̱ ju̱ú da̱ yóho cúú Elías, da̱ na̱sacuu profeta. Ta java na cáchí na̱ já: —Á a̱ ju̱ú da̱ yóho cúú in profeta tátu̱hun na̱ profeta na̱sa̱nduu sa̱nahá ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tá na̱xini jo̱ho Herodes ña̱ yóho já na̱casáhá cáchí da̱ já: —Jivi ndusa da̱ yóho cúú Juan, da̱ na̱jácandúta̱ ña̱yivi, da̱ na̱sahnda i̱ chuun ná chitúhu̱n ná ji̱co̱ dá joo viti na̱nditacu tucu da —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jáchi̱ mé Herodes yóho sa̱ na̱sahnda da chuun ña̱ ná tiin na Juan, da̱ na̱jácandúta̱ ña̱yivi ta na̱cató na̱ da̱ já na̱chica̱a̱n na̱ da̱ veca̱a. Na̱caja da ña̱ yóho sa̱há Herodías, ña̱ na̱sa̱cuu ñájíhí Felipe, ñani mé Herodes jáchi̱ sa̱ na̱quehe Herodes ña̱ cacuu ñá ñájíhí mé dá. ");
INSERT INTO mksNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ta na̱tiin Herodes mé Juan jáchi̱ já na̱sa̱ca̱ha̱n Juan já xi̱hi̱n dá: —Co̱ ndítahan coún xi̱hi̱n ñájíhí ñanún —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sa̱há ña̱ cán quéa̱ na̱xo̱jo̱ ini Herodías xi̱hi̱n Juan. Ta cúni̱ ñá cahní ñá da̱ joo a̱ cu̱ú caja ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Jáchi̱ yíhví Herodes Juan sa̱há ña̱ xíni̱ da̱ ña̱ cúú Juan in ta̱a nda̱a̱, da̱ co̱ cája cua̱chi. Ña̱ cán quéa̱ co̱ó na̱sa̱ha̱n Herodes ña̱ma̱ni̱ nu̱ mé Herodías caja ñá ña̱ núu xi̱hi̱n dá. Ta táa jo̱ho Herodes nu̱ cáha̱n Juan va̱tí cáhvi i̱vi̱ jo̱ho ini da sa̱há ña̱ xíni̱ jo̱ho da joo cáji̱i̱ ini da táa jo̱ho da nu̱ cáha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Joo in qui̱vi̱ na̱nu̱na̱ nu̱ Herodías cahní ña̱ Juan jáchi̱ na̱caja Herodes in víco̱ cuéntá qui̱ví na̱cacu da. Mé já na̱cana da da̱ náhnu ndúu nu̱ dá ña̱ ná quixi na cuxu na xi̱hi̱n dá. Ta na̱cana da tócó ndihi na̱ cúú sa̱cua̱ha̱ nu̱ú soldado xi̱hi̱n tócó ndihi ña̱yivi íin sa̱ha̱ estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ta ndaja coo ñá cúú ja̱hyi jíhí Herodías na̱qui̱hvi ñá nu̱ ndúu na xíxi na ta na̱casáhá ña̱ xíta sáhá ña̱ nu̱ú ndihi na̱ cán. Ta na̱catóó Herodes xi̱hín na̱ ndúu xíxi xi̱hi̱n dá ndá quia̱hva na̱xita sáhá ña̱ sa̱há ña̱ cán quéa̱ na̱cachi Herodes xi̱hi̱n ña̱: —Ndía̱ cúni̱ mún, ca̱cún ña̱ nu̱ú i̱ jáchi̱ quia̱hva i̱ ña̱ nu̱u̱n —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ta na̱sa̱ha̱n da̱ tu̱hun da nu̱ ñá cán ña̱ quia̱hva da tócó ndihi ña̱ha ná ca̱ca̱ ñá nu̱ dá va̱tí ñahñu táhví nda̱a̱ ñundáhyi̱ ña̱ cómí da̱ chuun sa̱ha̱ na̱cachi da quia̱hva da nu̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Já na̱quee ñá cán cua̱ha̱n ñá ca̱xi tu̱hún ña̱ nu̱ náná ña̱ ña̱ na̱cachi Herodes xi̱hi̱n ñá. Ta na̱nda̱ca̱ tu̱hún ñá náná ña̱ ndía̱ ca̱ca̱ ñá nu̱ dá ta já na̱cachi mé náná ña̱ já xi̱hi̱n ña̱: —Ca̱ca̱ yiquí jíní Juan, da̱ jácandúta̱ ña̱yivi —na̱cachi Herodías. ");
INSERT INTO mksNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ta cama chá na̱qui̱hvi tucu ñá cán nu̱ ndáca̱a̱n Herodes já cáchí ña̱ já xi̱hi̱n dá: —Viti ñúhú cúni̱ ña̱ ná quia̱hva mé ndó yiquí jíní Juan, da̱ jácandúta̱ ña̱yivi nu̱ú i̱ ini in co̱ho̱ cáhnu —na̱cachi ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ta ndaja coo na̱casáhá na̱cacuéha̱ ndiva̱ha ini Herodes sa̱há ña̱ na̱xi̱ca̱ ñá cán yiquí jíní Juan. Joo sa̱há ña̱ sa̱ na̱sa̱ha̱n da̱ tu̱hun da nu̱ ña̱ ta sa̱ na̱xini jo̱ho tócó ndihi na̱ ndúu xíxi xi̱hi̱n dá cán ña̱ na̱cachi da xi̱hi̱n ña̱ sa̱há ña̱ cán quéa̱ ndúsa̱ caja da ña̱ cúni̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chí i̱vi̱ la̱á na̱chindahá da̱ in soldado veca̱a ña̱ ná cañehe da yiquí jíní Juan quixi a. ");
INSERT INTO mksNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Na̱xi̱nu̱ soldado cán veca̱a já na̱chitúhu̱n dá ji̱co̱ Juan já ñéhe da ña̱ ini in co̱ho̱ cáhnu já na̱ndiquia̱hva da ña̱ nu̱ ñá cán já na̱ndiquia̱hva ñá a̱ nu̱ náná ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tá na̱canda̱a̱ ini na̱ na̱xi̱ca xi̱hi̱n Juan ña̱ na̱caja na xi̱hi̱n dá já na̱sa̱ha̱n na̱ na̱ndique̱he na yiquí cu̱ñu da já na̱jándu̱xu̱ na̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tá na̱ndihi já na̱ndique táhan tucu na̱ xíca tuun xi̱hi̱n Jesús xi̱hi̱n á já na̱casáhá ndícani na nu̱ á ña̱ na̱caja na xi̱hín ña̱ na̱jána̱ha̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Já na̱cachi Jesús xi̱hi̱n ná: —Naha ndó ná co̱ho̱ ndiquehe ndée̱ loho í nu̱ cáa xóo. Na̱cachi a já xi̱hi̱n ná jáchi̱ cua̱ha̱n va̱xi ña̱yivi xíca nuu cua̱ha̱ chá na̱ mé cán ta chí co̱ sáhan na ña̱ma̱ni̱ cuxu na. ");
INSERT INTO mksNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","A̱nda̱ já na̱ndi̱hvi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á ini in barco já na̱quee na cua̱ha̱n na̱ in nu̱ cáa xóo. ");
INSERT INTO mksNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Joo cua̱há ña̱yivi na̱ndicuni na Jesús tá na̱quee a cua̱ha̱n. Já xínu cua̱há ña̱yivi tá nu̱ú ñuu cán cua̱ha̱n sáhá na̱ xoo nu̱ú cua̱ha̱n Jesús ini barco. Ta jihna ga̱ mé ná na̱xi̱nu̱ yuhú tañu̱hú cán a̱ ju̱ú ga̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tá na̱nuu Jesús barco cán já na̱xini a cua̱há ndiva̱ha ña̱yivi. Já na̱tahvi ini a sa̱ha̱ ná jáchi̱ tá quia̱hva ndúu ndicachi, rí co̱ó xitoho quia̱hva já ndúu na. A̱nda̱ já na̱casáhá jána̱ha̱ cua̱há ña̱ha nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ta tá sa̱ cáhini cua̱ha̱n na̱xi̱nu̱ na̱ xíca tuun xi̱hi̱n á já cáchí na̱ já: —Sa̱ na̱hini va ta a̱ ju̱ú xoo nu̱ ndúu ña̱yivi quéa̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ndinda̱yí ndó ña̱yivi ná cu̱hu̱n na̱ ñuu válí xi̱hín nu̱ú yati yóho já ná cueen na ña̱ cuxu na —na̱cachi na̱ xíca tuun xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tá na̱ndihi já na̱nducú ñehe Jesús tu̱hun já cáchí a̱ já: —Mé ndó quia̱hva ndó ná cuxu na —na̱cachi Jesús xi̱hín na̱ cán. Ta na̱cachi na já xi̱hi̱n á: —Ndá cuu caja nde̱ quia̱hva nde̱ ña̱ cuxu na̱ yóho jáchi̱ jiu̱hún cua̱há ndiva̱ha xíní ñúhú nde̱ já cuu cueen nde̱ pan cuxu ña̱yivi cua̱ha̱ yóho. Ta ni a̱ quéta toho i̱vi̱ ciento denario —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Já na̱cachi tucu Jesús já xi̱hín na̱ cán: —Ndaja pan cómí ndo̱. Cuáhán ndo̱ cande̱hé ndo̱. Tá na̱sa̱ha̱n na̱ sánde̱hé na̱ já cáchí na̱ já xi̱hi̱n á: —Íin u̱hu̱n pan xi̱hín i̱vi̱ ti̱yacá. ");
INSERT INTO mksNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A̱nda̱ já na̱sahnda Jesús chuun nu̱ ná ña̱ ná jácaco̱o na ndihi ña̱yivi tá táhndá nu̱ú yu̱cu̱ cuíi̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ta na̱saco̱o na java táhndá in ciento na̱ ta java táhndá i̱vi̱ jico u̱xu̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A̱nda̱ já na̱tiin Jesús ndíhu̱hu̱n pan xi̱hi̱n ndíví ti̱yacá ta sánde̱hé a̱ indiví já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱. Ta na̱sahnda java pan já na̱sa̱ha̱n ña̱ nu̱ú na̱ xíca tuun xi̱hi̱n á já ná ndicahnda na ña̱ nu̱ú ña̱yivi. Tá quia̱hva já na̱sahnda ti̱yacá já na̱ndita̱hnda̱ rí nu̱ tócó ndihi ña̱yivi cán. ");
INSERT INTO mksNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Já na̱xixi tócó ndihi ña̱yivi cán ta na̱chutú ti̱xi ndihi na. ");
INSERT INTO mksNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ta mé pan xi̱hín ti̱yacá ña̱ na̱cando̱o na̱xixi na na̱jáchutú na̱ u̱xu̱ i̱vi̱ to̱yi̱cá. ");
INSERT INTO mksNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ta na̱xixi u̱hu̱n mil da̱ta̱a cán. ");
INSERT INTO mksNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tá na̱ndihi na̱caja Jesús ña̱ ná ndi̱hvi na̱ xíca tuun xi̱hi̱n á ini in barco ña̱ ná cu̱hu̱n cuéé na̱ inga xoo tañu̱hú já xi̱nu̱ na̱ Betsaida nani ndínda̱yí a̱ ña̱yivi já sa̱a̱ mé á cán ndique táhan xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ta tá sa̱ na̱ndinda̱yí ndihi a ña̱yivi na̱quee a cua̱ha̱n yúcu̱ ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tá na̱cuaá sa̱ ndáca̱a̱n barco ma̱hñú tañu̱hú cán ta Jesús íin yi̱i̱ va nu̱ ñúhu̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ta na̱xini a ña̱ ndóho ini na̱ xíca tuun xi̱hi̱n á jáchi̱ a̱ cu̱ú jácaca na barco ini ticui̱í jáchi̱ mé xoo nu̱ú cu̱hu̱n na̱ va̱xi ta̱chi̱. Tá sa̱ cua̱ha̱n tívi já xíca sáhá Jesús cua̱ha̱n nu̱ú ticui̱í xoo nu̱ ndúu na ta tá na̱cayati a nu̱ ndúu na ja̱lóho ya̱ha saa cu̱hu̱n a̱, nduu. ");
INSERT INTO mksNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Joo tá na̱xini na xíca sáhá Jesús nu̱ú ticui̱í na̱ca̱hán na̱ cúú á in ínima̱ já na̱cayuhú cóhó na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jáchi̱ tócó ndihi na̱ na̱xini ñahá na̱yi̱hví na̱. Joo na̱ndica̱ha̱n Jesús já cáchí a̱ já: —Ndacú coo ini ndó jáchi̱ ye̱he̱ va cúú u̱. A̱ yíhví toho ndó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tá na̱ndaa Jesús ja̱ta̱ barco nu̱ cándójó na̱ já na̱jáya̱a̱ ta̱chi̱. Chí na̱catóntó mé na̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jáchi̱ a̱ ñáha ta̱cu̱ va̱ha ini na sa̱há ña̱ na̱caja Jesús tá na̱ndaja cua̱ha̱ mé á pan xi̱hín ti̱yacá jáchi̱ na̱ndaji tuun xíní túni̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na̱xi̱nu̱ na̱ inga xoo tañu̱hú ta na̱cató ndaa na barco yuhú tañu̱hú cán já na̱sa̱a̱ na̱ ñundáhyi̱ Genesaret. ");
INSERT INTO mksNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tá quéta Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á ini barco cán i̱vi̱ la̱á na̱ndicuni ña̱yivi mé á. ");
INSERT INTO mksNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Já xínu na cua̱ha̱n na̱ ndijáá ñuu válí ndúu yati cán ndúcú na̱ na̱ quíhvi̱ já ñéhe na na̱ nu̱ú xi̱to cása̱a̱ na̱ nu̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ta ndá ñuu na̱cuu nu̱ quíhvi Jesús cúú á ñuu náhnu á ñuu válí á yúcu̱ já quéta ña̱yivi sácú na̱ na̱ quíhvi̱ yuhú íchi̱. Ta já xíca̱ ta̱hví na̱ nu̱ Jesús ña̱ ná quia̱hva ña̱ma̱ni̱ cani ndaa ndáha̱ ná a̱ va̱tí loho yuhú jahmá a̱. Ta ndá na̱ na̱cani ndaa ndáha̱ mé á i̱vi̱ la̱á na̱ndiva̱ha na. ");
INSERT INTO mksNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","In tañu na̱ fariseo xi̱hín java na̱ jána̱ha̱ ley Moisés, na̱ na̱quixi ñuu Jerusalén na̱cayati na nu̱ íin Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ta na̱xo̱jo̱ ini na tá na̱xini na ña̱ ndúu coo java na̱ xíca tuun xi̱hín Jesús xíxi na tá cáma̱ni̱ ndahá na̱ tá quia̱hva íin costumbre na̱ Israel. ");
INSERT INTO mksNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jáchi̱ jána̱ha̱ na̱ fariseo xi̱hín ndihi na̱ Israel ña̱ a̱ cu̱ú cuxu na tá cáma̱ní ndahá va̱ha na tá quia̱hva íin costumbre tásáhnu jícó na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ta jári jána̱ha̱ na̱ ña̱ tá ndícó co̱o na sáha̱n na̱ ya̱hvi xíní ñúhú ndahá na̱ tá quia̱hva íin costumbre na̱ já ná cuu cuxu na. Ta íin cua̱há ga̱ nu̱ú ña̱ha jána̱ha̱ na̱ ndítahan caja na tátu̱hun ña̱ ndícata na yáxi̱ xíhi na xi̱hín tindo̱ho̱ xi̱hín co̱hó ca̱a a̱nda̱ xi̱to quíji̱ na̱ viti, ndítahan ndicata na. ");
INSERT INTO mksNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A̱nda̱ já na̱casáhá na̱ fariseo xi̱hín na̱ jána̱ha̱ ley Moisés cáchí na̱ já xi̱hi̱n Jesús. —Ndáva̱ha co̱ cája na̱ xíca tuun xu̱hu̱n tá quia̱hva na̱cachi tásáhnu jícó yo̱ caja í. Ndáva̱ha xíxi na tá cáma̱ni̱ ndahá na̱ tá quia̱hva sáhndá ley caja í —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Já na̱cachi Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ na̱ca̱ha̱n profeta Isaías sa̱ha̱ ndo̱ jáchi̱ co̱ cúú ndó tá quia̱hva ndáa ndó. Já na̱ca̱hyí da̱ já: Yuhú ni̱nu uun na cája cáhnu na ye̱he̱. Ta co̱ cája cáhnu na ye̱he̱ xi̱hín ndinuhu ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mé a̱ uun va quéa̱ cája cáhnu na ye̱he̱, jáchi̱ ña̱ jána̱ha̱ na̱ nu̱ú ña̱yivi cúú á ña̱ quixi ji̱ni̱ mé cuití va na, na̱ca̱hyí Isaías sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jáchi̱ na̱jándacoo ndó ña̱ na̱sahnda Ndióxi̱ nu̱ ndó caja ndó ta na̱casáhá ndíco̱ cáhnu ndó costumbre ña̱ na̱caja tásáhnu jícó ndo̱. Ta sa̱há ña̱ yóho ndícata ndó tindo̱ho̱ xi̱hi̱n yáxi̱ xíhi ndó ta cája ndó cua̱há chága̱ costumbre yatá —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Já na̱cachi tucu a já xi̱hi̱n ná: —Sa̱há ña̱ cúni̱ ndo̱ candi̱co̱ cáhnu ndó costumbre mé va ndó sa̱há ña̱ cán quéa̱ na̱jándacoo ndó ña̱ na̱sahnda Ndióxi̱ caja ndó. ");
INSERT INTO mksNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Jáchi̱ já cáchí ley Moisés: “Caja cáhnún tátún xi̱hi̱n nánún”, ta jári cáchí a̱ já: “Ndá na̱ ná chica̱a̱n cháhan ja̱ta̱ tátá na̱ á ja̱ta̱ náná na̱, ndítahan quivi na”, cáchí ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Joo ndóhó jána̱ha̱ ndó nu̱ú ña̱yivi ña̱ cuu ca̱ha̱n na̱ já xi̱hi̱n tátá na̱ á náná na̱: “A̱ cu̱ú chindeé e̱ ndóhó jáchi̱ sa̱ na̱sacu xoo i̱ ña̱ha i̱ quia̱hva i̱ ña̱ nu̱ Ndióxi̱”, cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tá ná cachi na ña̱ yóho já quéa̱ co̱ ndúsa̱ ga̱ chíndeé na̱ tátá na̱ á náná na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Quia̱hva joho cája ndó sácu xóo ndó ña̱ na̱sahnda Ndióxi̱ nu̱ ndo̱ ta ndája ndó a̱ tátu̱hun in ña̱ha ña̱ co̱ó sa̱ha̱. Jáchi̱ ndíco̱ cáhnu ndó costumbre ña̱ na̱jándadacoo tásáhnu jícó ndó nu̱ ndo̱ ta quia̱hva já jána̱ha̱ ndó nu̱ú ja̱hyi ndó. Ta cua̱há ga̱ ña̱ha tátu̱hun ña̱ yóho cája ndó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Anda̱ já na̱cana tucu Jesús ña̱yivi já na̱cachi a já xi̱hi̱n ná: —Cuni jo̱ho ndihi ndó nu̱ cáha̱n i̱ xi̱hi̱n ndo̱ ta canda̱a̱ ini ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ni in ña̱ha xíxi ña̱yivi a̱ cu̱ú caja quini ínima̱ ná. Ña̱ cuu ndaja quini ña̱yivi cúú ña̱ quixi ínima̱ na̱ tátu̱hun ña̱ cáha̱n na̱ xi̱hín ña̱ cája na. ");
INSERT INTO mksNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na̱ íin jo̱ho, ná cuni jo̱ho na —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tá na̱ndihi na̱ndi̱hvi Jesús ini in vehe ta na̱cando̱o cua̱há ña̱yivi ja̱ta̱ véhe. Já na̱nda̱ca̱ tu̱hún na̱ xíca tuun xi̱hi̱n á ña̱ ndía̱ cúni̱ cachi a xi̱hín tu̱hun na̱ca̱ha̱n xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ta na̱nducú ñehe a tu̱hun nu̱ ná já na̱cachi a já: —Á co̱ó toho xíní túni̱ ri ndóhó va, va̱ha. Jáchi̱ co̱ cánda̱a̱ ini ndó ña̱ tócó ndihi ña̱ha xíxi ña̱yivi a̱ cu̱ú caja quini a na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Jáchi̱ ña̱ xíxi ña̱yivi co̱ xínu̱ a̱ ini ínima̱ ná joo xínu̱ co̱o a ti̱xi na já queta tucu a yiquí cu̱ñu na —na̱cachi Jesús. Xi̱hín tu̱hun yóho na̱cachi Jesús xi̱hi̱n ná ña̱ cuu cuxu na tócó ndihi ña̱ha ña̱ xíxi ña̱yivi jáchi̱ co̱ ndája quini a ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ta na̱cachi tucu Jesús já: —Ña̱ cuu ndaja quini ña̱yivi cúú ña̱ quíxi ínima̱ ná tátu̱hun tu̱hun cáha̱n na̱ xi̱hín ña̱ cája na. ");
INSERT INTO mksNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Jáchi̱ chí ini ínima̱ ná quéta ña̱ cáhvi núu ini na tátu̱hun ña̱ cáhvi ini in da̱ta̱a coo da xi̱hi̱n ñájíhí ñani táhan da á tá xíca̱ ini da coo da xi̱hín in ñáñáha̱, ñá co̱ cúú ñájíhí da̱ á tá cáhvi ini na cahní na̱ ndi̱i. ");
INSERT INTO mksNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ta sa̱ mé cán quéta ña̱ xíca̱ ini na caja cuíhná na̱ ta jári xíca̱ ini na coo cua̱há ndiva̱ha ña̱ha nu̱ ná. Ta sa̱ mé cán quéta ña̱ núu cája na ta cáha̱n na̱ ña̱ tu̱hún ta cája na tá nu̱ú cua̱chi ta cáhi̱hvi̱ ini na ta cátóó na̱ ca̱ha̱n na̱ sa̱ha̱ táhan na ta cája cáhnu na mé ná ta quíhví cája na. ");
INSERT INTO mksNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tócó ndihi ña̱ núu yóho ña̱ cáhvi ini ña̱yivi caja na, quíxi a ínima̱ ná ta ndája quini a na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Já na̱quee Jesús cua̱ha̱n chí ñundáhyi̱ cuéntá Tiro xi̱hín Sidón. Ta na̱qui̱hvi a in vehe coo a ta co̱ cúni̱ a̱ ña̱ ná canda̱a̱ ini na̱ ñuu ña̱ iin a cán joo co̱ó na̱cuu coo je̱hé a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chá va ta na̱canda̱a̱ ini in ñáñáha̱ ña̱ íin Jesús vehe cán. Ta íin in ja̱hyi jíhí ña̱, ñá ndáca̱a̱n ínima̱ quini ini. Ta ndaja coo na̱sa̱a̱ ñá ta na̱caxítí ña̱ sa̱ha̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ta cúú ñá ñá tóho̱ cuéntá ñundáhyi̱ Sirofenicia. Ta na̱xi̱ca̱ ta̱hví ñá nu̱ Jesús ña̱ ná tavá a̱ ínima̱ quini ndáca̱a̱n ini ja̱hyi ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ña̱: —Jihna ñúhú ndítahan nu̱ú i̱ chíndeé e̱ na̱ Israel a̱nda̱ jáví cuu chindeé e̱ ndo̱hó, na̱ tóho̱ jáchi̱ íin in tu̱hun ta cáchí a̱ ña̱ a̱ váha toho candaa í pan xíxi na̱ va̱lí ta jácana í ña̱ nu̱ú ti̱na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A̱nda̱ já na̱cachi mé ñá tóho̱ cán já xi̱hi̱n Jesús: —Mé a̱ nda̱a̱ cáha̱n ndó, xitoho. Joo a̱nda̱ ti̱na, rí ndúu ti̱xi mesa xíxi rí ña̱ jácu̱yu ja̱hyi xitoho rí —na̱cachi ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ñá: —Va̱ha va na̱ca̱hu̱n. Sa̱há ña̱ cán quéa̱ cáchí i̱ xu̱hu̱n cuanúhu̱ viti jáchi̱ sa̱ na̱queta va ínima̱ quini na̱sa̱ndaca̱a̱n ini ja̱hyún —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ta tá na̱xi̱nu̱ ñá vehe já na̱xini ñá cándúhu̱ ja̱hyi ñá nu̱ú xi̱to ta sa̱ co̱ó ga̱ ínima̱ quini cán ndáca̱a̱n ini ja̱hyi ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Na̱quee Jesús ñundáhyi̱ cuéntá Tiro ta na̱ya̱ha chí ñuu Sidón xi̱hín java ga̱ ñuu cuéntá Decápolis cán já na̱xi̱nu̱ co̱o a tañu̱hú Galilea. ");
INSERT INTO mksNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Cán ñéhe na in da̱ta̱a na̱casa̱a̱ na̱ nu̱ Jesús. Cúú dá da̱ jóho̱ ta cúú dá da̱ níhi̱. Ta na̱xi̱ca̱ na̱ nu̱ á ña̱ ná chinúu a ndáha̱ á ji̱ni̱ dá já ná ndiva̱ha da. ");
INSERT INTO mksNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Já na̱tavá xóo Jesús da̱ tañu ña̱yivi cán. Já na̱jáqui̱hvi a in nducu ndáha̱ jo̱ho da ta na̱xihnu a tóji̱í a̱ já na̱cani ndaa a tóji̱í a̱ yáa̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tá na̱ndihi na̱sande̱hé a̱ indiví já ndísa̱a̱ ndísa̱a̱ ínima̱ á já na̱cachi a já xi̱hi̱n dá: —Efata —na̱cachi a ta ña̱ yóho cúni̱ cachi: Ná ndinu̱na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","I̱vi̱ la̱á na̱ndinu̱na̱ jo̱ho mé da̱ jóho̱ cán ta na̱ndiva̱ha yáa̱ dá já na̱casáhá cáha̱n va̱ha da. ");
INSERT INTO mksNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ta na̱sahnda Jesús chuun nu̱ú ndihi na ña̱ ná a̱ cáxi tu̱hun na ña̱ yóho nu̱ú ni in ña̱yivi. Joo tá na̱cachi a̱ ña̱ yóho já quéa̱ ví ga̱ ví cáha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chí cátóntó ndihi ña̱yivi tá xíni jo̱ho na ña̱ ta cáha̱n xi̱hi̱n táhan na já cáchí na̱ já: —Va̱ha ndiva̱ha cája Jesús tócó ndihi ña̱ha jáchi̱ jándita̱cu̱ a̱ na̱ jóho̱ ta jándica̱ha̱n mé á na̱ níhi̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mé já na̱nditútú tucu cua̱há ña̱yivi ta chí co̱ó mé ña̱ha cuxu na. A̱nda̱ já na̱cana Jesús na̱ xíca tuun xi̱hi̱n á já na̱cachi a já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Táhnda̱ ndiva̱ha ini i̱ sa̱há ña̱yivi yóho jáchi̱ sa̱ na̱xi̱nu̱ u̱ni̱ qui̱vi̱ ndúu na xi̱hín i̱ yóho ta chí co̱ó ga̱ ña̱ha cuxu na. ");
INSERT INTO mksNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ta co̱ cúni̱ chindahá i̱ na̱ nu̱hu̱ na̱ vehe na jáchi̱ cáma̱ni̱ cuxu na ta tia̱hva náá cuitá na̱ ta cu̱yu na íchi̱ jáchi̱ sa̱ cáni̱ ndiva̱ha na̱quixi java na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A̱nda̱ já na̱cachi na̱ xíca tuun xi̱hi̱n á cán já: —Nda̱a̱ cáha̱n ndo̱. Ta ni mí, a̱ cu̱ú quia̱hva í ña̱ cuxu na jáchi̱ co̱ó toho ña̱yivi ndúu yóho nu̱ú cueén ña̱ cuxu na —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús na̱ já cáchí a̱ já xi̱hi̱n ná: —Ndaja pan cómí ndo̱. Já na̱cachi na̱ cán já: —U̱sa̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A̱nda̱ já na̱sahnda Jesús chuun nu̱ú ña̱yivi ña̱ ná caco̱o na nu̱ ñúhu̱. Já na̱tiin a ndíhu̱sa̱ pan cán. Ta na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱. Já na̱sahnda java ña̱ ta na̱sa̱ha̱n ña̱ nu̱ú na̱ xíca tuun xi̱hi̱n á cán ña̱ ná ndicahnda na ña̱ nu̱ú ña̱yivi cua̱ha̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ta jári na̱sa̱comí na̱ java ti̱yacá válí ta na̱ndiquia̱hva mé á ndixa̱hvi nu̱ Ndióxi̱ sa̱ha̱ ri̱ já na̱sahnda chuun nu̱ ná ña̱ ná ndicahnda na ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ta na̱xixi tócó ndihi na̱ ndúu cán a̱nda̱ quia̱hva na̱chutú ti̱xi na ta tá na̱ndihi na̱jáchutú na̱ ja̱nda̱ u̱sa̱ to̱yi̱cá xi̱hín ña̱ na̱cando̱o. ");
INSERT INTO mksNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tátu̱hun co̱mi̱ mil ña̱yivi na̱xixi. Ta tá na̱ndihi já na̱jándinda̱yí Jesús na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Já na̱ndi̱hvi a ini barco xi̱hín na̱ xíca tuun xi̱hi̱n á já na̱quee na cua̱ha̱n na̱ ñundáhyi̱ cuéntá Dalmanuta. ");
INSERT INTO mksNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","A̱nda̱ já na̱xi̱nu̱ na̱ fariseo nu̱ Jesús já na̱casáhá ndítúhún na̱ xi̱hi̱n á. Ta sa̱há ña̱ cúni̱ na̱ coto ndojó cuití ñahá na̱ sa̱há ña̱ cán quéa̱ na̱xi̱ca̱ na̱ nu̱ á ña̱ ná caja in ña̱ xitúhún, ña̱ quixi indiví já ná canda̱a̱ ini na á mé a̱ nda̱a̱ cúú á ña̱ na̱chindahá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ndísa̱a̱ ndísa̱a̱ ini Jesús jáchi̱ ndíhi ini a xi̱hi̱n ná já cáchí a̱ já: —Ndá sa̱ha̱ quéa̱ xíca̱ na̱ yóho ña̱ ná caja i̱ in ña̱ xitúhún. Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ a̱ cája i̱ ña̱ha xitúhún nu̱ú na̱ yóho —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A̱nda̱ já na̱ndi̱hvi tucu Jesús ini mé barco cán ta na̱jándacoo a na̱ cán já na̱quee a cua̱ha̱n inga xoo tañu̱hú. ");
INSERT INTO mksNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ta ndaja coo na̱ndindójó mé na̱ xíca tuun xi̱hín a̱ cán cañehe na ña̱ha cuxu na joo na̱sahi̱in in pan cuití va xi̱hi̱n ná ini barco cán. ");
INSERT INTO mksNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A̱nda̱ já na̱sahnda Jesús chuun nu̱ ná já cáchí a̱ já xi̱hi̱n ná: —Cande̱hé ndo̱. Cuéntá coo ndó xi̱hín na̱ fariseo ta xi̱hín na̱ cúú cuéntá Herodes jáchi̱ ña̱ jána̱ha̱ na̱ cúú á tátu̱hun yúsa̱ na̱xa̱a̱ ña̱ cáva táhan na xi̱hi̱n harina cáva̱ha na pan —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Co̱ó na̱canda̱a̱ ini na ña̱ cáchí a̱ ña̱ cán quéa̱ na̱casáhá ndítúhún xi̱hi̱n táhan na já cáchí na̱ já: —Sa̱há ña̱ co̱ó pan ñéhé va̱xí sa̱há ña̱ cán quéa̱ cáha̱n Jesús ña̱ yóho xo̱ho̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sa̱ na̱canda̱a̱ ini Jesús ña̱ cáha̱n na̱ ta já na̱casáhá cáchí a̱ já: —Mé ndó cáchí ndó ña̱ co̱ó pan ñéhé va̱xí jáchi̱ co̱ cánda̱a̱ ini ndó ta ni co̱ cája ndó cuéntá sa̱há ña̱ jána̱ha̱ i̱. Na̱ndaji tuun xíní túni̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Cúú ndó tátu̱hun na̱ co̱ tívi nu̱u̱ xi̱hín na̱ co̱ó jo̱ho jáchi̱ va̱tí xíní ndo̱ ta xíni̱ jo̱ho ndó joo co̱ cánda̱a̱ ini ndó. Á co̱ ndícu̱hu̱n ini ndó ña̱ na̱caja i̱ ");
INSERT INTO mksNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","tá na̱ndicahnda i̱ ndíhu̱hu̱n pan nu̱ú u̱hu̱n mil ta̱a. Ndaja to̱yi̱cá na̱nditaca na̱caja ndó xi̱hín ña̱ na̱cando̱o cán —na̱cachi Jesús. Já na̱nducú ñehe na tu̱hún nu̱ á: —U̱xu̱ i̱vi̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ta na̱cachi tucu Jesús xi̱hi̱n ná já: —Ta tá na̱ndicahnda i̱ u̱sa̱ pan nu̱ú co̱mi̱ mil ña̱yivi, ndaja to̱yi̱cá na̱nditaca na̱caja ndó xi̱hín ña̱ na̱cando̱o —na̱cachi a. Já na̱nducú ñehe na tuhun nu̱ á: —U̱sa̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A̱nda̱ já na̱cachi a já xi̱hi̱n ná: —Cáma̱ni̱ yi̱i̱ va cánda̱a̱ ini ndó —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tá na̱ndihi na̱xi̱nu̱ na̱ ñuu Betsaida já ñéhe na in da̱ cua̱á na̱casa̱a̱ na̱ nu̱ Jesús. Já na̱xi̱ca̱ ta̱hví na̱ nu̱ á ña̱ ná cani ndaa ndáha̱ á da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ta chí na̱tiin a ndáha̱ da̱ cua̱á cán já na̱tavá a̱ da̱ yuhú ñuu. Na̱chindaa tóji̱í a̱ nduchú núú da̱ já na̱chinúu a ndáha̱ á ji̱ni̱ dá. Já na̱nda̱ca̱ tu̱hún a̱ da̱ á cuu cande̱hé da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ta já na̱cachi da̱ cán já sánde̱hé da̱: —Sánde̱hé e̱ java ta̱a joo tá quia̱hva ndáa yíto̱ quia̱hva já ndáa da xíca nuu da xíní i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A̱nda̱ já na̱chinúu tucu Jesús ndáha̱ á nduchú núú da̱ já na̱sande̱hé nda̱a̱ da̱. A̱nda̱ jáví na̱ndiva̱ha nduchú núú da̱ ta na̱casáhá sánde̱hé cáxí va̱ha da tócó ndihi ña̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ta na̱chindahá Jesús da̱ cuanúhu̱ da̱ vehe da já na̱cachi a já xi̱hi̱n dá: —A̱ ndíhvún ma̱hñú ñuu ni a̱ ndícanún ña̱ yóho nu̱ú ña̱yivi ndúu ja̱n —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tá na̱ndihi já na̱sa̱ha̱n Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á ñuu válí ndáca̱a̱n Cesarea cuéntá Filipo. Nani xíca na cua̱ha̱n na̱ íchi̱ na̱nda̱ca̱ tu̱hún a̱ na̱ já cáchí a̱ já xi̱hi̱n ná: —Ndá da̱ cáchí ña̱yivi cúú ye̱he̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Já na̱cachi na̱ cán já: —Java na cáchí na̱ ña̱ cúú ndó Juan, da̱ na̱caja ndúta̱ ña̱yivi. Ta java na cáchí na̱ ña̱ cúú ndó profeta Elías. Ta java na cáchí na̱ ña̱ cúú ndó in táhan profeta na̱sa̱nduu sa̱nahá —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A̱nda̱ já na̱nda̱ca̱ tu̱hún tucu Jesús na̱ já cáchí a̱ já xi̱hi̱n ná: —Ta ndóhó ri, ndá da̱ cáchí ndo̱ cúú u̱ —na̱cachi a. A̱nda̱ já na̱cachi Pedro já xi̱hi̱n á: —Mé ndó cúú Cristo, mé a̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A̱nda̱ já na̱sahnda Jesús chuun nu̱ ná ña̱ ná a̱ cáxi tu̱hun na ña̱ yóho nu̱ú ni in ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A̱nda̱ já na̱casáhá jána̱ha̱ Jesús nu̱ ná ña̱ tandaa qui̱ví ndoho ndiva̱ha ini mé á, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. Ta na̱ sa̱cua̱ha̱ veñu̱hu xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés candají na̱ mé á ja̱nda̱ quia̱hva ná cahní ñahá na̱. Joo tá ná xi̱nu̱ u̱ni̱ qui̱vi̱ nditacu tucu a. ");
INSERT INTO mksNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cáxí ndiva̱ha na̱ca̱ha̱n Jesús ña̱ yóho xi̱hi̱n ná ta chí a̱nda̱ já na̱tavá xóo Pedro Jesús já na̱casáhá jána̱ni da a̱ sa̱há ña̱ na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Joo na̱ca̱va̱ Jesús ta na̱ndicoto nihni a nu̱ú na̱ xíca tuun xi̱hi̱n á já na̱casáhá ndícue̱he̱ a̱ xi̱hi̱n Pedro já cáchí a̱ já xi̱hi̱n dá: —Cuáhán quee Satanás, rí cúú tiñáhá sa̱cua̱ha̱. Co̱ íin xíní túnu̱n tá quia̱hva íin xíní túni̱ Ndióxi̱ jáchi̱ cáhvi inún tá quia̱hva cáhvi ini ña̱yivi ñuyíví yóho —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A̱nda̱ já na̱cana Jesús na̱ xíca tuun xi̱hi̱n á xi̱hín java ga̱ ña̱yivi já na̱cachi a já xi̱hi̱n ná: —Ndá na̱ cúni̱ candi̱co̱ ye̱he̱ ndítahan nu̱ ná ndi̱hi chága̱ ini na sa̱há ye̱he̱ a̱ ju̱ú ga̱ sa̱ha̱ mé ná. Ta ndítahan coo tia̱hva na ndoho ini na sa̱há ye̱he̱. Ta co̱ó caja toho a ná quivi na sa̱há i̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jáchi̱ ndá na̱ cátóó coo chága̱ ñuyíví yóho ndihi sa̱ha̱ ná. Joo ndá na̱ sáhan ndeé ini quivi sa̱há i̱ xi̱hín sa̱há tu̱hun Ndióxi̱, ñe̱he̱ táhvi̱ ná catacu na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Va̱tí ná quee va̱ha in na ñuyíví yóho ta cómí na̱ tócó ndihi ña̱ha ñuyíví joo ndá chuun quéa̱ tá nu̱ ndíhí ndihi sa̱ha̱ ná indayá. ");
INSERT INTO mksNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jáchi̱ ni in ña̱ha a̱ cu̱ú cha̱hvi in na sa̱ha̱ ínima̱ ná ná a̱ cúhu̱n na̱ indayá. ");
INSERT INTO mksNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cande̱hé ndo̱. Mé tiempo viti cája ña̱yivi cua̱há cua̱chi ta co̱ xéen na caja na ña̱ sáhndá Ndióxi̱ nu̱ ná. Ta ndá na̱ cácahan nu̱u̱ sa̱há i̱ xi̱hi̱n sa̱há tu̱hun va̱ha cáha̱n i̱ quia̱hva já cacahan ri nu̱ú ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi sa̱há na̱ cán tá ná quixi i̱ cacomí i̱ cuéntá sa̱há ña̱yivi. Mé tiempo cán na̱ha̱ ndaja cáhnu cúú ye̱he̱ jáchi̱ quixi i̱ xi̱hi̱n ndée̱ Ndióxi̱ ta xi̱hi̱n ndée̱ táto̱ yi̱i̱ mé á viti —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ta na̱cachi tucu Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Java na̱ ndúu yóho a̱ quíví toho na ja̱nda̱ quia̱hva ná xi̱nu̱ qui̱vi̱ cuni na cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi xi̱hi̱n ndée̱ mé á —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tá na̱ya̱ha i̱ñu̱ qui̱vi̱ já na̱ndaa Jesús in yucú jícó ta ndáca táhan Pedro xi̱hi̱n Jacobo xi̱hi̱n Juan cua̱ha̱n na̱ xi̱hi̱n á. Ta nu̱ táhyí mé na̱ cán na̱ndija̱ma quia̱hva cáa. ");
INSERT INTO mksNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ta a̱ ju̱ú quia̱hva na̱ndiye̱he̱ jáhma̱ ndíxi a chí na̱ndiyaa ca̱chi̱ ña̱. Ni in ña̱yivi ñuyíví yóho a̱ cu̱ú ndicata yaa na̱há jáhma̱ tá quia̱hva yaa na̱nduu jáhma̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A̱nda̱ já na̱ xíca tuun xi̱hín Jesús na̱xini na Elías xi̱hi̱n Moisés ndúu na ndítúhún na̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ta já na̱cachi Pedro já xi̱hín Jesús: —Maestro, va̱ha cúu ndúu nde̱ yóho jáchi̱ já cuu cava̱ha nde̱ u̱ni̱ vehe ti̱yahvá válí. In a coo mé ndó ta inga coo Moisés ta inga coo Elías —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Na̱yi̱hví ndiva̱ha na̱ xíca tuun xi̱hín Jesús sa̱há ña̱ cán quéa̱ co̱ xíni̱ mé Pedro ndía cáa cáha̱n va da. ");
INSERT INTO mksNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","A̱nda̱ já na̱nuu in vi̱co̱ ja̱ta̱ ná já na̱jája̱hvi a na̱ ta tañu vi̱co̱ cán na̱xini jo̱ho na ña̱ cáha̱n in a já cáchí a̱ já: —Da̱ yóho cúú ja̱hyi ma̱ní i̱. Cuni jo̱ho ndó nu̱ cáha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta tá na̱ndicoto nihni na sa̱ co̱ó ga̱ na̱ na̱xini na ta ja̱ndá in túhún Jesús na̱xini na. ");
INSERT INTO mksNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tá sa̱ cua̱ha̱n nuu na ji̱ni̱ yúcu̱ cán já na̱sahnda Jesús chuun nu̱ ná ña̱ ná a̱ cáxi tu̱hun na̱ nu̱ú ña̱yivi ña̱ na̱xini na a̱nda̱ quia̱hva ná xi̱nu̱ qui̱vi̱ nditacu tucu mé a̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sa̱há ña̱ cán quéa̱ na̱chije̱hé tu̱hun na sa̱há joo na̱nditúhún xi̱hi̱n táhan na ndía̱ cúni̱ cachi Jesús tá na̱cachi a ña̱ nditacu tucu a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","A̱nda̱ já na̱casáhá ndáca̱ tu̱hún na̱ mé á já cáchí na̱ já xi̱hi̱n á: —Ndáva̱ha cáchí na̱ jána̱ha̱ ley Moisés ña̱ ndítahan quixi jihna ñúhú profeta Elías —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Já na̱cachi Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ jihna ñúhú quixi Elías ta ndaja va̱ha ndihi da ña̱ha. Á co̱ xíni̱ ndó ndá quia̱hva cáchí tu̱hun Ndióxi̱ sa̱há da̱ chindahá Ndióxi̱ nduu ña̱yivi. Cáchí a̱ ña̱ ndoho ini da ta candají na̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Joo cáxi tu̱hun i̱ nu̱ ndó ña̱ sa̱ na̱quixi va Elías ta na̱caja na tá quia̱hva cúni̱ mé va na xi̱hi̱n dá ta tá quia̱hva cáchí tu̱hun Ndióxi̱ ndoho da quia̱hva já na̱ndoho da —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tá na̱ndihi já na̱ndicó co̱o Jesús xi̱hín na̱ cán nu̱ ndúu java ga̱ na̱ xíca tuun xi̱hi̱n á cán. Já na̱xini na cua̱há ndiva̱ha ña̱yivi na̱ca̱va̱ nuu na na̱ cán. Jári ñúhu java na̱ jána̱ha̱ ley Moisés cáni táhan yúhu̱ ná xi̱hín na̱ xíca tuun xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tá na̱xini ña̱yivi yóho Jesús chí na̱catóntó ndihi na já na̱ndava nihni na na̱sa̱ha̱n na̱ cáha̱n Ndióxi̱ ná xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús na̱ já cáchí a̱ já xi̱hi̱n ná: —Ndá sa̱ha̱ ndítúhún ndó xi̱hín na̱ ja̱n —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","In da̱ cándichi cán na̱nducú ñehe da tu̱hun nu̱ Jesús já cáchí da̱ já: —Maestro, yóho ñéhe e̱ ja̱hyí i̱ na̱casa̱a̱ i̱ nu̱ ndó jáchi̱ ndáca̱a̱n in ínima̱ quini ini da ta na̱ndaja níhi̱ ñahá ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ndá na̱cuu tíin rí da̱, jándacava rí da̱ nu̱ ñúhu̱ ta já cásáhá cána cuyu chi̱qui̱ñu̱ yúhu̱ dá ta cáhñá nu̱hu̱ dá. Xi̱hín ña̱ yóho cásáhá jácuitá rí da̱. Ta sa̱ na̱xi̱ca̱ i̱ ña̱ma̱ni̱ nu̱ú na̱ xíca tuun xi̱hi̱n ndó ña̱ ná tavá na̱ mé ínima̱ quini yóho joo co̱ó na̱cuu caja na ña̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Já na̱cachi Jesús já xi̱hi̱n ná: —Ndáhví na̱há na̱cuu ndó jáchi̱ sa̱ cua̱há ndiva̱ha qui̱vi̱ íin i̱ xi̱hi̱n ndo̱ ta a̱ ñáha candeé ini ndó ye̱he̱. Ta chí co̱ ndeé ga̱ ini i̱ xi̱hín ña̱ cája ndó. Taxi ndó da̱ loho ja̱n chóho —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chí ñéhe na da̱ loho cán na̱sa̱a̱ na̱ nu̱ Jesús. Ta tá na̱xini mé rí quini ndáca̱a̱n ini da̱ loho Jesús i̱vi̱ la̱á na̱caja rí ña̱ ná quivi yi̱hí da̱ loho cán já tíví núu da na̱ndicava da nu̱ ñúhu̱ xi̱hín chi̱qui̱ñu̱ cána yúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús tátá da̱ cán já cáchí a̱ já xi̱hi̱n dá: —Á sa̱nahá ndóho ja̱hyún ña̱ yóho —na̱cachi a. Já na̱cachi tátá da̱ cán já: —Ja̱nda̱ tá loho da cája rí já xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ta cua̱há tañu chíca̱a̱n rí quini da ini yávi̱ núhu̱ xi̱hín ini ticui̱í viti ña̱ cahní ñahá ri̱ cúni̱ ri̱. Ña̱ cán quéa̱ xíca̱ ta̱hví i̱ nu̱ ndó ña̱ ná candáhví loho ini ndó nde̱he̱ ta chindeé ndó nde̱he̱ tá ta̱ cuu caja ndó ña̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","A̱nda̱ já cáchí Jesús já xi̱hi̱n dá: —Cuu caja i̱ ña̱ tá cándúsún ye̱he̱. Jáchi̱ cuu caja i̱ tócó ndihi ña̱ha xi̱hín ña̱yivi tá cándeé ini na ye̱he̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","I̱vi̱ la̱á na̱cayuhú tátá mé da̱ loho cán já cáchí da̱ já: —Cándúsa vi̱ joo chindeé ndó ye̱he̱ ná candúsa chága̱ i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ta tá na̱xini Jesús ña̱ na̱casáhá chútú cua̱há ña̱yivi já na̱ndicue̱he̱ mé á xi̱hi̱n mé rí quini cán já cáchí a̱ já xi̱hi̱n ri̱: —Ínima̱ quini, rí na̱ndaja níhi̱ ta na̱ndaja jóho̱ da̱ loho yóho, sáhndá i̱ chuun nu̱u̱n ña̱ ná queún cu̱hu̱n ta a̱ ndícó co̱o ga̱ún ndi̱hvún ini da —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A̱nda̱ já na̱cayuhú cóhó rí quini cán já na̱sahní yi̱hí tucu rí da̱. Chí na̱queta rí cua̱ha̱n rí ta na̱jándacoo rí da̱ loho cán tátu̱hun in ndi̱i sa̱há ña̱ cán quéa̱ na̱casáhá cáchí ña̱yivi ña̱ sa̱ na̱xi̱hi̱ va da̱ ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Joo na̱tiin Jesús ndáha̱ dá já na̱ndiñehe a da̱. Ta já na̱nda̱ca̱ ndichi da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ta tá na̱ndi̱hvi Jesús ini in vehe xi̱hín na̱ xíca tuun xi̱hi̱n á já na̱nda̱ca̱ tu̱hún je̱hé na̱ mé á já cáchí na̱ já xi̱hi̱n á: —Ndáva̱ha co̱ó na̱cuu caja nde̱he̱ tavá nde̱ ínima̱ quini na̱sa̱ndaca̱a̱n ini da̱ loho ja̱n —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Já na̱cachi Jesús já xi̱hi̱n ná: —Tá cúni̱ ndó tavá ndo̱ tá ínima̱ quini táhan rí yóho ndítahan cajuhun ndó ta ca̱ca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tá na̱quee na cua̱ha̱n na̱ na̱ya̱ha na chí estado Galilea ta co̱ cúni̱ Jesús ña̱ ná canda̱a̱ ini ña̱yivi ");
INSERT INTO mksNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","jáchi̱ jána̱ha̱ Jesús nu̱ú na̱ xíca tuun xi̱hi̱n á cúni̱ a̱. Ta cáchí a̱ xi̱hi̱n ná ña̱ va̱xi qui̱vi̱ ndiquia̱hva ña̱yivi mé á, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ndahá ña̱yivi ta cahní ñahá na̱ joo tá ná ya̱ha u̱ni̱ qui̱vi̱ nditacu tucu a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Joo co̱ó na̱canda̱a̱ ini na ña̱ cáha̱n xi̱hi̱n ná ta yíhví na̱ nda̱ca̱ tu̱hún na̱ mé á sa̱há tu̱hun cáha̱n. ");
INSERT INTO mksNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ta ndaja coo na̱xi̱nu̱ na̱ ñuu Capernaum ta tá sa̱ ndúu na vehe já na̱casáhá ndáca̱ tu̱hún Jesús na̱ xíca tuun xi̱hi̱n á já cáchí a̱ já xi̱hi̱n ná: —Ndía̱ ndítúhún ndó sa̱ha̱ tá va̱xi ndó íchi̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Joo co̱ó na̱nducú ñehe na̱ cán tu̱hun nu̱ á jáchi̱ íchi̱ nu̱ú na̱quixi na na̱nditúhún cua̱ha̱ ná sa̱ha̱ ndá da̱ cúú da̱ cáhnu chága̱ tañu mé ná. ");
INSERT INTO mksNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A̱nda̱ já na̱sa̱co̱o Jesús já na̱cana ndíhu̱xu̱ i̱vi̱ da̱ xíca tuun xi̱hi̱n á já na̱casáhá cáchí a̱ já xi̱hi̱n dá: —Ndá ndó, na̱ cúni̱ cacuu na̱ nu̱ cuítí ndítahan ndaja núu ndó mé ndó cacuu ndó na̱ nu̱ ndíhí ta caja ndíví ndo̱ nu̱ ndíhi na —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tá na̱ndihi já na̱cana Jesús in da̱ loho já na̱sacu a da̱ ma̱hñú nu̱ ndúu na já na̱sa̱ñehe ndaa da̱ já na̱casáhá cáchí a̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ndá na̱ ná ndiquehe va̱ha in da̱ loho tátu̱hun da̱ yóho sa̱há ña̱ quíhvi̱ ini na ye̱he̱, ndíquehe ri na ye̱he̱ viti. Ta ndá na̱ ndíquehe ye̱he̱, a̱ ju̱ú in túhún ye̱he̱ ndíquehe na va̱ha jáchi̱ ndíquehe ri na tátá i̱, mé a̱ na̱chindahá ye̱he̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A̱nda̱ já na̱cachi Juan já: —Maestro, na̱xini nde̱ in da̱ta̱a ta cáha̱n da̱ qui̱vi̱ mé ndó já tává da̱ ínima̱ quini ñúhu ini ña̱yivi. Joo co̱ xíca nuu da xi̱hín yo̱ sa̱há ña̱ cán quéa̱ na̱saji nuu nde̱ nu̱ dá caja da ña̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Joo na̱cachi Jesús já: —A̱ cájí nuu ndó nu̱ dá jáchi̱ tá cája in na ña̱ xitúhún xi̱hín qui̱ví i̱ já quéa̱ a̱ cu̱ú caca nuu na ca̱ha̱n núu na sa̱há i̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jáchi̱ ndá na̱ co̱ ndíndita caja xíxi xo̱ho̱, mé na̱ cán cua̱ha̱n na̱ xoo mí. ");
INSERT INTO mksNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ta ndá na̱ ná quia̱hva in ña̱ha nu̱ ndó va̱tí in yáxi̱ ticui̱í sa̱há ña̱ ndíco̱ ndó ye̱he̱ mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ cha̱hvi tá cha̱hvi Ndióxi̱ sa̱há ña̱ma̱ni̱ cája na xi̱hi̱n ndó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ta cáchí tucu Jesús já: —Ndá na̱ ná jándacava in na̱ nda̱hví, na̱ cándeé ini ye̱he̱ nu̱ú cua̱chi ja̱nda̱ va̱ha chága̱ ná candi̱co̱ in yu̱ú yo̱jó ji̱co̱ ná ta ná ndihi sa̱há na̱ ca̱há tañu̱hú. ");
INSERT INTO mksNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tá ndáha̱ ndo̱ quéa̱ jándacava ndo̱hó nu̱ú cua̱chi chitúhu̱n ndó a̱ jáchi̱ va̱ha chága̱ ná cu̱hu̱n ndó indiví xi̱hín in túhún ndáha̱ ndo̱ a̱ ju̱ú ga̱ cu̱hu̱n ndó xi̱hi̱n ndíví ndáha̱ ndo̱ indayá nu̱ú co̱ ndáhva̱ ñúhu̱ cáyi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ta cán ni ticu̱jú co̱ xíhi̱ ni ñúhu̱ cáyi̱ co̱ ndáhva̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tá sa̱ha̱ ndo̱ quéa̱ jándacava ndo̱hó nu̱ú cua̱chi chitúhu̱n ri ndó ña̱ ja̱n va jáchi̱ va̱ha chága̱ ná cu̱hu̱n rénco̱ ndó indiví xi̱hín in túhún sa̱ha̱ ndo̱ a̱ ju̱ú ga̱ cu̱hu̱n ndó xi̱hi̱n ndíví sa̱ha̱ ndo̱ indayá nu̱ú co̱ ndáhva̱ ñúhu̱ cáyi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ta cán ni ticu̱jú co̱ xíhi̱ ta ni ñúhu̱ cáyi̱ co̱ ndáhva̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tá nduchú núú ndó quéa̱ jándacava ndo̱hó nu̱ú cua̱chi tavá ndó ña̱ jáchi̱ va̱ha chága̱ ná coo cóhó nu̱u̱ ndó cu̱hu̱n ndó nu̱ú cacomí Ndióxi̱ cuéntá sa̱ha̱ ndo̱ a̱ ju̱ú ga̱ ña̱ ná coo ndíví nduchú núú ndo̱ cu̱hu̱n ndó indayá. ");
INSERT INTO mksNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ta cán ni co̱ xíhi̱ ticu̱jú ta ni ñúhu̱ cáyi̱ co̱ ndáhva̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ʼTá quia̱hva ndívií jiu̱hún cuáán cája ñúhu̱ cáyi̱ quia̱hva já ndivií ínima̱ ña̱yivi xi̱hín ña̱ ndóho ini na. Ta tócó ndihi ña̱ha jóco̱ na̱ nu̱ Ndióxi̱ chíca̱a̱n na̱ ñi̱i̱ yívi na já co̱ tíví a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Va̱ha va cája ñi̱i̱ jáchi̱ xi̱hín ñi̱i̱ ndíha̱ji̱ ña̱ xíxi na joo tá co̱ óhva̱ ña̱ já a̱ cu̱ú caja o̱hva̱ tucu yó a̱ já ná caja chúun tucú ña̱. Ndítahan nu̱ ndóhó caja ndó tátu̱hun cája ñi̱i̱ ta já canduu vií xi̱hi̱n táhan ndó —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Na̱quee Jesús ñuu Capernaum cua̱ha̱n. Já na̱sa̱ha̱n estado Judea xi̱hín ñundáhyi̱ íin inga xoo yu̱ta Jordán. Cán na̱casáhá na̱nditaca tucu ña̱yivi nu̱ á chí jána̱ha̱ tucu a na̱ tá quia̱hva na̱ca̱an mé á cája. ");
INSERT INTO mksNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A̱nda̱ já na̱cayati java na̱ fariseo nu̱ Jesús sa̱há ña̱ coto ndojó ñahá na̱ cúni̱ na̱. Na̱cachi na já xi̱hi̱n á: —Á núná nu̱ú in da̱ta̱a jándacoo da ñájíhí da̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Já na̱nducú ñehe Jesús tu̱hun nu̱ ná já cáchí a̱ já xi̱hi̱n ná: —Ndaja cáchí ley Moisés ña̱ ndítahan caja ndó —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A̱nda̱ já na̱cachi na̱ cán já: —Tá ná quia̱hva in da̱ta̱a in tutu nu̱ ñájíhí da̱ sa̱há ña̱ cúni̱ da̱ jándacoo da ña̱ já quéa̱ sáhan ley Moisés ña̱ma̱ni̱ jándacoo da ña̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Sáhan ley Moisés ña̱ma̱ni̱ yóho nu̱ ndo̱ jáchi̱ táhyí ndiva̱ha ínima̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Joo ja̱nda̱ mé sa̱ha̱ tá na̱cava̱ha Ndióxi̱ ña̱yivi nu̱ cuítí já na̱cava̱ha in túhún ta̱a xi̱hín in túhún ñáha̱. ");
INSERT INTO mksNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sa̱há ña̱ cán quéa̱ ndítahan nu̱ú da̱ta̱a jándacoo da tátá da̱ xi̱hi̱n náná da̱ já ndique táhan da xi̱hi̱n ñájíhí da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Já xi̱nu̱ ndíví na̱ cán cacuu na tátu̱hun in víxí yiquí cu̱ñu na sa̱há ña̱ cán quéa̱ co̱ cúú ga̱ na̱ i̱vi̱ yiquí cu̱ñu sa̱há ña̱ na̱nduu na tátu̱hun in túhún yiquí cu̱ñu. ");
INSERT INTO mksNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Sa̱há ña̱ cán quéa̱ co̱ ndítahan nu̱ú na̱ cán janí táhan na ña̱ na̱jácatáhan Ndióxi̱ tá na̱tanda̱ha̱ ná —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ta tá na̱ndicó co̱o tucu na vehe já na̱casáhá tucu na̱ xíca tuun xi̱hi̱n á cán ndáca̱ tu̱hún na̱ Jesús sa̱há ña̱ na̱ca̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ta na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já: —Tá ná jándacoo in da̱ta̱a ñájíhí da̱ ta tánda̱ha̱ dá xi̱hín inga ñáñáha̱ já quéa̱ cája da cua̱chi nu̱ ñájíhí nu̱ú da̱ jáchi̱ íin da xi̱hín inga ñáha̱. ");
INSERT INTO mksNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ta tá ná jándacoo in ñáñáha̱ yíi̱ ña̱ ta tánda̱ha̱ ñá xi̱hín inga da cája ri ñá cán va cua̱chi nu̱ yíi̱ ña̱ jáchi̱ íin ñá xi̱hín inga da̱ta̱a —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A̱nda̱ já ñéhe na java na̱ va̱lí na̱casa̱a̱ na̱ nu̱ Jesús ña̱ ná cani ndaa ndáha̱ á na̱. Joo mé na̱ xíca tuun xi̱hi̱n á cán na̱casáhá na̱ cája cue̱he̱ na̱ xi̱hi̱n mé na̱ ndáca na̱ va̱lí cán. ");
INSERT INTO mksNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tá na̱xini Jesús ña̱ cája na já na̱ndicue̱he̱ a̱ já cáchí a̱ já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Quia̱hva ndó ña̱ma̱ni̱ ná quixi na̱ va̱lí nu̱ú i̱ ta a̱ cájí nuu ndó nu̱ ná jáchi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi tá ná caja na tá quia̱hva cája na̱ va̱lí yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ndá na̱ co̱ cúni̱ ndiquia̱hva na mé ná ndáha̱ Ndióxi̱ tátu̱hun cája na̱ va̱lí yóho já quéa̱ a̱ cúu cacomí Ndióxi̱ cuéntá sa̱ha̱ ná —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A̱nda̱ já na̱casáhá Jesús ñéhe ndaa na̱ va̱lí ta chínúu a ndáha̱ á ji̱ni̱ ná já cája yi̱i̱ á na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tá cua̱ha̱n tucu Jesús íchi̱ já xínu in da̱ta̱a na̱casa̱a̱ da̱ na̱saxítí da̱ nu̱ á já cáchí da̱ já xi̱hi̱n á: —Maestro, mé ndó cúú ndó ta̱a va̱ha ña̱ cán quéa̱ ndáca̱ tu̱hún i̱ ndo̱hó ndía̱ ndítahan caja i̱ já ná ñe̱he̱ táhvi̱ cu̱hu̱n i̱ indiví coo i̱ a̱nda̱ ama cáa qui̱vi̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Já na̱cachi Jesús já xi̱hi̱n dá: —Ndá cuéntá quéa̱ cáchún xi̱hín i̱ ña̱ cúú u̱ da̱ va̱ha. Ni in túhún toho ña̱yivi co̱ cúú ná na̱ va̱ha ñuyíví yóho. In túhún Ndióxi̱ cuití va quéa̱ va̱ha. ");
INSERT INTO mksNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Sa̱ xíni̱ vún ña̱ sáhndá Ndióxi̱ nu̱u̱n cajún já cáchí a̱ já: “Coto a̱ cóún xi̱hi̱n ñájíhí á yíi̱ ñani táhún. Coto a̱ cáhnún ndi̱i. Coto a̱ cája cuíhnún. Coto a̱ cáhún ña̱ tu̱hún sa̱há ña̱yivi. Coto a̱ jándahvún ña̱yivi. Ta caja cáhnún tátún xi̱hi̱n nánún” —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Já na̱cachi da̱ cán já: —Maestro, ja̱nda̱ tá na̱sacuu u̱ ta̱a loho na̱casáhá i̱ cája i̱ tócó ndihi ña̱ sáhndá Ndióxi̱ caja i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na̱sande̱hé Jesús nu̱ dá ta táhnda̱ ini a sa̱ha̱ dá já na̱cachi a já xi̱hi̱n dá: —Inga ña̱ha cáma̱ni̱ cajún: Cuáhán ji̱cún tócó ndihi ña̱hún ja̱n ta ndacahndún jiu̱hún ja̱n nu̱ú na̱ nda̱hví já ñe̱he̱ táhvu̱n coo cua̱há ña̱hún indiví. Ta tá na̱ndihi já quisún candi̱cún ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Joo tá na̱xini jo̱ho da̱ cui̱cá cán ña̱ na̱cachi Jesús i̱vi̱ la̱á na̱cavitá ini da já na̱quee cuéha̱ dá cua̱ha̱n da̱ jáchi̱ íin cua̱há ndiva̱ha ña̱ha da. ");
INSERT INTO mksNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","A̱nda̱ já na̱casáhá sánde̱hé Jesús nu̱ú na̱ xíca tuun xi̱hín a̱ cán já na̱cachi a já: —Ndaja yáncá ndiva̱ha cáa já ndiquia̱hva na̱ cui̱cá mé ná ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chí na̱catóntó mé na̱ xíca tuun xi̱hi̱n á cán sa̱há tu̱hun na̱ca̱ha̱n joo na̱ndica̱ha̱n tucu Jesús já cáchí a̱ já: —Ja̱hyi a, ndaja yáncá cáa sa̱há in na̱ cándeé ini jiu̱hún ndiquia̱hva na mé ná ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jáchi̱ ja̱nda̱ cama chága̱ cuu ya̱ha in camello ini in yávi̱ sa̱ha̱ yítu̱cú a̱ ju̱ú ga̱ ña̱ ná ndiquia̱hva in da̱ cui̱cá mé dá ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ dá —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A̱nda̱ já na̱catóntó ndihi mé na̱ xíca tuun xi̱hi̱n á cán tá na̱xini jo̱ho na ña̱ yóho. Já na̱casáhá ndáca̱ tu̱hún táhan na já cáchí na̱ já: —Ndá na̱ cúú na̱ cuu ca̱cu ndaa ínima̱, dá já —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Na̱ndicoto nihni Jesús nu̱ ná já cáchí a̱ já xi̱hi̱n ná: —Ni in na a̱ cúu caja ña̱ yóho joo Ndióxi̱ quéa̱ cuu caja ña̱ jáchi̱ ni in ña̱ha co̱ íhvi̱ toho nu̱ Ndióxi̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A̱nda̱ já na̱cachi Pedro já xi̱hín Jesús: —Joo nde̱he̱ na̱jándacoo ndihi nde̱ ña̱ na̱sa̱comí nde̱ ta ndíco̱ nde̱ ndo̱hó —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Já na̱nducú ñehe Jesús tu̱hun nu̱ ná já cáchí a̱ já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ndá na̱ jándacoo vehe na á ñani na á quia̱hva na á tátá na̱ á náná na̱ á ñájíhí na̱ á ja̱hyi na á ñundáhyi̱ ná sa̱há ye̱he̱ xi̱hín sa̱há tu̱hun cáha̱n i̱, ");
INSERT INTO mksNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na̱ cán cúú na̱ ñe̱he̱ cua̱ha̱ chága̱ ví ña̱ha ñuyíví yóho ja̱tá ña̱ na̱jándacoo na tátu̱hun vehe na, ñani na, quia̱hva na, náná na̱, ja̱hyi na, ñundáhyi̱ ná viti va̱tí ná ndicui̱ta ña̱yivi caja xíxi na xi̱hi̱n ná. Joo ñe̱he̱ táhvi̱ ná catacu na a̱nda̱ ama cáa qui̱vi̱ xi̱hi̱n Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ta ndúu cua̱há na̱ íin sa̱há ñuyíví yóho viti joo va̱xi qui̱vi̱ cacuu na na̱ co̱ó sa̱ha̱ nu̱ Ndióxi̱. Ta ndúu cua̱há na̱ co̱ó sa̱ha̱ ñuyíví yóho viti joo va̱xi qui̱vi̱ cacuu na na̱ íin sa̱ha̱ nu̱ Ndióxi̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ta ndaja coo cua̱ha̱n Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á chí íchi̱ ndáa cua̱ha̱n chí Jerusalén. Cánu̱u Jesús cua̱ha̱n xi̱hi̱n ná. Ta na̱catóntó na̱ cán ta yíhví na̱ cua̱ha̱n na̱ xi̱hi̱n á. A̱nda̱ já na̱tavá xóo tucu a ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hi̱n á já na̱casáhá cáha̱n xi̱hi̱n ná ña̱ ndoho a chága̱ chí nu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Já na̱cachi a já: —Cande̱hé ndo̱. Yóho ndáa í cua̱ha̱n yo̱ chí Jerusalén nu̱ú ndiquia̱hva na ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ndahá na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín nu̱ú na̱ jána̱ha̱ ley Moisés. Na̱ yóho cúú na̱ cacu ini sa̱há ndaja quivi i̱. A̱nda̱ já ndiquia̱hva na ye̱he̱ ndahá na̱ tóho̱. ");
INSERT INTO mksNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cua̱cu̱ ndaa na ye̱he̱ ta cani na ye̱he̱ ta cuihna na tóji̱í na̱ nu̱ú i̱ ta já cahní na̱ ye̱he̱. Joo tá ná ya̱ha u̱ni̱ qui̱ví nditacu tucu u̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A̱nda̱ já na̱cayati Jacobo xi̱hi̱n Juan, ja̱hyi Zebedeo nu̱ Jesús já na̱cachi da já xi̱hi̱n á: —Maestro, cúni̱ nde̱ ca̱ca̱ nde̱ in ña̱ma̱ni̱ nu̱ ndo̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Já na̱cachi Jesús já xi̱hi̱n dá: —Ndía̱ ma̱ni̱ cúni̱ ndó caja i̱ xi̱hi̱n ndo̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Já na̱cachi da̱ cán já xi̱hi̱n á: —Ña̱ xíca̱ nde̱ nu̱ ndo̱ quéa̱ ná quia̱hva ndó ña̱ma̱ni̱ nu̱ú nde̱ caco̱o in in nde̱ xoo jíi̱n ndo̱. In nde̱ coo xoo cuáha ta in nde̱ coo xoo íti jíi̱n mé ndó indiví nu̱ú coo ndó cacomí ndó cuéntá sa̱há ña̱yivi —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Co̱ cánda̱a̱ ini ndó ña̱ xíca̱ ndó nu̱ú i̱. Á cuu ndoho ini ndó tá quia̱hva ndítahan nu̱ú i̱ ndoho ini i̱. Jáchi̱ ña̱ va̱xi nu̱ú i̱ ndoho ini i̱ cúú á tátu̱hun coho i̱ in yáxi̱ ndutá o̱va̱. Á íin tia̱hva ndó ndoho ini ndó tá quia̱hva nditahan nu̱ú i̱ ndoho ini i̱ a̱nda̱ quia̱hva ná quivi i̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Já na̱cachi da̱ cán já: —Cuu caja nde̱ ña̱. Já na̱cachi Jesús já xi̱hi̱n dá: —Mé a̱ nda̱a̱ tandaa qui̱vi̱ coho ndó ña̱ o̱va̱ ñúhu ini yáxi̱, mé ña̱ coho i̱. Ta tandaa qui̱vi̱ ndoho ndiva̱ha ini ndó tá quia̱hva ndoho ini i̱ a̱nda̱ quia̱hva ná quivi i̱. ");
INSERT INTO mksNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Joo sa̱há ña̱ caco̱o in ndó xoo cuáha i̱ ta in ndó xoo íti i̱ a̱ ju̱ú nu̱ú i̱ quia̱hva i̱ ña̱ nu̱ ndo̱. Jáchi̱ sa̱ na̱ndica̱xi Ndióxi̱ na̱ ñe̱he̱ táhvi̱ caco̱o cán —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tá na̱xini jo̱ho u̱xu̱ chága̱ na̱ xíca tuun xi̱hi̱n Jesús cán ña̱ yóho já na̱casáhá xójo̱ ini na xi̱hi̱n Jacobo xi̱hi̱n Juan viti. ");
INSERT INTO mksNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Joo na̱cana Jesús na̱ já na̱cachi a já xi̱hi̱n ná: —Sa̱ xíni̱ ndó ndaja cája na̱ sáhndá chuun nu̱ú ña̱yivi ndúu ñuyíví yóho. Ña̱ cája na quéa̱ jácandíhi na ña̱yivi ta cája na tá quia̱hva cúni̱ mé ná. ");
INSERT INTO mksNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Joo co̱ ndítahan coo ña̱ cán tañu mé ndó jáchi̱ ndá da̱ cúni̱ cacuu da̱ cáhnu chága̱ tañu ndó xíní ñúhú cacuu da in da̱ cája ndíví nu̱ú ndihi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ta ndá da̱ cúni̱ cacuu ta̱a nu̱ cuítí tañu ndóhó ndítahan cacuu da da̱ cája ndíví nu̱ ndihi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jáchi̱ ni ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi co̱ó na̱quixi i̱ ñuyíví yóho ña̱ ná caja ndíví ña̱yivi nu̱ú i̱. Ña̱ na̱quixi i̱ caja i̱ quéa̱ caja ndíví i̱ nu̱ ná ta ndiquia̱hva i̱ mí i̱ quivi i̱ já ná cuu ca̱cu ndaa ínima̱ cua̱há ña̱yivi ná a̱ cúhu̱n na̱ indayá —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","A̱nda̱ já na̱xi̱nu̱ na̱ ñuu Jericó. Ta tá sa̱ na̱queta tucu Jesús cua̱ha̱n ja̱tá ñuu cán xi̱hín na̱ xíca tuun xi̱hi̱n á xi̱hín cua̱há ga̱ ña̱yivi ta mé yuhú íchi̱ cán íin coo in da̱ cua̱á naní Bartimeo, ja̱hyi Timeo sáti da. ");
INSERT INTO mksNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ta tá na̱xini jo̱ho da ña̱ cáyati Jesús, da̱ ñuu Nazaret va̱xi da já na̱casáhá mé da̱ cua̱á cán cáyuhú cóhó da̱ já cáchí da̱ já: —Jesús, da̱ na̱quixi chi̱chi David caja ndó ña̱ma̱ni̱ candáhví loho ini ndó ye̱he̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Joo na̱casáhá cua̱há ña̱yivi cája cue̱he̱ na̱ xi̱hi̱n dá ña̱ ná caji da yúhu̱ dá. Joo ví ga̱ ví cáyuhú da̱ já cáchí da̱ já: —Ndóhó, da̱ na̱quixi chi̱chi David caja ndó ña̱ma̱ni̱ candáhví loho ini ndó ye̱he̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","A̱nda̱ já na̱nda̱ca̱ ndichi Jesús já na̱cachi a já: —Cana ndó da̱ ná quixi da. Já na̱cana na da̱ cua̱á cán já cáchí na̱ já xi̱hi̱n dá: —A̱ ndícani inún. Candichi jáchi̱ cána Jesús yo̱hó —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A̱nda̱ já na̱jácana da cotó ndeé da̱ ta na̱nda̱ca̱ ndichi da já na̱sa̱a̱ da̱ nu̱ íin Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús da̱ já cáchí a̱ já xi̱hi̱n dá: —Ndía̱ cúnu̱n ná caja i̱ xu̱hu̱n. Já na̱cachi mé da̱ cua̱á cán já: —Cande̱hé e̱ cúni̱, xitoho. ");
INSERT INTO mksNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Já na̱cachi Jesús já xi̱hi̱n dá: —Cuu nu̱hu̱ vún viti. Sa̱ na̱ndiva̱hún jáchi̱ na̱candeé inún ye̱he̱ —na̱cachi a. Chí i̱vi̱ la̱á na̱nda̱ca̱ nde̱hé da̱ cua̱á cán. Já na̱ndi̱co̱ da̱ Jesús íchi̱ cán cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tá na̱xi̱nu̱ na̱ yati ñuu Jerusalén jíi̱n ñuu Betfagé xi̱hín ñuu Betania ña̱ ndíque táhan nu̱u̱ xi̱hi̱n yúcu̱ yitó Olivo já na̱sahnda Jesús chuun nu̱ú i̱vi̱ da̱ xíca tuun xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Já cáchí a̱ já xi̱hi̱n dá: —Cuáhán ndo̱ ñuu loho ndáca̱a̱n yati ja̱n. Tá ná xi̱nu̱ co̱o ndó ja̱n ndiñe̱he̱ ndó in búrro̱ ndíco̱ ndaa, rí cáma̱ni̱ yi̱i̱ ndaa na. Ndaxí ndó ri̱ ta cañehe ndó ri̱ quixi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ta ndá na̱ ná nda̱ca̱ tu̱hún ndo̱hó sa̱ha̱ ri̱ já quéa̱ cachi ndó xi̱hi̱n ná ña̱ xíní ñúhú xitoho ndó ri̱ viti joo tá ná ndihi chuun rí já ndixi tucu rí, já cachi ndó xi̱hi̱n ná —na̱cachi Jesús xi̱hi̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ta na̱quee da̱ cán cua̱ha̱n da̱ já na̱ndiñe̱he̱ dá mé búrro̱ cán ndíco̱ ndaa rí jíi̱n yéhé yuhú íchi̱ já na̱ndaxí da̱ ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ta ndaja coo java na̱ ndúu cán na̱casáhá cáchí na̱ já: —Ndía̱ cája ndó. Ndáva̱ha ndáxí ndo̱ búrro̱ ja̱na̱ nde̱ ja̱n —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A̱nda̱ já na̱nducú ñehe mé da̱ xíca tuun xi̱hi̱n Jesús cán tu̱hun nu̱ ná ta na̱cachi da tá quia̱hva na̱cachi Jesús xi̱hi̱n dá. A̱nda̱ já na̱ñe̱he̱ dá ña̱ma̱ni̱ cañehe da rí cu̱hu̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tá na̱ndihi já ñéhe da búrro̱ cán na̱casa̱a̱ da̱ nu̱ Jesús já na̱chojó da̱ cotó ndéé da̱ ja̱ta̱ ri̱ já na̱ndaa Jesús ja̱ta̱ ri̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta cua̱há ña̱yivi na̱casáhá na̱ chínduu na cotó ndéé na̱ íchi̱ ta java na na̱casáhá na̱ sáhndá na̱ ndáha̱ yíto̱ já chínduu na do̱ íchi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ta na̱ cua̱ha̱n chí nu̱u̱ ta jári na̱ va̱xi chí ja̱ta̱ na̱casáhá na̱ cáyuhú na̱ já cáchí na̱ já: —Cája cáhnu í Ndióxi̱. Ndicáhnu na̱há ná cacuu da̱ cómí cuéntá sa̱ha̱ yo̱ jáchi̱ cúú dá da̱ va̱xi yuhú nu̱u̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Cáhnu ná coo qui̱ví tá casáhá Ndióxi̱ cacomí a̱ cuéntá sa̱ha̱ yo̱. Tá quia̱hva na̱sa̱comí David, tátá yo̱ cuéntá sa̱há ña̱yivi sa̱nahá quia̱hva já cacomí mé á cuéntá sa̱ha̱ yo̱. Cáhnu ná cacuu Ndióxi̱ —cáchí ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A̱nda̱ já na̱ndi̱hvi Jesús ñuu Jerusalén ta já na̱xi̱nu̱ a̱ veñu̱hu cáhnu cán. Ta tá na̱ndihi na̱sande̱hé ndihi a níí xoo cán já na̱quee a cua̱ha̱n chí ñuu Betania xi̱hi̱n ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hi̱n á jáchi̱ sa̱ na̱hini ta cua̱ha̱n cuáá va. ");
INSERT INTO mksNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tá na̱quee na Betania inga qui̱vi̱ ita̱a̱n já na̱casáhá cuíco Jesús cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tá na̱xini xícá a̱ in titó ñu̱hú va̱ha dó ndoco ndáha̱. Na̱sa̱ha̱n Jesús sánde̱hé a̱ á íin cui̱hi nu̱ do̱ joo co̱ rí ná ñe̱he̱ a̱. Ndáha̱ uun va dó cán íin jáchi̱ a̱ ju̱ú tiempo coo rí cán que̱á. ");
INSERT INTO mksNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A̱nda̱ já na̱ca̱ha̱n Jesús xi̱hín titó ñu̱hú cán já cáchí a̱ já xi̱hi̱n do̱: —Ni in ga̱ na̱ a̱ cáxí ga̱ cui̱hi nu̱ yóhó —cáchí a̱ xi̱hi̱n do̱. Ta na̱xini jo̱ho na̱ xíca tuun xi̱hi̱n á cán tu̱hun yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tá na̱ndihi já na̱xi̱nu̱ na̱ Jerusalén. Ta tá na̱ndi̱hvi Jesús veñu̱hu cáhnu cán já na̱casáhá táxí a̱ na̱ ndúu jícó cán xi̱hín na̱ ndúu xéen viti. Ta na̱xicó ñehe a mesa na̱ ndúu ndíjama jiu̱hún ña̱yivi ta na̱xicó ñehe a táyi̱ sáco̱o na̱ ndúu jícó ndíja̱ta. ");
INSERT INTO mksNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ta chí co̱ó na̱sa̱ha̱n ña̱ma̱ni̱ nu̱ú ña̱yivi cañehe na ña̱ha ndi̱hvi na veñu̱hu. ");
INSERT INTO mksNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A̱nda̱ já na̱casáhá jána̱ha̱ nu̱ ná já cáchí a̱ já xi̱hi̱n ná: —Já cáchí tu̱hun Ndióxi̱: “Vehe mí i̱ cacuu a vehe nu̱ú quixi na ca̱ca̱ ta̱hví na̱ nu̱ú i̱ sa̱ha̱ tócó ndihi ña̱yivi ñuyíví”, cáchí tu̱hun Ndióxi̱. Joo ndóhó na̱ndai cuu ndó yóho caja cuíhná ndo̱ nu̱ú ña̱yivi —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tá mé na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán xi̱hín na̱ jána̱ha̱ ley Moisés na̱xini jo̱ho na ña̱ yóho já na̱casáhá na̱ ndúcú na̱ ndá quia̱hva cahní na̱ a̱ jáchi̱ yíhví ñahá na̱ sa̱há ña̱ cátóntó ndihi ña̱yivi xi̱hín ña̱ jána̱ha̱ mé á nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Joo tá na̱cuaá já na̱quee Jesús ñuu cua̱ha̱n xi̱hín na̱ xíca tuun xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ta naha chá inga qui̱ví ita̱a̱n na̱ya̱ha na nu̱ cándichi mé titó ñu̱hú cán já na̱xini na ña̱ na̱hi̱chi̱ do̱ ja̱nda̱ yóho̱ do̱ na̱hi̱chi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A̱nda̱ já na̱ndicu̱hu̱n ini Pedro sa̱ha̱ mé titó ñu̱hú já cáchí da̱ já xi̱hi̱n Jesús: —Maestro, cande̱hé ndó titó ñu̱hú, dó na̱ca̱ha̱n cue̱he̱ ndó xi̱hi̱n. Sa̱ na̱hi̱chi̱ dó viti —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Já na̱cachi Jesús já xi̱hi̱n dá: —Candeé ini ndó Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Jáchi̱ mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ná cachi ndó xi̱hi̱n yúcu̱ yóho: “Caxoo ta cuáhán jáque̱tún mún ini tañu̱hú”, ta tá co̱ cáhvi i̱vi̱ jo̱ho ini ndó ta tá candúsa ndó coo tá íin cáchí ndó ta chí já ndusa coo. ");
INSERT INTO mksNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sa̱há ña̱ cán quéa̱ cáchí i̱ xi̱hi̱n ndo̱ ña̱ tócó ndihi ña̱ha xíca̱ ta̱hví ndó nu̱ Ndióxi̱ ta tá cándúsa ndó ña̱ sa̱ na̱ñe̱he̱ ndó a̱ já quéa̱ ñe̱he̱ ndusa ndó a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ta tá ndúu ndó xíca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ xíní ñúhú caja cáhnu ini ndó sa̱ha̱ ndá na̱ xójo̱ ini ndó xi̱hi̱n já ná caja cáhnu ri ini Ndióxi̱, tátá ndo̱ ña̱ íin indiví sa̱há cua̱chi ndó. ");
INSERT INTO mksNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Joo tá co̱ cája cáhnu ini ndó sa̱há ña̱yivi já quéa̱ ni Ndióxi̱, tátá ndo̱ ña̱ íin indiví a̱ cája cáhnu ini a sa̱há cua̱chi ndó —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","A̱nda̱ já na̱ndicó co̱o tucu na ñuu Jerusalén. Ta tá xíca Jesús chí veñu̱hu cáhnu cán já na̱cayati na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Já na̱nda̱ca̱ tu̱hún na̱ Jesús já cáchí na̱ já xi̱hi̱n á: —Yo já sáhan ña̱ma̱ni̱ nu̱u̱n cajún ña̱ cájún yóho —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Já na̱cachi Jesús já xi̱hi̱n ná: —Ná nda̱ca̱ tu̱hún ri ye̱he̱ va ndo̱hó ta tá ná nducú ñehe ndó tu̱hun nu̱ú i̱ a̱nda̱ já ca̱xi tu̱hun i̱ nu̱ ndo̱ yo já na̱sa̱ha̱n ña̱ma̱ni̱ nu̱ú i̱ caja i̱ ña̱ cája i̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Cachi ndó xi̱hín i̱ yo já na̱chindahá Juan ña̱ ná quixi da caja ndúta̱ da̱ ña̱yivi. Á Ndióxi̱ na̱chindahá da̱, á ña̱yivi na̱chindahá ñahá. Nducú ñehe quíi̱ ndó tu̱hun nu̱ú i̱ viti —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A̱nda̱ já na̱casáhá ndítúhún xi̱hi̱n táhan na̱ cán já cáchí na̱ já: —Tá ná cachí ña̱ Ndióxi̱ quéa̱ na̱chindahá Juan ta já nducú nehe Jesús tu̱hun nu̱ yo̱ já cachi da̱ xo̱ho̱: “Ndá cuéntá quéa̱ co̱ó na̱xeen ndó candúsa ndó da̱, dá já”, cachi Jesús xo̱ho̱. ");
INSERT INTO mksNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ta tá ná cachí: “Ña̱yivi cúú na̱ na̱chindahá Juan”, já ndicui̱ta ña̱yivi xi̱hi̱n yo̱ —na̱cachi na ndítúhún xi̱hi̱n táhan na. Já cáchí na̱ jáchi̱ yíhví na̱ ña̱yivi jáchi̱ tócó ndihi ña̱yivi na̱ca̱hán na̱ sa̱ha̱ Juan ña̱ cúú dá da̱ na̱chindahá Ndióxi̱ jáya̱ha da tu̱hun cáha̱n mé á nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sa̱há ña̱ cán quéa̱ na̱cachi na já xi̱hi̱n Jesús: —Co̱ xíni̱ toho nde̱ yo na̱chindahá Juan. A̱nda̱ já na̱cachi a já xi̱hi̱n ná: —Ta ni ye̱he̱ a̱ cáxi tu̱hun i̱ nu̱ ndo̱ yo já na̱sa̱ha̱n ndée̱ nu̱ú i̱ caja i̱ ña̱ yóho —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","A̱nda̱ já na̱casáhá Jesús sácú a̱ quia̱hva nu̱ú ña̱yivi já na̱cachi a já xi̱hi̱n ná: —Na̱sahi̱in in da̱ta̱a na̱jánde̱e cua̱ha̱ dá tó uva nu̱ ñúhu̱ dá ta já na̱sacu da in corra yíto̱ nu̱ do̱. Ta na̱cava̱ha da in nu̱ú cu̱hni̱ mé uva cán ña̱ cava̱ha vino. Ta na̱cava̱ha da in nu̱ jícó canúu da já cuu candaa da tócó ndihi dó cán. ʼTá na̱ndihi já na̱sa̱ha̱n ndojó da̱ ñúhu̱ dá nu̱ú java na caja chúun na ña̱ já na̱quee da cua̱ha̱n xícá da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ta tá na̱xi̱nu̱ tiempo jáquee na já na̱chindahá da̱ in mozo da̱ nu̱ú na̱ cája chúun ñúhu̱ da̱ cán ña̱ ná ndiquia̱hva na ña̱ cáni nu̱ dá ndiquehe da sa̱ha̱ ñúhu̱ da̱ ña̱ na̱sa̱ha̱n ndojó da̱ nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Joo mé na̱ cája chúun tóo ñúhu̱ cán na̱tiin na mozo da̱ cán já na̱cani na da̱. Tá na̱ndihi já na̱nducú ñehe na da̱ nu̱ú xitoho da joo co̱ó ña̱ha ná sa̱ha̱n na̱ nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A̱nda̱ já na̱chindahá tucu mé da̱ xi̱hín ña̱ha ñúhu̱ cán inga mozo. Joo da̱ yóho na̱caja xíxi tucu na xi̱hi̱n dá jáchi̱ na̱cani na da̱ xi̱hín yu̱u̱. Ta na̱jándicue̱he̱ na̱ ji̱ni̱ dá já na̱casáhá cána̱há na̱ xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ta mé da̱ xi̱hín ña̱ha ñúhu̱ cán na̱chindahá tucu da inga mozo da̱ ta na̱sahní na̱ da̱. Ta na̱chindahá cua̱há ga̱ da̱ mozo da̱ na̱sa̱ha̱n cán. Ta java da na̱cani na ta java da na̱sahní na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ʼNa̱cando̱o in túhún ja̱hyi mé da̱ xi̱hín ña̱ha ñúhu̱ cán ta quíhvi̱ ndiva̱ha ini da ja̱hyi da. Joo tá nu̱ ndíhí já na̱chindahá da̱ ja̱hyi da jáchi̱ cáhán da̱: “Cája i̱ cuéntá coo toní ñúhú na̱ xi̱hín ja̱hyí i̱”, na̱ca̱hán da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Joo mé na̱ cája chúun ñúhu̱ cán na̱casáhá ndítúhún xi̱hi̱n táhan na já cáchí na̱ já: “Cande̱hé ndo̱. Yóho va̱xi da̱ cúú ja̱hyi xitoho í. Ta tá ná xi̱nu̱ qui̱ví quivi xitoho í ta da̱ yóho cacuu da ndicojo chuun sa̱ha̱ ñúhu̱ yóho. Cóho̱ cahní yó da̱ já ná cando̱o ñúhu̱ yóho ndáha̱ mí”, na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A̱nda̱ já na̱tiin na da̱ cán ta na̱sahní na̱ da̱ já na̱jácana na yiquí cu̱ñu da ja̱ta̱ cútu̱ cán —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús ña̱yivi ndúu cán já cáchí a̱ já: —Á co̱ xíni̱ ndó ndía̱ caja da̱ xi̱hín ña̱ha ñúhu̱ yóho viti. Ña̱ caja da quéa̱ quixi da ta cahní ndihi da na̱ cája chúun tóo nu̱ ñúhu̱ dá. Já ndiquia̱hva da ñúhu̱ dá nu̱ú java ga̱ na̱ já ná caja chúun na nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ʼÁ co̱ xíni̱ ndó ña̱ cáchí tu̱hun Ndióxi̱. Ña̱ cáchí a̱ quéa̱: Mé yu̱u̱ ña̱ na̱jácana da̱ cáva̱ha vehe, ña̱ cán cúú ña̱ na̱nduu yu̱u̱ ndúhu̱ sa̱há vehe ña̱ íin chága̱ sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ña̱ yóho quéa̱ na̱caja Ndióxi̱ ta cúú á in ña̱ha cáhnu ndiva̱ha nu̱ yo̱, cáchí tu̱hun Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A̱nda̱ já na̱casáhá ndúcú na̱ sa̱cua̱ha̱ tiin na Jesús chica̱a̱n na a̱ veca̱a jáchi̱ na̱canda̱a̱ ini na ña̱ sa̱ha̱ mé ná na̱sacu a quia̱hva yóho. Joo sa̱há ña̱ yíhví na̱ ña̱yivi na̱jándacoo na a̱ ta na̱quee na cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tá na̱ndihi já na̱chindahá na̱ java na̱ fariseo xi̱hi̱n na̱ cúú cuéntá Herodes nu̱ Jesús ña̱ ná coto ndojó ñahá na̱ xi̱hín tu̱hun cáha̱n mé á já ná chica̱a̱n na̱ cua̱chi ja̱tá. ");
INSERT INTO mksNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","A̱nda̱ já na̱xi̱nu̱ na̱ nu̱ Jesús já cáchí na̱ já xi̱hi̱n á: —Maestro, xíni̱ nde̱ ña̱ ndinuhu ña̱ nda̱a̱ cáha̱n mé ndó. Ta co̱ quéhe ndó cuéntá tá cáha̱n núu ña̱yivi sa̱ha̱ ndo̱. Ta cánda̱a̱ ini nde̱ ña̱ tá cáha̱n ndó sa̱há in ña̱ha cája ña̱yivi cúú á sa̱há ña̱ sánde̱hé ndó ja̱nda̱ ínima̱ ná. Ta cánda̱a̱ ini nde̱ ña̱ jána̱ha̱ ndó ña̱ nda̱a̱ sa̱ha̱ íchi̱ cuéntá Ndióxi̱. Ta viti cúni̱ nde̱ nda̱ca̱ tu̱hún nde̱ ndo̱hó á ndítahan nu̱ú nde̱ cha̱hvi nde̱ jiu̱hún cuéntá impuesto nu̱ú da̱ cómí cuéntá sa̱ha̱ yo̱ ñuu Roma. Á cha̱hvi nde̱ ña̱, á a̱ cháhvi toho nde̱ ña̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Joo sa̱ na̱canda̱a̱ ini Jesús ña̱ co̱ cúú ná tá quia̱hva ndáa na ña̱ cán quéa̱ na̱cachi a já xi̱hi̱n ná: —Cánda̱a̱ cáxí táhyí ini i̱ ña̱ cúni̱ ndó coto ndojó cuití ndó ye̱he̱. Jána̱ha̱ ndó in táhan jiu̱hún ja̱n nu̱ú i̱ ná cande̱hé e̱ ña̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Já na̱sa̱ha̱n na̱ mé jiu̱hún cán nu̱ á ta tá na̱xini a ña̱ já na̱cachi a já xi̱hi̱n ná: —Yo na̱hná ta yo qui̱vi̱ quéa̱ ndáa̱ nu̱ á. Já na̱cachi na̱ cán já xi̱hi̱n á: —Ñéhe a qui̱vi̱ xi̱hín na̱hná da̱ cómí cuéntá sa̱ha̱ yó ñuu Roma —na̱cachi na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ndiquia̱hva ndó ña̱ha da̱ cómí cuéntá sa̱ha̱ ndó ñuu Roma ja̱n nu̱ dá. Ta ndiquia̱hva ndó nu̱ Ndióxi̱ ña̱ cúú ña̱ha mé á —na̱cachi a. Chí na̱catóntó mé na̱ cán sa̱há ña̱ na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A̱nda̱ já na̱sa̱ha̱n java na̱ saduceo ca̱ha̱n na̱ xi̱hín Jesús. Ta mé na̱ saduceo yóho co̱ cándúsa na ña̱ ndítacu tucu na̱ sa̱ na̱xi̱hi̱. Sa̱há ña̱ cán quéa̱ na̱nda̱ca̱ tu̱hún na̱ Jesús já cáchí na̱ já xi̱hi̱n á: ");
INSERT INTO mksNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, nu̱ ley na̱ca̱hyi̱ Moisés sa̱nahá na̱ta̱hnda̱ chuun ta cáchí a̱ já: “Tá tánda̱ha̱ in da̱ta̱a xi̱hi̱n ñájíhí da̱ ta tá co̱ó ja̱hyi ñá cácu xi̱hi̱n dá ta tá ná xi̱nu̱ qui̱vi̱ quivi da̱ cán já quéa̱ cáchí ley Moisés ña̱ ndítahan tanda̱ha̱ tucu ñájíhí da̱ xi̱hín da̱ cúú ñani mé ndi̱i cán já ná coo ja̱hyi da̱ cán xi̱hi̱n yuhú nu̱ú ñani da”, já cáchí ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ta viti cuni jo̱ho ndó ná cacu nde̱ in quia̱hva nu̱ ndó. Na̱sahi̱in u̱sa̱ ñani ta da̱ nu̱ cuítí na̱tanda̱ha̱ dá xi̱hi̱n in ñáñáha̱. Tá na̱ndihi na̱xi̱hi̱ da̱ joo co̱ó ja̱hyi da ná cacu xi̱hi̱n ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ta na̱tanda̱ha̱ ñani da, da̱ chí i̱vi̱ xi̱hi̱n ñá cuáa̱n cán. Ta já na̱xi̱hi̱ ri da̱ cán va ta ni da̱ yóho co̱ó na̱cacu ja̱hyi xi̱hi̱n ñájíhí ñani. Ta quia̱hva já na̱ndoho ri ñani da, da̱ chí u̱ni̱. ");
INSERT INTO mksNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","A̱nda̱ quia̱hva na̱xi̱nu̱ ndíhu̱sa̱ da̱ na̱tanda̱ha̱ xi̱hi̱n ña̱ ta ni in da co̱ó na̱cacu ja̱hyi xi̱hi̱n ña̱. Tá nu̱ ndíhí na̱xi̱hi̱ ri mé va ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ta viti ndáca̱ tu̱hún nde̱ ndo̱hó ndá da̱ cacuu ndusa yíi̱ ñá cán tá ná xi̱nu̱ qui̱vi̱ nditacu tucu ndi̱i jáchi̱ ndíhu̱sa̱ va ñani da̱ cán na̱tanda̱ha̱ xi̱hi̱n ñá —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já cáchí a̱ já xi̱hi̱n ná: —A̱ váha toho cáhvi ini ndó jáchi̱ co̱ xíni̱ ndó ndaja cáha̱n tu̱hun Ndióxi̱ ta ni co̱ xíni̱ ndó ndá quia̱hva cáhnu cúú ndée̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Jáchi̱ tá ná nditacu tucu ndi̱i a̱ tánda̱ha̱ ga̱ na̱ ta ni a̱ quiáhva na ja̱hyi jíhí na̱ tanda̱ha̱ ná. Cacuu na tátu̱hun táto̱ Ndióxi̱ ndúu indiví ta co̱ tánda̱há na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Joo sa̱ xíni̱ yo̱ ña̱ nditacu tucu ndi̱i. Á a̱ ñáha cahvi ndó ña̱ na̱ca̱hyí Moisés sa̱há ña̱ na̱ca̱ha̱n Ndióxi̱ xi̱hi̱n dá tañu tohíñú, dó cándaha ñúhu̱ cán. Já na̱cachi a já xi̱hi̱n dá: “Ye̱he̱ cúú Ndióxi̱ cája cáhnu Abraham ta ye̱he̱ cúú Ndióxi̱ cája cáhnu Isaac ta ye̱he̱ cúú Ndióxi̱ cája cáhnu Jacob”, na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ta ña̱ yóho cúni̱ cachi a ña̱ tácú yi̱i̱ va Abraham xi̱hín Isaac xi̱hín Jacob va̱tí sa̱ na̱xi̱hi̱ yiquí cu̱ñu na. Sa̱há ña̱ cán quéa̱ co̱ xíni̱ ndó ndá sa̱ha̱ cáha̱n ndo̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ta ndaja coo in da̱ jána̱ha̱ ley Moisés na̱cayati da nu̱ Jesús jáchi̱ sa̱ na̱xini jo̱ho da ña̱ na̱ca̱ha̱n Jesús xi̱hín na̱ ndúu cán. Sa̱há ña̱ xíni̱ da̱ ña̱ na̱nducú ñehe nda̱a̱ Jesús tu̱hun nu̱ú na̱ cán sa̱há ña̱ cán quéa̱ na̱nda̱ca̱ tu̱hún da̱ Jesús já cáchí da̱ já xi̱hi̱n á: —Ndía̱ cúú ña̱ cáhnu chága̱ sáhndá Ndióxi̱ caja í —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Já na̱cachi Jesús já xi̱hi̱n dá: —Ña̱ cáhnu chága̱ cúú ña̱ cáchí tu̱hun Ndióxi̱ yóho: “Taa jo̱ho ndó, na̱ Israel. Íin in túhún ji̱ni̱ Ndióxi̱ ta mé á cúú xitoho í. ");
INSERT INTO mksNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ta ndítahan qui̱hvi̱ ini ndó mé Ndióxi̱, xitoho ndó xi̱hi̱n tócó ndihi ínima̱ ndo̱ ta xi̱hi̱n ndinuhu ini ndó. Ta qui̱hvi̱ ini ndó a̱ xi̱hi̱n tócó ndihi xíní túni̱ ndo̱ ta xi̱hi̱n tócó ndihi ndée̱ ndo̱.” Ña̱ yóho cúú ña̱ nu̱ cuítí sáhndá Ndióxi̱ caja ndó. ");
INSERT INTO mksNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tá cúni̱ coo ña̱ nu̱ cuítí já cúni̱ coo ri ña̱ chí i̱vi̱ va ta cáchí a̱: “Qui̱hvi̱ ini ndó ñani táhan ndó tá quia̱hva quíhvi̱ ini ndó mé ndó.” Co̱ó ga̱ inga ña̱ sáhndá Ndióxi̱ caja ndó cacuu ña̱ cáhnu chága̱ nu̱ú ña̱ yóho —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A̱nda̱ já na̱cachi mé da̱ jána̱ha̱ ley Moisés cán xi̱hín Jesús: —Va̱ha chá na̱ca̱ha̱n ndó, Maestro. Mé a̱ nda̱a̱ quéa̱ na̱ca̱ha̱n ndo̱ ña̱ íin in tála̱á cuití Ndióxi̱ ta co̱ó inga ga̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ta ndítahan qui̱hvi̱ iní mé á xi̱hi̱n tócó ndihi ínima̱ yo̱ ta xi̱hi̱n ndinuhu iní ta xi̱hi̱n tócó ndihi xíní túni̱ yo̱ ta xi̱hi̱n tócó ndihi ndée̱ yo̱. Ta ndítahan qui̱hvi̱ iní ñani táhan í tá quia̱hva quíhvi iní mí. Ndíya̱hvi chága̱ ña̱ yóho a̱ ju̱ú ga̱ tócó ndihi ña̱ha jóco̱ na̱ nu̱ Ndióxi̱ ta ndíya̱hvi chága̱ ña̱ a̱ ju̱ú ga̱ ña̱ha chíca̱a̱n ñúhu̱ ná nu̱ náa̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tá na̱xini Jesús ña̱ na̱nducú ñehe va̱ha da̱ cán tu̱hun nu̱ á já cáchí a̱ já xi̱hi̱n dá: —Ja̱lóho cúni̱ ña̱ cacomí Ndióxi̱ cuéntá sa̱hu̱n —na̱cachi Jesús. Tá na̱ndihi cán ni in ga̱ na̱ co̱ó na̱sa̱ha̱n ndeé ini na nda̱ca̱ tu̱hún ga̱ na̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ndáca̱a̱n Jesús veñu̱hu cáhnu jána̱ha̱ nu̱ú ña̱yivi já cáchí a̱ já xi̱hi̱n ná: —Ndáva̱ha cáchí na̱ jána̱ha̱ ley Moisés ña̱ va̱xi Cristo chi̱chi David. ");
INSERT INTO mksNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ta sa̱ mé David tá na̱chutú nda̱a̱ ini da xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱ já na̱cachi da já: Já na̱cachi Ndióxi̱ xi̱hi̱n xitoho i̱: “Caco̱o xoo cuáha i̱ yóho, a̱nda̱ quia̱hva ná caja i̱ ña̱ ná cacomún cuéntá sa̱há na̱ co̱ cúní yo̱hó”, na̱cachi Ndióxi̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ndáva̱ha cáchí na̱ ña̱ va̱xi Cristo chi̱chi David joo mé tiempo cán na̱cachi David ña̱ cúú á xitoho da —na̱cachi Jesús. Ta cua̱ha̱ ndiva̱ha ña̱yivi cáji̱i̱ íní na̱ táa jo̱ho na nu̱ cáha̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tá jána̱ha̱ Jesús na̱ já cáchí a̱ já xi̱hi̱n ná: —Cuéntá coo ndó xi̱hín na̱ jána̱ha̱ ley Moisés jáchi̱ cátóó na̱ cándixi na jáhma̱ náni̱ caca nuu na. Ta cátóó na̱ ca̱ha̱n toní ñúhú ndiva̱ha ña̱yivi xi̱hi̱n ná tá xíca nuu na nu̱ú ya̱hvi. ");
INSERT INTO mksNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ta tá cua̱ha̱n na̱ veñu̱hu cátóó na̱ caco̱o na nu̱ sáco̱o na̱ íin chága̱ sa̱ha̱. Ta tá cua̱ha̱n na̱ víco̱ nu̱ú va̱ha cátóó na̱ coo na. Cuéntá coo ndó xi̱hín na̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jáchi̱ cándaa na vehe na̱ji̱hí cuáa̱n ta tá na̱ndihi cua̱há ndiva̱ha xíca̱ ta̱hví na̱ nu̱ Ndióxi̱ jáchi̱ cúni̱ na̱ jája̱hvi na nu̱ú ña̱ núu cája na. Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ mé na̱ jána̱ha̱ ley Moisés yóho cacuu na na̱ ndoho chága̱ ini caja Ndióxi̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","In tañu íin coo Jesús ini veñu̱hu cáhnu cán yati nu̱ íin sa̱to̱ nu̱ táán na̱ jiu̱hún jóco̱ na̱ nu̱ Ndióxi̱. Ta sánde̱hé a̱ ndá quia̱hva táán ña̱yivi jiu̱hún ini mé sa̱to̱ cán. Ta na̱xini a cua̱há ta̱a cui̱cá xínu̱ co̱o táán cua̱há na̱ jiu̱hún ini mé sa̱to̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ta mé já na̱xi̱nu̱ co̱o in ñá cuáa̱n ndáhví ta na̱taán ña̱ i̱vi̱ jiu̱hún ña̱ núu ya̱hvi ini mé sa̱to̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Já na̱cana Jesús na̱ xíca tuun xi̱hi̱n á ta já cáchí a̱ já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ cua̱ha̱ chága̱ jiu̱hún na̱sa̱ha̱n ñá cuáa̱n ndáhví yóho a̱ ju̱ú ga̱ tócó ndihi java ga̱ na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Jáchi̱ tócó ndihi na̱ cán na̱sa̱ha̱n na̱ ña̱ yójó nu̱ ná joo ñá cuáa̱n ndáhví yóho na̱sa̱ha̱n ñá nu̱ Ndióxi̱ tócó ndihi ña̱ cómí ñá catacu ñá —na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tá na̱quee Jesús veñu̱hu cáhnu cán já na̱cachi in da̱ xíca tuun xi̱hín a̱ cán já: —Maestro, cande̱hé ndó ndaja náhnu yu̱u̱ na̱cava̱ha na veñu̱hu yóho ta ndaja jícó ndiva̱ha na̱cava̱ha na ña̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Mé a̱ nda̱a̱ náhnu a joo ndá chuun cúú á jáchi̱ ni ja̱nda̱ in yu̱u̱ yóho a̱ cándo̱o ja̱tá inga yu̱u̱ jáchi̱ va̱xi qui̱vi̱ tá ndita̱ni̱ ndihi ña̱ yóho —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A̱nda̱ já na̱sa̱ha̱n na̱ cán yúcu̱ yíto̱ Olivo, ña̱ xíto ndaa táhan xi̱hín veñu̱hu cáhnu cán. Ta tá íin coo Jesús cán já na̱xi̱nu̱ Pedro xi̱hi̱n Jacobo xi̱hi̱n Juan xi̱hi̱n Andrés já na̱ca̱ha̱n je̱hé na̱ xi̱hi̱n á já cáchí na̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Cúni̱ nde̱ ña̱ ná ca̱xi tu̱hun ndó xi̱hín nde̱ ndá ama coo tócó ndihi ña̱ yóho. Ta ndaja coo tá sa̱ na̱cayati mé qui̱vi̱ cán —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Já na̱cachi Jesús já xi̱hi̱n ná: —Cuéntá coo ndó ta a̱ quiáhva ndó ña̱ma̱ni̱ jándahvi ni in ña̱yivi ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jáchi̱ cua̱há ndiva̱ha na quixi na cuéntá mí i̱ ta ca̱ha̱n na̱ ña̱ tu̱hún tá cachi na já xi̱hi̱n ndó: “Ye̱he̱ cúú Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi.” Ta xi̱hín ña̱ yóho cua̱há ndiva̱ha ña̱yivi jándahvi na. ");
INSERT INTO mksNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ʼJoo tá na̱casáhá xíni̱ jo̱ho ndó ña̱ yóho cáa cúu tondóhó, a̱ cáyi̱hví toho ndó jáchi̱ quia̱hva já ndítahan coo. Joo cáma̱ní yi̱í xi̱nu̱ co̱o qui̱vi̱ nu̱ ndíhí. ");
INSERT INTO mksNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jáchi̱ ña̱yivi ndúu in nación ndicui̱ta na cani táhan na xi̱hín na̱ ndúu inga nación ta cani táhan na̱ in ñuu xi̱hín na̱ inga ñuu. Ta quixi nditáán ndijáá nu̱ ndúu ña̱yivi já xi̱nu̱ ta̱ma̱ ndeé ta já casáhá na̱ ndiva̱a̱ na̱. Ta tócó ndihi ña̱ yóho cúú á tá ca̱va̱ sáhá sa̱há ña̱ núu va̱xi nu̱ú ña̱yivi jáchi̱ cáma̱ni̱ xi̱nu̱ co̱o chága̱ nu̱ú ndoho ini na. ");
INSERT INTO mksNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ʼJoo candaa va̱ha ndó mé ndó jáchi̱ ndiquia̱hva na ndo̱hó ndahá na̱ cómí chuun ta cani na ndo̱hó ini veñu̱hu. Ta sa̱há ye̱he̱ cañehe na ndo̱hó nu̱ú na̱ cómí cuéntá sa̱há ña̱yivi xi̱hín nu̱ú na̱ cúú jutixia ta já cuu ca̱ha̱n ndó sa̱há i̱ nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Joo jihna ñúhú xíní ñúhú ndicui̱ta nuu tu̱hun va̱ha sa̱ha̱ mí i̱ nu̱ tócó ndihi ña̱yivi a̱nda̱ jáví ndihi sa̱ha̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ta tá ná cañehe na ndo̱hó cu̱hu̱n ndó nu̱ú na̱ jutixia, a̱ ndícani ini ndó sa̱há ndá tu̱hun ca̱ha̱n ndó xi̱hi̱n ná. Mé hora já ca̱ha̱n ndó ña̱ quia̱hva Ndióxi̱ nu̱ ndó ca̱ha̱n ndo̱. Jáchi̱ a̱ ju̱ú ji̱ni̱ mé ndó quixi ña̱ ca̱ha̱n ndo̱. Ínima̱ yi̱i̱ Ndióxi̱ cacuu ña̱ quia̱hva tócó ndihi ña̱ ca̱ha̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ta java ta̱a ji̱có túhún da̱ ñani da ta java da ji̱có túhún da̱ ja̱hyi da ña̱ ná cahní ñahá na̱. Ta cua̱ha̱ ná ndicui̱ta na cani táhan na xi̱hi̱n tátá na̱ ta cahní ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ta ndaja táhan ña̱yivi ndúu ñuyíví yóho candají na̱ ndo̱hó sa̱há ye̱he̱. Joo ndá na̱ ná candi̱co̱ tuun íchi̱ mí i̱ ja̱nda̱ ná xi̱nu̱ qui̱ví quivi na, na̱ ja̱n cacuu na̱ ca̱cu ndaa ínima̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ʼNa̱ cáhvi tutu ná canda̱a̱ ini na ña̱ cáha̱n. Daniel cúú da̱ na̱ca̱hyí sa̱nahá sa̱há in ña̱ quini ña̱ játi̱ví ñahá. Tá ná cuni ndó ña̱ cándichi in a nu̱ú co̱ ndítahan coo a já ndítahan nu̱ú na̱ ndúu estado Judea cunu na cu̱hu̱n na̱ chí yúcu̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ta ndá na̱ cánúu ji̱ni̱ véhe mé qui̱vi̱ já co̱ ndítahan nuu na tavá na̱ ña̱ha vehe na. ");
INSERT INTO mksNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ta ndá na̱ ndúu yúcu̱ co̱ ndítahan ndicó co̱o na vehe na ndiquehe na jáhma̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ndáhví na̱ji̱hí, mé na̱ ñúhu ja̱hyi mé qui̱vi̱ já. Ta ndáhví na̱ ñéhe ndaa na̱ va̱lí táhan ña̱ chíchí yi̱i̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ca̱ca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ ña̱ ná a̱ cácuu a tiempo vi̱xi tá ná cunu ndó cu̱hu̱n ndo̱ já ná a̱ ndóho chága̱ ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Jáchi̱ qui̱ví ndoho ndiva̱ha ini ndó cacuu a̱ cán. Jáchi̱ ja̱nda̱ tá na̱ca̱va̱ sáhá sa̱ha̱ ñuyíví co̱ó na̱ndoho ini na tá quia̱hva ndoho ini na mé qui̱ví ja̱n. Ta tá ná ya̱ha ña̱ ja̱n, a̱ ndícó co̱o ga̱ ña̱ ndoho ini na quia̱hva já. ");
INSERT INTO mksNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ta tá ná a̱ ndája cuítí Ndióxi̱ tiempo yóho ni in ña̱yivi a̱ cúu ca̱cu ndaa. Joo na̱sacu ini a ndaja cuítí a̱ mé tiempo yóho jáchi̱ quíhvi̱ ini a tócó ndihi na̱ na̱ca̱xi mé á. ");
INSERT INTO mksNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ʼTa tá ná cachi in na xi̱hi̱n ndó: “Cande̱hé ndo̱, yóho íin Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi”, á tá ná cachi na: “Cande̱hé ndo̱, cáa íin da”, cachi na já quéa̱ a̱ cándúsa toho ndó na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jáchi̱ quixi cua̱há na̱ jándahvi ndo̱hó ta ndaja na mé ná tátu̱hun Cristo. Joo a̱ ju̱ú Cristo cúú ná. Ta quixi cua̱ha̱ ná ta cachi na ca̱ha̱n na̱ cuéntá Ndióxi̱ ta jári caja na cua̱há nu̱ú ña̱ náhnu xi̱hín ña̱ xitúhún ña̱ ná jándahvi na ña̱yivi. Ta a̱nda̱ na̱ sa̱ na̱ca̱xi Ndióxi̱ jándahvi na tá ná cuu caja na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Xíní ñúhú cande̱hé va̱ha ndó mé ndó jáchi̱ sa̱ na̱ca̱xi tu̱hun ya̱chi̱ ndihi i̱ ña̱ yóho xi̱hi̱n ndo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Já cáchí tucu Jesús já: —Joo tá sa̱ na̱ya̱ha tócó ndihi ña̱ na̱ndoho ini ña̱yivi já canaá nu̱ú ca̱ndii ta a̱ ndíye̱he̱ ga̱ yo̱o̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","A̱nda̱ indiví quee qui̱mi cu̱yu rí nu̱ ñúhu̱ ta quiji nuu indiví ña̱ na̱cava̱ha Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","A̱nda̱ já cuni na ye̱he̱ quixi i̱ tañu vi̱co̱ xi̱hi̱n tócó ndihi ndée̱ cáhnu i̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. Ta cuni na ndá quia̱hva cáhnu cúú ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ta tá na̱ndihi já chindahá i̱ táto̱ mí i̱ ña̱ ná jánditaca na na̱ sa̱ na̱ca̱xi i̱ tañu tócó ndihi ñuu ja̱nda̱ níí cúú sa̱há ñuyíví ta ja̱nda̱ níí cúú sa̱há indiví. ");
INSERT INTO mksNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ʼCatia̱hva ndó ña̱ cúni̱ cachi mé quia̱hva sácú u̱ nu̱ ndó sa̱há titó ñu̱hú. Tá yúta̱ ndáha̱ dó cán ta va̱xi núma̱ válí do̱ já canda̱a̱ ini ndó ña̱ va̱xi tiempo ihní. ");
INSERT INTO mksNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ta quia̱hva já cacuu ña̱ yóho tá ná cuni ndó ya̱ha tócó ndihi ña̱ yóho. Jáchi̱ a̱nda̱ jáví canda̱a̱ ini ndó ña̱ na̱cayati tiempo quixi tucu ye̱he̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ ya̱ha tá ya̱ha tócó ndihi ña̱ na̱cachi i̱ xi̱hi̱n ndo̱ ta a̱nda̱ jáví quivi na̱ ndúu tiempo viti. ");
INSERT INTO mksNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ta ndihi sa̱há indiví xi̱hi̱n ñuyíví joo a̱ ndíhi toho sa̱há tu̱hun na̱ca̱ha̱n i̱ xi̱hi̱n ndó yóho. Jáchi̱ coo tá coo va ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ʼJoo ni in túhún toho ña̱yivi co̱ xíni̱ na̱ ndá qui̱vi̱ á ndá hora ya̱ha ña̱ yóho. Ta ni mé táto̱ Ndióxi̱ ndúu indiví co̱ xíni̱ na̱ ndá qui̱vi̱ coo ña̱ yóho. Ta ni ye̱he̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ co̱ xíni̱ ndá qui̱vi̱ coo ña̱ yóho. In túhún Ndióxi̱, tátá yo̱ quéa̱ xíni̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ʼSa̱há ña̱ cán quéa̱ cañuhu ini ndó sa̱há ña̱ yóho. Coo tia̱hva ndó ta ca̱ca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ jáchi̱ co̱ xíni̱ ndó ndá qui̱ví xi̱nu̱ co̱o ña̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jáchi̱ ña̱ yóho cúú á tátu̱hun in da̱ta̱a quéta cua̱ha̱n xícá joo tá cáma̱ní quee da cu̱hu̱n da̱ jándacoo tóo da vehe da nu̱ mozo da̱ ña̱ ná candaa na ña̱. Ta sáhan da chuun caja in in mozo da̱. Ta nu̱ú da̱ ndáá yéhé na̱sahnda da chuun ña̱ ná candaa va̱ha da ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sa̱há ña̱ cán quéa̱ xíní ñúhú coo tia̱hva ndó jáchi̱ co̱ xíni̱ ndo̱ ndá qui̱ví xi̱nu̱ co̱o mé da̱ cúú xitoho vehe. Co̱ xíni̱ ndo̱ á cacuu a tá na̱cuaá tóo á cacuu a java ñuú táji̱ á cacuu a tá na̱cana chéle á cacuu a tá sa̱ na̱ti̱vi. ");
INSERT INTO mksNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cuéntá coo ndó. A̱ ju̱ú tia̱hva náá xi̱nu̱ co̱o da ta ndiñe̱he̱ dá ndo̱hó ndúu ndó quíji̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ña̱ cáha̱n i̱ xi̱hi̱n ndó cáha̱n i̱ xi̱hín ndihi na: Xíní ñúhú coo tia̱hva ndó sa̱ha̱ mé qui̱vi̱ quixi tucu u̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tá cáma̱ní i̱vi̱ qui̱vi̱ caja na vicó pascua xi̱hi̱n víco̱ tá xíxi na pan ña̱ co̱ quée yusá na̱xa̱a̱ xi̱hi̱n já na̱casáhá na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés ndúcú na̱ ndá quia̱hva caja na tiin je̱hé na̱ Jesús já cuu cahní na̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ta já cáchí xi̱hi̱n táhan na: —A̱ tíin toho í da̱ mé víco̱ jáchi̱ tia̱hva náá ndiva̱a̱ ña̱yivi —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ta ndaja coo íin Jesús ñuu Betania vehe Simón, da̱ cáha̱n na̱ xi̱hi̱n: ta̱a na̱ndoho cue̱he̱ táhyi̱. Ta nani ndúu coo na nu̱ mesa cán na̱xi̱nu̱ in ñáñáha̱ ta ñéhe ñá in yúyú alabastro na̱chutú jíní a̱ xi̱hín perfume, dó támi ndiva̱ha sáha̱n ta cúú dó perfume ya̱hvi ndiva̱ha. Ta na̱tahví ñá yóho mé yúyú cán já na̱cho̱jó ña̱ do̱ ji̱ni̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ta java na̱ ndúu cán na̱casáhá na̱ jáa̱ ná xi̱hi̱n ña̱ já na̱casáhá cáchí xi̱hi̱n táhan na já: —Ndáva̱ha na̱ti̱ví uun perfume yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Cuu ji̱có yó do̱, nduu ta yáha ga̱ nu̱ú u̱ni̱ ciento denario quehé sa̱ha̱ dó ta xi̱hín jiu̱hún cán cuu chindeé yó na̱ nda̱hví, nduu —cáchí na̱. Sa̱há ña̱ cán quéa̱ na̱xo̱jo̱ ini na xi̱hi̱n ñáñáha̱ cán ta na̱ca̱ha̱n núu na sa̱ha̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —A̱ cáha̱n ndó xi̱hi̱n ña̱. A̱ jáqui̱hvi̱ ndó ña̱. Ña̱ va̱ha quéa̱ na̱caja ñá yóho xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Jáchi̱ na̱ nda̱hví níí tiempo canduu na tañu ndó ta cuu caja ndó ña̱ va̱ha xi̱hi̱n ná ndá tañu cúni̱ mé va ndó joo ye̱he̱ a̱ cóo tuun toho i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mé ñá yóho na̱caja ñá ja̱nda̱ nu̱ú na̱xi̱nu̱ ndée̱ ñá caja ñá xi̱hín i̱. Sa̱ na̱jándicuchu ya̱chi̱ va ñá yóho yiquí cu̱ñu i̱ xi̱hín perfume, dó támi sáha̱n ja̱n ña̱ ná coo tia̱hva vi̱ tá ná casa̱a̱ qui̱ví ndu̱xu̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ níí cúú ñuyíví nu̱ú caca nuu ña̱yivi ca̱ha̱n na̱ tu̱hun va̱ha sa̱ha̱ mí i̱ já quéa̱ ndicani na ña̱ na̱caja ñá yóho xi̱hín i̱ já ndicu̱hu̱n ini na sa̱ha̱ ña̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ta ndaja coo in táhan da̱ u̱xu̱ i̱vi̱ xíca tuun xi̱hi̱n Jesús, da̱ naní Judas Iscariote na̱sa̱ha̱n da̱ cáha̱n da̱ xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱. Já na̱sa̱ha̱n da̱ tu̱hun da nu̱ú na̱ cán ña̱ ndiquia̱hva da Jesús ndáha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tá na̱xini jo̱ho na̱ cán ña̱ na̱cachi da xi̱hi̱n ná na̱cavatá na̱ ta na̱sa̱ha̱n na̱ tu̱hun na nu̱ mé Judas ña̱ quia̱hva na jiu̱hún nu̱ dá. Ta sa̱ mé nani já na̱casáhá Judas ndúcú da̱ ndaja cuu caja da ndiquia̱hva da Jesús nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mé qui̱ví nu̱ú víco̱ pascua tá xíxi na pan ña̱ co̱ quée yusá na̱xa̱a̱ xi̱hi̱n já sáhní na̱ ndicachi válí jóco̱ na̱ nu̱ Ndióxi̱. Já na̱nda̱ca̱ tu̱hún na̱ xíca tuun xi̱hi̱n Jesús mé á já cáchí na̱ já xi̱hi̱n á: —Ndáchí cúni̱ ndó cu̱hu̱n nde̱ caja ndíví nde̱ cajíni ndó vicó pascua —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A̱nda̱ já na̱chindahá Jesús i̱vi̱ da̱ xíca tuun xi̱hi̱n á já cáchí a̱ já xi̱hi̱n dá: —Cuáhán ndó ñuu ja̱n jáchi̱ ja̱n ndiñe̱he̱ ndó in da̱ta̱a ñéhe da in yoo ti̱cui̱í ta candi̱co̱ ndó da̱ cu̱hu̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tá ná xi̱nu̱ da̱ vehe nu̱ú ndi̱hvi da já cachi ndó xi̱hín da̱ cúú xitoho vehe cán já: “Da̱ jána̱ha̱ nde̱he̱ cáchí xu̱hu̱n: Ndáchí íin nu̱ú coo i̱ cajíni i̱ vicó pascua xi̱hín na̱ xíca tuun xi̱hín i̱.” ");
INSERT INTO mksNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A̱nda̱ já jána̱ha̱ mé da̱ cán in cuarto cáhnu ña̱ cánúu ji̱ni̱ véhe piso ni̱nu. Sa̱ íin tia̱hva va ña̱. Cán caja ndíví ndo̱ ña̱ cajíní —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Já na̱quee mé na̱ xíca tuun xi̱hi̱n Jesús cán cua̱ha̱n na̱ ta tá na̱xi̱nu̱ na̱ ñuu cán na̱sahi̱in tá íin cáchí Jesús xi̱hi̱n ná. Já na̱caja ndíví na̱ ña̱ cajíni na vicó pascua mé cán. ");
INSERT INTO mksNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tá na̱cuaá na̱xi̱nu̱ Jesús xi̱hi̱n ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ta tá ndúu coo na nu̱ mesa xíxi na já na̱cachi Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ in táhan ndó, da̱ ndúu coo xíxi xi̱hín i̱ nu̱ mesa yóho cacuu da̱ ji̱có túhún ye̱he̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A̱nda̱ já na̱casáhá na̱ cán cácuéha̱ ini na já na̱casáhá tá in tá in na ndáca̱ tu̱hún na̱ mé á já cáchí na̱ já xi̱hi̱n á: —Á ye̱he̱ cacuu da̱ ji̱có túhún mé ndó. Já na̱cachi inga tucu da já: —Á a̱ ju̱ú ye̱he̱ cacuu da. ");
INSERT INTO mksNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A̱nda̱ já na̱cachi Jesús já: —In táhan ndó da̱ cúú u̱xu̱ i̱vi̱, da̱ in ndúu xíxi xi̱hín i̱ ini co̱hó i̱, da̱ cán cúú da̱ ji̱có túhún ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ye̱he̱ cúú da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta ndítahan nu̱ú i̱ quivi i̱ tá íin cáchí tu̱hun Ndióxi̱. Joo ndáhví na̱há na̱cuu da̱ ji̱có túhún ye̱he̱. Ja̱nda̱ va̱ha chága̱ ná a̱ cácu da, nduu —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nani xíxi na ndúu na na̱tiin Jesús pan já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱. Tá na̱ndihi na̱sahnda java ña̱ ta na̱sa̱ha̱n ña̱ nu̱ ná já cáchí a̱ já xi̱hi̱n ná: —Júhun ndó jáchi̱ ña̱ yóho cúú tátu̱hun yiquí cu̱ñu i̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tá na̱ndihi na̱tiin a in vaso nu̱ ñúhu tó uva já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱. Ta na̱sa̱ha̱n mé á do̱ nu̱ú na̱ cán ta tá in tá in na na̱xihi na do̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Já na̱cachi a já xi̱hi̱n ná: —Dó yóho cúú dó tátu̱hun ni̱í i̱, dó cui̱ta sa̱há cua̱há ña̱yivi. Tá ná cui̱ta ni̱í i̱ já canda̱a̱ ini ndó ña̱ na̱jáxi̱nu̱ co̱o Ndióxi̱ tu̱hun a na̱sa̱ha̱n sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ a̱ cóho ga̱ i̱ tó uva ja̱nda̱ quia̱hva ná xi̱nu̱ co̱o qui̱ví coho tucu u̱ inga dó va̱ha chága̱ tá ná xi̱nu̱ qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tá na̱ndihi na̱xita na in canto já na̱quee na cua̱ha̱n na̱ yúcu̱ yitó Olivo. ");
INSERT INTO mksNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Tócó ndihi ndó jándacoo ndó ye̱he̱ ñuú viti jáchi̱ já cáchí tu̱hun Ndióxi̱ já: “Cahní i̱ da̱ ndáá ndicachi ta xi̱hín ña̱ yóho ndicui̱ta nuu ndicachi ja̱na̱ dá cu̱hu̱n ri̱”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Joo tá na̱ndihi nditacu tucu u̱ ta já cu̱hu̱n jihna ñúhú ye̱he̱ estado Galilea a̱nda̱ já cu̱hu̱n mé ndó —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A̱nda̱ já na̱cachi Pedro já xi̱hi̱n Jesús: —Va̱tí ná jándacoo ndihi na mé ndó joo a̱ jándacoo toho i̱ ndo̱hó —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xu̱hu̱n mé ñuú viti tá cáma̱ní cana i̱vi̱ chéle já chije̱hé tu̱hún ña̱ xínún ye̱he̱ u̱ni̱ tañu —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Já na̱casáhá ndúcú ndéé Pedro cáha̱n da̱ já cáchí da̱ já: —Va̱tí ná quivi i̱ xi̱hi̱n ndo̱ joo a̱ chíje̱hé tu̱hun toho i̱ sa̱há ña̱ xíní i̱ mé ndó —na̱cachi da. Ta mé quia̱hva já na̱cachi ndihi na̱ cán xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","A̱nda̱ já na̱xi̱nu̱ na̱ cán in nu̱ú naní Getsemaní já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Yóho caco̱o ndó nani ná cu̱hu̱n i̱ cáa ca̱ca̱ ta̱hví i̱ nu̱ Ndióxi̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta ndáca Pedro xi̱hi̱n Jacobo xi̱hi̱n Juan cua̱ha̱n xi̱hi̱n á. Ta ndaja coo na̱casáhá cácuéha̱ ini a ta a̱ ju̱ú quia̱hva táhvi̱ ini a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Já na̱cachi a já xi̱hi̱n ná: —Cácuéha̱ ndiva̱ha ini i̱ chí quivi i̱ cúu ini i̱. Yóho cando̱o tóo ndó ta coto a̱ cúju̱ ndo̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A̱nda̱ já na̱quee Jesús cua̱ha̱n chága̱ chí nu̱u̱ já na̱caxítí a̱ ja̱nda̱ quia̱hva na̱xi̱nu̱ co̱o nu̱u̱ á nu̱ ñúhu̱ cán. Já na̱xi̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱ ña̱ ná caja mé á ña̱ ná a̱ ndóho a tá quia̱hva va̱xi nu̱ á ndoho a chí nu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Já cáchí a̱ já xíca̱ ta̱hví a̱ nu̱ Ndióxi̱: —Tátá Ndióxi̱, tócó ndihi ña̱ha cuu caja ndó. Chindeé ndó ye̱he̱ ná a̱ ndóho i̱ ña̱ i̱hvi̱ ndiva̱ha ña̱ va̱xi nu̱ú i̱ ndoho i̱. Joo ná coo tá íin cúni̱ mé ndó ta ná a̱ cóo toho ña̱ cúni̱ ye̱he̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A̱nda̱ já na̱ndicó co̱o a nu̱ ndúu na̱ xíca tuun xi̱hi̱n á cán ta já na̱ndiñe̱he̱ á na̱ quíji̱ na̱ ndúu na. Já na̱casáhá cáchí a̱ já xi̱hi̱n Pedro: —Á quíji̱ vún, Simón. Á co̱ó na̱cuu canditún ni in hora. ");
INSERT INTO mksNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xíní ñúhú coo tia̱hva ndó ta ca̱ca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ já ná a̱ cóto ndojó rí quini ndo̱hó. Mé a̱ nda̱a̱ ínima̱ ña̱yivi cúni̱ a̱ ndinducú a̱ Ndióxi̱ joo yiquí cu̱ñu na co̱ íin tia̱hva caja ña̱ cúni̱ Ndióxi̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A̱nda̱ já na̱quee tucu a cua̱ha̱n ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱. Ta sa̱ mé tu̱hun na̱ca̱ha̱n nu̱ cuítí cán na̱ca̱ha̱n tucu a chí i̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ta tá na̱ndicó co̱o a na̱ndiñe̱he̱ tucu a na̱ xíca tuun xi̱hi̱n á cán ndúu na quíji̱ na̱ jáchi̱ na̱quehe a̱ ma̱hnú na̱. Ta chí co̱ xíni̱ na̱ ndá tu̱hun nducú ñehe na nu̱ Jesús sa̱há ña̱ quíji̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tá na̱ndicó co̱o a táhndá u̱ni̱ já na̱cachi a já xi̱hi̱n ná: —Va̱tí cúni̱ ndó cu̱ju̱ ndo̱ ta va̱tí cúni̱ ndó ndique̱he ndée̱ ndo̱ joo a̱ cúu caja ndó ña̱ viti. Jáchi̱ sa̱ na̱xi̱nu̱ co̱o hora ndiquia̱hva na ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ndahá ña̱yivi cája cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cuáhán ndaco̱o ndó ná co̱ho̱. Jáchi̱ sa̱ va̱xi da̱ jícó túhún ye̱he̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ta nani cáha̱n yi̱i̱ va Jesús cándichi a já na̱xi̱nu̱ Judas, da̱ cúú in táhan da̱ u̱xu̱ i̱vi̱ xíca tuun xi̱hín Jesús cán. Ta xi̱hi̱n mé da̱ cán va̱xi cua̱há ña̱yivi ñéhe na machiti xi̱hi̱n yíto̱ viti. Mé na̱ va̱xi cán cúú ná na̱ va̱xi cuéntá na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín nu̱ú na̱ jána̱ha̱ ley Moisés xi̱hín nu̱ú na̱ sa̱cua̱há veñu̱hu. ");
INSERT INTO mksNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ta mé Judas, da̱ ndiquia̱hva mé á nu̱ú na̱ cán sa̱ na̱cando̱o da xi̱hín na̱ cán ña̱ tatí yúhu̱ dá sa̱jóho Jesús jáchi̱ na̱cachi da já xi̱hi̱n ná: —Mé da̱ ná tatí yuhú u̱ sa̱jóho, da̱ cán cúú dá tiin ndó ta cató tuun ndó da̱ cañehe ndó cu̱hu̱n ndo̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ta tá na̱xi̱nu̱ da̱ cán chí i̱vi̱ la̱á na̱cayati da nu̱ Jesús já cáchí da̱ já xi̱hi̱n á: —Maestro, maestro. Já na̱tatí yúhu̱ dá sa̱jóho a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","A̱nda̱ já na̱tiin tuun na Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Joo in táhan da̱ xíca tuun xi̱hín Jesús cán na̱tavá da̱ machiti da̱ já na̱chitúhu̱n dá in jo̱ho da̱ cúú mozo da̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ na̱xi̱nu̱ tiin ñahá cán: —Cája ndó xi̱hín i̱ tátu̱hun cája na xi̱hín ta̱a cui̱hná jáchi̱ na̱queta ndó va̱xi ndó tiin ndó ye̱he̱ xi̱hín machiti ta xi̱hi̱n yíto̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ndijáá níí qui̱vi̱ na̱sahi̱in i̱ tañu ndó ja̱n ta na̱jána̱ha̱ i̱ ndo̱hó ini veñu̱hu cáhnu ta ni in tañu co̱ó na̱tiin ndó ye̱he̱. Joo tócó ndihi ña̱ yáha yóho xíní ñúhú ya̱ha ña̱ já ná xi̱nu̱ co̱o nu̱ú ña̱ na̱ca̱hyi̱ sa̱há i̱ ini tu̱hun Ndióxi̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","A̱nda̱ já na̱xinu ndihi na̱ xíca tuun xi̱hi̱n Jesús cán cua̱ha̱n na̱ ta na̱jándacoo na mé á. ");
INSERT INTO mksNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Joo in da̱tacú cátíví da̱ in túhún ji̱ní sábana ndíco̱ da̱ ja̱tá na̱ cán cua̱ha̱n da̱ ta na̱tiin na da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Joo na̱janí da̱ mé dá ta na̱cando̱o sábana da̱ já na̱xinu lahla da cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","A̱nda̱ já na̱sa̱ñehe na Jesús na̱sa̱ha̱n na̱ nu̱ú da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱. Ta na̱ndique táhan tócó ndihi na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu xi̱hín na̱ jána̱ha̱ ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ta na̱sa̱ndi̱co̱ xícá Pedro Jesús a̱nda̱ quia̱hva na̱xi̱nu̱ da̱ yéhé vehe da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán. Já na̱sa̱co̱o da xi̱hín da̱ ndáá veñu̱hu cáhnu cán xítúní da̱ yati yávi̱ núhu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ta na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hi̱n tócó ndihi na̱ cómí cuéntá sa̱há na̱ Israel na̱taca na cán ndúcú na̱ cua̱chi jácana na ja̱tá Jesús já cuu cahní ñahá na̱. Joo co̱ó cua̱chi jíquí ná ñe̱he̱ ná chínúu na ja̱ta̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ta cua̱ha̱ ná na̱casáhá cáha̱n na̱ ña̱ tu̱hún sa̱ha̱ Jesús joo co̱ xínu̱ tu̱hun cáha̱n na̱ jáchi̱ a̱ cu̱ú ndique táhan va̱ha tu̱hun na. ");
INSERT INTO mksNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ta na̱nda̱ca̱ ndichi java da cáha̱n da̱ tu̱hun jíquí sa̱ha̱ Jesús já cáchí da̱ já: ");
INSERT INTO mksNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Na̱xini jo̱ho nde̱ na̱cachi da̱ ja̱n já: “Jándita̱ni̱ i̱ veñu̱hu cáhnu cán, ña̱ na̱cava̱ha ña̱yivi ta ti̱xi u̱ni̱ qui̱ví jácandichi tucu u̱ inga ga̱ ña̱ a̱ cu̱ú cava̱ha ndahá ta̱a” —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Joo ni já co̱ó na̱cuu ndique táhan tu̱hun na xi̱hín ña̱ na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","A̱nda̱ já na̱nda̱ca̱ ndichi mé da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ tañu na̱ cán já na̱nda̱ca̱ tu̱hún da̱ Jesús já cáchí da̱ já xi̱hi̱n á: —Á chí a̱ ndúcú ñehún tu̱hun nu̱ú nde̱ sa̱há cua̱chi jácojo na ja̱tu̱n —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Joo co̱ó na̱ca̱ha̱n Jesús ni in tu̱hun xi̱hi̱n ná já táji̱ níí já va na̱sahi̱in a. Mé da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán na̱casáhá ndáca̱ tu̱hún tucu da a̱ já cáchí da̱ já xi̱hi̱n á: —Á jivi ndusa yóhó cúún Cristo, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ yi̱i̱, mé da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A̱nda̱ já na̱cachi Jesús já: —A̱ja̱n, jivi ye̱he̱ cúú dá. Ta va̱xi qui̱vi̱ tá cuni ndó ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi caco̱o i̱ xoo cuáha Ndióxi̱, mé a̱ íin cua̱ha̱ ndée̱. Ta já cuni ndó ye̱he̱ ndicó co̱o i̱ ñuyíví yóho tañu vi̱co̱ tá ná quixi i̱ chí indiví —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A̱nda̱ já na̱ndatá da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ jáhma̱ da̱ ña̱ ná canda̱a̱ ini ña̱yivi ña̱ xójo̱ ini da. Já cáchí da̱ já: —Ndá chicuu chága̱ yó ña̱yivi ndicani nu̱ yo̱. Xi̱hín ña̱ na̱ca̱ha̱n da̱ yóho cánda̱a̱ iní ña̱ ndája núu da Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Á sa̱ na̱xini jo̱ho ndó ña̱ ndája núu da Ndióxi̱ xi̱hín tu̱hun na̱ca̱ha̱n da̱. Ndaja xíní ndó caja í xi̱hi̱n dá viti —na̱cachi da. A̱nda̱ já na̱ndique táhan tu̱hun ndihi ña̱yivi ña̱ ndáca̱a̱n cua̱chi nu̱ Jesús ña̱ cán quéa̱ ndítahan quivi a. ");
INSERT INTO mksNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Java na na̱casáhá na̱ xíhnu ndaa na tóji̱í nu̱ á ta java na na̱chicaji na jáhma̱ nu̱ á já na̱casáhá cáni na ja̱hndá nu̱u̱ á já ndáca̱ tu̱hún ñahá na̱ já cáchí na̱ já xi̱hi̱n á: —Ca̱ha̱n xi̱hín nde̱ yo na̱cani yo̱hó viti —na̱cachi na. Ta ja̱nda̱ na̱ ndáá veñu̱hu cáhnu cán viti na̱casáhá cáni na ja̱hndá nu̱u̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ta ndaja coo Pedro íin yi̱i̱ dá xítúní da̱ cán já na̱xi̱nu̱ in ñá cája chúun xi̱hín da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱. ");
INSERT INTO mksNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Já na̱xini ñá xítúní Pedro ta nahá va̱ha na̱sande̱hé ñá nu̱ dá já cáchí ña̱ já: —Yóhó cúún táhan da̱ xíca tuun xi̱hi̱n Jesús, da̱ ñuu Nazaret —na̱cachi ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Joo na̱chije̱hé tu̱hun da ña̱ xíni̱ da̱ Jesús já cáchí da̱ já: —U̱hu̱n. Co̱ xíni̱ toho i̱ da ta co̱ xíni̱ toho ye̱he̱ ndá sa̱ha̱ cáhu̱n —cáchí Pedro. A̱nda̱ já na̱cayati da yuyéhé ta i̱vi̱ la̱á na̱cana chéle. ");
INSERT INTO mksNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tá na̱xini mé ñá cája chúun xi̱hín da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán ña̱ na̱sandichi tóo da yéhé cán já na̱casáhá ña̱ cáxi tu̱hun ñá xi̱hi̱n tócó ndihi ña̱yivi ndúu cán já cáchí ña̱ já: —Cande̱hé ndó. Da̱ cáa cúú in táhan da̱ xíca tuun xi̱hín Jesús —na̱cachi ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Na̱cachi tucu Pedro ña̱ co̱ xíni̱ da̱ Jesús. Chá va na̱ya̱ha ña̱ yóho ta já na̱cachi na̱ ndúu xítúní cán xi̱hi̱n Pedro: —Táhan ri da̱ cáa va cúú yóhó jáchi̱ cúún da̱ Galilea ta cáhu̱n tátu̱hun cáha̱n na̱ cán —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","A̱nda̱ já na̱casáhá Pedro cána̱há da̱ ta na̱tavá da̱ qui̱vi̱ Ndióxi̱ ña̱ co̱ xíni̱ da̱ Jesús já na̱cachi da já: —Ni co̱ xíni̱ mí i̱ ndá ta̱a cúú da̱ ja̱n, da̱ cáha̱n ndó sa̱há ja̱n —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tá na̱cachi da já i̱vi̱ la̱á na̱cana chéle ña̱ chí i̱vi̱. A̱nda̱ já na̱ndicu̱hu̱n ini Pedro ña̱ na̱cachi Jesús xi̱hi̱n dá tá na̱cachi a já: “Tá cáma̱ní cana i̱vi̱ chéle sa̱ chíje̱hé tu̱hún ña̱ xínún ye̱he̱ u̱ni̱ tañu.” Tá na̱ndicu̱hu̱n ini Pedro ña̱ yóho já na̱casáhá sácu ndiva̱ha da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tá na̱ti̱vi inga qui̱ví ita̱a̱n já na̱ndique táhan na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ sa̱cua̱ha̱ veñu̱hu xi̱hín na̱ jána̱ha̱ ley Moisés xi̱hín ndihi na̱ cómí cuéntá sa̱há na̱ Israel. Já na̱cató na̱ Jesús ñéhe na a̱ cua̱ha̱n na̱ já na̱ndiquia̱hva na mé á nu̱ Pilato. ");
INSERT INTO mksNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ta mé Pilato na̱nda̱ca̱ tu̱hún da̱ Jesús já cáchí da̱ já xi̱hi̱n á: —Á mé a̱ nda̱a̱ cúún in rey, da̱ cómí cuéntá sa̱há na̱ Israel. —A̱ja̱n. Jivi cúú u̱ tá quia̱hva cáchí ndo̱ ja̱n —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ta na̱jácojo na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán cua̱há cua̱chi ja̱ta̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Já na̱nda̱ca̱ tu̱hún tucu Pilato Jesús já na̱cachi da já xi̱hi̱n á: —Ndáva̱ha co̱ ndúcú ñehún tu̱hun nu̱ú i̱. Cande̱hé ndaja cua̱há nu̱ú cua̱chi jácojo na ja̱tu̱n —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Joo ni in tu̱hun co̱ó na̱ca̱ha̱n Jesús. Tá na̱xini Pilato ña̱ co̱ ndúcú ñehe Jesús tu̱hun já na̱catóntó da̱ sa̱há ña̱ cája. ");
INSERT INTO mksNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tañu mé víco̱ pascua na̱sahi̱in costumbre Pilato ña̱ janí da̱ in da̱ ndáca̱a̱n veca̱a. Ndá da̱ cúni̱ ña̱yivi janí da̱, da̱ cán cúú da̱ jání da̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ta ndaja coo mé já ndáca̱a̱n in da̱ naní Barrabás veca̱a xi̱hín java ga̱ da̱ na̱xi̱ca xi̱hi̱n dá. Ndáca̱a̱n da̱ veca̱a sa̱há ña̱ na̱sahní da̱ ndi̱i tá na̱ndiva̱a̱ ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chí na̱xi̱nu̱ ña̱yivi nu̱ Pilato já na̱casáhá na̱ cáha̱n na̱ xi̱hi̱n dá ña̱ ná caja da tá quia̱hva sá caja da. ");
INSERT INTO mksNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Joo na̱nda̱ca̱ tu̱hún Pilato na̱ já cáchí da̱ já: —Á co̱ cúni̱ ndó ña̱ ná janí i̱ da̱ cúú rey nu̱ú ña̱yivi Israel yóho —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Na̱cachi Pilato ña̱ yóho jáchi̱ xíni̱ da̱ ña̱ na̱ndiquia̱hva na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán Jesús nu̱ da̱ sa̱há ña̱ cáhi̱hvi̱ ini na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Joo na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán na̱casáhá na̱ jándini̱hi na ña̱yivi ña̱ ná cachi na xi̱hi̱n Pilato ña̱ ná janí da̱ Barrabás. ");
INSERT INTO mksNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tá na̱ndihi já na̱nda̱ca̱ tu̱hún Pilato na̱ já na̱cachi da já xi̱hi̱n ná: —Ndía̱ cúni̱ ndó caja i̱ xi̱hín da̱ cáchí ndó cúú rey nu̱ ndóhó, na̱ Israel —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A̱nda̱ já na̱nducú ñehe ña̱yivi cán tu̱hun nu̱ Pilato já cáchí na̱ já xi̱hi̱n dá: —Cata caa ndó da̱ ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Já na̱cachi Pilato já xi̱hi̱n ná: —Ndá cua̱chi na̱caja da, va̱ha. Joo ví ga̱ ví cáyuhú cóhó na̱ já cáchí na̱ já: —Cata caa ndó da̱ ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ta sa̱há ña̱ cúni̱ Pilato cando̱o va̱ha da nu̱ú ña̱yivi na̱janí da̱ Barrabás. Ta tá na̱ndihi na̱jácaxáhan na Jesús já na̱ndiquia̱hva da a̱ ndáha̱ na̱ cu̱hu̱n cata caa ñahá na̱ ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A̱nda̱ já ñéhe soldado Jesús cua̱ha̱n na̱ yuyéhé vechúun cán. Já na̱jánditaca soldado cán java ga̱ táhan da. ");
INSERT INTO mksNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Já na̱chinúu na in jahmá cuáhá túu̱n ja̱ta̱ Jesús ta na̱chinúu na in ti̱yi̱vi̱ íñu̱ ji̱ni̱ á. ");
INSERT INTO mksNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tá na̱ndihi já na̱casáhá na̱ cáyuhú na̱ já cáchí na̱ já: —Cáhnu nahá ná cacuu yóhó, da̱ cúú rey nu̱ú na̱ Israel —cáchí na̱ sácu̱ ndaa ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tá na̱ndihi na̱casáhá cáni na yiquí jíní a̱ xi̱hín in ndo̱o ta na̱casáhá na̱ xíhnu ndaa na tóji̱í na̱ nu̱u̱ á já na̱casáhá na̱ cáxítí na̱ nu̱ á ña̱ cája na tátu̱hun cája cáhnu na a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tá na̱ndihi na̱sa̱cu̱ ndaa na a̱ já na̱tavá na̱ jáhma̱ cuáhá túu̱n ña̱ na̱sanúu ja̱tá. Ta na̱jánda̱ca̱ ndixi na a̱ xi̱hi̱n jáhma̱ mé á já na̱sa̱ñehe na a̱ cua̱ha̱n na̱ cata caa na a̱ ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tá ñéhe na Jesús cua̱ha̱n na̱ cata caa na a̱ ndi̱ca crúxu̱ já na̱ndique táhan na xi̱hín in da va̱xi da ndi̱hvi da ñuu Jerusalén. Mé da̱ cán naní da̱ Simón, da̱ ñuu Cirene, da̱ cúú tátá Alejandro xi̱hi̱n Rufo. Já na̱caja ndúsa̱ ná xi̱hi̱n dá ña̱ ná ndicojo da crúxu̱ nu̱ú cata caa na Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Já na̱sa̱ñehe na Jesús na̱sa̱ha̱n na̱ in xi̱qui̱ naní Gólgota. Tu̱hun yóho cúni̱ cáchí a: nu̱ ndúu lásá yiquí jíní ndi̱i. ");
INSERT INTO mksNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Cán na̱sa̱ha̱n na̱ vino nu̱ Jesús, dó na̱ca̱va̱ táhan xi̱hín ju̱sa ña̱ naní mirra. Joo co̱ó na̱xeen toho a coho a do̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A̱nda̱ já na̱cata caa na a̱ ndi̱ca crúxu̱. Já na̱casáhá soldado cán sájíquí da̱ sa̱ha̱ jáhma̱ Jesús ta na̱cachi xi̱hi̱n táhan da ña̱ ndá da̱ ná quee va̱ha cuu quehe in in jáhma̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ta cúú á tátu̱hun ca̱a̱ i̱n naha tá na̱cata caa na Jesús ndi̱ca crúxu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ta ji̱ní ndi̱ca crúxu̱ cán na̱ca̱hyí na̱ ndá sa̱há na̱cata caa na a̱ ta já cáchí a̱ já: “Da̱ yóho cúú rey nu̱ú na̱ Israel.” ");
INSERT INTO mksNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ta sa̱ mé já na̱cata caa na i̱vi̱ ta̱a cui̱hná xi̱hi̱n Jesús: in da xoo cuáha ta in da xoo íti. ");
INSERT INTO mksNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ta xi̱hín ña̱ yóho na̱xi̱nu̱ co̱o tu̱hun Ndióxi̱ tá cáchí a̱ já: “Tañu ta̱a quini na̱sacu na a̱.” ");
INSERT INTO mksNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chí cáva̱ ji̱ni̱ mé ña̱yivi yáha cán cána̱há na̱ xi̱hi̱n á já cáchí na̱ já: —Cande̱hé. Yóhó cáchún ña̱ jándita̱nu̱n veñu̱hu cáhnu cán ta ti̱xi u̱ni̱ víxí qui̱vi̱ cáchún jácandichi tucún ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jáca̱cu mún. Cuáhán nuu ndi̱ca crúxu̱ ja̱n —na̱cachi na sácu̱ ndaa i̱chi̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ta quia̱hva já cája na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán xi̱hín na̱ jána̱ha̱ ley Moisés sácu̱ ndaa ñahá na̱. Ta na̱casáhá cáha̱n xi̱hi̱n táhan na já cáchí na̱ já: —Na̱cuu na̱caja Jesús jáca̱cu da java ga̱ ña̱yivi joo viti a̱ cu̱ú jáca̱cu da mé dá. ");
INSERT INTO mksNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tá ta̱ mé a̱ nda̱a̱ cúú dá Cristo, da̱ cúú rey nu̱ú na̱ Israel ná nuu da ndi̱ca crúxu̱ viti ñúhú já ná candúsa nde̱ da̱ —cáchí na̱. Ta ja̱nda̱ da̱ i̱vi̱ táhan ndácaa ndi̱ca crúxu̱ jíi̱n á cán cána̱há da̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tá na̱xi̱nu̱ co̱o ca̱xi̱vi̱ nda̱a̱ na̱canaá níí cúú ñuyíví ta ja̱nda̱ ca̱a̱ u̱ni̱ sa̱hini já na̱casáhá na̱ndiye̱he̱ tucu. ");
INSERT INTO mksNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta sa̱ mé hora já na̱cayuhú cóhó Jesús já cáchí a̱ já: —Eloi, Eloi, lama sabactani —na̱cachi a. Tu̱hun yóho cúni̱ cáchí a̱: Ndióxi̱ mí i̱, Ndióxi̱ mí i̱, ndáva̱ha na̱jándacoo ndáha̱ ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ta java na̱ ndíta cán na̱xini jo̱ho na tu̱hun cáchí a̱. Já na̱cachi na já: —Cuni jo̱ho ndó jáchi̱ cána da profeta Elías —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A̱nda̱ já xínu in da na̱sa̱ha̱n da̱ na̱chindaxi da in ti̱co̱to̱ ini vino iyá. Já na̱cató da̱ mé ti̱co̱to̱ cán nu̱ú in yitó ndo̱o já na̱chitivi da do̱ yati yúhu̱ Jesús ña̱ ná coho a do̱. Já na̱cachi da já xi̱hín java da̱ cán: —Cóho̱ cande̱hó á quixi Elías jánuu a da̱ ndi̱ca crúxu̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A̱nda̱ já na̱cayuhú cóhó Jesús já na̱xi̱hi̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","A̱nda̱ já na̱nda̱tá java nda̱a̱ jáhma̱ ndeé ña̱ sájí nuu nu̱ú yi̱í ndiva̱ha veñu̱hu cáhnu ñuu Jerusalén cán. Ja̱nda̱ ji̱ni̱ á ta ja̱nda̱ sa̱há na̱nda̱ta̱. ");
INSERT INTO mksNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ta ndaja coo in da̱ta̱a, da̱ sáhndá chuun nu̱ú soldado cuéntá Roma na̱sahi̱in da nu̱ ndácaa Jesús cán ta tá na̱xini da na̱xi̱hi̱ a̱ já na̱cachi da já: —Mé a̱ nda̱a̱ táhyí cúú da̱ yóho in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ta na̱sa̱nduu java na̱ji̱hí ta sánde̱hé xícá na̱ Jesús. Tañu na̱ yóho na̱sa̱ndaca̱a̱n ñá naní María, ñá ñuu Magdala xi̱hín María, ñá cúú náná Jacobo, da̱ loho chá nu̱ú José xi̱hín in ñá naní Salomé. ");
INSERT INTO mksNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na̱sa̱ndi̱co̱ na̱ji̱hí yóho ja̱ta̱ Jesús ta na̱chindeé ñahá na̱ tá na̱sahi̱in a estado Galilea. Cua̱há ga̱ na̱ji̱hí na̱sa̱nduu cán ta java na cúú ná na̱ na̱sa̱ha̱n xi̱hi̱n á ñuu Jerusalén jihna tá cáma̱ní quivi a. ");
INSERT INTO mksNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tá na̱cuaá tóo uun qui̱ví viernexe tá cáma̱ní casa̱a̱ qui̱vi̱ ndíquehe ndée̱ na̱ Israel já na̱ya̱ha tócó ndihi ña̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ta ndaja coo íin in da naní José, da̱ ñuu Arimatea, da̱ cúú táhan na̱ cómí cuéntá sa̱há na̱ Israel. Mé José yóho ndáti da casa̱a̱ qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi ñuyíví yóho. Ta na̱sa̱ha̱n ndeé ini da cu̱hu̱n da̱ ca̱ha̱n máni̱ dá xi̱hín Pilato sa̱há yiquí cu̱ñu Jesús ña̱ ná quia̱hva mé Pilato ña̱ nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Chí na̱catóntó Pilato tá na̱canda̱a̱ ini da ña̱ sa̱ na̱xi̱hi̱ Jesús. Já na̱cana da da̱ sáhndá chuun nu̱ú soldado da̱ já na̱nda̱ca̱ tu̱hún ñahá da̱ á sa̱ na̱xi̱hi̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tá na̱ca̱xi tu̱hun da̱ cán nu̱ Pilato ña̱ sa̱ na̱xi̱hi̱ Jesús já na̱sa̱ha̱n Pilato ña̱ma̱ni̱ nu̱ú José ña̱ ná ndiquehe da yiquí cu̱ñu Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A̱nda̱ já na̱xeen José in jahmá va̱ha ta na̱jánuu da yiquí cu̱ñu Jesús ndi̱ca crúxu̱ já na̱chitiví da̱ ña̱ xi̱hín mé jahmá va̱ha cán. Tá na̱ndihi já na̱chica̱a̱n da̱ mé yiquí cu̱ñu Jesús cán ini in yávi̱ ndáca̱a̱n ndi̱ca cáva̱. Tá na̱ndihi já na̱chija̱hvi da yuhú cáva̱ cán xi̱hín in yu̱u̱ jáhndá cáhnu. ");
INSERT INTO mksNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ta ndaja coo María, ñá ñuu Magdala xi̱hín María, náná José na̱sande̱hé na̱ nu̱ú na̱sacu na yiquí cu̱ñu Jesús ini mé cáva̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ta tá sa̱ na̱ya̱ha qui̱vi̱ ndíque̱he ndée̱ na̱ já na̱sa̱ha̱n María, ñá ñuu Magdala xi̱hín María, ñá cúú náná Jacobo xi̱hi̱n Salomé viti na̱quee na cua̱ha̱n na̱ cueen na java nu̱ú ña̱ha támi sáha̱n ña̱ chindáá na̱ yiquí cu̱ñu Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta naha chá mé qui̱vi̱ domingo tá na̱queta ca̱ndii já cua̱ha̱n na̱ nu̱ú na̱chica̱a̱n na̱ yiquí cu̱ñu Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ta nani xíca na cua̱ha̱n na̱ íchi̱ cán já ndítúhún xi̱hi̱n táhan na ndá quia̱hva caja na tavá na̱ yu̱u̱ ndájí nu̱ú ndáca̱a̱n yiquí cu̱ñu Jesús cán. Já cáchí na̱ já: —Yo tavá toho yu̱u̱ ndájí nuu nu̱ú qui̱hví ini nu̱ ndáca̱a̱n yiquí cu̱ñu Jesús —cáchí xi̱hi̱n táhan na cása̱ha̱n na̱ jáchi̱ cáhnu ndiva̱ha mé yu̱u̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Joo tá na̱xi̱nu̱ na̱ mé cáva̱ cán já na̱xini na ña̱ co̱ó ga̱ yu̱u̱ ndájí yuhú cáva̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ta tá na̱ndi̱hvi na mé cáva̱ cán já na̱xini na cáa íin in da̱ta̱a ndíxí jahmá yaa ña̱ cáni̱. Íin coo da xoo cuáha ta cúú dá da̱ yúta̱. Tá na̱xini na̱ji̱hí yóho da̱ cán chí na̱yi̱hví na̱. ");
INSERT INTO mksNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A̱nda̱ já na̱ca̱ha̱n da̱ cán já cáchí da̱ já: —A̱ yíhví toho ndó. Xíni̱ ye̱he̱ ña̱ ndínducú ndo̱ Jesús ña̱ Nazaret, ña̱ na̱cata caa na ndi̱ca crúxu̱. Cande̱hé ndo̱ nu̱ú na̱sacu na a̱. Co̱ó ga̱ íin viti jáchi̱ na̱nditacu tucu a. ");
INSERT INTO mksNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ta viti cuáhán ndo̱ ca̱xi tu̱hun ndó xi̱hín na̱ na̱xi̱ca tuun xi̱hi̱n á ta xi̱hi̱n Pedro ña̱ cánu̱ú mé á cua̱ha̱n estado Galilea. Tá cu̱hu̱n ndó cán já cuni ndó a̱ tá quia̱hva na̱cachi mé á xi̱hi̱n ndo̱ —na̱cachi táto̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Já na̱quee na̱ cán xínu na cua̱ha̱n na̱ jáchi̱ na̱yi̱hví ndiva̱ha na a̱nda̱ quíji ni̱nu na. Co̱ó na̱ca̱ha̱n na̱ xi̱hín ni in ña̱yivi jáchi̱ na̱yi̱hví ndiva̱ha na. ");
INSERT INTO mksNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tá na̱ndihi na̱nditacu tucu Jesús ta tá na̱ti̱vi mé qui̱vi̱ domingo já ñá nu̱ cuítí na̱xini Jesús na̱sacuu ñá María, ñá ñuu Magdala, mé ñá na̱tavá Jesús u̱sa̱ rí quini na̱sa̱ndaca̱a̱n ini ñá. ");
INSERT INTO mksNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta tá na̱xini ñá mé á já na̱quee ñá cua̱ha̱n ñá ca̱xi tu̱hun ñá nu̱ú na̱ na̱xi̱ca tuun xi̱hi̱n Jesús ña̱ tácú a̱. Ta ndúu cuéha̱ ini na ta sácu na ndúu na tá na̱sa̱a̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ta na̱ca̱xi tu̱hun ñá nu̱ ná ña̱ na̱nditacu tucu Jesús ta na̱xini ñá mé á joo co̱ó na̱xeen na candúsa na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ta tá na̱ndihi já na̱ndija̱ma Jesús ndá quia̱hva cáa já na̱nda̱ca̱ náha̱ á nu̱ú i̱vi̱ táhan na̱ cua̱ha̱n yúcu̱, na̱ na̱xi̱ca tuun xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Joo tá na̱ndicuni na mé á já na̱quee na cua̱ha̱n na̱ ca̱xi tu̱hun na xi̱hín na̱ java cán joo co̱ó na̱xeen na candúsa na tu̱hun na̱ca̱ha̱n ndíví na̱ yóho xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tá na̱ndihi cán na̱nda̱ca̱ náha̱ Jesús nu̱ú ndíhu̱xu̱ in na̱ na̱xi̱ca tuun xi̱hi̱n á nani ndúu na xíxi na. Já na̱casáhá jána̱ni a na̱ jáchi̱ na̱ndaja táhyí na̱ ínima̱ ná ta co̱ó na̱xeen na candúsa na ña̱ na̱xini na̱ java cán Jesús tá na̱ndihi na̱nditacu tucu a. ");
INSERT INTO mksNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Já na̱casáhá cáchí Jesús já xi̱hi̱n ná: —Cuáhán ndo̱ níí cúú ñuyíví yóho ta ca̱xi tu̱hun ndó xi̱hín ndihi ña̱yivi tu̱hun va̱ha sa̱há i̱. ");
INSERT INTO mksNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ta ndá na̱ ná candúsa ye̱he̱ ta candúta̱ ná já quéa̱ ca̱cu ndaa ínima̱ ná ta a̱ cúhu̱n na̱ indayá. Joo na̱ co̱ cándúsa ye̱he̱, na̱ cán cúú na̱ cu̱hu̱n na̱ ndoho ini na indayá a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Joo na̱ cándeé ini ye̱he̱ caja na ña̱ xitúhún. Ta xi̱hín qui̱ví ye̱he̱ tavá na̱ ínima̱ quini ndáca̱a̱n ini ña̱yivi. Ta ndaca̱ha̱n na̱ tu̱hun sa̱á ña̱ co̱ó na̱catia̱hva na. ");
INSERT INTO mksNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ta tá ná tiin ndáha̱ ná co̱o̱ ta tá ná coho na ña̱ cúú cahní ñahá, a̱ cáhní toho a na̱. Ta tá ná chinúu na ndáha̱ ná ji̱ní na̱ quíhvi̱ já ndiva̱ha mé na̱ quíhvi̱ cán —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tá na̱ndihi na̱ca̱ha̱n Jesús, xitoho í tócó ndihi tu̱hun yóho xi̱hi̱n ná a̱nda̱ já na̱ndindita cua̱ha̱n indiví ta na̱sa̱co̱o a xoo cuáha Ndióxi̱, tátá yo̱. ");
INSERT INTO mksNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tá na̱ndihi já na̱quee na̱ na̱xi̱ca tuun xi̱hi̱n á cán cua̱ha̱n na̱ ca̱xi tu̱hun na tu̱hun va̱ha sa̱ha̱ Jesús ndijáá ñuu. Ta já na̱chindeé Jesús, xitoho í na̱ cán ta náha̱ ña̱ cúú á ña̱ nda̱a̱ cáha̱n na̱ jáchi̱ na̱caja mé á ña̱ cúú cája na cua̱há nu̱ú ña̱ xitúhún. Já ná coo.");
INSERT INTO mksNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Sa̱ xíni̱ va̱hún, Teófilo ña̱ sa̱ cua̱há ña̱yivi ndúcú na̱ ca̱hyí na̱ tá cáa tá íin ña̱ na̱ya̱ha tañu nde̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ta na̱jána̱ha̱ na̱ nu̱ú nde̱ tócó ndihi ña̱ na̱xini na ja̱nda̱ mé sa̱ha̱. Mé na̱ yóho cúú ná na̱ na̱xi̱ca nuu na̱ca̱ha̱n na̱ tu̱hun va̱ha sa̱ha̱ Jesús nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ta cúni̱ ri ye̱he̱ va ca̱hyí i̱ ña̱ jáchi̱ cuéé cuéé na̱nda̱ca̱ tu̱hún i̱ ndaja cáa a̱nda̱ mé sa̱ha̱ já ná cuu ca̱hyí vií ndihi i̱ ña̱ nu̱ mún, Teófilo, da̱ quíhvi̱ ndiva̱ha ini i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jáchi̱ cúni̱ ña̱ ná canda̱a̱ va̱ha inún ndaja cáa ña̱ nda̱a̱ ña̱ na̱jána̱ha̱ na̱ nu̱u̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mé tiempo cán na̱sacuu Herodes rey nu̱ú na̱ Judea. Ta na̱sahi̱in in da̱ cúú ju̱tu̱ naní Zacarías. Ta na̱sacuu da cuéntá in táhndá ju̱tu̱ naní Abías. Ta ñájíhí da̱ naní ña̱ Elisabet, ñá na̱quixi chi̱chi Aarón, da̱ na̱sacuu ju̱tu̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mé Zacarías yóho xi̱hi̱n ñájíhí da̱ na̱sacuu na ña̱yivi na̱xi̱ca nda̱a̱ nu̱ Ndióxi̱. Ta xi̱hín ndinuhu ini na na̱caja na ña̱ sáhndá Ndióxi̱ nu̱ú tu̱hun mé á caja na. Ta ni in túhún toho ña̱yivi co̱ó na̱cuu ñe̱he̱ íní na̱ ca̱ha̱n núu na sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Joo co̱ó toho ja̱hyi na na̱cacu jáchi̱ co̱ó na̱cuu canduu ja̱hyi Elisabet cán. Ta mé tiempo já sa̱ na̱cayatá ndiva̱ha ndíví na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ta ndaja coo in qui̱vi̱ na̱nditahan nu̱ú mé táhndá ju̱tu̱ xíca xi̱hi̱n Zacarías cán caja chúun na cuéntá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tócó ndihi ju̱tu̱ cán na̱sajíquí na̱ ndá da̱ ná quee va̱ha ta da̱ cán cacuu da̱ qui̱hvi chiníhmá ini veñu̱hu cáhnu ndáca̱a̱n ñuu Jerusalén cán. Ta na̱quee va̱ha Zacarías. ");
INSERT INTO mksNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ta nani chíníhmá Zacarías cán ini veñu̱hu já na̱nditútú ña̱yivi ndúu na yéhé ñu̱hu cán ndícahán na̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ta nani chíníhmá Zacarías nu̱ náa̱ cán ndáca̱a̱n da̱ já na̱canáha̱ in táto̱ Ndióxi̱ nu̱ dá cándichi a xoo cuáha nu̱ náa̱ nu̱ chíníhmá da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tá na̱xini Zacarías táto̱ Ndióxi̱ cán, na̱yi̱hví ndiva̱ha da ta ni co̱ xíni̱ da̱ ndía̱ caja da. ");
INSERT INTO mksNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Joo na̱ndica̱ha̱n táto̱ Ndióxi̱ cán xi̱hi̱n dá já na̱cachi a já: —A̱ yíhví tohún, Zacarías jáchi̱ sa̱ na̱xini jo̱ho Ndióxi̱ nu̱ú na̱xi̱ca̱ ta̱hvún nu̱ á. Sa̱há ña̱ cán quéa̱ caja mé á ña̱ ná cacu in ja̱hyi Elisabet, ñájíhún. Ta cacún qui̱vi̱ dá cananí da̱ Juan. ");
INSERT INTO mksNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A̱ ju̱ú quia̱hva cavatún ta caji̱i̱ inún caja ta̱a loho ja̱n tá ná cacu da. Ta cua̱há ga̱ java na caji̱i̱ íní na̱ caja da tá ná cacu da. ");
INSERT INTO mksNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jáchi̱ da̱ cáhnu cacuu ja̱hyún ja̱n nu̱ Ndióxi̱. A̱ cóho da ni in túhún toho dó xíhi ña̱yivi xíni na xi̱hi̱n. Ta cacuu da in da̱ jándicutú nda̱a̱ Ndióxi̱ xi̱hi̱n ínima̱ yi̱i̱ mé á ja̱nda̱ tá cáma̱ní cacu da. ");
INSERT INTO mksNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ta mé ja̱hyún ja̱n caja da ña̱ ná ndicó co̱o cua̱há na̱ Israel nu̱ Ndióxi̱, xitoho na. ");
INSERT INTO mksNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ta jihna ñúhú mé Juan cu̱hu̱n da̱ caja tia̱hva da ña̱yivi ja̱nda̱ ná quixi mé á chindahá Ndióxi̱. Tá quia̱hva na̱ndicutú nda̱a̱ ínima̱ profeta Elías xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱ quia̱hva já ndicutú nda̱a̱ ínima̱ Juan xi̱hi̱n á já ná coo ndée̱ dá caja da ña̱ha tátu̱hun na̱caja Elías. Ta caja mé Juan ña̱ ná ndique táhan máni̱ ña̱yivi xi̱hín ja̱hyi na. Ta caja da ña̱ ná coo jo̱ho ña̱yivi sáá ini já ná caja na ña̱ cúni̱ Ndióxi̱. Quia̱hva já caja da cacu tia̱hva da ña̱yivi ja̱nda̱ quia̱hva ná xi̱nu̱ qui̱ví quixi da̱ na̱sa̱ha̱n Ndióxi̱ tu̱hun a chindahá a̱ —na̱cachi táto̱ Ndióxi̱ cán xi̱hi̱n Zacarías. ");
INSERT INTO mksNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A̱nda̱ já na̱nda̱ca̱ tu̱hún Zacarías cán táto̱ Ndióxi̱ já na̱cachi da já xi̱hi̱n á: —Ndaja caja i̱ canda̱a̱ ini i̱ á mé a̱ nda̱a̱ táhyí coo tá íin cáchún coo jáchi̱ sa̱ na̱cayatá ndiva̱ha i̱ ta quia̱hva já na̱cayatá ri ñájíhí vi̱ —na̱cachi Zacarías cán. ");
INSERT INTO mksNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A̱nda̱ já na̱nducú ñehe táto̱ Ndióxi̱ cán tu̱hun nu̱ dá já cáchí a̱ já xi̱hi̱n dá: —Ye̱he̱ cúú Gabriel ta chuun Ndióxi̱ xíca nuu i̱ cája i̱. Mé a̱ cán na̱chindahá ye̱he̱ ña̱ ná quixi i̱ ca̱xi tu̱hun i̱ ña̱ yóho xu̱hu̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Joo viti sa̱há ña̱ co̱ó na̱candúsún ña̱ na̱cachi i̱ xu̱hu̱n cando̱o níhu̱n ña̱ ná a̱ cúu ca̱hu̱n ja̱nda̱ quia̱hva ná xi̱nu̱ qui̱vi̱ cacu ja̱hyún. Sa̱ va̱xi qui̱vi̱ coo tá íin na̱cachi i̱ xu̱hu̱n coo —na̱cachi táto̱ Ndióxi̱ cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Joo ndaja coo ña̱yivi ndíta ndáti yéhé ñu̱hu cán sa̱ na̱casáhá ndíhi ini na sa̱há ña̱ sa̱ na̱canahá ta co̱ó Zacarías cán quéta ja̱ta̱ véhe. ");
INSERT INTO mksNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Joo tá na̱queta Zacarías veñu̱hu co̱ó na̱cuu ca̱ha̱n da̱ ni in túhún tu̱hun xi̱hi̱n ná. Xi̱hín ña̱ yóho na̱canda̱a̱ ini na ña̱ na̱xini da in ña̱ha na̱caja Ndióxi̱ nu̱ náa̱ yi̱i̱ mé á cán. Ja̱ndá ndáha̱ uun da cúu nu̱ú na̱ cán jáchi̱ na̱cando̱o níhi̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ta tá sa̱ na̱jáxi̱nu̱ Zacarías qui̱vi̱ cája chúun da veñu̱hu cán já na̱quee da cuanúhu̱ dá vehe da. ");
INSERT INTO mksNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tá sa̱ na̱ya̱ha ña̱ yóho já na̱que̱e ja̱hyi Elisabet, ñájíhí Zacarías cán. Ta ti̱xi u̱hu̱n yo̱o̱ co̱ó na̱quee ñá caca nuu ñá. Ta na̱ca̱hán ña̱: ");
INSERT INTO mksNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Na̱caja Ndióxi̱ ña̱ yóho xi̱hín i̱ viti já ná a̱ cánde̱hé ndaa nahá ga̱ ña̱yivi ye̱he̱”, na̱ca̱hán ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tá na̱xi̱nu̱ i̱ñu̱ yo̱o̱ ñúhu ja̱hyi Elisabet cán já na̱chindahá Ndióxi̱ mé Gabriel, táto̱ mé á in ñuu naní Nazaret ndáca̱a̱n estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Na̱sa̱ha̱n táto̱ Ndióxi̱ yóho Nazaret na̱xi̱to nihni a in ñá tacú naní María, ñá na̱tiin tu̱hun in da̱ naní José ña̱ ná tanda̱ha̱ ñá xi̱hi̱n dá. Mé José yóho na̱quixi da chi̱chi David, da̱ na̱sacomí cuéntá sa̱há ña̱yivi Israel sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na̱ndi̱hvi táto̱ Ndióxi̱ cán nu̱ íin ñá ta já na̱cachi a já xi̱hi̱n ña̱: —Cáha̱n Ndióxi̱ ye̱he̱ xu̱hu̱n, María jáchi̱ cúún in ñá na̱ñe̱he̱ táhvi̱ nu̱ Ndióxi̱. Íin Ndióxi̱ xu̱hu̱n ta na̱caja cua̱ha̱ chága̱ ña̱ma̱ni̱ xu̱hu̱n a̱ ju̱ú ga̱ xi̱hín java ga̱ na̱ji̱hí —na̱cachi táto̱ Ndióxi̱ cán xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Joo tá na̱xini María táto̱ Ndióxi̱ cán já na̱catóntó ña̱ táa jo̱ho ñá ña̱ cáha̱n mé a̱ cán xi̱hi̱n ña̱. “Ta ndá cuéntá quéa̱ cáha̱n táto̱ Ndióxi̱ yóho já xi̱hín yo̱”, na̱ca̱hán ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A̱nda̱ já na̱cachi táto̱ Ndióxi̱ cán já xi̱hi̱n ña̱: —A̱ yíhví tohún, María jáchi̱ cúún in ñá na̱ñe̱he̱ táhvi̱ nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ta viti que̱e ja̱hyún ta tá sa̱ na̱cacu a já cacún qui̱vi̱ á ná cananí a̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mé ja̱hyún ja̱n cacuu a ta̱a cáhnu. Ta cachi ña̱yivi sa̱ha̱ dá ña̱ cacuu da in túhún ji̱ni̱ já ja̱hyi Ndióxi̱, mé á cáhnu nu̱ ndíhi a. Ta mé Ndióxi̱, xitoho í caja ña̱ ná cacomí ja̱hyún cuéntá sa̱há ña̱yivi tá quia̱hva na̱sacomí David, da̱ cúú tásáhnu jícó da̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Quixi da cacomí da̱ cuéntá sa̱há ña̱yivi Israel ta a̱nda̱ ama cáa qui̱vi̱ cacomí da̱ cuéntá sa̱ha̱ ná —na̱cachi táto̱ Ndióxi̱ cán xi̱hi̱n María. ");
INSERT INTO mksNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A̱nda̱ já na̱nda̱ca̱ tu̱hún María táto̱ Ndióxi̱ cán já cáchí ña̱ já xi̱hi̱n á: —Ndaja coo cacu ja̱hyi i̱ ta ni in túhún toho ta̱a co̱ íin xi̱hín i̱ —na̱cachi ñá xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A̱nda̱ já na̱nducú ñehe táto̱ Ndióxi̱ cán tu̱hun nu̱ ñá já cáchí a̱ já: —Ínima̱ yi̱i̱ Ndióxi̱ quéa̱ quixi jándicutú yo̱hó. Ta ndée̱ Ndióxi̱, mé á cáhnu nu̱ ndíhi a cán ca̱va̱ nuu a yo̱hó tátu̱hun caja in vi̱co̱. Sa̱há ña̱ cán quéa̱ tá ná cacu ja̱hyún ja̱n cacuu da in da̱ yi̱i̱ na̱ca̱xi Ndióxi̱ caja chúun nu̱ mé á. Ta cachi ña̱yivi sa̱ha̱ dá ña̱ cúú dá in túhún ji̱ni̱ já ja̱hyi Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ta cáxi tu̱hun i̱ xu̱hu̱n ña̱ cacu ja̱hyi Elisabet, ñá cúú táhún cán va̱tí sa̱ na̱cayatá ña̱. Ta viti sa̱ na̱xi̱nu̱ i̱ñu̱ yo̱o̱ ñúhu ja̱hyi ñá, mé ñá na̱cachi ña̱yivi sa̱ha̱ ña̱ a̱ cúu coo ja̱hyi ñá. ");
INSERT INTO mksNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jáchi̱ Ndióxi̱ cuu caja tócó ndihi ña̱ha —na̱cachi táto̱ Ndióxi̱ cán xi̱hi̱n María. ");
INSERT INTO mksNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A̱nda̱ já na̱cachi María já: —Ndióxi̱ cúú xitoho i̱ ta ná caja mé á tá quia̱hva cúni̱ a̱ xi̱hín i̱. Ná coo tá íin cáchí ndó coo. Tá na̱ndihi na̱cachi María cán ña̱ yóho já na̱quee táto̱ Ndióxi̱ cán cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ta mé tañu qui̱vi̱ já já xínu María na̱sa̱ha̱n ñá in ñuu ndáca̱a̱n chí yúcu̱ cuéntá Judea cán. ");
INSERT INTO mksNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ta tá na̱qui̱hvi ñá vehe Zacarías, yíi̱ Elisabet cán já na̱ca̱ha̱n Ndióxi̱ ñá xi̱hi̱n Elisabet. ");
INSERT INTO mksNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ta tá na̱xini jo̱ho Elisabet na̱ca̱ha̱n Ndióxi̱ María xi̱hi̱n ñá chí na̱candita ña̱ loho ndáca̱a̱n ti̱xi Elisabet cán chí i̱vi̱ la̱á na̱ndicutú nda̱a̱ ñá xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A̱nda̱ já na̱cayuhú cóhó Elisabet já na̱cachi ñá já xi̱hi̱n María: —Ni in túhún toho na̱ji̱hí co̱ó na̱caja máni̱ Ndióxi̱ xi̱hi̱n tá quia̱hva na̱caja máni̱ á yo̱hó. Ta na̱caja yi̱i̱ mé á ja̱hyún. ");
INSERT INTO mksNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ta co̱ó sa̱ha̱ toho ye̱he̱ ná quisún yóho, ñá cúú náná xitoho i̱ coto nihnún ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jáchi̱ tá na̱xini jo̱ho uun i̱ ña̱ na̱ca̱ha̱n Ndiósu̱n xi̱hín i̱ i̱vi̱ la̱á na̱ca̱nda̱ ja̱hyi i̱ ini ti̱xi i̱ jáchi̱ na̱caji̱i̱ íní a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ta̱hví na̱cuún jáchi̱ na̱candúsún ña̱ na̱cachi Ndióxi̱, xitoho í xu̱hu̱n. Jáchi̱ caja tá caja mé á ña̱ na̱cachi a caja —na̱cachi Elisabet cán xi̱hi̱n María. ");
INSERT INTO mksNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A̱nda̱ já na̱cachi María já: Cája cáhnu i̱ Ndióxi̱, xitoho í xi̱hi̱n ínima̱ i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ta cáji̱i̱ ndiva̱ha ini i̱ xi̱hín ña̱ cája Ndióxi̱, mé a̱ jáca̱cu ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jáchi̱ na̱ndicu̱hu̱n ini a sa̱há ye̱he̱, ñá ndáhví, ñá cúú in mozo mé á. Ta cachi ña̱yivi ndúu viti xi̱hín na̱ va̱xi qui̱ví canduu ñuyíví yóho ña̱ na̱caja cua̱ha̱ Ndióxi̱ ña̱ma̱ni̱ xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Jáchi̱ mé Ndióxi̱, mé a̱ cuu caja tócó ndihi ña̱ha na̱caja cua̱há ña̱ náhnu xi̱hín i̱. Ta yi̱i̱ ndiva̱ha qui̱vi̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ta níí tiempo táhvi̱ ini mé á sa̱ha̱ tócó ndihi ña̱yivi, na̱ cája cáhnu mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A̱ ju̱ú quia̱hva náhnu ña̱ha na̱caja mé á. Na̱sa̱hnu̱ a̱ nu̱ú na̱ ndíñehe jícó mé. ");
INSERT INTO mksNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ta na̱candaa mé á chuun ndahá da̱ náhnu ta na̱jánuu ndáha̱ mé á da̱. Ta na̱ndiñehe jícó mé á na̱ na̱jánuu ndáha̱ mé ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ta na̱jándicutú nda̱a̱ mé á ña̱ha nu̱ú na̱ na̱ndima̱ní ña̱ha cuxu. Ta na̱candaa mé á ña̱ na̱sacomí na̱ cui̱cá já na̱taxí a̱ na̱ cán ná quee na cu̱hu̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Na̱chindeé a̱ na̱ Israel, na̱ cája chúun cuéntá mé á. Ta co̱ó na̱ndindójó a̱ ta̱hvi̱ ini a sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jáchi̱ quia̱hva já na̱sa̱ha̱n mé á tu̱hun a caja a̱nda̱ ama cáa qui̱vi̱ xi̱hi̱n Abraham ta xi̱hín tásáhnu jícó yo̱, na̱ na̱quixi chi̱chi mé dá, já na̱cachi María cája cáhnu ñá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ta na̱cando̱o María na̱sahi̱in ñá vehe Elisabet ti̱xi u̱ni̱ yo̱o̱. A̱nda̱ já na̱quee ñá cuanúhu̱ ñá vehe ñá. ");
INSERT INTO mksNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tá na̱ndindaa qui̱ví cacu ja̱hyi Elisabet já na̱cacu in ta̱a loho. ");
INSERT INTO mksNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ta tócó ndihi ña̱yivi ndúu yati xi̱hi̱n ñá xi̱hín na̱ cúú táhan ñá na̱sa̱ha̱n na̱ xíto nihni na ña̱. Ta cáji̱i̱ íní na̱ jáchi̱ na̱canda̱a̱ ini na ña̱ na̱caja Ndióxi̱ cua̱há ña̱ma̱ni̱ xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta tá na̱xi̱nu̱ ña̱ loho cán u̱na̱ qui̱vi̱ já na̱sa̱ha̱n na̱ na̱chica̱a̱n na̱ marca yiquí cu̱ñu a tátu̱hun íin costumbre na̱. Ta na̱ca̱hán na̱ cananí a̱ Zacarías tá quia̱hva naní tátá a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Joo já na̱cachi Elisabet já: —A̱ cánaní toho da já. Juan va cananí da̱ —na̱cachi ñá xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A̱nda̱ já na̱cachi na cán já xi̱hi̱n ña̱: —Ndá cuéntá quéa̱ cananí ja̱hyún já ta ni in túhún toho na̱ vehún co̱ó naní já. ");
INSERT INTO mksNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A̱nda̱ já na̱cuu ndáha̱ ná nu̱ Zacarías cán ña̱ ndáca̱ tu̱hún na̱ da̱ ndaja coo cananí ña̱ loho cán. ");
INSERT INTO mksNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A̱nda̱ já na̱xi̱ca̱ Zacarías cán in tutu nu̱ ná ta já na̱ca̱hyí da̱ já: “Juan cananí da̱.” Tá na̱cahvi na̱ cán ña̱ yóho já na̱catóntó ndihi na. ");
INSERT INTO mksNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta chí sa̱ mé hora já na̱ndica̱ha̱n tucu Zacarías. Já na̱casáhá da̱ cája cáhnu da Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Xi̱hi̱n tócó ndihi ña̱ na̱ya̱ha yóho na̱catóntó ndihi na̱ na̱sanduu yati xi̱hi̱n Zacarías cán. Ta níí cúú ñuu válí ñúhu chí yúcu̱ cuéntá Judea cán na̱ndicui̱ta nuu tu̱hun sa̱ha̱ tócó ndihi ña̱ na̱ya̱ha yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ta tócó ndihi na̱ na̱xini jo̱ho ña̱ yóho na̱casáhá ndícani ini na sa̱há. Já na̱casáhá ndáca̱ tu̱hún táhan na já cáchí xi̱hi̱n táhan na já: —Ndá ta̱a cacuu ta̱a loho yóho tá ná cuahnu da. Na̱cachi na ña̱ yóho jáchi̱ na̱xini táhyí na̱ ña̱ma̱ni̱ náhnu cája Ndióxi̱ xi̱hín ta̱a loho cán. ");
INSERT INTO mksNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A̱nda̱ já na̱ndicutú ínima̱ Zacarías, tátá Juan cán xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱. Já na̱casáhá da̱ cáha̱n da̱ tu̱hun sáhan Ndióxi̱ nu̱ dá ca̱ha̱n da̱. Já na̱cachi da já: ");
INSERT INTO mksNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cáhnu ná cacuu Ndióxi̱, mé a̱ cúú xitoho ña̱yivi na̱quixi chi̱chi Israel. Jáchi̱ na̱quixi a jáca̱cu a mí, na̱ cúú cuéntá mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Na̱chindahá Ndióxi̱ mé a̱ jáca̱cu mí ná a̱ cúhu̱n yó indayá. Ta íin ndée̱ á caja tócó ndihi ña̱ náhnu. Ta na̱quixi a chi̱chi David, da̱ na̱caja chúun cuéntá Ndióxi̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ta ja̱nda̱ sa̱nahá ndiva̱ha na̱sa̱ha̱n Ndióxi̱ tu̱hun a ña̱ caja mé á ña̱ yóho. Ta já na̱jáya̱ha na̱ profeta cán tu̱hun na̱ca̱ha̱n Ndióxi̱ nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ña̱ na̱cachi mé á quéa̱ jáca̱cu a mí ndahá na̱ i̱hvi̱ yo̱ xi̱hi̱n ndáha̱ na̱ co̱ cúní mí. ");
INSERT INTO mksNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ta na̱cachi a ta̱hvi̱ ini a sa̱ha̱ tásáhnu jícó yo̱, na̱ na̱sanduu sa̱nahá cán. Ta a̱ ndíndójó toho mé á sa̱há tu̱hun yi̱i̱ na̱sa̱ha̱n nu̱ ná jáchi̱ ña̱ yi̱i̱ cúú tócó ndihi tu̱hun sáhan Ndióxi̱ nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ña̱ yóho cúú tu̱hun na̱cachi Ndióxi̱ jáxi̱nu̱ co̱o a nu̱u̱ tá na̱sa̱ha̱n mé á tu̱hun a nu̱ Abraham, da̱ na̱sacuu tásáhnu jícó yo̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ta na̱cachi mé á xi̱hi̱n dá ña̱ jáca̱cu a mí ndahá na̱ co̱ cúní mí já ná a̱ cáyi̱hví yo̱ caja chúun í cuéntá mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ta já ná cacuú ña̱yivi nda̱a̱, na̱ na̱ndiquia̱hva mé caja ña̱ cúni̱ mé á tócó ndihi qui̱vi̱ ndúú ñuyíví yóho, na̱cachi Zacarías nu̱ ndíhi ña̱yivi cán. ");
INSERT INTO mksNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A̱nda̱ já na̱casáhá da̱ cáha̱n da̱ xi̱hín ña̱ loho ja̱hyi da já cáchí da̱ já xi̱hi̱n á: Ta yóhó, ja̱hyi a, cachi ña̱yivi sa̱hu̱n ña̱ cúún in profeta Ndióxi̱, mé a̱ cúú cáhnu nu̱ ndíhi a. Ta jihna ñúhú cu̱hún jáca̱hún ña̱yivi ña̱ ná cacu tia̱hva na ínima̱ ná ndiquehe na mé a̱ chindahá Ndióxi̱ va̱xi. ");
INSERT INTO mksNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ta xi̱hín ña̱ yóho cuu ca̱xi tu̱hún xi̱hín ña̱yivi ña̱ cája cáhnu ini Ndióxi̱ sa̱há cua̱chi na. Já ná cuu ca̱cu ndaa ínima̱ ná ná a̱ cúhu̱n na̱ indayá. ");
INSERT INTO mksNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sa̱há ña̱ quíhvi̱ ini Ndióxi̱ mí ta sa̱há ña̱ táhvi̱ ini mé á sa̱ha̱ yo̱ sa̱há ña̱ cán quéa̱ ja̱nda̱ indiví nu̱ íin mé á na̱chindahá a̱ in a cuu chindeé a̱ mí ná ndi̱hví ichí sa̱á cuéntá mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jáchi̱ va̱xi a jándiye̱he̱ a̱ nu̱ú ña̱yivi ndúu nu̱ú naá ña̱ ná caca na íchi̱ nu̱ú cuu coo va̱ha ini na xi̱hi̱n Ndióxi̱, na̱cachi Zacarías xi̱hín ja̱hyi loho da. ");
INSERT INTO mksNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Já na̱casáhá sáhnu ta̱a loho cán cua̱ha̱n da̱. Ta ndíndacú da̱ xi̱hín ña̱ha Ndióxi̱ viti. Ta na̱sahi̱in da yucú íchí nu̱ú co̱ ndúu cua̱há ña̱yivi ja̱nda̱ quia̱hva na̱xi̱nu̱ qui̱ví na̱casáhá jána̱ha̱ da̱ nu̱ú na̱ Israel. ");
INSERT INTO mksNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ta mé tiempo cán tá na̱sacomí Augusto cuéntá sa̱há ña̱yivi ndúu ñuyíví já na̱sahnda da chuun ña̱ ná nditaca qui̱ví ndaja táha̱n ña̱yivi cómí da̱ cuéntá sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ta mé tañu nu̱ cuítí tá na̱nditaca qui̱vi̱ ná já na̱sacuu Cireneo gobernador estado Siria. ");
INSERT INTO mksNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ta tócó ndihi ña̱yivi na̱nditahan nu̱ ná cu̱hu̱n na̱ tá ñuu tá ñuu nu̱ú na̱cacu tásáhnu jícó na̱ ná que̱e qui̱vi̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sa̱há ña̱ cán quéa̱ na̱quee José ñuu Nazaret cuéntá Galilea cán já na̱sa̱ha̱n da̱ ñuu Belén ña̱ ndáca̱a̱n estado Judea nu̱ú na̱cacu David jáchi̱ na̱quixi da chi̱chi David. ");
INSERT INTO mksNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Na̱sa̱ha̱n María xi̱hi̱n José ñuu Belén que̱e qui̱vi̱ ná. Mé María yóho cúú ñá na̱xi̱ca̱ da̱ cacuu ñájíhí da̱. Ta sa̱ já ñúhu ja̱hyi ñá cua̱ha̱n ñá ñuu Belén. ");
INSERT INTO mksNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ta nani na̱sanduu na ñuu Belén cán na̱xi̱nu̱ qui̱ví cacu ja̱hyi María. ");
INSERT INTO mksNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ta na̱cacu ja̱hyi nu̱ú ña̱. Ta na̱chitiví ñá a̱ tico̱to̱ já na̱chindúhu̱ ñá a̱ nu̱ xixáhan quíti̱ cán. Mé nu̱ sánduu quíti̱ cán na̱cacu ja̱hyi María jáchi̱ co̱ó na̱ñe̱he̱ ná vehe canduu na jáchi̱ sa̱ na̱catáñu va vehe nu̱ú canduu ña̱yivi xínu̱ co̱o ñuu Belén cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na̱sanduu java na̱ ndáá ndicachi ja̱na̱ ná ñuú yati ñuu Belén cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ta in náá cuití na̱na̱ha̱ táto̱ Ndióxi̱ mé á nu̱ ná. Ta chí na̱ndiyi̱hvi̱ ndaa nu̱ ndúu na̱ cán na̱caja Ndióxi̱ ta na̱yi̱hví ndiva̱ha na. ");
INSERT INTO mksNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Joo na̱ndica̱ha̱n táto̱ Ndióxi̱ cán xi̱hi̱n ná já na̱cachi a já: —A̱ yíhví toho ndó jáchi̱ tu̱hun va̱ha quéa̱ ñéhe e̱ va̱xi i̱ ca̱ha̱n i̱ xi̱hi̱n ndo̱. Ta xi̱hín ña̱ yóho caji̱i̱ ndiva̱ha ini tócó ndihi ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jáchi̱ mé qui̱vi̱ víti na̱cacu in a jáca̱cu a ndo̱hó nu̱ú cua̱chi ndó ta mé á cán cúú Cristo, xitoho ndó, ña̱ na̱chindahá Ndióxi̱ cacomí a̱ cuéntá sa̱ha̱ ndo̱. Ta na̱cacu a ñuu Belén nu̱ú na̱cacu David sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tá ná cu̱hu̱n ndo̱ cán já cuni ndó ña̱ loho cán cátíví a̱ tico̱to̱ cándúhu̱ á nu̱ xíxáhan quíti̱. Tá ná cuni ndó ña̱ yóho já canda̱a̱ ini ndó ña̱ cáha̱n i̱ ña̱ nda̱a̱ xi̱hi̱n ndo̱ —na̱cachi táto̱ Ndióxi̱ xi̱hín na̱ ndáá ndicachi cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ta nani cáha̱n táto̱ Ndióxi̱ cán na̱xi̱nu̱ co̱o cua̱ha̱ chága̱ táto̱ Ndióxi̱ nu̱ íin a̱ cán. Mé táto̱ Ndióxi̱ yóho na̱quixi na indiví ta cája cáhnu na Ndióxi̱ já cáchí na̱ já: ");
INSERT INTO mksNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Cáhnu ná cacuu Ndióxi̱ íin indiví. Ta ná coo va̱ha ini tócó ndihi ña̱yivi ndúu ñuyíví, mé na̱ cáji̱i̱ ini xi̱hín ña̱ma̱ni̱ cája Ndióxi̱ xi̱hi̱n ná, na̱cachi táto̱ Ndióxi̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ta tá sa̱ na̱ndicó co̱o táto̱ Ndióxi̱ cán cua̱ha̱n chí indiví já na̱casáhá cáchí xi̱hi̱n táhan na̱ ndáá ndicachi cán já: —Cóho̱ quíi̱ yo̱ ñuu Belén cande̱hé yo̱ ña̱ na̱cachi Ndióxi̱, xitoho í xo̱ho̱ ña̱ na̱cuu ñuu Belén cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Já xínu na na̱sa̱ha̱n na̱ ta tá na̱xi̱nu̱ co̱o na cán já na̱ndiñe̱he̱ ná María xi̱hi̱n José xi̱hín mé ña̱ loho cándúhu̱ nu̱ xíxáhan quíti̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A̱nda̱ já na̱casáhá na̱ndicani na̱ ndáá ndicachi cán nu̱ ná ña̱ na̱cachi táto̱ Ndióxi̱ xi̱hi̱n ná sa̱há ña̱ loho cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ta chí cátóntó tócó ndihi ña̱yivi tá xíni̱ jo̱ho na ña̱ ndícani na̱ ndáá ndicachi cán nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Joo na̱ndicu̱hu̱n ini María tócó ndihi ña̱ na̱ya̱ha ta ndícani ini ñá sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tá na̱ndihi já na̱quee na̱ ndáá ndicachi cán cua̱ha̱n na̱. Ta a̱ ju̱ú quia̱hva cája cáhnu na Ndióxi̱ cua̱ha̱n na̱ sa̱ha̱ tócó ndihi ña̱ na̱xini jo̱ho na xi̱hín sa̱ha̱ tócó ndihi ña̱ na̱xini na jáchi̱ na̱sahi̱in tá íin na̱cachi táto̱ Ndióxi̱ cán xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tá na̱ya̱ha u̱na̱ qui̱vi̱ na̱cacu lée ja̱hyi María cán já na̱chica̱a̱n na̱ marca yiquí cu̱ñu a tá quia̱hva íin costumbre na̱. Ta na̱sacu na qui̱vi̱ á cananí a̱ Jesús jáchi̱ quia̱hva já na̱cachi táto̱ Ndióxi̱ cán xi̱hi̱n María ña̱ ndítahan cananí a̱ ja̱nda̱ tá cáma̱ní cañuhu ja̱hyi ñá. ");
INSERT INTO mksNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ta nu̱ ley Moisés, ña̱ na̱ca̱hyí da̱ sa̱nahá cáchí a̱ ña̱ tá ná ndihi na̱cacu ja̱hyi in ñáñáha̱, a̱ cúu qui̱hvi ñá veñu̱hu a̱nda̱ ná ya̱ha sáhndá ley qui̱vi̱. Ta tá sa̱ na̱ya̱ha qui̱vi̱ cán já na̱quehe María xi̱hi̱n José mé lée loho Jesús cán. Já ñéhe na ña̱ cua̱ha̱n na̱ ndiquia̱hva na cuéntá sa̱há nu̱ Ndióxi̱ veñu̱hu cáhnu ñuu Jerusalén cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Na̱caja na ña̱ yóho jáchi̱ já cáchí ley na̱sahnda Ndióxi̱ sa̱nahá: “Tócó ndihi ta̱a va̱lí, na̱ cúú ja̱hyi nu̱ú na̱ji̱hí, ndítahan ndiquia̱hva na ña̱ nu̱ Ndióxi̱.” ");
INSERT INTO mksNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ta jári na̱jo̱co̱ na̱ ña̱ sáhndá ley Moisés coo tá na̱ndihi na̱cacu ja̱hyi na. Ta ña̱ yóho cúú i̱vi̱ ndiyu̱u̱ á i̱vi̱ ndija̱ta. ");
INSERT INTO mksNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ta ndaja coo mé tiempo cán na̱sahi̱in in da̱ta̱a naní Simeón ñuu Jerusalén cán. Ta na̱sacuu da in ta̱a va̱ha ndiva̱ha, da̱ cája cáhnu Ndióxi̱. Ta ndáti da xi̱nu̱ co̱o qui̱vi̱ chindahá Ndióxi̱ in da̱ chindeé na̱ Israel já ná a̱ ndóho ga̱ ini na. Ta na̱ndicutú nda̱a̱ ínima̱ dá xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ta mé a̱ cán quéa̱ na̱cachi xi̱hi̱n dá ña̱ a̱ quíví toho da ja̱nda̱ quia̱hva ná cuni táhyí da̱ Cristo, mé a̱ na̱sa̱ha̱n Ndióxi̱ tu̱hun a chindahá a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ta mé ínima̱ yi̱i̱ Ndióxi̱ ndáca Simeón cua̱ha̱n da̱ veñu̱hu mé qui̱vi̱ na̱xi̱nu̱ María xi̱hi̱n José cán caja na xi̱hi̱n Jesús tá quia̱hva sáhndá ley Moisés caja na. ");
INSERT INTO mksNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tá na̱ndique táhan da xi̱hi̱n ná já na̱tiin da Jesús já na̱sañehe ndaa da a̱. Já na̱casáhá da̱ cája cáhnu da Ndióxi̱ já cáchí da̱ já: ");
INSERT INTO mksNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tátá Ndióxi̱, sa̱ cuu quia̱hva ndó ña̱ma̱ni̱ quivi yaa i̱ viti, jáchi̱ sa̱ na̱jáxi̱nu̱ co̱o ndó nu̱ú tu̱hun ndó, ña̱ na̱sa̱ha̱n ndó nu̱ú ye̱he̱, da̱ cúú mozo ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Jáchi̱ na̱xini i̱ xi̱hín nu̱ú i̱ mé a̱ na̱chindahá ndó jáca̱cu nde̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Na̱sacu ndó a̱ ña̱ ná jáca̱cu a ndaja táha̱n ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mé a̱ yóho jándiye̱he̱ a̱ nu̱ú na̱ co̱ó na̱quixi chi̱chi Israel. Ta sa̱ha̱ mé a̱ yóho ca̱ha̱n va̱ha ña̱yivi sa̱há na̱ Israel, na̱ cúú cuéntá mé ndo̱, na̱cachi Simeón. ");
INSERT INTO mksNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chí na̱catóntó José xi̱hi̱n María táa jo̱ho na ña̱ cáha̱n Simeón sa̱ha̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tá na̱ndihi na̱xi̱ca̱ ta̱hví Simeón nu̱ Ndióxi̱ sa̱ha̱ ná a̱nda̱ já na̱casáhá cáchí da̱ já xi̱hi̱n María, náná Jesús: —Na̱ca̱xi Ndióxi̱ ta̱a loho yóho ña̱ ná caja da ná cu̱hu̱n cua̱há na̱ Israel ndoho ini na ta caja da ña̱ ná ca̱cu ínima̱ cua̱há na̱ cán. Na̱quixi da nu̱ Ndióxi̱ joo candají cua̱ha̱ ná da̱ ");
INSERT INTO mksNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","já náha̱ táhyí ña̱ cáhvi ini in in na̱ cán. Ta yóhó, María ta̱hvi̱ ndiva̱ha inún sa̱há ña̱ yóho ta cacuu a tátu̱hun tuxú na̱ machiti ínimu̱n —na̱cachi Simeón xi̱hi̱n María. ");
INSERT INTO mksNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ta mé cán na̱sahi̱in ri in ñá naní Ana, ñá jáya̱ha tu̱hun cáha̱n Ndióxi̱ nu̱ú ña̱yivi. Ta na̱sacuu ñá ja̱hyi da̱ naní Fanuel, da̱ na̱quixi chi̱chi Aser. Mé Ana yóho na̱cayatá ña̱. Tá yúta̱ ñá na̱tanda̱ha̱ ña̱ joo u̱sa̱ la̱á cui̱a̱ na̱sahi̱in ñá xi̱hi̱n yíi̱ ña̱ já na̱xi̱hi̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ta viti sa̱ na̱xi̱nu̱ co̱mi̱ jícó co̱mí cui̱a̱ íin cuáa̱n ña̱. Ñuú ta ndiví íin tuun ñá veñu̱hu cája cáhnu ñá Ndióxi̱. Xíjuhun ñá ta xíca̱ ta̱hví ña̱ nu̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mé hora íin Simeón ndítúhún da̱ xi̱hi̱n María já na̱xi̱nu̱ co̱o Ana cán. Ta tá na̱ndihi na̱ndiquia̱hva ñá ndixa̱hvi nu̱ Ndióxi̱ já na̱casáhá cáha̱n ñá sa̱há ña̱ loho Jesús cán nu̱ú ña̱yivi, na̱ ndáti quixi qui̱ví chindahá Ndióxi̱ da̱ chindeé na̱ ñuu Jerusalén. Ta cáchí ñá ña̱ jivi mé Jesús cán quéa̱ ndáti na quixi. ");
INSERT INTO mksNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tá na̱ndihi na̱caja José xi̱hi̱n María ña̱ sáhndá ley Moisés cája na̱ cán já cuanúhu̱ na̱ ñuu Nazaret, ña̱ ndáca̱a̱n estado Galilea cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ta mé ta̱a loho Jesús sáhnu da ta ndíndacú da̱. Ta joho ndíndíchí ga̱ ví ji̱ni̱ dá cua̱ha̱n da̱. Ta cua̱há ndiva̱ha ña̱ma̱ni̱ cája Ndióxi̱ xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tá nu̱ cuía̱ sáhan náná tátá Jesús víco̱ pascua ñuu Jerusalén. ");
INSERT INTO mksNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ta tá na̱xi̱nu̱ Jesús u̱xu̱ i̱vi̱ cui̱a̱ já ndáca táhan mé á xi̱hi̱n ná tá cua̱ha̱n na̱ víco̱ ñuu Jerusalén cán jáchi̱ já na̱sahi̱in costumbre ña̱yivi cája na tañu víco̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ta tá sa̱ na̱ya̱ha víco̱ cán já na̱ndicó co̱o José xi̱hi̱n María cua̱ha̱n na̱. Joo co̱ó na̱xini na ña̱ na̱cando̱o Jesús ñuu Jerusalén cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tañu ña̱yivi cua̱ha̱ cán cátáhan da va̱xi da, na̱ca̱hán na̱. Ta tá sa̱ na̱xi̱nu̱ níí in qui̱vi̱ xíca na cua̱ha̱n na̱ já na̱casáhá ndínducú na̱ da̱ tañu ña̱yivi cúú táhan na xi̱hín tañu na̱ xíní táhan xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Joo co̱ó na̱ndiñe̱he̱ ná da̱. A̱nda̱ já na̱ndicó co̱o tucu na ñuu Jerusalén ndínducú na̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ja̱nda̱ qui̱ví u̱ni̱ ví já na̱ndiñe̱he̱ ná Jesús ini veñu̱hu cáhnu cán. Cáa íin coo da tañu na̱ jána̱ha̱ ley Moisés cán. Táa jo̱ho da nu̱ cáha̱n na̱ ta ndáca̱ tu̱hún da̱ na̱ sa̱há java ga̱ ña̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ta chí cátóntó tócó ndihi ña̱yivi tá xíni̱ jo̱ho na tu̱hun ndúcú ñehe da nu̱ú na̱ jána̱ha̱ ley Moisés cán jáchi̱ náha̱ ña̱ ndíchí ji̱ni̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tá na̱xini María xi̱hi̱n José ña̱ ndáca̱a̱n Jesús tañu na̱ jána̱ha̱ ley Moisés cán já na̱catóntó na̱. A̱nda̱ já na̱cachi María já xi̱hi̱n Jesús: —Ja̱hyi ma̱ní i̱. Ndá cuéntá quéa̱ na̱cajún ña̱ yóho xi̱hín nde̱. Ye̱he̱ xi̱hi̱n tátún a̱ ju̱ú quia̱hva ndícani ini nde̱ xíca nuu nde̱ ndínducú nde̱ yo̱hó —na̱cachi María xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A̱nda̱ já na̱cachi Jesús já: —Ndá cuéntá quéa̱ ndínducú ndó ye̱he̱. Á co̱ xíni̱ toho ndó ña̱ ndítahan ndi̱hi ini i̱ cája i̱ chuun na̱sahnda tátá i̱, mé á íin indiví nu̱ú i̱ cája i̱, va̱ha —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Joo ni María ni José co̱ó na̱canda̱a̱ ini na ña̱ na̱cachi Jesús cán xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A̱nda̱ já na̱ndicó co̱o Jesús cua̱ha̱n xi̱hi̱n ná ñuu Nazaret. Ta na̱caja da tócó ndihi ña̱ cúni̱ na̱. Ta na̱ndicu̱hu̱n ini María ña̱ na̱caja Jesús ini veñu̱hu cáhnu cán. ");
INSERT INTO mksNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ta sáhnu Jesús ta cáta̱cu̱ ini da cua̱ha̱n. Ta cáji̱i̱ ini Ndióxi̱ xi̱hi̱n ña̱ cája Jesús. Ta quia̱hva já cáji̱i̱ ri ini ña̱yivi va xi̱hín ña̱ cája da. ");
INSERT INTO mksNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tá na̱xi̱nu̱ sa̱hu̱n cui̱a̱ cómí Tiberio cuéntá sa̱há ña̱yivi ñuyíví já na̱sacuu Poncio Pilato gobernador nu̱ú na̱ ndúu estado Judea. Ta da̱ naní Herodes na̱sacuu gobernador nu̱ú na̱ ndúu estado Galilea. Ta ñani Herodes, da̱ naní Felipe cán na̱sacuu gobernador nu̱ú na̱ ndúu Iturea xi̱hín nu̱ú na̱ ndúu Traconite. Ta da̱ naní Lisanias na̱sacuu gobernador nu̱ú na̱ ndúu Abilinia. ");
INSERT INTO mksNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ta Anás xi̱hi̱n Caifás na̱sacuu da̱ sa̱cua̱ha̱ nu̱ ndíhi ju̱tu̱. Mé tiempo cán na̱ca̱ha̱n Ndióxi̱ xi̱hi̱n Juan, da̱ cúú ja̱hyi Zacarías, mé nu̱ íin da yucú íchí cán. ");
INSERT INTO mksNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","A̱nda̱ já na̱ya̱ha Juan ndíjáá ñuu válí ñúhu yuhú yu̱ta Jordán cán. Ta cáxi tu̱hun da nu̱ú ña̱yivi ña̱ ndítahan nu̱ ná jándacoo na ña̱ núu cája na já ná caja cáhnu ini Ndióxi̱ sa̱há cua̱chi na ta já ná candúta̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tócó ndihi ña̱ yóho na̱ya̱ha tá íin na̱cachi Isaías tá na̱ca̱hyí da̱ sa̱nahá: Va̱xi qui̱vi̱ tá ca̱ha̱n cóhó in da tañu yúcu̱ íchí ta cachi da já: “Caja tia̱hva ndó íchi̱ nu̱ú quixi xitoho í, ta cuná ndó in ichí nda̱cú nu̱ mé á ña̱ ná ndi̱hvi a ínima̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tócó ndihi ña̱ cúú táhvi̱ ná ndicutú ndihi a. Tócó ndihi yúcu̱ xi̱hín xi̱qui̱ ná ndica̱va̱ nda̱a̱ ndihi a. Tócó ndihi ichí ndíca̱va̱ ná ndinda̱cú ndihi a. Ta íchi̱ ña̱ co̱ íin nda̱a̱ nu̱u̱ ndinda̱a̱ ndihi nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ta tócó ndihi ña̱yivi ndúu ñuyíví cuni na ndá quia̱hva jáca̱cu Ndióxi̱ ña̱yivi”, já cáchí tutu na̱ca̱hyí Isaías sa̱nahá ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ta na̱casáhá ña̱yivi ndái cuu na nu̱ íin Juan ña̱ ná jácandúta̱ da̱ na̱ joo na̱casáhá xójo̱ ndiva̱ha ini da xi̱hi̱n ná já cáchí da̱ já: —Mé ndó cúú ndó tátu̱hun co̱o jáchi̱ cúú ndó na̱ quini. Cáhán ndo̱ ña̱ a̱ jándoho ga̱ Ndióxi̱ ini ndó sa̱há cua̱chi ndó tá ná candúta̱ ndo̱ va̱tí cája tá cája ndó cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xíní ñúhú caja ndó ña̱ va̱ha já ná cuni ña̱yivi ña̱ mé a̱ nda̱a̱ táhyí na̱jándicoo ndó ña̱ núu na̱sacaja ndó jihna. Ta a̱ cáhán ndo̱ ña̱ jáca̱cu Ndióxi̱ ndo̱hó sa̱há ña̱ cúú ndó na̱ na̱quixi chi̱chi Abraham. Jáchi̱ co̱ó sa̱ha̱ toho ña̱ ja̱n nu̱ Ndióxi̱ tá co̱ jándacoo ndó cua̱chi ndó. Jáchi̱ mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ ja̱nda̱ yu̱u̱ ndúu nu̱ ñúhu̱ ja̱n cuu caja Ndióxi̱ ña̱ ná nduu a ña̱yivi quixi chi̱chi Abraham. ");
INSERT INTO mksNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mé ndó cúú ndó tátu̱hun in yíto̱, dó sa̱ na̱tiin na hacha cua̱ha̱n na̱ cahnda na. Ta tócó ndihi yíto̱, dó co̱ sáhan cui̱hi va̱ha nu̱u̱, ta̱hnda̱ do̱ ta que̱e dó nu̱ ñúhu̱ ca̱yi̱ do̱. Quia̱hva já caja rí Ndióxi̱ xi̱hi̱n ndóhó tá co̱ cúni̱ ndó ndicó co̱o ini ndó nu̱ mé á —na̱cachi Juan xi̱hín ña̱yivi cán. ");
INSERT INTO mksNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A̱nda̱ já na̱casáhá ña̱yivi cán ndáca̱ tu̱hún na̱ da̱ já cáchí na̱ já xi̱hi̱n dá: —Ndía̱ ndítahan nu̱ú nde̱ caja nde̱. ");
INSERT INTO mksNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Já cáchí Juan já xi̱hi̱n ná: —Ndá na̱ ndúu i̱vi̱ cotó ná quia̱hva na in a nu̱ú na̱ co̱ó ña̱ha nu̱u̱. Ta ndá na̱ íin ña̱ cuxu ná cahnda java táhan na ña̱ xi̱hín na̱ co̱ó a̱ nu̱u̱ —cáchí Juan xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tañu na̱ na̱ndai cuu cán na̱xi̱nu̱ ri java da̱ játaca jiu̱hún cuéntá impuesto ña̱ candúta̱ dá. Ta na̱nda̱ca̱ tu̱hún da̱ Juan já na̱cachi da já: —Maestro, ndía̱ ndítahan nu̱ú nde̱ caja nde̱. ");
INSERT INTO mksNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A̱nda̱ já na̱cachi Juan já xi̱hi̱n dá: —Quehe ndó jiu̱hún nu̱ú ña̱yivi tá quia̱hva sáhndá ley cuití va quehe ndó —na̱cachi Juan xi̱hín da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ta jári java da̱ cúú soldado na̱nda̱ca̱ tu̱hún da̱ Juan já na̱cachi da já: —Ta nde̱he̱ ri ndía̱ ndítahan caja nde̱. Já na̱cachi Juan já xi̱hi̱n dá: —A̱ cándaa ndó ña̱ cómí ña̱yivi. A̱ jáyi̱hví ndó na̱ sa̱há ña̱ ná quia̱hva na ña̱ha nu̱ ndo̱. Ta ni a̱ jácojo ndó cua̱chi ja̱ta̱ ná tá co̱ó na̱caja na ña̱. Ta xíní ñúhú coo va̱ha ini ndó xi̱hín ya̱hvi quéhe ndó sa̱há chuun cája ndó —na̱cachi Juan xi̱hín da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tócó ndihi ña̱yivi ndíhi ini na jáchi̱ cúni̱ na̱ canda̱a̱ ini na ña̱ á mé Juan cúú Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Joo na̱ndica̱ha̱n Juan xi̱hi̱n tócó ndihi ña̱yivi já na̱cachi da já xi̱hi̱n ná: —Mé a̱ nda̱a̱ cája ndúta̱ i̱ ndo̱hó xi̱hín ticui̱í. Joo va̱xi inga da ta da̱ cán cúú da̱ jándicutú ínima̱ ndo̱ xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱ ta ña̱ cán cacuu a tátu̱hun ñúhu̱ cáyi̱. Ta da̱ cán íin cua̱ha̱ chága̱ ndée̱ dá a̱ ju̱ú ga̱ ye̱he̱. Ta chí co̱ó sa̱há i̱ ndica xítí i̱ nu̱ dá ña̱ ndaxí i̱ correa ndu̱sa̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mé da̱ va̱xi cán ca̱xi da ña̱yivi va̱ha tañu ña̱yivi quini. Cúú á tátu̱hun in da̱ta̱a tá jáxi̱xi da trigo xi̱hi̱n pala já ná quee xe̱he̱ á já cacu va̱ha da ña̱. Ta xe̱he̱ na̱cana cán cu̱hu̱n a̱ ca̱yi̱ a̱ xi̱hi̱n ñúhu̱ i̱ta̱ ña̱ a̱ ndáhva̱ toho —na̱cachi Juan. ");
INSERT INTO mksNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Quia̱hva joho na̱ca̱ha̱n Juan nu̱ú ña̱yivi tá na̱ca̱xi tu̱hun da tu̱hun va̱ha nu̱ ná. Ta cua̱há java ga̱ ña̱ha cáha̱n da̱ xi̱hi̱n ná caja na. ");
INSERT INTO mksNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Inga ña̱ha na̱caja da quéa̱ na̱jána̱ni da Herodes, da̱ cúú gobernador jáchi̱ na̱sahi̱in Herodes xi̱hín Herodías, ñá cúú ñájíhí ñani da, Felipe. Ta na̱jána̱ni Juan da̱ sa̱há java ga̱ ña̱ núu na̱caja da. ");
INSERT INTO mksNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Joo na̱caja jóhó Herodes mé dá ta co̱ó na̱xeen da coo jo̱ho da nu̱ cáha̱n Juan xi̱hi̱n dá. Ña̱ na̱caja da quéa̱ na̱caja chága̱ da̱ ña̱ núu tá na̱chica̱a̱n da̱ Juan veca̱a. ");
INSERT INTO mksNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tá cáma̱ní ndáca̱a̱n Juan veca̱a, cája ndúta̱ dá ña̱yivi ta já na̱jácandúta̱ ri da Jesús. Ta nani xíca̱ ta̱hví Jesús nu̱ Ndióxi̱ já na̱nu̱na̱ indiví. ");
INSERT INTO mksNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ta na̱nuu ínima̱ yi̱i̱ Ndióxi̱ ja̱ta̱ Jesús. Ta na̱saca̱a ínima̱ yi̱i̱ Ndióxi̱ yóho tá quia̱hva cáa in ndija̱ta. Tá na̱ndihi já na̱xini jo̱ho na ña̱ cáha̱n in a indiví já na̱cachi a já: —Yóhó cúún ja̱hyi ma̱ní i̱ ta cáji̱i̱ ndiva̱ha ini i̱ xu̱hu̱n —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na̱sandaca̱a̱n Jesús tátu̱hun o̱co̱ u̱xu̱ cui̱a̱ tá na̱casáhá jána̱ha̱ tu̱hun Ndióxi̱ nu̱ú ña̱yivi. Ta na̱ca̱hán ña̱yivi ña̱ na̱sacuu a ja̱hyi José. Ta José cán na̱sacuu da ja̱hyi Elí, ");
INSERT INTO mksNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ta tátá Elí na̱sananí Matat. Ta tátá Matat na̱sananí Leví. Ta tátá Leví na̱sananí Melqui. Ta tátá Melqui na̱sananí Jana. Ta tátá Jana na̱sananí José. ");
INSERT INTO mksNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ta tátá José na̱sananí Matatías. Ta tátá Matatías na̱sananí Amós. Ta tátá Amós na̱sananí Nahum. Ta tátá Nahum na̱sananí Esli. Ta tátá Esli na̱sananí Nagai. ");
INSERT INTO mksNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ta tátá Nagai na̱sananí Maat. Ta tátá Maat na̱sananí Matatías. Ta tátá Matatías na̱sananí Semei. Ta tátá Semei na̱sananí José. Ta tátá José na̱sananí Judá. ");
INSERT INTO mksNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ta tátá Judá na̱sananí Joana. Ta tátá Joana na̱sananí Resa. Ta tátá Resa na̱sananí Zorababel. Ta tátá Zorababel na̱sananí Salatiel. Ta tátá Salatiel na̱sananí Neri. ");
INSERT INTO mksNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ta tátá Neri na̱sananí Melqui. Ta tátá Melqui na̱sananí Adi. Ta tátá Adi na̱sananí Cosam. Ta tátá Cosam na̱sananí Elmodam. Ta tátá Elmodam na̱sananí Er. ");
INSERT INTO mksNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ta tátá Er na̱sananí Josué. Ta tátá Josué na̱sananí Eliezer. Ta tátá Eliezer na̱sananí Jorim. Ta tátá Jorim na̱sananí Matat. ");
INSERT INTO mksNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ta tátá Matat na̱sananí Leví. Ta tátá Leví na̱sananí Simeón. Ta tátá Simeón na̱sananí Judá. Ta tátá Judá na̱sananí José. Ta tátá José na̱sananí Jonán. Ta tátá Jonán na̱sananí Eliaquim. ");
INSERT INTO mksNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ta tátá Eliaquim na̱sananí Melea. Ta tátá Melea na̱sananí Mainán. Ta tátá Mainán na̱sananí Matata. Ta tátá Matata na̱sananí Natán. ");
INSERT INTO mksNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ta tátá Natán na̱sananí David. Ta tátá David na̱sananí Isaí. Ta tátá Isaí na̱sananí Obed. Ta tátá Obed na̱sananí Booz. Ta tátá Booz na̱sananí Salmón. Ta tátá Salmón na̱sananí Naasón. ");
INSERT INTO mksNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ta tátá Naasón na̱sananí Aminadab. Ta tátá Aminadab na̱sananí Aram. Ta tátá Aram na̱sananí Esrom. Ta tátá Esrom na̱sananí Fares. Ta tátá Fares na̱sananí Judá. ");
INSERT INTO mksNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ta tátá Judá na̱sananí Jacob. Ta tátá Jacob na̱sananí Isaac. Ta tátá Isaac na̱sananí Abraham. Ta tátá Abraham na̱sananí Taré. Ta tátá Taré na̱sananí Nacor. ");
INSERT INTO mksNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ta tátá Nacor na̱sananí Serug. Ta tátá Serug na̱sananí Ragau. Ta tátá Ragau na̱sananí Peleg. Ta tátá Peleg na̱sananí Heber. Ta tátá Heber na̱sananí Sala. ");
INSERT INTO mksNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ta tátá Sala na̱sananí Cainán. Ta tátá Cainán na̱sananí Arfaxad. Ta tátá Arfaxad na̱sananí Sem. Ta tátá Sem na̱sananí Noé. Ta tátá Noé na̱sananí Lamec. ");
INSERT INTO mksNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ta tátá Lamec na̱sananí Matusalén. Ta tátá Matusalén na̱sananí Enoc. Ta tátá Enoc na̱sananí Jared. Ta tátá Jared na̱sananí Mahalaleel. Ta tátá Mahalaleel na̱sananí Cainán. ");
INSERT INTO mksNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ta tátá Cainán na̱sananí Enós. Ta tátá Enós na̱sananí Set. Ta tátá Set na̱sananí Adán. Ta Ndióxi̱ na̱cava̱ha Adán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tá na̱ndihi cán na̱quee Jesús yu̱ta Jordán. Ta na̱ndicutú nda̱a̱ ínima̱ mé á xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱ ta mé a̱ cán na̱sandaca Jesús na̱sa̱ha̱n yucú íchí nu̱ú co̱ ndúu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ta cán na̱sahi̱in Jesús ti̱xi i̱vi̱ jico qui̱vi̱ ta na̱xito ndojó tiñáhá sa̱cua̱ha̱ mé á. Ta tócó ndihi qui̱vi̱ cán co̱ó na̱xixi a ta tá na̱ndihi já na̱casáhá cuíco a. ");
INSERT INTO mksNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A̱nda̱ já na̱cachi tiñáhá sa̱cua̱ha̱ cán já xi̱hi̱n á: —Tá ta̱ jivi ndusa ja̱hyi Ndióxi̱ cúún, cahnda chuun ña̱ ná nduu yu̱u̱ yóho pan. ");
INSERT INTO mksNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ri̱ já na̱cachi a já: —Já cáchí tu̱hun Ndióxi̱: “A̱ ju̱ú pan cuití cuxu ña̱yivi já catacu na, va̱ha. Xíní ñúhú caja ri na ña̱ sáhndá tu̱hun Ndióxi̱ nu̱ ná já quéa̱ ná cuu catacu na nu̱ Ndióxi̱”, —na̱cachi Jesús xi̱hi̱n rí cán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tá na̱ndihi já ndáca tiñáhá sa̱cua̱ha̱ cán Jesús na̱sa̱ha̱n rí in ji̱ni̱ yucú jícó xi̱hi̱n á já na̱na̱ha̱ rí tócó ndihi ñuu ndúu ñuyíví nu̱ á in tóo loho joho. ");
INSERT INTO mksNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A̱nda̱ já na̱cachi rí já xi̱hi̱n á: —Cande̱hé ndaja náhnu cúú ñuu ndúu ñuyíví ta ye̱he̱ sáhndá i̱ chuun nu̱ú ndaja táha̱n ña̱ ta cuu jasá i̱ ña̱ nu̱ yóhó jáchi̱ cuu jasá i̱ ña̱ yo nu̱ cúni̱ mí i̱ jasá i̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ta quia̱hva i̱ ña̱ nu̱u̱n tá ná caxítún nu̱ú i̱ caja cáhnún ye̱he̱ —na̱cachi rí xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Joo na̱nducú ñehe Jesús tu̱hun nu̱ ri̱ já cáchí a̱ já: —Satanás, cuáhán caxoo jáchi̱ já cáchí tu̱hun Ndióxi̱: “In túhún Ndióxi̱, xitohún ndítahan caja cáhnún ta in túhún mé á ndítahan caja ndívún nu̱u̱” —na̱cachi Jesús xi̱hín tiñáhá sa̱cua̱ha̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tá na̱ndihi já ndáca tucu tiñáhá sa̱cua̱ha̱ cán Jesús na̱sa̱ha̱n rí ñuu Jerusalén xi̱hi̱n á. Ta na̱jándaa rí a̱ nu̱ jícó ji̱ni̱ veñu̱hu cáhnu ndáca̱a̱n cán já na̱cachi rí já xi̱hi̱n á: —Tá ta̱ jivi ndusa ja̱hyi Ndióxi̱ cúún jácana mún chí ni̱nu̱. ");
INSERT INTO mksNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Jáchi̱ nu̱ú tu̱hun Ndióxi̱ ndáa̱ in tu̱hun ña̱ cáchí a̱ já: Cahnda Ndióxi̱ chuun nu̱ táto̱ mé á ña̱ ná candaa na yo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ta ndiñehe ndáha̱ ná yo̱hó já quéa̱ ná a̱ ndícue̱he̱ sa̱hu̱n tá ná cachihin sa̱hu̱n xi̱hín yu̱u̱, cáchí tu̱hun Ndióxi̱ —na̱cachi rí xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ri̱ já cáchí a̱ já: —Íin inga tucu nu̱ú na̱ca̱hyi̱ tu̱hun Ndióxi̱ ta cáchí a̱ já: “A̱ cóto ndojó tohún Ndióxi̱, xitohún” —na̱cachi Jesús xi̱hi̱n rí cán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ña̱ cán quéa̱ na̱quee xóo tóo tiñáhá sa̱cua̱ha̱ nu̱ Jesús ta na̱quee rí cua̱ha̱n ri̱ jáchi̱ co̱ó na̱ñe̱he̱ íní ri̱ ndá quia̱hva coto ndojó chága̱ rí a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ta ndaja coo na̱ndicó co̱o Jesús estado Galilea. Ta íin cua̱há ndée̱ a̱ jáchi̱ na̱ndicutú nda̱a̱ ínima̱ mé á xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱. Ta ndijáá ña̱yivi ndúu cán na̱casáhá na̱ cáha̱n na̱ sa̱ha̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ta na̱casáhá a̱ jána̱ha̱ tu̱hun Ndióxi̱ nu̱ú ña̱yivi ini veñu̱hu in in ñuu na. Ta tócó ndihi na cáha̱n va̱ha na sa̱há ña̱ cája mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tá na̱ndihi já cuanúhu̱ Jesús ñuu Nazaret nu̱ú na̱sahnu a. Ta mé qui̱vi̱ ndíquehe ndée̱ ná cán, na̱sa̱ha̱n mé á veñu̱hu. Ta na̱caja tá quia̱hva sá caja mé á já na̱nda̱ca̱ ndichi a cahvi a tu̱hun Ndióxi̱ nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na̱sa̱ha̱n na̱ libro na̱ca̱hyí profeta Isaías nu̱ á ña̱ ná cahvi a ña̱ nu̱ú na̱ ndúu veñu̱hu cán. Ta tá na̱suná a̱ libro cán já na̱ndiñe̱he̱ á nu̱ ndáa̱ ña̱ cáchí a̱ já: ");
INSERT INTO mksNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Chútú nda̱a̱ ínima̱ i̱ xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱, jáchi̱ na̱ca̱xi mé á ye̱he̱ ña̱ ná cu̱hu̱n i̱ ca̱xi tu̱hun i̱ tu̱hun sa̱á ña̱ va̱ha nu̱ú na̱ nda̱hví. Ta na̱chindahá mé á ye̱he̱ ña̱ ná ndaja va̱ha i̱ na̱ íin cuéha̱ ini. Ta na̱chindahá mé á ye̱he̱ ña̱ ná ca̱xi tu̱hun i̱ nu̱ú na̱ ndúu ndahá tiñáhá sa̱cua̱ha̱ ndá quia̱hva caja na queta na ndáha̱ ri̱. Ta na̱chindahá mé á ye̱he̱ ña̱ ná cuná i̱ nduchú núú na̱ cua̱á já ná cuu cande̱hé na̱. Ta na̱chindahá a̱ ye̱he̱ ña̱ ná candaa i̱ ña̱ ndóho ini ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta na̱chindahá mé á ye̱he̱ ña̱ ná ca̱ha̱n i̱ xi̱hín ña̱yivi ña̱ sa̱ na̱xi̱nu̱ co̱o tiempo va̱ha ndiva̱ha jáchi̱ cúni̱ Ndióxi̱ caja cua̱há ña̱ma̱ni̱ xi̱hín ña̱yivi, já cáchí ña̱ na̱cahvi Jesús nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tá na̱ndihi já na̱chicaji Jesús libro cán já na̱ndiquia̱hva mé á ña̱ nu̱ú da̱ cája chúun veñu̱hu cán ta na̱saco̱o a. Na̱ ñúhu veñu̱hu cán sánde̱hé na̱ nu̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sa̱há ña̱ cán quéa̱ na̱cachi a já xi̱hi̱n ná: —Mé qui̱vi̱ viti na̱xini ndó na̱xi̱nu̱ co̱o nu̱ú tu̱hun na̱ca̱hyí Isaías sa̱nahá ndiva̱ha —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ta ndijáá ña̱yivi cán cáha̱n va̱ha na sa̱ha̱ Jesús ta cátóntó na̱ sa̱há ña̱ ndató ndiva̱ha tu̱hun cáha̱n xi̱hi̱n ná. Já na̱casáhá ndáca̱ tu̱hún táhan na já cáchí na̱ já: —Á a̱ ju̱ú da̱ yóho cúú ja̱hyi José cán —cáchí na̱ cáha̱n xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A̱nda̱ já na̱cachi Jesús xi̱hín na̱ cán já: —Cája i̱ cuéntá cúni̱ ndó cachi ndó tu̱hun yóho xi̱hín i̱: “Yo̱hó, da̱ cúú doctor ndaja va̱ha jihna mún.” Ta xi̱hín ña̱ yóho cúni̱ ndó cachi ndó xi̱hín i̱: “Ña̱ náhnu na̱xini jo̱ho nde̱ na̱cajún ñuu Capernaum cán, caja ña mé ñuu mún yóho ná cuni nde̱.” ");
INSERT INTO mksNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","A̱nda̱ já na̱ca̱ha̱n chága̱ Jesús xi̱hi̱n ná já na̱cachi tucu a já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ni in túhún toho ña̱yivi co̱ ndíquehe va̱ha na profeta mé ñuu da. ");
INSERT INTO mksNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Tá na̱sahi̱in profeta Elías sa̱nahá já na̱sanduu cua̱há ri na̱ cuáa̱n tañu ña̱yivi Israel ta na̱ndoho ndiva̱ha ini na jáchi̱ na̱quixi in jo̱co ndeé ndiva̱ha sa̱há ña̱ co̱ó na̱cuun ja̱vi̱ ti̱xi u̱ni̱ cui̱a̱ java. ");
INSERT INTO mksNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Joo co̱ó na̱chindahá toho Ndióxi̱ Elías ña̱ ná cu̱hu̱n da̱ chindeé da̱ na̱ ndúu nación Israel cán. Ña̱ na̱caja Ndióxi̱ quéa̱ na̱chindahá a̱ da̱ nu̱ú in ñá cuáa̱n na̱sahi̱in ñuu Sarepta yati ñuu Sidón cán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ta quia̱hva já na̱sahi̱in ri tiempo tá na̱sacuu Eliseo profeta. Mé tiempo cán na̱sanduu cua̱há na̱ na̱ndoho cue̱he̱ táhyi̱ nación Israel cán. Joo in túhún da̱ na̱ndaja va̱ha da̱ cán, da̱ naní Naamán, da̱ na̱quixi ñuu tóho̱ naní Siria —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tá na̱xini jo̱ho na̱ ñúhu veñu̱hu cán ña̱ na̱cachi Jesús xi̱hi̱n ná já na̱xo̱jo̱ ndiva̱ha ini na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Já na̱ndicui̱ta na xi̱hi̱n á ta na̱tavá na̱ Jesús yuhú ñuu. Ta cán na̱jándaa na a̱ ji̱ni̱ yucú jícó nu̱ cánúu ñuu cán. Já na̱ca̱hán na̱ chindahá nihni na a̱ ja̱nda̱ ni̱nu̱. ");
INSERT INTO mksNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Joo na̱ya̱ha Jesús cua̱ha̱n nu̱ ná já na̱quee a cua̱ha̱n va. ");
INSERT INTO mksNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A̱nda̱ já na̱quee Jesús cua̱ha̱n ñuu Capernaum, ña̱ ndáca̱a̱n estado Galilea. Ta cán na̱casáhá jána̱ha̱ tu̱hun Ndióxi̱ nu̱ú ña̱yivi mé qui̱vi̱ ndíquehe ndée̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ta chí cátóntó na̱ tá quia̱hva jána̱ha̱ Jesús nu̱ ná jáchi̱ cáha̱n mé á tátu̱hun in da̱ íin sa̱ha̱ cahnda chuun. ");
INSERT INTO mksNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mé ini veñu̱hu nu̱ ndáca̱a̱n Jesús jána̱ha̱ cán na̱sa̱ndaca̱a̱n in da̱ta̱a, da̱ ndáca̱a̱n in ínima̱ quini ini. Já na̱cayuhú ínima̱ quini cán nu̱ Jesús já cáchí ri̱ já: ");
INSERT INTO mksNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jándacoo táji̱ nde̱he̱, Jesús, da̱ ñuu Nazaret. Ndá cuéntá quéa̱ quíhvi nuún xi̱hín nde̱. A̱ vásún jándihún sa̱há nde̱. Sa̱ xíni̱ va̱ha i̱ yo̱hó ta cánda̱a̱ cáxí ini i̱ ña̱ cúún in da̱ yi̱i̱ na̱chindahá Ndióxi̱ —na̱cachi ínima̱ quini cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","A̱nda̱ já na̱casáhá Jesús jána̱ni a ínima̱ quini ndáca̱a̱n ini da̱ta̱a cán já na̱cachi a já xi̱hi̱n ri̱: —Caji yúhu̱n ta janí da̱ yóho —na̱cachi Jesús xi̱hi̱n ri̱. Tá na̱cachi a já chí na̱jándacava rí quini da̱ta̱a nu̱ú na̱ cán já na̱queta rí ini da̱ cán. Ta co̱ó na̱caja rí ni in ña̱ núu xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tócó ndihi ña̱yivi na̱sanduu cán na̱yi̱hví ndiva̱ha na. Ta já na̱casáhá cáchí xi̱hi̱n táhan na já: —Íin ndiva̱ha sa̱há tu̱hun cáha̱n Jesús yóho jáchi̱ xi̱hín ña̱ cáha̱n da̱ sáhndá da̱ chuun xi̱hi̱n ndée̱ dá ta tává da̱ ínima̱ quini ta chí quée rí cua̱ha̱n ri̱ —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ta níí cúú ñuu válí cán na̱ndicui̱ta nuu tu̱hun sa̱ha̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A̱nda̱ já na̱quee Jesús veñu̱hu cán já cua̱ha̱n vehe in da̱ naní Simón. Tá na̱xi̱nu̱ a̱ cán já na̱qui̱hvi a ini vehe da. Ta na̱xini a ña̱ quíhvi̱ ñá cúú xo̱jo Simón cán, ña̱ chíca̱a̱n cáhni̱ ndeé ña̱. Chí na̱xi̱ca̱ ta̱hví na̱ nu̱ Jesús ña̱ ná ndaja va̱ha mé á ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A̱nda̱ já na̱cayati Jesús nu̱ ña̱ já na̱sahnda chuun nu̱ú cue̱he̱ cán ña̱ ná quee a. Já na̱ndindaa ña̱ chíca̱a̱n cáhni̱ á ña̱ chí i̱vi̱ la̱á na̱ndico̱o ñá já na̱casáhá cája ndíví ñá ña̱ cuxu na. ");
INSERT INTO mksNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tá na̱que̱ta nuu ca̱ndii mé qui̱vi̱ cán já ñéhe ña̱yivi na̱ quíhvi̱ ndúu nu̱ ná na̱xi̱nu̱ na̱ nu̱ Jesús. Tá nu̱ú cue̱he̱ na̱sa̱ndoho na̱ cán ta tá na̱chinúu Jesús ndáha̱ á ji̱ní in in na já na̱ndiva̱ha na na̱caja mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ta cua̱ha̱ táhan na̱ quíhvi̱ cán na̱cana ínima̱ quini ini na na̱caja mé á. Ta tá quéta rí quini cán já cáyuhú cóhó ri̱ nu̱ Jesús já cáchí ri̱ já: —Yóhó cúún in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ —cáchí ri̱ xi̱hi̱n Jesús. Joo na̱jána̱ni Jesús ínima̱ quini cán ta co̱ cúni̱ a̱ quia̱hva ña̱ma̱ni̱ ña̱ ná ca̱ha̱n ri̱ jáchi̱ xíni̱ va̱ha rí cán ña̱ cúú mé á Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tá na̱ti̱vi inga qui̱ví ita̱a̱n já na̱quee Jesús ñuu cán ta cua̱ha̱n in nu̱ cáa xóo. Joo na̱casáhá ña̱yivi ndínducú na̱ mé á ja̱nda̱ quia̱hva na̱xi̱nu̱ na̱ nu̱ íin a jáchi̱ cúni̱ na̱ caji na nu̱u̱ á ná a̱ jándacoo a na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ndítahan nu̱ú i̱ cu̱hu̱n i̱ ca̱xi tu̱hun i̱ xi̱hín ña̱yivi ndúu java ga̱ ñuu ña̱ va̱xi qui̱vi̱ cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. Jáchi̱ chuun yóho na̱chindahá Ndióxi̱ ye̱he̱ va̱xi i̱ —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chí na̱xi̱ca nuu Jesús jána̱ha̱ tu̱hun Ndióxi̱ nu̱ú ña̱yivi ini veñu̱hu estado Galilea cán. ");
INSERT INTO mksNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","In tañu íin Jesús yuhú tañu̱hú naní Genesaret. Ta a̱ ju̱ú quia̱hva na̱taca ña̱yivi chí na̱casáhá cándíhi na Jesús jáchi̱ cúni̱ na̱ cuni jo̱ho na tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ta na̱xini Jesús i̱vi̱ barco ndíta dó yati yuhú tañu̱hú cán. Co̱ó da̱ ñúhu ini dó jáchi̱ sa̱ na̱quee da̱ tává ti̱yacá ta yati jíi̱n va ndícata da ñúnu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A̱nda̱ já na̱qui̱hvi Jesús ini in táhan barco cán, do̱ cúú ña̱ha Simón. Ta na̱cachi Jesús xi̱hi̱n Simón ña̱ ná jácaxícá loho da do̱. Tá na̱ndihi já na̱saco̱o Jesús ini barco já na̱casáhá jána̱ha̱ nu̱ú ña̱yivi ja̱nda̱ mé ini barco cán. ");
INSERT INTO mksNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ta tá sa̱ na̱ndihi na̱ca̱ha̱n xi̱hín ña̱yivi cán já na̱cachi a já xi̱hi̱n Simón: —Cañehe barco yóho ná cu̱hu̱n dó xoo nu̱ cúná chága̱ ticui̱í ta jácanún ñúnu̱n tavún ti̱yacá —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","A̱nda̱ já na̱nducú ñehe Simón tu̱hun nu̱ Jesús já cáchí da̱ já xi̱hi̱n á: —Maestro, nini yaa ñuú na̱caja chúun nde̱ ña̱ ndúcú nde̱ tavá nde̱ ti̱yacá. Ta co̱ó ña̱ha na̱tavá nde̱. Joo tá sa̱ cáchí mé ndó já caja i̱ tá íin cáchí ndo̱ cu̱hu̱n i̱ jácana i̱ ñúnu̱ i̱ ini tañu̱hú —na̱cachi Simón xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ta tá na̱caja da ña̱ na̱cachi Jesús xi̱hi̱n dá já a̱ ju̱ú quia̱hva cua̱há ti̱yacá na̱tavá da̱ chí ja̱nda̱ ñúnu̱ dá cán na̱casáhá táhnda̱. ");
INSERT INTO mksNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","A̱nda̱ já na̱cuu ndáha̱ dá nu̱ú java ga̱ da̱ tává ti̱yacá ñúhu ini inga barco ña̱ ná quixi da chindeé táhan da xi̱hi̱n dá. A̱nda̱ já na̱quixi da̱ cán chindeé táhan da xi̱hi̱n Simón. Já na̱jácutú da̱ ndíví barco cán xi̱hín ti̱yacá chí ja̱nda̱ ndúcú caco̱o dó cán ca̱há tañu̱hú xi̱hín ña̱ cua̱há ti̱yacá na̱que̱e ini dó. ");
INSERT INTO mksNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tá na̱xini Simón Pedro cán ña̱ yóho já na̱caxítí da̱ nu̱ Jesús já cáchí da̱ já xi̱hi̱n á: —A̱ cáyati ndó nu̱ú i̱, xitoho i̱ jáchi̱ cúú u̱ in ta̱a cája cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Já na̱cachi Simón jáchi̱ na̱yi̱hví da̱. Ta quia̱hva já na̱yi̱hví da̱ na̱chindeé táhan xi̱hi̱n dá cán sa̱há ña̱ cua̱ha̱ nahá ti̱yacá na̱tavá da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Quia̱hva já na̱yi̱hví ri Jacobo xi̱hi̱n Juan, da̱ cúú ja̱hyi Zebedeo. Ndíví da̱ yóho chíndeé táhan da xi̱hi̱n Simón cán. Ta já na̱cachi Jesús já xi̱hi̱n Simón: —A̱ cáyi̱hví tohún jáchi̱ viti casáhún caca nuún tavún ña̱yivi tañu cua̱chi tá quia̱hva na̱cajún tá na̱tavún ti̱yacá ini tañu̱hú —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ña̱ cán quéa̱ tá na̱tavá da̱ cán barco da̱ yuhú tañu̱hú cán já na̱jándacoo ndihi da ña̱ha da ta na̱ndi̱co̱ da̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ta ndaja coo íin Jesús in ñuu ta já na̱xi̱nu̱ co̱o in da̱ ndóho cue̱he̱ táhyi̱ nu̱ á. Ta tá na̱xini da Jesús já na̱caxítí da̱ nu̱ á ja̱nda̱ quia̱hva na̱cani ndaa nu̱u̱ dá nu̱ ñúhu̱. Já na̱casáhá xíca̱ ta̱hví da̱ nu̱ á já cáchí da̱ já xi̱hi̱n á: —Cuu ndaja va̱ha ndó ye̱he̱, xitoho i̱ tá cúni̱ ndo̱ —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","A̱nda̱ já na̱cani ndaa ndáha̱ Jesús da̱ já na̱cachi a já: —Cúni̱ ña̱ ná ndiva̱hún ña̱ cán quéa̱ na̱ndiva̱hún viti —na̱cachi Jesús. Tá na̱cachi Jesús já chí i̱vi̱ la̱á na̱ndindaa cue̱he̱ táhyi̱ na̱ndoho da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A̱nda̱ já na̱sahnda Jesús chuun nu̱ dá ña̱ ná a̱ ndícani da nu̱ú ña̱yivi sa̱há ña̱ na̱caja xi̱hi̱n dá. Ña̱ na̱cachi a xi̱hi̱n dá quéa̱: —Cuáhán nda̱cún jána̱hu̱n mún nu̱ú ju̱tu̱. Ta ndítahan jo̱cún ña̱ha nu̱ Ndióxi̱ tátu̱hun na̱sahnda ley Moisés sa̱nahá caja na̱ sa̱ na̱ndiva̱ha. Já ná canda̱a̱ ini ña̱yivi ña̱ sa̱ na̱ndindaa va cue̱he̱ na̱sandohún —na̱cachi Jesús xi̱hín da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Joo ví ga̱ ví na̱casáhá ndícui̱ta nuu tu̱hun sa̱há ña̱ cája Jesús. Sa̱há ña̱ cán quéa̱ tácá cua̱há ndiva̱ha ña̱yivi cuni jo̱ho na nu̱ cáha̱n mé á xi̱hi̱n ná. Ta jári tácá na̱ jáchi̱ cúni̱ na̱ ña̱ ná ndaja va̱ha mé á na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Joo tává xóo Jesús mé á xoo nu̱ú co̱ó ña̱yivi ta cán sá xi̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","In tañu ndáca̱a̱n Jesús ini in vehe jána̱ha̱ nu̱ú ña̱yivi. Tañu na̱ cán na̱sa̱nduu coo java na̱ fariseo xi̱hín java na̱ jána̱ha̱ ley Moisés. Tócó ndihi na cúú ná na̱ na̱quixi ndijáá ñuu válí ñúhu estado Galilea cán xi̱hín ñuu válí ñúhu estado Judea xi̱hín ñuu Jerusalén viti. Ta náha̱ Jesús ña̱ ñéhe a ndée̱ Ndióxi̱ jáchi̱ ndíva̱ha ña̱yivi cája mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mé hora já na̱xi̱nu̱ co̱o java da̱ta̱a ta ñéhe da in xi̱to loho nu̱ cándúhu̱ in da̱ quíhvi̱, da̱ na̱xi̱hi̱ tu̱chu sa̱ha̱. Ta cúni̱ da̱ jáqui̱hvi da da̱ cán ini vehe nu̱ ndáca̱a̱n Jesús cán já chindúhu̱ dá da̱ nu̱ Jesús, na̱ca̱hán da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Joo co̱ó na̱cuu caja da qui̱hvi da jáchi̱ na̱nditútú ndiva̱ha ña̱yivi ndúu na yéhé vehe cán. Sa̱há ña̱ cán quéa̱ na̱ndaa da ji̱ni̱ véhe já na̱tavá da̱ teja cándójó cán. Já na̱jánuu da xi̱to loho nu̱ cándúhu̱ mé da̱ quíhvi̱ cán tañu tócó ndihi ña̱yivi ñúhu ini vehe cán ja̱nda̱ quia̱hva na̱xi̱nu̱ xi̱to da̱ quíhvi̱ cán nu̱ íin Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tá na̱xini Jesús ña̱ cándeé ini da̱ ñéhe da̱ quíhvi̱ cán mé á já na̱cachi a já xi̱hín da̱ quíhvi̱ cán já: —Cande̱hé. Sa̱ na̱caja cáhnu ini i̱ sa̱há cua̱chún viti —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A̱nda̱ já na̱casáhá na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo cán cáhán na̱: “Ndá da̱ cúú da̱ yóho ta ndá cuéntá quéa̱ ndája núu da Ndióxi̱ xi̱hín tu̱hun cáha̱n da̱. Jáchi̱ ni in túhún toho ña̱yivi a̱ cúu caja cáhnu ini sa̱há cua̱chi. In túhún ji̱ni̱ Ndióxi̱ quéa̱ cuu caja cáhnu ini sa̱há cua̱chi”, na̱ca̱hán na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Joo Jesús sa̱ na̱canda̱a̱ va ini a ña̱ cáhvi ini na̱ cán sa̱há ña̱ cán quéa̱ na̱cachi a já xi̱hi̱n ná: —Ndáva̱ha cáhán ndo̱ já. ");
INSERT INTO mksNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Á cáhán ndo̱ ña̱ i̱hvi̱ chága̱ cachi i̱ xi̱hín da̱ yóho: “Na̱caja cáhnu ini i̱ sa̱ha̱ cua̱chún viti.” Á tá co̱ó tá cachi i̱ xi̱hi̱n dá: “Ndico̱o ta cuanúhu̱.” ");
INSERT INTO mksNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Cande̱hé va̱ha ndo̱ ná na̱ha̱ i̱ nu̱ ndo̱ ña̱ íin sa̱há i̱, da̱ na̱chindahá Ndióxi̱ nduu u̱ ña̱yivi, caja cáhnu ini i̱ sa̱há cua̱chi ña̱yivi ñuyíví yóho —na̱cachi Jesús xi̱hín na̱ cán. A̱nda̱ já na̱cachi tucu a xi̱hín da̱ na̱xi̱hi̱ tu̱chu sa̱ha̱ cán já: —Ta viti cáha̱n i̱ xu̱hu̱n, cuándaco̱o ndiquehe xi̱to lohún ta cuánúhu̱. ");
INSERT INTO mksNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tá na̱cachi Jesús já chí i̱vi̱ la̱á na̱ndico̱o da nu̱ ndíhi ña̱yivi ndúu cán jáchi̱ na̱ndiva̱ha sa̱ha̱ dá. Ta na̱ndiquehe da xi̱to loho da nu̱ú na̱sandúhu̱ dá. A̱nda̱ já cája cáhnu da Ndióxi̱ na̱quee da cuanúhu̱ dá vehe da. ");
INSERT INTO mksNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ta tócó ndihi ña̱yivi na̱sa̱nduu cán na̱catóntó na̱ ta na̱caja cáhnu na Ndióxi̱ sa̱há ña̱ na̱caja Jesús. Ta a̱ ju̱ú quia̱hva yíhví na̱ já na̱cachi na já: —Ña̱ náhnu ndiva̱ha va quéa̱ na̱xiní qui̱vi̱ viti —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tá na̱ndihi já na̱quee Jesús xíca cua̱ha̱n. Ta cán na̱xini a in da̱ játaca jiu̱hún cuéntá impuesto. Mé da̱ yóho naní da̱ Leví ta íin coo da nu̱ sáco̱o na̱ játaca jiu̱hún cuéntá impuesto cán. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Naha quíi̱ candi̱cu̱n ye̱he̱ —na̱cachi a xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A̱nda̱ já na̱nda̱ca̱ ndichi Leví cán ta na̱jándacoo da tócó ndihi ña̱ha cán ta já na̱casáhá ndíco̱ da̱ Jesús xíca da. ");
INSERT INTO mksNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tá na̱ndihi já na̱cava̱ha Leví in víco̱ cáhnu mé vehe da cán ña̱ caja cáhnu da Jesús. Ta cán na̱taca cua̱ha̱ táhan na̱ játaca jiu̱hún cuéntá impuesto ndúu na vehe da. Ta cua̱há ga̱ ña̱yivi na̱taca ndúu coo nu̱ mesa cán. ");
INSERT INTO mksNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Joo na̱ fariseo xi̱hín na̱ jána̱ha̱ ley Moisés na̱casáhá na̱ cáha̱n núu na sa̱há na̱ xíca tuun xi̱hi̱n Jesús já na̱cachi na já: —Ndá cuéntá quéa̱ xíxi ndó xi̱hín na̱ játaca jiu̱hún cuéntá impuesto ta xi̱hín java ga̱ na̱ cája cua̱chi —na̱cachi na̱ cán xi̱hín na̱ xíca tuun xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ú na̱ cán já na̱cachi a já xi̱hi̱n ná: —Ña̱yivi íin va̱ha co̱ xíní ñúhú toho na da̱ cája tátá ñahá joo na̱ quíhvi̱, na̱ cán cúú na̱ xíní ñúhú da̱ cája tátá ñahá. ");
INSERT INTO mksNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ta ye̱he̱ co̱ó va̱xi toho i̱ cana i̱ na̱ sa̱ íin va̱ha. Va̱xi i̱ cana i̱ ña̱yivi, na̱ cája cua̱chi ña̱ ná jándacoo na cua̱chi cája na —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A̱nda̱ já na̱casáhá ndáca̱ tu̱hún tucu na Jesús já cáchí na̱ já xi̱hi̱n á: —Xíní nde̱ ña̱ xíca̱ ta̱hví ndiva̱ha va na̱ na̱saxi̱ca tuun xi̱hi̱n Juan ta jári xíjuhun ndiva̱ha va na̱ cán. Ta quia̱hva já cája na̱ fariseo. Joo na̱ xíca tuun xi̱hi̱n yóhó ja̱n níí tiempo xíxi na pan ta xíhi na vino. Ndá cuéntá quéa̱ cája na já —na̱cachi na̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já cáchí a̱ já xi̱hi̱n ná: —Cúú á tátu̱hun tá cája na víco̱ tánda̱ha̱ ta íin va mé da̱ tánda̱ha̱ cán xi̱hi̱n ná já quéa̱ co̱ ndítahan nu̱ ná cajuhun na. Quia̱hva já íin ri xi̱hín ye̱he̱ va. Co̱ó sa̱ha̱ cajuhun na̱ xíca tuun xi̱hín i̱ jáchi̱ íin vi̱ xi̱hi̱n ná viti. ");
INSERT INTO mksNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Joo va̱xi qui̱vi̱ ndindaa i̱ nu̱ú na̱ yóho. A̱nda̱ já casáhá na̱ yóho cajuhun na —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A̱nda̱ já na̱sacu Jesús quia̱hva nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Ni in túhún toho ña̱yivi co̱ sáhndá na̱ in túhu̱n jáhma̱ sa̱á já ndicahmá na̱ in jáhma̱ yatá. Jáchi̱ tá ná caja na já játi̱ví na̱ jáhma̱ sa̱á cán. Ta ni co̱ ndíque táhan va̱ha in jáhma̱ yatá tá jándaha na ña̱ xi̱hín in túhu̱n jahmá sa̱á. ");
INSERT INTO mksNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ta ni in túhún toho ña̱yivi co̱ táán na̱ vino sa̱á ini in nií yatá. Jáchi̱ tá ná caja na já já quéa̱ jáca̱hndi̱ va vino sa̱á nií yatá cán. Ta xi̱hín ña̱ yóho ti̱vi níi̱ cán ta ti̱vi ri dó cúú vino cán va. ");
INSERT INTO mksNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ña̱ ndítahan caja na quéa̱ taán na vino sa̱á ini nií sa̱á já ná cuu cañuhu va̱ha dó cán ta mé níi̱ co̱ cáhndi̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ta ni in túhún táhan na̱ xíhi vino yatá co̱ xíca̱ na̱ vino sa̱á coho na jáchi̱ cáchí na̱ ña̱ va̱ha chága̱ xíhi dó yatá —na̱cachi Jesús xi̱hín quia̱hva sácú a̱ nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","In qui̱vi̱ ndíquehe ndée̱ ña̱yivi nani xíca Jesús cua̱ha̱n xi̱hín na̱ xíca tuun xi̱hi̱n á já na̱ya̱ha na tañu nu̱ú na̱xutu na trigo. Já na̱casáhá na̱ cán túhun na yu̱cu̱ ji̱ni̱ trigo cán já tává na̱ trigo já chíníhni ndáha̱ ná a̱ ta sáxí na̱ cása̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tá na̱xini java na̱ fariseo cán ña̱ cája na já na̱cachi na já: —Ndáva̱ha cája ndó chuun ña̱ co̱ ndítahan caja ndó qui̱vi̱ ndíquehe ndée̱ yo̱ —na̱cachi na̱ fariseo cán xi̱hín na̱ xíca tuun xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a: —Á a̱ ñáha cahvi ndó nu̱ú tu̱hun Ndióxi̱ nu̱ cáha̱n sa̱há ña̱ na̱caja David sa̱nahá tá na̱cuico da xi̱hín na̱ xíca xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ña̱ na̱caja da̱ cán quéa̱ na̱qui̱hvi da ini veñu̱hu Ndióxi̱ ta na̱tiin da pan yi̱i̱ já na̱xixi da ña̱ ta na̱sa̱ha̱n da̱ ña̱ nu̱ú na̱ xíca xi̱hi̱n dá ña̱ ná cuxu na. Joo ju̱tu̱ cuití va cúú na̱ ndítahan nu̱ú cuxu ña̱ cán, nduu. ");
INSERT INTO mksNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ta ye̱he̱ va, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi íin sa̱há i̱ cahnda i̱ chuun sa̱há qui̱vi̱ ndíquehe ndée̱ ña̱yivi —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Inga tucu qui̱vi̱ ndíquehe ndée̱ ná já na̱qui̱hvi Jesús ini in veñu̱hu ta na̱casáhá jána̱ha̱ nu̱ ná. Ta ini mé veñu̱hu cán na̱sa̱ndaca̱a̱n in da̱ta̱a, da̱ na̱hi̱chi̱ ndahá cuáha. ");
INSERT INTO mksNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ta ndaja coo na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo nání na̱ Jesús sánde̱hé na̱ ña̱ á ndaja va̱ha mé á da̱ cán qui̱vi̱ ndíquehe ndée̱ na̱. Ta xi̱hín ña̱ yóho cáhán na̱ cuu ñe̱he̱ íní na̱ jácojo na cua̱chi ja̱tá. ");
INSERT INTO mksNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Joo sa̱ xíni̱ va Jesús ña̱ cáhvi ini na̱ cán. Sa̱há ña̱ cán quéa̱ na̱cachi a já xi̱hín da̱ na̱hi̱chi̱ ndáha̱ cán já: —Cuándaco̱o ta candichi ma̱hñú yóho —na̱cachi Jesús xi̱hi̱n dá. A̱nda̱ já na̱nda̱ca̱ ndichi da̱ cán nu̱ú Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A̱nda̱ já na̱casáhá Jesús cáha̱n xi̱hín java ga̱ na̱ ndúu cán já na̱cachi a já xi̱hi̱n ná: —Cuni jo̱ho ndó ná nda̱ca̱ tu̱hún i̱ ndo̱hó. Ndía cáchí ley ndítahan caja í mé qui̱vi̱ ndíquehe ndée̱ ña̱yivi. Á chindeé yo̱ ña̱yivi á caja í ña̱ núu xi̱hi̱n ná. Á jáca̱cú na̱ á cahní yó na̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A̱nda̱ já na̱ndicoto nihni Jesús nu̱ú ndihi na na̱ca̱va̱ nuu ndúu xi̱hi̱n á cán. Ta na̱cachi a já xi̱hín da̱ na̱hi̱chi̱ ndáha̱: —Jándaca̱a̱ ndáhu̱n. Ta tá na̱jándaca̱a̱ da̱ cán ndáha̱ dá chí i̱vi̱ la̱á na̱ndiva̱ha ndáha̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Joo tócó ndihi na̱ java ndúu cán na̱xo̱jo̱ ndiva̱ha ini na. Já na̱casáhá ndítúhún xi̱hi̱n táhan na ña̱ ndá quéa̱ cuu caja na já ná cuu jándihi na sa̱ha̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mé tañu já na̱quee Jesús na̱sa̱ha̱n in ji̱ni̱ yúcu̱ ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱. Ta níí cúú ñuú na̱xi̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ta tá sa̱ na̱ti̱vi já na̱cana mé á na̱ xíca xi̱hi̱n á. Ta tañu na̱ cán na̱ca̱xi a u̱xu̱ i̱vi̱ da̱ cacuu da in táhndá ta̱a cananí apóstol, da̱ chíndahá a̱ caca nuu cáha̱n tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na̱ca̱xi a da̱ naní Simón, da̱ na̱sacu tucu a qui̱vi̱ cananí Pedro. Ta na̱ca̱xi a da̱ cúú ñani Pedro, da̱ naní Andrés. Ta na̱ca̱xi a Jacobo xi̱hi̱n Juan xi̱hi̱n Felipe xi̱hi̱n Bartolomé ");
INSERT INTO mksNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","xi̱hi̱n Mateo xi̱hi̱n Tomás xi̱hi̱n Jacobo, da̱ cúú ja̱hyi Alfeo. Ta na̱ca̱xi a Simón, da̱ na̱xi̱ca cuéntá na̱ cananista. ");
INSERT INTO mksNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ta na̱ca̱xi ri a Judas, ñani Jacobo xi̱hi̱n Judas Iscariote, mé da̱ na̱ji̱có túhún Jesús tá nu̱ ndíhí. ");
INSERT INTO mksNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tá na̱ndihi na̱nuu Jesús ji̱ni̱ yúcu̱ xi̱hín na̱ xíca tuun xi̱hi̱n á já na̱xi̱nu̱ a̱ yojó nda̱a̱ na̱sahi̱in a xi̱hi̱n ná. Ta cán na̱sa̱nduu ri cua̱há ndiva̱ha ña̱yivi táhan na̱ na̱quixi ndijáá ñuu válí ndúu chí estado Judea xi̱hín na̱ ndúu ñuu Jerusalén xi̱hín na̱ ndúu ñuu Tiro xi̱hi̱n Sidón, ña̱ ndúu yati yuhú tañu̱hú. Ta tócó ndihi ña̱yivi yóho na̱xi̱nu̱ na̱ cuni jo̱ho na nu̱ cáha̱n Jesús. Ta na̱xi̱nu̱ na̱ jáchi̱ cúni̱ na̱ ña̱ ná ndaja va̱ha mé á na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ta tócó ndihi na̱ na̱sañuhu ínima̱ quini ini na̱ndaja va̱ha ri Jesús na̱ jáchi̱ na̱tavá a̱ ínima̱ quini na̱sañuhu ini na. ");
INSERT INTO mksNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ta tócó ndihi ña̱yivi cúni̱ na̱ cani ndaa ndáha̱ ná Jesús jáchi̱ xi̱hi̱n ndée̱ mé á ndája va̱ha tócó ndihi na̱ quíhvi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tá na̱ndihi já na̱sande̱hé Jesús nu̱ú na̱ xíca tuun xi̱hi̱n á já na̱casáhá cáchí a̱ já xi̱hi̱n ná: —Ta̱hví na̱cuu ndó, na̱ cándáhví jáchi̱ ndóhó cúú na̱ cacomí Ndióxi̱ cuéntá sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ʼTa̱hví na̱cuu ndó, na̱ cuíco viti ñúhú jáchi̱ ndóhó cacuu na̱ chutú nda̱a̱ tá ná ndihi. ʼTa̱hví na̱cuu ndó, na̱ sácu viti jáchi̱ ndóhó cacuu na̱ casáhá cua̱cu̱ tá nu̱ ndíhí. ");
INSERT INTO mksNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ʼTa̱hví na̱cuu ndó tá cándají ña̱yivi ndo̱hó ta casáhá táxí na̱ ndo̱hó á cánahá na̱ xi̱hi̱n ndo̱. Ta ta̱hví na̱cuu ndó tá quéhe núu na ndo̱hó sa̱há ña̱ cáhán na̱ ña̱ cúú ndó na̱ núu ndiva̱ha. Tá ná caja na tócó ndihi ña̱ yóho xi̱hi̱n ndo̱ sa̱há ña̱ cándeé ini ndó ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi, ta̱hví na̱cuu ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Já quéa̱ ndítahan cáji̱i̱ ndiva̱ha ini ndó mé qui̱vi̱ já jáchi̱ sa̱ na̱xi̱ca̱ ta̱hví Ndióxi̱ in ña̱ va̱ha ndiva̱ha íin indiví quia̱hva nu̱ ndo̱. Jáchi̱ tá quia̱hva cája xíxi na̱ ja̱n xi̱hi̱n ndó viti quia̱hva já na̱caja xíxi ri tásáhnu jícó na̱ ja̱n xi̱hín na̱ na̱sacuu profeta sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ʼJoo ndáhví na̱cuu ndó, na̱ cui̱cá viti jáchi̱ sa̱ na̱caji̱i̱ ndiva̱ha va ini ndó ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ʼNdáhví na̱cuu ndó, na̱ na̱chutú nda̱a̱ viti jáchi̱ ndóhó cúú na̱ quixi ta̱ma̱ nu̱u̱. ʼNdáhví na̱cuu ndó, na̱ sácu̱ viti jáchi̱ ndóhó cúú na̱ cuacu xi̱hi̱n ña̱ cacuéha̱ ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ʼNdáhví na̱cuu ndó tá ná casáhá ña̱yivi ca̱ha̱n va̱ha na sa̱ha̱ ndo̱ jáchi̱ quia̱hva já na̱ca̱ha̱n va̱ha tásáhnu jícó na̱ ja̱n sa̱há na̱ profeta túhún na̱sa̱nduu na̱jándahvi ña̱yivi sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ʼTócó ndihi ndó, na̱ xíni̱ jo̱ho nu̱ cáha̱n i̱ yóho, ndítahan qui̱hvi̱ ini ndó na̱ co̱ cúní ndo̱hó. Ta xíní ñúhú caja va̱ha ndó xi̱hi̱n ndá na̱ cándají ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xíní ñúhú ca̱ca̱ ta̱hví ndó nu̱ Ndióxi̱ ña̱ ná caja yi̱i̱ á na̱ na̱chica̱a̱n cháhan ja̱ta̱ ndo̱. Ta ca̱ca̱ ta̱hví ndó nu̱ Ndióxi̱ sa̱há na̱ cánahá xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta ndá na̱ ná cani in xoo sa̱jóho ndó, cata ñee ndó inga xoo sa̱jóho ndó nu̱ ná ña̱ ná cani na. Ta tá ná candaa na jahmá ndeé ndo̱ quia̱hva ndó ña̱ma̱ni̱ ña̱ ná quehe ri na cotó ndo̱ tá já cúni̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","A̱ cájíhnda̱ ndó nu̱ú na̱ xíca̱ ña̱ha nu̱ ndo̱. Ta ndá na̱ cándaa ña̱ cúú ña̱ha ndó, a̱ ndínda̱ca̱ ndó ña̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tá quia̱hva cúni̱ ndó caja ña̱yivi xi̱hi̱n ndo̱ quia̱hva já ndítahan caja ri ndóhó va xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ʼJáchi̱ tá quíhvi̱ ini ndó ña̱yivi sa̱há ña̱ quíhvi̱ ri ini na̱ cán ndo̱hó va, ndía va̱ha cája ndó jáchi̱ quia̱hva já cája ña̱yivi quini. ");
INSERT INTO mksNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ta tá cája va̱ha cuití ndo̱ xi̱hín na̱ cája va̱ha xi̱hi̱n mé ndó, ndía va̱ha cája ndó jáchi̱ quia̱hva já cája ri ña̱yivi quini va. ");
INSERT INTO mksNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ta tá sáhan tóo ndó ña̱ha ndó nu̱ú ña̱yivi sa̱há ña̱ cáhán ndo̱ caja na ña̱ma̱ni̱ xi̱hi̱n mé ndó, ndía va̱ha cája ndó jáchi̱ quia̱hva já cája ri ña̱yivi quini va. ");
INSERT INTO mksNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Joo ndóhó, xíní ñúhú qui̱hvi̱ ini ndó na̱ co̱ cúní ndo̱hó. Ta xíní ñúhú caja va̱ha ndó xi̱hín ña̱yivi. Ta xíní ñúhú quia̱hva tóo ndó ña̱ha ndó ta a̱ cándati ndó ña̱ ná nducú ñehe na̱ cán ña̱ nu̱ ndo̱. Tá ná caja ndó já já quéa̱ ñe̱he̱ táhvi̱ ndó ña̱ va̱ha ndiva̱ha caja Ndióxi̱ ta nduu ndó ja̱hyi Ndióxi̱, mé a̱ cúú Ndióxi̱ cáhnu ndiva̱ha. Jáchi̱ mé Ndióxi̱ cándáhví ini a ndá na̱ co̱ ndíquia̱hva ndixa̱hvi nu̱ mé á ta cándáhví ri ini a ña̱yivi quini va. ");
INSERT INTO mksNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Xíní ñúhú ta̱hnda̱ ini ndó sa̱há ña̱yivi tá quia̱hva táhnda̱ ini Ndióxi̱ sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ʼA̱ cánde̱hé ndaa ndó ña̱yivi já ná a̱ cája Ndióxi̱ já xi̱hi̱n ndo̱. A̱ chíca̱a̱n ndó cua̱chi ja̱tá inga na já ná a̱ quéhe Ndióxi̱ cuéntá sa̱há cua̱chi mé ndó. Caja cáhnu ini ndó sa̱ha̱ ná já ná caja cáhnu ini Ndióxi̱ sa̱ha̱ mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jasá ndo̱ ña̱ha nu̱ú ña̱yivi já ná ñe̱he̱ ndó ña̱ha nu̱ Ndióxi̱. Cúú á tátu̱hun cája ña̱yivi tá jáchutú na̱ in ndo̱ho̱ xi̱hín nu̱ni̱ ta quíji nihni na ndo̱ho̱ já ná ndituun a ta jácu̱yu chága̱ na̱ nu̱ni̱ já táán na̱ ña̱ ini a ja̱nda̱ quia̱hva xíta̱ ña̱ yuhú ndo̱ho̱ cán. Tá quia̱hva cája mé ndó xi̱hín ña̱yivi quia̱hva já caja Ndióxi̱ xi̱hi̱n ndo̱ jáchi̱ tá cua̱ha̱ sáhan ndó nu̱ú ña̱yivi quia̱hva já cua̱ha̱ quia̱hva ri Ndióxi̱ nu̱ ndóhó va —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tá na̱ndihi já na̱sacu a quia̱hva nu̱ ná já na̱cachi a já: —A̱ cu̱ú toho caja in ta̱a cua̱á candaca da inga da̱ cua̱á cu̱hu̱n da̱ jáchi̱ ndíví já da̱ ndicava da yávi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ni in túhún toho da̱ xíca jácuaha tia̱hva chága̱ nu̱ mé da̱ jána̱ha̱ ñahá cán. Joo tá ná xi̱nu̱ qui̱vi̱ já catia̱hva va̱ha da já canda̱a̱ ini da tócó ndihi ña̱ xíni̱ da̱ na̱jána̱ha̱ ñahá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ʼJáchi̱ ndá cuéntá quéa̱ sánde̱hé ndó ña̱ núu cája ñani táhan ndó ta co̱ sánde̱hé ndo̱ ndá quia̱hva náhnu chága̱ ña̱ núu cája mé ndó. Cúú á tátu̱hun ndáca̱a̱n in xe̱he̱ loho nduchú núú ñani táhan ndó nani ndáca̱a̱n in yíto̱ ndúhu̱ cáhnu ini nduchú núú ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ta tá a̱ cu̱ú cuni ndó yitó cáhnu ndáca̱a̱n ini nduchú núú mé ndó ndaja caja ndó cachi ndó xi̱hín ñani táhan ndó: “Ñani i̱, ná tavá loho i̱ xe̱he̱ ndáca̱a̱n nduchú núún ja̱n.” Jándahvi ndó mé ndó xi̱hín ña̱ cája ndó. Xíní ñúhú tavá ndo̱ yíto̱ cáhnu ndáca̱a̱n nduchú núú mé ndó já ná nu̱na̱ nu̱ ndó cuni va̱ha ndó já ná cuu tavá ndó xe̱he̱ loho ndáca̱a̱n nduchú núú ñani táhan ndó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","A̱nda̱ já na̱casáhá tucu a cáchí já: —Co̱ó toho yitó va̱ha cúun cui̱hi quini nu̱u̱. Ta ni co̱ó yitó quini cuu cuun cui̱hi va̱ha nu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jáchi̱ xi̱hín cui̱hi cúun nu̱ú in in yíto̱ cánda̱a̱ iní ndá yíto̱ cúú dó. A̱ vája cúú tu̱hun sáhndá ña̱yivi tití ñu̱hú nu̱ú to̱híñú. Ta ni a̱ vája cúú tu̱hun sáhndá na̱ uva nu̱ú tonáña̱ yúcú. ");
INSERT INTO mksNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","In ta̱a va̱ha cáha̱n da̱ ndinuhu ña̱ va̱ha jáchi̱ ndinuhu ña̱ va̱ha ñúhu ínima̱ dá. Ta in ta̱a quini cáha̱n da̱ ndinuhu ña̱ núu jáchi̱ ña̱ núu quéa̱ ndáca̱a̱n ínima̱ dá. Jáchi̱ yúhu̱ ña̱yivi cána tócó ndihi ña̱ na̱ndicutú ñúhu ínima̱ ná —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Cáha̱n tucu Jesús já cáchí a̱ já: —Ndá cuéntá quéa̱ cáha̱n xitoho na̱há ndó ye̱he̱ ta co̱ cája ndó ña̱ sáhndá i̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ná ca̱ha̱n i̱ xi̱hi̱n ndó ndaja íin da̱ va̱xi nu̱ú i̱ cuni jo̱ho da tu̱hun cáha̱n i̱ ta cája da ña̱ cáchí i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Cúú dá tátu̱hun in da̱ta̱a na̱cava̱ha vehe. Tá na̱casáhá da̱ tává da̱ sa̱há vehe da já na̱sata cúná da̱ já ná chinúu da vehe da ja̱ta̱ tóto̱. Ta tá na̱sa̱hnu̱ cua̱há yu̱ta já na̱cani ndaa ni̱hi ticui̱í cán ja̱tá vehe da. Joo co̱ó na̱ndicava vehe da na̱caja ticui̱í cán jáchi̱ tóyíí cándichi vehe da ja̱ta̱ tóto̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Joo ndá da̱ xíni̱ jo̱ho nu̱ cáha̱n i̱ ta co̱ cája da ña̱ cáchí i̱, cúú dá tátu̱hun inga da̱ta̱a, da̱ na̱cava̱ha vehe nu̱ ñúhu̱ uun. Ta co̱ó na̱sata da nu̱ú na̱ndu̱xu̱ sa̱há. Ta tá na̱sa̱hnu̱ cua̱há yu̱ta já na̱cani ndaa ni̱hi ticui̱í cán ja̱tá vehe da. Ta xi̱hín ña̱ yóho na̱ndicava vehe da ta chí na̱ndihi sa̱ha̱ chí uun —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tá na̱ndihi na̱ca̱ha̱n Jesús xi̱hín ña̱yivi cán já na̱quee a cua̱ha̱n chí Capernaum. ");
INSERT INTO mksNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mé ñuu Capernaum cán na̱sahi̱in in da̱ta̱a, da̱ sáhndá chuun nu̱ú soldado na̱quixi ñuu Roma. Mé da̱ yóho na̱sahi̱in in mozo da̱ ta quíhvi̱ ndiva̱ha ini da mozo da̱. Joo ndaja coo mé mozo da̱ yóho quíhvi̱ ndeé da̱ ta ja̱nda̱ ja̱ chá quivi da. ");
INSERT INTO mksNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tá na̱xini jo̱ho da̱ sáhndá chuun nu̱ú soldado yóho sa̱há Jesús já na̱chindahá da̱ java na̱ sa̱cua̱ha̱ táhan na̱ na̱quixi chi̱chi Israel já ná ca̱ca̱ na̱ ña̱ma̱ni̱ nu̱ú Jesús quixi a ndaja va̱ha mozo da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tá na̱xi̱nu̱ na̱ cán nu̱ú Jesús na̱casáhá xíca̱ ta̱hví ndiva̱ha na nu̱ á já cáchí na̱ já xi̱hi̱n á: —Íin sa̱há da̱ sáhndá chuun nu̱ú soldado yóho ña̱ ná chindeé ndó da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Jáchi̱ quíhvi̱ ini da tócó ndihi ña̱yivi ndúu nación Israel ta sa̱ mé da̱ ja̱n cúú da̱ na̱sahnda chuun ña̱ ná cava̱ha na veñu̱hu nde̱ —na̱cachi na̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","A̱nda̱ já na̱quee Jesús cua̱ha̱n xi̱hi̱n ná. Joo tá sa̱ ja̱lóho xi̱nu̱ co̱o na vehe da̱ sáhndá chuun nu̱ú soldado cán já na̱chindahá da̱ java amigo da̱ nu̱ú Jesús ná ca̱ha̱n na̱ yuhú nu̱u da já na̱cachi na já: —A̱ jándi̱hi ndó mé ndó ndi̱hvi ndó vehe e̱, xitoho i̱ jáchi̱ co̱ó sa̱ha̱ toho i̱ ña̱ ná ndi̱hvi ndó vehe e̱. ");
INSERT INTO mksNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sa̱há ña̱ cán quéa̱ co̱ó na̱sa̱ha̱n ndeé ini i̱ cu̱hu̱n i̱ ndinducú u̱ mé ndó. Joo ja̱nda̱ nu̱ íin ndó ja̱n cahnda ndó chuun ña̱ ná ndiva̱ha mozo i̱ já ndiva̱ha da. ");
INSERT INTO mksNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jáchi̱ ndúu java na̱ náhnu chága̱ sáhndá chuun nu̱ú i̱. Ta ndúu ri soldado sáhndá ri ye̱he̱ va chuun nu̱u̱. Ta tá chíndahá i̱ in da ña̱ ná cu̱hu̱n da̱ nu̱ cúni̱ mí i̱ cu̱hu̱n da̱ ta cua̱ha̱n da̱. Ta tá sáhndá i̱ chuun nu̱ú inga da ña̱ ná quixi da nu̱ú i̱ ta va̱xi da nu̱ú i̱. Ta tá sáhndá i̱ chuun nu̱ mozo i̱ ña̱ ná caja da ña̱ sáhndá i̱ ta cája da ña̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tá na̱xini jo̱ho Jesús tócó ndihi ña̱ na̱ca̱ha̱n amigo da̱ sáhndá chuun nu̱ú soldado cán xi̱hi̱n á já na̱catóntó a̱ xi̱hín da̱ta̱a cán. A̱nda̱ já na̱sande̱hé a̱ nu̱ tócó ndihi ña̱yivi ndíco̱ cua̱ha̱n cán já na̱cachi a já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ a̱ ñáha cuni i̱ tañu na̱ Israel in da̱ cándeé cáhnu na̱há ini Ndióxi̱ tá quia̱hva cándeé cáhnu ini da̱ yóho Ndióxi̱ —na̱cachi Jesús xi̱hín na̱ ndíco̱ ja̱tá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ta tá na̱ndicó co̱o na̱ cúú mozo da̱ sáhndá chuun nu̱ú soldado cán vehe da já na̱xini na ña̱ sa̱ na̱ndiva̱ha va da̱ na̱sa̱quíhvi̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tá sa̱ na̱ya̱ha ña̱ yóho já na̱quee Jesús cua̱ha̱n chí in ñuu naní Naín xi̱hín na̱ xíca tuun xi̱hi̱n á. Ta a̱ ju̱ú quia̱hva cua̱há ña̱yivi ndíco̱ cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tá na̱xi̱nu̱ co̱o a yati yuhú ñuu cán já na̱xini a ña̱yivi ñéhe na in ndi̱i cua̱ha̱n na̱ jándu̱xu̱ na̱. Mé ndi̱i cán na̱sacuu da in túhún já nu̱ náná da̱, ñá cúú ñá cuáa̱n. Ta a̱ ju̱ú quia̱hva cua̱há ña̱yivi ñuu cán ndáca táhan xi̱hi̱n ñá cua̱ha̱n na̱ jándu̱xu̱ na̱ ja̱hyi ñá. ");
INSERT INTO mksNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tá na̱xini Jesús ña̱ já na̱ta̱hvi̱ ini a sa̱ha̱ ña̱. A̱nda̱ já na̱cachi a já xi̱hi̱n ña̱: —A̱ cuácu ga̱u̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","A̱nda̱ já na̱cayati Jesús nu̱ú sa̱tó ndi̱i cán já na̱cani ndaa ndáha̱ á do̱. A̱nda̱ já na̱sa̱cui̱ta na̱ ndójo sa̱tó ndi̱i cán. Ta na̱ca̱ha̱n Jesús xi̱hín da̱ cúú ndi̱i cán já na̱cachi a já xi̱hi̱n dá: —Ye̱he̱ cáha̱n i̱ xu̱hu̱n, da̱ tacú, cuándaco̱o —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A̱nda̱ já na̱saco̱o da̱ na̱sacuu ndi̱i cán ta na̱casáhá da̱ cáha̱n da̱. Já na̱ndiquia̱hva Jesús da̱ nu̱ náná da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tá na̱xini tócó ndihi ña̱yivi cua̱ha̱n cán ña̱ na̱caja Jesús já yíhví na̱. Ta na̱casáhá na̱ cája cáhnu na Ndióxi̱ já cáchí na̱ já: —In profeta cáhnu ndiva̱ha cúú da̱ na̱xi̱nu̱ co̱o tañu mí yóho viti. Ta na̱cachi tucu na: —Ndióxi̱ quéa̱ na̱xi̱nu̱ co̱o nu̱ yo̱ ña̱ ná chindeé a̱ ña̱yivi cuéntá mé á —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ta níí cúú ña̱yivi cuéntá estado Judea xi̱hín na̱ ndúu yati cán na̱canda̱a̱ ini na sa̱há ña̱ na̱caja Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ta ndaja coo na̱ñe̱he̱ Juan, da̱ jácandúta̱ ña̱yivi, tu̱hun sa̱ha̱ tócó ndihi ña̱ na̱caja Jesús yóho jáchi̱ na̱ndicani na̱ xíca xi̱hi̱n Juan ña̱ nu̱ dá. Sa̱há ña̱ cán quéa̱ na̱cana da i̱vi̱ táhan da̱ xíca xi̱hi̱n da̱ ");
INSERT INTO mksNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","já na̱chindahá da̱ na̱ nu̱ Jesús ña̱ ná nda̱ca̱ tu̱hún na̱ mé á á jivi ndusa cúú á Cristo, mé a̱ chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi, á ndítahan candati na inga ga̱ quixi. ");
INSERT INTO mksNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tá na̱xi̱nu̱ na̱ xíca xi̱hi̱n Juan nu̱ íin Jesús já na̱cachi na já xi̱hi̱n á: —Da̱ naní Juan, da̱ xíca jácandúta̱ ña̱yivi, da̱ cán cúú da̱ na̱chindahá nde̱he̱ va̱xi nde̱ nda̱ca̱ tu̱hún nde̱ ndo̱hó á cúú ndó Cristo, ña̱ chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi, á ndítahan candati nde̱ inga ga̱ —na̱cachi na̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mé hora na̱xi̱nu̱ co̱o na̱ cán nu̱ íin Jesús já na̱xini na na̱ndaja va̱ha Jesús cua̱há ña̱yivi quíhvi̱, na̱ na̱sandoho tá nu̱ú cue̱he̱. Ta na̱tavá a̱ ínima̱ quini na̱sañuhu ínima̱ java na. Ta cua̱há ndiva̱ha na̱ cua̱á na̱ndinu̱na̱ nu̱u̱ na̱caja Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sa̱há ña̱ cán quéa̱ tá na̱nducú ñehe Jesús tu̱hun nu̱ú na̱ xíca xi̱hi̱n Juan cán já na̱cachi a já xi̱hi̱n ná: —Cuáhán ndó ndicani ndó nu̱ Juan sa̱ha̱ tócó ndihi ña̱ na̱xini ndó cája i̱ xi̱hi̱n tócó ndihi ña̱ na̱xini jo̱ho ndó cáha̱n i̱. Ta ndicani ndó nu̱ dá ña̱ ndínu̱na̱ nu̱ú na̱ cua̱á ta ndícaca na̱ rénco̱ cája i̱. Ta ndája va̱ha i̱ na̱ ndóho cue̱he̱ táhyi̱. Ta jándinu̱na̱ i̱ jo̱ho na̱ jóho̱ já ná cuni jo̱ho na. Ta jánditacu u̱ ndi̱i. Ta cáxi tu̱hun i̱ tu̱hun Ndióxi̱ nu̱ú na̱ nda̱hví já ná cuu ca̱cu ndaa ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ta̱hví na̱cuu na̱ co̱ jándacoo ña̱ cándeé ini na ye̱he̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tá na̱quee na̱ na̱chindahá Juan cán cua̱ha̱n na̱ já na̱casáhá Jesús cáha̱n sa̱ha̱ Juan nu̱ú ña̱yivi cán já cáchí a̱ já xi̱hi̱n ná: —Ndía̱ na̱ca̱hán ndó cuni ndó tá na̱queta ndó na̱sa̱ha̱n ndó sánde̱hé ndo̱ Juan yucú íchí cán. A̱ ju̱ú da̱ cán cúú ta̱a láhá já quíji nuu da tátu̱hun quíji nuu in tíyo̱ó cája ta̱chi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ndía̱ na̱queta ndó cande̱hé ndó. A̱ ju̱ú da̱ cán cúú ta̱a ndíxi jahmá lánda̱ ndiva̱ha. Sa̱ xíni̱ va̱ha ndó ña̱ co̱ ndúu toho da̱ ndíxi jahmá lánda̱ yucú íchí. Ndá da̱ ndíxi jahmá lánda̱ ta cája da ña̱ cúni̱ yiquí cu̱ñu da, mé da̱ cán cúú da̱ ndúu vehe rey cuití va. ");
INSERT INTO mksNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ndía̱ na̱sa̱ha̱n ndó na̱xini ndó cán. Á co̱ó na̱sa̱ha̱n ndó cuni jo̱ho ndó nu̱ cáha̱n in da̱ cúú profeta nu̱ ndo̱. Mé a̱ nda̱a̱ da̱ cán cúú dá in profeta ta íin chága̱ sa̱ha̱ dá a̱ ju̱ú ga̱ inga profeta na̱sa̱nduu sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jáchi̱ mé Juan cúú dá da̱ cáha̱n tu̱hun Ndióxi̱ sa̱ha̱ tá cáchí a̱ já: Chindahá i̱ in da̱ canu̱ú cu̱hu̱n nu̱ mún, já ná caja tia̱hva da íchi̱ nu̱ú quisún, já na̱ca̱hyi̱ a̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cande̱hé ndo̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Tañu tócó ndihi ña̱yivi co̱ó ga̱ inga profeta cáhnu chága̱ a̱ ju̱ú ga̱ Juan, mé da̱ jácandúta̱ ña̱yivi. Joo ndá na̱ sa̱ na̱ndiquia̱hva mé ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná, va̱tí cúú ná na̱ co̱ó sa̱ha̱, na̱ cán cúú na̱ cáhnu chága̱ a̱ ju̱ú ga̱ Juan —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tá na̱xini jo̱ho tócó ndihi ña̱yivi ndúu cán ña̱ yóho já na̱ndicuni na ña̱ cája nda̱a̱ Ndióxi̱ tócó ndihi ña̱ha. Na̱ na̱ca̱hán já cúú na̱ na̱jácandúta̱ Juan ta tañu na̱ cán na̱sañuhu java ri na̱ játaca jiu̱hún cuéntá impuesto. ");
INSERT INTO mksNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Joo na̱ fariseo xi̱hín na̱ jána̱ha̱ ley Moisés, na̱ co̱ó na̱jácandúta̱ Juan cán, na̱ cán cúú na̱ na̱quehe núu na tócó ndihi ña̱ma̱ni̱ cúni̱ Ndióxi̱ caja xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ná ca̱ha̱n i̱ xi̱hi̱n ndó ndaja íin ña̱yivi ndúu tiempo viti. ");
INSERT INTO mksNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cúú ná tátu̱hun na̱ va̱lí sáco̱o sájíquí nu̱ú ya̱hvi ta cáyuhú na̱ nu̱ú java ga̱ na̱ va̱lí ndúu cán já cáchí na̱ já: “Na̱tiví nde̱ tótíví nu̱ ndo̱ joo co̱ó na̱xeen ndó cata sáhá ndo̱. Ta na̱xita cuéha̱ ndiva̱ha nde̱ nu̱ ndo̱ ta ni co̱ó na̱sacu ndó.” ");
INSERT INTO mksNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Quia̱hva já íin ña̱yivi ndúu tiempo viti jáchi̱ na̱quixi Juan, da̱ jácandúta̱ ña̱yivi ta na̱xijuhun da ta co̱ó na̱xihi da vino joo na̱cachi ndó sa̱ha̱ dá ña̱ ndáca̱a̱n ínima̱ quini ini da. ");
INSERT INTO mksNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ta tá na̱xi̱nu̱ ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta xíxi i̱ pan ta xíhi i̱ vino já na̱casáhá cáchí ndo̱ sa̱há i̱ ña̱ cúu u̱ in ta̱a nde̱hé ndiva̱ha ta xíhi ndiva̱ha i̱. Ta cáchí ndo̱ ña̱ cátóó ndiva̱ha i̱ cacuu u̱ amigo na̱ cája cua̱chi xi̱hín na̱ játaca jiu̱hún cuéntá impuesto. ");
INSERT INTO mksNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Joo na̱ cúni̱ cánda̱a̱ ini ña̱ nda̱a̱, na̱ cán cúú na̱ cánda̱a̱ ini ña̱ cája Juan xi̱hín ye̱he̱ ña̱ nda̱a̱ —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","In táhan da̱ fariseo na̱cana da Jesús ña̱ ná cu̱hu̱n a̱ cuxu a vehe da. A̱nda̱ já na̱sa̱ha̱n Jesús vehe da já na̱saco̱o a nu̱ mesa. ");
INSERT INTO mksNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Joo ndaja coo in ñáñáha̱, mé ñá ñuu cán tá na̱ñe̱he̱ ñá tu̱hun ña̱ na̱xi̱nu̱ Jesús vehe Simón cán cuxu a já na̱xi̱nu̱ ñá xi̱hín in yúyú alabastro, ña̱ na̱chutú nda̱a̱ xi̱hi̱n sítí támi sáha̱n na̱casa̱a̱ ñá nu̱ Jesús. Mé ñáñáha̱ yóho cúú ñá in ñá cája cua̱há cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ta sácu ñá na̱caxítí ña̱ sa̱ha̱ Jesús ta xi̱hín ticui̱í nu̱u̱ ñá na̱jácuchu ñá sa̱há. Ta tá na̱ndihi já na̱jáhi̱chi̱ ñá do̱ xi̱hín ijí ji̱ni̱ ña̱. A̱nda̱ já na̱tatí yúhu̱ ñá sa̱há. Ta na̱chojó ñá sítí támi sáha̱n cán ja̱ta̱ sáha̱ á. ");
INSERT INTO mksNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tá na̱xini mé da̱ fariseo, da̱ na̱cana Jesús vehe da cán ña̱ yóho já na̱ca̱hán da̱ já: “Tá profeta ndusa ná cacuu da̱ yóho ta sa̱ cánda̱a̱ va ini da ndá ñá cúú ñá cáni ndaa ndáha̱ sa̱ha̱ dá jáchi̱ cúú ñá ña̱ cája cua̱há cua̱chi”, na̱ca̱hán Simón cán. ");
INSERT INTO mksNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A̱nda̱ já na̱cachi Jesús já xi̱hín da̱ fariseo cán: —Cande̱hé Simón, cuni jo̱ho ná ca̱ha̱n i̱ xu̱hu̱n —na̱cachi Jesús xi̱hi̱n dá. A̱nda̱ já na̱cachi Simón cán já xi̱hi̱n Jesús: —Ca̱ha̱n mé á xi̱hín i̱, xitoho i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","A̱nda̱ já na̱sacu Jesús in quia̱hva nu̱ dá já na̱cachi a já xi̱hi̱n dá: —Na̱sa̱nduu i̱vi̱ da̱ta̱a ta na̱sa̱yicá da̱ jiu̱hún nu̱ mé da̱ sáhan tóo a cán. In da na̱sa̱yicá u̱hu̱n ciento ta inga da na̱sayicá i̱vi̱ jico u̱xu̱. ");
INSERT INTO mksNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ta ni in da̱ cán co̱ ndéé da̱ cha̱hvi da ña̱ yícá da̱ sa̱há ña̱ cán quéa̱ na̱caja cáhnu ini da̱ sáhan tóo jiu̱hún cán sa̱há ña̱ yícá ndíví da̱ cán. Ta viti cachún xi̱hín i̱, Simón, ndá da̱ cáhún ti̱xi ndíví da̱ yóho cacuu da da̱ qui̱hvi̱ ini chága̱ mé da̱, da̱ na̱caja cáhnu ini sa̱ha̱ cuéntá ña̱ na̱sa̱yicá da̱ cán —na̱cachi Jesús xi̱hi̱n Simón. ");
INSERT INTO mksNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A̱nda̱ já na̱nducú ñehe Simón cán tu̱hun nu̱ Jesús já na̱cachi da já xi̱hi̱n á: —Cája i̱ cuéntá ña̱ quíhvi̱ ini chága̱ da̱ na̱sa̱yicá cua̱há jiu̱hún cán nu̱ dá —na̱cachi da. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n Simón: —Mé a̱ nda̱a̱ cáhu̱n —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","A̱nda̱ já na̱sande̱hé Jesús ñá na̱cho̱jo̱ sítí sa̱há cán já na̱cachi a já xi̱hi̱n Simón: —Cande̱hé va̱ha ñáñáha̱ ja̱n, Simón. Na̱qui̱hvi i̱ vehún joo co̱ó na̱sa̱hún ticui̱í ndoo sa̱há i̱. Joo ñáñáha̱ yóho na̱jácuchu ñá sa̱há i̱ xi̱hín ticui̱í nu̱u̱ ña̱. Ta tá na̱ndihi já na̱jáhi̱chi̱ ñá sa̱há i̱ xi̱hi̱n ijí ji̱ni̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ta yóhó, co̱ó na̱tatí yu̱hún sa̱jóho ye̱he̱ tá na̱sa̱a̱ i̱ vehún. Joo ñá yóho, ja̱nda̱ nani na̱qui̱hvi ñá vehún tátí yúhu̱ ñá sa̱há i̱. Ta a̱nda̱ viti ñúhú cája ñá a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ta ni co̱ó na̱chojó tohún sítí ji̱ní i̱ tá na̱xi̱nu̱ i̱ vehún. Joo ñá yóho na̱chojó ñá sítí támi sáha̱n sa̱há i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ta cáchí i̱ xu̱hu̱n, Simón, ña̱ xi̱hín ña̱ cája ñá yóho náha̱ ña̱ mé a̱ nda̱a̱ quíhvi̱ ini ñá ye̱he̱ jáchi̱ na̱caja cáhnu ini i̱ sa̱há cua̱chi ñá va̱tí cua̱há ndiva̱ha cúú á. Joo ndá na̱ cáhán ña̱ chá cuití va cua̱chi cája cáhnu ini i̱ sa̱ha̱, na̱ cán cúú ri na̱ chá cuití quíhvi̱ ini na ye̱he̱ —na̱cachi Jesús xi̱hi̱n Simón. ");
INSERT INTO mksNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A̱nda̱ já na̱casáhá cáchí a̱ já xi̱hi̱n ñáñáha̱ cán: —Sa̱ na̱caja cáhnu ini i̱ sa̱há cua̱chún viti. ");
INSERT INTO mksNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ta tócó ndihi java ga̱ na̱ na̱taca ndúu coo nu̱ mesa vehe Simón cán na̱casáhá cáchí xi̱hi̱n táhan na já: —Ndá ta̱a cúú da̱ yóho jáchi̱ ja̱nda̱ cua̱chi cája ña̱yivi cája cáhnu ini da sa̱ha̱ —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ñáñáha̱ cán: —Na̱ca̱cu ndaa ínimu̱n jáchi̱ na̱candeé inún ye̱he̱. Cuanúhu̱ ta a̱ ndícani ga̱ inún viti —na̱cachi Jesús xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tá na̱ndihi na̱ya̱ha ña̱ yóho já na̱casáhá Jesús xíca nuu a cua̱há ñuu náhnu xi̱hín ñuu válí ña̱ ca̱xi tu̱hun a xi̱hi̱n ná ña̱ sa̱ na̱cayati qui̱ví cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. Ta ndíco̱ ndíhu̱xu̱ i̱vi̱ na̱ apóstol cán mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ta na̱sandaca táhan java ri na̱ji̱hí xi̱hi̱n á, na̱ na̱tavá mé á ínima̱ quini ini xi̱hín na̱ na̱ndaja va̱ha mé á nu̱ú cue̱he̱ na̱sandoho na. Tañu na̱ji̱hí yóho na̱sa̱ndaca̱a̱n ñá naní María, ñá cáha̱n na̱ Magdalena xi̱hi̱n. Mé María yóho cúú ñá na̱tavá Jesús u̱sa̱ ínima̱ quini ini. ");
INSERT INTO mksNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ta cátáhan ri in ñá naní Juana cua̱ha̱n ñá xi̱hín na̱ cán. Mé Juana cúú ñá ñájíhí da̱ naní Chuza, da̱ cómí cuéntá sa̱há vehe Herodes. Ta jári in ñá naní Susana na̱xi̱ca nuu ñá xi̱hi̱n Jesús. Cua̱ha̱ chága̱ na̱ji̱hí na̱xi̱ca nuu na xi̱hi̱n á ta na̱chindeé ñahá na̱ xi̱hín ña̱ cómí na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na̱queta ña̱yivi cua̱há ñuu jáchi̱ cúni̱ na̱ cuni na Jesús. Ta tá sa̱ na̱taca cua̱há ña̱yivi nu̱ íin Jesús, na̱casáhá cáha̱n xi̱hi̱n ná. Ta na̱sacu a in quia̱hva nu̱ ná já na̱cachi a já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—In da̱ sátá tata na̱quee da cua̱ha̱n da̱ cata da ña̱. Ta tá sátá da̱ ña̱ cua̱ha̱n da̱ já na̱cu̱yu java ña íchi̱. Ta tá na̱ya̱ha ña̱yivi já na̱chiníhni sa̱ha̱ joho na a̱ ta já na̱xi̱nu̱ laa na̱saxí rí ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ta java tata cán na̱cu̱yu a tañu yu̱u̱. Ta tá na̱ndu̱ta̱ mé tata cán, cama chá na̱hi̱chi̱ a̱ jáchi̱ íchí ndiva̱ha tañu yu̱u̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ta java ga̱ tata cán na̱cu̱yu a tañu to̱híñú ta tá na̱ndu̱ta̱ ña̱ já na̱nditáha̱ ndihi a na̱caja to̱híñú, dó na̱sahnu xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Joo java tata na̱cu̱yu a nu̱ ñuhú va̱ha. Ta tá na̱sahnu a já na̱jáquee na cua̱há ña̱ha nu̱ á. Ja̱nda̱ in ciento tata na̱cana ja̱tá in in nu̱ú tata cán —na̱cachi Jesús xi̱hi̱n ná. Ta tá na̱ndihi na̱ndicani Jesús ña̱ yóho nu̱ ná já na̱ca̱ha̱n cóhó a̱ nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Ndá ndó, na̱ íin jo̱ho, ná cuni jo̱ho ndó —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A̱nda̱ já na̱casáhá na̱ xíca tuun xi̱hi̱n á cán ndáca̱ tu̱hún na̱ mé á ndía̱ cúni̱ cachi quia̱hva na̱cachi a xi̱hín ña̱yivi cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ta na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Ña̱ co̱ó na̱canda̱a̱ ini ndó jihna, ña̱ cán cánda̱a̱ ini ndó viti jáchi̱ na̱suná Ndióxi̱ xíní túni̱ ndó canda̱a̱ ini ndó ndá quia̱hva cacomí mé á cuéntá sa̱há ña̱yivi. Joo sácú u̱ quia̱hva nu̱ú java ga̱ ña̱yivi já quéa̱ va̱tí sánde̱hé na̱ joo cúú ná tátu̱hun na̱ co̱ tívi nu̱u̱. Ta va̱tí xíni̱ jo̱ho na, cúú ná tátu̱hun na̱ jóho̱ jáchi̱ co̱ cánda̱a̱ ini na ña̱ cáha̱n i̱ xi̱hi̱n ná —na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ña̱ yóho cúni̱ cachi quia̱hva na̱sacu u̱ nu̱ú ña̱yivi yóho: Mé tata cán cúú á yuhú nu̱ú tu̱hun Ndióxi̱, ña̱ xíca java na cáha̱n na̱ xi̱hín ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mé tata ña̱ na̱ndicava íchi̱ cán náha̱ nu̱ yo̱ ndá quia̱hva íin java ña̱yivi. Xíni̱ jo̱ho na tu̱hun Ndióxi̱ joo tá na̱ndihi já va̱xi tiñáhá sa̱cua̱ha̱ ta cája rí xi̱hi̱n ná ña̱ ndíndójó na̱ ña̱ já ná a̱ cándúsa na tu̱hun Ndióxi̱ ña̱ ná a̱ cácu ndaa ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ta tata ña̱ na̱ndicava tañu yu̱u̱ cán náha̱ nu̱ yo̱ ña̱ ndúu java ña̱yivi ta xíni̱ jo̱ho na tu̱hun Ndióxi̱ ta cáji̱i̱ íní na̱ ndíquehe na ña̱. Joo sa̱há ña̱ co̱ ñéhe̱ íní yóho̱ á cu̱hu̱n cúná a̱ sa̱há ña̱ cán quéa̱ chá tiempo cuití va cándúsa na tu̱hun Ndióxi̱. Jáchi̱ tá cásáhá ndóho ini na sa̱há tu̱hun Ndióxi̱ chí jándacoo va na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ta tata ña̱ na̱ndicava tañu to̱híñú cán náha̱ nu̱ yo̱ ña̱ ndúu java ña̱yivi ta xíni̱ jo̱ho na tu̱hun Ndióxi̱ joo co̱ jándacoo na íchi̱ na̱xi̱ca na jihna. Ta cásáhá ndícani ini na sa̱há ña̱ha ñuyíví yóho ta cásáhá na̱ cátóó na̱ canduu cua̱há ña̱ha cuícá nu̱ ná ta cásáhá ndicají ini na caja na ña̱ núu. Sa̱há ña̱ cán quéa̱ cúú á tátu̱hun tata ña̱ co̱ cána ña̱ha jáquee na nu̱u̱ jáchi̱ co̱ó na̱sahnu na xi̱hín tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Joo tata ña̱ na̱ndicava nu̱ ñuhú va̱ha cán náha̱ nu̱ yo̱ ña̱ ndúu java ña̱yivi ta xíni̱ jo̱ho na tu̱hun Ndióxi̱ xi̱hín ndinuhu ini na ta cája na ña̱ sáhndá a̱ nu̱ ná. Ta sa̱há ña̱ ndíco̱ cáhnu na Ndióxi̱ ta co̱ jándacoo na mé á sa̱há ña̱ cán quéa̱ cúú ná tátu̱hun tata na̱sa̱ha̱n cua̱há ña̱ha ña̱ cuu jáquee na nu̱u̱ jáchi̱ sáhnu na xi̱hín tu̱hun Ndióxi̱ —na̱cachi Jesús ndícani a nu̱ú na̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ʼNi in túhún toho ña̱yivi co̱ ndícahmi na in lámpara ta a̱nda̱ já chíja̱hvi na ja̱tá xi̱hín in ña̱ha. Ta ni co̱ chíca̱a̱n je̱hé na̱ ña̱ ti̱xi xi̱to. Ña̱ cája na quéa̱ chínúu jícó na̱ ña̱ já ná ye̱he̱ a̱ nu̱ú na̱ quíhvi ini vehe cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ni in túhún toho ña̱ha a̱ cu̱ú coo je̱hé nahá jáchi̱ xi̱nu̱ qui̱vi̱ já ndáca náha̱ nu̱ á. Ta ni in tu̱hun na̱ca̱ha̱n je̱hé ña̱yivi a̱ cu̱ú coo je̱hé nahá jáchi̱ xi̱nu̱ qui̱vi̱ já canda̱a̱ ini tócó ndihi ña̱yivi sa̱há tu̱hun na̱sahi̱in je̱hé cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ʼSa̱há ña̱ cán quéa̱ ndítahan coo jo̱ho va̱ha ndó nu̱ cáha̱n i̱ xi̱hi̱n ndo̱. Jáchi̱ da̱ íin ña̱ha nu̱u̱, ñe̱he̱ táhvi̱ dá coo chága̱ ña̱ha nu̱ dá joo da̱ co̱ó ña̱ha nu̱u̱, ja̱nda̱ ña̱ loho íin nu̱ dá ndindaa —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A̱nda̱ já na̱xi̱nu̱ co̱o náná Jesús xi̱hín ñani a mé nu̱ íin a̱ cán. Joo co̱ó na̱cuu cayatí na nu̱ á jáchi̱ a̱ ju̱ú quia̱hva na̱chutú ña̱yivi ndúu na xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A̱nda̱ já na̱sa̱ha̱n in da ca̱xi tu̱hun da xi̱hi̱n Jesús já cáchí da̱ já xi̱hi̱n á: —Ja̱ta̱ véhe cáa íin nánún xi̱hín ñanún ta ca̱ha̱n na̱ xu̱hu̱n cúni̱ na̱ —na̱cachi da̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A̱nda̱ já na̱cachi Jesús xi̱hi̱n tócó ndihi ña̱yivi ndúu cán já: —Ndá na̱ xíni̱ jo̱ho tu̱hun Ndióxi̱ ta cája na ña̱ cáchí a̱, na̱ cán cúú ná tátu̱hun náná i̱ xi̱hín ñani i̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","In qui̱vi̱ na̱qui̱hvi Jesús ini in barco xi̱hín na̱ xíca tuun xi̱hi̱n á. Ta já na̱cachi a já xi̱hi̱n ná: —Cóho̱ inga xoo tañu̱hú yóho. A̱nda̱ já na̱quee na cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ta nani xójo̱ cava na tañu̱hú cán cua̱ha̱n na̱ já na̱naá ini Jesús na̱qui̱ji̱ á. Ta in náá cuití na̱xi̱nu̱ in ta̱chi̱ quíni ndiva̱ha nu̱ú tañu̱hú cán ta na̱casáhá ndíndita dó ta jáchutú do̱ ini barco cán. Ta chí i̱yo̱ ndiva̱ha cáa jáchi̱ cuu caco̱o barco ca̱há ticui̱í. ");
INSERT INTO mksNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A̱nda̱ já na̱sa̱ha̱n na̱ ndíñehe na Jesús já na̱cachi na já xi̱hi̱n á: —Maestro, Maestro. Cáco̱o barco yo̱ ca̱há ticui̱í cua̱ha̱n do̱ —na̱cachi na xi̱hi̱n á. A̱nda̱ já na̱ndico̱o Jesús já na̱casáhá jána̱ni a ta̱chi̱ xi̱hín ticui̱í ndíco̱jo̱ cán. Tá na̱ndihi já na̱jáya̱a̱ mé á ta̱chi̱ xi̱hín ticui̱í chí táji̱ níí uun na̱cando̱o nu̱ú tañu̱hú cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Ndaja va̱ha co̱ cándeé ini ndó ye̱he̱ —na̱cachi a. Joo na̱ cán na̱yi̱hví na̱ ta na̱catóntó na̱. Ta chí ja̱ndá ndáca̱ tu̱hún táhan na já cáchí na̱ já: —Ndá da̱ cúú da̱ta̱a yóho ña̱ a̱nda̱ ta̱chi̱ xi̱hín tañu̱hú cándúsa nu̱ cáha̱n da̱ —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tá na̱ndihi já cua̱ha̱n na̱ ta na̱xi̱nu̱ co̱o na ñundáhyi̱ cuéntá Gadara, ña̱ cándo̱o inga xoo tañu̱hú ta ndícoto nihni táhan xi̱hín estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tá na̱nuu Jesús barco cán já na̱cayati in da̱ta̱a, da̱ ñuu Gadara cán nu̱ á. Mé da̱ yóho sa̱ na̱canahá ndiva̱ha ñúhu ínima̱ quini ini da. Ta já cáa vichí láhlá da̱ xíca nuu da. Ta ni co̱ íin da vehe. Tañu nu̱ jándu̱xu̱ na̱ ndi̱i cán va íin tuun da. ");
INSERT INTO mksNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tá na̱xini da Jesús na̱ndicava xítí da̱ nu̱ á ta já na̱cayuhú da̱ já na̱cachi da já xi̱hi̱n á: —Ndá cuéntá quéa̱ va̱sún qui̱hvi nuún xi̱hín i̱. Yóhó cúún Jesús, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱, ña̱ cáhnu ndiva̱ha. Xíca̱ ta̱hví i̱ nu̱u̱n ña̱ ná a̱ jándohún ini i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Na̱cachi da ña̱ yóho xi̱hi̱n Jesús jáchi̱ na̱casáhá sáhndá mé á chuun nu̱ ínima̱ quini cán ña̱ ná quee rí ínima̱ da̱ cán. Ta cua̱há tañu na̱sa̱tiin rí da̱. Ta va̱tí na̱cató na̱ ndáha̱ dá xi̱hín sa̱ha̱ dá xi̱hi̱n cadena joo na̱sahnda túhu̱n dá ña̱ na̱caja rí quini cán. Ta já na̱caja rí ña̱ ná cunu da cu̱hu̱n da̱ chí yucú íchí nu̱ú co̱ ndúu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na̱nda̱ca̱ tu̱hún Jesús mé rí quini cán já na̱cachi a já xi̱hi̱n ri̱: —Ndaja nanún. A̱nda̱ já na̱nducú ñehe da̱ cán tu̱hun nu̱ á já na̱cachi da já xi̱hi̱n á: —Legión naní i̱. Na̱cachi da̱ cán ña̱ naní da̱ Legión jáchi̱ cua̱há ndiva̱ha rí quini na̱ndi̱hvi rí ini da. ");
INSERT INTO mksNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ta mé rí quini ñúhu ini da̱ cán na̱xi̱ca̱ ta̱hví rí nu̱ Jesús ña̱ ná a̱ chíndahá a̱ rí cu̱hu̱n rí nu̱ ndúu ínima̱ ndi̱i. ");
INSERT INTO mksNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ta yati in ndi̱ca yúcu̱ cán na̱sa̱nduu cua̱há ndiva̱ha cóchí xíxáhan rí. Sa̱há ña̱ cán quéa̱ na̱xi̱ca̱ rí quini cán ña̱ma̱ni̱ nu̱ Jesús ña̱ ná ndi̱hvi rí ini cóchí ndúu cán. A̱nda̱ já na̱sa̱ha̱n Jesús ña̱ma̱ni̱ nu̱ ri̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chí na̱quee rí quini da̱ta̱a cán cua̱ha̱n rí já na̱ndi̱hvi rí ini cóchí cán. Ta tócó ndihi cóchí yóho xínu rí cua̱ha̱n rí na̱nuu rí nu̱ ndáyi já na̱jáque̱ta nuu rí mé rí ini tañu̱hú cán ta já na̱candaa rí ticui̱í já na̱xi̱hi̱ ri̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tá na̱xini mé da̱ta̱a ndáá cóchí cán ña̱ yóho já na̱xinu da cua̱ha̱n da̱ ca̱xi tu̱hun da ña̱ na̱ya̱ha yóho nu̱ú ña̱yivi ñuu Gadara cán xi̱hín nu̱ú java ga̱ na̱ ndúu yati cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A̱nda̱ já na̱queta ña̱yivi sánde̱hé na̱ ña̱ na̱cuu cán. Ta tá na̱xi̱nu̱ co̱o na nu̱ íin Jesús cán já na̱xini na íin coo mé da̱ na̱sañuhu rí quini ini cán sa̱ha̱ Jesús. Ta sa̱ na̱ndaca ndixi da jáhma̱ ta chí sa̱ na̱ndicáxí táhyí ini da. Tá na̱xini na ña̱ yóho chí na̱yi̱hví na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ta na̱ na̱xini nu̱ú na̱tavá Jesús rí quini ini da̱ta̱a cán, na̱ cán cúú na̱ na̱ndicani ña̱ nu̱ú na̱ co̱ó na̱xini cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tá na̱xini jo̱ho na̱ ñuu Gadara cán ndaja na̱sahi̱in já na̱xi̱ca̱ ta̱hví ndihi na nu̱ Jesús ña̱ ná quee a cu̱hu̱n a̱ jáchi̱ yíhví ndiva̱ha na. Sa̱há ña̱ cán quéa̱ na̱ndi̱hvi tucu Jesús ini barco cán ña̱ ná quee a cu̱hu̱n a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Joo tá cáma̱ní quee a cu̱hu̱n a̱ já na̱casáhá da̱ na̱queta rí quini ini cán xíca̱ ta̱hví da̱ nu̱ Jesús ña̱ ná quia̱hva mé á ña̱ma̱ni̱ cu̱hu̱n da̱ xi̱hi̱n á. Joo na̱sahnda Jesús chuun nu̱ dá ña̱ ná cando̱o da. Já na̱cachi a já xi̱hi̱n dá: ");
INSERT INTO mksNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Cuanúhu̱ vehún. Ta já ndicanún nu̱ú na̱ vehún ndaja náhnu ña̱ha na̱caja Ndióxi̱ xu̱hu̱n —na̱cachi Jesús xi̱hín da̱ cán. A̱nda̱ já na̱quee da̱ cán cua̱ha̱n da̱. Já na̱ndicani da nu̱ tócó ndihi na̱ Gadara cán ndaja cáa ña̱ na̱caja Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tá na̱ndicó co̱o Jesús inga xoo tañu̱hú cán, a̱ ju̱ú quia̱hva cávatá ña̱yivi na̱xi̱nu̱ na̱ ndiquehe na mé á jáchi̱ mé cán na̱sanduu na ndáti na mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A̱nda̱ já na̱casa̱a̱ in da̱ta̱a naní Jairo, da̱ sáhndá chuun veñu̱hu. Mé Jairo yóho na̱xi̱nu̱ da̱ na̱caxítí da̱ sa̱ha̱ Jesús já na̱xi̱ca̱ ta̱hví da̱ nu̱ á ña̱ ná cu̱hu̱n a̱ vehe da. ");
INSERT INTO mksNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jáchi̱ xíhi̱ ñá loho cúú ja̱hyi jíhí da̱ ta in já cúú ñá nu̱ dá ta ndáca̱a̱n ñá tátu̱hun u̱xu̱ i̱vi̱ cui̱a̱. Chí na̱quee Jesús cua̱ha̱n ta nani xíca cua̱ha̱n vehe Jairo cán a̱ ju̱ú quia̱hva cua̱há ña̱yivi ndíco̱ na̱ ja̱tá cua̱ha̱n na̱ ta chí ja̱nda̱ cándíhi na mé á cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta tañu ña̱yivi cua̱ha̱n cán ndáca̱a̱n in ñáñáha̱ ta ndíta̱hví ni̱i̱ ñá ti̱xi u̱xu̱ i̱vi̱ cui̱a̱. Ta na̱jándihi ndihi ñá jiu̱hún ña̱ nu̱ú na̱ cája tátá ña̱yivi joo ni in na co̱ó na̱cuu caja tátá ñahá. ");
INSERT INTO mksNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Joo na̱cayati ñá chí ja̱ta̱ Jesús ta na̱tiin ñá yúhu̱ jáhma̱ á. Chí i̱vi̱ la̱á na̱sacui̱i̱n ni̱i̱ ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A̱nda̱ já na̱casáhá Jesús ndáca̱ tu̱hún a̱ tócó ndihi ña̱yivi já na̱cachi a já xi̱hi̱n ná: —Ndá ndó na̱cani ndaa ndáha̱ ye̱he̱ —na̱cachi a xi̱hi̱n ná. Joo ni in na co̱ó na̱sa̱ha̱n tu̱hun nu̱ á. Sa̱há ña̱ cán quéa̱ na̱cachi Pedro xi̱hín java ga̱ da̱ xíca tuun xi̱hi̱n mé á cán já xi̱hi̱n á: —Maestro, a̱ ju̱ú quia̱hva cándíhi ña̱yivi mé ndó ta chindahá nihni joho na mé ndó va̱xi na ta cáa ga̱ mé ndó ndáca̱ tu̱hún ndo̱ ndá na̱ na̱cani ndaa ndáha̱ ndo̱hó —na̱cachi da̱ cán xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A̱nda̱ já na̱cachi Jesús já: —Íin in na̱ na̱cani ndaa ndáha̱ ye̱he̱ jáchi̱ na̱canda̱a̱ ini i̱ ña̱ na̱ndiva̱ha in na xi̱hi̱n ndée̱ mí i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Joo ndaja coo mé ñá na̱ndiva̱ha cán tá na̱xini ñá ña̱ na̱canda̱a̱ ini Jesús sa̱há ña̱ na̱caja ñá já na̱ndiquiji ni̱nu ñá xi̱hín ña̱ yíhví ña̱ ta já na̱xi̱nu̱ co̱o ña̱ na̱caxítí ña̱ nu̱ Jesús. Ta nu̱ ndíhi ña̱yivi ndúu cán na̱casáhá ña̱ ndícani ñá nu̱ á ndá cuéntá quéa̱ na̱cani ndaa ndáha̱ ña̱ mé á chí i̱vi̱ la̱á na̱ndiva̱ha ñá. ");
INSERT INTO mksNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ña̱: —Ja̱hyi a, na̱ndiva̱hún jáchi̱ na̱candúsún ye̱he̱. Cuanúhu̱. Ta a̱ ndícani ga̱ inún —na̱cachi Jesús xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ta nani cáha̱n Jesús xi̱hi̱n ñá cán já na̱xi̱nu̱ in da̱ na̱quixi chí vehe Jairo, da̱ sáhndá chuun veñu̱hu cán. Já na̱cachi da̱ cán já xi̱hi̱n dá: —Sa̱ na̱xi̱hi̱ va ja̱hyi ndó. A̱ jáqui̱hvi ga̱ ndó da̱ xíca jána̱ha̱ ña̱yivi ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Joo tá na̱xini jo̱ho Jesús ña̱ na̱cachi da̱ cán já na̱cachi a já xi̱hi̱n Jairo: —A̱ cáyi̱hví tohún. Candúsa cuití vún ye̱he̱ chí ndiva̱ha va ja̱hyún —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tá na̱xi̱nu̱ co̱o Jesús vehe Jairo cán co̱ó na̱xeen a quia̱hva ña̱ma̱ni̱ ña̱ ná qui̱hvi ña̱yivi ini vehe cán xi̱hi̱n á. Na̱ na̱qui̱hvi xi̱hi̱n á na̱sacuu Pedro xi̱hi̱n Jacobo xi̱hi̱n Juan xi̱hi̱n tátá mé ñá loho cán xi̱hi̱n náná ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ja̱ndá joho ndíváá ña̱yivi sácu ndiva̱ha na ndúu na sa̱ha̱ ñá loho cán. A̱nda̱ já na̱ndica̱ha̱n Jesús xi̱hi̱n ná já na̱cachi a já: —A̱ cuácu ndó. Co̱ó na̱xi̱hi̱ toho ñá loho yóho. Quíji̱ cuití va ñá —na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Joo na̱casáhá na̱ cán sácu̱ ndaa na Jesús jáchi̱ xíni̱ na̱ ña̱ sa̱ na̱xi̱hi̱ ñá loho cán ta sa̱ cúú ñá ndi̱i. ");
INSERT INTO mksNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","A̱nda̱ já na̱tiin Jesús ndáha̱ ñá na̱xi̱hi̱ cán já na̱ca̱ha̱n cóhó a̱ xi̱hi̱n ña̱ já na̱cachi a já: —Ñá loho, cuándaco̱o. ");
INSERT INTO mksNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chí i̱vi̱ la̱á na̱nditacu ñá loho cán já na̱ndico̱o ñá. Ta na̱sahnda Jesús chuun ña̱ ná quia̱hva na ña̱ cuxu ñá. ");
INSERT INTO mksNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chí a̱ ju̱ú quia̱hva na̱catóntó tátá náná ñá loho cán sa̱há ña̱ na̱caja Jesús. Joo na̱sahnda Jesús chuun nu̱ ná ña̱ ná a̱ ndícani na nu̱ú ni in ña̱yivi sa̱há ña̱ na̱ya̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na̱jánditaca Jesús ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hi̱n á já na̱sa̱ha̱n ndée̱ nu̱ ná ña̱ ná cuu tavá na̱ tá nu̱ú ínima̱ quini ñúhu ini ña̱yivi ta na̱sa̱ha̱n ndée̱ mé á nu̱ ná ña̱ ná cuu ndaja va̱ha na tá nu̱ú cue̱he̱ ndóho ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na̱sahnda Jesús chuun nu̱ ná ña̱ ná ca̱xi tu̱hun na xi̱hín ña̱yivi ña̱ sa̱ na̱cayati qui̱ví cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. Ta na̱sahnda chuun nu̱ ná ña̱ ná ndaja va̱ha na na̱ quíhvi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta na̱cachi a já xi̱hi̱n ná: —A̱ cáñehe ndó ña̱ha cu̱hu̱n ndó íchi̱. Ni garróté ni yátí ni pan ni jiu̱hún a̱ cáñehe ndó cu̱hu̱n ndo̱. In túhún cotó cañehe ndó cu̱hu̱n xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tá ná xi̱nu̱ co̱o ndó in vehe, canduu ndó vehe ja̱n ja̱nda̱ quia̱hva ná ndindaa qui̱ví quee ndó cu̱hu̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ta ndá ñuu nu̱ú co̱ cúni̱ na̱ ndiquehe va̱ha na ndo̱hó, cuáhán quee ndó ñuu ja̱n ta catí ndó ña̱ yácá sa̱ha̱ ndo̱ já ná na̱ha̱ ña̱ cua̱ha̱n cua̱chi na̱ cán ja̱ta̱ mé va na —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A̱nda̱ já na̱quee na̱ cán cua̱ha̱n na̱ ta na̱sa̱ha̱n na̱ na̱xi̱ca nuu na ndijáá ñuu válí. Xíca na cáxi tu̱hun na nu̱ú ña̱yivi tu̱hun va̱ha cáha̱n sa̱ha̱ Jesús, mé a̱ cuu jáca̱cu ñahá. Ta ndája va̱ha na na̱ quíhvi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ta ndaja coo Herodes, da̱ cúú gobernador cán na̱canda̱a̱ ini da sa̱ha̱ tócó ndihi ña̱ cája Jesús. Ta chí co̱ xíni̱ da̱ ndía̱ ca̱hán da̱ jáchi̱ java na cáchí na̱ xi̱hi̱n dá ña̱ cúú Jesús mé Juan, da̱ na̱jácandúta̱ ña̱yivi ta viti na̱nditacu tucu da cáchí java na xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ta java ri na cáchí na̱ ña̱ cúú Jesús profeta Elías, mé da̱ na̱xi̱ca nuu sa̱nahá ta viti na̱xi̱nu̱ tucu da nu̱ ná. Ta java na cáchí na̱ ña̱ cúú á in táhan na̱ profeta na̱sanduu sa̱nahá joo túní quéa̱ na̱nditacu tucu a xíca nuu a, cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A̱nda̱ já na̱cachi Herodes já xi̱hi̱n ná: —Mí ye̱he̱ cúú da̱ na̱sahnda chuun ña̱ ná chitúhu̱n ná ji̱co̱ da̱ naní Juan cán. Ta co̱ xíni̱ ndá da̱ cúú da̱ naní Jesús yóho. Jáchi̱ mé a̱ nda̱a̱ xíni̱ jo̱ho i̱ ña̱ cája cua̱há ndiva̱ha da ña̱ náhnu —na̱cachi Herodes cán. Ta chí cúni̱ Herodes cuni da Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tá na̱ndicó co̱o na̱ na̱chindahá Jesús caca nuu ca̱ha̱n tu̱hun Ndióxi̱ xi̱hín ña̱yivi cán nu̱ íin mé á já na̱ndicani na nu̱ á sa̱ha̱ tócó ndihi ña̱ na̱caja na nu̱ú na̱sa̱ha̱n na̱. A̱nda̱ já ñéhe Jesús na̱ na̱sa̱ha̱n na̱ in nu̱ cáa xóo yati chí ñuu Betsaida cán. ");
INSERT INTO mksNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Joo tá na̱canda̱a̱ ini ña̱yivi ndá xoo cua̱ha̱n Jesús já ndíco̱ na̱ cua̱ha̱n na̱. Ta na̱ndiquehe va̱ha Jesús na̱ ta na̱ndicani a nu̱ ná ña̱ sa̱ na̱cayati qui̱ví cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. Ta na̱ndaja va̱ha mé á na̱ quíhvi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ta tá sa̱ cáhini cua̱ha̱n já na̱cayati ndíhu̱xu̱ i̱vi̱ na̱ apóstol cán nu̱ Jesús já na̱cachi na já xi̱hi̱n á: —Ca̱ha̱n ndó xi̱hín ña̱yivi ná quee na cu̱hu̱n na̱ ndiquehe ndée̱ ná ta ná nducú na̱ ña̱ cuxu na ñuu válí xi̱hín nu̱ú yati chá yóho nu̱ ndúu ña̱yivi jáchi̱ co̱ó ña̱ha mé va nu̱ ndúú yóho —na̱cachi na̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Mé ndó quia̱hva ndó ná cuxu na —na̱cachi a xi̱hi̱n ná. A̱nda̱ já na̱cachi na̱ cán já xi̱hi̱n á: —U̱hu̱n víxí pan xi̱hín i̱vi̱ la̱á ti̱yacá cuití va íin nu̱ú nde̱. Ta ama ná cu̱hu̱n ri nde̱he̱ cueen nde̱ ña̱ha cuxu tócó ndihi ña̱yivi ndúu yóho —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jáchi̱ ña̱yivi cán cúú ná tátu̱hun u̱hu̱n mil ta̱a. A̱nda̱ já na̱cachi tucu Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Cacu coo ndó na̱ tá táhndá i̱vi̱ jico u̱xu̱, i̱vi̱ jico u̱xu̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chí na̱sacu coo ndíhu̱xu̱ i̱vi̱ na̱ apóstol cán na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A̱nda̱ já na̱tiin Jesús ndíhu̱hu̱n pan xi̱hi̱n ndíví ti̱yacá cán já na̱sande̱hé a̱ chí indiví já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱ sa̱há ña̱ cán. Tá na̱ndihi já na̱sahnda java táhví a̱ ña̱ já na̱sa̱ha̱n ña̱ nu̱ú na̱ xíca tuun xi̱hi̱n á cán já na̱ndita̱hnda̱ ña̱ cuxu ña̱yivi ndúu cán. ");
INSERT INTO mksNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ta tócó ndihi na na̱ñe̱hé na̱xixi ja̱nda̱ quia̱hva na̱chutú ti̱xi na. Tá na̱ndihi já na̱jáchutú na̱ u̱xu̱ i̱vi̱ to̱yi̱cá xi̱hín ña̱ na̱cando̱o na̱xixi ndihi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","In tañu tá na̱cana xóo Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á ña̱ ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱ já na̱nda̱ca̱ tu̱hún mé á na̱ já na̱cachi a já xi̱hi̱n ná: —Ndá da̱ cáchí ña̱yivi cúú ye̱he̱ —na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","A̱nda̱ já na̱nducú ñehe na̱ cán tu̱hun nu̱ á já na̱cachi na já xi̱hi̱n á: —Java ña̱yivi cáchí na̱ ña̱ cúú ndó Juan, da̱ na̱jácandúta̱ ña̱yivi. Ta java na cáchí na̱ ña̱ cúú ndó profeta Elías. Ta cáchí java ga̱ ví na̱ ña̱ cúú ndó in táhan profeta na̱sanduu sa̱nahá, da̱ na̱nditacu tucu xíca nuu viti —na̱cachi na̱ xíca tuun xi̱hi̱n Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús na̱ já na̱cachi a já xi̱hi̱n ná: —Ta ndóhó ri ndá da̱ cáchí ndo̱ cúú u̱ —na̱cachi a xi̱hi̱n ná. A̱nda̱ já na̱cachi Pedro já xi̱hi̱n á: —Mé ndó cúú Cristo, ña̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi —na̱cachi da xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Joo na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hín a̱ ña̱ coto a̱ ndícani na ña̱ yóho nu̱ú ni in túhún ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A̱nda̱ já na̱cachi a já xi̱hín na̱ cán: —Ye̱he̱ cúú u̱ da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta ndítahan nu̱ú i̱ ndoho ndiva̱ha ini i̱. Ta na̱ sa̱cua̱ha̱ veñu̱hu xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés candají na̱ ye̱he̱ ta a̱nda̱ já cahní na̱ ye̱he̱. Joo tá ná xi̱nu̱ u̱ni̱ qui̱vi̱ já nditacu tucu u̱ —na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tá na̱ndihi já na̱cachi tucu a já xi̱hín ndihi na̱ xíca tuun xi̱hi̱n á cán já: —Ndá na̱ cúni̱ candi̱co̱ ye̱he̱ ndítahan nu̱ ná ndi̱hi chága̱ ini na sa̱há ye̱he̱ a̱ ju̱ú ga̱ sa̱ha̱ mé ná. Ta ndijáá níí qui̱vi̱ ndítahan coo tia̱hva na ndoho ini na sa̱há ye̱he̱ ta co̱ó caja toho a ná quivi na sa̱há i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jáchi̱ ndá na̱ cátóó coo chága̱ ñuyíví yóho ndihi sa̱ha̱ ná. Joo ndá na̱ sáhan ndeé ini quivi sa̱há i̱ ñe̱he̱ táhvi̱ ná catacu na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Va̱tí ná quee va̱ha in na ñuyíví yóho ta cómí na̱ tócó ndihi ña̱ha ñuyíví joo ndá chuun quéa̱ tá nu̱ ndíhí ndihi sa̱ha̱ ná indayá. ");
INSERT INTO mksNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ndá na̱ cácahan nu̱u̱ sa̱há i̱ xi̱hín sa̱há tu̱hun va̱ha cáha̱n i̱ quia̱hva já cacahan ri nu̱ú ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi sa̱há na̱ cán tá ná quixi i̱ cacomí i̱ cuéntá sa̱há ña̱yivi. Mé tiempo cán na̱ha̱ ndaja cáhnu cúú ye̱he̱ jáchi̱ quixi i̱ xi̱hi̱n ndée̱ Ndióxi̱ ta xi̱hi̱n ndée̱ táto̱ mé á viti. ");
INSERT INTO mksNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ndúu java na̱ ndíta yóho ta ni a̱ quíví toho na ja̱nda̱ quia̱hva ná xi̱nu̱ qui̱ví cuni na cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ta tá na̱ya̱ha tátu̱hun u̱na̱ qui̱vi̱ na̱cachi Jesús ña̱ yóho xi̱hi̱n ná já na̱ndaa ji̱ní in yúcu̱ ña̱ ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱. Ta ndáca táhan Pedro xi̱hi̱n Jacobo xi̱hi̱n Juan cua̱ha̱n na̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ta nani xíca̱ ta̱hví Jesús nu̱ Ndióxi̱ já na̱ndija̱ma quia̱hva cáa nu̱u̱ á. Ta ja̱nda̱ jáhma̱ ndíxi a cán na̱ndiyaa ca̱chi̱ ña̱ ta chí a̱ ju̱ú quia̱hva yéhe̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","A̱nda̱ já na̱xini na i̱vi̱ ta̱a ndúu da ndítúhún da̱ xi̱hi̱n Jesús. In da̱ cán cúú Moisés ta inga da̱ cán cúú Elías. ");
INSERT INTO mksNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","A̱ ju̱ú quia̱hva ndató ndíye̱he̱ ndaa nu̱ ndúu na cáha̱n na̱ xi̱hi̱n Jesús ta ndítúhún na̱ sa̱há ña̱ jándoho na ini a ñuu Jerusalén ta já quivi a. ");
INSERT INTO mksNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ta va̱tí cúni̱ cu̱ju̱ Pedro xi̱hín java ga̱ na̱ cátáhan xi̱hi̱n dá cán na̱sandita na. Ta na̱xini na ndá quia̱hva cáhnu cúú Jesús xi̱hín da̱ i̱vi̱ táha̱n ndúu xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ta tá na̱casáhá cáxícá Moisés xi̱hi̱n Elías cán nu̱ Jesús cua̱ha̱n na̱ já na̱cachi Pedro já xi̱hi̱n Jesús: —Maestro, ndaja va̱ha cúú á ndúu nde̱ yóho jáchi̱ já cuu cava̱ha nde̱ u̱ni̱ vehe ti̱yahvá válí. In a coo mé ndó ta inga coo Moisés ta inga coo Elías —na̱cachi da. Joo chí co̱ xíni̱ mé va Pedro ndía̱ cáa cáha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ta nani cáha̱n da̱ ndíta na já na̱nuu in vi̱co̱ ja̱ta̱ ná ta na̱jája̱hví a̱ na̱. Ta chí na̱casáhá yíhví na̱ xíca tuun xi̱hi̱n Jesús cán tá na̱xini na na̱ca̱va̱ nuu vi̱co̱ cán na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","A̱nda̱ já na̱xini jo̱ho na cáha̱n in a tañu vi̱co̱ cán já na̱cachi a já: —Da̱ yóho cúú ja̱hyi ma̱ní i̱. Cuni jo̱ho ndó nu̱ cáha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tá na̱ndihi na̱xini jo̱ho na ña̱ cáchí a̱ cán já na̱xini na ña̱ íin in túhún ji̱ni̱ mé va Jesús. Ta mé na̱ xíca tuun xi̱hi̱n á cán na̱sahi̱in táji̱ yúhu̱ ná sa̱há ña̱ na̱xini na ta co̱ó na̱ndicani na sa̱há nu̱ú ni in túhún ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta inga qui̱ví ita̱a̱n tá na̱nuu Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á ji̱ni̱ yúcu̱ cán já na̱queta cua̱há ndiva̱ha ña̱yivi cua̱ha̱n na̱ ndique táhan na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A̱nda̱ já na̱ndica̱ha̱n cóhó ndiva̱ha in da̱ta̱a tañu tócó ndihi ña̱yivi cán já na̱cachi da já xi̱hi̱n Jesús: —Maestro, caja ndó ña̱ma̱ni̱ cande̱hé loho ndó ja̱hyí i̱ jáchi̱ in túhún ji̱ni̱ já cúú dá nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ta ndáca̱a̱n in ínima̱ quini ini da ta tíin rí dá ta cája rí xi̱hi̱n dá ña̱ ná nda̱hyi̱ cóhó da̱. Ta cája rí ña̱ ná quivi yi̱hí da̱ ta já cána cuyu chiqui̱ñu̱ yúhu̱ dá. A̱ ju̱ú quia̱hva cája xíxi rí quini cán xi̱hi̱n dá ta chí co̱ cúni̱ rí janí rí da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Sa̱ na̱xi̱ca̱ ta̱hví i̱ nu̱ú na̱ xíca tuun xi̱hi̱n ndo̱ ña̱ ná tavá na̱ mé rí quini cán joo co̱ó na̱cuu caja na ña̱ —na̱cachi da̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A̱nda̱ já na̱cachi Jesús já: —Ndáhví na̱há na̱cuu ndó jáchi̱ sa̱ cua̱há ndiva̱ha qui̱vi̱ íin i̱ xi̱hi̱n ndo̱ ta a̱ ñáha candeé ini ndó ye̱he̱. Cúú ndó ña̱yivi quini ndiva̱ha chí co̱ ndéé ga̱ ini i̱ xi̱hín ña̱ cája ndó. Taxi ndó ta̱a loho ja̱n chóho —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ta tá cáyati ta̱a loho cán cua̱ha̱n da̱ nu̱ Jesús já na̱caja rí quini cán ña̱ ná ndicava da nu̱ ñúhu̱ ta cán na̱caja rí ña̱ ná quivi yi̱hí tucu da. A̱nda̱ já na̱jána̱ni Jesús rí quini cán já na̱ndiva̱ha ta̱a loho cán ta na̱ndiquia̱hva mé á da̱ nu̱ tátá da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ta tócó ndihi ña̱yivi na̱sanduu cán na̱catóntó na̱ tá na̱xini na ña̱ náhnu cája Ndióxi̱. Ta nani cátóntó na̱ ndúu na sa̱há ña̱ náhnu cája Jesús cán já na̱casáhá cáha̱n mé á xi̱hín na̱ xíca tuun xi̱hi̱n á. Já na̱cachi a já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Cuni jo̱ho va̱ha ndó ña̱ yóho ta coto a̱ ndíndójó ndó ña̱. Tiin na ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta já ndiquia̱hva na ye̱he̱ ndahá java da̱ta̱a —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Joo ni in táhan na̱ xíca tuun xi̱hi̱n á cán co̱ó na̱canda̱a̱ ini na ndía̱ cúni̱ cachi Jesús. Jáchi̱ co̱ó na̱nu̱na̱ xíní túni̱ ná ña̱ ná canda̱a̱ ini na ña̱. Ta yíhví na̱ nda̱ca̱ tu̱hún na̱ mé á ña̱ ná ndicani a ña̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tá na̱ndihi já na̱casáhá na̱ xíca tuun xi̱hi̱n Jesús cán ndítúhún xi̱hi̱n táhan na sa̱ha̱ ndá da̱ cúú da̱ cáhnu chága̱ tañu mé ná. ");
INSERT INTO mksNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","A̱nda̱ já na̱xini Jesús ña̱ cáhvi ini na̱ cán já na̱tiin a in ta̱a loho já na̱sacu ndichi a da̱ jíi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Já na̱cachi a já xi̱hi̱n ná: —Ndá na̱ ná ndiquehe va̱ha ta̱a loho yóho sa̱há ña̱ quíhvi̱ ini na̱ ye̱he̱, ndíquehe ri na ye̱he̱ viti. Ta ndá na̱ ndíquehe ye̱he̱, ndiquehe ri na tátá i̱, mé a̱ na̱chindahá ye̱he̱. Ndá na̱ co̱ó sa̱ha̱ mé tañu tócó ndihi ndó, na̱ cán cúú na̱ íin chága̱ sa̱ha̱ nu̱ Ndióxi̱ —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A̱nda̱ já na̱cachi Juan já xi̱hi̱n Jesús: —Maestro, na̱xini nde̱ in da̱ta̱a ta cáha̱n da̱ qui̱vi̱ mé ndó já tává da̱ ínima̱ quini ñúhu ini ña̱yivi. Joo co̱ xíca nuu da xi̱hi̱n yo̱ sa̱há ña̱ cán quéa̱ na̱saji nuu nde̱ nu̱ dá caja da ña̱ —na̱cachi da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —A̱ cájí nuu ndó nu̱ dá sa̱há ña̱ cája da ña̱. Jáchi̱ ndá da̱ co̱ ndíndita caja xíxi xo̱ho̱, mé da̱ cán cua̱ha̱n da̱ xoo mí —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tá na̱cayati qui̱ví ndindita Jesús cu̱hu̱n a̱ indiví co̱ó na̱yi̱hví a̱ quehe a íchi̱ cua̱ha̱n chí ñuu Jerusalén. ");
INSERT INTO mksNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na̱chindahá Jesús java na̱ xíca xi̱hi̱n á ña̱ ná cu̱hu̱n cuéé na̱ in ñuu loho ndáca̱a̱n estado Samaria cán já ná nducú na̱ nu̱ú canduu tóo na chí na̱quee na cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Joo co̱ó na̱xeen toho na̱ Samaria cán ndiquehe na Jesús jáchi̱ na̱xini na ña̱ cua̱ha̱n chí ñuu Jerusalén. ");
INSERT INTO mksNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tá na̱xini Jacobo xi̱hi̱n Juan cán ña̱ yóho já na̱cachi da já xi̱hi̱n Jesús: —Á co̱ cúni̱ ndó, xitoho i̱ ña̱ ná cahnda nde̱ chuun ña̱ ná cu̱yu ñúhu̱ cáyi̱ indiví já ná jánaá nde̱ sa̱há ña̱yivi yóho tá quia̱hva na̱caja profeta Elías sa̱nahá —na̱cachi na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A̱nda̱ já na̱ndicoto nihni Jesús nu̱ ná já na̱casáhá jána̱ni a na̱ já na̱cachi a já xi̱hi̱n ná: —Co̱ xíni̱ ndó ña̱ a̱ váha toho cáhvi ini ndó já. ");
INSERT INTO mksNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jáchi̱ co̱ó na̱quixi toho ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi, ña̱ ná jánaá i̱ sa̱há ña̱yivi. Na̱quixi i̱ ñuyíví yóho jáchi̱ cúni̱ ña̱ ná ca̱cu ndaa ínima̱ ná —na̱cachi Jesús xi̱hín na̱ cán. A̱nda̱ já na̱quee na cua̱ha̱n na̱ inga ñuu loho. ");
INSERT INTO mksNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ta nani xíca na cua̱ha̱n na̱ já na̱cachi in da̱ta̱a já xi̱hi̱n Jesús: —Cúni̱ candi̱co̱ i̱ ndo̱hó ndá na̱cuu nu̱ú cu̱hu̱n ndo̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já cáchí a̱ já xi̱hi̱n dá: —Ndicuii cúú rí ta va̱ti̱ íin cáva̱ ñúhu rí. Laa cúú rí ta va̱ti̱ íin táca̱ ñúhu rí. Joo ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi chí ni nu̱ú cu̱ju̱ mí i̱ co̱ó va —na̱cachi a xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tá na̱ndihi já na̱cachi Jesús já xi̱hín inga da: —Naha quíi̱ candi̱co̱ ye̱he̱. Joo na̱nducú ñehe da̱ cán tu̱hun nu̱ Jesús já cáchí da̱ já xi̱hi̱n á: —Quia̱hva jihna ndó ña̱ma̱ni̱ nu̱ú i̱ ña̱ ná cu̱hu̱n i̱ jándu̱xu̱ tátá i̱ já quixi i̱ candi̱co̱ i̱ ndo̱hó —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Ná cu̱hu̱n mé ña̱yivi, na̱ a̱ ñáha ca̱cu ndaa ínima̱ jándu̱xu̱ na̱ ndi̱i ja̱n. Joo yóhó, cuáhán ca̱xi tu̱hun nu̱ú ña̱yivi ña̱ sa̱ na̱ndindaa qui̱ví cacomí Ndióxi̱ cuéntá sa̱ha̱ ná —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A̱nda̱ já na̱cativi inga da̱ta̱a nu̱ Jesús já na̱cachi da já xi̱hi̱n á: —Jesús, candi̱co̱ i̱ ndo̱hó cúni̱. Joo quia̱hva ndó ña̱ma̱ni̱ nu̱ú i̱ ná cu̱hu̱n loho i̱ ndinda̱yí jihna ñúhú i̱ na̱ vehe e̱ já quixi i̱ candi̱co̱ i̱ ndo̱hó —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Ndá da̱ cásáhá ndíco̱ ye̱he̱ ta já ndicó co̱o tucu da cua̱ha̱n da̱ chí ja̱ta̱, cúú dá da̱ co̱ó chuun toho cacomí Ndióxi̱ cuéntá sa̱ha̱. Jáchi̱ da̱ cán cúú dá tátu̱hun da̱ tíin ya̱ta̱ ta cásáhá da̱ xútu da cua̱ha̱n da̱ joo tá na̱ndihi ndicoto nihni tucu da chí ja̱ta̱ ta chí co̱ó sa̱ha̱ dá cacomí Ndióxi̱ cuéntá sa̱ha̱ dá —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tá na̱ndihi já na̱ca̱xi Jesús inga u̱ni̱ jico u̱xu̱ chága̱ da̱ta̱a. Ta tá i̱vi̱ tá i̱vi̱ da̱ na̱chindahá a̱ da̱ cua̱ha̱n da̱ já ná cu̱hu̱n cuéé da̱ ca̱ha̱n da̱ tu̱hun Ndióxi̱ xi̱hín ña̱yivi ndúu tócó ndihi ñuu nu̱ú na̱sacu ini Jesús cu̱hu̱n a̱ coto nihni a ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A̱nda̱ já na̱cachi a já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ndúu cua̱há ndiva̱ha ña̱yivi, na̱ cúni̱ cuni jo̱ho tu̱hun Ndióxi̱ joo co̱ó cua̱há na̱ cúni̱ cu̱hu̱n ca̱ha̱n ña̱ xi̱hi̱n ná. Cúú á tátu̱hun va̱ha ndiva̱ha na̱cana níi̱ nu̱ú utu joo ndíma̱ní na̱ jáquee ña. Ña̱ cán quéa̱ xíní ñúhú ca̱ca̱ ta̱hví ndo̱ nu̱ú da̱ xi̱hín ña̱ha utu cán ña̱ ná chindahá chága̱ da̱ na̱ jáquee nu̱ú utu da. Quia̱hva já ndítahan ca̱ca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ ña̱ ná chindahá chága̱ mé á na̱ caca nuu ca̱ha̱n tu̱hun Ndióxi̱ xi̱hín ña̱yivi já ná ndiquehe va̱ha na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mé ndó cúú ndó na̱ chindahá i̱ cu̱hu̱n caca nuu ca̱ha̱n tu̱hun Ndióxi̱. Mé a̱ nda̱a̱ i̱yo ndiva̱ha cáa nu̱ú cu̱hu̱n ndo̱ jáchi̱ cacuu ndó tátu̱hun ndicachi válí tañu cua̱há ndiva̱hyí. ");
INSERT INTO mksNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tá na̱quee ndó cua̱ha̱n ndo̱ coto a̱ cáñehe ndó yátí cu̱hu̱n ndo̱ ni jiu̱hún ni inga ndu̱sa̱ ndó a̱ cáñehe ndó cu̱hu̱n ndo̱. Ta a̱ cácui̱ta ndó ca̱ha̱n Ndióxi̱ ndó xi̱hín ña̱yivi ndique táhan xi̱hi̱n ndó íchi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ta tá ná xi̱nu̱ co̱o ndó in vehe, jihna ñúhú ca̱ha̱n Ndióxi̱ ndó xi̱hín na̱ ndúu vehe cán já cachi ndó já xi̱hi̱n ná: “Ná coo va̱ha ini ndó, na̱ ndúu vehe yóho”, cachi ndó xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ta tá mé a̱ nda̱a̱ íin va̱ha ini ña̱yivi ndúu vehe cán já a̱ cándo̱o núu toho tu̱hun na̱cachi ndó xi̱hín na̱ cán. Joo tá co̱ íin va̱ha ini na̱ cán já a̱ quéhe ndó cuéntá sa̱há ña̱ na̱cachi ndó ña̱ ná coo va̱ha ini na̱ ja̱n jáchi̱ a̱ ju̱ú na̱ coo va̱ha ini cúú toho na̱ ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tá ná xi̱nu̱ co̱o ndó in vehe nu̱ ndíquehe va̱ha na ndo̱hó, canduu ndó mé vehe ja̱n. Ta a̱ cáca nuu ndó tá vehe tá vehe nducú ndo̱ nu̱ú coo ndó. Ta ndá ña̱ha íin nu̱ ná sáhan na nu̱ ndo̱ cuxu ndó á coho ndó, tiin ndó a̱ ndáha̱ ná. Jáchi̱ ndítahan nu̱ú in da̱ta̱a ndiquehe da ña̱ catacu da sa̱há chuun cája da. ");
INSERT INTO mksNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ta tá ná xi̱nu̱ co̱o ndó in ñuu nu̱ ndíquehe va̱ha na ndo̱hó, cuxu ndó ndía̱ cúú mé a̱ sáhan na nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ta ndaja va̱ha ndó ndá na̱ quíhvi̱ ndúu cán. Ta cachi ndó já xi̱hi̱n ná: “Sa̱ na̱cayati qui̱ví cacomí Ndióxi̱ cuéntá sa̱ha̱ ndo̱”, cachi ndó xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Joo tá ná xi̱nu̱ co̱o ndó in ñuu nu̱ú co̱ cúni̱ na̱ ndiquehe va̱ha na ndo̱hó, cuáhán ndó cáyé ñuu cán já cachi ndó já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ja̱nda̱ ña̱ yácá na̱tiin ndaa sa̱há nde̱ ñuu ndó yóho quíji nihni nde̱ ta xi̱hín ña̱ yóho náha̱ nde̱ ña̱ cua̱ha̱n cua̱chi ndó ja̱ta̱ mé va ndó. Jáchi̱ sa̱ na̱ca̱xi tu̱hun va nde̱ xi̱hi̱n ndo̱ ña̱ sa̱ na̱cayati qui̱ví cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi”, cachi ndó xi̱hi̱n ná —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A̱nda̱ já na̱cachi tucu a já xi̱hi̱n ná: —Tá ná xi̱nu̱ co̱o qui̱vi̱ caja vií Ndióxi̱ sa̱há ña̱yivi já jándoho chága̱ mé á ini ña̱yivi ñuu ja̱n a̱ ju̱ú ga̱ tá quia̱hva na̱jándoho a ini na̱ ñuu Sodoma sa̱nahá —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A̱nda̱ já na̱cachi tucu Jesús xi̱hi̱n ná já: —Ndáhví na̱há na̱cuu ndó, na̱ ñuu Corazín. Ta ndáhví na̱há na̱cuu ndó na̱ ñuu Betsaida. Cua̱há ndiva̱ha ña̱ náhnu na̱caja i̱ nu̱ ndo̱ joo co̱ó na̱xeen ndó ndicó co̱o ini ndó jándacoo ndó cua̱chi ndó. Sa̱nahá na̱jándihi Ndióxi̱ sa̱há ñuu Tiro xi̱hín sa̱há ñuu Sidón sa̱há cua̱chi na. Tá ná sa̱ha̱n i̱ caja i̱ ña̱ náhnu nu̱ú na̱ cán tá quia̱hva na̱caja i̱ nu̱ mé ndó, sa̱ na̱jándacoo va na̱ cán cua̱chi na, nduu. Ta chí i̱vi̱ la̱á nda̱ca̱ ndixi na jahmá ndií ta jácu̱yu na ya̱a̱ yíquí jíní na̱, nduu. Jáchi̱ xi̱hín ña̱ yóho jána̱ha̱ na̱ ña̱ na̱ndicó co̱o ini na sa̱há cua̱chi na. ");
INSERT INTO mksNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Joo tá ná xi̱nu̱ qui̱vi̱ caja vií Ndióxi̱ sa̱há ña̱yivi já ndoho chága̱ ini mé ndó, na̱ ñuu ja̱n a̱ ju̱ú ga̱ tá quia̱hva na̱ndoho ini ña̱yivi na̱sanduu ñuu Tiro xi̱hín ñuu Sidón sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ta viti cáha̱n i̱ xi̱hi̱n ndó, na̱ ndúu ñuu Capernaum. Ja̱nda̱ indiví cúni̱ ndó cu̱hu̱n ndó joo sa̱há ña̱ sáá ini ndó cu̱hu̱n ndó ja̱nda̱ indayá, caja Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","A̱nda̱ já na̱cachi a xi̱hín na̱ xíca tuun xi̱hi̱n á já: —Ndá na̱ xíni̱ jo̱ho nu̱ cáha̱n ndo̱ ta cája na ña̱ cáchí ndo̱ já quéa̱ cúú á tátu̱hun cája na ña̱ cáchí ye̱he̱ xi̱hi̱n ná caja na. Ta ndá na̱ cándají ndo̱hó cúú á tátu̱hun cándají ri na ye̱he̱ va. Ta ndá na̱ cándají ye̱he̱, cándají ri na Ndióxi̱, mé a̱ na̱chindahá a̱ ye̱he̱ quixi i̱ ñuyíví yóho —na̱cachi Jesús xi̱hín na̱ chíndahá mé á cu̱hu̱n ca̱ha̱n tu̱hun Ndióxi̱ xi̱hín ña̱yivi cán. A̱nda̱ já na̱quee na cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","A̱ ju̱ú quia̱hva cáji̱i̱ íní na̱ u̱ni̱ jico u̱xu̱ na̱ na̱chindahá Jesús ca̱ha̱n tu̱hun Ndióxi̱ cán tá na̱ndicó co̱o na. Já na̱cachi na já xi̱hi̱n Jesús: —Tá cáha̱n nde̱ qui̱vi̱ ndó sáhndá nde̱ chuun nu̱ ínima̱ quini ta chí xíni̱ jo̱ho rí ta cája rí ña̱ sáhndá nde̱ nu̱ ri̱ —na̱cachi na̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ quéa̱ cáha̱n ndó ja̱n. Jáchi̱ na̱xini i̱ xi̱hín nu̱u̱ mí i̱ ndá quia̱hva na̱quee Satanás, rí cúú tiñáhá sa̱cua̱ha̱ indiví ta na̱ndicava rí nu̱ ñúhu̱ tátu̱hun in tasa. ");
INSERT INTO mksNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chí na̱sa̱ha̱n i̱ ndée̱ nu̱ ndóhó ña̱ ná cuu cahnda ndó chuun nu̱ú tiñáhá sa̱cua̱ha̱. Já cuu cua̱ni nihni ndó ja̱tá co̱o xi̱hín ja̱ta̱ líhma̱ ta a̱ ndóho ndó ni in ña̱ha. Ta na̱sa̱ha̱n i̱ ndée̱ nu̱ ndo̱ ña̱ ná cuu quee va̱ha ndó nu̱ú ndihi ña̱ núu cúni̱ tiñáhá sa̱cua̱ha̱ caja rí xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Va̱tí cáji̱i̱ ini ndó sa̱há ña̱ cándúsa rí quini nu̱ sáhndá ndó chuun nu̱ ri̱ joo ndítahan caji̱i̱ chága̱ ini ndó sa̱há ña̱ sa̱ na̱que̱e va qui̱vi̱ ndó ña̱ cu̱hu̱n ndó indiví —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ta chí mé hora já na̱caja ínima̱ yi̱i̱ Ndióxi̱ ña̱ ná caji̱i̱ ndiva̱ha ini Jesús. Já na̱casáhá cáchí a̱ já: —Cája cáhnu i̱ ndo̱hó, tátá Ndióxi̱, ña̱ cúú xitoho tócó ndihi ña̱ha ndúu indiví xi̱hi̱n ñuyíví. Jáchi̱ na̱jána̱ha̱ ndó ña̱ ndíchí ndiva̱ha nu̱ú ña̱yivi, na̱ co̱ó cua̱há sa̱ha̱ nu̱ú java ga̱ na̱. Ta na̱caja ndó ña̱ ná a̱ cúu canda̱a̱ ini na̱ ndi̱chí xi̱hín na̱ tácu̱ ini ña̱ha mé ndó. Já na̱caja ndó jáchi̱ já na̱sacu ini ndó caja ndó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","A̱nda̱ já na̱cachi a já xi̱hín na̱ ndúu cán: —Na̱ndiquia̱hva tátá i̱ tócó ndihi ña̱ha ndahá i̱ ña̱ ná cacomí i̱ cuéntá sa̱há. Ta ni in túhún toho ña̱yivi co̱ xíni̱ va̱ha na̱ ye̱he̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱. Mé Ndióxi̱, tátá i̱ cuití va xíni̱ va̱ha ye̱he̱. Ta ni in túhún toho na co̱ xíni̱ va̱ha yo cúú tátá i̱. In túhún ye̱he̱, da̱ cúú ja̱hyi a xíni̱ va̱ha i̱ yo cúú mé á. Ta ye̱he̱ cúú da̱ ca̱xi ndá ña̱yivi jána̱ha̱ i̱ nu̱u̱ sa̱há Ndióxi̱, tátá i̱ já ná canda̱a̱ va̱ha ini na yo cúú mé á —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A̱nda̱ já na̱sande̱hé a̱ nu̱ú na̱ xíca tuun xi̱hi̱n á cán. Já na̱casáhá cáchí a̱ já xi̱hi̱n mé cuití na̱: —Ta̱hví na̱cuu ña̱yivi tá ná cuu cande̱hé na̱ tócó ndihi ña̱ xíní mé ndó viti. ");
INSERT INTO mksNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ cua̱ha̱ táhan na̱ profeta na̱sanduu sa̱nahá ta cua̱ha̱ táhan na̱ na̱sacomí cuéntá sa̱há ña̱yivi sa̱nahá cúni̱ na̱ cuni na tócó ndihi ña̱ xíní ndo̱ cája i̱. Joo co̱ó na̱xini na ña̱. Ta cúni̱ na̱ cuni jo̱ho na ña̱ xíni̱ jo̱ho ndó cáha̱n i̱ xi̱hi̱n ndo̱. Joo co̱ó na̱xini jo̱ho na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ta ndaja coo in da̱ jána̱ha̱ ley Moisés na̱nda̱ca̱ ndichi da ca̱ha̱n da̱ xi̱hi̱n Jesús jáchi̱ cúni̱ da̱ coto ndojó ñahá da̱. Ta na̱cachi da já xi̱hi̱n á: —Maestro, ndía̱ ndítahan caja i̱ já ná cuu catacu u̱ indiví a̱nda̱ ama cáa qui̱vi̱ —na̱cachi da xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já xi̱hi̱n dá: —Ndaja cáchí ley Moisés. Ndaja cáchí ley tá cáhvún ña̱ —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A̱nda̱ já na̱nducú ñehe da̱ jána̱ha̱ ley Moisés cán tu̱hun nu̱ Jesús já na̱cachi da já: —“Qui̱hvi̱ inún Ndióxi̱, xitohún xi̱hi̱n tócó ndihi ínimu̱n ta xi̱hi̱n ndinuhu inún. Ta qui̱hvi̱ inún a̱ xi̱hi̱n tócó ndihi ndéu̱n ta xi̱hi̱n tócó ndihi xíní túnu̱n. Ta qui̱hvi̱ inún ñani táhún tá quia̱hva quíhvi̱ inún mún” —na̱cachi da̱ cán na̱nducú ñehe da tu̱hun nu̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Mé a̱ nda̱a̱ va̱ha va na̱ca̱hu̱n. Cuáhán caja tócó ndihi ña̱ yóho já ñe̱he̱ táhvu̱n catacún indiví a̱nda̱ ama cáa qui̱vi̱ —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Joo da̱ jána̱ha̱ ley Moisés cán cúni̱ da̱ cando̱o va̱ha da nu̱ú ña̱yivi ndúu cán sa̱há ña̱ cán quéa̱ cáchí da̱ já xi̱hi̱n Jesús: —Yo já cúú ñani táhan i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A̱nda̱ já na̱ndicani Jesús nu̱ dá já cáchí a̱ já xi̱hi̱n dá: —In tañu na̱quee in da̱ta̱a ñuu Jerusalén cua̱ha̱n da̱ íchi̱ ña̱ na̱nuu cua̱ha̱n chí ñuu Jericó. Ta ndaja coo cán na̱queta java ta̱a cui̱hná nu̱ dá. Ta na̱tiin na da̱ ta na̱caja cuíhná ndihi na ña̱ha da ja̱nda̱ jáhma̱ dá viti na̱quehe na. Tá na̱ndihi já na̱cani quini ndiva̱ha na da̱ ja̱nda̱ quia̱hva na̱sahní tóo na da̱. Já na̱quee na cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ta ña̱ va̱ha quéa̱ na̱ya̱ha in ju̱tu̱ mé íchi̱ cán. Joo tá na̱xini ñahá da̱ já na̱ya̱ha saa da cua̱ha̱n va da. ");
INSERT INTO mksNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta sa̱ mé íchi̱ cán na̱ya̱ha ri in da̱ na̱quixi chi̱chi Leví ta tá na̱xini da da̱ na̱ndicue̱he̱ cándúhu̱ íchi̱ cán já na̱ya̱ha saa da cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Jári in da̱ Samaria xíca cua̱ha̱n mé íchi̱ cán. Joo tá na̱xini da̱ da̱ na̱ndicue̱he̱ cándúhu̱ íchi̱ cán chí na̱ta̱hvi̱ ini da sa̱ha̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A̱nda̱ já na̱cayati da nu̱ cándúhu̱ dá. Já na̱caja tátá da̱ nu̱ú na̱ndicue̱he̱ da̱ quíhvi̱ cán xi̱hi̱n sítí xi̱hi̱n vino viti. Ta já na̱cató da̱ nu̱ú na̱ndicue̱he̱ cán xi̱hín ti̱co̱to̱. Tá na̱ndihi na̱jándaa da da̱ ja̱ta̱ búrro̱ ja̱na̱ dá já ñéhe ñahá da̱ cua̱ha̱n da̱. Já na̱nducú da̱ vehe coo tóo da̱ quíhvi̱ cán ña̱ ná candaa na da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ta inga qui̱ví ita̱a̱n tá na̱sacu ini da̱ Samaria cán quehe da íchi̱ cu̱hu̱n da̱ já na̱tavá da̱ i̱vi̱ jiu̱hún ca̱a na̱sa̱ha̱n da̱ nu̱ú da̱ xi̱hín ña̱ha vehe cán. Já na̱cachi da já xi̱hi̱n dá: “Cajún ña̱ma̱ní candaa va̱hún da̱ quíhvi̱ yóho. Ta tá ná chica̱a̱n chágu̱n jiu̱hún xi̱hi̱n dá, a̱ ndícani toho inún jáchi̱ cha̱hvi mí vi̱ ña̱ nu̱u̱n tá ná ndicó co̱o i̱”, cáchí da̱ Samaria cán —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús da̱ jána̱ha̱ ley Moisés cán já na̱cachi a já xi̱hi̱n dá: —Ta viti cachún xi̱hín i̱ ti̱xi ndíhu̱ni̱ da̱ na̱ya̱ha íchi̱ nu̱ú na̱sanduhú da̱ na̱ndicue̱he̱ na̱caja ta̱a cui̱hná yóho, ndá da̱ cúú da̱ na̱na̱ha̱ ña̱ mé a̱ nda̱a̱ táhyí quíhvi̱ ini da ñani táhan da —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A̱nda̱ já na̱cachi da̱ jána̱ha̱ ley Moisés já: —Da̱ na̱ta̱hvi̱ ini sa̱há da̱ na̱ndicue̱he̱ ja̱n, da̱ ja̱n cúú da̱ cája i̱ cuéntá na̱na̱ha̱ da̱ ña̱ mé a̱ nda̱a̱ quíhvi̱ ini da ñani táhan da —na̱cachi da̱ cán. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Ta viti cuáhán ri yóhó va, qui̱hvi̱ inún ñani táhún tá quia̱hva na̱caja da̱ Samaria yóho —na̱cachi a xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na̱quehe Jesús íchi̱ xíca cua̱ha̱n ja̱nda̱ quia̱hva na̱xi̱nu̱ co̱o a in ñuu loho. Ta cán na̱ndiquehe va̱ha in ñá naní Marta mé á vehe ñá. ");
INSERT INTO mksNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ta na̱sahi̱in in qui̱hvi̱ Marta yóho, ñá naní María. Ta na̱xi̱nu̱ co̱o María na̱saco̱o ñá yati sa̱ha̱ Jesús jáchi̱ cúni̱ ñá cuni jo̱ho ñá nu̱ cáha̱n mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Joo ndaja coo a̱ ju̱ú quia̱hva ndíhi ini mé Marta cája ndíví ñá ña̱ha cuxu na ndáca̱a̱n ña̱. A̱nda̱ já na̱cayati ñá nu̱ Jesús já na̱cachi ñá já xi̱hi̱n á: —Cande̱hé ndo̱, xitoho i̱. Á co̱ sánde̱hé toho ndó ña̱ in túhún mí i̱ cája ndíví i̱ ña̱ha ta ñá cúú qui̱hví i̱ ja̱n co̱ chíndeé loho ñá ye̱he̱. Ca̱ha̱n loho ndó xi̱hi̱n ña̱ ná chindeé ñá ye̱he̱ —na̱cachi Marta cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ña̱ já cáchí a̱ já xi̱hi̱n ña̱: —Marta loho, a̱ ju̱ú quia̱hva ndícani inún ta ndíhi inún jáchi̱ íin ndiva̱ha chuun nu̱u̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Joo íin in túhún ña̱ha ña̱ íin chága̱ sa̱ha̱ ta cúú á ña̱ ndítahan cajún. Ta María, ñá cúú qui̱hvu̱n yóho na̱ca̱xi ñá ña̱ va̱ha chága̱. Ta ni in na a̱ cúu caji nuu nu̱ ñá cuni jo̱ho ñá tu̱hun cáha̱n i̱ —na̱cachi Jesús xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","In tañu xíca ta̱hví Jesús nu̱ Ndióxi̱ ndáca̱a̱n. Ta tá na̱ndihi na̱xi̱ca̱ ta̱hví a̱ já na̱cachi in táhan da̱ xíca tuun xi̱hi̱n á cán já xi̱hi̱n á: —Jána̱ha̱ ndó nde̱he̱, xitoho nde̱ ca̱ca̱ ta̱hví nde̱ nu̱ Ndióxi̱, tátá yo̱ tá quia̱hva na̱caja Juan, da̱ na̱caja ndúta̱ ña̱yivi. Jáchi̱ na̱jána̱ha̱ da̱ nu̱ú na̱ na̱sa̱xi̱ca xi̱hi̱n dá ndá quia̱hva caja na ca̱ca̱ ta̱hví na̱ nu̱ Ndióxi̱ —na̱cachi da̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ cán: —Tá ná ca̱ca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ já cachi ndó já: Tátá Ndióxi̱, ña̱ íin indiví, cáhnu ná cacuu qui̱vi̱ ndo̱. Ná tandaa quíi̱ qui̱ví cacomí ndó cuéntá sa̱há nde̱. Ta ná coo tá íin cúni̱ mé ndó coo ñuyíví yóho tá quia̱hva íin indiví cája ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Quia̱hva ndó nu̱ú nde̱ ña̱ ndíma̱ní nu̱ú nde̱ cuxu nde̱ in in qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Caja cáhnu ini ndó sa̱há cua̱chi nde̱ tá quia̱hva cája cáhnu ini nde̱ sa̱ha̱ tócó ndihi ña̱ núu cája ña̱yivi xi̱hín nde̱. Ta a̱ quiáhva ndó ña̱ma̱ni̱ ña̱ ná coto ndojó tiñáhá sa̱cua̱ha̱ nde̱he̱ já ná a̱ cája nde̱ cua̱chi nu̱ ndo̱, já cachi ndó ca̱ca̱ ta̱hví ndo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","A̱nda̱ já na̱sacu Jesús in quia̱hva nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Cúú á tátu̱hun tá ná cu̱hu̱n ndó vehe in amigo ndo̱ java ñuú táji̱ ta já cachi ndó já xi̱hi̱n dá: “Amigo, á a̱ quiáhva tóún u̱ni̱ pan nu̱ú i̱ ");
INSERT INTO mksNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","jáchi̱ na̱casa̱a̱ in da̱ xíní táhan xi̱hín i̱ vehe e̱ ta cúú dá da̱ na̱sa̱ha̱n xícá ta co̱ó ña̱ha nu̱ú i̱ quia̱hva i̱ cuxu da”, cachi ndó xi̱hi̱n amigo ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ta viti ná caja í cuéntá nducú ñehe da ndáca̱a̱n ini vehe cán tu̱hun nu̱ ndo̱ já cachi da já: “A̱ jáqui̱hvún ye̱he̱ jáchi̱ ndájí tuun yéhé. Ta ndúu ja̱hyi válí i̱ quíji̱ na̱ xi̱hín i̱ nu̱ú xi̱to ta a̱ cu̱ú caja i̱ ndaco̱o i̱ quia̱hva i̱ ndá ña̱ha nu̱u̱n”, cachi da̱ cán xi̱hi̱n ndo̱ ná caja í cuéntá. ");
INSERT INTO mksNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ va̱tí co̱ cúni̱ da̱ ja̱n ndaco̱o da quia̱hva da ña̱ha nu̱ ndo̱ sa̱há ña̱ xíní táhan ndó xi̱hi̱n dá joo ndaco̱o tá ndaco̱o da̱ quia̱hva da ña̱ha nu̱ ndo̱ sa̱há ña̱ jáqui̱hvi ndó da̱. Sa̱há ña̱ cán quéa̱ ndaco̱o da quia̱hva da tócó ndihi ña̱ xíní ñúhú ndo̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ña̱ cán quéa̱ cáha̱n i̱ ña̱ yóho xi̱hi̱n ndo̱: Ndá ña̱ha ndíma̱ni̱ nu̱ ndo̱ xíní ñúhú ca̱ca̱ ndó ña̱ nu̱ Ndióxi̱ ta já quia̱hva mé á ña̱ nu̱ ndo̱. Ndinducú ndo̱ ña̱ cúni̱ ndo̱ ta ñehe ndó ña̱ caja Ndióxi̱. Cúú á tátu̱hun catí ndáha̱ ndo̱ yéhé ta já nu̱na̱ yéhé nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jáchi̱ na̱ xíca̱, na̱ cán cúú na̱ ñéhe̱ va. Ta na̱ ndúcú ña̱ha, na̱ cán cúú na̱ ndíñe̱he̱ va. Ta na̱ cátí ndáha̱ yéhé, na̱ cán cúú na̱ ndínu̱na̱ yéhé nu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ʼTa ndá ndó, na̱ ndúu ja̱hyi ta tá xíca̱ ja̱hyi ndó pan cuxu a nu̱ ndo̱, ama cuéhé ri ndó quia̱hva ndó yu̱u̱ nu̱ á ña̱ ná caxí a̱. Ta ama ná quia̱hva ndó co̱o caxí a̱ tá xíca̱ cu̱ñu ti̱yacá caxí a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ta ama cuéhé ri ndó quia̱hva ndó líhma̱ caxí ja̱hyi ndó tá xíca̱ ndi̱vi̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Va̱tí cúú ndó ña̱yivi cája cua̱chi joo xíni̱ va̱ha ndó quia̱hva ndó ña̱ va̱ha nu̱ú ja̱hyi ndó. Ta ndaja ga̱ ví cája Ndióxi̱, tátá ndo̱, mé a̱ íin indiví xi̱hi̱n ndo̱. Quia̱hva mé á ínima̱ yi̱i̱ á nu̱ ndá na̱ ná ca̱ca̱ ña̱ nu̱ á —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","In tañu tává Jesús ínima̱ quini ini in da̱ta̱a, da̱ na̱nduu níhi̱, na̱caja rí quini. Ta tá sa̱ na̱cana mé rí quini ini da̱ cán na̱caja Jesús a̱nda̱ já na̱ndica̱ha̱n tucu da. Ta chí na̱catóntó cua̱há ña̱yivi ndúu cán tá na̱xini na ña̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Joo java na na̱casáhá cáchí na̱ já sa̱ha̱ Jesús: —Ta̱a yóho cúú tává da̱ rí quini ñúhu ini ña̱yivi jáchi̱ mé Beelzebú, rí cúú tiñáhá sa̱cua̱ha̱ nu̱ rí quini cán, sáhan rí ndée̱ rí nu̱ dá cája da ña̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ta java ga̱ na̱ cúni̱ na̱ coto ndojó na̱ Jesús sa̱há ña̱ cán quéa̱ na̱xi̱ca̱ na̱ nu̱ á ña̱ ná caja mé á ña̱ha xitúhún quixi indiví já ná cuni na. ");
INSERT INTO mksNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Joo xíni̱ va̱ha va Jesús ña̱ cáhvi ini na̱ cán sa̱há ña̱ cán quéa̱ na̱cachi a já xi̱hi̱n ná: —Tá sáhndá java táhan ña̱yivi ndúu in ñuu ta ndúu na cua̱ha̱ táhndá já cásáhá cáni táhan ndaja táhan mé va na já cama chá ndihi sa̱há ñuu nu̱ ndúu na cán. Ta quia̱hva já yáha xi̱hín na̱ ndúu in vehe tá cásáhá sáhndá java táhan na ta cáni táhan na já cama chá ndihi sa̱há vehe na. ");
INSERT INTO mksNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ta quia̱hva já yáha xi̱hín Satanás, rí cúú tiñáhá sa̱cua̱ha̱ va. Tá ná cani táhan ndaja táhan mé rí já quéa̱ ndihi sa̱ha̱ ndée̱ ña̱ cómí ri̱. Cáha̱n i̱ ña̱ yóho xi̱hi̱n ndo̱ jáchi̱ cáchí ndo̱ ña̱ tává i̱ rí quini ini ña̱yivi xi̱hi̱n ndée̱ Beelzebú, rí cúú tiñáhá sa̱cua̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Joo tá mé a̱ nda̱a̱ cúú ndusa ña̱ cáchí ndó sa̱há i̱ ja̱n, ndáchí quéhe na̱ cúú cuéntá mé ndó ja̱n ndée̱ tává na̱ rí quini ini ña̱yivi. Ama ná cachi ndó ña̱ tává ndó rí quini xi̱hi̱n ndée̱ tiñáhá sa̱cua̱ha̱. Ña̱ yóho náha̱ ña̱ co̱ cáhvi nda̱a̱ ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Joo ye̱he̱ xi̱hín in túhún ndée̱ Ndióxi̱ tává i̱ ínima̱ quini ini ña̱yivi. Ta xi̱hín ña̱ yóho náha̱ cáxí a̱ ña̱ sa̱ na̱xi̱nu̱ co̱o qui̱ví cacomí Ndióxi̱ cuéntá sa̱ha̱ ndo̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ta sácú Jesús quia̱hva nu̱ ná ta xi̱hín ña̱ yóho jána̱ha̱ ña̱ quee va̱ha mé á xi̱hín tiñáhá sa̱cua̱ha̱. Já cáchí a̱ já: —Íin in da̱ta̱a ta tóyíí cáa da ta ñéhe da ndá chúun chíndeé da̱ mé dá. Ta nani ndáá da̱ vehe da mé a̱ nda̱a̱ co̱ó toho ña̱ha ndoho ña̱ha da jáchi̱ ndáá va̱ha da ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Joo tá ná quixi inga ta̱a, da̱ ndacú chága̱ a̱ ju̱ú ga̱ mé da̱ cán ta quee va̱ha da xi̱hi̱n dá já candaa ndihi da ndá chúun ña̱ na̱candeé ini da mé dá. Ta já caja tá cúni̱ mé da̱ ndacú chága̱ cán xi̱hi̱n ña̱ha da̱ inga cán. ");
INSERT INTO mksNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ʼNdá na̱ co̱ó cua̱ha̱n xoo i̱, cúú ná na̱ co̱ cúní ye̱he̱. Jáchi̱ ndá na̱ co̱ chíndeé ye̱he̱ xi̱hín ña̱ cája i̱, cúú ná na̱ sájí nuu nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ʼTá quéta in rí quini ini in da̱ta̱a já quée rí cua̱ha̱n rí xíca nuu rí ndijáá yucú íchí ndínducú rí nu̱ú cando̱o rí. Ta tá co̱ ndíñe̱he̱ rí ña̱ já cásáhá cáhvi ini rí já: “Cóho̱ ndicó co̱o tucú ini da̱ nu̱ú na̱sa̱ndaca̱a̱n í cán jáchi̱ cúú á tátu̱hun vehé”, cáhán ri̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ta tá xi̱nu̱ co̱o rí ini da̱ cán já sánde̱hé ri̱ ña̱ íin vií va ini da̱ cán tá quia̱hva vií ini vehe tá na̱ti̱hvi̱ á ta na̱ndaca ndójó va̱ha tócó ndihi ña̱ha ini a. ");
INSERT INTO mksNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","A̱nda̱ já quée tucu mé rí quini cán cua̱ha̱n ri̱ quehe rí u̱sa̱ ga̱ rí quini chága̱ a̱ ju̱ú ga̱ mé rí já xínu ndihi rí ndi̱hvi rí ini da̱ cán. Ta mé da̱ cán ndiquini chága̱ da̱ a̱ ju̱ú tá na̱sa̱ndaca̱a̱n in tála̱á rí ini da —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ta nani cáha̱n Jesús tu̱hun yóho nu̱ú ña̱yivi já na̱cayuhú cóhó in ñáñáha̱ tañu ña̱yivi cua̱ha̱ cán já na̱cachi ñá já: —Ta̱hví na̱cuu ñá na̱jácacu yo̱hó, mé ñá na̱jácuáhnu yo̱hó —na̱cachi ñá xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A̱nda̱ já na̱cachi Jesús já: —Ta̱hví chága̱ na̱cuu ña̱yivi tá xíni̱ jo̱ho na tu̱hun Ndióxi̱ ta cája na ña̱ cáchí a̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tá ndítaca cua̱há ña̱yivi nu̱ íin Jesús já na̱casáhá mé á cáha̱n xi̱hi̱n ná já na̱cachi a já: —Quini ndiva̱ha va ña̱yivi ndúu tiempo viti. Xíca̱ na̱ ña̱ ná caja i̱ ña̱ha xitúhún nu̱ ná. Joo co̱ó toho ña̱ cán coo. Ña̱ cuni ndusa na quéa̱ ndoho i̱ tá quia̱hva na̱ndoho Jonás, da̱ na̱sacuu profeta sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jáchi̱ mé ña̱yivi na̱sanduu sa̱nahá ñuu Nínive cán na̱canda̱a̱ ini na ña̱ na̱chindahá Ndióxi̱ Jonás nu̱ ná. Ta quia̱hva já canda̱a̱ ri ini na̱ ndúu viti ña̱ na̱chindahá ri Ndióxi̱ ye̱he̱ va, da̱ na̱nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tá ná xi̱nu̱ qui̱ví caja vií Ndióxi̱ sa̱há cua̱chi ña̱yivi ndúu tiempo viti a̱nda̱ já ndicui̱ta in ñá na̱sacomí cuéntá sa̱há ña̱yivi ndúu chí sur sa̱nahá ta chica̱a̱n ñá cua̱chi ja̱tá ña̱yivi ndúu tiempo viti. Jáchi̱ mé ñá cán va̱tí na̱sahi̱in xícá ndiva̱ha ñá nu̱ rey Salomón sa̱nahá na̱sa̱ha̱n ñá cuni jo̱ho ñá tu̱hun ndíchí cáha̱n da̱. Ta ye̱he̱ íin chága̱ sa̱há i̱ a̱ ju̱ú ga̱ Salomón joo co̱ cándúsa ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ta jári ña̱yivi na̱sanduu Nínive sa̱nahá cán ndicui̱ta na chica̱a̱n na cua̱chi ja̱ta̱ ndo̱ tá ná xi̱nu̱ qui̱ví caja vií Ndióxi̱ sa̱há cua̱chi ña̱yivi ndúu viti. Jáchi̱ mé na̱ na̱sanduu ñuu Nínive cán na̱jándacoo na cua̱chi cája na tá na̱ca̱ha̱n Jonás xi̱hi̱n ná ña̱ na̱cachi Ndióxi̱ coo. Ta ye̱he̱ íin chága̱ sa̱há i̱ a̱ ju̱ú ga̱ Jonás joo co̱ cándúsa ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ʼNi in túhún toho ña̱yivi co̱ chíca̱a̱n ñúhu̱ ná in lámpara ta já quéhe na ña̱ sácú na̱ in nu̱ú je̱hé. Ni co̱ chíca̱a̱n na̱ ña̱ ti̱xi sa̱to̱. Ña̱ cája na quéa̱ chínúu jícó na̱ ña̱ já ná ye̱he̱ nu̱ú na̱ quíhvi ini vehe cán. ");
INSERT INTO mksNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nduchú núú yo̱ cúú á tátu̱hun in lámpara jándiye̱he̱ a̱ nu̱ yo̱ já xíní yo̱ nu̱ xíca í. Ta tá tívi va̱ha nduchú núú yo̱ já cuu cande̱hé va̱ha í nu̱ xíca í. Joo tá co̱ tívi nduchú núú yo̱ já quéa̱ xíca í nu̱ naá ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Cuéntá coo ndó a̱ ju̱ú ca̱hán ndo̱ ña̱ cúú ndó na̱ xíca nu̱ yéhe̱ ta cáa ví ndó cája ndó cua̱chi tátu̱hun na̱ xíca nu̱ naá. ");
INSERT INTO mksNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tá ná quia̱hva ndó ña̱ma̱ni̱ jándiye̱he̱ Ndióxi̱ ínima̱ ndo̱ já a̱ cája ga̱ ndó cua̱chi jáchi̱ a̱ cáñehe ga̱ ndó ínima̱ quini. Tá cája ndó ña̱ cúni̱ Ndióxi̱ já cúú á tátu̱hun in lámpara jándiye̱he̱ ínima̱ ndo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tá na̱ndihi na̱ca̱ha̱n Jesús já na̱cana in da̱ fariseo Jesús ña̱ ná cu̱hu̱n a̱ cuxu a vehe da. Tá na̱ndihi já na̱sa̱ha̱n Jesús vehe da já na̱qui̱hvi a na̱saco̱o a nu̱ mesa xi̱hi̱n java na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Joo ndaja coo da̱ fariseo cán chí na̱catóntó da̱ jáchi̱ na̱xini da ña̱ co̱ó na̱ndahá Jesús caco̱o a cuxu a tá quia̱hva íin costumbre mé na̱ fariseo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A̱nda̱ já na̱cachi Jesús já xi̱hín da̱ fariseo cán: —Ndóhó, na̱ fariseo, ndíhi ini ndó cája ndó costumbre ña̱ ndícata ndó ja̱ta̱ vaso xi̱hín ja̱tá co̱ho̱ viti joo co̱ ndíhi ini ndó ndícata ndó ini a. Quia̱hva já cája mé va ndó jáchi̱ ndíhi ini ndó ndahá ndo̱ tátu̱hun costumbre ndo̱ joo co̱ ndíhi ini ndó ndaja vií ndo̱ ínima̱ ndo̱ nu̱ú na̱chutú nda̱a̱ xi̱hín ña̱ha quini cáhvi ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ndaja tóntó ji̱ni̱ ndo̱. Á co̱ xíni̱ toho ndó ña̱ tá na̱cava̱ha Ndióxi̱ ña̱yivi já na̱cava̱ha mé á yiquí cu̱ñu na ta na̱cava̱ha mé á ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Caja ndó ña̱ma̱ni̱ xi̱hín na̱ nda̱hví xi̱hín ndinuhu ini ndó já ná coo vií ndó nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ʼNdáhví na̱cuu ndó, na̱ fariseo. Mé ndó tá cáchí ndo̱ sáhan ndó ña̱ha nu̱ Ndióxi̱ já cáva̱ha ndó u̱xu̱ táhndá ña̱ha ndó cán. Ta in a sáhan ndó nu̱ Ndióxi̱ ta quéhe ndihi ndó ña̱ java cán. Quia̱hva já cája ndó xi̱hín mi̱nu estila xi̱hín yu̱cu̱ lo̱tá ta quia̱hva já cája ndó xi̱hi̱n tá nu̱ú ña̱ha cána nu̱ ñúhu̱ ndo̱. Joo co̱ cája ndó ña̱ nda̱a̱ xi̱hín ña̱yivi. Ta ni co̱ quíhvi̱ ini ndó Ndióxi̱. Joo ña̱ cúni̱ Ndióxi̱ caja ndó quéa̱ ná caja nda̱a̱ ndó ta ná qui̱hvi̱ ini ndó a̱. Ta a̱ ndíndójó ndó quia̱hva ndó ña̱ha nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ʼNdáhví na̱cuu ndó, na̱ fariseo. Jáchi̱ tá sáha̱n ndó veñu̱hu cátóó ndo̱ caco̱o ndó nu̱ sáco̱o na̱ náhnu. Ta cúni̱ ndó ña̱ ná ca̱ha̱n Ndióxi̱ toní ñúhú ndiva̱ha ña̱yivi xi̱hi̱n ndo̱ tá ndique táhan na xi̱hi̱n ndo̱ íchi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ʼNdáhví na̱cuu ndó, na̱ jána̱ha̱ ley Moisés. Ta ndáhví na̱cuu ndó, na̱ fariseo. Jáchi̱ co̱ cúú ndó tá quia̱hva ndáa ndó. Mé ndó cúú ndó tátu̱hun yávi̱ nu̱ táán na̱ ndi̱i jáchi̱ núu cája ndó. Va̱tí xójo̱ cava ña̱yivi yáha na nu̱ú na̱ndu̱xu̱ ndi̱i cán joo co̱ xíni̱ na̱ ña̱ cúú á in yávi̱ nu̱ ñúhu ndi̱i jáchi̱ co̱ó yu̱u̱ ñáñí a̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A̱nda̱ já na̱nducú ñehe in da̱ jána̱ha̱ ley Moisés cán tu̱hun nu̱ Jesús já na̱cachi da já xi̱hi̱n á: —Maestro, xi̱hín tu̱hun cáha̱n ja̱n jándihi̱hvi̱ ri a nde̱he̱ va. ");
INSERT INTO mksNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Ndáhví na̱cuu ri ndóhó va, na̱ jána̱ha̱ ley Moisés. Jáchi̱ cája ndó ña̱ ná coo i̱hvi̱ ndiva̱ha ley já ná a̱ cúu caja ña̱yivi ña̱. Joo mé ndó cája ndúsa̱ ndó xi̱hi̱n ná ña̱ ná caja na ña̱ va̱tí ni mé ndó a̱ cu̱ú caja ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ʼNdáhví na̱cuu ndó jáchi̱ cúú á tátu̱hun cáva̱ha ndó ñáñí nu̱ jándu̱xu̱ ndó na̱ profeta, na̱ na̱sahní tásáhnu jícó ndo̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ta xi̱hín ña̱ yóho náha̱ ndó ña̱ cáji̱i̱ ini ndó xi̱hín ña̱ na̱caja tásáhnu jícó ndo̱ sa̱nahá tá na̱sahní na̱ na̱ profeta. Ta viti cúú á tátu̱hun chíndeé táhan ndó xi̱hín na̱ cán jáchi̱ mé ná na̱sahní na̱ na̱ profeta ta mé ndó na̱cava̱ha ndó nu̱ú na̱ndu̱xu̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ʼXíni̱ va̱ha Ndióxi̱ ña̱yivi ta nda̱a̱ na̱ca̱ha̱n mé á tá na̱cachi a já: “Chindahá i̱ java profeta xi̱hín java apóstol nu̱ ndo̱. Joo mé ndó cahní ndo̱ java na ta java na ndicui̱ta ñee ndó na̱”, na̱cachi Ndióxi̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Joo viti ca̱ca̱ Ndióxi̱ cuéntá nu̱ú ña̱yivi ndúu tiempo viti sa̱ha̱ tócó ndihi na̱ profeta, na̱ na̱xi̱hi̱ ndijáá tiempo ja̱nda̱ nani na̱ca̱va̱ sáhá sa̱ha̱ ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ca̱ca̱ Ndióxi̱ cuéntá nu̱ú ña̱yivi ndúu tiempo viti sa̱há na̱ profeta ndi̱i na̱xi̱hi̱ sa̱nahá. Ca̱ca̱ mé á cuéntá sa̱há Abel, da̱ na̱xi̱hi̱ na̱caja Caín cán. Ta ca̱ca̱ mé á cuéntá sa̱há ndijáá na̱ profeta na̱xi̱hi̱ tiempo na̱quixi cán ja̱nda̱ quia̱hva na̱xi̱nu̱ co̱o a nu̱ú ca̱ca̱ cuéntá sa̱há ndi̱i Zacarías. Mé da̱ yóho na̱sahní na̱ da̱ ini veñu̱hu sa̱nahá tañu nu̱ náa̱ xi̱hín nu̱ú yi̱i̱ ndiva̱ha. Ña̱ cán quéa̱ cáha̱n i̱ xi̱hi̱n ndó ña̱ ca̱ca̱ Ndióxi̱ cuéntá sa̱ha̱ tócó ndihi ndi̱i ja̱n nu̱ú ña̱yivi ndúu tiempo viti. ");
INSERT INTO mksNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ʼNdáhví na̱cuu ndó, na̱ jána̱ha̱ ley Moisés. Jáchi̱ cája ndó ña̱ ná a̱ cúu canda̱a̱ ini ña̱yivi ña̱ cáchí tu̱hun Ndióxi̱. Ta xi̱hín ña̱ yóho cúú ndó na̱ sájí nuu cuití va jáchi̱ ni co̱ sáhan ndó ña̱ma̱ní nu̱ ná ña̱ ná candúsa na ña̱ nda̱a̱. Ta mé ndó va̱tí xíni̱ ndó cúú á ña̱ nda̱a̱ joo co̱ cája ndó ña̱ cáchí a̱ —na̱cachi Jesús xi̱hín na̱ jána̱ha̱ ley Moisés cán. ");
INSERT INTO mksNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tá na̱cachi Jesús ña̱ yóho já na̱xo̱jo̱ ndiva̱ha ini na̱ jána̱ha̱ ley Moisés cán xi̱hín na̱ fariseo cán xi̱hi̱n á. Ta já na̱casáhá na̱ ndáca̱ tu̱hún cua̱ha̱ chága̱ na̱ mé á sa̱há ña̱ cúni̱ na̱ jáqui̱hvi̱ cuití ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ta na̱sacu cua̱ha̱ ná tu̱hun i̱hvi̱ nu̱ á jáchi̱ ndúcú na̱ ndá quia̱hva chica̱a̱n na̱ cua̱chi ja̱tá xi̱hín in tu̱hun ña̱ ná ya̱ha yúhu̱ á ca̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ta nani cáha̱n Jesús cán na̱casáhá tácá cua̱há ndiva̱ha ña̱yivi. Cua̱ha̱ mil na̱ na̱casáhá ndáí cuu na cán. Ja̱nda̱ quia̱hva cándíhi táhan ndaja táhan mé ná xi̱hi̱n á cua̱ha̱n ná. Nu̱ cuítí na̱ca̱ha̱n Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á já cáchí a̱ já: —Cuéntá coo ndó xi̱hín na̱ fariseo jáchi̱ cúú ná tátu̱hun yúsa̱ na̱xa̱a̱ quée xi̱hi̱n harina ña̱ cáva̱ha na pan. Co̱ cúú ná tá quia̱hva ndáa na. ");
INSERT INTO mksNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta ni in túhún toho ña̱ha a̱ cúu coo je̱hé na̱há jáchi̱ cana tá cana tu̱hun sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tócó ndihi tu̱hun na̱ca̱ha̱n je̱hé ndó ñuú já va̱xi qui̱vi̱ cuni jo̱ho ña̱yivi ña̱ ndiví táhyí. Tócó ndihi ña̱ na̱ca̱ha̱n je̱hé ndo̱ tá ndájí yéhé já va̱xi qui̱vi̱ canda̱a̱ ini tócó ndihi ña̱yivi ñuu sa̱há —na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","A̱nda̱ já na̱casáhá cáha̱n Jesús xi̱hín ndihi na̱ cán já cáchí a̱ já: —Cande̱hé ndo̱, na̱ cúú amigo i̱. Cúni̱ ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ a̱ cáyi̱hví toho ndó ña̱yivi, na̱ cuu cahní yiquí cu̱ñu ndó. Jáchi̱ ña̱ ja̱n cúú ndihi va ña̱ cája na ta a̱ cu̱ú caja na ni in ña̱ha xi̱hi̱n ínima̱ ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ta viti ná ca̱ha̱n i̱ xi̱hi̱n ndó yo já ndítahan ndusa nu̱ ndó cayi̱hví ndo̱: Ndítahan cayi̱hví ndó Ndióxi̱ jáchi̱ mé a̱ cán quéa̱ cuu caja ña̱ ná quivi ndó ta tá na̱ndihi cuu chica̱a̱n ínima̱ ndo̱ ini indayá. Mé a̱ cán quéa̱ ndítahan ndusa cayi̱hví ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ʼSa̱ xíni̱ va̱ha ndó ña̱ u̱hu̱n laa válí ya̱hvi rí i̱vi̱ jiu̱hún. Va̱tí núu ndiva̱ha sáhan ña̱yivi rí joo co̱ ndíndójó toho Ndióxi̱ sa̱ha̱ ri̱ jáchi̱ ndáá mé á ri̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Quia̱hva já íin ri sa̱ha̱ mé ndó nu̱ Ndióxi̱. Jáchi̱ ja̱nda̱ ijí ji̱ni̱ ndó ja̱n ndáhvi tá in tá in a nu̱ Ndióxi̱. A̱ cáyi̱hví toho ndó jáchi̱ ndiya̱hvi chága̱ ndóhó nu̱ Ndióxi̱ a̱ ju̱ú ga̱ cua̱há laa válí. ");
INSERT INTO mksNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ʼMé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó ña̱ ndá na̱ cáxi tu̱hun nu̱ú ña̱yivi ña̱ cua̱ha̱n na̱ cuéntá mí i̱ já quéa̱ cachi mí i̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi sa̱ha̱ ná ña̱ mé a̱ nda̱a̱ cúú ndusa na̱ cán cuéntá mí i̱. Já cachi i̱ xi̱hi̱n táto̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Joo ndá na̱ ná cachi xi̱hín ña̱yivi ña̱ co̱ xíni̱ toho na ye̱he̱ já quéa̱ ni ye̱he̱ a̱ ndícuni toho i̱ na̱ ña̱ cúú ná cuéntá mí i̱ nu̱ táto̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ʼTa ndá na̱ ná ca̱ha̱n núu sa̱há ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi, caja cáhnu ini i̱ sa̱ha̱ ná. Joo ndá na̱ ná ca̱ha̱n núu sa̱ha̱ ínima̱ yi̱i̱ Ndióxi̱, na̱ cán cúú na̱ a̱ cája cáhnu ini toho Ndióxi̱ sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ʼTá ná tiin na ndo̱hó ña̱ cañehe na ndo̱hó cu̱hu̱n ndó na̱hma̱ ndó nu̱ú na̱ sa̱cua̱ha̱ veñu̱hu á nu̱ú na̱ jutixia sa̱há i̱, a̱ ndícani toho ini ndó ña̱ ndá tu̱hun quéa̱ ca̱ha̱n ndó nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Jáchi̱ tá ná xi̱nu̱ co̱o hora ca̱ha̱n ndó nu̱ú na̱ cán, jána̱ha̱ ínima̱ yi̱i̱ Ndióxi̱ nu̱ ndo̱ ndá tu̱hun nducú ñehe ndó nu̱ú na̱ cán —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","In táhan da̱ ndáca̱a̱n tañu ña̱yivi cua̱ha̱ cán na̱ca̱ha̱n da̱ xi̱hi̱n Jesús já na̱cachi da já xi̱hi̱n á: —Maestro, ca̱ha̱n loho ndó xi̱hín ñani i̱ ña̱ ná cahnda java da ña̱ha ña̱ na̱jándacoo tátá nde̱ nu̱ú nde̱ tá na̱xi̱hi̱ na̱ —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já xi̱hi̱n dá: —A̱ ju̱ú juéxe̱ cúú ye̱he̱ já coo i̱ cahnda java i̱ ña̱ha ndó, va̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A̱nda̱ já na̱cachi tucu a já xi̱hín na̱ ndúu cán: —Cuni jo̱ho va̱ha ndó. Cuéntá coo ndó ña̱ ná a̱ ndiáva̱ na̱há ini ndó canduu cua̱há ña̱ha cuícá nu̱ ndo̱. Jáchi̱ a̱ ju̱ú sa̱ha̱ ña̱ ndúu cua̱há ña̱ha cuícá nu̱ ndó chí cuu catacu na̱há chága̱ ndó, va̱ha —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A̱nda̱ já na̱sacu a in quia̱hva nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Na̱sahi̱in in da̱ cui̱cá ta a̱ ju̱ú quia̱hva na̱sahnu va̱ha ña̱ha nu̱ ñúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A̱nda̱ já na̱casáhá mé da̱ cui̱cá cán ndícani ini da já na̱ca̱hán da̱ já: “Ndáchí taán toho í cua̱há na̱há ña̱ha na̱cana nu̱ yo̱ yóho jáchi̱ co̱ó ga̱ nu̱ú cañuhu a”, na̱ca̱hán da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A̱nda̱ já na̱ca̱hán tucu da já: “Ña̱ caja í quéa̱ ndicani ndihi í yáca̱ níi̱ ña̱ha í já cava̱ha í ña̱ náhnu chága̱. Ta cán taán yo̱ ndihi ña̱ na̱cana nu̱ yo̱ ta cán taán yo̱ tócó ndihi java ga̱ ña̱ cómí yo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A̱nda̱ já cachi i̱ já xi̱hi̱n mí i̱: Sa̱ cua̱há ndiva̱ha va ña̱ha na̱sacu va̱hún viti. Ta queta ña̱ cusún ti̱xi cua̱há ndiva̱ha cui̱a̱. Ta viti ja̱ndá ndiquehe ndée̱ cuití vún. Cuxu cuití vún. Coho cuití vún. Ta ja̱ndá caji̱i̱ cuití ini vún, já va cachi i̱ xi̱hi̱n mí i̱”, na̱ca̱hán da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Joo na̱ca̱ha̱n Ndióxi̱ já na̱cachi a já xi̱hi̱n dá: “Ta̱a quíhví, sa̱ mé ñuú viti quivi vún. Ta tócó ndihi ña̱ na̱sacu va̱hún ja̱n a̱ ju̱ú ña̱ cusún cúú á. Ndá na̱ cúú mé va na̱ cuxu ña̱ ja̱n”, na̱cachi Ndióxi̱ xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Quíhví ndiva̱ha cája ña̱yivi tá ndája tútú na̱ ña̱ha ñuyíví yóho joo co̱ ñúhu ini na sa̱ha̱ Ndióxi̱ ña̱ ná caja na ña̱ cúni̱ mé á. Sa̱há ña̱ cán quéa̱ cúú ná na̱ nda̱hví ndiva̱ha nu̱ mé á —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tá na̱ndihi já na̱ca̱ha̱n Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán já na̱cachi a já xi̱hi̱n ná: —A̱ ndícani toho ini ndó sa̱há ña̱ cuxu ndó catacu ndó ta ni sa̱ha̱ jáhma̱ candixi ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Jáchi̱ cáhnu chága̱ mé ndó a̱ ju̱ú ga̱ ña̱ xíxi ndó xi̱hín ña̱ ndíxi ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cande̱hé ndó rí naní tica̱cá ja̱n. Co̱ xútu rí ta ni co̱ jáquee rí. Ta ni co̱ó yáca̱ nu̱ táán rí ña̱ha rí. Joo sáhan va Ndióxi̱ ña̱ha cuxu rí ña̱ ná catacu rí va̱tí laa va cúú rí. Ta mé ndó ndiya̱hvi chága̱ ndó a̱ ju̱ú ga̱ laa ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A̱ ndícani toho ini ndó jáchi̱ co̱ó toho a̱ ñéhe̱ ndó ndícani ini ndó. Ni in túhún toho ndó a̱ cúu ndaja jícó ndo̱ mé ndó java metro chága̱ sa̱há ña̱ ndícani ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tá ta̱ ni loho ña̱ yóho a̱ cu̱ú caja ndó, ndía̱ ndóho ndó ndícani na̱há ini ndó caja ndó java ga̱ ña̱ha, dá já. ");
INSERT INTO mksNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ʼCande̱hé ndo̱ ndá quia̱hva ndató sáhnu ita. Co̱ cája chúun a ta ni co̱ cáva̱ha jáhma̱ á. Joo mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ñúchí chága̱ ita yóho na̱caja Ndióxi̱ a̱ ju̱ú ga̱ jáhma̱ va̱ha ndiva̱ha na̱sa̱ndixi rey Salomón sa̱nahá, da̱ na̱sahi̱in cua̱há ña̱ha cuícá. ");
INSERT INTO mksNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Cande̱hé ndó ndaja ndáá va̱ha Ndióxi̱ yu̱cu̱ ita va̱tí íin tóo a viti ta ita̱a̱n cáyi̱ a̱ jándihi sa̱há. Ta ndíya̱hvi chága̱ mé ndó a̱ ju̱ú ga̱ yu̱cu̱ ita. Joo co̱ cándúsa ndó ña̱ candaa mé á ndo̱hó. Ña̱ cán quéa̱ xíní ñúhú candeé ini ndó Ndióxi̱ ña̱ quia̱hva tá quia̱hva mé á jáhma̱ candixi ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ta a̱ ndícani ini ndó ndaja caja ndó ñe̱he̱ ndó ña̱ cuxu ndó xi̱hín ña̱ coho ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jáchi̱ ña̱yivi, na̱ co̱ xíni̱ íchi̱ cuéntá Ndióxi̱, na̱ cán cúú na̱ ndícani cua̱há ini sa̱ha̱ tócó ndihi ña̱ yóho. Joo cúú ndó cuéntá Ndióxi̱, mé a̱ cúú tátá ndo̱ ta xíni̱ va̱ha mé a̱ ña̱ ndíma̱ní nu̱ ndó catacu ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Joo ndítahan nu̱ ndó ndiquia̱hva ndó mé ndó ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ndo̱ já quia̱hva mé á nu̱ ndo̱ ña̱ ndíma̱ní nu̱ ndo̱ catacu ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ʼA̱ cáyi̱hví toho ndó jáchi̱ mé ndó cúú ndó tátu̱hun ndicachi válí ja̱ná i̱. Mé a̱ nda̱a̱ chá va cúú ndó joo cáji̱i̱ ini Ndióxi̱ ña̱ cómí a̱ cuéntá sa̱ha̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ji̱có ndó ña̱ cómí ndo̱ ta jasá ndó ña̱ha nu̱ú na̱ ndíma̱ní ña̱ha nu̱u̱. Jáchi̱ quia̱hva já ndaja tútú ndó ña̱ha va̱ha indiví nu̱ú cu̱hu̱n ndo̱. Jáchi̱ mé cán a̱ ndíhi sa̱há ña̱ va̱ha cómí ndo̱. Ta ni na̱ cui̱hná a̱ cu̱ú qui̱hvi na caja cuíhná ña̱ha ndó cán. Ta ni tiquijí a̱ cu̱ú jándihi rí sa̱há ña̱ha ndó cán. ");
INSERT INTO mksNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jáchi̱ nu̱ú na̱ndaja tútú ndo̱ ña̱ ndáya̱hvi nu̱ ndo̱, cán coo ri ínima̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ʼXíní ñúhú canduu tia̱hva ndó candati ndó ndá hora ndicó co̱o tucu u̱ quixi i̱ ndiquehe e̱ ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xíní ñúhú cacuu ndó tátu̱hun mozo tá ndáti tia̱hva da ndicó co̱o xitoho da, da̱ cua̱ha̱n víco̱ tánda̱ha̱. Ndáti tia̱hva da cuná da̱ yéhé nu̱ dá tá ná xi̱nu̱ co̱o da cani ndáha̱ dá yéhé. ");
INSERT INTO mksNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ta̱hví na̱cuu mozo tá co̱ quíji̱ da̱ ndúu da tá ná xi̱nu̱ co̱o xitoho da. Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ja̱nda̱ mé da̱ cúú xitoho da̱ cán ndiquehe ñahá da̱ ta já caco̱o da da̱ nu̱ mesa da̱ ta já chica̱a̱n da̱ co̱ho̱ cuxu mozo da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Co̱ó caja toho a ña̱ ná xi̱nu̱ co̱o xitoho da java ñuú táji̱ á tá sa̱ yati ti̱vi, ta̱hví na̱cuu mozo cán tá ndíta da ndúu da tá na̱xi̱nu̱ xitoho da nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Cande̱hé ndo̱ jáchi̱ xíní ñúhú canda̱a̱ ini ndó ña̱ yóho. Tá xíni̱ in da̱ta̱a ndá hora cúni̱ na̱ cui̱hná qui̱hvi na̱ vehe da já quéa̱ a̱ cúju̱ da̱ jáchi̱ ndáá va̱ha da vehe da já ná a̱ quíhvi na caja cuíhná na̱ ña̱ha vehe da. ");
INSERT INTO mksNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Quia̱hva já xínú ñúhú canduu tia̱hva ri ndóhó va jáchi̱ quixi tucu ye̱he̱, da̱ na̱chindahá Ndióxi̱ ndúu ña̱yivi mé qui̱vi̱ co̱ cáhán ndo̱ quixi i̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A̱nda̱ já na̱nda̱ca̱ tu̱hún Pedro Jesús já na̱cachi da já xi̱hi̱n á: —Á nu̱ú nde̱he̱ cuití na̱sacu ndó quia̱hva yóho á na̱sacu ndó ña̱ nu̱ú ndaja táhan ña̱yivi ndúu yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Ña̱ cáha̱n i̱ yóho cáha̱n i̱ ña̱ xi̱hín da̱ tácu̱ ini, da̱ cája va̱ha ndusa. Cúú á tátu̱hun in mozo tá jándacoo xitoho da chuun ndáha̱ dá ña̱ ná quia̱hva da cuxu na̱ java ga̱ cúú mozo xi̱hi̱n dá cán. A̱nda̱ já na̱quee mé xitoho da cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ta̱hví na̱cuu mé mozo cán tá xínu̱ co̱o xitoho da ta ndíñe̱he̱ dá da̱ cája da chuun ña̱ na̱cando̱o nu̱ dá caja da. ");
INSERT INTO mksNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ quia̱hva xitoho da̱ cán chuun nu̱ dá ña̱ ná cacomí da̱ cuéntá sa̱ha̱ tócó ndihi ña̱ha cómí xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Joo da̱ cúú mozo yóho tá ná casáhá da̱ ca̱hán da̱ ña̱ cayáncá ndiva̱ha xitoho da ndicó co̱o da ta sa̱há ña̱ cán quéa̱ cásáhá da̱ cája xíxi da xi̱hín java ga̱ na̱ cúú mozo xi̱hi̱n dá cán. Ta já cáa ga̱ da̱ cásáhá xíxi da ta xíhi da ta já xíni da. ");
INSERT INTO mksNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ta ndaja coo xi̱nu̱ co̱o xitoho mozo cán mé qui̱vi̱ co̱ cáhán da̱. A̱nda̱ jáví jándoho quini xitoho da̱ cán ini da jáchi̱ co̱ó na̱caja da ña̱ ndítahan caja da. Ta ndoho da̱ yóho tá quia̱hva ndóho tócó ndihi na̱ sáá ini, mé na̱ co̱ cája ña̱ sáhndá xitoho na nu̱ ná caja na. ");
INSERT INTO mksNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ʼTá ná canda̱a̱ ini mozo ña̱ cúni̱ xitoho da caja da joo co̱ íin tia̱hva da caja da ña̱ ta ni co̱ cúni̱ da̱ caja da ña̱ sáhndá xitoho da nu̱ dá, da̱ cán cúú da̱ ndoho ndiva̱ha ini. ");
INSERT INTO mksNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Joo tá íin in mozo ta co̱ cánda̱a̱ va̱ha ini da ndá quéa̱ cúni̱ xitoho da caja da ta ndaja coo cája da in ña̱ha ña̱ co̱ táhán ini xitoho da xi̱hi̱n já quéa̱ chá cuití va ndoho ini da. Tá ná caja Ndióxi̱ cua̱há ña̱ma̱ni̱ xi̱hín in ña̱yivi já quéa̱ ndítahan caja chúun cua̱ha̱ ná nu̱ mé á. Ta tá sa̱ cándeé ini ña̱yivi inga na já quéa̱ ndinuhu ña̱ma̱ni̱ náhnu chága̱ ca̱ca̱ na̱ cán ña̱ ná caja na xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ʼYe̱he̱ na̱quixi i̱ ñuyíví yóho cahnda java táhan i̱ ña̱yivi já ná na̱ha̱ na̱ cúni̱ cu̱hu̱n xoo mí i̱ xi̱hín na̱ co̱ cúni̱ cu̱hu̱n xoo i̱. Ta ña̱ yóho cúú á tátu̱hun na̱quixi i̱ chíca̱a̱n ñúhu̱ i̱ ñuyíví yóho. Ta cúni̱ ña̱ ná ndihi quíi̱ chuun na̱quixi caja i̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Va̱xi qui̱ví ndoho ndiva̱ha ini i̱ ta a̱ ju̱ú quia̱hva ndíhi ini i̱ ndáti xi̱nu̱ co̱o mé qui̱ví ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","A̱ cáhán toho ndó ña̱ na̱xi̱nu̱ i̱ ñuyíví yóho caja i̱ ña̱ ná coo va̱ha ini ña̱yivi. Ña̱ va̱xi ye̱he̱ caja i̱ quéa̱ ná cahnda java táhan na. ");
INSERT INTO mksNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jáchi̱ viti xi̱hi̱n chí nu̱u̱ cacuu a tátu̱hun canduu u̱hu̱n ña̱yivi in vehe joo a̱ cúní táhan na sa̱há ye̱he̱ jáchi̱ i̱vi̱ na̱ cacuu cuéntá mí i̱ ta u̱ni̱ na̱ candají ye̱he̱. Á tá co̱ó ta u̱ni̱ na̱ qui̱hvi̱ ini ye̱he̱ ta i̱vi̱ na̱ candají ri ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ta jári da̱ cúú tátá cani táhan da xi̱hín ja̱hyi da sa̱há ye̱he̱. Ta jári ndicui̱ta da̱ta̱a cani táhan da xi̱hi̱n tátá da̱ sa̱há ye̱he̱. Ta jári na̱ji̱hí cani táhan na xi̱hín ja̱hyi jíhí na̱ sa̱há ye̱he̱. Ta jári na̱ji̱hí cani táhan na xi̱hi̱n náná na̱ sa̱há ye̱he̱. Ta jári ndicui̱ta na̱ji̱hí cani táhan na xi̱hín sa̱nu na sa̱há ye̱he̱. Ta jári ndicui̱ta na̱ji̱hí cani táhan na xi̱hín xo̱jo na sa̱há ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A̱nda̱ já na̱cachi tucu Jesús já xi̱hín ña̱yivi: —Mé ndó tá xíní ndo̱ ndicui̱ta vi̱co̱ va̱xi a ñuu ndó chí xoo nu̱ quéta ca̱ndii já cáchí ndó ña̱ cuun ja̱vi̱ ta chí cúun ndusa dó. ");
INSERT INTO mksNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ta tá xíní ndo̱ va̱xi ta̱chi̱ chí xoo sur já cáchí ndo̱ ña̱ ihní ndiva̱ha coo ta chí ihní ndusa sáhi̱in. ");
INSERT INTO mksNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Co̱ cúú ndó tá quia̱hva ndáa ndó. Cánda̱a̱ va̱ha ini ndó ña̱ cúu ñuyíví ta cánda̱a̱ ini ndó ca̱ha̱n ndó ndá quéa̱ coo tá sánde̱hé ndó indiví. Joo co̱ cúni̱ ndó canda̱a̱ ini ndó ña̱ jána̱ha̱ i̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ʼNdáva̱ha co̱ tává va̱ha ndó cuéntá ndía̱ quéa̱ va̱ha ta ndía̱ quéa̱ a̱ váha. ");
INSERT INTO mksNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tá sácú ini na sa̱ha̱ ndó cu̱hu̱n ndó veca̱a ta ndáca táhan ndó xi̱hín na̱ cán cua̱ha̱n ndó nu̱ú na̱ jutixia, xíní ñúhú nducú ndó ndá quia̱hva ndique táhan máni̱ tucu ndó xi̱hi̱n ná nani xíca ndó íchi̱ cua̱ha̱n ndo̱. Já quéa̱ ná a̱ cáñehe na̱ cán ndo̱hó cu̱hu̱n ndó nu̱ juéxe̱ jáchi̱ da̱ cúú juéxe̱ cán ndiquia̱hva da ndo̱hó ndáha̱ policía ta policía cán chica̱a̱n da̱ ndo̱hó veca̱a. ");
INSERT INTO mksNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ndáca̱a̱n ndó veca̱a ja̱n chí a̱ cána ndó ja̱nda̱ quia̱hva ná cha̱hvi ndihi ndó ña̱ yícá ndo̱ nu̱ú da̱ cán já janí da̱ ndo̱hó —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mé tiempo já na̱xi̱nu̱ co̱o java na ndicani na nu̱ Jesús sa̱há ña̱ na̱sahní Pilato java da̱ta̱a estado Galilea nani jóco̱ da̱ nu̱ Ndióxi̱. Ña̱ cán quéa̱ cáchí na̱ ña̱ na̱catáhan ni̱í da̱ na̱xi̱hi̱ xi̱hín ni̱i̱ quíti̱, rí jóco̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Á cáhán ndo̱ ña̱ na̱xi̱hi̱ da̱ Galilea yóho sa̱há ña̱ íin chága̱ cua̱chi da a̱ ju̱ú ga̱ java ga̱ na̱ Galilea. ");
INSERT INTO mksNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A̱ ju̱ú a̱ já jáchi̱ quia̱hva já ndihi ri sa̱ha̱ ndóhó va tá ná a̱ jándacoo ndó cua̱chi cája ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sa̱nahá ndiva̱ha já na̱xi̱hi̱ sa̱hu̱n u̱ni̱ ta̱a jáchi̱ na̱ndicava in torre naní Siloé ja̱ta̱ ná. Á cáhán ndo̱ ña̱ na̱ndicava torre cán ja̱tá na̱ yóho jáchi̱ na̱sahi̱in chága̱ cua̱chi na a̱ ju̱ú ga̱ na̱ ñuu Jerusalén. Joo co̱ cúú á quia̱hva já. ");
INSERT INTO mksNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ quia̱hva já ndihi ri sa̱ha̱ ndóhó va tá ná a̱ jándacoo ndó cua̱chi cája ndó —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","A̱nda̱ já na̱sacu Jesús in quia̱hva nu̱ ná já na̱cachi a já xi̱hi̱n ná: —In da̱ta̱a na̱jánde̱e da in ti̱tó ñu̱hú nu̱ ñúhu̱ dá. Ta tá na̱ya̱ha tiempo já na̱sa̱ha̱n da̱ sánde̱hé da̱ do̱ ña̱ á cána ti̱tó ñu̱hú nu̱ do̱. Joo co̱ mé rí na̱ndiñe̱he̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A̱nda̱ já na̱cachi da já xi̱hín da̱ ndáá ñúhu̱ dá cán: “Cande̱hé, sa̱ na̱xi̱nu̱ u̱ni̱ cui̱a̱ já cuití quixi i̱ ndúcú u̱ ti̱tó ñu̱hú nu̱ yíto̱ yóho. Ta co̱ó ña̱ha cána nu̱ do̱. Va̱ha chága̱ ná cahndún do̱ jáchi̱ ndá chuun quéa̱ candichi uun dó cája táñu dó nu̱ ñúhu̱ i̱”, na̱cachi da xi̱hín da̱ ndáá ñúhu̱ dá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","A̱nda̱ já na̱cachi da̱ ndáá ñúhu̱ dá cán já xi̱hi̱n dá: “Quia̱hva ndó ña̱ma̱ní, xitoho i̱ ña̱ ná coo tóo ga̱ dó cui̱a̱ víti ná játayi i̱ ñúhu̱ sa̱ha̱ do̱ ta ná chica̱a̱n loho i̱ ta̱ta̱ sa̱ha̱ do̱. ");
INSERT INTO mksNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ta xi̱hín ña̱ yóho jonáá cana cui̱hi nu̱ do̱. Ta tá co̱ó ña̱ha cána nu̱ do̱ já cahnda ndó do̱ tá cúni̱ ndo̱”, na̱cachi mozo cán xi̱hín xitoho da —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ta ndaja coo in qui̱vi̱ ndiquehe ndée̱ ná já na̱sa̱ndaca̱a̱n Jesús veñu̱hu jána̱ha̱ tu̱hun Ndióxi̱ nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta mé ini veñu̱hu cán na̱sa̱ndaca̱a̱n in ñáñáha̱, ñá quíhvi̱ sa̱hu̱n u̱ni̱ cui̱a̱. In ínima̱ quini cúú rí na̱qui̱hvi ini ñá ta na̱caja rí ña̱ ná nditojo ñá ta chí ni loho a̱ cu̱ú jándica̱a̱ ñá mé ñá. ");
INSERT INTO mksNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tá na̱xini Jesús ña̱ já na̱cana mé á ña̱ já na̱cachi a já xi̱hi̱n ña̱: —Ndaja va̱ha i̱ yo̱hó viti —na̱cachi Jesús xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A̱nda̱ já na̱chojó a̱ ndáha̱ á ja̱ta̱ ña̱ chí mé hora já na̱ndica̱a̱ yiquí cu̱ñu ñá ta na̱casáhá ña̱ cája cáhnu ñá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Joo mé da̱ cúú sa̱cua̱ha̱ veñu̱hu cán na̱casáhá ndícue̱he̱ da̱ jáchi̱ na̱ndaja va̱ha Jesús ñáñáha̱ cán mé qui̱vi̱ ndíquehe ndée̱ ná. Já na̱casáhá cáchí da̱ cán já xi̱hín ña̱yivi ndúu ini veñu̱hu cán já: —Íin i̱ñu̱ qui̱vi̱ núná nu̱ yó cája chúun í ta tañu qui̱vi̱ já cuu quixi ndó catátá ndo̱ tá cúni̱ ndo̱. Joo a̱ quíxi ndó catátá ndo̱ qui̱vi̱ ndíquehe ndée̱ yó —na̱cachi da xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A̱nda̱ já na̱cachi Jesús já xi̱hín da̱ sa̱cua̱ha̱ veñu̱hu: —Co̱ cúú ndó tá quia̱hva ndáa ndó. Cája mé ndó chuun qui̱vi̱ ndíquehe ndée̱ yo̱ tá ndáxí ndo̱ ti̱ndi̱qui̱ á búrro̱ ja̱na̱ ndó sáha̱n ndó jácoho ndó ri̱ ticui̱í. ");
INSERT INTO mksNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ta viti cande̱hé ndo̱ ñáñáha̱ yóho. Cúú ñá ñá na̱quixi chi̱chi Abraham ta sa̱ íin sa̱hu̱n u̱ni̱ cui̱a̱ na̱quehe cue̱he̱ ña̱ na̱caja Satanás, mé tiñáhá sa̱cua̱ha̱. Ta mé ndó cáhán ndo̱ ña̱ a̱ váha toho na̱caja i̱ ña̱ na̱janí i̱ ñáñáha̱ yóho ndáha̱ cue̱he̱ ña̱ na̱ndoho ñá ti̱xi cua̱há cui̱a̱. Joo mé a̱ nda̱a̱ na̱nditahan nu̱ú i̱ janí i̱ ña̱ ndahá cue̱he̱ yóho co̱ó caja toho a cúú á qui̱vi̱ ndíquehe ndée̱ yo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tá na̱cachi Jesús ña̱ yóho chí a̱ ju̱ú quia̱hva na̱cacahan nu̱ú na̱ co̱ cúní Jesús cán. Joo tócó ndihi java ga̱ ña̱yivi cán cáji̱i̱ ndiva̱ha ini na jáchi̱ na̱xini na ña̱ cája Jesús ña̱ náhnu ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tá na̱ndihi já na̱cachi tucu Jesús já: —Ná ndicani i̱ nu̱ ndó ndaja íin nu̱ ndíquia̱hva ña̱yivi mé ná ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Cúú á tátu̱hun in ndiquí mostaza ña̱ chíhin in da̱ta̱a nu̱ ñúhu̱ dá. Ta mé ndíqui̱ loho yóho sáhnu a ja̱nda̱ quia̱hva ndúu a tátu̱hun in yitó cáhnu nu̱ xínu̱ co̱o laa chójó ri̱ táca̱ ri̱ nu̱ ndáha̱ do̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","A̱nda̱ já na̱cachi tucu Jesús já: —Ná ndicani i̱ nu̱ ndo̱ ndaja íin nu̱ ndíquia̱hva ña̱yivi mé ná ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cúú á tátu̱hun tá cáva̱ha na pan ta quée yusá na̱xa̱a̱ xi̱hi̱n harina. Cúú á tátu̱hun tá cáva táhan in ñáñáha̱ loho yusá na̱xa̱a̱ xi̱hín u̱ni̱ táhndá náhnu harina ña̱ ná jánañu a tócó ndihi mé yúsa̱ cán —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na̱ndiquehe Jesús íchi̱ cua̱ha̱n chí ñuu Jerusalén ta ndijáá ñuu náhnu xi̱hín ñuu válí nu̱ yáha jána̱ha̱ mé á tu̱hun Ndióxi̱ cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ta ndaja coo na̱nda̱ca̱ tu̱hún in da Jesús já na̱cachi da já xi̱hi̱n á: —Xitoho í, á chá cuití va ña̱yivi cacuu na̱ ca̱cu ndaa ínima̱ cu̱hu̱n chí indiví —na̱cachi da xi̱hi̱n Jesús. A̱nda̱ já na̱nducú ñehe Jesús tu̱hun já cáchí a̱ já xi̱hi̱n dá: ");
INSERT INTO mksNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Cúú á tátu̱hun íin in yéhé táhán loho nu̱ú ndi̱hvi ña̱yivi indiví. Ña̱ cán quéa̱ xíní ñúhú ndó ndi̱hi̱ ini ndó ndi̱hvi ndó chí yéhé loho cán jáchi̱ cua̱há ndiva̱ha ña̱yivi ndítihvi na ña̱ qui̱hvi na joo a̱ cúu qui̱hvi na. ");
INSERT INTO mksNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jáchi̱ tá quia̱hva íin in xitoho vehe quia̱hva já íin Ndióxi̱. Jáchi̱ tá ná ndico̱o da̱ cúú xitoho vehe cán chícaji tuun da vi̱ti̱ yéhé vehe da já xínu̱ co̱o ndó cándichi ndó ja̱ta̱ véhe cáni ndáha̱ ndó yéhé já cachi ndó já: “Á ndúyu ndó, xitoho i̱. Á a̱ cája ndó ña̱ma̱ni̱ cuná loho ndó yéhé ná qui̱hvi nde̱”, cachi ndó xi̱hi̱n dá. Ta já nducú ñehe da̱ cán tu̱hun nu̱ ndó cachi da já xi̱hi̱n ndo̱: “Cuáhán ndo̱ jáchi̱ co̱ xíni̱ toho i̱ ndo̱hó.” ");
INSERT INTO mksNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ta já casáhá mé ndó cachi ndó já xi̱hi̱n dá: “Cua̱há tañu sa̱ na̱xixi nde̱ ta na̱xihi nde̱ xi̱hi̱n ndo̱. Ta níí cáyé ñuu nde̱ na̱xi̱ca nuu ndó na̱jána̱ha̱ ndó ña̱yivi.” ");
INSERT INTO mksNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A̱nda̱ já nducú ñehe da̱ cán tu̱hun nu̱ ndo̱ já cachi da já xi̱hi̱n ndo̱: “Sa̱ na̱ca̱ha̱n vi̱ xi̱hi̱n ndo̱ ña̱ co̱ xíni̱ toho i̱ ndá na̱ cúú ndóhó. Caxoo ndihi ndó nu̱ú i̱ jáchi̱ cúú ndó ña̱yivi cája ndinuhu ña̱ núu.” ");
INSERT INTO mksNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ta cán ndusa quéa̱ cuacu cóhó ndo̱ ta casáhá cahñá nu̱hu̱ ndó xi̱hín ña̱ co̱jo̱ ini ndó. Jáchi̱ cán cuni ndó Abraham xi̱hi̱n Isaac xi̱hi̱n Jacob xi̱hi̱n tócó ndihi na̱ profeta. Cuni ndó ña̱ ndúu na indiví cán ta cómí Ndióxi̱ cuéntá sa̱ha̱ ná. Ta a̱ ju̱ú quia̱hva ta̱hnda̱ ini ndó jáchi̱ tavá xóo Ndióxi̱ ndo̱hó ña̱ ná a̱ ndíhvi ndó nu̱ ndúu na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Jáchi̱ xi̱nu̱ ña̱yivi ndúu ndijáá ñuyíví nu̱ Ndióxi̱ ta ndaca nduu na nu̱ú cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ta mé qui̱vi̱ cán já cuni ndó java ña̱yivi, na̱ co̱ó sa̱ha̱ mé nu̱ú ña̱yivi ta nduu na na̱ íin chága̱ sa̱ha̱ nu̱ Ndióxi̱. Ta cán cuni ndó java na̱ ndíñehe jícó mé viti ta a̱ cóo toho sa̱ha̱ ná nu̱ Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mé qui̱vi̱ já na̱xi̱nu̱ co̱o java na̱ fariseo nu̱ Jesús já na̱cachi na já xi̱hi̱n á: —Cuáhán inga ñuu coún jáchi̱ sácú ini Herodes cahní da̱ yo̱hó —na̱cachi na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Cuáhán ndó ca̱ha̱n ndó xi̱hín da̱ cátóó jándahvi ña̱yivi ja̱n ta cachi ndó xi̱hi̱n dá ña̱ tává i̱ ínima̱ quini ñúhu ini ña̱yivi ta ndája va̱ha i̱ na̱ quíhvi̱ ta caja tá caja i̱ ña̱ yóho ja̱nda̱ quia̱hva ná xi̱nu̱ co̱o qui̱ví jándihi i̱ chuun yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Joo sa̱ mé Jerusalén ja̱n quivi vi̱ jáchi̱ ja̱n cúú nu̱ sáhní na̱ profeta. Ta viti ndítahan caca nuu yií vi̱ íchi̱ xíca i̱ cua̱ha̱n i̱ yóho —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","A̱nda̱ já na̱cachi tucu Jesús já: —Ndáhví na̱há na̱cuu ndó, na̱ ndúu ñuu Jerusalén. Jáchi̱ sáhní ndó na̱ profeta. Ta ndícui̱ta ndó cáni ndó na̱ na̱chindahá Ndióxi̱ nu̱ ndó xi̱hín yu̱u̱. Cua̱há ndiva̱ha tañu cúni̱ jánditaca ndihi i̱ ndo̱hó joo co̱ó na̱xeen ndó. Cúú á tá quia̱hva cája nduxú tá játaca rí ja̱hyi válí ri̱ ti̱xi ndi̱xi̱ ri̱. ");
INSERT INTO mksNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ta viti cuni jo̱ho ndó ña̱ cáha̱n i̱ xi̱hi̱n ndo̱. Va̱xi qui̱ví ja̱ni̱ ndáha̱ mé vehe ndó cando̱o a. Ta mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ a̱ cúní ga̱ ndó ye̱he̱ ja̱nda̱ quia̱hva ná xi̱nu̱ co̱o qui̱ví cachi ndó: “Cáhnu na̱há ná cacuu da̱ va̱xi cuéntá Ndióxi̱, xitoho í” —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ta ndaja coo in qui̱vi̱ ndíquehe ndée̱ ná já na̱sa̱ha̱n Jesús na̱xixi a vehe in da̱ cúú sa̱cua̱ha̱ nu̱ú na̱ fariseo. Ta java ga̱ na̱ fariseo cán na̱casáhá nání na̱ Jesús ndúu na. ");
INSERT INTO mksNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ta mé yati nu̱ Jesús cán na̱sahi̱in in da̱ta̱a, da̱ na̱qui̱hvi cuiñu yiquí cu̱ñu. ");
INSERT INTO mksNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo já na̱cachi a já xi̱hi̱n ná: —Á núná nu̱ yó ndaja va̱ha í in da̱ quíhvi̱ mé qui̱vi̱ ndíquehe ndée̱ yo̱, á co̱ núná toho nu̱ yó cája í ña̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Joo táji̱ na̱sahi̱in yuhú na̱ cán. A̱nda̱ já na̱ndaja va̱ha Jesús da̱ quíhvi̱ cán já na̱cachi a xi̱hi̱n dá ña̱ ná quee da cu̱hu̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ta já na̱cachi a já xi̱hín na̱ fariseo cán: —Mé ndó tá ndicava búrro̱ á ti̱ndi̱qui̱ ja̱na̱ ndo̱ ini in táhvi̱ chí i̱vi̱ la̱á tavá ndó ri̱. Ta co̱ó caja toho a á cúú á qui̱vi̱ ndíquehe ndée̱ yo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Joo co̱ó na̱cuu nducú ñehe na tu̱hun nu̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","A̱nda̱ já na̱xini Jesús ña̱ ja̱ndá joho ndáca̱xi na na̱taca cán nu̱ú va̱ha caco̱o na já na̱jána̱ha̱ nu̱ ná ndía̱ va̱ha chága̱ ndítahan caja na. Já na̱cachi a já: ");
INSERT INTO mksNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Tá ná cana in na yo̱hó cu̱hu̱n in víco̱ tánda̱ha̱, a̱ ndúcú tohún caco̱ún nu̱ sáco̱o na̱ náhnu. Jáchi̱ cuu xi̱nu̱ co̱o in da̱ íin chága̱ sa̱ha̱ a̱ ju̱ú ga̱ yóhó. ");
INSERT INTO mksNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ta da̱ na̱cana yo̱hó víco̱ cán cuu cachi da já xu̱hu̱n: “Quia̱hva nu̱ íin co̱ún ja̱n ná caco̱o da̱ yóho”, cachi da xu̱hu̱n. A̱nda̱ já cacahan nu̱u̱n já queún cu̱hu̱n caco̱ún ja̱nda̱ nu̱ ndíhí. ");
INSERT INTO mksNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ña̱ ndítahan cajún quéa̱ caco̱ún ja̱nda̱ nu̱ ndíhí. Já quéa̱ tá ná xi̱nu̱ da̱ na̱cana yo̱hó nu̱ íún já cachi da já xu̱hu̱n: “Amigo, cuáhán ya̱ha nu̱ ndúu na̱ náhnu coún.” Xi̱hín ña̱ yóho ndindita jícún nu̱ú na̱ ndúu coo nu̱ mesa xíxi xu̱hu̱n cán. ");
INSERT INTO mksNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jáchi̱ ndá na̱ cája cáhnu mé, na̱ cán cacuu na̱ na̱nuu ndáha joho. Ta na̱ co̱ ndíñehe jícó mé, na̱ cán cúú na̱ ndicáhnu —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","A̱nda̱ já na̱ca̱ha̱n Jesús xi̱hín mé da̱ na̱cana ñahá cán já na̱cachi a já xi̱hi̱n dá: —Tá ná cava̱ha cua̱hún ña̱ cajáhñu na á ña̱ cajíni na, a̱ cána tohún na̱ cúú amigún ja̱n ni na̱ cúú ñanún ja̱n ta ni a̱ cána tohún na̱ cúú táhún ta ni a̱ cánún na̱ cui̱cá ndúu yati xu̱hu̱n ja̱n. Jáchi̱ tá ná caja na víco̱ cana ri na̱ ja̱n va yo̱hó ta xi̱hín ña̱ ja̱n táhnda̱ cuéntá sa̱há ña̱ma̱ni̱ na̱cajún xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ña̱ ndítahan cajún tá ná cava̱hún in víco̱ quéa̱ canún na̱ nda̱hví ta canún na̱ rénco̱ ta canún na̱ cua̱á. ");
INSERT INTO mksNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ta já caji̱i̱ ínún jáchi̱ na̱ cán a̱ cúu toho caja na cha̱hvi na ña̱ma̱ni̱ na̱cajún xi̱hi̱n ná ñuyíví yóho. Joo va̱xi qui̱ví tá ná nditacu ña̱yivi na̱sañehe ínima̱ va̱ha ñuyíví yóho já cha̱hvi Ndióxi̱ ña̱ma̱ni̱ na̱cajún ja̱n —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tá na̱xini jo̱ho in táhan da̱ íin coo nu̱ mesa xi̱hi̱n Jesús cán ña̱ yóho já na̱cachi da já xi̱hi̱n á: —Ta̱hví na̱cuu na̱ ná ñe̱he̱ táhvi̱ cu̱hu̱n indiví ña̱ ná cacomí Ndióxi̱ cuéntá sa̱ha̱ ná —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A̱nda̱ já na̱sacu Jesús in quia̱hva nu̱ dá já na̱cachi a já xi̱hi̱n dá: —In da̱ta̱a na̱cava̱ha da in víco̱ cáhnu ta na̱cana cua̱há ndiva̱ha da ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ta tá sa̱ na̱xi̱nu̱ co̱o hora cajíni na já na̱sahnda da chuun nu̱ mozo da̱ ña̱ ná cu̱hu̱n da̱ cana da na̱ ña̱ quixi na ndaca nduu na nu̱ mesa. Já na̱cachi da já xi̱hi̱n ná: “Naha quíi̱ ndo̱ jáchi̱ sa̱ na̱candíví ndihi ña̱ha”, na̱cachi mozo xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Joo tócó ndihi na̱ cán na̱casáhá na̱ cáha̱n na̱ ña̱ a̱ cúu toho cu̱hu̱n na̱. Ta in táhan da̱ cán na̱casáhá cáchí da̱ já xi̱hi̱n mé mozo cán já: “Ja̱cá na̱xeen uun i̱ in ñúhu̱ ta xíní ñúhú cu̱hu̱n i̱ cande̱hé e̱ nu̱ á. Cáhnu coo inún”, na̱cachi da xi̱hi̱n mozo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ta inga da na̱cachi da xi̱hi̱n mé mozo cán já: “Ja̱cá na̱xeen e̱ u̱hu̱n yúntá ti̱ndi̱qui̱ ta viti cúni̱ cu̱hu̱n i̱ coto ndojó i̱ ri̱. Cáhnu coo inún”, na̱cachi da xi̱hi̱n mozo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ta inga tucu da na̱casáhá cáchí da̱ já: “Ja̱cá na̱tanda̱ha̱ vi̱ sa̱há ña̱ cán quéa̱ a̱ cúu toho cu̱hu̱n i̱”, na̱cachi da xi̱hi̱n mozo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tá na̱ndicó co̱o mozo cán nu̱ú xitoho da já na̱ndicani ndihi da nu̱ú xitoho da ña̱ na̱cachi na̱ cán xi̱hi̱n dá. A̱nda̱ já na̱casáhá na̱ndicue̱he̱ xitoho da̱ cán já na̱cachi tucu da já xi̱hi̱n mozo da̱: “Ta viti cuáhán camún ndijáá cáyé ñuu játacún na̱ nda̱hví xi̱hín na̱ rénco̱ xi̱hín na̱ cua̱á. Cañehún na̱ quisún yóho ná cuxu na”, na̱cachi xitoho da̱ cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tá na̱ndihi já na̱sa̱ha̱n mozo cán já na̱caja da ña̱ na̱cachi xitoho da xi̱hi̱n dá. Ta tá na̱ndicó co̱o da já na̱cachi da já xi̱hín xitoho da: “Sa̱ na̱caja i̱ tá íin na̱sahnda ndó nu̱ú i̱. Joo yójó tá yójó nu̱ú cuu canduu chága̱ na̱”, na̱cachi da xi̱hín xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","A̱nda̱ já na̱cachi xitoho da já xi̱hi̱n dá: “Cuáhán ndijáá cáyé xi̱hi̱n ndijáá íchi̱ ta xi̱hín ña̱ ndúsa̱ játacún na̱ ña̱ ná quixi na já ná chutú vehe e̱. ");
INSERT INTO mksNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Jáchi̱ ni in túhún toho táhan na̱ na̱cana i̱ quixi vehe e̱ nu̱ cuítí cán, a̱ quíxi ga̱ na̱ cajíni na ña̱ na̱catáhan vehe e̱”, na̱cachi da xi̱hi̱n mozo da̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cua̱há ña̱yivi ndíco̱ na̱ ja̱ta̱ Jesús cua̱ha̱n na̱. A̱nda̱ já na̱ndicó co̱o játá nu̱u̱ Jesús já na̱cachi a já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ndá na̱ cúni̱ jácuaha xi̱hín i̱ xíní ñúhú qui̱hvi̱ ini chága̱ na̱ ye̱he̱ a̱ ju̱ú ga̱ tátá na̱ xi̱hi̱n náná na̱. Ta xíní ñúhú qui̱hvi̱ ini chága̱ na̱ ye̱he̱ a̱ ju̱ú ga̱ ñájíhí na̱ á ja̱hyi na á ñani na á quia̱hva na. Ta xíní ñúhú qui̱hvi̱ ini chága̱ na̱ ye̱he̱ a̱ ju̱ú ga̱ mé ná. ");
INSERT INTO mksNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ta ndá na̱ co̱ ndíco̱ ye̱he̱ sa̱há ña̱ yíhví na̱ quivi na, mé a̱ nda̱a̱ co̱ó sa̱ha̱ toho na cacuu na cuéntá ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tá cúni̱ ndó cava̱ha ndó in vehe jícó ña̱ cája ndó quéa̱ tavá va̱ha ndó cuéntá ña̱ á queta jiu̱hún ndo̱ á a̱ quéta já ná jáxi̱nu̱ ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jáchi̱ tá ná a̱ tává jihna ndó cuéntá ta casáhá ndó cava̱ha ndó vehe ndó joo tá na̱ndihi co̱ quéta ga̱ jiu̱hún ndó ña̱ ná jáxi̱nu̱ co̱o ndó ña̱ já quéa̱ cacahan nu̱u̱ ndo̱ jáchi̱ casáhá ña̱yivi cua̱cu̱ ndaa na ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Já cachi na já xi̱hi̱n ndo̱: “Ta̱a ja̱n na̱casáhá da̱ cáva̱ha da vehe da joo co̱ó na̱cuu jáxi̱nu̱ dá ña̱”, já cachi na cua̱cu̱ ndaa na ndo̱hó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A̱nda̱ já na̱cachi tucu Jesús já: —Tá ná cani táhan in rey, da̱ cómí u̱xu̱ mil soldado xi̱hín inga rey, da̱ cómí o̱co̱ mil soldado já quéa̱ xíní ñúhú ndicani va̱ha ini da ña̱ á cuu quee va̱ha da xi̱hín da̱ inga rey cán tá ná qui̱hvi táhan da xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta tá na̱tavá va̱ha da cuéntá ña̱ a̱ cu̱ú quee va̱ha da xi̱hín rey, da̱ cómí o̱co̱ mil soldado cán ja̱nda̱ xícá va íin da já chindahá da̱ java na̱ta̱a ña̱ ná cu̱hu̱n da̱ ca̱ca̱ da̱ ña̱ma̱ni̱ nu̱ú inga rey cán ña̱ ná ndi̱co va tondóhó. ");
INSERT INTO mksNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Quia̱hva já íin ri xi̱hi̱n ndóhó va. Ndá ndóhó, na̱ co̱ cúni̱ jándacoo tócó ndihi ña̱ cómí ndo̱ sa̱há ye̱he̱ já quéa̱ co̱ó sa̱ha̱ toho ndó cacuu ndó cuéntá ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","A̱nda̱ já na̱cachi tucu Jesús já: —Ña̱ va̱ha ndiva̱ha cúú ñi̱i̱ yívi na joo co̱ó chuun toho a tá co̱ óhva̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mé ñi̱i̱, ña̱ co̱ óhva̱ ga̱ ja̱n ni co̱ váha ña̱ jácana í nu̱ ñúhu̱ yo̱ jáchi̱ co̱ ndáhá toho ñúhu̱ yo̱ cája ña̱. Ña̱ cája na xi̱hín ñi̱i̱ ja̱n quéa̱ sátá va na ña̱. Na̱ íin jo̱ho, ná cuni jo̱ho na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Cua̱há na̱ játaca jiu̱hún cuéntá impuesto xi̱hín cua̱há na̱ cája cua̱chi na̱casáhá na̱ cáyati na nu̱ íin Jesús jáchi̱ cúni̱ na̱ cuni jo̱ho na nu̱ cáha̱n mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sa̱há ña̱ cán quéa̱ na̱casáhá na̱ fariseo xi̱hín na̱ jána̱ha̱ ley Moisés cáha̱n núu na sa̱há. Já cáchí xi̱hi̱n táhan na já: —Ta̱a ja̱n ndíquehe va̱ha da ña̱yivi cája cua̱chi ta xíxi da xi̱hi̱n ná —cáchí xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","A̱nda̱ já na̱sacu Jesús in quia̱hva nu̱ ná já na̱cachi a já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Mé ndó tá cómí ndo̱ in ciento ndicachi ta tá in cuití ndíñúhú in ndicachi ja̱na̱ ndo̱ ña̱ cája ndó quéa̱ jándacoo ndó co̱mi̱ jíco sa̱hu̱n co̱mi̱ rí cán yúcu̱ ta já quée ndó cua̱ha̱n ndó ndinducú ndó rí na̱ndiñúhú cán ja̱nda̱ quia̱hva ndíñe̱he̱ ndó ri̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ta tá ndiñe̱he̱ ndó ri̱ já cávatá ndo̱ já quéhe ndó ri̱ chínúu ndó ri̱ sa̱há ji̱qui̱ ndo̱ va̱xi ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ta tá xínu̱ co̱o ndó vehe ndó já játaca ndó ñani táhan ndo̱ xi̱hín na̱ xíní táhan xi̱hi̱n ndó. Já casáhá cáchí ndó já xi̱hi̱n ná: “Xíní ñúhú caji̱i̱ íní ndó xi̱hín i̱ jáchi̱ cáji̱i̱ íní i̱ sa̱há ña̱ na̱ndiñe̱hé e̱ ndicachi ja̱ná i̱, rí na̱ndiñúhú cán”, cáchí ndó xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ quia̱hva já ta ja̱nda̱ chága̱ ví cáji̱i̱ ini na̱ ndúu indiví tá jándacoo in ña̱yivi cua̱chi cája na a̱ ju̱ú ga̱ sa̱há co̱mi̱ jícó sa̱hu̱n co̱mi̱ ña̱yivi, na̱ cája tá cája ña̱ va̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ʼTa viti ná ca̱ha̱n tucu u̱ inga quia̱hva xi̱hi̱n ndo̱. In ñáñáha̱ na̱sahi̱in u̱xu̱ jiu̱hún ca̱a ña̱ yahvi ndiva̱ha nu̱ ña̱. Ta tá ndíñúhú in táhan ña̱ cán já ndícahmi ñá ñúhu̱ ta tíhví ñá vehe ñá jáchi̱ ndíhi ini ñá ndínducú ñá ña̱ ta vií vií ndínducú ñá ña̱ ja̱nda̱ quia̱hva ná ndiñe̱he̱ ñá ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ta tá sa̱ na̱ndiñe̱he̱ ñá ña̱ já játaca ñá ñani táhan ñá xi̱hín na̱ xíní táhan xi̱hi̱n ña̱ já cásáhá cáchí ña̱ já xi̱hi̱n ná: “Xíní ñúhú caji̱i̱ íní ndó xi̱hín i̱ jáchi̱ cáji̱i̱ ini i̱ sa̱há ña̱ na̱ndiñe̱hé e̱ jiu̱hún i̱, ña̱ na̱ndiñúhú”, cachi ñá cán —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A̱nda̱ já na̱cachi tucu Jesús já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó quia̱hva já cáji̱i̱ íní táto̱ Ndióxi̱ ndúu indiví tá jándacoo in ña̱yivi cua̱chi cája na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","A̱nda̱ já na̱sacu Jesús in quia̱hva nu̱ ná já na̱cachi a já: —In da̱ta̱a na̱sahi̱in i̱vi̱ ja̱hyi ta̱a da. ");
INSERT INTO mksNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ta da̱ loho chá cán na̱cachi da já xi̱hi̱n tátá da̱: “Ta̱á i̱, á a̱ váha ná ndicahnda va ndó ña̱ha cómí ndo̱ já ná ndiquehe e̱ ña̱ cáni nu̱ú i̱ ndiquehe e̱”, na̱cachi da̱ cán xi̱hi̱n tátá da̱. A̱nda̱ já na̱sahnda java tátá da̱ ña̱ha, in táhndá na̱quehe mé dá ta in táhndá na̱quehe ñani da. ");
INSERT INTO mksNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ta chá va qui̱ví na̱ya̱ha já na̱ji̱có ndihi da̱ loho chá cán ña̱ha ña̱ na̱ñe̱he̱ dá nu̱ tátá da̱ ta xi̱hín jiu̱hún na̱cana cán na̱quee da cua̱ha̱n xícá ndiva̱ha da chí ñuu tóho̱. Ta cán na̱casáhá da̱ játi̱ví ndaja na̱cuu joho da jiu̱hún da̱ ña̱ cája da ña̱ núu. ");
INSERT INTO mksNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ta tá sa̱ na̱játi̱ví ndihi da jiu̱hún da̱ já na̱xi̱nu̱ in ta̱ma̱ ndeé ndiva̱ha mé nu̱ íin da cán. Já na̱casáhá na̱xi̱nu̱ jo̱co nu̱ dá ta na̱casáhá cuíco da. ");
INSERT INTO mksNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","A̱nda̱ já na̱quee da na̱sa̱ha̱n da̱ ndúcú da̱ chuun caja da nu̱ú in da̱ta̱a mé nu̱ íin da cán. Ta na̱sa̱ha̱n da̱ cán chuun nu̱ dá ña̱ ná cu̱hu̱n da̱ candaa da cóchí ja̱ná da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ta tá cúni̱ coo ndiava já cúni̱ coo ña̱ sáxí cóchí cán. Ta chí caxí da̱ ña̱ cán ja̱nda̱ quia̱hva chutú ti̱xi da cúni̱ da̱. Joo co̱ sáhan na ña̱ nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A̱nda̱ já na̱casáhá da̱ ndícani ini da já na̱ca̱hán da̱ já: “Cua̱ha̱ chá mozo táhan na̱ cája chúun nu̱ tátá i̱ chí yójó joho ña̱ha xíxáhan na ta yóho xíhi̱ va ye̱he̱ jo̱co íin i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ña̱ caja i̱ quéa̱ ndicó co̱o tucu u̱ nu̱ íin tátá i̱ ta já cachi i̱ já xi̱hi̱n ná: Tátá ma̱ní i̱, na̱caja i̱ cua̱chi nu̱ Ndióxi̱ ta na̱caja ri̱ cua̱chi nu̱ ndóhó va. ");
INSERT INTO mksNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ta chí co̱ó sa̱ha̱ mí vi̱ cacuu u̱ ja̱hyi ndó sa̱há ña̱ na̱caja i̱. Ndiquehe ndó ye̱he̱ ná cacuu u̱ tátu̱hun in mozo va ndó, já cachi i̱ cu̱hu̱n i̱ nu̱ tátá i̱”, na̱ca̱hán da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A̱nda̱ já na̱quehe da íchi̱ cuanúhu̱ dá vehe tátá da̱. ʼTa ja̱nda̱ xícá va va̱xi da já na̱xini tátá da̱ mé dá já na̱ndicuni a da̱. Ta na̱ta̱hvi̱ ini a sa̱ha̱ dá. Já xínu a na̱sa̱ha̱n ñe̱hé a̱ da̱ já na̱numi a da̱ ta na̱tatí yúhu̱ á sa̱jóho da. ");
INSERT INTO mksNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","A̱nda̱ já na̱cachi da já xi̱hi̱n tátá da̱: “Tátá ma̱ní i̱, na̱caja i̱ cua̱chi nu̱ Ndióxi̱ ta na̱caja ri̱ cua̱chi nu̱ ndóhó va. Ta chí co̱ó sa̱ha̱ mí i̱ cacuu u̱ ja̱hyi ndó”, na̱cachi da xi̱hi̱n tátá da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ta ndaja coo tátá da̱ na̱casáhá cáha̱n xi̱hín java ga̱ mozo já na̱cachi a já xi̱hi̱n ná: “Cama ndó ta tavá ndó jáhma̱, ña̱ va̱ha ta jácandixi ndó ja̱hyi i̱. Ta chica̱a̱n ndó in jéhe̱ nducu ndáha̱ dá. Ta chica̱a̱n ndó ndu̱sa̱ sa̱ha̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ta cañehe ndó chélo̱, rí ndató na̱ndaha ja̱n já ná quivi rí cuxú jáchi̱ caja i̱ in víco̱ viti. ");
INSERT INTO mksNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Jáchi̱ ja̱hyi i̱ yóho tá na̱quee da cua̱ha̱n da̱ na̱ca̱hán i̱ na̱xi̱hi̱ da̱. Joo viti na̱ndicó co̱o da nu̱ú i̱. Sa̱há ña̱ cán cúú á tátu̱hun na̱nditacu tucu da. Na̱sacuu da tátu̱hun da̱ na̱ndiñúhú joo viti na̱ndee va da”, na̱cachi tátá da̱ cán. A̱nda̱ já na̱casáhá na̱ cája na víco̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ʼJoo ndaja coo da̱ cúú ñani da, da̱ sa̱cua̱ha̱ chága̱ cán, ndáca̱a̱n da̱ cája chúun da yúcu̱ va. Ta tá na̱ndicó co̱o da já na̱xini jo̱ho da tíví musica ta cáxita sáhá na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A̱nda̱ já na̱cana da in da̱ cája chúun cán já na̱nda̱ca̱ tu̱hún ñahá da̱ ndía̱ cúu. ");
INSERT INTO mksNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A̱nda̱ já na̱cachi da̱ cája chúun cán xi̱hi̱n dá: “Cúu víco̱ jáchi̱ na̱ndicó co̱o ñanún. Ta na̱sahnda tátún chuun ña̱ ná quivi chélo̱, rí ndató na̱ndaha cán jáchi̱ cáji̱i̱ íní na̱ ña̱ na̱casa̱a̱ va̱ha ñanún ta co̱ó a̱ na̱ndoho da”, na̱cachi da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Joo ndaja coo da̱ sa̱cua̱ha̱ cán na̱joo da ta chí co̱ó na̱xeen da qui̱hvi da nu̱ cúu víco̱ cán. Sa̱há ña̱ cán na̱queta tátá da̱ ja̱ta̱ véhe já cáha̱n nda̱hví a̱ xi̱hi̱n dá ña̱ ná qui̱hvi da. ");
INSERT INTO mksNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A̱nda̱ já na̱casáhá cáchí da̱ já xi̱hi̱n tátá da̱: “Ta̱á i̱, sa̱ cánda̱a̱ va̱ha ini ndó ña̱ sa̱ cua̱há ndiva̱ha cui̱a̱ cája chúun i̱ nu̱ ndo̱ ta cája i̱ tócó ndihi ña̱ sáhndá ndó nu̱ú i̱ caja i̱. Joo ni in túhún toho tañu co̱ó na̱sa̱ha̱n ndó ni in tijúhu̱ loho nu̱ú i̱ ña̱ ná caja i̱ in víco̱ loho cuxu u̱ xi̱hín na̱ xíní táhan xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Joo viti na̱sahní ndó chélo̱, rí ndató na̱ndaha ja̱n, ña̱ cája ndó víco̱ jáchi̱ na̱casa̱a̱ ñani i̱ ja̱n. Ta mé da̱ ja̱n na̱xi̱ca nuu da na̱játi̱ví ndaja na̱cuu da jiu̱hún ndo̱ xi̱hín na̱ji̱hí xíca ji̱i̱”, na̱cachi da̱ cán xi̱hi̱n tátá da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A̱nda̱ já na̱cachi tátá da̱ já xi̱hi̱n dá: “Cande̱hé ja̱hyi a. Mé a̱ nda̱a̱ níí tiempo íún xi̱hín i̱. Ta ña̱ha mé vún cúú ndihi ña̱ íin nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Joo mé a̱ nda̱a̱ ndítahan nu̱ yo̱ caja í víco̱ ta caji̱i̱ íní yo̱ viti jáchi̱ na̱ndicó co̱o ñanún, mé da̱ na̱ca̱hán yo̱ ña̱ na̱xi̱hi̱. Ta viti na̱casa̱a̱ da̱ cúú á tátu̱hun na̱nditacu tucu da. Na̱sacuu a tátu̱hun na̱ndiñúhú da̱ joo na̱ndiñe̱he̱ yó da̱ viti”, na̱cachi a cán xi̱hín ja̱hyi a —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A̱nda̱ já na̱sacu tucu Jesús inga quia̱hva nu̱ú na̱ xíca tuun xi̱hi̱n á. Já na̱cachi a já xi̱hi̱n ná: —Na̱sahi̱in in ta̱a cui̱cá ta na̱sahi̱in in da̱ ndáá ña̱ha da. Joo java ña̱yivi na̱sa̱ha̱n na̱ chica̱a̱n na̱ cua̱chi ja̱ta̱ dá nu̱ú xitoho da ña̱ játi̱ví ndaja na̱cuu joho da ña̱ cúú ña̱ha xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A̱nda̱ já na̱cana xitoho da mé dá já na̱cachi da já xi̱hi̱n dá: “Joho cáchí ña̱yivi na̱quixi na cáha̱n na̱ sa̱hu̱n sa̱há ña̱ cán quéa̱ táxi i̱ cuéntá nu̱u̱n ña̱ ndicanún nu̱ú i̱ ndaja cáa chuun na̱cajún jáchi̱ ndindaa chuun ndáhu̱n ta a̱ cácuu ga̱ún da̱ ndáá ña̱ha i̱”, na̱cachi xitoho da̱ cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","A̱nda̱ já na̱casáhá da̱ cúú mozo cán ndícani ini da já na̱ca̱hán da̱ já: “Ndía̱ caja i̱ viti jáchi̱ ndindaa va chuun ndahá i̱ caja xitoho i̱. Ta co̱ ndée̱ toho i̱ caja i̱ chuun ve̱e. Ta tá ná caca nuu i̱ cuati i̱ ta cacahan va nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Sa̱ xíni̱ vi̱ ndía̱ caja i̱ já ná ndiquehe va̱ha ña̱yivi ye̱he̱ vehe na tá ná ndindaa chuun ndahá i̱ caja xitoho i̱”, na̱ca̱hán da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","A̱nda̱ já na̱cana da tá in tá in na̱ yícá nu̱ú xitoho da. Ta tá na̱xi̱nu̱ da̱ nu̱ cuítí cán nu̱ dá já na̱nda̱ca̱ tu̱hún ñahá da̱ já na̱cachi da já xi̱hi̱n dá: “Ndaja yícún nu̱ú xitoho i̱”, na̱cachi da xi̱hín da̱ yícá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Já na̱nducú ñehe da̱ cán tu̱hun já na̱cachi da já: “In ciento lata sítí yícá i̱ nu̱ú xitohún”, na̱cachi da̱ cán xi̱hi̱n dá. A̱nda̱ já na̱cachi da̱ cúú mozo cán já xi̱hi̱n dá: “Cande̱hé nu̱ tutu yóho ndáa̱ ndaja yícún nu̱ú xitoho i̱. Joo caco̱o quíi̱ ja̱n ta ca̱hyí ña̱ yícún i̱vi̱ jico u̱xu̱ lata sítí cuití va”, na̱cachi mozo cán xi̱hín da̱ yícá nu̱ú xitoho da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tá na̱ndihi já na̱nda̱ca̱ tu̱hún da̱ inga da̱ yícá nu̱ú xitoho da já na̱cachi da já xi̱hi̱n dá: “Ta yóhó ri ndaja yícún nu̱ú xitoho i̱”, na̱cachi da. A̱nda̱ já na̱nducú ñehe da̱ yícá cán tu̱hun nu̱ dá já na̱cachi da já xi̱hi̱n dá: “In ciento maquila trigo yícá i̱ nu̱ dá”, na̱cachi da̱ cán. A̱nda̱ já na̱cachi tucu da̱ ndáá ña̱ha cán já: “Cande̱hé yóho ndáa̱ ndaja yícún. Joo caco̱o quíi̱ ja̱n ta ca̱hyí ña̱ yícún co̱mi̱ jico maquila trigo cuití va”, na̱cachi da̱ ndáá ña̱ha cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tá na̱ndihi já na̱cachi xitoho da xi̱hi̱n dá ña̱ mé a̱ nda̱a̱ cúú dá in da̱ ndíchí ji̱ni̱ jáchi̱ xi̱hín ña̱ na̱caja da̱ cán cando̱o va̱ha da nu̱ú ña̱yivi yícá nu̱ú xitoho da va̱tí co̱ó na̱caja va̱ha da nu̱ú xitoho da —na̱cachi Jesús xi̱hín quia̱hva sácú a̱ nu̱ú na̱ xíca tuun xi̱hi̱n á cán. A̱nda̱ já na̱cachi tucu a já xi̱hi̱n ná: —Ña̱yivi cátóó canduu va̱ha ñuyíví yóho xíni̱ va̱ha chága̱ na̱ ndaja cája na cando̱o va̱ha nu̱ táhan na a̱ ju̱ú ga̱ na̱ sa̱ xíca íchi̱ cuéntá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ʼÑa̱yivi ndúu ñuyíví yóho cája na ña̱ núu xi̱hín ña̱ cómí na̱. Joo ndóhó, xíní ñúhú caja ndó ndinuhu ña̱ va̱ha xi̱hín ña̱ cómí ndo̱. Jáchi̱ ña̱ ja̱n quéa̱ cúni̱ Ndióxi̱ caja ndó. Jáchi̱ tá ná xi̱nu̱ qui̱ví quivi ndó já ndiquehe va̱ha na ndo̱hó indiví sa̱há ña̱ na̱caja va̱ha ndó xi̱hín ña̱ na̱sa̱comí ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ʼTa ndá da̱ xi̱hín ndinuhu ini ndáá da̱ ña̱ha da va̱tí loho cúú á quia̱hva já caja ri da candaa da ña̱ha da tá cua̱ha̱ cúú á. Joo ndá da̱ co̱ ndáá da̱ ña̱ha da xi̱hín ndinuhu ini da va̱tí loho cúú á quia̱hva já a̱ cándaa va̱ha da ña̱ha da tá cua̱ha̱ cúú á. ");
INSERT INTO mksNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ta tá co̱ ndáá va̱ha ndó ña̱ha ñuyíví yóho já quéa̱ ni Ndióxi̱ a̱ quiáhva toho a ña̱ha cuéntá indiví nu̱ ndo̱ jáchi̱ a̱ cátia̱hva ndó candaa ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ta tá co̱ tiáhva ndó candaa ndó ña̱ na̱sa̱ha̱n tóo inga na nu̱ ndo̱, náha̱ ña̱ a̱ cúu ndiquia̱hva na ña̱ cacuu ña̱ha mé ndó nu̱ ndo̱ jáchi̱ a̱ cátia̱hva ndó candaa ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ʼNi in túhún toho mozo a̱ cúu caja chúun nu̱ú i̱vi̱ xitoho. Jáchi̱ candají da̱ in xitoho da ta inga xitoho da qui̱hvi̱ ini chága̱ da̱. Á tá co̱ó ta caja ndíví va̱ha da chuun nu̱ú in xitoho da ta inga da̱ cán a̱ cája chúun va̱ha da nu̱u̱. Ta quia̱hva já íin ri xi̱hi̱n ndóhó va jáchi̱ a̱ cu̱ú caja cáhnu ndó Ndióxi̱ tá chínúu ndó ínima̱ ndó ja̱tá jiu̱hún ndo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ta nu̱ cáha̱n Jesús cán ndíta na̱ fariseo, na̱ cátóó ndiva̱ha jiu̱hún táa jo̱ho na nu̱ cáha̱n mé á. Ta na̱casáhá na̱ sácu̱ ndaa na Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Cája ndó tátu̱hun cúú ndó ña̱yivi va̱ha nu̱ú ña̱yivi joo sa̱ xíni̱ va̱ha Ndióxi̱ ínima̱ ndo̱. Ndá ña̱ cáhvi ini ña̱yivi ndáya̱hvi chága̱, ña̱ ja̱n quéa̱ co̱ ndáya̱hvi nu̱ Ndióxi̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","A̱nda̱ já na̱cachi tucu Jesús já: —Ja̱nda̱ tá cáma̱ní xi̱nu̱ Juan, da̱ na̱caja ndúta̱ ña̱yivi já na̱sahi̱in ley Moisés xi̱hín ña̱ na̱jána̱ha̱ na̱ profeta sa̱nahá. Joo viti ndijáá ndícui̱ta nuu tu̱hun Ndióxi̱ cua̱ha̱n ña̱ va̱xi qui̱vi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi. Ta ndá na̱ cúni̱ ndiquia̱hva na mé ná ndáha̱ Ndióxi̱ ndítahan nu̱ ná ndi̱hi ini na ndi̱hvi na íchi̱ cuéntá mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ʼJoo ja̱nda̱ quia̱hva ná naá sa̱ha̱ ñuyíví xi̱hín indiví ndítahan nu̱ú ña̱yivi caja na tócó ndihi ña̱ sáhndá ley. Jáchi̱ ja̱nda̱ va̱ha chága̱ íin a ná ndihi sa̱há ñuyíví xi̱hín indiví a̱ ju̱ú ga̱ ña̱ ná ndihi sa̱há in túhún tu̱hun ndáca̱a̱n nu̱ ley Moisés —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","A̱nda̱ já na̱cachi tucu Jesús já: —Tá jándacoo in da̱ta̱a ñájíhí da̱ ta tánda̱ha̱ dá xi̱hín inga ñáñáha̱ já quéa̱ cája da cua̱chi nu̱ Ndióxi̱. Ta ndá da̱ tánda̱ha̱ xi̱hín in ñáñáha̱, ñá na̱jándacoo yíi̱, cája ri da̱ cán va cua̱chi nu̱ Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ndícani Jesús nu̱ú ña̱yivi já na̱cachi a já xi̱hi̱n ná: —Na̱sahi̱in in da̱ cui̱cá ta a̱ ju̱ú quia̱hva va̱ha jáhma̱ na̱sandixi da ta chí a̱ ju̱ú quia̱hva ñúchí na̱caja cutú da̱ vehe da jáchi̱ ndijáá níí qui̱vi̱ na̱sacaja da víco̱ nu̱ xíxáhan cuícá ndiva̱ha da. ");
INSERT INTO mksNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta na̱sahi̱in in da̱ nda̱hví naní Lázaro. Quíhvi̱ da̱ ta ndóho da cue̱he̱ ndi̱hi táhyi̱. Ta ndáhví cáa da̱ íin coo da nu̱ ñúhu̱ yuyéhé da̱ cui̱cá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ta mé da̱ nda̱hví yóho cúni̱ da̱ jáchutú da̱ ti̱xi da xi̱hín ña̱ ndícava nu̱ mesa da̱ cui̱cá cán. Ta xi̱hín ña̱ ndeé quíhvi̱ da̱ nda̱hví yóho chí ja̱nda̱ ti̱na xínu̱ co̱o rí yácó ndaa rí nu̱ú ndi̱hi na̱nana níi̱ da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ta ndaja coo in qui̱ví na̱xi̱hi̱ da̱ nda̱hví cán. Já na̱xi̱nu̱ táto̱ Ndióxi̱ já ñéhe na da̱ cua̱ha̱n da̱ coo da indiví nu̱ íin Abraham. Ta jári da̱ cui̱cá cán va na̱xi̱hi̱ da̱ ta na̱sa̱ha̱n na̱ na̱jándu̱xu̱ ná da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ta nani ndóho ini da̱ cui̱cá cán ndáca̱a̱n da̱ indayá já na̱ndiñehe da nu̱u̱ dá. Já na̱xini xícá da̱ Abraham. Ta na̱xini da íin Lázaro xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A̱nda̱ já na̱casáhá da̱ cui̱cá cán cáyuhú da̱ já na̱cachi da já: “Tátá Abraham, candáhví loho ini ndó ye̱he̱. Ta ná chindahá ndó Lázaro ná quixi da yóho quia̱hva loho da ticui̱í jándaxi loho da yaá i̱ jáchi̱ ndóho ndiva̱ha ini i̱ indayá yóho nu̱ cáyi̱ ñuhú i̱ta̱.” ");
INSERT INTO mksNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","A̱nda̱ já na̱cachi Abraham já xi̱hi̱n dá: “Ja̱hyi a, xíní ñúhú ndicu̱hu̱n inún ña̱ va̱ha ndiva̱ha na̱sahi̱ún ñuyíví. Ta Lázaro yóho ndáhví ndiva̱ha na̱ndoho da ñuyíví sa̱há ña̱ cán quéa̱ co̱ ndóho ga̱ ini da yóho viti nani ndóho inún ja̱n viti. ");
INSERT INTO mksNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ta a̱ cúu sa̱a̱ toho Lázaro nu̱ íún ja̱n jáchi̱ íin in táhvi̱ cúná ndiva̱ha tañu nde̱he̱, na̱ ndúu xoo chóho xi̱hi̱n ndóhó, na̱ ndúu xoo chí ja̱n. Sa̱há ña̱ cán quéa̱ a̱ cu̱ú cu̱hu̱n na̱ ndúu xoo chóho chí ja̱n ta ni na̱ ndúu xoo chí ja̱n a̱ cu̱ú quixi xoo chóho”, na̱cachi Abraham xi̱hín da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","A̱nda̱ já na̱cachi da̱ cui̱cá cán já xi̱hi̱n Abraham: “Tá ta̱ já ta caja loho ndó ña̱ma̱ni̱, tátá Abraham ña̱ ná chindahá loho ndó Lázaro ña̱ ná cu̱hu̱n da̱ vehe tátá i̱ ");
INSERT INTO mksNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ná ca̱ha̱n loho da xi̱hín na̱ vehe e̱. Jáchi̱ ndúu u̱hu̱n ñani i̱ ta co̱ cúni̱ i̱ ña̱ ná quixi na̱ cán yóho ndoho ini na tá quia̱hva ndóho ini i̱ viti”, na̱cachi da̱ cui̱cá cán xi̱hi̱n Abraham. ");
INSERT INTO mksNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Joo na̱nducú ñehe Abraham tu̱hun nu̱ dá já na̱cachi da já xi̱hi̱n dá: “Sa̱ íin va ley na̱ca̱hyí Moisés xi̱hín ña̱ na̱ca̱hyí na̱ profeta nu̱ú na̱ cán. Va̱ha va ná caja na ña̱ cáchí a̱”, na̱cachi Abraham xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A̱nda̱ já na̱nducú ñehe da̱ cui̱cá cán tu̱hun nu̱ Abraham já na̱cachi da já xi̱hi̱n dá: “Mé a̱ nda̱a̱ quéa̱ cáha̱n ndó ja̱n, tátá Abraham. Joo va̱ha chága̱ ná chindahá ndó in táhan na̱ sa̱ na̱xi̱hi̱ já ná ca̱ha̱n na̱ xi̱hín ñani i̱ já ná jándacoo cama na cua̱chi cája na”, na̱cachi da xi̱hín Abraham. ");
INSERT INTO mksNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A̱nda̱ já na̱cachi tucu Abraham já xi̱hi̱n dá: “Tá co̱ cúni̱ ñanún caja da ña̱ na̱ca̱hyí Moisés xi̱hín ña̱ na̱ca̱hyí na̱ profeta quia̱hva já a̱ cándúsa toho ri na ndiquehe va̱ha na in ndi̱i tá ná nditacu a cu̱hu̱n a̱ ca̱ha̱n xi̱hín ñanún”, na̱cachi Abraham xi̱hín da̱ cui̱cá cán —na̱cachi Jesús xi̱hín ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Níí tiempo quixi ña̱ha ña̱ cája ña̱ ná ndicají ini ña̱yivi caja na cua̱chi. Joo ndáhví na̱cuu na tá ná jándicava na inga na nu̱ú cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ja̱nda̱ va̱ha chága̱ ná candi̱co̱ in yu̱ú yo̱jó ji̱co̱ ná ta ná ndihi sa̱ha̱ ná ca̱há tañu̱hú a̱ ju̱ú ga̱ ña̱ jándicava na na̱ nda̱hví yóho nu̱ú cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cuéntá coo ndó xi̱hín ña̱ cája ndó. ʼTá ná caja ñani táhan ndó cua̱chi nu̱ ndo̱, jána̱ni ndó da̱. Ta tá ná ta̱hvi̱ ini da sa̱há cua̱chi na̱caja da, caja cáhnu ini ndó sa̱ha̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ta va̱tí u̱sa̱ táhndá ná caja da cua̱chi nu̱ ndo̱ in qui̱vi̱ ta já va̱xi tucu da nu̱ ndo̱ u̱sa̱ táhndá ta já cásáhá cáchí tucu da xi̱hi̱n ndo̱ ña̱ a̱ ndícó co̱o ga̱ da̱ caja da ña̱ já ndítahan nu̱ ndó caja cáhnu ini ndó sa̱ha̱ dá —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tá na̱ndihi já na̱cachi na̱ xíca tuun xi̱hi̱n Jesús cán já xi̱hi̱n á: —Vá ná caja ndó ña̱ ná candeé chága̱ ini nde̱ ndo̱hó —na̱cachi na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Tá ná candeé ini ndó ye̱he̱ va̱tí cúú á tátu̱hun in ndiquí mostaza cuu cachi ndó xi̱hín in yíto̱ cáhnu ña̱ ná cu̱hu̱n dó candichi dó ini tañu̱hú ta chí já ndusa coo. ");
INSERT INTO mksNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ʼTá íin in mozo ndo̱ ta chindahá ndó da̱ yúcu̱ ña̱ ná tiin da ya̱ta̱ á candaa da quíti̱ ja̱na̱ ndo̱ ta tá ná ndicó co̱o da̱ cán já ama ná cachi ndó xi̱hi̱n dá ña̱ ná ya̱ha da caco̱o da nu̱ mesa cuxu da. ");
INSERT INTO mksNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ña̱ caja ndó quéa̱ cachi ndó já xi̱hi̱n dá: “Jácatáhan ña̱ha ná cajíni i̱ ta caja ndíví ná cuxu u̱. Ta tá sa̱ na̱ndihi na̱xixi i̱ já cuxu mún tá cúnu̱n”, ña̱ ja̱n va quéa̱ ca̱ha̱n ndó xi̱hi̱n mozo ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ta ama ná ndiquia̱hva ña̱yivi ndixa̱hvi nu̱ mozo na̱ tá na̱ndihi na̱caja da in chuun na̱sahnda na nu̱ dá caja da. ");
INSERT INTO mksNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ta quia̱hva já ndítahan coo ri xi̱hi̱n ndóhó va. Tá ná ndihi na̱caja ndó tócó ndihi chuun na̱sahnda Ndióxi̱ nu̱ ndo̱ já ndítahan nu̱ ndó cachi ndó já: “Mé nde̱ cúú nde̱ mozo co̱ó sa̱ha̱ ta na̱caja cuití va nde̱ chuun ndítahan nu̱ú nde̱ caja nde̱”, já ndítahan cachi ndó —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ta nani xíca Jesús cua̱ha̱n chí ñuu Jerusalén já na̱ya̱ha chí xoo nu̱ íin lindero na̱ Samaria xi̱hín na̱ Galilea. ");
INSERT INTO mksNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ta tá na̱xi̱nu̱ co̱o a in ñuu loho já na̱queta u̱xu̱ ta̱a ndóho cue̱he̱ táhyi̱ nu̱ á joo na̱sacui̱ta xícá da̱ nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Já na̱casáhá cáyuhú da̱ nu̱ Jesús já na̱cachi da já xi̱hi̱n á: —Jesús, maestro, candáhví loho ini ndó nde̱he̱ —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tá na̱xini Jesús ndíhu̱xu̱ da̱ cán já na̱cachi a já xi̱hi̱n dá: —Cuáhán ndó na̱ha̱ ndó mé ndó nu̱ú na̱ cúú ju̱tu̱ —na̱cachi Jesús xi̱hi̱n dá. Ta nani xíca ndihi da cua̱ha̱n da̱ na̱ndivií yiquí cu̱ñu da ta na̱ndindaa cue̱he̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ta ndaja coo in táhan ndíhu̱xu̱ da̱ cán tá na̱xini da ña̱ na̱ndivií yiquí cu̱ñu da já na̱cavatá ndiva̱ha da. Ta na̱casáhá da̱ cája cáhnu da Ndióxi̱ cáyuhú cóhó da̱ já na̱ndicó co̱o da nu̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Já na̱caxítí da̱ nu̱ á ja̱nda̱ quia̱hva na̱xi̱nu̱ taan da nu̱ ñúhu̱ jáchi̱ ndíquia̱hva ndiva̱ha da ndixa̱hvi nu̱ á. Ta mé da̱ta̱a yóho cúú dá da̱ Samaria. ");
INSERT INTO mksNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —U̱xu̱ cúú da̱ na̱ndiva̱ha na̱caja i̱. Joo i̱n da̱ cán co̱ó na̱xeen toho da ndicó co̱o da ndiquia̱hva da ndixa̱hvi nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","In túhún da̱ tóho̱ yóho cuití va cúú da̱ na̱ndicó co̱o ndíquia̱hva ndixa̱hvi nu̱ Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A̱nda̱ já na̱cachi Jesús já xi̱hín da̱ta̱a cán: —Candichi ta cuáhán. Na̱ndiva̱hún jáchi̱ na̱candúsún ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ta ndaja coo na̱ fariseo na̱casáhá na̱ ndáca̱ tu̱hún na̱ Jesús ña̱ ndá ama casáhá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi. A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —A̱ cúu cuni ndó nu̱ú cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Co̱ó toho ña̱yivi cachi xi̱hi̱n ndo̱: “Yóho íin a”, á “Cáa íin a.” Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ sa̱ na̱xi̱nu̱ va qui̱vi̱ ta viti tañu mé ndó na̱casáhá cómí Ndióxi̱ cuéntá sa̱há ña̱yivi —na̱cachi Jesús xi̱hín na̱ fariseo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A̱nda̱ já na̱casáhá cáchí a̱ já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Va̱xi qui̱ví tá cúni̱ ndó cuni ndó ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi va̱tí ná coo i̱ in qui̱vi̱ cuití va. Joo a̱ cóo toho i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta queta ña̱yivi cachi xi̱hi̱n ndo̱: “Yóho íin da.” Á tá co̱ó ta cachi na xi̱hi̱n ndo̱: “Cán íin da”, cachi na xi̱hi̱n ndo̱. Joo coto a̱ cúhu̱n ndó cande̱hé ndo̱. A̱ cándi̱co̱ ndó ja̱ta̱ ná cu̱hu̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jáchi̱ tá ná xi̱nu̱ ndusa qui̱ví quixi ye̱he̱ já cuni ndó quixi i̱ tá quia̱hva quixi tasa. Ta ndijáá ña̱yivi cuni na ndá quia̱hva ndiye̱he̱ a̱ tá xoo tá xoo. Quia̱hva já coo tá ná xi̱nu̱ qui̱ví quixi ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Joo jihna ñúhú ndítahan nu̱ú i̱ ndoho ndiva̱ha ini i̱. Ta a̱ ju̱ú quia̱hva candají ña̱yivi ndúu tiempo viti ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tá quia̱hva na̱sahi̱in tiempo tá na̱sahi̱in Noé sa̱nahá quia̱hva já coo ri tá ná xi̱nu̱ co̱o qui̱ví quixi ri ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jáchi̱ mé tiempo cán xíxi na ta xíhi na ta cája na vicó tánda̱ha̱ ja̱nda̱ quia̱hva na̱xi̱nu̱ qui̱ví na̱qui̱hvi Noé ini barco cáhnu. Já na̱xi̱nu̱ ja̱vi̱ quíni ndiva̱ha ta na̱ja̱hvi ñuyíví xi̱hín ticui̱í já na̱xi̱hi̱ ndihi ña̱yivi na̱sa̱nduu tiempo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ta quia̱hva já na̱sahi̱in ri mé tiempo tá na̱satacu Lot sa̱nahá. Ja̱ndá joho cáxixi ña̱yivi ta ja̱ndá joho cáxihi na ta ja̱ndá joho xéen na ña̱ha ta ja̱ndá joho jícó na̱ ña̱ha ndúu na ja̱ndá joho cáxutu na ta ja̱ndá joho cáva̱ha na vehe na. ");
INSERT INTO mksNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ta tá na̱xi̱nu̱ qui̱ví na̱jándacoo Lot ñuu Sodoma cán já na̱queta da cua̱ha̱n da̱ xi̱hín na̱ vehe da já na̱cu̱yu ñúhu̱ xi̱hín yu̱u̱ cáyi̱ chí indiví ta já na̱xi̱hi̱ ndihi ña̱yivi na̱sa̱nduu cán. ");
INSERT INTO mksNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Quia̱hva já caja ña̱yivi mé tiempo já jáchi̱ ndi̱hi ini na catacu na ja̱nda̱ quia̱hva xi̱nu̱ co̱o qui̱ví quixi tucu ye̱he̱ ñuyíví yóho, mé da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ʼTa ndá ndó, na̱ ndúu ja̱ta̱ véhe ndó mé qui̱vi̱ já a̱ quíhvi ndó ini vehe ndó ña̱ tavá ndó ña̱ha cómí ndo̱. Ta ndá ndó, na̱ ndúu yúcu̱ a̱ ndíxi ndó vehe ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ndítahan ndicu̱hu̱n ini ndó ndaja na̱ndoho ñá cúú ñájíhí Lot jáchi̱ na̱ca̱va̱ játá nu̱u̱ ña̱ sánde̱hé ñá ña̱ na̱jándacoo ñá ta já na̱ndihi sa̱ha̱ mé ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ndá na̱ chínúu ínima̱ ja̱tá ña̱ha ñuyíví yóho, na̱ cán cúú na̱ ndihi sa̱ha̱. Joo ndá na̱ ndíquia̱hva mé ndáha̱ mí i̱ ta íin tia̱hva na quivi na sa̱há i̱, na̱ cán cúú na̱ catacu a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ʼMé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ná xi̱nu̱ qui̱vi̱ cán já ndiquehe e̱ na̱ cúú cuéntá mí i̱. Cacuu a tátu̱hun tá ndúu i̱vi̱ na̱ quíji̱ na̱ in xi̱to ta in na ndiquehe e̱ ta inga na cando̱o va sa̱há ña̱ co̱ó na̱candúsa na mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ta tá ndúu i̱vi̱ na̱ ndíco na ta in ñá ndindita cu̱hu̱n xi̱hín i̱ ta inga ñá cando̱o va. ");
INSERT INTO mksNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ta tá ndúu i̱vi̱ da̱ta̱a yúcu̱ xútu da ta in da ndindita cu̱hu̱n xi̱hín i̱ ta inga da cando̱o va —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tá na̱xini jo̱ho na̱ xíca tuun xi̱hi̱n Jesús ña̱ yóho já na̱nda̱ca̱ tu̱hún na̱ mé á já na̱cachi na já xi̱hi̱n á: —Ta ndachi ya̱ha tócó ndihi ña̱ cáchí ndó xi̱hín nde̱ yóho, xitoho. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Tá quia̱hva cája ti̱yo̱có tá tácá ri̱ nu̱ cándúhu̱ in quíti̱, rí na̱xi̱hi̱ quia̱hva já caja ña̱yivi taca na nu̱ú i̱ tá ná xi̱nu̱ qui̱ví quixi i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na̱sacu Jesús in quia̱hva nu̱ ná jáchi̱ xi̱hín quia̱hva yóho cúni̱ a̱ jána̱ha̱ nu̱ ná ña̱ níí tiempo xíní ñúhú ca̱ca̱ ta̱hví na̱ nu̱ Ndióxi̱ ta co̱ ndítahan cuitá ini na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Já na̱cachi a já xi̱hi̱n ná: —In ñuu na̱sahi̱in in juéxe̱ ta co̱ó na̱sahi̱in toní ñúhú da̱ xi̱hi̱n Ndióxi̱ ta ni co̱ sáhní da̱ mé dá cúú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ta mé ñuu cán na̱sahi̱in in ñá cuáa̱n. Ta ndijáá níí qui̱vi̱ sáha̱n ñá cáha̱n nda̱hví ña̱ xi̱hi̱n mé juéxe̱ cán ña̱ ná caja vií da̱ sa̱há ña̱ sa̱há in na̱ co̱ cúní táhan xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ta sa̱ cua̱há qui̱vi̱ ta já cúu va ñá sáha̱n ñá nu̱ dá ta co̱ cúni̱ da̱ caja vií da̱ sa̱ha̱ ña̱. Joo tá na̱ndihi já na̱ca̱hán da̱ já: “Va̱tí co̱ó toní ñúhú i̱ xi̱hi̱n Ndióxi̱ ta ni co̱ sáhní i̱ mí i̱ cúú ña̱yivi ");
INSERT INTO mksNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","joo já caja tá caja vií i̱ sa̱ha̱ ñá cuáa̱n yóho jáchi̱ jándi̱hi ndiva̱ha ñá ye̱he̱ sa̱há ña̱ cán ndiquehe e̱ sa̱ha̱ ña̱ já ná a̱ quíxi ga̱ ñá jándi̱hi ñá ini i̱”, na̱ca̱hán da̱ cúú juéxe̱ cán —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ ndúu cán já: —Ña̱ yóho quéa̱ na̱cachi juéxe̱, da̱ co̱ ñéhe ínima̱ va̱ha cán. ");
INSERT INTO mksNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Joo cáhnu ga̱ ví ña̱ha caja Ndióxi̱ tá ná ndiquehe a sa̱há na̱ cúú cuéntá mé á tá xíca̱ ta̱hví na̱ nu̱ á ñuú ta ndiví. Jáchi̱ ndáti tia̱hva chíndeé a̱ na̱ cúú cuéntá mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ i̱vi̱ la̱á ndiquehe mé á sa̱ha̱ ná. Joo in ña̱ha cúni̱ nda̱ca̱ tu̱hún i̱ ndo̱hó. Á ndiñe̱hé e̱ ña̱yivi cándeé ini na ye̱he̱ tá ná xi̱nu̱ qui̱ví quixi tucu u̱ ñuyíví yóho —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A̱nda̱ já na̱sacu Jesús inga quia̱hva nu̱ú java ña̱yivi, na̱ ndíñehe jícó mé, na̱ cáhán ña̱ mé cuití na̱ cája ña̱ va̱ha. Ta já na̱casáhá cáchí a̱ já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—In tañu i̱vi̱ ta̱a na̱sa̱ha̱n da̱ veñu̱hu ca̱ca̱ ta̱hví da̱ nu̱ Ndióxi̱. In táhan da̱ cán cúú fariseo ta inga da̱ cán cúú da̱ játaca jiu̱hún cuéntá impuesto. ");
INSERT INTO mksNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ta nani xíca̱ ta̱hví da̱ fariseo cán nu̱ Ndióxi̱ cándichi da já cáchí da̱ já: “Tátá Ndióxi̱, ndíquia̱hva i̱ ndixa̱hvi nu̱ ndo̱ jáchi̱ co̱ cája i̱ tá quia̱hva cája java ga̱ ña̱yivi. Jáchi̱ java na cája cuíhná na̱ ta quini cája na ta cátóó na̱ coo na xi̱hi̱n ñájíhí ñani táhan na. Ta jári ndíquia̱hva i̱ ndixa̱hvi nu̱ ndo̱ jáchi̱ co̱ cája i̱ tá quia̱hva cája da̱ játaca jiu̱hún cuéntá impuesto yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jáchi̱ ye̱he̱ i̱vi̱ tañu xíjuhun i̱ in in semana ta tá cháhvi na ye̱he̱ sa̱há chuun cája i̱ já cáva̱ha i̱ u̱xu̱ táhndá ta já jóco̱ i̱ in táhndá nu̱ mé ndó”, cáchí da̱ fariseo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Joo da̱ játaca jiu̱hún cuéntá impuesto cán xícá xícá na̱sandichi da ta chí ni nu̱u̱ dá co̱ cúni̱ da̱ ndiñehe da indiví sa̱há ña̱ cáhán da̱ ña̱ co̱ó sa̱ha̱ dá caja da ña̱. Ña̱ cája da quéa̱ cáni da yi̱ca ndícá da̱ ta já cáchí da̱ já xíca̱ ta̱hví da̱ nu̱ Ndióxi̱: “Tátá Ndióxi̱, candáhví ini ndó ye̱he̱ jáchi̱ cúú u̱ in da̱ cája cua̱chi”, cáchí da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ na̱caja cáhnu ini Ndióxi̱ sa̱há da̱ játaca jiu̱hún cuéntá impuesto já cuanúhu̱ va da joo co̱ó na̱caja cáhnu ini a sa̱há da̱ fariseo cán. Na̱caja cáhnu ini Ndióxi̱ sa̱há da̱ játaca jiu̱hún cuéntá impuesto jáchi̱ ndá na̱ ndíñehe jícó mé jánuu ndáha̱ Ndióxi̱ na̱. Joo ndá na̱ jánuu mé nu̱ Ndióxi̱ já jándiñehe jícó mé á na̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ta cua̱há ña̱yivi ñéhe na na̱ va̱lí na̱xi̱nu̱ co̱o na nu̱ Jesús já ná cani ndaa ndáha̱ á na̱. Joo tá na̱xini na̱ xíca tuun xi̱hi̱n Jesús cán ña̱ yóho, na̱casáhá na̱ cája cue̱he̱ na̱ xi̱hi̱n mé na̱ ndáca na̱ va̱lí cán. ");
INSERT INTO mksNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Joo na̱cana Jesús na̱ já na̱cachi a já xi̱hi̱n ná: —Quia̱hva ndó ña̱ma̱ni̱ ná quixi na̱ va̱lí nu̱ú i̱. Ta a̱ cájí nuu ndó nu̱ ná jáchi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi tá ná caja na tá quia̱hva cája na̱ va̱lí yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ndá na̱ co̱ cúni̱ ndiquia̱hva na mé ná ndáha̱ Ndióxi̱ tátu̱hun cája na̱ va̱lí yóho já quéa̱ a̱ cúu cacomí Ndióxi̱ cuéntá sa̱ha̱ ná —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","In táhan da̱ sáhndá chuun cán na̱nda̱ca̱ tu̱hún da̱ Jesús já na̱cachi da já xi̱hi̱n á: —Maestro, mé ndó cúú ndó ta̱a va̱ha ña̱ cán quéa̱ ndáca̱ tu̱hún i̱ ndo̱hó ndía̱ ndítahan caja i̱ já ná ñe̱he̱ táhvi̱ i̱ cu̱hu̱n i̱ indiví coo i̱ a̱nda̱ ama cáa qui̱vi̱ —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Ndá cuéntá quéa̱ cáchún xi̱hín i̱ ña̱ cúú u̱ da̱ va̱ha. Ni in túhún toho ña̱yivi co̱ cúú ná na̱ va̱ha ñuyíví yóho. In túhún Ndióxi̱ cuití va quéa̱ va̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sa̱ xíni̱ vún ña̱ sáhndá Ndióxi̱ nu̱u̱n cajún já cáchí a̱ já: “Coto a̱ coún xi̱hi̱n ñájíhí á yíi̱ ñani táhún. Coto a̱ cáhnún ndi̱i. Coto a̱ cája cuíhnún. Coto a̱ cáhu̱n ña̱ tu̱hún sa̱há ña̱yivi. Ta caja cáhnún tátún nánún” —na̱cachi Jesús xi̱hín da̱ cui̱cá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A̱nda̱ já na̱nducú ñehe da̱ cán tu̱hun nu̱ Jesús já na̱cachi da já xi̱hi̱n á: —Ja̱nda̱ ta̱a loho i̱ na̱casáhá i̱ cája i̱ tócó ndihi ña̱ sáhndá Ndióxi̱ caja i̱ —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tá na̱xini jo̱ho Jesús ña̱ na̱cachi da̱ yóho xi̱hi̱n á já na̱cachi a já xi̱hi̱n dá: —Inga ña̱ha cáma̱ni̱ cajún: Cuáhán ji̱cún tócó ndihi ña̱hún ja̱n ta ndicahnda jiu̱hún ja̱n nu̱ú na̱ nda̱hví já ñehe táhvu̱n coo cua̱há ña̱hún indiví. Ta tá na̱ndihi já quisún candi̱cún ye̱he̱ —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tá na̱xini jo̱ho da̱ cui̱cá cán ña̱ na̱cachi Jesús xi̱hi̱n dá já na̱cacuéha̱ ndiva̱ha ini da jáchi̱ íin cua̱há ndiva̱ha ña̱ha dá. ");
INSERT INTO mksNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tá na̱xini Jesús ña̱ na̱cacuéha̱ ini da̱ cui̱cá cán já cáchí a̱ já: —Ndaja yáncá ndiva̱ha cáa já ndiquia̱hva na̱ cui̱cá mé ná ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jáchi̱ ja̱nda̱ cama chága̱ cuu ya̱ha in camello ini in yávi̱ sa̱ha̱ yítu̱cú a̱ ju̱ú ga̱ ña̱ ná ndiquia̱hva in na̱ cui̱cá mé ná ndáha̱ Ndióxi̱ ña̱ ná cacomí a̱ cuéntá sa̱ha̱ ná —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tá na̱xini jo̱ho ña̱yivi ndíta cán ña̱ na̱cachi Jesús já na̱cachi na̱ cán já: —Ndá na̱ cúú na̱ cuu ca̱cu ndaa ínima̱, dá já. ");
INSERT INTO mksNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ndióxi̱ quéa̱ cuu caja tócó ndihi ña̱ha va̱tí ña̱yivi a̱ cu̱ú caja na ña̱ —na̱cachi Jesús xi̱hín ña̱yivi ndúu cán. ");
INSERT INTO mksNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A̱nda̱ já na̱cachi Pedro já: —Cande̱hé ndo̱, xitoho i̱. Nde̱he̱ na̱jándacoo nde̱ tócó ndihi ña̱ na̱sacomí nde̱ ta ndíco̱ nde̱ ndo̱hó —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ndá na̱ jándacoo vehe á tátá náná na̱ á ñani na á ñájíhí na̱ á ja̱hyi na sa̱há ña̱ cúni̱ na̱ ña̱ ná cacomí Ndióxi̱ cuéntá sa̱ha̱ ná, ");
INSERT INTO mksNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na̱ cán cúú na̱ ñe̱he̱ cua̱ha̱ chága̱ ña̱ha ñuyíví yóho ja̱ta̱ tócó ndihi ña̱ na̱jándacoo na. Ta va̱xi qui̱ví já ñe̱he̱ táhvi̱ ri na catacu na indiví a̱nda̱ ama cáa qui̱vi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tá na̱ndihi já na̱tavá xóo Jesús ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hi̱n á cán. Já na̱cachi a já xi̱hi̱n ná: —Viti co̱hó chí ñuu Jerusalén nu̱ú xi̱nu̱ co̱o tócó ndihi ña̱ na̱ca̱hyí na̱ profeta sa̱há ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jáchi̱ mé ñuu cán tiin na ye̱he̱ já ndiquia̱hva na ye̱he̱ ndahá na̱ tóho̱. Cua̱cu̱ ndaa na ye̱he̱. Canahá na̱ xi̱hín i̱. Cuihna ndaa na tóji̱í na̱ ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Cani na ye̱he̱. Ta tá na̱ndihi já cahní na̱ ye̱he̱. Joo tá ná ya̱ha u̱ni̱ qui̱vi̱ já nditacu tucu u̱ tañu na̱ na̱xi̱hi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Joo na̱ xíca tuun xi̱hi̱n á cán ni loho co̱ó na̱canda̱a̱ ini na ña̱ cúni̱ Jesús cachi a xi̱hi̱n ná. Jáchi̱ cúú á ña̱ha ña̱ co̱ó na̱cuu canda̱a̱ ini na sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tá na̱cayati Jesús ñuu Jericó cán ta yati jíi̱n íchi̱ nu̱ xíca̱ mé á cua̱ha̱n cán íin coo in da̱ cua̱á sáti da. ");
INSERT INTO mksNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ta tá na̱xini jo̱ho da ña̱ yáha cua̱há ña̱yivi cua̱ha̱n na̱ já na̱casáhá da̱ ndáca̱ tu̱hún da̱ ndía̱ cúu. ");
INSERT INTO mksNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A̱nda̱ já na̱cachi na já xi̱hi̱n dá: —Jesús, da̱ ñuu Nazaret, da̱ cán cúú da̱ yáha cua̱ha̱n yóho —na̱cachi na xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A̱nda̱ já na̱casáhá da̱ cua̱á cán cáyuhú da̱ já cáchí da̱ já: —Jesús, da̱ na̱quixi chi̱chi David, caja ndó ña̱ma̱ni̱ candáhví loho ini ndó ye̱he̱ —cáchí da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Joo ña̱yivi, na̱ cánu̱ú cua̱ha̱n xi̱hi̱n Jesús cán na̱casáhá na̱ cája cue̱he̱ na̱ xi̱hi̱n dá ña̱ ná caji da yúhu̱ dá. Joo ví ga̱ ví na̱casáhá da̱ cáyuhú da̱ já cáchí tucu da: —Ndóhó, da̱ na̱quixi chi̱chi David, caja ndó ña̱ma̱ni̱ candáhví loho ini ndó ye̱he̱ —cáchí da̱ cáyuhú da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A̱nda̱ já na̱candichi Jesús já na̱sahnda chuun ña̱ ná cañehe na da̱ cua̱á cán nu̱ á. Ta tá na̱xi̱nu̱ da̱ nu̱ á já na̱nda̱ca̱ tu̱hún a̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Já na̱cachi a já xi̱hi̱n dá: —Ndía̱ cúnu̱n ná caja i̱ xu̱hu̱n —na̱cachi Jesús xi̱hi̱n dá. A̱nda̱ já na̱nducú ñehe da̱ cua̱á cán tu̱hun nu̱ á já na̱cachi da já: —Nda̱ca̱ nde̱hé e̱ cúni̱ i̱, xitoho i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tá na̱ndihi já na̱cachi Jesús já xi̱hi̱n dá: —Cande̱hé viti. Na̱ndiva̱hún jáchi̱ cándeé inún ye̱he̱ —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chí i̱vi̱ la̱á na̱nu̱na̱ nu̱ú da̱ cua̱á cán. Ta chí a̱ ju̱ú quia̱hva cája cáhnu da Ndióxi̱. Ndíco̱ da̱ Jesús cua̱ha̱n da̱. Ta jári tócó ndihi ña̱yivi tá na̱xini na ña̱ yóho já na̱casáhá na̱ cája cáhnu na Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tá na̱ndihi já na̱ndi̱hvi Jesús ñuu Jericó cán já xíca ma̱hñú ñuu cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ta cán na̱sahi̱in in da̱ cui̱cá naní Zaqueo, da̱ cúú da̱ sa̱cua̱ha̱ nu̱ú na̱ játaca jiu̱hún cuéntá impuesto. ");
INSERT INTO mksNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ta cúni̱ da̱ cuni da Jesús joo a̱ cu̱ú cuni ñahá da̱ jáchi̱ cáti cua̱há ndiva̱ha ña̱yivi nu̱ Jesús. Ta mé dá co̱ xínu̱ co̱o da cuni ñahá da̱ jáchi̱ cúú dá da̱ ndi̱hi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chí xínu da na̱canu̱ú da̱ nu̱ú ña̱yivi cua̱ha̱ cán já na̱ndaa da nu̱ú in yíto̱ yati mé jíi̱n íchi̱, mé nu̱ú ya̱ha Jesús cán ña̱ ná cuni ñahá da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ta tá na̱ya̱ha Jesús yati sa̱ha̱ yíto̱ cán já na̱ndiñehe nu̱u̱ á nu̱ cánúu da̱ cán. Já na̱cachi a já xi̱hi̱n dá: —Zaqueo, cuánuu quíi̱ jáchi̱ cúni̱ coo tóo i̱ vehún qui̱vi̱ víti —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A̱nda̱ já ndáva nihni Zaqueo na̱nuu da nu̱ yíto̱ cán. Já cávatá da̱ na̱ndiquehe va̱ha da Jesús cañehe da a̱ cua̱ha̱n da̱ xi̱hi̱n á vehe da. ");
INSERT INTO mksNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Joo tá na̱xini tócó ndihi java ga̱ ña̱yivi cán ña̱ yóho já na̱casáhá na̱ cáha̱n núu na sa̱ha̱ Jesús. Ta cáchí na̱ ña̱ cua̱ha̱n mé á coo tóo a vehe in da̱ta̱a, da̱ cája cua̱há cua̱chi. ");
INSERT INTO mksNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ta tá sa̱ ndúu ndihi na vehe Zaqueo já na̱nda̱ca̱ ndichi Zaqueo já na̱cachi da já xi̱hi̱n Jesús: —Cande̱hé ndo̱, xitoho i̱. Cahnda java nda̱a̱ i̱ ña̱ha cómí i̱ ta já ndicahnda i̱ ña̱ nu̱ú na̱ nda̱hví. Ta ndá na̱ na̱caja cuíhná i̱ ña̱ha, na̱ cán quia̱hva i̱ co̱mi̱ táhndá chága̱ ña̱ha nu̱u̱ jáchi̱ na̱jándahvi i̱ na̱ —na̱cachi Zaqueo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Qui̱ví viti cája cáhnu ini Ndióxi̱ sa̱há cua̱chi da̱ yóho xi̱hín cua̱chi na̱ vehe da jáchi̱ xi̱hín ña̱ na̱caja da̱ yóho viti náha̱ ña̱ mé a̱ nda̱a̱ cándeé ini da Ndióxi̱ tá quia̱hva na̱caja Abraham. ");
INSERT INTO mksNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ta ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi na̱quixi i̱ ndinducú u̱ na̱ xíca nuu cája cua̱há cua̱chi jáchi̱ ca̱cu ndaa ínima̱ ná cúni̱ —na̱cachi Jesús xi̱hi̱n ná ta já na̱quee a cua̱ha̱n tucu a íchi̱ chí ñuu Jerusalén. ");
INSERT INTO mksNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ta nani xíni̱ jo̱ho ña̱yivi ña̱ cáha̱n Jesús já na̱sacu mé á in quia̱hva nu̱ ná jáchi̱ cáyati chága̱ mé á ñuu Jerusalén cua̱ha̱n. Ta mé ña̱yivi ndíco̱ cua̱ha̱n cán na̱ca̱hán na̱ ña̱ tá xi̱nu̱ co̱o a ñuu Jerusalén cán chí i̱vi̱ la̱á va casáhá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi va̱tí a̱ ju̱ú a̱ já. ");
INSERT INTO mksNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Na̱sahi̱in in da̱ta̱a, da̱ cúú ja̱hyi in rey. In qui̱ví na̱quee da cua̱ha̱n xícá da̱ ña̱ ndicojo da chuun cacuu da rey. Tá na̱ndihi na̱sacu ini da nu̱hu̱ da̱ ñuu da. ");
INSERT INTO mksNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Joo tá cáma̱ní nu̱hu̱ da̱ já na̱cana da u̱xu̱ mozo da. Ta na̱sa̱ha̱n da̱ in in jiu̱hún nu̱ú in in da̱ cán ta mé jiu̱hún cán cúú á ña̱ íin ndiva̱ha ya̱hvi. A̱nda̱ já na̱cachi da já xi̱hi̱n mozo dá: “Caja ndó nda̱hvi̱ xi̱hín jiu̱hún yóho ja̱nda̱ quia̱hva ná xi̱nu̱ qui̱vi̱ ndicó co̱o tucu u̱ quixi i̱”, na̱cachi da xi̱hi̱n mozo da̱. Já na̱quee da cuanúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ta ndaja coo ña̱yivi ñundáhyi̱ xícá cándají na̱ da̱. Sa̱há ña̱ cán quéa̱ na̱chindahá na̱ in táhndá táto̱ ña̱ ná cachi na xi̱hi̱n tátá da̱ ña̱ co̱ cúni̱ toho na ña̱ ná cacomí da̱ cán cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Joo já na̱ndicojo da̱ cán chuun cacuu da rey mé ñundáhyi̱ xícá. Ta tá na̱xi̱nu̱ co̱o da cán já na̱sahnda da chuun ña̱ ná cu̱hu̱n na̱ cana na mozo da̱, da̱ na̱sa̱ha̱n da̱ jiu̱hún nu̱ cán. Jáchi̱ cúni̱ da̱ canda̱a̱ ini da ndaja jiu̱hún na̱ñe̱he̱ in in da̱ cán ja̱tá jiu̱hún da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tá na̱ndihi já na̱xi̱nu̱ co̱o in táhan da̱ na̱ñe̱he̱ jiu̱hún cán nu̱ dá já na̱cachi da já: “Cande̱hé ndó, xitoho i̱. Na̱sa̱ha̱n ndó in jiu̱hún nu̱ú i̱ ta viti na̱nduu a u̱xu̱”, na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A̱nda̱ já na̱nducú ñehe da̱ cúú rey cán tu̱hun nu̱ dá já na̱cachi da já xi̱hi̱n dá: “Va̱ha ndiva̱ha na̱cajún xi̱hín ña̱ yóho. Náha̱ ña̱ mé a̱ nda̱a̱ cúún in mozo va̱ha jáchi̱ na̱caja ndihún tá íin na̱cachi i̱ xu̱hún cajún xi̱hín jiu̱hún i̱ va̱tí loho quéa̱ na̱sa̱ha̱n i̱ nu̱u̱n caja chúún. Ta viti caja i̱ ña̱ ná cacomún cuéntá sa̱há u̱xu̱ ñuu”, na̱cachi rey cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tá na̱ndihi já na̱xi̱nu̱ co̱o inga táhan da̱ na̱ñe̱he̱ jiu̱hún cán nu̱ dá já na̱cachi da já: “Cande̱hé ndo̱, xitoho i̱. Na̱sa̱ha̱n ndó in jiu̱hún nu̱ú i̱ ta viti na̱nduu a u̱hu̱n”, na̱cachi mozo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A̱nda̱ já na̱cachi da̱ cúú rey já xi̱hi̱n dá: “Va̱ha na̱cajún sa̱há ña̱ cán quéa̱ caja i̱ ña̱ ná cacomún cuéntá sa̱há u̱hu̱n ñuu”, na̱cachi rey cán xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ta tá na̱ndihi já na̱xi̱nu̱ co̱o inga táhan da̱ cán já na̱cachi da já: “Cande̱hé ndo̱, xitoho i̱. Yóho íin mé jiu̱hún na̱sa̱ha̱n ndó nu̱ú i̱. Na̱chica̱a̱n va̱ha i̱ ña̱ nu̱ jáhma̱ i̱ ");
INSERT INTO mksNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","sa̱há ña̱ yíhví i̱ ndo̱hó. Jáchi̱ cúú ndó in ta̱a cue̱he̱ ndiva̱ha. Ta cátóó ndó ndiquehe ma̱ni̱ uun ndó ña̱ha. Ta cátóó ndó ña̱ ná caja chúun inga ña̱yivi já ja̱ndá xi̱nu̱ uun ndó ndiquehe ndó ña̱ha na̱ñe̱he̱ ná ja̱tá chuun cája ndó”, na̱cachi mozo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A̱nda̱ já na̱nducú ñehe da̱ cúú rey cán tu̱hun nu̱ mozo da̱ já na̱cachi da já xi̱hi̱n dá: “Co̱ cúún in mozo va̱ha nu̱ú i̱. Xi̱hín tu̱hun cáhu̱n chíca̱ún cua̱chi ja̱tu̱n jáchi̱ co̱ cúnu̱n caja chúún sa̱há i̱. Cáchún ña̱ xíni̱ va̱hún cúú ye̱he̱ in da̱ cue̱he̱ ndiva̱ha ta cátóó i̱ quehe e̱ ji̱quí jiu̱hún i̱ va̱tí co̱ó na̱caja chúun i̱ sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Sa̱há ña̱ cán quéa̱ ndá cuéntá quéa̱ co̱ó na̱sa̱ha̱n tóún jiu̱hún i̱, dá já. Já quéa̱ tá ná ndicó co̱o i̱ já ná ndiquehe e̱ ji̱qui̱ á nu̱ú na̱ cán, nduu”, na̱cachi rey cán xi̱hi̱n mozo da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tá na̱ndihi já na̱cachi tucu rey xi̱hín java ga̱ ña̱yivi ndíta cán já: “Candaa ndó jiu̱hún ndáha̱ dá ta quia̱hva ndó ña̱ nu̱ú da̱ cómí u̱xu̱ a̱ ja̱n”, na̱cachi da̱ cúú rey cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","A̱nda̱ já na̱cachi na̱ ndíta cán já xi̱hi̱n rey: “Cande̱hé ndo̱, xitoho i̱. Ndá túni̱ quia̱hva ri nde̱ jiu̱hún yóho nu̱ú da̱ sa̱ cómí u̱xu̱ a̱ cáa jáchi̱ sa̱ cua̱há va jiu̱hún cómí da̱ cáa”, na̱cachi na xi̱hi̱n rey cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Já na̱cachi rey cán já: “Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱, ña̱ ndá na̱ sa̱ íin ña̱ha nu̱u̱, mé na̱ cán ñe̱he̱ táhvi̱ ná coo chága̱ ña̱ nu̱ ná. Joo ndá na̱ co̱ó ña̱ha nu̱u̱ sa̱há ña̱ co̱ cája chúun na já quéa̱ ja̱nda̱ ña̱ loho cómí na̱ ndindaa”, na̱cachi rey cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ta na̱cachi tucu da já: “Cuáhán ndó quehe ndó ña̱yivi quini, na̱ co̱ cúní ye̱he̱, na̱ co̱ó na̱xeen ña̱ ná cacomí i̱ cuéntá sa̱há na̱ cán já ná quixi na. Ta cahní ndó na̱ ná quivi na nu̱u̱ táhyí i̱”, na̱cachi rey cán —na̱cachi Jesús ndicani a nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tá na̱ndihi na̱cachi Jesús ña̱ yóho xi̱hi̱n ná já na̱quehe tucu a íchi̱ xíca cua̱ha̱n chí ñuu Jerusalén. ");
INSERT INTO mksNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ta tá sa̱ na̱xi̱nu̱ co̱o a ji̱ni̱ yúcu̱ yitó olivo cán nu̱ú ja̱ chá xi̱nu̱ co̱o a ñuu Betfagé xi̱hín ñuu Betania cán já na̱sahnda chuun nu̱ú i̱vi̱ táhan da̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Já na̱cachi a já xi̱hi̱n dá: —Cuáhán ndo̱ ñuu loho ndáca̱a̱n ja̱n. Ta tá ná xi̱nu̱ co̱o ndó ja̱n ndiñehe ndó in búrro̱ ndíco̱ ndaa ja̱n, rí a̱ ñáha yi̱i̱ ndaa na. Ndaxí ndó ri̱ ta cañehe ndó ri̱ quixi ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta ndá na̱ ná nda̱ca̱ tu̱hún ndo̱hó ña̱ ndá cuéntá quéa̱ ndáxí ndó ri̱ já cachi ndó já xi̱hi̱n ná: “Mé a̱ cúú xitoho nde̱ xíní ñúhú a̱ ri̱”, cachi ndó xi̱hi̱n ná —na̱cachi Jesús xi̱hín da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Já na̱quee ndíví da̱ cua̱ha̱n da̱. Ta tá quia̱hva na̱cachi Jesús coo chí quia̱hva já ndusa na̱sahi̱in. ");
INSERT INTO mksNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jáchi̱ nani ndáxí da̱ búrro̱ cán ndúu da já na̱ca̱ha̱n mé na̱ xi̱hín ja̱na̱ rí cán sa̱ha̱ ri̱ já na̱cachi na̱ cán já: —Ndá cuéntá quéa̱ ndáxí ndó búrro̱ ja̱na̱ nde̱ ja̱n —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A̱nda̱ já na̱nducú ñehe da̱ xíca tuun xi̱hi̱n Jesús cán tu̱hun nu̱ ná já na̱cachi da já: —Ndáxí nde̱ ri̱ jáchi̱ mé a̱ cúú xitoho nde̱, xíní ñúhú a̱ ri̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Já na̱quehe da ri̱ ñéhe da cua̱ha̱n da̱ nu̱ Jesús. A̱nda̱ já na̱chojó ña̱yivi jáhma̱ ná ja̱ta̱ ri̱ já na̱jándaa na Jesús ja̱ta̱ ri̱. ");
INSERT INTO mksNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ta nani xíca búrro̱ cán cua̱ha̱n rí xi̱hi̱n Jesús já na̱chinduu ña̱yivi jáhma̱ ná íchi̱ nu̱ú ya̱ha rí cán xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ta yati ñuu Jerusalén, mé nu̱ú ndi̱ca yúcu̱ naní yitó Olivo cán já na̱casáhá cáyuhú tócó ndihi na̱ cúú cuéntá mé á cán. Cája cáhnu na Ndióxi̱ xi̱hín ña̱ cáji̱i̱ íní na̱ sa̱ha̱ tócó ndihi ña̱ náhnu na̱xini na na̱caja Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Já cáchí na̱ já cáyuhú na̱: —Ndicáhnu na̱há ná cacuu da̱ cómí cuéntá sa̱ha̱ yo̱ yóho jáchi̱ cúú dá da̱ va̱xi yuhú nu̱u̱ Ndióxi̱. Viti cáji̱i̱ ini na̱ ndúu indiví. Cáhnu ná cacuu Ndióxi̱ —cáchí na̱ cáyuhú na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A̱nda̱ já na̱cachi java na̱ fariseo ñúhu tañu ña̱yivi cán já xi̱hi̱n Jesús: —Maestro, jána̱ni ndó na̱ ndíco̱ ja̱ta̱ ndó yóho ná a̱ cáyuhú cóhó na̱ —na̱cachi na xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Joo na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ tá ná catáji̱ yuhú na̱ yóho ja̱nda̱ já yu̱u̱ ndúu jíi̱n íchi̱ ja̱n casáhá cayuhú a̱ caja cáhnu a ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tá na̱cayati chága̱ Jesús ñuu Jerusalén cán ta tá na̱xini a ñuu cán já na̱casáhá táhvi̱ ini a sácu a sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Já na̱cachi a já: —Cúni̱ jána̱ha̱ i̱ ndo̱hó ndía̱ ndítahan caja ndó já ná coo va̱ha ínima̱ ndó nu̱ Ndióxi̱. Joo co̱ cúni̱ toho ndó canda̱a̱ ini ndó ña̱. Ta viti a̱ cúu ga̱ canda̱a̱ ini ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Jáchi̱ va̱xi qui̱vi̱ tá quixi na̱ co̱ cúní ndo̱hó ta caji nuu na nu̱ ndo̱ ta cani táhan na xi̱hi̱n ndo̱. Ta ni in xoo a̱ cúu cunu ndó jáchi̱ níí cúú caji nuu na̱ cán já ná a̱ quée ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ta jándihi na sa̱ha̱ ndo̱ jáchi̱ cahní na̱ tócó ndihi ndó, na̱ ndúu cán. Ta ni in yu̱u̱ a̱ cándo̱o ja̱tá inga yu̱u̱ jáchi̱ ña̱ cu̱yu cacuu ndihi a. Já ndoho ndó jáchi̱ co̱ cánda̱a̱ ini ndó ña̱ na̱quixi i̱ jáca̱cu u̱ ndo̱hó já ná a̱ ndíhi sa̱ha̱ ndo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tá na̱xi̱nu̱ co̱o Jesús ñuu Jerusalén cán já na̱ndi̱hvi a veñu̱hu cáhnu ndáca̱a̱n ñuu cán. Já na̱casáhá táxí a̱ na̱ ndúu jícó cán xi̱hín na̱ ndúu xéen cán. ");
INSERT INTO mksNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jáchi̱ na̱caja cue̱he̱ a̱ xi̱hi̱n ná ta já na̱cachi a já: —Já cáchí tu̱hun Ndióxi̱: “Vehe mí i̱ cacuu a nu̱ú quixi na ca̱ca̱ ta̱hví na̱ nu̱ú i̱”, cáchí a̱. Joo ndóhó na̱ndai cuu ndó yóho cája cuíhná ndó nu̱ú ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ndijáá níí qui̱vi̱ sáha̱n Jesús veñu̱hu cáhnu cán jána̱ha̱ tu̱hun Ndióxi̱ nu̱ú ña̱yivi. Joo na̱ cúú sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés xi̱hín na̱ sa̱cua̱há ñuu ndúcú na̱ ndá quia̱hva caja na cahní na̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Joo co̱ ñéhe̱ íní na̱ ndaja caja na cahní na̱ Jesús jáchi̱ tócó ndihi ña̱yivi cúni̱ na̱ taa jo̱ho na nu̱ jána̱ha̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ta ndaja coo in qui̱vi̱ ndáca̱a̱n Jesús veñu̱hu cáhnu jána̱ha̱ ña̱yivi ndaja cuu ca̱cu ndaa ínima̱ ná já na̱xi̱nu̱ na̱ cúú sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés ta cátáhan ri na̱ sa̱cua̱há veñu̱hu na̱xi̱nu̱ co̱o na xi̱hi̱n ná nu̱ ndáca̱a̱n Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","A̱nda̱ já na̱cachi na já xi̱hi̱n Jesús: —Ndá sa̱ha̱ quéa̱ jána̱hún ña̱ yóho. Yo já sáhan ña̱ma̱ni̱ nu̱u̱n cajún ña̱ cájún yóho —na̱cachi na̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Ndáca̱ tu̱hún ri ye̱he̱ va ndo̱hó. Cachi ndó xi̱hín i̱: ");
INSERT INTO mksNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yo já na̱chindahá Juan ña̱ ná quixi da caja ndúta̱ dá ña̱yivi. Á Ndióxi̱ na̱chindahá da̱, á ña̱yivi na̱chindahá ñahá —na̱cachi Jesús xi̱hín na̱ cán ndáca̱ tu̱hún a̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A̱nda̱ já na̱casáhá ndítúhún xi̱hi̱n táhan na̱ sa̱cua̱ha̱ cán já cáchí na̱ já: —Ndía̱ cachi yó xi̱hi̱n Jesús yóho. Jáchi̱ tá ná cachí ña̱ Ndióxi̱ quéa̱ na̱chindahá Juan já nducú ñehe Jesús tu̱hun nu̱ yo̱ já cachi a já xo̱ho̱: “Ndá cuéntá quéa̱ co̱ó na̱xeen ndó candúsa ndó da̱, dá já”, cachi Jesús xo̱ho̱. ");
INSERT INTO mksNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ta tá ná cachí ña̱yivi va cúú na̱ na̱chindahá Juan já ndicui̱ta ña̱yivi ta cahní na̱ mí xi̱hín yu̱u̱. Jáchi̱ tócó ndihi ña̱yivi cánda̱a̱ va̱ha ini na ña̱ Ndióxi̱ quéa̱ na̱chindahá Juan jáya̱ha da tu̱hun cáha̱n mé á nu̱ú ña̱yivi —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sa̱há ña̱ cán quéa̱ na̱cachi na xi̱hi̱n Jesús ña̱ co̱ xíni̱ toho na yo já na̱chindahá Juan ña̱ ná quixi da caja ndúta̱ dá ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Ta ni ye̱he̱ a̱ cáxi tu̱hun i̱ xi̱hi̱n ndó yo já na̱sa̱ha̱n ña̱ma̱ni̱ nu̱ú i̱ caja i̱ ña̱ yóho —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tá na̱ndihi já na̱casáhá Jesús cáha̱n xi̱hín ña̱yivi ta já na̱sacu a quia̱hva yóho nu̱ ná já na̱cachi a já: —Na̱sahi̱in in da̱ta̱a ta na̱jánde̱e cua̱ha̱ dá tó uva. Ta tá na̱ndihi já na̱sa̱ha̱n ndojó na̱ mé dó uva cán. A̱nda̱ já na̱quee da cua̱ha̱n xícá da̱ cua̱ha̱ tiempo. ");
INSERT INTO mksNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ta tá na̱xi̱nu̱ co̱o tiempo jáquee na uva nu̱ dó uva ña̱ha da̱ cán já na̱chindahá da̱ in mozo da̱ ña̱ ná cu̱hu̱n da̱ ndiquehe da uva, rí ndítahan nu̱ dá ndiquehe da. Joo mé na̱ cája chúun tóo ñúhu̱ dá cán na̱tiin na mé mozo cán ta na̱cani na da̱ ta já cáa uun da na̱ndicó co̱o da na̱caja na. ");
INSERT INTO mksNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tá na̱ndihi já na̱chindahá mé da̱ xi̱hín ña̱ha ñúhu̱ cán inga tucu mozo da̱. Joo quia̱hva já na̱caja ri na xi̱hín da̱ cán va. Na̱canahá na̱ xi̱hi̱n dá ta na̱cani na da̱. Ta já cáa uun da na̱chindahá tucu na da̱ nu̱ú xitoho da. Co̱ó ña̱ha na̱sa̱ha̱n na̱ nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ta mé da̱ xi̱hín ña̱ha ñúhu̱ cán na̱chindahá tucu da inga mozo da̱ ta quia̱hva já na̱caja ri na xi̱hín da̱ cán va. Na̱jándicue̱he̱ na̱ da̱ ta já na̱taxí na̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ʼTa tá nu̱ ndíhí já na̱ca̱hán mé da̱ xi̱hín ña̱ha ñúhu̱ cán já: “Ña̱ caja i̱ viti quéa̱ chindahá i̱ ja̱hyi ma̱ní i̱ jáchi̱ cája i̱ cuéntá coo toní ñúhú na̱ xi̱hi̱n dá tá ná cuni na da̱”, na̱ca̱hán mé da̱ xi̱hín ña̱ha ñúhu̱ cán. Ta tá na̱ndihi já na̱chindahá da̱ ja̱hyi máni̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Joo tá na̱xini na̱ cája chúun tóo ñúhu̱ dá cán ña̱ va̱xi ja̱hyi da já na̱cachi xi̱hi̱n táhan na̱ cán já: “Cande̱hé ndo̱. Yóho va̱xi da̱ cúú ja̱hyi xitoho í. Ta tá ná xi̱nu̱ qui̱ví quivi xitoho í ta da̱ yóho cacuu da ndicojo chuun sa̱ha̱ ñúhu̱ yóho. Cóho̱ cahní yó da̱ já ná cando̱o ñúhu̱ yóho ndáha̱ mí”, na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","A̱nda̱ já na̱tavá na̱ da̱ cúú ja̱hyi xitoho cán ja̱ta̱ cútu̱ ta cán na̱sahní na̱ da̱ —na̱cachi Jesús. A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús ña̱yivi ndúu cán já na̱cachi a já xi̱hi̱n ná: —Á co̱ xíni̱ ndó ndía̱ caja da̱ xi̱hín ña̱ha ñúhu̱ viti. ");
INSERT INTO mksNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ña̱ caja da quéa̱ quixi da ta cahní ndihi da na̱ na̱caja chúun tóo nu̱ ñúhu̱ dá. Já ndiquia̱hva da ñúhu̱ dá nu̱ú java ga̱ na̱ já ná caja chúun na nu̱ á —na̱cachi Jesús. Tá na̱xini jo̱ho na̱ ndíta cán ña̱ yóho já na̱cachi ndihi na já: —A̱ cándeé Ndióxi̱ coo ña̱ ja̱n já —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Joo na̱sande̱hé Jesús nu̱ ná já na̱cachi a já: —Ta viti cachi ndó xi̱hín i̱ ndía̱ cúni̱ cachi tu̱hun Ndióxi̱ tá cáchí a̱ já: Mé yu̱u̱ ña̱ na̱jácana da cáva̱ha vehe, ña̱ cán cúú ña̱ na̱nduu yu̱u̱ ndúhu̱ sa̱há vehe ña̱ íin chága̱ sa̱ha̱, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ʼTa ye̱he̱ cúú u̱ tátu̱hun in tóto̱ cáhnu. Ta ndá na̱ ná ya̱ha ndicava ja̱ta̱ tóto̱ cán chí chachi ndihi na. Quia̱hva já ndihi sa̱há ña̱yivi tá co̱ cúni̱ na̱ candúsa na ye̱he̱. Ta mé tóto̱ cáhnu cán tá ná ya̱ha ndicava ja̱tá in ña̱yivi chíca̱ji̱ ndi̱hi̱ ñahá a̱ cán. Quia̱hva já ndihi sa̱há ña̱yivi ini indayá tá co̱ cúni̱ na̱ candúsa na ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chí sa̱ mé hora já cúni̱ na̱ cúú sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés cán tiin na Jesús jáchi̱ na̱canda̱a̱ ini na ña̱ sa̱ha̱ mé va na̱ cán sácú Jesús mé quia̱hva nu̱ú ña̱yivi cán. Joo co̱ó na̱tiin na Jesús jáchi̱ na̱yi̱hví na̱ ña̱yivi ndúu táa jo̱ho nu̱ cáha̱n Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ña̱ na̱caja na quéa̱ na̱chindahá na̱ java da̱ta̱a ña̱ ná cana̱ní da̱ Jesús. Ta ndája da mé dá ña̱ cúú dá ta̱a va̱ha ndiva̱ha joo co̱ cúú da̱ tá quia̱hva ndáa da. Ta xi̱hi̱n ña̱ yóho cúni̱ da̱ cayati da nu̱ Jesús ná cande̱hé da̱ á ya̱ha yúhu̱ á ca̱ha̱n ndá ña̱ha ña̱ cuu cu̱hu̱n da̱ ji̱có túhún da̱ mé á nu̱ú da̱ cúú gobernador. ");
INSERT INTO mksNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sa̱há ña̱ cán quéa̱ na̱cayati da nu̱ Jesús ta na̱nda̱ca̱ tu̱hún da̱ mé á já na̱cachi da já xi̱hi̱n á: —Maestro, cánda̱a̱ ini nde̱ ña̱ cáha̱n ndó ta jána̱ha̱ ndó ña̱ nda̱a̱. Ta cánda̱a̱ ini nde̱ ña̱ tá cáha̱n ndó sa̱há in ña̱ha cája ña̱yivi cúú á sa̱há ña̱ sánde̱hé ndó ja̱nda̱ ínima̱ ná. Ta cánda̱a̱ ini nde̱ ña̱ jána̱ha̱ ndó ña̱ nda̱a̱ sa̱ha̱ íchi̱ cuéntá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sa̱há ña̱ cán quéa̱ cúni̱ nde̱ canda̱a̱ ini nde̱ viti á ndítahan nu̱ú nde̱ cha̱hvi nde̱ jiu̱hún cuéntá impuesto nu̱ú da̱ cómí cuéntá sa̱ha̱ yo̱ ñuu Roma, á co̱ ndítahan toho nu̱ú nde̱ caja nde̱ ña̱ —na̱cachi na̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Joo sa̱ na̱canda̱a̱ va ini Jesús ña̱ cáhvi núu va ini na sa̱há ña̱ cán quéa̱ na̱nducú ñehe a tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Cánda̱a̱ cáxí táhyí ini i̱ ña̱ cúni̱ ndó coto ndojó cuití ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Jána̱ha̱ ndó in táhan jiu̱hún ja̱n nu̱ú i̱. Yo na̱hná ta yo qui̱vi̱ quéa̱ ndáa nu̱ á —na̱cachi a xi̱hi̱n ná. Já na̱cachi na já: —Ñéhe a qui̱vi̱ xi̱hín na̱hná da̱ cómí cuéntá sa̱há yo̱ ñuu Roma —na̱cachi na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ndiquia̱hva ndó ña̱ha da̱ cómí cuéntá sa̱ha̱ ndó ñuu Roma ja̱n nu̱ dá. Ta ndiquia̱hva ndó nu̱ Ndióxi̱ ña̱ cúú ña̱ha mé á nu̱ á —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Chí co̱ó na̱cuu caja na jándahvi na Jesús nu̱ú ña̱yivi ndúu cán jáchi̱ vií na̱nducú ñehe ndihi Jesús tu̱hun nu̱ ná. Ta chí joho cátóntó ndihi ña̱yivi xi̱hín quia̱hva na̱nducú ñehe Jesús tu̱hun nu̱ ná. Chí na̱catáji̱ na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tá na̱ndihi já na̱quee java na̱ saduceo cua̱ha̱n na̱ ca̱ha̱n na̱ xi̱hín Jesús. Ta mé na̱ saduceo co̱ cándúsa na ña̱ ndítacu tucu na̱ sa̱ na̱xi̱hi̱. Tá na̱sa̱a̱ na̱ nu̱ íin Jesús já na̱cachi na já xi̱hi̱n á: ");
INSERT INTO mksNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, nu̱ ley na̱ca̱hyi̱ Moisés sa̱nahá na̱ta̱hnda̱ chuun ta cáchí a̱ já: “Tá tánda̱ha̱ in da̱ta̱a xi̱hi̱n ñájíhí da̱ ta tá co̱ó ja̱hyi ñá cácu xi̱hi̱n dá ta tá ná xi̱nu̱ qui̱vi̱ quivi da já quéa̱ cáchí ley Moisés ña̱ ndítahan tanda̱ha̱ tucu ñájíhí da̱ xi̱hín da̱ cúú ñani mé ndi̱i cán já ná coo ja̱hyi da̱ cán xi̱hi̱n yuhú nu̱ú ñani da”, já cáchí ley Moisés. ");
INSERT INTO mksNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ta viti cuni jo̱ho ndó ná cacu nde̱ in quia̱hva nu̱ ndo̱. Na̱sahi̱in u̱sa̱ ñani. Ta da̱ nu̱ cuítí cán na̱tanda̱ha̱ dá. Joo na̱ya̱ha tiempo na̱xi̱hi̱ da̱ ta co̱ó toho ja̱hyi da na̱cacu xi̱hi̱n ñájíhí da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A̱nda̱ já na̱tanda̱ha̱ tucu ñá cuáa̱n cán xi̱hín ñani chí i̱vi̱ mé ndi̱i cán. Joo na̱xi̱nu̱ qui̱ví na̱xi̱hi̱ ri da̱ yóho va ta chí co̱ó ja̱hyi da na̱cacu xi̱hi̱n ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A̱nda̱ já na̱tanda̱há da̱ chí u̱ni̱ cán xi̱hi̱n ña̱. Joo ni da̱ cán ni java ga̱ ñani da co̱ó na̱cuu cacu ja̱hyi xi̱hi̱n ña̱. Ndíhu̱sa̱ da̱ na̱tanda̱ha̱ xi̱hi̱n ña̱ ta ndíhu̱sa̱ da̱ na̱xi̱hi̱. Joo ni in da co̱ó na̱cacu ja̱hyi xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tá nu̱ ndíhí já na̱xi̱hi̱ ri mé va ñá. ");
INSERT INTO mksNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ña̱ cúni̱ nde̱ canda̱a̱ ini nde̱ quéa̱, ndá da̱ cacuu ndusa yíi̱ ñá cán tá ná xi̱nu̱ qui̱ví nditacu tucu ndi̱i. Jáchi̱ ndíhu̱sa̱ va ñani da̱ cán na̱tanda̱há xi̱hi̱n ña̱ —na̱cachi na̱ cán ndáca̱ tu̱hún na̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já: —Nani ndúu ña̱yivi ñuyíví yóho cuití va tánda̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jáchi̱ ndá na̱ na̱nditacu tucu ta na̱ñe̱he̱ táhvi̱ ná coo na indiví já quéa̱ co̱ tánda̱ha̱ na̱ ta ni co̱ sáhan toho na ja̱hyi jíhí na̱ tanda̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Jáchi̱ mé cán cacuu na tátu̱hun táto̱ Ndióxi̱ já a̱ quívi ga̱ na̱. Ta cacuu na ja̱hyi Ndióxi̱ jáchi̱ sa̱ na̱nditacu na tañu ndi̱i. ");
INSERT INTO mksNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ta sa̱ xíni̱ yo̱ ña̱ nditacu tucu ndi̱i jáchi̱ já na̱cachi Moisés sa̱nahá tá na̱ca̱hyí da̱ sa̱há ña̱ na̱xini da tañu tohíñú, dó cándaha ñúhu̱ cáyi̱ cán. Tá na̱ca̱ha̱n da̱ sa̱há Ndióxi̱, na̱cachi da ña̱ ja̱nda̱ viti cája cáhnu Abraham xi̱hín Isaac xi̱hín Jacob mé Ndióxi̱ va̱tí na̱xi̱hi̱ na̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ta ña̱ yóho cúni̱ cachi a ña̱ tácú yi̱i̱ va Abraham xi̱hín Isaac xi̱hín Jacob va̱tí sa̱ na̱xi̱hi̱ yiquí cu̱ñu na. Jáchi̱ tócó ndihi na̱ cúú cuéntá Ndióxi̱, tácú na̱ nu̱ mé á —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A̱nda̱ já na̱cachi java na̱ jána̱ha̱ ley Moisés cán já xi̱hi̱n á: —Va̱ha va na̱ca̱ha̱n ndó, Maestro. ");
INSERT INTO mksNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ta chí co̱ó na̱sa̱ha̱n ndeé ga̱ ini na nda̱ca̱ tu̱hún chága̱ na̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","A̱nda̱ já na̱cachi Jesús já xi̱hín ña̱yivi ndúu cán: —Ndáva̱ha cáchí ña̱yivi ña̱ va̱xi Cristo chi̱chi David. ");
INSERT INTO mksNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ta ndáa ini Salmos ña̱ na̱ca̱hyí David já na̱cachi da já: Ndióxi̱ quéa̱ na̱cachi já xi̱hín xitoho i̱: “Coo xoo cuáha i̱ yóho, ");
INSERT INTO mksNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ja̱nda̱ quia̱hva ná caja i̱ ña̱ ná cacomún cuéntá sa̱há na̱ co̱ cúní yo̱hó”, na̱cachi Ndióxi̱, já na̱ca̱hyí David sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ndáva̱ha cáchí na̱ ña̱ va̱xi Cristo chi̱chi David joo mé tiempo cán na̱cachi David ña̱ cúú á xitoho da —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tócó ndihi ña̱yivi ndúu cán na̱xini jo̱ho na tá na̱casáhá Jesús cáchí a̱ xi̱hín na̱ xíca tuun xi̱hi̱n á já: ");
INSERT INTO mksNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Cuéntá coo ndó xi̱hín na̱ jána̱ha̱ ley Moisés jáchi̱ cátóó na̱ cándixi na jahmá náni̱ caca nuu na. Ta cátóó na̱ ca̱ha̱n toní ñúhú ndiva̱ha ña̱yivi xi̱hi̱n ná tá xíca nuu na nu̱ú ya̱hvi. Ta tá cua̱ha̱n na̱ veñu̱hu cátóó na̱ caco̱o na nu̱ sáco̱o na̱ íin chága̱ sa̱ha̱. Ta tá cua̱ha̱n na̱ víco̱ cátóó na̱ coo va̱ha na. ");
INSERT INTO mksNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ta cándaa na vehe na̱ji̱hí cuáa̱n. Ta tá na̱ndihi cáni̱ ndiva̱ha cája na xíca̱ ta̱hví na̱ nu̱ Ndióxi̱ jáchi̱ cúni̱ na̱ jája̱hvi na nu̱ú ña̱ núu cája na. Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ na̱ jána̱ha̱ ley Moisés yóho cacuu na na̱ ndoho chága̱ ini caja Ndióxi̱ nu̱ ndíhí —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ta ndaja coo ndáca̱a̱n Jesús ini veñu̱hu cáhnu cán ta sánde̱hé a̱ ndá quia̱hva táán na̱ cui̱cá jiu̱hún ini sa̱to̱ nu̱ jóco̱ ña̱yivi jiu̱hún nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ta jári na̱xini a na̱xi̱nu̱ co̱o in ñá cuáa̱n ndáhví ta na̱taán ña̱ i̱vi̱ jiu̱hún ña̱ núu ya̱hvi ini mé sa̱to̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á cán: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ cua̱ha̱ chága̱ jiu̱hún na̱sa̱ha̱n ñá cuáa̱n ndáhví yóho a̱ ju̱ú ga̱ tócó ndihi java ga̱ na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Jáchi̱ tócó ndihi na̱ java cán sáhan na ña̱ yójó nu̱ va na. Joo ñá cuáa̱n ndáhví yóho na̱sa̱ha̱n ñá nu̱ Ndióxi̱ tócó ndihi ña̱ cómí ñá catacu ñá —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Java ña̱yivi cán ndítúhún na̱ sa̱há veñu̱hu cáhnu ñuu Jerusalén ndíta na. Ta ndítúhún na̱ sa̱há yu̱u̱ ndató ndiva̱ha na̱cava̱ha veñu̱hu cán. Ta cáha̱n na̱ sa̱há ña̱ha na̱jo̱co̱ ña̱yivi nu̱ Ndióxi̱ ndáa cán. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Va̱xi qui̱vi̱ ndihi sa̱ha̱ tócó ndihi ña̱ ndíta ndó sánde̱hé ndo̱ yóho. Ta ni ja̱nda̱ in yu̱u̱ a̱ cándo̱o ja̱tá inga yu̱u̱ ña̱ nditani cacuu tócó ndihi ña̱ yóho —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","A̱nda̱ já na̱nda̱ca̱ tu̱hún na̱ Jesús já na̱cachi na já xi̱hi̱n á: —Maestro, ndá ama coo tócó ndihi ña̱ yóho. Ta ndaja coo tá sa̱ na̱cayati mé qui̱vi̱ cán —na̱cachi na xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A̱nda̱ já na̱cachi Jesús já: —Cuéntá coo ndó ta a̱ quiáhva ndó ña̱ma̱ni̱ jándahvi ña̱yivi ndo̱hó. Jáchi̱ quixi cua̱há ndiva̱ha na cuéntá mí i̱ ta ca̱ha̱n na̱ ña̱ tu̱hún tá cachi na já xi̱hi̱n ndo̱: “Ye̱he̱ cúú Cristo, da̱ na̱chindahá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi.” Ta cachi na já: “Viti na̱xi̱nu̱ co̱o tiempo ndihi sa̱ha̱ ñuyíví”, cachi na xi̱hi̱n ndo̱. Joo coto a̱ cándúsa ndó candi̱co̱ ndó ja̱ta̱ ná cu̱hu̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tá ná cuni jo̱ho ndó ña̱ cáni táhan ña̱yivi ñuyíví yóho, a̱ cáyi̱hví toho ndó. Jáchi̱ ndúsa̱ já ndítahan coo. Joo cáma̱ní yi̱i̱ va jáxi̱nu̱ co̱o qui̱ví ndihi sa̱há ñuyíví —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A̱nda̱ já na̱ca̱ha̱n chága̱ Jesús xi̱hi̱n ná já na̱cachi a já: —Ña̱yivi ndúu in nación ndicui̱ta na cani táhan na xi̱hín na̱ ndúu inga nación ta cani táhan na̱ in ñuu xi̱hín na̱ inga ñuu. ");
INSERT INTO mksNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ta quixi cua̱há ña̱ ta̱an tá sa̱ na̱cayati qui̱ví ndihi sa̱há ñuyíví. Ta quixi ta̱ma̱ ndeé. Ta quixi cue̱he̱ nu̱ú ña̱yivi ndúu cua̱há ñuu. Ta chí catóntó ndiva̱ha ña̱yivi cuni na ña̱ha náhnu chí indiví. Ta yi̱hví ndiva̱ha na tá cuni na java ña̱ha xitúhún ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ʼJoo tá cáma̱ní xi̱nu̱ co̱o qui̱vi̱ coo tócó ndihi ña̱ yóho já ndicui̱ta ña̱yivi caja xíxi na xi̱hi̱n ndó, na̱ cándúsa ye̱he̱. Ta cañehe na ndo̱hó cu̱hu̱n ndó ini veñu̱hu na ta cán caja vií na̱ sa̱ha̱ ndo̱ sa̱há ña̱ cándeé ini ndó ye̱he̱. Ta taán na̱ ndo̱hó ini veca̱a ta já cañehe na ndo̱hó cu̱hu̱n ndó cavií sa̱ha̱ ndó nu̱ú na̱ cúú jutixia xi̱hín nu̱ú na̱ cómí cuéntá sa̱há ña̱yivi. Tócó ndihi ña̱ yóho ndoho ndó sa̱há ña̱ cándeé ini ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ta xi̱hín ña̱ yóho cuu ñe̱he̱ íní ndo̱ ca̱ha̱n ndó sa̱há i̱ nu̱ú na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ta a̱ ndícani ini ndó sa̱ha̱ ndá tu̱hun ca̱ha̱n ndó sa̱ha̱ mé ndó nu̱ú na̱ cán tá ná xi̱nu̱ ndó nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Jáchi̱ mí i̱ quia̱hva i̱ tu̱hun nu̱ ndo̱ ta ndaja ndíchí i̱ ji̱ni̱ ndo̱ já ná cuu nducú ñehe va̱ha ndó tu̱hun nu̱ú na̱ cán. Ta chí a̱ cu̱ú quee va̱ha yuhú na̱ cán xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Joo cua̱há ña̱yivi ji̱có túhún na̱ ndo̱hó. Ta chí ja̱nda̱ tátá ndo̱ á ñani ndó á táhan ndó á na̱ xíní táhan xi̱hi̱n ndo̱, na̱ cán cacuu na̱ ji̱có túhún ndo̱hó cua̱há tañu. Ta java táhan ndó, na̱ cándeé ini ye̱he̱ quivi ndó caja na. ");
INSERT INTO mksNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ta ndijáá ña̱yivi ñuyíví candají na̱ ndo̱hó sa̱há ña̱ cándeé ini ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Joo ni in ña̱ha a̱ ndóho ndó a̱nda̱ ni in ijí ji̱ni̱ ndó a̱ ndíhi sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ta tá co̱ó na̱cuitá ndo̱ xi̱hi̱n tócó ndihi ña̱ núu caja na xi̱hi̱n ndo̱ já xi̱nu̱ ndó canduu ndó indiví a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ʼTá ná cuni ndó ña̱ na̱ca̱va̱ tiyi̱vi̱ soldado ja̱tá ñuu Jerusalén ndúu da, xíní ñúhú canda̱a̱ ini ndó ña̱ sa̱ na̱xi̱nu̱ qui̱ví ndihi sa̱há ñuu cán. ");
INSERT INTO mksNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ña̱ ndítahan caja ndó mé qui̱vi̱ cán quéa̱ cunu ndó cu̱hu̱n ndó chí yúcu̱ tá ndúu ndó chí estado Judea. Ta ndá ndó, na̱ ndúu ñuu Jerusalén xíní ñúhú jándacoo ndó ñuu ja̱n ta cunu ndó cu̱hu̱n ndo̱. Ta ndá ndó, na̱ ndúu yúcu̱, a̱ ndícó co̱o ga̱ ndó ndi̱hvi ndó ñuu Jerusalén yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jáchi̱ mé qui̱vi̱ já cacuu a qui̱ví ndoho ini ña̱yivi já ná xi̱nu̱ co̱o tócó ndihi nu̱ú ña̱ na̱cachi tu̱hun Ndióxi̱ coo sa̱nahá ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ndáhví na̱cuu na̱ji̱hí tá ñúhu ja̱hyi na mé qui̱vi̱ já. Ta ndáhví na̱cuu na tá ñéhe ndaa na na̱ va̱lí táhan ña̱ chíchí yi̱i̱. Jáchi̱ ndoho ndiva̱ha ini ña̱yivi ndúu ñuyíví mé qui̱vi̱ já sa̱há ña̱ xójo̱ ndiva̱ha ini Ndióxi̱ xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Java ña̱yivi quivi na caja soldado ta java na ca̱to̱ ná já cañehe na na̱ cu̱hu̱n na̱ ndijáá chí ñuu tóho̱ canduu na jáchi̱ ndihi sa̱há ñuu Jerusalén yóho. Ta já quixi na̱ ñuu tóho̱ ta casáhá na̱ cahnda na chuun nu̱ú ñuu Jerusalén yóho ja̱nda̱ quia̱hva ná xi̱nu̱ co̱o qui̱ví cacu ini Ndióxi̱ ña̱ ná quee na̱ tóho̱ cán cu̱hu̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ʼA̱nda̱ já cuni ndó ña̱ náhnu ndiva̱ha chí nu̱ú ca̱ndii xi̱hín nu̱ú yo̱o̱ xi̱hín nu̱ú qui̱mi viti. Ta ña̱yivi ñuyíví yóho yi̱hví ndiva̱ha na ta chí a̱ cánda̱a̱ ini na ndía̱ caja na jáchi̱ quini ndiva̱ha ta̱cu̱ nu̱ú ndico̱jo̱ tañu̱hú. ");
INSERT INTO mksNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ta chí ja̱nda̱ quivi tóo ña̱yivi xi̱hín ña̱ yi̱hví na̱ jáchi̱ casáhá ndicani ndiva̱ha ini na sa̱ha̱ tócó ndihi tondóhó va̱xi ñuyíví yóho. Jáchi̱ ja̱nda̱ mé ca̱ndii xi̱hín yo̱o̱ xi̱hín qui̱mi ndiquiji nuu a. ");
INSERT INTO mksNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A̱nda̱ já cuni ndó ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi, quixi i̱ tañu vi̱co̱ xi̱hi̱n tócó ndihi ndée̱ cáhnu i̱ ta chí ndiyi̱hvi ndaa mé nu̱ú quixi i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tá ná casáhá ya̱ha tócó ndihi ña̱ cáchí i̱ xi̱hi̱n ndo̱ yóho, xíní ñúhú ndindeé ini ndó ta ndiñehe ndó nu̱u̱ ndó jáchi̱ sa̱ na̱cayati qui̱vi̱ jáca̱cu Ndióxi̱ ndo̱hó cu̱hu̱n ndó coo ndó indiví —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","A̱nda̱ já na̱sacu a in quia̱hva nu̱ ná já na̱cachi a já: —Xíní ñúhú cande̱hé ndo̱ ndá quia̱hva cája chúun in ti̱tó ñu̱hú, á ndá yíto̱ na̱cuu. ");
INSERT INTO mksNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tá ná cuni ndó ña̱ ja̱ndá joho cana núma̱ do̱ já cánda̱a̱ ini ndó ña̱ na̱cayati tiempo ja̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ta quia̱hva já tá ná cuni ndó ña̱ sa̱ cúú yáha tócó ndihi ña̱ cáchí i̱ xi̱hi̱n ndo̱ yóho já canda̱a̱ ini ndó ña̱ sa̱ na̱cayati qui̱ví casáhá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ʼMé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ cuni ña̱yivi ndúu mé tiempo já ya̱ha tócó ndihi ña̱ na̱cachi i̱ xi̱hi̱n ndo̱ já quivi na. ");
INSERT INTO mksNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mé a̱ nda̱a̱ ña̱ cúú indiví xi̱hi̱n ñundáhyi̱ yóho ndihi sa̱há joo tu̱hun na̱ca̱ha̱n ye̱he̱ xi̱hi̱n ndo̱ a̱ ndíhi toho sa̱há jáchi̱ coo tá coo tá íin na̱cachi i̱ xi̱hi̱n ndó coo. ");
INSERT INTO mksNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ʼCuéntá coo ndó. Xíní ñúhú candati tia̱hva ndó qui̱ví quixi i̱ ndiquehe e̱ ndo̱hó. A̱ cáca nuu ndó yóho cáa ña̱ caja ndó ña̱ cúni̱ yiquí cu̱ñu ndó. A̱ cóho ndó caca nuu ndó. Ta a̱ ndíhi na̱há ini ndó ndicani ini ndó sa̱há ña̱ha ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tá ná xi̱nu̱ qui̱ví quixi i̱ cacuu a tátu̱hun tá sácú je̱hé in da̱ta̱a in trampa nu̱ú in quíti̱ sa̱há ña̱ cúni̱ da̱ tiin da ri̱. Mé quíti̱ cán co̱ xíni̱ rí ndáchí íin je̱hé trampa tiin ñahá cán. Quia̱hva já co̱ xíni̱ ña̱yivi ndúu ñuyíví ndá qui̱ví quixi tucu u̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Xíní ñúhú canduu tia̱hva ndó qui̱ví quixi i̱. Níí tiempo xíní ñúhú ca̱ca̱ ta̱hví ndo̱ nu̱ Ndióxi̱ já ná ndindeé ini ndó tá ná quixi tócó ndihi ña̱ yóho nu̱ ndo̱ ta já ná cuu xi̱nu̱ co̱o va̱ha ndó indiví já ná cuu coo vií ndo̱ nu̱ú ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi —na̱cachi Jesús jána̱ha̱ nu̱ú ña̱yivi cán. ");
INSERT INTO mksNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nini qui̱vi̱ na̱sahi̱in Jesús ini veñu̱hu cáhnu jána̱ha̱ tu̱hun Ndióxi̱ nu̱ú na̱ cán. Ta tá ñuú já sáha̱n quíji̱ a̱ yúcu̱ yitó Olivo cán. ");
INSERT INTO mksNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ndijáá níí qui̱vi̱ naha chá na̱xi̱nu̱ co̱o ña̱yivi veñu̱hu cáhnu cán jáchi̱ cúni̱ na̱ cuni jo̱ho na ña̱ jána̱ha̱ Jesús nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ta yati tandaa víco̱ pascua tá xíxi ña̱yivi pan ña̱ co̱ quée yusá na̱xia̱a̱ xi̱hi̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Já na̱casáhá na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés ndúcú na̱ ndaja caja na cahní na̱ Jesús. A̱ cu̱ú caja na cahní tívi na ña̱ jáchi̱ yíhví na̱ cana̱há ña̱yivi xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Joo ndaja coo tiñáhá sa̱cua̱ha̱ na̱nde̱ta nuu rí ínima̱ in táhan u̱xu̱ i̱vi̱ da̱ xíca tuun xi̱hi̱n Jesús. Mé da̱ cán naní da̱ Judas ta Judas Iscariote cáha̱n na̱ xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ta na̱sa̱ha̱n Judas ca̱ha̱n da̱ xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ ta xi̱hín na̱ sa̱cua̱ha̱ nu̱ policía ndáá veñu̱hu. Ta na̱nditúhún da̱ xi̱hi̱n ná ña̱ cuu caja da ji̱có túhún da̱ Jesús ta ndiquia̱hva ñahá dá mé á nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Xi̱hín ña̱ yóho na̱caji̱i̱ íní na̱ cán ta na̱sa̱ha̱n na̱ tu̱hun na nu̱ Judas ña̱ quia̱hva na jiu̱hún nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ta na̱candúsa Judas caja da ña̱ chí na̱casáhá da̱ ndúcú da̱ ndaja caja da ndiquia̱hva da Jesús nu̱ú na̱ cán tá co̱ó ña̱yivi ndúu xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na̱tandaa mé víco̱ tá xíxi na pan ña̱ co̱ quée yusá na̱xia̱a̱ xi̱hi̱n. Mé víco̱ yóho na̱sacaja na ña̱ tá nu̱ cuía̱ ta sáhní na̱ ndicachi válí jóco̱ na̱ nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mé qui̱vi̱ já na̱sahnda Jesús chuun nu̱ Pedro xi̱hín nu̱ Juan já na̱cachi a já xi̱hi̱n dá: —Cuáhán ndó caja ndíví ndo̱ ña̱ cajíní vicó pascua —na̱cachi a xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A̱nda̱ já na̱cachi da̱ cán já xi̱hi̱n á: —Yo vehe cúni̱ ndó cu̱hu̱n nde̱ ná caja ndíví nde̱ ña̱ cuxú. ");
INSERT INTO mksNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já: —Tá ná qui̱hvi ndó ñuu Jerusalén ja̱n já cuni ndó in da̱ta̱a ta ndójo da in yoo ticui̱í cua̱ha̱n da̱. Candi̱co̱ ndó ja̱ta̱ dá cu̱hu̱n ndo̱ ja̱nda̱ quia̱hva cuni ndó ndá vehe qui̱hvi da. ");
INSERT INTO mksNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ta já cu̱hu̱n ndó ca̱ha̱n ndó xi̱hi̱n mé da̱ xi̱hín ña̱ha vehe cán já cachi ndó já xi̱hi̱n dá: “Da̱ jána̱ha̱ nde̱he̱ cúú da̱ cáchí xu̱hu̱n: Ndáchí íin nu̱ú coo i̱ cajíni i̱ vicó pascua xi̱hín na̱ xíca tuun xi̱hín i̱.” ");
INSERT INTO mksNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A̱nda̱ já jána̱ha̱ mé da̱ cán in cuarto cáhnu ña̱ cánúu ji̱ni̱ véhe piso ni̱nu. Sa̱ íin tia̱hva va ña. Cán caja ndíví ndó ña̱ cajíní —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A̱nda̱ já na̱quee ndíví da̱ cán cua̱ha̱n da̱. Ta tá íin na̱cachi Jesús xi̱hi̱n dá coo quia̱hva já ndusa na̱sahi̱in. Ta chí na̱caja ndíví da̱ tócó ndihi ña̱ cajíni na vicó pascua. ");
INSERT INTO mksNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tá na̱xi̱nu̱ co̱o hora cajíni na já na̱saco̱o Jesús xi̱hi̱n tócó ndihi na̱ xíca tuun xi̱hi̱n á nu̱ mesa. ");
INSERT INTO mksNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Sa̱ xíca̱ ndiva̱ha ini i̱ cajíni i̱ vicó pascua yóho xi̱hi̱n ndó nani íin tóo i̱ xi̱hi̱n ndo̱ jáchi̱ va̱xi qui̱ví quivi i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Jáchi̱ mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ja̱nda̱ ná xi̱nu̱ qui̱vi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi a̱nda̱ jáví cajíni tucu u̱ vicó pascua xi̱hi̱n ndo̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A̱nda̱ já na̱tiin a in vaso nu̱ ñúhu tó uva ta na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱. Ta já na̱cachi a já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Coho ndó dó ñúhu ini vaso yóho ta cahnda java ndó dó nu̱ táhan ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Jáchi̱ a̱ ndícó co̱o ga̱ i̱ coho i̱ tó uva ja̱nda̱ quia̱hva ná xi̱nu̱ co̱o qui̱vi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tá na̱ndihi na̱tiin a pan ta na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱ sa̱há. A̱nda̱ já na̱sahnda java ña̱ já na̱sa̱ha̱n ña̱ nu̱ú na̱ xíca tuun xi̱hi̱n á cán já na̱cachi a já xi̱hi̱n ná: —Mé pan yóho cúú á tátu̱hun yiquí cu̱ñu i̱ jáchi̱ ndiquia̱hva i̱ mí i̱ quivi i̱ sa̱há ndihi ndó. Xíní ñúhú caja ndó ña̱ yóho ña̱ ná ndicu̱hu̱n ini ndó ña̱ na̱xi̱hi̱ i̱ sa̱ha̱ ndo̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tá sa̱ na̱ndihi na̱xijíni na ta já na̱tiin a vaso nu̱ ñúhu tó uva ta já na̱cachi a já: —Dó ñúhu ini vaso yóho cúú dó tátu̱hun ni̱í i̱ jáchi̱ cahní na̱ ye̱he̱ ta cui̱ta̱ ni̱í i̱ sa̱ha̱ ndihi ndó. Ta xi̱hín ña̱ yóho xi̱nu̱ co̱o nu̱ú tu̱hun na̱sa̱ha̱n Ndióxi̱ nu̱ú ña̱yivi sa̱nahá tá na̱cachi a jáca̱cu a ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ʼCuni jo̱ho va̱ha ndó ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Nu̱ mesa yóho íin coo da̱ ji̱có túhún ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jáchi̱ ja̱nda̱ sa̱nahá na̱sacu ini Ndióxi̱ ña̱ ndítahan ndoho ini ye̱he̱, da̱ na̱chindahá mé á nduu ña̱yivi. Joo ndáhví na̱cuu da̱ ji̱có túhún ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Xi̱hín ña̱ na̱cachi Jesús yóho na̱casáhá na̱ xíca tuun xi̱hi̱n á cán ndáca̱ tu̱hún táhan na sa̱ha̱ ndá da̱ cúú da̱ sácú ini cu̱hu̱n ji̱có túhún ñahá. ");
INSERT INTO mksNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tá na̱ndihi já na̱casáhá ndítúhún i̱hvi̱ xi̱hi̱n táhan da̱ xíca tuun xi̱hi̱n Jesús cán sa̱há ndá da̱ cúú da̱ íin chága̱ sa̱ha̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sa̱há ña̱ cán quéa̱ na̱cachi Jesús já xi̱hín ndihi da̱ cán: —Ndijáá ñuyíví sáhndá rey chuun nu̱ú ña̱yivi tá quia̱hva cúni̱ mé dá. Ta jári cúni̱ da̱ ña̱ ná cachi ña̱yivi sa̱ha̱ dá ña̱ cúú dá da̱ cája va̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Joo co̱ó nditahan coo ña̱ cán tañu mé ndó. Ña̱ ndítahan caja ndó quéa̱ tá in ndó cúni̱ ndó cacuu ndó da̱ íin chága̱ sa̱ha̱, xíní ñúhú jánuu ndáha̱ ndó mé ndó tátu̱hun da̱ loho chága̱ nu̱ ndíhi ndó. Ta ndá da̱ cúni̱ cahnda chuun, xíní ñúhú cacuu da tátu̱hun in da̱ cája ndíví nu̱ mesa xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mé ndó sa̱ cánda̱a̱ va̱ha ini ndó ña̱ íin chága̱ sa̱há da̱ íin coo nu̱ mesa a̱ ju̱ú ga̱ da̱ cája ndíví ñahá. Joo ye̱he̱ na̱jánuu ndáha̱ i̱ mí i̱ ta na̱nduu u̱ tátu̱hun in da̱ cája ndíví nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ʼNdóhó cúú ndó na̱ na̱sanduu tuun xi̱hín i̱ nu̱ tócó ndihi ña̱ i̱hvi̱ na̱quixi nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sa̱há ña̱ cán quéa̱ tá quia̱hva na̱caja tátá i̱ ña̱ma̱ni̱ xi̱hín i̱ ña̱ ná cacomí i̱ cuéntá sa̱há ña̱yivi quia̱hva já caja i̱ ña̱ma̱ni̱ xi̱hi̱n ndó ");
INSERT INTO mksNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ña̱ ná nditútú ndó canduu ndó xi̱hín i̱ tá ná cacomí i̱ cuéntá sa̱há ña̱yivi. Ta já ná cuu caja vií ndo̱ sa̱há na̱ na̱quixi ndíhu̱xu̱ i̱vi̱ táhndá na̱ na̱quixi chi̱chi Israel —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","A̱nda̱ já na̱ndica̱ha̱n Jesús já na̱cachi a já xi̱hi̱n Pedro: —Simón, cuni jo̱ho va̱hún. Jáchi̱ na̱xi̱ca̱ Satanás, mé tiñáhá sa̱cua̱ha̱ ña̱ma̱ni̱ ña̱ ná coto ndojó rí tócó ndihi ndó tá quia̱hva jáxi̱xi na trigo. ");
INSERT INTO mksNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Joo sa̱ na̱xi̱ca̱ ta̱hví i̱ nu̱ Ndióxi̱ sa̱ha̱ yóhó, Simón já ná a̱ jándacoún ña̱ cándeé inún ye̱he̱. Ta tá sa̱ na̱ndicó co̱o inún xi̱hín ña̱ cajún ja̱n, ndítahan chindeún java ga̱ na̱ cándeé ini ye̱he̱ já ná coo nda̱cú na̱ íchi̱ cuéntá mí i̱ —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","A̱nda̱ já na̱nducú ñehe Pedro tu̱hun nu̱ Jesús já na̱cachi da já xi̱hi̱n á: —Cande̱hé ndo̱, xitoho i̱. Ye̱he̱ sa̱ íin tia̱hva i̱ cu̱hu̱n i̱ veca̱a xi̱hi̱n ndo̱. Ta ja̱nda̱ ná cahní na̱ ye̱he̱ xi̱hi̱n ndo̱ tá cúni̱ na̱ jáchi̱ sa̱ íin tia̱hva vi̱ —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Já na̱cachi Jesús já xi̱hi̱n dá: —Cande̱hé Pedro ná ca̱ha̱n i̱ ña̱ nda̱a̱ xu̱hu̱n. Mé qui̱ví viti tá cáma̱ni̱ cana chéle já u̱ni̱ tañu chije̱hé tu̱hún sa̱há i̱ ta ca̱hún ña̱ co̱ xíni̱ tohún ye̱he̱ —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tá na̱ndihi já na̱nda̱ca̱ tu̱hún Jesús na̱ xíca tuun xi̱hi̱n á cán já na̱cachi a já xi̱hi̱n ná: —Jihna na̱chindahá i̱ ndo̱hó cu̱hu̱n ndó ca̱ha̱n ndó tu̱hun Ndióxi̱ ta na̱cachi i̱ xi̱hi̱n ndo̱ ña̱ ná a̱ cáñehe ndó yátí ni jiu̱hún ta ni inga ndu̱sa̱ a̱ cáñehe ndó cu̱hu̱n xi̱hi̱n ndo̱. Á na̱ndima̱ní ña̱ha nu̱ ndo̱ tá na̱sa̱ha̱n ndo̱ já —na̱cachi Jesús xi̱hi̱n ná. Já na̱cachi na̱ já: —Ni in ña̱ha co̱ó na̱ndima̱ni̱ nu̱ú nde̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A̱nda̱ já na̱cachi tucu a já xi̱hi̱n ná: —Joo viti co̱ó ga̱ ña̱ cán coo. Viti cáchí i̱ xi̱hi̱n ndo̱ ña̱ tá íin yátí nu̱ ndo̱, xíní ñúhú cañehe ndó ña̱ cu̱hu̱n ndo̱. Cañehe ndó jiu̱hún ndo̱ tá ná quee ndó cu̱hu̱n ndo̱. Ta tá co̱ó machiti nu̱ ndó, xíní ñúhú ji̱có ndó jahmá ndeé ndo̱ já cueen ndó machiti ña̱ ná coo tia̱hva ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Jáchi̱ sa̱nahá na̱ca̱hyi̱ a̱ nu̱ libro yi̱i̱ Ndióxi̱ ta sa̱há ye̱he̱ na̱ca̱ha̱n tá na̱cachi a já: “Na̱cachi ña̱yivi cúú dá ta̱a quini sa̱há ña̱ cán quéa̱ na̱chitáhan na da̱ xi̱hín ña̱yivi quini.” Tócó ndihi ña̱ na̱ca̱hyi̱ nu̱ú tu̱hun Ndióxi̱ sa̱há ye̱he̱ sa̱nahá xíní ñúhú xi̱nu̱ co̱o a viti —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A̱nda̱ já na̱cachi na̱ xíca tuun xi̱hi̱n á cán já: —Cande̱hé ndo̱, xitoho nde̱. Yóho ñéhe nde̱ i̱vi̱ machiti —na̱cachi na. —Sa̱ íin va̱ha —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tá na̱ndihi já na̱quee Jesús cua̱ha̱n yúcu̱ yíto̱ Olivo nu̱ sá sa̱ha̱n tuun a ca̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱. Ta já ndíco̱ ndihi na̱ xíca tuun xi̱hi̱n á cán ja̱tá cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ta tá sa̱ na̱xi̱nu̱ co̱o na cán já na̱cachi a já xi̱hi̱n ná: —Ca̱ca̱ ta̱hví ndó nu̱ Ndióxi̱ já ná a̱ ndícava ndó nu̱ú cua̱chi tá ná coto ndojó tiñáhá ndo̱hó —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tá na̱ndihi já na̱tavá xóo Jesús mé á tañu na̱ cán já na̱sa̱ha̱n tátu̱hun in quia̱hva nu̱ xínu̱ co̱o in yu̱u̱ tá jání yó ña̱ xi̱hi̱n ndáha̱ yo̱. Quia̱hva já na̱caxícá mé á tañu na̱ cán já na̱caxítí a̱ xíca̱ ta̱hví a̱ nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Já na̱cachi a já: —Tátá Ndióxi̱, á cuu caja ndó ña̱ma̱ni̱ já ná a̱ ndóho i̱ ña̱ i̱hvi̱ ndiva̱ha ña̱ va̱xi nu̱ú i̱ ndoho i̱. Joo ná coo tá íin cúni̱ mé ndó ná a̱ cóo toho ña̱ cúni̱ ye̱he̱ —cáchí Jesús xíca̱ ta̱hví a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","A̱nda̱ já na̱canáha̱ in táto̱ Ndióxi̱ indiví já na̱xi̱nu̱ a̱ sáhan tu̱hun ndeé ini Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ta na̱casáhá ndóho ndiva̱ha ini Jesús jáchi̱ na̱cacuéha̱ ini a. Sa̱há ña̱ cán quéa̱ na̱nducú ndéé chága̱ ví a̱ xíca̱ ta̱hví a̱ nu̱ Ndióxi̱. Ta chí ndícaa mé te̱e̱n á nu̱ ñúhu̱ ta dó cán cúú dó tátu̱hun ni̱i̱ cúyu nu̱ ñúhu̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ta tá na̱ndihi na̱xi̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱ já na̱nda̱ca̱ ndichi a já na̱quee a cua̱ha̱n nu̱ ndúu na̱ xíca tuun xi̱hi̱n á cán. Ta na̱nditahan mé á na̱ ndúu na quíji̱ na̱. A̱ ju̱ú quia̱hva cándií ini na sa̱há ña̱ cán na̱naá ini na na̱qui̱ji̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A̱nda̱ já na̱cachi a já xi̱hi̱n ná: —Ndá cuéntá quéa̱ quíji̱ ndo̱ ndúu ndó. Cuáhán ndaco̱o ndó ta ca̱ca̱ ta̱hví ndó nu̱ Ndióxi̱ já ná a̱ ndícava ndó nu̱ú cua̱chi tá ná coto ndojó tiñáhá ndo̱hó —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ja̱nda̱ cáha̱n chá va Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán cándichi a já na̱xi̱nu̱ cua̱há ndiva̱ha ña̱yivi nu̱ íin a. Ta in táhan da̱ u̱xu̱ i̱vi̱ xíca tuun xi̱hi̱n á, da̱ naní Judas cán, da̱ cán cúú da̱ ndáca ñayivi va̱xi da. Ta na̱cayati da tatí yúhu̱ dá sa̱jóho Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Judas, tatí yúhu̱n sa̱jóho i̱ tátu̱hun da̱ quíhvi̱ ini ye̱he̱. Joo xi̱hín ña̱ cájún ja̱n ndíquia̱hvún ye̱he̱ ndahá na̱ co̱ cúní ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tá na̱xini tócó ndihi na̱ ndúu xi̱hi̱n Jesús cán ña̱ cúu já na̱casáhá ndáca̱ tu̱hún na̱ mé á já na̱cachi na já: —Á cúni̱ ndó, xitoho nde̱ ña̱ ná ndicui̱ta nde̱ xi̱hi̱n machiti cani táhan nde̱ xi̱hi̱n ná —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Joo in táhan da̱ xíca tuun xi̱hi̱n Jesús cán na̱jándicue̱he̱ da̱ in da̱ cúú mozo da̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán jáchi̱ na̱chitúhu̱n dá jo̱ho xoo cuáha da. ");
INSERT INTO mksNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Joo já na̱cachi Jesús já xi̱hi̱n ná: —Sa̱ íin va̱ha. A̱ cáni táhan ndó xi̱hi̱n ná —na̱cachi Jesús. Tá na̱ndihi já na̱cani ndaa ndáha̱ mé á jo̱ho mozo cán já na̱ndaja va̱ha mé á da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ta na̱casáhá cáha̱n Jesús xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán xi̱hín na̱ sa̱cua̱ha̱ nu̱ policía ndáá veñu̱hu xi̱hín na̱ sa̱cua̱há veñu̱hu cán, mé na̱ na̱casa̱a̱ tiin na Jesús já na̱cachi a já xi̱hi̱n ná: —Cája ndó xi̱hín i̱ tátu̱hun cája na xi̱hín ta̱a cui̱hná jáchi̱ na̱queta ndó va̱xi ndó tiin ndó ye̱he̱ xi̱hi̱n machiti ta xi̱hi̱n yíto̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Joo co̱ó a̱ ná caja toho ndó xi̱hín i̱ tá na̱sahi̱in i̱ tañu ndó veñu̱hu cán. Joo núná nu̱ ndó viti caja núu ndó jáchi̱ na̱sa̱ha̱n Ndióxi̱ ña̱ma̱ni̱ ña̱ ná tiin ndó ye̱he̱. Jáchi̱ na̱cuaá viti ta chíndeé tiñáhá sa̱cua̱ha̱ ndo̱hó caja ndó ña̱ núu —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","A̱nda̱ já na̱tiin na Jesús. Já ñéhe na a̱ cua̱ha̱n na̱ vehe da̱ cúú sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán. Ta xícá xícá ndíco̱ Pedro ja̱ta̱ ná cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ta tá na̱xi̱nu̱ co̱o ña̱yivi cán yuhú yéhé da̱ cúú sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán já na̱ndicahmi na ñúhu̱ na̱saco̱o na xítúní na̱. Já na̱xi̱nu̱ co̱o ri Pedro na̱saco̱o da tañu na̱ cán xítúní da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Joo ndaja coo in ñáñáha̱ cája chúun vehe ju̱tu̱ sa̱cua̱ha̱ cán na̱xini ñá íin coo da xítúní da̱ yávi̱ núhu̱ cán. Ta na̱casáhá sánde̱hé ñá nu̱ dá já cáchí ñá já: —Da̱ xíca tuun xi̱hi̱n Jesús cúú ri da̱ íin coo yóho va —na̱cachi ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Joo na̱casáhá Pedro chíje̱hé tu̱hun da já na̱cachi da já: —Cande̱hé, ñáñáha̱. Co̱ xíni̱ toho i̱ ndá da̱ cúú da̱ ja̱n —na̱cachi Pedro xi̱hi̱n ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chá va ta na̱xini inga da̱ta̱a Pedro ta já na̱cachi da já xi̱hi̱n dá: —In táhan da̱ xíca tuun xi̱hi̱n Jesús cáa cúú ri yóhó va —na̱cachi da̱ cán xi̱hi̱n Pedro. A̱nda̱ já na̱cachi Pedro já: —U̱hu̱n. A̱ ju̱ú toho táhan na̱ cán cúú ye̱he̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ta tá sa̱ na̱ya̱ha tátu̱hun in hora já na̱cachi inga da̱ta̱a já: —Mé a̱ nda̱a̱ da̱ xíca tuun xi̱hi̱n Jesús cúú ri da̱ yóho va jáchi̱ cúú dá da̱ estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","A̱nda̱ já na̱cachi Pedro já xi̱hi̱n dá: —Co̱ xíni̱ toho i̱ ndá sa̱ha̱ cáhu̱n —na̱cachi Pedro. Tá chí mé hora já nani cáha̱n Pedro xi̱hín da̱ta̱a cán já na̱cana chéle. ");
INSERT INTO mksNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A̱nda̱ já na̱ndicoto nihni Jesús na̱sande̱hé a̱ nu̱ Pedro. Tá na̱ndicu̱hu̱n ini Pedro sa̱há tu̱hun na̱cachi Jesús xi̱hi̱n dá tá cáma̱ní tiin na a̱ tá na̱cachi a já: “Mé qui̱vi̱ viti tá cáma̱ni̱ cana chéle já u̱ni̱ tañu chije̱hé tu̱hún sa̱há i̱ ta ca̱hún ña̱ co̱ xíni̱ tohún ye̱he̱”, na̱cachi a xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A̱nda̱ já na̱queta Pedro cua̱ha̱n da̱ já na̱casáhá sácu ndiva̱ha da. ");
INSERT INTO mksNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ta java da̱ta̱a, da̱ ndúu ndáá Jesús cán na̱casáhá da̱ sácu̱ ndaa da ña̱. Ta na̱cani ñahá da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na̱chicaji da nu̱u̱ á ta na̱cani da ja̱hndá nu̱u̱ á já na̱casáhá da̱ ndáca̱ tu̱hún da̱ mé á já cáchí da̱ já xi̱hi̱n á: —Cachi yo já na̱cani ja̱hndá nu̱u̱n —cáchí da̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ta cua̱há chága̱ nu̱ú ña̱ núu cáha̱n na̱ xi̱hi̱n á ña̱ cána̱há na̱ xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ta tá sa̱ na̱ti̱vi já na̱taca na̱ sa̱cua̱ha̱ nu̱ú na̱ Israel cán xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán xi̱hín na̱ jána̱ha̱ ley Moisés cán viti. Já ñéhe na Jesús cua̱ha̱n na̱ cavií sa̱há nu̱ú na̱ cán. Ta tá sa̱ na̱nditútú ndihi na̱ cán ndúu na já na̱nda̱ca̱ tu̱hún na̱ Jesús já na̱cachi na já xi̱hi̱n á: ");
INSERT INTO mksNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Ca̱xi tu̱hun xi̱hín nde̱ á cúún Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi —na̱cachi na xi̱hi̱n á. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Tá a̱ja̱n ná cachi i̱ xi̱hi̱n ndo̱ ta chí a̱ cándúsa toho ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ta cája i̱ cuéntá a̱ cáha̱n ndó xi̱hín i̱ tá ná nda̱ca̱ tu̱hún i̱ ndo̱hó. Ta cája i̱ cuéntá ni a̱ cándúsa ndó janí ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Joo viti sa̱ na̱tandaa qui̱ví cu̱hu̱n ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta coo i̱ xoo cuáha Ndióxi̱ indiví jáchi̱ íin ndée̱ mé á caja tócó ndihi ña̱ha —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","A̱nda̱ já na̱casáhá tócó ndihi na̱ cán ndáca̱ tu̱hún na̱ mé á já na̱cachi na já: —Á jivi ndusa yóhó cúún in túhún ji̱ní já ja̱hyi Ndióxi̱, dá já —na̱cachi na. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —A̱ja̱n. Jivi cúú u̱ tá íin cáchí ndó ja̱n —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","A̱nda̱ já na̱casáhá tócó ndihi na̱ cán cáha̱n na̱ já na̱cachi na já: —Co̱ ndítahan ndinducú chága̱ yó ña̱yivi cacuu testigo nu̱ú ña̱ cáha̱n da̱ yóho jáchi̱ sa̱ xíni̱ jo̱ho í ña̱ cáha̱n da̱ ta chíca̱a̱n da̱ cua̱chi ja̱ta̱ mé dá —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","A̱nda̱ já na̱nda̱ca̱ ndichi ndihi na̱ cán já ñéhe na Jesús na̱sa̱ha̱n na̱ nu̱ Pilato. ");
INSERT INTO mksNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ta cán na̱casáhá na̱ chíca̱a̱n na̱ cua̱chi ja̱tá já na̱cachi na já sa̱há: —Na̱tiin nde̱ da̱ yóho jáchi̱ xíca nuu da jándiva̱a̱ da̱ ña̱yivi ñuu nde̱. Cáchí da̱ ña̱ co̱ ndítahan toho nu̱ú nde̱ cha̱hvi nde̱ jiu̱hún cuéntá impuesto nu̱ú da̱ cómí cuéntá sa̱ha̱ yó ñuu Roma. Ta cáchí da̱ ña̱ mé dá cúú dá Cristo, da̱ chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. Ta cáchí da̱ cúú dá in rey —na̱cachi na̱ cán xi̱hi̱n Pilato. ");
INSERT INTO mksNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","A̱nda̱ já na̱nda̱ca̱ tu̱hún Pilato Jesús já na̱cachi da já xi̱hi̱n á: —Á mé a̱ nda̱a̱ cúún in rey, da̱ cómí cuéntá sa̱há na̱ Israel —na̱cachi da̱ cán xi̱hi̱n Jesús. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —A̱ja̱n. Jivi cúú u̱ tá quia̱hva cáchí ndó ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","A̱nda̱ já na̱ndica̱ha̱n Pilato xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán ta xi̱hín ña̱yivi ndúu cán já na̱cachi da já: —Co̱ ndíñe̱he̱ mí vi̱ ndá cua̱chi quéa̱ na̱caja da̱ yóho —na̱cachi Pilato. ");
INSERT INTO mksNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Joo ña̱yivi cua̱ha̱ cán na̱casáhá cáyuhú cóhó chága̱ na̱ já cáchí na̱ já: —Mé da̱ ja̱n na̱xi̱ca nuu da jándiva̱a̱ da̱ tócó ndihi ña̱yivi estado Judea xi̱hín ña̱ jána̱ha̱ da̱ nu̱ ná. Ta ja̱nda̱ Galilea na̱casáhá da̱ jándiva̱a̱ da̱ ña̱yivi. Ta viti na̱xi̱nu̱ da̱ ñuu nde̱ cája da já —na̱cachi ña̱yivi cáyuhú na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tá na̱xini jo̱ho Pilato ña̱ na̱cachi ña̱yivi cán já na̱nda̱ca̱ tu̱hún da̱ na̱ á cúú Jesús da̱ estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ta tá na̱cachi na ña̱ ndusa cúú Jesús da̱ estado Galilea já na̱chindahá Pilato Jesús ña̱ ná cu̱hu̱n a̱ nu̱ú Herodes, da̱ cúú gobernador nu̱ú ña̱yivi estado Galilea. Jáchi̱ mé tañu já na̱sahi̱in tóo da ñuu Jerusalén. ");
INSERT INTO mksNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tá na̱xini Herodes Jesús já na̱caji̱i̱ íní da̱ jáchi̱ sa̱ ja̱nda̱ jihna cuni da Jesús cúni̱ da̱. Jáchi̱ cua̱há tañu na̱ndicani ña̱yivi nu̱ dá sa̱há ña̱ cája Jesús. Ta cúni̱ da̱ cuni da ña̱ ná caja Jesús in ña̱ha xitúhún. ");
INSERT INTO mksNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ta cua̱há ndiva̱ha ña̱ha na̱nda̱ca̱ tu̱hún Herodes cán Jesús joo co̱ó na̱nducú ñehe a tu̱hun nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ta tañu ña̱yivi cán ñúhu ri na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jána̱ha̱ ley Moisés ta chí a̱ ju̱ú quia̱hva ndúcú ndéé na̱ chíca̱a̱n na̱ cua̱chi ja̱ta̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A̱nda̱ já na̱casáhá Herodes cája xíxi da xi̱hi̱n Jesús ta quia̱hva já cája ri na̱ cúú soldado da̱ cán xi̱hi̱n á. Ta na̱jácandixi na Jesús xi̱hi̱n jahmá lánda̱ tátu̱hun jáhma̱ sándixi in rey. Na̱caja na já xi̱hi̱n á jáchi̱ cúni̱ na̱ cua̱cu̱ ndaa ñahá na̱. Tá na̱ndihi já na̱chindahá tucu Herodes Jesús ña̱ ná cu̱hu̱n a̱ nu̱ Pilato. ");
INSERT INTO mksNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ta chí mé qui̱vi̱ já na̱ndique táhan máni̱ Herodes xi̱hi̱n Pilato jáchi̱ jihna co̱ cúní táhan toho da, nduu. ");
INSERT INTO mksNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","A̱nda̱ já na̱jánditaca Pilato na̱ cúú sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán xi̱hín na̱ jutixia xi̱hín java ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Já na̱cachi da já xi̱hi̱n ná: —Mé ndó ñéhe ndó da̱ yóho na̱casa̱a̱ da̱ nu̱ú i̱. Ta cáchí ndó ña̱ xíca nuu da jándiva̱a̱ da̱ ña̱yivi. Joo sa̱ na̱xini ndó ña̱ na̱ndaja ndíchí i̱ da̱ nu̱ ndo̱. Ta ni in túhún toho cua̱chi táhan ña̱ cáha̱n ndó sa̱ha̱ ja̱n co̱ó na̱nditahan i̱ nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ta ni Herodes co̱ó cua̱chi ná ndiñe̱he̱ ja̱ta̱ dá sa̱há ña̱ cán quéa̱ na̱nducú ñehe da da̱ nu̱ú i̱. Cuni jo̱ho va̱ha ndó: Co̱ó sa̱ha̱ cúú á ña̱ quivi da. ");
INSERT INTO mksNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ña̱ caja i̱ quéa̱ jándoho i̱ ini da̱. A̱nda̱ já janí vi̱ da̱ cu̱hu̱n da̱ —na̱cachi Pilato cán xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tañu víco̱ pascua cán na̱sahi̱in costumbre nu̱ Pilato janí da̱ in táhan da̱ ñúhu veca̱a ña̱ ná cando̱o va̱ha da nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sa̱há ña̱ cán quéa̱ na̱casáhá cáyuhú tócó ndihi ña̱yivi nu̱ dá já cáchí na̱ já: —Cahní ndó da̱ ja̱n ta janí ndó Barrabás nu̱ú nde̱ —cáchí na̱ cáyuhú na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mé Barrabás yóho ndáca̱a̱n da̱ veca̱a jáchi̱ na̱játaca cua̱ha̱ dá ña̱yivi ta na̱ndicui̱ta da xi̱hín na̱ sa̱cua̱ha̱ ñuu Jerusalén cán ta cúú dá da̱ sáhní ndi̱i. Sa̱há ña̱ cán quéa̱ ndáca̱a̱n da̱ veca̱a. ");
INSERT INTO mksNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Joo cúni̱ Pilato janí da̱ Jesús sa̱há ña̱ cán quéa̱ na̱ca̱ha̱n tucu da xi̱hín ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Joo ví ga̱ ví na̱casáhá na̱ cán cáyuhú cóhó na̱ nu̱ dá já cáchí na̱ já: —Cata caa ndó da̱ ndi̱ca crúxu̱. Cata caa ndó da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ta a̱nda̱ já na̱ca̱ha̱n tucu Pilato ña̱ cúú u̱ni̱ xi̱hi̱n ná já na̱cachi da já: —Co̱ó toho ña̱ núu na̱há na̱caja toho da̱ yóho. A̱ cu̱ú cahnda i̱ chuun ña̱ ná cahní na̱ da̱ jáchi̱ co̱ó cua̱chi da. Ña̱ caja i̱ quéa̱ cahnda i̱ chuun ña̱ ná jándoho na ini da. A̱nda̱ já janí vi̱ da̱ —na̱cachi Pilato. ");
INSERT INTO mksNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Joo ví ga̱ ví ndúcú ndéé na̱ cán cáyuhú na̱ ña̱ ná cata caa na Jesús ndi̱ca crúxu̱. Ta xi̱hín ña̱ ndúcú ndéé na̱ cán cáha̱n na̱ ta ndúcú ndéé ri na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán cáha̱n na̱. Sa̱há ña̱ cán quéa̱ na̱ta̱hnu̱ ini Pilato. ");
INSERT INTO mksNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ta na̱candúsa da caja da ña̱ cúni̱ na̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ta na̱janí da̱ Barrabás jáchi̱ da̱ cán na̱ca̱ha̱n mé ná sa̱ha̱ ña̱ ná ja̱ni̱ dá. Ta mé Barrabás yóho na̱sa̱ndaca̱a̱n da̱ veca̱a sa̱há ña̱ na̱jándiva̱a̱ da̱ ña̱yivi ta sa̱há ña̱ na̱sahní da̱ ndi̱i. A̱nda̱ já na̱ndiquia̱hva da Jesús nu̱ ná ña̱ ná caja na tá cúni̱ mé ná xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ta tá ñéhe na Jesús cua̱ha̱n na̱ cata caa na a̱ já na̱xini na in da̱ naní Simón, da̱ ñuu Cirene va̱xi da ndi̱hvi da ñuu Jerusalén. Ta já na̱jácu̱hu̱n ndáha̱ ná da̱ ña̱ ná ndacojo da crúxu̱ nu̱ú tacaa Jesús cán. Ta na̱ndi̱co̱ da̱ Jesús cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ta a̱ ju̱ú quia̱hva cua̱há ña̱yivi ndíco̱ ja̱tá cua̱ha̱n na̱. Ta cua̱há na̱ji̱hí sácu ndiva̱ha na ta cáyuhú na̱ cua̱ha̱n na̱ ja̱tá jáchi̱ táhnda̱ ini na sa̱há. ");
INSERT INTO mksNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Joo na̱ndicoto nihni Jesús nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Na̱ji̱hí, na̱ ñuu Jerusalén, a̱ cuácu toho ndó sa̱há ye̱he̱. Sa̱ha̱ mé va ndó ta sa̱há ja̱hyi ndó viti ndítahan cuacu ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Jáchi̱ va̱xi qui̱vi̱ já casáhá ña̱yivi cachi na já: “Ta̱hví na̱cuu na̱ji̱hí, na̱ co̱ó na̱cacu ja̱hyi. Ta ta̱hví na̱cuu na̱ co̱ó ja̱hyí chíchí”, cachi na jáchi̱ ndóho ndiva̱ha ini na. ");
INSERT INTO mksNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mé tiempo já casáhá ña̱yivi cachi na já: “Vá ná cu̱yu yúcu̱ ja̱ta̱ yo̱ já ná quiví”, cachi na. Ta cachi na xi̱hín java yúcu̱: “Chije̱hé ndó nde̱he̱”, já cachi na sa̱há ña̱ ndóho ndiva̱ha ini na. ");
INSERT INTO mksNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Cande̱hé ndo̱ ndá quia̱hva jándoho na ini i̱ ta cúú u̱ tátu̱hun in yitó cuíi̱, dó tácú. Ta cája xíxi na xi̱hín i̱ joo xíxi chága̱ caja na xi̱hi̱n ndóhó jáchi̱ cúú ndó tátu̱hun in yitó íchí —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ta tá ñéhe na Jesús cua̱ha̱n cata caa na a̱ ndi̱ca crúxu̱ já ñéhe ri na i̱vi̱ da̱ cúú da̱ quini cua̱ha̱n na̱ cata caa na da̱ já ná quivi da xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ta tá na̱xi̱nu̱ co̱o na in nu̱ú naní lásá yiquí jíní ndi̱i cán na̱cata caa na a̱ ndi̱ca crúxu̱. Ta na̱cata caa ri na i̱vi̱ da̱ quini cán va: in da xoo cuáha Jesús ta inga da xoo íti a. ");
INSERT INTO mksNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ta tá cáta caa na Jesús ndi̱ca crúxu̱ já na̱cachi a já: —Tátá Ndióxi̱ caja cáhnu ini ndó sa̱há ña̱ cája ña̱yivi yóho xi̱hín i̱. Jáchi̱ co̱ xíni̱ na̱ ndía̱ cája na —na̱cachi Jesús. Ta ndaja coo java soldado cán na̱casáhá da̱ sájíquí da̱ sa̱ha̱ jáhma̱ Jesús já quéa̱ ndá da̱ ná quee va̱ha ndiquehe da jáhma̱ á. ");
INSERT INTO mksNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ta ña̱yivi ndúu cán sánde̱hé na̱ nu̱ tácaa Jesús ndi̱ca crúxu̱ nani na̱ cúú jutixia na̱sacui̱ta na ndúu na sácu̱ ndaa ñahá cán já cáchí na̱ já: —Na̱jáca̱cu da java ga̱ ña̱yivi. Ta viti ná jáca̱cu da mé dá tá mé a̱ nda̱a̱ cúú dá Cristo, da̱ na̱ca̱xi Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi —cáchí na̱ sácu̱ ndaa ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ta jári java soldado sácu̱ ndaa da Jesús ndúu da. Ta na̱cayati da̱ cán nu̱ Jesús já na̱chiñee da vino, dó iyá yúhu̱ á ña̱ ná coho a do̱. ");
INSERT INTO mksNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ta já cáchí da̱ já cáyuhú da̱ nu̱ á: —Tá ta̱ mé a̱ nda̱a̱ cúún rey, da̱ cómí cuéntá sa̱há na̱ Israel chindeé mún já ná a̱ quívún —cáchí da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ta na̱chindaa na in tabla ndi̱ca crúxu̱ yati ji̱ni̱ Jesús ta nu̱ mé tabla cán na̱ca̱hyí na: “Da̱ yóho cúú rey nu̱ú na̱ Israel.” Ta mé ña̱ yóho na̱ca̱hyí na̱ ña̱ tu̱hun griego, ña̱ cáha̱n na̱ nación Grecia xi̱hín tu̱hun latín, ña̱ cáha̱n na̱ ñuu Roma xi̱hín tu̱hun hebrero, ña̱ cáha̱n na̱ Israel viti. ");
INSERT INTO mksNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ta in táhan da̱ quini tácaa ndi̱ca inga crúxu̱ yati jíi̱n á cán na̱casáhá da̱ cána̱há da̱ xi̱hi̱n á. Já cáchí da̱ já: —Tá mé a̱ nda̱a̱ cúún Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi chindeé mún já ná a̱ quívún. Ta chindeé nde̱he̱ já ná a̱ quíví nde̱ —cáchí da̱. ");
INSERT INTO mksNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Joo inga táhan da̱ quini tácaa inga xoo jíi̱n a̱ cán na̱casáhá da̱ jána̱ni da da̱ cáha̱n xi̱hi̱n Jesús cán já na̱cachi da já xi̱hi̱n dá: —Á co̱ yíhví tohún Ndióxi̱. Jáchi̱ in cúú yo̱ ndóho iní yóho ");
INSERT INTO mksNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","joo mé Jesús yóho co̱ó toho cua̱chi na̱caja da. Ta mé cuití ví ndítahan ndoho iní ña̱ ná cha̱hví sa̱há cua̱chi na̱caja í —na̱cachi da̱ cán jána̱ni da inga da̱ tácaa cán. ");
INSERT INTO mksNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tá na̱ndihi já na̱cachi da já xi̱hi̱n Jesús: —Jesús, caja ndó ña̱ma̱ni̱ ndicu̱hu̱n ini ndó sa̱há i̱ tá ná casáhá ndó cacomí ndó cuéntá sa̱há ña̱yivi —na̱cachi da xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xu̱hu̱n ña̱ mé qui̱vi̱ víti cu̱hún coún xi̱hín i̱ indiví —na̱cachi a xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ta tátu̱hun ca̱xi̱vi̱ já na̱canaá níí cúú ñuyíví. Ta ja̱nda̱ ca̱a̱ u̱ni̱ sa̱hini já na̱casáhá na̱ndiye̱he̱ tucu. ");
INSERT INTO mksNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Na̱naá nu̱ú ca̱ndii. Ta ja̱nda̱ já na̱nda̱tá java nda̱a̱ jáhma̱ ndeé ña̱ tácaa veñu̱hu cáhnu ñuu Jerusalén ña̱ sájí nuu nu̱ú yi̱í ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A̱nda̱ já na̱cayuhú cóhó Jesús já cáchí a̱ já: —Tátá Ndióxi̱, ndáha̱ mé ndó jándacoo i̱ ínima̱ i̱. Ta tá na̱cachi a ña̱ yóho já na̱xi̱hi̱ va. ");
INSERT INTO mksNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ta ndaja coo da̱ sáhndá chuun nu̱ú soldado cuéntá Roma cán tá na̱xini da tócó ndihi ña̱ na̱ya̱ha yóho já na̱casáhá cája cáhnu da Ndióxi̱ já na̱cachi da já: —Mé a̱ nda̱a̱ táhyí co̱ó toho cua̱chi da̱ yóho —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ta tócó ndihi ña̱yivi na̱sa̱nduu cán, na̱ na̱xini nu̱ú na̱xi̱hi̱ Jesús ja̱ndá joho cáni na̱ yi̱ca ndícá na̱ sa̱há ña̱ táhnda̱ ini na sa̱ha̱ Jesús já cuanúhu̱ va na. ");
INSERT INTO mksNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Joo tócó ndihi na̱ xíní táhan xi̱hi̱n Jesús na̱cando̱o na ndíta xícá na̱ sánde̱hé na̱. Ta tañu na̱ cán na̱sa̱nduu ri na̱ji̱hí táhan na̱ na̱quixi xi̱hi̱n á ja̱nda̱ estado Galilea cán. ");
INSERT INTO mksNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ta ndaja coo na̱sahi̱in in da̱ta̱a naní José, da̱ ñuu Arimatea ña̱ ndáca̱a̱n estado Judea cán. Ta cúú dá in ta̱a va̱ha, da̱ cája ña̱ nda̱a̱ cuití va. Ta cúú da in táhan na̱ cómí cuéntá sa̱há na̱ Israel. ");
INSERT INTO mksNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mé José yóho co̱ó na̱tahan ini da xi̱hín ña̱ na̱caja java ga̱ na̱ cán jáchi̱ ndáti da casa̱a̱ qui̱vi̱ cacomí Ndióxi̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ta na̱sa̱ha̱n da̱ ca̱ha̱n nda̱hví da̱ xi̱hi̱n Pilato ña̱ ná ndiquia̱hva da yiquí cu̱ñu Jesús nu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ta chí na̱sa̱ha̱n Pilato ña̱ma̱ni̱ nu̱ dá chí na̱sa̱ha̱n da̱ na̱jánuu da yiquí cu̱ñu Jesús ndi̱ca crúxu̱ cán. Já na̱chitíví ñahá da̱ xi̱hi̱n jáhma̱ va̱ha ta já na̱chica̱a̱n ñahá da̱ ini in yávi̱ ndáca̱a̱n ndi̱ca cáva̱. Ta ni in túhún toho ndi̱i a̱ ñáha chíca̱a̱n na̱ ini mé cáva̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mé qui̱vi̱ cán na̱sacuu a qui̱vi̱ cája ndíví ña̱yivi ña̱ha vehe na jáchi̱ ja̱ chá cacuu a qui̱vi̱ ndíquehe ndée̱ ná sa̱há ña̱ cán quéa̱ ndíhi ini na jáxi̱nu̱ na̱ chuun cája na. ");
INSERT INTO mksNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ta na̱ji̱hí, na̱ na̱sa̱ndi̱co̱ ja̱ta̱ Jesús ja̱nda̱ tá na̱quixi a chí estado Galilea cán na̱sa̱ha̱n na̱ sánde̱hé na̱ ndi̱ca cáva̱ nu̱ú na̱jáque̱ta nuu na yiquí cu̱ñu Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ta tá na̱sa̱a̱ na̱ vehe na já na̱caja ndíví na̱ perfume xi̱hín java ga̱ ña̱ha támi sáha̱n ña̱ ná jándicuchu na yiquí cu̱ñu Jesús. Ta inga qui̱ví ita̱a̱n na̱ndiquehe ndée̱ ná tá quia̱hva na̱sahnda Ndióxi̱ caja na ja̱nda̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ta tá sa̱ na̱ya̱ha qui̱vi̱ ndíquehe ndée̱ ná ta naha chá qui̱vi̱ domingo já na̱quee tucu na̱ji̱hí cán cua̱ha̱n na̱ nu̱ú na̱chica̱a̱n na̱ yiquí cu̱ñu Jesús ini cáva̱ cán. Já ñéhe na perfume, dó na̱caja tia̱hva na cán. Ta ndáca táhan java ga̱ na̱ji̱hí xi̱hi̱n ná cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ta tá na̱xi̱nu̱ co̱o na cán já na̱xini na ña̱ co̱ó ga̱ yu̱u̱ ndájí ndaa yuhú cáva̱ nu̱ú na̱sa̱ndaca̱a̱n yiquí cu̱ñu Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","A̱nda̱ já na̱qui̱hvi na ini cáva̱ cán joo co̱ó ga̱ yiquí cu̱ñu Jesús na̱nditahan na. ");
INSERT INTO mksNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ta chí na̱yi̱hví na̱ ta co̱ xíni̱ na̱ ndía̱ caja na. Ta jo̱náá va na̱xini na ndíta i̱vi̱ da̱ta̱a yati jíi̱n ná. Ta a̱ ju̱ú quia̱hva ndató yéhe̱ jáhma̱ ndíxi da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ta chí a̱ ju̱ú quia̱hva yíhví na̱ji̱hí já na̱candayi na ja̱nda̱ quia̱hva na̱xi̱nu̱ ji̱ni̱ ná nu̱ ñúhu̱. A̱nda̱ já na̱cachi da̱ta̱a cán já xi̱hi̱n ná: —Co̱ ndítahan toho ndinducú ndo̱ in da̱ tácú tañu nu̱ sánduu ndi̱i. ");
INSERT INTO mksNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Co̱ó toho Jesús íin yóho jáchi̱ sa̱ na̱nditacu va. Xíní ñúhú ndicu̱hu̱n ini ndó ña̱ na̱cachi a xi̱hi̱n ndo̱ tá na̱sahi̱in a estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mé á cúú á da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta sa̱ na̱cachi a xi̱hi̱n ndo̱ ña̱ ndiquia̱hva na mé á ndahá ña̱yivi quini. Ta na̱cachi a xi̱hi̱n ndó ña̱ cata caa na a̱ ndi̱ca crúxu̱ ta tá ná xi̱nu̱ u̱ni̱ qui̱ví já nditacu tucu a —na̱cachi da̱ta̱a cán. ");
INSERT INTO mksNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","A̱nda̱ já na̱ndicu̱hu̱n ini na̱ji̱hí cán ña̱ na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chí na̱quee na cua̱ha̱n na̱ já na̱ndicani ndihi na sa̱há ña̱ yóho nu̱ú na̱ u̱xu̱ in na̱xi̱ca tuun xi̱hi̱n Jesús xi̱hín nu̱ú java ga̱ na̱ ndúu cán viti. ");
INSERT INTO mksNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mé na̱ji̱hí cán, na̱ na̱sa̱ha̱n cáxi tu̱hun ña̱ yóho nu̱ú na̱ apóstol cán na̱sa̱cuu María, ñá ñuu Magdala xi̱hi̱n Juana xi̱hi̱n María, ñá cúú náná Jacobo xi̱hín java ga̱ na̱ji̱hí. ");
INSERT INTO mksNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Joo na̱ apóstol, na̱ na̱xi̱ca tuun xi̱hi̱n Jesús cán na̱ca̱hán na̱ ña̱ cuéntó uun va que̱á. Sa̱há ña̱ cán quéa̱ co̱ó na̱xeen na candúsa na ña̱ na̱cachi na̱ji̱hí cán xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Joo ndaja coo na̱queta Pedro xínu da cua̱ha̱n da̱ sánde̱hé da̱ ini cáva̱ nu̱ú na̱chica̱a̱n na̱ yiquí cu̱ñu Jesús cán. Na̱xini da jáhma̱ va̱ha ña̱ na̱sativí a̱ cán joo co̱ó toho yiquí cu̱ñu a. Ta chí na̱catóntó da̱ na̱quee da cuanúhu̱ dá vehe da. ");
INSERT INTO mksNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta mé qui̱vi̱ já i̱vi̱ táhan na̱ cúú cuéntá Jesús na̱quee na cua̱ha̱n na̱ in ñuu naní Emaús. Mé ñuu cán ñéhe táhan tátu̱hun u̱xu̱ in kilometro xi̱hín ñuu Jerusalén. ");
INSERT INTO mksNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ta ndítúhún na̱ cán cása̱ha̱n na̱ sa̱ha̱ tócó ndihi ña̱ na̱cuu ñuu Jerusalén cán. ");
INSERT INTO mksNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ta nani ndítúhún na̱ cása̱ha̱n na̱ já na̱cayati Jesús nu̱ ná já na̱casáhá xíca mé á xi̱hi̱n ná cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ta va̱tí sánde̱hé na̱ cán nu̱ Jesús joo co̱ó na̱cuu ndicuni na mé á. ");
INSERT INTO mksNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús na̱ cán já na̱cachi a já: —Ndía̱ ndítúhún ndó cása̱ha̱n ndo̱. Ta ndava̱ha cácuéha̱ ini ndó cása̱ha̱n ndo̱ —na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Já in táhan na̱ cán, da̱ naní Cleofas na̱nducú ñehe da tu̱hun nu̱ á já na̱cachi da já: —Níí cúú va na̱ndicui̱ta nuu tu̱hun sa̱há ña̱ na̱cuu ñuu Jerusalén tañu qui̱vi̱ yóho. In túhún yóhó tañu na̱ ndúu cán cúú da̱ co̱ xíni̱ ña̱ na̱ya̱ha —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ndía̱ na̱cuu, va̱ha. Já na̱cachi na̱ cán já xi̱hi̱n á: —Na̱quixi in da̱ naní Jesús chí ñuu Nazaret ta na̱sacuu da in profeta cáhnu ndiva̱ha jáchi̱ cua̱há ndiva̱ha ña̱ náhnu na̱ca̱ha̱n da̱. Ta cua̱há ndiva̱ha ña̱ náhnu na̱caja da nu̱ Ndióxi̱ xi̱hín nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Joo na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ jutixia ñuu nde̱ na̱tiin na mé Jesús ta já na̱ndiquia̱hva na da̱ ña̱ ná cahní na̱ da̱ ta já na̱cata caa na da̱ ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Joo mé nde̱ na̱ca̱hán nde̱ ña̱ mé Jesús cán cacuu da da̱ ndáti nde̱ chindeé da̱ nde̱he̱, na̱ Israel yóho já ná a̱ cája xíxi ga̱ na̱ ñuu Roma xi̱hín nde̱, na̱ca̱hán nde̱. Joo na̱ndihi va viti jáchi̱ sa̱ na̱ya̱ha u̱ni̱ qui̱vi̱ na̱xi̱hi̱ da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Va̱tí na̱que̱ta java na̱ji̱hí tañu nde̱ yóho na̱jáyi̱hví na̱ nde̱he̱ jáchi̱ naha chá na̱sa̱ha̱n na̱ nu̱ú na̱ndu̱xu̱ Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ta cáchí na̱ ña̱ co̱ó ga̱ yiquí cu̱ñu Jesús ndáca̱a̱n cán. Sa̱há ña̱ cán quéa̱ na̱xi̱nu̱ na̱ nu̱ú na̱sanduu nde̱ ta na̱ndicani na nu̱ú nde̱ ña̱ na̱canáha̱ java táto̱ Ndióxi̱ nu̱ ná ta na̱cachi na ña̱ tácú va Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ta java táhan da̱ xíca tuun xi̱hín nde̱ cán na̱sa̱ha̱n da̱ sánde̱hé da̱ ini cáva̱ cán ta chí já ndusa cáa tá quia̱hva cáchí na̱ji̱hí. Ta co̱ mé Jesús na̱xini na —na̱cachi na̱ cán xi̱hi̱n Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ cán: —Ña̱yivi tóntó ndiva̱ha cúú ndó. Jáchi̱ yáncá ndiva̱ha já xínu̱ ini ndó candúsa ndó ña̱ nda̱a̱ ña̱ na̱ca̱ha̱n na̱ profeta sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Á co̱ cánda̱a̱ ini ndó ña̱ jihna ñúhú na̱nditahan nu̱ú da̱ cúú Cristo ndoho ini da ta tá sa̱ na̱ndihi já ndiñehe jícó Ndióxi̱ da̱ já ndacojo da chuun cacomí da̱ cuéntá sa̱há ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A̱nda̱ já na̱casáhá ndícani a nu̱ ná ña̱ na̱ca̱hyi̱ nu̱ú tu̱hun Ndióxi̱ nu̱ cáha̱n sa̱ha̱ tócó ndihi ña̱ ndítahan ndoho da̱ cúú Cristo. Na̱casáhá ndícani a ja̱nda̱ libro na̱ca̱hyí Moisés sa̱nahá ja̱nda̱ quia̱hva na̱xi̱nu̱ a̱ nu̱ tócó ndihi libro ña̱ na̱ca̱hyí na̱ profeta sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ta tá na̱xi̱nu̱ co̱o na ñuu nu̱ú cua̱ha̱n na̱ cán já na̱caja Jesús tátu̱hun yáha saa cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Joo mé na̱ cán na̱caja ndúsa̱ ná xi̱hi̱n á ña̱ ná coo tóo a xi̱hi̱n ná. Já na̱cachi na já xi̱hi̱n á: —Yóho cando̱o ndó coo tóo ndó jáchi̱ sa̱ na̱hini cuíí va ta ja̱ chá cuaá —na̱cachi na xi̱hi̱n á. A̱nda̱ já na̱qui̱hvi Jesús ini vehe ña̱ cando̱o a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ta tá na̱saco̱o a nu̱ mesa xi̱hi̱n ná já na̱tiin a in pan já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱ sa̱há. Ta na̱sahnda java ña̱ já na̱sa̱ha̱n ña̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ta chí i̱vi̱ la̱á na̱nu̱na̱ xíní túni̱ ná ta já na̱ndicuni na mé á ña̱ cúú á Jesús. Joo i̱vi̱ la̱á na̱jándiñúhú a̱ mé á nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","A̱nda̱ já na̱cachi xi̱hín táhan na já: —Íchi̱ quéa̱ cáji̱i̱ ndiva̱ha iní tá na̱ndicani Jesús tu̱hun Ndióxi̱ nu̱ yo̱ tá va̱xí íchi̱ xi̱hi̱n á —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chí i̱vi̱ la̱á na̱quehe tucu na íchi̱ ña̱ ndicó co̱o tucu na ñuu Jerusalén. Tá na̱xi̱nu̱ na̱ cán na̱ndiñe̱he̱ ná ña̱ ndítútú ndíhu̱xu̱ in táhan na̱ na̱xi̱ca tuun xi̱hi̱n Jesús cán ndúu na xi̱hín java ga̱ na̱ ndúu cán. ");
INSERT INTO mksNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","A̱nda̱ já na̱cachi na̱ cán xi̱hi̱n ndíví na̱ yóho: —Mé a̱ nda̱a̱ táhyí na̱nditacu tucu Jesús, xitoho í. Ta na̱xini Simón mé á —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A̱nda̱ já na̱casáhá ndíví na̱ cán ndícani na ña̱ na̱sandaca táhan na xi̱hi̱n Jesús na̱sa̱ha̱n na̱. Ta na̱ndicani na ña̱ na̱ndicuni na mé á nani na̱sahnda java mé á pan ña̱ cuxu na. ");
INSERT INTO mksNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ta nani ndítúhún yi̱i̱ ná ndúu na já na̱xi̱nu̱ co̱o Jesús na̱nda̱ca̱ ndichi a ma̱hñú na̱ cán já na̱ca̱ha̱n Ndióxi̱ á xi̱hi̱n ná já na̱cachi a já: —Ná caja Ndióxi̱ ña̱ ná coo va̱ha ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Joo na̱yi̱hví na̱ cán ta na̱ca̱hán na̱ ña̱ cúú á in ínima̱ ndi̱i va. ");
INSERT INTO mksNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Joo já na̱cachi Jesús já: —Ndá cuéntá quéa̱ yíhví ndo̱. Ta ndá cuéntá quéa̱ co̱ cándúsa ndó ña̱ cúú ye̱he̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cande̱hé ndó ndahá i̱ ta cande̱hé ndó sa̱há i̱. Sa̱ mé ye̱he̱ cúú vi̱. Cani ndaa ndáha̱ ndó ye̱he̱ ta cande̱hé va̱ha ndó ye̱he̱. Jáchi̱ in ínima̱ ndi̱i co̱ó toho yiquí cu̱ñu a tá quia̱hva sánde̱hé ndó ña̱ íin yiquí cu̱ñu ye̱he̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ta nani cáha̱n Jesús xi̱hi̱n ná já na̱casáhá náha̱ ndáha̱ á xi̱hi̱n sa̱há nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Joo cáma̱ní yií candúsa na̱ cán ña̱ cúú mé á Jesús jáchi̱ na̱catóntó na̱ ta cáji̱i̱ ndiva̱ha ini na ña̱ cán quéa̱ na̱cachi tucu Jesús já xi̱hi̱n ná: —Ndá ña̱ha íin nu̱ ndó ná cuxu u̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","A̱nda̱ já na̱sa̱ha̱n na̱ in túhu̱n ti̱yacá na̱yata nu̱ á xi̱hi̱n in ñi̱má ñu̱ñu̱ nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Já na̱tiin a ña̱ ndáha̱ ná já na̱xixi a ña̱ nani sánde̱hé na̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tá na̱ndihi já na̱cachi a já xi̱hi̱n ná: —Sa̱ na̱ya̱ha tá íin na̱cachi i̱ xi̱hi̱n ndó jihna. Sa̱ na̱xi̱nu̱ co̱o tá íin na̱ca̱hyí Moisés xi̱hín na̱ profeta sa̱nahá sa̱há ña̱ ndítahan ndoho i̱. Ta jári David tá na̱ca̱hyí da̱ libro Salmos já na̱ca̱ha̱n ri da̱ cán va sa̱há ña̱ ndoho i̱ —na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","A̱nda̱ já na̱caja Jesús ña̱ ná ndinu̱na̱ xíní túni̱ ná já ná canda̱a̱ ini na ña̱ cúni̱ cachi tu̱hun Ndióxi̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ta na̱cachi a já xi̱hi̱n ná: —Ja̱nda̱ sa̱nahá na̱ca̱hyi̱ ña̱ ndítahan quivi ye̱he̱, da̱ cúú Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. Joo na̱ca̱hyi̱ ri ña̱ ndítahan nditacu tucu u̱ qui̱ví u̱ni̱. ");
INSERT INTO mksNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ña̱ cán quéa̱ ndítahan nu̱ú ña̱yivi caca nuu na ca̱ha̱n na̱ tu̱hun va̱ha sa̱há i̱ níí cúú ñuyíví já ná ndicó co̱o ini ña̱yivi ta jándacoo na cua̱chi cája na. A̱nda̱ já caja cáhnu ini Ndióxi̱ sa̱há ndihi cua̱chi na. Ta ja̱nda̱ ñuu Jerusalén xíní ñúhú ña̱yivi casáhá na̱ ca̱ha̱n na̱ tu̱hun va̱ha sa̱há i̱ ta já cu̱hu̱n na̱ ja̱nda̱ ndijáá ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ta ndóhó cúú na̱ na̱xini ndaja cáa ña̱ na̱ndoho i̱ ña̱ cán quéa̱ ndítahan nu̱ ndó cu̱hu̱n ndó ca̱xi tu̱hun ndó tócó ndihi ña̱ yóho nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cuni jo̱ho va̱ha ndó jáchi̱ chindahá i̱ ínima̱ yi̱i̱ Ndióxi̱ já ná cañuhu a ini in in ndó. Jáchi̱ quia̱hva já na̱cachi Ndióxi̱, tátá i̱ tá na̱sa̱ha̱n tu̱hun a nu̱ ndo̱. Joo ndítahan canduu ndihi ndó ñuu Jerusalén yóho ja̱nda̱ quia̱hva ná ndicutú nda̱a̱ ínima̱ ndo̱ xi̱hi̱n ndée̱ Ndióxi̱ ña̱ quixi indiví —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","A̱nda̱ já ndáca Jesús na̱ cán na̱sa̱ha̱n na̱ xi̱hi̱n á yuhú ñuu Betania. Ta na̱ndiñehe a ndáha̱ á já na̱caja yi̱i̱ á na̱. ");
INSERT INTO mksNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ta tá cája yi̱i̱ á na̱ já na̱tavá xóo a mé á já na̱ndaa cua̱ha̱n indiví. ");
INSERT INTO mksNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tá na̱ndihi na̱caja cáhnu na̱ cán Jesús já cávatá ndiva̱ha na na̱ndicó co̱o na ñuu Jerusalén. ");
INSERT INTO mksNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ta níí tiempo na̱sa̱nduu tuun na veñu̱hu cáhnu cája cáhnu na Ndióxi̱. Já ná coo.");
INSERT INTO mksNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tá na̱ca̱va̱ sáhá sa̱ha̱ ñuyíví sa̱ íin va mé á naní tu̱hun Ndióxi̱. Na̱sahi̱in mé á xi̱hi̱n Ndióxi̱ ta in cúú mé á xi̱hi̱n Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ta ja̱nda̱ mé sa̱ha̱ sa̱ íin va xi̱hi̱n Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ta mé a̱ cán cúú á Jesucristo ta na̱caja Ndióxi̱ ña̱ na̱cava̱ha mé á tócó ndihi ña̱ha. Ta ni in túhún toho ña̱ha íin, a̱ cóo tá ná a̱ cáva̱ha mé á ña̱, nduu. ");
INSERT INTO mksNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ta mé á quéa̱ cája ña̱ ná catacu tócó ndihi ña̱ha ta mé á jándiyéhe̱ a̱ ínima̱ ña̱yivi já ná ndicuni na yo cúú mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mé Jesucristo cúú á tátu̱hun in ñúhu̱ cáyi̱ ña̱ jándiyéhe̱ a̱ xoo naá ta a̱ cu̱ú nda̱hva̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ta ndaja coo na̱chindahá Ndióxi̱ in da̱ta̱a naní Juan. ");
INSERT INTO mksNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Na̱quixi da ca̱xi tu̱hun da xi̱hín ña̱yivi ña̱ cúú Jesucristo ña̱ jándiyéhe̱ ínima̱ ña̱yivi, na̱ ndúu nu̱ú naá já ná cuu candúsa na mé á sa̱há ña̱ na̱ca̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mé Juan yóho co̱ cúú dá mé á jándiyéhe̱ ínima̱ ña̱yivi. Na̱quixi cuití da̱ ca̱xi tu̱hun da xi̱hín ña̱yivi ña̱ mé Jesucristo quéa̱ jándiyéhe̱ ínima̱ ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mé Jesucristo na̱xi̱nu̱ a̱ ñuyíví yóho ta cúú ndusa mé a̱ ña̱ jándiyéhe̱ ínima̱ tócó ndihi ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na̱quixi mé a̱ naní tu̱hun Ndióxi̱ ta na̱sahi̱in a ñuyíví yóho. Ta xi̱hín ña̱ na̱caja Jesucristo na̱cava̱ha Ndióxi̱ ñuyíví. Joo ña̱yivi ndúu ñuyíví yóho co̱ó na̱xeen na canda̱a̱ ini na yo cúú mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Na̱quixi Jesucristo ñuyíví ña̱ na̱cava̱ha mé á joo na̱ ñuu mé á co̱ó na̱xeen toho na ndique̱he va̱ha na mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Joo ndá na̱ ná ndiquehe va̱ha mé á ta candeé ini na mé á já quéa̱ sáhan mé á ña̱ma̱ni̱ nu̱ ná ña̱ ná nduu na na̱ cúú cuéntá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ta na̱ cán cúú na̱ na̱nduu ja̱hyi mé á. Ta co̱ cúú á sa̱há ña̱ na̱cacu na ñuyíví yóho ta ni co̱ cúú á sa̱há ña̱ cúni̱ in ta̱a cacu in ja̱hyi da. Na̱nduu na ja̱hyi mé á jáchi̱ já na̱sacu ini mé á coo. ");
INSERT INTO mksNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mé Jesucristo, mé a̱ naní tu̱hun Ndióxi̱ cán na̱nduu a in ta̱a ta na̱quixi a na̱sahi̱in a tañu nde̱. Ta tócó ndihi ña̱ na̱sacaja mé á na̱sa̱cuu a ña̱ nda̱a̱. Ta a̱ ju̱ú quia̱hva quíhvi̱ ini a ña̱yivi. Ta na̱xini nde̱ ndá quia̱hva cáhnu cúú mé á jáchi̱ sa̱há ña̱ cúú mé á in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ sa̱há ña̱ cán quéa̱ na̱caja Ndióxi̱ ña̱ ná ndicáhnu ndiva̱ha mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Tá na̱ndicani mé Juan sa̱há Jesús nu̱ú ña̱yivi já na̱cachi da já sa̱ha̱ mé á: —Mé a̱ yóho cúú á ña̱ na̱ca̱ha̱n i̱ sa̱há nu̱ ndo̱ tá na̱cachi i̱ xi̱hi̱n ndo̱ ña̱ va̱xi inga a̱ ja̱tá ye̱he̱. Ta na̱cachi i̱ xi̱hi̱n ndo̱ ña̱ íin chága̱ sa̱ha̱ mé a̱ cán a̱ ju̱ú ga̱ ye̱he̱ jáchi̱ ja̱nda̱ tá cáma̱ní yi̱í cacu u̱ sa̱ íin va mé á —na̱cachi Juan. ");
INSERT INTO mksNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ta sa̱há ña̱ íin ndiva̱ha ña̱ma̱ni̱ nu̱ mé á sa̱há ña̱ cán quéa̱ a̱ ju̱ú quia̱hva ñéhe̱ táhvi̱ tócó ndihí nu̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Na̱ca̱hyí Moisés ley Ndióxi̱ sa̱nahá. Joo Jesucristo, mé á cúú á ña̱ nda̱a̱ na̱quixi a ñuyíví yóho sa̱há ña̱ quíhvi̱ ndiva̱ha ini a mí. ");
INSERT INTO mksNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ta ni in túhún toho ña̱yivi co̱ó na̱xini na Ndióxi̱. In túhún Jesucristo, mé á cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱, mé a̱ cán quéa̱ xíni̱ ndá quia̱hva íin Ndióxi̱ jáchi̱ in cúú á xi̱hi̱n á ta mé a̱ quéa̱ na̱na̱ha̱ ña̱ yóho nu̱ yo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ta ndaja coo java na̱ sa̱cua̱ha̱ nu̱ú na̱ Israel, na̱ ndúu ñuu Jerusalén cán na̱chindahá na̱ java ju̱tu̱ xi̱hín java na̱ na̱quixi chi̱chi Leví nu̱ íin Juan ña̱ ná nda̱ca̱ tu̱hún na̱ da̱ á cúú dá da̱ na̱sa̱ha̱n Ndióxi̱ tu̱hun a chindahá a̱ ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ta cáxí táhyí na̱ca̱ha̱n Juan xi̱hi̱n ná ña̱ co̱ cúú dá da̱ cán ta já na̱cachi da já: —A̱ ju̱ú toho ye̱he̱ cúú da̱ na̱cachi Ndióxi̱ chindahá a̱ cacomí cuéntá sa̱há ña̱yivi —na̱cachi Juan. ");
INSERT INTO mksNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","A̱nda̱ já na̱nda̱ca̱ tu̱hún tucu na da̱ já na̱cachi na já xi̱hi̱n dá: —Yo já cúú yóhó, dá já. Á a̱ ju̱ú yóhó cúú profeta Elías —na̱cachi na. —A̱ ju̱ú toho ye̱he̱ cúú profeta Elías —na̱cachi Juan. A̱nda̱ já na̱cachi tucu na já xi̱hi̱n dá: —Á a̱ ju̱ú toho yóhó cúú profeta da̱ na̱cachi Ndióxi̱ chindahá a̱, dá já —na̱cachi na. Joo na̱nducú ñehe Juan tu̱hun nu̱ ná já na̱cachi da já xi̱hi̱n ná: —Ni in túhún toho da cáchí ndó ja̱n co̱ cúú ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","A̱nda̱ já na̱cachi tucu na já xi̱hi̱n dá: —Ndítahan ndicani lohún nu̱ú nde̱ yo cúú yóhó. Jáchi̱ java na̱ na̱chindahá na̱ nde̱he̱ ña̱ ná quixi nde̱ nda̱ca̱ tu̱hún nde̱ yo̱hó. Ta tá co̱ cúnu̱n ca̱xi tu̱hún xi̱hín nde̱ yo cúú yóhó, ndá cu̱hu̱n nde̱ quehe nde̱ tu̱hun nducú ñehe nde̱ nu̱ú na̱ na̱chindahá nde̱he̱ cán —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A̱nda̱ já na̱cachi Juan já xi̱hi̱n ná: —Ye̱he̱ cúú da̱ xíca nuu tañu yucú íchí ta cáyuhú cóhó i̱ já cáchí i̱ já xi̱hín ña̱yivi: “Cuná ndó in íchi̱ nda̱cú nu̱ mé á ña̱ ná ndi̱hvi a ínima̱ ndo̱” —na̱cachi Juan xi̱hi̱n ná tá quia̱hva na̱ca̱hyí profeta Isaías sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ta na̱ na̱nda̱ca̱ tu̱hún Juan cán na̱sa̱ha̱n na̱ jáchi̱ já na̱ta̱hnda̱ chuun na̱caja na̱ fariseo, mé na̱ sáhndá chuun ñuu Jerusalén cán. ");
INSERT INTO mksNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Já na̱cachi tucu na já xi̱hi̱n Juan: —Ndá cuéntá quéa̱ cája ndúta̱ yóhó ña̱yivi tá ta̱ co̱ cúún Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. Ta ndá cuéntá quéa̱ jácandútu̱n ña̱yivi tá ta̱ ni co̱ cúún Elías ta ni co̱ cúún mé profeta, da̱ na̱cachi Ndióxi̱ chindahá a̱ —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","A̱nda̱ já na̱cachi Juan já xi̱hi̱n ná: —Ye̱he̱ cája ndutá i̱ ña̱yivi xi̱hín ticui̱í joo tañu mé ndó íin in da co̱ xíni̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ta va̱xi in da̱ ja̱tá ye̱he̱ ta íin cua̱ha̱ chága̱ sa̱ha̱ dá a̱ ju̱ú ga̱ ye̱he̱. Ta chí ni co̱ó sa̱há i̱ ndaxí i̱ correa ndu̱sa̱ dá —na̱cachi Juan xi̱hín na̱ na̱sa̱ha̱n ndáca̱ tu̱hún ñahá cán. ");
INSERT INTO mksNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tócó ndihi ña̱ yóho na̱ya̱ha chí ñuu Betábara ña̱ ndáca̱a̱n inga xoo yu̱ta Jordán nu̱ú na̱caja ndúta̱ Juan ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ta inga qui̱ví ita̱a̱n já na̱xini Juan cáyati Jesús va̱xi a nu̱ íin da. Já na̱cachi Juan já xi̱hín ña̱yivi ndúu cán: —Cande̱hé ndo̱. Da̱ va̱xi ja̱n cúú dá tátu̱hun ndicachi jóco̱ na̱ nu̱ Ndióxi̱. Ta da̱ ja̱n cúú da̱ jándoo cua̱chi ña̱yivi ndúu ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Da̱ ja̱n cúú da̱ cáchí i̱ sa̱ha̱ ña̱ va̱xi in da ja̱tá ye̱he̱ ta íin cua̱ha̱ chága̱ sa̱ha̱ dá a̱ ju̱ú ga̱ ye̱he̱. Jáchi̱ ja̱nda̱ tá cáma̱ní cacu ye̱he̱ sa̱ íin va mé da̱ ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ta ni mí i̱ co̱ó na̱xini i̱ ndá quia̱hva cáa da joo na̱casáhá i̱ jácandutá i̱ ña̱yivi xi̱hín ticui̱í já ná canda̱a̱ ini na̱ Israel yo cúú mé dá —na̱cachi Juan. ");
INSERT INTO mksNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ta na̱ndicani da ña̱ na̱xini da já na̱cachi da já: —Sa̱ xíní xi̱hín nu̱u̱ mí i̱ ndá quia̱hva na̱nuu ínima̱ yi̱i̱ Ndióxi̱ ja̱tá Jesús. Mé ínima̱ yi̱i̱ Ndióxi̱ cán na̱nuu a indiví ta cáa tá quia̱hva cáa in ndija̱ta. ");
INSERT INTO mksNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mé a̱ nda̱a̱ co̱ó na̱xini toho ye̱he̱ yo cúú mé da̱ yóho, nduu. Joo Ndióxi̱, mé a̱ na̱chindahá ye̱he̱ jácandutá i̱ ña̱yivi xi̱hín ticui̱í, mé a̱ cán quéa̱ na̱cachi já xi̱hín i̱: “Ndá da̱ ná cunún ná nuu ínima̱ yi̱i̱ mí i̱ ta saco̱o a ja̱ta̱ dá, da̱ cán cúú da̱ jándicutú ini ña̱yivi xi̱hi̱n ínima̱ yi̱i̱ mí i̱”, na̱cachi Ndióxi̱ xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ta viti mé a̱ nda̱a̱ sa̱ xíni̱ vi̱ yo cúú mé á ta cáxi tu̱hun i̱ xi̱hi̱n ndo̱ ña̱ mé á cúú á in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ —na̱cachi Juan. ");
INSERT INTO mksNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ta inga qui̱ví ita̱a̱n na̱sahi̱in tucu Juan cán xi̱hín i̱vi̱ na̱ xíca xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Já na̱xini da ña̱ yáha Jesús cua̱ha̱n já na̱cachi Juan já xi̱hín na̱ xíca xi̱hi̱n dá cán: —Cande̱hé ndo̱. Da̱ ja̱n cúú tátu̱hun ndicachi, rí jóco̱ na̱ nu̱ Ndióxi̱ —na̱cachi Juan. ");
INSERT INTO mksNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tá na̱xini jo̱ho da̱ ndíta xi̱hín da̱ cán ña̱ yóho já ndíco̱ da̱ ja̱tá Jesús cua̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tá na̱xini Jesús ña̱ ndíco̱ da̱ cán ja̱tá já na̱ndicoto nihni a nu̱ dá já na̱cachi a xi̱hi̱n ndíví da̱ cán já: —Ndía̱ cúni̱ ndo̱ —na̱cachi a. Já na̱cachi da̱ cán já xi̱hi̱n á: —Maestro, ndájá íin vehe ndó já —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já: —Cóho̱ ná cuni ndó, dá já —na̱cachi a. Já ndáca táhan da na̱sa̱ha̱n da̱ xi̱hi̱n á sánde̱hé da̱ nu̱ íin a. Ta na̱sacuu a tátu̱hun ca̱a̱ co̱mi̱ sa̱hini já na̱sa̱nduu da xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","In táhan da na̱xini jo̱ho ña̱ na̱cachi Juan ta ndíco̱ da̱ ja̱tá Jesús cán naní da̱ Andrés, da̱ cúú ñani Simón, da̱ cáha̱n na̱ Pedro xi̱hi̱n cán. ");
INSERT INTO mksNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mé Andrés yóho ndáva da na̱sa̱ha̱n da̱ ndínducú da̱ ñani da, da̱ naní Simón cán. Ta tá na̱ndiñe̱he̱ ñahá da̱ já na̱cachi da já xi̱hi̱n dá: —Na̱nditahan nde̱ da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi, mé a̱ cúú Cristo —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tá na̱ndihi já ndáca Andrés cán ñani da na̱sa̱ha̱n da̱ nu̱ Jesús. Ta tá na̱xini Jesús da̱ já na̱cachi a já xi̱hi̱n dá: —Yóhó cúún Simón, ja̱hyi Jonás. Joo ye̱he̱ chinúu i̱ qui̱vu̱n cananún Cefas viti —na̱cachi Jesús. Qui̱vi̱ Cefas yóho in cúú va xi̱hi̱n Pedro ta cúni̱ cachi a in tóto̱. ");
INSERT INTO mksNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ta inga qui̱ví ita̱a̱n já na̱quee Jesús cua̱ha̱n chí estado Galilea. Ta cán na̱nditahan mé á da̱ naní Felipe já na̱cachi a já xi̱hi̱n dá: —Naha quíi̱ caca tuún xi̱hín i̱ —na̱cachi a xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Mé Felipe yóho cúú dá da̱ ñuu Betsaida ta mé ñuu cán cúú ri ñuu Andrés xi̱hi̱n Pedro. ");
INSERT INTO mksNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ta ndaja coo Felipe yóho ndáva da na̱sa̱ha̱n da̱ na̱ndinducú da̱ Natanael ta tá na̱ndiñe̱he̱ ñahá da̱ já na̱cachi da já xi̱hi̱n dá: —Na̱nditahan nde̱ da̱ na̱ca̱hyí Moisés sa̱ha̱ nu̱ ley sa̱nahá. Ta jári na̱ profeta na̱ca̱hyí ri na sa̱ha̱ dá. Ta mé dá cúú Jesús, ja̱hyi José, da̱ ñuu Nazaret —na̱cachi Felipe xi̱hín Natanael cán. ");
INSERT INTO mksNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","A̱nda̱ já na̱cachi Natanael já: —Ndá quehe ri ña̱ha va̱ha quixi chí ñuu Nazaret ja̱n —na̱cachi da. A̱nda̱ já na̱cachi Felipe já xi̱hi̱n dá: —Cóho̱ cande̱hún —na̱cachi da. A̱nda̱ já na̱quee da cua̱ha̱n da̱ nu̱ íin Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ta tá na̱xini Jesús na̱cayati Natanael nu̱ á já na̱cachi a já: —Da̱ yóho cúú ndusa in da̱ na̱quixi chi̱chi Israel ta cúú dá ta̱a cája ña̱ nda̱a̱ cuití va —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tá na̱xini jo̱ho Natanael ña̱ yóho já na̱nda̱ca̱ tu̱hún da̱ Jesús já na̱cachi da já xi̱hi̱n á: —Á xíni̱ ndó ye̱he̱, va̱ha. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Ja̱nda̱ tá cáma̱ní quee Felipe cu̱hu̱n da̱ cana da yo̱hó já na̱xini i̱ íin coún sa̱ha̱ ti̱tó ñu̱hú —na̱cachi Jesús xi̱hín Natanael. ");
INSERT INTO mksNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","A̱nda̱ já na̱casáhá cáchí da̱ já xi̱hín Jesús: —Maestro, jivi ndusa cúú ndó in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ ta cúú ndó ña̱ cómí cuéntá sa̱há ña̱yivi Israel —na̱cachi da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já: —Na̱candúsún ye̱he̱ sa̱há ña̱ na̱cachi i̱ xu̱hu̱n ña̱ na̱xini i̱ íin coún sa̱ha̱ ti̱tó ñu̱hú. Joo náhnu chága̱ ña̱ha cunún xi̱hín nduchú núún caja i̱ —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A̱nda̱ já na̱cachi tucu Jesús já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ cuni ndó xi̱hín nu̱u̱ ndó ña̱ nu̱ná indiví. Ta cuni ndó táto̱ Ndióxi̱ ndaa na ta nuu na xi̱nu̱ na nu̱ íin ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tá na̱ya̱ha u̱ni̱ qui̱vi̱ já na̱sahi̱in in vicó tánda̱ha̱ ñuu Caná ña̱ ndáca̱a̱n estado Galilea cán. Ta na̱sa̱ha̱n María, náná Jesús mé víco̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ta jári na̱cana na Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á ta chí na̱sa̱ha̱n ndihi na mé víco̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Joo ndaja coo nani cúú víco̱ cán na̱ndihi va vino xíhi na. Ta tá na̱xini náná Jesús ña̱ yóho já na̱cachi ñá já xi̱hín Jesús: —Sa̱ na̱ndihi va vino xíhi na —na̱cachi ñá xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Já na̱cachi Jesús já xi̱hi̱n ñá: —Co̱ xíní ñúhú toho ca̱ha̱n ndó já xi̱hín i̱ jáchi̱ cáma̱ní yi̱i̱ va ndindaa hora caja i̱ ña̱ha xitúhún —na̱cachi Jesús xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tá na̱ndihi já na̱cachi náná Jesús já xi̱hín na̱ jácaca vino cán: —Ndá ña̱ha ná cahnda Jesús nu̱ ndó caja ndó, caja ndó ña̱ —na̱cachi ñá xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ta mé vehe nu̱ cúú víco̱ cán na̱sahi̱in i̱ñu̱ yoo náhnu ña̱ na̱cava̱ha na xi̱hín yu̱u̱. Mé yoo cán na̱sa̱cuu a nu̱ táán na̱ Israel cán ticui̱í, dó ndája vií na̱ mé ná tá quia̱hva sáhndá ley nu̱ ná caja na. Ta tátu̱hun co̱mi̱ jícó á in ciento litro ticui̱í quéta ini in in yoo náhnu cán. ");
INSERT INTO mksNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tá na̱ndihi já na̱cachi Jesús já xi̱hín na̱ jácaca vino cán: —Jácutú ndihi ndó yoo náhnu ja̱n xi̱hín ticui̱í. Ta chí na̱jácutú jíní nda̱a̱ na̱ yoo náhnu cán xi̱hín ticui̱í. ");
INSERT INTO mksNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tá na̱ndihi já na̱cachi tucu Jesús já xi̱hi̱n ná: —Ta viti tavá loho ndó do̱ ta quia̱hva ndó do̱ ná coto ndojó da̱ cómí chuun sa̱ha̱ víco̱ yóho —na̱cachi Jesús. Já ñéhe na do̱ na̱sa̱ha̱n na̱ nu̱ú da̱ cómí chuun sa̱ha̱ víco̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Joo sa̱ na̱caja Jesús ña̱ ná nduu ticui̱í cán vino. Ta na̱xito ndojó da̱ do̱ joo co̱ xíni̱ da̱ ndájá na̱quixi dó. In túhún na̱ xíni̱ cúú na̱ na̱xini ña̱ na̱ndaja Jesús cán ticui̱í ña̱ ná nduu dó vino. Tá na̱xito ndojó mé da̱ cómí chuun yóho do̱ já na̱catóntó da̱ ta na̱cana da mé da̱ tánda̱ha̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Já na̱cachi da já xi̱hi̱n dá: —Ndijáá ña̱yivi tá cája na in víco̱ já sáhan na vino va̱ha nu̱ cuítí nu̱ú na̱ táhan cán. Ta tá sa̱ na̱xi̱hi̱ cua̱há na̱ já sáhan na dó núu cán. Joo yóhó na̱sacu va̱hún vino va̱ha ta ja̱ víti sáhún do̱ nu̱ú na̱ tácá víco̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ña̱ xitúhún yóho na̱caja Jesús ñuu Caná cuéntá estado Galilea na̱sa̱cuu a̱ ña̱ xitúhún nu̱ cuítí na̱caja Jesús já ná cuni ña̱yivi ndá quia̱hva cáhnu cúú mé á. Ta xi̱hín ña̱ yóho na̱candeé ini na̱ xíca tuun xi̱hín a̱ cán mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tá sa̱ na̱ya̱ha ña̱ yóho já na̱quee a cua̱ha̱n xi̱hín na̱ xíca tuun xi̱hi̱n á chí ñuu Capernaum. Ta ndáca táhan náná a̱ xi̱hín ñani a ndíco̱ na̱ cua̱ha̱n na̱ xi̱hi̱n á. Ta na̱sa̱nduu na ñuu Capernaum cán chá qui̱vi̱ cuití va. ");
INSERT INTO mksNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tá na̱cayati qui̱ví caja na̱ Israel vicó pascua já na̱quee Jesús na̱sa̱ha̱n chí ñuu Jerusalén. ");
INSERT INTO mksNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ta tá na̱xi̱nu̱ co̱o a veñu̱hu cáhnu ndáca̱a̱n Jerusalén cán já na̱xini a ña̱ ja̱ndá joho ndúu na̱ jícó. Java na jícó tindi̱qui̱ xi̱hín ndicachi xi̱hín ndija̱ta viti ta java na ndúu coo ndíjama jiu̱hún. ");
INSERT INTO mksNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ta chí na̱tiin Jesús yóho̱ ta na̱cava̱ha in churrú xi̱hi̱n á já na̱casáhá táxí ndihi a na̱ ndúu jícó cán. Ta ja̱nda̱ tindi̱qui̱ xi̱hín ndicachi ja̱na̱ ná na̱tavá a̱ ri̱ quee rí cu̱hu̱n ri̱. Ta já na̱xi̱nu̱ co̱o a nu̱ ndúu na̱ ndíjama jiu̱hún cán já na̱xicó ñehe a mesa na̱ já na̱cu̱yu ndihi jiu̱hún na̱ nu̱ ñúhu̱. ");
INSERT INTO mksNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ta na̱sahnda a̱ chuun nu̱ú na̱ jícó ndija̱ta cán já na̱cachi a já: —Tavá ndihi ndó ña̱ jícó ndó ja̱n. A̱ cája ndó xi̱hín vehe tátá i̱ ña̱ cúú á nu̱ cáya̱hvi ña̱ha —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tá na̱ndihi já na̱ndicu̱hu̱n ini na̱ xíca tuun xi̱hín Jesús cán ña̱ cáchí tu̱hun Ndióxi̱. Já cáchí a̱ já: “A̱ ju̱ú quia̱hva xójo̱ ini i̱ sa̱há ña̱ co̱ cája cáhnu ña̱yivi vehe Ndióxi̱”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tá na̱xini na̱ Israel cán ña̱ na̱caja Jesús ña̱ yóho já na̱nda̱ca̱ tu̱hún na̱ mé á já na̱cachi na já xi̱hi̱n á: —Xíní ñúhú cajún in ña̱ha xitúhún já ná cuni nde̱ ña̱ mé a̱ nda̱a̱ íin sa̱hún tasún na̱ ndúu jícó veñu̱hu yóho —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Tá ná jándita̱ni̱ ndó veñu̱hu yóho ta ti̱xi u̱ni̱ qui̱vi̱ já jácandichi tucu u̱ ña̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A̱nda̱ já na̱cachi na̱ Israel cán já xi̱hi̱n á: —Co̱ cándúsa nde̱ ña̱ cáchún jáchi̱ na̱caja chúun na i̱vi̱ jico i̱ñu̱ cui̱a̱ já na̱xi̱nu̱ veñu̱hu ja̱n. Ta yóhó cáchún ña̱ ti̱xi u̱ni̱ víxí qui̱vi̱ jácandichi tucún ña̱, va̱ha —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Joo co̱ cáha̱n toho Jesús sa̱há veñu̱hu cáhnu cán jáchi̱ cáha̱n mé á sa̱ha̱ yiquí cu̱ñu a. ");
INSERT INTO mksNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ña̱ cán quéa̱ tá na̱xi̱hi̱ Jesús ta na̱nditacu tucu a ti̱xi u̱ni̱ qui̱vi̱ já na̱ndicu̱hu̱n ini na̱ xíca tuun xi̱hi̱n á cán sa̱há tu̱hun na̱ca̱ha̱n mé á nu̱ú na̱ Israel yóho. Ta chí na̱candúsa na tu̱hun Ndióxi̱ ta na̱candúsa na tócó ndihi ña̱ na̱ca̱ha̱n Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Cua̱há ña̱yivi ñuu Jerusalén cán na̱candúsa na Jesús nani na̱sahi̱in a víco̱ pascua cán sa̱há ña̱ náhnu xi̱hín ña̱ xitúhún na̱caja nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Va̱tí na̱cachi na cándúsa na mé á joo co̱ó na̱candúsa toho Jesús na̱ jáchi̱ xíni̱ va̱ha mé á ndá ínima̱ ñéhe in in na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ta co̱ xíní ñúhú toho a ña̱ ca̱xi tu̱hun na xi̱hi̱n á ndá quia̱hva íin in in ña̱yivi jáchi̱ sa̱ xíni̱ ndihi va mé á ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na̱sahi̱in in da̱ xíca cuéntá na̱ fariseo naní Nicodemo ta cúú dá da̱ sa̱cua̱ha̱ nu̱ú na̱ Israel cán. ");
INSERT INTO mksNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ta ñuú na̱queta da cua̱ha̱n da̱ coto nihni da Jesús. Ta tá na̱xi̱nu̱ co̱o da nu̱ á já na̱cachi da já xi̱hi̱n á: —Maestro, cánda̱a̱ cáxí ini nde̱ ña̱ na̱chindahá Ndióxi̱ ndo̱hó va̱xi ndó nu̱ú nde̱ ña̱ ná jána̱ha̱ ndó nu̱ú nde̱. Jáchi̱ ni in túhún toho ña̱yivi a̱ cu̱ú caja ña̱ náhnu cája mé ndó tá ta̱ co̱ íin Ndióxi̱ xi̱hi̱n ná —na̱cachi da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ ni in túhún ña̱yivi a̱ cúu cacomí Ndióxi̱ cuéntá sa̱ha̱ tá ná a̱ ndícó co̱o tucu na cacu tucu na —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","A̱nda̱ já na̱nda̱ca̱ tu̱hún Nicodemo Jesús já na̱cachi da: —Ndá quia̱hva cuu cacu tucu na tá sa̱ na̱cayatá na̱. Ama ná ndi̱hvi tucu na ti̱xi náná na̱ já cacu tucu na —na̱cachi Nicodemo xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","A̱nda̱ já na̱cachi tucu Jesús já xi̱hi̱n dá: —Cáha̱n i̱ ña̱ nda̱a̱ xi̱hi̱n ndo̱. Tá na̱candúta̱ ña̱yivi xi̱hín ticui̱í ta tá na̱ndicutú nda̱a̱ ínima̱ ná xi̱hi̱n ínima̱ yi̱i̱ Ndióxi̱ já cúú á tátu̱hun cácu tucu na ta a̱nda̱ já cuu cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jáchi̱ ñuyíví yóho cácu ja̱hyi ña̱yivi ta sa̱ já ña̱yivi cúú va na. Joo na̱ jándicutú Ndióxi̱ xi̱hi̱n ínima̱ yi̱i̱ mé á, na̱ cán cúú ja̱hyi mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ta co̱ ndítahan catóntó ndó tá cáchí i̱ xi̱hi̱n ndó ña̱ ndítahan cacu tucu ndihi ña̱yivi já ná cacomí Ndióxi̱ cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jáchi̱ cúú á tátu̱hun tá xícó ta̱chi̱ ndá xoo cúni̱ mé á. Va̱tí xíni̱ jo̱ho í xícó ta̱chi̱ joo co̱ xíni̱ yo̱ ndá xoo quíxi a ta co̱ xíni̱ yo̱ ndá xoo cua̱ha̱n. Quia̱hva já íin ínima̱ yi̱i̱ Ndióxi̱ jáchi̱ va̱tí co̱ xíní ña̱yivi mé á joo xíní na̱ ndá quia̱hva cája mé á tá ñúhu a ini na —na̱cachi Jesús xi̱hín Nicodemo. ");
INSERT INTO mksNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tá na̱ndihi já na̱cachi Nicodemo já xi̱hín Jesús: —Co̱ cánda̱a̱ toho ini i̱ ña̱ cáchí ndo̱ xi̱hín i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Cúú ndó da̱ jána̱ha̱ nu̱ú ña̱yivi Israel ta ndítahan canda̱a̱ ini ndó ña̱ yóho, nduu jáchi̱ cúú ndó maestro cáhnu nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Cáha̱n nde̱ sa̱há ña̱ cánda̱a̱ ini nde̱ ta sa̱há ña̱ na̱xini nde̱ xi̱hín nu̱ú nde̱ joo ndóhó co̱ cándúsa ndó ña̱ cáha̱n nde̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Cáha̱n i̱ sa̱há ña̱ha ñuyíví yóho xi̱hi̱n ndo̱ ta co̱ cándúsa ndó ña̱. Ndaja ga̱ ví caja ndó tá ná ca̱ha̱n i̱ sa̱há ña̱ha íin indiví. ");
INSERT INTO mksNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ʼNi in túhún toho ña̱yivi a̱ ñáha ndaa cu̱hu̱n chí indiví. In túhún da̱ ndaa indiví cúú da̱ na̱nuu, da̱ na̱quixi ñuyíví yóho. Ta da̱ cán cúú ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sa̱nahá ndiva̱ha na̱cata caa Moisés in co̱o, rí na̱cava̱ha xi̱hín ca̱a nu̱ yíto̱ yucú íchí. Quia̱hva já cata caa ri na ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ndi̱ca crúxu̱ ");
INSERT INTO mksNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","já quéa̱ ná ca̱cu ndaa ínima̱ ña̱yivi já ná a̱ cúhu̱n na̱ indayá tá ná candeé ini na ye̱he̱. Ta xi̱hín ña̱ yóho catacu na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ʼJáchi̱ sa̱ha̱ ña̱ na̱qui̱hvi̱ ndiva̱ha ini Ndióxi̱ ña̱yivi ndúu ñuyíví sa̱há ña̱ cán quéa̱ na̱chindahá mé á in túhún ji̱ni̱ já ja̱hyi a ñuyíví yóho. Já quéa̱ tá ná candeé ini na mé á cuu ca̱cu ndaa ínima̱ ná já ná catacu na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Co̱ó na̱chindahá Ndióxi̱ ja̱hyi a ña̱ ná quixi da jándihi da sa̱há na̱ ndúu ñuyíví yóho. Na̱chindahá a̱ ja̱hyi a jáchi̱ cúni̱ a̱ jáca̱cu a ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ʼTa ndá na̱ sa̱ cándeé ini ye̱he̱, ña̱ cúú u̱ ja̱hyi Ndióxi̱, na̱ cán cúú na̱ cája cáhnu ini Ndióxi̱ sa̱ha̱. Joo na̱ co̱ó na̱xeen cándúsa ñahá cán, na̱ cán cúú na̱ co̱ cája cáhnu ini Ndióxi̱ sa̱ha̱ jáchi̱ co̱ó na̱xeen na cándúsa na da̱ cúú in túhún ji̱ni̱ já ja̱hyi mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ta na̱ co̱ó na̱xeen cándúsa cán sa̱ na̱sacu va Ndióxi̱ sa̱ha̱ ná cu̱hu̱n na̱ indayá jáchi̱ na̱ca̱an na cája na ña̱ núu. Sa̱há ña̱ cán quéa̱ na̱xi̱nu̱ mé á cúú ja̱hyi Ndióxi̱ ñuyíví yóho ta cúni̱ a̱ jándiyéhe̱ a̱ nu̱ú ña̱yivi. Jáchi̱ cátóó chága̱ na̱ canduu na nu̱ú naá jáchi̱ cája na ña̱ núu. ");
INSERT INTO mksNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Jáchi̱ tócó ndihi na̱ cája ña̱ núu cándají na̱ ña̱ va̱ha, ña̱ cúú tátu̱hun ña̱ yéhe̱. Ta co̱ cúni̱ na̱ cayati na nu̱ú ña̱ yéhe̱ cán já ná a̱ ndíti̱vi ña̱ núu cája na. ");
INSERT INTO mksNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Joo na̱ cája ña̱ nda̱a̱, na̱ cán cúú na̱ cáyati chága̱ nu̱ú ña̱ va̱ha, ña̱ cúú tátu̱hun ña̱ yéhe̱ já ná na̱ha̱ ña̱ mé a̱ nda̱a̱ cája na ña̱ cúni̱ Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tá sa̱ na̱ya̱ha ña̱ yóho já na̱quee Jesús na̱sa̱ha̱n chí estado Judea xi̱hín na̱ xíca tuun xi̱hi̱n á. Ta cán na̱sahi̱in a chá tiempo xi̱hi̱n ná jáchi̱ na̱jácandúta̱ ná ña̱yivi mé cán. ");
INSERT INTO mksNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ta jári Juan va na̱jácandúta̱ dá ña̱yivi chí ñuu naní Enón yati ñuu Salim cán jáchi̱ cán ñúhu cua̱há ticui̱í. Ta cua̱há ña̱yivi na̱sa̱ha̱n na̱ cán candúta̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tócó ndihi ña̱ yóho na̱ya̱ha tá cáma̱ní tiin na Juan chica̱a̱n na̱ da̱ veca̱a. ");
INSERT INTO mksNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","In tañu java na̱ xíca xi̱hi̱n Juan cán na̱casáhá na̱ ndítúhún i̱hvi̱ na̱ xi̱hín java na̱ Israel sa̱há ña̱ yóho: á ndíya̱hvi chága̱ tá cája ndúta̱ Juan ña̱yivi á tá cája ndúta̱ na̱ xíca tuun xi̱hín Jesús ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tá na̱ndihi já ndáva na̱ xíca xi̱hi̱n Juan na̱sa̱ha̱n na̱ cáha̱n na̱ xi̱hi̱n dá já na̱cachi na já: —Maestro, da̱ta̱a, da̱ na̱nditúhún xi̱hi̱n ndó inga xoo yu̱ta Jordán cán, da̱ na̱ca̱ha̱n mé ndó sa̱ha̱ nu̱ú nde̱ cán, viti xíca nuu da jácandúta̱ dá ña̱yivi ta ja̱ndá joho tócó ndihi ña̱yivi ndíco̱ na̱ da̱ viti —na̱cachi na̱ cán xi̱hi̱n Juan. ");
INSERT INTO mksNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A̱nda̱ já na̱cachi Juan já xi̱hín na̱ cán: —Ni in túhún toho ña̱ha a̱ cúu caja ña̱yivi tá co̱ sáhan Ndióxi̱ ña̱ma̱ni̱ nu̱ ná caja na ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ta sa̱ na̱xini jo̱ho ndó ña̱ na̱ca̱xi tu̱hun ya̱chi̱ vi̱ xi̱hi̱n ndo̱ ña̱ co̱ cúú ye̱he̱ da̱ na̱sa̱ha̱n Ndióxi̱ tu̱hun a chindahá a̱ cacomí a̱ cuéntá sa̱há ña̱yivi. Na̱chindahá Ndióxi̱ ye̱he̱ já ná cacu tia̱hva i̱ íchi̱ nu̱ú quixi mé da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cande̱hé ndo̱. Cúú á tátu̱hun tá cúu in víco̱ tánda̱ha̱. Ta da̱ cúú amigo da̱ tánda̱ha̱ cán ndáti da casa̱a̱ da̱. Ta cáji̱i̱ ini da tá xíni̱ jo̱ho da nu̱ cáha̱n vatá da̱ tánda̱ha̱ cán jáchi̱ íin ñájíhí da̱ xi̱hi̱n dá. Ta quia̱hva já cáji̱i̱ ini i̱ jáchi̱ cásáhá ña̱yivi ndíco̱ na̱ ja̱ta̱ Jesús viti. ");
INSERT INTO mksNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mé Jesús ja̱n ndicáhnu joho ga̱ cu̱hu̱n a̱. Ta ye̱he̱ ndítahan nuu ndáha joho i̱ cu̱hu̱n i̱ —na̱cachi Juan. ");
INSERT INTO mksNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mé Jesús na̱quixi chí indiví ta cáhnu chága̱ mé á nu̱ ndíhi ña̱ha. Ta ña̱yivi na̱cacu ñuyíví yóho cáha̱n na̱ sa̱há ña̱ha ñuyíví cuití va. Joo mé á na̱quixi chí indiví cán cúú á ña̱ cáhnu chága̱ nu̱ tócó ndihi ña̱ha. ");
INSERT INTO mksNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ta cáha̱n mé a̱ cán sa̱há ña̱ na̱xini xi̱hín nu̱u̱ a̱ ta cáha̱n sa̱há ña̱ na̱xini jo̱ho a. Joo ni in na co̱ cúni̱ candúsa na ña̱ cáha̱n mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Joo ndá na̱ cándúsa nu̱ cáha̱n mé á, na̱ cán cúú na̱ cánda̱a̱ cáxí ini na ña̱ cáha̱n Ndióxi̱ ña̱ nda̱a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ndióxi̱ quéa̱ na̱chindahá mé á ta cáha̱n ndinuhu tu̱hun Ndióxi̱ jáchi̱ co̱ ndáhví toho cúú ini Ndióxi̱ jándicutú nda̱a̱ mé a̱ cán xi̱hín ínima̱ yi̱i̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ta Ndióxi̱, tátá a̱ ña̱ íin indiví quíhvi̱ ndiva̱ha ini a in túhún ji̱ni̱ já ja̱hyi a ta na̱sa̱ha̱n ndée̱ a̱ nu̱ú ja̱hyi a ña̱ ná cuu caja tócó ndihi ña̱ha. ");
INSERT INTO mksNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ta ndá na̱ cándeé ini mé a̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ cán, na̱ cán cúú na̱ catacu a̱nda̱ ama cáa qui̱vi̱. Joo na̱ co̱ cúni̱ candúsa ñahá cán, na̱ cán cúú na̱ a̱ ñéhe̱ táhvi̱ toho na catacu na xi̱hi̱n Ndióxi̱. Ña̱ caja Ndióxi̱ xi̱hi̱n ná quéa̱ chindahá a̱ na̱ cu̱hu̱n na̱ indayá a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ta ndaja coo na̱ fariseo na̱canda̱a̱ ini na ña̱ cua̱ha̱ chága̱ ña̱yivi ndíco̱ ja̱tá Jesús ta cua̱ha̱ chága̱ ña̱yivi jácandúta̱ Jesús a̱ ju̱ú ga̱ Juan. ");
INSERT INTO mksNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Va̱tí a̱ ju̱ú mé Jesús jácandúta̱ ña̱yivi joo na̱ xíca tuun xi̱hi̱n á cán jácandúta̱ ñahá. ");
INSERT INTO mksNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ta tá na̱xini jo̱ho Jesús ña̱ cáha̱n ña̱yivi sa̱há já na̱quee a estado Judea xi̱hín na̱ xíca tuun xi̱hi̱n á cua̱ha̱n na̱ ndicó co̱o na chí estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta nu̱ú cu̱hu̱n a̱ Galilea cán ndúsa̱ ya̱ha nda̱a̱ estado Samaria já xi̱nu̱ a̱ nu̱ú cu̱hu̱n a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ta na̱xi̱nu̱ a̱ in ñuu loho naní Sicar cuéntá mé Samaria cán yati nu̱ú ñundáhyi̱ ña̱ na̱jándicoo ta̱hvi̱ Jacob nu̱ José, ja̱hyi da. ");
INSERT INTO mksNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ta cán na̱sahi̱in in chi̱co̱ho̱ ña̱ naní chi̱co̱ho̱ Jacob. Ta cúú á tátu̱hun ca̱xi̱vi̱ tá na̱xi̱nu̱ co̱o Jesús ñuu Sicar cán. Ta chí a̱ váha ga̱ na̱canaá a̱ sa̱há ña̱ cán quéa̱ na̱saco̱o a yati yuhú chi̱co̱ho̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ta nani íin coo a cán já na̱xi̱nu̱ in ñáñáha̱ cuéntá Samaria tavá ña̱ ticui̱í ini chi̱co̱ho̱ cán. Já na̱cachi Jesús já xi̱hi̱n ñá: —Quia̱hva loho ticui̱í ná coho i̱ —na̱cachi a xi̱hi̱n ñá. ");
INSERT INTO mksNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jáchi̱ sa̱ cua̱ha̱n na̱ xíca tuun xi̱hi̱n á ñuu cueen na ña̱ha cuxu na. ");
INSERT INTO mksNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A̱nda̱ já na̱catóntó ña̱ jáchi̱ co̱ xíní táhan va̱ha na̱ Israel xi̱hín na̱ Samaria. Ta na̱cachi ñá já xi̱hín Jesús já: —Ndá cuéntá quéa̱ xíca̱ yóhó, da̱ Israel, ticui̱í nu̱ú i̱ cohún ta ñá Samaria va cúú ye̱he̱ —na̱cachi ñá cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Já na̱cachi a já xi̱hi̱n ñá: —Tá ná canda̱a̱ inún yo cúú ye̱he̱, da̱ xíca̱ ticui̱í nu̱u̱n ta tá ná canda̱a̱ inún ndá quia̱hva íin ña̱ cúni̱ Ndióxi̱ quia̱hva nu̱u̱n já ca̱cún ña̱ nu̱ú i̱. Jáchi̱ ye̱he̱ cuu caja i̱ ña̱ ná catacún a̱nda̱ ama cáa qui̱vi̱ ta ña̱ yóho cuu a tátu̱hun ticui̱í, do̱ a̱ cúu ndihi sa̱ha̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A̱nda̱ já na̱cachi ñá cán já xi̱hi̱n á: —Cande̱hé ndo̱. Ni yáxi̱ co̱ ñéhe ndó tavá ndó ticui̱í ini chi̱co̱ho̱ yóho ta chi̱co̱ho̱ cúná ndiva̱ha cúú ña̱ yóho. Ndá cuu caja ri ndó quia̱hva ndó ticui̱í cáchí ndo̱ ja̱n nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tásáhnu jícó nde̱, da̱ naní Jacob cán na̱jándacoo chi̱co̱ho̱ yóho nu̱ú nde̱. Ta nu̱ú chi̱co̱ho̱ yóho na̱xihi da̱ cán ticui̱í ta sa̱ mé chi̱co̱ho̱ yóho na̱xihi ri ja̱hyi da̱ cán ta yóho na̱xihi ri quíti̱ ja̱na̱ dá. Ama ná cuu quia̱hva mé ndó ticui̱í va̱ha chága̱ a̱ ju̱ú ga̱ dó na̱jándacoo Jacob nu̱ú nde̱ —na̱cachi ñá cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ñá já na̱cachi a já: —Ndá ña̱yivi na̱cuu va xíhi ticui̱í chi̱co̱ho̱ yóho já quéa̱ i̱chi̱ tá i̱chi̱ ini na. ");
INSERT INTO mksNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Joo ndá na̱ ná coho ticui̱í táhan dó sáhan ye̱he̱, na̱ cán cúú na̱ a̱ ndícó co̱o ga̱ na̱ i̱chi̱ ini na a̱nda̱ ama cáa qui̱vi̱. Jáchi̱ cúú á tátu̱hun sa̱ mé ini mé va na cana ticui̱í, dó a̱ ndíhi sa̱ha̱ ta catacu na a̱nda̱ ama cáa qui̱vi̱ —na̱cachi Jesús xi̱hi̱n ñá. ");
INSERT INTO mksNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A̱nda̱ já na̱cachi ñá cán já xi̱hín Jesús: —Quia̱hva mé ndó ticui̱í, dó co̱ ndíhi sa̱ha̱ ja̱n nu̱ú i̱ ña̱ ná a̱ íchi̱ ga̱ ini i̱ ticui̱í já ná a̱ quíxi ga̱ i̱ yóho tavá i̱ dó coho i̱ —na̱cachi ñá xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ña̱: —Cuáhán cana yíu̱n ná quixi da yóho xu̱hu̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A̱nda̱ já na̱nducú ñehe ñá cán tu̱hun nu̱ á já na̱cachi ñá já: —Co̱ó toho yií i̱. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ñá: —Mé a̱ nda̱a̱ co̱ó toho yíu̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Joo na̱sahi̱in u̱hu̱n yíu̱n ta da̱ íin xu̱hu̱n viti ja̱n co̱ cúú toho da yíu̱n. Nda̱a̱ ndusa cáhu̱n —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Já na̱cachi ñá já xi̱hi̱n á: —Jivi ndusa in profeta cúú mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tásáhnu jícó nde̱, na̱ Samaria yóho na̱caja cáhnu na Ndióxi̱ yati ji̱ni̱ yúcu̱ ja̱n. Joo ndóhó, na̱ Israel cáchí ndo̱ ña̱ ndúsa̱ ndítahan nu̱ú nde̱ cu̱hu̱n nde̱ ñuu Jerusalén caja cáhnu nde̱ Ndióxi̱. Ta mé ndó ndaja cachi ndó —na̱cachi ñá cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ñá já na̱cachi a já xi̱hi̱n ñá: —Xíní ñúhú candúsún ña̱ cáha̱n i̱ jáchi̱ mé a̱ nda̱a̱ va̱xi qui̱vi̱ caja cáhnu ndihi ndó Ndióxi̱, tátá yo̱ ndá xoo na̱cuu va. A̱ cúní ñúhú ga̱ ndó cu̱hu̱n ndo̱ ji̱ni̱ yúcu̱ cáa ta ni a̱ cúní ñúhú ga̱ ndó cu̱hu̱n ndó ñuu Jerusalén caja cáhnu ndó Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Joo ndóhó, na̱ Samaria cája cáhnu cuáá ndo̱ Ndióxi̱ jáchi̱ co̱ xíni̱ ndó a̱. Joo nde̱he̱, na̱ Israel xíni̱ va̱ha nde̱ yo cúú Ndióxi̱ cája cáhnu nde̱. Jáchi̱ chi̱chi mé nde̱, na̱ Israel na̱sacu ini Ndióxi̱ quixi mé á jáca̱cu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ta viti na̱xi̱nu̱ qui̱vi̱ tá ndítahan caja cáhnu ña̱yivi Ndióxi̱, tátá yo̱ xi̱hín ndinuhu ini na tá quia̱hva cúni̱ ínima̱ yi̱i̱ Ndióxi̱ jáchi̱ quia̱hva já cúni̱ Ndióxi̱, tátá yo̱ ña̱ ná caja cáhnu ña̱yivi mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","A̱ cu̱ú cuni yó Ndióxi̱ jáchi̱ co̱ó toho yiquí cu̱ñu a sa̱há ña̱ cán quéa̱ xíní ñúhú caja cáhnu ña̱yivi mé á xi̱hín ínima̱ ná ta xi̱hín ndiñuhu ini na —na̱cachi Jesús xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A̱nda̱ já na̱cachi tucu ñá cán já: —Sa̱ cánda̱a̱ cáxí ini i̱ ña̱ va̱xi qui̱vi̱ quixi da̱ chindahá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi, mé da̱ cúú Cristo. Ta tá ná quixi da̱ cán já ndicani ndihi da nu̱ú nde̱ ndaja coo —na̱cachi ñá cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ñá: —Da̱ cán cúú ye̱he̱, da̱ cáha̱n xu̱hu̱n viti —na̱cachi Jesús xi̱hi̱n ñá. ");
INSERT INTO mksNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ta nani cáha̱n Jesús xi̱hi̱n ñá na̱xi̱nu̱ co̱o na̱ xíca tuun xi̱hi̱n á já na̱catóntó na̱ jáchi̱ na̱xini na ndítúhún a̱ xi̱hín in ñáñáha̱. Joo ni in túhún na̱ co̱ó na̱sa̱ha̱n ndeé ini na cu̱hu̱n na̱ nda̱ca̱ tu̱hún ñahá ndá a̱ cúni̱ ñá cán, á ndá sa̱ha̱ ndítúhún a̱ xi̱hi̱n ñá. ");
INSERT INTO mksNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tá na̱ndihi já na̱jándacoo ñá cán yoo ñá ta na̱quee ñá cua̱ha̱n ñá ñuu. Ta cán na̱casáhá cáha̱n ñá xi̱hín na̱ ñuu cán já cáchí ña̱ já xi̱hi̱n ná: ");
INSERT INTO mksNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Naha quíi̱ ndó. Cande̱hé ndó in da̱ta̱a, da̱ na̱ca̱ha̱n ndihi da tá quia̱hva na̱caja i̱. Á a̱ ju̱ú da̱ yóho cúú Cristo, da̱ na̱cachi Ndióxi̱ chindahá a̱ cacomí cuéntá sa̱há ña̱yivi —na̱cachi ñá cán xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tá na̱ndihi já na̱queta ndihi na̱ cán cua̱ha̱n na̱ xi̱hi̱n ña̱ nu̱ íin Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Joo tá cáma̱ni̱ xi̱nu̱ co̱o na nu̱ íin Jesús já na̱jáca̱ha̱n na̱ xíca xi̱hi̱n á mé á ña̱ ná cuxu a va̱tí loho. ");
INSERT INTO mksNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","A̱nda̱ já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á cán: —Sa̱ íin va ña̱ha cuxu u̱. Ta ndóhó, co̱ xíni̱ toho ndó ndá a̱ que̱á —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tá na̱ndihi já na̱casáhá na̱ cán ndáca̱ tu̱hún táhan na já cáchí na̱ já: —Ndá na̱ sa̱ na̱quixi ñehe va ña̱ha cuxu a —cáchí xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sa̱há ña̱ cán quéa̱ na̱cachi Jesús já xi̱hi̱n ná: —Tá quia̱hva ndíva̱ha ini ña̱yivi tá xíxi na quia̱hva já ndíva̱ha ini i̱ tá cája i̱ chuun ña̱ na̱chindahá Ndióxi̱ ye̱he̱ caja i̱ ñuyíví yóho. Ta xíní ñúhú caja i̱ ña̱ ja̱nda̱ quia̱hva ná jáxi̱nu̱ co̱o i̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Xíní ñúhú ndiñehe ndó nu̱u̱ ndó cande̱hé ndo̱ ña̱yivi jáchi̱ cúú ná tátu̱hun nu̱ú na̱xutu na trigo. Joo co̱ xíní ñúhú caja ndó tá quia̱hva cája ña̱yivi tá ndáti na co̱mí yo̱o̱ jáquee na trigo. Jáchi̱ viti ñúhú íin tia̱hva ña̱yivi ndiquehe na tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ndá na̱ xíca chíndeé ña̱yivi ndiquehe na tu̱hun Ndióxi̱, na̱ cán cúú ná tátu̱hun na̱ xíca jáquee trigo. Ta a̱ cája chúun uun toho na jáchi̱ quehe na ya̱hvi sa̱há chuun cája na. Ta na̱ ndíquehe tu̱hun Ndióxi̱ cán cúú na̱ cu̱hu̱n catacu indiví a̱nda̱ ama cáa qui̱vi̱. Ta sa̱há na̱ cán cavatá da̱ na̱xutu xi̱hín da̱ na̱jáquee. ");
INSERT INTO mksNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jáchi̱ íin in tu̱hun ta nda̱a̱ cáha̱n ña̱. Já cáchí a̱ já: “In da xútu ta inga da jáquee jáchi̱ cúú ndíví da̱ da̱ cája chúun nu̱ú in xitoho.” ");
INSERT INTO mksNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ta quia̱hva já na̱ya̱ha xi̱hi̱n mé ndó jáchi̱ ye̱he̱ na̱chindahá i̱ ndo̱hó ña̱ ná cu̱hu̱n ndó chindeé ndo̱ ña̱yivi ndi̱hvi na íchi̱ cuéntá Ndióxi̱ va̱tí co̱ó na̱ndoho ini ndó ca̱xi tu̱hun ndó tu̱hun Ndióxi̱ xi̱hi̱n ná. Jáchi̱ inga na na̱ca̱xi tu̱hun tu̱hun Ndióxi̱ xi̱hín na̱ cán joo ndóhó ñéhe̱ táhvi̱ ndó chíndeé ndó na̱ ndi̱hvi na íchi̱ cuéntá Ndióxi̱ —na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán nani cáma̱ni̱ xi̱nu̱ co̱o ña̱yivi ñuu cán nu̱ á. ");
INSERT INTO mksNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ta cua̱há ña̱yivi ñuu Samaria cán na̱candúsa na Jesús sa̱há ña̱ na̱ca̱ha̱n ñáñáha̱ cán xi̱hi̱n ná jáchi̱ na̱cachi ñá cán já xi̱hi̱n ná: “Na̱cachi mé á xi̱hín i̱ ndaja cáa tócó ndihi ña̱ na̱caja i̱.” ");
INSERT INTO mksNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sa̱há ña̱ cán quéa̱ tá na̱xi̱nu̱ co̱o na̱ Samaria cán nu̱ íin Jesús já na̱xi̱ca̱ ta̱hví na̱ nu̱ á ña̱ ná coo chága̱ xi̱hi̱n ná. Sa̱há ña̱ cán quéa̱ na̱cando̱o Jesús na̱sahi̱in a i̱vi̱ qui̱vi̱ xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ta cua̱há java ga̱ na̱ Samaria cán na̱candúsa na Jesús sa̱há tu̱hun na̱ca̱ha̱n mé á xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Já na̱cachi mé na̱ Samaria cán xi̱hín ñáñáha̱ cán já: —Na̱candúsa nde̱ yo̱hó tá na̱ca̱hún sa̱há Jesús nu̱ú nde̱ joo viti cándeé ini nde̱ mé á jáchi̱ na̱xini jo̱ho nde̱ nu̱ cáha̱n mé á. Ta viti ndusa cándúsa nde̱ ña̱ cúú á Cristo, mé á na̱chindahá Ndióxi̱ jáca̱cu a ña̱yivi ñuyíví —na̱cachi na̱ Samaria cán xi̱hi̱n ñá. ");
INSERT INTO mksNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tá sa̱ na̱ya̱ha i̱vi̱ qui̱vi̱ na̱sahi̱in Jesús mé Samaria cán já na̱quee tucu a cua̱ha̱n chí estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jáchi̱ sa̱ na̱cachi mé Jesús já: “Ni in túhún toho profeta co̱ cája cáhnu na da̱ ñuu da”, na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Joo tá na̱xi̱nu̱ co̱o Jesús estado Galilea cán já na̱ndiquehe va̱ha na̱ cán mé á jáchi̱ sa̱ na̱sa̱ha̱n ri na̱ cán vicó pascua ñuu Jerusalén ta cán na̱xini na ña̱ náhnu na̱caja mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","A̱nda̱ já na̱xi̱nu̱ co̱o tucu Jesús ñuu Caná cuéntá Galilea cán nu̱ú na̱ndaja mé á ticui̱í na̱nduu dó vino. Ta mé ñuu cán na̱sahi̱in in da̱ta̱a, da̱ cája chúun cuéntá gobierno. Ta a̱ ju̱ú quia̱hva quíhvi̱ ja̱hyi da cándúhu̱ dá ñuu Capernaum. ");
INSERT INTO mksNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ta tá na̱xini jo̱ho da̱ cán ña̱ sa̱ na̱quee Jesús estado Judea ta íin a estado Galilea viti já ndáva da na̱sa̱ha̱n da̱ nu̱ á já na̱xi̱ca̱ ta̱hví da̱ nu̱ á ña̱ ná cu̱hu̱n a̱ vehe da ndaja va̱ha ja̱hyi da jáchi̱ sa̱ ndícáhví da̱ cándúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tá na̱ndihi já na̱cachi Jesús já xi̱hi̱n dá: —Ndúsa̱ caja i̱ ña̱ náhnu xi̱hín ña̱ xitúhún nu̱ ndo̱ já cuu candúsa ndó ye̱he̱ á tá co̱ó ta co̱ cúni̱ ndó candúsa ndó ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","A̱nda̱ já na̱nducú ñehe da̱ cája chúun cuéntá gobierno cán tu̱hun nu̱ú Jesús já na̱cachi da já xi̱hi̱n á: —Á a̱ cu̱ú caja ndó ña̱ma̱ni̱ cu̱hu̱n quíi̱ ndó vehe e̱ jáchi̱ cúni̱ quivi ja̱hyi i̱ —na̱cachi da xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Cuáhán ndicó co̱o ndó vehe ndó jáchi̱ na̱ndiva̱ha ja̱hyi ndó —na̱cachi Jesús xi̱hi̱n dá. Ta na̱candúsa da̱ cán ña̱ na̱cachi Jesús xi̱hi̱n dá chí na̱quee da na̱ndicó co̱o da cuanúhu̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ta tá sa̱ yati xi̱nu̱ co̱o da vehe da já ndáva nihni na̱ cúú mozo da na̱sa̱ha̱n na̱ ñe̱he̱ ná da̱ já na̱cachi na já xi̱hi̱n dá: —Sa̱ co̱ quíhvi̱ ga̱ ja̱hyi ndó viti. ");
INSERT INTO mksNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A̱nda̱ já na̱nda̱ca̱ tu̱hún da̱ cán mozo da̱ já cáchí da̱ já: —Ndá hora na̱casáhá na̱ndiva̱ha ja̱hyi i̱ —na̱cachi da xi̱hi̱n ná. Já na̱cachi na̱ cán já: —Cuni tátu̱hun ca̱a̱ in sa̱hini já na̱ndindaa ña̱ chíca̱a̱n cáhni̱ á da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Xi̱hín ña̱ yóho na̱canda̱a̱ ini da̱ cán ña̱ mé a̱ nda̱a̱ na̱ndaja va̱ha Jesús ja̱hyi da jáchi̱ mé hora cán na̱cachi Jesús xi̱hi̱n dá ña̱ tácú tá tácú ja̱hyi da. Sa̱há ña̱ cán quéa̱ na̱candúsa mé dá xi̱hín na̱ vehe da Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ta xi̱hín ña̱ yóho na̱xi̱nu̱ i̱vi̱ ña̱ xitúhún na̱caja Jesús estado Galilea cán a̱nda̱ nani na̱quee a Judea já na̱ndicó co̱o tucu a Galilea. ");
INSERT INTO mksNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tá na̱ya̱ha ña̱ yóho já na̱quee Jesús cua̱ha̱n ñuu Jerusalén nu̱ cája na̱ Israel víco̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ta mé nu̱ quíhvi joho na ñuu Jerusalén cán íin in yéhé naní yéhé ndicachi. Ta yati cán na̱sahi̱in in vehe ta íin u̱hu̱n yuyéhé nu̱ quíhvi na ini a ta ini mé vehe cán ndáca̱a̱n in pila cáhnu nu̱ ñúhu ticui̱í ta naní a̱ Betesda tu̱hun hebreo. ");
INSERT INTO mksNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ta níí ini mé vehe cán na̱caníhni na̱ quíhvi̱ ndúu na. Java na̱ cúú ná na̱ cua̱á. Java na quíhvi̱ sa̱ha̱. Ta java na na̱xi̱hi̱ tu̱chu. Níí cán na̱caníhni na ndúu na ndáti na ndica̱nda̱ ticui̱í cán. ");
INSERT INTO mksNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jáchi̱ ndá tañu núu táto̱ Ndióxi̱ ta jándica̱nda̱ mé á ticui̱í cán. Ta ndá na̱ ná que̱ta nuu nu̱ cuítí ini mé ticui̱í cán tá na̱ndihi na̱ndica̱nda̱ do̱ já ndiva̱ha na ta co̱ cája toho a ndá cue̱he̱ ndóho na. ");
INSERT INTO mksNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ta tañu tócó ndihi na̱ quíhvi̱ na̱sa̱nduu cán na̱sa̱ndaca̱a̱n in da̱ta̱a, da̱ sa̱ íin o̱co̱ sa̱hu̱n u̱ni̱ cui̱a̱ quíhvi̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ta tá na̱xini Jesús cándúhu̱ dá tañu na̱ quíhvi̱ cán ta tá na̱canda̱a̱ ini a ña̱ sa̱nahá ndiva̱ha quíhvi̱ da̱ já na̱nda̱ca̱ tu̱hún a̱ da̱ já na̱cachi a já xi̱hi̱n dá: —Á ndiva̱hún cúnu̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","A̱nda̱ já na̱nducú ñehe da̱ cán tu̱hun nu̱ á já na̱cachi da já: —Co̱ó ni in ña̱yivi yóho ña̱ chindeé na̱ ye̱he̱ que̱ta nuu i̱ ini ticui̱í tá ndíca̱nda̱ do̱. Jáchi̱ tá ja̱cá cáhán uun i̱ jáque̱ta i̱ mí i̱, sa̱ na̱quee va̱ha va inga na nu̱ú i̱. Ña̱ cán quéa̱ a̱ cu̱ú ndiva̱ha i̱ —na̱cachi da̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Cuáhán ndaco̱o nditivún yívu̱n ta cuanúhu̱n —na̱cachi Jesús xi̱hín da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tá na̱cachi Jesús já chí i̱vi̱ la̱á na̱ndiva̱ha da̱ quíhvi̱ cán já na̱ndiquehe da yívi̱ dá já na̱casáhá da̱ xíca da. Ta sa̱há ña̱ cúú á qui̱vi̱ ndíquehe ndée̱ ná ");
INSERT INTO mksNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","sa̱há ña̱ cán quéa̱ na̱queta java na̱ sa̱cua̱ha̱ nu̱ú na̱ Israel já na̱cachi na já xi̱hi̱n dá: —Viti cúú á qui̱vi̱ ndíquehe ndée̱ yo̱ ta co̱ ndítahan toho nu̱u̱n cojún yívu̱n caca nuún —na̱cachi na xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A̱nda̱ já na̱nducú ñehe da̱ cán tu̱hun nu̱ ná já na̱cachi da já: —Mé da̱ na̱ndaja va̱ha ye̱he̱ cán cúú da̱ na̱sahnda chuun nu̱ú i̱ ña̱ ná cojo i̱ yívi̱ cu̱hu̱n i̱ —na̱cachi da̱ cán xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Já na̱nda̱ca̱ tu̱hún tucu na̱ Israel cán da̱ já na̱cachi na já: —Yo já na̱cachi xu̱hu̱n ña̱ ná ndicojún yívu̱n cu̱hu̱n —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Joo da̱ cán co̱ xíni̱ da̱ yo na̱ndaja va̱ha ñahá jáchi̱ tá na̱ndaja va̱ha Jesús da̱ já na̱qui̱hvi nuu a cán tañu ña̱yivi cua̱ha̱ cán cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tá na̱ndihi já na̱nditahan Jesús da̱ cán ini veñu̱hu cáhnu já na̱cachi a já xi̱hi̱n dá: —Cande̱hé. Sa̱ co̱ quíhvi̱ ga̱ún viti. A̱ ndícó co̱o ga̱ún cajún cua̱chi jáchi̱ tia̱hva náá quixi ña̱ ndeé chága̱ ví ndohún —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tá na̱ndihi já ndáva da̱ cán na̱sa̱ha̱n da̱ cáxi tu̱hun da nu̱ú na̱ Israel ña̱ Jesús cúú ña̱ na̱ndaja va̱ha ñahá. ");
INSERT INTO mksNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sa̱há ña̱ cán quéa̱ na̱casáhá na̱ Israel cán cája xíxi na xi̱hín Jesús. Ndúcú na̱ cahní na̱ a̱ sa̱há ña̱ cája chúun a ndája va̱ha mé á na̱ quíhvi̱ qui̱vi̱ ndíquehe ndée̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Cája chúun ta cája chúun Ndióxi̱, tátá i̱ sa̱há ña̱ cán quéa̱ cája chúun ta cája chúun ri ye̱he̱ va —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sa̱há ña̱ cán quéa̱ ví ga̱ ví cúni̱ na̱ Israel cán cahní na̱ Jesús jáchi̱ cáchí na̱ co̱ cája cáhnu a Ndióxi̱ qui̱vi̱ ndíquehe ndée̱ ná tá quia̱hva cáchí ley. Ta cúni̱ na̱ cahní na̱ mé á jáchi̱ cáchí a̱ ña̱ cúú á in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ ta xi̱hín ña̱ yóho ndája mé á tátu̱hun mé Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Já na̱cachi Jesús já xi̱hín na̱ Israel cán: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Ye̱he̱ cúú u̱ in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ ta co̱ cája i̱ ni in ña̱ha cuéntá mí i̱ jáchi̱ cája i̱ ña̱ xíní i̱ cája Ndióxi̱, tátá i̱. Ta tócó ndihi ña̱ cája tátá i̱ ña̱ cán cúú ña̱ cája ri ye̱he̱ va. ");
INSERT INTO mksNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Jáchi̱ sa̱há ña̱ quíhvi̱ ini Ndióxi̱, tátá i̱ ye̱he̱ sa̱há ña̱ cán quéa̱ náha̱ mé á nu̱ú i̱ ndaja táhan ña̱ha cája mé á. Ta ja̱nda̱ ña̱ha náhnu chága̱ ví na̱ha̱ mé á nu̱ú i̱ ta chí catóntó ndihi ndó tá ná cuni ndó ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jáchi̱ tá quia̱hva cája Ndióxi̱, tátá i̱ jánditacu a ndi̱i ña̱ ná catacu na quia̱hva já cuu caja ri ye̱he̱ jánditacu u̱ na̱ cúni̱ mí i̱ catacu. ");
INSERT INTO mksNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ta mé Ndióxi̱, tátá i̱ co̱ cája vií toho a sa̱há ña̱yivi. Ña̱ na̱caja mé á quéa̱ na̱sa̱ha̱n ña̱ma̱ni̱ nu̱ú i̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi mé á, ña̱ ná caja vií i̱ sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Já quéa̱ ná caja cáhnu ña̱yivi ye̱he̱ tá quia̱hva cája cáhnu na Ndióxi̱, tátá i̱. Jáchi̱ ndá na̱ co̱ cája cáhnu ye̱he̱ náha̱ ña̱ co̱ cája cáhnu na Ndióxi̱, tátá i̱ jáchi̱ mé a̱ cán na̱chindahá ye̱he̱ va̱xi i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ʼMé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Ndá na̱ táa jo̱ho va̱ha nu̱ cáha̱n i̱ ta cándúsa na Ndióxi̱, mé a̱ na̱chindahá ye̱he̱ quixi i̱, na̱ cán cúú na̱ catacu a̱nda̱ ama cáa qui̱vi̱. Ta a̱ jándoho Ndióxi̱ ini na indayá jáchi̱ cúú á tátu̱hun sa̱ na̱jánditacu tucu Ndióxi̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱ ña̱ va̱xi qui̱vi̱ ta cúú á tiempo viti tá na̱ co̱ tácú cuni jo̱ho na ña̱ cáha̱n ye̱he̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱. Ta ndá na̱ ná ndiquehe va̱ha tu̱hun cáha̱n i̱ xi̱hi̱n ná catacu na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jáchi̱ tá quia̱hva cuu caja Ndióxi̱ catacu ña̱yivi quia̱hva já na̱caja mé á ña̱ ná caja ri ye̱he̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi mé á, ña̱ ná cuu catacu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ta na̱sa̱ha̱n mé á ña̱ma̱ni̱ nu̱ú i̱ ña̱ ná caja vií i̱ sa̱há ña̱yivi ñuyíví jáchi̱ ye̱he̱ cúú da̱ na̱quixi indiví nduu in ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","A̱ cátóntó ndo̱ sa̱há ña̱ cáha̱n i̱ xi̱hi̱n ndo̱ yóho jáchi̱ mé a̱ nda̱a̱ va̱xi qui̱vi̱ tá cuni jo̱ho tócó ndihi na̱ sa̱ na̱xi̱hi̱ nu̱ú ca̱ha̱n i̱ xi̱hi̱n ná ");
INSERT INTO mksNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","já queta na camasanto. Ta na̱ na̱caja va̱ha cán nditacu na ta cu̱hu̱n na̱ catacu na a̱nda̱ ama cáa qui̱vi̱. Ta na̱ na̱caja ña̱ quini nditacu na ta cu̱hu̱n na̱ indayá ndoho ini na. ");
INSERT INTO mksNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ʼTócó ndihi ña̱ cája i̱ a̱ ju̱ú in túhún mí i̱ caja ña̱. Tá quia̱hva sáhndá Ndióxi̱, tátá i̱ chuun nu̱ú i̱ ña̱ ná caja vií i̱ sa̱há ña̱yivi quia̱hva já cája vií i̱ sa̱ha̱ ná. Ta cája vií nda̱a̱ i̱ sa̱ha̱ ná jáchi̱ co̱ ndúcú u̱ caja i̱ ña̱ cúni̱ mí i̱. Ña̱ ndúcú u̱ caja i̱ cúú ña̱ cúni̱ Ndióxi̱, tátá i̱ caja i̱ jáchi̱ mé á na̱chindahá ye̱he̱ quixi i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jáchi̱ tá sa̱ha̱ mí i̱ ná caca nuu i̱ ca̱ha̱n i̱, co̱ nditahan ndíquehe ndó ña̱ cáha̱n i̱ sa̱há i̱. Co̱ ndítahan nu̱ú i̱ ca̱ha̱n i̱ sa̱ha̱ mí i̱ ");
INSERT INTO mksNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","jáchi̱ íin inga ña̱ cáha̱n sa̱há i̱ ta ña̱ cáha̱n mé a̱ cán sa̱há i̱ cúú á ña̱ nda̱a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ta mé ndó na̱chindahá ndo̱ java na na̱sa̱ha̱n na̱ ndáca̱ tu̱hún na̱ Juan sa̱há i̱. Ta ña̱ nda̱a̱ na̱sa̱cuu tócó ndihi tu̱hun na̱nducú ñehe da̱ cán nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Va̱tí co̱ ndáti i̱ cándúsa ndó ye̱he̱ sa̱há ña̱ cáha̱n in ña̱yivi sa̱há i̱ joo cuu ca̱cu ndaa ínima̱ ndó tá ná candúsa ndó ña̱ cáha̱n Juan sa̱há i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jáchi̱ mé Juan, da̱ na̱caja ndúta̱ ña̱yivi cán na̱sa̱cuu da tátu̱hun in íti̱, dó jándiyéhe̱ nu̱u̱ ndo̱. Joo chá tiempo cuití va na̱caji̱i̱ ini ndó xi̱hín tu̱hun na̱ca̱ha̱n da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Íin inga ña̱ cáhnu chága̱ a̱ ju̱ú ga̱ ña̱ na̱ca̱ha̱n Juan sa̱há i̱. Ta ña̱ cán cúú á ña̱ náhnu xi̱hín ña̱ xitúhún na̱xini ndó na̱caja i̱. Ta ña̱ yóho náha̱ nu̱ ndo̱ yo cúú ye̱he̱ ta náha̱ ña̱ cúú á ña̱ nda̱a̱ ña̱ na̱chindahá Ndióxi̱, tátá i̱ ye̱he̱. Jáchi̱ tócó ndihi ña̱ cája i̱ cúú á ña̱ na̱cachi Ndióxi̱, tátá i̱ xi̱hín i̱ caja i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ta Ndióxi̱, tátá i̱, mé á na̱chindahá ye̱he̱ náha̱ tu̱hun sa̱há i̱. Joo ndóhó, co̱ xíni̱ jo̱ho ndó nu̱ cáha̱n mé á ta ni co̱ xíní tívi ndó a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ta ni co̱ó tu̱hun mé á ndáca̱a̱n ínima̱ ndo̱ jáchi̱ co̱ cándúsa ndó ye̱he̱, da̱ na̱chindahá mé á quixi ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Va̱tí jácuaha va̱ha ndó tu̱hun Ndióxi̱ sa̱há ña̱ ndúcú ndo̱ ndaja cuu catacu ndó a̱nda̱ ama cáa qui̱vi̱ joo co̱ cánda̱a̱ ini ndó ña̱ mé tu̱hun Ndióxi̱ cán cúú á ña̱ cáha̱n sa̱há ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ta co̱ cúni̱ ndó quixi ndó nu̱ú i̱ já ná caja i̱ ña̱ ná catacu ndó a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ʼCo̱ ndúcú toho i̱ ña̱ ná caja cáhnu ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Sa̱ xíni̱ va̱ha i̱ ínima̱ ndo̱ ta cánda̱a̱ ini i̱ ña̱ co̱ quíhvi̱ ini ndó Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na̱xi̱nu̱ i̱ ñuyíví yóho cuéntá Ndióxi̱, tátá i̱ ta co̱ cúni̱ ndó ndique̱he va̱ha ndó ye̱he̱. Joo tá ná quixi in da cuéntá mé dá já ndique̱he va̱ha ndusa ndó da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jáchi̱ mé ndó cátóó ndó cando̱o va̱ha ndó nu̱ú ña̱yivi cuití va ta co̱ ndúcú ndó cando̱o va̱ha ndó nu̱ Ndióxi̱. Sa̱há ña̱ cán quéa̱ i̱hvi̱ ndiva̱ha cúú ini ndó cándeé ini ndó in túhún ji̱ni̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Coto a̱ ju̱ú ca̱hán ndo̱ ña̱ jácojo i̱ cua̱chi ja̱ta̱ ndo̱ nu̱ Ndióxi̱, tátá i̱. Mé ley na̱ca̱hyí Moisés, ña̱ cán cúú á chíca̱a̱n cua̱chi ja̱ta̱ ndó va̱tí cándeé ini ndó da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tá ta̱ mé a̱ nda̱a̱ cándúsa ndó ña̱ na̱ca̱hyí Moisés sa̱nahá já quéa̱ cándúsa ndó ye̱he̱ jáchi̱ sa̱há ye̱he̱ na̱ca̱hyí Moisés sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Joo sa̱há ña̱ co̱ cándúsa ndó ña̱ na̱ca̱hyí Moisés sa̱há i̱ sa̱há ña̱ cán quéa̱ co̱ cándúsa ndó ña̱ cáha̱n i̱ xi̱hi̱n ndo̱ —na̱cachi Jesús xi̱hín na̱ Israel cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tá sa̱ na̱ya̱ha tócó ndihi ña̱ yóho já na̱quee Jesús cua̱ha̱n inga xoo tañu̱hú Galilea cán. Ta mé tañu̱hú cán cáha̱n tucu na xi̱hi̱n dó naní do̱ Tiberias. ");
INSERT INTO mksNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ta cua̱há ndiva̱ha ña̱yivi ndíco̱ ja̱ta̱ Jesús cua̱ha̱n na̱ jáchi̱ na̱xini na ña̱ náhnu na̱caja mé á tá na̱ndaja va̱ha mé á na̱ quíhvi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tá na̱ndihi já na̱ndaa Jesús in xi̱qui̱ ta cán na̱saco̱o a xi̱hín na̱ xíca tuun xi̱hín a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ta mé tiempo já sa̱ cáyati vicó pascua ña̱ cája mé na̱ Israel cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ta tá na̱ndicoto nihni Jesús já na̱xini a ña̱ ndíco̱ cua̱há ña̱yivi ja̱tá va̱xi na já na̱cachi a já xi̱hín Felipe: —Ndájá cájún cuéntá co̱hó cueen na̱há yo̱ ña̱ cuxu tócó ndihi ña̱yivi yóho —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na̱cachi Jesús ña̱ yóho xi̱hín Felipe jáchi̱ cúni̱ a̱ cuni a ndía̱ cachi da̱ cán xi̱hi̱n á. Jáchi̱ sa̱ xíni̱ va̱ha Jesús ndáa̱ quéa̱ caja ña̱ ná cuxu ndihi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","A̱nda̱ já na̱nducú ñehe Felipe tu̱hun nu̱ú Jesús já na̱cachi da já xi̱hi̱n á: —Ni i̱vi̱ ciento denario ná cañehé, a̱ quéta toho ña̱ cán cueén pan ná quia̱hva in yuhú in yuhú cuxu in in ña̱yivi ndúu yóho —na̱cachi da̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A̱nda̱ já na̱ca̱ha̱n Andrés, da̱ cúú in táhan na̱ xíca tuun xi̱hín Jesús, da̱ cúú ñani Simón Pedro. Já na̱cachi da já xi̱hín Jesús: ");
INSERT INTO mksNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Yóho íin in ta̱a loho ta ñéhe da u̱hu̱n pan cebada xi̱hín i̱vi̱ ti̱yacá. Joo ama ná queta ri ña̱ yóho cuxu tócó ndihi ña̱yivi ja̱n —na̱cachi Andrés xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A̱nda̱ já na̱cachi Jesús já: —Ca̱ha̱n ndó xi̱hi̱n ná ña̱ ná caco̱o na. A̱nda̱ já na̱saco̱o ndihi na̱ cán. Ta a̱ ju̱ú quia̱hva ndató na̱sahnu yu̱cu̱ nu̱ú na̱saco̱o tátu̱hun u̱hu̱n mil ta̱a. ");
INSERT INTO mksNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tá na̱ndihi já na̱tiin Jesús pan cán já na̱ndiquia̱hva ndixa̱hvi nu̱ Ndióxi̱. Ta tá na̱ndihi já na̱sa̱ha̱n ña̱ nu̱ú na̱ xíca tuun xi̱hi̱n á ta na̱ndicahnda na ña̱ nu̱ú na̱ ndúu coo cán. Ta quia̱hva já na̱caja ri a xi̱hín ti̱yacá va. Ta na̱xixi ndihi na ja̱nda̱ quia̱hva na̱chutú ti̱xi na. ");
INSERT INTO mksNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ta tá na̱ndihi já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á cán: —Jánditaca ndó tócó ndihi ña̱ na̱cando̱o ja̱n já ná a̱ tíví ña̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sa̱há ña̱ cán quéa̱ na̱jánditaca na ña̱ ta na̱jándicutú na̱ u̱xu̱ i̱vi̱ to̱yi̱cá xi̱hín ña̱ na̱cando̱o. ");
INSERT INTO mksNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tá na̱xini ndihi ña̱yivi cán ña̱ xitúhún na̱caja Jesús yóho já na̱casáhá cáchí xi̱hi̱n táhan na já: —Jivi ndusa da̱ yóho cúú profeta na̱cachi Ndióxi̱ chindahá a̱ ñuyíví yóho —cáchí xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Joo na̱quee Jesús cua̱ha̱n in túhún mé á coo a yúcu̱ jáchi̱ xíni̱ mé á ña̱ ndúcú ña̱yivi cañehe ndúsa̱ na̱ mé á jáchi̱ cúni̱ na̱ ndaja na mé á rey nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tá sa̱ na̱cuaá já na̱nuu na̱ xíca tuun xi̱hín Jesús xi̱qui̱ cán cua̱ha̱n chí yuhú tañu̱hú cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ta chí sa̱ na̱canaá va̱ha va ta co̱ó Jesús xínu̱ co̱o nu̱ ndúu na sa̱há ña̱ cán quéa̱ na̱ndaa na ja̱tá in barco ta na̱casáhá na̱ jándicaca na do̱ jáchi̱ cúni̱ na̱ cu̱hu̱n na̱ ñuu Capernaum. ");
INSERT INTO mksNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ta ndaja coo na̱casáhá ndíco̱jo̱ ticui̱í nu̱ú tañu̱hú cán jáchi̱ na̱casáhá xícó in ta̱chi̱ ndeé ndiva̱ha. ");
INSERT INTO mksNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ta tá sa̱ na̱caxícá na̱ u̱hu̱n á i̱ñu̱ kilometro cua̱ha̱n na̱ xi̱hi̱n barco cán nu̱ú ticui̱í já na̱xini na xíca sáhá Jesús cua̱ha̱n nu̱ú ticui̱í já cáyati a nu̱ barco cándójó na̱ cán. A̱nda̱ já na̱casáhá yíhví na̱ ndúu na. ");
INSERT INTO mksNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ta tá na̱xi̱nu̱ co̱o Jesús nu̱ ná já na̱cachi a já xi̱hi̱n ná: —A̱ cáyi̱hví toho ndó jáchi̱ ye̱he̱ va cúú u̱ —na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","A̱nda̱ já cávatá na̱ na̱jándaa na a̱ ja̱ta̱ barco. Ta i̱vi̱ la̱á sa̱ na̱xi̱nu̱ co̱o na nu̱ú cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tá na̱ti̱vi inga qui̱ví ita̱a̱n já na̱casáhá ña̱yivi ndínducú na̱ Jesús jáchi̱ na̱xini na ña̱ co̱ó na̱ndaa toho a in túhún barco na̱sahi̱in cán xi̱hín na̱ xíca tuun xi̱hi̱n a̱ jáchi̱ mé cuití na̱ cán sa̱ na̱ndaa cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ta nani ndúu na yuhú tañu̱hú yati nu̱ú na̱ndaja cua̱ha̱ Jesús pan tá na̱ndihi na̱ndiquia̱hva mé á ndixa̱hvi nu̱ Ndióxi̱ cán já na̱xi̱nu̱ co̱o java barco, dó na̱quixi chí ñuu Tiberias. ");
INSERT INTO mksNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ta sa̱há ña̱ co̱ó na̱nditahan na Jesús sa̱há ña̱ cán quéa̱ na̱ndaa na barco cán já na̱quee na cua̱ha̱n na̱ ñuu Capernaum ndinducú ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tá na̱xi̱nu̱ co̱o na̱ cán inga xoo tañu̱hú já na̱nditahan na Jesús. Ta na̱casáhá ndáca̱ tu̱hún na̱ mé á já cáchí na̱ já: —Maestro, ndá hora na̱xi̱nu̱ co̱o ndó yóho —na̱cachi na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Xíca ndó ndínducú ndó ye̱he̱ joo co̱ cúú á sa̱há ña̱ na̱canda̱a̱ ini ndó yo cúú ye̱he̱. Sa̱há ña̱ náhnu na̱caja i̱ tá na̱sa̱ha̱n i̱ ña̱ na̱xixi ndó ja̱nda̱ na̱chutú ti̱xi ndó sa̱há ña̱ cán quéa̱ ndínducú ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Co̱ ndítahan ndi̱hi nahá ini ndó sa̱há ña̱ cuxu ndó ñuyíví yóho. Ña̱ ndítahan caja ndó quéa̱ ndinducú ndó ndá quia̱hva catacu ndó a̱nda̱ ama cáa qui̱vi̱. Jáchi̱ ye̱he̱ cúú da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ta cuu caja i̱ ña̱ ná catacu ndó a̱nda̱ ama cáa qui̱vi̱. Jáchi̱ Ndióxi̱, tátá i̱ náha̱ ña̱ mé a̱ nda̱a̱ na̱ca̱xi a ye̱he̱ caja i̱ chuun yóho —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","A̱nda̱ já na̱cachi na̱ cán já xi̱hi̱n á: —Ndía̱ ndítahan nu̱ú nde̱ caja nde̱ já ná jáxi̱nu̱ co̱o nde̱ ña̱ cúni̱ Ndióxi̱ —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Já na̱cachi Jesús já xi̱hi̱n ná: —Ña̱ cúni̱ Ndióxi̱ caja ndó quéa̱ ná candúsa ndó ye̱he̱, da̱ na̱chindahá mé á ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","A̱nda̱ já na̱cachi tucu na̱ cán já xi̱hi̱n á: —Ndá ña̱ha xitúhún chága̱ cuu caja ndó nu̱ú nde̱ viti ña̱ ná cuni nde̱ ña̱ já ná cuu candúsa nde̱ ndo̱hó. Ndá a̱ náhnu quéa̱ cuu caja ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jáchi̱ mé tásáhnu jícó nde̱ na̱xixi na pan tá na̱xi̱ca na yucú íchí nu̱ co̱ ndúu ña̱yivi cán. Já cáchí tu̱hun Ndióxi̱ já: “Na̱xixi na pan ña̱ na̱quixi indiví na̱caja Moisés” —na̱cachi na̱ cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Já na̱cachi Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. A̱ ju̱ú toho Moisés cúú da̱ na̱sa̱ha̱n pan ña̱ na̱quixi indiví nu̱ ná. Jáchi̱ Ndióxi̱, tátá i̱ cúú ndusa ña̱ na̱sa̱ha̱n pan na̱quixi indiví nu̱ ná. Ta viti cúni̱ Ndióxi̱ quia̱hva in ña̱ha va̱ha chága̱ nu̱ ndo̱ a̱ ju̱ú ga̱ ña̱ na̱sa̱ha̱n Moisés nu̱ú na̱ cán sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jáchi̱ ye̱he̱ cúú u̱ tátu̱hun pan ña̱ na̱nuu indiví na̱caja Ndióxi̱ ña̱ ná cuu catacu ña̱yivi a̱nda̱ ama cáa qui̱vi̱ —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","A̱nda̱ já na̱cachi na̱ cán já xi̱hi̱n á: —Nini qui̱vi̱ quia̱hva ndó táhan pan ja̱n nu̱ú nde̱, xitoho. ");
INSERT INTO mksNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Já na̱cachi Jesús já xi̱hi̱n ná: —Ye̱he̱ cúú u̱ tátu̱hun mé pan ja̱n. Tá ná ndiquehe ña̱yivi ye̱he̱ já ndiva̱ha ini na ta cúú á tátu̱hun a̱ cuíco ga̱ na̱. Ta ndá na̱ cándúsa na mí i̱ já cúú á tátu̱hun a̱ íchi̱ ga̱ ini na ticui̱í. ");
INSERT INTO mksNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Joo cúú á tá quia̱hva na̱cachi i̱ xi̱hi̱n ndo̱: co̱ cándúsa toho ndó ye̱he̱ va̱tí xíní ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Joo tócó ndihi na̱ va̱xi nu̱ú i̱ cája Ndióxi̱, na̱ cán cúú na̱ cándúsa ye̱he̱. Ta ndá na̱ cándúsa ye̱he̱, na̱ cán co̱ táxí i̱ na̱ ña̱ ná quee na cu̱hu̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jáchi̱ va̱tí na̱nuu i̱ indiví nu̱ íin Ndióxi̱ joo co̱ó na̱quixi i̱ caja i̱ ña̱ cúni̱ mí i̱. Va̱xi i̱ caja i̱ ña̱ cúni̱ Ndióxi̱, tátá i̱ jáchi̱ mé á na̱chindahá ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ta ña̱ cúni̱ Ndióxi̱ quéa̱ ña̱ ná a̱ quiáhva i̱ ña̱ma̱ni̱ ndihi sa̱há na̱ na̱sa̱ha̱n mé á nu̱ú i̱. Ña̱ cúni̱ mé á quéa̱ ná jánditacu u̱ tócó ndihi na tá ná xi̱nu̱ co̱o qui̱ví nu̱ ndíhí. ");
INSERT INTO mksNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ña̱ cúni̱ Ndióxi̱ quéa̱ ná catacu ña̱yivi, na̱ cándeé ini ye̱he̱ a̱nda̱ ama cáa qui̱vi̱. Ta ye̱he̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi mé á jánditacu u̱ na̱ qui̱vi̱ nu̱ ndíhí cuíí —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A̱nda̱ já na̱casáhá na̱ Israel cán cáha̱n núu na sa̱há Jesús jáchi̱ sa̱ na̱cachi a ña̱ cúú á tátu̱hun pan ta na̱cachi a ña̱ na̱nuu a chí indiví. ");
INSERT INTO mksNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ta já na̱cachi xi̱hi̱n táhan na̱ cán já: —Á a̱ ju̱ú ja̱hyi José va cúú Jesús yóho. Ta xíni̱ va̱ha va mí yo cúú náná da̱ xi̱hi̱n tátá da̱. Ta ndá cuéntá quéa̱ cáchí ri da ña̱ na̱quixi da chí indiví, dá já —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —A̱ cáha̱n núu ga̱ ndó sa̱há i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jáchi̱ jáca̱ha̱n Ndióxi̱, tátá i̱, ña̱yivi ña̱ ná candúsa na ye̱he̱. Ta ni in túhún toho ña̱yivi a̱ cu̱ú candúsa na ye̱he̱ tá ta̱ co̱ jáca̱ha̱n Ndióxi̱ ínima̱ ná, mé á na̱chindahá ye̱he̱. Ta na̱ cán cúú na̱ jánditacu u̱ qui̱ví nu̱ ndíhí. ");
INSERT INTO mksNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Já na̱ca̱hyí na̱ profeta sa̱nahá: “Jána̱ha̱ Ndióxi̱ tócó ndihi ña̱yivi.” Ña̱ cán quéa̱ tócó ndihi ña̱yivi, na̱ xíni̱ jo̱ho nu̱ cáha̱n Ndióxi̱ ta cája na ña̱ jána̱ha̱ mé á nu̱ ná, na̱ cán cúú na̱ va̱xi nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ʼJoo a̱ ju̱ú ca̱hán ndo̱ ña̱ cuu cuni java ña̱yivi Ndióxi̱, tátá i̱. Jáchi̱ ye̱he̱, da̱ na̱chindahá mé á ñuyíví yóho, cúú in túhún da̱ xíní ñahá. ");
INSERT INTO mksNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Ndá na̱ cándeé ini ye̱he̱, na̱ cán cúú na̱ catacu a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jáchi̱ ye̱he̱ cúú u̱ tátu̱hun pan ña̱ cuu caja ña̱ ná catacu na. ");
INSERT INTO mksNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Sa̱ xíni̱ ndó tásáhnu jícó ndo̱ na̱xixi na pan yucú íchí sa̱nahá joo na̱xi̱hi̱ tá na̱xi̱hi̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Joo ye̱he̱ cúú u̱ tátu̱hun pan ña̱ na̱nuu chí indiví já quéa̱ ndá na̱ cándúsa ye̱he̱ cúú ná tátu̱hun na̱ xíxi pan ta já a̱ quíví na̱. Jáchi̱ tá ná cuxu na pan quia̱hva i̱ nu̱ ná já quéa̱ catacu na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ye̱he̱ cúú u̱ tátu̱hun mé pan xíxi na. Na̱nuu i̱ indiví ta a̱ cúu ndihi sa̱há i̱. Ta jivi mé yiquí cu̱ñu i̱ cúú á tátu̱hun pan xíxi na yóho ta va̱xi qui̱vi̱ ndiquia̱hva i̱ ña̱ nu̱ ná já ná cuu ca̱cu ndaa ínima̱ ná. Ta tá ná cuxu na ña̱ já catacu na a̱nda̱ ama cáa qui̱vi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A̱nda̱ já na̱casáhá na̱ Israel cán ndítúhún cue̱he̱ xi̱hi̱n táhan na já na̱cachi na já: —Cáchí da̱ yóho ña̱ cúú yiquí cu̱ñu da tátu̱hun pan xíxi ña̱yivi. Ndaja cuu caja ri da quia̱hva da ña̱ nu̱ yo̱ cuxú —cáchí xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. A̱ cu̱ú catacu ndó a̱nda̱ ama cáa qui̱vi̱ tá ta̱ co̱ cándúsa ndó ye̱he̱. Ta tá cándúsa ndó ye̱he̱ cúú á tátu̱hun xíxi ndó yiquí cu̱ñu i̱ ta cúú á tátu̱hun xíhi ndó ni̱í i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ndá na̱ xíxi na yiquí cu̱ñu i̱ ta xíhi na ni̱í i̱, na̱ cán cúú na̱ ca̱cu ndaa ínima̱ ná ta jánditacu u̱ na̱ qui̱vi̱ nu̱ ndíhí. ");
INSERT INTO mksNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Jáchi̱ yiquí cu̱ñu i̱ cúú ndusa tátu̱hun in ña̱ha va̱ha ndiva̱ha cuxu na ta ni̱í i̱ cúú dó tátu̱hun in dó va̱ha xíhi na. ");
INSERT INTO mksNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ndá na̱ ná ndiquehe va̱ha ye̱he̱ cúú á tátu̱hun ndiquehe va̱ha na in pan cuxu na ta cúú á tátu̱hun ndiquehe na ticui̱í xíhi na. Já quéa̱ in nduu na xi̱hín i̱ ta já in nduu ri ye̱he̱ va xi̱hi̱n mé ná. ");
INSERT INTO mksNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ta sa̱há ña̱ tácú Ndióxi̱, tátá i̱, mé a̱ na̱chindahá ye̱he̱ sa̱há ña̱ cán quéa̱ tácú ri ye̱he̱ va cája mé á. Quia̱hva já ya̱ha ri xi̱hín ña̱yivi jáchi̱ tá ná ndiquehe va̱ha na ye̱he̱ já catacu na caja i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jáchi̱ ye̱he̱ cúú u̱ ndusa tátu̱hun pan ña̱ na̱nuu indiví. Ta co̱ cúú á tátu̱hun ña̱ na̱ya̱ha xi̱hi̱n tásáhnu jícó ndo̱ tá na̱xixi na pan naní maná yucú íchí cán jáchi̱ tá na̱ndihi na̱xi̱hi̱ tá na̱xi̱hi̱ na̱ cán. Joo ndá na̱ cándeé ini ye̱he̱ cúú ná tátu̱hun na̱ xíxi pan ña̱ na̱quixi indiví. Ta na̱ cán catacu na a̱nda̱ ama cáa qui̱vi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tócó ndihi ña̱ yóho na̱jána̱ha̱ Jesús nu̱ ná ini veñu̱hu ñuu Capernaum cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ta cua̱há táhan na̱ xíca xi̱hín Jesús cán tá na̱xini jo̱ho na ña̱ na̱ca̱ha̱n mé á já na̱casáhá cáha̱n núu na sa̱há já cáchí na̱ já: —Yáncá ndiva̱ha candúsa í tu̱hun cáha̱n Jesús yóho. A̱ cúu toho caja í xi̱hi̱n á —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tá na̱xini Jesús ña̱ cáhvi núu ini na̱ xíca xi̱hín a̱ cán já na̱casáhá cáchí a̱ já xi̱hi̱n ná: —Ndíhi̱hvi̱ ndó sa̱há tu̱hun na̱ca̱ha̱n i̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ndaja ga̱ ví ndihi̱hvi̱ ndó tá ná cuni ndó ye̱he̱ ndaa i̱ cu̱hu̱n i̱ indiví nu̱ú na̱sahi̱in i̱ jáchi̱ ye̱he̱ cúú u̱ da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na̱sa̱ha̱n Ndióxi̱ in ínima̱ nu̱ú in in ña̱yivi ña̱ ná chindeé a̱ na̱ ndinducú na̱ mé á. Joo yiquí cu̱ñu ña̱yivi co̱ chíndeé toho a na̱ ndínducú na̱ mé á. Ta tócó ndihi ña̱ na̱ca̱ha̱n i̱ xi̱hi̱n ndo̱ cúú á ña̱ cuu xi̱nu̱ ini ínima̱ ndo̱ ña̱ ná catacu ndó a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Joo ndúu java ndó cáma̱ní yi̱í candúsa ndó ña̱ cáha̱n i̱ xi̱hi̱n ndo̱ —na̱cachi a. Na̱cachi Jesús ña̱ yóho jáchi̱ sa̱ xíni̱ mé á a̱nda̱ sa̱ha̱ ndá na̱ cúú na̱ co̱ cándúsa ñahá. Ta sa̱ xíni̱ Jesús ndá da̱ cúú da̱ ji̱có túhún ñahá. ");
INSERT INTO mksNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A̱nda̱ já na̱cachi tucu a já: —Sa̱há ña̱ cán quéa̱ cáchí i̱ xi̱hi̱n ndó ña̱ ni in túhún toho ña̱yivi a̱ cu̱ú candúsa na ye̱he̱ tá co̱ jáca̱ha̱n Ndióxi̱ ínima̱ ná —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tá na̱cachi Jesús ña̱ yóho já quéa̱ cua̱ha̱ táhan na̱ na̱saxi̱ca xi̱hín a̱ cán na̱jándacoo na mé á ta chí co̱ó na̱xeen ga̱ na̱ caca nuu na xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","A̱nda̱ já na̱nda̱ca̱ tu̱hún Jesús ndíhu̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hín a̱ cán já na̱cachi a já xi̱hi̱n ná: —Á cu̱hu̱n ri ndóhó va cúni̱ ndo̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","A̱nda̱ já na̱nducú ñehe Simón Pedro tu̱hun nu̱ú Jesús já na̱cachi da já: —Cande̱hé ndo̱, xitoho i̱. Yo nu̱ú ga̱ cuu cu̱hu̱n nde̱. Tu̱hun cáha̱n ndó xi̱hín nde̱ caja ña̱ ná cu̱hu̱n nde̱ catacu nde̱ a̱nda̱ ama cáa qui̱vi̱ tá ná candúsa nde̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ta nde̱he̱ sa̱ na̱candúsa va nde̱ ndo̱hó. Ta sa̱ xíni̱ va̱ha nde̱ ña̱ cúú ndó Cristo, ña̱ in túhún ji̱ni̱ já ja̱hyi Ndióxi̱, ña̱ tácú indiví —na̱cachi Pedro cán xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","A̱nda̱ já na̱cachi Jesús já: —Mé a̱ nda̱a̱ na̱ca̱xi i̱ ndíhu̱xu̱ i̱vi̱ ndó ña̱ ná caca tuun ndó xi̱hín i̱. Ta va̱tí na̱ca̱xi i̱ ndihi ndó joo in táhan ndó cúú dá cuéntá tiñáhá sa̱cua̱ha̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na̱cachi Jesús ña̱ yóho sa̱ha̱ Judas, ja̱hyi Simón Iscariote jáchi̱ mé Judas cán cúú dá da̱ ji̱có túhún ñahá chága̱ chí nu̱u̱ va̱tí cúú dá in táhan da̱ u̱xu̱ i̱vi̱ na̱ xíca tuun xi̱hín Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tá na̱ya̱ha ña̱ yóho já na̱xi̱ca nuu Jesús tá ñuu tá ñuu estado Galilea cán. Co̱ó na̱xeen ga̱ cu̱hu̱n a̱ chí Judea jáchi̱ cán na̱casáhá na̱ ndúcú na̱ mé á cahní na̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Joo sa̱há ña̱ na̱cayati víco̱ tá ndúu ña̱yivi vehe ti̱yahvá válí cája na̱ Israel ");
INSERT INTO mksNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","sa̱há ña̱ cán quéa̱ na̱cachi java ñani Jesús já xi̱hi̱n á: —Ndía̱ cájún coún yóho. Cuáhán chí Judea já ná cuni na̱ xíca xu̱hu̱n cán ndaja ndáa ña̱ náhnu cájún. ");
INSERT INTO mksNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Jáchi̱ tá cúni̱ in da̱ta̱a na̱ha̱ da̱ ña̱ náhnu cája da já quéa̱ co̱ ndáco̱o je̱hé toho da cája da ña̱. Tá ta̱ mé a̱ nda̱a̱ cájún ña̱ náhnu já quéa̱ xíní ñúhú cajún ña̱ já ná cuni níí cúú ña̱yivi ndaja náhnu ña̱ha cájún —na̱cachi ñani Jesús xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Na̱cachi na̱ cán ña̱ yóho jáchi̱ ni mé ñani a cán co̱ó na̱candúsa ñahá. ");
INSERT INTO mksNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A̱nda̱ já na̱cachi Jesús xi̱hín na̱ cán já: —Cáma̱ní yi̱í ndindaa hora cu̱hu̱n i̱. Ta va̱ha ri ndóhó ndá hora na̱cuu va cuu cu̱hu̱n ndó ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Jáchi̱ ña̱yivi cája ña̱ núu ñuyíví yóho a̱ cu̱ú candají toho na ndo̱hó joo cándají na̱ ye̱he̱ jáchi̱ cáxí táhyí cáha̱n i̱ xi̱hi̱n ná ña̱ cája na ña̱ núu. ");
INSERT INTO mksNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cuáhán mé ndó víco̱ tá cúni̱ ndó cu̱hu̱n ndo̱ jáchi̱ ye̱he̱ a̱ cúhu̱n toho i̱ jáchi̱ cáma̱ní yi̱í xi̱nu̱ hora cu̱hu̱n i̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ña̱ yóho na̱cachi Jesús xi̱hín ñani a. Ta na̱cando̱o mé á estado Galilea cán. ");
INSERT INTO mksNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Joo tá na̱ndihi na̱quee ñani Jesús cán cua̱ha̱n na̱ víco̱ já na̱quee ri Jesús cua̱ha̱n mé víco̱ cán. Joo co̱ó na̱xeen a na̱ha̱ tívi a mé á nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ta mé na̱ sa̱cua̱ha̱ nu̱ú na̱ Israel cán na̱casáhá na̱ ndúcú na̱ Jesús: “Ndá xíca nuu da tañu víco̱ cán”, cáhán na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ta ja̱ndá joho ndítúhún ya̱á ña̱yivi sa̱há Jesús xíca nuu na víco̱ cán. Java na cáchí na̱ sa̱há Jesús ña̱ cúú dá ta̱a cája va̱ha. Ta java na cáchí na̱: “Co̱ cúú toho da ta̱a va̱ha jáchi̱ xíca nuu cuití da̱ jándahvi da ña̱yivi”, cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Joo ni in na co̱ sáhan ndeé ini ca̱ha̱n sa̱há nu̱ú na̱ sa̱cua̱ha̱ nu̱ú na̱ Israel cán jáchi̱ yíhví ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ta tá na̱ta̱hvi̱ java víco̱ cán já na̱qui̱hvi Jesús ini veñu̱hu cáhnu ñuu Jerusalén cán já na̱casáhá jána̱ha̱ nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ta tá xíni̱ jo̱ho na̱ Israel cán nu̱ cáha̱n Jesús chí cátóntó na̱ já na̱casáhá ndáca̱ tu̱hún táhan na já cáchí na̱ já: —Ndájá na̱catia̱hva na̱há da̱ yóho ña̱ jána̱ha̱ da̱ nu̱ yo̱ jáchi̱ a̱ ju̱ú da̱ na̱xi̱ca jácuaha cúú dá —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Ña̱ jána̱ha̱ i̱ nu̱ ndo̱ yóho co̱ cúú á ña̱ na̱quixi ji̱ni̱ mí i̱ jáchi̱ cúú á ña̱ quíxi nu̱ Ndióxi̱, tátá i̱, mé á na̱chindahá ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ta tá mé a̱ nda̱a̱ sácú ini ndó caja ndó ña̱ cúni̱ Ndióxi̱ já quéa̱ cuu canda̱a̱ ini ndó á cáha̱n i̱ cuéntá Ndióxi̱, á cáha̱n i̱ cuéntá mí cuití vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jáchi̱ ndá na̱ cáha̱n cuéntá mé ná já quéa̱ ndúcú na̱ ña̱ ná caja cáhnu ña̱yivi na̱. Joo ndá na̱ ndúcú ña̱ ná ndicáhnu mé á na̱chindahá ñahá cán, na̱ cán cúú ndusa na̱ cáha̱n ña̱ nda̱a̱ ta co̱ cája na ña̱ co̱ ndítahan nu̱ ná caja na. ");
INSERT INTO mksNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ʼMé a̱ nda̱a̱ na̱jándacoo Moisés ley nu̱ ndo̱ joo ni in túhún ndo̱ co̱ cája ndó ña̱ cáchí a̱. Ta viti cúni̱ ndó cahní ndó ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A̱nda̱ já na̱nducú ñehe na̱ cán tu̱hun nu̱ á já na̱cachi na já: —Rí quini va ndáca̱a̱n ini yóhó jáchi̱ ni in túhún toho na co̱ ndúcú cahní yo̱hó —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Chí cátóntó ndiva̱ha ndó sa̱há in túhún ña̱ cáhnu na̱caja i̱ qui̱vi̱ ndíquehe ndée̱ yo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Joo cande̱hé ndo̱. Moisés cúú da̱ na̱sahnda chuun nu̱ tásáhnu jícó yo̱ ña̱ ná chica̱a̱n na̱ marca yiquí cu̱ñu na va̱tí a̱ ju̱ú Moisés na̱tavá sa̱há, va̱ha. Mé tásáhnu jícó yo̱ na̱tavá sa̱há ta mé ndó chíca̱a̱n tá chíca̱a̱n ndó marca yiquí cu̱ñu ta̱a va̱lí va̱tí cúú á qui̱vi̱ ndíquehe ndée̱ yo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ta viti cáchí ndo̱ xi̱hín i̱ ndaja cáa ri ña̱ yóho. Mé ndó chíca̱a̱n ndó marca yiquí cu̱ñu da̱ va̱lí va̱tí cúú á qui̱vi̱ ndíquehe ndée̱ yo̱ jáchi̱ co̱ cúni̱ ndó ya̱ha nu̱ú ña̱ na̱sahnda Moisés nu̱ ndó. Ta viti xójo̱ ini ndó xi̱hín i̱ sa̱há ña̱ na̱ndaja va̱ha i̱ in níí yiquí cu̱ñu in da̱ta̱a qui̱vi̱ ndíquehe ndée̱ yo̱. Ndaja cáa ri ña̱ ja̱n cáa já. ");
INSERT INTO mksNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mé ndó ndaja na̱cuu cáha̱n núu ndó sa̱há ña̱yivi ta co̱ ndítahan toho caja ndó já. Jáchi̱ ndítahan nu̱ ndó canda̱a̱ ini ndó ña̱ cúú ña̱ nda̱a̱ —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ta java na̱ ñuu Jerusalén na̱casáhá ndáca̱ tu̱hún táhan na já cáchí na̱ já: —Á a̱ ju̱ú da̱ yóho cúú da̱ xíca na ndúcú na̱ cahní na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nu̱ ndíhi na cándichi da jána̱ha̱ da̱ ta ni in na co̱ ndáa cúu da. Á tá co̱ó ta ja̱nda̱ na̱ jutixia cáa cándúsa na ña̱ cúú dá Cristo, da̱ na̱chindahá Ndióxi̱ cacomí a̱ cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Joo mí xíni̱ va̱ha í ndá ñuu na̱quixi da̱ yóho ña̱ cán quéa̱ xíni̱ yo̱ ña̱ co̱ cúú toho da Cristo jáchi̱ tá ná quixi ndusa Cristo cán ni in na a̱ cánda̱a̱ ini ndá ñuu quixi da —na̱cachi na̱ cán cáha̱n na̱ sa̱há Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ta nani jána̱ha̱ Jesús ini veñu̱hu cáhnu cán já na̱casáhá cáha̱n cóhó a̱ já na̱cachi a já: —Mé a̱ nda̱a̱ xíni̱ va̱ha ndó ye̱he̱ ta xíni̱ ndó ndá ñuu na̱quixi i̱. Joo co̱ó va̱xi ye̱he̱ cuéntá mí i̱. Mé Ndióxi̱ na̱chindahá ye̱he̱ va̱xi i̱, mé a̱ cán cája ña̱ nda̱a̱. Joo mé ndó co̱ xíni̱ toho ndó a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ye̱he̱ xíni̱ va̱ha i̱ yo cúú mé á jáchi̱ na̱quixi i̱ nu̱ íin mé á ta na̱chindahá mé á ye̱he̱ va̱xi i̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","A̱nda̱ já ndúcú na̱ tiin na Jesús chica̱a̱n na̱ a̱ veca̱a joo ni in na co̱ó na̱sa̱ha̱n ndeé ini tiin ñahá jáchi̱ cáma̱ní yií ndindaa hora tiin na a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ta cua̱ha̱ táhan ña̱yivi na̱xini jo̱ho nu̱ú na̱ca̱ha̱n Jesús cán na̱candúsa na mé á ta já cáchí na̱ já: —Á a̱ ju̱ú da̱ yóho cúú Cristo jáchi̱ tá ná quixi inga da ama ná caja da ña̱ha xitúhún chága̱ a̱ ju̱ú ga̱ da̱ yóho —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tá na̱xini jo̱ho na̱ fariseo ña̱ cáha̱n núu ña̱yivi sa̱há Jesús já na̱ndindeé ini na ta na̱ndindeé ini ri na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán chí na̱chindahá na̱ java soldado cuéntá veñu̱hu cáhnu cán ña̱ ná tiin na Jesús chica̱a̱n na̱ a̱ veca̱a. ");
INSERT INTO mksNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","A̱nda̱ já na̱cachi tucu Jesús já: —Chá tiempo cuití va coo tóo i̱ xi̱hi̱n ndo̱ ñuyíví yóho jáchi̱ tá na̱ndihi já cu̱hu̱n tucu u̱ nu̱ íin mé á na̱chindahá ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A̱nda̱ jáví caca nuu ndó ndinducú ndó ye̱he̱ joo a̱ ndítahan ndó ye̱he̱ jáchi̱ a̱ cúu cu̱hu̱n ndó nu̱ú coo i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tá na̱xini jo̱ho na̱ Israel cán ña̱ na̱cachi Jesús já na̱casáhá ndáca̱ tu̱hún táhan na já cáchí na̱ já: —Ta ndáchí já cu̱hu̱n ri da̱ yóho ña̱ cáchí da̱ ña̱ a̱ cúu nditahan í da̱. Á cu̱hu̱n xícá da̱ ñuu na̱ tóho̱ nu̱ ndúu na̱ Israel ña̱ ná jána̱ha̱ da̱ nu̱ú na̱ griego. ");
INSERT INTO mksNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ndía̱ cúni̱ cachi da xi̱hi̱n yó tá na̱cachi da ña̱ ndinducú yó da̱ ta a̱ ndítahan toho í da̱. Jáchi̱ na̱cachi da xi̱hi̱n yó ña̱ a̱ cúu co̱ho̱ nu̱ú coo da —na̱cachi xi̱hi̱n táhan na̱ cán jáchi̱ co̱ó na̱canda̱a̱ ini na ña̱ na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ta mé qui̱ví nu̱ ndíhí víco̱ cán na̱sacuu a qui̱vi̱ cáhnu chága̱ nu̱ú na̱ Israel. Ta mé qui̱vi̱ cán na̱nda̱ca̱ ndichi Jesús já na̱cayuhú a̱ já na̱cachi a já: —Ndá ndó íchi̱ ini ticui̱í, naha ndó nu̱ú i̱ já ná caja i̱ ña̱ ná ndiva̱ha ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jáchi̱ já na̱ca̱hyi̱ a̱ nu̱ú tu̱hun Ndióxi̱: “Ndá na̱ ná cándeé ini ye̱he̱, ini mé ínima̱ ná cana tátu̱hun yu̱ta ticui̱í, dó caja ña̱ ná catacu na” —na̱cachi Jesús xi̱hín na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ña̱ cúni̱ Jesús cachi a xi̱hín na̱ yóho quéa̱ tá ná candeé ini na mé á já xi̱nu̱ qui̱ví ndiquehe na ínima̱ yi̱i̱ Ndióxi̱ ini ínima̱ ná. Va̱tí mé a̱ nda̱a̱ a̱ ñáha toho xi̱nu̱ ínima̱ yi̱i̱ Ndióxi̱ ini ña̱yivi jáchi̱ cáma̱ní yi̱í va ndindita Jesús ndicáhnu ndiva̱ha mé á indiví. ");
INSERT INTO mksNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Java na̱ ndúu tañu ña̱yivi cua̱ha̱ cán tá na̱xini jo̱ho na ña̱ yóho já na̱casáhá cáchí na̱ já: —Jivi ndusa da̱ yóho cúú profeta na̱cachi Ndióxi̱ chindahá a̱ ñuyíví yóho —cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ta java na cáchí na̱ sa̱há Jesús ña̱ cúú á Cristo, da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. Ta java na cáchí na̱ ña̱ a̱ ju̱ú toho a jáchi̱ cáhán na̱ ña̱ a̱ cúu toho quixi Cristo estado Galilea. ");
INSERT INTO mksNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Jáchi̱ cáchí tu̱hun Ndióxi̱ ña̱ tá ná quixi Cristo ñuyíví yóho cacuu da da̱ quixi chi̱chi David, da̱ na̱sacomí cuéntá sa̱há ña̱yivi Israel sa̱nahá. Ta cáchí tu̱hun Ndióxi̱ ña̱ cacu da̱ cán ñuu Belén nu̱ú na̱cacu mé David cán. ");
INSERT INTO mksNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ta chí na̱casáhá na̱ sáhndá java táhan na sa̱há ña̱ co̱ó na̱ndique táhan tu̱hun na sa̱ha̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ta java na cúni̱ na̱ tiin na a̱ ña̱ ná cañehe ñahá na̱ cu̱hu̱n a̱ veca̱a. Joo ni in na co̱ó na̱tiin ñahá. ");
INSERT INTO mksNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tá na̱ndihi já na̱ndicó co̱o soldado cuéntá veñu̱hu cán nu̱ ndúu na̱ fariseo xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán joo co̱ó Jesús ñéhe na ná casa̱a̱ na̱. Já na̱casáhá na̱ ndúu cán ndáca̱ tu̱hún ñahá na̱ já cáchí na̱ já: —Ndá cuéntá quéa̱ co̱ó na̱tiin ndó da̱ —na̱cachi na̱ cán xi̱hín soldado. ");
INSERT INTO mksNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","A̱nda̱ já na̱nducú ñehe soldado cán tu̱hun nu̱ ná já cáchí da̱ já xi̱hi̱n ná: —Na̱catóntó nde̱ na̱xini jo̱ho nde̱ nu̱ cáha̱n da̱ jáchi̱ ñúchí ndiva̱ha cáha̱n da̱ ta ni in túhún na̱ co̱ó na̱ca̱ha̱n tá quia̱hva cáha̱n mé dá —na̱cachi soldado cán. ");
INSERT INTO mksNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Já na̱cachi na̱ fariseo já xi̱hi̱n dá: —Á jári ndóhó va na̱jándahvi da ja̱n viti. ");
INSERT INTO mksNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Jáchi̱ ja̱nda̱ ni in túhún toho táhan na̱ sa̱cua̱ha̱ ndúu tañu mé nde̱ co̱ cándúsa nde̱ da̱ ja̱n. Ta ni in na̱ fariseo co̱ cándúsa na nu̱ cáha̱n Jesús ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Joo cháhan va va̱xi ja̱tá ña̱yivi cándeé ini Jesús ja̱n jáchi̱ co̱ xíni̱ na̱ ña̱ cáchí ley Moisés —na̱cachi na̱ fariseo xi̱hín soldado. ");
INSERT INTO mksNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","A̱nda̱ já na̱ndica̱ha̱n Nicodemo, da̱ cúú in táhan na̱ fariseo cán, mé dá na̱sa̱ha̱n da̱ na̱nditúhún xi̱hín Jesús in ñuú. Já na̱cachi da já xi̱hín na̱ java ga̱ cán: ");
INSERT INTO mksNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Cáchí ley ña̱ a̱ cu̱ú tiín in ta̱a ta já chica̱a̱n ndaja na̱cuú da̱ veca̱a. Ña̱ cáchí ley quéa̱ ndítahan cuni jo̱ho í nu̱ú ca̱ha̱n da̱ já ná canda̱a̱ iní ndaja cáa ña̱ na̱caja da —na̱cachi Nicodemo. ");
INSERT INTO mksNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","A̱nda̱ já na̱caja cue̱he̱ na̱ xi̱hín Nicodemo já na̱cachi na já xi̱hi̱n dá: —Á da̱ Galilea cúú ri yóhó va. Cuáhán cahvi va̱ha tu̱hun Ndióxi̱ já cunún ña̱ co̱ cána ni in profeta estado Galilea —na̱cachi na xi̱hín Nicodemo. ");
INSERT INTO mksNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tá na̱ndihi já na̱ndicui̱ta nuu ndihi na̱ cán cuánúhu̱ ná vehe na. ");
INSERT INTO mksNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ta ndaja coo na̱quee Jesús cua̱ha̱n chí yúcu̱ yitó olivo. ");
INSERT INTO mksNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ta tá na̱ti̱vi inga qui̱ví ita̱a̱n já na̱ndicó co̱o tucu a veñu̱hu cáhnu cán. Ta tá na̱cayati ña̱yivi nu̱ á já na̱saco̱o a ta na̱casáhá jána̱ha̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ta ndaja coo na̱ jána̱ha̱ ley Moisés xi̱hín na̱ fariseo ñéhe na in ñáñáha̱ na̱sa̱a̱ na̱ nu̱ á. Mé ñáñáha̱ cán na̱nditahan na ña̱ mé hora cándúhu̱ ñá xi̱hín in da̱ta̱a, da̱ co̱ cúú yíi̱ ña̱. Ta já ñéhe na ñá na̱sacu ndichi na ña̱ nu̱ú na̱ ndúu cán. ");
INSERT INTO mksNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Já na̱cachi na já xi̱hín Jesús: —Cande̱hé ndo̱ Maestro. Na̱nditahan nde̱ ñáñáha̱ yóho cándúhu̱ ñá xi̱hín in da̱ta̱a, da̱ co̱ cúú yíi̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ta nu̱ ley na̱jándacoo Moisés nu̱ú nde̱ táhnda̱ chuun ña̱ ná cuun nde̱ yu̱u̱ na̱ji̱hí cája já. Ta mé ndó ndía̱ cachi ndó —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Na̱cachi na̱ cán já xi̱hín Jesús jáchi̱ cúni̱ na̱ coto ndojó cuití ñahá na̱ ta cúni̱ na̱ ñe̱he̱ íní na̱ jácojo na cua̱chi ja̱tá Jesús. Tá na̱ndihi já na̱saco̱o Jesús já na̱casáhá cáhyí a̱ nu̱ ñúhu̱ cán xi̱hín nducu ndáha̱ á. ");
INSERT INTO mksNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ta sa̱há ña̱ ndúcú ndéé na̱ cán ndáca̱ tu̱hún ñahá na̱ na̱nda̱ca̱ ndichi Jesús já na̱cachi a já xi̱hi̱n ná: —Ndá ndó, na̱ co̱ó na̱caja cua̱chi jácana jihna ñúhú ndó yu̱ú ja̱ta̱ ña̱ —na̱cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Já na̱saco̱o tucu a cáhyí a̱ nu̱ ñúhu̱ cán xi̱hín nducu ndáha̱ á. ");
INSERT INTO mksNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ta tá na̱xini jo̱ho tócó ndihi na̱ cán ña̱ na̱cachi Jesús já na̱casáhá na̱ cácahan nu̱u̱ ná ta tá in tá in na na̱casáhá quée na cua̱ha̱n na̱. Ta jihna ñúhú ga̱ na̱ yatá na̱casáhá quée cua̱ha̱n já ndíco̱ na̱ yúta̱ chága̱ cua̱ha̱n na̱. Ta tá sa̱ na̱quee ndihi na cua̱ha̱n na̱ já na̱cando̱o mé Jesús xi̱hi̱n ñá cán. ");
INSERT INTO mksNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","A̱nda̱ já na̱nda̱ca̱ ndichi a ta na̱nda̱ca̱ tu̱hún a̱ ña̱ já na̱cachi a já xi̱hi̱n ñá: —Ndáchí cua̱ha̱n na̱ jácojo cua̱chi ja̱tu̱n. Á co̱ó ga̱ na̱ jácojo cua̱chi ja̱tu̱n viti —na̱cachi Jesús xi̱hi̱n ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A̱nda̱ já na̱cachi ñá cán já xi̱hín Jesús: —Mé a̱ nda̱a̱ co̱ó ga̱ na̱. A̱nda̱ já na̱cachi Jesús já: —Ta ni ye̱he̱ a̱ chíca̱a̱n i̱ cua̱chi ja̱tu̱n. Cuánúhu̱ vehún ta a̱ cája ga̱ún cua̱chi —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Já na̱casáhá tucu Jesús cáha̱n xi̱hín ña̱yivi já cáchí a̱ já xi̱hi̱n ná: —Ye̱he̱ cúú u̱ tátu̱hun ñúhu̱ ña̱ jándiyéhe̱ ínima̱ ña̱yivi ta ndá na̱ cándeé ini ye̱he̱ cúú á tátu̱hun a̱ cáca ga̱ na̱ nu̱ú naá. Jáchi̱ jándiyéhe̱ e̱ nu̱ ná ta cája i̱ ña̱ ná catacu na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A̱nda̱ já na̱cachi na̱ fariseo já: —Sa̱ha̱ mé vún cáhu̱n ta xi̱hín ña̱ ja̱n náhún ña̱ cúnu̱n ndíñehe jícún mún. Ta xi̱hín ña̱ ja̱n náha̱ ña̱ co̱ cáhu̱n ña̱ nda̱a̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Tócó ndihi ña̱ cáha̱n i̱ sa̱ha̱ mí i̱ cúú á ña̱ nda̱a̱ ta íin sa̱há va̱tí mí i̱ cáha̱n i̱ ña̱. Jáchi̱ xíni̱ va̱ha i̱ ndá na̱quixi i̱ ta xíni̱ va̱ha i̱ ndá cu̱hu̱n i̱. Joo ndóhó, co̱ xíni̱ toho ndó ndá na̱quixi i̱ ta co̱ xíni̱ toho ndó ndá cu̱hu̱n i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mé ndó cátóó ndó cánde̱hé ndaa ndó ña̱yivi tá quia̱hva cája ña̱yivi ñuyíví. Joo ye̱he̱ co̱ cája toho i̱ já. ");
INSERT INTO mksNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Joo tá ná caja vií i̱ sa̱há ña̱yivi, caja i̱ ña̱ tá quia̱hva ndítahan caja i̱ jáchi̱ cája i̱ ña̱ nda̱a̱. Ta a̱ ju̱ú in túhún ye̱he̱ caja vií sa̱ha̱ ná jáchi̱ Ndióxi̱, tátá i̱, mé a̱ na̱chindahá ye̱he̱, mé á cán quéa̱ caja vií sa̱ha̱ ná xi̱hi̱n mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nu̱ ley mé ndó cáchí a̱ ña̱ tá in nu̱ú cáha̱n i̱vi̱ ña̱yivi sa̱há ña̱ na̱ya̱ha já náha̱ ña̱ cúú á ña̱ nda̱a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ta viti cuni jo̱ho ndó jáchi̱ quia̱hva já yáha ri xi̱hín ye̱he̱ va. Jáchi̱ ye̱he̱ cúú in testigo ta cáha̱n i̱ sa̱ha̱ mí i̱. Ta inga testigo cúú Ndióxi̱, tátá i̱, mé a̱ na̱chindahá ye̱he̱ —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","A̱nda̱ já na̱nda̱ca̱ tu̱hún na̱ Jesús já cáchí na̱ já xi̱hi̱n á: —Ndájá íin tátún ja̱n —na̱cachi na. A̱nda̱ já na̱cachi Jesús já: —Tá ná cuni ndó yo cúú ye̱he̱ já cuu canda̱a̱ ri ini ndó yo cúú tátá i̱. Joo co̱ xíni̱ ndo̱ yo cúú ye̱he̱ ta cáchí ga̱ ví tátá i̱ co̱ xíni̱ ndó a̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tócó ndihi ña̱ yóho na̱cachi Jesús xi̱hi̱n ná nani jána̱ha̱ ini veñu̱hu cáhnu yati nu̱ú na̱sahi̱in sa̱to̱ ndée jiu̱hún jóco̱ na̱ cán. Joo ni in na̱ co̱ó na̱sa̱ha̱n ndeé ini tiin ñahá chica̱a̱n veca̱a jáchi̱ co̱ó na̱sa̱ha̱n Ndióxi̱ ña̱ma̱ni̱ sa̱há ña̱ cáma̱ní yi̱í ndindaa hora tiin na mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","A̱nda̱ já na̱casáhá tucu Jesús cáchí a̱ já xi̱hi̱n ná: —Va̱xi qui̱vi̱ quee ye̱he̱ cu̱hu̱n i̱. Ta caca nuu ndó ndinducú ndó ye̱he̱ joo a̱ ndíñehe ndó ye̱he̱ jáchi̱ cája tá cája ndó cua̱chi ja̱nda̱ quia̱hva xi̱nu̱ qui̱ví quivi ndó. Ta sa̱há ña̱ cán quéa̱ a̱ cúu cu̱hu̱n ndó nu̱ú cu̱hu̱n ye̱he̱ cán —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A̱nda̱ já na̱casáhá na̱ Israel cán ndítúhún xi̱hi̱n táhan na já cáchí na̱ já: —Á cahní da̱ yóho mé dá cúni̱ da̱ ña̱ cán quéa̱ cáchí da̱ xi̱hi̱n yo̱ ña̱ a̱ cúu toho caja í co̱hó nu̱ú cu̱hu̱n da̱ —cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Já na̱cachi tucu Jesús já: —Mé ndó cúú ndó ña̱yivi ndúu ñuyíví yóho joo ye̱he̱ cúú u̱ da̱ na̱quixi chí indiví. Mé ndó cúú ndó cuéntá ñuyíví yóho joo ye̱he̱ co̱ cúú toho i̱ cuéntá ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sa̱há ña̱ cán quéa̱ na̱cachi i̱ xi̱hi̱n ndó ña̱ caja ndó cua̱chi ja̱nda̱ quia̱hva xi̱nu̱ qui̱ví quivi ndó. Jáchi̱ tá co̱ cándúsa ndó ña̱ cúú ye̱he̱ da̱ cáchí i̱ cúú u̱, da̱ na̱chindahá Ndióxi̱, já quéa̱ quivi ndó sa̱há cua̱chi ndó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","A̱nda̱ já na̱nda̱ca̱ tu̱hún na̱ cán Jesús já na̱cachi na já xi̱hi̱n á: —Ta ndá da̱ cúú yóhó, dá já —na̱cachi na. Já na̱cachi Jesús já: —Ja̱nda̱ sa̱há va na̱ca̱ha̱n i̱ xi̱hi̱n ndó yo cúú ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ta ña̱ xíni̱ jo̱ho i̱ cáha̱n mé á na̱chindahá ye̱he̱, ña̱ cán cúú ña̱ cáha̱n i̱ xi̱hín ña̱yivi ñuyíví. Ta ndinuhu ña̱ nda̱a̱ quéa̱ cáha̱n mé á. Ta mé a̱ nda̱a̱ íin cua̱há ndiva̱ha ña̱ núu cája ndó ta cuu tavá i̱ sa̱há nu̱ ndó tá ná caja vií i̱ sa̱ha̱ ndo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Joo co̱ó na̱canda̱a̱ ini na ña̱ cáha̱n Jesús sa̱ha̱ Ndióxi̱, tátá a̱ tá na̱cachi a já xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sa̱há ña̱ cán quéa̱ na̱cachi tucu a já xi̱hi̱n ná: —Tá na̱ndihi ná cata caa ndó ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi ndi̱ca crúxu̱ já quéa̱ canda̱a̱ ndusa ini ndó ña̱ ye̱he̱ cúú u̱ da̱ cáchí i̱ cúú u̱. Ta ni in túhún ña̱ha co̱ cája i̱ cuéntá mí i̱. Ta ña̱ jána̱ha̱ i̱ nu̱ ndo̱ cúú ña̱ na̱jána̱ha̱ Ndióxi̱, tátá i̱ nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ta mé á na̱chindahá ye̱he̱ co̱ na̱jándacoo ndáha̱ toho a̱ ye̱he̱ jáchi̱ íin tuun Ndióxi̱, tátá i̱ xi̱hín i̱. Ta níí tiempo ña̱ cája i̱ cúú ña̱ cáji̱i̱ ini Ndióxi̱ xi̱hi̱n —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ta chí cua̱há ña̱yivi na̱candúsa na Jesús tá na̱xini jo̱ho na tócó ndihi ña̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","A̱nda̱ já na̱ca̱ha̱n Jesús xi̱hín java na̱ Israel, na̱ sa̱ na̱candúsa ñahá cán já na̱cachi a já xi̱hi̱n ná: —Tá ná caja ndó tá íin na̱ca̱ha̱n i̱ xi̱hi̱n ndo̱ já na̱ha̱ ndó ña̱ mé a̱ nda̱a̱ táhyí cúú ndó na̱ cuéntá mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ta já canda̱a̱ ini ndó ña̱ nda̱a̱ ta ña̱ cán caja ña̱ ná a̱ cácuu ga̱ ndó tátu̱hun in mozo, da̱ ndúu ndáha̱ rí quini —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","A̱nda̱ já na̱cachi na̱ cán já xi̱hi̱n á: —Na̱ na̱quixi chi̱chi Abraham cúú nde̱. Ta ja̱nda̱ ni in túhún tañu co̱ó na̱sa̱cuu nde̱ mozo. Joo yóhó cáchún xi̱hín nde̱ ña̱ a̱ cácuu ga̱ nde̱ mozo. Ndaja cáa ña̱ cáa ri a já —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Já na̱cachi Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Tócó ndihi na̱ sá caja cua̱chi cúú tá cúú na̱ tátu̱hun mozo nu̱ú cua̱chi jáchi̱ cómí a̱ cuéntá sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ta da̱ cúú mozo nu̱ú in xitoho, co̱ó sa̱ha̱ dá coo nahá da̱ xi̱hín xitoho da jáchi̱ va̱xi qui̱vi̱ ndítahan quee da cu̱hu̱n da̱. Joo da̱ cúú ja̱hyi mé da̱ cúú xitoho cán íin sa̱ha̱ dá coo nahá da̱ xi̱hi̱n tátá da̱ jáchi̱ cúú dá da̱ vehe tátá da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ta quia̱hva já íin xi̱hín ye̱he̱, da̱ cúú ja̱hyi Ndióxi̱. Cája i̱ ña̱ ná a̱ cácomí ga̱ cua̱chi cuéntá sa̱ha̱ ndo̱ ta já a̱ cácuu ga̱ ndó tátu̱hun mozo nu̱ú cua̱chi cája ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ta sa̱ cánda̱a̱ va̱ha ini i̱ ña̱ cúú ndó ña̱yivi na̱quixi chi̱chi Abraham. Joo mé ndó cúni̱ ndó cahní ndó ye̱he̱ jáchi̱ co̱ cúni̱ ndó ndiquehe va̱ha ndó tu̱hun cáha̱n i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Cáha̱n i̱ sa̱ha̱ tócó ndihi ña̱ na̱na̱ha̱ Ndióxi̱, tátá i̱ nu̱ú i̱. Joo ndóhó cája ndó ña̱ cáha̱n tátá ndo̱ xi̱hi̱n ndó —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A̱nda̱ já na̱cachi na̱ cán já xi̱hi̱n á: —Abraham cúú tátá nde̱ jáchi̱ chi̱chi da̱ cán na̱quixi nde̱ —na̱cachi na. Já na̱cachi Jesús já xi̱hi̱n ná: —Tá jivi ndusa cúú ndó na̱ na̱quixi chi̱chi Abraham já quéa̱ caja ndó tá quia̱hva na̱caja da̱ cán, nduu. ");
INSERT INTO mksNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Joo ndúcú ndó cahní ndó ye̱he̱ jáchi̱ cáha̱n i̱ ña̱ nda̱a̱ xi̱hi̱n ndo̱ tá cáchí i̱ ña̱ na̱jána̱ha̱ Ndióxi̱ nu̱ú i̱. Mé Abraham co̱ó na̱caja toho da já. ");
INSERT INTO mksNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Joo cája ndó ña̱ núu tá quia̱hva cája tátá ndo̱ —na̱cachi Jesús. Já na̱cachi na̱ cán já xi̱hi̱n á: —A̱ ju̱ú ja̱hyi ndáhví toho ña̱yivi cúú nde̱he̱. Ndióxi̱ cúú ndusa tátá nde̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Já na̱cachi Jesús já: —Tá Ndióxi̱ ndusa ná cacuu tátá ndo̱ ta qui̱hvi̱ ini va ndó ye̱he̱, nduu. Jáchi̱ Ndióxi̱ na̱chindahá ye̱he̱ va̱xi i̱ ta íin i̱ yóho viti. Co̱ó va̱xi toho i̱ cuéntá mí i̱. Ndióxi̱ quéa̱ na̱chindahá ye̱he̱ va̱xi i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Joo co̱ cánda̱a̱ ini ndó tócó ndihi ña̱ ndícani i̱ nu̱ ndo̱ ta cúú á sa̱há ña̱ co̱ cúni̱ ndó cuni jo̱ho ndó nu̱ cáha̱n i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tátá ndo̱ cúú tiñáhá sa̱cua̱ha̱ ta cája ndó ña̱ cúni̱ rí cán jáchi̱ ñúhu ndó ndáha̱ ri̱. Ta rí sáhní ndi̱i cúú rí cán ja̱nda̱ mé sa̱ha̱. Ta ni in túhún tañu co̱ó na̱tiin rí ña̱ nda̱a̱ já ca̱ha̱n rí ña̱. Jáchi̱ cáha̱n rí ña̱ tu̱hún cuití va ta cuéntá mé rí quíxi ndihi ña̱ tu̱hún. ");
INSERT INTO mksNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Cande̱hé ndo̱. Co̱ cúni̱ ndó candúsa ndó ye̱he̱ jáchi̱ cáha̱n i̱ ña̱ nda̱a̱ xi̱hi̱n ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni in túhún toho ndó a̱ cúu na̱ha̱ nu̱ú ña̱yivi ña̱ íin cua̱chi i̱. Ta tá cáha̱n i̱ ña̱ nda̱a̱ cuití va xi̱hi̱n ndó ndá cuéntá quéa̱ co̱ cándúsa ndó ye̱he̱, dá já. ");
INSERT INTO mksNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jáchi̱ ndá na̱ cúú ndusa cuéntá Ndióxi̱ táa jo̱ho na ña̱ cúú tu̱hun Ndióxi̱. Joo náha̱ cáxí a̱ ña̱ co̱ cúú ndó cuéntá Ndióxi̱ jáchi̱ co̱ cúni̱ ndó cuni jo̱ho ndó nu̱ cáha̱n mé á xi̱hi̱n ndo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A̱nda̱ já na̱cana̱há na̱ Israel xi̱hín Jesús já na̱cachi na já: —Mé a̱ nda̱a̱ cúún in da̱ Samaria ta ndáca̱a̱n rí quini inún —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Co̱ó toho rí quini ndáca̱a̱n ínima̱ ye̱he̱. Ña̱ cája i̱ quéa̱ cája cáhnu i̱ Ndióxi̱, tátá i̱. Joo quéhe núu ndiva̱ha ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Co̱ cúni̱ toho i̱ ña̱ ná caja cáhnu ndó ye̱he̱ va̱tí mé a̱ nda̱a̱ cúni̱ Ndióxi̱ ña̱ ná caja cáhnu ndó ye̱he̱. Ta mé a̱ cán quéa̱ caja vií sa̱ha̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndó. Ndá na̱ ná caja ña̱ cáha̱n i̱ yóho, na̱ cán catacu na a̱nda̱ ama cáa qui̱vi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Já na̱nducú ñehe na̱ cán tu̱hun nu̱ á já na̱cachi na já xi̱hi̱n á: —Viti ndusa cánda̱a̱ ini nde̱ ña̱ ndáca̱a̱n rí quini inún jáchi̱ cáchún ña̱ tá ná caja nde̱ ña̱ cáhu̱n já quéa̱ catacu nde̱ a̱nda̱ ama cáa qui̱vi̱. Joo xíni̱ va̱ha nde̱ ña̱ na̱xi̱hi̱ tá na̱xi̱hi̱ Abraham, tásáhnu jícó nde̱ ta jári na̱ profeta na̱sanduu sa̱nahá na̱xi̱hi̱ na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Á cáhnu chága̱ yóhó a̱ ju̱ú ga̱ Abraham, da̱ na̱sacuu tásáhnu jícó nde̱, dá já. Mé Abraham na̱xi̱hi̱ da̱ ta jári mé na̱ profeta na̱xi̱hi̱ ri na̱ cán va. Á cájún cuéntá ña̱ cúún da̱ cáhnu chága̱ a̱ ju̱ú ga̱ na̱ cán, dá já —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Já na̱cachi Jesús já xi̱hi̱n ná: —Tá ná caja cáhnu i̱ mí i̱, co̱ó sa̱ha̱ toho ña̱ cája i̱. Joo Ndióxi̱, tátá i̱ jándicáhnu a ye̱he̱. Ta jári mé ndó cáchí ndo̱ ña̱ jivi mé a̱ cán cúú Ndióxi̱ cája cáhnu ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Joo co̱ xíni̱ toho ndó yo cúú mé á. Ye̱he̱ xíni̱ yo cúú mé á. Tá ná cachi i̱ ña̱ co̱ xíni̱ toho i̱ mé á, cúú u̱ in da̱ tu̱hún tátu̱hun mé ndó. Joo mé a̱ nda̱a̱ xíni̱ va̱ha i̱ yo cúú Ndióxi̱ ta cája i̱ ña̱ cáchí mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ta mé Abraham, da̱ na̱sa̱cuu tásáhnu jícó ndo̱ na̱caji̱i̱ íní da̱ jáchi̱ na̱ñe̱he̱ dá tu̱hun ña̱ quixi ye̱he̱ ñuyíví yóho. Ta a̱ ju̱ú quia̱hva na̱caji̱i̱ ini da tá na̱xini da ña̱ yóho —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A̱nda̱ já cána̱há chága̱ na̱ Israel xi̱hi̱n á já na̱cachi na já xi̱hi̱n á: —Ni i̱vi̱ jícó u̱xu̱ cui̱a̱ co̱ ndáca̱a̱n yóhó viti. Ta ndaja cúú cáchún na̱xinún Abraham, da̱ cúú tásáhnu jícó nde̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Ja̱nda̱ tá cáma̱ní cacu Abraham sa̱ íin va ye̱he̱ jáchi̱ cúú u̱ Ndióxi̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","A̱nda̱ já na̱tiin na̱ Israel cán yu̱u̱ ña̱ janí na̱ ja̱tá. Joo na̱ndaco̱o je̱hé Jesús já na̱ya̱ha tañu na̱ cán ta na̱quee a veñu̱hu cáhnu cán cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","In tañu tá xíca Jesús cua̱ha̱n já na̱xini a in da̱ta̱a, da̱ na̱cacu cuáá. ");
INSERT INTO mksNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A̱nda̱ já na̱casáhá na̱ xíca tuun xi̱hín Jesús cán ndáca̱ tu̱hún na̱ mé á sa̱há da̱ cua̱á cán já cáchí na̱ já xi̱hi̱n á: —Maestro, ndá cuéntá quéa̱ na̱cacu cuáá da̱ yóho. Á na̱cacu cuáá da̱ sa̱há cua̱chi na̱caja tátá da̱ á náná da̱. Á na̱cacu cuáá da̱ sa̱há cua̱chi na̱caja mé dá —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Co̱ó na̱cacu cuáá toho da̱ yóho sa̱há cua̱chi mé dá ta ni sa̱há cua̱chi tátá da̱ á náná da̱. Na̱cacu cuáá da̱ já ná na̱ha̱ i̱ nu̱ú ña̱yivi ndá quia̱hva náhnu ña̱ha cúú cája Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Jáchi̱ ndítahan caja i̱ chuun, ña̱ na̱chindahá tátá i̱ caja i̱ nani xíca nuu i̱ ñuyíví yóho. Ta cúú á tátu̱hun ndiví táhyí cúú á viti joo va̱xi qui̱vi̱ a̱ cóo ga̱ i̱ caja i̱ ña̱ yóho ta já cacuu a tátu̱hun na̱cuaá ndiva̱ha. Ta mé tiempo já ni in na a̱ cúu caja chúun. ");
INSERT INTO mksNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nani íin tóo i̱ ñuyíví yóho cúú á tátu̱hun jándiyéhe̱ mí i̱ nu̱ú na̱ ndúu ñuyíví yóho —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tá na̱ndihi na̱cachi Jesús ña̱ yóho já na̱xihnu a tóji̱í a̱ nu̱ ñúhu̱. Ta xi̱hín tóji̱í a̱ cán na̱cava̱ha in mbohla loho nda̱hyi̱ ta na̱chindaa mé á ña̱ nduchú núú da̱ cua̱á cán. ");
INSERT INTO mksNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tá na̱ndihi já na̱cachi a já xi̱hi̱n dá: —Cuáhán chi̱co̱ho̱ naní Siloé ta cán cuchún nu̱ún —na̱cachi Jesús xi̱hi̱n dá. Mé tu̱hun Siloé yóho cúni̱ cachi a: Da̱ na̱chindahá na̱. A̱nda̱ já na̱quee mé da̱ cua̱á cán na̱sa̱ha̱n da̱ na̱chichí nu̱ú da̱ ta tá na̱ndicó co̱o da̱ cán sa̱ sánde̱hé va da na̱casa̱a̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ta ndaja coo java na̱ cúú ñani táhan da xi̱hín java na̱ na̱xini ña̱ sáti da̱ cán tá na̱xini na ña̱ sánde̱hé tucu da já na̱cachi na xi̱hi̱n táhan na já: —Á a̱ ju̱ú da̱ yóho cúú da̱ da̱ cua̱á sáco̱o sáti yuhú íchi̱ —cáchí xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ta já cáchí java na já: —Jivi da̱ ja̱n cúú dá. Ta java na cáchí na̱: —A̱ ju̱ú toho da̱ ja̱n cúú dá va̱tí quia̱hva já cáa da —na̱cachi na. Joo mé da̱ na̱sahi̱in cuáá cán cáha̱n da̱ xi̱hi̱n ná já cáchí da̱ já: —Jivi ye̱he̱ cúú da̱ na̱sa̱cuu da̱ cua̱á cán —cáchí da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","A̱nda̱ já na̱casáhá na̱ ndáca̱ tu̱hún na̱ da̱ já cáchí na̱ já xi̱hi̱n dá: —Ndaja na̱cajún na̱nu̱ná nu̱u̱n —cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Já na̱cachi da̱ cán já: —Da̱ naní Jesús cúú da̱ na̱cava̱ha in mbohla loho nda̱hyi̱. Ta na̱chindaa da ña̱ nu̱ú i̱ ta na̱cachi da xi̱hín i̱ ña̱ ná cu̱hu̱n i̱ cuchú nu̱ú i̱ chi̱co̱ho̱ naní Siloé. Ta já na̱sa̱ha̱n i̱ na̱chichí nu̱ú i̱ cán ta xi̱hín ña̱ yóho na̱nu̱ná nu̱ú i̱. Sánde̱hé e̱ viti —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Já na̱nda̱ca̱ tu̱hún tucu na̱ cán da̱ já cáchí na̱ já: —Ta ndájá cua̱ha̱n da̱ na̱ndaja va̱ha yo̱hó viti —na̱cachi na. —Co̱ xíni̱ toho i̱ —na̱cachi da xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tá na̱ndihi ndáca na da̱ na̱sa̱cuu da̱ cua̱á cán na̱sa̱ha̱n da̱ nu̱ú na̱ fariseo ");
INSERT INTO mksNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","jáchi̱ na̱sa̱cuu a qui̱vi̱ ndíquehe ndée̱ na̱ tá na̱ndaja va̱ha Jesús da̱ cua̱á cán xi̱hi̱n mbohla loho nda̱hyi̱ na̱chindaa a nu̱ú da̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Já na̱nda̱ca̱ tu̱hún na̱ fariseo cán da̱ ndá quia̱hva na̱nu̱ná nu̱u̱ dá sánde̱hé da̱ viti. Já na̱nducú ñehe da tu̱hun nu̱ ná já na̱cachi da já xi̱hi̱n ná: —Na̱chindaa da nda̱hyi̱ nu̱ú i̱ ta na̱chichí nu̱ú i̱ ta viti tívi nu̱ú i̱ sánde̱hé e̱ —na̱cachi da xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Joo java na̱ fariseo na̱cachi na xi̱hín da̱ na̱sa̱cuu da̱ cua̱á cán já: —Da̱ na̱ndaja va̱ha yo̱hó co̱ó va̱xi toho da cuéntá Ndióxi̱ jáchi̱ co̱ cája cáhnu da qui̱vi̱ ndíquehe ndée̱ yo̱ —na̱cachi na. Joo já cáchí java na̱ fariseo já: —Tá da̱ cája cua̱chi ná cacuu Jesús ja̱n ta a̱ cúu caja da ña̱ha xitúhún na̱há tátu̱hun ña̱ yóho, nduu —na̱cachi java na. Chí co̱ó na̱cuu ndique táhan va̱ha tu̱hun na̱ fariseo cán sa̱há ña̱ cán quéa̱ na̱sahnda táhan ndaja táhan mé va na. ");
INSERT INTO mksNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Já na̱casáhá ndáca̱ tu̱hún tucu na da̱ na̱sacuu da̱ cua̱á cán já cáchí na̱ já xi̱hi̱n dá: —Ta viti na̱nu̱ná nu̱u̱n na̱caja da̱ ja̱n. Yo já cúú dá cáchún —na̱cachi na. Já na̱nducú ñehe da tu̱hun nu̱ ná já na̱cachi da já xi̱hi̱n ná: —Ye̱he̱ cáchí i̱ ña̱ cúú dá in profeta —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Joo co̱ó na̱xeen na̱ Israel cán candúsa na ña̱ na̱sa̱cuu da̱ da̱ cua̱á ta ni co̱ cándúsa na ña̱ na̱nu̱ná nu̱u̱ dá. Sa̱há ña̱ cán quéa̱ na̱sa̱ha̱n na̱ na̱cana na tátá náná da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ta já na̱nda̱ca̱ tu̱hún na̱ tátá da̱ xi̱hi̱n náná da̱ já na̱cachi na já xi̱hi̱n ná: —Á ja̱hyi ndó cúú da̱ yóho. Á mé a̱ nda̱a̱ sa̱ já cuáá já cáa da̱ na̱cacu da. Ta ndá cuéntá quéa̱ sa̱ tívi nu̱u̱ dá viti —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A̱nda̱ já na̱nducú ñehe na̱ cán tu̱hun nu̱ú na̱ Israel cán já na̱cachi na já xi̱hi̱n ná: —Cánda̱a̱ cáxí ini nde̱ ña̱ ja̱hyi nde̱ cúú da̱ yóho. Ta xíni̱ va̱ha nde̱ ña̱ na̱cacu cuáá da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Joo co̱ xíni̱ nde̱ ndaja na̱cuu na̱nu̱ná nu̱u̱ dá sánde̱hé da̱ viti. Ta ni co̱ xíni̱ nde̱ yo cúú da̱ na̱suná nu̱u̱ dá. Ja̱n íin mé ja̱hyi nde̱. Nda̱ca̱ tu̱hún ndó mé dá. Sa̱ quia̱hva ca̱ha̱n mé da̱ ja̱n xi̱hi̱n ndo̱ cúú á jáchi̱ a̱ ju̱ú da̱ loho ga̱ cúú dá ja̱n —na̱cachi tátá da̱ na̱sa̱cuu da̱ cua̱á cán xi̱hín na̱ Israel cán. ");
INSERT INTO mksNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na̱cachi na ña̱ yóho jáchi̱ yíhví na̱ ña̱ ná a̱ quiáhva ga̱ na̱ Israel cán ña̱ma̱ni̱ nu̱ ná ndi̱hvi na veñu̱hu. Jáchi̱ mé na̱ Israel cán na̱jándique táhan na tu̱hun na ña̱ a̱ quiáhva ga̱ na̱ ña̱ma̱ni̱ nu̱ú ña̱yivi qui̱hvi na ini veñu̱hu tá ta̱ cáha̱n na̱ ña̱ cúú Jesús da̱ na̱chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sa̱há ña̱ cán quéa̱ na̱cachi tátá náná da̱ na̱sacuu da cua̱á cán xi̱hín na̱ Israel ña̱ ndítahan nda̱ca̱ tu̱hún na̱ mé dá jáchi̱ a̱ ju̱ú ga̱ da̱ loho cúú da̱ ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tá na̱ndihi já na̱cana tucu na̱ Israel da̱ na̱sa̱cuu da̱ cua̱á cán já na̱cachi na já xi̱hi̱n dá: —Xíní ñúhú caja cáhnún Ndióxi̱ ta a̱ cája cáhnún Jesús ja̱n jáchi̱ xíni̱ va̱ha nde̱ ña̱ cúú dá in da̱ cája cua̱chi —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A̱nda̱ já na̱cachi da̱ cán já xi̱hín na̱ Israel: —Co̱ xíni̱ toho i̱ á cúú dá da̱ cája cua̱chi á cúú dá da̱ co̱ cája cua̱chi. Ña̱ xíni̱ ndusa i̱ quéa̱ na̱sa̱cuu u̱ da̱ cua̱á ta jivi da̱ ja̱n na̱suná nu̱ú i̱ sánde̱hé e̱ viti —na̱cachi da xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","A̱nda̱ já na̱casáhá ndáca̱ tu̱hún tucu na da̱ já cáchí na̱ já xi̱hi̱n dá: —Ta ndaja na̱caja da na̱suná da̱ nduchú núún. Ndía̱ na̱caja da xu̱hu̱n —na̱cachi na xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A̱nda̱ já na̱cachi da̱ na̱sa̱cuu da̱ cua̱á cán já xi̱hi̱n ná: —Sa̱ na̱cachi vi̱ xi̱hi̱n ndo̱ ndá quia̱hva na̱caja da na̱suná da̱ nu̱ú i̱. Joo co̱ cúni̱ ndó candúsa ndó ye̱he̱. Ndá cuéntá quéa̱ ndáca̱ tu̱hún tucu ndó ye̱he̱. Á cu̱hu̱n ri ndóhó va caca nuu ndó xi̱hi̱n dá cúni̱ ndo̱, va̱ha —na̱cachi da xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Já na̱casáhá na̱ Israel cán cána̱há na̱ xi̱hi̱n dá ta já na̱cachi na já xi̱hi̱n dá: —Yóhó va cúú da̱ xíca nuu xi̱hín da̱ ja̱n. Joo nde̱he̱ jácuaha nde̱ ley Moisés cuití va. ");
INSERT INTO mksNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jáchi̱ cánda̱a̱ va̱ha ini nde̱ ña̱ na̱ca̱ha̱n Ndióxi̱ xi̱hín Moisés. Joo mé Jesús ja̱n co̱ cúú dá cuéntá Ndióxi̱ ta ni co̱ xíni̱ nde̱ ndájá na̱quixi da ja̱n —na̱cachi na xi̱hín da̱ na̱sa̱cuu da̱ cua̱á cán. ");
INSERT INTO mksNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A̱nda̱ já na̱cachi tucu da̱ cán já xi̱hi̱n ná: —Mé a̱ nda̱a̱ cátóntó vi̱ xi̱hín ña̱ yóho jáchi̱ jivi Jesús ja̱n na̱suná da̱ nu̱ú i̱ ta ndóhó ni co̱ cánda̱a̱ ini ndó ndá da̱ cúú dá ta ni co̱ xíni̱ ndo̱ ndájá na̱quixi da. ");
INSERT INTO mksNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sa̱ xíni̱ yo̱ ña̱ co̱ xíni̱ jo̱ho Ndióxi̱ ña̱ xíca̱ ta̱hví ña̱yivi cája cua̱chi nu̱ á. Joo xíni̱ jo̱ho mé á nu̱ cáha̱n ña̱yivi tá cája cáhnu na mé á ta tá cája na ña̱ cúni̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ta viti cande̱hé ndo̱. Ja̱nda̱ sa̱ha̱ ñuyíví a̱ ñáha cuni jo̱ho í ña̱ ndícuná in da̱ta̱a nduchú núú in da̱ na̱cacu cuáá. ");
INSERT INTO mksNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ta Jesús yóho a̱ cúu toho caja cuná a̱ nu̱ú i̱ tá ta̱ co̱ cúú á ña̱ na̱quixi cuéntá Ndióxi̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","A̱nda̱ já na̱nducú ñehe na̱ cán tu̱hun nu̱ dá já na̱cachi na já xi̱hi̱n dá: —A̱nda̱ tá na̱cacún na̱chutú nda̱ún xi̱hín cua̱chi. Ta viti chí cúni̱ ri yóhó jána̱hún nde̱he̱ —na̱cachi na̱ Israel cán xi̱hi̱n dá. A̱nda̱ já na̱taxí na̱ da̱ veñu̱hu cán. ");
INSERT INTO mksNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tá na̱ndihi já na̱canda̱a̱ ini Jesús ña̱ na̱taxí na̱ da̱ na̱sa̱cuu da̱ cua̱á cán veñu̱hu. Ta tá na̱nditahan tucu Jesús da̱ já na̱cachi a já xi̱hi̱n dá: —Á cándeé inún da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi —na̱cachi Jesús xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Já na̱cachi da já xi̱hi̱n á: —Cachi ndó xi̱hín i̱ yo já cúú dá ña̱ ná cuu candeé ini i̱ da̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Sa̱ na̱xini vún ye̱he̱ ta jivi ye̱he̱, da̱ cáha̱n xu̱hu̱n yóho cúú da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ta tá na̱cachi Jesús ña̱ yóho já na̱caxítí da̱ cán nu̱ á caja cáhnu da a̱ já na̱cachi da já xi̱hi̱n á: —Mé a̱ nda̱a̱ cándeé ini i̱ ndo̱hó, xitoho i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","A̱nda̱ já na̱cachi tucu Jesús já xi̱hi̱n dá: —Ye̱he̱ na̱quixi i̱ ñuyíví yóho já ná na̱ha̱ i̱ nu̱ú ña̱yivi ndá quia̱hva ndáa ña̱ cája na. Jáchi̱ ndá na̱ cándeé ini ye̱he̱ cúú ná tátu̱hun na̱ sa̱ na̱ndiye̱he̱ nu̱u̱. Joo ndá na̱ cáhán ña̱ cúú ná na̱ sa̱ na̱ndiye̱he̱ nu̱u̱ cúú ná tátu̱hun na̱ cua̱á —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ta java na̱ fariseo, na̱ ndíta xi̱hín Jesús cán tá na̱xini jo̱ho na ña̱ yóho já na̱nda̱ca̱ tu̱hún na̱ mé á já cáchí na̱ já: —Á co̱ cáhún ña̱ cúú ri nde̱he̱ va na̱ cua̱á —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Tá ná ndicuni ndó ña̱ cúú ndó tátu̱hun na̱ cua̱á ta co̱ó toho cua̱chi ndó, nduu. Joo tá cáchí ndó ña̱ tívi va̱ha ndiva̱ha nu̱u̱ ndo̱ ta co̱ xíní ñúhú ndó in na̱ jána̱ha̱ ndo̱hó sa̱há ña̱ cán quéa̱ íin tá íin cua̱chi ndó —na̱cachi Jesús xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","A̱nda̱ já na̱cachi Jesús já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Tá ná qui̱hvi in da̱ta̱a ini in corra nu̱ ñúhu ndicachi joo co̱ cúni̱ da̱ qui̱hvi da chí yéhé nu̱ quíhvi mé rí ta ña̱ cája da quéa̱ ndáva ndojó da̱ corra ri̱ já náha̱ xi̱cá a̱ ña̱ cúú dá da̱ cui̱hná. ");
INSERT INTO mksNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Joo mé da̱ quíhvi chí yéhé cúú dá da̱ ndáá ndicachi. ");
INSERT INTO mksNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ta mé da̱ ndáá yéhé corra nu̱ ñúhu ndicachi cán súná da̱ yéhé ña̱ ná ndi̱hvi da̱ ndáá ndicachi ta jácana da rí cán tá qui̱vi̱ in in rí. Ta mé ndicachi cán ndícuni rí ta̱chi̱ dá já quéta rí cua̱ha̱n rí caca nuu rí xi̱hi̱n dá. ");
INSERT INTO mksNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ta tá sa̱ na̱queta ndihi rí já ndáca da ri̱. Ta cánu̱ú da̱ nu̱ ri̱ cua̱ha̱n da̱ já va̱ha cua̱ha̱n rí xi̱hi̱n dá jáchi̱ ndícuni va̱ha rí ta̱chi̱ dá. ");
INSERT INTO mksNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Joo co̱ ndíco̱ rí ja̱tá ña̱yivi tóho̱ jáchi̱ co̱ ndícuni rí ta̱chi̱ ná jáchi̱ cúú ná na̱ tóho̱. Ña̱ cája rí quéa̱ xínu rí nu̱ ná —na̱cachi Jesús xi̱hín na̱ fariseo. ");
INSERT INTO mksNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ta ña̱ yóho na̱sa̱cuu in quia̱hva na̱sacu Jesús nu̱ú na̱ fariseo joo co̱ó na̱canda̱a̱ ini na ña̱ cúni̱ mé á cachi a xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","A̱nda̱ já na̱cachi tucu Jesús já xi̱hi̱n ná: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Ye̱he̱ cúú u̱ tátu̱hun in yéhé nu̱ yáha ndicachi já ndíhvi rí corra ri̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tócó ndihi na̱ na̱quixi tá cáma̱ní xi̱nu̱ i̱ ñuyíví yóho na̱jándahvi na ña̱yivi ta cúú ná tátu̱hun na̱ cui̱hná. Joo co̱ó na̱xeen na̱ cúú cuéntá mí i̱, na̱ cúú tátu̱hun ndicachi taa jo̱ho na̱ nu̱ cáha̱n na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ye̱he̱ cúú u̱ tátu̱hun in yéhé ta ndá na̱ ná quixi nu̱ú i̱ quia̱hva i̱ ña̱ma̱ni̱ nu̱ ná qui̱hvi na já ná ca̱cu ndaa ínima̱ ná. Cúú á tátu̱hun núná nu̱ú ndicachi qui̱hvi rí ini corra ri̱ ta núná nu̱ú rí queta tucu rí jáchi̱ íin yu̱cu̱ cuíi̱ nu̱ ri̱ xíxáhan rí. ");
INSERT INTO mksNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ʼJáchi̱ da̱ cúú da̱ cui̱hná cán cája cuíhná da̱ ri̱ ta sáhní da̱ ri̱ ta jándihi da sa̱ha̱ ri̱. Joo ye̱he̱ na̱quixi i̱ ñuyíví yóho já ná cuu catacu va̱ha ña̱yivi ta já ná cuu coo va̱ha na a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ye̱he̱ cúú u̱ tátu̱hun in da̱ ndáá va̱ha ndicachi. Jáchi̱ da̱ cán co̱ yíhví da̱ quivi da sa̱há ndicachi jana dá. ");
INSERT INTO mksNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Joo da̱ quéhe ya̱hvi sa̱há ña̱ ndáá da̱ ndicachi, ndáá da̱ ri̱ sa̱ha̱ ya̱hvi quéhe da̱ cán cuití va. Sa̱há ña̱ cán quéa̱ tá xíní da̱ va̱xi ndiva̱hyí quehe rí in ndicachi, ña̱ cája da quéa̱ xínu da cua̱ha̱n da̱ ta jándacoo da ndicachi ndáhví cán. Jáchi̱ co̱ cúú dá da̱ ndáá va̱ha rí ta ni ja̱na̱ dá co̱ cúú ndicachi cán. Ta co̱ sáhní da̱ mé dá tá ná xi̱nu̱ co̱o ndiva̱hyí ña̱ ná tiin rí ndicachi cán cata nuu ñahá ri̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Da̱ quéhe ya̱hvi cán jándacoo da ri̱ jáchi̱ co̱ cúú rí ja̱na̱ mé dá ta co̱ sáhní da̱ mé dá cúú ndicachi. ");
INSERT INTO mksNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ʼJoo ye̱he̱ cúú u̱ tátu̱hun in da̱ ndáá va̱ha ndicachi. Tá quia̱hva xíni̱ va̱ha da̱ cán ndá rí cúú ndicachi ja̱na̱ dá quia̱hva já xíni̱ va̱ha i̱ ndá na̱ cúú cuéntá mí i̱. Ta jári xíni̱ va̱ha mé ná ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tá quia̱hva xíni̱ va̱ha Ndióxi̱, tátá i̱ ye̱he̱ ta xíni̱ va̱ha i̱ mé á quia̱hva já xíni̱ va̱ha i̱ na̱ cúú cuéntá mí i̱. Ta sa̱há ña̱ yóho íin tia̱hva i̱ ndiquia̱hva i̱ mí i̱ quivi i̱ sa̱ha̱ ná jáchi̱ cúú ná tátu̱hun ndicachi ja̱ná i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Joo ndúu java ga̱ ña̱yivi inga ñuu ta cacuu na cuéntá mí i̱. Xíní ñúhú ndiquehe e̱ na̱ cán ña̱ ná cuni jo̱ho na nu̱ cáha̱n i̱. Ta in nduu ndihi na ña̱ ná candaa i̱ tócó ndihi na. ");
INSERT INTO mksNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ʼQuíhvi̱ ini Ndióxi̱, tátá i̱ ye̱he̱ jáchi̱ ndíquia̱hva i̱ mí i̱ quivi i̱ sa̱há na̱ cúú cuéntá mí i̱ ta tá na̱ndihi nditacu tucu u̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ta ni in na a̱ cúu cahní ye̱he̱ ndaja na̱cuu joo ndíquia̱hva i̱ mí i̱ quivi i̱ jáchi̱ cúni̱ caja i̱ ña̱. Núná nu̱ú i̱ ndiquia̱hva i̱ mí i̱ quivi i̱ ta núná nu̱ú i̱ nditacu tucu u̱. Ña̱ yóho cúú chuun na̱sahnda tátá i̱ nu̱ú i̱ caja i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tá na̱xini jo̱ho na̱ Israel cán ña̱ yóho já na̱casáhá na̱ sáhndá táhan tucu na. ");
INSERT INTO mksNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ta cua̱ha̱ táhan na̱ cán na̱casáhá cáchí na̱ já: —Ndá cuéntá quéa̱ táa jo̱ho ndó nu̱ cáha̱n da̱ ja̱n ta da̱ na̱cata̱chi̱ va cúú dá. Tiñáhá va ndáca̱a̱n ini da —cáchí xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Joo java na cáha̱n va̱ha na sa̱há Jesús já cáchí na̱ já: —Ni in toho ña̱yivi a̱ cúu ca̱ha̱n va̱ha na̱há tátu̱hun cáha̱n Jesús yóho tá ndáca̱a̱n tiñáhá ini ínima̱ ná. Jáchi̱ ama ná cuu caja ri tiñáhá jándiye̱he̱ rí nu̱ú na̱ cua̱á —cáchí java na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na̱xi̱nu̱ co̱o qui̱vi̱ cája na víco̱ nu̱ cuía̱ ñuu Jerusalén tá cája cáhnu na qui̱ví na̱xi̱nu̱ veñu̱hu cáhnu ñuu Jerusalén. Ta mé tiempo vi̱xi na̱sa̱cuu a cán. ");
INSERT INTO mksNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ta jivi ini mé veñu̱hu cáhnu cán na̱sahi̱in Jesús ta xíca nuu a yati yuyéhé naní Salomón. ");
INSERT INTO mksNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Já na̱ca̱va̱ ti̱yi̱vi̱ na̱ Israel cán mé á já na̱casáhá ndáca̱ tu̱hún na̱ mé á já na̱cachi na já xi̱hi̱n á: —Ndaja cáa chí qui̱ví ca̱xi tu̱hun nda̱u̱n xi̱hín nde̱ ña̱ á jivi ndusa cúún Cristo, da̱ chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. Jáchi̱ in i̱vi̱ joho cáhu̱n xíní nde̱ ta co̱ cánda̱a̱ va̱ha ini nde̱ á jivún á a̱ ju̱ú tohún —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já: —Sa̱ na̱ca̱ha̱n vi̱ xi̱hi̱n ndó joo co̱ó na̱candúsa ndó ye̱he̱. Tócó ndihi ña̱ náhnu cája i̱, cája i̱ ña̱ xi̱hi̱n ndée̱ sáhan tátá i̱ nu̱ú i̱ ta jivi mé ña̱ náhnu ja̱n náha̱ nu̱ ndó ña̱ cúú u̱ da̱ na̱chindahá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Joo ndóhó co̱ cándúsa ndó ye̱he̱ jáchi̱ co̱ cúú ndó tátu̱hun ndicachi ja̱ná i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Joo ña̱yivi, na̱ cúú tátu̱hun ndicachi ja̱ná i̱, na̱ cán cúú na̱ ndícuni nu̱ cáha̱n i̱ ta ndícuni i̱ na̱ ña̱ cúú ná cuéntá mí i̱ ta já ndíco̱ na̱ ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ta caja i̱ ña̱ ná catacu na a̱nda̱ ama cáa qui̱vi̱ já ná a̱ ndíhi sa̱ha̱ ná. Ta ni in túhún ña̱yivi a̱ cúu caja candaa na̱ cán ndahá i̱ tá sa̱ ñúhu na ndahá i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ndióxi̱, tátá i̱ na̱sa̱ha̱n na̱ cán nu̱ú i̱ ta mé á quéa̱ cáhnu chága̱ nu̱ tócó ndihi ña̱ha. Ta ni in na a̱ cúu caja candaa na̱ cán ndáha̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ye̱he̱ xi̱hi̱n Ndióxi̱, tátá i̱ in cúú va nde̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","A̱nda̱ já na̱tiin tucu na̱ Israel cán yu̱u̱ cuun na Jesús ña̱ cahní ñahá na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Cua̱há ndiva̱ha ña̱ náhnu na̱caja i̱ nu̱ ndó, ña̱ na̱sa̱ha̱n tátá i̱ ña̱ma̱ní nu̱ú i̱ caja i̱ nu̱ ndo̱ yóho ta viti cachi ndó xi̱hín i̱ ndá quéa̱ co̱ táhan ini ndó xi̱hi̱n. Ndá cuéntá quéa̱ va̱xi ndó cuun ndó yu̱ú ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","A̱nda̱ já na̱cachi na̱ cán já xi̱hi̱n á: —Co̱ ndúcú toho nde̱ cuun nde̱ yu̱u̱ yo̱hó sa̱há ña̱ náhnu cájún. Cuun nde̱ yu̱u̱ yo̱hó cúni̱ nde̱ jáchi̱ ndája núún Ndióxi̱. Jáchi̱ cúún in ta̱a tátu̱hun nde̱he̱ ta ndájún mún cúún Ndióxi̱ —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ná: —Nu̱ ley na̱jándacoo Moisés nu̱ ndo̱ cáchí a̱ ña̱ cúú ña̱yivi tátu̱hun Ndióxi̱ sa̱há ña̱ cúú ná ja̱hyi mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ta sa̱ cánda̱a̱ va̱ha iní ña̱ a̱ cu̱ú ta̱hnu̱ ña̱ cáha̱n tu̱hun Ndióxi̱. Ta na̱cachi Ndióxi̱ xi̱hín na̱ na̱ndiquehe tu̱hun mé á ña̱ cúú ná tátu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sa̱há ña̱ cán quéa̱ ndá cuéntá quéa̱ cáchí ndo̱ ña̱ na̱ndaja núu i̱ Ndióxi̱ sa̱há ña̱ cáchí i̱ cúú u̱ in túhún ji̱ni̱ já ja̱hyi Ndióxi̱. Jáchi̱ mé Ndióxi̱ na̱ca̱xi a ye̱he̱ ta na̱chindahá a̱ ye̱he̱ va̱xi i̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sa̱há ña̱ cán quéa̱ co̱ ndítahan candúsa ndó ye̱he̱ tá ta̱ co̱ cája i̱ ña̱ náhnu tátu̱hun ña̱ cája Ndióxi̱, tátá i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Joo tá cája i̱ ña̱ já quéa̱ xíní ñúhú candúsa ndó ña̱ náhnu xíní ndo̱ cája i̱ va̱tí co̱ cúni̱ ndó candúsa ndó ye̱he̱. Ta xi̱hín ña̱ yóho cuu candúsa ndó ña̱ in cúú Ndióxi̱, tátá i̱ xi̱hín i̱ ta in cúú ye̱he̱ xi̱hi̱n mé á —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","A̱nda̱ já ndúcú tucu na tiin na a̱ chica̱a̱n na̱ a̱ veca̱a joo na̱chije̱hé a̱ nu̱ ná cua̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ta já na̱quee tucu a cua̱ha̱n chí inga xoo yu̱ta Jordán nu̱ú na̱caja ndúta̱ Juan ña̱yivi nu̱ cuítí cán. Ta na̱cando̱o Jesús na̱sahi̱in a cán. ");
INSERT INTO mksNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ta cua̱há ña̱yivi na̱casáhá na̱ xínu̱ na̱ nu̱ á ta já cáchí xi̱hi̱n táhan na já: —Mé a̱ nda̱a̱ co̱ó toho ña̱ha xitúhún na̱caja Juan. Joo tócó ndihi ña̱ na̱cachi da̱ cán sa̱ha̱ Jesús yóho cúú á ña̱ nda̱a̱ —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ta cua̱ha̱ ná na̱candúsa na Jesús mé nu̱ú na̱sahi̱in a cán. ");
INSERT INTO mksNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ta ndaja coo na̱quehe cue̱he̱ in da̱ naní Lázaro, da̱ ñuu Betania. Ta jivi mé ñuu yóho cúú ri ñuu María xi̱hi̱n Marta, qui̱hvi̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mé María, ñá cúú quia̱hva Lázaro yóho cúú ñá ñá na̱xo̱jo̱ perfume ja̱tá sa̱há Jesús ta na̱jándihi̱chi̱ ñá do̱ xi̱hín ijí ji̱ni̱ ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ta mé ñá xi̱hín qui̱hvi̱ ña̱ na̱chindahá na̱ chuun cua̱ha̱n nu̱ú Jesús ña̱ cácáhví ndiva̱ha Lázaro, da̱ quíhvi̱ ini mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ta tá na̱ñe̱he̱ Jesús tu̱hun yóho já na̱cachi a já: —A̱ ju̱ú cue̱he̱ cahní ñahá cúú toho ña̱ yóho. Joo xi̱hín cue̱he̱ yóho cuu na̱ha̱ ndá quia̱hva cáhnu cúú Ndióxi̱. Ta xi̱hín ña̱ yóho na̱ha̱ nu̱ú ña̱yivi ndá quia̱hva cáhnu cúú ye̱he̱, da̱ cúú in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ta ndaja coo quíhvi̱ ndiva̱ha ini Jesús Marta xi̱hín qui̱hvi̱ ñá ta quia̱hva já quíhvi̱ ri ini a Lázaro viti. ");
INSERT INTO mksNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Joo tá na̱ñe̱he̱ Jesús tu̱hun ña̱ quíhvi̱ Lázaro já na̱cando̱o a i̱vi̱ qui̱vi̱ chága̱ mé nu̱ú na̱sahi̱in a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ta tá na̱ndihi já na̱cachi Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Xíhín ndo̱ ná co̱ho̱ tucú chí Judea —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A̱nda̱ já na̱cachi na̱ cán já xi̱hi̱n á: —Maestro, viti chá va ndúcú ña̱yivi ndúu cán cahní na̱ ndo̱hó xi̱hín yu̱u̱ ta cáa tucu ri ndó cu̱hu̱n ndo̱ cúni̱ ndo̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Joo sa̱ xíni̱ Jesús ña̱ cáma̱ní xi̱nu̱ qui̱vi̱ quivi a sa̱há ña̱ cán quéa̱ na̱cachi a já xi̱hi̱n ná: —Cande̱hé ndó. U̱xu̱ i̱vi̱ hora ndáca in qui̱vi̱ ta tá xíca nuu na ndiví a̱ cúu toho cachihin sa̱ha̱ ná jáchi̱ tívi xícá yéhe̱ nu̱ xíca na. ");
INSERT INTO mksNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Joo ndá na̱ xíca nuu ñuú cuu cachihin sa̱ha̱ ná jáchi̱ co̱ yéhe̱ nu̱ xíca na —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tá na̱ndihi já na̱cachi tucu a já xi̱hi̱n ná: —Sa̱ na̱qui̱ji̱ va amigo yo̱ Lázaro viti. Joo víla̱á cu̱hu̱n i̱ ndiñehe e̱ da̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A̱nda̱ já na̱cachi na̱ cán já xi̱hi̱n á: —Maestro, tá ta̱ na̱naá ini da na̱qui̱ji̱ dá já quéa̱ íin va̱ha da, dá já —na̱cachi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Joo ña̱ cúni̱ cachi Jesús quéa̱ sa̱ na̱xi̱hi̱ va Lázaro va̱tí na̱ xíca tuun xi̱hín a̱ cán na̱ca̱hán na̱ ña̱ cúni̱ mé á cachi a quéa̱ na̱qui̱ji̱ Lázaro cán tá quia̱hva quíji̱ tócó ndihi ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","A̱nda̱ já na̱ca̱ha̱n cáxí táhyí tucu Jesús xi̱hi̱n ná já na̱cachi a já: —Na̱xi̱hi̱ va Lázaro. ");
INSERT INTO mksNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Joo cáji̱i̱ va ini i̱ ña̱ co̱ó i̱ ná sahi̱in i̱ tá na̱xi̱hi̱ da̱ jáchi̱ ña̱ yóho chindeé a̱ ndo̱hó já ná candúsa chága̱ ndó ye̱he̱. Cóho̱ cande̱hé yo̱ Lázaro —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","A̱nda̱ já na̱casáhá Tomás, da̱ cáha̱n na̱ cuátí xi̱hi̱n cán cáha̱n da̱ xi̱hín java ga̱ na̱ xíca tuun xi̱hín Jesús já cáchí da̱ já: —Cóho̱ ri mí ví quiví xi̱hi̱n mé dá, dá já —cáchí da̱. Já na̱quee na cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tá na̱xi̱nu̱ co̱o Jesús yati ñuu Betania cán já na̱ñe̱he̱ á tu̱hun ña̱ sa̱ na̱xi̱hi̱ Lázaro ta sa̱ íin co̱mí qui̱vi̱ na̱chica̱a̱n va na da̱ ini in cáva̱. ");
INSERT INTO mksNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mé ñuu Betania cán ñéhe táhan yati a xi̱hín Jerusalén tátu̱hun u̱ni̱ kilometro ñéhe táhan. ");
INSERT INTO mksNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ta cua̱ha̱ táhan na̱ Israel cán na̱sa̱ha̱n na̱ ndúu tóo na xi̱hi̱n Marta xi̱hi̱n María tá quia̱hva jáya̱ha na ini na sa̱há ña̱ na̱xi̱hi̱ Lázaro quia̱hva na. ");
INSERT INTO mksNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ta tá na̱ñe̱he̱ Marta tu̱hun ña̱ cáyati Jesús ñuu cán cua̱ha̱n já ndáva ñá na̱sa̱ha̱n ñe̱he̱ ñahá ña̱. Joo na̱cando̱o María vehe. ");
INSERT INTO mksNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tá na̱ndique táhan Marta xi̱hín Jesús já na̱cachi ñá já xi̱hi̱n á: —Xitoho, tá ná coo ndó yóho ta ni a̱ quíví toho Lázaro quia̱hva i̱, nduu. ");
INSERT INTO mksNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Joo cánda̱a̱ va̱ha ini i̱ ña̱ tá ná ca̱ca̱ ndó ña̱ cúni̱ mé ndó nu̱ Ndióxi̱ quia̱hva va mé a̱ cán ña̱ nu̱ ndo̱ —na̱cachi Marta. ");
INSERT INTO mksNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ñá: —Cande̱hé Marta. A̱ ndícani inún jáchi̱ nditacu tucu va Lázaro, quia̱hvún ja̱n —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A̱nda̱ já na̱cachi ñá já xi̱hi̱n á: —Sa̱ xíni̱ vi̱ ña̱ nditacu tucu quia̱hva i̱ tá ná xi̱nu̱ co̱o qui̱vi̱ nu̱ ndíhí tá ná nditacu tócó ndihi na̱ sa̱ na̱xi̱hi̱ —na̱cachi Marta. ");
INSERT INTO mksNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Já na̱cachi Jesús já xi̱hi̱n ñá: —Ye̱he̱ cúú da̱ cuu caja ña̱ ná nditacu tucu ndi̱i ta cuu caja i̱ ña̱ ná catacu ña̱yivi a̱nda̱ ama cáa qui̱vi̱. Ta ndá na̱ cándeé ini ye̱he̱ va̱tí ná quivi na catacu tá catacu na. ");
INSERT INTO mksNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ta tócó ndihi na̱ cándeé ini ye̱he̱ catacu na a̱nda̱ ama cáa qui̱vi̱ ta a̱ ndíhi toho sa̱ha̱ ná ini indayá. Á cándúsún ña̱ cáha̱n i̱ xu̱hu̱n —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","A̱nda̱ já na̱cachi Marta já xi̱hi̱n á: —Cándúsa i̱ ndo̱hó ña̱ cúú ndó in túhún ji̱ni̱ já ja̱hyi Ndióxi̱ ta cándúsa i̱ ña̱ mé ndó cúú Cristo, da̱ na̱chindahá Ndióxi̱ quixi ñuyíví yóho —na̱cachi ñá xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tá na̱ndihi já na̱quee Marta na̱sa̱ha̱n ñá cana ñá María qui̱hvi̱ ña̱. Ta já na̱ca̱ha̱n ya̱á ña̱ xi̱hín María já na̱cachi ñá já xi̱hi̱n ña̱: —Sa̱ na̱xi̱nu̱ co̱o Jesús, xitoho í ta íin a yóho. Cuáhán nu̱ íin a jáchi̱ cána yo̱hó —na̱cachi Marta xi̱hín qui̱hvi̱ ñá. ");
INSERT INTO mksNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tá na̱xini jo̱ho María cán ña̱ na̱cachi qui̱hvi̱ ña̱ xi̱hi̱n ña̱ chí i̱vi̱ la̱á ndáva ñá na̱sa̱ha̱n ña̱ nu̱ íin Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mé Jesús na̱sandati a cán yuhú ñuu, mé nu̱ú na̱ndique táhan xi̱hi̱n Marta cán. ");
INSERT INTO mksNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ta ndaja coo mé na̱ Israel, na̱ ndúu jáya̱ha ini ñá cán tá na̱xini na na̱quee númi̱ joho ñá cua̱ha̱n ña̱ já na̱ndicui̱ta na ndíco̱ na̱ ja̱ta̱ ñá cua̱ha̱n na̱. Jáchi̱ na̱ca̱hán na̱ cua̱ha̱n ñá cuacu ñá nu̱ ndáca̱a̱n Lázaro, quia̱hva ñá. ");
INSERT INTO mksNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ta tá na̱xi̱nu̱ co̱o ñá nu̱ íin Jesús já na̱caxítí ña̱ nu̱ á já na̱casáhá cáchí ña̱ já xi̱hi̱n á: —Tá ná coo ndó yóho, nduu ta ni a̱ quíví toho Lázaro quia̱hva i̱ —na̱cachi ñá. ");
INSERT INTO mksNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ta tá na̱xini Jesús ña̱ sácu cóhó María xi̱hín na̱ Israel, na̱ ndíco̱ na̱sa̱a̱ xi̱hi̱n ñá cán já na̱ta̱hvi̱ ndiva̱ha ini a ja̱nda̱ quia̱hva na̱ndisa̱a̱ ini a. ");
INSERT INTO mksNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A̱nda̱ já na̱nda̱ca̱ tu̱hún a̱ María cán já na̱cachi a já xi̱hi̱n ña̱: —Ndájá na̱chica̱a̱n ndó da̱ já —na̱cachi Jesús. —Na̱ha̱ quíi̱ ndó, xitoho i̱. Cande̱hé ndo̱ nu̱ú na̱chica̱a̱n nde̱ da̱ —na̱cachi María. ");
INSERT INTO mksNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A̱nda̱ já na̱sacu Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tá na̱xini na̱ Israel ña̱ yóho já na̱casáhá cáchí xi̱hi̱n táhan na já: —Cande̱hé ndo̱ ndaja náha̱ na̱qui̱hvi̱ ini Jesús yóho Lázaro —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ta java na na̱casáhá cáchí na̱ já: —Mé Jesús yóho na̱suná da̱ nduchú núú na̱ cua̱á. Á chí a̱ cu̱ú cuití caja da chindeé da̱ Lázaro já ná a̱ quíví da̱, nduu —na̱cachi java na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tá na̱ndihi já na̱casáhá táhvi̱ ndiva̱ha tucu ini Jesús ta já na̱cayati a nu̱ú na̱chica̱a̱n na̱ yiquí cu̱ñu Lázaro. Mé nu̱ú ndáca̱a̱n da̱ cán na̱sa̱cuu a in ndi̱ca cáva̱ ta in yu̱u̱ jáhndá cáhnu na̱saji nuu yéhé cán. ");
INSERT INTO mksNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","A̱nda̱ já na̱ndica̱ha̱n Jesús xi̱hín java na̱ ndúu cán ña̱ ná jácaxoo na yu̱u̱ ndájí nuu nu̱ ndáca̱a̱n Lázaro cán. Joo ndaja coo Marta, ña̱ cúú quia̱hva mé ndi̱i cán na̱casáhá ña̱ cáchí ña̱ já xi̱hín Jesús: —Cande̱hé ndo̱, xitoho i̱. Sa̱ quini cúú sáhan ndi̱i quia̱hva i̱ ja̱n jáchi̱ sa̱ íin co̱mí qui̱ví na̱xi̱hi̱ da̱ —na̱cachi ñá. ");
INSERT INTO mksNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n ñá: —Xíní ñúhú ndicu̱hu̱n inún tá na̱cachi i̱ xu̱hu̱n ña̱ tá ná candúsún Ndióxi̱ já cunún ndá quia̱hva cáhnu ña̱ha cuu caja mé á —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tá na̱ndihi já na̱jácaxoo na yu̱u̱ cáhnu ña̱ na̱saji nuu nu̱ú na̱sa̱ndaca̱a̱n Lázaro. Já na̱ndiñehe Jesús nu̱u̱ á chí indiví já na̱cachi a já: —Tátá Ndióxi̱, ndíquia̱hva i̱ ndixa̱hvi nu̱ ndo̱ jáchi̱ na̱xini jo̱ho ndó nu̱ú na̱ca̱ha̱n i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Va̱tí mé a̱ nda̱a̱ cánda̱a̱ va̱ha ini i̱ ña̱ níí tiempo xíni̱ jo̱ho ndó nu̱ cáha̱n i̱ xi̱hi̱n ndo̱. Joo cáha̱n i̱ ña̱ yóho sa̱há ña̱ ná cuni jo̱ho ña̱yivi ndúu xi̱hín i̱ yóho já ná candúsa na ña̱ mé ndó na̱chindahá ndó ye̱he̱ va̱xi i̱ ñuyíví yóho —na̱cachi Jesús ndíquia̱hva ndixa̱hvi nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tá na̱ndihi já na̱cayuhú cóhó a̱ já na̱cachi a já: —Lázaro, cuáhán queta. ");
INSERT INTO mksNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tá na̱ndihi já na̱queta Lázaro nu̱ú na̱sa̱ndaca̱a̱n da. Na̱ca̱va nuu ndáha̱ dá a̱nda̱ sa̱ha̱ dá xi̱hín ti̱co̱to̱ ta ndáji jáhma̱ nu̱u̱ dá na̱queta da va̱xi da. A̱nda̱ já na̱cachi Jesús xi̱hín java na̱ ndúu cán ña̱ ná ndaxí na̱ da̱ já ná quee da cu̱hu̱n da̱. Ta já na̱caja na. ");
INSERT INTO mksNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ta cua̱ha̱ táhan na̱ Israel, na̱ ndáca táhan na̱sa̱ha̱n xi̱hín María cán tá na̱xini na ña̱ na̱jánditacu tucu Jesús Lázaro cán já na̱candúsa na mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Joo java táhan na̱ Israel cán ndáva na na̱sa̱ha̱n na̱ cáha̱n na̱ xi̱hín na̱ fariseo ta na̱ndicani na nu̱ ná ña̱ na̱caja Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","A̱nda̱ já na̱casáhá na̱ fariseo xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán na̱játaca na tócó ndihi na̱ sa̱cua̱ha̱ nu̱ú na̱ Israel já na̱cachi na já xi̱hi̱n ná: —Ndía̱ caja í xi̱hín Jesús viti jáchi̱ cua̱há ndiva̱ha ña̱ha xitúhún cája da̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Xíní ñúhú caji nuu í nu̱ dá jáchi̱ tá ná a̱ cájí nu̱u̱ í nu̱ dá va̱xi qui̱vi̱ tá tócó ndihi ña̱yivi candeé ini na mé dá. Ta xi̱hín ña̱ yóho xi̱nu̱ ini na̱ jutixia ñuu Roma quixi na jándicani na veñu̱hu í ta jándihi na sa̱ha̱ tócó ndihi mí, na̱ Israel —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Joo in táhan da̱ ndúu cán naní da̱ Caifás, da̱ na̱sa̱cuu da̱ sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ mé cui̱a̱ cán, na̱ndica̱ha̱n da̱ já na̱cachi da já: —Mé ndó cúú ndó ña̱yivi co̱ xíní túni̱. ");
INSERT INTO mksNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jáchi̱ co̱ cánda̱a̱ ini ndó ña̱ va̱ha chága̱ ña̱ ná quivi in ta̱a nu̱ ndíhi ña̱yivi já ná a̱ ndíhi sa̱ha̱ tócó ndihi ña̱yivi. Ña̱ cán quéa̱ cáhán i̱ ña̱ va̱ha chága̱ ná quivi Jesús ja̱n já ná a̱ ndíhi sa̱ha̱ mí —na̱cachi Caifás. ");
INSERT INTO mksNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Joo co̱ó na̱ca̱ha̱n Caifás ña̱ yóho sa̱há ña̱ na̱quixi a ji̱ni̱ mé dá. Ndióxi̱ quéa̱ na̱jáca̱ha̱n ínima̱ dá ña̱ cáchí da̱ já jáchi̱ mé tiempo já na̱sa̱cuu da sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ ta na̱jáca̱ha̱n Ndióxi̱ ínima̱ dá ña̱ ná cachi da ña̱ ndítahan quivi Jesús sa̱há na̱ Israel. ");
INSERT INTO mksNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ta a̱ ju̱ú sa̱há in túhún na̱ Israel cuití va va̱ha jáchi̱ mé Jesús na̱nditahan quivi a sa̱ha̱ tócó ndihi na̱ cúú cuéntá Ndióxi̱, na̱ ndícui̱ta nuu ndúu ndijáá ñuyíví já ná cuu coo in ñuu. ");
INSERT INTO mksNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chí ja̱nda̱ mé qui̱vi̱ já na̱sacu ini na̱ Israel cán cahní na̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sa̱há ña̱ cán quéa̱ co̱ó na̱xi̱ca nuu tívi ga̱ Jesús tañu na̱ Israel cán. Ña̱ na̱caja mé á quéa̱ na̱quee a estado Judea cán já na̱sa̱ha̱n chí in ñuu naní Efraín, ña̱ íin yati xoo yucú íchí nu̱ú co̱ó ña̱yivi. Cán na̱sahi̱in a xi̱hín na̱ xíca tuun xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tá na̱cayati qui̱ví coo vicó pascua cája na̱ Israel já na̱quee cua̱há ña̱yivi ndúu ndijáá ñuu cán cua̱ha̱n na̱ chí Jerusalén jáchi̱ cúni̱ na̱ ndaja vií na̱ mé ná, ná coo tia̱hva na tá quia̱hva na̱sahnda ley Moisés nu̱ ná caja na tá cáma̱ni̱ chá qui̱ví coo vicó pascua. ");
INSERT INTO mksNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tá na̱taca ña̱yivi ñuu Jerusalén cán na̱casáhá ndúcú na̱ Jesús. Joo nani ñúhu na veñu̱hu cáhnu cán ndáca̱ tu̱hún táhan na sa̱há Jesús já cáchí xi̱hi̱n táhan na já: —Ndaja xíní ndo̱ á quixi Jesús á a̱ quíxi toho a vicó pascua yóho —na̱cachi xi̱hi̱n táhan na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ta na̱ fariseo xi̱hín na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ na̱sahnda na chuun ña̱ ndá na̱ ná cuni Jesús já ná cu̱hu̱n na̱ ca̱xi tu̱hun na xi̱hín na̱ cán ndájá íin a jáchi̱ cúni̱ na̱ tiin na a̱ chica̱a̱n na̱ a̱ veca̱a. ");
INSERT INTO mksNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ta tá cama̱ni̱ i̱ñu̱ qui̱ví coo vicó pascua já na̱quee Jesús na̱sa̱ha̱n ñuu Betania, mé ñuu nu̱ íin Lázaro, da̱ na̱jánditacu tucu mé á cán. ");
INSERT INTO mksNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ta cán na̱caja ndíví na̱ ña̱ cajíni Jesús jáchi̱ cúni̱ na̱ caja cáhnu na mé á. Ta mé Marta cúú ñá cája ndíví nu̱ ná. Ta Lázaro cúú in táhan da̱ íin coo nu̱ mesa xíxi xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ta ndaja coo María na̱sa̱ha̱n ñá quehe ñá tátu̱hun java litro perfume, dó ya̱hvi ndiva̱ha. Jáchi̱ cúú dó dó na̱cava̱ha xi̱hín ndinuhu yu̱cu̱ támi sáha̱n naní nardo. Na̱jácu̱yu ñá do̱ ja̱ta̱ sáha̱ Jesús. Ta tá na̱ndihi já na̱jáhi̱chi̱ ñá sa̱há xi̱hín ijí ji̱ni̱ ña̱. Ta níí ini vehe cán na̱ndicui̱ta nuu jíco̱ perfume cán. ");
INSERT INTO mksNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","A̱nda̱ já na̱xini in táhan da̱ xíca tuun xi̱hín Jesús, da̱ naní Judas Iscariote cán ña̱ yóho. Mé Judas yóho cúú dá da̱ ji̱có túhún Jesús tá nu̱ ndíhí ta já cáchí da̱ já: ");
INSERT INTO mksNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Ndá cuéntá quéa̱ co̱ó na̱caya̱hvi perfume yóho já ná cana jiu̱hún jasá yó nu̱ú na̱ nda̱hví, nduu. Jáchi̱ quia̱hva na u̱ni̱ ciento denario sa̱ha̱ dó, nduu —na̱cachi Judas cán. Ta in denario cúú ña̱ quéhe ña̱yivi cája chúun na in qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Joo co̱ó na̱cachi Judas ña̱ yóho sa̱há ña̱ quíhvi̱ ini ndusa da na̱ nda̱hví, va̱ha. Na̱cachi da já jáchi̱ cúú dá da̱ cui̱hná ta ndáha̱ mé dá ñúhu ndihi jiu̱hún ta cája cuíhná da̱ ña̱ tá cúni̱ da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —A̱ cáhu̱n xi̱hi̱n ñá jáchi̱ na̱sacu va̱ha ñá do̱ ña̱ ná chojó ñá do̱ yiquí cu̱ñu i̱. Jáchi̱ sa̱ xíni̱ ñá ña̱ sa̱ na̱cayati qui̱ví quivi i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ta níí tiempo canduu na̱ nda̱hví ja̱n tañu ndó ta ndá tañu cúni̱ mé ndó cuu chindeé ndó na̱. Joo ye̱he̱ a̱ cóo tuun toho i̱ xi̱hi̱n ndo̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Cua̱há na̱ Israel cán na̱ñe̱he̱ ná tu̱hun ña̱ íin Jesús ñuu Betania. Sa̱há ña̱ cán quéa̱ na̱sa̱ha̱n na̱ cán jáchi̱ cúni̱ na̱ cuni na Jesús ta cúni̱ na̱ cuni na Lázaro, mé da̱ na̱jánditacu tucu Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","A̱nda̱ já na̱sacu ini na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ cán cahní ri na̱ Lázaro viti. ");
INSERT INTO mksNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Jáchi̱ sa̱ha̱ Lázaro cán cua̱há na̱ Israel na̱casáhá na̱ cándeé ini na Jesús. Ta na̱jándacoo na ndíco̱ na̱ ja̱tá na̱ sa̱cua̱ha̱ nu̱ú na̱ Israel. ");
INSERT INTO mksNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ta inga qui̱ví ita̱a̱n cua̱há ndiva̱ha ña̱yivi na̱xi̱nu̱ co̱o na ñuu Jerusalén nu̱ú coo vicó pascua. Ta tá na̱canda̱a̱ ini na ña̱ xínu̱ co̱o Jesús ñuu Jerusalén cán ");
INSERT INTO mksNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","já na̱sa̱ha̱n na̱ na̱sahnda na ndáha̱ tó ñu̱u̱ já ndáva na na̱sa̱ha̱n na̱ na̱ñe̱he̱ ñahá na̱. Ta cáyuhú na̱ já cáchí na̱ já: —Cája cáhnu í Ndióxi̱. Cáhnu na̱há ná cacuu da̱ cómí cuéntá sa̱há na̱ Israel jáchi̱ cúú dá da̱ va̱xi yuhú nu̱u̱ Ndióxi̱ —cáchí na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na̱nditahan Jesús in búrro̱ ta na̱sanúu a ri̱ tá quia̱hva na̱cachi tu̱hun Ndióxi̱ sa̱nahá tá cáchí a̱ já: ");
INSERT INTO mksNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","A̱ cáyi̱hví toho ndó, na̱ ndúu ñuu Sión. Cande̱hé ndó da̱ cómí cuéntá sa̱ha̱ ndó ja̱n, cánúu da ja̱ta̱ búrro̱ loho va̱xi da, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ta co̱ó na̱canda̱a̱ ini na̱ xíca tuun xi̱hín Jesús cán ndá cuéntá quéa̱ cája ña̱yivi já xi̱hi̱n á. Joo chága̱ chí nu̱u̱ tá sa̱ na̱ndindita Jesús cua̱ha̱n indiví já na̱canda̱a̱ ini na ña̱ quia̱hva já ndáa̱ nu̱ú tu̱hun Ndióxi̱ sa̱nahá ña̱ caja na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mé ña̱yivi, na̱ na̱sa̱nduu xi̱hín Jesús tá na̱ca̱ha̱n xi̱hi̱n Lázaro ña̱ ná queta da nu̱ú na̱ndu̱xu̱ da̱ ña̱ nditacu da, mé na̱ cán na̱ndicani na nu̱ú java ga̱ ña̱yivi ña̱ na̱xini na na̱caja Jesús cán. ");
INSERT INTO mksNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sa̱há ña̱ cán quéa̱ na̱queta ña̱yivi na̱sa̱ha̱n na̱ ñe̱he̱ ná Jesús jáchi̱ na̱ñe̱he̱ ná tu̱hun sa̱há ña̱ cáhnu na̱caja mé a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tá na̱xini na̱ fariseo ña̱ yóho já na̱casáhá cáchí xi̱hi̱n táhan na já: —Cande̱hé ndo̱. Ndá cuu caja í quee va̱ha í xi̱hín da̱ ja̱n. Jáchi̱ tócó ndihi ña̱yivi cáti na cua̱ha̱n na̱ xi̱hín da̱ ja̱n —na̱cachi xi̱hi̱n táhan na̱ fariseo cán. ");
INSERT INTO mksNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tañu ña̱yivi cua̱ha̱ na̱xi̱nu̱ co̱o cája cáhnu Ndióxi̱ víco̱ ñuu Jerusalén cán na̱xi̱nu̱ co̱o ri java na̱ na̱quixi chí ñundáhyi̱ cuéntá Grecia. ");
INSERT INTO mksNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ta mé na̱ griego yóho na̱cayati na nu̱ Felipe, da̱ ñuu Betsaida cuéntá Galilea cán. Ta já na̱casáhá na̱ cáha̱n nda̱hví na̱ xi̱hi̱n dá já na̱cachi na já xi̱hi̱n dá: —Ca̱ha̱n nde̱ xi̱hín Jesús cúni̱ nde̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","A̱nda̱ já na̱quee Felipe na̱sa̱ha̱n da̱ ca̱xi tu̱hun da̱ xi̱hín Andrés ta já ndáca táhan ndíví da̱ na̱sa̱ha̱n da̱ ndícani da ña̱ nu̱ú Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Sa̱ na̱xi̱nu̱ co̱o va tiempo caja cáhnu Ndióxi̱ ye̱he̱, da̱ na̱chindahá mé á nduu ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Tá quia̱hva ndihi sa̱ha̱ in ndiquí trigo tá ndícava ña̱ ini ñundáhyi̱ quia̱hva já ndítahan nu̱ú i̱ quivi i̱. Jáchi̱ tá ná a̱ ndíhi sa̱ha̱ ndiquí trigo cán já in já cacuu va ña̱. Joo tá ná ndihi sa̱há ña̱ cán já ndu̱ta̱ ña̱ ta já ndicua̱há ndiva̱ha ña̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ndá na̱ cátóó chága̱ cája ña̱ cúni̱ mé cuití na̱ a̱ ju̱ú ga̱ ña̱ cúni̱ Ndióxi̱, na̱ cán cúú na̱ ndihi sa̱ha̱. Joo na̱ cája ña̱ cúni̱ Ndióxi̱, na̱ cán cúú na̱ catacu a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ta ndá na̱ cúni̱ caja chúun cuéntá mí i̱ ndítahan nu̱ ná candi̱co̱ na̱ ye̱he̱. Jáchi̱ nu̱ú coo ye̱he̱, cán coo ri na̱ cája ña̱ cúni̱ ye̱he̱. Ta na̱ cán cacuu na na̱ ndiñehe jícó Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ʼTa viti ñúhú cácuéha̱ ndiva̱ha ini i̱. Ta a̱ cu̱ú caca ta̱hví i̱ nu̱ Ndióxi̱ ña̱ ná a̱ quiáhva mé á ña̱ma̱ni̱ ndoho ini i̱ jáchi̱ sa̱há chuun yóho na̱quixi i̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ña̱ ndítahan cachi i̱ quéa̱: “Tátá Ndióxi̱, cáhnu ná cacuu mé ndó” —na̱cachi Jesús. Tá na̱cachi Jesús ña̱ yóho, na̱ca̱ha̱n Ndióxi̱ indiví já na̱cachi a já: —Sa̱ na̱ndaja cáhnu i̱ mí i̱ ta caja tucu u̱ ña̱ —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ta ña̱yivi ndúu cán tá na̱xini jo̱ho na ña̱ yóho já na̱cachi na ña̱ ja̱vi̱ va cána. Ta java na na̱cachi na táto̱ Ndióxi̱ quéa̱ na̱ca̱ha̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","A̱nda̱ já na̱ndica̱ha̱n Jesús xi̱hi̱n ná já na̱cachi a já: —A̱ ju̱ú sa̱há ye̱he̱ na̱xini jo̱ho ndó ña̱ yóho. Joo na̱catácu̱ a̱ já ná cuni jo̱ho mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ta sa̱ na̱tandaa qui̱ví cavií sa̱há ña̱yivi ndúu ñuyíví ta sa̱ na̱tandaa qui̱vi̱ ndihi sa̱há ña̱ cája tiñáhá sa̱cua̱ha̱, mé rí sáhndá chuun ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jáchi̱ tá ná cata caa na ye̱he̱ já caja i̱ ña̱ ná casáhá ña̱yivi níí cúú ñuyíví candeé ini na ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Xi̱hín ña̱ yóho cúni̱ mé á ndicani a nu̱ ná ña̱ quivi a ndi̱ca crúxu̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A̱nda̱ já na̱cachi ña̱yivi ndúu cán já xi̱hi̱n á: —Tá cáhvi nde̱ ley Moisés na̱ca̱hyi̱ sa̱nahá já cánda̱a̱ ini nde̱ ña̱ a̱nda̱ ama cáa qui̱vi̱ catacu da chindahá Ndióxi̱ cacomí cuéntá sa̱há ña̱yivi. Yo já cúú da̱ cáhu̱n sa̱ha̱. Tá ta̱ mé a̱ nda̱a̱ cúún da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi, da̱ catacu a̱nda̱ ama cáa qui̱vi̱ ndá cuéntá quéa̱ cáchún quivún —na̱cachi na xi̱hín Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Já na̱cachi Jesús já xi̱hi̱n ná: —Ye̱he̱ cúú da̱ jándiye̱he̱ ínima̱ ña̱yivi ta coo tóo loho chága̱ i̱ xi̱hi̱n ndo̱. Sa̱há ña̱ cán quéa̱ xíní ñúhú caca nuu ndó nani jándiye̱he̱ íchi̱ cu̱hu̱n ndo̱ ta viti núná nu̱ ndó caja ndó ña̱. Jáchi̱ va̱xi qui̱ví quivi i̱ caja na ta a̱nda̱ já cacuu a tátu̱hun canaá yávi̱ ta já a̱ cánda̱a̱ ini ndó ndá xoo cu̱hu̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Xíní ñúhú candeé ini ndó ye̱he̱ jáchi̱ cúú u̱ da̱ jándiye̱he̱ nu̱ ndó nani íin i̱ xi̱hi̱n ndó. A̱nda̱ jáví xi̱nu̱ co̱o ndó cacuu ndó ña̱yivi cuéntá mí i̱ —na̱cachi Jesús. Tá na̱ndihi já na̱quee Jesús cua̱ha̱n chíje̱hé a̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Va̱tí na̱caja Jesús cua̱há ña̱ xitúhún nu̱ú ña̱yivi cán joo co̱ó na̱xeen na candúsa na mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Já na̱sahi̱in jáchi̱ na̱nditahan xi̱nu̱ co̱o nu̱ú tu̱hun ña̱ na̱ca̱hyi̱ Isaías sa̱nahá cán tá na̱cachi a já: Tátá Ndióxi̱, co̱ cúni̱ na̱ candúsa na tu̱hun ña̱ cáha̱n í xi̱hi̱n ná. Va̱tí xíní na̱ ña̱ náhnu cája mé ndó joo co̱ cúni̱ na̱ candúsa na ndo̱hó, já na̱ca̱hyí Isaías sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sa̱há ña̱ cán quéa̱ co̱ó na̱cuu candúsa ñahá ña̱yivi cán. Ta inga tucu tu̱hun na̱ca̱hyí Isaías quéa̱ cáchí já: ");
INSERT INTO mksNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Mé Ndióxi̱ quéa̱ na̱jácuaá ñahá ta co̱ó na̱suná a̱ ínima̱ ná, já ná a̱ cúu canda̱a̱ ini na yo cúú mé á, já ná a̱ cúu ndicó co̱o na nu̱ mé á ña̱ ná ndaja va̱ha mé á na̱, na̱ca̱hyí Isaías. ");
INSERT INTO mksNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Quia̱hva já na̱ca̱ha̱n Isaías jáchi̱ na̱xini mé dá ndá quia̱hva cáhnu cúú Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ta cua̱ha̱ táhan na̱ Israel cán na̱candeé ini na Jesús. Ta ja̱nda̱ java na̱ sa̱cua̱ha̱ nu̱ú na̱ Israel cán na̱candeé ini na Jesús. Joo co̱ó na̱xeen na na̱ha̱ tu̱hun na sa̱há jáchi̱ na̱yi̱hví na̱ taxí na̱ fariseo cán na̱ veñu̱hu. ");
INSERT INTO mksNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jáchi̱ cúni̱ na̱ cando̱o va̱ha chága̱ na̱ nu̱ú ña̱yivi a̱ ju̱ú ga̱ nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tá na̱ndihi já na̱ca̱ha̱n cóhó Jesús já na̱cachi a já: —Ndá na̱ cándeé ini ye̱he̱ já quéa̱ a̱ ju̱ú in túhún ye̱he̱ cándeé ini na, va̱ha. Jáchi̱ cándeé ini ri na̱ Ndióxi̱, tátá i̱, mé a̱ na̱chindahá ye̱he̱ va̱xi i̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ta ndá na̱ xíní ye̱he̱ xíní ri na mé a̱ na̱chindahá ye̱he̱ va̱xi i̱ ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ye̱he̱ na̱quixi i̱ ñuyíví yóho ña̱ ná jándiyéhe̱ ínima̱ ña̱yivi já quéa̱ ndá na̱ ná candeé ini ye̱he̱, a̱ cánduu ga̱ na̱ nu̱ú naá. ");
INSERT INTO mksNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Joo na̱ xíni̱ jo̱ho nu̱ cáha̱n i̱ ta co̱ cája na ña̱, a̱ ju̱ú toho ye̱he̱ chíca̱a̱n cua̱chi ja̱ta̱ ná. Joo tu̱hun cáha̱n i̱ quéa̱ chíca̱a̱n cua̱chi ja̱ta̱ ná. Jáchi̱ co̱ó va̱xi i̱ ñuyíví yóho chica̱a̱n i̱ cua̱chi ja̱tá ña̱yivi. Na̱quixi i̱ já ná cuu ca̱cu ndaa ínima̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ndá na̱ cándají ye̱he̱ ta co̱ cúni̱ na̱ caja na ña̱ cáchí i̱ xi̱hi̱n ná, na̱ cán cúú na̱ cu̱hu̱n indayá jáchi̱ mé tu̱hun na̱ca̱ha̱n i̱ cacuu a ña̱ chíca̱a̱n cua̱chi ja̱ta̱ ná tá ná xi̱nu̱ co̱o mé qui̱ví nu̱ ndíhí cuíí. ");
INSERT INTO mksNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Jáchi̱ co̱ jána̱ha̱ i̱ ña̱ quíxi ji̱ni̱ mé cuití i̱. Tócó ndihi ña̱ cáha̱n i̱ ta tócó ndihi ña̱ jána̱ha̱ i̱ nu̱ú ña̱yivi cúú á ña̱ na̱chindahá Ndióxi̱, tátá i̱ ye̱he̱ jána̱ha̱ i̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ta cánda̱a̱ cáxí ini i̱ ña̱ tócó ndihi ña̱ jána̱ha̱ Ndióxi̱, tátá i̱ caja ña̱ ná cu̱hu̱n na̱ coo na indiví a̱nda̱ ama cáa qui̱vi̱. Ta tócó ndihi ña̱ cáha̱n i̱ xi̱hín ña̱yivi, cáha̱n i̱ ña̱ tá quia̱hva na̱sahnda Ndióxi̱, tátá i̱ nu̱ú i̱ caja i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tácáma̱ni̱ in qui̱vi̱ coo vicó pascua já sa̱ xíni̱ Jesús ña̱ sa̱ na̱xi̱nu̱ co̱o qui̱ví quivi a jándacoo a ñuyíví yóho já ndaa mé á ndique táhan xi̱hi̱n Ndióxi̱, tátá a̱. Níí tiempo na̱qui̱hvi̱ ini Jesús tócó ndihi na̱ cúú cuéntá mé á ndúu ñuyíví yóho ta co̱ó na̱jándacoo mé á ña̱ quíhvi̱ ini a na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ta ndaja coo íin Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á xíjíni na. Jihna sa̱ na̱jáca̱ha̱n tiñáhá sa̱cua̱ha̱ Judas Iscariote, da̱ cúú ja̱hyi Simón, ña̱ ná ji̱có túhún da̱ Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Joo sa̱ xíni̱ va̱ha Jesús ña̱ na̱sa̱ha̱n Ndióxi̱, tátá a̱ tócó ndihi ndée̱ á nu̱ mé á. Ta sa̱ xíni̱ a̱ ña̱ na̱quixi a nu̱ Ndióxi̱ ta jivi nu̱ Ndióxi̱ ndindita tucu a cu̱hu̱n a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ta nani xíjíni na na̱nda̱ca̱ ndichi Jesús já na̱tavá a̱ cotó níhnu a ta já na̱tiin a in jáhma̱ na̱chiñee a tóco̱ á. ");
INSERT INTO mksNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tá na̱ndihi já na̱taán a̱ ticui̱í ini in tisa̱ha̱n loho já na̱casáhá jándoo a sa̱há na̱ xíca tuun xi̱hín a̱ cán. Ta já na̱jándihi̱chi̱ a̱ sa̱ha̱ ná xi̱hi̱n jáhma̱ cáñee tóco̱ á cán. ");
INSERT INTO mksNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ta tá na̱nditahan ndoo sa̱ha̱ Simón Pedro já na̱nda̱ca̱ tu̱hún da̱ Jesús já cáchí da̱ já: —Á mé a̱ nda̱a̱ jándoo ndó sa̱há i̱, xitoho i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Já na̱cachi Jesús já xi̱hi̱n dá: —Viti ñúhú co̱ cánda̱a̱ toho inún ndía̱ quéa̱ cája i̱ yóho joo chága̱ chí nu̱u̱ já canda̱a̱ inún ndá cuéntá quéa̱ cája i̱ já —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","A̱nda̱ já na̱cachi Pedro já: —Chí a̱ quiáhva toho mí i̱ ña̱ma̱ní nu̱ ndó jándoo ndó sa̱há i̱ —na̱cachi da. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Tá ná a̱ quiáhvún ña̱ma̱ni̱ jándoo i̱ sa̱hún já a̱ cúu cacuún cuéntá mí i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","A̱nda̱ já na̱cachi tucu da já xi̱hín Jesús: —Tá ta̱ já cáchí ndo̱ quia̱hva va i̱ sa̱há i̱ jándoo ndó ta quia̱hva ri̱ ña̱ma̱ní jándahá ndó ye̱he̱ ta quia̱hva ri̱ ña̱ma̱ní chihin ndó ji̱ní i̱ viti —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","A̱nda̱ já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já xi̱hi̱n dá: —Tá sa̱ na̱chichi va̱ha ña̱yivi já ndúu vií na̱ ta sa̱ha̱ cuití va ndó xíní ñúhú ndicata i̱. Mé ndó, na̱ xíca tuun xi̱hín i̱, sa̱ ndúu vií ndo̱ jáchi̱ sa̱ na̱jándoo i̱ cua̱chi ndó sa̱há ña̱ cándeé ini ndó ye̱he̱ va̱tí a̱ ju̱ú ndihi ndó ndúu vií —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Na̱cachi Jesús a̱ ju̱ú ndihi na ndúu vií jáchi̱ sa̱ na̱canda̱a̱ va ini mé á ndá da̱ cúú da̱ ji̱có túhún ñahá. ");
INSERT INTO mksNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tá na̱ndihi na̱jándoo Jesús sa̱ha̱ ná já na̱candixi tucu a cotó níhnu a. Já na̱saco̱o tucu a nu̱ mesa já na̱cachi a já xi̱hi̱n ná: —Cája i̱ cuéntá co̱ cánda̱a̱ va̱ha ini ndó ndá cuéntá quéa̱ na̱jándoo i̱ sa̱ha̱ ndo̱. Sa̱há ña̱ cán quéa̱ ndicani i̱ ña̱ nu̱ ndo̱ viti. ");
INSERT INTO mksNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mé ndó cáchí ndo̱ maestro xi̱hín i̱ ta cáchí ndo̱ cúú u̱ xitoho ndó ta nda̱a̱ cáha̱n ndó jáchi̱ jivi ndusa i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ta viti cande̱hé ndó. Ye̱he̱ cúú u̱ maestro ndo̱ ta cúú u̱ xitoho ndó ta na̱jándoo i̱ sa̱ha̱ ndo̱. Sa̱há ña̱ cán quéa̱ quia̱hva já ndítahan caja ndó xi̱hi̱n ndaja táhan mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Sa̱ na̱sacu u̱ in quia̱hva nu̱ ndo̱ ta ndítahan caja ndó tá quia̱hva na̱caja mí i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Xíní ñúhú canda̱a̱ ini ndó ña̱ ni in túhún toho mozo a̱ cu̱ú cacuu da da̱ cáhnu chága̱ a̱ ju̱ú ga̱ xitoho da. Ta mé a̱ nda̱a̱ íin chága̱ sa̱há in da̱ sáhndá chuun a̱ ju̱ú ga̱ mé da̱ cua̱ha̱n caja chúun cán. ");
INSERT INTO mksNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tá na̱canda̱a̱ ini ndó ña̱ cáha̱n i̱ xi̱hi̱n ndo̱ yóho ta tá ná caja ndó ña̱ já quéa̱ cuu caji̱i̱ ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ʼA̱ ju̱ú sa̱ha̱ tócó ndihi ndó cáha̱n i̱ jáchi̱ sa̱ cánda̱a̱ va̱ha ini mí i̱ ndá ndó na̱ca̱xi i̱. Joo sa̱há in ndó ndítahan xi̱nu̱ co̱o nu̱ú tu̱hun Ndióxi̱ tá na̱cachi a já: “In da̱ sáco̱o tuun xíxi xi̱hín i̱, da̱ cán cúú da̱ na̱ndicui̱ta xi̱hín i̱”, cáchí tu̱hun Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Sa̱ cáxi tu̱hun cuéé e̱ ña̱ yóho xi̱hi̱n ndo̱ já quéa̱ tá sa̱ na̱xi̱nu̱ ña̱ yóho já candeé ini ndó ye̱he̱, ña̱ cúú u̱ da̱ cáchí i̱ cúú u̱. ");
INSERT INTO mksNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Ndá na̱ ná ndiquehe va̱ha in da̱ ná chindahá i̱, cúú á tátu̱hun ndíquehe va̱ha na ye̱he̱. Ta ndá na̱ ndíquehe va̱ha ye̱he̱, ndíquehe va̱ha ri na Ndióxi̱, mé a̱ na̱chindahá ye̱he̱ quixi i̱ ñuyíví yóho —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tá na̱ndihi na̱cachi Jesús ña̱ yóho já na̱cacuéha̱ ndiva̱ha ini a já na̱cachi a já: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. In táhan ndó cacuu da̱ cu̱hu̱n ji̱có túhún ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tá na̱ndihi já na̱casáhá na̱ xíca tuun xi̱hín Jesús cán sánde̱hé nu̱ táhan na. “Yo sa̱ha̱ cáha̱n Jesús”, cáhán na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jíi̱n Jesús cán íin coo in táhan da̱ xíca tuun xi̱hi̱n á, da̱ quíhvi̱ ini mé á cán. ");
INSERT INTO mksNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sa̱há ña̱ cán quéa̱ na̱cuu ndáha̱ Simón Pedro nu̱ dá ña̱ ná nda̱ca̱ tu̱hún da̱ mé á sa̱ha̱ ndá da̱ cúú da̱ ji̱có túhún ñahá. ");
INSERT INTO mksNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A̱nda̱ já na̱cativi chága̱ da̱ cán jíi̱n Jesús já na̱casáhá da̱ ndáca̱ tu̱hún ñahá da̱ já na̱cachi da já: —Ndá da̱ cúú dá, xitoho i̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Viti ñúhú chindaxi i̱ in túhu̱n pan ta ndá da̱ ná quia̱hva i̱ túhu̱n pan cán nu̱u̱, da̱ cán cúú dá —na̱cachi Jesús. Tá na̱ndihi já na̱chindaxi a in túhu̱n pan já na̱sa̱ha̱n ña̱ nu̱ Judas Iscariote, da̱ cúú ja̱hyi Simón. ");
INSERT INTO mksNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ta tá na̱tiin Judas pan cán chí i̱vi̱ la̱á na̱ndi̱hvi tiñáhá sa̱cua̱ha̱ ini da. Já na̱cachi Jesús já xi̱hi̱n dá: —Xíní ñúhú ndihi inún cajún ña̱ na̱sacu inún cajún —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Joo ni in túhún java ga̱ na̱ ndúu coo xíxi xi̱hín Jesús cán co̱ó na̱canda̱a̱ ini na ndá cuéntá quéa̱ na̱cachi Jesús ña̱ yóho xi̱hi̱n Judas. ");
INSERT INTO mksNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Java na na̱ca̱hán na̱ ña̱ na̱sahnda Jesús chuun nu̱ Judas ña̱ ná cu̱hu̱n da̱ cueen da ña̱ha cuéntá víco̱ pascua. Ta java na na̱ca̱hán na̱ ña̱ na̱sahnda chuun nu̱ dá ña̱ ná jasá da̱ jiu̱hún nu̱ú na̱ nda̱hví jáchi̱ ndáha̱ mé dá ñúhu ndihi jiu̱hún. ");
INSERT INTO mksNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tá na̱ndihi na̱tiin Judas pan na̱sa̱ha̱n Jesús nu̱ dá chí i̱vi̱ la̱á na̱quee da cua̱ha̱n da̱. Ta sa̱ ñuú va quéa̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tá sa̱ na̱queta Judas cua̱ha̱n da̱ já na̱casáhá cáchí Jesús já xi̱hín na̱ xíca tuun xi̱hi̱n á: —Viti ndusa quéa̱ na̱casáhá ndicáhnu ndiva̱ha ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. Ta sa̱há ña̱ caja i̱ ndicáhnu ndiva̱ha Ndióxi̱, tátá i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ta tá náha̱ ye̱he̱ ndá quia̱hva cáhnu cúú Ndióxi̱, tátá i̱ quia̱hva já náha̱ ri Ndióxi̱ ndá quia̱hva cáhnu cúú ye̱he̱, da̱ na̱chindahá Ndióxi̱ nduu ña̱yivi. Ta ja̱ chá cáma̱ní coo tócó ndihi ña̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Cande̱hé ndo̱, ja̱hyi mání i̱. Ja̱ chá cuití tiempo coo i̱ xi̱hi̱n ndo̱. A̱nda̱ já ndinducú ndó ye̱he̱ joo a̱ ndíñehe ndó ye̱he̱. Ndítahan ndicu̱hu̱n ini ndó tá na̱cachi i̱ xi̱hín na̱ Israel ña̱ a̱ cúu cu̱hu̱n na̱ nu̱ú cu̱hu̱n ye̱he̱. Quia̱hva já cáchí ri̱ xi̱hi̱n ndóhó va: A̱ cúu cu̱hu̱n ndó nu̱ú cu̱hu̱n i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ta viti sáhndá i̱ inga chuun nu̱ ndo̱ ta cúú á ña̱ sa̱á. Ta ña̱ yóho cúú á: Ndítahan qui̱hvi̱ ini táhan ndó. Tá quia̱hva quíhvi̱ ini ye̱he̱ ndo̱hó quia̱hva já ndítahan qui̱hvi̱ ri ini táhan ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jáchi̱ tá ná qui̱hvi̱ ini táhan ndó já canda̱a̱ ini tócó ndihi ña̱yivi ña̱ mé a̱ nda̱a̱ táhyí cúú ndó cuéntá mí i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","A̱nda̱ já na̱nda̱ca̱ tu̱hún Simón Pedro cán Jesús já na̱cachi da já xi̱hi̱n á: —Xitoho i̱, ndájá cu̱hu̱n ndó já —na̱cachi da. A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —A̱ cu̱ú toho cu̱hu̱n yóhó nu̱ú cu̱hu̱n i̱ viti. Joo cacuáchi̱ lohún já xi̱nu̱ co̱ún cán —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","A̱nda̱ já na̱cachi Pedro já xi̱hín Jesús: —Ndá cuéntá quéa̱ cáchí ndo̱ ña̱ a̱ cúu candi̱co̱ i̱ ndo̱hó cu̱hu̱n i̱ nu̱ú cu̱hu̱n ndó viti. Jáchi̱ sa̱ íin tia̱hva i̱ quivi i̱ sa̱ha̱ ndo̱ —na̱cachi Pedro. ");
INSERT INTO mksNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já xi̱hi̱n dá: —Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xu̱hu̱n. Va̱tí íin tia̱hvún quivún sa̱há i̱ joo tá cáma̱ni̱ cana chéle já u̱ni̱ tañu chije̱hé tu̱hún sa̱há i̱ ta ca̱hún ña̱ co̱ xíni̱ tohún ye̱he̱ —na̱cachi Jesús xi̱hi̱n Pedro. ");
INSERT INTO mksNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Já na̱cachi tucu Jesús já: —Coto a̱ ndícani ini ndó. Ndítahan candeé ini ndó Ndióxi̱ ta ndítahan candeé ini ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mé nu̱ íin Ndióxi̱, tátá i̱, cán íin cua̱há ndiva̱ha nu̱ núná nu̱ ndó canduu ndó. Tá ná a̱ cóo nu̱ú canduu ndó cán ja̱nda̱ mé sa̱ha̱ va sa̱ na̱ca̱xi tu̱hun i̱ xi̱hi̱n ndó, nduu. Ta cu̱hu̱n i̱ cacu tia̱hva i̱ mé nu̱ú canduu ndó cán. ");
INSERT INTO mksNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tá sa̱ ná quee e̱ cu̱hu̱n i̱ ta tá sa̱ ná caja ndíví i̱ nu̱ú canduu ndó cán já quixi tucu u̱ ndiquehe e̱ ndo̱hó já ná cu̱hu̱n ndó canduu ndó xi̱hín i̱ mé nu̱ú coo i̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mé ndó sa̱ xíni̱ ndó ndá íchi̱ candi̱co̱ ndó já cuu sa̱a̱ ndó nu̱ú cu̱hu̱n i̱ —na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hín a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","A̱nda̱ já na̱ndica̱ha̱n Tomás xi̱hín Jesús já na̱cachi da já xi̱hi̱n á: —Mé nde̱ co̱ xíni̱ toho nde̱ ndájá cu̱hu̱n ndo̱, xitoho nde̱. Ndaja caja ri nde̱ canda̱a̱ ini nde̱ ndá íchi̱ quehe nde̱ cu̱hu̱n nde̱ —na̱cachi da xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já xi̱hi̱n dá: —Ye̱he̱ cúú tátu̱hun íchi̱ ña̱ ndítahan candi̱co̱ ña̱yivi ta ye̱he̱ cúú da̱ jána̱ha̱ ña̱ nda̱a̱. Ta ye̱he̱ cúú da̱ cája ña̱ ná catacu ña̱yivi a̱nda̱ ama cáa qui̱vi̱. Ta in túhún ye̱he̱ ndítahan candeé ini ña̱yivi já ná cuu xi̱nu̱ co̱o na nu̱ Ndióxi̱, tátá i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tá xíni̱ ndó yo cúú ye̱he̱ já xíni̱ ri ndó yo cúú Ndióxi̱, tátá i̱. Ta viti xi̱hi̱n chí nu̱u̱ xíni̱ ndó a̱ jáchi̱ sa̱ na̱xini ndó a̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","A̱nda̱ já na̱cachi Felipe já xi̱hín Jesús: —Xitoho nde̱, jána̱ha̱ ndó nu̱ú nde̱ yo cúú tátá ndo̱ já ná caji̱i̱ ini nde̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Ndá cuéntá quéa̱ cáchún já jáchi̱ ja̱nda̱ jihna ndiva̱ha va íin i̱ xi̱hi̱n ndo̱ ta sa̱ ndítahan canda̱a̱ ini ndó yo cúú ye̱he̱. Jáchi̱ ndá na̱ sa̱ xíni̱ yo cúú ye̱he̱ xíni̱ ri na yo̱ cúú Ndióxi̱, tátá i̱. Sa̱há ña̱ cán quéa̱ ndá cuéntá quéa̱ cúni̱ ndó ña̱ ná jána̱ha̱ i̱ tátá i̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Xíní ñúhú candúsa ndó ña̱ in cúú va ye̱he̱ xi̱hi̱n Ndióxi̱, tátá i̱ ta in cúú va mé á xi̱hín i̱. Tócó ndihi ña̱ cáha̱n i̱ xi̱hi̱n ndo̱ yóho co̱ cáha̱n i̱ ña̱ sa̱há ña̱ quíxi a ji̱ni̱ mé cuití vi̱. Cáha̱n i̱ ña̱ quixi nu̱ Ndióxi̱ jáchi̱ íin mé á xi̱hín i̱. Ta chuun cája i̱ quixi a nu̱ Ndióxi̱ jáchi̱ cája chúun mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xíní ñúhú candúsa ndó ña̱ in cúú ye̱he̱ xi̱hi̱n Ndióxi̱, tátá i̱ ta in cúú Ndióxi̱, tátá i̱ xi̱hín i̱. Ta tá co̱ cúni̱ ndó candúsa ndó ña̱ já quéa̱ xíní ñúhú candúsa ndó ña̱ sa̱há ña̱ náhnu na̱xini ndó na̱caja i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Ndá na̱ cándeé ini ye̱he̱, cuu caja na ña xitúhún tátu̱hun ña̱ cája mí i̱. Ta ja̱nda̱ ña̱ náhnu chága̱ cuu caja na jáchi̱ cu̱hu̱n i̱ nu̱ íin Ndióxi̱, tátá i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ta tócó ndihi ña̱ ca̱ca̱ ndó nu̱ Ndióxi̱, xíní ñúhú ca̱ca̱ ndó ña̱ xi̱hín qui̱vi̱ mí i̱ já ná caja i̱ ña̱. Ta ndicáhnu Ndióxi̱, tátá i̱ xi̱hín ña̱ caja i̱ sa̱ha̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ta caja i̱ ndá ña̱ ná ca̱ca̱ ndo̱ nu̱ú i̱ tá ná ca̱ca̱ ndó ña̱ xi̱hín qui̱vi̱ mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ʼTá mé a̱ nda̱a̱ quíhvi̱ ini ndó ye̱he̱, caja tá caja ndó ña̱ sáhndá i̱ nu̱ ndo̱ caja ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ta ca̱ca̱ i̱ nu̱ Ndióxi̱, tátá i̱ ña̱ ná chindahá mé á ínima̱ yi̱i̱ mé á nu̱ ndo̱. Ta chíndeé mé á ndo̱hó já ná quia̱hva tu̱hun ndéé ini ndó ta já cuu coo tuun a xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Joo ña̱yivi, na̱ co̱ cúú cuéntá mí i̱, a̱ cúu ndiquehe na ña̱ jáchi̱ co̱ cánda̱a̱ ini na yo cúú mé á ta ni co̱ cúni̱ na̱ ndiquehe va̱ha na ña̱. Joo ndóhó xíni̱ va̱ha ndó a̱ jáchi̱ sa̱ íin a xi̱hi̱n ndo̱ ta níí tiempo cañuhu a ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","A̱ jándacoo ndáha̱ toho i̱ ndo̱hó jáchi̱ ndicó co̱o tucu u̱ já coo i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ja̱ chá cuití ta a̱ cúní ga̱ ña̱yivi cuéntá ñuyíví ye̱he̱. Joo mé ndó cuni tá cuni ndó ye̱he̱. Ta sa̱há ña̱ nditacu tucu u̱ sa̱há ña̱ cán quéa̱ cuu catacu mé ndó a̱nda̱ ama cáa qui̱vi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ta mé qui̱vi̱ cán canda̱a̱ ini ndó ña̱ mé a̱ nda̱a̱ in cúú ye̱he̱ xi̱hi̱n Ndióxi̱, tátá i̱. Ta canda̱a̱ ini ndó ña̱ quia̱hva já in cúú ndó xi̱hín i̱ ta in cúú ye̱he̱ xi̱hi̱n mé ndó viti. ");
INSERT INTO mksNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ndá na̱ ndíquehe va̱ha tu̱hun cáha̱n i̱ ta cája na ña̱, náha̱ na̱ xi̱hín ña̱ yóho ña̱ mé a̱ nda̱a̱ quíhvi̱ ini na ye̱he̱. Ta mé Ndióxi̱, tátá i̱ quíhvi̱ ini a ndijáá na̱ quíhvi̱ ini ye̱he̱. Ta quíhvi̱ ri ini ye̱he̱ na̱ ta na̱ha̱ i̱ mí i̱ nu̱ ná —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A̱nda̱ já in da̱ naní Judas, da̱ co̱ cúú toho da̱ naní Judas Iscariote, na̱nda̱ca̱ tu̱hún da̱ Jesús já na̱cachi da já xi̱hi̱n á: —Xitoho nde̱, ndá cuéntá quéa̱ cáchí ndó ña̱ na̱ha̱ ndó mé ndó nu̱ú nde̱ joo a̱ náha̱ toho ndó mé ndó nu̱ú ña̱yivi cuéntá ñuyíví —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Já na̱nducú ñehe Jesús tu̱hun nu̱ dá já na̱cachi a já xi̱hi̱n dá: —Ndá na̱ quíhvi̱ ini ye̱he̱, na̱ cán cúú na̱ cája ña̱ cáha̱n i̱. Ta já quíhvi̱ ini Ndióxi̱, tátá i̱ na̱ ta já quixi nde̱ coo nde̱ xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Joo na̱ co̱ quíhvi̱ ini ye̱he̱, na̱ cán cúú na̱ quéhe núu tu̱hun cáha̱n i̱. Ta mé tu̱hun cáha̱n i̱ nu̱ ndó yóho co̱ cúú á ña̱ quíxi ji̱ni̱ mí i̱. Cúú á tu̱hun Ndióxi̱, tátá i̱, mé a̱ na̱chindahá ye̱he̱ quixi i̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ʼTócó ndihi ña̱ yóho ndícani i̱ ña̱ nu̱ ndó viti nani íin i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Joo ínima̱ yi̱i̱ Ndióxi̱, mé a̱ chindahá Ndióxi̱ yuhú nu̱ú i̱ quixi a, chindeé a̱ ndo̱hó. Mé a̱ cán quéa̱ jána̱ha̱ tócó ndihi ña̱ha nu̱ ndo̱. Ta jándicu̱hu̱n a̱ ini ndó tócó ndihi ña̱ na̱cachi i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ʼTá sa̱ ná quee e̱ cu̱hu̱n i̱ já caja i̱ ña̱ ná coo va̱ha ini ndó. Joo a̱ cácuu a tátu̱hun tá cája ña̱yivi cuéntá ñuyíví. “Ná coo va̱ha ini ndó”, cáchí xi̱hi̱n táhan na joo co̱ íin va̱ha ini xi̱hi̱n táhan na. Coto a̱ ndícani na̱há ini ndó ta coto a̱ yíhví ndo̱ jáchi̱ caja i̱ ña̱ ná coo va̱ha ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Sa̱ na̱xini jo̱ho ndó ña̱ na̱cachi i̱ xi̱hi̱n ndo̱ ña̱ quee e̱ cu̱hu̱n i̱ ta ndicó co̱o tucu u̱ já coo i̱ xi̱hi̱n ndo̱. Ta tá mé a̱ nda̱a̱ quíhvi̱ ndusa ini ndó ye̱he̱ já quéa̱ caji̱i̱ ini ndó sa̱há ña̱ cáchí i̱ cu̱hu̱n i̱ nu̱ íin Ndióxi̱, tátá i̱. Ta íin chága̱ sa̱ha̱ mé á a̱ ju̱ú ga̱ ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Sa̱ ndícani cuéé vi̱ ña̱ yóho nu̱ ndo̱ já quéa̱ tá ná xi̱nu̱ co̱o ña̱ cáchí i̱ xi̱hi̱n ndo̱ coo já quéa̱ cuu candúsa ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ʼJa̱ chá cuití va coo i̱ ñuyíví yóho nditúhún i̱ xi̱hi̱n ndo̱ jáchi̱ sa̱ na̱tandaa hora xi̱nu̱ rí quini, rí cómí cuéntá sa̱há ña̱yivi ñuyíví yóho va̱tí mé a̱ nda̱a̱ co̱ ndée̱ rí caja rí ni in ña̱ha xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Joo ya̱ha tá ya̱ha ña̱ cúni̱ ri̱ caja rí xi̱hín i̱. Ta xi̱hín ña̱ yóho canda̱a̱ ini ña̱yivi ndúu ñuyíví ña̱ mé a̱ nda̱a̱ quíhvi̱ ini ndusa i̱ Ndióxi̱, tátá i̱ ta cája i̱ ña̱ na̱sahnda mé á nu̱ú i̱ caja i̱. Candichi ndó. Xíhín ndo̱ ná co̱ho̱ —na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hín a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","A̱nda̱ já na̱cachi tucu Jesús já xi̱hi̱n ná: —Ye̱he̱ cúú ndusa tátu̱hun in tó uva ta Ndióxi̱, tátá i̱ cúú á tátu̱hun da̱ ndája vií sa̱ha̱ mé tó uva cán. ");
INSERT INTO mksNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta ña̱yivi cúú ná tátu̱hun ndáha̱ tó uva cán. Ta ndá na̱ co̱ xe̱én caja ña̱ cúni̱ Ndióxi̱ jácaxoo a na̱ nu̱ mé á tá quia̱hva cája da̱ ndája vií dó cán tá chítúhu̱n dá ndáha̱ tó uva, ña̱ co̱ cána uva nu̱u̱. Joo tá cána cua̱ha̱ uva nu̱ do̱ já quéa̱ ndája vií da̱ ndáha̱ do̱ ta ndíja̱tá da̱ do̱ já ná cana cua̱ha̱ chága̱ uva nu̱ do̱. Quia̱hva já cája ri Ndióxi̱ xi̱hín ña̱yivi, na̱ cája ña̱ cúni̱ mé á. ");
INSERT INTO mksNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Joo mé ndó sa̱ na̱ndivií va ndó jáchi̱ na̱xini jo̱ho ndó ña̱ jána̱ha̱ i̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xíní ñúhú in cacuu ndó xi̱hín i̱ tá quia̱hva in cúú ye̱he̱ xi̱hi̱n ndo̱. Jáchi̱ in ndáha̱ tó uva a̱ cu̱ú cana uva nu̱ do̱ tá co̱ tíin dó tóco̱ tó uva cán. Quia̱hva já íin ri xi̱hi̱n ndóhó va. A̱ cúu caja ndó ña̱ cúni̱ Ndióxi̱ tá co̱ó in cúú ndó xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ʼYe̱he̱ cúú u̱ tátu̱hun tó uva ta ndóhó cúú ndó tátu̱hun ndáha̱ mé tó uva cán. Ta ndá na̱ in cúú xi̱hín i̱ tá quia̱hva in cúú u̱ xi̱hi̱n ná já quéa̱ cuu caja ndihi na ña̱ cúni̱ Ndióxi̱. Cacuu a tátu̱hun cána cua̱ha̱ uva va̱ha nu̱ ndáha̱ tó uva cán. Jáchi̱ mé a̱ nda̱a̱ ni in túhún ña̱ha a̱ cúu caja ndó tá ná a̱ chíndeé ye̱he̱ ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ta ndá na̱ co̱ cúni̱ in cacuu xi̱hín i̱, na̱ cán cúú na̱ jácaxoo Ndióxi̱. Ta cúú ná tátu̱hun in ndáha̱ tó uva, dó sa̱ na̱hi̱chi̱ ta nditaca dó cu̱hu̱n dó ca̱yi̱ do̱. ");
INSERT INTO mksNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ʼTá in ná cacuu ndó xi̱hín i̱ ta tá ná caja ndó ña̱ na̱jána̱ha̱ i̱ nu̱ ndo̱ já cuu ca̱ca̱ ndó ndá ña̱ cúni̱ mé ndó nu̱ú i̱ já quia̱hva i̱ ña̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mé Ndióxi̱, tátá i̱ ndicáhnu ndiva̱ha tá ná caja ndó ña̱ cúni̱ a̱ xi̱hi̱n ndinuhu ini ndó. Ta xi̱hín ña̱ yóho náha̱ ndó ña̱ cúú ndó cuéntá mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Quíhvi̱ ini i̱ ndo̱hó tá quia̱hva quíhvi̱ ini Ndióxi̱, tátá i̱ ye̱he̱. Xíní ñúhú coo tuun ndó xi̱hín i̱ jáchi̱ quíhvi̱ ini i̱ ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tá ná caja ndó tócó ndihi ña̱ sáhndá i̱ nu̱ ndo̱ caja ndó já quéa̱ coo tuun ndó xi̱hín i̱ jáchi̱ quíhvi̱ ini i̱ ndo̱hó. Quia̱hva já cája ri ye̱he̱ va. Cája i̱ tócó ndihi ña̱ na̱sahnda Ndióxi̱, tátá i̱ caja i̱ ta xi̱hín ña̱ yóho íin tuun i̱ xi̱hi̱n á jáchi̱ quíhvi̱ ini a ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ʼCáxi tu̱hun i̱ ña̱ yóho xi̱hi̱n ndo̱ já ná caji̱i̱ íní ndo̱ tá quia̱hva cáji̱i̱ íní ye̱he̱. Ta xi̱hín ña̱ yóho ndicutú nda̱a̱ ínima̱ ndo̱ xi̱hín ña̱ cáji̱i̱ ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Cuni jo̱ho ndó ña̱ sáhndá i̱ nu̱ ndo̱ yóho: Ndítahan qui̱hvi̱ ini táhan ndó tá quia̱hva quíhvi̱ ini ye̱he̱ ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tá mé a̱ nda̱a̱ táhyí quíhvi̱ ini ña̱yivi ñani táhan na já quéa̱ íin tia̱hva na quivi na sa̱ha̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mé ndó cúú ndó amigo i̱ tá cája ndó ña̱ sáhndá i̱ nu̱ ndó caja ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Cáchí i̱ xi̱hi̱n ndo̱ ña̱ cúú ndó amigo i̱ jáchi̱ cáxi tu̱hun ndihi i̱ xi̱hi̱n ndo̱ ña̱ cáha̱n Ndióxi̱, tátá i̱ xi̱hín i̱. Ta a̱ cáha̱n ga̱ i̱ xi̱hi̱n ndo̱ ña̱ cúú ndó mozo jáchi̱ in mozo co̱ xíni̱ toho da ndaja cáa ña̱ cája xitoho da. ");
INSERT INTO mksNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mé ndó co̱ó na̱ca̱xi ndó ye̱he̱ caca nuu i̱ xi̱hi̱n ndo̱. Joo mí i̱ na̱ca̱xi i̱ ndo̱hó ña̱ ná caca nuu ndó xi̱hín i̱. Ta na̱jána̱ha̱ i̱ ndo̱hó ndá quia̱hva caja ndó já ná cacuu ndó tátu̱hun in yíto̱, dó sáhan cua̱há cui̱hi ña̱ a̱ ndíhi sa̱ha̱. Tá ná caja ndó ña̱ cúni̱ Ndióxi̱ já quia̱hva tátá i̱ ndá a̱ cúni̱ mé ndó tá ná ca̱ca̱ ndó ña̱ xi̱hín qui̱vi̱ mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ña̱ yóho quéa̱ sáhndá i̱ nu̱ ndó caja ndó: Qui̱hvi̱ ini táhan ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ʼCande̱hé ndo̱. Tá ná casáhá candají ña̱yivi cuéntá ñuyíví ndo̱hó xíní ñúhú ndicu̱hu̱n ini ndó ña̱ jihna ñúhú ga̱ na̱candají ri na̱ ye̱he̱ va. ");
INSERT INTO mksNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tá ná caja ndó tá quia̱hva cája ña̱yivi ñuyíví já quéa̱ qui̱hvi̱ ini va na̱ cán ndo̱hó. Jáchi̱ já cája xi̱hi̱n táhan mé na̱ cán. Joo ye̱he̱ na̱ca̱xi i̱ ndo̱hó ña̱ ná quee ndó tañu na̱ cán. Sa̱há ña̱ cán quéa̱ co̱ cúni̱ na̱ cán ndo̱hó jáchi̱ co̱ cúú ga̱ ndó na̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Coto a̱ ndíndójó ndo̱ ña̱ na̱ca̱ha̱n i̱ xi̱hi̱n ndo̱ tá na̱cachi i̱ ña̱ ni in túhún toho mozo a̱ cúu cacuu da da̱ cáhnu chága̱ nu̱ú xitoho da. Ta ni mé ndó co̱ cúú ndó na̱ náhnu chága̱ a̱ ju̱ú ga̱ ye̱he̱. Jáchi̱ tá quia̱hva na̱caja xíxi na xi̱hín ye̱he̱ quia̱hva já caja xíxi ri na xi̱hi̱n ndóhó va. Tá ná candúsa na ña̱ na̱ca̱ha̱n i̱ xi̱hi̱n ná quia̱hva já candúsa ri na ña̱ ná ca̱ha̱n ri ndóhó va xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tócó ndihi ña̱ yóho caja na xi̱hi̱n ndo̱ sa̱há ña̱ cándeé ini ndó ye̱he̱. Jáchi̱ co̱ xíni̱ na̱ Ndióxi̱, tátá i̱, mé a̱ na̱chindahá ye̱he̱ va̱xi i̱ ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ʼTá ná a̱ quíxi toho i̱ ñuyíví yóho ca̱xi tu̱hun i̱ xi̱hín ña̱yivi, nduu co̱ó toho na̱ jácojo cua̱chi ja̱ta̱ ná, nduu. Joo viti na̱quixi i̱ ñuyíví yóho ta ndítahan nu̱ ná ndiquia̱hva na cuéntá sa̱há cua̱chi na. ");
INSERT INTO mksNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ndá ña̱yivi cándají ye̱he̱, cándají ri na Ndióxi̱, tátá i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na̱caja i̱ ña̱ náhnu nu̱ ná joo co̱ó na̱candúsa na ye̱he̱ sa̱há ña̱ cán quéa̱ ndójo na cua̱chi. Ta ni in túhún toho ña̱yivi co̱ó na̱caja ña̱ náhnu tá quia̱hva na̱caja i̱ nu̱ ná. Va̱tí na̱xini na ña̱ náhnu na̱caja i̱ joo cándají na̱ ye̱he̱ ta cándají na̱ Ndióxi̱, tátá i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Joo xi̱hi̱n tócó ndihi ña̱ cúu yóho xínu̱ co̱o nu̱ ley na̱jándacoo Moisés nu̱ ná sa̱nahá tá cáchí a̱ já: “Chí co̱ó sa̱ha̱ ná candají na̱ ye̱he̱”, já na̱cachi Moisés sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ʼTá ná quixi ínima̱ yi̱i̱ Ndióxi̱, mé a̱ chindahá i̱ cuéntá Ndióxi̱, tátá i̱, mé a̱ cán quéa̱ ca̱ha̱n va̱ha sa̱há i̱. Ta jána̱ha̱ ña̱ nda̱a̱ sa̱ha̱ Ndióxi̱ ta chindeé a̱ ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ta jári mé ndó ca̱ha̱n va̱ha ndó sa̱há i̱ jáchi̱ ja̱nda̱ sa̱ha̱ tá na̱casáhá cája chúun i̱ ñuyíví yóho na̱sa̱nduu tuun ndó xi̱hín i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Já na̱cachi tucu Jesús já: —Ca̱xi tu̱hun i̱ ña̱ yóho xi̱hi̱n ndó já ná a̱ jándacoo ndó ña̱ cándeé ini ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jáchi̱ va̱xi qui̱ví tá taxí ña̱yivi ndo̱hó veñu̱hu. Ta ndá na̱ ná cahní ndo̱hó ca̱hán na̱ ña̱ cája chúun na cuéntá Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Caja na ña̱ yóho jáchi̱ co̱ xíni̱ na̱ yo cúú Ndióxi̱, tátá i̱ ta ni co̱ xíni̱ na̱ ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sa̱ cáxi tu̱hun cuéé e̱ ña̱ yóho xi̱hi̱n ndo̱ já quéa̱ tá ná xi̱nu̱ co̱o qui̱vi̱ cán já ndicu̱hu̱n ini ndó ña̱ sa̱ na̱ca̱xi tu̱hun ya̱chi̱ vi̱ xi̱hi̱n ndo̱ ña̱ já coo. ʼCo̱ó na̱ca̱xi tu̱hun i̱ ña̱ yóho xi̱hi̱n ndó jihna jáchi̱ na̱sahi̱in i̱ xi̱hi̱n ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ja̱ chá cu̱hu̱n i̱ coo i̱ xi̱hi̱n Ndióxi̱, tátá i̱, mé a̱ na̱chindahá ye̱he̱ ñuyíví yóho joo ni in ndó co̱ ndáca̱ tu̱hún ndó ye̱he̱ ndájá cu̱hu̱n i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ña̱ cája ndó quéa̱ cácuéha̱ ndiva̱ha ini ndó sa̱há ña̱ ndícani i̱ tócó ndihi ña̱ yóho nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Joo mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱: Va̱ha chága̱ ná quee e̱ cu̱hu̱n i̱. Jáchi̱ tá ná a̱ quée ye̱he̱ cu̱hu̱n i̱ já a̱ cúu quixi ínima̱ yi̱i̱ Ndióxi̱ coo a xi̱hi̱n ndo̱ ta mé a̱ cán chindeé a̱ ndo̱hó. Joo tá ná quee e̱ cu̱hu̱n i̱ já chindahá i̱ mé á quixi a nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ta tá ná xi̱nu̱ a̱ cán jána̱ha̱ cáxí táhyí a̱ nu̱ú ña̱yivi ña̱ cája na cua̱chi. Ta jána̱ha̱ nu̱ ná ndaja íin íchi̱ cuéntá ña̱ nda̱a̱. Ta jána̱ha̱ nu̱ ná ndá quia̱hva cavií sa̱há ña̱yivi caja Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ta jána̱ha̱ cáxí táhyí a̱ ña̱ íin cua̱chi na jáchi̱ co̱ cándeé ini na ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ta jána̱ha̱ ínima̱ yi̱i̱ Ndióxi̱ ndaja íin íchi̱ cuéntá ña̱ nda̱a̱ jáchi̱ quee e̱ cu̱hu̱n i̱ nu̱ íin Ndióxi̱, tátá i̱ ta a̱ cúní ga̱ ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ta jána̱ha̱ cáxí táhyí a̱ ña̱ caja vií Ndióxi̱ sa̱há cua̱chi jáchi̱ sa̱ na̱caja vií a̱ sa̱há tiñáhá sa̱cua̱ha̱ va̱tí viti ñúhú cómí rí cuéntá sa̱há ña̱yivi ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ʼÍin cua̱há ndiva̱ha ña̱ha cúni̱ ca̱ha̱n chága̱ i̱ xi̱hi̱n ndo̱. Joo va̱ti̱ já va viti jáchi̱ a̱ cándo̱o ga̱ ji̱ni̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tá ná xi̱nu̱ ínima̱ yi̱i̱ Ndióxi̱, mé a̱ cúú ña̱ nda̱a̱, mé a̱ cán candaca ndo̱hó íchi̱ cuéntá ña̱ nda̱a̱. Ta a̱ cáha̱n toho a cán ña̱ quixi ji̱ni̱ mé á jáchi̱ ca̱ha̱n mé á ña̱ xíni̱ jo̱ho a cáha̱n Ndióxi̱. Ta ca̱xi tu̱hun a xi̱hi̱n ndo̱ ndá a̱ coo chága̱ chí nu̱u̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ta mé a̱ cán caja cáhnu a ye̱he̱ jáchi̱ jána̱ha̱ nu̱ ndó ña̱ cúni̱ mí i̱ jána̱ha̱ i̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tócó ndihi ña̱ha jána̱ha̱ Ndióxi̱, tátá i̱ cúú ri a ña̱ jána̱ha̱ ye̱he̱ va. Sa̱há ña̱ cán quéa̱ cáchí i̱ xi̱hi̱n ndó ña̱ ínima̱ yi̱i̱ mé á ca̱xi tu̱hun a xi̱hi̱n ndó ña̱ cúni̱ mí i̱ jána̱ha̱ i̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ʼJa̱ chá cuití coo i̱ xi̱hi̱n ndo̱ ta a̱ cúní ga̱ ndó ye̱he̱ jáchi̱ quee e̱ cu̱hu̱n i̱ nu̱ íin Ndióxi̱, tátá i̱. Joo tá na̱ndihi já cuni tucu ndó ye̱he̱ —cáchí Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","A̱nda̱ já na̱casáhá java na̱ xíca tuun xi̱hi̱n á cán ndáca̱ tu̱hún táhan na já cáchí xi̱hi̱n táhan na já: —Ndía̱ cúni̱ ri Jesús cachi a xo̱ho̱ tá cáchí a̱ ña̱ ja̱ chá cuití va ta a̱ cúní ga̱ í mé á ta tá na̱ndihi já cuni tucú mé á. Ta cáchí a̱ ña̱ cúú á sa̱há ña̱ quee a cu̱hu̱n a̱ nu̱ íin Ndióxi̱, tátá a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ndía̱ cúni̱ ri a cachi a ña̱ ja̱ chá cuití va cuní mé á. Co̱ cánda̱a̱ va̱ha toho iní ndía̱ cúni̱ mé á cachi a xi̱hín tu̱hun yóho —na̱cachi xi̱hi̱n táhan na. ");
INSERT INTO mksNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Joo na̱canda̱a̱ ini Jesús ña̱ cúni̱ na̱ nda̱ca̱ tu̱hún na̱ mé á sa̱há ña̱ cán quéa̱ na̱cachi a já xi̱hi̱n ná: —Na̱cachi i̱ xi̱hi̱n ndó ña̱ ja̱ chá cuití ta a̱ cúní ga̱ ndó ye̱he̱ ta tá na̱ndihi já cuni tucu ndó ye̱he̱. Ta viti cúni̱ ndo̱ nda̱ca̱ tu̱hún ndó ye̱he̱ ndía̱ cúni̱ cachi ña̱ yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mé a̱ nda̱a̱ ná ca̱ha̱n i̱ xi̱hi̱n ndo̱. Tandaa qui̱vi̱ cuacu ndó ta cacuéha̱ ndiva̱ha ini ndó ta ña̱yivi ñuyíví yóho cavatá ndiva̱ha na sa̱há ña̱ ndoho i̱. Ta va̱tí cacuéha̱ ini ndó joo in cuití ndaja̱ma ña̱ ja̱n ta já caji̱i̱ ndiva̱ha ini ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cacuu a tátu̱hun tá xínu̱ co̱o hora cacu ja̱hyi in ñáñáha̱ ta já casáhá ndóho ini ñá. Joo tá sa̱ na̱cacu ja̱hyi ñá ndíndójó ndihi ñá sa̱há ña̱ na̱ndoho ini ñá jáchi̱ sa̱ na̱cacu ja̱hyi ñá ta cáji̱i̱ ndiva̱ha ini ñá xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Quia̱hva já ndóho ini ndó xi̱hín ña̱ táhnda̱ ini ndó viti. Joo ndicó co̱o tucu ye̱he̱ já cuni táhan tucú ta já ndicutú nda̱a̱ ínima̱ ndó xi̱hín ña̱ cáji̱i̱ íní ndo̱. Ta ni in na a̱ cúu caja caji nuu nu̱ú ña̱ cáji̱i̱ íní ndó ja̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ʼMé qui̱vi̱ cán co̱ó ga̱ ña̱ha ca̱ca̱ ndó nu̱ú i̱. Jáchi̱ mé Ndióxi̱, tátá i̱ quia̱hva tócó ndihi ña̱ xíní ñúhú ndo̱ tá ná ca̱ca̱ ndó ña̱ nu̱ á xi̱hín qui̱vi̱ mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ja̱nda̱ viti a̱ ñáha ca̱ca̱ ndó ña̱ha nu̱ Ndióxi̱, tátá i̱ xi̱hín qui̱ví ye̱he̱. Joo viti xíní ñúhú ca̱ca̱ ndó ña̱ cúni̱ ndó nu̱ mé á xi̱hín qui̱ví ye̱he̱ ta já quia̱hva mé á ña̱ nu̱ ndo̱. Ta xi̱hín ña̱ yóho cuu ndicutú nda̱a̱ ini ndó xi̱hín ña̱ cáji̱i̱ íní ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ʼXi̱hín quia̱hva cuití na̱ca̱ha̱n i̱ ña̱ yóho xi̱hi̱n ndo̱. Joo tandaa qui̱vi̱ ta a̱ cáha̱n ga̱ i̱ xi̱hín quia̱hva nu̱ ndo̱. Ña̱ caja i̱ quéa̱ cáxí táhyí ca̱ha̱n i̱ sa̱ha̱ Ndióxi̱, tátá i̱ nu̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta mé qui̱vi̱ cán ca̱ca̱ ndó ña̱ cúni̱ ndó nu̱ Ndióxi̱, tátá i̱ xi̱hín qui̱vi̱ mí i̱. Sa̱ núná nu̱ ndó ca̱ca̱ ta̱hví ndó nu̱ á ta co̱ xíní ñúhú ga̱ ca̱ca̱ ta̱hví ye̱he̱ nu̱ mé á sa̱ha̱ ndo̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Jáchi̱ sa̱ quíhvi̱ ini tátá i̱ ndo̱hó sa̱há ña̱ quíhvi̱ ini ndó ye̱he̱ ta sa̱há ña̱ na̱candúsa ndó ña̱ na̱chindahá mé á ye̱he̱ va̱xi i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mé nu̱ íin Ndióxi̱, tátá i̱ na̱quee e̱ va̱xi i̱ ñuyíví yóho. Ta ya̱chi̱ chá ta jándacoo i̱ ñuyíví yóho já ndicó co̱o tucu u̱ cu̱hu̱n i̱ nu̱ íin Ndióxi̱, tátá i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","A̱nda̱ já na̱cachi na̱ xíca tuun xi̱hi̱n á cán já: —Viti ndusa quéa̱ cáha̱n cáxí táhyí ndo̱ xi̱hín nde̱ ta co̱ sácú ga̱ ndó quia̱hva nu̱ú nde̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ta viti ndusa cánda̱a̱ ini nde̱ ña̱ xíni̱ ndo̱ tócó ndihi ña̱ha. Ta ni co̱ xíní ñúhú toho ndó ña̱ ná nda̱ca̱ tu̱hún nde̱ ndo̱hó jáchi̱ sa̱ xíni̱ va ndó ña̱ cúni̱ nde̱ canda̱a̱ ini nde̱. Sa̱há ña̱ cán quéa̱ cándúsa nde̱ ña̱ na̱quixi ndó nu̱ íin Ndióxi̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Já na̱nducú ñehe Jesús tu̱hun nu̱ ná já na̱cachi a já xi̱hi̱n ná: —Á ja̱ víti ndusa cándúsa ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Joo sa̱ na̱xi̱nu̱ co̱o va hora ndicui̱ta nuu ndó ndá na̱cuu cu̱hu̱n ndo̱ ta jándacoo in túhún ndó ye̱he̱. Va̱tí mé a̱ nda̱a̱ a̱ cándo̱o mé toho i̱ jáchi̱ íin Ndióxi̱, tátá i̱ xi̱hín i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Cáxi tu̱hun i̱ ña̱ yóho xi̱hi̱n ndo̱ já ná coo va̱ha ini ndó sa̱há ña̱ in cúú ndó xi̱hín i̱. Mé a̱ nda̱a̱ ndoho tá ndoho ini ndó ñuyíví yóho. Joo a̱ cáyi̱hví toho ndó jáchi̱ ye̱he̱ na̱candeé e̱ na̱sa̱hnu̱ i̱ nu̱ tócó ndihi ña̱ núu ñuyíví yóho —na̱cachi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á cán. ");
INSERT INTO mksNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tá na̱ndihi na̱cachi Jesús tócó ndihi ña̱ yóho xi̱hín na̱ xíca tuun xi̱hi̱n á cán já na̱ndiñehe a nu̱u̱ á chí indiví já na̱cachi a já: —Tátá Ndióxi̱, sa̱ na̱xi̱nu̱ co̱o qui̱ví quivi i̱. Caja ndó ña̱ ndicáhnu ndiva̱ha mí i̱, da̱ cúú in túhún ji̱ní já ja̱hyi mé ndó já ná cuu caja cáhnu ri ye̱he̱ va ndo̱hó. ");
INSERT INTO mksNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Jáchi̱ mé ndó na̱sa̱ha̱n ndó nu̱ú i̱ ña̱ ná cacomí i̱ cuéntá sa̱ha̱ tócó ndihi ña̱yivi já ná cuu caja i̱ ña̱ ná catacu na a̱nda̱ ama cáa qui̱vi̱ jáchi̱ cúú ná na̱ na̱sa̱ha̱n ndo̱ nu̱ú i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ta tá xíni̱ na̱ yo cúú mé ndó ta tá xíni̱ na̱ yo cúú ye̱he̱, da̱ na̱chindahá ndó ñuyíví yóho já cuu catacu na a̱nda̱ ama cáa qui̱vi̱. Jáchi̱ in túhún mé ndó cúú ndusa Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ʼSa̱ na̱caja cáhnu i̱ ndo̱hó nani íin i̱ ñuyíví yóho ta sa̱ na̱jáxi̱nu̱ co̱o ndihi i̱ ña̱ na̱sahnda ndó nu̱ú i̱ caja i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ta viti xíca̱ ta̱hví i̱ nu̱ ndo̱, tátá Ndióxi̱ ña̱ ná na̱ha̱ ndo̱ nu̱ú ña̱yivi ndaja cáhnu cúú ye̱he̱ nu̱ mé ndó jáchi̱ quia̱hva já in cáhnu na̱sa̱cuu u̱ xi̱hi̱n ndó ja̱nda̱ tá cáma̱ní ca̱va̱ sáhá sa̱ha̱ ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ʼTa na̱ca̱xi ndó na̱ cacuu cuéntá mí i̱ tañu ña̱yivi cuéntá ñuyíví yóho. Ta sa̱ na̱ca̱xi tu̱hun i̱ xi̱hi̱n ná yo cúú mé ndó. Na̱ca̱xi ndó na̱ ta na̱ndiquia̱hva ndó na̱ nu̱ú i̱. Ta na̱candúsa na tu̱hun ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ta viti cánda̱a̱ ini na ña̱ tócó ndihi ña̱ sáhan ndó nu̱ú i̱ quíxi a cuéntá mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ta sa̱ na̱ca̱xi tu̱hun i̱ xi̱hi̱n ná tócó ndihi ña̱ na̱sa̱ha̱n ndó nu̱ú i̱ ta na̱ndiquehe va̱ha na ña̱. Ta sa̱ na̱canda̱a̱ ini na ña̱ mé a̱ nda̱a̱ na̱quixi i̱ cuéntá mé ndó. Ta na̱candúsa na ña̱ na̱chindahá ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ʼCo̱ xíca̱ ta̱hví i̱ nu̱ ndó sa̱há ña̱yivi cuéntá ñuyíví yóho. Joo xíca̱ ta̱hví i̱ nu̱ ndó sa̱há na̱ na̱sa̱ha̱n ndó nu̱ú i̱ jáchi̱ cúú ná cuéntá mé ndó. ");
INSERT INTO mksNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tócó ndihi na̱ cúú cuéntá mí i̱ cúú ná cuéntá mé ndó viti. Ta tócó ndihi na̱ cúú cuéntá mé ndó cúú ri na̱ cuéntá ye̱he̱ va. Ta ndicáhnu ndiva̱ha mí i̱ sa̱há ña̱ cája na. ");
INSERT INTO mksNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ʼA̱ cóo ga̱ i̱ ñuyíví yóho jáchi̱ sa̱a̱ i̱ nu̱ íin mé ndó. Joo na̱ na̱ca̱xi ndó yóho canduu tóo na ñuyíví yóho. Tátá Ndióxi̱, yi̱i̱ ndiva̱ha cúú mé ndó. Xíca̱ ta̱hví i̱ nu̱ ndó ña̱ ná candaa va̱ha ndó na̱ cúú cuéntá mé ndó jáchi̱ xi̱hi̱n ndée̱ mé ndó cuu candi̱co̱ na̱ íchi̱ cuéntá mé ndó. Já quéa̱ in ná nduu ndihi na tá quia̱hva in cúú mé ndó xi̱hín ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jáchi̱ nani íin i̱ xi̱hi̱n ná ñuyíví yóho ndáá i̱ na̱ xi̱hi̱n ndée̱ mé ndó. Ta ni in túhún toho táhan na̱ na̱sa̱ha̱n ndó nu̱ú i̱ cacomí i̱ cuéntá sa̱ha̱ cán co̱ó na̱ndihi sa̱ha̱. In túhún da̱ na̱ndihi sa̱ha̱ cúú da̱ ja̱nda̱ sa̱nahá na̱sahi̱in sa̱ha̱ ña̱ ndihi sa̱ha̱ dá já ná cuu xi̱nu̱ co̱o nu̱ú ña̱ na̱ca̱hyi̱ nu̱ú tu̱hun Ndióxi̱ sa̱nahá. ");
INSERT INTO mksNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ʼTa viti quee e̱ ñuyíví yóho sa̱a̱ i̱ nu̱ íin ndó ja̱n. Joo cáha̱n i̱ ña̱ yóho xi̱hi̱n ndó nani íin i̱ ñuyíví yóho já ná ndicutú nda̱a̱ ini na̱ yóho xi̱hín ña̱ cáji̱i̱ íní na̱ tá quia̱hva cáji̱i̱ íní mí i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Sa̱ na̱ca̱xi tu̱hun i̱ tu̱hun mé ndó nu̱ ná. Joo na̱ cúú cuéntá ñuyíví cándají na̱ na̱ cúú cuéntá mí i̱ jáchi̱ co̱ cúú ná cuéntá ñuyíví yóho tá quia̱hva co̱ cúú toho ye̱he̱ cuéntá ñuyíví yóho. ");
INSERT INTO mksNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Co̱ xíca̱ ta̱hví i̱ nu̱ ndo̱ ña̱ ná tavá ndo̱ na̱ ñuyíví yóho. Ña̱ cúni̱ quéa̱ ná chindeé ndó na̱ já ná a̱ quée va̱ha tiñáhá sa̱cua̱ha̱ xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tá quia̱hva co̱ cúú toho i̱ da̱ cuéntá ñuyíví yóho quia̱hva já co̱ cúú ga̱ na̱ cán ña̱yivi cuéntá ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ta xíca̱ ta̱hví i̱ nu̱ ndó ña̱ ná ndaja vií ndó na̱ xi̱hín tu̱hun mé ndó ña̱ jána̱ha̱ ndó nu̱ ná jáchi̱ tu̱hun mé ndó cúú ña̱ nda̱a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ta tá quia̱hva na̱caja ndó na̱chindahá ndó ye̱he̱ tañu na̱ ñuyíví yóho quia̱hva já chíndahá ri ye̱he̱ va na̱ cúú cuéntá mí i̱ tañu ña̱yivi cuéntá ñuyíví. ");
INSERT INTO mksNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ta ndíquia̱hva i̱ mí i̱ caja i̱ ña̱ cúni̱ mé ndó já quéa̱ ná cuu ndiquia̱hva na̱ yóho mé ná ndáha̱ mé ndó sa̱há ña̱ sa̱ xíni̱ na̱ ña̱ nda̱a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ʼTa a̱ ju̱ú sa̱há na̱ yóho cuití va xíca̱ ta̱hví i̱ nu̱ ndo̱, va̱ha. Xíca̱ ta̱hví ri nu̱ ndó sa̱há na̱ ná candúsa ye̱he̱ chága̱ chí nu̱u̱ sa̱há tu̱hun ca̱ha̱n mé na̱ yóho xi̱hi̱n ná. ");
INSERT INTO mksNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tátá Ndióxi̱, xíca̱ ta̱hví i̱ nu̱ ndó ña̱ ná caja ndó ña̱ in ná nduu tócó ndihi na̱ cúú cuéntá mé ndó yóho. Ta caja ndó ña̱ in ná nduu ndihi na xi̱hi̱n yó tá quia̱hva in cúú ndó xi̱hín ye̱he̱ ta in cúú ye̱he̱ xi̱hi̱n mé ndó. Jáchi̱ tá ná caja ndó ña̱ in ná nduu tócó ndihi na já cuu candúsa ña̱yivi cuéntá ñuyíví ña̱ mé a̱ nda̱a̱ na̱chindahá ndó ye̱he̱ va̱xi i̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na̱caja i̱ ña̱ na̱ndicáhnu na̱ cán tá quia̱hva na̱ndaja cáhnu ndó ye̱he̱. Já quéa̱ in ná nduu ndihi na tá quia̱hva in cúú mé ndó xi̱hín ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ta in cúú ye̱he̱ xi̱hi̱n ná tá quia̱hva in cúú mé ndó xi̱hín i̱ já ná xi̱nu̱ co̱o ndihi na cacuu na tátu̱hun in víxí ña̱yivi. Ta já ná cuni ña̱yivi cuéntá ñuyíví ña̱ mé a̱ nda̱a̱ na̱chindahá ndó ye̱he̱ va̱xi i̱. Ta já ná cuni na ña̱ quíhvi̱ ini ndó na̱ tá quia̱hva quíhvi̱ ini ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ʼTátá Ndióxi̱, na̱caja ndó ña̱ cómí i̱ cuéntá sa̱há na̱ yóho. Ta cúni̱ ña̱ ná coo na xi̱hín i̱ nu̱ú coo i̱ já ná cuni na ndá quia̱hva cáhnu cúú u̱ jáchi̱ na̱caja ndó ña̱ ná ndicáhnu ndiva̱ha i̱. Jáchi̱ ja̱nda̱ tá cama̱ní ca̱va̱ sáhá sa̱ha̱ ñuyíví quíhvi̱ ini ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tátá Ndióxi̱, cája ndó ña̱ nda̱a̱. Ta ña̱yivi cuéntá ñuyíví yóho co̱ xíni̱ toho na ndo̱hó. Joo ye̱he̱ xíni̱ va̱ha i̱ ndo̱hó ta na̱ cúú cuéntá mí i̱ yóho sa̱ cánda̱a̱ va̱ha ini na ña̱ na̱chindahá ndó ye̱he̱. ");
INSERT INTO mksNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Sa̱ na̱caja i̱ ña̱ ná canda̱a̱ ini na yo cúú mé ndó ta cája i̱ ña̱ ná canda̱a̱ chága̱ ini na sa̱ha̱ ndo̱. Ta xi̱hín ña̱ yóho canda̱a̱ ini na ña̱ quíhvi̱ ini ndó na̱ tá quia̱hva quíhvi̱ ini ndó ye̱he̱ ta já in ná nduu na xi̱hín i̱ —na̱cachi Jesús xíca̱ ta̱hví a̱ nu̱ Ndióxi̱. ");
INSERT INTO mksNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tá na̱ndihi na̱xi̱ca̱ ta̱hví Jesús nu̱ Ndióxi̱ já na̱queta mé á xi̱hín na̱ xíca tuun xi̱hín a̱ cán cua̱ha̱n chí inga xoo yívi̱ naní Cedrón. Ta yati cán cáa cua̱ha̱ yitó cui̱hi nu̱ú na̱qui̱hvi Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á. ");
INSERT INTO mksNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ta Judas Iscariote, mé da̱ jícó túhún ñahá cán sa̱ xíni̱ va̱ha da nu̱ sáhi̱in Jesús xi̱hín na̱ xíca tuun xi̱hi̱n á jáchi̱ cua̱há tañu na̱nditútú ndihi na̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ña̱ cán quéa̱ ndáca da in táhndá soldado ta ndáca da java policía, na̱ ndáá veñu̱hu cáhnu ñuu Jerusalén cán. Cúú ná na̱ na̱chindahá na̱ sa̱cua̱ha̱ nu̱ú ju̱tu̱ xi̱hín na̱ fariseo. Ta ja̱ndá joho ñéhe na ña̱ha ná cani na a̱ cua̱ha̱n na̱ ta ñéhe ri na ití yúsá jándiyéhe̱ na̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Joo sa̱ xíni̱ va̱ha Jesús ndía̱ ndítahan ndoho a sa̱há ña̱ cán quéa̱ na̱queta nu̱ ná já na̱nda̱ca̱ tu̱hún a̱ na̱ já na̱cachi a já xi̱hi̱n ná: —Yo ndínducú ndo̱ já —na̱cachi a. ");
INSERT INTO mksNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Já na̱nducú ñehe na̱ cán tu̱hun nu̱ á já na̱cachi na já xi̱hi̱n á: —Ndínducú nde̱ Jesús, da̱ ñuu Nazaret —na̱cachi na. —Ye̱he̱ cúú u̱ da̱ ndínducú ndo̱ —na̱cachi a. Ta tañu na̱ cán ndáca̱a̱n ri Judas, da̱ na̱ji̱có túhún ñahá cán. ");
INSERT INTO mksNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tá na̱cachi Jesús: “Ye̱he̱ cúú u̱ da̱ ndínducú ndo̱”, já na̱xi̱ca játá na̱ ta na̱cu̱yu na nu̱ ñúhu̱. ");
INSERT INTO mksNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Já na̱nda̱ca̱ tu̱hún tucu Jesús na̱ já na̱cachi a já xi̱hi̱n ná: —Yo ndínducú ndo̱ já —na̱cachi a. Já na̱nducú ñehe na̱ cán tu̱hun nu̱ á já na̱cachi na já xi̱hi̱n á: —Jesús, da̱ ñuu Nazaret ndínducú nde̱ —na̱cachi na. ");
INSERT INTO mksNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","A̱nda̱ já na̱cachi tucu Jesús já xi̱hi̱n ná: —Sa̱ na̱cachi vi̱ xi̱hi̱n ndo̱ ña̱ ye̱he̱ cúú u̱ da̱ ndínducú ndo̱. Sa̱há ña̱ cán quéa̱ quia̱hva ndó ña̱ma̱ni̱ nu̱ú na̱ yóho ña̱ ná quee na cu̱hu̱n na̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Na̱cachi Jesús ña̱ yóho já ná a̱ tíin na na̱ xíca tuun xi̱hín a̱ cán já ná xi̱nu̱ co̱o nu̱ú tu̱hun ña̱ na̱cachi mé á tá na̱xi̱ca̱ ta̱hví a̱ nu̱ Ndióxi̱ tá na̱cachi a já: “Tátá Ndióxi̱, ni in túhún toho táhan na̱ na̱sa̱ha̱n ndó nu̱ú i̱ co̱ó na̱ndihi sa̱ha̱ jáchi̱ na̱sandaa va̱ha i̱ na̱.” ");
INSERT INTO mksNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ta ndaja coo na̱sañee in machítí nu̱ tóco̱ Simón Pedro. Já na̱tuhun da ña̱ ta na̱chitúhu̱n dá jo̱ho cuáha in da̱ naní Malco, da̱ cúú mozo nu̱ú da̱ cúú sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱. ");
INSERT INTO mksNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n Pedro: —Chica̱a̱n va̱ha machítí ja̱n. Jáchi̱ sa̱ na̱sacu ini Ndióxi̱, tátá i̱ ndoho ini i̱ tócó ndihi ña̱ va̱xi nu̱ú i̱ ta íin tia̱hva i̱ ndoho ini i̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tócó ndihi soldado cán xi̱hín da̱ sáhndá chuun nu̱ dá xi̱hín java na̱ ndáá veñu̱hu cán na̱tiin na Jesús ta na̱cató na̱ a̱. ");
INSERT INTO mksNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jihna ñúhú ñéhe na a̱ na̱sa̱ha̱n na̱ nu̱ Anás, da̱ cúú xo̱jo Caifás, da̱ sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ mé cui̱a̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mé Caifás yóho cúú dá da̱ na̱cachi xi̱hín na̱ Israel ña̱ va̱ha chága̱ ña̱ ná quivi in ta̱a nu̱ ndíhi ña̱yivi já ná a̱ ndíhi sa̱ha̱ tócó ndihi ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ta ndaja coo Simón Pedro xi̱hín inga táhan da̱ xíca tuun xi̱hín Jesús cán ndíco̱ na̱ ja̱tá nu̱ ñéhe na a̱ cua̱ha̱n na̱. Ta da̱ inga cán xíni̱ táhan va̱ha da xi̱hín da̱ sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ ña̱ cán quéa̱ na̱ñe̱he̱ dá ña̱ma̱ní ndi̱hvi da xi̱hín Jesús yuyéhé vehe ju̱tu̱ cán. ");
INSERT INTO mksNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Joo na̱cando̱o Pedro ja̱ta̱ véhe yati yéhé cán. Joo da̱ inga cán na̱ndicó co̱o da já na̱xi̱ca̱ da̱ ña̱ma̱ni̱ nu̱ ñá ndáá yéhé vehe ju̱tu̱ cán ña̱ ná quia̱hva ñá ña̱ma̱ni̱ nu̱ Pedro qui̱hvi da. Sa̱há ña̱ cán na̱qui̱hvi Pedro chí yuyéhé vehe cán. ");
INSERT INTO mksNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ta mé ñá ndáá yéhé cán na̱nda̱ca̱ tu̱hún ña̱ Pedro já na̱cachi ñá já xi̱hi̱n dá: —Á a̱ ju̱ú in táhan da̱ xíca tuun xi̱hín Jesús cúú yóhó —na̱cachi ñá. A̱nda̱ já na̱cachi Pedro já xi̱hi̱n ña̱: —Co̱ cúú toho i̱ in táhan da̱ xíca tuun xi̱hi̱n á —na̱cachi Pedro. ");
INSERT INTO mksNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ta mé ñuú cán vi̱xi xíní na̱ cúú mozo xi̱hín na̱ ndáá veñu̱hu cán. Sa̱há ña̱ cán quéa̱ na̱ndicahmi na ñúhu̱ ta na̱nda̱ca̱ nduu na xítúní na̱ ta tañu na̱ cán cándichi ri Pedro xítúní da̱. ");
INSERT INTO mksNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tá na̱ndihi já na̱casáhá da̱ sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán ndája ndi̱chi̱ da̱ Jesús já na̱nda̱ca̱ tu̱hún da̱ mé á sa̱há na̱ na̱xi̱ca tuun xi̱hi̱n á. Ta na̱nda̱ca̱ tu̱hún da̱ mé á sa̱há ña̱ na̱jána̱ha̱ nu̱ú ña̱yivi. ");
INSERT INTO mksNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Co̱ó na̱ca̱ha̱n je̱hé toho i̱ xi̱hín ña̱yivi tá na̱jána̱ha̱ i̱ nu̱ ná. Níí tiempo na̱jána̱ha̱ i̱ tu̱hun Ndióxi̱ nu̱ ná ini veñu̱hu ta quia̱hva já na̱jána̱ha̱ i̱ nu̱ ná nu̱ tácá na̱ ini veñu̱hu cáhnu ñuu Jerusalén. Ta ni in túhún toho ña̱ha co̱ó na̱jána̱ha̱ je̱hé e̱ nu̱ ná. ");
INSERT INTO mksNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ta viti cachi ndó xi̱hín i̱ ndá cuéntá quéa̱ ndáca̱ tu̱hún ndó ye̱he̱ sa̱há ña̱ yóho. Cuáhán ndó nda̱ca̱ tu̱hún ndo̱ ña̱yivi, na̱ na̱jána̱ha̱ i̱ nu̱ cán já ná ndicani na̱ cán nu̱ ndo̱ ndaja cáa ña̱ na̱jána̱ha̱ i̱ nu̱ ná. Jáchi̱ xíni̱ va̱ha na ña̱ na̱ca̱ha̱n i̱ xi̱hi̱n ná —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tá na̱cachi Jesús ña̱ yóho já na̱cani in da̱ ndáá veñu̱hu cán ja̱hndá nu̱u̱ á já na̱cachi da já xi̱hi̱n á: —A̱ váha toho ndiñehe yúhu̱n nu̱ú da̱ sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","A̱nda̱ já na̱cachi Jesús já xi̱hi̱n dá: —Tá co̱ váha ná caja i̱, ca̱ha̱n xi̱hín i̱ ndá cúú ña̱ co̱ó na̱caja va̱ha i̱. Joo tá na̱caja va̱ha i̱ ndá cuéntá quéa̱ cánún ye̱he̱ —na̱cachi Jesús. ");
INSERT INTO mksNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tá na̱ndihi já na̱sa̱ñehe na Jesús nu̱ú Caifás, da̱ sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán ta sa̱ já ndíco̱ a̱ xi̱hi̱n yóho̱ ñéhe na a̱ cua̱ha̱n na̱. ");
INSERT INTO mksNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ta ndaja coo íin coo yi̱i̱ Pedro xítúní da̱ xi̱hín java na̱ ndúu cán. Ta já na̱casáhá na̱ cán ndáca̱ tu̱hún na̱ da̱ já na̱cachi na já xi̱hi̱n dá: —Á a̱ ju̱ú táhan da̱ xíca tuun xi̱hín Jesús cúú yóhó —na̱cachi na. Joo na̱chije̱hé tu̱hun Pedro ña̱ xíni̱ da̱ Jesús já na̱cachi da já: —Co̱ cúú toho i̱ in táhan da̱ xíca tuun xi̱hi̱n á —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Joo tá na̱ndihi já na̱nda̱ca̱ tu̱hún in da̱ cúú mozo nu̱ú da̱ sa̱cua̱ha̱ chága̱ nu̱ ndíhi ju̱tu̱ cán, da̱ cúú in táhan da̱ na̱chitúhu̱n Pedro jo̱ho. Ta na̱cachi da já xi̱hi̱n Pedro: —Cája i̱ cuéntá na̱xini i̱ yo̱hó nu̱ cáa cua̱ha̱ yitó cui̱hi nu̱ú na̱tiin na Jesús cán —na̱cachi da. ");
INSERT INTO mksNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Joo na̱chije̱hé tu̱hun tucu Pedro ña̱ xíni̱ da̱ Jesús ta i̱vi̱ la̱á na̱cana chéle tá quia̱hva na̱cachi Jesús xi̱hi̱n dá coo. ");
INSERT INTO mksNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ta tá na̱ti̱vi yaa já na̱tavá na̱ Jesús vehe Caifás cán já ñéhe na a̱ cua̱ha̱n na̱ vechúun nu̱ ndáca̱a̱n da̱ cúú gobernador cuéntá ñuu Roma. Joo mé na̱ Israel co̱ó na̱xeen na ndi̱hvi na vechúun cán jáchi̱ cáchí ley na̱ ña̱ tá ná ndi̱hvi na vehe na̱ tóho̱ já cuu yu̱xu̱ na̱ ta já a̱ cúu cajíni na vicó pascua ña̱ coo qui̱ví ita̱a̱n. ");
INSERT INTO mksNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sa̱há ña̱ cán quéa̱ na̱queta Pilato, da̱ cúú gobernador ja̱ta̱ véhe ca̱ha̱n da̱ xi̱hín na̱ Israel já na̱cachi da já: —Ndá cua̱chi na̱caja da̱ yóho —na̱cachi Pilato. ");
INSERT INTO mk