﻿USE sofia;
DROP TABLE IF EXISTS sofia.mkn_vpl;
CREATE TABLE mkn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mkn_vpl WRITE;
INSERT INTO mkn_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mula-mula Tuhan Allah bekin langit deng bumi. ");
INSERT INTO mkn_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Itu waktu, bumi balóm jadi, deng samua masi harba-biruk. Yang ada, aer. Deng galáp gulita tutu ame sang dia. Tuhan pung Roh ada bajalan di atas itu aer. ");
INSERT INTO mkn_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ais Tuhan Allah omong bilang, “Musti ada taráng.” Omong abis bagitu ju, taráng ada. ");
INSERT INTO mkn_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Lia itu taráng, ju Dia pung hati sanáng, tagal apa yang Dia su bekin tu, memang bae. Ais Dia kasi pisa itu taráng dari galáp, ko satu-satu ada pung waktu sandiri. ");
INSERT INTO mkn_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Dia kasi nama taráng tu, ‘siang’, deng galáp tu, ‘malam’. Itu hari partama. ");
INSERT INTO mkn_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Ais Tuhan Allah omong lai bilang, “Musti ada tampa kosong ko kasi pisa aer. Andia ko ada aer di bagian atas, deng ada aer di bagian bawa.” Omong abis bagitu ju, itu aer tabagi dua. ");
INSERT INTO mkn_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ais Dia kasi nama tampa kosong di bagian atas tu, ‘langit’. Itu hari kadua. ");
INSERT INTO mkn_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ais Tuhan Allah omong lai bilang, “Aer di bagian bawa tu musti takumpul di satu tampa, ko biar ada tana karíng.” Omong abis bagitu ju, tana karíng ada. ");
INSERT INTO mkn_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ais tana karíng tu, Dia kasi nama ‘darat’; deng aer yang takumpul tu, Dia kasi nama ‘laut’. Lia itu samua, ju Dia pung hati sanáng, tagal apa yang Dia su bekin tu, memang bae. ");
INSERT INTO mkn_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ais Tuhan Allah omong lai bilang, “Darat musti kasi kaluar tanaman. Musti ada tanaman yang babua, yang babiji, deng yang badaon ijo. Biar ko satu-satu tanaman kasi kaluar dia pung hasil iko dia pung macam.” Omong abis bagitu ju, samua tanaman jadi. ");
INSERT INTO mkn_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Di darat, tanaman dong kasi kaluar dong pung hasil iko satu-satu pung macam. Lia itu samua, ju Dia pung hati sanáng, tagal apa yang Dia su bekin tu, memang bae. ");
INSERT INTO mkn_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Itu hari katiga. ");
INSERT INTO mkn_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Ais Tuhan Allah omong lai bilang, “Di bagian atas tu, musti ada macam-macam barang taráng ko bekin taráng ini bumi. Musti ada yang kasi taráng waktu siang, deng musti ada laen yang kasi taráng waktu malam. Dong samua jadi tanda ko biar bisa itong hari, taon, deng musim.” Omong abis bagitu ju, samua barang taráng ada. ");
INSERT INTO mkn_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dia bekin dua macam barang taráng yang bésar. Yang lebe bésar, kasi taráng waktu siang; yang lebe kici, kasi taráng waktu malam. Dia ju bekin bintang dong. ");
INSERT INTO mkn_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dia ator itu barang dong di langit, ko dong senter kasi taráng bumi. ");
INSERT INTO mkn_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ais dong kasi taráng waktu siang, deng kasi taráng waktu malam. Deng bagitu, dong kasi pisa taráng dari galáp. Lia itu samua, ju Dia pung hati sanáng, tagal apa yang Dia su bekin tu, memang bae. ");
INSERT INTO mkn_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Itu hari kaꞌampa. ");
INSERT INTO mkn_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ais Tuhan Allah omong lai bilang, “Musti ada macam-macam binatang yang idop dalam aer. Deng musti ada macam-macam burung yang tarbáng di atas bumi.” ");
INSERT INTO mkn_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ais Dia bekin samua macam ikan deng binatang bésar yang idop di aer. Dia ju bekin samua macam burung yang tarbáng di langit. Lia itu samua, ju Dia pung hati sanáng, tagal apa yang Dia su bekin tu, memang bae. ");
INSERT INTO mkn_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ais Dia omong kasi berkat sang itu binatang dong samua bilang, “Ikan dong musti tamba banya, ko bekin ponu aer di mana-mana. Deng burung dong ju musti tamba banya.” ");
INSERT INTO mkn_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Itu hari kalima. ");
INSERT INTO mkn_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Ais Tuhan Allah omong lai bilang, “Musti ada macam-macam binatang yang idop di darat. Andia binatang piara, binatang liar, deng binatang marayap di tana, satu-satu deng dia pung macam.” Omong abis bagitu ju, samua binatang ada. Lia itu samua, ju Dia pung hati sanáng, tagal apa yang Dia su bekin tu, memang bae. ");
INSERT INTO mkn_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ais Tuhan Allah omong lai bilang, “Mari ko Kotong bekin manusia iko Kotong pung model. Biar dong urus deng ator samua ikan di laut, samua burung di langit, samua binatang piara, deng samua binatang laen dong yang idop di bumi.” ");
INSERT INTO mkn_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ju Dia bekin manusia iko Dia pung model. Dia bekin sang dong, laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ju Dia omong kasi berkat sang dong bilang, “Bosong musti barana tamba bam-banya, ko bekin ponu deng ator ini dunya. Beta ju kasi hak sang bosong ko urus ikan-ikan, burung-burung, deng samua binatang di darat. ");
INSERT INTO mkn_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Dengar bae-bae! Beta kasi sang bosong makanan macam-macam di ini dunya. Andia: tanaman yang babua, yang babiji, deng yang badaon ijo. ");
INSERT INTO mkn_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Beta ju kasi samua macam tanaman, ko jadi samua macam binatang pung makanan. Ada makanan buat binatang piara, binatang liar, binatang marayap, deng burung-burung dong.” Omong abis bagitu ju, samua macam makanan ada. ");
INSERT INTO mkn_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Lia itu samua, ju Dia pung hati sanáng, tagal apa yang Dia su bekin tu, memang talalu bae. Itu hari kaꞌanam. ");
INSERT INTO mkn_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Deng bagitu, Tuhan Allah bekin ame langit deng bumi, deng dia pung isi dong samua. ");
INSERT INTO mkn_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Dia karjá abis samua, ju dia pung beso, pas deng hari katuju, Dia barenti. ");
INSERT INTO mkn_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Deng bagitu, Dia bekin hari katuju jadi hari bésar dari hari-hari laen dong. Dia ator bagitu, tagal Dia su bekin abis Dia pung karjá, ais di hari katuju Dia istirahat. ");
INSERT INTO mkn_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Tuhan Allah bekin langit deng bumi pung carita, andia bagitu. ");
INSERT INTO mkn_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","Waktu TUHAN Allah baru mulai bekin langit deng bumi tu, ");
INSERT INTO mkn_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","balóm ada tanaman apa-apa, tagal Dia balóm kasi turun ujan. Itu waktu, yang ada cuma kabut yang nae dari tana ko bekin basa bumi. Deng balóm ada manusia yang bekin kabón. ");
INSERT INTO mkn_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ais ju TUHAN Allah ame tana sadiki, ko bekin ame jadi manusia. Ais Dia fuu kasi maso napas pi dalam dia pung lobang idong, ju itu manusia idop memang. ");
INSERT INTO mkn_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ais itu, TUHAN Allah buka ame satu kabón di tana Eden, di sablá matahari nae. Ju Dia kasi itu manusia ko tenga di itu kabón. ");
INSERT INTO mkn_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Dalam itu kabón, Dia su kasi idop macam-macam pohon yang bagus, deng pohon yang orang bisa makan deng enak. Dia ju kasi idop dua macam pohon di itu kabón pung teng-tenga. Kalo orang makan dari pohon yang satu pung bua, dia dapa idop tarús. Ma kalo orang makan dari pohon yang satu lai pung bua, dia bisa tau mana yang bae deng mana yang jahat. ");
INSERT INTO mkn_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ada kali satu di situ, yang malele kaluar dari itu kabón. Itu kali bacabang ampa. ");
INSERT INTO mkn_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Dia pung cabang partama, nama Pison. Itu cabang bataputar kuliling tana Hawila, yang ada banya mas. ");
INSERT INTO mkn_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Di situ ada mas barisi, ada pohon yang dia pung dara wangi, deng ada batu mangkilat. ");
INSERT INTO mkn_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Itu kali pung cabang kadua, nama Gihon. Itu cabang bataputar kuliling tana Kus. ");
INSERT INTO mkn_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Dia pung cabang katiga, nama Tigris. Ini cabang ni jadi batas di tana Asyur pung sablá matahari nae. Dia pung cabang kaꞌampa, nama Efrat. ");
INSERT INTO mkn_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","TUHAN Allah kasi itu manusia tenga di Eden, ko dia urus bae-bae itu kabón. ");
INSERT INTO mkn_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ju Dia parenta sang itu manusia bilang, “Lu bole makan bua apa sa dari samua pohon di ini kabón. ");
INSERT INTO mkn_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ma ada satu yang lu sonde bole makan. Andia, itu pohon yang kasi tau mana yang bae deng mana yang jahat. Kalo lu makan, lu pasti mati.” ");
INSERT INTO mkn_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ais TUHAN Allah omong lai bilang, “Sonde bae kalo ini manusia idop sandiri. Jadi Beta mau bekin kasi dia, satu tamán yang pas deng dia.” ");
INSERT INTO mkn_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Itu waktu, TUHAN Allah ame tana, ko bekin ame macam-macam binatang deng burung. Ais Dia antar bawa itu binatang deng burung dong pi di itu orang, ko biar dia kasi nama sang dong. Tarús, itu orang kasi nama itu binatang deng burung dong, satu-satu deng dia pung nama. Ma dia sandiri balóm dapa satu tamán yang pas deng dia. ");
INSERT INTO mkn_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ais itu, TUHAN Allah bekin itu orang ko tidor sonu. Waktu dia ada tidor, Tuhan ame dia pung tulang rebis satu, ais tutu kambali itu luka. ");
INSERT INTO mkn_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Dari itu tulang tu, Dia bekin jadi parampuan. Ais Dia sarakan itu parampuan pi itu orang. ");
INSERT INTO mkn_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Lia itu parampuan, ju itu orang bilang, “Naaa! Ini dolo! Ini baru pas deng beta! Dia pung tulang sama deng beta pung tulang. Deng dia pung daging ju sama deng beta pung daging. Tagal dia jadi dari laki-laki, andia ko beta kasi nama sang dia ‘parampuan’.” ");
INSERT INTO mkn_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tagal itu, laki-laki musti kasi tenga dia pung papa deng dia pung mama, ko pi idop satu hati deng dia pung bini, te dong dua su taꞌika jadi satu. ");
INSERT INTO mkn_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Itu waktu, dong dua ada talanjang bulat, ma dong sonde ada rasa malu sadiki ju. ");
INSERT INTO mkn_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Dari samua binatang yang TUHAN Allah su bekin di ini dunya, ular yang paling pintar putar-balek. Satu kali, ada ular yang tanya sang itu parampuan bilang, “Batúl, ko? Tuhan Allah ada larang bilang, ‘Bosong sonde bole makan bua dari pohon-pohon di ini kabón, wuang?’ ” ");
INSERT INTO mkn_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Itu parampuan balas bilang, “Sonde! Botong bole makan! Ma ada satu pohon di tenga kabón sa, yang Tuhan Allah larang botong makan. Dia bilang botong sonde bole makan, deng sonde bole sonto dia pung bua, te nanti botong mati.” ");
INSERT INTO mkn_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ma itu ular manyao bilang, “We, itu sonde batúl! Bosong sonde mati! ");
INSERT INTO mkn_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Tuhan Allah memang larang bagitu, tagal Dia su tau kalo bosong makan itu bua, bosong jadi pintar sama ke Dia. Andia, tau mana yang bae, deng mana yang jahat.” ");
INSERT INTO mkn_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ais, itu parampuan lia te itu pohon pung bagus lai, deng dia pung bua tingka ke enak sakali. Ju dia pikir bilang, “Kalo beta makan ini bua, tantu beta jadi pintar.” Ais dia ketu itu bua, ju dia makan. Ais dia bawa kasi dia pung laki, ju dia pung laki iko makan. ");
INSERT INTO mkn_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Makan abis ju, baru dong tau bilang, dong dua ada talanjang bulat. Andia ko dong natok daon ko tutu dong pung talanjang. ");
INSERT INTO mkn_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Dia pung sore, dong dengar TUHAN Allah ada bajalan di itu kabón. Ais dong pi sambunyi di balakang pohon, ko biar TUHAN sonde dapa lia sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ma TUHAN Allah pange itu laki-laki bilang, “We, Adam! Lu ada di mana?” ");
INSERT INTO mkn_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Itu laki-laki manyao bilang, “Beta ada dengar Tuhan pung suara di sini. Ma beta malu, te beta ada talanjang. Andia ko beta lari sambunyi.” ");
INSERT INTO mkn_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ais Tuhan bilang, “Sapa yang kasi tau kalo lu ada talanjang? Karmana? Tantu lu su makan itu bua yang beta larang, wuang?” ");
INSERT INTO mkn_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Dia manyao bilang, “Ini parampuan yang Tuhan kasi ko batamán deng beta tu, dia yang kasi itu bua ko beta makan!” ");
INSERT INTO mkn_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ais ju TUHAN Allah omong deng itu parampuan bilang, “Akurang ko lu bekin bagitu?” Ju itu parampuan manyao bilang, “Ko ular tipu ame sang beta na! Andia ko beta makan itu bua, suda ma.” ");
INSERT INTO mkn_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ais itu, ju TUHAN Allah kasi kutuk itu ular bilang, “Tagal lu pung bekin ni, Beta kasi hukum sang lu. Dari samua binatang yang laen, cuma lu sandiri yang kaná kutuk bagini. Mulai sakarang sampe lu mati, lu cuma tau marayap deng dada sa, deng lu tau makan di tana sa. ");
INSERT INTO mkn_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Beta bekin lu deng ini parampuan bamusu tarús. Deng bosong dua pung turunan dong, ju bagitu. Lu pung turunan nanti gigi ame orang pung tumit. Ma dia pung turunan satu, nanti titi bekin ancor lu pung kapala.” ");
INSERT INTO mkn_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ais itu, Tuhan Allah kasi tau itu parampuan bilang, “Nanti Beta tamba lu pung susa waktu dudu parú, deng tamba saki waktu lu barana. Biar bagitu, ma lu ju masi rindu tarús sang lu pung laki. Deng dia yang ator sang lu.” ");
INSERT INTO mkn_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ais Tuhan kasi tau itu laki-laki bilang, “Lu sonde iko Beta pung parenta, ma iko lu pung bini pung mau, sampe lu makan itu bua yang Beta su larang tu. Andia ko lu ju kaná hukum. Deng tana kaná hukum ju. Mulai sakarang sampe lu mati, lu musti karjá banting tulang bale tana, ko lu bisa dapa makan. Deng karjá bagitu, baru lu dapa idop. ");
INSERT INTO mkn_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Biar lu tanam macam-macam, ma tana cuma kasi kaluar duri deng onak sa. ");
INSERT INTO mkn_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ais lu musti karjá banting tulang, baru tana kasi lu makan. Lu musti karjá parés karingat bagitu sampe mati. Beta bekin ame sang lu dari tana. Jadi kalo lu mati, lu kambali pi jadi tana lai.” ");
INSERT INTO mkn_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ais itu, Adam kasi nama dia pung bini ‘Hawa’ (yang dia pung arti ‘yang idop’), te dia tu, samua orang yang idop pung mama. ");
INSERT INTO mkn_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ais TUHAN Allah bekin pakean dari binatang pung kulit, ko kasi dong dua pake. ");
INSERT INTO mkn_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ais TUHAN Allah omong bilang, “Sakarang, ini orang dong su tau mana yang bae, deng mana yang jahat, sama ke Kotong. Jang sampe dong ju makan bua dari itu pohon yang kasi dong idop tarús.” ");
INSERT INTO mkn_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ais ju Dia usir kasi kaluar sang dong dari itu kabón di Eden, ko dong pi tampa laen, idop deng bale tana, ko dong idop dari tana pung hasil. ");
INSERT INTO mkn_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Usir abis, ju Tuhan suru Dia pung ana bua basayap dari sorga dong, ko pi jaga di itu kabón pung sablá matahari nae. Dong pegang kalewang yang taꞌayun pi-datang, yang manyala sama ke api. Tuhan suru dong tutu jalan maso, te Dia sonde mau orang dong ketu ame itu bua yang kasi dong idop tarús. ");
INSERT INTO mkn_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ais Adam pi tidor deng dia pung bini Hawa. Ju itu parampuan dudu parú. Ais ju dia barana satu ana laki-laki. Ju dia bilang, “Beta su barana kasi kaluar satu ana laki-laki, tagal TUHAN su tolong sang beta.” Ais dia kasi nama itu ana, Kaen (yang dia pung arti ‘kasi kaluar’). ");
INSERT INTO mkn_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ais Hawa barana lai satu ana laki-laki. Ju dia kasi nama Habel. Waktu dong dua bésar datang, Habel gambala binatang, deng Kaen karjá kabón. ");
INSERT INTO mkn_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Satu kali, Kaen bawa ame dia pung kabón pung hasil saparu, ko kasi sang TUHAN. ");
INSERT INTO mkn_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel ju bawa ame dia pung domba mai dong pung ana partama. Dia horo itu domba dong, ais dia bawa daging yang paling bae kasi sang Tuhan. Lia bagitu, TUHAN pung hati sanáng sang Habel deng dia pung korban tu. ");
INSERT INTO mkn_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ma Dia sonde suka sang Kaen deng dia pung korban tu. Ju Kaen mara mau mati, sampe dia pung muka asaráng. ");
INSERT INTO mkn_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ju TUHAN omong deng Kaen bilang, “He, Kaen! Akurang ko lu mara bagitu? Karmana ko lu pung muka asaráng bagitu? ");
INSERT INTO mkn_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kalo lu bekin bae, tantu Beta ju tarima bae sang lu. Ma ati-ati! Kalo lu bekin jahat, nanti itu jahat makan bale sang lu, sama ke kucing mau kobo tikus. Jadi, kalo lu ada kapingin bekin jahat, lebe bae lu tola buang memang!” ");
INSERT INTO mkn_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Satu kali, Kaen buju sang Habel bilang, “Adi! Mari ko kotong jalan-jalan pi kabón.” Waktu dong sampe di sana, takuju sa Kaen papoko bekin mati sang dia pung adi. ");
INSERT INTO mkn_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ais TUHAN tanya sang Kaen bilang, “He, Kaen! Lu pung adi ada di mana?” Kaen manyao bilang, “Beta sonde tau dia ada di mana! Kira beta ni, tukang pegang dia pung kaki, ko?” ");
INSERT INTO mkn_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ju Tuhan omong bilang, “Akurang ko lu bekin jahat bagitu? Jang kira ko lu bisa sambunyi lu pung adi pung dara di tana, te Beta su lia samua! ");
INSERT INTO mkn_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sakarang kutuk su nae kaná sang lu. Te waktu lu bunu lu pung adi, tana isap ame dia pung dara. Jadi sakarang itu tana su sonde bisa kasi idop sang lu lai. ");
INSERT INTO mkn_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kalo lu bekin kabón, tana su sonde mau kasi lu hasil apa-apa lai. Mulai sakarang, lu maen tapaleuk pi-datang sama ke orang kasian yang cari idop di ini dunya.” ");
INSERT INTO mkn_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ma Kaen protes sang TUHAN bilang, “Awii! Tuhan, é! Karmana ko Tuhan kasi beta kutuk barát talalu, sampe beta su tar bisa pikol lai ni? ");
INSERT INTO mkn_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tagal Tuhan su usir sang beta dari ini tampa, beta nanti jao dari Tuhan. Beta maen tapaleuk pi mana-mana. Ais sapa sa yang nanti katumu sang beta, tantu dong bunu bekin mati sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ma TUHAN manyao bale bilang, “Sonde bagitu! Sapa yang bunu sang lu, Beta nanti hukum sang dia tuju kali lebe barát!” Ais TUHAN bekin tanda di Kaen, ko biar orang dapa tau kalo dong sonde bole bunu sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ais Kaen jalan kasi tenga itu tampa, ko pi jao-jao dari TUHAN. Dia jalan sampe di satu tampa di kabón Eden pung sablá matahari nae. Itu tampa pung nama Nod, yang pung arti bilang ‘Tapaleuk’. Ais ju dia tenga di situ. ");
INSERT INTO mkn_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ais itu, Kaen kawin, ju dia pung bini dudu parú. Ju dia barana satu ana laki-laki, yang dong kasi nama, Henok. Deng Kaen kasi bangun satu kampong. Ais dia kasi nama itu kampong, Henok, iko dia pung ana pung nama. ");
INSERT INTO mkn_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ais Henok pung ana, andia Irad. Irad pung ana, Mehuyael. Mehuyael pung ana, Metusael. Deng Metusael pung ana, Lamek. ");
INSERT INTO mkn_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek pung bini dua. Satu nama Ada, deng satu nama Sila. ");
INSERT INTO mkn_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada pung ana, nama Yabal. Dia pung turunan dong, jadi gambala. Dong idop bapinda-pinda deng tenga di tenda. ");
INSERT INTO mkn_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Dia pung adi, nama Yubal. Yubal pung turunan dong jadi tukang maen musik, pake suling deng alat musik kuti pake tali sanár. ");
INSERT INTO mkn_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek pung bini Sila barana sang Tubal Kaen. Dia pung turunan jadi tukang besi, ko dong bekin barang macam-macam dari besi deng tambaga. Tubal Kaen pung adi parampuan, nama Naꞌama. ");
INSERT INTO mkn_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Satu kali, Lamek angka-angka diri di muka dia pung bini dua-dua bilang, “Bosong dengar, é! Tadi ada satu nyong yang hantam sang beta, ma beta habok bekin mati sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Orang yang bunu sang Kaen, dapa hukuman tuju kali. Ma kalo ada yang mau balas dendam sang beta, dong dapa hukuman 77 kali.” ");
INSERT INTO mkn_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam pung bini Hawa barana satu ana laki-laki lai. Ju dong kasi nama itu ana, Set (yang dia pung arti ‘sorong kasi’), tagal Hawa bilang, “Tuhan Allah su sorong kasi beta ini ana ko ganti sang Habel, yang Kaen su bunu bekin mati tu.” ");
INSERT INTO mkn_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Lama-lama Set dapa satu ana laki-laki, nama Enos. Itu waktu, orang dong mulai sémba sang TUHAN Allah. ");
INSERT INTO mkn_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Waktu Allah bekin manusia, Dia bekin dong pung model, sama ke Dia pung diri sandiri. Dia bekin sang dong, laki-laki deng parampuan. Ais Dia pange sang dong “manusia”, deng Dia kasi berkat sang dong. Manusia partama pung nama, Adam. Ini ni, Adam pung turunan dong pung nama: ");
INSERT INTO mkn_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Waktu Adam su umur 130 taon, dia dapa satu ana laki-laki, dia pung model sama ke dia pung bapa. Ju dia kasi nama itu ana, Set. ");
INSERT INTO mkn_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ais itu, Adam masi idop lai 800 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Dia mati waktu dia pung umur su 930 taon. ");
INSERT INTO mkn_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Waktu Set umur 105 taon, ju dia dapa satu ana laki-laki, nama Enos. ");
INSERT INTO mkn_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ais Set masi idop lai 807 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Dia mati waktu dia pung umur su 912 taon. ");
INSERT INTO mkn_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Waktu Enos umur 90 taon, dia dapa satu ana laki-laki, nama Kenan. ");
INSERT INTO mkn_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ais itu, Enos masi idop lai 815 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Dia mati waktu dia pung umur su 905 taon. ");
INSERT INTO mkn_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Waktu Kenan umur 70 taon, dia dapa satu ana laki-laki, nama Mahalalel. ");
INSERT INTO mkn_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ais itu, Kenan masi idop lai 840 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Dia mati waktu dia pung umur su 910 taon. ");
INSERT INTO mkn_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Waktu Mahalalel umur 65 taon, dia dapa satu ana laki-laki, nama Yared. ");
INSERT INTO mkn_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ais itu, Mahalalel masi idop lai 830 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Dia mati waktu dia pung umur su 895 taon. ");
INSERT INTO mkn_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Waktu Yared umur 162 taon, dia dapa satu ana laki-laki, nama Henok. ");
INSERT INTO mkn_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ais itu, Yared masi idop lai 800 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Dia mati waktu dia pung umur su 962 taon. ");
INSERT INTO mkn_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Waktu Henok umur 65 taon, dia dapa ana laki-laki satu, nama Metusalak. ");
INSERT INTO mkn_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ais itu, Henok idop satu hati deng Tuhan Allah sampe 300 taon lai. Ju dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Dia idop satu hati tarús deng Tuhan Allah. Ais waktu dia pung umur 365 taon, ju dia ilang, tagal Tuhan Allah su angka nae sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Waktu Metusalak pung umur 187 taon, dia dapa satu ana laki-laki, nama Lamek. ");
INSERT INTO mkn_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ais itu, Metusalak masi idop lai 782 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Dia mati waktu dia pung umur su 969 taon. ");
INSERT INTO mkn_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Waktu Lamek umur 182 taon, dia dapa satu ana laki-laki. ");
INSERT INTO mkn_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek kasi nama itu ana, Noh (yang mirip satu kata yang dia pung arti ‘kasi hibur’), tagal dia bilang, “Ini ana nanti hibur bekin sanáng kotong pung hati dari kotong pung karjá satenga mati di ini tana yang Tuhan Allah su kutuk ame sang dia.” ");
INSERT INTO mkn_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ais itu, Lamek masi idop lai 595 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Dia mati waktu dia pung umur su 777 taon. ");
INSERT INTO mkn_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Waktu Noh pung umur su 500 taon, ju dia dapa tiga ana laki-laki, andia Sem, Yafet deng Ham. ");
INSERT INTO mkn_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Itu waktu, manusia su tamba banya. Ais dong su idop batasiram di mana-mana di ini dunya. Dong ju barana ame ana-ana parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Tuhan pung ana laki-laki dong dapa lia manusia pung ana nona dong manis-manis. Ju dong pi kawin ame deng nona-nona yang dong suka. ");
INSERT INTO mkn_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ais ju TUHAN bilang, “Beta su cape deng manusia pung idop yang harba-biruk. Beta pung Roh yang kasi idop sang dong tu, su sonde mau kasi tenga dong idop tarús lai. Dong musti mati. Jadi nanti dong cuma idop sampe 120 taon sa.” ");
INSERT INTO mkn_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Itu jaman, deng jaman baꞌiko-baꞌiko dong, su ada orang-orang raksasa di dunya. Waktu Tuhan pung ana laki-laki dong kawin ame manusia pung ana parampuan dong, ju dong barana ame orang-orang hebat, andia, kapala-kapala paráng, yang takanál dalam carita dolu-dolu. ");
INSERT INTO mkn_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Itu waktu, TUHAN lia manusia di dunya pung jahat su talalu. Dong pung hati cuma tau pikir jahat tarús sa. ");
INSERT INTO mkn_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ju TUHAN manyasal su bekin ame sang dong ko tenga di ini dunya. Itu bekin Dia pung hati saki mau mati. ");
INSERT INTO mkn_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Andia ko Dia omong bilang, “Deng bagitu, nanti Beta bekin ancor manusia, yang Beta su bekin ame di ini dunya. Burung-burung deng binatang laen dong, ju Beta bekin ancor samua. Te Beta manyasal su bekin sang dong.” ");
INSERT INTO mkn_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ma cuma Noh sa, yang bekin sanáng TUHAN pung hati. ");
INSERT INTO mkn_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noh pung carita bagini: dia pung ana laki-laki ada tiga orang, andia Sem, Yafet deng Ham. Noh tu, idop lurus deng sonde bekin jahat. Itu waktu cuma dia sandiri sa yang bae. Dia idop deka deng Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Ma Tuhan Allah lia kalo samua orang laen dong jahat abis. Di mana-mana sa, orang pung jalan idop dong su rusak mau mati. Tuhan Allah lia manusia di dunya tu, cuma ada jahat sa. ");
INSERT INTO mkn_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ais Tuhan Allah kasi tau sang Noh bilang, “Di mana-mana, Beta cuma dapa lia manusia pung jahat sa. Jadi Beta su putus bilang, Beta mau bekin ancor abis ini dunya deng dia pung isi samua. ");
INSERT INTO mkn_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Jadi bagini, Noh! Sakarang lu bekin ame satu kapal bésar dari kayu yang kuat. Di itu kapal pung dalam, lu bekin kamar-kamar. Ais lapis itu kapal deng ter. ");
INSERT INTO mkn_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Itu kapal, lu bekin dia pung panjang 133 meter; dia pung lebar 22 meter; deng dia pung tinggi 13 meter. ");
INSERT INTO mkn_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Pasang atap di itu kapal. Ma kasi farei itu atap kira-kira satenga meter dari atas dinding. Lu bagi itu kapal jadi tiga tingkat. Ais bekin satu pintu di itu kapal pung rebis. ");
INSERT INTO mkn_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Inga bae-bae! Beta nanti kasi turun banjer bésar ko bekin mati samua yang idop di ini dunya, sampe sonde ada sisa satu apa ju. ");
INSERT INTO mkn_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ma Beta mau ika Beta pung janji deng lu. Nanti lu maso pi dalam itu kapal sama-sama deng lu pung bini, lu pung ana-ana, deng lu pung ana mantu dong. ");
INSERT INTO mkn_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Dari samua binatang dong, lu musti pi ame satu-satu pasang, ko bawa maso pi dalam itu kapal, ko biar dong idop sama-sama deng lu. Sama ke binatang piara, burung-burung, deng binatang marayap dong, ko biar dong samua idop. ");
INSERT INTO mkn_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Lu musti bawa maso pi dalam itu kapal samua macam makanan kasi sang bosong, deng kasi itu binatang-binatang dong.” ");
INSERT INTO mkn_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ais ju Noh bekin iko sama deng Tuhan Allah pung parenta samua. ");
INSERT INTO mkn_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ais itu, ju TUHAN omong deng Noh bilang, “Beta lia pi mana-mana, ma cuma lu sa yang pung hati lurus. Tagal itu, lu deng lu pung bini-ana dong maso pi dalam kapal su. ");
INSERT INTO mkn_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Dari samua macam binatang yang bosong bole makan, deng yang bole bawa kasi sang Beta, na, lu bawa tuju-tuju pasang pi dalam itu kapal. Dari samua macam burung ju bawa tuju-tuju pasang. Ma dari binatang laen dong, bawa cuma satu-satu pasang sa. Deng bagitu, itu binatang deng burung dong jadi bibit, ko dong ada tarús. ");
INSERT INTO mkn_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Inga bae-bae, ó! Te tuju hari lai, Beta kasi turun ujan tar pake barenti sampe ampa pulu siang ampa pulu malam. Deng bagitu, Beta kasi mati abis samua yang idop di darat yang Beta su bekin.” ");
INSERT INTO mkn_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ais ju Noh bekin iko sama deng TUHAN pung parenta samua. ");
INSERT INTO mkn_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Waktu banjer datang tu, Noh pung umur 600 taon. ");
INSERT INTO mkn_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ais Noh deng dia pung bini, deng dia pung ana-ana, deng dia pung ana mantu dong, maso pi dalam itu kapal, ko salamat dari itu banjer bésar. ");
INSERT INTO mkn_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Iko TUHAN pung parenta tu, ju Noh bawa maso pi dalam kapal samua macam burung deng binatang laen dong, satu-satu deng dia pung pasang, bae dari yang orang bole makan, deng dari yang orang sonde bole makan. ");
INSERT INTO mkn_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Abis tuju hari, ju banjer tapoꞌa datang ko mulai tutu ame ini dunya. ");
INSERT INTO mkn_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Pas waktu Noh umur 600 taon, lewat dua bulan deng 17 hari, ju banjer pung datang! Itu waktu, tingka ke pintu langit tabuka, ko dia pung aer tapoꞌa turun. Deng samua mata aer di bawa tana dong tapica ko aer maspurak kaluar. ");
INSERT INTO mkn_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ju ujan turun tar pake barenti siang-malam, sampe ampa pulu hari. ");
INSERT INTO mkn_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ma itu hari ju, Noh, dia pung bini, dia pung ana tiga-tiga andia Sem, Yafet, deng Ham, deng dia pung ana mantu dong samua maso pi dalam kapal. ");
INSERT INTO mkn_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Dong maso sama-sama deng binatang dong, andia binatang piara, binatang liar, binatang marayap, burung-burung, deng binatang laen yang ada sayap dong. ");
INSERT INTO mkn_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Satu-satu pasang dari samua yang idop maso pi dalam kapal sama-sama deng Noh, sama ke Tuhan Allah pung parenta sang dia. Waktu dong samua su maso abis, ju TUHAN konci itu kapal pung pintu. ");
INSERT INTO mkn_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Ujan bésar turun tarús sampe ampa pulu hari, ju banjer nae tamba tinggi sampe kapal taꞌapung. Aer nae tarús sampe tutu ame gunung-gunung yang tinggi. ");
INSERT INTO mkn_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Itu aer nae sonde pake barenti, sampe dia pung tinggi ada tuju meter di atas gunung. ");
INSERT INTO mkn_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Deng bagitu, samua yang idop di darat dong mati abis. Andia: manusia, binatang piara, binatang liar, binatang marayap, deng burung-burung dong. Cuma Noh deng samua yang ada dalam itu kapal yang salamat. ");
INSERT INTO mkn_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Itu aer sonde tau turun-turun sampe saratus lima pulu hari. ");
INSERT INTO mkn_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ma Tuhan Allah sonde lupa sang Noh dong deng samua binatang di itu kapal. Ju Dia kasi angin ko fuu bekin turun itu aer banjer. ");
INSERT INTO mkn_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Dia tutu samua mata aer di bumi, deng kasi barenti ujan dari langit. ");
INSERT INTO mkn_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ju aer kurang tarús. Abis 150 hari, ju aer sonde bagitu tinggi lai. ");
INSERT INTO mkn_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Pas deng bulan tuju lewat 17 hari, ju itu kapal tadudu di atas satu gunung yang tinggi, nama Ararat. ");
INSERT INTO mkn_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Aer turun tarús sampe hari partama bulan sapulu, ju gunung-gunung pung ujung dong mulai kantara. ");
INSERT INTO mkn_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Lewat ampa pulu hari, ju Noh buka kapal pung jandela satu. ");
INSERT INTO mkn_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ais dia kasi lapás satu burung gagak. Itu burung tarbáng tarús pi-datang sampe aer banjer su turun batúl. Dia sonde kambali lai pi kapal. ");
INSERT INTO mkn_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ju Noh kasi lapás lai satu burung pompa, ko mau cari tau itu aer su turun batúl, ko balóm. ");
INSERT INTO mkn_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ma tagal aer masi tutu dunya samua, andia ko itu burung sonde dapa tampa hinggap. Ju dia kambali pi kapal. Noh sorong dia pung tangan, ko tarima ame itu burung maso dalam kapal. ");
INSERT INTO mkn_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noh tunggu tuju hari lai, ju dia kasi lapás ulang lai itu burung. ");
INSERT INTO mkn_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Dia pung sore, itu burung datang kambali sang Noh, deng dia ada bawa daon saitun satu yang dia baru pata ame. Ais ju Noh dapa tau kalo aer su turun batúl. ");
INSERT INTO mkn_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Dia tunggu tuju hari lai, ju dia kasi lapás ulang itu burung pompa. Ma ini kali, itu burung su sonde kambali lai. ");
INSERT INTO mkn_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Waktu Noh pung umur 601 taon, kaná hari partama bulan satu, aer su turun batúl-batúl. Ju Noh buka itu kapal pung jandela, ais dia lia kuliling, te tana dong su karíng. ");
INSERT INTO mkn_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Sampe bulan dua, hari 27, te tana su karíng batúl-batúl. ");
INSERT INTO mkn_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ais ju Tuhan Allah omong deng Noh bilang, ");
INSERT INTO mkn_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noh! Sakarang bosong samua turun suda dari ini kapal. ");
INSERT INTO mkn_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kasi kaluar itu binatang dong samua! Andia: binatang piara, binatang liar, binatang marayap, deng burung-burung dong. Kasi tenga ko dong samua tamba banya, deng bekin ponu ini dunya.” ");
INSERT INTO mkn_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Ais ju Noh deng dia pung bini, dia pung ana-ana, deng dia pung ana mantu dong samua kaluar dari itu kapal. Itu binatang dong samua ju kaluar, satu-satu deng dia pung golongan. ");
INSERT INTO mkn_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ais Noh susun batu ko bekin meja korban kasi sang TUHAN. Dari binatang-binatang yang bole pake jadi binatang korban, Noh ame satu-satu ekor. Ais dia horo ko bakar sang dong di atas itu meja korban, ko jadi tanda sukur sang TUHAN. ");
INSERT INTO mkn_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Waktu TUHAN dapa ciom itu korban pung baboo wangi, ju Dia pung hati sanáng. Ju Dia pikir bilang, “Mulai sakarang, Beta sonde akan kutuk lai ini dunya tagal manusia pung jahat. Biar dong cuma tau pikir jahat dari kici sa, ma Beta sonde akan kasi ancor abis lai samua yang idop, sama ke yang Beta su bekin tu. ");
INSERT INTO mkn_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Salama ini dunya masi ada, ini musim dong samua jalan tarús, iko dia pung atoran. Andia: musim tanam deng musim koru, musim dingin deng musim panas, musim karíng deng musim ujan, siang deng malam.” ");
INSERT INTO mkn_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Tuhan Allah kasi berkat sang Noh deng dia pung ana-ana dong, deng omong bilang, “Bosong barana bam-banya, ko bekin ponu ini dunya lai. ");
INSERT INTO mkn_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nanti samua binatang liar, burung deng ikan dong taku sang bosong. Bosong yang musti ator sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Bosong bole makan itu binatang samua pung daging, sama ke bosong ju bole makan tanaman dong pung hasil. Samua ni, Beta kasi sang bosong. ");
INSERT INTO mkn_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Cuma bosong sonde bole makan daging yang masi ada pung dara, tagal binatang pung nyawa ada di dia pung dara. ");
INSERT INTO mkn_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Beta bekin manusia iko Beta pung model. Tagal itu, sonde bole bunu manusia. Kalo ada orang ko binatang, yang bunu bekin mati manusia, musti bunu bekin mati sang dong ju. Ini hukum datang dari Beta. ");
INSERT INTO mkn_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Bosong musti barana bam-banya, ko bekin ponu ulang lai ini dunya.” ");
INSERT INTO mkn_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tuhan Allah sambung lai Dia pung omong bilang, ");
INSERT INTO mkn_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Sakarang Beta mau ika Beta pung janji deng bosong, sampe deng bosong pung turunan ju. ");
INSERT INTO mkn_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ini janji ju kaná deng samua yang idop, andia binatang piara, binatang liar, deng burung-burung. Pokonya, samua yang kaluar sama-sama deng bosong dari itu kapal. ");
INSERT INTO mkn_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Beta pung janji tu, bagini: Beta sonde akan kirim banjer bésar lai, ko bekin mati samua yang idop, deng bekin ancor abis ini dunya. ");
INSERT INTO mkn_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Beta taro Beta pung palangi di langit ko jadi tanda yang kasi inga Beta pung janji yang sonde putus-putus deng bosong, deng samua yang idop, deng ini dunya. ");
INSERT INTO mkn_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Kalo ada awan di langit, ais palangi kaluar, nanti dia kasi inga sang Beta itu janji bilang: nanti banjer bésar sonde akan bekin ancor abis lai samua yang idop. Deng bagitu, Beta pung janji yang sonde tau abis tu, su taꞌika deng bosong, deng samua yang idop.” ");
INSERT INTO mkn_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noh pung ana-ana yang kaluar dari itu kapal, andia Sem, Yafet deng Ham. (Ham tu, Kanaꞌan pung papa). ");
INSERT INTO mkn_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Samua orang di dunya pung turunan datang dari Noh pung tiga ana dong. ");
INSERT INTO mkn_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noh tu, orang tani. Dia yang partama kali bekin kabón anggor. ");
INSERT INTO mkn_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Satu kali, dia minum anggor sampe mabok barát. Ju dia buka buang dia pung pakean, abis tidor laloli talanjang bulat di dalam dia pung tenda. ");
INSERT INTO mkn_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Waktu Ham dapa lia dia pung bapa pung talanjang tu, ju dia lari kaluar, ko pi kasi tau dia pung kaka Sem deng Yafet. ");
INSERT INTO mkn_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ais dong dua ame satu salimut, ju dong buka kasi tagantong di dong pung bahu. Ais itu, dong jalan mondor maso pi dalam itu tenda, ko tutu ame dong pung bapa. Deng bagitu, dong sonde lia dong pung bapa pung talanjang tu. Ais dong kaluar. ");
INSERT INTO mkn_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Waktu Noh pung mabok mulai ilang, ju dia dapa tau dia pung ana bungsu pung bekin. ");
INSERT INTO mkn_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ais dia omong bilang, “Heh! Kanaꞌan pung bapa! Beta kutuk sang lu! Lu nanti jadi lu pung kaka dong pung budak! ");
INSERT INTO mkn_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Puji TUHAN! Biar ko Dia kasi berkat sang Sem! Ma biar ko Kanaꞌan jadi Sem pung jongos. ");
INSERT INTO mkn_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Biar Tuhan Allah bekin tamba luas Yafet pung tana; Deng dia pung turunan idop dame deng Sem pung turunan. Ma biar Kanaꞌan jadi Yafet pung kuli.” ");
INSERT INTO mkn_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mulai dari itu banjer abis, Noh masi idop lai 350 taon. ");
INSERT INTO mkn_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Dia mati waktu dia pung umur su 950 taon. ");
INSERT INTO mkn_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Abis banjer, ju Noh pung ana-ana dong dapa turunan. Andia turunan dari Sem, Yafet deng Ham. ");
INSERT INTO mkn_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Yafet pung turunan, andia, Gomer, Magog, Madai, Yawan, Tubal, Mesek deng Tiras. Satu-satu deng dong pung bahasa, dong pung suku, deng dong pung tana sandiri. Gomer pung turunan, andia, Askenas, Rifat deng Togarma. Yawan pung turunan, andia, Elisa, Tarsis, orang-orang Kitim, deng Dodanim yang tenga di pinggir-pinggir pante. ");
INSERT INTO mkn_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham pung turunan, andia, Kus, Misraim, Put, deng Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus pung turunan, andia, Seba, Hawila, Sabta, Raema deng Sabteka. Raema pung turunan, andia, Syeba deng Dedan. ");
INSERT INTO mkn_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus pung ana laki-laki sang Nimrod. Dia tu, panglima paráng partama yang hebat. ");
INSERT INTO mkn_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Dia pung hebat datang dari TUHAN, sampe dia ju jadi tukang buru binatang yang paling jago. Andia ko orang biasa omong bilang, “Biar ko lu jadi tukang buru binatang yang jago sama ke Nimrod, yang dapa dia pung hebat dari TUHAN.” ");
INSERT INTO mkn_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Mula-mula dia pung daꞌera mulai dari Babel, Erek Akad, deng Kalne. Dong samua ada di Sinear. ");
INSERT INTO mkn_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Dari situ, dia kuasa tamba Asyur. Ais ju dia kasi bangun kota Niniwe, Rehobot-Ir, Kala, ");
INSERT INTO mkn_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","deng Resen, yang ada di Niniwe deng Kala pung teng-tenga. Samua tu, kota-kota bésar. ");
INSERT INTO mkn_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim pung turunan, andia, orang-orang Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO mkn_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Kasluhim, deng Kaftorim. Orang Kasluhim tu, andia orang Filistin dong pung nene-moyang. ");
INSERT INTO mkn_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaꞌan pung ana sulung, andia, Sidon. Kanaꞌan ju jadi nene-moyang dari orang-orang Het, ");
INSERT INTO mkn_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusi, Amori, Girgasi, ");
INSERT INTO mkn_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi, Arki, Sini, ");
INSERT INTO mkn_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadi, Semari, deng Hamati. Kanaꞌan pung turunan dong tasiram jao-jao ");
INSERT INTO mkn_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","sampe dong pung batas-batas tana mulai dari Sidon tarús pi Gerar, sampe di Gasa. Dari situ pi Sodom, Gomora, Adma, deng Seboim, sampe di Lasa. ");
INSERT INTO mkn_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Dong samua tu, Ham pung turunan. Satu-satu deng dong pung bahasa, dong pung suku, deng dong pung tana sandiri. ");
INSERT INTO mkn_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet pung kaka Sem, jadi orang Eber dong pung nene-moyang. ");
INSERT INTO mkn_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem pung turunan, andia, Elam, Asyur, Arpaksad, Lud deng Aram. ");
INSERT INTO mkn_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram pung turunan, andia, orang-orang Us, Hul, Geter deng Mas. ");
INSERT INTO mkn_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad pung ana, Sela. Sela pung ana, Eber. ");
INSERT INTO mkn_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber dapa dua ana laki-laki. Yang sulung, dapa nama Pelek (yang dia pung arti ‘tabagi-bagi’), tagal itu waktu, orang dong tabagi-bagi di dunya. Dia pung adi, nama Yoktan. ");
INSERT INTO mkn_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan pung turunan, andia, Almodad, Selef, Hasar-Mawet, Yera, ");
INSERT INTO mkn_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO mkn_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO mkn_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, deng Yobab. Dong samua ni, Yoktan pung turunan. ");
INSERT INTO mkn_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Dong pung tampa tenga tu, mulai dari Mesa, tarús sampe di Sefar, andia tampa bagunung-bagunung di sablá matahari nae. ");
INSERT INTO mkn_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Dong samua tu, Sem pung turunan. Satu-satu deng dong pung bahasa, dong pung suku, deng dong pung tana sandiri. ");
INSERT INTO mkn_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Itu samua tu, Noh pung turunan, satu-satu deng dia pung suku sandiri-sandiri. Waktu banjer bésar abis, dong ni yang tasiram bekin ponu dunya. ");
INSERT INTO mkn_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Dolu-dolu, samua orang di dunya baꞌomong pake satu bahasa sa. ");
INSERT INTO mkn_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Waktu dong saparu mulai bapinda pi sablá matahari nae, dong sampe di satu tana rata di Sinear, ju dong tenga di situ. ");
INSERT INTO mkn_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Dong samua baꞌakór bilang, “We! Sodara-sodara dong! Mari ko kotong bangun satu kota bésar. Kotong musti bekin batu bata, ais kotong bakar sampe karás. Deng kotong susun itu batu bata dong pake ter. Ais kotong kasi badiri satu manara tinggi, yang dia pung ujung sampe di langit, ko biar kotong dapa nama. Biar ko kotong jadi satu bangsa bésar yang sonde usa tabagi-bagi.” ");
INSERT INTO mkn_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ju TUHAN turun ko maloi coba itu kota deng dia pung manara yang dong bangun. ");
INSERT INTO mkn_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ais Dia omong bilang, “Ini manusia dong samua, satu bangsa, deng pake satu bahasa. Apa yang dong bekin sakarang ni, baru mulai langka partama sa. Beso-lusa, kalo dong samua taꞌika jadi satu sama ke sakarang ni, nanti dong bisa bekin apa sa. ");
INSERT INTO mkn_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Lebe bae Kotong turun bekin dong pung bahasa jadi laen-laen, ko biar dong sonde bisa mangarti satu deng satu lai.” ");
INSERT INTO mkn_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ais ju Tuhan turun ko bekin kaco dong pung bahasa. Deng bagitu, Dia bekin itu manusia dong tasiram pi samua tampa di dunya. Ju dong su sonde bangun tarús itu kota lai. ");
INSERT INTO mkn_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Andia ko dong kasi nama itu kota, Babel, (yang amper sama ke satu kata yang dia pung arti ‘babingung’), tagal TUHAN bekin kaco dong pung bahasa deng kasi tasiram sang dong pi mana-mana di dunya. ");
INSERT INTO mkn_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ini Sem pung turunan. Waktu banjer bésar su barenti dua taon, pas deng Sem umur 100 taon, dia dapa satu ana laki-laki, nama Arpaksad. ");
INSERT INTO mkn_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ais itu, dia masi idop lai 500 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Waktu Arpaksad umur 35 taon, dia dapa satu ana laki-laki, nama Sela. ");
INSERT INTO mkn_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ais itu, Arpaksad masi idop lai 403 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Waktu Sela umur 30 taon, dia dapa satu ana laki-laki, nama Eber. ");
INSERT INTO mkn_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ais itu, Sela masi idop lai 403 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Waktu Eber umur 34 taon, dia dapa satu ana laki-laki, nama Pelek. ");
INSERT INTO mkn_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ais itu, Eber masi idop lai 430 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Waktu Pelek umur 30 taon, dia dapa satu ana laki-laki, nama Rehu. ");
INSERT INTO mkn_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ais itu, Pelek masi idop lai 209 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Waktu Rehu umur 32 taon, dia dapa satu ana laki-laki, nama Seruk. ");
INSERT INTO mkn_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ais itu, Rehu masi idop lai 207 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Waktu Seruk umur 30 taon, dia dapa satu ana laki-laki, nama Nahor. ");
INSERT INTO mkn_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ais itu, Seruk masi idop lai 200 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Waktu Nahor umur 29 taon, dia dapa satu ana laki-laki, nama Tera. ");
INSERT INTO mkn_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ais itu, Nahor masi idop lai 119 taon, deng dia dapa tamba lai ana laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Waktu Tera umur 70 taon lebe, ju dia dapa tiga ana laki-laki, andia, Abram, Nahor, deng Haran. ");
INSERT INTO mkn_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera pung turunan dong, bagini: Tera pung ana dong, andia Abram, Nahor, deng Haran. Haran dapa satu ana laki-laki, nama Lot. ");
INSERT INTO mkn_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran mati di dia pung kampong asal, nama Ur, di orang Kasdim pung tana. Waktu dia mati tu, dia pung bapa Tera masi idop. ");
INSERT INTO mkn_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram kawin deng Sarai. Nahor kawin deng Haran pung ana parampuan, nama Milka. Haran ju dapa ana laki-laki, nama Yiska. ");
INSERT INTO mkn_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ma Sarai mandul, sonde bisa barana. ");
INSERT INTO mkn_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Satu kali, Tera bawa dia pung ana Abram, dia pung ana mantu Sarai, deng cucu Lot, ko dong kaluar kasi tenga kampong Ur. Itu waktu dong mau pi tana Kanaꞌan. Ma sampe di negrí Haran, ju dong tenga di situ sa. ");
INSERT INTO mkn_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Di situ, Tera mati waktu dia pung umur 205 taon. ");
INSERT INTO mkn_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Itu waktu, TUHAN su omong deng Abram bilang, “Abram! Lu kaluar kasi tenga lu pung kelu, lu pung bapa pung ruma, deng lu pung kampong. Lu pi satu tampa, yang nanti Beta kasi tunju sang lu. ");
INSERT INTO mkn_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nanti Beta kasi berkat sang lu. Deng lu pung turunan nanti tamba banya, deng jadi bangsa yang hebat sampe orang dong kanál lu pung nama. Ais lu nanti jadi berkat kasi sang orang laen. ");
INSERT INTO mkn_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nanti Beta kasi berkat sang orang yang kasi berkat sang lu. Ma Beta kasi kutuk sang orang yang kasi kutuk sang lu. Dengar bae-bae! Te nanti samua suku-bangsa di ini dunya dapa berkat, tagal lu.” ");
INSERT INTO mkn_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Itu waktu, Abram pung umur 75 taon. Dia bawa dia pung bini Sarai, dia pung adi pung ana Lot, dia pung barang pusaka samua, deng samua orang karjá yang dia dapa di kota Haran. Ju Abram dong jalan kasi tenga Haran, ko pi di tampa yang TUHAN su kasi tau sang dia. Jadi dong jalan tarús, sampe di satu tampa, nama Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Sampe di sana, ju Abram jalan kuliling itu tana, sampe deka deng satu kampong, nama Sikem. Ais dong tenga tahan deka satu pohon bésar di More. Itu waktu, orang Kanaꞌan dong masi tenga di situ. ");
INSERT INTO mkn_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Di situ, TUHAN kasi tunju diri sang Abram. Dia bilang, “Nanti Beta kasi ini daꞌera sang lu pung turunan.” Ais ju Abram susun kasi badiri satu meja batu ko pake jadi meja korban kasi sang TUHAN yang su kasi tunju Dia pung diri di situ. ");
INSERT INTO mkn_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ais itu, Abram dong pinda pi gunung di salatan, ais tenga tahan di kampong Betel deng kampong Ai pung teng-tenga. Di situ dia kasi badiri satu meja korban, deng dia sémba sang TUHAN. ");
INSERT INTO mkn_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ais itu, dia bapinda-bapinda tampa, sampe di tana Negeb di Kanaꞌan pung sablá salatan. ");
INSERT INTO mkn_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Satu waktu, ada musim lapar yang hebat di tana Kanaꞌan. Andia ko Abram dong jalan lebe jao lai pi sablá salatan, sampe di negrí Masir. Dong tenga tahan di sana. ");
INSERT INTO mkn_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Waktu dong mau maso pi negrí Masir, dia kasi tau dia pung bini Sarai bilang, “Sarai. Lu ni, talalu manis. ");
INSERT INTO mkn_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ma nanti kalo orang Masir lia sang lu manis bagini, tantu dong mau bunu sang beta, tagal beta ni lu pung laki. Deng bagitu, dong bisa ame sang lu. ");
INSERT INTO mkn_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Jadi ada lebe bae, lu kasi tau sang dong bilang, beta ni, lu pung kaka. Deng bagitu, dong sonde bunu sang beta, ma nanti dong babae deng beta, tagal lu.” ");
INSERT INTO mkn_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Tarús, waktu Abram dong su sampe di Masir, orang dong dapa lia itu parampuan manis talalu. ");
INSERT INTO mkn_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Waktu raja Masir pung pagawe dong dapa lia sang dia, ju dong puji-puji itu parampuan pung manis di muka raja. Ais dong bawa itu parampuan pi raja pung ruma. ");
INSERT INTO mkn_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Jadi raja babae deng Abram, tagal Sarai. Ju raja parsén binatang kasi sang Abram, andia: kambing, domba, sapi, keledai, deng onta. Dia ju kasi parsén hamba laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ma tagal raja su ame orang pung bini pi dalam dia pung ruma, andia ko TUHAN hukum macam-macam sang dia deng dia pung isi ruma dong. ");
INSERT INTO mkn_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ais raja pange sang Abram ko tanya sang dia bilang, “Abram! Lu su bekin karmana sang beta? Akurang ko lu sonde kasi tau bilang, itu parampuan tu, lu pung bini? ");
INSERT INTO mkn_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ma lu bilang dia ni, lu pung adi! Amper sadiki beta ame sang dia jadi beta pung bini! Ini dia, lu pung bini. Sakarang, ame bawa sang dia, deng iskarobis suda dari beta pung muka!” ");
INSERT INTO mkn_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ais raja parenta dia pung pagawe dong, ko usir kasi kaluar Abram, dia pung bini, deng dong pung barang samua dari itu daꞌera. ");
INSERT INTO mkn_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ais itu, Abram jalan kasi tenga Masir, ko kambali pi tana Negeb. Dia bawa dia pung bini deng dia pung harta pusaka samua. Dia pung adi pung ana Lot ju ada iko sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram tu, kaya mau mati. Dia pung binatang piara deng mas-perak, talalu banya. ");
INSERT INTO mkn_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Dari Negeb dia jalan bapinda-bapinda ko pi kambali di kampong Betel deng kampong Ai pung teng-tenga. Dolu dia parná tenga di situ. ");
INSERT INTO mkn_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Deng dia ju su kasi badiri meja korban. Ais dia sémba sang TUHAN di situ. ");
INSERT INTO mkn_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, yang iko sama-sama deng Abram tu, ju ada pung binatang piara banya, deng dia pung orang karjá dong ju banya. ");
INSERT INTO mkn_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Ma itu tampa sonde cukup luas kasi Abram deng Lot, deng dong pung harta-benda samua, ko idop sama-sama di situ. Ais Abram deng Lot pung gambala dong mulai bakanjar, tagal rumput di itu tampa sonde cukup kasi dong pung binatang. (Itu waktu, orang Kanaꞌan deng orang Feris masi tenga di situ ju.) ");
INSERT INTO mkn_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ais ju Abram kasi tau sang dia pung ana bilang, “Lot, é! Kotong ni bakelu. Jang sampe kotong dua batar-enak satu deng satu, ais kotong pung orang karjá dong maen babakalai tarús. ");
INSERT INTO mkn_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Naa, lebe bae kotong dua bapisa sa. Ini tampa luas. Jadi, kalo lu pili ame tana di bagian kiri, na, beta ame di bagian kanan. Ma kalo lu pili ame tana di bagian kanan, na, beta ame di bagian kiri.” ");
INSERT INTO mkn_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ais Lot lia-lia kuliling. Ju dia dapa lia kali Yarden pung lemba yang limpa deng aer, sampe di kampong Soar. Itu tampa pung subur sama ke TUHAN pung kabón, deng sama ke tana Masir. (Itu waktu, TUHAN balóm kasi ancor kota Sodom deng Gomora. Jadi itu tana masi bae.) ");
INSERT INTO mkn_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Jadi Lot pili ame samua tana di kali Yarden pung lemba. Ais dong dua bapisa. Ju Lot pi sablá matahari nae. ");
INSERT INTO mkn_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ma Abram tenga tarús di tana Kanaꞌan. Ais Lot pi tenga di kampong-kampong deka kota Sodom di lemba Yarden. ");
INSERT INTO mkn_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ma orang Sodom jahat mau mati. Deng dong sonde mau dengar sang TUHAN. ");
INSERT INTO mkn_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Waktu Lot deng Abram su bapisa, ju TUHAN bilang sang Abram, “Abram! Coba lu buang mata kuliling ko lia samua tampa dari tampa yang lu badiri tu. Lia bae-bae muka-balakang kiri-kanan. ");
INSERT INTO mkn_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Samua tana yang lu lia tu, nanti Beta kasi sang lu deng lu pung turunan dong, ko jadi bosong pung pusaka tarús sampe salamanya. ");
INSERT INTO mkn_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nanti Beta kasi lu pung turunan dong jadi banya sama ke pasir di pante. Sampe orang dong sonde bisa itong lu pung turunan pung banya. ");
INSERT INTO mkn_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Sakarang lu jalan kuliling iko ini tana pung panjang deng lebar. Te samua tu, nanti Beta kasi sang lu!” ");
INSERT INTO mkn_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ais ju Abram dong pinda, deng pi tenga ulang lai di itu tampa deka pohon-pohon bésar di Mamre, deka kampong Hebron. Ais dia susun meja korban, ko sémba sang TUHAN di situ. ");
INSERT INTO mkn_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Itu waktu, ada ampa raja bakumpul. Andia: Amrafel, raja negrí Sinear. Ariok, raja negrí Elasar. Kedarlaomer, raja negrí Elam. Deng Tideal, raja negrí Goyim. ");
INSERT INTO mkn_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Itu waktu, ju ada lima raja laen yang bakumpul. Andia: Bera, raja negrí Sodom. Birsa, raja negrí Gomora. Sinab, raja negrí Adema. Semeber, raja negrí Seboim. Deng raja negrí Bela (andia negrí Soar). Ais, itu ampa raja dong baparáng lawan itu lima raja laen dong. ");
INSERT INTO mkn_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Itu lima raja dong bakumpul deng dong pung tantara di lemba Sidim, (yang sakarang dong bilang Laut Mati). ");
INSERT INTO mkn_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Itu paráng pung akar bagini: dolu itu lima raja tondo sang raja Kedarlaomer sampe 12 taon. Ma taon ka-13, ju dong bangun malawan sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Waktu maso pi taon ka-14, ju raja Kedarlaomer deng dia pung tamán tiga raja tu, datang deng dong pung tantara. Ju dong baparáng bekin kala barapa negrí. Andia: orang Refaim di negrí Asterot-Karnaim, orang Susim di negrí Ham, orang Emim di negrí Sawe-Kiryataim, ");
INSERT INTO mkn_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","deng orang Hori yang di gunung Seir sampe di tampa kosong El Paran pung pinggir. ");
INSERT INTO mkn_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ais dong bale kambali pi En Mispat (yang sakarang nama Kades). Ais itu, dong bekin ancor orang Amalek pung negrí, deng orang Amori yang tenga di negrí Haseson-Tamar. ");
INSERT INTO mkn_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Ais, itu lima raja ator dong pung tantara di lemba Sidim, ju dong baparáng lawan itu ampa raja dong. ");
INSERT INTO mkn_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Di itu lemba, ada banya kolam ter. Waktu dong baparáng tu, raja Sodom, raja Gomora deng dong pung tantara, bangun lari. Dong saparu jato maso dalam kolam ter. Deng saparu lari pi gunung. ");
INSERT INTO mkn_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Jadi itu ampa raja yang manáng tu, pi rampas ame samua barang deng makanan dari Sodom deng Gomora. Ais ju dong mulai pulang. ");
INSERT INTO mkn_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ma Abram pung ana Lot ada tenga di Sodom. Ais, itu ampa raja dong ju tangkap bawa Lot dong, deng rampas bawa dong pung barang samua. ");
INSERT INTO mkn_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ma ada satu orang yang talapás. Ju dia lari pi lapor sang Abram, orang Ibrani. Itu waktu, ada satu orang Amori, nama Mamre. Abram ada tenga deka-deka Mamre pung pohon-pohon bésar. Mamre pung sodara sang Eskol deng Aner. Dong tu, jadi Abram pung partei. ");
INSERT INTO mkn_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Waktu Abram dapa dengar bilang, orang su tangkap bawa dia pung adi pung ana, ju dia kumpul dia pung orang karjá yang pintar baparáng. Dong samua ada 318 orang. Ais ju dong pi buru itu ampa raja sampe di kampong Dan yang jao di sablá utara. ");
INSERT INTO mkn_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Di sana, Abram bagi dia pung orang-orang dong jadi barapa kalompok. Dia pung malam, ju dong pi saráng itu orang dong. Ma ada yang lari. Ais Abram dong buru tarús sang dong, sampe di kampong Hoba, di kota Damsik pung sablá utara. ");
INSERT INTO mkn_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ais Abram dapa ame kambali sang Lot, dia pung orang dong, dong pung barang samua, deng orang-orang laen ju. ");
INSERT INTO mkn_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Waktu Abram pulang dari kasi kala itu ampa raja dong, ju raja Sodom datang sambut sang Abram di lemba Sawe (yang orang biasa subu bilang, Lemba Raja). ");
INSERT INTO mkn_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Itu waktu, Melkisedek jadi kota Salem pung raja. Deng dia ju kapala agama dari Tuhan Allah yang Paling Tinggi. Dia datang ko bawa kasi sang Abram roti deng aer bua anggor. ");
INSERT INTO mkn_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Ais ju dia omong kasi berkat sang Abram bilang, “Biar Tuhan Allah yang Paling Tinggi, yang bekin ame langit deng bumi, kasi berkat sang lu. Puji sang Tuhan Allah, yang su bekin lu manáng dari lu pung musu dong.” Ais itu ju Abram bagi kasi Melkisedek satu per sapulu bagian dari samua yang dia su rampas kambali tu. ");
INSERT INTO mkn_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ais ju raja Sodom soya sang Abram, deng bilang, “Bapa Abram. Barang-barang yang bapa su rampas ame dari beta pung musu dong, biar bapa soa samua. Ma beta cuma minta kambali beta pung orang dong.” ");
INSERT INTO mkn_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ma Abram manyao bilang, “Beta sumpa di muka Tuhan Allah yang Paling Tinggi, yang bekin ame langit deng bumi, ");
INSERT INTO mkn_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","bilang, beta sonde akan ame barang satu apa ju dari lu pung barang. Biar banáng sapoꞌong ju, beta sonde akan ame. Deng bagitu, lu sonde bisa omong bilang, ‘Abram jadi kaya, gara-gara beta.’ ");
INSERT INTO mkn_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Beta sonde parlú apa-apa. Cuma mana yang beta pung orang dong su pake, anggap sa su abis. Deng biar beta pung tamán tiga orang ni, Aner, Eskol deng Mamre, ame bawa dong pung bagian.” ");
INSERT INTO mkn_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ais itu, TUHAN kasi tunju diri sang Abram. Ju Dia bilang, “Abram! Lu sonde usa taku. Te Beta yang tangkis ko pele sang lu dari musu. Deng Beta kasi ontong bésar sang lu.” ");
INSERT INTO mkn_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Ma Abram bilang, “Eee, Tuhan Allah. Biar Tuhan mau kasi sang beta bagitu banya ju, sonde ada guna apa-apa. Te beta sonde ada ana ko kasi beta turunan. Jadi mau dapa pusaka bam-banya bekin apa? Paling-paling beta pung hamba, Eliasar dari Damsik yang dapa samua.” ");
INSERT INTO mkn_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ma TUHAN manyao bilang, “Bukan bagitu! Te lu pung ana sandiri yang nanti dapa itu pusaka, ma bukan itu hamba.” ");
INSERT INTO mkn_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ju Dia bawa sang Abram kaluar, ais Dia bilang, “Sakarang lu lia pi langit. Coba lu lia itu bintang. Lu bisa itong sang dong, ko? Lu pung turunan nanti jadi sama banya deng itu bintang dong!” ");
INSERT INTO mkn_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ju Abram tarima TUHAN pung omong. Ais TUHAN cap sang dia orang hati lurus, tagal Abram parcaya sang Dia. ");
INSERT INTO mkn_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ju TUHAN sambung lai bilang, “Beta ni, Tuhan Allah. Beta yang su bawa kaluar sang lu dari kampong Ur di orang Kasdim dong pung tana. Deng Beta yang kasi ini tana jadi lu pung pusaka.” ");
INSERT INTO mkn_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ma Abram tanya lai bilang, “Ma karmana TUHAN? Karmana ko beta bisa tau bilang, nanti ini tana jadi beta pung pusaka?” ");
INSERT INTO mkn_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ju Dia manyao bilang, “Bagini! Mari kotong bekin satu acara, ko ika apa yang Beta omong tadi. Sakarang lu pi ame binatang kasi sang Beta: sapi mai satu, kambing mai satu, deng domba laki satu. Dong samua musti umur tiga taon. Ais lu ame bawa lai burung takukur satu ekor deng burung pompa satu ekor.” ");
INSERT INTO mkn_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ju Abram pi ame itu binatang samua. Ais dia balá bagi dua itu sapi, kambing, deng domba. Ju dia ator itu daging dong bagi dua di tana, satu bamangada deng satu, jadi dua baris. Ma dia sonde balá itu burung dong. ");
INSERT INTO mkn_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ais ju burung-burung tukang makan bangke dong datang ko mau makan itu daging dong. Ma Abram usir buang sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Waktu matahari tanggalám, ju Abram tidor sonu. Dia mimpi bilang, galáp gulita ada tutu ame sang dia sampe dia taku mau mati. ");
INSERT INTO mkn_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Ais Tuhan Allah kasi tau sang dia bilang, “Abram! Nanti lu idop sampe tua sakali, deng mati deng tanáng, baru dong kubur bae-bae sang lu. Ma lu pung turunan dong nanti pi jadi orang manumpang di orang laen pung negrí. Nanti bangsa dari itu negrí bekin sang dong jadi kuli, abis tendes bekin sangsara satenga mati, sampe ampa ratus taon. Ma nanti Beta hukum itu bangsa. Ais Beta bawa kaluar lu pung turunan dari situ, deng dong bawa harta pusaka bam-banya. ");
INSERT INTO mkn_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nanti Beta ator ko lu pung turunan kalima dong pulang datang di sini lai. Sakarang, orang Amori dong ada tenga di atas ini tana. Ini orang dong jahat, ma balóm talalu barát. Nanti kalo lu pung ana-cucu dong su pulang datang di sini, Beta mau pake sang dong, ko hukum bekin ancor orang Amori dong. Te itu waktu, dong pung jahat su kalewat batas.” ");
INSERT INTO mkn_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Waktu su malam, takuju te ada satu raꞌo tana liat baꞌasap deng satu obor manyala bagarák lewat itu daging dua baris pung teng-tenga. ");
INSERT INTO mkn_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Itu waktu, ju TUHAN ika janji deng Abram. Dia kasi tau bilang, “Beta janji, nanti Beta kasi ini daꞌera sang lu pung turunan, mulai dari kali Masir, sampe ke kali Efrat, ");
INSERT INTO mkn_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","deng tana orang-orang Keni, Kenas, Kadmon, ");
INSERT INTO mkn_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het, Feris, Refaim, ");
INSERT INTO mkn_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori, Kanaꞌan, Girgasi, deng Yebus.” ");
INSERT INTO mkn_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Itu waktu, Abram su kambali dari Masir, ko su tenga sapulu taon di Kanaꞌan. Dia pung bini, Sarai, balóm dapa ana. Sarai ada pung hamba parampuan orang Masir, nama Hagar. Satu kali, Sarai baꞌomong deng Abram bilang, “Bapa! TUHAN su pele beta pung tampa ana. Ada lebe bae bapa pi tidor deng beta pung hamba Hagar, ko biar dia barana kasi beta.” Ju Abram iko dia pung bini pung omong. Ais Sarai kasi Hagar ko jadi Abram pung bini muda. ");
INSERT INTO mkn_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ais ju Abram pi tidor deng Hagar, ju itu parampuan dudu parú. Ma waktu Hagar tau dia su dudu parú, dia jadi sombong, ju dia pandang enteng sang Sarai. ");
INSERT INTO mkn_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ais Sarai omong deng Abram bilang, “Beta yang kasi itu hamba ko jadi lu pung bini muda. Ma waktu itu parampuan tau dia bunting, ju dia pandang enteng sang beta. Itu lu pung sala samua! Kasi tenga ko TUHAN putus kotong dua pung parkara. Baru lu tau!” ");
INSERT INTO mkn_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ais ju Abram manyao bilang, “Bagini! Lu ni, bini tua. Ma dia tu, cuma bini muda sa. Jadi lu yang ada pung kuasa sang dia. Lu mau bekin apa sang dia, dari lu sa!” Ais ju Sarai bekin kasar-kasar sang Hagar sampe dia bangun lari. ");
INSERT INTO mkn_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Dia lari sampe di padang pasir. Ju TUHAN pung ana bua satu dari sorga dapa sang dia deka deng mata aer di jalan pi Sur. ");
INSERT INTO mkn_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ais dia bilang, “We! Hagar, Sarai pung hamba! Akurang ko lu ada di sini? Lu dari mana, deng mau pi mana?” Ju Hagar manyao bilang, “Beta lari kasi tenga beta pung nyonya.” ");
INSERT INTO mkn_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ju TUHAN pung ana bua kokoe sang dia bilang, “Bagini! Lebe bae lu pulang pi lu pung nyonya. Dia bekin karmana sang lu, na, tarima sa. ");
INSERT INTO mkn_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Lu jang taku. Nanti beta bekin lu pung turunan bam-banya, sampe orang sonde bisa itong ontong sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Sakarang lu ada dudu parú. Sonde lama lai, lu barana satu ana laki-laki. Lu musti kasi nama sang dia, Ismael (yang amper sama ke satu kata laen yang pung arti bilang, ‘Tuhan dengar’), tagal TUHAN su dengar lu pung manangis. ");
INSERT INTO mkn_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ma itu ana bésar datang, dia idop jao dari dia pung sodara dong. Tagal dia sama ke kuda liar yang sonde tau dengar parenta. Sapa sa, dia lawan. Deng samua orang lawan bale sang dia.” ");
INSERT INTO mkn_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Dengar abis bagitu, ju Hagar omong dalam hati bilang, “Beta su lia TUHAN, yang ada lia deng jaga sang beta.” Ais dia mulai pange sang Tuhan pake nama “Tuhan yang paduli sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Andia ko orang kasi nama itu mata aer, Beer Lahai Roi, yang dia pung arti, “Mata aer dari Dia yang idop, yang paduli sang beta.” Dia pung tampa di kampong Kades deng kampong Beret pung teng-tenga. Itu mata aer masi ada sampe sakarang. ");
INSERT INTO mkn_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ais itu, Hagar pulang. Ju dia barana ame satu ana laki-laki. Abram kasi nama sang dia Ismael. ");
INSERT INTO mkn_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Waktu Hagar barana sang Ismael, Abram pung umur su 86 taon. ");
INSERT INTO mkn_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Waktu Abram pung umur 99 taon, TUHAN datang kasi tunju Dia pung diri sang Abram. Ju Dia omong bilang, “Beta ni, Tuhan Allah yang Paling Kuasa. Lu musti iko tarús Beta pung mau, deng idop lurus-lurus. ");
INSERT INTO mkn_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Beta mau ika janji deng lu, deng bekin lu pung turunan dong balipa-ganda.” ");
INSERT INTO mkn_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ju Abram tikam lutut ko tondo kapala sampe di tana. Ais Tuhan Allah omong tarús bilang, ");
INSERT INTO mkn_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Beta bekin janji deng lu, bagini: nanti lu jadi banya bangsa pung nene-moyang. Tagal itu, lu pung nama bukan Abram lai (yang dia pung arti ‘bapa yang nama takanál’), ma Abraham (yang dia pung arti ‘banya bangsa pung nene-moyang’). ");
INSERT INTO mkn_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Beta nanti bekin lu pung turunan dong balipa-ganda. Deng nanti Beta ju kasi bangun banya bangsa dari dong, deng angka banya raja dari itu turunan dong. ");
INSERT INTO mkn_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Beta pegang tarús Beta pung janji deng lu, deng lu pung turunan dong. Ini janji sonde tau putus-putus, te Beta ni, lu deng lu pung turunan dong pung Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ini tana Kanaꞌan samua, nanti Beta kasi sang lu deng lu pung turunan dong. Sakarang lu cuma tenga manumpang sa di sini. Ma nanti lu pung turunan dong soa ini tana Kanaꞌan sampe salamanya. Deng nanti Beta ju jadi dong pung Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Ma lu deng lu pung turunan dong ju musti pegang tarús ini janji deng satia. Samua laki-laki musti sunat. ");
INSERT INTO mkn_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Mulai sakarang, samua laki-laki mulai dari umur dalapan hari, musti sunat. Lu pung kelu, lu pung orang karjá samua, deng budak yang lu su béli ame dari negrí laen, samua musti sunat. Sunat tu, jadi kotong dua pung tanda janji yang makaditi di bosong pung badan. ");
INSERT INTO mkn_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Laki-laki mana yang sonde sunat, sonde dapa bagian dalam Beta pung janji, deng sonde maso jadi Beta pung orang.” ");
INSERT INTO mkn_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ais itu, Tuhan Allah omong tarús lai bilang, “Mulai sakarang ni, lu jang pange lu pung bini, deng nama Sarai lai, ma pange Sara sa. ");
INSERT INTO mkn_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nanti Beta kasi berkat bam-banya sang Sara, ko dia barana kasi lu satu ana laki-laki. Batúl! Nanti Sara jadi banya bangsa pung nene-moyang. Deng nanti Beta angka banya raja dari dia pung turunan.” ");
INSERT INTO mkn_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ju Abraham lipa lutut ko tondo sampe di tana. Ma dalam hati dia ada katawa. Dia pikir bilang, “Laki-laki kakaluk umur 100 taon ke beta ni, masi dapa ana lai? Deng Sara yang su tua ganggók, umur 90 taon, mana masi bisa barana lai?” ");
INSERT INTO mkn_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ju dia kasi tau sang Tuhan bilang, “Tuhan. Biar Ismael sa yang dapa beta pung pusaka ju, sonde apa-apa.” ");
INSERT INTO mkn_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ma Tuhan Allah manyao bilang, “Sonde! Te nanti lu pung bini Sara barana satu ana laki-laki. Lu kasi nama sang dia, Isak. Beta pung janji nanti turun pi sang dia deng dia pung turunan, sampe salamanya. ");
INSERT INTO mkn_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Beta ju su dengar apa yang lu minta kasi Ismael. Tagal itu, Beta ju kasi berkat sang dia, deng Beta bekin tamba banya dia pung turunan. Nanti ada 12 kapala suku dari dia pung turunan. Deng dia pung turunan nanti jadi satu bangsa yang hebat. ");
INSERT INTO mkn_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Biar bagitu, ma Beta pung janji ni taꞌika deng lu pung ana Isak sa. Nanti taon muka, kira-kira waktu bagini, Sara barana sang dia.” ");
INSERT INTO mkn_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Omong abis bagitu, ju Tuhan Allah kasi tenga Abraham sandiri sa di situ. ");
INSERT INTO mkn_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Itu hari ju, Abraham iko memang Tuhan Allah pung parenta. Ju dia sunat. Ais dia sunat sang Ismael deng samua laki-laki dalam dia pung ruma. Dia ju sunat budak laki-laki dong samua. Itu waktu, Abraham su umur 99 taon, deng Ismael umur 13 taon. ");
INSERT INTO mkn_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Satu waktu, Abraham ada tenga deka pohon-pohon bésar di Mamre. TUHAN datang kasi tunju diri sang dia di situ. Dia pung carita bagini: itu hari panas mau mati, jadi Abraham dudu cari angin di muka tenda. ");
INSERT INTO mkn_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Waktu Abraham angka muka, ju dia dapa lia ada tiga orang badiri di sana. Ju dia lari pi sambut sang dong capát-capát. Dia tikam lutut, ");
INSERT INTO mkn_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ais bilang, “Bapa-bapa dong! Kalo bisa, na, bapa dong singga tahan di beta pung tenda dolo. Biar cuma minum aer kosong sa, ju bae. ");
INSERT INTO mkn_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Bapa dong barenti cape di bawa sombar. Nanti ana-ana dong ame aer ko datang cuci bapa dong pung kaki. ");
INSERT INTO mkn_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nanti beta pi sadia makan kasi bapa dong, ko dapa kuat sadiki, baru bapa dong jalan tarús. Te beta sanáng bisa layani sang bapa dong.” Ais ju dong manyao bilang, “Neu. Makasi bam-banya. Botong singga.” ");
INSERT INTO mkn_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ais Abraham lari pi tenda, deng kasi tau sang Sara bilang, “Capát! Ame tarigu yang paling bae satu sak, ko bekin roti.” ");
INSERT INTO mkn_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ais dia lari pi dia pung sapi dong, ko dia pili ame sapi ana satu yang gumuk. Ais dia suru dia pung hamba ko horo itu sapi, deng masa dia pung daging. ");
INSERT INTO mkn_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tarús Abraham pi ame susu, keju, deng daging yang baru masa tu, ais dia bawa kasi itu tamu dong. Waktu dong makan, dia badiri di bawa pohon ko layani sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ais dong tanya sang dia bilang, “Abraham! Lu pung bini Sara, di mana?” Ais dia manyao bilang, “Di dalam tenda.” ");
INSERT INTO mkn_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ju satu dari dong tiga omong bilang, “Kira-kira taon datang, Beta kambali. Itu waktu, lu pung bini Sara su barana ame satu ana laki-laki.” Waktu dong omong bagitu, Sara ada dengar dari balakang pintu. ");
INSERT INTO mkn_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Itu waktu, Abraham deng Sara memang su talalu tua, deng Sara ju su barenti datang bulan. ");
INSERT INTO mkn_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Dengar dong omong bagitu, ju Sara katawa dalam hati. Ju dia pikir bilang, “Aweꞌ! Beta su tua kakaluk bagini, deng beta pung laki su mamalek. Mana ko botong masi kapingin jadi panganten baru, ko cari ana lai?” ");
INSERT INTO mkn_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ais TUHAN tanya sang Abraham bilang, “Akurang ko Sara katawa? Dia pikir apa yang Beta omong ni, sonde bisa jadi, tagal dia su tua, ko? ");
INSERT INTO mkn_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Beta ni, TUHAN! Sonde ada yang Beta sonde bisa bekin! Inga bae-bae, é! Nanti kalo Beta kambali di sini taon datang, Sara su barana ame satu ana laki-laki.” ");
INSERT INTO mkn_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Dengar bagitu, ju Sara taku. Ais dia manyangkal bilang, “Beta sonde katawa, ma!” Ma Tuhan manyao bilang, “Lu tadi memang katawa, ma.” ");
INSERT INTO mkn_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ais, itu tiga tamu dong barangkat mau pi kota Sodom. Ju Abraham antar sang dong sampe di tenga jalan. Dari situ, dong bisa dapa lia kota Sodom. ");
INSERT INTO mkn_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ais TUHAN omong dalam hati bilang, “Lebe bae, Beta carita kasi Abraham, kalo Beta mau kasi ancor kota Sodom. ");
INSERT INTO mkn_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Te dia pung turunan nanti tamba banya, deng jadi bangsa yang hebat. Dia nanti jadi berkat kasi sang samua suku-bangsa di ini dunya ju. ");
INSERT INTO mkn_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Beta su pili ame sang dia, ko ajar dia pung ana-ana deng orang laen dong, iko tarús TUHAN pung jalan, ko dong idop lurus deng jujur. Kalo dong bekin bagitu, Beta bekin jadi Beta pung janji deng Abraham.” ");
INSERT INTO mkn_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ais TUHAN kasi tau sang Abraham bilang, “Bagini! Beta su dengar orang banya dong mangomek soꞌal orang dari kota Sodom deng Gomora. Dong pung jahat, su talalu kalewat. ");
INSERT INTO mkn_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Andia ko Beta turun, ko mau pareksa sandiri, samua yang Beta su dengar tu, batúl ko sonde. Kalo sonde, nanti Beta musti dapa tau.” ");
INSERT INTO mkn_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Waktu TUHAN masi baꞌomong deng Abraham, itu dua tamu dong jalan tarús pi kota Sodom. ");
INSERT INTO mkn_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham pi deka-deka sang Tuhan, ais kokoe bilang, “Karmana? Bapa mau kasi ancor orang bae deng orang jahat sama-sama, ko? ");
INSERT INTO mkn_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kalo ada 50 orang bae dalam itu kota, Bapa masi mau kasi ancor sang dong samua ju, ko? Ko, Bapa sonde kasi ancor itu kota tagal dong. ");
INSERT INTO mkn_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Bapa jang kasi ancor sang dong bagitu! Jang sampe itu orang bae dong ju iko mati, tagal Bapa mau kasi ancor orang jahat dong. Bapa yang jadi Hakim di ini langit deng bumi. Deng Bapa sandiri su tau kalo itu sonde adil.” ");
INSERT INTO mkn_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","TUHAN manyao bilang, “Kalo Beta dapa 50 orang bae di kota Sodom, Beta sonde hukum itu kota, tagal dong.” ");
INSERT INTO mkn_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ju Abraham omong lai bilang, “Bapa, minta ampon, kalo beta bisa omong sadiki lai. Beta ni, cuma manusia bodo yang sonde tau apa-apa. ");
INSERT INTO mkn_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Andekata sonde sampe 50 orang bae, ma cuma dapa 45 sa, karmana? Kalo kurang lima orang sa, Bapa masi mau bekin ancor itu kota, ko?” Tuhan manyao bilang, “Kalo Beta dapa 45 orang bae di situ, na, Beta sonde bekin ancor itu kota.” ");
INSERT INTO mkn_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ais Abraham kokoe lai bilang, “Kalo cuma dapa 40 orang sa, karmana, Bapa?” Ju Dia manyao bilang, “Kalo Beta dapa 40, Beta sonde hukum sang dong.” ");
INSERT INTO mkn_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham kokoe tarús lai bilang, “Bapa jang mara, ma andekata cuma 30 orang bae sa, karmana?” Dia manyao bilang, “Kalo Beta dapa 30 orang, Beta sonde jadi hukum sang dong.” ");
INSERT INTO mkn_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ais Abraham tawar lai bilang, “Bapa jang mara kalo beta tanya lai sadiki. Kalo cuma dapa 20 orang sa, karmana?” Ju Dia manyao lai bilang, “Kalo dapa 20 orang, Beta sonde akan kasi ancor itu kota.” ");
INSERT INTO mkn_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ju Abraham konci dia pung omong bilang, “Bapa! Beta omong satu kali lai, ma jang mara sang beta, ó! Karmana kalo cuma dapa 10 orang bae sa?” Ju Dia manyao bilang, “Kalo Beta dapa 10 orang bae di situ, Beta sonde kasi ancor itu kota.” ");
INSERT INTO mkn_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Baꞌomong abis bagitu, TUHAN jalan tarús, ais Abraham pulang. ");
INSERT INTO mkn_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Waktu Tuhan masi baꞌomong deng Abraham, Dia pung ana bua dua pi tarús di kota Sodom. Dong sampe di sana, ju matahari su mau tanggalám. Itu waktu, Lot masi dudu di kota pung pintu maso. Dapa lia itu dua orang, ju dia pi sambut sang dong. Tarús dia tikam lutut deng tondo di dong pung muka. ");
INSERT INTO mkn_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ais dia omong bilang, “Bapa dong! Mari ko singga tahan di beta pung ruma dolo. Biar ko bapa dong cuci kaki, ais tidor di sana. Nanti beso papagi, baru bapa dong jalan tarús.” Ma dong manyao bilang, “Tarima kasi. Ma sonde usa repot! Biar botong tidor di kota pung tana lapang sa.” ");
INSERT INTO mkn_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ma Lot kokoe tarús sang dong, sampe dong mau manumpang di dia pung ruma. Ais Lot dong bakar roti deng ator meja, ju dong makan rame-rame. ");
INSERT INTO mkn_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Itu tamu dong balóm pi tidor, te laki-laki Sodom dong, kici-bésar samua, datang kuliling Lot pung ruma. ");
INSERT INTO mkn_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Dong batarea kasar-kasar sang Lot bilang, “He, Lot! Itu laki-laki dua tadi di mana? Kasi kaluar sang dong datang, te botong mau nae sang dong!” ");
INSERT INTO mkn_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tarús Lot kaluar, ais tutu pintu. ");
INSERT INTO mkn_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Dia omong bilang, “Sodara dong! Bosong jang bekin jahat bagitu deng beta pung tamu. ");
INSERT INTO mkn_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Bosong coba dengar, é? Beta pung ana nona dua orang. Dong masi parawan. Biar beta kasi dong dua sang bosong. Bosong mau bekin apa sang dong, tarsará sa. Ma bosong jang bekin apa-apa deng beta pung tamu. Te iko kotong pung adat, beta musti jaga babae sang dong.” ");
INSERT INTO mkn_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ma itu orang Sodom dong batarea bilang, “Lu jang iko campor! Te lu ni, cuma orang manumpang sa di sini! Lu orang luar, jadi lu sonde ada hak ator sang botong. Lebe bae lu iskarobis dari sini. Kalo sonde, botong bekin sang lu lebe barát dari itu dua orang!” Ais dong tola buang sang Lot, ju dong rame-rame pi tabrak, ko mau bekin ancor itu pintu. ");
INSERT INTO mkn_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ma itu dua tamu sorong tangan ko hela kasi maso sang Lot pi dalam ruma, ju dong konci pintu. ");
INSERT INTO mkn_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ais dong dua bekin buta itu orang Sodom dong pung mata, sampe dong raba-raba cari pintu, ma sonde dapa. ");
INSERT INTO mkn_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Ais ju itu dua tamu omong deng Lot bilang, “Lot! TUHAN su tau ini kota pung jahat. Jadi Dia kirim sang botong datang ko mau kasi ancor bekin abis ini kota. Jadi lu masi ada pung kelu laen di ini kota, ko sonde? Kalo ada ana laki-laki, ko parampuan, ko ana mantu, ko sapa sa, na, pi ame bawa sang dong kaluar dari ini kota su!” ");
INSERT INTO mkn_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tarús Lot pi katumu dia pung calon ana mantu dua orang, ais dia kasi tau bilang, “Dengar bae-bae! Sakarang bosong kaluar capát-capát dari ini kota suda, te TUHAN su mau bekin ancor sang dia!” Ma dong kira Lot cuma omong maen gila sa. ");
INSERT INTO mkn_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Dia pung beso papagi, ju Tuhan pung ana bua dua orang tu, paksa sang Lot ko dong kaluar capát-capát suda. Dong bilang, “Lot! Bangun suda! Hela bawa lu pung bini, deng itu ana parampuan dua-dua, ko bosong lari suda. Kasi tenga ini kota. Jang sampe bosong mati bodo-bodo, deng ancor sama-sama deng ini kota.” ");
INSERT INTO mkn_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ma Lot masi baꞌeok. Padahal TUHAN mau kasi salamat sang dia. Andia ko itu tamu dua-dua pegang dong pung tangan ko hela sang Lot, dia pung bini, deng dia pung ana parampuan dua, ko bawa kaluar sang dong dari itu kota. ");
INSERT INTO mkn_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tarús satu dari itu dua tamu parenta bilang, “Lari capát-capát, ko cari salamat suda! Jang lia pi balakang! Jang barenti di lemba! Lari nae tarús pi gunung sana, ko biar bosong jang mati!” ");
INSERT INTO mkn_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ma Lot balas bilang, “Aduu, pak! Jang bagitu! ");
INSERT INTO mkn_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Pak memang su tolong kasi salamat sang botong. Ma itu gunung talalu jao! Jang-jangan botong balóm sampe di sana, te bahaya su buru dapa sang botong di tenga jalan. ");
INSERT INTO mkn_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Pak lia dolo. Ada satu kampong kici sonde jao dari sini. Itu kampong sonde ada pung arti apa-apa. Jadi kalo pak mau, na, biar botong pi cari salamat di situ sa.” ");
INSERT INTO mkn_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ju dia manyao bilang, “Neu! Pi suda! Nanti beta sonde kasi ancor itu kampong. ");
INSERT INTO mkn_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Jadi sakarang bosong lari capát suda pi sana! Te beta sonde bisa bekin apa-apa, kalo bosong balóm sampe di sana.” Mulai dari itu waktu, orang kasi nama itu kampong Soar, yang dia pung arti ‘kici’. ");
INSERT INTO mkn_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Waktu matahari mulai nae, Lot dong sampe di Soar. ");
INSERT INTO mkn_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Takuju sa, TUHAN poꞌa api deng balerang tabakar dari langit turun pi Sodom deng Gomora. ");
INSERT INTO mkn_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","TUHAN bekin ancor abis samua kota deng kampong di itu daꞌera, deng samua yang idop di situ, andia: manusia, binatang, deng tanaman dong. ");
INSERT INTO mkn_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Waktu dong lari, Lot pung bini lia pi balakang. Takuju sa, dia jadi tiang garam memang. ");
INSERT INTO mkn_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Dia pung beso papagi, Abraham pi ulang lai di tampa yang kamaren dia badiri ko kokoe sang TUHAN. ");
INSERT INTO mkn_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ju dia lia turun pi Sodom deng Gomora, deng itu lemba samua. Dia lia, te di mana-mana asap kabuak-kabuak nae pi langit. Deng api makan bekin abis samua. ");
INSERT INTO mkn_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tuhan Allah tolong sang Lot kaluar dari itu tampa yang kaná hukum, waktu Dia bekin ancor itu kota-kota dong, tagal Dia inga Dia pung janji sang Abraham. ");
INSERT INTO mkn_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Itu waktu, Lot taku tenga tarús di kampong Soar. Andia ko dia deng dia pung ana parampuan dua orang pinda pi gunung. Ais dong tenga dalam goa satu. ");
INSERT INTO mkn_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Satu kali, ana parampuan yang kaka omong deng dia pung adi bilang, “Kuliling di sini, sonde ada satu laki-laki yang bisa datang kawin deng kotong. Deng sonde lama lai, bapa tamba tua, deng su sonde bisa dapa ana lai. ");
INSERT INTO mkn_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Jadi lebe bae, kotong kasi minum mabo sang bapa. Ais kotong tidor deng dia, ko biar kotong bisa sambung bapa pung turunan.” ");
INSERT INTO mkn_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ju itu malam, dong kasi minum bekin mabo dong pung bapa deng anggor. Ais ju ana yang kaka pi tidor deng dia pung bapa. Ma bapatua talalu mabo, sampe dia sonde tau dia su bekin apa deng dia pung ana parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Dia pung beso, ju kaka kasi tau dia pung adi bilang, “Adi! Tadi malam beta su tidor deng bapa. Ini malam, lu pung bagian. Nanti kotong bekin mabo sang bapa lai, ais adi maso pi tidor deng dia. Deng bagitu, kotong dua sama-sama bisa dapa ana, ko sambung bapa pung turunan.” ");
INSERT INTO mkn_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Itu malam ju, dong bekin mabo lai dong pung bapa. Ais ana bungsu maso pi tidor deng dia pung bapa. Ma bapatua su talalu mabo, sampe dia sonde tau dia su bekin apa deng dia pung ana parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Deng bagitu, dong dua dudu parú dari dong pung bapa barana sandiri. ");
INSERT INTO mkn_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ais ju ana yang kaka, barana ame satu ana laki-laki. Ju dia kasi nama, Moab (yang dia pung bunyi amper sama ke satu kata laen, yang dia pung arti ‘datang dari bapa’). Dia yang jadi orang Moab yang ada sakarang, pung nene-moyang. ");
INSERT INTO mkn_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ais ana yang adi, ju barana ame satu ana laki-laki. Dia kasi nama, Ben Ami (yang dia pung arti ‘ana dari beta pung orang’). Dia tu, jadi orang Amon yang ada sakarang, pung nene-moyang. ");
INSERT INTO mkn_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ais itu, Abraham pinda dari Mamre, pi tana Negeb yang di sablá salatan, deng dia tenga di kampong Kades deng kampong Syur pung teng-tenga. Ma sonde lama, ju dia pinda lai pi kampong Gerar. ");
INSERT INTO mkn_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ju dia kasi tau orang-orang di sana bilang, Sara tu, dia pung adi. Andia ko Abimelek, raja Gerar, suru dia pung orang-orang dong pi minta sang Sara, ais bawa sang dia pi raja pung ruma jabatan. ");
INSERT INTO mkn_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Satu malam, Tuhan Allah kasi tunju diri sang raja dalam mimpi. Dia omong bilang, “Lu su mau mati, andia ni! Te lu ada ame orang pung bini na.” ");
INSERT INTO mkn_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Ma Abimelek manyao bilang, “Tuhan! Beta balóm sonto itu parampuan. Deng beta ju sonde sala. Abraham sandiri yang bilang, itu parampuan, dia pung adi! Deng itu parampuan ju mangaku bagitu. Andia ko beta suru pi ame sang dia deng hati barisi. Jadi Tuhan jang kasi sala sang beta!” ");
INSERT INTO mkn_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ju Tuhan manyao bilang, “Memang Beta tau lu pung hati barisi. Deng Beta yang tahan, ko lu jang sonto itu parampuan. Deng bagitu, lu ju sonde bekin sala sang Beta. ");
INSERT INTO mkn_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sakarang lu kirim pulang itu parampuan pi dia pung laki. Dia tu, Beta pung jubir. Jadi minta sang dia ko sambayang kasi sang lu, ko biar lu jang mati. Ma kalo lu sonde kasi kambali itu parampuan, lu inga bae-bae! Te lu deng lu pung orang samua nanti mati, andia tu.” ");
INSERT INTO mkn_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Beso papagi, ju raja pange dia pung pagawe samua, ais carita dia pung mimpi. Ju dong samua jadi taku. ");
INSERT INTO mkn_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ais raja pange sang Abraham, ju dia tanya bilang, “Beta ada bekin sala apa sang lu, sampe lu bekin calaka sang beta deng beta pung rakyat dong bagini? Lu sonde bole bekin hal yang tar bae bagini. ");
INSERT INTO mkn_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Lu pikir apa, sampe lu bekin bagini?” ");
INSERT INTO mkn_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ju Abraham manyao bilang, “Bapa raja! Beta pikir bosong samua orang yang sonde kanál sang Tuhan Allah. Jadi tantu ada yang mau bunu sang beta, ko biar bisa ame beta pung bini. ");
INSERT INTO mkn_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Beta memang omong batúl bilang, beta pung adi sang dia. Te botong dua satu bapa, ma laen mama. Andia ko botong baꞌame jadi laki-bini. ");
INSERT INTO mkn_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Jadi waktu Tuhan Allah suru botong pi maranto, beta kasi tau beta pung bini bilang, ‘Kalo kotong pi mana-mana, ais ada orang tanya kotong dua pung hubungan, deng kalo lu sayang sang beta, na, manyao bilang, botong dua bakaka-adi.’ ” ");
INSERT INTO mkn_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Ais ju raja Abimelek kasi pulang sang Sara. Ju dia omong deng Sara bilang, “Sakarang beta bayar kasi lu pung kaka saribu doi perak, ko jadi bukti bilang, beta sonde bekin sala apa-apa deng lu. Biar samua orang tau bagitu!” Ais raja omong deng Abraham bilang, “Abraham! Beta pung negrí ni, tabuka buat lu. Lu mau pi tenga di mana sa, bole.” Ais dia ju kasi sang Abraham, sapi deng kambing-domba. Dia ju kasi hamba laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Dolu TUHAN su tutu tampa ana dari samua parampuan yang tenga di Abimelek pung daꞌera, tagal dia su rampas ame Abraham pung bini. Ma waktu raja kasi pulang Sara pi dia pung laki, ju Abraham sambayang, ko Tuhan buka ulang lai itu parampuan dong pung tampa ana. Ju dong bisa barana lai. ");
INSERT INTO mkn_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Ais itu, ju TUHAN kasi berkat sang Sara, iko Dia pung janji. Abraham su tua, deng Sara su dudu parú. Waktu dia mau barana tu, Abraham pung umur su 100 taon. Ais pas dia pung waktu, ju dia barana ana laki-laki satu. Ju Abraham kasi nama itu ana, Isak (yang dia pung arti ‘dia katawa’). Sara ju omong bilang, “Tuhan Allah bekin beta katawa, tagal sakarang beta sanáng. Orang dong pikir, sonde mungkin beta dapa ana di hari tua bagini. Padahal, biar beta pung laki su tua kakaluk, ma beta masi barana kasi sang dia. Jadi sakarang, sapa sa yang dengar ini hal, dong ju iko katawa sama-sama deng beta.” Waktu Isak umur dalapan hari, Abraham sunat sang dia, iko Tuhan Allah pung parenta. ");
INSERT INTO mkn_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ais ju Isak tamba bésar. Waktu mau sole sang dia, Abraham bekin pesta bésar. ");
INSERT INTO mkn_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Satu kali, Sara lia Abraham pung bini muda, Hagar pung ana Ismael, ada maen baganggu deng Isak. Lia bagitu, ju Sara baꞌomong deng dia pung laki bilang, “Usir itu budak dari Masir deng dia pung ana suda! Te beta sonde mau itu ana budak tarima pusaka apa-apa. Cuma beta pung ana Isak sa, yang musti dapa samua.” ");
INSERT INTO mkn_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Dengar Sara pung omong bagitu, ju Abraham rasa tar enak, tagal Ismael tu, dia pung ana ju. ");
INSERT INTO mkn_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ma Tuhan Allah omong deng Abraham bilang, “Bram! Lu jang pikir itu bini muda deng dia pung ana. Iko Sara pung mau sa, tagal nanti lu dapa turunan yang Beta su janji tu, lewat Isak. ");
INSERT INTO mkn_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma Beta ju kasi berkat sang lu pung bini muda pung ana, tagal dia ju lu pung ana sandiri. Nanti dia pung turunan ju jadi satu bangsa.” ");
INSERT INTO mkn_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Dia pung beso papagi, ju Abraham bekin bakál ko kasi Hagar, deng gantong aer satu botol di dia pung bahu. Ais dia kasi lapás sang itu parampuan deng Ismael ko dong jalan suda. Ais ju dong jalan kuliling di tana kosong deka Beer Syeba. ");
INSERT INTO mkn_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Waktu dong pung aer minum su abis, ju Hagar kasi tenga dia pung ana di satu pohon kici pung sombar. ");
INSERT INTO mkn_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ju dia pikir dalam hati bilang, “Beta sonde bisa tahan lai, lia ini ana pung mati.” Ais dia ondor ko dudu kira-kira 50 meter dari itu ana. Ju dia manangis makarereu. ");
INSERT INTO mkn_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Tuhan Allah ju dengar Ismael pung suara manangis, ais Dia pung ana bua dari sorga pange sang Hagar bilang, “Hagar! Akurang ko lu susa bagini? Jang taku, te Tuhan su dengar itu ana pung manangis. ");
INSERT INTO mkn_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Sakarang lu bangun ko pi lia itu ana. Kasi kuat dia pung hati, te nanti Beta mau bekin dia pung turunan jadi satu bangsa yang hebat.” ");
INSERT INTO mkn_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ais ju Tuhan Allah bekin taráng dia pung mata, sampe dia dapa lia satu parigi di situ. Ju dia pi isi aer di itu botol, ais dia pi kasi minum dia pung ana. ");
INSERT INTO mkn_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Ju Ismael deng dia pung mama tenga di padang pasir Paran. Dia bésar datang, ju dia jadi jago bapana. Ais itu, dia pung mama kasi kawin dia deng nona Masir satu. Samua ni jadi, tagal Tuhan Allah ada sama-sama deng Ismael. ");
INSERT INTO mkn_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Itu waktu, raja Abimelek deng dia pung panglima paráng, nama Fikol, datang katumu sang Abraham. Raja omong bilang, “Abraham! Botong su tau bilang, Tuhan Allah ada sama-sama deng lu. Andia ko, lu bekin apa sa, samua jadi. ");
INSERT INTO mkn_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Jadi sakarang beta minta lu angka sumpa di Tuhan Allah pung muka bilang, lu sonde akan putar-balek sang beta deng beta pung ana-cucu dong. Sama ke beta su kasi tunju hati bae deng lu, na, lu ju musti kasi tunju hati bae sang beta deng ini negrí.” ");
INSERT INTO mkn_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ju Abraham manyao bilang, “Neu! Beta sumpa.” ");
INSERT INTO mkn_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ma ais itu, ju Abraham lapor sang raja bilang, “Bapa raja pung orang dong ada rampas ame beta pung parigi satu.” ");
INSERT INTO mkn_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Dengar bagitu, ju raja manyao bilang, “Waa! Beta baru dengar ini hal. Akurang ko bapa sonde lapor dari dolu? Beta sonde tau sapa yang bekin.” ");
INSERT INTO mkn_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Ais itu, Abraham deng Abimelek baꞌika janji. Ju Abraham ame sapi deng domba ko kasi sang raja. Ais ju dia pili kasi kaluar tamba lai domba ténak tuju ekor. ");
INSERT INTO mkn_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ju raja tanya sang dia bilang, “Akurang ko lu bekin bagitu?” ");
INSERT INTO mkn_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Tarús Abraham kasi tau bilang, “Bapa raja tarima ini domba ténak tuju ekor ko jadi tanda bilang, bapa raja mangaku, beta yang gali ini parigi.” ");
INSERT INTO mkn_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tagal dong dua su angka sumpa di situ, ju dong kasi nama itu tampa, Beer Syeba. Dia pung arti bilang, ‘Parigi Sumpa’. ");
INSERT INTO mkn_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Dong basumpa abis, ju raja Abimelek deng dia pung panglima pulang pi dong pung negrí Filistin. ");
INSERT INTO mkn_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ais itu, Abraham tanam satu pohon tamareska di Beer Syeba. Mulai dari itu waktu, itu pohon kasi inga sang Abraham, ko di situ dia sémba sang TUHAN yang Idop Sampe Salamanya. ");
INSERT INTO mkn_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ais ju Abraham tenga manumpang sampe lama di itu orang Filistin dong pung negrí. ");
INSERT INTO mkn_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Sonde lama lai, ju Tuhan uji sang Abraham, ko mau lia dia dengar sang Tuhan, ko sonde. Ais Tuhan pange sang dia bilang, “Abraham!” Ju dia manyao bilang, “Ia, Tuhan.” ");
INSERT INTO mkn_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ais Tuhan Allah suru sang dia bilang, “Dengar bae-bae! Ame lu pung ana satu biji yang lu paling sayang. Bawa sang dia pi tana Moria, ko lu bekin sang dia jadi korban bakar kasi Beta. Sampe di sana, baru Beta kasi tunju sang lu dia pung tampa di satu gunung.” ");
INSERT INTO mkn_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Dia pung beso papagi, ju Abraham potong kayu api. Ais dia ika-ika itu kayu dong, ju mua di atas binatang keledai. Tarús dia deng Isak, deng dia pung hamba dua orang, barangkat pi di tampa yang Tuhan su kasi tau sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Dong jalan-jalan, ju dia pung lusa, Abraham dapa lia itu tampa dari jao. ");
INSERT INTO mkn_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ais dia kasi tau sang itu dua hamba bilang, “Bosong dua tenga tahan di sini deng ini keledai, é! Beta deng be pung ana mau pi atas sana, ko mau sémba sang Tuhan. Abis, baru botong kambali datang sini lai.” ");
INSERT INTO mkn_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Tarús Abraham ame itu kayu api buat bakar korban, ko kasi nae di Isak pung bahu. Deng dia sandiri bawa piso deng kayu yang ada api. Waktu dong dua ada bajalan sama-sama, ");
INSERT INTO mkn_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ju Isak pange sang dia pung bapa bilang, “Papa!” Ais Abraham manyao bilang, “Kanapa, Isak?” Tarús Isak tanya bilang, “Papa. Kotong mau bakar korban. Di sini su ada dia pung kayu, deng dia pung api. Ma domba ana yang kotong pake jadi korban ada di mana?” ");
INSERT INTO mkn_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ais Abraham manyao bilang, “Ana, é! Nanti Tuhan Allah sandiri yang kasi Dia pung domba ana ko pake jadi korban.” Ju dong dua jalan nae tarús. ");
INSERT INTO mkn_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Waktu dong sampe di tampa yang Tuhan su kasi tau tu, ju Abraham susun batu ko bekin meja tampa bakar korban. Ais dia ator kayu api di atas meja batu. Ju dia ika dia pung ana, ko kasi tidor malenggang di atas kayu bakar. ");
INSERT INTO mkn_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Tarús dia ame piso ko mau bunu dia pung ana. ");
INSERT INTO mkn_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ma takuju sa, TUHAN pung ana bua batarea dari langit bilang, “We! Bram! Tunggu dolo!” Ju dia manyao bilang, “Ada apa, Tuhan?” ");
INSERT INTO mkn_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tarús itu suara bilang, “Lu jang bunu itu ana! Jang bekin apa-apa sang dia! Sakarang Beta su tau bilang, lu batúl-batúl iko Tuhan pung mau, tagal lu su siap kasi sang Tuhan lu pung ana satu biji tu, ko jadi korban.” ");
INSERT INTO mkn_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ais itu, Abraham dapa lia satu domba laki yang dia pung tandok tagaꞌe di pohon kici pung cabang dong. Ais Abraham pi ame memang itu domba, ko dia bakar jadi korban kasi sang Tuhan Allah, ganti dia pung ana. ");
INSERT INTO mkn_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Jadi Abraham kasi nama itu tampa, ‘Tuhan nanti sadia kasi apa yang parlú.’ Andia ko sampe sakarang ju orang omong bilang, “Di atas TUHAN pung gunung tu, nanti Dia sadia kasi apa yang parlú.” ");
INSERT INTO mkn_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ais ju Tuhan pung ana bua batarea ulang lai dari langit bilang, ");
INSERT INTO mkn_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“TUHAN sandiri bilang, ‘Beta sumpa pake Beta pung nama sandiri, bagini: lu su siap kasi sang Beta lu pung ana satu biji ko jadi korban. Andia ko ");
INSERT INTO mkn_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Beta nanti kasi berkat bam-banya sang lu deng lu pung turunan. Nanti dong tamba banya sampe sonde ada orang yang bisa itong ame sang dong, sama ke bintang di langit deng pasir di pante. Lu pung ana-cucu dong nanti kasi kala dong pung musu-musu. ");
INSERT INTO mkn_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Dari lu pung turunan, nanti samua suku-bangsa di dunya dapa berkat, tagal lu su iko Beta pung parenta.’ ” ");
INSERT INTO mkn_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ais itu, Abraham deng Isak turun kambali pi dong pung dua hamba, ko dong pulang sama-sama pi Beer Syeba. Abraham dong tenga di sana. ");
INSERT INTO mkn_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Satu kali, Abraham dapa dengar bilang, dia pung adi Nahor pung bini Milka su barana ame ana-ana. ");
INSERT INTO mkn_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ana sulung, nama Us. Dia pung adi, nama Bus. Ais itu, Kemuel (yang jadi Aram pung bapa). ");
INSERT INTO mkn_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Ais ada Kesed, Haso, Pildas, Yidlaf, deng Betuel. ");
INSERT INTO mkn_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel tu, Ribka pung bapa. ");
INSERT INTO mkn_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ma Nahor ju dapa tamba ana-ana dari dia pung bini piara, nama Reuma. Dia barana sang Teba, Gaham, Tahas, deng Maaka. ");
INSERT INTO mkn_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sara mati waktu dia pung umur su 127 taon. Waktu dia pung mati tu, Abraham dong ada tenga di kampong Kiryat-Arba (andia Hebron), di tana Kanaꞌan. Abraham manangis makarereu deng mete dia pung bini yang su mati. ");
INSERT INTO mkn_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ais Abraham pi katumu sang orang Het dong. Ju dia omong bilang, ");
INSERT INTO mkn_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Beta ni cuma manumpang di bosong pung teng-tenga. Beta sonde ada pung tana ko kubur beta pung bini. Jadi kalo bosong mau, na, kasi beta béli ame bosong pung tana sapoꞌong, ko biar beta kubur sang dia di situ.” ");
INSERT INTO mkn_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ju dong manyao bilang, ");
INSERT INTO mkn_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Bagini, bapa! Bagini lama, botong su pandang sang bapa, sama ke orang tua satu yang botong hormat batúl. Jadi bapa pili sa, tana mana yang paling bae, yang cocok deng bapa pung mau. Botong tarima bae sa, sonde ada yang tolak.” ");
INSERT INTO mkn_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tarús Abraham badiri, ais tondo ko kasi hormat sang tuan tana, orang Het dong. ");
INSERT INTO mkn_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ais dia bilang, “Kalo bosong tarima beta pung omong tadi, na, beta minta tolong bosong ko omong deng bapatua Sohar pung ana laki-laki, Efron. ");
INSERT INTO mkn_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Minta, kalo bisa na, dia jual kasi beta dia pung goa, nama Makpela, yang ada di dia pung kabón pung pinggir. Dia minta harga barapa sa, beta bayar. Beta mau bayar putus dia pung harga di bosong samua pung muka, ko biar itu tana jadi beta pung hak milik. Beta mau bekin sang dia jadi botong pung tampa kubur.” ");
INSERT INTO mkn_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Itu waktu, Efron sandiri ada iko dudu deng orang Het dong. Jadi dia ju dengar Abraham pung omong tu. Ais dia badiri ko manyao sang Abraham di muka orang tua-tua dong samua bilang, ");
INSERT INTO mkn_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Jang bagitu, bapa! Bagini sa. Beta kasi sa itu kabón deng dia pung goa Makpela sang bapa. Bapa kubur sa bapa pung bini di situ. Beta sarakan itu tana sang bapa di muka beta pung orang dong. Biar ko dong samua jadi saksi!” ");
INSERT INTO mkn_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ais Abraham tondo lai di muka orang Het dong. ");
INSERT INTO mkn_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ju dia omong deng Efron bilang, “Bagitu ju bae, ma bosong samua dengar sang beta dolo. Beta mau béli putus itu tana, ko biar beta kubur beta pung orang dong di situ.” ");
INSERT INTO mkn_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Ais ju Efron manyao bilang, “Itu tana pung harga cuma ampa ratus doi perak sa. Buat apa kotong dua batawar pi-datang deng doi sadiki ana tu? Bapa pi ko kubur bapa pung bini di situ suda.” ");
INSERT INTO mkn_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham satuju deng itu tana pung harga, iko Efron pung omong. Jadi di muka samua orang Het yang jadi saksi di situ, dia itong doi perak ampa ratus biji, ais bayar kasi sang Efron. ");
INSERT INTO mkn_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","Jadi deng bagitu Abraham dapa Efron pung tana, jadi dia pung milik. Andia itu tana yang ada di Makpela, deka deng Mamre (andia Hebron). Dia béli putus itu tana deng dia pung kabón, dia pung goa, deng dia pung pohon-pohon samua. Samua tua-tua orang Het jadi saksi bilang itu tana deng dia pung isi samua, Abraham pung hak milik. Ais ju Abraham pi kubur sang Sara di dalam itu goa, di tana Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Deng bagitu, itu kabón deng dia pung goa yang dolu orang Het dong pung tana, sakarang su jadi Abraham pung tana milik, ko dia pake jadi kerkof. ");
INSERT INTO mkn_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham pung umur panjang sampe dia su talalu tua. Deng TUHAN jaga bae-bae sang dia, ais kasi dia idop deng dame-sajahtra. ");
INSERT INTO mkn_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Abraham ada pung orang parcaya satu, yang urus dia pung harta samua. Satu kali, Abraham pange sang dia bilang, “Dengar bae-bae! Beta minta lu sumpa mati, pake TUHAN pung nama. Andia Tuhan Allah yang bekin ame langit deng bumi. Bilang, lu sonde bole ame nona dari ini orang Kanaꞌan dong, ko kasi kawin deng beta pung ana Isak. ");
INSERT INTO mkn_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ma lu musti pi di beta pung negrí asal, di beta pung kelu dong. Lu cari ame satu nona di situ ko kotong kasi kawin deng beta pung ana.” ");
INSERT INTO mkn_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ais itu hamba tanya sang Abraham bilang. “Bae, bapa! Ma karmana kalo itu nona sonde mau iko datang sini? Kalo bagitu, na, beta musti bawa bapa pung ana ko pi kawin di sana, ko karmana?” ");
INSERT INTO mkn_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham manyao bilang, “Lu inga bae-bae! Biar karmana ju, lu sonde bole bawa beta pung ana pi sana! ");
INSERT INTO mkn_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Inga te TUHAN yang pegang kuasa di langit, su bawa kaluar sang beta dari beta pung negrí asal, ais antar sang beta sampe di ini tana. Dia ju su ika janji deng beta bilang, ‘Nanti Beta kasi ini tana samua sang lu pung turunan.’ Jadi lu jang kawatir! Lu pi sa. Te nanti Tuhan suru Dia pung ana bua dari sorga datang buka jalan kasi sang lu, ko lu bisa katumu itu nona yang nanti jadi beta pung ana pung bini. ");
INSERT INTO mkn_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ma kalo itu nona sonde mau iko sang lu datang sini, na, lu bebas dari ini sumpa. Biar karmana ju, lu jang bawa beta pung ana pi sana.” ");
INSERT INTO mkn_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ais, itu hamba angka sumpa sang Abraham bilang, nanti dia bekin iko Abraham pung mau samua. ");
INSERT INTO mkn_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tarús itu hamba pili ame onta sapulu ekor. Ais dia mua macam-macam barang yang bagus di itu onta dong. Ju dia barangkat pi Nahor pung kota di Mesopotamia. ");
INSERT INTO mkn_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ahirnya, itu hamba sampe di itu kota. Ais dia deng dia pung onta dong barenti cape di pinggir kota, deka satu parigi. Itu waktu su sore, pas deng ana-ana parampuan dong ada pi timba aer di itu parigi. ");
INSERT INTO mkn_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ais, itu hamba sambayang bilang, “TUHAN, beta pung bos Abraham pung Allah. Tolong buka jalan ko biar beta pung jalan ni dapa hasil yang bae. Kasi tunju Tuhan pung hati bae sang beta pung bos, deng inga dia pung janji kasi sang beta. Jadi biar ko beta dapa katumu Isak pung calon bini. ");
INSERT INTO mkn_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tuhan, beta ada badiri di pinggir parigi ni. Deng nona-nona dari kota ada datang timba aer di sini. ");
INSERT INTO mkn_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Jadi beta minta bagini: kalo beta omong deng satu nona bilang, ‘Nona, é. Tolong kasi turun lu pung pareuk aer ko kasi beta minum sadiki dolo.’ Kalo dia manyao bilang, ‘Bapa minum sa. Deng nanti beta kasi minum bapa pung onta dong ju.’ Naa, itu jadi tanda bilang, itu nona yang Tuhan su pili jadi Isak pung bini! Deng tanda yang bagitu, beta bisa tau bilang, Tuhan su kasi tunju Tuhan pung bae sang beta pung bos, Abraham.” ");
INSERT INTO mkn_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Dia balóm abis sambayang, te satu nona datang. Dia pung nama Ribka. Dia tu, Abraham pung adi Nahor deng dia pung bini Milka pung cucu. Ribka pung bapa, nama Betuel. Ribka tu, talalu manis deng masi parawan. Dia turun pi dalam itu parigi, ju isi dia pung pareuk aer, ais nae kambali. ");
INSERT INTO mkn_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Waktu Ribka sampe di atas, ju Abraham pung hamba lari pi sang dia. Ais dia minta bilang, “Nona. Tolong kasi beta minum sadiki dolo.” ");
INSERT INTO mkn_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ais, itu nona manyao bilang, “Minum sa, om!” Tarús dia kasi turun capát-capát dia pung pareuk aer, ko kasi minum itu hamba. ");
INSERT INTO mkn_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Minum abis ju, itu nona bilang, “Biar ko beta timba aer kasi minum om pung onta dong, sampe dong puas.” ");
INSERT INTO mkn_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tarús dia pi poꞌa aer pung sisa di binatang dong pung tampa minum. Ais dia lari turun-nae timba aer dari itu parigi, ko kasi minum itu onta dong samua, sampe dong puas. ");
INSERT INTO mkn_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Abraham pung hamba badiri diam-diam, ko pasang mata lia itu nona pung karjá. Dia pikir-pikir bilang, “Ini nona yang Tuhan pili, ko?” ");
INSERT INTO mkn_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Itu onta dong samua minum sampe puas. Ju itu hamba ame cincin idong mas, deng satu pasang galáng mas ko taro di itu nona pung tangan dua-dua. ");
INSERT INTO mkn_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ais, itu hamba tanya bilang, “Nona pung bapa, nama sapa? Kalo bisa, na, beta manumpang tidor di nona pung bapa pung ruma.” ");
INSERT INTO mkn_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ju itu nona manyao bilang, “Beta pung bapa, nama Betuel. Beta pung baꞌi, Nahor. Deng beta pung nene, Milka. ");
INSERT INTO mkn_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Di botong pung ruma ada tampa tidor cukup kasi om dong. Deng ada rumput banya kasi om pung binatang dong.” ");
INSERT INTO mkn_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ais, itu hamba tondo ko sémba sang TUHAN. ");
INSERT INTO mkn_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ju dia omong bilang, “Puji Tuhan! Tuhan su buka jalan kasi sang beta, sampe beta su dapa katumu langsung deng bos Abraham pung kelu di sini. Deng bagitu, Tuhan su kasi tunju Tuhan pung hati bae kasi sang beta pung bos Abraham, deng su bekin jadi dia pung janji sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ais, itu nona lari pulang capát-capát, ko carita kasi isi ruma dong samua, apa yang su jadi. ");
INSERT INTO mkn_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka pung kaka laki-laki, nama Laban. Waktu dia lia itu barang mas, deng dengar Ribka pung carita, tarús Laban lari kaluar capát-capát, ko pi katumu deng itu hamba yang masi badiri deng dia pung onta dong deka itu parigi. ");
INSERT INTO mkn_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ais Laban omong bilang, “Om! TUHAN su antar sang om deng salamat sampe sini. Jadi jang badiri di luar sini! Mari pi di botong pung ruma. Botong su sadia kamar. Makanan buat om pung onta dong ju malimpa.” ");
INSERT INTO mkn_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ais ju Abraham pung hamba iko sang Laban, ko maso pi di Betuel pung ruma. Tarús Laban dong bantu kasi turun muatan dari onta dong. Ais dong kasi onta dong makan rumput. Dong ju bawa aer ko itu hamba deng dia pung orang dong cuci kaki. ");
INSERT INTO mkn_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Waktu dong ator makan di meja, ju itu hamba bilang, “Botong ada mau makan, ma beta minta parmisi ko mau kasi tau satu maksud dolo.” Ju Laban manyao bilang, “Om, omong sa.” ");
INSERT INTO mkn_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tarús itu hamba bilang, “Beta ni, bosong pung baꞌi Abraham pung hamba. ");
INSERT INTO mkn_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","TUHAN su kasi berkat bam-banya sang beta pung bos, sampe dia jadi talalu kaya. Tuhan su kasi sang dia mas-perak, hamba laki-laki deng parampuan, deng binatang bam-banya, andia: sapi, onta, keledai, deng kambing-domba. ");
INSERT INTO mkn_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Waktu beta pung bos laki-bini su tua, ju mama Sara barana kasi bos Abraham satu ana laki-laki. Dia yang nanti tarima bos Abraham pung pusaka samua. ");
INSERT INTO mkn_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Jadi bos Abraham suru beta sumpa bilang, ‘Lu sonde bole ame nona Kanaꞌan, ko kasi kawin deng beta pung ana Isak. ");
INSERT INTO mkn_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ma lu musti ame nona dari beta pung kelu dong sandiri, jadi dia pung bini.’ ");
INSERT INTO mkn_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ais beta tanya sang bos bilang, ‘Karmana kalo itu nona sonde mau iko sang beta?’ ");
INSERT INTO mkn_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ju dia manyao bilang, ‘TUHAN yang beta salalu iko Dia pung mau, nanti suru Dia pung ana bua dari sorga datang buka jalan kasi sang lu, biar lu bisa dapa satu nona dari beta pung kelu sandiri, ko jadi beta pung ana pung bini. ");
INSERT INTO mkn_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ma kalo beta pung kelu dong tolak ko sonde mau lapás itu nona datang sini, na, lu bebas dari itu sumpa.’ ");
INSERT INTO mkn_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Jadi waktu tadi sampe di parigi, beta sambayang dalam hati bilang, ‘TUHAN, beta pung bos Abraham pung Allah. Tolong buka jalan, ko biar beta pung jalan ni dapa hasil yang bae. Biar beta katumu Isak pung calon bini. ");
INSERT INTO mkn_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tuhan, beta ada badiri di pinggir parigi ni. Deng nona-nona dari kota ada datang timba aer di sini. Jadi beta minta bagini: kalo beta omong deng satu nona bilang, “Nona, é! Tolong kasi turun lu pung pareuk aer ko kasi beta minum sadiki dolo.” ");
INSERT INTO mkn_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kalo dia manyao bilang, “Bapa minum sa! Deng nanti beta kasi minum bapa pung onta dong ju.” Naa, itu jadi tanda bilang, itu nona yang Tuhan su pili jadi beta pung tuan muda pung bini!’ ");
INSERT INTO mkn_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Beta balóm sambayang abis, te nona Ribka su datang bawa dia pung pareuk aer, ko timba aer di parigi. Waktu dia nae pi atas, ju beta minta bilang, ‘Nona, kasi beta minum sadiki dolo.’ ");
INSERT INTO mkn_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ju dia kasi turun dia pung pareuk aer capát-capát, ko bilang, ‘Om minum sa! Deng nanti beta kasi minum om pung onta dong ju.’ Ais beta minum, deng beta pung onta dong ju minum. ");
INSERT INTO mkn_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ju beta tanya bilang, ‘Nona pung bapa, nama sapa?’ Ais dia manyao bilang, ‘Beta pung bapa, nama Betuel. Beta pung baꞌi, Nahor. Deng beta pung nene, Milka.’ Ais ju beta kasi pake cincin di dia pung idong, deng taro satu pasang galáng mas di dia pung tangan. ");
INSERT INTO mkn_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tarús beta tondo ko sémba sang Tuhan bilang, ‘Puji Tuhan! Tuhan su buka jalan kasi sang beta, sampe beta su dapa katumu langsung deng bos Abraham pung kelu di sini. Deng beta su dapa katumu langsung deng tuan muda Isak pung calon bini.’ ");
INSERT INTO mkn_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Jadi sakarang, kalo bapa dong mau kasi tunju sayang sang beta pung bos Abraham, na, kasi tau sang beta tarús taráng. Deng kalo sonde ju, na, kasi tau tarús taráng sa. Ko biar beta tau beta musti bekin apa.” ");
INSERT INTO mkn_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Itu hamba omong abis, ju Laban deng Betuel manyao bilang, “Kalo TUHAN su ator ame bagitu, na, botong mau bilang apa lai. ");
INSERT INTO mkn_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nona Ribka ada di sini. Ame sang dia ko bawa pi sana suda. Biar dia jadi baꞌi Abraham pung ana mantu, iko apa yang TUHAN su ator.” ");
INSERT INTO mkn_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Dengar bagitu, ju Abraham pung hamba tondo sampe di tana ko minta tarima kasi sang TUHAN. ");
INSERT INTO mkn_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Tarús dia angka kasi kaluar barang-barang mas-perak, deng pakean bagus-bagus ko kasi sang Ribka. Dia ju kasi sang Ribka pung kaka deng mama, hadia yang mahal-mahal. ");
INSERT INTO mkn_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ais itu, ju Abraham pung hamba, deng dia pung orang dong, dudu makan pesta. Ais dong tidor di situ. Dia pung beso pagi, dong bangun, ju itu hamba kasi tau sang tuan ruma bilang, “Beta minta isin, ko kalo bisa, na, botong mau pulang sakarang pi beta pung bos.” ");
INSERT INTO mkn_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ma Ribka pung kaka deng dia pung mama bilang, “Ko mau buru-buru barangkat bekin apa? Biar ko Ribka tenga deng botong barang sapulu hari bagitu dolo. Abis, na, bawa sang dia pi suda.” ");
INSERT INTO mkn_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ma itu hamba manyao bilang, “Aduu! Jang tahan sang beta! Te TUHAN su tolong sang beta, sampe beta su katumu sang tuan muda pung bini. Jadi mama dong lapás sang botong, ko botong pulang pi lapor sang bos dolo.” ");
INSERT INTO mkn_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tarús dong manyao bilang, “Bagini! Mari ko kotong tanya langsung sang Ribka sa. Dia pung mau karmana?” ");
INSERT INTO mkn_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ju dong pange sang dia ko tanya bilang, “Ribka! Sakarang tarsará lu sa. Lu mau iko memang deng ini orang, ko karmana?” Ais, itu nona manyao bilang, “Beta mau iko.” ");
INSERT INTO mkn_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Ais dong lapás sang Ribka, deng dia pung hamba parampuan yang urus sang dia dari kici, ko pi deng Abraham pung hamba dong. Ju dong omong kasi berkat sang Ribka bilang, “Rika! Botong harap Tuhan kasi lu barana bam-banya, ko lu pung turunan nanti jadi baribu-ribu. Deng botong ju harap lu pung turunan dong kasi kala musu-musu dong!” ");
INSERT INTO mkn_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ais itu, Ribka deng dia pung hamba parampuan dong manyimpan dong pung barang-barang, ju dong nae onta, ko barangkat memang iko Abraham pung hamba dong. ");
INSERT INTO mkn_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isak ada tenga di tana Negeb. Itu waktu, dia baru pulang dari parigi di Beer Lahai Roi. ");
INSERT INTO mkn_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Satu sore, dia kaluar dari tenda ko jalan-jalan cari angin. Dia angka muka, ju dia dapa lia onta dong datang. ");
INSERT INTO mkn_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Waktu Ribka dapa lia sang Isak, ju dia turun capát-capát dari dia pung onta. ");
INSERT INTO mkn_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ais dia tanya sang Abraham pung hamba bilang, “Om! Itu pak di sana yang ada jalan datang sini tu, sapa?” Itu hamba manyao bilang, “Dia tu, beta pung tuan muda.” Ju Ribka ame dia pung salendang ko tutu dia pung muka. ");
INSERT INTO mkn_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ais, itu hamba lapor samua sang Isak. ");
INSERT INTO mkn_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Tarús Isak bawa maso Ribka pi dalam dia pung mama pung tenda, ju dong dua kawin. Isak sayang mau mati sang Ribka, andia ko dia sonde susa lai deng dia pung mama pung mati. ");
INSERT INTO mkn_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham kawin lai deng satu parampuan, nama Ketura. ");
INSERT INTO mkn_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura barana kasi sang dia ana-ana, andia: Simran, Yoksan, Medan, Midian, Isbak, deng Sua. ");
INSERT INTO mkn_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan pung ana, Seba deng Dedan. Dedan pung turunan, andia orang Asyur, orang Letus, deng orang Leum. ");
INSERT INTO mkn_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian pung ana dong, andia: Efa, Efer, Henok, Abida deng Eldaa. Dong samua tu, Ketura pung turunan. ");
INSERT INTO mkn_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Waktu Abraham masi idop, dia su bagi kasi Hagar deng Ketura pung ana-ana dong, satu-satu deng dia pung harta. Ais dia suru sang dong, ko pi tenga di tana Kanaꞌan pung sablá matahari nae, ko biar dong jao dari dia pung ana Isak. Ma dia pung harta pusaka samua, dia sarakan kasi sang Isak. ");
INSERT INTO mkn_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham mati waktu dia pung umur su 175 taon. ");
INSERT INTO mkn_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Ais dia pung ana Isak deng Ismael kubur sang dia di goa Makpela yang deka deng Mamre. Dolu Abraham béli itu kabón dari orang Het, andia Sohar pung ana Efron. Dolu dong ju su kubur sang Sara di itu goa. ");
INSERT INTO mkn_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham mati abis, ju Tuhan Allah kasi berkat sang Isak, sampe dia idop deng dame-sajahtra. Itu waktu, Isak tenga deka parigi, nama Beer Lahai Roi. ");
INSERT INTO mkn_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ini Ismael pung carita. Dia tu, Abraham deng dia pung bini muda Hagar pung ana. Hagar tu, Sara pung hamba dari Masir. ");
INSERT INTO mkn_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismael pung ana ada 12 laki-laki. Ini dong pung nama baꞌiko-baꞌiko dari yang sulung sampe deng yang bungsu, andia: Nebayot, Kedar, Adbeel, Mibsam, Misma, Duma, Masa, Hadad, Tema, Yetur, Nafis, deng Kedma. Itu ana-ana dong, jadi nene-moyang dari dua blas suku-bangsa, satu-satu deng dia pung negrí sandiri. Dong kasi nama itu negrí, satu-satu iko dong pung moyang pung nama. ");
INSERT INTO mkn_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael mati waktu dia pung umur su 137 taon. ");
INSERT INTO mkn_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ma dia pung turunan dong, satu bamusu deng satu. Ais dong tenga tasiram mulai dari Hawila sampe Syur, yang babatas deng negrí Masir, tarús sampe di Asyur. ");
INSERT INTO mkn_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ini Abraham pung ana Isak pung carita. ");
INSERT INTO mkn_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Waktu Isak kawin deng Ribka, Isak pung umur 40 taon. Ribka pung bapa, Betuel. Deng dia pung kaka laki-laki, Laban. Dong tu, orang Aram dari Padan Aram. ");
INSERT INTO mkn_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ribka sonde dapa ana. Andia ko Isak sambayang sang TUHAN ko minta Dia buka Ribka pung tampa ana. TUHAN dengar dia pung sambayang, ju Ribka dudu parú. ");
INSERT INTO mkn_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Padahal dia ada dudu parú sang dua ana. Ma itu ana dong maen bakosi tarús dalam dong pung mama pung parú. Ju Ribka batanya dalam hati bilang, “Akurang ko ini ana dua bagini, ni?” Ais dia tanya sang TUHAN. ");
INSERT INTO mkn_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ju TUHAN manyao bilang, “Dalam lu pung parú, ada dua bangsa yang nanti bamusu tarús. Nanti yang bungsu lebe kuat dari yang sulung. Deng yang kaka karjá kasi dia pung adi.” ");
INSERT INTO mkn_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Waktu dia pung hari su sampe, ju Ribka barana ame dua ana laki-laki bagambar. ");
INSERT INTO mkn_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ana yang kaka pung warna mera, deng dia pung badan samua babulu. Andia ko dong kasi nama sang dia, Esau (yang dia pung bunyi amper sama deng kata laen yang ada pung arti ‘babulu’). ");
INSERT INTO mkn_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Abis, baru dia pung adi kaluar. Ma dia ada pegang dia pung kaka pung tumit. Andia ko dong kasi nama sang dia, Yakob (yang dia pung bunyi amper sama deng kata laen, yang ada pung arti ‘tumit’). Waktu barana sang dong dua, Isak pung umur su 60 taon. ");
INSERT INTO mkn_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Waktu itu dua ana dong bésar datang, Esau jadi jago buru binatang. Dia suka tenga di utan. Ma Yakob tu pandiam, deng suka tenga di ruma sa. ");
INSERT INTO mkn_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak suka makan daging binatang utan. Andia ko dia lebe sayang sang Esau. Ma Ribka lebe sayang sang Yakob. ");
INSERT INTO mkn_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Satu kali, waktu Yakob ada masa sop kacang, Esau baru pulang dari baburu binatang. Dia cape deng lapar satenga mati. ");
INSERT INTO mkn_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ju dia kasi tau sang Yakob bilang, “Adi, é! Kasi lu pung sop mera di pareu sadiki dolo, ko beta isi beta pung parú! Te beta lapar mau mati.” (Andia ko dong pange sang dia, Edom, yang dia pung bunyi amper sama deng kata laen, yang ada pung arti ‘mera’.) ");
INSERT INTO mkn_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ais Yakob manyao bilang, “Bae, kaka. Ma ofer kasi beta kaka pung hak sulung dolo!” ");
INSERT INTO mkn_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ju Esau manyao bilang, “Parsetan deng itu hak sulung! Lu soa sa. Beta su lapar mau mati ni. Lu sendo capát itu sop, ko bawa datang suda, te beta su mau makan.” ");
INSERT INTO mkn_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ma Yakob omong lai bilang, “Bu tunggu dolo! Bu sumpa dolo bilang, bu su ofer kasi beta itu hak.” Ju Esau angka sumpa bagitu. ");
INSERT INTO mkn_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ais Yakob sendo kasi sang dia itu sop kacang, deng roti. Esau makan-minum abis, ju dia bangun jalan. Deng bagitu, Esau kasi parsén buang dia pung hak sulung. ");
INSERT INTO mkn_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Satu kali, ada musim lapar yang hebat di itu negrí, sama ke musim lapar waktu Abraham masi idop. Jadi Isak pi minta isin sang Abimelek, orang Filistin pung raja, ko dia bisa tenga di Gerar. ");
INSERT INTO mkn_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Dia bekin bagitu, tagal TUHAN su kasi tunju diri sang dia bilang, “Lu jang pi Masir. Nanti Beta kasi tunju tampa laen sang lu. ");
INSERT INTO mkn_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Kalo lu tenga manumpang di itu tampa, nanti Beta sama-sama deng lu, deng kasi lu berkat macam-macam. Nanti Beta bekin lu pung turunan dong batamba banya, sama ke bintang di langit. Deng Beta kasi lu deng lu pung turunan ini daꞌera deng dia pung negrí samua. Dari lu pung turunan, nanti samua suku-bangsa di dunya dapa berkat. Deng bagitu, Beta bekin jadi Beta pung janji sang lu pung bapa Abraham. ");
INSERT INTO mkn_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Beta bekin ini samua, tagal lu pung bapa su iko Beta pung mau, Beta pung parenta, deng Beta pung atoran.” ");
INSERT INTO mkn_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Jadi Isak tenga tahan di Gerar. ");
INSERT INTO mkn_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ribka tu, talalu manis. Jadi waktu orang-orang di situ lia sang dia, dong batanya soꞌal dia. Ma Isak manyao bilang, “Ribka tu, beta pung adi.” Dia taku kalo dia mangaku bilang dia pung bini, nanti itu orang dong bunu sang dia ko dong ame bawa Ribka. ");
INSERT INTO mkn_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak su tenga lama-lama di sana, ju satu kali raja maloi dari jandela, te dia dapa lia Isak deng Ribka ada bapaló-baciom. ");
INSERT INTO mkn_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ju dia suru orang dong pange ame Isak, ko dia togor bilang, “Isak! Beta su tau parsís, itu parampuan tu, memang lu pung bini! Ma akurang ko lu bilang, dia tu, lu pung adi?” Ju Isak manyao bilang, “Bagini, bapa! Beta taku kalo beta bilang dia tu, beta pung bini, jang-jang nanti orang dong bunu mati sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ais raja manyao bilang, “Kalo ada orang di sini yang tidor deng lu pung bini, pasti lu kasi sala sang botong! Akurang ko lu bekin bagitu sang botong?” ");
INSERT INTO mkn_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ais itu, ju Abimelek kasi inga karás sang dia pung rakyat bilang, “Bosong samua inga bae-bae! Bosong sapa yang barani ganggu ini orang, ko dia pung bini, nanti beta hukum mati sang dia.” ");
INSERT INTO mkn_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Itu waktu, ju Isak batanam di itu negrí. Tarús dia dapa kambali dia pung hasil 100 kali, tagal TUHAN kasi berkat sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Dia pung kaya batamba tarús, sampe dia jadi kaya talalu. ");
INSERT INTO mkn_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Dia pung sapi deng kambing-domba dong tamba banya. Dia pung ana bua dong ju banya. Sampe orang Filistin iri sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Dolu Isak pung bapa Abraham dong su gali banya parigi. Ma sakarang orang Filistin dong pi tutu ame itu parigi samua deng tana. ");
INSERT INTO mkn_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ais raja Abimelek omong deng Isak bilang, “Isak! Lebe bae, lu barangkat kasi tenga ini negrí suda. Te lu pung kuasa su lebe dari botong.” ");
INSERT INTO mkn_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ais itu, Isak ondor dari situ, ko pi tenga kambali di lemba Gerar. ");
INSERT INTO mkn_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ju dia gali ulang lai itu parigi-parigi, yang dong su tutu ame. Deng dia kasi nama itu parigi dong, iko nama-nama yang dia pung bapa su kasi nama sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Waktu Isak pung hamba dong gali parigi di lemba Gerar, ju dong gali kaná mata aer ko maspurak kaluar. ");
INSERT INTO mkn_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ma gambala Gerar dong bakanjar deng Isak pung gambala dong, tagal itu aer. Dong bilang, “Ini botong pung aer!” Andia ko Isak kasi nama itu parigi, Esek, yang dia pung arti ‘bakanjar’. ");
INSERT INTO mkn_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ais itu, Isak pung orang dong gali satu parigi lai. Ma dong ju batangkár lai, tagal itu parigi. Andia ko Isak kasi nama itu parigi, Sitna, yang dia pung arti ‘baku malawan’. ");
INSERT INTO mkn_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ais itu, dia kasi tenga itu tampa, ju dia gali satu parigi laen lai. Ini kali dong sonde bakanjar. Andia ko Isak kasi nama itu parigi, Rehobot, yang dia pung arti ‘tampa luas’. Deng dia omong bilang, “Sakarang Tuhan su kasi kotong tenga di tana luas. Ais di sini, baru kotong bisa batamba banya.” ");
INSERT INTO mkn_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Dari situ, ju Isak dong barangkat lai ko mau pi tenga di Beer Syeba. ");
INSERT INTO mkn_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Itu malam, ju TUHAN kasi tunju diri sang dia, deng omong bilang, “Isak! Beta ni, lu pung bapa Abraham pung Tuhan Allah. Jadi lu jang taku, te Beta jaga sang lu. Nanti Beta kasi berkat sang lu. Deng lu pung turunan nanti batamba banya. Beta bekin bagini, tagal Beta pung janji sang lu pung bapa.” ");
INSERT INTO mkn_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ais Isak susun batu ko kasi bangun meja korban di situ. Ju dia minta tarima kasi sang TUHAN di itu tampa. Dia tenga di situ, deng dia pung orang dong mulai gali parigi lai. ");
INSERT INTO mkn_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Itu waktu, raja Abimelek datang dari Gerar. Dia sama-sama deng dia pung tamán Ahusat, deng dia pung panglima paráng, Fikol, datang katumu sang Isak. ");
INSERT INTO mkn_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ju Isak tanya bilang, “Bapa raja! Dolu bosong su usir kasi kaluar sang botong. Jadi sakarang bosong mau datang bekin apa lai?” ");
INSERT INTO mkn_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ais dong manyao bilang, “Bagini! Sakarang botong tau bilang, Tuhan jaga sang lu. Andia ko botong pikir-pikir, lebe bae kotong dua bekin janji bagini: lu sumpa bilang, ");
INSERT INTO mkn_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","bosong sonde akan bekin jahat sang botong, sama ke botong ju sonde bekin jahat sang bosong. Memang botong pung hati bae deng bosong. Andia ko tempo hari, bosong kaluar deng dame dari botong pung tana. Botong su tau batúl, TUHAN yang kasi berkat sang bosong.” ");
INSERT INTO mkn_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ais Isak bekin pesta kasi sang dong, ju samua makan-minum rame-rame. ");
INSERT INTO mkn_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ais dia pung beso papagi, ju dong baꞌangka sumpa. Tarús Isak kasi lapás sang dong, ko dong pi deng dame. ");
INSERT INTO mkn_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Itu hari, Isak pung orang karjá dong datang lapor soꞌal parigi yang dong gali bilang, “Bapa! Botong su dapa aer.” ");
INSERT INTO mkn_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ais Isak kasi nama itu parigi, Syeba, yang dia pung arti ‘sumpa’. Jadi dong kasi nama itu kota Beer Syeba, sampe sakarang. ");
INSERT INTO mkn_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Waktu Esau umur 40 taon, ju dia kawin deng dua nona dari suku Het. Yang satu, Beeri pung ana, nama Yudit. Deng yang satu lai, Elon pung ana, nama Basmat. ");
INSERT INTO mkn_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Itu dua parampuan tu, bekin Isak deng Ribka pung hati susa. ");
INSERT INTO mkn_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Waktu Isak su tua, dia pung mata su talalu kabur, ju dia pange dia pung ana sulung yang dia paling sayang bilang, “Sau! Lu mari sini dolo!” Esau manyao bilang, “Karmana, papa?” ");
INSERT INTO mkn_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak kasi tau bilang, “Bagini! Beta ni, su tua. Beta sonde tau kapan beta mati. ");
INSERT INTO mkn_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Jadi pi ame lu pung sanjata dong, ko pi buru kasi beta binatang utan satu dolo. ");
INSERT INTO mkn_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ais lu masa ena-ena iko beta pung suka, ko bawa datang kasi beta. Nanti makan abis, baru beta kasi berkat memang sang lu. Kalo su kasi berkat abis sang lu, biar beta mati, ju bae.” ");
INSERT INTO mkn_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ais ju Esau kaluar ko pi buru binatang. Ma Ribka ju dapa dengar Isak pung omong tu. ");
INSERT INTO mkn_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ais Ribka pi kasi tau sang Yakob bilang, “We, Ako! Lu dengar bae-bae! Tadi beta baru dapa dengar bapa ada omong deng Esau bagini: ");
INSERT INTO mkn_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Lu pi buru satu binatang utan, ko masa ena-ena kasi sang beta. Kalo beta su makan abis, nanti beta kasi berkat sang lu di TUHAN pung muka.’ ");
INSERT INTO mkn_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Jadi lu dengar bae-bae! Iko batúl-batúl deng beta pung parenta ni. ");
INSERT INTO mkn_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Sakarang lu pi di kotong pung tampa kambing-domba, ko pili ame dua kambing ténak yang gumu-gumuk. Ais potong ko ame dia pung daging, deng bawa kasi beta. Nanti beta masa, iko lu pung pung bapa pung suka. ");
INSERT INTO mkn_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kalo be su masa abis, na, lu bawa pi kasi lu pung bapa ko dia makan. Ais nanti dia kasi berkat sang lu dolo, baru dia mati. Deng bagitu, lu yang dapa itu berkat. Bukan lu pung kaka.” ");
INSERT INTO mkn_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ma Yakob omong deng dia pung mama bilang, “Mama! Dia pung masala, bagini. Bu Sau pung badan babulu, ma beta pung badan licin! ");
INSERT INTO mkn_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Jang-jang nanti bapa raba kaná beta pung badan, dia tau memang beta tipu sang dia. Ju dia kutuk sang beta!” ");
INSERT INTO mkn_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Dia pung mama manyao bilang, “Ako, é! Lu jang kawatir. Sarakan sa, nanti mama yang ator! Kalo lu pung bapa kutuk sang lu, biar mama yang pikol sa! Sakarang lu pi ame itu kambing suda.” ");
INSERT INTO mkn_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ais itu, Yakob pi pili ame itu kambing dong, ju dia potong ko bawa kasi dia pung mama. Tarús Ribka bamasa iko Isak pung suka. ");
INSERT INTO mkn_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ais Ribka pi ame Esau pung pakean yang bagus, ko kasi Yakob pake. ");
INSERT INTO mkn_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Dia ju bungkus Yakob pung tangan deng dia pung leher, pake itu kambing pung bulu. ");
INSERT INTO mkn_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tarús dia kasi sang Yakob itu makanan enak, deng roti yang dia su bekin. ");
INSERT INTO mkn_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ais Yakob pi antar itu makanan kasi dia pung bapa. Dia omong bilang, “Bapa! Beta su datang ni.” Ju Isak manyao bilang, “Heh? Ko, lu ni sapa?” ");
INSERT INTO mkn_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Tarús Yakob manyao bilang, “Beta ni, bapa pung ana sulung, Esau! Beta su bekin iko apa yang bapa suru tadi tu. Bangun ko makan suda. Beta su masa itu daging yang beta su tangkap ame di utan. Makan, ko abis bapa kasi berkat sang beta suda!” ");
INSERT INTO mkn_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ais Isak omong bilang, “Lu ni hebat, ó! Ko lu bisa dapa binatang capát bagitu!” Ju Yakob manyao bilang, “Beta dapa ni, tagal TUHAN yang bapa sémba tu, ada tolong sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Tarús Isak pange sang Yakob bilang, “Lu datang deka-deka, ko beta raba coba sang lu! Lu ni batúl Esau, ko?” ");
INSERT INTO mkn_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ais Yakob pi deka-deka dia pung bapa, ju bapatua mulai raba sang dia. Tarús dia omong bilang, “Ini suara ni, sama ke Yakob pung suara! Ma ini tangan ni, Esau pung tangan.” ");
INSERT INTO mkn_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ma Isak sonde kanál sang Yakob, tagal dia pung tangan babulu sama ke Esau. Ma waktu dia mau kasi berkat sang Yakob, ");
INSERT INTO mkn_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","dia tanya ulang lai bilang, “Lu ni, batúl-batúl Esau, ko?” Tarús Yakob manyao bilang, “Batúl papa!” ");
INSERT INTO mkn_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ais ju Isak omong bilang, “Lu sorong datang itu daging, ko beta mau makan. Abis, baru beta kasi berkat sang lu.” Tarús Yakob sorong kasi itu daging sang dia, deng kasi aer anggor ko dia minum. ");
INSERT INTO mkn_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ais itu, dia pung bapa omong bilang, “Ana, é! Mari deka-deka sini, ko ciom sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Waktu Yakob pi deka-deka ko ciom sang dia, ju Isak dapa ciom Esau pung pakean pung baboo. Ais dia omong kasi berkat sang Yakob bilang, “Beta pung ana pung baboo, sama ke padang rumput yang TUHAN su kasi berkat. ");
INSERT INTO mkn_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Biar Tuhan Allah kasi turun embun dari langit, ko bekin lu pung kabón dong jadi subur! Biar Dia kasi lu padi limpa-limpa, deng bua anggor ponu-ponu. ");
INSERT INTO mkn_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Bangsa-bangsa dong jadi lu pung hamba, Deng suku-suku dong, tondo kasi hormat sang lu. Biar lu parenta sang lu pung sodara dong samua, deng dong tikam lutut di lu pung muka. Sapa yang kutuk sang lu, dong ju dapa kutuk. Deng sapa yang kasi berkat sang lu, dong ju dapa berkat.” ");
INSERT INTO mkn_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Waktu Isak kasi berkat abis, ju Yakob baru kaluar kasi tenga dia pung bapa, dia pung kaka Esau pulang bawa binatang yang dia dapa tangkap. ");
INSERT INTO mkn_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ju dia pi bamasa, ais dia bawa kasi dia pung bapa. Dia omong bilang, “Papa! Bangun ko makan suda. Beta su masa itu daging yang beta tangkap. Abis makan, na, papa kasi berkat sang beta suda.” ");
INSERT INTO mkn_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ju Isak bingung, deng tanya bilang, “Heh! Ko lu ni, sapa lai?” Ais Esau manyao bilang, “Beta ni, Sau! Papa pung ana sulung.” ");
INSERT INTO mkn_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ju Isak mulai gamatar. Ais bapatua tanya bilang, “Kalo bagitu, tadi tu, sapa yang bawa kasi beta itu daging, ko beta su makan? Ais ju beta su kasi berkat sang dia. Deng sonde bisa cabu lai itu berkat.” ");
INSERT INTO mkn_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Dengar dia pung bapa omong bagitu, ju Esau saki hati deng manangis makarereu, deng omong karás-karás bilang, “Aduuu! Papa, é! Kasi berkat sang beta ju, papa!” ");
INSERT INTO mkn_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ma Isak bilang, “Lu pung adi su datang tipu ame sang beta, deng curi bawa lu pung berkat.” ");
INSERT INTO mkn_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tarús Esau omong bilang, “Dia su tipu sang beta dua kali. Dolu dia tipu ame beta pung hak sulung. Sakarang dia tipu ame lai beta pung berkat. Pantas dia pung nama, ‘Yakob’. Ma papa masi ada pung berkat laen lai kasi beta, ko?” (Nama Yakob pung arti ‘pegang di tumit’. Ma dia pung arti laen ‘tukang tipu’.) ");
INSERT INTO mkn_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ais ju Isak manyao bilang, “Beta su angka sang dia jadi lu pung bos. Deng dia pung sodara samua su jadi dia pung hamba. Beta su kasi sang dia padi limpa-limpa, deng anggor ponu-ponu. Jadi ana, é! Sakarang masi ada berkat apa lai, yang beta bisa kasi sang lu?” ");
INSERT INTO mkn_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Dengar bagitu, ju Esau maen noki tarús sang dia pung bapa bilang, “Bapa pung berkat cuma satu sa, ko? Pasti bapa masi bisa cari kasi beta berkat laen. Biar berkat kici sa ju bae!” Ju dia mulai manangis lai. ");
INSERT INTO mkn_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ais itu, ju Isak manyao bale sang dia bilang, “Lu pung idop nanti jao dari kabón yang subur, te sonde ada embun yang turun dari langit ko bekin basa lu pung tana. ");
INSERT INTO mkn_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Lu pung kalewang yang nanti kasi lu idop. Ma biar karmana ju, lu jadi hamba sang lu pung adi. Cuma kalo lu bisa malawan sang dia, nanti baru lu bisa talapás dari dia pung tangan.” ");
INSERT INTO mkn_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau binci mau mati sang Yakob, tagal dia pung adi su rampas ame dia pung berkat. Ma dia pikir bilang, “Sonde lama lai, te bapa mati. Jadi tunggu sa. Nanti mete-mete abis, beta bunu sang dia!” ");
INSERT INTO mkn_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Waktu Ribka dapa dengar Esau pung rancana, ju dia pange sang Yakob, deng bilang, “Lu dengar bae-bae! Lu pung kaka ada niat mau balas dia pung saki hati, ko mau bunu sang lu. Jadi lu lari capát-capát pi di lu pung toꞌo Laban di Haran. ");
INSERT INTO mkn_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Pi tenga sadiki lama di sana, sampe lu pung kaka su sonde mara lai sang lu. ");
INSERT INTO mkn_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kalo dia su lupa buang apa yang lu su bekin sang dia, nanti beta suru orang pange pulang sang lu. Te beta sonde mau beta pung ana dua-dua ilang dalam satu hari.” ");
INSERT INTO mkn_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ais Ribka omong deng Isak bilang, “Beta su doak deng Esau pung bini orang Het dong! Kalo Yakob ju kawin deng nona Het, na, lebe bae beta mati sa.” ");
INSERT INTO mkn_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ais Isak pange sang Yakob, ju dia kasi berkat deng nasiat bilang, “Dengar bae-bae! Lu jang kawin deng nona Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ma lu pi di Padan Aram, di baꞌi Betuel pung ruma. Lu pi kawin deng toꞌo Laban pung ana parampuan satu. ");
INSERT INTO mkn_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Biar Tuhan Allah yang Paling Kuasa kasi berkat sang lu, ko lu pung ana-cucu batamba banya, deng lu pung turunan jadi banya bangsa yang hebat. ");
INSERT INTO mkn_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Biar Tuhan pung janji sang Abraham jato pi di lu, deng lu pung turunan. Biar lu soa ini tana yang Tuhan Allah su janji kasi sang Abraham.” ");
INSERT INTO mkn_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Omong abis bagitu, ju Isak lapás sang Yakob pi Padan Aram, di dia pung toꞌo Laban deng baꞌi Betuel pung ruma. ");
INSERT INTO mkn_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau dapa dengar bilang, Isak su kasi berkat sang Yakob, deng larang sang dia ko jang kawin deng nona Kanaꞌan. Dia ju dapa dengar bilang, dia pung bapa su suru dia pung adi ko pi kawin deng toꞌo pung ana nona satu di Padan Aram. ");
INSERT INTO mkn_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ais Yakob dengar dia pung bapa deng mama pung parenta, ju dia barangkat pi Padan Aram. ");
INSERT INTO mkn_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau ju tau bilang, dia pung bapa sonde suka sang dia pung bini, orang Kanaꞌan dong. ");
INSERT INTO mkn_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Jadi dia pi sang bapa bésar Ismael, ais dia kawin lai deng Ismael pung ana, nama Mahalat. Mahalat tu, Nebayot pung adi parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ais Yakob jalan kasi tenga Beer Syeba, ko mau pi Haran. ");
INSERT INTO mkn_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Waktu matahari tanggalám, dia sampe di satu tampa, ju dia tidor di situ. Waktu dia mau tidor, dia ame satu batu ko bekin jadi bantal. ");
INSERT INTO mkn_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Itu malam dia mimpi. Dia dapa lia satu tangga badiri di tana deng dia pung ujung sampe di langit. Ais Tuhan Allah pung ana bua dari sorga dong turun-nae itu tangga. ");
INSERT INTO mkn_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Dalam itu mimpi, Yakob dapa lia TUHAN badiri di dia pung sablá, ais omong bilang, “Beta ni TUHAN, lu pung baꞌi Abraham deng bapa Isak pung Tuhan Allah. Nanti Beta kasi ini tana sang lu deng lu pung turunan. ");
INSERT INTO mkn_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nanti lu pung turunan dong pung banya sama ke abu. Deng nanti dong tasiram pi mana-mana di samua tampa. Dari lu pung turunan, nanti samua suku-bangsa di dunya dapa berkat. ");
INSERT INTO mkn_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Inga bae-bae! Lu pi mana sa, Beta sama-sama deng jaga sang lu. Nanti Beta bawa sang lu pulang kambali di ini negrí. Beta sonde kasi biar sang lu sandiri. Deng nanti Beta bekin jadi samua janji yang Beta kasi sang lu.” ");
INSERT INTO mkn_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Waktu Yakob bangun tidor, ju dia bilang, “Beta baru tau bilang, TUHAN ju ada di sini!” ");
INSERT INTO mkn_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Dia taku, ju dia pikir bilang, “We! Ini tampa bekin beta pung bulu badan badiri. Pasti Tuhan Allah pung ruma ada di sini! Mangkali ini dia pung pintu pi sorga.” ");
INSERT INTO mkn_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Dia pung papagi, Yakob bangun, tarús dia ame batu yang dia pake jadi bantal tu, ko kasi badiri jadi tanda. Ais dia poꞌa minya di atas itu batu, ko sémba sang Tuhan. ");
INSERT INTO mkn_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Dia kasi nama itu tampa, Betel, yang dia pung arti ‘Tuhan pung ruma’. (Dolu itu tampa, nama Lus). ");
INSERT INTO mkn_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ais itu, ju Yakob angka sumpa bilang, “Kalo Tuhan Allah sama-sama deng beta, ais jaga sang beta di beta pung jalan ni, deng kasi beta makan deng pakean, ");
INSERT INTO mkn_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","sampe beta pulang deng salamat, nanti TUHAN jadi beta pung Allah. ");
INSERT INTO mkn_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Batu yang beta kasi badiri ni, jadi tampa sémba sang Tuhan Allah. Deng samua yang Tuhan kasi sang beta, nanti beta kasi kambali satu bagian dari sapulu.” ");
INSERT INTO mkn_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ais itu, ju Yakob jalan tarús pi matahari nae. ");
INSERT INTO mkn_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Satu hari, dia dapa lia satu parigi deka satu kampong. Deka-deka situ, ada kambing-domba tiga kumpul, yang ada tunggu-tunggu ko dapa minum di situ. Ma ada satu batu bésar tutu itu parigi. ");
INSERT INTO mkn_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Dia pung biasa, kalo kambing-domba dong samua su bakumpul, baru gambala kasi ondor itu batu ko timba aer kasi minum binatang dong. Minum abis, dong tutu kambali itu parigi lai. ");
INSERT INTO mkn_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Tarús Yakob pi tanya itu gambala dong bilang, “We! Bosong dari mana?” Dong manyao bilang, “Botong ni, dari kampong Haran sini.” ");
INSERT INTO mkn_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ais Yakob tanya lai bilang, “Bosong kanál beta pung toꞌo Laban, ko? Dia tu, Nahor pung ana.” Ju dong manyao bilang, “Botong kanál.” ");
INSERT INTO mkn_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ju Yakob tanya tarús lai bilang, “Dia ada bae-bae, ko?” Dong manyao bilang, “Bapatua ada bae-bae sa. Coba lia. Itu dia pung ana parampuan, nama Rahel, ada foo bawa dia pung kambing-domba dong ko datang minum di sini. Lu tunggu sa.” ");
INSERT INTO mkn_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ais Yakob omong lai bilang, “Sakarang matahari masi tinggi. Jadi lebe bae binatang mana yang su bakumpul di sini, na, bosong kasi minum suda. Ais bosong foo bawa pi padang, ko dong makan rumput lai.” ");
INSERT INTO mkn_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ma dong protes bilang, “Aweꞌ, sonde bisa bagitu! Botong musti tunggu gambala dong samua bawa dong pung binatang ko bakumpul di sini dolo, baru botong kasi ondor itu batu, ko kasi minum binatang dong.” ");
INSERT INTO mkn_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob masi baꞌomong deng itu orang dong, te Rahel sampe deng dia pung bapa pung kambing-domba dong. Dia yang biasa foo itu binatang. ");
INSERT INTO mkn_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Waktu Yakob lia Rahel deng dia pung kambing-domba dong, ju dia pi kasi ondor itu parigi pung tutu. Ais dia kasi minum dia pung toꞌo pung binatang dong. ");
INSERT INTO mkn_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ais ju dia pi paló-ciom sang Rahel, deng manangis. ");
INSERT INTO mkn_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ais dia carita sang Rahel bilang, “Adi! Beta ni, lu pung bapa pung adi Ribka pung ana.” Ju Rahel lari pulang, ko pi kasi tau dia pung bapa. ");
INSERT INTO mkn_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Waktu Laban dengar Rahel pung carita soꞌal Yakob, dia pung adi Ribka pung ana, ju dia lari pi sambut sang dia. Waktu katumu, ju Laban paló-ciom sang dia, ais dia bawa sang Yakob pi dia pung ruma. Ais Yakob carita samua sang Laban. ");
INSERT INTO mkn_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Ju Laban omong bilang, “Memang batúl! Kotong dua bakelu!” ");
INSERT INTO mkn_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Waktu Yakob su tenga deng dong sampe satu bulan, ");
INSERT INTO mkn_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban omong deng dia bilang, “Bagini, Ako! Beta sonde mau lu karjá farei kasi beta tagal kotong dua bakelu. Lu minta gaji barapa?” ");
INSERT INTO mkn_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Naa, Laban tu, ada pung ana parampuan dua orang. Yang kaka, nama Lea. Yang adi, nama Rahel. ");
INSERT INTO mkn_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea pung mata sayu. Ma Rahel pung muka talalu manis, deng dia pung badan bagus. ");
INSERT INTO mkn_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakob cinta sang Rahel. Jadi dia manyao sang Laban bilang, “Beta karjá kasi toꞌo tuju taon, asal toꞌo kasi kawin beta deng Rahel.” ");
INSERT INTO mkn_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ais Laban manyao bilang, “Satuju! Lebe bae beta kasi kawin Rahel deng lu, andia beta pung kelu sandiri! Dia sonde usa kawin deng orang laen. Jadi lu tenga di sini sa, ko karjá kasi beta.” ");
INSERT INTO mkn_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ais Yakob karjá tuju taon, ko bisa dapa sang Rahel. Ma dia cinta mau mati sang Rahel. Jadi tuju taon tu, dia rasa sama ke cuma barapa hari sa. ");
INSERT INTO mkn_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Lewat itu tuju taon, ju Yakob kasi inga sang Laban bilang, “Toꞌo! Beta su karjá kasi toꞌo tuju taon ni, jadi sakarang kasi kawin sang beta deng Rahel su.” ");
INSERT INTO mkn_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ju Laban bekin pesta kawin, deng undang samua orang di itu negrí. ");
INSERT INTO mkn_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Itu malam, Laban sonde kasi Rahel, ma dia kasi Lea maso pi Yakob pung tenda. Jadi Yakob tidor deng dia. Dia pung beso, baru Yakob dapa tau, kalo dia kawin deng Lea. Tarús Yakob pi protes sang Laban bilang, “Akurang ko toꞌo pakaneꞌo sang beta? Beta su karjá banting tulang tuju taon, ko dapa sang Rahel! Ma akurang ko toꞌo ganti deng Lea?” Ais Laban manyao bilang, “Lu jang mara bagitu! Iko botong pung adat di sini, adi sonde bole kawin lebe dolo dari kaka. Jadi lebe bae bagini sa! Lu tunggu sampe ini pesta kawin tuju hari abis dolo. Baru lu dapa sang Rahel, asal lu karjá kasi beta tuju taon lai.” Ais Laban kasi dia pung hamba parampuan, nama Silpa ko jadi Lea pung hamba. ");
INSERT INTO mkn_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob satuju. Andia ko, waktu itu pesta tuju hari abis, ju Laban kasi kawin Rahel deng Yakob. ");
INSERT INTO mkn_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ais Laban kasi dia pung hamba parampuan satu lai, nama Bilha, ko jadi Rahel pung hamba. ");
INSERT INTO mkn_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ais ju Yakob tidor deng Rahel. Dia lebe cinta sang Rahel dari Lea. Ju dia karjá tamba lai tuju taon kasi dia pung bapa mantu. ");
INSERT INTO mkn_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ma TUHAN tau Yakob lebe cinta sang Rahel dari Lea. Ais Dia kasi loos ko Lea barana. Ma Rahel sonde dapa ana. ");
INSERT INTO mkn_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ais Lea dudu parú, ju dia dapa satu ana laki-laki. Dia kasi nama itu ana, Ruben (yang dia pung arti ‘lia, ada ana’), tagal dia bilang, “TUHAN memang su lia beta pung susa. Andia ko sakarang, beta pung laki ju mau lia sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ais itu, Lea dudu parú lai, ju dia dapa satu ana laki-laki. Dia kasi nama itu ana, Simeon (yang dia pung arti kira-kira ‘orang su dengar’), tagal dia bilang, “TUHAN su dengar bilang, beta pung laki sonde toe sang beta. Andia ko Dia kasi tamba satu ana lai sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ais itu, Lea dudu parú lai, ju dia dapa satu ana laki-laki lai. Dia kasi nama itu ana, Lewi, tagal dia bilang, “Deng ini ana, be pung parkara su abis. Pasti beta pung laki nanti taꞌika deng beta, tagal beta su barana kasi dia tiga ana laki-laki.” ");
INSERT INTO mkn_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ais itu, Lea dudu parú lai, ju dia dapa satu ana laki-laki. Dia kasi nama itu ana, Yahuda (yang dia pung arti kira-kira ‘puji’), tagal dia bilang, “Ini kali, beta mau puji TUHAN!” Ais itu, Lea sonde barana lai. ");
INSERT INTO mkn_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ma Rahel balóm dapa ana. Andia ko dia camburu sang dia pung kaka. Ju dia omong deng dia pung laki bilang, “Bu! Kasi beta ana dolo! Kalo sonde, na, lebe bae beta mati sa.” ");
INSERT INTO mkn_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ju Yakob masparak sang dia bilang, “Lu kira beta ni Tuhan, ko bisa kasi lu ana!?” ");
INSERT INTO mkn_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ais Rahel omong bilang, “Bagini! Lebe bae bapa ame beta pung hamba Bilha. Pi tidor deng dia, ko dia barana kasi beta ana.” ");
INSERT INTO mkn_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ais dia kasi Bilha di dia pung laki. Ju Yakob tidor deng dia. ");
INSERT INTO mkn_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ais Bilha dudu parú, ju dia barana ame satu ana laki-laki. ");
INSERT INTO mkn_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ju Rahel omong bilang, “Tuhan Allah su dengar beta pung sambayang. Andia ko Dia su kasi sang beta satu ana laki-laki. Allah su putus beta pung parkara deng adil.” Ju dia kasi nama itu ana, Dan (yang dia pung arti ‘putus parkara’). ");
INSERT INTO mkn_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ais itu, Bilha dudu parú lai, ju dia dapa satu ana laki-laki. ");
INSERT INTO mkn_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ais Rahel omong bilang, “Beta su basaing deng beta pung kaka, ais beta yang manáng.” Andia ko dia kasi nama itu ana, Naftali (yang dia pung arti ‘basaing’, ko ‘baterek’). ");
INSERT INTO mkn_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Waktu Lea rasa dia sonde dapa ana lai, tarús dia kasi dia pung hamba Silpa sang dia pung laki, ko kawin deng dia. ");
INSERT INTO mkn_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ais ju Silpa barana ame satu ana laki-laki. ");
INSERT INTO mkn_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ju Lea omong bilang, “Beta pung nasib, su bae.” Deng dia kasi nama itu ana, Gad (yang pung arti ‘nasib bae’). ");
INSERT INTO mkn_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Tarús Silpa barana ame satu ana laki-laki lai. ");
INSERT INTO mkn_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ais ju Lea omong bilang, “Wei! Sakarang, baru beta sanáng! Lia te nanti samua parampuan baꞌomong bilang, beta su talalu ontong.” Andia ko dia kasi nama itu ana, Aser (yang pung arti ‘sanáng’). ");
INSERT INTO mkn_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Satu kali, pas musim koru padi, Ruben pi utan, ju dapa katumu satu tanaman obat yang bisa bekin orang dapa ana. Tarús dia bawa kasi dia pung mama Lea. Lia bagitu, ju Rahel minta sang Lea bilang, “Kaka, é! Kasi beta obat sadiki yang Ruben bawa tu.” ");
INSERT INTO mkn_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ma Lea manyao bilang, “Weh! Lu ni, su talalu! Lu su rampas ame beta pung laki. Sakarang lu mau rampas ame itu obat dari beta pung ana lai? Lu ni, sonde tau malu!” Ma Rahel omong bilang, “Bagini, kaka. Kalo beta dapa itu obat, na, ini malam, lu bole tidor deng Yakob.” Ju Lea satuju. ");
INSERT INTO mkn_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Dia pung sore, Yakob pulang dari kabón. Ju Lea pi katumu deng dia, ais omong bilang, “Ako! Lu musti tidor deng beta ini malam! Te beta su bayar memang sang lu deng beta pung ana pung obat.” Ais, itu malam ju Yakob tidor deng Lea. ");
INSERT INTO mkn_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ais Tuhan Allah dengar Lea pung sambayang. Andia ko dia dudu parú, ju dia barana ame ana laki-laki kalima. ");
INSERT INTO mkn_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ais Lea kasi nama itu ana, Isaskar (yang pung arti ‘bayar cape’), tagal dia bilang, “Tuhan Allah su bayar beta pung cape, te beta su kasi Silpa kawin deng beta pung laki.” ");
INSERT INTO mkn_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ais itu, Lea dudu parú lai, ju dia barana ame ana laki-laki kaꞌanam. ");
INSERT INTO mkn_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Dia omong bilang, “Tuhan Allah su kasi beta hadia yang bagus. Jadi sakarang beta pung laki musti kasi hormat sang beta, tagal beta su barana ame kasi sang dia anam ana laki-laki.” Andia ko dia kasi nama itu ana Sebulon (yang pung arti ‘kasi hormat’). ");
INSERT INTO mkn_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ais itu, Lea barana ame satu ana parampuan, ju dia kasi nama, Dina. ");
INSERT INTO mkn_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ais Tuhan Allah inga sang Rahel, ju Dia dengar dia pung sambayang. Andia ko Dia buka dia pung tampa ana. ");
INSERT INTO mkn_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ais itu, Rahel dudu parú, ju dia barana ame ana laki-laki satu. Dia bilang, “Tuhan Allah su angka buang beta pung malu.” ");
INSERT INTO mkn_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ju dia kasi nama itu ana, Yusuf (yang pung arti kira-kira ‘biar dia kasi tamba’), tagal dia bilang, “Beta minta ko Tuhan Allah kasi tamba sang beta satu ana laki-laki lai.” ");
INSERT INTO mkn_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Waktu Rahel su barana sang Yusuf, Yakob omong deng Laban bilang, “Bapa! Kalo bisa, na, beta mau pulang pi beta pung negrí dolo. ");
INSERT INTO mkn_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Biar beta pulang deng bawa beta pung bini deng ana-ana dong. Bapa su tau, beta su karjá banting tulang kasi bapa, jadi beta su bayar putus sang dong. Tagal itu, sakarang dong tu beta pung hak.” ");
INSERT INTO mkn_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ais dia pung bapa mantu manyao bilang, “Ana, é! Lu dengar dolo. Beta su ramal abis, ju dapa tau bilang, Tuhan su kasi berkat sang beta, tagal lu. ");
INSERT INTO mkn_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Naa, sakarang lu mau minta barapa sa, beta bayar! Asal lu tenga di sini, deng karjá tarús kasi beta.” ");
INSERT INTO mkn_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ais Yakob manyao bilang, “Bapa su lia sandiri, beta pung karjá karás. Andia ko bapa pung binatang dong tamba banya tarús. ");
INSERT INTO mkn_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Waktu beta balóm datang tu, bapa pung harta sonde bagitu banya. Ma sakarang, bapa su kaya. Tuhan su kasi berkat sang bapa, tagal beta pung karjá. Sakarang su sampe dia pung waktu, ko beta mau karjá lai kasi beta pung bini-ana dong.” ");
INSERT INTO mkn_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ais ju Laban tanya bilang, “Jadi beta musti bayar karmana sang lu?” Tarús Yakob manyao bilang, “Bapa sonde usa kasi beta apa-apa. Nanti beta piara tarús bapa pung binatang dong, asal beta bisa bekin satu hal. ");
INSERT INTO mkn_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kasi isin sang beta, ko ini hari ju beta pi di bapa pung binatang dong, ko pili ame kambing-domba. Yang sonde batitik, deng yang sonde ada baláng dong, biar itu bapa pung. Ma yang batitik, deng yang ada baláng dong, biar beta yang dapa. Deng beta ju ame samua domba yang itam. Biar samua tu, bayar beta pung cape. ");
INSERT INTO mkn_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Di balakang hari, nanti bapa bisa tau beta ni jujur, ko sonde. Kapan sa, bapa bisa datang pareksa beta pung binatang dong. Kalo dapa lia ada kambing yang sonde batitik, ko sonde ada baláng, ko domba yang puti, na, bapa tau memang bilang, beta yang pancuri bapa pung binatang.” ");
INSERT INTO mkn_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ais ju Laban satuju bilang, “Bae! Bagitu sa.” ");
INSERT INTO mkn_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ma itu hari ju Laban kasi pisa samua binatang batitik, yang ada baláng, deng domba yang itam. Ais dia suru dia pung ana-ana dong ko urus itu binatang dong. ");
INSERT INTO mkn_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Tarús dong bawa itu binatang dong pi satu tampa yang dia pung jao tiga hari jalan kaki dari Yakob. Ais Yakob masi piara bapa mantu pung kambing-domba yang sisa dong. ");
INSERT INTO mkn_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ais itu, Yakob potong ame cabang dari tiga macam pohon, ko dia kupas bekin strep-strep. ");
INSERT INTO mkn_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Dia taro itu kayu bastrep dong di itu binatang pung tampa minum. Binatang dong suka bakawin di itu tampa minum. ");
INSERT INTO mkn_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Jadi waktu binatang bakawin di muka itu kayu bastrep dong, nanti dong pung ana dong kaluar datang, dong pung bulu ju batitik deng ada baláng. ");
INSERT INTO mkn_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ais waktu Laban pung binatang dong mau bakawin, Yakob kasi mangada sang dong pi di binatang yang batitik deng babaláng. Ais dong pung ana dong ju batitik deng babaláng. Deng bagitu, ju dia pung binatang sandiri batamba banya. Ais dia kasi pisa sang dong dari Laban pung binatang. ");
INSERT INTO mkn_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Waktu binatang yang kuat dong bakawin, Yakob taro itu kayu bastrep-strep di dong pung muka, di dong pung tampa minum. ");
INSERT INTO mkn_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ma kalo dia lia binatang mamalek yang bakawin, na, dia sonde taro itu kayu dong. Jadi Laban dapa samua binatang yang mamalek. Ma Yakob dapa samua binatang yang kuat-kuat. ");
INSERT INTO mkn_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Deng bagitu, Yakob jadi kaya mau mati. Dia pung kambing, domba, onta, keledai, deng hamba-hamba dong talalu banya. ");
INSERT INTO mkn_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Satu kali, Yakob dapa dengar Laban pung ana dong baꞌomong bilang, “Yakob su kaya mau mati, tagal dia su garu bekin karíng kotong pung bapa pung harta dong.” ");
INSERT INTO mkn_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob ju lia dia pung bapa mantu Laban pung muka su karíng-karíng, deng sonde bae-bae deng dia sama ke dolu lai. ");
INSERT INTO mkn_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ais itu, TUHAN omong deng Yakob bilang, “Sakarang dia pung waktu su sampe. Jadi lu musti kambali pi di lu pung mama-bapa dong. Beta nanti sama-sama deng lu.” ");
INSERT INTO mkn_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ais itu, Yakob suru pi pange sang Rahel deng Lea, ko datang katumu deng dia di tampa binatang di padang. ");
INSERT INTO mkn_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ais dia kasi tau sang dong bilang, “Balakang hari ni, beta lia bosong pung bapa pung muka su karíng-karíng sa deng beta. Dia ju su sonde bae-bae deng beta lai sama ke dolu. Ma Tuhan Allah yang beta pung bapa sémba tu, ada sama-sama deng beta. ");
INSERT INTO mkn_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Bosong dua tau, bagini lama ni, beta su karjá banting tulang satenga mati kasi bosong pung bapa! ");
INSERT INTO mkn_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Biar bagitu, ma dia ju tipu barmaen sang beta ulang kali. Dia ganti beta pung sewa sampe sapulu kali. Biar bagitu, ma Tuhan Allah jaga mati sang beta. ");
INSERT INTO mkn_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Waktu bosong pung bapa omong bilang, ‘Itu binatang batitik dong, jadi lu pung sewa,’ ju itu binatang dong barana ana batitik samua. Laen kali, dia omong lai bilang, ‘Sakarang binatang yang ada baláng dong, jadi lu pung sewa,’ ju itu binatang dong barana ana baláng samua. ");
INSERT INTO mkn_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tuhan Allah bekin bagitu, ko biar Dia ame bosong pung bapa pung binatang, ko kasi sang beta. ");
INSERT INTO mkn_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Satu kali, waktu binatang dong pung musim bakawin, beta lia dalam mimpi bilang, samua binatang laki yang ada bakawin tu, ada yang baloreng, batitik, deng ada yang baláng. ");
INSERT INTO mkn_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ais Tuhan pung ana bua dari sorga pange sang beta dalam mimpi bilang, ‘We! Yakob!’ Ais beta manyao bilang, ‘Ada apa, Tuhan?’ ");
INSERT INTO mkn_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ju dia kasi tau bilang, ‘Lia dolo! Samua binatang laki yang bakawin dong, cuma ada yang baloreng, batitik, deng baláng. Beta yang ator itu samua, tagal Beta su lia apa yang Laban su bekin ame sang lu. ");
INSERT INTO mkn_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Beta ni, Tuhan Allah yang kasi tunju diri sang lu di Betel. Di sana lu kasi badiri batu, ais poꞌa minya di atas ko sémba sang Beta. Ais lu ika janji deng Beta di situ. Sakarang lu musti jalan kasi tenga ini negrí, ko pulang pi lu pung mama-bapa dong pung negrí sana.’ ” ");
INSERT INTO mkn_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ais Rahel deng Lea manyao bilang, “Neu! Botong iko sa! Te botong su sonde ada pung pusaka apa-apa lai dari bapa Laban. ");
INSERT INTO mkn_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Bagini lama, bapatua su anggap sang botong sama ke orang luar sa. Dia su jual buang sang botong. Ais dia makan buang botong pung belis. ");
INSERT INTO mkn_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Samua harta yang Tuhan Allah ame dari bapa Laban tu, sakarang su jadi botong deng botong pung ana-ana dong pung pusaka. Jadi kalo Tuhan su bilang karmana, na, iko sa!” ");
INSERT INTO mkn_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Ais itu, Yakob mulai manyimpan dia pung barang-barang dong. Ju dia kasi nae dia pung bini-ana dong samua di atas onta, deng foo bawa dia pung binatang dong samua, deng barang-barang yang dia dapa di Padan Aram, ko dong pulang pi tana Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Itu waktu, Laban ada pi gunting dia pung domba dong pung bulu. Ju Rahel curi bawa dia pung bapa pung patong songgo dong. ");
INSERT INTO mkn_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakob dong barangkat diam-diam sa, deng sonde kasi tau dia pung bapa mantu. ");
INSERT INTO mkn_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Dia angka bawa dia pung harta dong samua, ais dong jalan buru-buru lewat kali Efrat, ju dong mangada pi gunung Gilead. ");
INSERT INTO mkn_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Lewat tiga hari, ju Laban dapa kabar bilang, Yakob dong su bangun lari. ");
INSERT INTO mkn_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ais Laban kumpul dia pung orang dong, ko pi buru sang dia pung ana mantu. Dong buru sampe tuju hari, baru dapa sang dong di gunung-gunung Gilead. ");
INSERT INTO mkn_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Dia pung malam, ju Tuhan kasi tunju diri sang Laban dalam mimpi. Dia bilang, “Laban! Nanti, kalo lu omong deng Yakob, lu jaga bae-bae lu pung mulu.” ");
INSERT INTO mkn_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Itu malam, Yakob su pasang tenda di gunung Gilead. Ais Laban dong ju pasang dong pung tenda sonde jao dari situ. ");
INSERT INTO mkn_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ais itu, Laban datang katumu deng Yakob. Ju dia omong bilang, “Heh, Yakob! Akurang ko lu bawa lari beta pung ana parampuan dong diam-diam bagini? Sama ke bawa orang yang lu tawan ame dalam paráng. ");
INSERT INTO mkn_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Masaꞌ lu lari diam-diam, sonde pake togor sang beta lai! Kalo lu kasi tau sang beta bae-bae, tantu beta bekin pesta rame-rame, ko antar sang bosong pake musik, baru lapás sang bosong ko barangkat. ");
INSERT INTO mkn_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Lu pung sala satu lai, andia lu sonde kasi beta sampat ko ciom beta pung ana-cucu dong, baru lapás sang dong. Lu pung cara ni, talalu bodo! ");
INSERT INTO mkn_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Deng gampang beta bisa bekin calaka sang lu! Ma tadi malam, Tuhan Allah, yang lu pung bapa sémba tu, togor sang beta bilang, kalo beta omong deng lu, beta musti jaga bae-bae beta pung mulu. ");
INSERT INTO mkn_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Memang beta mangarti bilang, lu barangkat tagal lu su rindu mau pulang. Ma akurang ko lu masi curi bawa beta pung patong songgo dong?” ");
INSERT INTO mkn_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ais ju Yakob manyao bilang, “Toꞌo jang mara sang beta! Beta jalan diam-diam tu, tagal beta taku, jang sampe toꞌo tahan ame ini ana dong, na, karmana?” ");
INSERT INTO mkn_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ma Yakob sonde tau bilang, dia pung bini Rahel yang curi ame itu patong dong. Jadi dia bilang, “Toꞌo! Soꞌal patong tu, cari sa! Kalo dapa di sapa, na, hukum bekin mati sang dia. Galeda samua sa! Kalo dapa toꞌo pung barang pusaka laen, na, ame pulang. Biar ini orang dong samua jadi saksi.” ");
INSERT INTO mkn_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ais Laban pi galeda dong satu-satu pung tenda. Mula-mula Yakob pung tenda. Ais dia pi di Lea pung tenda. Tarús itu hamba parampuan dua pung tenda dong. Ma dia sonde katumu itu patong dong. Ahirnya, dia maso pi Rahel pung tenda. ");
INSERT INTO mkn_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ma Rahel su sambunyi itu patong dong di kolong onta pung sadel. Ais dia dudu di atas itu sadel. Laban galeda alus-alus di Rahel pung tenda, ma sonde katumu. ");
INSERT INTO mkn_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ju Rahel omong deng dia pung bapa bilang, “Bapa jang mara. Beta sonde bisa badiri, te beta ada datang bulan.” Tarús Laban cari-cari lai, ma dia sonde dapa itu patong dong. ");
INSERT INTO mkn_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ais Yakob pung dara nae, ju dia masparak sang Laban bilang, “Beta su bekin jahat apa sang toꞌo? Sampe toꞌo buru sang beta, tingka ke beta orang jahat! ");
INSERT INTO mkn_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Toꞌo su galeda abis beta pung barang-barang samua. Ais toꞌo dapa apa? Coba taro di muka sini ko kotong samua lia! Biar ini orang dong putus bilang, itu barang, sapa pung. ");
INSERT INTO mkn_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Su 20 taon beta bakuli sang toꞌo. Waktu beta jaga toꞌo pung binatang dong, sonde ada satu yang miskram. Satu ekor ju, beta sonde makan! ");
INSERT INTO mkn_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kalo ada binatang jahat yang bekin mati toꞌo pung binatang satu, beta sonde lapor sang toꞌo, ma beta ganti. Deng kalo orang pancuri toꞌo pung binatang, toꞌo suru beta ganti, biar bukan beta pung sala. ");
INSERT INTO mkn_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Siang-siang, matahari panggang sang beta. Malam-malam, beta gamatar dingin. Beta mete sampe sonde bisa tidor, tagal jaga toꞌo pung binatang. ");
INSERT INTO mkn_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Memang 20 taon tu, batúl! Beta karjá 14 taon, ko dapa toꞌo pung ana parampuan dong. Ais itu, beta karjá tamba lai 6 taon, ko bisa dapa beta pung binatang. Karjá kuli bagitu lama, ma toꞌo maen ganti beta pung sewa sampe sapulu kali. ");
INSERT INTO mkn_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ontong ada Tuhan Allah, yang baꞌi Abraham deng bapa Isak sémba. Kalo Dia sonde jaga sang beta, pasti toꞌo su suru usir pulang sang beta deng tangan kosong. Ma Tuhan Allah sonde tutu mata deng beta pung susa, deng Dia lia beta pung karjá samua. Andia ko tadi malam, Dia datang togor sang toꞌo.” ");
INSERT INTO mkn_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Dengar abis Yakob pung omong bagitu, ju Laban manyao bilang, “Bagini! Itu parampuan dua tu, beta pung ana. Ana-ana yang dong barana ame tu, beta pung cucu samua. Ini binatang samua ni, beta pung. Samua yang lu lia di sini ni, memang beta pung. Ma beta mau bekin apa? Beta sonde bisa tahan sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Jadi lebe bae, kotong dua baꞌika janji. Deng kotong musti idop iko itu janji.” ");
INSERT INTO mkn_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ais itu, Yakob ame satu batu bésar, ko kasi badiri di situ jadi tanda. ");
INSERT INTO mkn_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ais Yakob suru dia pung orang dong, ko pi kumpul batu ko timbun. Ju dong samua dudu makan deka itu batu dong. ");
INSERT INTO mkn_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ais Laban kasi nama itu batu batimbun, Yegar Sahaduta. Ma Yakob kasi nama, Galeed. ");
INSERT INTO mkn_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ais Laban bilang, “Ini batu batimbun ni, jadi saksi kasi kotong dua.” Andia ko itu tampa nama, Galeed. ");
INSERT INTO mkn_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban ju kasi nama itu tampa, Mispa (yang pung bunyi amper sama ke kata laen, yang pung arti ‘tampa jaga yang tinggi’), tagal dia omong bilang, “Nanti TUHAN sandiri yang jaga kotong dua, ko biar kotong bajao ju, kotong jang langgar ini janji. ");
INSERT INTO mkn_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kalo lu bekin jahat sang beta pung ana dong ni, ko, kawin deng parampuan laen dong, tantu beta sonde tau. Ma inga! Tuhan Allah yang jadi saksi sang lu deng beta. ");
INSERT INTO mkn_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Coba lia ini batu yang badiri, deng batu batimbun. Inga, te ini batu dong, ju jadi batas. Lu sonde bole lewat ini batu dong ko bekin jahat sang beta. Deng beta ju sonde bole lewat ini batu dong ko bekin jahat sang lu. ");
INSERT INTO mkn_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kotong ika ini janji ni, pake kotong pung nene-moyang pung Tuhan Allah. Andia lu pung baꞌi Abraham, deng beta pung baꞌi Nahor pung Allah. Nanti Dia sandiri yang jadi hakim ko putus kotong pung parkara.” Dengar abis bagitu, ju Yakob angka sumpa mati, pake nama dari Tuhan Allah yang dia pung bapa Isak sémba. ");
INSERT INTO mkn_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ais itu, Yakob horo binatang, ju dia bawa jadi korban kasi Tuhan di atas itu gunung. Tarús dia pange orang dong samua ko makan rame-rame, deng dong mete sampe pagi di situ. ");
INSERT INTO mkn_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Dia pung beso papagi, ju Laban pi paló-ciom dia pung ana-cucu dong samua. Ais dia omong kasi berkat sang dong, ju dia pulang pi dia pung negrí. ");
INSERT INTO mkn_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ais itu, Yakob dong jalan tarús. Ju Tuhan pung ana bua dong dari sorga datang katumu deng dia. ");
INSERT INTO mkn_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Waktu lia sang dong, ju dia omong bilang, “Mangkali di sini Tuhan pung tantara dong pung tampa barenti!” Andia ko dia kasi nama itu tampa, Mahanaim (yang pung arti ‘dua tampa barenti’). ");
INSERT INTO mkn_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ais itu, Yakob suru dia pung ana bua barapa orang jalan lebe dolo pi negrí Edom (andia, Seir), ko kasi tau dia pung kaka Esau bilang, dia ada mau datang. ");
INSERT INTO mkn_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakob kasi tau dia pung ana bua dong bilang, “Bosong pi kasi tau beta pung kaka Esau bagini: ‘Bos Esau! Bos pung hamba, adi Yakob, kirim salam hormat bam-banya sang bos. Dari beta barangkat dolu sampe sakarang, bos pung hamba ada tenga di toꞌo Laban pung ruma. ");
INSERT INTO mkn_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Sakarang bos pung hamba su ada pung sapi, keledai, kambing-domba, hamba laki-laki deng hamba parampuan. Beta kirim ini orang dong lebe dolo, ko kasi kabar sang bos, soꞌal beta pung datang. Beta harap, bos suka tarima sang botong deng tangan tabuka.’ ” Ju itu orang dong pi. ");
INSERT INTO mkn_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Waktu dong datang kambali sang Yakob, dong lapor bilang, “Botong su pi katumu deng bapa pung kaka Esau. Sakarang dia ada jalan datang deng 400 laki-laki, ko mau katumu deng bapa.” ");
INSERT INTO mkn_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Dengar bagitu, ju Yakob pung hati duk-dak, deng dia taku mau mati. Ais dia bagi dia pung orang deng binatang dong samua, jadi dua rombongan. ");
INSERT INTO mkn_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Dia pikir bilang, “Kalo Esau datang, ko saráng ame rombongan partama, na, rombongan kadua bisa lari cari salamat.” ");
INSERT INTO mkn_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ais itu, Yakob sambayang bilang, “Tuhan Allah, é! Tuhan yang beta pung baꞌi Abraham deng beta pung bapa Isak sémba. Dengar sang beta dolo! Tempo hari, Tuhan yang suru beta ko pulang datang di beta pung kelu dong, di ini negrí. Tuhan yang janji bilang, nanti Tuhan ator bekin beres samua. ");
INSERT INTO mkn_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Beta sonde pantas tarima Tuhan pung sayang, deng Tuhan pung satia. Dolu waktu beta langgar kali Yarden, beta cuma bawa tongkat sa. Ma sakarang beta pulang datang bawa dua rombongan manusia deng binatang. ");
INSERT INTO mkn_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Beta taku, jang-jangan kaka Esau datang saráng bekin mati sang botong samua. Jadi beta minta ko Tuhan kasi salamat sang beta deng beta pung bini-ana dong samua dari kaka Esau. ");
INSERT INTO mkn_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tuhan yang janji bilang, Tuhan kasi berkat bam-banya sang beta, deng bekin beta pung turunan batamba banya, sama ke pasir di pante yang orang sonde bisa itong ame.” ");
INSERT INTO mkn_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ais Yakob tidor di itu tampa. Dia pung beso, ju dia pili ame binatang ko mau kasi parsén sang dia pung kaka. ");
INSERT INTO mkn_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Dia pili ame 200 kambing mai, 20 kambing laki, 200 domba mai, 20 domba laki, ");
INSERT INTO mkn_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 onta mai deng dong pung ana yang masi susu, 40 sapi mai, 10 sapi laki, 20 keledai mai, deng 10 keledai laki. ");
INSERT INTO mkn_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ais dia bagi itu binatang dong, satu-satu macam deng dia pung rombongan. Tarús dia kasi satu-satu rombongan deng dia pung gambala. Dia kasi tau sang dong bilang, “Bosong jalan lebe dolo. Nanti beta iko dari balakang. Ma bosong musti jaga ko rombongan yang satu sadiki jao dari rombongan yang laen.” ");
INSERT INTO mkn_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ais Yakob parenta gambala dari rombongan partama bilang, “Kalo beta pung kaka Esau katumu deng lu, deng dia tanya bilang, ‘Lu mau pi mana? Lu ni, sapa pung hamba? Ini binatang dong, sapa pung?’ ");
INSERT INTO mkn_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Naa, bosong musti manyao bilang, ‘Ini binatang dong, bos pung hamba Yakob pung. Dia kirim kasi sang dia pung kaka, bos Esau. Ma dia sandiri ada iko dari balakang.’ ” ");
INSERT INTO mkn_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Dia ju kasi parenta bagitu sang samua gambala dari rombongan laen dong bilang, “Kalo su katumu deng kaka Esau, bosong kasi parsén itu binatang dong. Tarús bosong kasi tau bilang, beta ada iko dari balakang.” Yakob pikir, kalo dia kasi itu binatang dong samua sang Esau, nanti Esau pung hati jadi noe deng dia. ");
INSERT INTO mkn_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Jadi dia kirim itu binatang dong lebe dolo. Ma itu malam, dia masi tenga di situ. ");
INSERT INTO mkn_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Itu malam, ju Yakob bangun, ais dia ator ko dia pung bini dua-dua, dia pung bini piara dua-dua, deng dia pung ana 11 orang, ko dong langgar pi kali Yabok pung sablá. ");
INSERT INTO mkn_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Waktu dong samua su sampe di sablá, ju dia kirim dia pung pusaka samua pi sana. ");
INSERT INTO mkn_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ma Yakob tenga sandiri di situ. Ais ju ada satu laki-laki datang, ko bagulat deng dia sampe amper siang. ");
INSERT INTO mkn_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Waktu itu laki-laki rasa dia su mau kala, ju dia hantam Yakob pung pinggul, sampe dia pung tulang bonggol talapás dari dia pung tampa dudu. ");
INSERT INTO mkn_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Tarús itu laki-laki bilang, “Lapás sang beta, te lai sadiki matahari su mau nae.” Ma Yakob manyao bilang, “Lu omong kasi berkat sang beta dolo, baru beta lapás sang lu!” ");
INSERT INTO mkn_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ju itu laki-laki tanya bilang, “Lu pung nama, sapa?” Dia manyao bilang, “Yakob.” ");
INSERT INTO mkn_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ais, itu laki-laki omong bilang, “Lu pung nama, bukan Yakob lai. Ma mulai sakarang, orang pange sang lu Israꞌel, tagal lu su bajuang lawan manusia deng Tuhan Allah, sampe lu manáng.” (Nama Israꞌel pung arti ‘yang bagulat deng Allah’.) ");
INSERT INTO mkn_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Tarús Yakob tanya bilang, “Lu pung nama, sapa?” Ma itu laki-laki bilang, “Lu mau tanya beta pung nama bekin apa?” Ais ju dia omong kasi berkat sang Yakob di situ. ");
INSERT INTO mkn_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ais Yakob omong bilang, “Beta su dapa lia Tuhan Allah muka deng muka, ma beta masi idop.” Andia ko dia kasi nama itu tampa, Peniꞌel, yang dia pung arti ‘Tuhan pung muka’. ");
INSERT INTO mkn_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Matahari su nae waktu Yakob jalan kasi tenga itu tampa. Ma dia jalan doka-doka, tagal dia pung pinggul tasala. ");
INSERT INTO mkn_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Andia ko sampe sakarang, orang Israꞌel dong sonde makan daging dari binatang pung pinggul, tagal Tuhan puku bekin tasala dong pung baꞌi Yakob pung tulang pinggul. ");
INSERT INTO mkn_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Itu hari, ju Yakob dapa lia Esau datang deng dia pung rombongan 400 orang. Ais dia babagi dia pung ana dong kasi pi dong pung mama satu-satu. ");
INSERT INTO mkn_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Dia ator ko itu dua bini piara deng dong pung ana dong jalan di muka. Ais Lea deng dia pung ana dong, baru Rahel deng dia pung ana Yusuf paling balakang. ");
INSERT INTO mkn_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ma Yakob jalan paling muka dari dong samua. Waktu su mau deka deng dia pung kaka, dia tikam lutut deng tondo sampe di tana, tuju kali. ");
INSERT INTO mkn_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ma waktu Esau dapa lia dia pung adi, ju dia lari pi katumu sang Yakob, ais paló-ciom sang dia. Ju dong dua bamanangis. ");
INSERT INTO mkn_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Waktu Esau dapa lia itu parampuan deng ana-ana dong, ju dia tanya bilang, “Ko ini orang dong samua ni, sapa?” Ju Yakob manyao bilang, “Dong tu, orang-orang yang Tuhan Allah su kasi sang beta, kaka pung hamba.” ");
INSERT INTO mkn_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ais itu, ju dia pung bini piara dong, deng dong pung ana-ana, datang soya sang Esau. ");
INSERT INTO mkn_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Tarús Lea deng dia pung ana dong, datang soya sang Esau. Paling balakang, Yusuf deng dia pung mama Rahel datang soya sang Esau. ");
INSERT INTO mkn_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ais ju Esau tanya bilang, “Itu rombongan binatang yang lu kirim tadi tu, dia pung maksud apa?” Ju Yakob manyao bilang, “Bagini, kaka! Beta parsén samua kasi sang kaka, ko biar kaka tarima sang beta deng hati luas.” ");
INSERT INTO mkn_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ma Esau balas bilang, “Adi Yakob! Beta pung harta ju banya. Jadi lu sonde usa kasi apa-apa sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ais Yakob manyao bilang, “Kaka jang bagitu! Kaka musti tarima, ko jadi tanda bilang, kaka tarima sang beta deng tangan tabuka. Te waktu beta lia kaka pung senyum tadi, tingka ke beta lia Tuhan Allah pung senyum. ");
INSERT INTO mkn_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Jadi beta minta deng hormat, ko biar kaka tarima beta pung hadia yang sonde ada pung arti ni. Te Tuhan Allah su talalu bae sang beta, andia ko Dia su kasi samua yang beta parlú.” Yakob kokoe tarús sang dia, sampe mau tar mau, Esau tarima itu hadia dong. ");
INSERT INTO mkn_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ais itu, Esau omong bilang, “Kalo bagitu, na, bosong siap ko kotong jalan su! Nanti beta antar sang bosong.” ");
INSERT INTO mkn_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ma Yakob manyao bilang, “Sonde usa, kaka! Kaka lia sandiri. Ana-ana dong masi kici-kici, deng sonde bisa jalan capát. Binatang yang baru barana dong, ju banya. Kalo kotong paksa sang dong jalan capát, dalam satu hari sa, nanti ini binatang dong bisa mati samua. ");
INSERT INTO mkn_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Jadi lebe bae, kaka dong jalan lebe dolo sa. Nanti botong samua jalan palán-palán dari balakang. Nanti beta datang lia sang kaka di Seir.” ");
INSERT INTO mkn_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ais itu, Esau omong lai bilang, “Kalo bagitu, na, beta kasi tenga beta pung ana bua saparu deng lu, ko dong tunju jalan kasi bosong.” Ma Yakob bilang, “Kaka sonde usa repot-repot! Yang pantíng, beta su tau kaka su tarima bae sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Dengar bagitu, ju Esau jalan kasi tenga sang dong, ko pulang pi Seir. ");
INSERT INTO mkn_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ma dari situ, Yakob pi Sukot. Di situ, dia bangun ruma deng bekin kandang kasi dia pung binatang dong samua. Andia ko itu tampa, dong kasi nama Sukot (yang pung arti ‘ruma tahan’). ");
INSERT INTO mkn_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ahirnya, Yakob dong sampe deng salamat dari Padan Aram pi kampong Sikem di negrí Kanaꞌan. Ais dong pasang tenda ko tenga deka-deka di itu kampong. ");
INSERT INTO mkn_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Itu tana yang Yakob pasang tenda tu, dia béli putus dari Hemor, Sikem pung bapa. Dia bayar deng 100 doi perak. ");
INSERT INTO mkn_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Di situ, dia susun batu ko bekin meja korban. Ais dia kasi nama itu tampa El-Elohe-Israꞌel yang dia pung arti ‘Allah tu, Israꞌel pung Allah’. ");
INSERT INTO mkn_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Satu kali, Yakob deng Lea pung ana parampuan, Dina, pi bakunjung sang nona-nona dari itu negrí. ");
INSERT INTO mkn_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Itu negrí pung raja, nama Hemor, dari suku Hewi. Dia pung ana laki-laki, nama Sikem. Satu kali, Sikem dapa lia sang Dina, ju bawa lari sang dia, ais parkosa sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikem jato hati sang Dina deng cinta mau mati sang dia. Jadi Sikem omong manis-manis deng Dina, ko biar Dina ju balas dia pung cinta. ");
INSERT INTO mkn_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ais Sikem kasi tau dia pung bapa bilang, “Bapa! Tolong pi maso minta sang Dina, ko beta bisa kawin deng dia.” ");
INSERT INTO mkn_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakob dapa dengar ada orang su parkosa dia pung ana parampuan, ma dia diam-diam sa, deng sonde bekin apa-apa. Te itu waktu, dia pung ana laki-laki dong ada jaga binatang di padang. Jadi dia tunggu sampe dong pulang samua. ");
INSERT INTO mkn_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Itu waktu, Sikem pung bapa Hemor datang sang Yakob ko mau maso minta sang Dina. ");
INSERT INTO mkn_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Pas dong dua ada baꞌomong, Yakob pung ana-ana dong pulang dari padang. Waktu dong dengar bilang, Sikem su parkosa dong pung adi parampuan, ju dong saki hati, deng mara mau mati. Ais dong bilang, “Hal macam bagitu, sonde pantas ada di Israꞌel. Jadi kotong sonde bole tarima orang bekin jahat macam bagitu.” ");
INSERT INTO mkn_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ju Hemor kokoe sang Yakob dong bilang, “Sodara Yakob! Beta pung ana Sikem su jato cinta batúl-batúl sang sodara pung ana parampuan. Jadi beta minta ko kasi isin beta pung ana kawin deng dia. ");
INSERT INTO mkn_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kalo bisa, na, kotong pung ana-ana dong baꞌame. Bosong pung ana laki-laki kawin deng botong pung ana parampuan. Deng botong pung ana laki-laki kawin deng bosong pung ana parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Biar bosong tenga bacampor deng botong di sini. Bosong bebas pili mau tenga di mana sa. Ais badagang, deng dapa harta di sini.” ");
INSERT INTO mkn_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Ais itu, Sikem omong deng Dina pung bapa, deng dia pung kaka dong bilang, “Bosong mau minta apa sa, beta iko. Bosong mau minta dia pung doi tutu malu, deng dia pung belis barapa sa, beta bayar. Asal bosong kasi isin ko beta kawin deng bosong pung adi parampuan.” ");
INSERT INTO mkn_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ma Yakob pung ana-ana dong su tau bilang, Sikem su parkosa dong pung adi Dina. Jadi dong manyao putar-balek sang Sikem deng dia pung bapa Hemor. ");
INSERT INTO mkn_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ais dong manyao bilang, “Botong sonde bisa kasi kawin botong pung adi deng orang yang sonde sunat! Itu bekin malu sang botong! ");
INSERT INTO mkn_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ma dia pung jalan kaluar, bagini: bosong laki-laki samua, kici-bésar, musti sunat sama ke botong. ");
INSERT INTO mkn_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kalo bosong bekin bagitu, baru botong bisa baꞌame. Deng botong ju bisa tenga sama-sama deng bosong di sini, ko kotong bisa jadi satu bangsa. ");
INSERT INTO mkn_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ma kalo bosong sonde iko botong pung mau, deng sonde mau sunat, nanti botong ame pulang botong pung adi, ais botong bangun jalan dari sini.” ");
INSERT INTO mkn_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hemor deng Sikem tarima bae dong pung omong. ");
INSERT INTO mkn_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ma Sikem su sonde sabar lai, tagal dia su cinta mati sang Dina. Naa, samua orang di itu negrí hormat sang Sikem. ");
INSERT INTO mkn_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Jadi Hemor deng Sikem pi di tampa urus parkara di kampong pung pintu maso, ais dong barunding deng samua orang di itu negrí. Dong omong bilang, ");
INSERT INTO mkn_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Sodara dong samua! Ini orang Israꞌel dong suka idop dame deng kotong. Jadi biar ko dong tenga sama-sama deng kotong di ini negrí. Ini negrí cukup luas buat kotong samua. Kotong bisa baꞌame deng dong pung ana nona. Dong ju bisa bakawin deng kotong pung ana nona dong. ");
INSERT INTO mkn_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Dong cuma minta satu hal kici sa, dari kotong. Andia, kotong laki-laki samua musti sunat sama ke dong. ");
INSERT INTO mkn_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kalo kotong su idop bagabung, nanti dong pung binatang deng harta samua ju jadi kotong pung pusaka, wuang? Jadi lebe bae kotong tarima dong pung mau. Mari botong samua sunat sama-sama! Satuju, ko?” ");
INSERT INTO mkn_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ais samua orang yang bakumpul di situ, satuju deng Hemor deng Sikem pung omong. Ju samua laki-laki di itu negrí dong sunat rame-rame. ");
INSERT INTO mkn_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Dia pung hari katiga, waktu samua yang kaná sunat dong pung luka masi saki, ju Dina pung kaka, Simeon deng Lewi, hela ame dong pung kalewang, ais dong maso diam-diam pi dalam kampong. Ju dong bunu itu laki-laki dong samua. ");
INSERT INTO mkn_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hemor deng Sikem ju kaná bunu. Tarús dong ame bawa sang Dina kaluar dari Sikem pung ruma, ko dong pulang. ");
INSERT INTO mkn_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ais itu, Yakob pung ana laen dong maso pi dalam itu negrí, ko dong rampok itu negrí pung isi. Dong mara, tagal orang su parkosa dong pung adi parampuan di situ. ");
INSERT INTO mkn_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Dong rampas orang pung barang samua dari dalam ruma, deng dong foo bawa orang pung binatang samua dari padang. ");
INSERT INTO mkn_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Dong ame bawa samua parampuan, deng ana-ana, deng rampas itu negrí pung barang mahal dong samua. ");
INSERT INTO mkn_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Waktu Yakob dapa tau itu hal, dia omong deng Simeon deng Lewi bilang, “Bosong su bekin karjá bodo apa ni? Bekin susa sang beta sa! Nanti orang Kanaꞌan, orang Peris, deng samua orang di ini daꞌera, binci mati sang kotong. Dong pung orang banya. Ma kotong pung orang cuma sadiki sa. Kalo dong sarbú datang, na, kotong ancor memang, suda ma.” ");
INSERT INTO mkn_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ma dong manyao deng mara bilang, “Bapa! Bapa kira botong mau kasi biar dong bekin botong pung adi jadi parampuan nakal, ko?” ");
INSERT INTO mkn_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ais itu, ju Tuhan Allah omong deng Yakob bilang, “Beta ni, Allah yang su kasi tunju diri sang lu, waktu lu lari dari lu pung kaka Esau. Sakarang lu pinda suda pi Betel. Sampe di situ, lu kasi bangun meja korban kasi Beta. Ais lu tenga di situ suda.” ");
INSERT INTO mkn_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Ais itu, Yakob omong deng dia pung isi ruma dong samua bilang, “Sakarang kotong samua mau barangkat pi Betel. Dolu waktu beta dalam susa, Tuhan Allah tolong sang beta di situ. Beta mau kasi badiri meja korban di situ. Jadi sakarang bosong angka buang bosong pung patong songgo samua. Bekin barisi bosong pung diri, deng ganti pakean, te kotong mau sémba sang Tuhan.” ");
INSERT INTO mkn_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tarús dong sarakan dong pung patong songgo deng dong pung anteng-anteng samua. Ais Yakob kubur itu barang dong samua di bawa pohon bésar satu deka kampong Sikem. ");
INSERT INTO mkn_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Waktu Yakob pung rombongan dong barangkat dari Sikem, Tuhan Allah kirim rasa taku kasi orang-orang di negrí kuliling dong, sampe dong sonde barani bekin jahat sang Yakob dong. ");
INSERT INTO mkn_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ju Yakob deng dia pung rombongan samua, sampe deng salamat di Betel (yang dolu, nama Lus), di tana Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Di situ Yakob kasi bangun meja korban dari batu. Ais dia kasi nama itu tampa, El Betel, (yang pung arti ‘Betel pung Allah’), tagal dolu Tuhan Allah kasi tunju Dia pung diri sang Yakob di situ, waktu dia lari dari dia pung kaka. ");
INSERT INTO mkn_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deka deng kampong Betel, ada satu pohon bésar yang orang kasi nama Alon Bakut. Dia pung arti ‘pohon makarereu’. Dia dapa itu nama, tagal waktu Ribka pung mama koko, nama Debora, mati, dong kubur sang dia di bawa itu pohon. ");
INSERT INTO mkn_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Waktu Yakob su kambali dari Padan Aram, Tuhan Allah kasi tunju diri lai, deng kasi berkat sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Tuhan omong bilang, “Mulai sakarang, lu pung nama, bukan Yakob lai. Ma Beta kasi lu nama baru, andia, Israꞌel. ");
INSERT INTO mkn_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Beta ni, Tuhan Allah yang Paling Kuasa. Jadi lu barana-cucu bam-banya suda! Nanti bangsa-bangsa dong kaluar datang dari lu pung turunan. Deng lu nanti barana ame raja-raja dong. ");
INSERT INTO mkn_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Negrí yang Beta su kasi sang lu pung baꞌi Abraham deng bapa Isak tu, sakarang Beta kasi sang lu deng lu pung turunan dong.” ");
INSERT INTO mkn_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Tuhan Allah omong abis bagitu, ju Yakob kasi badiri satu tiang batu di situ, ko biar jadi tanda yang kasi inga Tuhan pung janji. Tarús dia poꞌa aer anggor deng minya di atas itu batu, ko sémba sang Tuhan. ");
INSERT INTO mkn_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Itu tampa, dia kasi nama Betel. ");
INSERT INTO mkn_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ais itu, Yakob dong jalan kasi tenga Betel. Waktu dong masi sadiki jao dari Efrata (andia Betlehem), Rahel pung waktu barana su sampe. Ma dia barana susa. ");
INSERT INTO mkn_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Waktu dia masi muku satenga mati, ju dukun barana kasi tau sang dia bilang, “Mama Rahel! Bekin kuat hati, te mama dapa ana laki-laki lai!” ");
INSERT INTO mkn_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Waktu Rahel su mau putus napas, ju dia kasi nama itu ana, Ben-Oni, (yang dia pung arti ‘ana dari beta pung sangsara’). Ais itu, dia mati. Ma Yakob kasi nama itu ana, Benyamin, (yang dia pung arti ‘ana tangan kanan’). ");
INSERT INTO mkn_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ais ju dong kubur sang Rahel di pinggir jalan yang mau pi Efrata, (yang sakarang, dia pung nama Betlehem). ");
INSERT INTO mkn_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ju Yakob kasi badiri satu batu kubur di situ. Sampe ini hari ju, Rahel pung batu kubur tu, masi ada. ");
INSERT INTO mkn_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ais itu, ju Yakob bapinda-pinda tarús. Satu kali, dia pasang tenda di manara Eder pung sablá. ");
INSERT INTO mkn_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Waktu dong ada di situ, Ruben tidor deng dia pung bapa pung bini piara, Bilha. Yakob dapa tau itu hal. Yakob pung ana laki-laki ada dua blas orang. ");
INSERT INTO mkn_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea pung ana-ana, andia: Ruben (Yakob pung ana sulung), Simeon, Lewi, Yahuda, Isaskar, deng Sebulon. ");
INSERT INTO mkn_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel pung ana-ana, andia: Yusuf deng Benyamin. ");
INSERT INTO mkn_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel pung hamba Bilha pung ana-ana, andia: Dan deng Naftali. ");
INSERT INTO mkn_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ais Lea pung hamba Silpa pung ana-ana, andia: Gad deng Aser. Barana ame itu ana-ana dong di Padan Aram. ");
INSERT INTO mkn_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ais itu, Yakob pi lia dia pung bapa Isak di Mamre deka kampong Kiryat-Arba (andia sakarang, nama Hebron). Dolu dia pung baꞌi Abraham ju tenga di situ. ");
INSERT INTO mkn_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak idop sampe dia pung umur 180 taon, baru dia mati. Tarús dia pung ana Esau deng Yakob kubur sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ini Esau pung turunan dong. Dia pung nama laen, ju Edom. ");
INSERT INTO mkn_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau kawin deng dua nona Kanaꞌan. Yang satu, orang Het, andia Elon pung ana parampuan, nama Ada. Yang kadua, orang Hewi, nama Oholibama. Dia pung bapa, nama Anah, deng dia pung baꞌi, nama Sibeon. ");
INSERT INTO mkn_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau ju kawin deng Ismael pung ana parampuan, nama Basmat. Basmat pung kaka laki-laki, nama Nebayot. ");
INSERT INTO mkn_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau pung bini tua, Ada, barana sang Elifas. Basmat barana sang Rehuel. ");
INSERT INTO mkn_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ais Oholibama barana sang Yeus, Yalam deng Kora. Barana sang Esau pung ana dong samua di negrí Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Satu kali, Esau pinda pi satu negrí laen, jao dari Yakob. Dia bawa dia pung bini-ana, orang karjá, binatang, deng dia pung harta dong samua. ");
INSERT INTO mkn_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau bapisa deng Yakob, tagal dong pung binatang deng harta dong talalu banya. Jadi dong idop basesak di itu negrí. ");
INSERT INTO mkn_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ju Esau (andia Edom), pi tenga di daꞌera bagunung di Seir. ");
INSERT INTO mkn_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ini Esau pung turunan, yang dong bilang ‘orang Edom’. Dong tenga di daꞌera bagunung di Seir. ");
INSERT INTO mkn_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau pung bini Ada, barana satu ana laki-laki, nama Elifas. Elifas pung ana laki-laki ada lima orang. Andia, Teman, Omar, Sefo, Gatam deng Kenas. Elifas pung bini piara, nama Timna. Dia barana satu ana laki-laki, nama Amalek. Esau pung bini Basmat, barana satu ana laki-laki, nama Rehuel. Rehuel dapa ana laki-laki ampa. Andia Nahat, Sera, Syama, deng Misa. ");
INSERT INTO mkn_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau pung bini Oholibama, andia Anah pung ana, yang Sibeon pung cucu tu, barana ana laki-laki tiga. Andia Yeus, Yalam, deng Kora. ");
INSERT INTO mkn_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau pung ana-cucu dong tapica-pica jadi banya suku. Satu-satu deng dong pung kapala suku. Esau pung ana sulung Elifas pung ana dong, jadi kapala suku Teman, kapala suku Omar, kapala suku Sefo, kapala suku Kenas, kapala suku Kora, kapala suku Gatam, deng kapala suku Amalek. Dong samua tu, Esau deng dia pung bini Ada pung turunan. ");
INSERT INTO mkn_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau pung ana Rehuel pung ana dong, jadi kapala suku Nahat, kapala suku Sera, kapala suku Syama, deng kapala suku Misa. Dong samua tu, Esau deng dia pung bini Basmat pung turunan. ");
INSERT INTO mkn_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau deng dia pung bini Oholibama pung ana dong, jadi kapala suku Yeus, kapala suku Yalam, deng kapala suku Kora. ");
INSERT INTO mkn_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Itu suku dong samua, Esau pung turunan. ");
INSERT INTO mkn_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Di itu tampa, ju ada orang Hori satu, nama Seir. Dia pung ana-ana dong tapica-pica jadi banya suku. Satu-satu deng dong pung kapala suku. Ais dia pung ana jadi kapala suku Lotan, kapala suku Sobal, kapala suku Sibeon, kapala suku Anah, kapala suku Dison, kapala suku Eser, deng kapala suku Disan. ");
INSERT INTO mkn_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan pung ana, andia Hori deng Heman. (Lotan pung sodara parampuan, Timna). ");
INSERT INTO mkn_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal pung ana-ana, andia Alwan, Manahat, Ebal, Sefo, deng Onam. ");
INSERT INTO mkn_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon pung ana-ana, andia Aya deng Anah. Anah tu, yang dapa katumu mata aer panas di padang pasir, waktu dia gambala dia pung bapa pung keledai dong. ");
INSERT INTO mkn_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anah pung ana parampuan, andia Oholibama. Deng ana laki-laki, andia Dison. Dison pung ana-ana, andia Hemdan, Esban, Yitran, deng Keran. ");
INSERT INTO mkn_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser pung ana-ana, andia Bilhan, Saꞌawan, deng Akan. ");
INSERT INTO mkn_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan pung ana-ana, andia Us deng Aran. ");
INSERT INTO mkn_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Jadi kapala-kapala suku orang Hori dong, andia Lotan, Sobal, Sibeon, Anah, Dison, Eser, deng Disan. Dong samua tenga di negrí Seir. ");
INSERT INTO mkn_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Waktu negrí Israꞌel balóm ada raja, di tana Edom su ada pung raja. Dong pung nama baꞌiko-baꞌiko, andia: ");
INSERT INTO mkn_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Dong angka Beor pung ana, nama Bela, jadi raja di kota Dinhaba. ");
INSERT INTO mkn_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Waktu Bela mati, Yobab nae jadi raja, ganti sang dia. Dia pung bapa, nama Sera dari kampong Bosra. ");
INSERT INTO mkn_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Waktu Yobab mati, Husam nae jadi raja, ganti sang dia. Husam tu, dari orang Teman dong pung negrí. ");
INSERT INTO mkn_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Waktu Husam mati, Hadad nae jadi raja, ganti sang dia. Dia pung bapa, nama Bedad dari kampong Awit. (Dia tu, yang kasi kala orang Midian waktu dong baparáng di Moab.) ");
INSERT INTO mkn_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Waktu Hadad mati, Samla nae jadi raja, ganti sang dia. Samla tu, dari kampong Masreka. ");
INSERT INTO mkn_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Waktu Samla mati, Saul nae jadi raja, ganti sang dia. Saul tu, dari kampong Rehobot di pinggir kali. ");
INSERT INTO mkn_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Waktu Saul mati, Baꞌal-Hanan nae jadi raja, ganti sang dia. Dia pung bapa, nama Akbor. ");
INSERT INTO mkn_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Waktu Baꞌal-Hanan mati, Hadar nae jadi raja, ganti sang dia. Hadar tu, dari kampong Pau. Dia pung bini, nama Mehetabel. Mehetabel pung bapa, nama Matret. Deng dia pung baꞌi, Mesahab. ");
INSERT INTO mkn_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Jadi kapala-kapala suku yang turun dari Esau dong, andia: Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel, deng Iram. Dong satu-satu kasi nama dong pung negrí iko dong pung nama sandiri-sandiri. Jadi itu samua, carita soꞌal Esau pung turunan, andia orang Edom dong. ");
INSERT INTO mkn_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Ini Yakob dong pung carita. Tempo hari, Yakob pi tenga ulang lai di tana Kanaꞌan. Itu dia pung papa Isak pung tampa tenga dari dolu. ");
INSERT INTO mkn_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Itu waktu, Yakob pung ana satu dari dia pung bini Rahel, nama Yusuf. Waktu dia pung umur tuju blas taon, dia deng dia pung kaka dong biasa pi jaga dong pung kambing-domba sama-sama. Dia pung kaka dong, ana dari Yakob pung bini, Bilha deng Silpa. Ma Yusuf ni, tukang bawa mulu kasi dia pung papa, soꞌal dia pung kaka dong. ");
INSERT INTO mkn_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Waktu barana sang Yusuf, Yakob su tua. Andia ko dia sayang sang Yusuf lebe dari dia pung ana-ana laen dong. Satu kali, Yakob bekin satu baju panjang yang talalu bagus kasi sang Yusuf. ");
INSERT INTO mkn_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Waktu dia pung kaka dong lia papa lebe sayang sang Yusuf, dong binci mati sang dia, sampe dong sonde mau baꞌomong bae-bae deng dia lai. ");
INSERT INTO mkn_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Satu malam, ju Yusuf mimpi. Ais dia kasi tau itu mimpi sang dia pung kaka dong bilang, “We! Bosong dengar dolo! Beta mimpi bilang, kotong samua ada ika kotong pung padi-gandum dalam kabón. Ju beta pung padi badiri lurus. Ma bosong pung padi dong badiri kuliling, ko soya beta pung.” Dengar bagitu, ju dia pung kaka dong tamba jengkel lai sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ais ju dong togor sang Yusuf bilang, “Woi! Lu kira lu su mau jadi bos ko parenta sang botong, ko?” Te dong su talalu jengkel sang dia, tagal dia kasi tau itu mimpi. ");
INSERT INTO mkn_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ais itu, Yusuf mimpi ulang lai. Ju dia kasi tau dia pung kaka dong bilang, “We! Beta mimpi lai. Beta lia matahari, bulan, deng sablás bintang. Samua soya bae-bae sang beta.” ");
INSERT INTO mkn_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Waktu Yusuf su carita abis itu mimpi sang dia pung papa deng dia pung kaka dong, dia pung papa togor karás sang dia bilang, “Mimpi ke apa tu! Lu pikir beta, lu pung mama, deng lu pung kaka-adi dong datang ko kotong ciom lu pung kaki? Lu pung mau lai!” ");
INSERT INTO mkn_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Jadi Yusuf pung kaka dong camburu mati sang dia. Ma dia pung papa sonde abis pikir itu mimpi. ");
INSERT INTO mkn_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ais satu waktu, Yusuf pung kaka dong bawa dong pung papa pung kambing-domba sampe deka deng kampong Sikem. ");
INSERT INTO mkn_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Sonde lama, ju dia pung papa bilang, “Usu, é! Lu pung kaka dong ada jaga kambing-domba deka-deka di Sikem. Jadi siap-siap ko lu pi lia sang dong dolo.” Ais Yusuf manyao bilang, “Bae, papa.” ");
INSERT INTO mkn_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ju dia pung papa bilang, “Lu pi dolo ko lia lu pung kaka dong, deng beta pung kambing-domba dong. Dong ada karmana, na, lu kambali ko lapor sang beta.” Ais ju Yusuf jalan kasi tenga tana Hebron pung padang, ko pi tarús sampe di Sikem. ");
INSERT INTO mkn_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Sampe deng sampe ju, dia cari kuliling sang dong di itu padang. Ais ju dia katumu satu orang yang tanya sang dia bilang, “Lu ada cari apa?” ");
INSERT INTO mkn_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusuf manyao bilang, “Om. Beta ada cari beta pung kaka dong. Dong ada foo kambing-domba cari rumput deka-deka di sini. Om ada lia sang dong, ko?” ");
INSERT INTO mkn_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ais, itu orang kasi tau bilang, “Dong sonde ada di sini lai. Ma dong bilang dong mau pi deka-deka di kampong Dotan.” Ais ju Yusuf pi iko dia pung kaka dong, sampe dapa lia sang dong di Dotan. ");
INSERT INTO mkn_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ma waktu Yusuf masi jao, te dong su dapa lia sang dia. Ju dong baꞌakór ko mau bunu sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ais dong kasi tau satu deng satu bilang, “Bosong lia dolo. Bos tukang mimpi su datang! ");
INSERT INTO mkn_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mari suda ko kotong bunu sang dia. Abis, na, kotong lempar buang sang dia pi dalam parigi mati satu. Nanti kotong kasi tau sang papa bilang binatang utan dong su makan buang sang dia! Baru kotong lia dia pung mimpi dong jadi karmana!” ");
INSERT INTO mkn_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Dengar abis, ju dia pung kaka Ruben cari jalan ko mau kasi salamat sang Yusuf. Ju dia togor sang dia pung adi dong bilang, “We! Kotong jang bunu sang dia! ");
INSERT INTO mkn_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Lebe bae kotong buang sang dia pi dalam ini parigi mati sa. Di sini tampa sunyi, jadi sonde ada orang yang tau. Asal jang bekin badara sang dia.” Dia omong bagitu, tagal dia mau kasi lapás sang Yusuf, ko suru dia pulang. ");
INSERT INTO mkn_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ais waktu Yusuf sampe di dong, dia pung kaka dong pegang ame sang dia, ju dong ruꞌi buang dia pung baju yang bagus tu. ");
INSERT INTO mkn_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ais itu, dong hela raroso sang dia, ju dong tola maso pi dalam parigi mati. ");
INSERT INTO mkn_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ais ju dong kambali ko pi makan. Dong masi makan, ju takuju dong dapa lia satu rombongan datang. Itu rombongan pung onta dong ada mua bawa barang dagang, sama ke dara kayu wangi, bumbu-bumbu, deng obat macam-macam. Tau-tau te itu rombongan orang Ismael yang datang dari kampong Gilead mau pi jao sakali di negrí Masir. ");
INSERT INTO mkn_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ais itu, Yahuda kasi tau dia pung kaka-adi dong bilang, “We! Lebe bae bagini sa. Kotong jang bunu sang dia. Dia pung ontong apa? Biar karmana ju, kotong sonde bisa sambunyi dia pung dara. ");
INSERT INTO mkn_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ada lebe bae kotong pi jual sang dia di itu orang Ismael dong. Biar kotong bekin karmana sang dia, ju dia masi kotong pung adi barana. Tagal itu, kotong jang bekin saki sang dia, é!” Ju dong samua baꞌakór deng dia pung omong. ");
INSERT INTO mkn_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ais pas deng itu orang dagang dong lewat, ju Yusuf pung kaka dong hela nae sang dia dari itu parigi. Ju dong jual sang dia pi di itu orang Ismael dong deng harga dua pulu doi perak. Ais itu, ju dong bawa sang Yusuf pi Masir. ");
INSERT INTO mkn_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Waktu dong jual sang Yusuf tu, Ruben sonde tau. Andia ko waktu dia bale pi itu parigi, dia takuju mati, tagal Yusuf su sonde ada lai. Ais dia robe-robe dia pung pakean di badan, tagal dia pung hati talalu susa. ");
INSERT INTO mkn_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ju dia bale pi dia pung adi dong bilang, “Aduu! Itu ana sonde ada lai di situ! Sakarang beta musti bekin apa lai?” ");
INSERT INTO mkn_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ais dong horo kambing satu ekor, ju dong ame Yusuf pung baju bagus tu, ko calóp pi dalam itu dara. ");
INSERT INTO mkn_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ais dong bawa ame itu baju badara kasi dong pung papa, ko kasi tau bilang, “Papa! Botong dapa pili ini baju. Papa lia coba. Jang-jang ini adi Usu pung baju.” ");
INSERT INTO mkn_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Lia ame itu baju, ju Yakob langsung kanál. Tarús dia manyao bilang, “Aduuu! Ini memang beta pung ana pung baju. Tar tau binatang utan su rabe sang dia di mana. Awee! Beta pung ana su mati!” ");
INSERT INTO mkn_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ais itu, Yakob robe-robe dia pung baju, ju dia pake karong goni, tagal dia susa mau mati. Ju dia manangis makarereu sang dia pung ana sonde pake barenti. ");
INSERT INTO mkn_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Dia pung ana laki-laki deng ana parampuan samua datang kokoe sang dia, ma dong sonde ontong. Dia bilang, “Sonde! Beta bisa susa sampe mati, te beta sonde bisa lupa ini ana satu ni.” Ju Yakob pung hati susa tarús, tagal dia inga dia pung ana Yusuf yang su mati tu. ");
INSERT INTO mkn_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Waktu Yakob masi susa bagitu, te itu orang dagang dong su sampe di Masir. Ais dong pi jual sang Yusuf kasi satu orang bésar, nama Potifar. Dia ni, raja Masir pung komandán jaga. ");
INSERT INTO mkn_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ais itu, Yahuda jalan kasi tenga dia pung kaka-adi dong, ko pi tenga deng dia pung tamán Hira di kampong Adulam. ");
INSERT INTO mkn_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Di situ ada bapa satu, orang Kanaꞌan, nama Sua. Yahuda basuka deng Sua pung ana nona satu, ju dong dua kawin. Ais itu, dia barana barapa ana laki-laki baꞌiko-baꞌiko. ");
INSERT INTO mkn_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ana nomer satu, dong kasi nama Er. ");
INSERT INTO mkn_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Tarús nomer dua, dong kasi nama Onan. ");
INSERT INTO mkn_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ais nomer tiga, nama Sela. Waktu barana sang Sela, ju dong su pinda pi kampong laen, nama Kesib. ");
INSERT INTO mkn_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Waktu ana nomer satu, Er, su bésar datang, Yahuda pi maso minta kasi dia satu nona, nama Tamar. Ais ju dong dua kawin. ");
INSERT INTO mkn_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ma Er talalu jahat. Tagal itu, Tuhan hukum kasi mati sang dia. Andia ko Er mati sonde kasi tenga ana. ");
INSERT INTO mkn_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ais itu, Yahuda suru dia pung ana nomer dua bilang, “Onan! Lu pung kaka su mati, ma sonde ada ana. Jadi sakarang, iko orang tua dong pung biasa, lu musti ganti lu pung kaka ko kawin dia pung bini, ko biar lu kasi turunan sang lu pung kaka.” ");
INSERT INTO mkn_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan su tau itu adat. Ma dia sonde mau kasi turunan sang dia pung kaka Er. Jadi tiap kali, kalo dia tidor deng Tamar, dia buang kaluar dia pung bibit, ko biar Tamar sonde usa barana. ");
INSERT INTO mkn_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan pung cara bagitu, bekin Tuhan mara mau mati. Andia ko Tuhan ju hukum kasi mati sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Waktu Yahuda lia dia pung ana dua-dua yang kawin deng Tamar su mati, ju dia jadi taku. Dia pikir, jang sampe dia pung ana bungsu Sela kawin deng Tamar lai, nanti dia ju mati. Andia ko dia pi kasi tau dia pung ana mantu Tamar bilang, “Ana, é. Lebe bae lu pulang pi lu pung orang tua sa. Nanti beta pung ana Sela su bésar dolo, baru lu kambali ko kawin deng dia.” Ais ju Tamar pulang. ");
INSERT INTO mkn_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Lewat barapa lama, ju Yahuda pung bini mati. Jadi dia susa sampe waktu duka abis. Ais dia pange dia pung tamán Hira, ko dong dua pi kampong Timna. Di situ orang dong ada rame-rame cukur domba pung bulu ko jual. ");
INSERT INTO mkn_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ju orang kasi tau sang Tamar bilang, “Lu pung papa mantu ada pi Timna ko urus orang ko cukur dia pung domba dong pung bulu.” ");
INSERT INTO mkn_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Itu waktu, Yahuda pung ana bungsu Sela su bésar. Ma Tamar su tau bilang, dia pung papa mantu sonde mau kasi dia kawin deng Sela. Tarús Tamar cari akal ko tuntut dia pung hak. Ju dia buka kasi tenga dia pung pakean janda, ais ganti pake pakean bagus. Dia pake salendang ko tutu dia pung kapala deng dia pung muka. Ais dia pi dudu di kampong Enaim pung pintu maso, pas di jalan pi Timna. ");
INSERT INTO mkn_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Waktu Yahuda lewat itu pintu maso kampong, dia dapa lia satu parampuan. Dia kira itu parampuan nakal, tagal Tamar bagaya deng pakean, ais tutu dia pung muka lai. ");
INSERT INTO mkn_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda sonde sangka bilang itu parampuan tu, dia pung ana mantu. Jadi dia pi deka-deka itu parampuan, ko tanya bilang, “We! Kalo beta deng lu, na, lu minta barapa?” Ma Tamar manyao bilang, “Neu! Dari pak pung suka sa.” ");
INSERT INTO mkn_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahuda tawar bilang, “Karmana kalo beta kasi lu kambing satu?” Ais Tamar balas bilang, “Bae, pak. Asal pak kasi beta pegang barang jaminan dolo. Kapan-kapan, baru pak kirim itu kambing datang.” ");
INSERT INTO mkn_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Ju Yahuda tanya lai bilang, “Beta kasi lu barang jaminan apa?” Tamar manyao bilang, “Pak kasi tenga cap yang ada tagantong, deng dia pung tali di pak pung leher. Deng kasi tenga itu tongkat ju.” Dengar bagitu, ju Yahuda kasi itu barang dong sang dia. Ais dong dua pi tidor sama-sama. Ais itu, Tamar pulang. Dia buka dia pung pakean bagus deng dia pung salendang, ko pake ulang dia pung pakean janda. Tau-tau te Tamar su dudu parú. ");
INSERT INTO mkn_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Sonde lama, ju Yahuda minta tolong sang dia pung tamán Hira bilang, “Lu bawa ini kambing kasi itu parampuan nakal di Enaim sana, ko ame kambali beta pung barang yang dia ada pegang.” Hira pi sampe di sana, dia batanya pi-datang, ma sonde dapa katumu itu parampuan. ");
INSERT INTO mkn_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ju dia batanya orang-orang di situ bilang, “We! Bosong ada dapa lia itu palacor yang biasa dudu di pintu maso sini, ko? Dia ada di mana, é?” Ma dong manyao bilang, “Pak, di sini sonde ada parampuan nakal.” ");
INSERT INTO mkn_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Jadi Hira kambali pi Yahuda. Dia kasi tau bilang, “Beta sonde katumu itu parampuan. Beta cari-cari, ma orang di sana kasi tau bilang, di itu tampa sonde ada parampuan nakal.” ");
INSERT INTO mkn_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda manyao bilang, “Biar kasi tenga itu barang dong, ko dia soa sa! Asal orang jang bekin malu sang kotong! Te beta su mau bayar, ma kotong sonde dapa katumu sang dia na.” ");
INSERT INTO mkn_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Lewat tiga bulan, ju orang pi kasi tau sang Yahuda bilang, “Lu pung ana mantu Tamar su bekin diri jadi parampuan nakal. Sakarang dia ada bunting.” Dengar bagitu, ju Yahuda mara mau mati. Ais dia parenta itu orang bilang, “Pi hela bawa itu parampuan datang, ko bakar idop-idop sang dia!” ");
INSERT INTO mkn_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ais dong pi hela bawa sang Tamar. Ma dia kasi kaluar itu cap deng itu tongkat. Ju dia suru dong pi kasi tau dia pung papa mantu bilang, “Papa, tolong pareksa ini barang dong dolo. Ini cap deng tongkat pung tuan ni yang bekin beta dudu parú.” ");
INSERT INTO mkn_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Lia itu barang dong, ju Yahuda kanál memang, te itu dia pung. Ais dia kasi tau bilang, “Memang! Itu parampuan sonde sala. Beta yang sala. Dia yang batúl. Iko adat, na, beta musti kasi kawin dia deng beta pung ana Sela. Ma beta yang sonde mau. Kasi lapás sang dia sa!” Ais ju Yahuda sonde bakumpul lai deng Tamar. ");
INSERT INTO mkn_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar pung waktu barana su sampe, ju dia barana ana bagambar. ");
INSERT INTO mkn_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Waktu dia barana, ana satu kasi kaluar dia pung tangan. Ju ibu bidan ika banáng mera di itu tangan. Dia bilang, “Ini yang nomer satu.” ");
INSERT INTO mkn_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ma itu ana hela kambali dia pung tangan. Ais dia pung kambár yang kaluar lebe dolo. Ibu bidan bilang sang itu ana, “We! Lu ni memang kuat, ó! Andia ko lu baseti kaluar lebe dolo!” Ais dong kasi nama itu ana, Peres (dia pung arti bilang, ‘baseti kaluar’). ");
INSERT INTO mkn_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Abis, baru dia pung adi yang ada ika banáng mera tu kaluar. Dong kasi nama sang dia, Sera (dia pung arti bilang, ‘mera manyala’). ");
INSERT INTO mkn_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Tempo hari, itu orang Ismael dong bawa sang Yusuf pi Masir. Di situ ada orang bésar satu, nama Potifar. Dia tu, kapala dari samua tantara yang bajaga di raja Masir pung ruma jabatan. Ais ju Potifar béli Yusuf dari itu orang dagang dong, ko jadi dia pung budak di dia pung ruma. Di situ, TUHAN tolong sang Yusuf, sampe dia pung karjá samua jadi deng bae. ");
INSERT INTO mkn_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Dia pung bos lia Yusuf pung karjá bagitu bae, ju dia tau batúl TUHAN ada tolong sang Yusuf. ");
INSERT INTO mkn_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Andia ko dia pung bos suka sang Yusuf, deng parcaya sang dia. Tarús dia angka sang Yusuf jadi mandor di dia pung ruma. Dia ju kasi Yusuf urus dia pung ruma deng dia pung pusaka dong samua. ");
INSERT INTO mkn_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Mulai dari Yusuf jadi mandor di situ, Tuhan ju kasi berkat sang dia pung bos, orang Masir tu. Dia pung isi ruma, dia pung pusaka, dia pung kabón, deng dia pung karjá samua jadi deng bae. ");
INSERT INTO mkn_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ais waktu Potifar lia Yusuf urus samua karjá deng bae, andia ko dia sonde pikir apa-apa lai, cuma tau makan sa. Itu waktu, Yusuf talalu gaga. ");
INSERT INTO mkn_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Dia balóm lama tenga di sana, ma Potifar pung bini su jato hati deng dia. Ju dia kokoe ko Yusuf tidor sama-sama deng dia. ");
INSERT INTO mkn_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ma Yusuf sonde mau. Ju dia manyao bilang, “Jang bagitu, mama! Te beta pung bos Potifar su kasi beta kuasa ko urus dia pung karjá samua. ");
INSERT INTO mkn_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Di ini ruma sonde ada orang laen yang pegang kuasa lebe dari beta. Te bos su kasi beta urus samua-samua. Cuma mama sa, yang beta sonde ada hak urus. Karmana ko beta bisa bekin jahat bagitu! Itu ju su malawan Tuhan Allah pung mau!” ");
INSERT INTO mkn_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Biar bagitu, ma tiap hari itu bos pung bini maen kokoe tarús sa. Ma Yusuf sonde toe sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ais satu kali, ju Yusuf maso pi dalam ruma, ko mau lia dia pung karjá. Itu hari, sonde ada orang laen dalam ruma. ");
INSERT INTO mkn_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ju dia pung bos pung bini datang ko pegang Yusuf pung baju, tarús hela ame sang dia, ju bilang, “Mari suda! Sakarang tenga kotong dua sandiri sa. Mari su, kotong dua pi tidor.” Ma Yusuf sonde mau. Ais dia marontak, sampe dia pung baju talapás. Ju dia lari kaluar. Ma itu parampuan masi pegang tarús itu baju. ");
INSERT INTO mkn_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Waktu Potifar pung bini lia Yusuf su lari kaluar kasi tenga dia pung baju, ");
INSERT INTO mkn_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","ju dia pange orang karjá dong, ko kasi tau bilang, “We! Bosong mari lia dolo! Tadi, itu laki-laki Ibrani tu maso beta pung kamar. Dia mau bekin jahat sang beta, ma beta batarea karás-karás. Ini, dia kasi tenga dia pung baju, ais dia lari kaluar. Beta pung laki ni, dia bawa ini orang biadab ko bekin malu-malu sang kotong sa!” ");
INSERT INTO mkn_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ju Potifar pung bini pegang itu baju sampe dia pung laki pulang. ");
INSERT INTO mkn_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Pas dia pung laki pulang, ju dia carita bilang, “Bu, é! Itu orang Ibrani yang bu bawa di sini tu, tadi dia su maso di beta pung kamar, ko mau parkosa sang beta! ");
INSERT INTO mkn_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ma beta batarea karás-karás ko pange orang dong. Ais dia lari fuik, kasi tenga dia pung baju ni.” ");
INSERT INTO mkn_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Dengar dia pung bini carita bagitu, ju Potifar mara mau mati. ");
INSERT INTO mkn_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tarús dia suru orang dong pi tangkap sang Yusuf. Ju dong kasi maso sang dia pi dalam raja pung bui. ");
INSERT INTO mkn_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ma TUHAN sonde lupa sang Yusuf. Andia ko, TUHAN tolong tarús sang dia, sampe itu bui pung bos ju talalu suka sang Yusuf. ");
INSERT INTO mkn_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ais dia parcaya sang Yusuf. Andia ko dia kasi ofer Yusuf urus orang bui dong samua, deng urus samua karjá di situ. ");
INSERT INTO mkn_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Jadi bos su sonde pusing urus apa-apa lai di itu bui. TUHAN tolong tarús sang Yusuf, andia ko samua karjá di itu bui jadi bae. ");
INSERT INTO mkn_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Dalam itu bui, ada dua orang yang parná jadi kapala urusan di raja Masir pung ruma jabatan. Yang satu urus raja pung minum. Yang satu lai urus raja pung roti. Dong dua ada bekin tasala sang raja. Andia ko raja mara, sampe dia kasi maso sang dong pi dalam bui. Jadi dong dua tenga satu tampa deng Yusuf. ");
INSERT INTO mkn_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ais, itu kapala bui parenta sang Yusuf ko urus itu dua pagawe. Dong tenga di situ sampe satu-dua taon. ");
INSERT INTO mkn_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Satu malam, itu dua pagawe mimpi. Satu-satu deng dia pung mimpi sandiri-sandiri. Deng itu mimpi dong pung arti ju laen-laen. ");
INSERT INTO mkn_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Dia pung beso, Yusuf datang, dapa lia dong dua muka susa. ");
INSERT INTO mkn_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ju dia tanya sang dong bilang, “Akurang ko ini hari, bosong pung muka tar enak bagitu?” ");
INSERT INTO mkn_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ju dong manyao bilang, “Tadi malam botong ada mimpi, ma botong sonde tau dia pung arti.” Ais Yusuf omong bilang, “Sonde ada satu manusia yang tau mimpi pung arti, cuma Tuhan Allah sa. Coba bosong carita dolo. Nanti beta cari tau dia pung arti dong dari Tuhan.” ");
INSERT INTO mkn_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ais itu, orang yang urus raja pung minum, carita bilang, “Bagini. Dalam beta pung mimpi, beta dapa lia satu pohon anggor, ");
INSERT INTO mkn_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","bacabang tiga. Itu pohon langsung badaon, babunga, deng babua barangke-rangke sampe masak. ");
INSERT INTO mkn_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ais beta lia, beta ada pegang raja pung galás minum. Ju beta ame itu bua anggor ko parés pi dalam raja pung galás. Ais itu, beta sorong kasi sang raja ko minum.” ");
INSERT INTO mkn_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Dengar bagitu, ju Yusuf kasi tau bilang, “Bapa. Itu mimpi pung arti bagini: itu cabang tiga pung arti, andia tiga hari. ");
INSERT INTO mkn_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dalam tiga hari ni, nanti raja kasi kaluar sang bapa dari bui. Ais dia angka kambali sang bapa, ko urus ulang dia pung minum sama ke dolu. ");
INSERT INTO mkn_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kalo bapa pung nasib su bae bagitu, na, jang lupa sang beta, ó! Kalo bapa sayang sang beta, na, tolong kasi tau sang raja, ko dia ju kasi kaluar sang beta dari sini. ");
INSERT INTO mkn_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ko kalo iko dia pung batúl, dong ame paksa sang beta dari orang Ibrani dong pung kampong. Di sini, beta sonde bekin jahat apa-apa. Ma tau-tau, te dong su kasi maso sang beta di bui, sama ke beta ni, orang jahat sa.” ");
INSERT INTO mkn_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Dengar ame itu mimpi pung arti yang bagus bagitu, ju itu orang yang urus roti carita sang Yusuf bilang, “Adi, é. Beta ju mimpi bagini: beta ada suꞌu bakul tiga susun. ");
INSERT INTO mkn_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Di bakul paling atas, ada isi raja pung kue macam-macam. Ma burung dong datang ko toto bekin abis itu kue dong dari atas beta pung kapala.” ");
INSERT INTO mkn_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Dengar bagitu, ju Yusuf manyao bilang, “Bapa pung mimpi pung arti bagini: itu bakul tiga pung arti, tiga hari ju. ");
INSERT INTO mkn_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dalam tempo tiga hari ni, nanti raja suru orang datang potong buang bapa pung kapala. Ais dong gantong bapa pung badan di tiang. Ju burung dong datang toto bekin abis bapa pung daging.” ");
INSERT INTO mkn_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Lewat tiga hari, pas deng raja pung hari jadi, ju dia bekin pesta bésar kasi dia pung pagawe samua. Dia parenta ko dong pi kasi kaluar itu dua pagawe dari bui. ");
INSERT INTO mkn_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ais itu, dia angka kambali itu pagawe yang urus raja pung minum, pi dia pung pangkat yang dolu, ko dia urus ulang raja pung minum. ");
INSERT INTO mkn_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ma itu pagawe yang urus raja pung roti tu, dong gantong bekin mati sang dia, parsís ke yang Yusuf su omong. ");
INSERT INTO mkn_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ma itu pagawe yang urus minum tu, sonde inga lai sang Yusuf. Te dia su lupa buang sang Yusuf. ");
INSERT INTO mkn_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Lewat dua taon, ju raja Masir dapa mimpi. Dia mimpi, dia ada badiri di kali Nil pung pinggir. ");
INSERT INTO mkn_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Takuju, dia dapa lia tuju sapi gumu-gumuk. Dong pung kulit mangkilat. Dong kaluar dari itu kali, ko makan rumput di situ. ");
INSERT INTO mkn_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ais ju ada tuju sapi laen lai kaluar dari itu kali. Dong pung badan kurus karempeng. Dong badiri deka-deka deng itu sapi gumuk dong. ");
INSERT INTO mkn_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ais, itu tuju sapi kurus dong kodo ame itu tuju sapi gumuk dong. Ju raja takuju bangun. ");
INSERT INTO mkn_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Sonde lama lai, dia sonu ulang. Ju dia mimpi lai. Dia lia tuju buler padi yang baꞌisi kaluar dari satu batang yang subur. ");
INSERT INTO mkn_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ais dia dapa lia lai tuju buler padi yang kosong, su mamalek kaná angin panas. ");
INSERT INTO mkn_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ju samua buler padi yang kosong tu, kodo ame itu tuju buler padi yang baꞌisi. Ais ju raja tabangun. Baru dia tau, dia su mimpi lai. ");
INSERT INTO mkn_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Dia pung pagi, ju raja rasa tar enak. Ju dia parenta orang dong pi pange ame samua dukun deng orang pintar di Masir. Ais dia carita dia pung mimpi sang dong, ma sonde ada yang bisa kasi tau itu mimpi pung arti. ");
INSERT INTO mkn_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ais, itu pagawe yang urus raja pung minum tu, baru dapa inga sang Yusuf. Ju dia pi kasi tau sang raja bilang, “Tuan raja. Beta musti mangaku sala. ");
INSERT INTO mkn_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Dolu, waktu bapa mara sang beta deng beta pung tamán, ko kasi maso di bui, ");
INSERT INTO mkn_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","satu malam ju botong dua mimpi. Satu-satu deng dia pung mimpi, deng dia pung arti laen-laen. ");
INSERT INTO mkn_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Dalam itu bui ju ada satu orang Ibrani yang masi muda. Kapala bui angka sang dia jadi kapala urusan di bui. Botong carita botong pung mimpi sang dia. Ju dia kasi tau itu mimpi dong pung arti. ");
INSERT INTO mkn_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Andia ko tuan raja angka ulang sang beta. Ma beta pung tamán kaná hukum mati. Jadi samua tu, parsís sama ke itu orang Ibrani pung omong!” ");
INSERT INTO mkn_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Dengar bagitu, ju raja suru orang capát-capát pi ame Yusuf dari bui. Ais ju Yusuf pi barias barisi-barisi, deng ganti pakean, ko pi mangada sang raja. ");
INSERT INTO mkn_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Dia sampe, ju raja omong bilang, “Nyong, é! Beta ada mimpi, ma sonde ada satu orang ju yang bisa kasi tau itu mimpi pung arti. Ma ada orang kasi tau sang beta bilang, lu bisa.” ");
INSERT INTO mkn_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ju Yusuf manyao bilang, “Tuan raja. Beta ju sonde tau apa-apa. Cuma Tuhan Allah sa yang bisa kasi tau deng batúl itu mimpi pung arti. Tantu Dia mau kasi tau hal yang bae sang tuan raja.” ");
INSERT INTO mkn_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ais ju raja carita bilang, “Dalam beta pung mimpi tu, beta ada badiri di kali Nil pung pinggir. ");
INSERT INTO mkn_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ju ada tuju sapi gumu-gumuk deng dong pung kulit mangkilat. Dong kaluar dari kali, tarús dong pi makan rumput di kali pung pinggir. ");
INSERT INTO mkn_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ais ju ada tuju sapi laen lai yang datang. Ma itu sapi dong kurus karempeng. Di tana Masir ni, beta balóm parná lia sapi kurus macam bagitu! ");
INSERT INTO mkn_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ma beta heran! Te takuju sa, itu tuju sapi yang kurus tu, kodo abis itu tuju sapi gumu-gumuk. ");
INSERT INTO mkn_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Dong kodo abis, ma itu sapi dong kurus tarús. Ais ju beta takuju bangun. ");
INSERT INTO mkn_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ais itu, beta sonu lai, ju beta mimpi ulang. Beta lia ada tuju buler padi yang baꞌisi, kaluar dari satu batang yang subur. ");
INSERT INTO mkn_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ais beta dapa lia lai tuju buler padi yang kosong, su mamalek kaná angin panas. ");
INSERT INTO mkn_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ju samua buler padi yang kosong tu, kodo ame itu tuju buler padi yang baꞌisi. Ais itu beta tabangun. Ju beta carita itu mimpi di orang pintar dong. Ma sonde ada satu orang yang bisa kasi tau dia pung arti.” ");
INSERT INTO mkn_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ais Yusuf kasi tau bilang, “Tuan raja. Itu dua mimpi pung arti, cuma satu sa. Tuhan Allah su kasi tau memang sang tuan raja apa yang Dia mau bekin. ");
INSERT INTO mkn_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Itu mimpi pung arti bagini: itu tuju sapi gumu-gumuk dong, deng tuju buler padi baꞌisi tu, andia musim kinyang tuju taon. Dong pung arti satu sa. ");
INSERT INTO mkn_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ais, itu tuju sapi yang kurus karempeng, deng itu tuju buler padi yang kosong tu, andia musim lapar tuju taon. ");
INSERT INTO mkn_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Jadi Tuhan Allah su kasi tau memang apa yang Dia mau bekin. Itu sama ke beta su omong tadi. ");
INSERT INTO mkn_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nanti kotong dapa musim kinyang sampe tuju taon di samua tampa di negrí Masir. ");
INSERT INTO mkn_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Ais itu, baru kotong dapa musim lapar sampe tuju taon. Nanti itu musim lapar hebat mati pung! Sampe sonde ada makanan lai di ini negrí. Samua orang lapar mau mati, sampe dong sonde bisa inga lai itu musim kinyang. ");
INSERT INTO mkn_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Naa! Tuan raja dapa mimpi sampe dua kali tu, dia pung arti bilang, Tuhan Allah su ator memang. Sonde lama lai, te apa yang Dia ator tu, su mulai jadi. ");
INSERT INTO mkn_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tagal itu, beta usul bagini: lebe bae tuan raja cari satu orang yang pintar, yang bisa urus deng bae. Ais angka sang dia ko ator bae-bae ini negrí. ");
INSERT INTO mkn_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Waktu musim kinyang tuju taon tu, lebe bae tuan raja ju angka orang laen lai, ko dong kumpul hasil lebe. Itu hasil, dong bagi lima ko simpan satu bagian. ");
INSERT INTO mkn_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Dong musti iko tuan raja pung parenta, ko dong ame padi dari samua kampong di Masir. Ais dong musti simpan itu padi di lumbung-lumbung ko jaga bae-bae. ");
INSERT INTO mkn_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ko nanti itu tuju taon lapar sampe, na, kotong masi ada makanan. Deng ator bagitu, sonde ada orang yang mati lapar.” ");
INSERT INTO mkn_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Dengar Yusuf baꞌomong bagitu, ju raja deng dia pung pagawe tinggi dong satuju deng Yusuf pung usul. ");
INSERT INTO mkn_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ais raja omong bilang, “Tuhan Allah pung Roh pung kuasa su ada memang di Yusuf. Andia ko sonde mungkin botong dapa orang laen lai, yang lebe dari dia.” ");
INSERT INTO mkn_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ais raja omong deng Yusuf bilang, “Tuhan Allah su kasi tau ini hal dong samua sang lu. Sakarang baru botong tau bilang, lu ni pintar. Deng lu pung pintar lebe dari samua orang. ");
INSERT INTO mkn_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Andia ko sakarang beta angka lu jadi beta pung tangan kanan, ko lu jadi bos di beta pung istana. Deng nanti beta pung rakyat samua iko lu pung parenta. Cuma beta sandiri sa, yang lebe dari lu.” ");
INSERT INTO mkn_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Ais itu, ju raja cabu kasi kaluar dia pung cincin stempel, ko kasi maso di Yusuf pung jari. Ju dia omong bilang, “Deng bagini, beta angka lu jadi beta pung tangan kanan di samua negrí Masir.” Ais dia kasi pake Yusuf satu baju panjang yang alus, deng gantong rante mas di dia pung leher. ");
INSERT INTO mkn_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ais itu, dia kasi dia pung kareta kuda nomer dua ko Yusuf nae. Ada orang yang lari di muka kareta ko batarea ulang-ulang bilang, “We! Buka jalan, ó! Kasi hormat! Ada orang bésar mau lewat!” Deng bekin bagitu, raja su angka Yusuf jadi dia pung tangan kanan di tana Masir. ");
INSERT INTO mkn_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ais itu, raja omong deng Yusuf bilang, “Bagini. Lu su tau memang beta ni, raja. Deng beta su kasi tau samua orang di Masir bilang, kalo lu sonde kasi loos, na, dong sonde bisa bekin apa-apa.” ");
INSERT INTO mkn_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ais ju raja kasi nama sang Yusuf, Safnat Panea, iko orang Masir pung nama. Dia ju kasi kawin Yusuf deng satu parampuan, nama Asnat. Yusuf pung bapa mantu, nama Potifera. Dia yang urus agama di kota On. Deng bagitu, Yusuf jadi orang bésar di tana Masir. ");
INSERT INTO mkn_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Waktu dong angka sang Yusuf tu, dia pung umur tiga pulu taon. Ais itu, dia pi lia kuliling samua tampa di tana Masir. ");
INSERT INTO mkn_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Dalam waktu tuju taon musim kinyang tu, kabón dong pung hasil talalu banya. ");
INSERT INTO mkn_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ais Yusuf pi kumpul itu hasil lebe dong, ko dia simpan. Hasil padi dari tampa-tampa deka kota mana, na, dia simpan di itu kota pung lumbung. ");
INSERT INTO mkn_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Sampe hasil padi yang dia kumpul tu, banya talalu, sama ke pasir di pante, sampe sonde ada orang yang bisa ukur lai. ");
INSERT INTO mkn_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Waktu musim lapar balóm sampe, Yusuf pung bini Asnat su barana dua ana laki-laki. ");
INSERT INTO mkn_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ju Yusuf omong bilang, “Tuhan Allah su bekin beta lupa beta pung sangsara waktu beta kaluar dari beta pung papa pung ruma.” Andia ko dia kasi nama sang dia pung ana nomer satu, Manase (yang dia pung bunyi amper sama deng kata laen, yang dia pung arti bilang ‘lupa’). ");
INSERT INTO mkn_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Waktu dia dapa ana nomer dua, ju dia omong lai bilang, “Beta su dapa sangsara banya di ini tampa. Ma Tuhan Allah su kasi berkat deng beta dapa ana di sini.” Ju dia kasi nama itu ana, Efraim. ");
INSERT INTO mkn_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ais musim kinyang tuju taon tu abis. ");
INSERT INTO mkn_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ju musim lapar tuju taon mulai datang, pas deng apa yang Yusuf su omong memang. Di tampa laen orang su lapar. Ma di samua tampa di Masir, ada makanan. ");
INSERT INTO mkn_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Lama-lama ju orang Masir dong mulai lapar. Ais dong pi minta makanan di raja. Ju raja suru dong pi di Yusuf, ko iko Yusuf pung parenta. ");
INSERT INTO mkn_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ma itu musim lapar tamba hebat lai, sampe samua tampa di Masir ju kaná. Ju Yusuf mulai buka samua lumbung ko jual padi kasi orang Masir dong. ");
INSERT INTO mkn_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ais itu, orang dari mana-mana datang béli makanan dari Yusuf di Masir, tagal itu musim lapar batúl-batúl ngarí. ");
INSERT INTO mkn_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Itu waktu, papa Yakob dengar orang bilang ada padi di Masir, ju dia baꞌomong deng dia pung ana dong bilang, “Ana dong, é! Akurang ko bosong dudu-dudu tanganga bodo bagitu sa! ");
INSERT INTO mkn_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Beta su dengar bilang, di Masir ada makanan. Lebe bae bosong pi béli di sana dolo, ko biar kotong jang mati lapar.” ");
INSERT INTO mkn_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ais ju Yusuf pung kaka sapulu orang basiap-siap ko mau pi béli makanan di Masir. ");
INSERT INTO mkn_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ma Yakob sonde mau kasi loos Yusuf pung adi bungsu Benyamin ko pi sama-sama deng dong. Ko dia ada pikir, “Jang sampe itu ana dapa calaka lai!” ");
INSERT INTO mkn_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tagal orang di mana-mana su dengar ada makanan di Masir, andia ko banya orang pi béli di sana. Itu musim lapar ju su sampe di tana Kanaꞌan. Ais Yakob pung ana dong ju pi iko béli di sana. ");
INSERT INTO mkn_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Itu waktu, Yusuf su jadi raja pung tangan kanan di Masir. Kalo orang datang dari mana-mana ko mau béli padi, na, Yusuf yang jual kasi sang dong. Andia ko, waktu dia pung kaka dong sampe, dong pi tikam lutut kasi hormat sang dia sampe dong pung muka kaná tana. ");
INSERT INTO mkn_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Waktu dia lia sang dong, ju dia kanál memang. Ma Yusuf bekin diri sama ke orang Masir, andia ko dong sonde kanál sang dia. Ais dia batanya deng kasar sang dong bilang, “Bosong ni, dari mana?” Ju dong manyao bilang, “Botong ni dari Kanaꞌan. Botong datang ko mau minta béli makan di pak wakil.” ");
INSERT INTO mkn_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ais Yusuf inga dia pung mimpi dolu tu. Ju dia bekin taku sang dong bilang, “Beta sonde parcaya! Pasti bosong samua ni mata-mata. Bosong datang ko mau cari tau tana Masir pung rahasia, ais bale ko saráng sang kotong, to!” ");
INSERT INTO mkn_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ma dong manyao bilang, “Sonde, pak! Botong ni cuma pak pung orang suru-suru sa. Batúl-batúl botong datang cuma mau béli makan sa. ");
INSERT INTO mkn_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Botong samua ni satu bapa barana. Botong bukan mata-mata, pak! Botong orang bae-bae.” ");
INSERT INTO mkn_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ma Yusuf omong tamba karás lai bilang, “Heh! Omong kosong! Jang putar-balek sang beta! Memang bosong ni batúl mata-mata, ma. Tantu bosong datang ko mau cari tau ini negrí pung rahasia dong!” ");
INSERT INTO mkn_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ais dong protes bilang, “Sonde, pak! Botong ni cuma bapa pung orang suru-suru sa! Botong datang dari tana Kanaꞌan. Botong basodara dua blas orang. Botong samua satu papa. Botong pung adi bungsu ada tenga deng papa. Deng botong pung adi satu, su sonde ada lai.” ");
INSERT INTO mkn_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ais Yusuf bale manyao bilang, “Sonde! Su batúl apa yang beta omong tadi tu! Bosong ni memang mata-mata. ");
INSERT INTO mkn_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Naa! Bosong musti kasi bukti dolo, ko beta tau bosong pung omong tadi memang batúl, ko sonde. Beta sumpa! Kalo bosong pung adi bungsu tu sonde datang di sini, na, bosong sonde bisa jalan kasi tenga ini negrí! ");
INSERT INTO mkn_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Jadi bosong pili satu orang ko pi ame itu adi bungsu datang di sini. Yang laen, beta tahan. Beta mau lia bosong omong batúl, ko sonde. Kalo sonde, bosong memang batúl mata-mata.” ");
INSERT INTO mkn_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ais Yusuf suru tahan sang dong di bui tiga hari. ");
INSERT INTO mkn_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Dia pung tiga hari, ju Yusuf pi omong deng dong di bui bilang, “Beta ni, satu orang yang taku sang Tuhan. Deng beta salalu iko Dia pung mau. Beta mau lapás sang bosong, ko biar bosong bisa idop. Ma ada satu sarat. ");
INSERT INTO mkn_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kalo bosong omong jujur, na, bosong musti kasi tunju bukti sang beta. Dia pung jalan bagini: beta tahan satu orang dalam bui. Yang laen pulang ko bawa makanan kasi bosong pung kelu. Te dong ada tunggu bosong pulang bawa makanan. ");
INSERT INTO mkn_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ais bosong bawa datang bosong pung adi tu, ko jadi bukti bilang bosong orang jujur. Ko biar beta jang kasi hukum mati sang bosong.” Dengar bagitu, ju dong satuju. ");
INSERT INTO mkn_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ais dong satu baꞌomong deng satu bilang, “Naa! Sakarang kotong kaná balas dari kotong pung dosa tempo hari, yang kotong su bekin di kotong pung adi. Kotong su lia dia sangsara mati, sampe dia minta tolong, ma kotong sonde toe sang dia. Andia ko sakarang kotong sangsara bagini.” ");
INSERT INTO mkn_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ju Ruben kasi inga sang dong bilang, “We, adi-adi dong! Dolu beta su larang sang bosong, ko jang bekin apa-apa sang itu ana, to! Ma bosong sonde nodek beta pung omong. Andia ko, sakarang kotong pikol Yusuf pung dara suda, ma.” ");
INSERT INTO mkn_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Dong baꞌomong bagitu, ma dong sonde tau bilang, Yusuf ju mangarti dong pung bahasa. Tagal waktu Yusuf baꞌomong deng dong, dia pake bahasa Masir, ais jubir salin pi dalam bahasa Ibrani. ");
INSERT INTO mkn_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Dengar dong baꞌomong bagitu, ju Yusuf bangun kasi tenga sang dong, ko dia pi manangis sandiri di tampa laen. Waktu dia su manangis abis, ju dia kambali pi dong. Ais dia suru orang ika ame sang Simeon di dia pung sodara dong pung muka. ");
INSERT INTO mkn_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ais itu, Yusuf parenta dia pung orang dong, ko isi padi di dia pung kaka dong pung karong-karong. Deng kasi maso kambali satu-satu pung doi di dong pung mulu karong. Dia ju suru kasi sang dong bakál. Tarús, itu orang dong bekin iko Yusuf pung parenta. ");
INSERT INTO mkn_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ais itu, Yusuf pung kaka dong mua ame itu karong padi samua pi dong pung keledai. Ais ju dong bangun pulang. ");
INSERT INTO mkn_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Di tenga jalan dong barenti cape. Ju satu dari dong buka dia pung tali karong, ko mau kasi makan dia pung keledai. Ma dia lia dia pung doi ada di atas padi. ");
INSERT INTO mkn_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Dia takuju mau mati! Tarús dia batarea dia pung kaka dong bilang, “Awii! Bosong mari lia ini dolo! Te kotong su paya ni, ma! Dong su kasi pulang beta pung doi di beta pung karong.” Lia bagitu, ju dong ilang kira ko dong taku mau mati. Ais dong baꞌomong bilang, “Tuhan Allah su bekin apa sang kotong lai ni?” ");
INSERT INTO mkn_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ais dong jalan tarús. Sampe di Kanaꞌan, ju dong carita sang dong pung papa samua yang su jadi. ");
INSERT INTO mkn_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Dong kasi tau bilang, “Papa, é! Itu raja Masir pung tangan kanan tu, talalu sakali, é. Dia pung omong sa, kasar mau mati. Dia tudu sang botong bilang, botong pi mata-mata dia pung negrí. ");
INSERT INTO mkn_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ma botong manyao bilang, ‘Sonde! Botong omong jujur sa. Botong ni bukan mata-mata. ");
INSERT INTO mkn_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Botong orang bae-bae. Botong samua basodara dua blas orang. Botong satu papa barana. Cuma satu su sonde ada lai, deng yang bungsu ada tenga deng papa di Kanaꞌan.’ ");
INSERT INTO mkn_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ais, itu pak bilang, ‘Beta mau coba, bosong ni jujur, ko sonde! Bosong satu musti tenga di sini. Yang laen pulang, bawa padi kasi bosong pung kelu, ko biar dong jang mati lapar. ");
INSERT INTO mkn_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Bosong musti bawa datang bosong pung adi dolo. Deng bagitu, baru beta tau bosong ni bukan mata-mata, ma bosong memang orang jujur. Tarús beta bisa kasi lapás bosong pung sodara yang beta su tahan. Ais beta kasi loos, ko bosong bole pi mana sa, di ini negrí.’ ” ");
INSERT INTO mkn_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Carita abis, ju dong mulai bongkar dong pung isi karong dong. Takuju dong dapa lia satu-satu pung doi masi ada di dong pung karong. Lia bagitu, ju Yakob deng dia pung ana samua taku mau mati. ");
INSERT INTO mkn_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ais itu, Yakob omong deng dong bilang, “Bosong ni su bekin ilang beta pung ana dong. Yusuf sonde ada lai. Ais Simeon ju bagitu. Sakarang ju bosong mau ame bawa Benyamin lai? Bosong ni batúl-batúl mau bekin sangsara sang beta sa!” ");
INSERT INTO mkn_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ju Ruben omong deng dia pung papa bilang, “Papa, é! Sarakan Benyamin sang beta suda. Beta yang tanggong-jawab. Beta janji, nanti beta kasi pulang dia di papa. Ma kalo sonde, na, biar papa bunu beta pung ana laki-laki dua orang.” ");
INSERT INTO mkn_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ma Yakob omong bale bilang, “Sonde bisa! Bosong sonde bole bawa sang Benyamin. Te dia pung kaka Yusuf su mati. Sakarang tenga dia sandiri sa. Kalo dia ju calaka di tenga jalan, bosong bekin susa tamba di beta pung kapala sampe beta maso kubur.” ");
INSERT INTO mkn_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Itu waktu, musim lapar di Kanaꞌan tamba hebat lai. ");
INSERT INTO mkn_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yakob pung kelu dong su bekin abis itu makanan yang tempo hari dia pung ana dong bawa dari Masir. Ais dia kasi tau sang dong bilang, “Ana dong, é! Lebe bae bosong kambali pi Masir, ko béli kasi kotong padi lai dolo.” ");
INSERT INTO mkn_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ma Yahuda manyao bilang, “Papa! Tempo hari, itu raja Masir pung tangan kanan su kasi inga karás sang botong bilang, botong sonde bole kasi tunju muka sang dia, kalo botong sonde bawa papa pung ana bungsu Benyamin! ");
INSERT INTO mkn_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Jadi papa musti kasi loos sang adi Benyamin, ko iko sang botong dolo. Baru botong mau pi béli makanan kasi papa. ");
INSERT INTO mkn_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ma kalo papa sonde kasi sang Benyamin pi, na, botong ju sonde akan pi. Te itu orang Masir su omong bagitu na!” ");
INSERT INTO mkn_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ju Yakob togor sang dong bilang, “Akurang ko bosong su kasi tau itu orang bilang, bosong pung adi masi satu lai! Bosong cari-cari ko bekin susa sang beta sa!” ");
INSERT INTO mkn_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ais dong kokoe bilang, “Papa, é! Itu orang maen batanya tarús, ko mau cari tau kotong, deng kotong pung kelu samua na. Dia batanya bilang, ‘Karmana? Bosong pung papa masi idop, ko? Bosong masi ada adi laki-laki laen lai, ko?’ Ais botong mau bilang apa lai! Tarpaksa botong omong jujur sa. Ko sapa pi tau bilang, dia mau suru botong bawa botong pung adi pi sana?” ");
INSERT INTO mkn_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Ju Yahuda omong tamba lai bilang, “Papa! Kasi loos ini ana pi deng botong suda. Beta janji, kalo jadi apa-apa sang dia, na, biar beta yang tanggong ganti dia. Kalo beta sonde bawa pulang sang dia idop-idop kasi papa, na, biar papa mua itu sala sang beta sampe mati. Jadi papa kasi loos ini ana suda, te botong su mau jalan ni. Lebe bae botong pi capát-capát, ko jang ada yang mati lapar. ");
INSERT INTO mkn_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Coba kalo botong sonde tunggu bagini lama, na, tantu botong su pulang bale dua kali.” ");
INSERT INTO mkn_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ais ju dong pung papa bilang, “Kalo bagitu, bosong bekin bagini sa. Pi ame kotong pung hasil tana yang paling bae. Andia: madu, bumbu-bumbu, dara kayu wangi, salap obat, kanari deng kacang utan yang laen dong. Ais bawa kasi itu raja Masir pung tangan kanan, ko bilang ini kotong pung ole-ole. ");
INSERT INTO mkn_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Bosong ju bawa doi dua kali lipat, tagal bosong musti kasi pulang doi yang bosong dapa di bosong pung karong tempo hari tu. Mangkali itu orang dong yang bekin tasala. ");
INSERT INTO mkn_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bosong ju bawa bosong pung adi, ais capát bale pi sana, é! ");
INSERT INTO mkn_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Beta doꞌa-doꞌa ko Tuhan Allah yang Paling Kuasa, bekin raja Masir pung tangan kanan, ko dia rasa kasian sang bosong. Sampe dia mau kasi pulang Benyamin deng Simeon sang bosong, ko bosong samua pulang sama-sama. Ma kalo beta pung ana dong musti ilang, biar beta pikol itu susa tarús sa.” ");
INSERT INTO mkn_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ais itu, dong pi kumpul ame itu ole-ole deng doi dong, ko bawa pi Masir. Dong ju bawa sang Benyamin. Sampe sana, ju dong pi mangada sang Yusuf. ");
INSERT INTO mkn_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Waktu Yusuf lia Benyamin deng dia pung kaka dong, ju dia suru dia pung kapala urusan bilang, “We! Bawa ini orang dong pi beta pung ruma! Ais pi horo sapi satu ko bamasa ena-ena. Te nanti dong makan siang deng beta.” ");
INSERT INTO mkn_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ais, itu kapala urusan bekin iko Yusuf pung parenta. Ju dia antar bawa sang dong pi Yusuf pung ruma. ");
INSERT INTO mkn_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Waktu dong bajalan pi Yusuf pung ruma, dia pung kaka dong taku mau mati. Di tenga jalan dong baꞌomong bilang, “Weh! Akurang ko dia suru bawa sang kotong di sini? Jang-jangan dia mau bekin susa sang kotong, tagal itu doi yang dong su kasi kambali di kotong pung karong tempo hari tu. Dong sangaja antar kotong di sini, ko takuju sa, dong tangkap ame sang kotong ko bekin jadi dia pung budak. Abis, na, dong rampas ame kotong pung keledai samua.” ");
INSERT INTO mkn_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Andia ko, waktu dong su deka-deka Yusuf pung ruma, ju dong omong deng itu kapala urusan bilang, ");
INSERT INTO mkn_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Pak! Botong minta maꞌaf, te tempo hari botong su parná datang béli makanan di sini. ");
INSERT INTO mkn_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Ais waktu botong pulang kampong, botong barenti di jalan ko mau tidor. Tarús botong buka karong ko mau kasi makan binatang dong. Tau-tau te botong dapa kambali satu-satu pung doi béli padi tu, dalam karong. Botong sonde tau sapa yang taro di situ! Ma sakarang botong su bawa pulang itu doi dong samua. Jadi pak jang mara, ó! Biar pak tau, sakarang botong ju ada bawa doi laen lai, ko mau béli makanan baru.” ");
INSERT INTO mkn_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ais, itu kapala urusan manyao bilang, “Bosong tanáng sa! Sonde usa taku! Mangkali bosong pung Tuhan yang kasi berkat sang bosong dalam itu karong dong. Tempo hari, beta su tarima bosong pung doi samua, ma. Bosong sonde ada utang lai!” Ais ju dia lapás kasi kaluar sang Simeon pi dong. ");
INSERT INTO mkn_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tarús dong samua maso pi dalam Yusuf pung ruma. Ais, itu kapala urusan kasi aer ko dong cuci kasi barisi dong pung kaki. Dia ju kasi makan dong pung keledai dong. ");
INSERT INTO mkn_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ais dia kasi tau bilang, “Nanti bosong makan siang sama-sama deng bos.” Waktu dong masi tunggu-tunggu Yusuf pung datang, dong ator memang dong pung ole-ole. ");
INSERT INTO mkn_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Waktu Yusuf sampe, ju dong samua tikam lutut di dia pung muka. Ais dong sorong dong pung ole-ole dong kasi sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ais Yusuf tanya sang dong bilang, “Karmana? Bosong samua babae, ko? Karmana deng bosong pung papa yang su tua tu? Dia ju ada babae, ko?” ");
INSERT INTO mkn_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Dong manyao bilang, “Pak pung hamba tua, yang botong pung papa barana ada babae sa.” Ju dong tondo ko kasi hormat lai sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ais itu, Yusuf buang mata kuliling, sampe dia dapa lia dia pung adi Benyamin. Dong dua tu, satu bapa, satu mama. Ju dia bilang, “Ooo! Andia ni, bosong pung adi bungsu yang bosong su carita tempo hari tu, ko?” Ais dia omong deng Benyamin bilang, “Ana, é! Beta doꞌa-doꞌa ko Tuhan Allah kasi berkat bam-banya sang lu.” ");
INSERT INTO mkn_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Lia sang Benyamin tu, Yusuf pung rindu su mau tapoꞌa kaluar. Te dia sayang mau mati dia pung adi na. Dia su sonde bisa tahan dia pung hati lai. Ju dia capát-capát kasi tenga sang dong, ko maso pi dia pung kamar. Ais dia manangis maskakeduk di situ. ");
INSERT INTO mkn_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Manangis abis, ju dia pi cuci muka. Dia bekin tanáng dia pung hati, ais dia kaluar pi katumu sang dong. Ju dia suru dia pung pambantu dong pi ator meja. ");
INSERT INTO mkn_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ais dong taro kasi Yusuf makan di meja sandiri. Dia pung kaka-adi dong makan di meja laen. Dia pung staf orang Masir dong, ju makan di dong pung meja sandiri, tagal orang Masir dong rasa noju dudu makan bacampor deng orang Ibrani. ");
INSERT INTO mkn_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Itu kapala urusan su ator ko Yusuf pung kaka-adi dong dudu bamangada deng Yusuf. Dia ator sang dong satu-satu dudu iko dong pung umur, mulai dari yang paling kaka sampe yang paling adi. Waktu dong lia cara ator dudu bagitu, dong heran. ");
INSERT INTO mkn_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ais Yusuf ator ko pambantu dong ame kasi dia pung kaka-adi dong makanan dari dia pung meja sandiri. Dong samua tarima sama banya. Ma dong taro kasi Benyamin pung, lebe banya lima kali dari dia pung kaka dong. Ais ju dong samua makan-minum sampe takinyang-kinyang. ");
INSERT INTO mkn_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Dong makan abis, ju Yusuf bakusu-kusu deng dia pung kapala urusan bilang, “Lu pi isi ini orang dong pung karong satu-satu deng padi sampe ponu. Ais lu taro ulang dong pung doi pi dalam satu-satu pung karong. ");
INSERT INTO mkn_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ais lu ame beta pung mok perak, ko taro pi di ana bungsu pung karong.” Ju dia pi bekin iko Yusuf pung parenta. ");
INSERT INTO mkn_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Dia pung beso papagi, ju Yusuf lapás sang dong ko pulang bawa makanan deng dong pung keledai. ");
INSERT INTO mkn_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Dong balóm jalan talalu jao dari kota, ju Yusuf kasi tau dia pung kapala urusan bilang, “Lu pi buru iko itu orang dong capát-capát. Kalo su katumu sang dong, lu bilang bagini: ‘Akurang ko bosong pung hati culas deng bapatua? Ko bosong balas dia pung bae deng jahat bagini! ");
INSERT INTO mkn_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Karmana ko bosong sampe hati pancuri bawa bos pung mok perak? Bosong sonde tau, ko? Itu bukan bos pung mok minum sa! Dia ju pake itu mok ko cari tau orang pung nasib. Te itu mok ilmu na! Bosong pung bekin ni, memang su talalu jahat!’ ” ");
INSERT INTO mkn_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ais ju itu kapala urusan pi buru sang dong sampe dapa. Ju dia kasi tau sang dong, iko Yusuf pung omong tadi. ");
INSERT INTO mkn_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ais dong protes bilang, “Pak pung maksud karmana ni? Botong sumpa. Botong sonde mungkin bekin jahat bagitu! ");
INSERT INTO mkn_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Pak sandiri su tau, to? Itu doi dong dalam botong pung karong tempo hari tu, botong su kasi kambali sang pak, to? Jadi, karmana ko botong bisa pancuri bos pung mas ko perak dari dia pung ruma! Sonde mungkin! ");
INSERT INTO mkn_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Pak pareksa sa! Dapa itu barang di sapa pung karong, hukum mati sang dia suda! Deng biar botong yang laen ni, jadi pak pung budak sa.” ");
INSERT INTO mkn_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ais, itu kapala urusan bilang, “Sonde! Bagini sa. Kalo dapa itu mok di sapa, na, dia jadi beta pung kuli. Yang laen bole pulang.” ");
INSERT INTO mkn_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ju dong kasi turun capát-capát itu karong dong. Tarús dong buka memang. ");
INSERT INTO mkn_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ais, itu kapala urusan pareksa alus-alus itu karong dong satu-satu, mulai dari yang paling kaka pung karong, sampe yang paling kici pung. Ju dia dapa lia itu mok perak di Benyamin pung karong. ");
INSERT INTO mkn_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Lia bagitu, ju Benyamin pung kaka dong pung hati ancor-ancor. Ais dong kasi nae kambali itu karong dong di atas keledai, ju dong bale pi kota. ");
INSERT INTO mkn_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Waktu dong sampe di Yusuf pung ruma, dia masi ada di situ. Ju dong tikam lutut di dia pung muka. ");
INSERT INTO mkn_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ais Yusuf masparak sang dong bilang, “Heh! Akurang ko bosong bekin beta bagini! Bosong sonde tau bilang, orang bésar ke beta ni, bisa pake ilmu ko cari tau orang pung rahasia?” ");
INSERT INTO mkn_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ais Yahuda manyao bilang, “Awii! Tuhan Allah su kasi talanjang botong pung sala dong. Ais botong mau bilang apa lai, pak? Botong mau bela diri karmana lai. Kalo pak mau tahan sang botong pung adi bungsu ni, na, lebe bae pak tahan botong samua. Ame botong samua jadi pak pung budak sa.” ");
INSERT INTO mkn_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ma Yusuf manyao bilang, “Sonde! Dapa itu mok di sapa, na, dia tu yang jadi beta pung kuli! Bosong yang laen dong, bebas. Pulang pi bosong pung papa suda!” ");
INSERT INTO mkn_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ais itu, Yahuda pi deka-deka sang Yusuf, ju omong bilang, “Pak wakil! Beta tau pak pung kuasa sama ke raja sandiri. Tagal itu, jang mara sang beta dolo. Te beta parmisi minta baꞌomong sadiki deng pak. ");
INSERT INTO mkn_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Kamaren pak su tanya sang botong bilang, ‘Bosong pung papa deng adi yang satu masi ada, ko?’ ");
INSERT INTO mkn_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ais botong manyao bilang, ‘Botong pung papa su tua. Deng ada ju botong pung adi bungsu satu. Waktu barana sang dia, papa su tua. Itu adi bungsu pung kaka barana ada satu, ma dia su mati. Dong dua pung mama su mati ju. Jadi sakarang, tenga adi bungsu sandiri sa. Andia ko, botong pung papa sayang mau mati sang dia.’ ");
INSERT INTO mkn_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ais pak suru botong bawa datang botong pung adi tu, ko pak bisa lia sang dia. ");
INSERT INTO mkn_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ju botong manyao bilang, itu ana sonde bisa kasi tenga dia pung papa. Kalo dia kasi tenga, na, botong pung papa su mati, andia tu. ");
INSERT INTO mkn_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tarús pak manyao bilang, ‘Kalo bosong sonde bawa sang bosong pung adi tu, na, bosong sonde bisa lia beta pung muka lai.’ ");
INSERT INTO mkn_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ais ju botong pulang. Sampe di papa, ju botong kasi tau pak pung omong samua tu. ");
INSERT INTO mkn_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Lama-lama ju botong pung makanan su abis. Ais papa suru botong datang ulang di Masir ko béli makanan lai. ");
INSERT INTO mkn_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ma botong balas bilang, ‘Papa, é! Botong sonde bisa pi sana lai. Te raja pung tangan kanan su bilang, kalo botong sonde bawa botong pung adi bungsu, na, botong sonde bisa lia dia pung muka. Jadi botong pung adi bungsu musti iko dolo, baru botong jalan.’ ");
INSERT INTO mkn_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ais itu, botong pung papa omong lai bilang, ‘Bosong su tau, to? Beta pung bini Rahel pung ana cuma dua sa. ");
INSERT INTO mkn_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ana yang partama su sonde ada lai. Pasti binatang utan su kodo ame sang dia. Andia ko sampe sakarang, beta sonde dapa lia sang dia lai. ");
INSERT INTO mkn_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kalo bosong ame ini ana bungsu dari beta lai, tarús dia kaná calaka, na, bosong bekin tamba susa beta yang su tua ni, ko beta mati memang.’ ");
INSERT INTO mkn_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Bagini, pak wakil. Kalo beta kambali pi papa, deng sonde bawa ini adi bungsu, pasti botong pung papa su mati, andia tu. Ko dia pung jiwa taꞌika deng ini ana na. Dia su talalu tua, sampe kalo botong bekin tamba susa sang dia, pasti dia mati. ");
INSERT INTO mkn_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Tamba lai, beta su bajanji deng papa bilang, beta yang jamin ini ana. Beta bajanji sang papa, kalo beta sonde bawa bale ini ana pi dia, na biar beta tanggong itu sala sampe mati. ");
INSERT INTO mkn_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Jadi beta minta bagini, pak: biar beta sa yang tenga di sini ganti dia, jadi pak pung budak. Biar dia pulang deng dia pung kaka dong. ");
INSERT INTO mkn_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kalo ini ana sonde iko, na, beta ju sonde bisa pulang. Beta sonde bisa tahan lia papa pung sangsara sampe mati.” ");
INSERT INTO mkn_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Dengar bagitu, ju Yusuf pung hati noe sampe sonde bisa tahan lai di dia pung pagawe dong pung muka. Andia ko dia suru dong kaluar, ko dia bisa tenga sandiri deng dia pung kaka-adi dong. Deng bagitu, dia bisa mangaku dia pung diri tu, sapa. ");
INSERT INTO mkn_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ais, itu pagawe dong samua kaluar, ju Yusuf manangis makarereu karás-karás, sampe orang Masir dong di luar itu kamar dapa dengar. Deng orang-orang di raja pung ruma ju dapa dengar. ");
INSERT INTO mkn_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ais Yusuf kasi tau tarús taráng sang dia pung sodara dong bilang, “We! Kaka-adi dong, é! Beta ni Yusuf, bosong pung sodara! Papa memang masi idop, to?” Dengar bagitu, ju dia pung kaka-adi dong taku mau mati, sampe dong sonde bisa omong apa-apa lai. ");
INSERT INTO mkn_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ais ju Yusuf gape sang dong bilang, “We! Mari bosong datang deka-deka di sini dolo.” Ju dong pi deka deng Yusuf. Tarús dia omong ulang bilang, “Beta ni Yusuf, yang tempo hari bosong jual buang pi Masir. ");
INSERT INTO mkn_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Bosong memang su jual buang sang beta. Ma bosong jang taku, deng jang bakanjar kasi sala satu deng satu lai. Padahal, Tuhan Allah sandiri yang bawa beta datang di sini lebe dolo dari bosong. Ko deng bagitu, Dia pake sang beta ko kasi salamat banya orang, ko dong jang mati lapar. ");
INSERT INTO mkn_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Sakarang musim lapar baru jalan dua taon. Masi ada sisa lima taon lai. Itu waktu, orang sonde akan bale tana, sonde batanam, deng sonde dapa hasil apa-apa. ");
INSERT INTO mkn_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Deng ini cara yang kotong sonde mangarti ni, Tuhan Allah bawa beta lebe dolo dari bosong. Ko biar ada dari bosong, deng bosong pung ana-upu dong, yang salamat. ");
INSERT INTO mkn_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Jadi yang batúl, bukan bosong pung bekin sampe beta ada di sini, ma ini Tuhan Allah pung karjá. Dia yang bekin sang beta jadi raja pung tangan kanan di Masir. Ju beta jadi kapala urusan di raja pung ruma jabatan. Sonde ada orang laen yang lebe bésar dari beta. ");
INSERT INTO mkn_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Naa, sakarang bosong pulang capát suda, ko kasi tau beta pung omong sang papa, bilang bagini: ‘Papa pung ana Yusuf tu, masi idop! Dia su jadi orang bésar di negrí Masir. Dia ju minta papa pi Masir capát-capát. ");
INSERT INTO mkn_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nanti papa bole tenga di daꞌera Gosen deka deng dia. Itu tampa bae deng luas. Jadi papa bisa piara papa pung kambing-domba deng sapi dong samua. Ais dia ju minta ko papa datang deng ana-upu, isi ruma, deng dong pung pusaka samua ko tenga tarús di sana. ");
INSERT INTO mkn_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kalo papa di Gosen, na, dia bisa jaga papa di sana. Te musim lapar masi lima taon lai. Jadi dia nanti ator ko papa, kelu dong, deng papa pung binatang samua sonde kurang satu apa ju.’ ” ");
INSERT INTO mkn_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusuf kasi tau abis, ju dia omong lai bilang, “Sakarang bosong su lia sandiri, to? Ais lu ju, Benyamin. Beta ni, memang Yusuf. ");
INSERT INTO mkn_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Jadi kasi tau sang kotong pung papa bilang, beta pung kuasa di Masir ni talalu bésar. Deng carita ju sang papa samua-samua yang bosong su lia. Ais itu, bosong bawa datang papa capát-capát di sini suda!” ");
INSERT INTO mkn_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ais dia paló dia pung adi Benyamin, ko dong dua manangis. ");
INSERT INTO mkn_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Dia ju paló ame dia pung kaka dong, ko dia ciom satu-satu. Ais itu, baru dong mulai baꞌomong deng dia. ");
INSERT INTO mkn_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ais itu, waktu raja deng dia pung pagawe dong dengar Yusuf pung kaka-adi dong ada datang, ju dong samua sanáng. ");
INSERT INTO mkn_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ais ju raja baꞌomong deng Yusuf bilang, “Yusuf, é! Kasi tau lu pung kaka-adi dong, ko dong mua ame padi di dong pung keledai, ko bawa pulang pi Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ais suru dong bawa datang lu pung papa deng kelu samua, ko dong pinda di sini suda. Nanti beta kasi dong tana yang paling bae di Masir, ko dong bisa idop di situ, deng dong makan dari itu tana pung hasil. ");
INSERT INTO mkn_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ju kasi tau sang dong, ko dong bawa memang barapa kareta dari sini, ko nanti dong mua ame ana-ana kici deng lu pung papa. ");
INSERT INTO mkn_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Jang pikir itu pusaka yang dong sonde bisa angka bawa, te samua yang paling bae di Masir, nanti dong soa.” ");
INSERT INTO mkn_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Dengar bagitu, ju Yusuf kasi dong barapa kareta deng bakál di jalan, iko raja pung parenta. Deng dia pung kaka-adi dong ju manyimpan ko pulang iko raja pung parenta. ");
INSERT INTO mkn_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusuf ju kasi sang dong satu-satu pakean baru satu pasang. Ma dia kasi Benyamin doi perak tiga ratus, deng pakean baru lima pasang. ");
INSERT INTO mkn_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Dia ju kirim kasi dia pung papa barang-barang yang paling bae dari Masir, ko mua di atas sapulu keledai laki. Dia kasi tamba lai, padi, roti, deng makanan macam-macam, di atas sapulu keledai mai, ko jadi bakál buat dong bale datang pi Masir. ");
INSERT INTO mkn_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ais itu, dia kasi pulang sang dong, deng kasi inga bilang, “Bosong jang bakanjar di jalan, é!” ");
INSERT INTO mkn_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ais ju dong jalan pulang pi dong pung papa di Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Sampe di sana, ju dong kasi tau dong pung papa bilang, “Papa, é! Papa pung ana Yusuf masi idop. Dia su jadi orang bésar ko parenta di Masir!” Waktu Yakob dengar, ju dia tanganga bodo, deng dia sonde parcaya dong pung omong. ");
INSERT INTO mkn_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ma waktu dong su kasi tau abis Yusuf pung omong, deng dia dapa lia kareta yang Yusuf kirim ko mau mua bawa sang dia pi Masir, baru dia mulai parcaya. ");
INSERT INTO mkn_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Tarús dia omong bilang, “Awii! Beta pung ana masi idop, ó! Bagitu baru beta sanáng! Beta musti pi lia sang dia dolo, baru beta bisa mati deng tanáng.” ");
INSERT INTO mkn_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ais itu, Yakob manyimpan dia pung barang-barang dong, ju dong barangkat kasi tenga Kanaꞌan. Sampe di kampong Barseba, ju dia horo binatang ko bekin korban kasi Tuhan Allah, yang dia pung papa Isak sémba dari dolu. ");
INSERT INTO mkn_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ais satu malam ju dia mimpi. Dalam mimpi, dia dengar Tuhan Allah pange sang dia bilang, “We! Yakob! Lu bangun dolo ko dengar!” Ju dia manyao bilang, “Kanapa?” ");
INSERT INTO mkn_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ais Tuhan bilang, “Beta ni Tuhan Allah yang lu pung papa su sémba dari dolu. Lu jang taku pi Masir. Te Beta nanti bekin lu pung turunan jadi bangsa yang bésar di sana. ");
INSERT INTO mkn_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Beta nanti pi Masir sama-sama deng lu. Deng nanti Beta ju bawa pulang lu pung turunan kambali pi tana Kanaꞌan. Nanti, waktu lu mati, lu pung ana Yusuf dapa lu pung napas.” ");
INSERT INTO mkn_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ais itu, Yakob deng dia pung ana dong kasi tenga kampong Barseba. Ju dong kasi nae sang dia deng dong pung bini-ana, di atas kareta yang raja Masir su kirim datang. ");
INSERT INTO mkn_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Tarús dong ame bawa dong pung pusaka deng dong pung binatang samua yang su jadi dong pung milik di tana Kanaꞌan. Ais Yakob deng dia pung ana laki-laki, dia pung ana parampuan, deng dia pung cucu-cece dong samua, jalan pi Masir. ");
INSERT INTO mkn_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakob pung kelu yang iko pinda pi Masir, andia: Ruben, ana partama. ");
INSERT INTO mkn_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Dia pung ana-ana dong, andia: Henok, Palu, Hesron, deng Karmi. ");
INSERT INTO mkn_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon deng dia pung ana-ana. Andia: Yemuel, Yamin, Ohad, Yakin, deng Sohar. Deng Saul, andia dia pung ana dari bini orang Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi deng dia pung ana-ana. Andia: Gerson, Kehat, deng Merari. ");
INSERT INTO mkn_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda deng dia pung ana-ana. Andia: Sela, Peres deng Sera. Yahuda pung ana laen, Er deng Onan, su mati di Kanaꞌan. Dia ju bawa Peres pung ana-ana, andia: Hesron deng Hamul. ");
INSERT INTO mkn_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskar deng dia pung ana-ana. Andia: Tola, Pua, Ayub, deng Simron. ");
INSERT INTO mkn_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon deng dia pung ana-ana. Andia: Sered, Elon, deng Yahleel. ");
INSERT INTO mkn_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Dong samua tu, Yakob deng dia pung bini Lea pung ana barana waktu dong tenga di Mesopotamia. Ada lai dong pung ana parampuan, nama Dina. Jadi Yakob deng Lea pung turunan samua ada tiga pulu tiga orang. ");
INSERT INTO mkn_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Tarús, ada dia pung ana-ana dari bini laen. Andia, Gad, deng dia pung ana-ana: Sifion, Hagi, Suni, Esbon, Eri, Arodi, deng Areli. ");
INSERT INTO mkn_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser deng dia pung ana-ana. Andia: Yimna, Yiswa, Yiswi, Beria, deng dong pung sodara parampuan, nama Sera. Ada ju Beria pung ana-ana: Heber deng Malkiel. ");
INSERT INTO mkn_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dong samua tu, ada anam blas orang. Andia Yakob deng dia pung bini Silpa pung ana-upu. Silpa tu, andia babu yang Laban kasi sang dia pung ana parampuan Lea, Yakob pung bini tua. ");
INSERT INTO mkn_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Tarús, ada lai Yakob pung bini laen, nama Rahel. Dia barana dua ana. Andia Yusuf deng Benyamin. ");
INSERT INTO mkn_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Itu waktu, Yusuf su kawin deng Asnat di Masir. Dia pung papa mantu tu, kapala agama di kota On. Dia pung nama Potifera. Ais Yusuf deng Asnat pung ana-ana, andia, Efraim deng Manase. ");
INSERT INTO mkn_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin ju iko pi Masir deng dia pung ana-ana. Andia: Bela, Beker, Asibel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, deng Ared. ");
INSERT INTO mkn_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ais Yakob deng dia pung bini Rahel pung turunan tu, ada ampa blas orang. ");
INSERT INTO mkn_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ais itu, masi ada Yakob pung bini satu lai, nama Bilha. Dong pung ana, andia Dan deng Naftali. Dan pung ana, nama Husim. ");
INSERT INTO mkn_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali deng dia pung ana-ana. Andia: Yasel, Guni, Yeser deng Silem. ");
INSERT INTO mkn_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakob deng dia pung bini Bilha pung turunan tu, ada tuju orang. Bilha tu, andia Rahel pung babu yang dia dapa dari dia pung papa Laban. ");
INSERT INTO mkn_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jadi Yakob pung turunan samua yang pi Masir ada anam pulu anam orang. Balóm maso dia pung ana mantu dong. ");
INSERT INTO mkn_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tamba deng Yusuf pung ana yang lahir di Masir, dua orang. Jadi Yakob deng dia pung kelu yang tenga di Masir, samua ada tuju pulu orang. ");
INSERT INTO mkn_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Waktu dong su amper deka Masir, Yakob suru dia pung ana Yahuda jalan lebe dolo, ko pi pange sang Yusuf datang katumu deng dia pung papa di Gosen. Waktu dong su sampe di Gosen, ");
INSERT INTO mkn_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ju Yusuf nae pi dia pung kareta, ko pi katumu deng dia pung papa di situ. Waktu dong bakatumu, ju Yusuf paló dia pung papa, ju manangis lama sakali. ");
INSERT INTO mkn_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ais Yakob omong deng Yusuf bilang, “Ana Yusuf, é! Sakarang beta sandiri su lia sang lu. Deng beta su tau lu masi idop. Andia, biar beta mati sakarang ju bae.” ");
INSERT INTO mkn_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ais ju Yusuf kasi tau sang dia pung kaka-adi dong samua bilang, “Beta musti pi kasi tau sang raja bilang, beta pung kelu dong su datang dari Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ju nanti beta kasi tau bilang, bosong ni, orang yang piara domba deng sapi. Andia ko bosong ju ada bawa bosong pung binatang deng pusaka dong dari Kanaꞌan. ");
INSERT INTO mkn_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kalo nanti raja pange bosong, ais dia tanya bosong biasa karjá apa, ");
INSERT INTO mkn_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","na, bosong manyao suda sang dia bilang, bosong samua ni, tukang piara binatang dari kici-kici, sama ke bosong pung nene-moyang dong. Deng bagitu, nanti dia suru bosong tenga di daꞌera Gosen.” Yusuf kasi tau bagitu, tagal orang Masir dong rasa noju kalo dong tenga bakumpul deng gambala dong. ");
INSERT INTO mkn_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Ais ju Yusuf deng dia pung sodara lima orang pi mangada sang raja. Yusuf kasi kanál bilang, “Tuan raja! Beta pung papa deng beta pung kaka-adi dong su datang dari Kanaꞌan. Dong datang deng dong pung kambing-domba, dong pung sapi deng dong pung barang-barang samua. Sakarang dong samua su ada di daꞌera Gosen.” ");
INSERT INTO mkn_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ais raja tanya bilang, “Bosong pung karjá apa?” Ju dong manyao sang raja bilang, “Botong ni gambala, sama ke botong pung nene-moyang. ");
INSERT INTO mkn_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Sakarang ni, di tana Kanaꞌan ada musim karíng yang hebat sakali sampe sonde ada makanan deng rumput lai. Andia ko botong datang di ini negrí ko tenga tahan. Botong ju ada bawa botong pung binatang dong. Naa, sakarang botong minta isin sang papa raja, ko botong tenga di daꞌera Gosen, ko piara botong pung binatang dong di situ.” ");
INSERT INTO mkn_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ais ju raja kasi tau dia pung mau sang Yusuf bilang, “Sakarang lu pung papa deng kaka-adi dong su ada di sini. ");
INSERT INTO mkn_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Jadi dong bole bekin ini negrí sama ke dong pung negrí sandiri. Yang beta tau, daꞌera Gosen tu, daꞌera yang paling bae di ini negrí. Jadi lebe bae dong tenga di situ sa. Deng kalo dari dong ada yang tau urus binatang deng bae, biar ko dong ju urus beta pung di situ.” ");
INSERT INTO mkn_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ais ju Yusuf kasi kanál dia pung papa sang raja. Ju Yakob sambayang minta ko Tuhan Allah kasi berkat sang itu raja. ");
INSERT INTO mkn_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ju raja tanya sang Yakob bilang, “Bapa su umur barapa?” ");
INSERT INTO mkn_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob manyao bilang, “Beta su idop saratus tiga pulu taon, ma beta sonde tatáp di satu tampa. Beta pung nene-moyang dong ju bagitu. Kalo banding deng dong, na, beta pung umur memang lebe pende, ma ponu deng sangsara.” ");
INSERT INTO mkn_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ais Yakob minta parmisi sang raja. Ma dia balóm jalan, dia minta Tuhan kasi berkat lai sang raja. ");
INSERT INTO mkn_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ais Yusuf iko raja pung omong, tarús dia tunju tampa kasi sang dong di daꞌera Gosen. Itu tampa talalu bagus. (Nanti dong kasi nama itu tampa ‘Rameses’.) Ais ju Yusuf pung papa deng dia pung kaka-adi dong tenga tarús di situ. ");
INSERT INTO mkn_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ais Yusuf ju sadia makanan ko kasi dia pung papa, dia pung kaka-adi dong, deng dong pung bini-ana dong samua, dari yang paling bésar sampe yang paling kici. ");
INSERT INTO mkn_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Itu waktu, musim lapar talalu hebat, sampe di mana-mana su sonde ada makanan lai. Dari Masir sampe Kanaꞌan orang dong samua su soák. Dong sonde bisa bekin apa-apa lai, tagal dong su lapar mau mati. ");
INSERT INTO mkn_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ais orang datang dari samua tampa di Masir deng samua tampa di Kanaꞌan, ko béli makanan di Yusuf. Ju dia kumpul itu doi samua, ko pi simpan di raja pung ruma. ");
INSERT INTO mkn_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Itu waktu, orang Masir deng orang Kanaꞌan dong pung doi su abis. Andia ko dong sonde bisa béli makanan lai. Ais ju dong datang mangada sang Yusuf, ko minta bilang, “Bapa wakil, é! Kasi botong makan dolo, ko botong jang mati lapar. Te botong pung doi su abis na.” ");
INSERT INTO mkn_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ais Yusuf manyao bilang, “Kalo memang bosong pung doi sonde ada lai, na, bekin bagini: kasi sa bosong pung binatang, ko beta tukar deng makanan.” ");
INSERT INTO mkn_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ais ju dong kasi dong pung binatang sang Yusuf, ko tukar deng makanan. Andia dong pung kuda, dong pung domba, dong pung kambing, dong pung sapi deng dong pung keledai, tagal itu taon Yusuf su janji bagitu. ");
INSERT INTO mkn_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Bale taon, dong datang lai di Yusuf bilang, “Papa wakil, é! Botong omong jujur sa. Botong pung doi deng botong pung binatang, papa su tukar ame samua. Sakarang sonde ada apa-apa lai. Tenga botong pung diri deng botong pung tana sa. ");
INSERT INTO mkn_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Jang kasi biar botong mati. Kalo botong mati, na, sapa yang urus itu tana dong? Lebe bae, papa wakil ame botong jadi papa pung budak. Deng papa ju ame botong pung tana, ko jadi papa pung. Tarús papa kasi bibit ko botong tanam kasi papa. Ais botong pung cape, deng botong pung tana tu, papa ganti deng makanan sa. Asal botong jang mati!” ");
INSERT INTO mkn_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tagal musim lapar tamba hebat, andia ko samua orang Masir jual buang dong pung tana. Ju Yusuf béli ame samua tana di Masir ko jadi raja pung pusaka. ");
INSERT INTO mkn_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Deng bagitu, andia samua rakyat Masir jadi raja pung budak. ");
INSERT INTO mkn_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ma Yusuf sonde béli kapala agama dong pung tana, tagal raja kasi sang dong makanan tarús. Andia ko dong sonde parlú jual dong pung tana. ");
INSERT INTO mkn_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Itu waktu, ju Yusuf omong deng rakyat dong bilang, “Naa! Sakarang bosong su jadi raja pung budak. Bosong pung tana samua, ju beta su béli kasi raja. Jadi bosong ame ini bibit dong, ko pi tanam di itu tana dong suda. ");
INSERT INTO mkn_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ais nanti waktu koru, na, bosong bagi lima. Satu bagian bawa kasi raja. Sisa ampa bagian, bosong pake bekin bibit, deng saparu bosong makan deng bosong pung kelu dong.” ");
INSERT INTO mkn_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ais ju dong manyao bilang, “Pak su kasi salamat sang botong, tagal itu botong minta tarima kasi. Botong mau jadi tuan raja pung budak sa.” ");
INSERT INTO mkn_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ais Yusuf bekin itu atoran jadi adat di negrí Masir. Andia dari samua padi yang rakyat dong su koru, dong bagi lima. Satu bagian dong kasi sang raja. Ampa bagian dong pake sandiri. Cuma kapala agama dong pung tana, raja sonde béli. Itu adat, dong masi pake tarús. ");
INSERT INTO mkn_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Mulai itu waktu, ju orang Israꞌel dong tenga tarús di Masir di daꞌera Gosen. Dong jadi orang kaya, deng dong pung turunan ju tamba banya. ");
INSERT INTO mkn_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Di Masir Yakob masi idop lai tuju blas taon, sampe dia pung umur samua jadi saratus ampa pulu tuju taon. ");
INSERT INTO mkn_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ais waktu dia pung hari mati su deka-deka, ju dia pange sang Yusuf ko kasi tau bilang, “Ana Usu, é! Beta rasa-rasa sonde lama lai, te Tuhan Allah su pange pulang sang beta. Jadi beta minta, kalo lu sayang sang beta, lu sumpa ko lu jang kubur beta di tana Masir. ");
INSERT INTO mkn_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Lu musti bawa pulang beta pung mayat, pi kotong pung nene-moyang dong pung tampa kubur, ko kubur beta di situ. Itu papa pung mau.” Ju Yusuf manyao bilang, “Bae, papa! Kalo papa su mau bagitu, na, beta iko sa.” ");
INSERT INTO mkn_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Tarús Yakob omong bilang, “Naa, kalo bagitu, sakarang lu angka sumpa dolo, ko bilang lu iko papa pung mau.” Ais ju Yusuf sumpa iko Yakob pung omong. Tarús Yakob tikam lutut di atas koi, ko sambayang minta tarima kasi sang Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sonde lama lai, ju orang datang kasi tau sang Yusuf bilang dia pung papa su saki barát. Jadi dia bawa ame dia pung ana dua, andia Manase deng Efraim, ko pi lia sang dong pung baꞌi Yakob. ");
INSERT INTO mkn_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Waktu Yakob dengar Yusuf dong su datang, ju dia paksa diri ko dudu di koi. ");
INSERT INTO mkn_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ju dia kasi tau sang Yusuf bilang, “Ana Usu, é! Tempo hari Tuhan Allah yang Paling Kuasa su kasi tunju diri sang beta di kampong Lus di tana Kanaꞌan. Di situ, Dia janji sang beta. ");
INSERT INTO mkn_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Dia omong bilang, ‘Nanti Beta kasi lu pung ana-upu tamba banya, ko lu pung turunan jadi bangsa yang bésar. Nanti Beta ju kasi ini negrí pi sang lu pung turunan dong, ko jadi dong pung pusaka sampe kiamat.’ ");
INSERT INTO mkn_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Naa, sakarang lu pung ana Efraim deng Manase pung hak bagini: beta datang di Masir, te dong dua su ada. Biar bagitu, ju sakarang, beta su anggap dong dua ke beta pung ana sandiri, sama ke Ruben deng Simeon. ");
INSERT INTO mkn_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ma nanti kalo lu dapa ana lai, na, itu lu pung ana sa. Beta sonde anggap dong, beta pung ana. Jadi biar nanti dong tarima dong pung pusaka dari dong pung kaka Efraim deng Manase sa. ");
INSERT INTO mkn_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Beta bekin bagitu, ko inga lu pung mama Rahel. Waktu kotong kambali dari Mesopotamia pi Kanaꞌan, lu pung mama mati barana di tenga jalan deka deng kampong Efrata di tana Kanaꞌan. Itu waktu beta pung hati susa mau mati! Ju beta kubur sang dia di pinggir jalan yang mau pi kampong Efrata.” (Itu kampong sakarang, dong kasi nama Betlehem.) ");
INSERT INTO mkn_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakob omong abis, ju dia angka muka, ais dia lia Yusuf pung ana-ana di situ. Ju dia tanya sang Yusuf bilang, “We! Ini sapa pung ana-ana dong ni?” ");
INSERT INTO mkn_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Tarús Yusuf manyao bilang, “Dong ni, ana-ana yang Tuhan Allah kasi sang beta di Masir.” Ais ju Yakob omong bilang, “Kalo bagitu, na, lu bawa dong deka-deka sang beta, ko beta sambayang minta Tuhan Allah kasi berkat sang dong.” ");
INSERT INTO mkn_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakob su tua, deng dia pung mata su kabur. Andia ko dia sonde bisa lia babae lai. Tarús Yusuf bawa dia pung ana dua pi deka-deka sang Yakob, ko dia paló-ciom sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ais ju dia omong deng Yusuf bilang, “Bagini lama beta pikir sa, beta sonde mungkin katumu deng lu lai. Ma sakarang Tuhan Allah su bekin lebe lai, sampe beta ju masi bisa lia lu pung ana dong.” ");
INSERT INTO mkn_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ais ju Yusuf kasi ondor dia pung ana dong dari Yakob, ju dia tikam lutut deng muka sampe di tana, di dia pung papa pung muka. ");
INSERT INTO mkn_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ais ju Yusuf bangun. Tarús dia ame dia pung ana dong ko kasi badiri deka-deka deng dia pung papa. Dia taro ana nomer satu, Manase, di Yakob pung sablá kanan; deng ana nomer dua, Efraim, di Yakob pung sablá kiri. ");
INSERT INTO mkn_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ma waktu Yakob mau taro tangan ko minta berkat kasi sang dong dua, dia kasi pinda dia pung tangan kanan ko taro pi atas adi pung kapala, deng dia taro tangan kiri pi atas kaka pung kapala. ");
INSERT INTO mkn_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Tarús dia sambayang minta Tuhan Allah kasi berkat sang Yusuf bilang, “Lu pung baꞌi Isak pung bapa Abraham, deng lu pung baꞌi Isak sandiri, dong dua iko tarús sang Tuhan Allah pung mau. Tuhan Allah ju su piara sang beta dari muda sampe sakarang. ");
INSERT INTO mkn_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Dia su kasi lolos sang beta dari samua macam calaka. Jadi beta ju minta ko Dia kasi berkat sang ini ana dong deng dong pung turunan. Deng kalo dong sambayang sang Tuhan Allah, dong sonde lupa baꞌi Abraham, baꞌi Isak, deng beta pung nama. Biar ko dong pung turunan batamba banya, ko jadi bangsa yang bésar di ini dunya.” ");
INSERT INTO mkn_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ma waktu Yusuf lia dia pung papa ada taro dia pung tangan kanan di adi Efraim pung kapala, ju dia pegang ame dia pung papa pung tangan, ko kasi pinda di kaka Manase pung kapala. ");
INSERT INTO mkn_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Dia kasi tau dia pung papa bilang, “Papa, é! Jang bekin bagitu. Te dia tu, adi. Dia bukan ana nomer satu. Papa musti taro papa pung tangan kanan di atas kaka pung kapala. Ko itu kaka pung hak na!” ");
INSERT INTO mkn_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ma dia pung papa Yakob sonde mau. Ju dia bilang, “Ana, é! Beta memang tau. Te nanti Manase jadi hebat, deng dia pung turunan tamba banya sampe jadi bangsa yang bésar. Ma dia pung adi Efraim tu, nanti lebe hebat dari dia. Deng dia pung turunan dong, nanti talalu banya sampe dong jadi banya bangsa yang hebat.” ");
INSERT INTO mkn_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ais ju dia kasi tau sang itu ana dua bilang, “Nanti kalo orang Israꞌel minta Tuhan Allah kasi berkat sang orang, dong ju subu bosong dua pung nama. Nanti dong minta bilang, ‘Moga-moga Tuhan Allah kasi berkat sang lu, sama ke Dia kasi berkat sang Efraim deng Manase.’ ” Deng bagitu, Yakob ju subu Efraim pung nama lebe dolo dari dia pung kaka Manase pung nama. ");
INSERT INTO mkn_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ais ju Yakob kasi tau sang Yusuf bilang, “Ana, é! Sonde lama lai, te beta su mati. Ma nanti Tuhan Allah tolong sang bosong, ais Dia bawa bale sang bosong pi di bosong pung nene-moyang dong pung negrí. ");
INSERT INTO mkn_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ma sakarang, beta kasi sang lu lebe dari beta kasi sang lu pung kaka-adi dong. Te beta kasi tamba sang lu gunung di tana Kanaꞌan yang dolu beta ame dari orang Amori, waktu beta baparáng deng dong.” ");
INSERT INTO mkn_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ais itu, Yakob suru pange dia pung ana dong samua. Dong datang abis, ais dia kasi tau bilang, “Ana dong, é! Mari ko bosong bakumpul deka-deka deng beta di sini dolo. Beta mau kasi tau sang bosong, satu-satu pung jalan idop di balakang hari.” ");
INSERT INTO mkn_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ais Yakob mulai kasi tau memang dia pung ana-ana dong bilang, “Bagini! Yakob pung ana dong! Mari bosong badiri kuliling sang beta. Dengar bosong pung papa Israꞌel mau omong. ");
INSERT INTO mkn_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! Lu ni, beta pung ana paling tua! Lu ni, beta pung tongkat, deng beta pung tangan kanan. Orang paling hormat sang lu. ");
INSERT INTO mkn_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ma lu pung hati gampang tagoyang, sonde tau lu pung mau yang mana, sama ke arus laut yang takuju pi sini-pi sana. Takuju sa, lu su pi tidor deng beta pung bini Bilha, ko bekin kamomos lu pung papa pung koi. Andia ko lu pung pangkat kaka jato memang! ");
INSERT INTO mkn_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon deng Lewi! Bosong dua satu merek! Bosong dua talalu gampang maen angka kalewang, ko bekin orang dong sangsara. ");
INSERT INTO mkn_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Bosong pung sanáng, andia potong bekin putus sapi pung urat kaki, sampe dong taputar satenga mati di tampa sa. Deng bosong pung jahat lai, andia bosong makan gigi, baru bosong bunu orang. Andia ko beta sonde mau toe bosong pung omong. Beta ju sonde mau iko campor deng bosong pung parkara. ");
INSERT INTO mkn_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Jadi sakarang beta kutuk bosong pung asaráng tu, ko su talalu na! Deng bosong pung mara yang sonde ada pung rasa kasian sadiki ju. Nanti bosong musti tanggong sandiri bosong pung jahat. Nanti Tuhan kasi talempar kiri-kanan bosong pung turunan dong. Ais dong tenga tasiram di mana-mana di tana Israꞌel. ");
INSERT INTO mkn_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda! Lu pung nama pung arti bilang ‘puji’. Lu pung kaka-adi dong nanti puji sang lu, deng tondo kasi hormat sang lu. Lu ju tendes ame lu pung musu dong, sampe dong sonde bisa angka kapala. ");
INSERT INTO mkn_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Lu ni ke singa muda yang hebat, ko bisa cari makan sandiri. Lu ju sama ke singa laki yang hela badan ko mau pi tidor; sonde ada yang barani pi korek sang lu. Lu ju sama ke singa mai yang ada jaga dia pung ana; sonde ada orang yang barani pi ganggu. Bagitu ju deng lu, te orang eleng sang lu, deng sonde barani bekin macam-macam. ");
INSERT INTO mkn_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nanti lu yang pegang parenta. Lu pung turunan dong ju pegang parenta baꞌiko-baꞌiko sampe nanti ada satu yang ada pung hak lebe dari samua, yang dudu pegang itu parenta. Ais bangsa-bangsa dong samua soya deng dengar sang Dia. ");
INSERT INTO mkn_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Nanti lu idop sanáng-sanáng. Lu mau apa sa, ada! Lu mau bekin apa sa, jadi! Ais lu pung binatang deng kabón pung hasil dong, tamba banya sampe tabuang-tabuang. ");
INSERT INTO mkn_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Lu pung makan-minum dong ena-ena, sampe sonde tau abis-abis. ");
INSERT INTO mkn_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon! Lu pung tana pusaka paling luas, deng deka laut, sampe babatas deng kota Sidon. Kapal-kapal dong datang dari mana-mana ko buang jangkar deng aman di lu pung pante. ");
INSERT INTO mkn_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isaskar! Lu ni, sama ke keledai kuat, ma lu pung kapala batu sonde bisa-bisa pung. Kalo lu su tidor di tenga jalan, na, sapa yang masi bisa paksa kasi bangun sang lu, ko jalan tarús. Ma kalo lu su dapa lia kampong bagus di sablá sana, sonde suru ju, lu su pikol lu pung muatan ko jalan pi. Andia lu tu, bagitu suda! ");
INSERT INTO mkn_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan! Lu pung nama pung arti bilang ‘hakim’. Ais lu ni, deng lu pung turunan yang nanti putus lu pung suku pung parkara dong deng sonde barát sablá. Te lu pung suku tu, satu dari bangsa Israꞌel dong. ");
INSERT INTO mkn_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Lu ni ju lihai sama ke ular baracon yang ada tidor jaga di pinggir jalan. Kalo orang nae kuda lewat di situ, takuju sa, lu su gigi kuda pung balakang kaki, sampe dia pung orang jato talempar. ");
INSERT INTO mkn_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ee, TUHAN, é! Beta doꞌa-doꞌa ko Lu kasi salamat sang botong samua. ");
INSERT INTO mkn_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! Lu pung nama pung bunyi amper sama ke ‘saráng’. Nanti gerombolan parampok dong saráng sang lu, ma lu bale saráng kasi kala sang dong. ");
INSERT INTO mkn_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser! Nanti lu pung kabón pung hasil paling bae, sampe lu bisa bekin kue mewa-mewa yang enak, ko raja-raja dong datang béli di lu. ");
INSERT INTO mkn_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali! Lu ni, sama ke rusa mai yang liar, ais sonde ada orang bisa ator sang lu. Lu ju barana ame ana-ana yang manis-manis. ");
INSERT INTO mkn_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf! Lu sama ke pohon malata yang idop deka mata aer. Lu pung cabang dong malata nae pi tembok tinggi-tinggi. ");
INSERT INTO mkn_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ada ju orang yang lempar dong pung saki hati sang lu, sama ke musu yang pana sang lu. ");
INSERT INTO mkn_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ma Tuhan Allah yang beta sémba tu, tolong sang lu. Andia ko Dia bekin kuat lu pung tangan, sampe lu bisa pana balas sang dong, biar dari jao-jao. Lu bisa manáng sang dong, tagal Tuhan yang tolong sang lu, memang Dia pung kuasa hebat batúl! Andia ko beta basandar di Dia. Te Dia yang jaga sang beta. ");
INSERT INTO mkn_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Dia ju nanti jaga sang lu. Deng Dia kasi berkat sang lu, berkat dari langit, berkat dari bumi, deng berkat barana ana bam-banya yang sehat-sehat. ");
INSERT INTO mkn_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Gunung dong sonde ilang buang. Deng beta pung berkat kasi sang lu ni, lebe banya dari gunung dong samua! Biar berkat samua ni, tapoꞌa pi sang lu, tagal lu yang paling lebe dari lu pung kaka-adi dong samua. ");
INSERT INTO mkn_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin! Lu pung barani sama ke anjing utan lapar. Kalo papagi, dia su baburu ko tangkap ame dia pung makanan. Kalo malam, dia pi babagi yang sisa dong kasi dia pung ana-ana. Lu pung turunan ju hebat bagitu!” ");
INSERT INTO mkn_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Bagitu suda, Yakob kasi tau memang dia pung ana-ana pung jalan idop di balakang hari, satu-satu deng dia pung turunan. Dong samua tu yang kasi turun dua blas suku Israꞌel. ");
INSERT INTO mkn_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Ais ju Yakob minta dia pung ana dong janji bilang, “Sonde lama lai, te beta su mati. Kalo beta mati, bosong musti pi kubur sang beta di baꞌi Abraham pung kubur. Itu kubur ada di goa, badeka deng kampong Makpela deng Mamre di tana Kanaꞌan. Dolu baꞌi Abraham béli ame itu goa deng dia pung kabón ko bekin dia pung tampa kubur. Dia béli kontan dari orang suku Het, nama Efron. ");
INSERT INTO mkn_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Di situ dong kubur kotong pung baꞌi Abraham deng nene Sara, beta pung papa Isak, deng beta pung mama Ribka. Jadi bosong ju musti kubur sang beta di situ, di beta pung bini Lea pung sablá. ");
INSERT INTO mkn_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Naa, bosong jang lupa kubur sang beta di itu goa yang baꞌi Abraham su béli ame tu.” ");
INSERT INTO mkn_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakob omong abis bagitu, ju dia tidor kambali di atas koi, ju dia mati. ");
INSERT INTO mkn_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ais Yusuf paló ame dia pung papa, ju dia manangis makarereu. Tarús dia ciom dia pung papa ulang-ulang. ");
INSERT INTO mkn_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ais ju Yusuf parenta tukang urus mayat dong, ko taro ramuan, ko bekin awet Yakob pung mayat. ");
INSERT INTO mkn_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ais, itu tukang dong urus itu mayat sampe ampa pulu hari, iko dong pung biasa. Ju orang Masir dong samua iko manangis Yakob pung mati. Dong bekin bagitu sampe tuju pulu hari, sama ke dong pung orang bésar yang mati. ");
INSERT INTO mkn_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Abis dia pung tuju pulu hari, ju Yusuf kasi tau dia pung pagawe bilang, “Dengar! Beta minta ko bosong bawa beta pung omong ni, pi kasi tau sang raja bilang bagini: ");
INSERT INTO mkn_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Waktu beta pung papa su mau mati, dia ada minta beta janji ko pi kubur dia pung mayat di tana Kanaꞌan. Jadi beta minta raja kasi isin ko beta pi kubur beta pung papa. Ais itu, baru beta bale datang di sini.’ ” ");
INSERT INTO mkn_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Dengar bagitu, ju raja manyao bilang, “Kalo lu su janji lu pung papa bagitu, na, pi ko kubur sang dia di sana suda.” ");
INSERT INTO mkn_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tarús Yusuf pi kubur dia pung papa. Orang banya ju iko pi deng dia. Andia raja pung pagawe dong samua, deng orang bésar samua dari Masir. ");
INSERT INTO mkn_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusuf pung kaka-adi, deng dong pung orang karjá samua ju iko pi kubur sang Yakob. Yang tenga di Gosen, cuma dong pung bini deng ana kici dong, deng dong pung binatang. ");
INSERT INTO mkn_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tantara banya yang iko ju. Ada yang pake kareta, deng ada yang nae kuda. Tagal yang iko tu, banya sakali, andia ko rombongan yang iko bajalan antar mayat jadi talalu panjang. ");
INSERT INTO mkn_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ais dong samua bajalan sampe langgar kali Yarden di satu tampa nama Atad. Orang biasa datang ko puku padi di situ. Ais di itu tampa, Yusuf dong manangis makarereu dia pung papa pung mati. Ju dong mete-mete lai tuju malam. ");
INSERT INTO mkn_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Waktu orang Kanaꞌan di situ lia dong susa bagitu, ju dong omong bilang, “We! Bosong lia dolo. Orang Masir dong pung cara mete pung sedí ame lai! Dong manangis sampe bagitu macam tu.” Andia ko dong kasi nama itu tampa Abel-Misraim. Dia pung arti ‘orang Masir pung duka’. ");
INSERT INTO mkn_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ais Yakob pung ana dong bekin iko sama ke dong pung janji. ");
INSERT INTO mkn_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ju dong angka bawa Yakob pung mayat, ko pi kubur di goa deka kampong Makpela deng Mamre. Abraham su béli itu tampa dari orang suku Het, nama Efron, ko dia bekin jadi dong pung tampa kubur. ");
INSERT INTO mkn_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusuf kubur abis dia pung papa, ju dia deng dia pung kaka-adi dong bale pi Masir. Bagitu ju deng samua orang laen yang iko pi kubur deng dong. ");
INSERT INTO mkn_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Waktu dong sampe di Masir, Yusuf pung kaka dong mulai taku. Tagal dong pung papa su sonde ada lai, ju dong baꞌomong bilang, “We! Bosong pikir dolo! Andekata Yusuf masi simpan hati sang kotong, ko dia balas kotong pung bekin jahat sang dia, na, karmana?” ");
INSERT INTO mkn_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ais dong baꞌakór ko dong kirim kabar kasi Yusuf bilang bagini: “Pak wakil. Botong masi inga waktu kotong pung papa masi idop, dia ada suru sang botong ");
INSERT INTO mkn_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ko kasi tau sang pak bilang, ‘Usu musti lupa buang dia pung kaka dong pung sala. Tagal dolu dong su bekin jahat sang dia.’ Botong ju inga kotong pung papa ada sémba sang Tuhan Allah dari dolu. Botong ju jadi itu Tuhan pung hamba-hamba. Andia sakarang botong datang minta ampon, tagal botong samua su bekin sala sang pak.” Dengar bagitu, ju Yusuf manangis. ");
INSERT INTO mkn_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ais ju dia pung kaka dong datang sandiri ko dong tikam lutut di dia pung muka, deng dong omong bilang, “Biar pak bekin sang kotong jadi pak pung budak sa.” ");
INSERT INTO mkn_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ma Yusuf kasi tau sang dong bilang, “Kaka dong, é! Bosong sonde usa taku lai! Cuma Tuhan Allah sa yang ada pung hak ko kasi hukum orang. Ma beta ni, sonde. ");
INSERT INTO mkn_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Dolu tu, bosong memang su basakongkol ko mau bekin jahat sang beta. Ma Tuhan Allah su roba bosong pung maksud jahat, ko Dia bekin jadi bae. Andia ko Dia angka beta jadi orang bésar, ko orang banya bisa dapa salamat. ");
INSERT INTO mkn_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Jadi sakarang beta kasi tau sang bosong ko jang taku lai. Te beta janji nanti beta lia bosong deng bosong pung ana-ana samua.” Deng omong babae bagitu, ju Yusuf bekin tanáng dia pung kaka dong pung hati. ");
INSERT INTO mkn_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ais itu, ju Yusuf tenga tarús di Masir deng dia pung kaka-adi dong samua. Dia idop sampe saratus sapulu taon. ");
INSERT INTO mkn_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Dia masi dapa lia Efraim pung ana-upu dong. Deng dia sandiri ju ada piara Manase pung cucu, andia Makir pung ana-ana. ");
INSERT INTO mkn_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusuf kasi tau dia pung kaka dong bilang, “Kaka dong, é! Beta rasa-rasa, beta pung hari mati su deka-deka. Ma beta parcaya, Tuhan Allah pasti piara bosong. Dia yang nanti antar bosong kaluar dari ini negrí. Dia ju pimpin bosong bale pi negrí yang Dia su sumpa ko mau kasi sang baꞌi Abraham, baꞌi Isak deng papa Yakob.” ");
INSERT INTO mkn_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Tarús Yusuf minta dia pung sodara dong angka sumpa bilang, “Bosong musti janji sang beta. Kalo sampe waktu Tuhan Allah bawa bale sang bosong pi itu negrí, na, bosong ju musti bawa beta pung mayat.” ");
INSERT INTO mkn_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ais ju Yusuf mati di Masir, waktu dia pung umur saratus sapulu taon. Tarús dong taro ramuan di dia pung mayat. Ju dong kasi maso pi dalam dia pung peti. ");
INSERT INTO mkn_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Dolu-dolu, waktu balóm ada raja di tana Israꞌel, tukang putus parkara yang masi ator sang orang Israꞌel dong. Itu waktu, ada satu orang nama Elimelek. Dia tu, dari fam Efrata, dari kampong Betlehem di daꞌera Yahuda. Dia pung bini, nama Naꞌomi. Dong pung ana laki-laki dua orang, nama Mahlon deng Kilyon. Itu waktu, ada musim lapar yang hebat di daꞌera Yahuda. Andia ko Elimelek dong jalan kasi tenga dong pung kampong sandiri, ko pi tenga manumpang di tana Moab, di kali Yarden pung sablá matahari nae. ");
INSERT INTO mkn_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ma di sana, Elimelek mati, kasi tenga dia pung bini-ana dong sandiri. ");
INSERT INTO mkn_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Waktu ana dong su bésar datang, dong kawin ame bini dari orang Moab dong. Mahlon kawin ame satu parampuan, nama Rut. Kilyon kawin ame satu parampuan, nama Orpa. Ma waktu dong su tenga manumpang di situ kira-kira sapulu taon, ");
INSERT INTO mkn_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Naꞌomi pung ana laki-laki dua orang, andia Mahlon deng Kilyon, mati ju. Dong mati kasi tenga dong pung mama sandiri - sonde ada pung laki, sonde ada pung ana, deng sonde ada pung cucu. ");
INSERT INTO mkn_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Waktu Naꞌomi masi tenga di tana Moab, dia dapa dengar bilang, TUHAN ada inga Dia pung orang di daꞌera Yahuda, ais su ada makanan di sana lai. Andia ko Naꞌomi deng dia pung ana mantu dua orang manyimpan ko mau kasi tenga tana Moab ko kambali pi dia pung daꞌera sandiri. ");
INSERT INTO mkn_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ais dong tiga jalan kasi tenga mamatua pung ruma di tana Moab, iko jalan yang pulang pi daꞌera Yahuda. ");
INSERT INTO mkn_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ma waktu dong ada jalan, Naꞌomi kasi tau dia pung ana mantu dua orang tu bilang, “Bagini! Lebe bae bosong dua pulang pi bosong pung mama dong sa. Te bosong su kasi tunju hati bae sang beta pung ana yang su mati dong, deng beta ju. Andia ko beta minta ko TUHAN Allah ju kasi tunju Dia pung hati bae sang bosong dua. ");
INSERT INTO mkn_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Biar ko Dia ju kasi bosong dua, laki baru yang pung hati bae, ko bosong bisa idop aman sa.” Ais mamatua paló-ciom dong dua, ju dong manangis kuat-kuat. ");
INSERT INTO mkn_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Ma dong dua bilang, “Sonde, mama! Botong mau iko deng mama, ko idop sama-sama di mama pung orang dong sa.” ");
INSERT INTO mkn_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ma Naꞌomi manyao bilang, “Ana sayang dong, é! Pulang su! Dia pung guna apa, kalo bosong iko sang beta? Te beta ni su tua, deng sonde bisa barana ame ana laki-laki lai yang bisa jadi bosong pung laki kalo dong su bésar datang. Sonde mungkin, to? ");
INSERT INTO mkn_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Biar bosong dua ni sama ke beta pung ana sandiri, ma lebe bae bosong pulang sa. Te beta su tua ni, jadi bosong jang kira beta bisa kawin ulang lai. Beta sandiri sonde harap bagitu. Andekata ini malam ju, beta jadi kawin, tarús dapa ana laki-laki lai, na, bosong pung pikir karmana? ");
INSERT INTO mkn_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Bosong kira bosong mau tunggu itu ana dong bésar datang, ais kawin ame sang dong? Jang sampe bosong sonde tahan, ais kawin dolu deng orang laen. Susa, to? Ma beta pung susa lebe pait dari bosong pung susa, te beta rasa ke TUHAN Allah sandiri yang maen tampeleng sang beta. Jadi lebe bae bosong jang iko sang beta lai.” ");
INSERT INTO mkn_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Tarús dong tiga manangis makarareu ulang lai. Ais Orpa ciom ame dia pung mama mantu, ju pamit sang dia, ais pulang kambali. Ma Rut paló kuat-kuat sang dia pung mama mantu. ");
INSERT INTO mkn_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naꞌomi kasi tau sang dia bilang, “Lia sa! Orpa su pulang pi dia pung orang deng dia pung barang songgo-songgo dong. Akurang ko lu sonde pulang pi sama-sama deng dia?” ");
INSERT INTO mkn_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ma Rut manyao bilang, “Jang mara, ma mama jang suru beta pulang. Deng mama jang paksa ko beta jalan kasi tenga mama sandiri. Te beta mau makaditi tarús deng mama. Mama pi mana, na, beta pi sana ju. Mama tenga di mana, na, beta tenga di situ ju. Mama pung orang dong nanti jadi beta pung orang ju. Deng mama pung Tuhan Allah nanti jadi beta pung Tuhan Allah ju. ");
INSERT INTO mkn_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Nanti mama mati di mana, na, beta mati di situ ju. Dong kubur mama di mana, na, dong kubur sang beta di mama pung rebis ju. Biar ko TUHAN hukum sang beta, kalo beta tapisa dari mama. Te mati ju sonde bisa kasi pisa kotong dua na!” ");
INSERT INTO mkn_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Jadi waktu Naꞌomi lia kalo Rut su tanam kaki ko mau iko sang dia, dia sonde omong banya lai. ");
INSERT INTO mkn_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ais dong dua jalan tarús, sampe di kampong Betlehem. Waktu itu dua parampuan su sampe di sana, samua orang taheran-heran tagal dong. Parampuan dari itu kampong dong batanya bilang, “Batúl, ko? Ini mama Omi, ko?” ");
INSERT INTO mkn_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ma Naꞌomi kasi tau sang dong bilang, “Bagini! Bosong jang pange beta Naꞌomi lai, te itu dia pung arti bilang, ‘yang hati manis’. Lebe bae bosong pange beta Mara, te itu dia pung arti bilang, ‘yang hati pait’. Te Tuhan yang Paling Kuasa su bekin beta pung idop jadi talalu pait. ");
INSERT INTO mkn_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Dolu, waktu beta kaluar dari sini, beta langkáp, te beta ada pung laki deng beta ada pung ana dua. Ma sakarang Tuhan bawa pulang sang beta, kosong-kosong sa. Jadi, akurang ko bosong pange sang beta ‘Naꞌomi’, kalo TUHAN ada maen tampeleng sang beta? Te Dia yang Paling Kuasa. Deng Dia yang bekin susa sang beta na!” ");
INSERT INTO mkn_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Itu dia pung carita waktu Naꞌomi pulang dari tana Moab deng dia pung ana mantu Rut, yang orang Moab tu. Dong dua sampe di Betlehem, pas deng musim koru jagong rote. ");
INSERT INTO mkn_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Di Betlehem ada satu orang kaya, nama Boꞌas. Dia bakelu deng Elimelek, andia Naꞌomi pung laki yang su mati. Jadi kasi orang di situ dong, Boꞌas tu, sama ke Naꞌomi pung ipar satu. ");
INSERT INTO mkn_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Satu kali, itu parampuan asing orang Moab, andia Rut, pi dia pung mama mantu ko minta bilang, “Mama, é! Bisa ko, beta pi kabón dong ko pili ame jagong rote sisa yang jato di balakang orang karjá dong? Te Tuhan pung Atoran ada tulis bilang kasi tenga orang miskin bekin bagitu. Jang sampe ada orang yang mau kasi tunju dia pung hati bae sang beta bagitu. Bisa, ko?” Mamatua manyao bilang, “Bae ju. Pi su.” ");
INSERT INTO mkn_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ais Rut pi satu kabón ko pili ame jagong rote yang orang karjá dong sonde ame waktu dong ada koru. Tau-tau te itu kabón tu, andia Boꞌas pung tana milik. Dia yang bakelu deng Elimelek, andia Rut pung bapa mantu yang su mati. ");
INSERT INTO mkn_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Naa. Waktu Rut ada pili ame jagong rote tu, takuju sa, tuan kabón, andia Boꞌas, muncul datang dari kampong ko lia dia pung orang karjá dong. Dia togor sang dong bilang, “Saloom! Biar ko TUHAN Allah jaga bae-bae sang bosong!” Dong manyao bilang, “Saloom, bapa! Biar ko TUHAN Allah kasi tunju Dia pung hati bae sang bapa ju!” ");
INSERT INTO mkn_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Lia satu parampuan ada pili ame jagong rote, ju Boꞌas tanya sang dia pung mandor bilang, “Awii! Itu parampuan muda di situ tu, sapa pung kelu?” ");
INSERT INTO mkn_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Itu mandor kasi tau bilang, “Dia tu, orang Moab yang baru pulang sama-sama deng mama Omi dari sana. ");
INSERT INTO mkn_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Tadi pagi dia datang sang beta ko minta bilang, ‘Bos, é! Biar ko beta pili ame jagong rote sisa yang orang karjá dong sonde ika di situ.’ Ju beta manyao bilang, ‘Neu!’ Jadi dia su karjá karás dari tadi pagi sampe sakarang ni. Dia cuma barenti karjá sadiki sa di itu ruma kabón.” ");
INSERT INTO mkn_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ais Boꞌas pi baꞌomong deng Rut bilang, “Susi! Lu ni, orang baru, jadi dengar bae-bae sang beta dolo. Biar ko lu pili ame jagong rote sisa di sini sa. Sonde usa pinda pi orang laen pung kabón. Ma lebe bae, jang jao-jao dari itu nona dong yang ada karjá kasi sang beta di sini. ");
INSERT INTO mkn_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Lia bae-bae kalo dong ada koru di mana, ais dong su lewat itu tampa, na, susi pili ame jagong rote sisa di dong pung balakang. Beta su kasi tau sang itu laki-laki dong ko jang ganggu sang lu. Ais kalo aus, na, pi minum aer di itu kumbang yang dong su isi dari parigi. ");
INSERT INTO mkn_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Dengar bagitu ju, Rut tondo sampe di tana. Ais dia bilang, “Beta minta tarima kasi, bapa! Ma beta mau tanya bagini. Bapa pasti su tau, beta ni, bukan orang sini. Jadi, akurang ko bapa taro mata sang beta, deng kasi tunju hati bae sang beta?” ");
INSERT INTO mkn_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Ju Boꞌas manyao bilang, “Batúl. Beta su tau. Ma samua orang di sini ada carita lu pung hati bae kasi lu pung mama mantu waktu lu pung laki su mati. Dong ju carita lu ada jalan kasi tenga lu pung mama-bapa deng lu pung kampong asal, ko datang di orang laen dong pung teng-tenga, biar sonde kanál sang dong. ");
INSERT INTO mkn_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Jadi beta minta ko TUHAN, andia botong orang Israꞌel pung Allah, balas lu pung hati bae samua! Beta minta ko Dia kasi berkat bam-banya sang lu, tagal lu pung hati bae sang mama Omi. Biar ko TUHAN yang jaga sang lu di sini, tagal lu cari lindung di Dia, sama ke ayam ana dong cari lindung di bawa ayam mai pung sayap.” ");
INSERT INTO mkn_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ais Rut balas bilang, “Bapa, é! Biar beta bukan bapa pung orang karjá, ma beta mau bekin sanáng bapa pung hati tarús. Te bapa su kasi kuat beta pung hati, ais kasi tunju hati bae sang beta ju.” ");
INSERT INTO mkn_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Waktu dong barenti ko makan, ju Boꞌas kasi tau sang Rut bilang, “Mari sini sa! Makan sama-sama deng botong. Ame ini roti sadiki, ais kalo suka, na, colo pi dalam anggor asam ju.” Ais ju Rut pi dudu deka deng orang karjá dong. Tarús Boꞌas kasi dia jagong bakar ko makan. Rut makan sampe kinyang, deng masi ada sisa ju. ");
INSERT INTO mkn_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Waktu dia kambali di kabón ko pili ame jagong rote sisa yang orang karjá dong sonde ika ame, ju Boꞌas kasi tau dia pung orang karjá dong bilang, “Dengar bae-bae! Jang ganggu sang dia. Kasi biar ko dia pili ame jagong di mana sa. Deka deng itu ikatan dong ju, sonde apa-apa. Beta sonde mara kalo bosong tarek satu-dua puler dari jagong yang bosong su ikat dong, ais kasi tenga ko biar dia pili ame. Jang mara sang dia, deng jang bekin malu sang dia ju.” ");
INSERT INTO mkn_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut karjá di kabón satu hari anteru. Waktu matahari mau tanggalám, ju dia pukul kasi kaluar isi dari tangke dong. Dia pung isi, satu bakul ponu. ");
INSERT INTO mkn_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ais dia bawa pulang itu bakul pi kampong Betlehem, ju kasi tunju dia pung hasil sang dia pung mama mantu. Ais dia ju kasi kaluar makanan sisa dari makan siang tadi, ko kasi dia pung mama mantu. ");
INSERT INTO mkn_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ais Naꞌomi tanya sang Rut bilang, “Awii! Tadi lu pili ini jagong dong di mana, é? Lu karjá di sapa pung kabón? Biar ko Tuhan Allah kasi berkat bam-banya sang orang yang taro kira sang lu tadi.” Ju Rut manyao bilang, “Mama! Itu tuan kabón di situ, dia pung nama Boꞌas.” ");
INSERT INTO mkn_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naꞌomi kasi tau dia pung ana mantu bilang, “Biar ko TUHAN Allah kasi berkat bam-banya sang Boꞌas. Te Tuhan sonde lupa kasi tunju Dia pung hati bae sang kotong yang idop, deng kotong pung laki yang su mati dong ju. Beta kasi tau sang lu bagini: Boꞌas tu, kotong pung keluarga dekat. Botong bilang, dia yang ada ‘hak tabús’. Dia pung arti bilang, dia ada pung hak ko kawin ame sang lu, ko kasi turunan sang lu pung laki yang su mati tu.” ");
INSERT INTO mkn_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rut kasi tau bilang, “Mama! Tadi Boꞌas ju kasi tau sang beta bilang, ‘Beso datang di sini lai. Lu bole iko deka deng beta pung orang karjá dong sampe musim koru abis samua.’ ” ");
INSERT INTO mkn_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naꞌomi balas bilang, “Neu sa! Itu tanda bae. Te lu bisa karjá sama-sama deng dia pung parampuan karjá dong sampe musim koru abis. Kalo di orang laen pung kabón bisa sa ada yang ganggu sang lu. Ma di Boꞌas pung kabón dong, lu aman sa!” ");
INSERT INTO mkn_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Jadi siang hari Rut pili jagong rote sisa di Boꞌas pung kabón dong badeka-badeka deng dia pung parampuan karjá dong sampe musim koru jagong rote deng gandum abis. Malam hari, na, dia tenga tarús deng dia pung mama mantu. ");
INSERT INTO mkn_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Satu kali, Naꞌomi kasi tau dia pung ana mantu Rut bilang, “Bagini. Sakarang su dia pung waktu kalo beta cari laki yang bae kasi sang lu, ko biar lu ada pung ruma tangga sandiri, deng bisa idop aman tarús di situ. Ko karmana? ");
INSERT INTO mkn_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Dengar bae-bae. Lu masi inga itu laki-laki, nama Boꞌas, to? Dia yang ator ko biar lu pili jagong rote di balakang dia pung parampuan orang karjá dong. Dia bakelu deng kotong dari beta pung laki yang su mati. Ini malam ju banya orang rame-rame mau bakumpul di tampa inja padi. Nanti Boꞌas ada di situ ju. ");
INSERT INTO mkn_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Jadi beta pung mau, bagini: lu pi mandi dolo. Ais taro minya wangi sadiki, deng pake pakean yang alus ju. Ais itu, lu turun pi itu tampa inja padi tu. Ma jaga bae-bae. Tunggu ko Boꞌas su makan-minum abis dolo, baru kasi biar ko dia lia lu ada di situ. ");
INSERT INTO mkn_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Makan abis, pasti dia mau tidor. Tagal su galáp, andia ko lu musti lia bae-bae dia pi tidor di mana. Kalo dia su tidor, na, lu iko pi situ ju. Buka salimut yang tutu ame dia pung kaki ko sein sang dia, ais lu ju tidor di situ. Boꞌas tau botong pung adat, jadi nanti dia yang kasi tau lu musti bekin karmana.” ");
INSERT INTO mkn_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ju Rut manyao bilang, “Neu. Nanti beta bekin iko bagitu.” ");
INSERT INTO mkn_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ais dia turun pi tampa inja padi. Ju dia bekin iko dia pung mama mantu pung pasán samua. ");
INSERT INTO mkn_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Waktu Boꞌas makan-minum abis, ju dia rasa kinyang. Ais dia pi tidor di tampa tumpuk padi pung sablá. Tunggu sampe dia su sono, ju Rut pi diam-diam di Boꞌas pung tampa. Ais dia buka salimut yang ada di Boꞌas pung kaki, ju tidor di situ. ");
INSERT INTO mkn_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Kira-kira su tenga malam, ju Boꞌas takuju bangun. Ais dia balik badan, ju dia takuju, te ada satu parampuan yang tidor di dia pung kaki! ");
INSERT INTO mkn_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Ais Boꞌas tanya sang dia bilang, “Ko lu ni, sapa?” Ju Rut manyao bilang, “Beta ni, Rut, yang ke bapa pung parampuan karjá dong. Ma bapa ju yang ‘hak tabús’ sang beta. Dia pung arti bilang, bapa ada pung hak ko kawin ame sang beta, ko kasi turunan sang beta pung laki yang su mati tu. Jadi beta minta ko bapa tutu ame sang beta pake ujung salimut ni, ko jadi tanda bilang, bapa mau kawin ame sang beta.” ");
INSERT INTO mkn_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ais Boꞌas heran, ju omong bilang, “Awii! Beta minta ko TUHAN kasi berkat sang lu! Bisa sa, lu cari laki dari ana muda dong di sini yang kaya, ko sonde. Ma lu sonde bekin bagitu. Lu ni, talalu bae! Te lu kasi tunju sayang deng hormat tarús sang lu pung laki yang su mati pung kelu dong. Lu pung hati bae sakarang ni, lebe hebat dari yang lu su kasi tunju sang mama Omi dolu tu. ");
INSERT INTO mkn_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Jadi jang taku! Te beta mau bekin iko lu pung mau samua. Jang jadi pikiran, te samua orang bésar di ini kota dong su tau bilang, lu ni parampuan yang hati bae deng rajin. ");
INSERT INTO mkn_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ma sakarang masi ada satu hal lai. Sonde sala bilang, beta ni lu pung laki yang su mati pung kelu yang ‘hak tabús’ sang lu. Ma ada satu orang laen yang lebe deka dari beta. Jadi dia yang ada hak putus ko mau kawin ame sang lu. Kalo dia sonde mau, baru beta ada hak. ");
INSERT INTO mkn_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Jadi beta usul bagini: ini malam tenga di sini sa. Beso beta pi baꞌomong deng dia. Kalo dia sadia ko urus deng kawin sang lu, na, biar bagitu sa. Ma kalo sonde, na, beta sumpa pake Tuhan yang Idop pung nama bilang, beta sandiri yang nanti urus deng kawin ame sang lu. Botong pung adat di sini bilang, beta yang mau ‘tabús ame’ sang lu. Naa, tidor di situ sampe siang su.” ");
INSERT INTO mkn_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ais Rut tidor di Boꞌas pung kaki. Ma amper siang, waktu masi talalu galáp ko orang bisa kanál satu deng satu, ju Rut su bangun ko mau jalan. Te Boꞌas su kasi tau memang bilang, “Sonde bae kalo orang dapa tau ada parampuan yang datang malam-malam di ini tampa inja padi. ");
INSERT INTO mkn_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Mari, taro itu kain panas yang lu pake ko biar beta isi deng jagong rote.” Ais dia raꞌu jagong rote anam kali ko isi di Rut pung kain. Tarús dia bantu kasi pikol di Rut. Ais Boꞌas pulang pi kampong ju. ");
INSERT INTO mkn_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Waktu Rut sampe di ruma, ju dia pung mama mantu tanya sang dia bilang, “Karmana tadi malam, ó?” Ju Rut kasi tau samua-samua yang Boꞌas bekin kasi sang dia, ");
INSERT INTO mkn_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","ais tamba bilang, “Dia ju raꞌu kasi beta ini jagong rote. Ju dia bilang, ‘Lu jang pulang pi mama mantu deng tangan kosong sa.’ ” ");
INSERT INTO mkn_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Ju Naꞌomi manyao bilang, “Neu sa! Sakarang lu musti sabar sa, ko tunggu kabar. Te su jalás bilang, Boꞌas mau urus ini parkara deng sonde mau tunggu-tunggu lai. Pasti dia mau urus ini hari ju.” ");
INSERT INTO mkn_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ais ju Boꞌas pi di pintu maso kota ko mau dudu di situ. Di itu tampa, itu kota pung tua-tua biasa bakumpul ko barunding. Sampe deng sampe ju, dia pung kelu yang satu lai yang ada pung ‘hak tabús’ ko bisa kawin ame sang Rut ju jalan lewat di situ. Ais Boꞌas pange ame sang dia bilang, “We, bu! Mari dudu sini dolo! Te beta ada parlú.” Ju itu orang datang dudu di situ. ");
INSERT INTO mkn_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Tarús Boꞌas pange ame sapulu tua-tua ko dudu jadi saksi bilang, “Mari, bapa-bapa dong dudu sini ko dengar ini parkara.” Ju dong dudu. ");
INSERT INTO mkn_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Tarús Boꞌas carita kasi dia pung kelu yang ada pung ‘hak tabús’ di Rut bilang, “Bagini. Bu masi inga itu tana sapotong yang jadi kotong pung kelu Elimelek pung tana milik, ko? Dolu, waktu musim lapar, dia pi tana Moab, ais mati di sana. Sakarang dia pung janda, mama Naꞌomi, su pulang dari sana, ju mau jual itu tana. ");
INSERT INTO mkn_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Dengar bagitu, ju beta pikir bagini: biar beta kasi tau bu dolo, tagal bu yang ada pung hak ko ‘tabús ame’ itu tana. Te bu deng Elimelek satu turunan, na! Jadi, kalo bu mau béli ame itu tana, na, kasi tau memang, ko biar ini tua-tua dong jadi saksi. Ma kalo sonde, na, kasi tau di ini saksi dong pung muka ju, te beta mau béli. Yang batúl, bu yang ada pung hak lebe dolo. Ma kalo sonde mau, na, itu hak jato di beta.” Ju itu orang manyao bilang, “Neu. Beta béli.” ");
INSERT INTO mkn_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Tarús Boꞌas kasi tau tamba bilang, “Jang mara, ma bu musti inga, te kalo bu béli ame itu tana sapotong dari mama Omi, na, bu ju musti ame itu parampuan orang Moab, nama Rut. Te dia yang su kawin deng Elimelek pung ana yang su mati. Jadi bu musti kawin ame sang dia, ko kasi turunan sang dia pung laki yang su mati tu. Deng bagitu, dia pung tana pusaka sonde kaluar dari kotong pung kelu.” ");
INSERT INTO mkn_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Itu orang manyao bilang, “Kalo bagitu, na, jang mara, ma beta sonde jadi béli. Te kalo beta béli, na, itu sama ke beta pung pusaka sandiri ilang buang. Beta pung pusaka deng beta pung ana akan jadi bu Elimelek pung turunan pung milik. Jadi, biar beta sonde usa béli. Biar adi Boꞌas sa yang tabús ame itu tana deng kawin ame sang itu parampuan.” ");
INSERT INTO mkn_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Naa, dolu-dolu, waktu orang Israꞌel mau sarakan dong pung hak ko tabús ame satu barang pi orang laen, dong buka dong pung sandal ko kasi itu orang. Itu jadi tanda sah di orang pung muka bilang, dong su sarakan itu hak.) ");
INSERT INTO mkn_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Jadi waktu itu orang su sarakan dia pung hak tabús pi Boꞌas bilang, “Biar lu sa yang béli,” ju dia buka dia pung sandal ko kasi pi Boꞌas di tua-tua dong pung muka. ");
INSERT INTO mkn_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ais Boꞌas kasi tau tua-tua dong deng samua orang yang ada di situ bilang, “Bapa dong samua su jadi saksi ini hari. Itu hak su jato di beta. Beta kasi tau memang bilang, beta mau tabús ame dari mama Naꞌomi samua-samua yang dolu jadi milik dari bu Elimelek deng dia pung ana laki-laki, andia Kilyon deng Mahlon yang su mati dong. ");
INSERT INTO mkn_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Beta pung maksud bukan itu tana sandiri sa, te beta ju ame itu parampuan orang Moab, nama Rut, yang jadi Mahlon pung janda. Beta mau kawin ame sang dia, te beta su tabús itu hak. Deng bagitu, botong dua pung ana bisa jadi Mahlon pung turunan. Ju dia pung kelu deng dia pung orang kampong sonde akan lupa dia pung nama. Bosong ni yang jadi saksi ini hari.” ");
INSERT INTO mkn_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Ais ju tua-tua di itu kota deng samua orang yang ada bakumpul di situ manyao bilang, “Batúl, ó! Botong yang lia deng mata kapala sandiri. Botong ni yang jadi saksi. Itu parampuan yang maso dalam lu pung ruma, biar ko TUHAN bekin dia jadi ke Rahel deng Lea. Te samua orang Israꞌel turun dari dong dua. Biar ko Tuhan bekin lu jadi orang bésar di fam Efrata, deng jadi orang yang pung nama bae di kota Betlehem. ");
INSERT INTO mkn_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Biar ko Tuhan kasi ana sang lu deng itu parampuan muda, ko biar bosong dua pung turunan jadi hebat, sama ke lu pung moyang Peres pung turunan, yang jadi Tamar deng Yahuda pung ana.” ");
INSERT INTO mkn_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ais ju Boꞌas kawin ame sang Rut. Waktu dong dua tidor bakumpul, TUHAN buka Rut pung tampa ana, ko biar dia bisa dudu parú. Ju dia barana ame satu ana laki-laki. ");
INSERT INTO mkn_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Barana ame abis, ju parampuan di Betlehem dong kasi tau sang Naꞌomi bilang, “Puji TUHAN! Te Dia yang su kasi turunan sang lu, ko biar lu pung kelu pung nama jang ilang buang. Biar ko itu ana nanti jadi orang bésar di Israꞌel. ");
INSERT INTO mkn_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Biar ko ini ana bekin lu rasa ke su jadi muda kambali! Biar ko ini ana nanti jaga sang lu waktu su tua! Te lu pung ana mantu yang barana ame sang ini ana cucu ni, su kasi tunju dia pung sayang sang lu. Ini ana mantu yang satu ni, lebe bae kasi sang lu dari tuju ana laki-laki!” ");
INSERT INTO mkn_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naꞌomi paló ame sang itu ana, ju piara bae-bae sama ke dia pung ana sandiri. ");
INSERT INTO mkn_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ais parampuan di itu kota dong omong bilang, “Awii! Sakarang su sama ke Naꞌomi su dapa ana ulang lai! Talalu hebat, é!” Ju dong kasi nama sang dia ‘Obed’. Waktu Obed bésar datang, dia dapa satu ana laki-laki, nama Isai. Isai dapa satu ana, nama Daud, yang jadi raja. ");
INSERT INTO mkn_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Ini ni, dong pung moyang Peres pung turunan: Peres barana sang Hesron. ");
INSERT INTO mkn_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron barana sang Ram. Ram barana sang Aminadab. ");
INSERT INTO mkn_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab barana sang Nahason. Nahason barana sang Salmon. ");
INSERT INTO mkn_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon barana sang Boꞌas. Boꞌas barana sang Obed. ");
INSERT INTO mkn_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed barana sang Isai. Isai barana sang raja Daud. ");
INSERT INTO mkn_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Ini carita jadi, waktu raja Ahasuweros ada pegang parenta di Persia. Dia pegang kuasa di 127 propinsi, yang tasiar dari Hindia sampe deng Sudan. ");
INSERT INTO mkn_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","Itu waktu, dia dudu pegang parenta dari dia pung istana di kota Susa, yang ada pung benteng kuat. ");
INSERT INTO mkn_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","Waktu dia su pegang parenta tiga taon, ju dia bekin pesta rame-rame kasi dia pung pagawe deng bangsawan dong samua. Dia ju undang komandan tantara Persia deng Media dong, gubernor propinsi dong, deng orang bésar laen dong samua. Dong samua datang hadir. ");
INSERT INTO mkn_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Di itu pesta, dia kasi tunju negara pung kaya, deng dia pung hebat. Dong bagaya pake pakean mahal-mahal deng barias pake mas-perak ju. Itu pesta pung lama 180 hari. ");
INSERT INTO mkn_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Waktu itu 180 hari su abis, ju raja mau tutu samua pake pesta tuju hari yang lebe hebat lai. Samua yang tenga dalam itu benteng, kici-bésar, bapesta rame-rame di istana pung kintal. ");
INSERT INTO mkn_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Di itu kintal ada banya tiang dari batu marmer. Dong kasi tagantong gorden bam-banya dari kaen katun puti yang babunga warna biru. Dong ju ika itu gorden dong pake kaen lenan yang alus, deng tali warna ungu ko pasang di tiang pake cincin perak. Dong taro kursi tamu dari mas deng perak di atas lantai yang dong bekin dari ampat macam bahan: andia, ada batu mangkilat mera hati, ada marmer puti, ada kulit mutiara, deng satu batu mangkilat yang manyala macam-macam ju. ");
INSERT INTO mkn_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Tamu dong minum dari piala mas yang dia pung model macam-macam, deng babunga laen-laen. Ais raja pung aer anggor tapoꞌa-tapoꞌa ko kasi tunju dia pung hati bae. ");
INSERT INTO mkn_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Raja kasi tau tamu dong bilang, “Minum bam-banya! Jang malu-malu!” Ju dia suru dia pung orang karjá dong bilang, “Isi sampe ponu tarús. Taꞌusa pake barenti.” ");
INSERT INTO mkn_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Waktu raja Ahasuweros ada bekin itu pesta kasi laki-laki dong, raja pung bini tua, nama Wasti, ada bekin pesta kasi parampuan dong dalam raja pung istana ju. ");
INSERT INTO mkn_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Waktu hari ka-tuju, andia pesta pung hari tarahir, raja Ahasuweros talalu sanáng tagal su minum anggor bam-banya. Ju dia suru dia pung pagawe tuju orang yang layani sang dia di dia pung istana, andia: Mehuman, Bista, Harbona, Bigta, Abagta, Setar, deng Karkas, ");
INSERT INTO mkn_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","ko pi ame datang sang raja pung bini tua, Wasti. Dia suru bastél pake pakean langkáp deng topi jabatan. Te raja pung bini tua talalu cantik, andia ko raja mau kasi tunju di tamu dong. ");
INSERT INTO mkn_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Ma waktu itu pagawe dong su kasi tau raja pung parenta, ju raja pung bini manyao bilang, “Beta sonde pi.” Ais waktu dong kambali pi lapor sang raja bagitu, ju dia pung hati panas. ");
INSERT INTO mkn_vpl VALUES ("ET1_13","018_1_13","EST","1","13","14","(Naa, raja pung biasa, kalo dia mau bekin apa-apa, dia barunding dolu deng dia pung orang parcaya dong, yang tau sampe alus-alus dong pung hukum deng atoran. Yang biasa kasi nasiat sang raja, andia: Karsena, Setar, Admata, Tarsis, Meres, Marsena, deng Memukan. Dong yang jadi orang bésar di negara Persia deng Media, yang bisa maso mangada sang raja iko dong pung suka.) Ju raja minta nasiat sang dong bilang, ");
INSERT INTO mkn_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","“Waktu beta suru beta pung pagawe dong pi ame beta pung bini Wasti ko datang mangada sang beta, dia tolak deng sonde mau datang. Naa, iko kotong pung hukum deng atoran dong, beta musti kasi hukuman karmana sang dia? Te dia sonde mau iko raja pung parenta na!” ");
INSERT INTO mkn_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Ais Memukan badiri di raja pung muka deng di muka orang bésar dong, ju manyao bilang, “Bagini, bapa raja. Waktu bapa raja pung bini sonde mau dengar sang bapa raja, memang dia su hina deng bekin malu sang bapa raja. Ma bukan bapa raja sandiri sa, te dia ju hina deng bekin malu sang samua pagawe, deng samua rakyat yang ada di 127 propinsi. ");
INSERT INTO mkn_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Pasti samua parampuan di bapa raja pung daꞌera parenta nanti dengar dia pung bekin ni. Ais nanti dong ju sonde mau dengar-dengar sang dong pung laki, te dong bilang, ‘Raja Ahasuweros suru dia pung bini Wasti ko datang mangada, ma dia sonde pi.’ Jadi dong anggap reme dong pung laki ju. ");
INSERT INTO mkn_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Dengar sang beta. Te ini hari ju, orang bésar dari Persia deng Media pung bini dong yang ada iko pesta di istana ni, su dengar ame dia pung bekin tu. Nanti dong ju mau iko malawan sang dong pung laki. Satu anggap reme satu. Dong bakanjar tarús, sonde pake barenti ju. ");
INSERT INTO mkn_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","Jadi bapa raja, beta pung usul bagini: kalo bapa raja mau, na, tulis satu surat keputusan. Cap ini surat ko biar orang tau bilang, itu kaluar dari hukum deng atoran orang Persia deng orang Media, andia ko sonde bisa roba deng sonde bisa cabut kambali. Surat pung isi musti tulis bilang, raja pung bini Wasti sonde bole datang lai di bapa raja pung muka. Biar satu kali ju, sonde bisa. Ais kasi dia pung tampa sang satu parampuan laen yang lebe bae, yang tau kasi tunju hormat sang dia pung laki, andia bapa raja sandiri. ");
INSERT INTO mkn_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Ais nanti kalo ini surat keputusan dari bapa raja su kuliling di 127 propinsi, na, samua parampuan, kici-besar, akan taku, ais dengar-dengar deng kasi tunju hormat sang dong pung laki.” ");
INSERT INTO mkn_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Raja Ahasuweros deng dia pung pagawe dong samua tarima bae Memukan pung nasiat tu. ");
INSERT INTO mkn_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Ais dia suru dia pung orang karjá dong ko tulis surat, iko tiap suku pung bahasa deng huruf bilang, “Iko yang batúl, tiap laki musti jadi bos di dia pung ruma sandiri, deng baꞌomong dalam ruma pake dia pung suku pung bahasa.” Ju raja kirim itu surat pi 127 propinsi yang dia pegang parenta dong. ");
INSERT INTO mkn_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Lama-lama raja Ahasuweros pung mara su dingin. Ma dia inga tarús sang dia pung bini Wasti, deng dia pung bekin-bekin, ais deng surat keputusan yang kasi tau dia pung hukuman. ");
INSERT INTO mkn_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Ais ju raja pung orang karjá yang urus sang dia, omong bilang, “Bapa raja. Botong ada mau usul bagini: biar ko botong suru orang di mana-mana ko pi cari nona-nona manis yang balóm parná tidor bakumpul deng laki-laki. ");
INSERT INTO mkn_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Dari tiap propinsi, bapa raja bisa angka kapala urusan ko cari nona manis dong, ais antar sang dong datang bakumpul di ini benteng di Susa. Te di sini su ada bapa Hegai, yang sonde bisa kawin, yang bapa raja su angka ko urus parampuan di istana dong. Dia kapala urusan yang bisa jaga deng urus ini nona manis dong. Dia ju bisa ator ko biar tukang rias dong urus ini nona-nona manis pung kulit, rambut, deng pakean dong samua. ");
INSERT INTO mkn_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Ais, bapa raja bisa lia itu nona manis dong samua. Yang paling bekin sanáng bapa raja pung hati, na, bapa raja bisa angka sang dia ko jadi bini, ganti sang Wasti.” Dengar itu usulan dong ju, raja tarima bae, ais bekin iko. ");
INSERT INTO mkn_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Itu waktu, di benteng di Susa, ada satu orang Yahudi, nama Mordekai. Dia dari suku Benyamin. Dia pung papa, Yair; dia pung baꞌi Simei; deng dia pung oyang, Kis. ");
INSERT INTO mkn_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","Dolu-dolu, waktu Nebukadnesar jadi raja di Babel, deng Yekonya jadi raja Yahuda, Nebukadnesar tangkap ame sang Yekonya, Kis, deng orang laen dong, ju paksa bawa sang dong dari Yerusalem pi Babel. ");
INSERT INTO mkn_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Andia ko ini Kis pung turunan Mordekai, bésar datang di Babel, ju dong pung kelu batamba di sana. Ais, waktu dia pung bapa kici deng dia pung bini mati, Mordekai angka bapa kici pung ana nona, ko piara sang dia sama ke dia pung ana sandiri. Itu nona pung nama pake bahasa Ibrani, andia Hadasa. Deng dia pung nama pake bahasa Farsi, andia Ester. Naa, Ester ni, talalu manis deng badan baꞌisi. ");
INSERT INTO mkn_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Waktu raja pung putusan soꞌal cere buang sang mama Wasti deng cari bini baru su tasiar pi mana-mana, dong mulai ame nona-nona manis dari samua tampa ko kumpul sang dong di benteng di Susa. Dong ju bawa ame sang Ester pi raja pung istana. Dong suru Hegai ko tanggong-jawab sang dia, te dia yang urus samua parampuan di istana. ");
INSERT INTO mkn_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Itu kapala urusan talalu suka sang Ester, deng kasi tunju hati manis sang dia. Andia ko dia kasi Ester salap macam-macam, deng suru tukang pijit deng tukang rias ko bantu bekin dia jadi lebe cantik lai. Dia kasi Ester makanan yang bae, deng kasi dia parampuan tuju orang dari istana ko bantu sang dia. Tarús dia kasi pinda Ester dong di tampa paling bagus di parampuan istana dong pung kompleks. ");
INSERT INTO mkn_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Naa, Mordekai su pasán memang sang Ester ko jang kasi tau sapa-sapa bilang, dia orang Yahudi, deng dia pung kelu sapa. Ju Ester bekin iko dia pung parenta. ");
INSERT INTO mkn_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Tiap hari Mordekai jalan bolak-balik di muka kintal dari parampuan dong pung kompleks, ko dia dapa tau Ester ada karmana. ");
INSERT INTO mkn_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Naa, tiap nona musti tenga 12 bulan dalam istana dolo, baru dapa dia pung urutan tidor bakumpul deng raja Ahasuweros. Dong musti iko samua atoran kasi sang parampuan di istana dong. Andia: salama 6 bulan, tukang rias dong gosok sang dong pake minya dari dara kayu wangi mur. Salama 6 bulan lai, tukang rias dong gosok sang dong pake minya wangi macam-macam deng salap yang laen dong. ");
INSERT INTO mkn_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Kalo su sampe dia pung waktu ko satu nona maso pi tidor deng raja, na, dong kasi biar dia bole pili sandiri mau pake pakean yang mana, deng bahias pake rante mas ko perak karmana, iko dia pung suka sandiri. Dia bole minta apa sa dari parampuan dong pung kompleks di istana. ");
INSERT INTO mkn_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Kalo su mau malam, dong antar sang dia pi raja pung kamar. Dia pung beso pagi, dia sonde pulang pi kompleks pung bagian deng parampuan yang balóm tidor deng raja, ma dong musti pi di bagian deng parampuan yang su parná tidor bakumpul deng raja. Ada satu bapa lai yang sonde bisa kawin, nama Sasgas. Dia yang urus di itu bagian kadua. Kalo raja suka sang itu nona, ju minta sang dia subu pake dia pung nama, baru dia bisa kambali ko tidor ulang deng raja lai. ");
INSERT INTO mkn_vpl VALUES ("ET2_15","018_2_15","EST","2","15","16","Naa, kira-kira awal bulan Januari, waktu raja Ahasuweros su pegang parenta tuju taon, baru Ester dapa dia pung waktu ko maso pi istana ko tidor bakumpul deng raja. (Ester tu, andia Abihail pung ana. Abihail tu, andia Mordekai pung bapa kici. Deng Mordekai yang piara sang Ester dari kici.) Waktu Ester pung bagian ko pi istana, dia sonde minta apa-apa. Dia cuma minta nasiat dari Hegai sa, te dia yang urus parampuan yang balóm tidor deng raja. Deng dia iko itu nasiat sa. Andia ko waktu dia mau pi, samua orang yang lia sang Ester talalu suka sang dia. ");
INSERT INTO mkn_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Waktu Ester pi di istana ju, raja lebe sayang sang dia dari samua parampuan yang laen dong. Dia talalu suka sang Ester deng mau tunju dia pung kasi sayang sang dia. Andia ko raja angka sang dia, deng kasi dia pake topi jabatan, ganti sang Wasti yang su kaná usir tu. ");
INSERT INTO mkn_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Tarús raja bekin satu pesta bésar kasi sang Ester. Ais dia undang samua pagawe deng bangsawan ko dong makan rame-rame, deng dia kasi tamu dong hadia macam-macam yang bae. Ju dia putus bilang, itu hari jadi hari barenti karjá kasi 127 propinsi. ");
INSERT INTO mkn_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","Waktu dong su kumpul ame nona-nona dong kali kadua, na, dong ju su angka Mordekai jadi pagawe di raja pung istana. ");
INSERT INTO mkn_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Ma iko Mordekai pung pasán kasi sang Ester, dia sonde parná kasi tau orang bilang, dia orang Yahudi, deng dia pung kelu sapa. Te Ester masi dengar-dengar sang Mordekai, deng bekin iko dia pung parenta samua, sama ke dolu waktu Mordekai masi piara bae-bae sang dia. ");
INSERT INTO mkn_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Satu hari, waktu Mordekai dapa tugas di istana pung pintu maso, ada dua pagawe yang jaga di istana pung bagian dalam, yang simpan hati, ais ator siasat ko mau bunu bekin mati sang raja Ahasuweros. Dong dua tu, andia Bigtan deng Teres. ");
INSERT INTO mkn_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Ma Mordekai dapa tau dong dua pung rancana jahat. Ais dia kasi tau sang raja pung bini, Ester. Ju Ester pi kasi tau sang raja bilang, Mordekai yang kasi tau sang dia. ");
INSERT INTO mkn_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Waktu raja pung orang dong pareksa bae-bae itu laporan, tau-tau te itu batúl. Ais ju dong hukum itu dua orang deng tusu di atas tiang sampe mati. Itu parkara samua, dong tulis abis dalam raja Ahasuweros pung buku sajara. Itu waktu, raja ju ada lia dong tulis bagitu. ");
INSERT INTO mkn_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Ais itu hal dong samua, ju raja Ahasuweros mau kasi tunju hormat sang Haman, andia Hamedata pung ana, yang jadi turunan dari Agag. Andia ko dia angka sang Haman lebe tinggi dari dia pung pagawe dong samua. ");
INSERT INTO mkn_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Raja ju parenta ko kalo Haman maso-kaluar di istana pung pintu maso, na, samua pagawe yang laen dong musti tikam lutut ko kasi tunju hormat sang dia. Ais, samua kasi tunju hormat bagitu. Ma Mordekai sonde tikam lutut deng sonde kasi tunju hormat sang Haman. ");
INSERT INTO mkn_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Ais pagawe yang laen dong di istana pung pintu maso tanya sang Mordekai bilang, “Bapa! Akurang ko bapa sonde bekin iko raja pung parenta bagitu?” ");
INSERT INTO mkn_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Ju Mordekai manyao bilang, “Beta ni, orang Yahudi. Andia ko beta sonde bisa tikam lutut sang manusia deng barang songgo dong. Jadi beta sonde bisa tikam lutut sang Haman.” Dong buju-buju sang dia tiap hari, ma dia sonde mau dengar sang dong. Ais ju dong kasi tau sang Haman, ko mau lia kalo Haman kasi biar sang Mordekai bagitu, ko sonde. ");
INSERT INTO mkn_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Waktu Haman dapat tau bilang, Mordekai sonde mau tikam lutut deng sonde mau kasi tunju hormat sang dia, ju Haman talalu kakodok. ");
INSERT INTO mkn_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Ma Haman sonde puas kalo mau bunu bekin mati sang Mordekai sandiri sa. Te dia ju mau bunu bekin abis Mordekai pung bangsa Yahudi anteru di 127 propinsi yang raja Ahasuweros pegang parenta. ");
INSERT INTO mkn_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Dalam bulan April, waktu raja Ahasuweros su pegang parenta 12 taon, Haman suru bilang, “Cari tau kasi beta, waktu yang pas ko kotong bunu bekin abis Mordekai pung bangsa Yahudi dong.” Ais dong hela lot di Haman pung muka, ko cari tau bagitu. Ju itu lot jato kaná di tanggal 7 Maret, taon muka. ");
INSERT INTO mkn_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Ju Haman pi di raja Ahasuweros ko kokoe bilang, “Bapa raja yang mulia! Ada satu bangsa asing yang idop tasiar di bapa pung 127 propinsi samua. Ma dong idop tapisa dari samua. Dong ju sombong deng sonde mau bacampor deng bangsa laen dong di sini. Dong pung adat deng atoran beda dari samua suku-bangsa laen, dong ju sonde bekin iko bapa raja pung atoran dong. Sonde pantas kalo dong sonde mau hormat kotong pung atoran bagitu. Jadi ada lebe bae, bapa raja sonde usa kasi biar ko dong idop lai. ");
INSERT INTO mkn_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","Kalo iko bapa raja pung mau, beta usul bagini: bapa raja susun satu surat parenta yang tulis bilang, samua rakyat yang laen dong musti kasi ancor abis ini bangsa yang tar laku-laku dong. Kalo bapa raja satuju, na, biar ko beta kasi sang bendahara yang urus bapa raja pung doi, 10.000 karong doi perak. Ais pake itu doi dong ko bayar orang yang urus itu parkara dong. ");
INSERT INTO mkn_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Bapa raja bilang, “Neu.” Ais dia kasi kaluar dia pung cincin stempel dari dia pung jari, ju sarakan kasi sang Haman ko cap bekin sah itu surat parenta. (Haman tu, yang bamusu deng bangsa Yahudi dong. Dia tu, andia Hamedata pung ana, yang jadi turunan dari Agag.) ");
INSERT INTO mkn_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Ju raja kasi tau sang Haman bilang, “Itu doi dong, tarsará sang lu sa. Deng lu mau bekin apa sang itu bangsa tu, itu ju tarsará sang lu sa.” ");
INSERT INTO mkn_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Jadi tanggal 17 April, Haman kumpul ame raja pung juru tulis dong. Dong susun satu surat parenta iko parsís ke Haman suru sang dong. Dong tulis kasi tiap gubernor di tiap propinsi. Dong ju tulis kasi tiap bangsa deng suku pung tua-tua adat. Dong tulis iko tiap propinsi deng bangsa pung bahasa deng huruf dong. Tiap surat yang mau kaluar pake raja Ahasuweros pung nama, deng tanda cap dari raja pung cincin stempel sandiri yang dia su sarakan kasi sang Haman tu. ");
INSERT INTO mkn_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Ais dong kasi itu surat dong samua sang tukang bawa pasán dong ko mau lari bawa kasi itu surat pi itu 127 propinsi dong. Itu surat dong samua pung isi parenta yang sama bilang, “Pamimpin dong musti ator ko biar nanti tanggal 7 Maret, dong musti bunu bekin mati deng kasi ancor abis samua orang Yahudi, laki-laki-parampuan, kici-bésar, tua-muda samua. Orang yang urus itu parkara ju bole rampas ame orang Yahudi pung harta milik dong samua.” ");
INSERT INTO mkn_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Kalo itu surat dong su sampe di daꞌera, dong musti tulis ulang dia pung isi, ko biar rakyat di tiap propinsi deng bangsa bisa tau dia pung isi, ju siap-siap ko mau bunu bekin mati abis samua orang Yahudi pas dia pung hari. ");
INSERT INTO mkn_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Waktu raja parenta tukang bawa pasán dong ko pi bawa capát, ju dong langsung lari bawa kasi itu surat parenta pi samua tampa. Di kota Susa ju, dong tempel itu surat ko biar samua rakyat bisa tau. Ais ju raja dudu makan-minum deng Haman. Ma rakyat di kota Susa dong ada tabingung-bingung. ");
INSERT INTO mkn_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Waktu Mordekai dapa tau samua hal yang Haman dong mau bekin sang orang Yahudi dong, ju dia robek dia pung pakean dari badan. Ais dia ganti pake sarong dari karong goni, ju poꞌa abu di dia pung kapala sandiri ko jadi tanda bilang, dia pung hati talalu susa. Tarús dia kaluar dari dia pung ruma bagitu, pi kota pung jalan dong, ju manangis kuat-kuat dari dia pung hati yang pait. ");
INSERT INTO mkn_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Ma waktu sampe di istana pung pintu maso, dia sonde jadi maso, tagal orang yang pake sarong dari karong goni sonde bole maso di situ. ");
INSERT INTO mkn_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Waktu raja pung surat parenta sampe di tiap propinsi, ais dia pung rakyat dengar itu surat pung isi, ju orang Yahudi dong samua hati susa. Dong manangis kuat-kuat, sama ke ada orang baru mati. Ju dong puasa. Dong banya baganti pake sarong dari karong goni, ju dong poꞌa abu di dong pung kapala sandiri ko jadi tanda bilang, dong pung hati susa. ");
INSERT INTO mkn_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Waktu parampuan yang bantu Ester dong, deng laki-laki yang jaga parampuan dong datang kasi tau Ester soꞌal Mordekai, ju Ester pung hati susa mau mati. Ais dia kirim kasi Mordekai pakean yang bae, ko ganti itu karong goni. Ma dia sonde mau tarima. ");
INSERT INTO mkn_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Ais Ester pange datang satu orang, nama Hatak. (Dia tu, satu laki-laki yang sonde bisa kawin, yang raja suru karjá kasi sang Ester.) Ju Ester suru Hatak ko pi cari sang Mordekai, ko cari tau akurang ko Mordekai hati susa ko pake karong goni deng manangis kuat-kuat bagitu. ");
INSERT INTO mkn_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Andia ko Hatak kaluar pi cari Mordekai di tana lapang di muka istana pung pintu maso, ju tanya sang dia iko Ester pung pasán. ");
INSERT INTO mkn_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Ais Mordekai kasi tau samua-samua. Dia ju carita kasi tau barapa banya doi yang Haman su tawar mau kasi maso di raja pung bendahara, ko biar orang dong bunu kasi abis samua orang Yahudi. ");
INSERT INTO mkn_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Ju Mordekai kasi sang Hatak satu surat parenta yang dong su tempel di kota Susa, yang tulis bilang, raja suru ko bunu kasi abis samua orang Yahudi di 127 propinsi. Ais Mordekai minta sang Hatak bilang, “Pi kasi tunju ini surat sang raja pung bini, Ester. Carita samua-samua sang dia. Ais bilang beta yang suru sang dia ko pi mangada sang raja ko bela dia pung bangsa sandiri, deng minta ko biar raja kasi tunju dia pung hati bae sang botong samua.” ");
INSERT INTO mkn_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Ju Hatak pulang ko carita sang Ester samua-samua yang Mordekai bilang. ");
INSERT INTO mkn_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Ais Ester suru Hatak bawa pasán kambali pi sang Mordekai bilang, ");
INSERT INTO mkn_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“Bagini: ada satu atoran yang samua orang karjá di istana deng samua rakyat di 127 propinsi dong su tau. Andia, kalo ada laki-laki ko parampuan yang pi deka-deka deng raja di dia pung kamar parenta, padahal raja sonde parná pange sang dong, na, dia pung atoran bilang, itu orang musti kaná hukum mati. Cuma ada satu jalan kaluar sa, andia kalo raja sorong dia pung tongkat parenta mas. Kalo raja bekin bagitu, baru itu orang bisa salamat. Ma inga te, su 30 hari ni raja sonde pange beta datang.” ");
INSERT INTO mkn_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Ais Hatak pi kasi tau Mordekai samua yang Ester su bilang. ");
INSERT INTO mkn_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","Ju Mordekai manyao bilang, “Pi kasi tau sang raja pung bini, Ester bilang, ‘Jang pikir bilang, lu sandiri sa orang Yahudi yang sonde kaná bunu, tagal lu tenga dalam raja pung istana. ");
INSERT INTO mkn_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Ma inga te, kalo lu sonde omong apa-apa sakarang, nanti jalan kaluar deng jalan salamat kasi orang Yahudi dong muncul datang dari orang laen. Ma kalo jadi bagitu, lu deng lu pung kelu dong samua ancor buang. Sapa tau? Jang sampe lu jadi raja pung bini sakarang, ko cuma urus ini satu parkara sa.’ ” ");
INSERT INTO mkn_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Ais Ester kirim pasán kasi sang Mordekai bilang, ");
INSERT INTO mkn_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“Pi kumpul ame samua orang Yahudi di kota Susa ni. Beta minta ko bosong puasa deng sambayang kasi sang beta tiga siang, tiga malam. Jang makan, deng jang minum sadiki ju. Beta deng beta pung parampuan karjá dong ju puasa deng sambayang bagitu. Ais itu, biar beta langgar atoran, ma beta mau maso mangada sang raja. Kalo beta musti mati, na, biar beta mati.” ");
INSERT INTO mkn_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Ju Mordekai pulang, ais bekin iko Ester pung pasán samua. ");
INSERT INTO mkn_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Waktu dong su puasa tiga hari, Ester pake dia pung pakean jabatan yang alus, ju pi badiri pas di muka raja pung pintu. Itu pintu tu, yang maso pi raja pung tampa parenta. Raja ada dudu di atas dia pung kursi parenta yang bamangada deng itu pintu. Itu pintu tu, tabuka lebar. ");
INSERT INTO mkn_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Waktu raja lia Ester ada badiri di muka pintu, ju dia pung hati sanáng. Andia ko dia sorong dia pung tongkat parenta dari mas yang ada di dia pung tangan ko kasi tunju bilang, dia mau tarima bae sang Ester. Ais Ester maju pi muka, ju sonto itu tongkat pung ujung. ");
INSERT INTO mkn_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Ju raja tanya sang dia bilang, “Karmana, Ester? Ada parlú apa? Mau minta apa di beta, na, kasi tau sa! Nanti beta kasi. Biar mau minta bagi dua beta pung harta karajaꞌan ju, beta kasi.” ");
INSERT INTO mkn_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Ais Ester manyao bilang, “Bapa raja yang mulia. Beta ada siap meja ko bekin satu pesta kasi sang bapa raja. Jadi, kalo bapa raja suka, na, nanti bapa datang ko makan pesta. Kalo mau, na, tolong bawa Haman datang ju. Te sadiki lai samua su siap na!” ");
INSERT INTO mkn_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Tarús raja suru dia pung orang dong bilang, “Pi cari Haman ko suru dia datang sakarang. Capát! Te botong mau iko mama raja pung minta.” Ju dong pi. Waktu Haman su datang, ju dia iko sama-sama deng raja ko pi makan pesta yang Ester ada siap kasi sang dong. ");
INSERT INTO mkn_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Waktu dong ada minum anggor, ju raja tanya ulang sang Ester bilang, “Karmana, Ester? Sakarang su bisa kasi tau, lu ada parlú apa? Lu mau minta apa sang beta, na, kasi tau sa! Nanti beta kasi. Biar lu minta bagi dua beta pung harta karajaꞌan ju, beta kasi.” ");
INSERT INTO mkn_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Ais Ester kasi tau bilang, “Bapa raja yang beta sayang. Beta pung parlú bagini sa: ");
INSERT INTO mkn_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","kalo bapa raja sayang sang beta, deng mau bekin iko beta pung minta, na, beta usul bagini: biar beso beta bekin satu pesta lai kasi sang bapa raja. Beso, kalo datang makan pesta di sini, baru beta kasi tau beta pung parlú. Haman bisa iko datang ju.” ");
INSERT INTO mkn_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Itu hari, waktu Haman mau pulang dari itu pesta, ju dia pung hati babunga deng sanáng. Ma waktu dia kaluar dari istana pung pintu maso, dia lia Mordekai sonde badiri ko kasi tunju hormat sang dia, deng sonde kasi tunju rasa taku sadiki ju. Itu bekin Haman tamba jengkel lai sang Mordekai. ");
INSERT INTO mkn_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Biar dia makan gigi bagitu ju, dia tahan diri, ko pulang ruma. Sampe deng sampe ju, dia pange datang dia pung tamán dong, deng dia pung bini Seres. ");
INSERT INTO mkn_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Waktu dong su bakumpul, ju Haman omong bésar bilang, “Beta pung harta ada banya. Beta pung anak-anak ada banya ju. Ais raja ada kasi tunju hormat sang beta deng cara macam-macam. Dia ju angka sang beta lebe tinggi dari samua pagawe deng orang bésar laen dong yang karjá kasi sang dia. ");
INSERT INTO mkn_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Bukan raja sandiri sa yang kasi tunju hormat sang beta, ma tadi raja pung bini Ester ju minta ko raja deng beta pi makan pesta yang dia su ator. Cuma botong dua sa! Sonde ada orang laen lai! Bukan itu sa, ma dia ju su undang ko beso raja deng beta pi makan pesta lai di situ. Hebat, wuang? ");
INSERT INTO mkn_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Ma beta rasa ke itu samua sonde ada pung arti apa-apa. Te tiap kali beta maso-kaluar lewat istana pung pintu maso tu, beta lia itu orang Yahudi, andia Mordekai, ada dudu di situ. Dia sonde parná badiri ko kasi tunju hormat sang beta! Su talalu lebe ni!” ");
INSERT INTO mkn_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Ais Haman pung bini, Seres, deng dia pung tamán dong samua, omong bilang, “Kalo bagitu, na, botong usul bagini: suru orang ko kasi badiri satu tiang gantong yang tinggi 22 meter. Tarús beso pagi minta raja ko suru orang gantong ame sang Mordekai di situ sampe mati. Ais nanti, kalo iko makan pesta sama-sama deng raja, lu pung hati bisa tanáng, te lu pung parkara deng Mordekai su abis.” Ju Haman tarima bae dong pung usul, ais dia suru orang ko kasi badiri itu tiang gantong, ko biar dia bisa gantong kasi mati Mordekai di situ. ");
INSERT INTO mkn_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","Itu malam ju, raja susa tidor. Ais lama-lama dia suru orang bilang, “Bawa datang itu tulisan yang carita samua-samua yang su jadi, mulai dari dong angka sang beta jadi raja!” Ju orang pi ame itu tulisan dong, ais baca ko biar raja bisa dengar. ");
INSERT INTO mkn_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","Baca-baca, ju dong baca parkara dolu, waktu Mordekai dapat tau bilang, raja pung dua pagawe yang jaga di istana, andia Bigtan deng Teres, su ator siasat ko mau bunu sang raja Ahasuweros. Ju Mordekai kasi tau orang ko dong jang bunu ame sang raja. Ais ju orang su tulis itu parkara dalam itu tulisan, te itu dong pung sajara. ");
INSERT INTO mkn_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Dengar itu carita, ju raja tanya dia pung orang karjá dong bilang, “Kotong su bekin apa, ko kasi tunju hormat sang Mordekai? Te dia su kasi salamat sang beta, na!” Dong manyao bilang, “Bapa raja jang mara, ma kotong sonde parná bekin apa-apa kasi sang dia.” ");
INSERT INTO mkn_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Naa, itu waktu Haman baru maso di luar raja pung ruang parenta, ko mau minta raja gantong bekin mati sang Mordekai di itu tiang gantong yang dia baru kasi badiri tu. Ju raja lia ada orang yang badiri di ruang tunggu, ais dia tanya bilang, “Sapa yang ada di situ tu?” ");
INSERT INTO mkn_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Ju raja pung orang karjá dong manyao bilang, “Itu, andia Haman yang ada badiri di ruang tunggu.” Ais raja parenta bilang, “Suru dia maso sa!” ");
INSERT INTO mkn_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Ju Haman maso datang. Ais raja langsung tanya sang dia bilang, “Kalo raja mau kasi tunju hormat sang satu orang, na, raja musti bekin karmana?” Naa, Haman ada pikir bilang, “Pasti raja mau kasi tunju hormat sang beta ni. Te sonde mungkin ada orang laen lai yang lebe hebat dari beta na!” ");
INSERT INTO mkn_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Jadi dia kasi tau sang raja bilang, “Bapa raja! Beta pung usul bagini: kalo bapa raja mau kasi tunju hormat sang satu orang, na, ");
INSERT INTO mkn_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","suru orang karjá dong ko bawa bapa raja pung baju satu yang bapa raja parná pake. Deng bawa bapa raja pung kuda satu yang ada pake bapa raja pung tanda jabatan di dia pung kapala. ");
INSERT INTO mkn_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Ais sarakan itu baju deng itu kuda sang bapa raja pung pagawe tinggi satu, ko biar dia yang kasi pake itu baju sang itu orang yang bapa raja mau kasi tunju hormat sang dia. Deng itu pagawe ju yang musti kasi nae itu orang di bapa raja pung kuda. Ais ju suru itu pagawe ko antar bawa itu orang di kota pung tana lapang deng jalan bésar dong. Itu pagawe ju musti jalan di muka itu kuda, deng batarea kasi tau bilang, ‘Kalo raja mau kasi tunju hormat sang satu orang, na, dia kasi tunju deng cara bagini su!’ ” ");
INSERT INTO mkn_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Dengar bagitu, ju raja suru sang Haman bilang, “Neu! Sakarang lu pi ko pili ame itu baju deng kuda, parsís ke lu pung omong tadi tu. Ada satu orang Yahudi, nama Mordekai, yang biasa dapat tugas di istana pung pintu maso. Lari capát-capát ko bekin iko lu pung omong tadi samua kasi sang dia. Jang kurang satu apa ju! Te beta mau kasi tunju hormat sang dia na!” ");
INSERT INTO mkn_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Jadi mau tar mau Haman pi ame itu baju deng itu kuda. Ju dia kasi pake itu baju di Mordekai, ais kasi nae sang dia di itu kuda. Ju Haman antar dia kuliling di kota pung jalan bésar dong, deng batarea bilang, “Kalo raja mau kasi tunju hormat sang satu orang, na, dia kasi tunju deng cara bagini su!” ");
INSERT INTO mkn_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Antar abis, ju Mordekai kambali tugas di istana pung pintu maso. Ma Haman rasa malu mati. Andia ko dia pulang capát-capát deng tutu muka pake kaen. ");
INSERT INTO mkn_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Pulang deng pulang ju, dia carita kasi tau samua-samua sang dia pung bini Seres, deng dia pung tamán yang dia parcaya dong. Ju dong kasi tau bilang, “Aduu! Itu Mordekai tu, orang Yahudi. Lu su kala. Pasti lu su mulai jato ni, ma. Sonde mungkin lu bisa malawan ame sang dia!” ");
INSERT INTO mkn_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Waktu dong masi baꞌomong, ju raja pung pagawe dong datang ame sang Haman, ais antar dia capát-capát ko pi makan pesta yang Ester su siap. ");
INSERT INTO mkn_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Ais raja deng Haman datang makan pesta sama-sama deng mama raja Ester. ");
INSERT INTO mkn_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Itu pesta kadua, waktu dong ada minum aer anggor, ju raja tanya ulang sang Ester bilang, “Mama raja ada parlú apa? Lu mau minta apa sang beta, na, kasi tau sa! Te nanti beta kasi. Biar mau minta bagi dua beta pung harta karajaꞌan ju, beta kasi.” ");
INSERT INTO mkn_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Ais Ester manyao bilang, “Bagini, bapa raja. Kalo bapa raja batúl-batúl sayang sang beta, deng mau kasi tunju rasa kasian sang beta, na, beta minta ko biar beta deng beta pung bangsa dong bisa idop. Beta pung parlú, andia itu. ");
INSERT INTO mkn_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Te ada orang yang su jual buang sang beta deng beta pung bangsa dong, ko mau bunu bekin mati deng kasi ancor abis samua. Kalo dong cuma mau jual sang botong ko jadi budak, laki-laki deng parampuan, na, beta sonde omong sadiki ju, te beta sonde mau ganggu bapa raja deng parkara kici ana dong. Ma kalo bunu kasi abis sang beta deng beta pung orang dong, itu bekin rugi bésar sang bapa raja. Dia pung risiko tinggi na!” ");
INSERT INTO mkn_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Ju raja Ahasuweros tanya sang dia pung bini Ester bilang, “Hoe! Sapa yang mau bekin bagitu? Sapa yang barani bagitu tu?” ");
INSERT INTO mkn_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Ais Ester manyao bilang, “Itu orang jahat tu, andia Haman. Te dia yang bamusu deng botong, ko mau bunu bekin mati sang beta deng beta pung bangsa anteru!” Dengar Ester kasi tau dia pung jahat sang raja, pas di dia pung muka bagitu, ju Haman taku mau mati. ");
INSERT INTO mkn_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Ma raja talalu mara. Andia ko dia badiri, jalan kasi tenga sang dong. Dia jalan pi istana pung taman ko pikir mau bekin karmana. Ma Haman lia kalo raja su mau kasi ancor buang sang dia, ais dia tenga di situ ko mau minta sang Ester kasi salamat sang dia. ");
INSERT INTO mkn_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Itu waktu, Ester ada baring-baring di korsi panjang ko makan pesta, iko dong pung biasa. Pas waktu raja maso kambali dari taman pi dalam tampa makan pesta tu, ju dia lia Haman ada buang badan ko pegang Ester pung kaki ko minta raja pung bini kasi salamat sang dia. Lia bagitu, ju raja maruak bilang, “Hoe! Ini orang su talalu! Te dia barani mau parkosa sang beta pung bini di beta pung ruma sandiri ni!” Dengar raja omong bagitu, ju dia pung pagawe dong tutu ame Haman pung muka pake kaen. Itu jadi tanda bilang dia musti mati. ");
INSERT INTO mkn_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Ais raja pung orang parcaya satu yang layani sang dia, nama Harbona, usul bilang, “Bapa raja. Masi ada itu tiang gantong di Haman pung muka ruma. Dia pung tinggi 22 meter, ko biar samua orang bisa dapa lia. Te Haman mau pake itu tiang ko gantong bekin mati sang Mordekai, andia itu orang yang su kasi salamat sang bapa raja dolu, waktu itu dua orang mau bunu sang bapa raja.” Dengar bagitu, ju raja suru bilang, “Hoo. Pi gantong sang Haman di situ su!” ");
INSERT INTO mkn_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Ais dong gantong bekin mati sang Haman di itu tiang yang dia sandiri su bekin ko siap mau bunu sang Mordekai di situ. Bunu abis, ju raja pung hati jadi dingin. ");
INSERT INTO mkn_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Itu hari ju, raja Ahasuweros sarakan Haman pung harta samua pi dia pung bini Ester, te Haman tu yang bamusu deng Ester pung bangsa Yahudi. Itu waktu ju Mordekai datang mangada di raja, ais Ester buka kartu kalo dia bakelu deng Mordekai. ");
INSERT INTO mkn_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Ais ju raja ame dia pung cincin stempel dari dia pung jari sandiri yang dia su dapa kambali dari Haman, ais sarakan kasi sang Mordekai. Ju Ester angka Mordekai ko urus Haman pung harta deng tana milik dong. ");
INSERT INTO mkn_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Ais satu kali lai, Ester maso pi raja pung ruang parenta ko mau baꞌomong deng raja. Ju dia tikam lutut di raja pung kaki, deng manangis ko mau minta raja cari jalan ko biar Haman, yang orang Agag tu, pung rancana jahat jang jadi. ");
INSERT INTO mkn_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Lia bagitu, ju raja sorong dia pung tongkat parenta mas yang ada di dia pung tangan ko kasi tunju bilang, dia mau tarima bae sang Ester. Ais Ester badiri di raja pung muka, ");
INSERT INTO mkn_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","ju bilang, “Bapa raja yang mulia. Kalo bapa ada suka sang beta, deng kalo beta pung minta ni bacocok deng bapa raja pung suka, na, beta minta bagini: tolong tulis surat parenta yang tarek kambali itu surat-surat yang Haman, andia Hamedata pung ana, su parná tulis dong. Andia itu surat yang suru orang bunu bekin abis samua orang bangsa Yahudi dalam bapa raja pung 127 propinsi dong. ");
INSERT INTO mkn_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Te beta sonde bisa tahan ame lia calaka yang nanti jato kaná di beta pung orang dong sampe dong ancor abis. Apalai beta pung kelu sandiri dong. Beta sonde kuat bagitu, bapa.” ");
INSERT INTO mkn_vpl VALUES ("ET8_7","018_8_7","EST","8","7","8","Ju raja Ahasuweros kasi tau sang Ester deng Mordekai bilang, “Ma inga te, dia pung susa bagini: kalo ada surat parenta yang kaluar bawa raja pung nama deng pake cap dari raja pung cincin stempel, na, itu parenta sonde bisa batal deng sonde bisa cabut kambali. Ma orang dong su tau bilang, beta su suru gantong bekin mati sang Haman. Deng beta ju su sarakan Haman pung harta milik samua di Ester pung tangan, tagal Haman bamusu deng bangsa Yahudi deng ator siasat ko mau kasi ancor abis sang dong. Ais beta su kasi raja pung cincin stempel sang Mordekai. Jadi bosong bisa tulis apa sa, iko bosong pung suka soꞌal ini parkara deng orang Yahudi dong. Inga te, bosong tulis apa pake raja pung cincin stempel, na, orang sonde bisa cabut kambali. Te itu sama ke beta yang su parenta bagitu! ");
INSERT INTO mkn_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Jadi itu waktu ju, andia tanggal 25 Juni, Mordekai suru raja pung juru tulis dong datang bakumpul. Dong tulis surat parenta, iko parsís apa yang Mordekai kasi tau sang dong. Itu surat dong, dong tulis kasi samua-samua, andia: orang Yahudi, pagawe, gubernor, deng bangsawan dong di 127 propinsi yang tasiar dari Hindia sampe deng Sudan. Dong tulis iko tiap propinsi deng bangsa pung bahasa deng huruf dong. Dong tulis sang orang Yahudi pake dong pung bahasa Ibrani deng huruf Ibrani ju. ");
INSERT INTO mkn_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Mordekai susun itu surat dong sama ke kalo raja Ahasuweros sandiri yang susun. Tiap surat yang mau kaluar bawa raja pung nama, deng tanda cap dari raja pung cincin stempel sandiri yang dia su sarakan kasi sang Mordekai tu. Ju dia kasi sang tukang bawa pasán dong ko nae kuda yang paling capát, yang dong piara kasi sang raja deng maksud bagitu. ");
INSERT INTO mkn_vpl VALUES ("ET8_11","018_8_11","EST","8","11","13","Ini surat dong pung bunyi bagini: “Bapa raja kasi tau samua orang bagini: Nanti taon muka, tanggal 7 Maret, samua orang Yahudi di tiap kota di samua propinsi, bole bakumpul, deng bole bela diri. Kalo ada tantara yang sarbú datang di dong, na, orang Yahudi bole kasi ancor abis sang dong. Kalo ada musu dari bangsa mana, ko, propinsi apa sa yang datang saráng sang dong, na, orang Yahudi bole balas kasi ancor sang dong kambali. Biar laki-laki ko parampuan. Biar orang kici ko orang bésar. Bukan sa dong bole bela diri deng sarbú bale, ma orang Yahudi dong bole rampas ame dong pung musu pung harta milik deng tana milik samua ju. Ini surat parenta musti tempel di tiap propinsi, ko biar samua orang bisa baca sandiri dalam dong pung bahasa sandiri. Deng bagitu orang Yahudi samua bisa siap memang. Beta pung surat parenta bagitu sa!” ");
INSERT INTO mkn_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Ais ju raja suru tukang bawa pasán dong ko lari capát. Andia ko dong nae raja pung kuda yang paling capát dong, ais lari tasiar pi samua tampa, mulai dari benteng di kota Susa. ");
INSERT INTO mkn_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Ais ju waktu Mordekai kaluar dari raja pung istana, dia pake pakean yang biru deng puti, sama ke raja biasa pake. Dia pake topi jabatan dari mas, deng baju panjang dari kaen lenan dari Masir yang ada hias deng warna ungu. Waktu orang kota Susa dengar itu parkara pung jalan kaluar, deng lia Mordekai pung pakean alus, ju dong batarea rame-rame deng hati sanáng. ");
INSERT INTO mkn_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Waktu orang Yahudi dong dengar ada jalan kaluar bagitu, na, dong talalu sanáng, te dong bisa salamat, deng orang laen dong kasi tunju hormat sang dong. ");
INSERT INTO mkn_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Andia ko di tiap kota di samua propinsi, kalo raja pung surat parenta su sampe, na, samua orang Yahudi rasa sanáng. Ju dong bekin hari bae ko bapesta rame-rame. Ada orang laen ju yang minta dong angka sang dong jadi orang Yahudi ju, tagal dong taku orang Yahudi mau bekin apa-apa sang dong. ");
INSERT INTO mkn_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Ais, tanggal 7 Maret ada dua parenta yang bawa raja pung nama, yang sah di itu hari. Jadi itu hari orang Yahudi pung musu dong baharap dong bisa kasi ancor buang orang Yahudi dong. Padahal itu hari ju, su jadi tabale, te su oba ko jadi hari yang orang Yahudi dong bisa kasi kala bale sang dong pung musu dong. ");
INSERT INTO mkn_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Ais, di samua kota dalam itu 127 propinsi yang raja Ahasuweros pegang parenta dong, orang Yahudi bakumpul saráng bale sang musu-musu dong yang mau kasi ancor buang sang dong. Sonde ada yang bisa lawan ame sang dong, te samua bangsa laen dong takut mati sang orang Yahudi dong. ");
INSERT INTO mkn_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Ais orang bésar samua di itu 127 propinsi, andia: pagawe istana, gubernor, deng bangsawan dong, cari jalan ko mau tolong orang Yahudi dong, te dong su takut sang Mordekai. ");
INSERT INTO mkn_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Te orang di itu 127 propinsi dong samua su tau bilang, raja su angka Mordekai di dia pung istana, ju dia pung nama su tasiar pi mana-mana. Deng dia pung kuasa batamba tarús. ");
INSERT INTO mkn_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Jadi itu hari ju orang Yahudi dong pegang kalewang, ais bunu bekin mati deng kasi ancor buang sang orang yang bamusu deng dong. Dong bekin iko dong pung suka. ");
INSERT INTO mkn_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Dalam itu benteng di kota Susa sandiri sa, dong bunu bekin mati 500 orang. ");
INSERT INTO mkn_vpl VALUES ("ET9_7","018_9_7","EST","9","7","10","Dong ju bunu bekin mati sang Haman pung sapulu ana laki-laki. Andia: Parsandata, Dalfon, Aspata, Porata, Adalya, Aridata, Parmasta, Arisai, Aridai, deng Waisata. (Haman tu, andia Hamedata pung ana, yang bamusu deng bangsa Yahudi tu.) Ma orang Yahudi dong sonde rampas orang pung harta sadiki ju. ");
INSERT INTO mkn_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Itu hari ju orang lapor sang raja, ko kasi tau bilang, “Orang Yahudi dong su bunu abis barapa orang dalam benteng di ini kota Susa.” ");
INSERT INTO mkn_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Ais ju raja kasi tau sang Ester bilang, “Beta su dengar bilang, orang Yahudi dong su bunu bekin mati 500 orang dalam ini benteng di kota Susa. Dong ju bunu kasi abis Haman pung ana laki-laki sapulu orang dong. Beta sonde bisa bayangkan dong su bekin karmana di propinsi yang laen dong. Ma beta mau tanya, mama raja masi ada parlú, ko? Mama raja minta apa sa, nanti beta bekin iko. Kasi tau sa!” ");
INSERT INTO mkn_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Ju Ester manyao bilang, “Kalo bapa raja tarima bae, na, beta minta bagini: kalo beso, biar orang Yahudi dalam ini kota Susa bekin iko tarús itu surat parenta yang ada pake kamaren. Deng biar ko orang gantong ame Haman pung ana laki-laki sapulu orang pung mayat dong, ko biar samua orang bisa dapa lia. Beta pung minta bagitu sa.” ");
INSERT INTO mkn_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Ais raja tarima bae, ju dia kasi kaluar parenta di kota Susa, yang suru orang ko gantong ame Haman pung ana laki-laki sapulu orang pung mayat dong. ");
INSERT INTO mkn_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Ju dia pung beso, andia tanggal 8 Maret, orang Yahudi dalam kota Susa bunu tamba 300 orang lai. Ma dong sonde rampas ame orang pung harta sadiki ju. ");
INSERT INTO mkn_vpl VALUES ("ET9_16","018_9_16","EST","9","16","17","Itu waktu ju, andia tanggal 7 Maret, orang Yahudi yang tenga dalam raja pung 127 propinsi yang laen dong bakumpul ko bela diri dari musu dong. Ju dong bunu bekin mati 75.000 orang. Deng bagitu, dong bisa rasa aman, te sonde ada yang ancam sang dong lai. Ma dong sonde rampas ame orang pung harta sadiki ju. Dia pung beso, andia tanggal 8 Maret, dong bekin pesta rame-rame, tagal sanáng. ");
INSERT INTO mkn_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Deng bagitu, tanggal 7 deng 8 Maret di kota Susa, orang Yahudi dong bakumpul dua hari ko baparáng lawan orang yang bamusu deng dong. Ma tanggal 9 Maret, dong barenti, ais dong bakumpul ko bapesta rame-rame. ");
INSERT INTO mkn_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Ma kalo orang Yahudi yang tenga di kampong-kampong deng kota laen, dong cuma baparáng satu hari sa. Andia ko sampe sakarang ju, tiap taon, andia tanggal 8 Maret, dong bakumpul ko bapesta rame-rame. Di itu hari bae, dong bakirim makanan kasi satu deng satu. ");
INSERT INTO mkn_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Samua yang jadi tu, Mordekai tulis bae-bae. Ju dia kirim surat pi kasi samua orang Yahudi yang tenga di 127 propinsi yang raja Ahasuweros pegang parenta dong, biar jao ko dekat. ");
INSERT INTO mkn_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","Dia tulis kasi tau sang dong bilang: “Mulai sakarang, tiap taon bosong musti bekin pesta yang jato di tanggal 8 deng 9 Maret. ");
INSERT INTO mkn_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Te itu dua hari tu, yang kotong orang Yahudi kasi kala abis sang orang yang bamusu deng kotong. Deng bagitu, kotong su barenti cape, te sonde kaná ancam lai, deng samua su roba jadi baru. Andia ko kotong musti inga ini bulan, te kotong pung susa su oba jadi sanáng, deng kotong pung duka su oba jadi pesta rame-rame. Kotong sonde idop deng taku deng manangis lai. Andia ko tiap taon kotong musti bekin pesta rame-rame. Kotong musti bakirim makanan kasi satu deng satu, ju kasi barang sang orang miskin dong.” ");
INSERT INTO mkn_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Tarima itu surat yang Mordekai su tulis dong, ju orang Yahudi tarima bae, ais bekin hari bae tiap taon bagitu. ");
INSERT INTO mkn_vpl VALUES ("ET9_24","018_9_24","EST","9","24","26","Naa, dia pung carita kanapa dong kasi nama itu hari bae bilang “Purim”, andia bagini: dolu, ada satu orang Agag, nama Haman, andia Hamedata pung anak. Dia yang ator siasat ko mau bunu bekin abis orang Yahudi dong samua. Tagal dia mau cari waktu yang pas ko bekin jadi dia pung akal jahat, andia ko dia hela lot ko pili dia pung hari yang paling bae ko mau bunu orang Yahudi dong. Naa, ‘lot dong’ dalam bahasa Ibrani bilang, ‘pur-im’. (Dia pung bentuk tunggal, andia ‘pur’.) Ma waktu Ester dapa tau, ais pi mangada kasi tau sang raja, ju raja parenta pake surat bilang, itu rancana jahat yang Haman su ator ko bekin jahat sang orang Yahudi musti makan bale di Haman pung kapala sandiri. Te dia deng dia pung ana laki-laki dong samua musti mati tagantong di tiang. Itu, dia pung carita kanapa dong kasi nama itu hari bae bilang, “Purim”. Di itu hari bae dong inga samua yang jadi kaná deng orang Yahudi, ju dong inga itu surat yang Mordekai parná tulis yang kasi tunju jalan kaluar kasi sang dong. ");
INSERT INTO mkn_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","Mulai dari itu waktu, orang Yahudi dong bekin hari bae yang jalan dua hari ko inga itu parkara. Dong bekin bagitu tarús tiap taon. Itu jadi dong pung biasa tiap taon, iko samua yang Mordekai su tulis kasi sang dong, sampe turun-tamurun. ");
INSERT INTO mkn_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Dia pung batúl, andia: dalam tiap generasi, tiap kelu orang Yahudi di tiap kota di tiap propinsi, musti inga itu parkara deng bekin iko itu hari bae Purim tu. Sonde bole putus, ma musti kasi jalan tarús bagitu sampe turun-tamurun. ");
INSERT INTO mkn_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Jadi waktu Mordekai tulis dia pung surat nomer dua tu, raja pung bini Ester, andia Abihail pung ana, ju tulis satu surat yang bawa dia pung nama deng pangkat sandiri, yang dukung kuat Mordekai pung surat yang kasi jalan hari bae Purim tu. ");
INSERT INTO mkn_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Ju ada surat-surat yang orang kirim kasi sang orang Yahudi yang tenga di itu 127 propinsi yang raja Ahasuweros pegang parenta dong bilang, “Biar ko bosong samua bisa idop aman, dame, deng tanáng.” ");
INSERT INTO mkn_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","Ini surat dong ju kasi tau karmana dong musti bekin itu hari bae Purim tiap taon, iko Mordekai deng Ester dong pung surat. Orang Yahudi, dong pung ana, dong pung cucu, dong pung cece, deng dong pung turunan samua musti inga deng bekin itu hari bae tiap taon tarús-tarús, sama deng dong bekin orang Yahudi pung hari-hari bae laen dong ju. Ada yang dong makan rame-rame, ada yang dong musti puasa, deng ada yang dong musti manyasal deng sambayang minta tolong. ");
INSERT INTO mkn_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Raja pung bini Ester pung parenta kasi tunju cara bekin hari bae Purim, deng suru dong bekin bagitu tiap taon. Dong ju tulis itu samua-samua di pamarenta pung buku sajara. ");
INSERT INTO mkn_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Raja Ahasuweros ju kasi jalan parenta ko suru samua orang di dia pung karajaꞌan ko bayar pajak yang pake hasil kabón, ko, karjá. Itu atoran ju kaná sampe di laut pung sablá. ");
INSERT INTO mkn_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Samua yang raja bekin, samua yang kasi tunju dia pung kuasa, samua yang jadi, soꞌal itu orang Yahudi dong pung parkara yang bekin raja Ahasuweros angka sang Mordekai jadi orang bésar tu, pagawe di istana dong su tulis samua-samua dalam Buku Sajara Raja Orang Media deng Orang Persia dong. ");
INSERT INTO mkn_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Te itu orang Yahudi, andia Mordekai, nae jadi raja Ahasuweros pung tangan kanan. Mordekai ju jadi orang bésar di orang Yahudi dong pung teng-tenga. Dong ju hormat sang dia, tagal dia cari yang bae kasi dia pung orang dong sandiri. Kalo ada parkara ko, kasampatan ko, Mordekai cari jalan ko biar samua jadi bae kasi dia pung orang Yahudi dong. ");
INSERT INTO mkn_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Dolu-dolu, ada satu orang Israꞌel, nama Yunus. Dia pung bapa, nama Amitai. Satu kali, TUHAN Allah utus sang Yunus ko kasi tau Dia pung pasán bilang, ");
INSERT INTO mkn_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Dengar, é! Sakarang lu jalan pi sablá matahari nae di negara Asiria pung kota bésar, andia Niniwe, yang bamusu deng Israꞌel. Pi kasi tau taráng-taráng sang orang dong di situ bilang, ‘Tuhan Allah su lia bosong pung jahat. Andia ko Dia mau hukum sang bosong.’ ” ");
INSERT INTO mkn_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ma Yunus sonde mau dengar. Dia mau lari jao dari Tuhan. Andia ko dia mau pi jao di sablá matahari turun sampe di kota Tarsis, andia di Spanyol. Ju dia turun pi kota Yope ko cari kapal yang mau balayar pi Spanyol. Dapa satu kapal bagitu, ais dia bayar ongkos, ju nae itu kapal. Deng bagitu, ju Yunus pikir dia bisa lari sambunyi dari Tuhan. ");
INSERT INTO mkn_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Ma waktu itu kapal ada balayar, ju TUHAN kirim datang satu angin ribut bésar di laut. Ais laut mangamok sampe itu kapal amper mau ancor. ");
INSERT INTO mkn_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Ana bua kapal dong sandiri su taku mati. Dong satu-satu batarea minta tolong sang dong pung songgo-songgo dong. Ais ju dong angka buang itu kapal pung muatan, ko biar kapal lebe ringan. Naa, waktu ana bua kapal dong satenga mati cari jalan ko biar itu kapal jang tanggalám, na, Yunus su turun pi bawa, ju tidor sonu. ");
INSERT INTO mkn_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Ais waktu juragan dapa lia sang Yunus, dia masparak bilang, “Woeh! Lu ni, karmana? Akurang ko lu ada sonu bagitu? Paling sadiki lu bangun. Minta tolong sang lu pung songgo-songgo. Jang sampe dia yang bisa kasi tunju rasa kasian sang kotong, ko biar kotong jang ancor buang!” ");
INSERT INTO mkn_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Itu kapal pung ana bua dong baꞌomong satu deng satu bilang, “Kotong su calaka ni! Kalo kotong sonde dapa ini masala pung akar, na, pasti kotong su abis ni. Mari ko kotong hela lot ko cari tau, ini sapa pung sala.” Andia ko dong hela lot, ju Yunus yang dapa. ");
INSERT INTO mkn_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ais ju dong batanya-tanya sang Yunus bilang, “Karmana! Lu ada bekin sala apa sampe ini calaka jato kaná di kotong? Lu pung karjá apa, sampe lu nae ini kapal? Lu ni, dari mana? Lu pung asal dari mana? Lu pung orang dong, orang mana? Tolong kasi tau doo!” ");
INSERT INTO mkn_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yunus manyao bilang, “Beta ni, orang Ibrani. Beta sémba sang TUHAN Allah di langit, yang bekin ame laut deng darat samua. ");
INSERT INTO mkn_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Deng beta ada mau lari jao dari Dia.” Dengar bagitu ju, itu ana bua kapal dong tamba taku lai. Ju dong tanya sang Yunus bilang, “Akurang ko lu bekin bagitu?!” ");
INSERT INTO mkn_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Naa, itu galombang dong tamba bésar tarús. Ju itu ana bua dong tanya sang Yunus bilang, “Botong musti bekin karmana sang lu, ko biar ini laut bisa tanáng, ko botong bisa salamat?” ");
INSERT INTO mkn_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Ju Yunus manyao bilang, “Bagini. Beta su tau kalo ini angin ribut kaná sang bosong gara-gara beta. Jadi angka buang sang beta pi dalam laut sa, ko biar laut bisa tanáng kambali kasi sang bosong.” ");
INSERT INTO mkn_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Biar Yunus su usul bagitu, ma itu ana bua kapal dong coba-coba ko dayung kambali pi darat dolo. Ma sonde bisa, te itu angin ribut deng galombang tamba ganas tarús. ");
INSERT INTO mkn_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ju dong sambayang minta tolong sang Yunus pung TUHAN Allah bilang, “Tuhan! Tolong sang botong doo! Jang kasi tenga botong ancor buang tagal botong mau angka buang ini orang pi dalam laut. Andekata dia sonde parná bekin sala, ais botong bunu bekin mati sang dia, na, jang lempar itu sala pi botong. Te Tuhan yang ator ini samua, bukan botong. Jadi botong jang pikol itu sala.” ");
INSERT INTO mkn_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Sambayang abis, ju itu ana bua dong angka buang sang Yunus pi dalam laut. Tarús laut tadó memang. ");
INSERT INTO mkn_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Lia bagitu ju, itu ana bua dong taku sang TUHAN. Andia ko dong horo binatang kasi sang Tuhan, ju angka sumpa sang Dia. ");
INSERT INTO mkn_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Ma waktu dong buang sang Yunus pi dalam laut, ju TUHAN ator ko satu ikan bésar mati pung, datang kodo ame sang Yunus. Ju Yunus ada dalam itu ikan pung parú tiga siang, tiga malam. ");
INSERT INTO mkn_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Waktu Yunus masi ada di ikan pung parú, dia sambayang sang dia pung TUHAN Allah, ");
INSERT INTO mkn_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","bilang, “Waktu beta ada susa deng sangsara, beta batarea minta tolong sang TUHAN, ais Dia manyao, ko tolong sang beta. Waktu beta ada dalam ikan pung parú, itu sama ke beta ada di orang mati dong pung tampa. Ais beta pange minta tolong dari situ, ju Tuhan dengar, ko tolong sang beta. ");
INSERT INTO mkn_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Tuhan lempar buang sang beta pi tenga laut, sama ke banjer yang sapu bawa sang beta, ju galombang yang Tuhan kirim dong, hantam barmaen sang beta. ");
INSERT INTO mkn_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ais beta pikir bilang, ‘Tuhan su usir buang sang beta, ko biar sonde usa lia sang beta lai. Pasti beta sonde dapa lia, Tuhan pung ruma sambayang yang barisi lai.’ ");
INSERT INTO mkn_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Sadiki lai beta su mati, te galombang dong hantam barmaen sang beta, deng aer ada tutu ame sang beta, ju rumput laut dong feo ame beta pung kapala. ");
INSERT INTO mkn_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Beta turun tarús sampe di gunung pung kaki, yang ada di laut pung dasar. Itu sama ke beta turun pi orang mati dong pung tampa, ju dong konci mati sang beta di sana. Sonde mungkin beta bisa kaluar lai! Ma Tuhan ni, beta pung TUHAN Allah! Tuhan angka ame sang beta dari calaka di bawa, deng kasi salamat sang beta, ko biar beta jang mati! ");
INSERT INTO mkn_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Waktu beta su rasa mau putus napas, deng beta pung nyawa mau ilang buang, beta inga sang TUHAN, deng beta pung sambayang minta tolong, sampe di Bapa pung ruma sambayang yang barisi sana. ");
INSERT INTO mkn_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Samua orang yang maen songgo, sémba sang barang yang sonde ada pung guna dong. Dong bale balakang deng tola buang sang Tuhan yang suka kasi tunju hati bae sang dong, deng suka tolong orang yang bataꞌika deng Dia. ");
INSERT INTO mkn_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ma beta mau bawa korban sukur ko sémba deng angka nae lagu puji sang Tuhan! Apa yang beta su janji tu, sakarang beta mau bekin ame. Te TUHAN Allah yang ada pung kuasa, ko kasi salamat sang beta na!” ");
INSERT INTO mkn_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ais TUHAN suru itu ikan bésar ko bawa sang Yunus pi tana karíng. Ju itu ikan pi munta buang sang dia di pante. ");
INSERT INTO mkn_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ais itu, TUHAN Allah baꞌomong deng Yunus ulang lai. Dia suru bilang, ");
INSERT INTO mkn_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Sakarang lu kaluar dari sini ko pi negara Asiria pung kota bésar, andia Niniwe. Pi kasi tau sang dong samua pasán yang Beta su kasi tau sang lu.” ");
INSERT INTO mkn_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Ais Yunus bangun memang, ko pi kota Niniwe, iko TUHAN Allah pung parenta sang dia. (Naa, kota Niniwe tu, talalu bésar. Kalo orang jalan kaki dari sablá pi sablá, itu makan waktu tiga hari.) ");
INSERT INTO mkn_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Waktu Yunus su sampe di sana, dia mulai jalan kuliling dalam kota. Dia jalan satu hari anteru. Ais ju dia mulai batarea ko kasi tau orang Niniwe dong bilang, “Bosong orang Niniwe dong, dengar bae-bae! 40 hari lai, Tuhan Allah mau kasi ancor buang sang bosong deng ini kota Niniwe ni!” ");
INSERT INTO mkn_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Dengar bagitu, ju orang kota Niniwe dong parcaya Tuhan pung pasán kasi sang dong. Ais dong putus bilang, “Aduuu! Kotong su calaka ni, ma! Mari ko kotong samua puasa deng sambayang.” Jadi samua orang, kici-bésar, pake karong goni ko jadi tanda bilang, dong su manyasal deng tobat dari dong pung jahat. ");
INSERT INTO mkn_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ais waktu Niniwe pung raja dengar samua yang jadi tu, ju dia turun dari dia pung kursi parenta, ais dia buka dia pung pakean raja, ko ganti pake karong goni. Ais dia pi dudu di abu raꞌo ko kasi tunju dia pung rasa manyasal. ");
INSERT INTO mkn_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ais itu, ju raja kirim orang pi di kota Niniwe anteru ko suru dia pung rakyat datang bakumpul. Ais dia kasi tau sang dong samua bilang, “Bagini. Kotong pung idop jahat su bekin kotong calaka. Jadi beta, bosong pung raja ni, deng pegawe tinggi dong su putus bagini: samua orang musti puasa ko biar kotong bisa sambayang minta ampon. Jang makan, jang minum. Binatang dong ju bagitu. ");
INSERT INTO mkn_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Samua orang musti pake karong goni. Binatang dong ju bagitu. Deng bagitu kotong kasi tunju kotong pung rasa manyasal. Samua orang musti batarea ko minta tolong sang Tuhan dari hati yang barisi. Samua orang musti barenti kasi tenga dong pung idop bekin jahat. Samua orang musti barenti maen tendes, barenti siksa deng bekin sangsara orang laen. ");
INSERT INTO mkn_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Kalo kotong samua bekin bagitu, jang sampe Tuhan lia deng dengar sang kotong, ais Dia pung hati yang panas bisa dingin, ko biar Dia kasi tunju Dia pung rasa kasian deng sonde kasi ancor buang sang kotong!” ");
INSERT INTO mkn_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Waktu Tuhan lia kalo dong su rasa manyasal deng barenti dari idop bekin jahat bagitu, ju Dia rasa kasian, deng Dia pung hati panas jadi dingin. Ais Dia sonde kasi ancor buang sang dong. ");
INSERT INTO mkn_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ma Yunus talalu jengkel, tagal Tuhan kasi tunju rasa kasian sang orang Niniwe dong. Ju dia makan gigi sang Tuhan bagitu. ");
INSERT INTO mkn_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ais dia sambayang ko mangomel sang TUHAN Allah bilang, “Aweꞌ, Tuhan! Ini samua ni jadi parsís ke yang beta omong waktu beta masi di beta pung negrí sandiri tu. Andia ko beta mau lari jao pi Tarsis. Te beta tau bilang, Tuhan ni pung hati bae, deng suka kasi tunju rasa kasian. Tuhan sonde capát mara, ma hati ponu deng sayang kasi orang yang bataꞌika deng Dia. Tuhan sadia kasi ampon sang orang yang minta ampon, deng siap ko sonde kasi hukum orang yang su bartobat dari dong pung jahat. ");
INSERT INTO mkn_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Tuhan. Biar bunu bekin mati sang beta sakarang sa. Te ada lebe bae beta mati, ko sonde usa idop lai.” ");
INSERT INTO mkn_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ma TUHAN manyao sang Yunus bilang, “Sonde pantas kalo lu mara bagitu!” ");
INSERT INTO mkn_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jadi waktu Yunus su kasi tau abis Tuhan pung pasán kasi sang orang Niniwe dong, ju dia kaluar dari itu kota. Dia pi di kota pung sablá matahari nae, ais kasi bangun satu laak ko bisa dapa sombar. Dia dudu di situ ko mau lia Tuhan bekin karmana sang orang Niniwe dong. ");
INSERT INTO mkn_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ju TUHAN Allah kasi tumbu satu pohon malata ko biar dia pung daon kasi sombar di atas Yunus pung kapala. Deng bagitu, Yunus sonde kaná panas talalu, ais dia sanáng lia itu pohon. ");
INSERT INTO mkn_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ma dia pung beso amper siang, ju Tuhan kirim ulat datang makan buang itu pohon, ais dia mamalek buang. ");
INSERT INTO mkn_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ju waktu hari su panas, Tuhan kirim datang satu angin panas yang fuu dari sablá matahari nae. Itu panas kaná di Yunus pung kapala, sampe dia rasa tabakar ko mau samaput. Dia rasa mau mati sa. Ais dia masparak sang Tuhan bilang, “Akurang ko Tuhan sonde kasi biar beta mati?! Ada lebe bae beta mati sa. Sonde usa idop bagini lai!” ");
INSERT INTO mkn_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ju Tuhan balas sang Yunus bilang, “Lu pikir lu bisa mara tagal itu pohon malata su mati, ko? Lu pung hak apa? Lu ni, sapa?” Yunus manyao bilang, “Deng beta bagini mara ni, biar beta mati sa! Te itu yang pantas.” ");
INSERT INTO mkn_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Ma TUHAN Allah kasi tau sang Yunus bilang, “Bagini. Itu pohon muncul datang satu malam. Dia pung beso, itu pohon mamalek buang. Capát sa! Padahal lu sonde karjá apa-apa ko bekin itu pohon jadi idop. Lu sonde karjá sadiki ju ko bekin itu pohon batumbu. Biar bagitu, ma lu rasa kasian ko sonde mau itu pohon ancor buang. ");
INSERT INTO mkn_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Jadi sakarang pikir bae-bae soꞌal Beta ni. Kira-kira bae ko sonde, kalo Beta rasa kasian deng sonde mau ko itu orang Niniwe dong kaná ancor buang? Te di situ ada lebe dari 120.000 orang, tamba lai deng dong pung binatang samua. Apalai itu orang Niniwe dong sonde tau mana yang bae, deng mana yang jahat, sama ke orang yang sonde tau mana yang tangan kanan, deng mana yang tangan kiri. Andia tu!” ");
INSERT INTO mkn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","2","Ini buku carita soꞌal Yesus Kristus, itu Orang yang Tuhan Allah su janji memang dari dolu ko mau kirim datang. Dia tu, raja Daud pung turunan deng baꞌi Abraham pung turunan. Mulai dari baꞌi Abraham sampe raja Daud ada 14 turunan. Dia pung daftar nene-moyang dong, bagini: Abraham barana sang Isak, Isak barana sang Yakob, Yakob barana sang Yahuda deng dia pung adi-kaka dong, ");
INSERT INTO mkn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda barana sang Peres deng Sera (dong pung mama, nama Tamar), Peres barana sang Herson, Herson barana sang Ram, ");
INSERT INTO mkn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram barana sang Aminadab, Aminadab barana sang Nahason, Nahason barana sang Salmon, ");
INSERT INTO mkn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon barana sang Boas (dia pung mama, nama Rahab), Boas barana sang Obet (dia pung mama, nama Rut), Obet barana sang Isai, ");
INSERT INTO mkn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai barana sang Daud. ");
INSERT INTO mkn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Dari Daud sampe itu waktu yang bangsa Israꞌel kaná buang pi Babel, ada 14 turunan lai, andia: Daud barana sang Soleman (dia pung mama tu, dolu Uria pung bini). Soleman barana sang Rehabeam, Rehabeam barana sang Abia, Abia barana sang Asaf, Asaf barana sang Yosafat, Yosafat barana sang Yoram, Yoram barana sang Usia, Usia barana sang Yotam, Yotam barana sang Ahas, Ahas barana sang Heskia, Heskia barana sang Manase, Manase barana sang Amos, Amos barana sang Yosias, Yosias barana sang Yekonya deng dia pung adi dong waktu dong kaná buang pi Babel. ");
INSERT INTO mkn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Waktu dong kaná buang pi Babel sampe di Yesus, ada 14 turunan lai, andia: Yekonya barana sang Saltiel, Saltiel barana sang Serubabel, Serubabel barana sang Abihut, Abihut barana sang Elyakim, Elyakim barana sang Asor, Asor barana sang Sadok, Sadok barana sang Akim, Akim barana sang Eliut, Eliut barana sang Eliasar, Eliasar barana sang Matan, Matan barana sang Yakob, ais Yakob barana sang Yusuf. Yusuf tu, kawin deng Maria. Maria tu, yang barana sang Yesus Kristus. ");
INSERT INTO mkn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jadi mulai dari Abraham sampe Daud ada 14 turunan; dari Daud sampe dong kaná buang pi Babel ada 14 turunan; deng dari waktu kaná buang pi Babel sampe barana sang Kristus, ada 14 turunan. ");
INSERT INTO mkn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria barana sang Yesus tu, dia pung carita bagini: Maria su batunangan deng Yusuf. Dong dua balóm parná tidor bakumpul sama ke laki-bini, ma tau-tau te, Maria su dudu parú dari Tuhan Allah pung Roh yang Barisi. ");
INSERT INTO mkn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Waktu Yusuf dapa tau bagitu ju, dia mau bekin putus dong dua pung hubungan. Ma dia sonde mau bekin malu sang Maria di muka orang banya, tagal dia pung hati barisi. Andia ko dia mau bekin putus deng diam-diam sa. ");
INSERT INTO mkn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ais, waktu dia masi bapikir pi-datang, satu malam ju, dia mimpi. Dalam itu mimpi, dia dapa lia Tuhan Allah pung ana bua dari sorga datang kasi tau sang dia bilang, “We, Yusuf! Lu ni, raja Daud pung turunan. Lu jang ragu kawin ame sang Maria. Te itu Ana yang ada dalam dia pung parú tu, itu Tuhan pung Roh yang bekin. ");
INSERT INTO mkn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nanti Maria barana satu ana laki-laki. Ais lu musti kasi nama sang dia, Yesus, te Dia yang nanti kasi salamat sang Tuhan Allah pung orang dari dong pung sala-sala dong.” ");
INSERT INTO mkn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ini hal nanti jadi bagitu, tagal Tuhan Allah su kasi tau memang dari dolu. Dia parná pake Dia pung jubir Yesaya ko tulis bilang, ");
INSERT INTO mkn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Bosong dengar, ó! Nanti ada satu nona yang masi parawan, tau-tau te dia su dudu parú. Ais dia barana satu Ana laki-laki. Dong ju kasi nama sang Dia, Imanuel.” (Dalam bahasa Ibrani, ‘Imanuel’ pung arti: Tuhan Allah ada sama-sama deng kotong.) ");
INSERT INTO mkn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf mimpi abis, ju dia bangun. Tarús dia iko memang Tuhan Allah pung pasán tu. Dia ame sang Maria jadi dia pung bini, ");
INSERT INTO mkn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ma dia sonde tidor bakumpul sama ke laki-bini sampe Maria su barana abis itu Ana. Barana abis ju, Yusuf kasi nama itu Ana, Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Waktu Yesus lahir di kampong Betlehem di propinsi Yudea, raja Herodes ada pegang parenta. Itu waktu, ada barapa orang datang di kota Yerusalem dari tampa jao di sablá matahari nae. Dong tu, orang yang pintar lia bintang. ");
INSERT INTO mkn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Waktu dong sampe di Yerusalem, dong batanya pi-datang bilang, “Orang Yahudi pung raja yang baru lahir tu, ada di mana, é? Botong su dapa lia satu bintang di sablá matahari nae, yang kasi tanda bilang, Dia su lahir. Andia ko botong datang ko mau sémba sang Dia.” ");
INSERT INTO mkn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Waktu raja Herodes dengar dong pung omong bagitu, ju dia pung hati tar enak. Andia ko samua orang di Yerusalem dong ju rasa bagitu. ");
INSERT INTO mkn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ais ju raja Herodes kumpul ame kapala agama Yahudi pung bos-bos deng guru agama dong samua, ko dia tanya sang dong bilang, “Coba bosong kasi tau sang beta dolo! Itu Kristus, yang Tuhan Allah su janji memang tu, Dia mau lahir di mana, é?” ");
INSERT INTO mkn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ju dong manyao bilang, “Bapa raja. Dia lahir di kampong Betlehem, di propinsi Yudea. Te Tuhan pung jubir Mika su tulis memang dari dolu bagini: ");
INSERT INTO mkn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘We, bosong orang Betlehem, di propinsi Yudea sana. Bosong jang kira, bosong pung kampong tu, cuma satu kampong kici yang sonde ada pung arti. Te nanti ada satu orang bésar yang datang dari sana. Nanti Dia jadi gambala kasi Beta pung orang Israꞌel dong.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dengar abis bagitu ju, raja Herodes pange diam-diam itu orang yang pintar lia bintang dong. Ju dia tanya sang dong bilang, “Kapan bosong dapa lia itu bintang muncul di langit?” Ju dong kasi tau sang dia. ");
INSERT INTO mkn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ais Dia kirim sang dong pi Betlehem. Dia kasi tau bilang, “Bosong pi ko cari kuliling itu Ana di sana. Kalo bosong su katumu sang Dia, na, bale datang ko kasi tau sang beta. Te beta ju mau pi sémba sang Dia.” ");
INSERT INTO mkn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Dengar abis raja pung omong, ju dong pi. Tau-tau te, dong dapa lia lai itu bintang yang dolu dong su parná lia di sablá matahari nae tu. Itu bintang muncul di dong pung muka, ais dia jalan sampe barenti pas di atas itu Ana pung tampa tenga. ");
INSERT INTO mkn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lia bagitu ju, dong sanáng mau mati. ");
INSERT INTO mkn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ais dong maso pi dalam itu ruma, ju dong dapa lia itu Ana deng Dia pung mama Maria. Ju dong tikam lutut ko sémba sang Dia. Ais dong buka dong pung bungkusan hadia barang-barang mahal, ko kasi pi itu Ana. Dong kasi mas, kamanyán, deng dara kayu wangi. ");
INSERT INTO mkn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sonde lama, ju dong dapa mimpi dari Tuhan Allah bilang, “Bosong jang kambali pi raja Herodes lai.” Andia ko dong pulang pi dong pung negrí iko jalan laen. ");
INSERT INTO mkn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Waktu itu orang yang pintar lia bintang dong pulang, ju Tuhan pung ana bua satu dari sorga datang kasi tau sang Yusuf dalam mimpi bilang, “Usu! Bangun capát su! Angka bawa lari itu Ana deng Dia pung mama pi negrí Masir sana. Tenga tarús di situ sampe Beta kasi tau kapan bosong bole pulang, te raja Herodes ada cari ko mau bunu itu Ana!” ");
INSERT INTO mkn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ais Yusuf bangun. Ju dia bawa ame dia pung bini deng itu Ana malam-malam, ko dong lari pi negrí Masir. ");
INSERT INTO mkn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Dong tenga di sana sampe Herodes mati. Deng bagitu Tuhan Allah pung omong jadi, sama ke Dia pung jubir Hosea su kasi tau memang dari dolu bilang, “Beta pange pulang Beta pung Ana, ko kaluar dari Masir.” ");
INSERT INTO mkn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Waktu raja Herodes dapa tau bilang, itu orang yang pintar lia bintang dong su pakaneꞌo sang dia, ju dia jadi mara mau mati. Dia parenta dia pung tantara dong bilang, “Pi di kampong Betlehem deng kampong-kampong yang badeka di situ. Bunu bekin mati samua ana laki-laki kici dong, yang umur dua taon pi bawa.” Herodes parenta bagitu, tagal dia inga itu orang pintar dong pung carita. Dia itong mulai dari partama kali dong lia itu bintang muncul di langit. ");
INSERT INTO mkn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ini hal samua jadi, iko apa yang Tuhan Allah pung jubir Yeremia su tulis memang dari dolu bilang, ");
INSERT INTO mkn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ada suara orang manangis maskakeduk di kota Rama. Rahel ada manangis makarereu, tagal dia pung ana dong su mati abis. Dia sonde mau orang datang kokoe sang dia, tagal dia pung ana dong su sonde ada lai.” ");
INSERT INTO mkn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Lama-lama ju raja Herodes mati. Itu waktu Yusuf dong masi ada di Masir. Ju Tuhan Allah pung ana bua satu dari sorga, datang kasi tunju rupa sang dia dalam mimpi. ");
INSERT INTO mkn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Itu ana bua bilang, “Usu! Bangun su! Angka bawa pulang itu Ana deng dia pung mama, ko pi Israꞌel su. Te orang yang mau bunu itu Ana su mati.” ");
INSERT INTO mkn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dengar bagitu ju Yusuf bangun. Ais dia bawa pulang sang dong pi negrí Israꞌel. ");
INSERT INTO mkn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma waktu dia dapa dengar bilang, raja Herodes pung ana Arkalaus sakarang ada pegang parenta di propinsi Yudea, ju dia taku pulang pi situ. Ais Tuhan Allah parenta sang dia dalam satu mimpi lai bilang, “Yusuf, lu jang tenga di Yudea.” Andia ko dia pi tenga di propinsi Galilea, ");
INSERT INTO mkn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","di satu kampong nama Nasaret. Deng bagitu, Tuhan Allah pung omong tu, su jadi parsís, iko apa yang Dia pung jubir su tulis memang bilang, “Nanti dong pange sang Dia, Orang Nasaret.” ");
INSERT INTO mkn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Waktu Yesus su bésar, ju Yohanis Tukang Sarani mulai ajar orang di tampa sunyi, di propinsi Yudea. ");
INSERT INTO mkn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Dia kasi tau bilang, “Sodara sayang dong! Bosong musti mangaku deng kasi tenga bosong pung sala-sala, ko kambali pi Tuhan Allah su. Te sakarang, samua orang su bisa maso jadi Tuhan Allah pung orang.” ");
INSERT INTO mkn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Dolu Tuhan Allah pung jubir satu, nama Yesaya su tulis soꞌal Yohanis bilang, “Nanti ada orang yang batarea di tampa sunyi bilang, ‘Samua orang siap-siap bekin bae jalan, ko sambut Tuhan Allah pung datang! Bekin lurus jalan kasi sang Dia!’ ” ");
INSERT INTO mkn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanis ni pung cara idop sama ke Tuhan pung jubir dolu-dolu dong. Dia pung pakean, bekin dari binatang onta pung bulu. Dia pung ika pinggang, bekin dari binatang pung kulit. Dia pung makanan, kalamak deng madu utan. ");
INSERT INTO mkn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Itu waktu orang banya datang ko mau katumu deng Yohanis. Dong datang dari kota Yerusalem, deng dari anteru propinsi Yudea. Dong ju datang dari kampong-kampong yang badeka deng kali Yarden. ");
INSERT INTO mkn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dong buka hati deng mangaku dong pung sala-sala samua, ais ju Yohanis sarani sang dong di kali Yarden. ");
INSERT INTO mkn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Itu waktu, orang-orang dari partei agama Farisi deng partei agama Saduki ju datang ko minta Yohanis sarani sang dong. Ma waktu dia lia sang dong, ju dia masparak bilang, “Heh! Bosong ni sama ke ular yang tukang putar-balek! Tuhan Allah nanti hukum sang bosong tagal bosong pung bekin-bekin yang jahat dong. Weh! Jang kira bosong bisa lari kaluar dari Dia pung hukuman. ");
INSERT INTO mkn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jadi lebe bae bosong kambali pi Tuhan Allah, deng kasi tenga bosong pung sala-sala dong samua. Ais itu, bekin hal-hal yang bae, sama ke pohon yang kasi kaluar bua yang bae. ");
INSERT INTO mkn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jang kira kata bosong su aman, tagal bosong ni baꞌi Abraham pung turunan. Parcaya sang beta! Te Tuhan Allah bisa bekin ini batu dong jadi baꞌi Abraham pung turunan. ");
INSERT INTO mkn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Awas, é! Te ada Orang yang pegang kapak ko siap-siap mau potong samua pohon yang pung bua sonde bae. Potong ais, Dia lempar buang pi dalam api. ");
INSERT INTO mkn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Sakarang beta sarani sang bosong pake aer, ko jadi tanda bilang, bosong su bale balakang kasi tenga bosong pung sala-sala dong. Ma nanti satu Orang yang lebe hebat dari beta mau datang. Biar cuma jadi Dia pung tukang suru-suru sa ju, beta sonde pantas. Nanti Dia bekin ponu bosong pung hati deng Tuhan pung Roh yang Barisi. Dia ju bekin bosong jadi barisi, sama ke orang pake api ko bakar buang kotoran. ");
INSERT INTO mkn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Te Dia su pegang nyiru yang ada isi barás, ko mau tapis buang dia pung uuk. Ais Dia kasi maso itu barás pi dalam sokal. Ma itu uuk dong, Dia lempar buang pi dalam api yang manyala sonde tau abis-abis.” ");
INSERT INTO mkn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Itu waktu, Yesus turun datang dari Galilea pi kali Yarden. Dia datang minta Yohanis sarani sang Dia, ");
INSERT INTO mkn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ma Yohanis sonde mau. Dia protes bilang, “Karmana ko beta musti sarani sang Bos? Sonde tabale ni, ko? Bos ni yang musti sarani sang beta. Te itu yang beta parlú na!” ");
INSERT INTO mkn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Yesus manyao bilang, “Aman sa. Ma buat sakarang, biar bu yang sarani sang Beta sa. Deng bagitu kotong iko Tuhan Allah pung mau.” Dengar bagitu ju Yohanis manyao bilang, “Dari-dari sa, Bos.” Ju dia sarani sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sarani abis, ju Yesus kaluar dari kali. Ma takuju sa, ju langit tabuka. Ais Dia dapa lia Tuhan Allah pung Roh turun datang pi sang Dia, sama ke burung pompa datang hinggap di Dia. ");
INSERT INTO mkn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ais dong dapa dengar Tuhan Allah pung suara dari langit bilang, “Ini Dia, Beta pung Ana sayang. Dia salalu bekin sanáng sang Beta.” ");
INSERT INTO mkn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ais itu, Tuhan Allah pung Roh antar bawa sang Yesus pi tampa sunyi, ko biar setan dong pung bos bésar goda sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ju Dia puasa 40 siang 40 malam di situ. Ais itu ju, Dia lapar mati pung. ");
INSERT INTO mkn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Waktu Dia su lapar bagitu, ju setan dong pung bos bésar datang goda sang Dia bilang, “Lu ni, batúl-batúl Tuhan Allah pung Ana, ko? Kalo batúl, na, parenta ini batu dong ko jadi makanan su.” ");
INSERT INTO mkn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma Yesus manyao bilang, “Ada tatulis dalam Tuhan Allah pung Tulisan Barisi bilang: ‘Manusia sonde idop dari makanan sa. Ma dong ju musti dengar Tuhan Allah pung Kata-kata, deng bekin iko Dia pung mau.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tarús, itu setan bawa sang Yesus pi kota Yerusalem, andia Tuhan pung kota barisi. Ais dia bawa nae sang Yesus pi atas Ruma Sambayang Pusat pung tampa yang paling tinggi. ");
INSERT INTO mkn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ju itu setan bilang, “Kalo Lu memang batúl-batúl Tuhan Allah pung Ana, na, coba Lu malompa turun pi bawa su. Te ada tatulis di Tuhan Allah pung Tulisan Barisi bilang, ‘Nanti Tuhan Allah parenta Dia pung ana bua dari sorga dong, ko jaga sang Lu.’ Di Tuhan Allah pung Tulisan Barisi ju ada tulis bilang, ‘Nanti dong tada ame Lu deng dong pung tangan, ko biar Lu pung badan sonde saki, deng Lu sonde sonto batu ju.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma Yesus manyao bilang, “Ada tatulis ju dalam Tuhan Allah pung Tulisan Barisi bilang, ‘Tuhan Allah tu, yang hak parenta sang lu. Andia ko lu jang coba sang Dia.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tarús, itu setan bawa sang Yesus pi atas satu gunung yang talalu tinggi. Ju dia kasi tunju samua negrí di dunya, deng dong pung hebat samua. ");
INSERT INTO mkn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kasi tunju abis itu samua, ju itu setan kasi tau bilang, “Asal Lu tikam lutut ko sémba sang beta, nanti beta kasi itu samua-samua pi di Lu.” ");
INSERT INTO mkn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma Yesus masparak bilang, “Heh, setan! Lu iskarobis dari sini su! Te Tuhan Allah pung Tulisan Barisi ada bilang, ‘Lu musti sémba sang Tuhan Allah, deng lu musti karjá kasi sang Dia sa.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dengar bagitu, ju itu setan angka kaki kasi tenga sang Yesus. Ju Tuhan Allah pung ana bua dari sorga dong datang ko urus sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Itu waktu, raja Herodes kasi maso Yohanis Tukang Sarani dalam bui. Waktu Yesus dapa dengar bagitu, ju Dia pulang pi Galilea. ");
INSERT INTO mkn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Dia pi Dia pung kampong Nasaret, ais Dia jalan tarús ko pi tenga di kampong Kapernaum. Itu kampong ada di dano Galilea pung pinggir, di Sebulon deng Naftali pung tana. ");
INSERT INTO mkn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Deng bagitu, Dia bekin iko apa yang Tuhan Allah pung jubir Yesaya su tulis memang bilang, ");
INSERT INTO mkn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Di Sebulon pung tana, deng Naftali pung tana, yang deka di dano Galilea, di kali Yarden pung sablá, orang yang bukan orang Yahudi ada tenga di situ ju. ");
INSERT INTO mkn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dong ada idop dalam galáp, ma sakarang dong su dapa lia Taráng. Te Taráng su basinar kasi samua orang yang balóm kanál sang Tuhan Allah.” ");
INSERT INTO mkn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mulai dari itu waktu, ju Yesus mulai ajar orang bilang, “Bosong musti bale balakang deng kasi tenga bosong pung sala-sala dong, ko idop barisi su! Te sakarang samua orang su bisa maso jadi Tuhan Allah pung orang.” ");
INSERT INTO mkn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Satu hari, Yesus ada jalan iko dano Galilea pung pinggir. Dia nae katumu dua orang adi-kaka. Yang satu nama Simon, ma orang biasa pange sang dia, Petrus. Deng dia pung adi nama Anderias. Dong ada jala ikan di dano, tagal dong dua tu, nalayan. ");
INSERT INTO mkn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ju Yesus pange sang dong bilang, “We, mari ko iko sang Beta su! Bosong biasa cari ikan, ma sakarang Beta mau ajar sang bosong, ko bosong jadi tukang cari jiwa.” ");
INSERT INTO mkn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dengar abis bagitu, ju dong dua kasi tenga dong pung jala, ko iko memang sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ais itu, Yesus dong jalan tarús sadiki lai, ju Dia dapa lia Sabadeus pung ana. Yang kaka pung nama Yakobis, deng dia pung adi nama Yohanis. Dong dua ada ator bekin bae pukat dalam parahu sama-sama deng dong pung bapa. Ju Yesus pange sang dong dua ko iko sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dengar bagitu, ju dong jalan kasi tenga dong pung bapa deng dong pung parahu, ko dong iko memang sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ais itu, Yesus dong bajalan kuliling propinsi Galilea, ko Dia ajar di orang Yahudi pung ruma sambayang dong. Dia ajar soꞌal Tuhan Allah pung Kabar Bae, deng kasi tau cara karmana ko orang bisa iko Tuhan Allah pung parenta. Dia ju bekin bae samua orang dari dong pung panyaki macam-macam. ");
INSERT INTO mkn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sonde lama, ju kabar soꞌal Yesus tu, tasiar kuliling sampe di anteru propinsi Siria. Ais ju orang bawa datang dong pung orang saki macam-macam pi sang Dia. Dong ju bawa orang yang takaná setan, yang gila kambing, deng yang lumpu. Ju Dia bekin bae dong samua. ");
INSERT INTO mkn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Itu waktu, orang bam-banya datang iko sang Dia. Dong datang dari propinsi Galilea, deng dari daꞌera Sapulu Kota, yang dong subu bilang, Dekapolis. Ada laen lai yang datang dari kota Yerusalem, dari propinsi Yudea, deng dari kali Yarden pung sablá. ");
INSERT INTO mkn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Waktu Yesus dapa lia orang bam-banya datang iko sang Dia, ju Dia nae pi satu gunung kici, ko dudu di situ. Dia pung ana bua dong yang Dia su pili tu, datang deka-deka ko dengar sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ais Dia mulai ajar sang dong bilang, ");
INSERT INTO mkn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Orang kasian dong ontong, tagal Tuhan Allah sandiri, dong pung Raja yang bae. ");
INSERT INTO mkn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Orang yang rasa dukacita dong ontong, tagal Tuhan Allah sandiri yang kokoe sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Orang kici dong ontong, tagal nanti dong tarima samua berkat yang Tuhan Allah su janji. ");
INSERT INTO mkn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Orang yang talalu rindu sang Tuhan Allah pung jalan lurus dong, ontong, tagal nanti Dia bekin puas sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Orang yang kasi tunju rasa kasian dong ontong, tagal nanti Tuhan Allah ju jato kasian sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Orang yang pung hati barisi dong ontong, tagal nanti dong sandiri dapa lia Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Orang yang tukang bekin dame dong ontong, tagal nanti Tuhan Allah bilang, ‘Dong tu, Beta pung ana.’ ");
INSERT INTO mkn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Orang yang kaná siksa tagal iko sang Tuhan Allah dong ontong, tagal Tuhan sandiri tu, dong pung Raja yang bae. ");
INSERT INTO mkn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kalo orang laen bekin sangsara sang bosong tagal bosong iko sang Beta, bosong ju ontong. Kalo dong omong jahat sang bosong, deng bacarita putar-balek bekin busuk bosong pung nama, bosong ju ontong. ");
INSERT INTO mkn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Biar bagitu, ma bosong musti bekin diri sanáng deng hati babunga sa, tagal Tuhan Allah su sadia balas kasi bosong pung bagian, satu malꞌunuk di sorga. Ma inga, é! Bukan cuma bosong sa yang dapa sangsara bagitu, te dolu-dolu orang dong ju bekin jahat bagitu sang Tuhan Allah pung jubir dong.” ");
INSERT INTO mkn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kalo kotong mau bekin enak makanan, na, kotong parlú taro garam dolo. Bagitu ju orang yang idop di ini dunya, dong parlú sang bosong. Ma kalo garam su jadi tawar, na, dia pung guna apa? Cuma angka buang di jalan ko kaná inja sa. ");
INSERT INTO mkn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Bosong ju musti idop sama ke lampu, ko biar orang banya dapa lia deng bae-bae. Bosong musti manyala taráng-taráng, sama ke kota yang ada di atas gunung, yang samua orang dapa lia. ");
INSERT INTO mkn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Orang yang kasi manyala lampu teꞌoek, sonde kasi maso itu lampu pi dalam pareu tana. Ma dong taro itu lampu di tampa tinggi, ko bisa bekin taráng ruma pung isi samua. ");
INSERT INTO mkn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bosong ju musti idop bagitu. Bosong musti bacaya, ko biar orang laen dong dapa lia bosong pung idop yang bae. Deng lia bagitu nanti dong puji sang Tuhan Allah bilang, ‘Awii! Bosong pung Bapa di sorga tu, talalu hebat, ó!’ ” ");
INSERT INTO mkn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Bosong jang pikir kata, Beta datang di ini dunya, ko mau hapus buang Tuhan Allah pung atoran yang Dia kasi sang baꞌi Musa. Deng jang kira Beta sonde toe deng apa yang Tuhan Allah pung jubir dong su omong memang dari dolu. Te Beta datang ni, mau bekin samua jadi parsís sama ke samua hal yang dong su omong memang. ");
INSERT INTO mkn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tagal itu, dengar bae-bae, é! Langit deng bumi balóm bisa ancor buang, kalo samua balóm jadi, iko Tuhan Allah pung atoran dong. Biar satu titi ko koma ju, sonde ada yang bisa tahapus buang. ");
INSERT INTO mkn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dari Tuhan pung orang dong samua, kalo ada yang langgar Tuhan pung atoran, tagal dia pikir bilang, ‘Hee! Ini atoran ni, kici sa, sonde ada pung guna apa-apa!’ Ais dia ajar bagitu kasi orang laen, nanti Tuhan Allah di sorga bekin dia jadi orang kici sa. Ma orang yang bekin iko Tuhan Allah pung atoran samua, ais dia ajar bagitu kasi orang laen, nanti Tuhan Allah bekin dia jadi orang yang ada pung guna. ");
INSERT INTO mkn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Parcaya sang Beta! Kalo bosong sonde idop lurus lebe bae dari itu guru agama deng orang partei Farisi dong, na, bosong sonde bisa maso jadi Tuhan Allah pung orang.” ");
INSERT INTO mkn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bosong su tau baꞌi Musa pung atoran yang dia kasi tau memang sang kotong pung nene-moyang bilang, ‘Jang bunu orang, te sapa yang bunu orang, nanti dia kaná hukum.’ ");
INSERT INTO mkn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma Beta mau kasi tau bagini: jang bamara, te sapa yang mara sang dia pung sodara, nanti dia kaná hukum. Orang yang maruak sang dia pung sodara bilang, ‘Lu otak kea!’ nanti itu orang musti mangada di muka tua-tua agama dong. Deng orang yang masparak sang dia pung sodara bilang, ‘Bodo, é!’, nanti dia kaná hukum di api naraka. ");
INSERT INTO mkn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jadi, kalo lu ada bawa persembahan kasi sang Tuhan Allah, ma lu inga bilang, ada sodara yang masi mara sang lu, ");
INSERT INTO mkn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na, jang taro itu persembahan dolo. Lu pi badame deng lu pung sodara dolo, ais itu baru lu pi taro itu persembahan kasi sang Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kalo ada orang yang mau bekin parkara deng lu, na, lebe bae lu pi urus dame capát-capát deng dia dolo. Kalo sonde, nanti itu orang hela bawa sang lu pi mangada di hakim. Ais hakim sarakan sang lu pi di polisi, ju dong sese maso sang lu pi dalam bui. ");
INSERT INTO mkn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Beta omong batúl ni! Nanti lu tenga tarús dalam bui sampe bayar abis lu pung utang samua.” ");
INSERT INTO mkn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Bosong su tau baꞌi Musa pung atoran yang bilang, ‘Jang maen serong.’ ");
INSERT INTO mkn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma Beta mau kasi tau bagini: orang yang angka mata ko lia satu parampuan, ais dia pung hati kapingin tidor bakumpul deng dia, na, itu laki-laki su maen serong deng itu parampuan dalam dia pung hati. ");
INSERT INTO mkn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kalo lu bekin sala pake lu pung mata kanan, na, doꞌi buang sang dia sa. Te lebe bae lu maso pi dalam sorga deng lu pung mata satu sa, ko biar dong jang lempar buang sang lu pi api naraka deng lu pung mata biji dua-dua. ");
INSERT INTO mkn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Deng kalo lu bekin sala pake lu pung tangan kanan, na, potong buang itu tangan sa. Te lebe bae lu maso pi dalam sorga deng lu pung tangan sablá sa, ko biar dong jang lempar buang sang lu pi api naraka deng lu pung tangan dua-dua.” ");
INSERT INTO mkn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bosong su tau baꞌi Musa pung atoran bilang, ‘Orang yang cere buang dia pung bini, na, dia musti kasi surat cere sang itu parampuan.’ ");
INSERT INTO mkn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma Beta kasi tau bagini: kalo ada orang yang cere buang dia pung bini, padahal dia pung bini sonde parná maen serong, ais, itu parampuan kawin ulang, na, itu sama deng dia pung laki partama bekin dia barsina. Deng kalo ada laki-laki yang kawin ame sang satu parampuan yang parná kaná cere buang, na, dong dua su barsina ju.” ");
INSERT INTO mkn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Bosong su tau baꞌi Musa pung atoran yang dia kasi tau sang kotong pung nene-moyang dong bilang, ‘Kalo lu angka janji pake sumpa deng Tuhan Allah pung nama, na, lu su taꞌika deng itu janji.’ ");
INSERT INTO mkn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma Beta kasi tau bagini: kalo lu angka janji, na, jang pake sumpa. Jang sumpa pake sorga pung nama, tagal sorga tu, Tuhan Allah pung tampa tenga. ");
INSERT INTO mkn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jang sumpa pake bumi pung nama, tagal bumi tu Tuhan Allah pung alas kaki. Deng jang sumpa pake Yerusalem pung nama, tagal Yerusalem tu, Raja Bésar pung kota. ");
INSERT INTO mkn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jang sumpa deng bosong pung kapala. Te bosong sonde ada pung kuasa ko parenta rambu satu daon ko jadi itam ko puti. ");
INSERT INTO mkn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jadi kalo bosong mau angka janji bilang, ‘hoo’, na, kasi tau bilang, ‘hoo’ sa. Ma kalo sonde, na, bilang ‘sonde’ sa. Kalo bosong bilang lebe dari itu, na, itu su baꞌakar dari setan.” ");
INSERT INTO mkn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Bosong su tau baꞌi Musa pung atoran bilang, ‘Kalo ada orang bekin rusak lu pung mata, na, balas bekin rusak dia pung mata. Deng kalo ada orang bekin rubu lu pung gigi, na, balas bekin rubu dia pung gigi ju.’ ");
INSERT INTO mkn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma Beta kasi tau bagini: jang balas jahat deng jahat. Kalo orang tampeleng lu pung pipi sablá, na, kasi tenga ko dia tampeleng pipi yang laen lai. ");
INSERT INTO mkn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kalo ada orang yang mau bekin parkara deng lu, ko mau ame lu pung baju, na, kasi pi lu pung baju panas lai. ");
INSERT INTO mkn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kalo ada tantara satu paksa sang lu, ko jalan pikol bawa dia pung barang satu kilometer, na, pikol bawa tarús sampe dua kilometer. ");
INSERT INTO mkn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kalo ada orang minta lu pung barang apa, na, kasi pi sa. Deng kalo ada orang yang mau pinjam lu pung barang apa, na, kasi pi sa.” ");
INSERT INTO mkn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Bosong su dengar orang bilang, ‘Sayang sang lu pung sodara, deng binci orang yang binci sang lu.’ ");
INSERT INTO mkn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma Beta kasi tau bagini: lu musti sayang sang orang yang binci sang lu. Deng minta ko Tuhan kasi berkat sang orang yang bekin sangsara sang lu. ");
INSERT INTO mkn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kalo lu bekin bagitu, na, lu kasi tunju bilang, lu ni Bapa di sorga pung ana. Tagal Dia bekin matahari basinar kasi orang bae, deng Dia ju bekin matahari basinar kasi orang jahat. Dia ju kasi turun ujan kasi orang yang bekin iko Dia pung parenta sama-sama deng orang yang malawan Dia pung parenta. ");
INSERT INTO mkn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jadi, kalo lu cuma sayang sang orang yang sayang sang lu, na, lu kira Tuhan Allah musti balas deng berkat kasi sang lu, ko? Sonde! Te orang jahat ju sayang dong pung tamán yang sayang sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jadi, kalo lu cuma kasi saloom sang lu pung tamán, na, dia pung lebe apa? Te orang yang sonde parcaya sang Tuhan Allah ju bekin bagitu. ");
INSERT INTO mkn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jadi inga, é! Lu pung Bapa di sorga sayang samua orang. Jadi lu ju musti bekin iko bagitu!” ");
INSERT INTO mkn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus ajar tarús bilang, “Inga, é! Jang iko-iko agama pung atoran ko biar orang puji-puji sang bosong. Te kalo bosong bekin bagitu, na, bosong pung Bapa di sorga sonde akan kasi bosong pung upa apa-apa. ");
INSERT INTO mkn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kalo bosong mau tolong orang kasian dong, na, jang pi badodol di mana-mana. Te kalo bosong bekin bagitu, na, bosong su sama ke orang yang omong laen bekin laen. Dong suka pasiar pi ruma sambayang ko biar orang puji sang dong bilang, ‘Awii, ini orang ni, hebat mati, ó!’ Beta omong yang batúl! Deng makan puji bagitu, dong su tarima abis dong pung upa. ");
INSERT INTO mkn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Jadi, kalo bosong mau tolong orang kasian dong, na, jang kasi tau sapa-sapa, é! ");
INSERT INTO mkn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Deng bagitu, orang di ini dunya sonde tau. Ma bosong pung Bapa di sorga yang tau apa yang bosong bekin diam-diam tu. Nanti Dia balas sang bosong deng berkat bam-banya.” ");
INSERT INTO mkn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Waktu bosong sambayang, na, jang bekin diri sama ke orang yang omong laen bekin laen. Dong suka pi pasiar di jalan rame, deng badiri di dalam ruma sambayang, ko biar orang banya lia deng puji-puji sang dong bilang, ‘Awii! Dong ni, orang barisi, ó!’ Ma dengar, é! Deng makan puji bagitu, dong su tarima abis dong pung upa. ");
INSERT INTO mkn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma bosong sonde bole bagitu. Kalo bosong sambayang, na, maso pi dalam kamar ko tutu pintu. Ais sambayang diam-diam pi sang bosong pung Bapa. Biar orang laen sonde lia, ma bosong pung Bapa yang lia. Nanti Dia balas kasi sang bosong deng berkat bam-banya. ");
INSERT INTO mkn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kalo bosong sambayang, na, jang omong bataputar pi-datang. Te orang yang sonde kanál sang Tuhan Allah ju bisa sambayang bagitu. Dong pikir kata, Tuhan Allah suka dengar dong pung sambayang yang panjang lalolak tu. ");
INSERT INTO mkn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jang bekin iko sama ke dong, é! Te biar bosong balóm minta apa-apa sang Bapa di sorga, ma Dia su tau memang apa yang bosong parlú. ");
INSERT INTO mkn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jadi, kalo sambayang, na, pake conto bagini: ‘Bapa di sorga! Bapa pung nama paling barisi. Biar samua orang angka nae tinggi-tinggi Bapa pung nama yang hebat. ");
INSERT INTO mkn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Biar Bapa jadi Raja kasi samua orang! Biar samua orang bekin iko Bapa pung parenta di ini dunya, sama ke Bapa pung ana bua dong bekin iko Bapa pung parenta di sorga. ");
INSERT INTO mkn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bapa tolong kasi sang botong makanan yang cukup tiap hari. ");
INSERT INTO mkn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Botong minta Bapa hapus buang botong pung sala-sala dong, sama ke botong ju lupa buang orang pung sala yang dong bekin sang botong. ");
INSERT INTO mkn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bapa, jaga ko botong sonde bekin jahat. Deng kasi salamat sang botong, dari setan pung kuasa. Te Bapa tu, Raja yang paling kuasa deng paling hebat. Bapa yang pegang parenta tarús-tarús. Botong pung sambayang, bagitu sa Bapa. Amin.’ ");
INSERT INTO mkn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ma dengar, é! Kalo bosong lupa buang orang pung sala sang bosong, nanti bosong pung Bapa di sorga ju hapus buang bosong pung sala-sala dong. ");
INSERT INTO mkn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma kalo bosong sonde mau lupa buang orang pung sala sang bosong, nanti bosong pung Bapa ju sonde lupa bosong pung sala-sala dong.” ");
INSERT INTO mkn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kalo bosong sambayang deng puasa, na, jang bekin muka masnanaꞌok sama ke orang yang omong laen bekin laen. Te dong bekin bagitu ko biar orang puji sang dong bilang, ‘Awii! Dong ni, orang barisi, ó!’ Ma dengar, é! Deng makan puji bagitu, dong su tarima abis dong pung upa. ");
INSERT INTO mkn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma kalo bosong puasa, na, cuci bosong pung muka barisi-barisi, deng sisir rambu bae-bae! ");
INSERT INTO mkn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jadi nanti orang lia sang bosong, dong sonde tau bilang, bosong ada puasa. Ma bosong pung Bapa yang tau. Nanti Dia balas kasi sang bosong deng berkat bam-banya.” ");
INSERT INTO mkn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Jang karjá karás ko kumpul harta bam-banya di ini dunya. Te fufuk deng karat nanti bekin rusak sang dong. Deng pancuri ju datang bongkar ko angka bawa. ");
INSERT INTO mkn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma lebe bae bosong karjá karás ko kumpul harta bam-banya di sorga. Te di sana fufuk deng karat sonde bisa bekin rusak. Deng pancuri ju sonde bisa datang bongkar ko angka bawa. ");
INSERT INTO mkn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bosong simpan bosong pung harta di mana, pasti bosong pung hati ju makaditi di sana.” ");
INSERT INTO mkn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Orang pung mata, sama ke lampu yang bekin taráng dia pung dalam hati. Kalo dia pung mata taráng, na, dia iko jalan idop yang bae, sama ke orang yang jalan dalam taráng. ");
INSERT INTO mkn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma kalo dia pung mata kabur, na, dia sonde iko jalan yang bae, sama ke orang yang jalan raba-raba dalam galáp. Jadi, kalo itu taráng yang ada di bosong pung hati su jadi galáp, na, bosong ju idop dalam galáp.” ");
INSERT INTO mkn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Orang sonde bisa karjá batúl-batúl kasi dua bos, tagal dia nanti suka sang bos yang satu, lebe dari bos yang laen. Bisa ju dia iko bos yang satu, ma dia sonde toe deng bos yang laen. Tagal itu, lu sonde bisa bilang, ‘Tuhan tu, yang hak parenta sang beta,’ kalo lu su bekin doi jadi lu pung bos. ");
INSERT INTO mkn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Andia ko Beta kasi tau bagini: jang repot deng bapikir, beta mau idop karmana, beta mau makan apa, minum apa, pake apa? Bosong kira idop tu, cuma buat makan sa? Deng badan tu, cuma buat pake baju sa? Bukan bagitu. ");
INSERT INTO mkn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Coba lia itu burung yang tarbáng di udara dong. Dong sonde repot batanam deng bakoru ko simpan makanan dalam gudang. Ma bosong pung Bapa di sorga piara sang dong tarús. Dia ju tantu bisa piara sang bosong lebe dari ini lai. Jadi pikir bae-bae dolo. Te Dia nilei bosong lebe dari itu burung dong. ");
INSERT INTO mkn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kalo orang badiri di muka carmín, ais dia repot deng dia pung diri, dia bisa bekin tamba tinggi dia pung badan, ko? Sonde bisa! ");
INSERT INTO mkn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kalo sonde, na, akurang ko bosong barepot ko pikir-pikir soꞌal pakean lai? Pi lia coba itu bunga bakung di padang. Dong sonde putar banáng, deng sonde tanún kaen. ");
INSERT INTO mkn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma dengar bae-bae, ó! Raja Soleman pung pakean yang paling mewa ju, sonde bisa lawan itu bunga dong pung bagus. ");
INSERT INTO mkn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Te Tuhan Allah taro hati di bunga yang cuma idop ini hari, ais beso mati ko orang buang pi dalam api. Kalo Dia bekin bagitu, Dia ju pasti kasi pake sang bosong lebe dari itu bunga dong. Jadi, akurang ko bosong sonde parcaya batúl-batúl sang Dia? ");
INSERT INTO mkn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jadi sonde usa repot bapikir bilang, ‘Botong mau makan apa?’ ko, ‘Botong mau minum apa?’ ko, ‘Botong mau pake apa?’ ");
INSERT INTO mkn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Orang yang sonde parcaya sang Tuhan Allah, dong banting tulang ko mau coba dapa itu hal samua. Ma bosong jang bagitu, te bosong pung Bapa di sorga su tau samua yang bosong parlú. ");
INSERT INTO mkn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ma bosong musti kasi jalan Dia pung karjá dolo, deng musti iko Dia pung parenta dolo, ais nanti Dia kasi tamba samua hal yang bosong parlú. ");
INSERT INTO mkn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jadi jang repot bapikir deng apa yang bosong parlú beso. Te beso ada dia pung repot laen lai. Ini hari pung susa su cukup.” ");
INSERT INTO mkn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Bosong jang tudu orang, ko biar Tuhan jang tudu sang bosong. ");
INSERT INTO mkn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bosong nilei orang karmana, na, nanti Tuhan Allah nilei sang bosong bagitu ju. Bosong ukur orang laen pung sala karmana, nanti Tuhan Allah ukur sang bosong bagitu ju. ");
INSERT INTO mkn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Te lu suka tanda orang pung sala kici ana sa, ma lu pung sala yang bésar, lu anggap ke sonde ada sa. Itu sama ke lu lia abu satu titik di lu pung tamán pung mata. Padahal ada balok bésar pele lu pung mata, ma lu sonde rasa. ");
INSERT INTO mkn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Karmana ko lu barani omong bilang, ‘Konco! Mari ko beta tolong lap kasi kaluar itu abu dari lu pung mata biji dolo.’ Padahal lu sandiri sonde bisa lia apa-apa, te ada balok pele lu pung mata na. ");
INSERT INTO mkn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Woi! Dasar lu tu, orang muka-balakang batúl! Tolong doo! Angka buang itu balok dari lu pung mata sandiri dolo, baru lu bisa lia, ko tolong lap buang abu sapoꞌong ana dari lu pung kawan pung mata. ");
INSERT INTO mkn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jang ajar hal barisi soꞌal Tuhan, kasi tukang baꞌolok. Tagal dong tu, sama ke anjing jahat yang nanti bale datang ko saráng sang bosong. Dong ju bodo sama ke babi. Kalo orang kasi kalong mutiara yang mahal, na, dia sonde toe! Te dia cuma tau inja-inja sa.” ");
INSERT INTO mkn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kalo bosong sambayang, minta tarús sang Tuhan; nanti Dia kasi. Kalo cari tarús; nanti Dia kasi tunju jalan. Kalo eki tarús; nanti Dia buka pintu. ");
INSERT INTO mkn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Te samua orang yang minta tarús sang Tuhan, nanti tarima. Yang cari tarús, nanti dapa. Yang eki tarús, nanti Dia buka pintu. ");
INSERT INTO mkn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bosong pikir coba! Kalo ada ana yang minta roti, tantu dia pung bapa sonde kasi batu, wuang? ");
INSERT INTO mkn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ko, kalo ana minta ikan, bapa sonde kasi ular! ");
INSERT INTO mkn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bosong pung Bapa di sorga tu, memang bae batúl. Jadi kalo manusia yang jahat macam bosong sa, suka kasi barang yang bae sang bosong pung ana dong, apalai bosong pung Bapa! Dia tantu kasi apa yang bosong minta. ");
INSERT INTO mkn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jadi, apa yang lu mau orang laen bekin kasi sang lu, na, lu musti bekin bagitu kasi sang dia ju. Tagal ini ni, dasar dari samua yang baꞌi Musa deng Tuhan Allah pung jubir laen dong su ajar memang dari dolu.” ");
INSERT INTO mkn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kalo orang mau maso sorga, na, dia musti jalan lewat pintu yang sampít. Te ada jalan yang gampang deng pintu yang lebar ju, yang orang banya dong suka lewat. Ma awas, ó! Te jalan bagitu yang bawa orang pi naraka, ko dong tapisa buang dari Tuhan. ");
INSERT INTO mkn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Orang yang mau maso sorga musti iko itu jalan yang susa, deng maso itu pintu yang sampít. Te biar cuma sadiki orang sa yang jalan di situ, ma jalan sampít bagitu yang bawa orang pi Tuhan.” ");
INSERT INTO mkn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ati-ati deng tukang tipu yang angka diri bilang, dong tu Tuhan pung jubir. Te dong bekin diri pura-pura bae sama ke domba. Padahal dong tu jahat, sama ke anjing utan yang datang makan domba. ");
INSERT INTO mkn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Karmana bosong bisa kanál orang yang pura-pura? Lia sa dari apa yang dong bekin. Sama ke orang lia bua, ko kanál itu bua pung pohon. Bua yang bae, sonde kaluar dari pohon yang sonde bae. ");
INSERT INTO mkn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Te pohon yang bae kasi kaluar bua yang bae. Ma pohon yang sonde bae, kasi kaluar bua yang sonde bae. ");
INSERT INTO mkn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sonde ada pohon yang bae yang kasi kaluar bua yang sonde bae. Deng sonde ada pohon yang sonde bae yang kasi kaluar bua yang bae. ");
INSERT INTO mkn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pohon yang kasi kaluar bua yang sonde bae, tantu dong datang potong ko lempar buang maso pi dalam api. ");
INSERT INTO mkn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bagitu ju deng itu jubir pura-pura dong. Bosong bisa kanál sang dong dari dong pung bekin-bekin.” ");
INSERT INTO mkn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nanti ada orang yang pange sang Beta bilang, ‘Bos!’, andia yang hak parenta sang dong. Ma dong tu cuma subu di bibir sa. Nanti Tuhan Allah di sorga tola buang sang dong. Te cuma orang yang iko batúl-batúl Dia pung mau sa, yang Dia tarima ame jadi Dia pung orang. ");
INSERT INTO mkn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nanti waktu hari kiamat, banya orang mangaku bilang, Beta ni yang hak parenta sang dong. Dong kokoe sang Beta bilang, ‘Bos, é! Botong su pi kasi tasiar Bos pung ajaran. Botong ju usir setan dong pake Bos pung nama. Deng botong bekin tanda heran macam-macam pake Bos pung kuasa.’ ");
INSERT INTO mkn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Biar dong maen kokoe sang Beta bagitu ju, ma nanti Beta kasi tau dong bilang, ‘Bosong ni, sapa? Beta sonde kanál sang bosong, te bosong sonde idop iko Tuhan pung mau. Jadi iskarobis dari sini su!’ ” ");
INSERT INTO mkn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Orang yang datang dengar sang Beta, ais bekin iko Beta pung omong, dia sama ke orang yang pintar, yang kasi badiri dia pung ruma di atas fanderen batu. ");
INSERT INTO mkn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lama-lama ju ujan bésar turun sampe banjer datang. Angin kincang ju datang hantam itu ruma. Ma itu ruma sonde rubu, tagal dia badiri di atas fanderen batu yang kuat. ");
INSERT INTO mkn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Orang yang datang dengar sang Beta, ma dia sonde bekin iko Beta pung omong, dia sama ke orang bodo yang kasi badiri dia pung ruma di atas pasir. ");
INSERT INTO mkn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lama-lama ju ujan bésar turun sampe banjer datang. Angin kincang ju datang hantam itu ruma. Ju itu ruma rubu buang sampe ancor-ancor.” ");
INSERT INTO mkn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus omong abis bagitu, ju samua orang dong taheran-heran dengar Dia pung ajaran, ");
INSERT INTO mkn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","te Dia tau batúl-batúl itu ajaran pung isi. Dia pung cara ajar tu, sonde sama deng dong pung guru agama dong. ");
INSERT INTO mkn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus turun datang dari gunung, ju orang banya dong rame-rame pi iko sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Takuju sa, ada satu orang panyaki kusta datang mangada sang Dia. Dia tikam lutut ko minta tolong sang Yesus bilang, “Bos, é! Tolong sang beta dolo! Kalo mau, na, Bos bisa kasi ilang beta pung panyaki ni, ko biar orang jang noju sang beta lai, ju beta bisa sambayang lai dalam ruma ibadat.” ");
INSERT INTO mkn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dengar bagitu, ju Yesus sorong tangan, ais sonto itu orang kusta, deng omong bilang, “Beta mau sa! Lu bae su!” Takuju sa, itu orang pung panyaki ilang memang. ");
INSERT INTO mkn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ais Yesus kasi tau sang dia bilang, “Inga, é! Lu su bae, ma sonde bole kasi tau sapa-sapa. Lu musti iko baꞌi Musa pung atoran dolo. Jadi pi di kapala agama, ko dia pareksa lu pung badan, biar dia tau lu pung panyaki su ilang batúl, ko sonde. Ais lu musti kasi persembahan tanda tarima kasi, ko orang samua tau bilang, lu su bae batúl.” ");
INSERT INTO mkn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ais itu, ju Yesus maso pi kampong Kapernaum. Di situ ada satu komandán tantara Roma yang datang ko mau minta tolong bilang, ");
INSERT INTO mkn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bos, é! Beta pung ana karjá satu ada saki barát di ruma. Dia sonde bisa bangun dari koi, te dia ada sangsara mau mati.” ");
INSERT INTO mkn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus manyao bilang, “Bae! Nanti Beta pi ko bekin bae sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma itu komandán bilang, “Bos! Sonde usa cape-cape pi lai, te beta sonde pantas tarima sang Bos di beta pung ruma. Asal Bos omong sa dari sini, beta pung ana karjá tu, pasti bae memang. ");
INSERT INTO mkn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Beta mangarti ini hal, tagal beta pung bos dong ada pung kuasa ko parenta sang beta. Deng beta ju ada pung kuasa ko parenta beta pung tantara dong. Kalo beta kasi parenta beta pung ana bua bilang, ‘Pi sana!’ pasti dia pi. Kalo beta bilang, ‘Datang sini!’ pasti dia datang. Deng kalo beta suru beta pung orang karjá bilang, ‘Karjá ini!’ pasti dia bekin bagitu. Jadi asal Bos omong sa, pasti beta pung ana karjá tu, bae memang.” ");
INSERT INTO mkn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dengar bagitu, ju Yesus heran. Dia omong sang itu orang banya yang ada iko deng Dia bilang, “Heran, é! Su bagini lama, ma Beta balóm parná katumu satu orang Yahudi ju yang parcaya sama kuat ke ini orang Roma! ");
INSERT INTO mkn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Dengar, é! Te nanti ada banya orang luar sama ke ini orang Roma ni yang datang dari sablá matahari nae deng dari sablá matahari turun, ko dudu makan pesta sama-sama deng baꞌi Abraham, baꞌi Isak deng baꞌi Yakob dalam Tuhan Allah pung ruma di sorga. ");
INSERT INTO mkn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Biar Tuhan su pili orang Yahudi ko jadi Dia pung orang, ma ada banya yang sonde toe sang Dia. Nanti Dia tola buang sang dong pi tampa galáp buta. Di situ dong manangis makarereu deng sangsara mati pung.” ");
INSERT INTO mkn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Omong ais bagitu, ju Yesus kasi tau sang itu komandán bilang, “Pak pulang su. Te itu ana karjá su bae, sama ke pak pung parcaya.” Pas itu waktu ju, itu ana bae memang. ");
INSERT INTO mkn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ais satu kali, Yesus pi di Petrus pung ruma. Dia lia Petrus pung mama mantu ada tidor di koi, te dia ada damám. ");
INSERT INTO mkn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus pegang dia pung tangan, ju itu mamatua pung damám ilang memang. Ais dia bangun ko pi urus sang Yesus dong. ");
INSERT INTO mkn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Waktu matahari mulai turun, ju orang dong datang bawa dong pung orang yang takaná setan dong. Ais Yesus parenta itu setan dong bilang, “Heh, setan! Iskarobis dari ini orang dong!” Ju itu setan dong kaluar memang. Dia ju bekin bae samua orang saki. ");
INSERT INTO mkn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dia bekin ini samua, ko bekin iko apa yang Tuhan Allah pung jubir Yesaya su tulis memang bilang, “Dia bekin bae kotong pung panyaki. Deng Dia tanggong kotong pung sangsara.” ");
INSERT INTO mkn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ais itu, Yesus dapa lia orang bam-banya datang kuliling sang Dia. Ju Dia suru Dia pung ana bua dong bilang, “Mari ko kotong balayar pi dano pung sablá.” ");
INSERT INTO mkn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ju ada satu guru agama datang omong bilang, “Bapa Guru! Bapa pi mana sa, na, beta mau iko tarús deng Bapa!” ");
INSERT INTO mkn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma Yesus manyao bilang, “Bae ju! Ma inga bagini. Samua orang deng binatang ada dong pung tampa tenga sandiri. Anjing utan kambali pi dia pung lobang. Burung kambali pi dia pung sarang. Ma Beta, Manusia Tulen ni, sonde ada pung ruma sandiri ko pulang pi situ. Tampa alas kapala ju sonde ada.” ");
INSERT INTO mkn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ais satu orang laen lai, yang ada iko-iko sang Dia, datang minta bilang, “Bos! Beta mau iko sang Bos, ma biar beta pulang ko urus orang tua dong dolo. Kalo beta pung bapa su mati, na, baru beta iko.” ");
INSERT INTO mkn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma Yesus omong bilang, “Bagini! Kasi tenga ko orang yang sonde ada pung parcaya sang Tuhan dong, urus dong pung orang mati. Te kalo lu mau iko sang Beta, na, lu musti iko batúl-batúl!” ");
INSERT INTO mkn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ais itu, ju Yesus nae pi atas parahu sama-sama deng Dia pung ana bua dong. ");
INSERT INTO mkn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Waktu dong ada balayar pi dano pung sablá, ju Dia tidor. Sonde lama ju, angin ribut datang. Galombang puku pi-datang, ju aer maso pi dalam parahu. ");
INSERT INTO mkn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lia bagitu, ju ana bua dong kasi bangun sang Dia bilang, “Bos! Bos, é! Bangun ko tolong kasi salamat sang botong dolo! Te kotong su mau mati tanggalám ni!” ");
INSERT INTO mkn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ju Yesus manyao bilang, “Weh, akurang ko bosong taku!? Bosong sonde parcaya sang Beta, ko?” Ju Dia bangun. Ais Dia togor itu angin deng galombang bilang, “Barenti su!” Ju galombang deng angin jadi tadó memang. ");
INSERT INTO mkn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ju Yesus pung ana bua dong heran. Dong bilang, “Awii! Dia ni, sapa, é? Karmana ko Dia bisa parenta angin deng galombang ko dong iko Dia pung mau?” ");
INSERT INTO mkn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sonde lama lai, ju dong sampe di dano pung sablá, di orang Gadara pung daꞌera. Di situ ada dua orang takaná setan yang tenga di goa batu tampa orang mati. Dong tu, jahat mau mati, sampe sonde ada satu orang ju yang barani jalan iko situ. Dong lia Yesus datang ju, ");
INSERT INTO mkn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","dong batarea bilang, “Woi, Tuhan Allah pung Ana! Akurang ko Lu datang ganggu sang botong? Biar dia pung waktu ko mau hukum sang botong balóm sampe, ma Lu su mau siksa sang botong.” ");
INSERT INTO mkn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sonde jao dari situ, ada babi bam-banya doꞌi-doꞌi tana ko cari makan. ");
INSERT INTO mkn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ju itu setan dong minta sang Yesus bilang, “Kalo mau usir sang botong, na, suru sang botong ko maso pi dalam itu babi dong sa!” ");
INSERT INTO mkn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ju Yesus parenta sang dong bilang, “Pi su!” Ais, itu setan dong kaluar kasi tenga itu dua orang, ju dong maso pi dalam itu babi dong. Tarús itu babi dong lari harba-biruk turun iko pinggir gunung ko maso pi dalam dano. Ju dong samua mati tanggalám. ");
INSERT INTO mkn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lia bagitu ju, tukang jaga babi dong lari pulang pi kampong, ju dong carita samua-samua. ");
INSERT INTO mkn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dengar dong pung carita bagitu, ju orang banya dong kaluar pi itu tampa. Dong katumu sang Yesus, ju dong noki-noki ko Dia jalan kasi tenga dong pung tampa. ");
INSERT INTO mkn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ais itu, Yesus dong nae kambali pi dalam parahu, ko balayar pi dano pung sablá, sampe di Dia pung kota sandiri. ");
INSERT INTO mkn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Di situ ada orang yang dorok bawa dong pung kawan yang lumpu ko pi di Dia. Lia bagitu ju, Yesus tau dong ada parcaya sang Dia bilang, Dia bisa bekin bae dong pung kawan tu. Ju Dia omong sang itu orang lumpu bilang, “Ana, é! Kasi kuat lu pung hati dolo! Te Beta su hapus buang lu pung sala dong.” ");
INSERT INTO mkn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma ada barapa orang guru agama Yahudi di situ, yang dengar Yesus pung omong tu. Ju dong pung hati panas memang. Ais dong baꞌomong bilang, “Ini orang talalu barani omong bagitu, ó! Cuma Tuhan Allah sa yang bisa kasi ampon orang pung sala. Ma ini orang pung omong tu, bekin diri sama ke dia Tuhan Allah sa. Dia su hojat tu!” ");
INSERT INTO mkn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma Yesus tau dong pung dalam hati. Ais Dia omong bilang, “Akurang ko bosong pikir kata, Beta ni, ada omong hojat? ");
INSERT INTO mkn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mana yang lebe gampang? Kalo Beta kasi tau sang ini orang lumpu ni bilang, ‘Lu pung sala su dapa ampon,’ ko, Beta bilang, ‘Bangun suda, ko pulang.’ ");
INSERT INTO mkn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kalo dia bangun memang, bosong baru lia bukti bilang, Beta ni, Manusia Tulen. Te Beta ada hak ko kasi ampon orang pung sala.” Ju Yesus parenta sang itu orang lumpu bilang, “Bangun su! Angka lu pung tandu ko jalan pulang!” ");
INSERT INTO mkn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tarús, itu orang lumpu bangun, ju dia jalan pulang. ");
INSERT INTO mkn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lia bagitu ju, samua orang heran. Ais dong angka nae tinggi-tinggi Tuhan Allah pung nama bilang, “Tuhan Allah tu, talalu hebat, ó! Dia su kasi kuasa bésar bagini sang manusia.” ");
INSERT INTO mkn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ais itu, Yesus jalan dari situ, ju Dia dapa lia satu orang tukang tagi bea yang ada karjá di kantor pajak. Dia pung nama, Mateos. Ais Yesus ajak sang dia bilang, “Mari iko sang Beta!” Dengar bagitu, ju Mateos bangun ko iko memang sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ais itu, Mateos undang sang Yesus dong datang makan di dia pung ruma. Dia ju undang dia pung kawan-kawan tukang tagi bea, deng tamu-tamu laen dong, ko datang makan sama-sama deng dong. ");
INSERT INTO mkn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma ada barapa orang dari partei Farisi yang datang mangomek di Yesus pung ana bua dong bilang, “Akurang ko bosong pung guru dudu makan sama-sama deng orang tar laku-laku dong, sama ke itu tukang tagi bea dong, deng dong pung kawan orang jahat dong?” ");
INSERT INTO mkn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ma Yesus kasi tau sang dong bilang, “Orang yang saki memang parlú dokter. Ma orang yang su bae, sonde parlú. ");
INSERT INTO mkn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lebe bae bosong pulang ko pareksa bae-bae Tuhan Allah pung Kata-kata, yang dolu Dia suru Dia pung jubir Hosea tulis bilang, ‘Beta pung mau, andia, Beta pung orang dong basayang satu deng satu deng kasi tunju rasa kasian. Kalo dong sonde bekin bagitu, na, dong pung korban binatang yang dong bawa kasi Beta tu, sonde ada pung arti apa-apa.’ Itu yang Tuhan Allah su bilang. Tagal itu, Beta sonde datang ko urus orang yang anggap diri su bae, ma Beta datang ko urus orang tar bae-bae dong.” ");
INSERT INTO mkn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ais itu, Yohanis Tukang Sarani pung ana bua dong datang sang Yesus. Dong tanya bilang, “Botong yang iko sang Yohanis, biasa puasa. Orang Farisi dong ju puasa. Ma akurang ko Bapa pung ana bua dong maen makan-minum tarús? Dong sonde tau puasa, ko?” ");
INSERT INTO mkn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma Yesus manyao sang dong pake umpama bilang, “Bagini: kalo ada pesta kawin, tamu dong sonde puasa, ma dong makan kinyang. Kalo baroit laki-laki masi ada di situ, tantu dong samua makan rame-rame. Ma nanti satu kali, kalo orang laen tangkap bawa itu baroit laki-laki, ju dia pung tamán dong rasa susa dolo, baru itu saꞌat dong puasa. ");
INSERT INTO mkn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Orang sonde ame kaen baru sapoꞌong, ko tempel pi di baju tua yang su tarobe. Te nanti kalo cuci itu baju, kaen tempel yang baru tu batakundur. Deng bagitu, itu baju tua tamba tarobe. ");
INSERT INTO mkn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bagitu ju, orang sonde isi tuak baru, pi dalam haik yang su lapuk. Te nanti itu haik pica, ju itu tuak malele buang. Jadi tuak baru, musti poꞌa pi dalam haik yang baru ko dong dua bisa batahan!” Deng bagitu Yesus ajar sang dong bilang Dia pung ajaran tu, baru. Jadi jang kasi bacampor deng ajaran lama. ");
INSERT INTO mkn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Waktu Yesus masi baꞌomong deng Yohanis pung ana bua dong, ju ada satu kapala ruma sambayang datang katumu deng Dia. Itu orang tikam lutut di Yesus pung muka, ko minta bilang, “Bapa, é! Tolong dolo! Te beta pung ana nona baru mati. Bapa tolong pi ko taro tangan pi di dia dolo, ko dia bisa idop kambali.” ");
INSERT INTO mkn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dengar bagitu, ju Yesus deng Dia pung ana bua dong iko memang sang itu orang. ");
INSERT INTO mkn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Di tenga jalan, ada satu mama yang jalan iko deng dong. Dia pung datang bulan sonde tau-tau barenti batúl, su 12 taon. Dia ada pikir di dia pung hati bilang, “Asal beta bisa raba Yesus pung baju sa, tantu beta jadi bae.” Andia ko dia pi raba Yesus pung ujung baju. ");
INSERT INTO mkn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus ada barasa, ju Dia bale muka ko lia itu mama. Tarús Dia omong bilang, “Ana, é! Kasi kuat lu pung hati. Te, tagal lu parcaya batúl-batúl sang Beta, andia ko lu jadi bae.” Itu waktu ju, itu mama bae memang. ");
INSERT INTO mkn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ais itu, Yesus dong jalan tarús pi di itu kapala ruma sambayang pung ruma. Sampe di sana ju Dia maso deng lia tukang maen musik duka, deng orang banya manangis makarereu. ");
INSERT INTO mkn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma Yesus kasi tau sang dong bilang, “Barenti manangis, ko bosong pulang su! Te ini ana sonde mati. Dia cuma tidor sa.” Ma dong katawa kasi bengko mulu sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ais itu, ju itu orang dong kaluar samua. Ju Yesus maso pi dalam itu ana pung kamar, deng pegang dia pung tangan. Ju itu ana idop kambali memang. ");
INSERT INTO mkn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lia bagitu, ju orang mulai bacarita rame kuliling dong pung daꞌera, soꞌal apa yang Yesus su bekin. ");
INSERT INTO mkn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ais ju Yesus jalan tarús. Di tenga jalan, ada dua orang buta iko-iko sang Dia. Dong baꞌeki pange bilang, “Raja Daud pung turunan, é! Kasian sang botong dolo!” ");
INSERT INTO mkn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus maso pi dalam ruma, ju itu dua orang buta tu datang sang Dia. Ais Dia tanya sang dong bilang, “Bosong parcaya batúl-batúl bilang, Beta ada pung kuasa ko bekin bosong bisa dapa lia?” Ju dong manyao bilang, “Awii! Bapa jang tanya lai, te botong su parcaya sang Bapa isi-isi.” ");
INSERT INTO mkn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dengar bagitu, ju Yesus raba dong pung mata, deng omong bilang, “Kalo bagitu, na, biar jadi iko bosong pung parcaya!” ");
INSERT INTO mkn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesus omong ais bagitu, ju dong dapa lia memang. Ma Yesus kasi inga karás sang dong bilang, “Inga, é! Jang kasi tau satu orang ju deng apa yang su jadi ni!” ");
INSERT INTO mkn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma dong sonde bisa tahan diri. Ais dong jalan kuliling itu daꞌera ko kasi tasiar soꞌal apa yang Yesus su bekin. ");
INSERT INTO mkn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Itu dua orang buta kaluar abis ju, orang bawa datang satu orang laen pi Yesus. Itu orang sonde bisa baꞌomong, tagal dia takaná setan. ");
INSERT INTO mkn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lia bagitu ju, Yesus parenta itu setan kaluar dari itu orang. Itu setan kaluar ju, itu orang bisa baꞌomong memang. Ais orang banya di situ taheran-heran. Dong bilang, “Awii! Kotong orang Yahudi balóm parná lia yang bagini ni!” ");
INSERT INTO mkn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma orang Farisi dong sonde sanáng. Dong omong bilang, “Weh! Setan dong pung bos yang kasi Dia kuasa ko Dia bisa usir kaluar setan dong.” ");
INSERT INTO mkn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ais Yesus pi kuliling banya kota deng kampong, ko ajar orang di ruma sambayang dong. Dia ajar orang soꞌal Tuhan Allah pung Kabar Bae, deng karmana dong bisa maso jadi Dia pung orang. Dia ju bekin bae samua macam panyaki, deng samua orang yang badan sonde batúl dong. ");
INSERT INTO mkn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lia itu orang banya, ju Yesus jato kasian sang dong, tagal dong sonde tau mau bekin karmana. Te dong samua tu, sama ke domba yang sonde ada pung gambala. ");
INSERT INTO mkn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ais Yesus omong deng Dia pung ana bua dong bilang, “Ini orang banya ni, sama ke kabón pung hasil. Biar hasil banya, ma orang karjá sonde cukup ko koru ame itu hasil, deng simpan pi dalam gudang. ");
INSERT INTO mkn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tagal itu, bosong musti minta sang Tuan kabón, ko Dia kirim orang karjá, ko biar dong pi kumpul ame Dia pung hasil dong.” ");
INSERT INTO mkn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ais itu, Yesus pange Dia pung ana bua dong ko datang bakumpul. Ju Dia kasi dong kuasa ko usir setan deng bekin bae orang dari dong pung panyaki macam-macam. ");
INSERT INTO mkn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Itu 12 ana bua yang Dia utus dong pung nama, andia: Yang partama, nama Simon (yang biasa orang pange bilang, ‘Petrus’), ais dia pung adi, nama Anderias, ais itu, Yakobis, deng dia pung adi, nama Yohanis (dong dua tu, Sabadeus pung ana). ");
INSERT INTO mkn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ada ju Filipus, deng Bartolomeos. Ais Tomas, deng Mateos (tukang tagi bea). Ais Yakobis (Alpius pung ana), deng Tadius. ");
INSERT INTO mkn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ais Simon (yang iko partei politik Selot), deng Yudas Iskariot (yang nanti jual buang sang Yesus). ");
INSERT INTO mkn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Ais itu, Yesus utus Dia pung ana bua 12 orang, deng Dia kasi parenta bilang, “Beta utus sang bosong pi di kotong pung orang Yahudi, tagal ada banya dari kotong pung orang yang sonde iko batúl Tuhan pung jalan. Dong tu, sama ke domba kasasar. Tagal itu, bosong sonde usa pi di orang bukan Yahudi, conto ke orang Samaria dong. ");
INSERT INTO mkn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pi kasi tau sang kotong pung orang Israꞌel dong bilang, ‘Dia pung waktu su sampe ko samua orang bisa maso jadi Tuhan Allah pung orang.’ ");
INSERT INTO mkn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pi bekin bae orang saki, kasi idop kambali orang mati, bekin bae orang kusta, deng usir kasi kaluar setan. Tuhan su kasi bam-banya sang bosong, ma Dia sonde minta kambali apa-apa. Jadi sakarang bosong musti pi ko kasi bam-banya sang orang laen, ma bosong sonde usa minta kambali apa-apa ju dari dong. ");
INSERT INTO mkn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jalan deng kosong-kosong sa, é. Sonde usa bawa doi, ");
INSERT INTO mkn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","bakál, pakean ganti, sapatu, ko tongkat. Te orang musti kasi sang orang karjá, apa yang pantas ko dong bisa idop. ");
INSERT INTO mkn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kalo bosong maso dalam satu kota, ko, satu kampong, na, bosong cari orang yang mau tarima sang bosong. Ais tenga di situ, sampe bosong barangkat kasi tenga itu tampa. ");
INSERT INTO mkn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kalo bosong maso pi orang pung ruma, na, omong bilang, ‘Saloom! Tuhan kasi berkat sang bosong.’ ");
INSERT INTO mkn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kalo orang di itu ruma tarima sang bosong deng bae, bosong minta ko Tuhan kasi berkat sang dong. Ma kalo dong sonde tarima sang bosong, Tuhan ju sonde kasi berkat sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kalo orang sonde mau dengar sang bosong, na, kaluar dari itu ruma, ko itu kota, ais kabás buang abu dari bosong pung kaki, ko jadi tanda bilang, dong sonde mau dengar, na, dong pikol tanggong-jawab sandiri. ");
INSERT INTO mkn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nanti kalo Tuhan Allah kasi jato hukum sang manusia di ini dunya, tantu Dia kasi jato hukum yang barát sang itu orang Sodom deng Gomora yang dolu paling jahat. Ma inga! Te nanti Dia kasi jato hukum yang lebe barát lai kasi orang yang sonde mau tarima sang bosong!” ");
INSERT INTO mkn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Inga, te Beta utus sang bosong ni sama ke Beta kirim domba pi teng-tenga anjing utan yang jahat. Tagal itu, bosong musti pake otak sama ke ular yang pintar. Deng bosong pung hati ju musti lurus sama ke burung pompa yang sonde tau cari hal. ");
INSERT INTO mkn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ma ati-ati, ó! Te nanti orang siksa sang bosong sama ke anjing jahat gigi bekin mati domba. Nanti dong hela bawa bosong maso pi tampa urus parkara agama. Deng nanti dong firuk sang bosong di dong pung ruma sambayang. ");
INSERT INTO mkn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nanti dong hela bawa sang bosong pi mangada di gubernor deng raja, tagal bosong iko sang Beta. Ma bosong musti pake itu kasampatan kasi tau Beta pung Kabar Bae sang dong. Deng bagitu, orang yang sonde kanál sang Tuhan ju dapa dengar soꞌal Beta. ");
INSERT INTO mkn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ma kalo dong hela bawa sang bosong bagitu, na, bosong sonde usa taku bilang, ‘Nanti beta mau baꞌomong bilang, apa?’ Ko, ‘Nanti beta manyao bilang, apa?’ Sonde usa pikir-pikir bagitu, te sampe dia pung waktu, nanti bosong pung Bapa di sorga kasi tau soꞌal apa yang bosong musti omong. ");
INSERT INTO mkn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Itu waktu, apa yang bosong omong sonde baꞌakar di bosong sandiri, te Dia pung Roh Barisi yang ajar ko bosong omong apa. ");
INSERT INTO mkn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bosong lia sa, te nanti dalam satu ruma, kalo ada orang yang parcaya sang Beta, nanti dia pung sodara sandiri yang cari jalan ko orang bunu sang dia. Ais kalo ana yang parcaya, nanti dia pung bapa yang bunu sang dia. Kalo bapa deng mama yang parcaya, nanti dong pung ana sandiri yang bunu sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lia te nanti samua orang binci mati sang bosong, tagal bosong iko sang Beta. Ma orang yang batahan tarús sampe abis, Tuhan Allah nanti kasi salamat sang dia. ");
INSERT INTO mkn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kalo orang siksa sang bosong di satu kota, na, bangun lari pi kota laen. Batúl tu! Beta ni, Manusia Tulen. Nanti bosong masi balóm jalan kuliling abis samua kota di Israꞌel, ma Beta su kambali. ");
INSERT INTO mkn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Orang dong biasa taro hormat sang satu guru, lebe dari dia pung ana bua dong. Deng orang taro hormat sang satu bos, lebe dari dia pung ana karjá dong. ");
INSERT INTO mkn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kalo ana bua su balajar sama pintar deng dia pung guru, dia su rasa cukup. Deng kalo ana karjá su balajar sama pintar deng dia pung bos, na, dia ju rasa cukup. Jadi inga, é! Kalo orang su pange tuan ruma bilang, ‘Lu ni, Balsebul, andia setan dong pung bos!’ na, tantu dia pung isi ruma ju dapa nama lebe tar bae lai.” ");
INSERT INTO mkn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Jadi bosong sonde usa taku deng orang yang lawan sang bosong. Te apa yang orang bekin sambunyi-sambunyi, nanti samua orang dapa lia. ");
INSERT INTO mkn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Apa yang Beta su ajar sang bosong sandiri-sandiri, nanti bosong musti pi kasi tau samua orang. Deng apa yang Beta kasi tau diam-diam, nanti bosong musti pi kasi tau kuliling di samua tampa. ");
INSERT INTO mkn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jang taku manusia, te dong cuma bisa kasi mati orang sa, ma dong sonde bisa bekin rusak orang pung jiwa. Tagal itu, bosong musti taku sang Tuhan Allah, te Dia sa yang ada pung kuasa ko lempar buang orang pung badan deng dia pung jiwa pi dalam laut api yang manyala tarús-tarús. ");
INSERT INTO mkn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Jadi kasi kuat bosong pung hati. Orang jual burung pipit di pasar deng harga paling mura sa. Ma sonde ada satu ju yang jato mati, kalo bosong pung Bapa di sorga sonde kasi isin. ");
INSERT INTO mkn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bosong pung Bapa di sorga ju ada taro mata sang bosong sampe hal yang paling kici. Bosong pung urat rambu pung banya di kapala ju, Dia su tau na. ");
INSERT INTO mkn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jadi bosong jang taku! Tagal Tuhan Allah nilei sang bosong lebe mahal dari itu burung pipit dong samua.” ");
INSERT INTO mkn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ais Yesus omong lai bilang, “Orang yang barani mangaku kanál sang Beta di muka orang banya di ini dunya, nanti Beta ju mangaku kanál sang dia di muka Beta pung Bapa di sorga bilang, ‘Dia ni, Beta pung orang.’ ");
INSERT INTO mkn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma orang yang manyangkal sang Beta di muka orang banya bilang, dia sonde kanál sang Beta, nanti Beta ju kasi tau sang Beta pung Bapa di sorga bilang, ‘Beta sonde kanál sang ini orang.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Bosong jang sangka bilang, Beta datang bawa dame di ini dunya. Te Beta datang ko bekin manusia bamalawan satu deng satu. ");
INSERT INTO mkn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Beta datang di ini dunya, iko apa yang Tuhan pung jubir su tulis memang bilang, ‘Nanti ana laki-laki malawan dia pung bapa, ana parampuan malawan dia pung mama, deng ana mantu parampuan malawan dia pung mama mantu, ");
INSERT INTO mkn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","te isi ruma sandiri yang bamusu satu deng satu.’ ");
INSERT INTO mkn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jadi orang yang batúl-batúl mau iko sang Beta, dia musti sayang sang Beta lebe dari samua; lebe dari dia pung mama-bapa, deng lebe dari dia pung ana dong. Te kalo sonde, na, itu orang sonde pantas jadi Beta pung orang. ");
INSERT INTO mkn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Te orang yang mau iko sang Beta, ma sonde mau pikol sangsara, dia sonde pantas jadi Beta pung orang. ");
INSERT INTO mkn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Orang yang sadia mati tagal dia iko sang Beta, nanti dia dapa idop tarús deng Tuhan. Ma orang yang cuma mau idop buat dia pung diri sandiri sa, nanti dia pung idop tu, ilang buang bagitu sa!” ");
INSERT INTO mkn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Orang yang tarima sang bosong deng bae, dia ju tarima sang Beta. Deng orang yang tarima sang Beta, dia ju tarima sang Tuhan Allah yang utus sang Beta. ");
INSERT INTO mkn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Orang yang tarima Tuhan Allah pung jubir tagal itu jubir ada omong soꞌal Tuhan, nanti Tuhan balas sang dia sama ke Tuhan balas sang satu jubir. Deng orang yang tarima satu orang hati lurus tagal itu orang ada iko batúl-batúl Tuhan pung mau, nanti Tuhan balas sang dia sama ke Tuhan balas sang satu orang hati lurus. ");
INSERT INTO mkn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Orang yang tarima sang satu orang yang paling kici tagal dia iko sang Beta, pasti Tuhan balas sang dia. Biar orang cuma kasi aer puti satu galás sa, tantu Tuhan Allah sonde lupa sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Waktu Yesus kasi pasán abis sang Dia pung ana bua 12 orang tu, ju Dia pi kuliling di kampong-kampong di itu daꞌera, ko ajar orang deng kasi tau Tuhan Allah pung Kabar Bae. ");
INSERT INTO mkn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Itu waktu, Yohanis su ada dalam bui. Waktu dia dengar samua hal yang Yesus su bekin, ju dia suru dia pung ana bua dong pi tanya sang Yesus bilang, ");
INSERT INTO mkn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Tuhan Allah su janji memang dari dolu bilang, Dia mau kirim datang Kristus ko kasi salamat sang kotong orang Yahudi. Bapa ni, andia Kristus, ko? Ko, botong musti tunggu sang orang laen lai?” Ju dong pi tanya sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Dengar bagitu, ju Yesus manyao bilang, “Bosong su dengar deng su lia sandiri. Jadi pulang ko lapor sang Bu Anis bilang, samua su jadi, iko apa yang Tuhan Allah pung jubir Yesaya su tulis memang bilang: ");
INSERT INTO mkn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Orang buta, dapa lia. Orang kaki lumpu, bangun bajalan. Orang panyaki kusta, jadi barisi. Orang tuli, dapa dengar. Orang mati, idop kambali. Orang kasian, dengar Kabar Bae. ");
INSERT INTO mkn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jadi bagini: pi kasi tau Bu Anis, nanti dia ontong kalo dia parcaya tarús sang Beta. Tagal nanti Tuhan Allah kasi berkat sang orang yang dia pung parcaya sang Beta sonde tagoyang!” ");
INSERT INTO mkn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Waktu Yohanis pung ana bua dong su pulang, ju Yesus omong deng orang banya dong soꞌal Yohanis bilang, “Waktu bosong pi cari Yohanis di tampa sunyi sana tu, bosong pikir mau katumu deng manusia model ke apa? Sonde mungkin bosong pi sana ko katumu orang yang noe-noe, sama ke bambu yang tagoyang-goyang iko angin sa! ");
INSERT INTO mkn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Deng sonde mungkin bosong pi ko lia orang yang pake pakean mahal-mahal, te orang macam bagitu cuma tenga di istana sa! ");
INSERT INTO mkn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jadi bosong pi lia orang macam karmana di sana? Bosong pikir bosong pi cari Tuhan Allah pung jubir? Batúl! Ma dia tu, jubir yang paling hebat. ");
INSERT INTO mkn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Te Tuhan Allah pung Tulisan Barisi ada tulis memang soꞌal Yohanis bilang, ‘Dengar! Beta utus Beta pung orang, ko pi buka jalan kasi sang Lu.’ ");
INSERT INTO mkn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Dengar bae-bae, ó! Di ini dunya, sonde ada satu orang ju, yang lebe hebat dari Yohanis. Ma dari samua manusia yang parná mangaku Tuhan Allah jadi dong pung Raja, orang yang paling kakorek sa su lebe hebat dari Yohanis. ");
INSERT INTO mkn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mulai dari Yohanis angka dia pung karjá sampe sakarang, banya orang su maso jadi Tuhan Allah pung milik. Ma ada orang saparu yang pikir sala, ais dong baparáng ko paksa orang maso jadi Tuhan Allah pung orang. Deng ada yang baparáng malawan sang Tuhan pung orang ju. ");
INSERT INTO mkn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sampe deng Yohanis Tukang Sarani pung datang, kotong orang Yahudi biasa idop iko baꞌi Musa deng Tuhan Allah pung jubir dong pung atoran. ");
INSERT INTO mkn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jadi parcaya sang Beta sa! Yohanis tu, andia Elia yang Tuhan Allah pung jubir dong su kasi tau memang soꞌal dia pung datang. ");
INSERT INTO mkn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jadi, yang kapingin mangarti musti dengar bae-bae, ó! ");
INSERT INTO mkn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Beta mau kasi umpama ko bosong dapa tau, orang sakarang ni, manusia macam apa. Te dong tu, sama ke ana-ana yang ada dudu-dudu di pasar. Dong ada maen babatarea deng dong pung tamán bilang, ");
INSERT INTO mkn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘We! Botong tiop suling rame-rame, ma bosong sonde manari sanáng-sanáng. Ais botong manyanyi lagu duka, ma bosong sonde manangis.’ ");
INSERT INTO mkn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bosong ni sama ke ana kici dong yang sonde tau puas. Waktu Yohanis datang, dia suka puasa, deng sonde minum anggor. Ma orang cap sang dia bilang, ‘Dia ada takaná setan!’ ");
INSERT INTO mkn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ma sakarang Beta, Manusia Tulen, su datang. Beta sonde puasa, deng Beta minum anggor. Ma orang cap sang Beta bilang, ‘Dia tu, dasar manusia balalas! Pamabok barát lai! Dia pi bakawan deng tukang tagi bea dong! Satu partei deng orang tar laku-laku dong! Sonde tau diri lai!’ Ma bosong tanda sa, Beta pung omong, é! Tuhan pung pintar jadi kantara di Dia pung orang dong pung idop.” ");
INSERT INTO mkn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ais itu, Tuhan Yesus mulai togor orang yang ada tinggal di barapa kampong. Dia su bekin tanda heran paling banya di sana, ma dong sonde mau kasi tenga dong pung sala-sala dong ko iko Tuhan pung jalan idop yang batúl. ");
INSERT INTO mkn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus togor bilang, “Bosong orang Korasin deng orang Betsaida dong! Awas, é! Nanti bosong calaka! Beta su bekin tanda heran macam-macam di bosong pung batang idong, ma bosong sonde mau parcaya sang Tuhan Allah. Padahal bosong ni orang Yahudi, yang mangaku kanál sang Tuhan. Ma andekata itu tanda-tanda heran yang Beta bekin di bosong pung kampong, su jadi lebe dolo di kota Tirus deng kota Sidon, tantu bagini lama orang di situ dong su tobat memang, deng su kasi tenga dong pung sala-sala ko iko sang Tuhan. Deng dong ju tantu pake pakean duka, deng taro abu di atas kapala ko jadi tanda bilang, dong ada manyasal deng dong pung sala-sala. Padahal orang Tirus deng orang Sidon ni, bukan orang Yahudi yang mangaku kanál sang Tuhan. ");
INSERT INTO mkn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Batúl! Nanti bosong lia sa! Kalo Tuhan putus samua orang dong pung parkara, orang Tirus deng orang Sidon pung hukuman masi jao lebe ringan dari bosong pung hukuman. ");
INSERT INTO mkn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bosong orang Kapernaum! Awas, é! Bosong jang pikir bilang, nanti Tuhan angka nae sang bosong maso pi sorga. Sonde! Nanti Tuhan lempar buang sang bosong maso pi naraka! Andekata itu tanda-tanda heran yang Beta bekin di bosong pung kampong su jadi lebe dolo di kota Sodom, tantu Tuhan Allah sonde parlú kasi ancor itu kota jahat. Te kalo orang Sodom lia itu tanda heran dong, su tantu dong kasi tenga dong pung jahat. ");
INSERT INTO mkn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Batúl! Nanti bosong lia sa! Kalo Tuhan putus samua orang dong pung parkara, orang Sodom pung hukuman masi jao lebe ringan dari bosong pung hukuman!” ");
INSERT INTO mkn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Omong abis bagitu, ju Yesus sambayang bilang, “Bapa! Bapa yang pegang hak parenta samua di langit deng bumi. Beta minta tarima kasi bam-banya, tagal Bapa tutu ame itu hukuman dari orang yang anggap diri pintar, deng yang tinggi hati dong. Ma Bapa buka itu hal samua kasi orang kici dong, deng orang yang randá hati dong. ");
INSERT INTO mkn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Batúl, Bapa! Te itu yang bekin Bapa pung hati sanáng!” ");
INSERT INTO mkn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sambayang abis bagitu, ju Yesus kasi tau sang orang di situ dong bilang, “Dengar bae-bae, ó! Beta pung Bapa di sorga su kasi samua kuasa sang Beta. Yang kanál bae sang Beta tu, andia cuma Bapa sa. Deng yang kanál bae sang Bapa, cuma Bapa pung Ana sa, andia Beta ni. Deng Beta pili orang laen dong, ko kasi tau sang dong, ko biar dong ju kanál bae sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Bosong samua yang cape karjá karás, mari iko sang Beta! Bosong samua yang ada pikol masala barát, mari datang sang Beta! ");
INSERT INTO mkn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kalo bosong tarima Beta pung ajaran ko jalan sama-sama deng Beta, na, kotong ni sama ke sapi luku dua ekor yang ada hela sama-sama satu luku. Te Beta ni, pung hati bae, deng Beta ni, randá hati. Kalo bosong iko sang Beta, na, bosong jadi kuat kambali. ");
INSERT INTO mkn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tagal Beta pung ajaran sonde susa. Deng Beta pung parenta sonde barát.” ");
INSERT INTO mkn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Satu kali, kaná deng orang Yahudi dong pung hari barenti karjá, Yesus deng Dia pung ana bua dong ada jalan iko orang pung kabón. Dia pung ana bua dong lapar, andia ko dong ketu ame padi-gandum pung puler ko dong makan jalan-jalan. ");
INSERT INTO mkn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Di situ, ada barapa orang dari partei agama Farisi yang pegang karás dong pung adat Yahudi. Lia Yesus pung ana bua dong bekin bagitu, ju dong togor sang Dia bilang, “Lu pung ana bua dong ada ketu padi-gandum kaná deng hari barenti karjá! Sonde bole bagitu! Te itu su langgar kotong pung atoran.” ");
INSERT INTO mkn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Ma Yesus manyao bilang, “Karmana, ó? Bosong sonde inga baꞌi Daud pung carita tu? Baꞌi Daud deng dia pung ana bua dong pung parú su karoncong tagal lapar mau mati. Ju dia maso pi dalam Tuhan Allah pung Tenda Sambayang, ko ame itu roti yang kapala agama dong su kasi sang Tuhan, ko dong makan. Padahal cuma kapala agama dong sa yang bole makan itu roti. Orang laen sonde bole. Ais baꞌi Daud dong makan, ma sonde ada orang kasi sala sang dong. Bosong tingka ke sonde tau baca Tuhan Allah pung Tulisan Barisi sa! ");
INSERT INTO mkn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Te di situ ju ada tulis soꞌal kapala agama dong yang karjá layani di ruma sambayang, kaná deng hari barenti karjá. Ma dong sonde dapa sala apa-apa. ");
INSERT INTO mkn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Dengar, ó! Dolu ruma sambayang yang pantíng, ma sakarang ada yang lebe pantíng lai. Andia, Beta, Manusia Tulen ni. ");
INSERT INTO mkn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dalam Tuhan Allah pung Tulisan Barisi, Tuhan Allah ada bilang, ‘Beta pung mau bagini: Beta pung orang dong musti kasi tunju rasa kasian satu deng satu. Kalo dong sonde bekin bagitu, na, dong pung korban binatang yang dong bawa kasi Beta tu, sonde ada pung arti apa-apa.’ Naa, kalo bosong mangarti bae-bae Tuhan pung omong tu, tantu bosong sonde tudu Beta pung ana bua dong sala. Ko dong sonde bekin sala apa-apa na! ");
INSERT INTO mkn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Te Beta ni, Manusia Tulen. Beta yang ada pung hak ko putus bilang, orang bole bekin apa kaná deng hari barenti karjá.” ");
INSERT INTO mkn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ais itu ju Yesus jalan kasi tenga itu tampa, ko pi di dong pung ruma sambayang. ");
INSERT INTO mkn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Di situ, ada satu laki-laki yang dia pung tangan mati sablá. Itu orang Farisi dong ada mau cari-cari jalan ko kasi sala sang Yesus, andekata Dia bekin bae itu orang yang tangan mati sablá, kaná deng hari barenti karjá. Ais dong tanya sang Dia bilang, “Iko kotong pung atoran agama, orang bole bekin bae orang kaná deng hari barenti karjá, ko sonde?” ");
INSERT INTO mkn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ais Yesus manyao bilang, “Kalo orang pung domba satu jato dalam lobang, kaná deng hari barenti karjá, tantu itu domba pung tuan pi angka kasi kaluar itu domba, wuang? ");
INSERT INTO mkn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Naa! Tuhan sayang sang manusia, lebe dari itu tuan sayang sang dia pung domba. Tagal itu, orang bole bekin hal bae kaná deng hari barenti karjá.” ");
INSERT INTO mkn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tarús Dia omong deng itu orang yang tangan mati sablá bilang, “Bu, é! Sorong datang lu pung tangan!” Ais dia sorong dia pung tangan mati sablá tu, ju itu tangan jadi bae memang, sama ke dia pung tangan sablá lai. ");
INSERT INTO mkn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lia bagitu, ju itu orang Farisi dong maruak. Ais dong bangun jalan kasi tenga itu ruma sambayang, ju dong pi baꞌakór bilang, “Kotong musti cari jalan ko bunu sang Dia!” ");
INSERT INTO mkn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma Yesus tau dong pung rancana jahat tu, andia ko Dia jalan pi tampa laen. Banya orang iko sang Dia, ju Dia bekin bae samua orang saki. ");
INSERT INTO mkn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma Dia larang sang dong bilang, “Bosong jang kasi tau orang laen soꞌal Beta.” ");
INSERT INTO mkn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dia bekin bagitu iko apa yang Tuhan Allah su kasi tau sang Dia pung jubir Yesaya bilang, ");
INSERT INTO mkn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Coba lia! Ini Dia, Beta pung Orang suru-suru yang Beta su pili. Beta sayang sang Dia, deng Beta pung hati sanáng tarús deng Dia. Nanti Beta kasi Beta pung Roh sang Dia, ko Dia pi ajar orang di samua suku-bangsa soꞌal Beta pung jalan idop yang lurus. ");
INSERT INTO mkn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dia sonde tau puku-puku dada. Dia sonde tau angka-angka diri. ");
INSERT INTO mkn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dia pung hati bae. Dia sonde bekin susa orang. Kayu yang amper pata, Dia sonde pata buang. Lampu teꞌoek yang amper mati, Dia sonde fuu bekin mati. Dia ajar orang tarús, sampe lama-lama samua suku-bangsa tau ko iko Tuhan pung jalan idop yang lurus. ");
INSERT INTO mkn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Orang dari samua suku-bangsa nanti parcaya sang Dia, tagal dong tau Dia tu, sapa.” ");
INSERT INTO mkn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ais satu kali, orang dong bawa pi Yesus satu orang yang takaná setan sampe dia buta deng sonde bisa baꞌomong. Ju Yesus usir kasi kaluar itu setan ko bekin bae sang dia. Ais, itu orang bisa lia deng bisa baꞌomong memang. ");
INSERT INTO mkn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lia bagitu, ju samua orang taheran-heran. Dong baꞌomong bilang, “Mangkali Dia ni, Daud pung turunan, yang Tuhan pung jubir dong su tulis memang dari dolu-dolu. Dia ni, tantu Orang yang kotong su tunggu-tunggu tu!” ");
INSERT INTO mkn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma waktu orang Farisi dengar bagitu, ju dong sonde tarima. Ais dong baꞌomong bilang, “Woeh! Ini orang bisa usir kasi kaluar setan, tagal setan dong pung bos Balsebul, yang kasi kuasa sang Dia.” ");
INSERT INTO mkn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma Yesus tau orang Farisi dong pung omong tu. Ju Dia kasi tau sang dong bilang, “Bosong pung omong tu, sonde maso di akal! Kalo dalam satu negrí, dia pung rakyat dong baku hantam, karmana ko itu negrí masi bisa batahan! Bagitu ju kalo orang dalam satu kota, ko, dalam satu ruma, satu baraꞌu deng satu, tantu dong tu tapica-pica sampe ancor-ancor, ó! ");
INSERT INTO mkn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jadi, kalo setan dong maen bamusu deng maen baꞌusir satu deng satu, na, dong pung bos su sonde bisa pegang parenta lama-lama lai! ");
INSERT INTO mkn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Inga, é! Bosong pung orang dong ju tau usir setan. Dong pake kuasa dari setan, ko? Sonde! Jadi bosong jang omong sambarang bilang, Beta ada pake setan pung kuasa ko usir setan. Nanti bosong pung orang sandiri yang putus bilang, apa yang bosong tudu tu, sala. ");
INSERT INTO mkn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma kalo Beta batúl-batúl usir setan pake kuasa dari Tuhan pung Roh, itu kasi tunju bilang, Tuhan tu memang Raja yang su ada di bosong pung muka idong. ");
INSERT INTO mkn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kalo orang mau datang rampok barang di satu orang kuat pung ruma, dia musti ika mati itu orang dolo. Abis, baru dia bisa rampok ame itu orang pung barang dong. ");
INSERT INTO mkn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Inga bae-bae! Te orang yang sonde bapartei deng Beta, dia tu bamusu deng Beta. Deng orang yang sonde babantu deng Beta pung karjá, dia tu bekin kaco sa. ");
INSERT INTO mkn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jadi dengar bae-bae Beta pung omong ni! Tuhan Allah su sadia hapus buang sang orang dong pung sala. Deng kalo orang omong tar bae-bae kaná orang laen, Tuhan Allah masi sadia kasi ampon sang dia. Ma kalo ada orang barani omong tar bae-bae kasi Tuhan Allah pung Roh yang Barisi, Tuhan Allah sonde hapus buang dia pung sala tu. ");
INSERT INTO mkn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kalo orang omong jahat sang Beta, Manusia Tulen ni, Tuhan sadia kasi ampon sang dia. Ma kalo orang omong bekin hina lawan Tuhan pung Roh yang Barisi, ma Tuhan Allah sonde hapus buang dia pung sala tu, biar dari sakarang sampe salamanya ju!” ");
INSERT INTO mkn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ais Yesus omong tarús sang itu orang Farisi dong bilang, “Pikir bae-bae! Pohon yang bae kasi kaluar bua yang bae. Ma pohon yang sonde bae kasi kaluar bua yang sonde bae. Tagal dari pohon pung bua, orang bisa tau bilang, itu pohon tu, bae ko sonde. ");
INSERT INTO mkn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ma bosong ni sama ke ular tukang putar-balek! Bosong sonde bisa omong hal-hal yang bae. Tagal apa yang tasimpan dalam orang pung hati, itu yang nanti kaluar dari dia pung mulu. ");
INSERT INTO mkn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Orang bae, tantu omong yang bae, tagal ada hal-hal yang bae tasimpan dalam dia pung hati. Ma orang jahat, pasti omong yang jahat, tagal ada hal-hal yang jahat tasimpan dalam dia pung hati. ");
INSERT INTO mkn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Parcaya sang Beta! Te nanti hari kiamat datang, Tuhan Allah pareksa samua orang pung parkara. Itu waktu, tiap orang musti tanggong-jawab dia pung kata-kata yang sonde ada pung guna. ");
INSERT INTO mkn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Jadi ati-ati, ó! Te nanti Tuhan Allah timbang bosong pung kata-kata, deng putus bilang, bosong kaná hukum, ko sonde.” ");
INSERT INTO mkn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dengar Yesus pung omong bagitu, ada barapa guru agama deng orang Farisi yang minta sang Dia bilang, “Bapa Guru! Botong kapingin lia Pak bekin tanda heran, ko jadi bukti bilang, Pak pung kuasa tu batúl-batúl dari Tuhan Allah.” ");
INSERT INTO mkn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma Yesus masparak sang dong bilang, “Heh! Bosong orang sakarang ni, sonde mau dengar-dengar sang Tuhan! Bosong cuma tau bekin jahat sa! Biar bosong minta tanda heran, ma Beta sonde kasi. Tagal dolu Tuhan su kasi tanda heran pake Dia pung jubir Yunus. Itu su cukup! ");
INSERT INTO mkn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus tenga tiga siang, tiga malam dalam ikan bésar pung parú. Bagitu ju Beta, Manusia Tulen ni. Nanti Beta tenga tiga siang, tiga malam dalam goa batu tampa orang mati. ");
INSERT INTO mkn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nanti di hari kiamat, kalo Tuhan jadi hakim, orang Niniwe dong badiri jadi saksi ko tudu sang bosong bilang, ‘Bosong samua ni, ngali!’ Dolu, itu orang Niniwe dong dengar sang Tuhan pung jubir Yunus, ju dong tobat deng kasi tenga dong pung sala-sala. Ma bosong sonde. Padahal sakarang ada Orang di bosong pung teng-tenga yang lebe hebat dari Yunus, andia Beta ni. Ma bosong sonde mau toe sang Beta sadiki ju. ");
INSERT INTO mkn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nanti di hari kiamat, kalo Tuhan jadi hakim, ratu Seba dari salatan sana ju badiri jadi saksi. Dia tunju jari ko tudu sang bosong samua yang idop sakarang ni bilang, ‘Bosong samua ni, bodo, é!’ Dolu, itu ratu datang dari jao-jao ko lia deng mata kapala sandiri raja Soleman pung pintar. Padahal sakarang ada Orang di bosong pung teng-tenga yang lebe hebat dari Raja Soleman, andia Beta ni. Ma bosong sonde mau toe sang Beta sadiki ju.” ");
INSERT INTO mkn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kalo setan kaná usir kaluar dari satu orang, itu setan pi tampa sunyi ko cari tampa barenti cape. Ma dia sonde dapa tampa yang cocok. ");
INSERT INTO mkn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ju dia pikir bilang, ‘Ee! Sonde dapa tampa bagini, lebe bae beta pulang pi tenga kambali di itu orang yang dolu tu.’ Ais dia kambali, ju dia lia itu tampa su barisi deng taꞌator bae-bae. ");
INSERT INTO mkn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ais ju itu setan pi pange dia pung kawan tuju, yang lebe jahat lai dari dia. Tarús dong samua pi tenga di itu orang, ju dong karoyok rame-rame sang dia. Jadi sakarang, itu orang pung idop su lebe calaka lai. Bagitu ju kaná deng orang zaman sakarang dong.” ");
INSERT INTO mkn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Itu waktu, Yesus masi baꞌomong deng orang banya. Ju Dia pung mama deng Dia pung adi dong datang ko mau katumu deng Dia. Dong badiri sa di luar ruma ko suru orang pange sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ju orang datang kasi tau bilang, “Bapa! Bapa pung mama deng adi dong ada di luar. Dong mau katumu deng Bapa.” ");
INSERT INTO mkn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ais Yesus manyao bilang, “Beta pung mama yang batúl tu, sapa? Deng Beta pung sodara-sodara yang batúl tu, sapa?” ");
INSERT INTO mkn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ju Dia tunju pi di orang-orang yang iko sang Dia, deng kasi tau bilang, “Lia, te dong ni Beta pung mama deng Beta pung sodara dong. ");
INSERT INTO mkn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Te orang yang bekin iko Beta pung Bapa di sorga pung mau, dong tu Beta pung kelu yang batúl.” ");
INSERT INTO mkn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Itu hari ju Yesus kaluar dari itu ruma, ko pi dudu di dano Galilea pung pinggir. ");
INSERT INTO mkn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ju orang bam-banya datang makarubu sang Dia. Ais Dia nae pi dudu di atas satu parahu yang ada balabu di situ, ko mangajar. Itu orang di darat dong samua dengar sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ju Dia ajar bam-banya sang dong, pake umpama. Dia angka carita bilang, “Ada satu orang tani pi dia pung kabón ko siram bibit. ");
INSERT INTO mkn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Waktu dia siram itu bibit dong, ada yang jato di jalan. Ju burung dong datang ko toto bekin abis itu bibit dong samua. ");
INSERT INTO mkn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma ada bibit saparu jato kaná di tana babatu. Itu bibit banupuk capát, tagal itu tana isi tipis. ");
INSERT INTO mkn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma waktu matahari nae, ju itu nupuk dong mamalek, ko mati karíng. Te dong pung akar sonde maso sampe dalam tana na. ");
INSERT INTO mkn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ada bibit saparu lai jato di tenga rumput baduri. Ju itu rumput baduri dong gepe bekin mati itu nupuk. ");
INSERT INTO mkn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma ada bibit saparu lai jato kaná di tana isi. Itu bibit dong banupuk, abis ju dong jadi bésar sampe babua. Ada yang kasi bale hasil tiga pulu kali, ada yang anam pulu kali, deng ada yang sampe saratus kali. ");
INSERT INTO mkn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sapa yang ada talinga, na, dengar bae-bae, ó!” ");
INSERT INTO mkn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ais ju Yesus pung ana bua dong datang ko tanya sang Dia bilang, “Akurang ko Bapa ajar sang itu orang banya dong pake umpama?” ");
INSERT INTO mkn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ju Yesus manyao bilang, “Tagal bosong mau mangarti batúl-batúl Tuhan Allah pung parenta, andia ko Beta kasi tau memang itu umpama pung arti. Ma kalo orang laen, na, Beta ajar pake umpama sa. ");
INSERT INTO mkn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Te orang yang mau cari tau batúl-batúl Tuhan pung mau, nanti Tuhan kasi dia tamba mangarti lai. Ma orang yang sonde toe deng Tuhan pung mau, nanti Tuhan bekin dia tabodo-bodo. ");
INSERT INTO mkn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Beta ajar sang dong pake umpama sa, tagal: ‘Dong su lia, ma sonde mau mangarti. Dong su dengar, ma sonde mau tau.’ ");
INSERT INTO mkn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Dong tu sama ke orang yang Tuhan Allah pung jubir Yesaya su tulis bilang, ‘Bosong nanti dengar, ma bosong sonde mau mangarti. Bosong nanti lia, ma bosong sonde mau tau apa yang su jadi. ");
INSERT INTO mkn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tagal ini orang dong pung hati karás, dong bekin tuli dong pung talinga, dong bekin buta dong pung mata. Jadi kasi tenga pi sa, ko dong pung talinga jadi tuli bagitu sa, deng kasi tenga pi sa, ko dong pung mata jadi buta bagitu sa. Biar ko Beta sonde usa bekin bae sang dong, tagal dong sonde mau toe sang Beta.’ ");
INSERT INTO mkn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma bosong ni, barontong, ó! Te bosong su dapa lia deng bosong pung mata sandiri, deng bosong su dapa dengar deng bosong pung talinga sandiri. ");
INSERT INTO mkn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Parcaya sang Beta! Dolu-dolu Tuhan pung jubir deng orang yang pung hati lurus dong ada rindu mau lia apa yang bosong su dapa lia, ma dong sonde bisa. Dong ju rindu mau dengar apa yang bosong su dapa dengar, ma dong sonde bisa.” ");
INSERT INTO mkn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Omong abis bagitu, ju Yesus kasi tau sang dong bilang, “Jadi sakarang bosong dengar itu umpama pung arti. ");
INSERT INTO mkn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bibit yang jato di jalan tu, andia orang yang dengar Kata-kata soꞌal Tuhan Allah pung pegang parenta, ma dia sonde mangarti batúl-batúl. Ais ju setan dong pung bos datang rampas bawa itu Kata-kata dari itu orang pung hati. ");
INSERT INTO mkn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bibit yang jato di tana babatu tu, andia orang yang dengar Tuhan pung Kata-kata, ju dia tarima deng hati sanáng. ");
INSERT INTO mkn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma itu Kata-kata sonde baꞌakar. Andia ko dia sonde tasimpan lama di itu orang pung hati. Bagitu orang laen bekin susa tagal dia tarima itu Kata-kata, dia langsung lapás buang sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Deng bibit yang jato di tenga rumput baduri tu, sama ke orang yang su dengar itu Kata-kata. Ma dia talalu barepot deng macam-macam urusan ko bisa idop ena-ena sa. Ju itu urusan dong samua, seti buang itu Kata-kata dari dia pung hati, sampe sonde ada guna lai. ");
INSERT INTO mkn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma bibit yang jato kaná di tana isi, sama ke orang yang pasang talinga ko tarima itu Kata-kata, deng iko Tuhan pung mau. Ais dia bekin hal-hal yang bae sa, sama ke bibit yang babua tu. Ada yang babua tiga pulu kali lipat, ada ju yang anam pulu, deng ada yang sampe saratus kali.” ");
INSERT INTO mkn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus kasi tau lai satu umpama bilang, “Tuhan Allah pung pegang parenta sama ke ada satu orang yang siram bibit yang bae di dia pung kabón. ");
INSERT INTO mkn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Waktu malam, samua orang ada tidor sonu. Ju orang jahat datang, ko siram bibit rumput liar di itu kabón. ");
INSERT INTO mkn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Waktu itu kabón mulai kasi kaluar hasil, ju dia pung orang karjá dong dapa lia rumput liar ada tumbu sama-sama deng gandum di situ. ");
INSERT INTO mkn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ais ju dong pi kasi tau sang itu kabón pung tuan bilang, ‘Bos! Tempo hari botong tanam bibit yang bae di bos pung kabón, wuang? Akurang ko sakarang su ada banya rumput?’ ");
INSERT INTO mkn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Itu bos manyao bilang, ‘Itu tu, orang jahat pung karjá.’ Ju dia pung orang karjá dong usul bilang, ‘Bos, botong pi tofa buang itu rumput, ko?’ ");
INSERT INTO mkn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ma dia manyao bilang, ‘Jang! Te waktu bosong tofa itu rumput, nanti kotong pung tanaman bae dong ju iko tacabu buang. ");
INSERT INTO mkn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tenga pi ko dong tumbu sama-sama sampe musim koru. Nanti itu waktu, baru beta kasi tau orang karjá dong bilang, “Bosong kumpul dolo itu rumput liar dong. Ais ika satu-satu kabuak, ko bakar buang. Ais baru kumpul hasil yang bae dong, ko kasi maso dalam gudang.” ’ ” ");
INSERT INTO mkn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ais itu, Yesus omong lai bilang, “Beta tamba satu umpama lai, ko bosong bisa mangarti karmana Tuhan Allah jadi Raja kasi banya orang. Dia pung orang dong, mulai sama ke biji kici ana yang orang tanam di dia pung kabón. ");
INSERT INTO mkn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Biar itu biji tu, paling kici ana, ma kalo dia su idop datang, na, dia jadi pohon yang paling bésar di kabón. Sampe burung dong datang basarang di dia pung cabang dong.” ");
INSERT INTO mkn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus tamba satu umpama lai bilang, “Tuhan Allah pung orang dong, sama ke bibit roti yang satu parampuan ame ko campor deng tarigu satu sak. Ju itu roti reis sampe bésar, tagal itu bibit roti yang sadiki ana tu.” ");
INSERT INTO mkn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus ajar orang banya deng pake carita banya macam bagitu. Dia pung omong samua cuma pake umpama sa. ");
INSERT INTO mkn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Dia ajar bagitu ko iko apa yang Tuhan Allah pung jubir su tulis memang bilang, “Nanti Beta ajar pake umpama. Nanti Beta kasi tau hal-hal yang orang balóm parná dengar, mulai dari Tuhan bekin ini dunya sampe deng sakarang.” ");
INSERT INTO mkn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ais Yesus jalan kasi tenga itu orang banya dong, ko pulang pi ruma. Ju Dia pung ana bua dong datang, ko minta tolong sang Dia bilang, “Bapa! Tolong kasi tau sang botong itu umpama soꞌal rumput liar pung arti dolo!” ");
INSERT INTO mkn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ju Yesus manyao bilang, “Orang yang siram bibit yang bae tu, andia Beta, Manusia Tulen ni. ");
INSERT INTO mkn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Deng kabón tu, andia ini dunya ni. Bibit yang bae tu, andia orang-orang yang su maso jadi Tuhan Allah pung kelu. Deng rumput liar tu, andia setan dong pung bos pung orang dong. ");
INSERT INTO mkn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ais, itu orang jahat yang datang ko siram itu bibit rumput tu, andia setan dong pung bos bésar sandiri. Deng musim koru tu, andia hari kiamat. Orang karjá yang ame hasil tu, andia Tuhan Allah pung ana bua dari sorga dong. ");
INSERT INTO mkn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Waktu hari kiamat, dong kumpul ame itu rumput dong ko bakar buang. ");
INSERT INTO mkn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Te Beta, Manusia Tulen ni, nanti kirim datang ana bua dari sorga dong. Nanti dong pi kumpul ame sang samua orang yang sonde iko Tuhan pung parenta. Deng dong ju kumpul ame sang samua orang yang goda sang orang laen, ko dong jang iko Tuhan pung parenta. ");
INSERT INTO mkn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nanti dong lempar buang itu orang jahat samua pi dalam api naraka, sama ke rumput yang kaná bakar. Di situ, baru dong rasa sangsara mau mati, deng manangis makarereu tar pake barenti. ");
INSERT INTO mkn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma orang yang idop lurus iko Tuhan Allah pung mau, nanti dong tenga tarús deng dong pung Bapa Raja di sorga. Di situ, dong basinar taráng sama ke matahari. Naa! Orang yang mau mangarti sang Beta, pasang talinga bae-bae, ó!” ");
INSERT INTO mkn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus tamba satu umpama lai bilang, “Orang yang mau mangarti Tuhan pung pegang parenta, sama ke orang yang kapingin mau dapa barang yang mahal mati pung, yang orang parná sambunyi dalam tana sapoꞌong. Itu orang datang gali, ju dia dapa katumu itu barang di situ, andia ko dia sanáng mau mati. Ais dia kubur bale itu barang. Ju dia pulang capát-capát, ko pi jual abis dia pung harta samua-samua. Tarús dia pi béli ame itu tana, ko biar dia bisa soa memang itu barang mahal tu.” ");
INSERT INTO mkn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus tamba lai bilang, “Orang yang mau mangarti Tuhan pung pegang parenta, sama ke orang dagang satu yang kapingin mau dapa mutiara yang mahal mati pung. Ais dia cari-cari mutiara ko mau béli. ");
INSERT INTO mkn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Waktu dia katumu satu mutiara yang talalu bagus, ju dia pulang capát-capát, ko pi jual abis dia pung harta samua-samua. Tarús dia pi béli itu mutiara, ko biar dia bisa soa memang.” ");
INSERT INTO mkn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus tamba lai bilang, “Tuhan Allah pung pegang parenta tu, sama ke satu pukat yang nalayan dong pi lapás di dano. Ais itu pukat dapa ikan macam-macam. ");
INSERT INTO mkn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Waktu itu pukat su ponu deng ikan, ju nalayan dong datang angka ame, ko bawa pi pante. Ais dong dudu ko maꞌisi ikan dari pukat. Ikan yang bae, dong kasi maso pi karanjang. Ma ikan yang sonde bae, dong lempar buang. ");
INSERT INTO mkn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bagitu ju deng hari kiamat. Nanti Tuhan Allah pung ana bua dong datang dari sorga, ko pi kasi pisa orang yang jahat dari orang yang hati lurus. ");
INSERT INTO mkn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nanti dong lempar buang itu orang jahat samua pi dalam api naraka. Di situ, baru dong rasa sangsara mau mati, deng manangis makarereu tar pake barenti.” ");
INSERT INTO mkn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Omong abis bagitu, ju Yesus tanya sang dong bilang, “Bosong mangarti samua yang Beta su omong tadi, ko?” Dong manyao bilang, “Mangarti, Bos!” ");
INSERT INTO mkn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ais ju Yesus manyao bale bilang, “Bae! Te tiap guru agama yang su batúl-batúl balajar Tuhan pung Kata-kata yang tatulis memang dari dolu, ais dia ju pegang kuat Beta pung ajaran sakarang ni, na, dia sama ke satu tuan ruma yang suka buka dia pung gudang, ko kasi tunju dia pung harta yang lama, sama-sama deng dia pung harta yang baru.” ");
INSERT INTO mkn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Waktu Yesus su ajar abis orang banya dong pake umpama, ju Dia jalan kasi tenga itu tampa, ");
INSERT INTO mkn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ko pulang pi Dia pung kampong. Di situ, Dia maso pi ruma sambayang ko ajar orang. Samua orang yang dengar sang Dia, heran mau mati. Dong baꞌomong bilang, “Awii! Ini Orang pung pintar ame lai! Dia balajar di mana ni? Karmana ko sampe Dia bisa bekin itu tanda heran dong? ");
INSERT INTO mkn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Padahal Dia ni cuma tukang kayu pung Ana sa. Kotong kanál bae Dia pung mama Maria; deng Dia pung adi-adi dong, andia Yakobis, Yusuf, Yudas deng Simon. ");
INSERT INTO mkn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kotong ju kanál sang Dia pung adi parampuan dong, te kotong samua tenga satu kampong na! Jadi Dia dapa Dia pung pintar tu, dari mana lai? Deng Dia dapa Dia pung kuasa hebat tu, dari sapa lai?” ");
INSERT INTO mkn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Andia ko dong kakodok, sampe dong su sonde mau dengar sang Dia lai. Ma Yesus kasi tau bilang, “Memang batúl! Di tampa laen, orang dong suka kasi hormat sang Tuhan Allah pung jubir. Ma di dia pung kampong deng isi ruma sandiri, orang sonde mau hormat sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tagal dong pung hati karás sampe dong sonde mau parcaya sang Yesus, andia ko Dia sonde bekin tanda heran bam-banya di situ. ");
INSERT INTO mkn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Itu waktu, raja Herodes pegang parenta di propinsi Galilea. Dia ju dengar kabar macam-macam soꞌal Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Dia kasi tau dia pung pagawe dong bilang, “Ini Yesus ni, tantu Yohanis Tukang Sarani yang tempo hari beta suru potong ame dia pung kapala. Sakarang dia su idop kambali, ó! Andia ko dia ada pung kuasa ko bekin itu tanda heran dong.” ");
INSERT INTO mkn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Raja Herodes omong bagitu, te dolu dia ada baparkara deng Yohanis, sampe dia tangkap deng buang sang Yohanis pi bui. Itu parkara pung carita bagini: raja Herodes su kawin ame sang dia pung adi Filipus pung maitua, nama Herodias. Padahal Filipus deng Herodias balóm bacere. ");
INSERT INTO mkn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Andia ko Yohanis togor ulang-ulang bilang, “Bapa raja sonde bole baꞌame deng bapa pung adi pung bini. Te itu su langgar kotong pung adat Yahudi na!” ");
INSERT INTO mkn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ma Herodes sonde mau toe sang dia, ju dia kawin deng Herodias sa. Iko yang batúl, Herodes kapingin mau bunu sang Yohanis. Ma dia eleng sang orang banya, tagal dong parcaya bilang, Yohanis tu, Tuhan Allah pung jubir. Andia ko dia suru dia pung orang, ko kasi maso Yohanis pi dalam bui. ");
INSERT INTO mkn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma lama-lama, ju Herodes ada pesta hari jadi. Itu waktu, mama raja Herodias pung ana nona pi baronggeng mangada pi tamu dong. Dia pung ronggeng tu talalu bagus, sampe bekin Herodes pung hati sanáng mau mati. ");
INSERT INTO mkn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Baronggeng abis, ju Herodes pange itu ana nona ko bilang, “Lu mau minta apa sang beta, na, kasi tau sa! Te nanti beta kasi sang lu. Beta pegang batúl-batúl beta pung janji ni. Deng beta sumpa pake Tuhan Allah pung nama.” ");
INSERT INTO mkn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dengar raja pung omong bagitu, ju itu nona pung mama tusu-tusu sang dia. Andia ko dia pi minta bilang, “Bapa! Beta minta Yohanis Tukang Sarani pung kapala. Taro dalam dulang, ko bawa datang kasi sang beta.” ");
INSERT INTO mkn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Dengar itu nona minta bagitu, ju Herodes pung hati ilang memang. Ma dia sonde bisa hela kambali dia pung sumpa, te samua tamu su dengar na. Andia ko dia iko itu nona pung mau sa. ");
INSERT INTO mkn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tarús dia parenta ko orang pi potong ame Yohanis pung kapala di dalam bui. ");
INSERT INTO mkn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dong potong ame Yohanis pung kapala, ju dong taro dalam dulang, ko pi kasi sang itu nona. Dia tarima ame itu dulang ju, dia koko bawa ko pi kasi sang dia pung mama. ");
INSERT INTO mkn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Waktu Yohanis pung ana bua dong dengar dong su potong ame dia pung kapala, ju dong datang ame dia pung mayat, ko pi kubur. Ais dong pi lapor itu hal sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Waktu Yesus dengar itu kabar soꞌal Yohanis, ju Dia deng Dia pung ana bua dong mau ondor diri dari itu tampa. Ju dong nae parahu ko mau pi tampa sunyi ko bisa barenti cape. Ma orang banya dapa lia Yesus dong pung parahu ada iko-iko dano pung pinggir. Ais dong kaluar dari kampong dong, ju jalan capát-capát iko jalan darat. Andia ko dong sampe di tampa tujuan lebe dolo dari Yesus dong. ");
INSERT INTO mkn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Waktu Dia turun dari parahu, ju Dia lia itu orang bam-banya dong ada tunggu-tunggu sang Dia. Ais Dia jato kasian sang dong. Ju Dia bekin bae dong pung orang saki dong. ");
INSERT INTO mkn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Waktu su sore, ju Dia pung ana bua dong datang kasi tau sang Dia bilang, “Bapa, é! Lebe bae Bapa suru ini orang dong samua ko dong pi béli makan di kampong-kampong badeka di sini. Te su sore ni! Di sini sonde ada makan apa-apa.” ");
INSERT INTO mkn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma Yesus manyao bilang, “Sonde usa! Bosong yang kasi makan sang dong sa.” ");
INSERT INTO mkn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma dong manyao bilang, “Aiih, Bapa, é! Botong sonde ada apa-apa ko kasi makan orang bagini banya ni. Botong mau bekin karmana? Te cuma ada roti lima bua, deng ikan dua ekor sa, ma!” ");
INSERT INTO mkn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma Yesus omong bilang, “Hoo! Su bae tu. Bawa datang su!” ");
INSERT INTO mkn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tarús Dia suru itu orang dong samua ko dudu bakumpul di atas rumput. Ais ju Yesus ame itu roti lima bua, deng itu ikan dua ekor. Ju Dia mangada pi langit ko minta tarima kasi sang Tuhan Allah. Ais itu, Dia kasi pica-pica itu roti, ju sorong kasi pi di Dia pung ana bua, ko dong pi bagi-bagi kasi sang itu orang dong samua. ");
INSERT INTO mkn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ais ju dong samua makan sampe kinyang. Makan abis ju, dong pi kumpul ame itu makanan sisa dong, sampe ponu dua blas bakul. ");
INSERT INTO mkn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Samua orang yang iko makan tu, kira-kira ada lima ribu laki-laki. Balóm reken tamba parampuan deng ana-ana dong lai. ");
INSERT INTO mkn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dong samua makan abis ju, Yesus suru Dia pung ana bua dong pi nae parahu ko dong pi lebe dolo di dano pung sablá. Ma Dia masi tenga di situ, ko suru itu orang banya dong pulang. ");
INSERT INTO mkn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Waktu dong samua su pulang, ju Yesus nae pi atas gunung satu, ko sambayang. Sampe malam, te Dia masi sandiri di situ. ");
INSERT INTO mkn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Itu waktu, Dia pung ana bua dong pung parahu su sampe jao di dano pung teng-tenga. Ma dong ada badayong satenga mati, tagal parahu balayar lawan angin muka, deng galombang bésar hantam sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Amper siang, ju Yesus pi iko sang dong. Ma Dia ada jalan di atas aer. ");
INSERT INTO mkn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lia bagitu ju, itu ana bua dong takuju mati. Dong omong taku-taku bilang, “Heꞌe! Ada hantu tu!” ");
INSERT INTO mkn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma Yesus omong langsung sang dong bilang, “Woe! Bosong jang taku, ó! Te Beta ni, Yesus! Aman-aman sa!” ");
INSERT INTO mkn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dengar bagitu, ju Petrus manyao bilang, “Kalo situ memang Bos, na, suru beta jalan di atas aer ko pi di Bos.” ");
INSERT INTO mkn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ais Yesus manyao bilang, “Neu! Mari sini su!” Ju Petrus kaluar dari parahu ko pi di Yesus deng jalan di atas aer. ");
INSERT INTO mkn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma waktu Petrus rasa ada angin karás, ju dia taku mau mati. Dia mulai tanggalám, ju dia batarea bilang, “Aduu, Bos, é! Kasi salamat sang beta doo!” ");
INSERT INTO mkn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Langsung Yesus sorong Dia pung tangan capát-capát ko pegang ame sang dia. Dia omong bilang, “Aiih, Peꞌu, é! Akurang ko lu pung hati bacabang? Lu sonde parcaya batúl sang Beta, ko?” ");
INSERT INTO mkn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ais itu, dong dua maso pi dalam parahu. Ju angin tadó memang. ");
INSERT INTO mkn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lia bagitu, ju Dia pung ana bua dong angka puji-puji sang Dia bilang, “Awii! Bapa ni, memang batúl-batúl Tuhan Allah pung Ana, ó!” ");
INSERT INTO mkn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Waktu dong sampe di dano pung sablá ju, dong turun di kampong Genesaret pung pante. ");
INSERT INTO mkn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Waktu dong turun, te orang banya dong langsung kanál sang dong. Ju dong mulai batarea bilang, “We! Yesus su datang, ó!” Dong lari pi kasi tau kuliling, ju orang bawa datang samua orang saki dong. ");
INSERT INTO mkn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dong minta ko dong bisa sonto ame Dia pung baju. Te dong pikir bilang, “Asal orang saki sonto ame Yesus pung ujung baju sa, tantu dong bae memang.” Ju samua orang saki yang sonto Dia pung baju, bae memang. ");
INSERT INTO mkn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Satu waktu, ada rombongan orang Farisi deng guru agama datang dari Yerusalem ko katumu deng Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Orang Farisi dong pegang karás dong pung adat Yahudi. Waktu dong dengar bilang, Yesus pung ana bua dong makan sonde cuci tangan iko adat pung mau, ju dong jengkel. Ais dong datang ko kasi sala sang Yesus bilang, “Akurang ko lu pung ana bua dong makan, ma sonde cuci tangan dolo? Itu su malawan kotong pung nene-moyang pung adat tu!” ");
INSERT INTO mkn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma Yesus manyao bilang, “Bosong ni memang orang yang omong laen bekin laen! Bosong pintar malawan Tuhan Allah pung parenta, ko iko bosong pung nene-moyang pung adat sa. ");
INSERT INTO mkn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Te Tuhan Allah su parenta bilang, ‘Kasi hormat sang bosong pung mama-bapa.’ Deng tamba lai bilang, ‘Kalo satu orang maki dia pung bapa ko mama, musti hukum kasi mati sang dia.’ ");
INSERT INTO mkn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Tuhan Allah ajar bagitu, ma bosong ajar laen lai. Te bosong bilang, ‘Satu orang sonde parlú pake dia pung barang ko tolong dia pung mama-bapa, biar dong sangsara mati pung, kalo dia su janji mau kasi itu barang sang Tuhan.’ Ma deng bosong ajar bagitu, bosong su buang Tuhan Allah pung parenta, ko ganti deng bosong pung atoran sandiri. ");
INSERT INTO mkn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Andia ko tadi Beta su bilang, bosong ni, orang yang omong laen bekin laen! Itu pas deng apa yang Tuhan pung jubir Yesaya su tulis memang soꞌal bosong dari dolu-dolu! Te Tuhan ada pake dia ko tulis bilang, ");
INSERT INTO mkn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ada orang yang puji sang Beta, cuma deng mulu sa, ma sonde deng hati. ");
INSERT INTO mkn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Biar dong bekin bagitu ju, parcuma sa. Dong sonde toe deng Beta, te dong cuma toe deng manusia pung atoran sa.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ais itu, Yesus pange orang laen di situ ko ajar sang dong bilang, “Pasang talinga bae-bae, ko bosong bisa mangarti! ");
INSERT INTO mkn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Apa yang maso pi dalam orang pung mulu, itu sonde bekin kamomos orang. Ma apa yang kaluar dari orang pung mulu, itu yang bekin kamomos.” ");
INSERT INTO mkn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ais itu, Yesus pung ana bua dong datang ko kasi tau sang Dia bilang, “Bapa tau, ko? Itu orang Farisi dong saki hati dengar Bapa pung omong.” ");
INSERT INTO mkn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma Yesus manyao bilang, “Beta pung Bapa di sorga nanti cabu buang orang yang sonde ajar orang iko Tuhan pung mau. Itu sama ke orang tofa buang samua tanaman yang dia sonde tanam. ");
INSERT INTO mkn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jadi, jang toe deng itu orang Farisi dong! Te dong tu, sama ke orang buta yang kasi tunju jalan sang orang buta. Nanti dong jato rame-rame maso pi dalam lobang.” ");
INSERT INTO mkn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ais ju Petrus omong bilang, “Bapa, tolong kasi tau sang botong itu umpama tadi pung arti dolo!” ");
INSERT INTO mkn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus manyao bilang, “Naa! Bosong ju balóm mangarti? ");
INSERT INTO mkn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dia pung maksud bagini: apa yang kotong makan, maso di mulu, tarús pi dalam parú, abis kaluar ulang pi tampa buang aer. ");
INSERT INTO mkn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma apa yang kaluar dari mulu, itu yang bekin kamomos orang, sampe Tuhan Allah ju noju sang dia, deng sonde mau tarima sang dia. ");
INSERT INTO mkn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Te banya parkara yang jahat kaluar dari orang pung hati! Sama ke: pikir jahat, bunu orang, barsina, maen serong deng orang yang bukan dia pung laki ko dia pung bini, mancuri, saksi putar-balek, deng omong bekin busuk orang pung nama. ");
INSERT INTO mkn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hal-hal bagitu tu, yang bekin orang jadi kamomos. Ma kalo orang cuma makan deng sonde cuci tangan iko adat pung mau, na, itu sonde jadi soꞌal.” ");
INSERT INTO mkn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ais ju Yesus kasi tenga itu tampa, ko pi di daꞌera yang badeka deng kota Tirus deng kota Sidon. ");
INSERT INTO mkn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Di situ ada satu mama yang asal dari itu daꞌera. Dia bukan orang Yahudi. Waktu dia dengar Yesus su ada, dia datang minta deng sunggu-sunggu bilang, “Raja Daud pung turunan, é! Kasian sang beta doo! Te beta pung ana nona ada takaná setan. Aduu, kasian, é! Te dia su sangsara.” ");
INSERT INTO mkn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma Yesus diam sa, deng sonde manyao apa-apa. Ju Dia pung ana bua dong datang lapor bilang, “Bapa, ini mama ni maen batarea bekin tasibu sa. Lebe bae Bapa suru dia iskarobis dari sini su!” ");
INSERT INTO mkn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ju Yesus manyao bilang, “Tuhan Allah suru Beta datang ko tolong kotong pung orang Yahudi, tagal dong su jalan sala, sama ke domba yang kasasar. Dia sonde suru Beta pi tolong orang laen.” ");
INSERT INTO mkn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma itu mama datang lai deka-deka sang Yesus. Dia tikam lutut deng minta tolong bilang, “Bos, é! Tolong sang beta doo.” ");
INSERT INTO mkn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma Yesus buang bahasa bilang, “Sonde pantas ame makanan dari ana-ana dong, ais buang kasi anjing.” Dia pung maksud tasambunyi bilang, Yesus musti bantu Dia pung orang Yahudi dolo, baru bisa bantu orang laen. ");
INSERT INTO mkn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma itu mama balas bilang, “Batúl, Papa, é! Ma anjing dong ada tunggu-tunggu di kolong meja. Dong ju makan apa yang jato dari ana-ana dong pung piring.” Deng maksud bilang, waktu ana dong makan, anjing ju dapa makan. Biar Yesus bantu Dia pung orang, ma Dia ju musti lia orang laen. ");
INSERT INTO mkn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dengar bagitu, ju Yesus kasi tau bilang, “Awii! Mama parcaya batúl sang Beta, ó! Jadi mama pulang su, te apa yang mama minta tu, su jadi memang!” Ais dia pulang, ju dia lia dia pung ana su bae memang. ");
INSERT INTO mkn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ais itu, Yesus deng Dia pung ana bua dong kasi tenga itu tampa, ju dong jalan iko-iko dano Galilea pung pinggir. Tarús dong nae satu gunung, ais Yesus dudu ko mangajar sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ju orang bam-banya datang sang Dia. Dong bawa orang kaki hela, orang buta, orang lumpu, orang sonde bisa omong, deng orang yang saki laen ju. Dong taro itu orang saki dong deka-deka di Yesus pung kaki. Ais Dia bekin bae sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lia bagitu, ju itu orang banya dong, heran. Dong baꞌomong bilang, “Awii! Talalu hebat, ó! Orang kaki hela, bisa bajalan bae. Orang buta, bisa dapa lia. Orang lumpu, bisa bajalan. Deng orang sonde bisa omong, su bisa baꞌomong! Ini pasti Tuhan Allah yang bekin. Dia tu, andia Tuhan yang kotong pung nene-moyang dong sémba dari dolu-dolu.” ");
INSERT INTO mkn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Abis barapa hari ju, Yesus pange ame Dia pung ana bua dong ko bilang, “Beta su rasa kasian sang ini orang banya dong. Ada yang su datang dari jao, baru dong bakumpul su tiga hari, sampe su sonde ada makanan lai. Lebe bae dong jang pulang dolo deng parú kosong. Te jang sampe dong samaput di tenga jalan.” ");
INSERT INTO mkn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma Yesus pung ana bua dong manyao bilang, “Bapa! Ini tampa kosong yang jao dari kampong. Sonde mungkin kotong bisa kasi makan orang bagini banya.” ");
INSERT INTO mkn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma Yesus tanya sang dong bilang, “Bosong pung roti, ada barapa banya?” Dong manyao bilang, “Tuju sa! Deng ikan sadiki!” ");
INSERT INTO mkn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ais Yesus suru itu orang dong samua ko dudu di tana. ");
INSERT INTO mkn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ju Dia ame itu roti tuju bua deng ikan, ko minta tarima kasi sang Tuhan Allah. Ais Dia bekin pica-pica, ju Dia kasi pi Dia pung ana bua dong, ko dong pi babagi kasi itu orang dong samua. ");
INSERT INTO mkn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ju dong samua makan sampe puas. Ais dong kumpul ame makanan lebe, sampe ponu tuju bakul. ");
INSERT INTO mkn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Samua orang yang iko makan tu, kira-kira ada ampa ribu orang laki-laki. Balóm reken tamba parampuan deng ana-ana dong. ");
INSERT INTO mkn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ais itu, Yesus suru itu orang banya dong pulang. Ju Dia nae parahu ko dong pi di daꞌera Magadan. ");
INSERT INTO mkn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Satu kali, ada barapa orang Farisi deng orang Saduki datang sang Yesus. Dong mau basoꞌal-jawab deng Dia, ko mau hiki sang Dia. Tagal itu, dong minta sang Dia bilang, “Pak! Tolong kasi tunju tanda heran doo, ko jadi bukti bilang, Pak su dapa kuasa dari Tuhan Allah.” ");
INSERT INTO mkn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma Yesus manyao bilang, “Kalo matahari tanggalám deng langit pung warna mera, bosong tanda bilang, ‘Beso sonde akan ujan.’ ");
INSERT INTO mkn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Deng kalo matahari nae deng langit baꞌawan itam, bosong tanda bilang, ‘Ini hari mau ujan.’ Naa, kalo bosong bisa baca tanda cuaca bagitu, akurang ko bosong sonde bisa baca tanda-tanda jaman? ");
INSERT INTO mkn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wuih! Bosong orang sakarang ni, cuma tau bekin jahat sa! Bosong sonde toe sang Tuhan! Biar bosong minta tanda heran, ma Beta sonde kasi. Tagal dolu Tuhan su kasi tanda heran pake Dia pung jubir Yunus. Jadi itu su cukup!” Omong abis bagitu, ju Yesus jalan kasi tenga sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Waktu Yesus dong ada pi dano pung sablá, baru Dia pung ana bua dong inga bilang, dong lupa bawa roti buat dong pung bakál. ");
INSERT INTO mkn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Dengar dong omong bagitu, ju Dia kasi tau bilang, “Inga é! Bosong musti ati-ati sang orang Farisi deng orang Saduki dong pung bibit roti.” ");
INSERT INTO mkn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dengar bagitu, ju Dia pung ana bua dong babingung. Dong baꞌomong bilang, “Bapatua ada omong apa tu? Mangkali Dia omong bagitu, tagal botong sonde bawa roti, ko?” ");
INSERT INTO mkn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma Yesus tau dong pung pikiran. Ais Dia omong bilang, “Weh! Bosong ni su talalu! Akurang ko bosong omong soꞌal roti! Bosong kurang parcaya sang Beta, ko? ");
INSERT INTO mkn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bosong masi balóm mangarti Beta pung kuasa, ko? Te itu hari waktu Beta bekin pica-pica itu roti lima bua ko kasi makan lima ribu orang tu, ada barapa bakul yang bosong kumpul ame dia pung lebe? ");
INSERT INTO mkn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ais karmana lai deng itu tuju roti yang Beta bagi kasi ampa ribu orang tu? Ada barapa bakul yang bosong kumpul ame dia pung lebe? ");
INSERT INTO mkn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Akurang ko bosong sonde mangarti Beta pung omong tadi tu? Beta sonde omong soꞌal roti. Te Beta mau kasi inga sang bosong, ko biar bosong ati-ati deng orang Farisi deng orang Saduki dong pung ajaran. Te dong pung ajaran bisa pangaru orang banya, sama ke bibit roti kasi reis roti.” ");
INSERT INTO mkn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus omong bagitu, baru dong mangarti bilang, Dia sonde omong soꞌal roti. Ma Dia ada omong soꞌal orang Farisi deng orang Saduki dong pung ajaran yang sala. ");
INSERT INTO mkn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ais itu, ju Yesus dong jalan pi daꞌera yang badeka deng kota Kaisarea Filipi. Di tenga jalan, Dia tanya sang dong bilang, “Iko orang pung omong, dong bilang, Beta, andia Manusia Tulen ni, sapa?” ");
INSERT INTO mkn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dong manyao bilang, “Ada yang bilang Bapa ni, Yohanis Tukang Sarani yang su idop kambali. Laen bilang, mangkali Bapa ni, baꞌi Elia. Laen lai bilang, baꞌi Yeremia. Kalo sonde, na, Tuhan Allah pung jubir dolu-dolu yang laen.” ");
INSERT INTO mkn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tarús Yesus tanya lai sang dong bilang, “Kalo iko bosong sandiri, na, Beta ni, sapa?” ");
INSERT INTO mkn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ais ju Simon Petrus manyao bilang, “Bapa ni, Kristus, andia itu Orang yang dolu-dolu Tuhan Allah su janji mau kirim datang! Deng Bapa ni, Tuhan Allah yang idop tarús pung Ana!” ");
INSERT INTO mkn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ais Yesus bilang, “Simon, Yunus pung ana, é! Lu ni, barontong, ó! Te bukan manusia yang kasi tau ini hal sang lu. Ma Beta pung Bapa di sorga yang kasi tau. ");
INSERT INTO mkn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dengar, é! Sakarang Beta mau kasi nama ‘Petrus’ sang lu. Te itu nama pung arti andia, ‘batu’. Nanti lu jadi fanderen kasi Beta pung orang parcaya dong, tagal lu pung parcaya su kuat ke batu. Biar dong kaná siksa sampe mati ju, dong batahan tarús. ");
INSERT INTO mkn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Beta nanti kasi hak sang lu, ko urus Beta pung orang dong, sama ke lu pegang sorga pung konci. Te apa yang lu larang di ini dunya, itu Tuhan su larang di sorga. Deng apa yang lu kasi isin di ini dunya, itu Tuhan su kasi isin di sorga.” ");
INSERT INTO mkn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Omong abis bagitu, ju Yesus larang sang dong ko jang kasi tau sapa-sapa bilang Dia tu, Kristus. ");
INSERT INTO mkn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mulai dari itu waktu, ju Yesus kasi tau Dia pung ana bua dong bilang, “Beta musti pi kota Yerusalem. Ma nanti di situ, Beta dapa sangsara bam-banya dari tua-tua adat, kapala agama Yahudi pung bos-bos, deng guru agama dong samua. Nanti dong bunu bekin mati sang Beta, ma dia pung lusa, Beta idop kambali.” ");
INSERT INTO mkn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yesus kasi tau bagitu ju, Petrus hela ame sang Dia pi pinggir ko biar dong dua sandiri, ais togor bilang, “Bapa jang omong bagitu! Sonde mungkin Tuhan Allah kasi biar bagitu!” ");
INSERT INTO mkn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma Petrus pung omong tu, sonde iko Tuhan pung mau. Andia ko Yesus bale ko togor sang dia bilang, “Heh! Iskarobis dari sini! Itu tu, setan pung bos yang omong! Lu jang palang sang Beta! Lu cuma pikir iko manusia pung mau sa, bukan iko Tuhan pung mau!” ");
INSERT INTO mkn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ais ju Yesus ajar sang Dia pung ana bua dong bilang, “Orang yang mau iko sang Beta, dia musti batahan iko tarús tiap hari! Dia musti lupa buang dia pung mau-mau sandiri, ko iko Tuhan pung mau sa. Biar orang mau bunu sang dia, dia musti iko tarús sa, sama ke orang pikol dia pung kayu palang ko pi mati. ");
INSERT INTO mkn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Te orang yang sadia mati tagal dia iko sang Beta, nanti dia dapa idop tarús deng Tuhan. Ma orang yang cuma mau idop buat dia pung diri sandiri sa, nanti dia pung idop tu, ilang bagitu sa! ");
INSERT INTO mkn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Dengar, é! Kalo lu dapa dunya pung isi samua, ma Tuhan Allah tola buang sang lu, na, dia pung ontong apa? Biar lu pikol bawa dunya pung isi samua ju, lu sonde bisa tukar deng lu pung jiwa! ");
INSERT INTO mkn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Beta kasi tau sang bosong ini hal samua, tagal Beta ni, Manusia Tulen. Nanti Beta turun datang kambali pake Beta pung Bapa pung kuasa yang hebat, sama-sama deng Dia pung ana bua dari sorga. Itu waktu, nanti Beta balas kasi tiap orang iko apa yang dia bekin. ");
INSERT INTO mkn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Inga bae-bae, é! Nanti ada barapa orang dari bosong ni yang sonde akan mati, sampe kapan dong dapa lia sang Beta, andia Manusia Tulen, jadi Raja yang pegang parenta.” ");
INSERT INTO mkn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lewat anam hari ju, Yesus pange sang Petrus, Yakobis deng dia pung adi Yohanis, ko dong sama-sama pi nae di atas satu gunung tinggi, ko dong sandiri di situ sa. ");
INSERT INTO mkn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sampe di atas, ju dong lia Yesus su jadi laen. Dia pung muka basinar sama ke matahari, deng Dia pung pakean jadi puti mangkilat. ");
INSERT INTO mkn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Takuju sa, dong dapa lia Dia ada baꞌomong deng baꞌi Musa deng baꞌi Elia. ");
INSERT INTO mkn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ju Petrus jadi bingung, sampe dia omong sambarang bilang, “Bapa! Botong su enak di sini, ó! Jadi lebe bae botong bekin tiga lopo. Satu kasi sang Bapa, satu kasi baꞌi Musa, deng satu lai kasi baꞌi Elia.” ");
INSERT INTO mkn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Waktu Petrus masi omong bagitu, takuju sa, awan turun datang ko tutu ame sang dong. Ju dong taheran-heran dengar satu suara kaluar dari itu awan bilang, “Dengar, ó! Yesus ni, Beta pung Ana sayang. Dia salalu bekin sanáng Beta pung hati. Dengar bae-bae sang Dia, é!” ");
INSERT INTO mkn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dengar bagitu, ju itu ana bua dong taku mau mati, sampe dong jato matono. ");
INSERT INTO mkn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma Yesus datang korek sang dong, ju Dia bilang, “We! Bosong bangun su. Jang taku!” ");
INSERT INTO mkn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ais dong angka muka, ma dong sonde lia sapa-sapa di situ. Te cuma ada Yesus sa. ");
INSERT INTO mkn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ais itu, dong mulai turun dari itu gunung. Ju Yesus larang sang dong bilang, “Apa yang bosong baru lia tadi tu, jang kasi tau sapa-sapa, é! Te Beta, Manusia Tulen ni, musti mati dolo. Ais nanti kalo Beta su idop kambali, baru bosong bole kasi tau orang.” ");
INSERT INTO mkn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ju dong tanya sang Dia bilang, “Bapa ni, memang Kristus, ma baꞌi Elia di mana? Te itu guru agama dong ajar bilang, baꞌi Elia musti datang dolo, baru Kristus datang. Ma iko Bapa, karmana?” ");
INSERT INTO mkn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus manyao bilang, “Memang batúl. Baꞌi Elia musti datang dolo, ko buka jalan kasi sang Kristus. ");
INSERT INTO mkn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma dengar bae-bae, é! Baꞌi Elia su datang, ma orang sonde kanál sang dia. Dong bekin susa sang dia iko dong pung mau. Bagitu ju, nanti dong bekin sang Beta, Manusia Tulen ni.” ");
INSERT INTO mkn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dengar abis bagitu, baru dong tau bilang, baꞌi Elia yang Yesus ada omong tu, andia Yohanis Tukang Sarani. ");
INSERT INTO mkn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ais waktu Yesus dong su kambali, dong katumu deng orang banya yang ada tunggu sang dong. Ju ada satu bapa datang tikam lutut ko minta tolong sang Dia ");
INSERT INTO mkn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","bilang, “Bos! Kasian beta pung ana doo! Te dia saki gila kambing, deng dia sangsara mau mati. Kalo itu panyaki su foe, na, dia suka tajato dalam aer ko dalam api. Tolong doo! ");
INSERT INTO mkn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Beta su bawa sang dia pi Bos pung ana bua dong, ma dong sonde bisa bekin bae sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dengar bagitu, ju Yesus masparak sang Dia pung ana bua dong bilang, “Heh! Bosong ni su talalu! Beta su ajar ulang-ulang sang bosong, ma bosong sonde mangarti bae-bae. Deng bosong sonde parcaya batúl-batúl sang Beta! Beta musti sabar sang bosong sampe kapan lai? Mari bawa itu ana datang sini!” ");
INSERT INTO mkn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dong bawa itu ana, ais ju Dia usir buang setan kaluar dari itu ana. Tarús itu setan kaluar kasi tenga itu ana, ju dia bae memang. ");
INSERT INTO mkn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ais itu, waktu Yesus sandiri sama-sama deng Dia pung ana bua dong, dong tanya sang Dia bilang, “Bapa! Akurang ko tadi botong sonde bisa usir kasi kaluar itu setan?” ");
INSERT INTO mkn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus manyao bale bilang, “Bosong sonde bisa usir itu setan, tagal bosong sonde parcaya batúl na. Inga, é! Kalo bosong parcaya batúl-batúl sang Beta, biar cuma sadiki ana ju, sama ke satu biji yang kici ana, na, bosong bisa parenta satu gunung bilang, ‘We, gunung! Pinda pi sana!’ Tantu sa dia pinda. Jadi bosong bisa bekin apa sa, asal bosong parcaya batúl-batúl sang Tuhan. ");
INSERT INTO mkn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ma dengar, é! Setan macam bagini dong memang jahat talalu. Kalo bosong sonde sambayang deng puasa ko minta tolong sang Tuhan, na, bosong sonde bisa usir setan macam bagitu dong.” ");
INSERT INTO mkn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ais satu kali, Yesus deng Dia pung ana bua ada bakumpul di propinsi Galilea. Dia kasi tau sang dong bilang, “Sonde lama lai, te dong mau jual sang Beta pi orang laen. ");
INSERT INTO mkn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ais dong bunu bekin mati sang Beta, Manusia Tulen ni. Memang Beta mati, ma nanti dia pung lusa, Beta idop kambali.” Dengar Dia pung omong bagitu, ju Dia pung ana bua dong hati susa mau mati. ");
INSERT INTO mkn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Waktu Yesus deng Dia pung ana bua dong datang di kampong Kapernaum, ju tukang tagi bea dong, datang sang Petrus ko tanya bilang, “Bosong pung Guru bayar Ruma Sambayang Pusat pung pajak, ko sonde?” ");
INSERT INTO mkn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ju Petrus manyao bilang, “Bayar!” Waktu dia pulang, ju Yesus langsung kasi tau sang dia lebe dolo bilang, “We, Simon! Coba lu pikir. Raja-raja di ini dunya ame pajak dari sapa? Dari dong pung ana sandiri, ko, dari orang laen?” ");
INSERT INTO mkn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus manyao bilang, “Dari orang laen!” Yesus sambung lai bilang, “Kalo bagitu, raja pung ana sandiri sonde usa bayar, to? ");
INSERT INTO mkn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bagitu ju deng Ruma Sambayang Pusat pung pajak. Ma kotong sonde usa bekin mara itu tukang pajak dong. Jadi lebe bae, lu pi pancing ikan di dano sa. Lu tangkap ame ikan partama, na, buka dia pung mulu. Nanti lu dapa doi perak satu di dalam itu ikan pung mulu. Ais pake itu doi, ko pi bayar kotong dua pung pajak. Te itu su pas buat kotong dua.” ");
INSERT INTO mkn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Itu waktu, Yesus pung ana bua dong datang sang Dia ko tanya bilang, “Bapa! Sapa yang paling bésar dari Tuhan Allah pung orang samua?” ");
INSERT INTO mkn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ju Yesus pange satu ana kici, ais kasi badiri di dong pung teng-tenga. ");
INSERT INTO mkn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ais Dia bilang, “Dengar bae-bae! Orang yang mau maso jadi Tuhan pung orang, dia musti oba dia pung cara pikir, ko jadi sama ke ana kici yang sonde tau angka-angka diri. ");
INSERT INTO mkn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tagal orang yang randá hati sama ke ana kici ni, dia tu orang yang paling bésar di Tuhan pung muka. ");
INSERT INTO mkn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Deng orang yang tarima orang kici sama ke ini ana ni, tagal dia parcaya sang Beta, na, itu orang su tarima sang Beta.” ");
INSERT INTO mkn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ais Yesus kasi tau lai sang dong bilang, “Kalo ada orang yang bekin satu ana kici iko jalan yang sala, sampe dia sonde parcaya lai sang Beta, awas, ó! Lebe bae orang ika batu bésar satu di dia pung batang leher, ko kasi tanggalám sang dia di tenga laut. ");
INSERT INTO mkn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ini dunya ni memang tampa calaka, tagal ada banya hal yang bekin orang jato dalam dosa. Ma orang yang paling calaka tu, andia orang yang bekin gara-gara, ko orang laen bekin sala. ");
INSERT INTO mkn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kalo lu bekin sala pake lu pung tangan, ko, lu pung kaki, na, potong buang sang dia sa! Te lebe bae lu maso sorga deng tangan sablá sa, ko, kaki sablá sa, ko biar dong jang buang sang lu pi api naraka deng lu pung tangan deng kaki dua-dua. ");
INSERT INTO mkn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kalo lu bekin sala pake lu pung mata, doꞌi buang lu pung mata sa! Te lebe bae lu maso pi sorga deng mata sablá sa, ko biar dong jang buang sang lu pi api naraka deng lu pung mata dua-dua.” ");
INSERT INTO mkn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesus omong lai bilang, “Ati-ati, ó! Jang sampe bosong pandang enteng ana kici bagini. Te dong ada Tuhan pung ana bua dari sorga yang jaga sang dong. Deng itu ana bua dong bisa maso kapan-kapan sa, ko pi kasi tau ini orang dong pung hal di Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","13","Bosong pikir bae-bae, te Beta mau kasi umpama bagini: ada satu orang pung domba saratus ekor. Ais satu hari, ada domba satu ekor yang serong, iko jalan sandiri. Naa, bosong kira itu gambala musti bekin apa? Tantu dia kasi tenga dia pung domba 99 ekor di atas gunung, ko pi cari itu domba satu ekor yang ilang tu. Kalo dia su dapa kambali, nanti dia lebe sanáng lia dia pung domba yang satu tu, daripada dia lia dia pung domba 99 ekor yang sonde ilang. Beta, Manusia Tulen ni, datang ju ko mau kasi salamat sang orang yang serong dari jalan lurus. ");
INSERT INTO mkn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Te biar cuma satu ana kici sa yang ilang ju, Beta pung Bapa di sorga sonde sanáng.” ");
INSERT INTO mkn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus omong lai bilang, “Kalo lu pung sodara orang parcaya bekin sala sang lu, na, lu yang musti pi katumu deng dia. Ais kalo bosong dua sandiri, baru kasi tau dia pung sala. Kalo dia dengar lu pung omong, na, bosong dua su babae kambali tu. ");
INSERT INTO mkn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma kalo dia sonde mau dengar sang lu, na, pi ame lu pung tamán satu-dua orang ko pi sama-sama deng lu lai. Ais bosong pi katumu deng itu orang, ko omong lai deng dia. Te dalam Tuhan Allah pung Tulisan Barisi ada tatulis bilang, ‘Dalam satu parkara, musti ada dua ko tiga saksi yang omong sama, baru bisa tarima dong pung omong tu.’ ");
INSERT INTO mkn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma kalo dia masi sonde mau dengar sang bosong, na, pi kasi tau sang jamaꞌat. Deng kalo dia ju su sonde mau tarima bae jamaꞌat pung omong, na, anggap dia sama ke orang yang sonde kanál sang Tuhan. Kalo sonde, na, anggap dia jahat sama ke tukang tagi bea dong. ");
INSERT INTO mkn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Inga bae-bae Beta pung omong, é! Apa yang bosong larang di ini dunya, itu Tuhan su larang di sorga. Deng apa yang bosong kasi isin di ini dunya, itu Tuhan su kasi isin di sorga. ");
INSERT INTO mkn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Deng Beta kasi tau ulang bilang, kalo ada dua orang dari bosong yang sambayang satu hati, nanti Beta pung Bapa di sorga kasi apa yang dong minta. ");
INSERT INTO mkn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Te kalo ada dua-tiga orang bakumpul ko sambayang sama-sama, tagal dong tu Beta pung orang, na, Beta ju ada di dong pung teng-tenga.” ");
INSERT INTO mkn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ais itu, ju Petrus datang tanya sang Yesus bilang, “Bos, beta mau tanya sadiki. Kalo beta pung sodara orang parcaya bekin sala ulang-ulang sang beta, na, beta musti kasi ampon sang dia sampe barapa kali? Sampe tuju kali, ko?” ");
INSERT INTO mkn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ju Yesus manyao bilang, “Sonde! Lu musti kasi ampon sang dia 7 kali 70 kali, sampe lu sonde bisa itong lai. ");
INSERT INTO mkn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bosong musti bekin iko bagitu, tagal Tuhan Allah sama ke satu raja yang baꞌitong dia pung pagawe dong pung utang. ");
INSERT INTO mkn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Waktu dia mulai baꞌitong, ju dia suru dia pung orang ko pi pange datang satu pagawe yang ada baꞌutang doi deng dia, sampe juta-juta. ");
INSERT INTO mkn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma itu pagawe sonde bisa bayar ganti dia pung utang. Jadi raja parenta bilang, ‘Pi jual ini orang deng dia pung bini-ana samua, ko dong jadi budak. Deng jual abis dia pung harta dong samua, ko bayar dia pung utang dong.’ ");
INSERT INTO mkn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dengar bagitu, ju itu pagawe jato tikam lutut di raja pung muka, ko kokoe sang dia bilang, ‘Aduu! Bapa, é! Bapa raja tolong kasi beta waktu sadiki doo! Nanti beta bayar kambali beta pung utang dong samua.’ ");
INSERT INTO mkn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dengar bagitu, ju itu raja jato kasian sang dia. Ju dia hapus memang dia pung pagawe tu pung utang samua. Ais dia kasi lapás sang itu pagawe. ");
INSERT INTO mkn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ma waktu itu pagawe kaluar, ju dia nae katumu deng dia pung tamán satu yang ada baꞌutang doi sadiki sang dia. Tarús dia tangkap dia pung tamán, ko ceke dia pung batang leher deng masparak bilang, ‘Weh! Bayar lu pung utang sakarang ju!’ ");
INSERT INTO mkn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dengar bagitu, ju dia pung tamán jato tikam lutut ko kokoe sang dia bilang, ‘Aduu! Tamán, é! Tolong kasi beta waktu sadiki doo! Nanti beta bayar kambali beta pung utang sang lu.’ ");
INSERT INTO mkn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ma itu pagawe bilang, ‘Sonde bisa! Pokonya, lu musti bayar sakarang ju!’ Ais dia lempar kasi maso dia pung tamán pi dalam bui, sampe dia bayar abis dia pung utang dong. ");
INSERT INTO mkn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Waktu raja pung pagawe yang laen dapa lia apa yang su jadi tu, ju dong pung hati susa. Ais dong pi lapor sang raja. ");
INSERT INTO mkn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dengar bagitu, ju itu raja pange itu pagawe yang sonde tau diri tu. Dia togor bilang, ‘Heh, orang jahat! Tagal lu minta beta kasian sang lu, andia ko beta su hapus buang lu pung utang dong samua. ");
INSERT INTO mkn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ma akurang ko lu sonde tau kasian sang lu pung tamán, sama ke beta su kasian sang lu tu?’ ");
INSERT INTO mkn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Itu raja maruak, sampe dia suru dong pi tola maso sang itu orang dalam bui, ko biar dong siksa sang dia, sampe dia bayar abis dia pung utang dong samua.” ");
INSERT INTO mkn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ju Yesus tutu Dia pung carita deng kasi tau bilang, “Naa, Beta pung Bapa di sorga ju baꞌitong bagitu. Nanti Dia hukum sang bosong, kalo bosong sonde lupa buang batúl sang bosong pung sodara orang parcaya pung sala-sala dong.” ");
INSERT INTO mkn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus ajar abis itu samua, ju Dia jalan kasi tenga Galilea ko pi propinsi Yudea di kali Yarden pung sablá sana. ");
INSERT INTO mkn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Orang banya iko sang Dia, ju Dia bekin bae orang saki di sana. ");
INSERT INTO mkn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ada ju barapa orang Farisi yang datang ko mau hiki kasi jato sang Dia. Dong tanya bilang, “Bapa! Iko kotong pung atoran agama, kalo laki-laki su kawin, dia bole cere buang dia pung bini deng alasan apa sa, ko karmana?” ");
INSERT INTO mkn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma Dia manyao bilang, “Bosong ni, orang yang pintar agama. Ma akurang ko bosong sonde tau Tuhan Allah pung Tulisan Barisi pung isi? Te di carita mula-mula ada tulis bilang, ‘Tuhan Allah bekin manusia, laki-laki deng parampuan.’ ");
INSERT INTO mkn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Deng ada tatulis lai bilang, ‘Tagal itu, laki-laki musti kasi tenga dia pung mama-bapa, ko pi idop satu hati deng dia pung bini, te dong dua su jadi satu.’ ");
INSERT INTO mkn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tagal itu, kalo Tuhan Allah sandiri yang bekin dong dua jadi satu, na, manusia jang kasi cere lai!” ");
INSERT INTO mkn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dengar Yesus omong bagitu, ju itu orang Farisi dong tanya lai bilang, “Kalo bagitu, na, akurang ko baꞌi Musa bilang, orang bole bacere, asal dia kasi surat cere sang dia pung bini dolo?” ");
INSERT INTO mkn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ju Yesus manyao lai bilang, “Baꞌi Musa kasi biar bosong pung nene-moyang bacere deng dong pung bini, tagal dong tu, kapala batu sama ke bosong! Ma waktu Tuhan Allah bekin ini dunya, Dia pung maksud bukan bagitu. ");
INSERT INTO mkn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Andia ko Beta kasi tau, é! Kalo bini ada maen serong lebe dolo, na, laki-laki bole bacere. Ma kalo bini sonde maen serong, laki-laki yang cere buang sang dia, ais kawin lai deng parampuan laen, na, dia su barsina tu!” ");
INSERT INTO mkn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dengar Dia omong bagitu, ju Dia pung ana bua dong omong bilang, “Kalo bagitu, na, lebe bae jang kawin sa.” ");
INSERT INTO mkn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ju Yesus manyao bilang, “Sonde samua orang yang bisa tarima Beta pung omong ni. Cuma orang yang Tuhan Allah tunju sa. ");
INSERT INTO mkn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Te ada orang yang sonde kawin, tagal dari lahir su bagitu. Ada ju yang sonde kawin, tagal orang bekin bagitu sang dia. Deng ada ju, yang pili ko sonde kawin, tagal dia cuma mau kasi jalan Tuhan Allah pung karjá sa. Orang yang bisa mangarti ini ajaran, na, biar dia tarima sa.” ");
INSERT INTO mkn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Itu waktu, orang dong koko bawa dong pung ana-ana pi Yesus, ko biar Dia mua tangan deng omong kasi berkat sang dong. Ma Dia pung ana bua dong togor sang itu orang dong. ");
INSERT INTO mkn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ju Dia mara sang Dia pung ana bua dong bilang, “Kasi tenga itu ana dong datang sang Beta! Sonde usa larang! Te orang yang sama ke dong ni, andia Tuhan Allah pung orang.” ");
INSERT INTO mkn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ais Dia mua tangan pi di itu ana kici dong, deng minta ko Tuhan Allah kasi berkat sang dong. Ais itu, ju Dia jalan kasi tenga itu tampa. ");
INSERT INTO mkn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ais satu kali, ada orang datang tanya sang Yesus bilang, “Bapa Guru! Beta musti bekin hal bae yang karmana, ko biar beta tau parsís bilang, beta bisa maso sorga? Te beta mau idop tarús sama-sama deng Tuhan Allah.” ");
INSERT INTO mkn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ju Yesus manyao bilang, “Akurang ko lu tanya sang Beta soꞌal apa yang bae? Cuma Tuhan Allah sa yang bae. Kalo lu mau idop deng Dia, na, idop iko Dia pung parenta.” ");
INSERT INTO mkn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Itu orang tanya lai bilang, “Parenta yang mana tu?” Ju Yesus manyao bilang, “Jang bunu orang; jang maen serong; jang mancuri; jang jadi saksi putar-balek; ");
INSERT INTO mkn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kasi hormat sang lu pung mama-bapa; deng sayang lu pung sodara sama ke lu sayang lu pung diri sandiri.” ");
INSERT INTO mkn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Itu orang manyao bilang, “Naa, itu parenta samua tu, beta su bekin. Apa yang masi kurang lai?” ");
INSERT INTO mkn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dengar bagitu, ju Yesus bilang, “Naa! Kalo lu mau iko Tuhan pung mau samua, na, pulang ko jual lu pung harta samua. Ais pi bagi-bagi itu doi kasi orang miskin dong. Ais itu, baru lu datang ko iko sang Beta. Te nanti Tuhan Allah balas kasi lu harta bam-banya di sorga.” ");
INSERT INTO mkn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dengar bagitu, ju itu orang pulang deng hati susa, te dia kaya mau mati. ");
INSERT INTO mkn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ais ju Yesus omong deng Dia pung ana bua dong bilang, “Parcaya sang Beta, te orang kaya paling susa maso sorga. ");
INSERT INTO mkn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dia pung susa tu, sama ke binatang onta yang bésar, maso pi dia pung kandang lewat jarom pung lobang.” ");
INSERT INTO mkn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dengar bagitu ju, Dia pung ana bua dong jadi taheran-heran. Ju dong manyao bilang, “Kalo bagitu, na, sapa yang bisa maso sorga?” ");
INSERT INTO mkn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dia lia bae-bae sang dong, ju Dia omong bilang, “Kalo manusia yang karjá, memang sonde bisa. Ma kalo Tuhan Allah yang karjá, samua bisa jadi!” ");
INSERT INTO mkn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ju Petrus kasi inga bilang, “Bapa! Botong su jalan kasi tenga botong pung harta samua, ko iko sang Bapa. Ma botong dapa apa?” ");
INSERT INTO mkn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dia manyao bilang, “Parcaya sang Beta! Nanti kalo Tuhan Allah su bekin samua jadi baru, Beta, Manusia Tulen ni, dudu dalam hebat di korsi parenta bésar. Itu waktu, bosong yang iko sang Beta, ju iko dudu di atas 12 korsi parenta, ko jadi hakim kasi kotong pung 12 suku Israꞌel! ");
INSERT INTO mkn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Orang yang jalan kasi tenga dia pung ruma, adi-kaka, mama-bapa, ana-ana, deng dia pung kabón, ko iko sang Beta, nanti dia tarima bale sampe 100 kali lipat. Ais kalo ini dunya kiamat, dia ju dapa idop deng Tuhan tarús-tarús. ");
INSERT INTO mkn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jadi inga, é! Iko Tuhan Allah pung pikiran, banya orang yang bekin-bekin diri bésar, dong tu, andia orang yang paling kici. Ma orang yang anggap diri kici, dong tu, andia orang yang bésar, iko Tuhan pung pikiran.” ");
INSERT INTO mkn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ais itu, Yesus ajar bilang, “Tuhan Allah pung pegang parenta sama ke ini umpama: ada satu tuan kabón yang kaluar pagi-pagi jam anam, pi cari orang ko karjá di dia pung kabón anggor. ");
INSERT INTO mkn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dia dapa orang karjá, ju dong baꞌakór ko karjá satu hari, deng dia pung sewa satu doi perak, iko harga biasa. Satuju abis, ju dia suru dong pi karjá di dia pung kabón. ");
INSERT INTO mkn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jam sambilan pagi, ju dia kaluar lai pi pasar. Di situ dia dapa lia barapa orang yang ada dudu tanganga bodo sa. ");
INSERT INTO mkn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ju dia kasi tau sang dong bilang, ‘We, bu dong! Bosong mau karjá di beta pung kabón, ko? Nanti beta bayar sang bosong iko yang pantas.’ Dengar bagitu, ju dong ia bae, ais dong pi karjá. ");
INSERT INTO mkn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jam 12 tenga hari, deng jam tiga sore, itu tuan kabón kaluar ruma, ko pi cari orang karjá lai. ");
INSERT INTO mkn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Su sore, kira-kira jam lima, ju itu tuan kabón kaluar lai. Dia lia pi-datang, te masi ada orang yang badiri-badiri kosong sa. Ais dia tanya sang dong bilang, ‘Akurang ko bosong badiri kosong dari pagi sampe sore, deng sonde bekin apa-apa?’ ");
INSERT INTO mkn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Itu orang dong manyao bilang, ‘Bapa, é! Sonde ada orang yang kasi botong karjá.’ Ais, itu tuan bilang, ‘Kalo bagitu, na, bosong pi karjá di beta pung kabón su!’ ");
INSERT INTO mkn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Sampe dia pung jam barenti karjá, ju itu tuan kabón pange dia pung mandor ko bilang, ‘Pange orang karjá dong, ko bayar dong pung doi karjá satu-satu. Mulai dari orang yang maso tarahir sampe deng orang yang maso partama dong.’ ");
INSERT INTO mkn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ais, itu mandor pange itu orang dong yang karjá mulai dari jam lima sore. Dia kasi sang dong, satu-satu tarima satu doi perak. ");
INSERT INTO mkn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ais, itu mandor pange itu orang karjá laen dong, sampe deng orang yang karjá mulai dari jam anam pagi. Yang su karjá dari pagi pikir kata, tantu dong tarima lebe banya dari itu orang yang mulai karjá jam lima sore. Tau-tau te dong ju tarima satu doi perak. ");
INSERT INTO mkn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tarima bagitu ju, dong mangomek sang itu tuan kabón bilang, ");
INSERT INTO mkn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aweꞌ! Tar bisa bagini, bos! Dong yang datang paling balakang, cuma karjá satu jam sa. Ma botong yang maso dari papagi hari ni, su karjá banting tulang satenga mati sampe karingat dong malele! Ma karmana ko bos bayar sang botong sama ke dong tu?’ ");
INSERT INTO mkn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ju itu tuan kabón manyao sang satu dari dong bilang, ‘Bu, é! Beta sonde panake sang bu. Tagal bu sandiri satuju karjá satu hari, deng dia pung sewa satu doi perak. Batúl, to? Jadi beta su bayar iko kotong pung janji, wuang? ");
INSERT INTO mkn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ada lebe bae, bu tarima bu pung doi sewa ko pulang su. Kalo beta mau kasi orang yang maso karjá lebe lat dari bu, sama banya deng apa yang beta kasi sang bu, na, itu beta pung urusan. ");
INSERT INTO mkn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tantu beta ni bebas pake beta pung doi iko beta pung suka. Karmana ko bu jengkel tagal beta pung hati bae?’ ");
INSERT INTO mkn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bagitu ju, waktu Tuhan Allah jadi Raja kasi orang dong, Dia balas kasi Dia pung orang dong iko Dia pung suka. Jadi orang yang datang tarahir, nanti dia tarima dia pung bagian sama ke orang yang datang partama. Deng orang yang datang partama, nanti dia tarima dia pung bagian sama ke orang yang datang tarahir.” ");
INSERT INTO mkn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ais itu, ju Yesus dong mulai jalan pi Yerusalem. Di tenga jalan, Dia pange Dia pung ana bua ko dong bakumpul sandiri sa deng Dia. Ais itu, Dia kasi tau lai bilang, ");
INSERT INTO mkn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Bosong dengar, é! Kotong sakarang mau pi Yerusalem. Ma di sana dong jual buang sang Beta, Manusia Tulen ni, kasi pi di kapala agama Yahudi pung bos-bos, deng guru agama dong. Ais dong putus hukuman mati sang Beta. ");
INSERT INTO mkn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ju dong sarakan sang Beta pi orang laen yang sonde kanál sang Tuhan Allah. Ais dong omong bekin malu sang Beta. Dong firuk kasi ancor Beta pung badan. Ais, baru dong bunu bekin mati sang Beta di kayu palang. Memang Beta mati batúl. Ma dia pung lusa, Beta idop kambali.” ");
INSERT INTO mkn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ais itu, Sabadeus pung bini datang sang Yesus, sama-sama deng dia pung ana Yakobis deng Yohanis. Ju dia tikam lutut deng kasi hormat ko noki-noki sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ju Yesus tanya sang dia bilang, “Mama ada mau parlú apa?” Ju itu mama kasi tau bilang, “Bagini, Bapa! Beta minta, kalo Bapa su dudu pegang parenta, na, Bapa angka sang beta pung ana dua ni, ko dong ju iko pegang parenta sama-sama deng Bapa. Beta minta ko Bapa kasi dudu satu di Bapa pung sablá kanan, deng satu di sablá kiri.” ");
INSERT INTO mkn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dengar dia pung minta, ju Yesus kasi tau sang Yakobis deng Yohanis bilang, “Bosong sonde mangarti apa yang bosong minta. Te Beta nanti dapa sangsara banya. Jadi karmana? Bosong kira bosong ju mampu pikol itu sangsara sama-sama deng Beta, ko?” Dong dua manyao ena-ena sa bilang, “Talalu bisa, Bapa, é!” ");
INSERT INTO mkn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ais Dia manyao lai bilang, “Memang, bosong ju nanti pikol itu sangsara sama ke Beta. Ma sapa yang nanti dudu di Beta pung kanan deng kiri, itu bukan Beta yang putus. Itu Tuhan Allah yang pung hak putus. Dia su putus memang, sapa-sapa yang dudu di itu tampa.” ");
INSERT INTO mkn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Waktu sapulu ana bua yang laen su dengar dong dua pung minta bagitu, ju dong jengkel. ");
INSERT INTO mkn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ma Yesus pange ame sang dong samua, ju Dia bilang, “Bagini! Bosong su tau, to? Orang-orang bésar yang pegang parenta biasa tendes dong pung rakyat, sampe dong sonde bisa bagarák. Deng kapala-kapala dari bangsa yang sonde kanál sang Tuhan Allah, dong kasi parenta lebe-lebe, sampe dong pung rakyat sonde bisa angka kapala. ");
INSERT INTO mkn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ma bosong sonde bole bekin bagitu! Naa, sapa dari bosong yang mau jadi orang bésar, dia musti jadi sama ke jongos ko layani orang laen. ");
INSERT INTO mkn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Deng sapa yang mau jadi kapala, dia musti bekin diri sama ke hamba. ");
INSERT INTO mkn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dengar, é! Beta ju bagitu. Beta, Manusia Tulen ni, datang ko layani orang. Beta sonde datang ko orang layani sang Beta. Te Beta datang kasi Beta pung idop anteru-anteru, ko tabús ame banya orang dari dong pung sala-sala dong.” ");
INSERT INTO mkn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ais itu, Yesus dong jalan tarús. Waktu dong kaluar dari kota Yeriko, ada banya orang yang iko sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Di situ, ada dua orang buta yang dudu di pinggir jalan. Waktu dong dengar bilang, yang lewat tu, andia Yesus dari Nasaret, ju dong batarea karás-karás bilang, “Bos! Daud pung turunan, é! Botong su tunggu-tunggu lama sang Bos! Kasian sang botong dolo!” ");
INSERT INTO mkn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dengar dong batarea bagitu, ju orang togor bilang, “Heh! Bosong dua jang baribut!” Ma dong batarea lebe karás lai bilang, “Bos, é! Daud pung turunan, é! Kasian sang botong doo!” ");
INSERT INTO mkn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Waktu Yesus dengar bagitu, ju Dia barenti ko tanya sang dong bilang, “Bosong mau Beta bekin apa kasi bosong?” ");
INSERT INTO mkn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dong manyao bilang, “Bos é! Tolong ko botong bisa dapa lia doo!” ");
INSERT INTO mkn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dengar dong pung omong bagitu, ju Dia jato kasian sang dong. Ais Dia raba dong pung mata, ju dong lia memang. Ais itu, dong jalan iko sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ais itu, Yesus dong jalan tarús sampe di satu kampong nama Betfage, di gunung Saitun pung pinggir. Itu kampong su deka-deka deng kota Yerusalem. Di situ dong barenti tahan. Ju Dia suru Dia pung ana bua dua orang ko pi lebe dolo. ");
INSERT INTO mkn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Dia suru sang dong bilang, “Bosong dua pi di itu kampong sana. Kalo bosong maso, nanti bosong dapa lia binatang keledai mai deng dia pung ana satu ada taꞌika di situ. Bosong pi buka dong pung tali ko hela bawa datang kasi sang Beta. ");
INSERT INTO mkn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma kalo ada orang tanya sang bosong bilang, ‘Akurang ko bosong hela bawa orang pung keledai?’ Naa, bosong manyao bilang, ‘Bos ada mau pake. Kalo su pake abis, nanti Dia kirim pulang memang.’ ");
INSERT INTO mkn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Samua ni musti jadi, iko apa yang Tuhan Allah pung jubir su tulis memang bilang, ");
INSERT INTO mkn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘We, bosong orang Yerusalem dong! Mari ko lia sini doo! Te bosong pung Raja ada datang. Dia datang deng randá hati. Dia datang nae keledai ana.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ais ju itu ana bua pi, deng bekin iko samua, sama ke Yesus su pasán sang dong tu. ");
INSERT INTO mkn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dong hela bawa itu keledai mai deng dia pung ana pi Yesus. Ais dong taro dong pung salimut di keledai pung balakang, ju Yesus nae di atas ko mau maso kota. ");
INSERT INTO mkn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Waktu dong mau maso pi dalam kota, ju banya orang ame dong pung salimut deng dong pung salendang, ko taro di jalan. Ada ju yang pi potong ame daon-daon palam ko dong buka-buka di tenga jalan. Deng bagitu, dong bekin tanda bilang, dong sambut sang Dia sama ke orang bésar. ");
INSERT INTO mkn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ju ada orang saparu pi bajalan lebe dolo di muka Yesus, deng ada yang iko dari balakang. Dong baꞌeki rame-rame bilang, “Hosana! Botong puji-puji sang Tuhan Allah! Tagal Daud pung turunan su datang! Hosana! Botong puji-puji sang Tuhan Allah! Tagal Tuhan su utus datang ini Orang. Hosana! Botong puji-puji sang Tuhan Allah! Tagal Tuhan ada dudu parenta memang di langit yang paling tinggi!” ");
INSERT INTO mkn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Waktu Yesus maso Yerusalem deng rame-rame bagitu, ju isi kota samua kaluar ko batanya bilang, “Awii! Sapa yang datang ni?” ");
INSERT INTO mkn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Orang banya manyao bilang, “Dia ni, Tuhan Allah pung jubir. Dia pung nama Yesus, orang Nasaret, dari propinsi Galilea.” ");
INSERT INTO mkn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ais Yesus dong jalan tarús, ju dong maso pi Tuhan Allah pung Ruma Sambayang Pusat. Di itu Ruma Sambayang pung kintal, orang su bekin jadi pasar, ko dong bajual burung pompa yang orang pake jadi korban buat sambayang. Lia bagitu, ju Yesus pi usir kasi kaluar sang dong. Dia banting kasi talempar meja-meja yang dong pake tukar doi, deng banting kasi tabale bangku-bangku yang dong pake bajual itu burung dong. ");
INSERT INTO mkn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ju Dia kasi tau sang dong bilang, “Tuhan pung jubir su tulis bilang, ‘Beta kasi bangun ini Ruma, ko biar orang bisa datang sambayang di sini.’ Tuhan pung maksud bagitu, ma bosong su bekin ini Ruma jadi parampok dong pung tampa bakumpul!” ");
INSERT INTO mkn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ais ju orang buta deng orang lumpu dong datang sang Yesus di Tuhan Allah pung Ruma Sambayang tu. Ju Dia bekin bae sang dong samua. ");
INSERT INTO mkn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Di situ ada ju kapala agama Yahudi pung bos-bos deng guru agama dong. Waktu dong lia Yesus bekin tanda heran bagitu, ju dong jengkel. Lebe-lebe lai, waktu dong dengar itu ana-ana dong batarea rame-rame di Ruma Sambayang bilang, “Hosana! Botong puji-puji sang Tuhan Allah! Tagal raja Daud pung turunan su datang ni!” ");
INSERT INTO mkn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ais, itu bos-bos dong kasi tau sang Yesus bilang, “Weh! Lu dengar itu ana-ana dong pung omong? Itu sonde batúl tu!” Ma Yesus manyao sang dong bilang, “Hoo, Beta ada dengar. Ko akurang? Bosong balóm parná baca di Tuhan Allah pung Tulisan Barisi soꞌal ana-ana yang puji sang Tuhan Allah, ko? Te di situ ada tatulis bilang, ‘Tuhan Allah su siap memang ana mea deng ana kici, ko dong puji-puji sang Dia.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ais ju Yesus dong kaluar kasi tenga itu kota, ko pi tidor di kampong Betania. ");
INSERT INTO mkn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dia pung beso papagi, Yesus dong jalan lai ko maso kambali pi kota Yerusalem. Ma di tenga jalan, Dia su rasa lapar. ");
INSERT INTO mkn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dia dapa lia pohon satu di pinggir jalan yang orang biasa makan dia pung bua. Jadi Dia pi deka-deka itu pohon, ko mau lia coba ada bua, ko sonde. Ma waktu Dia sampe di itu pohon, Dia sonde dapa lia bua satu ju, tagal itu pohon baru badaon sa. Ju Dia omong deng itu pohon bilang, “Tagal lu sonde kasi kaluar lu pung bua kasi sang Beta, andia ko lu sonde akan babua lai!” Dia omong abis, ju itu pohon karíng memang. ");
INSERT INTO mkn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Dia pung ana bua dong lia bagitu, ju dong takuju. Dong tanya bilang, “Akurang ko takuju sa ini pohon karíng memang?” ");
INSERT INTO mkn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ju Dia manyao bilang, “Dengar bae-bae, é! Kalo bosong parcaya batúl-batúl sang Tuhan, deng sonde hati bacabang sadiki ju, bosong bisa bekin sama ke yang Beta su bekin tu. Bosong ju bisa bekin lebe dari itu. Conto ke: bosong bisa parenta gunung satu taꞌangka pi laut. Tantu Tuhan Allah kasi pinda itu gunung memang, asal bosong parcaya batúl-batúl sang Dia! ");
INSERT INTO mkn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te samua hal yang bosong minta sang Tuhan Allah, nanti bosong tarima, asal bosong parcaya batúl-batúl sang Dia.” ");
INSERT INTO mkn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ais Yesus dong jalan tarús. Sampe di Yerusalem, dong maso kambali lai pi Ruma Sambayang Pusat pung kintal. Waktu Dia ajar orang soꞌal Tuhan Allah pung jalan idop, ju kapala agama Yahudi pung bos-bos, deng tua-tua adat dong datang ko basoꞌal deng Dia bilang, “Sapa yang suru lu datang bekin kaco di sini kamaren? Sapa yang kasi itu hak sang lu?” ");
INSERT INTO mkn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma Dia tau dong ada cari jalan ko mau kasi jato sang Dia. Ais Dia balas bilang, “Beta ju mau tanya sang bosong. Bosong manyao sang Beta dolo, baru Beta manyao sang bosong. ");
INSERT INTO mkn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Beta mau tanya bagini: bosong samua kanál sang Yohanis, Tukang Sarani tu, to? Naa, sapa yang kasi hak sang dia ko sarani orang? Tuhan Allah ko, manusia?” Ais dong bapikir pi-datang, deng barunding bilang, “Aweꞌ! Kotong su kaná hiki ni, ma! Te kalo kotong manyao bilang, ‘Tuhan Allah yang kasi hak’, nanti Dia balas bilang, ‘Kalo bagitu, akurang ko bosong sonde parcaya sang Yohanis?’ ");
INSERT INTO mkn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma kotong ju sonde bisa bilang, ‘Manusia yang kasi hak’, te nanti orang dong samua mangamok sang kotong. Tagal dong parcaya bilang, Yohanis tu, Tuhan Allah pung jubir.” ");
INSERT INTO mkn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Andia ko dong manyao sang Yesus bilang, “Botong sonde tau.” Ju Yesus balas bilang, “Naa! Kalo bagitu, Beta ju sonde parlú kasi tau sapa yang kasi hak sang Beta.” ");
INSERT INTO mkn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus omong tarús deng itu bos-bos dong bilang, “Bosong pikir karmana deng umpama ni? Ada satu bapa deng dia pung ana laki-laki dua orang. Dia parenta sang ana sulung bilang, ‘Ana, é! Ini hari, na, lu pi karjá di kabón doo.’ ");
INSERT INTO mkn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma itu ana manyao bilang, ‘Eeh! Beta sonde pi.’ Ma sonde lama ju dia manyasal, ais dia pi. ");
INSERT INTO mkn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ais ju itu bapa suru dia pung ana nomer dua bilang, ‘Ana, é! Ini hari, na, lu pi karjá di kabón doo.’ Ju itu ana manyao bilang, ‘Bae bapa. Nanti beta pi’. Ma tau-tau, te dia sonde pi.” ");
INSERT INTO mkn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Carita ais bagitu, ju Yesus tanya sang dong bilang, “Naa, Beta mau tanya bagini: dari itu dua ana tu, yang mana yang bekin iko dia pung bapa pung parenta tu?” Ju dong manyao bilang, “Yang partama!” Ais Dia omong bilang, “Hoo. Ma dengar bae-bae, te Beta omong yang batúl. Orang yang bosong su cap orang tar laku-laku dong, sama ke ini tukang tagi bea, deng parampuan nakal, nanti dong maso jadi Tuhan Allah pung orang lebe dolo dari bosong. Te bosong cuma ia bae sang Tuhan sa, ma sonde bekin iko Dia pung mau. ");
INSERT INTO mkn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Dolu Yohanis Tukang Sarani su ajar sang bosong jalan karmana ko bosong bisa idop lurus. Ma bosong sonde mau parcaya sang dia. Padahal, waktu orang tar laku-laku dong dengar sang Yohanis, dong kasi tenga dong pung sala-sala, ko iko dia pung ajaran. Bosong ju su tau itu samua. Ma bosong sonde mau barenti dari bosong pung sala, ko iko Tuhan Allah pung mau.” ");
INSERT INTO mkn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ais itu, Yesus carita satu umpama lai bilang, “Ada satu tuan tana yang pi buka kabón baru, ko mau tanam pohon anggor di dia pung tana sapoꞌong. Ais dia bekin pagar kuliling. Deng dia bekin bak ko mau parés bua anggor pung aer. Ju dia kasi badiri satu tampa jaga yang tinggi. Ais dia kasi sewa itu kabón pi tukang garap, ko dong karjá bagi hasil deng dia. Tarús dia barangkat pi luar negrí. ");
INSERT INTO mkn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sampe musim ketu bua anggor, ju itu tuan kabón suru dia pung ana bua dong pi di itu tukang garap, ko minta dia pung bagian. ");
INSERT INTO mkn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma itu tukang garap dong sonde toe deng dia pung ana bua dong. Ada yang kaná pukul, ada yang kaná bunu, deng ada yang kaná lempar deng batu. ");
INSERT INTO mkn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ma itu tuan kabón suru lai dia pung ana bua satu rombongan yang lebe bésar dari yang partama tu. Ma itu tukang garap dong bekin jahat bagitu ju sang dong samua. ");
INSERT INTO mkn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lama-lama ju, itu tuan kabón suru dia pung ana sandiri. Te dia pikir kata, ‘Kalo beta kirim beta pung ana sandiri, pasti dong tarima bae-bae, deng dong dengar sang dia.’ ");
INSERT INTO mkn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ma waktu itu tukang garap dong lia sang itu ana, ju dong baꞌomong bilang, ‘We, bosong lia dolo! Te bapatua su kirim datang dia pung ana sandiri. Dia yang nanti tarima bapatua pung pusaka samua. Jadi mari ko kotong bunu sang dia su, ko biar kotong yang soa ini kabón.’ ");
INSERT INTO mkn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ju dong tangkap ame itu ana, ais hela buang pi luar kabón ko dong bunu sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus carita abis, ju Dia tanya sang dong bilang, “Naa, Beta mau tanya bagini: kalo itu tuan kabón kambali, kira-kira dia bekin karmana deng itu tukang garap dong?” ");
INSERT INTO mkn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ais orang Yahudi pung bos-bos dong manyao bilang, “Pasti dia bunu bekin mati itu orang jahat samua. Ais itu, dia kasi sewa itu kabón kasi pi orang laen, yang nanti bagi hasil pas deng dia pung waktu.” ");
INSERT INTO mkn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ais Yesus omong deng dong bilang, “Mangkali bosong sonde parná baca ame apa yang ada tatulis dalam Tuhan Allah pung Tulisan Barisi bilang, ‘Ada satu batu yang tukang batu dong tola buang, ma sakarang itu batu su jadi ruma pung batu alas! Tuhan Allah sandiri yang pili ame, ju kasi dudu itu batu. Andia ko kotong lia dia pung bagus lai!’ ” ");
INSERT INTO mkn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ais Yesus sambung Dia pung omong bilang, “Jadi bosong pikir bae-bae, é. Dolu Tuhan pili kotong orang Yahudi ni, ko jadi Dia pung orang. Ma tagal bosong sonde mau toe sang Beta, nanti Tuhan pili orang laen. Te orang yang idop iko Dia pung mau sa yang bisa maso jadi Dia pung orang. ");
INSERT INTO mkn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Beta kasi tau lurus-lurus sa. Beta ni, andia itu batu alas tu. Orang yang jato kaná ini batu, nanti itu orang jadi ancor-ancor. Deng kalo itu batu jato kaná orang, nanti itu orang jadi uuk-uuk memang.” ");
INSERT INTO mkn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Waktu kapala agama Yahudi pung bos-bos, deng orang Farisi dong dengar Yesus pung carita, ju dong tau bilang, Dia ada ser sang dong. Dong parsís sama ke itu tukang garap kabón dong, deng itu tukang batu yang tola buang itu batu alas. ");
INSERT INTO mkn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jadi dong mara mau mati. Ais dong ator siasat ko mau tangkap sang Dia. Ma dong ada eleng sang orang banya yang anggap Yesus tu, Tuhan Allah pung jubir. Andia ko dong sonde bisa bekin apa-apa sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ais Yesus omong lai deng dong pake umpama bilang, ");
INSERT INTO mkn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tuhan Allah pung pegang parenta tu, sama ke satu raja yang ada bekin pesta kawin kasi sang dia pung ana laki-laki. ");
INSERT INTO mkn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Waktu pesta su siap, ju dia suru dia pung hamba ko pi kasi tau orang-orang yang kaná undang dong bilang, ‘Mari, te acara su mau mulai.’ Ma itu orang dong sonde mau datang. ");
INSERT INTO mkn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ais, itu hamba dong pulang ko lapor sang raja. Dengar bagitu ju, itu raja suru dia pung hamba yang laen dong bilang, ‘Bosong pi kasi tau itu orang dong ko datang su, te pesta su siap. Beta su horo sapi, deng su masa ena-ena. Suru dong datang makan pesta, te samua su siap ni.’ ");
INSERT INTO mkn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Itu hamba dong pi kasi tau bagitu. Ma itu orang yang kaná undang dong sonde mau toe. Ada yang pi kabón, ada yang pi dong pung tampa karjá, ");
INSERT INTO mkn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","deng ada yang tangkap itu raja pung hamba dong, ko siksa sampe mati. ");
INSERT INTO mkn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Dengar bagitu, ju itu raja mara mau mati. Ais dia suru dia pung tantara dong ko pi bunu itu orang-orang yang su bunu dia pung hamba dong. Ais, itu tantara dong bakar itu kota sampe rata deng tana. ");
INSERT INTO mkn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ais ju itu raja pange dia pung hamba yang laen dong deng kasi tau bilang, ‘Pesta kawin su siap, ma orang-orang yang beta su undang tu, sonde pantas iko beta pung pesta. ");
INSERT INTO mkn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sakarang bosong kaluar pi jalan rame dong, ko undang sapa sa yang bosong katumu di situ.’ ");
INSERT INTO mkn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ais, itu hamba dong pi di jalan rame dong. Dong bawa datang banya orang yang dong katumu di situ, ko iko pesta kawin tu. Ada orang bae deng ada orang jahat yang datang bekin ponu itu tampa pesta. ");
INSERT INTO mkn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ais, itu raja maso pi tampa pesta ko lia kuliling dia pung tamu dong. Ju dia dapa lia satu tamu yang sonde pake pakean pesta. ");
INSERT INTO mkn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ais itu raja tanya bilang, ‘He, tamán! Akurang ko lu maso di sini sonde pake pakean pesta?’ Ma itu orang tanganga bodo sa. ");
INSERT INTO mkn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tarús itu raja parenta sang dia pung ana bua dong bilang, ‘Ika ini orang pung kaki deng tangan, ko angka buang sang dia pi luar. Biar ko dia manangis deng sangsara di tampa galáp sana.’ ");
INSERT INTO mkn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bagitu ju, Tuhan Allah undang banya orang, ma Dia cuma pili sadiki sa ko jadi Dia pung orang.” ");
INSERT INTO mkn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dengar abis Yesus pung omong bagitu, ju orang Farisi dong baꞌakór ko mau hiki deng tudu sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ais dong suru dong pung ana bua sama-sama deng orang dari Herodes pung partei politik, ko pi basoꞌal deng Yesus. Dong angka-angka nae sang Dia bilang, “Bapa Guru! Botong tau Bapa pung hati lurus. Bapa sonde tau putar-balek deng sonde pili muka. Bapa salalu ajar Tuhan Allah pung Kata-kata deng batúl. ");
INSERT INTO mkn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sakarang, botong mau tanya satu hal. Iko kotong pung atoran agama Yahudi, kira-kira kotong musti bayar pajak kasi pamarenta Roma pung raja bésar, ko sonde?” ");
INSERT INTO mkn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma Yesus su tau dong mau pancing sang Dia, ko Dia omong malawan pamarenta Roma. Ju Dia manyao bilang, “Dasar orang muka-balakang! Akurang ko bosong mau hiki sang Beta deng itu soꞌal? ");
INSERT INTO mkn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Coba kasi lia sang Beta doi perak satu yang orang pake ko bayar pajak!” Ju dong kasi tunju satu doi perak sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ais Dia tanya sang dong bilang, “Ini sapa pung gambar ni? Deng ini sapa pung nama ni?” ");
INSERT INTO mkn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dong manyao bilang, “Itu keser, pamarenta Roma pung raja bésar tu.” Ju Yesus kasi tau sang dong bilang, “Naa! Kalo bagitu, bosong pi kasi sang pamarenta apa yang pamarenta pung hak. Deng kasi sang Tuhan Allah apa yang jadi Tuhan Allah pung hak.” ");
INSERT INTO mkn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dengar Dia manyao bagitu, ju dong samua taheran-heran, ko Dia bilang batúl na. Andia ko dong sonde bisa hiki sang Dia. Ju dong jalan kasi tenga sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Di situ ada ju orang dari partei Saduki. Orang dari ini partei Saduki ni ajar bilang, orang mati sonde idop kambali. Itu hari, dong ju cari jalan ko mau hiki sang Yesus. Andia ko dong datang basoꞌal deng Dia bilang, ");
INSERT INTO mkn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Bapa Guru! Baꞌi Musa su tulis kasi tenga sang kotong ini adat bilang: kalo ada satu laki-laki mati kasi tenga dia pung bini, ma sonde ada ana, na, itu laki-laki pung adi musti kawin ame itu janda, ko biar kasi turunan sang dia pung kaka yang su mati tu. ");
INSERT INTO mkn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Memang, dolu baꞌi Musa ajar bagitu, ma sakarang botong ada mau tanya bagini: ada tuju laki-laki basodara. Yang partama kawin, ma dia mati, deng sonde kasi tenga ana. Ju dia pung adi yang iko sang dia, kawin bale itu janda. ");
INSERT INTO mkn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sonde lama lai dia ju mati deng sonde ada ana. Bagitu ju deng adi yang nomer tiga; dia kawin deng itu janda, ma dia ju mati deng sonde kasi tenga ana. Bagitu tarús-tarús sampe adi bungsu ju mati. ");
INSERT INTO mkn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ais ju itu janda mati. ");
INSERT INTO mkn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Naa! Sakarang botong mau tanya bagini: itu parampuan su parná kawin deng tuju laki-laki. Nanti kalo dunya kiamat, ais Tuhan kasi idop kambali orang mati dong, itu parampuan jadi sapa pung bini?” ");
INSERT INTO mkn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ais Yesus manyao bilang, “Kalo bosong batanya bagitu, na, bosong su sala bésar ni! Te bosong sonde mangarti Tuhan Allah pung Tulisan pung isi. Deng bosong ju sonde mangarti Dia pung kuasa yang hebat! ");
INSERT INTO mkn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yang batúl, bagini. Nanti, kalo Tuhan Allah kasi idop kambali orang mati, dong ju sonde bakawin lai, sama ke Dia pung ana bua di sorga. ");
INSERT INTO mkn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Deng Beta ju mau omong soꞌal orang mati bisa idop kambali, ko sonde. Dalam baꞌi Musa pung tulisan ada itu carita soꞌal pohon kici yang tabakar ma sonde angus. Dari itu carita, kotong dapa tau bilang, orang mati bisa idop kambali. Te di situ Tuhan Allah kasi tau sang baꞌi Musa bilang, ");
INSERT INTO mkn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Beta ni, lu pung baꞌi-baꞌi pung Tuhan Allah. Andia baꞌi Abraham, baꞌi Isak, deng baꞌi Yakob. Dong samua sémba tarús sang Beta sampe sakarang.’ Naa! Kotong tau bilang, waktu Tuhan omong bagitu, itu baꞌi dong su mati lama. Ma Tuhan Allah bilang Dia masi jadi tarús dong pung Tuhan. Andia ko kotong tau bilang, dong pung jiwa ada idop tarús, biar dong mati su lama. Jadi biar orang mati, ma dia idop kambali. Te cuma orang idop yang sémba sang Tuhan Allah, bukan orang mati, to?!” ");
INSERT INTO mkn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dengar Yesus ajar bagitu, ju itu orang Saduki dong sonde bisa balas apa-apa lai. Ma itu orang banya dong ada taheran-heran deng baꞌomong bilang, “Awii! Ini Orang pung ajaran talalu hebat, ó!” ");
INSERT INTO mkn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Waktu orang Farisi dong dengar bilang, Yesus su ontong sang itu orang Saduki dong, ju dong bakumpul rame-rame ko mau basoꞌal deng Dia. ");
INSERT INTO mkn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dong pung ahli agama satu mau hiki coba sang Dia bilang, ");
INSERT INTO mkn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Bapa Guru! Beta mau tanya bagini: kotong pung adat pung atoran, deng agama pung parenta dong, talalu banya. Dari samua parenta yang datang dari baꞌi Musa tu, yang mana yang paling pantíng?” ");
INSERT INTO mkn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ju Yesus manyao bilang, “Parenta yang paling pantíng dalam Tuhan Allah pung Tulisan Barisi tu bilang bagini: ‘Tuhan Allah tu, bosong pung Allah. Jadi bosong musti sayang sang Dia lebe dari samua. Tagal itu, bosong musti salalu rindu sang Dia, mangarti sang Dia, deng karjá karás ko iko Dia pung mau.’ ");
INSERT INTO mkn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Itu parenta tu, yang paling pantíng deng paling hebat! ");
INSERT INTO mkn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Deng ada parenta nomer dua yang bilang bagini: ‘Lu musti sayang orang laen dong, sama ke lu sayang lu pung diri sandiri.’ ");
INSERT INTO mkn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ini dua parenta ni, andia pohon dari baꞌi Musa pung atoran deng Tuhan Allah pung jubir dong pung ajaran samua. Orang sonde mungkin iko parenta yang laen dong, kalo dia sonde iko lebe dolo ini dua parenta bésar ni.” ");
INSERT INTO mkn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Waktu itu orang Farisi dong masi ada bakumpul di situ, ju Yesus soꞌal bale sang dong bilang, ");
INSERT INTO mkn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Dari dolu-dolu Tuhan Allah su janji kirim Kristus ko kasi salamat sang Dia pung orang dong. Naa, iko bosong pung pikiran, Kristus tu, sapa pung turunan?” Ju dong manyao bilang, “Dia tu, raja Daud pung turunan.” ");
INSERT INTO mkn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus omong tamba bilang, “Kalo bagitu, na, akurang ko Tuhan Allah pung Roh Barisi kasi tau sang raja Daud ko dia pange sang Kristus tu, ‘Bos’? Te Daud su tulis bilang, ");
INSERT INTO mkn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tuhan Allah su kasi tau sang beta pung bos bilang, “Mari ko dudu di Beta pung sablá kanan, di tampa yang paling hormat ni. Te nanti Beta bekin lu pung musu dong, sampe dong taꞌalok sang lu.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Naa! Dari itu tulisan, kotong dapa tau bilang, raja Daud sandiri yang pange sang Kristus tu, ‘Bos’. Jadi, kalo orang bilang Kristus tu, cuma raja Daud pung turunan sa, itu balóm cukup! Tagal Dia ju jadi raja Daud pung Bos yang hak parenta sang dia na!” ");
INSERT INTO mkn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dengar Yesus pung omong bagitu, ju itu orang Farisi dong jadi tabodo-bodo sa, te sonde ada satu orang ju yang bisa manyao sang Yesus. Andia ko mulai dari itu hari ju, dong su taku batanya-batanya deng dong sonde barani hiki coba sang Dia lai. ");
INSERT INTO mkn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ais ju Yesus ajar Dia pung ana bua dong, sama-sama deng itu orang banya yang ada iko sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Dia kasi tau bilang, “Itu guru agama deng orang Farisi dong pegang hak ko ajar baꞌi Musa pung atoran dong. ");
INSERT INTO mkn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tagal itu, bosong musti dengar sang dong deng iko dong pung ajaran ju. Ma jang iko apa yang dong bekin, tagal dong sonde bekin iko dong pung ajaran sandiri. ");
INSERT INTO mkn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dong paksa orang ko pikol iko dong pung atoran agama yang barát. Ma dong sandiri sonde mau tolong orang dong ko iko itu atoran. ");
INSERT INTO mkn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Samua yang dong bekin, dong bekin ko biar orang puji-puji sang dong. Conto ke: ada satu barang yang ada isi Tuhan Allah pung Kata-kata yang dong ika di dong pung kapala deng dong pung tangan. Ma dong bekin tamba bésar dong punya, ko biar orang angka-angka sang dong bilang, ‘We! Dong tu, orang barisi, ó!’ ");
INSERT INTO mkn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kalo dong maso pi ruma sambayang, ko, dong iko pesta, dong salalu cari tampa dudu yang paling bagus, ko banya orang lia sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kalo dong pi pasar, dong ju gila hormat. Dong cari ko orang soya sang dong bilang, ‘Salamat pagi, bapa guru yang terhormat.’ ");
INSERT INTO mkn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma bosong jang iko dong pung cara tu! Orang sonde bole pange sang bosong bilang, ‘bapa guru’, tagal bosong pung Guru cuma satu sa. Deng bosong samua ni, basodara. ");
INSERT INTO mkn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jang angka-angka nae orang di dunya bilang, ‘bapa’, tagal bosong pung Bapa di sorga cuma satu sa. ");
INSERT INTO mkn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Orang ju sonde bole pange sang bosong bilang, ‘bos’, tagal bosong pung Bos yang hak parenta sang bosong cuma satu sa, andia Beta ni, yang Tuhan Allah su janji kirim dari dolu tu. ");
INSERT INTO mkn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Andia ko Beta bilang bosong sonde bole angka-angka diri sama ke itu orang yang gila hormat dong. Sapa dari bosong yang mau jadi orang bésar, dia musti jadi sama ke jongos ko layani orang laen. ");
INSERT INTO mkn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Te orang yang angka-angka diri, nanti Tuhan kasi jato sang dia. Ma orang yang bekin diri sama ke orang kici, nanti Tuhan angka nae sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ais itu, Yesus omong sambung bilang, “Heh, bosong guru agama deng orang Farisi dong! Dasar bosong tu, orang muka-balakang! Nanti bosong dapa calaka, tagal bosong sonde mau parcaya sang Beta, andia itu Orang yang Tuhan Allah su janji mau kirim datang ni. Deng lebe jahat lai, bosong palang ame orang yang datang mau maso dalam Tuhan pung parenta ko dong jang parcaya sang Beta. ");
INSERT INTO mkn_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Heh, bosong guru agama deng orang Farisi dong! Dasar bosong tu, orang muka-balakang! Nanti bosong dapa calaka, tagal bosong maen putar-balek sang janda dong, ais rampas ame dong pung ruma. Ma di orang banya pung muka, bosong tutu bosong pung jahat tu, deng badiri sambayang lama-lama ko orang bilang bosong pung hati barisi. Ma nanti Tuhan Allah kasi hukum yang paling barát sang bosong. ");
INSERT INTO mkn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Heh, bosong guru agama deng orang Farisi dong! Dasar bosong tu, orang muka-balakang! Nanti bosong dapa calaka, tagal bosong balayar pi mana-mana, deng nae-turun gunung, cuma mau cari satu orang sa, ko dia maso pi dalam bosong pung partei agama. Ma kalo dia su maso, na, bosong bekin dia pung idop jadi lebe jahat lai, sampe dia dapa hukum di naraka dua kali lebe barát dari bosong. ");
INSERT INTO mkn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Weh! Bosong su jadi buta di hati, ma akurang ko bosong masi mau tunju jalan kasi orang laen lai? Nanti bosong dapa calaka tagal bosong ajar sambarang bilang, ‘Kalo orang angka janji pake sumpa deng subu Ruma Sambayang Pusat, na, itu orang sonde taꞌika deng dia pung janji tu. Ma kalo dia angka janji pake sumpa deng subu barang mas yang ada dalam itu Ruma Sambayang, na, baru dia taꞌika deng dia pung janji tu.’ ");
INSERT INTO mkn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bosong ni orang bodo yang buta kanóp! Bosong kira Tuhan anggap barang mas lebe pantíng dari Dia pung Ruma Sambayang Pusat? Sonde! Te itu Ruma yang bekin itu barang jadi barisi! ");
INSERT INTO mkn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bosong ju ajar sambarang bilang, ‘Kalo orang angka janji pake sumpa deng subu itu meja korban yang ada di Ruma Sambayang Pusat, na, itu orang sonde taꞌika deng dia pung janji tu. Ma kalo dia angka janji pake sumpa deng subu korban yang di atas itu meja, na, baru dia taꞌika deng dia pung janji tu.’ ");
INSERT INTO mkn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bosong ni, su buta batúl-batúl. Su tantu itu meja korban tu, lebe pantíng dari korban yang ada di itu meja pung atas. Te itu meja tu, yang bekin dong pung korban jadi barisi kasi Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tagal itu, kalo orang sumpa deng subu meja korban, na, lebe bae subu itu meja, deng samua yang ada di itu meja pung atas ju. ");
INSERT INTO mkn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Deng kalo orang sumpa deng subu Ruma Sambayang Pusat, na, lebe bae subu Ruma Sambayang sama-sama deng Tuhan Allah pung nama. Te Dia yang tenga di situ. ");
INSERT INTO mkn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Deng kalo orang sumpa deng subu sorga, na, itu tu, su sama ke dia subu Tuhan Allah pung korsi parenta sama-sama deng Dia pung nama, te Dia yang dudu pegang parenta di situ. ");
INSERT INTO mkn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Heh, bosong guru agama deng orang Farisi dong! Dasar bosong tu, orang muka-balakang! Nanti bosong dapa calaka, tagal bosong talalu pintar itong ko kasi Tuhan satu bagian dari sapulu bagian. Bosong maen baꞌitong samua-samua, sampe bosong pung bumbu-bumbu dari kabón, bosong ju itong mati. Conto ke bosong itong alus-alus bosong pung salasi, adas manis, deng jintan. Padahal bosong su lupa buang Tuhan Allah pung atoran yang paling pantíng dong! Te bosong sonde idop lurus. Bosong sonde sayang orang kasian dong. Deng bosong sonde idop tarús-tarús iko Tuhan pung mau. Lebe bae, bosong bekin iko itu samua dolo, baru bosong pi itong bosong pung bumbu-bumbu, yang bosong mau kasi sang Tuhan. ");
INSERT INTO mkn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bosong pung hati su buta, ma akurang ko bosong masi mau tunju jalan kasi orang laen lai? Bosong bekin atoran sampe alus-alus ko suru orang laen dong iko, ma Tuhan pung atoran yang paling pantíng tu, bosong sandiri sonde iko. Sama ke bosong pareksa alus-alus ko saring buang lalat kici dari bosong pung aer minum. Ma binatang bésar ke karbó, bosong kodo ame anteru-anteru! ");
INSERT INTO mkn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Heh, bosong guru agama deng orang Farisi dong! Dasar bosong tu, orang muka-balakang! Nanti bosong dapa calaka, tagal bosong cuci ame bosong pung piring-mangko dong sampe mangkilat, ma itu cuma di bagian luar sa. Padahal dia pung dalam dadolek mati deng kotoran dari bosong pung parampok deng bosong pung balalas. ");
INSERT INTO mkn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Weh! Orang Farisi buta dong! Cuci lebe dolo bosong pung piring mangko pung bagian dalam! Deng bagitu, dia pung bagian luar ju bisa jadi barisi! ");
INSERT INTO mkn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Heh, bosong guru agama deng orang Farisi dong! Dasar bosong tu, orang muka-balakang! Nanti bosong dapa calaka, tagal bosong ni sama ke kubur yang kaná cet puti. Orang dapa lia dia pung luar tu, talalu bagus. Ma dia pung dalam tu, ponu deng orang mati pung tulang, deng samua yang baboo puruk. ");
INSERT INTO mkn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bosong ju sama! Bosong suka bekin diri tingka ke orang barisi. Dari luar orang lia bosong tu, sama ke orang yang hati lurus. Padahal bosong pung dalam hati tu, su ponu deng hal jahat. Te bosong omong laen bekin laen, deng lupa buang Tuhan Allah pung parenta dong. ");
INSERT INTO mkn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Heh, bosong guru agama deng orang Farisi dong! Dasar bosong tu, orang muka-balakang! Nanti bosong dapa calaka! Bosong bekin kubur bésar-bésar kasi Tuhan Allah pung jubir dong, deng hias bagus-bagus orang bae dong pung kubur. ");
INSERT INTO mkn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma bosong bilang, ‘Andekata botong idop satu jaman deng botong pung nene-moyang dong, tantu botong sonde iko-iko bunu Tuhan Allah pung jubir dong.’ ");
INSERT INTO mkn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Deng bagitu, bosong buka bosong pung kartu sandiri bilang, bosong tu, ju jahat sama ke bosong pung nene-moyang dong. ");
INSERT INTO mkn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jadi lebe bae, bosong bekin jahat bagitu sampe abis, iko bosong pung nene-moyang pung sala dong! ");
INSERT INTO mkn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Bosong ni batúl-batúl jahat sama ke ular baracon. Bosong kira Tuhan Allah sonde kasi hukum sang bosong? Jang harap! Tantu Dia lempar buang sang bosong pi dalam api naraka! ");
INSERT INTO mkn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dengar, é! Nanti Beta kirim kasi bosong Beta pung utusan dong, ko dong ajar deng kasi tunju sang bosong Tuhan pung jalan idop yang batúl. Ma nanti bosong bunu saparu, deng paku bekin mati saparu di kayu palang. Ada ju yang bosong firuk di dalam ruma-ruma sambayang, deng ada yang bosong siksa sampe dong balari dari satu kota pi kota laen. ");
INSERT INTO mkn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dolu-dolu bosong pung nene-moyang bunu sang Habel. Padahal dia tu, orang yang pung hati lurus. Bosong pung nene-moyang maen bunu tarús-tarús orang hati lurus dong dari satu turunan pi turunan laen. Sampe deng Sakaria, andia Barakia pung ana. Dong bunu sang dia di Ruma Sambayang Pusat pung kintal deka deng meja korban. Tagal bosong iko bosong pung nene-moyang pung jahat tu, andia ko bosong musti tanggong itu orang hati lurus dong pung dara samua. ");
INSERT INTO mkn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Memang batúl! Te bosong yang ada sakarang ni, nanti kaná hukum, tagal ini hal-hal jahat dong yang bosong pung nene-moyang su bekin dari dolu.” ");
INSERT INTO mkn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“We, orang Yerusalem dong! Bosong yang maen bunu Tuhan Allah pung jubir dong, deng lempar bekin mati utusan yang mau datang tolong sang bosong. Beta maen buju sang bosong ulang kali ko datang sang Beta, sama ke ayam mai yang mau tutu ame dia pung ana dong di bawa dia pung sayap. Ma bosong sonde mau. ");
INSERT INTO mkn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tagal itu, Tuhan su sonde toe lai deng bosong pung ruma. Ais beso-lusa, te dia su kosong. ");
INSERT INTO mkn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Dengar bae-bae, é! Te bosong sonde akan lia sang Beta lai, sampe dia pung waktu bosong mangaku bilang, ‘Kotong minta ko Tuhan Allah kasi berkat sang ini Orang, tagal Tuhan yang utus sang Dia.’ Bosong mangaku bagitu, baru bosong dapa lia sang Beta lai.” ");
INSERT INTO mkn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ais itu, Yesus mau jalan kasi tenga Ruma Sambayang Pusat. Waktu Dia kaluar, Dia pung ana bua dong datang kasi tunju itu Ruma Sambayang pung bagus. ");
INSERT INTO mkn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma Dia manyao bilang, “Ini Ruma memang bagus! Ma dengar, é! Sonde lama lai, dong kasi rubu abis ini batu-batu samua.” ");
INSERT INTO mkn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ais Yesus jalan pi dudu di gunung Saitun. Ju Dia pung ana bua datang ko dong baꞌomong sandiri deng Dia bilang, “Bapa! Coba kasi tau ulang Bapa pung omong tadi tu. Kira-kira Bapa pung datang kambali tu, kapan? Deng dia pung tanda-tanda tu, kira-kira karmana? Karmana ju deng dunya pung kiamat?” ");
INSERT INTO mkn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ais Yesus manyao bilang, “Jaga diri bae-bae, ó! Ko bosong jang kaná tipu. ");
INSERT INTO mkn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Te nanti ada macam-macam orang yang datang puku dada bilang, ‘Beta ni, Kristus, Orang yang Tuhan Allah su janji dari dolu.’ Deng bagitu, dong tipu banya orang. ");
INSERT INTO mkn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kalo bosong lia orang baparáng, ko, bosong dengar kabar bilang, ada paráng di mana-mana, na, bosong sonde usa taku. Te hal macam bagitu tu, musti jadi. Ma hari kiamat balóm sampe. ");
INSERT INTO mkn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nanti satu suku baparáng lawan suku laen. Satu negara baparáng lawan negara laen. Ada tana goyang di mana-mana. Deng musim lapar ju hebat mati pung! ");
INSERT INTO mkn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma samua tu, baru tanda partama yang kasi tau bilang, hari kiamat pung waktu su deka-deka datang. Itu sama ke parampuan yang baru mulai rasa saki, tagal dia pung waktu barana su deka-deka datang. ");
INSERT INTO mkn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jadi bosong musti jaga diri bae-bae, é! Te nanti dong siksa deng bunu bekin mati sang bosong. Deng orang dari samua bangsa nanti binci mati sang bosong, tagal bosong iko sang Beta. ");
INSERT INTO mkn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Itu waktu, banya orang bale balakang deng sonde mau parcaya sang Beta lai. Dong babinci, deng bajual satu deng satu. ");
INSERT INTO mkn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nanti ada tukang tipu bilang dong tu, Tuhan pung jubir. Deng banya orang parcaya sang dong. ");
INSERT INTO mkn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nanti orang pung jahat dong tamba lama tamba banya, sampe orang su sonde basayang satu deng satu lai. ");
INSERT INTO mkn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma orang yang batahan tarús sampe mati, pasti Tuhan Allah kasi salamat sang dia. ");
INSERT INTO mkn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Te orang musti kasi tasiar Tuhan Allah pung Kabar Bae sampe di dunya pung huk-huk, ko biar samua orang bisa dapa tau Tuhan pung jalan idop yang batúl. Ais itu, baru hari kiamat datang.” ");
INSERT INTO mkn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus omong tarús bilang, “Tuhan Allah pung jubir Daniel su tulis soꞌal satu orang yang jahat mati pung. Nanti dia datang maso pi badiri di tampa pamali di Tuhan Allah pung Ruma Sambayang Pusat. Deng bagitu, dia bekin noju itu tampa. Andia ko Tuhan Allah bale balakang kasi tenga itu tampa. Naa! Kalo bosong su lia bagitu, ati-ati, ó! (Sapa yang baca ini tulisan ni, musti mangarti bae-bae!) ");
INSERT INTO mkn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Te itu jadi tanda bilang, hari-hari susa su ada di muka pintu. Kalo su lia bagitu, orang di propinsi Yudea bangun lari pi gunung suda. ");
INSERT INTO mkn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kalo ada yang su kaluar dari ruma, jang pulang pi ame barang lai. Lari capát-capát su, ko biar jang kaná calaka. ");
INSERT INTO mkn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Orang yang ada di kabón, jang kambali ko ame kaen panas lai. Lari tarús su! ");
INSERT INTO mkn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Yang paling kasian, andia parampuan yang ada dudu parú, deng mama-mama yang ada kasi susu ana mea. Te dong sonde bisa lari capát na. ");
INSERT INTO mkn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jadi lebe bae bosong sambayang ko minta itu calaka jang jato kaná deng musim ujan, ko, jato kaná deng hari barenti karjá. ");
INSERT INTO mkn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Te itu hari talalu susa mau mati! Mulai dari Tuhan Allah bekin ini dunya sampe sakarang, orang balóm parná lia susa bésar macam bagitu. Deng nanti orang ju sonde lia ulang lai susa macam bagitu. ");
INSERT INTO mkn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma bosong ontong bésar, te Tuhan Allah kasi pende itu hari. Kalo sonde, na, sonde ada satu orang ju yang bisa batahan idop. Ma tagal Tuhan Allah sayang Dia pung orang yang Dia su pili dong, andia ko Dia kasi pende itu hari-hari susa dong. ");
INSERT INTO mkn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nanti kalo itu hari su sampe, bosong dengar orang bilang, ‘Lia dolo! Kristus ada di sini!’ Deng orang laen bilang, ‘Kristus ada di sana!’ Ma bosong jang parcaya, é! ");
INSERT INTO mkn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Te nanti ada orang kaluar ko puku-puku dada bilang, ‘Beta ni, Kristus!’ Deng yang laen lai bilang, ‘Beta ni, Tuhan Allah pung jubir.’ Nanti dong bekin tanda heran macam-macam pake kuasa galáp ko putar-balek orang. Dong coba-coba ko Tuhan Allah pung orang dong ju kaná tipu! ");
INSERT INTO mkn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jadi bosong musti jaga diri bae-bae, é! Itu hari-hari susa dong balóm sampe, ma Beta su kasi inga memang sang bosong, ó! ");
INSERT INTO mkn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kalo orang kasi tau sang bosong bilang, ‘Kristus su ada di tana lapang sana, é!’ na, bosong jang pi sana. Deng kalo ada yang bilang, ‘Kristus su ada di dalam ini ruma!’, na, bosong jang parcaya deng dong pung putar-balek tu. ");
INSERT INTO mkn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Te Beta ni, Manusia Tulen. Nanti kalo Beta datang kambali di ini dunya, samua orang dapa lia sang Beta, sama ke orang lia kilat yang bacaya dari sablá matahari nae pi sablá matahari turun. ");
INSERT INTO mkn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kalo Beta datang kambali, nanti bosong tau Beta ada di mana. Sama ke orang tau bilang, kalo ada burung tukang makan bangke bakumpul di satu tampa, na, di situ pasti ada bangke.” ");
INSERT INTO mkn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ais Yesus sambung lai, ko kasi tau Dia pung ana bua bilang, “Kalo itu hari-hari susa dong su abis, ‘Nanti matahari jadi galáp, bulan ju su sonde taráng lai. Bintang-bintang bajato dari langit, deng samua kuasa di langit jadi harba-biruk.’ ");
INSERT INTO mkn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ais itu, ju samua orang dapa lia tanda di langit bilang, Manusia Tulen ada mau datang kambali. Lia bagitu ju, samua bangsa di dunya jadi taku sampe dong manangis. Te nanti Beta turun datang deng awan, baru dong lia Beta pung kuasa deng Beta pung hebat samua. ");
INSERT INTO mkn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ais Beta pake bunyi tarompet yang karás ko parenta Tuhan Allah pung ana bua di sorga pi kumpul samua orang yang Beta su pili ame dari dunya pung ujung-ujung, dari matahari nae sampe matahari turun; dari utara sampe salatan.” ");
INSERT INTO mkn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Beta ame conto ke pohon. Kalo dia pung daon mulai kuning, itu tanda bilang, musim panas su deka-deka datang. ");
INSERT INTO mkn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bagitu ju, kalo bosong su lia hari-hari susa datang, sama ke yang Beta su kasi tau tadi tu, itu tanda bilang, Beta su deka-deka datang. ");
INSERT INTO mkn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sakarang, dengar bae-bae! Dari samua orang yang idop sakarang ni, nanti ada yang balóm mati, te itu hari-hari susa dong su datang. ");
INSERT INTO mkn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Biar langit deng bumi su ilang buang, ma Beta pung kata-kata ni batahan sonde abis-abis.” ");
INSERT INTO mkn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Sonde ada orang yang tau kapan Beta datang kambali. Tuhan Allah pung ana bua di sorga, ju sonde tau. Beta sandiri, ju sonde tau. Cuma Beta pung Bapa sa yang tau. ");
INSERT INTO mkn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Te Beta ni, Manusia Tulen. Nanti kalo Beta datang kambali, itu sama ke dolu-dolu waktu Noh masi idop. ");
INSERT INTO mkn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Itu banjer bésar balóm datang, te orang dong makan-minum ena-ena, deng bakawin rame-rame sama ke biasa. Dong bekin bagitu tarús-tarús, sampe Noh maso pi dalam itu kapal bésar. ");
INSERT INTO mkn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma waktu banjer datang sapu bawa sang dong, baru dong pung mata tabuka, ko dong dapa tau apa yang su jadi tu. Bagitu ju deng Beta pung datang nanti. ");
INSERT INTO mkn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Itu waktu, kalo dua orang ada karjá kabón, takuju sa, te Tuhan Allah angka bawa yang satu, ma yang laen Dia kasi tenga. ");
INSERT INTO mkn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kalo dua parampuan ada tumbu padi, takuju sa, te Tuhan Allah angka bawa yang satu, ma yang laen Dia kasi tenga. ");
INSERT INTO mkn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tagal itu, bosong ju musti bajaga siang-malam, te bosong sonde tau kapan bosong pung Bos datang kambali. ");
INSERT INTO mkn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pikir bae-bae, é! Kalo tuan ruma tau sabantar malam pancuri mau datang, su tantu dia bajaga tarús, ko biar pancuri jang maso dalam dia pung ruma. ");
INSERT INTO mkn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tagal itu, bosong ju musti basiap-siap. Te Beta pung datang kambali tu, takuju-takuju sa!” ");
INSERT INTO mkn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ais Yesus omong tamba bilang, “Bosong musti jadi sama ke tukang suru-suru yang iko tarús-tarús dia pung bos pung mau. Te kalo bos mau jalan pi tampa jao, dia angka tukang suru-suru macam bagitu, ko urus dia pung isi ruma pung makan-minum samua. ");
INSERT INTO mkn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kalo bos pulang deng dapa lia dia pung tukang suru-suru ada karjá bae-bae, pasti dia sanáng deng itu orang. ");
INSERT INTO mkn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Parcaya sang Beta, te nanti itu bos kasi itu tukang suru-suru kuasa ko urus dia pung harta-milik samua. ");
INSERT INTO mkn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma kalo itu tukang suru-suru jahat, dia pasti omong dalam dia pung hati bilang, ");
INSERT INTO mkn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Bae su! Bos su jalan bagini, sapa pi tau kapan dia kambali, ó!’ Pikir bagitu ju, dia mulai papoko dia pung tamán orang karjá yang laen dong. Deng dia dudu makan-minum ena-ena sama-sama deng pamabok dong. ");
INSERT INTO mkn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ma sonde sangka-sangka, te takuju sa, dia pung bos pulang. ");
INSERT INTO mkn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ju itu bos siksa ukur kuat sang dia, ais lempar buang sang dia pi luar, ko dia tenga sama-sama deng orang muka-balakang dong. Di itu tampa, dong samua manangis makarereu, tagal dong ada sangsara mati pung.” ");
INSERT INTO mkn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ais ju Yesus sambung Dia pung omong soꞌal Tuhan Allah pung parenta bilang, “Bosong musti basiap-siap ko sambut Beta pung datang kambali, sama ke ini umpama ni. Bagini: satu kali, ada nona sapulu orang yang kaluar malam deng bawa dong pung lampu teꞌoek, ko pi sambut baroit laki-laki di dong pung tamán pung ruma. ");
INSERT INTO mkn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ma dari dong sapulu orang tu, ada lima yang bodo, deng lima yang pintar. ");
INSERT INTO mkn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lima yang bodo lupa bawa minya lebe. ");
INSERT INTO mkn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma lima yang pintar su bawa memang. ");
INSERT INTO mkn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sampe di itu ruma, itu baroit laki-laki balóm datang-datang ju. Lama-lama itu nona dong manganto kode, ju dong tatidor sonu. ");
INSERT INTO mkn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tau-tau te dia pung tenga malam, ju dong dengar orang batarea bilang, ‘Woi! Baroit su datang, ó! Mari kotong pi sambut sang dia su!’ ");
INSERT INTO mkn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dengar bagitu, ju itu nona dong bangun rame-rame. Ais dong pi siap-siap dong pung lampu teꞌoek. ");
INSERT INTO mkn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma itu nona bodo dong omong deng dong pung tamán bilang, ‘We, tamán dong! Tolong bagi minya sadiki kasi botong doo, te botong pung lampu su amper mati ni!’ ");
INSERT INTO mkn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ma itu nona yang pintar dong manyao bilang, ‘Aweꞌ! Jang mara, ma sonde bisa, ó. Te botong pung minya ni sonde cukup kasi kotong samua! Lebe bae bosong pi béli minya di kios sa.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ju dong pi béli minya. Ma waktu dong ada kaluar, itu baroit su sampe. Ais, itu nona yang pintar dong iko maso pi dalam tampa pesta, sama-sama deng baroit deng tamu samua. Dong samua maso di dalam ruma, ju orang tutu pintu. ");
INSERT INTO mkn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ais, itu nona yang bodo dong ju datang. Dong batarea noki-noki bilang, ‘Bos! Bos, é! Tolong buka pintu doo!’ ");
INSERT INTO mkn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma dia manyao bilang, ‘Weh, sonde bisa! Te beta sonde kanál sang bosong.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tagal itu, bosong ju musti siap-siap ko bajaga tarús, te bosong ju sonde tau Beta pung datang kaná hari apa, ko jam barapa.” ");
INSERT INTO mkn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ais Yesus sambung satu umpama lai bilang, “Kalo Beta su kasi tenga sang bosong, na, bosong musti karjá bae-bae kasi Beta, sama ke ini umpama ni. Bagini: ada satu bos mau pi tampa jao. Waktu dia su siap mau jalan, dia pange dia pung tukang suru-suru dong, ais dia parenta sang dong bilang, ‘Bosong pake ini doi jadi modal. Nanti kalo beta pulang, bosong musti lapor sang beta, bosong su ontong barapa.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ais dia kasi dia pung tukang suru-suru partama, doi mas lima saku, ko dia kasi babunga itu doi. Tarús dia kasi tukang suru-suru nomer dua, doi dua saku, deng tukang suru-suru nomer tiga, doi satu saku, iko dong satu-satu pung mampu. Ais ju dia barangkat pi jao. ");
INSERT INTO mkn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tarima ame itu doi, ju itu tukang suru-suru partama kaluar memang ko pi badagang. Sonde lama, te dia su dapa ontong doi lima saku lai. ");
INSERT INTO mkn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bagitu ju deng tukang suru-suru nomer dua. Dia dapa ontong doi dua saku lai. ");
INSERT INTO mkn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma tukang suru-suru nomer tiga yang tarima doi satu saku tu, dia pi gali lobang di tana, ko sambunyi dia pung bos pung doi tu. ");
INSERT INTO mkn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Lama-lama ju, baru itu bos datang. Ais dia kumpul dia pung tukang suru-suru ko mulai pareksa dia pung doi yang dong su urus tu. ");
INSERT INTO mkn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Itu tukang suru-suru partama maso deng sarakan doi sapulu saku, ju bilang, ‘Ini bos pung doi. Tempo hari bos su kasi beta doi lima saku. Ma sakarang, beta su dapa ontong lima saku lai.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dengar bagitu ju, itu bos sanáng. Dia kasi tau bilang, ‘Bagus! Lu ni, tukang suru-suru yang bae. Lu su karjá rajin, deng lu su iko tarús-tarús beta pung parenta, biar beta sonde ada di sini. Tagal lu su bisa urus hal kici bagini, nanti beta angka sang lu ko urus hal yang lebe bésar lai. Nanti beta bekin pesta ko kotong samua sanáng rame-rame.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ais, itu tukang suru-suru nomer dua datang sarakan sang dia pung bos doi ampa saku, deng bilang, ‘Bos! Dolu bos sarakan kasi beta, doi dua saku. Lia sa, te beta su dapa ontong doi dua saku lai.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Itu bos ju sanáng. Dia kasi tau bilang, ‘Bagus! Lu ni, ju tukang suru-suru yang bae. Lu su karjá rajin, deng lu su iko tarús-tarús beta pung parenta, biar beta sonde ada di sini. Tagal lu su bisa urus hal kici bagini, nanti beta angka sang lu ko urus hal yang lebe bésar lai. Nanti beta bekin pesta ko kotong samua sanáng rame-rame.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ais, itu tukang suru-suru nomer tiga datang. Ju dia kasi tau bilang, ‘Bos! Beta tau bos ni orang hati karás. Te bos ame apa yang orang laen bekin, deng ketu ame apa yang orang laen tanam. ");
INSERT INTO mkn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Beta taku, jang sampe ini doi dong ilang buang, ais bos hukum sang beta. Andia ko beta sambunyi bae-bae sang dia. Ini bos! Ame pulang su, te bos pung doi satu saku ni ada aman-aman sa!’ ");
INSERT INTO mkn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dengar bagitu ju, itu bos masparak sang dia bilang, ‘Lu ni tukang suru-suru jahat deng pamokol mati! Kalo lu su tau bilang, beta ame apa yang orang laen bekin, deng ketu ame apa yang orang laen tanam, ");
INSERT INTO mkn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","akurang ko lu sonde pi simpan beta pung doi di bank sa? Ko biar beta pulang, na, beta bisa dapa dia pung bunga, biar sadiki, ju bae!’ ");
INSERT INTO mkn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ais, itu bos suru dia pung orang suru-suru laen bilang, ‘Ame itu doi dari dia, ko sarakan kasi itu tukang suru-suru yang su dapa ontong doi lima saku tu. ");
INSERT INTO mkn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Te orang yang urus bae-bae apa yang dia su pegang, nanti dia dapa tamba banya lai. Ma orang yang sonde mau urus apa yang dia su pegang tu, nanti dong ame itu samua dari dia. ");
INSERT INTO mkn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tangkap ame ini tukang suru-suru yang sonde ada pung guna apa-apa ni. Hela raroso ko angka buang sang dia pi luar. Kasi tenga ko dia manangis makarereu deng sangsara di tampa galáp sana!’ ” ");
INSERT INTO mkn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ais ju Yesus omong tarús bilang, “Beta, Manusia Tulen ni, nanti turun datang kambali pake Beta pung Bapa pung kuasa yang hebat, sama-sama deng Dia pung ana bua dari sorga. Ais Beta dudu di atas Beta pung korsi parenta yang paling hebat, ko pareksa samua orang pung idop. ");
INSERT INTO mkn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nanti samua orang yang parná idop di dunya, datang mangada sang Beta. Ais Beta kasi pisa sang dong, sama ke gambala kasi pisa domba dari kambing, ko jadi dua kumpul. ");
INSERT INTO mkn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Orang-orang yang idop iko Tuhan Allah pung mau, Beta taro di Beta pung sablá kanan. Ma yang sonde dong, Beta taro di sablá kiri. ");
INSERT INTO mkn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Itu waktu, Beta pegang parenta sama ke Raja. Nanti Beta kasi tau sang itu orang yang ada di Beta pung sablá kanan bilang, ‘Bosong ni yang tarima berkat dari Beta pung Bapa. Mari ko maso pi dalam Dia pung ruma yang Dia su siap memang dari mula-mula kasi sang bosong. ");
INSERT INTO mkn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Beta undang sang bosong, tagal dolu waktu Beta lapar, bosong kasi Beta makan. Waktu Beta aus, bosong kasi Beta minum. Beta datang sama ke orang luar, ma bosong tarima sang Beta di bosong pung ruma. ");
INSERT INTO mkn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Beta sonde ada pung pakean, ma bosong kasi Beta pakean. Beta saki, ma bosong datang urus sang Beta. Beta di bui, ma bosong datang lia sang Beta.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dengar bagitu, nanti itu orang hati lurus dong yang ada di Beta pung sablá kanan tu, manyao bale bilang, ‘Tuhan, ini su karmana ni? Tuhan bilang, Tuhan lapar, ais botong kasi makan. Tuhan aus, ju botong kasi minum. ");
INSERT INTO mkn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tuhan sama ke orang luar, ju botong tarima maso di botong pung ruma. Tuhan sonde ada pung pakean, ais botong kasi. ");
INSERT INTO mkn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tuhan saki, ais botong pi urus. Tuhan di bui, ais botong pi tolong. Ma kapan botong bekin hal-hal bagitu?’ ");
INSERT INTO mkn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nanti Beta manyao sang dong bilang, ‘Parcaya sang Beta! Te waktu bosong bekin hal-hal bagitu kasi Beta pung orang dong, biar bekin kasi orang yang paling tar laku-laku ju, na, itu sama ke bosong su bekin kasi Beta ju!’ ");
INSERT INTO mkn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tarús Beta kasi tau itu orang dong yang ada di Beta pung sablá kiri bilang, ‘Heh, orang jahat dong! Tuhan Allah su kutuk sang bosong. Iskarobis dari sini! Nanti Beta suru orang pi lempar buang sang bosong pi dalam api naraka yang manyala sonde tau abis-abis. Te Tuhan Allah su sadia itu tampa sangsara kasi setan-setan deng dong pung bos bésar. ");
INSERT INTO mkn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Beta usir buang sang bosong, tagal waktu Beta lapar, bosong sonde kasi Beta makan. Waktu Beta aus, bosong sonde kasi Beta minum. ");
INSERT INTO mkn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Beta datang sama ke orang luar, ma bosong sonde tarima sang Beta di bosong pung ruma. Beta sonde ada pung pakean, ma bosong sonde kasi Beta pakean. Beta saki, ma bosong sonde datang urus sang Beta. Beta di bui, ma bosong sonde datang tolong sang Beta.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dengar bagitu, nanti itu orang jahat dong manyao bilang, ‘Tuhan, ini su karmana ni? Tuhan bilang Tuhan lapar, ma botong sonde kasi makan. Tuhan aus, ma botong sonde kasi minum. Tuhan sama ke orang luar, ma botong sonde tarima maso di botong pung ruma. Tuhan sonde ada pakean, ma botong sonde kasi. Tuhan ada saki, ma botong sonde pi urus. Tuhan di bui, ma botong sonde pi tolong. Ma kapan botong ada bekin sang Tuhan bagitu?’ ");
INSERT INTO mkn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nanti Beta manyao sang dong bilang, ‘Parcaya sang Beta! Te waktu bosong sonde tolong orang tar laku-laku dong, na, itu su sama ke bosong sonde tolong sang Beta.’ ");
INSERT INTO mkn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ais, itu orang jahat dong dapa sangsara tarús-tarús sonde tau putus-putus. Ma itu orang yang hati lurus dong, dapa idop tarús-tarús deng Tuhan sonde tau putus-putus.” ");
INSERT INTO mkn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Waktu Yesus su ajar abis itu hal samua sang dong, ju Dia kasi tau Dia pung ana bua dong bilang, ");
INSERT INTO mkn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Bosong su tau, nanti dua hari lai ada kotong pung hari bae, andia Pesta Paska. Itu waktu, nanti ada orang yang jual buang sang Beta, Manusia Tulen ni. Ais dong paku bekin mati sang Beta di kayu palang.” ");
INSERT INTO mkn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Itu waktu, kapala agama Yahudi pung bos-bos deng tua-tua adat dong ada bakumpul di Kayafas pung ruma. Kayafas tu, andia kapala agama Yahudi pung bos bésar. ");
INSERT INTO mkn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Dong ada bacari akal ko mau tangkap sang Yesus deng diam-diam, ko dong bunu sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma dong ator siasat bilang, “Tahan dolo! Kotong jang tangkap sang Dia capát-capát, tagal hari-hari bae su deka. Jang sampe orang banya yang suka sang Dia, bangun mangamok.” ");
INSERT INTO mkn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Di kampong Betania, ada satu orang, nama Simon. Dolu orang noju sang dia, tagal dia kaná panyaki kusta. Ma sakarang dia su bae. Waktu itu hari bae dong balóm datang, ju Yesus dong ada pi makan di Simon pung ruma. ");
INSERT INTO mkn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Waktu dong makan, ju ada satu parampuan datang katumu sang Yesus. Dia ada pegang satu botol, bekin dari batu yang mahal. Itu botol pung isi minya wangi yang mahal mati pung. Ais, itu parampuan puku bekin pata itu botol pung tutu. Ju dia poꞌa kasi malele palán-palán itu minya di Yesus pung kapala, ko jadi tanda dia kasi hormat sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma waktu Yesus pung ana bua dong lia itu parampuan bekin bagitu, ju dong mara, ko dong baꞌomong bilang, “Heh! Jang buang parcuma itu minya wangi yang mahal mati pung! ");
INSERT INTO mkn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Lebe bae dia jual itu minya sa! Ko biar dia pung doi, bagi kasi orang malarat dong!” ");
INSERT INTO mkn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma Yesus tau dong pung pikiran tu, ju Dia omong bilang, “Bosong sonde usa bekin susa ini parampuan! Kasi tenga pi sang dia sa! Beta sanáng, tagal dia su poꞌa ini minya wangi di Beta pung badan. ");
INSERT INTO mkn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Te orang malarat dong salalu ada di bosong pung teng-tenga. Ma sonde lama lai, te Beta ni su sonde ada sama-sama deng bosong. ");
INSERT INTO mkn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Deng ini parampuan poꞌa ini minya ni, dia su sadia Beta pung badan sama ke dia kasi rampe memang Beta pung mayat. Te Beta pung idop su sonde lama lai. ");
INSERT INTO mkn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Inga bae-bae, ó! Di mana sa Tuhan Allah pung Carita Bae tasiar kuliling ini dunya, dong ju pasti carita ini parampuan pung bae, ko biar samua orang inga sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ada satu orang dari Yesus pung ana bua dua blas orang, nama Yudas Iskariot. Itu hari ju, dia kaluar pi cari kapala agama Yahudi pung bos-bos, ko mau sarakan sang Yesus pi dong pung tangan. ");
INSERT INTO mkn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Sampe di dong, ju dia tanya bilang, “Bapa dong! Kalo beta bantu tangkap sang Yesus tu, na, bosong kasi beta apa?” Ju dong manyao bilang, “Kalo lu mau jual buang sang Dia kasi botong, na, botong bayar.” Ais dong itong ame tiga pulu doi perak ko sarakan pi Yudas. ");
INSERT INTO mkn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ais itu, Yudas kaluar, ju dia mulai cari akal ko mau sarakan sang Yesus pi di dong. ");
INSERT INTO mkn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tiap taon, orang Yahudi dong ada hari-hari bae yang dia pung lama tuju hari. Dong subu itu hari bae bilang, ‘Pesta Roti Sonde Pake Ragi’. Waktu itu pesta su mau mulai, Yesus pung ana bua dong datang tanya sang Dia bilang, “Bapa! Ini malam kotong musti buka kotong pung hari-hari bae. Jadi Bapa mau ko botong pi horo domba, deng sadia tampa pesta Paska di mana?” ");
INSERT INTO mkn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ais Dia manyao bilang, “Bosong maso kota, nanti bosong katumu deng satu bapa. Kasi tau sang dia bilang bagini, ‘Bu, é! Bapa Guru rasa su sonde lama lai Dia su mati. Ais Dia ada minta tampa di bu pung ruma, ko Dia pake bekin pesta Paska deng Dia pung ana bua dong.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dengar bagitu ju, Dia pung ana bua dong pi bekin iko Dia pung omong tu. Ais dong sadia makan pesta Paska di situ. ");
INSERT INTO mkn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Waktu su malam ju, Yesus deng Dia pung ana bua 12 orang dudu makan pesta. ");
INSERT INTO mkn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Waktu dong ada makan, ju Dia omong bilang, “Bosong dengar, é! Ada satu dari bosong, yang nanti jual buang sang Beta pi orang laen dong.” ");
INSERT INTO mkn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dengar bagitu, ju dong pung hati rasa tar enak. Tarús dong satu-satu tanya sang Yesus bilang, “Itu orang yang Bapa omong tu, bukan beta, to?” ");
INSERT INTO mkn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ju Dia manyao bilang, “Orang yang colo dia pung roti pi dalam ini mangko sama-sama deng Beta, dia tu yang nanti jual buang sang Beta. ");
INSERT INTO mkn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Inga, é! Beta, Manusia Tulen ni, musti mati sama ke dong su tulis memang dalam Tuhan Allah pung Tulisan Barisi. Ma ati-ati! Itu orang yang mau jual buang sang Beta tu, nanti dia pikol dia pung calaka! Ada lebe bae kalo dia pung mama sonde barana ame sang dia!” ");
INSERT INTO mkn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ais itu, Yudas ju iko tanya bilang, “Tantu itu orang yang Bapa omong tu, bukan beta, to?” Ju Yesus manyao bilang, “Memang lu sandiri su bilang bagitu. Ko sapa lai?” ");
INSERT INTO mkn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Waktu dong masi makan, ju Yesus angka ame roti satu balok, ko minta tarima kasi sang Tuhan Allah. Ais Dia bekin pica-pica itu roti, ju Dia sorong kasi sang Dia pung ana bua dong, deng kasi tau bilang, “Ini roti ni, Beta pung badan. Bosong ame ko makan su!” ");
INSERT INTO mkn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ais itu, Dia ame satu galás ponu deng aer anggor, ko minta tarima kasi sang Tuhan Allah. Ais ju Dia sorong pi Dia pung ana bua dong, deng kasi tau bilang, “Bosong samua ame ko minum. ");
INSERT INTO mkn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Te ini aer anggor ni, Beta pung dara. Nanti Beta mati, Beta pung dara tatumpa ko kasi salamat orang banya dari dong pung sala-sala dong. Ini dara jadi bukti ko kasi inga bilang, apa yang Tuhan Allah su janji tu, memang sakarang ni su jadi. Naa, ame ko minum su! ");
INSERT INTO mkn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ma dengar bae-bae! Mulai dari ini malam, Beta su sonde minum aer anggor lai. Nanti kalo Beta deng Beta pung Bapa su dudu pegang parenta di sorga, baru Beta minum lai deng bosong.” ");
INSERT INTO mkn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ais ju dong manyanyi satu lagu ko puji sang Tuhan Allah. Tarús, itu malam ju, dong kaluar pi gunung Saitun. ");
INSERT INTO mkn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Waktu dong jalan tu, Yesus kasi tau Dia pung ana bua memang bilang, “Nanti sabantar malam ni, bosong samua lari kasi tenga sang Beta. Te dong su tulis memang dalam Tuhan Allah pung Tulisan Barisi bilang, ‘Nanti Tuhan Allah bekin mati gambala, ais dia pung domba dong lari batasiram.’ ");
INSERT INTO mkn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Beta memang mati. Ma nanti kalo Beta su idop kambali, Beta pi tunggu bosong di propinsi Galilea sana.” ");
INSERT INTO mkn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma Petrus protes bilang, “Bapa! Biar orang laen dong samua lari kasi tenga Bapa, ma beta sonde akan!” ");
INSERT INTO mkn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ju Yesus manyao bilang, “Bagitu ko, Peꞌu? Parcaya sang Beta! Ini malam, ayam balóm kokoreꞌo, te lu su omong tiga kali bilang, lu sonde kanál sang Beta!” ");
INSERT INTO mkn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma Petrus bakarás bilang, “Sonde, Bapa! Kalo Bapa mati, beta ju iko mati sama-sama. Te beta sonde akan lari kasi tenga sang Bapa!” Petrus pung tamán laen dong ju satu-satu bilang bagitu. ");
INSERT INTO mkn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ais Yesus dong jalan tarús pi gunung Saitun, sampe di satu kabón, nama Getsemani. Di situ Dia kasi tau sang Dia pung ana bua dong bilang, “Bosong dudu tahan di sini doo, te Beta mau pi sambayang di sana.” ");
INSERT INTO mkn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma Dia pange bawa sang Petrus, Yakobis, deng Yohanis, ko dong tiga pi sama-sama deng Dia. Mulai dari itu waktu, ju Dia pung hati rasa susa deng sonde tanáng. ");
INSERT INTO mkn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dong baru jalan sadiki, te Dia kasi tau sang dong bilang, “Beta pung hati ada susa mau mati! Beta rasa tingka ke Beta su mau mati sa. Bosong dudu mete jaga deng Beta di sini dolo.” ");
INSERT INTO mkn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ais Dia maju lebe jao sadiki, ju Dia tikam lutut ko sambayang bilang, “Bapa manis! Kalo Bapa satuju, na, Beta sonde usa tanggong ini sangsara. Ma jang iko Beta pung mau; biar iko Bapa pung mau sa.” ");
INSERT INTO mkn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sambayang abis, ju Dia kambali pi Dia pung ana bua tiga orang tu. Ma dong ada tidor sonu. Ais Dia kasi bangun sang dong, ju Dia omong deng Petrus bilang, “He, Peꞌu! Kanapa ko bosong tidor? Beta di situ cuma sabantar sa, ma bosong sonde bisa mete jaga sadiki ju! ");
INSERT INTO mkn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Goso bekin taráng bosong pung mata dolo. Ais bangun ko bajaga deng Beta! Te bosong pung hati memang mau bekin yang bae, cuma bosong pung badan sonde kuat. Jadi lebe bae bosong sambayang, ko kalo kaná cobaꞌan, bosong bisa batahan.” ");
INSERT INTO mkn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ais Dia pi sambayang lai bilang, “Bapa! Kalo Beta yang musti pikol ini sangsara, na, biar iko Bapa pung mau sa.” ");
INSERT INTO mkn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sambayang abis, ju Dia datang kambali di Dia pung ana bua tiga orang tu. Ma dong su tidor ulang lai, te dong pung mata talalu barát. ");
INSERT INTO mkn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ais Dia kasi tenga sang dong, ko pi sambayang satu kali lai. Dia minta ulang sang Bapa, ko jang kasi tenga Dia pikol itu sangsara, ma biar iko Bapa pung mau sa. ");
INSERT INTO mkn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sambayang abis, ju Dia kambali ko kasi bangun sang Dia pung ana bua dong bilang, “Bosong masi tidor tarús ni, ko? Bangun su! Te orang yang mau jual buang sang Beta, Manusia Tulen ni, su deka. Sakarang dong su mau tangkap sang Beta, ko sarakan pi orang jahat dong pung tangan. ");
INSERT INTO mkn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Weh! Bangun su! Buka bosong pung mata ko lia coba pi sana dolo! Te itu orang yang jual buang sang Beta tu, su datang.” ");
INSERT INTO mkn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Waktu Yesus masi baꞌomong bagitu, Yudas su datang deng orang bam-banya. Dong datang deng bawa kalewang kudung deng kayu kudung, ko mau tangkap sang Yesus. Dong bekin bagitu, iko parenta dari kapala agama Yahudi pung bos-bos deng tua-tua adat dong. ");
INSERT INTO mkn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas su kasi sein memang sang dong bilang, “Bosong lia bae-bae, é! Orang yang beta ciom tu, bosong tangkap ame sang Dia su! Te Dia tu, andia itu orang yang bosong cari!” ");
INSERT INTO mkn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Waktu dong sampe di Yesus, ju Yudas langsung pi di Dia pung muka, ko bilang, “Saloom, Bapa Guru!” Ju Yudas paló-ciom sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ais Yesus tanya sang dia bilang, “He, Yudas! Lu pung datang ni, buat ini maksud, ko?” Tarús, itu orang banya dong maju datang, ko mau tangkap sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma tau-tau, te Yesus pung orang satu cabu ame dia pung parang, ko seruk bekin putus satu orang pung daon talinga. (Itu orang yang luka tu, andia kapala agama Yahudi pung bos bésar pung orang suru-suru.) ");
INSERT INTO mkn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Lia bagitu, ju Yesus kasi tau sang dia bilang, “Kasi maso lu pung parang kambali pi dia pung tampa. Te orang yang idop deng maen kalewang, nanti dia ju mati kaná kalewang. ");
INSERT INTO mkn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Lu sonde tau, ko? Beta bisa minta Beta pung Bapa ko Dia kirim Dia pung ana bua puluan ribu dari sorga, ko dong datang tolong sang Beta. ");
INSERT INTO mkn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma sonde usa. Kasi tenga sa, ko ini orang dong tangkap ame sang Beta. Te samua yang ada tatulis memang di Tuhan Allah pung Tulisan Barisi soꞌal Beta tu, musti jadi.” ");
INSERT INTO mkn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ais Yesus omong sang itu banya orang yang datang tangkap sang Dia bilang, “Weh! Bosong kira Beta ni, orang jahat, ko? Akurang ko bosong datang tangkap sang Beta deng bawa kalewang kudung deng kayu kudung? Padahal tiap hari Beta ajar sang bosong di Tuhan Allah pung Ruma Sambayang Pusat, ma sonde ada satu orang ju yang bekin apa-apa sang Beta. ");
INSERT INTO mkn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma biar sa! Mari, tangkap sang Beta su! Te ini samua su tatulis memang dari dolu di Tuhan Allah pung Tulisan Barisi.” Lia bagitu ju, Yesus pung ana bua dong taku mau mati. Ju dong bangun lari kasi tenga sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ais ju itu orang dong yang tangkap sang Yesus bawa sang Dia pi kapala agama Yahudi pung bos bésar, Kayafas, pung ruma, tagal orang bésar dong su bakumpul di situ. Andia, kapala agama Yahudi pung bos-bos, guru agama dong, deng tua-tua adat. ");
INSERT INTO mkn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Waktu dong pegang bawa sang Dia tu, Petrus ju ada iko sambunyi-sambunyi dari balakang, sampe di itu bos bésar pung ruma. Petrus ju maso di kintal, ko iko dudu sama-sama deng orang-orang yang ada di situ. Te dia mau tau apa yang nanti jadi. ");
INSERT INTO mkn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Dalam itu ruma, kapala agama Yahudi pung bos-bos ada berunding deng samua orang yang urus parkara agama. Dong samua cari bukti ko mau cari jalan ko putus hukuman mati kasi sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma biar dong sorong saksi palsu yang banya ju, dong sonde dapa bukti apa-apa yang dong bisa pake. Ahirnya dong dapa saksi dua orang. ");
INSERT INTO mkn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Itu dua orang basaksi bilang, “Botong parná dengar ini Orang omong bilang, ‘Nanti Beta kasi rubu Ruma Sambayang Pusat. Ma dalam waktu tiga hari ju, Beta nanti kasi bangun ulang.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ais, itu kapala agama Yahudi pung bos bésar bangun badiri di muka samua orang yang dudu di situ. Ju dia tanya sang Yesus bilang, “Lu su dengar banya orang tudu sang Lu. Ma akurang ko Lu diam-diam sa?” ");
INSERT INTO mkn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma Yesus sonde manyao apa-apa. Ju itu bos bésar tanya lai bilang, “Beta mau tanya ni! Ma Lu musti manyao batúl-batúl sama ke Lu ada manyao kasi Tuhan Allah yang idop di sorga. Ada orang yang bilang, Lu ni, Kristus, Tuhan Allah pung Ana yang Dia su janji dari dolu tu. Batúl tu, ko?” ");
INSERT INTO mkn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ais ju Yesus manyao bilang, “Memang batúl, sama ke pak omong tu. Ma inga, é! Te nanti bosong samua dapa lia Beta, Manusia Tulen ni. Nanti Beta dudu di sorga di Tuhan Allah pung sablá kanan, ko pegang parenta sama-sama deng Dia yang paling kuasa. Ais itu, nanti Beta turun datang kambali deng awan.” ");
INSERT INTO mkn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dengar Dia omong bagitu, ju itu bos bésar mara mau mati, sampe dia ruꞌi bekin tarobe dia pung baju panjang. Ais dia batarea kasi tau samua orang yang dudu di situ bilang, “Woeh! Kotong sonde parlú saksi lai! Bosong su dengar deng bosong pung talinga sandiri, Dia pung omong, to! Dia su angka diri jadi Tuhan Allah pung Ana. Ini su hojat ni! Bosong samua su tau bilang, iko kotong pung atoran agama, kalo ada orang bekin diri sama deng Tuhan, na, itu orang musti mati! ");
INSERT INTO mkn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Jadi sakarang, bosong mau putus bilang, apa?” Ju dong samua batarea bilang, “Ini orang memang sala batúl! Jadi Dia musti kaná hukum mati!” ");
INSERT INTO mkn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ais ada barapa orang maju ko sumbur luda sang Yesus. Ju dong papoko barmaen deng tampeleng sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ais dong ejek sang Dia bilang, “Weh! Lu ni, Kristus, wuang? Coba Lu rai doo! Sapa yang falungku sang Lu?” ");
INSERT INTO mkn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Itu waktu, Petrus masi iko dudu di kintal. Ais ada budak parampuan satu datang omong deng dia bilang, “Tadi lu ju ada iko sama-sama deng Yesus, itu orang Nasaret, to?” ");
INSERT INTO mkn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma dia manyangkal di muka orang banya tu bilang, “Sonde! Akurang ko lu tanya bagitu! Beta sonde kanál sang Dia, ma.” ");
INSERT INTO mkn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ais Petrus kaluar ko pi badiri di muka pintu pagar. Ju ada satu parampuan laen yang lia sang dia di situ. Tarús dia kasi tau sang orang di situ dong bilang, “We, tadi beta lia ini orang ada sama-sama deng Yesus, itu orang Nasaret tu.” ");
INSERT INTO mkn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ju Petrus protes bilang, “Lu gila mangkali! Beta sonde kanál itu Orang, ma! Beta sumpa!” ");
INSERT INTO mkn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sonde lama lai, orang laen dong yang ada di situ omong lai sang dia bilang, “Heh! Lu jang putar-balek lai bilang, lu sonde sama-sama deng itu orang! Te botong dengar lu pung balogat tu, parsís sama ke orang Galilea!” ");
INSERT INTO mkn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma dia mulai maki-maki, ju dia malawan bilang, “Weh! Beta sumpa pake Tuhan Allah pung nama! Beta sonde kanál itu Orang!” Pas dia omong bagitu, ju ayam kokoreꞌo. ");
INSERT INTO mkn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dengar itu ayam pung kokoreꞌo, ju Petrus inga ame Yesus pung bahasa tadi bilang, “Ayam balóm kokoreꞌo, te lu su omong tiga kali bilang, lu sonde kanál sang Beta.” Inga ame bagitu ju, dia pi luar ko manangis maskakeduk. ");
INSERT INTO mkn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Papagi sakali, samua orang yang urus parkara agama tu, basakongkol ko mau bekin mati sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tagal itu, dong ika bawa sang Dia pi mangada sang gubernor Pilatus. Te dong mau ko gubernor hukum mati sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Waktu Yudas tau bilang, Yesus su kaná hukuman mati, ju dia manyasal, tagal dia yang jual buang sang Yesus. Ais dia kambali pi kapala agama Yahudi pung bos-bos, deng tua-tua adat, ko kasi pulang dong pung doi tiga pulu perak tu. ");
INSERT INTO mkn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Dia kasi tau bilang, “Beta su bardosa ni, tagal beta su sarakan Orang yang sonde ada pung sala apa-apa ju.” Ma dong manyao bilang, “Weh! Botong sonde mau toe deng lu lai! Lu sandiri yang musti tanggong itu dosa.” ");
INSERT INTO mkn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ais Yudas lempar buang itu doi pi dalam Ruma Sambayang Pusat. Ju dia kaluar ko pi gantong diri sampe dia mati buang. ");
INSERT INTO mkn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ju kapala agama Yahudi pung bos-bos pi kumpul ame itu doi yang Yudas su lempar tu. Dong baꞌomong bilang, “Kotong sonde bole kasi maso kambali ini doi pi dalam peti doi, tagal ini doi kotor. ");
INSERT INTO mkn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jadi lebe bae kotong pi béli tana sapoꞌong dari tukang bekin pareu. Kalo ada orang asing yang mati, deng sonde ada orang yang kanál sang dia, na, kotong bisa kubur sang dia di situ sa.” ");
INSERT INTO mkn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ais ju dong pake itu doi, ko pi béli itu tana. Andia ko sampe sakarang, orang subu itu tampa bilang, ‘Tana Dara’. ");
INSERT INTO mkn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Deng bagitu, dong iko apa yang Tuhan pung jubir Yeremia su omong memang bilang, “Dong pake buang doi perak tiga pulu ko béli tana. Dong pake itu doi, tagal itu doi tu, harga béli orang, iko apa yang orang Israꞌel dong su putus memang. ");
INSERT INTO mkn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Itu tana dong béli dari tukang bekin pareu, iko Tuhan Allah pung parenta sang beta.” ");
INSERT INTO mkn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Waktu itu orang dong ame bawa Yesus sampe di gubernor, ju dia soꞌal sang Yesus bilang, “Karmana? Lu ni, batúl-batúl orang Yahudi pung Raja, ko?” Yesus manyao bilang, “Batúl. Pak su omong batúl tu.” ");
INSERT INTO mkn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ma waktu kapala agama Yahudi pung bos-bos deng tua-tua adat dong tudu banya hal sang Yesus, Dia sonde manyao apa-apa ju. ");
INSERT INTO mkn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ais gubernor tanya sang Dia bilang, “Lu sonde dengar dong pung omong tu? Dong su kasi sala bam-banya sang Lu. Ma akurang ko Lu sonde balas ju?!” ");
INSERT INTO mkn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Dia sonde manyao sadiki ju, sampe itu gubernor taheran-heran. ");
INSERT INTO mkn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tiap taon, kalo orang Yahudi dong bekin pesta Paska, orang banya dong biasa pili satu orang bui, ko gubernor kasi lapás sang dia. ");
INSERT INTO mkn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Itu waktu, ada orang bui satu, nama Barabas. Samua orang su tau dia tu sapa, tagal dia talalu jahat. ");
INSERT INTO mkn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Itu hari ju, orang banya pi gubernor Pilatus ko minta dia kasi lapás satu orang bui sama ke biasa. Ju Pilatus tanya sang dong bilang, “Bae! Ma beta kasi lapás sang sapa? Di sini ada Barabas, deng ada ju Yesus yang orang subu bilang, Kristus. Beta kasi lapás yang mana? Bosong pili sa.” ");
INSERT INTO mkn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Gubernor omong bagitu, te dia su tau kapala agama Yahudi pung bos-bos ame bawa sang Yesus kasi sang dia, tagal dong ada camburu deng jengkel mati sang Yesus.) ");
INSERT INTO mkn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Waktu gubernor masi pareksa itu parkara, ju dia pung maitua kirim pasán kasi sang dia bilang, “Bapa, é! Ati-ati, ó, te Yesus ni Orang yang sonde ada pung sala apa-apa. Gara-gara Dia, andia ko tadi malam beta mimpi sonde bae. Sampe sakarang ju beta masi rasa tar enak sakali.” ");
INSERT INTO mkn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma itu kapala agama Yahudi pung bos-bos deng tua-tua adat dong tusu-tusu itu orang banya tu, ko dong minta gubernor kasi lapás sang Barabas, deng hukum mati sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ais dia tanya ulang lai sang dong bilang, “Dari ini dua orang ni, beta lapás yang mana?” Ju dong samua manyao rame-rame bilang, “Barabas! Kasi lapás sang Barabas sa!” ");
INSERT INTO mkn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ais dia tanya sang dong bilang, “Kalo bagitu, na, beta bekin karmana deng ini Yesus, yang orang subu bilang, Kristus?” Ju dong samua batarea rame-rame bilang, “Paku bekin mati sang Dia di kayu palang sa!” ");
INSERT INTO mkn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ais gubernor tanya lai bilang, “Ko Dia pung sala apa? Beta su pareksa sang Dia, ma beta sonde dapa Dia pung sala apa-apa ni!” Ma dong samua batarea lebe karás lai bilang, “Bekin mati sang Dia! Paku sang Dia di kayu palang suda!” ");
INSERT INTO mkn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Sonde lama ju, dia tau bilang, dia sonde bisa bekin apa-apa lai, te itu orang banya dong su mau mangamok. Andia ko dia ame aer ko cuci dia pung tangan di dong pung muka, deng kasi tau bilang, “Beta sonde tanggong ini Orang pung mati! Biar bosong yang musti tanggong!” ");
INSERT INTO mkn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ju itu orang banya dong batarea manyao bilang, “Hoo, biar pi! Biar ko botong deng botong pung ana-cucu dong yang tanggong Dia pung dara tu!” ");
INSERT INTO mkn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dengar bagitu, ju dia bilang, “Neu pi.” Ju dia kasi lapás sang Barabas, iko dong pung mau. Ais dia parenta orang jaga dong, ko pi firuk sang Yesus pake cambuk. Firuk abis, ju tantara dong ame bawa sang Yesus, ko mau pi paku bekin mati sang Dia di kayu palang. ");
INSERT INTO mkn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ais itu, tantara dong hela bawa sang Yesus pi dong pung benteng pung kintal bésar. Di situ, dong pange ame dong pung tamán satu batalyon. ");
INSERT INTO mkn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ju dong kasi pake sang Dia satu baju panjang warna mera manyala. ");
INSERT INTO mkn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ais dong ame pohon baduri pung takis ko malaꞌe bekin topi. Ju dong tendes itu topi baduri pi Yesus pung kapala, ko bekin maen-maen sama ke dong mau angka raja baru pake topi jabatan. Ais dong kasi Dia pegang kayu satu di Dia pung tangan kanan, sama ke tongkat parenta. Ju dong tikam lutut mangada sang Dia, deng dong ejek sang Dia bilang, “Hormat orang Yahudi pung Raja.” ");
INSERT INTO mkn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ju dong buang luda sang Dia, deng ame itu tongkat dari Dia pung tangan, ko kadeluk barmaen Dia pung kapala. ");
INSERT INTO mkn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dong olok barmaen abis sang Dia, ju dong buka buang itu baju panjang. Tarús dong kasi pake ulang Dia pung pakean. Ais ju dong ame bawa sang Dia pi kaluar kota Yerusalem, ko mau pi paku sang Dia di kayu palang sampe mati. ");
INSERT INTO mkn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Waktu dong ada hela bawa sang Yesus, di tenga jalan dong nae katumu satu orang kota Kirene yang baru mau maso kota Yerusalem. Dia pung nama Simon. Dong paksa sang dia ko pikol ganti Yesus pung kayu palang. ");
INSERT INTO mkn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ais dong sampe di satu tampa, nama Golgota. (Dalam bahasa Aram, dia pung arti bilang, “Tampa tulang kapala.”) ");
INSERT INTO mkn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Di situ dong mau kasi Yesus minum anggor yang su campor deng obat yang pait, ko biar Dia bisa tahan saki. Yesus rasa sadiki ma, ais Dia tola buang. ");
INSERT INTO mkn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ais ju dong paku sang Dia di kayu palang. Ju tantara dong hela lot ko mau tau sapa yang dapa Dia pung pakean. ");
INSERT INTO mkn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ais dong dudu jaga sang Dia di situ. ");
INSERT INTO mkn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dong ju tulis di satu papan bilang, “INI YESUS, ORANG YAHUDI PUNG RAJA” Tarús dong paku itu papan di Dia pung atas kapala, ko kasi tau alasan kanapa ko dong hukum mati sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Di situ, dong ju paku bekin mati dua orang parampok. Satu di Dia pung sablá kanan; satu di Dia pung sablá kiri. ");
INSERT INTO mkn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Samua orang yang jalan lewat situ, lia sang Dia. Ju dong bekin babengko mulu ko olok sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Dong eki-eki sang Dia bilang, “Hoi! Lu bilang Lu bisa kasi rubu Tuhan Allah pung Ruma Sambayang Pusat, ais kasi bangun ulang dalam tempo tiga hari, to? Kalo Lu batúl-batúl Tuhan Allah pung Ana, na, coba Lu kasi lapás Lu pung diri ko turun dari itu kayu palang su.” ");
INSERT INTO mkn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bagitu ju kapala agama Yahudi pung bos-bos, guru agama, deng tua-tua adat iko olok-olok sang Dia bilang, ");
INSERT INTO mkn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Dia su kasi salamat orang laen, ma Dia sonde bisa kasi salamat Dia pung diri sandiri, ó. Dia bilang, Dia tu orang Israꞌel pung Raja! Kalo bagitu, na, lebe bae Dia turun memang dari itu kayu palang. Kalo kotong lia bagitu, baru kotong parcaya sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kalo Dia batúl-batúl Tuhan Allah pung Ana, biar ko ‘Dia baharap sang Tuhan Allah. Jadi, kalo Tuhan suka sang Dia, biar ko Tuhan yang kasi salamat sang Dia.’ ” ");
INSERT INTO mkn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Itu parampok dua orang tu, ju iko baꞌolok sang Dia bagitu. ");
INSERT INTO mkn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ais itu, galáp gulita tutu ame itu tampa dari tenga hari sampe jam tiga sore. ");
INSERT INTO mkn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pas jam tiga sore, ju Yesus batarea pake bahasa Aram bilang, “Eli! Eli! Lema sabaktani?” (Dia pung arti bilang, “Beta pung Tuhan! Beta pung Allah, é! Akurang ko Bapa bale balakang kasi tenga sang Beta bagini?”) ");
INSERT INTO mkn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ada barapa orang deka-deka di situ dengar Dia pung suara tu. Ju dong bilang, “Hoi! Bosong dengar dolo. Dia ada pange sang Elia, Tuhan pung jubir dolu-dolu tu!” ");
INSERT INTO mkn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ais satu orang lari-lari pi ame lumut ko calóp maso pi dalam anggor asam. Ju dia tusu itu lumut deng ujung tongkat, tarús sorong pi Yesus pung bibir ko Dia isap. ");
INSERT INTO mkn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma ada orang laen lai yang omong bilang, “Tunggu dolo ko kotong lia coba, Elia mau datang kasi salamat sang Dia, ko sonde?” ");
INSERT INTO mkn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ais Yesus batarea ulang lai deng suara karás, ju Dia mati. ");
INSERT INTO mkn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Di Ruma Sambayang Pusat, ada satu gorden bésar tagantong ko pele Tuhan Allah pung Kamar Paling Barisi. Parsís Yesus pung putus napas, ju itu gorden tarobe putus bagi dua, dari atas sampe bawa. Ju tana tagoyang, sampe batu bésar tabalá. ");
INSERT INTO mkn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kubur-kubur dong ju tabuka. Deng Tuhan Allah pung orang yang su mati, ada yang Dia kasi idop kambali. ");
INSERT INTO mkn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Waktu Yesus su idop kambali, ju dong kaluar datang dari kuburan, ais maso pi Yerusalem. Banya orang dapa lia sang dong di situ. ");
INSERT INTO mkn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Di Golgota, ada komandán deng dia pung ana bua yang jaga Yesus di kayu palang. Waktu dong lia bumi tagoyang, deng samua hal yang su jadi tu, ju dong taku mau mati. Dong baꞌomong bilang, “Awii! Ini Orang ni, memang batúl-batúl Tuhan Allah pung Ana!” ");
INSERT INTO mkn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Di situ ju ada mama barapa orang, yang iko lia Dia pung mati dari jao. Dong su iko sang Dia dari Galilea, te dong yang layani sang Dia dari dolu. ");
INSERT INTO mkn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dari itu mama dong, ada Maria dari kampong Magdala, Maria yang satu lai (andia Yakobis deng Yusuf pung mama), deng Sabadeus pung maitua (andia Yakobis deng Yohanis pung mama). ");
INSERT INTO mkn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Di situ ada satu orang kaya dari kampong Arimatea, nama Yusuf. Dia su lama iko Yesus pung ajaran. Naa, Yesus pung mati tu, jato kaná deng hari Jumat. Dia pung beso kaná deng orang Yahudi dong pung hari sambayang. Andia ko waktu matahari mau tanggalám, ju Yusuf cari jalan ko mau kasi turun memang Yesus pung mayat dari itu kayu palang. ");
INSERT INTO mkn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ais dia pi gubernor Pilatus, ko minta Yesus pung mayat. Ais gubernor parenta ko dong sarakan itu mayat sang Yusuf. ");
INSERT INTO mkn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tarús Yusuf pi Golgota. Ju dia kasi turun Yesus pung mayat dari kayu palang tu. Ju dia bungkus bae-bae itu mayat deng kaen baru yang mahal. ");
INSERT INTO mkn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Itu waktu, orang baru pahat abis satu lobang di gunung batu, ko sadia memang kubur kasi Yusuf deng dia pung kelu dong kalo dong mati. Jadi Yusuf dong koko kasi maso Yesus pung mayat ko pi taro dalam itu lobang. Tarús dong guling ame satu batu bésar, ko dong tutu bae-bae itu lobang. Ais itu, Yusuf dong pulang. ");
INSERT INTO mkn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Itu waktu, Maria dari Magdala deng Maria yang laen tu, ju iko sampe di situ. Dong dudu-dudu mangada pi itu lobang. ");
INSERT INTO mkn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Dia pung beso, kaná deng orang Yahudi pung hari barenti karjá. Ju kapala agama Yahudi pung bos-bos deng orang Farisi dong pi mangada sang gubernor. ");
INSERT INTO mkn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Dong kasi tau bilang, “Pak gub, botong inga waktu itu tukang tipu masi idop, dia ada parná bilang bagini: ‘Beta memang mati, ma lewat tiga hari ju, Beta idop kambali.’ ");
INSERT INTO mkn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tagal itu, pak tolong suru tantara dong ko jaga bae-bae itu kubur sampe dia pung tiga hari. Deng bagitu, Dia pung ana bua dong sonde bisa mancuri ame Dia pung mayat, ko tipu orang bilang, Dia su idop kambali. Te kalo dong tipu bagitu, itu su lebe jahat dari dong pung tipu dolo tu, waktu dong bilang Dia tu, andia Kristus.” ");
INSERT INTO mkn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dengar bagitu, ju gubernor manyao bilang, “Bae ju! Ma bosong ada pung orang jaga sandiri. Lebe bae pake sang dong sa, ko pi jaga bae-bae itu tampa.” ");
INSERT INTO mkn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ais dong pi di itu tampa, deng bawa dong pung orang jaga. Sampe di situ, dong segel mati itu batu di kubur pung pintu. Ju dong suru itu orang ko jaga tarús itu tampa, ko orang laen jang datang ame itu mayat. ");
INSERT INTO mkn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ais hari Minggu papagi, ju Maria dari Magdala deng Maria yang laen tu, pi lia itu tampa kubur. ");
INSERT INTO mkn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Takuju sa, bumi tagoyang hebat. Tuhan Allah pung ana bua satu dari sorga turun datang, ju dia pi guling buang itu batu bésar yang ada tutu itu lobang. Ais ju dia dudu di itu batu pung atas. ");
INSERT INTO mkn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Itu ana bua pung muka basinar sama ke kilat, deng dia pung pakean puti barisi. ");
INSERT INTO mkn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Itu orang jaga dong taku mau mati, sampe gamatar dingin, deng dong sonde bisa bagarak tingka ke orang mati. ");
INSERT INTO mkn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ju itu ana bua dari sorga tu, kasi tau sang itu mama dong bilang, “Bosong sonde usa taku! Beta tau bosong datang cari sang Yesus, itu Orang yang dong paku bekin mati di kayu palang tu. ");
INSERT INTO mkn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ma Dia su sonde ada di sini lai. Te Dia su idop kambali, sama ke Dia su omong memang tu. Mari maso ko lia sandiri itu tampa yang dong taro Dia pung mayat. Itu tampa su kosong! ");
INSERT INTO mkn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Naa, sakarang bosong pulang capát-capát su! Pi kasi tau sang Dia pung ana bua dong bilang, Yesus su idop kambali. Dia su jalan lebe dolo pi Galilea. Dong musti pi katumu deng Dia di sana, sama ke dolu Dia su janji memang sang dong. Parcaya sa. Pulang su ko kasi tau apa yang beta omong ni!” ");
INSERT INTO mkn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ju itu mama dong lari kaluar kasi tenga itu tampa. Dong rasa taku, ma dong ju ada rasa sanáng. Dong pulang capát-capát ko lapor itu hal samua sang Dia pung ana bua dong. ");
INSERT INTO mkn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma sampe di tenga jalan, takuju sa Yesus datang katumu sang dong. Dia omong bilang, “Saloom!” Lia bagitu, ju dong datang deka-deka ko paló Dia pung kaki, deng sémba sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ju Dia omong bilang, “Jang taku, é! Pi kasi tau Beta pung ana bua dong, ko dong pi tunggu sang Beta di Galilea.” ");
INSERT INTO mkn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Waktu itu mama dong masi di tenga jalan, ju itu orang jaga dong kambali pi kota. Dong pi lapor di kapala agama Yahudi pung bos-bos, samua hal yang su jadi tu. ");
INSERT INTO mkn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ju itu bos-bos ator siasat deng tua-tua adat dong, ko tempel doi bam-banya di itu orang jaga dong, ko tutu dong pung mulu. ");
INSERT INTO mkn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Itu bos dong kasi tau bilang, “Bagini. Kalo orang tanya, na, bosong musti manyao bilang, malam-malam bosong ada tidor sonu. Tau-tau, te Dia pung ana bua dong datang mancuri ame Dia pung mayat. ");
INSERT INTO mkn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Deng kalo pak gub dengar itu hal, na, bosong jang taku, te nanti botong yang ator sang bapatua.” ");
INSERT INTO mkn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ju itu orang jaga dong ame itu doi. Dong bekin iko itu bos-bos dong pung mau. Andia ko sampe sakarang orang Yahudi dong masi parcaya itu carita putar-balek tu. ");
INSERT INTO mkn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Dengar abis itu mama-mama dong pung laporan, ju Yesus pung ana bua sablás orang tu, pi propinsi Galilea ko katumu deng Dia di satu gunung, iko Dia pung janji. ");
INSERT INTO mkn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Waktu dong lia sang Dia di sana, ju dong sémba sang Dia. Biar bagitu, ma masi ada yang pung hati bacabang. ");
INSERT INTO mkn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ju Dia datang deka-deka sang dong, ais omong bilang, “Tuhan Allah su kasi Beta kuasa, ko Beta parenta samua yang ada di sorga, deng samua yang ada di dunya. ");
INSERT INTO mkn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jadi bosong pi mana-mana, na, bosong musti kasi tau samua suku-bangsa Beta pung Carita Bae. Bosong musti ajar bae-bae sang dong ko biar dong jadi Beta pung ana bua. Deng bosong musti sarani sang dong ko jadi tanda bilang, dong su taꞌika deng Bapa, deng Dia pung Ana, deng Dia pung Roh yang Barisi. ");
INSERT INTO mkn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Deng ajar sang dong ko bekin iko samua parenta yang Beta su kasi tau sang bosong. Inga, é! Beta ada tarús-tarús di bosong pung teng-tenga, sampe ini dunya kiamat.” ");
INSERT INTO mkn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ini carita bae. Ini, Tuhan Allah pung Ana pung carita. Dia pung nama Yesus Kristus, yang Tuhan Allah su tunju memang dari dolu. Dia pung carita mulai bagini: ");
INSERT INTO mkn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yesus balóm mulai Dia pung karjá, te Tuhan Allah su utus satu orang, nama Yohanis. Yohanis musti pi sadia jalan kasi Yesus pung datang. Te dolu-dolu, Tuhan Allah su pake Dia pung jubir satu, nama baꞌi Yesaya. Dia su tulis memang bilang: “Dengar, ó! Beta suru Beta pung orang satu, ko pi buka jalan kasi sang Lu. ");
INSERT INTO mkn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Itu orang nanti pi tampa sunyi, ko batarea bilang: ‘Samua orang siap-siap bekin bae jalan, ko tarima Tuhan pung datang! Bekin lurus jalan ko sambut sang Dia.’ ” ");
INSERT INTO mkn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Orang biasa pange sang Yohanis, Tukang Sarani. Dia tenga di tampa sunyi. Dia pung pakean bekin dari onta pung bulu. Dia pung ika pinggang bekin dari binatang pung kulit. Dia pung makanan, kalamak deng madu utan. Yohanis pung cara idop ni, sama ke baꞌi Elia dolu-dolu. Itu waktu, banya orang dari kota Yerusalem, deng propinsi Yudea pung isi samua, datang katumu deng Yohanis di dia pung tampa. Dong datang ko mau lia sang Yohanis deng mau dengar dia pung ajaran. Yohanis kasi tau sang dong bilang, “Bosong musti mangaku deng kasi tenga bosong pung sala samua, ko biar Tuhan Allah hapus buang itu sala dong. Ais bosong musti sarani dolo, ko jadi tanda bilang, bosong su babae deng Tuhan.” Dengar abis bagitu, ju dong mangaku sala, ais dia sarani sang dong di kali Yarden. ");
INSERT INTO mkn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Dia kasi tau bilang, “Nanti ada satu Orang yang lebe hebat dari beta mau datang. Biar cuma jadi Dia pung tukang suru-suru sa ju, beta sonde pantas. ");
INSERT INTO mkn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Beta cuma bisa sarani sang bosong pake aer sa, ma nanti Dia bekin lebe dari beta, te Dia bekin ponu bosong pung hati deng Tuhan pung Roh yang Barisi.” ");
INSERT INTO mkn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Itu waktu, Yesus datang dari kampong Nasaret di propinsi Galilea ko katumu sang Yohanis. Ju Yohanis sarani sang Dia di kali Yarden. ");
INSERT INTO mkn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Waktu Yesus kaluar dari aer, takuju ju, dapa lia langit tabuka. Ais ju Tuhan pung Roh turun pi Dia, sama ke burung pompa. ");
INSERT INTO mkn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ju dapa dengar Tuhan Allah pung suara dari langit bilang, “Lu ni, Beta pung Ana sayang. Lu salalu bekin sanáng sang Beta.” ");
INSERT INTO mkn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ais itu, Tuhan pung Roh hela bawa sang Yesus pi tampa kosong yang sunyi. ");
INSERT INTO mkn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Di situ ju ada binatang utan dong. Yesus tenga di itu tampa ampa pulu hari. Di situ, setan dong pung bos datang goda sang Yesus ko iko sang dia, ma tar ontong. Ais itu ju, Tuhan Allah pung ana bua dari sorga datang urus sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tempo hari, dong kasi maso sang Yohanis Tukang Sarani pi dalam bui abis, ju Yesus pi propinsi Galilea, ko kasi tau Tuhan Allah pung Kabar Bae di sana. ");
INSERT INTO mkn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Dia omong bilang, “Dengar, ó! Sakarang Tuhan pung waktu su sampe! Sakarang samua orang dapa tau bilang, Tuhan Allah ada pegang parenta. Andia ko bosong musti barenti suda deng bosong pung putar-balek, ko bale iko sang Tuhan. Ais ju parcaya sang Dia pung Kabar Bae ni, suda.” ");
INSERT INTO mkn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Satu hari, Yesus jalan iko dano Galilea pung pinggir. Dia dapa lia satu orang, nama Simon, deng dia pung adi, nama Anderias. Dong dua ada jala ikan. Itu dong pung karjá hari-hari. ");
INSERT INTO mkn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus pange sang dong bilang, “We! Mari ko iko sang Beta suda! Bosong biasa cari ikan, ma sakarang Beta mau bekin sang bosong jadi tukang cari jiwa.” ");
INSERT INTO mkn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dengar abis bagitu ju, dong dua kasi tenga itu jala, ko pi iko memang sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ais itu, Yesus jalan tarús sadiki lai, ju Dia dapa lia Sabadeus pung ana-ana dong. Yang kaka pung nama Yakobis, deng dia pung adi, nama Yohanis. Dong dua ada ator bekin bae pukat dalam parahu. ");
INSERT INTO mkn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus pange sang dong dua bilang, “We! Mari ko iko sang Beta.” Jadi dong dua jalan kasi tenga dong pung papa deng dong pung orang karjá dong di atas parahu. Ju dong pi iko sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ais Yesus deng itu ampa orang yang iko sang Dia, sampe di kota Kapernaum. Waktu orang Yahudi dong pung hari sambayang, ju Yesus maso pi dalam ruma sambayang ko mangajar di situ. ");
INSERT INTO mkn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dengar Dia pung omong, samua orang dong taheran-heran, te Dia tau batúl itu ajaran pung isi. Itu beda deng orang Yahudi pung guru agama dong. ");
INSERT INTO mkn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Itu waktu, ada satu orang yang takaná setan. Dia ju iko maso dalam ruma sambayang, ais itu setan di dalam itu orang batarea bilang, ");
INSERT INTO mkn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Woi! Yesus, orang Nasaret! Lu ada pung urusan apa deng botong! Lu datang ko mau bekin ancor sang botong, ko? Botong kanál sang Lu. Lu ni, Orang yang dolu Tuhan Allah janji ko mau kirim datang. Lu ni, Tuhan pung Orang Barisi yang sonde ada pung sala.” ");
INSERT INTO mkn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma Yesus masparak sang dia bilang, “Tutu lu pung mulu! Kaluar dari itu orang!” ");
INSERT INTO mkn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ju itu setan bekin ame itu orang pung badan batahela karás-karás. Ju dia kaluar dari itu orang deng batarea kuat-kuat. ");
INSERT INTO mkn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ais ju samua orang dalam itu ruma sambayang tanganga. Ju dong samua baꞌomong bilang, “We! Ini apa ni? Dia parenta setan dong ko kaluar, ju dong iko Dia pung mau. Ini ajaran baru, ko? Bapatua pung omong, hebat, ó!” ");
INSERT INTO mkn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ju orang dong mulai bacarita kuliling dari mulu pi mulu, tasiar sampe di samua kampong di propinsi Galilea. ");
INSERT INTO mkn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Waktu dong kaluar dari itu ruma sambayang ju, Yesus pi di Simon deng Anderias pung ruma. Yakobis deng Yohanis pi sama-sama deng dong. ");
INSERT INTO mkn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon pung mama mantu ada saki damám, ko ada tidor di koi. Jadi waktu Yesus deng Dia pung ana bua dong maso di itu ruma, ju orang datang kasi tau bilang, “Mamatua ada saki damám.” ");
INSERT INTO mkn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ais itu, Yesus pi lia mamatua, ju pegang dia pung tangan, ko tolong kasi bangun sang dia. Ju dia pung damám ilang memang. Ais ju mamatua kaluar pi urus sang dong. ");
INSERT INTO mkn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Waktu matahari mulai tanggalám, orang dong datang bawa dong pung orang saki, deng dong pung orang yang takaná setan dong. Dong bawa pi Yesus ko minta tolong. ");
INSERT INTO mkn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sampe manusia satu kota pung isi datang makarubu di muka itu ruma. ");
INSERT INTO mkn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Itu orang dong pung panyaki macam-macam, ma Yesus bekin bae samua. Deng Dia usir kasi kaluar setan jahat pung banya lai. Ma Dia sonde kasi loos itu setan dong baꞌomong, te dong ju ada kanál sang Dia na. ");
INSERT INTO mkn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dia pung beso amper siang, masi galáp buta, Yesus su bangun ko jalan kaluar dari itu ruma. Dia pi satu tampa sunyi ko sambayang, baꞌomong deng Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Waktu Simon dong bangun, sonde dapa lia sang Yesus, ju dong pi cari sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Waktu dong dapa katumu sang Dia, ju dong bilang, “Papa, banya orang ada cari sang Papa.” ");
INSERT INTO mkn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Dia manyao bilang, “Itu ju bae. Ma lebe bae kotong pi kampong-kampong laen dolo, yang deka-deka di sini. Te Beta mau kasi tau Kabar Bae sang dong ju. Ko itu Beta pung tugas na.” ");
INSERT INTO mkn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ais ju Dia jalan kuliling itu propinsi Galilea, ko kasi tau Kabar Bae dari Allah di dong pung ruma-ruma sambayang. Deng Dia ju usir kasi kaluar setan dari orang dong. ");
INSERT INTO mkn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Itu waktu, ada satu orang panyaki kusta datang sang Yesus. Ju dia tikam lutut ko minta tolong sang Yesus bilang, “Papa, é! Tolong beta dolo! Te beta tau, Papa bisa kasi ilang beta pung panyaki ni, ko biar orang jang noju lai sang beta. Asal Papa mau.” ");
INSERT INTO mkn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ais ju Yesus jato kasian itu orang, ju Dia sorong tangan ko raba sang dia bilang, “Memang, Beta mau! Naa, lu bae suda!” ");
INSERT INTO mkn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Takuju sa, itu orang pung panyaki ilang. Ais ju dia bae memang. ");
INSERT INTO mkn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ju Yesus suru itu orang ko pulang, deng kasi inga sang dia ");
INSERT INTO mkn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","bilang, “Inga bae-bae! Lu su bae, ma sonde bole kasi tau sapa-sapa, é! Lu musti iko baꞌi Musa pung parenta dolu. Jadi pi di kapala agama dolo, ko dia pareksa sang lu pung badan, ko lia lu pung panyaki ilang batúl, ko sonde. Ais itu, lu musti kasi persembahan tanda tarima kasi, ko orang samua tau bilang, lu su bae batúl.” ");
INSERT INTO mkn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma itu orang kaluar abis ju, dia pi bacarita kuliling di mana-mana. Ais ju orang banya cari ko katumu sang Yesus, sampe-sampe Dia sonde bisa tunju muka di kota. Jadi Dia tenga di tampa-tampa sunyi di luar kota sa. Ma dari mana-mana, orang maen malele datang tarús, ko mau katumu sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lewat barapa hari ju, Yesus pi ulang lai di Kapernaum. Ju orang kasi tau di mana-mana bilang, Dia su ada di ruma. ");
INSERT INTO mkn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ais orang dong datang dari mana-mana, ju dong makarubu sampe basesak dalam ruma. Di muka pintu ju, basesak. Ais itu, Yesus kasi tau sang dong Tuhan Allah pung mau. ");
INSERT INTO mkn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yesus masi baꞌomong, ju ada ampa orang dorok bawa satu orang lumpu ko pi Dia. ");
INSERT INTO mkn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma tagal su talalu banya orang, andia ko dong sonde bisa bawa itu orang sampe di Yesus pung muka. Ju dong nae pi atas ruma, ko bongkar atap pas di atas Yesus pung kapala. Waktu atap tabuka, ju dong kasi turun sang itu orang lumpu deng dia pung tikar. ");
INSERT INTO mkn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Waktu Yesus lia sang dong, Dia tau dong parcaya batúl-batúl sang Dia. Ju Dia kasi tau sang itu orang lumpu bilang, “Ana, é! Beta su kasi ampon lu pung sala dong!” ");
INSERT INTO mkn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma di situ ada dudu barapa orang guru agama Yahudi. Waktu dong dengar Yesus pung omong tu, dong rasa tar enak dalam hati. ");
INSERT INTO mkn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ais dong baꞌomong bilang, “Ko ini orang pung barani omong bagitu lai! Cuma Tuhan Allah sa, yang bisa kasi ampon orang dong pung sala. Ma ini orang pung omong tu, bekin diri sama ke dia Tuhan Allah sa. Dia su hojat tu!” ");
INSERT INTO mkn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma Yesus su tau memang dong pung hati. Ais Dia omong bilang, “Bosong jang pikir bagitu! ");
INSERT INTO mkn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Mana lebe gampang? Kalo Beta kasi tau sang ini orang lumpu bilang, ‘Lu pung sala su dapa ampon,’ bosong sonde tau kalo jadi bagitu, ko sonde. Ma kalo Beta bilang, ‘Bangun suda! Angka lu pung tikar ko pulang.’ Kalo dia bangun memang, bosong baru dapa lia bukti bilang, Beta ni, Manusia Tulen. Deng Beta ada pung kuasa deng hak ko kasi ampon orang pung sala.” Ais itu ju, Yesus kasi tau sang itu orang lumpu bilang, ");
INSERT INTO mkn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Lu dengar, é! Sakarang lu su bae! Jadi bangun, angka tikar ko pulang su, é.” ");
INSERT INTO mkn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dengar bagitu, ju itu orang bangun memang. Ais dia angka dia pung tikar, ju jalan kaluar. Samua orang di situ lia deng dong pung mata biji. Ju dong samua tanganga, ko bilang, “Awii! Botong baru parná lia yang bagini, ó! Tuhan Allah memang pung hebat lai!” ");
INSERT INTO mkn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ais itu ju, Yesus pi ulang lai di dano Galilea pung pinggir. Banya orang datang katumu sang Dia, ju Dia kasi tau sang dong Tuhan Allah pung mau. ");
INSERT INTO mkn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Di situ, ada satu orang, nama Lewi, Alpius pung ana. Dia karjá di tampa bayar bea kasi sang pamarenta Roma. Pas Yesus jalan lewat di situ, Dia dapa lia sang Lewi. Ju Dia bilang, “We! Mari ko iko sang Beta!” Dengar Yesus bilang bagitu ju, Lewi bangun ko iko memang sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ais itu ju, Yesus dong ada dudu makan di Lewi pung ruma, sama-sama deng Lewi pung tamán tukang tagi bea dong. Ada orang laen ju, yang orang Yahudi anggap orang tar bae dong, iko makan deng dong. Dari itu orang yang dudu makan dong, ada banya yang suka dengar sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Itu waktu, ada guru agama dari partei Farisi barapa orang, dapa lia Yesus dudu makan deng tukang tagi bea, deng itu orang sonde bae dong. Ju dong tanya sang Dia pung ana bua dong bilang, “Akurang ko bosong pung Guru dudu makan deng itu orang tukang tagi bea, deng itu orang tar bae dong?” ");
INSERT INTO mkn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma Yesus dapa dengar dong batanya bagitu, ju Dia manyao bilang, “Orang saki memang parlú dokter, ma orang su bae sonde parlú. Beta datang ko urus orang yang tar bae dong. Ma sonde datang ko urus orang yang su rasa diri batúl dong.” ");
INSERT INTO mkn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Satu kali, orang dari partei agama Farisi dong ada puasa. Dong lia Yohanis Tukang Sarani pung ana bua dong ju ada puasa. Ma dong sonde lia Yesus pung ana bua dong puasa sama ke dong. Ais dong pung orang datang katumu deng Yesus ko batanya bilang, “Papa. Botong ada puasa. Yohanis pung orang dong ju puasa. Ma, akurang ko Papa pung ana bua dong sonde puasa?” ");
INSERT INTO mkn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ju Yesus manyao bilang, “Memang bosong su tau, kalo ada pesta kawin, tamu dong sonde puasa, ma dong makan sampe kinyang. Kalo baroit laki-laki masi ada di situ, tantu dong samua makan rame-rame. ");
INSERT INTO mkn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma nanti satu kali, kalo orang laen tangkap bawa itu baroit laki-laki dolo, dia pung tamán dong rasa susa, baru dong puasa.” ");
INSERT INTO mkn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ais ju Yesus tamba satu umpama bilang, “Orang sonde tempel ko jaet kaen baru di baju lama. Te nanti kalo cuci, itu kaen baru takundur, ko bekin tamba tarobe lai itu baju lama. ");
INSERT INTO mkn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sama ju, ke orang sonde isi tuak baru pi dalam haik yang su lapuk. Te nanti itu haik pica, ju itu tuak malele buang. Jadi tuak baru musti poꞌa pi dalam haik yang baru.” Deng bagitu, Yesus ajar sang dong bilang, Dia pung ajaran baru, jang kasi campor deng orang Farisi dong pung ajaran lama. ");
INSERT INTO mkn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Satu kali, pas deng orang Yahudi pung hari sambayang, Yesus ada jalan lewat iko kabón. Ju Dia pung ana bua dong ketu ame padi-gandum ko makan. ");
INSERT INTO mkn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma orang Farisi dong dapa lia, ais ju dong kasi tau sang Yesus bilang, “Akurang ko lu pung ana bua dong langgar kotong pung atoran agama? Dong ada ketu padi-gandum pas deng hari barenti karjá! Bosong sonde bole bekin bagitu!” ");
INSERT INTO mkn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Dia manyao bilang, “Karmana, ó? Bosong sonde inga baꞌi Daud pung carita tu. Itu waktu, bapatua Abiatar jadi kapala agama Yahudi dong pung bos bésar. Baꞌi Daud deng dia pung ana bua dong pung parú su karoncong sampe lapar mau mati. Ju dong maso pi dalam Tuhan Allah pung Tenda Sambayang, ko ame itu roti yang kapala agama dong su kasi sang Tuhan, ko dong makan. Padahal cuma kapala agama dong sa yang bole makan, ma orang laen sonde bole. Ais baꞌi Daud dong makan, ma sonde ada orang kasi sala sang dong.” ");
INSERT INTO mkn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ju Yesus kasi tau tamba bilang, “Bosong jang lupa bilang, Tuhan Allah bekin hari barenti karjá ko jadi berkat, ko tolong kotong manusia. Ma Dia sonde bekin kotong manusia ko cuma iko hari barenti karjá pung atoran sa. ");
INSERT INTO mkn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jadi Beta ni, Manusia Tulen. Beta yang ada pung hak ko bilang manusia bole, ko, sonde bole bekin apa-apa pas deng hari barenti karjá.” ");
INSERT INTO mkn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ais itu ju, Yesus kambali lai pi ruma sambayang. Di situ Dia lia ada satu orang yang dia pung tangan mati sablá. ");
INSERT INTO mkn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Di situ ju, ada barapa orang yang cari-cari jalan ko mau kasi sala sang Yesus. Jadi dong tarús lur-lur sang Dia, ko mau tau Dia mau bekin bae itu orang, pas deng hari barenti karjá, ko sonde. ");
INSERT INTO mkn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ju Yesus pange sang itu orang yang tangan mati sablá bilang, “Mari ko lu badiri di muka sini.” ");
INSERT INTO mkn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ju Dia tanya sang itu orang dong samua bilang, “Kalo iko kotong pung atoran agama, kotong bole bekin apa, pas deng hari barenti karjá? Kotong bekin bae, ko sonde? Kotong bekin bae orang, ko, bunu bekin mati?” Ma dong samua diam sa. ");
INSERT INTO mkn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tarús ju Yesus pung hati talalu susa, tagal dong lebe pusing dong pung atoran, ma sonde toe deng itu orang yang tangan mati sablá. Ju Dia mara ko peꞌe mata lia kuliling sang dong. Ais ju Dia kasi tau itu orang bilang, “Sorong lu pung tangan suda!” Itu orang sorong dia pung tangan, ju takuju sa, dia pung tangan bae memang. ");
INSERT INTO mkn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ais ju itu orang Farisi dong kaluar kasi tenga itu ruma sambayang. Ju dong pi basakongkol deng orang dari partei politik Herodes, ko cari jalan mau bunu mati sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Satu kali, Yesus deng Dia pung ana bua dong ondor pi dano Galilea pung pinggir. Ma tagal orang banya su dengar apa yang Dia su bekin, andia ko dong samua datang dari kampong-kampong ko iko sang Dia. Dong datang dari propinsi Galilea, propinsi Yudea, deng propinsi Idumea. Ada orang laen ju datang dari kota Yerusalem, kota Sidon, deng kota Tirus. Deng ada yang laen ju datang dari kali Yarden pung sablá matahari nae. Dong samua cari ko bakatumu deng Dia. ");
INSERT INTO mkn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tagal orang dong bagitu banya, sampe Yesus suru Dia pung ana bua dong ko sadia kasi sang Dia satu parahu. Dia mau baꞌomong di atas parahu, ko dong samua dapa dengar, deng Dia sonde tapele. ");
INSERT INTO mkn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Dolu Dia parná bekin bae banya orang saki. Andia ko sakarang samua orang saki dong datang baseti ko mau raba sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Waktu orang yang setan su maso dong dapa lia sang Dia, tarús dong jato sampe muka kaná tana di Yesus pung muka. Ais ju dong batarea bilang, “Lu ni, memang Tuhan Allah pung Ana!” ");
INSERT INTO mkn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma Dia larang karás sang dong bilang, “Bosong jang kasi tau orang bilang, Beta ni sapa!” ");
INSERT INTO mkn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ais ju Yesus nae pi atas satu gunung. Dia pange ame barapa orang yang kaná deng Dia pung hati. Ju dong datang sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tarús Dia tunju ame dua blas orang. Dia bilang sang dong, “Beta pili sang bosong ko iko tarús sang Beta, ko jadi Beta pung utusan. Beta ju mau suru sang bosong ko pi kasi tau Tuhan Allah pung pasán di samua orang. ");
INSERT INTO mkn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Deng Beta mau kasi kuasa sang bosong, ko bosong bisa usir setan dari orang dong.” ");
INSERT INTO mkn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Itu dua blas orang dong pung nama, andia: Simon (yang Yesus ju kasi nama, Petrus), Yakobis, Yohanis, (Yakobis deng dia pung adi Yohanis ni, dong dua, Sabadeus pung ana. Yesus kasi nama sang dong dua ‘Boanerges’, dia pung arti ‘sama ke guntur’.) Anderias, Filipus, Bartolomeos, Mateos, Tomas, Yakobis (Alpius pung ana), Tadius, Simon (yang iko partei politik Selot), deng Yudas Iskariot (dia ni yang nanti jual buang sang Yesus). ");
INSERT INTO mkn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ais itu, Yesus deng Dia pung ana bua dong turun kambali dari itu gunung. Ju dong maso pi dalam ruma. Ma orang banya datang makarubu lai sang Yesus, sampe dong su sonde sampat makan lai. ");
INSERT INTO mkn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lia bagitu ju, orang bilang, “Coba lia sang Yesus dolo. Dia su lupa urus diri.” Tagal Dia pung kelu dong su dengar orang baꞌomong bagitu, andia ko dong datang mau ame bawa sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Itu waktu, guru agama dong dari Yerusalem datang ko kasi tau orang di situ bilang, “Weh! Bosong jang iko-iko sang itu Yesus. Te Dia bisa usir setan bagitu, tagal Dia dapa kuasa dari setan dong pung bos, yang orang biasa pange Balsebul.” ");
INSERT INTO mkn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus dengar bagitu, ju Dia pange ame sang dong samua, ko bilang, “Sonde maso akal! Karmana ko setan dong pung bos bisa usir dia pung diri sandiri? Sonde bisa! ");
INSERT INTO mkn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kalo dalam satu karajaꞌan, dia pung rakyat dong baku hantam, karmana ko itu karajaꞌan masi bisa batahan? Sonde bisa! ");
INSERT INTO mkn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Deng kalo isi ruma dong satu baraꞌu deng satu, karmana ko dong masi bisa batahan? Sonde bisa! ");
INSERT INTO mkn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bagitu ju kalo setan dong satu bamusu deng satu, pasti dong tapica-pica. Kalo bagitu, na, dong ancor-ancor! ");
INSERT INTO mkn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kalo orang mau datang rampok barang di satu orang kuat pung ruma, dia musti ika mati itu tuan ruma dolo. Abis, baru dia bisa rampok itu orang pung barang. ");
INSERT INTO mkn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jadi Beta kasi tau memang sang bosong: Tuhan Allah su sadia hapus buang orang dong pung sala. Deng kalo orang omong tar bae-bae soꞌal orang laen, Tuhan Allah masi sadia kasi ampon sang dia. ");
INSERT INTO mkn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma kalo ada orang yang barani omong tar bae-bae kasi Tuhan Allah pung Roh yang Barisi, Tuhan Allah sonde kasi ampon lai dia pung sala tu, sampe kiamat ju!” ");
INSERT INTO mkn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus bilang bagitu, tagal dong su cap ame sang Dia bilang, “Itu Orang su kaná setan!” ");
INSERT INTO mkn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ais ju Yesus pung mama deng Dia pung adi dong datang pi itu ruma, ko mau katumu deng Dia. Di sana dong badiri sa di luar ruma ko suru orang pange sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Itu waktu, Yesus ada dudu baꞌomong deng banya orang. Ju orang datang kasi tau bilang, “Papa, ó! Papa pung mama deng adi-adi dong ada di luar. Dong mau katumu deng Papa.” ");
INSERT INTO mkn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma Yesus manyao bilang, “Beta pung mama deng Beta pung sodara yang batúl tu, sapa?” ");
INSERT INTO mkn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ais Dia lia pi itu orang yang dudu kuliling sang Dia. Ju Dia omong bilang, “Bosong samua ni, Beta pung mama deng Beta pung sodara yang batúl. ");
INSERT INTO mkn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Te sapa yang bekin iko Tuhan Allah pung mau, na, dong tu, batúl-batúl Beta pung kelu.” ");
INSERT INTO mkn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Satu kali, Yesus pi lai di dano Galilea. Ju orang banya sakali datang makarubu sang Dia. Ais Dia nae pi dudu di atas satu parahu yang ada balabu di situ, ko mangajar. Itu orang di darat dong samua dengar sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ju Dia ajar bam-banya sang dong pake umpama bilang, ");
INSERT INTO mkn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Bosong dengar bae-bae, ó! Ada satu orang pi siram bibit di dia pung kabón. ");
INSERT INTO mkn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Waktu dia siram itu bibit dong, ada yang jato di jalan. Ju burung-burung dong datang ko toto bekin abis itu bibit. ");
INSERT INTO mkn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma ada bibit saparu jato kaná di tana babatu. Itu bibit banupuk capát. Ma tagal itu tana tipis, ");
INSERT INTO mkn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","waktu matahari nae, ju itu nupuk dong mamalek ko mati karíng. Te dong pung akar sonde maso sampe dalam na. ");
INSERT INTO mkn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ada bibit saparu lai jato di tenga rumput baduri. Ju itu rumput baduri dong gepe bekin mati itu nupuk, sampe sonde bisa babua. ");
INSERT INTO mkn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma ada bibit saparu lai jato kaná di tana isi. Itu bibit dong banupuk, abis ju dong jadi bésar sampe babua. Ada yang kasi bale hasil tiga pulu kali, ada yang anam pulu kali, deng ada yang sampe saratus kali. ");
INSERT INTO mkn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jadi bosong sapa yang ada talinga na, dengar babae, ó!” ");
INSERT INTO mkn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ais ju waktu Yesus su sandiri, Dia pung ana bua dua blas orang, deng barapa orang laen yang su dengar Dia pung ajaran tu, dong datang katumu sang Dia. Dong minta Dia kasi tau itu umpama pung arti. ");
INSERT INTO mkn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ju Yesus manyao bilang, “Tagal bosong mau tau batúl-batúl Tuhan Allah pung parenta, andia ko Beta kasi tau memang itu umpama pung arti. Ma kalo orang laen, na, Beta ajar deng umpama sa. ");
INSERT INTO mkn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Itu orang laen dong sama ke yang Tuhan Allah pung jubir su tulis memang bilang, ‘Dong su lia, ma sonde mau mangarti. Dong su dengar, ma sonde mau tau. Biar ko dong sonde usa parcaya sang Tuhan, ko Tuhan sonde parlú kasi ampon sang dong lai.’ ” ");
INSERT INTO mkn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ais ju Yesus kasi tau sang dong itu umpama pung arti bilang, “Kalo bosong balóm tangkap ame ini umpama pung arti na, karmana ko bosong bisa tangkap umpama yang laen dong pung arti? ");
INSERT INTO mkn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jadi dia pung arti, bagini: itu orang yang siram bibit tu, andia sama ke orang yang baꞌomong Tuhan Allah pung Kata-kata. ");
INSERT INTO mkn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Deng itu bibit yang jato di jalan sampe burung makan abis, sama ke orang yang dengar Tuhan Allah pung Kata-kata. Ma sonde lama ju, setan dong pung bos datang ko angka bawa itu Kata-kata dari itu orang pung hati. ");
INSERT INTO mkn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bibit yang jato kaná di tana babatu tu, sama ke orang yang su dengar deng tarima itu Kata-kata deng sanáng hati. ");
INSERT INTO mkn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma itu Kata-kata sonde baꞌakar. Andia ko dia sonde tasimpan lama di itu orang pung hati. Waktu orang laen bekin susa tagal dia tarima itu Kata-kata, dia langsung lapás buang itu Kata-kata. ");
INSERT INTO mkn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Deng bibit yang jato di tenga rumput baduri tu, sama ke orang yang su dengar itu Kata-kata. ");
INSERT INTO mkn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ma dia talalu barepot deng macam-macam urusan ko bisa idop ena-ena sa. Ju itu urusan dong samua, seti buang itu Kata-kata dari dia pung hati, sampe sonde ada hasil apa-apa lai. ");
INSERT INTO mkn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma bibit yang jato kaná di tana isi, sama ke orang yang pasang talinga ko tarima itu Kata-kata, deng iko Tuhan pung mau. Ais dia bekin hal-hal yang bae sa, sama ke bibit yang babua tu. Ada yang babua tiga pulu kali lipat, ada yang anam pulu, deng ada yang sampe saratus kali.” ");
INSERT INTO mkn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus omong tarús dari atas itu parahu. Dia kasi tamba lai satu umpama bilang, “Karmana! Bosong parná ko sonde, lia orang pake lampu teꞌoek, ais tutu sang dia dalam bakul! Ko, taro sang dia di kolong tampa tidor! Sonde, to? Kalo taro bagitu, na, dia sonde taráng lai. Orang musti taro itu lampu di tampa yang tinggi ko taráng. ");
INSERT INTO mkn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jadi barang yang tasambunyi sakarang, nanti dapa lia. Apa yang orang sonde tau sakarang, nanti dapa tau. ");
INSERT INTO mkn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jadi sapa yang ada pung talinga, na, dengar bae-bae. ");
INSERT INTO mkn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Naa, pikir bae-bae! Kalo bosong ukur orang laen pung bekin, orang ju ukur bosong bagitu. Tuhan Allah ju ukur bale sang bosong bagitu. Ma Dia pung ukuran lebe barát lai. ");
INSERT INTO mkn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Naa, kalo orang mau cari tau batúl-batúl Tuhan pung mau, dia tamba pintar. Ma kalo orang sonde pusing deng Tuhan pung mau, dia tamba bodo.” ");
INSERT INTO mkn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ais ju Yesus omong tamba bilang, “Tuhan Allah pung karajaꞌan tamba bésar sama ke bibit yang orang siram di dia pung kabón. ");
INSERT INTO mkn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Biar itu orang pulang, tidor-bangun, sonde inga itu bibit lai, ma itu bibit banupuk deng tamba bésar tarús. ");
INSERT INTO mkn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Te itu bibit idop sandiri di tana, mulai batangke, babunga, sampe baꞌisi. ");
INSERT INTO mkn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kalo padi su kuning, na, tuan kabón tau datang ko koru sa. Tuhan Allah pung karajaꞌan ju bagitu. Samua tu, Tuhan yang karjá.” ");
INSERT INTO mkn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ais itu, Yesus omong sambung lai bilang, “Beta tamba satu umpama lai, bagini: bosong bisa banding Tuhan Allah pung orang dong. Dong mulai deng sadiki sa, ma tamba lama, dong tamba banya. ");
INSERT INTO mkn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Itu tingka ke biji yang paling kici ana. ");
INSERT INTO mkn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma kalo kotong su tanam itu biji, dia idop jadi pohon yang paling bésar. Ju burung-burung datang cari sombar ko basarang di situ.” ");
INSERT INTO mkn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus pung cara ajar sang dong iko dong pung mangarti. ");
INSERT INTO mkn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dia biasa pake umpama kalo ajar sang orang dong. Ma kalo deng Dia pung ana bua dong, Dia kasi tau itu umpama pung arti samua. ");
INSERT INTO mkn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dia pung sore, Yesus masi di atas parahu. Ju Dia suru Dia pung ana bua dong bilang, “Mari kotong balayar pi sablá.” ");
INSERT INTO mkn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ais dong nae parahu sama-sama deng Yesus. Ju dong balayar kasi tenga itu orang banya dong di situ. Ma ada yang iko nae parahu laen. ");
INSERT INTO mkn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Itu waktu, Yesus alas Dia pung kapala di bantal ko tidor sonu di balakang. Sonde lama ju angin ribut datang. Galombang puku kasi maso aer di Yesus dong pung parahu, sampe amper ponu. Jadi ana bua dong taku mau mati. Ju dong datang kasi bangun sang Dia bilang, “Papa! Bangun dolo! Kotong su mau calaka ni! Ma Papa sonde toe sang botong!” ");
INSERT INTO mkn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dengar bagitu, ju Yesus bangun ko togor itu angin bilang, “Diam!” Ais Dia parenta itu dano bilang, “Tadó suda!” Itu angin langsung barenti, deng dano ju tadó memang. ");
INSERT INTO mkn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ais Yesus togor Dia pung ana bua dong bilang, “Akurang ko bosong samua taku bagitu? Bosong sonde parcaya sang Beta, ko?” ");
INSERT INTO mkn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dong samua taku deng heran, ju dong baꞌomong bilang, “Dia ni sapa, é? Sampe angin deng galombang ju dengar sang Dia, ó!” ");
INSERT INTO mkn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ais ju Yesus deng Dia pung ana bua dong sampe di dano Galilea pung sablá, di satu tampa nama Gerasa. ");
INSERT INTO mkn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Di situ ada satu orang laki-laki yang takaná setan sampe gila. Dia tenga di kuburan. Siang-malam dia tapaleuk kuliling bukit-bukit di situ deng talanjang bulat ko batarea tarús-tarús. Dia puku bekin luka dia pung badan deng batu. Ma dia kuat mati pung. Sonde ada orang yang bisa ika sang dia, biar deng rante besi ju. Orang dong su ulang kali ika dia pung kaki-tangan deng rante besi, ma dia bekin putus itu rante deng kasi pata buang besi dari dia pung kaki. Dia talalu kuat sampe sonde ada satu orang ju yang bisa tahan sang dia. Waktu Yesus dong turun dari parahu ko inja kaki di darat, ju itu orang gila dapa lia sang dong dari jao. Ais dia kaluar dari itu kuburan, ju dia lari pi ko tikam lutut di Yesus pung muka. ");
INSERT INTO mkn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Lia itu orang pung muka bagitu, ju Yesus omong bilang, “Hoi! Setan jahat! Lu kaluar dari ini orang su!” Ais, itu orang batarea karás-karás bilang, “Heh! Lu mau bekin apa sang beta! Beta tau Lu ni, memang Yesus, Tuhan Allah yang paling kuasa pung Ana. Beta minta ko Lu jang siksa sang beta!” ");
INSERT INTO mkn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ju Yesus tanya sang dia bilang, “Lu pung nama sapa?” Itu orang manyao bilang, “Beta pung nama Legion, te botong ni, banya sakali, tingka ke banya batalyon!” ");
INSERT INTO mkn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ais setan dong pake itu orang ko minta Yesus jang suru sang dong kaluar dari itu daꞌera. ");
INSERT INTO mkn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sonde jao dari situ ada barapa orang yang jaga babi satu kandang. Itu babi dong samua kira-kira ada dua ribu ekor. Dong ada cari-cari makan di pinggir gunung. ");
INSERT INTO mkn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ais ju itu setan dong minta sang Yesus bilang, “Suru sang botong ko pi maso di itu babi dong.” ");
INSERT INTO mkn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dengar bagitu, ju Yesus satuju. Ju itu setan dong lari kaluar dari itu orang ko maso pi dalam itu babi dong. Ju babi yang dua ribu ekor tu, dong balari harba-biruk turun iko gunung pung pinggir pi dalam dano, ju dong samua mati tanggalám di situ. ");
INSERT INTO mkn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dapa lia bagitu, ju orang yang jaga itu babi dong samua jadi taku mau mati. Ais dong lari pi bakastau orang kuliling kampong-kampong di situ. Ju banya orang kaluar datang ko mau pi lia apa yang su jadi. ");
INSERT INTO mkn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dong datang katumu sang Yesus, ju dong dapa lia itu orang yang takaná setan ada dudu di situ. Dia pung pikiran su jadi bae, deng dia su pake pakean. Lia bagitu ju, itu orang dong samua taku, tagal dong tau, sapa yang bisa usir kasi kaluar banya setan dari itu orang, na, dia memang batúl-batúl orang hebat. ");
INSERT INTO mkn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ais dong samua bakastau kuliling bilang, dong su lia deng mata biji sandiri itu orang gila su bae, deng itu babi dong yang su mati tanggalám. ");
INSERT INTO mkn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ju itu orang kampong di situ dong datang minta ko Yesus kasi tenga dong pung tampa. ");
INSERT INTO mkn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Waktu Yesus mau nae pi dalam parahu, ju itu orang yang tadi takaná setan datang minta sang Dia ko dia ju mau iko. ");
INSERT INTO mkn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma Yesus sonde mau. Dia omong bilang, “Lebe bae lu pulang ko kasi tau lu pung kelu samua, apa yang Tuhan Allah su bekin kasi sang lu. Deng bilang Tuhan Allah talalu sayang sang lu.” ");
INSERT INTO mkn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ais ju itu orang pulang ko pi kuliling satu daꞌera deng sapulu kota yang dong biasa subu bilang, ‘Dekapolis’. Dia bacarita apa yang Yesus su bekin kasi sang dia. Samua orang yang dengar dia pung carita tu, dong heran mau mati bilang, “Memang batúl, ó!” ");
INSERT INTO mkn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ais ju Yesus dong balayar pulang pi dano pung sablá. Waktu dong turun dari parahu, orang banya sakali datang makarubu sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Di situ ju ada satu orang nama Yairus. Dia tu, kapala ruma sambayang di itu kota. Waktu dia lia sang Yesus, ju dia tikam lutut di Dia pung muka ");
INSERT INTO mkn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ko kokoe bilang, “Papa, é! Beta pung ana nona baru umur dua blas taon, ada saki amper mati. Papa tolong datang ko bekin bae sang dia dolo.” ");
INSERT INTO mkn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ju Yesus iko sang Yairus ko pi dia pung ruma. Ma waktu dong mulai jalan, banya orang iko sang Dia sampe dong seti-seti sang Dia dari kiri-kanan. ");
INSERT INTO mkn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Di itu orang banya dong pung teng-tenga, ada satu parampuan yang dia pung datang bulan sonde barenti batúl su dua blas taon. ");
INSERT INTO mkn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dia su kasi abis dia pung doi deng harta dong ko pake bayar dokter dong. Sonde ada yang bisa bekin bae sang dia. Ma dia pung panyaki tu, foe tarús. ");
INSERT INTO mkn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Itu parampuan su dengar banya, soꞌal Yesus. Jadi dia baseti di tenga orang banya tu, ko mau datang deka-deka sang Yesus dari Dia pung balakang. Dia ada pikir di dia pung hati bilang, “Asal beta bisa raba Yesus pung baju sa, pasti beta bae!” Waktu dia sonto Yesus pung baju ju, takuju sa, dia pung dara loos tu, barenti memang. Dia rasa dia su bae batúl. ");
INSERT INTO mkn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pas itu waktu ju, Yesus rasa ada tanaga yang kaluar dari Dia pung badan. Ju Dia bale balakang ko lia itu orang banya dong. Ais Dia tanya bilang, “Bosong sapa yang ada sonto Beta pung baju, é?” ");
INSERT INTO mkn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dia pung ana bua dong manyao bilang, “Papa lia sandiri sa. Ko orang bagini banya dong baseti satu deng yang laen na. Ais Papa tanya bilang, ‘Sapa yang sonto Beta pung baju?’ ” ");
INSERT INTO mkn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma Yesus maen lia kuliling, ko mau cari tau sapa yang tadi ada sonto sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dengar Yesus tanya bagitu, ju itu parampuan su taku mau mati. Ais dia tikam lutut di Yesus pung muka ko mangaku samua bilang, “Papa! Beta yang sonto Papa pung baju.” ");
INSERT INTO mkn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ju Yesus manyao sang dia bilang, “Tagal mama parcaya batúl-batúl sang Beta, andia ko mama su bae. Sakarang mama pulang ruma deng hati tanáng suda, te mama pung susa su abis.” ");
INSERT INTO mkn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus masi baꞌomong bagitu, ju ada satu orang datang dari Yairus pung ruma, ko kasi tau bilang, “Kasian é, ana nona su mati. Jadi jang bekin cape sang Bapa Guru lai. Dia sonde usa pi lai.” ");
INSERT INTO mkn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma Yesus sonde ame pusing itu orang pung omong. Jadi Dia bilang sang Yairus, “Lu sonde usa taku, é! Parcaya sang Tuhan sa.” ");
INSERT INTO mkn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ju Yesus jalan kasi tenga dia pung ana bua laen dong. Ma Dia bawa sang Petrus, Yakobis deng dia pung adi Yohanis, ko dong jalan tarús. ");
INSERT INTO mkn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Waktu dong sampe di Yairus pung ruma, dong lia orang banya dong batasibu, deng dengar dong ada manangis makarereu. ");
INSERT INTO mkn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus maso pi dalam, ais Dia tanya sang dong bilang, “Akurang ko bosong tasibu deng manangis makarereu bagini? Ini ana sonde mati. Dia cuma tidor sa.” ");
INSERT INTO mkn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dong dengar Yesus pung omong bagitu, ju dong samua katawa olok-olok sang Dia. Ais Dia suru sang dong samua kaluar. Ju Dia pange ame itu ana pung papa deng mama, deng Dia pung ana bua tiga orang, ko dong samua maso pi dalam itu ana pung kamar. ");
INSERT INTO mkn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ju Yesus pegang itu ana pung tangan, ais Dia pake dong pung bahasa Aram ko omong sang itu ana bilang, “Talita kum!” (Dia pung arti bilang, “Nona! Bangun suda!”) ");
INSERT INTO mkn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Takuju sa, itu nona bangun ko mulai bajalan. Ais Yesus suru dia pung mama bilang, “Kasi ini ana makan suda!” Samua orang yang lia apa yang su jadi tu, dong taheran-heran. Ma Yesus larang karás sang dong bilang, “Bosong jang kasi tau sapa-sapa bilang, Beta su kasi idop kambali sang dia!” ");
INSERT INTO mkn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ais ju Yesus deng Dia pung ana bua dong samua pulang pi Dia pung kampong Nasaret. ");
INSERT INTO mkn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pas kaná deng orang Yahudi pung hari sambayang, Yesus maso pi ruma sambayang ko mangajar. Itu hari, ada banya orang yang pi sambayang. Waktu dong dengar Dia pung ajaran, dong taheran-heran, ko bilang, “Ini orang pung pintar lai! Dia ju ada pung kuasa na! Karmana ko Dia bisa bagitu? ");
INSERT INTO mkn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Padahal Dia cuma tukang kayu sa. Kotong kanál Dia pung mama Maria; deng Dia pung adi-adi dong, andia Yakobis, Yoses, Yudas deng Simon. Dia ju ada pung adi parampuan barapa orang. Kotong samua tenga satu kampong na!” Andia ko dong camburu sampe dong su sonde mau dengar sang Dia lai. ");
INSERT INTO mkn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ju Yesus kasi tau bilang, “Memang batúl! Orang lebe suka kasi hormat sang Tuhan Allah pung jubir dari tampa laen. Ma di dia pung kampong sandiri, orang sonde kasi hormat sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Ma itu orang dong pung hati karás mau mati, sampe dong sonde mau parcaya sang Yesus. Andia ko Dia heran, ais Dia sonde pake Dia pung kuasa lai di situ. Dia cuma bekin bae satu-dua orang saki sa. ");
INSERT INTO mkn_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Ais ju Yesus pi kuliling di kampong-kampong yang badeka, ko ajar orang dong Tuhan Allah pung mau. ");
INSERT INTO mkn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dia pange ame Dia pung ana bua dua blas orang ko suru dong jalan dua-dua orang pi kasi tau Tuhan Allah pung Kabar Bae. Dia ju kasi kuasa sang dong ko usir setan. ");
INSERT INTO mkn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Dia parenta sang dong bilang, “Bosong sonde usa bawa bam-banya di jalan, te nanti Tuhan yang ator. Sonde usa bawa bakál, doi, deng tas. Ma bawa tongkat deng sandal di kaki, deng baju satu potong sa. ");
INSERT INTO mkn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kalo ada orang tarima sang bosong di dong pung ruma, na, bosong musti tenga di situ sampe bosong barangkat lai. ");
INSERT INTO mkn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma kalo sampe di satu tampa, abis orang di situ dong sonde mau tarima, deng sonde mau dengar sang bosong, na, angka kaki dari situ. Ais kasi tau sang dong bilang, ‘Bosong sonde mau dengar na. Jadi biar bosong pikol tanggong-jawab sandiri!’ ” ");
INSERT INTO mkn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ais ju dong pi ko kasi tau itu Kabar Bae. Dong bilang samua orang musti barenti suda dari dong pung sala-sala, ais bale ko idop iko Tuhan pung mau-mau. ");
INSERT INTO mkn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dong ju usir kasi kaluar setan dong. Ais itu, dong taro minya di orang saki dong pung kapala, ko sambayang bekin bae sang dong. Ju dong bae memang. ");
INSERT INTO mkn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Itu waktu, orang di mana-mana su kanál sang Yesus. Carita soꞌal Dia pung kuasa tu, ju su sampe di raja Herodes pung talinga. Ada orang bilang, “Yohanis Tukang Sarani tu, su idop kambali di Yesus pung diri! Andia ko Dia bisa bekin itu tanda heran dong samua.” ");
INSERT INTO mkn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma ada orang laen yang bilang, “Sonde! Ini Elia yang su idop ulang di Dia pung diri.” Ada laen lai yang bilang, “Dia tu, Tuhan Allah pung jubir yang laen dari dolu dong.” ");
INSERT INTO mkn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma waktu raja Herodes dengar dong omong ame Yesus bagitu ju, dia manyao bilang, “Ini tantu Yohanis Tukang Sarani yang tempo hari beta suru potong ame dia pung kapala. Sakarang dia su idop kambali lai, ó!” ");
INSERT INTO mkn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Raja Herodes suru bagitu, tagal dia ada parkara bésar deng Yohanis. Dia pung carita bagini: raja Herodes su kawin ame sang dia pung adi Filipus pung maitua, nama Herodias. Padahal Filipus deng Herodias balóm bacere. Andia ko Yohanis togor ulang-ulang bilang, “Papa raja sonde bole baꞌame deng papa pung adi pung bini. Te itu su langgar kotong pung adat Yahudi na!” Biar bagitu, ma Herodes kawin deng itu parampuan ju. Ais ju dia suru orang dong pi tangkap ame sang Yohanis ko kasi maso pi bui. ");
INSERT INTO mkn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tagal Yohanis su togor ulang-ulang bagitu, andia ko itu parampuan simpan hati ko mau bunu bekin mati sang dia sa. Ma balóm sampat, te Herodes su tahan ame sang dia di bui. ");
INSERT INTO mkn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ju dia suru tantara dong ko jaga bae-bae sang Yohanis. Memang Herodes eleng sang Yohanis. Dia tau bilang, Yohanis tu, Tuhan Allah yang kirim sang dia. Deng dia tu, orang bae. Herodes memang suka dengar Yohanis pung omong. Ma satu-satu kali, dia pung hati tar enak dengar Yohanis pung omong. ");
INSERT INTO mkn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ais itu, ju satu hari, mama Herodias dapa sampat ko balas dia pung saki hati. Itu hari, dong ada bekin raja Herodes pung hari jadi. Dong undang orang-orang bésar ko dong datang makan hari jadi. Yang datang tu, orang pamarenta, tantara pung kapala dong, deng tua-tua adat Galilea dong. ");
INSERT INTO mkn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Di teng-tenga pesta, ju mama Herodias pung ana nona maso pi baronggeng. Dia pung ronggeng talalu bagus, sampe bekin sanáng Herodes deng dia pung tamu dong. Ju Herodes pange sang dia ko tanya, “Lu mau minta apa sang beta, na, kasi tau sa! Nanti beta kasi. ");
INSERT INTO mkn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Biar lu minta bagi dua beta pung karajaꞌan ju, beta kasi. Beta sumpa deng Tuhan Allah pung nama!” ");
INSERT INTO mkn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ju itu nona pi ko tanya dia pung mama bilang, “Mama! Mama kira beta minta apa yang paling bae sang papa?” Ju dia pung mama manyao bilang, “Naaa! Pi ko minta ame itu Yohanis pung kapala.” ");
INSERT INTO mkn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ais, itu nona datang sang Herodes capát-capát, ko pasán bilang, “Papa! Beta minta ko bawa kasi sang beta Yohanis pung kapala taro dalam dulang. Sakarang ju!” ");
INSERT INTO mkn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes dengar ame bagitu, ju dia pung hati ilang memang. Ma dia su sonde bisa hela kambali dia pung sumpa, te samua orang su dengar na. ");
INSERT INTO mkn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ais ju dia parenta satu komandán ko pi potong ame sang Yohanis pung kapala dari dalam bui. ");
INSERT INTO mkn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ju dong potong ame Yohanis pung kapala, ais taro dalam dulang, ko pi kasi sang itu nona. Dia tarima ame itu dulang, ju dia koko bawa pi kasi sang dia pung mama. ");
INSERT INTO mkn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Waktu Yohanis pung ana bua dong dengar bilang, dong su angka bawa Yohanis pung kapala, ju dong datang ame dia pung mayat, ko pi kubur sang dia. Bagitu sa, carita Yohanis pung mati. ");
INSERT INTO mkn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Satu waktu, ana bua yang Yesus su utus tu, dong pulang samua ko bakumpul ulang lai deng Dia. Dong kasi tau samua yang dong su bekin, deng apa yang dong su ajar sang orang dong. ");
INSERT INTO mkn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma itu waktu, talalu banya orang bajalan pi-datang ko cari sang Yesus. Sampe-sampe Dia deng Dia pung ana bua dong sonde bisa makan lai. Ju Yesus kasi tau Dia pung ana bua dong bilang, “Mari ko kotong pi cari tampa sunyi, ko kotong bisa barenti cape ame sadiki doo.” ");
INSERT INTO mkn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jadi dong samua nae pi dalam parahu ko pi cari tampa sunyi yang jao dari kampong. ");
INSERT INTO mkn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma itu orang banya dong dapa lia Yesus dong pung parahu pi iko-iko dano pung pinggir. Ais dong kaluar kampong iko jalan darat, ju dong sampe lebe dolo dari Yesus dong. ");
INSERT INTO mkn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Waktu Yesus turun dari parahu, ju Dia dapa lia orang banya su tunggu sang Dia. Ais ju Dia jato kasian sang dong, tagal dong samua sonde tau mau bekin apa, sama ke domba yang sonde ada pung gambala. Ais Dia ajar sang dong Tuhan Allah pung mau ");
INSERT INTO mkn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","dari siang sampe sore. Ju Dia pung ana bua dong kasi tau sang Dia bilang, “Papa! Lebe bae Papa suru ini orang dong samua ko dong pi béli makan di kampong-kampong badeka di sini. Te ini su sore ni, deng sonde ada makanan di sini.” ");
INSERT INTO mkn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma Yesus manyao bilang, “Sonde usa! Bosong sa yang kasi makan sang dong.” Ma dong bale tanya bilang, “Aweꞌ! Kalo botong kasi makan orang bagini banya, na, botong musti kasi kaluar doi banya mau mati! Sama ke satu tukang pung gaji satu taon! Mana bisa botong dapa doi banya bagitu!” ");
INSERT INTO mkn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ju Yesus manyao bilang, “Bosong pi cari tau dolo, sapa yang ada bawa bakál.” Ais ju dong pi cari tau, ju dong kambali kasi tau bilang, “Ada roti lima bua, deng ikan dua ekor sa.” ");
INSERT INTO mkn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ais Yesus suru itu orang samua ko dudu bakumpul di atas rumput. ");
INSERT INTO mkn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ju dong pi dudu bakumpul. Ada yang bakumpul saratus-saratus orang, deng ada yang lima-lima pulu orang. ");
INSERT INTO mkn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ais ju Yesus ame itu roti lima bua, deng itu ikan dua ekor. Ju Dia mangada pi langit ko minta tarima kasi sang Tuhan Allah. Ais itu, Dia kasi pica-pica itu roti, ju sorong kasi pi Dia pung ana bua, ko dong pi bagi-bagi kasi sang itu orang dong samua. Itu ikan dua ekor ju Dia bagi-bagi kasi. ");
INSERT INTO mkn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ais ju dong samua makan sampe kinyang. ");
INSERT INTO mkn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Makan abis ju, itu ana bua dong pi kumpul ame itu makanan yang lebe dong, ponu dua blas bakul. ");
INSERT INTO mkn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Itu orang dong kira-kira ada lima ribu orang. Itu baru itong laki-laki yang makan sa. Balóm reken tamba parampuan deng ana-ana. ");
INSERT INTO mkn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ais itu, Yesus suru Dia pung ana bua dong pi nae parahu ko pi lebe dolo di kampong Betsaida di dano pung sablá. Ma Dia masi tenga di situ, ko suru itu orang banya dong pulang. ");
INSERT INTO mkn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Waktu dong samua pulang, ju Dia nae pi gunung satu ko sambayang. ");
INSERT INTO mkn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Waktu su malam ju, Yesus turun kambali. Dia su dapa lia ana bua dong pung parahu su sampe di teng-tenga dano. Ma dong ada badayong satenga mati, tagal parahu balayar lawan angin muka na. Waktu amper siang ju, Yesus pi iko sang dong. Ma Dia jalan sa di atas aer. Waktu Dia su mau lewat itu parahu, ju dong dapa lia sang Dia. Dong takuju mau mati. Tarús dong batanya bilang, “Hee! Apa ni? Setan, ko apa?” Ma Yesus langsung omong bilang, “Woe! Bosong jang taku, ó! Ini Beta ni.” ");
INSERT INTO mkn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Waktu Yesus nae pi dalam parahu, ju itu angin tadó memang. Dia pung ana bua dong samua heran tar abis-abis. ");
INSERT INTO mkn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Dong baru lia Yesus pake Dia pung kuasa ko kasi makan lima ribu orang lebe. Ma dong balóm mangarti batúl Dia pung kuasa, tagal dong pung hati karás. ");
INSERT INTO mkn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waktu dong sampe di dano pung sablá, ju dong balabu di kota Genesaret pung pante. ");
INSERT INTO mkn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Waktu dong turun dari parahu, orang banya su dapa lia sang dong. Ju dong batarea bilang, “We! Yesus su datang ni!” ");
INSERT INTO mkn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Dong samua lari pi bakastau kuliling, ju orang dong pikol bawa datang orang-orang saki dong. Pokonya, asal dong dengar bilang, Yesus ada di satu tampa, dong rame-rame pikol bawa orang saki, ko kasi tidor sang dong di tana lapang. Dong pikir kata, “Asal itu orang saki dong sonto ame Yesus pung ujung baju sa, tantu dong bae.” Sonto bagitu, ju dong bae memang. ");
INSERT INTO mkn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ada satu rombongan orang Farisi deng barapa guru agama datang dari Yerusalem ko katumu sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Itu orang Farisi dong pegang karás dong pung adat Yahudi. Umpama, kalo orang mau makan, musti cuci tangan iko adat pung mau. Bagitu ju, kalo pulang pasar, dong musti mandi dolo. Sampe-sampe dong pung barang dapur sandiri, sama ke pareu, piring, galás, cerek, samua musti cuci iko adat pung mau, baru bole pake makan. Kalo ada orang Yahudi laen yang sonde iko itu adat, orang Farisi dong mara. Andia ko, dong mara waktu dong dapa lia Yesus pung ana bua dong makan sonde cuci tangan iko adat pung mau. Ais dong datang ko kasi sala sang Yesus bilang, “Akurang ko lu pung ana bua dong makan, ma sonde cuci tangan dolo? Itu, dong su malawan kotong pung adat dari nene-moyang!” ");
INSERT INTO mkn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Ma Yesus manyao bilang, “Bosong ni, memang orang yang omong laen bekin laen! Dari dolu baꞌi Yesaya su tulis Tuhan Allah pung pasán bilang, ‘Ini orang dong puji sang Beta, cuma deng mulu sa, ma sonde deng hati. Dong bekin bagitu, ju parcuma sa. Dong sonde pusing Beta pung mau, ma dong cuma iko manusia pung mau sa.’ Bosong ju sama deng itu. ");
INSERT INTO mkn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Bosong su kasi tenga Tuhan Allah pung parenta, ko mau iko manusia pung adat sa. Bosong memang pintar sakali bekin bagitu! ");
INSERT INTO mkn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Dolu-dolu baꞌi Musa su kasi tau Tuhan Allah pung parenta bilang, ‘Kasi hormat sang bosong pung mama deng papa.’ Deng tamba lai bilang, ‘Kalo satu orang maki dia pung mama ko papa, musti hukum kasi mati sang dia.’ ");
INSERT INTO mkn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Tuhan Allah ajar bagitu, ma bosong ajar laen lai. Bosong bilang, ‘Kalo orang janji mau kasi satu barang sang Tuhan Allah, biar dia pung mama deng papa sangsara mau mati, ma itu barang sonde bole pake ko bantu dong, te su janji nanti mau kasi sang Tuhan Allah na.’ ");
INSERT INTO mkn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Andia ko Beta su bilang tadi, bosong su buang Tuhan Allah pung mau, ko bosong ganti deng atoran baru. Ada banya atoran yang bosong su ganti bagitu.” ");
INSERT INTO mkn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ais ju Yesus pange orang laen dong di situ, ko bilang, “Pasang talinga dolo, ko bosong mangarti. ");
INSERT INTO mkn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Apa yang maso pi dalam parú, itu sonde bekin kamomos orang. Ma apa yang kaluar, itu yang bekin kamomos. ");
INSERT INTO mkn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Naa, sapa yang ada talinga, dengar bae-bae, ó!” ");
INSERT INTO mkn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ais Yesus deng Dia pung ana bua dong jalan kasi tenga itu orang dong, ko maso pi dalam satu ruma. Ju Dia pung ana bua tanya itu umpama pung arti. ");
INSERT INTO mkn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesus manyao bilang, “Bosong ju sonde mangarti, ko? Dia pung maksud bagini: apa yang orang makan, itu bae. Ma yang kaluar tu, tar bae. Apa yang kotong makan, maso di parú, abis kaluar ulang lai. (Tuhan Yesus pung maksud bilang, orang bole makan apa sa. Sonde larang.) ");
INSERT INTO mkn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma apa yang kaluar dari orang pung hati, itu yang bekin kamomos sampe Tuhan Allah noju sang dia, deng sonde mau bagabung deng dia. ");
INSERT INTO mkn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Te banya parkara jahat kaluar dari orang pung hati! Sama ke: pikir jahat, maen serong deng orang yang bukan dia pung laki ko dia pung bini, mancuri, bunu orang, ");
INSERT INTO mkn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","balalas, barsina, jahat, putar-balek, iko nafsu, iri hati, omong kasi jato orang, sombong, kurang ajar, deng kapala batu. ");
INSERT INTO mkn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Naa, samua yang jahat bagitu tu, kaluar dari orang pung hati. Itu yang bekin rusak sang dia. Tuhan Allah ju noju sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ais ju Yesus dong kasi tenga itu tampa, ko pi satu kota nama Tirus. Sampe di situ, tarús dong maso pi dalam satu ruma, tagal Yesus sonde mau ada orang tau Dia ada di situ. Ma Dia sonde bisa sambunyi. ");
INSERT INTO mkn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Di situ ada satu mama yang bukan orang Yahudi. Dia lahir di daꞌera Fenisia di propinsi Siria sana. Waktu dia dengar Yesus datang, dia pi minta Yesus ko usir kasi kaluar setan dari dia pung ana parampuan. ");
INSERT INTO mkn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Yesus buang bahasa bilang, “Ana-ana dong musti makan lebe dolo, baru buang dia pung sisa kasi anjing.” Deng maksud tasambunyi, Yesus musti bantu Dia pung orang Yahudi dolu, baru bisa bantu orang laen. ");
INSERT INTO mkn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma itu mama balas bilang, “Batúl, Papa! Ma itu anjing ada di kolong meja. Dia ju makan yang jato dari itu ana pung piring.” Deng maksud bilang, waktu ana-ana makan, anjing ju dapa makan. Biar Yesus bantu Dia pung orang, ma Dia musti lia orang laen ju. ");
INSERT INTO mkn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dengar bagitu, Yesus kasi tau bilang, “Awii! Mama su omong batúl! Jadi mama pulang suda, te itu setan su kaluar dari mama pung ana.” ");
INSERT INTO mkn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ais, itu mama pulang. Sampe di ruma, dia pung ana ada tidor sonu. Itu setan memang su kaluar. ");
INSERT INTO mkn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ais itu, ju Yesus dong kasi tenga itu kota Tirus, iko jalan pante lewat kota Sidon. Dari situ, dong jalan tarús sampe di dano Galilea. Ais dong jalan pi satu daꞌera deng sapulu kota yang dong biasa subu bilang, ‘Dekapolis’. ");
INSERT INTO mkn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Di situ ada satu orang yang bisu deng tuli. Dia pung kawan dong bawa sang dia pi Yesus. Dong minta ko Yesus taro tangan di itu orang, ko bekin bae sang dia. ");
INSERT INTO mkn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ju Yesus kasi tenga itu orang banya ko pi sandiri deng itu orang. Yesus kasi maso jari pi dalam itu orang pung talinga dua-dua. Ais ju Dia taro luda di jari, ju raba itu orang pung lida. ");
INSERT INTO mkn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesus mangada pi langit, hela napas panjang, ais parenta pake dong pung bahasa bilang, “Efata!” (Dia pung arti bilang, “Tabuka suda!”) ");
INSERT INTO mkn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dia bilang bagitu sa, ju itu orang pung talinga dapa dengar memang. Itu orang pung lida yang kaku tu, noe memang, sampe dia mulai baꞌomong ena-ena. ");
INSERT INTO mkn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ais ju dong dua kambali pi orang banya. Yesus larang sang dong bilang, “Dengar, ó! Bosong jang kasi tau orang bilang, Beta su bekin bae ini orang.” Biar Yesus larang karás, ma dong bacarita rame di mana-mana. ");
INSERT INTO mkn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Orang yang dengar itu carita, dong heran mau mati. Ju dong baꞌomong bilang, “Talalu hebat! Ini Orang bekin samua jadi bae. Orang tuli dapa dengar. Orang bisu bisa baꞌomong.” ");
INSERT INTO mkn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Satu kali, ju ada orang banya datang bakumpul ko dengar sang Yesus. Dong su iko sang Dia sampe tiga hari, andia ko dong su sonde ada makanan lai. Ju Yesus pange ame Dia pung ana bua dong, ko bilang, “Beta su rasa kasian sang ini orang banya dong. Ada yang su datang dari jao, baru dong bakumpul su tiga hari, sampe su sonde ada makanan lai ni. Lebe bae dong jang pulang deng parú kosong dolo. Jang sampe dong samaput di tenga jalan.” ");
INSERT INTO mkn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesus pung ana bua dong manyao bilang, “Papa. Ini tampa su jao dari kampong. Jadi sonde mungkin kotong bisa kasi makan orang bagini banya!” ");
INSERT INTO mkn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma Yesus tanya sang dong bilang, “Bosong pung roti, ada barapa banya?” Dong manyao bilang, “Papa. Botong ada simpan roti cuma tuju bua sa.” ");
INSERT INTO mkn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ais Yesus suru itu orang dong samua ko dudu di tana. Ju Dia ame itu roti tuju bua, ko minta tarima kasi sang Tuhan Allah. Ais Dia bekin pica-pica itu roti deng Dia pung tangan ko kasi pi Dia pung ana bua dong. Ju dong pi babagi kasi itu orang dong samua. ");
INSERT INTO mkn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dong ju dapa ikan barapa ekor. Ais Yesus minta tarima kasi lai sang Tuhan Allah buat itu ikan dong. Tarús Dia suru Dia pung ana bua dong ko pi babagi ame kasi itu orang dong lai. ");
INSERT INTO mkn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Dong samua kira-kira ada ampa ribu orang. Dong makan sampe kinyang. Makan abis, ju ana bua dong pi kumpul makanan yang tasisa dong, ponu tuju bakul. Ais itu, Yesus suru dong samua pulang. ");
INSERT INTO mkn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Waktu dong pulang, ju Yesus deng Dia pung ana bua dong nae pi dalam parahu, ko pi satu tampa, nama Dalmanuta. ");
INSERT INTO mkn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Waktu Yesus dong sampe di Dalmanuta, ju ada barapa orang dari partei agama Farisi datang katumu sang Dia. Dong basoꞌal-jawab deng Dia ko mau hiki sang Dia. Dong minta sang Dia bilang, “Bapa! Kasi tunju tanda heran ko jadi bukti bilang, Bapa memang dapa kuasa dari Tuhan Allah.” ");
INSERT INTO mkn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus hela napas panjang bilang, “Kalo Beta dengar bosong omong bagitu, Beta manyasal! Akurang ko bosong minta tanda heran? Jang bagitu! Tanda heran memang ada, ma Beta sonde bekin kasi bosong.” ");
INSERT INTO mkn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ais ju Yesus jalan kasi tenga sang dong ko pi nae kambali dalam parahu deng Dia pung ana bua dong. Ju dong barangkat pi dano pung sablá. ");
INSERT INTO mkn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Waktu Yesus dong sampe di tenga dano, baru ana bua dong inga yang dong lupa bawa bakál. Dong cuma bawa roti satu bua sa. ");
INSERT INTO mkn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Dengar dong omong roti, Yesus bilang, “Bosong musti ati-ati! Jang bosong takaná raja Herodes deng orang Farisi dong pung pangaru jahat. Dong pung pangaru sama ke bibit roti yang orang campor ko bekin reis roti.” ");
INSERT INTO mkn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dengar Dia omong bagitu, ju Dia pung ana bua dong bingung. Ju dong baꞌomong bilang, “Bapatua omong apa tu? Mangkali Dia omong bagitu, tagal botong sonde bawa roti, ko?” ");
INSERT INTO mkn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma Yesus tau dong pung pikiran. Jadi Dia omong bilang, “Akurang ko bosong cuma omong roti sa! Bosong sonde tangkap Beta pung maksud, ko? Bosong pung otak memang tumpul talalu! ");
INSERT INTO mkn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bosong su lia deng bosong pung mata biji sandiri, ma sonde tau dia pung arti! Sama ke sonde lia sa! Bosong dengar deng talinga sandiri, ma sonde mangarti apa-apa. Sama ke bosong sonde bisa dengar! Bosong su lupa ");
INSERT INTO mkn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","itu roti lima bua yang Beta bekin pica-pica ko kasi makan itu lima ribu orang dong, ko? Tempo hari bosong kumpul ame itu roti pung sisa barapa bakul?” Dong manyao bilang, “Dua blas bakul, Papa.” ");
INSERT INTO mkn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus tanya lai bilang, “Bosong masi inga tempo hari Beta bekin pica-pica itu roti tuju bua ko kasi makan itu ampa ribu orang, ko? Bosong kumpul ame sisa dong barapa bakul?” Dong manyao bilang, “Tuju, Papa!” ");
INSERT INTO mkn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ju Yesus bilang, “Memang batúl! Bosong su lia deng mata kapala sandiri, ma akurang ko bosong masi balóm mangarti Beta pung kuasa datang dari mana?” ");
INSERT INTO mkn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ais itu, Yesus dong sampe di kampong Betsaida. Di situ orang dong antar bawa satu orang buta pi sang Dia. Dong minta Yesus sonto bekin bae itu orang buta. ");
INSERT INTO mkn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ais Yesus pegang ame itu orang pung tangan ko bawa sang dia pi luar kampong. Ju Dia sumbur luda pi itu orang pung mata, ais Dia raba itu mata. Dia tanya bilang, “Karmana? Lu su bisa dapa lia, ko?” ");
INSERT INTO mkn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Itu orang angka muka ko lia kiri-kanan, ais dia manyao bilang, “Hoo! Beta lia orang bajalan. Ma tingka ke lia pohon yang bajalan!” ");
INSERT INTO mkn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ais Yesus taro lai Dia pung tangan pi itu orang pung mata. Ju itu orang coba lia ulang, tau-tau te dia pung mata su bae batúl. Sakarang dia su dapa lia deng taráng. ");
INSERT INTO mkn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ju Yesus suru itu orang pulang, ais kasi inga sang dia bilang, “Lu pulang suda, ma iko jalan laen! Jang bale lai pi Betsaida.” ");
INSERT INTO mkn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ais itu ju, Yesus dong jalan kuliling kampong-kampong di Kaisarea Filipi. Di tenga jalan Yesus tanya sang Dia pung ana bua dong bilang, “Kalo iko orang dong pung carita, dong bilang Beta ni, sapa?” ");
INSERT INTO mkn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dong manyao bilang, “Ada yang bilang ‘Yohanis Tukang Sarani’. Ada yang bilang ‘baꞌi Elia’, Tuhan pung jubir dolu tu. Ada laen bilang Papa ni, satu dari Tuhan Allah pung jubir dolu-dolu yang laen dong.” ");
INSERT INTO mkn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ju Yesus tanya lai bilang, “Ma, bosong sandiri bilang Beta ni, sapa?” Petrus manyao bilang, “Papa ni, Kristus! Yang Tuhan Allah su tunju memang dari dolu.” ");
INSERT INTO mkn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma Yesus larang sang dong bilang, “Bosong jang kasi tau sapa-sapa, é!” ");
INSERT INTO mkn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ais itu, Yesus mulai kasi tau Dia pung ana bua dong bilang, “Beta ni, Manusia Tulen. Nanti Beta dapa sangsara bam-banya, tagal tua-tua adat, kapala agama Yahudi dong pung bos-bos, deng guru agama dong samua tola buang sang Beta. Nanti dong bunu bekin mati sang Beta, ma pas deng dia pung lusa, Beta idop kambali.” ");
INSERT INTO mkn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus kasi tau tarús taráng bagitu, ju Petrus hela ame sang Dia pi pinggir ko togor bilang, “Papa jang omong bagitu! Beta sonde kasi tenga dong nae tangan sang Papa.” ");
INSERT INTO mkn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma Petrus omong bagitu, bukan iko Tuhan pung mau. Ju Yesus bale ko lia Dia pung ana bua laen dong. Ais Dia togor sang Petrus deng karás bilang, “Heh! Itu setan dong pung bos pung omong! Iskarobis dari sini! Lu cuma pikir manusia pung mau sa, bukan Tuhan pung mau!” ");
INSERT INTO mkn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ais ju Yesus pange orang laen dong ko datang bakumpul deng Dia pung ana bua dong. Ais Dia ajar sang dong bilang, “Sapa yang mau iko sang Beta, dia musti batahan iko tarús tiap hari! Dia musti lupa buang dia pung mau-mau sandiri, ko iko Tuhan pung mau sa. Biar orang mau bunu sang dia, dia musti iko tarús sa, sama ke orang pikol dia pung kayu palang ko pi mati. ");
INSERT INTO mkn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Te orang yang cuma mau idop buat dia pung diri sandiri sa, nanti dia pung idop tu, ilang bagitu sa! Ma orang yang sadia mati tagal dia iko sang Beta deng kasi tau Tuhan pung jalan idop, nanti dia dapa idop tarús deng Tuhan. ");
INSERT INTO mkn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dengar, é! Kalo lu dapa dunya pung isi samua, ma Tuhan Allah tola buang sang lu, lu ontong apa? ");
INSERT INTO mkn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Biar lu pikol bawa dunya pung isi samua ju, lu sonde bisa tukar deng lu pung jiwa! ");
INSERT INTO mkn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Inga, é! Orang di ini dunya sakarang pung jahat macam-macam. Dong sonde toe iko sang Tuhan. Jadi sapa yang malu iko sang Beta, ko malu pegang Beta pung ajaran, Beta ju nanti malu mangaku sang dia di Tuhan Allah pung muka. Te Beta, Manusia Tulen ni, nanti Beta datang kambali dari sorga. Deng Tuhan pung ana bua dari sorga dong, iko sama-sama deng Beta ju. Botong turun dari sorga deng Bapa pung kuasa yang hebat, baru orang tau Beta ni, sapa. ");
INSERT INTO mkn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bosong jang lupa Beta pung omong ni. Ada yang dari bosong samua ni, yang balóm mati, ma nanti dapa lia Tuhan Allah ada pegang parenta deng kuasa bésar.” ");
INSERT INTO mkn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Abis anam hari ju, Yesus minta sang Petrus, Yakobis, deng Yohanis, ko dong sama-sama pi nae di atas satu gunung tinggi yang sonde ada orang. Waktu dong sampe di atas, dong lia Yesus su jadi laen. ");
INSERT INTO mkn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Deng Dia pung pakean su jadi puti mangkilat. Di ini dunya sonde ada barang yang lebe puti dari Dia pung pakean tu. ");
INSERT INTO mkn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Takuju sa, ju dong dapa lia Yesus ada baꞌomong deng baꞌi Elia deng baꞌi Musa. ");
INSERT INTO mkn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Petrus dong taku mau mati. Ju Petrus su bingung sa, sampe dia omong sambarang. Ais dia kasi tau sang Yesus bilang, “Papa! Botong enak di sini, é! Jadi lebe bae botong bekin tiga lopo. Satu kasi sang Papa, satu kasi baꞌi Musa, deng satu lai kasi baꞌi Elia.” ");
INSERT INTO mkn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ais itu, ju awan turun datang ko tutu ame sang dong. Ju dong dengar suara kaluar dari itu awan bilang, “Dengar, ó! Yesus ni, Beta pung Ana sayang. Bosong dengar bae-bae sang Dia sa!” ");
INSERT INTO mkn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Waktu Petrus dong dengar itu suara, dong lia kuliling, ma takuju dong sonde dapa lia orang laen lai. Cuma Yesus sandiri sa. ");
INSERT INTO mkn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ais itu, Yesus deng Dia pung ana bua dong jalan turun dari itu gunung. Ju Yesus pasán sang dong bilang, “Apa yang bosong baru lia tadi tu, bosong jang kasi tau sapa-sapa. Beta ni, Manusia Tulen. Beta musti mati dolo. Ais nanti kalo Beta su idop kambali, baru bosong bole kasi tau orang.” ");
INSERT INTO mkn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dong pegang bae-bae Yesus pung pasán tu, ju dong sonde kasi tau orang. Ma dong tiga mulai batanya sandiri bilang, “Dia pung maksud apa bilang, Dia mau ‘idop kambali dari Dia pung mati’ tu? Karmana, é?” ");
INSERT INTO mkn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ju dong tanya sang Dia bilang, “Guru agama dong bilang, ‘Baꞌi Elia musti datang dolo, baru Kristus datang.’ Ma iko Papa, karmana?” ");
INSERT INTO mkn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus manyao bilang, “Memang batúl. Baꞌi Elia musti datang dolo ko buka jalan kasi Kristus, itu Orang yang Tuhan Allah su tunju dari dolu. Ma karmana? Bosong balóm mangarti apa yang dong su tulis di Tuhan Allah pung Tulisan Barisi soꞌal itu Manusia Tulen, ko? Te dong su tulis memang bilang, nanti kalo Dia su datang, na, orang bekin susa sampe dong mau bunu mati sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma bosong musti pasang talinga bae-bae, ó! Itu baꞌi Elia memang su datang. Ma orang bekin susa sang dia iko dong pung mau. Itu ju pas deng apa yang baꞌi-baꞌi dong su tulis memang dari dolu.” ");
INSERT INTO mkn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Waktu Yesus deng Dia pung ana bua tiga orang tu, bakatumu kambali deng ana bua laen, dong dapa lia orang banya ada bakumpul. Itu orang banya dong ada datang ko lia Yesus pung ana bua laen bakanjar deng guru agama dong. ");
INSERT INTO mkn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Waktu orang banya dong dapa lia sang Yesus, dong takuju, te dong kira Dia masi ada di atas gunung. Ais dong lari pi katumu deng Dia. ");
INSERT INTO mkn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ju Yesus tanya sang dong bilang, “Bosong ada bakanjar apa di sini?” ");
INSERT INTO mkn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ada satu orang datang bilang, “Papa, dengar dolo! Beta ada bawa beta pung ana laki-laki, ko Papa bekin bae sang dia. Dia bisu, sonde bisa baꞌomong, te dia takaná setan. ");
INSERT INTO mkn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kalo itu setan su maso, na, dia banting-banting ini ana pung badan di tana. Ais, itu ana pung mulu babusa, deng dia makan gigi. Ais dia pung badan bakaku sama ke kayu. Beta su minta Papa pung ana bua dong, ko tolong usir itu setan. Ma dong sonde bisa apa-apa.” ");
INSERT INTO mkn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dengar bagitu, ju Yesus masparak sang dong bilang, “Heh! Bosong ni, su talalu! Beta su ajar ulang-ulang sang bosong, ma bosong sonde mangarti bae-bae. Deng bosong sonde parcaya batúl-batúl sang Beta! Beta musti sabar sang bosong sampe kapan? Mari bawa itu ana datang di sini!” ");
INSERT INTO mkn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ais dong koko bawa itu ana datang sang Yesus. Ma waktu itu setan dapa lia sang Yesus, ju dia banting itu ana sampe jato taguling-guling di tana, deng dia pung mulu babusa. ");
INSERT INTO mkn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ais ju Yesus tanya itu ana pung papa bilang, “Lu pung ana jadi bagini ni, su dari kapan tempo?” Dia pung papa manyao bilang, “Su dari kici. ");
INSERT INTO mkn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Itu setan su lama mau kasi mati sang ini ana. Dia kasi jato beta pung ana ulang-ulang pi dalam api, deng kasi tanggalám pi dalam aer. Jadi Papa tolong dolo! Kalo bisa, Papa kasian sang botong ko bekin bae ini ana dolo.” ");
INSERT INTO mkn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus manyao bilang, “Akurang ko lu bilang ‘kalo bisa’? Beta memang bisa bekin samua, asal orang parcaya dolo!” ");
INSERT INTO mkn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ais itu, bapatua manyao deng mau manangis sa bilang, “Papa! Memang beta su parcaya. Ma tolong ko beta pung parcaya jadi lebe kuat lai!” ");
INSERT INTO mkn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Itu waktu, Yesus lia banya orang su mulai datang makarubu di situ. Ais dia parenta itu setan bilang, “Heh, setan jahat! Lu kaluar suda dari ini ana, ko dia dapa dengar, deng dia dapa baꞌomong. Lu jang maso ulang lai sang dia!” ");
INSERT INTO mkn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dengar Yesus omong bagitu ju, itu setan batarea karás-karás. Dia bekin itu ana jato tahela-hela, baru kaluar kasi tenga sang dia. Ju itu ana faraku sama ke su mati sa. Sampe orang dong di situ baꞌomong bilang, “Naa! Dia su mati!” ");
INSERT INTO mkn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Yesus pegang ame itu ana pung tangan ko tarek kasi bangun sang dia. Ju dia bangun memang. ");
INSERT INTO mkn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ais Yesus deng Dia pung ana bua dong kasi tenga itu tampa, ko maso pi dalam satu ruma. Di situ dong sandiri tanya sang Yesus bilang, “Papa! Akurang ko tadi botong sonde bisa usir itu setan?” ");
INSERT INTO mkn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ais Yesus kasi tau bilang, “Dengar bae-bae! Setan dong memang jahat. Jadi kalo bosong sonde sambayang minta tolong sang Tuhan, na, bosong sonde ontong usir setan macam bagitu dong.” ");
INSERT INTO mkn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ais itu, Yesus deng Dia pung ana bua dong kasi tenga itu tampa, ko maso pi propinsi Galilea. Itu waktu, Yesus sonde mau ada orang yang tau Dia ada di situ, ");
INSERT INTO mkn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","te Dia cuma mau ajar sang Dia pung ana bua sa. Dia kasi tau sang dong bilang, “Sonde lama lai, te dong mau jual sang Beta pi orang laen. Ais dong bunu bekin mati sang Beta, Manusia Tulen ni. Memang Beta mati, ma nanti dia pung lusa, Beta idop kambali.” ");
INSERT INTO mkn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesus kasi tau bagitu, ma Dia pung ana bua dong babingung. Dong sonde barani tanya lai Yesus pung maksud tu, apa. ");
INSERT INTO mkn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ais itu, ju Yesus dong jalan sampe di Kapernaum. Waktu dong maso pi dalam ruma, ju Yesus tanya sang Dia pung ana bua dong bilang, “Tadi bosong bakanjar apa di jalan tu?” ");
INSERT INTO mkn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma sonde ada yang barani manyao, te tadi di tenga jalan dong ada basambung mulu bilang, sapa yang paling bésar dari dong samua. ");
INSERT INTO mkn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ais Yesus dudu ko ajar sang dong bilang, “Sapa yang mau jadi orang bésar, dia pung idop musti batúl-batúl jadi sama ke orang kici ko layani samua orang.” ");
INSERT INTO mkn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ais Yesus koko ame satu ana kici di situ, ko Dia kambali pi dong pung teng-tenga. Ju Dia omong bilang, ");
INSERT INTO mkn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sapa yang iko Beta ko layani orang kici sama ke ini ana, dia pung arti, itu orang ju ada layani sang Beta. Deng dia ju ada layani sang Beta pung Papa yang utus sang Beta datang di ini dunya.” ");
INSERT INTO mkn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ais itu, Yesus pung ana bua Yohanis kalák bilang, “Papa! Satu kali botong lia ada satu orang pake Papa pung nama ko usir setan. Ma botong larang sang dia, te dia bukan kotong pung orang na.” ");
INSERT INTO mkn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma Yesus manyao bilang, “Heh! Bosong jang larang sang dia. Te sapa yang pake Beta pung nama ko bekin tanda heran, dia sonde akan omong bekin busuk Beta pung nama. ");
INSERT INTO mkn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kalo dia sonde malawan sang kotong, artinya dia ju kotong pung orang. ");
INSERT INTO mkn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Naa, inga bae-bae, ó! Kalo ada orang yang tau bilang, bosong iko sang Kristus, ais dia tolong sang bosong, tantu Tuhan Allah sonde lupa itu orang pung cape. Biar dia cuma kasi minum aer puti satu galás sa, ju Tuhan Allah sonde lupa sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ais Yesus kasi tau lai sang dong bilang, “Kalo ada orang yang bekin satu ana kici iko jalan idop yang sala, sampe itu ana sonde parcaya lai sang Beta, awas, ó! Lebe bae kasi itu orang, kalo ame batu bésar satu, ika di dia pung batang leher, ko kasi tanggalám di tenga laut. ");
INSERT INTO mkn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kalo lu bekin sala pake lu pung tangan, potong buang itu tangan sa! Te lebe bae lu maso sorga biar bawa tangan sablá sa, ko biar dong jang buang sang lu pi api naraka deng lu pung tangan dua-dua. ");
INSERT INTO mkn_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naraka tu, memang tampa sangsara. Dia pung api sonde tau mati-mati. Deng ulat-ulat di situ dong ju sonde barenti bekin busuk. ");
INSERT INTO mkn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kalo lu bekin sala pake lu pung kaki, potong buang itu kaki sa. Te lebe bae lu maso sorga bawa lu pung kaki sablá sa, ko biar dong jang buang sang lu pi api naraka deng lu pung kaki dua-dua. ");
INSERT INTO mkn_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Naraka tu, memang tampa sangsara. Dia pung api sonde tau mati-mati. Deng ulat-ulat di situ dong ju sonde barenti bekin busuk. ");
INSERT INTO mkn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kalo lu bekin sala pake lu pung mata, doꞌi buang lu pung mata sa! Te lebe bae lu maso pi sorga deng mata sablá sa, ko biar dong jang buang sang lu pi api naraka deng lu pung mata dua-dua. ");
INSERT INTO mkn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Naraka tu, memang tampa sangsara. Dia pung api sonde tau mati-mati. Deng ulat-ulat di situ dong ju sonde barenti bekin busuk.’ ");
INSERT INTO mkn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Beta pung ajaran ni, memang barát. Jadi sapa yang mau iko sang Beta, dia musti batahan iko tarús, sama ke daging yang orang taro garam ko seꞌi, ko biar itu daging batahan lama. ");
INSERT INTO mkn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Garam tu, bae. Kotong pake ko bekin enak makanan. Ma kalo itu garam sonde asin lai, dia pung guna apa? Kotong buang sa. Bosong ju musti jadi sama ke garam, ko idop basayang deng samua orang. Naa! Bosong barenti bakanjar bilang, sapa bésar, sapa kici!” ");
INSERT INTO mkn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ais ju Yesus dong pi propinsi Yudea deng tampa-tampa laen di kali Yarden pung sablá matahari nae. Di mana-mana orang banya datang makarubu sang Dia. Ais Yesus ajar sang dong sama ke biasa. ");
INSERT INTO mkn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ada barapa orang Farisi yang datang ko mau hiki kasi jato sang Dia. Dong tanya bilang, “Iko kotong pung atoran agama, kalo laki-laki su kawin, dia bole bacere, ko sonde?” ");
INSERT INTO mkn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus manyao bilang, “Inga dolo! Atoran laki-bini yang baꞌi Musa kasi sang kotong bilang, karmana?” ");
INSERT INTO mkn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dong manyao bilang, “Baꞌi Musa pung atoran bilang, orang bole bacere, asal kasi surat cere sang dia pung bini dolo.” ");
INSERT INTO mkn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus balas bilang, “Heh! Dengar, é! Tagal bosong pung kapala batu, andia ko baꞌi Musa tulis bagitu! ");
INSERT INTO mkn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jang bosong lupa itu carita mula-mula waktu Tuhan bekin langit deng bumi! Ada tatulis bilang, ‘Tuhan Allah bekin manusia, laki-laki deng parampuan. ");
INSERT INTO mkn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Andia ko laki-laki kasi tenga dia pung mama deng papa, pi idop satu hati deng dia pung bini, ");
INSERT INTO mkn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","te dong dua su jadi satu.’ ");
INSERT INTO mkn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kalo Tuhan Allah sandiri su bekin dong dua jadi satu, manusia jang kasi cere lai!” ");
INSERT INTO mkn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ais itu, Yesus deng Dia pung ana bua dong sandiri maso pi dalam satu ruma. Di situ dong tanya Yesus pung ajaran tadi. ");
INSERT INTO mkn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus manyao bilang, “Sapa yang cere buang dia pung bini, ais kawin lai, itu su barsina! ");
INSERT INTO mkn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Parampuan ju bagitu! Kalo dia su cere buang dia pung laki, ais kawin lai, itu ju barsina!” ");
INSERT INTO mkn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Satu waktu, ada orang bawa dong pung ana-ana pi sang Yesus, ko minta Dia taro tangan kasi berkat sang dong. Ma Yesus pung ana bua togor itu orang dong. ");
INSERT INTO mkn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus dapa lia bagitu, ju Dia mara Dia pung ana bua dong bilang, “Kasi tenga itu ana dong datang di Beta! Sonde usa larang! Te orang yang sama ke dong ni, yang Tuhan Allah pung orang. ");
INSERT INTO mkn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bosong inga bae-bae! Sapa yang mau datang mangada sang Tuhan Allah, dong musti rindu sang Dia, sama ke ana-ana rindu dong pung mama deng papa. Kalo sonde bagitu, dong sonde pantas jadi Tuhan Allah pung orang.” ");
INSERT INTO mkn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ais itu, Yesus paló ame itu ana dong, deng taro tangan di dong satu-satu, ko kasi berkat. ");
INSERT INTO mkn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Waktu Yesus dong mau barangkat, ju ada satu orang kaya lari-lari datang ko mau katumu sang Dia. Dia tondo di Yesus pung muka, ais dia tanya bilang, “Bapa Guru yang terhormat! Beta mau tanya sadiki. Bagini, Bapa. Beta musti bekin karmana, ko biar beta tau parsís beta bisa maso sorga ko idop tarús sama-sama deng Tuhan Allah?” ");
INSERT INTO mkn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus manyao bilang, “Akurang ko lu bilang sang Beta, ‘terhormat’? Sonde ada satu orang yang terhormat, kecuali Tuhan Allah sa. ");
INSERT INTO mkn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lu su tau Tuhan Allah pung parenta dari dolu dong bilang, ‘Jang bunu orang; Jang barsina; Jang mancuri; Jang jadi saksi putar-balek; Jang tipu orang ko ame dong pung barang; Deng kasi hormat sang lu pung mama deng papa.’ ” ");
INSERT INTO mkn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Itu orang manyao bilang, “Batúl, Bapa Guru! Mulai dari muda, beta su iko itu parenta samua.” ");
INSERT INTO mkn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus kasian itu orang. Ju Dia bilang, “Batúl! Ma masi ada lai satu hal. Sakarang lu pulang ko jual bekin abis lu pung harta dong samua. Dia pung doi, lu pi bagi-bagi kasi orang susa dong. Ais itu, lu datang ko iko sang Beta suda. Nanti Tuhan Allah balas kasi sang lu deng harta laen di sorga.” ");
INSERT INTO mkn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Itu orang dengar ame Yesus pung omong bagitu, ju dia pung hati ancor. Ais dia pulang deng hati susa mau mati, tagal dia talalu kaya na. ");
INSERT INTO mkn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ju Yesus lia pi-datang, deng omong sang Dia pung ana bua dong bilang, “Dengar, é! Orang kaya memang paling susa maso sorga!” ");
INSERT INTO mkn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Dengar Dia omong bagitu, ju ana bua dong bingung. Ma Yesus tamba lai bilang, “Dengar bae-bae! Mau jadi Tuhan Allah pung orang tu, talalu susa! Jang pikir itu gampang sa. ");
INSERT INTO mkn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ko orang kaya maso sorga jadi Tuhan Allah pung orang, itu sama susa ke binatang onta bésar satu, maso pi dia pung kandang lewat jarom pung lobang.” ");
INSERT INTO mkn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus pung omong tu, bekin dong samua tamba bingung lai. Ju dong batanya bilang, “Kalo memang batúl bagitu, sapa yang bisa dapa salamat, é?” ");
INSERT INTO mkn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus lia sang dong satu-satu, ju Dia bilang, “Buat manusia, memang sonde mungkin. Ma jang lupa: buat Tuhan Allah, samua bisa jadi!” ");
INSERT INTO mkn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ais ju Petrus angka omong bilang, “Papa. Botong su kasi tenga botong pung samua-samua, ko iko sang Papa. Ma botong dapa apa?” ");
INSERT INTO mkn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesus bilang, “Beta mau kasi tau sang bosong bagini: orang yang iko sang Beta, deng jalan kasi tenga dia pung mama-papa, dia pung adi-kaka, dia pung ana-ana dong, dia pung kabón, dia pung karjá, deng dia pung isi ruma samua, ko pi kasi tau orang di mana-mana Tuhan Allah pung Kabar Bae, nanti dia tarima bale sampe saratus kali lipat. Samua hal yang dia su kasi tenga tu, nanti dia tarima kambali balipa-ganda. Deng dia ju nanti kaná siksa tagal dia iko sang Beta. Ma nanti kalo ini dunya kiamat, dia akan idop tarús sama-sama deng Tuhan Allah. Itu dia pung balasan! ");
INSERT INTO mkn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Inga, é! Orang yang bekin-bekin diri bésar, iko Tuhan Allah pung pikir, nanti dia jadi orang yang paling kici. Ma orang yang anggap diri kici, iko Tuhan Allah pung pikir, dia yang nanti jadi orang bésar.” ");
INSERT INTO mkn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Itu waktu, Yesus dong jalan pi Yerusalem. Yesus jalan paling muka. Dia pung ana bua dua blas orang deng orang laen dong iko sang Dia. Dong ada inga apa yang Dia omong dolu bilang, orang mau bunu sang Dia di Yerusalem. Tagal itu, ju dong jadi bingung, deng taku. Dengar bagitu, ais Yesus pange ame Dia pung ana bua sandiri, ko kasi tau lai apa yang orang mau bekin sang Dia di Yerusalem. ");
INSERT INTO mkn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Dia omong bilang, “Bosong dengar, é! Kotong sakarang mau pi Yerusalem. Beta ni, Manusia Tulen. Ma di sana dong jual sang Beta, kasi pi di kapala agama Yahudi dong pung bos-bos, deng guru agama dong. Ais dong kasi hukum mati sang Beta. Ju dong lapás buang sang Beta pi orang laen yang sonde kanál sang Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ais dong omong bekin malu sang Beta. Dong buang luda sang Beta. Dong firuk kasi ancor-ancor Beta pung badan. Ais baru dong bunu bekin mati sang Beta. Memang Beta mati batúl. Ma dia pung lusa, Beta idop kambali.” ");
INSERT INTO mkn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ais ju Yakobis deng Yohanis, andia Sabadeus pung ana dong, datang sang Yesus. Dong minta sang Dia bilang, “Papa Guru! Botong ada parlú.” ");
INSERT INTO mkn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus tanya sang dong bilang, “Bosong parlú apa?” ");
INSERT INTO mkn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Dong manyao bilang, “Bagini, Papa! Nanti kalo Papa su dudu pegang parenta deng hebat, na, botong minta ko Papa kasi dudu sang botong, satu di Papa pung sablá kanan, satu di sablá kiri, ko botong ju pegang parenta.” ");
INSERT INTO mkn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus manyao bilang, “Bosong dua ni sonde mangarti apa yang bosong minta. Beta ni, nanti dapa sangsara banya. Jadi karmana? Bosong kira bosong ju mampu pikol itu sangsara sama-sama deng Beta sampe mati, ko?” ");
INSERT INTO mkn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dong manyao bilang, “Botong bisa, Papa!” Yesus balas lai sang dong bilang, “Memang, bosong ju nanti pikol itu sangsara sama ke Beta. ");
INSERT INTO mkn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma sapa yang nanti dudu di Beta pung kanan deng kiri, itu bukan Beta yang putus. Itu Tuhan Allah pung hak putus. Dia su putus memang, sapa-sapa yang dudu di itu tampa.” ");
INSERT INTO mkn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Waktu ana bua yang laen dong dengar Yakobis deng Yohanis pung minta bagitu, ju dong mara. ");
INSERT INTO mkn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ais Yesus pange ame sang dong samua, ju Dia bilang, “Bagini! Bosong su tau, to? Orang bésar yang pegang parenta biasa tendes dong pung rakyat, sampe dong sonde bisa bagarák. Deng kapala-kapala dari bangsa yang sonde kanál sang Tuhan Allah, dong kasi parenta lebe-lebe, sampe dong pung rakyat sonde bisa angka kapala. ");
INSERT INTO mkn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma bosong sonde bole bekin bagitu! Naa, sapa dari bosong yang mau jadi orang bésar, dia musti jadi sama ke tukang suru-suru ko layani orang laen. ");
INSERT INTO mkn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Deng orang yang mau jadi kapala, dia musti bekin diri sama ke jongos. ");
INSERT INTO mkn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Te Beta, Manusia Tulen ni, bukan datang ko orang layani sang Beta. Ma Beta datang ko layani banya orang. Beta datang kasi Beta pung idop anteru-anteru ko tabús ame banya orang dari dong pung sala-sala.” ");
INSERT INTO mkn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus deng Dia pung ana bua, deng orang bam-banya sampe di kota Yeriko. Waktu dong mau jalan tarús, te ada satu orang buta yang dudu minta-minta di pinggir jalan. Dia pung nama Bartimeos, papa Timeos pung ana. ");
INSERT INTO mkn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Waktu dia dengar bilang, yang lewat tu, Yesus dari Nasaret, ju dia batarea karás-karás bilang, “Yesus! Daud pung turunan, é! Botong su tunggu-tunggu lama sang Papa! Kasian sang beta dolo!” ");
INSERT INTO mkn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dengar dia batarea bagitu, ju orang dong togor sang dia bilang, “Heh! Diam!” Ma dia batarea lebe karás lai bilang, “Yesus! Daud pung turunan, é! Kasian sang beta doo!” ");
INSERT INTO mkn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ais Yesus barenti. Ju Dia bilang, “Bosong bawa sang dia datang di sini!” Ju dong pi sang dia bilang, “Lu diam suda! Papa Guru ada pange sang lu. Mari suda!” ");
INSERT INTO mkn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dengar bagitu, Bartimeos lempar buang dia pung salimut, ju dia badiri capát-capát ko pi katumu sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus tanya sang dia bilang, “Lu mau apa?” Itu orang buta manyao bilang, “Papa, é! Beta minta ko beta bisa dapa lia.” ");
INSERT INTO mkn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus bilang lai sang dia, “Tagal lu parcaya bilang, Beta bisa bekin bae sang lu, sakarang ju lu su bae! Pi suda!” Ju Bartimeos pung mata langsung bae memang. Ais itu, dia pi iko antar sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Waktu dong su deka deng kota Yerusalem, dong sampe di dua kampong, Betfage deng Betania, di gunung Saitun pung pinggir. Dari situ Yesus dong barenti tahan. Ais Dia kirim Dia pung ana bua dua orang ko pi lebe dolo. ");
INSERT INTO mkn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Dia pasán bilang, “Bosong dua pi lebe dolo di itu kampong sana. Kalo bosong maso, nanti bosong dapa lia binatang keledai pung ana satu, ada taꞌika di situ. Orang balóm parná nae coba sang dia. Bosong pi buka dia pung tali ko hela bawa sang dia datang sini. ");
INSERT INTO mkn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma kalo ada orang tanya sang bosong bilang, ‘Akurang ko bosong lapás bawa itu keledai?’ Naa, bosong manyao bilang, ‘Botong pung Bos mau pake sang dia. Kalo su pake abis, nanti Dia kirim pulang memang.’ ” ");
INSERT INTO mkn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ais, itu dua orang dong pi, ju dong dapa lia itu keledai pung ana ada taꞌika di muka satu ruma di pinggir jalan. Ju dong lapás ko bawa sang dia. ");
INSERT INTO mkn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ma orang yang ada badiri di situ dong tanya bilang, “Hoi! Akurang ko bosong lapás ame orang pung keledai?” ");
INSERT INTO mkn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ais dong manyao bilang, “Botong pung Bos mau pake sang dia. Kalo su pake abis, nanti botong bawa pulang memang.” Ju itu orang dong kasi tenga sang dong ko hela bawa itu keledai. ");
INSERT INTO mkn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Dong hela bawa pi Yesus. Ais dong taro dong pung salimut di atas itu keledai, ju Yesus nae. ");
INSERT INTO mkn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Waktu dong mau maso pi dalam kota, ju ada banya orang yang ame dong pung salimut, deng dong pung salendang, ko taro di jalan. Ada ju yang pi potong ame daon-daon palam di pinggir jalan ko dong buka-buka di tenga jalan. Deng bagitu, dong bekin tanda bilang, dong sambut sang Tuhan Yesus deng hormat. Sama ke dong biasa tarima orang-orang bésar. ");
INSERT INTO mkn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ju ada orang saparu pi bajalan lebe dolo di muka Yesus, deng ada yang iko dari balakang. Dong mulai baꞌeki bilang, “Hosana! Kotong puji-puji sang Tuhan Allah! Tuhan kasi berkat sang orang yang datang pake Tuhan pung nama, tagal Tuhan su utus sang Dia! ");
INSERT INTO mkn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Kotong puji-puji sang Tuhan Allah! Tagal Tuhan mau kasi bangun kambali raja Daud pung parenta! Hosana! Kotong puji-puji sang Tuhan Allah! Tagal Tuhan su dudu parenta di langit yang paling tinggi!” ");
INSERT INTO mkn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sampe dalam kota, ais Yesus dong pi maso di Tuhan Allah pung Ruma Sambayang Pusat pung kintal. Ju Yesus lia bae-bae kuliling itu kompleks. Ma tagal su sonde ada waktu lai, ju dong pulang kambali pi kampong Betania. ");
INSERT INTO mkn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Dia pung beso papagi, dong jalan kaluar dari Betania ko maso kambali di kota Yerusalem. Ma di tenga jalan, Yesus su rasa lapar. ");
INSERT INTO mkn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dia dapa lia satu pohon di pinggir jalan. Orang biasa makan dia pung bua. Jadi Yesus pi deka-deka itu pohon ko mau lia coba ada bua, ko sonde. Ma waktu Dia sampe di itu pohon, Dia sonde dapa lia apa-apa. Ko memang bukan dia pung musim babua na. Dia baru mulai badaon sa. ");
INSERT INTO mkn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ju Yesus omong kasi itu pohon bilang, “Tagal lu sonde kasi lu pung bua sang Beta, jadi mulai dari sakarang, lu sonde bisa kasi lu pung bua sang orang laen lai!” Dia pung ana bua dong dengar Dia pung omong karás bagitu. ");
INSERT INTO mkn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ais dong jalan tarús, sampe di Yerusalem, ju Yesus pi maso lai di Tuhan Allah pung Ruma Sambayang Pusat. Di itu Ruma Sambayang pung kintal, orang su bekin jadi pasar ko dong bajual burung pompa yang orang pake buat korban sambayang. Lia bagitu, ju Yesus pi usir kasi kaluar sang dong. Dia banting kasi talempar meja-meja yang dong pake tukar doi, deng banting kasi tabale bangku-bangku yang dong pake bajual itu burung dong. ");
INSERT INTO mkn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dia ju larang samua orang ko sonde bole bawa ame dong pung barang ko jalan potong lewat itu kintal lai. ");
INSERT INTO mkn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ju Dia ajar sang dong bilang, “Bosong su tau memang apa yang Tuhan pung jubir su tulis bilang, ‘Beta kasi bangun Beta pung Ruma ni, ko orang dari samua suku-bangsa datang sambayang di sini.’ Ma bosong su bekin ini Ruma jadi parampok dong pung tampa bakumpul!” ");
INSERT INTO mkn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Waktu kapala agama Yahudi dong pung bos-bos deng guru agama dong dengar Yesus su bekin bagitu, ju dong jengkel sang Dia. Ais dong mulai cari jalan ko mau bunu bekin mati sang Dia. Ma dong ju eleng, tagal banya orang talalu suka Dia pung ajaran. ");
INSERT INTO mkn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Waktu matahari su mulai tanggalám, ju Yesus dong kaluar dari kota Yerusalem, ko dong kambali pi tidor di kampong Betania. ");
INSERT INTO mkn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Dia pung beso papagi, dong kambali lai pi Yerusalem. Di tenga jalan, dong lewat itu pohon yang kamaren Yesus omong kasi dia. Dia pung ana bua dong taheran-heran, tagal itu pohon su mati karíng sampe dia pung akar-akar. Ju Petrus inga Yesus pung omong yang kamaren tu. Ais dia kasi tau bilang, “Papa! Lia coba! Itu pohon yang kamaren Papa kasi kutuk tu, su mati!” ");
INSERT INTO mkn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ju Yesus manyao bilang, “Memang batúl! Asal bosong ju parcaya sang Tuhan Allah bagitu. ");
INSERT INTO mkn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kalo bosong parcaya batúl-batúl, bosong bisa suru gunung satu ko taꞌangka pi laut. Ju Tuhan Allah kasi pinda itu gunung, asal bosong jang parcaya satenga-satenga! Bosong musti parcaya batúl-batúl sang Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Naa! Jang lupa, ó! Asal bosong parcaya batúl-batúl bilang, Tuhan Allah mampu kasi apa yang bosong minta, pasti Dia bekin kasi bosong! ");
INSERT INTO mkn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ma kalo ada yang sambayang, padahal dia pung hati ada batar-enak deng orang laen, dia musti babae deng itu orang dolo. Bagitu, baru bosong pung Papa di sorga mau hapus buang bosong pung sala-sala. ");
INSERT INTO mkn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kalo ada dari bosong yang simpan hati, deng sonde mau kasi ampon orang, tantu bosong pung Papa di sorga ju sonde mau lupa bosong pung sala-sala dong.” ");
INSERT INTO mkn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ais ju dong jalan tarús. Sampe di Yerusalem, dong maso kambali lai pi Tuhan Allah pung Ruma Sambayang Pusat. Waktu dong maso di kintal, kapala agama Yahudi pung bos-bos, guru agama dong, deng tua-tua adat Yahudi datang, ");
INSERT INTO mkn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ko basoꞌal deng Yesus bilang, “Sapa suru lu datang bekin kaco di sini kamaren? Sapa yang kasi lu hak!” ");
INSERT INTO mkn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma Yesus tau dong ada cari jalan ko mau kasi jato sang Dia. Ais Dia balas bilang, “Beta ju mau tanya sang bosong. Bosong manyao sang Beta dolo, baru Beta manyao sang bosong. ");
INSERT INTO mkn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Beta mau tanya bagini: bosong samua kanál sang Yohanis, Tukang Sarani tu, to? Naa, sapa yang suru sang dia ko pi sarani orang? Tuhan Allah ko, manusia?” ");
INSERT INTO mkn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ais dong bapikir pi-datang, deng barunding bilang, “Aweꞌ! Botong su kaná! Kalo botong manyao bilang, ‘Tuhan Allah yang suru’, nanti dia balas bilang, ‘Kalo bagitu, akurang ko bosong sonde parcaya sang Yohanis!’ ");
INSERT INTO mkn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma botong ju sonde bisa bilang, ‘Manusia yang suru.’ Te nanti orang dong samua mangamok. Tagal dong parcaya bilang, Yohanis tu, Tuhan Allah pung jubir.” ");
INSERT INTO mkn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ais dong manyao sa bilang, “Botong sonde tau!” Ju Yesus bale manyao bilang, “Naa! Kalo bagitu, Beta ju sonde mau kasi tau bilang, sapa yang suru sang Beta.” ");
INSERT INTO mkn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ais itu, Yesus omong lai deng itu kapala agama Yahudi pung bos-bos, guru agama dong, deng tua-tua adat Yahudi dong. Dia pake umpama bilang, “Ada satu orang pi buka kabón ko mau tanam pohon anggor di dia pung tana sapoꞌong. Ais dia bekin pagar kuliling. Deng dia bekin bak ko mau tada bua anggor pung aer. Ju dia kasi badiri satu tampa jaga yang tinggi. Ais dia kasi sewa itu kabón pi orang laen, ko dong karjá bagi hasil deng dia. Tarús dia barangkat pi luar negrí. ");
INSERT INTO mkn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sampe musim ketu bua anggor, ju itu tuan tana suru dia pung orang karjá satu pi di itu tukang garap dong, ko minta dia pung bagian. ");
INSERT INTO mkn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma waktu dia pung sampe, itu tukang garap dong tangkap ame sang dia, ju dong papoko sang dia. Ais dong suru sang dia ko pulang deng tangan kosong. ");
INSERT INTO mkn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ais, itu tuan tana kirim dia pung orang karjá satu lai. Ma itu tukang garap dong papoko sang dia pung kapala sampe luka-luka. Ais dong bekin malu, deng dong iskarobis sang dia. ");
INSERT INTO mkn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ais, itu tuan tana kirim ulang dia pung orang karjá laen lai. Ma dong bunu sang dia. Biar dong bekin karmana ju, ma itu tuan tana maen kirim tarús dia pung orang karjá. Ma itu tukang garap dong papoko saparu, deng bunu saparu. ");
INSERT INTO mkn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sakarang cuma tenga lai satu orang sa. Andia tuan tana pung ana laki-laki satu biji yang dia paling sayang. Tagal sonde ada jalan laen lai, jadi dia kirim itu ana sa. Dia pikir bilang, ‘Kalo beta kirim beta pung ana sandiri, pasti dong tarima bae-bae, deng dong dengar sang dia.’ ");
INSERT INTO mkn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Jadi dia kirim dia pung ana pi sana. Ma waktu tukang garap dong dapa lia itu ana datang, ju dong baꞌomong bilang, ‘We! Bosong lia dolo! Bapatua su kirim datang dia pung ana sandiri! Kalo bapatua mati, dia ni yang nanti tarima itu pusaka samua. Mari kotong bunu itu ana, ko biar kotong yang soa dia pung pusaka ni!’ ");
INSERT INTO mkn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ais dong rame-rame tangkap, ju dong bunu sang dia. Tarús dong lempar buang dia pung mayat pi balakang kabón. Itu umpama sampe di situ sa.” ");
INSERT INTO mkn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ais ju Yesus tanya sang orang bésar dong bilang, “Iko bosong pung pikiran, kira-kira itu tuan tana mau bekin karmana sang itu tukang garap dong? Iko Beta, su tantu dia datang ko bunu bekin abis itu tukang garap dong samua. Ais itu, dia kasi sewa itu kabón anggor pi orang laen. ");
INSERT INTO mkn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kotong samua su dapa baca dari Tuhan Allah pung Tulisan Barisi bilang, ‘Ada satu batu yang tukang dong su angka buang. Ma sakarang itu batu su jadi batu alas. ");
INSERT INTO mkn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tuhan Allah sandiri yang pili ame, ju kasi dudu itu batu. Andia ko kotong lia dia pung bagus lai!’ ” ");
INSERT INTO mkn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Itu orang bésar dong langsung mangarti bilang, Yesus ada ser sang dong pake itu umpama. Dong parsís ke tukang garap kabón anggor tadi tu. Ais ju dong mulai ator siasat ko mau tangkap sang Dia. Ma dong ada eleng sang orang banya yang suka Yesus pung ajaran. Jadi dong pi jalan kasi tenga sang Dia sa. ");
INSERT INTO mkn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ais itu, orang Yahudi pung orang bésar dong suru barapa orang Farisi, deng orang dari Herodes pung partei pi basoꞌal deng Yesus, ko mau hiki sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ais dong datang, ju basoꞌal deng Dia bilang, “Bapa Guru! Botong samua tau kalo Bapa pung hati lurus, deng sonde tau putar-balek. Bapa lia orang pung hati sa. Bapa ju kasi tau Tuhan Allah pung mau deng tarús-taráng, tagal Bapa sonde pandang muka. Naa! Sakarang botong mau tanya satu hal. Iko kotong pung atoran agama Yahudi, kira-kira kotong ni musti bayar bea kasi sang pamarenta Roma pung raja bésar, ko sonde?” ");
INSERT INTO mkn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma Yesus su tau dong mau pancing sang Dia, ko Dia omong malawan pamarenta Roma. Ju Yesus manyao deng karás bilang, “Akurang ko bosong mau hiki sang Beta deng itu soꞌal! Coba kasi lia sang Beta doi perak satu dolo!” ");
INSERT INTO mkn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ais dong sorong kasi sang Dia doi perak satu. Ju Yesus ame ko pareksa itu doi. Ais Dia tanya sang dong bilang, “Ini gambar ni, sapa pung muka? Deng ini sapa pung nama?” Ais dong manyao bilang, “Itu pamarenta Roma pung raja bésar!” ");
INSERT INTO mkn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ais Yesus bilang, “Naa! Kalo bagitu, bosong pi kasi sang pamarenta apa yang pamarenta pung hak. Deng kasi sang Tuhan Allah apa yang Tuhan Allah pung hak.” Dengar Dia manyao bagitu, ju dong samua taheran-heran, ko Dia bilang batúl na. Andia ko dong sonde bisa hiki ame sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ada satu partei agama laen, yang orang subu bilang, partei Saduki. Dong ajar bilang, orang mati sonde bisa idop kambali. Satu kali, ada barapa orang Saduki ju datang mau hiki sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Dong omong deng Yesus bilang, “Bapa Guru! Baꞌi Musa ada tulis kasi sang kotong, ini adat bilang: kalo ada satu laki-laki mati kasi tenga dia pung bini, ma sonde ada ana, na, itu laki-laki pung adi musti kawin ame itu janda, ko biar kasi turunan sang dia pung kaka yang su mati tu. ");
INSERT INTO mkn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Memang Musa ajar bagitu. Ma botong ada mau tanya bagini: ada tuju laki-laki basodara. Yang partama kawin lebe dolo. Ais dia mati, deng sonde ada ana. ");
INSERT INTO mkn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ju dia pung adi yang iko sang dia, kawin bale itu janda. Sonde lama dia ju mati, deng sonde ada ana. Bagitu ju deng adi yang nomer tiga. Dia kawin deng itu janda, ma dia mati, ju sonde ada ana. ");
INSERT INTO mkn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bagitu tarús-tarús sampe adi bungsu ju mati. Ais ju itu janda mati. ");
INSERT INTO mkn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naa! Sakarang botong mau tanya bagini: itu parampuan su parná kawin deng tuju laki-laki! Ma kalo dunya kiamat ko Tuhan kasi idop kambali orang mati dong, nanti itu parampuan jadi sapa pung bini dari itu tuju orang?” ");
INSERT INTO mkn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ais Yesus manyao bilang, “Kalo bosong batanya bagitu, dia pung arti, bosong sonde mangarti batúl Tuhan Allah pung Tulisan Barisi pung isi. Deng bosong ju sonde mangarti Tuhan Allah pung kuasa. Jadi bosong ni su sala batúl! ");
INSERT INTO mkn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Dengar, é! Bagini: di sorga, sonde ada yang kawin. Samua orang mati yang Tuhan kasi idop kambali, sonde ada yang kawin lai. Bagitu ju Tuhan Allah pung ana bua di sorga sonde kawin. ");
INSERT INTO mkn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ais, Beta ju kasi tau soꞌal orang mati dong idop kambali, ko sonde. Baꞌi Musa tulis soꞌal pohon kici yang tabakar ma sonde angus tu. Bosong inga itu carita, ko sonde? Waktu api manyala di itu pohon, Tuhan Allah kasi tau sang Musa bilang, ‘Beta ni, lu pung baꞌi-baꞌi dong pung Tuhan Allah. Andia baꞌi Abraham, baꞌi Isak, deng baꞌi Yakob. Dong samua sémba tarús sang Beta sampe sakarang.’ ");
INSERT INTO mkn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Naa! Kotong tau bilang, itu baꞌi-baꞌi dong su lama mati. Ma tagal Tuhan Allah su bilang Dia masi jadi dong pung Tuhan, andia ko kotong tau bilang, dong su idop kambali. Jadi biar orang su mati, ju dong idop kambali. Memang orang idop yang sémba sang Tuhan Allah, bukan orang mati, to? Jadi kalo bosong pegang tarús itu ajaran bilang, orang mati sonde idop kambali, bosong memang su talalu sala tu!” ");
INSERT INTO mkn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Itu waktu, ada satu guru agama yang iko dengar Yesus dudu baꞌomong deng orang dari partei Saduki dong. Itu guru agama pikir bilang, Yesus su manyao dong pung soꞌal tu deng bae. Ais dia tanya sang Yesus bilang, “Papa! Beta mau tanya bagini: kotong pung adat pung atoran, deng agama pung parenta dong, talalu banya. Dari samua parenta yang datang dari baꞌi Musa, yang mana yang paling pantíng?” ");
INSERT INTO mkn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus manyao bilang, “Parenta yang paling pantíng dalam Tuhan pung Tulisan Barisi tu, bilang bagini: ‘Samua orang di Israꞌel! Bosong dengar bae-bae! Tuhan Allah tu, memang kotong pung Tuhan, deng yang hak parenta sang kotong! Sonde ada yang laen lai, cuma Dia sandiri sa! ");
INSERT INTO mkn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jadi bosong musti sayang sang Dia lebe dari samua. Tagal itu, bosong musti salalu rindu sang Dia, mangarti sang Dia, deng karjá karás ko iko Dia pung mau.’ ");
INSERT INTO mkn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Deng parenta yang kadua bilang bagini: ‘Lu musti sayang orang laen dong, sama ke lu sayang lu pung diri sandiri.’ Ini dua parenta yang paling pantíng. Sonde ada parenta laen lai yang lebe pantíng dari ini dua parenta.” ");
INSERT INTO mkn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ais, itu guru agama omong lai sang Yesus bilang, “Memang! Yang Papa bilang tu, batúl. Tuhan Allah yang hak parenta sang kotong, deng sonde ada Tuhan laen lai. ");
INSERT INTO mkn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kotong musti sayang sang Dia lebe dari samua, sampe kotong salalu rindu sang Dia, mangarti sang Dia, deng karjá karás ko iko Dia pung mau. Deng kotong ju musti sayang orang laen, sama ke kotong sayang kotong pung diri badan. Itu, Tuhan lebe sanáng, daripada kotong cuma iko atoran agama sa. Itu lebe bae daripada kalo kotong cuma bakar binatang korban, ko, kasi barang laen sang Dia.” ");
INSERT INTO mkn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dengar dia manyao bagitu, ju Yesus pikir bilang, itu guru agama su mangarti deng bae. Ais Yesus bilang, “Lu su amper jadi Tuhan Allah pung orang.” Ais itu, sonde ada orang laen lai yang barani basoꞌal deng Yesus, ko sonde ada orang yang ontong sang Dia na. ");
INSERT INTO mkn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ais itu, Yesus masi ajar orang di Tuhan pung Ruma Sambayang Pusat. Ju Dia soꞌal sang dong bilang, “Iko bosong pung pikiran, karmana? Guru agama dong ajar soꞌal Kristus tu, yang Tuhan Allah su tunju dari dolu-kala. Iko dong, Dia cuma jadi raja Daud pung turunan sa. Ma itu sonde batúl. ");
INSERT INTO mkn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tagal dolu Tuhan Allah pung Roh yang Barisi su pake Daud ko tulis bilang, ‘Tuhan Allah su kasi tau sang beta pung bos bilang, “Mari ko dudu di ini tampa terhormat di Beta pung sablá kanan. Nanti Beta bekin sang lu pung musu dong, sampe dong taꞌalok sang lu.’ ” ");
INSERT INTO mkn_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Dari itu kotong dapa tau bilang, raja Daud sandiri pange sang Kristus tu bilang, ‘Bos’. Dia pung arti, kalo orang bilang Kristus tu, cuma raja Daud pung turunan sa, itu balóm cukup! Tagal Dia ju jadi raja Daud pung Bos yang hak parenta sang dia na!” ");
INSERT INTO mkn_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Waktu Yesus omong bagitu tadi, ju orang banya dong talalu suka dengar sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ais Dia kasi tau lai sang dong bilang, “Bosong musti ati-ati deng guru agama dong. Dong suka pasiar pake dong pung baju panjang raroso pi katumu banya orang, ko biar orang lia sang dong bilang, ‘We! Dong tu, orang bésar, ó!’ ");
INSERT INTO mkn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kalo dong maso pi ruma sambayang, ko, dong iko pesta, dong salalu cari tampa dudu yang paling bagus, ko biar banya orang lia sang dong. ");
INSERT INTO mkn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ma ati-ati, ó! Te dong ju maen putar-balek sang janda dong, ko rampas ame dong pung ruma samua. Ma di muka banya orang, dong tutu dong pung jahat tu, deng badiri sambayang lama-lama. Dong mau ko orang bilang dong pung hati barisi. Ma nanti Tuhan Allah kasi hukum paling barát sang dong.” ");
INSERT INTO mkn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ais itu, Yesus pi dudu bamangada deng peti derma di Tuhan pung Ruma Sambayang Pusat. Dia lia orang dong datang kasi maso dong pung doi kolekte pi dalam itu peti. Dia lia orang kaya dong ju datang kasi maso dong pung doi bam-banya di situ. ");
INSERT INTO mkn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ais ada satu janda kasian ju datang iko sambayang. Dia kasi maso doi dua sen di itu peti. Itu doi pung harga paling kici. ");
INSERT INTO mkn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ais Yesus gape Dia pung ana bua dong bilang, “Bosong lia bae-bae sang itu janda kasian tu. Dia kasi maso doi dua sen sa, ma dia su kasi lebe dari samua orang. ");
INSERT INTO mkn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Itu orang laen dong samua kasi maso kolekte dari dong pung doi sisa. Ma ini janda ni, dia su kasi abis dia pung doi samua sang Tuhan Allah.” ");
INSERT INTO mkn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ais itu, Yesus deng Dia pung ana bua dong mau pi kasi tenga Ruma Sambayang Pusat. Waktu dong kaluar, Dia pung ana bua satu kasi tunju itu Ruma Sambayang, ju bilang, “Papa, é! Coba Papa lia ini dolo! Ini Ruma pung bagus lai! Dong susun dia pung batu bésar dong talalu bagus, é!” ");
INSERT INTO mkn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Yesus manyao bilang, “Ini Ruma memang bagus! Ma sonde lama lai, te dong kasi rubu abis ini batu-batu samua.” ");
INSERT INTO mkn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ais ju Yesus dong pi gunung Saitun, ko dudu di tampa yang bamangada deng Ruma Sambayang Pusat. Ais Dia pung ana bua ampa orang datang ko dong baꞌomong sandiri deng Dia. Andia Petrus, Yakobis, Yohanis, deng Anderias. ");
INSERT INTO mkn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Dong tanya bilang, “Papa! Coba kasi tau ulang Papa pung omong tadi tu. Kapan tempo datang dia pung waktu tu? Deng dia pung tanda-tanda tu, karmana?” ");
INSERT INTO mkn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ais Yesus manyao bilang, “Asal bosong jaga bae-bae, ó! Ko bosong jang kaná tipu. ");
INSERT INTO mkn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Te nanti ada macam-macam orang yang datang puku dada bilang, ‘Beta ni, Kristus, andia Orang yang Tuhan Allah su janji memang dari dolu’. Ais dong ju tipu banya orang. ");
INSERT INTO mkn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kalo bosong lia orang baparáng, ko, bosong dengar isu bilang, ada paráng di mana-mana, na, bosong sonde usa taku. Te macam bagitu tu musti jadi dolo, ma hari kiamat balóm sampe. ");
INSERT INTO mkn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nanti satu suku baparáng lawan laen suku. Satu negara baparáng lawan laen negara. Ada tana goyang di mana-mana. Musim lapar dong ju hebat mati pung! Ini samua jadi tanda-tanda, sama ke parampuan yang baru mulai saki mau barana. ");
INSERT INTO mkn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Jadi bosong musti jaga bae-bae, é! Te nanti dong datang tangkap sang bosong ko hela bawa pi pangadilan agama. Deng dong papoko sang bosong dalam ruma sambayang dong. Dong ika bawa sang bosong pi orang yang pegang kuasa, tagal bosong iko sang Beta. Ma itu ju jadi salák ko bosong kasi tau sang dong soꞌal Beta. ");
INSERT INTO mkn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Te Tuhan pung orang musti pi kasi tau lebe dolo Beta pung Carita Bae sang samua suku di ini dunya, baru hari kiamat sampe. ");
INSERT INTO mkn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Inga, ó! Kalo dong ika bawa sang bosong pi pangadilan, bosong sonde usa taku bilang, ‘Nanti beta mau baꞌomong bilang apa? Ko, beta manyao bilang apa?’ Kalo dia pung waktu su sampe bagitu, bosong omong iko sa, apa yang Tuhan Allah pung Roh yang Barisi kasi tau sang bosong. ");
INSERT INTO mkn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dalam satu ruma, kalo ada orang yang parcaya sang Beta, nanti dia pung sodara sandiri cari jalan ko bunu sang dia. Ais kalo ana yang parcaya, nanti dia pung papa sandiri bunu sang dia. Ju kalo ada mama deng papa yang parcaya sang Beta, nanti dong pung ana sandiri yang bunu sang dong. ");
INSERT INTO mkn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jadi nanti orang dong binci mati sang bosong, tagal bosong parcaya sang Beta. Ma sapa yang batahan sampe abis, pasti Tuhan Allah kasi salamat sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus omong tarús bilang, “Satu orang yang jahat mati pung nanti datang. Dia maso pi badiri di tampa pamali di Tuhan Allah pung Ruma Sambayang Pusat yang sonde pantas buat dia, sampe dia bekin noju itu tampa. Andia ko Tuhan Allah bale balakang kasi tenga itu tampa. Kalo bosong su lia bagitu, ati-ati, ó! (Sapa yang baca ni, ju musti ati-ati!) Itu jadi tanda bilang, hari-hari susa su sampe di muka pintu. Kalo su lia bagitu, orang di propinsi Yudea bangun lari pi gunung suda. ");
INSERT INTO mkn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Deng musti lari capát-capát, ko biar jang calaka. Kalo ada yang su kaluar dari ruma, jang pulang pi ame barang lai. ");
INSERT INTO mkn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ju orang yang ada di kabón, jang kambali ko ame kaen panas lai. Ma lari tarús sa! ");
INSERT INTO mkn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yang paling kasian, parampuan yang ada dudu parú, deng mama-mama yang ada kasi susu ana mera. Ko dong sonde bisa lari capát na. ");
INSERT INTO mkn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jadi lebe bae bosong sambayang ko minta hal jahat tu jang jato pas deng musim ujan. ");
INSERT INTO mkn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Te itu hari talalu susa mau mati! Mulai dari Tuhan Allah bekin ini dunya sampe sakarang, orang balóm parná lia susa bésar macam ke bagitu. Deng nanti orang ju sonde lia ulang susa macam bagitu lai. ");
INSERT INTO mkn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kalo Tuhan sonde kasi pende itu hari, nanti sonde ada satu orang ju yang bisa batahan idop. Ma tagal Tuhan Allah sayang Dia pung orang yang Dia su pili dong, andia ko Dia kasi pende itu hari-hari susa dong. ");
INSERT INTO mkn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nanti kalo itu hari su sampe, bosong dengar orang dong bilang, ‘Lia dolo! Kristus ada di sini!’ Ma orang laen bilang, ‘Kristus ada di sana!’ Ma bosong jang dengar, é! ");
INSERT INTO mkn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Te nanti ada orang kaluar ko puku dada bilang, ‘Beta ni, Kristus!’ Yang laen lai bilang, ‘Beta ni, Tuhan Allah pung jubir.’ Nanti dong bekin tanda heran macam-macam pake setan pung kuasa ko putar-balek orang. Dong coba-coba ko Tuhan Allah pung orang dong ju kaná tipu! ");
INSERT INTO mkn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ma bosong musti jaga bae-bae, é! Itu hari-hari susa dong balóm sampe, ma Beta su kasi inga memang sang bosong, ó!” ");
INSERT INTO mkn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ais Yesus sambung lai ko kasi tau Dia pung ana bua dong bilang, “Kalo itu hari-hari susa dong su abis, ‘Nanti matahari jadi galáp, bulan ju su sonde taráng lai. ");
INSERT INTO mkn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Bintang-bintang bajato dari langit, deng kuasa di langit dong jadi harba-biruk.’ ");
INSERT INTO mkn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ais itu, baru samua orang dapa lia sang Beta, Manusia Tulen ni. Nanti Beta datang di awan dari langit. Deng samua orang dapa lia Beta pung kuasa, deng Beta pung hebat samua! ");
INSERT INTO mkn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ais Beta parenta Tuhan Allah pung ana bua di sorga, ko pi kumpul samua orang yang Beta su pili dari dunya pung ujung-ujung, dari matahari nae sampe matahari turun; dari utara sampe salatan.” ");
INSERT INTO mkn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus sambung Dia pung omong bilang, “Beta ame umpama dari pohon. Kalo dia pung daon mulai kuning, itu tanda bilang, musim panas su deka-deka datang. ");
INSERT INTO mkn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bagitu ju, kalo bosong su lia hari-hari susa datang, sama ke yang Beta su kasi tau tadi tu, itu tanda bilang, Beta su deka-deka datang. ");
INSERT INTO mkn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Sakarang dengar bae-bae! Dari samua orang yang idop sakarang ni, nanti ada yang balóm mati, te itu hari-hari susa dong su datang. ");
INSERT INTO mkn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Biar langit deng bumi su ilang, ma Beta pung omong ni batahan sonde abis-abis.” ");
INSERT INTO mkn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus omong tamba bilang, “Sonde ada satu orang yang tau kapan Beta pung hari deng jam datang kambali. Tuhan Allah pung ana bua di sorga, ju sonde tau. Beta sandiri, ju sonde tau. Cuma Beta pung Papa sa yang tau. ");
INSERT INTO mkn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tagal itu, bosong musti bajaga bae-bae, tagal bosong sonde tau kapan dia pung waktu. ");
INSERT INTO mkn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sonde lama lai Beta su pi kasi tenga sang bosong, ma nanti Beta datang kambali. Sama ke tuan ruma yang jalan kasi tenga dia pung ruma ko pi tampa jao. Dia suru dia pung ana bua dong ko urus bae-bae itu ruma. Deng dia bagi kasi dong satu-satu deng dia pung karjá. Dia parenta tukang jaga pintu ko bajaga bae-bae, sampe dia pulang. ");
INSERT INTO mkn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bosong ju musti bajaga siang-malam, tagal bosong sonde tau kapan tuan ruma pulang. Pulang sore ko, tenga malam ko, siang ko, waktu matahari nae ko. Bosong sonde tau kapan. ");
INSERT INTO mkn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jang sampe dia datang takuju, te dapa bosong ada tidor masanggorok. ");
INSERT INTO mkn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jadi apa yang Beta kasi tau sang bosong ni, Beta ju kasi tau samua orang laen bilang, ‘Bosong musti bajaga bae-bae ko sambut Beta pung datang.’ ” Sampe di situ, Tuhan Yesus barenti baꞌomong deng Dia pung ana bua dong di gunung Saitun. ");
INSERT INTO mkn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Ais itu, kapala agama Yahudi dong pung bos-bos deng guru agama dong masi bacari akal ko mau tangkap sang Yesus deng diam-diam. Ko dong mau bunu sang Dia na. Ma dong ator siasat bilang, “Tahan dolo! Kotong jang tangkap sang Dia capát-capát, tagal hari-hari bae su deka. Jang sampe orang banya dong nanti mangamok.” Dong baꞌomong bagitu, tagal masi dua hari lai, orang Yahudi dong pung hari-hari bae, yang dong kasi nama ‘Hari Paska’ deng ‘Pesta Roti Sonde Pake Ragi’. Deng itu hari-hari bae, dong inga tempo dolu, waktu dong pung nene-moyang kaluar dari negrí Masir. ");
INSERT INTO mkn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Di kampong Betania, ada satu orang nama Simon. Dolu orang noju sang dia, tagal dia kaná panyaki kusta. Ma sakarang dia su bae. Ais itu ju, waktu itu hari-hari bae balóm datang, Yesus dong ada pi makan di Simon pung ruma. Waktu dong makan, ada satu parampuan datang katumu sang Yesus. Dia ada pegang satu botol yang dong bekin dari batu. Dia pung isi, minya wangi asli yang mahal mati pung. Ais, itu parampuan puku bekin pata itu botol pung tutu. Ju dia poꞌa kasi malele palán-palán itu minya di Yesus pung kapala, ko jadi tanda dia kasi hormat sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma ada barapa orang laen yang iko makan di situ ju. Waktu dong lia itu parampuan bekin bagitu, ju dong mara, ko dong baꞌomong sombong bilang, “Hmm! Parampuan apa ni, ko dia pi buang parcuma itu minya wangi yang mahal mati pung! ");
INSERT INTO mkn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Lebe bae dia jual itu minya sa! Ko pi bagi dia pung doi yang banya, kasi sang orang malarat dong! Te itu minya wangi pung harga, sama ke satu orang pung gaji satu taon.” Ju dong togor karás sang dia. ");
INSERT INTO mkn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma Yesus balas bilang, “Bosong sonde usa bekin susa ini parampuan! Kasi tenga pi sang dia sa! Beta sanáng, tagal dia su poꞌa ini minya wangi di Beta pung badan. ");
INSERT INTO mkn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Orang kasian dong salalu ada deng bosong. Jadi bosong bisa tolong sang dong kapan sa. Ma kalo Beta, sonde lama lai, te Beta su sonde ada sama-sama deng bosong. ");
INSERT INTO mkn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Beta pung idop su sonde lama lai. Deng ini parampuan poꞌa ini minya tadi, dia su sadia Beta pung badan lebe dolo, sama ke dia kasi rampe memang Beta pung mayat. ");
INSERT INTO mkn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Inga bae-bae, ó! Di mana sa Tuhan Allah pung Carita Bae tasiar kuliling ini dunya, dong ju pasti carita ini parampuan pung bae! Ko biar samua orang inga sang dia.” ");
INSERT INTO mkn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ais ju ada satu dari Yesus pung ana bua dua blas orang tu, nama Yudas Iskariot. Dia kaluar pi cari kapala agama Yahudi dong pung bos-bos, ko mau jual buang sang Yesus kasi dong. Sampe di dong, ju dia kasi tau dia pung maksud. ");
INSERT INTO mkn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Waktu bos-bos dong dengar Yudas pung omong bagitu, ju dong sanáng mau mati. Ju dong janji bilang, “Kalo lu mau jual Yesus kasi sang botong, pasti botong bayar.” Ais Yudas kaluar, ju dia mulai cari akal ko mau kasi Yesus pi sang dong. ");
INSERT INTO mkn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Itu hari jato di hari partama dari orang Yahudi pung hari-hari bae. Jadi di itu hari, dong biasa bakar roti yang sonde pake bibit roti, deng dong ju horo domba. Ais ju Yesus pung ana bua dong datang tanya sang Dia bilang, “Papa! Ini hari ni, kotong pung hari bae Paska. Jadi Papa mau botong pi sadia tampa pesta Paska di mana?” ");
INSERT INTO mkn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ais Yesus suru Dia pung ana bua dua orang bilang, “Bosong pi lebe dolo di kota. Di sana, nanti bosong katumu deng satu laki-laki yang ada masaꞌa aer di satu kumbang kici. Bosong pi iko sang dia sa. ");
INSERT INTO mkn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nanti kalo dia maso pi ruma mana, na, bosong pi iko sang dia di situ. Ais bosong kasi tau sang itu tuan ruma bilang, ‘Bapa! Botong pung Bapa Guru ada minta satu tampa, ko Dia mau pake bekin pesta Paska deng Dia pung ana bua dong.’ ");
INSERT INTO mkn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ais nanti itu orang kasi tunju satu kamar luas di lante atas. Dia su sadia langkáp itu kamar. Cuma tenga bosong dua pi ko sadia makan di situ sa.” ");
INSERT INTO mkn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ais dong dua jalan pi kota. Di sana dong dapa katumu deng samua yang Yesus su kasi tau memang sang dong. Ju dong sadia samua, ko Yesus dong makan pesta Paska di situ. Ais dong dua pi pange sang Yesus dong. ");
INSERT INTO mkn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Waktu matahari su mulai tanggalám, ju Yesus deng Dia pung ana bua dua blas orang dong pi di situ. ");
INSERT INTO mkn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ais dong dudu ko makan sama-sama. Waktu dong ada makan, Yesus baꞌomong bilang, “Bosong dengar, é! Ada satu orang dari bosong yang nanti jual Beta kasi pi orang laen dong.” ");
INSERT INTO mkn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dengar bagitu, ju dong pung hati rasa tar enak. Tarús dong satu-satu tanya sang Yesus bilang, “Itu orang yang Papa omong tu, bukan beta, to?” ");
INSERT INTO mkn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus manyao bilang, “Orang yang colo dia pung roti pi dalam ini mangko sama-sama deng Beta, dia tu yang nanti jual buang sang Beta. ");
INSERT INTO mkn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Inga, é! Beta, Manusia Tulen ni, musti mati sama ke dong su tulis memang dalam Tuhan Allah pung Tulisan Barisi. Ma awas! Itu orang yang mau jual Beta tu, nanti dia pikol dia pung calaka! Ada lebe bae kalo dia pung mama sonde barana ame sang dia!” ");
INSERT INTO mkn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Waktu dong masi makan, ju Yesus angka ame roti satu balok, ko minta tarima kasi sang Tuhan Allah. Ais Dia bekin pica-pica itu roti, ju sorong kasi sang Dia pung ana bua dong. Ju Dia bilang, “Ini roti, Beta pung badan. Ame ko makan suda.” ");
INSERT INTO mkn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ais itu, Dia angka ame galás yang ada isi bua anggor pung aer. Dia ju minta tarima kasi sang Tuhan Allah. Ais Dia sorong kasi itu galás pi Dia pung ana bua ko dong samua minum. ");
INSERT INTO mkn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ju Dia bilang, “Ini anggor, Beta pung dara. Dia nanti tatumpa ko kasi salamat banya orang. Ini dara jadi bukti ko kasi inga bilang, apa yang Tuhan Allah su janji, memang sakarang ni su jadi. Naa, ame ko minum suda. ");
INSERT INTO mkn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dengar bae-bae dolo! Mulai dari ini malam, Beta su sonde minum bua anggor pung aer lai. Sampe Beta dudu parenta sama-sama deng Beta pung Bapa di sorga, baru Beta minum lai.” ");
INSERT INTO mkn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ais ju dong manyanyi satu lagu ko puji sang Tuhan Allah. Tarús dong kaluar malam ko pi gunung Saitun. ");
INSERT INTO mkn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Waktu dong bajalan tu, Yesus kasi tau memang bilang, “Nanti sabantar malam ni, bosong samua lari kasi tenga sang Beta. Itu sama ke dong su tulis memang dalam Tuhan Allah pung Tulisan Barisi bilang, ‘Nanti Tuhan Allah bekin mati gambala, ais dia pung domba dong lari batasiram.’ ");
INSERT INTO mkn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Beta memang mati. Ma nanti kalo Beta su idop kambali, Beta pi lebe dolo dari bosong di propinsi Galilea.” ");
INSERT INTO mkn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ais ju Petrus protes bilang, “Papa! Biar orang laen dong samua lari kasi tenga sang Papa, ma beta sonde akan!” ");
INSERT INTO mkn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus manyao bilang, “Peꞌu! Inga, é! Ini malam, ayam balóm kokoreꞌo dua kali, ma lu su omong tiga kali bilang, lu sonde kanál sang Beta!” ");
INSERT INTO mkn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma Petrus manyao karás bilang, “Sonde, Papa! Kalo Papa mati, beta ju iko mati sama-sama. Ma beta sonde akan lari kasi tenga sang Papa, deng sonde manyangkal sang Papa!” Petrus pung tamán laen dong ju satu-satu bilang bagitu. ");
INSERT INTO mkn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ais itu, Yesus dong jalan tarús sampe di satu kabón di gunung Saitun, nama ‘Getsemani’. Ju Yesus kasi tau sang dong bilang, “Bosong dudu tunggu di sini, é. Beta mau pi sambayang di sana.” ");
INSERT INTO mkn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ju Yesus pange bawa sang Petrus, Yakobis, deng Yohanis, ko pi sama-sama deng Dia. Mulai dari itu waktu, ju Dia pung hati rasa susa deng sonde tanáng. ");
INSERT INTO mkn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dia kasi tau sang dong bilang, “Beta pung hati susa mau mati! Beta rasa tingka ke Beta su mau mati sa. Bosong dudu bajaga di sini dolo.” ");
INSERT INTO mkn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ais Dia maju lebe jao sadiki, ju Dia tikam lutut di tana ko sambayang bilang, “Papa manis! Kalo Papa satuju, na, Beta sonde usa tanggong itu sangsara sampe mati macam bagini. Beta su tau memang bilang, sonde ada yang Papa sonde bisa bekin. Jadi kalo bole, na, Papa angka buang jao-jao ini sangsara dari Beta. Ma jang iko Beta pung mau; biar iko Papa pung mau sa.” ");
INSERT INTO mkn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ais ju Dia kambali pi Dia pung ana bua tiga orang tu, ma dong ada tidor sonu. Ais Dia kasi bangun sang dong, ju Dia omong sang Petrus bilang, “He, Peꞌu! Lu tidor, ko? Beta di situ cuma sabantar sa, ma bosong sonde bisa bajaga sadiki ju! ");
INSERT INTO mkn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Goso bekin taráng lu pung mata dolo. Ais bangun ko bajaga deng Beta! Bosong pung hati memang mau bekin yang bae, cuma bosong pung badan sonde kuat. Jadi lebe bae bosong sambayang, ko kalo kaná cobaꞌan, bosong sonde kala.” ");
INSERT INTO mkn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ais Yesus pi sambayang satu kali lai. Dia minta ulang sang Tuhan, ko jang kasi tenga Dia pikol itu sangsara. ");
INSERT INTO mkn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ais Dia datang kambali di Dia pung ana bua tiga orang tu. Ma dong su tidor ulang lai, te dong pung mata barát mau mati. Ais Dia kasi bangun ulang sang dong, ma dong sonde tau mau manyao bilang apa sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ais itu, Yesus kasi tenga sang dong ko pi sambayang yang katiga kali. Ais ju Dia kambali ko kasi bangun sang dong. Dia bilang, “Bosong masi tidor lai, ko? Cukup suda! Bangun! Te orang yang mau jual sang Beta, Manusia Tulen ni, su deka. Sakarang dong su mau tangkap sang Beta, ko kasi pi orang jahat dong pung tangan. ");
INSERT INTO mkn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangun su! Buka bosong pung mata ko lia coba pi sana dolo! Orang yang mau jual buang sang Beta tu, su datang. Mari ko kotong pi katumu sang dong!” ");
INSERT INTO mkn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Waktu Yesus masi baꞌomong bagitu, ju takuju sa, Yudas su datang deng orang bam-banya. Dong datang deng bawa kalewang kudung deng kayu kudung, ko mau tangkap sang Yesus. Dong bekin bagitu, iko parenta dari bos-bos Yahudi dong. Dong tu, andia kapala agama dong pung bos-bos, guru agama dong, deng tua-tua adat. ");
INSERT INTO mkn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas su kasi sein memang sang dong bilang, “Bosong lia bae-bae! Beta ciom sang sapa, na, bosong tangkap ame sang Dia suda! Andia Dia tu, orang yang bosong cari!” ");
INSERT INTO mkn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jadi waktu Yudas dong sampe di situ, ju dia langsung mangada sang Yesus. Ais dia togor bilang, “Bapa Guru!” Ju Yudas paló-ciom ame sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tarús orang banya dong maju datang, ko tangkap sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma Yesus pung orang satu cabu ame dia pung parang kudung ko seruk bekin putus satu orang pung daon talinga. Itu orang yang luka tu, kapala agama Yahudi pung bos bésar pung orang suru-suru. ");
INSERT INTO mkn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ais Yesus omong deng itu orang dong yang datang tangkap sang Dia bilang, “Karmana? Bosong kira Beta ni orang jahat, ko? Jadi bosong datang tangkap sang Beta deng bawa kalewang deng kayu kudung? ");
INSERT INTO mkn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tiap hari Beta ajar sang bosong di Tuhan Allah pung Ruma Sambayang Pusat, ma sonde ada satu orang yang datang tangkap sang Beta. Mari tangkap sang Beta suda! Te ini su tulis memang dari dolu di Tuhan Allah pung Tulisan Barisi.” ");
INSERT INTO mkn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesus pung ana bua dong taku mau mati. Ju dong bangun lari kasi tenga sang Dia sandiri sa. ");
INSERT INTO mkn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Di situ ju, ada satu orang muda yang iko-iko Yesus pung balakang. Dia ada bungkus badan deng kaen sapotong. Itu orang dong ju mau tangkap sang dia. ");
INSERT INTO mkn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ma dong dapa pegang dia pung kaen sa. Ais dia lari pulang deng talanjang sa, ko dia su taku mau mati na. ");
INSERT INTO mkn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ais itu, dong pegang bawa sang Yesus pi kapala agama Yahudi pung bos bésar pung ruma. Di situ, orang bésar dong su bakumpul. Andia, kapala agama dong pung bos-bos, guru agama dong, deng tua-tua adat. ");
INSERT INTO mkn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Waktu dong pegang bawa sang Yesus tu, Petrus ju ada iko sambunyi-sambunyi dari balakang, sampe di kapala agama Yahudi pung bos bésar pung ruma. Dia ju maso di kintal, ko iko dudu panggang api sama-sama deng orang jaga yang ada di situ. ");
INSERT INTO mkn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Di dalam itu ruma, kapala agama dong pung bos-bos ada baꞌomong deng orang-orang yang dudu di pangadilan agama. Dong samua cari bukti ko mau kasi sala sang Yesus, tagal dong mau hukum mati sang Dia. Ma dong sonde dapa bukti apa-apa. ");
INSERT INTO mkn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ju dong pange ame banya saksi ko mau kasi jato sang Yesus. Ma dong pung omong tu, sonde bacocok satu deng satu. ");
INSERT INTO mkn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ais ada barapa saksi lai yang bangun badiri ko omong putar-balek bilang, ");
INSERT INTO mkn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Botong ada dengar ini orang omong bilang, ‘Nanti Beta kasi rubu Ruma Sambayang Pusat yang manusia kasi bangun deng tangan. Ais tiga hari lai, nanti Beta kasi bangun ulang itu Ruma, ma sonde pake manusia pung tangan.’ ” ");
INSERT INTO mkn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma dong pung omong tu, sonde bacocok satu deng satu. ");
INSERT INTO mkn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ais kapala agama Yahudi pung bos bésar tu, bangun badiri di muka samua orang yang dudu di itu pangadilan. Ju dia tanya sang Yesus bilang, “Banya orang su kalák sang Lu. Ma akurang ko Lu diam sa?” ");
INSERT INTO mkn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesus sonde omong sadiki ju. Ais kapala agama Yahudi pung bos bésar tanya ulang sang Dia bilang, “Coba Lu kasi tau dolo! Apa memang Lu ni, batúl-batúl Kristus, Tuhan Allah pung Ana yang Dia su janji dari dolu tu?” ");
INSERT INTO mkn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus manyao bilang, “Memang batúl. Dia tu, andia Beta ni. Nanti bosong samua dapa lia Beta, Manusia Tulen ni, dudu di sorga di Tuhan Allah pung sablá kanan. Dia yang pung kuasa paling hebat! Nanti Beta deng Dia sama-sama pegang parenta! Ais itu, nanti Beta turun datang dari sorga deng awan.” ");
INSERT INTO mkn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dengar Yesus omong bagitu, ju kapala agama Yahudi pung bos bésar mara mau mati, sampe dia ruꞌi bekin tarobe dia pung baju panjang. Ais dia batarea kasi tau samua orang yang dudu di pangadilan tu bilang, “Kotong sonde parlú saksi lai! ");
INSERT INTO mkn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bosong su dengar deng bosong pung talinga sandiri, Dia sandiri yang omong bagitu, to? Dia su angka diri jadi Tuhan Allah pung Ana. Ini hojat barát! Iko atoran agama, kalo ada orang bekin diri sama deng Tuhan Allah, itu orang musti mati! Jadi sakarang, bosong mau putus bilang apa?” Ju dong samua putus bilang, “Ini orang memang batúl sala! Jadi dia musti kaná hukum mati!” ");
INSERT INTO mkn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ais barapa orang maju ko sumbur luda sang Yesus. Dong tutu ame Dia pung mata, ju dong papoko sang Dia. Ais dong suru bilang, “Kalo Lu jadi Tuhan pung jubir, na, coba Lu rai. Sapa yang falungku sang Lu?” Ais dong parenta orang yang jaga Ruma Sambayang Pusat, ko dong datang bawa sang Yesus. Dong bawa sang Dia pi, ju dong tampeleng barmaen sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Itu waktu, Petrus masi iko dudu di kintal. Ais kapala agama Yahudi pung bos bésar pung hamba parampuan satu datang lia sang dia ada panggang api. Dia lia bae-bae Petrus pung muka, ais dia omong bilang, “Tadi lu ju ada iko sama-sama deng Yesus, itu orang Nasaret, to? Batúl, to?” ");
INSERT INTO mkn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma Petrus manyao bilang, “Sonde! Akurang ko lu tanya bagitu! Beta sonde kanál sang Dia.” Ais Petrus kaluar ko pi badiri di muka pintu maso. Pas itu waktu ju, ayam kokoreꞌo. ");
INSERT INTO mkn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ais, itu hamba dapa lia ulang sang Petrus. Ju dia kasi tau orang-orang yang ada di situ bilang, “Dia ni, satu dari itu orang dong!” ");
INSERT INTO mkn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ju Petrus protes bilang, “Lu gila mangkali! Beta sonde kanál itu Orang, ma!” Sonde lama lai, satu orang laen yang ada di situ omong lai sang Petrus bilang, “Heh! Lu masi mau putar-balek lai bilang, lu sonde sama-sama deng itu orang dong! Weh! Bosong samua, orang Galilea, to?” ");
INSERT INTO mkn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma Petrus malawan lai bilang, “Weh! Beta sumpa! Beta sonde kanál itu Orang!” ");
INSERT INTO mkn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pas dia omong bagitu, ju ayam kokoreꞌo dua kali. Ju Petrus inga ame Yesus pung bahasa tadi bilang, “Ayam balóm kokoreꞌo dua kali, ma lu su manyangkal sang Beta tiga kali.” Inga ame bagitu, ju Petrus manangis makarereu. ");
INSERT INTO mkn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Papagi sakali, samua orang di pangadilan tu, basakongkol ko mau bekin mati sang Yesus. Ais dong ika bawa sang Dia pi mangada sang gubernor Pilatus. ");
INSERT INTO mkn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Waktu dong sampe di gubernor, dia soꞌal sang Yesus bilang, “Karmana? Batúl Lu ni, orang Yahudi pung Raja, ko?” Yesus manyao bilang, “Batúl. Pak gub su omong batúl tu.” ");
INSERT INTO mkn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ais kapala agama Yahudi dong pung bos-bos baꞌomong deng gubernor bilang, “Ini orang su bekin sala sonde sadiki!” Ju dong kasi tau Dia pung sala-sala dong, satu-satu. ");
INSERT INTO mkn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ais gubernor tanya ulang sang Yesus bilang, “Lu sonde dengar dong pung omong tu? Dong su kasi sala bam-banya sang Lu. Coba Lu balas dolo!” ");
INSERT INTO mkn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma Yesus sonde manyao apa-apa, sampe itu gubernor taheran-heran. ");
INSERT INTO mkn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tiap taon, kalo orang Yahudi dong bekin pesta Paska, orang banya dong biasa pili satu orang bui, ko gubernor kasi lapás sang dia. ");
INSERT INTO mkn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Itu waktu, ada satu orang bui, nama Barabas. Dolu dong tangkap sang dia deng dia pung tamán dong, tagal dia malawan pamarenta Roma, deng dia ju bunu orang. ");
INSERT INTO mkn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tagal itu pesta Paska su deka-deka, andia ko banya orang pi gubernor Pilatus ko batarea bilang, “Pak gubernor! Hari Paska su datang! Kalo bisa, na, pak gub tolong kasi lapás satu orang bui sama ke biasa!” ");
INSERT INTO mkn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ais gubernor manyao bilang, “Naa! Beta mau kasi lapás sang sapa? Karmana kalo beta lapás bosong orang Yahudi pung Raja ni? Bosong satuju, ko?” ");
INSERT INTO mkn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gubernor omong bagitu, padahal dia su tau kapala agama Yahudi dong pung bos-bos ada bawa sang Yesus kasi dia, tagal dong ada binci talalu sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma itu bos-bos agama tusu-tusu itu orang banya dong, ko dong samua minta sang gubernor bilang, “Botong sonde mau sang Dia! Kasi lapás sang Barabas sa!” ");
INSERT INTO mkn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ais gubernor tanya ulang bilang, “Kalo bagitu, beta musti bekin apa sang Yesus, yang dong pange sang Dia, ‘Raja orang Yahudi’ ni?” ");
INSERT INTO mkn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ju dong samua batarea rame-rame bilang, “Bekin mati sang Dia sa! Paku Dia di kayu palang!” ");
INSERT INTO mkn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ais gubernor tanya bilang, “Ko Dia pung sala apa? Beta su pareksa sang Dia, ma beta sonde dapa Dia pung sala apa-apa!” Ma dong samua batarea lebe karás lai bilang, “Bekin mati sang Dia! Paku Dia di kayu palang suda!” ");
INSERT INTO mkn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tagal gubernor mau bekin sanáng orang banya dong pung hati, andia ko dia lapás sang Barabas, iko dong pung mau. Ais dia parenta orang jaga dong, ko pi firuk sang Yesus pake cambuk. Firuk abis, ju tantara dong ame bawa sang Yesus, ko mau pi paku bekin mati sang Dia di kayu palang. ");
INSERT INTO mkn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ais itu, tantara dong hela bawa sang Yesus di dong pung kintal bésar. Di situ dong pange ame dong pung tamán satu batalyon. ");
INSERT INTO mkn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ju dong kasi pake sang Yesus satu baju panjang warna ungu sama ke raja dong biasa pake. Ais dong ame pohon baduri pung takis ko malaꞌe bekin topi. Ju dong tendes itu topi baduri pi Yesus pung kapala, ko maen-maen bekin sama ke dong mau angka raja baru pake topi jabatan. ");
INSERT INTO mkn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ju dong samua kasi hormat maen-maen sang Dia, deng bilang, “Tabe raja orang Yahudi!” ");
INSERT INTO mkn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ju dong sangaja tondo kasi hormat di Yesus pung muka. Ais dong sumbur luda ulang-ulang di Dia pung muka. Ais dong kadeluk ulang-ulang sang Dia deng kayu. ");
INSERT INTO mkn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Dong barmaen abis sang Dia, ju dong buka buang itu baju panjang. Ju dong kasi pake ulang Dia pung pakean. Ais ju dong bawa sang Dia pi kaluar kota Yerusalem, ko pi paku tagantong sang Dia di kayu palang sampe mati. ");
INSERT INTO mkn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Waktu dong jalan kaluar dari Yerusalem, di tenga jalan dong katumu satu orang dari kota Kirene. Dia pung nama Simon. Dia tu, Aleksander deng Rufus pung bapa. Dia baru mau maso pi Yerusalem, ma tantara dong pegang ame sang dia, ko paksa pikol Yesus pung kayu palang. ");
INSERT INTO mkn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dong hela bawa sang Yesus sampe di satu tampa, nama Golgota. (Dia pung arti bilang, ‘tampa tulang kapala’.) ");
INSERT INTO mkn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Di situ, dong mau kasi minum sang Yesus anggor asam yang su campor deng obat, ko biar Dia bisa tahan saki. Ma Yesus sonde mau minum. ");
INSERT INTO mkn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ais dong paku malenggang sang Yesus di kayu palang. Ju dong kasi badiri itu kayu palang, kira-kira jam sambilan pagi. Ju tantara dong hela lot ko mau tau sapa yang dapa Yesus pung pakean. ");
INSERT INTO mkn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ais dong tulis di satu papan, ko paku di Yesus pung atas kapala bilang, “Ini, orang Yahudi pung Raja” Dong pake itu alasan ko hukum sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Di situ, dong ju paku kasi mati dua orang parampok. Satu di Yesus pung sablá kanan; satu di Dia pung sablá kiri. ");
INSERT INTO mkn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Deng bagitu dong iko apa yang su tulis memang di Tuhan Allah pung Tulisan bilang, “Dong bekin sang Dia sama ke orang jahat.” ");
INSERT INTO mkn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Samua orang yang jalan lewat di situ lia Yesus tagantong di itu kayu palang. Ju dong goyang-goyang kapala ko olok bekin malu Yesus bilang, “Hoi! Lu bilang Lu bisa kasi rubu Tuhan Allah pung Ruma Sambayang Pusat, ais kasi bangun ulang dalam tempo tiga hari, to? ");
INSERT INTO mkn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Coba Lu turun dari itu kayu palang, ko kasi lapás Lu pung diri suda! Kalo bagitu, baru botong parcaya memang Lu ni, Tuhan Allah pung Ana.” ");
INSERT INTO mkn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kapala agama Yahudi dong pung bos-bos deng guru agama dong ju olok sang Yesus, deng baꞌomong bilang, “Dia su kasi salamat orang laen, ma sonde bisa kasi salamat Dia pung diri sandiri! ");
INSERT INTO mkn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dia bilang Dia pung diri, ‘Kristus’, andia Orang yang Tuhan Allah su janji memang dari dolu. Orang laen bilang, Dia ni orang Israꞌel pung Raja. Kalo batúl bagitu, na, biar Dia turun dari kayu palang ko kotong lia dolo. Bagitu, baru kotong bisa parcaya sang Dia.” Itu dua orang yang tagantong sama-sama deng Yesus di kayu palang, ju iko olok sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ais itu, galáp gulita tutu ame itu tampa dari tenga hari sampe jam tiga sore. ");
INSERT INTO mkn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pas jam tiga sore ju, Yesus batarea pake bahasa Aram bilang, “Eloi! Eloi! Lema sabaktani?” (Dia pung arti bilang, “Beta pung Tuhan! Beta pung Allah, é! Akurang ko Papa bale balakang kasi tenga sang Beta bagini?”) ");
INSERT INTO mkn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ada barapa orang deka-deka di situ dengar Yesus pung suara tu. Ju dong bilang, “Hoi! Bosong dengar dolo. Dia ada pange sang Elia, Tuhan pung jubir dolu tu!” ");
INSERT INTO mkn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ais satu orang lari-lari pi ame lumut ko calóp maso pi dalam anggor asam. Ju dia tusu itu lumut deng ujung tongkat, ju sorong pi Yesus pung bibir ko Dia isap. Ais, itu orang omong bilang, “Tunggu ko kotong lia coba! Sapa tau nanti Elia datang ko kasi turun sang Dia dari itu kayu palang.” ");
INSERT INTO mkn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ais Yesus batarea ulang lai, ju Dia mati. ");
INSERT INTO mkn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Di Ruma Sambayang Pusat, ada satu gorden bésar tagantong ko pele Tuhan Allah pung Kamar Paling Barisi. Parsís Yesus pung putus napas, ju itu gorden tarabe putus bagi dua, dari atas sampe bawa. ");
INSERT INTO mkn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Di Golgota, ada satu komandán jaga yang badiri deka Yesus pung kayu palang. Waktu dia lia Yesus pung mati, dia takuju. Ais dia bilang, “Awii! Ini Orang ni, memang batúl-batúl Tuhan Allah pung Ana, ó!” ");
INSERT INTO mkn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Deng ada parampuan barapa orang yang iko lia Yesus pung mati dari jao. Dong tu, yang dolu layani sang Yesus dong di Galilea. Andia, Salome, Maria dari negrí Magdala, deng Maria yang satu lai (andia Yakobis muda deng Yoses pung mama), deng banya parampuan laen dong yang iko datang di Yerusalem sama-sama deng Yesus. ");
INSERT INTO mkn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ais itu, ada satu orang cari jalan ko mau kasi turun Yesus pung mayat dari itu kayu palang. Itu orang pung nama Yusuf. Dia dari kota Arimatea. Deng dia ju anggota majelis di pangadilan agama Yahudi. Dia pung hati bae. Deng dia ada tunggu-tunggu Tuhan Allah pung parenta datang. Yesus pung mati tu, pas deng hari Jumat. Dia pung beso kaná deng orang Yahudi dong pung hari sambayang. Andia ko itu hari Jumat tu, Yusuf mau kasi turun lebe dolo Yesus pung mayat. Ais dia bekin barani dia pung hati, ko pi minta Yesus pung mayat di gubernor Pilatus. ");
INSERT INTO mkn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Waktu gubernor dengar Yusuf minta bagitu, ju dia heran. Ais dia bilang, “Awii! Ko itu orang su mati bagitu capát! Beta kira sonde mungkin bagitu, ó!” Ju dia suru orang ko pi pange itu komandán, ko dia tanya bilang, “Karmana, é? Yesus tu, su mati, ko balóm?” ");
INSERT INTO mkn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Itu komandán manyao bilang, “Dia memang su mati dari tadi, bapa.” Gubernor dengar bagitu, ju dia kasi isin sang Yusuf ko pi ame bawa Yesus pung mayat. ");
INSERT INTO mkn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ais Yusuf pi béli kaen panjang yang mahal. Tarús dia pi di Golgota. Ju dia kasi turun Yesus pung mayat dari kayu palang. Dia ju bungkus bae-bae itu mayat deng itu kaen baru. Itu waktu, dong baru abis pahat ame satu kubur di gunung batu. Ju dong koko kasi maso Yesus pung mayat pi dalam itu lobang kubur. Tarús dong guling ame satu batu plat yang bésar, ko dong tutu bae-bae di itu kubur pung pintu. Ju Yusuf dong pulang. ");
INSERT INTO mkn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Itu waktu, Maria dari Magdala deng Maria yang laen (andia Yoses pung mama), ju ada iko sampe di situ. Dong dua lia ko inga bae-bae itu tampa yang dong su taro Yesus pung mayat tu. ");
INSERT INTO mkn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dia pung beso, hari Sabtu, andia orang Yahudi dong pung hari sambayang. Waktu matahari su tanggalám, Maria dari negrí Magdala, Maria yang laen tu (andia Yakobis pung mama), deng Salome, pi béli minya wangi, ko beso dong mau pi siram di Yesus pung mayat, iko orang Yahudi dong pung adat. ");
INSERT INTO mkn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ais hari Minggu papagi sakali, ju dong tiga pi di itu kubur. ");
INSERT INTO mkn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Di tenga jalan dong baꞌomong bilang, “We! Nanti sapa yang bisa tolong kasi ondor itu batu bésar dari kubur pung pintu tu? Kotong tiga sa pasti sonde kuat, ko itu batu bésar mau mati na!” Ma sampe deng sampe di situ ju, dong dapa lia itu batu su taguling. ");
INSERT INTO mkn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ais dong maso pi dalam itu kubur. Ma dong takuju mau mati, tagal dong dapa lia satu orang muda ada dudu di dong pung sablá kanan, pake pakean puti mangkilat. ");
INSERT INTO mkn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ju itu orang muda kasi tau sang dong bilang, “Bosong sonde usa taku! Beta tau bosong datang ko mau cari Yesus dari Nasaret, yang dong su kasi mati di kayu palang tu. Dia su sonde ada di sini lai, ko Dia su idop kambali na! Mari ko bosong lia sandiri itu tampa yang dong taro Dia pung mayat tu, su kosong. ");
INSERT INTO mkn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Naa, bosong pulang capát-capát suda! Pi kasi tau sang Petrus dong bilang, Yesus su idop kambali. Dia su jalan lebe dolo pi Galilea. Nanti dong katumu deng Yesus di sana, sama ke yang dolu Dia su kasi tau memang sang dong. Naa, bosong pulang suda!” ");
INSERT INTO mkn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Waktu itu parampuan dong lia itu tampa kosong, dong takuju. Tarús dong lari kaluar. Ais dong pulang capát-capát. Dong sonde kasi tau sapa-sapa di jalan, tagal dong taku mau mati. ");
INSERT INTO mkn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hari Minggu papagi tu, Yesus pi kasi tunju muka lebe dolo sang Maria dari Magdala, yang dolu Yesus parná usir tuju setan dari dia pung diri. ");
INSERT INTO mkn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dia lia abis sang Yesus, tarús dia pulang ko pi kasi tau samua orang yang dolu iko sang Yesus. Dong masi bakumpul deng hati susa, deng dong pung aer mata jato inga Yesus pung mati tu. ");
INSERT INTO mkn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ais Maria kasi tau sang dong bilang, “Akurang ko bosong masi susa? Sonde usa susa lai, te Yesus su idop kambali! Tadi ni, beta baru sa katumu sang Dia na!” Ma dong samua manyao bilang, “Weh! Lu omong kosong!” ");
INSERT INTO mkn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ais itu, Yesus pung ana bua dua orang jalan pi satu kampong. Di tenga jalan ju, Yesus pi kasi tunju muka sang dong, ma Dia su jadi laen. Ma sonde lama, te dong ju kanál sang Dia. ");
INSERT INTO mkn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ais dong dua pulang pi kasi tau dong pung tamán bilang, “We! Bosong dengar dolo! Tadi ni, botong baru katumu deng Yesus di jalan!” Ma dong pung tamán dong samua manyao bilang, “Weh! Bosong jang omong kosong bagitu!” ");
INSERT INTO mkn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ais ju Yesus katumu deng Dia pung ana bua sablás orang, waktu dong ada dudu makan. Dia togor sang dong bilang, “Weh! Bosong pung kapala batu lai! Orang su kasi tau sang bosong bilang, dong su lia sang Beta deng dong pung mata biji sandiri, ma bosong sonde mau parcaya! Bosong bilang, dong samua omong kosong! Naa! Sakarang ni, Beta sandiri su datang. Beta memang su mati, ma sakarang ni, Beta su idop kambali! Naa, bosong lia sandiri sa. ");
INSERT INTO mkn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jadi sakarang bosong musti pi kuliling di ini dunya, ko pi kasi tau samua orang Beta pung Carita Bae ni. ");
INSERT INTO mkn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Orang yang parcaya sang Beta, deng dapa sarani, nanti Tuhan Allah kasi salamat sang dia, ko dia dapa tenga tarús deng Tuhan Allah di sorga. Ma orang yang sonde parcaya, nanti dia kaná hukum, deng Tuhan tola buang sang dia ko tenga tarús di luar. ");
INSERT INTO mkn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Deng orang yang parcaya sang Beta, nanti dong bekin tanda heran macam-macam, ko samua orang tau bilang, dong pung kuasa tu, memang datang dari Tuhan. Umpama, nanti dong bisa usir setan-setan pake Beta pung nama. Nanti Tuhan Allah bekin dong bisa baꞌomong pake bahasa laen yang dong sonde tau. ");
INSERT INTO mkn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ais kalo dong pegang ular baracon, ko, dong minum kaná racon, dong sonde kaná calaka. Ju kalo dong taro tangan ko sambayang sang orang saki, nanti itu orang jadi bae.” ");
INSERT INTO mkn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ais baꞌomong deng Dia pung ana bua dong, ju Tuhan Allah angka kasi nae sang Yesus pi sorga. Di situ Dia jadi Tuhan Allah pung tangan kanan, ko Dong dua dudu parenta sama-sama. ");
INSERT INTO mkn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ais ju Dia pung ana bua dong iko Dia pung parenta. Dong pi mana-mana ko kasi tau samua orang Yesus pung Carita Bae. Ju Tuhan Allah kasi kuasa sang dong, ko dong bekin samua tanda heran yang Yesus su kasi tau tu. Ais banya orang parcaya sang Yesus, te dong su tau bilang, Carita Bae tu, memang batúl. ");
INSERT INTO mkn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Bapa Teofilus yang terhormat. Salamat. Banya orang su coba tulis carita soꞌal hal-hal yang su jadi di botong pung teng-tenga. Dong tulis itu carita dong, pake carita-carita yang bataputar dari botong pi botong dari dolu, yang botong dapa tau dari Tuhan Yesus pung orang dalam dong, deng dari orang laen ju yang lia deng mata kapala sandiri. Samua carita tu, iko parsís-parsís ke Tuhan Allah pung janji memang dari dolu. Jadi beta su pareksa sampe alus-alus itu hal dong samua, mulai dari dia pung akar carita. Ais beta putus ko tulis ame itu samua deng bae-bae, iko dia pung urutan. Deng bagitu, pak bisa tau parsís apa yang su jadi. ");
INSERT INTO mkn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Deng pak ju bisa parcaya bilang, apa yang orang dong su carita kasi tu, bukan carita putar-balek. Samua tu, batúl-batúl ada! ");
INSERT INTO mkn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ini carita pung akar bagini: waktu raja Herodes pegang parenta di propinsi Yudea, ada satu orang, nama Sakaria. Dia tu, satu kapala agama Yahudi. Deng dia ju anggota dari baꞌi Abia pung kalompok kapala agama dong. Sakaria pung bini, nama Elisabet. Dia ju dari turunan kapala agama dong, te dia tu, baꞌi Musa pung kaka Harun pung turunan. ");
INSERT INTO mkn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dong dua idop lurus iko Tuhan Allah pung parenta deng atoran samua. Orang ju hormat sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dong dua ju su tua, ma sonde ada pung ana, te Elisabet pung tampa ana tu, ada tatutu. ");
INSERT INTO mkn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Satu kali, Sakaria deng dia pung kalompok Abia dong dapa roster karjá di Ruma Sambayang Pusat di kota Yerusalem. ");
INSERT INTO mkn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Iko dong pung biasa, itu kapala agama dong hela lot, ko mau tau sapa yang dapa tugas maso pi itu Ruma Sambayang Pusat pung Kamar Paling Barisi. Di situ, itu orang musti bakar kayu wangi di Tuhan Allah pung muka. Itu hari, lot jato kaná di Sakaria. ");
INSERT INTO mkn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ais ju dia maso pi. Waktu dia ada bakar kayu wangi dalam itu Kamar, orang bam-banya dong ada sambayang di kintal situ. ");
INSERT INTO mkn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Takuju sa, ju Tuhan Allah pung ana bua satu dari sorga, datang badiri di tampa bakar kayu wangi pung sablá kanan. ");
INSERT INTO mkn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lia bagitu, ju Sakaria taku mau mati, sampe sonde tau mau bekin apa. ");
INSERT INTO mkn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ma itu ana bua dari sorga omong bilang, “Sakaria! Jang taku, é! Te Tuhan Allah su dengar lu pung sambayang. Jadi lu pung bini nanti barana satu ana laki-laki kasi sang lu. Lu musti kasi nama sang dia, Yohanis. ");
INSERT INTO mkn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nanti banya orang ju iko sanáng sama-sama deng bosong, tagal bosong su dapa ana. Ini ana nanti bekin lu pung hati babunga. ");
INSERT INTO mkn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tuhan pung Roh yang Barisi pung kuasa ada sama-sama deng dia, mulai dari dia pung mama masi dudu parú. Dia musti pamali minum samua minuman karás. Waktu dia su bésar datang, Tuhan Allah pake sang dia jadi orang pantíng. ");
INSERT INTO mkn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nanti dia buju banya orang Israꞌel ko bale iko sang Tuhan Allah, yang ada hak parenta sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dia pung sifat deng kuasa nanti parsís ke baꞌi Elia, andia Tuhan pung jubir dari dolu. Dia datang lebe dolo dari kotong pung Bos. Dia bekin orang tua pung hati bale sayang sang dong pung ana-ana. Deng orang yang bale balakang sang Tuhan dia oba ju, ko dong bale iko sang Tuhan pung mau. Deng bagitu, dia bekin orang dong sadia dong pung hati ko tarima Bos pung datang.” ");
INSERT INTO mkn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma Sakaria bale tanya itu ana bua bilang, “Mana bisa?! Beta deng beta pung bini su tua bagini! Karmana ko beta bisa tau ini hal samua bisa jadi?” ");
INSERT INTO mkn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ais, itu ana bua manyao bilang, “Bagini! Beta ni, Gabriel, Tuhan Allah pung tukang suru-suru. Dia sandiri yang suru beta datang ko kasi tau ini kabar bae sang lu. ");
INSERT INTO mkn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma lu sonde mau parcaya beta pung omong. Jadi dia pung tanda yang lu minta bagini! Lu pung lida takancing, deng lu sonde bisa omong apa-apa mulai sakarang, sampe deng bosong barana ame itu ana. Nanti lu lia sandiri sa. Te apa yang beta bilang ni nanti jadi, pas deng dia pung waktu.” ");
INSERT INTO mkn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Orang banya yang ada sambayang di luar, su tabingung-bingung, tagal Sakaria sonde tau kaluar-kaluar. ");
INSERT INTO mkn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Waktu dia kaluar datang, dia su sonde bisa omong apa-apa lai. Ais dia kasi sein sang dong pake tangan, ju dong mangarti bilang, Tuhan su kasi tunju sang dia satu hal yang heran dalam itu Kamar Paling Barisi. ");
INSERT INTO mkn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dong pung tugas abis, ju Sakaria pulang pi dia pung ruma. ");
INSERT INTO mkn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Sonde lama ju Elisabet dudu parú. Ju dia kurung diri dalam ruma sampe lima bulan. Dia omong bilang, “Puji Tuhan! Ahirnya Tuhan kasi tunju Dia pung hati bae sang beta. Kalo beta su dapa turunan, orang dong su sonde bekin malu sang beta lai.” ");
INSERT INTO mkn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Waktu Elisabet pung parú su jalan anam bulan, ju Tuhan Allah kirim Dia pung ana bua dari sorga, pi satu kampong di propinsi Galilea, nama Nasaret. Itu ana bua pung nama, Gabriel. ");
INSERT INTO mkn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Di Nasaret ada satu nona, nama Maria. Maria su batunangan deng satu laki-laki, nama Yusuf. Yusuf tu, raja Daud pung turunan. Naa, Gabriel pi katumu deng itu nona Maria. ");
INSERT INTO mkn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Dia kasi tunju dia pung diri sang itu nona, ju dia bilang, “Salamat, nona, ó! Tuhan Allah su pili ame sang lu, ko mau bekin satu hal bae kasi sang lu. Tuhan Allah ada sama-sama deng lu, Maria.” ");
INSERT INTO mkn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dengar bagitu, ju Maria bingung deng itu ana bua pung omong. Dia sonde mangarti dia pung maksud apa. ");
INSERT INTO mkn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ju itu ana bua sambung lai bilang, “Maria! Lu sonde usa taku. Te Tuhan Allah pung maksud kasi tunju Dia pung hati bae sang lu. ");
INSERT INTO mkn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sonde lama lai, lu su dudu parú, ais nanti lu barana ame satu ana laki-laki. Lu musti kasi nama sang Dia, Yesus. ");
INSERT INTO mkn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dia nanti jadi Orang bésar. Nanti Tuhan subu sang Dia bilang, ‘Dia tu, Beta pung Ana sandiri.’ Andia, Ana dari Tuhan Allah yang Paling Tinggi. Nanti Tuhan Allah angka sang Dia ko pegang parenta, sama ke Dia pung nene-moyang raja Daud. ");
INSERT INTO mkn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dia yang nanti pegang parenta tarús-tarús sang orang Israꞌel dong. Te Dia pung parenta sonde tau abis-abis.” ");
INSERT INTO mkn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma Maria tanya sang Gabriel bilang, “Beta ni, sonde parná tidor bakumpul deng satu laki-laki ju! Karmana ko beta bisa dudu parú?” ");
INSERT INTO mkn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ais Gabriel manyao bilang, “Bagini! Nanti Tuhan pung Roh yang Barisi datang sang lu. Deng Tuhan Allah yang Paling Tinggi pung kuasa nanti tutu ame sang lu. Deng bagitu, Ana yang nanti lu barana ame tu, batúl-batúl barisi. Te Dia tu, Tuhan Allah pung Ana. ");
INSERT INTO mkn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jang heran! Te lu pung kelu satu, nama Elisabet, su dudu parú ju. Orang bilang dia su sonde bisa barana tagal dia su tua. Ma sakarang dia pung parú su jalan anam bulan. ");
INSERT INTO mkn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Te buat Tuhan Allah, samua bisa jadi!” ");
INSERT INTO mkn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ais Maria manyao bilang, “Bae. Beta ni Tuhan Allah pung hamba. Biar ko samua jadi iko ke bapa pung omong tu. Beta sadia iko Tuhan pung mau sa.” Ais ju itu ana bua dari sorga jalan kasi tenga sang dia. ");
INSERT INTO mkn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Lewat barapa hari, ju Maria buru-buru barangkat dari Nasaret pi Sakaria pung kampong di propinsi Yudea pung daꞌera bagunung. Sampe di situ, dia maso memang di Sakaria pung ruma. Ju dia kasi salam sang Elisabet. ");
INSERT INTO mkn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Waktu Elisabet dapa dengar Maria pung salam tu, ju itu ana dalam Elisabet pung parú bakosi. Deng Tuhan pung Roh yang Barisi datang maso sang Elisabet. ");
INSERT INTO mkn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ais dia pange kasi tau bilang, “Maria! Nanti orang dong angka nae lu pung nama lebe dari samua parampuan di ini dunya! Nanti orang dong ju angka nae itu Ana yang ada di dalam lu pung parú! ");
INSERT INTO mkn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Beta ju iko taꞌangka, tagal beta pung Bos pung mama datang katumu sang beta. ");
INSERT INTO mkn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bagitu lu maso datang kasi salam sang beta, langsung beta pung ana dalam parú ju bakosi tagal sanáng. ");
INSERT INTO mkn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tuhan Allah su kasi tunju Dia pung hati bae sang lu, tagal lu parcaya bilang, Dia mau bekin iko Dia pung janji.” ");
INSERT INTO mkn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria angka suara bilang, “Dari beta pung hati yang paling dalam, beta angka nae tinggi-tinggi sang Tuhan! ");
INSERT INTO mkn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Beta pung hati babunga, tagal Tuhan Allah kasi salamat sang beta! ");
INSERT INTO mkn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dia su taro mata bae-bae sang beta, Dia pung orang suru-suru yang sonde ada pung arti ni. Mulai sakarang samua orang nanti anggap beta ni, parampuan yang paling ontong, ");
INSERT INTO mkn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tagal Tuhan bekin hal-hal heran kasi sang beta. Dia tu, yang Paling Kuasa deng Paling Barisi. ");
INSERT INTO mkn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tuhan Allah salalu kasi tunju rasa kasian sang samua orang yang hormat deng sémba sang Dia, dari turunan satu pi turunan laen. ");
INSERT INTO mkn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dia pake Dia pung kuasa, ko bekin kaco sang orang yang kapala bésar dong. ");
INSERT INTO mkn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Dia kasi jato orang yang pegang kuasa dong, tagal dong pung tinggi hati. Ma Dia angka nae orang yang randá hati dong. ");
INSERT INTO mkn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dia kasi makan orang lapar dong sampe kinyang, ma Dia usir buang orang kaya dong ko pi deng tangan kosong. ");
INSERT INTO mkn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dia tolong Dia pung orang Israꞌel dong, deng salalu tunju Dia pung rasa kasian sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Dolu Dia ika janji deng kotong pung nene-moyang, andia baꞌi Abraham deng dia pung turunan samua. Sakarang itu janji ada taꞌika tarús-tarús.” ");
INSERT INTO mkn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ais Maria tenga deng Elisabet sampe tiga bulan. Ju dia pulang pi dia pung ruma di Nasaret. ");
INSERT INTO mkn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bagitu dia pung waktu su sampe, ju Elisabet barana ame satu ana laki-laki. ");
INSERT INTO mkn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Itu kabar tasiar pi dia pung kelu deng isi kampong dong bilang, Tuhan Allah su kasi tunju Dia pung hati bae deng kasi satu ana sang Elisabet. Ju dong samua iko sanáng. ");
INSERT INTO mkn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Waktu itu ana umur dalapan hari, ju dong sunat sang dia, iko orang Yahudi pung atoran. Dong mau kasi nama itu ana, Sakaria, iko dia pung bapa pung nama. ");
INSERT INTO mkn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma dia pung mama protes bilang, “Sonde bisa bagitu! Dia pung nama, musti Yohanis!” ");
INSERT INTO mkn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma dong balas bilang, “Kanapa pili nama Yohanis? Sonde ada satu orang ju di bosong pung kelu, yang ada pake itu nama!” ");
INSERT INTO mkn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ju dong kasi sein sang Sakaria, ko mau cari tau dia mau kasi nama sapa sang itu ana. ");
INSERT INTO mkn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria sein ko minta batu tulis. Dong kasi, ais dia tulis bilang, “Dia pung nama Yohanis!” Ju samua orang taheran-heran. ");
INSERT INTO mkn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Takuju sa, ju Sakaria pung lida yang takancing tu, noe memang. Ju dia angka puji sang Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Samua orang yang tenga deka-deka di situ dong, taku deng heran. Ju itu carita tasiar dari mulu pi mulu, sampe orang di gunung-gunung di propinsi Yudea dong ju tau abis. ");
INSERT INTO mkn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Orang dong yang dengar itu carita, pikir-pikir bilang, “Su jalás, Tuhan pung kuasa ada sama-sama deng itu ana. Nanti dia bésar datang, dia jadi manusia model ke apa, ó?” ");
INSERT INTO mkn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ais ju Tuhan pung Roh yang Barisi datang maso di Sakaria. Andia ko dia omong bilang, ");
INSERT INTO mkn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Puji Tuhan, orang Israꞌel pung Allah! Te Dia su datang ko tabús ame Dia pung orang dong, ko biar dong jang sama ke budak. ");
INSERT INTO mkn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tuhan su angka ame satu Orang yang Dia pung kuasa hebat, ko nanti kasi salamat sang kotong. Dia tu, dari raja Daud pung turunan. ");
INSERT INTO mkn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tuhan su janji memang ini samua dari dolu-dolu, pake Dia pung jubir yang satia dong. ");
INSERT INTO mkn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Sakarang Dia mau kasi lapás sang kotong dari kotong pung musu-musu, deng dari orang-orang yang saki hati sang kotong. ");
INSERT INTO mkn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Dia kasi tunju Dia pung hati bae sang kotong pung nene-moyang dong, tagal Dia inga tarús Dia pung janji sang dong, yang Dia ika deng baꞌi Abraham. ");
INSERT INTO mkn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Dia su kasi lapás sang kotong dari kotong pung musu dong, ko kotong bisa sémba sang Dia, deng sonde parlú taku-taku lai. ");
INSERT INTO mkn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Dia su kasi lapás sang kotong, ko biar kotong bisa idop barisi deng lurus tarús-tarús di Dia pung muka. ");
INSERT INTO mkn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Anis! Lu ni, beta pung ana. Orang nanti kanál sang lu bilang, lu ni, Tuhan Allah yang Paling Tinggi pung jubir. Lu nanti pi kasi tau orang dong, ko dong buka tangan tarima Bos pung datang. ");
INSERT INTO mkn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Lu nanti pi kasi tunju jalan sang Tuhan pung orang dong, ko dong dapa tau bilang, dong dapa salamat, tagal Tuhan hapus buang dong pung sala-sala dong. ");
INSERT INTO mkn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Tagal Tuhan pung hati noe deng kasian sang kotong, andia ko Dia kasi kotong kasampatan baru, sama ke hari baru bawa taráng yang baru. Kotong yang jalan dalam galáp, deng kotong yang taku mati, tagal balóm babae deng Tuhan, nanti dapa taráng ko antar sang kotong pi jalan dame.” ");
INSERT INTO mkn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ais ju Yohanis tamba hari, tamba bésar. Deng Tuhan pung Roh bekin kuat sang dia. Dia bésar datang, ju dia pi tenga di tampa sunyi, sampe dia mulai angka dia pung karjá kasi orang Israꞌel dong. ");
INSERT INTO mkn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Satu kali, waktu Kirenius jadi kapala daꞌera di Siria, ais raja bésar, nama Agustus, kasi kaluar parenta bilang, “Samua orang yang di bawa pamarenta Roma pung kuasa musti pulang kampong ko iko sensus!” Itu kali partama ko pamarenta Roma itong dia pung rakyat bagitu. ");
INSERT INTO mkn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jadi samua orang pulang kampong ko iko sensus. ");
INSERT INTO mkn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Naa, itu waktu, Yusuf tenga di kampong Nasaret di propinsi Galilea. Dia su batunangan deng satu nona, nama Maria, yang ada dudu parú. Yusuf tu, raja Daud pung turunan, jadi dia musti pulang pi Daud pung kota Betlehem di propinsi Yudea ko iko sensus. Andia ko dong dua barangkat pi kota Betlehem. ");
INSERT INTO mkn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Waktu dong su ada di sana, Maria pung waktu mau barana su sampe. ");
INSERT INTO mkn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma di situ, dong sonde dapa kamar di losmen. Andia ko dong maso pi dalam kandang. Ais ju dia barana Ana partama, Ana laki-laki. Ju dong bungkus sang Dia deng kaen, ko kasi tidor dalam binatang dong pung tampa makan. ");
INSERT INTO mkn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Itu malam, ada gambala barapa orang yang mete jaga dong pung kambing-domba di padang di luar kota. ");
INSERT INTO mkn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Takuju sa, dong dapa lia Tuhan Allah pung ana bua dari sorga. Ais Tuhan pung taráng bacaya kuliling sang dong, ju dong taku mau mati. ");
INSERT INTO mkn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma itu ana bua kasi tau bilang, “Bosong jang taku dolo! Dengar bae-bae, é! Te beta ni, datang mau kasi tau satu kabar bae kasi bosong. Samua yang dengar ini kabar, pasti sanáng. ");
INSERT INTO mkn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ini kabar bae pung isi bagini: Ini hari satu mama su barana sang Kristus di Betlehem, di raja Daud pung kota. Kristus tu, Orang yang Tuhan Allah su janji memang dari dolu. Tuhan kirim datang sang Dia ko kasi salamat orang dari dong pung sala-sala! Dia ni, yang nanti orang dong pange, ‘Bos’, te Dia yang hak parenta samua! ");
INSERT INTO mkn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nanti bosong dapa kanál sang Dia bagini: bosong katumu satu Ana mea yang ada tabungkus deng kaen. Dia ada tidor dalam binatang dong pung tampa makan.” ");
INSERT INTO mkn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Itu ana bua omong abis ju, takuju sa, Tuhan Allah pung ana bua yang laen dong dari sorga datang bam-banya ko bakumpul deng dia. Ju dong puji Tuhan Allah deng manyanyi bilang, ");
INSERT INTO mkn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Botong angka nae tinggi-tinggi Tuhan Allah pung nama! Dia yang dudu parenta di langit yang paling tinggi. Tuhan Allah mau kasi dame sang orang di bumi, yang bekin sanáng Dia pung hati!” ");
INSERT INTO mkn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ais ju Tuhan pung ana bua dong pulang kambali pi sorga. Ju itu gambala dong baꞌomong bilang, “We! Mari kotong pi Betlehem ko pi lia itu Ana dolo! Te Tuhan su kirim itu kabar kasi kotong.” ");
INSERT INTO mkn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ais dong jalan capát-capát pi Betlehem. Ju dong katumu sang Maria deng Yusuf. Dong ju dapa lia itu Ana mea, yang ada tidor dalam binatang pung tampa makan. ");
INSERT INTO mkn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Waktu dong dapa lia itu Ana, ju dong carita bilang, “Tadi Tuhan Allah pung ana bua dari sorga dong su kasi tau soꞌal ini Ana sang botong!” Ju dong carita samua sampe abis. ");
INSERT INTO mkn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Samua orang taheran-heran dengar itu gambala dong pung carita. ");
INSERT INTO mkn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Maria taro dalam dia pung hati samua yang su jadi tu. Deng dia pikir diam-diam ko mau cari tau dia pung arti bilang apa. ");
INSERT INTO mkn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ais ju itu gambala dong bale pi dong pung kambing-domba dong. Ju dong angka nae tinggi-tinggi Tuhan Allah pung nama. Dong minta tarima kasi sang Dia, tagal yang dong dengar deng lia, sama parsís ke apa yang Tuhan pung ana bua su omong tu. ");
INSERT INTO mkn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Barana abis dalapan hari, ju dong sunat itu Ana mea iko baꞌi Musa pung atoran. Ju Dia pung mama-bapa kasi nama sang Dia, ‘Yesus’. Itu nama tu, nama yang ana bua dari sorga su kasi tau sang dong, waktu Dia pung mama balóm dudu parú sang Dia. ");
INSERT INTO mkn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ada satu atoran dari baꞌi Musa yang bilang, parampuan yang su barana abis ampa pulu hari, musti pi bekin iko adat kasi barisi diri di Ruma Sambayang Pusat. Deng bagitu, dong su bisa maso di ruma sambayang sama ke biasa. Andia ko Yusuf deng Maria pi kota Yerusalem, ko mau bekin iko itu adat. Ju dong bawa dong pung Ana mea tu pi dalam Ruma Sambayang Pusat, ko sarakan sang Dia jadi Tuhan pung milik. ");
INSERT INTO mkn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dong iko Tuhan pung atoran yang bilang, “Tiap parampuan yang barana ana partama, kalo laki-laki, na, dia musti sarakan itu ana jadi Tuhan pung milik.” ");
INSERT INTO mkn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iko Tuhan pung atoran, kalo sarakan itu ana sang Tuhan, na, dia pung orang tua musti kasi korban burung takukur satu pasang, ko, burung pompa muda dua ekor. Andia ko Yusuf deng Maria ju bekin iko itu atoran. ");
INSERT INTO mkn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Itu waktu, ada satu baꞌi tua, nama Simeon, yang tenga di kota Yerusalem. Dia tu, orang yang hati lurus deng rindu sang Tuhan. Tuhan pung Roh yang Barisi su kasi tau sang dia bilang, dia nanti dapa lia sang Kristus dolo, baru dia mati. Kristus tu, yang nanti kasi salamat sang orang Israꞌel dong. ");
INSERT INTO mkn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Itu waktu, Tuhan pung Roh antar bawa sang Simeon pi Ruma Sambayang Pusat. Itu pas deng Yesus pung mama-bapa ada bawa sang Dia pi situ, ko sarakan sang Dia jadi Tuhan pung milik. ");
INSERT INTO mkn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Lia ame itu Ana, ais baꞌi Simeon koko ame sang Dia, ju dia angka puji kasi Tuhan Allah bilang, ");
INSERT INTO mkn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Puji Tuhan! Tuhan su bekin iko Dia pung janji sang beta. Jadi sakarang Tuhan su bisa kasi lapás sang beta, ko biar beta bisa mati deng tanáng, ");
INSERT INTO mkn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","te beta su lia ame Orang yang Tuhan kirim datang, ko kasi salamat sang botong dari botong pung sala-sala dong! ");
INSERT INTO mkn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tuhan mau pake ini Ana ko kasi salamat samua suku-bangsa. ");
INSERT INTO mkn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Dia nanti sama ke cahaya, yang bawa hormat kasi Tuhan pung bangsa Israꞌel dong. Dia ju sama ke taráng, yang kasi tunju Tuhan pung jalan kasi samua suku-bangsa laen dong.” ");
INSERT INTO mkn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dengar bagitu, ju Yusuf deng Maria taheran-heran deng apa yang baꞌi Simeon omong soꞌal dong pung Ana. ");
INSERT INTO mkn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ais itu, Simeon omong kasi berkat sang dong. Tarús dia kasi tau sang Maria bilang, “Yesus pung mama, é! Nanti banya orang di Israꞌel tola buang mama pung Ana ni. Ma dong pung bekin-bekin sang Dia tu, nanti kasi jato bale sang dong. Mama pung Ana ni, ju bekin banya orang dong hati babunga. ");
INSERT INTO mkn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Deng bagitu, nanti Tuhan buka talanjang orang dong pung isi hati. Ma lu, Maria, nanti lu dapa sangsara barát, sama ke kalewang tikam maso di lu pung ulu hati.” ");
INSERT INTO mkn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Di Ruma Sambayang Pusat ju ada satu nene, nama Hana. Dia pung umur su 84 taon. Dia pung bapa, nama Fanuel, dari suku Aser. Dia kawin tuju taon, ju dia pung laki mati kasi tenga sang dia. Nene Hana tu, Tuhan Allah pung jubir. Dia pung karjá, andia sambayang deng puasa di Ruma Sambayang Pusat, ko sémba sang Tuhan Allah siang-malam. ");
INSERT INTO mkn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Waktu Simeon ada baꞌomong deng Yusuf deng Maria, itu nene datang deka-deka. Ju dia dengar sang dong, ais dia angka puji-puji sang Tuhan Allah. Tarús dia omong soꞌal Yesus kasi samua orang yang ada tunggu-tunggu Raja yang Tuhan su janji mau kirim datang ko kasi bebas bangsa Israꞌel. ");
INSERT INTO mkn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Waktu Yusuf deng Maria su bekin iko baꞌi Musa pung atoran samua di kota Yerusalem, ju dong pulang pi propinsi Galilea, di dong pung kampong Nasaret. ");
INSERT INTO mkn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ju Yesus bésar datang. Ais Dia tamba kuat, tamba pintar, deng mangarti banya hal. Tuhan Allah ju kasi tunju hati bae sang Dia. ");
INSERT INTO mkn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tiap taon, Yusuf deng Maria jalan pi kota Yerusalem, ko makan pesta Paska di situ. ");
INSERT INTO mkn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Satu kali, waktu Yesus pung umur dua blas taon, ju dong jalan sama-sama pi Yerusalem ko iko itu pesta sama ke biasa. ");
INSERT INTO mkn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Waktu hari-hari Paska su abis, ju Yusuf deng Maria mulai jalan pulang pi Nasaret sama-sama deng banya orang yang mau pulang pi Galilea. Ma dong sonde tau, Yesus ada tatenga di Yerusalem. Dong sangka Dia ada jalan sama-sama deng Dia pung tamán dong. Ma sampe sore, dong sonde dapa lia sang Dia. Ais dong mulai pal pi-datang cari sang Dia di dong pung kelu deng tamán dong. ");
INSERT INTO mkn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tagal sonde tau-tau dapa katumu sang Dia, ju dong jalan kambali pi Yerusalem, ko mau cari sang Dia di sana. ");
INSERT INTO mkn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sampe di sana, dong cari-cari sang Dia sampe tiga hari, baru dapa katumu sang Dia dalam Ruma Sambayang Pusat. Dia ada dudu basoꞌal-jawab deng guru agama Yahudi dong. ");
INSERT INTO mkn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Orang dong samua yang ada dengar sang dong taheran-heran, tagal Dia batúl-batúl mangarti isi dari Tuhan Allah pung Tulisan Barisi, deng Dia bisa jawab dong pung soꞌal-soꞌal deng bae. ");
INSERT INTO mkn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lia bagitu, ju Dia pung mama-bapa dong heran. Ais Dia pung mama bilang, “Yesus! Akurang ko Lu bekin botong susa bagini? Lu pung bapa deng beta su tabingung-bingung bataputar pi-datang cari sang Lu!” ");
INSERT INTO mkn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma Yesus manyao bilang, “Akurang ko mama-bapa susa-susa cari sang Beta? Tau sa, to? Beta ada urusan di Beta pung Bapa pung Ruma.” ");
INSERT INTO mkn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma dong sonde mangarti batúl Dia pung maksud. ");
INSERT INTO mkn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ais ju dong samua pulang pi Nasaret. Yesus iko Dia pung mama deng bapa pung parenta dong. Ju Dia pung mama taro itu hal dong samua dalam dia pung hati. ");
INSERT INTO mkn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bagitu su, Yesus tamba dewasa, deng tamba pintar bawa diri. Tuhan Allah deng manusia ju ada sayang sang Dia. ");
INSERT INTO mkn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Itu waktu, Tiberius jadi keser yang pegang parenta di Roma su lima blas taon. Pontius Pilatus jadi gubernor di propinsi Yudea. Herodes jadi gubernor di propinsi Galilea. Herodes pung kaka Filipus jadi gubernor di propinsi Iturea deng propinsi Trakonitis. Deng Lisanias jadi gubernor di propinsi Abilene. Itu waktu ju, Hanas deng Kayafas jadi kapala agama Yahudi pung bos bésar di kota Yerusalem. Itu waktu, Yohanis, Sakaria pung ana tu, ada tenga di tampa sunyi yang jao dari kampong. Di situ, Tuhan kasi pasán sang dia. ");
INSERT INTO mkn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Dengar abis, ju Yohanis jalan pi samua kampong yang deka-deka deng kali Yarden, ko kasi tau orang dong bilang, “Bosong musti mangaku deng kasi tenga bosong pung sala samua, ko biar Tuhan Allah hapus buang itu sala dong. Ais bosong musti sarani dolo, ko jadi tanda bilang, bosong su babae deng Tuhan.” ");
INSERT INTO mkn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dolu-dolu Tuhan pung jubir baꞌi Yesaya ada tulis soꞌal Yohanis ni bilang, “Ada orang di tampa sunyi yang batarea bilang, ‘Samua orang siap-siap bekin bae jalan, ko tarima Tuhan pung datang! Bekin lurus jalan ko sambut sang Dia. ");
INSERT INTO mkn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tutu bekin rata tiap jurang. Puku bekin rata tiap gunung. Bekin lurus jalan bengko dong, bekin licin jalan kasar dong. ");
INSERT INTO mkn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Biar ko orang dari samua suku-bangsa bisa dapa tau bilang, Tuhan mau kasi salamat orang dari dong pung sala-sala.’ ” ");
INSERT INTO mkn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Orang banya datang dari mana-mana ko minta Yohanis sarani sang dong. Ma dia masparak sang dong bilang, “Weh! Bosong tukang putar-balek! Bosong sama ke ular baracon sa! Jang kira bosong bisa talapás dari Tuhan pung hukuman deng tobat pura-pura sa! Sonde! Tar lama lai, Tuhan kasi hukum samua orang yang sonde tobat batúl. ");
INSERT INTO mkn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bosong jang pikir bilang, ‘Beta ni sonde kaná hukum tagal beta ni, baꞌi Abraham pung turunan.’ Dapa di mana bagitu? Itu sonde bisa bantu bosong, tagal sonde bekin bosong jadi orang barisi. Tuhan mampu bekin ini batu dong ko jadi baꞌi Abraham pung turunan. Beta kasi tau, é! Kasi tunju deng bosong pung idop bilang, bosong su bale balakang kasi tenga bosong pung sala dong, deng bosong su bale iko sang Tuhan. ");
INSERT INTO mkn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bosong musti bekin hal yang bae. Kalo sonde, Tuhan pung hukum barát jato kaná sang bosong, sama ke orang pake kapak ko potong buang pohon dari dia pung akar. Bagitu su! Pohon sonde ada pung guna, kalo dia sonde ada pung hasil bae! Jadi lebe bae potong sang dia, ais lempar buang pi dalam api.” ");
INSERT INTO mkn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ais, itu orang banya dong tanya sang Yohanis bilang, “Jadi botong musti bekin apa?” ");
INSERT INTO mkn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ju dia manyao bilang, “Kalo lu ada pung baju dua, na, kasi satu di orang yang sonde ada pung baju. Kalo lu ada pung makanan, na, bagi kasi sang orang yang sonde ada pung makanan.” ");
INSERT INTO mkn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ais tukang tagi bea ju datang ko minta Yohanis sarani sang dong. Dong tanya bilang, “Bapa guru! Botong musti bekin karmana?” ");
INSERT INTO mkn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Dia manyao bilang, “Bosong suka maen putar-balek. Ma sakarang bosong musti karjá jujur. Jang hela pajak lebe-lebe dari pamarenta pung atoran. Biar ko rakyat bayar pajak pas-pas deng atoran.” ");
INSERT INTO mkn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ada ju barapa tantara di situ. Dong tanya sang Yohanis bilang, “Kalo botong, karmana? Botong musti bekin apa?” Ais dia manyao bilang, “Jang maen bapajak orang dong pung doi, iko bosong pung suka. Deng jang maen batudu orang sambarang. Bosong musti sukur deng puas tarima barisi bosong pung gaji.” ");
INSERT INTO mkn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dengar dia pung omong tu, ju samua orang mulai bakorek ko bakusu-kusu bilang, “Awii! Jang-jang Yohanis ni, Kristus, yang Tuhan su janji mau kirim datang dari dolu tu!” ");
INSERT INTO mkn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma Yohanis togor sang dong bilang, “Dengar bae-bae! Nanti ada satu Orang yang lebe hebat dari beta mau datang. Biar cuma jadi Dia pung tukang suru-suru sa, ju beta sonde pantas. Beta cuma bisa sarani sang bosong pake aer sa, ma nanti Dia bekin lebe dari beta, te Dia bekin ponu bosong pung hati deng Tuhan pung Roh yang Barisi. Dia nanti bekin barisi sang bosong, sama ke orang pake api ko bakar buang kotoran. ");
INSERT INTO mkn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dia hukum orang yang bekin sala dong, sama ke orang tani yang pake angin ko pisa buang kotoran dari padi. Ais dia simpan padi yang barisi dalam sokal, ma bakar buang dia pung kotoran. Bagitu ju, nanti Kristus hukum orang yang bekin sala dong, deng lempar buang sang dong pi dalam api yang sonde tau putus-putus.” ");
INSERT INTO mkn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Deng bagitu, Yohanis kasi inga orang macam-macam hal, deng kasi tau Tuhan pung Kabar Bae sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Itu waktu, Yohanis ju mulai omong taráng-taráng soꞌal Herodes pung bekin-bekin. Dia pung parkara bagini: Herodes tu, gubernor di propinsi Galilea. Dia pung sala su satu malꞌunuk pung. Conto ke dia su rampas bawa dia pung adi pung bini, nama Herodias. Padahal dia pung adi masi idop, deng balóm bacere deng Herodias. Herodes pung cara idop yang sonde batúl tu, bekin Yohanis togor sang dia taráng-taráng, sampe Herodes doak sang dia. Ais Herodes tangkap ame sang dia, ju lempar buang sang dia pi dalam bui. ");
INSERT INTO mkn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dulu waktu dong balóm tangkap sang Yohanis, dia ada sarani orang banya. Deng dia ju sarani sang Yesus. Ais itu Yesus sambayang, ju langit tabuka. ");
INSERT INTO mkn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tarús Tuhan pung Roh yang Barisi turun datang pi Dia. Itu Roh pung rupa sama ke burung pompa. Ju ada suara dari langit bilang, “Lu ni, Beta pung Ana sayang. Lu salalu bekin sanáng sang Beta.” ");
INSERT INTO mkn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Waktu Yesus mulai kasi tau orang soꞌal Tuhan pung jalan idop, Dia pung umur kira-kira tiga pulu taon. Orang kanál bilang, Yesus tu, Yusuf pung Ana. Yusuf pung nene-moyang dong, andia: Yusuf pung bapa, Eli. ");
INSERT INTO mkn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli pung bapa, Matat. Matat pung bapa, Lewi. Lewi pung bapa, Melki. Melki pung bapa, Yanai. Yanai pung bapa, Yusuf. ");
INSERT INTO mkn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf pung bapa, Matatias. Matatias pung bapa, Amos. Amos pung bapa, Nahum. Nahum pung bapa, Hesli. Hesli pung bapa, Nagai. ");
INSERT INTO mkn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai pung bapa, Maat. Maat pung bapa, Matatias. Matatias pung bapa, Semein. Semein pung bapa, Yosek. Yosek pung bapa, Yoda. ");
INSERT INTO mkn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda pung bapa, Yohanan. Yohanan pung bapa, Resa. Resa pung bapa, Serubabel. Serubabel pung bapa, Sealtiel. Sealtiel pung bapa, Neri. ");
INSERT INTO mkn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri pung bapa, Melki. Melki pung bapa, Adi. Adi pung bapa, Kosam. Kosam pung bapa, Elmadam. Elmadam pung bapa, Er. ");
INSERT INTO mkn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er pung bapa, Yosua. Yosua pung bapa, Elieser. Elieser pung bapa, Yorim. Yorim pung bapa, Matat. Matat pung bapa, Lewi. ");
INSERT INTO mkn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi pung bapa, Simeon. Simeon pung bapa, Yahuda. Yahuda pung bapa, Yusuf. Yusuf pung bapa, Yonam. Yonam pung bapa, Elyakim. ");
INSERT INTO mkn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim pung bapa, Melea. Melea pung bapa, Mena. Mena pung bapa, Matata. Matata pung bapa, Natan. Natan pung bapa, Daud. ");
INSERT INTO mkn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud pung bapa, Isai. Isai pung bapa, Obet. Obet pung bapa, Boas. Boas pung bapa, Salmon. Salmon pung bapa, Nahason. ");
INSERT INTO mkn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason pung bapa, Aminadab. Aminadab pung bapa, Admin. Admin pung bapa, Arni. Arni pung bapa, Hesron. Hesron pung bapa, Peres. Peres pung bapa, Yahuda. ");
INSERT INTO mkn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda pung bapa, Yakob. Yakob pung bapa, Isak. Isak pung bapa, Abraham. Abraham pung bapa, Tera. Tera pung bapa, Nahor. ");
INSERT INTO mkn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor pung bapa, Seruk. Seruk pung bapa, Rehu. Rehu pung bapa, Pelek. Pelek pung bapa, Eber. Eber pung bapa, Sela. ");
INSERT INTO mkn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela pung bapa, Kenan. Kenan pung bapa, Arpaksad. Arpaksad pung bapa, Sem. Sem pung bapa, Noh. Noh pung bapa, Lamek. ");
INSERT INTO mkn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek pung bapa, Metusalak. Metusalak pung bapa, Henok. Henok pung bapa, Yared. Yared pung bapa, Mahalalel. Mahalalel pung bapa, Kenan. ");
INSERT INTO mkn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan pung bapa, Enos. Enos pung bapa, Set. Set pung bapa, Adam. Adam tu, Tuhan Allah pung ana ciptaꞌan. ");
INSERT INTO mkn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Waktu Yohanis sarani abis sang Yesus, ju Yesus jalan kasi tenga kali Yarden. Tuhan pung Roh yang Barisi ada sama-sama deng Dia. Ais, itu Roh bawa sang Dia pi tampa sunyi. ");
INSERT INTO mkn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus tenga di situ sampe ampa pulu hari. Itu waktu ju Dia sonde makan apa-apa, sampe Dia lapar mati pung. Ju setan dong pung bos datang coba hiki sang Dia. ");
INSERT INTO mkn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dia omong sang Yesus bilang, “Kalo Lu memang Tuhan Allah pung Ana, Lu ada pung kuasa. Jadi suru ini batu dong jadi roti, ko Lu makan sang dong.” ");
INSERT INTO mkn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma Yesus manyao bilang, “Lu pung mau lai! Sonde tau, ko? Ada tulis dalam Tuhan Allah pung Tulisan Barisi bilang, ‘Manusia bukan cuma idop dari makanan toꞌ!’ ” ");
INSERT INTO mkn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Ais itu, setan dong pung bos bawa sang Dia pi satu tampa tinggi, ju kasi tunju abis sang Dia samua pamarenta di bumi deng dong pung hebat samua. Ais dia kokoe sang Yesus bilang, “Samua pamarenta deng dong pung kuasa tu, beta pung samua. Bagitu ju deng dia pung hebat samua! Jadi beta ada pung hak mau kasi sapa sa yang beta suka. ");
INSERT INTO mkn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Beta mau kasi samua sang Lu. Cuma Lu musti bekin satu hal dolo, baru beta kasi. Gampang sa! Lu cuma sémba sang beta. Itu sa!” ");
INSERT INTO mkn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Yesus manyao bale bilang, “Dapa di mana bagitu? Te dalam Tuhan Allah pung Tulisan Barisi ada tulis bilang, ‘Lu musti sémba sang Tuhan Allah sa. Deng lu musti layani ame sang Dia sa.’ ” ");
INSERT INTO mkn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ais itu, setan dong pung bos ame bawa sang Yesus pi kota Yerusalem. Di situ, dia bawa nae sang Yesus pi Ruma Sambayang Pusat pung tampa paling tinggi. Ais dia bilang, “Kalo Lu memang Tuhan Allah pung Ana, na, Lu buang diri pi bawa su! ");
INSERT INTO mkn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Te ada tulis di Tuhan Allah pung Tulisan Barisi bilang, ‘Tuhan Allah nanti suru Dia pung ana bua dari sorga, ko jaga ame sang Lu. ");
INSERT INTO mkn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nanti dong datang tada sang Lu, ko biar Lu pung kaki sonde tasonto sadiki ju di batu.’ ” ");
INSERT INTO mkn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma Yesus manyao bilang, “Jang maen paricuk deng Beta. Te ada tulis dalam Tuhan Allah pung Tulisan Barisi bilang, ‘Jang coba Tuhan Allah!’ ” ");
INSERT INTO mkn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setan dong pung bos coba sang Yesus deng jalan macam-macam, ma sonde dapa ontong sang Dia. Ais dia jalan kasi tenga sang Yesus, ko tunggu waktu yang bae. ");
INSERT INTO mkn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ais itu, ju Yesus kambali lai pi propinsi Galilea, te Tuhan pung Roh yang Barisi ada kasi kuasa sang Dia. Sonde lama, ju orang di itu daꞌera dong mulai kanál Dia pung nama. ");
INSERT INTO mkn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dia ajar di orang Yahudi pung ruma sambayang di mana-mana. Ju orang-orang puji sang Dia bilang, “Yesus tu, Orang hebat, ó!” ");
INSERT INTO mkn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Satu kali, Yesus datang di Dia pung kampong Nasaret. Pas deng orang Yahudi dong pung hari sambayang, andia ‘hari Sabat’, Dia maso pi ruma sambayang, sama ke Dia pung biasa. Ais Dia bangun badiri ko mau baca dari Tuhan Allah pung Tulisan Barisi. ");
INSERT INTO mkn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ju dong sorong kasi sang Dia baꞌi Yesaya pung tulisan. Tarús Dia buka, ais cari ayat, ju baca bilang, ");
INSERT INTO mkn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tuhan Allah pung Roh pung kuasa ada di Beta. Andia ko Dia tunju sang Beta, ko kasi tau Tuhan pung Kabar Bae sang orang kasian dong. Dia su utus sang Beta, ko kasi tau bilang, yang di bui dong, nanti bebas; yang buta dong, nanti bisa lia kambali; yang kaná tendes dong, nanti idop bebas. ");
INSERT INTO mkn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Te sakarang ni, Tuhan pung waktu su sampe, ko kasi salamat Dia pung orang dong.” ");
INSERT INTO mkn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Baca abis itu tulisan, ju Yesus gulung kambali ko sorong pi pamimpin ibadat, tarús Dia dudu. Samua orang yang ada dalam itu ruma sambayang lia tarús sang Dia. ");
INSERT INTO mkn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ais Dia kasi tau sang dong bilang, “Apa yang bosong dengar dari Tuhan Allah pung Tulisan Barisi tadi tu, sakarang su jadi!” ");
INSERT INTO mkn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ju samua orang yang ada di situ mulai omong angka-angka sang Yesus bilang, “Awii! Apa yang Dia omong tadi tu, pung bagus lai! Ma Dia ni, Usu pung Ana, wuang? Karmana ko bisa bagini?” ");
INSERT INTO mkn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ju Yesus kasi tau sang dong bilang, “Tantu bosong samua tau ada bahasa kata, ‘We, dokter! Bekin bae lu pung diri sandiri dolo!’ Bosong ada mau pake itu bahasa ko puku bale sang Beta bilang, ‘Akurang ko Lu sonde bekin tanda heran satu kasi botong di sini, sama ke yang Lu su bekin di kota Kapernaum sana?’ ");
INSERT INTO mkn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dia pung batúl bagini: orang sonde mau tarima sang Tuhan pung jubir di dia pung kampong sandiri. ");
INSERT INTO mkn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Ame conto dari Tuhan pung jubir, baꞌi Elia. Satu kali, ujan su sonde turun tiga taon satenga. Itu waktu, ada banya janda di Israꞌel. Ma Tuhan sonde kirim Elia ko tolong sang dong di Israꞌel. Tuhan cuma kirim sang dia pi satu mama janda di kampong Sarfat deka deng kota Sidon. Padahal mamatua tu, bukan orang Yahudi. Ma dia parcaya Tuhan Allah pung kuasa. ");
INSERT INTO mkn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ame conto laen lai dari Tuhan pung jubir Elisa. Itu waktu, ada banya orang Yahudi yang saki kusta di Israꞌel. Ma Tuhan sonde bekin bae sang dong. Tuhan cuma suru Elisa bekin bae satu orang kusta, nama Naaman. Padahal dia tu, orang Siria, bukan orang Yahudi. Ma dia parcaya Tuhan Allah pung kuasa.” ");
INSERT INTO mkn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Waktu dong dengar Yesus pung omong bagitu, ju dong samua maruak sang Dia. ");
INSERT INTO mkn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ais dong bangun rame-rame, ju usir buang sang Dia dari itu ruma sambayang. Tarús dong hela bawa sang Dia pi kampong pung pinggir, ko mau tola buang sang Dia pi dalam jurang di situ. ");
INSERT INTO mkn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma Dia cuma jalan kaluar lewat itu orang banya dong pung teng-tenga, abis kasi tenga sang dong di situ. ");
INSERT INTO mkn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ais itu, Yesus turun pi kota Kapernaum di dano Galilea pung pinggir. Tiap hari sambayang Dia ajar orang dong dalam ruma sambayang. ");
INSERT INTO mkn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Orang dong taheran-heran dengar Dia pung omong, te Dia tau batúl itu ajaran pung isi. ");
INSERT INTO mkn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Satu kali, waktu Yesus ada mangajar di itu ruma sambayang, ada satu orang yang takaná setan mulai batarea ukur kuat pung bilang, ");
INSERT INTO mkn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Woi! Yesus, Orang Nasaret! Lu ada pung urusan apa deng botong! Lu datang ko mau bekin ancor sang botong, ko? Botong kanál sang Lu. Lu ni, itu Orang Barisi yang dolu Tuhan Allah janji ko mau kirim datang.” ");
INSERT INTO mkn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma Yesus masparak sang dia bilang, “Tutu lu pung mulu! Kaluar dari itu orang!” Takuju sa, itu setan angka banting itu orang di lante di orang dong pung teng-tenga. Banting abis, ju itu setan kaluar kasi tenga itu orang, deng sonde bekin saki sang dia. ");
INSERT INTO mkn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Orang dong samua tanganga bilang, “Heran, é! Ini Orang pung omong tu, ada kuasa hebat! Sampe-sampe setan dong ju iko Dia pung parenta ko kaluar dari orang!” ");
INSERT INTO mkn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ais carita soꞌal Yesus mulai tasiar di itu daꞌera samua. ");
INSERT INTO mkn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Waktu dong kaluar dari itu ruma sambayang ju, Yesus pi satu orang pung ruma. Itu orang pung nama, Simon. Simon pung mama mantu ada saki damám, jadi dia pung badan ada panas tinggi. Ais dong minta sang Yesus bilang, “Bapa! Tolong bekin bae sang mamatua dolo!” ");
INSERT INTO mkn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus pi badiri di pinggir koi, ais usir kaluar itu damám dari mamatua. Itu saꞌat ju, dia pung damám ilang memang. Ais ju dia bangun memang ko pi sadia makan kasi sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Itu sore, waktu matahari su mulai tanggalám, orang dong bawa datang samua orang saki pi sang Yesus. Dong pung panyaki macam-macam. Ais Dia taro tangan di orang saki dong, ju bekin bae sang dong samua. ");
INSERT INTO mkn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Di itu orang saki dong ju, ada barapa yang takaná setan. Ais Yesus parenta sang setan dong ko kaluar dari itu orang dong. Dong kaluar deng batarea bilang, “Lu ni, Tuhan Allah pung Ana!” Te itu setan dong tau bilang, Dia tu, Kristus, yang Tuhan Allah su janji dari dolu ko mau kirim datang. Tagal itu, Yesus togor sang dong ko sonde bole baꞌomong satu kata ju soꞌal Dia pung diri. ");
INSERT INTO mkn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Dia pung beso amper siang, ju Yesus bangun ko pi satu tampa sunyi di luar kota. Orang dong cari sang Dia di mana-mana. Waktu katumu, ju dong noki sang Dia bilang, “Bapa tenga deng botong sa! Sonde usa jalan pi tampa laen!” ");
INSERT INTO mkn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma Dia manyao bilang, “Beta ju musti pi kampong laen dong, ko pi kasi tau Kabar Bae soꞌal Tuhan Allah pung parenta. Te Tuhan su utus sang Beta ko kasi jalan itu tugas.” ");
INSERT INTO mkn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ju Dia jalan dari satu kampong pi kampong laen ko mangajar di ruma-ruma sambayang di propinsi Yudea. ");
INSERT INTO mkn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Satu kali, Yesus ajar orang dong di dano Galilea pung pinggir. Banya orang datang ko mau dengar Tuhan Allah pung Kata-kata. Sampe-sampe dong baseti makarubu ame sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Deka-deka di situ, ada nalayan yang bekin barisi dong pung pukat di darat. Ju Yesus dapa lia dua parahu kosong ada sandar di situ. ");
INSERT INTO mkn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Satu dari itu parahu dong, andia Simon pung. Ais Yesus nae pi Simon pung parahu, ju minta sang dia ko tola itu parahu pi aer dalam sadiki. Tarús Dia dudu ko ajar itu orang banya dong. ");
INSERT INTO mkn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ajar abis, ju Dia omong sang Simon bilang, “Mon! Pi tampa yang sadiki dalam ko kasi turun pukat di situ. Te nanti bosong dapa ikan banya.” ");
INSERT INTO mkn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma Simon manyao bilang, “Bos lai ju! Botong su karjá banting tulang satu malam anteru, ma satu ekor ju, botong sonde dapa! Ma tagal Bapa su bilang bagitu, na, neu sa! Beta coba kasi turun sa.” ");
INSERT INTO mkn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ais dong kasi turun pukat. Waktu mau hela kasi nae kambali, tau-tau te itu pukat su ponu deng ikan satu malꞌunuk, sampe-sampe pukat su mulai tarobe. ");
INSERT INTO mkn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ju Simon batarea pange dia pung kawan dong dari parahu laen ko datang bantu. Ais dong raꞌu kasi maso ikan di parahu, sampe itu dua parahu ponu deng ikan ko su amper tanggalám. ");
INSERT INTO mkn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Simon pung kawan nalayan, Yakobis deng Yohanis, andia bapa Sabadeus pung ana-ana dong, ju ada. Dong ju heran mau mati, tagal dong dapa ikan bam-banya bagitu. Waktu Simon Petrus lia apa yang su jadi, ju dia langsung tikam lutut di Yesus pung muka bilang, “Beta ni, satu orang yang su bekin sala talalu banya. Jadi lebe bae Bos jang deka-deka sang beta lai.” Ma Yesus manyao bilang, “Mon! Jang talalu bapikir itu soꞌal, te Beta ada mau pake sang bosong. Bosong ni, biasa cari ikan. Ma sakarang Beta ajar bosong cari orang ko iko sang Beta.” ");
INSERT INTO mkn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ais ju dong langsung hela dong pung parahu ko simpan di darat. Ju dong jalan kasi tenga samua-samua, ko iko sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Di satu kampong, Yesus dapa katumu sang satu orang yang dia pung badan su ponu deng panyaki kusta. Waktu dia dapa lia sang Yesus, ju dia pi tikam lutut deng tondo dia pung muka sampe di tana. Ju dia bilang, “Bapa, é! Tolong beta dolo! Te beta tau, Bapa bisa kasi ilang beta pung panyaki ni, ko biar orang jang noju lai sang beta. Asal Bapa mau.” ");
INSERT INTO mkn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ais Yesus sorong tangan ko raba sang dia. Ju Dia omong bilang, “Beta mau sa! Lu bae su!” Omong abis, te itu orang pung kusta ilang buang memang. ");
INSERT INTO mkn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ju Yesus kasi inga sang dia bilang, “Inga bae-bae! Lu su bae, ma sonde bole kasi tau sapa-sapa, é! Lu musti iko baꞌi Musa pung parenta dolu. Jadi pi di kapala agama, ko dia pareksa lu pung badan, biar dia tau lu pung panyaki su ilang batúl, ko sonde. Ais lu musti kasi persembahan tanda tarima kasi, ko orang samua tau bilang, lu su bae batúl.” ");
INSERT INTO mkn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Biar Yesus larang, ma itu carita soꞌal Dia pung kuasa tu, tasiar dari mulu pi mulu pi mana-mana. Jadi orang dong maen malele datang ko mau dengar Dia ajar sang dong. Ais Dia bekin bae banya orang dari dong pung panyaki macam-macam. ");
INSERT INTO mkn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma Yesus ju suka ondor diri dari orang banya, ko pi sambayang di tampa sunyi. ");
INSERT INTO mkn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Satu kali, Yesus ajar orang di satu ruma. Itu waktu ada orang dari partei agama Farisi deng guru agama barapa orang, datang ko iko dengar sang Dia. Dong datang dari kampong-kampong di propinsi Galilea, dari propinsi Yudea, deng dari kota Yerusalem. Tuhan Allah ada kasi kuasa sang Yesus ko bekin bae orang saki dong. ");
INSERT INTO mkn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Itu waktu, ada barapa orang dorok bawa satu orang lumpu di atas tandu. Dong usaha karás bawa itu orang lumpu, ko Yesus bekin bae sang dia. Ma itu ruma su talalu sesak deng orang, sampe-sampe mau paksa maso ju, sonde bisa. Andia ko dong bawa nae itu orang lumpu pi atas ruma. Ais dong bongkar bekin lobang, ko loos kasi turun itu orang lumpu di atas tandu. Dong kasi turun sang dia di teng-tenga orang banya dong, parsís di Yesus pung muka. ");
INSERT INTO mkn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Lia bagitu ju, Yesus tau bilang, dong parcaya Dia bisa bekin bae sang dong pung kawan tu. Ju Dia omong sang itu orang lumpu bilang, “Ana, é! Beta su hapus buang lu pung sala dong.” ");
INSERT INTO mkn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dengar Yesus omong bagitu, ju itu orang Farisi deng guru agama dong mulai batanya bilang, “Heꞌe! Cuma Tuhan Allah sandiri sa yang ada pung hak ko hapus buang orang pung sala dong. Ko dia ni, sapa, sampe bekin diri sama ke Tuhan Allah! Ini ni, hojat barát!” ");
INSERT INTO mkn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ma Yesus tau dong pung dalam hati. Ais Dia omong bilang, “Akurang ko bosong pikir Beta ni, ada omong hojat? ");
INSERT INTO mkn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Beta ni, Manusia Tulen. Deng Beta ada pung hak ko kasi ampon orang pung sala. Kalo Beta cuma kasi tau sang ini orang lumpu ni bilang, ‘Beta su kasi ampon lu pung sala,’ bosong sonde lia Beta pung kuasa di ini dunya. Ma kalo Beta bilang, ‘Bangun suda! Angka lu pung tandu ko pulang.’ Kalo dia bangun memang, bosong baru dapa lia Beta pung kuasa. Andia ko Beta mau bekin bae ini orang lumpu ko biar bosong ju tau Beta ada pung hak ko kasi ampon orang pung sala.” Ju Dia bale ko omong sang itu orang lumpu bilang, “Badiri su! Angka lu pung tandu, ko jalan pulang!” ");
INSERT INTO mkn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Takuju sa, ju itu orang bangun badiri di orang banya dong pung muka, ais angka ame dia pung tandu. Tarús dia jalan pulang deng angka puji sang Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lia bagitu ju, samua orang heran. Ais dong angka nae tinggi-tinggi Tuhan Allah pung nama bilang, “Tuhan hebat, ó! Ini hari kotong su lia hal luar biasa deng kotong pung mata kapala sandiri!” ");
INSERT INTO mkn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sonde lama ju, Yesus kaluar dari itu ruma, ju Dia dapa lia satu orang tukang tagi bea yang ada dudu di dia pung tampa pajak. Itu orang pung nama, Lewi. Ais Yesus ajak sang dia bilang, “Mari iko sang Beta!” ");
INSERT INTO mkn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dengar bagitu, ju Lewi bangun memang, ais jalan kasi tenga samua-samua di situ, ko iko sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ais itu, Lewi bekin pesta bésar ko undang Yesus datang pi dia pung ruma. Dia ju undang dia pung kawan tukang tagi bea dong, deng tamu laen dong, ko datang makan pesta. ");
INSERT INTO mkn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma ada barapa orang partei agama Farisi deng guru agama dong, yang mangomel di Yesus pung ana bua dong bilang, “Akurang ko bosong dudu makan deng orang tar laku-laku dong, sama ke itu tukang tagi bea deng itu orang tar bae dong? Orang bae jang bacampor deng orang model ke dong!” ");
INSERT INTO mkn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ma Yesus kasi tau sang dong bilang, “Orang saki memang parlú dokter. Ma orang su bae, sonde parlú. ");
INSERT INTO mkn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Beta datang ko urus orang tar bae dong. Ma sonde datang ko urus orang yang su rasa diri batúl.” ");
INSERT INTO mkn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ais, itu orang dari partei agama Farisi deng guru agama dong ju mangomel di Yesus bilang, “Bagini, Bapa! Yohanis Tukang Sarani pung ana bua dong puasa deng sambayang ulang kali. Orang Farisi pung ana bua dong ju bagitu. Ma akurang ko Bapa pung ana bua dong maen makan-minum tarús? Dong tu, sonde tau puasa, ko?” ");
INSERT INTO mkn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ma Yesus balas pake umpama sang dong bilang, “Memang bosong su tau, kalo ada pesta kawin, tamu dong sonde puasa, ma dong makan sampe kinyang. Kalo baroit laki-laki masi ada di situ, tantu dong samua makan rame-rame. ");
INSERT INTO mkn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma nanti satu kali, kalo orang laen tangkap bawa itu baroit laki-laki dolo, dia pung tamán dong rasa susa, baru dong puasa.” ");
INSERT INTO mkn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ais ju Yesus kasi satu umpama lai bilang, “Sonde ada orang yang ame kaen baru sapoꞌong, ko tempel pi di baju lama yang tarobe. Te nanti kalo cuci itu baju, kaen tempel yang baru tu batakundur, deng itu baju lama tamba tarobe. ");
INSERT INTO mkn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Bagitu ju, orang sonde isi tuak baru pi dalam haik yang su lapuk. Te nanti itu haik pica, ju itu tuak malele buang. Jadi tuak baru musti poꞌa pi dalam haik yang baru. Deng bagitu, Yesus ajar sang dong bilang, Dia pung ajaran baru, jang kasi campor deng orang Farisi dong pung ajaran lama. ");
INSERT INTO mkn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Orang yang su parná minum aer anggor yang lama, sonde suka minum yang baru. Te dia tau bilang, ‘Anggor yang su tasimpan lama tu, yang paling enak na!’ ” ");
INSERT INTO mkn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Satu kali, pas deng orang Yahudi dong pung hari barenti karjá, Yesus deng Dia pung ana bua dong ada jalan iko orang pung kabón. Ju Dia pung ana bua dong koru ame padi-gandum pung buler yang ada di dong pung muka idong. Ais dong maꞌisi ko makan. ");
INSERT INTO mkn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Di situ, ada barapa orang dari partei agama Farisi yang pegang karás dong pung adat Yahudi. Lia Yesus pung ana bua dong bekin bagitu, ju dong togor sang Dia bilang, “Akurang ko Lu pung ana bua dong langgar kotong pung atoran agama? Dong ada karjá pas deng hari barenti karjá! Lia tu! Dong ada koru padi-gandum. Sonde bole bagitu!” ");
INSERT INTO mkn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Ma Yesus balas bilang, “Karmana, ó? Bosong sonde inga baꞌi Daud pung carita tu? Baꞌi Daud deng dia pung ana bua dong pung parú su karoncong tagal lapar mau mati. Ju dong maso pi dalam Tuhan Allah pung Tenda Sambayang, ko ame itu roti yang kapala agama dong su kasi sang Tuhan, ko dong makan. Padahal cuma kapala agama dong sa yang bole makan itu roti. Orang laen sonde bole. Ais baꞌi Daud dong makan, ma sonde ada orang kasi sala sang dong. Bosong tingka ke sonde tau baca Tuhan Allah pung Tulisan Barisi sa! ");
INSERT INTO mkn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pasang talinga ko dengar bae-bae! Beta ni, Manusia Tulen. Beta ada pung hak ko putus bilang, orang bole bekin apa pas deng hari barenti karjá.” ");
INSERT INTO mkn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Satu hari, pas deng hari barenti karjá yang laen ju, Yesus pi ajar di ruma sambayang. Di situ, ada satu laki-laki yang dia pung tangan mati sablá. ");
INSERT INTO mkn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Di situ, ju ada barapa guru agama deng orang dari partei agama Farisi yang ada cari salák ko mau gaꞌe kasi jato sang Yesus. Ais dong ada tunggu-tunggu kalo Dia mau bekin bae itu orang yang tangan mati sablá, pas deng hari barenti karjá. Deng bagitu, dong bisa tudu sang Dia di muka-muka. ");
INSERT INTO mkn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma Yesus tau parsís dong pung maksud. Andia ko Dia pange itu orang tangan mati sablá bilang, “Bu, é! Mari badiri di teng-tenga sini doo!” Ju dia pi badiri memang. ");
INSERT INTO mkn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ais Yesus tanya sang itu orang dong bilang, “Coba Beta tanya sang bosong doo. Iko kotong pung atoran agama, kotong bole bekin apa sa, pas deng hari barenti karjá? Kotong bekin bae ko, bekin jahat? Kotong kasi salamat orang ko, bekin ancor dia pung idop?” ");
INSERT INTO mkn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tarús Yesus lia kuliling sang dong, ju Dia omong deng itu orang yang tangan mati sablá tu bilang, “Sorong datang lu pung tangan!” Ais dia sorong, ju dia pung tangan bae memang. ");
INSERT INTO mkn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lia bagitu, ju Yesus pung musu-musu dong maruak. Ais dong mulai ator siasat bilang, “Botong musti cari jalan laen lai, ko mau kasi jato sang Dia!” ");
INSERT INTO mkn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sonde lama lai, ju Yesus pi satu gunung ko sambayang. Ais Dia sambayang di situ satu malam anteru. ");
INSERT INTO mkn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dia pung beso papagi, ju Dia pange ame Dia pung ana bua dong. Ais dari dong samua, Dia pili ame dua blas orang ko jadi Dia pung utusan. Orang yang Dia pili tu, andia: ");
INSERT INTO mkn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (yang biasa Yesus pange ‘Petrus’), Anderias (Simon pung adi), Yakobis, Yohanis (Yakobis pung adi), Filipus, Bartolomeos, ");
INSERT INTO mkn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateos, Tomas, Yakobis (Alpius pung ana), Simon (yang iko partei politik Selot), ");
INSERT INTO mkn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (Yakobis pung ana), deng Yudas Iskariot (yang nanti jual buang sang Yesus). ");
INSERT INTO mkn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Waktu turun dari gunung tu, Yesus deng Dia pung ana bua dong badiri di tana rata. Di situ ju, ada orang banya bakumpul. Dong tu, datang dari propinsi Yudea, dari kota Yerusalem, dari Tirus deng Sidon, andia dua kota di pinggir laut. ");
INSERT INTO mkn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dong datang ko mau dengar sang Yesus, deng ada yang mau minta Dia bekin bae orang saki. Ju Dia bekin bae sang dong. Dia ju bekin bae orang yang takaná setan, deng usir setan kaluar dari itu orang dong. ");
INSERT INTO mkn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Samua orang mau sonto ame sang Dia, te kalo dong sonto kaná, na, ada kuasa kaluar dari Dia yang bekin bae sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ais Yesus bale mangada pi Dia pung ana bua dong, ju ajar bilang, “Orang kasian dong! Bosong ontong, tagal Tuhan Allah sandiri bosong pung Raja yang bae. ");
INSERT INTO mkn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Orang lapar dong! Bosong ontong, tagal Tuhan yang nanti bekin bosong jadi kinyang. Orang yang manangis deng hati susa dong! Bosong ontong, tagal bosong nanti hati babunga deng katawa sanáng. ");
INSERT INTO mkn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Orang yang kaná susa tagal iko sang Beta, Manusia Tulen ni! Bosong ontong, tagal Tuhan nanti balas sang bosong di sorga. Biar orang binci sang bosong, ko, bekin rusak bosong pung nama bae, ko, inja-inja sang bosong, ko, usir kasi iskarobis sang bosong sama ke orang jahat, bosong ontong, tagal Tuhan nanti inga sang bosong di sorga. Jadi, kalo orang bekin susa sang bosong bagitu, na, bekin bosong pung hati babunga sa! Deng balompa sanáng! Sonde usa heran, tagal itu orang yang bekin susa sang bosong sakarang ni, dong pung nene-moyang sandiri yang bekin susa sang Tuhan Allah pung jubir dolu-dolu dong. Jadi, kalo bosong dapa susa macam bagitu, bekin bosong pung hati babunga sa, tagal Tuhan nanti balas sang bosong bam-banya di sorga! ");
INSERT INTO mkn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ma orang kaya dong! Bosong calaka, tagal bosong pung idop sanáng, cuma sampe di sini sa. ");
INSERT INTO mkn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Orang kinyang dong! Bosong calaka, tagal musim lapar yang hebat nae kaná sang bosong. Orang kiki-kaka sambarang dong! Bosong calaka, tagal sangsara datang bekin bosong manangis makarereu pung. ");
INSERT INTO mkn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Orang gila hormat dong! Bosong calaka, tagal dolu bosong pung nene-moyang dong, ju puji-puji sang jubir tukang omong kosong dong!” ");
INSERT INTO mkn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ju Yesus sambung bilang, “Pasang talinga ko dengar bae-bae! Lu musti sayang lu pung musu dong, deng bekin hal bae kasi orang yang binci sang lu. ");
INSERT INTO mkn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sambayang ko minta Tuhan Allah ko bekin hal bae kasi orang yang kutuk sang lu. Deng minta Dia bekin hal bae kasi orang yang bekin-bekin sang lu. ");
INSERT INTO mkn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kalo ada orang yang tampeleng lu pung pipi sablá, na, kasi loos ko dia tampeleng tamba lai lu pung pipi sablá. Kalo ada yang rampas ame lu pung baju panas, na, kasi tamba lai lu pung baju sang dia. ");
INSERT INTO mkn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kalo ada orang minta lu pung barang satu, na, kasi pi sa. Deng kalo ada yang angka bawa lu pung barang satu, tenga pi ko dia soa sa. Jang pi minta pulang lai! ");
INSERT INTO mkn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lu musti bekin sang orang laen dong, parsís ke lu mau dong bekin bagitu sang lu. ");
INSERT INTO mkn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Lu suka kasi tunju sayang sang lu pung orang sandiri dong. Itu bae. Ma dia pung hebat, apa? Te orang jahat dong ju sayang dong pung orang sandiri! ");
INSERT INTO mkn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kalo lu cuma bekin bae sang orang yang bekin bae sang lu, dia pung hebat di mana? Te orang jahat dong ju ada maen babalas bekin bae bagitu. ");
INSERT INTO mkn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kalo lu cuma kasi pinjam doi sang orang yang bisa bayar kambali, na, dia pung hebat apa? Te orang jahat dong ju tau kasi pinjam doi sang orang laen, asal beso-lusa dong tarima kambali anteru. ");
INSERT INTO mkn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ma yang hebat tu, andia bagini: sayang lu pung musu dong! Deng bekin hal bae kasi sang dong. Apa yang dong parlú, na, kasi pinjam sa. Sonde usa pikir bilang, dong bisa kasi kambali, ko sonde. Deng bagitu, Tuhan Allah nanti balas sang lu. Deng lu jadi Tuhan Allah yang Paling Tinggi pung ana. Tagal lu idop sama ke lu pung Bapa yang suka bekin hal bae kasi orang jahat. Dia ju bekin hal bae kasi orang yang sonde tau minta tarima kasi. ");
INSERT INTO mkn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jadi lu musti kasi tunju rasa kasian sang orang, sama ke lu pung Bapa di sorga ju kasi tunju rasa kasian sang lu.” ");
INSERT INTO mkn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus ajar tarús bilang, “Jang nilei orang, ko biar orang jang nilei bale sang lu. Jang karitik orang, te nanti orang dong karitik bale sang lu. Lupa buang orang pung sala, ko biar dong ju lupa buang lu pung sala. ");
INSERT INTO mkn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kalo lu kasi orang apa yang dong parlú, nanti lu tarima bale. Te nanti Tuhan ator ko lu tarima bale ponu-ponu. Itu sama ke orang ada poꞌa kacang bam-banya dalam balék ukur, ais roꞌo-roꞌo sang dia, tendes kasi turun sang dia, ais isi lai sampe konde ju tapoꞌa. Yang lu tarima tu, macam ke bagitu. Kalo lu kasi sadiki, lu ju tarima bale sadiki. Ma kalo lu kasi banya, lu ju tarima bale bam-banya.” ");
INSERT INTO mkn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus ju ajar pake umpama. Dia carita bilang, “Orang buta sonde mungkin kasi tunju jalan kasi orang buta yang laen. Te nanti dong dua rame-rame jato maso pi dalam lobang! ");
INSERT INTO mkn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ana murid sonde mungkin lebe hebat dari dia pung guru! Ma kalo dia iko bae-bae dia pung guru pung ajaran, dia bisa jadi sama ke dia pung guru. ");
INSERT INTO mkn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Lu suka tanda bae-bae orang pung sala kici ana sa. Ma lu pung sala yang bésar, lu anggap ke sonde ada sa. Itu sama ke lu lia abu satu titik di orang pung mata. Padahal ada balok bésar pele lu pung mata, ma lu sonde rasa! ");
INSERT INTO mkn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Karmana ko lu barani omong bilang, ‘Konco! Mari ko beta tolong lap kasi kaluar itu abu dari lu pung mata biji dolo.’ Padahal lu sandiri sonde bisa lia apa-apa, te ada balok pele lu pung mata na! Woe! Dasar lu tu, orang muka-balakang batúl! Tolong doo! Angka buang itu balok dari lu pung mata sandiri dolo. Baru lu bisa lia, ko tolong lap buang abu sapoꞌong ana dari lu pung kawan pung mata.” ");
INSERT INTO mkn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus tamba lai satu umpama bilang, “Sonde mungkin pohon yang bae, kasi kaluar bua yang sonde bae. Deng sonde mungkin pohon yang sonde bae, kasi kaluar bua yang bae. ");
INSERT INTO mkn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Orang bisa tanda, kalo satu pohon tu, bae ko sonde, andia dari itu pohon pung bua dong. Samua orang tau bilang, sonde mungkin orang ketu ame bua jambu, ko bua anggor dari pohon baduri. ");
INSERT INTO mkn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bagitu ju orang yang hati barisi, bisa bekin hal-hal yang bae. Ma orang yang hati kamomos bekin hal-hal jahat. Te dari orang pung omong, kasi tunju dia pung asli.” ");
INSERT INTO mkn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ais Yesus sambung lai bilang, “Bosong maen pange tarús sang Beta bilang, ‘Bos’. Ma akurang ko bosong sonde mau iko Beta pung omong? ");
INSERT INTO mkn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Orang yang datang dengar sang Beta, ais bekin iko Beta pung omong, dia tu, sama ke ");
INSERT INTO mkn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","orang yang mau kasi badiri ruma yang kuat. Dia gali bae-bae lobang fanderen di tana isi dolo, sampe dapa kaná batu isi. Ais dia bekin fanderen pas di atas itu batu, baru dia bangun ruma. Kalo banjer datang, na, itu ruma sonde tagoyang, tagal dia pung dasar su kuat. ");
INSERT INTO mkn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma orang yang cuma dengar satenga hati deng sonde iko Beta pung omong, dia tu sama ke orang yang mau bangun ruma deng gampang sa. Dia sonde bekin fanderen, ma dia cuma tempel itu ruma di atas tana isi di kali pung pinggir. Ais waktu banjer datang, ju sapu bekin ancor itu ruma!” ");
INSERT INTO mkn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ajar abis bagitu, ju Yesus bale pi kota Kapernaum. ");
INSERT INTO mkn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Di situ ada satu komandán tantara Roma. Dia ada pung satu ana karjá yang dia parcaya. Itu orang karjá tu, ada jato saki ko amper mati. ");
INSERT INTO mkn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Waktu itu komandán dapa dengar soꞌal Yesus, ju dia kirim barapa orang tua Yahudi ko pi minta Yesus datang bekin bae itu ana karjá. ");
INSERT INTO mkn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dong noki-noki sang Yesus, ko kalo bisa, na, Dia iko datang deng dong pi bekin bae itu orang. Dong buju sang Dia bilang, “Bapa! Ini orang Roma ni, orang bae! Dia tu, pantas Bapa tolong. ");
INSERT INTO mkn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Te dia su bangun satu ruma sambayang kasi sang kotong, ko dia sayang sang kotong orang Yahudi na.” ");
INSERT INTO mkn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ju Yesus iko deng dong. Dong balóm sampe di ruma, ma itu komandán su kirim dia pung kawan datang bawa pasán sang Yesus bilang, “Bos sonde usa cape-cape datang lai, te beta sonde pantas tarima Bos di beta pung ruma. ");
INSERT INTO mkn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Deng beta ju sonde pantas datang mangada sang Bos. Su jalás bilang, Bos ada pung kuasa. Jadi asal Bos omong sa dari situ, pasti beta pung ana karjá bae memang. Beta mangarti ini hal, tagal beta pung bos dong ada kuasa ko parenta sang beta. Deng beta ju ada pung kuasa ko parenta beta pung tantara dong. Kalo beta kasi parenta beta pung ana bua bilang, ‘Pi sana!’ pasti dia pi. Kalo beta bilang, ‘Datang sini!’ pasti dia datang. Deng kalo beta suru beta pung orang karjá bilang, ‘Karjá ini!’ pasti dia bekin bagitu. Jadi asal Bos omong sa, pasti beta pung ana karjá ni, bae memang.” ");
INSERT INTO mkn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dengar bagitu ju Yesus heran. Dia putar badan ko mangada sang itu orang banya yang ada iko deng Dia. Ju Dia bilang, “Heran, é! Su bagini lama, ma Beta balóm parná katumu satu orang Yahudi ju yang parcaya sama kuat ke ini orang Roma!” ");
INSERT INTO mkn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jadi Yesus cuma jalan sampe di situ sa. Ais komandán pung kawan dong bale pulang. Sampe di itu komandán pung ruma, ju dong dapa lia itu ana karjá su bae memang. ");
INSERT INTO mkn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dia pung beso, ju Yesus deng Dia pung ana bua dong barangkat pi satu kampong, nama Nain. Ada banya orang yang jalan sama-sama deng dong. ");
INSERT INTO mkn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Waktu dong su mau deka di itu kampong pung pintu maso, ada satu rombongan orang mau kaluar pi kubur orang mati. Yang mati tu, satu mama janda pung ana laki-laki satu biji sa. ");
INSERT INTO mkn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Waktu Yesus lia itu mama janda, ju Dia jato kasian. Tarús Dia omong deng itu mama bilang, “Mama! Suda lai, sonde usa manangis!” ");
INSERT INTO mkn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ais Yesus pi deka-deka, ju sonto itu tandu orang mati. Ju itu orang yang dorok itu tandu, barenti tahan. Tarús Yesus omong sang itu orang mati bilang, “Nyong! Bangun su!” ");
INSERT INTO mkn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ais, itu ana idop kambali, ju dia bangun dudu memang. Tarús dia mulai baꞌomong deng orang-orang yang ada badiri kuliling sang dia. Ais Yesus kasi tau sang itu mama bilang, “Mama! Ini mama pung ana.” ");
INSERT INTO mkn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Samua orang yang ada di situ dong taku mau mati! Ju dong puji-puji sang Tuhan Allah bilang, “Tuhan Allah su utus Dia pung jubir hebat satu kasi kotong!” Ada laen lai yang bilang, “Tuhan Allah su datang di kotong pung teng-tenga, ko kasi tunju Dia pung hati bae!” ");
INSERT INTO mkn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ju itu carita tasiar pi mana-mana di propinsi Yudea, sampe di daꞌera laen ju. ");
INSERT INTO mkn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Yohanis Tukang Sarani pung ana bua dong su dengar samua hal yang Yesus bekin. Ais dong pi carita kasi sang Yohanis dalam bui. Ju dia kirim dua orang pi sang Yesus ko tanya sang Dia bilang, “Bapa ni, batúl-batúl Kristus, yang botong ada tunggu-tunggu, ko? Ko, botong musti tunggu sang orang laen lai?” Ais dong katumu sang Yesus, ju dong tanya bagitu. ");
INSERT INTO mkn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Waktu itu utusan ada di situ, Yesus ada bekin bae banya orang dari dong pung panyaki macam-macam. Deng ada usir kaluar setan dari orang yang takaná setan. Deng ada bekin bae orang buta ko dong bisa dapa lia. ");
INSERT INTO mkn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ais Yesus kasi tau sang Yohanis pung ana bua dong bilang, “Bosong pulang pi kasi tau sang bu Anis, samua-samua yang bosong su dengar deng su lia sandiri, sama ke Tuhan Allah pung jubir Yesaya ada tulis bilang, ‘Orang buta, dapa lia. Orang kaki lumpu, bangun bajalan. Orang panyaki kusta, jadi barisi. Orang tuli, dapa dengar. Orang mati, idop kambali. Orang kasian, dengar Kabar Bae.’ ");
INSERT INTO mkn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pulang pi kasi tau sang bu Anis bilang, ‘Orang yang sonde malu tarima sang Beta, nanti dong ontong batúl.’ ” ");
INSERT INTO mkn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Waktu Yohanis pung ana bua dong su pulang, ju Yesus omong deng itu orang banya dong soꞌal Yohanis bilang, “Waktu bosong pi cari Yohanis di tampa sunyi sana tu, bosong pikir mau katumu deng manusia model ke apa? Sonde mungkin bosong pi sana ko katumu orang yang noe-noe, sama ke bambu yang tagoyang-goyang iko angin sa! ");
INSERT INTO mkn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Sonde mungkin bosong pi ko lia orang yang pake pakean mahal-mahal, te orang macam bagitu cuma tenga di istana sa! ");
INSERT INTO mkn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jadi bosong pi lia sapa di sana? Bosong pikir bosong pi cari Tuhan Allah pung jubir? Batúl! Ma dia tu, jubir yang paling hebat. ");
INSERT INTO mkn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Te Tulisan Barisi ada tulis memang soꞌal Yohanis bilang, ‘Dengar! Beta utus Beta pung orang, ko pi buka jalan kasi sang Lu.’ ");
INSERT INTO mkn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Di ini dunya, sonde ada satu orang ju, yang lebe hebat dari Yohanis. Ma di Tuhan pung karajaꞌan, orang yang paling kakorek sa su lebe hebat dari Yohanis.” ");
INSERT INTO mkn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Orang yang dengar Yesus pung omong tu, dong su mangarti bilang, Tuhan pung jalan tu, jalan idop yang batúl. Tukang tagi bea dong ju bagitu. Tagal dolu Yohanis su sarani deng ajar sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma orang dari partei agama Farisi deng ahli hukum Yahudi dong su sonde mau iko Tuhan Allah pung mau-mau. Andia ko dong sonde minta Yohanis sarani sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ais Yesus tanya bilang, “Beta mau banding orang sakarang ni, deng apa? Manusia macam apa dong ni? ");
INSERT INTO mkn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Dong tu, sama ke ana-ana yang ada dudu-dudu di pasar. Dong maen babatarea deng bamangomek bilang, ‘Botong tiop suling rame-rame, ma bosong sonde manari sanáng. Ais botong manyanyi lagu mete, ma bosong sonde manangis.’ ");
INSERT INTO mkn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Te Yohanis Tukang Sarani sonde minum anggor, deng suka puasa, na, bosong cap sang dia bilang, ‘Dia takaná setan!’ ");
INSERT INTO mkn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma sakarang Beta, Manusia Tulen ni, minum anggor deng makan roti ke biasa. Ju bosong cap sang Beta bilang, ‘Dia tu, dasar manusia balalas! Pamabok barát lai! Pi bakawan deng tukang tagi bea dong! Satu partei deng orang tar laku-laku dong! Sonde tau diri lai!’ ");
INSERT INTO mkn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma bosong tanda sa, Be pung omong, é! Orang yang mangarti batúl, dong iko Tuhan pung mau-mau.” ");
INSERT INTO mkn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Di itu kota, ada orang Farisi satu, nama Simon. Satu kali, dia undang Yesus dong datang makan di dia pung ruma. Tarima ame itu undangan, ju Yesus dong pi ko mau dudu makan. ");
INSERT INTO mkn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Itu waktu, ada satu parampuan nakal yang dapa dengar bilang, Yesus ada mau makan di situ. Ju dia maso datang, deng pegang bawa satu botol minya wangi yang mahal pung. ");
INSERT INTO mkn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dia datang deka sang Yesus dari Dia pung balakang. Ais dia pi tikam lutut di Yesus pung kaki. Tarús dia manangis makarereu sampe dia pung aer mata jato kaná Yesus pung kaki. Dia seka Yesus pung kaki pake dia pung rambu sandiri, deng ciom barmaen Yesus pung kaki. Ais ju dia poꞌa itu minya wangi pi Yesus pung kaki. ");
INSERT INTO mkn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon tu, kanál itu parampuan pung dudu-badiri. Andia ko dia pikir dalam hati bilang, “Ini su jadi bukti Yesus ni, bukan Tuhan Allah pung jubir! Kalo batúl-batúl Tuhan Allah yang kirim sang Dia, su tantu Yesus tau bilang, parampuan yang ada sonto sang Dia tu, parampuan nakal. Tuhan Allah pung jubir sonde macam ke Dia tu, te orang barisi sonde bole badeka deng orang kamomos dong!” ");
INSERT INTO mkn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma Yesus baca apa yang Simon ada pikir. Ju Dia bilang, “Bu Mon! Bagini, bu. Beta mau kasi tau sang bu satu hal.” Ju Simon manyao bilang, “Neu! Bapa Guru, omong sa.” ");
INSERT INTO mkn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tarús Yesus buang bahasa sang dia bilang, “Ada satu orang yang tukang kasi pinjam doi sang orang laen. Dia parná kasi pinjam doi sang dua orang. Yang satu, dia kasi pinjam 500 doi perak; yang laen, cuma 50 sa. ");
INSERT INTO mkn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma sampe dia pung waktu kasi pulang itu doi, na, dong dua sonde mampu. Ju itu tukang kasi pinjam doi tu, jato kasian sang dong dua. Andia ko dia kasi bebas itu dua orang pung utang. Naa, kalo iko bu Mon pung pikir, dari itu dua orang yang pinjam doi tu, mana yang lebe sayang sang itu tukang kasi pinjam doi?” ");
INSERT INTO mkn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon sambar langsung bilang, “Tantu yang pung utang paling bésar, é!” Yesus manyao bilang, “Batúl, bu!” ");
INSERT INTO mkn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ju Dia bale mangada sang itu parampuan, ko bilang sang Simon, “Coba bu Mon taro mata di ini parampuan ni. Waktu Beta maso datang di bu pung ruma, bu sonde sadia aer ko cuci Beta pung kaki iko kotong pung adat. Ma ini parampuan kasi basa Beta pung kaki pake dia pung aer mata, abis seka kasi barisi pake dia pung rambu. ");
INSERT INTO mkn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Deng tadi waktu sambut sang Beta pi dalam bu Mon pung ruma, bu Mon sonde ciom sang Beta, iko kotong pung biasa. Ma mulai dari Beta maso pi dalam ini ruma, ini parampuan sonde barenti ciom Beta pung kaki. ");
INSERT INTO mkn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bu Mon ju lupa itu adat poꞌa minya di tamu pung kapala, waktu Beta maso tadi. Ma ini parampuan su poꞌa minya wangi yang mahal mati pung di Beta pung kaki. ");
INSERT INTO mkn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bu Mon dengar bae-bae doo! Ini parampuan pung sala memang banya. Ma Tuhan su hapus buang samua, tagal dia su kasi tunju dia pung sayang deng rasa sukur bam-banya kasi sang Beta. Ma orang yang rasa diri sonde bekin sala banya, dia ju rasa sonde parlú dapa ampon banya. Andia ko dia sonde tau sayang, deng sonde tau rasa sukur bale kasi sang Tuhan.” ");
INSERT INTO mkn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ais ju Yesus omong sang itu parampuan bilang, “Beta su hapus buang lu pung sala dong!” ");
INSERT INTO mkn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Orang-orang yang ada dudu makan sama-sama, mulai bakusu-kusu bilang, “Woeh! Dia pikir Dia ni, sapa?! Dia barani kasi ampon orang pung sala, ó! Padahal cuma Tuhan Allah sandiri sa yang ada pung hak ko hapus buang orang pung sala! Cue!” ");
INSERT INTO mkn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ma Yesus kasi tau sang itu parampuan bilang, “Tagal lu su parcaya sang Beta, andia ko Tuhan su kasi salamat sang lu. Pulang su deng dame!” ");
INSERT INTO mkn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Sonde lama lai, ju Yesus deng Dia pung ana bua dua blas orang, ada jalan kuliling pi kota-kota deng kampong-kampong di situ. Dia jalan kasi tau orang dong soꞌal Tuhan Allah pung parenta. Itu jadi kabar bae kasi sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Dalam itu rombongan ada barapa parampuan yang iko ju. Ini parampuan dong ni, ada yang parná saki macam-macam, deng ada yang parná takaná setan. Ma Yesus su bekin bae sang dong samua. Macam ke Maria dari kampong Magdala. Dolu Yesus parná usir buang tuju setan kaluar dari dia. ");
INSERT INTO mkn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ada ju Susana, deng mama Yohana. Mama Yohana ni, andia bapa Kusa pung bini. Kusa tu, kapala urusan di raja Herodes pung ruma jabatan. Deng masi ada banya parampuan laen yang jalan sama-sama deng Yesus dong. Ini parampuan dong pake dong pung doi sandiri ko tanggong Yesus dong pung ongkos di jalan. ");
INSERT INTO mkn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Satu kali, orang dong kaluar datang dari banya kampong ko cari sang Yesus. Waktu orang banya su bakumpul, ju Dia carita kasi sang dong satu umpama bilang, ");
INSERT INTO mkn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ada satu orang tani pi siram bibit di dia pung kabón. Bibit saparu jato di jalan. Waktu orang jalan di situ, dong inja-inja itu bibit dong. Ais burung datang ko toto bekin abis. ");
INSERT INTO mkn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bibit saparu lai jato di tana babatu. Itu bibit mulai banupuk, ma dong layu buang, tagal kurang aer. ");
INSERT INTO mkn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bibit saparu yang laen jato di tampa baduri. Ma waktu itu bibit dong mulai banupuk, pohon baduri dong gepe kasi mati sang dong. ");
INSERT INTO mkn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma bibit yang laen lai, jato kaná di tana isi yang subur. Dong banupuk, ais tumbu jadi bésar sampe babua. Itu bibit dong kasi bale hasil saratus kali.” Carita abis bagitu, ju Yesus konci itu umpama, ais omong deng suara karás bilang, “Bosong yang ada pasang talinga, na, pikir ame bae-bae!” ");
INSERT INTO mkn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ais ju Yesus pung ana bua dong tanya itu umpama pung arti. ");
INSERT INTO mkn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Dia manyao bilang, “Bagini! Tagal bosong su iko batúl-batúl Tuhan Allah pung mau-mau, andia ko Beta buka taráng-taráng ko bosong tau, karmana Tuhan mau parenta Dia pung orang dong. Ma orang laen dong sonde mau toe Tuhan pung mau-mau. Andia ko Beta ajar sang dong pake umpama sa. Te Tuhan pung jubir su tulis memang soꞌal ini orang dong bilang, ‘Dong su lia, ma sonde mau mangarti. Dong su dengar, ma sonde mau tau.’ ” ");
INSERT INTO mkn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ju Yesus kasi tau itu umpama pung arti bilang, “Bibit tu, andia Tuhan Allah pung Kata-kata. ");
INSERT INTO mkn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bibit yang jato di jalan tu, andia orang yang dengar Tuhan pung Kata-kata, ma ais setan dong pung bos datang rampas bawa itu Kata-kata dari dong pung hati. Deng bagitu, dong sonde parcaya sang Tuhan, deng sonde dapa salamat. ");
INSERT INTO mkn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bibit yang jato di tana babatu tu, andia orang yang dengar Tuhan pung Kata-kata deng sanáng. Ma dong pung akar sonde maso dalam-dalam. Dong mulai parcaya, ma kalo susa su nae kaná sang dong, dong gampang jato. ");
INSERT INTO mkn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bibit yang jato pi tampa baduri tu, andia orang yang dengar deng tarima Tuhan pung Kata-kata. Ma sonde lama ju, dong lupa buang itu Kata-kata, te dong lebe barepot deng dong pung urusan sandiri sa, deng dong pung harta macam-macam, deng mau idop sanáng-sanáng sa. Andia ko, dong pung parcaya tu, sonde ada pung hasil apa-apa. ");
INSERT INTO mkn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma bibit yang jato di tana isi yang subur tu, andia orang yang pung hati bae deng hati lurus. Waktu dong dengar Tuhan Allah pung Kata-kata, ju dong taro bae-bae dalam hati. Deng bagitu, dong parcaya tarús, deng bekin banya hal yang bae.” ");
INSERT INTO mkn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ais Yesus omong lai bilang, “Sonde mungkin orang kasi manyala lampu teꞌoek, ais tutu ame deng pareu tana. Deng sonde ada orang yang taro lampu pi kolong koi. Te kalo bekin bagitu, na, orang sonde bisa dapa lia dia pung taráng lai. Lampu yang ada pung guna, andia yang ada taro di tampa tinggi, ko biar dia pung cahaya kasi taráng orang yang maso datang. ");
INSERT INTO mkn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Samua yang tasambunyi sakarang, nanti jadi kantara. Deng samua hal yang orang sonde tau sakarang, nanti orang dapa tau. ");
INSERT INTO mkn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jadi bosong musti pikir ame bae-bae ini hal dong. Orang yang mau cari tau batúl-batúl Tuhan pung mau, dia tamba pintar. Ma orang yang sonde pusing deng Tuhan pung mau, dia tamba bodo.” ");
INSERT INTO mkn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Satu kali, Yesus ada sibuk deng orang banya dong. Ju Dia pung mama deng adi-adi dong datang ko mau katumu deng Dia. Ma dong sonde bisa deka-deka deng Dia, tagal orang talalu banya. ");
INSERT INTO mkn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ju ada orang pi kasi tau sang Yesus bilang, “Bapa! Bapa pung mama deng adi-adi dong ada di luar. Dong ada mau katumu deng Bapa.” ");
INSERT INTO mkn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ju Dia manyao bilang, “Hoo! Ma bagini. Beta pung mama deng sodara yang batúl dong, andia orang yang dengar Tuhan Allah pung Kata-kata, ais bekin iko.” ");
INSERT INTO mkn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Satu kali, Yesus ajak Dia pung ana bua dong bilang, “Mari kotong nae parahu, ko pi dano pung sablá.” Ju dong nae parahu satu, ko dong mulai star. ");
INSERT INTO mkn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Waktu dong ada balayar, Yesus tidor. Sonde lama ju, angin ribut datang. Galombang puku maso dalam parahu. Ju dong su mau calaka. ");
INSERT INTO mkn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lia bagitu, ju ana bua dong kasi bangun sang Yesus bilang, “Bos! Bos, é! Bangun ko tolong dolo! Kotong su mau mati tanggalám ni!” Ju Yesus bangun. Ais Dia togor itu angin deng galombang bilang, “Barenti su!” Ju galombang deng angin jadi tadó memang. ");
INSERT INTO mkn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ais Dia togor sang Dia pung ana bua dong bilang, “Akurang ko bosong masi balóm parcaya sang Beta ju?” Dong taku deng heran. Ju dong batanya satu deng satu bilang, “Awii! Yesus ni, sapa? Karmana ko Dia bisa parenta angin deng galombang, ko dong iko Dia pung mau?” ");
INSERT INTO mkn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sonde lama ju dong sampe di daꞌera Gerasa, di dano Galilea pung sablá. ");
INSERT INTO mkn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Di situ ada satu orang yang su lama takaná setan dong. Dia sonde ada pung ruma, deng dia cuma tenga di kuburan sa. Tiap hari dia pal pi-datang deng talanjang bulat sa. Te setan dong parenta sang dia tarús-tarús. Orang su ika sang dia ulang kali pake rante deng galáng besi, ma dia kasi putus buang sa. Ais setan dong maen paksa dia ko lari pi tampa sunyi. Waktu Yesus dong turun dari parahu, itu orang gila datang sang Dia. Itu orang batarea, ais buang diri di Yesus pung kaki. Tarús Yesus parenta bilang, “Weh, setan! Kaluar dari ini orang!” Ju itu orang gila batarea bilang, “Woi! Jang ganggu sang beta! Te beta tau Lu ni, Yesus, Tuhan Allah yang Paling Tinggi pung Ana! Lu jang siksa sang beta!” ");
INSERT INTO mkn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus tanya sang dia bilang, “Lu pung nama sapa?” Ju itu setan manyao bilang, “Legion, te botong ada banya, tingka ke tantara ribu-ribu.” Dia bilang bagitu, tagal ada banya setan yang maso tenga di dia pung diri. ");
INSERT INTO mkn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Itu setan dong maen minta tarús sang Yesus ko jang suru sang dong pi Lobang Siksa, andia tampa tahan kuasa jahat dong. ");
INSERT INTO mkn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma deka-deka di situ, ada babi satu kalompok bésar yang ada doꞌi-doꞌi tana ko cari makan di gunung pung pinggir. Ju itu setan dong minta sang Yesus bilang, “Suru sa ko botong maso pi dalam itu babi dong!” Ju Yesus ia bae. ");
INSERT INTO mkn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ais, itu setan dong kaluar kasi tenga itu laki-laki, ju dong maso pi dalam itu babi dong. Itu babi dong samua jadi gila, tarús dong lari tabodo-bodo turun dari itu gunung, ko jato pi dalam dano. Ju dong samua mati tanggalám. ");
INSERT INTO mkn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lia bagitu ju, tukang jaga babi dong lari pi kuliling kampong-kampong di situ, ju dong carita samua-samua. ");
INSERT INTO mkn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dengar dong pung carita bagitu, orang banya dong kaluar pi itu tampa. Dong mau lia sandiri apa yang su jadi. Sampe di situ, ju dong dapa lia itu orang yang takaná setan ada dudu tanáng-tanáng deka Yesus pung kaki. Dia su pake pakean, deng dia su sonde gila lai. Lia bagitu, ju dong samua jadi taku. ");
INSERT INTO mkn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ais orang-orang yang tadi dapa lia itu parkara, kasi tau orang yang baru datang dong karmana ko itu orang gila su jadi bae kambali. ");
INSERT INTO mkn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ju orang Gerasa samua yang tenga di itu daꞌera dong, minta sang Yesus ko Dia jalan kasi tenga sang dong, te dong samua ada taku mau mati. Ju Yesus dong pi nae dalam parahu, ko mau pulang kambali pi dano Galilea pung sablá. ");
INSERT INTO mkn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ma itu orang yang tadi takaná setan tu, maen noki-noki sang Yesus bilang, “Bapa! Biar ko beta iko deng Bapa ju!” Ma Yesus balas bilang, ");
INSERT INTO mkn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bagini sa! Lebe bae lu pulang pi lu pung kelu dong, ko carita sang dong soꞌal Tuhan Allah pung bae, yang Dia su bekin kasi sang lu.” Ais, itu orang pi kuliling itu kota, ju dia carita kasi samua orang soꞌal Yesus bekin bae sang dia. ");
INSERT INTO mkn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ais ju Yesus dong balayar pulang pi dano Galilea pung sablá. Waktu dong turun dari parahu, orang banya dong su tunggu-tunggu sang Dia. Dong datang makarubu ko mau sambut sang Dia. ");
INSERT INTO mkn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Di situ ju, ada satu orang, nama Yairus. Dia tu, kapala ruma sambayang di itu kota. Dia pung ana, cuma satu biji sa; ana nona, umur dua blas taon. Sakarang itu nona ada saki karás amper mati. Waktu Yairus lia Yesus pung datang, dia pi tikam lutut di Yesus pung muka. Dia minta ko Yesus datang di dia pung ruma, ko tolong sang dia pung ana nona. Waktu Yesus manyao ia sang dia, ju dong jalan pi Yairus pung ruma. Ma orang banya dong ju tar sampat ko mau iko ju. Andia ko dong jalan baseti-baseti. ");
INSERT INTO mkn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ada satu parampuan ju yang jalan iko deng dong. Dia pung datang bulan sonde tau barenti batúl su dua blas taon. Dia su kasi abis dia pung doi deng harta dong, ko pake bayar kasi dokter dong. Ma sonde ada yang bisa bekin bae sang dia. Dia pung panyaki tu, maen foe tarús. ");
INSERT INTO mkn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ju dia datang deka-deka sang Yesus dari Dia pung balakang. Ais dia sonto ame Yesus pung ujung baju. Waktu dia sonto abis, ju dia pung dara loos barenti memang. ");
INSERT INTO mkn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Takuju Yesus badiri, ais Dia tanya bilang, “Sapa yang ada sonto sang Beta ni?” Ma sonde ada satu orang yang mangaku ju. Ais Petrus bilang, “Bos lai, ju! Ko orang banya ada jalan baseti bagini! Dong su, yang maen batola dari balakang.” ");
INSERT INTO mkn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma Yesus bilang sang dia, “Sonde! Tadi Beta rasa ada kuasa yang kaluar dari Beta. Jadi Beta tau ada satu orang yang sangaja sonto sang Beta.” ");
INSERT INTO mkn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Waktu itu parampuan sadar kalo dia sonde bisa sambunyi, ju dia taku mau mati. Dia gamatar, ko tikam lutut di Yesus. Ais dia carita dia pung akar masala di muka orang dong samua. Tarús dia kasi tau bilang, pas dia sonto sang Yesus, ju dia bae memang. ");
INSERT INTO mkn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ais Yesus omong sang dia bilang, “Susi! Lu su jadi bae, tagal lu parcaya sang Beta. Pulang ruma deng dame su!” ");
INSERT INTO mkn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Waktu Yesus masi baꞌomong deng itu parampuan, ju Yairus pung orang satu datang kasi tau sang dia bilang, “Aduu, Bapa, é! Bapa pung ana su sonde ada lai! Dia su mati, jadi sonde usa bekin repot lai sang Bapa Guru.” ");
INSERT INTO mkn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma waktu Yesus dapa dengar itu orang pung laporan, ju Dia bilang sang Yairus, “Bu! Tanáng sa! Jang kawatir! Parcaya sang Tuhan Allah sa. Dia yang kasi salamat sang bu pung ana.” ");
INSERT INTO mkn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Waktu dong sampe di Yairus pung ruma, orang dong su ponu di situ. Dong ada manangis makarereu. Ju Yesus togor sang dong bilang, “Bosong barenti manangis su! Ini ana sonde mati. Dia cuma tidor sa!” Ma orang dong cuma katawa bengko mulu sang Dia sa, te dong yang su lia sandiri itu ana pung putus napas. Ais ju Yesus minta itu ana nona pung mama-bapa, Petrus, Yohanis, deng Yakobis, maso pi dalam sama-sama deng Dia. Yang laen dong Dia suru tunggu di luar sa. ");
INSERT INTO mkn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dong maso, ju Yesus pegang itu ana pung tangan, deng pange bilang, “Nona! Bangun suda!” ");
INSERT INTO mkn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Takuju sa, itu ana idop kambali, abis dia bangun memang. Ais Yesus suru itu nona pung mama bilang, “Kasi ini ana makan doo!” ");
INSERT INTO mkn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Itu nona pung mama-bapa heran mau mati. Ma Yesus kasi inga sang dong, ko jang kasi tasiar itu kabar pi orang dong. ");
INSERT INTO mkn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Satu kali, Yesus kumpul Dia pung ana bua dua blas orang. Ais Dia kasi sang dong kuasa ko bisa usir setan, deng bisa bekin bae orang saki dari dong pung panyaki macam-macam. ");
INSERT INTO mkn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dia utus sang dong, ko jalan kasi tau orang soꞌal Tuhan Allah pung pegang parenta. Dia ju utus sang dong ko bekin bae orang saki dong di mana-mana. ");
INSERT INTO mkn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma Dia kasi tau sang dong bilang, “Inga bae-bae! Bosong sonde usa bawa apa-apa di jalan. Jalan deng baju di badan sa. Sonde usa bawa tongkat, ko tas, ko bakál, ko doi. Baju ganti ju, sonde usa bawa! ");
INSERT INTO mkn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kalo bosong maso di satu kampong, ko ada orang yang mau tarima sang bosong, na, pi tenga di dong pung ruma sa. Jang bapili-pili ruma. Tenga di situ tarús, sampe bosong barangkat kasi tenga itu kampong. ");
INSERT INTO mkn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kalo bosong maso pi satu kampong, ais orang di situ sonde mau tarima deng sonde mau dengar sang bosong, na, angka kaki kasi tenga sang dong sa. Kalo bosong kaluar dari situ, bekin iko adat ko kabás buang abu dari bosong pung kaki. Kasi tau sang dong bilang, ‘Bosong sonde mau dengar, na, biar ko bosong pikol tanggong-jawab sandiri!’ ” ");
INSERT INTO mkn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ais ju itu ana bua dong jalan dari kampong pi kampong. Dong kasi tau orang dong soꞌal Tuhan Allah pung Kabar Bae. Ais dong ju bekin bae orang saki dong. ");
INSERT INTO mkn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Itu waktu, carita macam-macam soꞌal Yesus su sampe di raja Herodes Antipas pung talinga. Dengar itu carita dong, ju dia bingung, tagal ada barapa orang yang bilang, “Yesus tu, andia Yohanis Tukang Sarani yang su idop kambali.” ");
INSERT INTO mkn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ada saparu lai yang bilang, “Dia tu, baꞌi Elia yang su idop kambali.” Ada laen lai yang bilang, “Dia tu, satu dari Tuhan pung jubir dolu-dolu yang laen dong.” ");
INSERT INTO mkn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma Herodes inga bilang, “Tempo hari, beta su suru potong bekin putus Yohanis pung kapala. Dia su idop kambali, ko apa? Ais ini satu ni, sapa lai?” Ju dia usaha ko mau katumu muka deng Yesus. ");
INSERT INTO mkn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Satu waktu, ana bua yang Yesus su utus tu, dong pulang ko bakumpul ulang lai deng Dia. Dong kasi tau sang Dia samua yang dong su bekin ame. Ais Yesus dong jalan diam-diam pi satu tampa deka deng kampong Betsaida, ko dong pi barenti cape di situ. ");
INSERT INTO mkn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma orang banya dong dapa ciom Yesus dong mau pi mana, ais dong baꞌekor sang Dia pi. Jadi Yesus tarima bae sang dong, tarús Dia bekin bae orang saki dong samua, deng Dia carita sang dong soꞌal Tuhan Allah pung pegang parenta. ");
INSERT INTO mkn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Waktu su sore, ju Dia pung ana bua dua blas orang dong, bawa usul sang Yesus bilang, “Lebe bae Bapa suru ini orang dong pi kampong-kampong yang badeka di sini, ko bisa cari dong pung makanan sandiri. Deng biar dong pi cari tampa ko dong manumpang tidor. Te tampa sunyi bagini, karmana ko dong bisa dapa makan?” ");
INSERT INTO mkn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Ma Yesus manyao bilang, “Bagini! Biar bosong sa yang kasi makan sang dong!” Ma dong protes bilang, “Aweꞌ, Bapa lai! Mana bisa bagitu? Ini orang dong ni, ada lima ribu lebe! Itu cuma laki-laki sa, balóm itong parampuan deng ana-ana lai! Ais kotong pung roti cuma lima bua, deng ikan dua ekor sa. Kalo Bapa mau botong yang kasi makan ini orang banya dong, na, karmana ko botong bisa béli makan bam-banya kasi sang dong?!” Ju Yesus suru sang dong bilang, “Ator ini orang dong dudu bakumpul lima-lima pulu, satu kalompok.” ");
INSERT INTO mkn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ais dong pi ator bagitu. ");
INSERT INTO mkn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Waktu dong su dudu, ju Yesus ame itu roti lima bua deng ikan dua ekor. Ais Dia mangada pi langit, ko sambayang minta tarima kasi. Ais Dia kasi pica-pica itu roti deng ikan, ju Dia sorong kasi ana bua dong ko pi bagi-bagi kasi itu orang dong. ");
INSERT INTO mkn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dong samua makan sampe kinyang. Ais dong kumpul ame itu makanan sisa dong, sampe ponu dua blas bakul. ");
INSERT INTO mkn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Satu kali, Yesus ada sandiri ko sambayang di satu tampa. Ais Dia pung ana bua dong bakumpul deng Dia. Sambayang abis, ju Dia tanya sang dong bilang, “Bosong dengar-dengar orang omong bilang, Beta ni, sapa?” ");
INSERT INTO mkn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dong manyao bilang, “Ada yang bilang Bapa ni, Yohanis Tukang Sarani. Laen lai bilang, mangkali Bapa ni, baꞌi Elia. Kalo sonde, na, satu dari Tuhan Allah pung jubir dolu-dolu yang su idop kambali.” ");
INSERT INTO mkn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tarús Yesus tanya lai sang dong bilang, “Kalo iko bosong sandiri, na, bosong anggap Beta ni, sapa?” Ais ju Petrus manyao bilang, “Bapa ni, Kristus, andia Orang yang Tuhan Allah su tunju memang dari dolu!” ");
INSERT INTO mkn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ais Yesus larang sang dong ko jang kasi tau sapa-sapa bilang, Dia tu, Kristus. ");
INSERT INTO mkn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ais ju Yesus omong tamba bilang, “Beta ni, Manusia Tulen. Beta musti pikol sangsara barát macam-macam. Nanti orang Yahudi pung tua-tua adat, kapala agama pung bos-bos, deng guru agama dong sonde mau tarima bilang, Beta ni, Kristus. Ais nanti dong bunu bekin mati sang Beta. Memang Beta mati, ma dia pung lusa, beta idop kambali!” ");
INSERT INTO mkn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ais ju Dia kasi tau orang banya dong bilang, “Orang yang mau iko sang Beta, na, dia musti batahan iko tarús tiap hari. Dia musti lapás buang dia pung mau-mau sandiri. Dia musti iko tarús, biar orang ada mau bunu sang dia, sama ke orang pikol dia pung kayu palang ko pi di dia pung tampa mati. ");
INSERT INTO mkn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Te orang yang sadia mati tagal dia iko sang Beta, nanti dia dapa idop tarús deng Tuhan. Ma orang yang cuma mau idop buat dia pung diri sandiri sa, nanti dia tapisa buang dari Tuhan Allah. ");
INSERT INTO mkn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kalo orang dapa dunya pung isi samua, ma Tuhan Allah tola buang sang dia, na, dia dapa ontong apa? ");
INSERT INTO mkn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Beta ni, Manusia Tulen. Jadi orang yang malu iko sang Beta, deng malu pegang Beta pung ajaran, Beta ju nanti malu mangaku sang dia di Tuhan Allah pung muka waktu Beta kambali dari sorga. Te nanti Beta turun datang deng Bapa pung kuasa yang hebat, sama-sama deng Dia pung ana bua dari sorga. ");
INSERT INTO mkn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Beta kasi tau batúl-batúl sang bosong. Ada barapa dari bosong yang ada di sini ni, yang nanti dapa lia sandiri Tuhan pung pegang parenta, ais baru dong bisa mati.” ");
INSERT INTO mkn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Abis dia pung dalapan hari, ju Yesus ame bawa sang Petrus, Yohanis deng Yakobis pi nae di satu gunung ko mau sambayang. ");
INSERT INTO mkn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Waktu Yesus ada sambayang, ju Dia pung rupa baꞌoba, deng Dia pung pakean jadi puti mangkilat. ");
INSERT INTO mkn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Takuju sa, dua orang muncul datang. Dong dua tu, andia baꞌi Musa deng baꞌi Elia. Ju dong ada baꞌomong deng Yesus. ");
INSERT INTO mkn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Dong ju kantara hebat luar biasa. Dong tiga baꞌomong soꞌal Yesus pung mati nanti di Yerusalem. ");
INSERT INTO mkn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Itu waktu, Petrus deng dia pung kawan dua orang manganto sonde bisa-bisa, sampe dong tatidor. Waktu dong bangun, ju dong dapa lia Yesus ada badiri deng dua orang. Dong ju lia Yesus bacaya taráng. ");
INSERT INTO mkn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Waktu baꞌi Musa deng baꞌi Elia su mau kasi tenga sang Yesus, ju Petrus bingung, sonde tau dia mau bekin apa. Ju dia omong sambarang sa bilang, “Bos! Botong rasa enak di sini, é! Jadi lebe bae botong kasi bangun tiga laak. Satu kasi sang Bos, satu kasi baꞌi Musa, deng satu lai kasi baꞌi Elia.” ");
INSERT INTO mkn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma waktu dia masi baꞌomong bagitu, ada satu awan turun datang ko tutu sang dong. Ais Petrus dong jadi taku. ");
INSERT INTO mkn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ju dong dapa dengar suara dari dalam itu awan bilang, “Ini, Beta pung Ana yang Beta su pili memang! Dia omong, na, dengar bae-bae sang Dia!” ");
INSERT INTO mkn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Omong abis, ju Petrus dong cuma lia Yesus sandiri sa. Dong tiga tutu mulu ko sonde carita kasi sapa-sapa ju, apa yang dong dapa lia tu. Lama-lama baru dong buka mulu ko carita kasi orang laen. ");
INSERT INTO mkn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Dia pung beso, waktu Yesus deng Petrus dong turun dari itu gunung, orang banya dong datang katumu sang Yesus. ");
INSERT INTO mkn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ju ada satu orang batarea sang Dia bilang, “Bapa Guru, é! Tolong lia beta pung ana laki-laki satu biji doo! ");
INSERT INTO mkn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Te ada setan yang maen pegang ame sang dia, ko bekin dia batarea takuju, deng roꞌo-roꞌo sang dia sampe busa fafudik kaluar dari dia pung mulu. Itu setan ju maen pok-pak pok-pak sang dia, deng maen ganggu sang dia tarús-tarús. ");
INSERT INTO mkn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Beta su minta tolong sang Bapa pung ana bua ko usir kasi kaluar itu setan, ma dong sonde ontong sang dia!” ");
INSERT INTO mkn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dengar bagitu, ju Yesus masparak sang dong samua bilang, “Weh! Bosong sonde parcaya kalo Tuhan bisa bekin bae orang, ko? Bosong tu, dasar manusia yang sonde tau idop iko jalan lurus! Beta musti sama-sama deng bosong barapa lama, baru bosong mau parcaya sang Beta? Beta musti sabar sang bosong sampe kapan lai!?” Ais Dia bale omong deng itu bapa bilang, “Bawa lu pung ana datang sini su!” ");
INSERT INTO mkn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Waktu dong bawa itu ana pi Yesus, ju itu setan banting itu ana di tana, roꞌo-roꞌo barmaen sang dia. Ma Yesus parenta itu setan ko kaluar kasi tenga itu ana, ju itu ana bae memang. Ais Yesus sarakan itu ana pi dia pung bapa. ");
INSERT INTO mkn_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Orang yang dapa lia Tuhan pung kuasa yang hebat tu, dong samua jadi taheran-heran. ");
INSERT INTO mkn_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Waktu orang dong samua masi baꞌomong soꞌal tanda-tanda heran yang Yesus ada bekin, Dia kasi tau sang Dia pung ana bua dong bilang, ");
INSERT INTO mkn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Bosong tanda bae-bae Beta pung omong ni! Sonde lama lai, te orang mau jual buang sang Beta, Manusia Tulen ni. Ais dong sarakan Beta pi orang luar dong.” ");
INSERT INTO mkn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma Dia pung ana bua dong tabingung-bingung. Dong sonde mangarti dia pung maksud. Dong ju taku tanya dia pung arti apa. ");
INSERT INTO mkn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Satu kali, Yesus pung ana bua dong mulai bakanjar soꞌal sapa dari dong yang nanti jadi orang nomer satu. ");
INSERT INTO mkn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma Yesus tau apa yang dong bakanjar. Ju Dia pange satu ana kici, ais kasi badiri sang itu ana di Dia pung sablá. ");
INSERT INTO mkn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ais Dia kasi tau sang dong bilang, “Dengar bae-bae! Orang yang iko Beta ko layani orang kici sama ke ini ana, dia pung arti, itu orang ju ada layani sang Beta. Deng dia ju ada layani sang Beta pung Bapa di sorga yang utus sang Beta datang di ini dunya. Ada banya orang yang suka pandang enteng sang dong. Macam ke orang kasian, orang susa, orang tar bae, orang sial, deng orang kici dong. Naa! Orang yang suka layani orang macam bagitu yang Tuhan Allah anggap paling hebat.” ");
INSERT INTO mkn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ais Yohanis kasi tau sang Yesus bilang, “Bapa! Satu kali, botong lia satu orang usir kaluar setan deng subu Bapa pung nama. Jadi botong larang sang dia ko jang subu-subu pake Bapa pung nama, tagal dia tu bukan kotong pung orang.” ");
INSERT INTO mkn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma Yesus manyao bilang, “Sonde usa! Te orang yang sonde malawan sang kotong, dia pung arti, dia tu kotong pung kawan sandiri.” ");
INSERT INTO mkn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus tau bilang, Dia pung hari nae pi sorga su deka-deka. Ais Dia putus ko barangkat pi kota Yerusalem. ");
INSERT INTO mkn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dia utus orang ko jalan kamuka dari dong, ko biar dong bisa ator makan-minum. Ju dong maso pi satu kampong di propinsi Samaria ko mau urus tampa manumpang. ");
INSERT INTO mkn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma itu orang Samaria dong sonde mau tarima sang Yesus dong, tagal Dia ada mau jalan pi sémba sang Tuhan Allah di kota Yerusalem. ");
INSERT INTO mkn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Waktu Yakobis deng Yohanis dapa dengar itu orang Samaria dong pung bekin-bekin, ju dong babuju sang Yesus bilang, “Bos! Karmana kalo kotong minta Tuhan Allah kirim api datang dari langit ko bakar abis sang dong?” ");
INSERT INTO mkn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma Yesus mangada sang dong dua, ju togor bilang, “Sonde usa pikir bagitu.” ");
INSERT INTO mkn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ais dong jalan tarús pi kampong laen. ");
INSERT INTO mkn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Waktu dong ada jalan, ada satu orang omong sang Yesus bilang, “Bapa! Bapa pi mana sa, na, beta mau iko tarús deng Bapa!” ");
INSERT INTO mkn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma Yesus manyao bilang, “Bae, ju! Ma inga bagini. Samua orang deng binatang ada dong pung tampa tenga sandiri. Anjing utan kambali pi dia pung lobang. Burung kambali pi dia pung sarang. Ma Beta, Manusia Tulen ni, sonde ada pung ruma sandiri ko pulang di situ. Tampa alas kapala, ju sonde ada.” ");
INSERT INTO mkn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Satu kali, Yesus pange satu orang laen bilang, “Mari iko sang Beta, ko jadi Beta pung orang.” Itu orang manyao bilang, “Neu! Ma bagini, Bos. Biar beta pulang ko urus orang tua dong dolo. Kalo beta pung bapa su mati, na, baru beta iko.” ");
INSERT INTO mkn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma Yesus kasi tau sang dia bilang, “Bagini! Kasi tenga ko orang yang sonde ada pung parcaya sang Tuhan dong, urus dong pung orang mati. Ma bosong yang parcaya sang Tuhan, bosong pung tugas pi jalan kasi tau soꞌal Tuhan Allah pung pegang parenta.” ");
INSERT INTO mkn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ada satu orang lai bilang, “Bae ju, Bos! Beta mau iko sang Bos tarús. Ma kasi isin ko beta pi ciom bapisa deng beta pung kelu dong dolo, baru beta kambali iko sang Bos.” ");
INSERT INTO mkn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma Yesus kasi tau sang dia bilang, “Bagini! Kalo orang mulai bale tana, ais batasibu deng urusan laen sampe lupa tanam, na, dia pung kabón sonde jadi. Bagitu ju deng orang yang putus mau iko sang Beta, ma maen inga tarús dia pung idop dolo. Orang macam bagitu sonde ada guna jadi orang karjá di Tuhan Allah pung parenta.” ");
INSERT INTO mkn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ais itu, Yesus pili ame ana bua laen, 72 orang. Ais Dia bagi-bagi sang dong dua-dua orang, ko dong pi lebe dolo dari Dia di tampa-tampa yang nanti Dia mau datang. ");
INSERT INTO mkn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Dia utus sang dong bilang, “Ada orang bam-banya yang sama ke padi yang su kuning. Tenga tuan kabón kirim dia pung orang karjá ko datang koru sa. Jadi bosong musti sambayang minta Tuhan Allah kirim tamba Dia pung orang karjá ko kumpul ame orang-orang yang mau iko sang Beta. Tagal orang yang mau iko sang Beta tu, banya. Ma orang karjá dong cuma sadiki sa. ");
INSERT INTO mkn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sakarang bosong barangkat suda! Beta utus sang bosong ko pi di orang banya dong. Ma inga bagini. Bosong sama ke domba ana yang hati manis, yang pi teng-tenga anjing utan yang jahat dong. ");
INSERT INTO mkn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bosong sonde usa bawa doi, ko tas pakean, ko sandal lebe di jalan. Jang buang-buang waktu parcuma deng maen batogor orang di jalan. ");
INSERT INTO mkn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","8","Kalo bosong maso pi dalam satu kampong, bosong sonde usa pinda-pinda dari satu ruma pi ruma laen. Kalo orang tarima bae sang bosong di satu ruma, na, tenga di situ sa, sampe bosong barangkat dari itu kampong. Kalo bosong maso pi satu ruma, bosong musti minta ko Tuhan Allah kasi berkat sang orang di itu ruma. Kalo tuan ruma di situ tarima bae sang bosong, tantu Tuhan kasi tunju Dia pung hati bae sang itu isi ruma dong. Ma kalo dong sonde mau tarima sang bosong, na, biar ko Tuhan kasi tunju Dia pung hati bae sang bosong sandiri sa. Kalo bosong maso di satu ruma ko, satu kampong ko, makan-minum apa sa yang dong kasi. Tarima deng sanáng hati, te pantas kalo dong kasi bosong bagitu ko ganti bosong pung karingat. ");
INSERT INTO mkn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bekin bae dong pung orang saki. Deng kasi tau sang dong bilang, ‘Tuhan Allah pung parenta su ada di muka idong!’ ");
INSERT INTO mkn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma ada kampong ju yang dia pung orang dong sonde mau tarima sang bosong. Kalo dong bekin bagitu sang bosong, na, pi badiri di kampong pung jalan ko angka omong bilang, ");
INSERT INTO mkn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Dengar bae-bae! Botong su datang bawa Tuhan pung Kata-kata kasi sang bosong, ma bosong sonde toe sadiki ju. Jadi botong sakarang kabás buang ini kampong pung abu dari botong pung kaki, ko jadi tanda bilang, nanti bosong tanggong risiko sandiri! Ma inga bae-bae! Tuhan Allah pung parenta su ada di muka idong!’ ");
INSERT INTO mkn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Bosong tau kota Sodom pung jahat, wuang? Beta kasi tau, é! Nanti pas di hari kiamat, Tuhan kasi hukum orang yang tola buang sang bosong tu, jao lebe barát dari orang Sodom dong!” ");
INSERT INTO mkn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus omong tamba lai bilang, “Bosong yang ada di kampong Korasin deng kampong Betsaida! Awas, é! Calaka kaná sang bosong! Beta su bekin tanda heran macam-macam di bosong pung batang idong, ma bosong sonde mau parcaya sang Tuhan. Padahal bosong ni, orang Yahudi yang mangaku kanál sang Dia. Ma andekata itu tanda-tanda heran yang Beta bekin di bosong pung kampong jadi kaná di kota Tirus deng kota Sidon, tantu bagini lama orang di situ dong su tobat memang, deng su kasi tenga dong pung sala-sala ko bale iko sang Tuhan. Deng dong ju tantu pake pakean duka, deng taro abu di atas kapala ko jadi tanda bilang, dong ada manyasal deng dong pung sala-sala dong. Padahal orang Tirus deng orang Sidon dong ni, bukan orang Yahudi yang mangaku kanál sang Tuhan. ");
INSERT INTO mkn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Batúl! Bosong lia sa! Nanti kalo Tuhan putus samua orang dong pung parkara, orang Tirus deng orang Sidon pung hukuman masi jao lebe ringan dari bosong pung hukuman. ");
INSERT INTO mkn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bosong orang kampong Kapernaum! Awas! Bosong jang pikir bilang, nanti Tuhan angka nae sang bosong maso pi sorga. Sonde! Nanti Tuhan lempar buang sang bosong maso pi naraka! ");
INSERT INTO mkn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Inga bae-bae! Te orang yang dengar sang bosong, sama sa deng dengar sang Beta. Deng orang yang sonde mau dengar sang bosong, sama sa deng sonde mau dengar sang Beta. Tamba lai, orang yang sonde mau dengar sang Beta tu, sama sa deng dia sonde mau dengar sang Tuhan Allah, yang su utus sang Beta datang di ini dunya.” ");
INSERT INTO mkn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Waktu itu 72 orang utusan datang kambali, dong pung hati ada babunga-bunga. Ju dong lapor sang Yesus bilang, “Awii! Pung hebat lai! Waktu botong pake Bos pung nama ko usir setan dong, itu setan dong dengar sang botong, ais ju dong kaluar memang! Talalu!” ");
INSERT INTO mkn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ju Yesus manyao sang dong bilang, “Batúl! Waktu bosong bekin bagitu, Beta ada lia Tuhan Allah lempar buang sang setan deng dong pung bos dari langit, sama ke kilat yang kaluar kiri-kanan dari langit! ");
INSERT INTO mkn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Inga, é! Setan dong pung bos tu, kotong pung musu. Deng dia ada pung kuasa ju! Ma Beta su kasi kuasa sang bosong ko kasi pata dia pung kuasa. Deng andekata bosong ada inja kaná ular babisa, ko, kalajingking, na, bosong sonde kaná apa-apa. Sonde ada yang bisa bekin calaka sang bosong. ");
INSERT INTO mkn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bosong pung hati babunga, tagal setan dong dengar sang bosong. Bae ju, ma itu hal kici sa! Lebe bae bosong pung hati babunga, tagal Tuhan su tulis ame bosong pung nama ko jadi Dia pung warga yang maso sorga.” ");
INSERT INTO mkn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Itu waktu, Tuhan pung Roh yang Barisi bekin Yesus pung hati babunga. Ais Dia puji Tuhan bilang, “Bapa! Bapa yang jadi Bos Bésar di langit deng bumi. Beta minta tarima kasi bam-banya, tagal Bapa tutu ame ini hal dong dari orang yang anggap diri pintar deng yang tinggi hati dong. Ma Bapa buka ini hal samua kasi ana-ana kici dong, deng orang yang randá hati dong. Batúl, Bapa! Te itu yang bekin Bapa pung hati sanáng!” ");
INSERT INTO mkn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ais Yesus kasi tau sang orang banya dong bilang, “Dengar ó! Beta pung Bapa di sorga su kasi samua kuasa sang Beta. Yang tau batúl bilang, Beta ni, sapa, andia cuma Bapa sa. Deng yang tau batúl bilang, Bapa tu, sapa, cuma Bapa pung Ana sa, andia Beta. Deng Beta pili orang laen, ko kasi tau sang dong, ko biar dong ju kanál sang Dia.” ");
INSERT INTO mkn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ais Yesus bale mangada sang Dia pung ana bua dong, deng kasi tau sang dong sandiri bilang, “Bosong ontong batúl, tagal bosong su lia Tuhan pung kuasa. ");
INSERT INTO mkn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Raja-raja deng jubir dolu-dolu dong rindu mau lia apa yang bosong su dapa lia, ma dong sonde bisa. Dong ju rindu mau dengar apa yang bosong su dapa dengar, ma dong sonde bisa.” ");
INSERT INTO mkn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Satu kali, ada satu ahli hukum Yahudi badiri ko mau hiki sang Yesus. Dia tanya bilang, “Bapa Guru! Tolong kasi tau doo! Beta musti bekin apa, ko biar beta tau beta bisa dapa idop tarús sama-sama deng Tuhan di sorga?” ");
INSERT INTO mkn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus manyao bilang, “Baꞌi Musa tulis apa soꞌal ini hal? Lu pung mangarti karmana sang dia?” ");
INSERT INTO mkn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Itu orang kasi tau bilang, “Dia ada tulis bilang: ‘Lu musti sayang sang Tuhan Allah, lebe dari samua, te Dia yang hak parenta sang lu. Tagal itu, lu musti salalu rindu sang Dia, karjá karás ko iko Dia pung mau, deng mangarti sang Dia.’ Ju ada tulis bilang, ‘Lu musti sayang lu pung sodara, sama ke lu sayang lu pung diri sandiri.’ ” ");
INSERT INTO mkn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus balas bilang, “Batúl! Kalo lu bekin iko bagitu, lu idop deng Tuhan tarús-tarús.” ");
INSERT INTO mkn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma itu orang ada mau bekin diri ke orang alim sa. Ais dia tanya sang Yesus bilang, “Ma beta pung ‘sodara’ tu, yang mana?” ");
INSERT INTO mkn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ju Yesus manyao bilang, “Bagini! Beta mau kasi satu umpama. Nanti lu kasi tau, mana yang batúl-batúl ‘sodara’. Dia pung carita bagini: Ada satu orang Yahudi barangkat dari kota Yerusalem, jalan turun pi Yeriko. Ma takuju sa, ada tukang rampok dong datang korfei barmaen sang dia. Dong papoko sang dia, ais rampas ame dia pung doi deng dia pung pakean samua. Tarús dong lempar buang sang dia di pinggir jalan, ais jalan kasi tenga sang dia. Itu orang su amper mau mati sa. ");
INSERT INTO mkn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma sonde sangka-sangka, te ada satu kapala agama Yahudi yang jalan turun lewat di situ ju. Ma waktu dia dapa lia ada orang luka-luka yang malenggang di pinggir jalan, dia sonde barenti ko tolong sang dia. Dia serong pi sablá ko jalan tarús sa. ");
INSERT INTO mkn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sonde lama, ju ada satu orang laen yang lewat di situ. Dia tu, orang dari suku Lewi yang biasa bantu di Tuhan Allah pung Ruma Sambayang Pusat. Waktu dia dapa lia itu orang talempar di pinggir jalan, dia pi lia deka-deka sa, ma sonde tolong sang dia. Tarús dia serong pi sablá ko jalan tarús. ");
INSERT INTO mkn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Sonde lama lai, ada satu orang dari daꞌera Samaria lewat di situ deng dia pung binatang keledai. Kotong samua tau bilang, orang Yahudi biasa lia deng sablá mata sang orang Samaria dong. Naa, waktu ini orang Samaria lia itu orang yang kaná rampok tu, ju dia jato kasian sang dia. Dia datang deka-deka ko mau tolong itu orang. Dia poꞌa anggor ko kasi barisi itu orang pung luka-luka dong, ais dia taro minya pi. Tarús farbán bae-bae sang dia, ju angka kasi nae pi atas dia pung keledai. Ais dia bawa itu orang pi sampe di kota. Tarús dia kasi manumpang itu orang di losmen, deng urus bae-bae sang dia. ");
INSERT INTO mkn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Dia pung beso, itu orang Samaria pi kasi panjar doi, dua perak di tuan losmen, deng kasi tau bilang, ‘Pake ini doi ko urus bae-bae itu orang saki sampe bae. Kalo sonde cukup, na, tolong pake tahan bapa pung doi doo. Waktu beta bale lai, nanti beta ganti bapa pung doi samua.’ ” ");
INSERT INTO mkn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus pung umpama sampe di situ sa. Ais Dia tanya sang itu ahli hukum bilang, “Iko lu, mana yang batúl-batúl ‘sodara,’ buat itu orang yang kaná rampok tadi tu?” ");
INSERT INTO mkn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Itu orang manyao bilang, “Tantu sa, itu orang yang jato kasian sang dia.” Yesus bilang, “Batúl, bu! Pi su, ko bekin iko.” ");
INSERT INTO mkn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Ais itu, Yesus deng Dia pung ana bua dong jalan tarús pi Yerusalem. Ju dong singga di satu kampong. Di situ ada dua basodara, nama Marta deng Maria. Marta minta ko Yesus dong manumpang di dia pung ruma. Ais dong tenga tahan di situ. Waktu Yesus dudu ko ajar orang dong, Marta batasibu urus makan-minum di dapur. Ma dia pung adi Maria, ada dudu deka-deka di Yesus pung kaki, ko dengar Dia pung omong. Sonde lama, ju Marta maso datang ko mangomel di Yesus bilang, “Bapa, é! Karmana, ó! Beta ada batasibu satenga mati urus makan-minum, baru beta pung adi dudu ena-ena di sini sa. Tolong doo! Suru sang dia bantu beta sadiki di dapur!” ");
INSERT INTO mkn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma Tuhan Yesus manyao bilang, “Maꞌa. Lu ni, batasibu deng pikir macam-macam. ");
INSERT INTO mkn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bae, ma ada satu hal yang lebe pantíng sakarang. Deng dia dudu dengar Beta pung Kata-kata, Mia su pili yang paling bae. Orang sonde bisa rampas buang itu Kata-kata dari dia.” ");
INSERT INTO mkn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Satu kali, Yesus pi sambayang. Sambayang abis, ju Dia pung ana bua satu datang ko minta bilang, “Bapa! Yohanis Tukang Sarani su ajar dia pung ana bua dong, ko dong tau sambayang. Botong minta ko Bapa ju ajar sang botong sambayang dolo!” ");
INSERT INTO mkn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ais Yesus bilang, “Bae ju! Sambayang pake conto bagini: Bapa! Bapa pung nama paling barisi. Biar samua orang angka nae tinggi-tinggi Bapa pung nama yang hebat. Biar Bapa jadi Raja kasi samua orang. ");
INSERT INTO mkn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bapa tolong kasi botong makanan yang cukup tiap hari. ");
INSERT INTO mkn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Botong minta Bapa lupa buang botong pung sala-sala dong, sama ke botong ju lupa buang orang pung sala yang dong bekin-bekin sang botong. Bapa jaga ko botong sonde bekin jahat.” ");
INSERT INTO mkn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ais Yesus ajar tamba sang dong soꞌal sambayang. Dia pake umpama bilang, “Andekata tenga malam, ada kawan datang dari jao, ko manumpang di lu pung ruma. Ma lu sonde ada apa-apa ko kasi dia makan. Ais lu pi di lu pung kawan laen pung ruma, ko noki-noki dari luar bilang, ‘Bu, é! Kasi tahan beta roti tiga balok doo! Te beta ada tamu di ruma, ma botong ada karíng-karíng sa, ni! Bu, tolong doo! Tiga balok sa! Nanti be ganti!’ ");
INSERT INTO mkn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kira-kira nanti lu pung kawan manyao bale bilang, ‘Ko bu lai, ju! Orang ada tidor sonu, ma bu datang ganggu lai! Pintu dong su takonci mati ni! Ana-ana dong su tidor sonu. Jang mara, é! Ma laen kali sa, bu!’ ");
INSERT INTO mkn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Biar bagitu ju, ma inga bae-bae. Biar itu orang sonde bangun ko kasi sang lu tagal lu dia pung kawan, ma kalo lu maen noki-noki tarús, tantu dia bangun ko kasi. ");
INSERT INTO mkn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Bagitu ju, deng sambayang. Minta tarús sang Tuhan; nanti Dia kasi. Cari tarús; nanti Dia kasi tunju jalan. Eki tarús; nanti Dia buka pintu. ");
INSERT INTO mkn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Te samua orang yang minta tarús sang Tuhan Allah, nanti tarima. Yang cari tarús, nanti dapa. Yang eki tarús, nanti Dia buka pintu. ");
INSERT INTO mkn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bosong pikir coba! Dapa di mana, ada bapa, yang kalo dia pung ana minta ikan, na, dia kasi ular? ");
INSERT INTO mkn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ko, kalo ana minta talór, dia kasi kalajingking? Sonde mungkin, to? ");
INSERT INTO mkn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Manusia pung dasar memang jahat. Ma bosong pung Bapa di sorga tu, Dia pung dasar bae batúl. Jadi, kalo manusia yang jahat macam bosong sa, suka kasi barang yang bae sang bosong pung ana-ana dong, apalai Bapa! Dia bukan cuma kasi apa yang bosong parlú sa, ma lebe dari itu, Dia kasi Dia pung Roh yang Barisi sang orang yang minta sang Dia.” ");
INSERT INTO mkn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Satu kali, Yesus usir kasi kaluar setan dari orang bisu satu. Ais, itu orang mulai omong kambali. Orang dong di situ taheran-heran. ");
INSERT INTO mkn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma ada ju yang bilang, “Memang sa, Dia bisa usir setan! Ko Dia dapa kuasa dari setan dong pung bos, andia Balsebul na.” ");
INSERT INTO mkn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Orang laen dong mau coba sang Yesus. Ais dong minta ko Dia bekin satu tanda heran lai ko kasi tunju sang dong bilang, Dia pung kuasa memang dari Tuhan. ");
INSERT INTO mkn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma Yesus tau memang dong pung otak kotor. Ju Dia omong bilang, “Kalo dalam satu negara, dia pung rakyat dong bamusu, tantu itu negara jadi ancor-ancor. Bagitu ju, kalo dalam satu ruma, dia pung isi ruma dong ada maen idop bakanjar satu deng laen, na, tantu itu ruma tangga su sonde jadi doi lai! ");
INSERT INTO mkn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jadi, kalo setan dong maen bamusu deng maen baꞌusir satu deng satu, na, dong pung bos su sonde bisa pegang parenta lama-lama lai! Jadi sonde maso di otak, kalo bosong bilang Beta ada pake setan pung kuasa ko usir setan sandiri! ");
INSERT INTO mkn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Inga, é! Bosong pung orang dong ju tau usir setan. Dong pake kuasa dari setan, ko? Sonde, to! Jadi bosong jang omong sambarang bilang, Beta ada pake setan pung kuasa ko usir setan. Nanti bosong pung orang sandiri yang putus bilang, apa yang bosong tudu tu, sala. ");
INSERT INTO mkn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ma kalo Beta batúl-batúl usir setan pake Tuhan Allah pung kuasa, itu kasi tunju bilang, Tuhan pung parenta su ada di bosong pung muka idong. Ada, ma tingka ke bosong sonde tau. ");
INSERT INTO mkn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kalo geng satu ada pake sanjata kiri-kanan, ko jaga bae-bae dia pung ruma, tantu dia pung barang samua aman-aman sa. ");
INSERT INTO mkn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma nanti, ada yang lebe kuat dari dia, datang kasi kala deng rampas ame itu orang pung sanjata dong. Ais itu, dia ju raꞌu bawa itu orang pung harta dong ko bagi-bagi kasi dia pung ana bua dong. Su bagini lama itu geng partama parcaya dia pung sanjata. Ma sakarang dia su sonde bisa harap itu sanjata dong lai. ");
INSERT INTO mkn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Inga bae-bae! Orang yang sonde bapartei deng Beta, dia tu, Beta pung musu. Deng orang yang sonde babantu deng Beta pung karjá, na, dia tu, bekin kaco sa.” ");
INSERT INTO mkn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus omong tamba lai bilang, “Kalo kotong usir setan kaluar dari satu orang, dia pi tampa sunyi ko cari tampa barenti cape. Tagal dia sonde dapa tampa yang cocok, ju dia pikir bilang, ‘Ee! Sonde dapa tampa bagini, lebe bae beta pulang pi tenga kambali di itu orang yang dolu tu.’ ");
INSERT INTO mkn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ais dia kambali, ju dia katumu itu tampa tu, su sapu barisi deng taꞌator bae-bae. ");
INSERT INTO mkn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ju itu setan pi pange dia pung kawan tuju setan, yang lebe jahat lai dari dia. Ais dong samua pi tenga di itu orang, ju karoyok sang dia. Jadi sakarang itu orang pung idop lebe calaka lai.” ");
INSERT INTO mkn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Waktu Yesus masi baꞌomong deng orang banya tu, ada satu parampuan di situ batarea bilang, “Pak pung mama ontong bésar, tagal dia yang dapa barana sang Pak, deng dapa kasi susu sang Pak!” ");
INSERT INTO mkn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesus manyao bilang, “Batúl, mama! Ma yang lebe ontong lai, andia orang yang pasang talinga ko dengar Tuhan Allah pung Kata-kata, deng bekin iko!” ");
INSERT INTO mkn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Waktu Yesus masi baꞌomong, orang banya dong makarubu kuliling sang Dia. Ju Dia angka omong bilang, “Orang sakarang dong ni, cuma tau bekin jahat sa. Dong maen minta tarús ko Beta bekin tanda heran kasi sang dong, ko dong tau Beta ni, batúl-batúl Tuhan pung orang. Padahal dolu Tuhan su kasi tanda heran sang dong pake Dia pung jubir Yunus. Itu su cukup! ");
INSERT INTO mkn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dolu-dolu, Yunus kasi tau orang kota Niniwe bilang, dong musti tobat dolo. Naa, apa yang jadi di Yunus dolu, jadi tanda kasi sang dong bilang, Tuhan Allah yang utus sang dia. Bagitu ju deng Beta, Manusia Tulen ni. Beta datang kasi tau sang bosong, ko bosong musti tobat dolo. Deng apa yang nanti jadi di Beta, ju jadi tanda kasi orang sakarang bilang, memang Tuhan Allah yang utus sang Beta. ");
INSERT INTO mkn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nanti di hari kiamat, kalo Tuhan badiri jadi Hakim, nanti ratu dari salatan sana idop kambali, ju badiri jadi saksi. Dia tunju jari ko tudu sang bosong samua yang idop sakarang ni bilang, ‘Bosong samua ni, bodo, é!’ Te dolu itu ratu datang dari jao-jao ko lia deng mata kapala sandiri raja Soleman pung pintar. Padahal sakarang ada Orang di bosong pung teng-tenga yang lebe hebat dari raja Soleman. Ma bosong sonde mau ame pusing sadiki ju sang Dia! ");
INSERT INTO mkn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Deng bukan dia sandiri sa! Nanti orang dari Niniwe dong ju bangun badiri ko tunju jari sang bosong yang idop sakarang ni bilang, ‘Bosong samua, bodo!’ Dong omong bagitu, tagal tempo hari, waktu Yunus pi kasi tau Tuhan pung mau sang dong, ju dong tobat memang. Padahal sakarang Orang yang lebe hebat dari Yunus ada di bosong pung teng-tenga, ma bosong sonde mau tobat sadiki ju!” ");
INSERT INTO mkn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus sambung lai Dia pung omong bilang, “Orang kasi manyala lampu teꞌoek, ais taro di tampa yang tinggi, ko biar dia bekin taráng itu kamar kasi samua orang yang maso di situ. Sonde ada orang yang kasi manyala lampu, ais tutu ame deng bakul, ko, sambunyi mati sang dia. Itu sonde ada guna apa-apa! ");
INSERT INTO mkn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Bosong pung mata ju sama ke lampu. Dia bekin taráng bosong pung dalam hati. Kalo mata galáp, orang lia samua-samua deng hati jahat. Ma kalo mata taráng, orang lia samua-samua deng hati bae. ");
INSERT INTO mkn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Usaha ko taráng yang ada di bosong pung hati tu, jadi taráng sakali, sama ke matahari pung taráng. Taráng di bosong pung hati tu, jang sama ke bulan pung taráng, yang cuma kasi lia bayang-bayang sa. ");
INSERT INTO mkn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kalo bosong pung hati taráng, sampe sonde ada satu nat ju yang galáp, tantu bosong pung idop samua ju taráng, sama ke ada lampu bésar yang kasi taráng bosong pung idop.” ");
INSERT INTO mkn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus omong abis, ju ada satu orang dari partei agama Farisi undang sang Dia ko datang makan di dia pung ruma. Sampe di sana, ju Yesus maso pi dalam ruma ko dudu di meja makan. ");
INSERT INTO mkn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma tuan ruma jadi heran lia Yesus dudu makan deng sonde pake cuci tangan lebe dolo, iko orang Farisi pung atoran. ");
INSERT INTO mkn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ais Yesus kasi tau sang dia bilang, “Bosong orang Farisi dong hebat! Bosong pegang karás bosong pung atoran agama! Bosong inga kasi barisi piring deng galás pung luar sampe mangkilat, ma bosong sonde inga ko kasi barisi bosong pung dalam hati yang kamomos tu, yang jahat deng rakus mati pung! ");
INSERT INTO mkn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ngali, é! Jang lupa. Tuhan Allah yang bekin bagian luar. Dia ju yang bekin bagian dalam. ");
INSERT INTO mkn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ma ada lebe bae, bosong kasi sang orang kasian dong dari apa yang bosong punya, ko biar bosong bisa barisi di Tuhan pung muka. ");
INSERT INTO mkn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bosong orang Farisi dong! Bosong nanti dapa calaka! Soꞌal kasi Tuhan satu bagian dari sapulu bagian, bosong maen baꞌitong samua-samua, kici-bésar. Sampe bosong pung bumbu kici ana dari kabón ju, bosong baꞌitong mati! Ma bosong sonde toe hal yang pantíng dong. Soꞌal parkara sayang sang Tuhan Allah, deng parkara adil, bosong lupa buang sang dong sa! Memang kotong musti tatáp kasi sang Tuhan Dia pung bagian, ma jang lupa hal-hal yang lebe pantíng dong. ");
INSERT INTO mkn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bosong nanti dapa calaka! Te bosong suka cari tampa yang paling bae dalam ruma sambayang, deng suka cari hormat di tampa-tampa umum. ");
INSERT INTO mkn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bosong nanti dapa calaka! Te bosong sama ke kubur yang dia pung tana su rata. Orang jalan di situ, ma dong sonde tau bilang, di situ ada kubur, tagal kubur pung tana di atas barisi, ma dia pung dalam busuk. Padahal iko kotong pung adat, orang yang inja kubur bekin kotor dia pung diri, jadi sonde pantas maso pi ruma sambayang. Bosong orang Farisi dong sama ke itu kubur! Di luar-luar bosong conto ke barisi mati pung. Ma bosong pung dalam hati ada ponu deng hal busuk.” ");
INSERT INTO mkn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ada satu ahli hukum Yahudi di situ, sambar sang Yesus pung omong bilang, “Bapa Guru! Bapa pung kata-kata tadi tu, puku kaná sang botong ju!” ");
INSERT INTO mkn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ais Yesus balas sang dia bilang, “Batúl! Bosong ahli hukum Yahudi dong, biar ko bosong ju dapa calaka! Bosong bukan bantu orang deng bekin ringan dong pung idop, ma bosong bekin tamba susa sang don