﻿USE sofia;
DROP TABLE IF EXISTS sofia.mkl_vpl;
CREATE TABLE mkl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mkl_vpl WRITE;
INSERT INTO mkl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dimii nyɑɑnzei Jesu Kirisi ŋɑ wee. Jesu Kirisii í jɛ tɔkui Dɑvidi, nɔ Dɑvidi mɔ wɑ jɛ tɔkui Aburɑhɑmu. ");
INSERT INTO mkl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aburɑhɑmui í bí Izɑɑki, Izɑɑki mɔi í bí Zɑkɔbu. Zɑkɔbu mɔi í bí Zudɑ do iɡbɑ̃ɛ do ifɔɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zudɑ do Tɑmɑɑ ɑboɛ ɑŋɑ mɔi ɑ̀ bí Fɑrɛsi do Zɑrɑ. Fɑrɛsi mɔ í bí Esiromu. Esiromu mɔ í bí Arɑmu. ");
INSERT INTO mkl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arɑmu mɔ í bí Aminɑdɑbu. Aminɑdɑbu mɔ í bí Nɑsɔ̃ɔ. Nɑsɔ̃ɔ mɔ í bí Sɑlɑmɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sɑlɑmɔɔ do Rɑhɑbu ɑboɛi ɑ̀ bí Boɑzi. Boɑzi mɔ do Rutu ɑboɛi ɑ̀ bí Obɛdi. Obɛdi mɔ í bí Izɑi. ");
INSERT INTO mkl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Izɑi mɔ í bí Dɑvidi iyi í nɑ í jɛ ilɑɑluu. Dɑvidiu mɔ í bí Sɑlomɔɔ. Iyei Sɑlomɔɔui í jɛ ɑboi Urii iyi Dɑvidi í sou. ");
INSERT INTO mkl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sɑlomɔɔ mɔ í bí Roboɑmu. Roboɑmu mɔ í bí Abiɑ. Abiɑ mɔ í bí Azɑfu. ");
INSERT INTO mkl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Azɑfu mɔ í bí Zozɑfɑti. Zozɑfɑti mɔ í bí Zorɑmu. Zorɑmu mɔ í bí Oziɑsi. ");
INSERT INTO mkl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziɑsi mɔ í bí Zoɑtɑmu. Zoɑtɑmu mɔ í bí Akɑzi. Akɑzi mɔ í bí Ezekiɑ. ");
INSERT INTO mkl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiɑ mɔ í bí Mɑnɑsee. Mɑnɑsee mɔ í bí Amɔɔ. Amɔɔ mɔ í bí Zoziɑsi. ");
INSERT INTO mkl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zoziɑsi mɔ í bí Zekoniɑ do ifɔɛ ŋɑ si wɑɑti iyi ilɑɑlui Bɑbilɔni, ilu nlɑu, í jɛ inɛi Izirɛli ŋɑ iɡũ í nɛò ŋɑ si ilɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Si ɑnyii iyi ɑ̀ nɛò ŋɑ ikpɑ Bɑbilɔni ŋɔi Zekoniɑ í bí Sɑlɑtɛli, nɔ Sɑlɑtɛli mɔ í bí Zorobɑbɛli. ");
INSERT INTO mkl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Nɔ Zorobɑbɛli mɔ í bí Abiudu. Abiudu mɔ í bí Eliɑkimu. Eliɑkimu mɔ í bí Azɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔɔ mɔ í bí Sɑdɔku. Sɑdɔku mɔ í bí Akimu. Akimu mɔ í bí Eliudu. ");
INSERT INTO mkl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudu mɔ í bí Eleɑzɑɑ. Eleɑzɑɑ mɔ í bí Mɑtɑni. Mɑtɑni mɔ í bí Zɑkɔbu. ");
INSERT INTO mkl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nɔ Zɑkɔbu mɔ í bí Zozɛfu mɔkɔi Mɑɑri, nɔ Mɑɑri mɔi í jɛ iyei Jesu iyi ɑ̀ yɑ kpe Kirisi. ");
INSERT INTO mkl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bɛɛbɛi si dimi nŋɑu hɑi wɑɑtii Aburɑhɑmu wɑ hee ku nɑɑ si wɑɑtii Dɑvidi, tɔku ikɑ̃ ikɑ̃ mɑɑtɛ̃ɛi í wɛɛ. Hɑi bi Dɑvidi mɑ́ ku nɑɑ si wɑɑti iyi ɑ̀ bɔò ŋɑ Bɑbilɔni tɔku ikɑ̃ ikɑ̃ mɑɑtɛ̃ɛi í wɛɛ. Si ɑnyiɛ, hɑi wɑɑti iyi ɑ̀ bɔò ŋɑ Bɑbilɔniu ku nɑɑ si wɑɑti iyi ɑ̀ bí Jesu iyi ɑ̀ yɑ kpe Kirisi tɔku ikɑ̃ ikɑ̃ mɑɑtɛ̃ɛi í wɛɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yɑɑse bɛi ɑ̀ bíò Jesu Kirisi wee. Hɑi wɑɑti iyi Mɑɑri í wɛɛ mudɛ̃ɛi ɑ̀ muɑ Zozɛfu. Ammɑ hee ɑ mɑɑ tɔtɔɔ sɛ̃ɛ Mɑɑri í nɛ ɑsĩ do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zozɛfu mɔkɔɛu wee inɛ dee deei. Kù bi nŋu ku dɑsi Mɑɑri ɑnyɔ si bɑntumɑ. Nɑ ŋɔi í ce í dɑsi idɔ nŋu ku kɔsiɛ si ɑsii. ");
INSERT INTO mkl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Si bɛi wɑ lɑsɑbu bɛɛbɛ ŋɔi ɑmɑlekɑi Aɔ̃ Lɑfɛ̃ɛ í nɑɑ í sɔ̃ɔ si ɑlɑ í ni, Zozɛfu, ɑwɔ tɔkui Dɑvidi ilɑɑluu, mɑɑ̀ ce njoi i so Mɑɑri, mudɛ̃ɛ iyi ɑ̀ muɛu. Dɑsiɛ kpɑsɛ̃. Asĩ iyi í nɛu bɛ, do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Á bí ɑmɑ inɛmɔkɔ nɔ i sɔɔ Jesu. Nŋui ɑ́ fɑɑbɑ inɛɛ ŋɑ hɑi si dulum du ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mii ŋɑu ihɛ̃ fei í cei ku bɑ ide iyi Aɔ̃ Lɑfɛ̃ɛ í tɑko í sɔ̃ wɑlii Ezɑi ku sisiɑ inɛ ŋɑu ku kɔ̃, ");
INSERT INTO mkl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","iyi í ni, Mudɛ̃ɛ ɡɔ iyi kù mɑ̀ mɔkɔ ɑ́ nɑ ku nɛ ɑsĩ. Á bí ɑmɑ inɛmɔkɔ, Nɔ ɑ kpoo Emɑnuɛli. Yɑɑsei iriui í jɛ Ilɑɑɔ̃ í wɛɛ do ɑwɑ. ");
INSERT INTO mkl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iyi Zozɛfu í jĩ ŋɔi í ce bɛi ɑmɑlekɑu í sɔ̃ɔ, í dɑsi Mɑɑri kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ammɑ ɑŋɑò ɑ kù tɔtɔɔ sɛ̃ɛ hee í koo í bíò ɑmɑ inɛmɔkɔɛ. Nɔ Zozɛfu í sɔɔ Jesu. ");
INSERT INTO mkl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","À bí Jesui Betelehɛmu si ilɛi Zudee si wɑɑtii ɑmɑnlu Herodu. Si ɑnyii kubíɛ woo mɑ̀ yɑɑsei ɑndɑiyɑ ɡɔ ŋɑ ɑ̀ nɑɑ Zeruzɑlɛmu hɑi nunui dɑɑkɔ, ");
INSERT INTO mkl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nɔ ɑ̀ bee ɑ̀ ni, iwoi ilɑɑlui Zuifu ŋɑ iyi ɑ̀ bí nsɛiu í wɑ. Hɑi nunui dɑɑkɔi ɑ̀ yɛ ɑndɑiyɑɛ í fitɑ, ŋɔi ɑ̀ nɑɑ ku tɔɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Iyi ɑmɑnlu Herodu í ɡbɔ ideu, ŋɔi inɔɛ í fɔ, bɛɛbɛ mɔi inɛi Zeruzɑlɛmu ŋɑu fei inɔ nŋɑ í fɔ. ");
INSERT INTO mkl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ŋɔi í tɔtɔɔ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ fei nɔ í bee ŋɑ tenɡi bii ɑ̀ ni ɑɑ bí Inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, Betelehɛmui si ilɛi Zudee domi bɛɛbɛi wɑlii Misee í tɑko í kɔɔ wo, ");
INSERT INTO mkl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","í ni, Ilɑɑɔ̃ í ni, Iŋɛ inɛi Betelehɛmu ŋɑ, si ilɛi Zudee, Ntɔ ntɔ, ilu nŋɛ kù kere si ilu nlɑi Zudee ŋɑ fei, Si nɑ iyi í jɔ̀ hɑi si ilu nŋɛi ilɑɑluu ɑ́ fitɑ Inɛ iyi ɑ́ ɡbɑ̃ inɛi Izirɛli, inɛm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ŋɔi Herodu í jɔ̀ ɑ̀ kpe woo mɑ̀ ŋɑu do ɑsii, í bee ŋɑ si wɑɑti iyi ɑndɑiyɑu í fitɑ dee dee. Nɔ ɑ̀ sɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Iyi í ɡbɔ bɛɛbɛ nɔ í sɔ̃ ŋɑ í ni ɑ bɔ Betelehɛmu ɑ koo ɑ bee yɑɑsei ɑmɑu wɑ sɑ̃ɑ sɑ̃ɑ. Bii ɑ̀ yɔɔ nɔ ɑ nyi wɑ ɑ nɑɑ ɑ sɔ̃ nŋu ku bɑ nŋu mɔ nŋu koo ɡulɛɑ. ");
INSERT INTO mkl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Iyi ɑ̀ ɡbɔ ideɛu ɑ̀ tɑ̃, ŋɔi ɑ̀ dɑsi kpɑ̃ɑ. Nɔ ɑndɑiyɑ iyi ɑ̀ tɑko ɑ̀ yɛ hɑi nunui dɑɑkɔu í nyi í cuɑ nŋɑ mɑ́ hee tenɡi bii ɑmɑu í wɑ, í bɛi í leekĩ lele bɛ cɑu. ");
INSERT INTO mkl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Iyi ɑ̀ yɛ ɑndɑiyɑu í leekĩ bɛɛbɛ, ŋɔi idɔ nŋɑ í dɔ̃ hee í cɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nɔ ɑ̀ lɔ ile bɛ ŋɔi ɑ̀ yɛ ɑmɑu do Mɑɑri iyeɛ. Nɔ ɑ̀ ɡulɛ ɑ̀ tɔɔɛ. Nɔ ɑ̀ fũ bɔɡɔi ɑmɑni nŋɑ ɑ̀ nyɑ wurɑ ɑ̀ muɑɑ, do tulɑre iyi ɑ̀ yɑ jo do ikpo ku dɔ̃ inunu iyi ɑ̀ yɑ kpe miru. ");
INSERT INTO mkl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Si ɑnyiɛ Ilɑɑɔ̃ í sɔ̃ ŋɑ si ɑlɑ í ni ɑ mɑɑ̀ nyi bi ɑmɑnlu Herodu mɑ́. Nɔ ɑ̀ too kpɑ̃ɑ mmu ɑ̀ nɛò ilɛi ide nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iyi woo mɑ̀ ŋɑu ɑ̀ to ɑnyi ɑ̀ nɛ, nɔ ɑmɑlekɑi Aɔ̃ Lɑfɛ̃ɛ í nɑɑ bi Zozɛfu si ɑlɑ í ni, dede i so ɑmɑu do iyeɛ i sɑ i nɛò ŋɑ ilɛi Ezibiti, domi Herodu ɑ́ dɛ ɑmɑu ku kpɑ. I koo i bubɑ bɛ titɑ̃ hee ɑjɔ iyi ɑn nɑ n ni i nyi wɑ mɑ́ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nɑ ŋɔi í jɔ̀ Zozɛfu í dede idũ í so ɑmɑu do iyeɛ í nɛò ŋɑ Ezibiti. ");
INSERT INTO mkl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bɛi ɑ̀ bubɑ hee Herodu í koo í ku. Iyi bɛ í cei ku bɑ ide iyi Aɔ̃ Lɑfɛ̃ɛ í sɔ̃ wɑliiɛ ku sisiɑ inɛ ŋɑu ku kɔ̃, si bɛi í ni, hɑi Ezibitii ǹ kpe ɑmɑm wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ŋɔi ɑmɑnlu Herodu í yɛ iyi woo mɑ̀ ɑndɑiyɑ ŋɑu ɑ̀ lɛlɛ nŋui, ŋɔi idɔɛ í kɔ̃ jiidɑ jiidɑ. Ŋɔi í ce dooi wɑɑti iyi woo mɑ̀ ŋɑu ɑ̀ yɛ ɑndɑiyɑu í fitɑ, ŋɔi í jɔ̀ ɑ̀ koo ɑ̀ kpɑ ɑmɑ inɛmɔkɔ kpɔtɔɔ ŋɑ hee ku koo si do ɑmɑi ɑdɔ̃ minji ŋɑ fei si ilui Betelehɛmu do ilɛɛkoɛ ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bɛɛbɛi ide iyi wɑlii Zeremi í fɔu í ce. Í ni, ");
INSERT INTO mkl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","À ɡbɔ ɑnu ku dɔ̃ si ilui Rɑmɑ. À ɡbɔ inɛ ŋɑ ɑ̀ kpɑtɑ, À wɑɑ cɑ̃ buubuu. Asee, Rɑsɛlii wɑ kpɑtɑ nɑ irii ɑmɑɛ ŋɑ. Nɔ ɑ̀ bɔ ku lɛlɛɛ, Ammɑ í kɔ ku ɡbɔ kulɛlɛu Si nɑ iyi í jɔ̀ ɑmɑɛ ŋɑ ɑ kù wɛɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Si ɑnyiɛ Herodu í nɑɑ í ku, ŋɔi ɑmɑlekɑi Aɔ̃ Lɑfɛ̃ɛ í nɑɑ bi Zozɛfu si ɑlɑ ilɛi Ezibiti bɛ, ");
INSERT INTO mkl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","í ni, dede i so ɑmɑu do iyeɛ i nyiò ŋɑ ilɛi Izirɛli. Inɛ ŋɑ iyi ɑ̀ wɑɑ dɛ ɑmɑu ku kpɑ ɑ̀ ku. ");
INSERT INTO mkl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nɔ Zozɛfu í dede í so ɑmɑu do iyeɛ ɑ̀ nyi ilɛi Izirɛli mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ammɑ í ɡbɔ iyi Aɑkelɑusii í jɛ bommɑi bɑɑɛ Herodu si ilɛi Zudeeu, ŋɔi wɑ ce njoi ku bɔ ku bubɑ bɛ. Nɔ Ilɑɑɔ̃ í sɔ̃ɔ si ɑlɑ mɑ́ í ni ku bɔ ilɛi Gɑlilee. Ŋɔi í tekĩ í bɔ Gɑlilee si bɛi Ilɑɑɔ̃ í sɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nɔ í koo í bubɑ Nɑzɑrɛti. Bɛɛbɛi idei wɑlii ŋɑu í kɔ̃, si bɛi ɑ̀ ni ɑɑ kpoo inɛi Nɑzɑrɛti. ");
INSERT INTO mkl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wɑɑti bɛɛbɛi, Zɑ̃ɑ woo dɑsi inyi í nɑɑ wɑ ce wɑɑzo si ɡbɑbuɑi Zudee. ");
INSERT INTO mkl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Í ni, i kpɑɑsi idɔ nŋɛ ŋɑ domi wɑɑti í mɑɑi iyi Ilɑɑɔ̃ ɑ́ nɑ ku jɛ bommɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Idei Zɑ̃ɑui wɑlii Ezɑi í fɔ wo, si wɑɑti iyi í ni, À ɡbɔ imui inɛ ɡɔ wɑ dɔ̃ ɑnu si ɡbɑbuɑ wɑ ni, I teese kpɑ̃ɑi Lɑfɛ̃ɛ ku tɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zɑ̃ɑ wɑ dɑsi ibɔi ntoi kpookpo, nɔ wɑ dĩ sɑntikii bɑtɑ. Kɛtɛnɡbo do nyikɔ̃i sɑkoi í jɛ ijɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nɔ inɛ ŋɑ ɑ̀ nɑɑ bi tɛɛ hɑi Zeruzɑlɛmu do hɑi ilɛi Zudee fei do hɑi ilu ŋɑ iyi ɑ̀ wɑ cinɡɑɑi idoi Zuudɛ̃ɛu fei. ");
INSERT INTO mkl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","À ce tuubɑi dulum du ŋɑ nɔ ɑ̀ jɔ̀ Zɑ̃ɑ í dɑsi ŋɑ inyi si idoi Zuudɛ̃ɛu. ");
INSERT INTO mkl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fɑrisi do Sɑdusi ŋɑ mɔ ɑ̀ wɑɑ nɑɑ bi tɛɛ ɑŋɑ nkpɔ nkpɔ ku bɑ ku dɑsi ŋɑ inyi. Iyi Zɑ̃ɑ í yɛ ŋɑ ŋɔi í sɔ̃ ŋɑ í ni, iŋɛ inɛ buu ŋɑ bɛi njo wukuku, yooi í sɔ̃ ŋɛ í ni i sɑɑ idɔɔkɔ̃i Ilɑɑɔ̃ iyi í mɑɑi wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nɑ nŋu, i ce kookoosu jiidɑ i nyisiò iyi ì kpɑɑsi idɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","I mɑɑ̀ tɑmɑɑ mɑ̀ ɑɑ bɑ fɑɑbɑ ŋɑ si nɑ iyi í jɔ̀ ì yɑ mɑɑ ni ì jɛ tɔkui Aburɑhɑmu ŋɑ. An sɔ̃ ŋɛ, Ilɑɑɔ̃ ɑ́ yɔkɔ ku so kutɑ ŋɑu ihɛ̃ ku ce ŋɑ tɔkui Aburɑhɑmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wee dɑɡbɑ wɑ kɑ̃si tɑ̃ mɔm ɑ dɑò icui jĩi. Nɑ nŋu, jĩi iyi kù wɑɑ so iso jiidɑ fei ɑɑ dɑɑ ɑ dɑsi inɑ. ");
INSERT INTO mkl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Amu inyii ǹ wɑ n dɑsi ŋɛ ku bɑ ku jɛ sɛɛdɑi idɔ ku kpɑɑsi nŋɛ, ɑmmɑ inɛ ɡɔ ɑ́ nɑ ku nɑɑ si ɑnyim. Í rem do ɡbuɡbɑ̃ ntɔ ntɔ, n kù to bɑɑ ǹ bɔ bɑɑtɑɛ. Nŋui ɑ́ dɑ nŋɛ si Hundei Ilɑɑɔ̃ do inɑ. ");
INSERT INTO mkl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wɑ mu mii ku fɛ bileeɛ si ɑwɔ, nɔ ku kpɑ̃ bileeu bii ɑ̀ kpokpoɛ, nɔ ku ko yɔyɔɔu ku dɑsi ɑkɑ, sɑkou mɔ ku dɑsi inɑ iyi ci yɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wɑɑti bɛɛbɛ Jesu í nɑɑ hɑi ilɛi Gɑlilee nɔ í bɔ idoi Zuudɛ̃ɛ ku bɑ Zɑ̃ɑ ku dɑsiɛ inyi. ");
INSERT INTO mkl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Iyi í to wɑ í ni Zɑ̃ɑ ku dɑsi nŋu inyi, ŋɔi Zɑ̃ɑ wɑ bi ku kɔ, í ni, ɑwɔi ì nɛ kpɑ̃ɑ i dɑsim inyi, nɔ bɛirei í ce ì wɑɑ nɑɑ bi tom. ");
INSERT INTO mkl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ŋɔi Jesu í jɛɑɑ í ni, jɔ̀ ku ce bɛɛbɛ titɑ̃, domi bɛɛbɛi ɑ̀ nɛ kɑ ce kɑ ceò mii iyi Ilɑɑɔ̃ í bi fei. Nɔ Zɑ̃ɑ í jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iyi í dɑsi Jesu inyi í tɑ̃, bɛ ɡbɑkɑ̃ Jesu í fitɑ wɑ hɑi si inɔ inyiu. Ŋɔi lelei Aɔ̃ í cĩ nɔ Zɑ̃ɑ í yɛ Hundei Ilɑɑɔ̃ wɑ de siɛ wɑ bɛi ɑnkɑsiidi. ");
INSERT INTO mkl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nɔ ɑ̀ ɡbɔ ide ku fɔ ɡɔ wɑ hɑi lele í ni, inɛ ihɛ̃i í jɛ Amɑm. Ǹ buu jiidɑ jiidɑ, siɛi inɔ didɔ̃m fei í yɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Si ɑnyii nŋu, ŋɔi Hundei Ilɑɑɔ̃ í bɔò Jesu si ɡbɑbuɑ ku bɑ Seetɑm ku lɛlɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ŋɔi Jesu í ce ɑnu ku dĩ dɑsɑ̃ ciiji do idũ ciiji, si ɑnyiɛ nɔ ɑri wɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ŋɔi Seetɑm woo lɛlɛu, í nɑɑ siɛ í ni, bii ɑwɔu Amɑi Ilɑɑɔ̃i do ntɔ, jɔ̀ kutɑ ŋɑu ihɛ̃ ɑ kpɔò pɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ŋɔi Jesu í jɛɑɑ í ni, kukɔi idei Ilɑɑɔ̃ í ni, ɑmɑnɛ ci yɑ wɛɛ nɑ ijɛ nŋu ɑkɑ̃, ɑmmɑ ɑ́ mɑɑ wɛɛi nɑ ide iyi Ilɑɑɔ̃ wɑ fɔ fei. ");
INSERT INTO mkl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nɔ Seetɑm í bɔòɛ Zeruzɑlɛmu, ilu kumɑ́u, nɔ í ɡũòɛ hee si ɑntɑi ile lelei kpɑsɛ̃i Ilɑɑɔ̃u. ");
INSERT INTO mkl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ŋɔi í ni mɑ́, bii ɑwɔu Amɑi Ilɑɑɔ̃i, fo i dinɡɑɑ ilɛ, domi kukɔi idei Ilɑɑɔ̃ í ni, Ilɑɑɔ̃ ɑ́ nɑ ɑmɑlekɑɛ ŋɑ woodɑ nɑ iriɛ ɑ mɑɑ deɡbeɛ, Nɔ ɑ mɑɑ muɛ si ɑwɔ Ku bɑ i mɑɑ̀ ti i koosɛ si kutɑ. ");
INSERT INTO mkl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nɔ Jesu í jɛɑɑ í ni, ɑmmɑ kukɔi idei Ilɑɑɔ̃ í ni mɑ́, mɑɑ̀ ti i sii Aɔ̃ Lɑfɛ̃ɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Si ɑnyii nŋu, Seetɑm í bɔò Jesu hee ɑntɑi iri kutɑ nlɑ ɡɔ mɑ́ nɔ í nyisiɛ bommɑi ɑndunyɑ fei do ɑmboe nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nɔ í ni, bii ì ɡulɛ ì tɔɔm, mii ŋɑu ihɛ̃ fei ɑn muɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nɔ Jesu í jɛɑɑ í ni, sɛkɛɛ bɛ Seetɑm. Kukɔi idei Ilɑɑɔ̃ í ni, Aɔ̃ Lɑfɛ̃ɛɛi ɑɑ tɔɔ, nɔ i wɛɛ nɑ irii nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ŋɔi Seetɑm í bɛi í sɛkɛɛ hɑi bi tɛɛ, nɔ ɑmɑlekɑ ŋɑ ɑ̀ nɑɑ ɑ̀ sobiɛ. ");
INSERT INTO mkl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ŋɔi Jesu í ɡbɔ ɑ̀ ni ɑ̀ mu Zɑ̃ɑ ɑ̀ dɑsiɛ piisɔ̃ɔ. Nɔ í sindɑ í nyi ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ammɑ iyi í to Nɑzɑrɛti, kù bubɑ bɛ, Kɑpɛrɑnumui í koo í bubɑ, ilu iyi í wɑ kɔkɔi tenku iyi ɑ̀ yɑ kpe Gɑlilee, si ilɛi Zɑbulɔ̃ɔ do Nɛfitɑli. ");
INSERT INTO mkl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iyi bɛ í cei ku bɑ ide iyi wɑlii Ezɑi í tɑko í fɔu ku kɔ̃ wɑɑti iyi í ni, ");
INSERT INTO mkl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Inɛi Zɑbulɔ̃ɔ do inɛi Nɛfitɑli ŋɑ, Aŋɑ iyi ɑ̀ wɑ kɔkɔi kpɑ̃ɑ iyi wɑ bɔ Tenku, Aŋɑ iyi ɑ̀ wɑ ikpɑ icei idoi Zuudɛ̃ɛu, Aŋɑ iyi ɑ̀ wɑ ilɛi Gɑlilee bii dimi mmu ŋɑ ɑ̀ wɑ, ");
INSERT INTO mkl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Aŋɑ iyi ɑ̀ wɑ si ilu kuku wo, Aŋɑi ɑ̀ yɛ inyɑ kumɑ́ nlɑ nlɑ. Aŋɑ iyi ɑ̀ wɑ si ilɛ bii iku do ilu kuku í wɑ, Aŋɑi inyɑ kumɑ́ í nɑɑ si. ");
INSERT INTO mkl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hɑi wɑɑti bɛɛbɛi Jesu í sinti ku wɑɑzo, í ni, i kpɑɑsi idɔ nŋɛ si nɑ iyi í jɔ̀ wɑɑti í mɑɑi wɑ iyi Ilɑɑɔ̃ ɑ́ jɛ bommɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ajɔ nŋu ɡɔ Jesu wɑ nɛ si itĩi tenku iyi ɑ̀ yɑ kpe Gɑlilee, ŋɔi í yɛ sɔɔkɔ minji ɡɔ ŋɑ, Simɔɔ iyi ɑ̀ yɑ kpe Piɛɛ do ifɔɛ Anderee, ɑ̀ wɑɑ le tɑɑo si inɔ tenkuu. ");
INSERT INTO mkl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nɔ í sɔ̃ ŋɑ í ni, i toom wɑ ŋɑ, nɔ ɑn ce ŋɛ woo dɛdɛ inɛ ŋɑ iyi ɑɑ jɛ ti Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bɛ ɡbɑkɑ̃ ɑ̀ jɔ̀ tɑɑo nŋɑ ŋɑ ɑ̀ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iyi í to wɑju nɔ í yɛ inɛ minji ɡɔ ŋɑ mɑ́, Zɑɑki do Zɑ̃ɑ ifɔɛ, ɑmɑi Zebedee ŋɑ. Inɛ ŋɑu ɑ̀ wɑ si ɑkɔi inyi ɡɔ do bɑɑ nŋɑ, ɑ̀ wɑɑ teese tɑɑo nŋɑ ŋɑ. Nɔ Jesu í kpe ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bɛ ɡbɑkɑ̃ ɑŋɑ mɔ ɑ̀ jɔ̀ ɑkɔu do bɑɑ nŋɑ ɑ̀ wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nɔ Jesu í dɑbii si ilɛi Gɑlilee fei wɑ kɔ inɛ ŋɑ si cio ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ nŋɑ ŋɑ, wɑ sisi nŋɑ lɑɑbɑɑu jiidɑ si bɛi Ilɑɑɔ̃ wɑ ce sɔɔlu ku nɑ ku jɛ bommɑɛ, nɔ í jɔ̀ inɛ ŋɑ ɑ̀ wɑɑ bɑ iri si bɔ̃ɔ dimi ikɑ̃ ikɑ̃ nŋɑ ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nɔ bɑɑuɛ í fɑnɡɑɑ bii fei si ilɛi Siri fei, hee inɛ ŋɑ ɑ̀ wɑsi ku nɑɑò bɔ̃ɔ nŋɑ ŋɑ wɑ bi tɛɛ. Inɛ ŋɑ iyi ɑ̀ nɛ dimii bɔ̃ɔ ikɑ̃ ikɑ̃ fei do inɛ ŋɑ iyi ɑ̀ nɛ wɑhɑlɑi ɑrɑ kuro nkpɔ do inɛ ŋɑ iyi inɛi inɔɔko ŋɑ ɑ̀ mu, do inɛ ŋɑ iyi ɑ̀ wɑɑ ce bɔ̃ɔi cukuunɑ do wɛɛɡɛ ŋɑ, ɑ̀ nɑɑò ɑŋɑ fei wɑ bi tɛɛ, nɔ í jɔ̀ ɑŋɑ fei ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nɔ zɑmɑɑ nkpɔ ɡɔ í too fitiɛ wɑ hɑi ilɛi Gɑlilee do hɑi ilui Zeruzɑlɛmu do ilɛi Zudee hee do icei idoi Zuudɛ̃ɛu bii Ilu Mɛɛwɑ ŋɑu ɑ̀ wɑ fei. ");
INSERT INTO mkl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iyi Jesu í yɛ zɑmɑɑu ŋɔi í koo í ɡũ iri kutɑ ɡɔ í bubɑ. Nɔ mɔcɔɛ ŋɑ ɑ̀ nɑɑ ɑ̀ tɔtɔɔ siɛ. ");
INSERT INTO mkl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nɔ í lɔsi cio ku kɔ ŋɑ si. Si cioɛu í ni, ");
INSERT INTO mkl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi ɑ̀ wɑɑ tɔɔ Ilɑɑɔ̃ do ɑrɑ kukɑye, Domi ɑŋɑi ɑ̀ jɛ inɛi bommɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi ɑ̀ wɑɑ kpɑtɑ, Domi Ilɑɑɔ̃i ɑ́ tũ idɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi dɑɑ nŋɑ í dɔ̃, Domi ɑŋɑi ɑɑ nɛ ilɛu fei. ");
INSERT INTO mkl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi ɑ̀ wɑɑ ɡbɔ ɑri do ɑɡbɛi mii iyi Ilɑɑɔ̃ wɑ bee, Domi Ilɑɑɔ̃ ɑ́ jɔ̀ ɑ yo. ");
INSERT INTO mkl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi ɑ̀ yɑ nɛ ɑrɑɑrei inɛ ŋɑ, Domi Ilɑɑɔ̃ mɔ ɑ́ nɛ ɑrɑɑre nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi idɔ nŋɑ í mɑ́, Domi ɑɑ yɛ Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi ɑ̀ wɑɑ ce icɛi lɑɑkɑi ku sũ, Domi Ilɑɑɔ̃ ɑ́ kpe ŋɑ ɑmɑɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi ɑ̀ kpɑ̃ ŋɑ iju si nɑ iyi í jɔ̀ ɑ̀ wɑɑ ce mii iyi Ilɑɑɔ̃ í bee ŋɑ, Domi ɑŋɑi ɑ̀ jɛ inɛi bommɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Iŋɛ ilu inɔ didɔ̃ ŋɑi, bii ɑ̀ wɑɑ bu ŋɛ nɔ ɑ̀ wɑɑ kpɑ̃ ŋɛ iju nɔ ɑ̀ wɑɑ mɑ́ ŋɛ lɑɑlɔ bɑɑ yoomɑ fei nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","I jɔ̀ i nyɑɑnyi i wɛɛò inɔ didɔ̃ nlɑ nlɑ ŋɑ si nɑ iyi í jɔ̀ ribɑ iyi ɑ̀ jilɛ nŋɛ leleɑɔ̃ í lɑ. Ntɔ ntɔ bɛɛbɛi ɑ̀ kpɑ̃ wɑlii ŋɑ iyi ɑ̀ cuɑ nŋɛ ŋɑu mɔ iju. ");
INSERT INTO mkl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, iŋɛi ì jɛ imu si inɔi inɛi ɑndunyɑ ŋɑ. Bii didɔ̃i imu í ku, mii ɑɑ dɑsi ku jɔ̀ ku dɔ̃ mɑ́. Í ɡbe de ɑ nikɑ̃ɛ, nɔ inɛ ŋɑ ɑ tɛɛsɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nɔ iŋɛi ì jɛ inyɑ kumɑ́i ɑndunyɑ. Ilu iyi ɑ̀ mɑ si iri kutɑ kɑɑ mɑnji. ");
INSERT INTO mkl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","A ci yɑ mɑ́ fitilɑ ɑ biiɛ do cɑkɑ. Ammɑ ɑ̀ yɑ kɔɑɛi tenɡi bii ɑ́ mɑ́ inyɑ, inɛi kpɑsɛ̃ fei ku yɛò ilu. ");
INSERT INTO mkl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bɛɛbɛ mɔi i jɔ̀ inyɑ kumɑ́ nŋɛ ku mɑ́ si wɑjui inɛ ŋɑ ku bɑ ɑ yɛ kookoosu jiidɑ nŋɛ ŋɑ nɔ irii Ilɑɑɔ̃ Bɑɑ nŋɛ iyi í wɑ lele ku nɛ ɑmboe. ");
INSERT INTO mkl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesu í ni mɑ́, i mɑɑ̀ tɑmɑɑ bɛi ǹ nɑɑ woodɑi Moizi do cioi wɑlii ŋɑu ku kpɑi. Aɑwo, ǹ nɑɑ ku kɔ̃ɔi. ");
INSERT INTO mkl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ntɔ ntɔ, hee lele do ilɛ koo tɑ̃ò, bɑɑ wɑsɑlii woodɑ keeke ɑkɑ̃ kɑɑ ɡɑiziɑ, í ɡbe fei ndɛɛ ku kɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nɑ nŋu, inɛ iyi í kuɑ woodɑ, bɑɑ bii í jɛ icu ɑkɑ̃ keeke ɡɔi, nɔ í sɔ̃ inɛ ɡɔ ŋɑ mɔ í ni ɑ ce bɛɛbɛ, ɑɑ kpe lɑfɛ̃ɛ inɛ iyi í kere í re si bommɑi Ilɑɑɔ̃. Ammɑ inɛ iyi wɑ jirimɑɛ nɔ wɑ kɔ inɛ ɡɔ ŋɑ mɔ si, ɑɑ kpe lɑfɛ̃ɛ inɛ nlɑ si bommɑi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ǹ wɑ n sɔ̃ ŋɛi, i kɑɑ jɛ inɛi bommɑi Ilɑɑɔ̃ ŋɑ bii kù jɛ ì ce mii iyi Ilɑɑɔ̃ í bee ŋɛ ŋɑ í re woo kɔ inɛ ŋɑ si woodɑ ŋɑ do Fɑrisi ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesu í sɔ̃ ŋɑ mɑ́ í ni, ì ɡbɔ ŋɑ iyi Moizi í sɔ̃ bɑlɑ nŋɛ ŋɑ í ni, i mɑɑ̀ kpɑ inɛ, nɔ inɛ iyi í kpɑ inɛ fei ɑɑ bɔòɛ si wɑjui woo kiiti ŋɑ ɑ nyisiɛ bɔ̃nɛ. ");
INSERT INTO mkl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ammɑ ɑmu, ɑn sɔ̃ ŋɛ, inɛ iyi wɑ ce idɔɔkɔ̃ do kpɑɑsiɛ ɑɑ bɔòɛ si wɑjui woo kiiti ŋɑ ɑ kpɑ̃ɑ iju, nɔ inɛ iyi wɑ cɔ kpɑɑsiɛ nfe ɑɑ kiitiɛ si wɑjui inɛ nɡbo ŋɑu, inɛ mɔ iyi wɑ cɔ kpɑɑsiɛ nnyɛi ɑ́ lɔ si inɑ iyi ci yɑ kuu. ");
INSERT INTO mkl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nɑ nŋu, bii ì nɑɑò ɑmuɑi Ilɑɑɔ̃ wɑ bi kuwee nɔ bɛi ì ye ɡiɡi iyi kpɑɑsiɛ ɡɔ wɑ mu tɑɑleɛ, ");
INSERT INTO mkl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jɔ̀ ɑmuɑɛu bi kuweeu bɛ titɑ̃, i koo i teese ideu ɡbɑkɑ̃, ɑwɔ do kpɑɑsiɛ. Si ɑnyiɛ, i bɛi i nyi wɑ i ceɑ Ilɑɑɔ̃ ɑmuɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Bii í jɛ inɛ ɡɔ wɑ bɔòɛ ile kiiti nɑ idei ɡbese ɡɔ, ce kookɑɑi hɑi kpɑ̃ɑ ɑwɔ do lɑfɛ̃ɛ i ɡbɔsi njɛ ku bɑ ku mɑɑ̀ dɑsiɛ ɑwɔi woo kiiti. Bii kù jɛ bɛɛbɛ, woo kiitiu ɑ́ dɑsiɛ si ɑwɔi zɑndɑɑmu, nɔ zɑndɑɑmu mɔ ku dɑsiɛ ile piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ntɔ ntɔ ǹ wɑ n sɔ̃ɛi, bii ɑ̀ dɑsiɛ piisɔ̃ɔ, bii i kù sɑ̃ ɡbeseu fei i kɑɑ fitɑ. Nkɑ̃mɑ kɑɑ ɡɑiziɑ si. ");
INSERT INTO mkl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesu í ni mɑ́, ì ɡbɔ ŋɑ iyi Moizi í ni, i mɑɑ̀ ce sɑkɑrɑ. ");
INSERT INTO mkl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ammɑ ɑmu, ɑn sɔ̃ ŋɛ, ɑwɔ inɛmɔkɔ iyi í cɔ inɑɑbo hee binɛɛ í dede, ì ce sɑkɑrɑ mbɛ tɑ̃ si idɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nɑ nŋu, bii iju njɛɛi wɑ dɑsiɛ dulum, nyɑɑ i nyɔɔ ku jĩiɛ. Á tiɑɛ i nyɔ ikɔ̃ ɑkɑ̃i ɑrɑɛ ɡɔ do iyi ɑɑ sɔsi ɑrɑɛ fei si inɑ iyi ci yɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bii í jɛ ɑwɔ njɛɛi wɑ dɑsiɛ dulum, buu i nyɔɔ ku jĩiɛ. Á tiɑɛ i nyɔ ikɔ̃ ɑkɑ̃i ɑrɑɛ ɡɔ do iyi ɑɑ sɔsi ɑrɑɛ fei si inɑ iyi ci yɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nɔ Jesu í sɔ̃ ŋɑ mɑ́ í ni, Moizi í ni, inɛ iyi wɑ kɔsi ɑboɛ ɑ́ nɑ́ɑ tiɑi njɛ kukɔsii. ");
INSERT INTO mkl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ammɑ ɑmu, ǹ wɑ n sɔ̃ ŋɛ, inɛ iyi í kɔsi ɑboɛ nɔ kù jɛ nɑ sɑkɑrɑ, mɔkɔu í dɑsiɛ sɑkɑrɑi. Nɔ mɔkɔ mɔ iyi í so ɑbo iyi ɑ̀ kɔsiu, í ce sɑkɑrɑi. ");
INSERT INTO mkl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesu í sɔ̃ ŋɑ mɑ́ í ni, ì nɔ ì ɡbɔ iyi Moizi í sɔ̃ bɑlɑ nŋɛ ŋɑu í ni, ide iyi ì ɡbɑsi si wɑjui Aɔ̃ Lɑfɛ̃ɛ ì ni ɑɑ ce, jɔ̀ i coo. ");
INSERT INTO mkl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ammɑ ɑmu, ǹ wɑ n sɔ̃ ŋɛi, i mɑɑ̀ yɑ ce kuɡbɑsi ŋɑ pɑi. I mɑɑ̀ yɑ ɡbɑsi do lele ŋɑ domi bɑtɑi bommɑi Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nɔ i mɑɑ̀ yɑ ɡbɑsi do ilɛ ŋɑ, domi bi ku lesi isɛɛi. Nɔ i mɑɑ̀ yɑ ɡbɑsi do Zeruzɑlɛmu ŋɑ domi ilui Ilɑɑɔ̃ ɑmɑnlu nlɑui. ");
INSERT INTO mkl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nɔ i mɑɑ̀ yɑ ɡbɑsi do iri nŋɛ ŋɑ si nɑ iyi í jɔ̀ i kɑɑ yɔkɔ i fũutɑ bɑɑ ntoi iri ɑkɑ̃ nŋɛ hee mɑ jɛ i jɔ̀ ku dũ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","I jɔ̀ ide ku fɔ nŋɛ ku jɛ ntɔ. Bii ì ni ooi ku jɛ oo do ntɔ, bii ɑɑwo mɔi, ku jɛ ɑɑwo. Iyi ɑɑ lesi ɑntɑɛ bɛbɛi fei ŋɑ, hɑi bi Seetɑm inɛ lɑɑlɔui wɑ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesu í sɔ̃ ŋɑ mɑ́ í ni, ì ɡbɔ ŋɑ iyi Moizi í fɔ wo í ni, inɛ iyi í nyɑ ijui inɛ ɡɔ, ɑɑ nyɑ ti nŋu mɔ. Inɛ mɔ iyi í cɛ inyii inɛ ɡɔ, ɑɑ cɛ ti nŋu mɔi. ");
INSERT INTO mkl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ammɑ ɑmu, ǹ wɑ n sɔ̃ ŋɛi, i mɑɑ̀ yɑ sɑ̃ɑ inɛ lɑɑlɔ iyi í ce nŋɛ. Bii inɛ í sɑmbɑlɑɛ si njɛ, toɑ cɑnɡɑu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bii inɛ ɡɔ í bɔòɛ kiiti ku bɑ ku ɡbɑ dɑnziɡiɛ, nɑɑ kumbooɛ mɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bii inɛ ɡɔ í tilɑsiɛ i soɑ nŋu ɑso i nɛò zɑkɑi kilo ɑkɑ̃, so i nɛɑɑ ku to kilo minji ɡbɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bii inɛ ɡɔ í tɔɔɛ mii ɡɔ, muɑɑ. Bii inɛ ɡɔ í nɑ̀ɑ mii ɡɔ ku kɑ̃ɑye bi tɛɛ, mɑɑ̀ kɔ. ");
INSERT INTO mkl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesu í ni mɑ́, ì ɡbɔ ŋɑ iyi Moizi í fɔ wo í ni, bi kpɑɑsiɛ, nɔ i cé mbɛɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ammɑ ɑmu, ǹ wɑ n sɔ̃ ŋɛi, i yɑ bi mbɛɛ nŋɛ ŋɑ, nɔ i yɑ ceɑ inɛ ŋɑ iyi ɑ̀ wɑɑ kpɑ̃ ŋɛ iju kutɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bii ì wɑɑ ce bɛɛbɛ ŋɑ ì wɑɑ nyisi inɛ ŋɑ iyi ì jɛ ɑmɑi Ilɑɑɔ̃ Bɑɑ nŋɛ iyi í wɑ lelei, domi Ilɑɑɔ̃ í jɔ̀ inunuɛ wɑ mɑ́ inyɑ si inɛ jiidɑ do si inɛ lɑɑlɔ ŋɑ. Nɔ í jɔ̀ ijĩ wɑ rɔɑ inɛ ŋɑ iyi ɑ̀ wɑɑ ce idɔɔbiɛ hee do bi inɛ ŋɑ iyi ɑ kù wɑɑ coo fei. ");
INSERT INTO mkl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bii inɛ ŋɑ iyi ɑ̀ bi ŋɛ ɑŋɑ ɑkɑ̃i iŋɛ mɔ ì bi ŋɑ, to, ribɑ yoomɑi ɑɑ bɑ ŋɑ. Bɑɑ woo ɡbɑ fiɑi lɛmpoo ŋɑ mɔ ɑ̀ yɑ ce dimiɛ. ");
INSERT INTO mkl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bii kpɑɑsi nŋɛ ŋɑ ɑŋɑ ɑkɑ̃i ì yɑ ce fɔɔ ŋɑ, to, iŋɛ mɔ yooi ì tiɑ ŋɑ. Bɑɑ hɑi dɑsi Ilɑɑɔ̃ nɑɑnɛ ŋɑ mɔ ɑ̀ yɑ ce bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nɑ nŋu, i jɔ̀ jiidɑ nŋɛ ku kɔ̃ bɛi ti Ilɑɑɔ̃ Bɑɑ nŋɛ iyi í wɑ lele í kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesu í fɔ mɑ́ í ni, bii ì wɑɑ ce mii iyi Ilɑɑɔ̃ í jilɛ nŋɛ, i yɑ ce lɑɑkɑi ŋɑ i mɑɑ̀ coo si bɑntumɑ. Bii ì wɑɑ coo si bɑntumɑ ku bɑ inɛ ŋɑ ɑ yɔɔ, i kɑɑ bɑ ribɑ kɑ̃mɑ hɑi bi Bɑɑ nŋɛ iyi í wɑ lele. ");
INSERT INTO mkl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nɑ nŋu, bii ì wɑɑ muɑ ilu ɑre ŋɑ nɡɔɡɔ ŋɑ, i mɑɑ̀ ti i cɑ̃ kɛsɛɛdɛ bɛi ilu muɑfiti ŋɑ ɑ̀ yɑ ce. À yɑ ce ɑmuɑ nŋɑ ŋɑi si ile bii ɑ̀ yɑ ce kutɔtɔɔ ŋɑ do si kpɑ̃ɑ ŋɑ ku bɑ inɛ ŋɑ ɑ sɑɑbu ŋɑ. Ntɔ ntɔ, inɛ nŋu ŋɑ ɑ̀ bɑ ribɑ nŋɑ fei tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ammɑ iŋɛ, wɑɑti iyi ì wɑɑ muɑ ilu ɑre ŋɑ nɡɔɡɔ ŋɑ, i mɑɑ̀ jɔ̀ ɑwɔ cɑnɡɑ nŋɛ ku mɑ̀ mii iyi ɑwɔ njɛu wɑ ce, ");
INSERT INTO mkl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ku bɑ ɑmuɑ iyi ì wɑɑ ce ŋɑ i coo si ɑfei iŋɛ minji. Nɔ Ilɑɑɔ̃ Bɑɑ nŋɛ iyi wɑ yɛ mii fei ɑ́ sɑ̃ nŋɛ ribɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesu í ni, bii ì wɑɑ ce kutɔɔ ŋɑ i mɑɑ̀ yɑ ce bɛi ilu muɑfiti ŋɑ ɑ̀ yɑ ce. À yɑ bi ɑŋɑ ɑ leekĩ ɑ ce kutɔɔ ile bii ɑ̀ yɑ ce kutɔtɔɔ ŋɑ do bi tɑfɑ ŋɑ ku bɑ inɛ fei ku yɛ ŋɑ. Ntɔ ntɔ, inɛ nŋu ŋɑ ɑ̀ bɑ ribɑ nŋɑ fei tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ammɑ iŋɛ, bii ì wɑɑ ce kutɔɔ ŋɑ, i lɔ hee ilɑɑwɑ i cĩmbo ŋɑ, i tɔɔ Ilɑɑɔ̃ Bɑɑ nŋɛ bɛ tenɡi bii inɛ ɡɔ kù wɑɑ yɛ ŋɛ, nɔ Bɑɑ nŋɛ iyi wɑ yɛ mii iyi wɑ mɑnji fei ɑ́ sɑ̃ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Bii ì wɑɑ ce kutɔɔ ŋɑ i mɑɑ̀ yɑ fɔ ide ɑkɑ̃ i mɑɑ sisi ŋɑ bɛ́i hɑi mɑ̀ Ilɑɑɔ̃ ŋɑ ɑ̀ yɑ ce. À wɑɑ tɑmɑɑ nɑ ide nkpɔ ku fɔi ɑŋɑi Ilɑɑɔ̃ ɑ́ ɡbɔò kutɔɔi ɑŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","I mɑɑ̀ yɑ jɔ ŋɑ ŋɑ, domi hee i mɑɑ̀ tɔɔ ŋɑ, Bɑɑ nŋɛ í mɑ̀ bukɑɑtɑi mii iyi ì nɛ tɑ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bɛi í sĩɑ i yɑ ce kutɔɔ ŋɑ wee. Ilɑɑɔ̃ Bɑɑ nwɑ iyi í wɑ lele, Jɔ̀ inɛ fei ku mɑ̀ iyi ɑwɔi ì jɛ inɛ kumɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nɑɑ jɛ bommɑɛ. Jɔ̀ inɛ fei ku ce idɔɔbiɛ si ilɛu ihɛ̃ bɛi ɑ̀ wɑɑ ce lele. ");
INSERT INTO mkl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mu nwɑ ijɛi ɑjɔ fei nwɑ. ");
INSERT INTO mkl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kpɑ idei dulum du wɑ bɛi ɑwɑ mɔ ɑ̀ yɑ kɑ kpɑ idei kurɑrɑ iyi inɛ ŋɑ ɑ̀ ce nwɑ. ");
INSERT INTO mkl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mɑɑ̀ ti i jɔ̀ kɑ dɑsi kulɛlɛ, Ammɑ nyɑ wɑ hɑi si ɑwɔi Seetɑm. Domi ɑwɔi ì nɛ bommɑ do ɡbuɡbɑ̃ do ɑmboe hee do ɑjɔ fei. Ami. ");
INSERT INTO mkl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nɔ í nyi í ni mɑ́, bii ì yɑ kpɑ idei kurɑrɑ iyi inɛ ŋɑ ɑ̀ ce nŋɛ, Ilɑɑɔ̃ Bɑɑ nŋɛ mɔ ɑ́ kpɑ idei kurɑrɑ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ammɑ bii iŋɛ mɔ i ci yɑ kpɑ idei kurɑrɑ iyi inɛ ŋɑ ɑ̀ ce nŋɛ, Bɑɑ nŋɛ mɔ kɑɑ kpɑ idei kurɑrɑ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesu í ni mɑ́, bii ì wɑɑ ce ɑnu ku dĩ ŋɑ, i mɑɑ̀ yɑ jɔ̀ wɑju nŋɛ ku nyisi wɑhɑlɑ nŋɛ bɛ́i ilu muɑfiti ŋɑ ɑ̀ yɑ ce. À yɑ kpɑɑsi wɑju nŋɑ ku bɑ inɛ fei ku yɔɔ iyi ɑ̀ wɑɑ dĩ ɑnu. Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, inɛ nŋu ŋɑ ɑ̀ bɑ ribɑ nŋɑ fei tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ammɑ iŋɛ, bii ì wɑɑ dĩ ɑnu, i wɛɛju sɑ̃ɑ sɑ̃ɑ ŋɑ nɔ i jɔsi wɑju nŋɛ ikpo ");
INSERT INTO mkl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ku bɑ inɛ ŋɑ ɑ mɑɑ̀ mɑ̀ iyi ì wɑɑ dĩ ɑnu ŋɑ, í ɡbe Ilɑɑɔ̃ Bɑɑ nŋɛ iyi í wɑ bii ɑ kù wɑɑ yɔɔ. Nɔ Bɑɑ nŋɛ iyi wɑ yɛ mii iyi wɑ mɑnji fei, ɑ́ sɑ̃ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Í sɔ̃ ŋɑ mɑ́ í ni, i mɑɑ̀ ti i dɛdɛ ɑmɑni si ɑndunyɑu ihɛ̃, bii tũtũ ŋɑ ɑɑ jɔɔ, do bii ɑ́ mu ɑtɛ, do bii ile ŋɑ ɑɑ lɔ do ɡbuɡbɑ̃ ɑ koo ɑ ce ileɛ. ");
INSERT INTO mkl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ammɑ i dɛdɛ ɑmɑnii lele bii kɑɑ mu ɑtɛ nɔ tũtũ ŋɑ ɑ kɑɑ yɔkɔ ɑ bɛjɛɛ, nɔ ile ŋɑ mɔ ɑ kɑɑ yɔkɔ ɑ lɔ ɑ ce ileɛ. ");
INSERT INTO mkl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ntɔ ntɔ, í sĩɑ i dɛdɛ ɑmɑnii lele ŋɑ domi bii ɑmɑnii inɛ í wɑ, bɛ mɔi lɑɑkɑɛ í yɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Í ni mɑ́, ijui í jɛ fitilɑi ɑrɑ. Bii ijuɛ wɑ nɛ bɑɑni, ɑrɑɛ fei ì wɑ si inyɑ kumɑ́i. ");
INSERT INTO mkl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ammɑ bii ijuɛ kù wɑɑ nɛ bɑɑni, ɑrɑɛ mɔ fei í wɑ si ilu kukui. Nɑ nŋu, mii iyi í nɛ ku ceɛ inyɑ kumɑ́, bii ilu kukui í ce, ilu kukuu ɑ́ lɑ ku cɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesu í sɔ̃ ŋɑ mɑ́ í ni, inɛ ɡɔ kɑɑ yɔkɔ ku ceɑ lɑfɛ̃ɛ minji icɛ ɑjɔ. Ntɔ ntɔ, ɑ́ cé inɛ ɑkɑ̃ nɔ ku bi inɛ ɑkɑ̃, wɑlɑkɔ ɑ́ jirimɑ inɛ ɑkɑ̃ nɔ ku dondɑ inɛ ɑkɑ̃. I kɑɑ yɔkɔ i too Ilɑɑɔ̃ do fiɑ ɑjɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nɑ nŋu ǹ wɑ n sɔ̃ ŋɛi, i mɑɑ̀ yɑ mɑɑ weeweɑ do mii iyi ɑɑ jɛ i mɑɑ wɛɛò ŋɑ, wɑlɑkɔ do jĩnɛ iyi ɑɑ dɑsi ŋɑ. Kuwɛɛi ɑmɑnɛ í re ijɛ, ɑrɑ mɔ í re jĩnɛ. ");
INSERT INTO mkl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","I cɔ yɛi ŋɑ iyi ɑ̀ wɑɑ fo lele. A kù wɑɑ ɡbɛ̃ hee ɑ dɑ nɡɔɡɔ ɑ dɑsi suu. Do nŋu fei, Bɑɑ nŋɛ iyi í wɑ lele wɑ wo ŋɑ. I kù mɑ̀ ŋɑ iyi bɛɛrɛ nŋɛ í re ti yɛi ŋɑu bɛ? ");
INSERT INTO mkl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yooi si inɔ nŋɛ nɑ kuweeweɑɛ ɑ́ yɔkɔ ku kɔ̃ɔsi kusɔi ɑdɔ̃ɛ bɑɑ keeke. ");
INSERT INTO mkl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","To, nɑ mii í ce ì yɑ mɑɑ weeweɑ do idei jĩnɛ ŋɑ. I cɔ bɛi wuɑ ŋɑ ɑ̀ yɑ dɑ koko si inɔ sɑko mɛɛ. A kù wɑɑ ce icɛ ɑ ci yɑ nɔ ɑ wɔ̃ ɑcɔ. ");
INSERT INTO mkl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ammɑ ǹ wɑ n sɔ̃ ŋɛ, bɑɑ Sɑlomɔɔ ilɑɑlu nlɑu, do ɑmboe nlɑ nlɑɛ fei kù nɛ jĩnɛ iyi boodɑɛ í to kokoi jĩi ŋɑu bɛ bɑɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Fɔfɔ í wɛɛi nnyi do kusĩɑɛ ɑmmɑ ɑlɑ ɑɑ dɑsiɛ inɑi. To, bii Ilɑɑɔ̃ í muɑ fɔfɔ ŋɑ iyi ɑɑ nɑ ɑ dɑsi inɑ boodɑ ku sĩɑ bɛɛbɛ, kɑɑ yɔkɔ ku mu nŋɛ nyɑu ku re fɔfɔ ŋɑu bɛ de. I kù yɛ nɑɑnɛ nŋɛi kù lɑ? ");
INSERT INTO mkl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nɑ nŋu, i mɑɑ̀ yɑ weeweɑ i ni ŋɑ, mii ɑɑ kɑ jɛ, mii ɑɑ kɑ mɔ, wɑlɑkɔ mii ɑɑ kɑ biiò ɑrɑ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hɑi mɑ̀ idei Ilɑɑɔ̃ ŋɑi ɑ̀ yɑ mɑɑ kpɑtɑɑ mii ŋɑu bɛ fei, ɑmmɑ Bɑɑ nŋɛ iyi í wɑ lele í mɑ̀ iyi ì nɛ bukɑɑtɑi mii ŋɑu bɛ fei ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nɑ nŋu, i hɑnyɑ titɑ̃ ŋɑ i ce idɔɔbii Ilɑɑɔ̃ do bɛi ɑɑ ce i jɔ̀ bommɑɛ ku bɔ wɑju. Iyi í ɡbe bɛi fei Ilɑɑɔ̃i ɑ́ kɔ̃ɔ nŋɛ si. ");
INSERT INTO mkl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ajɔ fei wɑhɑlɑɛ í yɑ tooi. Nɑ nŋu, i mɑɑ̀ kpɑtɑò ɑlɑ ŋɑ, domi ɑlɑ mɔi ɑ́ mɑ̀ tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesu wɑ fɔ mɑ́ í ni, i mɑɑ̀ yɑ kiiti inɛ ŋɑ ku bɑ Ilɑɑɔ̃ mɔ ku mɑɑ̀ kiiti nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ntɔ ntɔ, ǹ wɑ n sɔ̃ ŋɛi, do yɑɑse bɛi ì yɑ mɑɑ kiiti inɛ ŋɑ, bɛɛbɛ mɔi Ilɑɑɔ̃ mɔ ɑ́ nɑɑ ku kiiti nŋɛ. Nɔ si ɡũɑ bii ì wɑ̃ɑò inɛ ŋɑ, si bɛ mɔi ɑɑ wɑ̃ɑ iŋɛ mɔ. ");
INSERT INTO mkl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nɑ mii í ce ì wɑɑ yɛ fɔfɔ keeke iyi í wɑ si ijui kpɑɑsiɛ nɔ i kù yɛ jĩi ite iyi í wɑ si titɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bɛirei ɑɑ ce i sɔ̃ kpɑɑsiɛ i ni, jɔ̀ n nyɑɛ fɔfɔ si ijuɛ, ɑwɔ iyi jĩi ite í wɑ si tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Awɔ ilu muɑfitii, jɔ̀ i tɑko i nyɑ jĩi ite iyi í wɑ si ijuɛ titɑ̃ ku bɑ i yɛ ilu sɑ̃ɑ sɑ̃ɑ, i bɛi i nyɑ fɔfɔ iyi í wɑ si ijui kpɑɑsiɛ. ");
INSERT INTO mkl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","I mɑɑ̀ nyɔ lɛɡɛ jiidɑ nŋɛ ŋɑ si wɑjui kuusɔɔ ŋɑ ku bɑ ɑ mɑɑ̀ tɛɛsɛɛ. Nɔ i mɑɑ̀ ti i nɑ ɑjɑ ŋɑ mii kumɑ́ ŋɑ ku bɑ ɑ mɑɑ̀ nɑ ɑ sindɑ ɑ ŋɔ ŋɛ . ");
INSERT INTO mkl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesu í ni mɑ́, i yɑ tɔɔ ŋɑ, ɑɑ mu nŋɛ. I yɑ dɛdɛ ŋɑ, ɑɑ bɑ ŋɑ. I yɑ cɑ̃ ɡɑmbo ŋɑ, ɑɑ cĩ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ntɔ ntɔ, inɛ iyi í yɑ tɔɔ fei, ɑɑ muɑ. Inɛ mɔ iyi wɑ dɛdɛ fei, ɑ́ bɑ. Inɛ mɔ iyi wɑ cɑ̃ ɡɑmbo fei, ɑɑ cĩɑ lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Yooi í wɑ si inɔ nŋɛ ihɛ̃ iyi bii ɑmɑɛ í tɔɔɛ pɛ̃ɛ ɑ́ so kutɑ ku nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bɛɛbɛ mɔi inɛ kɑ̃mɑ kù wɛɛ iyi bii ɑmɑɛ í tɔɔɛ cɛ̃ɛ ɑ́ so njo ku nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Debɛi, bii iŋɛ iyi ì yɑ ce lɑɑlɔ ŋɑ ì mɑ̀ mii jiidɑ ku nɑ ɑmɑ nŋɛ ŋɑ, ì wɑɑ tɑmɑɑ mɑ̀ Bɑɑ nŋɛ iyi í wɑ lele kɑɑ yɔkɔ ku muɑ inɛ ŋɑ iyi ɑ̀ wɑɑ tɔɔɛ mii jiidɑ ku re bɛɛbɛ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nɑ nŋu, mii iyi ì bi inɛ ŋɑ ɑ yɑ ce nŋɛ fei, iŋɛ mɔ i ce nŋɑ bɛɛbɛ ŋɑ, domi iyi bɛi í jɛ icui idei kukɔsii wɑlii ŋɑu do ti woodɑi Moizi. ");
INSERT INTO mkl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Í sɔ̃ ŋɑ mɑ́ í ni, koofɑ nlɑ do kpɑ̃ɑ ku cĩ ɡɔ í wɛɛ, do minjisiɑ ku monɡolo ɡɔ iyi wɑ bɔ ɑlɑ nwɑ. Í lɔ do koofɑ ku monɡolou ŋɑ, domi koofɑ nlɑu do kpɑ̃ɑ ku cĩu, bi ikui wɑ bɔ, nɔ inɛ nkpɔi wɑ too do bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ammɑ kpɑ̃ɑ iyi wɑ bɔ bi kuwɛɛ hɑi tɑ̃ í mɑnte, ɑndɛɛ kù cĩ. Nɔ inɛ ŋɑ iyi ɑ̀ yɛ kpɑ̃ɑu ɑ̀ wɑɑ tooɛ ɑ kù kpɔ. ");
INSERT INTO mkl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesu í ni mɑ́, i yɑ ce lɑɑkɑi ŋɑ do wɑlii ilu ibo ŋɑ. À yɑ nɑɑ bi tu ŋɛi do dɑɑ didɔ̃ bɛi ɑnɡudɑ̃ ŋɑ, ɑmmɑ idɔ nŋɑ í yɛi bɛi idɔi mbo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aɑ yɔkɔ i mɑ̀ ŋɑ ŋɑi si kookoosu nŋɑ ŋɑ bɛi ɑ̀ yɑ mɑ̀ jĩi hɑi si isoɛ. A ci yɑ kɑ isoi rezɛ̃ɛ si ɑɡũ. Nɔ ɑ ci yɑ kɑ fiɡi si ɑɡũ fũfũ. ");
INSERT INTO mkl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jĩi jiidɑ fei iso jiidɑi í yɑ so, nɔ jĩi lɑɑlɔ mɔ ku so iso lɑɑlɔ. ");
INSERT INTO mkl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jĩi jiidɑ kɑɑ yɔkɔ ku so iso lɑɑlɔ, bɛɛbɛ mɔi jĩi lɑɑlɔ kɑɑ yɔkɔ ku so iso jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nɔ jĩi iyi kù wɑɑ so iso jiidɑ fei ɑ̀ yɑ dɑɑi ɑ dɑsi inɑ. ");
INSERT INTO mkl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Si bɛi ɑ̀ yɑ mɑ̀ jĩi hɑi si isoɛ, bɛɛbɛ mɔi ɑɑ mɑ̀ wɑlii ilu ibo ŋɑ hɑi si kookoosu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesu í ni mɑ́, kù jɛ inɛ iyi wɑ kpem Lɑfɛ̃ɛ Lɑfɛ̃ɛ feii ɑ́ nɑ ku lɔ si bommɑi Ilɑɑɔ̃, bii kù jɛ inɛ ŋɑ iyi ɑ̀ wɑɑ ce idɔɔbii Bɑɑm iyi í wɑ lele. ");
INSERT INTO mkl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ajɔ nŋu bɛ, inɛ nkpɔi ɑ́ mɑɑ ni, Lɑfɛ̃ɛ Lɑfɛ̃ɛ, ɑ kù ce wɑlii do iriɛ? A kù lele inɛi inɔɔko ŋɑ do iriɛ? A kù ce mɑɑmɑɑke nkpɔ do iriɛ? ");
INSERT INTO mkl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ammɑ ɑn sɔ̃ ŋɑ si wɑjui inɛ fei n ni, n kù mɑ̀ ŋɛ ɑjɔ kɑ̃mɑ. I sɛkɛɛ hɑi bi tom, iŋɛ iyi i kù ce idɔɔbim ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesu í kpɑ nŋɑ mɔndɑ mɑ́ í ni, nɑ nŋu, inɛ iyi í ɡbɔ ide iyi ǹ wɑ n fɔu ihɛ̃ fei nɔ wɑ jirimɑɛ, ɑ́ yɛi bɛi mɔkɔ ilu bisi iyi í mɑ ileɛ si kutɑ. ");
INSERT INTO mkl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ijĩ í rɔ, ido í kɔ̃ í nikɑ̃, nɔ fufu nlɑ nlɑ í dede si ileu, ɑmmɑ kù cuku, domi si kutɑi ɑ̀ mɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ammɑ ɑwɔ iyi ì ɡbɔ ide iyi ǹ wɑ n fɔu ihɛ̃ fei nɔ i kù sɑɑluɛ, ɑɑ yɛi bɛi mɔkɔ nnyɛi iyi í koo í mɑ ileɛ si sɑ̃ɑi ido. ");
INSERT INTO mkl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ijĩ í rɔ, ido í kɔ̃ í nikɑ̃, nɔ fufu nlɑ nlɑ í dede si ileu, nɔ í cuku í lɛɡɛ fei. ");
INSERT INTO mkl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃, ŋɔi zɑmɑɑu í biti do si bɛi wɑ kɔ ŋɑ si cio. ");
INSERT INTO mkl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","À bitii si nɑ iyi í jɔ̀ do yiikoi wɑ kɔ ŋɑ si, kù jɛ bɛi woo kɔ inɛ ŋɑ si woodɑ nŋɑ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu í sɔ̃ ŋɑ ide ŋɑu ihɛ̃ feii í bɛi wɑ kitɑ wɑ hɑi si ɑntɑi kutɑu. Wɑɑti iyi í kitɑ wɑ ŋɔi zɑmɑɑ nlɑ ɡɔ wɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nɔ dintɛ ɡɔ í nɑɑ í sɛɛbɑtɑ si wɑjuɛ í ni, Lɑfɛ̃ɛ, bii ì bi, ɑɑ yɔkɔ i jɔ̀ n bɑ iri n jɛ inɛ iyi í mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ŋɔi Jesu í yɔ ɑwɔɛ í luu nɔ í ni, ǹ bi. Bɑ iri nɔ i jɛ inɛ kumɑ́. Bɛ ɡbɑkɑ̃ í bɑ iri hɑi si bɔ̃ɔɛu. ");
INSERT INTO mkl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nɔ Jesu í sɔ̃ɔ í ni, ɡbɔ, mɑɑ̀ sɔ̃ inɛ ɡɔ ideu ihɛ̃, ɑmmɑ koo nyisi ɑrɑɛ bi woo weei Ilɑɑɔ̃u, nɔ i ce kuwee iyi Moizi í jilɛu. Kuweeu bɛi ɑ́ nyisi ŋɑ iyi ì jɛ inɛ iyi í mɑ́ bɛbɛi. ");
INSERT INTO mkl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ŋɔi Jesu í bɔ Kɑpɛrɑnumu. Wɑɑti iyi í lɔ inɔ iluu ŋɔi inɛ nɡboi sooɡe cĩɔ ɡɔ í koo í tɔɔɛ ku fɑɑbɑ nŋu, ");
INSERT INTO mkl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","í ni, Lɑfɛ̃ɛ, ɑmɑɑcɛm wɑ ce bɔ̃ɔ kpɑsɛ̃, ci yɑ yɔkɔ ku wu bɑɑ ɑwɔ, wɑ kpɑ̃ɑ iju ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ŋɔi Jesu í ni, í sĩɑ, ɑn koo n fɑɑbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ammɑ inɛ nɡboi sooɡe ŋɑu í jɛɑɑ í ni, Lɑfɛ̃ɛ, n kù to i lɔ kpɑsɛ̃m. Bɑɑ hɑi ihɛ̃ fɔ ide, ɑmɑɑcɛm nɔu ɑ́ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Amu tɑkɑm, ǹ nɛ inɛ nɡbo ŋɑ iyi ǹ wɑ n jirimɑ, nɔ ǹ nɛ sooɡe ɡɔ ŋɑ mɔ iyi ǹ wɑ n ɡbɑ̃. Inɛ ɑkɑ̃ nŋɑ iyi ǹ bɛ ɑ́ kooi, inɛ iyi ǹ kpe mɔ ɑ́ nɑɑi, nɔ icɛ iyi ǹ ni ɑmɑɑcɛm ku ce nŋui í yɑ ce. ");
INSERT INTO mkl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iyi Jesu í ɡbɔ ideu í biti nɔ í sɔ̃ inɛ ŋɑ iyi ɑ̀ wɑɑ tooɛu í ni, ntɔ ntɔ, bɑɑ si inɔi inɛi Izirɛli ŋɑ fei n kù yɛ inɛ iyi í yɔkɔ í dɑsim nɑɑnɛ nlɑ bɛi inɛɛu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","An sɔ̃ ŋɛ, hɑi jɛ Zuifu nkpɔ ɑ́ nɑ ku nɑɑ hɑi do bii fei ɑ bubɑ si bommɑi Ilɑɑɔ̃. Aŋɑi ɑɑ jɛ do Aburɑhɑmu do Izɑɑki do Zɑkɔbu bɑlɑ nŋɛ ŋɑ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ammɑ iŋɛ, tɔku nŋɑ ŋɑ iyi í jɔ iŋɛò ŋɑ i wɑ bɛ ɑɑ nyɔ ŋɛ ɑnɡule si ilu kuku. Tenɡi bɛi ɑɑ lesi ɑwɔ si iri i mɑɑ kpɑtɑò ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nɔ Jesu í sɔ̃ inɛ nɡboi sooɡe ŋɑu í ni, bɔ kpɑsɛ̃ɛ. Fei ndɛɛ ɑ́ ce si bɛi ì dɑsi nɑɑnɛu. Bɛ ɡbɑkɑ̃ ɑmɑɑcɛu í bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Si ɑnyiɛ, Jesu í bɔ kpɑsɛ̃i Piɛɛ, í koo í bɑ iyei ɑboi Piɛɛ kù wɑɑ nɛ bɑɑni, wɑ sũò ɑrɑ ɡbɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ŋɔi Jesu í lu ɑwɔɛ nɔ ɑrɑ ɡbɑ̃ɑu í nyɑ. Nɔ ɑbou í dede í yɑɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iyi ɑlɛ í lɛ, ɑ̀ nɑɑ Jesu inɛ ŋɑ iyi ɑ̀ nɛ inɛi inɔɔko ŋɑ wɑ nkpɔ nkpɔ. Nɔ í lele inɛi inɔɔko ŋɑu do ide ku fɔ, nɔ inɛ ŋɑ iyi ɑ̀ wɑɑ ce bɔ̃ɔ fei í jɔ̀ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Í ce nŋu ŋɑu bɛi ku bɑ ide iyi wɑlii Ezɑi í fɔu ku kɔ̃ iyi í ni, nŋu tɑkɑɛ í so ɡbuɡbɑ̃ hɑi nɛ nwɑ nɔ í nyɑ bɔ̃ɔ nwɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ajɔ nŋu ɡɔ, zɑmɑɑ nkpɔ ɡɔ í kɑɑko Jesu. Iyi Jesu í yɛ ŋɑ ŋɔi í sɔ̃ mɔcɔɛ ŋɑu í ni ɑ bɔ icei tenkuu do ikpɑ ihɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hee ɑ mɑɑ nɛ ŋɔi woo kɔ inɛ ŋɑ si woodɑ ɡɔ í nɑɑ bi tɛɛ nɔ í ni, Mɛɛtu, ɑn tooɛ bii ì wɑɑ bɔ fei. ");
INSERT INTO mkl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nɔ Jesu í sɔ̃ɔ í ni, iŋɑ ŋɑ ɑ̀ nɛ kolo ŋɑ nɔ bɑɑ yɛi ŋɑ mɔ ɑ̀ nɛ bi ku sũ. Ammɑ ɑmu Amɑi Amɑnɛ n kù nɛ bii ɑn koo n sũ n sĩmi. ");
INSERT INTO mkl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nɔ inɛ ɑkɑ̃i mɔcɔi Jesu ɡɔ mɔ í ni, Lɑfɛ̃ɛ, jɔ̀ n koo n si bɑɑm wɑ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ammɑ Jesu í jɛɑɑ í ni, ɑwɔ de toom wɑ, nɔ i jɔ̀ iku ŋɑ ɑ si iku nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Si ɑnyii nŋu, Jesu í lɔ ɑkɔi inyi nɔ mɔcɔɛ ŋɑ mɔ ɑ̀ lɔ ɑ̀ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Iyi ɑ̀ wɑɑ nɛ ŋɔi fufu nlɑ ɡɔ í dede si tenkuu hee kutɑ̃nɡɑ̃m ndii inyiu wɑ bii ɑkɔu. Ammɑ Jesu wɑ sĩ njoo. ");
INSERT INTO mkl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ŋɔi mɔcɔ ŋɑu ɑ̀ koo ɑ̀ jũu ɑ̀ ni, Lɑfɛ̃ɛ, fɑɑbɑ wɑ, ɑ̀ wɑɑ bɔ nfe ku ce. ");
INSERT INTO mkl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, nɑɑnɛ ku dɑsi nŋɛ kù lɑ. Nɑ mii í ce ì jɔ̀ njo wɑ mu ŋɛ ŋɑ. Iyi í fɔ bɛɛbɛ í tɑ̃, ŋɔi í dede í lɑ si inyiu do fufuu nɔ ɑ̀ coko sɔ̃m sɔ̃m. ");
INSERT INTO mkl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nɔ mɔcɔ ŋɑu fei ɑ̀ biti ɑ̀ wɑɑ ni, inɛ dimi yoomɑi ihɛ̃. Bɑɑ inyi do fufu ŋɑ fei ɑ̀ wɑɑ jirimɑ ideɛ. ");
INSERT INTO mkl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iyi Jesu í to icei tenkuu do ikpɑ ihɔ̃ si ilɛi Gɑdɑrɑ, ŋɔi ɑmɑnɛ minji ɡɔ ŋɑ ɑ̀ fitɑ wɑ hɑi bi ku si iku ŋɑ ɑ̀ kòo wɑ. Inɛ ŋɑu ɑ̀ nɛ inɛi inɔɔko ku ɡɑɑbu ntɔ ntɔ hee í jɔ̀ inɛ ɡɔ ci yɑ jɛ ku too kpɑ̃ɑu. ");
INSERT INTO mkl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nɔ ɑ̀ dɔ̃ ɑnu ɑ̀ ni, mii í wɑ si ɡɑ̃mɛi ɑwɑɛ ŋɑ, ɑwɔ Amɑi Ilɑɑɔ̃. Ì nɑɑ ku kpɑ̃ wɑ iju hɑi wɑɑtiu kù toi? ");
INSERT INTO mkl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nɔ ɑ̀ hɔ̃nnɛ kuusɔɔ ɡɑɑ ɡɔ ŋɑ wɑju ɑ̀ wɑɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nɔ inɛi inɔɔko ŋɑu ɑ̀ tɔɔ Jesu ɑ̀ ni, bii ì wɑɑ lele wɑi, jɔ̀ kɑɑ mu kuusɔɔ ɡɑɑ ŋɑu ihɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ŋɔi Jesu í sɔ̃ ŋɑ í ni ɑ koo. Nɔ ɑ̀ fitɑ hɑi si inɛ ŋɑu ɑ̀ koo ɑ̀ mu kuusɔɔ ŋɑu. Nɔ kuusɔɔ ɡɑɑ ŋɑu fei ɑ̀ sɛi wɑ hɑi ɑntɑi iri kutɑu ɑ̀ nɑ ɑ̀ dɑsi tenkuu, inyi í jɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Woo deɡbe kuusɔɔ ŋɑu ɑ̀ sɑ ɑ̀ nɛ inɔ ilu ɑ̀ koo ɑ̀ sisiɑ inɛ ŋɑ ideu fei do bɛi ɑ̀ ceɑ inɛ minji ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nɔ inɛi inɔ ilu ŋɑu fei ɑ̀ fitɑ ɑ̀ bɔ Jesu ku cɔ. Iyi ɑ̀ koo ɑ̀ yɔɔ ŋɔi ɑ̀ tɔɔɛ ku fitɑ hɑi ilɛi ide nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iyi inɛ ŋɑu ɑ̀ tɔɔɛ ku fitɑ hɑi ilɛi ide nŋɑ ŋɔi Jesu í lɔ ɑkɔi inyi í kuɑ icei tenkuu mɑ́. Í nɛ ilui nŋu tɑkɑɛ . ");
INSERT INTO mkl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ŋɔi inɛ ɡɔ ŋɑ ɑ̀ nɑɑ wɛɛɡɛ ɡɔ wɑ, wɑ sũ si mɑkɛɛ. Iyi Jesu í yɛ nɑɑnɛ ku dɑsi nŋɑu, nɔ í sɔ̃ wɛɛɡɛu í ni, bɑɑkɔɔm, mɑɑ̀ mɔnɡɔ temuɑ, ǹ kpɑ idei dulum dɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wee woo kɔ inɛ ŋɑ si woodɑ ɡɔ ŋɑ ɑ̀ wɑ bɛ. Iyi ɑ̀ ɡbɔ wɑ fɔ bɛɛbɛ ŋɔi ɑ̀ wɑɑ lɑsɑbu si idɔ nŋɑ ɑ̀ wɑɑ ni, inɛɛu ihɛ̃ wɑ bu Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesu í bɛi í mɑ̀ ide iyi ɑ̀ wɑɑ lɑsɑbu ŋɔi í ni, nɑ mii í ce ì wɑɑ ce lɑsɑbu lɑɑlɔ bɛɛbɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Si ide minji ŋɑu ihɛ̃, yoomɑi kufɔɛ í fɑɑlɑ í re, inɛ ku sɔ̃ inɛ ɡɔ ku ni ǹ kpɑ idei dulum dɛɛ, wɑlɑkɔ ku ni ku dede ku nɛ. ");
INSERT INTO mkl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ammɑ ǹ bi i mɑ̀ ŋɑ iyi ɑmu Amɑi Amɑnɛ ǹ nɛ ɡbuɡbɑ̃ n kpɑ idei dulum dii inɛ ŋɑ si ɑndunyɑ. Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi í sɔ̃ wɛɛɡɛu í ni, dede i so mɑkɛɛɛ i bɔ kpɑsɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ŋɔi wɛɛɡɛu í dede í nɛ ideɛ. ");
INSERT INTO mkl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wee inɛ nkpɔ nkpɔi í wɑ bɛ. Iyi ɑ̀ yɔɔ bɛɛbɛ ŋɔi njo í mu ŋɑ ɑ̀ wɑɑ sɑɑbu Ilɑɑɔ̃ do iyi í nɑ ɑmɑnɛ dimii yiikou bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ŋɔi Jesu í dede hɑi bɛ í bɔ inɔ iluu. Iyi wɑ nɛ ŋɔi í yɛ mɔkɔ ɡɔ iyi ɑ̀ yɑ kpe Mɑtie wɑ bubɑ ile bi ku ɡbɑ fiɑi lɛmpoo. Ŋɔi í sɔ̃ɔ í ni, toom wɑ. Nɔ Mɑtie í dede í tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Si ɑnyiɛ Jesu wɑ jɛ kpɑsɛ̃i mɔkɔu, ŋɔi woo ɡbɑ fiɑi lɛmpoo do inɛ nkpɔ ɡɔ ŋɑ mɑ́ iyi kuwɛɛ nŋɑ kù sĩɑ ɑ̀ nɑɑ ɑ̀ bubɑ bi Jesu do mɔcɔɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wee Fɑrisi ɡɔ ŋɑ ɑ̀ yɛ ŋɑ, nɔ ɑ̀ bee mɔcɔɛ ŋɑu ɑ̀ ni, nɑ mii í ce Mɛɛtu nŋɛ wɑ jɛ do woo ɡbɑ fiɑi lɛmpoo do inɛ lɑɑlɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iyi Jesu í ɡbɔ ide nŋɑu ŋɔi í ni, ilu bɑɑni ŋɑ ɑ kù nɛ bukɑɑtɑi ilu iwɔ bii kù jɛ bɔ̃ɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ǹ wɑ n sɔ̃ ŋɛi, n kù nɑɑ ku kpe inɛ dee dee ŋɑ, ɑmmɑ dulum ŋɑi ǹ nɑɑ ku kpe. I koo i bee yɑɑsei kukɔu iyi í ni, Ilɑɑɔ̃ í ni, ǹ bi i ce ɑrɑɑrei njɛ ŋɑ ku re i ceem kuwee. ");
INSERT INTO mkl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wee Zɑ̃ɑ woo dɑsi inyiu mɔ í nɛ mɔcɔ ŋɑ. Mɔcɔɛ ŋɑu ɑ̀ nɑɑ bi Jesu nɔ ɑ̀ beeɛ ɑ̀ ni, nɑ mii í ce ɑwɑ do Fɑrisi ŋɑu ɑ̀ yɑ kɑ dĩ ɑnu ɑmmɑ ɑwɔ, mɔcɔɛ ŋɑ ɑ ci yɑ dĩ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nɔ Jesu í jɛ nŋɑ í ni, kpɑɑsii mɔkɔ titɔ̃ ŋɑ ɑɑ nɛ inɔ kufɔ ɡɔ wɑɑti iyi mɔkɔ titɔ̃u í wɑ inɔ nŋɑi? Aɑwo, ɑmmɑ ɑjɔ ɡɔ wɑ nɑɑ iyi ɑɑ nyɑ mɔkɔ titɔ̃u hɑi si inɔ nŋɑ. Wɑɑti bɛɛbɛ ɑɑ dĩ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ŋɔi í kpɑ nŋɑ mɔndɑ í ni, inɛ ɡɔ kɑɑ sɔ jɑɑɛ nɡbo do titɔ̃ɛ ku tɔtɔɔɛ. Bii í ce bɛɛbɛ, titɔ̃u ɑ́ ɡɑ jɑɑɛ nɡbou ku kɔ̃ɔsi. ");
INSERT INTO mkl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bɛɛbɛ mɔi ɑ ci yɑ dɑsi vɛ̃ɛ titɔ̃ iyi wɑ ɡbɑ si bɔɡɔ bɑtɑ nɡbo ŋɑ. Bii ì ce bɛɛbɛ, bɔɡɔ bɑtɑ nɡbo ŋɑu ɑɑ ɡɑi, nɔ vɛ̃ɛu ku nikɑ̃, bɔɡɔ ŋɑu mɔ ɑ́ ce nfe. À yɑ dɑsi vɛ̃ɛ titɔ̃i si bɔɡɔ titɔ̃ ŋɑ. Bɑɑ bii wɑ ɡbɑ, bɔɡɔu kɑɑ ɡɑ. ");
INSERT INTO mkl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Si wɑɑti iyi Jesu wɑ sɔ̃ ŋɑ ideu ihɛ̃ ŋɔi inɛ nɡbo ɡɔ í nɑɑ í sɛɛbɑtɑ si wɑjuɛ í ni, ɑmɑ inɑɑbom wee í ku nsɛi nsɛi, ɑmmɑ nɑɑ le siɛ ɑwɔ ku jĩ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nɔ Jesu í dede do mɔcɔɛ ŋɑ ɑ̀ too mɔkɔu. ");
INSERT INTO mkl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Wɑɑti iyi ɑ̀ dɑsi kpɑ̃ɑ ɑ̀ wɑɑ nɛ, inɑɑbo ɡɔ wɑ too ŋɑ. Abou wɑ ce bɔ̃ɔi ɑwɔ ku mu hɑi ɑdɔ̃ mɑɑteeji wɑ. Ŋɔi í bɔ do ɑnyii Jesu í koo í lu itĩi ibɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Í ce bɛɛbɛi si nɑ iyi í jɔ̀ í fɔ si idɔɛ í ni, bɑɑ bii jɑɑɛi ǹ bɑ ǹ lu ɑn bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ŋɔi Jesu í sindɑ í cɔɔ nɔ í ni, ɑbooyi, mɑɑ̀ mɔnɡɔ temuɑ, nɑɑnɛɛi í fɑɑbɑɛ. Bɛ ɡbɑkɑ̃ ɑbou í bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ŋɔi Jesu í mɔsi isɛɛnɛɛ í to kpɑsɛ̃i inɛ nɡbou í yɛ woo fɑ̃ ɡɑɑsiɑi iku ŋɑ do zɑmɑɑ nlɑ nlɑ ɡɔ wɑ dɔ̃ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nɔ í ni, i fitɑ hɑi ihɛ̃. Amɑ inɑɑbou kù ku, wɑ sĩ njooi, nɔ ɑ̀ wɑɑ yɑɑkoɛ. ");
INSERT INTO mkl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ŋɔi Jesu í jɔ̀ inɛ ŋɑu ɑ̀ fitɑ nɔ í lɔ í mu ɑwɔi mudɛ̃ɛu nɔ í dede. ");
INSERT INTO mkl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nɔ lɑɑbɑɑui ideu í fɑnɡɑɑ si ilɛu fei. ");
INSERT INTO mkl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nɔ Jesu í nɛ hɑi bɛ. Si isɛɛnɛɛu fɛɛju minji ɡɔ ŋɑ ɑ̀ tooɛ ɑ̀ wɑɑ dɔ̃ siɛ ɑnu, ɑ̀ wɑɑ ni, tɔkui ilɑɑlu Dɑvidi, ce ɑrɑɑre nwɑ i jɔ̀ kɑ yɛ ilu. ");
INSERT INTO mkl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ŋɔi Jesu í nɛ hee í to kpɑsɛ̃. Nɔ fɛɛju ŋɑu ɑ̀ nɑɑ bi tɛɛ nɔ í bee ŋɑ í ni, ì dɑsi nɑɑnɛ ŋɑ iyi ɑn yɔkɔ n coo? Nɔ ɑŋɑ mɔ ɑ̀ ni, oo, Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nɔ Jesu í lu iju nŋɑu í ni, ku ce nŋɛ si bɛi ì dɑsi nɑɑnɛu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nɔ ɑ̀ yɛ ilu. Nɔ Jesu í sɔ̃ ŋɑ í kɔnkɔn du ŋɑ í ni, i ɡbɔ ŋɑ, i mɑɑ̀ sɔ̃ inɛ ɡɔ ideu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ammɑ iyi ɑ̀ sɛkɛɛ ɡbɑkɑ̃ ɑ̀ lɔsi lɑɑbɑɑui Jesuu ku sisi si ilɛu fei. ");
INSERT INTO mkl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nɔ Jesu do mɔcɔɛ ŋɑ ɑ̀ nɛ hɑi bɛ, ŋɔi ɑ̀ nɑɑ Jesu inɛ ɡɔ wɑ. Inɛɛu inɛi inɔɔko dekĩ ɡɔ í muu. ");
INSERT INTO mkl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nɔ Jesu í lele inɛi inɔɔkou. Iyi í leleɛ ɡbɑkɑ̃ nɔ mɔkɔu í lɔsi ide ku fɔ. Inɛ ŋɑ ɑ̀ biti ɑ̀ wɑsi ku ni, ɑ kù yɛ dimiɛ si ilɛi Izirɛli ɑjɔ kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ammɑ Fɑrisi ŋɑu ɑ̀ ni, Seetɑm ilɑɑlui inɛi inɔɔko ŋɑui í muɑɑ ɡbuɡbɑ̃ ku leleò ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu wɑ dɑbii dɑbii si ilu nlɑ ŋɑ do si ilɛɛko ŋɑ, wɑ kɔ inɛ ŋɑ si cio ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ nŋɑ ŋɑ, nɔ wɑ sisi lɑɑbɑɑu jiidɑi bommɑi Ilɑɑɔ̃ nɔ í jɔ̀ bɔ̃ɔ ŋɑ do kɔ̃ɔ ŋɑ fei ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iyi í yɛ zɑmɑɑu, ɑrɑɑre fei í muu, domi ɑ̀ wɛɛ do biti, inɔ nŋɑ fei í fɔ, ɑ̀ wɛɛ nŋɑ bɛi ɑnɡudɑ̃ ŋɑ iyi ɑ kù nɛ woo deɡbe. ");
INSERT INTO mkl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ŋɔi í sɔ̃ mɔcɔɛ ŋɑ í ni, ɑmɑɑjɛ iyi í jĩɑ í to ku dɑ í kpɔ, ɑmmɑ woo dɑ ŋɑu ɑ kù kpɔ. ");
INSERT INTO mkl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nɑ nŋu, i tɔɔ ilu ikou ku bɛ woo dɑ ŋɑ wɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Si ɑnyii nŋu, Jesu í kpe mɔcɔ mɑɑteejiɛ ŋɑu í tɔtɔɔ ŋɑ bi tɛɛ. Nɔ í mu nŋɑ yiiko ɑ leleò inɛi inɔɔko ŋɑ nɔ ɑ jɔ̀ kɔ̃ɔ ŋɑ ɑ bɑ iri do inɛ ŋɑ iyi ɑ̀ wɑɑ ce bɔ̃ɔ dimi ikɑ̃ ikɑ̃ fei. ");
INSERT INTO mkl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Irii woo bɛ mɑɑteeji ŋɑu wee. Sinte, Simɔɔ iyi ɑ̀ yɑ kpe Piɛɛu do ifɔɛ Anderee, do ɑmɑ minjii Zebedee ŋɑ Zɑɑki do ifɔɛ Zɑ̃ɑ, ");
INSERT INTO mkl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","do Filipu do Bɑɑtelemi, do Tomɑɑ, do Mɑtie iyi í tɑko í jɛ woo ɡbɑ fiɑi lɛmpoo, do Zɑɑki ɑmɑi Alifee do Tɑdee, ");
INSERT INTO mkl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","do Simɔɔ inɛi iɡbɛi Zelɔtu , do Zudɑsi Isikɑriɔti, inɛ iyi ɑ́ nɑ ku zɑmbɑɛu. ");
INSERT INTO mkl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesu í bɛ ɑmɑnɛ mɑɑteeji ŋɑu nɔ í sɔ̃ ŋɑ bɛi nŋu í bi ɑ ce. Í ni, i mɑɑ̀ bɔ bi dimi mmu ŋɑ, nɔ i mɑɑ̀ lɔ si ilui inɛi Sɑmɑri kɑ̃mɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ammɑ i bɔ bi inɛi Izirɛli ŋɑ, ɑŋɑ iyi ɑ̀ nyɔ bɛi ɑmɑ ɑnɡudɑ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","I koo i wɑɑzo ŋɑ i ni, Ilɑɑɔ̃ í mɑɑi ku jɛ bommɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nɔ i jɔ̀ bɔ̃ɔ ŋɑ ɑ bɑ iri nɔ i jĩ iku ŋɑ, i jɔ̀ dintɛ ŋɑ ɑ bɑ iri ɑ jɛ inɛ kumɑ́, nɔ i lele inɛi inɔɔko ŋɑ iyi ɑ̀ wɑ si inɛ ŋɑ. Si bɛi ì bɑ hɑi nɛ kusɑ̃ ŋɑ, iŋɛ mɔ i nɑ hɑi nɛ kusɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","I mɑɑ̀ ti i so fiɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","I mɑɑ̀ ti i so bɔɡɔ, i mɑɑ̀ ti i so ibɔ minjisiɑ, wɑlɑ bɑɑtɑ, wɑlɑ ɡolo. I mɑɑ̀ so mii ŋɑu bɛ kɑ̃mɑ ŋɑ si nɑ iyi í jɔ̀ woo ce icɛ í nɛ kpɑ̃ɑi ɑ nɑ́ɑ bukɑɑtɑi mii iyi í nɛ ku mɑɑ wɛɛò. ");
INSERT INTO mkl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Bii ì to ilu nlɑ wɑlɑkɔ si ilɛɛko ɡɔ, i dɛdɛ inɛ iyi í jɛsi ku ɡbɑ ŋɛ, nɔ i bubɑ kpɑsɛ̃ɛ bɛ ŋɑ hee ku to ɑjɔ iyi ì wɑɑ nɛ hɑi si iluu. ");
INSERT INTO mkl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bii ì lɔ kpɑsɛ̃ ɡɔ i yɑ ce inɛ ŋɑu fɔɔ i ni ŋɑ, lɑɑkɑi ku sũ ku wɛɛ do iŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Bii ɑ̀ ɡbɑ ŋɛ, lɑɑkɑi ku sũu ɑ́ wɛɛ do ɑŋɑi, ɑmmɑ bii ɑ kù ɡbɑ ŋɛ, ɑ́ bɑɑ si ŋɛi. ");
INSERT INTO mkl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Si ilu ɡɔ wɑlɑ si kpɑsɛ̃ ɡɔ, bii inɛ ŋɑu ɑ̀ kɔ ku ɡbɑ ŋɛ, hee mɑ́ jɛ ɑ ɡbɔ ide nŋɛ, i nɛ hɑi bɛ nɔ i ɡbuɡbɑ̃ nŋɑ irurui bɑɑtɑ nŋɛ ŋɑ ku bɑ ku jɛ nŋɑ sɛɛdɑ iyi kiitii Ilɑɑɔ̃ ɑ́ nɑɑ si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ntɔ ntɔ, ɑn sɔ̃ ŋɛ, si ɑjɔi kiitiu, Ilɑɑɔ̃ ɑ́ ce ɑrɑɑrei inɛi Sodomu do Gɔmɔɔ ŋɑ ku re inɛi ilu dimi bɛɛbɛ ŋɑu bɛ ");
INSERT INTO mkl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesu í sɔ̃ ŋɑ mɑ́ í ni, wee ǹ wɑ n bɛ ŋɛ nɔ ɑɑ yɛ ŋɑi bɛi ɑnɡudɑ̃ ŋɑ si inɔi mbo ŋɑ. Nɑ nŋu, i jɔ̀ i nɛ bisi bɛi njo ŋɑ, , nɔ i jɛ hɑi ce lɑɑlɔ bɛi ɑnkɑsiidi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nɔ i ce lɑɑkɑi ŋɑ si nɑ iyi í jɔ̀ inɛ ɡɔ ŋɑ ɑɑ nɑ ɑ mu ŋɛ ɑ bɔò ŋɛ bi ku ce kiiti, ɑɑ nɔ ɑ cɑ̃ ŋɛ ile bi ku ce kutɔtɔɔ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aɑ bɔò ŋɛ si wɑjui ilu ilɛ ŋɑ do bi ɑmɑnlu ŋɑ nɑ irim, ku bɑ i jɛ sɛɛdɑm si wɑju nŋɑ ŋɑ do bi dimi mmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ammɑ bii ɑ̀ bɔò ŋɛ bi ku kiiti, i mɑɑ̀ ti i biti do ide iyi ɑɑ fɔ ŋɑ wɑlɑ do yɑɑse bɛi ɑɑ fɔɔò ŋɑ. Bii wɑɑtiu í to, Ilɑɑɔ̃ ɑ́ mu nŋɛ ide iyi ɑɑ fɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nɔ ide iyi ɑɑ fɔ ŋɑ kɑɑ jɛ ide nŋɛ, ɑ́ nɑɑi hɑi bi Hundei Ilɑɑɔ̃ Bɑɑ nŋɛ iyi í wɑ si ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Inɛ ɡɔ ŋɑ ɑɑ zɑmbɑ ifɔ nŋɑ ŋɑ wɑlɑkɔ iɡbɑ̃ nŋɑ ŋɑ ku bɑ ɑ kpɑ ŋɑ. Bɛɛbɛ mɔi bɑɑ ŋɑ ɑɑ mɑɑ ceɑ ɑmɑ nŋɑ ŋɑ. Amu ŋɑ mɔ ɑɑ dede si bɑɑ nŋɑ ŋɑ ku bɑ ɑ kpɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Inɛ fei ɑ́ cé ŋɛi nɑ irim, ɑmmɑ inɛ iyi í temuɑ hee kɔɔ ɑ́ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bii ɑ̀ wɑɑ kpɑ̃ ŋɛ iju si ilu ɡɔ i sɑ i bɔ ilu mmu. Ntɔ ntɔ, ɑn sɔ̃ ŋɛ, i kɑɑ dɑbii si ilɛi Izirɛliu i kpɑ iriɛ ŋɑ ɑmu Amɑi Amɑnɛ n to wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Amɑ cio ci yɑ re woo kɔsiɛ, ɑmɑɑcɛ mɔ ci yɑ re lɑfɛ̃ɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nɑ nŋu, í sĩɑ ɑmɑ cio ku jɛsi ɑ ceɑ nŋu bɛi ɑ̀ ceɑ woo kɔsiɛ. Bɛɛbɛ mɔi, í sĩɑ ɑmɑɑcɛ mɔ ku jɛsi ɑ ceɑ nŋu bɛi ɑ̀ ceɑ lɑfɛ̃ɛɛ. Bii ɑ̀ wɑɑ kpe ɑmu ilu kpɑsɛ̃u Seetɑm, ɑɑ sɔ iŋɛ inɛi kpɑsɛ̃ɛ ŋɑu iri lɑɑlɔ iyi í re bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nɔ Jesu í ni mɑ́, do nŋu fei i mɑɑ̀ ce njo nŋɑ ŋɑ, domi nɡɔɡɔ kù wɛɛ iyi wɑ mɑnji iyi kɑɑ fitɑ ɡbuɡbɑ̃ɑ, nɔ ɑsii kɑ̃mɑ kù wɛɛ iyi ɑ kɑ̀ɑ nɑ ɑ mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Iyi ǹ wɑ n sɔ̃ ŋɛ si ilu kuku, i fɔɔ si inyɑ kumɑ́ ŋɑ. Iyi ì ɡbɔ si ɑsii ŋɑ i cɑ̃ kɛsɛɛdɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","I mɑɑ̀ ce njoi inɛ ŋɑ iyi ɑɑ kpɑ ɑrɑ nŋu ɑkɑ̃, nɔ ɑ kɑɑ yɔkɔ ɑ kpɑ hunde. Ammɑ i ce njoi inɛ iyi ɑ́ yɔkɔ ku kpɑ ɑrɑ do hunde ɑjɔ si inɑ iyi ci yɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","A ci yɑ tɑ ɑmɑ yɛi minji súù ɑkɑ̃ bɑ. Do nŋu fei, Ilɑɑɔ̃ wɑ mɑ̀ bɑɑni nŋɑ. Bɑɑ ɑkɑ̃ nŋɑ ci yɑ nɔ ku ku iyi kù jɛ do kumɑ̀siɛ. ");
INSERT INTO mkl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Iŋɛ mɔ, hee do ntoi iri nŋɛ ŋɑ fei Ilɑɑɔ̃ í mɑ̀ jĩɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nɑ nŋu, i mɑɑ̀ ce njo ŋɑ, bɛɛrɛ nŋɛ í re yɛi ŋɑ hee bii í jĩ. ");
INSERT INTO mkl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nɑ nŋu, inɛ iyi í fɔ si wɑjui ɑmɑnɛ ŋɑ í ni nŋu í ɡbɑm, ɑmu mɔ ɑn ɡbɑɑ si wɑjui Bɑɑm iyi í wɑ lele. ");
INSERT INTO mkl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ammɑ inɛ iyi í kɔsim si wɑjui ɑmɑnɛ ŋɑ, ɑmu mɔ ɑn kɔsiɛ si wɑjui Bɑɑm iyi í wɑ lele. ");
INSERT INTO mkl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Í sɔ̃ ŋɑ mɑ́ í ni, i mɑɑ̀ tɑmɑɑ mɑ̀ lɑɑkɑi ku sũi ǹ nɑɑ nŋɛ wɑ si ɑndunyɑ. Aɑwo, ijɑi ǹ nɑɑò wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ǹ nɑɑ ku kosi ɑmɑ inɛmɔkɔ do bɑɑɛi, ɑmɑ inɑɑbo mɔ do iyeɛ, ɑso mɔkɔ mɔ do iyei mɔkɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Inɛi kpɑsɛ̃ nŋɛ ŋɑi ɑɑ jɛ mbɛɛ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Inɛ iyi í bi bɑɑɛ wɑlɑkɔ iyeɛ í rem, lɑfɛ̃ɛ kù to ku jɛ inɛm. Bɛɛbɛ mɔi inɛ iyi í bi ɑmɑ inɛmɔkɔɛ wɑlɑkɔ ɑmɑ inɑɑboɛ í rem, lɑfɛ̃ɛ kù to ku jɛ inɛm. ");
INSERT INTO mkl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Inɛ iyi kù jɛsi nŋu ku so jĩi ku ɡɑɑuɛ ku toom do wɑ, kù to ku jɛ inɛm. ");
INSERT INTO mkl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Inɛ iyi í bi ku jɛ kuwɛɛ do idɔɔbiɛ ɑ́ nɑ ku kuɑɛ. Ammɑ inɛ iyi í kɔsi kuwɛɛɛ nɑ irim, lɑfɛ̃ɛ ɑ́ nɑ ku bɑ́ɑ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesu í ni mɑ́, inɛ iyi í ɡbɑ ŋɛ í ɡbɑm nii, nɔ inɛ iyi í ɡbɑm í ɡbɑ inɛ iyi í bɛm wɑi. ");
INSERT INTO mkl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Inɛ iyi í ɡbɑ wɑlii si nɑ iyi í jɔ̀ Ilɑɑɔ̃ í bɔɔ wɑ, Ilɑɑɔ̃ ɑ́ nɑ nŋu mɔ ribɑi wɑlii, nɔ inɛ iyi í ɡbɑ ɑmɑnɛ iyi wɑ ce idɔɔbii Ilɑɑɔ̃ si nɑ iyi í jɔ̀ í jɛ dee dee, Ilɑɑɔ̃ ɑ́ nɑ nŋu mɔ ribɑi inɛ dee dee. ");
INSERT INTO mkl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Inɛ mɔ iyi í muɑ tɑɑkɑ ɡɔ bɑɑ inyi tũtũ si nɑ iyi í jɔ̀ í jɛ mɔcɔm, ǹ wɑ n sɔ̃ ŋɛi, lɑfɛ̃ɛ kɑɑ kuɑ ribɑɛ pɑi. ");
INSERT INTO mkl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wɑɑti iyi Jesu í sɔ̃ mɔcɔ mɑɑteejiɛ ŋɑu ide ŋɑu fei í tɑ̃, ŋɔi í nɛ hɑi bɛ í koo í dɑbii si ilui Gɑlilee ŋɑu í kɔ inɛ ŋɑ si cio nɔ í ce nŋɑ wɑɑzo. ");
INSERT INTO mkl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wee wɑɑti bɛɛbɛ Zɑ̃ɑ woo dɑsi inyiu í wɑ piisɔ̃ɔ. Nɔ hɑi ile piisɔ̃ɔ bɛ í ɡbɔ bɑɑui icɛi Jesu iyi ɑ̀ yɑ kpe Kirisi. Ŋɔi í bɛ siɛ mɔcɔɛ ɡɔ ŋɑ ");
INSERT INTO mkl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ɑ koo ɑ beeɛ ɑ ni, ɑwɔi ì jɛ inɛ iyi Ilɑɑɔ̃ ɑ́ nɑ ku bɛ wɑu? Mɑ̀ kɑ deɡbe inɛ mmu ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nɔ Jesu í jɛ nŋɑ í ni, i koo i sisiɑ Zɑ̃ɑ mii iyi ì yɛ do iyi ì ɡbɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Fɛɛju ŋɑ ɑ̀ wɑɑ yɛ ilu, woo sukutɛ ŋɑ ɑ̀ wɑɑ nɛ dee dee, dintɛ ŋɑ ɑ̀ bɑ iri ɑ̀ jɛ inɛ kumɑ́, dekĩ ŋɑ ɑ̀ wɑɑ ɡbɔ ide, iku ŋɑ ɑ̀ jĩ, nɔ ɑ wɑɑ sisiɑ ilu ɑre ŋɑ lɑɑbɑɑu jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ilu inɔ didɔ̃i inɛ iyi kɑɑ nyiò ɑnyi si nɑɑnɛ ku dɑsiɛ nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Iyi mɔcɔi Zɑ̃ɑ ŋɑu ɑ̀ ɡbɔ bɛi Jesu í fɔ, ŋɔi ɑ̀ sindɑ ɑ̀ nɛ. Wɑɑti iyi ɑ̀ wɑɑ nɛ, ŋɔi Jesu í lɔsi ku sisiɑ zɑmɑɑu idei Zɑ̃ɑ í ni, mii ì bɔ ku cɔ si ɡbɑbuɑu ŋɑ. Fɔfɔ iyi fufu wɑ yɑyɑ? Aɑwo. ");
INSERT INTO mkl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","To, mii ì bɔ ku cɔ ŋɑ. Mɑ̀ mɔkɔ iyi wɑ dɑsi ibɔ ku sĩɑu. Aɑwo, inɛ ŋɑ iyi ɑ̀ wɑɑ dɑsi ibɔi fiɑ nkpɔ, ɑŋɑi ɑ̀ yɑ wɑ kɑbɑi ilɑɑlu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","To, mii ì bɔ ku cɔ ŋɑ. Mɑ̀ wɑliii ì bɔ ku cɔ ŋɑ. Oo, ntɔ ntɔ ɑn sɔ̃ ŋɛ, inɛɛu bɛ í re bɑɑ wɑlii. ");
INSERT INTO mkl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Zɑ̃ɑi kukɔi idei Ilɑɑɔ̃ wɑ fɑ̃ɑ tenɡi bii í ni, Ilɑɑɔ̃ í ni, wee ǹ bɛ woo sisi idem wɑ si wɑjuɛ iyi ɑ́ teeseɛ kpɑ̃ɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ntɔ ntɔ ɑn sɔ̃ ŋɛ, si inɔi inɛ ŋɑ iyi inɑɑbo ŋɑ ɑ̀ bí fei, kɑ̃mɑ nŋɑ kù wɛɛ iyi í re Zɑ̃ɑ woo dɑsi inyi. Ammɑ do nŋu fei, bɑɑ inɛ iyi í kere í re si bommɑi Ilɑɑɔ̃ í roo. ");
INSERT INTO mkl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Hɑi wɑɑti iyi Zɑ̃ɑ í sinti ku wɑɑzo hee do nsɛi fei bommɑi Ilɑɑɔ̃ wɑ bɔ wɑjui do ɡbuɡbɑ̃, nɔ ilu ɡbuɡbɑ̃ ŋɑi ɑ̀ yɑ bɑɑ . ");
INSERT INTO mkl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moizi í fɔ idei bommɑu si woodɑɛ. Nɔ wɑlii ŋɑu mɔ, ɑŋɑ fei ɑ̀ fɔ ideɛ hee í koo í to wɑ si wɑɑtii Zɑ̃ɑ woo dɑsi inyiu. ");
INSERT INTO mkl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ì ɡbɔ ŋɑ iyi ɑ̀ ni Elii ɑ́ nɑ ku nɑɑ. Bii ì jɛsi i ɡbɔ idem ŋɑ, Zɑ̃ɑi í jɛ Eliiu. ");
INSERT INTO mkl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Inɛ iyi í nɛ itĩ iyi ɑ́ ɡbɔò ide, ku ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yooi ɑn wɑ̃ò inɛi nsɛi ŋɑu ihɛ̃. À yɛi bɛi ɑmu ŋɑ iyi ɑ̀ wɑɑ bubɑ bɑntumɑ ɑ̀ sɔ̃ njɛ ɑ̀ wɑɑ ni, ");
INSERT INTO mkl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ɑ̀ fɑ̃ nŋɛ yee nɔ i kù jojo ŋɑ, nɔ ɑ̀ kɔ̃ nŋɛ irii iku ŋɑ nɔ i kù kpɑtɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ǹ ni bɛɛbɛi si nɑ iyi í jɔ̀ wɑɑti iyi Zɑ̃ɑ woo dɑsi inyiu í nɑɑ í yɑ dĩ ɑnu nɔ ci yɑ mɔ vɛ̃ɛ, nɔ ɑ̀ ni í nɛ inɛi inɔɔkoi. ");
INSERT INTO mkl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nɔ iyi ɑmu Amɑi Amɑnɛ ǹ nɑɑ, ǹ yɑ n jɛ nɔ n mɑɑ n mɔ, nɔ inɛ ŋɑ ɑ̀ ni ǹ bi ijɛ nɔ ǹ jɛ woo mɔ ɑtɛ̃, nɔ ǹ jɛ kpɑɑsii woo ɡbɑ fiɑi lɛmpoo ŋɑ do ilu dulum ŋɑ. Do nŋu fei, ɑ̀ yɛ iyi bisii Ilɑɑɔ̃ í jɛ dee dee nɑ icɛ ŋɑ iyi wɑ ce. ");
INSERT INTO mkl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nɔ Jesu í lɔsi ku ɡbɑɡbɑ si inɛi ilu ŋɑ bii í ce mɑɑmɑɑke nkpɔ nkpɔ ŋɑu si nɑ iyi í jɔ̀ ɑ kù kpɑɑsi idɔ. ");
INSERT INTO mkl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Í ni, inɔ kufɔ nlɑ nlɑi ɑ́ jɛ tu ŋɛ, iŋɛ inɛi Kɔrɑzɛ̃ɛ ŋɑ. Iŋɛ mɔ inɛi Bɛsɑidɑ ŋɑ, inɔ kufɔ nlɑ nlɑi ɑ́ jɛ tu ŋɛ. Mɑɑmɑɑke ŋɑ iyi ɑ̀ ce si ilu nŋɛ ŋɑu ihɛ̃, bii í jɛ Tii do Sidɔ̃ɔi . ɑ̀ coo wo, inɛi ilu ŋɑu ɑɑ dĩ sɑɑki ɑ kpɑtɑò nɑ irii dulum du ŋɑ nɔ ɑ kpɑɑsi idɔ hɑi ku kpɛ. ");
INSERT INTO mkl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nɑ ŋɔi í jɔ̀ ǹ wɑ n sɔ̃ ŋɛ iyi si ɑjɔi kiitiu ijuukpɑ̃i inɛi Tii do Sidɔ̃ɔ ŋɑ ɑ́ tiɑ tu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Iŋɛ mɔ, inɛi Kɑpɛrɑnumu ŋɑ, ì wɑɑ tɑmɑɑ ŋɑ ɑɑ so ŋɛ hee lelei? Aɑwo, ɑɑ kɛkɛ ŋɛi hee bi ku wɑi iku ŋɑ. Ntɔ ntɔ, mɑɑmɑɑke nkpɔ nkpɔ iyi ǹ ce si ilu nŋɛ, bii í jɛ Sodomui ǹ coo wo, iluu ɑ́ wɛɛ bɑɑ nnyi. ");
INSERT INTO mkl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nɑ ŋɔi í jɔ̀ ǹ wɑ n sɔ̃ ŋɛ iyi si ɑjɔi kiitiu ijuukpɑ̃i inɛi Sodomu ŋɑ ɑ́ tiɑ tu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wɑɑti bɛɛbɛ ŋɔi Jesu í ni, Bɑɑbɑ, ɑwɔ iyi ì jɛ Lɑfɛ̃ɛi lele do ilɛ, ǹ wɑ n sɑɑbuɛ do iyi ì sinɡɑɑ ilu bisi do woo mɑ̀ ŋɑ mii ŋɑu ihɛ̃ nɔ ì nyisi ɑmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Í sĩɑ Bɑɑbɑ, si nɑ iyi í jɔ̀ bɛɛbɛi ì bi. ");
INSERT INTO mkl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nɔ í sɔ̃ inɛ ŋɑ í ni, Bɑɑm nii í dɑɑm mii fei si ɑwɔ. Inɛ kɑ̃mɑ kù mɑ̀ ɑmu Amɑu bii kù jɛ Bɑɑu. Nɔ inɛ kɑ̃mɑ kù mɑ̀ Bɑɑu bii kù jɛ ɑmu Amɑu do inɛ ŋɑ iyi ǹ bi n nyisi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Iŋɛ iyi ì ɡbɛɛji nɔ ɑso wɑ wɔ ŋɛ fei i nɑɑ wɑ bi tom ɑn mu nŋɛ kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","I jɛsi n lesi ŋɛ zuuɡum nɔ i ɡbɑ idei ciom ŋɑ, si nɑ iyi í jɔ̀ ɑmuu ɑmɑnɛ kurɔ do woo kɑye ɑrɑi. Bii ì wɑɑ ce bɛɛbɛ ŋɑ, ɑɑ bɑ kusĩmii hunde nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ntɔ ntɔ, zuuɡum nɔu kù ɡɑɑbu nɔ ɑso iyi ɑn kɑ̃ nŋɛ kù wo. ");
INSERT INTO mkl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Si ɑnyii ɑjɔ minji, ɑjɔi kusĩmi ɡɔ, Jesu do mɔcɔɛ ŋɑ ɑ̀ wɑɑ too kɔɔi ilɛ ɡɔ. Nɔ wee ɑri wɑ kpɑ mɔcɔɛ ŋɑu ŋɔi ɑ̀ wɔ ɑmɑɑjɛ iyi ɑ̀ ɡbɛ̃ si ilɛu ɑ̀ nunu ijuɛ si ɑwɔ ɑ̀ wɑɑ ŋɔ. ");
INSERT INTO mkl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Wee Fɑrisi ɡɔ ŋɑ ɑ̀ wɑ bɛ. Iyi ɑ̀ yɔɔ ŋɔi ɑ̀ sɔ̃ Jesu ɑ̀ ni, cɔ, mɔcɔɛ ŋɑ ɑ̀ wɑɑ ce mii iyi ɑ kù nɛ kpɑ̃ɑi ku ce si ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ammɑ Jesu í jɛ nŋɑ í ni, i kù cio mii iyi Dɑvidi í ce si wɑɑti iyi ɑri wɑ kpɑ nŋu do inɛɛ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Í lɔ kpɑsɛ̃i Ilɑɑɔ̃ nɔ í so pɛ̃ɛ iyi ɑ̀ jilɛɑ Ilɑɑɔ̃ í jɛ, nŋu do inɛɛ ŋɑ. Nɔ wee ɑ kù nɛ kpɑ̃ɑi pɛ̃ɛu ku jɛ, í ɡbe woo weei Ilɑɑɔ̃ ŋɑ ɑŋɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mɑ̀ i kù cioɛ si tiɑi woodɑi Moizi ŋɑ iyi si ɑjɔi kusĩmi woo wee ŋɑ iyi ɑ̀ yɑ nɛ icɛ si kpɑsɛ̃i Ilɑɑɔ̃ ɑ kù wɑɑ jirimɑ ɑjɔi kusĩmi? Do nŋu fei, ɑ kù jɛ ilu tɑɑle ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ammɑ ɑn sɔ̃ ŋɛ iyi inɛ ɡɔ í wɑ ihɛ̃ iyi í nɛ bɛɛrɛ í re kpɑsɛ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kukɔi idei Ilɑɑɔ̃ wɑ fɔ í ni, Ilɑɑɔ̃ í ni, ǹ bi i ce ɑrɑɑrei njɛ ŋɑ ku re i ceem kuwee. Bii í jɛ ì mɑ̀ yɑɑsei ideu bɛ ŋɑ wo i kɑɑ mɑɑ yɛ tɑɑlei hɑi nɛ tɑɑle ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nɔ ɑɑ mɑ̀ ŋɑ iyi ɑmu Amɑi Amɑnɛi ǹ jɛ inɛ nɡboi ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nɔ Jesu í nɛ hɑi bɛ í koo í lɔ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu. ");
INSERT INTO mkl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wee mɔkɔ ɡɔ í wɑ bɛ, ɑwɔ ɑkɑ̃ɛ í ku í ɡbɛ. Nɔ inɛ ŋɑ iyi ɑ̀ wɑ bɛu ɑ̀ bee Jesu ɑ̀ ni, woodɑ í nɑ inɛ kpɑ̃ɑ ku jɔ̀ inɛ ku bɑ iri si ɑjɔi kusĩmi? À wɑɑ fɔ bɛɛbɛi ku bɑ ɑ yɛ tɑɑleɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nɔ Jesu í jɛ nŋɑ í ni, bii inɛ ɡɔ nŋɛ í nɛ ɑnɡudɑ̃ ɑkɑ̃ nɔ í koo í dɑsi inɔ isɑ bɑɑ bii ɑjɔi kusĩmii, lɑfɛ̃ɛ kɑɑ nyɑɑ? ");
INSERT INTO mkl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Amɑnɛ í bɛi í re ɑnɡudɑ̃ hee bii í jĩ. Nɑ nŋu, inɛ í nɛ kpɑ̃ɑ ku ce mii jiidɑ si ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nɔ Jesu í sɔ̃ mɔkɔu í ni, tɛ ɑwɔɛ. Iyi í tɔɔ nɔ í bɑɑ dee dee bɛi ɑwɔ ɑkɑ̃u mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ŋɔi Fɑrisi ŋɑu ɑ̀ fitɑ ɑ̀ koo ɑ̀ wɑɑ busi njɛ bɛi ɑɑ ce ɑ kpɑò Jesu. ");
INSERT INTO mkl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ammɑ Jesu í mɑ̀ si ŋɑ nɔ í nɛ hɑi bɛ. Wɑɑti iyi Jesu wɑ nɛ, zɑmɑɑ nlɑ nlɑ ɡɔ í tooɛ. Nɔ í jɔ̀ inɛ ŋɑ iyi ɑ̀ jɛ bɔ̃ɔ ŋɑ fei ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ammɑ í sɔ̃ ŋɑ í kɔnkɔn du ŋɑ í ni ɑ mɑɑ̀ sɔ̃ inɛ ɡɔ inɛ iyi nŋu í jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Í jɔ̀ ɑ̀ bɑ iri ku bɑ ide iyi wɑlii Ezɑi í fɔu ku kɔ̃, iyi í ni, ");
INSERT INTO mkl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ilɑɑɔ̃ í ni, Woo ce icɛm iyi ǹ cicɑ wee. Nŋui ǹ bi jiidɑ, siɛi inɔ didɔ̃m fei í yɑ wɑ. An dɑɑ si Hundem, Nɔ ku sisiɑ dimi fei dee dee ku jɛm. ");
INSERT INTO mkl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kɑɑ ce kɑkɔɔ do inɛ ɡɔ hee ku lɑ siɛ. Bɛɛbɛ mɔi kɑɑ kosi inɛ ŋɑ ijɑ si inɔ ilu pɑi. ");
INSERT INTO mkl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kɑɑ tɑmbɔ ɑmɑ jĩi iyi í kɔmbɑ wɑ bi ku cɛ, Nɔ kɑɑ kpɑ fitilɑ iyi inyɑ kumɑ́ɛ kù lɑ , Hee wɑɑti koo to si bii ɑ́ jɔ̀ dee dee ku jɛm ku kɑ̃miɑ inɛ fei, ");
INSERT INTO mkl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","nɔ kpɑ̃ɑ ku cɔi dimi fei kú wɑ siɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Si ɑnyii nŋu, ɑ̀ nɑɑ Jesu mɔkɔ ɡɔ wɑ iyi inɛi inɔɔko í jɔ̀ í fɛɛju nɔ í dekĩ. Nɔ Jesu í fɑɑbɑ inɛɛu, í jɔ̀ wɑ yɛ ilu nɔ wɑ fɔ ide. ");
INSERT INTO mkl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nɔ zɑmɑɑu fei í biti ɑ̀ wɑɑ ni, debɛi, ɑ́ jɛ tɔkui Dɑvidiu mbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ammɑ iyi Fɑrisi ŋɑu ɑ̀ ɡbɔ ideu, ŋɔi ɑ̀ ni, mɔkɔu ihɛ̃ wɑ lele inɛi inɔɔko ŋɑi do ɡbuɡbɑ̃i Bɛɛlizebuu . ilɑɑlu nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Si bɛi Jesu í mɑ̀ lɑsɑbu nŋɑ, ŋɔi í sɔ̃ ŋɑ í ni, bommɑ iyi inɛɛ ŋɑ ɑ̀ wɑɑ jɑ ɑŋɑ duusɔ̃ɔ ɑ́ nɑ ku ɡbe nɡbɛ. Bɛɛbɛ mɔi ilu wɑlɑkɔ kpɑsɛ̃ ɡɔ iyi inɛɛ ŋɑ ɑ̀ wɑɑ jɑ ɑŋɑ duusɔ̃ɔ kɑɑ nɑ ku kpɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nɑ nŋu, bii Seetɑm wɑ lele ɑrɑɛ, wɑ ce iɡũ do ɑrɑɛi, bommɑɛ kɑɑ kpɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bii í jɛ do ɡbuɡbɑ̃i Bɛɛlizebuui ǹ wɑ n leleò inɛi inɔɔko ŋɑ, to, do ɡbuɡbɑ̃i yooi mɔcɔ nŋɛ ŋɑ mɔ ɑ̀ wɑɑ leleò ŋɑ. Debɛi ɑŋɑ tɑkɑ nŋɑ ɑɑ yɛ tɑɑle nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ammɑ bii do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃i ǹ wɑ n leleò inɛi inɔɔko ŋɑu, nŋu bɛ wɑ nyisi iyi Ilɑɑɔ̃ í sinti ku jɛ bommɑɛ si ɑnini nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bɛirei inɛ ɑ́ ce ku lɔ kpɑsɛ̃i inɛ iyi í nɛ ɡbuɡbɑ̃ ku coo ile bii kù jɛ í tɑko í dĩ ilu ɡbuɡbɑ̃u. Ammɑ bii í dũu ɑ́ yɔkɔ ku coo ile. ");
INSERT INTO mkl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Inɛ iyi kù jɛ tom, mbɛɛm nii. Inɛ iyi kù wɑɑ bɑm ku tɔtɔɔ, wɑ fɑnɡɑɑɛi. ");
INSERT INTO mkl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nɑ ŋɔi í ce ǹ wɑ n sɔ̃ ŋɛ, Ilɑɑɔ̃ ɑ́ yɔkɔ ku kpɑ idei dulum do ɑrɑbu fei. Ammɑ inɛ iyi wɑ bu Hundei Ilɑɑɔ̃, kɑɑ bɑ ɑ kpɑ idei dulum dɛɛ pɑi. ");
INSERT INTO mkl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bii ɑmɑnɛ wɑ fɔ lɑɑlɔi Amɑi Amɑnɛ Ilɑɑɔ̃ ɑ́ yɔkɔ ku kpɑ idei dulum dɛɛ. Ammɑ inɛ iyi wɑ fɔ tɑɑlei Hundei Ilɑɑɔ̃ kɑɑ bɑ ɑ kpɑ idei dulum ndɛɛ hɑi nnyi hee do ɑlɑ fei. ");
INSERT INTO mkl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesu í sɔ̃ ŋɑ mɑ́ í ni, ɑ̀ yɑ mɑ̀ jĩii hɑi si isoɛ. Jĩi jiidɑ iso jiidɑi í yɑ so, ɑmmɑ jĩi lɑɑlɔ, iso lɑɑlɔi í yɑ so. ");
INSERT INTO mkl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Iŋɛ inɛ buu ŋɑi bɛi njo wukuku. Iŋɛ inɛ lɑɑlɔ ŋɑ, bɛirei ɑɑ ce i fɔ ide jiidɑ ŋɑ. Mii iyi wɑ kɔ̃ si idɔɛ nŋui ɡɛlɛɛ í yɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Inɛ jiidɑ ide jiidɑi í yɑ fɔ. Nɔ ide jiidɑu í yɑ nɑɑi hɑi si ide jiidɑ iyi wɑ sinɡɑ si idɔɛ. Bɛɛbɛ mɔi inɛ lɑɑlɔ ide lɑɑlɔi í yɑ fɔ. Nɔ ide lɑɑlɔu mɔ í yɑ nɑɑi hɑi si ide lɑɑlɔ iyi wɑ sinɡɑ si idɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","An sɔ̃ ŋɛ, ide nfe iyi inɛ ŋɑ ɑ̀ wɑɑ fɔ fei, Ilɑɑɔ̃ ɑ́ nɑ ku bee ŋɑ si ɑjɔi kiitiu, ");
INSERT INTO mkl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","domi hɑi si ideɛi Ilɑɑɔ̃ ɑ́ kiitiɛ, nɔ ku kpeɛ hɑi nɛ tɑɑle wɑlɑkɔ ilu tɑɑle. ");
INSERT INTO mkl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ŋɔi woo kɔ inɛ ŋɑ si woodɑ do Fɑrisi ɡɔ ŋɑ ɑ̀ sɔ̃ Jesu ɑ̀ ni, Mɛɛtu, ɑ̀ bi i ce mɑɑmɑɑke ɡɔ iyi ɑ́ nyisi wɑ iyi Ilɑɑɔ̃i í bɛɛ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ammɑ Jesu í jɛ nŋɑ í ni, inɛ lɑɑlɔi nsɛi ŋɑ iyi ɑ kù wɑɑ leekĩ do Ilɑɑɔ̃ nŋu ɑkɑ̃, mɑɑmɑɑkei ɑ̀ yɑ mɑɑ bi, ɑmmɑ mɑɑmɑɑke ɡɔ kù wɛɛ iyi ɑɑ nyisi ŋɑ mɑ́ bii kù jɛ ti wɑlii Zonɑsi, ");
INSERT INTO mkl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","domi si bɛi Zonɑsi í ce dɑsɑ̃ mɛɛtɑ do idũ mɛɛtɑ si inɔi cɛ̃ɛ nlɑu, bɛɛbɛ mɔi Amɑi Amɑnɛ ɑ́ ce dɑsɑ̃ mɛɛtɑ do idũ mɛɛtɑ si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Si ɑjɔi kiitiu, inɛi Ninivu ŋɑ ɑɑ dede si inɛi nnyi ŋɑ ɑ yɛ tɑɑle nŋɑ, si nɑ iyi í jɔ̀ ɑ̀ kpɑɑsi idɔ nŋɑ nɑ wɑɑzoi Zonɑsi. Wee nsɛi inɛ iyi wɑ sɔ̃ ŋɛ ideu ihɛ̃ í re Zonɑsi. ");
INSERT INTO mkl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Si ɑjɔi kiitiu, ilɑɑlu inɑɑbo iyi í nɑɑ hɑi ɑwɔ cɑnɡɑi kpɑ̃ɑi inunu ɑ́ dede si inɛi nnyi ŋɑ ku yɛ tɑɑle nŋɑ, si nɑ iyi í jɔ̀ hɑi jĩijĩi í dede í nɑɑ ku ɡbɔ idei bisii Sɑlomɔɔ, ilɑɑlu nlɑu. Nɔ wee nsɛi inɛ iyi wɑ sɔ̃ ŋɛ ideu ihɛ̃ í re Sɑlomɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ŋɔi Jesu í kpɑ nŋɑ mɔndɑu ihɛ̃ í ni, bii inɛi inɔɔko í fitɑ si inɛ, í yɑ mɑɑ dɑbii si ɡbɑɑ ŋɑi ku mɑɑ dɛ bi ku sĩmi. Bii í kuɑ, ");
INSERT INTO mkl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ŋɔi í yɑ ni, ɑn nyi inyɑ nwom hɑi bii ǹ fitɑ wɑi. Wɑɑti iyi í nyi wɑ nɔ í bɑ inɛɛu í yɛ bɛi ile nɡbɛ iyi ɑ̀ kpɑ̃ ɑ̀ teeseɛ sɑ̃ɑ sɑ̃ɑ, ");
INSERT INTO mkl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ɑ́ koo ku dɛdɛ kpɑɑsi lɑɑlɔ ŋɑ iyi ɑ̀ roo wɑ mɑ́ bɛi ɑŋɑ mɛɛje, ɑ nɑ ɑ lɔ si inɛɛu ɑ mɑɑ wɑ bɛ. Wɑɑti bɛɛbɛ kuwɛɛi tɑkoi inɛɛu ɑ́ tiɑ bɑɑ ti ɑnkɑ̃ɑnyiɛ mɑ́. Mii iyi ɑ́ bɑ inɛ lɑɑlɔi nsɛi ŋɑ mbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Wɑɑti iyi Jesu wɑ bɑ zɑmɑɑu ide ku fɔ, ŋɔi iyeɛ do ifɔɛ ŋɑ ɑ̀ nɑɑ ɑ̀ leekĩ wɑduude, ɑ̀ wɑɑ bi ɑ bɑɑ ide ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nɔ inɛ ɡɔ í nɑɑ í sɔ̃ Jesu í ni, iyeɛ do ifɔɛ ŋɑ wee, ɑ̀ wɑ wɑduude ɑ̀ wɑɑ bi ɑ bɑɛ ide ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ammɑ Jesu í jɛɑ inɛɛu í ni, yooi í jɛ iyem, nɔ yoo ŋɑi ɑ̀ jɛ ifɔm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nɔ í tosi mɔcɔɛ ŋɑu ɑwɔ í ni, iŋɛi ì jɛ iyem do ifɔm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ntɔ ntɔ inɛ iyi wɑ ce idɔɔbii Bɑɑm iyi í wɑ lele, lɑfɛ̃ɛi í jɛ ifɔm wɑlɑ wecĩm wɑlɑ iyem. ");
INSERT INTO mkl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Si ɑjɔ ɑkɑ̃u bɛ mɑ́, Jesu í fitɑ hɑi kpɑsɛ̃ í koo í bubɑ itĩi tenku. ");
INSERT INTO mkl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nɔ zɑmɑɑ nlɑ nlɑ ɡɔ í tɔtɔɔ siɛ. Ŋɔi í lɔ ɑkɔi inyi ɡɔ í bubɑ ku bɑ ku kɔ ŋɑ si cio. Nɔ zɑmɑɑu fei wɑ leekĩ itĩ tenkuu bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nɔ í sɔ̃ ŋɑ mii nkpɔ do mɔndɑ. Í ni, mɔkɔ ɡɔ í fitɑ wɑ fɑ̃ dimi. ");
INSERT INTO mkl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Si bɛi wɑ fɑ̃ dimiu, ŋɔi ɡɔɡɔ ŋɑ ɑ̀ cuku si kpɑ̃ɑ nɔ yɛi ŋɑ ɑ̀ nɑɑ ɑ̀ jɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nɔ ɡɔɡɔ ŋɑ mɔ ɑ̀ cuku si ilɛ iyi í nɛ kutɑ, tenɡi bii sɑ̃ɑ kù kpɔ. Nɔ í fitɑ bɛ ɡbɑkɑ̃ si nɑ iyi í jɔ̀ sɑ̃ɑ kù lɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ammɑ iyi inunu wɑ ce, ŋɔi í joo nɔ í ɡbɛ, domi icɑ̃ɛ kù mi lɛlɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gɔɡɔ ŋɑ mɔ ɑ̀ cuku si inɔ ɑɡũ ŋɑ. Ŋɔi ɑɡũ ŋɑu ɑ̀ dede siɛ ɑ̀ biiɛ ɑ̀ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nɔ ɡɔɡɔ ŋɑ mɔ ɑ̀ cuku si ilɛ jiidɑ nɔ ɑ̀ bí. Gɔɡɔ ŋɑ ɑ̀ nɛ iju cĩɔ, ɡɔɡɔ ŋɑ mɔ kitɑ, ɡɔɡɔ ŋɑ mɔ kuntɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Iyi Jesu í kpɑ mɔndɑu í tɑ̃ ŋɔi í ni, inɛ iyi í nɛ itĩ iyi ɑ́ ɡbɔò ide, ku ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ŋɔi mɔcɔɛ ŋɑ ɑ̀ nɑɑ ɑ̀ beeɛ ɑ̀ ni, nɑ mii í ce ì yɑ mɑɑ sɔ̃ inɛ ŋɑ ide do mɔndɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nɔ í sɔ̃ ŋɑ í ni, iŋɛi Ilɑɑɔ̃ í jɔ̀ ì mɑ̀ ɑsiii bommɑɛ ŋɑ. Ammɑ kù jɔ̀ inɛ ŋɑ iyi ɑ̀ ɡbe ŋɑu ɑ mɑ̀ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Inɛ iyi í nɛ, nŋui ɑ̀ yɑ kɔ̃ɔɑ si, nɔ kunɛu ku lɑ. Ammɑ inɛ iyi kù nɛ, bɑɑ keeke iyi í nɛu ɑ̀ yɑ ɡbɑɑi mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Inɛ ŋɑu, ɑ̀ yɑ mɑɑ cɔ ilu ɑmmɑ ɑ kù wɑɑ yɛ, nɔ ɑ̀ wɑɑ sɔ̃ ŋɑ ide ɑmmɑ ɑ kù wɑɑ ɡbɔ yɑɑseɛ. Nɑ ŋɔi i jɔ̀ ǹ yɑ n mɑɑ n sɔ̃ ŋɑ ide do mɔndɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mii iyi í bɑ ŋɑu bɛ Ezɑi í tɑko í ce wɑliiɛ í ni, Aɑ yɑ desi ide itĩ ɑmmɑ ì kɑɑ ɡbɔ yɑɑseɛ ŋɑ, Nɔ ɑɑ mɑɑ cɔ ilu ɑmmɑ ì kɑɑ yɛ nɡɔɡɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Idɔ nŋɑ í bɑɑ í le. À dĩ itĩ nŋɑ ku bɑ ɑ mɑɑ̀ ɡbɔ ide ɡɔ, Nɔ ɑ̀ bii iju nŋɑ ku bɑ ɑ mɑɑ̀ yɛ nɡɔɡɔ, Nɔ idɔ nŋɑ mɔ ku mɑɑ̀ mɑ̀ nɡɔɡɔ. Bii kù jɛ bɛɛbɛ ɑɑ nɑɑ ɑ sindɑ wɑ bi Ilɑɑɔ̃ nɔ ku jɔ̀ ɑ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ammɑ Jesu í sɔ̃ mɔcɔɛ ŋɑu í ni, iŋɛ ilu inɔ didɔ̃ ŋɑi, si nɑ iyi í jɔ̀ iju nŋɛ wɑ yɛ ilu, nɔ itĩ nŋɛ wɑ ɡbɔ ide mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, wɑlii do inɛ nkpɔ iyi wɑ jirimɑ idei Ilɑɑɔ̃, ɑ̀ bi ɑŋɑ ɑ̀ yɛ mii iyi ì wɑɑ yɛu ihɛ̃ ŋɑ, ɑmmɑ ɑ kù yɔɔ. Nɔ ɑ̀ bi ɑŋɑ ɑ ɡbɔ mii iyi ì wɑɑ ɡbɔu ihɛ̃ ŋɑ, ɑ kù nɔ ɑ kù ɡbɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesu í sɔ̃ ŋɑ mɑ́ í ni, i de itĩ i ɡbɔ yɑɑsei mɔndɑi woo ɡbɛ̃u ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Inɛ iyi wɑ ɡbɔ idei bommɑi Ilɑɑɔ̃ nɔ kù ɡbɔ yɑɑseɛ, í yɛi bɛi kpɑ̃ɑ bii dimiu í cuku. Seetɑm inɛ lɑɑlɔui, i yɑ nɑɑ ku nyɑ ide iyi ɑ̀ ɡbɛ̃ si idɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Inɛ mɔ iyi í yɛ bɛi ilɛ kutɑ bii dimiu í cukuu, bii wɑ ɡbɔ ideu ɡbɑkɑ̃ í yɑ ɡbɑɑi do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ammɑ ci yɑ jɔ̀ ideu ku ce icɑ̃ jiidɑ si idɔɛ, nɔ kɑɑ yɔkɔ ku leekĩ ku kpɛ. Bii wɑhɑlɑ ɡɔ í dede, wɑlɑkɔ ijuukpɑ̃ ɡɔ nɑ irii ideu, í yɑ fũsi ɑwɔi ɡbɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Inɛ mɔ iyi í ɡbɑ ideu bɛi si ilɛ ku nɛ ɑɡũ ŋɑu, wɑ ɡbɔ ideu ɑmmɑ lɑsɑbu bututui mii ŋɑ iyi wɑ bitɑndiɛ do fiɑ ku bi iyi wɑ dĩ ijuɛ, ɑŋɑi ɑ̀ wɑɑ ɡɑnji ideu ku ce icɛ si inɛɛu. ");
INSERT INTO mkl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Inɛ mɔ iyi í ɡbɑ ideu bɛi si ilɛ jiidɑ, nŋui í jɛ inɛ iyi wɑ ɡbɔ ideu nɔ í ɡbɔɔ do yɑɑseɛ, nɔ í so iso. Bi inɛ ɡɔ ŋɑ, dimiu í so iso cĩɔ, inɛ ɡɔ ŋɑ kitɑ, inɛ ɡɔ ŋɑ mɔ kuntɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nɔ Jesu í kpɑ nŋɑ mɔndɑ mɑ́ í ni, fɑɑji iyi wɑ fɔ idei bommɑi Ilɑɑɔ̃ wee. Mɔkɔ ɡɔi í koo í ɡbɛ̃ dimi jiidɑ si ilɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ammɑ idũ si wɑɑti iyi inɛ fei wɑ sĩ njoo, ŋɔi mbɛɛi mɔkɔu í nɑɑ í ɡbɛ̃ɑ fɔfɔ lɑɑlɔ si inɔ ilɛɛ nɔ í nɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nɔ dimi jiidɑu í fitɑ, wɑ lɑ, nɔ í bí. Fɔfɔ lɑɑlɔu mɔ í fitɑ, nɔ ɑŋɑ fei ɑ̀ lɑ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ŋɔi ɑmɑɑcɛɛ ŋɑu ɑ̀ nɑɑ ɑ̀ sɔ̃ɔ ɑ̀ ni, lɑfɛ̃ɛ, í jɔ dimi jiidɑi ì ɡbɛ̃ si ilɛɛ yɑ. To, nɔ hɑi iwoi fɔfɔ lɑɑlɔu ihɛ̃ í fitɑ wɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ŋɔi í sɔ̃ ŋɑ í ni, mbɛɛ ɡɔi í coo. Nɔ ɑmɑɑcɛɛ ŋɑu ɑ̀ beeɛ ɑ̀ ni, ì bi kɑɑ loɡoo fɔfɔ lɑɑlɔu? ");
INSERT INTO mkl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nɔ í ni, ɑɑwo. Bii ì wɑɑ bi i loɡoo fɔfɔ lɑɑlɔu bii i kù lɑɑkɑi ŋɑ ɑɑ nɑ i tɔtɔɔ i loɡooò dimi jiidɑu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","I jɔ̀ ɑŋɑ fei ɑ dede nŋɑ hee bii kumuɛ í to. Wɑɑti bɛɛbɛ ɑn sɔ̃ woo mu ŋɑu ɑ kpɑ fɔfɔ lɑɑlɔu titɑ̃ ɑ dũu ɑ dɑsi inɑ, ɑ bɛi ɑ tɔtɔɔ dimi jiidɑu ɑ dɑsi suum. ");
INSERT INTO mkl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nɔ Jesu í kpɑ nŋɑ mɔndɑ ɡɔ mɑ́ í ni, bommɑi Ilɑɑɔ̃ í yɛi bɛi nɡboi mutɑɑdi iyi inɛ ɡɔ í so í ɡbɛ̃ si ilɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nɡbou í kere í re nɡbo ŋɑ iyi ɑ̀ ɡbe fei, ɑmmɑ bii ɑ̀ ɡbɔ̃ɔ, nŋui í yɑ fitɑ ku lɑ́ ku re ɑmɑ jĩi fei, hee yɛi ŋɑ ɑ̀ yɑ mɑɑ ce ɑntɛ si ɑmɑɑwɔɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nɔ Jesu í kpɑ nŋɑ mɔndɑ ɡɔ mɑ́ í ni, bommɑi Ilɑɑɔ̃ í yɛi bɛi lefee iyi ɑbo ɡɔ í so í dɑsi iyɑfũi pɛ̃ɛ ɡũɑ mɛɛtɑ, nɔ fei í dede í kpɑnte. ");
INSERT INTO mkl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ide ŋɑu bɛ fei sɑ̃ɑ sɑ̃ɑ do mɔndɑi Jesu í sɔ̃ zɑmɑɑu, ci yɑ fɔ ide iyi kù jɛ do mɔndɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bɛɛbɛi idei inɛ ɑkɑ̃i wɑlii ŋɑu í ce iyi í ni, Ilɑɑɔ̃ í ni, Do mɔndɑi ɑn yɑ n sɔ̃ ŋɑ ide, Nɔ si bɑntumɑi ɑn fɔ mii iyi wɑ mɑnji hɑi wɑɑti iyi ǹ tɑkɑ ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesu í jɔ̀ zɑmɑɑu nɔ í koo í lɔ kpɑsɛ̃. Nɔ mɔcɔɛ ŋɑu ɑ̀ bɔ bi tɛɛ ɑ̀ ni, sisi nwɑ yɑɑsei mɔndɑi fɔfɔ lɑɑlɔu. ");
INSERT INTO mkl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nɔ í jɛ nŋɑ í ni, inɛ iyi í ɡbɛ̃ dimi jiidɑu ɑmu Amɑi Amɑnɛi. ");
INSERT INTO mkl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ilɛui í jɛ ɑndunyɑ. Dimi jiidɑu mɔ, nŋui í jɛ inɛi bommɑi Ilɑɑɔ̃ ŋɑ. Fɔfɔ lɑɑlɔu nŋui í jɛ inɛi Seetɑm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mbɛɛ iyi í ɡbɔ̃ɔ nŋui í jɛ Seetɑm. Ajɔi kumuu mɔi í jɛ ɑjɔ iyi ɑndunyɑ ɑ́ kpɑ iri, nɔ woo mu ŋɑu mɔ ɑŋɑi ɑ̀ jɛ ɑmɑlekɑ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nɔ si bɛi ɑ̀ yɑ kpɑ fɔfɔ lɑɑlɔu ɑ dɑsi inɑu, bɛɛbɛ mɔi ɑ́ jɛ si ɑjɔ iyi ɑndunyɑ ɑ́ kpɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Amu Amɑi Amɑnɛ, ɑn bɛ ɑmɑlekɑm ŋɑ wɑ ɑ nɑ ɑ nyɑ inɛ ŋɑ iyi ɑ̀ wɑɑ dɑsi inɛ ŋɑ kurɑrɑ do woo ce lɑɑlɔ ŋɑu ɑ tekĩò ŋɑ hɑi tenɡi bii ɑn nɑ n jɛ bommɑm, ");
INSERT INTO mkl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","nɔ ɑ dɑsi ŋɑ inɑ iyi ci yɑ ku. Tenɡi bɛi ɑɑ lesi ɑwɔ si iri ɑ kpɑtɑò. ");
INSERT INTO mkl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nɔ wɑɑti bɛɛbɛ inɛ ŋɑ iyi ɑ̀ wɑɑ dɛ idɔɔbii Ilɑɑɔ̃ ku ce ɑɑ mɑɑ mɑ́ inyɑi bɛi inunu si bommɑi Ilɑɑɔ̃ Bɑɑ nŋɑ. Inɛ iyi í nɛ itĩ iyi ɑ́ ɡbɔò ide, ku ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nɔ Jesu í ni mɑ́, mɔndɑ ɡɔ iyi wɑ fɔ idei bommɑi Ilɑɑɔ̃ wee. Ajɔ nŋu ɡɔ inɛ ɡɔ í koo í kɑ̃si ɑmɑni iyi wɑ sinɡɑ si inɔ ilɛ. Iyi í yɔɔ nɔ í teese í sinɡɑɛ mɑ. Nɔ í nɛ do inɔ didɔ̃ í koo í tɑ mii iyi í nɛ fei, nɔ í nɑɑ í rɑ ikou. ");
INSERT INTO mkl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesu í ni, bommɑi Ilɑɑɔ̃ í yɛi mɑ́ bɛi lɛɡɛ jiidɑ ŋɑ iyi woo nyɑ sĩɑ ɡɔ wɑ dɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iyi í yɛ ɑkɑ̃ iyi í jɛ jiidɑ ti fiɑ nkpɔ ɡɔ, nɔ í koo í tɑ mii iyi í nɛ fei í nɑɑ í rɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesu í ni mɑ́, bommɑi Ilɑɑɔ̃ í yɛi mɑ́ bɛi tɑɑo iyi ɑ̀ sɔsi inɔ inyi ku mu cɛ̃ɛ dimi ikɑ̃ ikɑ̃ fei. ");
INSERT INTO mkl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bii í mu cɛ̃ɛ ŋɑu í tɑ̃, sɔɔkɔ ŋɑu ɑ̀ yɑ fɑɑ wɑ icei. Nɔ ɑ bubɑ ɑ cicɑ cɛ̃ɛ jiidɑ ŋɑu ɑ dɑsi kɔlɔ, cɛ̃ɛ ŋɑ iyi ɑ kù ce ncɛɛu mɔ nɔ ɑ nikɑ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nɔ bɛɛbɛ mɔi ɑ́ yɛ si iri ku kpɑi ɑndunyɑ. Amɑlekɑ ŋɑ ɑɑ nɑ ɑ nyɑ inɛ ŋɑ iyi ɑ̀ wɑɑ ce lɑɑlɔ hɑi si inɔi inɛ ŋɑ iyi ɑ̀ wɑɑ ce idɔɔbii Ilɑɑɔ̃, ");
INSERT INTO mkl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ɑ dɑsi ŋɑ inɑ iyi ci yɑ ku. Bɛi ɑɑ lesi ɑwɔ si iri ɑ kpɑtɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu í bee ŋɑ í ni, ì ɡbɔ yɑɑsei ideu fei ŋɑ? Nɔ ɑ̀ jɛ ɑ̀ ni, oo. ");
INSERT INTO mkl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nɔ í sɔ̃ ŋɑ í ni, bɛɛbɛ mɔi, woo kɔ inɛ ŋɑ si woodɑ bɑɑ yoomɑ fei iyi í bɑɑ í jɛ inɛ iyi í mɑ̀ idei bommɑi Ilɑɑɔ̃, í yɛi bɛi ilu kpɑsɛ̃ ɡɔ iyi wɑ nyɑ mii titɔ̃ ŋɑ do mii nwo ŋɑ hɑi si ɑmɑniɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iyi Jesu í kpɑ nŋɑ mɔndɑ ŋɑu bɛ í tɑ̃, nɔ í nɛ hɑi bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Í bɔ ilu bii í jɛ ɑmɑ. Iyi í to bɛ í lɔsi ku kɔ inɛ ŋɑ si cio ile bii ɑ̀ yɑ mɑɑ ce kutɔtɔɔ hee inɛ ŋɑ iyi ɑ̀ wɑɑ ɡbɔ ideɛ ŋɑu ɑ̀ nɑ ɑ̀ biti. Nɔ ɑ̀ wɑɑ ni, hɑi iwoi inɛɛu ihɛ̃ í bɑ dimii bisiu ihɛ̃ wɑ. Bɛirei í ce wɑ ceò mɑɑmɑɑke ŋɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Í jɔ ɑmɑi woo ɡbe jĩi nɔu mbɛ yɑ. Kù jɛ iyeɛi ɑ̀ yɑ kpe Mɑɑriu? Zɑɑki do Zozɛfu do Simɔɔ do Zudu ŋɑ si ɑ̀ jɛ ifɔɛ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Awɑò wecĩɛ ŋɑ fei si ɑ̀ wɑ ihɛ̃ bɑ. Bii bɛɛbɛi nɔ hɑi iwoi í bɑ ɡbuɡbɑ̃u ihɛ̃ fei wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","To, lɑsɑbu nŋu ŋɑu bɛi í ɡɑnji ŋɑ ɑ dɑsiɛ nɑɑnɛ. Nɔ Jesu í sɔ̃ ŋɑ í ni, kù nɛ bii wɑlii ci yɑ nɛ bɛɛrɛ bii kù jɛ si ilɛi ideɛ do si kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kù nɔ kù ce mɑɑmɑɑke nkpɔ bɛ si nɑ iyi í jɔ̀ ɑ kù dɑsiɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Si wɑɑti bɛɛbɛi Herodu, ilɑɑlui Gɑlileeu í ɡbɔ lɑɑbɑɑui Jesu. ");
INSERT INTO mkl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nɔ í sɔ̃ ɑmɑɑcɛɛ ŋɑ í ni, inɛɛu bɛ Zɑ̃ɑ woo dɑsi inyiui í jĩ wɑ hɑi si bɑlɛ. Nɑ ŋɔi í jɔ̀ í nɛ ɡbuɡbɑ̃ wɑ ceò mɑɑmɑɑke ŋɑu bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mii iyi í jɔ̀ Herodu í fɔ bɛɛbe wee. Herodu í tɑko í so Herodiɑsi ɑboi Filipu, ifɔɛ. Ŋɔi Zɑ̃ɑ í sɔ̃ɔ í ni, kù sĩɑ i ɡbɑ ɑboi ifɔɛ i dɑsi kpɑsɛ̃ɛ. Ide iyi Zɑ̃ɑ í fɔ nɑ irii Herodiɑsiu í jɔ̀ Herodu í ni ɑ muu ɑ dũu ɑ dɑsiɛ piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nɔ Herodu wɑ bi ku kpɑɑ, ɑmmɑ wɑ ce njoi inɛ ŋɑ si nɑ iyi í jɔ̀ ɑŋɑ fei ɑ̀ ni Zɑ̃ɑ wɑliii. ");
INSERT INTO mkl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ŋɔi ɑjɔ í nɑɑ í to bii Herodu wɑ ce jinɡɑu ku yeò ɡiɡii ɑjɔi kubiɛ. Nɔ ɑmɑ inɑɑboi Herodiɑsi wɑ jojo si wɑjui inɛ ŋɑ iyi ɑ̀ kpe ku jɛu. Ŋɔi í dɔ̃ɑ Herodu si jiidɑ jiidɑ ");
INSERT INTO mkl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hee í ceɑɑ kuwɑ̃ nɔ í ɡbɑsi í ni nŋu ɑ́ muɑɑ mii iyi í bi fei. ");
INSERT INTO mkl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ŋɔi ɑmɑ inɑɑbou í koo í bee iyeɛ, nɔ í nyi wɑ í nɑɑ í sɔ̃ɔ í ni, ǹ bi i muum irii Zɑ̃ɑ woo dɑsi inyiu wɑ si pɛrɛnti. ");
INSERT INTO mkl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ŋɔi inɔi ilɑɑluu í fɔ. Do nŋu fei í jɛsi nɔ í ni ɑ koo ɑ bu irii Zɑ̃ɑu wɑ ɑ nɑɑ ɑ nɑ́ɑ. Í jɛsii si nɑ iyi í jɔ̀ í ɡbɑsi tɑ̃ do mii fei si wɑjui inɛ njooɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nɔ í bɛ inɛ ŋɑ ile piisɔ̃ɔ bɛ ɑ koo ɑ bu irii Zɑ̃ɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ŋɔi inɛ ŋɑu ɑ̀ koo ɑ̀ buu nɔ ɑ̀ lesi pɛrɛnti wɑ ɑ̀ nɑɑ ɑ̀ nɑ ɑmɑ inɑɑbou nɔ nŋu mɔ í koo í nɑ iyeɛ. ");
INSERT INTO mkl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ŋɔi mɔcɔi Zɑ̃ɑ ŋɑu ɑ̀ ɡbɔ ideu. Nɔ ɑ̀ nɑɑ ɑ̀ so ikuɛu ɑ̀ koo ɑ̀ suu. Nɔ ɑ̀ koo ɑ̀ sɔ̃ Jesu. ");
INSERT INTO mkl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iyi Jesu í ɡbɔ ideu ŋɔi í nɛ hɑi bɛ. Í lɔ ɑkɔi inyi do mɔcɔɛ ŋɑ nɔ ɑ̀ bɔ ɡbɑbuɑ ɡɔ. Iyi inɛ ŋɑ ɑ̀ ɡbɔ, ŋɔi ɑ̀ fitɑ hɑi inɔ ilu nŋɑ ŋɑ ɑ̀ dɑ hɑ̃mɛɛ nŋɑ wɑ do isɛ. ");
INSERT INTO mkl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iyi ɑ̀ fitɑ hɑi si ɑkɔi inyiu ŋɔi Jesu í yɛ zɑmɑɑu. Nɔ í ce ɑrɑɑre nŋɑ nɔ í jɔ̀ bɔ̃ɔ nŋɑ ŋɑ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Iyi ɑlɛ wɑ lɛ ŋɔi mɔcɔɛ ŋɑu ɑ̀ nɑɑ bi tɛɛ ɑ̀ ni, si ɡbɑbuɑi ɑ̀ wɑ ihɛ̃ nɔ wee idũ wɑ dũ. Nɑ nŋu, jɔ̀ inɛ ŋɑu ɑ nɛ ilɛɛko ŋɑ ɑ koo ɑ rɑ mii iyi ɑɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ammɑ Jesu í sɔ̃ ŋɑ í ni, ɑ kù nɛ bukɑɑtɑi ɑ nɛ. Iŋɛ tɑkɑ nŋɛ, i nɑ ŋɑ ijɛ ɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ŋɔi ɑ̀ ni, pɛ̃ɛ iyi ɑ̀ nɛ ihɛ̃ kù re ɑrɑ miu do cɛ̃ɛ minji. ");
INSERT INTO mkl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nɔ Jesu í ni, i nɑɑm wɑ ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nɔ í ni zɑmɑɑu ku bubɑ si fɔfɔu, nɔ í so pɛ̃ɛ ɑrɑ miu do cɛ̃ɛ minjiu, í wu iju lele í sɑɑbu Ilɑɑɔ̃. Nɔ í bububu pɛ̃ɛ ŋɑu í nɑ mɔcɔɛ ŋɑu nɔ ɑŋɑ mɔ ɑ̀ kpɛ̃ɑ zɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nɔ ɑŋɑ fei ɑ̀ jɛ ɑ̀ yo hee mbɔɛ í ɡbe. Ŋɔi mɔcɔɛ ŋɑu ɑ̀ ko iyi í ɡbeu hee kɔlɔ mɑɑteeji í kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Inɛmɔkɔ ŋɑ iyi ɑ̀ jɛu ɑ̀ wɛɛi zɑkɑi ɑmɑnɛ dubu miu (5.000), bɑɑi inɑɑbo do ɑmu ŋɑ bɑɑsi. ");
INSERT INTO mkl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iyi ɑ̀ tɑ̃ ŋɔi Jesu í ni mɔcɔ ŋɑu ɑ̀ lɔ ɑkɔi inyiu ku bɑ ɑ tɑkoɛ ɑ kuɑ ice ihɔ̃. Iyi ɑ̀ wɑɑ nɛ nɔ í ni zɑmɑɑu ku nɛ. ");
INSERT INTO mkl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wɑɑti iyi í jɔ̀ ɑ̀ nɛ nɔ í koo í ɡũ iri kutɑ ɡɔ ku bɑ ku ce kutɔɔ. Nɔ idũ í dũ í bɑ́ɑ bɛ nŋu ɑkɑ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wee wɑɑti bɛɛbɛ ɑkɔi inyiu í wɑ si ɑninii tenkuu tɑ̃. Nɔ kutɑ̃nɡɑ̃m dii inyiu í wɑsi ku tɑleɛ si nɑ iyi í jɔ̀ fufu wɑ ko ŋɑ ikpó. ");
INSERT INTO mkl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Zɑkɑi ɑmɛɛjumɑ ŋɔi Jesu wɑ nɛ si ɑntɑi inyiu, wɑ bɔ bi mɔcɔɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wɑɑti iyi ɑ̀ yɔɔ wɑ nɛ si ɑntɑi tenkuu wɑ ŋɔi ziɡi nŋɑ í dɑ, njo wɑ mu ŋɑ, ɑ̀ wɑɑ ni, zĩii. Nɔ njou í jɔ̀ ɑ̀ wɑsi ku dɔ̃ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bɛ ɡbɑkɑ̃ Jesu í bɑ ŋɑ ide ku fɔ í sɔ̃ ŋɑ í ni, i sũ lɑɑkɑi nŋɛ ŋɑ. Amui Jesu, i mɑɑ̀ ce njo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ŋɔi Piɛɛ í sɔ̃ɔ í ni, Lɑfɛ̃ɛ, bii ɑwɔi, jɔ̀ ɑmu mɔ n nɛ n nɑɑ bi tɛɛ si ɑntɑi inyiu. ");
INSERT INTO mkl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nɔ Jesu í jɛɑɑ í ni, nɑɑ wɑ. Nɔ Piɛɛ í kitɑ hɑi si ɑkɔi inyiu nɔ í nɛ si ɑntɑi inyiu wɑ bɔ bi Jesu. ");
INSERT INTO mkl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ammɑ iyi lɑɑkɑɛ í bɔ si fufu iyi wɑ ce do ɡbuɡbɑ̃u, ŋɔi njo í muu. Nɔ í sinti ku mile. Ŋɔi í dɔ̃ ɑnu í ni, Lɑfɛ̃ɛ, fɑɑbɑm. ");
INSERT INTO mkl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nɔ ɡbɑkɑ̃ Jesu í yɔ ɑwɔ í muu nɔ í ni, nɑ mii í ce ì wɑɑ sikɑ sikɑ mɑ́. Nɑɑnɛɛ kù lɑ. ");
INSERT INTO mkl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ŋɔi ɑŋɑ minji fei ɑ̀ ɡũ ɑkɔi inyiu nɔ fufuu í leekĩ. ");
INSERT INTO mkl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nɔ inɛ ŋɑ iyi ɑ̀ wɑ si inɔi ɑkɔu ɑ̀ ɡulɛ si wɑjui Jesu ɑ̀ ni, ntɔ ntɔ, ɑwɔu Amɑi Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Iyi ɑ̀ kuɑ, nɔ ɑ̀ to ilɛi Genesɑrɛti. ");
INSERT INTO mkl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Si bɛi inɛi bɛ ŋɑu ɑ̀ mɑ̀ Jesu, ŋɔi ɑ̀ fɔ lɑɑbɑɑuɛ bii fei ɑ̀ ni í to wɑ. Nɔ ɑ̀ nɑɑ bɔ̃ɔ fei wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nɔ ɑ̀ tɔɔɛ ɑ̀ ni ku jɔ̀ ɑŋɑ ɑ lu bɑɑ itĩi kumbooɛ, nɔ inɛ iyi í luu fei í yɑ bɑ irii. ");
INSERT INTO mkl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ŋɔi Fɑrisi ɡɔ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ɡɔ ŋɑ ɑ̀ nɑɑ hɑi Zeruzɑlɛmu ɑ̀ bɔ bi Jesu ɑ̀ beeɛ ɑ̀ ni, ");
INSERT INTO mkl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","nɑ mii í ce mɔcɔɛ ŋɑ ɑ kù wɑɑ too dedembɑi bɑlɑ nwɑ ŋɑ. Nɑ mii í ce ɑ ci yɑ wɔɔ ɑ bɛi ɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nɔ Jesu í jɛ nŋɑ do ide ku bee í ni, nɑ mii í ce iŋɛ mɔ dedembɑ nŋɛ ŋɑ ku too í jɔ̀ i kù wɑɑ jirimɑ woodɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ì mɑ̀ sɑ̃ɑ sɑ̃ɑ ŋɑ iyi Ilɑɑɔ̃ í ni, i ɡbɔɑ iyeò bɑɑ nŋɛ ŋɑ i jirimɑ ŋɑ ŋɑ. Nɔ í ni mɑ́, inɛ iyi wɑ fɔ lɑɑlɔi iyeò bɑɑɛ ŋɑ ɑ kpɑ lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ammɑ iŋɛ ì wɑɑ fɔ ide mmu. Ì wɑɑ ni inɛ ɑ́ yɔkɔ ku sɔ̃ iyeò bɑɑɛ ku ni, fiɑ iyi ɑn yɔkɔ n sobiɛ do, ǹ jilɛɑɑ Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nɔ inɛ iyi í fɔ bɛɛbɛ kɑɑ sobi iyeò bɑɑɛ mɑ́ hee ku jirimɑ ŋɑ. Bɛɛbɛi ì wɑɑ kpɑ idei Ilɑɑɔ̃ ŋɑ ku bɑ i too dedembɑ iyi ɑ̀ jɔ̀ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Iŋɛu ilu muɑfiti ŋɑi. Hɑi tɑko Ezɑi í ce wɑliiɛi dee dee nɑ iri nŋɛ wɑɑti iyi í kɔ si tiɑɛ í ni, Ilɑɑɔ̃ í ni, ");
INSERT INTO mkl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Inɛ ŋɑu ihɛ̃ ɑ̀ wɑɑ jirimɑm nii Do ɡɛlɛ nŋu ɑkɑ̃. Ammɑ idɔ nŋɑ í jĩim. ");
INSERT INTO mkl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","À wɑɑ tɔɔm nii si nɡbɛ. Woodɑi ɑmɑnɛ ŋɑi ɑ̀ wɑɑ kɔ inɛ ŋɑ si Nɔ ɑ̀ wɑɑ ni woodɑm nii. ");
INSERT INTO mkl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ŋɔi Jesu í kpe zɑmɑɑu nɔ í ni, i de itĩ i ɡbɔ yɑɑsei ideu. ");
INSERT INTO mkl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kù jɛ mii iyi wɑ lɔ hɑi do ɡɛlɛi ɑmɑnɛi í yɑ dɑsiɛ riisi. Ammɑ mii iyi í yɑ fitɑ hɑi si ɡɛlɛi ɑmɑnɛi ɑ́ dɑsiɛ riisi. ");
INSERT INTO mkl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nɔ mɔcɔɛ ŋɑu ɑ̀ nɑ ɑ̀ sɔ̃ɔ ɑ̀ ni, i kù mɑ̀ ide iyi ì fɔu bɛ í jɛɑ Fɑrisi ŋɑu tɑɑle? ");
INSERT INTO mkl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nɔ Jesu í jɛ nŋɑ í ni, jĩi bɑɑ yoomɑ iyi Bɑɑm iyi í wɑ lele kù lɔ fei, ɑɑ tuui. ");
INSERT INTO mkl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","I jɔ̀ ŋɑ bɛ. Woo mu ɡolo fɛɛju ŋɑi. Nɔ bii fɛɛju wɑ muɑ fɛɛju ɡolo ɑŋɑ minji fei ɑ̀ yɑ koo ɑ dɑsi ɡooi. ");
INSERT INTO mkl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ŋɔi Piɛɛ í ni, sisi nwɑ yɑɑsei mɔndɑu bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nɔ Jesu í ni, iŋɛ mɔ, i kù nɛ bisi ŋɑi? ");
INSERT INTO mkl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","I kù mɑ̀ ŋɑ, mii iyi wɑ lɔ hɑi do ɡɛlɛi ɑmɑnɛ fei, si inɔɛi wɑ bɔ? Si ɑnyiɛ nɔ ku fitɑ hɑi si ɑrɑ. ");
INSERT INTO mkl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ammɑ ide iyi í yɑ fitɑ hɑi si ɡɛlɛ, hɑi si idɔi wɑ nɑɑ. Nŋu bɛi wɑ dɑsi ɑmɑnɛ riisi, ");
INSERT INTO mkl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","domi hɑi si idɔi ɑmɑnɛi lɑsɑbu lɑɑlɔ wɑ nɑɑ. Inɛ ku kpɑ, do sɑkɑrɑ, do sɛ̃ɛ ku tɔtɔɔ do mudɛ̃ɛ hɑi ce ɑbɔdɔ̃, do ile, do ibo, do inɛ ku bɛjɛ, mii ŋɑu bɛ fei hɑi si idɔi wɑ nɑɑ, ");
INSERT INTO mkl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","nɔ nŋu ŋɑu bɛi í yɑ dɑsi ɑmɑnɛ riisi. Ammɑ kù jɛ kujɛ hɑi wɔɔi ɑ́ dɑsi inɛ riisi. ");
INSERT INTO mkl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Si ɑnyii nŋu, Jesu í nɛ hɑi bɛ í bɔ ikpɑ Tii do Sidɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Inɑɑboi ilɛi Kɑnɑɑ̃ ɡɔ iyi í wɑ bɛ í nɑɑ bi tɛɛ nɔ í dɔ̃ ɑnu í ni, Lɑfɛ̃ɛ, tɔkui Dɑvidi ɑmɑnlu nlɑu, ce ɑrɑɑrem. Amɑ inɑɑbom í nɛ inɛi inɔɔko, nɔ wɑ kpɑ̃ɑ iju ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ammɑ Jesu kù jɛɑɑ ide kɑ̃mɑ. Nɔ mɔcɔɛ ŋɑ ɑ̀ nɑɑ ɑ̀ tɔɔɛ ɑ̀ ni, ɑbou ihɛ̃ wɑ dɔ̃ ɑnu wɑ too ɑnyi nwɑ. I kɑɑ leleɛ? ");
INSERT INTO mkl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nɔ í jɛ í ni, bi inɛi Izirɛli ŋɑ ɑŋɑ ɑkɑ̃i ɑ̀ bɛm wɑ, inɛ ŋɑ iyi ɑ̀ yɛ bɛi ɑnɡudɑ̃ ŋɑ iyi ɑ̀ nyɔ. ");
INSERT INTO mkl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ammɑ ɑbou í nɑɑ í ɡulɛ si wɑjuɛ í ni, Lɑfɛ̃ɛ, sobiim. ");
INSERT INTO mkl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nɔ Jesu í ni, kù sĩɑ ɑ ɡbɑ ijɛi ɑmu ŋɑ ɑ nɑ ɑjɑ keeke ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ŋɔi ɑbou í ni, ntɔi Lɑfɛ̃ɛ. Ammɑ do nŋu fei, ɑjɑ keeke ŋɑu ɑ̀ yɑ wɑ ɑbɛi tɑɑbu ɑ mɑɑ jɛ buubuui ijɛ iyi wɑ cuku wɑ hɑi si tɑɑbui lɑfɛ̃ɛ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nɔ Jesu í jɛɑɑ í ni, ɑbooyi, nɑɑnɛ ku dɑsiɛ í lɑ. Bɛ́i ì bi fei ɑ́ ce. Nɔ ɡbɑkɑ̃ ɑmɑ inɑɑboɛu í bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nɔ Jesu í nɛ hɑi bɛ í too itĩi tenkui Gɑlilee, í koo í ɡũ ɑntɑi kutɑ ɡɔ í bubɑ. ");
INSERT INTO mkl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nɔ zɑmɑɑ nlɑ ɡɔ í nɑɑ bi tɛɛ. À nɑɑò ilu kutɛ ɑkɑ̃ ŋɑ wɑ, do fɛɛju ŋɑ, do wɛɛɡɛ ŋɑ, do dekĩ ŋɑ, do bɔ̃ɔ nkpɔ mɑ́ nɔ ɑ̀ jilɛ ŋɑ si wɑjui Jesu, nɔ í jɔ̀ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ŋɔi inɛ ŋɑu ɑ̀ biti iyi ɑ̀ yɛ dekĩ ŋɑu ɑ̀ wɑɑ fɔ ide, wɛɛɡɛ ŋɑu ɑ̀ bɑ iri, ilu kutɛ ɑkɑ̃ ŋɑu ɑ̀ wɑɑ nɛ, fɛɛju ŋɑ ɑ̀ wɑɑ yɛ ilu, nɔ ɑ̀ wɑɑ sɑɑbu Ilɑɑɔ̃ Lɑfɛ̃ɛi inɛi Izirɛli ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesu í kpe mɔcɔɛ ŋɑ í ni, ɑrɑɑrei inɛ ŋɑu ihɛ̃ wɑ mum, domi ɑjɔ mɛɛtɑ nŋɑi ihɛ̃ iyi ɑ̀ wɑ bi tom, nɔ sɔndɑ kɑ̃mɑ kù ɡbe nŋɑ mɑ́. Nɔ n kù bi n jɔ̀ ɑ nɛò ɑriu ku bɑ ɑ mɑɑ̀ nɑ ɑ koo ɑ cuku kpɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nɔ mɔcɔɛ ŋɑu mɔ ɑ̀ beeɛ ɑ̀ ni, to, iwoi ɑɑ kɑ bɑ ijɛ si ɡbɑbuɑu ihɛ̃ iyi ɑ́ yo zɑmɑɑ nlɑ nlɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nɔ Jesu í bee ŋɑ í ni, pɛ̃ɛ fɛloi ì nɛ ŋɑ. Ŋɔi ɑ̀ ni, pɛ̃ɛ ɑrɑ mɛɛjei do cɛ̃ɛ wɛwɛɛ ɡɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nɔ Jesu í ni inɛ ŋɑu ɑ bubɑ ilɛ. ");
INSERT INTO mkl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nɔ í so pɛ̃ɛ ɑrɑ mɛɛjeu do cɛ̃ɛ ŋɑu, í sɑɑbu Ilɑɑɔ̃ titɑ̃ í bɛi í bububuɛ í nɑ mɔcɔɛ ŋɑ ɑ kpɛ̃ nŋɑ. Ŋɔi ɑ̀ kpɛ̃ɑ inɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nɔ ɑŋɑ fei ɑ̀ jɛ ɑ̀ yo hee pɛ̃ɛu í ɡbe. Ŋɔi ɑ̀ ko pɛ̃ɛ iyi í ɡbeu nɔ í ce kɔlɔ mɛɛje. ");
INSERT INTO mkl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Inɛ ŋɑ iyi ɑ̀ jɛu ɑ̀ wɛɛi zɑkɑi ɑmɑnɛ dubu mɛɛ (4.000), bɑɑi inɑɑbo do ɑmɑ keeke ŋɑ bɑɑsi. ");
INSERT INTO mkl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ŋɔi Jesu í jɔ̀ inɛ ŋɑu ɑ̀ nɛ í bɛi í lɔ ɑkɔi inyi í nɛ ikpɑ ilɛi Mɑɡɑdɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Si ɑnyii nŋu, Fɑrisi do Sɑdusi ŋɑ ɑ̀ nɑɑ bi Jesu ɑ cɔ lɑɑkɑɛ. À tɔɔɛ ku ce mɑɑmɑɑke iyi ɑ́ nyisi iyi ɡbuɡbɑ̃ɛ hɑi bi Ilɑɑɔ̃i wɑ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ŋɔi Jesu í jɛ nŋɑ í ni, bii inunu wɑ bɔ ku lɔ nɔ lele í kpɑ̃ ì yɑ ni ŋɑ, iju iyi ɑ́ mɑ́ ɑlɑ ɑ́ dɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Bii dɑɑkɔi í yɑ ni ŋɑ, ijĩ ɑ́ rɔ domi ijĩ í dũ í we mɑnɡo. Ì wɑɑ mɑ̀ yɑɑsei lele ŋɑ ɑmmɑ i kù wɑɑ mɑ̀ yɑɑsei wɑɑti iyi ɑ̀ wɑ si nsɛi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Inɛ lɑɑlɔi nsɛi ŋɑ iyi ɑ kù leekĩò Ilɑɑɔ̃ nŋu ɑkɑ̃, nyindɑi ɑ̀ yɑ mɑɑ bi ku yɛ. Ammɑ nyindɑ ɡɔ kù wɛɛ iyi ɑɑ nyisi ŋɑ mɑ́ bii kù jɛ ide iyi í bɑ wɑlii Zonɑsiu. Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi í jɔ̀ ŋɑ í nɛ. ");
INSERT INTO mkl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Si ɑnyii nŋu, Jesu do mɔcɔɛ ŋɑu ɑ̀ koo ɑ̀ lɔ ɑkɔi inyi ɑ̀ wɑɑ bɔ ikpɑ icei tenkuu ikpɑ ihɔ̃. Nɔ wee mɔcɔɛ ŋɑu ɑ̀ ɡbɛjɛ ku so pɛ̃ɛ kosĩɑ. ");
INSERT INTO mkl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, to, i ce lɑɑkɑi do lefeei Fɑrisi do Sɑdusi ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ŋɔi mɔcɔ ŋɑu ɑ̀ wɑɑ lɑsɑbu si idɔ nŋɑ ɑ̀ wɑɑ ni, nɑ iyi í jɔ̀ ɑ kù so pɛ̃ɛ kosĩɑi í jɔ̀ wɑ fɔ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ammɑ Jesu í mɑ̀ lɑsɑbu nŋɑ iyi ɑ̀ wɑɑ ce nɔ í bee ŋɑ í ni, nɑ mii í ce ì wɑɑ ni ŋɑ, nɑ iyi í jɔ̀ iŋɛ i kù so pɛ̃ɛ kosĩɑi í jɔ̀ ǹ wɑ n fɔ bɛɛbɛ. Nɑɑnɛ nŋɛ kù lɑ. ");
INSERT INTO mkl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","I kù ɡbɔ yɑɑseɛ hee nsɛi ŋɑ? I kù wɑɑ ye ɡiɡii pɛ̃ɛ ɑrɑ miu iyi ǹ bu ǹ kpɛ̃ɑ ɑmɑnɛ dubu miu do jiɑi pɛ̃ɛ kɔlɔ iyi í ɡbe mɑ́ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mɑ̀ i kù wɑɑ ye ɡiɡii pɛ̃ɛ ɑrɑ mɛɛje iyi ǹ bububu ǹ nɑ ɑmɑnɛ dubu mɛɛ ŋɑu do jiɑi pɛ̃ɛ kɔlɔ iyi í ɡbe mɑ́ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nɑ mii í ce i kù mɑ̀ ŋɑ iyi pɛ̃ɛ si ǹ wɑ n fɑ̃ɑ. I ce lɑɑkɑi do lefeei Fɑrisi ŋɑ do Sɑdusi ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bɛbɛi mɔcɔ ŋɑu ɑ̀ mɑ̀ iyi kù jɛ lefee iyi í yɑ jɔ̀ pɛ̃ɛ ku wui wɑ fɑ̃ɑ, ɑmmɑ ɑ̀ mɑ̀ iyi cioi Fɑrisi do ti Sɑdusi ŋɑui wɑ fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nɔ Jesu í to Sezɑree si ilɛi Filipee. Nɔ í bee mɔcɔɛ ŋɑ í ni, yooi inɛ ŋɑ ɑ̀ yɑ ni ɑmu Amɑi Amɑnɛ ǹ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, inɛ ɡɔ ŋɑ ɑ̀ yɑ ni ɑwɔu Zɑ̃ɑ woo dɑsi inyiui. Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɑ ni ɑwɔu Elii wɑlii nlɑi tɑkoui. Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɑ ni ɑwɔu Zeremiii, wɑlɑkɔ wɑlii mmu ɡɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nɔ Jesu í bee ŋɑ í ni, iŋɛ mɔ ni, yooi ì ni ǹ jɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nɔ Simɔɔ Piɛɛ í jɛɑɑ í ni, ɑwɔu Amɑi Ilɑɑɔ̃ nŋu iyi í jɛ irii kuwɛɛui. Awɔi ì jɛ inɛ iyi í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ŋɔi Jesu í ni, Simɔɔ, ɑmɑi Zɑ̃ɑ, ɑwɔu ilu inɔ didɔ̃i. Kù jɛ ɑmɑnɛi í sɔ̃ɛ, bii ku jɛ Bɑɑm iyi í wɑ lele. ");
INSERT INTO mkl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Amui ǹ wɑ n sɔ̃ɛ iyi ɑwɔu Piɛɛi, wɑɑtɔ kutɑ. Si ɑntɑi kutɑui ɑn jilɛ iɡbɛm, nɔ bɑɑ iku tɑkɑɛ kɑɑ yɔkɔ ku ɡɑnji iɡbɛu . ");
INSERT INTO mkl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Awɔi ɑn nɑ yiiko si kpɑ̃ɑi bommɑi Ilɑɑɔ̃. Mii iyi ì kɔsi si ɑndunyɑ, lele mɔ ɑ̀ kɔsii. Nɔ mii iyi ì jɛsi si ɑndunyɑu, lele mɔ ɑ́ jɛsii. ");
INSERT INTO mkl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑu do kuɡɑɑbu í ni ɑ mɑɑ̀ nɑ ɑ sɔ̃ inɛ ɡɔ iyi nŋu í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hɑi wɑɑti bɛɛbɛi Jesu í sinti ku sɔ̃ mɔcɔɛ ŋɑ í ni tilɑsii nŋu ku bɔ Zeruzɑlɛmu. Tenɡi bɛi inɛ nɡbo ŋɑ do inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ ɑɑ kpɑ̃ nŋu iju. Aɑ kpɑ nŋu, ɑmmɑ si ɑjɔ mɛɛtɑsiɑ nŋu ɑ́ jĩ mɑ́ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ŋɔi Piɛɛ í ɡbɑ̃ɑ í bɔòɛ kɔkɔlɛ í sɔ̃ɔ í ni, Ilɑɑɔ̃ ku wɑɑsu ideu, Lɑfɛ̃ɛ. Ide dimi bɛɛbɛ kɑɑ bɑɛ pɑi. ");
INSERT INTO mkl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ammɑ Jesu í sindɑ í sɔ̃ Piɛɛ í ni, sɛkɛɛ hɑi bi tom Seetɑm. Ì wɑɑ bi i jɛɛm bi ku koosɛ, domi i kù wɑɑ ce lɑsɑbui Ilɑɑɔ̃, í ɡbe ti ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Si ɑnyii nŋu Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, inɛ iyi wɑ bi ku toom, ku jɔ̀ idɔɔbiɛ nɔ ku so jĩi ku ɡɑɑuɛ ku toom wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nɔ inɛ iyi wɑ bi ku bɑ kuwɛɛ do idɔɔbiɛ, kɑɑ bɑɑ. Ammɑ inɛ iyi í nyɔ kuwɛɛɛ nɑ irim, lɑfɛ̃ɛ ɑ́ bɑɑ do ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Arɑnfɑ̃ɑni yoomɑi ɑmɑnɛ í nɛ bii í bɑ ɑmɑnii ɑndunyɑ fei nɔ í kuɑ kuwɛɛɛ. Mɑ̀ mii í wɛɛ iyi ɑmɑnɛ ɑ́ kpɑɑsiò kuwɛɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Amu Amɑi Amɑnɛ ɑn nyi wɑ mɑ́ dei kɑm kɑm do ɑmboei Bɑɑm do ɑmɑlekɑm ŋɑ ɑjɔ. Si wɑɑti bɛɛbɛi ɑn sɑ̃ɑ inɛ fei si yɑɑse bɛi í jɛò kuwɛɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, inɛ ŋɑ iyi ɑ̀ wɑ ihɛ̃, ɡɔɡɔ nŋɑ ŋɑ ɑɑ yɛ ɑmu Amɑi Amɑnɛ n nɑ n jɛ bommɑm hee ɑŋɑ fei ɑ mɑɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Si ɑnyii ɑjɔ mɛɛfɑ Jesu í kpe Piɛɛ do Zɑɑki do Zɑ̃ɑ ifɔɛ í nyɑ ŋɑ ikɑ̃ nɔ ɑ̀ koo ɑ̀ ɡũ iri kutɑ nlɑ ɡɔ ɑŋɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ŋɔi ɑ̀ bɑ wee ɑrɑɛ í kpɑɑsi. Wɑjuɛ wɑ dɑɑnɑ jiidɑ jiidɑ, nɔ jɑɑɛ ŋɑ í fũutɑ pɑi pɑi bɛi inyɑ kumɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Si ɑnyiɛ ŋɔi Moizi do Elii ɑ̀ fɑɑtɑ wɑ ɑnu ɑkɑ̃ ɑ̀ wɑɑ bɑɑ ide ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ŋɔi Piɛɛ í sɔ̃ Jesu í ni, Lɑfɛ̃ɛ, í sĩɑ kɑ mɑɑ wɑ ihɛ̃. Bii ì bi, jɔ̀ kɑ ce ilei ɑcɔ mɛɛtɑ, ɑkɑ̃ titɛɛ, ɑkɑ̃ mɔ ti Moizi, ɑkɑ̃ mɔ ti Elii. ");
INSERT INTO mkl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wɑ fɔ ideu kù tɑ̃ mɔm nɔ inyɑ kumɑ́ ɡɔ í nɑɑ si ŋɑ bɛi bukɔɔ. Nɔ ɑ̀ ɡbɔ ide ku fɔ ɡɔ hɑi si inɔɛ í ni, inɛ ihɛ̃i í jɛ ɑmɑm. Ǹ buu jiidɑ jiidɑ, siɛi inɔ didɔ̃m fei í yɑ wɑ. I yɑ ɡbɔ ideɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iyi mɔcɔ ŋɑu ɑ̀ ɡbɔ ide ku fɔu ŋɔi njo í mu ŋɑ hee ɑ̀ sɛɛbɑtɑ ilɛ. ");
INSERT INTO mkl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ammɑ Jesu í nɑɑ bi tu ŋɑ í lu ŋɑ í ni, i dede ŋɑ i mɑɑ̀ jɔ̀ njo ku mu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nɔ ɑ̀ wu iju lele, ɑmmɑ ɑ kù yɛ inɛ ɡɔ bii kù jɛ Jesu nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ŋɔi ɑ̀ wɑɑ kitɑ wɑ hɑi ɑntɑi iri kutɑu nɔ Jesu í sɔ̃ ŋɑ í ni, i mɑɑ̀ sɔ̃ inɛ ɡɔ mii iyi í yɛu bɛ ŋɑ hee ɑmu Amɑi Amɑnɛ n koo n ku nɔ n jĩ hɑi si bɑlɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ŋɔi mɔcɔ ŋɑu ɑ̀ bee Jesu ɑ̀ ni, nɔ nɑ mii í ce woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ yɑ ni Eliii ɑ́ tɑko inɛ iyi Ilɑɑɔ̃ í cicɑu ku nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nɔ í jɛ nŋɑ í ni, ntɔi Eliii ɑ́ tɑko ku nɑɑ nɔ ku teese mii fei sɑ̃ɑ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ammɑ ɑn sɔ̃ ŋɛ iyi Elii í nɑɑ tɑ̃, inɛ ŋɑ ɑ kù mɑ̀ɑ, nɔ ɑ̀ ceɑɑ bɛi ɑ̀ bi. Bɛɛbɛ mɔi ɑmu Amɑi Amɑnɛ ɑn bɑ ijuukpɑ̃ si ɑwɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ŋɔi mɔcɔ ŋɑu ɑ̀ mɑ̀ bɛbɛi iyi Zɑ̃ɑ woo dɑsi inyii wɑ fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iyi ɑ̀ to wɑ bii zɑmɑɑ í wɑu, ŋɔi mɔkɔ ɡɔ í nɑɑ í ɡulɛ si wɑjui Jesu ");
INSERT INTO mkl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","í ni, Lɑfɛ̃ɛ, ce ɑrɑɑrei ɑmɑ inɛmɔkɔm nɔu ihɛ̃. Inɛi inɔɔko ɡɔ í sɔsiɛ bɔ̃ɔi cukuunɑ, wɑ wɑhɑlɑɛ mɔi jiidɑ jiidɑ. Ajɔ ɡɔ ŋɑ í yɑ dɑsiɛ inɔ inɑ wɑlɑkɔ inɔ inyi. ");
INSERT INTO mkl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ǹ soo ǹ nɑɑɛ wɑ bi mɔcɔɛ ŋɑu ihɛ̃ ɑmmɑ ɑ̀ mɔnɡɔ ku fɑɑbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu í ni, iŋɛ inɛ lɑɑlɔ hɑi dɑsi nɑɑnɛ ŋɑ, hee wɑɑti yoomɑi ɑn mɑɑ ǹ wɑ inɔ nŋɛ. Mɑ̀ hee wɑɑti yoomɑi ɑn mɑɑ n temuɑò ŋɛ. I nɑɑm ɑmɑu wɑ ihɛ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nɔ ɑ̀ nɑɑ Jesu ɑmɑu wɑ, ŋɔi í lɑ si inɛi inɔɔkou nɔ í fitɑ siɛ nɔ ɑmɑu í bɑ iri tenɡi bɛu bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ŋɔi mɔcɔi Jesu ŋɑu ɑ̀ bɔ bi tɛɛ ɑŋɑ duusɔ̃ɔ ɑ̀ beeɛ ɑ̀ ni, nɑ mii í ce ɑwɑ ɑ kù yɔkɔ ɑ kù lele inɛi inɔɔkou. ");
INSERT INTO mkl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nɔ Jesu í jɛ nŋɑ í ni, si nɑ iyi í jɔ̀ nɑɑnɛ nŋɛ kù lɑi. Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, bii nɑɑnɛ nŋɛ í lɑ í to bɑɑ dimii mii ku ɡbɛ̃ iyi í kere í re, ɑɑ yɔkɔ i sɔ̃ iri kutɑu ihɛ̃ ŋɑ í ni ku dede hɑi bɛ ku bɔ ihɔ̃, nɔ bɛɛbɛ mɔi ɑ́ dede. Nkɑ̃mɑ kù wɛɛ iyi ɑɑ mɔnɡɔ ku ce ŋɑ.  ");
INSERT INTO mkl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ammɑ dimii inɛi inɔɔko bɛɛbɛ ci yɑ fitɑ bii kù jɛ do kutɔɔ do ɑnu ku dĩ. ");
INSERT INTO mkl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ajɔ nŋu ɡɔ si bɛi mɔcɔ ŋɑu ɑ̀ tɔtɔɔ Gɑlilee bɛ ŋɔi Jesu í sɔ̃ ŋɑ í ni, ɑɑ mu ɑmu Amɑi Amɑnɛ ɑ dɑɑ inɛ ŋɑ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aɑ kpɑm, ɑmmɑ si ɑjɔ mɛɛtɑsiɑ ɑn jĩ hɑi si bɑlɛ mɑ́. Ŋɔi inɔi mɔcɔ ŋɑu í fɔ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Si ɑnyii nŋu Jesu do mɔcɔɛ ŋɑ ɑ̀ bɔ Kɑpɛrɑnumu, ŋɔi woo ɡbɑ fiɑ iyi ɑ̀ nɛ ku sɑ̃ nɑ icɛi kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu ɑ̀ nɑɑ bi Piɛɛ ɑ̀ beeɛ ɑ̀ ni, Mɛɛtu nŋɛ ci yɑ sɑ̃ fiɑi kpɑsɛ̃i Ilɑɑɔ̃? ");
INSERT INTO mkl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nɔ Piɛɛ í ni, ɑ́ɑ́, í yɑ sɑ̃. Ŋɔi Piɛɛ í nɛ kpɑsɛ̃. Iyi í lɔ ile nɔ Jesu í tɑko í beeɛ í ni, Simɔɔ, bɛirei ì wɑɑ lɑsɑbu. Ilɑɑlui ɑndunyɑ ŋɑu ihɛ̃, hɑi bi yooi ɑ̀ yɑ ɡbɑ fiɑi lɛmpoo. Hɑi bi ɑmɑɑlu ŋɑ de, mɑ̀ hɑi bi inɛ njoo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nɔ Piɛɛ í jɛ í ni, hɑi bi inɛ njoo ŋɑi. Ŋɔi Jesu í ni, nɑ nŋu, ɑmɑɑlu ŋɑ ɑ kɑɑ sɑ̃ . ");
INSERT INTO mkl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ammɑ do nŋu fei, kù sĩɑ kɑ jɛ nŋɑ bi ku koosɛ. Nɑ nŋu, bɔ tenku bɛ i koo i le kootiɑ, cɛ̃ɛ iyi í tɑko í muu, lɑ ɡɛlɛɛ. Aɑ yɛ kpɛkɛlɛ bɛ iyi ɑ́ to fiɑ ku sɑ̃i ɑwɑɛ fei. Nyɑɑ i koo i sɑ̃ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wɑɑti nŋu, mɔcɔi Jesu ŋɑu ɑ̀ nɑɑ bi tɛɛ ɑ̀ beeɛ ɑ̀ ni, si bommɑi Ilɑɑɔ̃ yooi í jɛ inɛ nɡbo. ");
INSERT INTO mkl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ŋɔi Jesu í kpe ɑmɑ keeke ɡɔ í leekĩɛ si ɑnini nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nɔ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, bii i kù kpɑɑsi idɔ nŋɛ nɔ i kù yɛ bɛi ɑmɑ keeke ŋɑ, i kɑɑ lɔ tenɡi bii Ilɑɑɔ̃ í jɛ bommɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Inɛ iyi ɑ́ jɛ inɛ nɡbo si bommɑi Ilɑɑɔ̃ nŋui í jɛ inɛ iyi í kɑye ɑrɑɛ í bɑɑ í yɛ bɛi ɑmɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Inɛ iyi í nɔ í ɡbɑ ɑmɑ keeke bɛi inɛ ihɛ̃ nɑ irim, ɑmui í ɡbɑ. ");
INSERT INTO mkl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Inɛ iyi í dɑsi inɛ ɑkɑ̃i ɑmɑ keeke ŋɑ iyi ɑ̀ dɑsim nɑɑnɛu ihɛ̃ dulum, ɑ́ tiɑ ɑ dĩɑ lɑfɛ̃ɛu ɑlɔ si kɔ̃ɔ ɑ tɑle siɛ inɔ tenku inyi ku jɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ijuukpɑ̃ nlɑ nlɑi inɛi ɑndunyɑ ŋɑ ɑɑ yɛ si nɑ iyi í jɔ̀ ɑ̀ yɑ mɑɑ dɑsi kpɑɑsi nŋɑ ŋɑ dulum. Kù nɔ kù nɛ bɛi ɑ́ ce iyi inɛ ɡɔ ŋɑ ɑ kù dɑsi kpɑɑsi nŋɑ ŋɑ dulum, ɑmmɑ inɛ iyi í ce bɛɛbɛ ɑ́ yɛ ijuukpɑ̃ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Bii í jɛ ɑwɔɛ wɑlɑkɔ isɛɛ wɑ dɑsiɛ dulum, buu i nyɔɔ ku jĩòɛ. Á tiɑɛ i lɔ si kuwɛɛ iyi ci yɑ tɑ̃ do ɑwɔ ɑkɑ̃ wɑlɑkɔ kutɛ ɑkɑ̃ do iyi ɑɑ nɛ ɑwɔ minji do kutɛ minjiu fei nɔ ɑ dɑsiɛ inɑ iyi ci yɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bii í nɔ í jɛ ijuɛi wɑ dɑsiɛ dulum, nyɑɑ i nyɔɔ ku jĩòɛ. Á tiɑɛ i lɔ si kuwɛɛ iyi ci yɑ tɑ̃ do iju ɑkɑ̃ do iyi ɑɑ nɛ iju minji fei nɔ ɑ dɑsiɛò inɑ iyi ci yɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesu í sɔ̃ ŋɑ mɑ́ í ni, i ce lɑɑkɑi i mɑɑ̀ dondɑ bɑɑ inɛ ɑkɑ̃i ɑmu ŋɑu ŋɑ. Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, ɑmɑlekɑ woo deɡbe nŋɑ ŋɑ ɑ̀ yɑ mɑɑ leekĩi ɑjɔ fei si wɑjui Bɑɑm iyi í wɑ lele.  ");
INSERT INTO mkl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Amu Amɑi Amɑnɛ ǹ nɑɑ ku fɑɑbɑ inɛ ŋɑ iyi ɑ̀ nyɔi. ");
INSERT INTO mkl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bɛirei ì wɑɑ lɑsɑbu ŋɑ. Bii inɛ ɡɔ í nɛ ɑnɡudɑ̃ cĩɔ nɔ ɑkɑ̃ɛ í nyɔ, kɑɑ jɔ̀ cĩɔ fɑkɑ̃ kù wɑ siu titɑ̃ si ɡeete bii ɑ̀ wɑu koo dɛdɛ ɑkɑ̃ iyi í nyɔu wɑ? ");
INSERT INTO mkl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ntɔ ntɔ ǹ wɑ n sɔ ŋɛi, bii í yɔɔ, ɑ́ nɛ inɔ didɔ̃ nlɑ nlɑ nɑ iriɛ ku re bɑɑ cĩɔ fɑkɑ̃ kù wɑ si iyi kù nyɔu. ");
INSERT INTO mkl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bɛɛbɛ mɔi, Bɑɑ nŋɛ iyi í wɑ lele kù bi bɑɑ inɛ ɑkɑ̃i ɑmɑ keeke ŋɑu ku nyɔ. ");
INSERT INTO mkl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesu í ni mɑ́, bii kpɑɑsi woo dɑsi nɑɑnɛ ɡɔ í ce dulum, bɔ bi tɛɛ ɑwɔ ɑkɑ̃ nɔ í jɔ̀ ku mɑ̀ yɑɑsei dulum nɔu. Bii í ɡbɔ ideɛ, ì bɑɑɛ wɑ mɑ́ si kpɑ̃ɑ jiidɑi. ");
INSERT INTO mkl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ammɑ bii í kɔ ku ɡbɔ ideɛ, dɛdɛ inɛ ɑkɑ̃ wɑlɑ minji si bɛi kukɔi idei Ilɑɑɔ̃ wɑ fɔ. I bɔ bi tɛɛ ŋɑ, nɔ inɛ ŋɑu ɑɑ jɛ sɛɛdɑi ideu fei. ");
INSERT INTO mkl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bii í kɔ ku ɡbɔ ide nŋɑ, sɔ̃ inɛi iɡbɛ ŋɑu. Bii í nɔ í kɔ ku ɡbɔ bɑɑ idei inɛi iɡbɛ ŋɑu, i dooɛ bɛi hɑi dɑsi nɑɑnɛ wɑlɑkɔ bɛi woo ɡbɑ fiɑi lɛmpoo. ");
INSERT INTO mkl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, mii iyi ì kɔsi si ɑndunyɑ fei ŋɑ, lele mɔ ɑ́ kɔsi. Nɔ mii iyi ì jɛsi si ɑndunyɑ fei ŋɑ lele mɔ ɑ́ jɛsi. ");
INSERT INTO mkl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ǹ wɑ n sɔ̃ ŋɛ mɑ́ iyi bii ɑmɑnɛ minji í ce ɑnu ɑkɑ̃ si ɑndunyɑ ihɛ̃ ɑ tɔɔ nɡɔɡɔ, Bɑɑm iyi í wɑ lele ɑ́ mu nŋɑ, ");
INSERT INTO mkl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","domi tenɡi bii ɑmɑnɛ minji wɑlɑ mɛɛtɑ í tɔtɔɔ ɑ̀ wɑɑ ce kutɔɔ do irim, ǹ wɑ si ɑnini nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ŋɔi Piɛɛ í bɔ bi Jesu í beeɛ í ni, Lɑfɛ̃ɛ, bii kpɑɑsim í ceem kurɑrɑ isɛ fɛloi ɑn ceɑɑ suuru. Hee isɛ ɡbɛɛje? ");
INSERT INTO mkl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ŋɔi Jesu í jɛɑɑ í ni, ɑɑwo. N kɑɑ n sɔ̃ɛ iyi ɑndi isɛ ɡbɛɛjei, ɑmmɑ ɑɑ ceɑɑ suurui isɛ kitɑò fɛɛwɑ tuubɑ mɛɛje. ");
INSERT INTO mkl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sotĩ i ɡbɔ fɑɑji ɡɔ iyi wɑ nyisi bɛi bommɑi Ilɑɑɔ̃ í yɛ. Ilɑɑlu ɡɔ wɑ bi ku ce dooi ɡbeseɛ iyi ɑmɑɑcɛɛ ŋɑ ɑ̀ wɑɑ mu. ");
INSERT INTO mkl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iyi í sinti ku ce dooi ɡbeseu, ŋɔi ɑ̀ nɑɑò inɛ ɡɔ wɑ bɛ, iyi wɑ mu ɡbeseɛ í to bɑɑ fɔɔtɔ ciwɑ nkpɔ nkpɔ . ");
INSERT INTO mkl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Si bɛi inɛɛu kù nɛ mii iyi ɑ́ sɑ̃ò ɡbeseu, ŋɔi lɑfɛ̃ɛɛ í ni ɑ tɑɑ bɛi ɑru, nŋu do ɑboɛ do ɑmɑɛ ŋɑ do mii iyi í nɛ fei ɑ sɑ̃ò ɡbeseu. ");
INSERT INTO mkl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ŋɔi ɑmɑɑcɛu í ɡulɛ si wɑjui lɑfɛ̃ɛɛu wɑ tɔɔɛ suuru í ni, yɔkɔɔm suuru ɑn sɑ̃ɛ mbɛ fei. ");
INSERT INTO mkl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nɔ lɑfɛ̃ɛɛu í ce ɑrɑɑreɛ í kpɑ ɡbeseu nɔ í jɔ̀ɛ í nɛ. ");
INSERT INTO mkl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Iyi ɑmɑɑcɛu í fitɑ hɑi bɛ ɡbɑkɑ̃, nɔ í ko ɑmɑɑcɛ kpɑɑsiɛ ɡɔ iyi wɑ mu ɡbeseɛ zɑkɑi kpɛkɛlɛ cĩɔ. Ŋɔi í bɑtɑɛ í tɛ kɔ̃ɔɛ í ni, sɑ̃ɑm ɡbesem iyi ì wɑɑ muu. ");
INSERT INTO mkl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ŋɔi kpɑɑsiɛu í ɡulɛ si wɑjuɛ í tɔɔɛ suuru í ni, yɔkɔɔm suuru ɑn sɑ̃ɛ ɡbeseɛ. ");
INSERT INTO mkl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ammɑ kù jɛ, nɔ í jɔ̀ ɑ̀ dɑsi kpɑɑsiɛu piisɔ̃ɔ hee koo sɑ̃ò ɡbeseu fei ku tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ŋɔi ɑmɑɑcɛ iyi ɑ̀ ɡbe ŋɑu ɑ̀ yɛ bɛi í ce nɔ inɔ nŋɑ fei í fɔ, ŋɔi ɑ̀ koo ɑ̀ sisiɑ lɑfɛ̃ɛ nŋɑ yɑɑsei ideu fei. ");
INSERT INTO mkl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ŋɔi lɑfɛ̃ɛu í kpoo í ni, ɑwɔ ɑmɑɑcɛ lɑɑlɔ, í jɔ iyi ì tɔɔm suuru ǹ kpɑ ɡbeseɛu feii mɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Awɔ mɔ ì nɛ i ce ɑrɑɑrei ɑmɑɑcɛ kpɑɑsiɛi wo si bɛi ǹ ceɛ. ");
INSERT INTO mkl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nɔ idɔi lɑfɛ̃ɛu í kɔ̃, ŋɔi í jɔ̀ ɑ̀ dɑsiɛ piisɔ̃ɔ si ɑwɔi woo kpɑ̃ inɛ ŋɑ iju hee koo sɑ̃ò ɡbeseu fei ku tɑ̃u. ");
INSERT INTO mkl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ŋɔi Jesu í ni, bɛɛbɛ mɔi Bɑɑm iyi í wɑ lele ɑ́ ce nŋɛ, iŋɛ iyi i ci yɑ ceɑ kpɑɑsi nŋɛ ŋɑ suuru do inɔ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iyi Jesu í fɔ ideu í tɑ̃ nɔ í nɛ hɑi ilɛi Gɑlilee í bɔ ikpɑ ilɛi Zudee iyi í wɑ icei idoi Zuudɛ̃ɛu. ");
INSERT INTO mkl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ŋɔi zɑmɑɑ nlɑ ɡɔ wɑ tooɛ nɔ í jɔ̀ bɔ̃ɔ ŋɑ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ŋɔi Fɑrisi ɡɔ ŋɑ ɑ̀ nɑɑ bi tɛɛ ku bɑ ɑ cɔ lɑɑkɑɛ. Nɔ ɑ̀ beeɛ ɑ̀ ni, ɑmɑnɛ í nɛ kpɑ̃ɑ ku kɔsi ɑboɛ si ide bɑɑ yoomɑ fei? ");
INSERT INTO mkl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nɔ í jɛ nŋɑ í ni, i kù cio iyi kukɔi idei Ilɑɑɔ̃ wɑ fɔ ŋɑ? Í ni, hɑi sinte, Woo tɑkɑ í ce ŋɑi inɛmɔkɔ do inɑɑbo. ");
INSERT INTO mkl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nɔ í ni mɑ́, nɑ nŋu, mɔkɔ ɑ́ jɔ̀ iyeò bɑɑɛ nɔ nŋu do ɑboɛ ɑ mɑɑ wɛɛ nɔ ɑŋɑ minji fei ɑ bɑɑ ɑ jɛ ɑrɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Si bɛɛbɛ ɑ kù jɛ ɑŋɑ minji mɑ́, ɑrɑ ɑkɑ̃ dei ɑ̀ jɛ. Nɑ nŋu, ɑmɑnɛ kù nɛ ku fɛɛfɛ mii iyi Ilɑɑɔ̃ í tɔtɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nɔ Fɑrisi ŋɑu ɑ̀ beeɛ ɑ̀ ni, bii bɛɛbɛi, nɑ mii í ce Moizi í nɑ woodɑ í ni inɛ iyi wɑ bi ku kɔsi ɑboɛ ku ceɑɑ tiɑi njɛ ku kɔ ku bɛi ku kɔsiɛ. ");
INSERT INTO mkl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nɔ Jesu í jɛ nŋɑ í ni, Moizi í jɔ̀ ì wɑɑ lele ɑbo nŋɛ ŋɑi nɑ idɔ kulele nŋɛ. Ammɑ wɑɑti iyi Ilɑɑɔ̃ í tɑkɑ ɑmɑnɛ kù jɛ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","An sɔ̃ ŋɛ, inɛ iyi í kɔsi ɑboɛ nɔ kù jɛ nɑ sɑkɑrɑ, nɔ í so mmuɛ, nŋu tɑkɑɛ í ce sɑkɑrɑi. ");
INSERT INTO mkl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ŋɔi mɔcɔɛ ŋɑu ɑ̀ sɔ̃ɔ ɑ̀ ni, bii bɛɛbɛi si ɡɑ̃mɛi ɑboò mɔkɔ í tiɑ ɑ mɑɑ̀ yɑ so njɛ. ");
INSERT INTO mkl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nɔ Jesu í ni, ide iyi ǹ wɑ n fɔ nsɛi, kù jɛ inɛ feii ɑ́ yɔkɔ ku ɡbɔ yɑɑseɛ, bii kù jɛ inɛ ŋɑ iyi Ilɑɑɔ̃ í mu nŋɑ ɡbuɡbɑ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mii ikɑ̃ ikɑ̃ iyi wɑ ɡɑnji inɛ ŋɑ njɛ ku so í kpɔ. Inɛ ɡɔ ŋɑ bɛɛbɛi ɑ̀ bí ŋɑ do, ɑ kɑɑ yɔkɔ dei. Inɛ ɡɔ ŋɑ mɔ ɑmɑnɛ ŋɑi ɑ̀ ce nŋɑ bɛɛbɛ. Inɛ ɡɔ ŋɑ mɔ ɑ kù bi ɑbo ku so ku bɑ ɑ ce icɛi bommɑi Ilɑɑɔ̃ jiidɑ jiidɑ. Inɛ iyi ɑ́ yɔkɔ ku ɡbɑ ideu ku ɡbɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Si ɑnyii nŋu, inɛ ŋɑ ɑ̀ ɡbɑ̃ ɑmɑ keeke ŋɑ ɑ̀ nɑɑ Jesu wɑ ku le si ŋɑ ɑwɔ nɔ ku ce nŋɑ kutɔɔ. Ammɑ mɔcɔɛ ŋɑ ɑ̀ wɑɑ ɡbɑɡbɑ si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, i jɔ̀ ɑmu ŋɑu ɑ nɑɑ bi tom, i mɑɑ̀ ɡɑnji ŋɑ, domi bommɑi Ilɑɑɔ̃ í jɛ ti inɛ ŋɑ iyi ɑ̀ jɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ŋɔi í le nŋɑ ɑwɔ si iri nɔ í ce nŋɑ kutɔɔ í bɛi í nɛ hɑi bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ajɔ nŋu ɡɔ mɔkɔ ɡɔ í nɑɑ bi Jesu nɔ í beeɛ í ni, Mɛɛtu, mii jiidɑ yoomɑi ɑn ce n bɑò kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nɔ Jesu í beeɛ í ni, nɑ mii í ce ì wɑɑ beem idei jiidɑ ku ce. Ilɑɑɔ̃ nŋu ɑkɑ̃i í jɛ jiidɑ. Bii ì bi i bɑ kuwɛɛ iyi ci yɑ tɑ̃, jirimɑ woodɑi Ilɑɑɔ̃ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nɔ í bee Jesu í ni, woodɑ yoomɑ ŋɑi. Nɔ í sɔ̃ɔ í ni, mɑɑ̀ kpɑ inɛ, mɑɑ̀ ce sɑkɑrɑ, mɑɑ̀ ce ile, nɔ i mɑɑ̀ jɛɑ inɛ ɡɔ sɛɛdɑ ibo. ");
INSERT INTO mkl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Jirimɑ iyeò bɑɑɛ, nɔ i bi kpɑɑsiɛ bɛi ì bi ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nɔ ɑwɑɑsũu í ni, ǹ wɑ n jirimɑ iyi bɛ fei tɑ̃, mii í ɡbe n ce mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ŋɔi Jesu í sɔ̃ɔ í ni, bii ì bi i kɔ̃ dee dee, koo tɑ mii iyi ì nɛ fei, nɔ i kpɛ̃ɑ ilu ɑre ŋɑ fiɑu. Bii ì ce bɛɛbɛ ɑɑ bɑ ɑmɑni jiidɑ lelei Aɔ̃. Si ɑnyiɛ nɔ i nɑɑ i toom. ");
INSERT INTO mkl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Iyi ɑwɑɑsũu í ɡbɔ bɛɛbɛ ŋɔi í sindɑ í nɛ do inɔ kufɔ domi ilu ɑmɑni nlɑ nlɑi. ");
INSERT INTO mkl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, ɑ́ ɡɑɑbuɑ ilu fiɑ ku lɔ tenɡi bii Ilɑɑɔ̃ í jɛ bommɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nɔ ɑn sɔ̃ ŋɛ mɑ́ iyi ɑ́ fɑɑlɑɑ kpookpo ku lɔ si iwoi ɑbɛɛ do iyi ilu ɑmɑni ɑ́ lɔò tenɡi bii Ilɑɑɔ̃ í jɛ bommɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iyi mɔcɔ ŋɑu ɑ̀ ɡbɔ ideu ŋɔi ɑ̀ biti kɑɑ kɑɑ, nɔ ɑ̀ ni, bii bɛɛbɛi, to, yooi ɑ́ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ŋɔi Jesu í cɔ ŋɑ nɔ í ni, bi ɑmɑnɛ ŋɑi kɑɑ ce, ɑmmɑ Ilɑɑɔ̃ ɑ́ yɔkɔ ku ce fei ndɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ŋɔi Piɛɛ í sɔ̃ɔ í ni, wee ɑ̀ jɔ̀ mii fei tɑ̃ ɑ̀ wɑɑ tooɛ. To, yoomɑi ɑ́ nɑ ku jɛ tu wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nɔ Jesu í sɔ̃ ŋɑ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, wɑɑti iyi Ilɑɑɔ̃ ɑ́ ce mii fei titɔ̃ nɔ ɑmu Amɑi Amɑnɛ n mɑɑ n bubɑ si bɑtɑi bommɑ ilu ɑmboem, iŋɛ ɑmɑnɛ mɑɑteeji iyi ì wɑɑ toom ŋɑu ihɛ̃, iŋɛ mɔ ɑɑ bubɑ si bɑtɑi bommɑu i kiitiò dimi mɑɑteejii inɛi Izirɛli ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nɔ inɛ bɑɑ yoomɑ iyi í jɔ̀ kpɑsɛ̃ɛ wɑ, wɑlɑkɔ iɡbɑ̃ do ifɔɛ ŋɑ, wɑlɑkɔ wecĩɛ ŋɑ, wɑlɑkɔ bɑɑɛ, wɑlɑkɔ iyeɛ, wɑlɑkɔ ɑmɑɛ ŋɑ, wɑlɑkɔ ikoɛ ŋɑ nɑ irim, ɑ́ bɑ ribɑɛ ikɔ cĩɔ, nɔ ku bɑ kuwɛɛ hɑi tɑ̃ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ammɑ inɛ ŋɑ iyi ɑ̀ jɛ inɛi wɑju ŋɑ si nsɛi, nkpɔ nŋɑ ɑ́ nɑ ku jɛ inɛi ɑnyi, nɔ inɛi ɑnyi ŋɑ mɔ, nkpɔ nŋɑ ɑ́ nɑ ku jɛ inɛi wɑju. ");
INSERT INTO mkl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesu í kpɑ nŋɑ mɔndɑu ihɛ̃ í ni, idei bommɑi Ilɑɑɔ̃ í jɔ idei ilu kpɑsɛ̃ ɡɔ iyi í fitɑ dɑɑdɑɑkɔ wɑ dɛdɛ ɑmɑɑcɛ ku bɔò ŋɑ ikoɛ. ");
INSERT INTO mkl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wɑɑti iyi í bɑ ɑmɑɑcɛ ŋɑu ɑŋɑò ŋɑ ɑ̀ fɔ ɑ̀ ɡbɔɑ njɛ ku sɑ̃ nŋɑ si bɛi ɑ̀ yɑ sɑ̃ɑ woo ce icɛ si ɑjɔ ɑkɑ̃, nɔ í ni ɑ bɔ ikoi nŋu ɑ koo ɑ ce icɛ. Nɔ ɑ̀ koo. ");
INSERT INTO mkl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nɔ zɑkɑi isɔ mɛɛsɑ̃ í fitɑ mɑ́ í koo í bɑ inɛ ɡɔ ŋɑ ɑ̀ wɑɑ bubɑ si tɑfɑ ɑ kù wɑɑ ce nkɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nɔ í sɔ̃ ŋɑ í ni, iŋɛ mɔ, i bɔ ikom i koo i ce icɛ ŋɑ. An sɑ̃ nŋɛ si bɛi í jɔ. ");
INSERT INTO mkl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ŋɔi ɑ̀ koo. Ŋɔi ilu kpɑsɛ̃u í fitɑ mɑ́ zɑkɑi dɑsɑ̃, do ɑlɛ zɑkɑi inunu ku sindɑ mɑ, nɔ ide dimi ɑkɑ̃ui í yɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Alɛ zɑkɑi isɔ miu ŋɔi í fitɑ nɔ í yɛ inɛ ɡɔ ŋɑ mɑ́ ɑ̀ wɑɑ bubɑ. Ŋɔi í bee ŋɑ í ni, nɑ mii í ce ì wɑɑ bubɑ ihɛ̃ nɡbɛ nɡbɛ hɑi dɑɑkɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, si nɑ iyi í jɔ̀ inɛ kɑ̃mɑ kù dɑsi wɑ icɛi. Ŋɔi í ni, to, iŋɛ mɔ i bɔ ikom i koo i ce icɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Iyi í to ɑlɛ zɑkɑi kulɔi inunu ŋɔi ilu kpɑsɛ̃u í kpe inɛ nɡboi ɑmɑɑcɛɛ ŋɑu í sɔ̃ɔ í ni, kpe ɡɑɑnɔɔmɑ ŋɑu wɑ, sɑ̃ nŋɑ fiɑ nŋɑ, sinti hɑi bi inɛi ɑnkɑ̃ɑnyi ŋɑu hee ku koo si inɛ sinte ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Inɛ ŋɑ iyi ɑ̀ sinti icɛ ɑlɛ zɑkɑi isɔ miu ŋɑu ɑ̀ nɑɑ ɑ̀ ɡbɑ fiɑi icɛi ɑjɔ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ammɑ iyi ɑ̀ to si inɛ sinte ŋɑu ɑ̀ tɑmɑɑ bɛi ti ɑŋɑ ɑ́ re bɛɛbɛi. Ammɑ fiɑi icɛi ɑjɔ ɑkɑ̃i ɑ̀ sɑ̃ɑ ɑŋɑ mɔ. ");
INSERT INTO mkl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Iyi ɑ̀ yɛ fiɑu bɛɛbɛ ŋɔi ɑ̀ wɑsi ku ɡbɑɡbɑ si ilu kpɑsɛ̃u. ");
INSERT INTO mkl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","À wɑɑ ni, inɛ ŋɑ iyi ɑ̀ nɑɑ ɑnkɑ̃ɑnyiu isɔ ɑkɑ̃i ɑ̀ ce icɛ nɔ ì sɑ̃ nŋɑ bɛi ɑwɑ iyi ɑ̀ ce icɛ si inyɑ ɡbɑ̃ɑ hɑi dɑɑkɔ hee ɑ̀ ɡbɛɛji. ");
INSERT INTO mkl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ŋɔi ilu kpɑsɛ̃u í sɔ̃ inɛ ɑkɑ̃ nŋɑ í ni, kpɑɑsim, n kù tɑkiɛ, domi ì jɛsi i ɡbɑ fiɑi icɛi ɑjɔ ɑkɑ̃, mɑ̀ kù jɛ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","To, ɡbɑ fiɑɛ i nɛ. Ǹ bi n sɑ̃ɑ inɛi ɑnkɑ̃ɑnyiu ihɛ̃ bɛi ɑwɔ mɔ. ");
INSERT INTO mkl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kù jɛ bɛi ǹ bii ɑn ceò fiɑm? Mɑ̀ ì wɑɑ ce iɡu si nɑ iyi í jɔ̀ ǹ ce jiidɑi. ");
INSERT INTO mkl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ŋɔi Jesu í ni, bɛɛbɛ mɔi inɛi ɑnyi ŋɑ ɑɑ nɑ ɑ́ jɛ inɛi wɑju, nɔ inɛi wɑju ŋɑ mɔ ɑ nɑ ɑ́ jɛ inɛi ɑnyi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ŋɔi Jesu í dɑsi kpɑ̃ɑ wɑ bɔ Zeruzɑlɛmu. Nɔ í nyɑ mɔcɔ mɑɑteeji ŋɑu ikɑ̃, ŋɔi í sɔ̃ ŋɑ si kpɑ̃ɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","wee ɑ̀ wɑɑ bɔ Zeruzɑlɛmu. Bɛi ɑɑ mu ɑmu Amɑi Amɑnɛ ɑ dɑsim ɑwɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ. Aɑ yɛ tɑɑlem ɑ ni ɑ kpɑm. ");
INSERT INTO mkl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Si ɑnyiɛ nɔ ɑ dɑsim si ɑwɔi dimi mmu ŋɑ, ɑɑ yɑɑkom, nɔ ɑ tɛɛm kpɔtɔɔ, nɔ ɑ kpɑkpɑm si jĩi ku ɡɑɑu. Nɔ si ɑjɔ mɛɛtɑsiɑ ɑn jĩ mɑ́ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Si ɑnyii nŋu ŋɔi iyei ɑmɑi Zebedee ŋɑ í nɑɑ bi Jesu do ɑmɑɛ ŋɑ nɔ í ɡulɛ si wɑjuɛ ku tɔɔɛ nɡɔɡɔ. ");
INSERT INTO mkl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nɔ Jesu í beeɛ í ni, mii ì bi. Ŋɔi í ni, si wɑɑti iyi ɑɑ nɑɑ i jɛ bommɑ, jɔ̀ ɑmɑ minjim ŋɑu ihɛ̃, inɛ ɑkɑ̃ ku bubɑ ɑwɔ njɛɛ, inɛ ɑkɑ̃ mɔ ɑwɔ cɑnɡɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ŋɔi Jesu í sɔ̃ mɔcɔ minji ŋɑu í ni, i kù mɑ̀ mii iyi ì wɑɑ tɔɔm ŋɑ mɔm. Aɑ yɔkɔ i temuɑò ijuukpɑ̃ iyi ɑn yɛ ŋɑ? Nɔ ɑ̀ ni ɑŋɑ ɑɑ yɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nɔ í sɔ̃ ŋɑ mɑ́ í ni, ntɔi, ɑɑ yɛ ijuukpɑ̃ iyi ɑn yɛ ŋɑ. Ammɑ kù jɛ ɑmui ɑn cicɑ inɛ ŋɑ iyi ɑɑ bubɑ si cɑnɡɑ do njɛm. Bi ku bubɑu bɛ, inɛ ŋɑ iyi Ilɑɑɔ̃ Bɑɑm í ceɑ sɔɔluɛ ŋɑi ɑɑ bubɑ si. ");
INSERT INTO mkl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ŋɔi mɔcɔ mɛɛwɑ iyi ɑ̀ ɡbe ŋɑu ɑ̀ ɡbɔ ideu nɔ idɔ nŋɑ í kɔ̃ò minji ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ŋɔi Jesu í kpe ɑŋɑ fei í sɔ̃ ŋɑ í ni, iŋɛ mɔ ì mɑ̀ ŋɑ si ɑndunyɑu ihɛ̃ ilɑɑlu ŋɑu ɑ̀ yɑ mɑɑ tɑɑ inɛ nŋɑ ŋɑ ɡbuɡbɑ̃i. Nɔ inɛ nɡbo nŋɑ ŋɑ mɔ ɑ mɑɑ nyisi yiiko nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ammɑ bi tu ŋɛ kɑɑ ce bɛɛbɛ. Inɛ nŋɛ iyi wɑ bi nŋu ku jɛ inɛ nɡbo, nŋui ɑ́ jɛ woo ce nŋɛ icɛ. ");
INSERT INTO mkl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bɛɛbɛ mɔi inɛ iyi wɑ bi nŋu ku jɛ woo cuɑ nŋɛ, ɑ́ jɛ ɑru nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bɛɛbɛ mɔi ɑmu Amɑi Amɑnɛ n kù nɑɑ inɛ ŋɑ ɑ ceem icɛ, ɑmmɑ ɑmui ɑn ce nŋɑ icɛ, nɔ n nɑ kuwɛɛm n yɑò inɛ nkpɔ hɑi si dulum. ");
INSERT INTO mkl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Si isɛɛnɛu Jesu do mɔcɔɛ ŋɑ ɑ̀ to Zeriko nɔ ɑ̀ wɑɑ fitɑ hɑi bɛ. Wɑɑti iyi ɑ wɑɑ fitɑu, zɑmɑɑ nlɑ ɡɔ wɑ too ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wee fɛɛju minji ɡɔ ŋɑ ɑ̀ wɑɑ bubɑ itĩ kpɑ̃ɑ bɛ, nɔ ɑ̀ ɡbɔ iyi Jesu wɑ lɔ. Ŋɔi ɑ̀ dɔ̃ ɑnu ɑ̀ mɑɑ ni, Lɑfɛ̃ɛ, tɔkui ilɑɑlu Dɑvidi, ce ɑrɑɑre nwɑ. ");
INSERT INTO mkl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nɔ zɑmɑɑu wɑ lɑ si ŋɑ wɑ ni ɑ coko. Ammɑ bɛ́i ɑ̀ wɑɑ ni ɑ cokou, bɛɛbɛ mɔi ɑ̀ yɑ dɔ̃ ɑnu hee lele ɑ̀ mɑɑ ni, Lɑfɛ̃ɛ, tɔkui Dɑvidi, ce ɑrɑɑre nwɑ. ");
INSERT INTO mkl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ŋɔi Jesu í leekĩ í kpe ŋɑ í bee ŋɑ í ni, mii ì bi n ce nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, Lɑfɛ̃ɛ, ɑ̀ bi kɑ yɛ ilui. ");
INSERT INTO mkl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nɔ Jesu í ce ɑrɑɑre nŋɑ í lu iju nŋɑu. Nɔ ɡbɑkɑ̃ inɛ ŋɑu ɑ̀ yɛ ilu nɔ ɑ̀ wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ŋɔi Jesu do mɔcɔɛ ŋɑ ɑ̀ mɔsi isɛɛnɛ nŋɑ nɔ ɑ̀ mɑɑi Zeruzɑlɛmu wɑ. À to Bɛtifɑje si ɡeete iyi ɑ̀ yɑ kpe Olivie. Nɔ Jesu í bɛ mɔcɔ minji ɡɔ ŋɑ ");
INSERT INTO mkl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","í ni, i bɔ ilu iyi í wɑ wɑju nŋɛu bɛ, ɑɑ yɛ bii ɡbɑnkɛlɛ ɡɔ wɑ so do ɑmɑɛ. I fũ ŋɑ i nɑɑm wɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Bii inɛ ɡɔ wɑ bee ŋɛ ide ɡɔ, i jɛɑɑ i ni, Lɑfɛ̃ɛi í nɛ bukɑɑtɑ nŋɑ. Inɛɛu ɑ́ jɔ̀ i nɑɑò ŋɑ wɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nŋu ŋɑu bɛ í cei ku bɑ idei wɑliiu ku kɔ̃ iyi í ni, ");
INSERT INTO mkl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","I sɔ̃ inɛi Siɔ̃ɔ ŋɑ, i ni, I cɔ ilɑɑlu nŋɛ wɑ nɑɑ bi tu ŋɛ. Amɑnɛ kurɔi. Si ɡbɑnkɛlɛui í ɡũ, Si ɑmɑɛ. Mɛɛmu ku so ɑsoi. ");
INSERT INTO mkl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nɔ mɔcɔ ŋɑu ɑ̀ koo ɑ̀ ce bɛi í sɔ̃ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","À nɑɑò ɡbɑnkɛlɛu do ɑmɑɛ wɑ, ɑ̀ tɛ ɑcɔ nŋɑ si ɑntɑɛ nɔ Jesu í ɡũu. ");
INSERT INTO mkl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nɔ si zɑmɑɑu inɛ nkpɔ í tɛ ibɔɛ si kpɑ̃ɑu. Inɛ ɡɔ ŋɑ mɔ ɑ̀ dɑ ɑmɑɑwɔi jĩi ŋɑ ɑ̀ tɔɔ si kpɑ̃ɑu. ");
INSERT INTO mkl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Inɛ ŋɑ iyi ɑ̀ wɑɑ cuɑ Jesu do inɛ ŋɑ iyi ɑ̀ wɑɑ tooɛ fei ɑ̀ wɑsi ku dɔ̃ ɑnu ɑ̀ wɑɑ ni, tɔkui Dɑvidi, ɑ̀ wɑɑ sɑɑbuɛ. Aɔ̃ Lɑfɛ̃ɛ ku weeɛ, ɑwɔ iyi ì wɑɑ nɑɑ do iriɛ. Kɑ sɑɑbu Ilɑɑɔ̃ hee lele . ");
INSERT INTO mkl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iyi Jesu í lɔ inɔ ilu Zeruzɑlɛmu, inɛi iluu fei í biti. Nɔ ɑ̀ wɑsi ku ni, yooi ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ŋɔi zɑmɑɑu í jɛ í ni, Jesu wɑliiui, inɛi Nɑzɑrɛti si ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ŋɔi Jesu í bɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃. Iyi í to bɛ í lele woo tɑ iwò ŋɑ do woo rɑ ŋɑ iyi ɑ̀ wɑ bɛ. Í fukɑ fukɑ tɑɑbui woo kpɑɑsi fiɑ ŋɑ, do kitɑ̃i woo tɑ ɑnkɑsiidi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nɔ í sɔ̃ ŋɑ í ni, ɑ̀ kɔɔ ɑ̀ ni, Ilɑɑɔ̃ í ni ilei nŋu ile bi ku tɔɔi ɑ́ jɛ. Ammɑ iŋɛ wee ì coo bi ku tɔtɔɔi ile ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ŋɔi fɛɛju do ilu kutɛ ɑkɑ̃ ɡɔ ŋɑ ɑ̀ nɑɑ bi Jesu kpɑsɛ̃i Ilɑɑɔ̃ bɛ nɔ í jɔ̀ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ammɑ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu, idɔ nŋɑ í kɔ̃ iyi ɑ̀ yɛ mɑɑmɑɑke ŋɑ iyi í ce, nɔ ɑ̀ ɡbɔ ɑmu ŋɑ ɑ̀ wɑsi ku dɔ̃ ɑnu ɑ̀ wɑɑ ni, tɔkui ilɑɑlu Dɑvidi, ɑ̀ wɑɑ sɑɑbuɛ. ");
INSERT INTO mkl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nɔ ɑ̀ bee Jesu ɑ̀ ni, ì bɛi ì ɡbɔ iyi ɑ̀ wɑɑ fɔ mbɛ? Nɔ í jɛ nŋɑ í ni, oo. Mii iyi wɑ ceu ihɛ̃, i kù cio ideɛ ŋɑ tenɡi bii ɑ̀ ni, Ilɑɑɔ̃ í jɔ̀ ɑ̀ ɡbɔ sɑɑbuɛ hɑi si ɡɛlɛi ɑmu ŋɑ do si ɡɛlɛi ɑmɑ kpɔtɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Si ɑnyii nŋu, í jɔ̀ ŋɑ í nɛ hɑi ilu bɛ í koo í sũ Betɑni. ");
INSERT INTO mkl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iju kumɑ́ɛ dɑɑdɑɑkɔ Jesu í nɛ hɑi Betɑni wɑ nyi Zeruzɑlɛmu, nɔ ɑri wɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ŋɔi í yɛ jĩi ndii fiɡi ɡɔ itĩ kpɑ̃ɑ bɛ, nɔ í yɑɑ siɛ. Ammɑ iyi í to kɔkɔɛ í bɑ wee wuɑ ŋɑi í nɛ. Ŋɔi í sɔ̃ jĩi nɔu í ni, ɑwɔ i kɑɑ so mɑ́ ɑjɔ kɑ̃mɑ. Nɔ ɡbɑkɑ̃ jĩi nɔu í ɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iyi mɔcɔ ŋɑu ɑ̀ yɔɔ, ŋɔi ɑ̀ biti. À bee Jesu ɑ̀ ni, bɛirei í ce jĩi ndii fiɡiu ihɛ̃ í ɡbɛ ɑnu ɑkɑ̃ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ŋɔi Jesu í jɛ nŋɑ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, bii ì dɑsi nɑɑnɛ nɔ i kù wɑɑ sikɑ ŋɑ, ɑɑ yɔkɔ i ce bɛi ǹ ceɑ jĩi nɔu ihɛ̃ ŋɑ. Nɔ kɑɑ jɛ bɑɑ iyi bɛ nŋu ɑkɑ̃, ɑɑ yɔkɔ i sɔ̃ iri kutɑu ihɛ̃ ŋɑ i ni ku dede hɑi bɛ koo dɑ́sí tenku, ɑ́ nɔ ku koo. ");
INSERT INTO mkl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bii ì dɑsi nɑɑnɛ ŋɑ, mii iyi ì tɔɔ Ilɑɑɔ̃ fei, ɑɑ bɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ŋɔi Jesu í to Zeruzɑlɛmu nɔ í bɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ mɑ́ wɑ kɔ inɛ ŋɑ si cio. Ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do inɛ nɡbo ŋɑ ɑ̀ nɑɑ bi tɛɛ, ɑ̀ beeɛ ɑ̀ ni, mii ŋɑ iyi ì wɑɑ ceu ihɛ̃, yooi í nɑɛ kpɑ̃ɑ iyi ì wɑɑ cooò. Do yiikoi yooi ì wɑɑ cooò. ");
INSERT INTO mkl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ŋɔi Jesu í jɛ nŋɑ í ni, ɑmu mɔ ɑn bee ŋɛ ide ɡɔ. Bii ì yɔkɔ ì jɛɛm ŋɑ, ɑmu mɔ ɑn sɔ̃ ŋɛ inɛ iyi í nɑm yiiko ǹ wɑ n ceò mii ŋɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hɑi iwoi Zɑ̃ɑ í bɑ yiiko iyi í dɑsiò inɛ ŋɑ inyi. Hɑi bi Ilɑɑɔ̃ de, mɑ̀ hɑi bi ɑmɑnɛ ŋɑ. Ŋɔi ɑ̀ busi njɛ ɑ̀ wɑɑ ni, bɛirei ɑɑ kɑ jɛɑɑ. Nsɛi nɔɔ, bii ɑ̀ jɛɑɑ ɑ̀ ni Ilɑɑɔ̃i, ɑ́ bee wɑ nɑ mii í ce ɑ kù dɑsi Zɑ̃ɑ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nɔ wee njo kɑɑ jɔ̀ kɑ ni hɑi bi ɑmɑnɛ ŋɑi. Bii ɑ̀ ni hɑi bi ɑmɑnɛ ŋɑi, zɑmɑɑu ɑ́ yɛ tɑɑle nwɑ si nɑ iyi í jɔ̀ inɛ fei í jɛsi iyi Zɑ̃ɑ wɑliii kɑm kɑm. ");
INSERT INTO mkl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ŋɔi ɑ̀ jɛɑ Jesu ɑ̀ ni, ɑ kù mɑ̀. Nɔ Jesu mɔ í sɔ̃ ŋɑ í ni, debɛi, ɑmu mɔ n kɑɑ n sɔ̃ ŋɛ yiikoi inɛ iyi ǹ wɑ n ceò mii ŋɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesu í kpɑ nŋɑ mɔndɑu ihɛ̃ í ni, bɛirei ì wɑɑ lɑsɑbu ŋɑ. Mɔkɔ ɡɔ í nɛ ɑmɑ inɛmɔkɔ minji. Nɔ í sɔ̃ inɛ sinteu í ni, ɑmɑɑyi, bɔ ikom i koo i ce icɛ nnyi. ");
INSERT INTO mkl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nɔ í ni, n kɑɑ n koo. Ammɑ do ɑnkɑ̃ɑnyi í ce lɑsɑbu mmu nɔ í koo. ");
INSERT INTO mkl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nɔ mɔkɔu í koo í sɔ̃ ɑmɑ minjisiɑɛu mɔ bɛɛbɛ, nɔ ɑmɑu í jɛɑɑ í ni, to, ɑn koo, bɑɑbɑ. Ammɑ kù koo. ");
INSERT INTO mkl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Si ɑmɑ minji ŋɑu yoo nŋɑi í ce idɔɔbii bɑɑɛ. Ŋɔi ɑ̀ ni, inɛ sinteui. Ŋɔi Jesu í sɔ̃ ŋɑ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, woo ɡbɑ fiɑi lɛmpoo do inɑɑbo woo tɑ icu ŋɑ ɑɑ tɑko ŋɛ ɑ lɔ si tenɡi bii Ilɑɑɔ̃ í jɛ bommɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ǹ wɑ n fɔ bɛɛbɛi si nɑ iyi í jɔ̀ Zɑ̃ɑ í nɑɑ ku nyisi ŋɛ kpɑ̃ɑ jiidɑ, nɔ i kù dɑsiɛ nɑɑnɛ ŋɑ. Woo ɡbɑ fiɑi lɛmpoo do woo tɑ icu ŋɑi ɑ̀ dɑsiɛ nɑɑnɛ. Ammɑ iŋɛ, do iyi ì yɛ idɔ ku kpɑɑsi nŋɑ ŋɑ fei i kù kpɑɑsi idɔ nŋɛ i dɑsiɛ nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, i ɡbɔ mɔndɑ ɡɔ mɑ́ ŋɑ. Ilu kpɑsɛ̃ ɡɔ í ce ikoɛ, nɔ í lɔ si jĩi ndii rezɛ̃ɛ ŋɑ nɔ í ce kɑɑ í kɑɑkooɛò. Nɔ í ce bi ku fɔ̃ inyii isoɛ. Nɔ í cɑ̃ tɑfɑ bii ku deɡbe ikou. Ŋɔi í so ɡɑɑnɔɔmɑ ŋɑ í dɑsi ŋɑ si ikou ɑ mɑɑ loɡooɛ, í bɛi í bɔ ilu koo kpɛ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wɑɑti iyi isoi jĩi nɔu í jĩɑ í to ku kɑ, ŋɔi í bɛ ɑmɑɑcɛ ŋɑ wɑ bi woo loɡoo ŋɑu ɑ koo ɑ ɡbɑ iyi í jɛ ti nŋu wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ammɑ ɡɑɑnɔɔmɑ ŋɑu ɑ̀ dede ɑ̀ wo si ŋɑ, ɑ̀ cɑ̃ inɛ ɑkɑ̃, nɔ ɑ̀ kpɑ inɛ ɑkɑ̃ mɑ́, nɔ ɑ̀ tɑ inɛ mɛɛtɑsiɑu mɔ kutɑ ɑ̀ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nɔ ilu ilɛu í bɛ si ŋɑ ɑmɑɑcɛ ɡɔ ŋɑ wɑ mɑ́. Inɛ nŋu ŋɑ ɑ̀ kpɔ ɑ̀ re bɑɑ inɛi tɑko ŋɑu. Do nŋu fei, ɑ̀ ce nŋɑ bɛi ɑ̀ ceɑ inɛi tɑko ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Si ɑnyii ɑŋɑ fei í bɛ si ŋɑ ɑmɑ ɑbíɛ wɑ, í ni, ɑɑ jirimɑ ɑmɑm. ");
INSERT INTO mkl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ammɑ iyi ɡɑɑnɔɔmɑ ŋɑu ɑ̀ yɛ ɑmɑu ɑ̀ fɔ ɑŋɑ duusɔ̃ɔ ɑ̀ wɑɑ ni, i cɔ inɛ iyi ɑ́ nɑ ku jɛ tubuu. I nɑɑ wɑ kɑ kpɑɑ nɔ ilɛu ku bɑɑ ku jɛ tu wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ŋɔi ɑ̀ muu ɑ̀ fitɑɛ hɑi inɔ kɑɑu ɑ̀ koo ɑ̀ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","To, wɑɑti iyi ilu ilɛu ɑ́ nɑɑ, bɛirei ɑ́ ceɑ ɡɑɑnɔɔmɑ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, ɑ́ kpɑ inɛ lɑɑlɔ ŋɑui kɑɑ ce ɑrɑɑre nŋɑ nɔ ku dɛ ɡɑɑnɔɔmɑ mmu ŋɑ ku dɑsi ŋɑ si ilɛɛu, inɛ ŋɑ iyi bii isoi jĩi nɔu í jĩɑ ɑɑ yɑ nɑ́ɑ iyi í jɛ tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ŋɔi Jesu í bee ŋɑ í ni, i kù cio iyi ihɛ̃ si kukɔi idei Ilɑɑɔ̃ ŋɑ bɑ. Í ni, Kutɑ iyi woo mɑ ŋɑ ɑ̀ kɔsiu Nŋui í bɑɑ í jɛ kutɑ sintei icui ileu. Aɔ̃ Lɑfɛ̃ɛi í coo, nɔ í mu wɑ biti. ");
INSERT INTO mkl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nɔ Jesu í ni mɑ́, ǹ wɑ n sɔ̃ ŋɛi, Ilɑɑɔ̃ ɑ́ ɡbɑ bommɑɛ hɑi bi tu ŋɛ ku nɑ dimi mmu ŋɑ iyi ɑ̀ wɑɑ ce idɔɔbiɛ.  ");
INSERT INTO mkl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Inɛ iyi í cuku si kutɑu ihɛ̃, kutɑu ɑ́ lɛɡɛɛi. Inɛ iyi í nɔ í bɑtɑ mɔ ɑ́ lɔlɔ lɑfɛ̃ɛi nɛkɔ̃ nɛkɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Iyi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do Fɑrisi ŋɑu ɑ̀ ɡbɔ mɔndɑi Jesu ŋɑu, ɑ̀ mɑ̀ iyi ɑŋɑi wɑ fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ŋɔi ɑ̀ wɑɑ dɛ kpɑ̃ɑ bɛi ɑɑ ce ɑ muu. Ammɑ ɑ̀ wɑɑ ce njoi zɑmɑɑu si nɑ iyi í jɔ̀ ɑ̀ dɑsi nɑɑnɛ iyi wɑliii ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ŋɔi Jesu í sɔ̃ ŋɑ ide do mɔndɑ ŋɑ mɑ́ í ni, ");
INSERT INTO mkl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","i ɡbɔ fɑɑji ɡɔ iyi wɑ nyisi ŋɛ bɛi bommɑi Ilɑɑɔ̃ í yɛ. Ilɑɑlu ɡɔ wɑ ceɑ ɑmɑɛ ɑbɔdɔ̃, ");
INSERT INTO mkl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","nɔ í bɛ ɑmɑɑcɛɛ ŋɑ í ni ɑ koo ɑ kpe inɛ ŋɑ iyi ɑ̀ kpe ɑbɔdɔ̃u wɑ. Ammɑ inɛ ŋɑu ɑ kù wɑɑ bi ku nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nɔ í bɛ ɑmɑɑcɛ mmu ɡɔ ŋɑ mɑ́ í ni, i koo i sɔ̃ inɛ ŋɑ iyi ǹ kpe ŋɑu i ni ǹ tɑ̃ sɔɔlu. Kɛtɛ kombo ŋɑ do mɛɛmu ku nɛ ikpo ɡɔ ŋɑi ǹ kpɑ nɔ ɑ̀ ce icɛi fei ndɛɛ ɑ̀ tɑ̃, ɑ nɑɑ wɑ bi ku ce ɑbɔdɔ̃u. ");
INSERT INTO mkl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ammɑ inɛ ŋɑ iyi ɑ̀ kpe ŋɑu ɑ kù sɑɑluɛ mɔm, inɛ fei í nɛ wũɑɛ. Inɛ ɡɔ ŋɑ ɑ̀ nɛ iko nŋɑ, inɛ ɡɔ ŋɑ mɔ ɑ̀ nɛ sĩɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Gɔɡɔ ŋɑ ɑ̀ mu ɑmɑɑcɛ ŋɑu ɑ̀ cɑ̃ ŋɑ ɑ̀ kpɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ŋɔi idɔi ilɑɑluu í kɔ̃ nɔ í bɛ sooɡeɛ ŋɑ ɑ̀ koo ɑ̀ kpɑ woo kpɑ inɛ ŋɑu nɔ ɑ̀ dɑsi ilu nŋɑu inɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ŋɔi í sɔ̃ ɑmɑɑcɛɛ ŋɑu mɑ́ í ni, to, ijɛi ɑbɔdɔ̃u í jĩɑ, ɑmmɑ inɛ ŋɑ iyi ǹ tɑko ǹ kpe ŋɑu ɑ kù jɔò ijɛu bɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nɑ nŋu, i bɔ si tɑfɑ ŋɑ i kpe inɛ ŋɑ iyi ɑ̀ wɑ bɛ fei wɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nɔ ɑmɑɑcɛ ŋɑu ɑ̀ bɔ si tɑfɑ ŋɑu ɑ̀ tɔtɔɔ inɛ ŋɑ iyi ɑ̀ wɑ bɛ fei wɑ, hɑi inɛ jiidɑ do inɛ lɑɑlɔ ŋɑ, nɔ ɑbɔdɔ̃u í kɔ̃ do ɑmɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Iyi ilɑɑluu í lɔ ile bi ku ce ɑbɔdɔ̃u, í cɔ inɛ ŋɑ iyi ɑ̀ nɑɑ ku jɛu, nɔ i bɑ wee, inɛ ɑkɑ̃ kù wɑɑ dɑsi jĩnɛi ɑbɔdɔ̃ iyi í nɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ŋɔi í beeɛ í ni, kpɑɑsi, bɛirei í ce ì lɔ wɑ ihɛ̃ i kù wɑɑ dɑsi jĩnɛi ɑbɔdɔ̃. Nɔ inɛɛu kù ni ide kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ŋɔi ilɑɑluu í sɔ̃ ɑmɑɑcɛɛ ŋɑ í ni, i dĩ ɑwɔɛ do isɛɛ ŋɑ nɔ i soo i nyɔɔ ɑnɡule si ilu kuku, tenɡi bii inɛ ŋɑ ɑɑ lesi ɑwɔ si iri ɑ kpɑtɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nɔ Jesu í ni mɑ́, do iyi Ilɑɑɔ̃ í kpe inɛ nkpɔ fei, inɛ iyi í cicɑ kù kpɔ. ");
INSERT INTO mkl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wɑɑti bɛɛbɛ Fɑrisi ŋɑ ɑ̀ koo ɑ̀ tɔtɔɔ ɑ̀ wɑɑ busi njɛ ɑ bɑ ɑ leɑ Jesu tɑɑi ide. ");
INSERT INTO mkl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ŋɔi ɑ̀ bɛ mɔcɔ nŋɑ ɡɔ ŋɑ do inɛi Herodu ɡɔ ŋɑ bi tɛɛ. Iyi ɑ̀ to ŋɔi ɑ̀ ni, Mɛɛtu, ɑ̀ mɑ̀ iyi ì yɑ fɔ ntɔ, nɔ ì wɑɑ kɔ inɛ ŋɑ si idei Ilɑɑɔ̃ do ntɔ. Bɛɛbɛ mɔi i kù wɑɑ ce njoi inɛ ɡɔ, domi i ci yɑ cɔ ijui ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nɑ nŋu, sɔ̃ wɑ bɛi ì yɛ. Í sĩɑ kɑ sɑ̃ɑ ilɑɑlu Sezɑɑ fiɑi lɛmpoo? Mɑ kɑ mɑɑ̀ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wee Jesu í mɑ̀ lɑsɑbu nŋɑ iyi ɑ̀ wɑɑ ce tɑ̃, ŋɔi í sɔ̃ ŋɑ í ni, iŋɛ ilu muɑfiti ŋɑ, nɑ mii í ce ì wɑɑ leem tɑɑi ide ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","I nyisim kpɛkɛlɛ iyi ì yɑ sɑ̃ò lɛmpoou wɑ ŋɑ. Nɔ ɑ̀ nyisiɛ kpɛkɛlɛ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nɔ Jesu í bee ŋɑ í ni, fotooi yooi í wɑ si kpɛkɛlɛu ihɛ̃ nɔ irii yooi ɑ̀ kɔ si. ");
INSERT INTO mkl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nɔ ɑ̀ ni, ti Sezɑɑi. Ŋɔi Jesu í sɔ̃ ŋɑ í ni, to, debɛi i sɑ̃ɑ Sezɑɑ iyi í jɛ tɛɛ ŋɑ, nɔ i sɑ̃ɑ Ilɑɑɔ̃ mɔ iyi í jɛ tɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iyi ɑ̀ ɡbɔ ideu bɛɛbɛ, ŋɔi ɑ̀ biti ɑ̀ jɔ̀ɔ ɑ̀ nɛ. ");
INSERT INTO mkl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Si ɑjɔ ɑkɑ̃u Sɑdusi ɡɔ ŋɑ mɔ ɑ̀ nɑɑ bi Jesu mɑ́. Aŋɑi ɑ̀ yɑ mɑɑ ni iku ŋɑ ɑ kɑɑ jĩ. Iyi ɑ̀ to wɑ bi Jesu ŋɔi ɑ̀ beeɛ ɑ̀ ni, ");
INSERT INTO mkl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mɛɛtu, Moizi í ni bii inɛ ɡɔ í ku í jɔ̀ ɑboɛ nɔ kù bíò ɑmɑ, ifɔɛ ku so jɑɑɔ̃u ku bɑ ku bíɑ iɡbɑ̃ɛ ɑmɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wee si inɔ nwɑ inɛ mɛɛje ɡɔ ŋɑ ɑ̀ wɛɛ iyi ɑ̀ jɛ ɑmɑi bɑɑ ɑkɑ̃. Iɡbɑ̃ nŋɑ í so ɑbo nɔ kù bíò ɑmɑ nɔ í ku í jɔ̀ɑ ifɔɛ jɑɑɔ̃u. ");
INSERT INTO mkl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bɛɛbɛi inɛ minjisiɑu mɔ í ce, do mɛɛtɑsiɑu, hee í koo í kɑ̃siò ɑmɑnɛ mɛɛjesiɑu. ");
INSERT INTO mkl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Si ɑnyii ɑŋɑ fei nɔ ɑbou mɔ í nɑ í ku. ");
INSERT INTO mkl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","To, ɑjɔ iyi iku ŋɑ ɑɑ nɑ ɑ jĩ, ɑboi yoo nŋɑi ɑ́ jɛ, si bɛi ɑŋɑ fei ɑ̀ soo ɑboi. ");
INSERT INTO mkl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ammɑ Jesu í jɛ nŋɑ í ni, ì wɑɑ rɑrɑ ŋɑi si nɑ iyi í jɔ̀ i kù mɑ̀ ɡbuɡbɑ̃i Ilɑɑɔ̃ ŋɑ hee mɑ́ jɛ mii iyi kukɔi ideɛ wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ntɔ ntɔ, si wɑɑti iyi iku ŋɑ ɑɑ nɑɑ ɑ jĩ, wɑɑti bɛɛbɛ inɛmɔkɔ ŋɑ do inɑɑbo ŋɑ ɑ kɑɑ so njɛ mɑ́, ɑmmɑ ɑɑ yɛi bɛi ɑmɑlekɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Iyi í jɛ ti idei kujĩi iku ŋɑ, ɑ̀ kɔɔ wo ɑ̀ ni, Ilɑɑɔ̃ í ni nŋu Ilɑɑɔ̃, Lɑfɛ̃ɛi Aburɑhɑmui, do ti Izɑɑki, do ti Zɑkɔbu. I kù cio ideu bɛ ŋɑ iyi Ilɑɑɔ̃ í sɔ̃ ŋɛi? Ilɑɑɔ̃ kù jɛ Lɑfɛ̃ɛi iku ŋɑ, Lɑfɛ̃ɛi inɛ ŋɑ iyi ɑ̀ wɛɛi. ");
INSERT INTO mkl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nɔ zɑmɑɑ iyi í wɑ bɛ fei í ɡbɔ cioi ideɛ nɔ ideu í tosi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ŋɔi Fɑrisi ŋɑu ɑ̀ ɡbɔ iyi Jesu í kɑ̃miɑ Sɑdusi ŋɑu si ideu nɔ ɑ̀ tɔtɔɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Inɛ ɑkɑ̃ nŋɑ iyi wɑ jɛ woo kɔ inɛ ŋɑ si woodɑu wɑ bi ku cɔ lɑɑkɑi Jesu nɔ í beeɛ í ni, ");
INSERT INTO mkl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Mɛɛtu, si woodɑ ŋɑu fei, yoomɑi í re. ");
INSERT INTO mkl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ŋɔi Jesu í jɛɑɑ í ni, bi Aɔ̃ Lɑfɛ̃ɛɛ do idɔɛ fei do lɑsɑbuɛ fei. ");
INSERT INTO mkl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nŋu bɛi í jɛ woodɑ sinte, nŋui í nɔ í re ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Minjisiɑ iyi í too wee. Bi inɛ mmu ŋɑ bɛi ì bi ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Woodɑ minji ŋɑu bɛi ɑ̀ jɛ icui idei woodɑi Moizi do ti idei wɑlii ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Si bɛi Fɑrisi ŋɑu ɑ̀ tɔtɔɔ, ŋɔi Jesu í bee ŋɑ ideu ihɛ̃ ");
INSERT INTO mkl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","í ni, bɛirei ì wɑɑ lɑsɑbu si idei inɛ iyi Ilɑɑɔ̃ í cicɑ ŋɑ. Tɔkui yooi í jɛ. Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, tɔkui ilɑɑlu Dɑvidii. ");
INSERT INTO mkl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nɔ Jesu í bee ŋɑ í ni, bii bɛɛbɛi, bɛirei í ce Dɑvidi wɑ kpoo Lɑfɛ̃ɛ wɑɑti iyi í fɔ do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃ í ni, ");
INSERT INTO mkl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Aɔ̃ Lɑfɛ̃ɛ í sɔ̃ Lɑfɛ̃ɛm í ni, Bubɑ si ɑwɔ njɛm ihɛ̃ Hee n ce mbɛɛɛ ŋɑ bi ku lesi isɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nɔ Jesu í ni mɑ́, to, bii Dɑvidi wɑ kpoo Lɑfɛ̃ɛɛ, bɛirei ɑ́ ce ku jɛ tɔkuɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nɔ bɑɑ inɛ ɑkɑ̃ nŋɑ kù yɔkɔ ku jɛɑɑ ide kɑ̃mɑ. Nɔ hɑi wɑɑti bɛɛbɛu inɛ ɡɔ kù beeɛ ide ɡɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ŋɔi Jesu í sɔ̃ zɑmɑɑu do mɔcɔɛ ŋɑu, ");
INSERT INTO mkl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","í ni, woo kɔ inɛ ŋɑ si woodɑ ŋɑu do Fɑrisi ŋɑu, ɑŋɑi ɑ̀ sɑ̃si ɑɡbɛi Moizi ɑ̀ wɑɑ sisi woodɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nɑ nŋu, i yɑ ɡbɔ ide nŋɑ nɔ i ce mii iyi ɑ̀ wɑɑ sɔ̃ ŋɛ fei. Ammɑ i mɑɑ̀ yɑ ce kookoosu bɛi ɑ̀ wɑɑ ce, domi ide iyi ɑ̀ yɑ fɔ ɑ ci yɑ ceò icɛ. ");
INSERT INTO mkl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","À yɑ dĩ ɑso ku wo ɑ mɑɑ kɑ̃ɑ inɛ ŋɑ, ɑmmɑ ɑŋɑ tɑkɑ nŋɑ ɑ ci yɑ jɛsi ɑ luu bɑɑ do ɑmɑɑwɔ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kookoosu nŋɑ iyi ɑ̀ wɑɑ ce fei ɑ̀ wɑɑ cooi ku bɑ ɑ yɛ ŋɑò. Bɛɛbɛi ɑ̀ yɑ dĩ ɑmɑ tiɑ iyi í lɑ í re ti kpɑɑsi ŋɑ nɔ ɑ dɑsi jɑbɑ nŋɑ ikũ sisɔ iyi í re ti kpɑɑsi ŋɑ si itĩ do ilɛ . ");
INSERT INTO mkl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nɔ ɑ ci yɑ bi kɑɑ inyɑ sinte bi ku jɛ jinɡɑu ŋɑ do kitɑ̃i inɛ nɡbo ŋɑ ile bii ɑ̀ yɑ ce kutɔtɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","À yɑ bi inɛ ŋɑ ɑ mɑɑ ce ɑŋɑ fɔɔ si bɑntumɑ do bɛɛrɛ nɔ ɑ mɑɑ kpe ŋɑ lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ammɑ iŋɛ, i mɑɑ̀ yɑ jɔ̀ ɑ kpe ŋɛ lɑfɛ̃ɛ, domi iŋɛ fei sɑɑ ŋɑi, nɔ Lɑfɛ̃ɛ ɑkɑ̃ leɡe leɡei ì nɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nɔ i mɑɑ̀ kpe inɛ kɑ̃mɑ Bɑɑbɑ si ilɛ ihɛ̃ ŋɑ, domi inɛ ɑkɑ̃i í jɛ Bɑɑ nŋɛ. Nŋui í wɑ lele. ");
INSERT INTO mkl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nɔ i mɑɑ̀ yɑ jɔ̀ ɑ kpe ŋɛ ilɑɑlu ŋɑ domi ilɑɑlu ɑkɑ̃ leɡe leɡei ì nɛ ŋɑ, nŋui í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Inɛ iyi í jɛ inɛ nɡbo nŋɛ nŋui í nɛ ku jɛ woo ce icɛ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Inɛ iyi í so ɑrɑɛ lele, ɑɑ kɑyeɛi, inɛ mɔ iyi í kɑye ɑrɑɛ ɑɑ soo lelei. ");
INSERT INTO mkl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jesu í ni, iŋɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑ do Fɑrisi ŋɑ, iŋɛ ilu muɑfiti ŋɑi. Aɑ yɛ ijuukpɑ̃ ŋɑ, si nɑ iyi í jɔ̀ ì wɑɑ cĩmboɑ inɛ ŋɑ kpɑ̃ɑi bommɑi Ilɑɑɔ̃ ŋɑ. Iŋɛ tɑkɑ nŋɛ, i kù jɛsi i lɔ ŋɑ, nɔ inɛ ŋɑ iyi ɑ̀ bi ku lɔ, ì wɑɑ ɡɑnji ŋɑ ŋɑ.  ");
INSERT INTO mkl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Iŋɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑ do Fɑrisi ŋɑ, iŋɛ ilu muɑfiti ŋɑi. Aɑ yɛ ijuukpɑ̃ ŋɑ, si nɑ iyi í jɔ̀ ì yɑ mɑɑ ce kutɔɔ sisɔ ŋɑ ku bɑ inɛ ŋɑ ɑ ni iŋɛu inɛ jiidɑ ŋɑi. Nɔ wee mii iyi jɑɑɔ̃ ŋɑ ɑ̀ nɛ fei ì yɑ ɡbɑɑ ŋɑi. Nɑ ŋɔi í jɔ̀ ijuukpɑ̃ nŋɛ ɑ́ lɑ ku re. ");
INSERT INTO mkl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Iŋɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑ do Fɑrisi ŋɑ, iŋɛ ilu muɑfiti ŋɑi. Aɑ yɛ ijuukpɑ̃ ŋɑ, si nɑ iyi í jɔ̀ ì wɑɑ dɑbii bii fei ŋɑ, ì wɑɑ nɛ si tenku do si ilɛ fei ì wɑɑ dɛdɛ bɑɑ inɛ ŋɑ iyi ɑɑ bɑ i kpɑɑsi idɔ nŋɑ ŋɑ. Nɔ bii ì bɑ ŋɑ ì yɑ sindɑ lɑfɛ̃ɛ ŋɑi ku jɛ inɛ iyi ɑ̀ nɛ ɑ dɑsiɛ inɑ iyi ci yɑ ku ku re bɑɑ iŋɛ tɑkɑ nŋɛ isɛ ɡbeeji. ");
INSERT INTO mkl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Iŋɛ fɛɛju ŋɑi iyi ì wɑɑ mu ɡoloi fɛɛju ŋɑ, ɑɑ yɛ ijuukpɑ̃ ŋɑ. Ì yɑ mɑɑ ni ŋɑ, bii inɛ í ceekpe do kpɑsɛ̃i Ilɑɑɔ̃ kù jɛ tɑɑle bɑɑ bii kù kɔ̃ɔ. Ammɑ bii í ceekpe do wurɑi kpɑsɛ̃u, tilɑsii ku kɔ̃ ideu. ");
INSERT INTO mkl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Iŋɛ fɛɛju nnyɛi ŋɑi. Yoomɑi í lɑ í re. Wurɑu? Mɑ̀ kpɑsɛ̃ iyi í jɔ̀ wurɑu í jɛ ti Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nɔ ì wɑɑ ni mɑ́ ŋɑ, bii inɛ í ceekpe do bi kuwee kù jɛ tɑɑle bɑɑ bii kù kɔ̃ɔ, ɑmmɑ bii í ceekpe do iŋɑi kuweeu, tilɑsii ku kɔ̃ ideu. ");
INSERT INTO mkl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Iŋɛ fɛɛju ŋɑi. Yoomɑi í lɑ í re. Iŋɑi kuweeu? Mɑ̀ bi kuwee iyi í jɔ̀ iŋɑi kuweeu í jɛ ti Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nɑ nŋu, inɛ iyi í ceekpe do bi kuwee, hee do mii iyi wɑ lesi feii í ceekpeò. ");
INSERT INTO mkl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Inɛ mɔ iyi í ceekpe do kpɑsɛ̃i Ilɑɑɔ̃, hee do Ilɑɑɔ̃ iyi í wɑ bɛ feii í ceekpeò. ");
INSERT INTO mkl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Inɛ mɔ iyi í nɔ í ceekpe do lele, hee do bɑtɑi bommɑi Ilɑɑɔ̃ do Ilɑɑɔ̃ tɑkɑɛ iyi wɑ bubɑ bɛi í ceekpeò. ");
INSERT INTO mkl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Iŋɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑ do Fɑrisi ŋɑ, iŋɛ ilu muɑfiti ŋɑi. Aɑ yɛ ijuukpɑ̃ ŋɑ, si nɑ iyi í jɔ̀ ì wɑɑ nɑ Ilɑɑɔ̃ hee do zɑkɑɑi nyɑui ɑyɛ ŋɑ, ɑmmɑ ì wɑɑ ɡbɛjɛ mii iyi í lɑ í re si woodɑ ŋɑ. Mii ŋɑui í jɛ idɔɔbii Ilɑɑɔ̃ ku ce do ɑrɑɑre ku nyisi do ilu nɑɑnɛ ku jɛ. Nŋu ŋɑu bɛi í jɔ i ce ŋɑ, nɔ i mɑɑ̀ ɡbɛjɛ iyi í ɡbe ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Iŋɛ fɛɛju ŋɑi iyi ì wɑɑ mu ɡoloi fɛɛju ŋɑ. Ì wɑɑ coo inyi nŋɛ nɑ kokoo ŋɑ nɔ ì bɛi ì wɑɑ miò kpookpo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Iŋɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑ do Fɑrisi ŋɑ, iŋɛ ilu muɑfiti ŋɑi. Aɑ yɛ ijuukpɑ̃ ŋɑ si nɑ iyi í jɔ̀ ɑnyii kɔɔfu do ti jɛɛ ŋɑi ì yɑ wiɛ ŋɑ, ɑmmɑ hɑi si binɛ lɑɑlɔ do ilei ì bɑò mii ndii inɔɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Awɔ Fɑrisi fɛɛju, wiɛ inɔi jɛɛ titɑ̃, ɑnyiu mɔ ku bɛi ku mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Iŋɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑ do Fɑrisi ŋɑ, iŋɛ ilu muɑfiti ŋɑi. Aɑ yɛ ijuukpɑ̃ ŋɑ, si nɑ iyi í jɔ̀ ì yɛ ŋɑi bɛi bɑlɛ iyi ɑ̀ jɔsi mii fũfũ ku bɑ ɑnyiɛ ku sĩɑ, ɑmmɑ inɔɛ kũkũi ɑmɑnɛ do konkombi wɑ kɔ̃ si. ");
INSERT INTO mkl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bɛɛbɛ mɔi iŋɛ tɑkɑ nŋɛ, bii inɛ ŋɑ ɑ̀ wɑɑ yɛ ŋɛ, iŋɛ inɛ jiidɑ ŋɑi, ɑmmɑ si idɔ nŋɛ muɑfiti do lɑɑlɔi wɑ kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Iŋɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑ do Fɑrisi ŋɑ, iŋɛ ilu muɑfiti ŋɑi. Aɑ yɛ ijuukpɑ̃ ŋɑ, si nɑ iyi í jɔ̀ ì wɑɑ teese bɑlɛi wɑlii ŋɑu, nɔ ì wɑɑ ce boodɑ si ti inɛ dee dee ŋɑu mɔ mɑ́ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nɔ ì wɑɑ ni ŋɑ, bii í jɛ si wɑɑtii bɑlɑ nwɑ ŋɑi ɑ̀ dede wo ɑ kɑɑ kɑ dɑsi bɑɑ nwɑ si wɑlii ŋɑu ku kpɑ. ");
INSERT INTO mkl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iŋɛ tɑkɑ nŋɛ ì wɑɑ nyisi iyi iŋɛ tɔkui inɛ ŋɑ iyi ɑ̀ kpɑ wɑlii ŋɑui. ");
INSERT INTO mkl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","To, i hɑnyɑ i tɑmbɔ lɑɑlɔ iyi bɑlɑ nŋɛ ŋɑ ɑ̀ sintiu. ");
INSERT INTO mkl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Iŋɛ inɛ buu ŋɑ bɛi njo wukuku. I kù nɛ bɛi ɑɑ ce i sɑɑ inɑ iyi ci yɑ kuu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nɑ nŋu, i de itĩ i ɡbɔ, ɑn bɛ nŋɛ wɑlii ŋɑ wɑ do ilu bisi ŋɑ do woo mɑ̀ tiɑ ŋɑ. Si inɔ nŋɑ ɑɑ kpɑ ɡɔɡɔ ŋɑ, nɔ i kpɑkpɑ ɡɔɡɔ ŋɑ mɔ si jĩi ku ɡɑɑu, ɡɔɡɔ ŋɑ mɔ nɔ i tɛ nŋɑ kpɔtɔɔ ile bii ì yɑ ce kutɔtɔɔ nŋɛ ŋɑ, nɔ i lele ŋɑ si ilu ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nɑ nŋu, ijuukpɑ̃i woo kpɑ inɛ dee dee ŋɑu fei ɑ́ jɛ si iri nŋɛi. Abɛlii í jɛ inɛ dee dee sinte iyi ì kpɑ ŋɑ. Zɑkɑri ɑmɑi Bɑrɑki iyi ì kpɑ si ɑfei kpɑsɛ̃i Ilɑɑɔ̃ do bi kuweeu ŋɑ, nŋui í jɛ inɛ ɑnkɑ̃ɑnyi iyi ì kpɑ ŋɑ. Ikui inɛ dee dee ŋɑu bɛ fei, hɑi Abɛli hee ku koo si Zɑkɑri, iŋɛi ɑɑ yɛ ijuukpɑ̃ɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ntɔ ntɔ, ǹ wɑ n sɔ̃ ŋɛi, ijuukpɑ̃i mii ŋɑu bɛ fei si inɛi nnyi ŋɑu ihɛ̃i ɑ́ bɑɑ ku jɛ si. ");
INSERT INTO mkl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesu í ni, iŋɛ inɛi Zeruzɑlɛmu ŋɑ, iŋɛ iyi ì yɑ kpɑ wɑlii ŋɑ nɔ i tɑ ɑmɑ ɑbɛi Ilɑɑɔ̃ ŋɑ mɔ kutɑ i kpɑ ŋɑ ŋɑ. Isɛ fɛloi ǹ yɑ n bi n tɔtɔɔ ŋɛ si ɑbɛm bɛi ɑjɛɛ í yɑ tɔtɔɔ ɑmɑɛ ŋɑ si ikpɑɛ, ɑmmɑ i kù jɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wee nsɛi Ilɑɑɔ̃ ɑ́ fũ nŋɛ kpɑsɛ̃ nŋɛ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, hɑi nsɛi i kɑɑ yɛm mɑ́ ŋɑ í ɡbe hee ɑjɔ iyi ɑɑ ni ŋɑ, Ilɑɑɔ̃ ku weeɑ inɛ iyi wɑ nɑɑ do irii Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ŋɔi Jesu í fitɑ hɑi kpɑsɛ̃i Ilɑɑɔ̃. Iyi wɑ nɛ ŋɔi mɔcɔɛ ŋɑ ɑ̀ koo ɑ̀ bɑɑ ɑ̀ nyisiɛ bɛi ɑ̀ mɑ kpɑsɛ̃i Ilɑɑɔ̃u do ileɛ ŋɑ sɑ̃ɑ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ŋɔi í sɔ̃ ŋɑ í ni, ì wɑɑ yɛ mii ŋɑu bɛ fei ŋɑ yɑ. Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, kutɑ bɑɑ ɑkɑ̃ kɑɑ nɑɑ ku mɑɑ lesi njɛ bɛ mɑ́, ɑɑ kɛkɛɛ mbɛ fei. ");
INSERT INTO mkl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesu í koo í bubɑ iri kutɑi Olivie. Ŋɔi mɔcɔɛ ŋɑ ɑ̀ bɔ bi tɛɛ ɑŋɑ duusɔ̃ɔ ɑ̀ beeɛ ɑ̀ ni, sɔ̃ wɑ wɑɑti iyi mii nɔu bɛ ɑ́ ce. Nyindɑ yoomɑi ɑ́ nyisi kunyiɛ wɑ do wɑɑtii ɑnkɑ̃ɑnyi. ");
INSERT INTO mkl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nɔ Jesu í jɛ nŋɑ í ni, i ce lɑɑkɑi ŋɑ inɛ ɡɔ ku mɑɑ̀ nɑɑ ku dĩ iju nŋɛ, ");
INSERT INTO mkl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","domi inɛ ŋɑ iyi ɑɑ nɑ ɑ mɑɑ nɑɑ ɑkɑ̃ ɑkɑ̃ ɑ mɑɑ ni ɑŋɑi ɑ̀ jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu ɑɑ kpɔ. Aɑ dĩ ijui inɛ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nɔ ɑɑ mɑɑ ɡbɔ ibɑi iɡũ ɑmɛɛ ɑmɛɛ do jĩijĩ ŋɑ. I mɑɑ̀ jɔ̀ ku dɑ ziɡi nŋɛ, domi í ɡbe mii ŋɑu bɛ fei ku ce. Ammɑ kù jɛ wɑɑtii ɑnkɑ̃ɑnyiu bɛ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dimi ɡɔ ŋɑ ɑɑ yɑ nɑ ɑ mɑɑ jɑ do dimi mmu ŋɑ. Ilɑɑlu ɡɔ ŋɑ mɔ ɑɑ mɑɑ jɑ do ilɑɑlu mmu ŋɑ. Nɔ ilɛ ɑ́ yɑyɑ si ilu ɡɔ ŋɑ, nɔ ɑri ɑ́ ce. ");
INSERT INTO mkl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Inɛ nŋu bɛ fei ɑ́ yɛi bɛi ɑrɑ kuro sintei bɑ̃ɑsĩ ku bɛi ku bí. ");
INSERT INTO mkl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Si wɑɑti nŋu, ɑɑ dɑsi ŋɛ si ɑwɔi inɛ ŋɑ ɑ kpɑ̃ ŋɛ iju, ɑɑ kpɑ ŋɛ mɔm. Dimi fei ɑ́ cé ŋɛi nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wɑɑti bɛɛbɛ, inɛ nkpɔ ɑ́ nyiò ɑnyi, ɑɑ mɑɑ zɑmbɑ njɛ nɔ ɑ cé njɛ. ");
INSERT INTO mkl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wɑlii ibo nkpɔ ŋɑi ɑɑ nɑ ɑ nɑɑ ɑ mɑɑ wɑ inyii itĩi inɛ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lɑɑlɔ ku ce ɑ́ kɔ̃ɔsi hee ku jɔ̀ inɛ nkpɔ kɑɑ nɛ kubii kpɑɑsi ŋɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ammɑ inɛ iyi í temuɑ hee kɔɔɛ ɑ́ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aɑ wɑɑzo lɑɑbɑɑu jiidɑi bommɑi Ilɑɑɔ̃u si ɑndunyɑ fei ku bɑ dimi fei ku ɡbɔɔ, ɑndunyɑ ku bɛi ku kpɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesu í ni, wɑlii Dɑniɛli í fɔ idei mii lɑɑlɔ ɡɔ wo iyi ɑ́ riisi kpɑsɛ̃i Ilɑɑɔ̃. Nŋui ɑɑ yɛ ŋɑ í wɑ si inyɑ iyi í jɛ ti Ilɑɑɔ̃. Inɛ iyi wɑ cio idei mii lɑɑlɔu, ku ce lɑɑkɑi ku ɡbɔɔ sɑ̃ɑ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Wɑɑti bɛɛbɛ inɛ ŋɑ iyi ɑ̀ wɑ ilɛi Zudee ɑ sɑ ɑ bɔ iri kutɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nɔ inɛ iyi í wɑ ɑntɑi ile sikifɑ, bii í kitɑ ilɛ ku bɑ ku sɑ ku mɑɑ̀ bɔ nɡɔɡɔ ku so inɔ ileɛ. ");
INSERT INTO mkl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nɔ inɛ mɔ iyi í wɑ iko ku mɑɑ̀ nyi kpɑsɛ̃ koo so kumbooɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wɑɑti bɛɛbɛ wɑhɑlɑi bɑ̃ɑsĩ ŋɑ do ɑyɑwo ŋɑ ɑ́ cɑɑ mɔm. ");
INSERT INTO mkl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","I ce kutɔɔ ŋɑ ku bɑ wɑɑtii kusɑu ku mɑɑ̀ nɑ ku jɛ sukui tũtũ wɑlɑkɔ ɑjɔi kusĩmi . ");
INSERT INTO mkl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ntɔ ntɔ, wɑɑti bɛɛbɛ wɑhɑlɑ nlɑ nlɑi ɑ́ nɑɑ iyi ɑ kù yɛ dimiɛ hɑi sintei ɑndunyɑ hee do nnyi, nɔ ɑ kɑɑ kɑ yɛ dimiɛ mɑ́ hee do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bii Ilɑɑɔ̃ kù jilɛ si nŋu ku kɑye kukpɔi ɑjɔu wo inɛ ɡɔ kɑɑ wɛɛ. Ammɑ í kɑyeɛi nɑ irii inɛ ŋɑ iyi í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Wɑɑti bɛɛbɛ, bii inɛ ɡɔ í sɔ̃ ŋɛ í ni, i cɔ inɛ iyi Ilɑɑɔ̃ í cicɑu í wɑ ihɛ̃, wɑlɑkɔ inɛ mmu ɡɔ ku ni, í wɑ ihɔ̃, i mɑɑ̀ dɑsi lɑfɛ̃ɛ nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Inɛ ɡɔ ŋɑ ɑɑ nɑ ɑ nɑɑ ɑkɑ̃ ɑkɑ̃ ɑ mɑɑ ni ɑŋɑi ɑ̀ jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu wɑlɑkɔ ɑ ni ɑŋɑi ɑ̀ jɛ wɑlii ŋɑ ɑmmɑ iboi. Aɑ mɑɑ ce dobu dobu do mɑɑmɑɑke ŋɑ ku bɑ ɑ dĩ hee do ijui inɛ ŋɑ iyi Ilɑɑɔ̃ í cicɑu bii ɑɑ yɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nɑ ŋɔi í jɔ̀ ǹ wɑ n sɔ̃ ŋɛ fei ndɛɛ do njumɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nɑ nŋu, bii ɑ̀ nɑ ɑ̀ sɔ̃ ŋɛ ɑ̀ ni, inɛ iyi Ilɑɑɔ̃ í cicɑu í wɑ ɡbɑbuɑ, i mɑɑ̀ koo. Wɑlɑkɔ bii ɑ̀ sɔ̃ ŋɛ ɑ̀ ni, wɑ mɑnji ilɑɑwɑ, i mɑɑ̀ dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Si bɛi kuŋɔi ijĩ í yɑ mɑ́ inyɑ hɑi nunui dɑɑkɔ hee ku bɔ nunui ɑlɛ ɑnu ɑkɑ̃, bɛɛbɛ mɔi kunɑɑi ɑmu Amɑi Amɑnɛ ɑ́ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tenɡi bii iku í wɑ, bɛi yembeeku ŋɑ ɑ̀ yɑ tɔtɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesu í ni, si ɑnyii wɑhɑlɑu ɡbɑkɑ̃, nunu ɑ́ kuku inyɑi, nɔ cukpɑ mɔ kɑɑ mɑ́ inyɑ mɑ́, ɑndɑiyɑ ŋɑ ɑɑ cuku wɑ hɑi lele nɔ ɡbuɡbɑ̃i lele ŋɑ ɑ yɑyɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wɑɑti bɛɛbɛ nyindɑi Amɑi Amɑnɛ ɑ́ fitɑ lelei Aɔ̃. Nɔ dimii ɑndunyɑ ŋɑ fei ɑɑ le ɑwɔ si iri ɑ mɑɑ kpɑtɑ. Aɑ yɛ ɑmu Amɑi Amɑnɛ ǹ wɑ n nɑɑ si kudũi ijĩ do ɡbuɡbɑ̃ nlɑ nlɑ do ɑmboe. ");
INSERT INTO mkl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kɑ̃ɑkɑ̃ɑkĩ nlɑ nlɑ ɑ́ dɔ̃ ɑnu nɔ n bɛ ɑmɑlekɑm ŋɑ wɑ si ɑndunyɑ ɡontɑ mɛɛu. Aŋɑi ɑɑ tɔtɔɔ inɛ ŋɑ iyi ǹ cicɑ si ɑndunyɑu fei. ");
INSERT INTO mkl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesu í ni, i cɔ mii iyi jĩi ndii fiɡi wɑ kɔ ŋɛ si ŋɑ. Bii ì nɑ ì yɛ ɑmɑɑwɔɛ ŋɑ ɑ̀ sinti ku wu wuɑ kpɔtɔɔ, ì yɑ mɑ̀ iyi ɑtɛ í mɑɑi wɑ mbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bɛɛbɛ mɔi, bii ì yɛ mii ŋɑu bɛ fei wɑ ce, i mɑ̀ ŋɑ iyi kubɑɑi ɑmu Amɑi Amɑnɛ kɑɑ kpɛ mɑ́, ɑjɔu í mɑɑi wɑ mɔm. ");
INSERT INTO mkl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, kù jɛ inɛi nsɛi ŋɑ feii ɑɑ ku ideu ku bɛi ku ce. ");
INSERT INTO mkl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lele do ilɛ fei ɑ́ nɑ ku tɑ̃, ɑmmɑ idem ŋɑ ɑ kɑɑ tɑ̃ pɑi. ");
INSERT INTO mkl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jesu í sɔ̃ ŋɑ mɑ́ í ni, inɛ kɑ̃mɑ kù mɑ̀ wɑɑtiu hee mɑ́ jɛ ɑjɔ iyi mii ŋɑu ɑ́ ce, bɑɑ ɑmɑlekɑ ŋɑ iyi ɑ̀ wɑ lele, bɑɑ ɑmu Amɑu, í ɡbe Ilɑɑɔ̃ Bɑɑbɑ nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Si bɛi í ce si wɑɑtii Noweeu, bɛɛbɛ mɔi ɑ́ ce si wɑɑti iyi ɑmu Amɑi Amɑnɛ ɑn nyi wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hee kukɔ̃i inyi nlɑu ku mɑɑ nɑɑ, inɛ ŋɑ ɑ̀ wɑɑ jɛ, ɑ̀ wɑɑ mɔ, ɑ̀ wɑɑ ce ɑbɔdɔ̃ ŋɑ, ɑ̀ wɑɑ muɑ ɑmɑ nŋɑ ŋɑ mɔkɔ hee í koo í to si ɑjɔ iyi Nowee í koo í lɔò ɑkɔi inyiu. ");
INSERT INTO mkl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A kù wɑɑ lɑsɑbu do wɑhɑlɑ dimi bɛɛbɛ hee í to kukɔ̃i inyi nlɑu í jɛ ŋɑ fei. Bɛɛbɛ mɔi ɑ́ jɛ si wɑɑti iyi ɑmu Amɑi Amɑnɛ ɑn nyi wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Si wɑɑti nŋu, ɑmɑnɛ minji ɑ́ wɑ iko nɔ ɑɑ so inɛ ɑkɑ̃ ɑ jɔ̀ inɛ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Inɑɑbo minji ɑ́ mɑɑ lɔlɔ, ɑɑ so inɛ ɑkɑ̃ ɑ jɔ̀ inɛ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nɑ nŋu, i wɛɛò sɔɔlu ŋɑ, domi i kù mɑ̀ ɑjɔ iyi Lɑfɛ̃ɛ nŋɛ ɑ́ nyi wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","I ɡbɔ iyi ihɛ̃ mɑ́ ŋɑ. Bii ilu kpɑsɛ̃ í mɑ̀ idũ zɑkɑ iyi ile ɑ́ nɑɑ, ɑ́ wɔ njoo nɔ ku ɡɑnjiɛ ku lɔ kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nɑ nŋu, iŋɛ mɔ, i wɛɛò sɔɔlu ŋɑ, domi ɑmu Amɑi Amɑnɛ ɑn nyi wɑ si wɑɑti iyi i kù wɑɑ tɑmɑɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Í sɔ̃ ŋɑ mɑ́ í ni, yooi í jɛ ɑmɑɑcɛ ilu nɑɑnɛ iyi í nɛ lɑɑkɑi. Lɑfɛ̃ɛi í jɛ inɛ iyi ilu kpɑsɛ̃ ɡɔ í kpe í so ɑmɑɑcɛ kpɑɑsiɛ ŋɑ í dɑɑ si ɑwɔ ku mɑɑ cɔ ŋɑ ku nɑ ŋɑ ijɛ si bɛi í jɔ. ");
INSERT INTO mkl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Inɔ didɔ̃i ɑ́ jɛ ti ɑmɑɑcɛu bii lɑfɛ̃ɛɛ í bɑ̀ɑ í nɑɑ í bɑ́ɑ wɑ ce bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ntɔ ntɔ, lɑfɛ̃ɛu ɑ́ dɑɑ ɑmɑɑcɛu mii ndɛɛ fei si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ammɑ bii í jɛ ɑmɑɑcɛ lɑɑlɔi, ɑ́ lɑsɑbui ku ni, lɑfɛ̃ɛm kɑɑ bɑɑ ńyɑ mɑ́, ");
INSERT INTO mkl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nɔ ku dede ku mɑɑ cɑ̃ ɑmɑɑcɛ kpɑɑsiɛ ŋɑ nɔ ku mɑɑ jɛ ku mɑɑ mɔ do woo mɔ ɑtɛ̃ ŋɑ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bɛɛbɛi, lɑfɛ̃ɛu ɑ́ nɑ ku bɑɑ si ɑjɔ iyi kù wɑɑ cɔ kpɑ̃ɑɛ, do si wɑɑti iyi kù wɑɑ tɑmɑɑ, ");
INSERT INTO mkl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","nɔ ɑ́ kpɑ̃ɑ iju jiidɑ jiidɑ, nɔ nŋu do ilu muɑfiti ŋɑu fei wɑhɑlɑ nŋɑ ɑ́ jɛ inyɑ ɑkɑ̃. Tenɡi bɛi ɑ́ le ɑwɔ si iri ku mɑɑ kpɑtɑò. ");
INSERT INTO mkl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesu í ni, ɑjɔ iyi ɑn nɑɑ n jɛ bommɑm ɑ́ yɛi bɛi fɑɑjii mudɛ̃ɛ mɛɛwɑ ɡɔ ŋɑ iyi ɑ̀ so fitilɑ nŋɑ ŋɑ ɑ̀ bɔ mɔkɔ titɔ̃ ku ko. ");
INSERT INTO mkl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Si inɔ nŋɑ ɑmɑnɛ miu í jɛ ilu lɑɑkɑi, ɑmɑnɛ miu mɔ kù nɛ lɑɑkɑi. ");
INSERT INTO mkl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mudɛ̃ɛ miu hɑi nɛ lɑɑkɑi ŋɑu ɑ̀ so fitilɑ nŋɑ ŋɑ nɔ ɑ kù so ikpo kosĩɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ammɑ ilu lɑɑkɑi ŋɑu ɑ̀ so fitilɑ nŋɑ ŋɑ do ikpo kosĩɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wee mɔkɔ titɔ̃u kù to wɑ ńyɑ. Si bɛi wɑ kpɛ, ŋɔi mudɛ̃ɛ mɛɛwɑ ŋɑu ɑ̀ siiko ɑ̀ wɑɑ sĩ njoo. ");
INSERT INTO mkl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hee zɑkɑi lɑjɑ ŋɔi ɑ̀ ɡbɔ ɑnu ku dɔ̃i inɛ ŋɑ. À wɑɑ ni, mɔkɔ titɔ̃u wee wɑ to wɑ, i dede kɑ kòo. ");
INSERT INTO mkl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ŋɔi mudɛ̃ɛ mɛɛwɑ ŋɑu ɑ̀ jĩ ɑ̀ wɑɑ teese fitilɑ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hɑi nɛ lɑɑkɑi ŋɑu ɑ̀ tɔɔ inɛ ihɔ̃ ŋɑu ɑ̀ ni, i mu nwɑ ikpo domi fitilɑ nwɑ ŋɑ ɑ̀ wɑɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ŋɔi ilu lɑɑkɑi ŋɑu ɑ̀ ni, ɑɑwo, kɑɑ to ɑwɑ fei. I koo i rɑ tu ŋɛ ɡbɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Iyi ɑ̀ bɔ ikpou ku rɑ ŋɔi mɔkɔ titɔ̃u í to wɑ. Inɛ nɡu ŋɑ iyi ɑ̀ ce sɔɔlu jiidɑ ŋɑu ɑ̀ tooɛ ɑ̀ lɔ bi ku ce ɑbɔdɔ̃u nɔ ɑ̀ cĩmbo ɡɑmbou. ");
INSERT INTO mkl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Si ɑnyiɛ ŋɔi woo bɔ ikpo ku rɑ ŋɑu mɔ ɑ̀ to wɑ, ɑ̀ wɑsi ku dɔ̃ ɑnu ɑ̀ wɑɑ ni, lɑfɛ̃ɛ, lɑfɛ̃ɛ, cĩ nwɑ ɡɑmbo. ");
INSERT INTO mkl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ammɑ mɔkɔ titɔ̃u í ni, ntɔ ntɔ, n kù mɑ̀ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ŋɔi Jesu í ni mɑ́, to, nɑ nŋu, i mɑɑ cɔ kpɑ̃ɑ ŋɑ domi i kù mɑ̀ ɑjɔ iyi ɑn nyi wɑ ŋɑ hee mɑ́ jɛ wɑɑtiu. ");
INSERT INTO mkl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesu í sɔ̃ ŋɑ mɑ́, í ni, bommɑi Ilɑɑɔ̃ í yɛi mɑ́ bɛi fɑɑjii mɔkɔ ɡɔ iyi wɑ bi ku bɔ ilu koo kpɛ bɛ. Nɔ í kpe ɑmɑɑcɛɛ ŋɑ í so ɑmɑniɛ fei í dɑ nŋɑ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Í nɑ inɛ ɑkɑ̃ fiɑi wurɑ kpɛkɛlɛ nlɑ miu, inɛ ɑkɑ̃ mɔ minji, inɛ mɛɛtɑsiɑu mɔ ɑkɑ̃, í nɑ ɑŋɑ feii si bɛi ɡbuɡbɑ̃i inɛ fei í to, í bɛi í nɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ŋɔi ɡbɑkɑ̃ ɑmɑɑcɛ iyi ɑ̀ nɑ fiɑ kpɛkɛlɛ miuu í so fiɑu wɑ ceò sĩɑ, nɔ í bɑ ribɑ miu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bɛɛbɛ mɔi inɛ iyi ɑ̀ nɑ minjiu mɔ, í bɑ ribɑ minji mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ammɑ inɛ iyi ɑ̀ nɑ ɑkɑ̃u í koo í tu isɑi í sinɡɑ fiɑi lɑfɛ̃ɛu. ");
INSERT INTO mkl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Si bɛɛbɛ ɑjɔ í koo wɑ bɑɑ ŋɔi lɑfɛ̃ɛi inɛ ŋɑu í bɑɑ nɔ í kpe ŋɑ ɑ nɑ ɑ sisiɑ nŋu bɛi ɑ̀ ceɑ fiɑu. ");
INSERT INTO mkl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Amɑɑcɛ iyi í nɑ fiɑ kpɛkɛlɛ miuu í nɑɑò miu mmuɛ wɑ mɑ́, nɔ í sɔ̃ɔ í ni, lɑfɛ̃ɛ, fiɑ kpɛkɛlɛ miu iyi ì nɑm nɔu n ceò sĩɑ hee ǹ bɑ ribɑ miu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ŋɔi lɑfɛ̃ɛɛ í sɔ̃ɔ í ni, í sĩɑ, ɑwɔu ɑmɑɑcɛ jiidɑ ilu nɑɑnɛi. Si mii keekeu ihɛ̃ ǹ yɛ iyi ì jɛ ilu nɑɑnɛ, nɑ nŋu, ɑn dɑɑɛ mii nlɑ si ɑwɔ. Nɑɑ wɑ kɑ jɛ jinɡɑu. ");
INSERT INTO mkl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Inɛ iyi í nɑ kpɛkɛlɛ minjiu mɔ í nɑɑ í ni, lɑfɛ̃ɛ, fiɑ kpɛkɛlɛ minji iyi ì nɑm nɔu, ǹ bɑ ribɑ minji mɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nɔ lɑfɛ̃ɛɛ í ni, í sĩɑ, ɑwɔu ɑmɑɑcɛ jiidɑ ilu nɑɑnɛi. Si mii keekeu ihɛ̃ ǹ yɛ iyi ì jɛ ilu nɑɑnɛ, nɑ nŋu, ɑn dɑɑɛ mii nlɑ si ɑwɔ. Nɑɑ wɑ kɑ jɛ jinɡɑu. ");
INSERT INTO mkl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Si ɑnyii nŋu ŋɔi ɑmɑɑcɛ iyi í nɑ kpɛkɛlɛ ɑkɑ̃u mɔ í nɑɑ í ni, lɑfɛ̃ɛ, ǹ mɑ̀ iyi ɑwɔu inɛ ku ɡɑɑbui. Bii i kù ɡbɛ̃ bɛi ì yɑ dɑ, nɔ tenɡi bii i kù fɑ̃ dimi, bɛi ì yɑ mu. ");
INSERT INTO mkl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Njoi nŋu dei í mum bɛ, nɔ ǹ koo ǹ si fiɑɛu ilɛ. To, fiɑɛ wee. ");
INSERT INTO mkl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ŋɔi lɑfɛ̃ɛɛu í sɔ̃ɔ í ni, ɑwɔu ɑmɑɑcɛ yɑɑmɔ ilu ikɑi, ɑwɔi ì mɑ̀ iyi ǹ yɑ n dɑ bɑɑ bii n kù ɡbɛ̃, nɔ bɛi n kù fɑ̃ dimi ǹ yɑ n mui. ");
INSERT INTO mkl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","To, iyi ì mɑ̀ bɛɛbɛ wo, ɑɑ nɑ inɛ ɡɔ fiɑm nɔui, nɔ i dɑɑ si inyi. Bii ì ce bɛɛbɛ wo ɑn yɛ ndom do ribɑɛ fei wɑɑti iyi ǹ bɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Si ɑnyiɛ ŋɔi í sɔ̃ ɑmɑɑcɛ kpɑɑsi ŋɑu í ni, i ɡbɑ fiɑ kpɛkɛlɛ ɑkɑ̃u i nɑ inɛ iyi í nɛ mɛɛwɑu, ");
INSERT INTO mkl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","domi inɛ iyi í nɛ, nŋui ɑ̀ yɑ kɔ̃ɔɑ si ku bɑ iyi í nɛu ku kɔ̃ɔsi mɑ́. Ammɑ inɛ iyi kù nɛ, bɑɑ keeke iyi í nɛu mɑ́ ɑ̀ yɑ ɡbɑɑi. ");
INSERT INTO mkl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Amɑɑcɛ nfeu mɔ, i soo i nyɔɔ ɑnɡule si ilu kuku tenɡi bii inɛ ŋɑ ɑɑ lesi ɑwɔ si iri ɑ kpɑtɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ŋɔi Jesu í ni mɑ́, si wɑɑti iyi ɑmu Amɑi Amɑnɛ ɑn nɑɑ do ɑmboem do ɑmɑlekɑ ŋɑu fei, ɑn bubɑ si bɑtɑi bommɑ ilu ɑmboem. ");
INSERT INTO mkl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dimii ɑndunyɑ fei ɑ́ tɔtɔɔ si wɑjum, nɔ ɑn fɛɛfɛ inɛ ŋɑ bɛi woo deɡbe í yɑ fɛɛfɛ ɑnɡudɑ̃ do iwo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","An jilɛ inɛ dee dee ŋɑu ikpɑ ɑwɔ njɛm, inɛ lɑɑlɔ ŋɑu mɔ ikpɑ ɑwɔ cɑnɡɑm. ");
INSERT INTO mkl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wɑɑti bɛɛbɛ ɑmu ilɑɑluu ɑn sɔ̃ inɛ ŋɑ iyi ɑ̀ wɑ ɑwɔ njɛm n ni, i nɑɑ wɑ ŋɑ, iŋɛ iyi í bɑ kuweei Bɑɑm. I nɑɑ i bubɑ si bommɑ iyi ɑ̀ ce nŋɛ sɔɔluɛ hɑi wɑɑtii kusintii ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bommɑu tu ŋɛi si nɑ iyi í jɔ̀ si wɑɑti iyi ɑri wɑ kpɑm, ì muum ijɛ ǹ jɛ ŋɑ. Nɔ si wɑɑti iyi ɑɡbɛ wɑ kpɑm mɑ́, ì muum inyi ǹ mɔ ŋɑ. Nɔ si wɑɑti iyi ǹ jɛ inɛ njoo ì ɡbɑm si kpɑsɛ̃ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nɔ si wɑɑti iyi ǹ wɛɛ bɑsĩ ì bii ɑnyim ŋɑ. Nɔ iyi ǹ wɑ n ce bɔ̃ɔ ì ɡbɔɔm ŋɑ. Nɔ si wɑɑti iyi ǹ wɑ ile piisɔ̃ɔ ì yɑ nɑɑ ku cɔm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Wɑɑti nŋu, inɛ dee dee ŋɑu ɑɑ jɛɛm ɑ ni, Lɑfɛ̃ɛ, wɑɑti yoomɑi ɑ̀ yɛ ɑri wɑ kpɑɛ nɔ ɑ̀ nɑɛ ijɛ ì jɛ wɑlɑ ɑɡbɛ wɑ kpɑɛ ɑ̀ nɑɛ inyi ì mɔ. ");
INSERT INTO mkl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wɑɑti yoomɑi ɑ̀ yɛ ì jɛ inɛ njoo ɑ̀ ɡbɑɛ si kpɑ̃sɛ nwɑ, wɑlɑkɔ ɑ̀ yɛɛ bɑsĩ nɔ ɑ̀ bii ɑnyiɛ. ");
INSERT INTO mkl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mɑ̀ wɑɑti yoomɑi ɑ̀ yɛ ì wɑɑ ce bɔ̃ɔ wɑlɑkɔ ì wɑ ile piisɔ̃ɔ nɔ ɑ̀ nɑɑ ku cɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Amu ilɑɑluu ɑn jɛ nŋɑ n ni, ntɔ ntɔ, bii ì ceɑ inɛ ɑkɑ̃i inɛm ŋɑ iyi ɑ̀ kere ɑ̀ re ŋɑu ihɛ̃ bɛɛbɛ ŋɑ, ɑmui ì ceɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Si ɑnyii nŋu, n bɛi n sɔ̃ inɛi ɑwɔ cɑnɡɑm ŋɑu mɔ n ni, i fɑ ɑrɑ nŋɛ hɑi kɔkɔm, iŋɛ iyi Ilɑɑɔ̃ í ceekpe. I bɔ si inɑ iyi ci yɑ ku, iyi ɑ̀ koɑ Seetɑm do ɑmɑlekɑɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aɑ lɔ si inɑ ŋɑi si nɑ iyi í jɔ̀ wɑɑti iyi ɑri wɑ kpɑm wo i kù muum ijɛ n jɛ ŋɑ. Nɔ wɑɑti iyi ɑɡbɛ wɑ kpɑm i kù muum inyi n mɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wɑɑti iyi ǹ jɛ inɛ njoo i kù ɡbɑm si kpɑsɛ̃ nŋɛ ŋɑ. Nɔ si wɑɑti iyi ǹ wɛɛ bɑsĩ i kù bii ɑnyim ŋɑ. Iyi ǹ wɑ n ce bɔ̃ɔ nɔ ǹ wɑ ile piisɔ̃ɔ, i ci yɑ nɑɑ ku cɔm ŋɑ mɔm. ");
INSERT INTO mkl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aŋɑ mɔ ɑɑ jɛɛm ɑ ni, Lɑfɛ̃ɛ, wɑɑti yoomɑi ɑ̀ yɛ ɑri wɑ kpɑɛ, wɑlɑkɔ ɑɡbɛ, wɑlɑkɔ í jɛ inɛ njoo, wɑlɑkɔ bɑsĩ, wɑlɑkɔ si bɔ̃ɔ, wɑlɑkɔ ile piisɔ̃ɔ nɔ ɑ kù sobiɛ. ");
INSERT INTO mkl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","An jɛ nŋɑ n ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, si bɛi i kù ceɑ inɛ ɑkɑ̃i inɛ ŋɑ iyi ɑ̀ kere ɑ̀ re ŋɑu ihɛ̃ bɛɛbɛ, ɑmui i kù ceɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nɑ nŋu, ɑɑ yɛ ijuukpɑ̃ ŋɑi si inɑ iyi ci yɑ ku. Ammɑ inɛ dee dee ŋɑu ɑɑ lɔ si kuwɛɛ iyi ci yɑ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iyi Jesu í fɔ ide ŋɑu fei í tɑ̃, ŋɔi í sɔ̃ mɔcɔɛ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ì mɑ̀ ŋɑ iyi ɑjɔ minjii í ɡbe kɑ jɛò jinɡɑui Iku ku kuɑ. Nɔ wɑɑti bɛɛbɛi ɑɑ dɑsi ɑmu Amɑi Amɑnɛ si ɑwɔi inɛ ŋɑ ɑ kpɑm si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wɑɑti iyi Jesu wɑ sɔ̃ mɔcɔɛ ŋɑ ideu, inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do inɛ nɡbo ŋɑu ɑ̀ tɔtɔɔ kɑbɑi Kɑifu woo wee nlɑu. ");
INSERT INTO mkl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bɛi ɑ̀ wɑɑ busi njɛ bɛ́i ɑɑ ce ɑ bɑ ɑ mu Jesu do bisi ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ammɑ ɑ̀ wɑɑ ni, kù sĩɑ ku jɛ si ɑjɔi jinɡɑuu ku bɑ hoyɑ hoyɑ ku mɑɑ̀ dede si zɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesu í wɑ Betɑni kpɑsɛ̃i Simɔɔ iyi í tɑko í ce bɔ̃ɔi dintɛu, ");
INSERT INTO mkl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ŋɔi ɑbo ɡɔ í nɑɑ bi tɛɛ wɑɑti iyi ɑ̀ wɑɑ jɛ. Wɑ mu ɑmɑ cɑkɑ ku sĩɑ ɡɔ iyi í nɛ tulɑre ku nɛ fiɑ ɡɔ, nɔ í fɑ̃si tulɑreu si irii Jesu. ");
INSERT INTO mkl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iyi mɔcɔ ŋɑu ɑ̀ yɔɔ, ŋɔi idɔ nŋɑ í kɔ̃ ɑ̀ ni, nɑ mii í ce ɑbou í koo í ce ɑsɔɔi tulɑreu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aɑ kɑ tɑɑi wo fiɑ nkpɔ nkpɔ kɑ kpɛ̃ɑ ilu ɑre ŋɑ fiɑu. ");
INSERT INTO mkl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iyi Jesu í ɡbɔ ɑ̀ wɑɑ fɔ bɛɛbɛ ŋɔi í bee ŋɑ í ni, nɑ mii í ce ì wɑɑ yɛ tɑɑlei ɑbou ŋɑ. Mii jiidɑi í ceem bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ntɔ ntɔ, ilu ɑre ŋɑ ɑɑ mɑɑ wɛɛ do iŋɛ wɑɑti kɑ̃mɑ fei, ɑmmɑ ɑmu n kɑɑ n mɑɑ n wɛɛ do iŋɛ hee do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Abou í fɑ̃si ɑrɑm tulɑre do njumɑ ku ceò sɔɔlui kusim. ");
INSERT INTO mkl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ntɔ ntɔ, tenɡi bii inɛ ŋɑ ɑɑ koo ɑ mɑɑ wɑɑzo lɑɑbɑɑu jiidɑu si ɑndunyɑu fei, ɑɑ sisi ide iyi ɑbou ihɛ̃ í ce ɑ mɑɑ yeò ɡiɡiɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ŋɔi Zudɑsi Isikɑriɔti, inɛ ɑkɑ̃i mɔcɔ mɑɑteeji ŋɑu, í bɔ bi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu, ");
INSERT INTO mkl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","í bee ŋɑ í ni, mii ɑɑ muum ŋɑ bii ǹ dɑ nŋɛ Jesu si ɑwɔ. Nɔ ɑ̀ kɑ fiɑ isɔ fũfũ ɑrɑ kuntɑɑ ɑ̀ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hɑi wɑɑti bɛɛbɛi, Zudɑsi wɑ dɛ kpɑ̃ɑ bɛ́i ɑ́ ce ku zɑmbɑò Jesu ku nɑ inɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Si ɑjɔ sintei jinɡɑui Pɛ̃ɛ hɑi nɛ lefeeu mɔcɔi Jesu ŋɑu ɑ̀ nɑɑ ɑ̀ beeɛ ɑ̀ ni, iwoi ì bi kɑɑ ceeɛ sɔɔlui jinɡɑui Iku ku kuɑu. ");
INSERT INTO mkl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ŋɔi í jɛ nŋɑ í ni, i bɔ inɔ ilu bi wɑ̃ɑnɛ kɑsɑ i sɔ̃ɔ i ni, ɑmu Mɛɛtu ǹ ni, wɑɑtim í to. Bi tɛɛi ɑn jɛ jinɡɑui Iku ku kuɑ do mɔcɔm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nɔ mɔcɔ ŋɑu ɑ̀ ce bɛi Jesu í sɔ̃ ŋɑ, ɑ̀ ce sɔɔlui jinɡɑuu. ");
INSERT INTO mkl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iyi ɑlɛ í lɛ Jesu do mɔcɔ mɑɑteeji ŋɑu ɑ̀ wɑɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wɑɑti iyi ɑ̀ wɑɑ jɛ ŋɔi Jesu í ni, ntɔ ntɔ, inɛ ɑkɑ̃ nŋɛ ɑ́ zɑmbɑm. ");
INSERT INTO mkl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ŋɔi inɔi mɔcɔ ŋɑu í fɔ ntɔ ntɔ, ɑ̀ wɑsi ku beeɛ ɑkɑ̃ ɑkɑ̃ ɑ̀ wɑɑ ni, isɑ kù jɛ ɑmu yɑ Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ŋɔi Jesu í jɛ nŋɑ í ni, inɛ iyi í ɡũsi pɛ̃ɛ si inɔ jɛɛ ɑwɑò ɑjɔ, lɑfɛ̃ɛi ɑ́ zɑmbɑm. ");
INSERT INTO mkl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Amu Amɑi Amɑnɛ ɑn ku si bɛi kukɔi idei Ilɑɑɔ̃ wɑ fɔ. Ammɑ inɛ iyi ɑ́ zɑmbɑm ɑ́ yɛ ijuukpɑ̃ nlɑ nlɑ. Á tiɑɑ inɛɛu bii í jɛ ɑ kù buu mɔm wo. ");
INSERT INTO mkl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zudɑsi iyi ɑ́ zɑmbɑɛu mɔ í so ide í ni, isɑ kù nɔ kù jɛ ɑmu yɑ Mɛɛtu. Nɔ Jesu í jɛɑɑ í ni, oo, ɑwɔi ɑɑ coo. ");
INSERT INTO mkl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wɑɑti iyi ɑ̀ wɑɑ jɛ, ŋɔi Jesu í so pɛ̃ɛ nɔ í sɑɑbu Ilɑɑɔ̃ titɑ̃ í bɛi í bububuɛ í nɑ mɔcɔɛ ŋɑu, í ni, iyi ihɛ̃i í jɛ ɑrɑm, i ɡbɑ i jɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Si ɑnyii nŋu, nɔ í so kɔɔfu si bii ɑ̀ dɑsi vɛ̃ɛ í sɑɑbu Ilɑɑɔ̃ nɔ í nɑ ŋɑ í ni, iyi ihɛ̃i í jɛ njɛm. Nŋui í jɛ nyindɑi ɑkɑbuu iyi Ilɑɑɔ̃ í dĩ do ɑmɑnɛ ŋɑ. An nikɑ̃ɛ nɑ irii inɛ nkpɔ ku bɑ n kpɑ idei dulum du ŋɑ. Iŋɛ fei, i mɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","An sɔ̃ ŋɛ, hɑi nnyi n kɑɑ n mɔ ɑtɛ̃ vɛ̃ɛ mɑ́ í ɡbe hee ɑjɔ iyi ɑwɑɛ ŋɑ fei ɑɑ kɑ mɔ vɛ̃ɛ titɔ̃ si bommɑi Bɑɑm. ");
INSERT INTO mkl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Si ɑnyiɛ ɑ̀ kɔ̃ iri ŋɑ nɔ ɑ̀ fitɑ ɑ̀ bɔ iri kutɑi Olivieu. ");
INSERT INTO mkl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, idũuyi mɔm, iŋɛ fei ɑɑ nyiò ɑnyi nɑ irim. Bɛ́i Ilɑɑɔ̃ í fɔ si kukɔi ideɛ, bɛɛbɛi ɑ́ ce. I ni, ɑ́ kpɑ woo deɡbeu nɔ ɑnɡudɑ̃ ŋɑu ɑ fɑnɡɑɑ bii fei. ");
INSERT INTO mkl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ammɑ ɑn jĩ hɑi si bɑlɛ nɔ n cuɑ nŋɛ n bɔ ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ŋɔi Piɛɛ í sɔ̃ɔ í ni, bɑɑ bii inɛ fei wɑ nyiò ɑnyi nɑ iriɛ, ɑmu n kɑɑ n nyiò ɑnyi pɑi. ");
INSERT INTO mkl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ŋɔi Jesu í sɔ̃ɔ í ni, ntɔ ntɔ, idũuyi mɔm, hee ɑjɛɛ ku mɑɑ kɔ, ɑɑ jɑ̃ isɛ ɡbɛɛtɑ i ni i kù mɑ̀m. ");
INSERT INTO mkl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ammɑ Piɛɛ í jɛɑɑ í ni, n kɑɑ n kɔsiɛ pɑi, bɑɑ bii í jɛ ɑn ku do ɑwɔ ɑjɔi. Nɔ mɔcɔ ŋɑu mɔ fei ɑ̀ fɔ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ŋɔi Jesu do mɔcɔɛ ŋɑ ɑ̀ bɔ inyɑ ɡɔ iyi ɑ̀ yɑ kpe Gɛsemɑnee. Iyi ɑ̀ to bɛ nɔ í sɔ̃ ŋɑ í ni, i bubɑ ihɛ̃ titɑ̃ ŋɑ n koo n ce kutɔɔ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ŋɔi í ɡbɑ̃ Piɛɛ do ɑmɑ minjii Zebedee ŋɑu ɑ̀ bɔ wɑju. Nɔ inɔ kufɔ í nɑɑ siɛ hee ɑrɑɛ fei í rɔ. ");
INSERT INTO mkl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ŋɔi í sɔ̃ ŋɑ í ni, inɔ kufɔ í nɑɑ sim nlɑ nlɑ hee wɑ bi ku kpɑm. I wɑ ihɛ̃, i bɑm njoo ku wɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iyi í fɔ bɛɛbɛ í tɑ̃, ŋɔi í bɔ wɑju keeke í koo í sɛɛbɑtɑ ilɛ wɑ ce kutɔɔ í ni, Bɑɑm, bii ɑ́ ce, jɔ̀ wɑhɑlɑu ihɛ̃ ku jĩim. Ammɑ do nŋu fei, ku mɑɑ̀ ti ku jɛ ti idɔɔbim, jɔ̀ idɔɔbiɛ ku ce. ");
INSERT INTO mkl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Si ɑnyiɛ ŋɔi í nyi wɑ bi mɔcɔ mɛɛtɑ ŋɑu í bɑ ŋɑ ɑ̀ wɑɑ sĩ njoo. Ŋɔi í bee Piɛɛ í ni, debɛi, i kù yɔkɔ i kù bɑm njoo ku wɔ bɑɑ lɛɛu ɑkɑ̃ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","I wɔ njoo nɔ i mɑɑ ce kutɔɔ ŋɑ ku bɑ i mɑɑ̀ dɑsi kulɛlɛi inɛ ŋɑ. Idɔi ɑmɑnɛ í bi, ɑmmɑ ɑrɑɛ í kuɑ ɡbuɡbɑ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nɔ í jĩò ŋɑ isɛ ɡbeejisiɑ mɑ́ í koo í ce kutɔɔ í ni, Bɑɑm, bii ì jɛ wɑhɑlɑu ihɛ̃ kɑɑ jĩim, bii í jɛ kù nɛ bɛi ɑ́ ce iyi n kù yɔɔi, jɔ̀ idɔɔbiɛ ku ce. ");
INSERT INTO mkl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iyi í ce kutɔɔ í tɑ̃ ŋɔi í nyi wɑ bi tu ŋɑ mɑ́ nɔ í bɑ ŋɑ ɑ̀ wɑɑ sĩ njoo mɑ́, domi njoo wɑ kpɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesu í jɔ̀ ŋɑ mɑ́, í koo í ce kutɔɔ isɛ ɡbɛɛtɑsiɑɛ si ide ɑkɑ̃u. ");
INSERT INTO mkl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nɔ í nyi wɑ bi tu ŋɑ mɑ́ í sɔ̃ ŋɑ í ni, ì sũ ì wɑɑ sĩmi ŋɑi hee nsɛi? I cɔ, wɑɑti í ɡbe keeke iyi ɑɑ mu ɑmu Amɑi Amɑnɛ ɑ dɑɑ ilu dulum ŋɑ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Inɛ iyi ɑ́ zɑmbɑm wɑ to wɑ. I dede kɑɑ kòo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iyi Jesu wɑ fɔ bɛɛbɛ ɡbɑkɑ̃, ŋɔi Zudɑsi, inɛ ɑkɑ̃i mɔcɔ mɑɑteeji ŋɑu í to wɑ. Zɑmɑɑ nlɑ ɡɔ wɑ tooɛ wɑ ɑ̀ wɑɑ mu tɑɑkubɑ ŋɑ do ɡolo ŋɑ. Inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do inɛ nɡbo ŋɑui ɑ̀ bɛ ŋɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wɑɑti iyi Zudɑsi í dɑsi idɔ nŋu ku zɑmbɑ Jesuu, í sɔ̃ inɛ ŋɑu nyindɑ ɡɔ iyi nŋu ɑ́ ce. Í ni, inɛ iyi ɑn koo n yɑ n bɑɑbɑɛ, Lɑfɛ̃ɛ mbɛ, i muu. ");
INSERT INTO mkl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hɑi Zudɑsi í to wɑ ɡbɑkɑ̃, í sɛkɛɛi si Jesu í ni, irei ì cɑɑlɛ, Mɛɛtu. Nɔ í bɑɑbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ŋɔi Jesu í sɔ̃ɔ í ni, kpɑɑsim, iyi ì nɑɑ ku ceu, coo. Nɔ inɛ ŋɑu ɑ̀ to Jesu ɑwɔ ɡbɑkɑ̃ ɑ̀ muu. ");
INSERT INTO mkl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ŋɔi inɛ ɑkɑ̃i mɔcɔi Jesu ŋɑu í yɔ tɑɑkubɑɛ í cɑfé itĩi ɑmɑɑcɛi woo wee nlɑi Ilɑɑɔ̃u í buu. ");
INSERT INTO mkl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ammɑ Jesu í sɔ̃ɔ í ni, sindo tɑɑkubɑɛ si ɑnkɔ̃ɔɛ. Inɛ iyi wɑ kpɑ inɛ do tɑɑkubɑ fei, tɑɑkubɑi ɑ́ nɑ ku kpɑ lɑfɛ̃ɛ mɔ. ");
INSERT INTO mkl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","I kù mɑ̀ iyi bii ǹ bi ɑn yɔkɔ n tɔɔ Bɑɑm, nɔ ɡbɑkɑ̃ ku sɑmbɑɑm ɑmɑlekɑ dubu nkpɔ nkpɔ wɑ ɑ nɑɑ ɑ sobim? ");
INSERT INTO mkl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ammɑ bii ǹ ce bɛɛbɛ, kukɔi idei Ilɑɑɔ̃ iyi í ni mii ŋɑu ihɛ̃ fei ɑ́ bɑm nii kɑɑ kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ŋɔi Jesu í bee zɑmɑɑu í ni, ɑmui ì nɑɑ ku mu bɛ ŋɑ do tɑɑkubɑ do ɡolo ŋɑ bɛi woo ce ile? Ǹ yɑ n wɑ si inɔ nŋɛ ɑjɔ fei n mɑɑ n kɔ inɛ ŋɑ si cio kpɑsɛ̃i Ilɑɑɔ̃, nɔ i kù mum ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ammɑ nŋu ŋɑu bɛ fei í cei ku bɑ ide iyi wɑlii ŋɑu ɑ̀ fɔ si tiɑi idei Ilɑɑɔ̃ ku kɔ̃. Ŋɔi mɔcɔ ŋɑu fei ɑ̀ jɔ̀ɔ ɑ̀ sɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Inɛ ŋɑ iyi ɑ̀ mu Jesuu ɑ̀ bɔòɛ bi Kɑifu woo wee nlɑi Ilɑɑɔ̃. Tenɡi bɛi woo kɔ inɛ ŋɑ si woodɑ ŋɑu do inɛ nɡbo ŋɑu ɑ̀ tɔtɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nɔ Piɛɛ í wɑ hee jĩijĩ wɑ too Jesu wɑ do ɑnyi hee í bɔ inɔ bɑntumɑi kpɑsɛ̃i woo wee nlɑu. Ŋɔi í bubɑ bɛ do woo deɡbe ɑndɛ koofɑ ŋɑu nɑ ku yɛò bɛi ideu ɑ́ kpɑò iri. ");
INSERT INTO mkl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wɑɑti nŋu inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do iɡbɛi woo kiiti ŋɑu fei ɑ̀ wɑɑ dɛ ɑ mɑ́ Jesu ide iyi ɑɑ yɛò tɑɑleɛ ku bɑ ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ammɑ ɑ kù bɑ ide iyi ɑɑ yɛò tɑɑleɛ bɑɑ do iyi ilu sɛɛdɑ ibo nkpɔ í nɑɑ í mɑ́ɑ ide fei. Si ɑnyii nŋu, ɑmɑnɛ minji ɡɔ ŋɑ ɑ̀ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","À ni, mɔkɔu ihɛ̃ í ni nŋu ɑ́ yɔkɔ ku lɛɡɛ kpɑsɛ̃i Ilɑɑɔ̃ nɔ si ɑfei ɑjɔ mɛɛtɑ nŋu ku mɑ mmuɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ŋɔi woo wee nlɑi Ilɑɑɔ̃u í dede í bee Jesu í ni, i kù wɑɑ ni ide ɡɔ? Ide mii inɛ ŋɑu ihɛ̃ ɑ̀ wɑɑ yɛò tɑɑleɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ammɑ Jesu wɑ cokoɛ. Ŋɔi woo wee nlɑu í sɔ̃ɔ í ni, do irii Ilɑɑɔ̃, fɔ bii ɑwɔu Amɑi Ilɑɑɔ̃ inɛ iyi Ilɑɑɔ̃ í cicɑui . ");
INSERT INTO mkl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ŋɔi Jesu í jɛɑɑ í ni, oo, ɑmui, si bɛi ì fɔ. Nɔ ǹ wɑ n sɔ̃ ŋɛi, ɑɑ yɛ ɑmu Amɑi Amɑnɛ ǹ wɑ n bubɑ ɑwɔ njɛi Ilɑɑɔ̃ ilu ɡbuɡbɑ̃ fei. Bɛɛbɛ mɔi ɑɑ nɑ i yɛm ŋɑ ɑjɔ ɑkɑ̃ n nɑɑ si kudũi ijĩ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ŋɔi woo wee nlɑu í ɡɑ ibɔɛ ku nyisiò idɔɔkɔ̃ɛ. Ŋɔi í ni, wɑ bu Ilɑɑɔ̃. A kù wɑɑ dɛ ilu sɛɛdɑ kɑ̃mɑ mɑ́. I ɡbɔ bɛi wɑ bu Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bɛirei ì yɛ ɑ ceɑ mɔkɔu ŋɑ. Ŋɔi ɑŋɑ fei ɑ̀ yɛ tɑɑleɛ ɑ̀ ni í to ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ŋɔi ɑ̀ wɑsi ku tu si wɑjui Jesu ɑntɔ nɔ ɑ̀ wɑɑ dɑɑ kutu, inɛ ɡɔ ŋɑ mɔ ɑ̀ wɑɑ sɑmbɑlɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nɔ ɑ̀ ni, ɑwɔ iyi ì wɑɑ kpe ɑrɑɛ inɛ iyi Ilɑɑɔ̃ í cicɑu, sɔ̃ wɑ inɛ iyi í cɑ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wɑɑti bɛɛbɛ Piɛɛ wɑ bubɑ bɑntumɑi kpɑsɛ̃u. Ŋɔi mudɛ̃ɛ woo ce icɛ ɡɔ í sɛkɛɛ siɛ wɑ í ni, ɑwɔ mɔ ì tɑko ì wɛɛ do Jesu inɛi Gɑlileeu. ");
INSERT INTO mkl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ammɑ í jɑ̃ si wɑjui ɑŋɑ fei í ni, n kù mɑ̀ iyi ì wɑɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Si ɑnyiɛ, nɔ í dede í bɔ ikpɑ ɑndɛ kɑbɑu. Ŋɔi mudɛ̃ɛ ɑmɑɑcɛ mmu ɡɔ í yɔɔ mɑ́, nɔ í sɔ̃ inɛ ŋɑ iyi ɑ̀ wɑ bɛu í ni, inɛɛu ihɛ̃ í tɑko í wɛɛ do Jesu inɛi Nɑzɑrɛtiu. ");
INSERT INTO mkl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ŋɔi Piɛɛ í jɑ̃ mɑ́ nɔ í ceekpe í ni, n kù mɑ̀ inɛɛu bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Iyi í kɔ̃ɔsi mɑ́, ŋɔi inɛ ŋɑ iyi ɑ̀ wɑ bɛu ɑ̀ sɛkɛɛ si Piɛɛ ɑ̀ ni, ntɔ ntɔ ɑwɔu inɛ ɑkɑ̃ nŋɑi. Ide ku fɔɛ wɑ nyisi iyi ɑwɔu inɛi Gɑlileei. ");
INSERT INTO mkl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ŋɔi í teese í ceekpe í ni, n kù mɑ̀ mɔkɔu. Bɛ ɡbɑkɑ̃ ɑjɛɛ wɑ kɔ. ");
INSERT INTO mkl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nɔ Piɛɛ í ye ɡiɡii ide iyi Jesu í sɔ̃ɔu wo í ni, hee ɑjɛɛ ku mɑɑ kɔ ɑɑ jɑ̃ isɛ ɡbɛɛtɑ i ni i kù mɑ̀m. Ŋɔi í fitɑ í koo wɑ kpɑtɑ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ŋɔi dɑɑdɑɑkɔ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do inɛ nɡbo ŋɑ fei ɑ̀ jilɔɔ si ɑŋɑ ɑ kpɑ Jesu. ");
INSERT INTO mkl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nɔ ɑ̀ dũu ɑ̀ koo ɑ̀ dɑɑ Pilɑti ilu ilɛu si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zudɑsi, nŋu iyi í zɑmbɑ Jesuu, í yɛ bɛi ɑ̀ yɛ tɑɑleɛ ɑ kpɑɑ, ŋɔi inɔɛ í fɔ. Nɔ í nyiò fiɑi isɔ fũfũ kuntɑɑu bi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do inɛ nɡbo ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Í sɔ̃ ŋɑ í ni, ǹ ce dulum si bɛi ǹ zɑmbɑ inɛ dee deeu ihɛ̃ ɑ kpɑɑ. Ammɑ ɑ̀ jɛɑɑ ɑ̀ ni, yoomɑi í yɛ wɑ. Í jɛ idei iriɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ŋɔi Zudɑsi í nyɔ fiɑu si kpɑsɛ̃i Ilɑɑɔ̃ bɛ í nɛɛ. Nɔ í koo í dɑsi kɔ̃ɔɛ ikũ lele í kpɑ ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu ɑ̀ tɑsi fiɑu ɑ̀ ni, bɛirei ɑɑ kɑ ceò fiɑu ihɛ̃. A kù nɛ kpɑ̃ɑ kɑ dɑsi kpɑkoi kpɑsɛ̃i Ilɑɑɔ̃ si nɑ iyi í jɔ̀ fiɑ iyi ɑ̀ sɑ̃ nɑ ɑ nikɑ̃ò njɛi inɛ ɡɔi. ");
INSERT INTO mkl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iyi ɑ̀ busi njɛ ɑ̀ tɑ̃, nɔ ɑ̀ so fiɑu ɑ̀ rɑò ikoi woo mɑ cɑkɑ ɡɔ, ɑ̀ ce bi ku si inɛ njoo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nɑ ŋɔi í jɔ̀ ɑ̀ yɑ kpe ikou ikoi njɛ bɑɑ nnyi. ");
INSERT INTO mkl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bɛɛbɛi idei Zeremii wɑliiu í ce si bɛi í ni, ɑ̀ so fiɑi isɔ fũfũ kuntɑɑu, fiɑ iyi inɛi Izirɛli ŋɑ ɑ̀ jɛsi ɑŋɑ ɑ sɑ̃ nɑ iriɛu, ");
INSERT INTO mkl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nɔ ɑ̀ rɑò ikoi woo mɑ cɑkɑu, si bɛi Aɔ̃ Lɑfɛ̃ɛ í dɑsim. ");
INSERT INTO mkl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ŋɔi ɑ̀ koo ɑ̀ leekĩ Jesu si wɑjui Pilɑti ilu ilɛu, nɔ í beeɛ í ni, ɑwɔi ì jɛ ilɑɑlui Zuifu ŋɑ? Nɔ Jesu í jɛɑɑ í ni, oo, si bɛi ì fɔ. ");
INSERT INTO mkl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Si ɑnyii nŋu, inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do inɛ nɡbo ŋɑu ɑ̀ wɑɑ mɑ́ɑ ide, nɔ kù ni nŋɑ ide kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ŋɔi Pilɑti í beeɛ í ni, i kù wɑɑ ɡbɔ ide ŋɑ iyi inɛ ŋɑ ɑ̀ fɔ ɑ̀ wɑɑ yɛò tɑɑleɛ bɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ammɑ Jesu kù jɛɑɑ bɑɑ ɡbɑkɑ̃ hee biti í muu. ");
INSERT INTO mkl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wee si jinɡɑui Iku ku kuɑ fei ilu ilɛu í yɑ jɔ̀ inɛi piisɔ̃ɔ ɑkɑ̃ iyi zɑmɑɑ í bii. ");
INSERT INTO mkl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wee, wɑɑti bɛɛbɛ inɛ ɡɔ í wɑ ile piisɔ̃ɔ bɛ, ɑ̀ yɑ kpoo Bɑrɑbɑɑ, nɔ inɛ fei í mɑ̀ɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ŋɔi í jɔ̀ iyi zɑmɑɑu í tɔtɔɔ, Pilɑti í bee ŋɑ í ni, yooi ì bi n jɔ̀ nŋɛ, Bɑrɑbɑɑ de, mɑ̀ Jesu iyi ɑ̀ yɑ kpe Kirisiu. ");
INSERT INTO mkl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Í fɔ bɛɛbɛi si nɑ iyi í jɔ̀ wɑ mɑ̀ sɑ̃ɑ sɑ̃ɑ iyi nɑ iɡui í jɔ̀ ɑ̀ dɑɑ nŋu Jesu si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wɑɑti iyi Pilɑti wɑ bubɑ bi ku ce kiitiu, ŋɔi ɑboɛ í bɛ siɛ inɛ ɡɔ wɑ í ni, mɑɑ̀ dɑsi idei inɛ dee deeu bɛ bɑɑ, domi idũ, iyi ǹ wɑ n sũ, ǹ yɛ wɑhɑlɑ jiidɑ jiidɑ si ɑlɑ nɑ iriɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ammɑ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do inɛ nɡbo ŋɑu ɑ̀ wɑsi ku mɑnte zɑmɑɑu ɑ̀ wɑɑ ni ɑ̀ sɔ̃ Pilɑti ku nyɑɑ ɑŋɑ Bɑrɑbɑɑ nɔ ku jɔ̀ ɑ kpɑ Jesu. ");
INSERT INTO mkl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nɔ Pilɑti í bee ŋɑ í ni, si ɑmɑnɛ minji ŋɑu bɛ, yoo nŋɑi ì bi n jɔ̀ nŋɛ. Nɔ ɑ̀ ni, Bɑrɑbɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nɔ Pilɑti í ni, to, bɛirei ɑn ceɑ Jesu iyi ɑ̀ yɑ kpe Kirisiu. Ŋɔi ɑŋɑ fei ɑ̀ ni, kpɑkpɑɛ si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ŋɔi Pilɑti í bee ŋɑ í ni, lɑɑlɔ yoomɑi í bɛi í ce. Ammɑ bɛ́i Pilɑti wɑ fɔ fei, bɛɛbɛ mɔi inɛ ŋɑu ɑ̀ yɑ dɔ̃ ɑnu hee lele ɑ ni, kpɑkpɑɛ si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Iyi Pilɑti í yɛ mii iyi nŋu wɑ ce fei nɡbɛi, wɑkɑtɑu wɑ kɔ̃ɔsi mɔm nii, ŋɔi í bu inyi í wɔɔ si wɑjui zɑmɑɑu í nyisi iyi bɑɑi nŋu kù wɑ si ideu, í ni, njɛi mɔkɔ dee deeu ihɛ̃ ku nikɑ̃ɛ kù yɛm, í jɛ idei irii nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ŋɔi inɛ ŋɑu fei ɑ̀ jɛ ɑ̀ ni, kunikɑ̃i njɛɛu ku jɛ idei irii ɑwɑ do ɑmɑ nwɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ŋɔi Pilɑti í jɔ̀ nŋɑ Bɑrɑbɑɑ, nɔ í jɔ̀ ɑ̀ tɛɑ Jesu kpɔtɔɔ. Si ɑnyii nŋu, nɔ í dɑ nŋɑ si ɑwɔ ɑ koo ɑ kpɑkpɑɛ si jĩi. ");
INSERT INTO mkl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Si ɑnyii nŋu ŋɔi sooɡe ŋɑ ɑ̀ ɡbɑ̃ Jesu ɑ̀ lɔòɛ kɑbɑi ilu ilɛu, nɔ ɑ̀ tɔtɔɔ sooɡeɛ ŋɑ iyi ɑ̀ ɡbe ŋɑu fei bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","À bɔ nyɑuɛ ŋɑ nɔ ɑ̀ dɑɑ si ibɔ nkpɑ sisɔ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nɔ ɑ̀ bɑ fulɑi ɑɡũ ɑ̀ leɑ si iri, nɔ ɑ̀ nɑɑ kpokpoo si ɑwɔ njɛɛ, ɑ̀ bɛi ɑ̀ ɡulɛ si wɑjuɛ ɑ̀ wɑɑ yɑɑkoɛ ɑ̀ wɑɑ ni, fɔɔ ilɑɑlui Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ŋɔi ɑ̀ tu siɛ ɑntɔ nɔ ɑ̀ ɡbɑ kpokpoou ɑ̀ cɑ̃ɑ si iriɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Iyi ɑ̀ yɑɑkoɛ ɑ̀ tɑ̃, ŋɔi ɑ̀ bɔɑɑ ibɔ nkpɑu ɑ̀ bɛi ɑ̀ dɑɑ si ibɔɛ ɑ̀ ɡbɑ̃ɑ ɑ̀ wɑɑ bɔ ku kpɑkpɑɛ si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wɑɑti iyi ɑ̀ wɑɑ fitɑ hɑi inɔ iluu ŋɔi ɑ̀ ko inɛi Sirɛni ɡɔ ɑ̀ yɑ kpoo Simɔɔ. Ŋɔi sooɡe ŋɑu ɑ̀ tilɑsiɛ ɑ̀ kɑ̃ɑ jĩi ku ɡɑɑu bii ɑɑ kpɑkpɑ si Jesuu. ");
INSERT INTO mkl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nɔ ɑ̀ wɑɑ bɔ inyɑ ɡɔ iyi ɑ̀ yɑ kpe Gɔɔɡɔtɑ, wɑɑtɔ inyɑ iyi í jɔ kokoi iri. Wɑɑti iyi ɑ̀ to bɛ, ");
INSERT INTO mkl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ɑ̀ nɑ Jesu ɑtɛ̃ vɛ̃ɛ iyi ɑ̀ yɔɡɛɛ do ɑlolo. Ammɑ iyi í tiɛɛ kù bi nŋu ku mɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ŋɔi ɑ̀ kpɑkpɑɛ si jĩi ku ɡɑɑuu nɔ ɑ̀ tɑ kpɑsɑ si jĩnɛɛ ŋɑu ɑ̀ ce ikpɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nɔ ɑ̀ bubɑ ɑ̀ wɑɑ deɡbeɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Si ɑntɑi iriɛ do lele, ɑ̀ kɔ ide iyi wɑ fɔ tɑɑle iyi í ce ɑ̀ ni, inɛ ihɛ̃i í jɛ Jesu, Ilɑɑlui Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ŋɔi ɑ̀ kpɑkpɑ ile minji ɡɔ ŋɑ bɛ mɑ́, inɛ ɑkɑ̃ ikpɑ ɑwɔ njɛɛ, inɛ ɑkɑ̃ mɔ ikpɑ ɑwɔ cɑnɡɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Inɛ ŋɑ iyi ɑ̀ wɑɑ too do bɛ ɑ̀ yɑ ɡbuɡbɑ̃ irii ɑ mɑɑ buu, ");
INSERT INTO mkl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ɑ mɑɑ ni, kù jɛ ɑwɔi ì ni ɑɑ lɛɡɛ kpɑsɛ̃i Ilɑɑɔ̃ nɔ i mɑɑ mɑ́ si ɑfei ɑjɔ mɛɛtɑ? To, bii ɑwɔu Amɑi Ilɑɑɔ̃i, fɑɑbɑ ɑrɑɛ bɛ, kitɑ wɑ hɑi si ɑntɑi jĩi ku ɡɑɑuu. ");
INSERT INTO mkl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bɛɛbɛi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ do inɛ nɡbo ŋɑu ɑ̀ yɑ mɑɑ yɑɑkoɛ ɑ mɑɑ ni, ");
INSERT INTO mkl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","í fɑɑbɑ inɛ ɡɔ ŋɑ ɑmmɑ í mɔnɡɔ ku fɑɑbɑ ɑrɑɛ. Kù jɛ í ni nŋu ilɑɑlui inɛi Izirɛli ŋɑi? To, ku kitɑ wɑ hɑi si ɑntɑi jĩi nɔu ku bɑ kɑ dɑsiɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Í dɑsi Ilɑɑɔ̃ nɑɑnɛ nɔ í ni nŋu Amɑi Ilɑɑɔ̃i. Debɛi, bii Ilɑɑɔ̃ í nɛ kubiɛ ntɔ ntɔi ku fɑɑbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɛɛbɛ mɔi ile ŋɑ iyi ɑ̀ kpɑkpɑ do Jesu ɑjɔu ɑ̀ yɑ mɑɑ yɑɑkoɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ŋɔi dɑsɑ̃ nkpɑu ilu í kuku si ilɛ fei hee í koo í to isɔ mɛɛtɑi ɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nɔ si isɔ mɛɛtɑu Jesu í dɔ̃ ɑnu hee lele í ni, Eli, Eli, lɑmɑ sɑbɑtɑni, wɑɑtɔ Ilɑɑɔ̃, Ilɑɑɔ̃, nɑ mii í ce ì fũsim ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ŋɔi inɛ ɡɔ ŋɑ iyi ɑ̀ wɑ bɛu ɑ̀ ɡbɔ ideu. Nɔ ɑ̀ ni, wɑ kpe Elii. ");
INSERT INTO mkl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ŋɔi ɡbɑkɑ̃ inɛ ɑkɑ̃ nŋɑ í sɛi í koo í dĩ kɑnyɑ si ɡolo ɡɔ í sɔsi inyiikɑ̃ í bɛi í nɑɑ í toɑ Jesu ku cɔ̃ɔcɔ̃ɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ammɑ inɛ ŋɑ iyi ɑ̀ ɡbe ŋɑu ɑ̀ ni, jɔ̀ɔ titɑ̃, kɑ cɔ bii Elii ɑ́ nɑ ku fɑɑbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nɔ Jesu í dɔ̃ ɑnu mɑ́ hee lele í bɛi í ku. ");
INSERT INTO mkl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Asee, wɑɑti bɛɛbɛ si ilui Zeruzɑlɛmu, ridoo iyi í wɑ kpɑsɛ̃i Ilɑɑɔ̃u í ɡɑ í kpɛ̃ minji hɑi lele hee ku bɔ ilɛ, nɔ ilɛ í yɑyɑ hee kutɑ ŋɑ ɑ̀ lɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Bɑlɛ ŋɑ ɑ̀ cĩ, nɔ woo dɑsi Ilɑɑɔ̃ nɑɑnɛ nkpɔ ŋɑ iyi ɑ̀ tɑko ɑ̀ ku wo ɑ̀ jĩ mɑ́, ɑ̀ fitɑ hɑi inɔ bɑlɛ. Si ɑnyii kujĩi Jesu nɔ ɑ̀ bɔ Zeruzɑlɛmu ilu kumɑ́u ɑ̀ tusɛ ɑrɑ nŋɑ bi inɛ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ŋɔi inɛ nɡboi sooɡe ŋɑ do inɛ ŋɑ iyi ɑ̀ wɑ bi tɛɛ ɑ̀ wɑɑ deɡbe Jesuu ɑ̀ yɛ kuyɑyɑi ilɛu do mii ŋɑ iyi í ce fei ŋɔi njo nlɑ nlɑ í mu ŋɑ ɑ̀ wɑɑ ni, ntɔ ntɔ, inɛɛu ihɛ̃ Amɑi Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Inɑɑbo nkpɔ ɡɔ ŋɑ ɑ̀ wɑ bɛ, ɑ̀ wɑɑ cɔ Jesu wɑ hɑi jĩijĩ. À too Jesu wɑi hɑi Gɑlilee ɑ nɑɑ ɑ ɡbɔɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Si inɔ nŋɑ Mɑɑri inɛi Mɑdɑlɑu do Mɑɑri iyei Zɑɑki do Zozɛfu, do iyei ɑmɑi Zebedee ŋɑ, ɑŋɑ fei ɑ̀ wɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iyi ɑlɛ í lɛ, ŋɔi mɔkɔ ilu fiɑ ɡɔ í nɑɑ bɛ. À yɑ kpoo Zozɛfu, inɛi Arimɑteei. Wee nŋu mɔ mɔcɔi Jesui wɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ŋɔi í bɔ bi Pilɑti í tɔɔɛ ikui Jesu. Nɔ Pilɑti í yɔɔdɑɑ í ni ɑ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zozɛfu í so ikuu í woo do ɑcɔ fũfũ titɔ̃ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nɔ í koo í suu si isɑi kutɑ ɡɔ iyi í jɔ̀ ɑ̀ ɡbeɑ nŋu tɑkɑɛ wo, ɑmmɑ ɑ kù dɑsi inɛ ɡɔ titɑ̃. Si ɑnyiɛ nɔ í bimbili kutɑ nlɑ ɡɔ í dĩò ɑndɛi bɑlɛu í bɛi í nɛ. ");
INSERT INTO mkl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mɑɑri inɛi Mɑdɑlɑu do Mɑɑri iyi ihɔ̃u ɑ̀ wɑ bɛ ɑ̀ wɑɑ bubɑ kɔkɔi bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iyi ɑjɔi sɔɔlui kusĩmiu í kpɑ iri, ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do Fɑrisi ŋɑu ɑ̀ bɔ bi Pilɑti ɑjɔ . ");
INSERT INTO mkl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","À ni, lɑfɛ̃ɛ, ɑ̀ ye ɡiɡii ide iyi ilu ibou í fɔ si wɑɑti iyi í wɛɛ si ɑndunyɑ í ni si ɑjɔ mɛɛtɑsiɑ nŋu ɑ́ jĩ hɑi si bɑlɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nɑ nŋu, jɔ̀ ɑ mɑɑ deɡbe bɑlɛu hee ku to zɑkɑi ɑjɔ mɛɛtɑ, ku bɑ mɔcɔɛ ŋɑ ɑ mɑɑ̀ nɑ ɑ nyɑ ikuu, ɑ bɛi ɑ koo ɑ sɔ̃ inɛ ŋɑ ɑ ni, í jĩ hɑi si bɑlɛ. Wɑɑti bɛɛbɛ iboi ɑnkɑ̃ɑnyiu ihɛ̃ ɑ́ nɑ ku re bɑɑ ti tɑkou mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ŋɔi Pilɑti í sɔ̃ ŋɑ í ni, i ɡbɑ̃ sooɡe ŋɑu ɑ koo ɑ deɡbeɛ bɛi ì bi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nɔ ɑŋɑò ŋɑ fei ɑ̀ bɔ bi bɑlɛu. À ce nyindɑi ɑmɑnlu si kutɑu ku bɑ inɛ ɡɔ ku mɑɑ̀ cũu. Nɔ ɑ̀ jilɛ sooɡe ŋɑ bɛ ɑ̀ wɑɑ deɡbeɛ. ");
INSERT INTO mkl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Iyi ɑjɔi kusĩmiu í lɔ, ɑjɔ ɑmɑɑzumɑ dɑɑdɑɑkɔ Mɑɑri inɛi Mɑdɑlɑu do Mɑɑri iyi ihɔ̃ ɑ̀ bɔ bɑlɛu ku cɔ. ");
INSERT INTO mkl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ŋɔi ɡbɑkɑ̃ ilɛ kuyɑyɑ nlɑ ɡɔ í dede nɔ ɑmɑlekɑi Aɔ̃ Lɑfɛ̃ɛ ɡɔ í kitɑ wɑ hɑi lele í nɑɑ í tɑle kutɑu wɑ bubɑ si. ");
INSERT INTO mkl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wɑjuɛ wɑ dɑɑnɑ bɛi kuŋɔi ijĩ nɔ nyɑuɛ ŋɑ mɔ wɑ fũutɑ bɛi iwu tɑfɑ. ");
INSERT INTO mkl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ŋɔi njo í mu woo deɡbe ŋɑu hee ɑ̀ wɑɑ yɑyɑ nɔ ɑ̀ cuku ilɛ bɛi iku ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ŋɔi ɑmɑlekɑu í sɔ̃ inɑɑbo ŋɑu í ni, iŋɛ, i mɑɑ̀ jɔ̀ njo ku mu ŋɛ. Ǹ mɑ̀ iyi Jesu inɛ iyi ɑ̀ kpɑkpɑ si jĩi ku ɡɑɑuui ì wɑɑ dɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kù wɑ ihɛ̃ mɑ́, í jĩ hɑi si bɑlɛ si bɛi í tɑko í fɔu. I nɑɑ i cɔ bii í tɑko wɑ sũ wo, ");
INSERT INTO mkl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","nɔ i koo ńyɑ ńyɑ i koo i sɔ̃ mɔcɔɛ ŋɑ i ni, í jĩ hɑi si bɑlɛ. Á cuɑ nŋɛ ikpɑ Gɑlilee. Bɛi ɑɑ yɔɔ ŋɑ. Iyi ǹ nɛ ɑn sɔ̃ ŋɛ mbɛ. ");
INSERT INTO mkl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ŋɔi ɑ̀ sindɑ ńyɑ ńyɑ hɑi bi bɑlɛu do njo. Nɔ bɑɑ do iyi ɑ̀ wɑɑ ce njo fei ɑ̀ nɛ inɔ didɔ̃ nlɑ nlɑ mɑ́. Ŋɔi ɑ̀ sɛi ɑ̀ koo ɑ̀ sɔ̃ mɔcɔɛ ŋɑ lɑɑbɑɑuu. ");
INSERT INTO mkl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ŋɔi Jesu í kò ŋɑ í ni, i fɔɔ. Ŋɔi ɑ̀ sɛkɛɛ siɛ wɑ ɑ̀ nɑɑ ɑ̀ mu kutɛɛ ɑ̀ sɛɛbɑtɑ si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nɔ Jesu í sɔ̃ ŋɑ í ni, i mɑɑ̀ jɔ̀ njo ku mu ŋɛ. I koo i sɔ̃ kpɑɑsim ŋɑ ɑ bɔ Gɑlilee, bɛi ɑɑ yɛm. ");
INSERT INTO mkl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wɑɑti iyi ɑ̀ wɑ si kpɑ̃ɑ ɑ̀ wɑɑ nɛu, inɛ ɡɔ ŋɑ si woo deɡbe ŋɑu ɑ̀ bɔ inɔ ilu ɑ̀ koo ɑ̀ sisiɑ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ mii iyi í ceu fei. ");
INSERT INTO mkl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nɔ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu ɑ̀ ce kutɔtɔɔ do inɛ nɡbo ŋɑu ɑ̀ busi njɛ nɔ ɑ̀ muɑ sooɡe ŋɑu fiɑ nkpɔ ɡɔ, ");
INSERT INTO mkl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ɑ̀ sɔ̃ ŋɑ ɑ̀ ni, i sɔ̃ inɛ ŋɑ i ni mɔcɔɛ ŋɑ ɑ̀ nɑɑ idũ lɑjɑ ɑ̀ nɑɑ ɑ̀ ce ilei ikuu wɑɑti iyi ì wɑɑ sĩ njoo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bii ilu ilɛu í ɡbɔ ideu, ɑ̀ mɑ̀ bɛi ɑɑ kɑ ce ku bɑ ku mɑɑ̀ kpɑ̃ ŋɛ iju. ");
INSERT INTO mkl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sooɡe ŋɑu ɑ̀ ɡbɑ fiɑu nɔ ɑ̀ ce bɛi ɑ̀ tɔɔ ŋɑu. Ŋɔi í jɔ̀ ideu í fɑnɡɑɑ si inɔi Zuifu ŋɑ hee do nnyi fei. ");
INSERT INTO mkl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesu í bɔ Gɑlilee. Si ɑnyii nŋu nɔ mɔcɔ mɑɑtɑkɑ̃ ŋɑu ɑ̀ koo ɑ̀ bɑɑ bɛ si iri kutɑ bii í tɑko í sɔ̃ ŋɑ wou. ");
INSERT INTO mkl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iyi ɑ̀ yɔɔ, ŋɔi ɑ̀ wɑɑ ɡulɛɑɑ. Ammɑ ɡɔɡɔ ŋɑ ɑ̀ wɑɑ sikɑ sikɑ. ");
INSERT INTO mkl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ŋɔi Jesu í sɛkɛɛ si ŋɑ wɑ í ni, yiikoi lele do ti ilɛ fei ɑ̀ nɑm nii. ");
INSERT INTO mkl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nɑ nŋu, i koo si dimi fei, i ce ŋɑ mɔcɔm ŋɑ. Nɔ i dɑsi ŋɑ inyi do irii Bɑɑbɑ do ti Amɑ do ti Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nɔ ide ŋɑ iyi ǹ sɔ̃ ŋɛ fei, i kɔ ŋɑ si ide ŋɑu ku jirimɑ ŋɑ. Nɔ ɑn mɑɑ n wɛɛ do iŋɛ ɑjɔ fei hee kɔɔi ɑndunyɑ");
INSERT INTO mkl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kusintii lɑɑbɑɑu jiidɑi Jesu Kirisi Amɑi Ilɑɑɔ̃ wee. ");
INSERT INTO mkl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Í sinti si bɛi Ezɑi wɑlii í tɑko í kɔ si tiɑɛ í ni, Ilɑɑɔ̃ í ni, cɔ, ɑn bɛ woo sisi idem wɑ si wɑjuɛ, iyi ɑ́ teeseɛ kpɑ̃ɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nŋui ɑ́ dɔ̃ ɑnu si ɡbɑbuɑu ku ni, I teese kpɑ̃ɑi Lɑfɛ̃ɛ ku tɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bɛɛbɛi Zɑ̃ɑ í nɑɑ si ɡbɑbuɑ wɑ dɑsi inɛ ŋɑ iyi ɑ̀ koo bi tɛɛ inyi. Wɑ wɑɑzoɑ inɛ ŋɑ wɑ ni, i kpɑɑsi idɔ ku bɑ Ilɑɑɔ̃ ku kpɑ idei kurɑrɑ nŋɛ nɔ ɑ dɑsi ŋɛ inyi. ");
INSERT INTO mkl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nɔ inɛ ŋɑ ɑ̀ nɑɑ bi tɛɛ hɑi Zeruzɑlɛmu do hɑi ilɛi Zudee fei. À ce tuubɑi dulum du ŋɑ nɔ ɑ̀ jɔ̀ Zɑ̃ɑ í dɑsi ŋɑ inyi idoi Zuudɛ̃ɛu. ");
INSERT INTO mkl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zɑ̃ɑ wɑ dɑsi ibɔi ntoi kpookpo, nɔ wɑ dĩ sɑntikii bɑtɑ. Kɛtɛnɡbo do nyikɔ̃i sɑkoi í jɛ ijɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wɑ wɑɑzoɑ zɑmɑɑ wɑ ni, inɛ ɡɔ ɑ́ nɑɑ si ɑnyim iyi í nɛ ɡbuɡbɑ̃ í rem. N kù to bɑɑ n bɑte n fũ ikũi bɑɑtɑɛ si kutɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Amu ǹ dɑsi ŋɛ inyi, ɑmmɑ njɛ Hundei Ilɑɑɔ̃i ɑ́ dɑ nŋɛ si. ");
INSERT INTO mkl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wɑɑti bɛɛbɛ Jesu í dede wɑ hɑi Nɑzɑrɛti si ilɛi Gɑlilee í nɑɑ bi Zɑ̃ɑ. Iyi í to wɑ nɔ Zɑ̃ɑ í dɑsiɛ inyi si idoi Zuudɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wɑɑti iyi Jesu wɑ fitɑ wɑ hɑi si inyiu ɡbɑkɑ̃ ŋɔi í bɑ lelei Aɔ̃ í cĩ. Nɔ Hundei Ilɑɑɔ̃ í de siɛ wɑ bɛi ɑnkɑsiidi. ");
INSERT INTO mkl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nɔ ɑ̀ ɡbɔ ide ku fɔ wɑ hɑi lele í ni, ɑwɔu ɑmɑm nii, ǹ biɛ jiidɑ jiidɑ. Siɛi inɔ didɔ̃m fei í yɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ŋɔi ɡbɑkɑ̃, Hundeu í tɑle siɛ ɡbɑbuɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Bɛi í ce ɑjɔ ciiji nɔ Seetɑm wɑ lɛlɛɛ ku ce lɑɑlɔ. Í wɑ bɛ do iŋɑi sɑko ŋɑ nɔ ɑmɑlekɑ ŋɑ ɑ̀ sobiɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Si ɑnyiɛ ŋɔi ɑ̀ dɑsi Zɑ̃ɑ piisɔ̃ɔ. Nɔ wɑɑti bɛɛbɛ Jesu í bɔ ilɛi Gɑlilee wɑ wɑɑzo lɑɑbɑɑu jiidɑ iyi wɑ nɑɑ hɑi bi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Í ni, ɑwɑɑti í to iyi Ilɑɑɔ̃ ɑ́ nɑ ku jɛ bommɑɛ. I kpɑɑsi idɔ nŋɛ nɔ i dɑsi lɑɑbɑɑu jiidɑu nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ajɔ nŋu ɡɔ Jesu wɑ too tenku sisɔi Gɑlileeu. Ŋɔi í yɛ Simɔɔ do ifɔɛ Anderee, sɔɔkɔ ŋɑ, ɑ̀ wɑɑ le tɑɑo si inɔ tenkuu. ");
INSERT INTO mkl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, i toom wɑ ŋɑ nɔ n ce ŋɛ woo dɛdɛ inɛ ŋɑ iyi ɑɑ jɛ ti Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ŋɔi ɡbɑkɑ̃ ɑ̀ jɔ̀ tɑɑo nŋɑ ŋɑ ɑ̀ wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ŋɔi Jesu í nɛ í jĩ keeke nɔ í yɛ Zɑɑki do ifɔɛ Zɑ̃ɑ, ɑmɑi Zebedee ŋɑ. Aŋɑ mɔ ɑ̀ wɑ si inɔ ɑkɔi inyi nŋɑ, ɑ̀ wɑɑ teese tɑɑo nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ŋɔi ɡbɑkɑ̃ í kpe ŋɑ. Nɔ ɑ̀ jɔ̀ Zebedee bɑɑ nŋɑ si inɔi ɑkɔi inyiu bɛ do woo ce icɛɛ ŋɑ, nɔ ɑ̀ wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ŋɔi Jesu do mɔcɔɛ ŋɑ ɑ̀ bɔ Kɑpɛrɑnumu. Nɔ ɑjɔi kusĩmi Jesu í bɔ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu, wɑ kɔ inɛ ŋɑ si cioi idei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wɑ kɔ nŋɑ si cio do yiiko. Kù wɑɑ kɔ nŋɑ si bɛi woo kɔ inɛ ŋɑ si woodɑ ŋɑ. Nŋui í jɔ̀ ɑ̀ biti. ");
INSERT INTO mkl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wee inɛ ɡɔ í wɑ ile bɛ, í nɛ inɛi inɔɔko. Nɔ í dɔ̃ ɑnu hee lele í ni, ");
INSERT INTO mkl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","mii í wɑ si ɡɑ̃mɛi ɑwɑɛ ŋɑ, Jesu, ɑwɔ inɛi Nɑzɑrɛti. Ì nɑɑ ku kpɑ wɑi? Ǹ mɑ̀ inɛ iyi ì jɛ. Awɔi ì jɛ Inɛ kumɑ́ iyi Ilɑɑɔ̃ í bɛ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ŋɔi Jesu í lɑ siɛ í ni, coko, fitɑ hɑi si inɛɛu bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ŋɔi inɛi inɔɔkou í dɔ̃ ɑnu nlɑ nlɑ, í yɑyɑɛ do ɡbuɡbɑ̃ nɔ í fitɑ siɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nɔ ɑŋɑ fei ɑ̀ biti ntɔ ntɔ hee ɑ̀ wɑɑ bee njɛ ide ɑ̀ wɑɑ ni, dimii mii iyi ihɛ̃. Inɛɛu wɑ kɔ wɑ si cio titɔ̃ do yiiko. Wɑ jilɛɑ hee do inɛi inɔɔko ŋɑ fei ide nɔ ɑ̀ wɑɑ jirimɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ŋɔi ɡbɑkɑ̃ í nyɑ iri si ilɛi Gɑlilee fei. ");
INSERT INTO mkl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ŋɔi Jesu í fitɑ hɑi ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu, nŋu do Zɑɑki do Zɑ̃ɑ nɔ ɑ̀ bɔ kpɑsɛ̃i Simɔɔ do Anderee. ");
INSERT INTO mkl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wee iyei ɑboi Simɔɔ wɑ sũ domi wɑ ce ɑrɑ ɡbɑ̃ɑ. Iyi ɑ̀ to wɑ ɡbɑkɑ̃ ŋɔi ɑ̀ koo ɑ̀ sɔ̃ Jesu ɑ̀ ni ɑbou kù wɑɑ nɛ bɑɑni. ");
INSERT INTO mkl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ŋɔi í sɛkɛɛ siɛ wɑ í mu ɑwɔɛ í dedeɛ. Bɛ ɡbɑkɑ̃ ɑrɑ ɡbɑ̃ɑu í nyɑ nɔ ɑbou í yɑɑɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Alɛ ɑjɔ nŋu iyi inunu í lɔ ŋɔi inɛ ŋɑ ɑ̀ nɑɑɑ Jesu bɔ̃ɔ ŋɑ wɑ do inɛ ŋɑ iyi ɑ̀ nɛ inɛi inɔɔko ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nɔ inɛi ilu ŋɑu fei ɑ̀ nɑɑ ɑ̀ tɔtɔɔ si ɑndɛ koofɑu. ");
INSERT INTO mkl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Í jɔ̀ inɛ nkpɔ í bɑ iri si bɔ̃ɔ ikɑ̃ ikɑ̃ ŋɑ, nɔ í lele inɛi inɔɔko nkpɔ nkpɔ. Ammɑ ci yɑ jɛ inɛi inɔɔko ŋɑu ɑ fɔ ide domi ɑ̀ mɑ̀ɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dɑɑdɑɑkɔu, hee inyɑ ku mɑɑ mɑ́, Jesu í dede í fitɑ hɑi kpɑsɛ̃u í bɔ si ɡbɑbuɑ ɡɔ, í koo í ce kutɔɔ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ŋɔi Simɔɔ do kpɑɑsiɛ ŋɑ ɑ̀ wɑsi ku dɛdɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Iyi ɑ̀ nɑ ɑ̀ yɔɔ, ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, inɛ fei wɑ dɛdɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ŋɔi í jɛ nŋɑ í ni, kɑ bɔ wɑju si ilu mmu ŋɑ ku bɑ n wɑɑzo idei Ilɑɑɔ̃ bɛ, domi nɑ ŋɔi í jɔ̀ ǹ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nɔ ɑ̀ koo ɑ̀ dɑbii si ilɛi Gɑlilee fei. Í yɑ mɑɑ wɑɑzo ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ ŋɑu, nɔ í yɑ mɑɑ lele inɛi inɔɔko ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ŋɔi dintɛ ɡɔ í nɑɑ bi Jesu í nɑɑ í ɡulɛ si wɑjuɛ, wɑ tɔɔɛ wɑ ni, bii ì bi, ɑɑ yɔkɔ i jɔ̀ n bɑ iri nɔ n jɛ inɛ iyi í mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ŋɔi Jesu í ce ɑrɑɑreɛ. Í yɔ ɑwɔɛ í luu nɔ í ni, ǹ bi. Bɑ iri nɔ i jɛ inɛ kumɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bɛ ɡbɑkɑ̃ bɔ̃ɔi dintɛu í nyɑ siɛ nɔ í jɛ inɛ iyi í mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ŋɔi Jesu í sɔ̃ɔ ide do ɡbuɡbɑ̃ í ni, ɡbɔ. Mɑɑ̀ sɔ̃ inɛ ɡɔ ideu ihɛ̃, ɑmmɑ koo nyisi ɑrɑɛ bi woo weei Ilɑɑɔ̃u. Nɔ i ce kuwee iyi Moizi í jilɛu. Kuweeu bɛi ɑ́ nyisi ŋɑ iyi ì jɛ inɛ iyi í mɑ́ bɛbɛi. Iyi í sɔ̃ɔ bɛɛbɛ í tɑ̃ nɔ í ni ku nɛ. ");
INSERT INTO mkl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Do nŋu fei inɛɛu, iyi í nɛ, í koo í wɑsi ku sisi ideu bɑntumɑ hee lele, nŋui í jɔ̀ Jesu kù yɔkɔ ku lɔ si inɔ ilu do ɡɑɑze mɑ́. I yɑ mɑɑ mu ɑrɑɛi ɑnɡule si ɡbɑbuɑ ŋɑ. Nɔ inɛ ŋɑ ɑ yɑ mɑɑ koo bi tɛɛ bɛ hɑi bii fei. ");
INSERT INTO mkl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iyi í ce ɑjɔ minji mɑ́ Jesu í nyi wɑ Kɑpɛrɑnumu. Ŋɔi inɛ ŋɑ ɑ̀ ɡbɔ iyi í wɑ kpɑsɛ̃ ɡɔ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nɔ ɑ̀ tɔtɔɔ bɛ bututu hee ɑndɛi ileu kɑɑ yɔkɔ ku ɡbɑ ŋɑ. Ŋɔi wɑ sɔ̃ ŋɑ idei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nɔ inɛ mɛɛ ɡɔ ŋɑ mɔ ɑ̀ nɑɑ bi tɛɛ ɑ̀ wɑɑ so wɛɛɡɛ ɡɔ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wee ɑ kɑɑ bɑ ɑ to wɑ bi Jesu nɑ irii zɑmɑɑu. Ŋɔi ɑ̀ ɡũ ɑntɑi ileu ɑ̀ lu ɑntɑi sikifɑi tenɡi bii Jesu í wɑu. Ŋɔi ɑ̀ to wɛɛɡɛu do mɑkɛɛ si bii wɑ sũ siu hɑi do ikpɑ ɑndɛ bii ɑ̀ luò sikifɑu. ");
INSERT INTO mkl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iyi Jesu í yɛ nɑɑnɛi inɛ ŋɑu ŋɔi í sɔ̃ wɛɛɡɛu í ni, bɑɑkɔɔm, ǹ kpɑ idei dulum dɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wee woo kɔ inɛ ŋɑ si woodɑ ɡɔ ŋɑ ɑ̀ wɑɑ bubɑ bɛ ɑ̀ wɑɑ lɑsɑbu si idɔ nŋɑ ɑ̀ wɑɑ ni, ");
INSERT INTO mkl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","bɛirei inɛɛu í ce wɑ fɔ bɛɛbɛ. Wɑ bu Ilɑɑɔ̃. Yooi ɑ́ yɔkɔ ku kpɑ idei dulum dii inɛ ɡɔ bii kù jɛ Ilɑɑɔ̃ nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesu í mɑ̀ ɡbɑkɑ̃ si idɔɛ mii iyi ɑ̀ wɑɑ lɑsɑbu, ŋɔi í sɔ̃ ŋɑ í ni, nɑ mii í ce ì wɑɑ ce dimii lɑsɑbuu bɛ si idɔ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Yoomɑi í fɑɑlɑ í re, inɛ ku sɔ̃ wɛɛɡɛ ku ni ǹ kpɑ idei dulum dɛɛ, wɑlɑkɔ ku ni ku dede ku so mɑkɛɛɛ ku nɛ. ");
INSERT INTO mkl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ammɑ ǹ bi i mɑ̀ ŋɑ iyi ɑmu Amɑi Amɑnɛ ǹ nɛ ɡbuɡbɑ̃ n kpɑ idei dulum dii inɛ ŋɑ si ɑndunyɑ. Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi í sɔ̃ wɛɛɡɛu í ni, ");
INSERT INTO mkl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","dede i so mɑkɛɛɛ i bɔ kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ŋɔi ɡbɑkɑ̃ wɛɛɡɛu í dede í so mɑkɛɛɛ í nɛ wɑ fitɑ hɑi inɔ kpɑsɛ̃u. Fei ndɛɛ í cei si wɑjui inɛ ŋɑ hee í mu ɑŋɑ fei biti. Nɔ ɑ̀ sɑɑbu Ilɑɑɔ̃ ɑ̀ wɑɑ ni ɑŋɑ ɑ kù yɛ dimiɛ ɑjɔ kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ŋɔi Jesu í nyi itĩi tenkuu mɑ́. Ŋɔi zɑmɑɑ fei í nɑɑ bi tɛɛ. Wɑ cio nŋɑ idei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ŋɔi í ɡbe wɑ lɔ kɔkɔi ile bi ku ɡbɑ fiɑi lɛmpoo nɔ í yɛ Levi, ɑmɑi Alifee wɑ bubɑ bɛ. Ŋɔi í sɔ̃ɔ í ni, toom wɑ. Nɔ Levi í dede í tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Si ɑnyiɛ Jesu wɑ jɛ kpɑsɛ̃i Levi. Nɔ wee, woo ɡbɑ fiɑi lɛmpoo do inɛ lɑɑlɔ nkpɔ wɑ jɛ do nŋu do mɔcɔɛ ŋɑ ɑjɔ, si nɑ iyi í jɔ̀ ɑŋɑ nkpɔ nkpɔi ɑ̀ wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","To, wee Fɑrisi ɡɔ ŋɑ ɑ̀ wɑ bɛ iyi ɑ̀ jɛ woo kɔ inɛ ŋɑ si woodɑ. Iyi ɑ̀ yɔɔ wɑ jɛ do woo ɡbɑ fiɑi lɛmpoo ŋɑ do inɛ lɑɑlɔ ŋɑu nɔ ɑ̀ bee mɔcɔɛ ŋɑu ɑ̀ ni, bɛirei í ce wɑ jɛ nɔ wɑ mɔ do woo ɡbɑ fiɑi lɛmpoo ŋɑ do inɛ lɑɑlɔ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iyi Jesu í ɡbɔ bɛɛbɛ, ŋɔi í sɔ̃ ŋɑ í ni, ilu bɑɑni ŋɑ ɑ kù nɛ bukɑɑtɑi ilu iwɔ bii kù jɛ bɔ̃ɔ ŋɑ. Bɛɛbɛ mɔi n kù nɑɑ ku kpe inɛ dee dee ŋɑ, ɑmmɑ ilu dulum ŋɑi ǹ nɑɑ ku kpe. ");
INSERT INTO mkl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ajɔ nŋu ɡɔ mɔcɔi Zɑ̃ɑ ŋɑ do ti Fɑrisi ŋɑ ɑ̀ wɑɑ dĩ ɑnu ŋɔi inɛ ɡɔ nŋɑ ŋɑ ɑ̀ nɑɑ ɑ̀ bee Jesu ɑ̀ ni, bɛirei í ce mɔcɔi Zɑ̃ɑ do ti Fɑrisi ŋɑ ɑ̀ yɑ dĩ ɑnu, nɔ wee mɔcɔɛ ŋɑ ɑ ci yɑ dĩ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ŋɔi Jesu í jɛ nŋɑ í ni, kpɑɑsii mɔkɔ titɔ̃ ŋɑ ɑɑ yɔkɔ ɑ dĩ ɑnu wɑɑti iyi mɔkɔ titɔ̃u í wɑ inɔ nŋɑ? Ntɔ ntɔ, wɑɑti iyi mɔkɔ titɔ̃u í wɑ inɔ nŋɑ fei, ɑ kɑɑ yɔkɔ ɑ dĩ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ammɑ ɑjɔ wɑ nɑɑ iyi ɑɑ nyɑ mɔkɔ titɔ̃u hɑi si inɔ nŋɑ. Wɑɑti bɛɛbɛi ɑɑ dĩ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ntɔ ntɔ, inɛ ɡɔ kɑɑ sɔ jɑɑɛ nɡbo do titɔ̃ɛ ku tɔtɔɔɛ. Bii í ce bɛɛbɛ, titɔ̃u ɑ́ ɡɑ jɑɑɛ nɡbou ku kɔ̃ɔsii. ");
INSERT INTO mkl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bɛɛbɛ mɔi ɑ ci yɑ dɑsi vɛ̃ɛ titɔ̃ iyi wɑ ɡbɑ si bɔɡɔ bɑtɑ nɡbo ŋɑ. Bii ì ce bɛɛbɛ, bɔɡɔ bɑtɑ nɡbo ŋɑu ɑɑ ɡɑi, nɔ vɛ̃ɛu ku nikɑ̃. Nɔ bɔɡɔ ŋɑu do vɛ̃ɛu fei ku ce nfe. Ammɑ ɑ̀ yɑ dɑsi vɛ̃ɛ titɔ̃i si bɔɡɔ titɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Si ɑjɔi kusĩmi ɡɔ Jesu do mɔcɔɛ ŋɑ ɑ̀ wɑɑ too kɔɔi ilɛ ɡɔ. Si isɛɛnɛ nŋɑu ŋɔi mɔcɔɛ ŋɑu ɑ̀ wɔ ɑmɑɑjɛ iyi ɑ̀ ɡbɛ̃ si ilɛu ɑ̀ nunu ijuɛ si ɑwɔ ɑ̀ wɑɑ ŋɔ. ");
INSERT INTO mkl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ŋɔi Fɑrisi ŋɑu ɑ̀ bee Jesu ɑ̀ ni, i kù wɑɑ yɔɔi? Nɑ mii í ce ɑ̀ wɑɑ ce mii iyi ɑ kù nɛ kpɑ̃ɑi ku ce si ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nɔ í jɛ nŋɑ í ni, i kù cio ɑjɔ kɑ̃mɑ ŋɑ mii iyi Dɑvidi í ce si wɑɑti iyi í wɑ si wɑhɑlɑ nɔ ɑri wɑ kpɑ nŋu do inɛɛ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Í lɔ kpɑsɛ̃i Ilɑɑɔ̃ nɔ í jɛ pɛ̃ɛ iyi ɑ̀ jilɛɑ Ilɑɑɔ̃ iyi ɑ̀ ɡɑnji inɛ fei ku jɛ bii kù jɛ woo weei Ilɑɑɔ̃ ŋɑ ɑŋɑ ɑkɑ̃. Ammɑ Dɑvidi í so pɛ̃ɛu nɔ í nɑ do inɛɛ ŋɑ fei ɑ̀ jɛ. Wɑɑti bɛɛbɛ Abiɑtɑi wɑ jɛ woo wee nlɑu. ");
INSERT INTO mkl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nɔ Jesu í sɔ̃ ŋɑ mɑ́ í ni, Ilɑɑɔ̃ í jilɛ ɑjɔi kusĩmii nɑ ɑrɑnfɑ̃ɑnii ɑmɑnɛ ŋɑ. Kù jɛ ɑmɑnɛ ŋɑi ɑɑ nɑ ɑ jɛ ɑrui ɑjɔi kusĩmiu. ");
INSERT INTO mkl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nɑ nŋu, i mɑ̀ ŋɑ iyi ɑmu Amɑi Amɑnɛ ǹ jɛ inɛ nɡboi ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Si ɑnyii nŋu ŋɔi Jesu í bɔ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu mɑ́. Wee inɛ ɡɔ í wɑ bɛ, ɑwɔ ɑkɑ̃ɛ í ku í ɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nɔ inɛ ŋɑ iyi ɑ̀ wɑ bɛ ɑ̀ kɑ̃si Jesu iju, ɑ̀ wɑɑ cɔ mɑ̀ ɑ́ jɔ̀ inɛɛu ku bɑ iri si ɑjɔi kusĩmi. À wɑɑ cɔɔ domi ɑ̀ wɑɑ bi ɑ yɛ tɑɑleɛi. ");
INSERT INTO mkl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ŋɔi Jesu í sɔ̃ inɛ iyi ɑwɔɛ í kuu í ni, dede i leekĩ si ɑnini nŋɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nɔ í bee inɛ ŋɑu í ni, si ɑjɔi kusĩmi, í sĩɑ ɑmɑnɛ ku ce jiidɑ de mɑ̀ lɑɑlɔ, ku fɑɑbɑ inɛ de, mɑ̀ ku kpɑɑ. Ŋɔi ɑŋɑ fei ɑ̀ coko. ");
INSERT INTO mkl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ŋɔi Jesu wɑ cɔ ɑŋɑ fei do idɔɔkɔ̃, nɔ inɔɛ í fɔ ntɔ ntɔ domi í yɛ idɔ nŋɑ í le. Ŋɔi í sɔ̃ inɛɛu í ni, tɛ ɑwɔɛ. Iyi í tɔɔ nɔ ɑwɔu í bɑɑ dee dee. ");
INSERT INTO mkl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nɑ nŋu, Fɑrisi ŋɑu ɑ̀ fitɑ hɑi ileu bɛ. Nɔ ɑ̀ tɔtɔɔ do inɛi Herodu ŋɑ. À wɑɑ busi njɛ bɛi ɑɑ ce ɑ kpɑò Jesu. ");
INSERT INTO mkl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ŋɔi Jesu do mɔcɔɛ ŋɑ ɑ̀ fɑ ɑrɑ nŋɑ ɑ̀ bɔ ikpɑ tenkui Gɑlilee, nɔ zɑmɑɑ nlɑ ɡɔ wɑ tooɛ wɑ hɑi ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nɔ inɛi Zeruzɑlɛmu ŋɑ do inɛi ilu mmu ɡɔ ŋɑ iyi ɑ̀ wɑ si ilɛi Zudee mɑ́, do inɛi ilɛi Idumee ŋɑ, do inɛi icei idoi Zuudɛ̃ɛ ŋɑ, do inɛi ilɛɛkoi Tii do Sidɔ̃ɔ ŋɑ ɑ̀ ɡbɔ mii iyi wɑ ce nɔ ɑ̀ nɑɑ bi tɛɛ ɑŋɑ nkpɔ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ŋɔi í ni mɔcɔ ŋɑu ɑ jilɛɑ nŋu ɑkɔi inyi nɑ bii zɑmɑɑu í nɑ wɑ mɑnteɛ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ntɔi, si bɛi í jɔ̀ inɛ nkpɔ í bɑ iri, nŋui í jɔ̀ bɔ̃ɔ ŋɑ fei ɑ̀ yɑ mɑɑ nɑɑ bi tɛɛ ɑ mɑɑ tɑle njɛ ɑ bɑ ɑ luu ku bɑ ɑ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nɔ bii inɛ ŋɑ iyi ɑ̀ nɛ inɛi inɔɔko ŋɑ ɑ̀ yɔɔ ɑ̀ yɑ nɑ ɑ ɡulɛ si wɑjuɛi ɑ dɔ̃ ɑnu ɑ mɑɑ ni, ɑwɔi ì jɛ Amɑi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ammɑ Jesu í yɑ sɔ̃ inɛi inɔɔko ŋɑu ide do kuɡɑɑbu ku bɑ ɑ mɑɑ̀ sɔ̃ inɛ ŋɑ inɛ iyi nŋu í jɛ. ");
INSERT INTO mkl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Si ɑnyii nŋu, Jesu í ɡũ iri kutɑ ɡɔ, ŋɔi í kpe inɛ ŋɑ iyi í bi. Nɔ ɑ̀ nɑɑ bi tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ŋɔi í cicɑ ɑmɑnɛ mɑɑteeji ku bɑ ɑ yɑ mɑɑ wɑ bi tɛɛ, nɔ ku bɛ ŋɑ ɑ koo ɑ wɑɑzoɑ inɛ ŋɑ. Nɔ í sɔ ŋɑ woo bɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nɔ í mu nŋɑ ɡbuɡbɑ̃ ɑ leleò inɛi inɔɔko ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Amɑnɛ mɑɑteeji ŋɑ iyi í cicɑu wee. Sinte titɑ̃ í cicɑ Simɔɔ nɔ í sɔɔ Piɛɛ, wɑɑtɔ kutɑ. ");
INSERT INTO mkl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Si ɑnyii nŋu, ŋɔi í cicɑ Zɑɑki, do Zɑ̃ɑ ifɔɛ, ɑmɑi Zebedee ŋɑ, nɔ í sɔ ŋɑ Boɑnɛzɛɛ, wɑɑtɔ inɛ ŋɑ iyi ɑ̀ jɔ ibɑi ijĩ. ");
INSERT INTO mkl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Si ɑnyii nŋu í bɛi í cicɑ Anderee, do Filipu, do Bɑɑtelemi, do Mɑtie, do Tomɑɑ, do Zɑɑki ɑmɑi Alifee, do Tɑdee, do Simɔɔ inɛi iɡbɛi Zelɔtu , ");
INSERT INTO mkl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","do Zudɑsi Isikɑriɔti, inɛ iyi ɑ́ nɑ ku zɑmbɑɛu. ");
INSERT INTO mkl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ŋɔi Jesu do mɔcɔɛ ŋɑ ɑ̀ bɔ kpɑsɛ̃. Nɔ zɑmɑɑ í tɔtɔɔ bɛ hee ɑ kù bɑ bɑɑ fɑyɑi ku jɛ. ");
INSERT INTO mkl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ŋɔi nyɑɑnzei Jesu ŋɑ ɑ̀ ɡbɔ mii iyi wɑ ce, nɔ ɑ̀ wɑɑ nɑɑ ku muu, domi ɑ̀ ni kù wɛɛ dee dee mɑi. ");
INSERT INTO mkl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wee, woo kɔ inɛ ŋɑ si woodɑ ɡɔ ŋɑ ɑ̀ wɑ bɛ iyi ɑ̀ nɑɑ hɑi Zeruzɑlɛmu. À ni, Bɛɛlizebu, wɑɑtɔ Seetɑm inɛ nɡboi inɛi inɔɔko ŋɑi í wɑ siɛ. Nŋui í muɑ ɡbuɡbɑ̃ wɑ leleò inɛi inɔɔko ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ŋɔi Jesu í kpe ŋɑ í bee ŋɑ ide do mɔndɑ í ni, bɛirei Seetɑm ɑ́ ce ku lele ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bii inɛi bommɑ ɑkɑ̃ ŋɑ ɑ̀ wɑɑ jɑò njɛ, bommɑu bɛ kɑɑ yɔkɔ ku bɔ wɑju mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bii inɛi kpɑsɛ̃ ɑkɑ̃ ŋɑ ɑ̀ wɑɑ jɑò njɛ, kpɑsɛ̃u bɛ kɑɑ yɔkɔ ku bɔ wɑju mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bɛɛbɛ mɔi bii Seetɑm wɑ jɑ do ɑrɑɛ, bommɑɛ ɑ́ kpɛ̃i nɔ kɑɑ bɔ wɑju mɑ́, ɑ́ tɑ̃i. ");
INSERT INTO mkl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Inɛ ɡɔ kɑɑ yɔkɔ ku lɔ kpɑsɛ̃i inɛ iyi í nɛ ɡbuɡbɑ̃ ku coo ile, bii kù jɛ í tɑko í dĩ lɑfɛ̃ɛ. Ammɑ bii í dũu ɑ́ yɔkɔ ku coo ile. ");
INSERT INTO mkl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ntɔ ntɔ ɑn sɔ̃ ŋɛ, ɑlɑbu do dulum ŋɑ iyi ɑmɑnɛ í ce fei, Ilɑɑɔ̃ ɑ́ yɔkɔ ku ceɑ suuru ku kpɑ ideu. ");
INSERT INTO mkl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ammɑ inɛ iyi ɑ́ bu Hundei Ilɑɑɔ̃, Ilɑɑɔ̃ kɑɑ kpɑ idei dulum dii lɑfɛ̃ɛ ɑjɔ kɑ̃mɑ. Dulum dɛɛu ɑ́ mɑɑ wɛɛɑi hee do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu í sɔ̃ ŋɑ bɛɛbɛi si nɑ iyi í jɔ̀ inɛ ŋɑ ɑ̀ wɑɑ ni í nɛ inɛi inɔɔko. ");
INSERT INTO mkl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ŋɔi iyei Jesu do ifɔɛ ŋɑ ɑ̀ to wɑ ɑ̀ wɑɑ leekĩ wɑduude. Nɔ ɑ̀ bɛ inɛ ɡɔ koo kpoo wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wee zɑmɑɑ í bubɑ í kɑɑkoɛ. Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, cɔ, iyeɛ do ifɔɛ ŋɑ ɑ̀ wɑ wɑduude, ɑ̀ wɑɑ kpeɛ. ");
INSERT INTO mkl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ŋɔi Jesu í jɛ nŋɑ í ni, yooi í jɛ iyem, nɔ yoo ŋɑi ɑ̀ jɛ ifɔm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nɔ í cɔ inɛ ŋɑ iyi ɑ̀ bubɑ ɑ̀ kɑɑkoɛu nɔ í ni, iŋɛi ì jɛ iyem do ifɔm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nɔ í ni mɑ́, inɛ iyi wɑ ce idɔɔbii Ilɑɑɔ̃ fei, lɑfɛ̃ɛi í jɛ ifɔm, wɑlɑ wecĩm wɑlɑ iyem. ");
INSERT INTO mkl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ŋɔi Jesu í lɔsi ku cioɑ inɛ ŋɑ idei Ilɑɑɔ̃ mɑ́ kɔkɔi tenkuu. Nɔ zɑmɑɑ nlɑ ɡɔ í nɑɑ í tɔtɔɔ siɛ í kɑɑkoɛ ŋɔi í jɔ̀ í ɡũ ɑkɔi inyiu í bubɑ. Akɔi inyiu í wɑ si tenkuu nɔ zɑmɑɑu fei wɑ leekĩ itĩi tenkuu. ");
INSERT INTO mkl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wɑ kɔ ŋɑ si mii nkpɔ do mɔndɑ. Si bɛi wɑ kɔ ŋɑ si ciou í sɔ̃ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","i sotĩ i ɡbɔ mɔndɑ ɡɔ ŋɑ. Mɔkɔ ɡɔ í fitɑ wɑ fɑ̃ dimi. ");
INSERT INTO mkl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Si bɛi wɑ fɑ̃ dimiu, ŋɔi ɡɔɡɔ ŋɑ ɑ̀ cuku si kpɑ̃ɑ, nɔ yɛi ŋɑ ɑ̀ nɑɑ ɑ̀ jɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nɔ ɡɔɡɔ ŋɑ mɔ ɑ̀ cuku si ilɛ iyi í nɛ kutɑ, tenɡi bii sɑ̃ɑ kù kpɔ. Nɔ í fitɑ bɛ ɡbɑkɑ̃, ɑmmɑ si bɛi sɑ̃ɑ kù lɑ bɛ, ŋɔi í jɔ̀ icɑ̃ɛ kù bɑ ku mi lɛlɛ. ");
INSERT INTO mkl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Iyi inunu wɑ ce, ŋɔi í joo nɔ í ɡbɛ, domi icɑ̃ɛ kù mi lɛlɛ. ");
INSERT INTO mkl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gɔɡɔ ŋɑ mɔ ɑ̀ cuku si inɔ ɑɡũ ŋɑ. Ŋɔi ɑɡũ ŋɑu ɑ̀ dede siɛ ɑ̀ biiɛ, nɔ ɑ̀ ɡɑnjiɛ ku bí. ");
INSERT INTO mkl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nɔ ɡɔɡɔ ŋɑ mɔ ɑ̀ cuku si ilɛ jiidɑ. Ŋɔi ɑ̀ fitɑ ɑ̀ lɑ, ɑ̀ bí jiidɑ. Dimi ɡɔ ŋɑ ɑ̀ so kuntɑɑ, ɡɔɡɔ ŋɑ mɔ kitɑ, ɡɔɡɔ ŋɑ mɔ cĩɔ. ");
INSERT INTO mkl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iyi Jesu í kpɑ mɔndɑu í tɑ̃ ŋɔi í ni, inɛ iyi í nɛ itĩ iyi ɑ́ ɡbɔò ide, ku ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wɑɑti iyi Jesu í kpɑɑ zɑmɑɑu mɔndɑ nkpɔ í tɑ̃ ŋɔi í jɔ̀ inɛ ŋɑu ɑ̀ nɛ. Nɔ inɛ ŋɑ iyi ɑ̀ ɡbe bi tɛɛ do mɔcɔ mɑɑteeji ŋɑu ɑ̀ wɑɑ beeɛ yɑɑsei mɔndɑ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ŋɔi í jɛ nŋɑ í ni, iŋɛi Ilɑɑɔ̃ í jɔ̀ ì mɑ̀ ɑsiii bommɑɛ ŋɑ. Ammɑ inɛ ŋɑ iyi ɑ̀ ɡbe fei ɑ̀ wɑɑ ɡbɔ ideu do mɔndɑi. ");
INSERT INTO mkl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ǹ yɑ n fɔ nŋɑ ide do mɔndɑi ku bɑ “Bɑɑ bii ɑ̀ cɔ ilu ɑ mɑɑ̀ yɛ. Nɔ bɑɑ bii ɑ̀ ɡbɔ ide ɑ kɑɑ mɑ̀ yɑɑseɛ. Bii kù jɛ bɛɛbɛ ɑɑ nɑ ɑ sindɑ wɑ bi Ilɑɑɔ̃, nɔ Ilɑɑɔ̃ ku kpɑ idei dulum du ŋɑ.” ");
INSERT INTO mkl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ŋɔi Jesu í bee ŋɑ mɑ́ í ni, debɛi i kù ɡbɔ yɑɑsei mɔndɑu bɛ ŋɑ? Nɔ bɛirei ɑɑ ce i ɡbɔ yɑɑsei mɔndɑ ŋɑ iyi ɑ̀ ɡbe fei. ");
INSERT INTO mkl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yɑɑseɛ wee. Mɔkɔu, idei Ilɑɑɔ̃i wɑ fɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Inɛ ɡɔ ŋɑ ɑ̀ yɛi bɛi inyɑ ŋɑ bii ideu i cuku si kpɑ̃ɑu. Iyi ɑ̀ ɡbɔ ideu ɡbɑkɑ̃ Seetɑm í nɑɑ í nyɑɑ hɑi si idɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bɛɛbɛ mɔi inɛ ɡɔ ŋɑ ɑ̀ yɛi bɛi inyɑ ŋɑ bii ideu í cuku si ilɛ iyi í nɛ kutɑ. Iyi ɑ̀ ɡbɔ ideu ɡbɑkɑ̃ ɑ̀ ɡbɑɑi do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ammɑ ɑ kù jɔ̀ kù ce icɑ̃ si idɔ nŋɑ. Inɛ dimi bɛɛbɛ ŋɑ ɑ ci yɑ leekĩ ku kpɛ. Wɑɑti iyi ijuukpɑ̃ do wɑhɑlɑ ɡɔ í nɑɑ si ŋɑ nɑ irii idei Ilɑɑɔ̃ ɡbɑkɑ̃, ɑ̀ yɑ fũsi ɑwɔi. ");
INSERT INTO mkl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɛi bɛi dimi ŋɑ iyi ɑ̀ cuku si inɔ ɑɡũ ŋɑ. Aŋɑi ɑ̀ jɛ inɛ ŋɑ iyi ɑ̀ ɡbɔ idei Ilɑɑɔ̃, ");
INSERT INTO mkl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ɑmmɑ lɑsɑbu bututui mii ŋɑ wɑ bitɑndi ŋɑ. Fiɑ ku bi wɑ dĩ iju nŋɑ nɔ ɑ̀ nɛ kɔdɛɛi mii nkpɔ. Mii ŋɑu bɛi wɑ ɡɑnji ideu ku ce icɛ si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɛi bɛi dimi ŋɑ iyi ɑ̀ cuku si ilɛ ncɛɛ. Iyi ɑ̀ ɡbɔ idei Ilɑɑɔ̃ ɑ̀ ɡbɑɑ nɔ wɑ so. Si inɔ nŋɑ inɛ ɡɔ ŋɑ ɑ̀ so kuntɑɑ, inɛ ɡɔ ŋɑ mɔ kitɑ, inɛ ɡɔ ŋɑ mɔ cĩɔ. ");
INSERT INTO mkl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, ɑ ci yɑ mɑ́ fitilɑ ɑ biiɛ do cɑkɑ wɑlɑkɔ ɑ dɑsi ɑbɛ dɑɑyi. Ammɑ si ɑntɑi tɑɑbui ɑ̀ yɑ lesi. Mɑ̀ kù jɛ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mii iyi wɑ mɑnji fei ɑ́ fitɑ ɡbuɡbɑ̃ɑ nɔ ɑsiii ide ɡɔ mɔ kù wɛɛ iyi ɑ kɑ̀ɑ fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Inɛ iyi í nɛ itĩ iyi ɑ́ ɡbɔò ide, ku ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ŋɔi í sɔ̃ ŋɑ mɑ́ í ni, i ce lɑɑkɑi ŋɑ do ide iyi ì ɡbɔ ŋɑ. Si ɡũɑ iyi ì wɑ̃ɑò kpɑɑsi nŋɛ ŋɑ, si bɛi Ilɑɑɔ̃ ɑ́ wɑ̃ɑò iŋɛ mɔ nɔ ku kɔ̃ɔsi mɑ́ ku re bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ǹ wɑ n sɔ̃ ŋɛi, inɛ iyi í nɛ, nŋui ɑ̀ yɑ nɑ mɑ́, ɑmmɑ inɛ iyi kù nɛ, bɑɑ ɑndi iyi í nɛu mɑ́ ɑ̀ yɑ ɡbɑɑi. ");
INSERT INTO mkl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ŋɔi Jesu í fɔ mɑ́ í ni, ide iyi ɑɑ kɑ wɑ̃ò bommɑi Ilɑɑɔ̃ wee. Inɛ ɡɔ í fɑ̃ dimi si ikoɛ. ");
INSERT INTO mkl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Si ɑnyiɛ, bɑɑ bii wɑ sũ wɑlɑkɔ wɑ cɔ ilu, ɑlɛò dɑɑkɔ, wɑɑti kɑ̃mɑ fei dimiu i fitɑ wɑ lɑ. Kù mɑ̀ bɑɑ bɛi wɑ ce. ");
INSERT INTO mkl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ilɛ í yɑ jɔ̀ ɑmɑɑjɛ ku fitɑi do ɑrɑɛ. Í yɑ ce wuɑi titɑ̃, ku bɛi ku ce ɑsĩ nɔ ku bí. ");
INSERT INTO mkl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bii ɑmɑɑjɛu í jĩɑ nɔ ɑ muu do kɔɔmɑ, domi wɑɑtii kumui í to. ");
INSERT INTO mkl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ŋɔi Jesu í fɔ mɑ́ í ni, mii ɑɑ kɑ wɑ̃ò bommɑi Ilɑɑɔ̃. Do mɔndɑ yoomɑi ɑɑ kɑ sisiò yɑɑseɛ. ");
INSERT INTO mkl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Í yɛi bɛi nɡboi mutɑɑdi iyi wɑɑti iyi ɑ̀ wɑɑ ɡbɔ̃ɔ, nŋui í kere í re nɡboi mii ku ɡbɛ̃ fei si ilɛ. ");
INSERT INTO mkl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ammɑ wɑɑti iyi ɑ̀ ɡbɔ̃ɔ ɑ̀ tɑ̃, nŋui í yɑ dede ku lɑ ku re ɑmɑ jĩi fei. Nɔ í yɑ ce ɑmɑɑwɔ nlɑ nlɑ hee yɛi ŋɑ ɑ mɑɑ ce ɑntɛ si ɑmɑɑwɔɛ ŋɑ, nɔ ɑ wɑ si jĩjĩɛ. ");
INSERT INTO mkl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Do mɔndɑ nkpɔ bɛɛbɛi Jesu í kɔ inɛ ŋɑ si cio, zɑkɑ bɛi ɑ̀ yɔkɔ ɑ̀ ɡbɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ci yɑ sɔ̃ ŋɑ ide hɑi nɛ mɔndɑ, ɑmmɑ bii í ɡbe nŋu do mɔcɔɛ ŋɑ í yɑ tusɛ nŋɑi fei. ");
INSERT INTO mkl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Alɛ ɑjɔ nŋu, Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, kɑ bɔ ice ihɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iyi ɑ̀ jɔ̀ zɑmɑɑu í nɛ ŋɔi ɑ̀ lɔ ɑkɔi inyi bii Jesu í tɑko í wɑu ku bɑ ɑ kuɑ ice ɑjɔ. Nɔ ɑkɔ mmu ɡɔ ŋɑ mɔ ɑ̀ wɑɑ too ŋɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ŋɔi fufu nlɑ ɡɔ í dede, í jɔ̀ inyi wɑ lɔ inɔ ɑkɔu hee í mɑɑi ku kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ammɑ Jesu wɑ sĩ njoo si ɑnyii ɑkɔu, í lesi iriɛ si lɛfɛu ɡɔ. Ŋɔi ɑ̀ jũu ɑ̀ beeɛ ɑ̀ ni, Mɛɛtu, kù jɛɛ ide kɑ̃mɑ bii ɑ̀ wɑɑ bi kɑ ce nfe? ");
INSERT INTO mkl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iyi Jesu í jĩ, ŋɔi í lɑ si fufuu, nɔ í sɔ̃ tenkuu í ni, í to bɛɛbɛ, i coko. Nɔ fufuu í leekĩ nɔ inyɑu í coko cɑu. ");
INSERT INTO mkl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ŋɔi Jesu í bee mɔcɔɛ ŋɑ í ni, nɑ mii í ce ì jɔ̀ njo wɑ mu ŋɛ ŋɑ. Mii í ce i kù dɑsim nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ŋɔi njo nlɑ nlɑ wɑ mu ŋɑ nɔ ɑ̀ sɔ̃ njɛ ɑ̀ wɑɑ ni, inɛ dimi yoomɑi ihɛ̃, iyi fufu do inyi fei wɑ jirimɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ŋɔi ɑ̀ to icei tenkuu do ikpɑ ihɔ̃ si ilɛi ilui Zerɑzee. ");
INSERT INTO mkl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nɔ Jesu í kitɑ wɑ hɑi si ɑntɑi ɑkɔi inyiu. Nɔ ɡbɑkɑ̃ inɛ ɡɔ iyi í nɛ inɛi inɔɔko í fitɑ wɑ hɑi ikpɑ bi ku si iku ŋɑ wɑ koo wɑ . ");
INSERT INTO mkl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Bi ku si iku ŋɑi í jɛ ideɛ. Nɔ wee í nɛ ɡbuɡbɑ̃ hee í jɔ̀ inɛ ɡɔ kɑɑ yɔkɔ ku dũu, bɑɑ do sesee. ");
INSERT INTO mkl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","À yɑ dɑɑ si kpɛmkpɛm, nɔ ɑ dĩ isɛɛ do sesee ɑmmɑ í yɑ dɑ seseeui nɔ ku cɛ kpɛmkpɛm nɔu. Wee, inɛ ɡɔ kù nɛ ɡbuɡbɑ̃ iyi ɑ́ yɔkɔ ku nɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wɑɑti kɑ̃mɑ fei, dɑsɑ̃ do idũ, si ɑninii iri kutɑ ŋɑ do bi ku si iku ŋɑi í yɑ wɑ ku mɑɑ dɔ̃ ɑnu, nɔ ku mɑɑ mɛɛ ɑrɑɛ do kutɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Iyi í yɛ Jesu wɑ hɑi jĩijĩ ŋɔi í sɛi, í koo í ɡulɛ si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ŋɔi í dɔ̃ ɑnu hee lele í ni, mii í wɑ ɑninii ɑwɑɛ, Jesu, ɑwɔ Amɑi Ilɑɑɔ̃. Ilɑɑɔ̃ í re fei, nɔ ǹ wɑ n tɔɔɛ do iriɛ, mɑɑ̀ wɑhɑlɑm. ");
INSERT INTO mkl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Í fɔ bɛɛbɛ si nɑ iyi í jɔ̀ Jesu í ni inɛi inɔɔkou kú fitɑ siɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nɔ Jesu í beeɛ í ni, irei iriɛ. Ŋɔi í jɛɑɑ í ni, irim nii Zɑmɑɑ, domi ɑ̀ kpɔ. ");
INSERT INTO mkl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ŋɔi í tɔɔ Jesu suuru ku mɑɑ̀ nyɔ ɑŋɑ ikpɑ ɑnɡule. ");
INSERT INTO mkl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wee ɑ̀ yɛ kusɔɔ ɡɑɑ ŋɑ ɑ̀ wɑɑ jɛ ikpɑ iri kutɑu bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ŋɔi inɛi inɔɔko ŋɑu ɑ̀ tɔɔ Jesu ɑ̀ ni, jɔ̀ kɑɑ mu kusɔɔ ŋɑu ihɔ̃, ku bɑ kɑ mɑɑ wɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nɔ Jesu í yɔɔdɑ nŋɑ. Ŋɔi ɑ̀ fitɑ hɑi si inɛɛu ɑ̀ koo ɑ̀ mu kusɔɔ ŋɑu ɑ̀ tɑle si ŋɑ hɑi ɑntɑi iri kutɑu ɑ̀ dɑsi inyi nɔ inyiu í jɛ ŋɑ. Kukpɔ nŋɑ í to dubu minji (2.000). ");
INSERT INTO mkl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Woo deɡbe kusɔɔ ŋɑu ɑ̀ sɑ ɑ̀ koo ɑ̀ wɑɑ sisi lɑɑbɑɑui ideu si ilu nlɑu do si ilɛɛko ŋɑ. Nɔ inɛ ŋɑ ɑ̀ fitɑ ɑ̀ bɔ ku cɔ mii iyi í ceu. ");
INSERT INTO mkl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iyi ɑ̀ nɑɑ bi Jesu, ɑ̀ yɛ inɛ iyi í tɑko í nɛ inɛi inɔɔko bututuu í bɑɑ si lɑɑkɑɛ í dɑsi jĩnɛ ŋɑ wɑ bubɑ. Ŋɔi ɑ̀ biti, njo í mu ŋɑ jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Inɛ ŋɑ iyi ideu í ce iju nŋɑ ɑ̀ wɑɑ sisiɑ inɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nɔ inɛ ŋɑu ɑ̀ tɔɔ Jesu ku fitɑ hɑi ilɛi ilu nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wɑɑti iyi Jesu wɑ lɔ ɑkɔi inyiu, ŋɔi inɛ iyi í tɑko í nɛ inɛi inɔɔko ŋɑu wɑɑ tɔɔɛ í ni ku jɔ̀ nŋu ku tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ammɑ Jesu í kɔ. Nɔ í sɔ̃ɔ í ni, bɔ kpɑsɛ̃ɛ bi inɛɛ ŋɑ koo sɔ̃ ŋɑ mii iyi Lɑfɛ̃ɛ í ceɛ, do yɑɑse bɛi í ce ɑrɑɑreɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ŋɔi inɛɛu í nɛ, í wɑsi ku sisiɑ inɛi ilɛ iyi ɑ̀ yɑ kpe Ilu Mɛɛwɑ ŋɑu mii iyi Jesu í ceɑ nŋu fei. Ŋɔi ɑŋɑ fei ɑ̀ biti jiidɑ jiidɑ. Nɔ Jesu mɔ í dede wɑ hɑi bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu í bɑɑ hɑi ice ikpɑ ihɔ̃ do ɑkɔi inyiu. Í wɑ itĩi tenkuu bɛ nɔ zɑmɑɑ nlɑ ɡɔ í nɑɑ í tɔtɔɔ bi tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ŋɔi inɛ ɡɔ í nɑɑ bi tɛɛ. À yɑ kpoo Zɑirusi. Inɛ nɡboi ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔi. Iyi í yɛ Jesu, ŋɔi í sɛɛbɑtɑ si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ŋɔi í tɔɔɛ ku sobi nŋu í ni, ɑmɑ inɑɑbom wɑ bi ku ku. Ǹ wɑ n tɔɔɛ, i nɑɑ i lesiɛ ɑwɔ, nɔ ku bɑ iri ku mɑɑ wɛɛ bɑɑni. ");
INSERT INTO mkl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ŋɔi ɑŋɑò Jesu ɑ̀ wɑɑ nɛ. Nɔ zɑmɑɑ nlɑ ɡɔ wɑ tooɛ hee ɑ̀ wɑɑ mɑnteɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wee si inɔi inɛ ŋɑu inɑɑbo ɡɔ í wɑ bɛ iyi wɑ ce bɔ̃ɔi ɑwɔ ku mu hɑi ɑdɔ̃ mɑɑteeji wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Í wɑhɑlɑ jiidɑ si ɑwɔi lokotoro nkpɔ hee ɑndi fiɑ iyi í nɛ fei í jɔɔ, kù nɔ kù ce bɑɑ dɑɑmɑ, ɑmmɑ bɔ̃ɔɛu í teese wɑ kɔ̃ɔsii. ");
INSERT INTO mkl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Abou í ɡbɔ lɑɑbɑɑui Jesu wo, ŋɔi í jɔ̀ í nɑɑ do ɑnyiɛ si inɔi zɑmɑɑu í lu jɑɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Í ce bɛɛbɛi domi í fɔ si idɔɛ í ni, bɑɑ bii jɑɑɛi ǹ lu ɑn bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ŋɔi ɡbɑkɑ̃ bɔ̃ɔi ɑwɔ ku muɛu í leekĩ. Ŋɔi í ɡbɔ fufui bɑɑni si ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ŋɔi Jesu í mɑ̀ ɡbɑkɑ̃ iyi ɡbuɡbɑ̃ ɡɔ í fitɑ hɑi si ɑrɑi nŋu nɔ í sindɑ wɑ cɔ zɑmɑɑu nɔ í ni, yooi í lu jɑɑɛm. ");
INSERT INTO mkl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ŋɔi mɔcɔɛ ŋɑ ɑ̀ sɔ̃ɔ ɑ̀ ni, debɛi i kù wɑɑ yɛ zɑmɑɑ iyi wɑ mɑnteɛi, nɔ ì wɑɑ ni yooi í luɛ? ");
INSERT INTO mkl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ŋɔi Jesu í sindɑ í cɔ inɛ ŋɑu ku bɑ ku yɛ inɛ iyi í ce bɛɛbɛu. ");
INSERT INTO mkl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ŋɔi ɑbou wɑ yɑyɑ do njo, domi í mɑ̀ mii iyi nŋu í ce. Ŋɔi í nɑɑ í ɡulɛ si wɑjuɛ í sɔ̃ɔ ntɔ si mii iyi í bɑ nŋu fei. ");
INSERT INTO mkl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nɔ Jesu í sɔ̃ɔ í ni, ɑbooyi, nɑɑnɛɛi í fɑɑbɑɛ. Koo wɛɛ si lɑɑkɑɛ, ì bɑ iri si bɔ̃ɔɛu mbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Si bɛi Jesu wɑ fɔ ideu, inɛ ɡɔ ŋɑ ɑ̀ nɑɑ hɑi kpɑsɛ̃i Zɑirusi inɛ nɡbou, ɑ̀ sɔ̃ɔ ɑ̀ ni, ɑmɑ inɑɑboɛu í ku. Mɑɑ̀ wɑhɑlɑ Mɛɛtu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ammɑ Jesu kù dɑsi ide nŋɑu. Nɔ í sɔ̃ Zɑirusi í ni, mɑɑ̀ jɔ̀ ziɡiɛ ku dɑ, ɑwɔ de dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ŋɔi í ni inɛ ɡɔ ku mɑɑ̀ si nŋu kpɑsɛ̃i Zɑirusi wɑ bii kù jɛ Piɛɛ do Zɑɑki, do Zɑ̃ɑ ifɔi Zɑɑki. ");
INSERT INTO mkl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Iyi ɑ̀ to nɔ Jesu í yɛ zɑmɑɑ nlɑ ɡɔ bɛ ɑ̀ wɑɑ cɑ̃ kpokpoo, ɑ̀ wɑɑ kpɑtɑ ɑ̀ wɑɑ dɔ̃ ɑnu nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ŋɔi í lɔ kpɑsɛ̃u í bee ŋɑ í ni, nɑ mii í ce ì wɑɑ dɔ̃ ɑnu bɛɛbɛ ŋɑ. Nɑ mii í jɔ̀ ì wɑɑ kpɑtɑ ŋɑ. Amɑu kù ku mɛɛ, wɑ sĩ njooi. ");
INSERT INTO mkl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nɔ ɑ̀ wɑɑ yɑɑkoɛ. Ŋɔi Jesu í jɔ̀ ɑŋɑ fei ɑ̀ fitɑ, í ɡbe bɑɑu do iyei ɑmɑu do mɔcɔ mɛɛtɑ ŋɑ iyi ɑ̀ suu wɑu, ŋɔi ɑ̀ lɔ bii ɑmɑu í wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ŋɔi Jesu í mu ɑwɔi ɑmɑu í fɔ do feeɛ í ni, tɑlitɑ kumi, wɑɑtɔ ɑmɑ inɑɑbo, dede. Amui, ǹ sɔ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ŋɔi ɡbɑkɑ̃ ɑmɑ inɑɑbou í dede nɔ wɑ nɛ. Í nɛ zɑkɑi ɑdɔ̃ mɑɑteeji. Iyi inɛ ŋɑu ɑ̀ yɔɔ ŋɔi ɑ̀ biti ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ŋɔi Jesu í sɔ̃ ŋɑ í ni ɑ nɑ́ɑ ijɛ ku jɛ. Nɔ í sɔ̃ ŋɑ mɑ́ do kuɡɑɑbu í ni ɑ mɑɑ̀ jɔ̀ inɛ ɡɔ ku ɡbɔ ideu. ");
INSERT INTO mkl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ŋɔi Jesu í nɛ hɑi kpɑsɛ̃i Zɑirusi bɛ í bɔ ilu bii í jɛ ɑmɑ. Nɔ mɔcɔɛ ŋɑ ɑ̀ suu. ");
INSERT INTO mkl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iyi ɑjɔi kusĩmi í nɑɑ ŋɔi í lɔsi ku sisiɑ inɛ ŋɑ ide ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu. Ŋɔi inɛ nkpɔ nkpɔ í ɡbɔ ideu nɔ ɑ̀ biti ɑ̀ wɑɑ ni, hɑi iwoi nŋu í bɑ dimii lɑsɑbu jiidɑu bɛ. Dimii bisi yoomɑi ɑ̀ muɑ nŋu. Bɛirei í ce wɑ ce dimii mɑɑmɑɑkeu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kù jɛ woo ɡbe jĩi nɔu mbɛ yɑ, ɑmɑi Mɑɑriu mɛɛ. Mɑ̀ kù jɛ iɡbɑ̃i Zɑɑki do Zozee, do Zudu do Simɔɔ mbɛ bɑ. Nɔ wecĩɛ ŋɑ ɑ kù wɑ inɔ nwɑ ihɛ̃? To, lɑsɑbu nŋu ŋɑu bɛi wɑ ɡɑnji ŋɑ ɑ dɑsiɛò nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, kù nɛ bii wɑlii ci yɑ nɛ bɛɛrɛ bii kù jɛ si ilɛi ideɛ do si inɔi inɛɛ ŋɑ do kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Ŋɔi Jesu í biti domi ɑ kù dɑsiɛ nɑɑnɛ. Bɛɛbɛi kù yɔkɔ kù ce mɑɑmɑɑke bɛ, bii kù jɛ bɔ̃ɔ ɡɔ ŋɑ iyi í lesi ɑwɔ nɔ ɑ̀ bɑ iri. Si ɑnyiɛ, Jesu í yɑ mɑɑ dɑbii dɑbii si ilɛɛko ŋɑu ku mɑɑ sisiɑ inɛ ŋɑ idei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ŋɔi í kpe woo bɛ mɑɑteejiɛ ŋɑu nɔ í bɛ ŋɑ minji minji, í mu nŋɑ ɡbuɡbɑ̃ ɑ leleò inɛi inɔɔko ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Í sɔ̃ ŋɑ í ni, i mɑɑ̀ so nkɑ̃mɑ si isɛɛnɛ nŋɛu. I mɑɑ̀ so ijɛ hee mɑ́ jɛ bɔɡɔ, hee mɑ́ jɛ fiɑ, í ɡbe ɡolo. ");
INSERT INTO mkl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","I dɑsi bɑɑtɑ nŋɛ ɑmmɑ i mɑɑ̀ kpele ibɔ minji. ");
INSERT INTO mkl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ŋɔi í sɔ̃ ŋɑ mɑ́ í ni, bii ì to ilu bii ì wɑɑ bɔ ŋɑ, i wɑ kpɑsɛ̃ bii ɑ̀ dɑsi ŋɛ hee i koo i nɛò hɑi ilu bɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bii í jɛ bii ɡɔ ŋɑ inɛ ŋɑ ɑ kù ɡbɑ ŋɛ hee mɑ́ jɛ ɑ ɡbɔ ide nŋɛ, i fitɑ hɑi bɛ ŋɑ, nɔ i ɡbuɡbɑ̃ nŋɑ irurui bɑɑtɑ nŋɛ ŋɑ ku bɑ ku jɛ nŋɑ sɛɛdɑ iyi kiitii Ilɑɑɔ̃ ɑ́ nɑɑ si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nɔ mɔcɔ ŋɑu ɑ̀ nɛ nɔ ɑ̀ wɑɑ wɑɑzoɑ inɛ ŋɑ ɑ̀ wɑɑ ni ɑ kpɑɑsi idɔ. ");
INSERT INTO mkl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nɔ ɑ̀ lele inɛi inɔɔko nkpɔ nkpɔ, nɔ ɑ̀ yɑ tontooɑ bɔ̃ɔ nkpɔ nkpɔ ikpo si iri. Nɔ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ilɑɑlu Herodu í ɡbɔ bɑɑui Jesu, si nɑ iyi í jɔ̀ iriɛ í fɑnɡɑɑ bii fei. Nɔ inɛ ɡɔ ŋɑ ɑ̀ niɑ Jesu, Zɑ̃ɑ woo dɑsi inyiui í jĩ hɑi si bɑlɛ. Nɑ ŋɔi í jɔ̀ í nɛ ɡbuɡbɑ̃ wɑ ceò mɑɑmɑɑke. ");
INSERT INTO mkl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Inɛ ɡɔ ŋɑ mɔ ɑ̀ wɑɑ niɑ Jesu, Elii wɑlii nlɑi tɑkoui. Nɔ inɛ ɡɔ ŋɑ mɔ ɑ̀ wɑɑ niɑɑ, nŋu mɔ wɑliii bɛi ti tɑko ŋɑui. ");
INSERT INTO mkl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ammɑ iyi Herodu í ɡbɔ ideu ŋɔi í ni, Zɑ̃ɑ woo dɑsi inyiui. Ǹ jɔ̀ ɑ̀ bu iriɛ wo. Debɛi nŋui í jĩ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mii iyi í jɔ̀ Herodu wɑ fɔ bɛɛbɛ wee. Hɑi tɑko Herodu tɑkɑɛ í ni ɑ mu Zɑ̃ɑ ɑ dũu ɑ dɑsiɛ piisɔ̃ɔ nɑ ku tũò idɔi Herodiɑsi. Wee Herodu í tɑko í so Herodiɑsi ɑboi Filipu, ifɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ŋɔi Zɑ̃ɑ í sɔ̃ɔ í ni, kù sĩɑ i ɡbɑ ɑboi ifɔɛ i dɑsi kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nɑ ŋɔi í jɔ̀ Herodiɑsi wɑ mu Zɑ̃ɑ do idɔɔkɔ̃. Wɑ bi ku kpɑɑ ɑmmɑ kù bɑ kpɑ̃ɑ ");
INSERT INTO mkl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","si nɑ iyi í jɔ̀ Herodu í mɑ̀ bɛɛrɛi Zɑ̃ɑ. Bii wɑ ɡbɔ ideɛ idɔɛ í yɑ dedei, ɑmmɑ do nŋu fei í yɑ bi nŋu ku ɡbɔɔ. Í mɑ̀ iyi ɑmɑnɛ dee deei nɔ kuwɛɛɛ kù nɛ tɑɑle kɑ̃mɑ. Nɑ ŋɔi í jɔ̀ í bii ɑnyiɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Do nŋu fei, ɑjɔ nŋu ɡɔ Herodiɑsi í bɑ kpɑ̃ɑɛ. Ajɔ nŋu Herodu í nyɑ jinɡɑu nlɑ nlɑ ku yeò ɡiɡii ɑjɔi kubíɛ. Ŋɔi í kpe ɑkɑwe nlɑɛ ŋɑ do inɛ nɡboi sooɡeɛ ŋɑ, do inɛ nɡboi ilɛi Gɑlilee ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ŋɔi ɑmɑ inɑɑboi Herodiɑsi í lɔ ileu wɑ jojo, ŋɔi í dɔ̃ɑ Herodu si do inɛɛ ŋɑ iyi í kpe wɑ ŋɑu fei. Ŋɔi Herodu í sɔ̃ mudɛ̃ɛu í ni, tɔɔm mii iyi ì bi fei, ɑn muuɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nɔ í ɡbɑsi do mii fei í ni, mii iyi ì tɔɔm fei, ɑn muuɛ, bɑɑ bii í jɛ bubui bommɑm nii. ");
INSERT INTO mkl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ŋɔi ɑmɑ inɑɑbou í koo í bee iyeɛ í ni, mii í jɔ n tɔɔɛ. Ŋɔi iyeɛ í jɛ í ni, tɔɔɛ irii Zɑ̃ɑ woo dɑsi inyiu. ");
INSERT INTO mkl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ŋɔi ɡbɑkɑ̃ ɑmɑ inɑɑbou í nɑɑ bi ilɑɑluu í sɔ̃ɔ í ni, ǹ bi i muum irii Zɑ̃ɑ woo dɑsi inyiu nsɛi nsɛi si pɛrɛnti. ");
INSERT INTO mkl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bɑɑ do iyi inɔi ilɑɑluu í fɔ ntɔ ntɔ fei kù bi ku kɔɔ, si nɑ iyi í jɔ̀ í ɡbɑsi do mii fei si wɑjui inɛ njooɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ŋɔi ɡbɑkɑ̃ í bɛ sooɡe ɡɔ koo bù irii Zɑ̃ɑ woo dɑsi inyiu wɑ. Ŋɔi sooɡeu í koo í bu irii Zɑ̃ɑ wɑ hɑi ile piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nɔ í nɑɑò wɑ si pɛrɛntiu í nɑɑ í nɑ ɑmɑ inɑɑbou. Nɔ ɑmɑ inɑɑbou mɔ í koo í nɑ iyeɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Iyi mɔcɔi Zɑ̃ɑ ŋɑ ɑ̀ ɡbɔ iyi í ku, ŋɔi ɑ̀ nɑɑ ɑ̀ soo ɑ̀ koo ɑ̀ suu. ");
INSERT INTO mkl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nɔ woo bɛ mɑɑteeji ŋɑ iyi Jesu í tɑko í bɛ ŋɑu ɑ̀ bɑɑ bi tɛɛ ɑ̀ wɑɑ sisiɑɑ mii ŋɑ iyi ɑŋɑ ɑ̀ ce fei do cio iyi ɑ̀ kɔ inɛ ŋɑ si fei. ");
INSERT INTO mkl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nɔ inɛ ŋɑ ɑ̀ wɑsi ku nɑɑ ku nɛ hee Jesu do mɔcɔɛ ŋɑ ɑ kù bɑ fɑyɑi ku jɛ. Nɑ ŋɔi í jɔ̀ í sɔ̃ ŋɑ í ni, i jɔ̀ kɑ nyɑ ɑrɑ nwɑ kɑ bɔ ikpɑ ɡbɑbuɑ ku bɑ i sĩmi keeke ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ŋɔi ɑ̀ jɔ̀ inɛ ŋɑu bɛ, nɔ ɑ̀ koo ɑ̀ lɔ ɑkɔi inyiu ɑ̀ bɔ ikpɑ ɡbɑbuɑu. ");
INSERT INTO mkl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ammɑ inɛ nkpɔ í yɛ ŋɑ wɑɑti iyi ɑ̀ wɑɑ nɛ, nɔ ɑ̀ mɑ̀ ŋɑ. Ŋɔi ɑ̀ mɑ̀ tenɡi bii ɑ̀ wɑɑ bɔu. Nɔ inɛ ŋɑ ɑ̀ sɛi wɑ do isɛ hɑi ilu ŋɑ fei ɑ̀ cuɑ nŋɑ tenɡi bii ɑ̀ wɑɑ bɔu. ");
INSERT INTO mkl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iyi Jesu í to wɑ ŋɔi í fitɑ hɑi inɔ ɑkɔu. Nɔ í yɛ zɑmɑɑ nkpɔu. Ŋɔi í ce ɑrɑɑre nŋɑ, domi ɑ̀ yɛi bɛi ɑnɡudɑ̃ ŋɑ iyi ɑ kù nɛ woo deɡbe. Ŋɔi í lɔsi ku kɔ nŋɑ si cio nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Si bɛi ɑlɛ wɑ lɛ, ŋɔi mɔcɔɛ ŋɑ ɑ̀ nɑɑ bi tɛɛ ɑ̀ ni, inyɑu wee ɡbɑbuɑi, nɔ idũ wɑ dũ. ");
INSERT INTO mkl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nɑ nŋu, dɑ inɛ ŋɑu ɑ bɔ ilɛɛko ŋɑ do inɔ ilu ŋɑ iyi ɑ̀ wɑ ɑmɛɛ, ku bɑ ɑ koo ɑ rɑ mii iyi ɑɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ammɑ í sɔ̃ ŋɑ í ni, iŋɛ tɑkɑ nŋɛ i nɑ ŋɑ ijɛ ɑ jɛ. Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, i kù mɑ̀ bɑɑ bii ɑ̀ so fiɑi icɛi cukpɑ mɛɛjɔ, kɑɑ to kɑ rɑ nŋɑ pɛ̃ɛ kɑ nɑ ŋɑ ɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ŋɔi Jesu í bee ŋɑ í ni, pɛ̃ɛ fɛloi ì nɛ ŋɑ. I koo i cɔ wɑ. Iyi ɑ̀ koo ɑ̀ cɔ, ŋɔi ɑ̀ ni, pɛ̃ɛ miui ɑ̀ nɛ do cɛ̃ɛ minji. ");
INSERT INTO mkl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nɔ Jesu í sɔ̃ mɔcɔɛ ŋɑu í ni ɑ jɔ̀ inɛ ŋɑu ɑ bubɑ si fɔfɔ tũtũu bɛ ikɑ̃ ikɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ŋɔi ɑ̀ bubɑ ikɑ̃ ikɑ̃, tuubɑ ɡɔ ŋɑ ɑmɑnɛ cĩɔ, tuubɑ ɡɔ ŋɑ mɔ ɑmɑnɛ ciitɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ŋɔi Jesu í so pɛ̃ɛ miuu do cɛ̃ɛ minjiu, nɔ í wu iju lele í sɑɑbu Ilɑɑɔ̃. Ŋɔi í bububu pɛ̃ɛu nɔ í nɑ mɔcɔ ŋɑu ɑ kpɛ̃ɑ zɑmɑɑu. Nɔ í kpɛ̃ nŋɑ cɛ̃ɛ minjiu mɔ inɛ fei í bɑ. ");
INSERT INTO mkl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aŋɑ fei ɑ̀ jɛ ɑ̀ yo. ");
INSERT INTO mkl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ŋɔi ɑ̀ ko pɛ̃ɛ do cɛ̃ɛ bubu iyi í ɡbeu kɔlɔ mɑɑteeji í kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Inɛmɔkɔ ŋɑ iyi ɑ̀ jɛ pɛ̃ɛu ɑ̀ wɛɛi ɑmɑnɛ dubu miu (5.000) bɑ̀kɑ̀ inɑɑbo do ɑmu ŋɑ bɑɑsi. ");
INSERT INTO mkl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iyi ɑ̀ tɑ̃ ɡbɑkɑ̃ ŋɔi Jesu í jɔ̀ mɔcɔɛ ŋɑu ɑ̀ lɔ ɑkɔi inyiu ku bɑ ɑ tɑkoɛ ɑ kuɑ ice ihɔ̃, ikpɑ Bɛsɑidɑ. Iyi ɑ̀ wɑɑ nɛ nɔ í ni zɑmɑɑu ku nɛ. ");
INSERT INTO mkl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wɑɑti iyi í jɔ̀ ɑ̀ nɛ ŋɔi í koo í ɡũ iri kutɑ ɡɔ ku bɑ ku ce kutɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nɔ í wɑ bɛ hee idũ í koo í dũ, nɔ ɑkɔi inyiu í wɑ si ɑninii tenkuu do mɔcɔ ŋɑu nɔ Jesu mɔ í wɑ ilɛ nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Í yɛ mɔcɔɛ ŋɑu ɑ̀ wɑ si wɑhɑlɑi ku wɑi ɑkɔi inyiu, domi fufuu wɑ kò ŋɑ. Zɑkɑi ɑmɛɛjumɑ́ ŋɔi í mɑɑi si ŋɑ, wɑ nɛ si ɑntɑi inyiu wɑ bi ku cuɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ammɑ wɑɑti iyi ɑ̀ yɔɔ wɑ nɛ si ɑntɑi tenkuu ŋɔi ɑ̀ tɑmɑɑ bɛi zĩii, ŋɔi ɑ̀ wɑɑ dɔ̃ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Aŋɑ fei ɑ̀ yɔɔ ŋɔi njo wɑ mu ŋɑ. Ŋɔi ɡbɑkɑ̃ Jesu í bɑ ŋɑ ide ku fɔ í sɔ̃ ŋɑ í ni, i sũ lɑɑkɑi nŋɛ ŋɑ. Amui Jesu, i mɑɑ̀ ce njo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ŋɔi í lɔ inɔ ɑkɔu í bɑ ŋɑ bɛ, nɔ fufuu í leekĩ. Ŋɔi ziɡi nŋɑ fei í dɑ ɑ̀ biti hee, ");
INSERT INTO mkl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","domi ɑ kù ɡbɔ yɑɑsei mɑɑmɑɑkei pɛ̃ɛu si nɑ iyi í jɔ̀ idɔ nŋɑ í le. ");
INSERT INTO mkl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iyi ɑ̀ kuɑ tenkuu ɑ̀ tɑ̃ ŋɔi ɑ̀ to ilɛi Genesɑrɛti ɑ̀ koo ɑ̀ dĩ ɑkɔ nŋɑ bi ku leekĩu. ");
INSERT INTO mkl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wee inɛ ɡɔ ŋɑ ɑ̀ wɑ bɛ. Iyi Jesu do mɔcɔɛ ŋɑ ɑ̀ fitɑ hɑi si ɑkɔu ɡbɑkɑ̃ ŋɔi inɛ ŋɑu ɑ̀ mɑ̀ Jesu. ");
INSERT INTO mkl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ŋɔi ɑŋɑ fei ɑ̀ sɛi ɑ̀ wɑɑ nɑɑò bɔ̃ɔ ŋɑ wɑ hɑi inɔ ilu ŋɑ. À yɑ so ŋɑ wɑi si sɛ̃ɛ ŋɑ ɑ nɑɑò ŋɑ wɑ tenɡi bii ɑ̀ ɡbɔ í wɑu. ");
INSERT INTO mkl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bii Jesu í to fei, hɑi ilɛɛko ŋɑ do ilu nlɑ ŋɑ do iko bii inɛ ŋɑ ɑ̀ wɑɑ sũ fei, ɑ̀ yɑ mɑɑ nɑɑò bɔ̃ɔ ŋɑ wɑi si bɑntumɑ bii í wɑu. Ŋɔi ɑ̀ yɑ tɔɔɛ ku jɔ̀ ɑŋɑ ɑ lu bɑɑ itĩi kumbooɛ. Nɔ inɛ ŋɑ iyi ɑ̀ luu fei ɑ̀ yɑ bɑ irii. ");
INSERT INTO mkl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ŋɔi Fɑrisi ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ɡɔɡɔ ŋɑ ɑ̀ nɑɑ hɑi Zeruzɑlɛmu nɔ ɑ̀ tɔtɔɔ kɔkɔi Jesu. ");
INSERT INTO mkl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ŋɔi ɑ̀ yɛ mɔcɔɛ ɡɔ ŋɑ ɑ̀ wɑɑ jɛ do ɑwɔ riisi, wɑɑtɔ ɑ kù wɔɔ si bɛi ɑ̀ yɑ ce si dedembɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wee Fɑrisi ŋɑ do Zuifu ŋɑ iyi ɑ̀ ɡbe fei, ɑ̀ wɑɑ too dedembɑi bɑlɑ nŋɑ ŋɑ. Bii kù jɛ ɑ̀ wɔɔ sɑ̃ɑ sɑ̃ɑ ɑ ci yɑ jɛ nɡɔɡɔ. ");
INSERT INTO mkl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bɛɛbɛ mɔi, bii ɑ̀ bɑɑ hɑi ɑjɑ nɔ ɑ kù wɔɔ ɑ ci yɑ jɛ. Mii nkpɔ nkpɔi ɑ̀ yɑ ce mɑ́ iyi í jɛ dedembɑ nŋɑ. Mii ŋɑu ɡɔɡɔ ŋɑ wee, kɔɔfu ku wiɛ do boonyi do cɑkɑi isɔ nkpɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","To, si bɛi Fɑrisi ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ yɛ mɔcɔ ŋɑu ɑ̀ wɑɑ jɛò ɑwɔ riisi ŋɔi í jɔ̀ ɑ̀ bee Jesu ɑ̀ ni, nɑ mii í ce mɔcɔɛ ŋɑ ɑ kù wɑɑ too dedembɑi bɑlɑ nwɑ ŋɑ. Nɑ mii í jɔ̀ ɑ̀ yɑ jɛ do ɑwɔ riisi. ");
INSERT INTO mkl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nɔ Jesu í jɛ nŋɑ í ni, iŋɛ ilu muɑfiti ŋɑ, hɑi tɑko Ezɑi í ce wɑliiɛi dee dee nɑ iri nŋɛ wɑɑti iyi í kɔ si tiɑɛ í ni, “Ilɑɑɔ̃ í ni, Inɛ ŋɑu ihɛ̃ ɑ̀ wɑɑ ceem bɛɛrɛi do ɡɛlɛ nŋu ɑkɑ̃. Ammɑ idɔ nŋɑ í jĩim. ");
INSERT INTO mkl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kutɔɔ iyi ɑ̀ wɑɑ ceem nɡbɛi, Domi woodɑi ɑmɑnɛ ŋɑi ɑ̀ wɑɑ kɔ inɛ ŋɑ si nɔ ɑ̀ wɑɑ ni woodɑm nii.” ");
INSERT INTO mkl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, ì wɑɑ jɔ̀ woodɑi Ilɑɑɔ̃ ŋɑ nɔ ì wɑɑ too dedembɑi ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Do ntɔ í wɑɑ kpɑ woodɑi Ilɑɑɔ̃ ŋɑi ku bɑ i sɑ̃si dedembɑ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moizi í ni, “i jirimɑ iyeò bɑɑ nŋɛ ŋɑ”. Nɔ í ni mɑ́, “inɛ iyi wɑ fɔ lɑɑlɔi iyeò bɑɑɛ ŋɑ, ɑ kpɑ lɑfɛ̃ɛ.” ");
INSERT INTO mkl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ammɑ iŋɛ, ì wɑɑ fɔ ide mmu. Ì wɑɑ ni inɛ ɑ́ yɔkɔ ku sɔ̃ iyeò bɑɑɛ ku ni fiɑ iyi nŋu ɑ́ sobi ŋɑ do, ti Ilɑɑɔ̃i. Fiɑui ì wɑɑ kpe kɔɔbɑ̃ɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nɔ bii inɛ í dɔ̃ bɛɛbɛ, i kɑɑ nɑ́ɑ kpɑ̃ɑ ku sobiò iyeò bɑɑɛ mɑ́ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bɛɛbɛ, ì wɑɑ kpɑ idei Ilɑɑɔ̃ ŋɑ nɔ ì wɑɑ too dedembɑ iyi ɑ̀ jɔ̀ nŋɛ ŋɑ. Nɔ ì wɑɑ ce mii lɑɑlɔ nkpɔ mɑ́ iyi í jɔ dimi bɛɛbɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ŋɔi Jesu í kpe zɑmɑɑu mɑ́ bi tɛɛ ŋɔi í sɔ̃ ŋɑ í ni, iŋɛ fei i sotĩ i ɡbɔ yɑɑsei idem ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nkɑ̃mɑ kù wɛɛ iyi ɑ́ lɔ do ɡɛlɛi ɑmɑnɛ ku dɑsiɛ riisi. Ammɑ iyi ɑ́ fitɑ hɑi si idɔi ɑmɑnɛ, nŋui ɑ́ dɑsiɛ riisi.  ");
INSERT INTO mkl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Inɛ iyi í nɛ itĩ iyi ɑ́ ɡbɔò ide, ku ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ŋɔi Jesu í nyɑ ɑrɑɛ hɑi bi zɑmɑɑu í koo í lɔ kpɑsɛ̃. Wɑɑti iyi í lɔ kpɑsɛ̃u ŋɔi mɔcɔɛ ŋɑu ɑ̀ beeɛ yɑɑsei mɔndɑu. ");
INSERT INTO mkl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ŋɔi í bee ŋɑ í ni, i kù nɛ bisi ŋɑi? I kù mɑ̀ ŋɑ mii iyi ɑ́ lɔ inɔi ɑmɑnɛ hɑi wɑduude kɑɑ dɑsiɛ riisi? ");
INSERT INTO mkl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kɑɑ dɑsiɛ riisi, domi ijɛ kɑɑ lɔ si idɔi inɛ bii kù jɛ si inɔɛ, nɔ ku yɔ́ ku bɛi ku fitɑ. Jesu í fɔ bɛɛbɛi ku bɑ ku sɔ̃ ŋɑ iyi ijɛ kɑ̃mɑ kù jɛ ìwɔ̀. ");
INSERT INTO mkl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nɔ í ni mɑ́, mii iyi wɑ fitɑ hɑi si idɔi ɑmɑnɛi í yɑ dɑsiɛ riisi, ");
INSERT INTO mkl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","domi hɑi si idɔi ɑmɑnɛi lɑsɑbu lɑɑlɔ do icu ku ko, do ile ku ce, do inɛ ku kpɑ, ");
INSERT INTO mkl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","do sɑkɑrɑ, do kɔdɛɛ, do inɔ ku kɑ̃, do tɑkii, do dɑɑ iyi í lɔ zɑkɑ, do iɡu, do funɛi inɛ ku nyɑ, do fɑɑo, do idɔ ku le í yɑ fitɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mii lɑɑlɔ ŋɑu bɛ fei hɑi si idɔi ɑmɑnɛi wɑ fitɑ nɔ ɑŋɑi ɑ̀ yɑ dɑsi inɛ riisi. ");
INSERT INTO mkl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi í dɑsi kpɑ̃ɑ í bɔ ilɛɛkoi Tii, ŋɔi í lɔ kpɑsɛ̃ ɡɔ. Wee kù wɑɑ bi inɛ ɡɔ ku mɑ̀, ɑmmɑ kɑɑ yɔkɔ ku mɑnji. ");
INSERT INTO mkl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Abo ɡɔ í wɑ bɛ, ɑmɑ inɑɑboɛ í nɛ inɛi inɔɔko. Iyi í ɡbɔ Jesu í to wɑ bɛ ɡbɑkɑ̃, ŋɔi í nɑɑ í ɡulɛ si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Abou í bɛi í jɛ dimi mmu. À buui Fenisi si ilɛi Siri. Ŋɔi wɑ tɔɔ Jesu ku leleɑ nŋu inɛi inɔɔkou hɑi si ɑmɑɛu. ");
INSERT INTO mkl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ammɑ Jesu í sɔ̃ɔ í ni, jɔ̀ ɑmu ŋɑ ɑ jɛ ɑ yo titɑ̃, domi kù sĩɑ ɑ ɡbɑ ijɛi ɑmu ŋɑ ɑ nɑ ɑjɑ keeke ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ŋɔi ɑbou í ni, ntɔi Lɑfɛ̃ɛ. Ammɑ bɑɑ do nŋu fei, ɑjɑ keeke ŋɑu ɑ̀ yɑ wɑ ɑbɛi tɑɑbu ɑ mɑɑ jɛ buubuui ijɛi ɑmu ŋɑ iyi wɑ cuku wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ŋɔi Jesu í sɔ̃ɔ í ni, nɑ ide iyi ì fɔu bɛ, nɛ. Inɛi inɔɔkou í fitɑ siɛ mbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iyi í nyi kpɑsɛ̃ɛ ŋɔi í koo í bɑ ɑmɑu wɑ sũ si dɑɑyi, inɛi inɔ ikou í fitɑ siɛ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ŋɔi Jesu í dede hɑi ilɛɛkoi Tii í too do Sidɔ̃ɔ, í bɛi í bɔ tenkui Gɑlilee si ilɛ iyi ɑ̀ yɑ kpe Ilu Mɛɛwɑ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iyi í to, ŋɔi inɛ ɡɔ ŋɑ ɑ̀ nɑɑò dekĩ ɡɔ wɑ, iyi ci yɑ yɔkɔ ku fɔ ide sɑ̃ɑ sɑ̃ɑ, ŋɔi ɑ̀ tɔɔ Jesu ku lesiɛ ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ŋɔi Jesu í bɔòɛ hee bii í jĩò zɑmɑɑu. Ŋɔi í dɑsi ɑmɑɑwɔɛ si itĩi dekĩu, nɔ í tu ɑntɔ, í jɔɑ si ɑmɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nɔ í wu iju lele í jilɛ idɔ í fɔ do fee nŋɑ í ni, efɑtɑ, wɑɑtɔ, cĩ. ");
INSERT INTO mkl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ŋɔi ɡbɑkɑ̃ itĩi mɔkɔu í cĩ nɔ ɑmɛɛ í tɛ, nɔ í sinti ku fɔ ide dee dee. ");
INSERT INTO mkl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesu í sɔ̃ ŋɑ í ni ɑ mɑɑ̀ sɔ̃ inɛ ɡɔ, ɑmmɑ si bɛi wɑ sɔ̃ ŋɑu, bɛɛbɛ mɔi ɑŋɑ mɔ ɑ̀ wɑsi ku sɔ̃ inɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ŋɔi inɛ ŋɑu ɑ̀ biti hee í cɑɑ ɑ̀ wɑɑ ni, mii iyi wɑ ce fei í sĩɑi. Í jɔ̀ bɑɑ dekĩ ŋɑ ɑ̀ wɑɑ ɡbɔ ide, inɛ ŋɑ iyi ɑ ci yɑ yɔkɔ ɑ fɔ ide wo ɑ̀ wɑɑ fɔ bɛbɛi. ");
INSERT INTO mkl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Iyi í ce ɑjɔ minji ŋɔi zɑmɑɑ nlɑ ɡɔ í tɔtɔɔ bi tɛɛ mɑ́. Nɔ wee ɑ kù nɛ mii iyi ɑɑ jɛ. Ŋɔi Jesu í kpe mɔcɔɛ ŋɑu í sɔ̃ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ɑrɑɑrei zɑmɑɑu ihɛ̃ wɑ mum domi ɑjɔ mɛɛtɑ nŋɑi ihɛ̃ iyi ɑ̀ wɑ bi tom, nɔ sɔndɑ kɑ̃mɑ kù ɡbe nŋɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bii ǹ jɔ̀ ɑ̀ nɛò ɑri ɑɑ koo ɑ cuku kpɑ̃ɑ, si bɛi idei inɛ ɡɔ ŋɑ í jĩ. ");
INSERT INTO mkl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ŋɔi mɔcɔɛ ŋɑu ɑ̀ beeɛ ɑ̀ ni, iwoi ɑɑ kɑ bɑ pɛ̃ɛ si ɡbɑbuɑu ihɛ̃ iyi ɑɑ jɛ ɑ yoò. ");
INSERT INTO mkl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ŋɔi Jesu í bee ŋɑ í ni, pɛ̃ɛ fɛloi ì nɛ ŋɑ. Ŋɔi ɑ̀ ni, ɑrɑ mɛɛjei. ");
INSERT INTO mkl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ŋɔi Jesu í ni zɑmɑɑu fei ku bubɑ ilɛ. Nɔ í so pɛ̃ɛ ɑrɑ mɛɛjeu í bɛi í sɑɑbu Ilɑɑɔ̃, nɔ í bububuɛ í nɑ mɔcɔɛ ŋɑu ɑ kpɛ̃ nŋɑ. Ŋɔi ɑ̀ kpɛ̃ɑ zɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wee ɑ̀ nɛ cɛ̃ɛ keeke ɡɔ ŋɑ bɛ mɑ́. Ŋɔi Jesu í sɑɑbu Ilɑɑɔ̃ mɑ́, í bɛi í ni ɑ kpɛ̃ nŋɑ, nɔ ɑ̀ kpɛ̃ nŋɑ cɛ̃ɛ ŋɑu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nɔ ɑŋɑ fei ɑ̀ jɛ ɑ̀ yo. Ŋɔi ɑ̀ nɑɑ ɑ̀ ko bubui pɛ̃ɛ ŋɑ iyi í ɡbeu kɔlɔ mɛɛje. ");
INSERT INTO mkl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jiɑi inɛ ŋɑu í to zɑkɑi ɑŋɑ dubu mɛɛ (4.000). Ŋɔi Jesu í bɛi í jɔ̀ inɛ ŋɑu ɑ̀ nɛ. ");
INSERT INTO mkl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ŋɔi ɡbɑkɑ̃ í koo í lɔ ɑkɔi inyiu do mɔcɔɛ ŋɑ ɑ̀ bɔ ikpɑ Dɑɑmɑnutɑ. ");
INSERT INTO mkl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ŋɔi Fɑrisi ɡɔ ŋɑ ɑ̀ nɑɑ bi Jesu ɑ̀ wɑsi ku bɑɑ kɑkɔɔ ku ce. À cɔ lɑɑkɑɛ, ɑ̀ tɔɔɛ ku ce mɑɑmɑɑke iyi ɑ́ nyisi iyi ɡbuɡbɑ̃ɛ hɑi bi Ilɑɑɔ̃i wɑ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ŋɔi Jesu í jilɛ idɔɛ í ni, nɑ mii í ce inɛi nsɛi ŋɑu ihɛ̃ ɑ̀ wɑɑ tɔɔm n ce mɑɑmɑɑke. Ntɔ ntɔ, n kɑɑ n nyisi ŋɛ mɑɑmɑɑke kɑ̃mɑ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ŋɔi í jɔ̀ ŋɑ í koo í lɔ ɑkɔu do mɔcɔɛ ŋɑ ɑ kuɑ do ice ihɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wee mɔcɔɛ ŋɑu ɑ̀ ɡbɛjɛ ijɛ ku so, pɛ̃ɛ ɑkɑ̃i ɑ̀ nɛ si ɑkɔu bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, i ce lɑɑkɑi i nyɑ ɑrɑ nŋɛ hɑi bi lefeei Fɑrisi ŋɑ do ti inɛi Herodu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ŋɔi mɔcɔ ŋɑu ɑ̀ wɑɑ sɔ̃ njɛ ide ɑ̀ wɑɑ ni, si nɑ iyi í jɔ̀ ɑ kù nɛ ijɛi í jɔ̀ wɑ dɔ̃ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wee Jesu í mɑ̀ iyi ɑ̀ wɑɑ fɔ ŋɔi í ni, nɑ mii í ce ì fɔ ì wɑɑ ni ŋɑ, si nɑ iyi í jɔ̀ ɑ kù nɛ pɛ̃ɛi. Iŋɛ mɔ i kù mɑ̀ ŋɑ hee nsɛi? I kù ɡbɔ yɑɑsei ideu ŋɑi? I kù nɛ bisi ŋɑi? Idɔ nŋɛ mɔ í lei? ");
INSERT INTO mkl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Í jɔ ì nɛ iju ŋɑ mɛɛ, i ci yɑ yɛ ilu ŋɑi? I kù nɛ itĩ ŋɑ bɑ. I ci yɑ ɡbɔ ide ŋɑi? I ci yɑ ye ɡiɡi ŋɑi? ");
INSERT INTO mkl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wɑɑti iyi ǹ kpɛ̃ɑ ɑmɑnɛ dubu miu pɛ̃ɛ ɑrɑ miuu, pɛ̃ɛ kɔlɔ fɛloi búbù iyi í ɡbeu í ce. Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, kɔlɔ mɑɑteejii. ");
INSERT INTO mkl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ŋɔi Jesu í bee ŋɑ mɑ́ í ni, si wɑɑti iyi ǹ bu pɛ̃ɛ ɑrɑ mɛɛjeu ǹ nɑ ɑmɑnɛ dubu mɛɛ ŋɑu, pɛ̃ɛ bubu iyi í ɡbeu kɔlɔ fɛloi ì kóo ŋɑ. Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, kɔlɔ mɛɛjei. ");
INSERT INTO mkl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, i kù ɡbɔ hee nsɛi ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ŋɔi ɑ̀ to ilu ɡɔ iyi ɑ̀ yɑ kpe Bɛsɑidɑ, nɔ inɛ ɡɔ ŋɑ ɑ̀ nɑ́ɑɑ Jesu fɛɛju ɡɔ wɑ, ɑ̀ tɔɔɛ ku luu. ");
INSERT INTO mkl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ŋɔi í mu ɑwɔi fɛɛjuu í bɔòɛ ɑlɑlɑi iluu. Ŋɔi í dɑɑ ɑntɔ si ijuɛ í lesiɛ ɑwɔ í ni, ì wɑɑ yɛ nɡɔɡɔ? ");
INSERT INTO mkl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ŋɔi fɛɛjuu í cɔ ilu í ni, ǹ wɑ n yɛ ɑmɑnɛ ŋɑ ɑ̀ wɑɑ nɛ, ɑmmɑ ɑ̀ yɛi bɛi jĩi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ŋɔi Jesu í leɑ ɑwɔ si iju mɑ́. Iyi inɛɛu í cɔ ilu mɑ́ nɔ í bɑ wee nŋu í bɑ iri, wɑ yɛ ilu wɑu wɑu. ");
INSERT INTO mkl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ŋɔi Jesu í ni ku nɛ kpɑsɛ̃ɛ, ɑmmɑ ku mɑɑ̀ too do inɔ ilu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ŋɔi Jesu do mɔcɔɛ ŋɑ ɑ̀ nɛ ikpɑ ilu ŋɑ iyi ɑ̀ wɑ kɔkɔi Sezɑree, si ilɛi Filipi. Ŋɔi si kpɑ̃ɑu í bee mɔcɔɛ ŋɑ í ni, yooi inɛ ŋɑ ɑ̀ yɑ ni ǹ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nɔ ɑ̀ jɛɑɑ ɑ̀ ni, inɛ ɡɔ ŋɑ ɑ̀ yɑ ni ɑwɔu Zɑ̃ɑ woo dɑsi inyii. Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɑ ni ɑwɔu Elii wɑlii nlɑi tɑkoui. Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɑ ni ɑwɔu inɛ ɑkɑ̃i wɑlii ŋɑui. ");
INSERT INTO mkl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ŋɔi Jesu í bee ŋɑ í ni, iŋɛ mɔ ni, yooi ì ni ǹ jɛ ŋɑ. Ŋɔi Piɛɛ í jɛɑɑ í ni, ɑwɔu Kirisii, inɛ iyi Ilɑɑɔ̃ í cicɑ. ");
INSERT INTO mkl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ŋɔi Jesu í sɔ̃ ŋɑ do kuɡɑɑbu í ni ɑ mɑɑ̀ sɔ̃ inɛ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ŋɔi Jesu í sinti ku sɔ̃ mɔcɔɛ ŋɑu í ni nŋu Amɑi Amɑnɛ, í ɡbe nŋu ku ce wɑhɑlɑ jiidɑ. Inɛ nɡbo ŋɑ do inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ ɑɑ kɔsi nŋu ɑ kpɑ nŋu, ɑmmɑ nŋu ɑ́ jĩ hɑi si bɑlɛ si ɑjɔ mɛɛtɑsiɑ. ");
INSERT INTO mkl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Í fɔ ideui sɑ̃ɑ sɑ̃ɑ, kù sinɡɑɛ. Ŋɔi Piɛɛ í ɡbɑ̃ɑ í bɔòɛ kɔkɔlɛ nɔ í ni ku mɑɑ̀ fɔ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ammɑ Jesu í sindɑ í cɔ mɔcɔɛ ŋɑ, nɔ í lɑ si Piɛɛ í ni, sɛkɛɛ hɑi bi tom, Seetɑm, domi i kù wɑɑ ce lɑsɑbui Ilɑɑɔ̃, í ɡbe ti ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Si ɑnyiɛ, í kpe zɑmɑɑu do mɔcɔɛ ŋɑ, í sɔ̃ ŋɑ í ni, inɛ iyi wɑ bi ku toom, ku jɔ̀ idɔɔbiɛ nɔ ku so jĩi ku ɡɑɑuɛ ku toom wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nɔ inɛ iyi wɑ bi ku bɑ kuwɛɛ do idɔɔbiɛ, kɑɑ bɑɑ. Ammɑ inɛ iyi í nyɔ kuwɛɛɛ nɑ irim do nɑ lɑɑbɑɑu jiidɑu, lɑfɛ̃ɛ ɑ́ bɑɑ do ntɔ. ");
INSERT INTO mkl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Arɑnfɑ̃ɑni yoomɑi ɑmɑnɛ í nɛ bii í bɑ ɑmɑnii ɑndunyɑ fei nɔ í kuɑ kuwɛɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mɑ̀ mii í wɛɛ iyi ɑmɑnɛ ɑ́ kpɑɑsiò kuwɛɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nɔ Jesu í ni mɑ́, inɛi nsɛi ŋɑ ilu dulum ŋɑi iyi ɑ kù leekĩò Ilɑɑɔ̃ nŋu ɑkɑ̃. Nɑ nŋu, inɛ iyi wɑ ce ɑnyɔi ɑmu Amɑi Amɑnɛ, wɑlɑkɔ wɑ ce ɑnyɔi idem si wɑju nŋɑ, ɑmu mɔ ɑn ce ɑnyɔi lɑfɛ̃ɛ wɑɑti iyi ɑn nyi wɑ. Nɔ wɑɑti iyi ɑn nyi wɑ ɑn nyi wɑi do ɑmboei Bɑɑm do ɑmɑlekɑɛ ŋɑ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, ntɔ ntɔ, inɛ ŋɑ iyi ɑ̀ wɑ ihɛ̃ si nsɛi, ɡɔɡɔ nŋɑ ŋɑ ɑɑ yɛ bommɑi Ilɑɑɔ̃ wɑ nɑɑ do ɡbuɡbɑ̃ ɑ bɛi ɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Si ɑnyii ɑjɔ mɛɛfɑ Jesu í kpe Piɛɛ do Zɑɑki do Zɑ̃ɑ í nyɑ ŋɑ ikɑ̃ nɔ ɑ̀ koo ɑ̀ ɡũ iri kutɑ nlɑ ɡɔ ɑŋɑ duusɔ̃ɔ. Si bɛi ɑ̀ wɑɑ cɔɔ ŋɔi ɑ̀ bɑ ɑrɑɛ í kpɑɑsi. ");
INSERT INTO mkl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ŋɔi jɑɑɛ ŋɑ wɑ dɑɑnɑ jiidɑ í fũutɑ pɑi pɑi hee inɛ ɡɔ kù wɛɛ si ɑndunyɑ ihɛ̃ iyi ɑ́ yɔkɔ ku fɔ ɑcɔɛ ku fũutɑ bɛɛbɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Si ɑnyiɛ ŋɔi Elii do Moizi ɑ̀ fɑɑtɑ wɑ ɑ̀ wɑɑ bɑɑ ide ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nɔ Piɛɛ í sɔ̃ Jesu í ni, Mɛɛtu, ɑ́ sĩɑ kɑ mɑɑ wɑ ihɛ̃. Jɔ̀ kɑ ce ilei ɑcɔ mɛɛtɑ, ɑkɑ̃ titɛɛ, ɑkɑ̃ mɔ ti Moizi, ɑkɑ̃ mɔ ti Elii. ");
INSERT INTO mkl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wɑ fɔ bɛɛbɛi si nɑ iyi í jɔ̀ njo í mu ŋɑ hee í jɔ̀ kù mɑ̀ bɑɑ bɛi ɑ́ ni. ");
INSERT INTO mkl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ŋɔi bukɔɔ ɡɔ í nɑɑ í bii ŋɑ, nɔ hɑi si bukɔɔu ɑ̀ ɡbɔ ide ku fɔ ɡɔ í ni, inɛ ihɛ̃i í jɛ ɑmɑm, ǹ buu jiidɑ jiidɑ. I yɑ ɡbɔ ideɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ŋɔi ɡbɑkɑ̃ mɔcɔɛ ŋɑu ɑ̀ cɔ bii fei, nɔ ɑ kù yɛ inɛ ɡɔ bii kù jɛ Jesu nŋu ɑkɑ̃ do ɑŋɑ tɑkɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ŋɔi ɑ̀ wɑɑ kitɑ wɑ hɑi iri kutɑu nɔ Jesu í sɔ̃ ŋɑ í ni ɑ mɑɑ̀ sɔ̃ inɛ ɡɔ mii iyi ɑ̀ yɛ hee nŋu Amɑi Amɑnɛ koo ku nɔ ku jĩ hɑi si bɑlɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nɔ ɑ̀ jirimɑ ide iyi í sɔ̃ ŋɑu ɑmmɑ ɑ̀ wɑɑ bee njɛ ide ɑ̀ wɑɑ ni, yoomɑi í jɛ inɛ ku ku nɔ ku jĩ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nɔ ɑ̀ bee Jesu ɑ̀ ni, nɑ mii í ce woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ ni Elii ɑ́ tɑko Kirisi ku nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ŋɔi í jɛ nŋɑ í ni, ntɔi Eliii ɑ́ tɑko ku nɑɑ ku teese mii fei sɑ̃ɑ sɑ̃ɑ. Ammɑ kukɔi idei Ilɑɑɔ̃ í ni mɑ́, inɛ ŋɑ ɑɑ kpɑ̃ Amɑi Amɑnɛ iju jiidɑ nɔ ɑ dondɑɛ, mɑ̀ iboi. ");
INSERT INTO mkl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ammɑ ǹ wɑ n sɔ̃ ŋɛ iyi Elii í nɑɑ tɑ̃, nɔ inɛ ŋɑ ɑ̀ wɑhɑlɑɛ bɛi ɑ̀ bi, si bɛi kukɔi idei Ilɑɑɔ̃ wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wɑɑti iyi Jesu do mɔcɔ mɛɛtɑ ŋɑu ɑ̀ wɑɑ to wɑ kɔkɔi mɔcɔ bubu ŋɑu, ŋɔi ɑ̀ yɛ zɑmɑɑ nlɑ nlɑ ɡɔ í kɑɑko ŋɑ, do woo kɔ inɛ ŋɑ si woodɑ ɡɔ ŋɑ iyi ɑ̀ wɑɑ bɑ ŋɑ kɑkɔɔ ku ce. ");
INSERT INTO mkl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Iyi inɛ ŋɑu ɑ̀ yɛ Jesu ɡbɑkɑ̃ ɑ̀ biti nɔ ɑ̀ sɛi ɑ̀ koo ɑ̀ coo fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ŋɔi Jesu í bee mɔcɔɛ ŋɑ í ni, kɑkɔɔi mii ì wɑɑ ce iŋɛò ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ŋɔi si inɔi zɑmɑɑu inɛ ɑkɑ̃ í jɛɑɑ í ni, Mɛɛtu, ǹ nɑɑɛ ɑmɑ inɛmɔkɔm wɑ si nɑ iyi í jɔ̀ í nɛ inɛi inɔɔko iyi í jɔ̀ ci yɑ fɔ ide. ");
INSERT INTO mkl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wɑɑti iyi í dede siɛ fei í yɑ kɛkɛɛ ilɛi nɔ ɡɛlɛɛ ku ce ɑntɔ foko ku mɑɑ ŋɔ inyi nɔ ku kɑsɑ̃m. Wee ǹ tɔɔ mɔcɔɛ ŋɑ ɑ leleɑɑ, ɑmmɑ ɑ kù yɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, iŋɛ hɑi dɑsi nɑɑnɛ ŋɑ, hee wɑɑti yoomɑi ɑn mɑɑ n wɑ inɔ nŋɛ. Mɑ hee wɑɑti yoomɑi ɑn mɑɑ n temuɑò ŋɛ. I nɑɑm ɑmɑu wɑ ihɛ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nɔ ɑ̀ nɑɑɛ wɑ. Iyi ɑmɑu í yɛ Jesu ɡbɑkɑ̃, ŋɔi inɛi inɔɔkou í yɑyɑɛ do ɡbuɡbɑ̃, nɔ ɑmɑu í cuku ilɛ wɑ bimbili í ce ɑntɔ foko si ɡɛlɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nɔ Jesu í bee bɑɑɛ í ni, hɑi wɑɑti yoomɑi inɛi inɔɔkou ihɛ̃ í muu. Ŋɔi bɑɑu í jɛɑɑ í ni, hɑi wɑɑti iyi í wɛɛ keekei. ");
INSERT INTO mkl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nɔ inɛi inɔɔkou í nɛ dɔɔnɛɛi ku dɑsiɛ inɔ inɑi wɑlɑkɔ inɔ inyi ku bɑ ku kpɑɑ. Ammɑ, bii ɑɑ yɔkɔ i ce nɡɔɡɔ, ce ɑrɑɑre nwɑ, i sobi wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ŋɔi Jesu í sɔ̃ɔ í ni, ì ni bii ɑn yɔkɔ wó. Inɛ iyi í dɑsi nɑɑnɛ ɑ́ yɔkɔ ku ce fei ndɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ŋɔi ɡbɑkɑ̃ bɑɑi ɑmɑu í dɔ̃ ɑnu nlɑ ɡɔ í ni, ǹ dɑsi nɑɑnɛ. Sobim ku bɑ n mɑɑ̀ n sikɑ si nɑɑnɛ ku dɑsim. ");
INSERT INTO mkl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iyi Jesu í yɛ ɑkpɔi inɛ ŋɑu wɑ kɔ̃ɔsi ɑ̀ sɛi ɑ̀ wɑɑ nɑɑ bi ti nŋu ŋɔi í lɑsi inɛi inɔɔkou í ni, ɑwɔ iyi ì yɑ dɑsi inɛ dekĩ ku mɔnɡɔ ide ku fɔ, ɑmui ǹ ni, fitɑ si ɑmɑu nɔ i mɑɑ̀ nyi wɑ siɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ŋɔi inɛi inɔɔkou í dɔ̃ ɑnu nɔ í yɑyɑ ɑmɑu do ɡbuɡbɑ̃ í bɛi í fitɑ. Ŋɔi ɑmɑu í kɑsɑ̃m hee inɛ nkpɔ í ni í kui. ");
INSERT INTO mkl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ammɑ Jesu í mu ɑwɔɛ í dedeɛ nɔ ɑmɑu í leekĩ. ");
INSERT INTO mkl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Si ɑnyiɛ Jesu í lɔ kpɑsɛ̃ ɡɔ, nŋu do mɔcɔɛ ŋɑ ɑŋɑ duusɔ̃ɔ. Ŋɔi mɔcɔɛ ŋɑu ɑ̀ beeɛ ɑ̀ ni, nɑ mii í ce ɑwɑ ɑ kù yɔkɔ ɑ kù lele inɛi inɔɔkou. ");
INSERT INTO mkl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ŋɔi Jesu í jɛ nŋɑ í ni, do kutɔɔ nŋu ɑkɑ̃i ɑɑ yɔkɔ i nyɑò dimii inɛi inɔɔkou bɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Si ɑnyiɛ, Jesu do mɔcɔɛ ŋɑ ɑ̀ nɛ hɑi bɛ nɔ ɑ̀ koo ɑ̀ dɑbii dɑbii si ilɛi Gɑlilee. Wee Jesu kù bi inɛ ŋɑ ɑ mɑ̀ bii nŋu í wɑ, ");
INSERT INTO mkl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","domi wɑ kɔ mɔcɔɛ ŋɑu si cio nɔ í sɔ̃ ŋɑ í ni, ɑɑ mu ɑmu Amɑi Amɑnɛ ɑ dɑɑ inɛ ŋɑ si ɑwɔ. Aɑ kpɑm, ɑmmɑ si ɑjɔ mɛɛtɑsiɑ ɑn jĩ hɑi si bɑlɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ammɑ mɔcɔɛ ŋɑu ɑ kù ɡbɔ yɑɑsei ideu, nɔ ɑ̀ wɑɑ ce njoi ku beeɛ. ");
INSERT INTO mkl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ŋɔi ɑ̀ to wɑ Kɑpɛrɑnumu. Wɑɑti iyi ɑ̀ to kpɑsɛ̃ ŋɔi Jesu í bee mɔcɔɛ ŋɑ í ni, kɑkɔɔi mii ì wɑɑ ce wɑ si kpɑ̃ɑu bɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ŋɔi ɑ̀ coko, domi hɑi kpɑ̃ɑ ɑ̀ wɑɑ ce kɑkɔɔ wɑi ɑŋɑ duusɔ̃ɔ ɑ bɑ ɑ mɑ̀ inɛ iyi í jɛ inɛ nɡbo. ");
INSERT INTO mkl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ŋɔi Jesu í bubɑ, nɔ í kpe ɑmɑnɛ mɑɑteeji ŋɑu í sɔ̃ ŋɑ í ni, inɛ iyi wɑ bi nŋu ku jɛ inɛ sinte, lɑfɛ̃ɛi ɑ́ jɛ inɛi ɑnkɑ̃ɑnyii inɛ fei nɔ ku jɛ woo ce icɛi inɛ fei. ");
INSERT INTO mkl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ŋɔi í so ɑmɑ keeke ɡɔ í leekĩɛ si ɑnini nŋɑ, nɔ í so ɑmɑu si ikpɑɛ, í bɛi í sɔ̃ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","inɛ iyi í ɡbɑ ɑmɑ keeke bɛi inɛ ihɛ̃ nɑ irim, ɑmui í ɡbɑ. Inɛ mɔ iyi í ɡbɑm, kù jɛ ɑmu ɑkɑ̃i í ɡbɑ, inɛ iyi í bɛm wɑi í ɡbɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ŋɔi Zɑ̃ɑ í sɔ̃ɔ í ni, Mɛɛtu, ɑ̀ yɛ inɛ ɡɔ iyi í yɑ mɑɑ lele inɛi inɔɔko ŋɑ do iriɛ, nɔ ɑ̀ kɔɑ domi kù wɑɑ tooɛ kù jɛ inɛ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ammɑ Jesu í jɛɑɑ í ni, i mɑɑ̀ kɔɑ ŋɑ. Inɛ ɡɔ kɑɑ yɔkɔ ku ce mɑɑmɑɑke do irim nɔ bii í tɛkɛɛ ɡbɑkɑ̃ ku fɔ lɑɑlɔm mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Do ntɔ, inɛ iyi kù jɛ mbɛɛ nwɑ inɛ nwɑi. ");
INSERT INTO mkl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ntɔ ntɔ, inɛ iyi í mu nŋɛ inyi ku mɔ nɑ irim, si nɑ iyi í jɔ̀ ì jɛ titom ŋɑ, lɑfɛ̃ɛ kɑɑ kuɑ ribɑɛ pɑi. ");
INSERT INTO mkl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, inɛ iyi í dɑsi inɛ ɑkɑ̃i ɑmɑ keeke ŋɑ iyi ɑ̀ dɑsim nɑɑnɛu ihɛ̃ kurɑrɑ, í tiɑ ɑ dĩɑ lɑfɛ̃ɛ ɑlɔ ɡɔ si kɔ̃ɔɛ, nɔ ɑ sɔsiɛ si tenku. ");
INSERT INTO mkl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Bii í jɛ ɑwɔ ɑkɑ̃ɛi wɑ dɑsiɛ kurɑrɑ, buu. Á tiɑ i lɔ si kuwɛɛ iyi ci yɑ tɑ̃ do ɑwɔ ɑkɑ̃ do iyi ɑɑ nɛ ɑwɔ minji fei nɔ i lɔ si inyɑi wɑhɑlɑ si inɑ iyi ci yɑ ku.  ");
INSERT INTO mkl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tenɡi bɛ kokoo ku ŋɔ ɑrɑ ŋɑ ɑ kɑɑ ku nɔ inɑu mɔ kɑɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Bii í jɛ kutɛ ɑkɑ̃ɛi wɑ dɑsiɛ kurɑrɑ, buu. Á tiɑ i lɔ si kuwɛɛ iyi ci yɑ tɑ̃ do kutɛ ɑkɑ̃ do iyi ɑɑ nɛ kutɛ minji fei nɔ i lɔ si inyɑi wɑhɑlɑ.  ");
INSERT INTO mkl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tenɡi bɛ kokoo ku ŋɔ ɑrɑ ŋɑ ɑ kɑɑ ku nɔ inɑu mɔ kɑɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nɔ bii í jɛ iju ɑkɑ̃ɛi wɑ dɑsiɛ kurɑrɑ, nyɑɑ. Á tiɑ i lɔ si bommɑi Ilɑɑɔ̃ do iju ɑkɑ̃ do iyi ɑɑ nɛ iju minji fei nɔ i lɔ si inyɑi wɑhɑlɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tenɡi bɛ kokoo ku ŋɔ ɑrɑ ŋɑ ɑ kɑɑ ku nɔ inɑu mɔ kɑɑ ku. ");
INSERT INTO mkl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ntɔ ntɔ si bɛi ɑ̀ yɑ fɑ̃si iŋɑ fei imu, bɛɛbɛ mɔi inɛ fei ɑ̀ yɛ ijuukpɑ̃ iyi í yɛ bɛi inɑ ku cɔ lɑɑkɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Imu mii ncɛɛi, ɑmmɑ bii didɔ̃i imu í ku, mii ɑɑ dɑsi i jɔ̀ ku dɔ̃ mɑ́ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK9_51","071_9_51","MRK","9","51","51","Iŋɛ fei í sĩɑ i yɛ bɛi imu ŋɑ, i mɑɑ ɡbɔ si njɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ŋɔi Jesu í nɛ hɑi bɛ í bɔ ilɛi Zudee. Si ɑnyiɛ nɔ í kuɑ í bɔ ikpɑ icei idoi Zuudɛ̃ɛ. Ŋɔi zɑmɑɑ ɡɔ í tɔtɔɔ kɔkɔɛ mɑ́, ŋɔi í lɔsi ku kɔ nŋɑ si cioi idei Ilɑɑɔ̃ si bɛi í nɛ dɔ̃ɔnɛɛi ku ce. ");
INSERT INTO mkl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ŋɔi Fɑrisi ɡɔ ŋɑ ɑ̀ nɑɑ bi tɛɛ ku bɑ ɑ cɔ lɑɑkɑɛ, nɔ ɑ̀ beeɛ bii í jɛ ɑmɑnɛ í nɛ kpɑ̃ɑ ku kɔsi ɑboɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ŋɔi Jesu í jɛ nŋɑ í ni, si ideu bɛ, woodɑ yoomɑi Moizi í kɔ nŋɛ wo. ");
INSERT INTO mkl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ŋɔi ɑ̀ ni, Moizi í ni, bii ì wɑɑ kɔsi ɑboɛ ɑɑ ceɑɑ tiɑi njɛ ku kɔ i bɛi i kɔsiɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, nɑ idɔ ku le nŋɛi í jɔ̀ Moizi í kɔ nŋɛ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ammɑ hɑi sinte, wɑɑti iyi Ilɑɑɔ̃ í tɑkɑ ɑndunyɑ, í ce inɛmɔkɔi do inɑɑbo. ");
INSERT INTO mkl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nɑ nŋu, mɔkɔ ɑ́ jɔ̀ iyeò bɑɑɛ nɔ nŋu do ɑboɛ ɑ mɑɑ wɛɛ ");
INSERT INTO mkl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nɔ ɑŋɑ minji fei ɑ bɑɑ ɑ jɛ ɑrɑ ɑkɑ̃. Si bɛɛbɛ ɑ kù jɛ ɑŋɑ minji mɑ́, ɑrɑ ɑkɑ̃ dei ɑ̀ jɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nɑ nŋu, ɑmɑnɛ ku nɛ ku fɛɛfɛ mii iyi Ilɑɑɔ̃ í tɔtɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi ɑ̀ bɔ kpɑsɛ̃ nɔ mɔcɔɛ ŋɑu ɑ̀ wɑɑ beeɛ ide si ide ɑkɑ̃u mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, inɛ iyi í kɔsi ɑboɛ nɔ í so mmuɛ dulum nii í ce bi ɑbo sinteu si nɑ iyi í jɔ̀ í ce sɑkɑrɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bɛɛbɛ mɔi bii inɑɑbo í kɔ mɔkɔɛ nɔ í so mɔkɔ titɔ̃ í ce sɑkɑrɑi. ");
INSERT INTO mkl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ŋɔi inɛ ŋɑ ɑ̀ ɡbɑ̃ ɑmɑ keeke ŋɑ ɑ̀ nɑɑɑ Jesu wɑ ku lu ŋɑ. Ammɑ mɔcɔɛ ŋɑu ɑ̀ wɑɑ lɑsi inɛ ŋɑ iyi ɑ̀ nɑɑò ŋɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iyi Jesu í yɛ mii iyi ɑ̀ wɑɑ ceu, ŋɔi idɔɛ í kɔ̃, í sɔ̃ ŋɑ í ni, i jɔ̀ ɑmu ŋɑu ɑ nɑɑ bi tom, i mɑɑ̀ ɡɑnji ŋɑ. Domi Ilɑɑɔ̃ í jɛ ilɑɑlui inɛ ŋɑ iyi ɑ̀ jɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ntɔ ntɔ, inɛ iyi kù wɑɑ sũɑ Ilɑɑɔ̃ iri ilɛ bɛi ɑmɑ keeke, Ilɑɑɔ̃ kɑɑ jɛ ilɑɑlui lɑfɛ̃ɛ pɑi. ");
INSERT INTO mkl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ŋɔi í so ɑmu ŋɑu si ikpɑɛ í lesi ɑŋɑ fei ɑwɔ, nɔ í wee nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ŋɔi Jesu í dɑsi kpɑ̃ɑ. Iyi wɑ nɛ, ŋɔi inɛ ɡɔ í sɛi wɑ í nɑɑ í ɡulɛ si wɑjuɛ í ni, Mɛɛtu, ɑwɔ inɛ ncɛɛ, mii ɑn ce n bɑò kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ŋɔi Jesu í beeɛ í ni, nɑ mii í ce ì wɑɑ kpem inɛ ncɛɛ. Inɛ ɡɔ kù wɛɛ iyi í jɛ ncɛɛ bii kù jɛ Ilɑɑɔ̃ nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ì mɑ̀ sɑ̃ɑ sɑ̃ɑ mii iyi woodɑ í ni. Mii iyi woodɑ í ni wee, mɑɑ̀ kpɑ inɛ, mɑɑ̀ ce sɑkɑrɑ, mɑɑ̀ ce ile, mɑɑ̀ jɛɑ inɛ ɡɔ sɛɛdɑ ibo, mɑɑ̀ tɑkii inɛ ɡɔ, jirimɑ iyeò bɑɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nɔ inɛɛu í ni, Mɛɛtu, ǹ wɑ n jirimɑ iyi bɛ fei tɑ̃ hɑi keekem. ");
INSERT INTO mkl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ŋɔi Jesu í cɔ inɛɛu do kubi nɔ í ni, í ɡbeɛ mii ɑkɑ̃. Koo i tɑ mii iyi ì nɛ fei nɔ i kpɛ̃ɑ ilu ɑre ŋɑ fiɑu. Bii ì ce bɛɛbɛ ɑɑ bɑ ɑmɑni jiidɑ lelei Aɔ̃. Si ɑnyiɛ nɔ i nɑɑ i toom. ");
INSERT INTO mkl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ide iyi Jesu í fɔu kù dɔ̃ɑ inɛɛu si. Nɔ si bɛi í jɛ ilu ɑmɑni nlɑ nlɑ ŋɔi í sindɑ wɑ nɛ do inɔ ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ŋɔi Jesu í cɔ inɛ ŋɑ iyi ɑ̀ kɑɑkoɛu nɔ í sɔ̃ mɔcɔɛ ŋɑ í ni, ɑ́ ɡɑɑbu hee ku cɑɑ ilu fiɑ ku jɛsi Ilɑɑɔ̃ ku jɛ ilɑɑluɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ŋɔi mɔcɔ ŋɑu ɑ̀ biti do ide iyi Jesu í fɔu. Nɔ Jesu í ni mɑ́, kpɑɑsim ŋɑ, ɑ́ ɡɑɑbu hee ku cɑɑ inɛ ku jɛsi Ilɑɑɔ̃ ku jɛ ilɑɑluɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Í fɑɑlɑɑ kpookpo ku lɔ si iwoi ɑbɛɛ do iyi ilu ɑmɑni ɑ́ jɛsi Ilɑɑɔ̃ ku jɛ ilɑɑluɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ŋɔi mɔcɔɛ ŋɑu ɑ̀ biti hee í cɑɑ nɔ ɑ̀ bee njɛ ɑ̀ wɑɑ ni, bii bɛɛbɛi nɔ yooi ɑ́ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ŋɔi Jesu í cɔ ŋɑ tii, nɔ í ni, bi ɑmɑnɛ ŋɑi kɑɑ ce, ɑmmɑ bi Ilɑɑɔ̃ ɑ́ ce, domi Ilɑɑɔ̃ ci yɑ mɔnɡɔ nɡɔɡɔ. ");
INSERT INTO mkl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ŋɔi Piɛɛ í sɔ̃ɔ í ni, wee, ɑ̀ jɔ̀ mii fei tɑ̃ ɑ̀ wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ŋɔi Jesu í ni, ntɔ ntɔ, inɛ iyi í jɔ̀ kpɑsɛ̃ɛ wɑ, wɑlɑkɔ iɡbɑ̃ɛ ŋɑ wɑlɑkɔ ifɔɛ ŋɑ wɑlɑkɔ wecĩɛ ŋɑ, wɑlɑkɔ iyeò bɑɑɛ, wɑlɑkɔ ɑmɑɛ ŋɑ, wɑlɑkɔ ikoɛ ŋɑ nɑ irim do nɑ lɑɑbɑɑu jiidɑu, ");
INSERT INTO mkl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bɑɑ hɑi si ɑndunyɑu ihɛ̃ ɑ́ bɑ mii ŋɑu bɛ fei ikɔ cĩɔ. Á bɑ kpɑsɛ̃ ŋɑ, do iɡbɑ̃ do ifɔ ŋɑ do wecĩ ŋɑ, do iye ŋɑ, do ɑmu ŋɑ, do iko ŋɑ, nɔ si ɑntɑɛ ɑ́ bɑ wɑhɑlɑ mɔ mɑ́. Nɔ ɑlɑ ɑ́ bɑ kuwɛɛ iyi ci yɑ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ammɑ inɛ ŋɑ iyi ɑ̀ jɛ inɛi wɑju ŋɑ si nsɛi, nkpɔ nŋɑ ɑ́ nɑ ku jɛ inɛi ɑnyi ŋɑ nɔ inɛi ɑnyi ŋɑ mɔ ɑɑ nɑ ɑ jɛ inɛi wɑju ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nɔ Jesu do mɔcɔɛ ŋɑ ɑ̀ dɑsi kpɑ̃ɑ mɑ́, nŋu tɑkɑɛ wɑ cuɑ nŋɑ. À wɑɑ bɔ Zeruzɑlɛmu. Ŋɔi njo í mu mɔcɔɛ ŋɑu nɔ inɛ mmu ŋɑ iyi ɑ̀ wɑɑ too ɑnyi nŋɑu, ziɡi nŋɑ í dɑ. Ŋɔi Jesu í nyɑ mɔcɔ mɑɑteeji ŋɑu ikɑ̃ í lɔsi ku sɔ̃ ŋɑ mii iyi ɑ́ nɑ ku bɑ nŋu. ");
INSERT INTO mkl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Í ni, wee ɑ̀ wɑɑ bɔ Zeruzɑlɛmu. Bɛi ɑɑ mu ɑmu Amɑi Amɑnɛ ɑ dɑsim ɑwɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ. Aɑ yɛ tɑɑlem ɑ ni ɑ kpɑm. Si ɑnyiɛ nɔ ɑ dɑsim si ɑwɔi dimi mmu ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ɑɑ yɑɑkom nɔ ɑ tusim ɑntɔ, ɑɑ tɛɛm kpɔtɔɔ, nɔ ɑ kpɑm. Nɔ si ɑjɔ mɛɛtɑsiɑ ɑn jĩ mɑ́ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ŋɔi Zɑɑki do Zɑ̃ɑ, ɑmɑi Zebedee ŋɑ, ɑ̀ bɔ bi Jesu ɑ̀ sɔ̃ɔ ɑ̀ ni, Mɛɛtu, ɑ̀ wɑɑ bi i ce nwɑ mii iyi ɑ̀ wɑɑ tɔɔɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nɔ í bee ŋɑ í ni, mii ì bi n ce nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, wɑɑti iyi ɑɑ nɑ i jɛ bommɑ do ɑmboe, jɔ̀ kɑ bubɑ inɛ ɑkɑ̃ ɑwɔ njɛɛ, inɛ ɑkɑ̃ mɔ ɑwɔ cɑnɡɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nɔ Jesu í ni, i kù mɑ̀ mii iyi ì wɑɑ tɔɔm ŋɑ mɔm. Aɑ yɔkɔ i temuɑò ijuukpɑ̃ iyi ɑn yɛ ŋɑ? Zɑkɑ bɛi inɛ ŋɑ ɑɑ kpɑ̃m iju ɑ́ cɑɑ. Aɑ jɛsi ɑɑ ce nŋɛ dimiɛ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nɔ ɑ̀ ni ɑŋɑ ɑɑ yɔkɔ. Nɔ í sɔ̃ ŋɑ mɑ́ í ni, ntɔi, ɑɑ yɛ ijuukpɑ̃ iyi ɑn yɛ ŋɑ. Zɑkɑ bɛi inɛ ŋɑ ɑɑ kpɑ̃m iju, bɛɛbɛi ɑɑ ceɑ iŋɛ mɔ. ");
INSERT INTO mkl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ammɑ kù jɛ ɑmui ɑn cicɑ inɛ ŋɑ iyi ɑɑ bubɑ cɑnɡɑ do njɛm. Bi ku bubɑu bɛ, inɛ ŋɑ iyi ɑ̀ ceɑ sɔɔluɛ, ɑŋɑi ɑɑ bubɑ si. ");
INSERT INTO mkl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ŋɔi mɔcɔ mɛɛwɑ ŋɑu ɑ̀ ɡbɔ ideu nɔ idɔ nŋɑ í kɔ̃ò Zɑɑki do Zɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ŋɔi Jesu í kpe ŋɑ í ni, iŋɛ mɔ ì mɑ̀ ŋɑ si ɑndunyɑu ihɛ̃ ilɑɑlu ŋɑ ɑ̀ yɑ mɑɑ tɑɑ inɛ nŋɑ ŋɑ ɡbuɡbɑ̃i. Nɔ inɛ nɡbo ŋɑ mɔ ɑ mɑɑ nyisi yiiko nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ammɑ bi tu ŋɛ kɑɑ ce bɛɛbɛ. Inɛ nŋɛ iyi wɑ bi nŋu ku jɛ inɛ nɡbo, nŋui ɑ́ jɛ woo ce nŋɛ icɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Bɛɛbɛ mɔi inɛ iyi wɑ bi nŋu ku jɛ woo cuɑ nŋɛ, nŋui ɑ́ jɛ ɑrui inɛ fei. ");
INSERT INTO mkl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bɛɛbɛ mɔi bɑɑ ɑmu Amɑi Amɑnɛ n kù nɑɑ inɛ ŋɑ ɑ ceem icɛ, ɑmmɑ ɑmui ɑn ce nŋɑ icɛ, nɔ n nɑ kuwɛɛm n yɑò inɛ nkpɔ hɑi si dulum. ");
INSERT INTO mkl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Si isɛɛnɛu Jesu do mɔcɔɛ ŋɑ ɑ̀ to Zeriko nɔ ɑ̀ wɑɑ fitɑ hɑi bɛ. Wɑɑti iyi ɑ̀ wɑɑ fitɑu zɑmɑɑ nlɑ ɡɔ wɑ too ŋɑ. Wee fɛɛju woo bɑrɑ ɡɔ iyi ɑ̀ yɑ kpe Bɑɑtimee, ɑmɑi Timee, wɑ bubɑ itĩ kpɑ̃ɑ wɑ bɑrɑ. ");
INSERT INTO mkl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iyi í ɡbɔ ɑ̀ ni Jesu inɛi Nɑzɑrɛtiui wɑ lɔ, ŋɔi í wɑsi ku dɔ̃ ɑnu wɑ ni, Jesu, tɔkui Dɑvidi, ce ɑrɑɑrem. ");
INSERT INTO mkl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nɔ inɛ nkpɔ wɑ lɑ siɛ ɑ̀ wɑɑ ni ku coko. Ammɑ bɛ́i ɑ̀ wɑɑ ni ku cokou, bɛɛbɛ mɔi í yɑ dɔ̃ ɑnu hee lele ku mɑɑ ni, tɔkui Dɑvidi, ce ɑrɑɑrem. ");
INSERT INTO mkl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ŋɔi Jesu í leekĩ í ni ɑ kpoo wɑ. Nɔ ɑ̀ kpe fɛɛjuu wɑ ɑ̀ sɔ̃ɔ ɑ̀ ni, mɑɑ̀ jɔ̀ inɔɛ ku fɔ, dede wɑ. Jesu wɑ kpeɛ. ");
INSERT INTO mkl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ŋɔi fɛɛjuu í nyɔ kumbooɛ í dede ɡbɑkɑ̃ í koo bi Jesu. ");
INSERT INTO mkl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nɔ Jesu í beeɛ í ni, mii ì bi n ceeɛ. Ŋɔi fɛɛjuu í jɛɑɑ í ni, Mɛɛtu, ǹ bi n yɛ ilui. ");
INSERT INTO mkl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nɔ Jesu í sɔ̃ɔ í ni, koo. Nɑɑnɛɛ í fɑɑbɑɛ. Ŋɔi ɡbɑkɑ̃ í yɔkɔ í yɛ ilu, nɔ í too Jesu si isɛɛnɛɛu. ");
INSERT INTO mkl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesu do mɔcɔɛ ŋɑ ɑ̀ mɑɑi Zeruzɑlɛmu wɑ. À wɑ tenɡii Bɛtifɑze do Betɑni, nɔ ɑ̀ to Geetei Olivie ŋɑu. Ŋɔi Jesu í bɛ mɔcɔ minjiɛ ɡɔ ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","í sɔ̃ ŋɑ í ni, i bɔ ilu iyi í wɑ wɑju nŋɛu bɛ. Bii ì lɔ iluu ɡbɑkɑ̃ ŋɑ ɑɑ yɛ ɑmɑ ɡbɑnkɛlɛ ɡɔ wɑ so bɛ iyi inɛ ɡɔ kù ɡũu titɑ̃. I fũu nɔ i nɑɑm wɑ ihɛ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Bii inɛ ɡɔ í bee ŋɛ í ni, nɑ mii í ce ì wɑɑ fũu ŋɑ, i ni Lɑfɛ̃ɛi í nɛ bukɑɑtɑɛ nɔ ɑ́ sindo wɑ ihɛ̃ nsɛi. ");
INSERT INTO mkl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi inɛ ŋɑu ɑ̀ koo. Nɔ ɑ̀ bɑ ɑmɑ ɡbɑnkɛlɛu wɑ so si ɑndɛi ile ɡɔ itĩ kpɑ̃ɑ, ŋɔi ɑ̀ fũu wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nɔ si inɔi inɛ ŋɑ iyi ɑ̀ wɑ bɛu inɛ ɡɔ ŋɑ ɑ̀ bee ŋɑ ɑ̀ ni, mii ì wɑɑ ce bɛ ŋɑ. Bɛirei í ce ì wɑɑ fũ ɑmɑ ɡbɑnkɛlɛu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ŋɔi ɑ̀ jɛ nŋɑ si bɛi Jesu í fɔu wo. Nɔ inɛ ŋɑu ɑ̀ jɔ̀ ɑ̀ nɛò. ");
INSERT INTO mkl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ŋɔi ɑ̀ nɑɑɑ Jesu ɑmɑ ɡbɑnkɛlɛu wɑ. Nɔ ɑ̀ tɛ́ si ibɔ nŋɑ ŋɑ Jesu í bɛi í ɡũ ɑntɑɛ í bubɑ si. ");
INSERT INTO mkl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ŋɔi inɛ nkpɔ ɡɔ ŋɑ ɑ̀ tɛ jɑɑɛ nŋɑ ŋɑ si kpɑ̃ɑ, inɛ ɡɔ ŋɑ mɔ ɑ̀ dɑ wuɑ ŋɑ wɑ hɑi iko ŋɑ ɑ̀ wɑɑ tɔɔ si kpɑ̃ɑu. ");
INSERT INTO mkl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Inɛ ŋɑ iyi ɑ̀ wɑɑ cuɑ Jesu do inɛ ŋɑ iyi ɑ̀ wɑɑ tooɛ fei ɑ̀ wɑsi ku dɔ̃ ɑnu ɑ̀ wɑɑ ni, ɑ̀ wɑɑ sɑɑbuɛ. Aɔ̃ Lɑfɛ̃ɛ ku weeɛ, ɑwɔ iyi ì wɑɑ nɑɑ do iriɛ . ");
INSERT INTO mkl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ilɑɑɔ̃ ku weeɑ bommɑ iyi wɑ nɑɑ. Ku weeɑ bommɑi Dɑvidi, bɑlɑ nwɑ. Kɑ sɑɑbu Ilɑɑɔ̃ hee lele. ");
INSERT INTO mkl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ŋɔi Jesu í to Zeruzɑlɛmu, í koo í lɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃. Ŋɔi í cɔ mii fei í kɑɑkoɛ. Iyi í yɛ idũ wɑ dũ ŋɔi í bɔ Betɑni do mɔcɔ mɑɑteeji ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Iju kumɑ́ɛ Jesu do mɔcɔɛ ŋɑ ɑ̀ wɑɑ nɛ hɑi Betɑni ku bɑ ɑ bɔ Zeruzɑlɛmu mɑ́. Ŋɔi ɑri wɑ kpɑ Jesu. ");
INSERT INTO mkl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nɔ í hɔ̃nnɛ jĩi ndii fiɡi ɡɔ do wuɑɛ ŋɑ. Ŋɔi wɑ bɔ ku cɔ mɑ̀ ɑ́ bɑ siɛ iso. Ammɑ iyi í to kɔkɔɛ í bɑ wee wuɑ ŋɑi fei domi kù jɛ wɑɑtii kusoi fiɡi. ");
INSERT INTO mkl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ŋɔi í sɔ̃ jĩi nɔu í ni, inɛ ɡɔ kɑɑ jɛ isoɛ mɑ́ ɑjɔ kɑ̃mɑ. Nɔ mɔcɔɛ ŋɑu ɑ̀ ɡbɔ ideu. ");
INSERT INTO mkl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wɑɑti iyi ɑ̀ to Zeruzɑlɛmu Jesu í bɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃. Nɔ í lɔsi ku lele woo tɑ iwò ŋɑ do woo rɑ iwo ŋɑ iyi ɑ̀ wɑ bɛ. Í fukɑ fukɑ tɑɑbui woo kpɑɑsi fiɑ ŋɑ do kitɑ̃i woo tɑ ɑnkɑsiidi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kù jɛ inɛ kɑ̃mɑ ku so ɑso ɡɔ si inɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ŋɔi í sinti ku kɔ inɛ ŋɑu si cio í ni, ɑ̀ kɔɔ ɑ̀ ni, Ilɑɑɔ̃ í ni ilei nŋu ile bi ku tɔɔi inɛ feii ɑ́ jɛ. Ammɑ iŋɛ wee ì coo bi ku tɔtɔɔi ile ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iyi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ ɡbɔ ideu bɛ, ŋɔi ɑ̀ wɑɑ dɛ kpɑ̃ɑ iyi ɑɑ kpɑò Jesu, domi ɑ̀ wɑɑ ce njoɛ si nɑ iyi í jɔ̀ zɑmɑɑu fei í biti do sɑɑbui cioɛ. ");
INSERT INTO mkl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Iyi ɑlɛ í lɛ ŋɔi Jesu do mɔcɔɛ ŋɑ ɑ̀ fitɑ hɑi inɔ iluu. ");
INSERT INTO mkl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ŋɔi ɑ̀ wɑɑ lɔ dɑɑkɔ, nɔ ɑ̀ yɛ jĩi ndii fiɡiu í ɡbɛ hee do icɑ̃ɛ ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wee Piɛɛ wɑ ye ɡiɡii mii ŋɑ iyi í tɑko í ceu, ŋɔi í sɔ̃ Jesu í ni, Mɛɛtu, cɔ jĩi iyi ì ceekpeu í ɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, i dɑsi Ilɑɑɔ̃ nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ntɔ ntɔ, bii inɛ ɡɔ í sɔ̃ iri kutɑu ihɛ̃ í ni, dede hɑi bɛ i koo i dɑsi tenku nɔ kù wɑɑ sikɑ sikɑ si idɔɛ, bii í dɑsi nɑɑnɛ, bɛɛbɛ mɔi ɑ́ ce. ");
INSERT INTO mkl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nɑ iyi ihɛ̃i ǹ wɑ n sɔ̃ ŋɛ, mii iyi ì wɑɑ tɔɔ si kutɔɔ nŋɛ fei, i dɑsi nɑɑnɛ iyi ì bɑɑ tɑ̃ ŋɑ nɔ bɛɛbɛ mɔi ɑ́ ce nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wɑɑti iyi ì dede ì leekĩ ì wɑɑ bi i ce kutɔɔ ŋɑ, bii ì nɛ ide ɡɔ do inɛ ɡɔ ŋɑ i kpɑ idei kurɑrɑ iyi í wɑ si ɡɑ̃mɛi iŋɛò ŋɑ titɑ̃ ku bɑ Bɑɑ nŋɛ mɔ iyi í wɑ lele ku kpɑ idei dulum du ŋɛ.  ");
INSERT INTO mkl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ammɑ bii iŋɛ tɑkɑ nŋɛ i kù wɑɑ kpɑ idei kurɑrɑ iyi inɛ ŋɑ ɑ̀ ce nŋɛ, Bɑɑ nŋɛ mɔ iyi í wɑ lele kɑɑ kpe idei kurɑrɑ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ŋɔi ɑ̀ nyi ɑ̀ bɔ Zeruzɑlɛmu mɑ́. Iyi Jesu wɑ dɑbii si bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do woo kɔ inɛ ŋɑ si woodɑ ŋɑu do inɛ nɡbo ŋɑu ɑ̀ nɑɑ bi tɛɛ, ");
INSERT INTO mkl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ɑ̀ beeɛ ɑ̀ ni, mii ŋɑ iyi ì wɑɑ ceu ihɛ̃, yooi í nɑɛ kpɑ̃ɑ iyi ì wɑɑ cooò. Do yiikoi yooi ì wɑɑ cooò. ");
INSERT INTO mkl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ŋɔi Jesu í jɛ nŋɑ í ni, ɑmu mɔ ɑn bee ŋɛ ide ɡɔ. Bii ì yɔkɔ ì jɛɛm ŋɑ, ɑn sɔ̃ ŋɛ inɛ iyi í nɑm yiiko ǹ wɑ n ceò mii ŋɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Hɑi iwoi Zɑ̃ɑ í bɑ yiiko iyi í dɑsiò inɛ ŋɑ inyi. Hɑi bi Ilɑɑɔ̃ de, mɑ hɑi bi ɑmɑnɛ ŋɑ. I jɛɛm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nɔ ɑ̀ busi njɛ ɑ̀ wɑɑ ni, bɛirei ɑɑ kɑ jɛɑɑ. Nsɛi nɔɔ, bii ɑ̀ jɛɑɑ ɑ̀ ni hɑi bi Ilɑɑɔ̃i, ɑ́ bee wɑ bɛirei í ce ɑ kù dɑsi Zɑ̃ɑ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bii ɑ̀ nɔ ɑ̀ ni hɑi bi ɑmɑnɛ ŋɑi, to. Wee ɑ̀ fɔ bɛɛbɛi si nɑ iyi í jɔ̀ ɑ̀ wɑɑ ce njoi zɑmɑɑu, domi zɑmɑɑu fei í jɛsi iyi Zɑ̃ɑ wɑliii kɑm kɑm. ");
INSERT INTO mkl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ŋɔi í jɔ̀ ɑ̀ jɛɑ Jesu ɑ̀ ni, ɑ kù mɑ̀. Nɔ Jesu mɔ í sɔ̃ ŋɑ í ni, to, debɛi ɑmu mɔ, n kɑɑ n sɔ̃ ŋɛ yiikoi inɛ iyi ǹ wɑ n ceò mii ŋɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Si ɑnyii nŋu, Jesu í lɔsi ku sɔ̃ ŋɑ ide do mɔndɑ. Í ni, inɛ ɡɔ í ce ikoɛ, í lɔ si jĩi ndii rezɛ̃ɛ ŋɑ nɔ í ce kɑɑ í kɑɑkoɛò. Nɔ í ce bi ku fɔ̃ inyii isoɛ. Nɔ í cɑ̃ tɑfɑ bii ku deɡbe ikou. Ŋɔi í so ɡɑɑnɔɔmɑ ŋɑ í dɑsi ŋɑ si ikou ɑ mɑɑ loɡooɛ, í bɛi í bɔ ilu koo kpɛ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wɑɑti iyi jĩi nɔu í so í to ku kɑ ŋɔi í bɛ woo ce icɛ ɡɔ bi ɡɑɑnɔɔmɑ ŋɑu koo ɡbɑ iyi í jɛ ti nŋu wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ŋɔi ɑ̀ muu ɑ̀ cɑ̃ɑ nɔ ɑ̀ leleɛ í nɛ ɑwɔ nɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nɔ ilu ikou í bɛ woo ce icɛ mmu mɑ́ bi tu ŋɑ. Ŋɔi ɑ̀ bu nŋu mɔ nɔ ɑ̀ cɑ̃ɑ si iriɛ. ");
INSERT INTO mkl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nɔ í bɛ ɑmɑnɛ mɛɛtɑsiɑ nɔ ɑ̀ cɑ̃ɑ ɑ̀ kpɑɑ. Bɛɛbɛi ɑ̀ ceɑ inɛ nkpɔ mɑ́. À cɑ̃ inɛ ɡɔ ŋɑ nɔ ɑ̀ kpɑ inɛ ɡɔ ŋɑ mɔ. ");
INSERT INTO mkl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nsɛi í ɡbe ɑmɑ ɑbíi ilu ilɛu iyi í bi jiidɑ jiidɑ. Nŋui í bɛ do ɑnkɑ̃ɑnyi í ni, ɑɑ jirimɑ ɑmɑm. ");
INSERT INTO mkl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ammɑ wɑɑti iyi ɑmɑɛu wɑ to, woo ce icɛ ŋɑu ɑ̀ fɔ ɑŋɑ duusɔ̃ɔ ɑ̀ wɑɑ ni, i cɔ inɛ iyi ɑ́ nɑ ku jɛ tubuu. Kɑ kpɑɑ nɔ tubuu ku bɑɑ ku jɛ tu wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ŋɔi ɑ̀ muu ɑ̀ kpɑɑ nɔ ɑ̀ soo ɑ̀ koo ɑ̀ nyɔɔ do ɑlɑlɑi kɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ŋɔi Jesu í ni, to, bɛbɛi bɛirei ilu ikou tɑkɑɛ ɑ́ ce nŋɑ. Á koo ku kpɑ ŋɑi nɔ ku dɛ inɛ mmu ŋɑ ku dɑsi ŋɑ ikou. ");
INSERT INTO mkl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","To, i kù cio kukɔi idei Ilɑɑɔ̃u ŋɑ tenɡi bii í ni, Kutɑ iyi woo mɑ ŋɑ ɑ̀ kɔsiu Nŋui í bɑɑ í jɛ kutɑ sintei icui ileu. ");
INSERT INTO mkl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aɔ̃ Lɑfɛ̃ɛi í coo, nɔ í mu wɑ biti. ");
INSERT INTO mkl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi inɛ nɡboi Zuifu ŋɑu ɑ̀ wɑɑ dɛ Jesu ku mu, domi ɑ̀ mɑ̀ nɑ irii ɑŋɑi í kpɑ mɔndɑu. Ammɑ si bɛi ɑ̀ wɑɑ ce njoi zɑmɑɑu, ŋɔi í jɔ̀ ɑ̀ jɔ̀ɔ ɑ̀ nɛ. ");
INSERT INTO mkl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ŋɔi inɛ nɡboi Zuifu ŋɑu ɑ̀ bɛ Fɑrisi ɡɔ ŋɑ do inɛi Herodu ɡɔ ŋɑ bi Jesu ɑ koo ɑ leɑ tɑɑi ide. ");
INSERT INTO mkl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iyi ɑ̀ to bi tɛɛ nɔ ɑ̀ sɔ̃ɔ ɑ̀ ni, Mɛɛtu, ɑ̀ mɑ̀ iyi ì yɑ fɔ ntɔ. Bɛɛbɛ mɔi i kù wɑɑ ce njoi inɛ ɡɔ, domi i ci yɑ cɔ ijui ɑmɑnɛ ŋɑ, ɑmmɑ ì wɑɑ kɔ inɛ ŋɑ si idei Ilɑɑɔ̃ do ntɔ. Í sĩɑ kɑ sɑ̃ɑ ilɑɑlu Sezɑɑ fiɑi lɛmpoo? Mɑ̀ kɑ mɑɑ̀ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ammɑ Jesu í mɑ̀ muɑfiti nŋɑ, nɔ í ni, bɛirei í ce ì wɑɑ leem tɑɑi ide ŋɑ. I nɑɑm kpɛkɛlɛ ɑkɑ̃ wɑ n cɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ŋɔi ɑ̀ nɑɑ ɑkɑ̃ wɑ. Nɔ Jesu í bee ŋɑ í ni, fotooi yooi í wɑ si kpɛkɛlɛu ihɛ̃ nɔ irii yooi ɑ̀ kɔ si. Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, ti Sezɑɑi. ");
INSERT INTO mkl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, to, i sɑ̃ɑ Sezɑɑ iyi í jɛ tɛɛ ŋɑ. Nɔ i sɑ̃ɑ Ilɑɑɔ̃ mɔ iyi í jɛ tɛɛ ŋɑ. Ŋɔi inɛ ŋɑ ɑ̀ biti ntɔ ntɔ do yɑɑse bɛi í fɔò ide. ");
INSERT INTO mkl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ŋɔi Sɑdusi ɡɔ ŋɑ ɑ̀ nɑɑ bi Jesu. Aŋɑi ɑ̀ yɑ mɑɑ ni iku ŋɑ ɑ kɑɑ jĩ. Iyi ɑ̀ to wɑ bi Jesu ŋɔi ɑ̀ beeɛ ɑ̀ ni, ");
INSERT INTO mkl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Mɛɛtu, tɑko wo Moizi í kɔ̀ nwɑ í ni, bii inɛ ɡɔ í ku í jɔ̀ ɑboɛ, nɔ nŋu do ɑboɛu ɑ kù nɛ ɑmɑ, ifɔɛ ku so jɑɑɔ̃u ku bɑ ku bíɑ iɡbɑ̃ɛ ɑmɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wee, inɛ mɛɛje ɡɔ ŋɑ ɑ̀ wɛɛ iyi ɑ̀ jɛ ɑmɑi bɑɑ ɑkɑ̃. Iɡbɑ̃ nŋɑ í so ɑbo nɔ í ku, nŋu do ɑboɛ ɑ kù nɛ ɑmɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ŋɔi inɛ minjisiɑu í so jɑɑɔ̃u nɔ nŋu mɔ í ku, kù bɑ ɑmɑ. Ŋɔi inɛ mɛɛtɑsiɑu mɔ í ce bɛɛbɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nɔ ɑŋɑ mɛɛje iyi ɑ̀ so ɑbou fei ɑ̀ kú, bɑɑ inɛ ɑkɑ̃ nŋɑ kù bɑ ɑmɑ. Si ɑnyi nŋɑ, ŋɔi ɑbou mɔ í nɑ í ku. ");
INSERT INTO mkl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To, ɑjɔ iyi iku ŋɑ ɑɑ nɑ ɑ jĩ, ɑboi yoo nŋɑi ɑ́ jɛ, si bɛi ɑŋɑ mɛɛjeu fei ɑ̀ soo ɑboi. ");
INSERT INTO mkl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ŋɔi Jesu í jɛ nŋɑ í ni, ì wɑɑ rɑrɑ ŋɑi si nɑ iyi í jɔ̀ i kù mɑ̀ ɡbuɡbɑ̃i Ilɑɑɔ̃ ŋɑ hee mɑ jɛ mii iyi kukɔi ideɛ wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ntɔ ntɔ, si wɑɑti iyi iku ŋɑ ɑɑ nɑ ɑ jĩ, wɑɑti bɛɛbɛ inɛmɔkɔ do inɑɑbo ŋɑ ɑ kɑɑ so njɛ mɑ́, ɑmmɑ ɑɑ yɛi bɛi ɑmɑlekɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iyi í jɛ ti idei kujĩi iku ŋɑ, Moizi í kɔ si tiɑɛ tenɡi bii wɑ fɔ idei ɑmɑ jĩi nɔu. Tenɡi bɛi Ilɑɑɔ̃ í sɔ̃ɔ ide ɡɔ. Í ni nŋu Aɔ̃ Lɑfɛ̃ɛi Aburɑhɑmui, do ti Izɑɑki, do ti Zɑkɔbu. I kù cio ideu bɛ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bii Ilɑɑɔ̃ í ni nŋu í jɛ Lɑfɛ̃ɛi inɛ ɡɔ ŋɑ iyi ɑ̀ kú, iyi bɛ wɑ nyisi iyi inɛ ŋɑu ɑ̀ wɛɛ bɑɑ bii ɑ̀ ku. Ntɔ ntɔ, Ilɑɑɔ̃ kù jɛ Lɑfɛ̃ɛi iku ŋɑ, Lɑfɛ̃ɛi inɛ ŋɑ iyi ɑ̀ wɛɛi. Debɛi i kù yɛ iyi ì wɑ si kurɑrɑ nlɑ nlɑ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ŋɔi inɛ ɑkɑ̃i woo kɔ inɛ ŋɑ si woodɑ ŋɑu í ɡbɔ ɑ̀ wɑɑ ce kɑkɔɔu. Í yɛ iyi Jesu í jɛɑ Sɑdusi ŋɑu í ce ncɛɛ. Ŋɔi í bɔ bi Jesu í beeɛ í ni, si woodɑ ŋɑu fei yoomɑi í re. ");
INSERT INTO mkl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ŋɔi Jesu í jɛɑɑ í ni, woodɑ iyi í reu wee. I de itĩ i ɡbɔ, iŋɛ inɛi Izirɛli ŋɑ. Ilɑɑɔ̃ Lɑfɛ̃ɛ nwɑ, nŋu ɑkɑ̃i í jɛ Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bi Aɔ̃ Lɑfɛ̃ɛɛ do idɔɛ fei, do lɑsɑbuɛ fei, do ɡbuɡbɑ̃ɛ fei. ");
INSERT INTO mkl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Minjisiɑu wee. Bi inɛ mmu ŋɑ bɛi ì bi ɑrɑɛ. Woodɑ ɡɔ kù wɛɛ iyi í re bɛɛbɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ŋɔi woo kɔ inɛ ŋɑ si woodɑu í sɔ̃ Jesu í ni, í sĩɑ Mɛɛtu. Ide iyi ì fɔu ntɔi. Ilɑɑɔ̃ ɑkɑ̃i í wɛɛ, nɔ Lɑfɛ̃ɛ ɡɔ kù wɛɛ mɑ́ bii kù jɛ nŋu ɑkɑ̃u. ");
INSERT INTO mkl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Amɑnɛ ku bi Ilɑɑɔ̃ do idɔɛ fei, do lɑsɑbuɛ fei, do ɡbuɡbɑ̃ɛ fei, nɔ ku bi inɛ ŋɑ bɛi í bi ɑrɑɛ, inɛ nŋu bɛi í sĩɑ í re kuwee iyi ɑ̀ yɑ jo si inɑ fei sɑ̃ɑ sɑ̃ɑ do kuwee ŋɑ iyi ɑ̀ ɡbe fei. ");
INSERT INTO mkl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iyi Jesu í yɛ í jɛ do lɑsɑbu jiidɑ, ŋɔi í sɔ̃ɔ í ni, í ɡbe keeke i jɛsi Ilɑɑɔ̃ ku jɛ ilɑɑluɛ. Si ɑnyii nŋu, inɛ kɑ̃mɑ kù jɛ ku bee Jesu ide ɡɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Si ɑnyii nŋu, Jesu í wɑsi ku kɔɑ inɛ ŋɑ si cio inɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ nɔ í bee ŋɑ í ni, bɛirei í ce woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ ni inɛ iyi Ilɑɑɔ̃ í cicɑu tɔkui ilɑɑlu Dɑvidii. ");
INSERT INTO mkl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dɑvidi tɑkɑɛ í fɔ do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃ í ni, Aɔ̃ Lɑfɛ̃ɛ í sɔ̃ Lɑfɛ̃ɛm í ni, Bubɑ si ɑwɔ njɛm, Hee n ce mbɛɛɛ ŋɑ bi ku lesi isɛɛ. ");
INSERT INTO mkl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nɔ Jesu í ni mɑ́, to, bii Dɑvidi tɑkɑɛ wɑ kpoo Lɑfɛ̃ɛ, bɛirei ɑ́ ce ku jɛ tɔkuɛ mɑ́. Nɔ zɑmɑɑ nkpɔ ɡɔ wɑ ɡbɔ idei Jesu do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wɑ sɔ̃ ŋɑ si cioɛu wɑ ni, i mu ɑrɑ nŋɛ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu, ɑŋɑ iyi ɑ̀ yɑ bi ɑ mɑɑ dɑbii do jɑbɑ ŋɑu nɔ ɑ̀ bi inɛ ŋɑ ɑ yɑ ce ɑŋɑ fɔɔ do jirimɑ si bɑntumɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","À ci yɑ bi kɑɑ kitɑ̃i inɛ nɡbo ŋɑ ile bi ku ce kutɔtɔɔ, do inyɑ sinte bi ku ce jinɡɑu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","À yɑ tɑkii jɑɑɔ̃ ŋɑ ɑ ɡbɑ mii ndu ŋɑ ŋɑ fei, nɔ ɑ̀ yɑ mɑɑ ce kutɔɔ sisɔ ku bɑ ɑ yɛ ŋɑ nŋu ɑkɑ̃. Nɑ ŋɔi í jɔ̀ ijuukpɑ̃ nŋɑ ɑ́ lɑ ku cɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ŋɔi Jesu í koo í bubɑ kɔkɔi kpɑkoi kɔlɛtiu wɑ cɔ bɛi inɛ ŋɑ ɑ̀ wɑɑ dɑsi fiɑ. Ilu fiɑ ɡɔ ŋɑ ɑ̀ dɑsi fiɑ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ŋɔi jɑɑɔ̃ ilu ɑre ɡɔ mɔ í nɑɑ, ŋɔi í dɑsi kpɛkɛlɛ keeke minji ɡɔ ŋɑ iyi kù re bɑɑ dɑlɑ. ");
INSERT INTO mkl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ŋɔi Jesu í kpe mɔcɔɛ ŋɑu í sɔ̃ ŋɑ í ni, ntɔ ntɔ, jɑɑɔ̃ ilu ɑreu í dɑsi fiɑ si kpɑkoi kɔlɛtiu ihɛ̃ í re inɛ fei, ");
INSERT INTO mkl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","domi ɑŋɑ fei, iyi í lesi ɑntɑi fiɑ nŋɑ ŋɑi ɑ̀ dɑsi, ɑmmɑ ɑbou bɑɑ do iyi í jɛ ilu ɑre, í dɑsii ɑndi iyi í nɛ fei, nkɑ̃mɑ kù ɡbeɑ iyi ɑ́ mɑɑ wɛɛò mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ŋɔi Jesu wɑ fitɑ wɑ hɑi bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ nɔ mɔcɔ ɑkɑ̃ɛ ɡɔ í ni, Mɛɛtu, cɔ bɛi kpɑsɛ̃i Ilɑɑɔ̃u ihɛ̃ í lɑ nɔ ɑ̀ mɑɑ do kutɑ kusĩɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ŋɔi Jesu í ni, ì wɑɑ yɛ ile nlɑ ŋɑu ihɛ̃? Kutɑ bɑɑ ɑkɑ̃ kɑɑ nɑ ku mɑɑ lesi njɛ bɛ mɑ́, ɑɑ kɛkɛɛ mbɛ fei. ");
INSERT INTO mkl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ŋɔi Jesu í koo í bubɑ si iri kutɑi Olivieu wɑ cɔ ikpɑ kpɑsɛ̃i Ilɑɑɔ̃. Ŋɔi Piɛɛ do Zɑɑki do Zɑ̃ɑ do Anderee ɑ̀ wɑ bi Jesu ɑŋɑ nŋɑ. Ŋɔi ɑ̀ beeɛ ɑ̀ ni, ");
INSERT INTO mkl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","sɔ̃ wɑ wɑɑti iyi mii nɔu bɛ ɑ́ ce. Nyindɑ yoomɑi ɑɑ kɑ yɛ kɑ bɑ kɑ mɑ̀ iyi wɑɑtiu í to. ");
INSERT INTO mkl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ŋɔi Jesu í jɛ nŋɑ í ni, i ce lɑɑkɑi ŋɑ inɛ ɡɔ ku mɑɑ̀ nɑ ku dĩ iju nŋɛ, ");
INSERT INTO mkl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","domi inɛ ŋɑ iyi ɑɑ nɑ ɑ mɑɑ nɑɑ ɑkɑ̃ ɑkɑ̃ ɑ mɑɑ ni ɑŋɑi ɑ̀ jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu ɑɑ kpɔ. Aɑ dĩ ijui inɛ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bii ì ɡbɔ ibɑi iɡũ ɑmɛɛ ɑmɛɛ ŋɑ do bɑɑui iɡũ ŋɑ hee jĩijĩ i mɑɑ̀ jɔ̀ idɔ nŋɛ ku dede, domi í ɡbe mii ŋɑu bɛ fei ku cei. Ammɑ kù nɔ kù jɛ wɑɑtii ɑnkɑ̃ɑnyiu bɛ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dimi ɡɔ ŋɑ ɑɑ yɑ nɑ ɑ mɑɑ jɑ do dimi mmu ŋɑ, nɔ ilɑɑlu ɡɔ ŋɑ mɔ ɑɑ mɑɑ jɑ do ilɑɑlu mmu ŋɑ. Nɔ ilɛ ɑ́ yɑyɑ si ilu ɡɔ ŋɑ, nɔ ɑri ɑ́ ce. Nŋu bɛ ɑ́ yɛi bɛi ɑrɑ kuro sintei bɑ̃ɑsĩ ku bɛi ku bí. ");
INSERT INTO mkl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ammɑ iŋɛ tɑkɑ nŋɛ i ce lɑɑkɑi. Aɑ nɑ ɑ mu ŋɛ ɑ koo ɑ nɑ woo kiiti ŋɑ, nɔ ɑ tɛ nŋɛ kpɔtɔɔ ile bi kutɔtɔɔ ŋɑ. Nɔ ɑɑ bɔò ŋɛ bi ilɑɑlu ŋɑ do bi ilu ilɛ ŋɑ nɑ irim ku bɑ i jɛ nŋɑ sɛɛdɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ammɑ í ɡbe ɑ wɑɑzoɑ inɛ ŋɑ lɑɑbɑɑu jiidɑi Ilɑɑɔ̃ si dimi fei wɑɑtii ɑnkɑ̃ɑnyiu ku bɛi ku to wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wɑɑti iyi ɑ̀ mu ŋɛ ɑ̀ wɑɑ bɔ ku nɑ woo ce kiiti ŋɑu, i mɑɑ̀ ti i biti do ide iyi ɑɑ fɔ ŋɑ, ɑmmɑ bii ɑwɑɑtiu í to i fɔ ide iyi í nɑɑ nŋɛ si idɔ. Nɔ ide ŋɑ iyi ɑɑ fɔ ŋɑ kɑɑ jɛ ide nŋɛ, Hundei Ilɑɑɔ̃i ɑ́ fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Inɛ ɡɔ ŋɑ ɑɑ zɑmbɑ ifɔ nŋɑ ŋɑ wɑlɑkɔ iɡbɑ̃ nŋɑ ŋɑ ku bɑ ɑ kpɑ ŋɑ. Bɛɛbɛ mɔi bɑɑ ŋɑ ɑɑ mɑɑ ceɑ ɑmɑ nŋɑ ŋɑ. Amu ŋɑ mɔ ɑɑ dede si bɑɑ nŋɑ ŋɑ ku bɑ ɑ kpɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Inɛ fei ɑ́ cé ŋɛi nɑ irim. Ammɑ inɛ iyi í temuɑ hee kɔɔ ɑ́ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nɔ Jesu í ni mɑ́, ɑɑ yɛ mii lɑɑlɔ iyi wɑ bɛjɛ mii ŋɑ tenɡi bii kù jɔ ku wɑ ŋɑ. Inɛ iyi wɑ cio idei mii lɑɑlɔu ku ce lɑɑkɑi ku ɡbɔɔ sɑ̃ɑ sɑ̃ɑ. Wɑɑti bɛɛbɛ inɛ ŋɑ iyi ɑ̀ wɑ ilɛi Zudee ɑ sɑ ɑ bɔ iri kutɑ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nɔ inɛ iyi í wɑ ɑntɑi ile sikifɑ, bii í kitɑ ilɛ ku bɑ ku sɑ ku mɑɑ̀ bɔ nɡɔɡɔ ku so inɔ ileɛ. ");
INSERT INTO mkl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nɔ inɛ mɔ iyi í wɑ iko ku mɑɑ̀ nyi kpɑsɛ̃ koo so kumbooɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wɑɑtii bɛɛbɛ wɑhɑlɑi bɑ̃ɑsĩ ŋɑ do ɑyɑwo ŋɑ ɑ́ cɑɑ mɔm. ");
INSERT INTO mkl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","I ce kutɔɔ ŋɑ ku bɑ ide sɑ̃miu bɛ ku mɑɑ̀ jɛ si sukui tũtũ. ");
INSERT INTO mkl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ntɔ ntɔ, ɑjɔ nŋu wɑhɑlɑ nlɑ nlɑi ɑ́ nɑɑ iyi ɑ kù yɛ dimiɛ hɑi sinte wɑɑti iyi Ilɑɑɔ̃ í tɑkɑ ɑndunyɑ hee ku bɑɑ nsɛi. Nɔ ɑ kɑɑ kɑ yɛ dimiɛ mɑ́ hee do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nɔ bii Aɔ̃ Lɑfɛ̃ɛ kù jilɛ si nŋu ku kɑye kukpɔi ɑjɔu wo inɛ ɡɔ kɑɑ wɛɛ mɑ́. Ammɑ í kɑyeɛ nɑ irii inɛ ŋɑ iyi í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wɑɑti bɛɛbɛ bii inɛ ɡɔ í sɔ̃ ŋɛ í ni, i cɔ, inɛ iyi Ilɑɑɔ̃ í cicɑu í wɑ ihɛ̃, wɑlɑkɔ inɛ mmu ɡɔ ku ni í wɑ ihɔ̃, i mɑɑ̀ dɑsi lɑfɛ̃ɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Inɛ ɡɔ ŋɑ ɑɑ nɑ ɑ nɑɑ ɑkɑ̃ ɑkɑ̃ ɑ mɑɑ ni ɑŋɑi ɑ̀ jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu wɑlɑkɔ ɑ ni ɑŋɑi ɑ̀ jɛ wɑlii ŋɑ ɑmmɑ iboi. Aɑ mɑɑ ce dobu dobu do mɑɑmɑɑke ŋɑ ku bɑ ɑ dĩ hee do ijui inɛ ŋɑ iyi Ilɑɑɔ̃ í cicɑu bii ɑɑ yɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","To, iŋɛ, i mɑ́ɑ ce lɑɑkɑi ŋɑ. Nɑ ŋɔi í ce ǹ wɑ n sɔ̃ ŋɛ fei ndɛɛ do njumɑ. ");
INSERT INTO mkl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ammɑ si ɑjɔ nŋu si ɑnyii wɑhɑlɑu, inunu ɑ́ kuku inyɑ, cukpɑ mɔ kɑɑ mɑ́ inyɑ mɑ́, ");
INSERT INTO mkl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ɑndɑiyɑ ŋɑ ɑɑ cuku wɑ hɑi lele, nɔ ɡbuɡbɑ̃i lele ŋɑ ɑ yɑyɑ. ");
INSERT INTO mkl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wɑɑti bɛɛbɛ inɛ ŋɑ ɑɑ yɛ ɑmu Amɑi Amɑnɛ, ǹ wɑ n nɑɑ si kudũi ijĩ do ɡbuɡbɑ̃ nlɑ ɡɔ do ɑmboe. ");
INSERT INTO mkl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Si ɑnyii nŋu, ɑn bɛ ɑmɑlekɑ ŋɑ wɑ si ɑndunyɑ ɡontɑ mɛɛu. Aŋɑi ɑɑ bɔ bii fei ɑ tɔtɔɔ inɛ ŋɑ iyi ǹ cicɑu. Aɑ tɔtɔɔ ŋɑ si ɑndunyɑu fei. ");
INSERT INTO mkl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jesu í ni, i cɔ mii iyi jĩi ndii fiɡi wɑ kɔ ŋɛ si ŋɑ. Bii ì nɑ ì yɛ ɑmɑɑwɔɛ ŋɑ ɑ̀ sinti ku wu wuɑ kpɔtɔɔ ì yɑ mɑ̀ iyi ɑtɛ í mɑɑi wɑ mbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bɛɛbɛ mɔi, bii ì yɛ mii ŋɑu bɛ fei wɑ ce, i mɑ̀ ŋɑ iyi kubɑɑi ɑmu Amɑi Amɑnɛ kɑɑ kpɛ mɑ́, ɑjɔu í mɑɑi wɑ mɔm. ");
INSERT INTO mkl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ntɔ ntɔ, ǹ wɑ n sɔ̃ ŋɛi, kù jɛ inɛi nsɛi ŋɑ feii ɑɑ ku ideu ku bɛi ku ce. ");
INSERT INTO mkl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lele do ilɛ fei ɑ́ nɑ ku tɑ̃, ɑmmɑ idem ŋɑ kɑɑ tɑ̃ pɑi. ");
INSERT INTO mkl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jesu í sɔ̃ ŋɑ mɑ́ í ni, inɛ kɑ̃mɑ kù mɑ̀ wɑɑtiu hee mɑ jɛ ɑjɔ iyi mii ŋɑu ɑ́ ce, bɑɑ ɑmɑlekɑ ŋɑ iyi ɑ̀ wɑ lele, bɑɑ ɑmu Amɑu, í ɡbe Ilɑɑɔ̃ Bɑɑbɑ nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","I ce lɑɑkɑi ŋɑ, i yɑ mɑɑ cɔ kpɑ̃ɑ nɔ i yɑ ce kutɔɔ ŋɑ si nɑ iyi í jɔ̀ i kù mɑ̀ wɑɑti iyi ɑjɔu ɑ́ to wɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Á yɛi bɛi inɛ iyi wɑ bɔ ilu nɔ í jɔ̀ɑ woo ce icɛɛ ŋɑ kpɑsɛ̃ɛ í nɑ inɛ fei icɛɛ, nɔ í sɔ̃ woo deɡbe ɑndɛ koofɑu ku mɑɑ cɔ kpɑsɛ̃u. ");
INSERT INTO mkl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Si nɑ iyi í jɔ̀ i kù mɑ̀ ŋɑ mɑ ɑlɛi ilu kpɑsɛ̃u ɑ́ nɑ ku to wɑ wɑlɑkɔ idũ lɑjɑ, wɑlɑkɔ wɑɑtii kukɔi jɛɛ, wɑlɑkɔ dɑɑdɑɑkɔ, nɑ nŋu, i mɑ́ɑ cɔ kpɑ̃ɑ ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ku bɑ ku mɑɑ̀ nɑɑ ku bɑ ŋɛ ì wɑɑ sĩ njoo ŋɑ, nɔ ku mɑɑ̀ nɑɑ ku boe ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ide iyi ǹ wɑ n sɔ̃ ŋɛu ihɛ̃, nŋu mɔi ǹ wɑ n sɔ̃ inɛ fei. I mɑ́ɑ cɔ kpɑ̃ɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Si ɑfei ɑjɔ minji jinɡɑui Iku ku kuɑ do ti Pɛ̃ɛ hɑi nɛ lefee ɑ́ to wɑ. Ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ wɑɑ dɛ kpɑ̃ɑ bɛi ɑɑ ce ɑ mu Jesu do bisi ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ammɑ ɑ̀ wɑɑ ni, kù sĩɑ ku jɛ si ɑjɔi jinɡɑuu ku bɑ hoyɑ hoyɑ ku mɑɑ̀ dede si zɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesu í wɑ Betɑni kpɑsɛ̃i Simɔɔ iyi í tɑko í ce bɔ̃ɔi dintɛu, ŋɔi ɑbo ɡɔ í lɔ wɑ bi tɛɛ wɑɑti iyi ɑ̀ wɑɑ jɛ. Wɑ mu ɑmɑ cɑkɑ ku sĩɑ ɡɔ iyi ɑ̀ ce do ɑbɑtii, iyi í nɛ tulɑre ku nɛ fiɑ iyi ɑ̀ ce do ikpoi nɑɑdi. Tulɑreu í bɛi í cɑɑdɑ. Ŋɔi í lɛɡɛ ɑmɑ cɑkɑu nɔ í fɑ̃si tulɑreu si irii Jesu. ");
INSERT INTO mkl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nɔ inɛ ɡɔ ŋɑ ɑ̀ wɑ bɛ. À sɔ̃ njɛ do idɔɔkɔ̃ ɑ̀ wɑɑ ni, nɑ mii í ce ɑbou ihɛ̃ í koo í ce ɑsɔɔi tulɑreu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aɑ kɑ tɑɑi wo zɑkɑi fiɑi icɛi ɑdɔ̃ ɑkɑ̃ nɔ kɑ muɑ ilu ɑre ŋɑ. Ŋɔi ɑ̀ wɑɑ lɑ si ɑbou do kuɡɑɑbu. ");
INSERT INTO mkl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ammɑ Jesu í ni, i jɔ̀ ɑbou. Nɑ mii í ce ì wɑɑ yɛ tɑɑleɛ ŋɑ. Mii jiidɑi í ceem bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ntɔ ntɔ, ilu ɑre ŋɑ ɑɑ mɑɑ wɛɛ do iŋɛ wɑɑti kɑ̃mɑ fei, nɔ wɑɑti iyi ì bi fei ɑɑ yɔkɔ i ce nŋɑ jiidɑ ŋɑ, ɑmmɑ ɑmu n kɑɑ n nɑ n wɛɛ do iŋɛ hee do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Abou í ce ɑndi ɡbuɡbɑ̃ɛ iyi ɑ́ yɔkɔ mbɛ, í fɑ̃si ɑrɑm tulɑre do njuumɑ bɛ́i ɑ̀ yɑ fɑ̃si ɑrɑi iku ŋɑ ɑ bɛi ɑ si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ntɔ ntɔ, tenɡi bii inɛ ŋɑ ɑɑ koo ɑ mɑɑ wɑɑzo lɑɑbɑɑu jiidɑu si ɑndunyɑ fei, ɑɑ sisi ide iyi ɑbou ihɛ̃ í ce ɑ mɑɑ yeò ɡiɡiɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ŋɔi Zudɑsi Isikɑriɔti, inɛ ɑkɑ̃i mɔcɔ mɑɑteeji ŋɑu, í bɔ bi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu í ni nŋu ɑ́ dɑ nŋɑ Jesu si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iyi ɑ̀ ɡbɔ ideu, ŋɔi inɔ nŋɑ í dɔ̃ nɔ ɑ̀ ni ɑŋɑ ɑɑ muɑɑ fiɑ. Ŋɔi Zudɑsi wɑ dɛ kpɑ̃ɑ bɛ́i ɑ́ ce ku zɑmbɑò Jesu ku nɑ inɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Si ɑjɔ sintei jinɡɑui Pɛ̃ɛ hɑi nɛ lefeeu, si wɑɑti iyi inɛ ŋɑ ɑ̀ yɑ sɑkɑ ɑnɡudɑ̃i jinɡɑui Iku ku kuɑ ɑ ceò kuwee, ŋɔi mɔcɔi Jesu ŋɑu ɑ̀ beeɛ ɑ̀ ni, iwoi ì bi kɑɑ ceeɛ ijɛi jinɡɑuu. ");
INSERT INTO mkl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ŋɔi í bɛ ɑmɑnɛ minji si inɔi mɔcɔɛ ŋɑu í sɔ̃ ŋɑ í ni, i bɔ inɔ ilu, ɑɑ yɛ mɔkɔ ɡɔ wɑ so inyi jɔlɔ. I tooɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mɔkɔu ɑ́ koo ku lɔ kpɑsɛ̃ ɡɔ. Kpɑsɛ̃ bii ɑ́ lɔu, i koo i sɔ̃ ilu kpɑsɛ̃u i ni ŋɑ, Mɛɛtu í ni kɑ beeɛ ile bii nŋu ɑ́ jɛ jinɡɑui Iku ku kuɑ do mɔcɔi nŋu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mɔkɔu ɑ́ bɔò ŋɛ si ɑntɑi ile ku kpɛkɛ ɡɔ nɔ ɑ́ nyisi ŋɛ ilɑɑwɑ nlɑ ɡɔ iyi ɑ̀ ce sɔɔlui fei ndɛɛ tɑ̃. Bɛi ɑɑ ce nwɑ sɔɔlui jinɡɑuu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ŋɔi mɔcɔ ŋɑu ɑ̀ dɑsi kpɑ̃ɑ ɑ̀ nɛ. Iyi ɑ̀ to inɔ iluu nɔ ɑ̀ yɛ ideu í ce bɛi Jesu í sɔ̃ ŋɑu, ŋɔi ɑ̀ ce ijɛi jinɡɑuu bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Iyi ɑlɛ í lɛ, ŋɔi Jesu í to wɑ do mɔcɔ mɑɑteeji ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wɑɑti iyi ɑ̀ wɑɑ jɛ ŋɔi Jesu í ni, ntɔ ntɔ, inɛ ɑkɑ̃ nŋɛ iyi ɑwɔò ɑ̀ wɑɑ jɛ, nŋui ɑ́ zɑmbɑm. ");
INSERT INTO mkl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ŋɔi inɔi ɑŋɑ fei í fɔ, nɔ ɑ̀ wɑsi ku beeɛ ɑkɑ̃ ɑkɑ̃ ɑ̀ wɑɑ ni, isɑ kù jɛ ɑmu yɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ŋɔi Jesu í jɛ nŋɑ í ni, si inɔi iŋɛ mɑɑteejiu, inɛ ɑkɑ̃ nŋɛ ɑ́ ɡũsi pɛ̃ɛ si inɔ jɛɛ ɑwɔò ɑjɔ. Lɑfɛ̃ɛi ɑ́ zɑmbɑm. ");
INSERT INTO mkl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Do ntɔ ɑmu Amɑi Amɑnɛ ɑn ku si bɛi kukɔi idei Ilɑɑɔ̃ wɑ fɔ. Ammɑ inɛ iyi ɑ́ zɑmbɑm ɑ́ yɛ ijuukpɑ̃ nlɑ nlɑ. Á tiɑɑ inɛɛu bii í jɛ ɑ kù búu mɔm wo. ");
INSERT INTO mkl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wɑɑti iyi ɑ̀ wɑɑ jɛ, ŋɔi Jesu í so pɛ̃ɛ í sɑɑbu Ilɑɑɔ̃ titɑ̃ í bɛi í bububuɛ í nɑ mɔcɔɛ ŋɑu í ni, i ɡbɑ ŋɑ. Iyi ihɛ̃i í jɛ ɑrɑm. ");
INSERT INTO mkl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ŋɔi í so kɔɔfu mɑ́ si bii ɑ̀ dɑsi vɛ̃ɛ í sɑɑbu Ilɑɑɔ̃ nɔ í nɑ ŋɑ ɑŋɑ fei ɑ̀ mɔ. ");
INSERT INTO mkl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ŋɔi í sɔ̃ ŋɑ í ni, iyi ihɛ̃i í jɛ njɛm. Nŋui í jɛ nyindɑi ɑkɑbuu iyi Ilɑɑɔ̃ í dĩ do ɑmɑnɛ ŋɑ. An nikɑ̃ɛ nɑ irii dulum dii inɛ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ntɔ ntɔ, n kɑɑ n mɔ ɑtɛ̃ vɛ̃ɛ mɑ́ í ɡbe hee ɑjɔ iyi ɑn mɔ vɛ̃ɛ titɔ̃ si ɑndunyɑ titɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Si ɑnyiɛ ɑ̀ kɔ̃ iri ŋɑ nɔ ɑ̀ fitɑ ɑ̀ bɔ iri kutɑi Olivie ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, iŋɛ fei ɑɑ nyiò ɑnyi nɑ irim. Bɛ́i Ilɑɑɔ̃ í fɔ si kukɔi ideɛ, bɛɛbɛi ɑ́ ce. Í ni nŋu ɑ́ kpɑ woo deɡbeu nɔ ɑnɡudɑ̃ ŋɑu ɑ fɑnɡɑɑ bii fei. ");
INSERT INTO mkl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ammɑ ɑn jĩ hɑi si bɑlɛ nɔ n cuɑ nŋɛ n bɔ ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ŋɔi Piɛɛ í sɔ̃ɔ í ni, bɑɑ bii inɛ fei wɑ nyiò ɑnyi nɑ iriɛ, ɑmu n kɑɑ n nyiò ɑnyi pɑi. ");
INSERT INTO mkl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ŋɔi Jesu í sɔ̃ɔ í ni, ntɔ ntɔ, nnyi, idũuyi mɔm, hee ɑjɛɛ ku mɑɑ kɔ isɛ ɡbeeji, ɑɑ jɑ̃ isɛ ɡbɛɛtɑ i ni i kù mɑ̀m. ");
INSERT INTO mkl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ammɑ bɛ́i Jesu wɑ fɔ, bɛɛbɛ mɔi Piɛɛ í yɑ fɔ hee lele ku ni, n kɑɑ n kɔsiɛ pɑi, bɑɑ bii í jɛ ɑn ku do ɑwɔ ɑjɔi. Ŋɔi ɑŋɑ fei ɑ̀ fɔ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ŋɔi Jesu do mɔcɔɛ ŋɑ ɑ̀ bɔ inyɑ ɡɔ iyi ɑ̀ yɑ kpe Gɛsemɑnee. Iyi ɑ̀ to bɛ nɔ í sɔ̃ ŋɑ í ni, i bubɑ ihɛ̃ titɑ̃ ŋɑ n koo n ce kutɔɔ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ŋɔi í ɡbɑ̃ Piɛɛ do Zɑɑki do Zɑ̃ɑ ɑ̀ bɔ wɑju. Nɔ njo í muu hee ɑrɑɛ fei í rɔ. ");
INSERT INTO mkl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ŋɔi í sɔ̃ ŋɑ í ni, inɔ ku fɔ í nɑɑ sim nlɑ nlɑ hee wɑ bi ku kpɑm. I wɑ ihɛ̃, i wɔ njoo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi í bɔ wɑju keeke í koo í sɛɛbɑtɑ ilɛ wɑ ce kutɔɔ, bii ɑ́ ce, wɑhɑlɑu ku jĩò nŋu. ");
INSERT INTO mkl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wɑ ni, Bɑɑm, ɑɑ yɔkɔ i ce mii fei. Jɔ̀ wɑhɑlɑu ihɛ̃ ku jĩim. Ammɑ do nŋu fei, ku mɑɑ̀ ti ku jɛ ti idɔɔbim, jɔ̀ idɔɔbiɛ ku ce. ");
INSERT INTO mkl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Si ɑnyiɛ ŋɔi í nyi wɑ bi mɔcɔ mɛɛtɑ ŋɑu í bɑ ŋɑ ɑ̀ wɑɑ sĩ njoo. Ŋɔi í bee Piɛɛ í ni, Simɔɔ, ì wɑɑ sĩ njooi? Debɛi, i kù yɔkɔ i kù wɔ njoo bɑɑ lɛɛu ɑkɑ̃? ");
INSERT INTO mkl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","I wɔ njoo nɔ i mɑɑ ce kutɔɔ ŋɑ ku bɑ i mɑɑ̀ dɑsi kulɛlɛi inɛ ŋɑ. Idɔi ɑmɑnɛ í bi, ɑmmɑ ɑrɑɛ í kuɑ ɡbuɡbɑ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ŋɔi í nyi mɑ́ í koo í ce kutɔɔ si ide ɑkɑ̃u. ");
INSERT INTO mkl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iyi í nyi wɑ bi tu ŋɑ mɑ́, nɔ í bɑ ŋɑ ɑ̀ wɑɑ sĩ njoo mɑ́, domi njoo wɑ kpɑ ŋɑ. Iyi í jĩ ŋɑ nɔ ɑ kù mɑ̀ bɛi ɑɑ sɔ̃ɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ŋɔi í nyi í koo í ce kutɔɔ mɑ́ nɔ í bɑɑ bi tu ŋɑ isɛ ɡbɛɛtɑsiɑɛ í bee ŋɑ í ni, ì sũ ì wɑɑ sĩmi ŋɑi hee nsɛi? Í to bɛɛbɛ. Wee, ɑwɑɑtiu í to tɑ̃, iyi ɑɑ mu ɑmu Amɑi Amɑnɛ, ɑ́ dɑɑ ilu dulum ŋɑ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wee, inɛ iyi ɑ́ zɑmbɑm wɑ to wɑ. I dede kɑ kòo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iyi Jesu wɑ fɔ bɛɛbɛ, ɡbɑkɑ̃ ŋɔi Zudɑsi, inɛ ɑkɑ̃i mɔcɔ mɑɑteeji ŋɑu, í to wɑ. Zɑmɑɑ nlɑ ɡɔ wɑ tooɛ wɑ ɑ̀ wɑɑ mu tɑɑkubɑ ŋɑ do ɡolo ŋɑ. Inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do woo kɔ inɛ ŋɑ si woodɑ ŋɑ do inɛ nɡbo ŋɑui ɑ̀ bɛ ŋɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wɑɑti iyi Zudɑsi í dɑsi idɔ nŋu ku zɑmbɑ Jesuu, í sɔ̃ inɛ ŋɑu nyindɑ ɡɔ iyi nŋu ɑ́ ce. Í ni, inɛ iyi ɑn koo n yɑ n bɑɑbɑɛ, lɑfɛ̃ɛ mbɛ. I muu dim dim i nɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hɑi Zudɑsi í to wɑ ɡbɑkɑ̃, í sɛkɛɛ si Jesu í ni, Mɛɛtu. Ŋɔi í bɑɑbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ŋɔi inɛ ŋɑu ɑ̀ to Jesu ɑwɔ ɑ̀ muu. ");
INSERT INTO mkl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ŋɔi inɛ ɑkɑ̃i mɔcɔ ŋɑu í yɔ tɑɑkubɑɛ í cɑfe itĩi ɑmɑɑcɛi woo wee nlɑi Ilɑɑɔ̃u í buu. ");
INSERT INTO mkl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ŋɔi Jesu í bee ŋɑ í ni, ɑmui ì nɑɑ ku mu ŋɑ do tɑɑkubɑ do ɡolo ŋɑ bɛi woo ce ile? ");
INSERT INTO mkl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ǹ yɑ n wɑ si inɔ nŋɛ ɑjɔ fei n mɑɑ n kɔ inɛ ŋɑ si cio kpɑsɛ̃i Ilɑɑɔ̃, nɔ i kù mum ŋɑ. Ammɑ nŋu ŋɑu bɛ fei í ce ku bɑ kukɔi idei Ilɑɑɔ̃ ku kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ŋɔi mɔcɔ ŋɑu fei ɑ̀ jɔ̀ɔ ɑ̀ sɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ŋɔi ɑmɑ ɑwɑɑsũ ɡɔ mɔ wɑ too Jesu, wɑ kpɑkɑ ɑcɔ. Ŋɔi inɛ ɡɔ wɑ dɛ ku muu, ");
INSERT INTO mkl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ɑmmɑ í sɑ bɑsĩ í jɔ̀ ɑcɔu. ");
INSERT INTO mkl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ŋɔi ɑ̀ bɔò Jesu bi woo wee nlɑi Ilɑɑɔ̃u. Tenɡi bɛi inɛ nɡboi woo wee ŋɑu do inɛ nɡbo ŋɑu do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ tɔtɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nɔ Piɛɛ í wɑ hee jĩijĩ wɑ too Jesu wɑ do ɑnyi hee í bɔ inɔ bɑntumɑi kpɑsɛ̃i woo wee nlɑu. Ŋɔi í bubɑ bɛ do woo deɡbe ɑndɛ koofɑ ŋɑu, wɑ nyiɑ kɔkɔi inɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wɑɑti nŋu inɛ nɡboi woo wee ŋɑ do iɡbɛi woo kiiti ŋɑu fei ɑ̀ wɑɑ dɛ ide ɡɔ iyi ɑɑ yɛò tɑɑlei Jesu ɑ bɑ ɑ kpɑɑ. Ammɑ ɑ kù bɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Inɛ nkpɔ í wɑsi ku mɑ́ɑ ide, ɑmmɑ ide nŋɑ kù wɑɑ so njɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ŋɔi inɛ ɡɔ ŋɑ ɑ̀ dede ɑ̀ mɑ́ɑ ide ɑ̀ ni, ");
INSERT INTO mkl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ɑ̀ ɡbɔ iyi í ni nŋu ɑ́ lɛɡɛ kpɑsɛ̃i Ilɑɑɔ̃u nɔ si ɑfei ɑjɔ mɛɛtɑ nŋu ɑ́ be ku mɑ mmuɛ iyi kɑɑ jɛ do ɑwɔi ɑmɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ammɑ bɑɑ si bɛ, ide nŋɑ kù so njɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ŋɔi woo wee nlɑu í dede í leekĩ si wɑjui ɑŋɑ fei, nɔ í bee Jesu í ni, i kù wɑɑ ni ide ɡɔ? Ide mii inɛ ŋɑu ihɛ̃ ɑ̀ wɑɑ yɛò tɑɑleɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ammɑ Jesu wɑ cokoɛ, kù fɔ ide ɡɔ. Ŋɔi woo wee nlɑu í beeɛ mɑ́ í ni, ɑwɔi ì jɛ inɛ iyi Ilɑɑɔ̃ í cicɑ, Amɑi Ilɑɑɔ̃? ");
INSERT INTO mkl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ŋɔi Jesu í jɛɑɑ í ni, oo, ɑmui. Nɔ ɑɑ yɛ ŋɑ ɑmu Amɑi Amɑnɛ ǹ wɑ n bubɑ si ɑwɔ njɛi Ilɑɑɔ̃ ilu ɡbuɡbɑ̃ fei. Nɔ ɑjɔ ɑkɑ̃ ɑɑ nɑ i yɛm ŋɑ ǹ wɑ n nɑɑ si kudũi ijĩ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ŋɔi woo wee nlɑu í ɡɑ ibɔɛ ku nyisiò idɔɔkɔ̃ɛ. Nɔ í ni, ɑ kù wɑɑ dɛ siɛ ilu sɛɛdɑ kɑ̃mɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ì ɡbɔ bɛi wɑ bu Ilɑɑɔ̃ ŋɑ. Bɛirei ì yɛ ɑ ceɑ mɔkɔu ŋɑ. Ŋɔi ɑŋɑ fei ɑ̀ yɛ tɑɑleɛ ɑ̀ ni ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ŋɔi inɛ ɡɔ ŋɑ ɑ̀ wɑsi ku tusi Jesu ɑntɔ ɡbɑkɑ̃ nɔ ɑ̀ bii ijuɛ ɑ̀ bɛi ɑ̀ wɑɑ dɑɑ kutu ɑ̀ beeɛ ɑ̀ wɑɑ ni, ɑwɔ wɑlii, sɔ̃ wɑ inɛ iyi í cɑ̃ɛ. Ŋɔi sooɡe ŋɑu ɑ̀ mu Jesu ɑ̀ wɑsi ku sɑmbɑlɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wɑɑti iyi Piɛɛ í wɑ bɑntumɑi kpɑsɛ̃u, ŋɔi inɛ ɑkɑ̃i ɑmɑ inɑɑbo woo ce icɛi woo wee nlɑi Ilɑɑɔ̃u í nɑɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Iyi í yɛ Piɛɛ wɑ nyiɑ, ŋɔi í cɔɔ sɛ̃ɛ í ni, ɑwɔ mɔ, ì tɑko ì wɛɛ do Jesu inɛi Nɑzɑrɛtiu. ");
INSERT INTO mkl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ammɑ í jɑ̃ í ni, n kù mɑ̀ɑ fɔ́, n kù ɡbɔ ide iyi ì wɑɑ fɔ. Ŋɔi í fitɑ í bɔ ikpɑ ɑndɛ kɑbɑu. Wɑɑti bɛɛbɛi jɛɛ wɑ kɔ. ");
INSERT INTO mkl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ŋɔi ɑmɑ inɑɑbo woo ce icɛu í yɔɔ bɛ mɑ́, ŋɔi í wɑsi ku sɔ̃ inɛ ŋɑ iyi ɑ̀ wɑ bɛu wɑ ni, inɛɛu ihɛ̃ inɛ ɑkɑ̃ nŋɑi. ");
INSERT INTO mkl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ŋɔi Piɛɛ í jɑ̃ mɑ́. Iyi í kpɛ keeke, ŋɔi inɛ ŋɑ iyi ɑ̀ wɑ bɛu ɑ̀ sɔ̃ Piɛɛ ɑ̀ ni, ntɔ ntɔ, ɑwɔu inɛ ɑkɑ̃ nŋɑi, domi ɑwɔ mɔ inɛi Gɑlileei. ");
INSERT INTO mkl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ŋɔi Piɛɛ í ceekpe í ni, n kù mɑ̀ mɔkɔ iyi ì wɑɑ fɑ̃ɑu bɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bɛ ɡbɑkɑ̃ ɑjɛɛ í kɔ isɛ ɡbeejisiɑɛ. Ŋɔi Piɛɛ í ye ɡiɡii ide iyi Jesu í sɔ̃ɔu wo í ni, hee ɑjɛɛ ku mɑɑ kɔ isɛ ɡbeeji ɑɑ jɑ̃ isɛ ɡbɛɛtɑ i ni i kù mɑ̀m. Ŋɔi Piɛɛ í lɔsi ku kpɑtɑ. ");
INSERT INTO mkl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ŋɔi dɑɑdɑɑkɔ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do inɛ nɡbo ŋɑu do woo kɔ inɛ ŋɑ si woodɑ ŋɑu do inɛ ŋɑ iyi ɑ̀ ɡbe si iɡbɛi woo kiiti ŋɑu fei ɑ̀ tɔtɔɔ ɑ̀ wũɑ ideu ɑjɔ. Nɔ ɑ̀ dĩ Jesu ɑ̀ koo ɑ̀ dɑɑ Pilɑti si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ŋɔi Pilɑti í beeɛ í ni, ɑwɔi ì jɛ ilɑɑlui Zuifu ŋɑ? Nɔ Jesu í jɛɑɑ í ni, oo, si bɛi ì fɔ. ");
INSERT INTO mkl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ŋɔi inɛ nɡboi woo wee ŋɑu ɑ̀ mɑ́ Jesu ide ikɑ̃ ikɑ̃ fei. ");
INSERT INTO mkl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ŋɔi Pilɑti í beeɛ mɑ́ í ni, i kù wɑɑ fɔ ide ɡɔ? I kù ɡbɔ bɛi ɑ̀ wɑɑ niɛ? ");
INSERT INTO mkl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ammɑ Jesu kù jɛ ide kɑ̃mɑ mɑ́ hee biti í mu Pilɑti. ");
INSERT INTO mkl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Wee si jinɡɑui Iku ku kuɑ fei Pilɑti í yɑ jɔ̀ inɛi piisɔ̃ɔ ɑkɑ̃ iyi zɑmɑɑ í bii. ");
INSERT INTO mkl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wee inɛ ɡɔ í wɑ ile piisɔ̃ɔ bɛ do kpɑɑsiɛ ŋɑ si nɑ iyi í jɔ̀ ɑ̀ kpɑ inɛ ɡɔ si wɑɑtii ide ku kɔ nŋɑ. Iriɛi Bɑrɑbɑsi. ");
INSERT INTO mkl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ŋɔi zɑmɑɑu í bɔ bi Pilɑti ɑ̀ wɑɑ tɔɔɛ ku ceɑ ɑŋɑ bɛi í yɑ ce nŋɑ ɑdɔ̃ fei si jinɡɑuu. ");
INSERT INTO mkl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ŋɔi Pilɑti í bee ŋɑ í ni, ì bi n jɔ̀ nŋɛ ilɑɑlui Zuifu ŋɑu ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Í fɔ bɛɛbɛi si nɑ iyi í jɔ̀ wɑ mɑ̀ sɑ̃ɑ sɑ̃ɑ iyi nɑ iɡui í jɔ̀ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu ɑ̀ dɑɑ nŋu Jesu si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ammɑ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu ɑ̀ wɑsi ku mɑnte zɑmɑɑu ɑ̀ ni ɑ sɔ̃ Pilɑti ku nyɑ nŋɑ Bɑrɑbɑsi. ");
INSERT INTO mkl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nɔ Pilɑti í bee ŋɑ mɑ́ í ni, to, bɛirei ì bi n ceɑ inɛ iyi ì yɑ mɑɑ kpe ilɑɑlui Zuifu ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ŋɔi ɑ̀ dɔ̃ ɑnu ɑ̀ ni, kpɑkpɑɛ si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nɔ Pilɑti í bee ŋɑ í ni, lɑɑlɔ yoomɑi í bɛi í ce. Ammɑ bɛ́i Pilɑti wɑ fɔ fei, bɛɛbɛ mɔi inɛ ŋɑu ɑ̀ yɑ dɔ̃ ɑnu hee lele ɑ ni, kpɑkpɑɛ si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Si nɑ iyi í jɔ̀ Pilɑti í bi ku ce iyi ɑ́ dɔ̃ɑ zɑmɑɑu si, nŋui í jɔ̀ í nyɑ nŋɑ Bɑrɑbɑsi nɔ í mu Jesu í jɔ̀ ɑ̀ tɛɑɑ kpɔtɔɔ. Si ɑnyiɛ, nɔ í dɑɑ sooɡe ŋɑ si ɑwɔ ɑ koo ɑ kpɑkpɑɛ si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ŋɔi sooɡe ŋɑu ɑ̀ ɡbɑ̃ Jesu ɑ̀ bɔòɛ kɑbɑi ilɑɑlu, nɔ ɑ̀ tɔtɔɔ sooɡe ŋɑ iyi ɑ̀ ɡbe ŋɑu fei bɛ. ");
INSERT INTO mkl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ŋɔi ɑ̀ dɑɑ Jesu si ibɔ nkpɑ sisɔ ɡɔ, nɔ ɑ̀ bɑ fulɑi ɑɡũ ɑ̀ dɑɑ si iriɛ. ");
INSERT INTO mkl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ŋɔi ɑ̀ yɑɑkoɛ ɑ̀ wɑɑ ni, fɔɔ ilɑɑlui Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ŋɔi ɑ̀ yɑ mɑɑ cɑ̃ɑ kpokpoo si iriɛ, ɑ mɑɑ tusiɛ ɑntɔ, nɔ ɑ̀ wɑɑ ɡulɛɑ ɑ̀ wɑɑ sɛɛbɑtɑ si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iyi ɑ̀ yɑɑkoɛ ɑ̀ tɑ̃, ŋɔi ɑ̀ nyɑɑ ibɔ nkpɑu ɑ̀ bɛi ɑ̀ dɑɑ si ibɔɛ, nɔ ɑ̀ bɔòɛ wɑduude ɑ̀ koo ɑ̀ kpɑkpɑɛ si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wee inɛi Sirɛni ɡɔ iyi ɑ̀ yɑ kpe Simɔɔ wɑ bɑɑ hɑi iko, nɔ í to wɑ bɛ. Bɑɑi Alesɑndu do Rufusui. Iyi í to wɑ nɔ sooɡe ŋɑu ɑ̀ muu do ɡbuɡbɑ̃ ɑ̀ kɑ̃ɑ jĩi ku ɡɑɑu bii ɑɑ kpɑkpɑ si Jesuu. ");
INSERT INTO mkl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ŋɔi ɑ̀ bɔò nŋu do Jesu si inyɑ ɡɔ iyi ɑ̀ yɑ kpe Gɔɔɡɔtɑ, wɑɑtɔ inyɑ iyi í jɔ kokoi iri. ");
INSERT INTO mkl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nɔ ɑ̀ nɑ́ Jesu ɑtɛ̃ vɛ̃ɛ iyi ɑ̀ yɔɡɛɛ do iwɔ iyi ɑ̀ yɑ kpe miru, ɑmmɑ í kɔ ku mɔɔ. ");
INSERT INTO mkl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ŋɔi ɑ̀ kpɑkpɑɛ si jĩi nɔu. Si ɑnyiɛ sooɡe ŋɑu ɑ̀ tɑ kpɑsɑ si jĩnɛɛ ŋɑ ɑ bɑ ɑ yɛ iyi inɛ fei ɑ́ bɑ. Bɛɛbɛi ɑ̀ ce ikpɛ̃i jɑɑɛɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dɑɑkɔ zɑkɑi bɛi isɔ mɛɛsɑ̃i ɑ̀ kpɑkpɑɛ si jĩi nɔu. ");
INSERT INTO mkl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ŋɔi ɑ̀ kɔ kurɑrɑɛ si jĩi ɡɔ ɑ̀ mɑsi jĩi bii ɑ̀ kpɑkpɑɛu, ɑ̀ ni ilɑɑlui Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ŋɔi ɑ̀ kpɑkpɑ ile minji ɡɔ ŋɑ bɛ mɑ́, inɛ ɑkɑ̃ ikpɑ ɑwɔ njɛɛ, inɛ ɑkɑ̃ mɔ ikpɑ ɑwɔ cɑnɡɑɛ.  ");
INSERT INTO mkl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bɛɛbɛi kukɔi idei Ilɑɑɔ̃ í kɔ̃ iyi í ni, ɑ̀ dooɑɛ si inɛ lɑɑlɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Woo lɔ ŋɑ ɑ̀ yɑ mɑɑ ɡuɡbɑ̃ iri ɑ buu ɑ mɑɑ ni, ɑhɑ̃, kù jɛ ɑwɔi ì ni ɑɑ lɛɡɛ kpɑsɛ̃i Ilɑɑɔ̃u nɔ i mɑɑ mɑ si ɑfei ɑjɔ mɛɛtɑ? ");
INSERT INTO mkl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","To, fɑɑbɑ ɑrɑɛ bɛ, kitɑ hɑi si ɑntɑi jĩi ku ɡɑɑuu. ");
INSERT INTO mkl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bɛɛbɛ mɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ wɑɑ yɑɑkoɛ. À sɔ̃ njɛ ɑ̀ wɑɑ ni, í fɑɑbɑ inɛ ɡɔ ŋɑ ɑmmɑ kɑɑ yɔkɔ ku fɑɑbɑ ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Bɛbɛi, nŋu Kirisi ilɑɑlui Izirɛliu ku kitɑ wɑ hɑi si jĩi nɔu ku bɑ kɑ yɔɔ, nɔ kɑ dɑsiɛ nɑɑnɛ. Bɛɛbɛ mɔi, inɛ ŋɑ iyi ɑ̀ kpɑkpɑ do Jesu ɑjɔ́u ɑ̀ yɑ mɑɑ yɑɑkoɛ. ");
INSERT INTO mkl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ŋɔi dɑsɑ̃ nkpɑu ilu í kuku si ilɛ fei hee í koo í to isɔ mɛɛtɑi ɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ŋɔi si isɔ mɛɛtɑu Jesu í dɔ̃ ɑnu hee lele í ni, Eloi, Eloi, lɑmɑ sɑbɑtɑni, wɑɑtɔ Ilɑɑɔ̃, Ilɑɑɔ̃, nɑ mii í ce ì fũsim ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ŋɔi inɛ ɡɔ ŋɑ iyi ɑ̀ wɑ bɛu ɑ̀ ɡbɔ ideu. Nɔ ɑ̀ ni, i ɡbɔ, wɑ kpe Elii. ");
INSERT INTO mkl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ŋɔi inɛ ɑkɑ̃ nŋɑ í sɛi í koo í dĩ kɑnyɑ si ɡolo ɡɔ í sɔsi inyiikɑ̃ í bɛi í nɑɑ í toɑ Jesu ku cɔ̃ɔcɔ̃ɔɛ, nɔ í ni, kɑ leekĩ, kɑ cɔ mɑ Elii ɑ́ nɑɑ ku kitɑɛ hɑi si jĩi ku ɡɑɑuu. ");
INSERT INTO mkl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ŋɔi Jesu í dɔ̃ ɑnu hee lele í bɛi í ku. ");
INSERT INTO mkl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Asee, wɑɑti bɛɛbɛ si ilui Zeruzɑlɛmu, ridoo iyi í wɑ kpɑsɛ̃i Ilɑɑɔ̃u í ɡɑ í kpɛ̃ minji hɑi lele hee ku bɔ ilɛ. ");
INSERT INTO mkl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Inɛ nɡboi sooɡe ŋɑ iyi í wɑ wɑjui Jesu í yɛ yɑɑse bɛi í ce í bɛi í ku, nɔ í ni, ntɔ ntɔ, inɛɛu ihɛ̃ Amɑi Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ŋɔi inɑɑbo ɡɔ ŋɑ mɔ ɑ̀ wɑ bɛ ɑ̀ wɑɑ cɔ ilu wɑ hɑi jĩijĩ. Si inɔ nŋɑ Mɑɑri inɛi Mɑdɑlɑu í wɑ bɛ do Sɑlomee do Mɑɑri, iyei Zozee do Zɑɑki iyi í jɛ ɑmɑ ɑwɑɑsũu. ");
INSERT INTO mkl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wee hɑi tɑko, wɑɑti iyi Jesu í wɑ ilɛi Gɑlilee, ɑŋɑi ɑ̀ tooɛ ɑ̀ yɑ mɑɑ ceɑ icɛ. Nɔ inɑɑbo nkpɔ ɡɔ ŋɑ mɔ ɑ̀ wɑ bɛ, iyi ɑŋɑò ŋɑ ɑ̀ sì Jesu wɑ iyi wɑ nɑɑ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Iyi ɑlɛ í lɛ, ŋɔi Zozɛfu inɛi Arimɑteeu í nɑɑ bɛ. Í bɛi í jɛ ilu bɛɛrɛ si inɔi Zuifu woo kiiti ŋɑu, nɔ wɑ cɔ kpɑ̃ɑ iyi Ilɑɑɔ̃ ɑ́ nɑ ku jɛ bommɑ. Wee ɑjɔi sɔɔlui jinɡɑui. Iju kumɑ́ɛ ɑjɔi kusĩmii ɑ́ jɛ. Nɑ ŋɔi í jɔ̀ Zozɛfu í bɔ bi Pilɑti do wɔɔkɔ ku tɔɔɛ ikui Jesu. ");
INSERT INTO mkl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ŋɔi Pilɑti í biti do iyi í ɡbɔ ɑ̀ ni í kú tɑ̃. Ŋɔi í kpe inɛ nɡboi sooɡe ŋɑu í beeɛ mɑ Jesu í kú í kpɛ. ");
INSERT INTO mkl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Iyi inɛ nɡboi sooɡe ŋɑu í sisiɑɑ yɑɑse bɛi Jesu í kuò, ŋɔi í jɛsi Zozɛfu koo so ikuu. ");
INSERT INTO mkl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ŋɔi Zozɛfu í koo í rɑ ɑcɔ fũfũ, nɔ í nyɑ ikui Jesu wɑ hɑi si jĩi ku ɡɑɑuu, í woo do ɑcɔu. Nɔ í suu si isɑi kutɑ ɡɔ iyi ɑ̀ ɡbe wo. Si ɑnyiɛ í bimbili kutɑ nlɑ ɡɔ í dĩò ɑndɛi bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ŋɔi Mɑɑri inɛi Mɑdɑlɑu do Mɑɑri iyei Zozee ɑ̀ yɛ bii ɑ̀ wɑɑ dɑsi ikui Jesuu. ");
INSERT INTO mkl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Iyi ɑjɔi kusĩmi í lɔ, ŋɔi Mɑɑri inɛi Mɑdɑlɑu do Sɑlomee do Mɑɑri iyei Zɑɑki, ɑ̀ rɑ tulɑre iyi ɑɑ koo ɑ fɑ̃si ikui Jesu. ");
INSERT INTO mkl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ŋɔi ɑjɔ ɑmɑɑzumɑ dɑɑdɑɑkɔu ɑbo ŋɑu ɑ̀ bɔ bi bɑlɛu, ");
INSERT INTO mkl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ŋɔi ɑ̀ wɑɑ bee njɛ si kpɑ̃ɑu ɑ̀ wɑɑ ni, yooi ɑ́ tɑle nwɑ kutɑu hɑi si ɑndɛi bɑlɛu yɑ. ");
INSERT INTO mkl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","À wɑɑ fɔ bɛɛbɛi si nɑ iyi í jɔ̀ kutɑu í lɑ í cɑɑ. Ammɑ iyi ɑ̀ cɔ wɑju ɑ̀ yɛ kutɑu í bimbili. ");
INSERT INTO mkl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ŋɔi ɑ̀ lɔ inɔ bɑlɛu nɔ ɑ̀ yɛ ɑwɑɑsũ ɡɔ wɑ bubɑ do ɑwɔ njɛ bɛ, wɑ dɑsi jɑbɑ fũfũ, nɔ njo í mu ŋɑ jiidɑ jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ŋɔi í sɔ̃ ŋɑ í ni, i mɑɑ̀ jɔ̀ njo ku mu ŋɛ. Ǹ mɑ̀ iyi Jesu, inɛi Nɑzɑrɛtiui ì wɑɑ dɛdɛ ŋɑ, iyi ɑ̀ kpɑkpɑ si jĩi ku ɡɑɑuu. Í jĩ hɑi si bɑlɛ, kù wɑ ihɛ̃ mɑ́. I cɔ tenɡi bii ɑ̀ dɑsiɛu wo. ");
INSERT INTO mkl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ammɑ i koo bɛbɛi i koo i sɔ̃ mɔcɔɛ ŋɑu do Piɛɛ tɑkɑɛ i ni, ɑ́ cuɑ nŋɛ ku bɔ ilɛi Gɑlilee. Bɛi ɑɑ koo i yɔɔ ŋɑ si bɛi í sɔ̃ ŋɛ wo. ");
INSERT INTO mkl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ŋɔi ɑ̀ fitɑ wɑ ɑ̀ sɑ hɑi bi bɑlɛu do kuyɑyɑ domi njo í mu ŋɑ ntɔ ntɔ. A kù nɔ ɑ kù sɔ̃ inɛ ɡɔ ideu nɑ irii njo iyi í mu ŋɑu.  ");
INSERT INTO mkl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iyi Jesu í jĩ hɑi si bɑlɛ ɑjɔ ɑmɑɑzumɑ dɑɑdɑɑkɔu, bi Mɑɑri inɛi Mɑdɑlɑui í tɑko í nyisi ɑrɑɛ. Mɑɑriui Jesu í tɑko í leleɑ inɛi inɔɔko mɛɛje wo. ");
INSERT INTO mkl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ŋɔi ɑbou í koo í sɔ̃ kpɑɑsiɛ ŋɑ lɑɑbɑɑuu. Aŋɑi ɑ̀ wɑɑ too Jesu wo nɔ ɑ̀ wɛɛò inɔ kufɔ ɑ̀ wɑsi ku kpɑtɑ. ");
INSERT INTO mkl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Iyi í ni Jesu í jĩ mɑ́, nŋu í yɔɔ, ɑ kù dɑsiɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Si ɑnyii nŋu, ŋɔi Jesu í tusɛ ɑrɑɛ bi mɔcɔ minjiɛ ɡɔ ŋɑ iyi ɑ̀ wɑɑ nɛ si kpɑ̃ɑ, ɑ̀ wɑɑ bɔ ilɛɛko. Ammɑ í kpɑɑsi ɑrɑɛ si kuyɛ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ŋɔi inɛ ŋɑu ɑ̀ bɑɑ inɔ ilu nɔ ɑ̀ koo ɑ̀ sɔ̃ inɛ bubu ŋɑu, ɑmmɑ kpɑɑsi ŋɑu ɑ kù dɑsi ɑŋɑ mɔ nɑɑnɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Si ɑnyiɛ Jesu í koo í tusɛ ɑrɑɛ bi mɔcɔ mɑɑtɑkɑ̃ ŋɑu bii ɑ̀ wɑɑ jɛ. Ŋɔi í ɡbɑɡbɑ si ŋɑ nɑ nɑɑnɛ hɑi dɑsi nŋɑ do idɔ kule nŋɑ, si nɑ iyi í jɔ̀ ɑ kù jɛsi idei inɛ ŋɑ iyi ɑ̀ yɔɔ í jĩ hɑi si bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ŋɔi í sɔ̃ ŋɑ í ni, i bɔ si ɑndunyɑ fei, nɔ i wɑɑzoɑ inɛ bɑɑ yoomɑ fei lɑɑbɑɑu jiidɑu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Inɛ iyi í dɑsi nɑɑnɛ nɔ í jɔ̀ ɑ̀ dɑsiɛ inyi ɑ́ bɑ fɑɑbɑ, ɑmmɑ inɛ iyi kù dɑsi nɑɑnɛ, Ilɑɑɔ̃ ɑ́ yɛ tɑɑleɛ ku kpɑ̃ɑ iju. ");
INSERT INTO mkl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","I cɔ mɑɑmɑɑke ɡɔ ŋɑ iyi woo dɑsim nɑɑnɛ ŋɑ ɑɑ ce. Aɑ lele inɛi inɔɔko ŋɑ do irim, nɔ ɑɑ fɔ ide do fee ŋɑ iyi i kù wɑɑ ɡbɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aɑ mu njo ŋɑ do ɑwɔ, nɔ bɑɑ bii ɑ̀ mɔ kɔɔtɛ̃ ɡɔ kɑɑ ce nŋɑ ide kɑ̃mɑ. Aɑ lesi bɔ̃ɔ ŋɑ ɑwɔ nɔ ɑ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iyi Lɑfɛ̃ɛ Jesu í sɔ̃ ŋɑ ideu í tɑ̃, ŋɔi ɑ̀ soo lele í koo í bubɑ si ɑwɔ njɛi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ŋɔi mɔcɔ ŋɑu ɑ̀ koo ɑ̀ wɑɑ wɑɑzoɑ inɛ ŋɑ bii fei. Nɔ Lɑfɛ̃ɛ wɑ sobi ŋɑ si icɛu, í jɔ̀ ɑ̀ yɑ mɑɑ ce mɑɑmɑɑke ŋɑ ku bɑ inɛ ŋɑ ɑ mɑ̀ iyi ide nŋɑ í jɛ ntɔ.");
INSERT INTO mkl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Bɑɑkɔɔm Teofilu, ilu bɛɛrɛ nlɑ, ǹ wɑ n ceɛ fɔɔ. Í sĩɑɑm si n kɔɛ tiɑu ihɛ̃ wɑ n sɔ̃ɛ dee dee mii iyi í ce si ɑnini nwɑ. Inɛ ŋɑ iyi ɑ̀ yɔɔ hɑi sinte, nɔ ɑ̀ bɑɑ ɑ̀ jɛ woo ce icɛi ideu, ɑŋɑi ɑ̀ sɔ̃ wɑ. Iyi inɛ ŋɑ ɑ̀ ɡbɔɔ, inɛ nkpɔ nkpɔi í ce kookɑɑi ku bɑ ɑ kɔɔ dee dee. Nɔ í sĩɑɑm si ɑmu mɔ n kɔɛ wɑ ku bɑ i mɑ̀ kɑm kɑm iyi ide ŋɑ iyi ɑ̀ kɔɛ siu ntɔi, domi ǹ wũɑ ideu fei hɑi sinteɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Si wɑɑti iyi Herodu í jɛ ilɑɑlui Zudee, woo weei Ilɑɑɔ̃ ɡɔ í wɑ bɛ ɑ̀ yɑ kpoo Zɑkɑri. Si wuɑi woo weei Ilɑɑɔ̃ ŋɑ iyi í jɛ ti Abiɑi í wɑ. Aboɛi ɑ̀ yɑ kpe Elizɑbɛti. Si dimii Arɔ̃ɔ iyi í jɛ woo wee nlɑ sintei Ilɑɑɔ̃ui í wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aŋɑ minji fei ɑ̀ jɛ dee dee si wɑjui Ilɑɑɔ̃ nɔ ɑ̀ wɑɑ jirimɑ woodɑi Lɑfɛ̃ɛ do ideɛ fei mɑm mɑm. ");
INSERT INTO mkl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ammɑ ɑ kù nɛ ɑmɑ domi Elizɑbɛti ɡbɛndɑi, nɔ ɑŋɑ minji fei ɑ̀ ɡbo tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ajɔ nŋu ɡɔ, Zɑkɑri wɑ ce icɛi kuweeɛ si wɑjui Ilɑɑɔ̃ domi si wuɑɛi kuweeu í to si. ");
INSERT INTO mkl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Wee, ɑ̀ yɑ tɑ kpɑsɑi ku bɑ ɑ mɑ̀ inɛ iyi ɑ́ lɔ si kpɑsɛ̃i Ilɑɑɔ̃ koo jo tulɑre. Ŋɔi ɑjɔ nŋu bɛ, kpɑsɑu í so Zɑkɑri, ŋɔi í jɔ̀ í lɔ inɔ ileu koo jo tulɑreu. ");
INSERT INTO mkl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nɔ zɑmɑɑu fei wɑ ce kutɔɔ wɑduude si wɑɑti iyi wɑ jo tulɑreu. ");
INSERT INTO mkl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ŋɔi ɑmɑlekɑi Ilɑɑɔ̃ ɡɔ í nɑɑ siɛ, wɑ leekĩ si ɑwɔ njɛi bi ku jo tulɑreu. ");
INSERT INTO mkl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Iyi Zɑkɑri í yɔɔ ŋɔi ziɡiɛ í dɑ, nɔ njo í muu hee í cɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ammɑ ɑmɑlekɑu í sɔ̃ɔ í ni, mɑɑ̀ jɔ̀ njo ku muɛ, Zɑkɑri. Ilɑɑɔ̃ í ɡbɔ kutɔɔɛ. Elizɑbɛti ɑboɛ ɑ́ bíɛ ɑmɑ inɛmɔkɔ nɔ i sɔɔ Zɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aɑ nɛ inɔ didɔ̃ nlɑ nlɑ nɔ inɛ nkpɔ ɑ́ wɛɛ do inɔ didɔ̃ nɑ kubiɛ, ");
INSERT INTO mkl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","si nɑ iyi í jɔ̀ inɛ nlɑi ɑ́ jɛ si wɑjui Aɔ̃ Lɑfɛ̃ɛ. Kɑɑ mɔ vɛ̃ɛ, hee mɑ́ jɛ ɑtɛ̃ kulele mmu ɡɔ. Nɔ ɑ́ kɔ̃ò Hundei Ilɑɑɔ̃ hɑi inɔi iyeɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Á jɔ̀ inɛi Izirɛli nkpɔ ku kpɑɑsi idɔ nɔ ɑ nyi wɑ bi Aɔ̃ Lɑfɛ̃ɛ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nŋui ɑ́ cuɑɑ Ilɑɑɔ̃ nɔ ku yɛ bɛi Elii wɑlii nlɑi tɑkou. Gbuɡbɑ̃ɛ mɔ ɑ́ yɛi bɛi ti Elii. Á jɔ̀ bɑɑ do ɑmɑ nŋɑ ŋɑ ɑ ɡbɔsi njɛ, nɔ ɑ́ jɔ̀ hɑi ɡbɔ ide ŋɑ mɔ ɑ ce lɑsɑbu bɛi inɛ dee dee ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ammɑ Zɑkɑri í sɔ̃ ɑmɑlekɑu í ni, ɑmu wee ǹ ɡbo tɑ̃ nɔ ɑbom mɔ í ce inɛ nɡbo. To, bɛirei ɑn ce n mɑ̀ iyi ideu ɑ́ ce. ");
INSERT INTO mkl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ŋɔi ɑmɑlekɑu í jɛɑɑ í ni, ɑmui Gɑbiɛli. Amui ǹ yɑ n wɑ bi Ilɑɑɔ̃ n mɑɑ n ceɑɑ icɛ. Nŋui í bɛm wɑ n nɑ n bɑɛ ide ku fɔ nɔ n sisiɛ lɑɑbɑɑu jiidɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ammɑ i kù dɑsi idem nɔu nɑɑnɛ bɑɑ do iyi ɑ́ nɑ ku ce bii wɑɑtiɛ í to. Nɑ nŋu, ɑɑ dekĩ, i kɑɑ yɔkɔ i fɔ ide mɑ́ í ɡbe ɑjɔ iyi ideu í cei. ");
INSERT INTO mkl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wee inɛ ŋɑ ɑ̀ wɑɑ deɡbe Zɑkɑri, nɔ ɑ̀ biti do iyi wɑ kpɛ inɔ kpɑsɛ̃i Ilɑɑɔ̃ bɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Iyi í fitɑ wɑ, kù yɔkɔ ku bɑ ŋɑ ide ku fɔ mɑ́, ŋɔi ɑ̀ mɑ̀ iyi í ce kuyɛ ɡɔi si inɔ ileu bɛ. Wɑ bɑ ŋɑ ide ku fɔ do ɑwɔ ku nyisi iyi ntɔi, ɑmmɑ kù yɔkɔ ku fɔ ide do ɡɛlɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Si ɑnyii kuyɛu, Zɑkɑri í mɔsi icɛɛ mɑ́ hee í koo í to ɑjɔ iyi icɛɛ í kpɑ iri inɔ kpɑsɛ̃ bɛ. Ŋɔi í nyi ideɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Si ɑnyiɛ, Elizɑbɛti ɑboɛ í bɑ ɑsĩ, nɔ wɑ sinɡɑ ɑrɑɛ zɑkɑi cukpɑ miu, í ni , ");
INSERT INTO mkl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","cɔ mii iyi Ilɑɑɔ̃ í ceem. Í cɔm do iju jiidɑ nɔ í nyɑɑm ɑnyɔ si wɑjui ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Iyi ɑsĩi Elizɑbɛti í bɑ cukpɑ mɛɛfɑ, ŋɔi Ilɑɑɔ̃ í bɛ ɑmɑlekɑ Gɑbiɛli Nɑzɑrɛti si ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Í bɔɔi bi mudɛ̃ɛ ɡɔ iyi kù mɑ̀ mɔkɔ, ɑmmɑ ɑ̀ muɑ ɑwɑɑsũ ɡɔ iyi ɑ̀ yɑ kpe Zozɛfu, si dimii ilɑɑlu Dɑvidi. Irii mudɛ̃ɛui í jɛ Mɑɑri. ");
INSERT INTO mkl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Amɑlekɑu í lɔ bi tɛɛ í sɔ̃ɔ í ni, ǹ wɑ n ceɛ fɔɔ, ɑwɔ iyi Ilɑɑɔ̃ í ceɑ didɔ̃. Aɔ̃ Lɑfɛ̃ɛ í wɛɛ do ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ŋɔi Mɑɑri í biti do ideu nɔ wɑ bee ɑrɑɛ ide wɑ ni, yoomɑi í jɛ yɑɑsei fɔɔu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ŋɔi ɑmɑlekɑu í sɔ̃ɔ í ni, mɑɑ̀ jɔ̀ njo ku muɛ Mɑɑri. Ilɑɑɔ̃ í ceeɛ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aɑ bɑ ɑsĩ i bí ɑmɑ inɛmɔkɔ nɔ i sɔɔ Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Á nɑ ku jɛ inɛ nlɑ. Amɑi Ilɑɑɔ̃i ɑɑ yɑ kpoo, nŋu iyi kù nɛ sɑɑ. Aɔ̃ Lɑfɛ̃ɛ ɑ́ coo ilɑɑlu, ɑ́ nɑ́ɑ bommɑi Dɑvidi bɑlɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nŋui ɑ́ jɛ bommɑ si dimii Zɑkɔbu do ɑjɔ fei. Bommɑɛ kɑɑ nɛ kɔɔ . ");
INSERT INTO mkl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ŋɔi Mɑɑri í bee ɑmɑlekɑu í ni, bɛirei ɑ́ ce ku ce, si bɛi n kù mɑ̀ mɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ŋɔi ɑmɑlekɑu í jɛɑɑ í ni, Hundei Ilɑɑɔ̃i ɑ́ nɑɑ siɛ, nɔ ɡbuɡbɑ̃ɛ ku biiɛ bɛi jĩjĩ. Nŋui í jɔ̀ ɑɑ kpe ɑmɑ kumɑ́ iyi ɑɑ nɑ i biu Amɑi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elizɑbɛti nyɑɑnzeɛu mɔ iyi ɑ̀ yɑ mɑɑ kpe ɡbɛndɑu, do si ɑɡboɛu fei, í nɛ ɑsĩi ɑmɑ inɛmɔkɔ. Í wɛɛ si cukpɑ mɛɛfɑsiɑɛ nsɛi. ");
INSERT INTO mkl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mɑɑri, jɔ̀ i mɑ̀ iyi nkɑ̃mɑ kù wɛɛ iyi Ilɑɑɔ̃ í mɔnɡɔ. ");
INSERT INTO mkl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ŋɔi Mɑɑri í ni, ɑmu woo ce icɛi Aɔ̃ Lɑfɛ̃ɛi. Fei ndɛɛ ku ceem bɛi ì sɔ̃m nɔu. Ŋɔi ɑmɑlekɑu í nɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Si ɑnyii nŋu, ŋɔi Mɑɑri í dede do sɑɑsɑ í dɑsi kpɑ̃ɑ wɑ nɛ ikpɑ ɡeete ŋɑ, í bɔ ilu ɡɔ si ilɛi Zudee. ");
INSERT INTO mkl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Iyi í to bɛ ŋɔi í lɔ kpɑsɛ̃i Zɑkɑri nɔ í ce Elizɑbɛti fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wɑɑti iyi Elizɑbɛti í ɡbɔ fɔɔi Mɑɑriu, ŋɔi ɑmɑu í yɑɡɑ si inɔɛ, nɔ Elizɑbɛti í kɔ̃ò Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nɔ í dɔ̃ ɑnu hee lele í ni, Ilɑɑɔ̃ í weeɛ í re inɑɑbo fei, nɔ kuweeu ɑ́ sɔ si ɑmɑ iyi ɑɑ nɑ i bíu. ");
INSERT INTO mkl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yooi ǹ jɛ hee iyei Lɑfɛ̃ɛm í nɑɑ bi tom. ");
INSERT INTO mkl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wɑɑti iyi ǹ ɡbɔ fɔɔɛu bɛ, ɑmɑ iyi í wɑ inɔm í yɑɡɑ do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ilu inɔ didɔ̃i ɑwɔ iyi ì dɑsi nɑɑnɛ iyi mii iyi Ilɑɑɔ̃ í sɔ̃ɛ ɑ́ nɑ ku ce. ");
INSERT INTO mkl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nɔ Mɑɑri í ni, Idɔm wɑ sɑɑbu Aɔ̃ Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nɔ ǹ wɛɛò inɔ didɔ̃ nɑ irii Ilɑɑɔ̃ Woo fɑɑbɑm, ");
INSERT INTO mkl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Si nɑ iyi í jɔ̀ í kɑ̃sim iju jiidɑɛ, ɑmu woo ce icɛɛ iyi n kù jɛ nɡɔɡɔ. Nɔ hɑi nsɛi inɛi ɑndunyɑ ŋɑ fei ɑɑ mɑɑ ni ɑmuu ilu inɔ didɔ̃i, ");
INSERT INTO mkl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Domi Ilɑɑɔ̃, ilu ɡbuɡbɑ̃ fei í ceem mii nlɑ nlɑ. Iriɛ í mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Í yɑ ce ɑrɑɑrei inɛ ŋɑ iyi ɑ̀ wɑɑ jirimɑɛ hee do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Í ce icɛ ɡbuɡbɑ̃ ŋɑ do ɡbuɡbɑ̃i ɑwɔɛ Nɔ í fɑnɡɑɑ inɛ ŋɑ iyi lɑsɑbui idɔ nŋɑ í nɛ fɑɑo. ");
INSERT INTO mkl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Í kɛkɛ ilɑɑlu ŋɑ si bɑtɑi bommɑ nŋɑ ŋɑ, Nɔ í so ilu ɑre ŋɑ lele. ");
INSERT INTO mkl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Í jɔ̀ inɛ ŋɑ iyi ɑri wɑ kpɑ ɑ̀ jɛ mii jiidɑ ŋɑ ɑ̀ yo, Ammɑ í lele ilu fiɑ ŋɑ ɑwɔ nɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Í sobi inɛi Izirɛli woo ce icɛɛ ŋɑ, Í ce ɑrɑɑre nŋɑ hee do ɑjɔ fei Bɛi í tɑko í sɔ̃ Aburɑhɑmu do tɔkuɛ ŋɑ Aŋɑ iyi ɑ̀ jɛ bɑlɑ nwɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Iri iyi Mɑɑri í kɔ̃u mbɛ. Si ɑnyiɛ nɔ í bubɑ bi Elizɑbɛti bɛ zɑkɑi cukpɑ mɛɛtɑ, í bɛi í nyi ideɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Awɑɑti í to bii Elizɑbɛti ɑ́ bí ɑmɑɛ, nɔ í bí ɑmɑ inɛmɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kpɑɑsiɛ ŋɑ do nyɑɑnzeɛ ŋɑ ɑ̀ ɡbɔ iyi Aɔ̃ Lɑfɛ̃ɛ í ce ɑrɑɑreɛ ntɔ ntɔ, nɔ ɑŋɑò ŋɑ ɑ̀ wɛɛò inɔ didɔ̃ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Si ɑjɔ mɛɛjɔsiɑ ɑ̀ nɑɑ ku dɑsi ɑmɑu bɑnɡo, nɔ ɑ̀ wɑɑ bi ɑ̀ kpoo Zɑkɑri, irii bɑɑɛu. ");
INSERT INTO mkl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ammɑ iyeɛ í so ide í ni, ɑɑwo, Zɑ̃ɑi ɑɑ kpoo. ");
INSERT INTO mkl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, si nyɑɑnzeɛ inɛ kɑ̃mɑ kù nɛ dimii iriu bɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nɔ ɑ̀ bee bɑɑɛ do ɑwɔ ku bɑ ɑ mɑ̀ bɛi í bi ɑ kpe ɑmɑu. ");
INSERT INTO mkl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ŋɔi Zɑkɑri í tɔɔ mii ɡɔ si bii ɑ́ kɔ si, nɔ í kɔ í ni, Zɑ̃ɑi í jɛ iriɛ. Nɔ ɑŋɑ fei ɑ̀ biti. ");
INSERT INTO mkl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ŋɔi ɡbɑkɑ̃ Zɑkɑri í yɔkɔ í fɔ ide do ɡɛlɛɛ, nɔ í lɔsi ide ku fɔ wɑ sɑɑbuò Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ŋɔi njo í mu hee do inɛ ŋɑ iyi ɑ̀ wɑ ɑmɛɛ ɑmɛɛ fei. Nɔ si ilɛɛkoi ɡeetei Zudee ŋɑ fei inɛ ŋɑ ɑ̀ wɑsi ku ce fɑɑjii ideu. ");
INSERT INTO mkl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Inɛ ŋɑ iyi ɑ̀ ɡbɔ ideu fei ɑ̀ yɑ mɑɑ muui si idɔ nŋɑ nɔ ɑ mɑɑ ni, debɛi, bɛirei ɑmɑu ihɛ̃ ɑ́ nɑ ku jɛ. Mii ŋɑ iyi í ceu ihɛ̃ fei wɑ nyisi iyi ɡbuɡbɑ̃i Ilɑɑɔ̃ í wɛɛ do nŋu. ");
INSERT INTO mkl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ŋɔi Zɑkɑri bɑɑi ɑmɑu í kɔ̃ò Hundei Ilɑɑɔ̃, nɔ í ce wɑlii í ni, ");
INSERT INTO mkl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Sɑɑbui í jɛ ti Ilɑɑɔ̃ Lɑfɛ̃ɛi inɛi Izirɛli ŋɑ Si nɑ iyi í jɔ̀ í nɑɑ bi inɛɛ ŋɑ í nɑ í yɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nɔ í nɑɑ nwɑ Woo fɑɑbɑ ilu ɡbuɡbɑ̃ wɑ si nyɑɑnzei ilɑɑlu Dɑvidi ɑmɑɑcɛɛu, ");
INSERT INTO mkl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Si bɛi í jɔ̀ wɑlii kumɑ́ɛ ŋɑu ɑ̀ fɔ wo hɑi ku kpɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nŋui ɑ́ fɑɑbɑ wɑ hɑi si ɑwɔi mbɛɛ nwɑ ŋɑ, Do hɑi bi inɛ ŋɑ iyi ɑ̀ cé wɑ fei. ");
INSERT INTO mkl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bɛɛbɛi í nyisi bɑlɑ nwɑ ŋɑ ɑrɑɑreɛ, Nɔ wɑ yeò ɡiɡii ɑkɑbuu kumɑ́ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Akɑbuuui í jɛ kuwɑ̃ iyi í ceɑ Aburɑhɑmu bɑlɑ nwɑ, ");
INSERT INTO mkl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Í ni nŋu ɑ́ nyɑ wɑ hɑi si ɑwɔi mbɛɛ nwɑ ŋɑ, Nɔ nŋu ku jɔ̀ kɑ ceɑ nŋu icɛ do wɔɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nɔ icɛ iyi ɑɑ kɑ ceɑu ku jɛ do idɔ kumɑ́ nɔ kɑ jɛ dee dee si wɑjuɛ do ɑjɔ fei si kuwɛɛ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nɔ ɑwɔ ɑmɑm, ɑɑ kpeɛ wɑliii Ilɑɑɔ̃, nŋu iyi kù nɛ sɑɑ, Domi ɑɑ cuɑɑ Lɑfɛ̃ɛ i mɑɑ teeseɑ kpɑ̃ɑ, ");
INSERT INTO mkl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nɔ ɑɑ jɔ̀ inɛɛ ŋɑ ɑ mɑ̀ iyi ɑŋɑ ɑɑ bɑ fɑɑbɑ wɑɑti iyi Ilɑɑɔ̃ ɑ́ nyɑ dulum du ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ntɔ ntɔ, ɑrɑɑrei Ilɑɑɔ̃ Lɑfɛ̃ɛ nwɑ í lɑ́ si wɑ. Nɑ sɑɑbui ɑrɑɑreɛui í jɔ̀ inyɑ kumɑ́ í nɑɑ si wɑ hɑi lele bɛi nunui dɑɑkɔ, ");
INSERT INTO mkl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ku bɑ ku mɑ́ inyɑ si inɛ ŋɑ iyi ɑ̀ wɑɑ bubɑ si ilu kuku do si jĩjĩi iku Ku mɑɑ nɛò ɑwɑ fei si kpɑ̃ɑi lɑɑkɑi ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iri iyi Zɑkɑri í kɔ̃u mbɛ. Si ɑnyii nŋu ɑmɑu wɑ lɑ, nɔ bisiɛ wɑ kɔ̃ɔsi nɔ í koo í wɑ ɡbɑbuɑ hee í koo í tóò ɑjɔ iyi í nyisi ɑrɑɛ bɑntumɑ si wɑjui inɛi Izirɛli ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wɑɑti bɛɛbɛ, ilɑɑlu nlɑi Romu iyi ɑ̀ yɑ kpe Oɡusitu í nɑ woodɑ í ni ɑ ce inɛ ŋɑ kukɑ si ilɛɛ fei. ");
INSERT INTO mkl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kukɑ sinteu ihɛ̃ ɑ̀ cooi si wɑɑti iyi Kiriniusi wɑ jɛ ilu ilɛ si ilɛi Siri. ");
INSERT INTO mkl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nɔ inɛ fei í nɛ si iluɛ koo nɑ iriɛ ɑ kɔɔ si tiɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ŋɔi Zozɛfu mɔ í nɛ hɑi Nɑzɑrɛti si ilɛi Gɑlilee, í bɔ ilɛi Zudee si ilui Dɑvidi iyi ɑ̀ yɑ kpe Betelehɛmu, domi nŋu mɔ nyɑɑnzei Dɑvidii wɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Í bɔ ku nɑ iriɛ, nŋu do Mɑɑri ɑboɛ iyi í nɛ ɑsĩ . ");
INSERT INTO mkl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Si wɑɑti iyi ɑ̀ wɑ bɛ, ɑjɔ í nɑ í to bii ɑ́ bí ɑmɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nɔ í bí ɑmɑ sinteɛ, ɑmɑ inɛmɔkɔ. Í biiɛ do ɑcɔ nɔ í tɔɔ si bi ku jɛi ɑnɡudɑ̃ ŋɑ, si nɑ iyi í jɔ̀ inyɑ kù wɛɛ bii inɛ njoo ŋɑ ɑɑ sɔ. ");
INSERT INTO mkl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Woo deɡbe ɡɔ ŋɑ ɑ̀ wɑ inɔ sɑko bɛ, ɑ̀ wɑɑ deɡbe ɑnɡudɑ̃ ŋɑ idũ. ");
INSERT INTO mkl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ŋɔi ɑmɑlekɑi Aɔ̃ Lɑfɛ̃ɛ ɡɔ í fɑɑtɑ si ŋɑ wɑ, nɔ inyɑ kumɑ́ nlɑ ɡɔ í kɑɑko ŋɑ. Inyɑ kumɑ́u ɑmboei Lɑfɛ̃ɛui. Ŋɔi njo í mu ŋɑ jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ammɑ ɑmɑlekɑu í sɔ̃ ŋɑ í ni, i mɑɑ̀ jɔ̀ njo ku mu ŋɛ. Lɑɑbɑɑu jiidɑi ǹ nɑɑ ku sisi nŋɛ, iyi ɑ́ jɛɑ inɛ fei inɔ didɔ̃ nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lɑɑbɑɑuu wee. Nnyi, si ilui Dɑvidi, ɑ̀ bí nŋɛ Woo fɑɑbɑ. Nŋui í jɛ Lɑfɛ̃ɛ, inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yɑɑse bɛi ɑɑ mɑ̀ɑu ŋɑ wee. Aɑ yɛ ɑmɑ kpɔtɔɔ ɡɔ bɛ ɑ̀ biiɛ do ɑcɔ, wɑ sũ si bi ku jɛi ɑnɡudɑ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi ɡbɑkɑ̃ ɑmɑlekɑ mmu ɡɔ ŋɑ ɑ̀ nɑɑ bi tɛɛ ɑŋɑ nkpɔ nkpɔ nɔ ɑ̀ sɑɑbu Ilɑɑɔ̃ ɑ̀ wɑɑ ni, ");
INSERT INTO mkl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","kɑ jɔ̀ irii Ilɑɑɔ̃ ku nɛ ɑmboe hee lele. Nɔ lɑɑkɑi ku sũ ku wɑ si ilɛ si inɛ ŋɑ iyi Ilɑɑɔ̃ í bi. ");
INSERT INTO mkl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ŋɔi ɑmɑlekɑ ŋɑu ɑ̀ jɔ̀ ŋɑ ɑ̀ nyi lele. Si ɑnyii nŋu, woo deɡbe ŋɑu ɑ̀ sɑbuu njɛ ɑ̀ wɑɑ ni, debɛi, kɑ bɔ Betelehɛmu, kɑɑ cɔ mii iyi í ce, iyi Aɔ̃ Lɑfɛ̃ɛ í jɔ̀ ɑ̀ mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nɔ ɑ̀ ce sɑɑsɑ ɑ̀ sɛi ɑ̀ koo. Ŋɔi ɑ̀ to nɔ ɑ̀ yɛ Mɑɑri do Zozɛfu, do ɑmɑ kpɔtɔɔu bii wɑ sũ si bi ku jɛi ɑnɡudɑ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iyi ɑ̀ yɔɔ, ɑ̀ wɑɑ sisi mii iyi ɑmɑlekɑu í sɔ̃ ŋɑ si ɡɑ̃mɛi ɑmɑu. ");
INSERT INTO mkl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nɔ inɛ ŋɑ iyi ɑ̀ ɡbɔ idei woo deɡbe ŋɑu fei ideu í yɑ mu ŋɑ bitii. ");
INSERT INTO mkl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ammɑ Mɑɑri njɛ wɑ mu fei ndɛɛ si idɔɛ, nɔ wɑ lɑsɑbu si do lɑɑkɑi. ");
INSERT INTO mkl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ŋɔi woo deɡbe ŋɑu ɑ̀ sindɑ ɑ̀ wɑɑ nɛ. Nɔ ɑ̀ wɑɑ nyisi ɑmboei Ilɑɑɔ̃, ɑ̀ wɑɑ sɑɑbuɛ nɑ irii mii iyi ɑ̀ ɡbɔ do iyi ɑ̀ yɛ fei, domi fei ndɛɛ í cei si bɛi ɑmɑlekɑu í sisi nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Si ɑjɔ mɛɛjɔsiɑ ŋɔi ɑ̀ sɔɔ Jesu, iri iyi ɑmɑlekɑu í ni ɑ kpoo hɑi wɑɑti iyi iyeɛ kù nɛ ɑsĩu. Ajɔ nŋu bɛ mɔi ɑɑ dɑsiɛ bɑnɡo. ");
INSERT INTO mkl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Mii iyi Moizi í kɔ si woodɑɛ wee. Í ni, ɑmɑ inɛmɔkɔ iyi ɑ̀ bí sinte fei ɑɑ nyɑɑ ikɑ̃i ku jɛ ti Aɔ̃ Lɑfɛ̃ɛ. Nɑ ŋɔi í jɔ̀ iyi wɑɑti í to si bii ɑɑ ce kuwee Mɑɑri ku bɛi ku mɑ́ si ɑyɑwo iyi í ceu Zozɛfu do Mɑɑri ɑ̀ so ɑmɑu ɑ̀ bɔò Zeruzɑlɛmu ku bɑ ɑ nyisi Aɔ̃ Lɑfɛ̃ɛ ");
INSERT INTO mkl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","nɔ ɑ ce kuwee. Kuweeu do kufe minji wɑlɑ do ɑnkɑsiidi minjii ɑ̀ yɑ cooò si bɛi ɑ̀ kɔɔ si woodɑi Aɔ̃ Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wee mɔkɔ ɡɔ í wɑ Zeruzɑlɛmu bɛ ɑ̀ yɑ kpoo Simeɔ̃. Mɔkɔu í jɛ inɛ dee dee nɔ í mɑ̀ bɛɛrɛi Ilɑɑɔ̃. Wɑ deɡbe inɛ iyi ɑ́ nɑ ku tũ idɔi inɛi Izirɛli ŋɑ nɔ Hundei Ilɑɑɔ̃ í wɛɛ do nŋu. ");
INSERT INTO mkl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Hundei Ilɑɑɔ̃u í sɔ̃ɔ wo í ni ɑ́ yɛ inɛ iyi Aɔ̃ Lɑfɛ̃ɛ í cicɑu ku bɛi ku ku. ");
INSERT INTO mkl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ŋɔi Hundeu í tɑle siɛ kpɑsɛ̃i Ilɑɑɔ̃ ku bɔ. Iyi iyeò bɑɑi Jesu ŋɑ ɑ̀ lɔòɛ bɛ ku bɑ ɑ ceɑ bɛi woodɑ í fɔ, ");
INSERT INTO mkl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ŋɔi Simeɔ̃ í ɡbɑɑ í muu si ɑwɔɛ í sɑɑbu Ilɑɑɔ̃ wɑ ni, ");
INSERT INTO mkl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Lɑfɛ̃ɛ, nsɛi jɔ̀ ɑmu woo ce icɛɛ n jɔ̀ ɑndunyɑ do lɑɑkɑi ku sũ si bɛi ì sɔ̃m wo, ");
INSERT INTO mkl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Domi ijum í yɛ fɑɑbɑɛ, ");
INSERT INTO mkl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Iyi ì ce sɔɔluɛ si wɑjui dimi fei. ");
INSERT INTO mkl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nŋui í jɛ inyɑ kumɑ́ iyi ɑ́ nyisi dimi mmu ŋɑ kpɑ̃ɑɛ. Nɔ nŋui í jɛ ɑmboei inɛɛ ŋɑ, inɛi Izirɛli ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ide iyi Simeɔ̃ wɑ fɔ si ɡɑ̃mɛi ɑmɑu í mu iyeò bɑɑɛ fei biti. ");
INSERT INTO mkl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeɔ̃ í wee nŋɑ nɔ í sɔ̃ Mɑɑri iyei Jesuu í ni, Ilɑɑɔ̃ í cicɑ ɑmɑu ihɛ̃i ku kɛkɛ inɛ nkpɔ nɔ ku dede inɛ nkpɔ mɔ si inɔi inɛi Izirɛli ŋɑ. Nŋui Ilɑɑɔ̃ í bɛ wɑ ku jɛ bɛi nyindɑ, ɑmmɑ inɛ ŋɑ ɑɑ kɔ siɛ. ");
INSERT INTO mkl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nɔ lɑsɑbui idɔi inɛ nkpɔ kú fitɑ ɡbuɡbɑ̃ɑ. Awɔ tɑkɑɛ, inɔ ku fɔ ɑ́ ɡũɛ ɑjɔ ɑkɑ̃ si idɔɛ bɛi tɑɑkubɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Inɑɑbo wɑlii ɡɔ mɔ í wɑ bɛ ɑ̀ yɑ kpoo Anɑ, ɑmɑi Fɑnuɛli si dimii Azɛɛ ŋɑ. Abou í ɡbo ntɔ ntɔ. Í ce muɑu zɑkɑi ɑdɔ̃ mɛɛje mɔkɔɛ kù bɛi kù nɑ kù wɛɛ, ");
INSERT INTO mkl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nɔ í bubɑ jɑɑɔ̃ ɑdɔ̃ nkpɔ nkpɔ. Nsɛi ɑbou í nɛ ɑdɔ̃ cinɛ do mɛɛ, nɔ ci yɑ fitɑ hɑi bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃. Dɑsɑ̃ do idũ fei, í yɑ mɑɑ ceɑ Ilɑɑɔ̃ icɛi do ɑnu kudĩ do kutɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wɑɑti bɛɛbɛ nŋu mɔ í sɛkɛɛ si ŋɑ wɑ, wɑ sɑɑbu Ilɑɑɔ̃, nɔ í lɔsi idei ɑmɑu ku sisiɑ inɛ ŋɑ iyi ɑ̀ wɑɑ deɡbe inɛ iyi ɑ́ nɑ ku fɑɑbɑ inɛi Zeruzɑlɛmu ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wɑɑti iyi iyeò bɑɑi Jesu ŋɑ ɑ̀ tɑ̃ mii ŋɑ iyi woodɑi Aɔ̃ Lɑfɛ̃ɛ í ni ɑ ceu fei, ŋɔi ɑ̀ nyi Nɑzɑrɛti ilu nŋɑ si ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nɔ ɑmɑu wɑ lɑ, ɡbuɡbɑ̃ɛ wɑ kɔ̃ɔsi nɔ í kɔ̃ò bisi. Nɔ didɔ̃i Ilɑɑɔ̃ í wɛɛɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Adɔ̃ fei iyeò bɑɑi Jesu ŋɑ ɑ̀ yɑ bɔ jinɡɑui Iku ku kuɑi Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Si wɑɑti iyi Jesu í nɛ ɑdɔ̃ mɑɑteeji ŋɔi ɑ̀ bɔ jinɡɑuu si bɛi ɑ̀ nɛ dɔ̃ɔnɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Iyi jinɡɑuu í tɑ̃ ɑ̀ wɑɑ nɛ, ŋɔi Jesu í ɡbe Zeruzɑlɛmu bɛ, ɑmmɑ bɑɑɛ ŋɑ ɑ kù mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A wɑɑ tɑmɑɑ bɛi í wɑ si inɔ nŋɑi. Wee ɑ̀ nɛi zɑkɑi ɑjɔ ɑkɑ̃, ŋɔi ɑ̀ dɛdɛɛ si inɔi nyɑɑnze nŋɑ ŋɑ do kpɑɑsi nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ammɑ ɑ kù yɔɔ, nɔ ɑ̀ sindɑ ɑ̀ nyi ikpɑ Zeruzɑlɛmu ɑ̀ wɑɑ dɛdɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Si ɑjɔ mɛɛtɑsiɑ ŋɔi ɑ̀ yɔɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃. Wɑ bubɑ si ɑninii woo kɔ inɛ ŋɑ si woodɑ ŋɑ, wɑ ɡbɔ ide nŋɑ nɔ wɑ bee ŋɑ ide. ");
INSERT INTO mkl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Inɛ ŋɑ iyi ɑ̀ wɑɑ ɡbɔ ideɛ fei ɑ̀ bitiò bisiɛ do si bɛi wɑ jɛ nŋɑ ide. ");
INSERT INTO mkl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iyi bɑɑɛ ŋɑu ɑ̀ yɔɔ bɛ, ŋɔi ɑŋɑ mɔ ɑ̀ biti, nɔ iyeɛ í ni, ɑmɑm, nɑ mii í ce ì ce nwɑ bɛɛbɛ. Amu do bɑɑɛ wee, ɑ̀ wɑsi ku dɛdɛɛ do inɔ ku fɔ nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ŋɔi í bee ŋɑ í ni, nɑ mii í ce ì wɑɑ dɛdɛɛm ŋɑ. I kù mɑ̀ ŋɑ iyi wũɑi Bɑɑm nii ǹ nɛ n ce? ");
INSERT INTO mkl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ammɑ ide iyi wɑ sɔ̃ ŋɑu ɑ kù ɡbɔ yɑɑseɛ. ");
INSERT INTO mkl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ŋɔi í too ŋɑ ɑ̀ nɛ Nɑzɑrɛti nɔ wɑ ɡbɔ ide nŋɑ. Wee iyeu wɑ mu ide ŋɑu ihɛ̃ fei si idɔɛ. ");
INSERT INTO mkl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu í lɑ́ wɑ koo nɔ bisiɛ mɔ wɑ kɔ̃ɔsi nɔ wɑ dɔ̃ɑ Ilɑɑɔ̃ si hee do ɑmɑnɛ ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Iyi ilɑɑlu nlɑi Romu iyi ɑ̀ yɑ kpe Tibɛɛ í ce ɑdɔ̃ mɑɑtũ si bommɑɛ, wɑɑti bɛɛbɛ Pɔnsu Pilɑtii wɑ jɛ ilu ilɛi Zudee, nɔ Herodu mɔ wɑ jɛ inɛ nɡbo si ilɛi Gɑlilee, nɔ Filipu ifɔɛu mɔ wɑ jɛ inɛ nɡbo si ilɛi Iture do Tɑkoniti, nɔ Lisɑniɑ mɔ wɑ jɛ inɛ nɡbo si ilɛi Abilɛni. ");
INSERT INTO mkl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ani do Kɑifu ŋɑ mɔ ɑ̀ wɑɑ jɛ woo wee nlɑi Ilɑɑɔ̃. Wɑɑti bɛɛbɛi Ilɑɑɔ̃ í sɔ̃ Zɑ̃ɑ ɑmɑi Zɑkɑri ide si ɡbɑbuɑ. ");
INSERT INTO mkl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nɔ Zɑ̃ɑ í bɔ si ilu ŋɑ iyi ɑ̀ wɑ kɔkɔi idoi Zuudɛ̃ɛ fei wɑ wɑɑzo nŋɑ wɑ ni, i kpɑɑsi idɔ ku bɑ Ilɑɑɔ̃ ku kpɑ idei dulum du ŋɛ nɔ ɑ dɑsi ŋɛ inyi. ");
INSERT INTO mkl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bɛɛbɛi ide iyi wɑlii Ezɑi í kɔ si tiɑɛu í ce. Í ni, Imui inɛ ɡɔ wɑ dɔ̃ ɑnu si ɡbɑbuɑ wɑ ni, I teese kpɑ̃ɑi Lɑfɛ̃ɛ ku tɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nɔ ɑɑ dĩ lɔɔmɑ ŋɑu fei. Nɔ ɡeete do iri kutɑ fei ɑ́ munɡɑ ɑnu, Nɔ kpɑ̃ɑ ku kɑ ŋɑ fei ɑɑ tɛ, Kpɑ̃ɑ iyi í sɑ̃mi fei ɑ́ sĩɑ. ");
INSERT INTO mkl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Inɛ fei ɑ́ yɛ bɛ́i Ilɑɑɔ̃ wɑ fɑɑbɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Zɑmɑɑ nkpɔ nkpɔi wɑ koo bi Zɑ̃ɑ ku dɑsi ŋɑ inyi. Nɔ í sɔ̃ ŋɑ í ni, iŋɛ inɛ buu ŋɑ bɛi njo wukuku, yooi í sɔ̃ ŋɛ í ni i sɑɑ idɔɔkɔ̃i kiitii Ilɑɑɔ̃ iyi ɑ́ nɑ ku nɑɑu. ");
INSERT INTO mkl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nɑ nŋu, i ce kookoosu jiidɑ i nyisiò iyi ì kpɑɑsi idɔ ŋɑ, nɔ i mɑɑ̀ tɑmɑɑ mɑ̀ ɑɑ bɑ fɑɑbɑ ŋɑ si nɑ iyi í jɔ̀ ì yɑ mɑɑ ni iŋɛ ì jɛ dimii Aburɑhɑmu ŋɑ. Ǹ wɑ n sɔ̃ ŋɛ, Ilɑɑɔ̃ ɑ́ yɔkɔ ku so kutɑ ŋɑu ihɛ̃ ku ce ŋɑ dimii Aburɑhɑmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wee dɑɡbɑ wɑ kɑ̃ si jĩi tɑ̃ mɔm ɑ dɑò icuɛ. Nɑ nŋu, jĩi iyi kù wɑɑ so iso jiidɑ fei ɑɑ dɑɑ ɑ dɑsi inɑ. ");
INSERT INTO mkl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ŋɔi zɑmɑɑu í beeɛ wɑ ni, debɛi, bɛirei ɑɑ kɑ ce. ");
INSERT INTO mkl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nɔ í jɛ nŋɑ í ni, inɛ iyi í nɛ ibɔ minji ku so ɑkɑ̃ ku muɑ kpɑɑsiɛ iyi kù nɛ, nɔ inɛ mɔ iyi í nɛ ijɛ ku kpɔ̃ɔ do kpɑɑsiɛ. ");
INSERT INTO mkl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Woo ɡbɑ fiɑi lɛmpoo ɡɔ ŋɑ mɔ ɑ̀ nɑɑ ɑ dɑsi ɑŋɑ mɔ inyi, ŋɔi ɑ̀ beeɛ ɑ̀ ni, Mɛɛtu, bɛirei ɑɑ kɑ ce. ");
INSERT INTO mkl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ŋɔi í sɔ̃ ŋɑ í ni, i mɑɑ̀ ɡbɑ ku lɔ zɑkɑ bɛi ɑ̀ dɑ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ŋɔi sooɡe ɡɔ ŋɑ mɔ ɑ̀ beeɛ ɑ̀ ni, ɑwɑ mɔ ni, bɛirei ɑɑ kɑ ce. Nɔ í sɔ̃ ŋɑ í ni, i mɑɑ̀ yɑ ɡbɑ fiɑi inɛ ɡɔ do ɡbuɡbɑ̃ ŋɑ, nɔ i mɑɑ̀ yɑ mɑ́ inɛ ɡɔ ide, nɔ i mɑɑ̀ yɑ dondɑ iyi ɑ̀ wɑɑ sɑ̃ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Inɛ ŋɑu ɑ̀ wɑɑ cɔ kpɑ̃ɑi inɛ iyi Ilɑɑɔ̃ í cicɑu nɔ ɑ̀ wɑɑ lɑsɑbu si idɔ nŋɑ mɑ̀ Zɑ̃ɑi í jɛ inɛɛu. ");
INSERT INTO mkl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nɔ Zɑ̃ɑ í sɔ̃ ɑŋɑ fei í ni, inyii ɑmu ǹ wɑ n dɑsi ŋɛ, ɑmmɑ inɛ ɡɔ wɑ nɑɑ iyi í rem do ɡbuɡbɑ̃. N kù to n fũ bɑɑ ikũi bɑɑtɑɛ. Nŋui ɑ́ dɑ nŋɛ si Hundei Ilɑɑɔ̃ do inɑ. ");
INSERT INTO mkl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wɑ mu kɑɑle ku fɛ bileeɛ si ɑwɔ, nɔ ku kpɑ̃ bileeu bii ɑ̀ kpokpoɛ, nɔ ku ko yɔyɔɔu ku dɑsi ɑkɑ, sɑkou mɔ ku dɑsi inɑ iyi ci yɑ ku. ");
INSERT INTO mkl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Do fɑɑji nkpɔ ɡɔ ŋɑ mɔi Zɑ̃ɑ wɑ ceɑò inɛ ŋɑ wɑɑzoi lɑɑbɑɑu jiidɑu. ");
INSERT INTO mkl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ammɑ hɑi tɑko ilɑɑlu Herodu í so Heriodiɑsi, ɑboi ifɔɛ, í jɛ ɑboɛ, ŋɔi Zɑ̃ɑ í ɡbɑɡbɑ siɛ nɑ ideu do nɑ dɑɑ lɑɑlɔ ŋɑ iyi í ce fei wo. ");
INSERT INTO mkl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Si ɑntɑi lɑɑlɔ ŋɑ iyi Herodu wɑ ce, do ɑnkɑ̃ɑnyi í nɑ í jɔ̀ ɑ̀ mu Zɑ̃ɑ ɑ̀ dɑsiɛ piisɔ̃ɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Zɑ̃ɑ í wɑsi inɛ nkpɔ nkpɔ ku dɑsi inyi si wɑɑti iyi ɑ kù dɑsiɛ piisɔ̃ɔ, ŋɔi Jesu mɔ í nɑɑ bi tɛɛ, nɔ í dɑsi Jesu mɔ inyi. Ŋɔi Jesu wɑ ce kutɔɔ nɔ lelei Aɔ̃ í cĩ, ");
INSERT INTO mkl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","nɔ Hundei Ilɑɑɔ̃ í de siɛ wɑ hɑi lele do ɑrɑ ɡɔ bɛi ɑnkɑsiidi. Nɔ ɑ̀ ɡbɔ ide ku fɔ ɡɔ wɑ hɑi lele í ni, ɑwɔu ɑmɑm nii, ǹ biɛ jiidɑ jiidɑ. Siɛi inɔ didɔ̃m fei í yɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu í to ɑdɔ̃ kuntɑɑ í bɛi í sinti icɛɛ. Inɛ ŋɑ ɑ̀ yɑ mɑɑ cɔɔi bɛi ɑmɑi Zozɛfu . Bɑlɑi Zozɛfu ŋɑ wee ");
INSERT INTO mkl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli do Mɑtɑti do Levi do Mɛliki do Zɑnɑi Zozɛfu, ");
INSERT INTO mkl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","do Mɑtɑtiɑ do Amɔsu do Nɑumu do Esili do Nɑɡɑi, ");
INSERT INTO mkl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","do Mɑɑtu do Mɑtɑtiɑ do Semɛni do Zozɛki do Zodɑ, ");
INSERT INTO mkl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","do Zoɑnɑni do Rezɑ do Zorobɑbɛli do Sɑlɑtɛli do Neri, ");
INSERT INTO mkl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","do Mɛliki do Adi do Kosɑmu do Elimɑdɑmu do Ɛɛ, ");
INSERT INTO mkl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","do Zozue do Eliezɛɛ do Zorimu do Mɑtɑti do Levi, ");
INSERT INTO mkl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","do Simeɔ̃ do Zudɑ do Zozɛfu do Zonɑmui do Eliɑkimu, ");
INSERT INTO mkl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","do Meleɑ do Mɛnɑ do Mɑtɑtɑ do Nɑtɑ̃ɑ do Dɑvidi, ");
INSERT INTO mkl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","do Izɑi do Obɛdi do Boɑzi do Sɑlumɔ do Nɑsɔ̃ɔ, ");
INSERT INTO mkl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","do Aminɑdɑbu do Adimi do Aɑni do Esiromu do Perɛzi do Zudɑ, ");
INSERT INTO mkl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","do Zɑkɔbu do Izɑɑki do Aburɑhɑmu do Terɑ do Nɑkɔɔ, ");
INSERT INTO mkl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","do Seruku do Rɑɡɑu do Fɑlɛki do Ebɛɛ do Sɑlɑ, ");
INSERT INTO mkl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","do Kɑinɑmu do Aɑfɑsɑdi do Sɛmu do Nowee do Lɑmɛki, ");
INSERT INTO mkl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","do Mɑtusɑlɑ do Enɔku do Zeredi do Mɑleleli do Kɑinɑmu, ");
INSERT INTO mkl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","do Enɔsi do Sɛti do Adɑmu do Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu í kɔ̃ò Hundei Ilɑɑɔ̃ nɔ í bɑɑ hɑi idoi Zuudɛ̃ɛ. Nɔ Hundeu í bɔòɛ si ɡbɑbuɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nɔ Seetɑm í lɛlɛɛ bɛ zɑkɑi ɑjɔ ciiji. Nɔ si ɑjɔu bɛ fei kù jɛ nkɑ̃mɑ. Iyi bɑɑi nŋu í lɔ, ŋɔi ɑri wɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nɔ Seetɑm í sɔ̃ɔ í ni, bii ɑwɔu Amɑi Ilɑɑɔ̃i do ntɔ, jɔ̀ kutɑu ihɛ̃ ku kpɔò pɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nɔ Jesu í jɛɑɑ í ni, kukɔi idei Ilɑɑɔ̃ í ni, ɑmɑnɛ ci yɑ wɛɛ nɑ ijɛ nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nɔ Seetɑm í bɔòɛ hee ɑntɑi iri kutɑ ɡɔ, í nyisiɛ bommɑi ɑndunyɑ fei si iju kɑ̃mɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nɔ í sɔ̃ɔ í ni, ɑmboei bommɑ ŋɑu fei ɑn muuɛ nɔ ɑn jɔ̀ i nɛ yiiko si ŋɑ. Inɛ iyi ǹ bi, lɑfɛ̃ɛi ɑn muɑ, si nɑ iyi í jɔ̀ ɑ̀ nɑm nii. ");
INSERT INTO mkl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nɑ nŋu, bii ì nɑɑ ì ɡulɛ si wɑjum, fei ndɛɛ ɑ́ jɛ tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nɔ Jesu í jɛɑɑ í ni, kukɔi idei Ilɑɑɔ̃ í ni, Aɔ̃ Lɑfɛ̃ɛɛi ɑɑ ɡulɛɑ, nɔ nŋu ɑkɑ̃i ɑɑ tɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nɔ Seetɑm í ɡbɑ̃ɑ í bɔòɛ Zeruzɑlɛmu nɔ í ɡũòɛ hee si ɑntɑi ile lelei kpɑsɛ̃i Ilɑɑɔ̃ nɔ í sɔ̃ɔ í ni, bii ɑwɔu ɑmɑi Ilɑɑɔ̃i, fo i dinɡɑ ilɛ, ");
INSERT INTO mkl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","domi kukɔi idei Ilɑɑɔ̃ í ni, Ilɑɑɔ̃ ɑ́ nɑ ɑmɑlekɑɛ ŋɑ woodɑ nɑ iriɛ ɑ mɑɑ deɡbeɛ, ");
INSERT INTO mkl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","nɔ ɑ mɑɑ muɛ si ɑwɔ ku bɑ i mɑɑ̀ ti i koosɛ si kutɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ŋɔi Jesu í jɛɑɑ í ni, kukɔi idei Ilɑɑɔ̃ í ni, mɑɑ̀ ti i sii Aɔ̃ Lɑfɛ̃ɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Iyi Seetɑm í lɛlɛɛ si bisiɛ ŋɑu bɛ fei í tɑ̃, ŋɔi í jɔ̀ɔ titɑ̃ í nɛ hee wɑɑti mmu ɡɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nɔ Jesu í nyi ikpɑ ilɛi Gɑlilee do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃, nɔ iriɛ í fɑnɡɑɑ si ilɛu fei. ");
INSERT INTO mkl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wɑ kɔ ŋɑ si cioi idei Ilɑɑɔ̃ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ nŋɑ ŋɑ, nɔ inɛ fei wɑ sɑɑbuɛ. ");
INSERT INTO mkl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nɔ Jesu í bɔ Nɑzɑrɛti ilu bii í jɛ ɑmɑu. Ŋɔi si ɑjɔi kusĩmi í bɔ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu si bɛi í nɛ dɔɔnɛɛ. Ŋɔi í dede ku cio tiɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ŋɔi ɑ̀ nɑ́ɑ tiɑ iyi Ezɑi wɑliiu í kɔ. Si bɛi wɑ fũu ŋɔi í kɑ̃ si kukɔ ɡɔ iyi wɑ ni, ");
INSERT INTO mkl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Hundei Aɔ̃ Lɑfɛ̃ɛ í wɑ sim. Í cicɑɑm n sisiɑò ilu ɑre ŋɑ lɑɑbɑɑu jiidɑu. Í bɛm n koo n sɔ̃ inɛi piisɔ̃ɔ ŋɑ n ni ɑɑ jɔ̀ ŋɑ ɑ nɛ Nɔ n sɔ̃ fɛɛju ŋɑ n ni ɑɑ yɛ ilu mɑ́, Nɔ n jɔ̀ inɛ ŋɑ iyi inɛ ŋɑ ɑ̀ wɑɑ tɑɑ ɡbuɡbɑ̃ ɑ nɛ ɑrɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nɔ n sisiɑ inɛ ŋɑ n ni ɑwɑɑtii didɔ̃i Lɑfɛ̃ɛ í to wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ŋɔi Jesu í kɑ tiɑu mɑ́ í sindoɑ woo ce icɛu nɔ í bubɑ. Ŋɔi inɛ ŋɑ iyi ɑ̀ tɔtɔɔ bɛ fei ɑ̀ kɑ̃siɛ iju. ");
INSERT INTO mkl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ŋɔi í sinti ideɛ ku sɔ̃ ŋɑ í ni, nnyii kukɔi idei Ilɑɑɔ̃ iyi ì ɡbɔ nsɛiu ŋɑ í kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ŋɔi ɑŋɑ fei ɑ̀ wɑɑ jɛɑɑ sɛɛdɑ jiidɑ, nɔ biti í mu ŋɑ do ide didɔ̃ iyi wɑ fitɑ hɑi si ɡɛlɛɛu. À ni, kù jɛ ɑmɑi Zozɛfuu mbɛ yɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nɔ Jesu í sɔ̃ ŋɑ í ni, kù nɛ sikɑ ɑɑ kpɑɑm mɔndɑu ihɛ̃ í ni ŋɑ, ɑwɔ lokotoro, fɑɑbɑ ɑrɑɛ. Ce iluɛ ihɛ̃ mii ŋɑ iyi ɑ̀ ɡbɔ ì ce Kɑpɛrɑnumu fei. ");
INSERT INTO mkl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ammɑ ɑn sɔ̃ ŋɛ, wɑlii kɑ̃mɑ kù wɛɛ iyi í yɑ nɛ bɛɛrɛ si ilui nŋu tɑkɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ì mɑ̀ sɑ̃ɑ sɑ̃ɑ ŋɑ iyi ɑri nlɑ ɡɔ í ce si ilɛu fei si wɑɑtii Elii wɑlii nlɑu. Ijĩ kù rɔ si ɑfei ɑdɔ̃ mɛɛtɑ do cukpɑ mɛɛfɑ, mɑ irei. Wɑɑti bɛɛbɛ inɑɑbo jɑɑɔ̃ nkpɔi í wɑ si ilɛi Izirɛli. ");
INSERT INTO mkl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Do nŋu fei, Ilɑɑɔ̃ kù bɛ Elii wɑlii nlɑu bi kɑ̃mɑ nŋɑ bii kù jɛ bi jɑ̃ɑɔ̃ ɡɔ í wɑ Sɑrɛputɑ si ilɛi Sidɔ̃ɔ . ");
INSERT INTO mkl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nɔ dintɛ nkpɔ mɔi í wɛɛ wo si ilɛi Izirɛli si wɑɑtii Elizee wɑliiu. Do nŋu fei, kù jɔ̀ ɡɔɡɔ nŋɑ ɡɔ ku bɑ iri, bii kù jɛ Nɑɑmɑ inɛi ilɛi Siriu. ");
INSERT INTO mkl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi idɔi inɛ ŋɑ iyi ɑ̀ wɑ ile bii ɑ̀ yɑ ce kutɔtɔɔu bɛ fei í kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ŋɔi ɑ̀ dede ɑ̀ leleɛ hɑi inɔ iluu ɑ̀ bɔòɛ hee si ɑntɑi iri kutɑ si bii ɑ̀ mɑ ilu nŋɑ ku bɑ ɑ tɑleɛ wɑ ilɛ. ");
INSERT INTO mkl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ammɑ í lɔ ɑnini nŋɑ bɛ í nɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nɔ Jesu í bɔ Kɑpɛrɑnumu, ilui Gɑlilee ɡɔ nɔ wɑ kɔ inɛ ŋɑ si cioi idei Ilɑɑɔ̃ si ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wɑ kɔ ŋɑ si cio do yiiko. Nŋui í jɔ̀ ideu í tosi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wee mɔkɔ ɡɔ í wɑ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu bɛ í nɛ inɛi inɔɔko, ŋɔi í dɔ̃ ɑnu hee lele í ni, ");
INSERT INTO mkl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","mii í wɑ si ɡɑ̃mɛi ɑwɑɛ ŋɑ ɑwɔ Jesu inɛi Nɑzɑrɛti. Ì nɑɑ ku kpɑ wɑi? Ǹ mɑ̀ inɛ iyi ì jɛ. Awɔi ì jɛ inɛ kumɑ́ iyi Ilɑɑɔ̃ í bɛ wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ŋɔi Jesu í lɑ siɛ í ni, coko, fitɑ hɑi si mɔkɔu. Ŋɔi inɛi inɔɔkou í tɑ mɔkɔu ilɛ si ɑnini nŋɑ, nɔ í fitɑ siɛ, kù mɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ŋɔi ɑŋɑ fei ɑ̀ biti, ɑ̀ bee njɛ ɑŋɑ duusɔ̃ɔ ɑ̀ wɑɑ ni, ide dimi yoomɑi ihɛ̃. Mɔkɔu wee wɑ sɔ̃ inɛi inɔɔko ŋɑ ide do yiiko do ɡbuɡbɑ̃ nɔ ɑ̀ wɑɑ fitɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ŋɔi iriɛ í fɑnɡɑɑ si ilɛɛkoi iluu fei. ");
INSERT INTO mkl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ŋɔi Jesu í fitɑ hɑi ile bii ɑ̀ yɑ ce kutɔtɔɔu, nɔ í bɔ kpɑsɛ̃i Simɔɔ. Wee iyei ɑboi Simɔɔu wɑ ce bɔ̃ɔi ɑrɑ ɡbɑ̃ɑ ntɔ ntɔ. Ŋɔi ɑ̀ tɔɔɛ ku jɔ̀ ku bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ŋɔi í kɔmbɑ si ɑbou í lɑ si ɑrɑ ɡbɑ̃ɑu nɔ í nyɑ. Nɔ ɑbou í dede ɡbɑkɑ̃ í yɑɑɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Alɛi ɑjɔ nŋu iyi inunu í lɔ, ŋɔi inɛ ŋɑ iyi inɛ nŋɑ ŋɑ ɑ̀ wɑɑ ce bɔ̃ɔ dimi ikɑ̃ ikɑ̃ fei ɑ̀ wɑsi ku nɑɑò ŋɑ wɑ bi tɛɛ. Nɔ í lesi ɑŋɑ fei ɑwɔ í jɔ̀ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Inɛi inɔɔko ŋɑ mɔ ɑ̀ fitɑ hɑi si inɛ nkpɔ, ɑ̀ dɔ̃ò ɑnu ɑ̀ wɑɑ ni, ɑwɔi ì jɛ Amɑi Ilɑɑɔ̃. Ammɑ Jesu í lɑ si ŋɑ nɔ wɑ ɡɑnji ŋɑ ide ku fɔ domi ɑ̀ mɑ̀ iyi nŋuu inɛ iyi Ilɑɑɔ̃ í cicɑi. ");
INSERT INTO mkl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Iyi iju í mɑ́ ŋɔi Jesu í fitɑ hɑi inɔ ilu í bɔ ɡbɑbuɑ. Ŋɔi zɑmɑɑ nkpɔ nkpɔ ɡɔ wɑ dɛdɛɛ. Iyi ɑ̀ to bi tɛɛ ŋɔi ɑ̀ tɔɔɛ suuru ku mɑɑ̀ nɛ ku jɔ̀ ɑŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ammɑ í sɔ̃ ŋɑ í ni, kù nɛ bɛi ɑn ce iyi n kù wɑɑzo lɑɑbɑɑu jiidɑi bommɑi Ilɑɑɔ̃ si ilu mmu ŋɑ mɑ́, domi nɑ nŋui ɑ̀ bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iyi í fɔ bɛɛbɛ í tɑ̃ nɔ í koo í dɑbii wɑ ce wɑɑzo ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ ŋɑ ilɛi Zudee. ");
INSERT INTO mkl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ajɔ nŋu ɡɔ Jesu wɑ leekĩ kɔkɔi tenku iyi ɑ̀ yɑ kpe Genesɑrɛti, nɔ zɑmɑɑ nlɑ ɡɔ wɑ mɑnteɛ ku bɑ ɑ ɡbɔ idei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nɔ í yɛ ɑkɔi inyi minji itĩi tenkuu bɛ. Ammɑ sɔɔkɔ ŋɑu ɑ̀ fitɑ ɑ̀ wɑɑ wiɛ tɑɑo nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nɔ Jesu í lɔ inɔ ɑkɔi inyiu ɑkɑ̃. Akɔi inyi iyi í lɔ siu inɛ nŋu ti Simɔɔi. Nɔ í kpe Simɔɔ í tɔɔɛ í ni ku nɑ ku sɛkɛɛò ɑkɔu hɑi itĩi inyiu keeke. Ŋɔi í bubɑ si inɔi ɑkɔu, wɑ kɔ zɑmɑɑu si cio. ");
INSERT INTO mkl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iyi í fɔ ideɛ í tɑ̃ nɔ í sɔ̃ Simɔɔ í ni, bɔò ɑkɔu si buɑ, nɔ i le tɑɑo nŋɛ ŋɑ si inyiu i mu cɛ̃ɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ŋɔi Simɔɔ í sɔ̃ɔ í ni, Mɛɛtu, ɑ̀ ce icɛ do idũ fei ɑ kù mu nɡɔɡɔ. Ammɑ si bɛi ɑwɔi ì fɔ, ɑn dɑsi tɑɑo ŋɑu inɔ inyi. ");
INSERT INTO mkl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ŋɔi ɑ̀ dɑsi tɑɑo nŋɑ ŋɑu inɔ inyi. Iyi ɑ̀ dɑsi ŋɔi ɑ̀ mu cɛ̃ɛ bututu hee tɑɑo nŋɑ ŋɑu ɑ̀ wɑɑ bi ɑ ɡɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nɔ ɑ̀ kpe kpɑɑsi nŋɑ ŋɑ iyi ɑ̀ wɑ si ɑkɔ minjisiɑu do ɑwɔ ɑ nɑɑ ɑ sobi ŋɑ. Iyi ɑŋɑ mɔ ɑ̀ nɑɑ nɔ ɑkɔ minjiu fei í kɔ̃ do cɛ̃ɛ hee wɑ bi ku mi. ");
INSERT INTO mkl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Iyi Simɔɔ Piɛɛ í yɛ mii nɔu í ce bɛɛbɛ ŋɔi í koo í ɡulɛ si wɑjui Jesu í ni, Lɑfɛ̃ɛ, tɛkɛɛ hɑi bi tom, domi ɑmuu ilu dulum nii. ");
INSERT INTO mkl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Í fɔ bɛɛbɛi si nɑ iyi í jɔ̀ njo í muu, nŋu do kpɑɑsiɛ ŋɑu fei nɑ cɛ̃ɛ nkpɔ nkpɔ iyi ɑ̀ muu. ");
INSERT INTO mkl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bɛɛbɛ mɔi njo í mu kpɑɑsi minjiɛ ŋɑ, Zɑɑki do Zɑ̃ɑ ɑmɑi Zebedee ŋɑu. Ammɑ Jesu í sɔ̃ Simɔɔ í ni, mɑɑ̀ jɔ̀ njo ku muɛ. Bɛbɛi inɛ ŋɑ iyi ɑɑ toom ŋɑi ɑɑ yɑ mɑɑ dɛdɛ. ");
INSERT INTO mkl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ŋɔi ɑ̀ bɔò ɑkɔi inyiu ice nɔ ɑ̀ jɔ̀ fei ndɛɛ ɑ̀ wɑɑ too Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Si ɑnyii nŋu Jesu í wɑ si ilu ɡɔ bɛ, nɔ mɔkɔ ɡɔ í nɑɑ bi tɛɛ. Mɔkɔu wɑ ce bɔ̃ɔi dintɛ jiidɑ. Iyi í yɛ Jesu ŋɔi í nɑɑ í sɛɛbɑtɑ si wɑjuɛ í tɔɔɛ suuru í ni, Lɑfɛ̃ɛ, bii ì bi, ɑɑ yɔkɔ i jɔ̀ n bɑ iri n jɛ inɛ iyi í mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ŋɔi Jesu í yɔ ɑwɔɛ í luu nɔ í ni, ǹ bi. Bɑ iri nɔ i jɛ inɛ kumɑ́. Bɛ ɡbɑkɑ̃ bɔ̃ɔi dintɛu í nyɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ŋɔi Jesu í sɔ̃ɔ í ni ku mɑɑ̀ sɔ̃ inɛ kɑ̃mɑ ideu bɛ, ɑmmɑ koo nyisi ɑrɑɛ bi woo weei Ilɑɑɔ̃u. Nɔ í ni ku ce kuwee iyi Moizi í jilɛu. Kuweeu bɛi ɑ́ nyisi inɛ ŋɑ iyi ì jɛ inɛ iyi í mɑ́ bɛbɛi. ");
INSERT INTO mkl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Do nŋu fei, iriɛ í fɑnɡɑɑ wɑ kɔ̃ɔsi, nɔ zɑmɑɑ nkpɔ nkpɔ í yɑ mɑɑ tɔtɔɔ bi tɛɛ ku bɑ ɑ ɡbɔ ideɛ nɔ ku bɑ ɑ bɑ iri si bɔ̃ɔ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ammɑ Jesu í yɑ bɔ ɡbɑbuɑi nŋu ɑkɑ̃ koo ce kutɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ajɔ nŋu ɡɔ Jesu wɑ kɔ inɛ ŋɑ si cio. Wee Fɑrisi do woo kɔ inɛ ŋɑ si woodɑ ɡɔ ŋɑ ɑ̀ wɑɑ bubɑ bɛ. À nɑɑi hɑi Zeruzɑlɛmu do hɑi ilu ŋɑ iyi ɑ̀ wɑ ilɛi Zudee do ilɛi Gɑlilee fei. Nɔ inɛ ŋɑ ɑ̀ wɑɑ yɛ ɡbuɡbɑ̃i Lɑfɛ̃ɛ Jesu wɑɑti iyi í jɔ̀ bɔ̃ɔ ŋɑ ɑ̀ wɑɑ bɑ iriu. ");
INSERT INTO mkl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ŋɔi inɛ ɡɔ ŋɑ mɔ ɑ̀ nɑɑ bɛ ɑ̀ wɑɑ so wɛɛɡɛ ɡɔ wɑ si mɑkɛɛ. Nɔ ɑ̀ wɑɑ dɛdɛ bɛi ɑɑ ce ɑ lɔòɛ ile ɑ koo ɑ jilɔɔ si wɑjui Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ammɑ ɑ kù bɑ do bii ɑɑ lɔòɛ nɑ irii zɑmɑɑu, ŋɔi ɑ̀ koo ɑ̀ ɡũ ɑntɑi ileu, ɑ̀ luu nɔ ɑ̀ kitɑɑɛ do mɑkɛɛu si ɑninii zɑmɑɑu si wɑjui Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iyi Jesu í yɛ nɑɑnɛ nŋɑ ŋɔi í sɔ̃ wɛɛɡɛu í ni, mɔkɔɔyi, ǹ kpɑ idei dulum dɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Woo kɔ inɛ ŋɑ si woodɑ do Fɑrisi ŋɑ ɑ̀ wɑsi ku bee ɑrɑ nŋɑ ide ɑ̀ wɑɑ ni, yooi inɛɛu ihɛ̃ í jɛ iyi wɑ bu Ilɑɑɔ̃. Yooi ɑ́ yɔkɔ ku kpɑ idei dulum dii inɛ ɡɔ bii kù jɛ Ilɑɑɔ̃ nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ammɑ Jesu í mɑ̀ lɑsɑbui idɔ nŋɑ, ŋɔi í bee ŋɑ í ni, nɑ mii í jɔ̀ ì wɑɑ ce dimii lɑsɑbu bɛɛbɛ si idɔ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yoomɑi í fɑɑlɑ í re, inɛ ku sɔ̃ inɛ ɡɔ ku ni ǹ kpɑ idei dulum dɛɛ, wɑlɑkɔ ku ni ku dede ku nɛ. ");
INSERT INTO mkl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ammɑ ǹ bi i mɑ̀ ŋɑ iyi ɑmu Amɑi Amɑnɛ ǹ nɛ ɡbuɡbɑ̃ n kpɑ idei dulum dii inɛ ŋɑ si ɑndunyɑ. Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi í sɔ̃ wɛɛɡɛu í ni, dede i so mɑkɛɛɛ i bɔ kpɑsɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ŋɔi ɡbɑkɑ̃ wɛɛɡɛu í dede si wɑju nŋɑ, í so mɑkɛɛ iyi wɑ sũ siu, nɔ wɑ nɛ kpɑsɛ̃ wɑ sɑɑbuò Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ŋɔi ɑŋɑ fei ɑ̀ biti ɑ̀ wɑɑ sɑɑbu Ilɑɑɔ̃. Njo í bɛi wɑ mu ŋɑ ɑ̀ wɑɑ ni, ɑ̀ yɛ mii mɑɑmɑɑke nnyi. ");
INSERT INTO mkl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Si ɑnyii nŋu, Jesu í fitɑ wɑ nɛ si inɔ ilu. Nɔ í yɛ woo ɡbɑ fiɑi lɛmpoo ɡɔ ɑ̀ yɑ kpoo Levi, wɑ bubɑ ile bi ku ce icɛɛ, nɔ Jesu í sɔ̃ɔ í ni, toom wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ŋɔi Levi í dede, í jɔ̀ mii ndɛɛ fei í tooɛ. ");
INSERT INTO mkl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Si ɑnyiɛ, í ceɑ Jesu jinɡɑu nlɑ ɡɔ si kpɑsɛ̃ɛ. Woo ɡbɑ fiɑi lɛmpoo bututu do inɛ ɡɔ ŋɑ mɔ ɑ̀ wɑɑ bɑ ŋɑ ku jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Wee Fɑrisi ɡɔ ŋɑ ɑ̀ wɑ bɛ do Fɑrisi mmu ɡɔ ŋɑ iyi ɑ̀ jɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑ. Aŋɑi ɑ̀ wɑɑ ɡbɑɡbɑ si mɔcɔi Jesu ŋɑu ɑ̀ wɑɑ ni, nɑ mii í ce ì jɛ ì wɑɑ mɔ ŋɑ do woo ɡbɑ fiɑi lɛmpoo do inɛ lɑɑlɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iyi Jesu í ɡbɔ bɛɛbɛ ŋɔi í jɛ nŋɑ í ni, ilu bɑɑni ŋɑ ɑ kù nɛ bukɑɑtɑi ilu iwɔ bii kù jɛ bɔ̃ɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bɛɛbɛ mɔi n kù nɑɑ ku kpe inɛ dee dee ŋɑ, ɑmmɑ ilu dulum ŋɑi ǹ nɑɑ ku kpe ɑ kpɑɑsi idɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ŋɔi inɛ ŋɑu ɑ̀ bee Jesu mɑ́ ɑ̀ ni, bɛirei í ce mɔcɔi Zɑ̃ɑ woo dɑsi inyiu do ti Fɑrisi ŋɑ ɑ̀ yɑ dĩ ɑnu ɑ mɑɑ ceò kutɔɔ, nɔ wee mɔcɔɛ ŋɑ ɑ ci yɑ dĩ ɑnu. À yɑ mɑɑ jɛi nɔ ɑ mɑɑ mɔ. ");
INSERT INTO mkl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ŋɔi Jesu í bee ŋɑ í ni, ɑɑ yɔkɔ i jɔ̀ kpɑɑsii mɔkɔ titɔ̃ ŋɑ ɑ̀ dĩ ɑnu si wɑɑti iyi mɔkɔ titɔ̃u í wɑ inɔ nŋɑ? ");
INSERT INTO mkl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ammɑ ɑjɔ wɑ nɑɑ iyi ɑɑ nyɑ mɔkɔ titɔ̃u hɑi si inɔ nŋɑ. Wɑɑti bɛɛbɛi ɑɑ dĩ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ŋɔi í kpɑ nŋɑ mɔndɑ ɡɔ í ni, ɑ ci yɑ ɡɑ ibɔ titɔ̃ ɑ sɔò ibɔ nɡbo. Bii ì ce bɛɛbɛ, ì bɛjɛ ibɔ titɔ̃u mbɛ nɔ jɑɑɛ titɔ̃u ɑ́ wɛɛi ikɑ̃ kɑɑ ce si ibɔ nɡbou. ");
INSERT INTO mkl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Inɛ ɡɔ ci yɑ nɔ kù dɑsi vɛ̃ɛ titɔ̃ iyi wɑ ɡbɑ si bɔɡɔ bɑtɑ nɡbo ŋɑ. Bii í ce bɛɛbɛ, vɛ̃ɛu ɑ́ jɔ̀ bɔɡɔ ŋɑu ku ɡɑ, vɛ̃ɛu ku nikɑ̃ nɔ bɔɡɔ ŋɑu ku bɛjɛ. ");
INSERT INTO mkl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ammɑ ɑ̀ yɑ dɑsi vɛ̃ɛ titɔ̃i si bɔɡɔ titɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nɔ inɛ ɡɔ kù wɛɛ iyi ɑ́ mɔ vɛ̃ɛ nwo nɔ ku bi vɛ̃ɛ titɔ̃ mɑ́, domi ɑ́ ni nwou í ceɑ nŋu. ");
INSERT INTO mkl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Si ɑjɔi kusĩmi ɡɔ Jesu wɑ too kɔɔi ilɛ ɡɔ, ŋɔi mɔcɔɛ ŋɑ ɑ̀ wɔ ɑmɑɑjɛ iyi ɑ̀ ɡbɛ̃ si ilɛu ɑ̀ nunu ijuɛ si ɑwɔ ɑ̀ wɑɑ ŋɔ. ");
INSERT INTO mkl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ŋɔi Fɑrisi ɡɔ ŋɑ ɑ̀ bee ŋɑ ɑ̀ ni, nɑ mii í jɔ̀ ì wɑɑ ce mii iyi ɑ kù nɛ kpɑ̃ɑi ku ce si ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ŋɔi Jesu í bee ŋɑ í ni, i kù cio mii iyi Dɑvidi í ce, nŋu do inɛɛ ŋɑ, si wɑɑti iyi ɑri wɑ kpɑ ŋɑu? ");
INSERT INTO mkl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Í lɔ kpɑsɛ̃i Ilɑɑɔ̃ nɔ í so pɛ̃ɛ iyi ɑ̀ jilɛɑ Ilɑɑɔ̃ í jɛ, nŋu do inɛɛ ŋɑ. Wee ɑ̀ ɡɑnji inɛ fei ku jɛ pɛ̃ɛu bɛ bii kù jɛ woo weei Ilɑɑɔ̃ ŋɑ ɑŋɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nɔ Jesu í sɔ̃ ŋɑ mɑ́ í ni, ɑmu Amɑi Amɑnɛ, ɑmui ǹ jɛ inɛ nɡboi ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Si ɑjɔi kusĩmi mmu ɡɔ, Jesu í lɔ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu nɔ í wɑsi ku ceɑ inɛ ŋɑ cioi idei Ilɑɑɔ̃. Wee mɔkɔ ɡɔ í wɑ bɛ, ɑwɔ njɛɛ í ku í ɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Woo kɔ inɛ ŋɑ si woodɑ do Fɑrisi ŋɑ ɑ̀ kɑ̃si Jesu iju, ɑ̀ wɑɑ cɔ mɑ̀ ɑ́ jɔ̀ inɛɛu ku bɑ iri si ɑjɔi kusĩmi. À wɑɑ cɔɔ domi ɑ̀ wɑɑ bi ɑ yɛ tɑɑleɛi. ");
INSERT INTO mkl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ammɑ Jesu í mɑ̀ lɑsɑbu nŋɑ, ŋɔi í sɔ̃ mɔkɔ iyi ɑwɔɛ í kuu í ni, dede i leekĩ si ɑnini nŋɑ bɛ. Nɔ í dede í leekĩ. ");
INSERT INTO mkl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nɔ Jesu í ni, ǹ wɑ n bee ŋɛi, si ɑjɔi kusĩmi, í sĩɑ ɑmɑnɛ ku ce jiidɑ de mɑ̀ lɑɑlɔ, ku fɑɑbɑ ɑmɑnɛ de, mɑ̀ ku kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ŋɔi í cɔ ɑŋɑ fei í kɑɑko ŋɑ, nɔ í sɔ̃ mɔkɔu í ni, tɛ ɑwɔɛ. Iyi í tɛ ɑwɔu ŋɔi í bɑɑ dee dee. ");
INSERT INTO mkl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ŋɔi idɔ nŋɑ í kɔ̃, nɔ ɑ̀ wɑɑ busi njɛ bɛi ɑɑ ceɑ Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wɑɑti bɛɛbɛ Jesu í koo í ɡũ iri kutɑ ɡɔ ku ce kutɔɔ. Nɔ idũu fei í wɑsi ku ce kutɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Iyi iju í mɑ́ í tɔtɔɔ mɔcɔɛ ŋɑ nɔ í cicɑ ɑmɑnɛ mɑɑteeji si inɔ nŋɑ, í sɔ ŋɑ woo bɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iri nŋɑ wee, Simɔɔ iyi í sɔ Piɛɛ, do Anderee ifɔɛ, do Zɑɑki do Zɑ̃ɑ do Filipu do Bɑɑtelemi ");
INSERT INTO mkl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","do Mɑtie do Tomɑɑ do Zɑɑki ɑmɑi Alifee, do Simɔɔ inɛi iɡbɛi Zelɔtu , ");
INSERT INTO mkl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","do Zudɑsi ɑmɑi Zɑɑki, do Zudɑsi Isikɑriɔti iyi ɑ́ nɑ ku zɑmbɑɛu. ");
INSERT INTO mkl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Wɑɑti iyi Jesu í cicɑ woo bɛ mɑɑteeji ŋɑu í tɑ̃ ŋɔi ɑŋɑò ŋɑ ɑ̀ kitɑ wɑ ɑ̀ wɑɑ leekĩ si ilɛ ku munɡɑ ɑnu ɡɔ. Tenɡi bɛi mɔcɔ nkpɔɛ ŋɑu ɑ̀ wɑ do zɑmɑɑ nlɑ ɡɔ. Inɛ ŋɑu ɑ̀ nɑɑi hɑi ilɛi Zudee fei do Zeruzɑlɛmu ilu nlɑɛ, do hɑi Tii do Sidɔ̃ɔ, ilu ŋɑ iyi ɑ̀ wɑ ikpɑ bi inyi dũdũ. ");
INSERT INTO mkl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","À nɑɑ bi tɛɛi ku bɑ ɑ ɡbɔ ideɛ nɔ ɑ bɑ iri si bɔ̃ɔ nŋɑ. Inɛ ŋɑ iyi inɛi inɔɔko ŋɑ ɑ̀ sindɑ iri nŋɑ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ŋɔi inɛ ŋɑu fei ɑ̀ wɑɑ dɛ ku luu, domi ɡbuɡbɑ̃ nlɑ nlɑ í yɑ fitɑ siɛ nɔ ku jɔ̀ ɑŋɑ fei ɑ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ŋɔi Jesu í cɔ mɔcɔɛ ŋɑu í ni, Ilu inɔ didɔ̃ ŋɑi iŋɛ ilu ɑre ŋɑ, domi iŋɛi ì jɛ inɛi bommɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ilu inɔ didɔ̃ ŋɑi iŋɛ iyi ɑri wɑ kpɑ si nsɛi domi Ilɑɑɔ̃ ɑ́ jɔ̀ i yo ŋɑ. Ilu inɔ didɔ̃ ŋɑi iŋɛ iyi ì wɑɑ kpɑtɑ si nsɛi, domi ɑɑ nɑ i nyɑɑnyi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Iŋɛ ilu inɔ didɔ̃ ŋɑi bii inɛ ŋɑ ɑ̀ cé ŋɛ, nɔ ɑ̀ lele ŋɛ hɑi inɔ nŋɑ, nɔ ɑ̀ wɑɑ bu ŋɛ, nɔ ɑ̀ wɑɑ sɔ ŋɛ iri lɑɑlɔ nɑ irii ɑmu Amɑi Amɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ajɔ nŋu, i jɔ̀ inɔ nŋɛ ku dɔ̃, i fo i dinɡɑɑ do inɔ didɔ̃, domi ribɑ iyi ɑ̀ jilɛ nŋɛ lelei Aɔ̃ í lɑ. Inɛ ŋɑu bɛ, bɛɛbɛi mɔi bɑlɑ nŋɑ ŋɑ ɑ̀ ceɑ wɑlii ŋɑu wo. ");
INSERT INTO mkl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ammɑ inɔ kufɔi ɑ́ jɛ ti iŋɛ ilu fiɑ ŋɑ, domi ì bɑ inɔ nŋɛ í tũ tɑ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Inɔ kufɔi ɑ́ jɛ ti iŋɛ iyi ì wɑ si ɑyo si nsɛi, domi ɑri ɑ́ nɑ ku kpɑ ŋɛ. Inɔ kufɔi ɑ́ jɛ ti iŋɛ iyi ì wɑɑ nyɑɑnyi si nsɛi, domi ɑɑ nɑ i kpɑtɑ i mɑɑ cɑ̃ kpokpo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Iŋɛ ilu inɔ kufɔ ŋɑi bii inɛ fei wɑ sɑɑbu ŋɛ domi bɛɛbɛi bɑlɑ nŋɛ ŋɑ ɑ̀ ceɑ wɑlii ilu ibo ŋɑu wo. ");
INSERT INTO mkl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ammɑ iŋɛ iyi ì sotĩ ì wɑɑ ɡbɔ idem ŋɑ, ǹ wɑ n sɔ̃ ŋɛi, i yɑ bi mbɛɛ nŋɛ ŋɑ, nɔ inɛ ŋɑ iyi ɑ̀ cé ŋɛ i yɑ ce nŋɑ jiidɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","I weeɑ inɛ ŋɑ iyi ɑ̀ wɑɑ ce ikpe ŋɛ, nɔ i yɑ ceɑ inɛ ŋɑ iyi ɑ̀ wɑɑ ce nŋɛ lɑɑlɔ kutɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bii inɛ ɡɔ í sɑmbɑlɑɛ, toɑ kɛkɛlɛ ɑkɑ̃ɛ mɑ́. Inɛ iyi í ɡbɑ ibɔ kumbooɛ, mɑɑ̀ ti i kɔ ku so dɑnziɡiɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bii inɛ ɡɔ í tɔɔɛ mii ɡɔ, muɑɑ. Bii inɛ ɡɔ í so mii ndɛɛ ɡɔi, mɑɑ̀ ti i beeɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Dimi iyi ì bi inɛ ŋɑ ɑ ce nŋɛ, iŋɛ mɔ i ce nŋɑ dimi nŋu. ");
INSERT INTO mkl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Bii inɛ ŋɑ iyi ɑ̀ bi ŋɛ ɑŋɑ ɑkɑ̃i iŋɛ mɔ ì bi ŋɑ, sɑɑbu yoomɑi ì nɛ ŋɑ. Bɑɑ woo ce lɑɑlɔ ŋɑ tɑkɑ nŋɑ ɑ̀ yɑ bi kpɑɑsi nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bii inɛ ŋɑ iyi ɑ̀ wɑɑ ce nŋɛ jiidɑ, ɑŋɑi iŋɛ mɔ ì wɑɑ sɑ̃ɑ ɡbese, sɑɑbu yoomɑi ì nɛ ŋɑ. Bɑɑ woo ce lɑɑlɔ ŋɑ tɑkɑ nŋɑ ɑ̀ yɑ ce bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bii ì wɑɑ wɛ̃ɑ inɛ ŋɑ nɡɔɡɔ nɑ iyi í jɔ̀ ì wɑɑ tɑmɑɑ ɑɑ nɑ ɑ sɑ̃ nŋɛ, to, sɑɑbu yoomɑi ì nɛ ŋɑ. Bɑɑ woo ce lɑɑlɔ ŋɑ tɑkɑ nŋɑ ɑ̀ yɑ wɛ̃ɑ njɛ nɔ ɑ sɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ammɑ i bi mbɛɛ nŋɛ ŋɑ, i ce nŋɑ jiidɑ ŋɑ, i yɑ wɛ̃ nŋɑ i mɑɑ̀ cɔ kpɑ̃ɑi ku sɑ̃ ŋɑ. Bii ì wɑɑ ce bɛɛbɛ ŋɑ, ribɑ nŋɛ ɑ́ lɑ nɔ ɑɑ jɛ ɑmɑi Ilɑɑɔ̃ ŋɑ, nŋu iyi kù nɛ sɑɑ, domi nŋu tɑkɑɛ wɑ nyisi ɑmɑnɛ ɡudulu ŋɑ do ɑmɑnɛ lɑɑlɔ ŋɑ didɔ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","I jɔ̀ i nɛ ɑrɑɑrei inɛ ŋɑ bɛi Bɑɑ nŋɛ mɔ í nɛ. ");
INSERT INTO mkl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesu í sɔ̃ ŋɑ mɑ́ í ni, i mɑɑ̀ yɑ kiiti inɛ ŋɑ, nɔ Ilɑɑɔ̃ mɔ kɑɑ kiiti ŋɛ. I mɑɑ̀ yɑ yɛ tɑɑlei inɛ ŋɑ nɔ Ilɑɑɔ̃ mɔ kɑɑ yɛ tɑɑle nŋɛ. I yɑ kpɑ idei kurɑrɑi njɛ ŋɑ nɔ Ilɑɑɔ̃ mɔ ɑ́ kpɑ idei kurɑrɑi iŋɛ mɔ. ");
INSERT INTO mkl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","I yɑ muɑ njɛ ŋɑ nɔ Ilɑɑɔ̃ mɔ ɑ́ mu nŋɛ. Si ɡũɑ nlɑ nlɑi ɑ́ ce nŋɛ ɑmuɑ. Á yɑɡɑɛ ku kitiɡbɑɛ ku kɔ̃ hee ɑndɛɛ, nɔ ku cuu nŋɛ si bɔɡɔ. Ntɔ ntɔ ɡũɑ iyi ì wɑ̃ɑò kpɑɑsi ŋɑ, nŋui Ilɑɑɔ̃ mɔ ɑ́ wɑ̃ nŋɛ do. ");
INSERT INTO mkl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nɔ í kpɑ nŋɑ mɔndɑ ɡɔ í ni, fɛɛju ɑ́ yɔkɔ ku muɑ fɛɛju ɑkpɑ? Bii fɛɛju ŋɑ ɑ̀ wɑɑ muɑ njɛ ɑkpɑ ɑŋɑ minji fei ɑ kɑɑ dɑsi isɑ? ");
INSERT INTO mkl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Woo kɔkɔ icɛ ci yɑ re inɛ nɡboɛ. Ammɑ inɛ fei, wɑɑti iyi í mɑ̀ mii iyi inɛ nɡboɛ í nyisiɛ, nŋu mɔ í yɑ yɛi bɛi inɛ nɡbou. ");
INSERT INTO mkl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nɑ mii í ce ì wɑɑ yɛ fɔfɔ keeke iyi í wɑ si ijui kpɑɑsiɛ nɔ i kù yɛ jĩi ite iyi í wɑ si titɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bɛirei ɑɑ ce i ni, kpɑɑsi, jɔ̀ n nyɑɛ fɔfɔ si ijuɛ, nɔ ɑwɔ i kù wɑɑ yɛ jĩi ite iyi í wɑ si titɛɛ. Awɔ ilu muɑfitii, jɔ̀ i tɑko i nyɑ jĩi ite iyi í wɑ si ijuɛu titɑ̃ ku bɑ i yɛ ilu sɑ̃ɑ sɑ̃ɑ, i bɛi i nyɑ fɔfɔ iyi í wɑ si ijui kpɑɑsiɛ. ");
INSERT INTO mkl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, jĩi jiidɑ kɑɑ so iso lɑɑlɔ. Bɛɛbɛ mɔi jĩi lɑɑlɔ kɑɑ so iso jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ntɔ ntɔ jĩi fei hɑi si isoɛi ɑ̀ yɑ mɑ̀ɑ. A ci yɑ kɑ fiɡi si ɑɡũ, bɛɛbɛ mɔi ɑ ci yɑ kɑ rezɛ̃ɛ si ɑɡũ fũfũ, mɑ̀ irei. ");
INSERT INTO mkl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Amɑnɛ jiidɑ í yɑ nyɑ jiidɑ wɑi hɑi si mii jiidɑ iyi wɑ sinɡɑ si idɔɛ. Amɑnɛ lɑɑlɔ mɔ í yɑ nyɑ lɑɑlɔ wɑi hɑi si mii lɑɑlɔ iyi wɑ sinɡɑ si idɔɛ, domi mii iyi wɑ kɔ̃ si idɔi ɑmɑnɛ, nŋui ɡɛlɛɛ í yɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nɔ Jesu í sɔ̃ ŋɑ mɑ́ í ni, nɑ mii í ce ì yɑ mɑɑ kpem Lɑfɛ̃ɛ, Lɑfɛ̃ɛ, nɔ i ci yɑ ceò ide iyi ǹ sɔ̃ ŋɛ icɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Inɛ iyi í nɑɑ bi tom fei nɔ wɑ ɡbɔ idem nɔ wɑ jirimɑɛ, ɑn nyisi ŋɛ inɛ iyi lɑfɛ̃ɛ í jɔ. ");
INSERT INTO mkl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Í jɔ mɔkɔ ɡɔ iyi wɑ mɑ ile. Mɔkɔu í tu isɑ titɑ̃ í jĩ hee í koo í kɑ̃si kutɑ í bɛi í nyɔ icui ileu. Si ɑnyiɛ ŋɔi ijĩ í nɑ í rɔ nɔ ido í kɔ̃ wɑ nikɑ̃, wɑ cɑ̃ ileu, ɑmmɑ kù yɔkɔ ku kɛkɛɛ domi kumɑɛ í sĩɑ. ");
INSERT INTO mkl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ammɑ inɛ iyi í ɡbɔ idem nɔ kù wɑɑ jirimɑɛ, í yɛi bɛi mɔkɔ ɡɔ iyi í mɑ ile nɔ kù nyɔ icuɛ do kutɑ. Ŋɔi ido í nɑ í kɔ̃ í nikɑ̃ wɑ cɑ̃ ileu nɔ ɡbɑkɑ̃ í cuku í lɛɡɛ fei. ");
INSERT INTO mkl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iyi Jesu í sɔ̃ ŋɑ ideu fei í tɑ̃, ŋɔi í bɔ Kɑpɛrɑnumu. ");
INSERT INTO mkl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wee inɛ nɡboi sooɡe ɡɔ í wɑ bɛ. Sooɡeu í nɛ ɑmɑɑcɛɛ, nɔ í buui jiidɑ jiidɑ. Amɑɑcɛui wɑ ce bɔ̃ɔ hee wɑ bi ku ku. ");
INSERT INTO mkl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ŋɔi sooɡeu í ɡbɔ bɑɑui Jesu, nɔ í bɛ inɛ nɡboi Zuifu ɡɔ ŋɑ bi tɛɛ ɑ koo ɑ tɔɔɛ ku nɑ ku fɑɑbɑ ɑmɑɑcɛi nŋu. ");
INSERT INTO mkl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ŋɔi inɛ ŋɑu ɑ̀ koo. Iyi ɑ̀ to bi Jesu, ŋɔi ɑ̀ tɔɔɛ suuru ntɔ ntɔ ɑ̀ ni mɔkɔu í to i sobiɛ ");
INSERT INTO mkl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","domi í bi dimi nwɑ. Nŋui í nɔ í mɑ nwɑ ile bii ɑ̀ yɑ kɑ ce kutɔtɔɔu bɛ. ");
INSERT INTO mkl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nɔ ɑŋɑò Jesu ŋɑ ɑ̀ dɑsi kpɑ̃ɑ ɑ̀ wɑɑ nɛ. Iyi ɑ̀ mɑɑi kpɑsɛ̃u ŋɔi sooɡeu í bɛ kpɑɑsiɛ ɡɔ ŋɑ ɑ koo ɑ sɔ̃ɔ ɑ ni, Lɑfɛ̃ɛ, sooɡeu njɛ í ni i mɑɑ̀ tɑɑbi ɑrɑɛ, domi nŋu kù to i lɔ wɑ kpɑsɛ̃i nŋu. ");
INSERT INTO mkl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nɑ nŋui í ce mɔm í yɔɔ iyi nŋu kù to nŋu ku nɑɑ bi tɛɛ do ɑrɑɛ. Ammɑ í ni i fɔ ide nŋu ɑkɑ̃ wɑ, ɑmɑɑcɛi nŋu ɑ́ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nɔ í ni bɑɑ nŋu tɑkɑi nŋu, idei inɛ nɡboi nŋu ŋɑi nŋu wɑ ɡbɔ, nɔ nŋu mɔ í nɛ sooɡe ŋɑ iyi wɑ ɡbɑ̃. Bii nŋu í sɔ̃ inɛ ɑkɑ̃ nŋu í ni ku bɔ ihɔ̃, í yɑ kooi. Bii nŋu í nɔ í kpe inɛ ɡɔ nŋɑ í yɑ nɑɑi. Nɔ bii nŋu í sɔ̃ ɑmɑɑcɛi nŋu ɡɔ nŋu í ni ku ce iyi ihɛ̃ í yɑ cooi. ");
INSERT INTO mkl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iyi Jesu í ɡbɔ ideu í biti, nɔ í sindɑ í sɔ̃ zɑmɑɑ iyi wɑ tooɛu í ni, ǹ wɑ n sɔ̃ ŋɛ, bɑɑ si inɔi inɛi Izirɛli ŋɑ fei n kù yɛ inɛ iyi í yɔkɔ í dɑsim nɑɑnɛ nlɑ nlɑ bɛi inɛɛu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi ɑmɑ ɑbɛ ŋɑu ɑ̀ nyi kpɑsɛ̃, nɔ ɑ̀ bɑ ɑmɑɑcɛu í bɑ bɑɑni. ");
INSERT INTO mkl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Si ɑnyiɛ ŋɔi Jesu í bɔ ilu ɡɔ iyi ɑ̀ yɑ kpe Nɑyini. Mɔcɔɛ ŋɑ do zɑmɑɑ nlɑ ɡɔ wɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wɑɑti iyi í mɑɑi si ɡɑmboi bindii iluu, í yɛ ɑ̀ so ikui ɑmɑ ɑwɑɑsũ ɡɔ ɑ̀ wɑɑ bɔ ku suu. Amɑ ɑwɑɑsũu nŋu ɑkɑ̃i iyeɛ í bí nɔ iyeu jɑɑɔ̃i. Inɛi inɔ ilu nkpɔ nkpɔi wɑ too fitii ɑbou. ");
INSERT INTO mkl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Iyi Lɑfɛ̃ɛ í yɛ ɑbou ŋɔi ɑrɑɑre í muu, nɔ í sɔ̃ɔ í ni, mɑɑ̀ kpɑtɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ŋɔi í sɛkɛɛ si ŋɑ í lu kpɑkoi ikuu nɔ inɛ ŋɑ iyi ɑ̀ wɑɑ soou ɑ̀ leekĩ. Nɔ Jesu í ni, ɑwɔ ɑwɑɑsũ, ǹ wɑ n sɔ̃ɛ, dede. ");
INSERT INTO mkl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nɔ ɑwɑɑsũ iyi í kúu í dede í bubɑ wɑ fɔ ide. Nɔ Jesu í sindoɑ iyeɛ. ");
INSERT INTO mkl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ŋɔi njo í mu ɑŋɑ fei, nɔ ɑ̀ sɑɑbu Ilɑɑɔ̃ ɑ̀ wɑɑ ni, wɑlii ilu ɡbuɡbɑ̃i í nɑɑ si wɑ. Nɔ ɑ̀ wɑ ni mɑ́, Ilɑɑɔ̃ í nɑɑ bi inɛɛ ŋɑ ku bɑ ku sobi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ŋɔi ideu í fɑnɡɑɑ si ilɛi Zudee do si ilɛɛkoɛ ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ŋɔi mɔcɔi Zɑ̃ɑ ŋɑ ɑ̀ koo ɑ̀ bɑɑ ile piisɔ̃ɔ bɛ ɑ̀ sisiɑɑ mii ŋɑu bɛ fei. Nɔ í kpe ɑmɑnɛ minji si inɔ nŋɑ, ");
INSERT INTO mkl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","í bɛ ŋɑ bi Lɑfɛ̃ɛ ɑ beeɛ ɑ ni, ɑwɔi ì jɛ inɛ iyi Ilɑɑɔ̃ ɑ́ nɑ ku bɛ wɑu? Mɑ̀ kɑ deɡbe inɛ mmu ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Iyi ɑ̀ to wɑ bi Jesu, ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, Zɑ̃ɑ woo dɑsi inyiui í bɛ wɑ kɑ nɑɑ kɑ beeɛ kɑ ni, ɑwɔi ì jɛ inɛ iyi Ilɑɑɔ̃ ɑ́ nɑ ku bɛ wɑu? Mɑ̀ kɑ deɡbe inɛ mmu ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wee si wɑɑti nŋu bɛi, Jesu í jɔ̀ bɔ̃ɔ nkpɔ do kɔ̃̀ɔ ŋɑ ɑ̀ wɑɑ bɑ iri, nɔ wɑ lele inɛi inɔɔko ŋɑ hɑi si inɛ ɡɔ ŋɑ, nɔ í jɔ̀ fɛɛju nkpɔ í yɛ ilu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nɔ í jɛɑ ɑmɑ ɑbɛ ŋɑu í ni, i koo i sisiɑ Zɑ̃ɑ mii iyi ì yɛ do iyi ì ɡbɔ ŋɑ. Fɛɛju ŋɑ ɑ̀ wɑɑ yɛ ilu, woo sukutɛ ŋɑ ɑ̀ wɑɑ nɛ dee dee, dintɛ ŋɑ ɑ̀ bɑ iri ɑ̀ jɛ inɛ kumɑ́, dekĩ ŋɑ ɑ̀ wɑɑ ɡbɔ ide, iku ŋɑ ɑ̀ jĩ, nɔ ɑ̀ wɑɑ wɑɑzoɑ ilu ɑre ŋɑ lɑɑbɑɑu jiidɑu. ");
INSERT INTO mkl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ilu inɔ didɔ̃i inɛ iyi kɑɑ nyiò ɑnyi si nɑɑnɛ ku dɑsiɛ nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Iyi ɑmɑ ɑbɛi Zɑ̃ɑ ŋɑu ɑ̀ ɡbɔ bɛi Jesu í fɔ, ŋɔi ɑ̀ sindɑ ɑ̀ nɛ. Wɑɑti iyi ɑ̀ wɑɑ nɛ, ŋɔi Jesu í lɔsi ku sisiɑ zɑmɑɑu idei Zɑ̃ɑ í ni, mii ì bɔ ku cɔ ɡbɑbuɑu ŋɑ. Fɔfɔ iyi fufu wɑ yɑyɑ? Aɑwo. ");
INSERT INTO mkl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","To, mii ì bɔ ku cɔ ŋɑ. Mɑ̀ mɔkɔ iyi wɑ dɑsi jɑɑɛ jiidɑu? Aɑwo, inɛ ŋɑ iyi ɑ̀ wɑɑ dɑsi jɑɑɛi fiɑ nkpɔ nɔ ɑ̀ wɑ si inɔi ɑmɑni nlɑ nlɑ, ɑŋɑi ɑ̀ yɑ wɑ kɑbɑi ilɑɑlu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","To, mii ì bɔ ku cɔ ŋɑ. Mɑ̀ wɑliii ì bɔ ku cɔ ŋɑ. Oo, ntɔ ntɔ ɑn sɔ̃ ŋɛ, inɛɛu bɛ í re bɑɑ wɑlii. ");
INSERT INTO mkl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Zɑ̃ɑi kukɔi idei Ilɑɑɔ̃ wɑ fɑ̃ɑ tenɡi bii í ni, Ilɑɑɔ̃ í ni, Wee, ǹ bɛ woo sisi idem wɑ si wɑjuɛ iyi ɑ́ teeseɛ kpɑ̃ɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","An sɔ̃ ŋɛ, si inɔi inɛ ŋɑ iyi inɑɑbo ŋɑ ɑ̀ bí fei, kɑ̃mɑ nŋɑ kù wɛɛ iyi í re Zɑ̃ɑ. Ammɑ do nŋu fei, bɑɑ inɛ iyi í kere í re si bommɑi Ilɑɑɔ̃ í roo. ");
INSERT INTO mkl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nɔ Jesu í ni mɑ́, inɛ ŋɑ iyi ɑ̀ ɡbɔ idei Zɑ̃ɑ fei hee do woo ɡbɑ fiɑi lɛmpoo ŋɑ fei ɑ̀ jɔ̀ Zɑ̃ɑ í dɑsi ŋɑ inyi nɔ nŋu bɛ wɑ nyisi iyi ɑ̀ mɑ̀ iyi Ilɑɑɔ̃ í jɛ dee dee. ");
INSERT INTO mkl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ammɑ Fɑrisi ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ ɑ kù jɛ Zɑ̃ɑ ku dɑsi ŋɑ inyi. Bɛɛbɛ mɔi ɑ̀ kɔsi mii iyi Ilɑɑɔ̃ í dɑsi idɔ ku ce nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ŋɔi Jesu í ni, yooi ɑn wɑ̃ò inɛi nsɛi ŋɑu ihɛ̃. Yooi ɑ̀ jɔ. ");
INSERT INTO mkl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","À jɔ ɑmu ŋɑ iyi ɑ̀ wɑɑ bubɑ bɑntumɑ, ɑ̀ sɔ̃ njɛ ɑ̀ wɑɑ ni, ɑ̀ fɑ̃ nŋɛ yee nɔ i kù jojo ŋɑ, nɔ ɑ̀ kɔ̃ nŋɛ irii iku ŋɑ nɔ i kù kpɑtɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ǹ ni bɛɛbɛi si nɑ iyi í jɔ̀ wɑɑti iyi Zɑ̃ɑ woo dɑsi inyi í nɑɑ, í yɑ dĩ ɑnu, ci yɑ mɔ vɛ̃ɛ, nɔ ì ni í nɛ inɛi inɔɔko ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nɔ iyi ɑmu Amɑi Amɑnɛ ǹ nɑɑ, ǹ yɑ n jɛ nɔ n mɑɑ n mɔ, nɔ í ni ŋɑ ǹ bi ijɛ nɔ ǹ jɛ woo mɔ ɑtɛ̃ nɔ ǹ jɛ kpɑɑsii woo ɡbɑ fiɑi lɛmpoo ŋɑ do ilu dulum ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Do nŋu fei, ɑ̀ yɛ iyi bisii Ilɑɑɔ̃ í jɛ dee dee nɑ icɛ ŋɑ iyi wɑ ce. ");
INSERT INTO mkl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fɑrisi ɡɔ í kpe Jesu ku jɛ bi tɛɛ ɑjɔ nŋu ɡɔ. Nɔ Jesu í lɔ ileɛ í bubɑ wɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wee, ɑbo ɑ̀ tɑ icu ɡɔ í wɑ si iluu bɛ. Iyi í ɡbɔ ɑ̀ ni Jesu wɑ jɛ kpɑsɛ̃i Fɑrisiu, ŋɔi í nɑɑò tulɑre wɑ si ɑmɑ cɑkɑ ku sĩɑ ɡɔ iyi ɑ̀ ce do ɑbɑtii. ");
INSERT INTO mkl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Abou í nɑɑ í wɑi do ɑnyii Jesu bi isɛɛ ŋɑ. Wɑ kpɑtɑ nɔ cikɑ̃ɑjuɛ ŋɑ wɑ tontoo si isɛɛ hee í cɔɔ, nɔ wɑ ɡbɑ̃ɑ do ntoi iriɛ ŋɑ, wɑ cɔ̃ɔcɔ̃ɔɛ, í fɑ̃ siɛ tulɑreu. ");
INSERT INTO mkl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fɑrisi iyi í kpe Jesu ku jɛu, iyi í yɔɔ, ŋɔi í fɔ si idɔɛ í ni, mɔkɔu ihɛ̃, bii wɑliii, ɑ́ mɑ̀ dimii inɑɑbo iyi wɑ luu ihɛ̃ domi woo tɑ icui. ");
INSERT INTO mkl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nɔ Jesu í ni, Simɔɔ, ǹ nɛ ide ɡɔ iyi ɑn sɔ̃ɛ. Nɔ í ni, fɔ, Mɛɛtu. ");
INSERT INTO mkl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ŋɔi Jesu í ni, mɔkɔ ɡɔ í wɛɛ iyi ɑmɑnɛ minji wɑ mu ɡbeseɛ. Inɛ ɑkɑ̃ wɑ mu kpɛkɛlɛ cĩɔ miu, inɛ ɑkɑ̃ mɔ ciitɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nɔ wee ɑ kù nɛ mii iyi ɑɑ sɑ̃ɑò, nɔ í ceɑ ɑŋɑ minji fei suuru. To, si ɑŋɑ minjiu, yoo nŋɑi ɑ́ bi mɔkɔu ku re. ");
INSERT INTO mkl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nɔ Simɔɔ í jɛɑɑ í ni, ǹ tɑmɑɑ inɛ iyi ɡbeseɛ í reui. Ŋɔi Jesu í sɔ̃ɔ í ni, ntɔi ì fɔ. ");
INSERT INTO mkl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iyi í ni bɛɛbɛ í tɑ̃, ŋɔi í sindɑ si inɑɑbou nɔ í sɔ̃ Simɔɔ í ni, ì yɛ ɑbou ihɛ̃? Iyi ǹ lɔ wɑ kpɑsɛ̃ɛ i kù muum inyi n wiɛ kutɛm, ɑmmɑ ɑbou ihɛ̃ í cɔ̀ kutɛm do cikɑ̃ɑjuɛ ŋɑ, nɔ í ɡbɑ̃ɑ do ntoi iriɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","I kù cem fɔɔ do kucɔ̃ɔcɔ̃ɔ ɑmmɑ ɑbou ihɛ̃, hɑi wɑɑti iyi ǹ lɔ wɑ, kù jɔ̀ kutɛm ku cɔ̃ɔcɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nɔ i kù jɔsi irim ikpo, ɑmmɑ ɑbou ihɛ̃, í fɑ̃si isɛm tulɑre. ");
INSERT INTO mkl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nɑ ŋɔi í jɔ̀ ǹ wɑ n sɔ̃ɛ kubi nlɑi ɑbou ihɛ̃ wɑ nyisi iyi Ilɑɑɔ̃ í kpɑ idei dulum dɛɛ, bɑɑ do iyi í kpɔ fei. Ammɑ inɛ iyi ɑ̀ ceɑ suuru keeke, kubiɛ mɔ keekei. ");
INSERT INTO mkl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ŋɔi í sɔ̃ ɑbou í ni, ɑ̀ kpɑ idei dulum dɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Inɛ ŋɑ iyi ɑ̀ wɑɑ jɛ ɑŋɑò ŋɑu, ɑ̀ bee njɛ ide ɑ̀ wɑɑ ni, dimii ɑmɑnɛ yoomɑi ihɛ̃ iyi ɑ́ yɔkɔ ku kpɑ idei dulum dii ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nɔ Jesu í sɔ̃ ɑbou í ni, nɑɑnɛɛi í fɑɑbɑɛ. Koo nɛ do lɑɑkɑi ku sũ. ");
INSERT INTO mkl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Si ɑnyii nŋu, Jesu í dɑbii dɑbii si wɑnɡɑɑ ŋɑ do si ilɛɛko ŋɑ, wɑ wɑɑzo wɑ sisi lɑɑbɑɑu jiidɑi bommɑi Ilɑɑɔ̃. Nɔ mɔcɔ mɑɑteeji ŋɑu ɑ̀ suu ");
INSERT INTO mkl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","do inɑɑbo nkpɔ ɡɔ ŋɑ. Si inɔi inɑɑbo ŋɑu, ɡɔɡɔ ŋɑ ɑ̀ wɑɑ ce bɔ̃ɔ wo, ɡɔɡɔ ŋɑ mɔ ɑ̀ nɛ inɛi inɔɔko ŋɑ wo, nɔ Jesu í jɔ̀ ɑŋɑ fei ɑ̀ bɑ iri. Inɑɑbo ŋɑu wee. Mɑɑri iyi ɑ̀ yɑ kpe inɛi Mɑdɑlɑ, nŋui Jesu í leleɑ inɛi inɔɔko mɛɛje ŋɑu, ");
INSERT INTO mkl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","do Zoɑnɑ ɑboi Cuzɑ, woo mu ɑmɑnii ilɑɑlu Herodu, do Suzɑni do inɑɑbo nkpɔ ɡɔ ŋɑ mɑ. Abo ŋɑu ɑ̀ wɑɑ sobi ŋɑ do ɑmɑni nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hɑi ilu fei inɛ ŋɑ ɑ̀ wɑsi ku nɑɑ bi Jesu. Si bɛi zɑmɑɑ í tɔtɔɔ ŋɔi í kpɑ nŋɑ mɔndɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Si mɔndɑu í ni, mɔkɔ ɡɔ í fitɑ wɑ fɑ̃ dimi. Si bɛi wɑ fɑ̃ dimiu, ŋɔi ɡɔɡɔ ŋɑ ɑ̀ cuku si kpɑ̃ɑ, nɔ inɛ ŋɑ ɑ̀ nɛ̀ si nɔ yɛi ŋɑ ɑ̀ jɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nɔ ɡɔɡɔ ŋɑ mɔ ɑ̀ cuku si ilɛ iyi í nɛ kutɑ. Iyi í fitɑ ɡbɑkɑ̃, í ɡbɛi, domi mɑndi kù wɑ si. ");
INSERT INTO mkl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gɔɡɔ ŋɑ mɔ ɑ̀ cuku si inɔ ɑɡũ ŋɑ. Ŋɔi ɑɡũ ŋɑu do dimi jiidɑu ɑ̀ fitɑ ɑjɔ, ŋɔi ɑɡũ ŋɑu ɑ̀ dede ɑ̀ lɑ ɑ̀ bii dimi jiidɑu. ");
INSERT INTO mkl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gɔɡɔ ŋɑ mɔ ɑ̀ cuku si ilɛ jiidɑ, nɔ ɑ̀ fitɑ ɑ̀ lɑ ɑ̀ so iso cĩɔ cĩɔ. Iyi Jesu í fɔ bɛɛbɛ í tɑ̃, nɔ í lɑ hee lele í ni, inɛ iyi í nɛ itĩ iyi ɑ́ ɡbɔò ide, ku ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nɔ mɔcɔɛ ŋɑ ɑ̀ beeɛ yɑɑsei mɔndɑu. ");
INSERT INTO mkl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ŋɔi í jɛ nŋɑ í ni, iŋɛi Ilɑɑɔ̃ í jɔ̀ ì mɑ̀ ɑsiii bommɑɛ, ɑmmɑ inɛ ŋɑ iyi ɑ̀ ɡbe ɑ̀ wɑɑ sɔ̃ ŋɑi do mɔndɑ ŋɑ ku bɑ Bɑɑ bii ɑ̀ wɑɑ cɔ ɑ mɑɑ̀ yɔɔ. Nɔ bii ɑ̀ wɑɑ ɡbɔ ɑ kɑɑ mɑ̀ yɑɑseɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yɑɑsei mɔndɑu wee. Dimiu, idei Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Inɛ ɡɔ ŋɑ ɑ̀ yɛi bɛi kpɑ̃ɑ tenɡi bii dimiu í cuku. Aŋɑi ɑ̀ ɡbɔ ideu, ɑmmɑ Seetɑm í nɑɑ í nyɑɑ hɑi si idɔ nŋɑ ku bɑ ɑ mɑɑ̀ dɑsi nɑɑnɛ ɑ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɛi bɛi ilɛ kutɑ. Aŋɑi ɑ̀ ɡbɔ ideu nɔ ɑ̀ ɡbɑɑ do inɔ didɔ̃. Ammɑ ɑ kù jɔ̀ kù ce icɑ̃ si idɔ nŋɑ. Nɑɑnɛ ku dɑsi nŋɑ í kpɛ keeke ɑmmɑ iyi wɑhɑlɑ í nɑɑ, ɑ̀ nyiò ɑnyi. ");
INSERT INTO mkl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɛi bɛi inyɑ iyi í nɛ ɑɡũ ŋɑu. Aŋɑi ɑ̀ ɡbɔ ideu, ɑmmɑ si bɛi ɑ̀ wɑɑ nɛ, inɔ ku fɔ do ɑmɑni do didɔ̃i ɑndunyɑ ŋɑi ɑ̀ bii ideu ɑ̀ kpɑɑ, nɔ iso nŋɑ ŋɑ kù jĩɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɛi bɛi ilɛ jiidɑu. Aŋɑi ɑ̀ ɡbɔ ideu nɔ ɑ̀ jilɔɔ si idɔ jiidɑ hɑi nɛ muɑfiti, nɔ ɑ̀ wɑɑ temuɑ hee wɑ so iso. ");
INSERT INTO mkl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ í ni, inɛ ɡɔ ci yɑ mɑ fitilɑ ku biiɛ do cɑkɑ, wɑlɑkɔ ku dɑsi ɑbɛ dɑɑi. Ammɑ ɑ̀ yɑ kɔɑɛi lele ku bɑ inɛ ŋɑ iyi ɑ̀ wɑɑ lɔ wɑ fei ɑ yɛ inyɑ kumɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Si bɛɛbɛ mii iyi wɑ mɑnji fei ɑ́ boli, nɔ mii iyi ɑ̀ ce si ɑsii fei ɑ́ nɑ ku fitɑ ɡbuɡbɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nɑ nŋu, i ce lɑɑkɑi ŋɑ do yɑɑse bɛi ì wɑɑ ɡbɔò ide ŋɑ, domi inɛ iyi í nɛ, nŋui ɑ̀ yɑ kɔ̃ɔɑ si. Inɛ mɔ iyi kù nɛ, ɑndi iyi wɑ tɑmɑɑ siu mɑ́ ɑ̀ yɑ ɡbɑɑi. ");
INSERT INTO mkl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iyei Jesu do ifɔɛ ŋɑ ɑ̀ nɑɑ bi tɛɛ, ɑmmɑ ɑ kù bɑ ɑ kù to siɛ nɑ zɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nɔ inɛ ŋɑ ɑ̀ sɔ̃ɔ ɑ̀ ni, iyeɛ do ifɔɛ ŋɑ ɑ̀ wɑɑ leekĩ wɑduude ɑ̀ wɑɑ bi ku yɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ammɑ í jɛ nŋɑ í ni, inɛ ŋɑ iyi ɑ̀ wɑɑ ɡbɔ idei Ilɑɑɔ̃ nɔ ɑ̀ wɑɑ jirimɑɛ, ɑŋɑi ɑ̀ jɛ iyem wɑlɑkɔ ifɔm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ajɔ nŋu ɡɔ Jesu í lɔ ɑkɔi inyi nŋu do mɔcɔɛ ŋɑ, nɔ í sɔ̃ ŋɑ í ni, kɑ kuɑ tenkuu kɑ bɔ ice ikpɑ ihɔ̃. Nɔ ɑ̀ nɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Si bɛi ɑ̀ wɑɑ nɛu, Jesu í sĩ njoo. Ŋɔi fufu nlɑ ɡɔ í dede si tenkuu, nɔ inyi wɑ kɔ̃ ɑkɔu. À wɑ si mbirisi. ");
INSERT INTO mkl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ŋɔi ɑ̀ sɛkɛɛ si Jesu ɑ̀ jũu ɑ̀ ni, Mɛɛtu, Mɛɛtu, ɑ̀ wɑɑ bɔ nfe ku ce. Ŋɔi Jesu í jĩ nɔ í lɑ si fufuu do kucɑ̃i inyiu. Nɔ ɑ̀ dɛ̀ ɑ̀ coko sɔ̃m sɔ̃m. ");
INSERT INTO mkl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nɔ í bee mɔcɔɛ ŋɑ í ni, hee iwoi nɑɑnɛ iyi ì dɑsim í wɑ. Nɔ njo í mu ŋɑ ɑ̀ biti, ɑ̀ bee njɛ ɑ̀ wɑɑ ni, dimii ɑmɑnɛ yoomɑi ihɛ̃, iyi wɑ bɑ fufu do inyi ide ku fɔ nɔ ɑ̀ wɑɑ ɡbɔ ideɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nɔ Jesu do mɔcɔɛ ŋɑu ɑ̀ to ice ikpɑ ihɔ̃, si ilɛi inɛi Zerɑzee ŋɑ iyi í wɑ do wɑjui ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Ŋɔi ɑ̀ fitɑ hɑi inɔi ɑkɔi inyiu. Iyi ɑ̀ kitɑ ilɛ ŋɔi Jesu í yɛ mɔkɔ ɡɔ wɑ nɑɑ ku kòo. Mɔkɔu inɛi ilu bɛi. Wee í bɛi í nɛ inɛi inɔɔko ŋɑ. Wɑɑti kɑ̃mɑ fei ɑ̀ yɑ mɑɑ dede siɛi. Ŋɔi inɛ ŋɑ ɑ̀ yɑ dũu do sesee nɔ ɑ̀ dĩ isɛɛu do isɔ ku bɑ ɑ nɔɔ. Ammɑ í yɑ dɑ kudĩ ŋɑui fei nɔ inɛi inɔɔkoɛ ŋɑu ɑ̀ bɔòɛ hee si ɡbɑbuɑ ŋɑ. Hɑi kukpɛ bɑsĩi í yɑ mɑɑ wɛɛ, ci yɑ bubɑ kpɑsɛ̃. Bi ku si iku ŋɑi í yɑ wɑ. Iyi mɔkɔu í yɛ Jesu ŋɔi í koo í cuku si wɑjuɛ í dɔ̃ ɑnu hee lele wɑ ni, mii í wɑ ɑninii ɑwɑɛ, Jesu ɑwɔ Amɑi Ilɑɑɔ̃. Ilɑɑɔ̃ í re fei nɔ ǹ wɑ n tɔɔɛi, mɑɑ̀ wɑhɑlɑm. Wɑ dɔ̃ bɛɛbɛi si nɑ iyi í jɔ̀ Jesu í ni inɛi inɔɔko ŋɑu ɑ fitɑ siɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nɔ Jesu í beeɛ í ni, irei iriɛ. Nɔ í jɛɑɑ í ni, Zɑmɑɑ. Í ni bɛɛbɛi si nɑ iyi í jɔ̀ inɛi inɔɔko nkpɔ nkpɔi í nɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nɔ inɛi inɔɔkoɛ ŋɑu ɑ̀ wɑɑ tɔɔ Jesu suuru ntɔ ntɔ ku mɑɑ̀ dɑsi ɑŋɑ si isɑ nlɑ hɑi nɛ kɔɔu. ");
INSERT INTO mkl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wee, kuusɔɔ ɡɑɑ nlɑ ɡɔ ŋɑ ɑ̀ wɑ bɛ ɑ̀ wɑɑ jɛ si iri kutɑ ɡɔ. Nɔ inɛi inɔɔko ŋɑu ɑ̀ tɔɔ Jesu ku jɔ̀ ɑŋɑ ɑ koo ɑ mu kuusɔɔ ŋɑu ku bɑ ɑŋɑ ɑ mɑɑ wɑ bɛ. Nɔ í yɔɔdɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nɔ inɛi inɔɔko ŋɑu ɑ̀ fitɑ hɑi si mɔkɔu, ɑ̀ koo ɑ̀ mu kuusɔɔ ŋɑu. Nɔ kuusɔɔ ɡɑɑ ŋɑu ɑ̀ sɛi hɑi ɑntɑi iri kutɑu ɑ̀ dɑsi tenku nɔ inyiu í jɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ŋɔi woo deɡbe kuusɔɔ ŋɑu ɑ̀ yɛ mii iyi í ce, nɔ ɑ̀ sɑ ɑ̀ koo ɑ̀ wɑɑ sisi lɑɑbɑɑui ideu si ilu nlɑu do si ilɛɛko ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nɔ inɛ ŋɑ ɑ̀ fitɑ ɑ̀ bɔ̀ ku cɔ mii iyi í ceu. Iyi ɑ̀ to bi Jesu, ŋɔi ɑ̀ yɛ mɔkɔ iyi inɛi inɔɔko ŋɑ ɑ̀ fitɑ siɛu. Mɔkɔu í bɑɑ si lɑɑkɑɛ mɑ́, nɔ wɑ bubɑ kɔkɔi Jesu í dɑsi jĩnɛ ŋɑ. Ŋɔi njo í mu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Inɛ ŋɑ iyi ideu í ce iju nŋɑ ɑ̀ wɑɑ sisiɑ inɛ ŋɑ bɛi inɛɛu í ce í bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ŋɔi inɛi ilɛi Zerɑzee ŋɑ fei ɑ̀ tɔɔ Jesu suuru ɑ̀ ni ku nɛ hɑi bɛ, domi njo í mu ŋɑ ntɔ ntɔ. Nɔ Jesu í lɔ ɑkɔi inyiu wɑ bi ku nɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ŋɔi mɔkɔ iyi inɛi inɔɔko ŋɑ ɑ̀ fitɑ siɛu wɑ tɔɔ Jesu ku jɔ̀ nŋu ku tooɛ. Ammɑ Jesu í ni ku sindɑ ku ");
INSERT INTO mkl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","nyi ideɛ, koo sisi mii iyi Ilɑɑɔ̃ í ceɑɑ fei. Nɔ inɛɛu í nɛ í koo í wɑsi ku sisi mii iyi Jesu í ceɑ nŋu fei si iluu fei. ");
INSERT INTO mkl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iyi Jesu í bɑɑ hɑi ilɛi Zerɑzee nɔ zɑmɑɑ í wɑsi ku coo fɔɔ, domi ɑŋɑ fei ɑ̀ wɑɑ deɡbeɛi. ");
INSERT INTO mkl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ŋɔi inɛ ɡɔ í nɑɑ bi tɛɛ. Lɑfɛ̃ɛi ɑ̀ yɑ kpe Zɑirusi. Inɛ nɡboi ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔi. Iyi í yɛ Jesu, ŋɔi í sɛɛbɑtɑ si wɑjuɛ nɔ í tɔɔɛ ku nɑɑ kpɑsɛ̃i nŋu. ");
INSERT INTO mkl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Wɑ tɔɔ Jesu ku nɑɑ kpɑsɛ̃ɛi si nɑ iyi í jɔ̀ ɑmɑ inɑɑbo ɑkɑ̃ leɡe leɡeɛ iyi í nɛ ɑdɔ̃ mɑɑteeji, wɑ bi ku ku. Ŋɔi Jesu wɑ koo. Iyi wɑ koo, nɔ zɑmɑɑ nlɑ nlɑ wɑ mɑnteɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wee ɑbo ɡɔ mɔ í wɑ bɛ iyi wɑ ce bɔ̃ɔi ɑwɔ ku mu hɑi ɑdɔ̃ mɑɑteeji. Nɔ í jɛ fiɑɛ fei bi lokotoro ŋɑ, nɔ kɑ̃mɑ nŋɑ kù yɔkɔ kù fɑɑbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ŋɔi í sɛkɛɛ si Jesu do ɑnyi í koo í lu itĩi ibɔɛ. Bɛ ɡbɑkɑ̃ bɔ̃ɔu í tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nɔ Jesu í bee í ni, yooi í lum. Ŋɔi ɑŋɑ fei ɑ̀ wɑɑ jɑ̃, ŋɔi Piɛɛ í ni, Mɛɛtu, zɑmɑɑui í kɑɑkoɛ wɑ mɑnteɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ammɑ Jesu í ni, ǹ mɑ̀ iyi inɛ ɡɔ í lum kɑm kɑm si nɑ iyi í jɔ̀ ɡbuɡbɑ̃m í ce icɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iyi ɑbou í yɛ iyi Jesu í mɑ̀ iyi inɛ ɡɔ í luu, ŋɔi í koo í ɡulɛ si wɑjuɛ do kuyɑyɑ. Nɔ í fɔ si wɑjui zɑmɑɑu mii iyi í ce í jɔ̀ nŋu í lu Jesu, do bɛi nŋu í bɑ iri ɑnu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nɔ Jesu í sɔ̃ɔ í ni, ɑbooyi, nɑɑnɛɛi í fɑɑbɑɛ, koo nɛ do lɑɑkɑi ku sũ. ");
INSERT INTO mkl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Si bɛi Jesu wɑ fɔ ideu ŋɔi inɛ ɡɔ í nɑɑ hɑi kpɑsɛ̃i Zɑirusi inɛ nɡbou í sɔ̃ɔ í ni, ɑmɑ inɑɑboɛu kù wɛɛ, mɑɑ̀ bitɑndi Mɛɛtu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iyi Jesu í ɡbɔ ideu nɔ í sɔ̃ Zɑirusi í ni, mɑɑ̀ jɔ̀ ziɡiɛ ku dɑ, ɑwɔ de dɑsi nɑɑnɛ, ɑ́ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Ŋɔi ɑ̀ dɑsi kpɑ̃ɑ mɑ́ ɑ̀ wɑɑ koo. Iyi í to kpɑsɛ̃ bɛ, í bɑ wee, inɛ fei í wɑsi ku kpɑtɑ ɑ̀ wɑɑ cɑ̃ kpokpo nɑ irii ɑmɑu. Nɔ Jesu í ni, i mɑɑ̀ kpɑtɑ ŋɑ, kù ku, wɑ sĩ njooi. Ŋɔi ɑ̀ wɑɑ yɑɑkoɛ domi ɑ̀ mɑ̀ iyi í kui. Ŋɔi Jesu kù jɛ inɛ ɡɔ ku lɔ kpɑsɛ̃u do nŋu ɑjɔ bii kù jɛ Piɛɛ do Zɑ̃ɑ do Zɑɑki do iyeò bɑɑi ɑmɑu. ");
INSERT INTO mkl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iyi í to bi ɑmɑ inɑɑbou ŋɔi í mu ɑwɔɛ nɔ í fɔ ide hee lele í ni, ɑmɑ mudɛ̃ɛ, dede. ");
INSERT INTO mkl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nɔ hundeɛ í bɑɑ mɑ́, nɔ í dede tenɡi bɛ ɡbɑkɑ̃. Nɔ Jesu í sɔ̃ ŋɑ í ni ɑ nɑ ɑmɑu ijɛ. ");
INSERT INTO mkl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nɔ nyɑɑnzeɛ ŋɑu ɑ̀ biti ntɔ ntɔ, ɑmmɑ Jesu í sɔ̃ ŋɑ í ni ɑ mɑɑ̀ sɔ̃ inɛ ɡɔ mii iyi í ce. ");
INSERT INTO mkl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesu í kpe mɔcɔ mɑɑteejiɛ ŋɑu í tɔtɔɔ ŋɑ í mu nŋɑ ɡbuɡbɑ̃ do yiiko ɑ leleò inɛi inɔɔko ŋɑ fei nɔ ɑ jɔ̀ bɔ̃ɔ ŋɑ ɑ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ŋɔi í bɛ ŋɑ ɑ koo ɑ wɑɑzo idei bommɑi Ilɑɑɔ̃ nɔ ɑ jɔ̀ bɔ̃ɔ ŋɑ ɑ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nɔ í sɔ̃ ŋɑ í ni, i mɑɑ̀ so nkɑ̃mɑ si isɛɛnɛ nŋɛu, bɑɑ ɡolo hee mɑ́ jɛ bɔɡɔ, wɑlɑ ijɛ, wɑlɑ fiɑ, nɔ i mɑɑ̀ so bɑɑ ibɔ minjisiɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kpɑsɛ̃ bii ì sɔ ŋɑ, i yɑ wɑ bɛ hee i koo i fitɑ hɑi ilu bɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ilu bii ɑ̀ kɔ ku ɡbɑ ŋɛ, i fitɑ hɑi ilu bɛ ŋɑ nɔ i ɡbuɡbɑ̃ nŋɑ irurui bɑɑtɑ nŋɛ ŋɑ ku jɛ nŋɑ sɛɛdɑ iyi kiitii Ilɑɑɔ̃ ɑ́ nɑɑ si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mɔcɔ ŋɑu ɑ̀ dede ɑ̀ dɑbii si ilɛɛko ŋɑu, ɑ̀ wɑɑ sisiò lɑɑbɑɑu jiidɑu nɔ ɑ̀ wɑsi ku jɔ̀ bɔ̃ɔ ŋɑ ɑ̀ wɑɑ bɑ iri bii fei. ");
INSERT INTO mkl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wee Herodu ilu ilɛu, í ɡbɔ mii iyi Jesu wɑ ce fei, nɔ lɑɑkɑiɛ í dede. Kù mɑ̀ bɑɑ bɛi ɑ́ lɑsɑbu mɑ́ si nɑ iyi í jɔ̀ inɛ ɡɔ ŋɑ ɑ̀ wɑɑ ni Zɑ̃ɑi í jĩ hɑi si bɑlɛ, ");
INSERT INTO mkl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","inɛ ɡɔ ŋɑ mɔ ɑ̀ ni Elii wɑlii nlɑui í nɑɑ mɑ́, nɔ inɛ ɡɔ ŋɑ mɔ ɑ̀ ni inɛ ɑkɑ̃i wɑliii tɑko ŋɑui í jĩ hɑi si bɑlɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nɔ Herodu í ni, ǹ jɔ̀ ɑ̀ bu irii Zɑ̃ɑ. Debɛi, inɛ ihɛ̃ iyi ǹ yɑ mɑɑ n ɡbɔ bɑɑuɛ iyi wɑ ce dimii mii ŋɑu bɛ, yooi. Ŋɔi wɑ dɛ ku yɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nɔ mɔcɔ mɑɑteeji ŋɑ iyi Jesu í tɑko í bɛ ŋɑu ɑ̀ bɑɑ bi tɛɛ ɑ̀ wɑɑ sisiɑɑ mii ŋɑ iyi ɑŋɑ ɑ̀ ce fei. Nɔ Jesu í ɡbɑ̃ ŋɑ ikɑ̃ í bɔò ŋɑ ikpɑ kɔkɔi ilu ɡɔ iyi ɑ̀ yɑ kpe Bɛsɑidɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ŋɔi inɛ ŋɑ ɑ̀ ɡbɔ ikpɑ bii ɑ̀ wɑ nɔ zɑmɑɑ nkpɔ ɡɔ í hɑ̃mɛɛ ŋɑ bɛ. Nɔ Jesu í ɡbɑ ŋɑ wɑ sɔ̃ ŋɑ idei bommɑi Ilɑɑɔ̃, nɔ í jɔ̀ inɛ ŋɑ iyi ɑ kù wɑɑ nɛ bɑɑni ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iyi inunu wɑ lɔ ŋɔi woo bɛ mɑɑteeji ŋɑu ɑ̀ sɛkɛɛ siɛ ɑ̀ sɔ̃ɔ ɑ̀ ni, jɔ̀ inɛ ŋɑu ɑ̀ nɛ inɔ ilu wɑlɑkɔ ilɛɛko ŋɑ ɑ̀ dɛ bii ɑɑ sũ do mii iyi ɑɑ jɛ, domi si ɡbɑbuɑi ɑ̀ wɑ ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, iŋɛ tɑkɑ nŋɛ i nɑ ŋɑ ijɛ ɑ jɛ mɛɛ. Ammɑ ɑ̀ ni, pɛ̃ɛ iyi ɑ̀ nɛ kù re ɑrɑ miu do cɛ̃ɛ minji. Mɑ̀ ì bi ɑwɑ tɑkɑ nwɑ kɑɑ rɑ ijɛ iyi inɛ fei ɑ́ jɛi. ");
INSERT INTO mkl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wee si inɔi inɛ ŋɑu inɛmɔkɔ ŋɑ ɑ̀ to zɑkɑi ɑmɑnɛ dubu miu (5.000). Ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑu í ni, i jɔ̀ ɑ bubɑ wuɑ ikɑ̃ ikɑ̃ ɑmɑnɛ ciitɑɑ ciitɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nɔ ɑ̀ ce bɛɛbɛ ɑ̀ jɔ̀ ɑŋɑ fei ɑ̀ bubɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ŋɔi Jesu í so pɛ̃ɛ miu do cɛ̃ɛ minjiu nɔ í wu iju lele í sɑɑbu Ilɑɑɔ̃ nɔ í bububuɛ í nɑ mɔcɔɛ ŋɑu ɑ kpɛ̃ɑ zɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nɔ ɑŋɑ fei ɑ̀ jɛ ɑ̀ yo. Nɔ ɑ̀ ko iyi ɑ̀ jɛ í ɡbeu, nɔ í kɔ̃ kɔlɔ mɑɑteeji. ");
INSERT INTO mkl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ajɔ nŋu ɡɔ Jesu do mɔcɔɛ ŋɑ ɑ̀ nyɑ ɑrɑ nŋɑ ikɑ̃ nɔ wɑ ce kutɔɔ. Nɔ í bee ŋɑ í ni, yooi inɛ ŋɑ ɑ̀ yɑ ni ǹ jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nɔ ɑ̀ jɛɑɑ ɑ̀ ni, inɛ ɡɔ ŋɑ ɑ̀ yɑ ni ɑwɔu Zɑ̃ɑ woo dɑsi inyii. Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɑ ni ɑwɔu Elii wɑlii nlɑi tɑkoui. Inɛ ɡɔ ŋɑ mɔ ɑ̀ yɑ ni ɑwɔu inɛ ɑkɑ̃i wɑliii tɑko ŋɑui í jĩ wɑ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ŋɔi í bee ŋɑ í ni, iŋɛ mɔ ni, yooi ì ni ǹ jɛ ŋɑ. Ŋɔi Piɛɛ í ni, ɑwɔi ì jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ŋɔi Jesu í sɔ̃ mɔcɔ ŋɑu do kuɡɑɑbu í ni ɑ mɑɑ̀ nɑ ɑ sɔ̃ inɛ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Í sɔ̃ ŋɑ mɑ́ í ni, ɑmu Amɑi Amɑnɛ, kù nɛ bɛi ɑ́ ce iyi n kù yɛ ijuukpɑ̃ ntɔ ntɔ. Inɛ nɡbo ŋɑ do inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ ɑɑ kɔsim ɑ kpɑm, ɑmmɑ ɑn jĩ hɑi si bɑlɛ si ɑjɔ mɛɛtɑsiɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nɔ í sɔ̃ ɑŋɑ fei í ni, inɛ iyi wɑ bi ku toom, ku jɔ̀ idɔɔbiɛ nɔ ku so jĩi ku ɡɑɑuɛ ku toom wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nɔ inɛ iyi wɑ bi ku bɑ kuwɛɛɛ do idɔɔbiɛ kɑɑ bɑɑ. Ammɑ inɛ iyi í nyɔ kuwɛɛɛ nɑ irim, lɑfɛ̃ɛi ɑ́ bɑɑ do ntɔ. ");
INSERT INTO mkl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Arɑnfɑ̃ɑni yoomɑi ɑmɑnɛ í nɛ bii í bɑ ɑmɑnii ɑndunyɑ fei, nɔ í kuɑ kuwɛɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nɔ í ni mɑ́, inɛ iyi wɑ ce ɑnyɔi ɑmu Amɑi Amɑnɛ, wɑlɑkɔ wɑ ce ɑnyɔi idem, ɑmu mɔ ɑn ce ɑnyɔi lɑfɛ̃ɛ wɑɑti iyi ɑn nyi wɑ. Nɔ wɑɑti iyi ɑn nyi wɑ, ɑn nyi wɑi do ɑmboei Bɑɑm do ɑmɑlekɑɛ ŋɑ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ntɔ ntɔ, inɛ ŋɑ iyi ɑ̀ wɑ ihɛ̃ si nsɛi, ɡɔɡɔ nŋɑ ŋɑ ɑɑ yɛ bommɑi Ilɑɑɔ̃ wɑ nɑɑ ɑ bɛi ɑ ku. ");
INSERT INTO mkl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iyi Jesu í fɔ ideu í tɑ̃, iyi í ce zɑkɑi ɑjɔ mɛɛjɔ ŋɔi í kpe Piɛɛ do Zɑ̃ɑ do Zɑɑki ɑ̀ koo ɑ̀ ɡũ ɑntɑi iri kutɑ nlɑ ɡɔ ku bɑ ku ce kutɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iyi wɑ ce kutɔɔ ŋɔi wɑjuɛ í kpɑɑsi dimi ikɑ̃, nɔ jɑɑɛɛ í fũutɑ pɑi pɑi. ");
INSERT INTO mkl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ŋɔi ɡbɑkɑ̃ Moizi do Elii ɑ̀ fɑɑtɑ wɑ do ɑmboe ɑ̀ wɑɑ bɑɑ ide ku fɔ. À wɑɑ fɔ idei ikuɛ iyi ɑ́ kú Zeruzɑlɛmu ku jɔ̀ò ɑndunyɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wee Piɛɛ do kpɑɑsiɛ ŋɑ ɑ̀ wɑɑ siiko ntɔ ntɔ, ɑmmɑ iyi iju nŋɑ í mɑ́ ɑ̀ yɛ ɑmboei Jesu nɔ ɑ̀ yɛ ɑmɑnɛ minji ŋɑ iyi ɑ̀ wɑɑ leekĩ bi tɛɛu. ");
INSERT INTO mkl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wɑɑti iyi inɛ ŋɑu ɑ̀ wɑɑ jɔ̀ Jesu, Piɛɛ í sɔ̃ɔ í ni, Mɛɛtu, ɑ́ sĩɑ kɑ mɑɑ wɑ ihɛ̃. Jɔ̀ kɑ ce ilei ɑcɔ mɛɛtɑ, ɑkɑ̃ titɛɛ, ɑkɑ̃ mɔ ti Moizi, ɑkɑ̃ mɔ ti Elii. Í ni bɛɛbɛi si nɑ iyi í jɔ̀ kù mɑ̀ mii iyi wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Si bɛi wɑ fɔ ideu, bukɔɔ í nɑɑ í bii ŋɑ. Iyi mɔcɔ ŋɑu ɑ̀ yɛ bukɔɔu wɑ bii ŋɑ ŋɔi njo í mu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nɔ ɑ̀ ɡbɔ ide ku fɔ ɡɔ hɑi si bukɔɔu í ni, inɛ ihɛ̃i í jɛ Amɑm. Nŋui ǹ cicɑ. I yɑ ɡbɔ ideɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Si ɑnyii ide ku fɔu, Jesu nŋu ɑkɑ̃i ɑ̀ yɛ bɛ. Ŋɔi si wɑɑtiu bɛ mɔcɔ ŋɑu ɑ coko ɑ kù sɔ̃ inɛ kɑ̃mɑ mii iyi ɑ̀ yɛ. ");
INSERT INTO mkl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Iju kumɑ́ɛ iyi ɑ̀ kitɑ wɑ hɑi ɑntɑi iri kutɑu, zɑmɑɑ nlɑ ɡɔ í nɑɑ í ko Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ŋɔi si inɔi zɑmɑɑu mɔkɔ ɡɔ í dɔ̃ ɑnu hee lele í ni, Mɛɛtu, cɔ ɑmɑ inɛmɔkɔ ɑkɑ̃u ihɛ̃i ǹ nɛ. Ǹ wɑ n tɔɔɛ i fɑɑbɑɛ ");
INSERT INTO mkl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","domi inɛi inɔɔko ɡɔ í yɑ dede siɛi. Nɔ wɑɑti iyi í dede fei, ɑnu ɑkɑ̃ ɑmɑu í yɑ dɔ̃ ɑnui. Nɔ inɛi inɔɔkou í yɑ ɡbuɡbɑ̃ɛ jiidɑ, nɔ ɑmɑu í yɑ mɑɑ ce ɑntɔ foko ku mɑɑ mɛɛ ɑrɑɛ, nɔ kufitɑɛ í yɑ ɡɑɑbu. ");
INSERT INTO mkl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ǹ tɔɔ mɔcɔɛ ŋɑ ɑ leleɑ, ɑmmɑ ɑ̀ mɔnɡɔ. ");
INSERT INTO mkl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ŋɔi Jesu í ni, iŋɛ inɛ lɑɑlɔ hɑi dɑsi nɑɑnɛ ŋɑ, hee wɑɑti yoomɑi ɑn wɑ inɔ nŋɛ. Mɑ̀ hee wɑɑti yoomɑi ɑn mɑɑ temuɑò ŋɛ. Ŋɔi í sɔ̃ mɔkɔu í ni, nɑɑò ɑmɑɛu wɑ ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nɔ wɑ nɑɑɛ wɑ. Iyi í toɛ wɑ kɔkɔi Jesu ŋɔi inɛi inɔɔkou í kɛkɛɛ ilɛ í ɡbuɡbɑ̃ɛ jiidɑ. Ammɑ Jesu í fɔ si inɛi inɔɔkou ide do ɡbuɡbɑ̃ ŋɔi í fitɑ nɔ ɑmɑu í bɑ iri. Nɔ Jesu í sindoɑ bɑɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Inɛ ŋɑ iyi ɑ̀ wɑ bɛ fei ɑ̀ biti do bɛi ɡbuɡbɑ̃i Ilɑɑɔ̃ í lɑ í to. Si bɛi ɑŋɑ fei ɑ̀ wɛɛò bitiu bɛɛbɛ do mii iyi Jesu wɑ ce fei, ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","iŋɛ, i de itĩ i ɡbɔ ide iyi ǹ wɑ n sɔ̃ ŋɛu ihɛ̃ sɑ̃ɑ sɑ̃ɑ ŋɑ. Aɑ mu ɑmu Amɑi Amɑnɛ ɑ dɑɑ inɛ ŋɑ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ammɑ mɔcɔɛ ŋɑu ɑ kù ɡbɔ yɑɑsei ideu, domi ideu kù mɑ́ nŋɑ titɑ̃, nŋui í jɔ̀ ɑ kù ɡbɔ yɑɑseɛ. Nɔ wee ɑ̀ wɑɑ ce njoi yɑɑsei ideu ku bee Jesu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ajɔ nŋu ɡɔ mɔcɔ ŋɑu ɑ̀ wɑɑ ce kɑkɔɔ ku bɑ ɑ mɑ̀ inɛ iyi í re si inɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Wee Jesu í mɑ̀ lɑsɑbui idɔ nŋɑ, ŋɔi í so ɑmɑ keeke ɡɔ í leekĩɛ kɔkɔɛ, ");
INSERT INTO mkl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nɔ í sɔ̃ ŋɑ í ni, inɛ iyi í ɡbɑ ɑmɑu ihɛ̃ nɑ irim, ɑmu tɑkɑm nii í ɡbɑ. Inɛ mɔ iyi í nɔ í ɡbɑm, inɛ iyi í bɛm wɑi í ɡbɑ. Inɛ iyi í kere í re si inɔ nŋɛ, nŋui í re iŋɛ fei. ");
INSERT INTO mkl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ŋɔi Zɑ̃ɑ í ni, Mɛɛtu, ɑ̀ yɛ inɛ ɡɔ í yɑ mɑɑ lele inɛi inɔɔko ŋɑ do iriɛ, nɔ ɑ̀ ɡɑnjiɛ, domi kù wɑ inɔ nwɑ, kù wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ŋɔi Jesu í sɔ̃ɔ í ni, i mɑɑ̀ ɡɑnjiɑ ŋɑ, domi inɛ iyi kù jɛ mbɛɛ nŋɛ, inɛ nŋɛi. ");
INSERT INTO mkl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wee wɑɑti í mɑɑi wɑ si bii Jesu ɑ́ jɔ̀ ɑndunyɑ ku nyi lele mɑ́, ŋɔi í dɑsi idɔ mɑm mɑm nŋu ku bɔ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nɔ í bɛ inɛ ɡɔ ŋɑ ɑ cuɑɑ ku bɑ ɑ koo ɑ ceɑɑ sɔɔlui bi ku sũ. Ŋɔi inɛ ŋɑ iyi í bɛ ŋɑu ɑ̀ to ilui Sɑmɑri ɡɔ, ");
INSERT INTO mkl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ɑmmɑ inɛi ilu bɛ ŋɑ ɑ kù jɛ ku ɡbɑɑ si nɑ iyi í jɔ̀ Zeruzɑlɛmuui wɑ bɔ. ");
INSERT INTO mkl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iyi Zɑɑki do Zɑ̃ɑ ɑ̀ ɡbɔ bɛɛbɛ, ŋɔi ɑ̀ beeɛ ɑ̀ ni, Lɑfɛ̃ɛ, ì bi kɑ jɔ̀ inɑ ku kitɑ si ŋɑ wɑ hɑi lele ku kpɑ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ammɑ Jesu í sindɑ í lɑ si ŋɑ do ɡbuɡbɑ̃. Í ni, i kù mɑ̀ iyi ì wɑɑ fɔ ŋɑ mɔm. ");
INSERT INTO mkl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Amu Amɑi Amɑnɛ n kù nɑɑ ku kpɑ ɑmɑnɛ ŋɑ, bii kù jɛ n fɑɑbɑ ŋɑ. Nɔ ɑ̀ bɔ ilu mmu ɡɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Si bɛi ɑ̀ wɑɑ nɛ ŋɔi inɛ ɡɔ í nɑɑ í sɔ̃ Jesu í ni, ɑn tooɛ bii ì wɑɑ bɔ fei. ");
INSERT INTO mkl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ŋɔi Jesu í sɔ̃ɔ í ni, iŋɑ ŋɑ ɑ̀ nɛ kolo ŋɑ, nɔ bɑɑ yɛi ŋɑ mɔ ɑ̀ nɛ bi ku sũ. Ammɑ ɑmu Amɑi Amɑnɛ n kù nɛ bii ɑn koo n sũ n sĩmi. ");
INSERT INTO mkl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nɔ í sɔ̃ inɛ mmu ɡɔ í ni, toom wɑ. Ammɑ inɛɛu í ni, jɔ̀ n koo n si bɑɑm wɑ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ŋɔi Jesu í sɔ̃ɔ í ni, jɔ̀ iku ŋɑ ɑ si iku nŋɑ ŋɑ, ɑmmɑ ɑwɔ, koo sisi lɑɑbɑɑu jiidɑi bommɑi Ilɑɑɔ̃ bii fei. ");
INSERT INTO mkl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nɔ inɛ ɡɔ í sɔ̃ɔ mɑ́ í ni, ɑn tooɛ Lɑfɛ̃ɛ, ɑmmɑ jɔ̀ n koo n tɔɔ inɛm ŋɑ sukudɔ̃ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nɔ Jesu í sɔ̃ɔ í ni, inɛ iyi í lesi ɑwɔɛ si kɑɑkoi kɛtɛ nɔ í sindɑ í cɔ ɑnyi, kù jɔò bommɑi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Si ɑnyii nŋu, Lɑfɛ̃ɛ í cicɑ ɑmɑnɛ kitɑò fɛɛwɑ mmu mɑ́, í bɛ ŋɑ minji minji ɑ cuɑɑ si ilu ŋɑ fei do bii nŋu tɑkɑɛ ɑ́ nɛ ku bɔ fei. ");
INSERT INTO mkl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nɔ í sɔ̃ ŋɑ í ni, ɑmɑɑjɛ iyi í to ku dɑ í kpɔ, ɑmmɑ woo dɑ ŋɑu ɑ kù kpɔ. Nɑ nŋu, i tɔɔ ilu ikou ku bɛ inɛ ŋɑ iyi ɑɑ ce icɛu wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","I dɑsi kpɑ̃ɑ ŋɑ, ǹ wɑ n bɛ ŋɛi bɛi ɑmɑ ɑnɡudɑ̃ ŋɑ si inɔi mɛɛmu kuɡɑɑbu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","I mɑɑ̀ so tɑɑlili hee mɑ́ jɛ bɔɡɔ, wɑlɑkɔ bɑɑtɑ, nɔ i mɑɑ̀ yɑ leekĩ kpɑ̃ɑ i mɑɑ̀ ce inɛ ɡɔ fɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kpɑsɛ̃ bii ì lɔ ŋɑ i tɑko i sɔ̃ ŋɑ ŋɑ i ni, Ilɑɑɔ̃ ku mu nŋɛ lɑɑkɑi ku sũ. ");
INSERT INTO mkl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bii ilu lɑɑkɑi ku sũ ɡɔ í wɑ bɛ, lɑɑkɑi ku sũ nŋɛ ɑ́ to siɛ. Bii kù wɛɛ mɔi ɑ́ nyi wɑ si ŋɛi. ");
INSERT INTO mkl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kpɑsɛ̃ bii ɑ̀ ɡbɑ ŋɛu, kpɑsɛ̃ bɛi ɑɑ mɑɑ wɑ ŋɑ, sɔndɑ do inyi iyi ɑ̀ nɑ ŋɛ fei i yɑ ɡbɑ i jɛ ŋɑ, domi inɛ kɑɑ mɑ́ɑ ce icɛ iyi kù wɑɑ jɛ. I mɑɑ̀ yɑ lɔ kpɑsɛ̃ do kpɑsɛ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ilu iyi ì lɔ fei ŋɑ bii ɑ̀ ɡbɑ ŋɛ, ijɛ iyi ɑ̀ nɑ ŋɛ i yɑ jɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","I sɔ̃ inɛi ilu ŋɑu i ni, bommɑi Ilɑɑɔ̃ í mɑɑi si ŋɛ. Nɔ bɔ̃ɔ ŋɑ iyi ɑ̀ wɑ bɛ i jɔ̀ ɑ bɑ iri ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ammɑ ilu bii ì lɔ nɔ ɑ kù ɡbɑ ŋɛ, i bɔ bɑntumɑi iluu nɔ i ni, ");
INSERT INTO mkl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","wee ɑ̀ wɑɑ ɡbuɡbɑ̃ nŋɛ hee do irùrùi ilu nŋɛ iyi í wɑ si kutɛ nwɑ. Do nŋu fei, i mɑ̀ ŋɑ iyi bommɑi Ilɑɑɔ̃ í mɑɑi wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nɔ Jesu í ni mɑ́, ɑn sɔ̃ ŋɛ iyi si ɑjɔi kiitiu, ijuukpɑ̃i inɛi Sodomu ŋɑ ilu nlɑi tɑkou, ɑ́ tiɑ do ti inɛi ilu ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nɔ Jesu í ni mɑ́, inɔ kufɔ nlɑ nlɑi ɑ́ jɛ tu ŋɛ, iŋɛ inɛi Kɔrɑzɛ̃ɛ ŋɑ. Iŋɛ mɔ inɛi Bɛsɑidɑ ŋɑ inɔ kufɔ nlɑ nlɑi ɑ́ jɛ tu ŋɛ. Mɑɑmɑɑke ŋɑ iyi ɑ̀ ce si ilu nŋɛ ŋɑu ihɛ̃, bii í jɛ si ilui Tii do Sidɔ̃ɔi ɑ̀ coo wo, bii í wɑ inɛi ilu ŋɑu ɑɑ dĩ sɑɑki ɑ kpɑtɑò nɑ irii dulum du ŋɑ nɔ ɑ kpɑɑsi idɔ hɑi ku kpɛ. ");
INSERT INTO mkl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nɑ ŋɔi í jɔ̀ ǹ wɑ n sɔ̃ ŋɛ iyi si ɑjɔi kiitiu ijuukpɑ̃i inɛi Tii do Sidɔ̃ɔ ŋɑ ɑ́ tiɑ tu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iŋɛ mɔ, inɛi Kɑpɛrɑnumu ŋɑ, ì wɑɑ tɑmɑɑ ŋɑ ɑɑ so ŋɛ hee lelei? Aɑwo, ɑɑ kɛkɛ ŋɛi hee bi ku wɑi iku ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nɔ í sɔ̃ mɔcɔɛ ŋɑ í ni, inɛ iyi í ɡbɔ ide nŋɛ, idem nii í ɡbɔ. Inɛ mɔ iyi í kɔsi ŋɛ, ɑmui í kɔsi. Inɛ mɔ iyi í nɔ í kɔsim, inɛ iyi í bɛm wɑi í kɔsi. ");
INSERT INTO mkl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mɔcɔ kitɑò fɛɛwɑ ŋɑ iyi Jesu í bɛ ŋɑu ɑ̀ bɑɑ do inɔ didɔ̃ nɔ ɑ̀ ni, Lɑfɛ̃ɛ, hee do inɛi inɔɔko ŋɑ fei ɑ̀ yɑ jirimɑ wɑ nɑ iriɛu. ");
INSERT INTO mkl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nɔ Jesu í sɔ̃ ŋɑ í ni, ǹ yɛ Seetɑm wɑ cuku wɑ hɑi lele bɛi kuŋɔi ijĩ. ");
INSERT INTO mkl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ntɔ ntɔ ǹ mu nŋɛ yiiko i tɛɛsɛò njo ŋɑ do cencee ŋɑ hee do ɡbuɡbɑ̃ iyi Seetɑm mbɛɛu í nɛ fei, nɔ nkɑ̃mɑ kɑɑ yɔkɔ ku mɛɛ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Do nŋu fei, i mɑɑ̀ jɔ̀ inɔ nŋɛ ku dɔ̃ nɑ iyi í jɔ̀ inɛi inɔɔko ŋɑu ɑ̀ wɑɑ jirimɑ ŋɛ, ɑmmɑ i jɔ̀ inɔ nŋɛ ku dɔ̃ si nɑ iyi í jɔ̀ ɑ̀ kɔ iri nŋɛ lelei Aɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Si wɑɑti ɑkɑ̃u, inɔi Jesu í dɔ̃ jiidɑ jiidɑ do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃ nɔ í ni, Bɑɑbɑ, ɑwɔ iyi ì jɛ Lɑfɛ̃ɛi lele do ilɛ, ǹ wɑ n sɑɑbuɛ do iyi ì sinɡɑɑ ilu bisi do woo mɑ̀ ŋɑ mii ŋɑu ihɛ̃ nɔ ì nyisi ɑmu ŋɑ. Í sĩɑ Bɑɑbɑ, si nɑ iyi í jɔ̀ bɛɛbɛi ì bi. ");
INSERT INTO mkl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bɑɑm nii í dɑɑm mii fei si ɑwɔ. Inɛ kɑ̃mɑ kù mɑ̀ ɑmu Amɑu bii kù jɛ Bɑɑu. Nɔ inɛ kɑ̃mɑ kù mɑ̀ Bɑɑu bii kù jɛ ɑmu Amɑu do inɛ ŋɑ iyi ǹ bi n nyisi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ŋɔi Jesu í sindɑ si mɔcɔɛ ŋɑu í sɔ̃ ŋɑ í ni, ilu inɔ didɔ̃i inɛ iyi ijuɛ wɑ yɛ mii iyi ì wɑɑ yɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ntɔ ntɔ ɑn sɔ̃ ŋɛ, wɑlii do ɑmɑnlu nkpɔ ɑ̀ bi ɑŋɑ ɑ yɛ mii ŋɑ iyi ì wɑɑ yɛ ŋɑ, ɑ kù nɔ ɑ kù yɔɔ. À bi ɑŋɑ ɑ ɡbɔ iyi ì wɑɑ ɡbɔ ŋɑ, ɑ kù nɔ ɑ kù ɡbɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ajɔ nŋu ɡɔ woo kɔ inɛ ŋɑ si woodɑ ɡɔ í dede ku cɑ̃ idɔi Jesu nɔ í ni, Mɛɛtu, bɛirei ɑn ce n bɑò kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ŋɔi Jesu í beeɛ í ni, mii ɑ̀ kɔ si woodɑu. Ide mii ì yɑ cio si. ");
INSERT INTO mkl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ŋɔi í jɛ í ni, bi Aɔ̃ Lɑfɛ̃ɛɛ do idɔɛ fei, do ɡbuɡbɑ̃ɛ fei, do lɑsɑbuɛ fei, nɔ i bi inɛ mmu ŋɑ bɛi ì bi ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ŋɔi Jesu í ni, ide iyi ì jɛ í sĩɑ. Ce bɛɛbɛ, ɑɑ bɑ kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ammɑ mɔkɔu wɑ bi ku nɑ ɑrɑɛ ntɔ, nɔ í beeɛ í ni, yooi í jɛ inɛ mmu. ");
INSERT INTO mkl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nɔ Jesu í sɔ̃ɔ í ni, mɔkɔ ɡɔ í kitɑ wɑ hɑi Zeruzɑlɛmu wɑ bɔ Zeriko, ŋɔi í koo í dɑsi ɑwɔi ile ŋɑ. Ile ŋɑu ɑ̀ coo ile ɑ̀ cɑ̃ɑ, nɔ ɑ̀ nɛ ɑ̀ jɔ̀ɔ bɛ wɑ kɑsɑ̃m. ");
INSERT INTO mkl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wee, woo weei Ilɑɑɔ̃ ɡɔ wɑ too kpɑ̃ɑu wɑ. Iyi í yɛ mɔkɔu, ŋɔi í ɡbe í lɔ. ");
INSERT INTO mkl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bɛɛbɛ mɔi inɛ ɡɔ si dimii Levi í to inyɑu. Iyi í yɔɔ nɔ í ɡbe í lɔ. ");
INSERT INTO mkl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ammɑ inɛi Sɑmɑri ɡɔ mɔ wɑ bɔ ilu. Iyi í to bɛ ŋɔi í yɛ mɔkɔu nɔ ɑrɑɑre í muu. ");
INSERT INTO mkl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nɔ í sɛkɛɛ siɛ í jɔɑɑ ikpo do ɑtɛ̃ vɛ̃ɛ si ɑɡbɛi kumɛɛ ŋɑu nɔ í dũu. Si ɑnyiɛ nɔ í lesiɛ si ɡbɑnkɛlɛi nŋu tɑkɑɛ í bɔòɛ bi ku sɔi inɛ njoo ŋɑ nɔ í ɡbɔɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Iju kumɑ́ɛ, nɔ í so fiɑi icɛi ɑjɔ minji, í nɑ inɛ nɡboi bi ku sɔi inɛ njoo ŋɑu, nɔ í ni, ɡbɔɑ inɛɛu ihɛ̃. Iyi ì jɛ í lesi nɑ iriɛ, ɑn sɑ̃ɑɛ wɑɑti iyi ɑn bɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ŋɔi Jesu í ni, si ɑmɑnɛ mɛɛtɑ ŋɑu bɛ, yoo nŋɑi ì tɑmɑɑ í jɛ kpɑɑsii inɛ iyi í dɑsi ɑwɔi ile ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ŋɔi inɛɛu í ni, inɛ iyi í ce ɑrɑɑreɛu. Ŋɔi Jesu í ni, debɛi, ɑwɔ mɔ, koo ce bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ajɔ nŋu ɡɔ Jesu do mɔcɔɛ ŋɑu ɑ̀ wɑɑ nɛ nɔ ɑ̀ to ilu ɡɔ. Wee inɑɑbo ɡɔ í wɑ ilu bɛ, ɑ̀ yɑ kpoo Mɑɑtɑ. Nŋui í ɡbɑ ŋɑ si kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Abou í nɛ ifɔɛ ɡɔ iyi ɑ̀ yɑ kpe Mɑɑri. Ifɔu wɑ bubɑi kɔkɔi Lɑfɛ̃ɛ wɑ ɡbɔ ideɛ. ");
INSERT INTO mkl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ammɑ Mɑɑtɑ nŋu í wɑsi ku mɑnte ɑrɑɛ do cɑkɑ ku tɛkɛ. Ŋɔi í nɑɑ í ni, Lɑfɛ̃ɛ, kù jɛɛ si ide kɑ̃mɑ iyi ifɔm í jɔ̀ɔm icɛu ɑmu ɑkɑ̃? I kɑɑ jɔ̀ ku nɑɑ ku sobim? ");
INSERT INTO mkl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ŋɔi Lɑfɛ̃ɛ í jɛɑɑ í ni, Mɑɑtɑ, Mɑɑtɑ, ì wɑɑ mɑnte ɑrɑɛ ì wɑɑ weeweɑ nɑ mii nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ammɑ bukɑɑtɑi mii ɑkɑ̃i ɑmɑnɛ í nɛ. Nŋui Mɑɑri njɛ í cicɑ bɛ, nɔ inɛ kɑ̃mɑ kɑɑ ɡbɑɑ siɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ajɔ nŋu ɡɔ Jesu wɑ ce kutɔɔ bii ɡɔ. Iyi í tɑ̃ ŋɔi mɔcɔ ɑkɑ̃ɛ í ni, Lɑfɛ̃ɛ, kɔ wɑ si bɛi ɑɑ kɑ yɑ ce kutɔɔ, bɛi Zɑ̃ɑ í kɔ mɔcɔɛ ŋɑ si. ");
INSERT INTO mkl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, bii ì wɑɑ ce kutɔɔ ŋɑ i yɑ ni, Bɑɑbɑ, jɔ̀ inɛ fei ku mɑ̀ iyi ɑwɔi ì jɛ inɛ kumɑ́. Nɑɑ jɛ bommɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mu nwɑ ijɛi ɑjɔ fei nwɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kpɑ idei dulum du wɑ, domi ɑwɑ mɔ ɑ̀ yɑ kɑ kpɑ idei kurɑrɑ iyi inɛ ŋɑ ɑ̀ ce nwɑ. Mɑɑ̀ ti i jɔ̀ kɑ dɑsi kulɛlɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nɔ í sɔ̃ ŋɑ mɑ́ í ni, ɑ́ yɔkɔ ku jɛ nsɛi inɛ ɡɔ nŋɛ í bɑ inɛ njoo idũ lɑjɑ. Bii kù nɛ ijɛ iyi ɑ́ nɑɑ, ɑ́ bɔ bi kpɑɑsiɛi ku ni, wɛ̃ɛm pɛ̃ɛ mɛɛtɑ wɑ, ");
INSERT INTO mkl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","domi kpɑɑsim ɡɔ í nɑɑ bi tom hɑi ilu ɡɔ. Nɔ wee, n kù nɛ nɡɔɡɔ iyi ɑn nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kpɑɑsiɛu ɑ́ yɔkɔ ku jɛɑɑ hɑi inɔ ile ku ni, mɑɑ̀ mɑntem, ɑmu ǹ sɔɔkɔ tɑ̃, ɑmu do ɑmɑm ŋɑ fei ɑ̀ wɑɑ sũ. N kɑɑ n yɔkɔ n dede n nɑɛ pɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ǹ wɑ n sɔ̃ ŋɛi, bɑɑ bii kù bi ku dede ku nɑ́ɑ si nɑ iyi í jɔ̀ í jɛ kpɑɑsiɛ, ɑ́ yɔkɔ ku dede ku nɑɑ bukɑɑtɑi mii iyi í bi fei si nɑ iyi í jɔ̀ wɑ mɑnteɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nɑ nŋu, ǹ wɑ n sɔ̃ ŋɛi, i yɑ tɔɔ ŋɑ, ɑɑ mu nŋɛ. I yɑ dɛdɛ ŋɑ ɑɑ bɑ ŋɑ. I yɑ cɑ̃ ɡɑmbo ŋɑ, ɑɑ cĩ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ntɔ ntɔ, inɛ iyi wɑ tɔɔ fei, Ilɑɑɔ̃ ɑ́ muɑɑ. Inɛ mɔ iyi wɑ dɛdɛ, Ilɑɑɔ̃ ɑ́ jɔ̀ ku bɑ. Inɛ mɔ iyi í nɔ wɑ cɑ̃ ɡɑmbo, Ilɑɑɔ̃ ɑ́ cĩɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yooi í wɑ si inɔ nŋɛ ihɛ̃ iyi bii ɑmɑɛ í tɔɔɛ pɛ̃ɛ ɑ́ so kutɑ ku nɑɑ. Wɑlɑkɔ bii í tɔɔɛ cɛ̃ɛ ku so njo ku nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wɑlɑkɔ bii í tɔɔɛ njɛi ɑjɛɛ ɑ́ nɑɑ cencee? Aɑwo, kɑɑ ce. ");
INSERT INTO mkl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Iŋɛ iyi ì yɑ ce lɑɑlɔ ŋɑ ì mɑ̀ mii jiidɑ ku nɑ ɑmɑ nŋɛ ŋɑ, mɑ̀ irei. To, Ilɑɑɔ̃ Bɑɑ nŋɛ iyi í wɑ lele kɑɑ ce ku re zɑkɑ bɛɛbɛ? Kɑɑ so Hundeɛ ku nɑ inɛ ŋɑ iyi ɑ̀ wɑɑ tɔɔɛ? ");
INSERT INTO mkl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Si ɑnyii nŋu, ɑ̀ nɑɑ Jesu mɔkɔ ɡɔ wɑ. Mɔkɔu í nɛ inɛi inɔɔko ɡɔ iyi í jɔ̀ í dekĩ. Nɔ Jesu í lele inɛi inɔɔkou. Iyi í fitɑ ŋɔi mɔkɔu í lɔsi ide ku fɔ, nɔ zɑmɑɑ fei í biti. ");
INSERT INTO mkl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ammɑ inɛ ɡɔ ŋɑ ɑ̀ ni, inɛ nɡboi inɛi inɔɔko ŋɑ iyi ɑ̀ yɑ kpe Bɛɛlizebui í muɑ Jesu ɡbuɡbɑ̃ wɑ leleò inɛi inɔɔko ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nɔ inɛ ɡɔ ŋɑ mɔ ɑ̀ wɑɑ bi ɑ cɑ̃ idɔɛ ɑ cɔ. Nɔ ɑ̀ sɔ̃ɔ ɑ̀ ni ku ce mɑɑmɑɑke ku nyisi iyi yiikoɛ wɑ nɑɑi hɑi lele. ");
INSERT INTO mkl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Si bɛi Jesu í mɑ̀ lɑsɑbu nŋɑ ŋɔi í ni, bommɑ iyi inɛɛ ŋɑ ɑ̀ wɑɑ jɑ ɑŋɑ duusɔ̃ɔ, bommɑu ɑ́ nɑ ku kpɑò bommɑ nɔ kpɑsɛ̃ɛ ŋɑ ku cuku. ");
INSERT INTO mkl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bɛɛbɛ mɔi bii Seetɑm wɑ jɑ do ɑrɑɛ, bɛirei bommɑɛ ɑ́ ce ku bɔ wɑju. Ǹ ni bɛɛbɛi si nɑ iyi í jɔ̀ ì wɑɑ ni do ɡbuɡbɑ̃i Bɛɛlizebui ǹ wɑ n leleò inɛi inɔɔko ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bii do ɡbuɡbɑ̃i Bɛɛlizebuui ǹ wɑ n leleò inɛi inɔɔko ŋɑ, to, do ɡbuɡbɑ̃i yooi mɔcɔ nŋɛ ŋɑ mɔ ɑ̀ wɑɑ leleò ŋɑ. Nɑ ŋɔi í ce ɑŋɑ tɑkɑ nŋɑ ɑɑ nyisi iyi ì rɑrɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ammɑ bii do ɡbuɡbɑ̃i Ilɑɑɔ̃i ǹ wɑ n leleò inɛi inɔɔko ŋɑu, nŋu bɛ wɑ nyisi iyi Ilɑɑɔ̃ í sinti ku jɛ bommɑɛ si ɑnini nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Bii ilu ɡbuɡbɑ̃ jiidɑ ɡɔ í nɛ jĩnɛi iɡũ nɔ wɑ deɡbe kpɑsɛ̃ɛ, ɑmɑniɛ ɑ́ wɛɛi si lɑɑkɑi. ");
INSERT INTO mkl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ammɑ bii ilu ɡbuɡbɑ̃ ɡɔ mɔ iyi í roo í nɑɑ í jɔɔ iɡũ, njɛ ɑ́ ko jĩnɛi iɡũ iyi wɑ nɑɑnɛui fei nɔ ku ce ikpɛ̃i ɑmɑniu mɔ. ");
INSERT INTO mkl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Inɛ iyi kù jɛ tom, mbɛɛm nii. Inɛ iyi kù wɑɑ bɑm ku tɔtɔɔ, wɑ fɑnɡɑɑɛi. ");
INSERT INTO mkl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ŋɔi Jesu í kpɑ nŋɑ mɔndɑu ihɛ̃ í ni, bii inɛi inɔɔko í fitɑ si inɛ, í yɑ mɑɑ dɑbii si ɡbɑɑ ŋɑi ku mɑɑ dɛ bi ku sĩmi. Bii í kuɑ, ŋɔi í yɑ ni, ɑn nyi inyɑ nwom hɑi bii ǹ fitɑ wɑi. ");
INSERT INTO mkl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wɑɑti iyi í nyi nɔ í bɑ inɛɛu í yɛ bɛi ile nɡbɛ iyi ɑ̀ kpɑ̃ ɑ̀ teeseɛ sɑ̃ɑ sɑ̃ɑ, ");
INSERT INTO mkl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ɑ́ koo ku dɛdɛ kpɑɑsi lɑɑlɔ ŋɑ iyi ɑ̀ roo wɑ mɑ́ bɛi ɑŋɑ mɛɛje, ɑ nɑ ɑ lɔ si inɛɛu ɑ mɑɑ wɑ bɛ. Wɑɑti bɛɛbɛ kuwɛɛi tɑkoi inɛɛu ɑ́ tiɑ bɑɑ ti ɑnkɑ̃ɑnyiɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wɑɑti iyi Jesu wɑ fɔ bɛɛbɛ, ɑbo ɡɔ í dɔ̃ ɑnu hɑi inɔ zɑmɑɑu í ni, ilu inɔ didɔ̃i inɛ iyi í so ɑsĩɛ, nɔ ì mɔmɔ ɑmɔɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ŋɔi Jesu í jɛɑɑ í ni, í tiɑ i ni ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi ɑ̀ wɑɑ ɡbɔ idei Ilɑɑɔ̃, nɔ ɑ̀ wɑɑ ceò icɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Si bɛi zɑmɑɑu wɑ kɔ̃ɔsi ŋɔi Jesu í ni, inɛi nsɛi ŋɑ inɛ lɑɑlɔ ŋɑi. À wɑɑ tɔɔ mɑɑmɑɑke, ɑmmɑ mɑɑmɑɑke ɡɔ kù wɛɛ iyi ɑɑ nyisi ŋɑ, bii kù jɛ ti fɑɑjii wɑlii Zonɑsi. ");
INSERT INTO mkl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Si bɛi Zonɑsi í jɛ nyindɑ bi inɛi Ninivu ŋɑ, bɛɛbɛ mɔi ɑmu Amɑi Amɑnɛ ɑn jɛ nyindɑ bi inɛi nsɛi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Si ɑjɔi kiitiu inɑɑbo ilɑɑlui ilɛi Sebɑ ɑ́ dede si inɛi nsɛi ŋɑ ku yɛ tɑɑle nŋɑ, si nɑ iyi í jɔ̀ hɑi jĩijĩi í dede í nɑɑ ku ɡbɔ idei bisii Sɑlomɔɔ ilɑɑlu nlɑu. Nɔ wee nsɛi, ɑmu iyi ǹ wɑ n sɔ̃ ŋɛ ideu ihɛ̃ ǹ re Sɑlomɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Si ɑjɔi kiitiu inɛi Ninivu ŋɑ ɑɑ dede si inɛi nsɛi ŋɑ ɑ yɛ tɑɑle nŋɑ, si nɑ iyi í jɔ̀ ɑ̀ kpɑɑsi idɔ nŋɑ nɑ wɑɑzoi Zonɑsi. Nɔ wee nsɛi, ɑmu iyi ǹ wɑ n sɔ̃ ŋɛ ideu ihɛ̃ ǹ re Zonɑsi. ");
INSERT INTO mkl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Inɛ ɡɔ ci yɑ mɑ́ fitilɑ ku sinɡɑɛ, wɑlɑkɔ ku biiɛ do cɑkɑ, ɑmmɑ ɑ̀ yɑ jilɔɔi bi ku lesi fitilɑ ku bɑ inɛ ŋɑ iyi ɑ̀ wɑɑ lɔ wɑ ɑ mɑɑ yɛ inyɑ kumɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ijuɛi í jɛ fitilɑi ɑrɑɛ. Bii ijuɛ wɑ nɛ bɑɑni, ɑrɑɛ fei í wɑ si inyɑ kumɑ́i. Ammɑ bii kù wɑɑ nɛ bɑɑni, ɑrɑɛ mɔ fei í wɑ si ilu kukui. ");
INSERT INTO mkl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nɑ nŋu, ce lɑɑkɑi ku bɑ inyɑ kumɑ́ iyi í wɑ si ɑrɑɛu ku mɑɑ̀ ce ilu kuku. ");
INSERT INTO mkl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bii ɑrɑɛ fei wɑ nɛ inyɑ kumɑ́, nɔ bɑɑ ikɔ̃ ɑkɑ̃ɛ ɡɔ kù wɑ si ilu kuku, fei ndɛɛ ɑ́ mɑɑ mɑ́i bɛi wɑɑti iyi fitilɑ í mɑ́ siɛ inyɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iyi Jesu í fɔ ideu í tɑ̃, ŋɔi Fɑrisi ɡɔ í kpoo ku jɛ kpɑsɛ̃ɛ. Nɔ í koo í bubɑ kpɑsɛ̃i Fɑrisiu, ɑŋɑò ɑ̀ wɑɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ŋɔi Fɑrisiu í cɔɔ í biti do iyi kù wɔɔ í bɛi wɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ammɑ Lɑfɛ̃ɛ í sɔ̃ɔ í ni, iŋɛ Fɑrisi ŋɑ, í yɛ ŋɑi bɛi inɛ ŋɑ iyi ɑ̀ yɑ wiɛ ɑnyii kɔɔfu do jɛɛ ŋɑ nɔ ɑ jɔ̀ inɔɛ riisi. Inɔ hɑi sĩɑ do tɑkiii wɑ kɔ̃ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Iŋɛ hɑi nɛ yɑɑse ŋɑ, inɛ iyi í tɑkɑ ɑnyii ɑrɑ, lɑfɛ̃ɛ si í ce inɔɛ mɔ? ");
INSERT INTO mkl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Í sĩɑ i nɑ ilu ɑre ŋɑ mii iyi í wɑ si inɔ jɛɛ do kɔɔfu, nɔ mii fei ɑ́ mɑ́ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ammɑ ijuukpɑ̃i ɑ́ jɛ tu ŋɛ, iŋɛ Fɑrisi ŋɑ, si nɑ iyi í jɔ̀ ì yɑ nɑ Ilɑɑɔ̃ hee do zɑkɑɑi ɑyɛ ŋɑ fei. Do nŋu fei, i kù wɑɑ ce jiidɑ nɔ i kù wɑɑ nyisi kubii Ilɑɑɔ̃ ŋɑ. Iyi bɛi í jɔ i yɑ ce nɔ i mɑɑ̀ ɡbɛjɛ iyi í ɡbe ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ijuukpɑ̃i ɑ́ jɛ tu ŋɛ, iŋɛ Fɑrisi ŋɑ, si nɑ iyi í jɔ̀ si ile bi ku ce kutɔtɔɔ ŋɑ kitɑ̃i inɛ nɡbo ŋɑi ì yɑ bi ŋɑ, nɔ ì yɑ bi ɑ ce ŋɛ fɔɔ do bɛɛrɛ nlɑ nlɑ si bɑntumɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aɑ yɛ ijuukpɑ̃ ŋɑ domi ì yɛi bɛi bɑlɛ ŋɑ iyi inɛ ɡɔ kù wɑɑ yɛ. Si ɑntɑi nŋɑi ɑ̀ wɑɑ nɛ ɑ kù nɔ ɑ kù mɑ̀ . ");
INSERT INTO mkl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ŋɔi woo kɔ inɛ ŋɑ si woodɑ ɡɔ í sɔ̃ɔ í ni, Mɛɛtu, bii ì wɑɑ fɔ bɛɛbɛ, ɑwɑ mɔi ì wɑɑ bu. ");
INSERT INTO mkl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ŋɔi Jesu í jɛɑɑ í ni, ijuukpɑ̃i ɑ́ jɛ tu ŋɛ, iŋɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑ mɔ, domi ì wɑɑ kɑ̃ɑ inɛ ŋɑ ɑso ku ɡɑɑbu ku so ŋɑ, nɔ iŋɛ tɑkɑ nŋɛ i ci yɑ lesi bɑɑ ɑmɑɑwɔ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Aɑ yɛ ijuukpɑ̃ ŋɑ, si nɑ iyi í jɔ̀ wɑlii ŋɑ iyi bɑlɑ nŋɛ ŋɑ ɑ̀ kpɑ wo, iŋɛi ì wɑɑ teese bɑlɛ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ì wɑɑ nyisi ŋɑ iyi ì jɛsi mii iyi bɑlɑ nŋɛ ŋɑu ɑ̀ ce, si nɑ iyi í jɔ̀ ɑŋɑi ɑ̀ kpɑ wɑlii ŋɑu, nɔ iŋɛi ì wɑɑ teese bɑlɛ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ŋɔi í jɔ̀ Ilɑɑɔ̃ í fɔ si bisiɛ í ni, ɑn bɛ wɑlii ŋɑ do woo bɛ ŋɑ si ɑnini nŋɑ. Aɑ kpɑ inɛ ɡɔ ŋɑ nɔ ɑ kpɑ̃ inɛ ɡɔ ŋɑ mɔ iju. ");
INSERT INTO mkl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nɑ nŋu, ijuukpɑ̃i woo kpɑ wɑlii ŋɑu fei hɑi sintei ɑndunyɑ si iri nŋɛi ɑ́ jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Iŋɛi ɑɑ yɛ ijuukpɑ̃i kukpɑi Abɛli hee ku koo si do Zɑkɑri iyi ɑ̀ kpɑ si ɑfei bi ku weeu do kpɑsɛ̃i Ilɑɑɔ̃. Ntɔ ntɔ, ǹ wɑ n sɔ̃ ŋɛ, ijuukpɑ̃i mii ŋɑu bɛ fei si inɛi nsɛi ŋɑu ihɛ̃i ɑ́ bɑɑ ku jɛ si. ");
INSERT INTO mkl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ijuukpɑ̃i ɑ́ jɛ tu ŋɛ, iŋɛ woo kɔ inɛ ŋɑ si woodɑ ŋɑu, domi i kù bi ntɔi idei Ilɑɑɔ̃ ku mɑ̀ ŋɑ, nɔ inɛ ŋɑ iyi ɑ̀ bi ku mɑ̀ɛ iŋɛi ì wɑɑ ɡɑnji ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi í fitɑ hɑi bɛ. Ŋɔi idɔi woo kɔ inɛ ŋɑ si woodɑ do Fɑrisi ŋɑu í kɔ̃ nɔ ɑ̀ wɑsi ku mɑnteɛ do ide ku bee si ɡɑ̃mɛi ide nkpɔ, ");
INSERT INTO mkl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ɑ̀ wɑɑ leɑò tɑɑi ide ku bɑ ɑ muu si ide ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wɑɑti iyi Jesu wɑ fɔ bɛɛbɛ zɑmɑɑ í tɔtɔɔ dubu nkpɔ nkpɔ hee ɑ̀ wɑɑ tɛɛsɛ njɛ. Ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑ si wɑjui zɑmɑɑu í ni, i ce lɑɑkɑii ɑrɑ nŋɛ ŋɑ do lefeei Fɑrisi ŋɑ iyi í jɛ muɑfiti. ");
INSERT INTO mkl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nɡɔɡɔ kù wɛɛ iyi wɑ mɑnji iyi kɑɑ fitɑ ɡbuɡbɑ̃ɑ, nɔ ɑsii kɑ̃mɑ kù wɛɛ iyi ɑ kɑɑ nɑ ɑ mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ŋɔi í ce ide iyi ì fɔ si ilu kuku fei ŋɑ ɑɑ nɑ ɑ ɡbɔɔ si inyɑ kumɑ́, ɡundu iyi ì nɔ ì nyɑ inɔ ile ŋɑ ɑɑ cɑ̃ kɛsɛɛdɛɛ si ɑntɑi ile lele ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Iŋɛ iyi ì jɛ kpɑɑsim ŋɑ, iŋɛi ǹ wɑ n sɔ̃, i mɑɑ̀ ce njoi inɛ ŋɑ iyi ɑɑ kpɑ ɑrɑ nŋɛ, nɔ si ɑnyii nŋu ɑ kɑɑ yɔkɔ ɑ ce nɡɔɡɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","An sɔ̃ ŋɛ inɛ iyi í jɔ i yɑ ce njoɛ ŋɑ. I ce njoi inɛ iyi í nɛ yiiko ku kpɑ inɛ nɔ ku dɑsiɛ si inɑ iyi ci yɑ ku mɑ́. Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛ, lɑfɛ̃ɛi í jɔ i ce njoɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A ci yɑ tɑ ɑmɑ yɛi ɑrɑ miu súù minji bɑ. Do nŋu fei, Ilɑɑɔ̃ ci yɑ ɡbɛjɛ bɑɑ ɑkɑ̃ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Iŋɛ mɔ, hee do ntoi iri nŋɛ ŋɑ fei Ilɑɑɔ̃ í mɑ̀ jiɑ nŋɑ. Nɑ nŋu, i mɑɑ̀ ce njoi nɡɔɡɔ, domi bɛɛrɛ nŋɛ í re yɛi hee bii ijĩ. ");
INSERT INTO mkl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ǹ wɑ n sɔ̃ ŋɛi, inɛ iyi í fɔ si wɑjui ɑmɑnɛ ŋɑ í ni nŋu í ɡbɑm, ɑmu mɔ Amɑi Amɑnɛ ɑn ɡbɑ lɑfɛ̃ɛ si wɑjui ɑmɑlekɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ammɑ inɛ iyi í kɔsim si wɑjui ɑmɑnɛ ŋɑ, ɑmu mɔ ɑn kɔsi lɑfɛ̃ɛ si wɑjui ɑmɑlekɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Inɛ iyi wɑ fɔ lɑɑlɔi ɑmu Amɑi Amɑnɛ, Ilɑɑɔ̃ ɑ́ yɔkɔ ku kpɑ idei dulum dɛɛ. Ammɑ inɛ iyi wɑ fɔ lɑɑlɔi Hundei Ilɑɑɔ̃ kɑɑ bɑ ɑ kpɑ idei dulum ndɛɛ pɑi. ");
INSERT INTO mkl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bii ɑ̀ bɔò ŋɛ ile bii ɑ̀ yɑ ce kutɔtɔɔ ŋɑ ku bɑ inɛ nɡbo ŋɑ do ilu yiiko ŋɑ ɑ kiiti ŋɛ, i mɑɑ̀ ti i ce njo do bɛi ɑɑ ce i kɔò ɑrɑ nŋɛ do ide iyi ɑɑ fɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","I mɑɑ̀ ce njo ŋɑ domi wɑɑti bɛɛbɛ Hundei Ilɑɑɔ̃i ɑ́ sɔ̃ ŋɛ iyi í jɔ i fɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Si inɔ zɑmɑɑu ŋɔi inɛ ɡɔ í sɔ̃ Jesu í ni, Mɛɛtu, sɔ̃ iɡbɑ̃m ku jɔ̀ kɑ kpɛ̃ tubu nwɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ŋɔi Jesu í jɛɑɑ í ni, mɔkɔɔyi, yooi í cem woo kiiti nŋɛ wɑlɑ woo kpɛ̃ tubu nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nɔ í sɔ̃ ŋɑ í ni, i yɑ ce lɑɑkɑi ŋɑ ntɔ ntɔ do kɔdɛɛ fei, domi ɑmɑnii ɑmɑnɛ si í jɛ icui kuwɛɛɛ, bɑɑ bii bɛirei ɑmɑniu í lɑ í to. ");
INSERT INTO mkl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nɔ í kpɑ nŋɑ mɔndɑ ɡɔ í ni, ikoi mɔkɔ ilu fiɑ ɡɔ í ce ijɛ jiidɑ jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ŋɔi mɔkɔu í lɑsɑbu í ni, bɛirei ɑn ce. Wee n kù nɛ bii ɑn dɑsi ijɛu. ");
INSERT INTO mkl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ŋɔi í ni, ǹ mɑ̀ bɛi ɑn ce. An lɛɡɛ ɑkɑm ŋɑui, nɔ n mɑ mmuɛ ŋɑ iyi ɑ̀ lɑ ɑ̀ re. Nɔ n kosi bileem fei bɛ do ijɛm ŋɑ iyi ɑ̀ ɡbe. ");
INSERT INTO mkl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nɔ n fɔ si idɔm n ni, ǹ nɛ ɑmɑni nlɑ nlɑ iyi ǹ wɑ n sinɡɑ ti ɑdɔ̃ nkpɔ nkpɔ. An sĩmii nɔ n mɑɑ n jɛ n mɑɑ n mɔ nɔ n mɑɑ n wɛɛò inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ammɑ Ilɑɑɔ̃ í sɔ̃ɔ í ni, ɑwɔu nnyɛi, idũuyi mɔm ɑɑ nyɑ hundeɛ. Sɔɔlui mii ŋɑ iyi ì ceu bɛ, ti yooi ɑ́ jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ŋɔi Jesu í ni, bɛɛbɛ mɔi ɑ́ jɛ bi inɛ iyi wɑ koɑ ɑrɑɛ ɑmɑni nɔ bi Ilɑɑɔ̃ kù nɛ nkɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi í sɔ̃ mɔcɔɛ ŋɑ í ni, nɑ ŋɔi í jɔ̀ ǹ wɑ n sɔ̃ ŋɛ ǹ ni, i mɑɑ̀ yɑ mɑɑ weeweɑ do mii iyi ɑɑ jɛ i mɑɑ wɛɛò ŋɑ, wɑlɑkɔ do jĩnɛ iyi ɑɑ dɑsi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kuwɛɛi ɑmɑnɛ í re ijɛ, ɑrɑ mɔ í re jĩnɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","I ce lɑɑkɑi kunɡbɑ̃ ŋɑ í cɔ. A kù wɑɑ ɡbɛ̃ hee ɑ dɑ nɡɔɡɔ, ɑ kù nɔ ɑ kù nɛ suu. Ilɑɑɔ̃ í nɔ wɑ wo ŋɑ. Bɛɛrɛ nŋɛ kù re yɛi ŋɑ hee bii í jĩ? ");
INSERT INTO mkl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yooi si inɔ nŋɛ nɑ kuweeweɑɛ ɑ́ yɔkɔ ku kɔ̃ɔsi kusɔi ɑdɔ̃ɛ bɑɑ keeke. ");
INSERT INTO mkl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","To, bii i kɑɑ yɔkɔ i ce mii keekeu bɛ ŋɑ, nɑ mii í ce ì wɑɑ weeweɑ do iyi í ɡbe ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","I cɔ bɛi wuɑ ŋɑ ɑ̀ yɑ dɑ koko mɛɛ. A kù wɑɑ ce icɛ ɑ ci yɑ nɔ ɑ wɔ̃ ɑcɔ. Do nŋu fei, ǹ wɑ n sɔ̃ ŋɛi, bɑɑ Sɑlomɔɔ ilɑɑlu nlɑu, do ɑmboe nlɑ nlɑɛ fei kù nɛ jĩnɛ iyi boodɑɛ í to kokoi jĩi ŋɑu bɛ bɑɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Fɔfɔ í wɛɛi nnyi do kusĩɑɛ ɑmmɑ ɑlɑ ɑɑ dɑsiɛ inɑ. To, bii Ilɑɑɔ̃ í muɑ fɔfɔ ŋɑ iyi ɑɑ nɑ ɑ dɑsi inɑ boodɑ ku sĩɑ bɛɛbɛ, kɑɑ yɔkɔ ku mu nŋɛ nyɑu ku re fɔfɔ ŋɑu bɛ de. I kù yɛ nɑɑnɛ nŋɛi kù lɑ? ");
INSERT INTO mkl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","I mɑɑ̀ yɑ dɛ mii iyi ɑɑ jɛ ŋɑ wɑlɑkɔ mii iyi ɑɑ mɔ i mɑɑ̀ weeweɑò ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hɑi mɑ̀ idei Ilɑɑɔ̃ ŋɑi ɑ̀ yɑ mɑɑ kpɑtɑɑ mii ŋɑu bɛ fei, ɑmmɑ Bɑɑ nŋɛ i mɑ̀ iyi ì nɛ bukɑɑtɑi mii ŋɑu bɛ fei ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nɑ nŋu, i hɑnyɑ i dɛ bɛi ɑɑ ce i jɔ̀ bommɑi Ilɑɑɔ̃ ku bɔ wɑju titɑ̃ ŋɑ. Iyi í ɡbe bɛi fei Ilɑɑɔ̃i ɑ́ kɔ̃ɔ nŋɛ si. ");
INSERT INTO mkl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nɔ Jesu wɑ bɑ mɔcɔɛ ŋɑu ide ku fɔ mɑ́ í ni, iŋɛ ɡɑɑ keekem, i mɑɑ̀ ti i ce njo ŋɑ, domi ɑ́ dɔ̃ɑ Bɑɑ nŋɛ si ku jɔ̀ i jɛ ɑmɑɑlu ŋɑ si ɑndunyɑ titɔ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","I tɑ mii iyi ì nɛ ŋɑ nɔ i muɑ ilu ɑre ŋɑ fiɑu. I ceɑ ɑrɑ nŋɛ tɑɑlili iyi kɑɑ ɡbo ikpɑ lele si bii ɑɑ dɑsi ɑmɑni nŋɛ iyi kɑɑ tɑ̃. Tenɡi bɛ ile kɑɑ to si, nɔ tũtũ ŋɑ mɔ ɑ kɑɑ bɛjɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ntɔ ntɔ, bii ɑmɑni nŋɛ í wɑ, bɛi lɑɑkɑi nŋɛ mɔ í yɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","I ce sɔɔlu i dĩ kpɑkɑ nɔ i jɔ̀ fitilɑ nŋɛ ku mɑɑ mɑ́ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","I jɔ̀ i yɛ bɛi inɛ ŋɑ iyi ɑ̀ wɑɑ deɡbe kubɑɑi lɑfɛ̃ɛ nŋɑ wɑ hɑi bi ku ce ɑbɔdɔ̃, ku bɑ bii í to wɑ í cɑ̃ ɡɑmbo ɡbɑkɑ̃ ɑ cĩɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Woo ce icɛ ilu inɔ didɔ̃ ŋɑi, inɛ ŋɑ iyi lɑfɛ̃ɛ ɑ́ nɑ ku bɑ ɑ̀ cɔ kpɑ̃ɑ ɑ̀ wɑɑ deɡbe ku toɛ wɑ. Ntɔ ntɔ n wɑ n sɔ̃ ŋɛ, nŋu tɑkɑɛ ɑ́ dĩ ɡbɑnkili nɔ ku jɔ̀ ɑ bubɑ nɔ ku nɑ ku kpɛ̃ nŋɑ ijɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ilu inɔ didɔ̃ ŋɑi bii í bɑɑ í nɑ í bɑ ŋɑ si bɛɛbɛ, bɑɑ bii í to wɑ lɑjɑi, wɑlɑ kukɔ sintei ɑjɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","I jɔ̀ i mɑ̀ sɑ̃ɑ sɑ̃ɑ ŋɑ iyi bii ilu kpɑsɛ̃ í mɑ̀ wɑɑti iyi ile ɑ́ lɔ wɑ, ɑ́ dede ku wɔ njoo, kɑɑ jɔ̀ ile ku lɛɡɛ ɡɑmboɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iŋɛ mɔ, i ce sɔɔlu ŋɑ domi ɑmu Amɑi Amɑnɛ, ɑn nɑɑi si wɑɑti iyi i kù wɑɑ lɑsɑbu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ŋɔi Piɛɛ í ni, Lɑfɛ̃ɛ, ɑwɑi ì kpɑɑ mɔndɑu ihɛ̃? Mɑ̀ inɛ fei. ");
INSERT INTO mkl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ŋɔi Lɑfɛ̃ɛ í jɛ í ni, yooi í jɛ ɑmɑɑcɛ ilu nɑɑnɛ iyi í nɛ lɑɑkɑi. Lɑfɛ̃ɛi í jɛ inɛ iyi ilu kpɑsɛ̃ ɡɔ í kpe nɔ í so ɑmɑɑcɛ kpɑɑsiɛ ŋɑ í dɑɑ si ɑwɔ ku mɑɑ cɔ ŋɑ ku nɑ ŋɑ ijɛ si bɛi í jɔ. ");
INSERT INTO mkl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Inɔ didɔ̃i ɑ́ jɛ ti ɑmɑɑcɛu bii lɑfɛ̃ɛɛ í bɑ̀ɑ í nɑ í bɑɑ wɑ ce bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ntɔ ntɔ, lɑfɛ̃ɛu ɑ́ dɑɑ ɑmɑɑcɛu mii ndɛɛ fei si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ammɑ bii í jɛ ɑmɑɑcɛ lɑɑlɔi, ɑ́ lɑsɑbui ku ni, lɑfɛ̃ɛm kɑɑ bɑɑ ńyɑ mɑ́, nɔ ku dede ku mɑɑ cɑ̃ inɑɑbo do inɛmɔkɔ woo ce icɛ ŋɑ iyi ɑ̀ ɡbeu, nɔ ku mɑɑ jɛ ku mɑɑ mɔ ɑtɛ̃ ku mɑɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bɛɛbɛi lɑfɛ̃ɛu ɑ́ nɑ ku bɑɑ si ɑjɔ iyi kù wɑɑ cɔ kpɑ̃ɑɛ, do si wɑɑti iyi kù wɑɑ tɑmɑɑ, nɔ ɑ́ kpɑ̃ɑ iju jiidɑ jiidɑ bɛi ɑ̀ yɑ ceɑ ɑmɑɑcɛ lɑɑlɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Woo ce icɛ iyi í mɑ̀ mii iyi lɑfɛ̃ɛɛ í bi, nɔ kù coo, ɡoloɛ ɑ́ lɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ammɑ inɛ iyi kù mɑ̀, nɔ í ce kookoosu iyi í jɔ ɑ cɑ̃ɑ, ɡoloɛ kɑɑ lɑ. Inɛ iyi ɑ̀ nɑ mii nkpɔ, ɑɑ beeɛ mii nkpɔ. Inɛ mɔ iyi ɑ̀ dɑɑ mii nkpɔ si ɑwɔ, nŋui ɑɑ bee ku re. ");
INSERT INTO mkl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nɔ Jesu í sɔ̃ ŋɑ mɑ́ í ni, inɑi ǹ nɑɑ ku fɑ̃ si ɑndunyɑ, nɔ ǹ bɛi ǹ bi ku jɛ í jo tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nɔ inyi ku dɑsi ɡɔ í wɛɛ kù nɛ bɛi ɑ́ ce iyi n kù coo. Inyi ku dɑsiu nŋui í jɛ wɑhɑlɑ iyi ɑn yɛ n bɛi n ku. Nɔ lɑɑkɑim kɑɑ jɛ ɑkɑ̃ í ɡbe hee bii í ce. ");
INSERT INTO mkl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ì tɑmɑɑ bɛi lɑɑkɑi ku sũi ǹ nɑɑ nŋɛ wɑ si ɑndunyɑ ŋɑ? Aɑwo, ǹ wɑ n sɔ̃ ŋɛi, njɛ ku fɛɛfɛi ǹ nɑɑò wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ntɔ ntɔ, hɑi nsɛi bii ɑmɑnɛ miu í wɑ kpɑsɛ̃ ɑkɑ̃ ɑɑ kpɛ̃ ikɑ̃ ikɑ̃. Tɔɔsi ɑkɑ̃ kɑɑ wɛɛ nŋɑ, ɑmɑnɛ mɛɛtɑ ŋɑu ɑ kɑɑ ɡbɔ si njɛ do inɛ minji ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bɑɑ do ɑmɑ ɑ kɑɑ ɡbɔ si njɛ. Iye do ɑmɑ inɑɑboɛ ɑ kɑɑ ɡbɔ si njɛ. Anɑu do ɑbou ɑ kɑɑ ɡbɔ si njɛ. ");
INSERT INTO mkl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ŋɔi í sɔ̃ zɑmɑɑu mɑ́ í ni, bii ì yɛ kudũi ijĩ wɑ dede hɑi nunui ɑlɛ ŋɑ ì yɑ fɔ ŋɑi ɡbɑkɑ̃ i ni, ijĩ ɑ́ nɑɑ. Bɛɛbɛ mɔi í yɑ nɔ ku ce. ");
INSERT INTO mkl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bii ì nɔ ì yɛ fufu wɑ ce wɑ hɑi ikpɑ ɑwɔ cɑnɡɑi kpɑ̃ɑi inunu ŋɑ, ì yɑ ni, inyɑ ɡbɑ̃ɑ ɑ́ ce. Nɔ bɛɛbɛ mɔi í yɑ nɔ ku ce . ");
INSERT INTO mkl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Iŋɛ ilu muɑfiti ŋɑ, ì mɑ̀ yɑɑsei nyindɑi lele do ilɛ ŋɑ. Bɛirei í ce i kù mɑ̀ yɑɑsei wɑɑtiu ihɛ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Bɛirei í ce i ci yɑ lɑsɑbu si ɑrɑ nŋɛ i mɑ̀ iyi í jɛ dee dee ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bii inɛ ɡɔ wɑ bɔòɛ bi ku ce kiiti nɑ idei ɡbese ɡɔ, ce kookɑi hɑi kpɑ̃ɑ ɑwɔ do lɑfɛ̃ɛ i ɡbɔ si njɛ ŋɑ ku bɑ ku mɑɑ̀ dɑsiɛ si ɑwɔi woo kiiti. Bii kù jɛ bɛɛbɛ, woo kiitiu ɑ́ dɑsiɛ si ɑwɔi woo deɡbe piisɔ̃ɔ, nɔ woo deɡbe piisɔ̃ɔu mɔ ku dɑsiɛ ile piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ǹ wɑ n sɔ̃ ŋɛi, bii ɑ̀ dɑsiɛ piisɔ̃ɔ, bii i kù sɑ̃ ɡbeseɛ fei, i kɑɑ fitɑ. Bɑɑ tɑnɡɑ kɑɑ ɡɑiziɑ si. ");
INSERT INTO mkl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wɑɑti bɛɛbɛ, inɛ ɡɔ ŋɑ iyi ɑ̀ wɑ bɛ ɑ̀ wɑɑ sisiɑ Jesu mii iyi í bɑ inɛi Gɑlilee ɡɔ ŋɑ, inɛ ŋɑ iyi Pilɑti í jɔ̀ ɑ̀ kpɑ nɔ njɛ nŋɑ í yɔɡɛɛ do njɛi mɛɛmu ŋɑ iyi ɑ̀ wɑɑ ceɑò Ilɑɑɔ̃ kuwee. ");
INSERT INTO mkl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ammɑ Jesu í sɔ̃ ŋɑ í ni, iŋɛ ì wɑɑ tɑmɑɑ dulum dii inɛi Gɑlilee ŋɑu bɛ í re ti inɛi Gɑlilee ŋɑ iyi ɑ̀ ɡbei? Ì wɑɑ tɑmɑɑ dulum du ŋɑi í jɔ̀ ɑ̀ kpɑ ŋɑ bɛɛbɛ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aɑwo. Bɛɛbɛ mɔi ǹ wɑ n sɔ̃ ŋɛ, iŋɛ tɑkɑ nŋɛ, bii i kù sindɑ idɔ ŋɑ, iŋɛ fei ɑɑ kui bɛi ɑŋɑ mɔ. ");
INSERT INTO mkl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ì wɑɑ ye ɡiɡii ɑmɑnɛ mɑɑtũ do mɛɛtɑ ŋɑ iyi ile ku ɡbokɑi Siloe í cuku í bɑtɑ í kpɑu ŋɑ? Debɛi, ì wɑɑ tɑmɑɑ kurɑrɑ nŋɑi í re ti inɛi Zeruzɑlɛmu ŋɑ iyi ɑ̀ ɡbe fei ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aɑwo, ǹ wɑ n sɔ̃ ŋɛi, iŋɛ tɑkɑ nŋɛ, bii i kù kpɑɑsi idɔ ŋɑ, iŋɛ fei ɑɑ kui bɛi ɑŋɑ mɔ. ");
INSERT INTO mkl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ŋɔi í kpɑ nŋɑ mɔndɑu ihɛ̃ mɑ́ í ni, mɔkɔ ɡɔ í lɔ jĩi ndii fiɡi si kɑɑɛ. Wɑɑti iyi jĩi nɔu í lɑ ŋɔi mɔkɔu í bɔ isoɛ ku kɑ, nɔ kù bɑ. ");
INSERT INTO mkl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ŋɔi í sɔ̃ woo ce icɛɛ í ni, ɑdɔ̃ mɛɛtɑ wɑi ihɛ̃ bɛbɛi iyi bii ǹ nɑɑ isoi jĩi nɔu ihɛ̃ ku kɑ n ci yɑ n bɑ. Dɑɑ i nyɔɔi. Nɑ mii í ce ɑ́ mɑɑ ɡbɑ nwɑ inyɑ nɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ŋɔi woo ce icɛu í sɔ̃ɔ í ni, lɑfɛ̃ɛ, jɔ̀ɔ ɑdɔ̃ɔyi titɑ̃ kɑ cɔ. An tu fitiɛ n kɑɑkoɛ, nɔ n dɑɑ si tɑɑsi. ");
INSERT INTO mkl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Á yɔkɔ ku jɛ ɑdɔ̃ ɡɔ ɑ́ so. Bii kù so i bɛi i dɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Si ɑjɔi kusĩmi ɡɔ, Jesu wɑ kɔ inɛ ŋɑ si cioi idei Ilɑɑɔ̃ ile ɡɔ bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wee ɑbo ɡɔ mɔ í wɑ bɛ iyi inɛi inɔɔko í jɔ̀ í ce bɔ̃ɔ bɛi zɑkɑi ɑdɔ̃ mɑɑtũ do mɛɛtɑ. Í yɑ mɑɑ bɑtei, ci yɑ yɔkɔ ku tɛ ɑrɑɛ bɑɑ keeke. ");
INSERT INTO mkl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iyi Jesu í yɔɔ ŋɔi í kpoo í ni, ɑbooyi, í bɑ iri mbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nɔ í le siɛ ɑwɔ. Ŋɔi ɡbɑkɑ̃ í tɛ ɑrɑɛ nɔ í lɔsi Ilɑɑɔ̃ ku sɑɑbu. ");
INSERT INTO mkl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ammɑ idɔi inɛ nɡboi ile bii ɑ̀ yɑ ce kutɔtɔɔu í kɔ̃ si nɑ iyi í jɔ̀ Jesu í jɔ̀ inɛ ɡɔ í bɑ iri si ɑjɔi kusĩmi, nɔ í sɔ̃ zɑmɑɑu í ni, ɑjɔ mɛɛfɑi í wɛɛ iyi ɑɑ yɔkɔ i ce icɛ ŋɑ. I nɑɑ wɑ wɑɑti bɛɛbɛ ku bɑ i bɑ iri ŋɑ, ku mɑɑ̀ ti ku jɛ si ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ŋɔi Lɑfɛ̃ɛ í jɛɑɑ í ni, iŋɛ ilu muɑfiti ŋɑi, iŋɛ fei i ci yɑ fũ kɛtɛ nŋɛ ŋɑ do ɡbɑnkɛlɛ nŋɛ ŋɑ ɑ koo ɑ mɔ inyi si ɑjɔi kusĩmi? ");
INSERT INTO mkl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Abou ihɛ̃ mɔ dimii Aburɑhɑmui. Nɔ wee Seetɑm wɑ dũu hɑi zɑkɑi ɑdɔ̃ mɑɑtũ do mɛɛtɑ. Kù sĩɑ ɑ fũu si ɑjɔi kusĩmi? ");
INSERT INTO mkl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wɑɑti iyi wɑ fɔ ideu bɛ, ɑnyɔ wɑ mu mbɛɛɛ ŋɑu fei, nɔ zɑmɑɑu í wɛɛ do inɔ didɔ̃ nɑ mɑɑmɑɑke ŋɑ iyi wɑ ce fei. ");
INSERT INTO mkl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ŋɔi Jesu í ni mɑ́, mii bommɑi Ilɑɑɔ̃ í jɔ. Mii ɑn wɑ̃ɑ do. ");
INSERT INTO mkl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Í yɛi bɛi nɡboi mutɑɑdi iyi inɛ ɡɔ í so í ɡbɛ̃ si ilɛɛ. Nɔ í fitɑ í ce jĩi hee yɛi ŋɑ ɑ̀ yɑ mɑɑ ce ɑntɛ si ɑmɑɑwɔɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ŋɔi í ni mɑ́, mii ɑn nyi n wɑ̃ò bommɑi Ilɑɑɔ̃ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bommɑi Ilɑɑɔ̃ í yɛi bɛi lefee iyi ɑbo ɡɔ í so í dɑsi iyɑfũi pɛ̃ɛ ɡũɑ mɛɛtɑ nɔ fei ndɛɛ í dede í kpɑnte. ");
INSERT INTO mkl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesu wɑ too si ilu nlɑ ŋɑ do ilɛɛko ŋɑ wɑ kɔ inɛ ŋɑ si cioi idei Ilɑɑɔ̃ wɑ nɛò ikpɑ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Si isɛɛnɛu ŋɔi inɛ ɡɔ í nɑɑ bi tɛɛ nɔ í beeɛ í ni, Lɑfɛ̃ɛ, inɛ ŋɑ iyi ɑɑ bɑ fɑɑbɑ ɑ kɑɑ kpɔ? Ŋɔi í jɛ í ni, ");
INSERT INTO mkl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","i ce kookɑɑi i lɔ do ɑndɛ iyi kù cĩu ŋɑ. Ǹ wɑ n sɔ̃ ŋɛi, inɛ nkpɔi ɑ́ mɑɑ dɛ kpɑ̃ɑ iyi ɑɑ lɔò ɑ kɑɑ nɔ ɑ yɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wɑɑti iyi ɑmu ilu kpɑsɛ̃ ǹ dede ǹ cĩmbo koofɑu iŋɛ ɑɑ wɑ wɑduude, i mɑɑ cɑ̃ ɡɑmbo ŋɑ i mɑɑ ni, Lɑfɛ̃ɛ, cĩ nwɑ. Nɔ ɑn jɛ nŋɛ n ni, n kù mɑ̀ hɑi bii ì nɑɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Wɑɑti bɛɛbɛi ɑɑ ni ŋɑ, ɑ̀ jɛ ɑ̀ mɔ si wɑjuɛ, ì nɔ ì kɔ wɑ si cioi idei Ilɑɑɔ̃ si bɑntumɑi ilu nwɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nɔ ɑn sɔ̃ ŋɛ n ni, n kù mɑ̀ hɑi bii ì nɑɑ ŋɑ. I fɑ ɑrɑ nŋɛ hɑi bi tom, iŋɛ fei woo ce lɑɑlɔ ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ajɔ wɑ nɑɑ iyi ɑɑ yɛ Aburɑhɑmu do Izɑɑki do Zɑkɔbu do wɑlii ŋɑu fei si ɑndunyɑ titɔ̃i Ilɑɑɔ̃ nɔ iŋɛ i bɑ wee ɑ̀ nyɔ ŋɛ wɑduude. Tenɡi bɛi ɑɑ so ɑwɔ i le si iri i kpɑtɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nɔ inɛ ɡɔ ŋɑ ɑɑ nɑɑ hɑi nunui dɑɑkɔ do hɑi nunui ɑlɛ do hɑi nunu ɡɑɑ cinɡɑɑ minjiu nɔ ɑɑ bubɑ ɑ jɛ si ɑndunyɑ titɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Wɑɑti bɛɛbɛ inɛi ɑnyi ɡɔ ŋɑ ɑɑ nɑ ɑ jɛ woo cuɑ ŋɑ, woo cuɑ ɡɔ ŋɑ mɔ ɑ nɑ ɑ jɛ inɛi ɑnyi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wɑɑti nŋu, Fɑrisi ɡɔ ŋɑ ɑ̀ nɑɑ ɑ̀ sɔ̃ Jesu ɑ̀ ni, koo, fitɑ hɑi ihɛ̃ domi Herodu wɑ bi ku kpɑɛi. ");
INSERT INTO mkl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ŋɔi í jɛ nŋɑ í ni, i koo i sɔ̃ Herodu, ilu bisi lɑɑlɔu bɛ i ni, wee, nnyi do ɑlɑ ǹ wɑ n lele inɛi inɔɔko ŋɑ nɔ n jɔ̀ inɛ ŋɑ ɑ̀ wɑɑ bɑ iri, nɔ si ɑjɔ mɛɛtɑsiɑ ɑn koo n tɑmbɔ icɛm. ");
INSERT INTO mkl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ammɑ kù nɛ bɛi ɑn ce iyi n kù ce isɛɛnɛm nnyi do ɑlɑ do ɑlɑ ɑkɑ̃, domi ɑ kɑɑ kpɑ wɑlii kɑ̃mɑ bii ɡɔ bii kù jɛ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Iŋɛ inɛi Zeruzɑlɛmu ŋɑ, iŋɛ iyi ì yɑ kpɑ wɑlii ŋɑ, nɔ i tɑ ɑmɑ ɑbɛi Ilɑɑɔ̃ ŋɑ mɔ kutɑ i kpɑ ŋɑ ŋɑ, isɛ fɛloi ǹ yɑ n bi n tɔtɔɔ ŋɛ si ɑbɛm bɛi ɑjɛɛ í yɑ tɔtɔɔ ɑmɑɛ ŋɑ si ikpɑɛ, ɑmmɑ i kù jɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wee nsɛi Ilɑɑɔ̃ ɑ́ fũ nŋɛ kpɑsɛ̃ nŋɛ si ɑwɔ. Ammɑ ɑn sɔ̃ ŋɛ, hɑi nsɛi i kɑɑ yɛm mɑ́ ŋɑ í ɡbe hee ɑjɔ iyi ɑɑ ni ŋɑ, Ilɑɑɔ̃ ku weeɑ inɛ iyi wɑ nɑɑ do irii Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Si ɑjɔi kusĩmi ɡɔ Jesu í bɔ ku jɛ kpɑsɛ̃i inɛ nɡboi Fɑrisi ɡɔ ŋɑ. Wee inɛ ɡɔ ŋɑ mɔ ɑ̀ wɑ bɛ, ɑ̀ wɑɑ cɔɔ do lɑɑkɑi. ");
INSERT INTO mkl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mɔkɔ ɡɔ í wɑ bɛ, wɑ leekĩ wɑjui Jesu. Mɔkɔu wɑ ce bɔ̃ɔi ɑrɑ ku wu. ");
INSERT INTO mkl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ŋɔi Jesu í bee woo kɔ inɛ ŋɑ si woodɑ do Fɑrisi ŋɑu í ni, woodɑ í wɛɛ ɑ jɔ̀ inɛ ɡɔ ku bɑ iri si ɑjɔi kusĩmi? Mɑ̀ kù wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ŋɔi ɑ̀ coko. Nɔ í le si ɑwɔɛ si bɔ̃ɔu í jɔ̀ inɛɛu í bɑ iri nɔ í ni ku nɛ. ");
INSERT INTO mkl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nɔ í bee ŋɑ í ni, yoo nŋɛi, bii ɑmɑɛ wɑlɑkɔ bii kɛtɛɛ í dɑsi lɔɡɔ, kɑɑ nyɑɑ ɡbɑkɑ̃ bɑɑ bii ɑjɔi kusĩmii. ");
INSERT INTO mkl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ŋɔi ɑ kù yɔkɔ ɑ kù jɛɑɑ ideu. ");
INSERT INTO mkl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iyi Jesu í ce lɑɑkɑi í yɛ inɛ ŋɑ iyi ɑ̀ kpe ku jɛ ŋɑu ɑ̀ wɑsi ku cicɑ kitɑ̃i wɑju ŋɑ iyi ɑ̀ nɛ bɛɛrɛ ŋɑu nɔ í sɔ̃ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","bii ɑ̀ kpeɛ bi ku ce ɑbɔdɔ̃, mɑɑ̀ bubɑ si kitɑ̃i wɑju ilu bɛɛrɛ ŋɑu. Á yɔkɔ ku jɛ ɑ̀ kpe inɛ ɡɔ iyi í reɛ do bɛɛrɛ. ");
INSERT INTO mkl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nɔ inɛ iyi í kpe iŋɛ feiu ɑ́ nɑ ku ni, dede i muɑ mɔkɔu ihɛ̃ kitɑ̃u bɛ. Wɑɑti bɛɛbɛi ɑɑ dede do ɑnyɔ i koo i bubɑ si kitɑ̃i ɑnyi ihɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ammɑ bii ɑ̀ kpeɛ ku jɛ, koo bubɑ si kitɑ̃i ɑnyi ku bɑ bii inɛ iyi í kpeɛu í to wɑ ku ni, bɑɑkɔɔm, dede i nɑɑ wɑ wɑju. Wɑɑti bɛɛbɛi ɑɑ jɛ ilu bɛɛrɛ nlɑ si wɑjui inɛ ŋɑ iyi iŋɛò ŋɑ ì wɑɑ bubɑ ŋɑu fei. ");
INSERT INTO mkl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ntɔ ntɔ inɛ iyi í so ɑrɑɛ lele ɑ̀ yɑ kɑyeɛi. Inɛ mɔ iyi í kɑye ɑrɑɛ ɑ̀ yɑ soo lelei. ");
INSERT INTO mkl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nɔ Jesu í sɔ̃ inɛ iyi í kpoo ku jɛu mɔ í ni, bii ì wɑɑ kpe inɛ ŋɑ ku jɛ wɑlɑkɔ jinɡɑu, mɑɑ̀ ti i kpe kpɑɑsiɛ ŋɑ, wɑlɑkɔ iɡbɑ̃ɛ do ifɔɛ ŋɑ, wɑlɑkɔ nyɑɑnzeɛ ŋɑ, wɑlɑkɔ kpɑɑsi ilu fiɑɛ ŋɑ, ku bɑ ɑŋɑ mɔ ɑ mɑɑ̀ kpeɛ ɑ sɑ̃ ɡbese. ");
INSERT INTO mkl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ammɑ bii ì wɑɑ kpe inɛ ŋɑ ku jɛ, kpe ilu ɑre ŋɑ, do wɛɛɡɛ ŋɑ, do ilu kutɛ ɑkɑ̃ ŋɑ do fɛɛju ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bii ì ce bɛɛbɛ ɑɑ jɛ ilu inɔ didɔ̃ si nɑ iyi í jɔ̀ inɛ nŋu ŋɑu ɑ kɑɑ bɑ nɡɔɡɔ iyi ɑɑ sɑ̃ɛò ɡbese. Ilɑɑɔ̃i ɑ́ sɑ̃ɛ ɡbese si wɑɑti iyi inɛ dee dee ŋɑ ɑɑ jĩ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iyi ɑ̀ ɡbɔ ideu, ŋɔi inɛ ɑkɑ̃i inɛ ŋɑ iyi ɑŋɑò ŋɑ ɑ̀ wɑɑ jɛu í sɔ̃ Jesu í ni, debɛi ilu inɔ didɔ̃i inɛ iyi ɑ́ jɛ si ɑndunyɑ titɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ŋɔi Jesu í kpɑ nŋɑ mɔndɑ í ni, mɔkɔ ɡɔ í ce ijɛ nlɑ nlɑ nɔ í kpe inɛ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Iyi ɑwɑɑtii kujɛu í to ŋɔi í bɛ woo ce icɛɛ koo sɔ̃ inɛ ŋɑ iyi í kpeu ku ni, i nɑɑ wɑ ŋɑ, domi sɔndɑ fei í jĩɑ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ammɑ ɑŋɑ fei ɑ̀ lɔsi ɡɑɑfɑrɑ ku tɔɔ. Inɛ sinteu í ni, ǹ rɑ iko, tilɑsi, í ɡbe n koo n cɔɔ. Ǹ wɑ n tɔɔɛ ku ceem suuru. ");
INSERT INTO mkl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Inɛ mmu mɔ í ni, ǹ rɑ kɛtɛ ku loɡoo ŋɑi kɔ̃ɔ miu, nɔ ǹ wɑ n bi n dĩ nŋɑ n ceò icɛ n cɔ. Ǹ wɑ n tɔɔɛ ku ceem suuru. ");
INSERT INTO mkl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nɔ inɛ mmu ɡɔ mɔ í ni mɑ́, nsɛi ǹ so ɑbo. Nɑ ŋɔi í jɔ̀ n kɑɑ n bɑ n nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ŋɔi woo ce icɛu í sindɑ í koo í sɔ̃ lɑfɛ̃ɛɛ ɡɑɑfɑrɑ iyi inɛ ŋɑu fei ɑ̀ tɔɔ. Ŋɔi idɔi lɑfɛ̃ɛu í kɔ̃, nɔ í sɔ̃ woo ce icɛɛu í ni, koo i bɔ si bɑntumɑ ŋɑ nsɛi nsɛi do si kpɑ̃ɑi inɔ iluu, kpeem ilu ɑre ŋɑ wɑ do wɛɛɡɛ ŋɑ do fɛɛju ŋɑ do ilu kutɛ ɑkɑ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ŋɔi woo ce icɛu í koo. Iyi í bɑɑ nɔ í ni, lɑfɛ̃ɛ, iyi ì dɑsim nɔu ǹ coo tɑ̃. Wee inyɑ í ɡbe mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ŋɔi lɑfɛ̃ɛu í sɔ̃ɔ mɑ́ í ni, bɔ si kpɑ̃ɑi ilɛɛko ŋɑ do kpɑ̃ɑi iko ŋɑ, jɔ̀ inɛ ŋɑ ɑ lɔ wɑ bɑɑ do tilɑsi, kpɑsɛ̃m de ku kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ntɔ ntɔ, ɑn sɔ ŋɛ, inɛ ŋɑ iyi ǹ tɑko ǹ kpeu bɑɑ inɛ ɑkɑ̃ nŋɑ kɑɑ tiɛ ijɛu ihɛ̃ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ajɔ nŋu ɡɔ Jesu wɑ nɛ nɔ zɑmɑɑ nlɑ nlɑ ɡɔ wɑ tooɛ. Ŋɔi Jesu í sindɑ í sɔ̃ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","inɛ iyi í nɑɑ bi tom nɔ kù cé bɑɑɛ do iyeɛ do ɑboɛ do ɑmɑɛ ŋɑ do iɡbɑ̃ɛ ŋɑ do ifɔɛ ŋɑ do wecĩɛ ŋɑ do kuwɛɛi nŋu tɑkɑɛ kɑɑ yɔkɔ kù jɛ mɔcɔm . ");
INSERT INTO mkl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Inɛ iyi kù jɛsi nŋu ku so jĩi ku ɡɑɑuɛ ku toom do wɑ kɑɑ yɔkɔ ku jɛ mɔcɔm. ");
INSERT INTO mkl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bii inɛ ɡɔ nŋɛ í bi ku mɑ ile ɑ́ bubɑ ku ce dooɑ titɑ̃ ku cɔ mɑ̀ fiɑi nŋu ɑ́ to ku kpɑò iriɛ. ");
INSERT INTO mkl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bii kù jɛ bɛɛbɛ, nɔ í cɛ icui ileu, í bɛi í nɑ í mɔnɡɔ ku mɑɛ, inɛ ŋɑ iyi ɑ̀ yɔɔ fei ɑɑ nyɑɑnyiɛ, ");
INSERT INTO mkl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ɑ ni, mɔkɔu ihɛ̃ í sinti ku mɑ nɔ wee í mɔnɡɔ kù kpɑ iriɛ. ");
INSERT INTO mkl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bɛɛbɛ mɔi ilɑɑlu ŋɑ mɔ ɑ̀ yɑ ce ɑ bɛi ɑ bɔ iɡũ. Bii ilɑɑlu ɡɔ í nɛ sooɡe dubu mɛɛwɑ, nɔ í yɛ ilɑɑlu mmu ɡɔ wɑ nɑɑ siɛ iɡũ do sooɡe dubu kɔnfiɑ, ɑ́ dedei ɡbɑkɑ̃ ku ce iɡũ? Aɑwo, ɑ́ bubɑi titɑ̃ ku lɑsɑbu ku cɔ mɑ̀ nŋu ɑ́ yɔkɔ ku kɑ̃miɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bii í yɛ nŋu kɑɑ nɔɔ, ɑ́ bɛ inɛ ŋɑi bi ilɑɑlu iyi ihɔ̃u hɑi wɑɑti iyi kù to wɑ titɑ̃ ku bɑ ɑŋɑò ɑ ɡbɔsi njɛ nɔ lɑɑkɑi ku sũ ku wɑ ɑnini nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nɑ ŋɔi í ce ɑwɔ iyi i kù jɔ̀ mii iyi ì nɛ fei, i kɑɑ yɔkɔ í jɛ mɔcɔm. ");
INSERT INTO mkl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nɔ Jesu í ni mɑ́, imu mii ncɛɛi, ɑmmɑ bii didɔ̃i imu í ku, mii ɑɑ dɑsi ɑ jɔ̀ ku dɔ̃ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kɑɑ ce bukɑɑtɑ kɑ̃mɑ mɑ́ nɔ bɑɑ bii ikoi kɑɑ ce tɑɑsi. À yɑ dikɑ̃ɛi wɑduude. Inɛ iyi í nɛ itĩ iyi ɑ́ ɡbɔò ide, ku ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Woo ɡbɑ fiɑi lɛmpoo ŋɑ do inɛ lɑɑlɔ ŋɑ fei ɑ̀ nɑɑ bi Jesu ku bɑ ɑ ɡbɔ ideɛ. ");
INSERT INTO mkl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ŋɔi Fɑrisi do woo kɔ inɛ ŋɑ si woodɑ ŋɑ ɑ̀ lɔsi ku ɡbɑɡbɑ ɑ̀ wɑɑ ni, mɔkɔu wɑ ɡbɑ inɛ lɑɑlɔ ŋɑ nɔ ɑŋɑò ŋɑ ɑ̀ tɔtɔɔ ɑ̀ wɑɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ŋɔi Jesu í kpɑ nŋɑ mɔndɑ ɡɔ í ni, ");
INSERT INTO mkl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Bii inɛ ɡɔ nŋɛ í nɛ ɑnɡudɑ̃ cĩɔ iyi wɑ deɡbe si ɡbɑbuɑ nɔ ɑkɑ̃ í nyɔ siɛ, lɑfɛ̃ɛ ɑ́ jɔ̀ cinɛò fɛɛwɑ do mɛɛsɑ̃ iyi í ɡbeu si ɡbɑbuɑ bɛi koo dɛdɛ ɑkɑ̃ iyi í nyɔu wɑ hee koo yɔɔ, mɑ̀ irei. ");
INSERT INTO mkl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hɑi í nɔ í yɔɔ ɡbɑkɑ̃ ɑ́ muu ku le siɛ kɔnɡɔ wɑi do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Bii í bɑɑ kpɑsɛ̃ ɑ́ kpe kpɑɑsiɛ ŋɑ do inɛ ŋɑ iyi ɑ̀ wɑɑ mɑ́ kɔkɔɛ ku sɔ̃ ŋɑ ku ni, i bɑm inɔ didɔ̃ ku kpɛ̃, domi ɑnɡudɑ̃m iyi í nyɔu ǹ yɔɔ wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ŋɔi Jesu í ni, bɛɛbɛ mɔi ǹ wɑ n sɔ̃ ŋɛ, inɔ didɔ̃i inɛi lele ŋɑ ɑ́ lɑ nɑ ilu dulum ɑkɑ̃ iyi í kpɑɑsi idɔ ku re inɛ dee dee cĩɔ fɑkɑ̃ kù wɑ si iyi ɑ kù nɛ bukɑɑtɑi idɔ ku kpɑɑsi. ");
INSERT INTO mkl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nɔ Jesu í kpɑ nŋɑ mɔndɑ mmuɛ mɑ́ í ni, bii inɑɑbo ɡɔ í nɛ kpɛkɛlɛ mɛɛwɑ nɔ ɑkɑ̃ɛ í nyɔ, ɑ́ mɑ́ fitilɑi nɔ ku kpɑ̃ ileu ku dɛdɛɛ do lɑɑkɑi hee koo yɔɔu. ");
INSERT INTO mkl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bii í yɔɔ ɑ́ kpe kpɑɑsiɛ ŋɑ do inɛ ŋɑ iyi ɑ̀ wɑɑ mɑ́ kɔkɔɛ nɔ ku ni, I bɑm inɔ didɔ̃ ku kpɛ̃, domi fiɑm iyi í nyɔu ǹ yɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bɛɛbɛ mɔi ǹ wɑ n sɔ̃ ŋɛ, ɑmɑlekɑi Ilɑɑɔ̃ ŋɑ ɑ̀ yɑ wɛɛò inɔ didɔ̃ nɑ ilu dulum ɑkɑ̃ iyi í kpɑɑsi idɔ. ");
INSERT INTO mkl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesu í ni mɑ́, mɔkɔ ɡɔ í nɛ ɑmɑ inɛmɔkɔ minji. ");
INSERT INTO mkl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ŋɔi ifɔu í sɔ̃ bɑɑu í ni, bɑɑm, kpɛ̃ ɑmɑniu nɔ i nɑm iyi í jɛ titom. Nɔ bɑɑu í ce nŋɑ ikpɛ̃i ɑmɑniɛu. ");
INSERT INTO mkl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Iyi í ce ɑjɔ minji, ifɔu í tɑ mii iyi í nɛ fei nɔ í so fiɑu í nɛò hee ilɛ jĩijĩ ɡɔ. Bɛi í koo í ce kuwɛɛɛ si dɑɑ lɑɑlɔ í kpɑò irii ɑmɑniɛu fei. ");
INSERT INTO mkl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wɑɑti iyi í jɛ fei ndɛɛ í kpɑ iriɛ, ɑri nlɑ ɡɔ í bɛi í nɑɑ si ilɛu nɔ í lɔ si ɑre. ");
INSERT INTO mkl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ŋɔi í bɔ bi inɛi ilɛ bɛ ɡɔ nɔ lɑfɛ̃ɛ í koo í dɑsiɛ icɛi kusɔɔ ŋɑ ku deɡbe. ");
INSERT INTO mkl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tenɡi bɛi í bi ku wo ɑrɑɛ do ijɛi kusɔɔ ŋɑu ɑmmɑ inɛ kɑ̃mɑ kù muɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Iyi lɑɑkɑɛ í nɑ í bɑɑ nɔ í ni, ɑmɑ icɛi bɑɑm ŋɑ fei ɑ̀ nɛ ijɛ wɑ kɔ̃ nŋɑi, nɔ ɑmu wee ǹ wɑ n ku do ɑri ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","An dede n nyi bi bɑɑm n sɔ̃ɔ n ni, bɑɑm, ǹ ce dulum bi Ilɑɑɔ̃ do bi tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nɑ nŋu, n kù to ɑ kpem ɑmɑɛ mɑ́. Ceem bɛi ɑmɑɑcɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ŋɔi í dede wɑ nyi ikpɑ bi bɑɑɛu. Hɑi wɑɑti iyi wɑ jĩ, ŋɔi bɑɑɛ í hɔ̃nnɛɛ nɔ ɑrɑɑre fei í muu. Í sɛi í koo í yɑɑ do inɔ didɔ̃ nɔ í coo fɔɔ do kubi. ");
INSERT INTO mkl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ŋɔi ɑmɑu í ni, bɑɑbɑ, ǹ ce dulum bi Ilɑɑɔ̃ do bi tɛɛ. Nɑ nŋu, n ku tò ɑ kpem ɑmɑɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ammɑ bɑɑɛu í sɔ̃ woo ce icɛɛ ŋɑ í ni, i nɑɑò ibɔ kumboo wɑ ńyɑ ńyɑ iyi í sĩɑ, i dɑɑ si ŋɑ. Nɔ i nɑɑ lɛlɛɑwɔ do bɑɑtɑ ku dɑsi. ");
INSERT INTO mkl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","I nɑɑò kɛtɛ kombo sɑɑsɑɑbɔ iyi í lɑ í reu bɛ wɑ, nɔ i kpɑɑ ŋɑ. Kɑ jɛ kɑ ce jinɡɑu do inɔ didɔ̃, ");
INSERT INTO mkl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","domi ɑmɑm iyi í yɛ bɛi í ku wo, í bɑɑ si ɑndunyɑ mɑ́. Í nyɔ wo nɔ ɑ̀ yɔɔ mɑ́. Ŋɔi ɑ̀ wɑ si inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Wee wɑɑti bɛɛbɛ iɡbɑ̃u í wɑ iko. Iyi wɑ bɑɑ í mɑɑi kpɑsɛ̃ wɑ ŋɔi wɑ ɡbɔ ɑnui ɡɑ̃ɡɑ̃ nɔ inɛ ŋɑ ɑ̀ wɑɑ jojo. ");
INSERT INTO mkl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ŋɔi í kpe woo ce icɛ ɡɔ í beeɛ í ni, mii í ce. ");
INSERT INTO mkl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ŋɔi woo ce icɛu í sɔ̃ɔ í ni, ifɔɛi í bɑɑ, nɔ bɑɑ nŋɛ í kpɑ kɛtɛ sɑɑsɑɑbɔ iyi í nɛ ikpo si nɑ iyi í jɔ̀ í yɔɔ bɑɑni. ");
INSERT INTO mkl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ŋɔi iɡbɑ̃u í dɑmɔɔ í kɔ ku lɔ kpɑsɛ̃. Ŋɔi bɑɑu í fitɑ wɑ í nɑɑ ku lɛlɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ammɑ í sɔ̃ bɑɑu í ni, cɔ hɑi ɑdɔ̃ nkpɔ nkpɔ iyi ǹ wɑ n ceɛ icɛ wɑ. Nɔ n kù dondɑ ideɛ kɑ̃mɑ, nɔ bɑɑ ɑmɑ iwo i kù muum n ceò jinɡɑu do inɔ didɔ̃ ɑmu do kpɑɑsim ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ammɑ iyi ɑmɑɛ í bɑɑ, nŋu iyi í koo í jɛ ɑmɑniɛ do inɑɑbo sɑkɑrɑ ŋɑ, nɔ nɑ iriɛi ì kpɑ kɛtɛ sɑɑsɑɑbɔu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ŋɔi bɑɑu í ni, ɑwɔ ɑmɑm nii, ɑwɑɛi ɑ̀ wɛɛ do ɑjɔ fei, nɔ mii iyi ǹ nɛ fei í jɛ tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ammɑ í sĩɑ kɑ jɛ jinɡɑu do inɔ didɔ̃ nlɑ nlɑ si nɑ iyi í jɔ̀ ifɔɛu ihɛ̃ í yɛ bɛi í kui wo nɔ í bɑɑ si ɑndunyɑ mɑ́. Í nyɔ wo nɔ ɑ̀ yɔɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, mɔkɔ ilu fiɑ ɡɔi í wɛɛ. Mɔkɔu í nɛ ɑmɑɑcɛ ɡɔ nɔ í so ɑmɑnii kpɑsɛ̃ɛ fei í dɑɑ si ɑwɔ. Iyi í ce ɑjɔ minji ŋɔi inɛ ŋɑ ɑ̀ koo ɑ̀ kɔɔmɔtɔ ɑmɑɑcɛu bi lɑfɛ̃ɛ ɑ̀ ni, wɑ bɛjɛ ɑmɑniɛu fei. ");
INSERT INTO mkl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ŋɔi lɑfɛ̃ɛ í kpoo í beeɛ í ni, irei ǹ wɑ n ɡbɔ inɛ ŋɑ ɑ̀ wɑsi ku sɔ iriɛ dɑ. I kɑɑ yɔkɔ i jɛ ɑmɑɑcɛm mɑ́. Koo so tiɑi icɛɛ wɑ si bii ì yɑ ce dooɑi fiɑm, i nɑɑ i nyisim. ");
INSERT INTO mkl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ŋɔi ɑmɑɑcɛu wɑ bee ɑrɑɛ ide wɑ ni, bɛirei ɑn ce, si bɛi lɑfɛ̃ɛm wɑ nyɑm hɑi si icɛi kpɑsɛ̃ɛ. Wee n kù nɛ ɡbuɡbɑ̃ iyi ɑn yɔkɔ n loɡooò, nɔ wee ɑnyɔ kɑɑ jɔ̀ n bɑrɑ. ");
INSERT INTO mkl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ǹ mɑ̀ bɛi ɑn ce ku bɑ inɛ ŋɑ ɑ ɡbɑm si kpɑsɛ̃ nŋɑ wɑɑti iyi ɑɑ nyɑm hɑi si icɛm. ");
INSERT INTO mkl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ŋɔi í kpe ilu ɡbesei lɑfɛ̃ɛ ŋɑu fei. Nɔ ɑŋɑ fei ɑ̀ koo bi tɛɛ ɑkɑ̃ ɑkɑ̃. Ŋɔi í bee inɛ sinte iyi í to bi tɛɛu í ni, ɡbesei lɑfɛ̃ɛm fɛloi ì wɑɑ mu. ");
INSERT INTO mkl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ŋɔi í jɛ í ni, ikpo iyi ɑ́ kɔ̃ boonyi cĩɔ. Ŋɔi í sɔ̃ɔ í ni, so tiɑɛ i bubɑ ńyɑ ńyɑ nɔ i kɔ ciitɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ŋɔi í bee inɛ ɡɔ mɑ́ í ni, ɑwɔ mɔ, fɛloi ì wɑɑ mu. Ŋɔi í sɔ̃ɔ í ni, iyɑ sɑɑki cĩɔ. Ŋɔi í sɔ̃ nŋu mɔ í ni, so tiɑɛ i kɔ cinɛ. ");
INSERT INTO mkl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ŋɔi lɑfɛ̃ɛi ɑmɑɑcɛ hɑi nɛ nɑɑnɛu í ɡbɔ ideu nɔ í sɑɑbuɛ si nɑ iyi í jɔ̀ í yɔɔ iyi í nɛ bisi ntɔ ntɔ. Ŋɔi Jesu í ni, inɛi ɑndunyɑ ŋɑ ɑ̀ nɛ bisi ɑŋɑ duusɔ̃ɔ si kuwɛɛ nŋɑ ɑ̀ re inɛi inyɑ kumɑ́ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, i yɑ dɛ kpɑɑsi ŋɑ do ɑmɑnii ɑndunyɑ ku bɑ bii í nɑ wɑ ɡɑiziɑ ŋɛ ɑ ɡbɑ ŋɛ si ɑndunyɑ titɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Inɛ iyi í nɛ nɑɑnɛ si mii keeke ɑ́ nɛ nɑɑnɛ si mii nlɑ. Inɛ iyi wɑ ce lɑɑlɔ si mii keeke ɑ́ ce lɑɑlɔ si mii nlɑ. ");
INSERT INTO mkl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nɑ nŋu, bii i kù nɛ nɑɑnɛ si ɑmɑnii ɑndunyɑ ŋɑ, yooi ɑ́ dɑ nŋɛ si ɑmɑni ntɔ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bii i kù nɛ nɑɑnɛ si mii ndii inɛ ɡɔ, yooi ɑ́ nɑ ŋɛ iyi í jɛ tu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Amɑɑcɛ kɑ̃mɑ kɑɑ yɔkɔ ku ceɑ lɑfɛ̃ɛ minji icɛ ɑjɔ. Ntɔ ntɔ ɑ́ cé inɛ ɑkɑ̃ nɔ ku bi inɛ ɑkɑ̃, wɑlɑkɔ ku jirimɑ inɛ ɑkɑ̃ nɔ ku dondɑ inɛ ɑkɑ̃. I kɑɑ yɔkɔ i too Ilɑɑɔ̃ do fiɑ ɑjɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Wee Fɑrisi ŋɑ fiɑ ku bi nŋɑ í cɑɑ. Iyi ɑ̀ ɡbɔ ide ŋɑ iyi Jesu í fɔu fei ŋɔi ɑ̀ wɑɑ yɑɑkoɛ. ");
INSERT INTO mkl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nɔ Jesu í sɔ̃ ŋɑ í ni, iŋɛ ì wɑɑ dɛ i jɛ inɛ dee dee ŋɑ si wɑjui ɑmɑnɛ ŋɑ, ɑmmɑ Ilɑɑɔ̃ í mɑ̀ idɔ nŋɛ. Ǹ wɑ n sɔ̃ ŋɛi, mii iyi ɑmɑnɛ ŋɑ ɑ̀ wɑɑ cɔ mii jiidɑ, bi Ilɑɑɔ̃ mii sɑ̃mii. ");
INSERT INTO mkl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Woodɑ do idei wɑlii ŋɑu fei ɑ̀ wɛɛ hee do wɑɑtii Zɑ̃ɑ. Hɑi wɑɑti bɛɛbɛ ɑ̀ wɑɑ sisi lɑɑbɑɑu jiidɑi bommɑi Ilɑɑɔ̃ nɔ inɛ fei wɑ ce kookɑɑi ku bɑ ku lɔ do ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Woodɑ bɑɑ wɑsɑli í ɡɑɑbu ku bɛjɛ í re lele do ilɛ ku kpɑ iri mɔm. ");
INSERT INTO mkl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Inɛ iyi í kɔsi ɑboɛ nɔ í so mmuɛ í ce sɑkɑrɑi. Inɛ iyi í so ɑbo iyi mɔkɔɛ í kɔsi í ce sɑkɑrɑi. ");
INSERT INTO mkl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ŋɔi Jesu í kpɑ nŋɑ mɔndɑu ihɛ̃ í ni, mɔkɔ ilu ɑmɑni ɡɔ í wɛɛ. Mɔkɔu í yɑ mɑɑ dɑsi ibɔ cɑɑdɑ ilu iju ku sĩɑ ɡɔ. Kpɑsɛ̃ɛ ɑjɔ fei jinɡɑui. ");
INSERT INTO mkl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ilu ɑre ɡɔ mɔ í wɛɛ, í yɑ mɑɑ sũi ɑndɛ koofɑi ilu fiɑu, ɑ̀ yɑ kpoo Lɑzɑɑ. Konkoli wɑ kɔ̃ si ɑrɑɛ fei. ");
INSERT INTO mkl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nɔ ɑjɑ ŋɑ ɑ̀ yɑ nɑɑ ɑ mɑɑ fɑ konkoliɛ ŋɑu. Mɔkɔu í bi ku wo ɑrɑɛ bɑɑ do bubui sɔndɑi ilu fiɑu iyi í yɑ ɡbe, ɑmmɑ ci yɑ bɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ŋɔi mɔkɔu í nɑ í ku nɔ ɑmɑlekɑ ŋɑ ɑ̀ soo ɑ̀ bɔòɛ bi Aburɑhɑmu. Nɔ ilu fiɑu mɔ í nɑ í ku ɑ̀ suu. ");
INSERT INTO mkl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nɔ í koo wɑ yɛ ijuukpɑ̃ bi ku wɑi iku ŋɑ, nɔ í wu iju lele, ŋɔi í hɔ̃nnɛ Lɑzɑɑ kɔkɔi Aburɑhɑmu. ");
INSERT INTO mkl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ŋɔi í dɔ̃ ɑnu í ni, bɑɑbɑ Aburɑhɑmu, ce ɑrɑɑrem. Bɛ Lɑzɑɑ wɑ ku sɔsi ɑmɑɑwɔɛ si inyi ku nɑ ku tũ ɑmɛm, domi ǹ wɑ n yɛ ijuukpɑ̃ nlɑ nlɑ si ɑmɛi inɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ŋɔi Aburɑhɑmu í ni, ɑmɑm, ye ɡiɡi iyi ì bɑ mii jiidɑɛ tɑ̃ hɑi ɑndunyɑ, nɔ Lɑzɑɑ mɔ í yɛ wɑhɑlɑ. Wee ihɛ̃ nsɛi inɔɛ í tũ nɔ ɑwɔ mɔ ì wɑɑ yɛ ijuukpɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nɔ si ɑntɑiɛ, isɑ nlɑ ɡɔi í fɛɛfɛ wɑ ku bɑ inɛ ŋɑ iyi ɑ̀ bi ɑ kuɑ ɑ bɔ bi tu ŋɛ bɛ ɑ mɑɑ̀ yɔkɔ. Bɛɛbɛ mɔi inɛ ɡɔ kɑɑ yɔkɔ ku nɑɑ ihɛ̃ hɑi bɛ. ");
INSERT INTO mkl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ŋɔi ilu ɑmɑniu í ni, debɛi, ǹ wɑ n tɔɔɛi bɑɑbɑ, bɛ Lɑzɑɑ kpɑsɛ̃i bɑɑm, ");
INSERT INTO mkl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","koo sɔ̃ ifɔ miu ŋɑ iyi ǹ nɛ bɛu ku ni ɑ ce lɑɑkɑi ku bɑ ɑ mɑɑ̀ nɑ ɑ nɑɑ si inyɑ ku ɡɑɑbuu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ammɑ Aburɑhɑmu í ni, ɑ̀ nɛ tiɑ iyi Moizi do wɑlii ŋɑ ɑ̀ kɔ wou tɑ̃, ɑɑ yɔkɔ ɑ ɡbɔ ide nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nɔ í ni, ɑɑwo, bɑɑbɑ Aburɑhɑmu. Ammɑ bii hɑi bi iku ŋɑi inɛ ɡɔ í koo bi tu ŋɑ, ɑɑ kpɑɑsi idɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ŋɔi Aburɑhɑmu í sɔ̃ɔ í ni, bii ɑ kù ɡbɔ ti Moizi do ti wɑlii ŋɑu, bɑɑ bii inɛ ɡɔ í jĩ hɑi bi iku ŋɑ ihɛ̃ í koo bɛ ɑ kɑɑ dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, kù nɛ bɛi ɑ́ ce iyi kulɛlɛ iyi ɑ́ dɑsi ɑmɑnɛ lɑɑlɔ kù wɑɑ ce, ɑmmɑ ijuukpɑ̃i ɑ́ jɛ ti inɛ iyi í nɑɑò wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Á tiɑ ɑ dĩɑ lɑfɛ̃ɛ ɑlɔ si kɔ̃ɔ ɑ sɔsiɛ inɔ tenku do iyi ɑ́ lɛlɛ ɑmɑ ɑkɑ̃ ku dɑsiɛ dulum. ");
INSERT INTO mkl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","I yɑ ce lɑɑkɑii njɛ ŋɑ. Bii kpɑɑsiɛ ɡɔ í nɑ í ce dulum, sɔ̃ɔ ide do lɑɑkɑi í nyisiɛ tɑɑleɛ. Bii í kpɑɑsi idɔ, kpɑ idei kurɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bɑɑ bii isɛ ɡbɛɛjei wɑ rɑrɑɛ si ɑjɔ ɑkɑ̃, nɔ isɛ ɡbɛɛjeu fei wɑ ce tuubɑi dulum dɛɛ, ɑwɔ mɔ kpɑ idei dulum dɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Woo bɛ ŋɑu ɑ̀ sɔ̃ Lɑfɛ̃ɛ ɑ̀ ni, kɔ̃ɔsi nɑɑnɛ ku dɑsi nwɑ. ");
INSERT INTO mkl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ŋɔi Lɑfɛ̃ɛ í ni, bɑɑ bii nɑɑnɛ ku dɑsi nŋɛ í munɡɑu ijui iyɑku, ɑɑ yɔkɔ i sɔ̃ jĩi nɔu ihɛ̃ i ni ku wu hɑi bɛ, koo lɔ ɑrɑɛ si tenku, ɑ́ nɔ ku ceò ide nŋɛ icɛ. ");
INSERT INTO mkl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesu í ni mɑ́, inɛ kɑ̃mɑ nŋɛ bii í nɛ ɑru iyi wɑ loɡoo wɑlɑkɔ wɑ deɡbeɑ kɛtɛ ŋɑ, bii í bɑɑ kpɑsɛ̃ kɑɑ sɔ̃ɔ ku ni, nɑɑ wɑ nsɛi i bubɑ i jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ammɑ ɑ́ sɔ̃ɔi ku ni, ceem sɔɔlui ijɛ, kpɑɑsi jɑɑɛ ŋɑ, i nɑɑm ijɛ wɑ hee n jɛ n mɔ. Si ɑnyiɛ, ɑwɔ mɔ ɑɑ jɛ nɔ i mɔ. ");
INSERT INTO mkl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ammɑ kɑɑ sɑɑbu ɑruu si nɑ iyi í jɔ̀ í ce bɛi í sɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bɛɛbɛ mɔi bii iŋɛ tɑkɑ nŋɛ ì ce mii iyi ɑ̀ dɑsi ŋɛ fei í sĩɑ i ni ŋɑ, ɑ̀ jɛ ɑmɑɑcɛ ŋɑ iyi ɑ kù nɛ sɑɑbu. Iyi ɑ̀ dɑsi wɑ ku ce nŋu ɑkɑ̃i ɑ̀ ce. ");
INSERT INTO mkl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Si wɑɑti iyi Jesu wɑ bɔ ikpɑ ilui Zeruzɑlɛmu, í too si ɑfei ilɛi Gɑlilee do ilɛi Sɑmɑri. ");
INSERT INTO mkl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ŋɔi í mɑɑi ilu ɡɔ. Wɑɑti iyi wɑ bi ku lɔ inɔ iluu, ŋɔi dintɛ mɛɛwɑ ɡɔ ŋɑ ɑ̀ koo ɑ̀ kòo ɑmmɑ ɑ̀ leekĩ ɑ̀ jĩiɛ keeke. ");
INSERT INTO mkl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ŋɔi ɑ̀ dɔ̃ ɑnu hee lele ɑ̀ ni, Jesu, Mɛɛtu, ce ɑrɑɑre nwɑ. ");
INSERT INTO mkl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iyi í yɛ ŋɑ ŋɔi í ni, i koo i nyisi ɑrɑ nŋɛ bi woo weei Ilɑɑɔ̃ ŋɑ. Ŋɔi ɑ̀ wɑɑ koo. Si bɛi ɑ̀ wɑɑ nɛu, ŋɔi ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iyi inɛ ɑkɑ̃ nŋɑ í yɛ nŋu í bɑ iri, ŋɔi í sindɑ wɑ bɑɑ wɑ sɑɑbuò Ilɑɑɔ̃ hee lele. ");
INSERT INTO mkl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wɑɑti iyi í to wɑ bi Jesu nɔ í sɛɛbɑtɑ si wɑjuɛ wɑ sɑɑbuɛ. Wee mɔkɔu inɛi Sɑmɑrii. ");
INSERT INTO mkl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ŋɔi Jesu í ni, ɑmɑnɛ mɛɛwɑ si ǹ jɔ̀ í bɑ iri bɑ. To, iwoi ɑmɑnɛ mɛɛsɑ̃ iyi ɑ̀ ɡbe ŋɑu ɑ̀ wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Isɛ mmuu ihɛ̃ nŋu ɑkɑ̃i í sindɑ wɑ ku sɑɑbu Ilɑɑɔ̃? ");
INSERT INTO mkl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ŋɔi í sɔ̃ mɔkɔu í ni, dede i nɛ, nɑɑnɛ ku dɑsiɛi í fɑɑbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ŋɔi Fɑrisi ŋɑu ɑ̀ bee Jesu ɑ̀ ni, ɑjɔ yoomɑi Ilɑɑɔ̃ ɑ́ nɑ ku jɛ bommɑɛ. Ŋɔi í jɛ nŋɑ í ni, Ilɑɑɔ̃ kɑɑ jɛ bommɑɛ do yɑɑse bɛi inɛ ŋɑ ɑɑ yɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Inɛ ɡɔ kɑɑ fɔ ku ni, Ilɑɑɔ̃ í jɛ bommɑɛ ikpɑ ihɛ̃, wɑlɑkɔ ikpɑ ihɔ̃. Aɑwo, domi wee Ilɑɑɔ̃ í jɛ bommɑɛ tɑ̃ si idɔi inɛ ŋɑ . ");
INSERT INTO mkl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nɔ í sɔ̃ mɔcɔ ŋɑu í ni, ɑwɑɑti wɑ nɑɑ iyi ɑmu Amɑi Amɑnɛ ɑn nyi wɑ do ɑmboem. Hee ɑjɔu ku mɑɑ to wɑ ɑwɑɑti wɑ nɑɑ iyi ɑɑ bi i yɛm ŋɑ bɑɑ ɑjɔ ɑkɑ̃, ɑmmɑ i kɑɑ yɛm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Inɛ ɡɔ ŋɑ ɑɑ sɔ̃ ŋɛ ɑ ni, í wɑ ihɛ̃ wɑlɑkɔ í wɑ ihɔ̃. I mɑɑ̀ sɛi i koo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ǹ wɑ n sɔ̃ ŋɛi, bɛi kuŋɔi ijĩ í yɑ dɑɑnɑ hɑi lele ɑnu ɑkɑ̃ koo kɑ̃ ilɛu bɛ, bɛɛbɛ mɔi kubɑɑi ɑmu Amɑi Amɑnɛ ɑ́ yɛ. ");
INSERT INTO mkl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ammɑ sinte titɑ̃ kù nɛ bɛi ɑn ce iyi n kù yɛ ijuukpɑ̃ ntɔ ntɔ nɔ inɛi nsɛi ŋɑu ihɛ̃ ɑɑ kɔsim. ");
INSERT INTO mkl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mii iyi í ce si wɑɑtii Noweeu, bɛɛbɛ mɔi ɑ́ ce si wɑɑti iyi ɑmu Amɑi Amɑnɛ ɑn nyi wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Inɛ ŋɑ ɑ̀ jɛ ɑ̀ wɑɑ mɔ, ɑ̀ wɑɑ ce ɑbɔdɔ̃ ŋɑ, ɑ̀ yɑ mɑɑ muɑ ɑmɑ nŋɑ ŋɑ mɔkɔ hee í koo í to ɑjɔ iyi Nowee í lɔ ɑkɔi inyiu. Nɔ ijĩ nlɑu í nɑɑ í jɛ ɑŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Á nyi ku cei mɑ́ bɛi wɑɑtii Lɔtuu. Inɛ ŋɑ ɑ̀ jɛ ɑ̀ wɑɑ mɔ, ɑ̀ rɑ ɑ̀ wɑɑ tɑ, ɑ̀ wɑɑ ɡbɛ̃, nɔ ɑ̀ wɑɑ mɑ ile. ");
INSERT INTO mkl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ammɑ si ɑjɔ iyi Lɔtu í fitɑ hɑi Sodomu, inɑ do fɑinwitɑ wɑ rɔ wɑi hɑi lele nɔ ɑŋɑ fei ɑ̀ ce nfe. ");
INSERT INTO mkl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nɔ bɛɛbɛ mɔi ɑ́ yɛ ɑjɔ iyi ɑmu Amɑi Amɑnɛ ɑn fɑɑtɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Si ɑjɔ nŋu, inɛ iyi í wɑ ɑntɑi ile sikifɑ nɔ nyɑuɛ ŋɑ í wɑ inɔ ile, kɑɑ bɑ ku lɔ ku soo mɑ́. Inɛ mɔ iyi í wɑ iko kɑɑ bɑ ku bɑɑ ide mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","I ye ɡiɡii ɑboi Lɔtu. ");
INSERT INTO mkl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Inɛ iyi í bi ku jɛ ɑndunyɑ do idɔɔbiɛ ɑ́ nɑ ku kuɑɛ. Ammɑ inɛ iyi í kɔsi kuwɛɛɛ ɑ́ bɑ́ɑ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","An sɔ̃ ŋɛ si idũ ɑjɔ nŋu, ɑmɑnɛ minji ɑ́ mɑɑ sũ si dɑɑyi ɑkɑ̃, ɑɑ so inɛ ɑkɑ̃ ɑ jɔ̀ inɛ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Inɑɑbo minji ɑ́ mɑɑ lɔlɔ ɑɑ so inɛ ɑkɑ̃ ɑ jɔ̀ inɛ ɑkɑ̃.  ");
INSERT INTO mkl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Inɛmɔkɔ minji ɑ́ wɑ iko, ɑɑ so inɛ ɑkɑ̃ ɑ jɔ̀ inɛ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ŋɔi mɔcɔ ŋɑu ɑ̀ beeɛ ɑ̀ ni, ikpɑ iwoi ideu bɛ ɑ́ ce yɑ Lɑfɛ̃ɛ. Ŋɔi í jɛ nŋɑ do mɔndɑu ihɛ̃ í ni, bii iku wɑ sũ, tenɡi bɛi yembeeku ŋɑ ɑ̀ yɑ tɔtɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesu í kpɑ nŋɑ mɔndɑu ihɛ̃ ku nyisi ŋɑ iyi í sĩɑ ɑ mɑɑ ce kutɔɔ wɑɑti kɑ̃mɑ fei, ɡbɛɛji ku mɑɑ̀ wɑ si. ");
INSERT INTO mkl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Í ni, woo kiiti ɡɔ í wɑ si ilu nlɑ ɡɔ, kù wɑɑ ce njoi Ilɑɑɔ̃, kù nɔ kù wɑɑ jirimɑ inɛ kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wee si ilu ɑkɑ̃u jɑɑɔ̃ ɡɔ mɔ í wɑ bɛ. Í yɑ nɑɑ ɑjɔò ɑjɔ bi tɛɛ ku sɔ̃ɔ ku ni, kiitim, ɑmu do mbɛɛm. ");
INSERT INTO mkl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ŋɔi í kɔ hee í kpɛ. Ammɑ si ɑnyiɛ í lɑsɑbu si idɔɛ í ni, bɑɑ bii n kù wɑ n ce njoi Ilɑɑɔ̃, nɔ n kù wɑ n jirimɑ inɛ ɡɔ, ");
INSERT INTO mkl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","do nŋu fei, si nɑ iyi í jɔ̀ jɑɑɔ̃u ihɛ̃ í yɑ mɑɑ bitɑndim, ɑn ceɑɑ kiitiu nŋu do mbɛɛɛ, ku bɑ ku mɑɑ̀ bitɑndim mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ŋɔi Lɑfɛ̃ɛ í ni, to, i ɡbɔ bɛi woo kiiti lɑɑlɔu í fɔ bɛ ŋɑ de. ");
INSERT INTO mkl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ilɑɑɔ̃ kɑɑ bɛi ku ce ku re zɑkɑ bɛɛbɛ? Inɛ ŋɑ iyi í cicɑ, kɑɑ kiiti ŋɑ bii ɑ̀ wɑɑ dɔ̃ siɛ ɑnu dɑsɑ̃ do idũ? Iyi í re mɔm, kɑɑ kpɛ ku bɛi ku ɡbɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ǹ wɑ n sɔ̃ ŋɛi, ɑ́ ce nŋɑ kiitii ɡbɑ̃ɑ ɡbɑ̃ɑ. Ammɑ wɑɑti iyi ɑmu Amɑi Amɑnɛ ɑn nyi wɑ mɑ́ ɑn nɑ n bɑ nɑɑnɛ ku dɑsi si ilɛu ihɛ̃? ");
INSERT INTO mkl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesu í kpɑ mɔndɑ ɡɔ mɑ́ nɑ irii inɛ ɡɔ ŋɑ iyi ɑ̀ wɑɑ cɔ ɑrɑ nŋɑ inɛ dee dee, nɔ ɑ̀ wɑɑ cɑ inɛ ɡɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Í ni, ɑmɑnɛ minji ɡɔ ŋɑ ɑ̀ bɔ ku tɔɔ kpɑsɛ̃i Ilɑɑɔ̃, inɛ ɑkɑ̃ Fɑrisii, inɛ ɑkɑ̃ mɔ woo ɡbɑ fiɑi lɛmpooi. ");
INSERT INTO mkl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fɑrisiu í leekĩ wɑ ceɑ ɑrɑɛ kutɔɔ wɑ ni, Ilɑɑɔ̃, ǹ sɑɑbuɛ do iyi n kù yɛ bɛi inɛ ŋɑ iyi ɑ̀ ɡbe, iyi ɑ̀ jɛ woo tɑki inɛ ŋɑ, do woo ce lɑɑlɔ ŋɑ, do woo ce sɑkɑrɑ ŋɑ, do woo ɡbɑ fiɑi lɛmpoo ŋɑ bɛi mɔkɔu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Si ɑzumɑ ɑkɑ̃ fei ǹ yɑ n dĩ ɑnu ɑjɔ minji, nɔ mii iyi ǹ bɑ fei ǹ yɑ n nyɑ zɑɡɑɑɛi si bɛi í jɔ. ");
INSERT INTO mkl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Woo ɡbɑ fiɑi lɛmpoou mɔ í leekĩ í mu ɑrɑɛ ikɑ̃, kù yɔkɔ kù wu iju lele, í le ɑwɔ si iri í ni, Ilɑɑɔ̃, ce ɑrɑɑrem ɑmu ilu dulum. ");
INSERT INTO mkl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesu í ni, ǹ wɑ n sɔ̃ ŋɛi, hɑi bɛ inɛɛu ihɛ̃ í bɑɑ í jɛ dee dee si wɑjui Ilɑɑɔ̃ í nyiò ideɛ. Ammɑ Fɑrisiu kù jɛ dee dee, domi inɛ iyi í so ɑrɑɛ lele ɑɑ kɑye lɑfɛ̃ɛi, inɛ mɔ iyi í kɑye ɑrɑɛ ɑɑ soo lelei. ");
INSERT INTO mkl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Si ɑnyii nŋu, inɛ ŋɑ ɑ̀ ɡbɑ̃ ɑmɑ kpɔtɔɔ ŋɑ ɑ̀ nɑɑɑ Jesu wɑ ku lesi ŋɑ ɑwɔ. Iyi mɔcɔɛ ŋɑu ɑ̀ yɔɔ bɛɛbɛ ŋɔi ɑ̀ wɑ ɡbɑɡbɑ si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ammɑ Jesu í ni ɑ nɑɑ nŋu ɑmu ŋɑu wɑ. Nɔ í sɔ̃ mɔcɔɛ ŋɑu í ni, i jɔ̀ ɑmu ŋɑu ɑ nɑɑ bi tom, i mɑɑ̀ ɡɑnji ŋɑ, domi Ilɑɑɔ̃ í jɛ ilɑɑlui inɛ ŋɑ iyi ɑ̀ jɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ntɔ ntɔ, inɛ iyi kù wɑɑ sũɑ Ilɑɑɔ̃ iri ilɛ bɛi ɑmɑ keeke, Ilɑɑɔ̃ kɑɑ jɛ ilɑɑluɛ pɑi. ");
INSERT INTO mkl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Inɛ nɡboi Zuifu ɡɔ í nɑɑ bi Jesu í beeɛ í ni, Mɛɛtu, ɑwɔ inɛ ncɛɛ, mii ɑn ce n bɑò kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ŋɔi Jesu í beeɛ í ni, nɑ mii í ce ì wɑɑ kpem inɛ ncɛɛ. Inɛ ɡɔ kù wɛɛ iyi í jɛ ncɛɛ bii kù jɛ Ilɑɑɔ̃ nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ì mɑ̀ sɑ̃ɑ sɑ̃ɑ mii iyi woodɑ í ni. Mii iyi woodɑ í ni wee, mɑɑ̀ ce sɑkɑrɑ, mɑɑ̀ kpɑ inɛ, mɑɑ̀ ce ile, mɑɑ̀ jɛɑ inɛ ɡɔ sɛɛdɑ ibo, jirimɑ iyeò bɑɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ŋɔi inɛɛu í ni, ǹ wɑ n jirimɑ mii ŋɑu bɛ fei tɑ̃ hɑi keekem. ");
INSERT INTO mkl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iyi Jesu í ɡbɔ bɛɛbɛ, ŋɔi í sɔ̃ɔ í ni, í ɡbeɛ mii ɑkɑ̃. Koo i tɑ mii iyi ì nɛ fei nɔ i kpɛ̃ɑ ilu ɑre ŋɑ fiɑu. Bii ì ce bɛɛbɛ ɑɑ bɑ ɑmɑni jiidɑ lelei Aɔ̃. Si ɑnyiɛ nɔ i nɑɑ i toom. ");
INSERT INTO mkl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Iyi mɔkɔu í ɡbɔ bɛɛbɛ ŋɔi inɔɛ í fɔ ntɔ ntɔ, domi ilu ɑmɑni nlɑ nlɑi. ");
INSERT INTO mkl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iyi Jesu í cɔɔ ŋɔi í ni, ɑ́ ɡɑɑbu hee ku cɑɑ ilu fiɑ ku jɛsi Ilɑɑɔ̃ ku jɛ ilɑɑluɛ. ");
INSERT INTO mkl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Á fɑɑlɑɑ kpookpo ku lɔ si iwoi ɑbɛɛ do iyi ilu ɑmɑni ɑ́ jɛsi Ilɑɑɔ̃ ku jɛ ilɑɑluɛ. ");
INSERT INTO mkl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ŋɔi inɛ ŋɑ iyi ɑ̀ wɑɑ de siɛ itĩu ɑ̀ ni, bii bɛɛbɛi nɔ yooi ɑ́ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nɔ Jesu í sɔ̃ ŋɑ í ni, mii iyi ɑmɑnɛ í mɔnɡɔ, Ilɑɑɔ̃ kɑɑ mɔnɡɔɛ. ");
INSERT INTO mkl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ŋɔi Piɛɛ í ni, wee ɑ̀ jɔ̀ mii iyi ɑ̀ nɛ fei tɑ̃, ɑ̀ wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nɔ Jesu í ni, ntɔ ntɔ, inɛ iyi í jɔ̀ kpɑsɛ̃ɛ fei, wɑlɑkɔ ɑboɛ, wɑlɑ iɡbɑ̃ do ifɔɛ ŋɑ, wɑlɑ iyeò bɑɑɛ, wɑlɑ ɑmɑɛ ŋɑ, nɑ irii bommɑi Ilɑɑɔ̃, ");
INSERT INTO mkl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ɑ́ bɑ ku kpɔ ku re si nsɛi, nɔ si ɑntɑɛ mɑ́ ɑ́ bɑ kuwɛɛ hɑi tɑ̃ ɑlɑ. ");
INSERT INTO mkl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu í kpe mɔcɔ mɑɑteeji ŋɑu bi tɛɛ, nɔ í sɔ̃ ŋɑ í ni, wee ɑ̀ wɑɑ bɔ Zeruzɑlɛmu. Bɛi, ide iyi wɑlii ŋɑu ɑ kɔ nɑ irii ɑmu Amɑi Amɑnɛu fei ɑ́ ce. ");
INSERT INTO mkl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aɑ mum ɑ dɑɑ dimi mmu ŋɑ si ɑwɔ ɑ yɑɑkoom, nɔ ɑ kpɑ̃m iju ɑ tu sim ɑntɔ. ");
INSERT INTO mkl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Aɑ weem kpɔtɔɔ, si ɑnyiɛ nɔ ɑɑ kpɑm, ɑmmɑ si ɑjɔ mɛɛtɑsiɑ ɑn jĩ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ammɑ mɔcɔ ŋɑu ɑ kù mɑ̀ nkɑ̃mɑ si ideu. Ideu í mɑnji nŋɑ ɑ kù ɡbɔ yɑɑseɛ. ");
INSERT INTO mkl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Si isɛɛnɛu Jesu í mɑɑi Zeriko. Wee fɛɛju ɡɔ wɑ bubɑ itĩ kpɑ̃ɑ wɑ bɑrɑ. ");
INSERT INTO mkl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Iyi í ɡbɔ ibɑi zɑmɑɑ iyi wɑ lɔ, ŋɔi í bee mii í ce. ");
INSERT INTO mkl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, Jesu inɛi Nɑzɑrɛtiui wɑ lɔ. ");
INSERT INTO mkl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ŋɔi í wɑsi ku dɔ̃ ɑnu wɑ ni, Jesu, tɔkui Dɑvidi, ce ɑrɑɑrem. ");
INSERT INTO mkl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Inɛ ŋɑ iyi ɑ̀ wɑɑ cuɑ ŋɑu ɑ̀ lɑ siɛ ɑ̀ ni ku coko. Ammɑ bɛi ɑ̀ wɑɑ ni ku cokou, bɛɛbɛ mɔi í yɑ dɔ̃ ɑnu hee lele ku mɑɑ ni, tɔkui Dɑvidi, ce ɑrɑɑrem. ");
INSERT INTO mkl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ŋɔi Jesu í leekĩ í ni ɑ nɑɑɛ wɑ. Iyi fɛɛjuu í to wɑ ŋɔi Jesu í beeɛ í ni, ");
INSERT INTO mkl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","mii ì bi n ceeɛ. Ŋɔi í ni, Lɑfɛ̃ɛ, ǹ bi n yɛ ilui. ");
INSERT INTO mkl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ŋɔi Jesu í sɔ̃ɔ í ni, yɛ ilu. Nɑɑnɛɛ í fɑɑbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ŋɔi ɡbɑkɑ̃ í yɛ ilu, nɔ wɑ too Jesu í wɑsi Ilɑɑɔ̃ ku sɑɑbu. Iyi zɑmɑɑu í yɔɔ, ŋɔi ɑŋɑ fei ɑ̀ wɑsi Ilɑɑɔ̃ ku sɑɑbu. ");
INSERT INTO mkl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu í to inɔ ilu Zeriko, nɔ wɑ lɔ. ");
INSERT INTO mkl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wee mɔkɔ ilu fiɑ ɡɔ í wɑ bɛ ɑ̀ yɑ kpoo Zɑkee, wɑ jɛ inɛ nɡboi woo ɡbɑ fiɑi lɛmpoo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nɔ wɑ dɛ nŋu ku yɛ Jesu, ɑmmɑ kù bɑ kù yɔɔ nɑ zɑmɑɑu, domi nŋu ɑmɑnɛ kɑndɑɑi. ");
INSERT INTO mkl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ŋɔi í sɛi í bɔ wɑju í koo í ɡũ jĩi ndii sikomɔɔ ɡɔ ku bɑ ku yɔɔ, domi í mɑ̀ iyi do bɛi ɑ́ lɔò. ");
INSERT INTO mkl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iyi Jesu í to tenɡi bii í wɑu, ŋɔi í wu iju lele í sɔ̃ɔ í ni, Zɑkee, kitɑ wɑ ńyɑ ńyɑ, domi kpɑsɛ̃ɛi ɑn sɔ nnyi. ");
INSERT INTO mkl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nɔ Zɑkee í kitɑ wɑ do sɑɑsɑ í nɑɑ í ɡbɑɑ do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Iyi inɛ ŋɑ ɑ̀ yɔɔ, ŋɔi ɑŋɑ fei ɑ̀ ɡbɑɡbɑ ɑ̀ wɑɑ ni, í koo í sɔ kpɑsɛ̃i ilu dulum. ");
INSERT INTO mkl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ammɑ Zɑkee í dede í leekĩ si wɑjui Lɑfɛ̃ɛ í ni, bubui ɑmɑnim ɑn nɑ ilu ɑre ŋɑ. Nɔ inɛ ŋɑ iyi ǹ tɑkii ŋɑ ǹ ɡbɑ mii ndu ŋɑ, ɑn sindo nŋɑ bɛɛbɛ mɑ́ tuubɑ mɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nɔ Jesu í sɔ̃ɔ í ni, nnyi inɛi kpɑsɛ̃ ŋɑu ihɛ̃ ɑ̀ bɑ fɑɑbɑ, domi ɑwɔ mɔ tɔkui Aburɑhɑmui. ");
INSERT INTO mkl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Amu Amɑi Amɑnɛ ǹ nɑɑ ku dɛdɛ inɛ ŋɑ iyi ɑ̀ nyɔi n fɑɑbɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Si bɛi inɛ ŋɑ ɑ̀ wɑɑ de si ideu itĩ, nɔ í kpɑ mɔndɑ ɡɔ mɑ́. Inɛ ŋɑu ɑ̀ wɑɑ tɑmɑɑ bɛi bii í to Zeruzɑlɛmu ɑ́ jɛ bommɑi ɡbɑkɑ̃, nɔ wee wɑɑti bɛɛbɛ í mɑɑi Zeruzɑlɛmu. Nɑ ŋɔi í jɔ í kpɑ nŋɑ mɔndɑu ihɛ̃ ku bɑ ku nyisi iyi nŋu kɑɑ jɛ bommɑu ɡbɑ̃ɑ ɡbɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Í ni, mɔkɔ ɑmɑi ɑmɑnlu ɡɔi í bɔ bommɑ ku jɛ hee ilɛ jĩijĩ ɡɔ si ɑnyiɛ nɔ ku bɑɑ ideɛ. ");
INSERT INTO mkl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hee ku mɑɑ nɛ ŋɔi í kpe ɑmɑɑcɛɛ ŋɑ ɑŋɑ mɛɛwɑ, nɔ í nɑ ɑŋɑ fei kpɛkɛlɛi wurɑ ɡɔ nɔ í ni, i ceò fiɑu ihɛ̃ sĩɑ hee n mɑɑ n bɑɑ. Iyi í fɔ bɛɛbɛ í tɑ̃ nɔ í nɛ. ");
INSERT INTO mkl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ammɑ inɛi ilɛɛ ŋɑ ɑ̀ cóo nɔ ɑ̀ bɛ inɛ ŋɑ si ɑnyiɛ ɑ̀ ni ɑŋɑ ɑ kù bi ku jɛ bommɑ si ilɛi ɑŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Wɑɑti iyi í jɛ bommɑu í bɑɑ si ilɛɛ, ŋɔi í kpe ɑmɑɑcɛ ŋɑ iyi í nɑ fiɑu wo bi tɛɛ ku bɑ ku yɛ bɛi fiɑi inɛ fei í bíɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Inɛ sinteu í nɑɑ í ni, Lɑfɛ̃ɛ, kpɛkɛlɛ iyi ì nɑm nɔu ǹ ceò sĩɑ hee ǹ bɑ ribɑ mɛɛwɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ŋɔi í sɔ̃ɔ í ni, í sĩɑ, ɑwɔ ɑmɑɑcɛ jiidɑi. Si bɛi ì jɛ ilu nɑɑnɛ si mii keekeu ihɛ̃, ɑn jɔ̀ í jɛ ilɑɑlu si ilu mɛɛwɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Inɛ minjisiɑu mɔ í nɑɑ í ni, Lɑfɛ̃ɛ, kpɛkɛlɛ iyi ì nɑm nɔu ǹ ceò sĩɑ hee ǹ bɑ ribɑ miu. ");
INSERT INTO mkl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nɔ í sɔ̃ɔ í ni, ɑwɔ mɔ, ɑn ceɛ ilɑɑlu si ilu miu. ");
INSERT INTO mkl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nɔ inɛ mmu í nɑɑ mɑ́ í ni, Lɑfɛ̃ɛ, fiɑɛ wee. Ǹ wooi si mɑnɡo ");
INSERT INTO mkl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","domi ǹ wɑ n ce njoɛ si nɑ iyi í jɔ̀ ì jɛ inɛ ku ɡɑɑbu. Mii iyi i kù jilɛ nŋui i yɑ mɑɑ dɛ ku so, bɑɑ bii i kù ɡbɛ̃ ì yɑ mɑɑ dɑi. ");
INSERT INTO mkl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ŋɔi ilɑɑluu í sɔ̃ɔ í ni, ɑwɔ ɑmɑɑcɛ yɑɑmɔ, ɑn kiitiɛi hɑi si ideɛ iyi ì fɔ. Awɔi ì mɑ̀ iyi ǹ jɛ inɛ ku ɡɑɑbu, ǹ yɑ n so mii iyi n kù jilɛ, nɔ n dɑ mii iyi n kù ɡbɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","To, nɑ mii í ce i kù ni i wɛ̃ɑ inɛ ŋɑ fiɑm nɔu i dɑ nŋɑ si inyi ku bɑ n bɑ ndom do ribɑ wɑɑti iyi ǹ bɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ŋɔi í sɔ̃ inɛ ŋɑ iyi ɑ̀ wɑ bɛu í ni ɑ ɡbɑ fiɑu ɑ nɑ ilu mɛɛwɑu. ");
INSERT INTO mkl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, Lɑfɛ̃ɛ, inɛ nŋu í nɛ mɛɛwɑ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ŋɔi í ni, ǹ wɑ n sɔ̃ ŋɛi, inɛ iyi í nɛ, lɑfɛ̃ɛi ɑɑ kɔ̃ɔɑ si. Inɛ mɔ iyi kù nɛ, bɑɑ ɑndi keeke iyi í nɛu mɔm ɑɑ ɡbɑɑi. ");
INSERT INTO mkl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Si ɑnyiɛ nɔ í ni, i koo i nɑɑm mbɛɛm ŋɑu wɑ ihɛ̃, ɑŋɑ iyi ɑ kù bi n jɛ bommɑu, nɔ i kpɑ ŋɑ si wɑjum. ");
INSERT INTO mkl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃, ŋɔi í mu kpɑ̃ɑ í cuɑɑ zɑmɑɑu wɑ bɔ ikpɑ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Si isɛɛnɛɛu í mɑɑi ilui Bɛtifɑze do Betɑni, kɔkɔi ɡeetei Olivie. Ŋɔi í bɛ mɔcɔ minjiɛ ɡɔ ŋɑ ");
INSERT INTO mkl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","í sɔ̃ ŋɑ í ni, i bɔ ilu iyi í wɑ wɑju nŋɛu bɛ. Bii ì to bɛ ŋɑ ɑɑ yɛ ɑmɑ ɡbɑnkɛlɛ ɡɔ wɑ so bɛ iyi inɛ ɡɔ kù ɡũu titɑ̃. I fũu i nɑɑm wɑ ihɛ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nɔ bii inɛ ɡɔ í bee ŋɛ í ni, nɑ mii í ce ì wɑɑ fũu ŋɑ, i ni, Lɑfɛ̃ɛi í nɛ bukɑɑtɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Inɛ ŋɑ iyi Jesu í bɛu ɑ̀ koo ɑ̀ bɑ mii ŋɑu fei í ce si bɛi í sɔ̃ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Si wɑɑti iyi ɑ̀ wɑɑ fũu, ilu ɡbɑnkɛlɛ ŋɑu ɑ̀ ni, bɛirei í ce ì wɑɑ fũu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ŋɔi ɑ̀ ni, Lɑfɛ̃ɛi í nɛ bukɑɑtɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ŋɔi ɑ̀ nɑɑɑ Jesu ɑmɑ ɡbɑnkɛlɛu wɑ. Nɔ ɑ̀ tɛ si ibɔ nŋɑ ŋɑ Jesu í bɛi í ɡũ ɑntɑɛ í bubɑ si. ");
INSERT INTO mkl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iyi í sinti ku nɛ, ŋɔi inɛ ŋɑ ɑ̀ wɑsi ku tɛ ibɔ nŋɑ ŋɑ si kpɑ̃ɑu. ");
INSERT INTO mkl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iyi í mɑɑi Zeruzɑlɛmu tenɡi bii kpɑ̃ɑi ɡeetei Olivieu í sinti ku dɑsi lɔɔmɑ, ŋɔi mɔcɔɛ ŋɑu fei ɑ̀ wɑɑ dɔ̃ ɑnu ɑ̀ lɔsi Ilɑɑɔ̃ ku sɑɑbu do inɔ didɔ̃ nɑ irii mɑɑmɑɑke ŋɑ iyi ɑ̀ yɛu fei. ");
INSERT INTO mkl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","À wɑsi ku ni, Ilɑɑɔ̃ ku weeɑ ilɑɑlu iyi wɑ nɑɑ do irii Lɑfɛ̃ɛ. Ilɑɑɔ̃ ku jɔ̀ lɑɑkɑi ku sũ ku wɑ lele nɔ ku nyisi ɑmboeɛ. ");
INSERT INTO mkl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hɑi si inɔ zɑmɑɑu Fɑrisi ɡɔ ŋɑ ɑ̀ sɔ̃ Jesu ɑ̀ ni, Mɛɛtu, sɔ̃ mɔcɔɛ ŋɑu ɑ coko. ");
INSERT INTO mkl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ŋɔi Jesu í ni, ǹ wɑ n sɔ̃ ŋɛ, bɑɑ bii inɛ ihɛ̃ ŋɑ ɑ̀ coko, kutɑ ŋɑ ɑɑ dɔ̃ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Si bɛi Jesu í mɑɑi Zeruzɑlɛmu, ŋɔi í yɛ iluu nɔ wɑ kpɑtɑɑ inɛɛ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ǹ bi wo i mɑ̀ ŋɑ mii iyi ɑ́ mu nŋɛ lɑɑkɑi ku sũ, bɑɑ nnyi. Ammɑ nsɛi í mɑnji nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Awɑɑti wɑ nɑɑ si ŋɛ iyi mbɛɛ nŋɛ ŋɑ ɑɑ bu ilu nŋɛ koe, ɑɑ bii si ŋɛ ɑ mɑnte ŋɛ cɑnɡɑ do njɛ. ");
INSERT INTO mkl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aɑ lɛɡɛ ilu nŋɛ do iŋɛ inɛɛ ŋɑ iyi ì wɑ inɔɛ ŋɑ. A kɑɑ jɔ̀ kutɑ bɑɑ ɑkɑ̃ ku le si njɛ ɑjɔ nŋu. Bɛɛbɛi ɑ́ ce si nɑ iyi í jɔ̀ Ilɑɑɔ̃ í nɑɑ bi tu ŋɛ nɔ i kù mɑ̀ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Wɑɑti iyi ɑ̀ to Zeruzɑlɛmu Jesu í bɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃. Nɔ í lɔsi ku lele woo tɑ iwò ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Í sɔ̃ ŋɑ í ni, ɑ̀ kɔɔ ɑ̀ ni, Ilɑɑɔ̃ í ni ilei nŋu ile bi ku tɔɔi ɑ́ jɛ. Ammɑ iŋɛ wee ì coo bi ku tɔtɔɔi ile ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesu í yɑ mɑɑ kɔɑ inɛ ŋɑ si cioi idei Ilɑɑɔ̃ ɑjɔ fei kpɑsɛ̃i Ilɑɑɔ̃ bɛ. Ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ do ilu irii inɛi Zuifu ŋɑ ɑ̀ wɑɑ bi ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ammɑ ɑ kù mɑ̀ bɛirei ɑɑ ce, domi inɛ feii í yɑ mɑɑ de si ideɛ itĩ do lɑɑkɑi. ");
INSERT INTO mkl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ajɔ nŋu ɡɔ si bɛi Jesu wɑ kɔ zɑmɑɑu si cio bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ wɑ sisi lɑɑbɑɑu jiidɑu, ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ do inɛ nɡbo ŋɑ ɑ̀ fɑɑtɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nɔ ɑ̀ ni, sɔ̃ wɑ, yiiko yoomɑi ì wɑɑ ceò mii ŋɑu ihɛ̃, mɑ̀ yooi í nɑɛ kpɑ̃ɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ŋɔi í sɔ̃ ŋɑ í ni, ɑmu mɔ, ɑn bee ŋɛ ide ɡɔ. I sɔ̃m ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","hɑi iwoi Zɑ̃ɑ í bɑ yiiko iyi í dɑsiò inɛ ŋɑ inyi. Hɑi bi Ilɑɑɔ̃ de, mɑ̀ hɑi bi ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ŋɔi ɑ̀ wɑɑ busi njɛ ɑ̀ wɑɑ ni, bɛirei ɑɑ kɑ jɛɑɑ. Nsɛi nɔɔ, bii ɑ̀ jɛɑɑ ɑ̀ ni hɑi bi Ilɑɑɔ̃i, ɑ́ bee wɑ bɛirei í ce ɑ kù dɑsi Zɑ̃ɑ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bii ɑ̀ nɔ ɑ̀ ni hɑi bi ɑmɑnɛ ŋɑi, inɛ ŋɑ ɑɑ nɑ ɑ tɑ wɑ kutɑ domi inɛ fei í dɑsi nɑɑnɛ iyi Zɑ̃ɑ wɑliii. ");
INSERT INTO mkl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ŋɔi ɑ̀ jɛ ɑ̀ ni, ɑ kù mɑ̀ hɑi iwoi í bɑ yiikoɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nɔ Jesu í sɔ̃ ŋɑ í ni, ɑmu mɔ, n kɑɑ n sɔ̃ ŋɛ yiikoi inɛ iyi ǹ wɑ n ceò mii ŋɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Si ɑnyiɛ nɔ í kpɑɑ inɛ ŋɑ mɔndɑu ihɛ̃ í ni, inɛ ɡɔ í ce ikoɛ nɔ í lɔ si jĩi ndii rezɛ̃ɛ nɔ í ce kɑɑ í kɑɑkoɛò. Ŋɔi í so ɡɑɑnɔɔmɑ ŋɑ í dɑsi ŋɑ si ikou ɑ mɑɑ loɡooɛ, í bɛi í bɔ ilu koo kpɛ bɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wɑɑti iyi jĩi nɔu í so í to ku kɑ, ŋɔi í bɛ woo ce icɛ ɡɔ bi ɡɑɑnɔɔmɑ ŋɑu koo ɡbɑ iyi í jɛ ti nŋu wɑ. Nɔ ɡɑɑnɔɔmɑ ŋɑu ɑ̀ cɑ̃ɑ ɑ̀ leleɛ í nɛ ɑwɔ nɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nɔ ilu ikou í bɛ woo ce icɛ mmu mɑ́. Nɔ ɑ̀ cɑ̃ nŋu mɔ, ɑ̀ buu yɑkɑ yɑkɑ, ɑ̀ sindɑɛ ɑwɔ nɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nɔ í bɛ ɑmɑnɛ mɛɛtɑsiɑ wɑ mɑ́, nɔ ɑ̀ mɛɛ nŋu mɔ ɑ̀ bɛi ɑ̀ leleɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ŋɔi ilu ikou í ni, bɛirei ɑn ce. An bɛ ɑmɑ ɑkɑ̃m iyi ǹ bi jiidɑui. Aɑ yɔkɔ ɑ jirimɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ammɑ iyi ɡɑɑnɔɔmɑ ŋɑu ɑ̀ yɔɔ, ŋɔi ɑ̀ busi njɛ ɑ̀ wɑɑ ni, i cɔ inɛ iyi ɑ́ nɑ ku jɛ tubuu. Kɑ kpɑɑ ku bɑ ilɛu ku jɛ tu wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ŋɔi ɑ̀ muu ɑ̀ fitɑɛ hɑi inɔ kɑrɑu nɔ ɑ̀ kpɑɑ. Ŋɔi Jesu í ni, to, nsɛi, bɛirei ilu ikou tɑkɑɛ ɑ́ ce nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Á koo ku kpɑ ŋɑi, nɔ ku dɛ inɛ mmu ŋɑ ku dɑsi ŋɑ si ikou. Iyi ɑ̀ ɡbɔ ideu, ŋɔi ɑ̀ ni, Ilɑɑɔ̃ ku mɑɑ̀ ce bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ammɑ Jesu í cɔ ŋɑ, nɔ í ni, bii bɛɛbɛi, yoomɑi í jɛ yɑɑsei kukɔu ihɛ̃ si bɛi í ni, Kutɑ iyi woo mɑ ŋɑ ɑ̀ kɔsiu, Nŋui í bɑɑ í jɛ kutɑ sintei icui ileu. ");
INSERT INTO mkl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nɔ inɛ iyi í cuku si kutɑu fei, ɑ́ cɛi. Inɛ iyi í nɔ í bɑtɑ mɔ ɑ́ lɔlɔɛi nɛkɔ̃ nɛkɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Iyi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ ɡbɔ ideu ɡbɑkɑ̃ ŋɔi ɑ̀ wɑɑ dɛ bɛi ɑɑ ce ɑ mu Jesu. Ammɑ ɑ̀ wɑɑ ce njoi zɑmɑɑu. À wɑɑ bi ɑ muui domi ɑ̀ mɑ̀ iyi nɑ irii ɑŋɑi í kpɑ mɔndɑu. ");
INSERT INTO mkl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nŋui í jɔ̀ si fei ndɛɛ ɑ̀ yɑ mɑɑ ce lɑɑkɑɛ. Ŋɔi ɑ̀ bɛ siɛ woo zɑmbɑ ɡɔ ŋɑ iyi ɑ̀ yɛ bɛi inɛ jiidɑ ŋɑ ɑ koo ɑ cɔ lɑɑkɑɛ. À bɛ ŋɑi ku bɑ ɑ leɑɑ tɑɑi ide nɔ ɑ bɑ kpɑ̃ɑ ɑ muu ɑ dɑɑ ilu ilɛu si ɑwɔi nŋu iyi í nɛ ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Inɛ ŋɑu ɑ̀ sɔ̃ɔ ide ɑ̀ ni, Mɛɛtu, ɑ̀ mɑ̀ iyi ideɛ do cio iyi ì wɑɑ kɔ inɛ ŋɑ siu, fei ndɛɛ dee deei. I ci yɑ nɑ inɛ ɡɔ ntɔ nɑ kubi, ì wɑɑ nyisi inɛ ŋɑ kpɑ̃ɑi Ilɑɑɔ̃ si ntɔɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Á sĩɑ kɑ sɑ̃ɑ ilɑɑlu Sezɑɑ fiɑi lɛmpoo? Mɑ̀ kɑ mɑɑ̀ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ammɑ Jesu í mɑ̀ muɑfiti nŋɑ, nɔ í ni, ");
INSERT INTO mkl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","i nyisim kpɛkɛlɛ ɑkɑ̃ wɑ n cɔ. Fotooi yooi í wɑ si kpɛkɛlɛu ihɛ̃ nɔ irii yooi ɑ̀ kɔ si. Ŋɔi ɑ̀ ni, ti Sezɑɑi. ");
INSERT INTO mkl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, to, i sɑ̃ɑ Sezɑɑ iyi í jɛ tɛɛ ŋɑ. Nɔ i sɑ̃ɑ Ilɑɑɔ̃ mɔ iyi í jɛ tɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ŋɔi ɑ̀ mɔnɡɔ ku too ɑwɔ do ideɛ ŋɑ iyi wɑ fɔ si wɑjui zɑmɑɑu. Ŋɔi ɑ̀ biti do ide ŋɑ iyi í jɛò, nɔ ɑ̀ coko nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Si ɑjɔ ɑkɑ̃u Sɑdusi ɡɔ ŋɑ mɔ ɑ̀ nɑɑ bi Jesu. Aŋɑi ɑ̀ yɑ mɑɑ ni iku ŋɑ ɑ kɑɑ jĩ. Iyi ɑ̀ to bi tɛɛ ŋɔi ɑ̀ beeɛ ɑ̀ ni, ");
INSERT INTO mkl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mɛɛtu, ide iyi Moizi í kɔ nwɑ wee. Í ni bii inɛ ɡɔ í ku í jɔ̀ ɑboɛ, nɔ nŋu do ɑboɛ ɑ kù nɛ ɑmɑ, ifɔɛ ku so jɑɑɔ̃u ku bɑ ku bíɑ iɡbɑ̃ɛ ɑmɑ. ");
INSERT INTO mkl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wee inɛ mɛɛje ɡɔ ŋɑ ɑ̀ wɛɛ iyi ɑ̀ jɛ ɑmɑi bɑɑ ɑkɑ̃. Iɡbɑ̃ nŋɑ í so ɑbo nɔ í ku, kù nɛ ɑmɑ do ɑbou bɑɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ŋɔi inɛ minjisiɑu do mɛɛtɑsiɑu ɑ̀ so jɑɑɔ̃u. ");
INSERT INTO mkl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nɔ bɛɛbɛi í ce si ɡɑ̃mɛi ɑŋɑ mɛɛjeu fei, nɔ ɑ̀ ku. Kɑ̃mɑ nŋɑ kù bɑ ɑmɑ do ɑbou. ");
INSERT INTO mkl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nɔ si ɑnyiɛ ɑbou mɔ í nɑ í ku. ");
INSERT INTO mkl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","To, ɑjɔ iyi iku ŋɑ ɑɑ nɑ ɑ jĩ, ɑboi yoo nŋɑi ɑ́ jɛ, si bɛi ɑŋɑ mɛɛjeu fei ɑ̀ soo ɑboi. ");
INSERT INTO mkl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ŋɔi Jesu í jɛ nŋɑ í ni, si ɑndunyɑu ihɛ̃ inɛmɔkɔ do inɑɑbo ŋɑ ɑ̀ yɑ so njɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ammɑ inɛ ŋɑ iyi Ilɑɑɔ̃ í jɔ̀ ɑ̀ jĩ hɑi si bɑlɛ ɑ̀ bɑ kuwɛɛi ɑlɑ, ɑbo do mɔkɔ ŋɑ ɑ kɑɑ yɑ so njɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aɑ yɛi bɛi ɑmɑlekɑ ŋɑ, ɑ kɑɑ ku mɑ́. Aɑ jɛ ɑmɑi Ilɑɑɔ̃ ŋɑ si nɑ iyi í jɔ̀ ɑ̀ jĩ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Si wɑɑti iyi Moizi í yɛ ɑmɑ jĩi iyi í mu inɑ nɔ kù wɑɑ jou, nŋu tɑkɑɛ í fɔ mɑm mɑm iyi iku ŋɑ ɑɑ jĩ. Wɑɑti nŋu í kpe Ilɑɑɔ̃ Lɑfɛ̃ɛi Aburɑhɑmu do Izɑɑki do Zɑkɔbu. ");
INSERT INTO mkl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ntɔ ntɔ, Ilɑɑɔ̃ kù jɛ Lɑfɛ̃ɛi iku ŋɑ, ti ilu hunde ŋɑi, domi bi tɛɛ, inɛ fei ilu hundei. ");
INSERT INTO mkl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ŋɔi woo kɔ inɛ ŋɑ si woodɑ ŋɑu, ɡɔɡɔ ŋɑ ɑ̀ ɡbɑ ide ɑ̀ ni, ide iyi ì fɔu bɛ Mɛɛtu, dee deei. ");
INSERT INTO mkl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Si ɑnyiɛ ɑ kù jɛ ɑ kù beeɛ ide ɡɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nɔ Jesu í bee ŋɑ í ni, bɛirei ɑɑ ce ɑ ni inɛ iyi Ilɑɑɔ̃ í cicɑu tɔkui ilɑɑlu Dɑvidii. ");
INSERT INTO mkl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dɑvidi tɑkɑɛ í fɔ si tiɑi iri ku kɔ̃ɛ í ni, Aɔ̃ Lɑfɛ̃ɛ í sɔ̃ Lɑfɛ̃ɛm í ni, Bubɑ ɑwɔ njɛm, ");
INSERT INTO mkl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Hee n ce mbɛɛɛ ŋɑ bi ku lesi isɛɛ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","To, bii Dɑvidi tɑkɑɛ wɑ kpoo Lɑfɛ̃ɛ, bɛirei ɑ́ ce ku jɛ tɔkuɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Si bɛi inɛ fei wɑ de si Jesu itĩ, ŋɔi í sɔ̃ mɔcɔɛ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","i mu ɑrɑ nŋɛ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu, ɑŋɑ iyi ɑ̀ yɑ bi ɑ mɑɑ dɑbii do ibɔ kumboo, nɔ ɑ̀ bi ɑ yɑ ce ɑŋɑ fɔɔ do jirimɑ nlɑ nlɑ si bɑntumɑ. A ci yɑ bi kɑɑ kitɑ̃i inɛ nɡbo ŋɑ ile bi kutɔtɔɔ do inyɑ sinte bi ku ce jinɡɑu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","À yɑ tɑkii jɑɑɔ̃ ŋɑ ɑ ɡbɑ mii ndu ŋɑ ŋɑ fei, nɔ ɑ̀ yɑ mɑɑ ce kutɔɔ sisɔ ku bɑ ɑ yɛ ŋɑ nŋu ɑkɑ̃. Nɑ ŋɔi í jɔ̀ ijuukpɑ̃ nŋɑ ɑ́ lɑ ku cɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi í wu iju wɑ cɔ bɛi ilu fiɑ ŋɑ ɑ̀ wɑɑ dɑsi fiɑ si kpɑkoi kɔlɛtiu. ");
INSERT INTO mkl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nɔ í yɛ ɑbo jɑɑɔ̃ ilu ɑre ɡɔ mɔ í sɔsi kpɛkɛlɛ keeke minji ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ŋɔi í ni, ntɔ ntɔ, jɑɑɔ̃ ilu ɑreu ihɛ̃ í dɑsi fiɑ í re inɛ ŋɑ iyi ɑ̀ ɡbe fei. ");
INSERT INTO mkl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Inɛ ŋɑ iyi ɑ̀ ɡbe ŋɑu fei, iyi í lesi ɑntɑi fiɑ nŋɑ ŋɑi ɑ̀ dɑsi, ɑmmɑ ɑbou, bɑɑ do iyi í jɛ ilu ɑre, ɑndi iyi í nɛ feii í dɑsi bɛ, nkɑ̃mɑ kù ɡbeɑ iyi ɑ́ mɑɑ wɛɛò mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ajɔ nŋu ɡɔ inɛ ɡɔ ŋɑ ɑ̀ fɔ ɑ̀ wɑɑ ni kpɑsɛ̃i Ilɑɑɔ̃u í sĩɑ do kutɑɛ ŋɑ fei do ɑmuɑ ŋɑ iyi ɑ̀ nɑ Ilɑɑɔ̃ ɑ̀ ceɑò boodɑ. Iyi Jesu í ɡbɔ bɛɛbɛ ŋɔi í ni, ");
INSERT INTO mkl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","mii ŋɑu bɛ iyi ì wɑɑ yɛ fei ŋɑ ɑjɔ ɑkɑ̃ ɑ́ kpɑ iri. Kutɑ bɑɑ ɑkɑ̃ kɑɑ nɑ ku mɑɑ lesi njɛ bɛ mɑ́, ɑɑ kɛkɛɛ mbɛ fei. ");
INSERT INTO mkl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, Mɛɛtu, wɑɑti yoomɑi inɛ nŋu ɑ́ to wɑ. Nyindɑ yoomɑi ɑɑ kɑ tɑko kɑ yɛ. ");
INSERT INTO mkl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, i ce lɑɑkɑi ŋɑ i mɑɑ̀ jɔ̀ inɛ ɡɔ ku dĩ iju nŋɛ, domi inɛ ŋɑ iyi ɑɑ nɑ ɑ mɑɑ nɑɑ ɑkɑ̃ ɑkɑ̃ ɑ mɑɑ ni ɑŋɑi ɑ̀ jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu ɑɑ kpɔ. Nɔ ɑɑ nyi ɑ sɔ̃ ŋɛ mɑ́ ɑ ni, wɑɑtiu í mɑɑi wɑ mbɛ. Ammɑ i mɑɑ̀ too ŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bii ì ɡbɔ ɑ̀ wɑɑ fɔ lɑɑbɑɑui iɡũ ŋɑ do ijɑ ŋɑ, i mɑɑ̀ jɔ̀ ziɡi nŋɛ ku dɑ, domi nŋu ŋɑu bɛi ɑ́ tɑko ku to wɑ. Ammɑ kù jɛ wɑɑtii ɑnkɑ̃ɑnyiu bɛ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ŋɔi í sɔ̃ ŋɑ mɑ́ í ni, dimi ɡɔ ŋɑ ɑɑ yɑ nɑ ɑ mɑɑ jɑ do dimi mmu ŋɑ, nɔ ilɑɑlu ɡɔ ŋɑ mɔ ɑɑ mɑɑ jɑ do ilɑɑlu mmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ilɛ ɑ́ yɑyɑ bii ɡɔ ŋɑ nlɑ nlɑ, nɔ si ilɛ ɡɔ ŋɑ mɔ ɑri ɑ́ ce do bɔ̃ɔ lɑɑlɔ ŋɑ iyi ɑ́ kpɑ inɛ nkpɔ. Aɑ nɑ i yɛ mɑɑmɑɑke lɑɑlɔ ŋɑ do nyindɑ nlɑ nlɑ ikpɑ lele hee ziɡi nŋɛ ku dɑ. ");
INSERT INTO mkl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ammɑ hee nŋu ŋɑu bɛ fei ku mɑɑ ce ɑɑ mu ŋɛ ɑ kpɑ̃ ŋɛ iju. Aɑ dɑsi ŋɛ ɑwɔi woo kiiti ŋɑ ile bii ɑ̀ yɑ ce kutɔtɔɔ ŋɑ, ɑɑ dɑsi ŋɛ piisɔ̃ɔ, nɔ ɑ bɔò ŋɛ bi ɑmɑnlu ŋɑ do bi ilu ilɛ ŋɑ nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nŋu ŋɑu bɛi ɑ́ mu nŋɛ kpɑ̃ɑ i jɛò sɛɛdɑm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nɑ nŋu, i jilɛ idɔ nŋɛ i mɑɑ̀ yɑ biti do ide iyi ɑɑ fɔ i nyɑò ɑrɑ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","I mɑɑ̀ biti ŋɑ domi ɑn mu nŋɛ ide do bisi iyi mbɛɛ nŋɛ ŋɑ kɑ̃mɑ nŋɑ ɑ kɑɑ yɔkɔ ɑ jɑ̃ ŋɛ hee mɑ́ jɛ ɑ kɔ. ");
INSERT INTO mkl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bɑɑ iyeò bɑɑ nŋɛ ŋɑ do iɡbɑ̃ nŋɛ ŋɑ do ifɔ nŋɛ ŋɑ do nyɑɑnze nŋɛ ŋɑ do kpɑɑsi nŋɛ ŋɑ, ɑɑ zɑmbɑ ŋɛ nɔ ɑ jɔ̀ ɑ kpɑ inɛ nkpɔ si inɔ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Inɛ fei ɑ́ cé ŋɛi nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ammɑ bɑɑ ntoi iri ɑkɑ̃ nŋɛ kɑɑ dɑ ku nyɔ. ");
INSERT INTO mkl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","I temuɑ ŋɑ, ɑɑ bɑ fɑɑbɑi hunde nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ajɔ iyi ì yɛ woo jɑ iɡũ ŋɑ ɑ̀ to wɑ Zeruzɑlɛmu ɑ̀ buu koe, i mɑ̀ ŋɑ iyi iri kukpɑɛ í mɑɑi wɑ mbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wɑɑti bɛɛbɛ inɛ ŋɑ iyi ɑ̀ wɑ ilɛi Zudee ɑ sɑ ɑ bɔ iri kutɑ ŋɑu. Inɛ ŋɑ mɔ iyi ɑ̀ wɑ inɔ ilu Zeruzɑlɛmu tɑkɑɛ ɑ sɑ ɑ fitɑ, inɛ ŋɑ mɔ iyi ɑ̀ wɑ iko ku sũ ɑ mɑɑ̀ bɔ inɔ ilu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ntɔ ntɔ, wɑɑtiu ɑ́ jɛ wɑɑti iyi Ilɑɑɔ̃ ɑ́ kpɑ̃ inɛ ŋɑ iju ku sɑ̃ ɡbese ku bɑ mii iyi ɑ̀ fɔ si kukɔi ideɛ ku kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wɑɑti bɛɛbɛ wɑhɑlɑi bɑɑsĩ ŋɑ do ɑyɑwo ŋɑ ɑ́ cɑɑ. Inɔ ku fɔ nlɑ nlɑi ɑ́ wɑ si ilɛu si nɑ iyi í jɔ̀ Ilɑɑɔ̃ ɑ́ sɑ̃ idɔɔkɔ̃ɛ si inɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aɑ mɑɑ kpɑ ŋɑ do tɑɑkubɑ, nɔ ɑ mu ŋɑ ɑru si ilɛ fei. Dimi mmu ŋɑ ɑɑ tɛɛsɛ Zeruzɑlɛmuui hee wɑɑtiu koo kpɑò iri. ");
INSERT INTO mkl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Aɑ yɛ nyindɑ si inunu do si cukpɑ do si ɑndɑiyɑ ŋɑ. Nɔ si ilɛ ibɑi tenku do kucɑ̃i inyiu ɑ́ jɔ̀ dimi ŋɑ ɑ biti hee ɑ kɑɑ mɑ̀ bɑɑ bɛi ɑɑ ce. ");
INSERT INTO mkl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bɑɑ njo ɑlɑ́lɑ ɑ́ jɔ̀ inɛ ŋɑ ɑ kɑsɑ̃m nɑ mii ŋɑ iyi ɑ́ nɑ ku ce si ɑndunyɑu ihɛ̃, domi ɡbuɡbɑ̃i lele ŋɑ ɑɑ mɑɑ yɑyɑi. ");
INSERT INTO mkl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wɑɑti bɛɛbɛi ɑɑ yɛ ɑmu Amɑi Amɑnɛ ǹ fɑɑtɑ wɑ si kudũi ijĩ do ɡbuɡbɑ̃ nlɑ nlɑ do ɑmboe. ");
INSERT INTO mkl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bii iyi bɛ ŋɑ ɑ̀ sinti ku ce, i leekĩ i mu ɑrɑ nŋɛ ŋɑ, domi fɑɑbɑ nŋɛi í mɑɑi wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nɔ Jesu í kpɑ nŋɑ mɔndɑ ɡɔ í ni, i cɔ jĩi ndii fiɡi do jĩi ŋɑ iyi ɑ̀ ɡbe fei. ");
INSERT INTO mkl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bii ì yɛ í sinti ku ru wuɑ ŋɑ, iŋɛ tɑkɑ nŋɛ ì yɑ mɑ̀ ŋɑ iyi ɑtɛ í mɑɑi wɑi. ");
INSERT INTO mkl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bɛɛbɛ mɔi bii iŋɛ mɔ ì yɛ mii ŋɑu bɛ wɑ ce, i mɑ̀ ŋɑ iyi bommɑi Ilɑɑɔ̃i í mɑɑi wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛ, inɛi nsɛi ŋɑ, kù jɛ ɑŋɑ feii ɑɑ ku ideu ihɛ̃ ku bɛi ku ce. ");
INSERT INTO mkl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lele do ilɛ fei ɑ́ nɑ ku tɑ̃ ɑmmɑ idem ŋɑ ɑ kɑɑ tɑ̃ pɑi. ");
INSERT INTO mkl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","I ce lɑɑkɑii ɑrɑ nŋɛ ŋɑ ku bɑ i mɑɑ̀ nɑ i jɛ hɑi nɛ lɑɑkɑi ŋɑ nɑ ɑtɛ̃ ku mɔ do ijɛ ku bi do lɑsɑbui mii ndii ɑndunyɑ ŋɑ. Bii kù jɛ bɛɛbɛ ɑjɔu ɑ́ nɑ ku boe ŋɛi bɛi cɛkũm, ");
INSERT INTO mkl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","domi ɑ́ nɑ ku bɑ inɛ ŋɑ iyi ɑ̀ wɑ si ɑndunyɑu ihɛ̃ fei. ");
INSERT INTO mkl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nɑ nŋu, i cɔ kpɑ̃ɑ i mɑɑ ceò kutɔɔ ŋɑ wɑɑti kɑ̃mɑ fei ku bɑ i bɑ ɡbuɡbɑ̃ i ɡbɑ̃ si mii iyi wɑ nɑɑ fei ŋɑ, nɔ i yɔkɔ i leekĩ si wɑjui ɑmu Amɑi Amɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ajɔ fei Jesu í yɑ kɔ inɛ ŋɑ si cio kpɑsɛ̃i Ilɑɑɔ̃, ɑlɛ nɔ koo sũ ɡeetei Olivie. ");
INSERT INTO mkl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bii iju í mɑ́ inɛ fei í yɑ nɑɑ kpɑsɛ̃i Ilɑɑɔ̃ bɛ ku ɡbɔò ideɛ iyi wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jinɡɑui Pɛ̃ɛ hɑi nɛ lefee iyi ɑ̀ yɑ kpe jinɡɑui Iku ku kuɑu í mɑɑi wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ wɑɑ dɛ kpɑ̃ɑ bɛi ɑɑ ce ɑ kpɑò Jesu, ɑmmɑ ɑ̀ wɑɑ ce njoi zɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ŋɔi Seetɑm í lɔ idɔi Zudɑsi iyi ɑ̀ yɑ kpe Isikɑriɔti. Wee inɛ ɑkɑ̃i mɔcɔ mɑɑteeji ŋɑui. ");
INSERT INTO mkl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Zudɑsi í koo í dĩ ɑnu tɔɔsi do inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do inɛ nɡboi woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu do yɑɑse bɛi ɑ́ ce ku dɑ nŋɑ Jesu si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ŋɔi inɔ nŋɑ í dɔ̃ nɔ ɑ̀ ni ɑŋɑ ɑɑ muɑ fiɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nɔ Zudɑsi í jɛsi, nɔ wɑ dɛ kpɑ̃ɑ bɛi ɑ́ ce ku dɑ nŋɑ Jesu si ɑwɔ, zɑmɑɑu ku mɑɑ̀ ti ku mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ŋɔi ɑjɔi jinɡɑui Pɛ̃ɛ hɑi nɛ lefeeu í to wɑ si bii ɑ̀ yɑ kpɑ ɑnɡudɑ̃i jinɡɑui Iku ku kuɑ ɑ ceò kuweeu. ");
INSERT INTO mkl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ŋɔi Jesu í bɛ Piɛɛ do Zɑ̃ɑ í ni, i koo i ce sɔɔlui jinɡɑui Iku ku kuɑu kɑ jɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, iwoi ì bi kɑɑ ce sɔɔluu. ");
INSERT INTO mkl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ŋɔi í sɔ̃ ŋɑ í ni, bii ì lɔ inɔ iluu ŋɑ ɑɑ yɛ mɔkɔ ɡɔ wɑ so inyi jɔlɔ. I tooɛ. Mɔkɔu ɑ́ koo ku lɔ kpɑsɛ̃ ɡɔ. Kpɑsɛ̃ bii ɑ́ lɔu ");
INSERT INTO mkl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","i koo i sɔ̃ ilu kpɑsɛ̃u i ni ŋɑ, Mɛɛtu í ni kɑ beeɛ ile bii nŋu ɑ́ jɛ jinɡɑui Iku ku kuɑ do mɔcɔi nŋu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mɔkɔu ɑ́ bɔò ŋɛ si ɑntɑi ile kukpɛkɛ ɡɔ nɔ ɑ́ nyisi ŋɛ ilɑɑwɑ nlɑ ɡɔ iyi ɑ̀ ce sɔɔlui fei ndɛɛ tɑ̃. Bɛi ɑɑ ce nwɑ sɔɔlui jinɡɑuu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iyi ɑ̀ nɛ nɔ ɑ̀ koo ɑ̀ bɑ mii ŋɑu fei í cei dee dee si bɛi í sɔ̃ ŋɑu, nɔ ɑ̀ ce sɔɔlui jinɡɑuu. ");
INSERT INTO mkl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Iyi wɑɑtiu í to, Jesu do mɔcɔɛ ŋɑu ɑ̀ bɔ tenɡi bii ɑ̀ ce sɔɔluu, nɔ ɑ̀ bubɑ ɑ̀ wɑɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, ǹ bi ntɔ ntɔ n ce jinɡɑui Iku ku kuɑu ihɛ̃i ɑwɑɛ ŋɑ n bɛi n yɛ ijuukpɑ̃m nɔu. ");
INSERT INTO mkl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nɔ ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, n kɑɑ n jɛ jinɡɑu ihɛ̃ mɑ́ bii kù jɛ si ɑndunyɑ titɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iyi í fɔ bɛɛbɛ í tɑ̃, ŋɔi í so kɔɔfu í sɑɑbu Ilɑɑɔ̃ nɔ í sɔ̃ mɔcɔɛ ŋɑ í ni, i ɡbɑ vɛ̃ɛ iyi í wɑ si kɔɔfuu ihɛ̃ i mɔ iŋɛ fei. ");
INSERT INTO mkl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ammɑ ǹ wɑ n sɔ̃ ŋɛi, hɑi nsɛi ɑmu n kɑɑ n mɔ vɛ̃ɛ mɑ́ hee ɑndunyɑ titɔ̃i Ilɑɑɔ̃ koo too wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Si ɑnyii nŋu, nɔ í so pɛ̃ɛ nɔ í sɑɑbu Ilɑɑɔ̃ titɑ̃ í bɛi í bububuɛ, nɔ í nɑ ŋɑ í ni, iyi ihɛ̃i í jɛ ɑrɑm iyi ǹ nɑ nɑ iri nŋɛ. I yɑ coo ŋɑ i mɑɑ yeò ɡiɡim. ");
INSERT INTO mkl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Iyi ɑ̀ jɛ ɑ̀ tɑ̃ ŋɔi í so kɔɔfu mɑ́ í nɑ ŋɑ í ni, kɔɔfuu ihɛ̃i í jɛ nyindɑi ɑkɑbuu titɔ̃ iyi Ilɑɑɔ̃ í dĩ do njɛm iyi ɑ́ nikɑ̃ nɑ iri nŋɛ si ikum. ");
INSERT INTO mkl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ammɑ i cɔ inɛ iyi ɑ́ zɑmbɑm nɔu wee í wɑ ihɛ̃, ɑwɔɛ do tom nii í wɑ si inɔ jɛɛ ihɛ̃ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Amu Amɑi Amɑnɛ ɑn ku si bɛi Ilɑɑɔ̃ í jilɔɔ. Ammɑ ijuukpɑ̃i inɛ iyi ɑ́ zɑmbɑm nɔu ɑ́ lɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ŋɔi ɑ̀ sinti ku bee njɛ ɑ̀ wɑɑ ni, yooi ɑ́ yɔkɔ ku ce dimiɛ si inɔ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ŋɔi kɑkɔɔ í dede si ɑninii mɔcɔ ŋɑu, ɑ̀ wɑɑ bee njɛ inɛ iyi ɑ́ jɛ inɛ nɡbo si inɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, ɑmɑnlui ɑndunyɑ ŋɑ ɑ̀ yɑ mɑɑ tɑɑ inɛ ŋɑ ɑmɑnlu ku jɛi, nɔ inɛ nɡbo ŋɑ iyi ɑ̀ wɑɑ nyisi ɡbuɡbɑ̃ nŋɑ ɑ̀ yɑ bi ɑ kpe ɑŋɑ woo ce jiidɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ammɑ iŋɛ i mɑɑ̀ yɛ bɛɛbɛ ŋɑ. I jɔ̀ inɛ iyi í lɑ í re si inɔ nŋɛ ku bɑɑ ku jɛ keeke nŋɛ, nɔ inɛ iyi í jɛ inɛ nɡbo kú jɛ ɑmɑɑcɛ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Inɛ iyi í bubɑ wɑ jɛ si ɑntɑi tɑɑbu do inɛ iyi wɑ nɑɑò ijɛu wɑ, yoo nŋɑi í re. Kù jɛ inɛ iyi wɑ jɛui? To, ɑmu wee ǹ wɑ inɔ nŋɛi bɛi inɛ iyi wɑ nɑɑò ijɛu wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Iŋɛi ì temuɑ do ɑmu si wɑhɑlɑm ŋɑu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nɑ nŋu, si bɛi Bɑɑbɑ í jilɛɛm bommɑu, bɛɛbɛ mɔi ɑmu mɔ ǹ wɑ n jilɛ nŋɛ ");
INSERT INTO mkl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ku bɑ i jɛ nɔ i mɔ do ɑmu si bommɑm ŋɑ, nɔ i bubɑ si bɑtɑi ɑmɑnlu ŋɑ i kiitiò dimi mɑɑteejii Izirɛli ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ŋɔi Jesu í ni, Simɔɔ, Simɔɔ, Seetɑm í tɔɔ kpɑ̃ɑ ku bɑ ku fɛɛ bɛi iyɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ammɑ ɑmu ǹ ce kutɔɔ nɑ iriɛ ku bɑ nɑɑnɛ ku dɑsiɛ ku mɑɑ̀ ɡɑiziɑ. Nɔ ɑwɔ, wɑɑti iyi ɑɑ kpɑɑsi idɔ mɑ́, muɑ kpɑɑsiɛ ŋɑ mɔ ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ŋɔi Piɛɛ í ni, Lɑfɛ̃ɛ, ǹ tɑ̃ sɔɔlu ɑwɑɛ kɑ bɔ piisɔ̃ɔ, bii iku mɔi kɑ ku ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ŋɔi Jesu í ni, Piɛɛ, ǹ wɑ n sɔ̃ɛi, idũuyi mɔm, hee ɑjɛɛ ku mɑɑ kɔ ɑɑ jɑ̃ isɛ ɡbɛɛtɑ i ni i kù mɑ̀m. ");
INSERT INTO mkl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Si ɑnyii nŋu ŋɔi Jesu í bee ŋɑ í ni, si wɑɑti iyi ǹ bɛ ŋɛ hɑi mu tɑɑlili do bɔɡɔ do bɑɑtɑ ì kuɑ nɡɔɡɔ ŋɑ? Ŋɔi ɑ̀ jɛ ɑ̀ ni, ɑɑwo, ɑ kù kuɑ nkɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ŋɔi í ni, to, nsɛi, kù jɛ bɛɛbɛ mɑ́. Inɛ iyi í nɛ tɑɑlili ku soo, bɛɛbɛ mɔi inɛ iyi í nɛ bɔɡɔ ku soo. Inɛ mɔ iyi kù nɛ tɑɑkubɑ, ku tɑ ibɔɛ ku rɑò. ");
INSERT INTO mkl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Si ɑnyii nŋu mɑ́, í sɔ̃ ŋɑ í ni, ideu ihɛ̃ iyi ɑ̀ kɔ nɑ irim nɔu ɑ́ cei, si bɛi ɑ̀ ni, ɑ̀ dooɑɛ si woo ce lɑɑlɔ ŋɑ. Kù nɔ kù nɛ bɛi ɑ́ ce iyi kù ce bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ŋɔi mɔcɔ ŋɑu ɑ̀ ni, Lɑfɛ̃ɛ, tɑɑkubɑ minji ɡɔ wee. Nɔ í ni, kɑ jɔ̀ ide nŋu bɛ. ");
INSERT INTO mkl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ nɔ í fitɑ hɑi inɔ iluu í bɔ iri kutɑi Olivie si bɛi í nɛ dɔɔnɛɛ. Nɔ mɔcɔɛ ŋɑ ɑ̀ wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Iyi ɑ̀ to inyɑu, ŋɔi í sɔ̃ ŋɑ í ni, i ce kutɔɔ ŋɑ ku bɑ i mɑɑ̀ dɑ́si kulɛlɛi inɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Si ɑnyii nŋu nɔ í sɛkɛɛ í jɔ̀ ŋɑ zɑkɑi kujĩi kutɑi ɑwɔ nɔ í ɡulɛ bɛ wɑ ce kutɔɔ ");
INSERT INTO mkl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","wɑ ni, Bɑɑbɑ, bii ì bi, ɑɑ jɔ̀ wɑhɑlɑu ihɛ̃ ku jĩim. Ammɑ ku mɑɑ̀ ti ku jɛ ti idɔɔbim, jɔ̀ idɔɔbiɛ ku ce.  ");
INSERT INTO mkl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ŋɔi ɑmɑlekɑ ɡɔ í nɑɑ siɛ wɑ hɑi lele í nɑɑ í muɑɑ ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Si inɔ ku fɔ nlɑ nlɑu wɑ ce kutɔɔui do ɡbuɡbɑ̃, nɔ í dɑ koko hee wɑ tontoo ilɛ. Koko iyi í dɑu í yɛi bɛi njɛ. ");
INSERT INTO mkl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Iyi í ce kutɔɔu í tɑ̃ ŋɔi í dede í bɔ bi mɔcɔɛ ŋɑu nɔ í koo í bɑ ɑ̀ wɑɑ sĩ njoo do inɔ ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nɔ í bee ŋɑ í ni, nɑ mii í ce ì wɑɑ sĩ njoo ŋɑ. I dede i ce kutɔɔ ŋɑ ku bɑ i mɑɑ̀ dɑsi kulɛlɛi inɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iyi Jesu wɑ fɔ bɛɛbɛ ɡbɑkɑ̃ ŋɔi Zudɑsi inɛ ɑkɑ̃i mɔcɔ mɑɑteeji ŋɑu í to wɑ do zɑmɑɑ ɡɔ. Iyi í to wɑ í nɑ wɑ bɑɑbɑ Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ŋɔi Jesu í ni, Zudɑsi, do dimii fɔɔ bɛ ihɛ̃i ɑɑ zɑmbɑò ɑmu Amɑi Amɑnɛ? ");
INSERT INTO mkl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Inɛ ŋɑ iyi ɑ̀ wɑɑ too Jesuu, iyi ɑ̀ yɛ mii iyi wɑ ce, ŋɔi ɑ̀ bee Jesu ɑ̀ ni, Lɑfɛ̃ɛ, kɑ dɑ ŋɑ do tɑɑkubɑu? ");
INSERT INTO mkl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ŋɔi inɛ ɑkɑ̃ nŋɑ í cɑfe itĩ njɛi ɑmɑɑcɛi woo wee nlɑi Ilɑɑɔ̃u í buu. ");
INSERT INTO mkl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ammɑ Jesu í ni, i leekĩ, i jɔ̀ bɛɛbɛ. Nɔ í lu itĩi mɔkɔu nɔ í bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Si ɑnyii nŋu Jesu í bee inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do inɛ nɡboi woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu do inɛ nɡbo ŋɑ iyi ɑ̀ nɑɑ siɛu í ni, ɑmui ì nɑɑ ku mu ŋɑ do tɑɑkubɑ do ɡolo ŋɑ bɛi woo ce ile? ");
INSERT INTO mkl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ajɔ fei ǹ yɑ n wɑ si inɔ nŋɛ n mɑɑ n kɔ inɛ ŋɑ si cio kpɑsɛ̃i Ilɑɑɔ̃, nɔ i kù mum ŋɑ. Ammɑ wɑɑtiu ihɛ̃i í jɛ tu ŋɛ do ɡbuɡbɑ̃i ilu kuku. ");
INSERT INTO mkl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iyi inɛ ŋɑu ɑ̀ mu Jesu, ŋɔi ɑ̀ bɔòɛ kpɑsɛ̃i woo wee nlɑi Ilɑɑɔ̃u. Nɔ Piɛɛ í wɑ hee jĩijĩ wɑ too ŋɑ wɑ do ɑnyi. ");
INSERT INTO mkl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ŋɔi inɛ ŋɑ ɑ̀ ko inɑ si ɑninii bɑntumɑi kpɑsɛ̃u ɑ̀ wɑɑ bubɑ bɛ. Nɔ Piɛɛ mɔ í koo í bubɑ bi tu ŋɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ŋɔi inɑɑbo woo ce icɛ ɡɔ í yɔɔ wɑ bubɑ kɔkɔi inɑu nɔ í kɑ̃siɛ iju í ni, inɛɛu ihɛ̃ mɔ í tɑko í wɑ bi Jesu wo. ");
INSERT INTO mkl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ammɑ í jɑ̃ í ni, ɑbooyi, n kù mɑ̀ɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Iyi í ce sɑ̃ɑ mɑ́ ŋɔi inɛ ɡɔ í yɔɔ nɔ í ni, ɑwɔ mɔ inɛ ɑkɑ̃i inɛ ŋɑui. Ammɑ Piɛɛ í ni, mɔkɔɔyi, n kù jɛ inɛ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Si ɑnyii nŋu zɑkɑi lɛɛu ɑkɑ̃ mɑ́, ŋɔi inɛ ɡɔ í fɔ do ɡbuɡbɑ̃ í ni, ntɔ ntɔ, mɔkɔu ihɛ̃ mɔ í yɑ wɑ bi Jesu wo domi nŋu mɔ inɛi Gɑlileei. ");
INSERT INTO mkl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ammɑ Piɛɛ í ni, ɑwɔu bɛ, n kù mɑ̀ bɛi ì wɑɑ bi i fɔ. Si bɛi wɑ fɔ ideu ɡbɑkɑ̃ ŋɔi ɑjɛɛ wɑ kɔ. ");
INSERT INTO mkl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nɔ Jesu í sindɑ í cɔ Piɛɛ. Ŋɔi Piɛɛ í ye ɡiɡii ide iyi Lɑfɛ̃ɛ í sɔ̃ɔu wo í ni, nnyi hee ɑjɛɛ ku mɑɑ kɔ ɑɑ jɑ̃ isɛ ɡbɛɛtɑ i ni i kù mɑ̀m. ");
INSERT INTO mkl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ŋɔi í fitɑ wɑduude í koo wɑ kpɑtɑ do inɔ ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Inɛ ŋɑ iyi ɑ̀ mu Jesuu ɑ̀ wɑɑ buu nɔ ɑ̀ wɑsi ku cɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","À bii wɑjuɛ ɑ̀ bɛi ɑ̀ beeɛ ɑ̀ wɑɑ ni, ce wɑlii. Yooi í cɑ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nɔ ɑ̀ buu dimii ɑrɑbu ikɑ̃ ikɑ̃ fei. ");
INSERT INTO mkl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Iyi iju í mɑ́ ŋɔi iɡbɛi inɛ nɡboi Zuifu ŋɑu ɑ̀ tɔtɔɔ nɔ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ bɔò Jesu bi iɡbɛi woo kiiti nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nɔ ɑ̀ beeɛ ɑ̀ ni, sɔ̃ wɑ bii ɑwɔu inɛ iyi Ilɑɑɔ̃ í cicɑui. Ŋɔi Jesu í jɛ nŋɑ í ni, bɑɑ bii ǹ sɔ̃ ŋɛ i kɑɑ dɑsi nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nɔ bii ǹ bee ŋɛ ide ɡɔ i kɑɑ jɛɛm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ammɑ hɑi nsɛi ɑmu Amɑi Amɑnɛ ɑn bubɑi si ɑwɔ njɛi Ilɑɑɔ̃ ilu ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ŋɔi ɑŋɑ fei ɑ̀ ni, debɛi, ɑwɔu Amɑi Ilɑɑɔ̃i? Ŋɔi í jɛ nŋɑ í ni, oo, ɑmu Amɑi Ilɑɑɔ̃i si bɛi ì fɔu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ŋɔi ɑ̀ ni, sɛɛdɑ yoomɑi ɑ̀ wɑɑ deɡbe mɑ́. Awɑ tɑkɑ nwɑ ɑ̀ ɡbɔɔ tɑ̃ hɑi si ɡɛlɛɛ. ");
INSERT INTO mkl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nɔ ɑŋɑ fei ɑ̀ dede ɑ̀ bɔò Jesu bi Pilɑti. ");
INSERT INTO mkl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ŋɔi ɑ̀ lɔsi dulum ku mɑ́ɑ ɑ̀ ni, ɑ̀ bɑ inɛɛu ihɛ̃ í wɑsi ku kɔ inɛ ŋɑ si bisi bɛi ɑɑ ce ɑ jɛ ilɛ nwɑ iɡũ nɔ wɑ ɡɑnji ɑ sɑ̃ɑ ilɑɑlu nlɑi Romu fiɑi lɛmpoo. Si ɑnyii nŋu mɑ́ í yɑ mɑɑ kpe ɑrɑɛ ɑmɑnlu, nɔ í ni nŋuu inɛ iyi Ilɑɑɔ̃ í cicɑui. ");
INSERT INTO mkl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nɔ Pilɑti í beeɛ í ni, ɑwɔi ì jɛ ilɑɑlui Zuifu ŋɑ? Nɔ Jesu í jɛɑɑ í ni, oo, si bɛi ì fɔ. ");
INSERT INTO mkl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nɔ Pilɑti í sɔ̃ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do zɑmɑɑu í ni, n kù yɛ tɑɑle kɑ̃mɑ si mɔkɔu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ammɑ ɑ̀ lɑ do ɡbuɡbɑ̃ ɑ̀ wɑɑ ni, í yɑ mɑɑ kosi inɛ ŋɑ ijɑi do cioɛ iyi í yɑ mɑɑ ce nŋɑ. Hɑi ilɛi Gɑlileei í sintiɛ nɔ í bɔ si ilɛi Zudee fei í bɛi í to wɑ ihɛ̃ mɑ nsɛi. ");
INSERT INTO mkl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Iyi Pilɑti í ɡbɔ bɛɛbɛ, ŋɔi í bee í ni, kù jɛ mɔkɔu inɛi Gɑlileei bɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nɔ í ɡbɔ ɑ̀ ni Jesu wɑ nɑɑi hɑi si ilɛi bommɑi Herodu. Ŋɔi í ni ɑ bɔòɛ bi Herodu. Wee wɑɑti bɛɛbɛ Herodu mɔ í wɑ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ŋɔi ɑ̀ bɔò Jesu bi tɛɛ. Iyi Herodu í yɛ Jesu ŋɔi inɔɛ í dɔ̃ ntɔ ntɔ, si nɑ iyi í jɔ̀ hɑi ku kpɛi wɑ dɛ ku yɔɔ, nɑ irii lɑɑbɑɑuɛ iyi í ɡbɔ ɑ̀ yɑ mɑɑ fɔu. Ŋɔi í bi ku ceɑ nŋu mɑɑmɑɑke ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ŋɔi í bee Jesu ide nkpɔ nkpɔ ɑmmɑ Jesu kù jɛɑɑ ide kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wee inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ wɑ bɛ, ɑ̀ wɑɑ mɑ́ɑ dulum do ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ŋɔi Herodu í jɔ̀ ɑ̀ dɑɑ si ibɔ ku sĩɑ ɡɔ nɔ nŋu do sooɡeɛ ŋɑ ɑ̀ wɑɑ yɑɑkoɛ nɔ ɑ̀ wɑsi ku buu. Si ɑnyii nŋu nɔ í jɔ̀ ɑ̀ nyiòɛ bi Pilɑti mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodu do Pilɑti wee mbɛɛ ŋɑi wo, ɑmmɑ ɑjɔ nŋu bɛi ɑ̀ dɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilɑti í kpe inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do inɛ nɡbo ŋɑ do zɑmɑɑ nkpɔ mɑ́ í tɔtɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nɔ í sɔ̃ ŋɑ í ni, ì nɑɑm mɔkɔu ihɛ̃ wɑ ŋɑ, ì ni wɑ kɔ inɛ ŋɑ si bisi bɛi ɑɑ ce ɑ jɛò ilɛ nwɑ iɡũ do ile. Nɔ wee ǹ beeɛ ideu si wɑju nŋɛ ihɛ̃, ɑmmɑ n kù yɛ si mɔkɔu ide kɑ̃mɑ iyi ì wɑɑ yɛò tɑɑleɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nɔ Herodu mɔ kù yɛ siɛ tɑɑle kɑ̃mɑ. Nɑ ŋɔi í ce í jɔ̀ ɑ̀ nyiòɛ wɑ ihɛ̃. Mɔkɔu kù ce kurɑrɑ kɑ̃mɑ iyi í to ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nɑ nŋu, ɑn jɔ̀ ɑ tɛɑɑ kpɔtɔɔ nɔ n jɔ̀ɔ ku nɛɛ.  ");
INSERT INTO mkl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Wee si jinɡɑui Iku ku kuɑ fei tilɑsi Pilɑti í yɑ jɔ̀ inɛi piisɔ̃ɔ ɑkɑ̃i. ");
INSERT INTO mkl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ŋɔi ɑŋɑ fei ɑ̀ dɔ̃ ɑnu hee lele ɑ̀ wɑɑ ni, kpɑ inɛ ihɛ̃ nɔ i jɔ̀ nwɑ Bɑrɑbɑsi. ");
INSERT INTO mkl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Wee ɑ̀ mu Bɑrɑbɑsi ɑ̀ dɑsiɛ piisɔ̃ɔi wo nɑ kosi iyi í ce si inɔ ilu nɔ í nyi í kpɑ inɛ ɡɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ŋɔi Pilɑti í bee ŋɑ ide mɑ́ si nɑ iyi í jɔ̀ í dɑsi idɔ nŋu ku jɔ̀ Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ŋɔi ɑ̀ dedeò hoyɑ hoyɑ ɑ̀ wɑsi ku ni, kpɑkpɑɛ si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ŋɔi Pilɑti í bee ŋɑ isɛ ɡbɛɛtɑsiɑɛ í ni, lɑɑlɔ yoomɑi í bɛi í ce. Amu n kù yɛ siɛ nɡɔɡɔ iyi í to iku. Nɑ nŋu, ɑn jɔ̀ ɑ tɛɑɑ kpɔtɔɔi nɔ n jɔ̀ɔ ku nɛ. ");
INSERT INTO mkl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ammɑ bɛi Pilɑti wɑ fɔ fei, bɛɛbɛ mɔi inɛ ŋɑu ɑ̀ yɑ dɔ̃ ɑnu hee lele ɑ mɑɑ ni, kpɑkpɑɛ si jĩi ku ɡɑɑu. Ŋɔi ɑnu ku dɔ̃ nŋɑu í kɑ̃miɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nɔ Pilɑti í dɑsi idɔ nŋu ku ce bɛi ɑ̀ biu. ");
INSERT INTO mkl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nɔ í jɔ̀ nŋɑ inɛ iyi ɑ̀ biu, inɛ iyi ɑ̀ dɑsi piisɔ̃ɔ nɑ kosi do inɛ ku kpɑu, nɔ í dɑ nŋɑ Jesu si ɑwɔ ɑ ceɑɑ bɛi ɑ̀ bi. ");
INSERT INTO mkl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ŋɔi inɛ ŋɑu ɑ̀ ɡbɑ̃ Jesu ɑ̀ wɑɑ nɛòɛ. Wɑɑti iyi ɑ̀ wɑɑ nɛòɛu, ŋɔi ɑ̀ ko mɔkɔ ɡɔ iyi ɑ̀ yɑ kpe Simɔɔ, inɛi Sirɛni. Mɔkɔu wɑ bɑɑi hɑi ikoɛ. Ŋɔi ɑ̀ muu ɑ̀ kɑ̃ɑ jĩi ku ɡɑɑuu ku tooò Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nɔ zɑmɑɑ nlɑ ɡɔ wɑ tooɛ. Si inɔ nŋɑ inɑɑbo ɡɔ ŋɑ ɑ̀ wɑ bɛ ɑ̀ kpɑtɑ ɑ̀ wɑɑ cɑ̃ kpokpo nɑ iriɛ. ");
INSERT INTO mkl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iyi Jesu í sindɑ í cɔ ŋɑ ŋɔi í ni, iŋɛ inɑɑboi Zeruzɑlɛmu ŋɑ, i mɑɑ̀ kpɑtɑ nɑ irim, ɑmmɑ i kpɑtɑ nɑ iri nŋɛ do nɑ irii ɑmɑ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, ɑjɔ wɑ nɑɑ iyi inɛ ŋɑ ɑɑ ni, ilu inɔ didɔ̃i ɡbɛndɑ ŋɑ do inɑɑbo ŋɑ iyi ɑ kù bí, do inɑɑbo ŋɑ iyi ɑmɑ kù mɔmɔ si ɑmɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wɑɑti bɛɛbɛi ɑɑ mɑɑ sɔ̃ iri kutɑ ŋɑ ɑ ni, i cuku i bɑtɑ wɑ wɑ ŋɑ. Nɔ ɑɑ sɔ̃ ɡeete ŋɑ ɑ ni, i bii wɑ wɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ntɔ ntɔ, ǹ wɑ n sɔ̃ ŋɛ, bii inɛ ŋɑ ɑ̀ wɑɑ ceɑ jĩi tũtũ dimi bɛ ihɛ̃, bɛirei ɑɑ nɑ ɑ ceɑ jĩi nɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wɑɑti iyi ɑ̀ wɑɑ nɛò Jesu ɑ̀ kooò woo ce lɑɑlɔ minji ɡɔ ŋɑ mɔ iyi ɑɑ kpɑ ŋɑ do nŋu ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ŋɔi ɑ̀ to inyɑ iyi ɑ̀ yɑ kpe kokoi iriu. Bɛi ɑ̀ kpɑkpɑ Jesu si jĩi ku ɡɑɑuu. Bɛ mɔi ɑ̀ kpɑkpɑ woo ce lɑɑlɔ minji ŋɑu, inɛ ɑkɑ̃ ikpɑ ɑwɔ njɛɛ, inɛ ɑkɑ̃ mɔ ikpɑ ɑwɔ cɑnɡɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nɔ Jesu í ni, Bɑɑbɑ, kpɑ idei dulum du ŋɑ, domi ɑ kù mɑ̀ mii iyi ɑ̀ wɑɑ ce. Si ɑnyiɛ sooɡe ŋɑu ɑ̀ tɑ kpɑsɑ si jĩnɛɛ ŋɑ ɑ bɑ ɑ yɛ iyi inɛ fei ɑ́ bɑ. Bɛɛbɛi ɑ̀ ceò ikpɛ̃i jĩnɛɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ŋɔi zɑmɑɑu í wɑ bɛ wɑ cɔɔ. Nɔ inɛ nɡbo ŋɑu ɑ̀ yɑɑkoɛ ɑ̀ wɑɑ ni, í fɑɑbɑ inɛ ɡɔ ŋɑ. To, kú fɑɑbɑ ɑrɑɛ bɛ bii nŋui í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ŋɔi sooɡe ŋɑ mɔ ɑ̀ sɛkɛɛ siɛ ɑŋɑ mɔ ɑ̀ koo ɑ̀ wɑɑ yɑɑkoɛ nɔ ɑ̀ nɑɑ inyi ikɑ̃ ku mɔ. ");
INSERT INTO mkl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nɔ ɑ̀ sɔ̃ɔ ɑ̀ ni, bii ɑwɔi í jɛ ilɑɑlui Zuifu ŋɑ, ɑwɔ tɑkɑɛ fɑɑbɑ ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Si dee deei ɑntɑi iriɛ ɑ̀ kɔɔ ɑ̀ ni, inɛ ihɛ̃i í jɛ ilɑɑlui Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Inɛ ɑkɑ̃i woo ce lɑɑlɔ ŋɑ iyi ɑ̀ kpɑkpɑ si jĩi nɔu wɑ sɔ̃ Jesu ide nfe wɑ ni, kù jɛ ɑwɔi ì jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu bɑ. To, fɑɑbɑ ɑrɑɛ nɔ i fɑɑbɑ ɑwɑ mɔ. ");
INSERT INTO mkl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ammɑ inɛ ɑkɑ̃u mɔ í jɛɑɑ í ni, i kù wɑɑ ce njoi Ilɑɑɔ̃, bɑɑ ɑwɔ iyi iŋɛò fei ì wɑɑ yɛ ijuukpɑ̃ ɑkɑ̃? ");
INSERT INTO mkl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bii ɑwɑi ɑ̀ wɑɑ kpɑ̃ iju bɛɛbɛ, dee deei, domi ɑ̀ wɑɑ sɑ̃ nwɑ ɡbesei mii iyi ɑ̀ ce. Ammɑ njɛ kù ce lɑɑlɔ kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ŋɔi í sindɑ í sɔ̃ Jesu í ni, wɑɑti iyi ɑɑ koo i jɛ bommɑɛ nɔ i nyi wɑ si ɑndunyɑ mɑ́, ye ɡiɡim. ");
INSERT INTO mkl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nɔ Jesu í jɛɑɑ í ni, ntɔ ntɔ, ǹ wɑ n sɔ̃ɛi, nnyi mɔm ɑɑ wɛɛ do ɑmu lelei Aɔ̃. ");
INSERT INTO mkl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ŋɔi zɑkɑi dɑsɑ̃ nkpɑu ilu í kuku si ɑndunyɑu fei hee í koo í to isɔ mɛɛtɑi ɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Wɑɑti iyi ilu kukuu í ce ŋɔi ridooi kpɑsɛ̃i Ilɑɑɔ̃u í ɡɑ í kpɛ̃ minji. ");
INSERT INTO mkl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nɔ Jesu í lɑ do ɡbuɡbɑ̃ í ni, Bɑɑbɑ, ǹ dɑɑɛ hundem si ɑwɔ. Iyi í fɔ bɛɛbɛ nɔ í ku. ");
INSERT INTO mkl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Iyi inɛ nɡboi sooɡe ŋɑu í yɛ mii iyi í ceu, ŋɔi í sɑɑbu Ilɑɑɔ̃ í ni, ntɔ ntɔ inɛɛu ihɛ̃ kù nɛ tɑɑle kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nɔ inɛ ŋɑ mɔ iyi ɑ̀ nɑɑ ku cɔ mii iyi ɑ́ nɑ ku ceu fei ɑ̀ yɔɔ nɔ ɑ̀ sindɑ ɑ̀ nɛ do inɔ ku fɔ nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Inɛ ŋɑ iyi ɑ̀ mɑ̀ Jesu fei do inɑɑbo ŋɑ iyi ɑ̀ tooɛ wɑ hɑi ilɛi Gɑlileeu, ɑ̀ leekĩ hee jĩijĩ ɑ̀ wɑɑ cɔ mii iyi wɑ ce. ");
INSERT INTO mkl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mɔkɔ ɡɔ iyi ɑ̀ yɑ kpe Zozɛfu, inɛi Arimɑtee ilu ɑkɑ̃i Zuifu ŋɑu í nɑɑ bɛ. Mɔkɔu inɛ dee deei, wɑ ce jiidɑ, nɔ í wɛɛò kpɑ̃ɑ ku cɔ iyi Ilɑɑɔ̃ ɑ́ nɑ ku jɛ bommɑɛ. Í wɑ si iɡbɛi woo kiiti ŋɑ, ɑmmɑ kù jɛsi ide nŋɑ iyi ɑ̀ jilɛ ɑ ceɑ Jesu wo. ");
INSERT INTO mkl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mɔkɔu í bɔ bi Pilɑti í koo í tɔɔ ikui Jesu. ");
INSERT INTO mkl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ŋɔi í kitɑɛ wɑ hɑi si ɑntɑi jĩi ku ɡɑɑuu nɔ í biiɛ do ɑcɔ fũfũ titɔ̃ ɡɔ í bɛi í koo í suu. Í suui si isɑi kutɑ ɡɔ iyi ɑ̀ ɡbe wo nɔ ɑ kù si inɛ ɡɔ bɛ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wee ɑjɔi sɔɔlui kusĩmii, iyi hɑi ɑlɛu ɑjɔi kusĩmiu ɑ́ sinti. ");
INSERT INTO mkl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ŋɔi inɑɑbo ŋɑ iyi ɑ̀ too Jesu wɑ hɑi ilɛi Gɑlileeu ɑ̀ too Zozɛfu nɔ ɑ̀ yɛ bɑlɛu do bɛ́i ɑ̀ si Jesu fei. ");
INSERT INTO mkl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ŋɔi ɑ̀ sindɑ ɑ̀ bɔ ide ɑ̀ koo ɑ̀ ce sɔɔlui ikpo ku dɔ̃ inúnu do tulɑre ŋɑ wɑ. Si ɑjɔi kusĩmiu nɔ ɑ̀ sĩmi si bɛi woodɑ í fɔ. ");
INSERT INTO mkl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ajɔ ɑmɑ ɑzumɑ dɑɑdɑɑkɔu inɑɑbo ŋɑu ɑ̀ bɔ bi bɑlɛu ɑ̀ wɑɑ mu ikpo nŋɑ ŋɑ do tulɑre jiidɑ iyi ɑ̀ ce sɔɔluɛu. ");
INSERT INTO mkl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ŋɔi ɑ̀ bɑ kutɑu í bimbili hɑi ɑndɛi bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ŋɔi ɑ̀ lɔ inɔ bɑlɛu ɑmmɑ ɑ kù yɛ ikui Jesu bɛ. ");
INSERT INTO mkl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Si bɛi ɑ̀ wɑɑ leekĩ do bitiu ŋɔi ɑmɑnɛ minji ɡɔ ŋɑ ɑ̀ nɑɑ si ŋɑ ɑ̀ wɑɑ dɑsi jɑɑɛ ku dɑɑnɑ ɡɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ŋɔi inɑɑbo ŋɑu ɑ̀ wɑɑ ce njo nɔ ɑ̀ kɔmbɑ iri nŋɑ ilɛ, nɔ inɛ ŋɑu ɑ̀ sɔ̃ ŋɑ ɑ̀ ni, nɑ mii í ce ì wɑɑ dɛdɛ ilu hunde bi ku wɑi iku ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kù wɑ ihɛ̃ mɑ́, njɛ í jĩ hɑi si bɑlɛ. I ye ɡiɡii ide iyi í sɔ̃ ŋɛ si wɑɑti iyi í wɑ Gɑlilee ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Í ni kù nɛ bɛi ɑ́ ce iyi ɑ kù mu nŋu Amɑi Amɑnɛ ɑ kù dɑsi nŋu si ɑwɔi ilu dulum ŋɑ. Í ni ɑɑ kpɑkpɑ nŋu si jĩi ku ɡɑɑuu, ɑmmɑ nŋu ɑ́ jĩ mɑ́ si ɑjɔ mɛɛtɑsiɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ŋɔi inɑɑbo ŋɑu ɑ̀ ye ɡiɡii idei Jesuu. ");
INSERT INTO mkl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ŋɔi ɑ̀ sindɑ ɑ̀ nɛ hɑi bi bɑlɛu. Nɔ bɛi mii ŋɑu í ce fei ɑ̀ koo ɑ̀ sisiɑ mɔcɔ mɑɑtɑkɑ̃ ŋɑu do inɛ ŋɑ iyi ɑ̀ ɡbeu fei. ");
INSERT INTO mkl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mɑɑri inɛi Mɑdɑlɑ do Zoɑnɑ do Mɑɑri iyei Zɑɑki do inɑɑbo ɡɔ ŋɑ mɑ́, ɑŋɑi ɑ̀ koo ɑ̀ sɔ̃ woo bɛ ŋɑu ideu. ");
INSERT INTO mkl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ammɑ ideu wɑ jɛ nŋɑi bɛi ɑrɑ, ɑ kù dɑsi idei inɑɑbo ŋɑu nɑɑnɛ.  ");
INSERT INTO mkl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Do nŋu fei Piɛɛ í dede í sɛi í bɔ bi bɑlɛu. Iyi í to í bɑte í cɔ inɔ bɑlɛu, ɑmmɑ ɑcɔ iyi ɑ̀ woo dou nŋu ɑkɑ̃i í yɛ wɑ timbi ilɛ, nɔ í sindɑ í nyi kpɑsɛ̃ do biti. ");
INSERT INTO mkl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Si ɑjɔ ɑkɑ̃u mɔcɔ minji ɡɔ ŋɑ ɑ̀ wɑɑ bɔ ilu ɡɔ iyi ɑ̀ yɑ kpe Emɑyusi. Zɑkɑi kilo mɑɑtɑkɑ̃i í jĩò Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","À wɑɑ nyɑ fɑɑjii mii ŋɑ iyi í ceu fei ɑ̀ wɑɑ nɛò. ");
INSERT INTO mkl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iyi ɑ̀ wɑsi ku nyɑ fɑɑjii ideu, ŋɔi Jesu tɑkɑɛ í sɛkɛɛ si ŋɑ ɑŋɑò ŋɑ ɑ̀ wɑɑ nɛ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","À yɔɔ ɑmmɑ nɡɔɡɔ í ɡɑnji ŋɑ ɑ mɑ̀ɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nɔ í bee ŋɑ í ni, ide yoomɑi ì fɔ ì wɑɑ nɛò bɛɛbɛ ŋɑ. Ŋɔi ɑ̀ leekĩ ɑ̀ bɛjɛ wɑju do inɔ ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Inɛ ɑkɑ̃ iyi ɑ̀ yɑ kpe Keleopɑ í ni, bii kù jɛ ɑwɔ ɑkɑ̃ bɑɑ si, yooi í wɑ si Zeruzɑlɛmu iyi kù mɑ̀ mii iyi í ce si ɑjɔ ɡbeejiu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ŋɔi í bee ŋɑ í ni, mii í ce. Ŋɔi ɑ̀ ni, idei Jesu inɛi Nɑzɑrɛtiu ni. Mɔkɔu wɑlii ilu ɡbuɡbɑ̃i si icɛ do si ide ku fɔ si wɑjui Ilɑɑɔ̃ do si wɑjui ɑmɑnɛ ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do inɛ nɡbo nwɑ ŋɑ ɑ̀ dɑɑ inɛ ŋɑ si ɑwɔ ɑ̀ yɛ tɑɑleɛ ɑ̀ kpɑkpɑɛ si jĩi ɑ̀ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","À wɑɑ tɑmɑɑ nŋui ɑ́ fɑɑbɑ inɛi Izirɛli ŋɑ wo, ɑmmɑ ɑjɔ mɛɛtɑɛi ihɛ̃ iyi ideu í ce wɑ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Si ɑnyii nŋu, inɑɑbo ɡɔ ŋɑ si inɔ nwɑ ɑ̀ nɑɑ ɑ̀ ɡidi wɑ do ideu mɑ́. Inɑɑbo ŋɑu ɑ̀ dede dɑɑdɑɑkɔ ɑ̀ bɔ bi bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Iyi ɑ̀ to nɔ ɑ kù yɛ ikui Jesuu bɛ. Ŋɔi ɑ̀ nɑɑ ɑ̀ sɔ̃ wɑ ɑ̀ ni ɑmɑlekɑ ŋɑ ɑ̀ nɑɑ si ɑŋɑ nɔ ɑ̀ sɔ̃ ɑŋɑ ɑ̀ ni í jĩ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ŋɔi inɛ ɡɔ ŋɑ hɑi si inɔ nwɑ ɑ̀ bɔ bi bɑlɛu nɔ ɑ̀ koo ɑ̀ bɑ mii ŋɑu í cei dee dee si bɛi inɑɑbo ŋɑu ɑ̀ sɔ̃ wɑu, ɑmmɑ ɑ kù yɛ nŋu tɑkɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, iŋɛ hɑi nɛ bisi ŋɑi, i ci yɑ dɑsi ide iyi wɑlii ŋɑ ɑ̀ fɔ fei nɑɑnɛ ɡbɑ̃ɑ ɡbɑ̃ɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kù nɛ bɛi ɑ́ ce iyi inɛ iyi Ilɑɑɔ̃ í cicɑu kù yɛ ijuukpɑ̃, inɛ ŋɑ ɑ bɛi ɑ yɛ ɑmboeɛ. ");
INSERT INTO mkl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ŋɔi í sisi nŋɑ ide iyi ɑ̀ fɔ si kukɔi idei Ilɑɑɔ̃ fei si ɡɑ̃mɛi nŋu tɑkɑɛ. Í sintiɛi hɑi si tiɑi Moizi do ti wɑlii ŋɑu fei. ");
INSERT INTO mkl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Wɑɑti iyi ɑ̀ mɑɑi si ilu bii ɑ̀ wɑɑ bɔu, ŋɔi Jesu tɑkɑɛ í ce bɛi inɛ iyi wɑ bɔ wɑju. ");
INSERT INTO mkl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ŋɔi ɑ̀ mɑnte mɑnteɛ ɑ̀ ni ku ɡbe bi ɑŋɑ domi ɑlɛ í lɛ tɑ̃ nɔ inunu wɑ lɔ. Ŋɔi í sindɑ wɑ í nɑɑ í ɡbe bi tu ŋɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ŋɔi ɑŋɑò ŋɑ ɑ̀ wɑɑ jɛ. Wɑɑti iyi ɑ̀ wɑɑ jɛu ŋɔi í so pɛ̃ɛu í ce si kutɔɔ í bɛi í bububuɛ nɔ í nɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Wɑɑti bɛɛbɛi iju nŋɑ í cĩ bɛi nɔ ɑ̀ mɑ̀ɑ. Ammɑ tenɡi bɛ mɑ́ ɡbɑkɑ̃ ɑ̀ kuɑɛ. ");
INSERT INTO mkl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nɔ ɑ̀ sɔ̃ njɛ ɑ̀ wɑɑ ni, bɑɑ si wɑɑti iyi wɑ sɔ̃ wɑ idei kukɔi Ilɑɑɔ̃u hɑi si kpɑ̃ɑu wɑ inɔ nwɑ kù tũ de. ");
INSERT INTO mkl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nɔ ɑŋɑ mɔ ɑ̀ dede ɡbɑkɑ̃ ɑ̀ nɛ ikpɑ Zeruzɑlɛmu. Iyi ɑ̀ to bɛ ɑ̀ koo ɑ̀ bɑ mɔcɔ mɑɑtɑkɑ̃ ŋɑu ɑ̀ wɑɑ tɔtɔɔ do inɛ ɡɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ŋɔi inɛ ŋɑ iyi ɑ̀ tɔtɔɔ ŋɑu ɑ̀ wɑɑ sɔ̃ ɑmɑnɛ minji ŋɑu mɔ ɑ̀ ni, Lɑfɛ̃ɛ í jĩi hɑi si bɑlɛ ntɔ ntɔ, nɔ í nyisi ɑrɑɛ bi Simɔɔ. ");
INSERT INTO mkl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nɔ ɑmɑnɛ minji ŋɑu mɔ ɑ̀ sisi nŋɑ mii iyi í bɑ ɑŋɑ si kpɑ̃ɑ do bɛi ɑŋɑ ɑ̀ mɑ̀ Jesu si wɑɑti iyi wɑ bu pɛ̃ɛu. ");
INSERT INTO mkl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Iyi ɑ̀ wɑsi ideu ku fɔ bɛɛbɛ, ŋɔi nŋu tɑkɑɛ í fɑɑtɑ wɑ si ɑnini nŋɑ nɔ í ni, Ilɑɑɔ̃ ku mu nŋɛ lɑɑkɑi ku sũ. ");
INSERT INTO mkl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ŋɔi njo í mu ŋɑ, ziɡi nŋɑ í dɑ. À tɑmɑɑ bɛi zĩii. ");
INSERT INTO mkl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ŋɔi í bee ŋɑ í ni, mii í ce ì wɑɑ biti ŋɑ. Nɑ mii í ce dimii lɑsɑbuu ihɛ̃ í wɑ si idɔ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","I cɔ ɑwɔm do isɛm ŋɑ. Amui, i lum i cɔ ŋɑ. Zĩii ci yɑ nɛ ɑrɑ do kũkũ si bɛi ì wɑɑ yɛm ŋɑu ihɛ̃ ŋɑ.  ");
INSERT INTO mkl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iyi í fɔ bɛɛbɛ í tɑ̃ nɔ í nyisi ŋɑ ɑwɔɛ do isɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ŋɔi inɔ didɔ̃ nŋɑ í jɔ̀ ɑ kù dɑsi nɑɑnɛ ɡbɑ̃ɑ ɡbɑ̃ɑ nɔ ɑ̀ wɑ si biti nlɑ nlɑ, ŋɔi í jɔ̀ í bee ŋɑ í ni, i kù nɛ mii ku jɛ ɡɔ ihɛ̃ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ŋɔi ɑ̀ nyɑ cɛ̃ɛ ku bɑndɑ ɑkɑ̃ ɑ̀ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nɔ í ɡbɑ í ŋɔɔ si wɑju nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ŋɔi í ye ŋɑ ɡiɡi í ni, ide ŋɑ iyi ǹ sɔ̃ ŋɛu mbɛ si wɑɑti iyi ǹ wɑ inɔ nŋɛ wo. Ǹ tɑko ǹ sɔ̃ ŋɛ wo ǹ ni mii ŋɑ iyi ɑ̀ kɔ nɑ irim si tiɑi woodɑi Moiziu do si ti wɑlii ŋɑu do si iri ku kɔ̃i Dɑvidi ŋɑu kù nɛ bɛi ɑ́ ce iyi kù ce. ");
INSERT INTO mkl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ŋɔi í mu nŋɑ lɑɑkɑi jiidɑ ku bɑ ɑ ɡbɔ yɑɑsei kukɔi idei Ilɑɑɔ̃u. ");
INSERT INTO mkl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nɔ í sɔ̃ ŋɑ í ni, bɛɛbɛi ɑ̀ kɔɔ ɑ̀ ni ɑmu iyi Ilɑɑɔ̃ í cicɑ ɑn yɛ ijuukpɑ̃. Aɑ kpɑm, ɑmmɑ ɑn jĩ hɑi si bɑlɛ si ɑjɔ mɛɛtɑsiɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nɔ ɑɑ wɑɑzo do irim si dimi fei, ɑɑ sintii hɑi Zeruzɑlɛmu. Aɑ wɑɑzo ɑ kpe inɛ ŋɑ ɑ kpɑɑsi idɔ nɔ Ilɑɑɔ̃ ku kpɑ idei dulum du ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Iŋɛi ɑɑ jɛ sɛɛdɑi ide ŋɑu bɛ fei ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nɔ ɑn sɑmbɑ nŋɛ mii iyi Bɑɑm í wɑ̃ ŋɛ dou wɑ. Ammɑ si iluu ihɛ̃i ɑɑ mɑɑ wɑ ŋɑ hee ɡbuɡbɑ̃i Ilɑɑɔ̃ ku nɑɑ si ŋɛ wɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ŋɔi Jesu í ɡbɑ̃ mɔcɔɛ ŋɑu í fitɑò ŋɑ hɑi inɔ iluu. Nɔ í bɔò ŋɑ hee ikpɑ Betɑni, nɔ í wu ɑwɔ lele í wee nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wɑɑti iyi wɑ wee nŋɑu, ŋɔi í sɛkɛɛ hɑi bi tu ŋɑ nɔ í so ɑrɑɛ í nɛ lele. ");
INSERT INTO mkl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aŋɑ mɔ iyi ɑ̀ ɡulɛ ɑ̀ tɔɔɛ ŋɔi ɑ̀ nyi ikpɑ Zeruzɑlɛmu do inɔ didɔ̃ nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nɔ kpɑsɛ̃i Ilɑɑɔ̃ bɛi ɑ̀ yɑ mɑɑ wɑ wɑɑti kɑ̃mɑ fei ɑ mɑɑ sɑɑbu Ilɑɑɔ̃.");
INSERT INTO mkl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hee ɑ mɑɑ tɑkɑ ɑndunyɑ inɛ ɡɔ í wɛɛ ɑ̀ yɑ kpoo Ide. Ideu í wɛɛi do Ilɑɑɔ̃. Ideu tɑkɑɛ Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ideu njɛ í wɛɛi hɑi sinte do Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nŋui í tɑkɑ mii bɑɑ yoomɑ fei, nɔ nkɑ̃mɑ kù wɛɛ iyi kù jɛ nŋui í tɑkɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nŋu tɑkɑɛi í jɛ irii kuwɛɛu, nɔ kuwɛɛu í mɑ́ɑ inɛ ŋɑ inyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Inyɑ kumɑ́u í mɑ́i do si ilu kuku fei, nɔ ilu kukuu kù yɔkɔ kù kɑ̃miɑɛ . ");
INSERT INTO mkl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Mɔkɔ ɡɔ í wɛɛ iyi ɑ̀ yɑ kpe Zɑ̃ɑ. Nŋui Ilɑɑɔ̃ í bɛ wɑ ku nɑɑ ku jɛɑ inɛ ŋɑ sɛɛdɑi inyɑ kumɑ́u, nɔ inɛ fei ku dɑsiò inyɑ kumɑ́u nɑɑnɛ do sɑɑbuɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zɑ̃ɑ tɑkɑɛ kù jɛ inyɑ kumɑ́u, ɑmmɑ ɑ̀ bɔɔ wɑi ku jɛ sɛɛdɑi inyɑ kumɑ́u. ");
INSERT INTO mkl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Inyɑ kumɑ́u nŋu ɑkɑ̃i í jɛ inyɑ kumɑ́ ntɔ iyi í nɑɑ si ɑndunyɑ ku bɑ ku jɔ̀ inɛ fei ku yɛ ilu. ");
INSERT INTO mkl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Inɛ iyi í jɛ Ideu í wɑ si ɑndunyɑ wo. Do sɑɑbuɛi Ilɑɑɔ̃ í tɑkɑò ɑndunyɑ. Do nŋu fei, inɛi ɑndunyɑ ŋɑ ɑ kù mɑ̀ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Bi inɛɛ ŋɑi í nɑɑ nɔ inɛɛ ŋɑu ɑ̀ kɔsiɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ammɑ inɛ ŋɑ iyi ɑ̀ ɡbɑɑ nɔ ɑ̀ dɑsiɛ nɑɑnɛ í mu nŋɑ kpɑ̃ɑ ɑ jɛò ɑmɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","A kù jɛ ɑmɑi Ilɑɑɔ̃ ŋɑ do yɑɑse bɛi ɑ̀ yɑ ce ɑ bíò ɑmu ŋɑ si ɑndunyɑ. Kù jɛ do idɔɔbii ɑmɑnɛ ŋɑ, ti Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ideui í bɑɑ í jɛ ɑmɑnɛ. Í kɔ̃ò didɔ̃ nɔ bɛɛbɛ mɔi í kɔ̃ò ntɔ, nɔ í bɑ wɑ kuwɛɛ. À yɛ ɑmboeɛ, ɑ̀ cɔɔ do lɑɑkɑi, dimii ɑmboe iyi Ilɑɑɔ̃ Bɑɑbɑ í nɑ Amɑ ɑkɑ̃ɛu. ");
INSERT INTO mkl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zɑ̃ɑ í jɛɑ inɛ ŋɑ sɛɛdɑɛ, í lɑ í ni nŋu mbɛ inɛ iyi nŋu í fɔ ideɛu nŋu í ni ɑ́ nɑ ku nɑɑ si ɑnyii nŋuu, ɑmmɑ í re nŋu domi í wɛɛ hɑi wɑɑti iyi ɑ kù bí nŋu. ");
INSERT INTO mkl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Si ɑmɑni nlɑɛu ɑwɑ fei ɑ̀ bɑ ɑndi bɑɑ nwɑ, nɔ ɑ̀ bɑ didɔ̃ si ɑntɑi didɔ̃u. ");
INSERT INTO mkl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hɑi bi Moizii Ilɑɑɔ̃ í nɑ wɑ woodɑ, ɑmmɑ didɔ̃ do ntɔ í nɑɑi hɑi bi Jesu Kirisi. ");
INSERT INTO mkl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Inɛ kɑ̃mɑ kù yɛ Ilɑɑɔ̃ Bɑɑbɑ ɑjɔ kɑ̃mɑ. Amɑ ɑkɑ̃ɛ iyi í wɑ bi tɛɛu nŋu tɑkɑɛ Ilɑɑɔ̃i. Nŋui í jɔ̀ ɑ̀ mɑ̀ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ajɔ nŋu ɡɔ inɛ nɡboi Zuifu ŋɑ iyi ɑ̀ wɑ Zeruzɑlɛmu ɑ̀ bɛ si Zɑ̃ɑ woo weei Ilɑɑɔ̃ ŋɑ do inɛi Levi ŋɑ ɑ koo ɑ beeɛ ɑ ni, ɑwɔi yoo. ");
INSERT INTO mkl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ŋɔi Zɑ̃ɑ í jɛ nŋɑ í fɔ si bɑntumɑ í ni, n kù jɛ inɛ iyi Ilɑɑɔ̃ í cicɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, debɛi, ɑwɔi yoo. Awɔi Elii wɑlii nlɑi tɑkou? Nɔ í ni, ɑɑwo. N kù jɛ Elii. Nɔ ɑ̀ beeɛ mɑ́ ɑ̀ ni, ɑwɔi ì jɛ wɑlii iyi ɑ́ nɑ ku nɑɑu? Nɔ í ni, ɑɑwo. ");
INSERT INTO mkl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ŋɔi ɑ̀ beeɛ mɑ́ ɑ̀ ni, debɛi, ɑwɔi yoo. Sɔ̃ wɑ ku bɑ kɑ bɑ iyi ɑɑ kɑɑ sisiɑ inɛ ŋɑ iyi ɑ̀ bɛ wɑ wɑ. Bɛirei ɑwɔ tɑkɑɛ ì wɑɑ niɑ ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ŋɔi Zɑ̃ɑ í so ide iyi wɑlii Ezɑi í tɑko í fɔu í jɛ nŋɑ do í ni, Amui ǹ jɛ inɛ iyi wɑ dɔ̃ ɑnu si ɡbɑbuɑ wɑ ni, I teese kpɑ̃ɑi Lɑfɛ̃ɛ kú tɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wee inɛ ŋɑ iyi ɑ̀ bɛ wɑ ŋɑu, Fɑrisi ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ŋɔi ɑ̀ bee Zɑ̃ɑ ɑ̀ ni, ì ni i kù jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu, i kù jɛ Elii, i kù nɔ i kù jɛ wɑlii iyi ɑ́ nɑ ku nɑɑu. To, nɑ mii í jɔ̀ ì yɑ mɑɑ dɑsi inɛ ŋɑ inyi. ");
INSERT INTO mkl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ŋɔi Zɑ̃ɑ í jɛ nŋɑ í ni, ɑmu inyii ǹ wɑ n dɑsi inɛ ŋɑ, ɑmmɑ inɛ iyi ɑ́ nɑ ku nɑɑu í wɑ ɑnini nŋɛ nɔ i kù mɑ̀ɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nŋui ɑ́ nɑɑ si ɑnyim. Nɔ n kù tosi n fũ bɑɑ ikũi bɑɑtɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ide ŋɑu ihɛ̃ fei Betɑnii í ce. Betɑniu do ikpɑ nunui dɑɑkɔi idoi Zuudɛ̃ɛi í wɑ. Tenɡi bɛi Zɑ̃ɑ wɑ dɑsi inɛ ŋɑ inyi. ");
INSERT INTO mkl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Iju kumɑ́ɛ ŋɔi Zɑ̃ɑ í yɛ Jesu wɑ nɑɑ siɛ, ŋɔi í sɔ̃ inɛ ŋɑ í ni, i cɔɔ ŋɑ. Inɛ ihɛ̃i í jɛ ɑnɡudɑ̃i Ilɑɑɔ̃ iyi ɑ́ nyɑ dulum dii inɛi ɑndunyɑ ŋɑ ku nɛò. ");
INSERT INTO mkl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ideɛi ǹ tɑko ǹ fɔ wo ǹ ni inɛ ɡɔ wɑ nɑɑ si ɑnyim iyi í rem, domi njɛ í wɛɛ hɑi wɑɑti iyi ɑ kù bí ɑmu. ");
INSERT INTO mkl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Amu tɑkɑm n kù mɑ̀ mɑ̀ nŋui ɑ̀ ni ɑ́ nɑ ku nɑɑu wo, ɑmmɑ ɑmu ǹ nɑɑ ku dɑsi ŋɛ inyii ku bɑ iŋɛ inɛi Izirɛli ŋɑ i mɑ̀ɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ŋɔi Zɑ̃ɑ í sɔ̃ ŋɑ mɑ́ í ni, ǹ yɛ Hundei Ilɑɑɔ̃ wɑ kitɑ siɛ wɑ hɑi lele. Hundeu í yɛi bɛi ɑnkɑsiidi. ");
INSERT INTO mkl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Amu mɔ n kù mɑ̀ mɑ̀ nŋui ɑ̀ ni ɑ́ nɑ ku nɑɑu wo. Ammɑ Ilɑɑɔ̃i í bɛm wɑ n nɑɑ n dɑsi inɛ ŋɑ inyi. Nɔ nŋui í sɔ̃m mii iyi ɑ́ jɔ̀ n mɑ̀ɑ. Í ni ɑn yɛ inɛ ɡɔ iyi Hundei nŋu ɑ́ kitɑ ku de siɛ wɑ nɔ ku mɑɑ wɑ bɛ. Nŋui ɑ́ dɑɑ inɛ ŋɑ si Hundei nŋu. ");
INSERT INTO mkl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ǹ yɔɔ, nɔ ǹ wɑ n jɛɑ inɛ ŋɑ sɛɛdɑ iyi nŋui í jɛ Amɑi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Iju kumɑ́ɛ Zɑ̃ɑ í wɑ bɛ mɑ́, wɑ leekĩ do mɔcɔ minjiɛ ɡɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ŋɔi ɑ̀ yɛ Jesu wɑ lɔ nɔ Zɑ̃ɑ í ni, i cɔɔ ŋɑ. Inɛ ihɛ̃i í jɛ ɑnɡudɑ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Iyi mɔcɔ ŋɑu ɑ̀ ɡbɔ ideu ŋɔi ɑ̀ too Jesu. ");
INSERT INTO mkl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ŋɔi Jesu í sindɑ í bɑ ɑ̀ wɑɑ too nŋu wɑ, nɔ í bee ŋɑ í ni, mii ì wɑɑ dɛ ŋɑ. Ŋɔi ɑ̀ ni do fee nŋɑ, Rɑbi, wɑɑtɔ mɛɛtu. Ŋɔi ɑ̀ beeɛ ɑ̀ ni, iwoi í jɛ kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ŋɔi í jɛ nŋɑ í ni, i nɑɑ i cɔ ŋɑ. Nɔ ɑ̀ tooɛ ɑ̀ koo ɑ̀ cɔ bii í wɑ nɔ ɑ̀ hoe bɛ. Ideu ihɛ̃ í cei ɑlɛ zɑkɑi isɔ mɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Inɛ ɑkɑ̃i ɑmɑnɛ minji ŋɑ iyi ɑ̀ ɡbɔ idei Zɑ̃ɑ nɔ ɑ̀ too Jesuu, nŋui í jɛ Anderee, ifɔi Simɔɔ Piɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Iyi í sɛkɛɛ hɑi bi Jesu ɡbɑkɑ̃ í koo í kpe Simɔɔ iɡbɑ̃ɛ nɔ í sɔ̃ɔ í ni, ɑ̀ yɛ inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ŋɔi í bɔò Simɔɔ bi Jesu. Iyi Jesu í cɔɔ nɔ í ni, ǹ mɑ̀ iyi ɑwɔi ì jɛ Simɔɔ ɑmɑi Zɑ̃ɑ, ɑmmɑ Sefɑsii ɑɑ yɑ kpeɛ bɛbɛi. (Iriu bɛ do Piɛɛ fei, yɑɑseɛi í jɛ kutɑ.) ");
INSERT INTO mkl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Iju kumɑ́ɛ Jesu í dɑsi idɔ nŋu ku bɔ ilɛi Gɑlilee. Iyi í to bɛ ŋɔi í ko Filipu nɔ í sɔ̃ɔ í ni, toom wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Wee Filipu inɛi Bɛsɑidɑi. Anderee do Piɛɛ ŋɑ mɔ inɛi ilu bɛ ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ŋɔi Filipu í koo í dɛdɛ Nɑtɑniɛli í sɔ̃ɔ í ni, ɑ̀ yɛ inɛ iyi Moizi í kɔ ideɛ si tiɑi woodɑu nɔ wɑlii ŋɑu mɔ ɑ̀ fɔ ideɛ. Inɛɛu nŋui í jɛ Jesu inɛi Nɑzɑrɛti ɑmɑi Zozɛfu. ");
INSERT INTO mkl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ŋɔi Nɑtɑniɛli í beeɛ í ni, inɛ jiidɑ ɡɔ ɑ́ yɔkɔ ku fitɑ hɑi Nɑzɑrɛti mbɛ? Ŋɔi Filipu í ni, nɑɑ i koo i cɔ. ");
INSERT INTO mkl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ŋɔi ɑ̀ wɑɑ koo. Iyi Jesu í yɛ Nɑtɑniɛli wɑ nɑɑ bi tɛɛ ŋɔi í ni, i cɔ ŋɑ, ɑmɑi Izirɛli tɑkɑɛi wɑ nɑɑ bɛ, kù nɛ tɑki kɑ̃mɑ si idɔɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ŋɔi Nɑtɑniɛli í beeɛ í ni, hɑi iwoi ì mɑ̀m. Ŋɔi Jesu í ni, bɑɑ hee Filipu koo mɑɑ kpeɛ wɑ ǹ yɛɛ icui jĩi ndii fiɡiu ihɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ŋɔi Nɑtɑniɛli í ni, Mɛɛtu, ɑwɔu Amɑi Ilɑɑɔ̃i, ɑwɔu Ilɑɑlui Izirɛlii. ");
INSERT INTO mkl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ŋɔi Jesu í jɛɑɑ í ni, ì dɑsim nɑɑnɛ tɑ̃ si nɑ iyi í jɔ̀ ǹ ni ǹ yɛɛ ɑbɛ jĩi ndii fiɡiu ihɔ̃? Aɑ yɛ nɡɔɡɔ iyi í lɑ í re iyi bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nɔ í ni mɑ́, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛ, ɑɑ nɑ i yɛ lelei Aɔ̃ í cĩ ŋɑ nɔ ɑmɑlekɑi Ilɑɑɔ̃ ŋɑ ɑɑ ɡũ ɑ mɑɑ kitɑ si ɑmu Amɑi Amɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Si ɑjɔ mɛɛtɑsiɑɛ ŋɔi ɑ̀ wɑɑ ce ɑbɔdɔ̃ ɡɔ Kɑnɑ ilɛi Gɑlilee. Nɔ iyei Jesu í wɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nɔ ɑ̀ kpe Jesu do mɔcɔɛ ŋɑ mɔ bi ku ce ɑbɔdɔ̃u. ");
INSERT INTO mkl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ŋɔi ɑtɛ̃ vɛ̃ɛ nŋɑ í nɑ í tɑ̃ nɔ iyei Jesu í koo í sɔ̃ɔ í ni, ɑŋɑ ɑ kù nɛ vɛ̃ɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nɔ Jesu í jɛɑɑ í ni, yɑɑyi, ɑwɔ si ɑɑ sɔ̃m mii iyi ɑn ce. Wɑɑtim kù to titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ŋɔi iyeu í sɔ̃ woo ce icɛ ŋɑu í ni, i ce bɛi í sɔ̃ ŋɛ fei. ");
INSERT INTO mkl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Wee tenɡi bii ɑ̀ wɑɑ ce ɑbɔdɔ̃u boonyi mɛɛfɑ ɡɔ ŋɑ iyi ɑ̀ ce do kutɑ ɑ̀ wɑ bɛ, si bɛi Zuifu ŋɑu ɑ̀ yɑ kpɑ̃ si inyii ɑwɑlɑ nŋɑ. Boonyi ɑkɑ̃ fei ɑ́ yɔkɔ ku ɡbɑ inyi zɑkɑi jɔlɔ jɔnkɑ mɛɛ wɑlɑ mɛɛfɑ. ");
INSERT INTO mkl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nɔ Jesu í sɔ̃ woo ce icɛ ŋɑu í ni, i kpɑ̃ inyi i cuusi boonyi ŋɑu ku kɔ̃ ŋɑ. Nɔ ɑ̀ kpɑ̃ ɑ̀ cuusi hee fei ndɛɛ í kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ŋɔi ɡbɑkɑ̃ Jesu í ni ɑ bu ɑ koo ɑ nɑ inɛ nɡboi ɑbɔdɔ̃u, nɔ ɑ̀ bu ɑ̀ wɑɑ bɔ ku nɑ́ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ammɑ hee ɑ mɑɑ nɑ́ɑ, í kpɑɑsi vɛ̃ɛ tɑ̃. Ŋɔi inɛ nɡbou í tiɛɛ. (Kù mɑ̀ hɑi bii í nɑɑ, ɑmmɑ inɛ ŋɑ iyi ɑ̀ kpɑ̃ inyiu wɑ nɡu ŋɑ ɑ̀ mɑ̀.) Iyi í tiɛɛ nɔ í kpe mɔkɔ titɔ̃u, ");
INSERT INTO mkl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","í sɔ̃ɔ í ni, ɑtɛ̃ iyi í dɔ̃ ku mɔi ɑ̀ yɑ tɑko ɑ nɑɑò wɑ, bii inɛ ŋɑ ɑ̀ mɔ hee ɑ̀ yo ɑ bɛi ɑ nɑ ŋɑ iyi kù dɔ̃ sɑ̃ɑ sɑ̃ɑu. Ammɑ ɑwɔ, didɔ̃ui ì sinɡɑ hee í to nsɛi. ");
INSERT INTO mkl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iyi bɛi í jɛ mɑɑmɑɑke sinte iyi Jesu í ce. Kɑnɑ bɛi í coo si ilɛi Gɑlilee. Do yɑɑse bɛɛbɛi í nyisiò ɑmboeɛ nɔ mɔcɔɛ ŋɑ ɑ̀ dɑsiɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Si ɑnyii nŋu nɔ i bɔ Kɑpɛrɑnumu, nŋu do iyeɛ do ifɔɛ ŋɑ do mɔcɔɛ ŋɑ, ɑmmɑ ɑ kù kpɛ bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jinɡɑui Zuifu ŋɑ iyi ɑ̀ yɑ ni jinɡɑui Iku ku kuɑui í mɑɑi wɑ. Ŋɔi Jesu í bɔ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wɑɑti iyi í to bɛ, í bɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ nɔ í bɑ woo tɑ kɛtɛ do ɑnɡudɑ̃ do ɑnkɑsiidi ŋɑ si bɑntumɑi kpɑsɛ̃u do inɛ ŋɑ iyi ɑ̀ bubɑ ɑ̀ wɑɑ kpɑɑsi fiɑ. ");
INSERT INTO mkl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ŋɔi í ce kolonɡbɑi ikũ nɔ í leleò ɑŋɑ fei hɑi bɛ, hee do ɑnɡudɑ̃ do kɛtɛ ŋɑu fei. Nɔ í fukɑ tɑɑbui woo kpɑɑsi fiɑ ŋɑu í nikɑ̃ fiɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nɔ í sɔ̃ woo tɑ ɑnkɑsiidi ŋɑu í ni, i fitɑò mii ŋɑu bɛ hɑi ihɛ̃. I mɑɑ̀ sindɑ kpɑsɛ̃i Bɑɑm ɑjɑ̀ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iyi mɔcɔɛ ŋɑu ɑ̀ ɡbɔ bɛɛbɛ ŋɔi ɑ̀ ye ɡiɡii kukɔi idei Ilɑɑɔ̃ iyi í ni, ǹ nɛ himmɑ si icɛi ileɛu hee wɑ bi ku kpɑm. ");
INSERT INTO mkl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ŋɔi Zuifu ŋɑu ɑ̀ beeɛ ɑ̀ ni, mɑɑmɑɑke yoomɑi ɑɑ yɔkɔ i ce nwɑ ku bɑ kɑ mɑ̀ iyi ì nɛ kpɑ̃ɑi bɛɛbɛ ku ce. ");
INSERT INTO mkl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ŋɔi Jesu í jɛ nŋɑ í ni, i lɛɡɛ ileu ihɛ̃ ŋɑ nɔ si ɑfei ɑjɔ mɛɛtɑ ɑn dedeɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ŋɔi Zuifu ŋɑu ɑ̀ sɔ̃ɔ ɑ̀ ni, ɑdɔ̃ ciiji do mɛɛfɑi ɑ̀ ce ɑ̀ bɛi ɑ̀ mɑò ileu ihɛ̃. Bɛirei ɑɑ ce i dedeɛ si ɑfei ɑjɔ mɛɛtɑ. ");
INSERT INTO mkl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ammɑ idei ile iyi Jesu wɑ fɔu, ɑrɑɛi wɑ fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nɑ nŋu, wɑɑti iyi Jesu í jĩ hɑi si bɑlɛ, mɔcɔɛ ŋɑ ɑ̀ ye ɡiɡi iyi í fɔ ide bɛɛbɛ wo. Nɔ ɑ̀ dɑsi kukɔi idei Ilɑɑɔ̃ nɑɑnɛ do ide ŋɑ iyi Jesu í tɑko í sɔ̃ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Si bɛi Jesu í wɑ Zeruzɑlɛmu si wɑɑtii jinɡɑui Iku ku kuɑu, inɛ ŋɑ ɑ̀ yɛ mɑɑmɑɑke ŋɑ iyi í yɑ mɑɑ ce nɔ inɛ nkpɔ í dɑsiɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ammɑ Jesu kù nɑ ŋɑ ɑrɑ domi í mɑ̀ idɔi inɛ fei. ");
INSERT INTO mkl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kù bee hee ɑ sisiɑ nŋu dɑɑi ɑmɑnɛ domi nŋu tɑkɑɛ í mɑ̀ mii iyi í wɑ si idɔi ɑmɑnɛ fei sɑ̃ɑ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Idũ ɑjɔ nŋu ɡɔ mɔkɔ ɡɔ í bɔ bi Jesu ɑ̀ yɑ kpoo Nikodɛmu. Mɔkɔu Fɑrisii, nɔ wɑ jɛ inɛ nɡboi Zuifu ɡɔ ŋɑ. Iyi í to bi Jesu ŋɔi í ni, Mɛɛtu, ɑ̀ mɑ̀ iyi Ilɑɑɔ̃i í bɛɛ wɑ i nɑɑ i kɔ nwɑ si cio. À mɑ̀ bɛɛbɛi si nɑ iyi í jɔ̀ inɛ ɡɔ kù wɛɛ iyi ɑ́ yɔkɔ ku ce mɑɑmɑɑke ŋɑ iyi ì yɑ mɑɑ ce bii kù jɛ Ilɑɑɔ̃i í wɛɛ do lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ŋɔi Jesu í jɛɑɑ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ɛi, nɔ ɑ kù bí inɛ isɛ ɡbeejisiɑ kɑɑ yɔkɔ ku yɛ ɑndunyɑ titɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ammɑ Nikodɛmu í beeɛ í ni, inɛ iyi í lɑ tɑ̃, bɛirei ɑɑ ce ɑ búu mɑ́. Á nyi inɔi iyeɛ ɑ bɛi ɑ buu isɛ ɡbeejisiɑ mɑ́i? ");
INSERT INTO mkl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ŋɔi Jesu í jɛɑɑ í ni, ntɔ ntɔ, bii kù jɛ inyi do Hundei Ilɑɑɔ̃i í bi inɛ ɡɔ, lɑfɛ̃ɛ kɑɑ yɔkɔ ku lɔ ɑndunyɑ titɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Amɑnɛ ɑmɑnɛi í yɑ bí, Hundei Ilɑɑɔ̃ mɔ hundei í yɑ bí. ");
INSERT INTO mkl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ǹ sɔ̃ɛ ǹ ni, í ɡbe ɑ bí inɛ isɛ ɡbeejisiɑ. Ammɑ mɑɑ̀ jɔ̀ ideu ku muɛ biti. ");
INSERT INTO mkl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fufu í yɑ mɑɑ cei do bii í bi, nɔ ì yɑ mɑɑ ɡbɔ ibɑɛ, mɑ̀ irei. Ammɑ i kɑɑ mɑ̀ hɑi bii wɑ nɑɑ hee mɑ́ jɛ bii wɑ bɔ. Bɛɛbɛ mɔi í yɛ do inɛ iyi Hundei Ilɑɑɔ̃ í bí fei. ");
INSERT INTO mkl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ŋɔi Nikodɛmu í beeɛ í ni, bɛirei ɑ́ ce ku ce. ");
INSERT INTO mkl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ŋɔi Jesu í jɛɑɑ í ni, ɑwɔi ì wɑɑ kɔ inɛi Izirɛli ŋɑ si cio nɔ i kù mɑ̀ yɑɑsei ideu bɛ? ");
INSERT INTO mkl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ntɔ ntɔ ǹ wɑ n sɔ̃ɛ, ide iyi ɑ̀ mɑ̀i ɑ̀ wɑɑ fɔ, nɔ ɑ̀ wɑɑ jɛ sɛɛdɑi mii iyi ɑ̀ yɛ. Ammɑ do nŋu fei, i ci yɑ jɛsi sɛɛdɑ nwɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ǹ wɑ n sɔ̃ ŋɛ ide iyi wɑ ce si ɑndunyɑ nɔ i kù dɑsi nɑɑnɛ ŋɑ. To, bii bɛɛbɛi, nɔ bɛirei ɑɑ ce i dɑsi nɑɑnɛ ŋɑ bii n sɔ̃ ŋɛ mii ŋɑ iyi wɑ ce lelei Aɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Inɛ ɡɔ kù wɛɛ iyi í bɔ lelei Aɔ̃ bii kù jɛ ɑmu Amɑi Amɑnɛ, ɑmu iyi ǹ kitɑ wɑ hɑi lelei Aɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Si bɛi Moizi í kɔɑ njo si jĩi í wuu lele si ɡbɑɑu, bɛɛbɛ mɔi ɑmu Amɑi Amɑnɛ kù nɛ bɛi ɑ́ ce iyi ɑ kù wu ɑrɑm lele, ");
INSERT INTO mkl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ku bɑ inɛ iyi í dɑsim nɑɑnɛ fei ku bɑ kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ilɑɑɔ̃ í bi inɛi ɑndunyɑ ŋɑ jiidɑ jiidɑ hee í nɑ ŋɑ Amɑ ɑkɑ̃ɛ ku bɑ inɛ iyi í dɑsiɛ nɑɑnɛ fei ku mɑɑ̀ ce nfe, ɑmmɑ kú nɛ kuwɛɛ iyi ci yɑ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ilɑɑɔ̃ kù bɛ Amɑɛ wɑ si ɑndunyɑ ku bɑ ku yɛò tɑɑlei inɛi ɑndunyɑ ŋɑ, ɑmmɑ í bɔɔ wɑi ku bɑ inɛi ɑndunyɑ ŋɑ ɑ bɑ fɑɑbɑ nɑ sɑɑbuɛ. ");
INSERT INTO mkl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Inɛ iyi í dɑsiɛ nɑɑnɛ, Ilɑɑɔ̃ kɑɑ yɛ tɑɑleɛ, ɑmmɑ inɛ iyi kù dɑsiɛ nɑɑnɛ í yɛ tɑɑlei lɑfɛ̃ɛ tɑ̃, si nɑ iyi í jɔ̀ kù dɑsi ɑmɑ ɑkɑ̃ɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Í yɛ tɑɑlei inɛ dimi bɛɛbɛ ŋɑi si nɑ iyi í jɔ̀ inyɑ kumɑ́ í nɑɑ si ɑndunyɑ, ɑmmɑ inɛ ŋɑ ɑ̀ bi ilu kuku í re inyɑ kumɑ́u. À bi ilu kukuui si nɑ iyi í jɔ̀ kuce nŋɑ kù sĩɑ. ");
INSERT INTO mkl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ntɔ ntɔ, inɛ iyi wɑ ce lɑɑlɔ fei í yɑ cé inyɑ kumɑ́i. Ci yɑ nɑɑ si inyɑ kumɑ́u ku bɑ mii iyi wɑ ce ku mɑɑ̀ fitɑ ɡbuɡbɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ammɑ inɛ iyi wɑ too kpɑ̃ɑi ntɔ í yɑ ce icɛɛ ŋɑi do idɔɔbii Ilɑɑɔ̃. Nɑ ŋɔi í jɔ̀ ɑ́ nɑɑ si inyɑ kumɑ́ ku bɑ ɑ yɛ mii iyi nŋu wɑ ce ti idɔɔbii Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Si ɑnyii nŋu, Jesu do mɔcɔɛ ŋɑ ɑ̀ bɔ ilɛi Zudee. Aŋɑò ŋɑ ɑ̀ ce bɛ ɑjɔ minji, nɔ Jesu í dɑsi inɛ ŋɑ inyi. ");
INSERT INTO mkl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Zɑ̃ɑ mɔ wɑ dɑsi inɛ ŋɑ inyi ilui Enɔɔ, kɔkɔi Sɑlimu, domi inyi í kpɔ bɛ. Inɛ ŋɑ ɑ̀ wɑsi ku koo siɛ nɔ wɑ dɑsi ŋɑ inyi. ");
INSERT INTO mkl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wɑɑti bɛɛbɛ ɑ kù dɑsi Zɑ̃ɑ piisɔ̃ɔ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ŋɔi mɔcɔi Zɑ̃ɑ ŋɑ do Zuifu ɡɔ ɑ̀ wɑɑ ce kɑkɔɔ si buki iyi ɑmɑnɛ ɑ́ ce ku bɛi ku mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ŋɔi ɑ̀ bɔ bi Zɑ̃ɑ ɑ̀ ni, Mɛɛtu, ɑjɔɛ ì jɛ sɛɛdɑi mɔkɔ iyi iŋɛò ì wɑ icei idoi Zuudɛ̃ɛu, mɑ̀ irei. Wee nsɛi nŋu mɔ wɑ dɑsi inɛ ŋɑ inyi, nɔ inɛ fei wɑ bɔ bi tɛɛ. Kù jɛɛ si ide kɑ̃mɑ? ");
INSERT INTO mkl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ŋɔi Zɑ̃ɑ í sɔ̃ ŋɑ í ni, inɛ ɡɔ kɑɑ yɔkɔ ku bɑ nɡɔɡɔ bii kù jɛ Ilɑɑɔ̃i í muɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Iŋɛ tɑkɑ nŋɛ ì jɛ sɛɛdɑm iyi ǹ ni n kù jɛ inɛ iyi Ilɑɑɔ̃ í cicɑ, ɑmmɑ ɑ̀ bɛm wɑi ku bɑ n cuɑɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Inɛ iyi í nɛ ɑbo titɔ̃ nŋui í jɛ mɔkɔ titɔ̃, mɑ̀ irei. Ammɑ kpɑɑsii mɔkɔ titɔ̃u, inɛ nŋu ɑ́ leekĩi ku mɑɑ ɡbɔ. Nŋu mɔ í yɑ nɛ inɔ didɔ̃ ntɔ ntɔ wɑɑti iyi í ɡbɔ imui mɔkɔ titɔ̃u. Nɑ ŋɔi í jɔ̀ nsɛi ɑmu tɑkɑm ǹ nɛ inɔ didɔ̃ nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kù nɛ bɛi ɑ́ ce iyi bɛɛrɛi Jesu kù kɔ̃ɔsi, nɔ tom kù nɛ bɛi ɑ́ ce iyi kù kɑye. ");
INSERT INTO mkl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nɔ Zɑ̃ɑ í ni mɑ́, inɛ iyi í nɑɑ hɑi lele nŋui í re inɛ fei. Inɛ iyi í jɛ ti ɑndunyɑ, inɛi ɑndunyɑi, idei ɑndunyɑi í yɑ mɑɑ fɔ. Inɛ iyi í nɑɑ hɑi lele nŋui í re inɛ fei. ");
INSERT INTO mkl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Wɑ jɛ sɛɛdɑi mii iyi í yɛ do iyi í ɡbɔ. Ammɑ inɛ kɑ̃mɑ kù wɑɑ jɛsi sɛɛdɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Inɛ iyi í jɛsi sɛɛdɑɛ, í jɛsi iyi Ilɑɑɔ̃ í jɛ ilu ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Inɛ iyi Ilɑɑɔ̃ í bɛ wɑ idei Ilɑɑɔ̃i wɑ fɔ, domi Ilɑɑɔ̃ í muɑɑ Hundeɛ do inɔ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ilɑɑɔ̃ Bɑɑbɑ í bi Amɑɛ nɔ í dɑɑ mii fei si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Inɛ iyi í dɑsi ɑmɑu nɑɑnɛ fei í nɛ kuwɛɛ hɑi tɑ̃. Inɛ mɔ iyi í kɔ ku dɑsiɛ nɑɑnɛ kɑɑ bɑ kuwɛɛu, ɑmmɑ idɔɔkɔ̃i Ilɑɑɔ̃ í wɑ si irii lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Fɑrisi ŋɑ ɑ̀ ɡbɔ iyi Jesu wɑ bɑ mɔcɔ ŋɑ wɑ dɑsi ŋɑ inyi wɑ re Zɑ̃ɑ. Ammɑ kù jɛ Jesu tɑkɑɛi wɑ dɑsi inɛ ŋɑ inyiu, mɔcɔɛ ŋɑi ɑ̀ wɑɑ coo. Ajɔ nŋu ɡɔ Jesu í ɡbɔ iyi ɑ̀ wɑɑ fɔ bɛɛbɛ, ŋɔi í nɛ hɑi Zudee bɛ wɑ bɔ ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wee ku bɛi ku to bɛ tilɑsii ku too do ilɛi Sɑmɑri. ");
INSERT INTO mkl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ŋɔi í to si ilui Sɑmɑri ɡɔ iyi ɑ̀ yɑ kpe Sikɑɑ, kɔkɔi iko iyi Zɑkɔbu í muɑ Zozɛfu ɑmɑɛu. ");
INSERT INTO mkl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Bɛi lɔɡɔi Zɑkɔbuu í wɑ. Jesu í to bɛi zɑkɑi dɑsɑ̃. Ŋɔi í koo í bubɑ si itĩi lɔɡɔu si nɑ iyi í jɔ̀ í ɡbɛɛji do isɛɛnɛu. ");
INSERT INTO mkl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ŋɔi inɑɑboi Sɑmɑri ɡɔ í nɑɑ inyi ku kpɑ̃. Ŋɔi Jesu í ni, muum inyi n mɔ. ");
INSERT INTO mkl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Wee mɔcɔɛ ŋɑ ɑ̀ bɔ inɔ ilu ijɛ ku rɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ŋɔi ɑbou í sɔ̃ Jesu í ni, ɑwɔ Zuifu, bɛirei í ce ì wɑɑ tɔɔm inyi ku mɔ, ɑmu inɑɑboi Sɑmɑri. Abou í ni bɛɛbɛi si nɑ iyi í jɔ̀ Zuifu ŋɑ do inɛi Sɑmɑri ŋɑ ɑ ci yɑ ce njɛ fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ŋɔi Jesu í jɛɑɑ í ni, bii ì mɑ̀ ɑmuɑi Ilɑɑɔ̃ wo, nɔ bii ì mɑ̀ inɛ iyi wɑ tɔɔɛ inyi ku mɔ, ɑɑ tɔɔm nii wo nɔ n muɛ inyii kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ŋɔi ɑbou í sɔ̃ɔ í ni, mɔkɔɔyi, i kù nɛ ɡookɑ. Wee lɔɡɔu í jĩ isɑ. Bɛirei ɑɑ ce i bɑ inyii kuwɛɛu. ");
INSERT INTO mkl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Zɑkɔbu, bɑlɑ nwɑi í tu nwɑ lɔɡɔu ihɛ̃. Nɔ nŋu do ɑmɑɛ ŋɑ do mɛɛmuɛ ŋɑ fei ihɛ̃i ɑ̀ yɑ mɔ. Mɑ̀ ɑwɔ ì wɑɑ tɑmɑɑ ì re Zɑkɔbu bɑlɑ nwɑui. ");
INSERT INTO mkl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ŋɔi Jesu í jɛɑɑ í ni, inɛ iyi í yɑ mɔ inyii lɔɡɔu ihɛ̃ fei, ɑɡbɛ ɑ́ kpɑɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ammɑ inɛ iyi ɑn muɑ inyi ku mɔ, ɑɡbɛ kɑɑ kpɑ lɑfɛ̃ɛ mɑ́, domi inyi iyi ɑn muɑ lɑfɛ̃ɛ ɑ́ mɑɑ sɔ̃i bɛi inyii isɔ̃ nɔ ɑ́ nɑ inɛ kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ŋɔi ɑbou í ni, mɔkɔɔyi, ǹ bi i muum dimii inyiu bɛ ku bɑ ɑɡbɛ ku mɑɑ̀ kpɑm mɑ́ nɔ n mɑɑ̀ n nɑɑ inyi ku kpɑ̃ ihɛ̃ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ŋɔi Jesu í sɔ̃ɔ í ni, koo kpe mɔkɔɛ wɑ i nɑɑ wɑ ihɛ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ŋɔi ɑbou í jɛɑ Jesu í ni, n kù nɛ mɔkɔ. Ŋɔi Jesu mɔ í ni, ntɔi ì fɔ iyi ì ni i kù nɛ mɔkɔ, ");
INSERT INTO mkl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","domi mɔkɔ miui ì tɑko ì nɛ. Nɔ wee mɔkɔ iyi ì nɛ si nsɛi kù jɛ mɔkɔɛ. Inɛ nŋu ntɔi ì fɔ. ");
INSERT INTO mkl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ŋɔi ɑbou í ni, mɔkɔɔyi, ǹ yɛ iyi ɑwɔu wɑliii. ");
INSERT INTO mkl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","To, ɑwɑ inɛi Sɑmɑri ŋɑ, bɑlɑ nwɑ ŋɑ si ɡeeteu ihɔ̃i ɑ̀ yɑ ɡulɛ ɑ tɔɔ Ilɑɑɔ̃ wo, ɑmmɑ iŋɛ Zuifu ŋɑ, ì ni í ɡbe Zeruzɑlɛmui inɛ ku yɑ ɡulɛ ku tɔɔɛ. ");
INSERT INTO mkl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nɔ Jesu í sɔ̃ɔ í ni, ɑbooyi, dɑsi idem iyi ɑn sɔ̃ɛ nɑɑnɛ. Awɑɑti wɑ nɑɑ iyi ɑ kɑɑ ɡulɛ ɑ tɔɔ Ilɑɑɔ̃ Bɑɑbɑ si ɑntɑi ɡeeteu ihɔ̃ hee mɑ́ jɛ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Iŋɛ inɛi Sɑmɑri ŋɑ, ì wɑɑ ɡulɛɑ Ilɑɑɔ̃, ɑmmɑ i kù mɑ̀ɑ ŋɑ. Awɑ Zuifu ŋɑ ɑ̀ mɑ̀ɑ ɑ̀ bɛi ɑ̀ wɑɑ ɡulɛɑò, domi idei fɑɑbɑ wɑ nɑɑi hɑi bi Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ammɑ ɑwɑɑti ɡɔ ɑ́ nɑ ku nɑɑ, nɔ í to wɑ tɑ̃ mɔm de, iyi Hundei Ilɑɑɔ̃ ɑ́ jɔ̀ inɛ ŋɑ ɑ mɑɑ ɡulɛ ɑ tɔɔ Ilɑɑɔ̃ Bɑɑbɑ do ntɔ. Woo ɡulɛɑɑ do yɑɑse bɛɛbɛ ŋɑi í bi. Inɛ bɛ ŋɑi ɑ̀ jɛ woo ɡulɛɑɑ Ilɑɑɔ̃ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ilɑɑɔ̃i í jɛ Hunde, nɔ kù nɛ bɛi ɑɑ ce iyi ɑ kù ɡulɛɑɑ si Hunde do si ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ŋɔi ɑbou í sɔ̃ɔ í ni, ǹ mɑ̀ inɛ iyi Ilɑɑɔ̃ í cicɑ ɑ́ nɑ ku nɑɑ. Bii í nɑɑ nŋui ɑ́ sisi nwɑ fei ndɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ŋɔi Jesu í ni, ɑmui ihɛ̃, ɑmu iyi ǹ wɑ n bɑɛ ide ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wɑɑti bɛɛbɛ mɔcɔi Jesu ŋɑu ɑ̀ to wɑ. Ŋɔi ideu í mu ŋɑ biti ntɔ ntɔ do iyi ɑ̀ yɛ wɑ bɑ inɑɑbo ide ku fɔ. Do nŋu fei, kɑ̃mɑ nŋɑ ɡɔ kù bee ɑbou mii iyi í bi. A kù nɔ ɑ kù bee Jesu ɑ kù ni, mii í ce ì wɑɑ bɑ ɑbou ide ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ŋɔi ɑbou í jilɛ bɔɔdoɛ bɛ í nyi inɔ ilu í koo í sɔ̃ inɛ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","i nɑɑ i koo i cɔ inɛ ɡɔ iyi í sɔ̃m mii iyi ǹ tɑko ǹ ce fei. Mɑ̀ inɛ iyi Ilɑɑɔ̃ í cicɑu mbɛ yɑ. ");
INSERT INTO mkl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nɔ inɛ ŋɑ ɑ̀ fitɑ wɑ hɑi inɔ iluu ɑ̀ wɑɑ bɔ bi Jesu. ");
INSERT INTO mkl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wɑɑti bɛɛbɛ mɔcɔɛ ŋɑ ɑ̀ wɑsi ku mɑnteɛ ɑ̀ wɑɑ ni, Mɛɛtu, jɛ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ammɑ í sɔ̃ ŋɑ í ni, ǹ nɛ dimii ijɛ ɡɔ iyi i kù mɑ̀ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ŋɔi mɔcɔ ŋɑu ɑ̀ bee njɛ ɑ̀ wɑɑ ni, mɑ̀ inɛ ɡɔ í nɑɑ ijɛ wɑi de. ");
INSERT INTO mkl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nɔ Jesu í sɔ̃ ŋɑ í ni, ijɛm nŋui í jɛ n ce idɔɔbii inɛ iyi í bɛm wɑ nɔ n kpɑ irii icɛɛ iyi í dɑsim. ");
INSERT INTO mkl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Iŋɛ ì wɑɑ ni í ɡbe cukpɑ mɛɛ ɑ bɛi ɑ dɑ iyɑ. Ammɑ ɑmu ǹ wɑ n sɔ̃ ŋɛ, i cɔ iko ŋɑu, mii ku ɡbɛ̃ ŋɑu fei í jĩɑ í to ku dɑ. ");
INSERT INTO mkl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Inɛ iyi wɑ dɑ í wɑsi fiɑɛ ku ɡbɑ tɑ̃, nɔ ɑmɑɑjɛ iyi wɑ tɔtɔɔu ti kuwɛɛ hɑi tɑ̃i. Si bɛɛbɛ woo ɡbɛ̃ do woo dɑ ɑ̀ nɛ inɔ didɔ̃ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","À yɑ kpɑ mɔndɑ ɡɔ ɑ ni, inɛ ɡɔ wɑ ɡbɛ̃ nɔ inɛ mmu ɡɔ wɑ dɑ. Mɔndɑu ntɔi wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ǹ bɛ ŋɛi i koo i dɑ si iko bii i kù loɡoo ŋɑ. Inɛ ɡɔ ŋɑi ɑ̀ ce icɛ bɛ, wee nsɛi iŋɛi ì nɑɑ ì wɑɑ dɑ mii iyi ɑ̀ ɡbɛ̃u ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Inɛi Sɑmɑri nkpɔ nkpɔi í dɑsi Jesu nɑɑnɛ si inɔ iluu bɛ si nɑ iyi í jɔ̀ ɑbou í tɑko í sɔ̃ ŋɑ í ni Jesu í sɔ̃ nŋu mii iyi nŋu í ce wo fei. ");
INSERT INTO mkl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nɑ nŋu, inɛi Sɑmɑri ŋɑu ɑ̀ koo ɑ̀ bɑ Jesu ɑ̀ tɔɔɛ suuru ku ɡbe bi ti ɑŋɑ. Nɔ í ce bɛ ɑjɔ minji. ");
INSERT INTO mkl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Inɛ nkpɔi í dɑsi nɑɑnɛ mɑ́ wɑɑti iyi ɑ̀ ɡbɔ idei Jesu, ");
INSERT INTO mkl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ŋɔi ɑ̀ sɔ̃ ɑbou ɑ̀ ni, kù jɛ nɑ ide iyi ì fɔu nŋu ɑkɑ̃i í jɔ̀ ɑ̀ dɑsi Jesu nɑɑnɛ mɑ́, ɑmmɑ si nɑ iyi í jɔ̀ ɑwɑ tɑkɑ nwɑ ɑ̀ ɡbɔ ideɛi nɔ ɑ̀ mɑ̀ iyi do ntɔ nŋui í jɛ Woo fɑɑbɑi ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iyi Jesu í ce ɑjɔ minji bɛ ŋɔi í nɛ í bɔ ikpɑ ilɛi Gɑlilee, ");
INSERT INTO mkl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","domi nŋu tɑkɑɛ í fɔ wo í ni, wɑlii ci yɑ nɛ bɛɛrɛ si iluɛ. ");
INSERT INTO mkl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iyi í to Gɑlilee ŋɔi inɛ ŋɑu ɑ̀ ɡbɑɑ do inɔ didɔ̃. Tɑko wo ɑ̀ bɔ jinɡɑu Zeruzɑlɛmu nɔ ɑ̀ yɛ mii iyi í ce bɛ fei. Nɑ ŋɔi í jɔ̀ ɑ̀ ɡbɑɑ do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nɔ í nyi í bɔ Kɑnɑ si ilɛi Gɑlilee mɑ́, tenɡi bii í tɑko í jɔ̀ inyi í kpɑɑsi vɛ̃ɛu. Wee ɑkɑwei ilɑɑlu ɡɔ í wɑ Kɑpɛrɑnumu, ɑmɑɛ kù wɑɑ nɛ bɑɑni. ");
INSERT INTO mkl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ŋɔi í ɡbɔ iyi Jesu í nɛ hɑi ilɛi Zudee í nɑɑ ilɛi Gɑlilee. Ŋɔi í dede hɑi Kɑpɛrɑnumu í bɔ bi tɛɛ í koo í tɔɔɛ suuru ku nɑ ku fɑɑbɑ ɑmɑi nŋu iyi wɑ bi ku ku. ");
INSERT INTO mkl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ŋɔi Jesu í jɛɑɑ í ni, iŋɛ i ci yɑ dɑsi nɑɑnɛ ɑjɔ kɑ̃mɑ ŋɑ bii kù jɛ ì yɛ nyindɑ do mɑɑmɑɑke ɡɔ ŋɑ sisi. ");
INSERT INTO mkl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ŋɔi ɑkɑweu í ni, mɔkɔɔyi, ǹ wɑ n tɔɔɛ suuru i nɑɑ wɑ bi tom hee ɑmɑu ku mɑɑ ku. ");
INSERT INTO mkl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ŋɔi Jesu í sɔ̃ɔ í ni, koo i nɛ, ɑmɑɛ ɑ́ wɛɛ. Nɔ inɛɛu í dɑsi idei Jesuu nɑɑnɛ nɔ í nɛ. ");
INSERT INTO mkl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iyi í dɑsi kpɑ̃ɑi ideɛ wɑ nɛ ŋɔi í ko woo ce icɛɛ ŋɑ ɑ̀ wɑɑ nɑɑ. Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, ɑmɑɛ í bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ŋɔi í bee ŋɑ si wɑɑti yoomɑi í bɑ iri. Ŋɔi ɑ̀ ni, ɑnɑ isɔ ɑkɑ̃i bɔ̃ɔu í nyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ŋɔi bɑɑi ɑmɑu í ye ɡiɡi iyi wɑɑtiu bɛi Jesu í sɔ̃ɔ ideu dee dee í ni, ɑmɑɛ ɑ́ wɛɛ. Nɔ nŋu do inɛi kpɑsɛ̃ɛ ŋɑ fei ɑ̀ dɑsi Jesu nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Isɛ ɡbeejisiɑi ihɛ̃ bɛbɛi iyi Jesu í dede hɑi ilɛi Zudee í nɑɑ ilɛi Gɑlilee nɔ si kunɑɑɛu fei í ce mɑɑmɑɑkei. Iyi ihɛ̃i í jɛ mɑɑmɑɑke minjisiɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Si ɑnyiɛ ŋɔi jinɡɑu ɡɔ í to wɑ. Jinɡɑui Zuifu ŋɑi. Nɔ Jesu í bɔ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Wee Zeruzɑlɛmu bɛ, bi ku lɔò inɔ iluu í kpɔ. Andɛ ɑkɑ̃i ɑ̀ yɑ kpe Andɛi ɑnɡudɑ̃ ŋɑ. Kɔkɔi ɑndɛu bɛi fɑtɑmɑ nlɑ ɡɔ í wɑ. Nɔ ɑ̀ mɑ si ile iyi í nɛ ɑndɛ miu. Do feei Ebɛɛ Bɛtizɑdɑi ɑ̀ yɑ kpoo. ");
INSERT INTO mkl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Si ɑndɛi ile ŋɑui bɔ̃ɔ nkpɔ í yɑ nɑ ku mɑɑ sũ, fɛɛju ŋɑ do woo sukutɛ do wɛɛɡɛ ŋɑ. Bɛi ɑ̀ yɑ sũ ɑ mɑɑ deɡbe kuyɑyɑi inyiu, ");
INSERT INTO mkl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","domi ɑjɔ ɡɔ ŋɑ ɑmɑlekɑi Ilɑɑɔ̃ í yɑ kitɑ wɑ ku lɔ si fɑtɑmɑu nɔ ku fɔ inyiu. Bii inyiu í fɔ bɔ̃ɔ iyi í tɑko í dɑsi bɛ dimii bɔ̃ɔ iyi í nɛ fei í yɑ bɑ irii. ");
INSERT INTO mkl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wee inɛ ɡɔ í wɑ bɛ, bɔ̃ɔu ɑdɔ̃ kuntɑɑ do mɛɛjɔi í ce siɛ. ");
INSERT INTO mkl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iyi Jesu í yɔɔ wɑ sũ bɛ í bɛi í mɑ̀ iyi í kpɛ bɛ ŋɔi í beeɛ í ni, ì bi i bɑ iri? ");
INSERT INTO mkl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ŋɔi bɔ̃ɔu í jɛɑɑ í ni, mɔkɔɔyi, n kù nɛ inɛ iyi ɑ́ dɑsim si inyiu wɑɑti iyi í fɔ. Hee n mɑɑ n kookɑɑi n mɑɑ n dɑsi inyiu, inɛ ɡɔ í yɑ tɑkom nii. ");
INSERT INTO mkl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ŋɔi Jesu í sɔ̃ɔ í ni, dede i kɑ sɛ̃ɛɛ, i nɛò. ");
INSERT INTO mkl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ŋɔi ɡbɑkɑ̃ inɛɛu í bɑ iri nɔ í kɑ sɛ̃ɛɛ í dɑsi kpɑ̃ɑ wɑ nɛ. Wee ɑjɔi kusĩmii. ");
INSERT INTO mkl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ŋɔi inɛ nɡboi Zuifu ŋɑu ɑ̀ sɔ̃ inɛ iyi í bɑ iriu ɑ̀ ni, ɑjɔi kusĩmii nnyi. Woodɑ nwɑ í ɡɑnji i so sɛ̃ɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ŋɔi í sɔ̃ ŋɑ í ni, inɛ iyi í jɔ̀ n bɑ irii í ni n so sɛ̃ɛm n nɛ. ");
INSERT INTO mkl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, yooi í sɔ̃ɛ í ni i so sɛ̃ɛɛ i nɛ. ");
INSERT INTO mkl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ammɑ inɛ iyi í bɑ iriu kù mɑ̀ lɑfɛ̃ɛ si nɑ iyi í jɔ̀ zɑmɑɑ í wɑ bɛ nɔ Jesu í dɑsi inɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Iyi í ce sɑ̃ɑ ŋɔi Jesu í yɔɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ nɔ í sɔ̃ɔ í ni, wee ì bɑ iri bɛbɛi. To, mɑɑ̀ ce dulum mɑ́ ku bɑ lɑɑlɔ iyi í re bɛɛbɛ ku mɑɑ̀ bɑɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ŋɔi inɛɛu í nyi bi inɛ nɡbo ŋɑu í sɔ̃ ŋɑ í ni Jesui í jɔ̀ nŋu í bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ŋɔi í jɔ̀ inɛ ŋɑu ɑ̀ wɑɑ kpɑ̃ Jesu iju si nɑ iyi í jɔ̀ í ce dimii mii nɔu bɛ si ɑjɔi kusĩmi. ");
INSERT INTO mkl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ammɑ Jesu í sɔ̃ ŋɑ í ni, Bɑɑm í yɑ mɑɑ ce icɛi wɑɑti kɑ̃mɑ fei, bɛɛbɛ mɔi ɑmu tɑkɑm ǹ wɑ n ce. ");
INSERT INTO mkl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nɑ irii ideu bɛi Zuifu ŋɑ ɑ̀ teese ɑ̀ wɑɑ dɛ Jesu ku kpɑ, kù jɛ si nɑ iyi í jɔ̀ í jɔ̀ inɛɛu í bɑ iri si ɑjɔi kusĩmi nŋu ɑkɑ̃, ɑmmɑ si nɑ iyi í jɔ̀ wɑ wɑ̃ ɑrɑɛi do Ilɑɑɔ̃ mɑ́, wɑ ni Ilɑɑɔ̃i í jɛ bɑɑi nŋu. ");
INSERT INTO mkl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, ɑmu Amɑ, n kɑɑ n yɔkɔ n ce nɡɔɡɔ do ɑrɑm bii kù jɛ mii iyi ǹ yɛ Bɑɑm wɑ ce. Mii iyi Bɑɑbɑ wɑ ce fei, nŋui ɑmu mɔ Amɑ ǹ wɑ n ce. ");
INSERT INTO mkl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bɑɑbɑ í bi ɑmu Amɑɛ nɔ í nyisim mii iyi nŋu tɑkɑɛ wɑ ce fei. Á nyisim icɛ iyi í re bɛ ihɛ̃ mɑ́ mɔm ku bɑ iŋɛ fei i biti ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ntɔ ntɔ, si bɛi Ilɑɑɔ̃ Bɑɑbɑ í yɑ jĩ iku ŋɑ nɔ ku ce ŋɑ ilu hunde, bɛɛbɛ mɔi ɑmu Amɑɛu ɑn muɑ inɛ ŋɑ iyi ǹ bi kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ilɑɑɔ̃ Bɑɑbɑ tɑkɑɛ ci yɑ kiiti inɛ ɡɔ, ɑmmɑ í so kiitiu fei í dɑɑ ɑmu Amɑɛ si ɑwɔ, ");
INSERT INTO mkl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ku bɑ inɛ fei ku sɑɑlu ɑmu Amɑu si bɛi ɑ̀ wɑɑ sɑɑlu Ilɑɑɔ̃ Bɑɑbɑ. Inɛ iyi kù sɑɑlu ɑmu Amɑu, Bɑɑbɑ iyi í bɛm wɑi kù sɑɑlu. ");
INSERT INTO mkl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, inɛ iyi wɑ ɡbɔ idem nɔ í dɑsi inɛ iyi í bɛm wɑ nɑɑnɛ, lɑfɛ̃ɛ í nɛ kuwɛɛ hɑi tɑ̃. Kɑɑ nɑɑ bi ku ce kiiti mɑ́, ɑmmɑ í kuɑ iku í lɔsi kuwɛɛi. ");
INSERT INTO mkl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ntɔ ntɔ, ɑwɑɑti wɑ nɑɑ nɔ wee í to wɑ tɑ̃, iyi iku ŋɑ ɑɑ ɡbɔ imui ɑmu Amɑi Ilɑɑɔ̃ nɔ si inɔ nŋɑ inɛ ŋɑ iyi ɑ̀ ɡbɔ imum fei ɑɑ nɛ kuwɛɛ . ");
INSERT INTO mkl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Si bɛi Bɑɑbɑ tɑkɑɛ í jɛ irii kuwɛɛ, bɛɛbɛ mɔi í jɔ̀ ɑmu Amɑɛ ǹ jɛ. ");
INSERT INTO mkl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nɔ í muum kpɑ̃ɑ n kiitiò inɛ ŋɑ, si nɑ iyi í jɔ̀ ǹ jɛ Amɑi Amɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nɑ nŋu, i mɑɑ̀ biti ŋɑ, domi wɑɑti wɑ nɑɑ iyi iku ŋɑ fei ɑɑ ɡbɔ imum, ");
INSERT INTO mkl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nɔ ɑɑ fitɑ wɑ hɑi si bɑlɛ. Inɛ ŋɑ iyi ɑ̀ ce jiidɑɛ ɑɑ jĩ si kuwɛɛ hɑi tɑ̃. Inɛ ŋɑ mɔ iyi ɑ̀ ce lɑɑlɔ ɑɑ jĩ nɔ ɑ kiiti ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesu í ni, n kɑɑ n yɔkɔ n ce nɡɔɡɔ do ɑrɑm. Si bɛi Ilɑɑɔ̃ í sɔ̃m si bɛɛbɛi ɑn ceò kiitiu, nɔ kiitim í jɛ dee dee domi n kù wɑ n dɛ idɔɔbim ku ce, bii kù jɛ idɔɔbii inɛ iyi í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Bii ɑmu tɑkɑm nii ǹ wɑ n jɛɑ ɑrɑm sɛɛdɑ wo, sɛɛdɑm kù jɛ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ammɑ inɛ ɡɔ í wɛɛ iyi wɑ jɛɑ inɛ ŋɑ sɛɛdɑm nɔ ǹ mɑ̀ iyi sɛɛdɑ iyi wɑ jɛ nŋɑ nɑ irim nɔu ntɔi. Lɑfɛ̃ɛi í jɛ Zɑ̃ɑ woo dɑsi inyi. ");
INSERT INTO mkl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Iŋɛi í bɛ siɛ inɛ ŋɑ, nɔ ide iyi í fɔ si ɡɑ̃mɛm nɔu ntɔi. ");
INSERT INTO mkl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kù jɛ ǹ wɑ n dɛ ɑmɑnɛ ku jɛɛm sɛɛdɑ, ɑmu de ǹ wɑ n fɔ bɛɛbɛi ku bɑ i bɑ fɑɑbɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zɑ̃ɑu bɛ í yɛi bɛi fitilɑ iyi ɑ̀ mɑ́ ku mɑ́ inyɑ. Nɔ wɑɑti keeke ɡɔ ì jɛsi i wɛɛò inɔ didɔ̃ si inyɑ kumɑ́ɛu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ammɑ sɛɛdɑ ɡɔ í wɛɛ iyi í lɑ í re ti Zɑ̃ɑ. Sɛɛdɑui í jɛ icɛ iyi ǹ wɑ n ce. Aɔ̃ Bɑɑbɑi í dɑɑm si ɑwɔ, nŋu mɔi wɑ jɛɑ inɛ ŋɑ sɛɛdɑm nɔ wɑ nyisi iyi Ilɑɑɔ̃ Bɑɑbɑi í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ilɑɑɔ̃ Bɑɑbɑ tɑkɑɛi wɑ jɛɑ inɛ ŋɑ sɛɛdɑm. Ammɑ iŋɛ i kù ɡbɔ ide ku fɔɛ bɑɑ ɑjɔ ɑkɑ̃ ŋɑ hee mɑ́ jɛ i yɔɔ do iju ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ideɛ kù bɑ bi ku bubɑ si ŋɛ, domi i kù dɑsi ɑmu iyi í bɛ wɑu nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Iŋɛ í yɑ mɑɑ cio kukɔi idei Ilɑɑɔ̃ si nɑ iyi í jɔ̀ ì wɑɑ tɑmɑɑ ɑɑ bɑ siɛ kuwɛɛ hɑi tɑ̃ ŋɑ. Nɔ wee kukɔ ŋɑu bɛ fei wɑ jɛɑ inɛ ŋɑ sɛɛdɑm. ");
INSERT INTO mkl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ammɑ do nŋu fei ì kɔ ku nɑɑ bi tom ku bɑ i bɑ kuwɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","N kù wɑ n dɛ sɑɑbu bi ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ammɑ ǹ mɑ̀ ŋɛ. Ǹ mɑ̀ iyi i kù nɛ kubii Ilɑɑɔ̃ si idɔ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Do irii Bɑɑm nii ǹ nɑɑ, nɔ i kù ɡbɑm ŋɑ. Ammɑ bii inɛ ɡɔ njɛ í nɑɑ do irii ɑrɑi nŋu tɑkɑɛ, lɑfɛ̃ɛi ɑɑ ɡbɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bii bɛɛbɛi bɛirei ɑɑ ce i dɑsim nɑɑnɛ ŋɑ, iŋɛ iyi ì yɑ mɑɑ dɛ sɑɑbui njɛ ŋɑ iŋɛ duusɔ̃ɔ nɔ i kù wɑɑ dɛ sɑɑbu iyi wɑ nɑɑ hɑi bi Ilɑɑɔ̃ ŋɑ, nŋu iyi kù nɛ sɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","I mɑɑ̀ tɑmɑɑ mɑ̀ ɑmui ɑn yɛ tɑɑle nŋɛ bi Ilɑɑɔ̃ Bɑɑbɑ. Moizi, nŋu iyi ì wɑɑ nɑɑnɛ ŋɑu, nŋui ɑ́ yɛ tɑɑle nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bii ì dɑsi Moizi nɑɑnɛ ntɔ ntɔ ŋɑ wo, ɑɑ dɑsi ɑmu mɔ nɑɑnɛ ŋɑ, domi idem nii Moizi í kɔ. ");
INSERT INTO mkl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ammɑ i kù dɑsi ideɛ nɑɑnɛ ŋɑ. To, bɛirei ɑɑ ce i dɑsi idem nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Si ɑnyii nŋu, jinɡɑui Zuifu ŋɑ iyi ɑ̀ yɑ kpe Iku ku kuɑu í mɑɑi wɑ. Wɑɑti bɛɛbɛi Jesu í kuɑ icei tenkui Gɑlilee. Tenkuui ɑ̀ yɑ nyi ɑ kpe Tiberiɑ mɑ́. Ŋɔi zɑmɑɑ nkpɔ wɑ tooɛ, domi ɑ̀ yɛ mɑɑmɑɑke ŋɑ iyi í yɑ mɑɑ ce ku mɑɑ fɑɑbɑò bɔ̃ɔ ŋɑ. Ŋɔi Jesu í ɡũ ɡeete ɡɔ í bubɑ do mɔcɔɛ ŋɑ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iyi í cɔ ilu nɔ í yɛ zɑmɑɑ nlɑ ɡɔi wɑ nɑɑ bi tɛɛ. Ŋɔi í bee Filipu í ni, iwoi ɑɑ kɑ bɑ ijɛ iyi ɑɑ kɑ rɑ inɛ ŋɑu ihɛ̃ ɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Í fɔ bɛɛbɛi ku cɔò lɑɑkɑi Filipu domi í mɑ̀ bɛi nŋu ɑ́ ce tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ŋɔi Filipu í jɛɑɑ í ni, bɑɑ fiɑi icɛi ɑjɔ cĩɔ minji kɑɑ to kɑ rɑ nŋɑ ijɛ, iyi ɑŋɑ fei ɑɑ bɑ kekee kekee. ");
INSERT INTO mkl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ŋɔi inɛ ɑkɑ̃i mɔcɔ ŋɑu iyi ɑ̀ yɑ kpe Anderee, ifɔi Simɔɔ Piɛɛ í ni, ");
INSERT INTO mkl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ɑmɑ ɑwɑɑsũ ɡɔ í wɑ ihɛ̃ í nɛ pɛ̃ɛ ɑrɑ miu do cɛ̃ɛ keeke minji. Ammɑ nŋu bɛ kɑɑ ceɑ zɑmɑɑ nlɑu ihɛ̃ nkɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ŋɔi Jesu í ni, í jɔ̀ ɑŋɑ fei ɑ bubɑ. Wee inyɑu í nɛ fɔfɔ nkpɔ nkpɔ. Ŋɔi ɑŋɑ fei ɑ̀ bubɑ. Si inɔ nŋɑ kukpɔi inɛmɔkɔ ŋɑu í to dubu miu (5.000). ");
INSERT INTO mkl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ŋɔi Jesu í so pɛ̃ɛ ŋɑu í sɑɑbu Ilɑɑɔ̃, ŋɔi í jɔ̀ ɑ̀ kpɛ̃ɑ inɛ ŋɑ iyi ɑ̀ wɑɑ bubɑu. Bɛɛbɛ mɔi í ce do cɛ̃ɛ ŋɑu. Nɔ ɑ̀ jɛ bɛi ɑ̀ bi. ");
INSERT INTO mkl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Iyi ɑŋɑ fei ɑ̀ jɛ ɑ̀ yo, ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, i ko ijɛ iyi í ɡbeu ŋɑ ku bɑ ɡɔɡɔ ku mɑɑ̀ ce nfe. ");
INSERT INTO mkl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nɔ ɑ̀ ko ijɛ iyi í ɡbeu. Si pɛ̃ɛ ɑrɑ miu iyi Jesu í ɡbɑ í bububu í kpɛ̃ɑ inɛ ŋɑ ɑ̀ jɛu, kɔlɔ mɑɑteejii í ɡbe. ");
INSERT INTO mkl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iyi inɛ ŋɑu ɑ̀ yɛ mɑɑmɑɑke iyi Jesu í ceu ŋɔi ɑ̀ ni, do ntɔ, nŋui í jɛ wɑlii iyi ɑ́ nɑ ku nɑɑ si ɑndunyɑu. ");
INSERT INTO mkl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ŋɔi inɛ ŋɑu ɑ̀ wɑɑ bi ɑ muu do ɡbuɡbɑ̃ ɑ coo ilɑɑlu. Ammɑ si bɛi Jesu í mɑ̀ si ŋɑ ŋɔi í nyɑ ɑrɑɛ nŋu ɑkɑ̃ í nyi iri kutɑu mɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iyi ɑlɛ í lɛ ŋɔi mɔcɔi Jesu ŋɑu ɑ̀ bɔ itĩi tenkuu. ");
INSERT INTO mkl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ŋɔi ɑ̀ lɔ ɑkɔi inyi ku bɑ ɑ kuɑ ɑ bɔ Kɑpɛrɑnumu. Nɔ ɑ̀ dɑsi kpɑ̃ɑ ɑ̀ wɑɑ nɛ. Ŋɔi idũ í dũ nɔ wee Jesu kù to si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ŋɔi fufu nlɑ ɡɔ wɑ ce nɔ inyiu wɑ yɑyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iyi ɑ̀ nɛ zɑkɑi kilo mɛɛfɑ ŋɔi ɑ̀ hɔ̃nnɛ Jesu wɑ nɛ si ɑntɑi inyiu wɑ nɑɑ bi tu ŋɑ, ŋɔi ziɡi nŋɑ í dɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ammɑ Jesu í sɔ̃ ŋɑ í ni, ɑmui, i mɑɑ̀ jɔ̀ njo ku mu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ŋɔi ɑ̀ wɑɑ bi nŋu mɔ ku lɔ inɔ ɑkɔi inyiu ɑmmɑ wee ɡbɑkɑ̃ ɑ̀ to bii ɑ̀ wɑɑ bɔu. ");
INSERT INTO mkl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Iju kumɑ́ɛ inɛ ŋɑ iyi ɑ̀ wɑ icei tenkuu bɛ, ɑ̀ ye ɡiɡi iyi ɑkɔ ɑkɑ̃i í wɑ bɛ wo. À nɔ ɑ̀ mɑ̀ iyi Jesu kù lɔ ɑkɔi inyiu do mɔcɔɛ ŋɑ ɑjɔ, ɑŋɑ duusɔ̃ɔ nŋɑi ɑ̀ nɛ. ");
INSERT INTO mkl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wɑɑti bɛɛbɛ, ɑkɔi inyi ɡɔ ŋɑ mɔ ɑ̀ nɑɑ hɑi Tiberiɑ nɔ ɑ̀ to inyɑu. Tenɡi bɛi Lɑfɛ̃ɛ Jesu í tɑko í sɑɑbu Ilɑɑɔ̃ í bɛi í nɑ ŋɑ pɛ̃ɛ ɑ̀ jɛu. ");
INSERT INTO mkl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Iyi zɑmɑɑu í yɛ Jesu do mɔcɔɛ ŋɑ kɑ̃mɑ nŋɑ kù wɑ bɛ, ŋɔi ɑŋɑ mɔ ɑ̀ lɔ ɑkɔi inyi ŋɑu ɑ̀ bɔ ku dɛdɛ ŋɑ ikpɑ Kɑpɛrɑnumu. ");
INSERT INTO mkl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ŋɔi inɛ ŋɑu ɑ̀ kuɑ icei tenkuu do ikpɑ ihɔ̃ ɑ̀ koo ɑ̀ bɑ Jesu bɛ nɔ ɑ̀ ni, Mɛɛtu, wɑɑti yoomɑi í to wɑ ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ŋɔi Jesu í jɛ nŋɑ í ni, ntɔ ntɔ, ì wɑɑ dɛdɛm ŋɑi si nɑ iyi í jɔ̀ ì bɑ pɛ̃ɛ ì jɛ ì yo ŋɑ, kù jɛ nɑ iyi í jɔ̀ ì yɛ ǹ ce mɑɑmɑɑke ɡɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","I mɑɑ̀ ti i ce icɛi ijɛ iyi í yɑ sɑ̃mi nŋu ɑkɑ̃, ɑmmɑ i ce icɛi ijɛ iyi ɑ́ jɔ̀ i bɑ kuwɛɛ hɑi tɑ̃ ŋɑ. Nɔ ijɛ nŋu ɑmu Amɑi Amɑnɛi ɑn mu nŋɛ, domi ɑmui Ilɑɑɔ̃ Bɑɑbɑ í nɑ yiikoɛ nɔ í jɔ̀ inɛ ŋɑ ɑ̀ wɑɑ yɔɔ. ");
INSERT INTO mkl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, mii ɑɑ kɑ ce kɑ ceò icɛ iyi Ilɑɑɔ̃ í bi. ");
INSERT INTO mkl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ŋɔi Jesu í jɛ nŋɑ í ni, icɛ iyi Ilɑɑɔ̃ í bi si ŋɛi í jɛ i dɑsi ɑmu woo bɛɛ nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, mɑɑmɑɑke yoomɑi ɑɑ ce kɑ yɔɔ ku bɑ kɑ dɑsiɛ nɑɑnɛ. Mɑ̀ icɛ yoomɑi ɑɑ ce. ");
INSERT INTO mkl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nɔ ɑ̀ ni mɑ́, bɑlɑ nwɑ ŋɑ ɑ̀ jɛ ijɛ ɡɔ iyi ɑ̀ yɑ kpe mɑnɑ si ɡbɑɑ. À kɔɔ ɑ̀ ni í nɑ ŋɑ ijɛ wɑ hɑi lelei Aɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ŋɔi Jesu í jɛ nŋɑ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, kù jɛ Moizii í mu nŋɛ ijɛu wɑ hɑi lele, ɑmmɑ Bɑɑm nii í mu nŋɛ ijɛ iyi í jɛ ntɔu wɑ hɑi lele. ");
INSERT INTO mkl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nɔ ijɛ iyi Ilɑɑɔ̃ í yɑ muɑ inɛ, nŋui í jɛ inɛ iyi í kitɑ wɑ hɑi lele iyi ɑ́ jɔ̀ ɑmɑnɛ ku bɑ kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, mɔkɔɔyi, mu nwɑ dimii ijɛu bɛ do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, ɑmui ǹ jɛ ijɛi kuwɛɛ. Inɛ iyi í nɑɑ bi tom, ɑri kɑɑ kpɑ lɑfɛ̃ɛ mɑ́ pɑi, nɔ inɛ iyi í dɑsim nɑɑnɛ, ɑɡbɛ kɑɑ kpɑɑ mɑ́ pɑi. ");
INSERT INTO mkl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ǹ tɑko ǹ sɔ̃ ŋɛ wo ǹ ni, ì wɑɑ yɛm ŋɑ, ɑmmɑ i kù dɑsi nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Inɛ ŋɑ iyi Bɑɑbɑ í nɑm fei ɑɑ nɑɑ bi tom, nɔ inɛ iyi í nɑɑ bi tom bɑɑ bii bɛirei n kɑɑ n nyɔɔ ɑnɡule. ");
INSERT INTO mkl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ǹ kitɑ wɑi hɑi lelei Aɔ̃ n nɑ n ceò idɔɔbii inɛ iyi í bɛm wɑ, kù jɛ idɔɔbii ɑmu tɑkɑm. ");
INSERT INTO mkl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Idɔɔbii inɛ iyi í bɛm wɑ wee. Inɛ ŋɑ iyi í nɑm, n mɑɑ̀ n jɔ̀ bɑɑ inɛ ɑkɑ̃ nŋɑ ku ce nfe ɑmmɑ n jĩ ɑŋɑ fei hɑi si bɑlɛ si ɑjɔi ɑnkɑ̃ɑnyi. ");
INSERT INTO mkl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Idɔɔbii Bɑɑm nii í jɛ inɛ iyi í yɛ ɑmu Amɑ nɔ í dɑsim nɑɑnɛ fei ku nɛ kuwɛɛ hɑi tɑ̃, ɑn nɔ n jĩ lɑfɛ̃ɛ hɑi si bɑlɛ si ɑjɔi ɑnkɑ̃ɑnyi. ");
INSERT INTO mkl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ŋɔi Zuifu ŋɑu ɑ̀ wɑɑ ɡbɑɡbɑ siɛ nɑ iyi í jɔ̀ í ni nŋu í jɛ ijɛ iyi í kitɑ wɑ hɑi lelei Aɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ŋɔi ɑ̀ ni, í jɔ Jesu ɑmɑi Zozɛfuu mbɛ mɛɛ. À mɑ̀ iyeò bɑɑɛ. Bɛirei í ce í ni nŋu í nɑɑi hɑi lele. ");
INSERT INTO mkl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, i mɑɑ̀ ti i mɑɑ̀ ɡbɑɡbɑ nɑ irim bɛɛbɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Inɛ ɡɔ kɑɑ yɔkɔ ku nɑɑ bi tom bii kù jɛ Bɑɑbɑ iyi í bɛm wɑi í fɑ lɑfɛ̃ɛ wɑ. Nɔ inɛ nŋui ɑn jɔ̀ ku jĩ hɑi si bɑlɛ si ɑjɔi ɑnkɑ̃ɑnyiu. ");
INSERT INTO mkl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Inɛ ɑkɑ̃i wɑlii ŋɑu í kɔ í ni, Ilɑɑɔ̃ tɑkɑɛi ɑ́ nɑ ku kɔ inɛ fei si cio. Nɔ bɛɛbɛi inɛ iyi í ɡbɔ idei Bɑɑbɑ fei nɔ í jirimɑ cioɛ lɑfɛ̃ɛ ɑ́ nɑɑ bi tom. ");
INSERT INTO mkl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Inɛ kɑ̃mɑ kù yɛ Ilɑɑɔ̃ Bɑɑbɑ do iju, í ɡbe ɑmu iyi ǹ nɑɑ hɑi bi tɛɛu. ");
INSERT INTO mkl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ntɔ ntɔ, inɛ iyi í dɑsim nɑɑnɛ fei í nɛ kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Amui ǹ jɛ ijɛi kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bɑlɑ nŋɛ ŋɑ ɑ̀ jɛ mɑnɑ si ɡbɑɑ ɑmmɑ kù ɡɑnji ɑ ku. ");
INSERT INTO mkl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ammɑ ɑmu ijɛ ɡɔi ǹ wɑ n fɑ̃ɑ iyi í nɑɑ hɑi lele, iyi bii ɑmɑnɛ í jɛ kɑɑ ku. ");
INSERT INTO mkl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Amui ǹ jɛ ijɛi kuwɛɛ. Hɑi lelei ǹ kitɑ wɑ. Nɔ inɛ iyi í bɑ ijɛu í jɛ fei í nɛ kuwɛɛ hɑi tɑ̃. Ijɛui í jɛ ɑrɑm. An nɑ́ɑi ku bɑ inɛ ŋɑ ɑ mɑɑ wɛɛò. ");
INSERT INTO mkl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iyi Jesu í fɔ bɛɛbɛ ŋɔi Zuifu ŋɑ ɑ̀ ce si kɑkɔɔ jiidɑ ɑ̀ wɑɑ ni, bɛirei nŋu ɑ́ ce ku nɑ wɑ iŋɑi ɑrɑɛ kɑ ŋɔ. ");
INSERT INTO mkl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, bii i kù ŋɔ iŋɑi ɑrɑi ɑmu Amɑi Amɑnɛ wɑlɑkɔ i kù mɔ njɛm i kù nɛ kuwɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Inɛ iyi í ŋɔ iŋɑi ɑrɑm nɔ í mɔ njɛm í nɛ kuwɛɛ hɑi tɑ̃, nɔ ɑn jũu hɑi si bɑlɛ si ɑjɔi ɑnkɑ̃ɑnyiu, ");
INSERT INTO mkl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","domi iŋɑi ɑrɑm nii í jɛ ijɛ ɑlɑlɑ nɔ njɛm mɔi í jɛ inyi ɑlɑlɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Inɛ iyi í ŋɔ iŋɑi ɑrɑm nɔ í mɔ njɛm ɑwɑò ɑɑ kɑ nɛ ɑnu ɑkɑ̃ kɑ mɑɑ wɛɛò. ");
INSERT INTO mkl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bɑɑbɑi í bɛm wɑ. Nŋui í nɛ kuwɛɛ nɔ nɑ iriɛi ɑmu mɔ ǹ wɛɛ. Bɛɛbɛ mɔi inɛ iyi í ŋɔm, lɑfɛ̃ɛ í nɛ kuwɛɛ nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ijɛ iyi í kitɑ wɑ hɑi lelei ǹ wɑ n fɑ̃ɑ. Inɛ nŋu kù jɛ bɛi ijɛ iyi bɑlɑ nŋɛ ŋɑ ɑ̀ jɛ nɔ kù ɡɑnji ɑ̀ kuu. Inɛ iyi wɑ jɛ dimii ijɛu ihɛ̃ ɑ́ mɑɑ wɛɛi hee do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ideu bɛi Jesu í kɔ inɛ ŋɑ si ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ Kɑpɛrɑnumu. ");
INSERT INTO mkl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iyi mɔcɔi Jesu ŋɑu ɑ̀ ɡbɔ ideu ŋɔi nkpɔ nŋɑ í ni, ideu ihɛ̃ í lele. Yooi ɑ́ nɔɔ. ");
INSERT INTO mkl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nɔ Jesu í mɑ̀ iyi ɑ̀ wɑsi ku ɡbɑɡbɑ nɑ ideu, ŋɔi í bee ŋɑ í ni, ideui í jɛ nŋɛ bi ku koosɛɛ? ");
INSERT INTO mkl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Debɛi, bɛirei ɑɑ ni ŋɑ bii ì yɛ ɑmu Amɑi Amɑnɛ ǹ wɑ n bɔ lele ŋɑ bii ǹ tɑko ǹ wɑ wo. ");
INSERT INTO mkl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hundei í yɑ muɑ inɛ kuwɛɛ, ɡbuɡbɑ̃i ɑmɑnɛ kù jɛ nkɑ̃mɑ. Nɔ ide iyi ǹ sɔ̃ ŋɛu wee hundei, nɔ nŋui í jɛ kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ammɑ si inɔ nŋɛ inɛ ɡɔ ŋɑ ɑ kù dɑsi nɑɑnɛ. Jesu í fɔ bɛɛbɛi si nɑ iyi í jɔ̀ í mɑ̀ hɑi sinteɛ inɛ ŋɑ iyi ɑ kɑɑ dɑsi nŋu nɑɑnɛ do inɛ iyi ɑ́ nɑ ku zɑmbɑ nŋu. ");
INSERT INTO mkl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nɔ í ni mɑ́, nɑ iyi ihɛ̃i í jɔ̀ ǹ sɔ̃ ŋɛ wo ǹ ni inɛ ɡɔ kù wɛɛ iyi ɑ́ nɑɑ bi tom bii kù jɛ Ilɑɑɔ̃ Bɑɑbɑi í jɔ̀ lɑfɛ̃ɛ í nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ŋɔi hɑi wɑɑti bɛɛbɛ mɔcɔ nkpɔɛ ŋɑu ɑ̀ fɑ ɑrɑ nŋɑ do ɑnyi ɑ ci yɑ tooɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nɑ ŋɔi í jɔ̀ Jesu í bee mɔcɔ mɑɑteejiɛ ŋɑu í ni, iŋɛ mɔ ni, i kù wɑɑ nɛ ŋɑi? ");
INSERT INTO mkl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ŋɔi Simɔɔ Piɛɛ í jɛɑɑ í ni, Lɑfɛ̃ɛ, bi yooi ɑɑ kɑ bɔ mɑ́. Awɔi ì nɛ idei kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Awɑ ɑ̀ dɑsi nɑɑnɛ nɔ ɑ̀ mɑ̀ kɑm kɑm iyi ɑwɔi ì jɛ Inɛ Kumɑ́ iyi í nɑɑ hɑi bi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ŋɔi Jesu í bee ŋɑ í ni, kù jɛ ɑmui ǹ cicɑ iŋɛ mɑɑteejiu bɑ. Do nŋu fei inɛ ɑkɑ̃ nŋɛ í jɛ inɛi Seetɑm. ");
INSERT INTO mkl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wɑɑtɔ idei Zudɑsi ɑmɑi Simɔɔ Isikɑriotii wɑ fɑ̃ɑ, si nɑ iyi í jɔ̀ bɑɑ do iyi í wɑ si inɔi mɔcɔ mɑɑteeji ŋɑu fei, nŋui ɑ́ zɑmbɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Si ɑnyii nŋu, Jesu wɑ dɑbii si ilɛi Gɑlilee. Kù bi ku bɔ ikpɑ ilɛi Zudee domi Zuifu ŋɑu ɑ̀ wɑɑ dɛ ku kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nɔ wee jinɡɑui Zuifu ŋɑ iyi ɑ̀ yɑ kpe jinɡɑui Ilei ɑcɔ í mɑɑi wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ŋɔi ifɔi Jesu ŋɑ ɑ̀ sɔ̃ɔ ɑ̀ ni, nɛ hɑi ihɛ̃ i bɔ Zudee ku bɑ mɔcɔɛ ŋɑ iyi ɑ̀ wɑ ikpɑ bɛ ɑ yɛ icɛ iyi ì wɑɑ ce, ");
INSERT INTO mkl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","domi bii ɑmɑnɛ í bi ɑ mɑ̀ nŋu bɑntumɑ kɑɑ mɑ́ɑ ce nɡɔɡɔ si ɑsii. Bii ì wɑɑ ce dimii icɛ bɛɛbɛ, í ɡbe í nyisi inɛ ŋɑ ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","À wɑɑ fɔ bɛɛbɛi si nɑ iyi í jɔ̀ bɑɑ ɑŋɑ tɑkɑ nŋɑ ɑ kù dɑsiɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, wɑɑtim kù to wɑ titɑ̃, ɑmmɑ iŋɛ wɑɑtiu fei í sĩɑ nŋɛi. ");
INSERT INTO mkl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Inɛi ɑndunyɑ ŋɑ ɑ kɑɑ yɔkɔ ɑ cé ŋɛ, ɑmmɑ ɑ̀ cé ɑmu domi ǹ yɑ n ni kookoosu nŋɑ kù sĩɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Iŋɛ i bɔ jinɡɑuu, ɑmmɑ ɑmu n kù wɑ n koo titɑ̃, si nɑ iyi í jɔ̀ wɑɑtim kù to wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iyi í sɔ̃ ŋɑ ideu í tɑ̃ nɔ í ɡbe ilɛi Gɑlilee bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iyi ifɔi Jesu ŋɑ ɑ̀ bɔ jinɡɑuu ŋɔi nŋu mɔ í dede í koo do ɑsii, kù bi ɑ yɔɔ si bɑntumɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ŋɔi Zuifu ŋɑu ɑ̀ wɑsi ku dɛdɛɛ si wɑɑtii jinɡɑuu ɑ̀ wɑɑ ni, iwoi í wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ŋɔi si zɑmɑɑu inɛ ŋɑ ɑ̀ wɑsi ku fɔ ideɛ do ɡundu. Inɛ ɡɔ ŋɑ ɑ̀ wɑɑ ni, inɛ jiidɑi. Nɔ inɛ ɡɔ ŋɑ mɔ ɑ̀ wɑɑ ni, iboi, wɑ dĩ ijui inɛ ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ammɑ kɑ̃mɑ nŋɑ ci yɑ fɔ ideɛ do wɔɔkɔ domi ɑ̀ wɑɑ ce njoi inɛ nɡbo ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Iyi inɛ ŋɑ ɑ̀ jɛ jinɡɑuu ɑ̀ to ɑnini ŋɔi Jesu í koo í lɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ bɛ wɑ kɔ inɛ ŋɑ si cio. ");
INSERT INTO mkl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ŋɔi Zuifu ŋɑu ɑ̀ biti nɔ ɑ̀ wɑsi ku ni, bɛirei inɛ iyi kù bɔ cio í ce í mɑ̀ kukɔi idei Ilɑɑɔ̃ bɛ ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ŋɔi Jesu í jɛ nŋɑ í ni, ciom kù jɛ hɑi si idɔm nii wɑ fitɑ wɑ. Hɑi bi Ilɑɑɔ̃i wɑ nɑɑ, nŋu iyi í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Inɛ iyi í bi nŋu ku ce idɔɔbii Ilɑɑɔ̃, lɑfɛ̃ɛ ɑ́ mɑ̀ bii ciom hɑi bi Ilɑɑɔ̃i wɑ nɑɑ, wɑlɑkɔ bii í jɛ ti ɑmu tɑkɑm nii. ");
INSERT INTO mkl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Inɛ iyi wɑ fɔ ide do yiikoi irii ɑrɑɛ bɛɛrɛi nŋu tɑkɑɛi wɑ dɛ. Ammɑ inɛ iyi wɑ dɛ bɛɛrɛi inɛ iyi í bɔɔ wɑ, lɑfɛ̃ɛ ntɔi í yɑ fɔ, ibo kɑ̃mɑ ci yɑ wɑ siɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moizii í nɑ ŋɛ woodɑ, mɑ̀ irei. Ammɑ do nŋu fei, kɑ̃mɑ nŋɛ kù wɑɑ jirimɑ woodɑu. To, nɑ mii í ce ì wɑɑ dɛ ku kpɑm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ŋɔi zɑmɑɑu í jɛɑɑ í ni, ì nɛ inɛi inɔɔkoi bɑ. Yooi wɑ dɛ ku kpɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu í jɛ nŋɑ í ni, mɑɑmɑɑke ɑkɑ̃i ǹ ce si ɑjɔi kusĩmi nɔ iŋɛ fei í biti. ");
INSERT INTO mkl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ammɑ i lɑsɑbu ŋɑ. Moizii í nɑ ŋɛ woodɑi bɑnɡo ku dɑsi. Nŋui í jɔ̀ bɑɑ bii í jɛ ɑjɔi kusĩmii ì yɑ mɑɑ dɑsi ɑmɑ nŋɛ ŋɑ bɑnɡo ŋɑ. Nɔ mɔm idei bɑnɡo ku dɑsiu kù jɛ hɑi bi Moizii wɑ nɑɑ, hɑi bi bɑlɑ nŋɛ ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Debɛi, bii ì wɑɑ dɑsi ɑmɑ nŋɛ ŋɑ bɑnɡo si ɑjɔi kusĩmiu ku bɑ i mɑɑ̀ bɛjɛ woodɑi Moizi ŋɑ, nɑ mii í ce ì yɑ mɑɑ mum do idɔɔkɔ̃ ŋɑ wɑɑti iyi ǹ fɑɑbɑ inɛ ɡɔ mɑm mɑm si ɑjɔi kusĩmiu. ");
INSERT INTO mkl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","I mɑɑ̀ yɑ kiiti nɡɔɡɔ si bɛi ì wɑɑ yɔɔ do iju nŋu ɑkɑ̃ ŋɑ, ɑmmɑ i ce kiitiu dee dee ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ŋɔi inɛi Zeruzɑlɛmu ɡɔ ŋɑ, iyi ɑ̀ ɡbɔ Jesu í fɔ bɛɛbɛ ɑ̀ wɑɑ ni, kù jɛ inɛɛu ihɛ̃i ɑ̀ wɑɑ dɛ ku kpɑu yɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nɔ wee wɑ fɔ ide si bɑntumɑ nɔ inɛ ɡɔ kù ni ide ɡɔ mɛɛ. Mɑ̀ inɛ nɡbo nwɑ ŋɑ ɑ̀ mɑ̀ bɛbɛi iyi nŋui í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu do ntɔ de. ");
INSERT INTO mkl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ammɑ bii í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu wɑ nɑɑ inɛ ɡɔ kɑɑ mɑ̀ hɑi bii ɑ́ nɑɑò wɑ, nɔ wee ɑwɑ ɑ̀ mɑ̀ hɑi bii inɛɛu ihɛ̃ í nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Si bɛi Jesu wɑ kɔ ŋɑ si cio bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ bɛ í lɑ wɑ ni, ì wɑɑ tɑmɑɑ bɛi ì mɑ̀m ŋɑi, ì nɔ ì mɑ̀ hɑi bii ǹ wɑ n nɑɑ ŋɑ. Do nŋu fei, n kù nɑɑ do yiikoi ɑrɑm, ɑmmɑ ilu ntɔi iyi iŋɛ i kù mɑ̀, nŋui í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Amu ǹ mɑ̀ɑ, domi hɑi bi tɛɛi ǹ wɑ n nɑɑ, nŋu mɔi í nɔ í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ŋɔi ɑ̀ wɑɑ dɛ ku muu, ɑmmɑ inɛ ɡɔ kù lesiɛ ɑwɔ domi wɑɑtiɛ kù to wɑ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Si zɑmɑɑu inɛ nkpɔ í dɑsiɛ nɑɑnɛ ŋɔi ɑ̀ ni, bii inɛ ihɛ̃ kù jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu, inɛ mmu iyi ɑ́ nɑ ku nɑɑ ɑ́ yɔkɔ ku ce mɑɑmɑɑke ŋɑ ku re bɛi inɛɛu ihɛ̃ wɑ ce? ");
INSERT INTO mkl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fɑrisi ŋɑu ɑ̀ ɡbɔ bɛi inɛ ŋɑu ɑ̀ wɑɑ fɔ idei Jesu do ɡundu. Nɑ nŋu, inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do Fɑrisi ŋɑ ɑ̀ bɛ woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑ ɑ koo ɑ muu wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, wɑɑti keekei í ɡbe iyi ɑn wɛɛ do iŋɛ. Si ɑnyiɛ ɑn nyi bi inɛ iyi í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aɑ nɑ i mɑɑ dɛdɛɛm ŋɑ ɑmmɑ i kɑɑ yɛm ŋɑ, domi i kɑɑ yɔkɔ i bɔ bii ɑn wɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ŋɔi Zuifu ŋɑu ɑ̀ bee njɛ ide ɑ̀ wɑɑ ni, iwoi ɑ́ bɔ iyi ɑ kɑɑ kɑ yɔɔ. Mɑ̀ bi inɛ nwɑ ŋɑ iyi ɑ̀ fɑnɡɑɑ si ilɛi dimi mmu ŋɑui ɑ́ bɔ yɑ. Á koo kɔ dimi mmu ŋɑu si cioi? ");
INSERT INTO mkl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yoomɑi í jɛ yɑɑsei ide iyi í fɔu bɛ si bɛi í ni ɑɑ kɑ dɛ nŋu ɑmmɑ ɑ kɑɑ kɑ yɛ nŋu, domi bii nŋu ɑ́ wɑ ɑ kɑɑ kɑ yɔkɔ kɑ bɔ bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ajɔi ɑnkɑ̃ɑnyii jinɡɑui í yɑ nɛ bɛɛrɛ ku re. Ajɔ nŋuu, ŋɔi Jesu í dede í leekĩ wɑ fɔ ide hee lele wɑ ni, inɛ iyi ɑɡbɛ wɑ kpɑ ku nɑɑ ku mɔ inyi bi tom. ");
INSERT INTO mkl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Inɛ iyi í dɑsim nɑɑnɛ fei inyii kuwɛɛ ɑ́ cɑ̃ si idɔi lɑfɛ̃ɛ. Bɛɛbɛi kukɔi idei Ilɑɑɔ̃ í ni. ");
INSERT INTO mkl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Wee idei Hundei Ilɑɑɔ̃i Jesu wɑ fɑ̃ɑ. Inɛ iyi í dɑsi Jesu nɑɑnɛ fei ɑ́ bɑ Hundeu. Ammɑ wɑɑti iyi wɑ fɔ bɛɛbɛu Ilɑɑɔ̃ kù nɑ Hundeɛ titɑ̃ si nɑ iyi í jɔ̀ Jesu kù nyisi ɑmboeɛ wɑɑti bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Inɛ ɡɔ ŋɑ si inɔi zɑmɑɑu, iyi ɑ̀ ɡbɔ ideu ŋɔi ɑ̀ ni, inɛɛu ihɛ̃ wɑlii nlɑui ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Inɛ ɡɔ ŋɑ mɔ ɑ̀ ni, inɛ iyi Ilɑɑɔ̃ í cicɑui. Ammɑ inɛ ɡɔ ŋɑ ɑ̀ ni, bɛirei inɛ iyi Ilɑɑɔ̃ í cicɑu ɑ́ ce ku nɑɑ hɑi ilɛi Gɑlilee. ");
INSERT INTO mkl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kukɔi idei Ilɑɑɔ̃ kù ni inɛ iyi Ilɑɑɔ̃ í cicɑu ɑ́ fitɑ wɑi hɑi si dimii Dɑvidi? Hɑi Bɛtɛlehɛmu ilui Dɑvidi tɑkɑɛ si ɑ́ nɑɑ? ");
INSERT INTO mkl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nɔ inɛ ŋɑu ɑ̀ wɑɑ kpɛ̃ njɛ nɑ iriɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Inɛ ɡɔ ŋɑ ɑ̀ bi ɑ muu, ɑmmɑ inɛ kɑ̃mɑ kù lesiɛ ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ŋɔi woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu ɑ̀ nyi bi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do Fɑrisi ŋɑu. Ŋɔi ɑ̀ bee ŋɑ ɑ̀ ni, nɑ mii í ce i kù mu Jesuu wɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ŋɔi woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu ɑ̀ jɛ ɑ̀ ni, inɛ kɑ̃mɑ kù wɛɛ iyi í fɔ ide bɛi inɛɛu bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ŋɔi Fɑrisi ŋɑu ɑ̀ bee ŋɑ ɑ̀ wɑɑ ni, to, iŋɛ mɔ ì jɔ̀ inɛɛu í dĩ iju nŋɛ ŋɑ yɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ì ɡbɔ bii inɛ nɡbo ɡɔ wɑlɑkɔ Fɑrisi ŋɑu bɑɑ inɛ ɑkɑ̃ nŋɑ í dɑsiɛ nɑɑnɛ ŋɑi? ");
INSERT INTO mkl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ammɑ zɑmɑɑu kù mɑ̀ woodɑi Moizi. Ilɑɑɔ̃ kú ceekpe ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ammɑ si inɔi Fɑrisi ŋɑu inɛ ɡɔ í wɑ bɛ ɑ̀ yɑ kpoo Nikodɛmu. Nŋui í bɔ bi Jesu idũu wo. Iyi í ɡbɔ ɑ̀ wɑɑ fɔ bɛɛbɛ ŋɔi í bee ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","woodɑ nwɑ í yɔɔdɑ nwɑ kɑ yɛ tɑɑlei ɑmɑnɛ hɑi ɑ kù ɡbɔ ideɛ nɔ ɑ kù mɑ̀ mii iyi í ce? ");
INSERT INTO mkl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, ɑsee ɑwɔ tɑkɑɛ mɔ inɛi Gɑlileei? Cɔ si kukɔi idei Ilɑɑɔ̃ sɑ̃ɑ sɑ̃ɑ, i kɑɑ yɛ wɑlii ɡɔ iyi í fitɑ wɑ hɑi Gɑlilee.  ");
INSERT INTO mkl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nɔ inɛ fei í nɛ kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ŋɔi Jesu í bɔ ɡeete iyi ɑ̀ yɑ kpe Olivie. ");
INSERT INTO mkl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ammɑ iju kumɑ́ɛ dɑɑdɑɑkɔ í sindɑ í bɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ nɔ inɛ fei wɑ bɔ bi tɛɛ, nɔ í bubɑ í lɔsi cio ku kɔ ŋɑ si. ");
INSERT INTO mkl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ŋɔi woo kɔ inɛ ŋɑ si woodɑ ŋɑ do Fɑrisi ŋɑ ɑ̀ nɑɑò inɑɑbo ɡɔ wɑ bi tɛɛ iyi ɑ̀ muu si sɑkɑrɑ ku ce. Ŋɔi ɑ̀ leekĩɛ si ɑninii zɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nɔ ɑ̀ sɔ̃ Jesu ɑ̀ ni, Mɛɛtu, ɑ̀ mu ɑbou ihɛ̃i si sɑkɑrɑ ku ce. ");
INSERT INTO mkl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wee Moizi í fɔ si woodɑɛ í ni dimii inɑɑbo bɛ ihɛ̃ kɑ tɑɑ kutɑ kɑ kpɑɑ. To, ɑwɔ mɔ, bɛirei ì yɔɔ. ");
INSERT INTO mkl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","À fɔ bɛɛbɛi ku bɑ ɑ cɔ lɑɑkɑɛ nɔ ɑ yɛ tɑɑleɛ. Ammɑ Jesu í kɔmbɑ iri ilɛ wɑ kɔ si ilɛ do ɑmɑɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ŋɔi ɑ̀ beeɛ ɑ̀ mɑnteɛ nɔ í dede í tɛ í sɔ̃ ŋɑ í ni, inɛ iyi kù ce dulum si inɔ nŋɛ ku tɑko ku tɑ ɑbou kutɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nɔ í kɔmbɑ mɑ́ wɑ kɔ si ilɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iyi ɑ̀ ɡbɔ bɛɛbɛ ŋɔi ɑ̀ fitɑ ɑkɑ̃ ɑkɑ̃ hɑi inɛ nɡbo ŋɑu hee ku bɔ si inɛi ɑnkɑ̃ɑnyi ŋɑu. Í ɡbe Jesu nŋu ɑkɑ̃ do ɑbou si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ŋɔi Jesu í dede í tɛ mɑ́ nɔ í beeɛ í ni, ɑbooyi, iwoi ɑ̀ wɑ. Inɛ ɡɔ kù ɡbe ihɛ̃ iyi wɑ yɛ tɑɑleɛ mɑ́? ");
INSERT INTO mkl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ŋɔi ɑbou í ni, mɔkɔɔyi, bɑɑ ɑkɑ̃ nŋɑ kù wɑ ihɛ̃ mɑ́. Jesu í ni, ɑmu tɑkɑm mɔ n kɑɑ n yɛ tɑɑleɛ. Nɛɛ, ɑmmɑ mɑɑ̀ ce dulum mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Si ɑnyii nŋu, Jesu í bɑ inɛ ŋɑ ide ku fɔ mɑ́ í ni, ɑmui ǹ jɛ inyɑ kumɑ́i ɑndunyɑ. Inɛ iyi wɑ toom ɑ́ nɛ inyɑ kumɑ́ iyi ɑ́ jɔ̀ inɛ ku bɑ kuwɛɛ, kɑɑ mɑɑ nɛ si ilu kuku. ");
INSERT INTO mkl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ŋɔi Fɑrisi ŋɑu ɑ̀ sɔ̃ɔ ɑ̀ ni, nsɛi ì wɑɑ jɛɑ ɑrɑɛ sɛɛdɑ. Sɛɛdɑɛ kù jɛ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ŋɔi Jesu í jɛ nŋɑ í ni, bɑɑ bii ǹ wɑ n jɛɑ ɑrɑm sɛɛdɑ, ide ŋɑ iyi ǹ wɑ n fɔu fei ntɔi, domi ǹ mɑ̀ hɑi bii ǹ nɑɑ ǹ nɔ ǹ mɑ̀ bii ǹ wɑ n bɔ. Ammɑ iŋɛ i kù mɑ̀ hɑi bii ǹ nɑɑ hee mɑ́ jɛ bii ǹ wɑ n bɔ. ");
INSERT INTO mkl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Iŋɛ ì yɑ mɑɑ ce kiiti ŋɑi bɛi ɑmɑnɛ ŋɑ ɑ̀ yɑ ce, ɑmu n ci yɑ n kiiti inɛ kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ammɑ bɑɑ bii í jɛ ǹ wɑ n kiiti inɛ ŋɑ, kiitim í sĩɑ domi ɑmu ɑkɑ̃ si ɑn kiiti ŋɑ, Bɑɑbɑ iyi í bɛm wɑ í wɛɛ do ɑmu. ");
INSERT INTO mkl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","À kɔɔ si tiɑi woodɑ nŋɛ ɑ̀ ni sɛɛdɑi ɑmɑnɛ minjii í jɛ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ǹ wɑ n jɛɑ ɑrɑm sɛɛdɑ nɔ Bɑɑbɑ, iyi í bɛm wɑ, nŋu mɔ wɑ jɛɑ inɛ ŋɑ sɛɛdɑm. ");
INSERT INTO mkl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, iwoi Bɑɑɛu í wɑ. Ŋɔi Jesu í jɛ nŋɑ í ni, i kù mɑ̀ ɑmu tɑkɑm ŋɑ mɔm hee mɑ́ jɛ Bɑɑm. Bii í jɛ ì mɑ̀m ŋɑ wo ɑɑ mɑ̀ Bɑɑm nɔu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ideu bɛi Jesu í fɔ wɑɑti iyi wɑ kɔ inɛ ŋɑ si cio bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ bii ɑ̀ yɑ jilɛ fiɑi kɔlɛtiu. Nɔ inɛ ɡɔ kù lesiɛ ɑwɔ si nɑ iyi í jɔ̀ wɑɑtiɛ kù to wɑ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, ɑn nɛ nɔ ɑɑ nɑ i dɛdɛɛm ŋɑ, ɑmmɑ ɑɑ ku ŋɑi si dulum du ŋɛ. I kɑɑ yɔkɔ i bɔ bii ǹ wɑ n bɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Si bɛi í ni bii nŋu wɑ bɔ ɑ kɑɑ yɔkɔ ɑ bɔ bɛ nŋui í jɔ̀ Zuifu ŋɑu ɑ̀ bee njɛ ɑ̀ wɑɑ ni, debɛi ɑ́ kpɑ ɑrɑɛi? ");
INSERT INTO mkl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nɔ Jesu í ni, hɑi ilɛ ihɛ̃i iŋɛ ì nɑɑ ŋɑ, ɑmmɑ ɑmu hɑi lelei ǹ nɑɑ. Iŋɛ inɛi ɑndunyɑ ŋɑi, ɑmmɑ ɑmu n kù jɛ inɛi ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nɑ ŋɔi í ce ǹ ni ɑɑ ku si dulum du ŋɛ ŋɑ. Ntɔ ntɔ, bii i kù dɑsi nɑɑnɛ ŋɑ iyi ɑmui ǹ jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu ɑɑ ku si dulum du ŋɛ ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, ɑwɔi yoo. Ŋɔi Jesu í jɛ nŋɑ í ni, ǹ sɔ̃ ŋɛ tɑ̃ hɑi sinteɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ide iyi ǹ nɛ ku fɔ nɑ iri nŋɛ n yɛò tɑɑle nŋɛ í kpɔ. Ammɑ inɛ iyi í bɛm wɑ ilu ntɔi, nɔ ide iyi ǹ ɡbɔ hɑi bi tɛɛ, nŋui ǹ wɑ n sisiɑ inɛ ŋɑ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ammɑ wɑɑti iyi Jesu wɑ fɔ bɛɛbɛ ɑ kù mɑ̀ hee mɑ̀ idei Ilɑɑɔ̃ Bɑɑbɑi wɑ sɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ŋɔi Jesu í ni, ɑjɔ iyi ɑɑ so Amɑi Amɑnɛ i kɔɑɛ lele ŋɑ, ɑjɔ nŋui ɑɑ mɑ̀ ŋɑ iyi ɑmui ǹ jɛ inɛ iyi Ilɑɑɔ̃ í cicɑ. Nɔ ɑjɔ nŋui ɑɑ mɑ̀ ŋɑ mɑ́ iyi n kù wɑ n ce nɡɔɡɔ do ɑrɑm. Ide iyi Bɑɑbɑ í sɔ̃m nŋu ɑkɑ̃i ǹ wɑ n sɔ̃ iŋɛ mɔ. ");
INSERT INTO mkl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nŋu iyi í bɛm wɑ í wɛɛ do ɑmu. Kù jɔ̀m ɑmu ɑkɑ̃ domi wɑɑti kɑ̃mɑ fei iyi ɑ́ dɔ̃ɑ sii ǹ yɑ n ce. ");
INSERT INTO mkl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iyi Jesu í fɔ bɛɛbɛ inɛ nkpɔi í dɑsiɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ŋɔi Jesu í sɔ̃ Zuifu ŋɑ iyi ɑ̀ dɑsiɛ nɑɑnɛ í ni, bii ì wɑɑ jirimɑ idem ŋɑ ì jɛ mɔcɔm ŋɑi ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aɑ mɑ̀ ntɔ ŋɑ nɔ ntɔu ɑ́ jɔ̀ i nɛ ɑrɑ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, ɑwɑu tɔkui Aburɑhɑmu ŋɑi ɑ kù nɔ ɑ kù jɛ ɑrui inɛ ɡɔ ɑjɔ kɑ̃mɑ. Bɛirei í ce ì wɑɑ sɔ̃ wɑ ì ni ɑɑ kɑ nɛ ɑrɑ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ŋɔi Jesu í jɛ nŋɑ í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, inɛ iyi í yɑ ce dulum fei ɑrui dulum nii í jɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aru ci yɑ nɔ ku wɑ kpɑsɛ̃i lɑfɛ̃ɛ do ɑjɔ fei, ɑmɑ ɑ̀ bíɛi í yɑ wɑ bɛ do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nɑ ŋɔi í ce, bii ɑmu Amɑi Ilɑɑɔ̃ ǹ jɔ̀ ì nɛ ɑrɑɛ, ɑɑ nɛ ɑrɑɛi ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ǹ mɑ̀ iyi iŋɛu tɔkui Aburɑhɑmu ŋɑi. Ammɑ ì wɑɑ dɛ ku kpɑm ŋɑ si nɑ iyi í jɔ̀ i ci yɑ jɔ̀ idem ku bubɑ si idɔ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mii iyi ǹ yɛ bi Bɑɑm nŋui ǹ wɑ n sɔ̃ ŋɛ, bɛɛbɛi iŋɛ mɔ ì wɑɑ ce mii iyi bɑɑ nŋɛ í sɔ̃ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, Aburɑhɑmui í jɛ bɑɑ nwɑ. Ŋɔi Jesu í jɛ nŋɑ í ni, bii í jɛ iŋɛu ɑmɑi Aburɑhɑmu ŋɑi ntɔ ntɔ, mii iyi Aburɑhɑmu í ce nŋui ɑɑ yɑ ce ŋɑ wo. ");
INSERT INTO mkl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ammɑ wee nsɛi í yɑ mɑɑ dɛ ku kpɑm ŋɑi, ɑmu iyi ǹ wɑ n sɔ̃ ŋɛ ide ntɔ iyi ǹ ɡbɔ hɑi bi Ilɑɑɔ̃. Aburɑhɑmu kù nɔ kù ce dimiɛ ɑjɔ kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Do nŋu fei, ǹ wɑ n sɔ̃ ŋɛi, kookoosu ŋɑ iyi bɑɑ nŋɛ í yɑ ce nŋui iŋɛ mɔ ì wɑɑ ce. Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, ɑwɑ ɑ kù jɛ seeɡe ŋɑ. Ilɑɑɔ̃ nŋu ɑkɑ̃i í jɛ bɑɑ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, bii í jɛ Ilɑɑɔ̃i í jɛ bɑɑ nŋɛ ɑɑ bim ŋɑ, domi hɑi bi Ilɑɑɔ̃i ǹ fitɑ wɑ ǹ nɑɑ ihɛ̃. N kù nɑɑ do ɑrɑm, nŋui í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nɑ mii í ce i ci yɑ ɡbɔ yɑɑsei idem ŋɑ. I ci yɑ ɡbɔ yɑɑseɛ ŋɑi si nɑ iyi í jɔ̀ i kɑɑ yɔkɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Seetɑm nii í jɛ bɑɑ nŋɛ, nɔ ì wɑɑ bi i ce idɔɔbii bɑɑ nŋɛu. Hɑi sinte woo kpɑ inɛi. Kù wɑɑ leekĩ si kpɑ̃ɑi ntɔ domi ntɔ kù wɑ siɛ. Bii wɑ sɔ ibo, í yɑ mɑɑ fɔi bɛi nŋu tɑkɑɛ í yɛ domi ilu iboi, nɔ bɑɑi ilu ibo feii. ");
INSERT INTO mkl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ammɑ si nɑ iyi í jɔ̀ ɑmu ǹ yɑ n sɔ̃ ŋɛ ntɔ, nŋui í jɔ̀ i kù wɑɑ dɑsim nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yoo nŋɛi ɑ́ yɔkɔ ku ni nŋu í yɛ ǹ ce dulum. Kù wɛɛ. Debɛi, nɑ mii í ce i ci yɑ dɑsim nɑɑnɛ ŋɑ bii ǹ wɑ n sɔ̃ ŋɛ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Inɛ iyi í jɛ ti Ilɑɑɔ̃ nŋui í yɑ ɡbɔ idei Ilɑɑɔ̃. Si bɛi iŋɛ i kù jɛ tɛɛ ŋɑ nŋui í jɔ̀ i ci yɑ ɡbɔ ideɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ŋɔi Zuifu ŋɑu ɑ̀ sɔ̃ Jesu ɑ̀ ni, debɛi ɑwɑ ɑ̀ nɛ ntɔ si bɛi ɑ̀ ni ɑwɔu inɛi Sɑmɑrii, nɔ ì nɛ inɛi inɔɔko. ");
INSERT INTO mkl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ŋɔi Jesu í jɛ nŋɑ í ni, n kù nɛ inɛi inɔɔko. Bɑɑm nii ǹ wɑ n sɑɑlu, ɑmmɑ iŋɛ i kù wɑɑ sɑɑlum ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","N kù wɑ n dɛ bɛɛrɛi ɑrɑm. Inɛ ɡɔi wɑ dɛdɛ bɛɛrɛm, nŋui í nɔ í jɛ woo kiiti. ");
INSERT INTO mkl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, inɛ iyi wɑ jirimɑ idem lɑfɛ̃ɛ kɑɑ ku pɑi. ");
INSERT INTO mkl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ŋɔi Zuifu ŋɑu ɑ̀ sɔ̃ɔ ɑ̀ ni, bɛbɛi ɑ̀ mɑ̀ iyi ntɔ ntɔ ì nɛ inɛi inɔɔkoi, domi Aburɑhɑmu í ku nɔ wɑlii ŋɑu mɔ ɑ̀ ku, nɔ ɑwɔ ì ni inɛ iyi wɑ jirimɑ ideɛ kɑɑ ku pɑi. ");
INSERT INTO mkl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bɑlɑ nwɑ Aburɑhɑmu í ku. Mɑ̀ ì tɑmɑɑ ɑwɔ ì lɑ ì rooi? Nɔ wɑlii ŋɑu mɔ ɑ̀ ku. To, yooi ɑwɔ ì wɑɑ tɑmɑɑ ì jɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ŋɔi Jesu í jɛ nŋɑ í ni, bii ɑmui ǹ wɑ n dɛ bɛɛrɛi ɑrɑm, bɛɛrɛ nɡbɛi. Inɛ iyi wɑ dɛ bɛɛrɛm nŋui í jɛ Bɑɑm, inɛ iyi iŋɛ ì ni í jɛ Aɔ̃ Lɑfɛ̃ɛ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Do nŋu fei, i kù mɑ̀ɑ ŋɑ, ɑmmɑ ɑmu ǹ mɑ̀ɑ. Bii ǹ ni n kù mɑ̀ɑ, ǹ jɛ ilu iboi bɛi iŋɛ mɔ. Ammɑ ɑmu ǹ mɑ̀ɑ nɔ ǹ wɑ n jirimɑ ideɛ. ");
INSERT INTO mkl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aburɑhɑmu, bɑlɑ nŋɛu, í wɛɛò inɔ didɔ̃ nlɑ nlɑ si bɛi ɑ́ nɑ ku yɛ kunɑɑm. Í nɔ í yɔɔ. Iyi í yɔɔ nɔ inɔɛ í dɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ŋɔi Zuifu ŋɑu ɑ̀ sɔ̃ɔ ɑ̀ ni, i kù to ɑdɔ̃ ciitɑɑ titɑ̃, nɔ bɛirei ì ce ì yɛ Aburɑhɑmu. ");
INSERT INTO mkl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ŋɔi Jesu í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛ, ǹ wɛɛ mɔm wo hɑi wɑɑti iyi ɑ kù bí Aburɑhɑmu. ");
INSERT INTO mkl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ŋɔi ɑ̀ tɑsi kutɑ ɑ̀ wɑɑ bi ɑ tɑɑ, ɑmmɑ Jesu í mɑnji í fitɑ hɑi kpɑsɛ̃i Ilɑɑɔ̃u í nɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iyi Jesu wɑ nɛ ŋɔi í yɛ inɛ ɡɔ iyi ɑ̀ bí fɛɛju. ");
INSERT INTO mkl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nɔ mɔcɔɛ ŋɑ ɑ̀ beeɛ ɑ̀ ni, Mɛɛtu, nɑ mii í ce ɑ̀ bí inɛɛu ihɛ̃ fɛɛju. Nɑ irii dulum dɛɛi de, mɑ̀ nɑ irii dulum dii iyeò bɑɑɛ ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ŋɔi Jesu í jɛ nŋɑ í ni, kù jɛ nɑ iyi í jɔ̀ í ce dulum, kù nɔ kù jɛ nɑ iyi í jɔ̀ iyeò bɑɑɛ ŋɑ ɑ̀ ce dulum. Í fɛɛjuɛ dei ku bɑ ɑ yɛ yɑɑse bɛi Ilɑɑɔ̃ wɑ ce icɛ siɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dɑsɑ̃ kù nɛ bɛi ɑɑ kɑ ce iyi ɑ kù ce icɛi inɛ iyi í bɛm wɑ. Idũ í mɑɑi wɑ si bii inɛ ɡɔ kɑɑ yɔkɔ ku ce icɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wɑɑti iyi ǹ wɑ si ɑndunyɑ fei ɑmui ǹ jɛ inyɑ kumɑ́i ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi í tu ɑntɔ í tɑkiɛ do sɑ̃ɑ í dɑɑ fɛɛjuu si ijuɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ŋɔi í sɔ̃ɔ í ni, koo wɛɛju si inyii fɑtɑmɑi Siloe. (Yɑɑsei iriu bɛi í jɛ ku bɛ̀.) Ŋɔi fɛɛjuu í koo í wɛɛju nɔ í bɑɑ wɑ yɛ ilu bɛbɛi. ");
INSERT INTO mkl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kpɑɑsiɛ ŋɑ do inɛ ŋɑ iyi ɑ̀ yɔɔ í yɑ mɑɑ bɑrɑ wo ɑ̀ ni, kù jɛ mɔkɔ iyi í yɑ bubɑ ku mɑɑ bɑrɑu mbɛ yɑ. ");
INSERT INTO mkl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Inɛ ɡɔ ŋɑ ɑ̀ ni, nŋui. Inɛ ɡɔ ŋɑ mɔ ɑ̀ ni, kù jɛ nŋu, ɑ̀ jɔ njɛi. Ŋɔi inɛɛu tɑkɑɛ í ni, ɑmu mbɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ŋɔi inɛ ŋɑu ɑ̀ beeɛ ɑ̀ ni, bɛirei í ce ijuɛ í cĩ. ");
INSERT INTO mkl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ŋɔi í sɔ̃ ŋɑ í ni, inɛ iyi ɑ̀ yɑ kpe Jesuu bɛi í tu ɑntɔ si sɑ̃ɑ í sisɑɑm si iju nɔ í sɔ̃m í ni n bɔ fɑtɑmɑi Siloe n koo n wɛɛju. Ŋɔi iyi ǹ koo ǹ wɛɛju ɡbɑkɑ̃ ǹ yɛ ilu. ");
INSERT INTO mkl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nɔ ɑ̀ beeɛ ɑ̀ ni, iwoi inɛɛu í wɑ. Nɔ í ni, n kù mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Wee í ko ɑjɔi kusĩmii Jesu í tɑki sɑ̃ɑ do ɑntɔ í jɔ̀ inɛɛu í yɛò iluu. Ŋɔi ɑ̀ ɡbɑ̃ inɛɛu ɑ̀ bɔòɛ bi Fɑrisi ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ŋɔi Fɑrisi ŋɑu mɔ ɑ̀ beeɛ bɛi í ce í yɛò ilu. Nɔ í jɛ nŋɑ í ni, Jesui í dɑɑm sɑ̃ɑ si iju í ni n koo n wɛɛju. Iyi ǹ wɛɛju nɔ ǹ yɛ ilu. ");
INSERT INTO mkl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ŋɔi Fɑrisi ŋɑu ɡɔɡɔ ŋɑ ɑ̀ ni, inɛ iyi í ce icɛu bɛ kù nɑɑ hɑi bi Ilɑɑɔ̃, domi kù wɑɑ jirimɑ ɑjɔi kusĩmi. Ammɑ inɛ ɡɔ ŋɑ mɔ ɑ̀ ni, bɛirei ilu dulum ɑ́ ce ku yɔkɔ ku ce dimii mɑɑmɑɑkeu ihɛ̃. Nɔ kɑkɔɔ í lɔsi ɑnini nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ŋɔi ɑ̀ bee fɛɛjuu mɑ́ ɑ̀ ni, si kuyɛi ɑwɔ tɑkɑɛ ni, bɛirei ì yɔɔ, ɑwɔ iyi í jɔ̀ ì yɛ ilu. Nɔ í ni, wɑliii. ");
INSERT INTO mkl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ammɑ inɛ nɡbo ŋɑu ɑ kù dɑsi nɑɑnɛ iyi inɛɛu í jɛ fɛɛju wo í bɛi wɑ yɛò ilu nsɛi. Ŋɔi ɑ̀ koo ɑ̀ bee iyeò bɑɑɛ ŋɑ ");
INSERT INTO mkl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ɑ̀ ni, ɑmɑ nŋɛui ihɛ̃? Nɔ ntɔ ntɔ do fɛɛjui ì buu bɛ ŋɑ? Nɔ bɛirei í ce wɑ yɛ ilu nsɛi. ");
INSERT INTO mkl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ŋɔi bɑɑɛ ŋɑu ɑ̀ ni, ɑ̀ mɑ̀ iyi ɑmɑ nwɑi nɔ do fɛɛju mɔi ɑ̀ búu. ");
INSERT INTO mkl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ammɑ ɑ kù mɑ̀ bɛi í ce wɑ yɛ ilu si nsɛi, ɑ kù nɔ ɑ kù mɑ̀ inɛ iyi í cĩɑɑ ijuɛ. Nŋu tɑkɑɛ í lɑ, i beeɛ, ɑ́ sɔ̃ ŋɛ do ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","À fɔ bɛɛbɛi si nɑ iyi í jɔ̀ ɑ̀ wɑɑ ce njoi inɛ nɡboi Zuifu ŋɑu. À wɑɑ ce njo nŋɑi si nɑ iyi í jɔ̀ ɑ̀ ce ɑnu ɑkɑ̃ tɑ̃ ɑ̀ ni inɛ iyi í jɛsi iyi Jesu í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑ ɑ kɑɑ jɛ lɑfɛ̃ɛ ku nɑɑ ile bii ɑ̀ yɑ ce kutɔtɔɔ nŋɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ŋɔi í ce ɑ̀ ni nŋu tɑkɑɛ í lɑ, ɑ beeɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ŋɔi Fɑrisi ŋɑu ɑ̀ kpe inɛɛu mɑ́ ɑ̀ sɔ̃ɔ ɑ̀ ni, fɔ ntɔ nɑ Ilɑɑɔ̃. Awɑ ɑ̀ mɑ̀ iyi inɛɛu ilu dulum nii. ");
INSERT INTO mkl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ŋɔi í jɛ nŋɑ í ni, ɑmu de n kù mɑ̀ dulum ku jɛi njɛ. Ǹ jɛ fɛɛju wo ɑmmɑ nsɛi ǹ wɑ n yɛ ilu. Andi iyi ǹ mɑ̀ mbɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ŋɔi ɑ̀ beeɛ ɑ̀ ni, bɛirei do bɛirei í ceeɛ. Bɛirei í ce í cĩ ijuɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nɔ í ni, ǹ sɔ̃ ŋɛ tɑ̃, i kù ɡbɔ bɛi ǹ fɔ ŋɑi. Bɛirei í ce ì wɑɑ bi i ɡbɔɔ mɑ́ ŋɑ. Mɑ̀ iŋɛ mɔ ì wɑɑ bi i jɛ mɔcɔɛ ŋɑi de. ");
INSERT INTO mkl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ŋɔi ɑ̀ buu ɑ̀ ni, ɑwɔi ì jɛ mɔcɔɛ bɛ mɛɛ. Awɑu mɔcɔi Moizi ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Awɑ ɑ̀ mɑ̀ iyi Ilɑɑɔ̃ í bɑ Moizi ide ku fɔ wo, ɑmmɑ inɛɛu bɛ ɑwɑ ɑ kù mɑ̀ hɑi bii í nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ŋɔi inɛɛu í ni, to, ide nŋɛu bɛi í bitim iyi i kù mɑ̀ hɑi bii í nɑɑ ŋɑ. Do nŋu fei, njɛi í jɔ̀ ǹ yɛ ilu. ");
INSERT INTO mkl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Awɑ de ɑ̀ mɑ̀ iyi Ilɑɑɔ̃ ci yɑ ɡbɔ idei ilu dulum ŋɑ, í ɡbe inɛ ŋɑ iyi ɑ̀ wɑɑ jirimɑɛ nɔ ɑ̀ wɑɑ ce idɔɔbiɛ, idei lɑfɛ̃ɛ ŋɑi í yɑ ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ajɔ kɑ̃mɑ inɛ ɡɔ kù ɡbɔ bii ɑ̀ cĩ ijui inɛ iyi ɑ̀ bí do fɛɛju. ");
INSERT INTO mkl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Bii kù jɛ hɑi bi Ilɑɑɔ̃i inɛɛu bɛ í nɑɑ kɑɑ yɔkɔ ku ce nkɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, si dulum nii ɑ̀ bíɛ mɑm mɑm. Ì tɑmɑɑ ɑwɔi ɑɑ kɔ nwɑ si cio? Ŋɔi ɑ̀ ɡɑnjiɛ ku nɑɑ ile bii ɑ̀ yɑ ce kutɔtɔɔ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iyi Jesu í ɡbɔ ɑ̀ lele inɛɛu ŋɔi í koo í yɔɔ í beeɛ í ni, i dɑsi Amɑi Amɑnɛ nɑɑnɛ? ");
INSERT INTO mkl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ŋɔi inɛɛu í ni, mɔkɔɔyi, yooi í jɛ Amɑi Amɑnɛ ku bɑ n dɑsiɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ŋɔi Jesu í ni, ɑmu iyi ì wɑɑ yɛu ihɛ̃ mbɛ, ɑmui ǹ wɑ n bɑɛ ide ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nɔ í ni, ǹ dɑsiɛ nɑɑnɛ Lɑfɛ̃ɛ. Ŋɔi í ɡulɛ si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ŋɔi Jesu í ni, nɑ irii kiitii ǹ nɑɑ si ɑndunyɑ ku bɑ fɛɛju ŋɑ ɑ yɛ ilu, nɔ inɛ ŋɑ mɔ iyi ɑ̀ wɑɑ yɛ ilu ɑ fɛɛju. ");
INSERT INTO mkl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ŋɔi Fɑrisi ɡɔ ŋɑ iyi ɑ̀ wɑ bɛu ɑ̀ ɡbɔ ideu ŋɔi ɑ̀ beeɛ ɑ̀ ni, ɑwɑ mɔ fɛɛju ŋɑi? ");
INSERT INTO mkl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, bii ì jɛ fɛɛju ŋɑ, i kù nɛ tɑɑle ŋɑ. Ammɑ si bɛi ì yɑ wɛɛ si iŋɛ ì wɑɑ yɛ ilu ŋɑ, nŋui í jɔ̀ ì wɑ si dulum hee nsɛi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesu í ni, ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, inɛ iyi í lɔ ɑroi ɑnɡudɑ̃ ŋɑ nɔ kù lɔ hɑi ɑndɛɛ, bii í koo í ɡũ idĩ í bɛi í lɔò, lɑfɛ̃ɛ ile bɑtɑ nɡbɑi. ");
INSERT INTO mkl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ammɑ inɛ iyi wɑ lɔ hɑi do ɑndɛi ɑroi ɑnɡudɑ̃ ŋɑu, lɑfɛ̃ɛi í jɛ woo deɡbe ɑnɡudɑ̃ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Woo deɡbe ɑrou í yɑ cĩɑɑi, nɔ ɑnɡudɑ̃ ŋɑu ɑ̀ yɑ ɡbɔ imuɛ. Nɔ ku kpe ɑnɡudɑ̃ɛ ŋɑ do iri nŋɑ ɑkɑ̃ ɑkɑ̃ ku fitɑò ŋɑ wɑduude. ");
INSERT INTO mkl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wɑɑti iyi í fitɑò ɑŋɑ fei wɑduude nɔ ku cuɑ nŋɑ ɑ mɑɑ tooɛ domi ɑ̀ mɑ̀ imuɛ. ");
INSERT INTO mkl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A kɑɑ jɛ ɑ too inɛ njoo ɡɔ, ɑmmɑ ɑɑ sɑ ku jĩ hɑi bi tɛɛ domi ɑ kù mɑ̀ imuɛ. ");
INSERT INTO mkl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu í kpɑ nŋɑ mɔndɑu bɛ ɑmmɑ ɑ kù ɡbɔ yɑɑseɛ. ");
INSERT INTO mkl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, ǹ wɑ n sɔ̃ ŋɛi, ɑmui ǹ jɛ ɑndɛi ɑroi ɑnɡudɑ̃ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bɑɑi ɑmu bɑɑsi inɛ ŋɑ iyi ɑ̀ cuɑm wɑ fei ile bɑtɑ nɡbɑ ŋɑi, ɑmmɑ ɑnɡudɑ̃ ŋɑu ɑ kù ɡbɔ ide nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Amui ǹ jɛ ɑndɛ. Inɛ iyi í lɔ wɑ do bi tom fei ɑ́ bɑ fɑɑbɑ. Á lɔ, ɑ́ nɔ ku fitɑ, nɔ ɑ́ bɑ bi ku jɛ. ");
INSERT INTO mkl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ile njɛ ci yɑ nɑɑ kɑɑ ku ce ile nɔ ku kpɑ nɔ ku bɛjɛ. Ammɑ ɑmu ǹ nɑɑi ku bɑ inɛ ŋɑ ɑ bɑ kuwɛɛ nɔ ɑ nɔɔ jiidɑ jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Amui ǹ jɛ woo deɡbe jiidɑ. Woo deɡbe jiidɑ í yɑ jɛsi nŋu ku kui nɑ irii ɑnɡudɑ̃ɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ammɑ woo ce ɡɑɑnɔɔmɑ kù jɛ woo deɡbe. Si bɛi ɑnɡudɑ̃ ŋɑu ɑ kù jɛ titɛɛ, bii i hɔ̃nnɛ muusu nlɑ wɑ nɑɑ ɑ́ jɔ̀ ɑnɡudɑ̃ ŋɑui ku sɑ, nɔ muusu nlɑu ku mu ɑnɡudɑ̃ ŋɑu nɔ iyi ɑ̀ ɡbe ŋɑu ɑ fɑnɡɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Á sɑi domi nɑ fiɑi wɑ ce icɛ, kɑɑ nɛ ɑrɑɑrei ɑnɡudɑ̃ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Amui ǹ jɛ woo deɡbe jiidɑ. Si bɛi Bɑɑm í mɑ̀m nɔ ɑmu mɔ ǹ mɑ̀ɑ, bɛɛbɛ mɔi ǹ mɑ̀ ɑnɡudɑ̃m ŋɑ nɔ ɑŋɑ mɔ ɑ̀ mɑ̀m, nɔ ǹ jɛsi n ku nɑ iri nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nɔ ǹ nɛ ɑnɡudɑ̃ ɡɔ ŋɑ mɑ́ iyi ɑ kù wɑ si ɑrou ihɛ̃. Kù nɛ bɛi ɑn ce iyi n kù nɑɑò ŋɑ wɑ. Aɑ nɔ ɑ ɡbɔ imum nɔ ɑŋɑò ti tɑko ŋɑu fei ɑ jɛ ɡɑɑ ɑkɑ̃, woo deɡbe mɔ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bɑɑbɑ í bim si nɑ iyi í jɔ̀ ǹ jɛsi n ku. An ku nɔ ɑn jĩ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Inɛ kɑ̃mɑ kɑɑ yɔkɔ ku nyɑ hundem. Ammɑ ɑmu tɑkɑm nii ɑn nyɑɑ. Ǹ nɛ yiiko iyi ɑn nɑ hundem, nɔ ǹ nɛ yiiko iyi ɑn ɡbɑɑò mɑ́. Bɛɛbɛi Bɑɑm í dɑsim ku ce. ");
INSERT INTO mkl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iyi í fɔ bɛɛbɛ, ŋɔi Zuifu ŋɑu ɑ̀ nyi ɑ̀ kpɛ̃ mɑ́ nɑ irii ideu. ");
INSERT INTO mkl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Inɛ ɡɔ ŋɑ ɑ̀ ni, í nɛ inɛi inɔɔkoi. Sũmui. Nɑ mii í ce ì wɑɑ ɡbɔ ideɛ ŋɑ mɔm. ");
INSERT INTO mkl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nɔ inɛ ɡɔ ŋɑ mɔ ɑ̀ ni, inɛ iyi í nɛ inɛi inɔɔko ci yɑ fɔ ide bɛ ihɛ̃. Inɛ iyi í nɛ inɛi inɔɔko ɑ́ yɔkɔ ku cĩ ijui fɛɛju ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wɑɑti í to iyi ɑɑ ce jinɡɑu ɡɔ Zeruzɑlɛmu iyi ɑ̀ yɑ ni Kpɑsɛ̃i Ilɑɑɔ̃ ku teese. Wɑɑti bɛɛbɛ sukui tũtũi. ");
INSERT INTO mkl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nɔ Jesu í wɑ bɑntumɑi kpɑsɛ̃u wɑ nɛ ikpɑ ɑkɑ̃i ileu iyi ɑɑ yɑ kpe bɑntumɑi Sɑlomɔɔ. ");
INSERT INTO mkl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ŋɔi Zuifu ŋɑu ɑ̀ kɑɑkoɛ ɑ̀ beeɛ ɑ̀ ni, hee wɑɑti yoomɑi ɑɑ jɔ̀ sikɑ iyi ɑ̀ wɛɛò ku kpɑ iri. Bii ɑwɔi ì jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu ntɔ ntɔ, sɔ̃ wɑ sɑ̃ɑ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ŋɔi Jesu í jɛ nŋɑ í ni, ǹ sɔ̃ ŋɛ tɑ̃, ɑmmɑ i kù dɑsim nɑɑnɛ ŋɑ. Icɛ iyi ǹ wɑ n ce nŋui wɑ jɛɑ inɛ ŋɑ sɛɛdɑm. Ǹ wɑ n cooi do irii Bɑɑm. ");
INSERT INTO mkl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ammɑ i ci yɑ dɑsim nɑɑnɛ ŋɑ domi i kù wɑ si inɔi ɑnɡudɑ̃m ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Anɡudɑ̃m ŋɑ ɑ̀ yɑ ɡbɔ ide ku fɔm. Ǹ mɑ̀ ŋɑ nɔ ɑ̀ yɑ mɑɑ toom. ");
INSERT INTO mkl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nɔ ǹ mu nŋɑ kuwɛɛ hɑi tɑ̃, ɑ kɑɑ ku ɑjɔ kɑ̃mɑ, nɔ inɛ ɡɔ mɔ kɑɑ yɔkɔ ku lɑkɑti ŋɑ hɑi si ɑwɔm pɑi. ");
INSERT INTO mkl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bɑɑm nii í muum nɔ í lɑ í re inɛ fei. Inɛ ɡɔ kù wɛɛ iyi ɑ́ yɔkɔ ku lɑkɑti ŋɑ hɑi si ɑwɔi Bɑɑm. ");
INSERT INTO mkl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nɔ ɑmu do Bɑɑm fei ɑkɑ̃i. ");
INSERT INTO mkl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iyi Zuifu ŋɑu ɑ̀ ɡbɔ bɛɛbɛ ŋɔi ɑ̀ tɑsi kutɑ ɑ̀ wɑɑ bi ɑ tɑɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, do ɡbuɡbɑ̃i Bɑɑm ǹ ce icɛ jiidɑ nkpɔ si wɑju nŋɛ. Nɑ icɛ yoomɑi ì wɑɑ bi i tɑm kutɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ŋɔi Zuifu ŋɑu ɑ̀ jɛɑɑ ɑ̀ ni, ɑ kù wɑɑ bi kɑ tɑɛ kutɑ nɑ icɛ jiidɑ ŋɑu, ɑmmɑ si nɑ iyi í jɔ̀ ì wɑɑ bu Ilɑɑɔ̃i, domi ɑwɔu ɑmɑnɛi nɔ ì wɑɑ bi i ce ɑrɑɛ Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ŋɔi Jesu í ni, ɑ̀ kɔ ide ɡɔ si tiɑi woodɑ nŋɛ. Ideu wɑ fɔ idei ɑmɑnɛ ŋɑ, í ni, iŋɛ ɑmɑnɛ ŋɑ, iŋɛ mɔ Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nɔ Jesu í sɔ̃ ŋɑ mɑ́ í ni, ɑ̀ mɑ̀ iyi kukɔi idei Ilɑɑɔ̃ ntɔi wɑ fɔ do ɑjɔ fei. To, si ideu ihɛ̃ Ilɑɑɔ̃ tɑkɑɛ wɑ kpe inɛ ŋɑ iyi ɑ̀ ɡbɔ ideɛu Ilɑɑɔ̃, mɑ irei. ");
INSERT INTO mkl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Bii bɛɛbɛi, bɛirei í ce ì ni ǹ wɑ n bu Ilɑɑɔ̃ ŋɑ si nɑ iyi í jɔ̀ ǹ ni ɑmuu Amɑi Ilɑɑɔ̃i. Nɔ ɑmu tɑkɑm mɔ Bɑɑbɑi í cicɑɑm nɔ í bɛm wɑ si ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bii n kù wɑ n ce icɛi Bɑɑm i mɑɑ̀ dɑsim nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ammɑ bii ǹ wɑ n coo, bɑɑ bii i kù dɑsim nɑɑnɛ ŋɑ, i dɑsi icɛm nɑɑnɛ ku bɑ i mɑ̀ sɑ̃ɑ sɑ̃ɑ ŋɑ iyi Bɑɑbɑ í wɑ sim nɔ ɑmu mɔ ǹ wɑ si Bɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iyi ɑ̀ ɡbɔ bɛɛbɛ ŋɔi ɑ̀ wɑɑ dɛ kpɑ̃ɑ mɑ́ ɑ bɑ ɑ muu, ɑmmɑ Jesu í ɡbɑ̃ si ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","nɔ í nyi icei idoi Zuudɛ̃ɛ mɑ́ bii Zɑ̃ɑ í tɑko í dɑsi inɛ ŋɑ inyiu. Tenɡi bɛi í koo í wɑ, ");
INSERT INTO mkl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","nɔ inɛ nkpɔ í bɔ bi tɛɛ. Ŋɔi inɛ ŋɑ ɑ̀ ni, Zɑ̃ɑ kù ce mɑɑmɑɑke kɑ̃mɑ, ɑmmɑ ide iyi í fɔ si ɡɑ̃mɛi inɛɛu ihɛ̃ fei ntɔi. ");
INSERT INTO mkl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nɔ inɛ nkpɔ nkpɔ í dɑsiɛ nɑɑnɛ tenɡi bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mɔkɔ ɡɔ iyi ɑ̀ yɑ kpe Lɑzɑɑ kù wɑɑ nɛ bɑɑni. Betɑnii í jɛ iluɛ, nɔ ilui Mɑɑri do Mɑɑtɑ mɔm bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lɑzɑɑu wecĩ nŋɑi. Mɑɑriui í jɛ inɑɑbo iyi ɑ́ nɑ ku fɑ̃si tulɑre si isɛi Jesu nɔ ku ɡbɑ̃ɑ do ntoi iriɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ŋɔi wecĩ minjii Lɑzɑɑ ŋɑu ɑ̀ sɑmbɑ si Jesu ɑnu ɑ̀ ni, Lɑfɛ̃ɛ, kpɑɑsi jiidɑɛ kù wɑɑ nɛ bɑɑni. ");
INSERT INTO mkl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iyi Jesu í ɡbɔ ideu ŋɔi í ni, bɔ̃ɔu kɑɑ kpɑɑ, ɑmmɑ nɑ irii bɔ̃ɔɛu inɛ ŋɑ ɑɑ yɛ ɑmboei Ilɑɑɔ̃ do ti ɑmu iyi ǹ jɛ Amɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Wee Jesu í bi Mɑɑtɑ do ifɔɛ do wecĩ nŋɑ Lɑzɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bɑɑ do iyi í ɡbɔ bɑɑni hɑi nɛi Lɑzɑɑu, í ce ɑjɔ minji mɑ́ ilu bii í wɑu. ");
INSERT INTO mkl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Si ɑnyiɛ nɔ í sɔ̃ mɔcɔɛ ŋɑ í ni, kɑ nyi ilɛi Zudee mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ŋɔi mɔcɔɛ ŋɑ ɑ̀ ni, Mɛɛtu, si ɑjɔ minjiu ihɛ̃ bɛi ɑ̀ bi ɑ tɑɛ kutɑ, nɔ ì wɑɑ bi i nyi bɛ mɑ́? ");
INSERT INTO mkl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ŋɔi Jesu í bee ŋɑ í ni, ɑjɔ ɑkɑ̃ lɛɛu fɛloi í nɛ. Kù jɛ mɑɑteeji bɑ. Bii inɛ ɡɔ wɑ nɛ dɑsɑ̃ kɑɑ koosɛ domi wɑ yɛ inyɑ kumɑ́i ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ammɑ inɛ iyi wɑ nɛ idũ ɑ́ koosɛ domi inyɑ kumɑ́ kù wɛɛɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bɛɛbɛi Jesu í sɔ̃ ŋɑ. Nɔ í fɔ mɑ́ í ni, kpɑɑsi nwɑ Lɑzɑɑ wɑ sĩ njooi mɛɛ, ɑmmɑ ɑn koo n jũu. ");
INSERT INTO mkl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ŋɔi mɔcɔɛ ŋɑu ɑ̀ sɔ̃ɔ ɑ̀ ni, Lɑfɛ̃ɛ, bii í jɛ wɑ sĩ njooi í sĩɑ. Á bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Wee ikui Lɑzɑɑi Jesu í fɑ̃ɑ, ɑmmɑ ɑŋɑ ɑ̀ tɑmɑɑ bɛi idei njoo ɑlɑlɑi í fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nɑ ŋɔi í jɔ̀ Jesu í sɔ̃ ŋɑ do yɑɑseɛ í ni, Lɑzɑɑ kù wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ammɑ nɑ iri nŋɛi ǹ wɛɛò inɔ didɔ̃ si nɑ iyi í jɔ̀ n kù wɑ bɛ hee n jɔ̀ ku bɑ iri. Bɛbɛi nŋu bɛ ɑ́ jɔ̀ i dɑsim nɑɑnɛ ŋɑ. I nɛ kɑ bɔ bi tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ŋɔi Tomɑɑ iyi ɑ̀ yɑ kpe Sìkɑ̀u í sɔ̃ mɔcɔ kpɑɑsiɛ ŋɑ í ni, to, i jɔ̀ kɑ koo kɑ ku do Mɛɛtu ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ŋɔi Jesu do mɔcɔɛ ŋɑu ɑ̀ bɔ Betɑni bɛ. Iyi ɑ̀ to, ɑ̀ koo ɑ̀ bɑ ɑ̀ si Lɑzɑɑ tɑ̃ hee í ce ɑjɔ mɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Wee kujĩi Betɑni do Zeruzɑlɛmu kù re kilo mɛɛtɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nɔ hɑi Zeruzɑlɛmu bɛ Zuifu nkpɔ ɡɔ ŋɑ mɔ ɑ̀ nɑɑ bi Mɑɑtɑ do Mɑɑri ɑ̀ nɑɑ ku ce ŋɑ fɔɔ si bɛi wecĩ nŋɑ kù wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Iyi Mɑɑtɑ í ɡbɔ Jesu wɑ nɑɑ, ŋɔi í bɔ ku koɛ. Ammɑ Mɑɑri wɑ bubɑ kpɑsɛ̃. ");
INSERT INTO mkl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ŋɔi Mɑɑtɑ í sɔ̃ Jesu í ni, Lɑfɛ̃ɛ, bii í jɛ ì wɑ ihɛ̃ wo wecĩm kɑɑ ku. ");
INSERT INTO mkl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ammɑ ǹ mɑ̀ bɑɑ nsɛi mii iyi ɑɑ tɔɔ Ilɑɑɔ̃ fei ɑ́ muuɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ŋɔi Jesu í sɔ̃ɔ í ni, wecĩɛ ɑ́ jĩ wɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ŋɔi Mɑɑtɑ í ni, ntɔi, ǹ mɑ̀ iyi ɑjɔi ɑnkɑ̃ɑnyi iku ŋɑ ɑɑ jĩ hɑi si bɑlɛ. Nŋu mɔ ɑ́ jĩ ɑjɔ nŋu bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ŋɔi Jesu í sɔ̃ɔ í ni, ɑmui ǹ jɛ kujĩi iku ŋɑ nɔ ǹ jɛ kuwɛɛ. Inɛ iyi í dɑsim nɑɑnɛ ɑ́ mɑɑ wɛɛi bɑɑ bii í ku. ");
INSERT INTO mkl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nɔ inɛ iyi í wɛɛ nɔ í dɑsim nɑɑnɛ kɑɑ ku ɑjɔ kɑ̃mɑ. Ì dɑsi ideu bɛ nɑɑnɛ? ");
INSERT INTO mkl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nɔ Mɑɑtɑ í jɛɑɑ í ni, oo Lɑfɛ̃ɛ, ǹ dɑsi nɑɑnɛ iyi ɑwɔi ì jɛ Kirisi, Amɑi Ilɑɑɔ̃, iyi ɑ̀ ni ɑ́ nɑ ku nɑɑ si ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Iyi Mɑɑtɑ í fɔ bɛɛbɛ í tɑ̃ ŋɔi í koo í kpe Mɑɑri ifɔɛ wɑ í sɔ̃ɔ do ɡundu í ni, Mɛɛtu í to wɑ, wɑ kpeɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Iyi Mɑɑri í ɡbɔ bɛɛbɛ ŋɔi í dede do sɑɑsɑ í bɔ bi tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Wee Jesu kù lɔ wɑ inɔ ilu titɑ̃, ɑmmɑ í wɑ tenɡi bii Mɑɑtɑ í kòou. ");
INSERT INTO mkl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zuifu ŋɑ iyi ɑ̀ bɔ Mɑɑri ku ce fɔɔ kpɑsɛ̃ɛ, ɑ̀ yɛ í dede í fitɑ do sɑɑsɑ. Ŋɔi ɑ̀ tooɛ. À tɑmɑɑ wɑ bɔ ku kpɑtɑ bi bɑlɛui. ");
INSERT INTO mkl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ŋɔi Mɑɑri í to bii Jesu í wɑu. Iyi í yɔɔ ŋɔi í sɛɛbɑtɑ si wɑjuɛ í sɔ̃ɔ í ni, Lɑfɛ̃ɛ, bii ì wɑ ihɛ̃ wo wecĩm kɑɑ ku. ");
INSERT INTO mkl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iyi Jesu í yɛ wɑ kpɑtɑ nɔ Zuifu ŋɑ mɔ iyi ɑ̀ tooɛ wɑu ɑ̀ wɑɑ kpɑtɑ, ideu í fɔ inɔɛ jiidɑ jiidɑ hee wɑ yɑyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ŋɔi í bee ŋɑ í ni, iwoi ì suu ŋɑ. Nɔ ɑ̀ sɔ̃ɔ ɑ̀ ni, Lɑfɛ̃ɛ, nɑɑ cɔ. ");
INSERT INTO mkl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ŋɔi Jesu í kpɑtɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nŋui í jɔ̀ Zuifu ŋɑu ɑ̀ ni, i cɔ zɑkɑ bɛi í buu. ");
INSERT INTO mkl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ammɑ ɡɔɡɔ ŋɑ ɑ̀ ni, inɛɛu ihɛ̃ í jɔ̀ fɛɛju ŋɑ ɑ̀ yɛ ilu. Kɑɑ yɔkɔ ku ɡɑnji Lɑzɑɑ ku mɑɑ̀ ku wo? ");
INSERT INTO mkl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ŋɔi inɔ ku fɔu í jɔ̀ Jesu í yɑyɑ mɑ́, nɔ í bɔ bi bɑlɛu. Wee bɑlɛu si lɔɔmɑi iri kutɑ ɡɔi í wɑ nɔ ɑ̀ dĩ ɑndɛɛ do kutɑ nlɑ ɡɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ŋɔi Jesu í ni, i tɑle kutɑu hɑi bɛ ŋɑ. Ammɑ Mɑɑtɑ wecĩi inɛ iyi í kuu í sɔ̃ɔ í ni, Lɑfɛ̃ɛ, bii í wɑ í sɑ̃mi wɑ nu tɑ̃ domi hɑi wɑɑti iyi ɑ̀ dɑsiɛ bɑlɛ í to ɑjɔ mɛɛ wɑ nnyi. ");
INSERT INTO mkl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ŋɔi Jesu í beeɛ í ni, i jɔ ǹ sɔ̃ɛ ǹ ni bii ì dɑsim nɑɑnɛ ɑɑ yɛ ɑmboei Ilɑɑɔ̃ mɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Si ɑnyiɛ ŋɔi ɑ̀ tɑle kutɑu hɑi bɛ. Nɔ Jesu í wu iju lele í ni, Bɑɑm, ǹ wɑ n sɑɑbuɛ si nɑ iyi í jɔ̀ ì ɡbɔ kutɔɔm. ");
INSERT INTO mkl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Amu tɑkɑm ǹ mɑ̀ iyi wɑɑti kɑ̃mɑ fei ì yɑ mɑɑ ɡbɔ idem, ɑmmɑ ǹ fɔ bɛɛbɛi nɑ inɛ ŋɑ iyi ɑ̀ wɑɑ leekĩ ihɛ̃ ku bɑ ɑ dɑsi nɑɑnɛ iyi ɑwɔi ì bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi í lɑ hee lele í ni, Lɑzɑɑ, fitɑ wɑ hɑi bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ŋɔi í fitɑ wɑ hɑi inɔ bɑlɛu do ɑcɔ iyi ɑ̀ woò ɑwɔɛ ŋɑ do isɛɛ ŋɑ do iriɛ. Ŋɔi Jesu í ni, i fũu i jɔ̀ ku nɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ŋɔi Zuifu ŋɑ iyi ɑ̀ nɑɑ bi Mɑɑriu, nkpɔ nŋɑ í dɑsi Jesu nɑɑnɛ iyi ɑ̀ yɛ mii iyi í ce. ");
INSERT INTO mkl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ammɑ ɡɔɡɔ ŋɑ ɑ̀ nyi ɑ̀ koo ɑ̀ sɔ̃ Fɑrisi ŋɑu mii iyi Jesu í ce. ");
INSERT INTO mkl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do Fɑrisi ŋɑu ɑ̀ tɔtɔɔ inɛ nɡboi woo ce kiiti ŋɑu mɔ ɑ̀ bee njɛ ɑ̀ wɑɑ ni, bɛirei ɑɑ kɑ ce. Inɛɛu wee í wɑsi mɑɑmɑɑke nkpɔ nkpɔ ku ce. ");
INSERT INTO mkl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bii ɑ̀ jɔ̀ wɑ ce bɛɛbɛ wɑ koo inɛ fei ɑ́ nɑ ku dɑsiɛ nɑɑnɛ. Nɔ inɛi Romu ŋɑ ɑɑ nɑɑ ɑ lɛɡɛ kpɑsɛ̃i Ilɑɑɔ̃, nɔ ɑ ko dimi nwɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ammɑ Kɑifu iyi í jɛ woo wee nlɑ si ɑdɔ̃ nŋu bɛ, í wɑ inɔ nŋɑ, nɔ í sɔ̃ ŋɑ í ni, i kù mɑ̀ nkɑ̃mɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","I kù mɑ̀ ŋɑ iyi ɑrɑnfɑ̃ɑni nwɑi inɛ ɑkɑ̃ ku ku si ɑɡbɛi dimi nwɑ ŋɑ? Si bɛɛbɛ dimi nwɑu fei kɑɑ ce nfe mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wee, ide iyi í fɔu bɛ, kù jɛ hɑi si lɑsɑbui nŋu tɑkɑɛi wɑ nɑɑ. Ammɑ si nɑ iyi í jɔ̀ í jɛ woo wee nlɑ si ɑdɔ̃ nŋu, nɑ ŋɔi í jɔ̀ í ce wɑlii Jesu ku ku si ɑɡbɛi dimii Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kù nɔ kù jɛ si ɑɡbɛi ɑŋɑ ɑkɑ̃i ɑ́ ku, ɑmmɑ ɑ́ kui ku bɑ kú jɔ̀ ɑmɑi Ilɑɑɔ̃ ŋɑ iyi ɑ̀ wɑ bii fei ɑ jɛ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ŋɔi í jɔ̀ hɑi ɑjɔ nŋu ɑ̀ wɑɑ busi njɛ ɑ bɑ ɑ kpɑ Jesu. ");
INSERT INTO mkl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nɑ ŋɔi í jɔ̀ Jesu ci yɑ mɑɑ dɑbii si inɔi Zuifu ŋɑu mɑ́ si bɑntumɑ, ɑmmɑ í nɛ hɑi bɛ í bɔ ilɛ iyi í wɑ kɔkɔi ɡbɑbuɑ ɡɔ si ilu ɡɔ iyi ɑ̀ yɑ kpe Efɑrɑimu. Nŋu do mɔcɔɛ ŋɑ ɑ̀ koo ɑ̀ bubɑ ilu bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wee jinɡɑui Zuifu ŋɑ iyi ɑ̀ yɑ kpe Iku ku kuɑ í mɑɑi wɑ. Nɔ hɑi ilɛɛko ŋɑ inɛ nkpɔ í bɔ kuwee ku ce Zeruzɑlɛmu ku bɑ ɑ mɑ́ hee jinɡɑuu ku mɑɑ̀ to wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ŋɔi ɑ̀ wɑɑ dɛdɛ Jesu, nɔ ɑ̀ leekĩ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ ɑ̀ bee njɛ ɑ̀ wɑɑ ni, bɛirei ì wɑɑ lɑsɑbu ŋɑ. Mɑ kù wɑɑ nɑɑ jinɡɑui yɑ. ");
INSERT INTO mkl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wee inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do Fɑrisi ŋɑ ɑ̀ nɑ woodɑ ɑ̀ ni bii inɛ ɡɔ í mɑ̀ bii Jesu í wɑ ku sɔ̃ ɑŋɑ ɑ koo ɑ muu. ");
INSERT INTO mkl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Si ɑjɔ mɛɛfɑ iyi í ɡbe jinɡɑui Iku ku kuɑu ku bɛi ku to wɑ, ŋɔi Jesu í bɔ Betɑni. Bɛi Lɑzɑɑ inɛ iyi Jesu í jĩ hɑi si bɑlɛu í wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ilu bɛi ɑ̀ ceɑ Jesu ijɛ wɑ jɛ. Mɑɑtɑ wɑ ɡbɔ nŋɑ nɔ Lɑzɑɑ í wɑ si inɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wee Mɑɑri í nɛ tulɑrei fiɑ nkpɔ ɡɔ iyi ɑ̀ ce do ikpoi nɑɑdi ɑlɑlɑ, zɑkɑi bubui kilo. Ŋɔi í koo í soo í nɑɑ í fɑ̃si isɛi Jesu, nɔ í ɡbɑ̃ɑ do ntoi iriɛ. Ŋɔi inunui tulɑreu í ɡbɑ kpɑsɛ̃u fei. ");
INSERT INTO mkl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ŋɔi inɛ ɑkɑ̃i mɔcɔi Jesu ŋɑu iyi ɑ̀ yɑ kpe Zudɑsi Isikɑriɔti inɛ iyi ɑ́ zɑmbɑɛu í ni, ");
INSERT INTO mkl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","fiɑi tulɑreu ihɛ̃ ɑ́ yɔkɔ ku to fiɑi icɛi ɑdɔ̃ ɑkɑ̃. Nɑ mii í jɔ̀ ɑ kù tɑɑ kɑ kpɛ̃ɑ ilu ɑre ŋɑ fiɑu. ");
INSERT INTO mkl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Iyi wɑ fɔ bɛɛbɛ kù jɛ wɑ ce ɑrɑɑrei ilu ɑre ŋɑu fɑ, ɑmmɑ si nɑ iyi í jɔ̀ í jɛ ile dei. Nŋui í yɑ mɑɑ mu bɔɡɔi fiɑ nŋɑu, nɔ í yɑ mɑɑ ce ilei fiɑ iyi ɑ̀ yɑ dɑsiu. ");
INSERT INTO mkl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ammɑ Jesu í ni, jɔ̀ ɑbou si lɑɑkɑɛ. Amui í jilɛɑ ku bɑ ku fɑ̃sim ɑ bɛi ɑ sim. ");
INSERT INTO mkl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wɑɑti kɑ̃mɑ fei ɑɑ nɛ ilu ɑre ŋɑ si inɔ nŋɛ, ɑmmɑ ɑmu i kɑɑ nɛm do ɑjɔ fei ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zuifu nkpɔ í ɡbɔ iyi Jesu í wɑ Betɑni, nɔ ɑ̀ bɔ bɛ. Kù jɛ nɑ Jesu nŋu ɑkɑ̃, ɑmmɑ ɑ̀ wɑɑ bi ɑ̀ yɛ Lɑzɑɑ iyi Jesu í jĩ hɑi si bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ammɑ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu ɑ̀ wɑɑ busi njɛ ɑ bɑ ɑ kpɑ Lɑzɑɑ mɔ, ");
INSERT INTO mkl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","domi nɑ iriɛi Zuifu nkpɔ ɡɔ ŋɑ ɑ̀ fitɑ hɑi bi tu ŋɑ ɑ̀ dɑsi Jesu nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Iju kumɑ́ɛ ŋɔi zɑmɑɑ iyi í nɑɑ jinɡɑuu í ɡbɔ iyi Jesu wɑ nɑɑ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ŋɔi ɑ̀ so wuɑi kpɑkpɑ ɑ̀ wɑɑ bɔ ku koɛ. À dɔ̃ ɑnu hee lele ɑ̀ wɑɑ ni, ɑ̀ wɑɑ sɑɑbuɛ. Aɔ̃ Lɑfɛ̃ɛ ku weeɛ, ɑwɔ iyi ì wɑɑ nɑɑ do iriɛ. Ilɑɑɔ̃ ku weeɛ, ɑwɔ Ilɑɑlui Izirɛli . ");
INSERT INTO mkl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu wee í bɑ ɑmɑ ɡbɑnkɛlɛ ɡɔ wɑ ɡũ. Bɛɛbɛi í ce si bɛi kukɔi idei Ilɑɑɔ̃ wɑ fɔ í ni, ");
INSERT INTO mkl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","I mɑɑ̀ ce njo, iŋɛ inɛi Siɔ̃ɔ ŋɑ. I cɔ ilɑɑlu nŋɛ í ɡũ ɑmɑ ɡbɑnkɛlɛ, wɑ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ide ŋɑu bɛ mɔcɔi Jesu ŋɑu ɑ kù ɡbɔ yɑɑseɛ wɑɑti bɛɛbɛ, ɑmmɑ wɑɑti iyi í nyi lelei Aɔ̃ do ɑmboeɛ, ɑ̀ ye ɡiɡi iyi mii ŋɑu fei ɑ̀ kɔɔ si kukɔi idei Ilɑɑɔ̃ nɑ iriɛ, ɑ̀ nɔ ɑ̀ ceɑɑ fei ndɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Inɛ ŋɑ iyi ɑ̀ wɑ bɛ do Jesu ɑjɔ wɑɑti iyi í kpe Lɑzɑɑ í jũu hɑi si bɑlɛu, ɑŋɑ fei ɑ̀ wɑɑ sisiɑ inɛ ŋɑ mii iyi Jesu í ce. ");
INSERT INTO mkl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ŋɔi í jɔ̀ zɑmɑɑu fei í bɔ ku koɛ bɛɛbɛ domi ɑ̀ ɡbɔ bɑɑui mɑɑmɑɑke iyi í ceu. ");
INSERT INTO mkl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nɑ nŋu, Fɑrisi ŋɑu ɑ̀ fɔ ɑŋɑ duusɔ̃ɔ ɑ̀ wɑɑ ni, i kù yɛ ɑ̀ mɔnɡɔ inɛɛu ihɛ̃i mɑm mɑm? Wee inɛi ɑndunyɑ ŋɑ fei ɑ̀ wɑɑ tooɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wee Gɛrɛki ɡɔ ŋɑ ɑ̀ wɑ si inɔi inɛ ŋɑ iyi ɑ̀ nɑɑ Zeruzɑlɛmu Ilɑɑɔ̃ ku ɡulɛɑ wɑɑtii jinɡɑuu. ");
INSERT INTO mkl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ŋɔi ɑ̀ bɔ bi Filipu inɛi Bɛsɑidɑ si ilɛi Gɑlileeu, ɑ̀ ni, mɔkɔɔyi, ɑ̀ wɑɑ bi Jesu ku yɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ŋɔi Filipu í koo í sɔ̃ Anderee, nɔ Anderee do Filipu ɑ̀ koo ɑ̀ sɔ̃ Jesu. ");
INSERT INTO mkl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, ɑwɑɑti í to mbɛ bɛi bii inɛ ŋɑ ɑɑ yɛ ɑmboei ɑmu Amɑi Amɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, bii ijui iyɑ kù cuku si ilɛ kù ku, nŋu ɑkɑ̃i ɑ́ mɑɑ wɛɛ. Ammɑ bii í ku ɑ́ bí iju nkpɔ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Inɛ iyi í bi kuwɛɛɛ ɑ́ nɑ ku kuɑɛ. Inɛ mɔ iyi kù sɑɑlu kuwɛɛɛ nɡɔɡɔ, sɔɔlui kuwɛɛ hɑi tɑ̃i lɑfɛ̃ɛ wɑ ce. ");
INSERT INTO mkl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Inɛ iyi í wɛɛ nɑ irim ku toom wɑ. Nɔ bii ǹ wɑ, bɛi lɑfɛ̃ɛ mɔ ɑ́ wɑ. Bii inɛ ɡɔ í wɛɛ nɑ irim, Bɑɑm ɑ́ ceɑ lɑfɛ̃ɛ bɛɛrɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ŋɔi Jesu í ni, nsɛi inɔm í fɔ jiidɑ jiidɑ. N kù mɑ̀ bɑɑ bɛirei ɑn fɔ. Mɑ̀ n tɔɔ Bɑɑbɑ ku nyɑm si wɑhɑlɑ iyi ɑ́ bɑm nsɛiu ihɛ̃i yɑ. Aɑwo, n kɑɑ n ce bɛɛbɛ domi nɑ nŋui í jɔ̀ ǹ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bɑɑbɑ, jɔ̀ iriɛ ku nɛ bɛɛrɛ. Iyi Jesu í fɔ bɛɛbɛ ŋɔi ɑ̀ ɡbɔ ide ku fɔ ɡɔ wɑ hɑi lele í ni, ǹ jɔ̀ ì nɛ bɛɛrɛ tɑ̃ nɔ ɑn jɔ̀ ku kɔ̃ɔsi mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Iyi inɛ ŋɑ iyi ɑ̀ wɑ bɛu ɑ̀ ɡbɔ ide ku fɔu, ŋɔi ɑ̀ ni, kulɑi ijĩi. Ŋɔi inɛ ɡɔ ŋɑ mɔ ɑ̀ ni, ɑmɑlekɑ ɡɔi wɑ bɑɑ ide ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nɔ Jesu í sɔ̃ ŋɑ í ni, kù jɛ nɑ irim nii ɑ̀ ɡbɔ ide ku fɔu bɛ, ɑmmɑ nɑ iri nŋɛi. ");
INSERT INTO mkl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nsɛi ɑjɔ í to wɑ mbɛ si bii Ilɑɑɔ̃ ɑ́ kiiti inɛi ɑndunyɑ ŋɑ. Bɛbɛii ɑɑ lele Seetɑm ilɑɑlui ɑndunyɑu. ");
INSERT INTO mkl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wɑɑti iyi ɑɑ som hɑi ilɛ ɑ kɔɑm lele, wɑɑti bɛɛbɛi ɑn fɑ inɛ fei wɑ bi tom. ");
INSERT INTO mkl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Si ideu bɛ Jesu wɑ sisi yɑɑse bɛi nŋu ɑ́ kui. ");
INSERT INTO mkl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ŋɔi zɑmɑɑu í sɔ̃ɔ í ni, ɑ̀ ɡbɔ si tiɑi woodɑ nwɑ iyi inɛ iyi Ilɑɑɔ̃ í cicɑu ɑ́ mɑɑ wɛɛi hee do ɑjɔ fei. Bɛirei í ce ì wɑɑ ni kù nɛ bɛi ɑ́ ce iyi ɑ kù so Amɑi Amɑnɛ hɑi ilɛ ɑ kɔɑɛ lele. Yooi í jɛ Amɑi Amɑnɛu. ");
INSERT INTO mkl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, í ɡbe keeke iyi inyɑ kumɑ́ kɑɑ wɑ ɑnini nŋɛ mɑ́. Í sĩɑ i yɑ mɑɑ nɛ si wɑɑti iyi ì nɛ inyɑ kumɑ́u ŋɑ ku bɑ ilu kuku ku mɑɑ̀ nɑ ku boe ŋɛ, domi inɛ iyi wɑ nɛ si ilu kuku ci yɑ mɑ̀ bii wɑ bɔ. ");
INSERT INTO mkl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nɑ nŋu, i dɑsi inyɑ kumɑ́u nɑɑnɛ wɑɑti iyi ì nɔɔ ŋɑ ku bɑ i jɛ ɑmɑi inyɑ kumɑ́ ŋɑ. Iyi Jesu í fɔ bɛɛbɛ í tɑ̃ ŋɔi í dede hɑi inɔ nŋɑ í nɛ í koo í mɑnji. ");
INSERT INTO mkl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bɑɑ do iyi í ce mɑɑmɑɑke nkpɔ fei si wɑju nŋɑ ɑ kù dɑsiɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bɛɛbɛi ide iyi wɑlii Ezɑi í fɔu í ce. Í ni, Lɑfɛ̃ɛ, yooi í dɑsi wɑɑzo nwɑ nɑɑnɛ. Mɑ̀ bi yooi Lɑfɛ̃ɛ í nyisi ɡbuɡbɑ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Wɑlii Ezɑi í fɔ mɑ́ í ni, Ilɑɑɔ̃ í fɛɛju ŋɑ, Ku bɑ ɑ mɑɑ̀ yɛ ilu. Nɔ í jɔ̀ idɔ nŋɑ í le Ku bɑ ɑ mɑɑ̀ mɑ̀ do bisi nŋɑ. Í ce bɛɛbɛi ku bɑ ɑ mɑɑ̀ nɑ ɑ kpɑɑsi idɔ nɔ nŋu ku jɔ̀ ɑ bɑ iri. Ŋɔi í jɔ̀ ɑ kù yɔkɔ ɑ kù dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezɑi í fɔ bɛɛbɛi si nɑ iyi í jɔ̀ í yɛ ɑmboei Jesu nɔ í fɔ ide nɑ iriɛ. ");
INSERT INTO mkl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Do nŋu fei, bɑɑ inɛ nɡboi Zuifu ŋɑu nkpɔ í dɑsi Jesu nɑɑnɛ. Ammɑ si bɛi ɑ̀ wɑɑ ce njoi Fɑrisi ŋɑu ɑ kù jɛsi si bɑntumɑ ku bɑ ɑ mɑɑ̀ nɑ ɑ ɡɑnji ŋɑ ile bii ɑ̀ yɑ ce kutɔtɔɔ ŋɑu ku bɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","A kù wɑɑ bi ɑ lele ɑŋɑ hɑi bɛi si nɑ iyi í jɔ̀ sɑɑbui ɑmɑnɛ ŋɑi ɑ̀ bi í re ti Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ŋɔi Jesu í fɔ ide hee lele í ni, inɛ iyi í dɑsim nɑɑnɛ, kù jɛ ɑmu ɑkɑ̃i í dɑsi nɑɑnɛ, í dɑsi inɛ iyi í bɛm wɑ mɔ nɑɑnɛi. ");
INSERT INTO mkl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bɛɛbɛ mɔi inɛ iyi í yɛm í yɛ inɛ iyi í bɛm wɑi. ");
INSERT INTO mkl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Amui ǹ jɛ inyɑ kumɑ́, nɔ ǹ nɑɑi si ɑndunyɑ ku bɑ inɛ iyi í dɑsim nɑɑnɛ fei ku mɑɑ̀ wɑ si ilu kuku mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Inɛ iyi í ɡbɔ idem nɔ kù wɑɑ sɑɑluɛ, kù jɛ ɑmui ɑn yɛ tɑɑlei lɑfɛ̃ɛ. Amu ǹ nɑɑi n nɑ n fɑɑbɑ inɛi ɑndunyɑ ŋɑ, n kù nɑɑ ku yɛ tɑɑle nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Inɛ iyi í kɔsim nɔ kù ɡbɑ idem, í nɛ mii iyi ɑ́ yɛ tɑɑlei lɑfɛ̃ɛi. Ide ŋɑ iyi ǹ fɔ, nŋui ɑ́ yɛ tɑɑlei lɑfɛ̃ɛ si ɑjɔi ɑnkɑ̃ɑnyiu. ");
INSERT INTO mkl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ideui ɑ́ yɛ tɑɑleɛ si nɑ iyi í jɔ̀ n kù wɑ n fɔ ide do yiikoi ɑrɑm, ɑmmɑ Ilɑɑɔ̃ Bɑɑbɑ tɑkɑɛi í sɔ̃m ide ŋɑ iyi ɑn fɔ. Nŋui í nɔ í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ǹ mɑ̀ iyi ide ŋɑ iyi í sɔ̃m ŋɑu kuwɛɛ hɑi tɑ̃i ɑ́ jɛ kɔkɔɔ nŋɑ. Ŋɔi í jɔ̀ ide iyi ǹ wɑ n fɔ, ǹ wɑ n fɔɔi bɛi Bɑɑbɑ í sɔ̃m. ");
INSERT INTO mkl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ajɔ iyi bii iju í mɑ́ ɑ́ jɛ jinɡɑui Iku ku kuɑu í to. Nɔ Jesu í mɑ̀ iyi wɑɑtii nŋu í to mbɛ nŋu ku nɛ hɑi ɑndunyɑ nŋu ku bɔ bi Bɑɑi nŋu. Hɑi sinte hee ku bɑɑ nsɛi í nɛ kubii inɛɛ ŋɑ, nɔ kubi nŋɑ iyi í nɛu í bɔòi hee kɔɔ. ");
INSERT INTO mkl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ŋɔi Jesu do mɔcɔɛ ŋɑ ɑ̀ wɑɑ jɛ ɑjɔ. Wee Seetɑm í tɑle si Zudɑsi Isikɑriɔti ɑmɑi Simɔɔu ku zɑmbɑɛ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesu tɑkɑɛ í mɑ̀ iyi Ilɑɑɔ̃ Bɑɑbɑ í dɑɑ nŋu mii fei si ɑwɔ, í nɔ í mɑ̀ iyi nŋu í nɑɑi hɑi bi Ilɑɑɔ̃ nɔ nŋu wɑ nyi bɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ŋɔi í dede hɑi bi ku jɛu í bɔ́ kumbooɛ í jilɔɔ, nɔ í so ɑcɔ ɡɔ í dĩ si kpɑkɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ŋɔi í bu inyi si jɛɛ wɑ wiɛò kutɛi mɔcɔɛ ŋɑ nɔ wɑ ɡbɑ̃ɑ do ɑcɔ iyi í dĩ si kpɑkɑɛu. ");
INSERT INTO mkl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iyi í to si Simɔɔ Piɛɛ ŋɔi Piɛɛ í beeɛ í ni, Lɑfɛ̃ɛ, ɑwɔi ɑɑ wiɛ kutɛm? ");
INSERT INTO mkl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nɔ Jesu í jɛɑɑ í ni, i kù mɑ̀ mii iyi ǹ wɑ n ce nsɛi, ɑmmɑ bii í kɔ̃ɔsi ɑɑ nɑ i mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ŋɔi Piɛɛ í ni, ɑɑwo, ɑwɔ si ɑɑ wiɛm kutɛm pɑi. Ŋɔi Jesu í sɔ̃ɔ í ni, bii n kù wiɛ kutɛɛ i kɑɑ jɛ inɛm mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ŋɔi Simɔɔ Piɛɛ í ni, debɛi Lɑfɛ̃ɛ, kù jɛ kutɛm nŋu ɑkɑ̃i ɑɑ wiɛ mɛɛ, wiɛ ɑwɔm do irim fei. ");
INSERT INTO mkl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ŋɔi Jesu í sɔ̃ɔ í ni, inɛ iyi í wɛ tɑ̃ kù nɛ bukɑɑtɑi ku wɛ mɑ́ í ɡbe isɛɛ ŋɑ ku bɑ ku mɑ́ mɑm mɑm. Iŋɛ ì mɑ́, ɑmmɑ kù jɛ iŋɛ fei. ");
INSERT INTO mkl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Wee Jesu í mɑ̀ inɛ iyi ɑ́ zɑmbɑ nŋu tɑ̃, ŋɔi í jɔ̀ í ni kù jɛ ɑŋɑ feii ɑ̀ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iyi í wiɛ kutɛ nŋɑ ŋɑ í tɑ̃, ŋɔi í so kumbooɛ í dɑsi, nɔ í nyi ɑɡbɛɛ mɑ́ í bɛi í bee ŋɑ í ni, ì mɑ̀ yɑɑsei icɛ iyi ǹ ce nŋɛu bɛ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ì yɑ mɑɑ kpem Mɛɛtu do Lɑfɛ̃ɛ ŋɑ. Ntɔi ì wɑɑ fɔ ŋɑ, domi bɛɛbɛi ǹ jɛ. ");
INSERT INTO mkl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","To, bii ɑmu iyi ǹ jɛ Lɑfɛ̃ɛ do Mɛɛtu nŋɛ ǹ wiɛ kutɛ nŋɛ ŋɑ, í sĩɑ iŋɛ mɔ i yɑ wiɛ kutɛi njɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yɑɑse jiidɑi ǹ nyisi ŋɛ bɛ ku bɑ iŋɛ mɔ i yɑ ceɑ njɛ bɛi ǹ ce nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, woo ce icɛ ci yɑ lɑ ku re inɛ nɡboɛ. Bɛɛbɛ mɔi inɛ iyi ɑ̀ bɛ ci yɑ lɑ ku re inɛ iyi í bɔɔ. ");
INSERT INTO mkl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nsɛi wee ì mɑ̀ yɑɑsei iyi ihɛ̃ ŋɑ. Bii ì wɑɑ coo ŋɑ, ɑɑ nɛ inɔ didɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kù jɛ iŋɛ feii ǹ wɑ n fɑ̃ɑ. Ǹ mɑ̀ inɛ ŋɑ iyi ǹ cicɑi. Ammɑ kù nɛ bɛi ɑ́ ce iyi kukɔi idei Ilɑɑɔ̃ kù kɔ̃. Kukɔu í ni, inɛ iyi wɑ bɑm ku jɛ ɑjɔ, nŋui í sindɑ í jɛ mbɛɛm. ");
INSERT INTO mkl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Hɑi nsɛi ǹ wɑ n sɔ̃ ŋɛi hee ide ŋɑu ku mɑɑ ce ku bɑ bii í nɑ í ce i dɑsi nɑɑnɛ ŋɑ iyi ɑmui ǹ jɛ inɛ iyi ǹ ni ǹ jɛu. ");
INSERT INTO mkl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, inɛ iyi í ɡbɑ inɛ iyi ǹ bɛ, ɑmui í ɡbɑ. Nɔ inɛ iyi í ɡbɑm, inɛ iyi í bɛm wɑi í ɡbɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃, ŋɔi inɔɛ í fɔ kɑɑ kɑɑ. Ŋɔi í sɔ̃ ŋɑ sɑ̃ɑ sɑ̃ɑ í ni, ntɔ ntɔ ɑn sɔ̃ ŋɛ, inɛ ɑkɑ̃ nŋɛi ɑ́ zɑmbɑm. ");
INSERT INTO mkl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ŋɔi mɔcɔ ŋɑu ɑ̀ wɑɑ cɔ njɛ domi ɑ kù mɑ̀ inɛ iyi wɑ fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wee inɛ ɑkɑ̃ nŋɑ, inɛ iyi Jesu í bi jiidɑ jiidɑu, wɑ ɡbesi ɡɛndɛi Jesu. ");
INSERT INTO mkl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ŋɔi Simɔɔ Piɛɛ í ceɑɑ nyindɑ do ɑwɔ ku bee Jesu yooi wɑ fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ŋɔi mɔcɔ iyi wɑ ɡbesi ɡɛndɛi Jesuu í beeɛ í ni, Lɑfɛ̃ɛ, yooi ì wɑɑ fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ŋɔi Jesu í jɛɑɑ í ni, ɑn bu kili nɔ n ɡusi ɑyɛ, inɛ iyi ǹ nɑ, lɑfɛ̃ɛi. Ŋɔi í bu kiliu í nɑ Zudɑsi ɑmɑi Simɔɔ Isikɑriɔti. ");
INSERT INTO mkl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hɑi wɑɑti iyi Zudɑsi í ɡbɑ kiliu ɡbɑkɑ̃ Seetɑm í lɔ siɛi. Ŋɔi Jesu í sɔ̃ɔ í ni, mii iyi ɑɑ ce, coo do njumɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ammɑ si inɔ nŋɑ inɛ ɡɔ kù mɑ̀ mii iyi í jɔ̀ í sɔ̃ɔ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Si bɛi Zudɑsii wɑ mu bɔɡɔi fiɑ nŋɑu, ŋɔi í jɔ̀ inɛ ɡɔ ŋɑ ɑ̀ tɑmɑɑ Jesu í ni koo rɑ nɡɔɡɔ wɑ iyi ɑŋɑ ɑɑ jɛò jinɡɑui wɑlɑkɔ wɑ sɔ̃ɔ ku muɑ ilu ɑre ŋɑ fiɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iyi Zudɑsi í ɡbɑ ciliu í mi ɡbɑkɑ̃ ŋɔi í fitɑ. Wee í ko idũ í dũ. ");
INSERT INTO mkl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iyi Zudɑsi í fitɑ ŋɔi Jesu í ni, bɛbɛii inɛ ŋɑ ɑɑ yɛ ɑmboei ɑmu Amɑi Amɑnɛ, nɔ ɑɑ yɛ ti Ilɑɑɔ̃ mɔ nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Si bɛi inɛ ŋɑ ɑɑ yɛ ɑmboei Ilɑɑɔ̃ nɑ irim, nŋu tɑkɑɛ ɑ́ jɔ̀ ɑ yɛ ti ɑmu mɔ. Á coo mɔi kɑɑ kpɛ. ");
INSERT INTO mkl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Iŋɛ bɑɑkɔɔm ŋɑ, wɑɑti keekei í ɡbe iyi ɑn wɛɛ do iŋɛ, nɔ si ɑnyiɛ ɑɑ nɑ i mɑɑ dɛdɛɛm ŋɑ. Ammɑ ide iyi ǹ sɔ̃ Zuifu ŋɑu nŋui ǹ wɑ n sɔ̃ iŋɛ mɔ bɛ nsɛi. I kɑɑ yɔkɔ i bɔ bii ǹ wɑ n bɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Woodɑ titɔ̃ iyi ǹ wɑ n jilɛ nŋɛ wee, i yɑ bi njɛ ŋɑ. Si bɛi ǹ bi ŋɛ, iŋɛ mɔ i yɑ bi njɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bii ì bi njɛ ŋɑ, inɛ fei ɑ́ mɑ̀ iyi ì jɛ mɔcɔm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ŋɔi Simɔɔ Piɛɛ í bee Jesu í ni, iwoi ì wɑɑ bɔ Lɑfɛ̃ɛ. Ŋɔi Jesu í jɛɑɑ í ni, bii ǹ wɑ n bɔ i kɑɑ yɔkɔ i toom nsɛi, ɑmmɑ bii í kɔ̃ɔsi ɑɑ toom wɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ŋɔi Piɛɛ í beeɛ í ni, Lɑfɛ̃ɛ, bɛirei í ce n kɑɑ n yɔkɔ n tooɛ nsɛi. Ǹ tɑ̃ sɔɔlu n nɑ kuwɛɛm nɑ iriɛ. ");
INSERT INTO mkl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ŋɔi Jesu í jɛɑɑ í ni, ì tɑ̃ sɔɔlu i nɑ kuwɛɛɛ nɑ irim do ntɔ? Ntɔ ntɔ ǹ wɑ n sɔ̃ɛi, hee ɑjɛɛ ku mɑɑ kɔ ɑɑ jɑ̃ isɛ ɡbɛɛtɑ i ni i kù mɑ̀m. ");
INSERT INTO mkl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ŋɔi Jesu í sɔ̃ mɔcɔɛ ŋɑ í ni, i mɑɑ̀ yɑ wɛɛ do inɔ ku fɔ ŋɑ. I dɑsi Ilɑɑɔ̃ nɑɑnɛ nɔ i dɑsim nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bi ku wɑ í kpɔ kpɑsɛ̃i Bɑɑm. Nɔ wee ǹ wɑ n koo bɛ n koo n ce nŋɛ sɔɔlui bi ku wɑ. Bii kù jɛ ntɔ, n kɑɑ n sɔ̃ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bii ǹ koo ǹ ce nŋɛ bi ku wɑ ǹ tɑ̃ ɑn nyi wɑ mɑ́, n nɑɑ n ɡbɑ̃ ŋɛ n bɔò ŋɛ bi tom ku bɑ iŋɛ mɔ i wɑ bii ǹ wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bii ǹ wɑ n bɔ ì mɑ̀ kpɑ̃ɑu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ŋɔi Tomɑɑ í ni, Lɑfɛ̃ɛ, ɑ kù mɑ̀ bɑɑ bii ì wɑɑ bɔ mɔm. Bɛirei ɑɑ kɑ ce kɑ mɑ̀ kpɑ̃ɑu. ");
INSERT INTO mkl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ŋɔi Jesu í jɛɑɑ í ni, ɑmui ǹ jɛ kpɑ̃ɑ, do ntɔ, do kuwɛɛ. Inɛ kɑ̃mɑ kɑɑ bɔ bi Ilɑɑɔ̃ Bɑɑbɑ bii kù jɛ hɑi do bi tom. ");
INSERT INTO mkl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bii ì mɑ̀m ŋɑ, ɑɑ mɑ̀ Bɑɑm ŋɑ. Nɔ hɑi nsɛi ì mɑ̀ɑ ŋɑ ì nɔ ì yɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ŋɔi Filipu í ni, Lɑfɛ̃ɛ, nyisi wɑ Bɑɑbɑ, nŋu bɛ ɑ́ to wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ŋɔi Jesu í jɛɑɑ í ni, Filipu, hɑi kukpɛi ǹ wɑ inɔ nŋɛ ihɛ̃ nɔ i kù mɑ̀m? Inɛ iyi í yɛm í yɛ Ilɑɑɔ̃ Bɑɑbɑi. To, nɑ mii í ce ì wɑɑ ni, nyisi wɑ Ilɑɑɔ̃ Bɑɑbɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","I kù dɑsi nɑɑnɛ iyi ǹ wɑ si Ilɑɑɔ̃ Bɑɑbɑ, nɔ Ilɑɑɔ̃ Bɑɑbɑ mɔ í wɑ sim ni? Ide iyi ǹ wɑ n sɔ̃ ŋɛ, n kù wɑ n fɔɔ do yiikoi ɑmu tɑkɑm. Ammɑ Bɑɑbɑ í wɑ sim nɔ nŋui wɑ ce icɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","I dɑsim nɑɑnɛ ŋɑ iyi ǹ wɑ si Bɑɑbɑ nɔ Bɑɑbɑ mɔ í wɑ sim. Wɑlɑkɔ i dɑsi nɑɑnɛ ŋɑ bɑɑ nɑ icɛu tɑkɑɛ iyi ì wɑɑ yɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, inɛ iyi í dɑsim nɑɑnɛ, lɑfɛ̃ɛ mɔ ɑ́ ce icɛ iyi ǹ wɑ n ce, nɔ ɑ́ ce ku lɑ ku re bɛɛbɛ mɔm, domi wee ǹ wɑ n bɔ bi Bɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nɔ mii iyi ɑɑ tɔɔɛ do irim ŋɑ fei ɑn coo ku bɑ ɑmu Amɑu n nyisiò ɑmboei Bɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bii ì tɔɔɛ nɡɔɡɔ do irim ɑɑ bɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nɔ Jesu í ni mɑ́, bii ì bim ŋɑ ɑɑ jirimɑ mii iyi ǹ ni i ce ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nɔ ɑn tɔɔ Ilɑɑɔ̃ Bɑɑbɑ ku mu nŋɛ Woo muɑ ɡbuɡbɑ̃ mmuɛ wɑ, iyi ɑ́ mɑɑ wɛɛ do iŋɛ hee do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Woo muɑ ɡbuɡbɑ̃u Hundei Ilɑɑɔ̃i, nŋui ɑ́ jɔ̀ inɛ ŋɑ ɑ mɑ̀ ntɔu. Inɛi ɑndunyɑ ŋɑ ɑ kɑɑ yɔkɔ ɑ ɡbɑɑ si nɑ iyi í jɔ̀ ɑ kù wɑɑ yɔɔ, bɛɛbɛ mɔi ɑ kù mɑ̀ɑ. Ammɑ iŋɛ ì mɑ̀ɑ ŋɑ, domi í wɛɛ do iŋɛ, ɑ́ nɔ ku wɑ si idɔ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","N kɑɑ n jɔ̀ ŋɛ kɔyɔ. An nɑ n nyi wɑ bi tu ŋɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Í ɡbe keeke nsɛi iyi inɛi ɑndunyɑ ŋɑ ɑ kɑɑ yɛm mɑ́, ɑmmɑ iŋɛ ɑɑ yɛm ŋɑ si nɑ iyi í jɔ̀ ǹ wɛɛ, nɔ iŋɛ mɔ ɑɑ wɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wɑɑti iyi ɑjɔu í to wɑ ɑɑ mɑ̀ ŋɑ iyi ǹ wɑ si Bɑɑm nɔ iŋɛ mɔ ì wɑ sim ŋɑ nɔ ɑmu mɔ ǹ wɑ si ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Inɛ iyi í mɑ̀ woodɑm nɔ wɑ jirimɑɛ, lɑfɛ̃ɛi í bim. Inɛ iyi í bim, Bɑɑm ɑ́ bi nŋu mɔ, nɔ ɑmu tɑkɑm ɑn bi lɑfɛ̃ɛ, nɔ ɑn nyisiɛ ɑrɑm. ");
INSERT INTO mkl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Zudɑsi ɡɔ í wɑ bɛ, ɑmmɑ kù jɛ Zudɑsi Isikɑriɔti. Nŋui í beeɛ í ni, Lɑfɛ̃ɛ, bɛirei ɑɑ ce i nyisi wɑ ɑrɑɛ nɔ i kɑɑ nyisi inɛi ɑndunyɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ŋɔi Jesu í jɛɑɑ í ni, inɛ iyi í bim fei ɑ́ ɡbɔ idem, nɔ Bɑɑm ɑ́ bi lɑfɛ̃ɛ nɔ ɑmu do Bɑɑm nɔu fei ɑɑ kɑ nɑ kɑ ce bi ku wɑ si idɔi lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Inɛ iyi kù bim, lɑfɛɛ kɑɑ jirimɑ idem pɑi. Nɔ ide iyi ì wɑɑ ɡbɔ ŋɑu ihɛ̃ ŋɑ, kù jɛ idei ɑmu tɑkɑm, ɑmmɑ idei Bɑɑbɑi. Nŋui í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ide ŋɑu ihɛ̃ fei ǹ wɑ n sɔ̃ ŋɛi hɑi wɑɑti iyi ǹ wɑ inɔ nŋɛ ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ammɑ Hundei Ilɑɑɔ̃, Woo muɑ ɡbuɡbɑ̃u, ɑ́ mɑɑ kɔ ŋɛ si mii fei, nɔ ku mɑɑ ye ŋɛ ɡiɡii ide ŋɑ iyi ǹ tɑko ǹ sɔ̃ ŋɛ fei. Nŋui Bɑɑbɑ ɑ́ bɛ nŋɛ wɑ do irim nɔu. ");
INSERT INTO mkl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Lɑɑkɑi ku sũi ǹ wɑ n jɔ̀ nŋɛ. Bɛi ɑmu tɑkɑm ǹ wɛɛò lɑɑkɑi ku sũ, bɛɛbɛ mɔi ɑn jɔ̀ iŋɛ mɔ í wɛɛò lɑɑkɑi ku sũ. Nɔ lɑɑkɑi ku sũ iyi ɑn mu nŋɛu kɑɑ jɛ bɛi ti ɑndunyɑ. Nɑ nŋu, i mɑɑ̀ wɛɛò inɔ ku fɔ ŋɑ, nɔ i mɑɑ̀ jɔ̀ ziɡi nŋɛ ku dɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ì ɡbɔ ŋɑ iyi ǹ sɔ̃ ŋɛ ǹ ni ǹ wɑ n koo ɑmmɑ ɑn nyi wɑ bi tu ŋɛ mɑ́. Bii ì bim ŋɑ ɑɑ wɛɛ do inɔ didɔ̃ ŋɑ do iyi ǹ wɑ n bɔ bi Bɑɑbɑ, domi nŋui í rem. ");
INSERT INTO mkl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nɑ ŋɔi í ce ǹ wɑ n sɔ̃ ŋɛ hɑi nsɛi hee ide ŋɑu ku mɑɑ ce, ku bɑ bii ideu í nɑ í ce i dɑsim nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","N kɑɑ n bɑ n sɔ̃ ŋɛ ide nkpɔ mɑ́ si nɑ iyi í jɔ̀ Seetɑm ilɑɑlui ɑndunyɑu wɑ nɑɑ, ɑmmɑ kù nɛ ɡbuɡbɑ̃ kɑ̃mɑ sim. ");
INSERT INTO mkl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","To, i dede kɑ nɛ ku bɑ inɛi ɑndunyɑ ŋɑ ɑ mɑ̀ iyi ǹ bi Bɑɑbɑ nɔ ǹ wɑ n ce fei ndɛɛ si bɛi Bɑɑbɑ í nɑm woodɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Si ɑnyii nŋu nɔ Jesu í sɔ̃ ŋɑ mɑ́ í ni, ɑmui ǹ jɛ icui jĩi ndii rezɛ̃ɛ nɔ Bɑɑm mɔi í jɛ woo loɡooɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Amɑɑwɔm ŋɑ iyi ɑ ci yɑ so fei, nŋui í yɑ dɑ ŋɑ ku nyɔ ŋɑ. Amɑɑwɔ ŋɑ iyi ɑ̀ wɑɑ so mɔ í yɑ kɔtɑ ŋɑi ku bɑ kuso nŋɑ ku kɔ̃ɔsi. ");
INSERT INTO mkl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Iŋɛ í mɑ́ tɑ̃ do sɑɑbui ide iyi ǹ sɔ̃ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","I jɔ̀ i mɑ́ sim ŋɑ, nɔ ɑmu mɔ ɑn mɑ́ si ŋɛ. Si bɛi ɑmɑɑwɔ kɑɑ yɔkɔ ku so iso do ɑrɑɛ bii kù jɛ wɑ mɑ́ si icui jĩi, bɛɛbɛ mɔi iŋɛ tɑkɑ nŋɛ i kɑɑ yɔkɔ i so bii i kù wɑɑ mɑ́ sim ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Amui ǹ jɛ icui jĩi ndii rezɛ̃ɛ, iŋɛ mɔi ì jɛ ɑmɑɑwɔɛ ŋɑ. Inɛ iyi wɑ mɑ́ sim nɔ ɑmu mɔ ǹ wɑ n mɑ́ si lɑfɛ̃ɛ, ɑ́ so iso nkpɔ. Ammɑ bii kù jɛ do ɑmu i kɑɑ yɔkɔ i ce nɡɔɡɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Inɛ iyi kù wɑɑ mɑ́ sim ɑɑ nyɑɑi ɑ nyɔɔ bɛi ɑ̀ yɑ nyɔ ɑmɑɑwɔi jĩi ŋɑ. Si ɑnyiɛ, bii ɑ̀ ɡbɛ nɔ ɑ tɔtɔɔ ŋɑ ɑ dɑsi ŋɑ inɑ ɑ jo. ");
INSERT INTO mkl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bii ì wɑɑ mɑ́ sim ŋɑ nɔ idem í wɑ si ŋɛ i tɔɔ mii iyi ì bi fei ŋɑ ɑɑ bɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Iso nkpɔ ku so nŋɛi ɑ́ jɔ̀ irii Bɑɑm ku nɛ ɑmboe. Bɛɛbɛ mɔi ɑɑ nyisiò inɛ ŋɑ iyi iŋɛu mɔcɔm ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ǹ bi ŋɛi bɛi Bɑɑm mɔ í bim. I jɔ̀ i wɑ si kubim ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bii ì wɑɑ jirimɑ woodɑm ŋɑ, bɛɛbɛ mɔi ɑɑ wɑ si kubim ŋɑ, bɛi ɑmu mɔ ǹ jirimɑ woodɑi Bɑɑm nɔ ǹ wɑ si kubiɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ǹ sɔ̃ ŋɛ inɛ nŋu bɛi ku bɑ inɔ didɔ̃m ku wɑ si ŋɛ nɔ inɔ didɔ̃ nŋɛ ku kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Woodɑ iyi ǹ nɑ ŋɛ wee, i yɑ bi njɛ ŋɑ bɛi ǹ bi ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kubi nlɑ ɡɔ kù wɛɛ iyi í re inɛ ku ku si ɑɡbɛi kpɑɑsiɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bii ì wɑɑ ce iyi ǹ dɑsi ŋɛ ì jɛ kpɑɑsim ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","N kɑɑ n kpe ŋɛ ɑru mɑ́, domi ɑru ci yɑ mɑ̀ mii iyi lɑfɛ̃ɛɛ wɑ ce. Ammɑ ǹ wɑ n kpe ŋɛ kpɑɑsi ŋɑ si nɑ iyi í jɔ̀ mii iyi ǹ ɡbɔ hɑi bi Bɑɑm fei, nŋui ǹ sɔ̃ ŋɛ bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kù jɛ iŋɛi í cicɑɑm, ɑmmɑ ɑmui ǹ cicɑ ŋɛ. Nɔ ǹ nyɑ ŋɛ ikɑ̃ ku bɑ i yɑ so iso iyi ɑ́ kpɛ ŋɑ. Si bɛɛbɛ mii iyi ɑɑ tɔɔ Bɑɑbɑ do irim ŋɑ fei ɑ́ mu nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iyi ǹ wɑ n dɑsi ŋɛ nŋui í jɛ i yɑ bi njɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Bii inɛi ɑndunyɑ ŋɑ ɑ̀ cé ŋɛ, i mɑ̀ ŋɑ iyi ɑmui ɑ̀ tɑko ɑ̀ cé. ");
INSERT INTO mkl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bii ì jɛ ti ɑndunyɑ ŋɑ, tilɑsi inɛi ɑndunyɑ ŋɑ ɑɑ bi ŋɛi, domi tu ŋɑi ì jɛ ŋɑ. Ammɑ ɑmu ǹ cicɑ ŋɛi ǹ nyɑ ŋɛ hɑi si ɑndunyɑ, nɔ i kù jɛ ti ɑndunyɑ mɑ́ ŋɑ. Nŋui í jɔ̀ inɛi ɑndunyɑ ŋɑ ɑ̀ cé ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nɔ i ye ɡiɡii ide iyi ǹ sɔ̃ ŋɛ ǹ ni woo ce icɛ ci yɑ lɑ ku re lɑfɛ̃ɛɛ. Bɛɛbɛi si bɛi ɑ̀ wɑhɑlɑm ɑɑ wɑhɑlɑ iŋɛ mɔ. Bii í jɛ ɑ̀ jirimɑ idem, bɛɛbɛ mɔi ɑɑ jirimɑ ide nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ammɑ mii ŋɑu bɛ fei ɑɑ ce nŋɛi nɑ irim si nɑ iyi í jɔ̀ ɑ kù mɑ̀ inɛ iyi í bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bii n kù nɑɑ n kù sɔ̃ ŋɑ ide wo, dulum kɑɑ wɑ si iri nŋɑ. Ammɑ nsɛi ɑ kù nɛ bɛi ɑɑ ce ɑ ni ɑŋɑ ɑ kù mɑ̀ mɑ̀ dulum nii. ");
INSERT INTO mkl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Inɛ iyi í cém í cé Bɑɑm mɔi. ");
INSERT INTO mkl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Inɛ kɑ̃mɑ kù ce mii iyi ǹ ce si ɑnini nŋɑ. Bii n kù ce mii ŋɑu bɛ wo, dulum du ŋɑ kɑɑ wɑ si iri nŋɑ. Ammɑ wee nsɛi ɑ̀ yɛ fei ndɛɛ nɔ do nŋu fei ɑ̀ cé ɑmu do Bɑɑm. ");
INSERT INTO mkl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Iyi bɛ í cei ku bɑ ide iyi ɑ̀ kɔ si tiɑi woodɑ nŋɑ ku kɔ̃ iyi í ni, ɑ̀ cém nɔ ɑ kù mɑ̀ iriò isɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ammɑ ɑn bɛ nŋɛ Hundei Ilɑɑɔ̃ wɑ, nŋui ɑ́ jɔ̀ inɛ ŋɑ ɑ mɑ̀ ntɔu. Nŋui í jɛ Woo muɑ ɡbuɡbɑ̃u, nɔ hɑi bi Ilɑɑɔ̃ Bɑɑbɑi ɑ́ nɑɑ. Bii í to wɑ nŋui ɑ́ jɛ nŋɛ sɛɛdɑm. ");
INSERT INTO mkl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nɔ iŋɛ mɔ ɑɑ jɛɑ inɛ ŋɑ sɛɛdɑm ŋɑ, si nɑ iyi í jɔ̀ ɑwɑòɛ ŋɑi ɑ̀ wɛɛ hɑi wɑɑti iyi ǹ sinti icɛm. ");
INSERT INTO mkl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ide ŋɑu ihɛ̃ fei ǹ sɔ̃ ŋɛi ku bɑ i mɑɑ̀ koosɛ ŋɑ si nɑɑnɛ ku dɑsi nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Aɑ nɑ ɑ ɡɑnji ŋɛ ile bii ɑ̀ yɑ ce kutɔtɔɔ ŋɑ ku bɔ. Nɔ ɑwɑɑti wɑ nɑɑ iyi inɛ ŋɑ ɑɑ kpɑ inɛ ɡɔ nŋɛ ŋɑ, nɔ ɑɑ mɑɑ tɑmɑɑ bɛi Ilɑɑɔ̃i ɑŋɑ ɑ̀ wɑɑ ceɑ icɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Aɑ yɑ mɑɑ ce bɛɛbɛi si nɑ iyi í jɔ̀ ɑ kù mɑ̀m hee mɑ́ jɛ Bɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ǹ wɑ n sɔ̃ ŋɛ ide ŋɑu ihɛ̃i ku bɑ bii ɑwɑɑtiu í to wɑ i ye ɡiɡi ŋɑ iyi ǹ tɑko ǹ sɔ̃ ŋɛ tɑ̃. Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, n kù sɔ̃ ŋɛ ide ŋɑu ihɛ̃ hɑi sinte domi ɑwɑɛ ŋɑi ɑ̀ wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Wee nsɛi ǹ wɑ n bɔ bi inɛ iyi í bɛm wɑ, nɔ bɑɑ inɛ ɑkɑ̃ nŋɛ kù beem iwoi ǹ wɑ n bɔ. ");
INSERT INTO mkl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ammɑ ideu ihɛ̃ iyi ǹ sɔ̃ ŋɛ nŋui í fɔ inɔ nŋɛ kɑɑ kɑɑ, mɑ irei. ");
INSERT INTO mkl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Do nŋu fei, ntɔi ǹ wɑ n sɔ̃ ŋɛ, bii ǹ koo ɑrɑnfɑ̃ɑni nŋɛi. Arɑnfɑ̃ɑni nŋɛi, domi bii ǹ koo ɑn bɛ nŋɛ Woo muɑ ɡbuɡbɑ̃u wɑ, ɑmmɑ bii n kù koo kɑɑ nɑɑ bi tu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wɑɑti iyi ɑ́ to wɑ nŋui ɑ́ nyisi inɛi ɑndunyɑ ŋɑ iyi ɑ̀ jɛ ilu dulum ŋɑ, nɔ ku jɔ̀ inɛ ŋɑ ɑ mɑ̀ mii iyi í jɛ dee dee, nɔ ku jɔ̀ ɑ mɑ̀ iyi Ilɑɑɔ̃ ɑ́ kiiti inɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Á nyisi ŋɑ iyi ɑ̀ jɛ ilu dulum ŋɑ si nɑ iyi í jɔ̀ ɑ kù dɑsim nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Á jɔ̀ ɑ́ mɑ̀ mii iyi í jɛ dee dee si nɑ iyi í jɔ̀ ǹ wɑ n bɔ bi Bɑɑbɑ nɔ i kɑɑ yɛm mɑ́ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nɔ ɑ́ jɔ̀ ɑ mɑ̀ iyi Ilɑɑɔ̃ ɑ́ kiiti inɛ ŋɑ domi í kiiti Seetɑm ilɑɑlui ɑndunyɑ tɑ̃ mɔm. ");
INSERT INTO mkl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ǹ nɛ mii nkpɔ iyi ɑn sɔ̃ ŋɛ mɑ́ ɑmmɑ ideu í re ŋɛ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wɑɑti iyi Hundei ntɔ ɑ́ to wɑ, nŋui ɑ́ jɔ̀ i mɑ̀ ntɔu fei ŋɑ. Kɑɑ fɔ ide do yiikoi nŋu tɑkɑɛ, ide ŋɑ iyi í ɡbɔ do iyi ɑ̀ nɑ ku cei ɑ́ sɔ̃ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nŋui ɑ́ jɔ̀ irim ku nɛ ɑmboe, domi idem nii ɑ́ ɡbɔ ku sisi nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mii iyi Bɑɑbɑ í nɛ fei, tom nii. Ŋɔi í ce ǹ ni Hundei Ilɑɑɔ̃u ɑ́ ɡbɔ idem ku sisi nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesu í sɔ̃ ŋɑ í ni, bii í kɔ̃ɔsi keeke i kɑɑ yɛm mɑ́ ŋɑ, nɔ bii í ce sɑ̃ɑ mɑ́ ɑɑ yɛm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ŋɔi mɔcɔɛ ɡɔ ŋɑ ɑ̀ bee njɛ ɑ̀ wɑɑ ni, yoomɑi í jɛ yɑɑsei ideu bɛ. Í ni bii í kɔ̃ɔsi keeke ɑ kɑɑ kɑ yɛ nŋu nɔ bii í ce sɑ̃ɑ mɑ́ ɑɑ kɑ yɛ nŋu. Yoomɑi í jɛ yɑɑseɛ. Í ni nŋu wɑ bɔ bi Bɑɑi nŋu. Yoomɑi í jɛ yɑɑsei iyi bɛ mɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","To, yoomɑi í jɛ yɑɑsei bii í kɔ̃ɔsi keeke. A kù mɑ̀ ide mii wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Wee Jesu í mɑ̀ iyi ɑ̀ wɑɑ bi ɑ bee nŋu ideu. Ŋɔi í ni, to, ǹ sɔ̃ ŋɛ ǹ ni bii í kɔ̃ɔsi keeke i kɑɑ yɛm mɑ́ ŋɑ, nɔ bii í ce sɑ̃ɑ mɑ́ ɑɑ yɛm ŋɑ, mɑ̀ irei. Ideu bɛi ì wɑɑ bee ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛ, ɑɑ kpɑtɑ i weeweɑ ŋɑ, ɑmmɑ ɑ́ dɔ̃ɑ inɛi ɑndunyɑ ŋɑ si. Aɑ wɛɛ do inɔ kufɔ ŋɑ, ɑmmɑ inɔ kufɔ nŋɛ ɑ́ nɑ ku kpɑɑsi inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Bii inɑɑbo í ɡulɛ wɑ bi ku bí, í yɑ nɛ inɔ ku fɔ si nɑ iyi í jɔ̀ wɑɑtii ɑrɑ kuroɛi í to wɑ. Ammɑ bii í bí ɑmɑu í yɑ ɡbɛjɛ ɑrɑ kuroui domi inɔ didɔ̃ɛ í yɑ lɑ do iyi í bí ɑmɑ si ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bɛɛbɛi iŋɛ mɔ ì wɛɛò inɔ kufɔ si nsɛi ŋɑ. Ammɑ ɑn nɑ n yɛ ŋɛ mɑ́, ɑɑ wɛɛò inɔ didɔ̃ ŋɑ, nɔ inɛ ɡɔ kɑɑ yɔkɔ ku nyɑ inɔ didɔ̃ nŋɛu. ");
INSERT INTO mkl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bii ɑwɑɑtiu í to wɑ, i kɑɑ beem nkɑ̃mɑ ŋɑ. Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, mii iyi ɑɑ tɔɔ Ilɑɑɔ̃ Bɑɑbɑ do irim ŋɑ fei ɑ́ mu nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hee nsɛi i kù tɔɔ nɡɔɡɔ do irim ŋɑ. I tɔɔ, ɑɑ bɑ ŋɑ ku bɑ inɔ didɔ̃ nŋɛ ku kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, ide ŋɑu ihɛ̃ fei nsɛi do mɔndɑi ǹ sɔ̃ ŋɛ. Ammɑ ɑwɑɑti wɑ nɑɑ, iyi n kɑɑ n sɔ̃ ŋɛ ide do mɔndɑ mɑ́. Ide iyi í jɛ idei Bɑɑbɑ ɑn sɔ̃ ŋɛi sɑ̃ɑ sɑ̃ɑ do yɑɑseɛ. ");
INSERT INTO mkl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Bii wɑɑtiu í to wɑ, ɑɑ tɔɔ Bɑɑbɑ do irim ŋɑ. N kɑɑ n sɔ̃ ŋɛ n ni ɑn tɔɔɛ nɑ iri nŋɛ mɑ́, ");
INSERT INTO mkl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","domi Bɑɑbɑ tɑkɑɛ í bi ŋɛ. Í bi ŋɛ si nɑ iyi í jɔ̀ iŋɛ mɔ ì bim, nɔ ì dɑsi nɑɑnɛ ŋɑ iyi hɑi bi tɛɛi ǹ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ntɔi, hɑi bi Bɑɑbɑi ǹ fitɑ wɑ ǹ nɑɑ ɑndunyɑ. Nsɛi ǹ wɑ n jɔ̀ ɑndunyɑ ǹ wɑ n bɔ bi Bɑɑm. ");
INSERT INTO mkl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ŋɔi mɔcɔɛ ŋɑ ɑ̀ sɔ̃ɔ ɑ̀ ni, to, bɛbɛii ì wɑɑ fɔ ide do yɑɑse si nɑ iyi í jɔ̀ mɔndɑ kù wɑ si. ");
INSERT INTO mkl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nsɛi ɑ̀ mɑ̀ iyi ì mɑ̀ fei ndɛɛ, nɔ ì mɑ̀ lɑsɑbui idɔ nwɑ bɑɑ bii ɑ kù beeɛ ide ɡɔ. Ŋɔi í jɔ̀ ɑ̀ dɑsi nɑɑnɛ iyi hɑi bi Ilɑɑɔ̃i ì nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ŋɔi Jesu í jɛ nŋɑ í ni, debɛi ì dɑsi nɑɑnɛ bɛbɛi ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","I ce lɑɑkɑi ŋɑ. Awɑɑti wɑ nɑɑ nɔ í to wɑ tɑ̃ mɔm de, iyi inɛ ŋɑ ɑɑ jɔ̀ iŋɛ fei i fɑnɡɑɑ i jɔ̀ ɑmu ɑkɑ̃ i bɔ kpɑsɛ̃ ŋɑ. Do nŋu fei n kù jɛ ɑmu ɑkɑ̃, domi Bɑɑbɑ í wɛɛ do ɑmu. ");
INSERT INTO mkl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ide ŋɑu ihɛ̃ ǹ wɑ n sɔ̃ ŋɛi ku bɑ i nɛ lɑɑkɑi ku sũ nɑ ɑnu ɑkɑ̃ iyi ɑwɑɛ ŋɑ ɑ̀ nɛ. Si ɑndunyɑu ihɛ̃ ɑɑ yɛ ijuukpɑ̃ ŋɑ, ɑmmɑ i mɑɑ̀ mɔnɡɔ temuɑ ŋɑ, domi ǹ kɑ̃miɑ ɑndunyɑ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iyi Jesu í fɔ bɛɛbɛ í tɑ̃, ŋɔi í wu iju lele í ni, Bɑɑbɑ, ɑwɑɑti í to. Jɔ̀ irii ɑmu Amɑɛ ku nɛ ɑmboe ku bɑ ɑmu mɔ n jɔ̀ titɛɛ ku nɛ ɑmboe, ");
INSERT INTO mkl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","nɔ inɛ ŋɑ iyi ì nɑm fei n mu nŋɑ kuwɛɛ hɑi tɑ̃ si bɛi ì muum yiiko si inɛ fei. ");
INSERT INTO mkl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kuwɛɛ hɑi tɑ̃ui í jɛ inɛ ŋɑ ɑ mɑ̀ɛ, ɑwɔ Ilɑɑɔ̃ ɑkɑ̃ ilu ntɔu, nɔ ɑ mɑ̀m, ɑmu Jesu Kirisi iyi ì bɛ wɑu. ");
INSERT INTO mkl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ǹ jɔ̀ iriɛ í nɛ ɑmboe si ilɛu ihɛ̃, nɔ icɛ ŋɑ iyi í dɑsim ku ceu fei ǹ coo. ");
INSERT INTO mkl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bɑɑbɑ, nsɛi ǹ wɑ n tɔɔɛi, jɔ̀ n nɛ ɑmboe bi tɛɛ bɛi ǹ tɑko ǹ nɛ wo hee ɑ mɑɑ tɑkɑ ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Inɛ ŋɑ iyi ì cicɑ hɑi si ɑndunyɑ ì nɑm, ǹ jɔ̀ ɑ̀ mɑ̀ɛ. Tɛɛi ɑ̀ jɛ wo, nɔ ì so ŋɑ ì nɑm. À nɔ ɑ̀ wɑɑ jirimɑ ideɛ. ");
INSERT INTO mkl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nsɛi ɑ̀ mɑ̀ mii iyi ì nɑm fei, hɑi bi tɛɛi í nɑɑ, ");
INSERT INTO mkl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","domi ide ŋɑ iyi ì sɔ̃m nŋui ɑmu mɔ ǹ sɔ̃ ŋɑ, nɔ ɑ̀ ɡbɑ ideu. À mɑ̀ iyi ntɔ ntɔ hɑi bi tɛɛi ǹ nɑɑ nɔ ɑ̀ dɑsi nɑɑnɛ iyi ɑwɔi ì bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ǹ wɑ n tɔɔɛ nɑ iri nŋɑ. Kù jɛ nɑ irii inɛi ɑndunyɑ ŋɑi ǹ wɑ n tɔɔɛ, ɑmmɑ nɑ inɛ ŋɑ iyi ì nɑm ŋɑi, domi ɑŋɑi ɑ̀ jɛ tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mii iyi ǹ nɛ fei tɛɛi, nɔ mii iyi ɑwɔ mɔ ì nɛ fei tom nii, nɔ irim í nɛ ɑmboe nɑ iri nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nsɛi ǹ wɑ n nyi wɑ bi tɛɛ. Bii í kɔ̃ɔsi keeke n kɑɑ n mɑɑ n wɑ si ɑndunyɑ mɑ́, ɑŋɑi ɑɑ mɑɑ wɑ si ɑndunyɑu. Bɑɑbɑ kumɑ́, deɡbe ŋɑ do ɡbuɡbɑ̃i iriɛ iyi ì nɑm, ku bɑ ɑ jɛ ɑkɑ̃ si bɛi ɑwɑɛ ɑ̀ jɛ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wɑɑti iyi ǹ wɛɛ do ɑŋɑ ǹ deɡbe ŋɑ do ɡbuɡbɑ̃i iriɛ, iri iyi ì nɑm nɔu. Ǹ deɡbe ŋɑ nɔ si inɔ nŋɑ bɑɑ inɛ ɑkɑ̃ kù ce nfe, bii kù jɛ ɑmɑi nfeu bɑɑsi. Bɛɛbɛi kukɔi ideɛ í kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nsɛi ǹ wɑ n nyi wɑ bi tɛɛ. Ide ŋɑu ihɛ̃ si ɑndunyɑu ihɛ̃i ǹ wɑ n fɔɔ, ku bɑ ɑŋɑ mɔ ɑ kɔ̃ò inɔ didɔ̃ nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ǹ nɑ ŋɑ ideɛ, nɔ inɛi ɑndunyɑ ŋɑ ɑ̀ cé ŋɑ si nɑ iyi í jɔ̀ ɑ kù jɛ ti ɑndunyɑ, si bɛi ɑmu mɔ n kù jɛ ti ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","N kù wɑ n tɔɔɛ i nyɑ ŋɑ hɑi si ɑndunyɑ, ɑmmɑ ǹ wɑ n tɔɔɛi i deɡbe ŋɑ ku bɑ Seetɑm inɛ lɑɑlɔu ku mɑɑ̀ nɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","A kù jɛ ti ɑndunyɑ si bɛi ɑmu mɔ n kù jɛ ti ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ideɛi í jɛ ntɔ. Jɔ̀ ideɛu ku nyɑ ŋɑ ikɑ̃ ɑ jɛ titɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ǹ bɛ ŋɑi si ɑndunyɑ si bɛi ɑwɔ mɔ ì bɛm si ɑndunyɑu. ");
INSERT INTO mkl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nɑ iri nŋɑi ǹ so ɑrɑm ǹ nɑɛ ku bɑ ɑŋɑ mɔ ɑ jɛ titɛɛ mɑm mɑm. ");
INSERT INTO mkl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kù jɛ ɑŋɑ ɑkɑ̃i ǹ wɑ n ceɑ kutɔɔ, ɑmmɑ do inɛ ŋɑ mɔ iyi ɑɑ nɑ ɑ dɑsim nɑɑnɛ nɑ sɑɑbui ide nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ǹ wɑ n tɔɔɛi ɑŋɑ fei ɑ jɛ ɑkɑ̃. Si bɛi ɑwɔ Bɑɑbɑ ì wɑ sim, nɔ ɑmu mɔ ǹ wɑ siɛ, jɔ̀ ɑ jɛ ɑkɑ̃ si wɑ ku bɑ inɛi ɑndunyɑ ŋɑ ɑ dɑsi nɑɑnɛ iyi ɑwɔi ì bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Amboeɛ iyi ì jɔ̀ inɛ ŋɑ ɑ̀ yɛ sim, nŋui ǹ jɔ̀ ɑ̀ wɑɑ yɛ si ɑŋɑ mɔ ku bɑ ɑŋɑ mɔ ɑ jɛ ɑkɑ̃ bɛi ɑwɑɛ ɑ̀ jɛ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jɔ̀ n wɑ si ŋɑ nɔ ɑwɔ mɔ i wɑ sim ku bɑ ɑ jɛ ɑkɑ̃ mɑm mɑm, nɔ inɛi ɑndunyɑ ŋɑ ɑ mɑ̀ iyi ɑwɔi ì bɛm wɑ nɔ ì bi ŋɑi bɛi ì bim. ");
INSERT INTO mkl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bɑɑbɑ, ǹ bi inɛ ŋɑ iyi ì nɑm ɑ mɑɑ wɑ bi tom bii ɑn wɑ, ku bɑ ɑ yɛ ɑmboem, ɑmboe iyi ì muum. Ì muum ɑmboeui si nɑ iyi í jɔ̀ ì bim hɑi wɑɑti iyi ɑ kù tɑkɑ ɑndunyɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bɑɑbɑ ɑwɔ iyi ì jɛ dee dee, bɑɑ do iyi inɛi ɑndunyɑ ŋɑ ɑ kù mɑ̀ɛ, ɑmu ǹ mɑ̀ɛ, nɔ inɛ ihɛ̃ ŋɑ mɔ ɑ̀ mɑ̀ iyi ɑwɔi ì bɛm wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ǹ jɔ̀ ɑ̀ mɑ̀ɛ, nɔ ɑn kɔ̃ɔ nŋɑ si kumɑ̀ɛ mɑ́ ku bɑ kubi iyi ì bim ku wɑ si ŋɑ, nɔ ɑmu mɔ n wɑ si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iyi Jesu í ce kutɔɔɛ í tɑ̃, ŋɔi í fitɑ, nŋu do mɔcɔɛ ŋɑ ɑ̀ bɔ lɑmbo ɡɔ iyi í wɑ icei ido iyi ɑ̀ yɑ kpe Sedorɔ̃ɔ. Ŋɔi í lɔ bɛ, nŋu do mɔcɔɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Wee Zudɑsi inɛ iyi ɑ́ zɑmbɑɛu mɔ í mɑ̀ inyɑu, domi ɑŋɑò ŋɑ ɑ̀ yɑ koo bɛ isɛ fɛɛfɛlo. ");
INSERT INTO mkl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ŋɔi í jɔ̀ Zudɑsi í bɔ bɛ do sooɡe ŋɑ do woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑ iyi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do Fɑrisi ŋɑu ɑ̀ bɛ wɑu. À wɑɑ mu jĩnɛi iɡũ nŋɑ do fitilɑ ŋɑ do inɑ juɡulɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesu í bɛi wɑ mɑ̀ mii ŋɑ iyi ɑ́ bɑ nŋu fei. Iyi ɑ̀ to wɑ ŋɔi í sɛkɛɛ si ŋɑ í bee ŋɑ í ni, yooi ì wɑɑ dɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, Jesu inɛi Nɑzɑrɛtiui ɑ̀ wɑɑ dɛdɛ. Ŋɔi Jesu í ni, ɑmui ihɛ̃ mɛɛ. Wee Zudɑsi inɛ iyi ɑ́ zɑmbɑɛu, wɑ leekĩ bɛ ɑŋɑò ŋɑ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iyi Jesu í jɛ nŋɑ í ni, ɑmui ihɛ̃, ŋɔi ɑŋɑ fei ɑ̀ sɛkɛɛ do ɑnyi ɑ̀ koo ɑ̀ cuku ilɛ. ");
INSERT INTO mkl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ŋɔi Jesu í bee ŋɑ mɑ́ í ni, yooi ì wɑɑ dɛ ŋɑ. Ŋɔi ɑ̀ ni, Jesu inɛi Nɑzɑrɛtiui ɑ̀ wɑɑ dɛdɛ. ");
INSERT INTO mkl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nɔ Jesu í ni, ǹ sɔ̃ ŋɛ tɑ̃ ǹ ni ɑmui ihɛ̃. To, bii ɑmui ì wɑɑ dɛdɛ ŋɑ i jɔ̀ inɛ ŋɑ iyi ɑ̀ ɡbeu ɑ nɛ. ");
INSERT INTO mkl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Bɛɛbɛi ide iyi í tɑko í fɔu í kɔ̃ iyi í ni, Bɑɑbɑ, inɛ ŋɑ iyi ì nɑm fei bɑɑ inɛ ɑkɑ̃ nŋɑ kù ce nfe. ");
INSERT INTO mkl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Wee Simɔɔ Piɛɛ í nɛ tɑɑkubɑ. Ŋɔi í yɔɔ í cɑfeò itĩ njɛi woo ce icɛi woo wee nlɑi Ilɑɑɔ̃u. Irii woo ce icɛui Mɑlikusu. ");
INSERT INTO mkl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ammɑ Jesu í sɔ̃ Piɛɛ í ni, sindo tɑɑkubɑɛ si ɑnkɔ̃ɔɛ. Ì wɑɑ tɑmɑɑ n kɑɑ n temuɑò ijuukpɑ̃ iyi Bɑɑbɑ í jilɛɛm nii? ");
INSERT INTO mkl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ŋɔi sooɡe ŋɑ do inɛ nɡbo nŋɑ do Zuifu woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu ɑ̀ mu Jesu ɑ̀ dũu. ");
INSERT INTO mkl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nɔ ɑ̀ tɑko ɑ̀ bɔòɛ bi Ani titɑ̃. Wee Aniu wɑ jɛ bɑɑi ɑboi Kɑifu, iyi í jɛ woo wee nlɑi Ilɑɑɔ̃ si ɑdɔ̃ nŋu. ");
INSERT INTO mkl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nɔ Kɑifu í sɔ̃ Zuifu kpɑɑsiɛ ŋɑu ideu ihɛ̃ wo í ni, ɑrɑnfɑ̃ɑni nwɑi inɛ ɑkɑ̃ ku ku si ɑɡbɛi dimi nwɑ. ");
INSERT INTO mkl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Wɑɑti iyi ɑ̀ mu Jesu ɑ̀ wɑɑ nɛɛ ŋɔi Simɔɔ Piɛɛ do mɔcɔ mmu ɡɔ ɑ̀ wɑɑ tooɛ. Wee woo wee nlɑi Ilɑɑɔ̃u í mɑ̀ mɔcɔ inɛ nŋu, ŋɔi í jɔ̀ mɔcɔu í bɑ í too Jesu í lɔò bɑntumɑi kpɑsɛ̃i woo wee nlɑu. ");
INSERT INTO mkl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ammɑ Piɛɛ í ɡbe wɑduude ɑndɛ koofɑ bɛ. Nɔ mɔcɔ iyi woo wee nlɑu í mɑ̀u, í fitɑ wɑ í nɑɑ í bɑ mudɛ̃ɛ iyi wɑ deɡbe koofɑu ide ku fɔ, nɔ í jɔ̀ Piɛɛ í lɔ. ");
INSERT INTO mkl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nɔ mudɛ̃ɛu í bee Piɛɛ í ni, kù jɛ ɑwɔ mɔ inɛ ɑkɑ̃i mɔcɔi mɔkɔui yɑ. Ŋɔi Piɛɛ í ni, ɑɑwo, kù jɛ ɑmu. ");
INSERT INTO mkl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Si bɛi tũtũ wɑ ceu, ŋɔi woo ce icɛ ŋɑ do woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu ɑ̀ leekĩ kɔkɔi inɑ nyɛnyɛ ɑ̀ wɑɑ nyiɑ. Nɔ Piɛɛ mɔ í koo wɑ nyiɑ bi tu ŋɑ bɛ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ŋɔi woo wee nlɑi Ilɑɑɔ̃u í bee Jesu idei mɔcɔɛ ŋɑ do yɑɑsei cio iyi wɑ kɔ si. ");
INSERT INTO mkl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ŋɔi Jesu í jɛɑɑ í ni, ideu si bɑntumɑi ǹ sɔ̃ inɛ fei. Ǹ yɑ n kɔ inɛ ŋɑ si ciom nii ile bii ɑ̀ yɑ ce kutɔtɔɔ ŋɑ do si kpɑsɛ̃i Ilɑɑɔ̃, bii Zuifu ŋɑ fei ɑ̀ yɑ tɔtɔɔ. N kù fɔ ide kɑ̃mɑ si ɑsii. ");
INSERT INTO mkl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nɑ mii í ce ì wɑɑ beem ide. Inɛ ŋɑ iyi ɑ̀ ɡbɔ idem, bee ɑŋɑ tɑkɑ nŋɑ iyi ǹ sɔ̃ ŋɑ, ɑŋɑi ɑɑ mɑ̀ mii iyi ǹ fɔ. ");
INSERT INTO mkl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iyi Jesu í fɔ bɛɛbɛ, ŋɔi inɛ ɑkɑ̃i woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu í sɑmbɑlɑɛ í ni, woo wee nlɑui ì wɑɑ jɛɑɑ ide nfe nfe bɛɛbɛ? ");
INSERT INTO mkl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ŋɔi Jesu í jɛɑɑ í ni, bii ide lɑɑlɔi ǹ fɔ, fɔɔ inɛ fei ku ɡbɔ. Ammɑ bii í jɛ ide jiidɑ mɔi ǹ fɔ, nɑ mii í ce ì wɑɑ sɑmbɑlɑm. ");
INSERT INTO mkl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nɔ Ani í jɔ̀ ɑ̀ dũu ɑ̀ bɔòɛ bi Kɑifu, woo wee nlɑu. ");
INSERT INTO mkl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Wɑɑti iyi Simɔɔ Piɛɛ í wɑ bɛ wɑ nyiɑ inɑu ŋɔi ɑ̀ beeɛ ɑ̀ ni, kù jɛ ɑwɔ mɔ inɛ ɑkɑ̃i mɔcɔi mɔkɔui yɑ. Ŋɔi Piɛɛ í jɑ̃ í ni, ɑɑwo, kù jɛ ɑmu. ");
INSERT INTO mkl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wee woo ce icɛ ɑkɑ̃i woo wee nlɑi Ilɑɑɔ̃u í wɑ bɛ. Wɑ jɛ nyɑɑnzei inɛ iyi Piɛɛ í bu itĩɛu. Iyi í yɛ Piɛɛ ŋɔi í beeɛ í ni, n kù yɛɛ iŋɛò lɑmbo bɛi? ");
INSERT INTO mkl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ammɑ Piɛɛ í jɑ̃ mɑ́ í ni, ɑɑwo. Gbɑkɑ̃ ŋɔi ɑjɛɛ wɑ kɔ. ");
INSERT INTO mkl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hɑi bi Kɑifu bɛ, inɛ nɡboi Zuifu ŋɑu ɑ̀ bɔò Jesu bi ku kiitii ilu ilɛu bii Pilɑti í wɑ. Wee dɑɑdɑɑkɔi. Aŋɑ tɑkɑ nŋɑ ɑ kù lɔ ile bi ku ce kiitiu ku bɑ ɑŋɑ ɑ mɑɑ̀ nɑ ɑ jɛ ilu riisi ŋɑ. A kù bi ɑ jɛ ilu riisi domi ɑ̀ wɑɑ bi ɑ bɑ ɑ jɛ ijɛi jinɡɑui Iku ku kuɑu. ");
INSERT INTO mkl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nŋui í jɔ̀ Pilɑti í fitɑ wɑ í nɑɑ í bɑ ŋɑ í bee ŋɑ í ni, tɑɑle yoomɑi ì yɛ si mɔkɔu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ŋɔi ɑ̀ ni, bii kù ce lɑɑlɔ, ɑ kɑɑ kɑ dɑɛ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ŋɔi Pilɑti í sɔ̃ ŋɑ í ni, iŋɛ tɑkɑ nŋɛ i kooɛ i koo i kiiti do woodɑ nŋɛ. Ammɑ ɑ̀ ni, iŋɛ inɛi Romu ŋɑ i kù nɑ wɑ kpɑ̃ɑ iyi ɑɑ kɑ kpɑò ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bɛɛbɛi idei Jesu í ce ku nyisiò dimii iku iyi ɑ́ ku. ");
INSERT INTO mkl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ŋɔi Pilɑti í lɔ ile bi ku ce kiitiu mɑ́ í kpe Jesu í beeɛ í ni, ɑwɔi ì jɛ ilɑɑlui Zuifu ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ŋɔi Jesu í ni, inɛ ɡɔi í sɔ̃ɛ bɛɛbɛ de, mɑ̀ ì nɔ ì wɑɑ beei. ");
INSERT INTO mkl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ammɑ Pilɑti í ni, ɑmuu Zuifui ǹ bɛi ǹ mɑ̀? Dimiɛ ŋɑ do inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑi ɑ̀ muɛ ɑ̀ dɑɑm si ɑwɔ. Mii ì ce. ");
INSERT INTO mkl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ŋɔi Jesu í jɛɑɑ í ni, bommɑm kù jɛ ti ɑndunyɑ. Bii í jɛ ti ɑndunyɑi, woo ce icɛm ŋɑ ɑɑ jɑ, ɑ kɑɑ jɛ ɑ mum ɑ nɑ inɛ nɡboi Zuifu ŋɑu. Ammɑ bommɑm kù jɛ ti ɑndunyɑ ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ŋɔi Pilɑti í beeɛ í ni, debɛi, ɑwɔu ilɑɑlui? Ŋɔi Jesu í jɛɑɑ í ni, ɑwɔi ì fɔ bɛɛbɛ. Ǹ nɑɑi si ɑndunyɑ, ɑ̀ bím nii n jɛ sɛɛdɑi ntɔ. Inɛ iyi í jɛ ti ntɔ fei ɑ́ ɡbɔ idem. ");
INSERT INTO mkl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nɔ Pilɑti í beeɛ í ni, dimii mii mɔm nii ɑ̀ yɑ kpe ntɔ. Si ɑnyii ide ŋɑu ŋɔi Pilɑti í fitɑ mɑ́ í bɔ bi Zuifu ŋɑu. Í sɔ̃ ŋɑ í ni, ɑmu n kù yɛ tɑɑle kɑ̃mɑ si mɔkɔu. ");
INSERT INTO mkl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ammɑ si bɛi ɑ̀ nɛ dɔɔnɛɛ, ɑn jɔ̀ nŋɛ inɛi piisɔ̃ɔ ɑkɑ̃ si jinɡɑui Iku ku kuɑ. Ì bi n jɔ̀ nŋɛ ilɑɑlui Zuifu ŋɑu? ");
INSERT INTO mkl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ŋɔi ɑŋɑ fei ɑ̀ wɑsi ku dɔ̃ ɑnu do ɡbuɡbɑ̃ ɑ̀ wɑɑ ni ɑŋɑ ɑ kù bi mɔkɔu bɛ. À wɑɑ ni Bɑrɑbɑsii ɑŋɑ ɑ̀ bi. Wee Bɑrɑbɑsiu í yɑ ce ilei. ");
INSERT INTO mkl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ŋɔi Pilɑti í jɔ̀ ɑ̀ cɑ̃ Jesu do kpɔtɔɔ. ");
INSERT INTO mkl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ŋɔi sooɡe ŋɑ ɑ̀ bɑ fulɑi ɑɡũ ɑ̀ dɑɑ Jesu si iriɛ, nɔ ɑ̀ dɑɑ si kumboo nkpɑ ɡɔ mɑ́ ɑ̀ wɑɑ yɑɑkoɛò. ");
INSERT INTO mkl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ŋɔi ɑ̀ yɑ sɛkɛɛ siɛ wɑ ɑ̀ nɑɑ ɑ mɑɑ coo fɔɔ ɑ mɑɑ ni, fɔɔ ilɑɑlui Zuifu ŋɑ. Nɔ ɑ mɑɑ sɑmbɑlɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ŋɔi Pilɑti í fitɑ wɑ mɑ í sɔ̃ zɑmɑɑu í ni, wee ɑn fitɑò nŋɛ mɔkɔu wɑ ku bɑ i mɑ̀ ŋɑ iyi n kù yɛ siɛ kurɑrɑ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ŋɔi í fitɑò Jesu wɑ do fulɑi ɑɡũu do kumboo nkpɑɛ. Ŋɔi Pilɑti í sɔ̃ ŋɑ í ni, mɔkɔu wee. ");
INSERT INTO mkl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Iyi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu ɑ̀ yɔɔ ŋɔi ɑ̀ wɑsi ku lɑ ɑ̀ wɑɑ ni, kpɑkpɑɛ si jĩi. Ŋɔi Pilɑti í sɔ̃ ŋɑ í ni, iŋɛ tɑkɑ nŋɛ, i ɡbɑ i kpɑkpɑɛ si jĩi ku ɡɑɑu. Ammɑ ɑmu n kù yɛ siɛ tɑɑle ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ŋɔi Zuifu ŋɑu ɑ̀ sɔ̃ɔ ɑ̀ ni ɑŋɑ ɑ̀ nɛ woodɑ ɡɔ, nɔ si woodɑi ɑŋɑu í ɡbe de ɑ kpɑɑi domi wɑ ni nŋuu ɑmɑi Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Iyi Pilɑti í ɡbɔ ideu, njo í muu mɑ́ hee í cɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ŋɔi í bɔò Jesu bi ku ce kiitiu mɑ́ í koo í beeɛ í ni, hɑi iwoi ì wɑɑ nɑɑ ntɔ ntɔ. Ammɑ Jesu kù jɛɑɑ mɔm. ");
INSERT INTO mkl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ŋɔi Pilɑti í beeɛ í ni, bɑɑ ɑmu tɑkɑm i kɑɑ bɑm ide ku fɔ? I kù mɑ̀ iyi ǹ nɛ kpɑ̃ɑ n jɔ̀ɛ, nɔ ǹ nɛ kpɑ̃ɑ mɑ́ n kpɑkpɑɛ si jĩi ku ɡɑɑui? ");
INSERT INTO mkl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ŋɔi Jesu í jɛɑɑ í ni, i kɑɑ nɛ ɡbuɡbɑ̃ kɑ̃mɑ sim, bii kù jɛ Ilɑɑɔ̃i í nɑɛ wɑ. Nŋui í jɔ̀ inɛ iyi í dɑsim si ɑwɔɛ, dulum dɛɛ í re bɑɑ tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Iyi Pilɑti í ɡbɔ bɛɛbɛ, ŋɔi wɑ ce kookɑɑi ku bɑ ku jɔ̀ɔ. Ammɑ Zuifu ŋɑu ɑ̀ dɔ̃ ɑnu ɑ̀ wɑɑ ni, bii ì jɔ̀ mɔkɔu bɛ, i kù jɛ kpɑɑsii ilɑɑlu nlɑi Romu mɑ́. Inɛ iyi í ce ɑrɑɛ ilɑɑlu fei mbɛɛi ilɑɑlu nlɑi Romuui í bɑɑ í jɛ. ");
INSERT INTO mkl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Iyi Pilɑti í ɡbɔ ideu, ŋɔi í jɔ̀ ɑ̀ fitɑò Jesu nɔ í bubɑ si kitɑ̃i woo kiitiu iyi í wɑ inyɑ bii ɑ̀ yɑ kpe Tintim ndii kutɑ. Ammɑ do fee Ebɛɛ, Gɑbɑtɑi ɑ̀ yɑ kpe inyɑu. ");
INSERT INTO mkl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Wee ɑ̀ wɑ si ɑjɔ iyi bii iju í mɑ́ ɑ́ jɛ ɑjɔi kusĩmi. Ajɔi kusĩmiu ɑlɛi ɑ́ sinti, nɔ inɛ ŋɑ ɑ̀ wɑsi ku ce sɔɔlui jinɡɑui Iku ku kuɑu. Nɔ wɑɑti bɛɛbɛ zɑkɑi dɑsɑ̃i. Ŋɔi Pilɑti í sɔ̃ Zuifu ŋɑu í ni, ilɑɑlu nŋɛ wee. ");
INSERT INTO mkl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ammɑ ɑ̀ wɑsi ku dɔ̃ ɑnu ɑ̀ wɑɑ ni, kpɑɑ. Kpɑkpɑɛ si jĩi ku ɡɑɑu. Ŋɔi Pilɑti í bee ŋɑ í ni, bɛirei í ce ì bi n kpɑkpɑ ilɑɑlu nŋɛ si jĩi ku ɡɑɑu. Ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu ɑ̀ jɛɑɑ ɑ̀ ni, ɑ kù nɛ ilɑɑlu mmu ɡɔ bii kù jɛ ilɑɑlu nlɑi Romu. ");
INSERT INTO mkl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ŋɔi Pilɑti í dɑ nŋɑ Jesu si ɑwɔ ku bɑ ɑ kpɑkpɑɛ si jĩi ku ɡɑɑu. Nɔ ɑ̀ mu Jesu ɑ̀ nɛò. ");
INSERT INTO mkl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nɔ ɑ̀ kɑ̃ɑ Jesu jĩi ku ɡɑɑuu í so í fitɑò hɑi inɔ ilu í bɔò hee inyɑ iyi ɑ̀ yɑ kpe inyɑi kokoi iri. Do feei Ebɛɛ, Gɔɔɡɔtɑi ɑ̀ yɑ kpe inyɑu. ");
INSERT INTO mkl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bɛi ɑ̀ kpɑkpɑɛ si jĩi ku ɡɑɑuu. Nɔ ɑ̀ kpɑkpɑ inɛmɔkɔ minji ɡɔ ŋɑ bɛ mɑ́, inɛ ɑkɑ̃ do ɑwɔ cɑnɡɑɛ, inɛ ɑkɑ̃ mɔ do ɑwɔ njɛɛ nɔ Jesu í wɑ ɑnini nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ŋɔi Pilɑti í jɔ̀ ɑ̀ kɔ ide ɡɔ si jĩi ɡɔ ɑ̀ mɑsi ɑntɑi jĩi ku ɡɑɑuu. Kukɔu í ni, Jesu inɛi Nɑzɑrɛti, ilɑɑlui Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Zuifu nkpɔ í kɑ kukɔu domi inyɑu kù jĩò inɔ ilu. Nɔ ɑ̀ kɔɔ do feei Ebɛɛ do Lɑtɛ̃ɛ do Gɛrɛki. ");
INSERT INTO mkl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu ɑ̀ sɔ̃ Pilɑti ɑ̀ ni, mɑɑ̀ ti i kɔ i ni, ilɑɑlui Zuifu ŋɑ, ɑmmɑ kɔ i ni, í ni nŋu í jɛ Ilɑɑlui Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ŋɔi Pilɑti í ni, iyi ǹ kɔ tɑ̃ ǹ kɔɔi. ");
INSERT INTO mkl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Iyi sooɡe ŋɑu ɑ̀ kpɑkpɑ Jesu ɑ̀ tɑ̃ ŋɔi ɑ̀ so jɑɑɛɛ ŋɑ ɑ̀ kpɔ̃ɔ ikɔ mɛɛ, sooɡe fei í so ikɔ ɑkɑ̃ ɑkɑ̃. Nɔ ɑ̀ so ibɔ sisɔɛu mɑ́. Ibɔu kù nɛ ɑɡbɛi ku sɔ domi ɑ̀ wɔ̃ɔi hɑi lele hee ku bɔ ilɛ. Iyi ɑ̀ so ibɔu ");
INSERT INTO mkl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ŋɔi ɑ̀ ni, kɑ mɑɑ̀ ɡɑ ibɔu, ɑmmɑ kɑ tɑ si kpɑsɑ kɑ cɔ ti inɛ iyi ɑ́ jɛ. Nɔ bɛɛbɛi ɑ̀ ce. Bɛɛbɛi kukɔi idei Ilɑɑɔ̃ í kɔ̃ tenɡi bii í ni, ɑŋɑ duusɔ̃ɔ ɑ̀ kpɛ̃ jɑɑɛm ŋɑ. Nɔ ɑ̀ tɑ si ibɔ nlɑm kpɑsɑ. ");
INSERT INTO mkl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Wee iyei Jesu do ifɔi iyeɛ, do Mɑɑri ɑboi Kopɑ, do Mɑɑri inɛi Mɑdɑlɑ, ɑ̀ wɑɑ leekĩ bi jĩi ku ɡɑɑui Jesu. ");
INSERT INTO mkl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ŋɔi Jesu í yɛ iyeɛ bɛ, do mɔcɔ iyi í biu ɑ̀ wɑɑ leekĩ kɔkɔi njɛ, nɔ í sɔ̃ iyeɛ í ni, ɑbooyi, inɛ ihɛ̃i í bɑɑ í jɛ bɛi ɑmɑɛ. ");
INSERT INTO mkl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ŋɔi í sɔ̃ mɔcɔu í ni, ɑbou ihɛ̃ bɛi iyeɛi í bɑɑ í jɛ. Hɑi ɑjɔ nŋui mɔcɔu í ɡbɑ̃ɑ í bɔòɛ kpɑsɛ̃ɛ wɑ woo. ");
INSERT INTO mkl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Si ɑnyii nŋu, si bɛi Jesu í mɑ̀ iyi bɛbɛi fei ndɛɛ í kpɑ iri mbɛ, ŋɔi í ni, ɑɡbɛ wɑ kpɑm. Í fɔ bɛɛbɛi ku bɑ kukɔi idei Ilɑɑɔ̃ ku kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wee cɑkɑ ɡɔ í wɑ bɛ í nɛ ɑtɛ̃ kukɑ̃ bɑm bɑm. Ŋɔi ɑ̀ dĩ kɑnyɑ si ɑmɑɑwɔi jĩi ɡɔ ɑ̀ sɔsi ɑtɛ̃ kukɑ̃u ɑ̀ wɑɑ too si ɡɛlɛi Jesu. ");
INSERT INTO mkl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iyi Jesu í tiɛ ɑtɛ̃ kukɑ̃u ŋɔi í ni, ǹ kpɑ irii icɛm nii mbɛ. Nɔ í kɔmbɑ iriɛ í ku. ");
INSERT INTO mkl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Si bɛi ɑ̀ wɑ si sɔɔlui ɑjɔi kusĩmiu, Zuifu ŋɑu ɑ kù wɑɑ bi ɑjɔu ku to wɑ ku bɑ iku ŋɑu si jĩi ŋɑu bɛ, domi ɑjɔu ɑjɔ nlɑ ɡɔi. Nŋui í jɔ̀ ɑ̀ koo ɑ̀ tɔɔ Pilɑti ku jɔ̀ ɑ cɛ kutɛi inɛ ŋɑ iyi ɑ̀ kpɑkpɑ ŋɑu, nɔ ɑ nyɑ ŋɑ hɑi bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nɑ ŋɔi í ce sooɡe ŋɑu ɑ̀ cɛ kutɛi inɛ sinteu do inɛ minjisiɑu, ɑŋɑ iyi ɑ̀ kpɑkpɑ do Jesu ɑjɔu. ");
INSERT INTO mkl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ammɑ wɑɑti iyi ɑ̀ to bi Jesu, ɑ̀ bɑ í ku tɑ̃, nɔ ɑ kù cɛ kutɛɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ammɑ inɛ ɑkɑ̃i sooɡe ŋɑu í ɡũ kpɑkpɑɑ cinɡɑɛ do kɑkɑ, ŋɔi ɡbɑkɑ̃ njɛ do inyi wɑ jo wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Amu Zɑ̃ɑ ǹ yɛ iyi bɛ fei, nɔ ǹ wɑ n jɛɑ inɛ ŋɑ sɛɛdɑɛ, sɛɛdɑm nɔu ntɔi. Ǹ mɑ̀ kɑm kɑm iyi ntɔi ǹ wɑ n fɔ, nɔ ǹ wɑ n fɔi ku bɑ iŋɛ mɔ i dɑsi nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","A kù cɛ kutɛɛ ŋɑ nɔ iyi bɛ í cei ku bɑ kukɔi idei Ilɑɑɔ̃ ku kɔ̃ iyi í ni, bɑɑ kũkũ ɑkɑ̃ɛ kɑɑ lɛɡɛ. ");
INSERT INTO mkl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nɔ kukɔi idei Ilɑɑɔ̃ í ni mɑ́, ɑɑ cɔ inɛ iyi ɑŋɑ tɑkɑ nŋɑ ɑ̀ ɡũu. ");
INSERT INTO mkl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Si ɑnyii nŋu, Zozɛfu inɛi Arimɑteeu í koo í tɔɔ Pilɑti ku jɔ̀ nŋu ku nyɑ ikui Jesu. Wee Zozɛfu mɔ mɔcɔi Jesui, ɑmmɑ si ɑsiii, domi wɑ ce njoi inɛ nɡboi Zuifu ŋɑ. Nɔ Pilɑti í jɛɑɑ si. Nɑ ŋɔi í jɔ̀ Zozɛfu í koo í nyɑ ikui Jesuu. ");
INSERT INTO mkl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛmu iyi í bɔ bi Jesu idũ ɡɔ wo, í si Zozɛfu. Nɔ wɑ mu tulɑre dimi ikɑ̃ ikɑ̃ minji, ɑkɑ̃ mirui ɑ̀ yɑ kpoo, ɑkɑ̃ mɔ ɑloɛ. Kuwoɛ í to zɑkɑi kilo kuntɑɑ. ");
INSERT INTO mkl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inɛ minji ŋɑu ɑ̀ so ikui Jesu ɑ̀ woo do jɑɑɛ fũfũ ɡɔ ŋɑ nɔ ɑ̀ fɑ̃si tulɑreu. Si dɔɔnɛi Zuifu ŋɑ bɛɛbɛi ɑ̀ yɑ ce bii ɑ̀ wɑɑ si iku. ");
INSERT INTO mkl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lɑmbo ɡɔ í wɑ tenɡi bii ɑ̀ kpɑkpɑ Jesu si jĩi nɔu. Si inɔ lɑmbou ɑ̀ ɡbe isɑi kutɑ ɡɔ bɛ kù kpɛ titɑ̃, nɔ ɑ kù si inɛ ɡɔ si bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bɛi ɑ̀ koo ɑ̀ si Jesu si nɑ iyi í jɔ̀ tenɡi bɛ kù jĩ, nɔ ɑ̀ bi ɑ suu ɡbɑ̃ɑ ɡbɑ̃ɑ hee ɑjɔi kusĩmiu ku mɑɑ to wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ajɔ ɑmɑɑzumɑ dɑɑdɑɑkɔ wɑɑti iyi iju kù mɑ́ sɑ̃ɑ sɑ̃ɑ, ŋɔi Mɑɑri inɛi Mɑdɑlɑu í bɔ bi bɑlɛu. Nɔ í bɑ wee ɑ̀ tɑle kutɑu hɑi ɑndɛ bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ŋɔi í sɛi í bɔ bi Simɔɔ Piɛɛ do bi mɔcɔ iyi Jesu í bi jiidɑu, í sɔ̃ ŋɑ í ni, ɑ̀ nyɑ ikui Lɑfɛ̃ɛ hɑi inɔ bɑlɛ nɔ ɑ kù mɑ̀ bii ɑ̀ dɑsi. ");
INSERT INTO mkl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ŋɔi Piɛɛ do mɔcɔu ɑ̀ fitɑ ɑ̀ bɔ bi bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Aŋɑ minji fei ɑ̀ sɛi ɑjɔ, ɑmmɑ mɔcɔu í sɛi í cuɑ Piɛɛ, nŋui í tɑko í to bi bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nɔ í bɑte í nɑnte si bɑlɛu, nɔ í yɛ jɑɑɛ ŋɑu wɑ jilɛ, ɑmmɑ kù lɔ. ");
INSERT INTO mkl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ŋɔi Simɔɔ Piɛɛ wɑ bɑɑ do ɑnyi. Iyi í to wɑ nɔ í lɔ inɔ bɑlɛu. Nɔ í yɛ jɑɑɛ ŋɑu wɑ jilɛ, ");
INSERT INTO mkl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","do mɑnɡo iyi ɑ̀ tɑko ɑ̀ dĩò iriɛu. Ammɑ mɑnɡou kù wɑɑ jilɛ inyɑ ɑkɑ̃ do jɑɑɛ ŋɑu, wɑ woi ikpɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ŋɔi mɔcɔ iyi í tɑko í to bi bɑlɛu, nŋu mɔ í lɔ. Iyi í yɛ mii ŋɑu nɔ í dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mɔcɔ ŋɑu ɑ kù tɑko ɑ kù ɡbɔ yɑɑsei kukɔi idei Ilɑɑɔ̃ wo iyi í ni kù nɛ bɛi ɑ́ ce iyi Jesu kù jĩ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ŋɔi mɔcɔ ŋɑu ɑ̀ sindɑ ɑ̀ bɔ kpɑsɛ̃. ");
INSERT INTO mkl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ammɑ Mɑɑri wɑ leekĩ wɑduude kɔkɔi bɑlɛu wɑ kpɑtɑ. Si bɛi wɑ kpɑtɑu ŋɔi í bɑte í nɑnte inɔ bɑlɛu. ");
INSERT INTO mkl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nɔ í yɛ ɑmɑlekɑ minji ɡɔ ŋɑ ɑ̀ wɑɑ dɑsi nyɑu fũfũ ɑ̀ wɑɑ bubɑ tenɡi bii ikui Jesu wɑ sũ wo, inɛ ɑkɑ̃ ikpɑ iri, inɛ ɑkɑ̃ mɔ ikpɑ kutɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nɔ ɑ̀ beeɛ ɑ̀ ni, ɑbooyi, nɑ mii í ce ì wɑɑ kpɑtɑ. Ŋɔi í jɛ nŋɑ í ni, ɑ̀ so ikui Lɑfɛ̃ɛm hɑi ihɛ̃i nɔ n kù mɑ̀ bii ɑ̀ dɑsiɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iyi í fɔ bɛɛbɛ í tɑ̃, ŋɔi í sindɑ nɔ í yɛ Jesu wɑ leekĩ bɛ. Ammɑ kù mɑ̀ mɑ̀ Jesui. ");
INSERT INTO mkl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ŋɔi Jesu í beeɛ í ni, ɑbooyi, nɑ mii í ce ì wɑɑ kpɑtɑ. Yooi ì wɑɑ dɛ. Ŋɔi Mɑɑri í tɑmɑɑ bɛi woo deɡbe lɑmboui. Ŋɔi í sɔ̃ɔ í ni, mɔkɔɔyi, bii ɑwɔi ì soo, sɔ̃m bii ì jilɔɔ n koo n soo. ");
INSERT INTO mkl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ŋɔi Jesu í ni, Mɑɑri. Ŋɔi Mɑɑri í sindɑ siɛ í sɔ̃ɔ do feei Ebɛɛ í ni, Rɑbuni, wɑɑtɔ Mɛɛtu. ");
INSERT INTO mkl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ŋɔi Jesu í sɔ̃ɔ í ni, jɔ̀m, mɑɑ̀ lum, domi n kù bɔ lele bi Bɑɑm titɑ̃. Ammɑ bɔ bi mɔcɔm ŋɑ, sɔ̃ ŋɑ i ni ǹ wɑ n bɔ bi Ilɑɑɔ̃. Nŋui í jɛ bɑɑm, nɔ í jɛ bɑɑi iŋɛ mɔ. ");
INSERT INTO mkl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ŋɔi Mɑɑri inɛi Mɑdɑlɑu í koo í sɔ̃ mɔcɔ ŋɑu í ni nŋu í yɛ Lɑfɛ̃ɛ. Nɔ wɑ sisi nŋɑ ide iyi Jesu í sɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ajɔ ɑmɑɑzumɑu iyi ɑlɛ í lɛ ŋɔi mɔcɔ ŋɑu ɑ̀ tɔtɔɔ si ile ɡɔ nɔ ɑ̀ sɔkɔ ɡɑmbou domi ɑ̀ wɑɑ ce njoi inɛ nɡboi Zuifu ŋɑu. Ŋɔi Jesu í fɑɑtɑ wɑ í leekĩ si ɑnini nŋɑ. Nɔ í sɔ̃ ŋɑ í ni, lɑɑkɑi ku sũ ku wɛɛ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iyi í sɔ̃ ŋɑ bɛɛbɛ í tɑ̃ ŋɔi í nyisi ŋɑ ɑwɔɛ ŋɑ do kpɑkpɑɑ cinɡɑɛu. Nɔ inɔi mɔcɔ ŋɑu í dɔ̃ iyi ɑ̀ yɛ Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ŋɔi Jesu í sɔ̃ ŋɑ mɑ́ í ni, lɑɑkɑi ku sũ ku wɛɛ nŋɛ. Si bɛi Bɑɑbɑ í bɛm wɑ, bɛɛbɛ mɔi ɑmu mɔ ǹ bɛ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi í fufu ŋɑ í ni, i ɡbɑ Hundei Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Inɛ iyi ì kpɑ idei dulum dɛɛ ŋɑ, Ilɑɑɔ̃ mɔ ɑ́ kpɑɑi. Inɛ mɔ iyi ì ni dulum ndɛɛ í jɛ idei iriɛ ŋɑ, lɑfɛ̃ɛ ɑ́ mɑɑ wɛɛò ndɛɛi. ");
INSERT INTO mkl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wee Tomɑɑ inɛ ɑkɑ̃i mɔcɔ mɑɑteeji ŋɑ iyi ɑ̀ yɑ kpe Sìkɑ̀u kù wɑ inɔ nŋɑ si wɑɑti iyi Jesu í nɑɑ si ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ŋɔi mɔcɔ ŋɑ iyi ɑ̀ ɡbeu ɑ̀ sɔ̃ɔ ɑ̀ ni, ɑ̀ yɛ Lɑfɛ̃ɛ. Ammɑ Tomɑɑ í sɔ̃ ŋɑ í ni, nɔ n kù yɛ ɑɡbɛi ponti ŋɑu si ɑwɔɛ ŋɑ nɔ n kù dɑsi ɑmɑɑwɔm si ɑɡbɛi pontiu nɔ n kù dɑsi ɑwɔm si dɑlɑi jujui kpɑkpɑɑ cinɡɑɑɛu n kɑɑ n dɑsi nɑɑnɛ pɑi. ");
INSERT INTO mkl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Zɑkɑi ɑzumɑ ɑkɑ̃ mɑ́ ɑ̀ tɔtɔɔ mɑ́ si inɔ ile. Tomɑɑ í wɑ inɔ nŋɑ. Nɔ ɑ̀ cĩmbo ɡɑmbo ŋɑ. Ammɑ Jesu í fɑɑtɑ si ɑnini nŋɑ wɑ mɑ́ nɔ í ni, lɑɑkɑi ku sũ ku wɛɛ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nɔ í sɔ̃ Tomɑɑ í ni, cɔ ɑwɔm ŋɑ nɔ i dɑsi ɑmɑɑwɔɛ si bɛ. Nɑɑò ɑwɔɛ wɑ mɑ́ i luò cinɡɑɑm. Jɔ̀ sikɑ sikɑu bɛ, dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ŋɔi Tomɑɑ í jɛɑɑ í ni, ɑwɔi ì jɛ Aɔ̃ Lɑfɛ̃ɛm. ");
INSERT INTO mkl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ŋɔi Jesu í sɔ̃ɔ í ni, debɛi ì dɑsi nɑɑnɛ si nɑ iyi í jɔ̀ ì yɛm, mɑ irei. Ilu inɔ didɔ̃ ŋɑi inɛ ŋɑ iyi ɑ kù yɛm nɔ do nŋu fei ɑ̀ dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Mɑɑmɑɑke nkpɔi Jesu í ce mɑ́ si wɑjui mɔcɔɛ ŋɑ iyi ɑ kù kɔ si tiɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ammɑ ide iyi ihɛ̃ ŋɑi ɑ̀ kɔ ku bɑ i dɑsi nɑɑnɛ ŋɑ iyi Jesui í jɛ Kirisi Amɑi Ilɑɑɔ̃ ku bɑ nɑɑnɛ iyi ì dɑsiɛ ŋɑu ku jɔ̀ i bɑ kuwɛɛ hɑi tɑ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Si ɑnyii nŋu, Jesu í nyisi ɑrɑɛ bi mɔcɔɛ ɡɔ ŋɑ mɑ́ kɔkɔi tenku iyi ɑ̀ yɑ kpe Tiberiɑ. Do yɑɑse bɛi í nyisiò ɑrɑɛ wee. ");
INSERT INTO mkl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔɔ Piɛɛ do Tomɑɑ iyi ɑ̀ yɑ kpe Sìkɑ̀u do Nɑtɑniɛli inɛi Kɑnɑ si ilɛi Gɑlilee do ɑmɑi Zebedee ŋɑ do mɔcɔ minji mmu ɡɔ ŋɑ mɑ́, ɑŋɑ fei ɑ̀ wɑ inyɑ ɑkɑ̃ bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ŋɔi Simɔɔ Piɛɛ í sɔ̃ ŋɑ í ni, ǹ wɑ n bɔ cɔcɔ. Nɔ ɑ̀ ni, ɑɑ kɑ siɛ. Nɔ ɑ̀ fitɑ ɡbɑkɑ̃ ɑ̀ lɔ ɑkɔi inyi ɡɔ idũ ɑ̀ nɛ. Ammɑ idũ ɑjɔ nŋu ɑ kù mu nkɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Iyi iju wɑ bɔ ku mɑ́, ŋɔi ɑ̀ yɛ Jesu wɑ leekĩ itĩi tenkuu bɛ, ɑmmɑ ɑ kù mɑ̀ mɑ̀ nŋui. ");
INSERT INTO mkl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ŋɔi Jesu í bee ŋɑ í ni, iŋɛ ɑwɑɑsũ ŋɑu bɛ, i kù mu nkɑ̃mɑ ŋɑ de. Ŋɔi ɑ̀ ni, ɑɑwo. ");
INSERT INTO mkl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ŋɔi í sɔ̃ ŋɑ í ni, i dɑsi tɑɑo nŋɛ inɔ inyi do ikpɑ ɑwɔ njɛi ɑkɔi inyiu, ɑɑ mu cɛ̃ɛ ŋɑ. Nɔ ɑ̀ sɔ tɑɑo nŋɑ inɔ inyi nɔ ɑ̀ mu cɛ̃ɛ hee ɑ̀ mɔnɡɔ ku fɑɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mɔcɔ iyi Jesu í bi jiidɑu í sɔ̃ Piɛɛ í ni, Lɑfɛ̃ɛ mbɛ. Iyi Simɔɔ Piɛɛ í ɡbɔ iyi Lɑfɛ̃ɛi, ŋɔi í dɑsi ibɔɛ domi bɑsĩi í wɛɛ wo. Nɔ í dɑsi inyiu wɑ bɔ bi tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ammɑ mɔcɔ ŋɑ iyi ɑ̀ ɡbeu ɑ̀ to wɑ ice do ɑkɔi inyiu, ɑ̀ wɑɑ fɑ tɑɑo nŋɑ iyi í kɔ̃ do cɛ̃ɛu. Kujĩ nŋɑ do ice kù re mɛɛtu cĩɔ. ");
INSERT INTO mkl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Iyi ɑ̀ kitɑ wɑ ilɛ nɔ ɑ̀ yɛ inɑ nyɛnyɛ ɡɔ bɛ cɛ̃ɛ wɑ bɑndɑ si, nɔ pɛ̃ɛ wɑ jilɛ bɛ. ");
INSERT INTO mkl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, i nɑɑò cɛ̃ɛ ɡɔ ŋɑ iyi ì mu wɑ nsɛiu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nɔ Simɔɔ Piɛɛ í koo í lɔ ɑkɔi inyiu nɔ í fɑ tɑɑou wɑ ilɛ. Tɑɑou í kɔ̃ do cɛ̃ɛ nlɑ ŋɑ. Kukpɔ nŋɑ í to cĩɔ do ciitɑɑ do mɛɛtɑ. Do iyi í kpɔ bɛɛbɛ fei tɑɑou kù ɡɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ŋɔi Jesu í sɔ̃ ŋɑ í ni, i nɑɑ i nyɑ sɔndɑ ŋɑ. Nɔ bɑɑ mɔcɔ ɑkɑ̃ kù jɛ ku beeɛ ku ni, ɑwɔi yoo, domi ɑ̀ mɑ̀ iyi Lɑfɛ̃ɛi. ");
INSERT INTO mkl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ŋɔi Jesu í koo í so pɛ̃ɛu do cɛ̃ɛu í nɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Isɛ ɡbɛɛtɑsiɑɛi mbɛ bɛi iyi Jesu í nyisi mɔcɔɛ ŋɑ ɑrɑɛ hɑi wɑɑti iyi í jĩ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iyi ɑ̀ nyɑ sɔndɑ ɑ̀ tɑ̃ ŋɔi Jesu í bee Simɔɔ Piɛɛ í ni, Simɔɔ ɑmɑi Zɑ̃ɑ, ì bim í re inɛ ihɔ̃ ŋɑ? Nɔ Piɛɛ í jɛɑɑ í ni, oo Lɑfɛ̃ɛ. Ì mɑ̀ iyi ǹ biɛ. Ŋɔi Jesu í sɔ̃ɔ í ni, ɡbɔɑ ɑmɑ ɑnɡudɑ̃m ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nɔ í beeɛ mɑ́ isɛ ɡbeejisiɑ í ni, Simɔɔ ɑmɑi Zɑ̃ɑ, ì bim? Nɔ Piɛɛ í jɛɑɑ í ni, oo Lɑfɛ̃ɛ. Ì mɑ̀ iyi ǹ biɛ. Ŋɔi Jesu í sɔ̃ɔ í ni, ɡbɑ̃ ɑnɡudɑ̃m ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nɔ í sisi í beeɛ mɑ́ isɛ ɡbɛɛtɑsiɑ í ni, Simɔɔ ɑmɑi Zɑ̃ɑ, ì bim? Nɔ inɔi Piɛɛ í fɔ do si bɛi í beeɛ isɛ ɡbɛɛtɑsiɑ í ni, ì bim? Ŋɔi Piɛɛ í jɛɑɑ í ni, Lɑfɛ̃ɛ, ì mɑ̀ fei ndɛɛ, ì mɑ̀ kɑm kɑm iyi ǹ biɛ. Nɔ Jesu í sɔ̃ɔ í ni, to, ɡbɑ̃ ɑnɡudɑ̃m ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ntɔ ntɔ ǹ wɑ n sɔ̃ɛi, wɑɑti iyi ì wɛɛ ɑwɑɑsũ ì yɑ dĩɑ ɑrɑɛ wondo nɔ i bɔ bii ì bi. Ammɑ bii ì nɑɑ ì ɡbo, ɑɑ tɛ ikpɑɛi nɔ inɛ ɡɔ ku dĩɛ nɔ ku bɔòɛ bii i kù bi. ");
INSERT INTO mkl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Do ideu bɛi Jesu í fɔ yɑɑse bɛi Piɛɛ ɑ́ nɑ ku ku ku nyisiò ɑmboei Ilɑɑɔ̃. Iyi í fɔ bɛɛbɛ í tɑ̃ nɔ í sɔ̃ɔ í ni, toom wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ŋɔi Piɛɛ í sindɑ, nɔ í yɛ mɔcɔ iyi Jesu í bi jiidɑu wɑ nɑɑ do ɑnyi nŋɑ. Mɔcɔu nŋui í tɑko í ɡbesi ɡɛndɛi Jesu wɑɑti iyi ɑ̀ wɑɑ jɛ í beeɛ í ni, Lɑfɛ̃ɛ, yooi ɑ́ zɑmbɑɛu. ");
INSERT INTO mkl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Iyi Piɛɛ í yɛ mɔcɔu ŋɔi í bee Jesu í ni, Lɑfɛ̃ɛ, mɔkɔu ihɛ̃ mɔ ni, bɛirei ti nŋu mɔ ɑ́ yɛ. ");
INSERT INTO mkl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ŋɔi Jesu í jɛɑɑ í ni, bɑɑ bii ǹ bi n jɔ̀ ku mɑɑ wɛɛ hee n koo n nyiò wɑ mɑ́i, iwoi í yɛɛ. Awɔ de, toom wɑ. ");
INSERT INTO mkl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ŋɔi lɑɑbɑɑui ideu í fɑnɡɑɑ si inɔi woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ̀ be ni mɔcɔu kɑɑ ku. Ammɑ Jesu kù ni kɑɑ ku, nŋu de í ni, bɑɑ bii ǹ bi n jɔ̀ ku mɑɑ wɛɛ hee n koo n nyiò wɑ mɑ́i, iwoi í yɛɛ. ");
INSERT INTO mkl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mɔcɔ iyi Jesu wɑ fɑ̃ɑu ɑmu Zɑ̃ɑi. Nɔ ɑmu tɑkɑm nii ǹ wɑ n jɛ sɛɛdɑi ide ŋɑu, ɑmu iyi n kɔ tiɑu ihɛ̃, ɑ̀ nɔ ɑ̀ mɑ̀ iyi sɛɛdɑm í jɛ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mii nkpɔ nkpɔ í wɛɛ mɑ́ iyi Jesu í ce. Bii í jɛ ɑ̀ kɔ fei ndɛɛ ɑkɑ̃ ɑkɑ̃, n kù tɑmɑɑ mɑ̀ ɑndunyɑu ihɛ̃ ɑ́ to inɛ ŋɑ ɑ bɑ bii ɑɑ jilɛ tiɑ ŋɑ iyi ɑɑ kɔ ŋɑu fei.");
INSERT INTO mkl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Bɑɑkɔɔm, Teofili, Si tiɑ sintem ǹ kɔ mii iyi Jesu í ce do cio iyi í yɑ mɑɑ kɔɑ inɛ ŋɑ si fei hɑi sinteɛ, ");
INSERT INTO mkl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hee í koo í to ɑjɔ iyi Ilɑɑɔ̃ í soo lele. Hee ku mɑɑ nɛ, inɛ ŋɑ iyi í cicɑ wo ɑ̀ jɛ woo bɛ ŋɑu, í bɑ ŋɑ ide ku fɔ do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃ í sɔ̃ ŋɑ bɛi ɑɑ ce. ");
INSERT INTO mkl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Si ɑnyii ikuɛ í nyisi ŋɑ ɑrɑɛ si ɑfei ɑjɔ ciiji isɛ fɛɛfɛlo ku jɛ nŋɑ sɛɛdɑ iyi kù nɛ sikɑ sikɑ iyi nŋu í wɛɛ. À yɔɔ nɔ í ce nŋɑ fɑɑjii bommɑi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ajɔ nŋu ɡɔ, si bɛi Jesu do mɔcɔɛ ŋɑ ɑ̀ wɑ inyɑ ɑkɑ̃ í sɔ̃ ŋɑ í ni, i mɑɑ̀ tekĩ hɑi Zeruzɑlɛmu ŋɑ, ɑmmɑ i deɡbe ɑmuɑ iyi Ilɑɑɔ̃ Bɑɑbɑ í wɑ̃ò ŋɛu, ɑmuɑ iyi ǹ tɑko ǹ sɔ̃ ŋɛ ideɛu. ");
INSERT INTO mkl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Zɑ̃ɑ nŋu, inyii í dɑsi ŋɛ wo, ɑmmɑ si ɑjɔ minjiu ihɛ̃ ɑɑ dɑ nŋɛ si Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ŋɔi woo bɛ ŋɑ iyi ɑŋɑò Jesu ŋɑ ɑ̀ wɑ inyɑ ɑkɑ̃u ɑ̀ beeɛ ɑ̀ ni, Lɑfɛ̃ɛ, bɛbɛii ɑɑ teese i jilɛ bommɑi Izirɛli? ");
INSERT INTO mkl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ŋɔi Jesu í jɛ nŋɑ í ni, kù jɛ bɑɑ nŋɛ i mɑ̀ ɑjɔu wɑlɑkɔ i mɑ̀ yɑɑse bɛi mii ŋɑu bɛ ɑ́ nɑ ku ce ŋɑ. Ilɑɑɔ̃ Bɑɑbɑi í jilɛ iyi bɛ ŋɑ do yiikoɛ. ");
INSERT INTO mkl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ammɑ ɑɑ bɑ ɡbuɡbɑ̃ ŋɑ wɑɑti iyi Hundei Ilɑɑɔ̃ ɑ́ nɑɑ si ŋɛ. Aɑ jɛɑ inɛ ŋɑ sɛɛdɑm ŋɑ si ilui Zeruzɑlɛmu, do si ilɛi Zudee fei, do si ilɛi Sɑmɑri hee ku bɔ do kɔɔi ɑndunyɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iyi Jesu í fɔ ideu í tɑ̃, ŋɔi ɑ̀ wɑɑ cɔɔ nɔ ɑ̀ bɑ wee Ilɑɑɔ̃ í soo ikpɑ lele nɔ kudũi ijĩ ɡɔ í jɔ̀ ɑ kù yɔɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Wɑɑti iyi ɑ̀ wɑɑ cɔɔ wɑ nɛ ikpɑ lelei Aɔ̃, ŋɔi ɡbɑkɑ̃ ɑ̀ yɛ woo dɑsi ibɔ fũfũ minji ɡɔ ŋɑ bɛ ɑ̀ wɑɑ leekĩ kɔkɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ŋɔi inɛ ŋɑu ɑ̀ ni, iŋɛ inɛi Gɑlilee ŋɑ, nɑ mii í ce ì leekĩ ì wɑɑ cɔ lele ŋɑ. Jesuu bɛ iyi Ilɑɑɔ̃ í so ikpɑ lele hɑi bi tu ŋɛu ɑ́ nyi wɑ mɑ́ do yɑɑse bɛi ì yɔɔ í nɛò leleu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iyi inɛ ŋɑu ɑ̀ fɔ bɛɛbɛ ɑ̀ tɑ̃, ŋɔi woo bɛ ŋɑu ɑ̀ sindɑ wɑ hɑi iri kutɑi Olivie bii ɑ̀ wɑu ɑ̀ nyi wɑ Zeruzɑlɛmu. Iri kutɑu í wɑ kɔkɔi iluu zɑkɑi kilo ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Iyi ɑ̀ to Zeruzɑlɛmu ŋɔi ɑ̀ ɡũ lelei ile ku kpɛkɛ bii ɑ̀ yɑ mɑɑ wɑu. Aŋɑ iyi ɑ̀ tɔtɔɔ bɛu wee, Piɛɛ do Zɑ̃ɑ, do Zɑɑki, do Anderee, do Filipu, do Tomɑɑ, do Bɑɑtelemi, do Mɑtie, do Zɑɑki ɑmɑi Alifee, do Simɔɔ iyi í yɑ jɑbuɑ ilɛɛ do Zudu ɑmɑi Zɑɑki. ");
INSERT INTO mkl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Do ɑnu ɑkɑ̃i inɛ ŋɑu fei ɑ̀ yɑ tɔtɔɔ ɑ mɑɑ ce kutɔɔ do himmɑ, ɑŋɑ do ifɔi Jesu ŋɑ do Mɑɑri iyeɛ do inɑɑbo ɡɔ ŋɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ajɔ nŋu ɡɔ woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ̀ tɔtɔɔ mɑ́. Kukpɔ nŋɑ í to zɑkɑi ɑmɑnɛ cifɑ. Ŋɔi Piɛɛ í dede í leekĩ si ɑnini nŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","iŋɛ kpɑɑsim ŋɑ, Hundei Ilɑɑɔ̃i í jɔ̀ Dɑvidi í fɔ idei Zudɑsi wo, nŋu iyi í cuɑɑ inɛ ŋɑ iyi ɑ̀ mu Jesuu, nɔ ideu kù nɛ bɛi ɑ́ ce iyi kù ce. ");
INSERT INTO mkl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zudɑsiui í tɑko í jɛ inɛ ɑkɑ̃ nwɑ wo, nŋu mɔ í yɑ dɑsi icɛ nwɑ ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Fiɑ iyi í bɑ nɑ lɑɑlɔ iyi í ceu í rɑò iko ɡɔ. Ŋɔi í cuku, iriɛ í tɑko í to ilɛ nɔ inɔɛ í lɑ, ifũɛ fei í fitɑ. ");
INSERT INTO mkl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ŋɔi inɛ ŋɑ iyi ɑ̀ wɑ Zeruzɑlɛmu fei ɑ̀ ɡbɔ ideu. Nɑ ŋɔi í jɔ̀ do fee nŋɑ ɑ̀ wɑɑ kpe ikou Akedɑmɑ, wɑɑtɔ Ikoi njɛ̀. ");
INSERT INTO mkl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ideɛ iyi ɑ̀ kɔ si tiɑi iri kukɔ̃u wee. A jɔ̀ ideɛu ku kpɔò bommɑ. Inɛ ɡɔ ku mɑɑ̀ bubɑ bɛ mɑ́. Nɔ ɑ̀ kɔɔ mɑ́ ɑ̀ ni, A jɔ̀ inɛ ɡɔ ku jɛ nsũɛ si icɛu. ");
INSERT INTO mkl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Debɛi, kɑ dɑsi inɛ ɡɔ si inɔ nwɑ ku jɛ nsũi Zudɑsiu. Nɔ í ɡbe lɑfɛ̃ɛ ku jɛ inɛ iyi í yɛ kujĩi Lɑfɛ̃ɛ Jesu hɑi si bɑlɛ bɛi ɑwɑ mɔ. Nɔ lɑfɛ̃ɛ ku jɛ inɛ ɑkɑ̃i inɛ ŋɑ iyi ɑ̀ bɑ wɑ kuwɛɛ ɑjɔ si wɑɑti kɑ̃mɑ fei iyi Jesu í wɛɛ do ɑwɑ si ɑndunyɑu ihɛ̃, hɑi wɑɑti iyi Zɑ̃ɑ í dɑsiɛ inyi hee í koo í bɔ lele. ");
INSERT INTO mkl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ŋɔi ɑ̀ cicɑ ɑmɑnɛ minji ɡɔ ŋɑ, irii inɛ ɑkɑ̃i Zozɛfu iyi ɑ̀ yɑ kpe Bɑɑsɑbɑ, wɑlɑkɔ Zusitu, inɛ minjisiɑu mɔ Mɑtiɑsi. ");
INSERT INTO mkl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ŋɔi ɑ̀ ce kutɔɔ ɑ̀ ni, Lɑfɛ̃ɛ, ɑwɔ iyi ì mɑ̀ idɔi inɛ fei, nyisi wɑ inɛ iyi ì cicɑ. Si inɔi mɔcɔ minjiɛ ŋɑu ihɛ̃ ");
INSERT INTO mkl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nyisi wɑ inɛ iyi ì bi ku jɛ nsũi Zudɑsi si icɛi woo bɛ ŋɑu, icɛ iyi Zudɑsi í jɔ̀ nɔ í koo í lɔ tenɡi bii í jɔ ɑ̀ dɑsiɛ. ");
INSERT INTO mkl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ŋɔi ɑ̀ tɑ nŋɑ kpɑsɑ. Nɔ kpɑsɑu í so Mɑtiɑsi. Ŋɔi ɑ̀ dɑsiɛ si inɔi woo bɛ mɑɑtɑkɑ̃ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Iyi ɑjɔi Pɑntekotu í to, ŋɔi woo dɑsi Jesu nɑɑnɛ ŋɑu fei ɑ̀ tɔtɔɔ inyɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Gbɑkɑ̃ ŋɔi ɑ̀ ɡbɔ ibɑ ɡɔ í nɑɑ hɑi lele, í jɔ bɛi fufu nlɑ, nɔ si inɔ ileu fei inɛ ŋɑ ɑ̀ ɡbɔ ibɑu. ");
INSERT INTO mkl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Si ɑnyiɛ ŋɔi ɑ̀ yɛ nɡɔɡɔ bɛi ɑmɛi inɑ í nɑ í lesi irii ɑŋɑ fei ɑkɑ̃ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ŋɔi ɑŋɑ iyi ɑ̀ wɑ bɛ fei ɑ̀ kɔ̃ò Hundei Ilɑɑɔ̃ nɔ ɑ̀ wɑɑ fɔ fee mmu ɡɔ ŋɑ, si bɛi Hundei Ilɑɑɔ̃ í mu nŋɑ ɑŋɑ fei ikɑ̃ ikɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wee wɑɑti bɛɛbɛ Zuifu ɡɔ ŋɑ iyi ɑ̀ mɑ̀ bɛɛrɛi Ilɑɑɔ̃ ɑ̀ nɑɑ hɑi ilɛ fei ɑ̀ wɑ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Iyi ɑ̀ ɡbɔ ibɑu, ŋɔi zɑmɑɑ nkpɔ nkpɔ í sɛi í koo í tɔtɔɔ bɛ nɔ ɑ̀ biti jiidɑ jiidɑ si nɑ iyi í jɔ̀ ɑ̀ ɡbɔ woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ̀ wɑɑ fɔ feei ɑŋɑ ikɑ̃ ikɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ŋɔi í mu ŋɑ biti hee í cɑɑ, nɔ ɑ̀ bee njɛ ɑ̀ wɑɑ ni, inɛ ŋɑ iyi ɑ̀ wɑɑ fɔ ideu bɛ, n jɔ ɑŋɑ fei inɛi Gɑlilee ŋɑi mɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nɔ bɛirei í ce ɑwɑ fei ɑ̀ ɡbɔ ɑ̀ wɑɑ fɔ ide do fee nwɑ ikɑ̃ ikɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Si inɔ nwɑ inɛ ɡɔ ŋɑ ɑ̀ nɑɑi hɑi ilɛi Pɑɑti do hɑi Mɛdi do Elɑmi, do hɑi ilɛi Mezopotɑmi do Zudee do Kɑpɑdosi do Pontu do hɑi ilɛi Azii. ");
INSERT INTO mkl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Inɛ ɡɔ ŋɑ mɔ hɑi ilɛi Firizii ɑ̀ nɑɑ do Pɑnfili do Ezibiti do hɑi ikpɑ Libi iyi í wɑ kɔkɔi Sirɛni. Inɛ ɡɔ ŋɑ mɔ ɑ̀ nɑɑ hɑi Romu. ");
INSERT INTO mkl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Inɛ ɡɔ ŋɑ Zuifu ŋɑi ɑ̀ bí ŋɑ, inɛ ɡɔ ŋɑ mɔ ɑ̀ wɑɑ too kucei Zuifu ŋɑ. Inɛ ɡɔ ŋɑ ɑ̀ nɑɑ hɑi ilɛi Kɛrɛti do hɑi Arɑbi. Do nŋu fei, ɑwɑ fei ɑ̀ ɡbɔ ɑ̀ wɑɑ fɔ fee nwɑ ŋɑ ikɑ̃ ikɑ̃ ɑ̀ wɑɑ sisiò mii nlɑ ŋɑ iyi Ilɑɑɔ̃ í ce. ");
INSERT INTO mkl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ŋɔi ɑŋɑ fei ɑ̀ biti hee ɑ kù mɑ̀ bɛi ɑɑ lɑsɑbu nɔ ɑ̀ bee njɛ ɑ̀ wɑɑ ni, yoomɑi í jɛ yɑɑsei mii nɔu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ammɑ inɛ ɡɔ ŋɑ ɑ̀ yɑɑko ŋɑ ɑ̀ wɑɑ ni, inɛ ŋɑu ɑ̀ mɔ ɑtɛ̃i hee í cɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ŋɔi Piɛɛ í dede do woo bɛ mɑɑtɑkɑ̃ ŋɑu ɑjɔ́ nɔ wɑ lɑ hee lele í sɔ̃ zɑmɑɑu wɑ ni, iŋɛ Zuifu ŋɑ do iŋɛ mɔ iyi ì wɑ Zeruzɑlɛmu fei, i sotĩ i ɡbɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ǹ bi i mɑ̀ ŋɑ iyi inɛ ŋɑu ihɛ̃ ɑ kù mɔ ɑtɛ̃ si bɛi ì wɑɑ tɑmɑɑ ŋɑu bɛ, domi ɑ̀ wɛɛ si dɑɑdɑɑkɔ, bɑɑ isɔ mɛɛsɑ̃ kù lɔ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ammɑ iyi ì wɑɑ yɛ dɑɑkɔɔyiu ihɛ̃ ŋɑ, iyi wɑlii Zoɛli í fɔu mbɛ iyi í ni, ");
INSERT INTO mkl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ilɑɑɔ̃ í ni, si ɑjɔi ɑnkɑ̃ɑnyi ŋɑu ɑn dɑɑ inɛ fei si Hundem. Amɑ inɛmɔkɔ do ɑmɑ inɑɑbo nŋɛ ŋɑ ɑɑ ce wɑlii. Awɑɑsũ nŋɛ ŋɑ ɑɑ yɑ mɑɑ ce kuyɛ ŋɑ, Nɔ mɔkɔ nɡbo nŋɛ ŋɑ mɔ Ilɑɑɔ̃ ɑ́ bɑ ŋɑ ide ku fɔ si ɑlɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wɑɑti bɛɛbɛ, ɑn dɑsi Hundem si inɛmɔkɔ do inɑɑbo woo ce icɛm ŋɑ, Nɔ ɑɑ ce wɑlii. ");
INSERT INTO mkl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","An nyisi mii mɑɑmɑɑke ŋɑ ikpɑ lelei Aɔ̃, Nɔ ɑn jɔ̀ inɛ ŋɑ ɑ yɛ mii mɑɑmɑɑke ŋɑ mɑ́ si ilɛ. Inɛ ŋɑ ɑɑ yɛ njɛ̀ do inɑ do cuɑi inɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Inunu ɑ́ kuku inyɑ Nɔ cukpɑ ku kpɑ̃ bɛi njɛ̀. Si ɑnyii nŋui ɑjɔi Lɑfɛ̃ɛ ɑ́ to wɑ, ɑjɔ nlɑ ilu ɑmboeu. ");
INSERT INTO mkl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ammɑ inɛ ŋɑ iyi ɑ̀ wɑɑ kpe Aɔ̃ Lɑfɛ̃ɛ fei ɑɑ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Iŋɛ inɛi Izirɛli ŋɑ, i sotĩ i ɡbɔ ideu ŋɑ. Ilɑɑɔ̃ í jɔ̀ ì mɑ̀ yiikoi Jesu inɛi Nɑzɑrɛtiu ŋɑ nɑ mɑɑmɑɑke do nyindɑ ŋɑ iyi í jɔ̀ Jesu í ce si ɑnini nŋɛ, si bɛi iŋɛ tɑkɑ nŋɛ ì mɑ̀ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jesuu, Ilɑɑɔ̃ tɑkɑɛi í lɑsɑbu hɑi sinte í jilɔɔ si ɑ dɑɑ inɛ ŋɑ si ɑwɔ. Nɔ iŋɛi ì dɑɑ ilu dulum ŋɑ si ɑwɔ ì jɔ̀ ɑ̀ kpɑkpɑɛ si jĩi ku ɡɑɑu ɑ̀ kpɑɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ammɑ Ilɑɑɔ̃ í jũu hɑi si bɑlɛ, í nyɑɑ hɑi si wɑhɑlɑi iku domi iku kù nɛ ɡbuɡbɑ̃ kɑ̃mɑ siɛ hee ku ɡɛɛɛ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ideɛi Dɑvidi í kɔ í ni, Ǹ wɑ n yɛ Aɔ̃ Lɑfɛ̃ɛ ɑjɔ fei, Domi í wɑ ɑwɔ njɛm ku bɑ n mɑɑ̀ n yɑyɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nɑ ŋɔi í jɔ̀ idɔm wɑ dɔ̃, nɔ ǹ wɑ n fɔ ide do inɔ didɔ̃. Nɔ bɑɑ bii í jɛ ɑn ku ǹ nɛ kpɑ̃ɑ ku cɔ, ");
INSERT INTO mkl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Domi ɑwɔ Ilɑɑɔ̃ i kɑɑ jɔ̀ hundem bi ku wɑi iku ŋɑ. Bɛɛbɛ mɔi i kɑɑ jɔ̀ ɑrɑi Inɛ Kumɑ́ɛ ku sɑ̃mi. ");
INSERT INTO mkl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ì nyisim kpɑ̃ɑ iyi wɑ bɔɔm si kuwɛɛ. An wɛɛ do ɑwɔ si inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Si ɑnyii nŋu nɔ Piɛɛ í ni mɑ́, iŋɛ kpɑɑsim ŋɑ, ǹ wɑ n sɔ̃ ŋɛ nɔ kù nɛ sikɑ kɑ̃mɑ, Dɑvidi bɑlɑ nwɑ í ku nɔ ɑ̀ suu. Bɑlɛɛ mɔi í wɑ si ɑnini nwɑ ihɛ̃ hee do nnyi fei, mɑ̀ irei. ");
INSERT INTO mkl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ammɑ si bɛi í jɛ wɑlii, í mɑ̀ iyi Ilɑɑɔ̃ í ceɑ nŋu kuwɑ̃i ide ɡɔ do kuɡbɑsi í ni tɔkuɛ ɡɔ ɑ́ nɑ ku bubɑ si kitɑ̃i bommɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dɑvidi í mɑ̀ mii iyi ɑ́ nɑ ku ce. Nɑ ŋɔi í jɔ̀ ide iyi í fɔ, iyi í ni Ilɑɑɔ̃ kɑɑ jɔ̀ hundeɛ bi ku wɑi iku ŋɑ nɔ ɑrɑɛ kɑɑ sɑ̃mi, idei kujĩi inɛ iyi Ilɑɑɔ̃ í cicɑui wɑ fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesuu iyi ǹ wɑ n fɔ ideɛ, Ilɑɑɔ̃ í jũu hɑi si bɑlɛ nɔ ɑwɑ fei ɑ̀ jɛ sɛɛdɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ilɑɑɔ̃ Bɑɑbɑ í soo lele nɔ í muɑɑ Hundeɛ iyi í wɑ̃ɑò wo. Nɔ nŋu mɔ í muɑ ɑwɑ mɔ Hundeu. Nŋui ì wɑɑ yɛ nɔ ì wɑɑ ɡbɔ ŋɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dɑvidi tɑkɑɛ kù bɔ lelei Aɔ̃ ɑmmɑ í ni, Aɔ̃ Lɑfɛ̃ɛ í sɔ̃ Lɑfɛ̃ɛm í ni, Bubɑ ɑwɔ njɛm, ");
INSERT INTO mkl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Hee n ce mbɛɛɛ ŋɑ Bi ku lesi isɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nɑ ŋɔi í jɔ̀ í sĩɑ iŋɛ inɛi Izirɛli ŋɑ fei i mɑ̀ iyi ihɛ̃ ŋɑ sɑ̃ɑ sɑ̃ɑ. Jesu iyi ì kpɑkpɑ si jĩi nɔu bɛ ŋɑ, nŋui Aɔ̃ í ce Lɑfɛ̃ɛ do Kirisi. ");
INSERT INTO mkl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iyi inɛ ŋɑu ɑ̀ ɡbɔ bɛɛbɛ ŋɔi ideu í to si ŋɑ ntɔ ntɔ, nɔ ɑ̀ bee Piɛɛ do woo bɛ iyi ɑ̀ ɡbe ŋɑu ɑ̀ ni, iŋɛ kpɑɑsi nwɑ ŋɑ, bɛirei ɑɑ kɑ ce. ");
INSERT INTO mkl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ŋɔi Piɛɛ í sɔ̃ ŋɑ í ni, iŋɛ fei i kpɑɑsi idɔ nŋɛ i jɔ̀ ɑ dɑsi ŋɛ inyi do irii Jesu Kirisi ku bɑ Ilɑɑɔ̃ ku kpɑ idei dulum du ŋɛ, nɔ ɑɑ bɑ ɑmuɑi Ilɑɑɔ̃ mɑ ŋɑ iyi í jɛ Hundeɛ. ");
INSERT INTO mkl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bɛɛbɛi ɑ́ ce si nɑ iyi í jɔ̀ Ilɑɑɔ̃ í ce nŋɛ kuwɑ̃ɛ, iŋɛ do ɑmɑ nŋɛ ŋɑ do inɛ ŋɑ iyi ɑ̀ wɑ hee jĩijĩ fei, inɛ ŋɑ iyi Aɔ̃ Lɑfɛ̃ɛ nwɑ ɑ́ kpe fei. ");
INSERT INTO mkl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Do ide ikɑ̃ ikɑ̃ nkpɔ nkpɔi Piɛɛ í jɛ nŋɑ do sɛɛdɑ nɔ í mu nŋɑ ɡbuɡbɑ̃ í ni, i nyɑ ɑrɑ nŋɛ ikɑ̃ hɑi bi inɛ lɑɑlɔi nsɛi ŋɑu ihɛ̃ ku bɑ i bɑ fɑɑbɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ŋɔi ɑ̀ dɑsi inɛ ŋɑ iyi ɑ̀ ɡbɑ idei Piɛɛu inyi. Ajɔ nŋu zɑkɑ bɛi ɑmɑnɛ dubu mɛɛtɑ í kɔ̃ɔsi si inɔi woo dɑsi Jesu nɑɑnɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nɔ ɑ̀ yɑ ɡbɔ cio iyi woo bɛ ŋɑu ɑ̀ yɑ mɑɑ kɔ ŋɑ siu fei, nɔ ɑ̀ yɑ mɑɑ wɛɛ do ɑnu ɑkɑ̃, ɑ̀ yɑ mɑɑ jɛ ijɛ iyi ɑɑ yeò ɡiɡii ikui Jesu, nɔ ɑ̀ yɑ mɑɑ ce kutɔɔ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ŋɔi ideu í to si inɛ fei, nɔ Ilɑɑɔ̃ í jɔ̀ woo bɛ ŋɑu ɑ̀ wɑsi mɑɑmɑɑke nkpɔ nkpɔ ku ce. ");
INSERT INTO mkl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Woo dɑsi Jesu nɑɑnɛ ŋɑu fei ɑ̀ ce ɑnu ɑkɑ̃ nɔ mii iyi ɑ̀ nɛ fei ti ɑŋɑ feii í jɛ. ");
INSERT INTO mkl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wɑɑti iyi inɛ ɡɔ í nɛ bukɑɑtɑi nɡɔɡɔ fei ɑ̀ yɑ tɑ iko nŋɑ ŋɑi do mii ndu ŋɑ ŋɑ nɔ ɑ nɑ lɑfɛ̃ɛ fiɑu zɑkɑ bɛi í nɛ bukɑɑtɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ajɔ fei ɑ̀ yɑ tɔtɔɔi si bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃. À yɑ tɔtɔɔ ɑ mɑɑ jɛi si inɔ kpɑsɛ̃ nŋɑ ŋɑ do inɔ didɔ̃. Muɑfiti ci yɑ wɑ si. ");
INSERT INTO mkl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","À yɑ mɑɑ sɑɑbu Ilɑɑɔ̃ nɔ inɛ fei í mɑ̀ bɛɛrɛ nŋɑ. Ajɔ fei inɛ ŋɑ ɑ̀ yɑ dɑsi nɑɑnɛi nɔ ɑ bɑ fɑɑbɑ. Bɛɛbɛi Lɑfɛ̃ɛ Jesu í yɑ mɑɑ kɔ̃ɔsi kukpɔi woo dɑsiɛ nɑɑnɛ ŋɑu wɑɑti kɑ̃mɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ŋɔi ɑlɛ ɑjɔ nŋu ɡɔ zɑkɑi isɔ mɛɛtɑ Piɛɛ do Zɑ̃ɑ ɑ̀ wɑɑ bɔ kutɔɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ŋɔi ɑ̀ yɛ mɔkɔ ɡɔ bɛ iyi ɑ̀ bí do wɛɛɡɛ. Ajɔ fei ɑ̀ yɑ nɑ ɑ jilɔɔi ɑndɛi bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ iyi ɑ̀ yɑ kpe ɑndɛ Ku sĩɑu, ku mɑɑ bɑrɑ wɑɑti iyi inɛ ŋɑ ɑ̀ wɑɑ lɔ. ");
INSERT INTO mkl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Iyi í yɛ Piɛɛ do Zɑ̃ɑ ɑ̀ wɑɑ lɔ bɑntumɑi kpɑsɛ̃u ŋɔi í tɔɔ ŋɑ ɑ muɑ nŋu nɡɔɡɔ. ");
INSERT INTO mkl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ŋɔi Piɛɛ do Zɑ̃ɑ ɑ̀ kɑ̃siɛ iju, nɔ Piɛɛ í ni, cɔ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ŋɔi í cɔ ŋɑ do lɑɑkɑi domi wɑ tɑmɑɑ nɡɔɡɔ si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ammɑ Piɛɛ í sɔ̃ɔ í ni, n kù nɛ fiɑ hee mɑ́ jɛ wurɑ, ɑmmɑ iyi ǹ nɛ ɑn muuɛ. Do irii Jesu Kirisi inɛi Nɑzɑrɛtiu, dede i nɛ. ");
INSERT INTO mkl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ŋɔi í mu ɑwɔ njɛi mɔkɔu í dedeɛ. Bɛ ɡbɑkɑ̃, isɛi inɛɛu do ikɔ̃i isɛɛ ŋɑu í ce ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ŋɔi í fo í dinɡɑ wɑ nɛ. Ŋɔi ɑŋɑò ŋɑ fei ɑ̀ lɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ ɑjɔ́, ŋɔi í fo í dinɡɑ wɑ nɛ wɑ sɑɑbuò Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ŋɔi inɛ fei í yɛ wɑ nɛ wɑ sɑɑbuò Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Si bɛi ɑ̀ mɑ̀ iyi nŋui í yɑ tɑko ku mɑɑ bubɑ ɑndɛ kusĩɑi bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ ku mɑɑ bɑrɑu, ŋɔi biti í mu ɑŋɑ fei nɔ ideu í to si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ŋɔi mɔkɔ iyi í bɑ iriu kù jɛ kù nɛ hɑi bi Piɛɛ do Zɑ̃ɑ. Aŋɑò ŋɑ ɑ̀ wɑ ikpɑ ɑkɑ̃i kpɑsɛ̃i Ilɑɑɔ̃ iyi ɑ̀ yɑ kpe bɑntumɑi Sɑlomɔɔ. Nɔ inɛ ŋɑ iyi ideu í mu ŋɑ bitiu ɑ̀ sɛi ɑ̀ bɔ bi tu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Iyi Piɛɛ í yɛ ŋɑ ŋɔi í sɔ̃ ŋɑ í ni, iŋɛ inɛi Izirɛli ŋɑ, bɛirei í ce ì biti ì wɑɑ cɔ wɑ bɛɛbɛ ŋɑ. Ì tɑmɑɑ bɛi ɡbuɡbɑ̃ nwɑi wɑlɑkɔ dɑɑ jiidɑ nwɑi í jɔ̀ mɔkɔu wɑ nɛ ŋɑ? ");
INSERT INTO mkl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aburɑhɑmu do Izɑɑki do Zɑkɔbu ɑŋɑ iyi ɑ̀ jɛ bɑlɑ nwɑ ŋɑu, Aɔ̃ Lɑfɛ̃ɛ nŋɑi í jɔ̀ Jesu woo ce icɛɛ í nɛ ɑmboe. Iŋɛi ì muu ì nɑ inɛ nɡbo ŋɑ nɔ ì kɔsiɛ ŋɑ si wɑjui Pilɑti, bɑɑ do iyi Pilɑti wɑ bi ku jɔ̀ɔ wo. ");
INSERT INTO mkl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ammɑ iŋɛi ì kɔsiɛ, nŋu iyi í jɛ Inɛ Kumɑ́ do Inɛ Dee deeu nɔ ì tɔɔ Pilɑti ku jɔ̀ nŋɛ woo kpɑ inɛu si ɑɡbɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Si bɛɛbɛ ì kpɑ inɛ iyi í jɛ irii kuwɛɛu ŋɑ. Ammɑ Ilɑɑɔ̃ í jũu hɑi si bɑlɛ, nɔ ɑwɑ ɑ̀ yɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesuu do nɑɑnɛ iyi mɔkɔu ihɛ̃ í dɑsiɛ nŋui í jɔ̀ í bɑ ɡbuɡbɑ̃. Mɔkɔ iyi ì wɑɑ yɛ nɔ ì mɑ̀ ŋɑu ihɛ̃, nɑɑnɛ iyi í dɑsi Jesuui í jɔ̀ í bɑ iri mɑm mɑm si wɑjui iŋɛ fei. ");
INSERT INTO mkl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nsɛi kpɑɑsim ŋɑ, ǹ mɑ̀ mii iyi ì ceɑ Jesuu ŋɑ, ì cooi si nɡɔɡɔ hɑi mɑ̀ ŋɑ, bɛɛbɛi do inɛ nɡbo nŋɛ ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ilɑɑɔ̃ í jɔ̀ wɑlii ŋɑu fei ɑ̀ tɑko ɑ̀ fɔ ideɛ wo. Nɔ bɛɛbɛ mɔi bɛi ɑ̀ fɔu fei í kɔ̃. Ide iyi ɑ̀ fɔu nŋui í jɛ ɑ̀ ni, kù nɛ bɛi ɑ́ ce iyi inɛ iyi Ilɑɑɔ̃ í cicɑu kù yɛ ijuukpɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nɑ nŋu, i kpɑɑsi idɔ nŋɛ i sindɑ si Ilɑɑɔ̃ ŋɑ ku bɑ ku kpɑ idei dulum du ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nɔ Ilɑɑɔ̃ ku mu nŋɛ kusĩmi jiidɑ, nɔ ku bɛ Kirisi iyi í cicɑu wɑ ku jɛ tu ŋɛ, nŋu iyi í jɛ Jesuu. ");
INSERT INTO mkl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tilɑsii Jesu Kirisi ku mɑɑ wɑ lele hee ɑwɑɑti koo toò mii fei ku jɛ titɔ̃ si bɛi Ilɑɑɔ̃ í jɔ̀ wɑlii kumɑ́ɛ ŋɑu ɑ̀ tɑko ɑ̀ fɔ wo. ");
INSERT INTO mkl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moizi, inɛ ɑkɑ̃ nŋɑ, í ni, Aɔ̃ Lɑfɛ̃ɛ nŋɛ ɑ́ jɔ̀ wɑlii ɡɔ ku fitɑ hɑi si ɑnini nŋɛ iyi ɑ́ yɛ bɛi ɑmu. Nɔ ɑ́ sĩɑ i ɡbɔ mii iyi ɑ́ sɔ̃ ŋɛ fei. ");
INSERT INTO mkl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Inɛ iyi kù wɑɑ too si idei wɑliiu fei ɑɑ nyɑɑ hɑi si inɔi zɑmɑɑi Ilɑɑɔ̃i ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bɛɛbɛ mɔi Sɑmuɛli do wɑlii ŋɑ iyi ɑ̀ nɑɑ si ɑnyiɛ, ɑŋɑ fei ɑ̀ tɑko ɑ̀ fɔ idei mii ŋɑ iyi wɑ ce nsɛiu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mii iyi wɑlii ŋɑu ɑ̀ ni Ilɑɑɔ̃ ɑ́ ceu, iŋɛi wɑ ceɑ. Nŋui í jɛ ɑkɑbuu iyi Ilɑɑɔ̃ í dĩ do bɑlɑ nŋɛ ŋɑ si wɑɑti iyi í sɔ̃ Aburɑhɑmu í ni, hɑi si dimiɛi ɑn jɔ̀ inɛi ɑndunyɑ fei ku bɑ kuwee. ");
INSERT INTO mkl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bɛɛbɛi Ilɑɑɔ̃ í jɔ̀ woo ce icɛɛ í fitɑ hɑi bi tu ŋɛ nɔ í bɔɔ wɑi ku bɑ ku wee nŋɛ ku bɑ iŋɛ fei i sindɑ i jɔ̀ lɑɑlɔ ku ce nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Si wɑɑti iyi Piɛɛ do Zɑ̃ɑ ɑ̀ wɑɑ sɔ̃ zɑmɑɑu ideu bɛɛbɛ, ŋɔi woo weei Ilɑɑɔ̃ ŋɑu do inɛ nɡboi inɛ ŋɑ iyi ɑ̀ yɑ mɑɑ deɡbe kpɑsɛ̃i Ilɑɑɔ̃u do Sɑdusi ŋɑ ɑ̀ sɛkɛɛ si ŋɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Idɔ nŋɑ í kɔ̃ si nɑ iyi í jɔ̀ mɔcɔ minji ŋɑu ɑ̀ wɑɑ kɔ inɛ ŋɑ si cio ɑ̀ wɑɑ sɔ̃ ŋɑ iyi Jesu í jĩ hɑi si bɑlɛ, wɑɑtɔ iku ŋɑ ɑɑ yɔkɔ ɑ nyi wɑ si kuwɛɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ŋɔi ɑ̀ mu ŋɑ ɑ̀ cĩmbo ŋɑ si ile piisɔ̃ɔ hee iju kumɑ́ domi ɑlɛ í lɛ tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Do nŋu fei, inɛ nkpɔ iyi í ɡbɔ ideu í dɑsi nɑɑnɛ. Nɔ kukpɔ nŋɑ í kɔ̃ɔsi hee í to zɑkɑi ɑmɑnɛ dubu miu. ");
INSERT INTO mkl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iju kumɑ́ɛ ŋɔi inɛ nɡboi Zuifu ŋɑ do inɛ nɡbo bubu ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑu ɑ̀ tɔtɔɔ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ŋɔi ɑ̀ tɔtɔɔ ɑŋɑ do woo wee nlɑu iyi ɑ̀ yɑ kpe Ani, do Kɑifu do Zɑ̃ɑ do Alesɑndu do inɛ ŋɑ iyi ɑ̀ ɡbe si nyɑɑnzei woo wee nlɑu fei. ");
INSERT INTO mkl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ŋɔi ɑ̀ nyɑ Piɛɛ do Zɑ̃ɑ wɑ hɑi ile piisɔ̃ɔu ɑ̀ nɑɑ ɑ̀ leekĩ ŋɑ si wɑju nŋɑ nɔ ɑ̀ lɔsi ku bee ŋɑ ɑ̀ wɑɑ ni, do ɡbuɡbɑ̃i yooi, mɑ̀ do irii yooi ì ceò mii nɔu bɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ŋɔi Piɛɛ í kɔ̃ò Hundei Ilɑɑɔ̃ nɔ í sɔ̃ ŋɑ í ni, iŋɛ ilɑɑlu do inɛ nɡbo ŋɑu, ");
INSERT INTO mkl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ì wɑɑ bee wɑ idei icɛ jiidɑ ŋɑ iyi ɑ̀ ceɑ wɛɛɡɛu ihɛ̃ do bɛi í ce í bɑò iri. ");
INSERT INTO mkl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nɑ nŋu, í sĩɑ iŋɛ fei do inɛi Izirɛli ŋɑu fei i mɑ̀ ŋɑ, mɔkɔ iyi wɑ leekĩ si wɑju nŋɛu bɛ, í bɑ irii do sɑɑbui irii Jesu Kirisi inɛi Nɑzɑrɛtiu, inɛ iyi ì kpɑkpɑ si ɑntɑi jĩi ku ɡɑɑuu ŋɑ nɔ Ilɑɑɔ̃ í jũu hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesui kukɔu wɑ fɑ̃ɑ iyi í ni, Kutɑ iyi woo mɑ ŋɑ ɑ̀ cɑu, Nŋui í bɑɑ í jɛ kutɑ sintei icui ile. ");
INSERT INTO mkl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Woo fɑɑbɑ ɡɔ kù wɛɛ mɑ́ bii kù jɛ nŋu ɑkɑ̃, domi Ilɑɑɔ̃ kù nɑ irii inɛ ɡɔ mɑ́ si ɑndunyɑ iyi ɑɑ kɑ kpe kɑ bɑò fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Iyi inɛ ŋɑu ɑ̀ ɡbɔ ideu ŋɔi ɑ̀ biti domi ɑ̀ yɛ wɔɔkɔi Piɛɛ do Zɑ̃ɑ nɔ ɑ̀ mɑ̀ ɡbɑkɑ̃ iyi tɑ́ɑkɑ ŋɑi iyi ɑ kù ce bɑɑ cio. Ŋɔi ɑ̀ mɑ̀ iyi ɑŋɑi ɑ̀ wɛɛ wo do Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ammɑ si bɛi ɑ̀ yɛ mɔkɔ iyi í bɑ iriu wɑ leekĩ do Piɛɛ do Zɑ̃ɑ, nŋui í jɔ̀ ɑ kù bɑ ide ɡɔ iyi ɑɑ ni mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ŋɔi ɑ̀ ni ɑ fitɑ hɑi ile kiitiu. Iyi ɑ̀ fitɑ, inɛ ŋɑ iyi ɑ̀ ɡbe bɛu ɑ̀ wɑɑ busi njɛ ɑŋɑ duusɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ŋɔi ɑ̀ wɑɑ ni, bɛirei ɑɑ kɑ ceɑ mɔkɔ ŋɑu ihɛ̃. Wee inɛi Zeruzɑlɛmu ŋɑ fei ɑ̀ mɑ̀ iyi ɑ̀ ce mɑɑmɑɑke nlɑ nlɑ ɡɔ, nɔ ɑ kɑɑ kɑ yɔkɔ kɑ jɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ammɑ kɑ ɡɑnji ŋɑ ku bɑ ideu ku mɑɑ̀ fɑnɡɑɑ si inɛ ŋɑ iyi ɑ̀ ɡbe mɑ́, kɑ kɔ̀ nŋɑ do ijuukpɑ̃ ku bɑ ɑ mɑɑ̀ sɔ̃ inɛ kɑ̃mɑ ide do irii Jesu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ŋɔi ɑ̀ kpe ŋɑ mɑ́ nɔ ɑ̀ kɔ nŋɑ ɑ fɔ ide do irii Jesu mɑ́ hee mɑ́ jɛ ɑ kɔ inɛ ŋɑ si cioi ideɛ. ");
INSERT INTO mkl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ammɑ Piɛɛ do Zɑ̃ɑ ɑ̀ sɔ̃ ŋɑ ɑ̀ ni, i bee ɑrɑ nŋɛ ide bii ɑ́ jɛ dee dee si wɑjui Ilɑɑɔ̃ kɑ ɡbɔ ide nŋɛ nɔ kɑ jɔ̀ ti Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Awɑ de ɑ kɑɑ kɑ yɔkɔ kɑ coko do mii iyi ɑ̀ yɛ do iyi ɑ̀ ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ŋɔi ɑ̀ ɡbɑɡbɑ si ŋɑ mɑ́ ntɔ ntɔ ɑ̀ bɛi ɑ̀ jɔ̀ ŋɑ. A kù bɑ yɑɑse bɛi ɑɑ ce ɑ fɑ itĩ nŋɑ si nɑ iyi í jɔ̀ inɛ fei wɑ sɑɑbu Ilɑɑɔ̃ do mii iyi í ceu, ");
INSERT INTO mkl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","domi mɔkɔ iyi ɑ̀ fɑɑbɑ do mɑɑmɑɑkeu, ɑdɔ̃ɛ í re bɑɑ ciiji. ");
INSERT INTO mkl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ŋɔi Piɛɛ do Zɑ̃ɑ ɑ̀ nyi bi kpɑɑsi nŋɑ ŋɑ si wɑɑti iyi woo kiiti ŋɑu ɑ̀ jɔ̀ ŋɑ. Nɔ ɑ̀ koo ɑ̀ sisi nŋɑ ide iyi inɛ nɡbo ŋɑ do inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ ɑ̀ sɔ̃ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iyi ɑ̀ ɡbɔ ideu ŋɔi ɑŋɑ fei ɑ̀ tɔɔ Ilɑɑɔ̃ do ɑnu ɑkɑ̃ ɑ̀ ni, Aɔ̃ Lɑfɛ̃ɛ, ɑwɔi ì tɑkɑ lele do ilɛ do tenku do mii iyi í wɑ si fei. ");
INSERT INTO mkl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Hundeɛi í jɔ̀ bɑlɑ nwɑ Dɑvidi woo ce icɛɛ í fɔ wo í ni, Nɑ mii í ce idɔi inɛi dimi mmu ŋɑ í kɔ̃. Nɑ mii í ce inɛ ŋɑ ɑ̀ wɑɑ ce ɑnu tɔɔsi ɑ bɑ ɑ ceɑ Ilɑɑɔ̃ lɑɑlɔ, nɔ wee mii ɡɔi iyi kɑɑ yɔkɔ ku ce mɔm. ");
INSERT INTO mkl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Amɑnlui ɑndunyɑ ŋɑ do ilu iri ŋɑ ɑ̀ dede nɔ ɑ̀ tɔtɔɔ Ku bɑ ɑ ce iɡũ do Ilɑɑɔ̃ do inɛ iyi í cicɑ. ");
INSERT INTO mkl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ilɑɑɔ̃ Bɑɑbɑ, ide iyi Dɑvidi í fɔu bɛ ntɔi, domi Herodu do Pɔnsu Pilɑti ɑ̀ ce ɑnu ɑkɑ̃. À tɔtɔɔ do dimi mmu ŋɑ do inɛi Izirɛli ŋɑ si iluu ihɛ̃ ɑ̀ yɛ tɑɑlei Jesu woo ce icɛ kumɑ́ɛ iyi ì cicɑ ì nyɑ ikɑ̃u. ");
INSERT INTO mkl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bɛɛbɛi ɑ̀ ce, nɔ nŋu bɛ í jɔ̀ mii iyi ì jilɛ fei hɑi tɑko do iyi í jɛ idɔɔbiɛ í kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nɑ nŋu nsɛi, Lɑfɛ̃ɛ, ce lɑɑkɑii ide ku fɔ nŋɑ nɔ i jɔ̀ ɑwɑ woo ce icɛɛ ŋɑu kɑ sisi ideɛu do wɔɔkɔ nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nyisi ɡbuɡbɑ̃ɛ ku bɑ mɑɑmɑɑke ŋɑ ku ce nɔ inɛ ŋɑ ɑ bɑ iri do sɑɑbui irii Jesu woo ce icɛ kumɑ́ɛu. ");
INSERT INTO mkl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Iyi ɑ̀ ce kutɔɔu ɑ̀ tɑ̃ ŋɔi inyɑ bii ɑ̀ tɔtɔɔu í yɑyɑ. Ŋɔi ɑŋɑ fei ɑ̀ kɔ̃ò Hundei Ilɑɑɔ̃ nɔ ɑ̀ wɑsi ku wɑɑzo idei Ilɑɑɔ̃ bɛbɛi do wɔɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Akpɔi woo dɑsi Jesu nɑɑnɛ ŋɑu í kɔ̃ɔsi nɔ ɑŋɑ fei ɑ̀ nɛ ɑnu ɑkɑ̃. Inɛ ɡɔ ci yɑ ni mii iyi nŋu í nɛ ti nŋu ɑkɑ̃i ɑmmɑ mii iyi ɑ̀ nɛ fei ti ɑŋɑ feii. ");
INSERT INTO mkl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Do ɡbuɡbɑ̃ nlɑ nlɑi woo bɛ ŋɑu ɑ̀ wɑɑ sisiò kujĩi Lɑfɛ̃ɛ Jesu hɑi si bɑlɛ, nɔ didɔ̃ nlɑ nlɑi Ilɑɑɔ̃ í wɑ si ɑŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Inɛ ɡɔ kù jɛ ɑre si inɔ nŋɑ, domi ɑjɔ minji do ɑjɔ minji fei inɛ ŋɑ iyi ɑ̀ nɛ iko do kpɑsɛ̃ ŋɑ fei ɑ̀ yɑ tɑɑi nɔ ɑ nɑɑò fiɑu wɑ, ");
INSERT INTO mkl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ɑ nɑɑ ɑ nɑ woo bɛ ŋɑu, nɔ ɑ ce ikpɛ̃ɛ si bɛi bukɑɑtɑi inɛ fei í to. ");
INSERT INTO mkl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Bɛɛbɛi Jozɛfu, inɛi Levi ɡɔ iyi ɑ̀ bí Sipu, í ce. Nŋui woo bɛ ŋɑu ɑ̀ yɑ kpe Bɑɑnɑbɑsi, wɑɑtɔ woo muɑ inɛ ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Í tɑ ikoɛ ɡɔ í nɑɑò fiɑu wɑ í nɑɑ í nɑ woo bɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ammɑ mɔkɔ ɡɔ í wɛɛ iyi ɑ̀ yɑ kpe Anɑniɑsi, ɑboɛ mɔ ɑ̀ yɑ kpoo Sɑfirɑ. Mɔkɔu í tɑ ikoɛ ɡɔ, ");
INSERT INTO mkl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","nɔ í jilɛ ikɔ ɑkɑ̃i fiɑu ndɛɛ, iyi í ɡbeu mɔ í koo í nɑ woo bɛ ŋɑu. Nɔ wee ɑboɛ í wɛɛò kumɑ̀siɛ. ");
INSERT INTO mkl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Iyi í nɑ ŋɑ fiɑu ŋɔi Piɛɛ í beeɛ í ni, Anɑniɑsi, bɛirei í ce ì jɔ̀ Seetɑm í lɔ si idɔɛ hee ì wɑɑ sɔɑ Hundei Ilɑɑɔ̃ ibo nɔ ì jɔ̀ bubui fiɑi ikou ndɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Iko iyi ì tɑu ɑwɔ si ì nɔɔ bɑ. Iyi ì tɑɑ ì tɑ̃, fiɑu kù jɛ titɛɛi? To, nɑ mii í jɔ̀ ì ce dimii lɑsɑbuu ihɛ̃. Kù jɛ ɑmɑnɛ ŋɑi ì sɔɑ ibo, Ilɑɑɔ̃i ì sɔɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Iyi Anɑniɑsi í ɡbɔ ideu ɡbɑkɑ̃ ŋɔi í cuku tenɡi bɛ í ku. Ŋɔi inɛ ŋɑ iyi ɑ̀ ɡbɔ ideu fei njo í mu ŋɑ hee í cɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ŋɔi ɑwɑɑsũ ŋɑ ɑ̀ nɑɑ ɑ̀ wo ikuu do ɑcɔ ɑ̀ koo ɑ̀ suu. ");
INSERT INTO mkl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Si ɑnyii isɔ mɛɛtɑ mɑ́, ŋɔi ɑboɛ mɔ í lɔ wɑ. Wee kù mɑ̀ mii iyi í ce mɔkɔi nŋu titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ŋɔi Piɛɛ í beeɛ í ni, fiɑ iyi mɔkɔɛ í nɑɑò wɑu ihɛ̃, bɛɛbɛi ì tɑ iko nŋɛu ŋɑ? Ŋɔi Sɑfirɑ í jɛɑɑ í ni, bɛɛ mbɛ. ");
INSERT INTO mkl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ŋɔi Piɛɛ í beeɛ í ni, bɛirei í ce iŋɛ minji fei ì ce ɑnu ɑkɑ̃ i cɔ lɑɑkɑii Hundei Aɔ̃ Lɑfɛ̃ɛ bɛɛbɛ ŋɑ. Cɔ, inɛ ŋɑ iyi ɑ̀ si mɔkɔɛ ɑ̀ wɑ ɑndɛ koofɑ bɛ, ɑɑ si ɑwɔ mɔ. ");
INSERT INTO mkl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bɛ ɡbɑkɑ̃ ŋɔi ɑbou mɔ í cuku si wɑjui Piɛɛ bɛ í ku. Ŋɔi ɑwɑɑsũ ŋɑu ɑ̀ lɔ bɛ ɑ̀ koo ɑ̀ bɑ í ku, ŋɔi ɑ̀ soo wɑ ɑ̀ nɑɑ ɑ̀ suu kɔkɔi mɔkɔɛ. ");
INSERT INTO mkl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ŋɔi njo í mu inɛi iɡbɛi Jesu ŋɑu ntɔ ntɔ do inɛ ŋɑ iyi ɑ̀ ɡbɔ ideu fei. ");
INSERT INTO mkl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ŋɔi woo bɛ ŋɑu ɑ̀ jɔ̀ mɑɑmɑɑke do nyindɑ nkpɔ í wɑsi ku ce si wɑjui inɛ ŋɑ. Nɔ woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ̀ yɑ tɔtɔɔ bɑntumɑi Sɑlomɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Inɛ kɑ̃mɑ kù bi ku lɔ inɔ nŋɑ do muɑfiti domi ɑ̀ wɑɑ ce njo, ɑmmɑ do nŋu fei ɑ̀ wɑɑ sɑɑbu ŋɑ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ammɑ kukpɔi inɛ ŋɑ iyi ɑ̀ dɑsi Lɑfɛ̃ɛ Jesu nɑɑnɛ ntɔ ntɔ í kɔ̃ɔsi wɑ koo, hɑi inɛmɔkɔ do inɑɑbo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ŋɔi inɛ ŋɑ ɑ̀ wɑsi ku nɑɑò bɔ̃ɔ ŋɑ wɑ si kpɑ̃ɑ ŋɑ. À yɑ nɑɑ ɑ jilɛ ŋɑi si dɑɑyi ŋɑ do si sɛ̃ɛ ŋɑ ku bɑ bii Piɛɛ wɑ lɔ ɑyɑɛ ku bii inɛ ɡɔ ŋɑ si inɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ŋɔi inɛ nkpɔ í wɑsi ku nɑɑò bɔ̃ɔ ŋɑ wɑ do inɛ ŋɑ iyi ɑ̀ nɛ inɛi inɔɔko ŋɑ hɑi ilɛɛkoi Zeruzɑlɛmu ŋɑ, ɑŋɑ fei ɑ̀ nɔ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ammɑ woo wee nlɑi Ilɑɑɔ̃u do inɛ ŋɑ iyi ɑ̀ wɑ si iɡbɛi Sɑduse ŋɑ iyi ɑ̀ wɑ bi tɛɛu fei ɑ̀ dedeò iɡu si ɡɑ̃mɛi woo bɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ŋɔi ɑ̀ mu ŋɑ ɡbɑkɑ̃ ɑ̀ dɑsi ŋɑ piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ŋɔi idũu ɑmɑlekɑi Aɔ̃ Lɑfɛ̃ɛ í nɑɑ í cĩ ɡɑmboi ile piisɔ̃ɔu í nyɑ ŋɑ nɔ í sɔ̃ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","i bɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ i koo i leekĩ bɛ ŋɑ nɔ i sisiɑ inɛ ŋɑ idei kuwɛɛu fei. ");
INSERT INTO mkl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nɔ woo bɛ ŋɑu ɑ̀ ɡbɔ ideu. Amɛɛjumɑ ɡbɑkɑ̃ ŋɔi ɑ̀ bɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ bɛ ɑ̀ wɑsi ku kɔ inɛ ŋɑ si cio. Wee wɑɑti bɛɛbɛ woo wee nlɑi Ilɑɑɔ̃u do inɛɛ ŋɑu ɑ̀ tɔtɔɔ nɔ ɑ̀ kpe iɡbɛi woo kiiti ŋɑu do inɛ nɡboi Izirɛli ŋɑ fei, ɑ̀ bɛi ɑ̀ bɛ woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃ ŋɑu ɑ koo ɑ kpe woo bɛ ŋɑu wɑ hɑi ile piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ammɑ iyi ɑ̀ to ɑ kù yɛ woo bɛ ŋɑu ile piisɔ̃ɔ bɛ. Nɔ ɑ̀ nyi bi inɛ nɡbo ŋɑu mɑ́ ");
INSERT INTO mkl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ɑ̀ ni, iyi ɑ̀ to bɛ ɑ̀ bɑ ile piisɔ̃ɔu wɑ cĩmbo dim dim nɔ ɑ̀ bɑ woo deɡbe ŋɑu ɑ̀ wɑɑ leekĩ ɑndɛ bɛ. Ammɑ iyi ɑ̀ cĩ ɡɑmbo ŋɑu ɑ kù yɛ inɛ kɑ̃mɑ ile bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Iyi inɛ nɡboi woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃u do inɛ nɡboi woo wee ŋɑu ɑ̀ ɡbɔ ideu, ŋɔi ɑ̀ biti ɑ kù mɑ̀ bɛi ideu ɑ́ kpɑ iri. ");
INSERT INTO mkl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ŋɔi inɛ ɡɔ í nɑɑ í sɔ̃ ŋɑ í ni, i ɡbɔ ŋɑ, inɛ ŋɑ iyi ì dɑsi piisɔ̃ɔ ŋɑu ɑ̀ wɑ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ ɑ̀ wɑɑ kɔ inɛ ŋɑ si cio. ");
INSERT INTO mkl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ŋɔi inɛ nɡboi woo deɡbe kpɑsɛ̃i Ilɑɑɔ̃u, nŋu do inɛɛ ŋɑ ɑ̀ koo ɑ̀ ɡbɑ̃ ŋɑ ɑ̀ nɑɑò ŋɑ wɑ bi inɛ nɡbo ŋɑu. Ammɑ kù jɛ do ɡbuɡbɑ̃ domi ɑ̀ wɑɑ ce njoi zɑmɑɑu ɑ mɑɑ nɑ ɑ tɑ ŋɑ kutɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Iyi ɑ̀ nɑɑò ŋɑ wɑ ɑ̀ leekĩ ŋɑ si wɑjui iɡbɛi woo kiiti ŋɑu nɔ woo wee nlɑi Ilɑɑɔ̃u í sɔ̃ ŋɑ ");
INSERT INTO mkl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","í ni, ɑ̀ kɔ̀ nŋɛ mɑm mɑm ɑ̀ ni i mɑɑ̀ yɑ ce wɑɑzo do irii mɔkɔu mɑ́ ŋɑ. Ammɑ wee, ì ce wɑɑzo nŋɛ ì wɑɑ koo ŋɑ hee ì kɔ inɛi Zeruzɑlɛmu ŋɑ fei si cio nŋɛ nɔ ì wɑɑ bi i dɑsi wɑ tɑɑlei ikui mɔkɔu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ŋɔi Piɛɛ do woo bɛ kpɑɑsiɛ ŋɑu ɑ̀ jɛ ɑ̀ ni, tilɑsi idei Ilɑɑɔ̃i ɑɑ kɑ jirimɑ, kù jɛ ti ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Aɔ̃ Lɑfɛ̃ɛi bɑlɑ nwɑ ŋɑi í jĩ Jesuu hɑi si bɑlɛ, inɛ iyi ì kpɑkpɑ si jĩi ì kpɑɑ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ŋɔi Ilɑɑɔ̃ í soo lele í jilɔɔ ɑwɔ njɛɛ ku jɛ ilɑɑlu do Woo fɑɑbɑ nɔ ku muɑò inɛi Izirɛli ŋɑ kpɑ̃ɑ ɑ kpɑɑsi idɔ nŋɑ ku bɑ ku kpɑ idei dulum du ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Awɑi ɑ̀ jɛ sɛɛdɑi mii ŋɑu bɛ, ɑwɑ do Hundei Ilɑɑɔ̃ iyi Ilɑɑɔ̃ í muɑ inɛ ŋɑ iyi ɑ̀ wɑɑ jirimɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iyi ɑ̀ ɡbɔ ideu ŋɔi idɔ nŋɑ í kɔ̃ hee ɑ̀ wɑɑ dɛ ɑ kpɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ammɑ inɛ ɑkɑ̃ nŋɑ iyi ɑ̀ yɑ kpe Gɑmɑliɛ í dede í leekĩ si ɑninii woo kiiti ŋɑu í ni ɑ nyɑ woo bɛ ŋɑu wɑ titɑ̃. Gɑmɑliɛu Fɑrisii wɑ jɛ do woo kɔ inɛ ŋɑ si woodɑ, nɔ í nɛ bɛɛrɛ ntɔ ntɔ bi inɛ fei. ");
INSERT INTO mkl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ŋɔi í sɔ̃ inɛ ŋɑu í ni, iŋɛ inɛi Izirɛli ŋɑ, i lɑɑkɑi ŋɑ do mii iyi ì wɑɑ bi i ceɑ inɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kù kpɛ mɔm titɑ̃ iyi mɔkɔ ɡɔ í nɑɑ ihɛ̃ ɑ̀ yɑ kpoo Tedɑsi nɔ í yɑ mɑɑ so ɑrɑɛ lele bɛi inɛ nlɑ ɡɔ nɔ ɑmɑnɛ bɛi cĩɔ mɛɛ wɑ tooɛ. Ammɑ ɑ̀ kpɑɑ, nɔ mɔcɔɛ ŋɑu fei ɑ̀ fɑnɡɑɑ, nɔ ɑ̀ ɡbɛjɛ ideɛ. ");
INSERT INTO mkl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Si ɑnyiɛ, wɑɑti iyi ɑ̀ nɑ ɑ̀ wɑɑ ce kukɑ, ŋɔi mɔkɔ ɡɔ mɔ í nɑɑ ɑ̀ yɑ kpoo Zudɑsi inɛi Gɑlilee. Nŋu mɔ í jɔ̀ inɛ nkpɔ nkpɔ wɑ tooɛ. Ammɑ ɑ̀ kpɑ nŋu mɔ nɔ inɛ ŋɑ iyi ɑ̀ wɑɑ tooɛu fei ɑ̀ fɑnɡɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nɑ nŋu, bii í jɛ ɑɑ ɡbɔ idem ŋɑ, i jɔ̀ inɛ ŋɑu bɛ ɑ nɛ ŋɑ. Bii í jɛ ideu do icɛ ŋɑ iyi ɑ̀ wɑɑ ceu hɑi bi ɑmɑnɛ ŋɑi wɑ nɑɑ, ɑ́ nɑ ku kpɑ iri. ");
INSERT INTO mkl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ammɑ bii kuce nŋɑu hɑi bi Ilɑɑɔ̃i wɑ nɑɑ, i kɑɑ yɔkɔ i kɑ̃miɑ ŋɑ ŋɑ. I ce lɑɑkɑi i mɑɑ̀ ti i nɑ i mɑɑ bɑ Ilɑɑɔ̃ ku jɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nɔ ɑ̀ ɡbɔ ideɛ. Ŋɔi ɑ̀ kpe woo bɛ ŋɑu ɑ̀ cɑ̃ ŋɑ do kpɔtɔɔ ɑ̀ ni ɑ mɑɑ̀ fɔ ide do irii Jesu mɑ́ ɑ̀ bɛi ɑ̀ jɔ̀ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ŋɔi woo bɛ ŋɑu ɑ̀ nɛ hɑi bi iɡbɛi woo kiiti ŋɑu do inɔ didɔ̃ nlɑ nlɑ si nɑ iyi í jɔ̀ Ilɑɑɔ̃ í kɑ ŋɑ si inɛ ŋɑ iyi ɑ̀ to ɑ mɑɑ yɑɑko ŋɑ nɑ irii Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ajɔ fei si bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ do si inɔ kpɑsɛ̃ ŋɑ ɑ̀ yɑ mɑɑ ce wɑɑzoi lɑɑbɑɑu jiidɑu nɔ ɑ mɑɑ kɔ inɛ ŋɑ si cio wɑɑti kɑ̃mɑ fei ɑ mɑɑ ni Jesui í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Wɑɑti bɛɛbɛ kukpɔi inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesuu wɑ kɔ̃ɔsi. Ŋɔi Zuifu ŋɑ iyi ɑ̀ yɑ fɔ Gɛrɛkiu ɑ̀ wɑɑ ɡbɑɡbɑ si Zuifu ɑlɑlɑ ŋɑu domi si ijɛ iyi ɑ̀ yɑ mɑɑ kpɛ̃ɑ jɑɑɔ̃ ŋɑ wɑɑti kɑ̃mɑ fei ɑ̀ yɑ mɑɑ ɡbɛjɛ jɑɑɔ̃ nŋɑ ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ŋɔi woo bɛ mɑɑteeji ŋɑu ɑ̀ tɔtɔɔ inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu ŋɑu fei ɑ̀ ni, kù sĩɑ kɑ jɔ̀ idei Ilɑɑɔ̃ ku wɑɑzo kɑ mɑɑ ce idei ijɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nɑ nŋu, iŋɛ kpɑɑsi nwɑ ŋɑ, i cicɑ ɑmɑnɛ mɛɛje si inɔ nŋɛ, inɛ ŋɑ iyi ɑ̀ wɑɑ jɛ nŋɑ sɛɛdɑ jiidɑ, iyi ɑ̀ kɔ̃ò Hundei Ilɑɑɔ̃ do bisi, nɔ kɑ kɑ̃ɑ nŋɑ icɛu. ");
INSERT INTO mkl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ammɑ ɑwɑ tɑkɑ nwɑ ɑɑ kɑ mɑɑ ce kutɔɔ nɔ kɑ mɑɑ wɑɑzo idei Ilɑɑɔ̃ wɑɑti kɑ̃mɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Inɛ ŋɑu fei ɑ̀ jɛsi ideu. Ŋɔi ɑ̀ cicɑ Etiɛni iyi í kɔ̃ò Hundei Ilɑɑɔ̃ nɔ nɑɑnɛɛ í lɑ. Si ɑnyii nŋu nɔ ɑ̀ cicɑ Filipu, do Pokɔɔ, do Nikɑnɔɔ, do Timɔɔ, do Pɑmenɑsi, do Nikolɑ inɛi Antiɔsi iyi í too kucei Zuifu ŋɑ wo í bɛi í nɑ í dɑsi Jesu nɑɑnɛu. ");
INSERT INTO mkl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ŋɔi ɑ̀ bɔò ŋɑ bi woo bɛ ŋɑu. Nɔ woo bɛ ŋɑu ɑ̀ ce kutɔɔ ɑ̀ le nŋɑ ɑwɔ si iri ku bɑ ɑ sintiò icɛ. ");
INSERT INTO mkl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bɛɛbɛ mɔi idei Ilɑɑɔ̃ í fɑnɡɑɑ wɑ koo nɔ kukpɔi inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesuu í kɔ̃ɔsi wɑ koo si ilui Zeruzɑlɛmu, nɔ woo weei Ilɑɑɔ̃ nkpɔ í dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wee Etiɛni í nɛ ɡbuɡbɑ̃ ntɔ ntɔ nɔ Ilɑɑɔ̃ í ceɑɑ didɔ̃ nɔ í ce mɑɑmɑɑke do nyindɑ nlɑ ɡɔ ŋɑ si ɑninii inɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ammɑ inɛ ɡɔ ŋɑ ɑ̀ bɑ Etiɛni kɑkɔɔ ku ce. Inɛ ŋɑu ɡɔɡɔ ŋɑ hɑi ilɛi Silisii ɑ̀ nɑɑ do hɑi ilɛi Azii, ɡɔɡɔ ŋɑ mɔ inɛi Sirɛni ŋɑi do Alesɑndiri, ɑŋɑi ɑ̀ jɛ inɛi iɡbɛi Zuifu ɡɔ ŋɑ iyi ɑ̀ yɑ kpe ɑru ŋɑ iyi ɑ̀ jɔ̀. ");
INSERT INTO mkl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ammɑ ɑ kù nɔɔ domi wɑ fɔ idei do bisi do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ŋɔi ɑ̀ muɑ mɔkɔ ɡɔ ŋɑ fiɑ si ɑsii ku bɑ ɑ mɑ́ɑ ide. Nɔ inɛ ŋɑ iyi ɑ̀ muɑɑ fiɑ ŋɑu ɑ̀ sɔ̃ inɛ ŋɑ ɑ̀ ni ɑ̀ ɡbɔ inɛɛu ihɛ̃ wɑ fɔ lɑɑlɔi Moizi do Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bɛɛbɛi ɑ̀ dedeò idɔɔkɔ̃i inɛ ŋɑ, do inɛ nɡbo ŋɑ do woo kɔ inɛ ŋɑ si woodɑ ŋɑ. À sɛkɛɛ si Etiɛni nɔ ɑ̀ muu ɑ̀ bɔòɛ si wɑjui iɡbɛi woo kiiti ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Si ɑnyiɛ ŋɔi ɑ̀ nɑɑò mɔkɔ ɡɔ ŋɑ wɑ iyi ɑ̀ nɑɑ ɑ̀ mɑ́ɑ ide ɑ̀ ni, inɛɛu ihɛ̃ wɑɑti kɑ̃mɑ fei í yɑ mɑɑ fɔ lɑɑlɔi kpɑsɛ̃i Ilɑɑɔ̃u do woodɑi Moizi. ");
INSERT INTO mkl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","À ɡbɔ iyi í fɔ í ni Jesu inɛi Nɑzɑrɛtiu ɑ́ lɛɡɛ kpɑsɛ̃u ihɛ̃ nɔ ku kpɑɑsi dedembɑ ŋɑ iyi Moizi í sɔ̃ wɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Inɛ ŋɑ iyi ɑ̀ wɑ si iɡbɛu fei ɑ̀ kɑ̃si Etiɛni iju ŋɔi ɑ̀ yɛ wɑjuɛ wɑ dɑɑnɑ bɛi wɑjui ɑmɑlekɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ŋɔi woo wee nlɑi Ilɑɑɔ̃u í bee Etiɛni í ni, ideu ntɔi? ");
INSERT INTO mkl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ŋɔi Etiɛni í jɛɑɑ í ni, iŋɛ bɑɑm ŋɑ do kpɑɑsim ŋɑ, i ɡbɔ iyi ǹ wɑ n fɔ. Wɑɑti iyi Aburɑhɑmu bɑlɑ nwɑ í wɑ ilɛi Mesopotɑmi, Ilɑɑɔ̃ ilu ɑmboe í nɑɑ bi tɛɛ. Wɑɑti bɛɛbɛ, kù bɔ Hɑrɑ̃ɑ titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ŋɔi Ilɑɑɔ̃ í sɔ̃ɔ í ni, jɔ̀ ilɛi ideɛ do nyɑɑnzeɛ ŋɑ nɔ i bɔ ilɛ bii ɑn nyisiɛ. ");
INSERT INTO mkl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ŋɔi Aburɑhɑmu í fitɑ hɑi ilɛi inɛi Kɑlɑdee ŋɑ nɔ í koo í bubɑ Hɑrɑ̃ɑ. Hɑi bɛ, si ɑnyii ikui bɑɑɛu ŋɔi Ilɑɑɔ̃ í jɔ̀ í nɑɑ ilɛ bii ì wɑ nsɛi ŋɑu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wɑɑti bɛɛbɛ kù muɑɑ bii kɑ̃mɑ si ilɛu, bɑɑ bii ɑ́ lesi kutɛ titɑ̃. Ammɑ do iyi Aburɑhɑmu kù bí fei Ilɑɑɔ̃ í ceɑɑ kuwɑ̃ í ni nŋu ɑ́ muɑɑ ilɛu nɔ ku jɛ ti nŋu do ɑmɑɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ŋɔi Ilɑɑɔ̃ í sɔ̃ Aburɑhɑmu mɑ́ í ni, tɔkuɛ ŋɑ ɑɑ wɑ si ilɛ mmu ɡɔ, bɛi ɑɑ mu ŋɑ ɑ jɛ ɑru ɑ wɑhɑlɑ ŋɑ zɑkɑi ɑdɔ̃ cĩɔ mɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ilɑɑɔ̃ í nɔ í ni, ɑmui ɑn kiiti dimi iyi ɑ̀ mu ŋɑ ɑruu. Si ɑnyii nŋu tɔkuɛ ŋɑu ɑɑ fitɑ hɑi ilɛ bɛ ɑ bɑɑ ilɛu ihɛ̃ bii ɑɑ tɔɔm. ");
INSERT INTO mkl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wɑɑti bɛɛbɛ Ilɑɑɔ̃ í nɑ Aburɑhɑmu woodɑi bɑnɡo ku dɑsi ku jɛ sɛɛdɑi ɑkɑbuuɛ. Si ɑnyiɛ ŋɔi Aburɑhɑmu í nɑ í bí Izɑɑki nɔ í dɑsiɛ bɑnɡo si ɑjɔ mɛɛjɔsiɑɛ. Bɛɛbɛi Izɑɑki mɔ í ceɑ Zɑkɔbu, nɔ Zɑkɔbu mɔ í ceɑ ɑmɑ mɑɑteejiɛ ŋɑ bɛɛbɛ, ɑŋɑ iyi ɑ̀ jɛ bɑlɑi dimi mɑɑteejii Zuifu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Amɑi Zɑkɔbu ŋɑu ɑ̀ wɑɑ bɑ Zozɛfu ifɔ nŋɑ iɡu ku ce nɔ ɑ̀ muu ɑ̀ tɑɑ inɛ ŋɑ iyi ɑ̀ wɑɑ bɔ ilɛi Ezibiti. Ammɑ Ilɑɑɔ̃ í wɑ ɑnyiɛ, ");
INSERT INTO mkl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ŋɔi í nyɑɑ hɑi si wɑhɑlɑɛ fei. Í muɑɑ bisi nɔ í jɔ̀ í nɛ bɛɛrɛ bi Fɑrɑɔ̃ ilɑɑlui Ezibitiu. Ŋɔi Fɑrɑɔ̃ í coo minjisiɑɛ si ilɛu nɔ í jɔ̀ í jɛ inɛ nɡboi kpɑsɛ̃ɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ŋɔi ɑri í nɑɑ si ilɛi Ezibiti do si ilɛi Kɑnɑɑ̃ fei, í kpɑ̃ inɛ ŋɑ iju ntɔ ntɔ. Bɑlɑ nwɑ ŋɑu ɑ kù bɑ bɑɑ mii iyi ɑɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ŋɔi Zɑkɔbu í ɡbɔ iyi ijɛ í wɑ ilɛi Ezibiti, nɔ í bɛ ɑmɑɛ ŋɑu bɛ ɡbɑkɑ̃ ɑkɑ̃, ɑŋɑ iyi ɑ̀ jɛ bɑlɑ nwɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Iyi ɑ̀ koo bɛ isɛ ɡbeejisiɑ ŋɔi Zozɛfu í tusɛ ɑrɑɛ bi iɡbɑ̃ɛ ŋɑu do ifɔɛ, nɔ Fɑrɑɔ̃ mɔ í tɔtɔɔ í mɑ̀ò ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ŋɔi Zozɛfu í sɔ̃ ŋɑ í ni ɑ koo ɑ kpe Zɑkɔbu bɑɑi nŋu wɑ do nyɑɑnzeɛ ŋɑ fei. Wee inɛ ŋɑu ɑ̀ wɛɛi ɑmɑnɛ kitɑò fɛɛwɑ do miu. ");
INSERT INTO mkl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Bɛɛbɛi Zɑkɔbu í bɔò Ezibiti. Bɛi í ku, bɛ mɔi bɑlɑ nwɑ ŋɑu ɑ̀ ku. ");
INSERT INTO mkl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nɔ ɑ̀ so iku nŋɑ ɑ̀ bɔò Sikɛmu ɑ̀ koo ɑ̀ si ŋɑ si bɑlɛ iyi Aburɑhɑmu í tɑko í rɑ bi ɑmɑi Hemɔɔ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ide iyi Ilɑɑɔ̃ í wɑ̃ò Aburɑhɑmuu, iyi wɑɑtii kuceɛ í mɑɑi wɑ inɛ nwɑ ŋɑ ɑ̀ kpɔ ɑ̀ wɑɑ kɔ̃ɔsi si ilɛi Ezibitiu. ");
INSERT INTO mkl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Si ɑnyii ɑdɔ̃ nkpɔ nkpɔ inɛ mmu ɡɔ í nɑɑ í jɛ bommɑ, inɛ nŋu kù mɑ̀ Zozɛfu. ");
INSERT INTO mkl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nŋui í dĩ ijui inɛ nwɑ ŋɑ nɔ í ce nŋɑ lɑɑlɔ, nɔ í nyi í tilɑsi ŋɑ mɑ́ ɑ nyɔ ɑmɑ kpɔtɔɔ nŋɑ ŋɑ ɑ ku. ");
INSERT INTO mkl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wɑɑti bɛɛbɛi ɑ̀ bí Moizi. Amɑ kpɔtɔɔi iyi í sĩɑ hee í cɑɑ. Ŋɔi ɑ̀ wòo bɛ si kpɑsɛ̃i bɑɑɛ zɑkɑi cukpɑ mɛɛtɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Iyi ɑ̀ koo ɑ̀ jilɔɔ, ŋɔi ɑmɑ inɑɑboi Fɑrɑɔ̃ í so ndɛɛ í muu bɛi ɑmɑi nŋu tɑkɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ŋɔi ɑ̀ kɔɑ Moizi si bisii inɛi Ezibiti ŋɑu fei nɔ í bɑɑ í jɛ ilu ɡbuɡbɑ̃ si ide ku fɔ do si kuceɛ. ");
INSERT INTO mkl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Iyi Moizi í to ɑdɔ̃ ciiji, ŋɔi í dɑsi idɔ nŋu koo cɔ inɛi Izirɛli ŋɑ dimiɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ŋɔi í yɛ inɛi Ezibiti ɡɔ wɑ kpɑ̃ inɛ ɑkɑ̃ nŋɑ iju, ŋɔi í bɔ inɛɛu ku fɑɑbɑ nɔ í cɑ̃ inɛi Ezibitiu í kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Í tɑmɑɑ bɛi inɛi nŋu ŋɑ ɑɑ mɑ̀ iyi Ilɑɑɔ̃ í bɛ nŋu wɑi nŋu ku nɑ ku fɑɑbɑ ŋɑ, ɑmmɑ ɑ kù mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Iju kumɑ́ɛ ŋɔi Moizi í yɛ inɛ Izirɛli minji ɡɔ ŋɑ iyi ɑ̀ wɑɑ jɑ. Ŋɔi wɑ bi ku lɑ ŋɑ, nɔ í ni, kpɑɑsim ŋɑ, iŋɛ iyi ì jɛ nyɑɑnze ɑkɑ̃ ŋɑ, nɑ mii í ce ì wɑɑ wɑhɑlɑ njɛ bɛɛbɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ŋɔi inɛ iyi wɑ wɑhɑlɑ kpɑɑsiɛu í tɑle Moizi í ni, yooi í ceɛ inɛ nɡbo i nɑ i kiiti nwɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","I bi i kpɑ ɑmu mɔ bɛi ì kpɑ inɛi Ezibitiu ɑnɑi? ");
INSERT INTO mkl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Iyi Moizi í ɡbɔ ideu ŋɔi í sɑ í nɛ ilɛi Mɑdiɑ̃ɑ í koo wɑ jɛ inɛ njoo bɛ. Bɛi í so ɑbo nɔ í bí ɑmɑ inɛmɔkɔ minji. ");
INSERT INTO mkl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Si ɑnyii ɑdɔ̃ ciiji ŋɔi ɑjɔ nŋu ɡɔ ɑmɑlekɑ ɡɔ í nɑɑ bi tɛɛ si ɡbɑɑu kɔkɔi ɡeetei Sinɑi. Amɑlekɑu í nɑɑi si ɑmɑ wuɑ tũtũ ɡɔ iyi í ce bɛi wɑ jo. ");
INSERT INTO mkl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Iyi Moizi í yɔɔ ŋɔi í biti. Nɔ í sɛkɛɛ siɛ í bɔ ku cɔɔ, ŋɔi í ɡbɔ ide ku fɔi Aɔ̃ Lɑfɛ̃ɛ wɑ ni, ");
INSERT INTO mkl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ɑmui ǹ jɛ Ilɑɑɔ̃, Lɑfɛ̃ɛi Aburɑhɑmu do Izɑɑki do Zɑkɔbu, bɑlɑɛ ŋɑ. Ŋɔi Moizi í yɑyɑ do njo, kù wɑɑ bi inyɑu ku cɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ŋɔi Aɔ̃ Lɑfɛ̃ɛ í sɔ̃ɔ í ni, bɔ́ bɑɑtɑɛ bɛ, domi inyɑ bii ì wɑɑ leekĩu bɛ inyɑ kumɑ́i. ");
INSERT INTO mkl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Wee ǹ yɛ wɑhɑlɑi inɛm ŋɑ iyi ɑ̀ wɑ ilɛi Ezibiti. Ǹ ɡbɔ kukpɑtɑ nŋɑ, nɔ ǹ kitɑ wɑ n nɑɑ n fɑɑbɑ ŋɑ. To, nsɛi, nɑɑ wɑ, n bɛɛ Ezibiti. ");
INSERT INTO mkl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Moiziu, iyi inɛi Izirɛli ŋɑ ɑ̀ kɔsi wo nɔ ɑ̀ niɑ, yooi í ceɛ inɛ nɡbo woo kiiti, nŋui Ilɑɑɔ̃ í bɛ ku jɛ inɛ nɡbo woo fɑɑbɑ nŋɑ do sobii ɑmɑlekɑ iyi í nɑɑ bi tɛɛ si ɑmɑ wuɑu. ");
INSERT INTO mkl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moiziu nŋui í nyɑ inɛi Izirɛli ŋɑ hɑi ilɛi Ezibiti nɔ í ce nyindɑ ŋɑ do mɑɑmɑɑke ŋɑ si ilɛu do si Tenku Nkpɑu do si ɡbɑɑ zɑkɑi ɑdɔ̃ ciiji. ");
INSERT INTO mkl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moizi tɑkɑɛ í nyi í sɔ̃ inɛi Izirɛli ŋɑu mɑ́ í ni, Ilɑɑɔ̃ ɑ́ bɛ si ŋɛ wɑlii wɑ bɛi ɑmu, iyi ɑ́ jɛ inɛ ɑkɑ̃ nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moizii í tɑko í wɑ bii inɛi Izirɛli ŋɑu ɑ̀ tɔtɔɔ si ɡbɑɑu. Nŋui í wɑ ɑfei bɑlɑ nwɑ ŋɑ do ɑmɑlekɑ iyi í bɑɑ ide ku fɔ si ɡeetei Sinɑiu. Nɔ hɑi bi tɛɛi í ɡbɑ idei kuwɛɛ í nɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ammɑ bɑlɑ nwɑ ŋɑu ɑ kù wɑɑ bi ideɛ ku ɡbɔ. À kɔsiɛ ɑ̀ wɑɑ bi ɑ nyi ikpɑ ilɛi Ezibiti mɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ŋɔi í jɔ̀ ɑ̀ sɔ̃ Arɔ̃ɔ ɑ̀ ni, ce nwɑ iwɛ̃ iyi ɑ́ cuɑ nwɑ si kpɑ̃ɑ domi Moiziu iyi í nyɑ wɑ wɑ hɑi ilɛi Ezibiti ɑ kù mɑ̀ mii iyi í coo. ");
INSERT INTO mkl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ŋɔi ɑ̀ ce iwɛ̃ ɡɔ iyi í jɔ ɑmɑ kɛtɛ, nɔ inɔ nŋɑ í dɔ̃ nɑ icɛi ɑwɔ nŋɑu nɔ ɑ̀ ceɑɑ kuwee. ");
INSERT INTO mkl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nɑ nŋu, Ilɑɑɔ̃ í fɑ ɑrɑɛ hɑi bi tu ŋɑ nɔ í jɔ̀ ɑ̀ wɑɑ tɔɔ inunu do cukpɑ do ɑndɑiyɑ ŋɑ. Ide nŋui ɑ̀ kɔ si tiɑi wɑlii ŋɑu ɑ̀ ni, Ilɑɑɔ̃ í ni, Iŋɛ inɛi Izirɛli ŋɑ, kù jɛ ɑmui í ceɑ dimii kuwee ikɑ̃ ikɑ̃ Adɔ̃ ciiji si ɡbɑɑ ihɛ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ammɑ iwɛ̃ ŋɑ iyi iŋɛ tɑkɑ nŋɛ ì ce ŋɑi ì ceɑ kuwee ŋɑ. Ilei ɑcɔi iwɛ̃ Mɔlɔkui ì yɑ mɑɑ so ŋɑ do ɑndɑiyɑi iwɛ̃ Refɑ̃ɑ. Nɑ ŋɔi í jɔ̀ ɑn jɔ̀ ɑ mu ŋɛ ɑ nɛò ŋɛ hee ilɛi Bɑbilɔni. ");
INSERT INTO mkl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nɔ Etiɛni í ni mɑ́, bɑlɑ nwɑ ŋɑu ɑ̀ nɛ ilei ɑcɔ si ɡbɑɑu, nŋui wɑ nyisi iyi Ilɑɑɔ̃ í wɛɛ do ɑŋɑ. Moizi í cooi bɛi Ilɑɑɔ̃ í nyisiɛ í ni ku coou. ");
INSERT INTO mkl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ilei ɑcɔu, bɑlɑ nwɑ ŋɑ iyi ɑ̀ nɑɑ si ɑnyii inɛ sinte ŋɑu, ɑŋɑ do Zozue woo cuɑ nŋɑ ɑ̀ soo ɑ̀ nɛò wɑ ilɛu ihɛ̃. Ilɛu Ilɑɑɔ̃i í lele dimi ŋɑ iyi ɑ̀ tɑko ɑ̀ wɑ si wo. Nɔ ilei ɑcɔu í wɑ ihɛ̃ hee wɑɑtii ilɑɑlu Dɑvidi. ");
INSERT INTO mkl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Si bɛi Dɑvidi í bɑ didɔ̃i Ilɑɑɔ̃, nŋui í jɔ̀ í tɔɔɛ ku jɔ̀ nŋu ku mɑɑ ile tenɡi bii tɔkui Zɑkɔbu ŋɑ ɑɑ yɑ ɡulɛɑɑ . ");
INSERT INTO mkl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ammɑ Sɑlomɔɔi í mɑɑ ileu. ");
INSERT INTO mkl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ammɑ Ilɑɑɔ̃ kù nɛ sɑɑ. Ci yɑ wɑ si ile iyi ɑmɑnɛ ŋɑ ɑ̀ mɑ. Bɛɛbɛi wɑlii ɡɔ í tɑko í fɔ wo í ni, ");
INSERT INTO mkl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ilɑɑɔ̃ í ni, lelei í jɛ kitɑ̃i bommɑm, Nɔ ilɛ í jɛ bi ku lesi isɛm. Debɛi, dimii ile yoomɑi ɑɑ yɔkɔ i mɑɑm ŋɑ. Mɑ̀ iwoi inyɑ í wɑ bii ɑn yɑ n sĩmi. ");
INSERT INTO mkl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kù jɛ ɑmui ǹ ce fei ndɛɛ? ");
INSERT INTO mkl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nɔ Etiɛni í ni mɑ́, iŋɛ inɛ ku ɡɑɑbu ŋɑi, idɔ nŋɛ do itĩ nŋɛ fei í le. Ì yɑ mɑɑ kɔsi Hundei Ilɑɑɔ̃ ŋɑi wɑɑti kɑ̃mɑ fei. Iŋɛ mɔ ì wɑɑ ce bɛi bɑlɑ nŋɛ ŋɑ ɑ̀ tɑko ɑ̀ ce wo. ");
INSERT INTO mkl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wɑlii yoomɑ ŋɑi bɑlɑ nŋɛ ŋɑ ɑ kù kpɑ̃ iju. À kpɑ hee do inɛ ŋɑ iyi ɑ̀ fɔ kunɑɑi Inɛ Dee deeu, inɛ iyi iŋɛ tɑkɑ nŋɛ ì zɑmbɑɛ si nsɛi ì kpɑɑ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Iŋɛ iyi do sɑɑbui ɑmɑlekɑ ŋɑu Ilɑɑɔ̃, í nɑ ŋɛ woodɑɛ, i kù too si woodɑu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iyi inɛ ŋɑu ɑ̀ ɡbɔ ideu ŋɔi idɔ nŋɑ í kɔ̃ si Etiɛni hee ɑ̀ wɑɑ ŋɔ ɑmɑɑwɔ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ammɑ Etiɛni í kɔ̃ò Hundei Ilɑɑɔ̃ nɔ í cɔ lele, ŋɔi í yɛ ɑmboei Ilɑɑɔ̃ nɔ í yɛ Jesu mɔ wɑ leekĩ do ikpɑ ɑwɔ njɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ŋɔi í ni, i ɡbɔ ŋɑ, ǹ yɛ lele í cĩ nɔ Amɑi Amɑnɛ wɑ leekĩ do ikpɑ ɑwɔ njɛi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ammɑ ɑ̀ dĩ itĩ nŋɑ ɑ̀ bɛi ɑ̀ dɔ̃ ɑnu nlɑ nlɑ nɔ ɑ̀ sɛi ɑjɔ ɑ̀ koo ɑ̀ wo siɛ. ");
INSERT INTO mkl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ŋɔi ɑ̀ fɑɑ hɑi inɔ ilu ɑ̀ koo ɑ̀ nyɔɔ ku bɑ ɑ tɑɑ kutɑ ɑ kpɑɑ. Ŋɔi inɛ ŋɑ iyi ɑ̀ tɑko ɑ̀ mɑ́ɑ ideu ɑ̀ bɔ kumboo nŋɑ ŋɑ ɑ̀ jɔ̀ɑ ɑwɑɑsũ ɡɔ bɛ ɑ̀ yɑ kpoo Sɔlu. ");
INSERT INTO mkl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Si bɛi ɑ̀ wɑɑ tɑ Etiɛni kutɑu ŋɔi Etiɛni í ce kutɔɔ í ni, Lɑfɛ̃ɛ Jesu, ɡbɑ hundem. ");
INSERT INTO mkl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ŋɔi í cuku í ɡulɛ wɑ dɔ̃ ɑnu hee lele wɑ ni, Lɑfɛ̃ɛ, mɑɑ̀ mu ŋɑ do dulum nɔu ihɛ̃. Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi í ku. ");
INSERT INTO mkl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nɔ wɑɑtii kukpɑi Etiɛniu Sɔlu mɔ í jɛsi. Hɑi ɑjɔ nŋu bɛi ɑ̀ sinti ku kpɑ̃ inɛi iɡbɛi Jesu ŋɑ iyi ɑ̀ wɑ Zeruzɑlɛmu iju. Bii kù jɛ woo bɛ ŋɑu bɑɑsi, woo dɑsi Jesu nɑɑnɛ ŋɑu fei ɑ̀ fɑnɡɑɑi si ilɛi Zudee do si ilɛi Sɑmɑri. ");
INSERT INTO mkl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nɔ inɛ ɡɔ ŋɑ iyi ɑ̀ mɑ̀ bɛɛrɛi Ilɑɑɔ̃ ɑ̀ si Etiɛni do kukpɑtɑ. ");
INSERT INTO mkl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ammɑ Sɔlu í wɑsi inɛi iɡbɛi Jesu ŋɑ ku kpɑ̃ iju. Í yɑ lɔ kpɑsɛ̃ do kpɑsɛ̃ ŋɑi ku mɑɑ mu inɛmɔkɔ do inɑɑbo ŋɑ do ɡbuɡbɑ̃ koo dɑsi ŋɑ piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Inɛ ŋɑ iyi ɑ̀ fɑnɡɑɑu ɑ̀ koo ɑ̀ wɑɑ wɑɑzo lɑɑbɑɑu jiidɑu bii fei. ");
INSERT INTO mkl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipu í bɔ ilu nlɑi Sɑmɑri nɔ wɑ ceɑ inɛi ilu bɛ ŋɑ fɑɑjii inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Nɔ í ce mɑɑmɑɑke ŋɑ. Í lele inɛi inɔɔko ŋɑ hɑi si inɛ nkpɔ nɔ ɑ̀ fitɑ do ɑnu ku dɔ̃ nlɑ nlɑ, nɔ í jɔ̀ wɛɛɡɛ nkpɔ do ilu kutɛ ɑkɑ̃ ŋɑ ɑ̀ bɑ iri. Iyi inɛ ŋɑ ɑ̀ wɑɑ ɡbɔ wɑɑzoɛu nɔ ɑ̀ yɛ mɑɑmɑɑke ŋɑu, ŋɔi ɑŋɑ fei ɑ̀ teese ɑ̀ de itĩ jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nɔ inɛi ilu ŋɑu ɑ̀ wɛɛò inɔ didɔ̃ nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wee mɔkɔ ɡɔ mɔ í wɑ si iluu bɛ, ɑ̀ yɑ kpoo Simɔɔ. Í yɑ mɑɑ ce dobu dobu í jɔ̀ inɛi ilu ŋɑu fei ɑ̀ biti nɔ í ce ɑrɑɛ inɛ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Hɑi ɑmɑ keeke do inɛ nɡbo fei ɑ̀ yɑ ɡbɔ ideɛ ntɔ ntɔ nɔ ɑ̀ yɑ mɑɑ ni, inɛɛu ihɛ̃i í jɛ inɛ iyi ɑ̀ yɑ kpe ɡbuɡbɑ̃ nlɑi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","À yɑ mɑɑ ɡbɔ ideɛi domi hɑi kukpɛ dobu dobuɛ ŋɑu í yɑ mɑɑ mu ŋɑ bitii. ");
INSERT INTO mkl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ammɑ iyi inɛ ŋɑu ɑ̀ dɑsi nɑɑnɛ si lɑɑbɑɑu jiidɑ iyi Filipu wɑ fɔ si ɡɑ̃mɛi bommɑi Ilɑɑɔ̃ do si ɡɑ̃mɛi Jesu Kirisiu, ŋɔi ɑ̀ dɑsi ŋɑ inyi hɑi inɛmɔkɔ do inɑɑbo fei. ");
INSERT INTO mkl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔɔ tɑkɑɛ í dɑsi Jesu nɑɑnɛ nɔ ɑ̀ dɑsiɛ inyi. Í yɑ mɑɑ too Filipu bii fei nɔ í biti ntɔ ntɔ iyi í yɛ mɑɑmɑɑke nlɑ ŋɑ iyi wɑ ce. ");
INSERT INTO mkl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Woo bɛ ŋɑu ɑ̀ ɡbɔ iyi inɛi Sɑmɑri ŋɑu ɑ̀ ɡbɑ idei Ilɑɑɔ̃. Ŋɔi ɑ̀ bɛ si ŋɑ Piɛɛ do Zɑ̃ɑ hɑi Zeruzɑlɛmu bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Iyi ɑ̀ to ŋɔi ɑ̀ ce nŋɑ kutɔɔ ku bɑ ɑ bɑ Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","À ce bɛɛbɛi si nɑ iyi í jɔ̀ Hundei Ilɑɑɔ̃ kù kitɑ si kɑ̃mɑ nŋɑ wɑ titɑ̃, ɑŋɑ de ɑ̀ ce inyi ku dɑsi nŋɑi do irii Lɑfɛ̃ɛ Jesu nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ŋɔi Piɛɛ do Zɑ̃ɑ ɑ̀ le nŋɑ ɑwɔ si iri, nɔ ɑ̀ bɑ Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Iyi Simɔɔ í yɛ woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ̀ bɑ Hundei Ilɑɑɔ̃ wɑɑti iyi woo bɛ ŋɑu ɑ̀ le nŋɑ ɑwɔ si iriu, ŋɔi wɑ bi ku mu nŋɑ fiɑ. ");
INSERT INTO mkl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Í ni ɑ muɑ nŋu ɡbuɡbɑ̃u bɛ ku bɑ inɛ iyi nŋu ɑ́ leɑ ɑwɔ si iri fei ku bɑ Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ammɑ Piɛɛ í sɔ̃ɔ í ni, ɑwɔ do fiɑɛ fei ɑɑ ce nfe, domi ì tɑmɑɑ bɛi ɑɑ yɔkɔ i rɑ ɑmuɑi Ilɑɑɔ̃ do fiɑi. ");
INSERT INTO mkl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","I kù nɛ kpɑ̃ɑi nɡɔɡɔ ihɛ̃ domi idɔɛ kù jɛ dee dee si wɑjui Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nɑ nŋu, sindɑ idɔɛ hɑi si lɑɑlɔ ku ceɛ, nɔ i tɔɔ Ilɑɑɔ̃ ku ceɛ suurui lɑsɑbu lɑɑlɔ ku ceɛ bii ɑ́ ce. ");
INSERT INTO mkl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ǹ wɑ n fɔ bɛɛbɛi si nɑ iyi í jɔ̀ ǹ yɛ dɑɑɛ í ro nɔ dulum í dĩɛ. ");
INSERT INTO mkl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ŋɔi Simɔɔ í jɛ nŋɑ í ni, iŋɛ tɑkɑ nŋɛ i ceem kutɔɔ bi Lɑfɛ̃ɛ ku bɑ ide ŋɑ iyi ì sɔ̃m ŋɑu bɛ kɑ̃mɑɛ ku mɑɑ̀ bɑm. ");
INSERT INTO mkl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wɑɑti iyi ɑ̀ ce wɑɑzo ɑ̀ sisiɑ inɛ ŋɑ yɑɑsei idei Ilɑɑɔ̃ ɑ̀ tɑ̃ ŋɔi ɑ̀ sindɑ ɑ̀ wɑɑ nyi Zeruzɑlɛmu. Iyi ɑ̀ wɑɑ nɛ, ŋɔi ɑ̀ wɑsi ku sisi lɑɑbɑɑu jiidɑu si ilu nkpɔi Sɑmɑri mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ŋɔi ɑmɑlekɑi Lɑfɛ̃ɛ ɡɔ í bɑ Filipu ide ku fɔ í ni, dede i bɔ ikpɑ ɑwɔ cɑnɡɑi kpɑ̃ɑi inunu, too kpɑ̃ɑ iyi í wɑ hɑi Zeruzɑlɛmu ku bɔ Gɑzɑ. Kpɑ̃ɑ nŋui í bɔ ikpɑ ɡbɑbuɑu bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ŋɔi Filipu í dede í nɛ. Si kpɑ̃ɑu, ŋɔi í yɛ inɛi Etiopi ɡɔ. Inɛɛu ɑkɑwe nlɑ nlɑi. Nŋui í yɑ mɑɑ mu ɑmɑnii inɑɑbo ilɑɑlui Etiopi. Í nɑɑ Zeruzɑlɛmui Ilɑɑɔ̃ ku ɡulɛɑ, ");
INSERT INTO mkl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ŋɔi í sindɑ wɑ bɔ ikpɑ ideɛ mɑ́. Wɑ bubɑ si sɑrɛtii ɑcĩ wɑ cio tiɑ iyi wɑlii Ezɑi í kɔ. ");
INSERT INTO mkl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ŋɔi Hundei Ilɑɑɔ̃ í sɔ̃ Filipu í ni ku bɔ kɔkɔi sɑrɛtiu. ");
INSERT INTO mkl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ŋɔi Filipu í sɛi í bɔ bi sɑrɛtiu, nɔ í ɡbɔ inɛi Etiopiu wɑ cio si tiɑi wɑlii Ezɑiu. Nɔ í beeɛ í ni, ide iyi ì wɑɑ ciou bɛ ì wɑɑ ɡbɔ bɛi wɑ fɔ mbɛ? ");
INSERT INTO mkl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ŋɔi inɛɛu í jɛɑɑ í ni, bɛirei ɑn ce n ɡbɔ bii kù jɛ inɛ ɡɔi í tusɛɛm. Ŋɔi í tɔɔ Filipu ku ɡũ wɑ si sɑrɛtiu ku bubɑ bi nŋu. Nɔ Filipu í ɡũ. ");
INSERT INTO mkl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ide iyi mɔkɔu wɑ cio si kukɔi idei Ilɑɑɔ̃ wee. À kooòɛ bɛi ɑnɡudɑ̃ iyi ɑɑ sɑkɑ. Bɛi ɑmɑ ɑnɡudɑ̃ í yɑ mɑɑ coko wɑɑti iyi ɑ̀ wɑɑ bu ntoɛ, Bɛɛbɛ mɔi nŋu mɔ kù lɑ ɡɛlɛ. ");
INSERT INTO mkl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","À kɑyeɛ nɔ ɑ̀ kɔ ku kiitiɛ dee dee. Si bɛi ɑ̀ kpɑ irii kuwɛɛɛ, kù wɑ si ilɛu ihɛ̃ mɑ́, Yooi ɑ́ fɔ idei inɛi ɑnyiɛ ŋɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ŋɔi ɑkɑweu í sɔ̃ Filipu í ni, ǹ wɑ n tɔɔɛ i sɔ̃m inɛ iyi wɑliiu wɑ fɑ̃ɑ. Nŋu tɑkɑɛi wɑ fɑ̃ɑ ɑrɑɛ de. Mɑ̀ inɛ ɡɔi wɑ fɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ŋɔi Filipu í so ide í sinti do idei wɑliiu í sisiɑɑò lɑɑbɑɑu jiidɑi Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Si bɛi ɑ̀ wɑɑ nɛ si kpɑ̃ɑu ŋɔi ɑ̀ to ido ɡɔ iyi í nɛ inyi. Ŋɔi ɑkɑweu í ni, cɔ inyi ihɛ̃. To, mii ɑ́ ɡɑnjim n ce inyi ku dɑsim mɑ́.  ");
INSERT INTO mkl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ŋɔi Filipu í sɔ̃ɔ í ni, bii ì dɑsi Jesu nɑɑnɛ do idɔɛ fei ɑɑ yɔkɔ i ce inyi ku dɑsiɛ mɛɛ. Nɔ ɑkɑweu í jɛ í ni, ǹ dɑsi nɑɑnɛ iyi Jesu Kirisi Amɑi Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ŋɔi í ni ɑ leekĩ sɑrɛtiu. Iyi ɑ̀ leekĩɛ nɔ nŋu do Filipu ɑ̀ kitɑ ɑŋɑ minji nŋɑ si inyiu, nɔ Filipu í dɑsiɛ inyi. ");
INSERT INTO mkl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Iyi ɑ̀ fitɑ hɑi si inɔ inyiu, ŋɔi Hundei Aɔ̃ Lɑfɛ̃ɛ í nɛò Filipu. Nɔ ɑkɑweu kù yɔɔ mɑ́, ɑmmɑ í dɑsi kpɑ̃ɑ wɑ nɛ do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ŋɔi Filipu í bɑ nŋu í wɑ ilu ɡɔ iyi ɑ̀ yɑ kpe Azɔtu, nɔ í ce wɑɑzoi lɑɑbɑɑu jiidɑ bɛ do ilu ŋɑ iyi ɑ̀ wɑ si kpɑ̃ɑu fei hee í toò Sezɑree. ");
INSERT INTO mkl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Wɑɑti bɛɛbɛ Sɔlu í yɑ mɑɑ kpɑ̃ inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu ŋɑu iju nɔ wɑ bi ku kpɑ ŋɑ mɔm nii. Nɑ ŋɔi í jɔ̀ í bɔ bi woo wee nlɑi Ilɑɑɔ̃u, ");
INSERT INTO mkl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","í tɔɔɛ ku ceɑ nŋu tiɑ ŋɑ. Tiɑ ŋɑui ɑ́ koo ku nɑ inɛ nɡboi ile bi ku ce kutɔtɔɔ ŋɑ iyi ɑ̀ wɑ Dɑmɑsi. Do sɑɑbui tiɑ ŋɑui ɑ́ bɑò ɡbuɡbɑ̃ iyi ɑ́ koo ku muò inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu, bii inɛmɔkɔi wɑlɑ bii inɑɑboi, ku bɑ ku yɔkɔ ku dĩ ŋɑ ku bɔò ŋɑ Zeruzɑlɛmu. Iyi í ɡbɑ tiɑ ŋɑu nɔ í dɑsi kpɑ̃ɑ wɑ nɛ. ");
INSERT INTO mkl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Si bɛi Sɔlu wɑ nɛ í mɑɑi Dɑmɑsi, ŋɔi ɑnu ɑkɑ̃ inyɑ kumɑ ɡɔ í nɑɑ siɛ wɑ hɑi lele. ");
INSERT INTO mkl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ŋɔi í cuku ilɛ nɔ í ɡbɔ imui inɛ ɡɔ í ni, Sɔlu, Sɔlu, nɑ mii í ce ì wɑɑ kpɑ̃m iju. ");
INSERT INTO mkl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ŋɔi Sɔlu í bee í ni, Lɑfɛ̃ɛ, ɑwɔi yoo. Ŋɔi Lɑfɛ̃ɛ í jɛɑɑ í ni, ɑmui Jesu iyi ì wɑɑ kpɑ̃ ijuu. ");
INSERT INTO mkl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Dede i bɔ inɔ iluu, bɛi ɑɑ sɔ̃ɛ mii iyi ɑɑ ce. ");
INSERT INTO mkl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wɑɑti bɛɛbɛ inɛ ŋɑ iyi ɑ̀ wɑɑ nɛ do Sɔluu ɑ̀ leekĩ ɑ̀ coko sɔ̃m sɔ̃m, ɑ̀ ɡbɔ ide ku fɔu ɑmmɑ ɑ kù yɛ inɛ kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ŋɔi Sɔlu í dede hɑi ilɛ í cĩ ijuɛ ɑmmɑ kù yɛ ilu. Ŋɔi ɑ̀ mu ɑwɔɛ ɑ̀ bɔòɛ Dɑmɑsi. ");
INSERT INTO mkl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Í fɛɛju zɑkɑi ɑjɔ mɛɛtɑ, kù jɛ kù mɔ. ");
INSERT INTO mkl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wee mɔcɔi Jesu ɡɔ í wɑ Dɑmɑsi bɛ ɑ̀ yɑ kpoo Anɑniɑsi. Ŋɔi Lɑfɛ̃ɛ Jesu í nɑɑ siɛ si kuyɛ í kpoo í ni, Anɑniɑsi. Nɔ í jɛ í ni, Amu wee Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ŋɔi Lɑfɛ̃ɛ í sɔ̃ɔ í ni, dede i koo i mu kpɑ̃ɑ iyi ɑ̀ yɑ kpe Kpɑ̃ɑ Kutɛu i bɔ idei Zudɑsi. Bii ì to bɛ bee mɔkɔ ɡɔ iyi ɑ̀ yɑ kpe Sɔlu inɛi Tɑrusiu. Wɑ ce kutɔɔ, ");
INSERT INTO mkl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","nɔ í ce kuyɛ í yɛ mɔkɔ ɡɔ iyi ɑ̀ yɑ kpe Anɑniɑsi í lɔ wɑ nɔ í lesi nŋu ɑwɔ ku bɑ nŋu ku yɛ ilu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ammɑ Anɑniɑsi í ni, Lɑfɛ̃ɛ, inɛ nkpɔi í sɔ̃m lɑɑbɑɑui mɔkɔu bɛ do lɑɑlɔ ŋɑ iyi í ceɑ inɛɛ ŋɑ Zeruzɑlɛmu fei. ");
INSERT INTO mkl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nɔ ɑ̀ ɡbɔ iyi inɛ nɡboi woo wee ŋɑi ɑ̀ nɑɑ ɡbuɡbɑ̃ ku mu inɛ ŋɑ iyi ɑ̀ wɑɑ ce kutɔɔ do iriɛ ihɛ̃ fei. ");
INSERT INTO mkl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ammɑ Lɑfɛ̃ɛ í sɔ̃ɔ í ni, koo, domi ǹ cicɑ inɛɛu bɛi ku jɛ woo ce icɛm ku fɔ lɑɑbɑɑui irim bi dimi mmu ŋɑ do bi ilɑɑlu nŋɑ ŋɑ do bi inɛi Izirɛli ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","An nɔ n nyisiɛ bɛi nŋu mɔ ɑ́ yɛ ijuukpɑ̃ nɑ irim. ");
INSERT INTO mkl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ŋɔi Anɑniɑsi í dede í koo. Iyi í to, ŋɔi í lesi Sɔlu ɑwɔ í ni, Sɔlu kpɑɑsim, Jesu Lɑfɛ̃ɛ, nŋu iyi í nɑɑ siɛ si kpɑ̃ɑu si wɑɑti iyi ì wɑɑ nɑɑ, nŋui í bɛm wɑ ku bɑ i yɛ ilu mɑ́ nɔ i kɔ̃ò Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bɛ ɡbɑkɑ̃ nɡɔɡɔ í cuku wɑ hɑi si ijui Sɔlu í yɛ bɛi kpɑkɑi cɛ̃ɛ, nɔ í yɛ ilu mɑ́. Ŋɔi í dede nɔ ɑ̀ dɑsiɛ inyi. ");
INSERT INTO mkl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Si ɑnyiɛ ŋɔi í jɛ sɔndɑ nɔ ɡbuɡbɑ̃ɛ í bɑɑ mɑ́. Nɔ Sɔlu í ce ɑjɔ minji Dɑmɑsi bɛ do inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Gbɑkɑ̃ í bɔ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ ŋɑ wɑ wɑɑzo wɑ fɔ iyi Jesu Amɑi Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Inɛ ŋɑ iyi ɑ̀ wɑɑ ɡbɔ ideɛu fei ɑ̀ biti ɑ̀ bee njɛ ɑ̀ wɑɑ ni, kù jɛ mɔkɔu iyi í yɑ mɑɑ wɑhɑlɑ inɛ ŋɑ iyi ɑ̀ wɑɑ ce kutɔɔ do irii Jesu Zeruzɑlɛmuu mbɛ yɑ. Kù jɛ nŋui wɑ nɑɑ ihɛ̃ wo ku nɑ ku mu inɛ ŋɑ ku dĩ ŋɑ koo nɑ inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu? ");
INSERT INTO mkl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ammɑ ɡbuɡbɑ̃i Sɔlu í yɑ mɑɑ kɔ̃ɔsii, nɔ Zuifu ŋɑ iyi ɑ̀ wɑ Dɑmɑsiu ɑ kù mɑ̀ bɛi ɑɑ jɛɑɑ wɑɑti iyi wɑ sɔ̃ ŋɑ kɑm kɑm iyi Jesui í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Zɑkɑi ɑjɔ minji mɑ́ ŋɔi Zuifu ŋɑu ɑ̀ wɑɑ busi njɛ ɑ bɑ ɑ kpɑ Sɔlu. ");
INSERT INTO mkl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ammɑ inɛ ɡɔ í koo í sisiɑ Sɔlu ide iyi inɛ ŋɑu ɑ̀ dĩu. Inɛ ŋɑu ɑ̀ yɑ mɑɑ deɡbe iluui hee do ɑndɛ koofɑ ŋɑu fei dɑsɑ̃ do idũ ku bɑ ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ammɑ idũ ɡɔ mɔcɔi Sɔlu ŋɑ ɑ̀ jɔ̀ í lɔ inɔ kɔlɔ ɑ̀ bɛi ɑ̀ koo ɑ̀ kitɑɛ hɑi do ɑntɑi bindii iluu. ");
INSERT INTO mkl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ŋɔi Sɔlu í bɔ Zeruzɑlɛmu. Iyi í to bɛ í bi ku tɔtɔɔ do inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesuu, ɑmmɑ ɑŋɑ fei ɑ̀ wɑɑ ce njoɛ si nɑ iyi í jɔ̀ ɑ kù mɑ̀ mɑ̀ ntɔ ntɔ wɑ too kpɑ̃ɑi Jesui. ");
INSERT INTO mkl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ŋɔi Bɑɑnɑbɑsi í bɔòɛ bi woo bɛ ŋɑu nɔ í sɔ̃ ŋɑ bɛi Sɔlu í yɛ Lɑfɛ̃ɛ si kpɑ̃ɑ, do bɛi Lɑfɛ̃ɛ í bɑɑ ide ku fɔ. Nɔ í sɔ̃ ŋɑ bɛi Sɔlu í ce wɑɑzo Dɑmɑsi do irii Jesu do wɔɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hɑi wɑɑti bɛɛbɛi Sɔlu wɑ dɑbii si ilui Zeruzɑlɛmu do woo bɛ ŋɑu wɑ wɑɑzo do irii Lɑfɛ̃ɛ Jesu do wɔɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nɔ í ce kɑkɔɔ do Zuifu ŋɑ iyi ɑ̀ wɑɑ fɔ Gɛrɛkiu, ɑmmɑ ɑŋɑ mɔ ɑ̀ wɑɑ dɛ kpɑ̃ɑ bɛi ɑɑ ce ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Iyi kpɑɑsi woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ̀ ɡbɔ, ŋɔi ɑ̀ bɔòɛ Sezɑree nɔ ɑ̀ jɔ̀ í nɛ Tɑrusi. ");
INSERT INTO mkl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Inɛi iɡbɛi Jesu ŋɑ iyi ɑ̀ wɑ ilɛi Zudee do ilɛi Gɑlilee do ilɛi Sɑmɑri fei ɑ̀ wɛɛò lɑɑkɑi ku sũ, ɑ̀ wɑɑ jirimɑ Ilɑɑɔ̃, ɑ̀ muɑ njɛ ɡbuɡbɑ̃ nɔ ɑkpɔ nŋɑ í kɔ̃ɔsi wɑ koo do sobii Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piɛɛ mɔ wɑ dɑbii bii fei. Nɔ í bɔ bi inɛi Jesu ŋɑ iyi ɑ̀ wɑ Lidɑ. ");
INSERT INTO mkl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Bɛi í yɛ wɛɛɡɛ ɡɔ ɑ̀ yɑ kpoo Enee, kù dede hɑi bi ku sũɛ hɑi zɑkɑi ɑdɔ̃ mɛɛjɔ. ");
INSERT INTO mkl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ŋɔi Piɛɛ í sɔ̃ɔ í ni, Enee dede, Jesu Kirisi í jɔ̀ ì bɑ iri, kɑ sɛ̃ɛɛ. Gbɑkɑ̃ ŋɔi í dede. ");
INSERT INTO mkl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ŋɔi inɛ ŋɑ iyi ɑ̀ wɑ Lidɑu fei do inɛi ilɛɛkoi Sɑrɔ̃ɔ ŋɑ ɑ̀ yɔɔ nɔ ɑ̀ dɑsi Lɑfɛ̃ɛ Jesu nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Wee si ilui Zopee inɑɑbo woo dɑsi Jesu nɑɑnɛ ɡɔ í wɑ bɛ ɑ̀ yɑ kpoo Tɑbitɑ. Nŋui ɑ̀ yɑ kpe Dɔɔkɑsi mɑ́ do feei Gɛrɛki, wɑɑtɔ kɑbuɑ. Í nɛ dɑɑ jiidɑ nɔ í yɑ mɑɑ sobi ilu ɑre ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ŋɔi ɑjɔ nŋu ɡɔ í nɑ í ce bɔ̃ɔ í ku. Iyi ɑ̀ wɛ ikuɛ ŋɔi ɑ̀ koo ɑ̀ jilɔɔ ile lele. ");
INSERT INTO mkl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu iyi ɑ̀ wɑ Zopee ɑ̀ ɡbɔ iyi Piɛɛ í wɑ Lidɑ kɔkɔi Zopee bɛ. Ŋɔi ɑ̀ bɛ siɛ inɛ minji ɑ̀ ni ɑ koo ɑ sɔ̃ɔ ku nɑɑ wɑ bi ɑŋɑ nsɛi nsɛi. ");
INSERT INTO mkl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ŋɔi Piɛɛ í dede í too ŋɑ wɑ. Iyi í to bɛ, ŋɔi ɑ̀ bɔòɛ lelei ileu. Ŋɔi jɑɑɔ̃ ŋɑ fei ɑ̀ nɑɑ ɑ̀ kɑɑkoɛ ɑ̀ wɑɑ kpɑtɑò nɔ ɑ̀ wɑɑ nyisiɛ ibɔ do jɑɑɛ ŋɑ iyi Dɔɔkɑsi í ce wɑɑti iyi í wɛɛ ɑŋɑò ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ŋɔi Piɛɛ í nyɑ ɑŋɑ fei hɑi ilɑɑwɑ í bɛi í ɡulɛ wɑ ce kutɔɔ. Í sindɑ si ikuu í ni, Tɑbitɑ dede. Ŋɔi í cĩ ijuɛ. Iyi í yɛ Piɛɛ nɔ í dede í bubɑ. ");
INSERT INTO mkl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ŋɔi Piɛɛ í mu ɑwɔɛ í dedeɛ. Nɔ í kpe jɑɑɔ̃ ŋɑu do inɛi Jesu ŋɑ iyi ɑ̀ ɡbe í nyisi ŋɑ Dɔɔkɑsi iyi í jĩ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ŋɔi lɑɑbɑɑuu í fɑnɡɑɑ si ilui Zopee fei, nɔ inɛ nkpɔ í dɑsi Lɑfɛ̃ɛ Jesu nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nɔ Piɛɛ í ce ɑjɔ minji Zopee bɛ bi ɑnɑ̀ ɡɔ iyi ɑ̀ yɑ kpe Simɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Inɛ ɡɔ í wɑ Sezɑree, ɑ̀ yɑ kpoo Kɔɔnɛi. Nŋui wɑ jɛ inɛ nɡboi wuɑi sooɡe ɡɔ ŋɑ iyi ɑ̀ yɑ kpe Inɛi Itɑli ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mɔkɔu wɑ too Ilɑɑɔ̃ nɔ í yɑ mɑɑ jirimɑɛ ntɔ ntɔ, nŋu do nyɑɑnzeɛ ŋɑ fei. Í yɑ mɑɑ ce kutɔɔ wɑɑti kɑ̃mɑ fei, í yɑ nɔ ku sobi ilu ɑrei Zuifu ŋɑ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ŋɔi ɑjɔ ɑkɑ̃ zɑkɑi isɔ mɛɛtɑ í ce kuyɛ. Í yɛ ɑmɑlekɑi Ilɑɑɔ̃ dee dee. Amɑlekɑu í lɔ siɛ wɑ, ŋɔi í kpoo í ni, Kɔɔnɛi. ");
INSERT INTO mkl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ŋɔi í cɔ ɑmɑlekɑu í kɑ̃siɛ iju ŋɔi njo í muu nɔ í beeɛ í ni, Lɑfɛ̃ɛ, mii í ce. Ŋɔi ɑmɑlekɑu í jɛɑɑ í ni, Ilɑɑɔ̃ í ɡbɔ kutɔɔɛ, nɔ kù ɡbɛjɛ yɑɑse bɛi ì sobi ilu ɑre ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nsɛi, bɛ inɛ ɡɔ ŋɑ Zopee ɑ koo ɑ kpe Simɔɔ iyi ɑ̀ yɑ kpe Piɛɛu wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Inɛ njooi, í wɑ kpɑsɛ̃i ɑnɑ̀ ɡɔ iyi ɑ̀ yɑ kpe Simɔɔ. Kpɑsɛ̃ɛ í wɑ kɔkɔi tenku. ");
INSERT INTO mkl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Iyi ɑmɑlekɑu í bɑɑ ide ku fɔ í tɑ̃ í nɛ, ŋɔi Kɔɔnɛi í kpe inɛ minji ɡɔ ŋɑ si inɔi woo ce icɛɛ ŋɑu. Nɔ si inɔi sooɡe ŋɑ iyi ɑ̀ yɑ wɑ kɔkɔɛu í kpe inɛ ɑkɑ̃ ɡɔ mɑ́ iyi í mɑ̀ bɛɛrɛi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ŋɔi í sisi nŋɑ ide iyi í ce fei, í bɛi í bɛ ŋɑ Zopee. ");
INSERT INTO mkl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Iju kumɑ́ɛ zɑkɑi dɑsɑ̃ ɑ̀ wɑ si kpɑ̃ɑu nɔ ɑ̀ mɑɑi si iluu. Wɑɑti bɛɛbɛ í ko Piɛɛ í ɡũ ɑntɑi ile sikifɑ wɑ ce kutɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ŋɔi ɑri í nɑ wɑ kpɑɑ, nɔ wɑ bi ku jɛ. Wɑɑti iyi ɑ̀ wɑɑ tɛkɛɑ cɑkɑ ŋɔi í ce kuyɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Í yɛ lelei Aɔ̃ í cĩ nɔ ɑcɔ nlɑ ɡɔ iyi ɑ̀ wɑɑ mu ɡontɑ mɛɛɛ wɑ kitɑ wɑ ilɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Inɔɛ bɛi dimii iŋɑ kutɛ mɛɛ fei í wɑ si do iyi wɑ cɑ̃ ilɛ do dimii yɛi fei. ");
INSERT INTO mkl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ŋɔi Piɛɛ í ɡbɔ ide ku fɔ ɡɔ í ni, Piɛɛ dede, kpɑ i ŋɔ. ");
INSERT INTO mkl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ammɑ Piɛɛ í jɛɑɑ í ni, jɑ̃m, Lɑfɛ̃ɛ. Ajɔ kɑ̃mɑ n kù ŋɔ iŋɑ iyi í jɛ iwɔ̀ hee mɑ̀ jɛ iyi í riisi. ");
INSERT INTO mkl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nɔ ide ku fɔu í ni mɑ́, mii iyi Ilɑɑɔ̃ í ni í mɑ́ mɑɑ̀ ti i kɔsi. ");
INSERT INTO mkl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bɛɛbɛi í ce hee isɛ ɡbɛɛtɑ. Nɔ ɡbɑkɑ̃ ɑcɔu í nyi lele. ");
INSERT INTO mkl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ŋɔi Piɛɛ wɑ bee ɑrɑɛ yoomɑi í jɛ yɑɑsei kuyɛu. Wɑɑti bɛɛbɛi inɛ ŋɑ iyi Kɔɔnɛi í bɛ ŋɑu ɑ̀ to Zopee bɛ. Ŋɔi ɑ̀ bee kpɑsɛ̃i Simɔɔ nɔ ɑ̀ nyisi ŋɑ. Wɑɑti iyi Piɛɛ í wɑsi ku lɑsɑbu si ideu ŋɔi ɑ̀ to wɑ ɑndɛ koofɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ŋɔi ɑ̀ kpe inɛi kpɑsɛ̃ ŋɑu ɑ̀ bee ŋɑ mɑ̀ inɛ njoo ɡɔ í wɑ bɛ iyi ɑ̀ yɑ kpe Simɔɔ Piɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Si bɛi Piɛɛ í wɑsi ku lɑsɑbu si idei kuyɛɛu ŋɔi Hundei Ilɑɑɔ̃ í sɔ̃ɔ í ni, wee ɑmɑnɛ mɛɛtɑ ɡɔ ŋɑ ɑ̀ wɑɑ dɛdɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dede i kitɑ i koo i bɑ ŋɑ. Nɔ iŋɛò ŋɑ i nɛ. Mɑɑ̀ leekĩ leekĩ, domi ɑmui ǹ bɛ ŋɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ŋɔi Piɛɛ í kitɑ í koo í bɑ ŋɑ í ni, inɛ iyi ì wɑɑ dɛ ŋɑu ɑmui ihɛ̃ mɛɛ. Mii ì bi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nɔ ɑ̀ ni, Kɔɔnɛi, inɛ nɡboi sooɡe ŋɑui wɑ dɛdɛɛ. Inɛ dee deei, í yɑ mɑɑ jirimɑ Ilɑɑɔ̃ nɔ Zuifu ŋɑ fei ɑ̀ yɑ mɑɑ fɔ jiidɑ ku jɛɛ. Amɑlekɑi Ilɑɑɔ̃ ɡɔ í sɔ̃ɔ í ni ku kpeɛ bi tɛɛ ku bɑ ku ɡbɔ ide iyi ɑɑ sɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Idũu ŋɔi Piɛɛ í dɑsi inɛ ŋɑu kpɑsɛ̃ í ce nŋɑ yɑɑɛ. Iju kumɑ́ɛ í dɑsiò ŋɑ kpɑ̃ɑ, nɔ kpɑɑsi woo dɑsi Jesu nɑɑnɛi Zopee ɡɔ ŋɑ ɑ̀ suu. ");
INSERT INTO mkl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Iju kumɑ́ mmuɛ ŋɔi ɑ̀ to Sezɑree. Wee hee ɑ mɑɑ to wɑ Kɔɔnɛi í tɔtɔɔ nyɑɑnzeɛ ŋɑ do kpɑɑsi jiidɑɛ ŋɑ ɑ̀ wɑɑ deɡbe ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Iyi Piɛɛ wɑ bi ku lɔ inɔ kpɑsɛ̃u ŋɔi Kɔɔnɛi í bɔ ku koɛ í koo í sɛɛbɑtɑ si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ammɑ Piɛɛ í dedeɛ í ni, dede, domi ɑmu mɔ ɑmɑnɛi bɛi ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ŋɔi wɑ bɑ Kɔɔnɛi ide ku fɔ hee í koo í lɔò inɔ ile, nɔ í yɛ inɛ nkpɔ í tɔtɔɔ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nɔ í sɔ̃ ŋɑ í ni, iŋɛ tɑkɑ nŋɛ ì mɑ̀ ŋɑ iyi woodɑi ɑwɑ Zuifu ŋɑ í kɔ nwɑ kɑ tɔtɔɔ do iŋɛ dimi mmu ŋɑ, wɑlɑ kɑ bɔ kpɑsɛ̃ nŋɛ. Ammɑ Ilɑɑɔ̃ í sɔ̃m í ni kù sĩɑ n kpe inɛ ɡɔ ilu riisi hee mɑ́ jɛ n kɔsiɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nŋui í jɔ̀ iyi ì kpem ŋɑ n kù kɔ. Nsɛi, ǹ bi i sɔ̃m nɑ mii í ce ì kpem wɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ŋɔi Kɔɔnɛi í ni, í to ɑjɔ mɛɛ wɑ ihɛ̃ nnyi iyi zɑkɑi isɔ mɛɛtɑ bɛ ihɛ̃i ǹ wɑ kpɑsɛ̃m ihɛ̃ ǹ wɑ n ce kutɔɔ. Ŋɔi inɛ ɡɔ í nɑɑ bi tom, wɑ dɑsi ibɔi jɑɑɛ ku dɑɑnɑ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nɔ í sɔ̃m í ni, Kɔɔnɛi, Ilɑɑɔ̃ í ɡbɔ kutɔɔɛ nɔ kù ɡbɛjɛ jiidɑ ku ceɛ do bɛi ì yɑ mɑɑ sobi ilu ɑre ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nɑ nŋu, bɛ inɛ ɡɔ ŋɑ Zopee ɑ koo ɑ kpe Simɔɔ Piɛɛ wɑ. Inɛ njooi wɑ jɛ. Í wɑ kpɑsɛ̃i ɑnɑ̀ ɡɔ iyi ɑ̀ yɑ kpe Simɔɔ. Kpɑsɛ̃ɛ í wɑ kɔkɔi tenku. ");
INSERT INTO mkl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Iyi ɑmɑlekɑu í fɔ bɛɛbɛ, ŋɔi ǹ bɛ siɛ inɛ ŋɑu bɛ wɑ ɡbɑkɑ̃, ì nɔ ì jɛ ì nɑɑ. Iyi bɛ í sĩɑ. Nsɛi ɑwɑ fei ɑ̀ wɑ si wɑjui Ilɑɑɔ̃ ihɛ̃ ɑ̀ wɑɑ de itĩ si ide iyi Lɑfɛ̃ɛ í sɔ̃ɛ fei i sɔ̃ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ŋɔi Piɛɛ í so ide í ni, ǹ mɑ̀ bɛbɛi iyi Ilɑɑɔ̃ kù wɑɑ cɔ inɛ kɑ̃mɑ dimi mmu. ");
INSERT INTO mkl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Inɛ iyi í yɑ mɑɑ jirimɑ Ilɑɑɔ̃ fei nɔ wɑ ce iyi í sĩɑ dee dee, Ilɑɑɔ̃ í yɑ ɡbɑ lɑfɛ̃ɛi si dimi iyi í jɛ fei. ");
INSERT INTO mkl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ì mɑ̀ lɑɑbɑɑu jiidɑ iyi Ilɑɑɔ̃ í jɔ̀ ɑ̀ wɑɑzoɑ inɛi Izirɛli ŋɑ ɑ̀ ni inɛ ŋɑ ɑɑ bɑ lɑɑkɑi ku sũ do sɑɑbui Jesu Kirisi nŋu iyi í jɛ Lɑfɛ̃ɛi inɛ fei. ");
INSERT INTO mkl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ì nɔ ì mɑ̀ ŋɑ mii iyi í sinti si ilɛi Gɑlilee í bɛi í ce si ilɛi Zudee fei wɑɑti iyi Zɑ̃ɑ í sisi idei inyi ku dɑsi iyi í yɑ mɑɑ ceu í tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ì mɑ̀ bɛi Ilɑɑɔ̃ í muɑ Jesu inɛi Nɑzɑrɛtiu Hundeɛ ŋɑ do bɛi í muɑɑ ɡbuɡbɑ̃. Nɔ í dɑbii si ilɛu fei wɑ ce jiidɑ nɔ í jɔ̀ inɛ ŋɑ iyi ɑ̀ wɑ si ɑwɔi Seetɑm fei ɑ̀ bɑ iri. Í yɑ mɑɑ ce bɛɛbɛi si nɑ iyi í jɔ̀ Ilɑɑɔ̃ í wɛɛ do nŋu. ");
INSERT INTO mkl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Awɑi ɑ̀ wɑɑ jɛɑ inɛ ŋɑ sɛɛdɑi mii iyi í ce ilɛi Zuifu ŋɑ do ilui Zeruzɑlɛmu fei. Nɔ ɑ̀ kpɑkpɑɛ si jĩi ɑ̀ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ammɑ si ɑjɔ mɛɛtɑsiɑ Ilɑɑɔ̃ í jũu hɑi si bɑlɛ nɔ í jɔ̀ í tusɛɑ inɛ ɡɔ ŋɑ ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kù nɔ kù jɛ inɛ feii í yɔɔ bii kù jɛ ɑwɑ iyi ɑ̀ jɛ sɛɛdɑ iyi Ilɑɑɔ̃ í cicɑ hɑi tɑko, ɑwɑ iyi ɑ̀ jɛ nɔ ɑ̀ mɔ do nŋu si ɑnyii kujĩɛ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nɔ í dɑsi wɑ kɑ mɑɑ wɑɑzoɑ inɛ ŋɑ, nɔ kɑ jɛɑ inɛ ŋɑ sɛɛdɑ iyi nŋui Ilɑɑɔ̃ í cicɑ ku kiiti ilu hunde do iku ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bɛɛbɛ mɔi wɑlii ŋɑ fei ɑ̀ fɔ ideɛ ɑ̀ ni inɛ iyi í dɑsiɛ nɑɑnɛ fei Ilɑɑɔ̃ ɑ́ kpɑ idei dulum ndii lɑfɛ̃ɛ nɑ sɑɑbui iriɛ. ");
INSERT INTO mkl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wɑɑti iyi Piɛɛ wɑ fɔ ide mɑ́, ŋɔi Hundei Ilɑɑɔ̃ í nɑɑ si inɛ ŋɑ iyi ɑ̀ wɑɑ ɡbɔ ideu fei. ");
INSERT INTO mkl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Zuifu woo dɑsi Jesu nɑɑnɛ ŋɑ iyi ɑ̀ si Piɛɛ bɛu, ɑ̀ biti do iyi Ilɑɑɔ̃ í muɑ dimi mmu ŋɑ mɔ Hundeɛ, ");
INSERT INTO mkl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","domi ɑ̀ ɡbɔ inɛ ŋɑu ɑ̀ wɑɑ fɔ ide do fee ŋɑ iyi ɑ̀ kù wɑɑ ɡbɔ ɑ̀ wɑɑ sisiò bɛi kulɑi Ilɑɑɔ̃ í to. ");
INSERT INTO mkl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ŋɔi Piɛɛ í ni, si bɛi inɛ ŋɑu ihɛ̃ ɑ̀ bɑ Hundei Ilɑɑɔ̃ bɛi ɑwɑ mɔ, yooi ɑ́ yɔkɔ ku ɡɑnji ŋɑ ɑ dɑsi ŋɑ inyi. ");
INSERT INTO mkl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ŋɔi í ni ɑ dɑsi ŋɑ inyi do irii Jesu Kirisi. Ŋɔi Kɔɔnɛi ŋɑ ɑ̀ tɔɔɛ ɑ̀ ni ku bubɑ bi ɑŋɑ bɛ ku ce ɑjɔ minji. ");
INSERT INTO mkl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Woo bɛ ŋɑ do kpɑɑsi woo dɑsi Jesu nɑɑnɛ ŋɑ iyi ɑ̀ wɑ ilɛi Zudee ɑ̀ ɡbɔ iyi hɑi jɛ Zuifu ŋɑ mɔ ɑ̀ ɡbɑ idei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ŋɔi Piɛɛ í bɑɑ Zeruzɑlɛmu nɔ Zuifu woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ̀ yɛ tɑɑleɛ, ");
INSERT INTO mkl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ɑ̀ ni ɑ̀ lɔ kpɑsɛ̃i inɛ ŋɑ iyi ɑ kù ce bɑnɡo nɔ ɑŋɑò ŋɑ ɑ̀ jɛ. ");
INSERT INTO mkl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ŋɔi Piɛɛ í sisi nŋɑ ideu hɑi sinteɛ bɛi í ce fei. ");
INSERT INTO mkl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Í sɔ̃ ŋɑ í ni, wɑɑti iyi ǹ wɑ Zopee ǹ wɑ n ce kutɔɔ ɑjɔ nŋu ɡɔ, ŋɔi ǹ ce kuyɛ. Ǹ yɛ ɑcɔ nlɑ ɡɔ iyi ɑ̀ wɑɑ mu ɡontɑ mɛɛɛ wɑ kitɑ wɑ hɑi lelei Aɔ̃ í nɑɑ í leekĩ kɔkɔm. ");
INSERT INTO mkl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Iyi ǹ wɑ n cɔɔ do lɑɑkɑi, ŋɔi si inɔɛ ǹ yɛ iŋɑi sɑko ilu kutɛ mɛɛ ŋɑ do iŋɑ ku cɑ̃ ilɛ ŋɑ do yɛi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ŋɔi ǹ ɡbɔ ide ku fɔ ɡɔ í sɔ̃m í ni, Piɛɛ dede, kpɑ i ŋɔ. ");
INSERT INTO mkl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ammɑ ǹ ni, jɑ̃m Lɑfɛ̃ɛ. Ajɔ kɑ̃mɑ iŋɑ iyi í jɛ iwɔ̀ hee mɑ́ jɛ iyi í riisi kù lɔ ɡɛlɛm. ");
INSERT INTO mkl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nɔ ide ku fɔu í sɔ̃m mɑ́ hɑi lele í ni mii iyi Ilɑɑɔ̃ í ni í mɑ́, n mɑɑ̀ n kɔsi. ");
INSERT INTO mkl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bɛɛbɛi í ce isɛ ɡbɛɛtɑ í bɛi í nyi lele. ");
INSERT INTO mkl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Wee hɑi Sezɑree ɑ̀ bɛ sim ɑmɑnɛ mɛɛtɑ ɡɔ ŋɑ wɑ. Bɛ ɡbɑkɑ̃ inɛ ŋɑu ɑ̀ to wɑ ɑndɛ koofɑi kpɑsɛ̃ bii ǹ wɑu. ");
INSERT INTO mkl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ŋɔi Hundei Ilɑɑɔ̃ í ni n too ŋɑ n mɑɑ̀ n leekĩ leekĩ. Nɔ kpɑɑsi mɛɛfɑm ŋɑu ihɛ̃ ɑ̀ sim Sezɑree bɛ nɔ ɑ̀ lɔ kpɑsɛ̃i Kɔɔnɛi ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nɔ Kɔɔnɛi í sɔ̃ wɑ bɛi nŋu í yɛ ɑmɑlekɑ si kpɑsɛ̃i nŋu wɑ leekĩ nɔ í ni, bɛ inɛ ɡɔ ŋɑ Zopee ɑ koo ɑ kpe Simɔɔ Piɛɛ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nŋui ɑ́ sɔ̃ɛ bɛi ɑwɔ do nyɑɑnzeɛ ŋɑ fei ɑɑ ce i bɑò fɑɑbɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ŋɔi ǹ koo. Iyi ǹ sinti ku wɑɑzo, ŋɔi Hundei Ilɑɑɔ̃ í nɑɑ si ŋɑ wɑ bɛi í nɑɑ si ɑwɑ mɔ tɑko wo. ");
INSERT INTO mkl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ŋɔi ǹ ye ɡiɡii ide iyi Lɑfɛ̃ɛ í fɔu iyi í ni, Zɑ̃ɑ í dɑsi inɛ ŋɑ inyi, ɑmmɑ Hundei Ilɑɑɔ̃i ɑn dɑ nŋɛ si. ");
INSERT INTO mkl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bɛɛbɛ mɔi Ilɑɑɔ̃ í ce nŋɑ ɑmuɑ bɛi í mu nwɑ wo wɑɑti iyi ɑ̀ dɑsi Lɑfɛ̃ɛ Jesu Kirisi nɑɑnɛ. Nɑ nŋu, bɛirei ɑmu ɑn ce n ɡɑnjiò mii iyi Ilɑɑɔ̃ í ce. ");
INSERT INTO mkl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iyi inɛ ŋɑu ɑ̀ ɡbɔ ideu, ŋɔi idɔ nŋɑ í tũ, nɔ ɑ̀ sɑɑbu Ilɑɑɔ̃ ɑ̀ wɑɑ ni, debɛi, Ilɑɑɔ̃ í muɑ hee do dimi mmu ŋɑ mɔ kpɑ̃ɑ ɑ kpɑɑsiò idɔ nŋɑ ɑ bɑò kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Wee woo dɑsi Jesu nɑɑnɛ ŋɑ iyi ɑ̀ fɑnɡɑɑ bii fei nɑ ijuukpɑ̃ iyi í nɑɑ si wɑɑti iyi ɑ̀ kpɑ Etiɛniu, ɡɔɡɔ ŋɑ ɑ̀ sɑ ɑ̀ bɔ hee ɡunɡum ɡɔ iyi ɑ̀ yɑ kpe Sipu. Gɔɡɔ ŋɑ mɔ ɑ̀ bɔ ilɛi Fenisi, ɡɔɡɔ ŋɑ mɔ ɑ̀ nɛ Antiɔsi. Zuifu ŋɑ ɑŋɑ ɑkɑ̃i ɑ̀ yɑ mɑɑ wɑɑzoɑ lɑɑbɑɑu jiidɑu. ");
INSERT INTO mkl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Do nŋu fei, inɛ ɡɔ ŋɑ hɑi si inɔ nŋɑ ɑ̀ nɑɑ hɑi Sipu do hɑi Sirɛni ɑ̀ bɔ Antiɔsi nɔ ɑ̀ wɑɑ sisiɑ hɑi jɛ Zuifu ŋɑ mɔ lɑɑbɑɑu jiidɑi Jesu Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nɔ ɡbuɡbɑ̃i Aɔ̃ Lɑfɛ̃ɛ í wɛɛ nŋɑ, nɔ inɛ nkpɔ í kpɑɑsi idɔ í dɑsi Lɑfɛ̃ɛ Jesu nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Iyi inɛi iɡbɛi Jesu ŋɑ iyi ɑ̀ wɑ Zeruzɑlɛmu ɑ̀ ɡbɔ ideu, ŋɔi ɑ̀ bɛ Bɑɑnɑbɑsi Antiɔsi bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Iyi í to bɛ í yɛ bɛi Ilɑɑɔ̃ í ceɑ inɛ ŋɑu didɔ̃ nɔ inɔɛ í dɔ̃. Ŋɔi í mu nŋɑ ɡbuɡbɑ̃ ku bɑ ɑ leekĩ dim dim si Lɑfɛ̃ɛ do idɔ nŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bɑɑnɑbɑsiu inɛ ncɛɛi iyi í dɑsi Jesu nɑɑnɛ ntɔ ntɔ nɔ í kɔ̃ò Hundei Ilɑɑɔ̃. Nɔ ɑkpɔi woo dɑsi Lɑfɛ̃ɛ Jesu nɑɑnɛ ŋɑu í nyi í kɔ̃ɔsi mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Si ɑnyiɛ ŋɔi í bɔ Sɔlu ku dɛdɛ ikpɑ Tɑrusi. ");
INSERT INTO mkl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Iyi í yɔɔ ŋɔi í bɔòɛ Antiɔsi. Adɔ̃ ɑkɑ̃i ɑŋɑ minjiu ɑ̀ ce bɛ ɑ̀ yɑ tɔtɔɔ do inɛi iɡbɛi Jesu ŋɑ nɔ ɑ̀ yɑ kɔɑ inɛ nkpɔ si cioi idei Ilɑɑɔ̃. Antiɔsi bɛi ɑ̀ tɑko ɑ̀ kpe inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesuu inɛi Kirisi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wɑɑti bɛɛbɛ wɑlii ɡɔ ŋɑ ɑ̀ bɔ Antiɔsi hɑi Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Inɛ ɑkɑ̃ nŋɑ iyi ɑ̀ yɑ kpe Aɡɑbusi í dede í leekĩ nɔ í ce wɑlii do sobii Hundei Ilɑɑɔ̃ í ni ɑri nlɑ nlɑ ɑ́ ce si ɑndunyɑ fei. Bɛɛbɛ mɔi ɑriu í nɔ í ce si wɑɑtii Kolodu ilɑɑlu nlɑi Romuu. ");
INSERT INTO mkl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Si bɛi inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesuu ɑ̀ ɡbɔ bɛɛbɛ ŋɔi ɑ̀ dɑsi idɔ ɑŋɑ ɑ sɑmbɑ ɑmuɑ ŋɑ zɑkɑ bɛi inɛ fei í nɛ, ku bɑ ku sobi kpɑɑsi nŋɑ ŋɑ iyi ɑ̀ wɑ ilɛi Zudee. ");
INSERT INTO mkl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ŋɔi ɑ̀ ce bɛɛbɛ, nɔ ɑ̀ jɔ̀ Bɑɑnɑbɑsi do Sɔlu ɑ̀ kooò ɑmuɑu bi inɛ nɡbo nŋɑ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wɑɑti bɛɛbɛ ilɑɑlu Herodu í sinti ku kpɑ̃ inɛi iɡbɛi Jesu ɡɔ ŋɑ iju. ");
INSERT INTO mkl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Í jɔ̀ ɑ̀ kpɑ Zɑɑki iɡbɑ̃i Zɑ̃ɑ do tɑɑkubɑ. ");
INSERT INTO mkl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ŋɔi í yɛ ideu í dɔ̃ɑ Zuifu ŋɑu si, nɔ í jɔ̀ ɑ̀ mu Piɛɛ mɑ́. Wee wɑɑtii jinɡɑui Pɛ̃ɛ hɑi nɛ lefeei. ");
INSERT INTO mkl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Iyi ɑ̀ mu Piɛɛ ŋɔi Herodu í jɔ̀ ɑ̀ dɑsiɛ piisɔ̃ɔ nɔ í jɔ̀ sooɡe ŋɑ ɑ̀ wɑɑ deɡbeɛ, ɑŋɑ mɛɛ ikɔ mɛɛ. Herodu í bi nŋu ku ceɑɑ kiiti si wɑjui zɑmɑɑ bii jinɡɑui Iku ku kuɑu í lɔ. ");
INSERT INTO mkl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","À wɑɑ mu Piɛɛ si ile piisɔ̃ɔ bɛ, ɑmmɑ inɛi iɡbɛi Jesu ŋɑ ɑ̀ wɑsi ku ce kutɔɔ nɑ iriɛ do himmɑ jiidɑ jiidɑ bi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Piɛɛ wɑ sĩ njoo si ɑninii sooɡe minji ɡɔ ŋɑ idũ iyi iju kumɑ́ɛ Herodu wɑ bi ku nyɑɑ hɑi ile piisɔ̃ɔu ku bɔòɛ si wɑjui zɑmɑɑ. À dũu do sesee minji nɔ sooɡe ɡɔ ŋɑ ɑ̀ wɑɑ deɡbe ɑndɛi ile piisɔ̃ɔu bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ŋɔi ɡbɑkɑ̃ ɑmɑlekɑi Aɔ̃ Lɑfɛ̃ɛ ɡɔ í nɑɑ si ile piisɔ̃ɔu, ŋɔi inyɑ í mɑ́. Ŋɔi ɑmɑlekɑu í cɑ̃ Piɛɛ si cinɡɑɛ í jũu í ni, dede ńyɑ ńyɑ. Bɛ ɡbɑkɑ̃ ŋɔi sesee ŋɑu í cuku hɑi si ɑwɔɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ŋɔi ɑmɑlekɑu í ni, dɑsi ibɔɛ do bɑɑtɑɛ. Ŋɔi Piɛɛ í ce bɛɛbɛ, ŋɔi ɑmɑlekɑu í sɔ̃ɔ mɑ́ í ni, bii dɑbiiɛ nɔ i toom wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ŋɔi Piɛɛ í fitɑ hɑi ile piisɔ̃ɔu í tooɛ, ɑmmɑ kù mɑ̀ iyi mii ŋɑu bɛ fei ɑmɑlekɑu wɑ cooi ntɔ ntɔ. Í tɑmɑɑ bɛi nŋu wɑ lɑɑlɑɑi. ");
INSERT INTO mkl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","À lɔ woo deɡbe piisɔ̃ɔ sinteu do minjisiɑu nɔ ɑ̀ tosi ɡɑmboi isɔu. Inɛ nŋu ikpɑ inɔ ilui wɑ cɔ. Ŋɔi í cĩ do ɑrɑɛ nɔ ɑ̀ fitɑ ɑ̀ mu kpɑ̃ɑ ɑ̀ nɛ hee ɑ̀ lɔ kpɑ̃ɑ kókò sinte, ŋɔi ɡbɑkɑ̃ ɑmɑlekɑu í nɛ í jɔ̀ Piɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ŋɔi Piɛɛ í yɔɔ bɛbɛi iyi kù jɛ ɑ̀lɑ́. Nɔ í ni, ntɔ ntɔ Ilɑɑɔ̃i í bɛ sim ɑmɑlekɑɛ wɑ ku nɑ ku nyɑm hɑi si ɑwɔi Herodu, do lɑɑlɔ iyi Zuifu ŋɑu ɑ̀ bi ɑ ceem fei. ");
INSERT INTO mkl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iyi í yɛ yɑɑsei ideu ŋɔi í bɔ kpɑsɛ̃i Mɑɑri iyei Zɑ̃ɑ Mɑɑku. Wee í ko inɛ nkpɔ nkpɔi í tɔtɔɔ bɛ ɑ̀ wɑsi ku ce kutɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Iyi Piɛɛ í to bɛ ŋɔi í cɑ̃ ɡɑmboi ɑndɛ koofɑu ŋɔi ɑbo woo ce icɛ ɡɔ iyi ɑ̀ yɑ kpe Rodu í koo í bee í ni, yooi. ");
INSERT INTO mkl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Iyi í mɑ̀ imui Piɛɛ ŋɔi inɔ didɔ̃ kù jɔ̀ kù cũu. Ŋɔi í sɛi í nyi ile í koo í sɔ̃ inɛ ŋɑ í ni Piɛɛ í wɑ ɑndɛ koofɑ. ");
INSERT INTO mkl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, ì wɑɑ sũmui. Ammɑ í ni, ntɔ ntɔi. Ŋɔi ɑ̀ ni, ɑ́ mɑ́ jɛ ɑyɑɛi. ");
INSERT INTO mkl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wee Piɛɛ wɑ leekĩ bɛ í wɑsi ku cɑ̃ ɡɑmbo. Iyi ɑ̀ nɑɑ ɑ̀ cũu nɔ ɑ̀ bɑ wee nŋui, ŋɔi í mu ŋɑ biti. ");
INSERT INTO mkl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nɔ í ni ɑ coko do ɑwɔ í bɛi wɑ sɔ̃ ŋɑ bɛi Lɑfɛ̃ɛ í ce í nyɑ nŋu wɑ hɑi ile piisɔ̃ɔu. Ŋɔi í ni ɑ koo ɑ sɔ̃ Zɑkɔbu ideu do kpɑɑsi ŋɑ iyi ɑ̀ ɡbe, í bɛi í fitɑ í bɔ inyɑ mmu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Iju kumɑ́ɛ dɑɑdɑɑkɔ ideu í jɔ̀ sooɡe ŋɑu ɑ̀ biti hee ɑ̀ bee njɛ ɑ̀ wɑɑ ni, ikpɑ iwoi Piɛɛ í bɔ. ");
INSERT INTO mkl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ŋɔi Herodu í ni ɑ dɛdɛɛ. Ŋɔi ɑ̀ dɛdɛɛ ɑmmɑ ɑ kù yɔɔ. Ŋɔi í bee woo deɡbe ŋɑu ide. Si bɛi ɑ kù yɔkɔ ɑ kù jɛɑɑ, nɔ í ni ɑ kpɑ ŋɑ. Ŋɔi Herodu í bɛi í dede hɑi ilɛi Zudee í koo í bubɑ ikpɑ Sezɑree ɑjɔ minji titɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Wee idɔi Herodu í kɔ̃ò inɛi Tii ŋɑ do inɛi Sidɔ̃ɔ ŋɑ ntɔ ntɔ, ŋɔi inɛ ŋɑu ɑ̀ tɔtɔɔ njɛ nɔ ɑ̀ nyɑ inɛ ɡɔ ŋɑ ɑ̀ bɛ ŋɑ bi Herodu. Nɔ ɑ̀ ce Bɑlɑtu ɑkɑwei ilɑɑluu kpɑɑsi ɑ̀ bɛi ɑ̀ bɔ bi Herodu ɑ koo ɑ tɔɔɛ suuru domi inɛi ilɛ nŋɑ ŋɑ si ilɛi Herodui ɑ̀ yɑ bɔ ijɛ ku dɛdɛ. ");
INSERT INTO mkl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ŋɔi Herodu í dɑ nŋɑ ɑjɔ si bii ɑ́ yɛ ŋɑ. Iyi ɑjɔu í to ŋɔi Herodu í dɑsi ibɔi ilɑɑluɛ í bɛi í bubɑ si ɑntɑi kitɑ̃i bommɑɛ í bɛi í so ide wɑ sɔ̃ inɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ŋɔi inɛ ŋɑu ɑ̀ dɔ̃ ɑnu ɑ̀ sɑɑbuɛ ɑ̀ wɑɑ ni, kù jɛ bɑɑ ɑmɑnɛi wɑ fɔ ideu, Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bɛ ɡbɑkɑ̃ ɑmɑlekɑi Ilɑɑɔ̃ í dɑsi Herodu bɔ̃ɔ í jɔ̀ kokoo ŋɑ ɑ̀ ŋɔ ɑrɑɛ í ku, si nɑ iyi í jɔ̀ nŋu ɑmɑnɛ í ɡbɑ ɑmboei Ilɑɑɔ̃, kù kɔsi. ");
INSERT INTO mkl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ammɑ idei Ilɑɑɔ̃ njɛ í fɑnɡɑɑ wɑ kɔ̃ɔsi. ");
INSERT INTO mkl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Iyi Bɑɑnɑbɑsi do Sɔlu ɑ̀ ce mii iyi ɑ̀ dɑsi ŋɑ ku ceu Zeruzɑlɛmu bɛ ɑ̀ tɑ̃ ŋɔi ɑ̀ sindɑ ɑ̀ nyi Antiɔsi mɑ́. Iyi ɑ̀ wɑɑ nɛ ɑ̀ ɡbɑ̃ Zɑ̃ɑ Mɑɑku í si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Wɑlii do woo kɔsi cio ɡɔ ŋɑ ɑ̀ wɑ si inɔi inɛi iɡbɛi Jesu ŋɑ Antiɔsi bɛ. Iri nŋɑ wee. Bɑɑnɑbɑsi, do Simeɔ̃ iyi í jɛ ɑmɑnɛ dũdũ, do Lusiu inɛi Sirɛni, do Mɑnɑhɛnu, nŋu iyi ɑ̀ bíí do Herodu ilɑɑluu inyɑ ɑkɑ̃, do Sɔlu. ");
INSERT INTO mkl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ajɔ nŋu si bɛi inɛ ŋɑu ɑ̀ wɑɑ tɔɔ Lɑfɛ̃ɛ do ɑnu ku dĩ ɑjɔ, ŋɔi Hundei Ilɑɑɔ̃ í sɔ̃ ŋɑ í ni, i cicɑ Bɑɑnɑbɑsi do Sɔlu i nyɑ ŋɑ ikɑ̃ ŋɑ ɑ ce icɛ iyi ǹ kpe ŋɑò. ");
INSERT INTO mkl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Iyi ɑ̀ ce ɑnu ku dĩ do kutɔɔu ɑ̀ tɑ̃, ŋɔi ɑ̀ leɑ Bɑɑnɑbɑsi do Sɔlu ɑwɔ si iri, nɔ ɑ̀ jɔ̀ ŋɑ ɑ̀ nɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bɛɛbɛi Hundei Ilɑɑɔ̃ í bɛ Bɑɑnɑbɑsi do Sɔlu fei. Nɔ ɑ̀ to ilu ɡɔ iyi ɑ̀ yɑ kpe Selɛsi. Hɑi bɛi ɑ̀ lɔ ɑkɔi inyi ɑ̀ bɔ ɡunɡum ɡɔ iyi ɑ̀ yɑ kpe Sipu. ");
INSERT INTO mkl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Iyi ɑ̀ to si ilui Sipu ɡɔ iyi ɑ̀ yɑ kpe Sɑlɑmini ŋɔi ɑ̀ wɑsi ku wɑɑzo idei Ilɑɑɔ̃ si ile ikɑ̃ ikɑ̃ bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ nŋɑ ŋɑu. Zɑ̃ɑ Mɑɑku mɔ í too ŋɑ ku sobi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nɔ ɑ̀ kuɑ ɡunɡum nɔu ɑ̀ bɛi ɑ̀ to Pɑfɔsi. Pɑfɔsi bɛi ɑ̀ yɛ Zuifu woo ce dobu dobu ɡɔ iyi í jɛ wɑlii ilu ibo. Iriɛi Bɑɑjesu. ");
INSERT INTO mkl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Í wɛɛ do Seejiu Pɔlusi, ilu ilɛi Sipu ilu bisiu. Ilu ilɛu í ni ɑ kpe Bɑɑnɑbɑsi do Sɔlu wɑ si nɑ iyi í jɔ̀ wɑ bi ku ɡbɔ idei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ammɑ woo ce dobu dobuu iyi ɑ̀ yɑ kpe Elimɑsi do feei Gɛrɛki wɑ bi ku ɡɑnji ŋɑ. Wɑ ce kookɑɑi ku sindɑ ilu ilɛu hɑi si kpɑ̃ɑi nɑɑnɛ ku dɑsi si Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nɔ Sɔlu iyi ɑ̀ yɑ nyi ɑ kpe Pɔlu mɑu í kɔ̃ò Hundei Ilɑɑɔ̃ nɔ í kɑ̃si woo ce dobu dobuu iju, ");
INSERT INTO mkl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","í ni, ɑwɔ iyi ì jɛ ilu bisi lɑɑlɔ do woo tɑki inɛ, ɑwɔ inɛi Seetɑm nii nɔ ì jɛ mbɛɛi mii iyi í jɛ dee dee fei. Hee wɑɑti yoomɑi ɑɑ leekĩò ide ntɔi Aɔ̃ Lɑfɛ̃ɛu ku kpɑɑsi do ibo mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","To, nsɛi, Ilɑɑɔ̃ ɑ́ to siɛ ɑwɔ, ɑɑ fɛɛju, i kɑɑ yɛ ilu mɑ́ si zɑkɑi ɑjɔ minjiu ihɛ̃. Bɛ ɡbɑkɑ̃ í fɛɛju, nɔ í nɛ wɑ dɑbii wɑ dɛdɛ inɛ ɡɔ iyi ɑ́ mu ɑwɔɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Iyi ilu ilɛu í yɛ mii iyi í ceu ŋɔi í dɑsi nɑɑnɛ si nɑ iyi í jɔ̀ idei Lɑfɛ̃ɛ Jesu í to siɛ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Si ɑnyiɛ ŋɔi Pɔlu do kpɑɑsiɛ ŋɑ ɑ̀ lɔ ɑkɔi inyi hɑi Pɑfɔsi ɑ̀ nɛ nɔ ɑ̀ to Pɛɛzu si ilɛi Pɑnfili. Ammɑ Zɑ̃ɑ Mɑɑku í jɔ̀ ŋɑ hɑi bɛ í sindɑ í nyi Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Hɑi Pɛɛzu bɛ Pɔlu nɡu ŋɑ ɑ̀ mɔsi ɑ̀ bɔ Antiɔsi si ilɛi Pisidi. Iyi ɑjɔi kusĩmi í to ŋɔi ɑ̀ bɔ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ ɑ̀ bubɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nɔ inɛ ɡɔ í cio si tiɑ iyi Moizi do wɑlii ŋɑu ɑ̀ kɔ. Iyi í cio í tɑ̃, ŋɔi inɛ nɡboi iɡbɛ ŋɑu ɑ̀ bɛ si ŋɑ inɛ ɡɔ koo bee ŋɑ ku ni, iŋɛ kpɑɑsi ŋɑ, bii ì nɛ ide iyi ɑɑ muɑò inɛ ŋɑ ɡbuɡbɑ̃ i fɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ŋɔi Pɔlu í dede í ni ɑ coko do ɑwɔ nɔ í ni, iŋɛ inɛi Izirɛli ŋɑ do iŋɛ dimi mmu ŋɑ iyi ì wɑɑ jirimɑ Ilɑɑɔ̃, i de itĩ i ɡbɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Aɔ̃ Lɑfɛ̃ɛ nwɑi í cicɑ bɑlɑ nwɑ ŋɑ nɔ í kɔ̃ɔsi kukpɔ nŋɑ wɑɑti iyi ɑ̀ wɑɑ jɛ inɛ njoo si ilɛi Ezibiti. Si ɑnyii nŋu, í nyɑ ŋɑ hɑi ilɛi Ezibiti do ɡbuɡbɑ̃ɛ, ");
INSERT INTO mkl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","nɔ í yɔkɔò ŋɑ temuɑ zɑkɑi ɑdɔ̃ ciiji si ɡbɑɑu. ");
INSERT INTO mkl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Í kpɑ dimi ikɑ̃ ikɑ̃ mɛɛje si ilɛi Kɑnɑɑ̃ nɔ í so ilɛ nŋɑu í nɑ ŋɑ í jɛ tu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Iyi bɛ ŋɑ fei í cei zɑkɑi ɑdɔ̃ cĩɔ mɛɛ do ciitɑɑ. Si ɑnyii nŋu, Ilɑɑɔ̃ í jilɛ nŋɑ woo kiiti ŋɑ hee í koo í toò wɑɑtii Sɑmuɛli wɑliiu. ");
INSERT INTO mkl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ŋɔi ɑ̀ ni ɑŋɑ ɑ̀ bi ilɑɑlu, nɔ Ilɑɑɔ̃ í mu nŋɑ Sɔlu ɑmɑi Kisi hɑi si dimii Bɛnzɑmɛɛ nɔ í jɛ bommɑu zɑkɑi ɑdɔ̃ ciiji. ");
INSERT INTO mkl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nɔ Ilɑɑɔ̃ í nyɑɑ bommɑ í sɑ̃si Dɑvidi. Dɑvidiui í jɛɑɑ sɛɛdɑ í ni, ǹ yɛ Dɑvidi ɑmɑi Izɑi í jɛ dimii inɛ iyi ǹ bi, nŋui ɑ́ ce idɔɔbim fei. ");
INSERT INTO mkl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Hɑi si dimii Dɑvidii Jesu í fitɑ, inɛ iyi Ilɑɑɔ̃ í cicɑ ku jɛ woo fɑɑbɑi inɛi Izirɛli ŋɑ si bɛi í tɑko í ce nŋɑ kuwɑ̃ɛu. ");
INSERT INTO mkl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesu ku bɛi ku nɑɑ, Zɑ̃ɑ í ceɑ inɛi Izirɛli ŋɑ fei wɑɑzo í ni ɑ kpɑɑsi idɔ nŋɑ nɔ ɑ ce inyi ku dɑsi. ");
INSERT INTO mkl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Wɑɑti iyi icɛi Zɑ̃ɑ í mɑɑi ku kpɑ iri í ni, kù jɛ ɑmui ì wɑɑ deɡbe ŋɑ, ɑmmɑ inɛ ɡɔ ɑ́ nɑɑ si ɑnyim iyi n kù to n bɑte n fũ ikũi bɑɑtɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","To, iŋɛ kpɑɑsi ŋɑ, iŋɛ iyi ì jɛ dimii Aburɑhɑmu ŋɑ, do dimi mmu ŋɑ iyi ì wɑɑ jirimɑ Ilɑɑɔ̃, iŋɛi ɑ̀ sɑmbɑɑ idei fɑɑbɑu ihɛ̃ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Wee inɛi Zeruzɑlɛmu ŋɑ do inɛ nɡbo nŋɑ ŋɑ ɑ kù mɑ̀ yooi Jesu í jɛ dee dee, ɑ kù nɔ ɑ kù ɡbɔ yɑɑsei idei wɑlii ŋɑ iyi ɑ̀ yɑ mɑɑ cio si ɑjɔi kusĩmi feiu. Ammɑ do nŋu fei ɑ̀ jɔ̀ ideu í kɔ̃ si wɑɑti iyi ɑ̀ yɛ tɑɑlei Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","A kù yɛ siɛ nɡɔɡɔ iyi ɑ́ jɔ̀ ɑ kpɑɑ, ɑmmɑ do nŋu fei ɑ̀ tɔɔ Pilɑti ku jɔ̀ ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ŋɔi ɑ̀ ce mii iyi ɑ̀ kɔ nɑ iriɛu fei. Si ɑnyiɛ nɔ ɑ̀ kitɑɛ hɑi si jĩi ku ɡɑɑuu ɑ̀ dɑsi ikuɛ si inɔ bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ammɑ Ilɑɑɔ̃ í jũu hɑi si bɑlɛ, ");
INSERT INTO mkl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","nɔ si ɑfei ɑjɔ nkpɔ nkpɔ í nyisi inɛ ɡɔ ŋɑ ɑrɑɛ. Inɛ ŋɑu, ɑŋɑi ɑ̀ tooɛ wɑ wo hɑi ilɛi Gɑlilee ɑ̀ nɑɑ Zeruzɑlɛmu. Aŋɑi ɑ̀ wɑɑ jɛ sɛɛdɑi ideɛ nsɛi bi inɛi Izirɛli ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Awɑ mɔ idei kuwɑ̃ iyi Ilɑɑɔ̃ í ceɑ bɑlɑ nwɑ ŋɑu, nŋui ɑ̀ wɑɑ sɔ̃ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Í jɔ̀ kuwɑ̃u í kɔ̃ si wɑɑti nwɑ. Awɑ tɔku nŋɑ ŋɑ, ɑwɑi ɑ̀ yɛ kukɔ̃i kuwɑ̃u wɑɑti iyi í jĩ Jesu hɑi si bɑlɛ si bɛi ɑ̀ kɔɔ si Tiɑi Iri Kukɔ̃ iri minjisiɑ ɑ̀ ni, Ilɑɑɔ̃ í ni, ɑwɔi ì jɛ ɑmɑm, Hɑi nnyi ǹ jɛ Bɑɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ilɑɑɔ̃ í fɔ wo í ni nŋu ɑ́ jũu hɑi bi iku ŋɑ ku bɑ ku mɑɑ̀ nɑ ku sɑ̃mi. Bɛɛbɛi í fɔ wɑɑti iyi í ni, An wee nŋɛ dee dee bɛi ǹ wɑ̃ò Dɑvidi wo, kù nɔ kù nɛ sikɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nɑ ŋɔi í ce Dɑvidi í fɔ mɑ́ í ni, I kɑɑ jɔ̀ ɑrɑi Inɛ Kumɑ́ɛ ku sɑ̃mi. ");
INSERT INTO mkl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dɑvidi tɑkɑɛ í ce mii iyi Ilɑɑɔ̃ í dɑsiɛ í bɛi í ku, nɔ ɑ̀ suu kɔkɔi bɑlɑɛ ŋɑ nɔ ɑrɑɛ í sɑ̃mi, mɑ̀ irei. ");
INSERT INTO mkl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ammɑ Jesu inɛ nŋu Ilɑɑɔ̃ í jũu hɑi si bɑlɛ kù sɑ̃mi. ");
INSERT INTO mkl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Debɛi, iŋɛ kpɑɑsim ŋɑ, i jɔ̀ i mɑ̀ ŋɑ iyi nɑ sɑɑbuɛi ɑ̀ wɑɑ sisi nŋɛ iyi Ilɑɑɔ̃ ɑ́ kpɑ idei dulum du ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Inɛ iyi í dɑsiɛ nɑɑnɛ fei, nŋui ɑ́ jɔ̀ lɑfɛ̃ɛ ku jɛ dee dee bi Ilɑɑɔ̃. Ammɑ woodɑi Moizi kɑɑ yɔkɔ ku ce bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nɑ nŋu, i ce lɑɑkɑi ŋɑ mii iyi wɑlii ŋɑ ɑ̀ fɔu ku mɑɑ̀ bɑ ŋɛ, iyi ɑ̀ ni, ");
INSERT INTO mkl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Iŋɛ woo yɑɑko ɑmu Ilɑɑɔ̃, i ɡbɔ idem ŋɑ. Aɑ biti ŋɑ nɔ ɑɑ ce nfe ŋɑ, Domi ɑn ce mii ɡɔ si wɑɑti nŋɛ iyi bɑɑ bii í jɛ inɛ ɡɔ í nɑ wɑ sisi nŋɛ i kɑɑ dɑsi nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Iyi Pɔlu í fɔ bɛɛbɛ í tɑ̃ ŋɔi nŋu do Bɑɑnɑbɑsi ɑ̀ wɑɑ bi ɑ fitɑ hɑi ile bii ɑ̀ yɑ ce kutɔtɔɔu bɛ, ŋɔi inɛ ŋɑu ɑ̀ wɑɑ tɔɔ ŋɑ ɑ nyi wɑ mɑ́ ɑ nɑɑ ɑ wɑɑzo si ide ɑkɑ̃u si ɑjɔi kusĩmi mmu iyi wɑ bɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Iyi inɛ ŋɑu ɑ̀ fitɑ ŋɔi Zuifu nkpɔ do inɛ ŋɑ iyi ɑ̀ wɑɑ too kucei Zuifu ŋɑ nɔ ɑ̀ mɑ̀ bɛɛrɛi Ilɑɑɔ̃u ɑ̀ wɑɑ too ŋɑ. Ŋɔi Pɔlu do Bɑɑnɑbɑsi ɑ̀ bɑ ŋɑ ide ku fɔ ɑ̀ mu nŋɑ ɡbuɡbɑ̃ ku bɑ ɑ mɑɑ leekĩ dim dim si didɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Si ɑjɔi kusĩmi mmuu inɛi ilu ŋɑu fei ɑ̀ tɔtɔɔi ɑ bɑ ɑ ɡbɔ idei Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Iyi Zuifu ŋɑu ɑ̀ yɛ zɑmɑɑu ŋɔi ɑ̀ dedeò iɡu ku jɑ ɑ̀ wɑɑ jɑ̃ ide iyi Pɔlu wɑ fɔu nɔ ɑ̀ wɑɑ buu. ");
INSERT INTO mkl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ammɑ Pɔlu do Bɑɑnɑbɑsi ɑ̀ sɔ̃ ŋɑ do wɔɔkɔ ɑ̀ ni, tilɑsii iŋɛ Zuifu ŋɑ ɑ tɑko ɑ sɔ̃ ŋɛ idei Ilɑɑɔ̃. Ammɑ si nɑ iyi í jɔ̀ ì wɑɑ kɔsi ŋɑ nɔ i kù kɑ ɑrɑ nŋɛ si inɛ ŋɑ iyi ɑ̀ bi ɑ bɑ kuwɛɛ hɑi tɑ̃, nɑ nŋu, ɑɑ kɑ jɔ̀ ŋɛ nɔ kɑ bɔ bi dimi mmu ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","domi nŋu bɛi Lɑfɛ̃ɛ í dɑsi wɑ ku ce í ni, N ce ŋɛi bɛi fitilɑ bi dimi mmu ŋɑ Ku bɑ i bɔò idei fɑɑbɑu hee kɔɔi ɑndunyɑu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Iyi hɑi jɛ Zuifu ŋɑu ɑ̀ ɡbɔ ideu, ŋɔi í dɔ̃ nŋɑ si, ɑ̀ wɑɑ sɑɑbu Aɔ̃ Lɑfɛ̃ɛ nɑ ideɛu. Nɔ inɛ ŋɑ iyi Aɔ̃ Lɑfɛ̃ɛ í jilɔɔ si ɑ bɑ kuwɛɛ hɑi tɑ̃u fei ɑ̀ dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nɔ idei Lɑfɛ̃ɛu í fɑnɡɑɑ si ilɛu fei. ");
INSERT INTO mkl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ammɑ Zuifu ŋɑu ɑ̀ dede idɔɔkɔ̃i ilu irii ilu ŋɑu do inɑɑbo ilu ɑmɑni ŋɑ iyi ɑ̀ wɑɑ too kucei Zuifu ŋɑu. Nŋui í jɔ̀ ɑ̀ kpɑ̃ Pɔlu do Bɑɑnɑbɑsi iju ɑ̀ lele ŋɑ hɑi bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ŋɔi woo bɛ ŋɑu ɑ̀ ɡbuɡbɑ̃ si ŋɑ sɑ̃ɑi bɑɑtɑ nŋɑ ŋɑ ɑ̀ wɑɑ nyisiò iyi mii iyi ɑ́ nɑ ku bɑ ŋɑ í jɛ idei iri nŋɑ. Si ɑnyiɛ nɔ ɑ̀ nɛ Ikonimu. ");
INSERT INTO mkl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ammɑ inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu Antiɔsiu nɡu ŋɑ ɑ̀ wɛɛò inɔ didɔ̃ nɔ ɑ̀ kɔ̃ò Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikonimu bɛi Pɔlu do Bɑɑnɑbɑsi ɑ̀ lɔ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu nɔ ɑ̀ ce wɑɑzo hee inɛ nkpɔ í dɑsi nɑɑnɛ, hɑi Zuifu ŋɑ hee do hɑi jɛ Zuifu ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ammɑ Zuifu ŋɑ iyi ɑ̀ kɔ ku dɑsi nɑɑnɛu ɑ̀ dede idɔɔkɔ̃i dimi mmu ŋɑ ku bɑ ɑ ce lɑsɑbu lɑɑlɔ si ɡɑ̃mɛi kpɑɑsi woo dɑsi Jesu nɑɑnɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Do nŋu fei, Pɔlu do Bɑɑnɑbɑsi ɑ̀ kpɛ Ikonimu ɑ̀ wɑɑ wɑɑzoɑ inɛ ŋɑ do wɔɔkɔ. Lɑfɛ̃ɛ í mu nŋɑ ɡbuɡbɑ̃ ɑ̀ yɑ mɑɑ ceò mɑɑmɑɑke ikɑ̃ ikɑ̃ ŋɑ. Mɑɑmɑɑke ŋɑu wɑ nyisi iyi wɑɑzo nŋɑ iyi ɑ̀ wɑɑ ce si idei didɔ̃i nŋuu ntɔi. ");
INSERT INTO mkl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ammɑ inɛi ilu ŋɑu ɑ̀ kpɛ̃ minji. Inɛ ɡɔ ŋɑ ɑ̀ leekĩò Zuifu ŋɑ, inɛ ɡɔ ŋɑ mɔ ɑ̀ leekĩò woo bɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ŋɔi Zuifu ŋɑ do hɑi jɛ Zuifu ŋɑ do inɛ nɡbo nŋɑ ŋɑ ɑ̀ ce ɑnu ɑkɑ̃ ɑ wɑhɑlɑ woo bɛ ŋɑu ɑ tɑ ŋɑ kutɑ ɑ kpɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Iyi Pɔlu do Bɑɑnɑbɑsi ɑ̀ mɑ̀ ideu ɡbɑkɑ̃, ŋɔi ɑ̀ sɑ ɑ̀ bɔ Lisiti do Dɛɛbu si ilɛi Likoni do si ilɛɛkoɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nɔ ɑ̀ wɑsi lɑɑbɑɑu jiidɑu ku wɑɑzo bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mɔkɔ ɡɔ í wɑ Lisiti, isɛɛ ŋɑ fei í ku nɔ bɛɛbɛi ɑ̀ buu do, kù dede kù nɛ bɑɑ ɑjɔ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Si bɛi Pɔlu wɑ bɑ inɛ ŋɑ ide ku fɔ mɔkɔu wɑ ɡbɔ. Ŋɔi Pɔlu í kɑ̃ siɛ iju nɔ í yɛ iyi nɑɑnɛɛ ɑ́ yɔkɔ ku jɔ̀ ku bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ŋɔi Pɔlu í sɔ̃ɔ do ɡbuɡbɑ̃ í ni, dede i leekĩ si kutɛɛ. Ŋɔi mɔkɔu í dede í fo í dinɡɑ wɑ nɛ. ");
INSERT INTO mkl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Iyi zɑmɑɑu í yɛ mii iyi Pɔlu í ce ŋɔi ɑ̀ dɔ̃ ɑnu hee lele do fee nŋɑ ɑ̀ ni, iwɛ̃ nwɑ ŋɑu ɑ̀ kpɔò ɑmɑnɛ ɑ̀ nɑɑ si wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ŋɔi ɑ̀ wɑɑ kpe Bɑɑnɑbɑsi Susi, Pɔlu mɔ Hɛɛmɛɛzi domi Pɔlui í jɛ woo wɑɑzo. ");
INSERT INTO mkl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Wee ilei iwɛ̃ iyi ɑ̀ yɑ kpe Susiu í wɑ hɑi do ɑnɡulei bi ku lɔi iluu wɑ. Ŋɔi inɛ ŋɑ ɑ̀ koo ɑ̀ dɛ kɛtɛ kombo ŋɑ wɑ nɔ ɑ̀ ce boodɑ do kokoi jĩi ŋɑ ɑ̀ dɑ nŋɑ si kɔ̃ɔ. Nɔ woo weei Susiu í nɑɑò ŋɑ wɑ ɑndɛ koofɑi iluu. Nŋu do inɛ ŋɑu fei ɑ̀ wɑɑ bi ɑ ceɑ woo bɛ ŋɑu kuwee. ");
INSERT INTO mkl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ammɑ iyi woo bɛ minji ŋɑu ɑ̀ ɡbɔ ideu, ɑ̀ ɡɑ ibɔ nŋɑ ŋɑ ɑ̀ wɑɑ nyisiò iyi ɑŋɑ ɑ kù jɛsi, nɔ ɑ̀ dɔ̃ ɑnu ɑ̀ sɛi ɑ̀ wɑɑ nɛò bi zɑmɑɑu ɑ̀ wɑɑ ni, ");
INSERT INTO mkl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","nɑ mii í ce ì wɑɑ ce bɛɛbɛ, iŋɛ kpɑɑsi ŋɑ. Awɑ mɔ ɑmɑnɛi bɛi iŋɛ tɑkɑ nŋɛ. Lɑɑbɑɑu jiidɑi ɑ̀ nɑɑ ku sɔ̃ ŋɛ ku bɑ i jɔ̀ iwɛ̃ nfe nŋɛ ŋɑu nɔ i sindɑ si Ilɑɑɔ̃, nŋu iyi í jɛ icui kuwɛɛ. Nŋui í ce lele do ilɛ do tenku do mii iyi í wɑ inɔ nŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tɑko wo í jɔ̀ dimi fei wɑ too kpɑ̃ɑ iyi í bi. ");
INSERT INTO mkl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ammɑ do nŋu fei í nyisi wɑ iyi nŋu í wɛɛ domi wɑ ce nwɑ jiidɑ ŋɑ. Í jɔ̀ ijĩ wɑ wɔ ku bɑ kɑ bɑ ijɛ si iko si wɑɑtii ɑtɛ ku bɑ kɑ nɛ inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ammɑ bɑɑ do iyi Pɔlu ŋɑ ɑ̀ fɔ bɛɛbɛ fei, bɛi ɑ̀ ce ɑ̀ ɡɑnji kuweei zɑmɑɑu í ɡɑɑbu. ");
INSERT INTO mkl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ŋɔi Zuifu ɡɔ ŋɑ ɑ̀ nɑɑ hɑi Antiɔsi do hɑi Ikonimu ɑ̀ wɑ inyii itĩi inɛ ŋɑu nɔ ɑ̀ tɑ Pɔlu kutɑ ku bɑ ɑ kpɑɑ, ŋɔi ɑ̀ fɑɑ ɑ̀ bɔò ɑlɑlɑi iluu domi ɑ̀ tɑmɑɑ bɛi í kui. ");
INSERT INTO mkl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ammɑ inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu ɑ̀ nɑɑ ɑ̀ kɑɑkoɛ, ŋɔi í dede í bɔ inɔ ilu. Iju kumɑɛ ŋɔi nŋu do Bɑɑnɑbɑsi ɑ̀ dede ɑ̀ bɔ Dɛɛbu. ");
INSERT INTO mkl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Iyi Pɔlu do Bɑɑnɑbɑsi ɑ̀ to Dɛɛbu ɑ̀ wɑɑzo lɑɑbɑɑu jiidɑ si iluu nɔ inɛ nkpɔ í lɔsi kpɑ̃ɑi Jesu ku too bɛ. Si ɑnyiɛ nɔ ɑ̀ nyi ikpɑ Lisiti do Ikonimu do Antiɔsi iyi í wɑ ilɛi Pisidi. ");
INSERT INTO mkl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nɔ ɑ̀ muɑ inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesuu ɡbuɡbɑ̃ ku bɑ ɑ leekĩ si nɑɑnɛu dim dim. Nɔ ɑ̀ sɔ̃ ŋɑ ɑ̀ ni, wɑhɑlɑ nkpɔ nkpɔi ɑɑ kɑ yɛ kɑ bɛi kɑ lɔ si ɑndunyɑ titɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ŋɔi ɑ̀ cicɑɑ iɡbɛi inɛi Jesu ŋɑ fei inɛ nɡbo ŋɑ. Si ɑnyiɛ nɔ ɑ̀ ce kutɔɔ do ɑnu kudĩ ɑ̀ so ŋɑ ɑ̀ dɑɑ Lɑfɛ̃ɛ si ɑwɔ, nŋu iyi ɑ̀ dɑsi nɑɑnɛu. ");
INSERT INTO mkl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Si ɑnyii nŋu nɔ ɑ̀ nɛ hɑi bɛ ɑ̀ koo ɑ̀ lɔ ilɛi Pisidi ɑ̀ bɔ ilɛi Pɑnfili, ");
INSERT INTO mkl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","nɔ ɑ̀ to iluɛ ɡɔ iyi ɑ̀ yɑ kpe Pɛɛzu ɑ̀ ce wɑɑzo bɛ ɑ̀ bɛi ɑ̀ bɔ Atɑli. ");
INSERT INTO mkl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Hɑi bɛi ɑ̀ lɔ ɑkɔi inyi ɑ̀ nyi ikpɑ Antiɔsi si ilɛi Siri bɛ. Ilu bɛi ɑ̀ tɑko ɑ̀ le nŋɑ ɑwɔ si iri wo nɑ icɛ iyi ɑɑ koo ɑ ceu ku bɑ Ilɑɑɔ̃ ku mu nŋɑ didɔ̃ɛ. Nɔ icɛui ɑ̀ ce ɑ̀ kpɑ iriɛ wɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Iyi ɑ̀ to Antiɔsi ŋɔi ɑ̀ tɔtɔɔ inɛi iɡbɛi Jesu ŋɑ nɔ ɑ̀ sisi nŋɑ mii iyi Ilɑɑɔ̃ í ceɑ ɑŋɑ fei do si bɛi í ceò kpɑ̃ɑ hɑi jɛ Zuifu ŋɑ mɔ ɑ̀ dɑsiò nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nɔ ɑ̀ kpɛ ilu bɛ do inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ŋɔi inɛ ɡɔ ŋɑ ɑ̀ nɑɑ Antiɔsi bɛ. Inɛ ŋɑu ɑ̀ nɑɑi hɑi ilɛi Zudee, nɔ ɑ̀ wɑɑ sɔ̃ kpɑɑsi woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ̀ ni, i kɑɑ bɑ fɑɑbɑ ŋɑ bii ɑ kù dɑsi ŋɛ bɑnɡo si bɛi woodɑi Moizi wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Iyi Pɔlu do Bɑɑnɑbɑsi ɑ̀ ɡbɔ bɛɛbɛ ŋɔi ɑ̀ bɑ ŋɑ kɑkɔɔ ku ce jiidɑ jiidɑ si ideu. Ŋɔi woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ̀ cicɑ Pɔlu do Bɑɑnɑbɑsi do inɛ ɡɔ ŋɑ hɑi ilui Antiɔsi bɛ ɑ̀ bɛ ŋɑ Zeruzɑlɛmu bi woo bɛ ŋɑu do inɛ nɡbo ŋɑu nɑ irii ideu. ");
INSERT INTO mkl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pɔlu ŋɑ ɑ̀ dɑsi kpɑ̃ɑ ɑ̀ wɑɑ nɛ nɔ inɛi iɡbɛi Jesu ŋɑu ɑ̀ koo ɑ̀ leekĩ nŋɑ. Ŋɔi ɑ̀ ce isɛɛnɛ nŋɑ ɑ̀ koo ɑ̀ lɔ ilɛi Fenisi do ilɛi Sɑmɑri nɔ ɑ̀ wɑsi ku sisiɑ kpɑɑsi woo dɑsi nɑɑnɛ ŋɑu bɛi hɑi jɛ Zuifu ŋɑ mɔ ɑ̀ sindɑ idɔ nŋɑ si Jesu. Ŋɔi lɑɑbɑɑui ideu í jɔ̀ inɔi ɑŋɑ fei í dɔ̃ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Iyi ɑ̀ to Zeruzɑlɛmu, ŋɔi inɛi iɡbɛi Jesu ŋɑu do woo bɛ ŋɑu do inɛ nɡbo ŋɑu ɑ̀ ɡbɑ ŋɑ do inɔ didɔ̃. Ŋɔi Pɔlu do Bɑɑnɑbɑsi ɑ̀ sisi nŋɑ mii iyi Ilɑɑɔ̃ í ce fei nɑ icɛi ɑŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ammɑ Fɑrisi ɡɔ ŋɑ iyi ɑ̀ dɑsi Jesu nɑɑnɛ ɑ̀ dede ɑ̀ ni, hɑi jɛ Zuifu ŋɑ iyi ɑ̀ dɑsi Jesu nɑɑnɛu fei, tilɑsii ɑ dɑsi ŋɑ bɑnɡo nɔ ɑ sɔ̃ ŋɑ ɑ too woodɑi Moizi. ");
INSERT INTO mkl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ŋɔi woo bɛ ŋɑu do inɛ nɡbo ŋɑu ɑ̀ tɔtɔɔ ɑ wũɑ ideu. ");
INSERT INTO mkl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Si bɛi ɑ̀ wɑɑ fɑ ideu ŋɔi Piɛɛ í dede í ni, iŋɛ kpɑɑsim ŋɑ, ì mɑ̀ ŋɑ iyi hɑi ku kpɛ Ilɑɑɔ̃ í nyɑm hɑi si inɔ nŋɛ ku bɑ n koo n sisiɑ hɑi jɛ Zuifu ŋɑ mɔ lɑɑbɑɑu jiidɑu ku bɑ ɑŋɑ mɔ ɑ dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nɔ Ilɑɑɔ̃, nŋu iyi í mɑ̀ idɔi inɛ fei, í mu nŋɑ Hundeɛ bɛi í muɑ ɑwɑ mɔ ku bɑ ku nyisi iyi nŋu í ɡbɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kù ce nkɑ̃mɑ iyi í jɛ ikɑ̃ si ɡɑ̃mɛ nŋɑ do ɑwɑ. Í jɔ̀ idɔ nŋɑ í mɑ́ nɑ nɑɑnɛ iyi ɑ̀ dɑsiɛ bɛi í ceɑ ɑwɑ mɔ. ");
INSERT INTO mkl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Debɛi, nɑ mii í ce ì wɑɑ cɑ̃ idɔi Ilɑɑɔ̃ ŋɑ nsɛi, ì bi i kɑ̃ɑ hɑi jɛ Zuifu ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesuu ɑso iyi bɑlɑ nwɑ ŋɑ do ɑwɑ tɑkɑ nwɑ ɑ̀ mɔnɡɔ ku so. ");
INSERT INTO mkl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","À mɑ̀ iyi nɑ didɔ̃i Lɑfɛ̃ɛ Jesui ɑwɑ ɑ̀ bɑò fɑɑbɑ, nɔ bɛɛbɛ mɔi bɑɑ do hɑi jɛ Zuifu ŋɑu mɔ. ");
INSERT INTO mkl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ŋɔi inɛ ŋɑu fei ɑ̀ coko ɑ̀ wɑɑ desi Pɔlu do Bɑɑnɑbɑsi itĩ wɑɑti iyi ɑ̀ wɑɑ sisi nŋɑ yɑɑsei mɑɑmɑɑke ŋɑ iyi Ilɑɑɔ̃ í jɔ̀ ɑŋɑ ɑ̀ ce fei si wɑjui hɑi jɛ Zuifu ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Iyi ɑ̀ fɔ ide ɑ̀ tɑ̃ ŋɔi Zɑɑki mɔ í so ide í ni, iŋɛ kpɑɑsim ŋɑ, i ɡbɔ iyi ǹ wɑ n fɔ. ");
INSERT INTO mkl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɔɔ í sisi nŋɛ bɛi Ilɑɑɔ̃ í ce hɑi sinte í cicɑò inɛ ɡɔ ŋɑ hɑi si inɔi dimi mmu ŋɑu ɑ̀ kpe ŋɑ inɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nɔ ideu í jɛ ɑkɑ̃ do ti wɑlii ŋɑu si bɛi kukɔi idei Ilɑɑɔ̃ í ni, ");
INSERT INTO mkl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Amu Ilɑɑɔ̃, wɑɑti bɛɛbɛi ɑn nyi wɑ, Nɔ n teese ilei Dɑvidi iyi í cuku. An dede ile kúkúú, Nɔ n mɑɑ mɑ́, ");
INSERT INTO mkl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ku bɑ inɛ ŋɑ iyi ɑ kù jɛ inɛi kpɑsɛ̃u fei ɑ dɛdɛ ɑmu Aɔ̃ Lɑfɛ̃ɛ. Aŋɑi ɑ̀ jɛ inɛ ŋɑ iyi ɑ̀ jɛ titom hɑi si dimi mmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Bɛɛbɛi ɑmu Aɔ̃ Lɑfɛ̃ɛ ǹ fɔ, ɑmu iyi ǹ jɔ̀ ɑ̀ mɑ̀ mii ŋɑu ihɛ̃ hɑi ku kpɛ. ");
INSERT INTO mkl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nɔ Zɑɑki í ni mɑ́, nɑ nŋu, si kuyɛm, kù sĩɑ ɑ sɔ̃ hɑi jɛ Zuifu ŋɑ iyi ɑ̀ sindɑ idɔ nŋɑ si Ilɑɑɔ̃u woodɑ ku ɡɑɑbu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ammɑ kɑ ce nŋɑ tiɑ kɑ sɔ̃ ŋɑ ɑ mɑɑ̀ yɑ jɛ ijɛi kuwee, nɔ ɑ mɑɑ̀ yɑ tɔtɔɔ sɛ̃ɛ do inɑɑbo mmu ɡɔ wɑlɑkɔ inɑɑbo mɔ do mɔkɔ mmu ɡɔ, ɑ mɑɑ̀ yɑ ŋɔ iŋɑ jifɑ, nɔ ɑ mɑɑ̀ yɑ ŋɔ kpɑɑi iŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Hɑi tɑko wo, si ilu fei ɑ̀ yɑ cio woodɑi Moizi ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ si ɑjɔi kusĩmi fei nɔ ɑ wɑɑzo ideɛ. ");
INSERT INTO mkl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Iyi Zɑɑki í fɔ bɛɛbɛ í tɑ̃ ŋɔi woo bɛ ŋɑu do inɛ nɡbo ŋɑu do inɛi iɡbɛ ŋɑu fei ɑ̀ yɛ iyi í sĩɑ ku jɛ ɑŋɑ ɑ cicɑ inɛ ɡɔ ŋɑ hɑi si inɔi ɑŋɑ ɑ bɛ ŋɑ Antiɔsi do Pɔlu do Bɑɑnɑbɑsi ɑjɔ. Ŋɔi ɑ̀ cicɑ Silɑsi do Zudu iyi ɑ̀ yɑ kpe Bɑɑsɑbɑ mɑ́, ɑŋɑ iyi ɑ̀ nɛ bɛɛrɛ si inɔi kpɑɑsi woo dɑsi Jesu nɑɑnɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ŋɔi ɑ̀ ni ɑ kooò tiɑu. Si tiɑu ɑ̀ ni, Awɑ woo bɛ ŋɑ do inɛ nɡbo ŋɑu, ɑwɑ woo dɑsi nɑɑnɛ kpɑɑsi nŋɛ ŋɑ, ɑwɑi ɑ̀ sɑmbɑ nŋɛ tiɑu ihɛ̃ wɑ. Iŋɛi ɑ̀ sɑmbɑɑ wɑ, iŋɛ hɑi jɛ Zuifu woo dɑsi nɑɑnɛ ŋɑ iyi ì wɑ Antiɔsi do Siri do Silisi. À wɑɑ ce ŋɛ fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","À ɡbɔ iyi inɛ ɡɔ nwɑ ŋɑ ɑ̀ nɑɑ bi tu ŋɛ ɑ̀ fɔ inɔ nŋɛ nɔ ɑ̀ sindɑ lɑɑkɑi nŋɛ do ide nŋɑ ŋɑ. Ammɑ ɑwɑ si ɑ̀ dɑsi ŋɑ ideu bɛ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nɑ ŋɔi í jɔ̀ ɑ̀ busi njɛ nɔ ɑ̀ yɔɔ iyi í sĩɑ kɑ cicɑ inɛ ɡɔ ŋɑ kɑ bɛ si ŋɛ wɑ. Aŋɑi ɑɑ si Bɑɑnɑbɑsi do Pɔlu, bɑɑkɔɔ nwɑ ŋɑu wɑ, ");
INSERT INTO mkl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ɑŋɑ iyi ɑ kù sɑɑlu kuwɛɛ nŋɑ nɡɔɡɔ nɑ irii Lɑfɛ̃ɛ nwɑ Jesu Kirisi. ");
INSERT INTO mkl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Zudu do Silɑsi ɑŋɑi ɑ̀ jɛ inɛ ŋɑ iyi ɑ̀ cicɑu. À wɑɑ bɛ ŋɑ wɑi ɑ nɑ ɑ sɔ̃ ŋɛ ide ɑkɑ̃u ɡɛlɛò ɡɛlɛ. ");
INSERT INTO mkl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Awɑ do Hundei Ilɑɑɔ̃ í sĩɑ nwɑ si kɑ mɑɑ̀ kɑ̃ nŋɛ ɑso ɡɔ bii kù jɛ iyi ihɛ̃ iyi í jɛ ɑsoi tilɑsi. ");
INSERT INTO mkl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nŋui í jɛ, i mɑɑ̀ yɑ jɛ ijɛi kuwee ŋɑ, nɔ i mɑɑ̀ yɑ ŋɔ kpɑɑ ŋɑ, i mɑɑ̀ yɑ ŋɔ iŋɑ jifɑ ŋɑ, nɔ i mɑɑ̀ yɑ tɔtɔɔ sɛ̃ɛ do inɑɑbo mmu ɡɔ wɑlɑkɔ inɑɑbo mɔ do mɔkɔ mmu ɡɔ ŋɑ. Bii ì mu ɑrɑ nŋɛ si mii bɛɛbɛ ŋɑu bɛ ŋɑ í sĩɑ. To, kɑ sukudɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Iyi ɑ̀ tɔɔ njɛ sukudɔ̃ ɑ̀ tɑ̃ ŋɔi inɛ ŋɑu ɑ̀ dɑsi kpɑ̃ɑ ɑ̀ nɛ Antiɔsi. Bɛi ɑ̀ koo ɑ̀ tɔtɔɔ inɛi iɡbɛi Jesu ŋɑu fei ɑ̀ nɑ ŋɑ tiɑu. ");
INSERT INTO mkl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Iyi ɑ̀ cio tiɑu í mu nŋɑ ɡbuɡbɑ̃ nɔ inɔ nŋɑ í dɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Zudu do Silɑsi ŋɑ mɔ wɑlii ŋɑi, ɑ̀ muɑ kpɑɑsi woo dɑsi nɑɑnɛ ŋɑu ɡbuɡbɑ̃ nɔ ɑ̀ sobi ŋɑ si ide nkpɔ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Iyi ɑ̀ ce ɑjɔ minji bɛ kpɑɑsi woo dɑsi nɑɑnɛ ŋɑu ɑ̀ tɔɔ ŋɑ sukudɔ̃ nɔ ɑ̀ ni ɑ to bi inɛ ŋɑ iyi ɑ̀ bɛ ŋɑ wɑ bɑɑni.  ");
INSERT INTO mkl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ammɑ Silɑsi inɛ nŋu í dɑsi idɔ nŋu ku ce ɑjɔ minji bɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔlu do Bɑɑnɑbɑsi ɑ̀ ɡbe Antiɔsi bɛ. Aŋɑò inɛ nkpɔ ŋɑ ɑjɔ ɑ̀ wɑɑ kɔɑ inɛ ŋɑ si cioi idei Lɑfɛ̃ɛ nɔ ɑ̀ ce wɑɑzoɛ. ");
INSERT INTO mkl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Iyi í ce ɑjɔ minji mɑ́ ŋɔi Pɔlu í sɔ̃ Bɑɑnɑbɑsi í ni, kɑ koo kɑɑ kɑɑko kpɑɑsi nwɑ ŋɑu mɑ́ si ilu ŋɑ bii ɑ̀ tɑko ɑ̀ wɑɑzo idei Lɑfɛ̃ɛ fei wo nɔ kɑ yɛ bɛi inɛ ŋɑu ɑ̀ wɛɛò si nsɛi. ");
INSERT INTO mkl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ŋɔi Bɑɑnɑbɑsi wɑ bi ku ɡbɑ̃ Zɑ̃ɑ Mɑɑku ɑŋɑò ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ammɑ Pɔlu í fɔ í mɑnteɛ í ni kù sĩɑ ɑŋɑ ɑ ɡbɑ̃ɑ, nŋu iyi kù sobi ɑŋɑ wo si icɛu ɑmmɑ í sindɑ í jɔ̀ ɑŋɑ wɑ hɑi Pɑnfili. ");
INSERT INTO mkl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ŋɔi ɑ̀ ce kɑkɔɔ nɔ ɑ kù ɡbɔ si njɛ hee ɑ̀ nɑ ɑ̀ kpɛ̃. Ŋɔi Bɑɑnɑbɑsi í ɡbɑ̃ Mɑɑku ɑ̀ lɔ ɑkɔi inyi ɑ̀ bɔ Sipu. ");
INSERT INTO mkl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nɔ Pɔlu mɔ í cicɑ Silɑsi, nɔ kpɑɑsi woo dɑsi nɑɑnɛ ŋɑu ɑ̀ so ŋɑ ɑ̀ dɑɑ Lɑfɛ̃ɛ si ɑwɔ ɑ̀ bɛi ɑ̀ nɛ, ");
INSERT INTO mkl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ɑ̀ koo ɑ̀ lɔ ilɛi Siri do Silisi ɑ̀ wɑsi inɛi iɡbɛi Jesu ŋɑ ku muɑ ɡbuɡbɑ̃ si nɑɑnɛ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ŋɔi Pɔlu do Silɑsi ɑ̀ to Dɛɛbu do Lisiti. Wee inɛ ɡɔ í wɑ bɛ wɑ too kpɑ̃ɑi Jesu. À yɑ kpoo Timɔtee. Iyeɛ Zuifu woo dɑsi Jesu nɑɑnɛi, ɑmmɑ bɑɑɛ Gɛrɛkii. ");
INSERT INTO mkl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kpɑɑsi woo dɑsi nɑɑnɛ ŋɑ iyi ɑ̀ wɑ Lisiti do Ikonimu ɑ̀ yɑ mɑɑ fɔ jiidɑ ku jɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔlu í bi Timɔtee ku too nŋu nɔ í ɡbɑ̃ í nɛɛ. Ammɑ ku bɛi ku ɡbɑ̃ ku nɛɛ í dɑsiɛ bɑnɡoi nɑ Zuifu ŋɑ iyi ɑ̀ wɑ bɛu domi ɑŋɑ fei ɑ̀ mɑ̀ iyi bɑɑɛ Gɛrɛkii. ");
INSERT INTO mkl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nɔ ɑ̀ bɔ ilu do ilu ŋɑ ɑ̀ sɔ̃ woo dɑsi Jesu nɑɑnɛ ŋɑu mii ŋɑ iyi woo bɛ ŋɑu do inɛ nɡboi iɡbɛi Jesu ŋɑ iyi ɑ̀ wɑ Zeruzɑlɛmu ɑ̀ jilɛ nɔ ɑ̀ ni ɑ jirimɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ŋɔi woo dɑsi Jesu nɑɑnɛ ŋɑu, nɑɑnɛ nŋɑ í teese í kɔ̃ɔsi nɔ ɑkpɔ nŋɑ mɔ í yɑ mɑɑ kɔ̃ɔsii ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Hundei Ilɑɑɔ̃ í ɡɑnji Pɔlu ŋɑ ɑ wɑɑzo idei Ilɑɑɔ̃ si ilɛi Azii, ŋɔi í jɔ̀ ɑ̀ too do ikpɑ ilɛi Firizi do ti Gɑlɑti. ");
INSERT INTO mkl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Iyi ɑ̀ to ilɛi Misi ŋɔi ɑ̀ wɑɑ bi ɑ bɔ ilɛi Bitini, ɑmmɑ Hundei Jesu í kɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ŋɔi í jɔ̀ ɑ̀ too do ilɛi Misi ɑ̀ bɔ ilu iyi ɑ̀ yɑ kpe Torɑsi. ");
INSERT INTO mkl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ŋɔi Pɔlu í ce kuyɛ idũ. Si kuyɛɛu í yɛ inɛi Mɑsedɔni ɡɔ wɑ leekĩ nɔ wɑ tɔɔ nŋu ku nɑɑ Mɑsedɔni ku nɑ ku sobi ɑŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Si bɛi í ce kuyɛu ŋɔi ɡbɑkɑ̃ ɑ̀ wɑɑ dɛ kpɑ̃ɑ ku bɑ kɑ bɔ Mɑsedɔni domi ɑ̀ mɑ̀ iyi Ilɑɑɔ̃ í bi kɑɑ wɑɑzo nŋɑ lɑɑbɑɑu jiidɑu. ");
INSERT INTO mkl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hɑi Torɑsi bɛi ɑwɑ ɑ̀ lɔ ɑkɔi inyi nɔ ɡbɑkɑ̃ ɑ̀ bɔ ɡunɡũm ɡɔ iyi ɑ̀ yɑ kpe Sɑmɔtɑsi. Iju kumɑɛ nɔ ɑ̀ bɔ Neɑpolisi. ");
INSERT INTO mkl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Hɑi bɛ do kutɛi ɑ̀ nɛ ɑ̀ bɔ Filipi, ilu nlɑi Mɑsedɔni nɔ ɑ̀ ce ɑjɔ minji bɛ. Wee inɛi Romu ŋɑi ɑ̀ nɛ iluu. ");
INSERT INTO mkl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Si ɑjɔi kusĩmiu ŋɔi ɑ̀ fitɑ hɑi ilu bɛ ɑ̀ bɔ itĩi ido ɡɔ, ɑ̀ bɔ ku cɔ mɑ̀ tenɡi bii ɑ̀ yɑ ce kutɔɔ í wɑ bɛ. Ŋɔi ɑ̀ koo ɑ̀ yɛ tenɡi bii inɛ ŋɑ ɑ̀ yɑ ce kutɔɔ nɔ ɑ̀ bubɑ ɑ̀ ce fɑɑji do inɑɑbo ɡɔ ŋɑ iyi ɑ̀ tɔtɔɔ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Abo ɡɔ í wɑ bɛ ɑ̀ yɑ kpoo Lidi, inɛi Tiɑtiii, í yɑ tɑ ɑcɔi fiɑ nkpɔ nɔ í yɑ mɑɑ jirimɑ Ilɑɑɔ̃. Iyi ɑ̀ wɑɑ bɑ ŋɑ ide ku fɔ nɔ wɑ de itĩ, nɔ Lɑfɛ̃ɛ í cĩ idɔɛ ku bɑ ku ɡbɔ ide iyi Pɔlu wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Abou do inɛi kpɑsɛ̃ɛ ŋɑ fei ɑ̀ ce inyi ku dɑsi nɔ í tɔɔ wɑ í ni, bii ì mɑ̀ iyi ǹ dɑsi nɑɑnɛ ntɔ ntɔ ŋɑi i nɑɑ wɑ i nɑɑ i ce bɑɑ ɑjɔ minji kpɑsɛ̃m ŋɑ. Nɔ í mɑnte wɑ hee ɑ̀ jɛ́ nɔ ɑ̀ koo kpɑsɛ̃ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ŋɔi ɑjɔ nŋu ɡɔ iyi ɑwɑ ɑ̀ wɑɑ bɔ tenɡi bii ɑ̀ yɑ ce kutɔɔu, ɑ̀ ko ɑmɑ inɑɑbo woo ce icɛ ɡɔ iyi í nɛ inɛi inɔɔko. Bii inɛi inɔɔkou í dede siɛ í yɑ mɑɑ fɔ ide iyi ɑ́ nɑ ku cei. Nɔ lɑfɛ̃ɛɛ ŋɑ ɑ̀ wɑɑ bɑ fiɑ jiidɑ nɑ iriɛ. ");
INSERT INTO mkl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ŋɔi í too ɑwɑ do Pɔlu wɑ lɑ hee lele wɑ ni, inɛ ŋɑu ihɛ̃ woo ce icɛi Ilɑɑɔ̃ ilu ɡbuɡbɑ̃ ŋɑi. À nɑɑ ku nyisi ŋɛ kpɑ̃ɑi fɑɑbɑi. ");
INSERT INTO mkl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Bɛɛbɛi í yɑ mɑɑ fɔ ɑjɔ fei, hee ideu í cɑɑ si Pɔlu nɔ í sindɑ í sɔ̃ inɛi inɔɔkoɛu í ni, do sɑɑbui irii Jesu Kirisi ǹ ni, fitɑ. Bɛ ɡbɑkɑ̃ ŋɔi í fitɑ siɛ. ");
INSERT INTO mkl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Iyi lɑfɛ̃ɛɛ ŋɑ ɑ̀ mɑ̀ iyi ɑŋɑ ɑ kɑɑ bɑ siɛ fiɑ mɑ́, ŋɔi ɑ̀ mu Pɔlu do Silɑsi ɑ̀ tɑle ŋɑ ɑ̀ bɔò ŋɑ bɑntumɑ bi woo kiiti ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","À bɔò ŋɑ si wɑjui inɛ nɡboi Romu ŋɑ ɑ̀ ni, inɛ ŋɑu ihɛ̃ ɑ̀ wɑɑ bɛjɛ ilu nwɑi. Zuifu ŋɑi, ");
INSERT INTO mkl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","nɔ ɑ̀ wɑsi ku sisi ide ɡɔ ŋɑ iyi woodɑ nwɑ kù bi kɑ ɡbɔ hee kɑ tooɛ, ɑwɑ iyi ɑ̀ jɛ inɛi Romu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ŋɔi idɔi zɑmɑɑu í kɔ̃ si ŋɑ. Ŋɔi inɛ nɡbo ŋɑu ɑ̀ bɔ ibɔi Pɔlu do Silɑsi do ɡbuɡbɑ̃ nɔ ɑ̀ ni ɑ cɑ̃ ŋɑ do fɑɑtɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Iyi ɑ̀ cɑ̃ ŋɑ jiidɑ jiidɑ ɑ̀ tɑ̃ ŋɔi ɑ̀ koo ɑ̀ cĩmbo ŋɑ ile piisɔ̃ɔ nɔ ɑ̀ sɔ̃ woo deɡbe piisɔ̃ɔu ku deɡbe ŋɑ ku sĩɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Iyi woo deɡbeu í ɡbɔ ɑ̀ sɔ̃ɔ bɛɛbɛ, ŋɔi í koo í dɑsi ŋɑ hee ilɑɑwɑi ɑnkɑ̃ɑnyii piisɔ̃ɔu nɔ í dɑ nŋɑ si ɡbɛɛɡbɛɛkui jĩi. ");
INSERT INTO mkl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Zɑkɑi idũ lɑjɑ ŋɔi Pɔlu do Silɑsi ɑ̀ wɑɑ ce kutɔɔ nɔ ɑ̀ kɔ̃ iri ɑ̀ wɑɑ sɑɑbuò Ilɑɑɔ̃. Nɔ inɛi piisɔ̃ɔ ŋɑ iyi ɑ̀ wɑ bɛu ɑ̀ wɑɑ de si ŋɑ itĩ. ");
INSERT INTO mkl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ŋɔi ɡbɑkɑ̃ ilɛ í yɑyɑ do ɡbuɡbɑ̃ hee icui ile piisɔ̃ɔu í yɑyɑ. Ŋɔi ɡɑmbo ŋɑu fei ɑ̀ cĩ nɔ sesee ŋɑ iyi ɑ̀ dĩò inɛi piisɔ̃ɔ ŋɑu fei ɑ̀ fũ ɑ̀ cuku. ");
INSERT INTO mkl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ŋɔi ɡbɑkɑ̃ woo deɡbeu í jĩ í bɑ ɡɑmbo ŋɑu fei wɑ cĩ ŋɔi í tɑmɑɑ bɛi inɛi piisɔ̃ɔ ŋɑu ɑ̀ sɑi. Ŋɔi í nyɑ tɑɑkubɑ wɑ bi ku kpɑ ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ammɑ Pɔlu í lɑ hee lele í ni, mɑɑ̀ ceɑ ɑrɑɛ lɑɑlɔ kɑ̃mɑ. Awɑ fei ɑ̀ wɑ ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ŋɔi woo deɡbeu í dɛ fitilɑ í sɛi í lɔ hee ilɑɑwɑ bii Pɔlu do Silɑsi ɑ̀ wɑu nɔ í ɡulɛ nŋɑ do kuyɑyɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ŋɔi í fitɑò ŋɑ wɑ wɑduude í ni, i suuru ŋɑ, mii ɑn ce n bɑò fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, dɑsi Jesu Lɑfɛ̃ɛ nɑɑnɛ ɑɑ bɑ fɑɑbɑ, ɑwɔ do inɛi kpɑsɛ̃ɛ ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ŋɔi ɑ̀ wɑɑzoɑɑ idei Lɑfɛ̃ɛ Jesu, nŋu do inɛi kpɑsɛ̃ɛ ŋɑu fei. ");
INSERT INTO mkl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ŋɔi idũu bɛ woo deɡbeu í ɡbɑ̃ ŋɑ í koo í wiɛ kumɛɛ nŋɑ ŋɑu. Nɔ nŋu do inɛɛ ŋɑ fei ɑ̀ ce inyi ku dɑsi ɡbɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ŋɔi í ɡbɑ̃ Pɔlu do Silɑsi í bɔò ŋɑ lele bii ileɛ í wɑ nɔ í nɑ ŋɑ ijɛ ɑ̀ jɛ. Nŋu do inɛɛ ŋɑ fei, inɔ nŋɑ í dɔ̃ do bɛi ɑ̀ dɑsi Ilɑɑɔ̃ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Iyi iju í mɑ́ ŋɔi inɛ nɡboi Romu ŋɑ ɑ̀ bɛ polisi ŋɑ ɑ koo ɑ sɔ̃ woo deɡbeu ku jɔ̀ inɛ ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ŋɔi woo deɡbeu í sɔ̃ Pɔlu ideu í ni, inɛ nɡbo ŋɑ ɑ̀ ni n jɔ̀ ŋɛ. Nɑ nŋu, i fitɑ i nɛ nŋɛ sɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ammɑ Pɔlu í sɔ̃ polisi ŋɑu í ni, ɑɑwo. À cɑ̃ wɑ si bɑntumɑ hɑi ɑ kù ce nwɑ kiiti, ɑwɑ mɔ iyi ɑ̀ jɛ inɛi Romu ŋɑ nɔ ɑ̀ cĩmbo wɑ si ile piisɔ̃ɔ. Nɔ nsɛi ɑ̀ bi ɑ nyɑ wɑ do ɑsii? Kù jɛ bɛɛbɛi ɑ̀ yɑ ce. Í ɡbe ɑŋɑ tɑkɑ nŋɑi ɑ nɑɑ ɑ nyɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ŋɔi polisi ŋɑu ɑ̀ koo ɑ̀ sɔ̃ inɛ nɡboi Romu ŋɑu. Iyi ɑ̀ ɡbɔ Pɔlu do Silɑsi inɛi Romu ŋɑi ŋɔi ziɡi nŋɑ í dɑ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ŋɔi ɑ̀ koo ɑ̀ tɔɔ ŋɑ suuru nɔ ɑ̀ nyɑ ŋɑ hɑi ile piisɔ̃ɔu ɑ̀ bɛi ɑ̀ tɔɔ ŋɑ ɑ fitɑ hɑi inɔ iluu. ");
INSERT INTO mkl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Iyi Pɔlu do Silɑsi ɑ̀ fitɑ hɑi ile piisɔ̃ɔu ŋɔi ɑ̀ bɔ kpɑsɛ̃i Lidi. Iyi ɑ̀ koo ɑ̀ yɛ kpɑɑsi woo dɑsi nɑɑnɛ ŋɑu ɑ̀ mu nŋɑ ɡbuɡbɑ̃, ɑ̀ bɛi ɑ̀ nɛ. ");
INSERT INTO mkl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ŋɔi Pɔlu do Silɑsi ɑ̀ wɑɑ nɛ nɔ ɑ̀ lɔ ilu minji ɡɔ ŋɑ iyi ɑ̀ yɑ kpe Anfipolisi do Apoloni nɔ ɑ̀ to Tɛsɑlonikɑ bii Zuifu ŋɑ ɑ̀ nɛ ile bii ɑ̀ yɑ ce kutɔtɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ŋɔi Pɔlu í bɔ ileu bɛ si bɛi í nɛ dɔɔnɛɛ. Nɔ ɑŋɑò ŋɑ ɑ̀ wũɑ tiɑi idei Ilɑɑɔ̃ ɑjɔi kusĩmi mɛɛtɑ ɑ̀ mɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Wɑ sɔ̃ ŋɑ iyi kù nɛ bɛi ɑ́ ce iyi inɛ iyi Ilɑɑɔ̃ í cicɑu kù yɛ ijuukpɑ̃. Á kú nɔ ku jĩ hɑi si bɑlɛ mɑ́. Ŋɔi í sɔ̃ ŋɑ í ni, Jesuu iyi ǹ wɑ n sisi nŋɛ ideɛu ihɛ̃ nŋui í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Inɛ ŋɑ iyi ɑ̀ de itĩ siɛu inɛ ɡɔ ŋɑ ɑ̀ dɑsi ideu nɑɑnɛ, nɔ ɑ̀ bɑɑ ɑnu ɑkɑ̃ ku ce, nŋu do Silɑsi. Bɛɛbɛi hɑi jɛ Zuifu nkpɔ mɔ do inɑɑbo ilu iri ŋɑu ilu iri ŋɑu ɑ̀ ce, ɑŋɑ iyi ɑ̀ mɑ̀ bɛɛrɛi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ammɑ Zuifu ŋɑu ɑ̀ dedeò iɡu ku jɑ nɔ ɑ̀ tɔtɔɔ inɛ nfe ŋɑ bɛrɛtɛkɛ ɑ̀ jɔ̀ hoyɑ hoyɑ í dede nɔ ɑŋɑ fei ɑ̀ sɛi ɑ̀ bɔ Pɔlu do Silɑsi ku dɛdɛ kpɑsɛ̃i Zɑsɔ̃ɔ ku bɑ ɑ fitɑò ŋɑ wɑ si wɑjui zɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Iyi ɑ̀ dɛdɛ ŋɑ ɑ kù yɛ ŋɑ, nɔ ɑ̀ mu Zɑsɔ̃ɔ do kpɑɑsi woo dɑsi Jesu nɑɑnɛ ɡɔ ŋɑ ɑ̀ fɑ ŋɑ ɑ̀ bɔò ŋɑ bi inɛ nɡboi ilu ŋɑ. Nɔ ɑ̀ wɑsi ku lɑ ɑ̀ wɑɑ ni, inɛ ŋɑ iyi ɑ̀ wɑɑ sindɑ ɑndunyɑ feiu ɑ̀ to wɑ ihɛ̃, ");
INSERT INTO mkl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","nɔ wee Zɑsɔ̃ɔ í jɔ̀ ɑ̀ sɔ kpɑsɛ̃ɛ. Aŋɑ fei ɑ̀ wɑɑ bɛjɛ woodɑi ilɑɑlu nlɑi Romu ɑ̀ wɑɑ ni ilɑɑlu ɡɔ í wɛɛ mɑ́ iyi ɑ̀ yɑ kpe Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ŋɔi ideu í dede idɔi zɑmɑɑu do inɛ nɡboi ilu ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ŋɔi ɑ̀ ni Zɑsɔ̃ɔ do kpɑɑsiɛ ŋɑu ɑ sɑ̃ fiɑ si bɛi woodɑ í jilɛ ɑ bɛi ɑ jɔ̀ ŋɑ ɑ nɛ. Iyi ɑ̀ sɑ̃ fiɑu nɔ ɑ̀ jɔ̀ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Iyi idũ í dũ ɡbɑkɑ̃ ŋɔi kpɑɑsi woo dɑsi nɑɑnɛ ŋɑu ɑ̀ jɔ̀ Pɔlu do Silɑsi ɑ̀ nɛ Beree. Iyi ɑ̀ to bɛ ŋɔi ɑ̀ bɔ ile bii Zuifu ŋɑu ɑ̀ yɑ ce kutɔtɔɔu. ");
INSERT INTO mkl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ammɑ inɛ ŋɑ iyi ɑ̀ wɑ bɛ ŋɑu ɑ̀ lɑsɑbu si ideu do lɑɑkɑi í re Zuifu ŋɑ iyi ɑ̀ wɑ Tɛsɑlonikɑ. À ɡbɑ idei Ilɑɑɔ̃ do inɔ didɔ̃. Ajɔ fei ɑ̀ yɑ mɑɑ cio kukɔui ku bɑ ɑ mɑ̀ bii í jɛ mii iyi Pɔlu í yɑ mɑɑ sɔ̃ ŋɑu ntɔi. ");
INSERT INTO mkl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nɔ Zuifu nkpɔ í dɑsi Jesu nɑɑnɛ do inɑɑbo Gɛrɛki ɡɔ ŋɑ iyi ɑ̀ jɛ ilu iriu do inɛmɔkɔ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ammɑ Zuifu ŋɑ iyi ɑ̀ wɑ Tɛsɑlonikɑ ɑ̀ ɡbɔ iyi Pɔlu wɑ wɑɑzo idei Ilɑɑɔ̃ Beree ŋɔi ɑ̀ koo ɑ̀ dede idɔi inɛ ŋɑ ɑ̀ fɔ́ inɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bɛ ɡbɑkɑ̃ ŋɔi kpɑɑsi woo dɑsi nɑɑnɛ ŋɑu ɑ̀ bɔò Pɔlu ikpɑ tenku ku bɑ ku nɛ hɑi bɛ, ɑmmɑ Silɑsi do Timɔtee ɑ̀ ɡbe Beree bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Inɛ ŋɑ iyi ɑ̀ koo ɑ̀ leekĩɑ Pɔluu ɑ̀ bɔòɛi hee Atɛni. Ŋɔi Pɔlu í sɑmbɑ ŋɑ ɑnu í ni ɑ sɔ̃ Silɑsi do Timɔtee ɑ hɑ̃mɛɛ nŋu wɑ ńyɑ ńyɑ. Nɔ inɛ ŋɑu ɑ̀ sindɑ ɑ̀ nɛ Beree mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Wɑɑti iyi Pɔlu wɑ deɡbe ŋɑ Atɛni lɑɑkɑɛ ci yɑ sũ domi iwɛ̃ í kpɔ si iluu. ");
INSERT INTO mkl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nɑ nŋu, Zuifu ŋɑ do Gɛrɛki ŋɑ iyi ɑ̀ yɑ mɑɑ jirimɑ Ilɑɑɔ̃, í yɑ bɑ ŋɑ fɑɑji ku ce ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu. Nɔ ɑjɔ fei, inɛ ŋɑ iyi í ko si bɑntumɑi iluu ɑŋɑò ŋɑ mɔ ɑ̀ yɑ mɑɑ ce kɑkɔɔ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Si bɛi í yɑ mɑɑ bɑ ŋɑ kɑkɔɔ ku ce ŋɔi woo mɑ̀ ɡɔ ŋɑ iyi ɑ̀ jɛ inɛi Epikuri do Sitosi ŋɑ ɑ̀ bɔ bi tɛɛ ɑ̀ wɑɑ bɑɑ kɑkɔɔ ku ce. Inɛ ɡɔ ŋɑ ɑ̀ ni, woo ce ide nkpɔ yoomɑi ihɛ̃. Nɔ inɛ ɡɔ ŋɑ mɔ, iyi ɑ̀ ɡbɔ wɑ fɔ idei ikui Jesu do kujĩɛ mɑ́ ɑ̀ ni, mɑ̀ iwɛ̃ mmu ɡɔ ŋɑi wɑ fɑ̃ɑ yɑ. ");
INSERT INTO mkl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ŋɔi ɑ̀ bɔòɛ iri kutɑ ɡɔ iyi ɑ̀ yɑ kpe Arepɑɡu, tenɡi bii inɛ nɡboi ilu ŋɑu ɑ̀ yɑ ce kutɔtɔɔ nŋɑ nɔ ɑ̀ ni, ɑ̀ bi kɑ ɡbɔ ide titɔ̃ iyi ì wɑɑ dɑbiiò, ");
INSERT INTO mkl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","domi ì wɑɑ sisi nwɑ ide titɔ̃ nɔ ɑ̀ bi kɑ mɑ̀ yɑɑseɛ. ");
INSERT INTO mkl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Wee inɛi Atɛni ŋɑ fei do inɛ njoo ŋɑ iyi ɑ̀ nɑ ɑ̀ bubɑ ilu bɛ ɑ̀ yɑ so wɑɑti nŋɑ fei ɑ mɑɑ fɔ wɑlɑkɔ ɑ ɡbɔò bɑɑui mii titɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ŋɔi Pɔlu í dede í leekĩ Arepɑɡu bɛ í sɔ̃ ŋɑ í ni, iŋɛ inɛi Atɛni ŋɑ, ǹ yɛ iyi idei iwɛ̃ ŋɑi wɑ mu ŋɛ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Wɑɑti iyi ǹ wɑ n dɑbii si inɔ ilu nŋɛ ǹ yɛ mii nkpɔ iyi ì wɑɑ tɔɔ ŋɑ. Ǹ yɛ bi kuwee ɡɔ ɑ̀ kɔ si ɑ̀ ni, tenɡi ihɛ̃i ɑ̀ yɑ tɔɔ inɛ iyi ɑ kù mɑ̀. Nsɛi inɛ iyi iŋɛ ì wɑɑ tɔɔ iyi i kù mɑ̀ ŋɑu bɛ, ideɛi ǹ wɑ n sisi nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ilɑɑɔ̃, nŋu iyi í tɑkɑ ɑndunyɑu do mii iyi í wɑ si fei, nŋu iyi í jɛ Lɑfɛ̃ɛi lele do ilɛ, kɑɑ bubɑ si ile iyi ɑmɑnɛ ŋɑ ɑ̀ mɑ do ɑwɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Awɔi ɑmɑnɛ kɑɑ yɔkɔ ku muɑɑ nkɑ̃mɑ, domi kù nɛ bukɑɑtɑi nɡɔɡɔ. Nŋu tɑkɑɛi wɑ muɑ ɑmɑnɛ ŋɑ kumi do kuwɛɛ do mii fei. ");
INSERT INTO mkl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hɑi si inɛ ɑkɑ̃ iyi í tɑko í tɑkɑui dimi iyi wɑ tɛ si ɑndunyɑu ihɛ̃ fei í fitɑ. Hɑi tɑkoi í jilɛ wɑɑti nŋɑ do tenɡi bii ɑɑ mɑɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ilɑɑɔ̃ í ce bɛɛbɛi ku bɑ ɑ ce kookɑɑi ɑ mɑɑ dɛdɛɛ do kubɑbii nɔ si kudɛdɛu ɑɑ yɔɔ. Ammɑ ntɔ ntɔ Ilɑɑɔ̃ kù jĩò kɑ̃mɑ nwɑ ɡɔ, ");
INSERT INTO mkl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","domi nɑ iriɛi ɑ̀ nɛ kuwɛɛ, nɔ nŋui í jɔ̀ ɑrɑ nwɑ wɑ nɛ. Woo kɔ tiɑ nŋɛ ɡɔ ŋɑ ɑ̀ ni, ɑwɑ mɔ ɑmɑɛ ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Debɛi, si nɑ iyi í jɔ̀ ɑ̀ jɛ ɑmɑi Ilɑɑɔ̃ ŋɑ, kù sĩɑ kɑ mɑɑ ce lɑsɑbu kɑ ni Ilɑɑɔ̃ í yɛ bɛi iwɛ̃ iyi ɑmɑnɛ í lɑsɑbu í coo ku sĩɑ do wurɑ wɑlɑ do isɔ fũfũ wɑlɑ do kutɑ. ");
INSERT INTO mkl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ilɑɑɔ̃ í temuɑò ɑmɑnɛ ŋɑ wo si kumɑ̀ hɑi mɑ̀ nŋɑ, ɑmmɑ nsɛi wɑ sɔ̃ inɛ ŋɑ tenɡi bii ɑ̀ wɑ fei ɑ nɑɑ ɑ kpɑɑsi idɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nɔ í jilɛ ɑjɔ si bii inɛ iyi í cicɑu ɑ́ kiitiò inɛi ɑndunyɑ ŋɑ fei nɔ kiitiɛu dee deei ɑ́ jɛ. Nɔ í jũu tɑ̃ hɑi si bɑlɛ ku bɑ ku nyisi inɛ fei iyi inɛ bɛ ɑ́ nɑ ku cei. ");
INSERT INTO mkl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Iyi ɑ̀ ɡbɔ Pɔlu wɑ fɔ idei kujĩi iku ŋɑ hɑi si bɑlɛ ŋɔi inɛ ɡɔ ŋɑ ɑ̀ wɑɑ yɑɑkoɛ. Inɛ ɡɔ ŋɑ mɔ ɑ̀ ni, ɑ̀ bi fɑɑjii ideu bɛ mɑ́ ɑjɔ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ŋɔi Pɔlu í nɛ í jɔ̀ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Do nŋu fei, inɛmɔkɔ ɡɔ ŋɑ ɑ̀ bɔ bi tɛɛ ɑ̀ dɑsi Jesu nɑɑnɛ. Si inɔ nŋɑi Deni woo ce kiitii Arepɑɡu ɡɔ í wɑ. Abo ɡɔ mɔ iyi ɑ̀ yɑ kpe Dɑmɑrisi í dɑsi nɑɑnɛ do inɛ ɡɔ ŋɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Si ɑnyii nŋu, Pɔlu í nɛ hɑi Atɛni bɛ í bɔ Kɔrɛnti. ");
INSERT INTO mkl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ŋɔi í ko Zuifu ɡɔ bɛ iyi ɑ̀ yɑ kpe Akilɑsi, iyi ɑ̀ buu ilɛi Pɔntu. Kù kpɛ titɑ̃ iyi í nɑɑ hɑi ilɛi Itɑli, nŋu do ɑboɛ Pirisilɑ, domi Kolodu ilɑɑlu nlɑi Romu í nɑ woodɑ í ni Zuifu fei ku fitɑ hɑi Romu. Ŋɔi Pɔlu í bɔ ku cɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Nɔ í bubɑ ɑŋɑò ŋɑ ɑ̀ ce icɛ ɑjɔ domi í yɑ ce ilei ɑcɔ bɛi ɑŋɑ mɔ ɑ̀ yɑ ce. ");
INSERT INTO mkl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ajɔi kusĩmi fei í yɑ bɔ wɑɑzo ku ce ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ. Nɔ í yɑ mɑɑ mu nŋɑ ide ɑŋɑ do Gɛrɛki ŋɑu ku bɑ ɑ dɑsi Jesu nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Wɑɑti iyi Silɑsi do Timɔtee ɑ̀ to wɑ hɑi ilɛi Mɑsedɔni, Pɔlu í yɑ mɑɑ ce icɛi wɑɑzoi wɑɑti kɑ̃mɑ fei ku mɑɑ sɔ̃ Zuifu ŋɑu iyi ntɔ ntɔ Jesui í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu. ");
INSERT INTO mkl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ammɑ ɑ̀ jɑ̃ɑ nɔ ɑ̀ wɑɑ buu, ŋɔi í ɡbuɡbɑ̃ si ŋɑ irurui ibɔɛ nɔ í sɔ̃ ŋɑ í ni, bii ì nɑ ì ce nfe ŋɑ, í jɛ idei iri nŋɛ. Kù jɛ bɑɑm mɑ́. Hɑi nnyi ɑn jɔ̀ ŋɛ n koo n ceɑ hɑi jɛ Zuifu ŋɑ wɑɑzo. ");
INSERT INTO mkl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ŋɔi í nɛ hɑi bɛ í bɔ kpɑsɛ̃i Titee Zusitu, inɛ iyi í yɑ mɑɑ jirimɑ Ilɑɑɔ̃u. Ileɛ wee kɔkɔi ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔui í wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ŋɔi Kirisipu inɛ nɡboi iɡbɛu í dɑsi Lɑfɛ̃ɛ Jesu nɑɑnɛ, nŋu do inɛi kpɑsɛ̃ɛ ŋɑ fei. Inɛi Kɔrɛnti nkpɔ í ɡbɔ wɑɑzoi Pɔlu nɔ ɑŋɑ mɔ ɑ̀ dɑsi nɑɑnɛ, nɔ ɑ̀ dɑsi ŋɑ inyi. ");
INSERT INTO mkl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ŋɔi Aɔ̃ Lɑfɛ̃ɛ í sɔ̃ Pɔlu si kuyɛ idũ í ni, mɑɑ̀ ce njo. Hɑnyɑ i sɔ̃ ŋɑ, mɑɑ̀ coko, ");
INSERT INTO mkl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","domi ǹ wɛɛ do ɑwɔ. Inɛ ɡɔ kɑɑ yɔkɔ ku lesiɛ ɑwɔ hee ku ceɛ lɑɑlɔ. Sɔ̃ ŋɑ ideu domi inɛ nkpɔi í wɑ si iluu ihɛ̃ iyi ɑ́ jɛ titom. ");
INSERT INTO mkl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔlu í bubɑ ilu bɛ ɑdɔ̃ ɑkɑ̃ do bubu nɔ wɑ kɔ ŋɑ si idei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Wɑɑti iyi Gɑliɔ̃ɔ wɑ jɛ ilɑɑlu si ilɛi Gɛrɛsi, ŋɔi Zuifu ŋɑu ɑ̀ ce ɑnu ɑkɑ̃ ɑ̀ tɔtɔɔ ɑ̀ ɡbɑ̃ Pɔlu ɑ̀ bɔòɛ bi ku ce kiiti. ");
INSERT INTO mkl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","À ni, mɔkɔu ihɛ̃ njɛi wɑ lɛlɛ inɛ ŋɑ ku bɑ ɑ tɔɔ Ilɑɑɔ̃ si bɛi woodɑ nwɑ kù bi. ");
INSERT INTO mkl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Iyi Pɔlu wɑ bi ku fɔ ide, ŋɔi Gɑliɔ̃ɔ í sɔ̃ ŋɑ í ni, bii í jɛ idei kurɑrɑ wɑlɑkɔ lɑɑlɔ ɡɔi í ce ɑn nyi wɑ n nɑɑ n ɡbɔ ide nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ammɑ bii í jɛ idei kɑkɔɔ ŋɑi do idei irii inɛ ŋɑ do woodɑi iŋɛ tɑkɑ nŋɛi, iŋɛi ɑɑ wũɑ ndu ŋɛ. N kɑɑ n jɛ woo kiitii ide dimi bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ŋɔi í lele ŋɑ hɑi bi ku ce kiitiu. ");
INSERT INTO mkl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nɔ inɛ ŋɑu fei ɑ̀ mu Sɔsitɛni inɛ nɡboi iɡbɛi Zuifu ŋɑu ɑ̀ lɔsi ku cɑ̃ɑ tenɡii ɑndɛi ile bi ku ce kiitiu. Ammɑ bɑɑi Gɑliɔ̃ɔ kù wɑ si ideu. ");
INSERT INTO mkl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔlu í kpɛ Kɔrɛnti mɑ́. Si ɑnyiɛ nɔ í tɔɔ kpɑɑsi woo dɑsi nɑɑnɛ ŋɑu sukudɔ̃ nɔ í koo í wɑ iriɛ Sɑnkeree ku bɑ ku nyisi iyi í tɑko í ceɑ Ilɑɑɔ̃ kuwɑ̃ do kuɡbɑsi wo. Nɔ í lɔ ɑkɔi inyi do Pirisilɑ do Akilɑsi ɑjɔ ɑ̀ nɛ ikpɑ ilɛi Siri. ");
INSERT INTO mkl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","21","Iyi ɑ̀ to Efɛɛzu ŋɔi Pɔlu í lɔ ile bii ɑ̀ yɑ ce kutɔtɔɔ nɔ í bɑ Zuifu ŋɑu fɑɑji ku ce. Ŋɔi ɑ̀ tɔɔɛ ku ce ɑjɔ minji bi tu ŋɑ, ɑmmɑ kù wɑɑ jɛ. Iyi wɑ nɛ ŋɔi í sɔ̃ ŋɑ í ni, bii Ilɑɑɔ̃ í bi ɑn nyi wɑ mɑ́. Nɔ í jɔ̀ Pirisilɑ do Akilɑsi bɛ í koo í lɔ ɑkɔi inyi í nɛ hɑi Efɛɛzu. ");
INSERT INTO mkl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Iyi í to Sezɑree, ŋɔi í kitɑ í bɔ Zeruzɑlɛmu í koo í ce inɛi iɡbɛi Jesu ŋɑ fɔɔ. Si ɑnyiɛ nɔ í bɔ Antiɔsi. ");
INSERT INTO mkl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Iyi í ce ɑjɔ minji bɛ ŋɔi í nyi í dɑsi kpɑ̃ɑ mɑ́ í koo wɑ dɑbii si ilɛi Gɑlɑti do Firizi wɑ muɑ inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu fei ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Zuifu ɡɔ iyi ɑ̀ yɑ kpe Apolo iyi ɑ̀ bi Alesɑndiri í bɔ Efɛɛzu. Ilu bisii nɔ í mɑ̀ tiɑi idei Ilɑɑɔ̃ sɑ̃ɑ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Wee í mɑ̀ kpɑ̃ɑi idei Lɑfɛ̃ɛ nɔ í yɑ ce wɑɑzoɛ do himmɑ nɔ í sisi idei Jesu dee dee. Ammɑ inyi ku dɑsii Zɑ̃ɑ nŋu ɑkɑ̃i í mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Wɑ ce nŋɑ wɑɑzo do nɑɑnɛ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu. Ŋɔi Pirisilɑ do Akilɑsi ɑ̀ ɡbɔ wɑɑziɛ nɔ ɑ̀ kpoo ide nŋɑ ɑ̀ koo ɑ̀ teese ɑ̀ sisiɑɑ yɑɑsei idei Ilɑɑɔ̃ dee dee. ");
INSERT INTO mkl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Si ɑnyiɛ, Apolo í dɑsi idɔ nŋu ku bɔ ilɛi Gɛrɛsi. Nɔ kpɑɑsi woo dɑsi nɑɑnɛ ŋɑu ɑ̀ muɑɑ ɡbuɡbɑ̃ ku bɑ ku koo nɔ ɑ̀ ceɑ inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu iyi ɑ̀ wɑ ilɛi Gɛrɛsiu tiɑ ku bɑ bii í to bɛ ɑ coo cenkɑ̃. Wɑɑti iyi í to bɛ í sobi woo dɑsi Jesu nɑɑnɛ ŋɑu jiidɑ jiidɑ nɑ didɔ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nɔ í kɑ̃miɑ Zuifu ŋɑu do wɔɔkɔ si bɑntumɑ ku bɑ ɑ mɑ̀ iyi ɑŋɑ ɑ̀ wɑ si kurɑrɑi nɔ í nyisi ŋɑ hɑi si tiɑi idei Ilɑɑɔ̃ iyi Jesui í jɛ inɛ iyi Ilɑɑɔ̃ í cicɑu dim dim. ");
INSERT INTO mkl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Wɑɑti iyi Apolo í wɑ Kɔrɛnti Pɔlu í too kpɑ̃ɑ iyi wɑ bɔ ikpɑ iri kutɑ ŋɑu nɔ í to Efɛɛzu. Ŋɔi í bɑ inɛ ɡɔ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ŋɔi í bee ŋɑ í ni, i kù bɑ Hundei Ilɑɑɔ̃ titɑ̃ hɑi wɑɑti iyi ì dɑsi nɑɑnɛ ŋɑ? Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, ɑɑwo. A kù ɡbɔ mɑ̀ Hundei Ilɑɑɔ̃ í wɛɛ mɔm. ");
INSERT INTO mkl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ŋɔi Pɔlu í bee ŋɑ mɑ́ í ni, debɛi, inyi ku dɑsi yoomɑi ɑ̀ ce nŋɛ. Ŋɔi ɑ̀ jɛɑɑ ɑ̀ ni, inyi ku dɑsii Zɑ̃ɑi. ");
INSERT INTO mkl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ŋɔi Pɔlu í sɔ̃ ŋɑ í ni, inɛ ŋɑ iyi ɑ̀ kpɑɑsi idɔ, ɑŋɑi Zɑ̃ɑ í dɑsi inyi. Nɔ í sɔ̃ inɛ ŋɑ í ni ɑ dɑsi Jesu nɑɑnɛ, nŋu iyi ɑ́ nɑ ku nɑɑ si ɑnyii nŋu. ");
INSERT INTO mkl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Iyi ɑ̀ ɡbɔ idei Pɔluu ŋɔi ɑ̀ ce inyi ku dɑsi do irii Lɑfɛ̃ɛ Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ŋɔi Pɔlu í le nŋɑ ɑwɔ si iri nɔ Hundei Ilɑɑɔ̃ í nɑɑ si ŋɑ ŋɔi ɑ̀ wɑɑ fɔ ide do fee mmu ŋɑ nɔ ɑ̀ ce wɑlii. ");
INSERT INTO mkl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Inɛ ŋɑu ɑ̀ to zɑkɑi ɑŋɑ mɑɑteeji. ");
INSERT INTO mkl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Si ɑnyii nŋu, Pɔlu í bɔ ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔu wɑ wɑɑzo idei bommɑi Ilɑɑɔ̃ do nɑɑnɛ nɔ í ce bɛɛbɛ zɑkɑi cukpɑ mɛɛtɑ, nɔ ɑŋɑò ŋɑ ɑ̀ wɑsi ku busi njɛ nɔ í wɑsi ku lɛlɛ ŋɑ ku bɑ ɑ dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ammɑ inɛ ɡɔ ŋɑ ɑ̀ lele idɔ nŋɑ ɑ̀ kɔ ku dɑsi nɑɑnɛ, nɔ ɑ̀ nyi ɑ̀ wɑɑ fɔ ide lɑɑlɔ mɑ́ si kpɑ̃ɑi idei Lɑfɛ̃ɛ si wɑjui zɑmɑɑu. Nɑ ŋɔi í jɔ̀ Pɔlu í tɛkɛɛ hɑi bi tu ŋɑ, nŋu do inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesuu. Í yɑ mɑɑ kɔ ŋɑ si cio ɑjɔ fei si ile cioi Tiɑnusi. ");
INSERT INTO mkl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bɛɛbɛi ɑ̀ ce ɑdɔ̃ minji hee inɛ ŋɑ iyi ɑ̀ wɑ ilɛi Azii fei, hɑi Zuifu ŋɑ do hɑi jɛ Zuifu ŋɑ, ɑ̀ ɡbɔò idei Lɑfɛ̃ɛ Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ilɑɑɔ̃ í muɑ Pɔlu ɡbuɡbɑ̃ ku ceò mɑɑmɑɑke nlɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nɑ ŋɔi í jɔ̀ jɑɑɛ iyi í lu ɑrɑɛ fei, bii ɑ̀ so ɑ̀ leɑ bɔ̃ɔ ŋɑu si ɑrɑ ɑ̀ yɑ bɑ irii. Inɛ ŋɑ mɔ iyi ɑ̀ nɛ inɛi inɔɔko ŋɑ, bii ɑ̀ lu ŋɑò, inɛi inɔɔko ŋɑu ɑ̀ yɑ fitɑi. ");
INSERT INTO mkl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Zuifu ɡɔ ŋɑ ɑ̀ yɑ mɑɑ dɑbii bii fei ɑ mɑɑ nyɑ inɛi inɔɔkoi inɛ ŋɑ. Si inɔ nŋɑ ɡɔɡɔ nŋɑ ŋɑ ɑ̀ dɑsi idɔ ɑ kpe irii Lɑfɛ̃ɛ Jesu ɑ nyɑò inɛi inɔɔkoi inɛ ɡɔ. Zuifu inɛ nɡboi woo weei Ilɑɑɔ̃ ɡɔ iyi ɑ̀ yɑ kpe Sevɑ, ɑmɑ inɛmɔkɔ mɛɛjeɛ ŋɑi ɑ̀ wɑɑ bi ɑ ce bɛɛbɛ. Ajɔ nŋu ɡɔ ɑ̀ sɔ̃ inɛi inɔɔkoi inɛ ɡɔ ŋɑ ɑ̀ ni, do irii Jesu iyi Pɔlu wɑ wɑɑzou, fitɑ. ");
INSERT INTO mkl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ammɑ inɛi inɔɔkoi inɛɛu í ni, ǹ mɑ̀ Jesu nɔ ǹ mɑ̀ Pɔlu, ɑmmɑ yooi iŋɛ mɔ ì jɛ. ");
INSERT INTO mkl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ŋɔi mɔkɔ iyi í nɛ inɛi inɔɔkou í fo í bɑtɑ ŋɑ nɔ í kɑ̃miɑ ŋɑ í cɑ̃ ŋɑ í mɛɛ ŋɑ ntɔ ntɔ hee ɑŋɑ fei ɑ̀ sɑ hɑi kpɑsɛ̃ɛ bɑsĩ. ");
INSERT INTO mkl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ŋɔi inɛi Efɛɛzu ŋɑ hɑi Zuifu do Gɛrɛki ŋɑ fei ɑ̀ ɡbɔ ideu, nɔ njo í mu ŋɑ, nɔ irii Lɑfɛ̃ɛ Jesu í nɛ bɛɛrɛ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ŋɔi woo dɑsi Jesu nɑɑnɛ nkpɔ í nɑɑ í tuubɑ si bɑntumɑ. À fɔ mii iyi ɑŋɑ ɑ̀ yɑ ce wo. ");
INSERT INTO mkl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Inɛ ŋɑ iyi ɑ̀ yɑ tɑko ɑ mɑɑ ce dobu dobu wo ɑŋɑ nkpɔ nkpɔi ɑ̀ nɑɑò tiɑ nŋɑ ŋɑ iyi ɑ̀ yɑ mɑɑ ceò dobu dobuu wɑ ɑ̀ nɑɑ ɑ̀ joo si wɑjui zɑmɑɑ. Inɛ ɡɔ í ce dooɑi fiɑi tiɑ ŋɑu, nɔ ɑ̀ bɑ wee jiɑɛ í to zɑkɑi kpɛkɛlɛ dubu ciitɑɑ . ");
INSERT INTO mkl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Bɛɛbɛi ɡbuɡbɑ̃i Aɔ̃ Lɑfɛ̃ɛ í jɔ̀ idei Jesu wɑ fɑnɡɑɑ bii fei do ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Iyi nŋu ŋɑu í ce í tɑ̃, ŋɔi Pɔlu í dɑsi idɔ nŋu ku too do ilɛi Mɑsedɔni do si ilɛi Gɛrɛsi nŋu ku bɔ Zeruzɑlɛmu. Í ni bii nŋu í to bɛ, tilɑsii nŋu ku bɔ Romu mɔ. ");
INSERT INTO mkl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ŋɔi í bɛ Timɔtee do Erɑsitu, ɑŋɑ iyi ɑ̀ wɑɑ sobiɛ si icɛu, ikpɑ Mɑsedɔni, ɑmmɑ nŋu tɑkɑɛ í kpɛ keeke mɑ́ ilɛi Azii bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wɑɑti bɛɛbɛ wɑhɑlɑ nlɑ ɡɔ í dede Efɛɛzu bɛ nɑ kpɑ̃ɑi idei Jesu. ");
INSERT INTO mkl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Gbɛdɛ woo cɑ̃ isɔ fũfũ ɡɔ í wɑ bɛ ɑ̀ yɑ kpoo Demɛtiusi. Í yɑ ce mii ɡɔ ŋɑ iyi ɑ̀ jɔ ilei iwɛ̃ nŋɑ Aritemi. Nɔ woo ce icɛ dimi bɛɛbɛ ŋɑ fei ɑ̀ yɑ bɑ si ɑmɑnii jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ŋɔi í tɔtɔɔ woo ce icɛɛ ŋɑ do ɡbɛdɛ mmuɛ ɡɔ ŋɑ mɑ́ í ni, i kù mɑ̀ ŋɑ iyi si icɛu ihɛ̃i ɑ̀ wɑɑ bɑ si ɑmɑni? ");
INSERT INTO mkl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Iŋɛ tɑkɑ nŋɛ ì wɑɑ yɔɔ ŋɑ, ì nɔ ì wɑɑ ɡbɔ ŋɑ mii iyi Pɔlu wɑ ce. Wɑ ni kù jɛ iwɛ̃ ŋɑ iyi ɑmɑnɛ ŋɑ ɑ̀ ce do ɑwɔ nŋɑi ɑɑ tɔɔ. Nɔ í yɔkɔ í kɑ̃miɑ inɛ nkpɔ nkpɔ, kù nɔ kù jɛ bɑɑ Efɛɛzu ihɛ̃ nŋu ɑkɑ̃, do si ilu nkpɔi ilɛi Azii feii. ");
INSERT INTO mkl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Á nɑ ku jɔ̀ icɛ nwɑ ku bɑ iri sɑ̃mi. Si ɑnyiɛ ɑ́ nyi ku jɔ̀ ɑ kɑɑ sɑɑlu bɑɑ ilei iwɛ̃ nwɑ Aritemi, nɔ bɛɛrɛ nlɑɛ ɑ́ nɑ ku tɑ̃, iwɛ̃ iyi inɛi Azii ŋɑ do inɛi ɑndunyɑ fei wɑ tɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Iyi ɑ̀ ɡbɔ ideu ŋɔi idɔ nŋɑ í kɔ̃, nɔ ɑ̀ wɑsi ku dɔ̃ ɑnu hee lele ɑ̀ wɑɑ ni, Aritemi nwɑ í lɑ. ");
INSERT INTO mkl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ŋɔi hoyɑ hoyɑ í dede si iluu fei nɔ do ɑnu ɑkɑ̃ inɛ ŋɑ ɑ̀ fo ɑ̀ bɑtɑ Gɑyusi do Aritɑɑki ɑ̀ mu ŋɑ ɑ̀ bɔò ŋɑ bii ɑ̀ yɑ cɛiu. Inɛ ŋɑu inɛi Mɑsedɔni ŋɑi, ɑŋɑi ɑ̀ wɑɑ si Pɔlu si isɛɛnɛu. Nɔ inɛ nkpɔ í sɛi í bɔ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔlu wɑ bi ku bɔ bi zɑmɑɑu ɑmmɑ kpɑɑsi woo too kpɑ̃ɑi Jesu ŋɑu ɑ̀ kɔ. ");
INSERT INTO mkl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nɔ hee do ɑkɑwei ilɛ bɛ ŋɑ ɡɔɡɔ ŋɑ iyi ɑ̀ jɛ kpɑɑsiɛ ŋɑu ɑŋɑ mɔ ɑ̀ bɛ ɑmɑ wɑ ɑ̀ ni ɑ koo ɑ tɔɔɛ suuru ku mɑɑ̀ nɑɑ ile bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ile bɛi ɑŋɑ fei ɑ̀ wɑɑ dɔ̃ ɑnu ɑ̀ wɑsi ku fɔ ide nŋɑ ikɑ̃ ikɑ̃. Inɛ nkpɔ nŋɑ kù mɑ̀ nɑ mii í ce ɑ̀ tɔtɔɔ bɛ mɔm. ");
INSERT INTO mkl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ŋɔi Zuifu ɡɔ ŋɑ ɑ̀ sisiɑ Alesɑndu yɑɑsei ideu nɔ ɑ̀ tɑle siɛ wɑjui zɑmɑɑu. Ŋɔi Alesɑndu í ni ɑ coko do ɑwɔ nɔ wɑ bi ku sɔ̃ ŋɑ ideu do yɑɑseɛ. ");
INSERT INTO mkl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ammɑ wɑɑti iyi ɑ̀ mɑ̀ iyi nŋu mɔ Zuifui, ɑŋɑ fei ɑ̀ wɑsi ku dɔ̃ ɑnu hee zɑkɑi isɔ minji ɑ̀ wɑɑ ni, Aritemi nwɑ í lɑ. ");
INSERT INTO mkl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Si ɑnyiɛ ŋɔi woo kɔ tiɑi ilu nŋɑu í jɔ̀ ɑ̀ coko nɔ í ni, iŋɛ inɛi Efɛɛzu ŋɑ, yooi kù mɑ̀ iyi ilu nwɑi ilei Aritemi ilu bɛɛrɛu í wɑ, ɑwɑi ɑ̀ nɔ ɑ̀ wɑɑ ceɑɑ icɛ. Nɔ ì mɑ̀ ŋɑ hɑi lelei mii iyi í jɔɔu í cuku wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Inɛ ɡɔ kɑɑ yɔkɔ ku jɑ̃ ideu. Nɑ nŋu, i mu ɑrɑ nŋɛ ŋɑ i mɑɑ̀ ce nɡɔɡɔ do sɑɑsɑ. ");
INSERT INTO mkl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Inɛ ŋɑ iyi ì nɑɑò wɑ nsɛi ŋɑu ihɛ̃ ŋɑ ɑ kù ce ilei mii ndii ilei iwɛ̃ nwɑ ŋɑ ɑ kù nɔ ɑ kù fɔ lɑɑlɔɛ. ");
INSERT INTO mkl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nɑ nŋu, bii Demɛtiusi do ɡbɛdɛ ŋɑ iyi ɑ̀ wɑ bi tɛɛ ŋɑu ɑ̀ nɛ ide ɡɔ do inɛ ɡɔi ɑ̀ jilɛ ɑjɔ ŋɑ iyi ɑ̀ yɑ ce kiiti do woo ce kiiti ŋɑ, i jɔ̀ ŋɑ ɑ ce ide nŋɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nɔ bii ì nɛ ide ɡɔ si ɑntɑɛ mɑ́ ŋɑ, ɑɑ yɔkɔ i wũɑɛ bi inɛ nɡboi woo ce kiiti ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Aɑ yɔkɔ ɑ yɛ tɑɑle nwɑ ɑ ni ɑwɑi ɑ̀ dede ijɑ si idei nnyiu ihɛ̃ domi kù nɛ yɑɑse. Bɛi ɑ̀ bee wɑ yɑɑsei ideu ɑ kɑɑ kɑ bɑ iyi ɑɑ kɑ fɔ mɔm. ");
INSERT INTO mkl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi í jɔ̀ zɑmɑɑu í fɑnɡɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Iyi hoyɑ hoyɑu í leekĩ ŋɔi Pɔlu í tɔtɔɔ inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu ŋɑu í mu nŋɑ ɡbuɡbɑ̃ nɔ í tɔɔ ŋɑ sukudɔ̃ í bɛi í nɛ ilɛi Mɑsedɔni. ");
INSERT INTO mkl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Í dɑbii si ilɛu fei í muɑ inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu ŋɑ ɡbuɡbɑ̃ ntɔ ntɔ, í bɛi í to ilɛi Gɛrɛsi ");
INSERT INTO mkl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","í ce bɛ cukpɑ mɛɛtɑ. Wɑɑti iyi wɑ bi ɑkɔi inyi ku lɔ ku bɔ ilɛi Siri ŋɔi í ɡbɔ iyi Zuifu ŋɑ ɑ̀ wɑɑ dɛ nŋu ku kpɑ. Nɑ nŋu, í dɑsi idɔ nŋu ku too do ikpɑ Mɑsedɔni mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Inɛ ŋɑ iyi ɑ̀ suu si isɛɛnɛɛu wee, Sopɑtɛɛ ɑmɑi Pirusi inɛi Beree, do Aritɑɑki do Sikundusi inɛi Tɛsɑlonikɑ ŋɑ, do Gɑyusi inɛi Dɛɛbu, do Timɔtee do Tisiki do Torofimu, inɛi ilɛi Azii ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Aŋɑi ɑ̀ cuɑ ɑ̀ koo ɑ̀ deɡbe wɑ Torɑsi. ");
INSERT INTO mkl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Iyi ɑwɑ tɑkɑ nwɑ ɑ̀ jɛ jinɡɑui Pɛ̃ɛ hɑi nɛ lefeeu ɑ̀ tɑ̃ ɑ̀ koo ɑ̀ lɔ ɑkɔi inyi Filipi bɛ. Nɔ si isɛɛnɛ nwɑu si ɑjɔ miusiɑ ɑ̀ koo ɑ̀ bɑ ŋɑ Torɑsi nɔ ɑ̀ ce ɑjɔ mɛɛje bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ŋɔi ɑjɔ sintei ɑzumɑ ɑlɛu ɑwɑ ɑ̀ tɔtɔɔ ɑ̀ wɑɑ jɛ ijɛi Lɑfɛ̃ɛ, ŋɔi Pɔlu í wɑsi ku ceɑ inɛ ŋɑu wɑɑzo. Bii iju í mɑ́i Pɔlu ɑ́ nɛ. Ŋɔi í jɔ̀ wɑɑzoɛu í sɔ hee í to idũ lɑjɑ. ");
INSERT INTO mkl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Wee fitilɑ í kpɔ lelei ile kukpɛkɛ bii ɑ̀ tɔtɔɔu. ");
INSERT INTO mkl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ŋɔi ɑwɑɑsũ ɡɔ wɑ bubɑ si fɛrɛnti bɛ ɑ̀ yɑ kpoo Etiki. Si bɛi wɑɑzoi Pɔlu í sɔ ŋɔi í siiko hee í nɑ í sĩ njoo nɔ í cuku wɑ ilɛ hɑi lelei ile kukpɛkɛ mɛɛtɑsiɑu. Iyi ɑ̀ koo ɑ̀ dedeɛ ɑ̀ bɑ wee í ku. ");
INSERT INTO mkl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ŋɔi Pɔlu í kitɑ wɑ nɔ í bɑte í soo í ni, i mɑɑ̀ ce njo ŋɑ, hundeɛ í wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Iyi Pɔlu í ɡũ lelei ileu mɑ́ í so pɛ̃ɛ í bububuɛ nɔ ɑŋɑò ŋɑ ɑ̀ jɛ, nɔ í lɔsi ku wɑɑzo mɑ́ hee iju í mɑ́u í bɛi í nɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ammɑ ɑ̀ bɔòɛ Etiki iyi í nyɑ í cuku wɑu kpɑsɛ̃ bɑɑni nɔ inɔi ɑŋɑ fei í dɔ̃ jiidɑ jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Awɑ ɑ̀ koo ɑ̀ lɔ ɑkɔi inyi ɑ̀ cuɑ ɑ̀ bɔ Asosi. Tenɡi bɛi Pɔlu ɑ́ nɑ ku bɑ wɑ nɔ kɑ soo. Bɛɛbɛi í bi si nɑ iyi í jɔ̀ wɑ bi ku koo do isɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Iyi í nɑɑ í bɑ wɑ Asosi, hɑi bɛi í lɔ ɑkɔi inyi ɑwɑò ŋɑ ɑ̀ bɔ Mitilɛni. ");
INSERT INTO mkl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ŋɔi ɑ̀ nɛ hɑi bɛ nɔ iju kumɑ́ɛ ɑ̀ to ɡunɡum ɡɔ iyi ɑ̀ yɑ kpe Kio. Iju kumɑ́ mmuɛ nɔ ɑ̀ to ɡunɡum mmu ɡɔ iyi ɑ̀ yɑ kpe Sɑmɔsi, ŋɔi ɑjɔ mɛɛtɑsiɑɛ ɑ̀ to Miletu. ");
INSERT INTO mkl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Wee Pɔlu í dɑsi idɔ nŋu ku mɑɑ̀ leekĩ Efɛɛzu ku bɑ wɑɑti ku mɑɑ̀ lɔ nŋu si ilɛi Azii. Wɑ ce kookɑɑi fei ku bɑ nŋu ku to Zeruzɑlɛmu nɑ jinɡɑui Pɑntikotu. ");
INSERT INTO mkl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ŋɔi hɑi Miletu Pɔlu í bɛ ɑmɑ Efɛɛzu í ni ɑ kpe inɛ nɡboi iɡbɛi inɛi Jesu ŋɑu wɑ ɑ nɑɑ ɑ bɑ nŋu bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Iyi inɛ ŋɑu ɑ̀ to wɑ bi tɛɛ ŋɔi í sɔ̃ ŋɑ í ni, iŋɛ tɑkɑ nŋɛ ì mɑ̀ ŋɑ bɛi ǹ jɛ kuwɛɛm wɑɑti iyi ǹ wɑ si ɑnini nŋɛ hɑi ɑjɔ sinte iyi ǹ nɑɑ si ilɛi Azii. ");
INSERT INTO mkl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ǹ ce icɛi Lɑfɛ̃ɛ Jesu do ɑrɑ ku kɑye do cikɑ̃ɑju ɑjɔ, ǹ nɔ ǹ yɛ wɑhɑlɑ si nɑ iyi í jɔ̀ Zuifu ŋɑu ɑ̀ leekĩ si ɑŋɑ ɑ kpɑm. ");
INSERT INTO mkl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Iŋɛ tɑkɑ nŋɛ ì mɑ̀ mii ŋɑ iyi ɑ́ ce nŋɛ ɑrɑnfɑ̃ɑni, n kù sinɡɑ nŋɛ kɑ̃mɑɛ. Ammɑ ǹ sɔ̃ ŋɛ ntɔ fei nɔ ǹ kɔ ŋɛ si cio si bɑntumɑ do si kpɑsɛ̃ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ǹ sɔ̃ Zuifu ŋɑ do hɑi jɛ Zuifu ŋɑ ɑ nɑɑ ɑ kpɑɑsi idɔ nŋɑ ɑ sindɑ si Ilɑɑɔ̃ ɑ dɑsi Lɑfɛ̃ɛ nwɑ Jesu nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nɔ wee bɛbɛi mɑ́, Hundei Ilɑɑɔ̃ wɑ tilɑsiim n bɔ Zeruzɑlɛmu, nɔ n kù mɑ̀ mii iyi ɑ́ koo bɑm bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Amu de ǹ mɑ̀ si ilu fei Hundei Ilɑɑɔ̃ wɑ sɔ̃m iyi piisɔ̃ɔ ku ce do ijuukpɑ̃ wɑ deɡbem. ");
INSERT INTO mkl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ammɑ kuwɛɛm kù jɛ nɡɔɡɔ bi tom, n kù nɔ n kù wɑ sɑɑluɛ, ɑmu de n bɑ n tɑmbɔ icɛm iyi Jesu Lɑfɛ̃ɛ í dɑsim n ce. Icɛu nŋui í jɛ n sisi lɑɑbɑɑu jiidɑi didɔ̃ iyi Ilɑɑɔ̃ í ce nwɑ. ");
INSERT INTO mkl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Iŋɛ iyi ǹ dɑbii ǹ wɑ n wɑɑzo idei bommɑi Ilɑɑɔ̃ si ɑninii nŋɛu fei, nsɛi ǹ mɑ̀ iyi i kɑɑ yɛm mɑ́ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nɑ ŋɔi í ce ǹ wɑ n sɔ̃ ŋɛ si bɑntumɑ hɑi nnyi, bii inɛ ɡɔ nŋɛ í nɑ í ce nfe kù jɛ idei irim, ");
INSERT INTO mkl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","domi ǹ sisi nŋɛ ide iyi Ilɑɑɔ̃ í jilɛ fei n kù sinɡɑ nŋɛ ɡɔɡɔɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","I mu ɑrɑ nŋɛ ku sĩɑ, nɔ i yɑ mɑɑ deɡbe inɛ ŋɑ iyi Hundei Ilɑɑɔ̃ í dɑ nŋɛ si ɑwɔ fei, ɑŋɑ iyi ɑ̀ jɛ iɡbɛi inɛi Lɑfɛ̃ɛ Jesu ŋɑ iyi nŋu tɑkɑɛ í yɑ do njɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ǹ mɑ̀ do ɑnyim ɑmɑnɛ ŋɑ ɑɑ nɑɑ si ɑnini nŋɛ bɛi iŋɑi sɑko í yɑ nɑɑ si ɑnɡudɑ̃ ŋɑ, ɑ kɑɑ nɔ ɑ jɔ̀ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nɔ bɑɑ hɑi si inɔ nŋɛ inɛ ɡɔ ŋɑ ɑɑ kpɑɑsi ntɔu ku bɑ ku jɛ ibo nɔ ɑɑ wɑ inyii itĩi woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ jɛò mɔcɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nɑ nŋu, i wɔ njoo ŋɑ. I ye ɡiɡi ŋɑ bɛi ɑmu tɑkɑm ǹ ce ɑdɔ̃ mɛɛtɑ bi tu ŋɛ Efɛɛzu bɛ wo nɔ ǹ kɔ ŋɛ ɑkɑ̃ ɑkɑ̃ ɑlɛò dɑɑkɔ do cikɑ̃ɑju ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nsɛi ǹ so ŋɛ ǹ wɑ n dɑɑ Ilɑɑɔ̃ si ɑwɔ nɔ ǹ wɑ n dɑ nŋɛ idei didɔ̃ɛ si ɑwɔ. Nŋui ɑ́ yɔkɔ ku mu nŋɛ ɡbuɡbɑ̃ nɔ ku mu nŋɛ tubu iyi í jilɛɑ inɛ ŋɑ iyi í cicɑ ɑ jɛ tɛɛ fei. ");
INSERT INTO mkl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Wɑɑti iyi ǹ wɑ bi tu ŋɛ, iŋɛ tɑkɑ nŋɛ ì mɑ̀ ŋɑ iyi n kù nɛ kɔdɛɛi isɔ fũfũi inɛ ɡɔ hee mɑ́ jɛ wurɑ wɑlɑ ibɔɛ. ");
INSERT INTO mkl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ì nɔ ì mɑ̀ ŋɑ iyi ǹ yɑ n ce icɛi do ɑwɔm n bɛi n bɑ bukɑɑtɑi mii ŋɑ iyi ǹ bi fei, ɑmu do inɛ ŋɑ iyi ɑ̀ wɑɑ toom. ");
INSERT INTO mkl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","N nyisi ŋɛ si mii fei iyi ɑ́ sĩɑ i ce icɛ bɛɛbɛ ŋɑ i yɑ sobiò hɑi nɛ ɡbuɡbɑ̃ ŋɑ nɔ i ye ɡiɡii idei Jesu Lɑfɛ̃ɛ iyi í ni, woo ce ɑmuɑ í nɛ inɔ didɔ̃ í re inɛ iyi wɑ ɡbɑ ɑmuɑu. ");
INSERT INTO mkl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Iyi Pɔlu í fɔ bɛɛbɛ í tɑ̃ ŋɔi í ɡulɛ ɑŋɑò ŋɑ fei nɔ ɑ̀ ce kutɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ŋɔi ɑŋɑ fei ɑ̀ kpɑtɑ nɔ ɑ̀ yɑ́ɑ ɑ̀ tɔɔɛ sukudɔ̃ do kubi ");
INSERT INTO mkl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ɑ̀ bɛi ɑ̀ suu hee bi ɑkɔi inyiu. Aŋɑ fei ɑ̀ wɛɛò inɔ ku fɔi si nɑ iyi í jɔ̀ í ni ɑ kɑɑ nɑ ɑ yɛ nŋu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Iyi ɑ̀ tɔɔ ŋɑ sukudɔ̃ ŋɔi ɑwɑò Pɔlu ɑ̀ koo ɑ̀ lɔ ɑkɔi inyi ɑ̀ nɛ suusuu ɑ̀ bɔ ɡunɡum ɡɔ iyi ɑ̀ yɑ kpe Kosi, iju kumɑɛ nɔ ɑ̀ to ɡunɡum mmu ɡɔ iyi ɑ̀ yɑ kpe Rodu. Hɑi bɛ mɑ́ nɔ ɑ̀ bɔ Pɑtɑrɑ. ");
INSERT INTO mkl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Bɛi ɑ̀ bɑ ɑkɔi inyi iyi wɑ bɔ ikpɑ ilɛi Fenisi nɔ ɑ̀ lɔ ɑ̀ nɛ. ");
INSERT INTO mkl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ŋɔi ɑ̀ yɛ ɡunɡum ɡɔ iyi ɑ̀ yɑ kpe Sipu, ɑ̀ dɑleɛ do ikpɑ ɑwɔ cɑnɡɑ nɔ ɑ̀ bɔ ikpɑ ilɛi Siri. Ŋɔi ɑ̀ to Tii bii ɑkɔi inyiu ɑ́ kitɑ ɑsoɛ. ");
INSERT INTO mkl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ilu bɛi ɑ̀ yɛ inɛ ɡɔ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu nɔ ɑ̀ ce ɑjɔ mɛɛje bi tu ŋɑ bɛ. Ŋɔi Hundei Ilɑɑɔ̃ í jɔ̀ ɑ̀ sɔ̃ Pɔlu ɑ̀ ni ku mɑɑ̀ bɔ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ammɑ iyi ɑjɔi kunɛ nwɑ í to ɑ̀ nyi bi ɑkɔu mɑ́. Aŋɑ fei do ɑbo nŋɑ ŋɑ do ɑmɑ nŋɑ ŋɑ ɑ̀ nɑɑ ɑ̀ leekĩ nwɑ hɑi iluu. Awɑ fei ɑ̀ ɡulɛ itĩi tenkuu nɔ ɑ̀ ce kutɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Iyi ɑ̀ tɔɔ njɛ sukudɔ̃ ɑ̀ tɑ̃ ɑwɑ ɑ̀ lɔ ɑkɔi inyiu ɑ̀ nɛ, ŋɔi ɑŋɑ mɔ ɑ̀ nɛ ɑ̀ nyi kpɑsɛ̃ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Hɑi Tii ɑ̀ dɑsi kpɑ̃ɑ mɑ́ nɔ ɑ̀ to Tolemɑsi. Bɛi ɑ̀ kitɑ hɑi si ɑkɔi inyiu nɔ ɑ̀ koo ɑ̀ ce kpɑɑsi woo dɑsi Jesu nɑɑnɛ ŋɑ fɔɔ nɔ ɑ̀ sũ bɛ idũ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Iju kumɑ́ɛ nɔ ɑ̀ nɛ ɑ̀ bɔ Sezɑree. Nɔ ɑ̀ koo ɑ̀ sɔ kpɑsɛ̃i Filipu woo wɑɑzou, nŋu iyi wɑ jɛ inɛ ɑkɑ̃i ɑmɑnɛ mɛɛje ŋɑ iyi ɑ̀ cicɑ wo si ilui Zeruzɑlɛmuu. ");
INSERT INTO mkl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mɔkɔu í nɛ mudɛ̃ɛ mɛɛ ɡɔ ŋɑ iyi ɑ kù mɑ̀ mɔkɔ, wɑlii ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Iyi ɑ̀ ce ɑjɔ minji bɛ wɑlii ɡɔ iyi ɑ̀ yɑ kpe Aɡɑbusi í nɑɑ bɛ hɑi ilɛi Zudee. ");
INSERT INTO mkl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Í nɑɑ bi tu wɑ nɔ í so sɑntiikii Pɔlu í dĩò isɛɛ ŋɑ do ɑwɔɛ ŋɑ nɔ í ni, ide iyi Hundei Ilɑɑɔ̃ wɑ fɔ wee. Inɛ iyi í nɛ sɑntiikiu ihɛ̃ bɛ ihɛ̃i Zuifu ŋɑ iyi ɑ̀ wɑ Zeruzɑlɛmu ɑɑ dũu nɔ ɑ dɑɑ dimi mmu ŋɑ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Iyi ɑwɑ do inɛi Sezɑree ŋɑ iyi ɑ̀ wɑ bɛ ɑ̀ ɡbɔ ideu, ŋɔi ɑ̀ wɑsi ku tɔɔ Pɔlu ku mɑɑ̀ bɔ Zeruzɑlɛmu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ammɑ í ni, nɑ mii í ce ì wɑɑ kpɑtɑ bɛɛbɛ ŋɑ ì wɑɑ ɡɑnji wɔɔkɔm ŋɑ. Ǹ tɑ̃ sɔɔlu n ku nɑ irii icɛi Lɑfɛ̃ɛ Jesu Zeruzɑlɛmu bɛ, kù jɛ ku dĩ nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Iyi ɑ̀ yɛ kù ɡbɔ ide nwɑ, ɑ̀ coko nɔ ɑ̀ ni, Aɔ̃ Lɑfɛ̃ɛ ku ce idɔɔbiɛ. ");
INSERT INTO mkl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Si ɑnyii nŋu nɔ ɑ̀ dede ɑ̀ ce sɔɔlu ɑ̀ wɑɑ bɔ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ŋɔi si inɔi inɛ ŋɑ iyi ɑ̀ wɑɑ too kpɑ̃ɑi Jesu ŋɑu, inɛ ɡɔ ŋɑ ɑ̀ dede hɑi Sezɑree bɛ ɑ̀ si wɑ, nɔ ɑ̀ bɔò wɑ hee kpɑsɛ̃i Nɑsɔ̃ɔ inɛi Sipu bii ɑɑ kɑ sɔu. Mɔkɔu í dɑsi Jesu nɑɑnɛ í kpɛ. ");
INSERT INTO mkl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Iyi ɑ̀ to Zeruzɑlɛmu bɛ ŋɔi kpɑɑsi woo dɑsi Jesu nɑɑnɛ ŋɑ ɑ̀ ɡbɑ wɑ do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Iju kumɑ́ɛ ŋɔi ɑwɑò Pɔlu ŋɑ ɑ̀ bɔ bi Zɑɑki nɔ inɛ nɡboi iɡbɛi Jesu ŋɑu fei ɑ̀ tɔtɔɔ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ŋɔi Pɔlu í ce ŋɑ fɔɔ nɔ í sisi nŋɑ mii ŋɑ iyi Ilɑɑɔ̃ í ce ɑkɑ̃ ɑkɑ̃ si ɡɑ̃mɛi hɑi jɛ Zuifu ŋɑ nɑ icɛ iyi nŋu í ce. ");
INSERT INTO mkl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Iyi ɑ̀ ɡbɔ ideɛ ŋɔi ɑ̀ sɑɑbu Ilɑɑɔ̃. Ŋɔi ɑ̀ sɔ̃ Pɔlu ɑ̀ ni, kpɑɑsi nwɑ, ì ɡbɔɔ? Zuifu nkpɔ nkpɔi í dɑsi Jesu nɑɑnɛ nɔ ɑŋɑ fei ɑ̀ wɑɑ too woodɑi Moizi do himmɑ. ");
INSERT INTO mkl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ammɑ inɛ ŋɑ ɑ̀ mɑ́ɛ ide ɑ̀ ni ì wɑɑ sɔ̃ Zuifu ŋɑ iyi ɑ̀ wɑ bi dimi mmu ŋɑ ɑ jɔ̀ woodɑi Moiziu do dedembɑi bɑlɑ nwɑ ŋɑ, nɔ ɑ mɑɑ̀ yɑ dɑsi ɑmɑ nŋɑ ŋɑ bɑnɡo. ");
INSERT INTO mkl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Debɛi, bɛirei ɑɑ kɑ ce. Kù nɛ sikɑ kɑ̃mɑ inɛ ŋɑ ɑɑ mɑ̀ iyi ì to wɑ ilu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nɑ nŋu, ce iyi ɑɑ kɑ sɔ̃ɛ. Amɑnɛ mɛɛ ɡɔ ŋɑ ɑ̀ wɑ ihɛ̃ iyi ɑ̀ ceɑ Ilɑɑɔ̃ kuwɑ̃ . ");
INSERT INTO mkl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kooò ŋɑ nɔ iŋɛ fei i ce buki iyi ɑ́ jɔ̀ ì mɑ́ ŋɑ, nɔ i sɑ̃ fiɑi iri ku wɑ nŋɑ. Nŋui ɑ́ jɔ̀ inɛ fei ku mɑ̀ mii iyi ɑ̀ ɡbɔ nɑ iriɛu kù jɛ ntɔ, ɑmmɑ ɑɑ yɛ iyi ɑwɔ tɑkɑɛ ì wɑɑ too woodɑi Moizi. ");
INSERT INTO mkl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ammɑ iyi í jɛ ti dimi mmu woo dɑsi Jesu nɑɑnɛ ŋɑ, ɑwɑ ɑ̀ kɔ tiɑ ɑ̀ sɑmbɑ nŋɑ si nɑ iyi í jɔ̀ ɑ̀ yɔɔ iyi í sĩɑ kɑ jilɛ nŋɑ woodɑ kɑ ni ɑ mɑɑ̀ yɑ jɛ ijɛi kuwee nɔ ɑ mɑɑ̀ yɑ ŋɔ kpɑɑi iŋɑ nɔ ɑ mɑɑ̀ yɑ ŋɔ iŋɑ jifɑ nɔ ɑ mɑɑ̀ yɑ tɔtɔɔ sɛ̃ɛ hɑi ce ɑbɔdɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Iju kumɑ́ɛ nɔ Pɔlu í kooò inɛ ŋɑu nɔ ɑ̀ ce buki iyi ɑ́ jɔ̀ ɑ mɑ́. Si ɑnyiɛ Pɔlu í lɔ bɑntumɑi kpɑsɛ̃i Ilɑɑɔ̃ í koo í sɔ̃ woo weei Ilɑɑɔ̃ ŋɑu ɑjɔ iyi bukii ɑŋɑ ɑ́ kɔ̃, ɑjɔ nŋu bɛi ɑ ceɑ ɑŋɑ kuwee ɑkɑ̃ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Iyi ɑjɔ mɛɛjeu wɑ tɑ̃ ŋɔi Zuifu ŋɑ iyi ɑ̀ nɑɑ hɑi ilɛi Azii ɑ̀ yɛ Pɔlu kpɑsɛ̃i Ilɑɑɔ̃ bɛ. Ŋɔi ɑ̀ dede idɔi zɑmɑɑu fei nɔ ɑ̀ muu. ");
INSERT INTO mkl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","À dɔ̃ ɑnu ɑ̀ wɑɑ ni, iŋɛ inɛi Izirɛli ŋɑ, i fɑɑbɑ. Mɔkɔu ihɛ̃ í yɑ mɑɑ bɔ bii fei ku mɑɑ kɔ inɛ fei si cio ku mɑɑ fɔò tɑɑlei inɛi Izirɛli ŋɑ do woodɑi Moizi do kpɑsɛ̃i Ilɑɑɔ̃u ihɛ̃. Wee í nɑɑò dimi mmu ɡɔ ŋɑ wɑ si kpɑsɛ̃u ihɛ̃ mɑ́, nɔ í dɑsi ile kumɑ́u riisi. ");
INSERT INTO mkl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","À fɔ bɛɛbɛi si nɑ iyi í jɔ̀ ɑ̀ tɑko ɑ̀ yɛ Torofimu inɛi Efɛɛzuu, nŋu do Pɔlu si iluu, nɔ ɑ̀ tɑmɑɑ bɛi Pɔlu í nɑɑɛ wɑ kpɑsɛ̃i Ilɑɑɔ̃ bɛi. ");
INSERT INTO mkl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nɔ inɛ ŋɑ ɑ̀ cɑ̃ bii bii si iluu fei. Ŋɔi inɛ ŋɑ ɑ̀ sɛi ɑ̀ wɑsi ku nɑɑ hɑi bii fei, nɔ ɑ̀ mu Pɔlu ɑ̀ fɑɑ ɑ̀ fitɑɛ wɑ hɑi bɑntumɑi kpɑsɛ̃u. Bɛ ɡbɑkɑ̃ ɑ̀ cĩmbo ɡɑmbo ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Wɑɑti iyi ɑ̀ wɑɑ bi ɑ kpɑɑ ŋɔi inɛ nɡboi iɡũi Romu í ɡbɔ iyi hoyɑ hoyɑ í dede si ilui Zeruzɑlɛmu fei. ");
INSERT INTO mkl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ŋɔi ɡbɑkɑ̃ í so sooɡe ɡɔ ŋɑ do inɛ nɡboi sooɡe ɡɔ ŋɑ mɑ́ nɔ í sɛi í bɔò ŋɑ bi zɑmɑɑu. Iyi zɑmɑɑu í yɛ nŋu do sooɡe ŋɑu, ŋɔi ɑ̀ jɔ̀ Pɔlu ku cɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ŋɔi inɛ nɡboi iɡũu í bɔ bi Pɔlu í muu nɔ í ni ɑ dũu do sesee minji. Nɔ í bee ŋɑ í ni, yooi. Mii í ce. ");
INSERT INTO mkl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ammɑ si zɑmɑɑu inɛ ɡɔ ŋɑ ɑ̀ wɑɑ lɑ do ide ɑkɑ̃, inɛ ɡɔ ŋɑ mɔ do ide mmu hee í jɔ̀ inɛ nɡboi iɡũu kù yɔkɔ ku mɑ̀ ntɔi ideu nɑ wɑkɑtɑu. Nɑ ŋɔi í ce í ni ɑ bɔò Pɔlu bii kuwɑi sooɡe ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Iyi ɑ̀ toò Pɔlu hɑi bii ɑ̀ yɑ ɡũ ɑ lɔò inɔ ileu, ŋɔi sooɡe ŋɑu ɑ̀ soo lele nɑ kuɡɑɑbui zɑmɑɑu, ");
INSERT INTO mkl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","domi inɛ ŋɑu fei ɑ̀ wɑɑ too ŋɑ ɑ̀ wɑɑ lɑò ɑ̀ wɑɑ ni, i kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Si bɛi ɑ̀ wɑɑ bi ɑ lɔò Pɔlu inɔ ileu, ŋɔi í bee inɛ nɡboi iɡũu í ni, ɑɑ yɔɔdɑɑm n fɔ ide ɡɔ? Ammɑ inɛ nɡbou í beeɛ í ni, ɑsee ì wɑɑ ɡbɔ Gɛrɛki mɔm? ");
INSERT INTO mkl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Debɛi, i kù jɛ inɛi Ezibiti iyi si ɑjɔ ɡbeejiu ihɛ̃ í bi ku kɛkɛ ilɑɑluu nɔ í tɔtɔɔ woo kpɑ inɛ ŋɑ ɑŋɑ dubu mɛɛ í bɔò ŋɑ si ɡbɑbuɑu? ");
INSERT INTO mkl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ŋɔi Pɔlu í jɛɑɑ í ni, ɑmuu Zuifui. Amuu ɑmɑɑlui si ilu ɡɔ iyi í nyɑ iri. À bim ni Tɑrusi si ilɛi Silisi. Ǹ wɑ n tɔɔɛi, jɔ̀ n bɑ inɛ ŋɑu ide ku fɔ. ");
INSERT INTO mkl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nɔ inɛ nɡboi iɡũu í muɑɑ kpɑ̃ɑ. Ŋɔi Pɔlu wɑ leekĩ bi ku ɡũ ku lɔò inɔ ileu í ni zɑmɑɑu ku coko do ɑwɔ. Ŋɔi ɑŋɑ fei ɑ̀ coko cɑu. Nɔ Pɔlu wɑ sɔ̃ ŋɑ ide do feei Ebɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Í ni, iŋɛ kpɑɑsim ŋɑ do bɑɑm ŋɑ, i ɡbɔ iyi ǹ nɛ ku sɔ̃ ŋɛ n kɔò ɑrɑm. ");
INSERT INTO mkl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Iyi ɑ̀ ɡbɔ wɑ bɑ ɑŋɑ ide ku fɔ do feei Ebɛɛ ŋɔi ɑ̀ mu ɑrɑ nŋɑ sɛ̃ɛ í re bɑɑ bɛi ɑ̀ tɑko ɑ̀ mu ɑrɑ nŋɑ wo. Ŋɔi Pɔlu í sɔ̃ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ɑmuu Zuifui, ɑ̀ bim nii Tɑrusi si ilɛi Silisi, ɑmmɑ Zeruzɑlɛmu ihɛ̃i ɑ̀ bíím. Gɑmɑliɛlii í kɔm si cio, nŋui í kɔm si woodɑi bɑlɑ nwɑ ŋɑ sɑ̃ɑ sɑ̃ɑ, nɔ ǹ nɛ himmɑ si icɛi Ilɑɑɔ̃ si bɛi iŋɛ fei ì wɛɛò nnyi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ǹ kpɑ̃ woo too kpɑ̃ɑi Jesu ŋɑ iju jiidɑ jiidɑ hee ǹ kpɑ ɡɔɡɔ ŋɑ. Ǹ mu inɛmɔkɔ ŋɑ do inɑɑbo ŋɑ ǹ dĩ ŋɑ ǹ dɑsi ŋɑ piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Woo wee nlɑi Ilɑɑɔ̃u do iɡbɛi inɛ nɡbo ŋɑu fei ɑɑ yɔkɔ ɑ jɛ sɛɛdɑm. Hɑi si ɑwɔ nŋɑi ǹ ɡbɑ tiɑ iyi ɑ̀ kɔɑ Zuifu kpɑɑsi ŋɑ iyi ɑ̀ wɑ Dɑmɑsi. Nɔ ǹ bɔ bɛ ku bɑ n mu woo dɑsi Jesu nɑɑnɛ ŋɑ iyi ɑ̀ wɑ bɛu n dĩ ŋɑ nɔ n nɑɑò ŋɑ wɑ Zeruzɑlɛmu n jɔ̀ ɑ kpɑ̃ ŋɑ iju. ");
INSERT INTO mkl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ŋɔi Pɔlu í sɔ̃ ŋɑ mɑ́ í ni, si bɛi ǹ wɑ n koo ǹ mɑɑi Dɑmɑsi zɑkɑi dɑsɑ̃u, si kpɑ̃ɑu ɡbɑkɑ̃ ŋɔi inyɑ kumɑ́ nlɑ ɡɔ í nɑɑ sim hɑi lele í biim piu. ");
INSERT INTO mkl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ŋɔi ǹ cuku ilɛ nɔ ǹ ɡbɔ ide ku fɔ ɡɔ wɑ kpem wɑ ni, Sɔlu, Sɔlu, nɑ mii í ce ì wɑɑ kpɑ̃m iju. ");
INSERT INTO mkl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ŋɔi ǹ bee ǹ ni, ɑwɔi yoo Lɑfɛ̃ɛ. Ŋɔi í ni, ɑmui Jesu inɛi Nɑzɑrɛti, ɑmu iyi ì yɑ mɑɑ kpɑ̃ ijuu. ");
INSERT INTO mkl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Inɛ ŋɑ iyi ɑ̀ wɑɑ toom ŋɑu ɑ̀ yɛ inyɑ kumɑ́u ɑmmɑ ɑ kù ɡbɔ imui inɛ iyi wɑ bɑm ide ku fɔu. ");
INSERT INTO mkl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nɔ ǹ beeɛ ǹ ni, Lɑfɛ̃ɛ, bɛirei ɑn ce. Ŋɔi í ni, dede i bɔ Dɑmɑsi. Bɛi ɑɑ sɔ̃ɛ mii iyi Ilɑɑɔ̃ í bi i ce fei. ");
INSERT INTO mkl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kulɑi inyɑ kumɑ́u í jɔ̀ ǹ fɛɛju. Nɑ nŋu, kpɑɑsim ŋɑ ɑ̀ mu ɑwɔm nii ɑ̀ toò Dɑmɑsi. ");
INSERT INTO mkl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Wee mɔkɔ ɡɔ í wɑ bɛ ɑ̀ yɑ kpoo Anɑniɑsi, í mɑ̀ bɛɛrɛi Ilɑɑɔ̃ nɔ wɑ too woodɑi Moizi. Zuifu ŋɑ iyi ɑ̀ wɑ ilu bɛ fei ɑ̀ wɑɑ jɛ sɛɛdɑ jiidɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ŋɔi í nɑɑ bi tom nɔ í ni, Sɔlu kpɑɑsim, yɛ ilu. Tenɡi bɛ ɡbɑkɑ̃ ijum í cĩ nɔ ǹ yɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nɔ í ni mɑ́, Ilɑɑɔ̃ Lɑfɛ̃ɛi bɑlɑ nwɑ ŋɑi í cicɑɛ ku bɑ i mɑ̀ idɔɔbiɛ nɔ i yɛ Jesu Inɛ Dee deeu, nɔ i ɡbɔ idei ɡɛlɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Awɔi ɑɑ jɛ sɛɛdɑɛ i sɔ̃ inɛ fei mii iyi ì yɛ do iyi ì ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nsɛi, mɑɑ̀ jɔ̀ ku kpɛ mɑ́. Dede i kpe irii Aɔ̃ Lɑfɛ̃ɛ, i jɔ̀ ɑ dɑsiɛò inyi ku bɑ i wɛ i mɑ́ hɑi si dulum dɛɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Pɔlu í ni mɑ́, iyi ǹ nyi Zeruzɑlɛmu ŋɔi ɑjɔ nŋu ɡɔ ǹ wɑ n ce kutɔɔ kpɑsɛ̃i Ilɑɑɔ̃ nɔ ǹ ce kuyɛ. ");
INSERT INTO mkl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Si kuyɛm nɔu ǹ yɛ Lɑfɛ̃ɛ Jesu nɔ í sɔ̃m í ni n ce ńyɑ n fitɑ hɑi Zeruzɑlɛmu domi inɛ ŋɑu ɑ kɑɑ ɡbɑ ide iyi ǹ wɑ n sisi nɑ irii nŋuu. ");
INSERT INTO mkl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nɔ ǹ ni, Lɑfɛ̃ɛ, nɡu ŋɑ ɑ̀ mɑ̀ sɑ̃ɑ sɑ̃ɑ iyi ǹ yɑ n bɔ ile bii ɑ̀ yɑ ce kutɔtɔɔ ŋɑ n mu inɛ ŋɑ iyi ɑ̀ dɑsiɛ nɑɑnɛ n cɑ̃ ŋɑ nɔ n dɑsi ŋɑ piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nɔ ɑ̀ mɑ̀ si ɑjɔ iyi ɑ̀ kpɑ Etiɛni woo jɛ sɛɛdɑɛ, ɑmu tɑkɑm ǹ wɑ bɛ ǹ jɛsi ɑ kpɑɑ. Amui ǹ cɔɑ inɛ ŋɑ iyi ɑ̀ kpɑɑ ŋɑu jĩnɛ nŋɑ mɔm. ");
INSERT INTO mkl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ammɑ í sɔ̃m í ni n koo, domi hee jĩijĩ bi dimi mmu ŋɑi nŋu ɑ́ bɛm. ");
INSERT INTO mkl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Inɛ ŋɑu ɑ̀ wɑɑ desi idei Pɔlu itĩ hee í fɔ ide ŋɑu bɛ. Ammɑ wɑɑti iyi ɑ̀ ɡbɔ í ni Ilɑɑɔ̃ í bɛ nŋu bi dimi mmu ŋɑ, ŋɔi ɑŋɑ fei ɑ̀ lɔsi ku dɔ̃ ɑnu ɑ̀ wɑɑ ni, i kpɑɑ. Dimii lɑfɛ̃ɛ kù sĩɑ ku mɑɑ wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Idɔɔkɔ̃ nŋɑ í jɔ̀ ɑ̀ wɑɑ dɔ̃ ɑnu nɔ ɑ̀ bɔ ibɔ nŋɑ ŋɑ ɑ̀ nyɔɔ, nɔ ɑ̀ wɑɑ dede iruru lele. ");
INSERT INTO mkl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ŋɔi inɛ nɡboi iɡũi Romuu í ni ɑ bɔò Pɔlu inɔ ile nɔ ɑ tɛɑɑ kpɔtɔɔ ku bɑ ku fɔ ntɔ. Í ni bɛɛbɛi si nɑ iyi í jɔ̀ wɑ bi ku mɑ̀ nɑ mii í jɔ̀ zɑmɑɑu wɑ dɔ̃ siɛ ɑnu. ");
INSERT INTO mkl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Iyi ɑ̀ dĩ Pɔlu ɑ̀ wɑɑ bi ɑ cɑ̃ɑ ŋɔi í bee inɛ nɡboi sooɡe ŋɑ iyi í wɑ bɛu í ni, ì nɛ kpɑ̃ɑ i cɑ̃ inɛi Romu titɑ̃ i bɛi i ceɑɑ kiiti? ");
INSERT INTO mkl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Iyi inɛ nɡboi sooɡe ŋɑu í ɡbɔ ideu í koo í sɔ̃ inɛ nɡboi iɡũu í ni, bɛirei ɑɑ ce. Mɔkɔu inɛi Romui. ");
INSERT INTO mkl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ŋɔi inɛ nɡboi iɡũu í nɑɑ bi Pɔlu í beeɛ í ni, ɑwɔu inɛi Romui? Nɔ Pɔlu í ni, oo. ");
INSERT INTO mkl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ŋɔi inɛ nɡboi iɡũu í ni, ɑmu ǹ sɑ̃ fiɑi jiidɑ jiidɑ ǹ bɛi ǹ jɛò inɛi Romu. Ŋɔi Pɔlu í jɛɑɑ í ni, ɑmu, bɛɛbɛi ɑ̀ bím. ");
INSERT INTO mkl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ŋɔi ɡbɑkɑ̃ inɛ ŋɑ iyi ɑ̀ wɑɑ bi ɑ cɑ̃ɑu ɑ̀ jɔ̀ɔ, domi njo í mu bɑɑ inɛ nɡboi iɡũu tɑkɑɛ do iyi í ɡbɔ Pɔlu tɑkɑɛ inɛi Romui nɔ wee nŋu í jɔ̀ ɑ̀ dũu do sesee wo. ");
INSERT INTO mkl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Inɛ nɡboi iɡũu í bi nŋu ku mɑ̀ kɑm kɑm mii iyi í jɔ̀ Zuifu ŋɑu ɑ̀ wɑɑ yɛ tɑɑlei Pɔlu. Nɑ ŋɔi í jɔ̀ iju kumɑ́ɛ í jɔ̀ ɑ̀ fũu, nɔ í ni inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ do iɡbɛi woo kiiti ŋɑu fei ɑ tɔtɔɔ wɑ. Nɔ í bɔò Pɔlu wɑju nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔlu í kɑ̃si inɛ ŋɑ iyi ɑ̀ tɔtɔɔu iju nɔ í ni, iŋɛ kpɑɑsim ŋɑ, idɔm kɑɑ yɛ tɑɑlem domi ǹ ce kuwɛɛm nii dee dee si wɑjui Ilɑɑɔ̃ hee do nnyi fei. ");
INSERT INTO mkl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ŋɔi Anɑniɑsi woo wee nlɑu, í sɔ̃ inɛ ŋɑ iyi ɑ̀ wɑɑ leekĩ bi Pɔluu í ni ɑ cɑ̃ɑ si ɡɛlɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nɔ Pɔlu í buu í ni, Ilɑɑɔ̃i ɑ́ cɑ̃ɛ, ɑwɔ idĩ fũfũ ! Ì bubɑ ì wɑɑ kiitiim si woodɑi Moizi, nɔ ì kuɑ woodɑ mɑ́ ì ni ɑ cɑ̃m. ");
INSERT INTO mkl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ŋɔi inɛ ŋɑ iyi ɑ̀ wɑɑ leekĩ kɔkɔɛu ɑ̀ ni, woo wee nlɑi Ilɑɑɔ̃i ì yɔkɔ ì wɑɑ bu bɛɛbɛ? ");
INSERT INTO mkl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ŋɔi Pɔlu í ni, kpɑɑsim ŋɑ, n kù mɑ̀ mɑ̀ woo wee nlɑi. Ǹ mɑ̀ iyi kukɔi idei Ilɑɑɔ̃ í ni, i mɑɑ̀ yɑ fɔ tɑɑlei ilu iri nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔlu í mɑ̀ si iɡbɛu inɛ ɡɔ ŋɑ Sɑdusi ŋɑi, inɛ ɡɔ ŋɑ mɔ Fɑrisi ŋɑi. Ŋɔi í fɔ ide hee lele si iɡbɛu í ni, iŋɛ kpɑɑsim ŋɑ, ɑmuu Fɑrisii, inɛ iyi Fɑrisi ŋɑ ɑ̀ bí. Ì wɑɑ kiitiim ŋɑi si nɑ iyi í jɔ̀ ǹ dɑsi nɑɑnɛ iyi iku ŋɑ ɑɑ nɑ ɑ jĩ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Iyi í fɔ bɛɛbɛ ɡbɑkɑ̃, ŋɔi Fɑrisi ŋɑu do Sɑdusi ŋɑu ɑ̀ wɑɑ ce kɑkɔɔ nɔ iɡbɛu í kpɛ̃ minji. ");
INSERT INTO mkl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sɑdusi ŋɑ ɑ̀ yɑ ni iku ŋɑ ɑ kɑɑ jĩ hɑi si bɑlɛ, ɑmɑlekɑ do hunde mmu ɡɔ ŋɑ mɔ ɑ kù wɛɛ, ɑmmɑ Fɑrisi ŋɑ ɑ̀ jɛsi iyi mii ŋɑu bɛ fei í wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nɔ wɑkɑtɑ í dede si ɑnini nŋɑ ɑ̀ wɑɑ jɑ̃ do ɡbuɡbɑ̃, nɔ Fɑrisi woo kɔ inɛ ŋɑ si woodɑ ɡɔ ŋɑ ɑ̀ ni, ɑ kù yɛ tɑɑlei mɔkɔu. Yooi í mɑ̀ mɑ̀ ɑmɑlekɑ ɡɔi wɑlɑkɔ hunde mmu ɡɔi í sɔ̃ɔ ide. ");
INSERT INTO mkl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ŋɔi kɑkɔɔu í lɑ ntɔ ntɔ hee njo í mu inɛ nɡboi iɡũu jiidɑ ɑ mɑɑ̀ nɑ ɑ ɡɑ ɑrɑi Pɔlu. Nɔ í ni sooɡe ŋɑu ɑ koo ɑ ɡbɑ̃ Pɔlu wɑ ɑ nyiòɛ inɔ ileu. ");
INSERT INTO mkl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Idũ ɑjɔ nŋu Aɔ̃ Lɑfɛ̃ɛ í nɑɑ í sɔ̃ Pɔlu í ni, mɑɑ̀ mɔnɡɔ munyɑ. Si bɛi ì jɛɛm sɛɛdɑ Zeruzɑlɛmu ihɛ̃, bɛɛbɛ mɔi ɑɑ jɛɛm sɛɛdɑ Romu mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Iju kumɑ́ɛ dɑɑdɑɑkɔ ŋɔi Zuifu ŋɑu ɑ̀ ce ɑnu ɑkɑ̃ nɔ ɑ̀ ceekpe ɑ̀ ni ɑŋɑ ɑ kɑɑ jɛ hee mɑ́ jɛ ɑ mɔ bii kù jɛ ɑ̀ kpɑ Pɔlu sisi. ");
INSERT INTO mkl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Aŋɑ iyi ɑ̀ ce ɑnu ɑkɑ̃u ɑ̀ re bɑɑ ɑŋɑ ciiji. ");
INSERT INTO mkl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ŋɔi ɑ̀ koo ɑ̀ bɑ inɛ nɡbo ŋɑ do inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu ɑ̀ sɔ̃ ŋɑ ɑ̀ ni, ɑ̀ ceekpe iyi ɑ kɑɑ kɑ tiɛ nɡɔɡɔ bii kù jɛ ɑ̀ bɑ ɑ̀ kpɑ Pɔlu sisi. ");
INSERT INTO mkl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nɑ nŋu, ɑ̀ bi iŋɛ do iɡbɛi woo kiiti ŋɑu i koo i sɔ̃ inɛ nɡboi iɡũu ku nɑɑò Pɔlu wɑ bi tu ŋɛ, nɔ ku jɔ bɛi ì wɑɑ bi i teese i cɔ yɑɑsei ideɛu mɑ́ ŋɑ. Awɑ ɑɑ kɑ ce sɔɔlu kɑ kpɑɑ hee ku mɑɑ to wɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ammɑ ɑmɑ inɛmɔkɔi wecĩi Pɔlu í ɡbɔ ɑ̀ wɑɑ fɔ idei zɑmbɑu. Ŋɔi í koo í lɔ idei sooɡe ŋɑu nɔ í sɔ̃ Pɔlu ideu. ");
INSERT INTO mkl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ŋɔi Pɔlu í kpe inɛ ɑkɑ̃i inɛ nɡboi sooɡe ŋɑu í sɔ̃ɔ í ni, bɔò ɑmɑ ɑwɑɑsũ ihɛ̃ bi inɛ nɡboi iɡũu domi í nɛ ide ɡɔ iyi ɑ́ sɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ŋɔi inɛ nɡboi sooɡe ŋɑu í bɔò ɑwɑɑsũu bi inɛ nɡboi iɡũu, nɔ í sɔ̃ɔ í ni, Pɔlu inɛi piisɔ̃ɔu í kpem nɔ í tɔɔm n nɑɑò ɑwɑɑsũu ihɛ̃ wɑ bi titɛɛ, domi wɑ bi ku sɔ̃ɛ ide ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ŋɔi inɛ nɡboi iɡũu í mu ɑwɔi ɑwɑɑsũu í bɔòɛ kɔkɔlɛ í beeɛ í ni, ide mii ì wɑɑ bi i sɔ̃m. ");
INSERT INTO mkl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ŋɔi í ni, Zuifu ŋɑ ɑ̀ ce ɑnu ɑkɑ̃ ɑ̀ tɔɔɛ ɑlɑ i bɔò Pɔlu bi iɡbɛi woo kiiti ŋɑu, nɔ ku jɔ bɛi ɑ̀ wɑɑ bi ɑ teese ɑ cɔ yɑɑsei ideɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ammɑ mɑɑ̀ ti i ɡbɔ ide nŋɑu, domi ɑ̀ re bɑɑ ɑŋɑ ciiji inɛ ŋɑ iyi ɑ̀ wɑɑ siɑɑ kpɑ̃ɑ ku bɑ ɑ muu. Nɔ ɑŋɑ fei ɑ̀ ceekpe ɑ̀ ni ɑŋɑ ɑ kɑɑ jɛ ɑ kɑɑ mɔ bii kù jɛ ɑ̀ kpɑɑ. Bɑɑ nsɛi ɑ̀ tɑ̃ sɔɔlu ɑ coo. Awɔ ɑkɑ̃i ɑ̀ wɑɑ deɡbe i jɔ̀ ku nɑɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ŋɔi inɛ nɡboi iɡũu í ni, mɑɑ̀ sɔ̃ inɛ ɡɔ i ni ì sisiim ideu ihɛ̃ mɑ́. Nɔ í jɔ̀ ɑwɑɑsũu í nɛ. ");
INSERT INTO mkl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ŋɔi inɛ nɡboi iɡũu í kpe inɛ nɡboi sooɡe minji ɡɔ ŋɑ í sɔ̃ ŋɑ í ni, i tɔtɔɔ sooɡe cĩɔ minji ɑ bɔ Sezɑree do mɑsɑ kitɑò fɛɛwɑ do ilu kɑkɑɑ ŋɑ ɑŋɑ cĩɔ minji i ce sɔɔlu i dɑsi kpɑ̃ɑ isɔ mɛɛsɑ̃i ɑlɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Nɔ i dĩɑ ɑcĩ ŋɑ ɡɑɑyi nɔ i so Pɔlu i kooòɛ bi Felisi ilu ilɛu bɑɑni. ");
INSERT INTO mkl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Iyi í fɔ bɛɛbɛ í tɑ̃ ŋɔi í kɔ tiɑ mɑ́ í ni, ");
INSERT INTO mkl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ɑmu Kolodu Lisiɑsi, ǹ wɑ n ceɛ fɔɔ, ɑwɔ Felisi ilu ilɛ ilu bɛɛrɛ nlɑ nlɑu. ");
INSERT INTO mkl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mɔkɔu ihɛ̃ wee ǹ jɔ̀ ɑ̀ nɑɑòɛ wɑ bi tɛɛ. Zuifu ŋɑ ɑ̀ muui ɑ̀ wɑɑ bi ɑ kpɑɑ. Iyi ǹ mɑ̀ iyi inɛi Romui ŋɔi ǹ koo do sooɡem ŋɑ nɔ ǹ ɡbɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ǹ bi n mɑ̀ nɑ mii í ce ɑ̀ wɑɑ yɛ tɑɑleɛ. Nɑ nŋu, ǹ bɔòɛ si wɑjui iɡbɛi woo kiiti nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Hɑi bɛi ǹ yɔɔ iyi ɑ̀ wɑɑ yɛ tɑɑleɛi nɑ woodɑ nŋɑ ɑmmɑ kù ce nɡɔɡɔ iyi í to ɑ dɑsiɛ piisɔ̃ɔ mɔm hee mɑ jɛ ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Si ɑnyiɛ ǹ ɡbɔ iyi Zuifu ŋɑu ɑ̀ ce ɑnu ɑkɑ̃ ku bɑ ɑŋɑ ɑ kpɑɑ, ŋɔi ɡbɑkɑ̃ ǹ jɔ̀ ɑ̀ nɑɑòɛ wɑ bi tɛɛ. Nɔ ǹ sɔ̃ inɛ ŋɑ iyi ɑ̀ wɑɑ yɛ tɑɑleɛ ɑ nɑɑ ɑ fɔ ide nŋɑ si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Iyi í kɔ tiɑu í tɑ̃ nɔ í soo í nɑ sooɡe ŋɑu. Ŋɔi sooɡe ŋɑu ɑ̀ ce bɛi í sɔ̃ ŋɑu fei, ɑ̀ so Pɔlu idũu ɑ̀ bɔòɛ hee Antipɑtisi. ");
INSERT INTO mkl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Iju kumɑɛ ŋɔi sooɡe ŋɑu ɑ̀ nyi bi ileu nɔ mɑsɑ ŋɑu ɑ̀ wɑɑ bɔò Pɔlu bi Felisi ilu ilɛu. ");
INSERT INTO mkl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Iyi ɑ̀ to Sezɑree ɡbɑkɑ̃ ŋɔi ɑ̀ nɑɑ tiɑu nɔ ɑ̀ nyisiɛ Pɔlu. ");
INSERT INTO mkl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Iyi í cio tiɑu í tɑ̃ ŋɔi í bee Pɔlu hɑi bii í nɑɑ. Ŋɔi Pɔlu í ní hɑi ilɛi Silisii. ");
INSERT INTO mkl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Nɔ Felisi í ni, ɑwɔi ɑɑ sisiim ideɛ bii woo yɛ tɑɑleɛ ŋɑu ɑ̀ to wɑ. Nɔ í ni ɑ dɑsi Pɔlu kpɑsɛ̃i ɑmɑnlu Herodu. ");
INSERT INTO mkl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Iyi í ce ɑjɔ miu ŋɔi Anɑniɑsi woo wee nlɑi Ilɑɑɔ̃u í bɔ Sezɑree nŋu do inɛ nɡbo ɡɔ ŋɑ do woo mɑ̀ woodɑ ɡɔ iyi ɑ̀ yɑ kpe Tɛɛtulu. Ŋɔi ɑ̀ bɔ bi Felisi ilu ilɛu ɑ̀ koo ɑ̀ wɑɑ fɔ tɑɑlei Pɔlu. ");
INSERT INTO mkl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ŋɔi ɑ̀ kpe Pɔlu wɑ nɔ Tɛɛtulu í lɔsi ide ku fɔ wɑ yɛò tɑɑleɛ wɑ ni, ɑwɔ Felisi ilu bɛɛrɛ nlɑ, ɑ̀ nɛ lɑɑkɑi ku sũ ntɔ ntɔ do bɑɑkɑɛ. Ilu ku yɛ jiidɑɛ í jɔ̀ ì kpɑɑsi mii nkpɔ nɑ ɑrɑnfɑ̃ɑnii ilɛ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","À jɛsi mii iyi ì wɑɑ ce fei bii fei si wɑɑti kɑ̃mɑ fei do sɑɑbu jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","A kù bi kɑ kpɑ wɑɑtiɛ ɑmmɑ ɑ̀ wɑɑ tɔɔɛ i cɔ wɑ do iju jiidɑ nɔ i ɡbɔ ide keeke iyi ɑ̀ nɛu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","À yɛ iyi mɔkɔu ihɛ̃ ilu nɑɑnɑui, nɔ í nɛ kòsi si ɑninii Zuifu ŋɑ si ɑndunyɑu ihɛ̃ fei. Nŋui í jɛ inɛ nɡboi kpɑ̃ɑi Aɔ̃ ku tɔɔ ɡɔ iyi ɑ̀ yɑ kpe inɛi Nɑzɑrɛti ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Í dɛ kpɑ̃ɑ mɔm ku riisiò kpɑsɛ̃i Ilɑɑɔ̃u. Nŋui í jɔ̀ ɑ̀ muu. À bi kɑ kiitiɛ do woodɑ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ammɑ Lisiɑsi inɛ nɡboi iɡũu í nɑɑ í ɡbɑɑ hɑi si ɑwɔ nwɑ do ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nɔ í ni woo yɛ tɑɑleɛ ŋɑu ɑ nɑɑ bi tɛɛ. Awɔ tɑkɑɛ beeɛ ide, ɑɑ yɔkɔ i ɡbɔ ntɔi ideu si bii í jɔ̀ ɑ̀ wɑɑ yɛ tɑɑleɛu. ");
INSERT INTO mkl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Iyi Tɛɛtulu í fɔ bɛɛbɛ í tɑ̃ nɔ Zuifu ŋɑ iyi ɑ̀ wɑ bɛu fei ɑ̀ ni ideu ntɔi. ");
INSERT INTO mkl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ŋɔi Felisi ilu ilɛu í tosi Pɔlu ɑwɔ í ni ku fɔ ideɛ. Ŋɔi Pɔlu í ni, ǹ mɑ̀ iyi ɑwɔi ì jɛ woo ce kiitii ilɛu ihɛ̃ hɑi ku kpɛ. Nɑ nŋu, ɑn kɔò ɑrɑm do lɑɑkɑi ku sũ. ");
INSERT INTO mkl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Bii ì bee ɑɑ sɔ̃ɛ iyi kù re ɑjɔ mɑɑteeji wɑ iyi ǹ bɔ Zeruzɑlɛmu Ilɑɑɔ̃ ku ɡulɛɑ. ");
INSERT INTO mkl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Inɛ kɑ̃mɑ kù yɛm bii ǹ wɑ n ce kɑkɔɔ do inɛ ɡɔ titɑ̃ hee mɑ́ jɛ n kòsi ŋɑ ijɑ si kpɑsɛ̃i Ilɑɑɔ̃ wɑlɑkɔ ile bii ɑ̀ yɑ ce kutɔtɔɔ nŋɑ ŋɑ wɑlɑkɔ si inɔ ilu nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ide iyi ɑ̀ wɑɑ mɑ́m nɔu bɛ nsɛi, nkɑ̃mɑ kù wɛɛ iyi wɑ nyisi iyi ntɔi. ");
INSERT INTO mkl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ammɑ ide ɑkɑ̃i ɑn jɛsi si wɑjuɛ, ǹ wɑ n tɔɔ Ilɑɑɔ̃ Lɑfɛ̃ɛi bɑlɑ nwɑ ŋɑ do kpɑ̃ɑ iyi inɛ ihɛ̃ ŋɑ ɑ̀ wɑɑ ni iboi. Do nŋu fei, ǹ wɑ n jirimɑ woodɑi Moizi ŋɑu do tiɑi wɑlii ŋɑu fei. ");
INSERT INTO mkl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ǹ dɑsi nɑɑnɛ iyi Ilɑɑɔ̃ ɑ́ jĩ ɑmɑnɛ jiidɑ ŋɑ do ɑmɑnɛ lɑɑlɔ ŋɑ hɑi si bɑlɛ, bɛi ɑŋɑ mɔ ɑ̀ dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nŋui í jɔ̀ ɑmu mɔ ǹ wɑ n hɑnyɑ ɑjɔ fei ku bɑ idɔm ku mɑɑ̀ yɛ tɑɑlem si wɑjui Ilɑɑɔ̃ do si wɑjui inɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Adɔ̃ nkpɔ nkpɔi í lɔ n kù bɔ Zeruzɑlɛmu. Si ɑjɔ ɡbeejiu ihɛ̃i ǹ koo bɛ ǹ bɔ ku sobi inɛi ilɛm ŋɑ do fiɑ nɔ n ceɑ Ilɑɑɔ̃ ɑmuɑ. ");
INSERT INTO mkl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Si nŋui ɑ̀ bɑm kpɑsɛ̃i Ilɑɑɔ̃ bɛ ǹ wɑ n ce bukii ɑrɑ ku mɑ́m. Zɑmɑɑ kɑ̃mɑ kù wɑ bɛ, ijɑ ku kòsi mɔ kù wɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ammɑ Zuifui ilɛi Azii ɡɔ ŋɑ ɑ̀ wɑ bɛ. Á sĩɑ ɑŋɑ tɑkɑ nŋɑ ɑ nɑɑ ɑ jɛ sɛɛdɑ si wɑjuɛ bii í jɛ ɑ̀ yɛ sim tɑɑle ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Wɑlɑkɔ jɔ̀ inɛ ŋɑu ihɛ̃ ɑ fɔ tɑɑle iyi ɑ̀ yɛ sim si wɑɑti iyi ɑ̀ leekĩim si wɑjui iɡbɛi woo kiiti ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","A kù yɛ tɑɑlem si nkɑ̃mɑ bii kù jɛ si ide ɑkɑ̃u ihɛ̃ iyi ǹ fɔ hee lele ǹ ni iku ŋɑ ɑɑ nɑ ɑ jĩ hɑi si bɑlɛ. Nɑ ŋɔi í jɔ̀ ɑ̀ wɑɑ kiitim si wɑjuɛ nnyi mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Wee Felisi í mɑ̀ yɑɑsei kpɑ̃ɑi woo dɑsi Jesu nɑɑnɛ ŋɑ sɑ̃ɑ sɑ̃ɑ, ŋɔi í sɔ̃ Zuifu ŋɑu í ni, i jɔ̀ Lisiɑsi inɛ nɡboi iɡũu ku to wɑ, ɑjɔ nŋui ɑn wũɑ ide nŋɛu. ");
INSERT INTO mkl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nɔ í sɔ̃ inɛ nɡboi sooɡe ŋɑu í ni ku mu Pɔlu titɑ̃, ɑmmɑ ku jɔ̀ ku nɛ ɑrɑɛ keeke nɔ kú yɑ jɔ̀ kpɑɑsiɛ ŋɑ ɑ yɑ nɑɑ ɑ cɔɔ nɔ ɑ mɑ́ɑ ɡbɔɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Iyi wɑɑti í lɔ keeke ŋɔi Felisi í nɑɑò ɑbo Zuifuɛ ɡɔ wɑ, ɑ̀ yɑ kpoo Dusilɑ. Ŋɔi í ni ɑ koo ɑ kpe Pɔlu wɑ. Iyi í to wɑ nɔ ɑ̀ wɑɑ desiɛ itĩ si bɛi wɑ fɔ idei nɑɑnɛ ku dɑsi si Jesu Kirisi. ");
INSERT INTO mkl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ammɑ si bɛi Pɔlu wɑ sisi nŋɑ idei dee dee ku jɛ do ɡɑyɑ do kiiti iyi wɑ nɑɑ, ziɡii Felisi í dɑ nɔ í ni, ɑɑ yɔkɔ i nɛ titɑ̃. Bii ǹ bɑ fɑyɑ ɑn kpeɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Wee wɑ bi Pɔlu ku muɑ nŋu fiɑi. Ŋɔi í ce í yɑ mɑɑ kpoo kpɑɑ kpɑɑ ɑŋɑò ɑ mɑɑ fɔ ide. ");
INSERT INTO mkl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Iyi í ce bɛi ɑdɔ̃ minji ŋɔi Pɔsiu Fesitu í nɑ í sɑ̃si ɑɡbɛi Felisi. Wee Felisi í jɔ̀ Pɔlu ile piisɔ̃ɔ bɛi si nɑ iyi í jɔ̀ wɑ bi nŋu ku nɛ bɛɛrɛ bi Zuifu ŋɑu. ");
INSERT INTO mkl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Iyi Fesitu í to wɑ Sezɑree, si ɑjɔ mɛɛsiɑɛ í bɔ Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do Zuifu inɛ nɡbo ŋɑu ɑ̀ koo ɑ̀ mɑ́ Pɔlu ide bi Fesitu. ");
INSERT INTO mkl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Nɔ ɑ̀ wɑɑ tɔɔɛ suuru ntɔ ntɔ ku bɑ kú jɔ̀ Pɔlu ku nɑɑ Zeruzɑlɛmu. À wɑɑ bi Pɔlu ku nɑɑ Zeruzɑlɛmui si nɑ iyi í jɔ̀ ɑ̀ dĩ zɑmbɑ nŋɑ ɑŋɑ ɑ bɑ ɑ kpɑɑ kpɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ammɑ Fesitu í jɛ nŋɑ í ni Pɔlu í wɑ ile piisɔ̃ɔi Sezɑree nɔ nŋu tɑkɑi nŋu kɑɑ kpɛtɛ ku nyi bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nɑ nŋu, í ni ɑ jɔ̀ nŋu do inɛ nɡbo nŋɑ ŋɑ ɑ koo bɛ nɔ bii í jɛ í ce tɑɑle ɡɔi ɑ́ fɔ. ");
INSERT INTO mkl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesitu kù re ɑjɔ mɛɛjɔ wɑlɑ ɑjɔ mɛɛwɑ si inɔ nŋɑ nɔ í nyi Sezɑree mɑ́. Iju kumɑ́ɛ nɔ í bɔ ile bi ku ce kiiti nɔ í ni ɑ nɑɑò Pɔlu wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Iyi Pɔlu í to wɑ ŋɔi Zuifu ŋɑ iyi ɑ̀ nɑɑ hɑi Zeruzɑlɛmu ɑ̀ kɑɑkoɛ ɑ̀ wɑɑ mɑ́ɑ ide lɑɑlɔ kuɡɑɑbu nkpɔ nkpɔ nɔ nkɑ̃mɑ kù wɛɛ iyi wɑ nyisi iyi ide nŋɑu ntɔi. ");
INSERT INTO mkl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ŋɔi Pɔlu wɑ kɔò ɑrɑɛ í ni, n kù ce kurɑrɑ ɡɔ si woodɑi Zuifu ŋɑ hee mɑ́ jɛ si kpɑsɛ̃i Ilɑɑɔ̃ hee mɑ́ jɛ bi ilɑɑlu nlɑi Romu. ");
INSERT INTO mkl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ammɑ Fesitu wɑ bi nŋu ku nɛ bɛɛrɛ bi Zuifu ŋɑu. Nɑ ŋɔi í jɔ̀ í bee Pɔlu í ni, ì bi i bɔ Zeruzɑlɛmu ɑ ceeɛ kiiti si wɑjum nɑ irii ideu ihɛ̃? ");
INSERT INTO mkl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ŋɔi Pɔlu í ni, ɑɑwo. Bi ku kiitii ilɑɑlu nlɑi Romui ǹ wɑ ihɛ̃, ihɛ̃i ɑ́ sĩɑ ɑ kiitiim. N kù ceɑ Zuifu ŋɑ kurɑrɑ kɑ̃mɑ, nɔ ɑwɔ tɑkɑɛ ì wɑɑ nɛ kumɑ̀siɛ sɑ̃ɑ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Bii ǹ ce kurɑrɑ wɑlɑkɔ dɑɑ ɡɔ iyi í to ɑ kpɑm n kɑɑ n kɔ. Ammɑ ide ŋɑ iyi ɑ̀ wɑɑ yɛ tɑɑlem siu ihɛ̃, bii kù jɛ ntɔ inɛ ɡɔ kɑɑ yɔkɔ ku dɑsim ɑwɔ. Nɑ nŋu, ǹ so kiitim ǹ dɑɑ ilɑɑlu nlɑu tɑkɑɛ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Iyi Fesitu do inɛɛ ŋɑ ɑ̀ busi njɛ ɑ̀ tɑ̃, ŋɔi í sɔ̃ Pɔlu í ni, si bɛi ì so kiitiɛ ì dɑɑ ilɑɑlu nlɑu si ɑwɔ, bi tɛɛi ɑɑ bɔ. ");
INSERT INTO mkl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Iyi wɑɑti í lɔ keeke mɑ́, ŋɔi ɑmɑnlu Aɡiripɑ do wecĩɛ Berenisi ɑ̀ nɑɑ Sezɑree Fesitu ku ce fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Si bɛi ɑ̀ wɑɑ kpɛ bɛ ŋɔi Fesitu í sɔ̃ ɑmɑnluu idei Pɔluu í ni, inɛ ɡɔ í wɑ ihɛ̃, Felisi í jɔ̀ ɑ̀ dɑsiɛ piisɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Iyi ǹ bɔ Zeruzɑlɛmu ŋɔi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑu do inɛ nɡboi Zuifu ŋɑu ɑ̀ nɑɑò ideɛ wɑ bi tom. Nɔ ɑ̀ tɔɔm n yɛ tɑɑleɛ ku bɑ ɑŋɑ ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ammɑ ǹ jɛ nŋɑ ǹ ni inɛi Romu ŋɑ ɑ ci yɑ jɔ̀ ɑ kpɑ inɛ bii kù jɛ ɑ̀ kiitiɛ. À yɑ muɑɑ wɑɑtii nŋu do woo yɛ tɑɑleɛ ŋɑu ɑ fɔ ide titɑ̃ ɡɛlɛò ɡɛlɛ. ");
INSERT INTO mkl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ŋɔi ɑŋɑ fei ɑ̀ nɑɑ ilu ihɛ̃. Si bɛi n kù bi ku kpɛ mɑ́, ŋɔi iju kumɑ́ɛ ǹ kpe ŋɑ bi ku ce kiiti nɔ ǹ ni ɑ ɡbɑ̃ Pɔlu wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ŋɔi woo yɛ tɑɑleɛ ŋɑu ɑ̀ dede siɛ ɑmmɑ ɑ kù yɛ tɑɑleɛ si ide lɑɑlɔ ɡɔ bɛi ǹ wɑ n tɑmɑɑu. ");
INSERT INTO mkl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Idei kutɔɔi ɑŋɑ tɑkɑ nŋɑi ɑ̀ wɑɑ ce si kɑkɔɔ, do idei mɔkɔ ɡɔ iyi í ku ɑ̀ yɑ kpoo Jesu. Ammɑ Pɔlu í ni dim dim mɔkɔu í wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Amu ǹ biti bɛirei ɑn kiiti ideu ihɛ̃. Nɑ ŋɔi í jɔ̀ ǹ bee Pɔlu bii í bi n koo n ceɑɑ kiitii ideu Zeruzɑlɛmu. ");
INSERT INTO mkl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ammɑ í so kiitiɛu í nɑ ilɑɑlu nlɑu. Nɔ ǹ ni ɑ dɑsiɛ piisɔ̃ɔ mɑ́ titɑ̃ hee n mɑɑ n jɔ̀ ɑ kooòɛ bi tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ŋɔi Aɡiripɑ í sɔ̃ Fesitu í ni, ɑmu tɑkɑm ǹ bi n ɡbɔ ide hɑi si ɡɛlɛi mɔkɔu. Ŋɔi Fesitu í ni, ɑlɑ ɑɑ ɡbɔ. ");
INSERT INTO mkl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ŋɔi iju kumɑ́ɛ Aɡiripɑ do Berenisi ɑ̀ nɑɑ bi ku ce kiitiu do jirimɑ jiidɑ, ŋɔi inɛ nɡboi sooɡe ŋɑ do ilu bɛɛrɛi ilu ŋɑu ɑ̀ too ŋɑ wɑ. Ŋɔi Fesitu í ni ɑ nɑɑò Pɔlu wɑ, nɔ ɑ̀ nɑɑɛ wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Iyi Pɔlu í to wɑ ŋɔi Fesitu í ni, to, ɑwɔ ɑmɑnlu Aɡiripɑ do iŋɛ iyi ì wɑ ihɛ̃ fei ŋɑ, Pɔluu wee. Nɑ iriɛi Zuifu ŋɑu fei ɑ̀ nɑɑ bi tom wɑɑti iyi ǹ bɔ Zeruzɑlɛmu, nɔ ɑ̀ nyi wɑ bitom ihɛ̃ mɑ́, ɑ̀ wɑɑ lɑ ɑ̀ ni kù sĩɑ ɑ jɔ̀ɔ si hunde. ");
INSERT INTO mkl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Amu n kù yɛ siɛ tɑɑle kɑ̃mɑ iyi í to ɑ kpɑɑ. Ammɑ si bɛi nŋu tɑkɑɛ í so kiitiu í dɑɑ ilɑɑlu nlɑu si ɑwɔ ŋɔi í ce ǹ ni ɑn jɔ̀ ɑ kooɛ bi tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Do nŋu fei, n kù yɛ siɛ ide bɑɑ icu ɑkɑ̃ iyi ɑn ceɑò ilɑɑlu nlɑu tiɑ. Nɑ ŋɔi í jɔ̀ ǹ nɑɑɛ wɑ si wɑjui iŋɛ fei. Iyi í re mɔm ǹ nɑɑɛ wɑi si wɑjui ɑwɔ ɑmɑnlu Aɡiripɑ, i cɔ yɑɑsei ideu ku bɑ n bɑ iyi ɑn kɔ. ");
INSERT INTO mkl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kù nɛɛm yɑɑse n sɑmbɑɑ inɛi piisɔ̃ɔ ɡɔ nɔ n kù sisiɑɑ tɑɑle ɡɔ iyi í ce. ");
INSERT INTO mkl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ŋɔi Aɡiripɑ í sɔ̃ Pɔlu í ni, ì nɛ kpɑ̃ɑ i fɔ ide i kɔò ɑrɑɛ. Ŋɔi Pɔlu í wu ɑwɔ lele nɔ í lɔsi ku kɔò ɑrɑɛ í ni, ");
INSERT INTO mkl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ɑwɔ ɑmɑnlu Aɡiripɑ, inɔm í dɔ̃ do bɛi ɑn fɔ ide nnyi n kɔò ɑrɑm si wɑjuɛ si ide ŋɑ iyi Zuifu ŋɑu ɑ̀ wɑɑ mɑ́m nɔu fei. ");
INSERT INTO mkl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ǹ mɑ̀ iyi ì mɑ̀ dedembɑi Zuifu ŋɑ sɑ̃ɑ sɑ̃ɑ do idei kɑkɔɔ nŋɑ. Nɑ ŋɔi í jɔ̀ ǹ wɑ n tɔɔɛ i ɡbɔ idem do lɑɑkɑi. ");
INSERT INTO mkl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Zuifu ŋɑu fei ɑ̀ mɑ̀ kuwɛɛm hɑi wɑɑti iyi ǹ wɛɛ ɑwɑɑsũ. À mɑ̀ iyi Zeruzɑlɛmu bɛi ǹ jɛ ɑmɑ bi dimii inɛm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","À mɑ̀m hɑi ku kpɛ. Nɑ nŋu, bii ɑ̀ bi ɑɑ yɔkɔ ɑ jɛɛm sɛɛdɑ iyi si kpɑ̃ɑi Fɑrisi ŋɑi ǹ lɑ, ɑŋɑ iyi ɑ̀ re inɛ fei si kpɑ̃ɑi Ilɑɑɔ̃ ku tɔɔ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nɔ nsɛi ɑ̀ wɑɑ kiitiim si nɑ iyi í jɔ̀ ǹ wɑ n cɔ kpɑ̃ɑi kuwɑ̃ iyi Ilɑɑɔ̃ í ceɑ bɑlɑ nwɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kuwɑ̃ui dimi mɑɑteeji nwɑ ŋɑu mɔ fei ɑ̀ wɑɑ cɔ kpɑ̃ɑɛ. Nɑ ŋɔi í jɔ̀ ɑ̀ wɑɑ ceɑ Ilɑɑɔ̃ icɛ do himmɑ ɑlɛò dɑɑkɔ. Amɑnlu, kpɑ̃ɑu bɛ iyi ǹ wɑ n cɔ nŋui í jɔ̀ Zuifu ŋɑu ɑ̀ wɑɑ mɑ́m ide. ");
INSERT INTO mkl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Bɛirei í ce iŋɛ Zuifu ŋɑ i ci yɑ yɔkɔ i dɑsi nɑɑnɛ ŋɑ iyi Ilɑɑɔ̃ ɑ́ jĩ iku ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Amu tɑkɑm ǹ tɑmɑɑ í sĩɑi wo n dɛdɛ kpɑ̃ɑ bɑɑ yoomɑ fei bɛi ɑn ce n ɡɑnjiò idei Jesu inɛi Nɑzɑrɛtiu. ");
INSERT INTO mkl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Bɛɛbɛi ǹ ce Zeruzɑlɛmu. Inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ ɑ̀ nɑm ɡbuɡbɑ̃ n muò woo dɑsi Jesu nɑɑnɛ nkpɔ n dɑsi ŋɑ piisɔ̃ɔ. Bii ɑ̀ bi ɑ kpɑ inɛ ɡɔ mɔm ɑmu tɑkɑm ǹ yɑ n wɑ sii. ");
INSERT INTO mkl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Tuubɑ nkpɔ nkpɔ ǹ yɑ n mɑɑ n kpɑ̃ ŋɑ ijui ile bii Zuifu ŋɑ ɑ̀ yɑ ce kutɔtɔɔ nŋɑ ŋɑ fei ku bɑ n tilɑsi ŋɑ ɑ kɔsi idei Jesu. Ǹ yɑ n mɑɑ n mu ŋɑ do idɔɔkɔ̃ hee kɑɑ kɑɑ, ǹ yɑ n bɔ hee do si ilu mmu ŋɑ fei n koo n kpɑ̃ ŋɑ iju. ");
INSERT INTO mkl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ŋɔi Pɔlu í ni mɑ́, bɛɛbɛi inɛ nɡboi woo weei Ilɑɑɔ̃ ŋɑ ɑ̀ yɔɔdɑɑm n bɔ Dɑmɑsi do yiiko nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Amɑnlu, zɑkɑi dɑsɑ̃ si kpɑ̃ɑu ǹ yɛ inyɑ kumɑ́ í nɑɑ hɑi lele í bii wɑ, ɑmu do inɛ ŋɑ iyi ɑ̀ wɑɑ sim. Inyɑ kumɑ́u í re bɑɑ inyɑ kumɑ́i inunu. ");
INSERT INTO mkl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ŋɔi ɑwɑ fei ɑ̀ cuku ilɛ, nɔ ǹ ɡbɔ imu ɡɔ wɑ bɑm ide ku fɔ do feei Ebɛɛ wɑ ni, Sɔlu, Sɔlu, nɑ mii í ce ì yɑ mɑɑ kpɑ̃m iju. Á ɡɑɑbuɛ i kɔ sim bɛi í yɑ ɡɑɑbuɑ kɛtɛ kombo iyi wɑ jɑbu nɑ ɡoloi lɑfɛ̃ɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nɔ ǹ bee ǹ ni, ɑwɔi yoo Lɑfɛ̃ɛ. Nɔ í ni, ɑmui Jesu iyi ì yɑ mɑɑ kpɑ̃ ijuu. ");
INSERT INTO mkl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nsɛi, dede i leekĩ. Ǹ nɑɑ siɛi n cicɑɛ i jɛ woo ce icɛm, nɔ i jɛ sɛɛdɑi mii ŋɑ iyi ì yɛ tɑ̃ do iyi ɑɑ nyi i yɛ mɑ́ wɑɑti iyi ɑn nɑɑ siɛ. ");
INSERT INTO mkl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ǹ cicɑɛi hɑi si inɛi Izirɛli ŋɑ do hɑi bi dimi mmu ŋɑ nɔ ǹ wɑ n bɛɛ bi tu ŋɑ ");
INSERT INTO mkl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","i cĩ nŋɑ iju. Ǹ wɑ n bɛɛ bi tu ŋɑi ku bɑ ɑ sindɑ hɑi si ilu kuku ɑ lɔ si inyɑ kumɑ́, nɔ ɑ sindɑ hɑi si ɡbuɡbɑ̃i Seetɑm ɑ nɑɑ bi Ilɑɑɔ̃. An bɛɛ bi tu ŋɑi ku bɑ ɑ dɑsim nɑɑnɛ nɔ Ilɑɑɔ̃ ku kpɑ dulum du ŋɑ nɔ ɑ nɑ ɑ jɛ tubu do inɛ ŋɑ iyi í cicɑ ɑ̀ jɛ tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ŋɔi Pɔlu í ni mɑ́, ɑmɑnlu Aɡiripɑ, nɑ ŋɔi í ce ǹ wɑ n jirimɑ kuyɛ iyi í nɑɑ hɑi bi Ilɑɑɔ̃u. ");
INSERT INTO mkl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Sinte titɑ̃ ǹ ce wɑɑzo Dɑmɑsi, si ɑnyiɛ nɔ ǹ ce Zeruzɑlɛmu do si ilɛi Zudee fei do bi dimi mmu ŋɑ. Ǹ sɔ̃ ŋɑ ǹ ni ɑ kpɑɑsi idɔ ɑ sindɑ si Ilɑɑɔ̃, nɔ ɑ ce icɛ iyi ɑ́ jɔ̀ ɑ yɛ si ŋɑ iyi ɑ̀ kpɑɑsi idɔ. ");
INSERT INTO mkl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nɑ ŋɔi í ce Zuifu ŋɑu ɑ̀ mum hɑi kpɑsɛ̃i Ilɑɑɔ̃ ɑ̀ wɑɑ dɛ ku kpɑm. ");
INSERT INTO mkl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ammɑ Ilɑɑɔ̃i í nyɑm hee do nnyi fei nɔ ǹ wɑ ihɛ̃ ǹ wɑ n jɛ sɛɛdɑ si wɑjui ɑmɑnɛ ŋɑ hɑi keeke do nlɑ fei. N kù wɑ n fɔ ide ɡɔ bii kù jɛ iyi Moizi do wɑlii ŋɑ ɑ̀ ni ɑ́ nɑ ku ceu bɑɑsi. ");
INSERT INTO mkl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Mii iyi ɑ̀ ni ɑ́ nɑ ku ceu nŋui í jɛ Kirisi ɑ́ nɑ ku yɛ ijuukpɑ̃ nɔ kú jɛ inɛ sinte iyi ɑ́ jĩ hɑi si bɑlɛ nɔ ku sisi idei inyɑ kumɑ́ bi Zuifu ŋɑ do bi dimi mmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Si bɛi Pɔlu í sisi yɑɑsei ideɛ bɛɛbɛ ŋɔi Fesitu í lɑ hee lele í ni, Pɔlu, ì wɑɑ sũmui. Mɑ̀ cio nlɑ ku ceɛi í dɑsiɛ sũmu. ");
INSERT INTO mkl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ammɑ Pɔlu í ni, n kù jɛ sũmu Fesitu, ɑwɔ ilu bɛɛrɛu. Ide iyi ǹ wɑ n fɔu dei í jɛ ntɔ, nɔ wɑ too kpɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Amɑnlu Aɡiripɑ í nɔ í mɑ̀ yɑɑsei ideu. Ŋɔi í ce ǹ wɑ n fɔ ideu do lɑɑkɑi ku sũ si wɑjuɛ si nɑ iyi í jɔ̀ ǹ mɑ̀ kɑ̃mɑɛ kù mɑnjiɑ, domi ideu kù ce si ɑsii. ");
INSERT INTO mkl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Awɔ ɑmɑnlu Aɡiripɑ, ì dɑsi idei wɑlii ŋɑu nɑɑnɛ mbɛ? Ǹ mɑ̀ sɑ̃ɑ sɑ̃ɑ iyi ì dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ŋɔi Aɡiripɑ í sɔ̃ Pɔlu í ni, debɛi, si wɑɑti keekeu ihɛ̃ ì wɑɑ tɑmɑɑ ɑɑ cem inɛi Kirisi? ");
INSERT INTO mkl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ŋɔi Pɔlu í jɛɑɑ í ni, ǹ wɑ n tɔɔ Ilɑɑɔ̃ ku jɔ̀ i yɛ bɛi ɑmu, bii ɑ́ ce nsɛi, bii í nɔ í jɛ ɑ́ kpɛ mɔi. Ku mɑɑ̀ jɛ bɑɑ ɑwɔ ɑkɑ̃, ɑmmɑ hee do inɛ ŋɑ iyi ɑ̀ wɑɑ de itĩ si idem nnyiu ihɛ̃ fei. Ǹ bi iŋɛ mɔ i yɛ bɛi ɑmu ɑmmɑ ku mɑɑ̀ jɛ ɑ dɑ nŋɛ si kpɛnkpɛm bɛi ɑ̀ dɑɑm siu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Iyi Pɔlu í fɔ bɛɛbɛ í tɑ̃ ŋɔi ɑmɑnluu do ilu ilɛu do Berenisi do inɛ ŋɑ iyi ɑ̀ wɑ bi tu ŋɑu fei ɑ̀ dede ");
INSERT INTO mkl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ɑ̀ fitɑ hɑi inɔ ileu. Iyi ɑ̀ wɑɑ fitɑ ŋɔi ɑ̀ sɔ̃ njɛ ɑ̀ wɑɑ ni, inɛɛu bɛ kù ce dɑɑ kɑ̃mɑ iyi í to ɑ muu piisɔ̃ɔ hee mɑ́ jɛ ɑ kpɑɑ. ");
INSERT INTO mkl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ŋɔi Aɡiripɑ í sɔ̃ Fesitu í ni, bii mɔkɔu kù so kiitiu ku dɑɑ ilɑɑlu nlɑi Romu si ɑwɔ wo ɑɑ kɑ yɔkɔ kɑ jɔ̀ɔ. ");
INSERT INTO mkl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Wɑɑti iyi ɑ̀ dɑsi idɔ kɑ bɔ ilɛi Itɑli do ɑkɔi inyi ŋɔi ɑ̀ so Pɔlu do inɛi piisɔ̃ɔ ɡɔ ŋɑ ɑ̀ dɑɑ inɛ nɡboi sooɡe ɡɔ iyi ɑ̀ yɑ kpe Juliu si ɑwɔ. Nŋu mɔ wɑ jɛ inɛ nɡbo si inɔ wuɑi sooɡei Romu ŋɑ iyi ɑ̀ yɑ kpe ti ilɑɑlu Oɡusitu. ");
INSERT INTO mkl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","À lɔ ɑkɔi inyii Adɑmiti ɡɔ iyi wɑ bɔ ikpɑ ilɛi Azii, nɔ ɑ̀ nɛ. Nɔ inɛi Mɑsedɔni ɡɔ iyi í nɑɑ hɑi Tɛsɑlonikɑ í wɑ inɔ nwɑ ɑ̀ yɑ kpoo Aritɑɑki. ");
INSERT INTO mkl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Iju kumɑ́ɛ nɔ ɑ̀ to Sidɔ̃ɔ. Ŋɔi Zuliu í ceɑ Pɔlu jiidɑ í jɔ̀ í koo í yɛ kpɑɑsiɛ ŋɑ ku bɑ ɑ muɑɑ mii iyi í bi. ");
INSERT INTO mkl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Iyi ɑ̀ nɛ hɑi bɛ ŋɔi fufu nlɑ ɡɔ wɑ ko ŋɑ wɑ, nŋui í jɔ̀ ɑ̀ too do icei ɡunɡum ɡɔ iyi ɑ̀ yɑ kpe Sipu. ");
INSERT INTO mkl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ŋɔi ɑ̀ kuɑ inyi dũdũu ikpɑ ilɛi Silisi do Pɑnfili nɔ ɑ̀ to wɑ Mirɑ si ilɛi Lisi. ");
INSERT INTO mkl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ilu bɛi, inɛ nɡboi sooɡeu í yɛ ɑkɔi inyii Alesɑndiri ɡɔ iyi wɑ bɔ ikpɑ ilɛi Itɑli nɔ í dɑsi wɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Iyi ɑ̀ nɛ, ɑjɔ nkpɔ nkpɔ kpɛlɛ kpɛlɛi ɑ̀ ce ɑ̀ wɑɑ koo do wɑhɑlɑ nlɑ nlɑ nɔ ɑ̀ to kɔkɔi ilu ɡɔ iyi ɑ̀ yɑ kpe Sinidi. Si bɛi fufu nlɑu wɑ ɡɑnji wɑ wɑju ku bɔ, ɑ̀ yɑ̀ɑ ɑ̀ bɔ ikpɑ ɡunɡum ɡɔ iyi ɑ̀ yɑ kpe Kɛrɛti. Iyi ɑ̀ wɑɑ koo, ɑ̀ tooi do ikpɑ icei ɡunɡum nɔu kɔkɔi ilɛi Sɑmɔneei domi fufuu kù lɑ do ikpɑ bɛ. ");
INSERT INTO mkl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nɔ ɑ̀ lɔ bɛ do kookɑɑi nlɑ nlɑ nɔ ɑ̀ to bi ku leekĩi ɑkɔi inyi iyi ɑ̀ yɑ kpe Ku Sĩɑ kɔkɔi Lɑsee. ");
INSERT INTO mkl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Wɑɑti sisɔi ɑ̀ ce bɛ hee inɛ ŋɑ ɑ̀ dĩ ɑnu ɑ̀ tɑ̃, nɔ wɑju ku bɔ nwɑ í jɛ mbirisi nlɑ nlɑ domi wɑɑtiu í yɑ ɡɑɑbu do ɑkɔi inyi. Nɑ ŋɔi í jɔ̀ Pɔlu í sɔ̃ ŋɑ í ni, ");
INSERT INTO mkl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","iŋɛ kpɑɑsim ŋɑ, ǹ yɛ ilu ku bɔ nwɑu ɑ́ ɡɑɑbu, ɑ́ nɛ mbirisi do muse. Aso nwɑ ŋɑ do ɑkɔi inyiu tɑkɑɛ fei ɑ́ ce nfe, nɔ ɑwɑ tɑkɑ nwɑ kɑ ku. ");
INSERT INTO mkl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ammɑ inɛ nɡboi sooɡe ŋɑu wɑ ɡbɔ idei woo mu ɑkɔu do inɛ iyi í nɛ ɑkɔu tɑkɑɛ í re ti Pɔlu. ");
INSERT INTO mkl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Wee bi ku leekĩi ɑkɔi inyi ŋɑu kù sĩɑ ɑ leekĩ bɛ sukui kpɑɑ. Ŋɔi í jɔ̀ inɛ nkpɔ nŋɑ í dɑsi idɔ í ni kɑ mɔsi wɑju kɑ to Fenisi tenɡi bii bi ku leekĩi ɑkɔi inyii ɡunɡum ndii Kɛrɛtiu í wɑ. Bi ku leekĩi ɑkɔi inyiu do ikpɑ nunui ɑlɛ cinɡɑɑ do cinɡɑɑi wɑ cɔ. Bɛi ɑ̀ bi ɑ wɑ sukui fufuu. ");
INSERT INTO mkl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ŋɔi fufu fɛrɛfɛrɛ ɡɔ í dede hɑi ikpɑ ɑwɔ cɑnɡɑi kpɑ̃ɑi inunu ŋɔi inɛ ŋɑu ɑ̀ tɑmɑɑ bɛi isɛɛnɛi ɑŋɑu ɑ́ cei si bɛi ɑŋɑ ɑ̀ bi. Ŋɔi ɑ̀ fɑ mii ku leekĩ ɑkɔu wɑ hɑi inɔ inyi ɑ̀ bɔ wɑju nɔ ɑ̀ wɑɑ too kɔkɔi ɡunɡum ndii Kɛrɛti. ");
INSERT INTO mkl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ammɑ iyi í ce sɑ̃ɑ fufu nlɑ ɡɔ iyi ɑ̀ yɑ kpe Erɑkilɔ̃ɔ í dede do ɡbuɡbɑ̃ hɑi ɡeetei ɡunɡum nɔu wɑ. ");
INSERT INTO mkl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ŋɔi í tɑle ɑkɔu wɑ hee ɑ̀ mɔnɡɔ ku jɔ̀ ɑkɔu ku nɛ dee dee nɔ ɑ̀ jɔ̀ɔɛ í nɛò wɑ bii í bi. ");
INSERT INTO mkl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nɔ ɑ̀ koo ɑ̀ lɔ kɔkɔi ɡunɡum keeke ɡɔ bɛ iyi ɑ̀ yɑ kpe Kodɑ. Gunɡum nɔui í jɔ̀ fufuu í tiɑ. Do nŋu fei kɑ bɛi kɑ so ɑkɔi inyi keeke iyi í jɛ ti fɑɑbɑu kɑ dɑsi inɔ ɑkɔi inyi nlɑu ɑ̀ wɑhɑlɑ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Iyi ɑ̀ dɑsi ɑ̀ tɑ̃ ŋɔi woo ce icɛ si inɔi ɑkɔi inyi ŋɑu ɑ̀ dĩ ɑkɔi inyiu do ikũ ŋɑ. Nɔ ɑ̀ fũ ikũi ɑcɔɛ, nɔ ɑ̀ jɔ̀ fufuu í bɔò ŋɑ bii í bi si nɑ iyi í jɔ̀ ɑ̀ wɑɑ ce njo ɑ mɑɑ nɑ ɑ dɑsi sɑ̃ɑi Libi. ");
INSERT INTO mkl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Iju kumɑ́ɛ si bɛi fufuu wɑ cɑ̃ wɑ do ɡbuɡbɑ̃ ŋɔi ɑ̀ lɔsi ɑsoi ɑkɔi inyiu ku wɑ̀ ku dɑsi inɔ inyi. ");
INSERT INTO mkl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Iju kumɑ́ɛ mɑ́ ɑ̀ wɑsi nyɑui ɑkɔi inyiu tɑkɑɛ ku wɑ̀ ku sɔsi inɔ inyiu do ɑwɔi ɑwɑ tɑkɑ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ajɔ nkpɔ nkpɔi ɑ̀ ce inunu kù fitɑ hee mɑ́ jɛ ɑndɑiyɑ ŋɑ nɔ fufu nlɑ ɡɔ wɑ ce, ɑ kù tɑmɑɑ mɑ ɑɑ kɑ fitɑ si. ");
INSERT INTO mkl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Hɑi kukpɛ ɑ kù jɛ. Ŋɔi Pɔlu í dede í leekĩ si ɑnini nŋɑ í ni, iŋɛ fei, bii ì jɛ idem ŋɑ wo ɑ kɑɑ kɑ nɛ hɑi Kɛrɛti nɔ ɑ kɑɑ kɑ yɛ mbirisi do museu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ammɑ nsɛi ǹ wɑ n tɔɔ ŋɛ, i jɔ̀ lɑɑkɑi nŋɛ ku sũ domi kɑ̃mɑ nŋɛ ɡɔ kɑɑ ce nfe bii kù jɛ ɑkɔi inyiu nŋu ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ǹ mɑ̀ bɛɛbɛi si nɑ iyi í jɔ̀ Ilɑɑɔ̃, nŋu iyi ǹ jɛ tɛɛ, ǹ wɑ n ceɑɑ icɛu, ɑmɑlekɑɛ í nɑɑ sim idũ ɑnɑ ");
INSERT INTO mkl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","í ni, Pɔlu, mɑɑ̀ ce njo. Kù nɛ bɛi ɑɑ ce iyi i kù leekĩ si wɑjui ilɑɑlu nlɑi Romu. Nɔ wee, inɛ ŋɑ iyi iŋɛò ŋɑ ì wɑ inɔ ɑkɔu fei, Ilɑɑɔ̃ í yɔɔdɑ nŋɑi ɑ bɑɛ ku wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nɑ nŋu, iŋɛ fei, i fũ ɑrɑ nŋɛ, domi ǹ wɑ n nɑɑnɛ idei Ilɑɑɔ̃u. Bɛi í sɔ̃m nɔu ɑ́ cei. ");
INSERT INTO mkl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ammɑ ɑkɔi inyiu ɑ́ cuku kɔkɔi ɡunɡum ɡɔ ku lɛɡɛ. ");
INSERT INTO mkl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Si idũi ɑjɔ mɑɑtɛ̃ɛsiɑɛ ŋɔi fufu nlɑ ɡɔ wɑ tɑle wɑ si ɑntɑi tenku bii ɑ̀ wɑ iyi ɑ̀ yɑ kpe Mediterɑneu. Ŋɔi zɑkɑi idũ lɑjɑu woo ce icɛi ɑkɔi inyi ŋɑu ɑ̀ tɑmɑɑ bɛi ɑ̀ mɑɑi ilɛi. ");
INSERT INTO mkl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ŋɔi ɑ̀ dɑsi mii ɡɔ inɔ inyi ɑ̀ wɑ̃ kujĩi isɑɛ nɔ ɑ̀ bɑ í to mɛɛtu kuntɑɑ do mɛɛje. Iyi í kɔ̃ɔsi keeke nɔ ɑ̀ sɔsi mɑ́ nɔ ɑ̀ bɑ í ce mɛɛtu kɔnfiɑ do mɛɛjɔ. ");
INSERT INTO mkl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","À wɑɑ ce njo ɑ mɑɑ nɑ ɑ ɡɑmɔ do kutɑ ŋɑ, nɑ ŋɔi í ce ɑ̀ sɔsi mii ku leekĩ ɑkɔi inyi ɑrɑ mɛɛ do ɑnyii ɑkɔu ku bɑ ku leekĩɛ nɔ ɑ̀ wɑɑ deɡbe iju ku mɑ́ ńyɑ. ");
INSERT INTO mkl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ŋɔi woo ce icɛi ɑkɔ ŋɑu ɡɔɡɔ ŋɑ ɑ̀ wɑɑ dɛ bɛi ɑɑ ce ɑ sɑ do ile. Nɑ ŋɔi í jɔ̀ ɑ̀ kitɑ ɑkɔi inyi keeke iyi í jɛ ti fɑɑbɑu si inyiu ku bɑ inɛ ŋɑ ɑ tɑmɑɑ bɛi ɑ̀ wɑɑ bɔ ku dĩ mii ku leekĩ ɑkɔu si wɑjuɛi. ");
INSERT INTO mkl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ammɑ Pɔlu í sɔ̃ sooɡe ŋɑu do inɛ nɡbo nŋɑ í ni, bii inɛ ŋɑu ihɛ̃ ɑ kù bubɑ sɛ̃ɛ iŋɛ tɑkɑ nŋɛ i kɑɑ bɑ fɑɑbɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ŋɔi sooɡe ŋɑu ɑ̀ bu ikũi ɑkɔ keekeu nɔ ɑ̀ jɔ̀ í mile si inyiu. ");
INSERT INTO mkl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Si bɛi ɑ̀ wɑɑ deɡbe iju kumɑ́u ŋɔi Pɔlu í tɔɔ ɑŋɑ fei ɑ jɛ. Í ni, ɑjɔ mɑɑtɛ̃ɛ wɑi ihɛ̃ ì wɑɑ dɛ kpɑ̃ɑi fɑɑbɑ ŋɑ i kù nɔ i kù jɛ nɡɔɡɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ǹ wɑ n tɔɔ ŋɛ i jɛ nɑ fɑɑbɑ nŋɛ. Ntɔ ntɔ ǹ wɑ n sɔ̃ ŋɛi, bɑɑ ntoi irii inɛ ɑkɑ̃ nŋɛ kɑɑ dɑ ku nyɔ. ");
INSERT INTO mkl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Iyi Pɔlu í fɔ bɛɛbɛ í tɑ̃ ŋɔi í so pɛ̃ɛ í sɑɑbu Ilɑɑɔ̃ si wɑjui ɑŋɑ fei nɔ í bububuɛ í lɔsi ku jɛ. ");
INSERT INTO mkl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ŋɔi ɑŋɑ fei ɑ̀ fũ ɑrɑ nŋɑ ɑ̀ wɑsi ku jɛ. ");
INSERT INTO mkl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Awɑ iyi ɑ̀ wɑ si inɔi ɑkɔi inyiu ɑ̀ wɛɛi ɑmɑnɛ cĩɔ minji do kitɑò fɛɛwɑ do mɛɛfɑ. ");
INSERT INTO mkl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Iyi ɑŋɑ fei ɑ̀ jɛ ɑ̀ yo ŋɔi ɑ̀ wɑ iyɑfũ nŋɑu ɑ̀ sɔsi inɔ inyiu ku bɑ ɑkɔu ku fɛrɛ. ");
INSERT INTO mkl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Iyi iju í mɑ́ ŋɔi ɑ̀ nyɔ. Woo ce icɛ si ɑkɔi inyi ŋɑu ɑ kù mɑ̀ inyɑu, ɑmmɑ ɑ̀ yɛ wɑɑwɑɑ ɡɔ í nɛ sɑ̃ɑ, nɔ ɑ̀ dɑsi idɔ ɑ bɔò ɑkɔu bɛ bii ɑɑ yɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ŋɔi ɑ̀ bu ikũ ku leekĩ ɑkɔu ɑ̀ jɔ̀ í mile. Si wɑɑti ɑkɑ̃u nɔ inɛ ɡɔ ŋɑ ɑ̀ fũ ikũ iyi ɑ̀ yɑ dĩò fɑlɑfili ŋɑu. Nɔ ɑ̀ dede ɑcɔu lele ikpɑ wɑjui ɑkɔu ku bɑ fufu ku tɑleɛ ikpɑ wɑɑwɑɑu. ");
INSERT INTO mkl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ammɑ ɑ̀ kɑ̃si ɡeetei sɑ̃ɑ ɡɔ do ɡbuɡbɑ̃ nɔ ɑ̀ mɔnɡɔ ku lɔ. Nɔ wɑjui ɑkɔu í ɡũ ilɛ si sɑ̃ɑ ɑ̀ mɔnɡɔ ku wuɛ, nɔ kucɑ̃i inyi nlɑu í tɑle fitii ɑkɔi inyiu do ɡbuɡbɑ̃ í lɛɡɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ŋɔi sooɡe ŋɑu ɑ̀ dɑsi idɔ ɑŋɑ ɑ kpɑ inɛi piisɔ̃ɔ ŋɑu fei ku bɑ ɑ mɑɑ̀ nɑ ɑ wɑ̀ ɑ sɑ. ");
INSERT INTO mkl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ammɑ inɛ nɡboi sooɡe ŋɑu í bi ku fɑɑbɑ Pɔlu. Nɑ ŋɔi í ce í ɡɑnji ŋɑ. Í ni inɛ ŋɑ iyi ɑ̀ mɑ̀ ɑ̀wɑ̀ ɑ cuɑ ɑ kuɑ ice. ");
INSERT INTO mkl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Nɔ inɛ ŋɑ iyi ɑ̀ ɡbe ɑ ɡũ kpɑtɑkui ɑkɔu wɑlɑkɔ kpɑlɔɛ ŋɑu ɑ kuɑò ice. Bɛɛbɛi inɛ ŋɑu fei ɑ̀ kuɑò ice bɑɑni. ");
INSERT INTO mkl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Iyi ɑwɑ fei ɑ̀ to ɡunɡum bɛ bɑɑni ɑ̀ mɑ̀ iyi inyɑu Mɑlitui ɑ̀ yɑ kpoo. ");
INSERT INTO mkl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Inɛi Mɑlitu ŋɑu ɑ̀ mu wɑ do kubi jiidɑ. À ko nwɑ inɑ nlɑ nlɑ ɑwɑ fei ɑ̀ nɑɑ ɑ̀ nyiɑ si nɑ iyi í jɔ̀ ijĩ wɑ rɔ nɔ tũtũ wɑ ce. ");
INSERT INTO mkl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ŋɔi Pɔlu í so jĩi kɑmbo í dɑsi inɑ. Asee njo wukuku ɡɔ í wɑ si bɛ. Iyi í ɡbɔ inyɑ ɡbɑ̃ɑ ŋɔi í fitɑ í wenwee si ɑwɔɛ. ");
INSERT INTO mkl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Iyi inɛi ilu ŋɑu ɑ̀ yɛ njou si ɑwɔi Pɔlu ŋɔi ɑ̀ sɔ̃ njɛ ɑ̀ wɑɑ ni, kɑm kɑm mɔkɔu ihɛ̃ woo kpɑ inɛi. Bɑɑ do iyi í fitɑ hɑi si wɑhɑlɑi inyiu ihɛ̃ fei, iwɛ̃ ŋɑ ɑɑ kiitiɛ nɔ ɑ kɑɑ jɔ̀ ku wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ammɑ Pɔlu í ɡbuɡbɑ̃ njou si inɑ kù nɔ kù ɡbɔ ɑrɑ kuro kɑ̃mɑ. ");
INSERT INTO mkl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ŋɔi inɛ ŋɑu ɑ̀ wɑɑ cɔɔ mɑ̀ ɑrɑɛ ɑ́ nɑ ku wu wɑlɑkɔ mɑ̀ ɑ́ nɑ ku ku. Ammɑ ɑ̀ kpɛ bɛ nɔ nkɑ̃mɑ kù ce nɔ ɑ̀ kpɑɑsi ide ɑ̀ ni inɛɛu ihɛ̃ iwɛ̃ nlɑ nlɑ ɡɔi. ");
INSERT INTO mkl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Wee kɔkɔi inyɑu kpɑsɛ̃i mɔkɔ ɡɔ í wɑ bɛ, mɔkɔui í jɛ ilɑɑlui ɡunɡum nɔu, ɑ̀ yɑ kpoo Pubilusi. Í ɡbɑ wɑi jiidɑ jiidɑ ɑ̀ ce ɑjɔ mɛɛtɑ si kpɑsɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Wee bɑɑɛ kù wɑɑ nɛ bɑɑni, wɑ ce ɑrɑ ɡbɑ̃ɑ do bɑmbɑnnu. Ŋɔi Pɔlu í bɔ ile bii wɑ sũu í koo í ceɑɑ kutɔɔ í le siɛ ɑwɔ nɔ í bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Si ɑnyii nŋu, ɑ̀ nɑɑò bɔ̃ɔ mmu ɡɔ ŋɑ wɑ mɑ́ nɔ ɑ̀ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ŋɔi inɛ ŋɑu ɑ̀ jirimɑ wɑ ntɔ ntɔ. Iyi ɑwɑɑti í to ɑ̀ wɑɑ bi kɑ nɛ ŋɔi ɑndi bukɑɑtɑi mii iyi ɑ̀ bi fei inɛ ŋɑu ɑ̀ mu nwɑ. ");
INSERT INTO mkl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Cukpɑ mɛɛtɑi ɑ̀ ce bɛ ɑ̀ bɛi ɑ̀ lɔ ɑkɔi inyii Alesɑndiri ɡɔ ɑ̀ nɛ. Nŋu mɔ ɡunɡum bɛi í leekĩ sukui kpɑɑu. Akɔu í nɛ nyindɑi iwɛ̃ Sikɑ ŋɑ . ");
INSERT INTO mkl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nɔ ɑ̀ to ilu ɡɔ iyi ɑ̀ yɑ kpe Sirɑkusi nɔ ɑ̀ sũ bɛ idũ mɛɛtɑ. ");
INSERT INTO mkl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Si ɑnyiɛ ŋɔi ɑ̀ dede hɑi bɛ mɑ́ ɑ̀ bɔ Rezio. Iju kumɑ́ɛ nɔ fufu ɡɔ í dede wɑ hɑi ikpɑ ɑwɔ cɑnɡɑi kpɑ̃ɑi inunu wɑ tɑle wɑ í jɔ̀ ɑ̀ to Puzɔli si ɑjɔ minjisiɑɛ. ");
INSERT INTO mkl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ŋɔi ɑ̀ yɛ kpɑɑsi woo dɑsi Jesu nɑɑnɛ ɡɔ ŋɑ bɛ nɔ ɑ̀ ni kɑ ce ɑzumɑ ɑkɑ̃ bi ti ɑŋɑ. Bɛɛbɛi isɛɛnɛ nwɑu í ce ɑ̀ bɛi ɑ̀ toò Romu. ");
INSERT INTO mkl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ŋɔi kpɑɑsi woo dɑsi Jesu nɑɑnɛ ŋɑ iyi ɑ̀ wɑ Romuu ɑ̀ ɡbɔ bɑɑu nwɑ nɔ ɑ̀ nɑɑ kuko nwɑ hee kɔkɔi ɑjɑi Apiusi. Nɔ inɛ ɡɔ ŋɑ mɔ ɑ̀ kò wɑ bi ku sɔi inɛ njoo ŋɑ iyi ɑ̀ yɑ kpe Ile Mɛɛtɑ. Iyi Pɔlu í yɛ ŋɑ ŋɔi lɑɑkɑɛ í sũ í wɑsi Ilɑɑɔ̃ ku sɑɑbu. ");
INSERT INTO mkl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Iyi ɑ̀ to Romu ŋɔi ɑ̀ jɔ̀ Pɔlu í nɛ ileɛ ikɑ̃. Nɔ sooɡe ɡɔ í yɑ mɑɑ deɡbeɛ. ");
INSERT INTO mkl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Iyi í ce zɑkɑi ɑjɔ mɛɛtɑ ŋɔi Pɔlu í kpe inɛ nɡboi Zuifui Romu ŋɑu. Iyi ɑ̀ tɔtɔɔ ɑ̀ tɑ̃ ŋɔi í ni, iŋɛ kpɑɑsim ŋɑ, Zuifu ŋɑ iyi ɑ̀ wɑ Zeruzɑlɛmu ɑ̀ mum ɑ̀ koo ɑ̀ nɑ inɛi Romu ŋɑ n kù bɛi n kù rɑrɑɑ zɑmɑɑu si nkɑ̃mɑ, n kù nɔ n kù kɔsi dedembɑi bɑlɑ nwɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Inɛi Romu ŋɑu ɑ̀ cɔ yɑɑsei ideu nɔ ɑ̀ bi ɑ jɔ̀m domi ɑ kù yɛ sim kurɑrɑ kɑ̃mɑ iyi í to ɑ kpɑm. ");
INSERT INTO mkl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ammɑ Zuifu ŋɑu ɑ kù jɛ ideu ŋɔi í ce ǹ so kiitiu ǹ dɑɑ ilɑɑlu nlɑi Romu si ɑwɔ, bɑɑ do iyi n kù bi n yɛ tɑɑlei inɛi dimim ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nɑ ŋɔi í jɔ̀ ǹ tɔtɔɔ ŋɛ n sɔ̃ ŋɛ do yɑɑseɛ. Inɛ ŋɑ ɑ̀ dɑɑm si kpɛnkpɛm nii nɑ inɛ iyi inɛi Izirɛli ŋɑ ɑ̀ wɑɑ cɔ kpɑ̃ɑɛu. ");
INSERT INTO mkl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ŋɔi ɑ̀ sɔ̃ɔ ɑ̀ ni, ɑ kù yɛ tiɑ kɑ̃mɑ iyi ɑ̀ ce wɑ hɑi ilɛi Zudee nɑ irii ideɛ, ɑ kù nɔ ɑ kù yɛ inɛ kɑ̃mɑ iyi í nɑɑò ide lɑɑlɔ wɑ hɑi bɛ nɑ iriɛ. ");
INSERT INTO mkl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ammɑ ɑwɑ tɑkɑ nwɑ ɑ̀ bi kɑ ɡbɔ iyi í wɑ idɔɛ, domi ɑ̀ mɑ̀ bii feii ɑ̀ yɑ mɑɑ fɔ lɑɑlɔi kpɑ̃ɑ iyi ì wɑɑ toou. ");
INSERT INTO mkl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nɔ ɑ̀ jilɛ ɑjɔ iyi ɑɑ nyi wɑ bi tɛɛ mɑ́. Iyi ɑjɔu í to inɛ nkpɔi í nɑɑ ile bii í wɑu. Ŋɔi í kɔ nŋɑ si cio hɑi dɑɑkɔ hee ɑlɛ í koo í lɛò. Wɑ sisi nŋɑ yɑɑsei bommɑi Ilɑɑɔ̃ nɔ wɑ kɔ nŋɑ si idei Jesu hɑi si woodɑi Moizi do si tiɑi wɑlii ŋɑu ku bɑ ɑ jɛsi. ");
INSERT INTO mkl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ŋɔi inɛ ɡɔ ŋɑ ɑ̀ jɛ ideu, ɑmmɑ inɛ ɡɔ ŋɑ ɑ kù jɛsi. ");
INSERT INTO mkl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Si bɛi ɑ kù ɡbɔsi njɛ, ŋɔi ɑ̀ fitɑ hɑi bi Pɔlu. Wɑɑti iyi ɑ̀ wɑɑ bi ɑ nɛ ŋɔi Pɔlu í fɔ ide ɡɔ í ni, hɑi tɑko Hundei Ilɑɑɔ̃ í nɛ ntɔ wɑɑti iyi í jɔ̀ wɑlii Ezɑi í sɔ̃ bɑlɑ nŋɛ ŋɑ ide ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Í ni, Bɔ bi inɛ ŋɑu bɛ i sɔ̃ ŋɑ i ni, Aɑ yɑ de itĩ do lɑɑkɑi ŋɑ ɑmmɑ i kɑɑ ɡbɔ yɑɑsei ide kɑ̃mɑ ŋɑ. Aɑ yɑ cɔ ilu ŋɑ jiidɑ jiidɑ ɑmmɑ i kɑɑ yɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ntɔ ntɔ, idɔi inɛ ŋɑu kù nɛ biti. À dĩ itĩ nŋɑ Ku bɑ ɑ mɑɑ̀ ɡbɔ ide. Nɔ ɑ̀ bii iju nŋɑ Ku bɑ ɑ mɑɑ̀ yɛ ilu. Bɛɛbɛi ɑ̀ ce ku bɑ idɔ nŋɑ ku mɑɑ̀ mɑ̀ nɡɔɡɔ Nɔ ɑ mɑɑ̀ nɑ ɑ sindɑ wɑ bi tom n jɔ̀ ɑ bɑ iri. ");
INSERT INTO mkl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ŋɔi Pɔlu í sɔ̃ ŋɑ mɑ́ í ni, nɑ nŋu, i mɑ̀ ŋɑ iyi Ilɑɑɔ̃ í jɔ̀ idei fɑɑbɑɛ í bɔ bi dimi mmu ŋɑ. Aŋɑi ɑɑ ɡbɔɔ.  ");
INSERT INTO mkl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Iyi Pɔlu í fɔ ideu bɛɛbɛ í tɑ̃ ŋɔi Zuifu ŋɑu ɑ̀ dede ɑ̀ wɑɑ ce kɑkɔɔ ntɔ ntɔ ɑ̀ wɑɑ nɛò. ");
INSERT INTO mkl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Adɔ̃ minjii Pɔlu í ce si ile iyi í hɑyɑu. Nɔ inɛ ŋɑ iyi ɑ̀ bɔ ku cɔɔ fei í bɑ ŋɑ fɑɑji ku ce do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Wɑ wɑɑzo idei bommɑi Ilɑɑɔ̃ nɔ wɑ kɔ nŋɑ si idei Lɑfɛ̃ɛ Jesu Kirisi do wɔɔkɔ nɔ inɛ kɑ̃mɑ kù ɡɑnjiɛ.");
INSERT INTO mkl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Amui Pɔlu woo ce icɛi Jesu Kirisi, ɑmu iyi Ilɑɑɔ̃ í kpe n nɑ n jɛ woo bɛ nɔ í nyɑm ikɑ̃ n wɑɑzoò lɑɑbɑɑu jiidɑɛ. ");
INSERT INTO mkl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Lɑɑbɑɑu jiidɑui Ilɑɑɔ̃ í wɑ̃ò wɑ wo. Nɔ kuwɑ̃ iyi í ceui í jɔ̀ wɑliiɛ ŋɑ ɑ̀ kɔ si kukɔi ideɛ. ");
INSERT INTO mkl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Jesu Kirisi Lɑfɛ̃ɛ nwɑi wɑ fɑ̃ɑ, nŋu iyi í jɛ Amɑi Ilɑɑɔ̃u. À búui bɛi ɑmɑnɛ si dimii Dɑvidi ɑmɑnlu nlɑu, ");
INSERT INTO mkl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ɑmmɑ Hundei Ilɑɑɔ̃ í nyisi do ɡbuɡbɑ̃ iyi ntɔi Amɑi Ilɑɑɔ̃i si wɑɑti iyi í dedeɛ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jesuu nŋui í muum didɔ̃ ǹ jɛò woo bɛ ku bɑ n nɑɑò inɛ ŋɑ wɑ hɑi si dimi fei bi tɛɛ nɑ iriɛ ku bɑ ɑ dɑsiɛ nɑɑnɛ nɔ ɑ jirimɑɛ. ");
INSERT INTO mkl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","7","Iŋɛ inɛi Romu ŋɑu, ì wɑ si inɔ nŋɑ ŋɑ, iŋɛ iyi Jesu Kirisi í kpe. Nɑ ŋɔi í jɔ̀ ǹ wɑ n kɔɑ iŋɛ fei tiɑu ihɛ̃ wɑ, iŋɛ iyi Ilɑɑɔ̃ í nɛ kubi nŋɛ nɔ í kpe ŋɛ i nɑ i jɛ titi nŋu ŋɑ. Ilɑɑɔ̃ Bɑɑ nwɑ do Lɑfɛ̃ɛ Jesu Kirisi ɑ mu nŋɛ didɔ̃ do lɑɑkɑi ku sũ. ");
INSERT INTO mkl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Sinte titɑ̃ ǹ wɑ n sɑɑbu Aɔ̃ Lɑfɛ̃ɛm do sɑɑbui Jesu Kirisi nɑ irii iŋɛ fei, si nɑ iyi í jɔ̀ ɑ̀ wɑɑ fɔ idei nɑɑnɛ ku dɑsi nŋɛ si ɑndunyɑ fei. ");
INSERT INTO mkl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ilɑɑɔ̃, nŋu iyi ǹ wɑ n ceɑ icɛ do idɔm fei ǹ wɑ n sisiò lɑɑbɑɑu jiidɑi Amɑɛ, í mɑ̀ iyi ǹ wɑ n ye ɡiɡi nŋɛ wɑɑti kɑ̃mɑ fei ");
INSERT INTO mkl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","si kutɔɔm. Ǹ yɑ n mɑɑ n tɔɔ Ilɑɑɔ̃ bii í bi ku muum kpɑ̃ɑ bɛbɛi n nɑɑ bi tu ŋɛ, ");
INSERT INTO mkl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","12","domi ǹ dɑsi idɔ jiidɑ jiidɑ n nɑɑ n yɛ ŋɛ ku bɑ i bɑ ɡbuɡbɑ̃ ŋɑ do sɑɑbum, wɑɑtɔ kɑ bɑ ɡbuɡbɑ̃ ɑjɔ si nɑɑnɛ ku dɑsi nwɑ ɑwɑɛ ŋɑ wɑɑti iyi ɑn nɑɑ n wɑ bi tu ŋɛ. Gbuɡbɑ̃u ɑmuɑi Hundei Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Iŋɛ inɛm ŋɑ, ǹ bi i mɑ̀ ŋɑ iyi tuubɑ nkpɔ nkpɔi ǹ yɑ n ce sɔɔlui ku nɑɑ bi tu ŋɛ, ɑmmɑ hee nsɛi n kù bɑ fɑyɑɛ. Ǹ bi icɛm ku nɛ iso si ɑnini nŋɛ, bɛi í nɛ bi dimi mmu ɡɔ ŋɑ mɔ. ");
INSERT INTO mkl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ǹ wɑ n mu ɡbesei n wɑɑzoɑ inɛ fei hɑi inɛ ŋɑ iyi ɑ̀ fũ iju hee do ilu iju dũdũ ŋɑ, bi inɛ ŋɑ iyi ɑ̀ nɛ kumɑ̀ hee do inɛ ŋɑ iyi ɑ kù nɛ kumɑ̀. ");
INSERT INTO mkl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ŋɔi í jɔ̀ ǹ wɑ n bi n sisiɑ iŋɛ inɛi Romu ŋɑu mɔ lɑɑbɑɑu jiidɑu ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","N kɑɑ n ce ɑnyɔi lɑɑbɑɑu jiidɑu, domi í jɛ ɡbuɡbɑ̃i Ilɑɑɔ̃i iyi wɑ fɑɑbɑ inɛ iyi í dɑsi Jesu nɑɑnɛ fei, hɑi Zuifu ŋɑ hee ku koo si dimi mmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Lɑɑbɑɑu jiidɑu wɑ nyisi iyi Ilɑɑɔ̃ í yɑ jɔ̀ inɛ ku jɛ dee dee nɑ nɑɑnɛ ku dɑsi nŋu ɑkɑ̃, si bɛi ɑ̀ kɔɔ ɑ̀ ni, inɛ iyi í jɛ dee dee si wɑjui Ilɑɑɔ̃ nɑ nɑɑnɛ ku dɑsiu ɑ́ bɑ kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Do ntɔi, Ilɑɑɔ̃ wɑ nyisi idɔɔkɔ̃ɛ wɑ hɑi lele si ɡɑ̃mɛi inɛ ŋɑ iyi ɑ̀ wɑɑ ce lɑɑlɔ fei nɔ ɑ kù mɑ̀ bɛɛrɛɛ. Si lɑɑlɔ ku ce nŋɑu ɑ kù jɔ̀ ntɔ kù wɑɑ ce icɛ. ");
INSERT INTO mkl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ilɑɑɔ̃ wɑ ce idɔɔkɔ̃ domi mii iyi í jɔ ɑmɑnɛ kú mɑ̀ siɛ kù mɑnji nŋɑ. Ilɑɑɔ̃ tɑkɑɛ í nyisi ŋɑ mɑm mɑm. ");
INSERT INTO mkl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Do ntɔ, ɑ kɑɑ yɔkɔ ɑ yɔɔ do iju, ɑmmɑ hɑi wɑɑti iyi í tɑkɑ ɑndunyɑ í nyisi ɑrɑɛ iyi nŋui í jɛ Ilɑɑɔ̃, nɔ í nyisi ɡbuɡbɑ̃ hɑi nɛ kɔɔɛ si mii ŋɑ iyi í tɑkɑ. Nɑ nŋu, ɑ kù nɛ iyi ɑɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","À mɑ̀ Ilɑɑɔ̃ ɑmmɑ ɑ kù wɑɑ sɑɑluɛ hee ɑ bɛi ɑ sɑɑbuɛ si bɛi í jɔ. Iri nŋɑ í nɑ í ku, nɔ idɔ hɑi nɛ bisi nŋɑ í dɑ́si ilu kuku nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","À wɑɑ tɑmɑɑ ɑŋɑ ɑ̀ nɛ bisi ɑmmɑ nnyɛi ɑ̀ nɑ ɑ̀ ce. ");
INSERT INTO mkl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Í sĩɑi wo ɑ tɔɔ Ilɑɑɔ̃ ilu ɑmboe, nŋu iyi kɑɑ ku ɑjɔ kɑ̃mɑ. Ammɑ wee ɑ̀ sindɑ ɑ̀ wɑɑ tɔɔ iwɛ̃ ŋɑ iyi ɑ̀ jɔ ɑmɑnɛ iyi ɑ́ ku. Iwɛ̃ ɡɔ ŋɑ mɔ ɑ̀ jɔ yɛi ŋɑ, do iŋɑ ŋɑ iyi ɑ̀ wɑɑ nɛ do iyi ɑ̀ wɑɑ cɑ̃ ilɛ. ");
INSERT INTO mkl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nɑ ŋɔi í jɔ̀ Ilɑɑɔ̃ í fũsi ŋɑ ɑwɔ ku bɑ ɑ hɑnyɑ ɑ ce dɑɑ sɑ̃mi ɑŋɑ duusɔ̃ɔ si bɛi idɔ nŋɑ í bi. Dɑɑ sɑ̃miu ɑ́ jɔ̀ ɑ cɑ̃ ɑnyi. ");
INSERT INTO mkl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Inɛ ŋɑu ɑ̀ kpɑɑsi ntɔi Ilɑɑɔ̃ do ibo. Mii ŋɑ iyi Ilɑɑɔ̃ í tɑkɑ ŋɑi ɑ̀ wɑɑ tɔɔ ɑ̀ wɑɑ ce nŋɑ icɛ, kù jɛ Ilɑɑɔ̃ tɑkɑɛ. Ilɑɑɔ̃i ɑ̀ nɛ kɑ mɑɑ sɑɑbu hee do ɑjɔ fei. Ami. ");
INSERT INTO mkl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ŋɔi í jɔ̀ Ilɑɑɔ̃ í fũsi ŋɑ ɑwɔ nɔ ɑ̀ dɑsi kɔdɛɛ iyi í jɔ̀ ɑ̀ wɑɑ cɑ̃ ɑnyi. Inɑɑbo nŋɑ ŋɑ ɑ ci yɑ jɛ bɑɑ inɛmɔkɔ ku sũò ŋɑ mɑ́, bii ku jɛ ɑŋɑ duusɔ̃ɔ. ");
INSERT INTO mkl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Bɛɛbɛ mɔi inɛmɔkɔ ŋɑu mɔ ɑ ci yɑ sũò bɑɑ inɑɑbo ŋɑu mɑ́, ɑmmɑ kubi hɑi nɛ yɑɑsei ɑŋɑ duusɔ̃ɔ í lɑ hee í cɑɑ. À wɑɑ ce idei iju hɑi nɛ ɑnyɔ inɛmɔkɔ do inɛmɔkɔ, nɔ ɑŋɑ tɑkɑ nŋɑ ɑ̀ wɑɑ ɡbɑ ijuukpɑ̃ iyi í to zɑkɑi kurɑrɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Si nɑ iyi í jɔ̀ ɑ kù bi Ilɑɑɔ̃ ku mɑ̀ ŋɔi í jɔ̀ í dɑsi ŋɑ lɑsɑbu lɑɑlɔ ɑ ceò mii iyi kù jɔ ɑmɑnɛ ku ce. ");
INSERT INTO mkl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Nɔ lɑɑlɔ fei í wɛɛ nŋɑ, hɑi inɔ ku kɑ̃ do kɔdɛɛ do njɛ ku cé do iɡu do inɛ ku kpɑ do ijɑ do ibo do bisi lɑɑlɔ, hee do irii njɛ ku sɔ. ");
INSERT INTO mkl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","À yɑ mɑɑ fɔ lɑɑlɔi njɛ, ɑ̀ cé Ilɑɑɔ̃, ɑ̀ yɑ yɛ ɑrɑ nŋɑ, ɑ̀ jɛ ilu fɑɑu ŋɑ, ɑ̀ yɑ tɔɔ fufu, ɑ̀ nɛ bisii lɑɑlɔ ku ce, ɑ kù wɑɑ sɑɑlu iyeò bɑɑ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","A kù nɛ bisi, ɑ kù nɛ nɑɑnɛ, ɑ kù bi njɛ, ɑ kù nɛ ɑrɑɑrei njɛ. ");
INSERT INTO mkl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","À mɑ̀ woodɑi Ilɑɑɔ̃ iyi wɑ fɔ í ni, inɛ ŋɑ iyi ɑ̀ wɑɑ ce dimii mii bɛɛbɛ ŋɑ, ikui í jɛ kɔkɔɔ nŋɑ. Do nŋu fei ɑ̀ yɑ coo, nɔ ɑ̀ yɑ mɑɑ sɑɑbu woo ce dimiɛ ŋɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nɑ nŋu, ɑwɔ iyi ì wɑɑ yɛ tɑɑlei inɛ ŋɑ, bɑɑ bii yooi ì jɛ, i kù nɛ iyi ɑɑ fɔ, domi wɑɑti iyi ì wɑɑ yɛ tɑɑlei inɛ ŋɑ nɔ ɑwɔ tɑkɑɛ ì wɑɑ ce mii lɑɑlɔ ŋɑu bɛ, ɑwɔ tɑkɑɛ ì wɑɑ so tɑɑlei. ");
INSERT INTO mkl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Do ntɔ, ɑ̀ mɑ̀ iyi Ilɑɑɔ̃ í nɛ ntɔ bii wɑ yɛ tɑɑlei inɛ ŋɑ iyi ɑ̀ wɑɑ ce dimi bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Debɛi, ì wɑɑ tɑmɑɑ mɑ̀ ɑwɔ ɑɑ fitɑ si kiitii Ilɑɑɔ̃i, ɑwɔ iyi ì wɑɑ yɛ tɑɑlei inɛ ŋɑ, nɔ ɑwɔ mɔ ì wɑɑ ce dimi bɛɛbɛ mɑ́? ");
INSERT INTO mkl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Mɑ̀ ì dondɑ kulɑi jiidɑ ku jɛɛ do temuɑɛ do suuru ku nɛɛi? I kù mɑ̀ iyi jiidɑ ku jɛi Ilɑɑɔ̃ í mɔsi wɑ koo si ɡɑ̃mɛɛ ku bɑ i kpɑɑsi kuwɛɛɛ? ");
INSERT INTO mkl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ammɑ si nɑ iyi í jɔ̀ idɔɛ í le nɔ i kù jɛsi i kpɑɑsi, ì wɑɑ fɑɑ ɑrɑɛ idɔɔkɔ̃ iyi í lɑ í rei si ɑjɔ iyi Ilɑɑɔ̃ ɑ́ kiiti inɛ ŋɑ dee dee nɔ inɛ fei ɑ́ yɔɔ. ");
INSERT INTO mkl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ajɔ nŋu bɛ ɑ́ sɑ̃ɑ inɛ fei si bɛi kuceɛ í to. ");
INSERT INTO mkl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Inɛ ŋɑ iyi ɑ̀ temuɑ ɑ̀ wɑɑ ce jiidɑ ɑ̀ wɑɑ dɛdɛò ɑmboe do bɛɛrɛ, nɔ ɑ̀ wɑɑ dɛ ɑŋɑ ɑ mɑɑ̀ ce nfe, ɑŋɑi Ilɑɑɔ̃ ɑ́ muɑ kuwɛɛ hɑi tɑ̃u. ");
INSERT INTO mkl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ammɑ inɛ ŋɑ iyi ɑ̀ kɔsiɛ nɔ ɑ kù wɑɑ ceò ntɔ icɛ í ɡbe lɑɑlɔ, ɑŋɑi ɑɑ yɛ idɔɔkɔ̃ nlɑɛ. ");
INSERT INTO mkl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Inɛ iyi wɑ ce lɑɑlɔ fei ɑ́ yɛ wɑhɑlɑ do ijuukpɑ̃, hɑi Zuifu ŋɑ hee ku koo si dimi mmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Inɛ mɔ iyi wɑ ce jiidɑ ɑ́ bɑ ɑmboe do bɛɛrɛ do lɑɑkɑi ku sũ, hɑi Zuifu ŋɑ hee ku koo si dimi mmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Bɛɛbɛi Ilɑɑɔ̃ ɑ́ ce domi bi tɛɛ inɛ ɡɔ kù re inɛ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Inɛ ŋɑ iyi ɑ̀ wɑɑ ce dulum hɑi mɑ̀ woodɑ, si woodɑ hɑi mɑ̀ nŋɑi ɑɑ ce nfe. Ammɑ inɛ ŋɑ mɔ iyi ɑ̀ mɑ̀ woodɑ nɔ ɑ̀ wɑɑ ce dulum, woodɑui ɑ́ kiiti ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","domi kù jɛ inɛ ŋɑ iyi ɑ̀ wɑɑ ɡbɔ idei woodɑu ɑŋɑi ɑ̀ jɛ dee dee si wɑjui Ilɑɑɔ̃, í ɡbe inɛ ŋɑ iyi ɑ̀ wɑɑ ce iyi wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Wɑɑti iyi dimi mmu ŋɑ, ɑŋɑ iyi ɑ kù mɑ̀ woodɑ, ɑ̀ wɑɑ ce mii iyi wɑ fɔ do idɔɔbi nŋɑ, iyi bɛ wɑ nyisi iyi woodɑu í wɑ si idɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Dɑɑ nŋɑ wɑ nyisi iyi ɑ̀ kɔ woodɑu si idɔ nŋɑ. Idɔ nŋɑ wɑ jɛ sɛɛdɑɛ, nɔ lɑsɑbu nŋɑ í yɑ yɛ tɑɑle nŋɑ wɑlɑkɔ ku nɑ ŋɑ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ajɔi kiitii Ilɑɑɔ̃ si bii Jesu Kirisi ɑ́ kiiti inɛ ŋɑ bɛɛbɛi mii ŋɑu bɛ fei ɑ́ ce. Á kiiti inɛ ŋɑ nɑ icɛ iyi ɑ̀ wɑɑ ce si ɑsii fei si bɛi lɑɑbɑɑu jiidɑ iyi ǹ wɑ n sisi nŋɛu wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Awɔ Zuifu, ì wɑɑ cɔ ɑrɑɛ Zuifu, ì wɑɑ nɑɑnɛ woodɑ, ì wɑɑ tɔɔ fufu ì ni ɑwɔ ì jɛ inɛi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ì mɑ̀ mii iyi Ilɑɑɔ̃ í bi i ce, nɔ woodɑ í kɔɛ si i ce mii iyi í sĩɑ. ");
INSERT INTO mkl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ì wɑɑ tɑmɑɑ iyi ɑɑ yɔkɔ i cuɑɑ fɛɛju ŋɑ nɔ i jɛ inyɑ kumɑ́i inɛi ilu kuku ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Ì wɑɑ tɑmɑɑ mɑ̀ ɑɑ yɔkɔ i muɑ nnyɛi ŋɑ bisi, nɔ i kɔ hɑi mɑ̀ ŋɑ si cio, domi ì mɑ̀ iyi icui kumɑ̀ do ntɔu si woodɑi í wɑ. ");
INSERT INTO mkl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","To, ɑwɔ iyi ì wɑɑ kɔ inɛ ɡɔ ŋɑ si cio, nɑ mii í ce i kɑɑ kɔ ɑrɑɛ. Awɔ iyi ì wɑɑ sɔ̃ inɛ ŋɑ ɑ mɑɑ̀ ce ile, nɑ mii ì wɑɑ ce ile. ");
INSERT INTO mkl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Awɔ iyi ì ni inɛ ŋɑ ɑ mɑɑ̀ ce sɑkɑrɑ, nɑ mii í ce ì wɑɑ coo. Awɔ iyi ì cé iwɛ̃, nɑ mii í ce ì wɑɑ bɔ ilè ile bɛ. ");
INSERT INTO mkl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Awɔ iyi ì wɑɑ tɔɔ fufu si nɑ iyi í jɔ̀ ì mɑ̀ woodɑ, nɑ mii í ce i kù wɑɑ jirimɑɛ ì jɔ̀ irii Ilɑɑɔ̃ wɑ bɛjɛ. ");
INSERT INTO mkl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nɑ irii iŋɛ Zuifu ŋɑi dimi mmu ŋɑ ɑ̀ bɑ ɑ̀ wɑɑ fɔò tɑɑlei Ilɑɑɔ̃, si bɛi kukɔi ideɛ wɑ fɔ. ");
INSERT INTO mkl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Awɔ Zuifu, bii ì wɑɑ too woodɑ, bɑnɡoɛ í nɛ ɑrɑnfɑ̃ɑni jiidɑ, ɑmmɑ bii i kù wɑɑ jirimɑ woodɑu, bɑnɡoɛ í jɛ nɡbɛ. ");
INSERT INTO mkl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nɑ nŋu, dimi mmu iyi ɑ kù dɑsiɛ bɑnɡo nɔ wɑ too woodɑu, Ilɑɑɔ̃ kɑɑ cɔɔ bɛi inɛ iyi ɑ̀ dɑsiɛ bɑnɡo? ");
INSERT INTO mkl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Dimi mmu iyi wɑ too woodɑu, bɑɑ bii ɑ kù dɑsiɛ bɑnɡou ɑ́ yɛ tɑɑlei iŋɛ Zuifu ŋɑu, domi bɑɑ do iyi ì ce bɑnɡo nɔ ì mɑ̀ woodɑ iyi ɑ̀ kɔ nŋɛ i kù wɑɑ jirimɑɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Inɛ iyi í jɛ Zuifu do ntɔ kù jɛ inɛ iyi í jɛ Zuifu si kuyɛi inɛ ŋɑ. Iyi í nɔ í jɛ bɑnɡou ntɔ ntɔ kù jɛ iyi ɑ̀ yɑ ce si ɑrɑ. ");
INSERT INTO mkl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ammɑ inɛ iyi í jɛ Zuifu ntɔ ntɔ, nŋui í jɛ Zuifu si idɔɛ. Iyi í nɔ í jɛ bɑnɡo do ntɔ nŋui í jɛ bɑnɡoi idɔ. Icɛi Hundei Ilɑɑɔ̃i, kù jɛ ti woodɑ. Zuifu dimi bɛɛbɛ, Ilɑɑɔ̃i ɑ́ sɑɑbuɛ, kù jɛ ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Debɛi, ɑrɑnfɑ̃ɑni yoomɑi Zuifu ku jɛ í nɛ. Ribɑ yoomɑi bɑnɡo ku ce í nɛ. ");
INSERT INTO mkl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ntɔ ntɔ ɑrɑnfɑ̃ɑniɛ í lɑ si mii fei. Sinte, Zuifu ŋɑi Ilɑɑɔ̃ í dɑɑ ideɛ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Bii inɛ ɡɔ ŋɑ ɑ kù dɑsi nɑɑnɛ, nɑɑnɛ hɑi dɑsi nŋɑu ɑ́ jɔ̀ Ilɑɑɔ̃ mɔ kú jɛ hɑi nɛ nɑɑnɛi? ");
INSERT INTO mkl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Aɑwo, kù jɛ bɛɛbɛ. Bɑɑ bii inɛ fei í jɛ ilu ibo kɑ mɑ̀ iyi Ilɑɑɔ̃ í jɛ ntɔ. Si bɛi kukɔi ideɛ wɑ fɔ nɑ iriɛ í ni, Amɑnɛ ŋɑ ɑ̀ nɛ ɑ mɑ̀ iyi ì jɛ dee dee si ide kufɔɛ, Nɔ ì yɑ fɔ ntɔ si kiitiɛ. ");
INSERT INTO mkl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","6","Ammɑ bii lɑɑlɔ ku ce nwɑ í jɔ̀ ɑ̀ mɑ̀ iyi Ilɑɑɔ̃i í jɛ dee dee, bɛirei ɑɑ kɑ ni. Aɑ kɑ yɛ tɑɑlei Ilɑɑɔ̃ bii wɑ kpɑ̃ wɑ iju? Aɑwo, kù jɛ bɛɛbɛ. Ǹ wɑ n fɔ dei si bɛi ɑmɑnɛ ŋɑ ɑ̀ yɑ dɔ̃. Bii Ilɑɑɔ̃ kù jɛ dee dee, debɛi bɛirei ɑ́ ce ku kiiti ɑndunyɑu. ");
INSERT INTO mkl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Bii ibom í teese í jɔ̀ inɛ ŋɑ ɑ̀ wɑɑ yɛ ntɔi Ilɑɑɔ̃, nɔ do yɑɑse bɛɛbɛ iriɛ wɑ bɑò ɑmboe, nɑ mii í ce ɑ́ mɑɑ yɛ tɑɑlem mɑ́ bɛi ilu dulum. ");
INSERT INTO mkl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Nɑ mii í ce ɑ kɑɑ kɑ ni, kɑ ce lɑɑlɔ ku bɑ irii Ilɑɑɔ̃ ku nɛò bɛɛrɛ. Inɛ ɡɔ ŋɑ ɑ̀ yɑ ni bɛɛbɛi ǹ wɑ n fɔ ku bɑ ɑ bɛjɛ irim. Inɛ dimiɛ ŋɑ ɑɑ nɔ ɑ yɛ ijuukpɑ̃ɛ si bɛi í jɔ. ");
INSERT INTO mkl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Debɛi, ɑwɑ Zuifu ŋɑ mɔ ɑ̀ tiɑ inɛ ɡɔ ŋɑ mɛɛ. Aɑwo, bɑɑ keeke, domi ɑ̀ nyisi tɑ̃ iyi Zuifu ŋɑ do dimi mmu ŋɑ ɑŋɑ fei ɑ̀ wɑ si ɑwɔ ɡbuɡbɑ̃i dulum. ");
INSERT INTO mkl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kukɔi idei Ilɑɑɔ̃ wɑ fɔ í ni, Inɛ kɑ̃mɑ kù jɛ dee dee, bɑɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Inɛ ɡɔ kù wɛɛ iyi í nɛ bisi. Inɛ ɡɔ kù nɔ kù wɛɛ iyi wɑ dɛ Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Inɛ fei í nyɔi, Inɛ fei í bɛjɛi. Inɛ kɑ̃mɑ kù wɛɛ iyi wɑ ce jiidɑ bɑɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Idei ɡɛlɛ nŋɑ í sɑ̃mi bɛi bɑlɛ foo, Nɔ í nɛ ɑcĩ bɛi njo. Do idei ɡɛlɛ nŋɑui ɑ̀ yɑ tɑkiò inɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","À nɛ inɔ kuro nɔ ikpei wɑ kɔ̃ si ɡɛlɛ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Kutɛ ɡbɑ̃ɑ ku kpɑ inɛi ɑ̀ nɛ. ");
INSERT INTO mkl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Bii ɑ̀ bɔ fei idei kukpɑ do inɔ kufɔi ɑ̀ yɑ jɔ̀ bɛ. ");
INSERT INTO mkl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","A kù mɑ̀ kpɑ̃ɑi lɑɑkɑi ku sũ. ");
INSERT INTO mkl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","A kù nɛ njoi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ammɑ ɑwɑ ɑ̀ mɑ̀ iyi mii iyi woodɑ wɑ fɔ fei, inɛ ŋɑ iyi woodɑu í kɑ̃i wɑ fɑ̃ɑ. Woodɑ í wɛɛi ku bɑ ɡɛlɛ kɑ̃mɑ ku mɑɑ̀ nɛ iyi ɑ́ fɔ, nɔ inɛ fei ku mɑ̀ iyi Ilɑɑɔ̃ wɑ yɛ tɑɑleɛ. ");
INSERT INTO mkl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ntɔ ntɔ inɛ kɑ̃mɑ kù wɛɛ iyi ɑ́ yɔkɔ ku jirimɑ woodɑ hee koo jɛò dee dee si wɑjui Ilɑɑɔ̃. Woodɑ í wɛɛi ku bɑ ku jɔ̀ ɑmɑnɛ ku mɑ̀ iyi nŋu í jɛ ilu dulum. ");
INSERT INTO mkl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ammɑ nsɛi, Ilɑɑɔ̃ í nyisi wɑ yɑɑse bɛi nŋu í yɑ ce ɑmɑnɛ dee dee, kù jɛ do idei woodɑ. Woodɑi Moizi do wɑliii Ilɑɑɔ̃ ŋɑu ɑ̀ jɛ sɛɛdɑɛ. ");
INSERT INTO mkl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Inɛ ŋɑ iyi ɑ̀ dɑsi Jesu Kirisi nɑɑnɛ fei, Ilɑɑɔ̃ í ce ŋɑ dee dee nɑ nɑɑnɛ iyi ɑ̀ dɑsiu. Inɛ ɡɔ kù jɛ ikɑ̃, ");
INSERT INTO mkl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","domi inɛ fei í ce dulum nɔ ɑ̀ kuɑ ɑmboei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ammɑ Ilɑɑɔ̃ í ce ŋɑ dee dee hɑi nɛ nɡɔɡɔ ku sɑ̃ nɑ didɔ̃ɛ do sɑɑbui Jesu Kirisi iyi í yɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Nŋui Ilɑɑɔ̃ í jilɛ ku jɛ kuwee. Njɛɛ iyi í nikɑ̃ í kpɑ dulum dii inɛ ŋɑ iyi ɑ̀ dɑsiɛ nɑɑnɛ. Ilɑɑɔ̃ í ce bɛɛbɛi ku nyisiò iyi nŋu í jɛ dee dee. Tɑko wo si suuruɛ í temuɑ do dulum dii ɑmɑnɛ ŋɑ, kù kpɑ̃ ŋɑ iju. ");
INSERT INTO mkl_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ammɑ si dee dee ku jɛɛ wɑ nyisi wɑ si wɑɑtii nsɛiu ihɛ̃ iyi nŋu inɛ dee deei, nɔ nŋu wɑ ce inɛ ŋɑ dee dee nɑ nɑɑnɛ iyi ɑ̀ dɑsi Jesu. ");
INSERT INTO mkl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Debɛi, ɑ̀ nɛ kpɑ̃ɑ iyi ɑɑ kɑ tɔɔ fufu mɑ́? Aɑwo, kɑɑ ce. Nɑ mii. Si nɑ iyi í jɔ̀ kù jɛ woodɑ ku jirimɑi ɑ̀ wɑɑ kɑ, bii kù jɛ nɑɑnɛ ku dɑsi. ");
INSERT INTO mkl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","À nɔ ɑ̀ yɛ iyi ɑmɑnɛ ɑ́ jɛ dee deei nɑ nɑɑnɛ iyi í dɑsi nŋu ɑkɑ̃, kù jɛ nɑ woodɑ ku jirimɑ. ");
INSERT INTO mkl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Mɑ̀ Ilɑɑɔ̃ í jɛ ti Zuifu ŋɑ ɑŋɑ ɑkɑ̃i? Kù jɛ ti dimi mmu ŋɑ mɑ́? Ntɔ ntɔ í jɛ ti dimi mmu ŋɑ mɔ, ");
INSERT INTO mkl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","domi Ilɑɑɔ̃ ɑkɑ̃i í wɛɛ. Nŋui ɑ́ ce inɛ ŋɑ dee dee nɑ nɑɑnɛ ku dɑsi nŋɑ, hɑi Zuifu ŋɑ hee do dimi mmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Si bɛɛbɛ ɑ̀ wɑɑ kpɑ woodɑ nɑ idei nɑɑnɛ ku dɑsiui? Aɑwo. À kɔ̃ɔsi ɡbuɡbɑ̃ɛ mɔm nii. ");
INSERT INTO mkl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Bɛirei ɑɑ kɑ fɔ nsɛi do idei Aburɑhɑmu bɑlɑ nwɑ. Mii í bɑ. ");
INSERT INTO mkl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Bii Ilɑɑɔ̃ í ce Aburɑhɑmu ɑmɑnɛ dee dee nɑ icɛ iyi í ce, ɑ́ yɔkɔ ku tɔɔò fufu. Ammɑ kù nɛ si bii ɑ́ tɔɔò fufu si wɑjui Ilɑɑɔ̃, ");
INSERT INTO mkl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","domi kukɔi idei Ilɑɑɔ̃ wɑ fɔ í ni, Aburɑhɑmu í dɑsi Ilɑɑɔ̃ nɑɑnɛ nɔ nŋui í jɔ̀ Ilɑɑɔ̃ í dooɛ si inɛ dee dee. ");
INSERT INTO mkl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Nsɛi, inɛ iyi wɑ ce icɛ ɑ ci yɑ doo fiɑi lɑfɛ̃ɛ bɛi ɑmuɑ, ti njɛ ɑsɑiyɑɛi. ");
INSERT INTO mkl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ammɑ inɛ iyi í dɑsi Ilɑɑɔ̃ nɑɑnɛ, nɔ kù dɛ nŋu ku jɛ dee dee nɑ icɛɛ, Ilɑɑɔ̃ mɔ, nŋu iyi í yɑ ce ilu dulum ŋɑ dee dee, ɑ́ doo lɑfɛ̃ɛu ɑmɑnɛ dee dee nɑ nɑɑnɛ ku dɑsiɛ. ");
INSERT INTO mkl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Bɛɛbɛi Dɑvidi mɔ wɑ fɔ idei inɔ didɔ̃i inɛ iyi Ilɑɑɔ̃ í doo ɑmɑnɛ dee dee iyi kù jɛ nɑ icɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Í ni, Ilu inɔ didɔ̃i inɛ iyi Ilɑɑɔ̃ í kpɑ idei kurɑrɑɛ, Nɔ í bii dulum dɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ilu inɔ didɔ̃i inɛ iyi Ilɑɑɔ̃ kù wɑɑ doo dulum dɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Inɔ didɔ̃u, ti inɛ ŋɑ iyi ɑ̀ ce bɑnɡo ɑŋɑ ɑkɑ̃i? Kù jɛ ti inɛ ŋɑ mɔ iyi ɑ kù ce bɑnɡo? À tɑko ɑ̀ fɔɔ tɑ̃ wo ɑ̀ ni, Ilɑɑɔ̃ í doo Aburɑhɑmu ɑmɑnɛ dee dee nɑ nɑɑnɛ iyi í dɑsiu. ");
INSERT INTO mkl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Bɛirei í yɛ wɑɑti bɛɛbɛ. Í ce bɑnɡo bɑ. Mɑ̀ kù ce. Wɑɑti bɛɛbɛ kù ce bɑnɡo titɑ̃. Hɑi lɔ bɑnɡoi wɑ jɛ. ");
INSERT INTO mkl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Si ɑnyiɛ í nɑ í ce bɑnɡo iyi wɑ jɛ nyindɑ iyi Ilɑɑɔ̃ í coo inɛ dee dee. Í coo inɛ dee dee nɑ nɑɑnɛ ku dɑsiu wɑɑti iyi kù ce bɑnɡo. Bɛɛbɛ mɔi í nɑ í jɛ bɑlɑi hɑi ce bɑnɡo ŋɑ iyi ɑ̀ dɑsi nɑɑnɛ fei ku bɑ Ilɑɑɔ̃ ku doo ɑŋɑ mɔ inɛ dee dee ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Nɔ wɑ jɛ bɑlɑi woo ce bɑnɡo ŋɑ mɔ, ɑŋɑ iyi kù jɛ bɑnɡo nŋu ɑkɑ̃i ɑ̀ ce, ɑmmɑ tuubɑi nɑɑnɛ ku dɑsi iyi bɑlɑ nwɑ Aburɑhɑmu í jɔ̀ si wɑɑti iyi kù ce bɑnɡo, nŋui ɑŋɑ mɔ ɑ̀ wɑɑ too si. ");
INSERT INTO mkl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ilɑɑɔ̃ í ceɑ Aburɑhɑmu do dimiɛ ŋɑ kuwɑ̃ iyi ɑŋɑi ɑɑ jɛ tubui ɑndunyɑu ihɛ̃ fei. Kù jɛ si nɑ iyi í jɔ̀ í jirimɑ woodɑ, ɑmmɑ si nɑ iyi í jɔ̀ í jɛ dee dee nɑ nɑɑnɛ ku dɑsiɛui. ");
INSERT INTO mkl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Bii í jɛ inɛ ŋɑ iyi ɑ̀ wɑɑ jirimɑ woodɑ, ɑŋɑi ɑɑ nɛ mii ŋɑ iyi Ilɑɑɔ̃ í ce kuwɑ̃ɛu, nɑɑnɛ ku dɑsiu nɡbɛi, nɔ kuwɑ̃ iyi Ilɑɑɔ̃ í ceu mɔ í kpɑ iri mbɛ, ");
INSERT INTO mkl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","domi woodɑi wɑ nɑɑò idɔɔkɔ̃i Ilɑɑɔ̃ wɑ. Ammɑ bii woodɑ kù wɛɛ, idei woodɑ ku kuɑ mɔ kɑɑ wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Nɑ nŋu, kuwɑ̃u, ti inɛ ŋɑ iyi ɑ̀ dɑsi nɑɑnɛi ku bɑ ku jɛ ɑmuɑ iyi Ilɑɑɔ̃ í mu nwɑ nɑ didɔ̃ɛ nɔ ku jɛ ti dimii Aburɑhɑmu fei. Kù jɛ inɛ ŋɑ iyi ɑ̀ nɛ woodɑ ɑŋɑ ɑkɑ̃, ɑmmɑ do inɛ ŋɑ iyi ɑ̀ dɑsi nɑɑnɛ bɛi Aburɑhɑmu, nŋu iyi í jɛ bɑlɑi ɑwɑ fei. ");
INSERT INTO mkl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kukɔi idei Ilɑɑɔ̃ wɑ fɔ í ni, nŋui ǹ ce bɑlɑi dimi nkpɔ. Nŋui í jɛ bɑlɑ nwɑ si wɑjui Ilɑɑɔ̃. Ilɑɑɔ̃i í dɑsi nɑɑnɛ, nŋu iyi í yɑ jĩ iku ŋɑ, nɔ do ide ku fɔɛi í tɑkɑ mii ŋɑ iyi ɑ kù wɛɛ wo. ");
INSERT INTO mkl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Aburɑhɑmu í dɑsi Ilɑɑɔ̃ nɑɑnɛ nɔ wɑ cɔò kpɑ̃ɑ bɑɑ do iyi kù yɛ mii iyi wɑ deɡbeu titɑ̃. Nɑ nŋu, Ilɑɑɔ̃ í coo bɑlɑi dimi nkpɔ ŋɑ si bɛi í tɑko í fɔ í ni, dimiɛ ŋɑ ɑɑ nɑ ɑ kpɔ. ");
INSERT INTO mkl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Wɑɑti nŋu í nɛ zɑkɑi ɑdɔ̃ cĩɔ. Í mɑ̀ iyi nŋu í ɡbo, nɔ Sɑrɑ ɑboɛu mɔ kɑɑ yɔkɔ ku bí ɑmɑ mɑ́, ɑmmɑ do nŋu fei nɑɑnɛ ku dɑsiɛ kù kɑye. ");
INSERT INTO mkl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Kù fũsi nɑɑnɛ ku dɑsiɛ ɑwɔ, kù nɔ kù sikɑ si ide iyi Ilɑɑɔ̃ í wɑ̃u. Nɑɑnɛu í teese wɑ muɑɑ ɡbuɡbɑ̃ mɔm nii nɔ wɑ sɑɑbu Ilɑɑɔ̃, ");
INSERT INTO mkl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","domi í mɑ̀ kɑm kɑm, mii iyi Ilɑɑɔ̃ í wɑ̃u í nɛ ɡbuɡbɑ̃i ku coo. ");
INSERT INTO mkl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ŋɔi í jɔ̀ nɑ nɑɑnɛ ku dɑsiɛ Ilɑɑɔ̃ í dooɛ inɛ dee dee. ");
INSERT INTO mkl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ammɑ iyi ɑ̀ kɔɔ ɑ̀ ni, ɑ̀ dooɛ inɛ dee dee, kù jɛ nɑ irii nŋu ɑkɑ̃i ɑ̀ kɔɔ. ");
INSERT INTO mkl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","À kɔɔi nɑ irii ɑwɑ mɔ iyi Ilɑɑɔ̃ wɑ doo wɑ inɛ dee dee, ɑwɑ iyi ɑ̀ dɑsiɛ nɑɑnɛ, nŋu iyi í jĩ Jesu Lɑfɛ̃ɛ nwɑ hɑi si bɑlɛ. ");
INSERT INTO mkl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ilɑɑɔ̃i í jɔ̀ ɑ̀ kpɑ Jesu wo nɑ irii dulum du wɑ nɔ í jũu mɑ́ ku bɑ ku ce wɑ inɛ dee dee ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Nsɛi, si bɛi Ilɑɑɔ̃ í ce wɑ inɛ dee dee ŋɑ nɑ nɑɑnɛ ku dɑsi nwɑ, ɑ̀ dɔ̃ do nŋu nɑ sɑɑbui Lɑfɛ̃ɛ nwɑ Jesu Kirisi. ");
INSERT INTO mkl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Jesu mɔi í mu nwɑ kpɑ̃ɑ do sɑɑbui nɑɑnɛ ku dɑsiu kɑ sɛkɛɛ si Ilɑɑɔ̃, nŋu iyi í ce nwɑ didɔ̃. Nɑ didɔ̃ui ɑ̀ wɑɑ leekĩ dim dim nɔ ɑ̀ nɛ inɔ didɔ̃ domi ɑ̀ wɑɑ cɔ kpɑ̃ɑ iyi ɑɑ kɑ nɛ bɑɑ nwɑ si ɑmboei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Iyi í re mɔm, bɑɑ si wɑhɑlɑ ɑ̀ yɑ kɑ nɛ inɔ didɔ̃i domi ɑ̀ mɑ̀ iyi wɑhɑlɑ í yɑ bí temuɑ. ");
INSERT INTO mkl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Bii ɑ̀ nɔ ɑ̀ temuɑ si wɑhɑlɑu, ɑɑ kɑ fitɑ bɛi inɛ iyi í jɛ iɡũ si lɑɑkɑi ku cɔ, nɔ iɡũ iyi ɑ̀ jɛu ɑ́ bí nwɑ kpɑ̃ɑ ku cɔ. ");
INSERT INTO mkl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Nɔ kpɑ̃ɑ iyi ɑ̀ wɑɑ cɔu kɑɑ jɛ nɡbɛ domi kubii Ilɑɑɔ̃ í wɑ si idɔ nwɑ do sɑɑbui Hundeɛ iyi í mu nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Si wɑɑti iyi ɑ kù nɛ ɡbuɡbɑ̃, Kirisi í ku nɑ irii inɛ ŋɑ iyi ɑ kù mɑ̀ bɛɛrɛi Ilɑɑɔ̃. Í kui si wɑɑti iyi Ilɑɑɔ̃ í jilɛu. ");
INSERT INTO mkl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","À ɡɑɑbuɑ ɑmɑnɛ ku jɛsi nŋu ku ku bɑɑ nɑ inɛ dee dee. Á yɔkɔ ku jɛ ilu wɔɔkɔ ɡɔ ɑ́ jɛsi nŋu ku ku nɑ inɛ jiidɑ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ammɑ Ilɑɑɔ̃ í nyisi wɑ kubi nlɑɛ domi wɑɑti iyi ɑ̀ jɛ ilu dulum ŋɑ Kirisi í ku nɑ iri nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Nsɛi, si nɑ iyi í jɔ̀ njɛi Kirisi í jɔ̀ Ilɑɑɔ̃ í ce wɑ inɛ dee dee ŋɑ, kù nɛ sikɑ kɑ̃mɑ ɑ́ fɑɑbɑ wɑ hɑi si idɔɔkɔ̃ɛ iyi ɑ́ nɑɑ. ");
INSERT INTO mkl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Wɑɑti iyi ɑ̀ jɛ mbɛɛi Ilɑɑɔ̃, í jɔ̀ ɑ̀ dɔ̃ do nŋu nɑ ikui Amɑɛ. Nɑ nŋu nsɛi, si bɛi ɑ̀ dɔ̃ do nŋu, sikɑ kɑ̃mɑ kù wɑsi ɑ́ nyi ku fɑɑbɑ wɑ mɑ́ nɑ kuwɛɛi Amɑu. ");
INSERT INTO mkl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Iyi í re mɔm, Lɑfɛ̃ɛ nwɑ Jesu Kirisi, nŋu iyi í jɔ̀ ɑ̀ dɔ̃ do Ilɑɑɔ̃, í nyi í jɔ̀ ɑ̀ nɛ inɔ didɔ̃ mɑ́ si Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Dulum í lɔ wɑi si ɑndunyɑ hɑi bi inɛ ɑkɑ̃, nɔ dulum nɔu í nɑɑò iku wɑ. Si bɛɛbɛ, ikuu í tosi inɛ fei domi inɛ feii í ce dulum. ");
INSERT INTO mkl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ntɔi dulum í wɑ si ɑndunyɑ wo woodɑi Moizi í bɛi í nɑɑ, ɑmmɑ bii woodɑ kù wɛɛ, ijuukpɑ̃i woodɑ ku kuɑ mɔ kɑɑ wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Do nŋu fei, hɑi wɑɑtii Adɑmu hee ku koo si Moizi fei, inɛ ŋɑ ɑ̀ yɑ ku bɑɑ do iyi ɑ kù kuɑ woodɑ bɛi Adɑmu í ce. Aɑ kɑ yɔkɔ kɑ wɑ̃ Adɑmu do inɛ iyi í nɑ í nɑɑu. ");
INSERT INTO mkl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ntɔ ntɔ, inɛ nkpɔi í ku nɑ kurɑrɑi inɛ ɑkɑ̃u, ɑmmɑ didɔ̃i Ilɑɑɔ̃ í lɑ í re kurɑrɑi Adɑmu. Didɔ̃i Ilɑɑɔ̃u mɔ hɑi bi inɛ ɑkɑ̃i í nɑɑ, nɔ lɑfɛ̃ɛui í jɛ Jesu Kirisi. Didɔ̃u ɑmuɑ nlɑ nlɑi, nɔ í tosi inɛ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Amuɑi Ilɑɑɔ̃u do kurɑrɑi inɛ ɑkɑ̃u í wɑ̃ɑiɑ njɛ, domi kurɑrɑ ɑkɑ̃ui í jɔ̀ Ilɑɑɔ̃ ɑ́ kiiti inɛ ŋɑ ku yɛ tɑɑle nŋɑ, ɑmmɑ didɔ̃ɛi ɑ́ jɔ̀ ku ce wɑ inɛ dee dee bɑɑ do iyi ɑ̀ tɑko ɑ̀ ce kurɑrɑ nkpɔ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","À mɑ̀ iyi iku í tosi inɛ fei nɑ kurɑrɑi inɛ ɑkɑ̃u. Ammɑ nɑ inɛ ɑkɑ̃ mɔi ɑɑ kɑ bɑ mii iyi í lɑ í re, domi inɛ iyi í ɡbɑ didɔ̃ nlɑi Ilɑɑɔ̃ do ɑmuɑ nlɑɛ iyi í jɔ̀ í jɛ dee dee fei, ɑ́ mɑɑ wɛɛ nɔ ɑ́ jɛ bommɑ nɑ irii Jesu Kirisiu. ");
INSERT INTO mkl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nɑ nŋu, si bɛi kurɑrɑi inɛ ɑkɑ̃ í jɔ̀ Ilɑɑɔ̃ í yɛ tɑɑlei inɛ fei, bɛɛbɛ mɔi dee dee ku jɛi inɛ ɑkɑ̃ í jɔ̀ inɛ fei í jɛ dee dee í bɑò kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Si bɛi ide hɑi ɡbɔi inɛ ɑkɑ̃ í jɔ̀ inɛ nkpɔ í jɛ ilu dulum, bɛɛbɛ mɔi Ilɑɑɔ̃ ɑ́ ce inɛ nkpɔ dee dee nɑ ide ku jirimɑi inɛ ɑkɑ̃u. ");
INSERT INTO mkl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Woodɑ í lɔ wɑi ku bɑ kurɑrɑ ku kɔ̃ɔsi, ɑmmɑ bii dulum í kɔ̃ɔsi, didɔ̃i Ilɑɑɔ̃ mɔ í yɑ kɔ̃ɔsi ku roo mɑ́i. ");
INSERT INTO mkl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Si bɛi dulum í lɔsi inɛ fei hee í nɑɑò iku wɑ, bɛɛbɛ mɔi didɔ̃i Ilɑɑɔ̃ í nɑɑ si inɛ fei ku bɑ ku ce wɑ inɛ dee dee ŋɑ nɔ ku mu nwɑ kuwɛɛ iyi ci yɑ tɑ̃ nɑ ɑnu ɑkɑ̃ iyi ɑ̀ nɛ do Lɑfɛ̃ɛ nwɑ Jesu Kirisi. ");
INSERT INTO mkl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Debɛi bɛirei ɑɑ kɑ ce. Aɑ kɑ yɑ mɑɑ ce dulum ku bɑ didɔ̃u ku kɔ̃ɔsi? ");
INSERT INTO mkl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Aɑwo, kù jɛ bɛɛbɛ. Awɑ iyi ɑ̀ ku si ɡɑ̃mɛi dulum, bɛirei ɑɑ kɑ ce kɑ mɑɑ jɛ kuwɛɛ nwɑ si dulum mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","I kù mɑ̀ ŋɑ ɑwɑ iyi ɑ̀ dɑsi wɑ inyi do irii Jesu Kirisi fei, ɑ̀ kui bɛi nŋu mɔ í ku? ");
INSERT INTO mkl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Nɑ nŋu, si inyi ku dɑsiu ɑ̀ ku do nŋu ɑjɔ, nɔ ɑ̀ si wɑ do nŋu ɑjɔ, ku bɑ bɛi ɑmboei Ilɑɑɔ̃ Bɑɑbɑ í dedeɛ hɑi si bɑlɛ ɑwɑ mɔ kɑ mɑɑ nɛ si kuwɛɛ titɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ntɔ ntɔ, si bɛi ɑnu ɑkɑ̃ nwɑ do nŋu í jɔ̀ ɑ̀ ku do nŋu ɑjɔ, kù nɛ sikɑ ɑ́ jɔ̀ kɑ dede mɑ́ hɑi si bɑlɛ do nŋu ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","À mɑ̀ iyi ɑ̀ kpɑkpɑ dɑɑ nwo nwɑ si jĩi ku ɡɑɑu do Jesu ɑjɔ, ku bɑ dɑɑ nwo nwɑ iyi wɑ dɑsi wɑ dulum nɔu ku kpɑ iri, nɔ kɑ mɑɑ̀ jɛ ɑrui dulum mɑ́, ");
INSERT INTO mkl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","domi dulum kɑɑ nɛ ɡbuɡbɑ̃ kɑ̃mɑ mɑ́ si inɛ iyi í ku. ");
INSERT INTO mkl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nsɛi, si bɛi ɑ̀ ku do Kirisi ɑjɔ, bɛɛbɛ mɔi ɑ̀ nɛ nɑɑnɛ iyi ɑɑ kɑ bɑ kuwɛɛ do nŋu ɑjɔ, ");
INSERT INTO mkl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","domi ɑ̀ mɑ̀ iyi Kirisi, nŋu iyi í dede hɑi si bɑlɛ kɑɑ ku mɑ́, iku kù nɛ siɛ ɡbuɡbɑ̃ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Wɑɑti iyi í ku, í kui ɡbɑkɑ̃ ɑkɑ̃ nɑ irii dulum, ɑmmɑ í bɑɑ si kuwɛɛ mɑ́, nɔ kuwɛɛ iyi í wɑ si nsɛi í jɛ ti Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Bɛɛbɛ mɔi iŋɛ tɑkɑ nŋɛ i doo ɑrɑ nŋɛ bɛi iku si ɡɑ̃mɛi dulum, nɔ i doo ɑrɑ nŋɛ ilu hunde mɑ́ si wɑjui Ilɑɑɔ̃ nɑ ɑnu ɑkɑ̃ nŋɛ iyi ì nɛ do Jesu Kirisi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Nɑ nŋu, i mɑɑ̀ jɔ̀ dulum ku jɛ bommɑ si ɑrɑ nŋɛ mɑ́, i mɑɑ̀ ti i jɔ̀ kɔdɛɛi ɑrɑu ku kɑ̃miɑ ŋɛ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","I mɑɑ̀ ti i jɔ̀ ikɔ̃ ikɔ̃i ɑrɑ nŋɛ kɑ̃mɑ kù wɑ si ɑwɔi dulum mɑ́ i mɑɑ ceò lɑɑlɔ ŋɑ. Ammɑ i so ɑrɑ nŋɛ i nɑ Ilɑɑɔ̃ bɛi inɛ ŋɑ iyi ɑ̀ jĩ wɑ hɑi si bɑlɛ, nɔ i so ikɔ̃ ikɔ̃i ɑrɑ nŋɛ fei i dɑɑ Ilɑɑɔ̃ si ɑwɔ ŋɑ i mɑɑ ceò jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Dulum kù nɛ ku nɛ si ŋɛ ɡbuɡbɑ̃ mɑ́ domi woodɑ kù nɛ ɡbuɡbɑ̃ si ŋɛ ɑmmɑ didɔ̃i Ilɑɑɔ̃i í nɛ ɡbuɡbɑ̃ si ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","To, mii ɑɑ kɑ ce. Si bɛi Ilɑɑɔ̃ í ce nwɑ didɔ̃ nɔ woodɑ kù nɛ si wɑ ɡbuɡbɑ̃, dulum nii ɑɑ kɑ mɑɑ ce? Aɑwo, kù jɛ bɛɛbɛ. ");
INSERT INTO mkl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ì mɑ̀ sɑ̃ɑ sɑ̃ɑ ŋɑ bii ì so ɑrɑ nŋɛ ì dɑɑ inɛ ɡɔ si ɑwɔ ì wɑɑ jirimɑɛ ŋɑ, inɛ iyi ì wɑɑ jirimɑu bɛ ŋɑ ɑruɛi ì jɛ ŋɑ. Bii ì jɛ ɑrui dulum ŋɑ, kɔkɔɔɛi í jɛ iku, bii ì nɔ ì jɛ ɑrui Ilɑɑɔ̃ ku jirimɑ ŋɑ, kɔkɔɔi nŋu mɔi ɑ́ jɔ̀ Ilɑɑɔ̃ ku ce ŋɛ inɛ dee dee ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ammɑ kɑ sɑɑbu Ilɑɑɔ̃ domi bɑɑ do iyi ì jɛ ɑrui dulum ŋɑ wo, nsɛi do inɔ ɑkɑ̃i ì wɑɑ jirimɑ kukɔsi iyi ɑ̀ dɑ nŋɛ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","À yɑ ŋɛ hɑi si ɑwɔi dulum, nɔ ì bɑɑ ì jɛ ɑrui icɛ jiidɑ ku ce ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ǹ wɑ n sɔ̃ ŋɛ ideu ihɛ̃i do yɑɑsei kucei inɛ ŋɑ nɑ ɡbuɡbɑ̃ hɑi nɛ nŋɛ. Si bɛi ì tɑko ì so ikɔ̃ ikɔ̃i ɑrɑ nŋɛ ikɑ̃ ikɑ̃ ì dɑɑ riisi do lɑɑlɔ si ɑwɔ bɛi ɑru ku bɑ i ceò lɑɑlɔ ŋɑ, nsɛi ì nɛ i so ikɔ̃i ɑrɑ nŋɛ fei i jɔ̀ ku jɛ ɑrui icɛ jiidɑ ku ce ŋɑu ŋɑ ku bɑ dɑɑ nŋɛ ku mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Wɑɑti iyi ì wɑɑ jɛ ɑrui dulum ŋɑ, ì yɑ jilɔɔ si i kù nɛ i ce mii iyi Ilɑɑɔ̃ wɑ tɔɔ ŋɛi. ");
INSERT INTO mkl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ribɑ yoomɑi ì yɑ bɑ ŋɑ wɑɑti bɛɛbɛ. Ribɑ iyi ì bɑ ŋɑu wɑ mu ŋɛ ɑnyɔ nsɛi, nɔ iri ku kpɑɛ ikui. ");
INSERT INTO mkl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ammɑ nsɛi ɑ̀ yɑ ŋɛ hɑi si ɑwɔi dulum ì bɑɑ ì jɛ ɑrui Ilɑɑɔ̃ ŋɑ, ribɑ nŋɛi í jɛ dɑɑ iyi í mɑ́, iri ku kpɑɛ mɔi í jɛ kuwɛɛ hɑi tɑ̃. ");
INSERT INTO mkl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ribɑi dulum nii í jɛ iku, ɑmmɑ ɑmuɑi Ilɑɑɔ̃i í jɛ kuwɛɛ iyi ci yɑ tɑ̃ nɑ ɑnu ɑkɑ̃ nwɑ iyi ɑ̀ ce do Jesu Kirisi Lɑfɛ̃ɛ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Iŋɛ inɛm ŋɑ, iŋɛ iyi ì mɑ̀ woodɑ ŋɑ, i kù mɑ̀ ŋɑ iyi woodɑ í nɛ ɡbuɡbɑ̃i si ɑmɑnɛ si wɑɑti iyi í wɛɛ si hunde nŋu ɑkɑ̃? ");
INSERT INTO mkl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Bɛɛbɛ mɔi ɑbo ɑ̀ so mɔkɔ í nɛ ku wɑ bi mɔkɔɛ si wɑɑti iyi mɔkɔu í wɛɛ. Ammɑ bii mɔkɔu í ku ɑbou í fitɑ hɑi si woodɑi njɛ ku so mbɛ. ");
INSERT INTO mkl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Nɑ nŋu, bii mɔkɔu í wɛɛ nɔ ɑbou í koo í so mɔkɔ mmu, ɑbo ɑ̀ ce sɑkɑrɑi ɑɑ kpoo. Ammɑ bii mɔkɔɛ í ku, í fitɑ si woodɑi njɛ ku soui. Wɑɑti bɛɛbɛ bii í so mɔkɔ mmu kù jɛ ɑ̀ ce sɑkɑrɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Bɛɛbɛ mɔi iŋɛ inɛm ŋɑ, ɑnu ɑkɑ̃ nŋɛ do Kirisi í jɔ̀ iŋɛ mɔ ì ku do nŋu ɑjɔ nɔ ì fitɑ hɑi si ɑwɔi woodɑ. Bɛbɛi ti inɛ mmui ì jɛ ŋɑ. Ti inɛ iyi í jĩ hɑi si bɑlɛui ì jɛ ŋɑ ku bɑ i so iso iyi í jɛ ti Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Wɑɑti iyi ɑ̀ wɛɛò dɑɑ nwo nwɑ ŋɑ wo, kɔdɛɛ lɑɑlɔ iyi woodɑ í dede si wɑ wɑ ce icɛ si ikɔ̃i ɑrɑ nwɑ ikɑ̃ ikɑ̃ fei nɔ wɑ bɔò wɑ bi iku. ");
INSERT INTO mkl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ammɑ nsɛi, si bɛi ɑ̀ ku si ɡɑ̃mɛi woodɑ, nŋu iyi wɑ mu wɑ wo bɛi ɑru, ɑ̀ fitɑ hɑi si ɑwɔɛ. Bɛbɛi ɑɑ kɑ yɔkɔ kɑ ceɑ Ilɑɑɔ̃ icɛ do dɑɑ titɔ̃ iyi í jɛ ti Hundeɛ, kɑɑ jɛ do dɑɑ nwo iyi í jɛ ti woodɑ. ");
INSERT INTO mkl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","To, bɛirei ɑɑ kɑ fɔ. Woodɑu dulum nii? Aɑwo, kù jɛ bɛɛbɛ. Ammɑ nɑ sɑɑbui woodɑui í jɔ̀ ǹ mɑ̀ dulum. Ntɔ ntɔ, n kɑɑ n mɑ̀ mɑ̀ kɔdɛɛ dulum nii wo bii woodɑ kù ni n mɑɑ̀ n ce kɔdɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Nɔ nɑ woodɑui dulum í bɑ kpɑ̃ɑ í bíim kɔdɛɛ ikɑ̃ ikɑ̃ fei, domi bii woodɑ kù wɛɛ dulum mɔ kɑɑ wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Tɑko wɑɑti iyi n kù mɑ̀ woodɑ, ǹ wɛɛ wo, ɑmmɑ wɑɑti iyi ǹ nɑ ǹ mɑ̀ woodɑ, dulum í dedei ");
INSERT INTO mkl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","nɔ ǹ ku. Bɛɛbɛi woodɑ iyi í nɛ ku jɔ̀ n nɛ kuwɛɛ, ǹ bɑ wee ikui í nɑɑm wɑ, ");
INSERT INTO mkl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","domi dulum í ceò woodɑ icɛ nɔ í wɑ inyii itĩm í kpɑm. ");
INSERT INTO mkl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ntɔ ntɔ woodɑ í mɑ́ nɔ ideɛ mɔ í mɑ́, í jɛ dee dee, í nɔ í sĩɑ. ");
INSERT INTO mkl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Debɛi mii jiidɑu í bɑɑ í jɛɛm kpɑ̃ɑi iku? Aɑwo, kù jɛ bɛɛbɛ. Dulum nii í kpɑm. Mii jiidɑi í so í nɑ í kpɑm do. Nŋui í jɔ̀ ɑ̀ yɔɔ iyi dulum í jɛ mii lɑɑlɔ do ntɔ nɔ í ɡɑɑbu í cɑɑ. ");
INSERT INTO mkl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ntɔi ɑ̀ mɑ̀ iyi woodɑi Ilɑɑɔ̃ ti Hundei, ɑmmɑ ɑmu ɑmɑnɛi iyi ɑ̀ tɑɑ dulum ǹ jɛ ɑruɛ. ");
INSERT INTO mkl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mii iyi ǹ wɑ n ce n ci yɑ n mɑ̀ yɑɑseɛ, domi mii iyi ǹ bi, n ci yɑ n ce nŋu, ɑmmɑ mii iyi ǹ cé, nŋui ǹ yɑ n ce. ");
INSERT INTO mkl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Bii ǹ wɑ n ce iyi n kù bi, ǹ jɛsi iyi woodɑ í sĩɑi. ");
INSERT INTO mkl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ammɑ bii bɛɛbɛi, kù jɛ ɑmui ǹ wɑ n coo mɑ́, dulum iyi í wɑ sim nii wɑ coo. ");
INSERT INTO mkl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ǹ mɑ̀ sɑ̃ɑ sɑ̃ɑ iyi mii jiidɑ kɑ̃mɑ kù wɑ sim, wɑɑtɔ dɑɑm nii ǹ wɑ n fɑ̃ɑ, domi wɑɑti kɑ̃mɑ fei idɔm í yɑ mɑɑ bi jiidɑ ku ce, ɑmmɑ kuceɛi n ci yɑ n yɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","N ci yɑ n ce jiidɑ iyi ǹ bi, í ɡbe lɑɑlɔ iyi n kù biu. ");
INSERT INTO mkl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Nɔ bii ǹ wɑ n ce iyi n kù bi, kù jɛ ɑ ni ɑmui ǹ wɑ n coo, dulum iyi í wɑ sim nii wɑ coo. ");
INSERT INTO mkl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","To, ǹ yɛ ide ɡɔ í wɛɛm. Nŋu wee. Wɑɑti iyi ǹ bi jiidɑ ku ce fei, lɑɑlɔi í yɑ mɑɑ mɑ́ sim. ");
INSERT INTO mkl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Si idɔm woodɑi Ilɑɑɔ̃ ku jirimɑ í dɔ̃, ");
INSERT INTO mkl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ɑmmɑ si kucei ikɔ̃ ikɔ̃i ɑrɑm fei ǹ wɑ n yɛ ide mmu ɡɔ iyi wɑ jɑ do lɑsɑbum, nɔ wɑ cem ɑrui dulum iyi í wɑ sim. ");
INSERT INTO mkl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ilu inɔ kufɔi ǹ jɛ. Yooi ɑ́ nyɑm hɑi si ɑwɔi ɑrɑ iyi wɑ bɔɔm ikuu ihɛ̃. ");
INSERT INTO mkl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ǹ wɑ n sɑɑbu Ilɑɑɔ̃ do sɑɑbui Jesu Kirisi Lɑfɛ̃ɛ nwɑ. Bɛɛbɛ mɔi, ǹ jɛ ɑrui woodɑi Ilɑɑɔ̃ si idɔm, ɑmmɑ si dɑɑm ǹ jɛ ɑrui ɡbuɡbɑ̃i dulum. ");
INSERT INTO mkl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nɑ nŋu, nsɛi Ilɑɑɔ̃ kɑɑ yɛ tɑɑlei inɛ ŋɑ iyi ɑ̀ nɛ ɑnu ɑkɑ̃ do Jesu Kirisi mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Hundei Ilɑɑɔ̃i í yɑ jɔ̀ inɛ ku bɑ kuwɛɛ nɑ sɑɑbui Jesu Kirisi, nɔ ɡbuɡbɑ̃i Hundeɛui í nyɑm hɑi si ɡbuɡbɑ̃i dulum do ti iku. ");
INSERT INTO mkl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mii iyi woodɑi Moizi kù yɔkɔ ku ce si nɑ iyi í jɔ̀ mɔnɡɔi ɑmɑnɛ ŋɑ í jɔ̀ woodɑu í kuɑ ɡbuɡbɑ̃, Ilɑɑɔ̃ í coo. Dulum iyi í wɑ si ɑrɑi ɑmɑnɛ, í kiitiɛ si wɑɑti iyi í jɔ̀ Amɑi nŋu tɑkɑɛ í so ɑrɑ iyi í jɔ ɑrɑi dulum dii ɑmɑnɛ ŋɑ, nɔ í bɔɔ wɑ ku nɑ ku jɛ kuwee nɑ dulum. ");
INSERT INTO mkl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ilɑɑɔ̃ í ce bɛɛbɛi ku bɑ isɛɛnɛ nwɑ ku jɛ dee dee si ide iyi woodɑu wɑ fɔ, ɑwɑ iyi ɑ kù wɑɑ nɛ si idɔɔbii ɑrɑ nwɑ, í ɡbe si idɔɔbii Hundei Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Inɛ ŋɑ iyi ɑ̀ wɑɑ nɛ si idɔɔbii ɑrɑ, lɑsɑbu nŋɑ fei si dɑɑi ɑrɑui í yɑ wɑ. Ammɑ inɛ ŋɑ iyi ɑ̀ wɑɑ nɛ si idɔɔbii Hundei Ilɑɑɔ̃, lɑsɑbu nŋɑ fei si mii iyi Hundeu í bii í yɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Inɛ iyi lɑsɑbuɛ fei í wɑ si idɔɔbii ɑrɑ, ikui ɑ́ jɛ iri ku kpɑɛ. Ammɑ inɛ iyi lɑsɑbuɛ í wɑ si mii iyi Hundei Ilɑɑɔ̃ í bi, lɑfɛ̃ɛ ɑ́ bɑ kuwɛɛ do lɑɑkɑi ku sũ. ");
INSERT INTO mkl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Inɛ ŋɑ mɔ iyi ɑ̀ wɑɑ too idɔɔbii ɑrɑ, ɑŋɑi ɑ̀ jɛ mbɛɛi Ilɑɑɔ̃ ŋɑ. A kù wɑɑ jirimɑ woodɑɛ, nɔ ɑ kɑɑ yɔkɔ mɔm. ");
INSERT INTO mkl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Inɛ ŋɑ iyi ɑ̀ wɑɑ too idɔɔbii ɑrɑ ɑ kɑɑ yɔkɔ ɑ ce iyi ɑ́ dɔ̃ɑ Ilɑɑɔ̃ si. ");
INSERT INTO mkl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ammɑ iŋɛ i kù wɑɑ too idɔɔbii ɑrɑ, ì wɑɑ nɛ ŋɑi bɛi Hunde í bi, iŋɛ iyi Hundei Ilɑɑɔ̃ í wɑ si ŋɛ. Inɛ iyi kù nɛ Hundei Kirisi, lɑfɛ̃ɛ kù jɛ ti Kirisi. ");
INSERT INTO mkl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Nɔ bii Kirisi í wɑ si ŋɛ, bɑɑ do iyi ɑrɑ nŋɛ í ku nɑ dulum fei, hunde nŋɛ ɑ́ mɑɑ wɛɛ domi ì jɛ dee dee si wɑjui Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ilɑɑɔ̃i í jĩ Jesu hɑi si bɑlɛ. Nɔ bii Hundei nŋu iyi í jĩ Kirisi hɑi si bɑlɛu í wɑ si ŋɛ ɑ́ nɑ ɑrɑ iku nŋɛ ŋɑu mɔ kuwɛɛ nɑ sɑɑbui Hundeɛ iyi í wɑ si ŋɛu. ");
INSERT INTO mkl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nɑ nŋu iŋɛ inɛm ŋɑ, Ilɑɑɔ̃i ɑ̀ nɛ kɑ sɑɑbu, kù jɛ ɑrɑ hee ɑrɑu ku tilɑsi wɑ kɑ ceò mii iyi í bi. ");
INSERT INTO mkl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ntɔ ntɔ, bii ì wɑɑ ce idɔɔbii ɑrɑ ɑɑ ku ŋɑ. Ammɑ bii ì jɔ̀ Hundei Ilɑɑɔ̃ í sobi ŋɛ í kpɑò kookoosui ɑrɑu ɑɑ nɛ kuwɛɛ ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","domi inɛ ŋɑ iyi Hundei Ilɑɑɔ̃ wɑ ɡbɑ̃ fei, ɑŋɑi ɑ̀ jɛ ɑmɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Hunde iyi Ilɑɑɔ̃ í mu nŋɛ kɑɑ ce ŋɛ ɑru, kɑɑ nɔ ku jɔ̀ njo ku mu ŋɛ mɑ́, ɑmmɑ Hundeu i ce ŋɛ ɑmɑi Ilɑɑɔ̃ ŋɑ, nɔ do sɑɑbuɛi ɑɑ kɑ yɔkɔ kɑ kpe Ilɑɑɔ̃, kɑ ni Bɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Hundei Ilɑɑɔ̃ tɑkɑɛ wɑ sɔ̃ hunde nwɑ iyi ɑ̀ jɛ ɑmɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","To, si bɛi ɑ̀ jɛ ɑmɑɛ ŋɑ, nŋui í jɔ̀ ɑ̀ nɛ bɑɑ si mii iyi í jilɛ nwɑ. Aɑ kɑ nɛ ikpɛ̃ do Kirisi ɑjɔ, domi bii ɑ̀ bɑɑ ijuukpɑ̃ɛ ku kpɛ̃, bɛɛbɛ mɔi ɑɑ kɑ bɑɑ ɑmboeɛ ku kpɛ̃ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ǹ mɑ̀ wɑhɑlɑi nsɛi nwɑu ihɛ̃ kù jɛ nkɑ̃mɑ do ɑmboe iyi Ilɑɑɔ̃ ɑ́ nɑ ku nyisi wɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Bɑɑ mii ŋɑ iyi Ilɑɑɔ̃ í tɑkɑ fei ɑ̀ wɑɑ deɡbe ɑjɔ nŋu do sɑɑsɑ, ɑjɔ si bii Ilɑɑɔ̃ ɑ́ jɔ̀ ɑ yɛ ɑmboeɛ si ɑmɑɛ ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","domi mii ŋɑ iyi í tɑkɑ fei ɑ̀ dɑ́si kpɑ̃ɑi nfe ku ce, kù jɛ nɑ idɔɔbii ɑŋɑ tɑkɑ nŋɑ, Ilɑɑɔ̃i í coo bɛɛbɛ. Do nŋu fei, kpɑ̃ɑ ku cɔu mɔ í wɛɛ ");
INSERT INTO mkl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","iyi Ilɑɑɔ̃ ɑ́ yɑ mii ŋɑu mɔ ku bɑ kɑ̃mɑ nŋɑ ku mɑɑ̀ bɛjɛ mɑ́ nɔ ɑ nɛ ikpɛ̃ si ɑmboei ɑrɑ ku nɛi ɑmɑi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","À mɑ̀ iyi hee nsɛi mii ŋɑ iyi Ilɑɑɔ̃ í tɑkɑ fei ɑ̀ wɑɑ kɑkɑɑi bɛi inɑɑbo iyi wɑ kɑkɑɑ do ɑrɑ kuroi kubí. ");
INSERT INTO mkl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Nɔ iyi í re mɔm, bɑɑ ɑwɑ iyi Ilɑɑɔ̃ í mu nwɑ Hundeɛ bɛi fiɑi kɑɑziɡi, ɑ̀ wɑɑ kɑkɑɑ si idɔ nwɑ ɑ̀ wɑɑ deɡbeò Ilɑɑɔ̃ ku nyisi iyi ɑ̀ jɛ ɑmɑɛ ŋɑ ntɔ ntɔ nɔ ku fɑɑbɑ ɑrɑ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Fɑɑbɑu í jɛ tu wɑ, ɑmmɑ si kpɑ̃ɑɛ ku cɔi ɑ̀ wɑ si titɑ̃. Bii ɑ̀ yɛ mii iyi ɑ̀ wɑɑ deɡbe, kudeɡbe kù wɛɛ mɑ́. Mii iyi ɑmɑnɛ wɑ yɛ ɑ́ mɑɑ cɔ kpɑ̃ɑɛ mɑ́? ");
INSERT INTO mkl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ammɑ bii ɑ̀ wɑɑ cɔ kpɑ̃ɑi mii ɡɔ iyi ɑ kù wɑɑ yɛ, ɑɑ kɑ mɑɑ deɡbeɛi do temuɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Bɛɛbɛ mɔi Hundei Ilɑɑɔ̃ í yɑ mɑɑ sobi wɑ si ɡbuɡbɑ̃ hɑi nɛ nwɑ, domi ɑ ci yɑ kɑ mɑ̀ mii iyi í sĩɑ kɑ tɔɔ. Ammɑ Hundeu tɑkɑɛi í yɑ tɔɔ Ilɑɑɔ̃ nɑ iri nwɑ do ide iyi í re ide ku fɔi ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Nɔ Ilɑɑɔ̃, nŋu iyi wɑ yɛ idɔi ɑmɑnɛ ŋɑ í mɑ̀ mii iyi Hundeu wɑ lɑsɑbu, domi do idɔɔbiɛi Hundeu wɑ tɔɔɛ nɑ irii inɛ ŋɑ iyi ɑ̀ jɛ tɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Nɔ iyi í re mɔm, ɑ̀ mɑ̀ sɑ̃ɑ sɑ̃ɑ, inɛ ŋɑ iyi ɑ̀ bi Ilɑɑɔ̃, ɑŋɑ iyi í kpe si idɔɔbiɛ ɑ̀ jɛ tɛɛ, Ilɑɑɔ̃ wɑ ce icɛ si mii iyi í bɑ ŋɑ fei ku bɑ ku ce nŋɑ jiidɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ntɔ ntɔ, inɛ ŋɑ iyi Ilɑɑɔ̃ í cicɑ hɑi tɑko, ɑŋɑi í jilɛ ku bɑ ɑ jɔ Amɑɛ. Si bɛɛbɛ Amɑɛui ɑ́ jɛ yemmɑi ifɔ nkpɔ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Inɛ ŋɑ iyi í cicɑ í jilɛu, nŋui í kpe ŋɑ. Inɛ ŋɑ iyi í kpeu í ce ŋɑ dee dee. Inɛ ŋɑ iyi í ce dee deeu í ce nŋɑ ikpɛ̃i ɑmboeɛ. ");
INSERT INTO mkl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Debɛi bɛirei ɑɑ kɑ fɔ mɑ́. Bii Ilɑɑɔ̃ í jɛ tu wɑ, yooi ɑ́ yɔkɔ ku jɛ mbɛɛ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ilɑɑɔ̃ kù kɔò ɑmɑi nŋu tɑkɑɛ, ɑmmɑ í jɔ̀ ɑ̀ dɑɑ inɛ ŋɑ si ɑwɔ ɑ̀ kpɑɑ nɑ irii ɑwɑ fei. Nŋu iyi í nɑ wɑ ɑmɑɛu bɛɛbɛ, bɛirei ɑ́ ce iyi kù mu nwɑ mii iyi í ɡbe fei. ");
INSERT INTO mkl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Inɛ ŋɑ iyi Ilɑɑɔ̃ í cicɑ, yooi ɑ́ yɔkɔ ku mɑ́ ŋɑ dulum mɑ́. Kù wɛɛ, domi Ilɑɑɔ̃i í ce ŋɑ dee dee. ");
INSERT INTO mkl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","To, yooi ɑ́ yɔkɔ ku yɛ tɑɑle nŋɑ. Kù wɛɛ, domi Jesu Kirisi í ku, nɔ iyi í re mɔm í jĩ hɑi si bɑlɛ mɑ́, í wɑ ɑwɔ njɛi Ilɑɑɔ̃. Í nɔ wɑ tɔɔ Ilɑɑɔ̃ nɑ iri nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Yooi ɑ́ yɔkɔ ku fɛɛfɛ wɑ do kubii Kirisi. Tɔnyɑ? Mɑ̀ wɑhɑlɑ. Mɑ̀ ijuukpɑ̃. Mɑ̀ ɑri. Mɑ̀ ɑre. Mɑ̀ mbirisi. Mɑ̀ iɡũ. ");
INSERT INTO mkl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ntɔ ntɔ, Lɑfɛ̃ɛ, nɑ iriɛi ɑ̀ yɑ kɑ wɑ si ɑnui iku ɑlɛò dɑɑkɔ. À wɑɑ cɔ wɑ bɛi ɑnɡudɑ̃ ŋɑ iyi ɑ̀ wɑɑ bɔ ku sɑkɑ, si bɛi kukɔi idei Ilɑɑɔ̃ í fɔ. ");
INSERT INTO mkl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ammɑ si mii ŋɑu ihɛ̃ fei ɑ̀ jɛ iɡũ mɑm mɑm nɑ sɑɑbui Kirisi iyi í bi wɑ, ");
INSERT INTO mkl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","domi ǹ mɑ̀ kɑm kɑm, nkɑ̃mɑ kù wɛɛ iyi ɑ́ yɔkɔ ku fɛɛfɛ wɑ do kubiɛ. Bɑɑ iku kɑɑ yɔkɔ, wɑlɑ kuwɛɛ, do ɑmɑlekɑ ŋɑ, do yiikoi lele ŋɑ. Mii iyi í bɑ wɑ nnyi hee do iyi ɑ́ nɑ ku bɑ wɑ ɑlɑ fei, kɑ̃mɑ nŋɑ kɑɑ yɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Mii ŋɑ iyi ɑ̀ wɑ lele do iyi ɑ̀ wɑ ilɛ hee do mii iyi ɑ̀ tɑkɑ fei, nkɑ̃mɑ kɑɑ yɔkɔ ku fɛɛfɛ wɑ do kubi iyi Ilɑɑɔ̃ í nyisi wɑ si Jesu Kirisi Lɑfɛ̃ɛ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ntɔi ǹ wɑ n fɔ, ɑmu inɛi Kirisi, n kɑɑ n sɔ ibo. Idɔm do Hundei Ilɑɑɔ̃ ɑ̀ jɛsi iyi ntɔi. ");
INSERT INTO mkl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Inɔm í fɔ ntɔ ntɔ nɑ Zuifu kpɑɑsi ŋɑ nɔ ǹ yɑ n mɑɑ n ce ɑrɑɑre nŋɑ wɑɑti kɑ̃mɑ fei. ");
INSERT INTO mkl_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","An jɛsi Ilɑɑɔ̃ ku ceekpem nɔ ku fɛɛfɛɛm do Kirisi ku bɑ inɛ ŋɑ iyi ɑ̀ jɛ dimim ɑ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Aŋɑi ɑ̀ jɛ inɛi Izirɛli ŋɑ, inɛ ŋɑ iyi Ilɑɑɔ̃ í cicɑ ɑ jɛ tɛɛ bɛi ɑmɑɛ ŋɑ, nɔ í nyisi ŋɑ ɑmboeɛ. Do ɑŋɑi í dĩ ɑkɑbuuɛ ŋɑ, nɔ í nɑ ŋɑ woodɑ do kpɑ̃ɑɛ ku tɔɔ, do idei kuwɑ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Bɑlɑ nŋɑ ŋɑi ɑ̀ jɛ inɛi Ilɑɑɔ̃ ŋɑ. Si dimi nŋɑi Kirisi í fitɑ bɛi ɑmɑnɛ nŋu iyi í re mii fei. Nŋui í jɛ Ilɑɑɔ̃, nŋu iyi í jɔ kɑ mɑɑ sɑɑbu hee do ɑjɔ fei. Ami. ");
INSERT INTO mkl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Kù jɛ ǹ wɑ n ni ide iyi Ilɑɑɔ̃ í wɑ̃u í jɛ nɡbɛ, ɑmmɑ kù jɛ inɛ ŋɑ iyi ɑ̀ bí si dimii inɛi Izirɛli ŋɑu feii ɑ̀ jɛ inɛi Izirɛli do ntɔ. ");
INSERT INTO mkl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Kù nɔ kù jɛ inɛ ŋɑ iyi ɑ̀ bí si dimii Aburɑhɑmu feii ɑ̀ jɛ tɔkuɛ ŋɑ do ntɔ, domi Ilɑɑɔ̃ í sɔ̃ Aburɑhɑmu í ni, dimii ɑmɑi Izɑɑki ŋɑi ɑɑ jɛ tɔkuɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Wɑɑtɔ kù jɛ ɑmɑi Aburɑhɑmu ŋɑ feii ɑ̀ jɛ ɑmɑi Ilɑɑɔ̃ ŋɑ, í ɡbe ɑmu ŋɑ ŋɑ iyi Ilɑɑɔ̃ í ceɑ kuwɑ̃ɛ ŋɑu, ɑŋɑ ɑkɑ̃. ");
INSERT INTO mkl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ide iyi Ilɑɑɔ̃ í wɑ̃ò Aburɑhɑmu wee, í ni, ɑdɔ̃ ɡɔ suku bɛ iyi ihɛ̃ ɑn nyi wɑ mɑ́, hee wɑɑti bɛɛbɛ Sɑrɑ ɑ́ bí ɑmɑ inɛmɔkɔ. ");
INSERT INTO mkl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Kù jɛ iyi bɛ nŋu ɑkɑ̃, ɑmɑi Rebɛkɑ minji ŋɑu fei sikɑ ŋɑi. Bɑɑ nŋɑi í jɛ bɑlɑ nwɑ Izɑɑki. ");
INSERT INTO mkl_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Ammɑ do nŋu fei, hee Rebekɑ ku mɑɑ bí ŋɑ, si wɑɑti iyi ɑ kù ce jiidɑ ɡɔ titɑ̃ hee mɑ́ jɛ lɑɑlɔ, Ilɑɑɔ̃ í sɔ̃ Rebekɑ í ni, inɛ sintei ɑ́ yɑ sũɑ inɛ ɑnkɑ̃ɑnyiu iri ilɛ. Í fɔ bɛɛbɛi ku bɑ ku nyisi iyi nŋu í yɑ cicɑ inɛ ŋɑi bɛi nŋu tɑkɑi nŋu í bi, nɔ í kpe ŋɑ si bɛi nŋu tɑkɑɛ í jilɛ, kù jɛ nɑ kuce nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Tiɑi idei Ilɑɑɔ̃ í fɔ mɑ́ í ni, Ilɑɑɔ̃ í ni, ǹ bi Zɑkɔbu nɔ ǹ cé Ezɑu. ");
INSERT INTO mkl_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Debɛi, bɛirei ɑɑ kɑ fɔ nsɛi. Ilɑɑɔ̃ kù jɛ dee deei? Aɑwo, kù jɛ bɛɛbɛ, ");
INSERT INTO mkl_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","domi í sɔ̃ Moizi í ni, inɛ iyi ǹ bii ɑn ceɑ didɔ̃, nɔ inɛ iyi ǹ bii ɑn ce ɑrɑɑreɛ. ");
INSERT INTO mkl_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Nɑ nŋu, kù jɛ nɑ idɔɔbii inɛ ɡɔ, kù nɔ kù jɛ nɑ kookɑɑi inɛ ɡɔ, ɑmmɑ nɑ ɑrɑɑrei Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Bɛɛbɛi kukɔi idei Ilɑɑɔ̃ wɑ fɔ idei Fɑrɑɔ̃, nŋu iyi Ilɑɑɔ̃ í le idɔɛ í ni n kɑ̃ n ceɛ ilɑɑlui ku bɑ inɛ ŋɑ ɑ yɛ ɡbuɡbɑ̃m siɛ, nɔ inɛi ɑndunyɑ fei ku ɡbɔ irim. ");
INSERT INTO mkl_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Bɛɛbɛi Ilɑɑɔ̃ í yɑ ce ɑrɑɑrei inɛ iyi í bi, nɔ ku le idɔi inɛ mɔ iyi í bi. ");
INSERT INTO mkl_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Bii bɛɛbɛi, inɛ ɡɔ ɑ́ yɔkɔ ku sɔ̃m ku ni, Ilɑɑɔ̃ kù nɛ kpɑ̃ɑ ku yɛ tɑɑlei ɑmɑnɛ ŋɑ mɑ́, domi inɛ kɑ̃mɑ kɑɑ yɔkɔ ku dede si mii iyi í jilɛ. ");
INSERT INTO mkl_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Awɔ iyi ì wɑɑ fɔ bɛɛbɛ, yooi ì jɛ i bɛi i kɑkɔɔ Ilɑɑɔ̃. Cɑkɑ ɑ́ yɔkɔ ku bee woo mɑ ku ni, nɑ mii í ce ì mɑm bɛ ihɛ̃? ");
INSERT INTO mkl_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Kù jɛ woo mɑ cɑkɑi ɑ́ ceò ɑmɑ bɛi í bi bɑ. Si ɑmɑ ɑkɑ̃u bɛ kɑɑ yɔkɔ ku ce cɑjɑ iyi ɑ̀ yɑ mɑɑ ceò icɛ wɑɑti kɑ̃mɑ fei do cɑkɑ iyi í nɛ bɛɛrɛ í re bɑ. ");
INSERT INTO mkl_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","To, yɑɑseu bɛ wɑ nyisi mii iyi Ilɑɑɔ̃ í ce. Í bi ku nyisi inɛ ɡɔ ŋɑ idɔɔkɔ̃ nlɑɛ do ɡbuɡbɑ̃ɛ. Ammɑ í temuɑi titɑ̃ do inɛ ŋɑ iyi idɔɛ í kɔ̃ siu, ɑŋɑ iyi ɑ̀ yɛ bɛi cɑkɑ ŋɑ iyi ɑɑ nyɔu. ");
INSERT INTO mkl_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ammɑ í bi ku nyisi inɛ ɡɔ ŋɑ mɔ bɛi ɑmboeɛ í lɑ í to. Aŋɑi í ce ɑrɑɑre nŋɑ nɔ í ce sɔɔlu nŋɑ hɑi ku kpɛ ɑ nɛ ikpɛ̃ si ɑmboeɛ. ");
INSERT INTO mkl_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Inɛ ŋɑu ɑwɑi. Si inɔ nwɑ Zuifu ŋɑ do hɑi jɛ Zuifu ŋɑ ɑ̀ wɑsi. Ilɑɑɔ̃i í kpe ɑwɑ fei. ");
INSERT INTO mkl_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Bɛɛbɛi wɑlii Ozee í fɔ si tiɑɛ í ni, Ilɑɑɔ̃ í ni, Inɛ ŋɑ iyi ɑ kù jɛ tom wo, nsɛi ɑn kpe ŋɑ inɛm. Dimi ŋɑ iyi n kù bi wo, nsɛi ɑn kpe ŋɑ bɑɑkɔɔm ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Nɔ tenɡi bii ǹ sɔ̃ ŋɑ wo ǹ ni, i kù jɛ inɛm ŋɑ, Bɛ mɔi ɑn kpe ŋɑ mɑ́ ɑmɑm ŋɑ, ɑmu iyi ǹ jɛ irii kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ŋɔi wɑlii Ezɑi í fɔ ide hee lele nɑ irii inɛi Izirɛli ŋɑ í ni, bɑɑ bii inɛi Izirɛli ŋɑu ɑ̀ kpɔ bɛi sɑ̃ɑi ɑcĩi ido, inɛ mbɔi ɑ́ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ide iyi Ilɑɑɔ̃ í fɔu ɑ́ kɔ̃i mɑm mɑm si ɑndunyɑu, nɔ kɑɑ kpɛ mɔm. ");
INSERT INTO mkl_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Í yɛ mbɛ bɛi wɑlii Ezɑi í tɑko í fɔu iyi í ni, Bii Aɔ̃ Lɑfɛ̃ɛ, ilu ɡbuɡbɑ̃ fei kù jɔ̀ nwɑ fiti mbɔi ɑmɑnɛ ŋɑ wo ni, Awɑ fei ɑɑ kɑ kui wo bɛi inɛi Sodomu ŋɑ, Do inɛi Gɔmɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Debɛi, bɛirei ɑɑ kɑ fɔ. Bɛi ɑɑ kɑ fɔ wee, dimi mmu ŋɑ iyi ɑ kù wɑɑ dɛ ɑ̀ jɛ dee dee si wɑjui Ilɑɑɔ̃ wo, nsɛi ɑ̀ jɛ dee dee nɑ sɑɑbui nɑɑnɛ ku dɑsi nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ammɑ inɛi Izirɛli ŋɑ iyi ɑ̀ wɑɑ dɛ ɑŋɑ ɑ too woodɑ ku bɑ ɑŋɑ ɑ jɛ dee dee si wɑjui Ilɑɑɔ̃, kù ce. ");
INSERT INTO mkl_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Nɑ mii. Si nɑ iyi í jɔ̀ inɛi Izirɛli ŋɑ ɑ kù dɛdɛɛ do nɑɑnɛ ku dɑsi, í ɡbe do icɛ nŋɑ. À koosɛ si kutɑ iyi í yɑ jɔ̀ inɛ ŋɑ ɑ koosɛu. ");
INSERT INTO mkl_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Ideɛi kukɔu wɑ fɑ̃ɑ í ni, Wee ǹ wɑ n jilɛ inɛ ɡɔ Siɔ̃ɔ iyi í yɛ bɛi kutɑ bi ku koosɛ. Nŋui ɑ́ jɔ̀ inɛ ɡɔ ŋɑ ɑ cuku, Ammɑ inɛ iyi í dɑsiɛ nɑɑnɛ kɑɑ yɛ ɑnyɔ. ");
INSERT INTO mkl_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Iŋɛ inɛm ŋɑ, iyi ǹ bi si idɔm fei do iyi ǹ wɑ n tɔɔ Ilɑɑɔ̃, nŋui í jɛ dimim ŋɑ ɑ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ntɔ ntɔ, ɑn yɔkɔ n fɔ nɑ iri nŋɑ n ni ɑ̀ wɑɑ ceɑ Ilɑɑɔ̃ icɛ do himmɑ, ɑmmɑ ɑ kù nɛ kumɑ̀. ");
INSERT INTO mkl_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","A kù mɑ̀ bɛi Ilɑɑɔ̃ í yɑ ceò inɛ dee dee, nŋui í jɔ̀ ɑ̀ dɛ kpɑ̃ɑ nŋɑ bɛi ɑɑ ce ɑ jɛò dee dee, nɔ ɑ kù wɑɑ too si kpɑ̃ɑ iyi Ilɑɑɔ̃ í jilɛ. ");
INSERT INTO mkl_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kpɑ̃ɑ iyi Ilɑɑɔ̃ í jilɛui í jɛ Kirisi iyi í nɑ í kpɑ irii woodɑi Moizi nɔ inɛ iyi í dɑsiɛ nɑɑnɛu fei ɑ́ jɛ dee dee si wɑjui Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Ide iyi Moizi í kɔ si yɑɑse bɛi inɛ ɑ́ jɛò dee dee si wɑjui Ilɑɑɔ̃ si woodɑ ku jirimɑ wee. Inɛ iyi wɑ jirimɑ woodɑ ŋɑu fei, si nŋui ɑ́ bɑ kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ammɑ ide iyi ɑ̀ kɔ si yɑɑse bɛi ɑmɑnɛ ɑ́ jɛò dee dee nɑ nɑɑnɛ ku dɑsi wee. Mɑɑ̀ ti i fɔ si idɔɛ i ni, yooi ɑ́ bɔ lelei Aɔ̃. Bii ì wɑɑ fɔ bɛɛbɛ, í yɛ bɛi ì wɑɑ dɛ Kirisi ku kitɑ wɑi. ");
INSERT INTO mkl_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Nɔ i mɑɑ̀ ti i fɔ i ni, yooi ɑ́ lɔ lɛlɛi ilɛ. Bii ì wɑɑ fɔ bɛɛbɛ, í yɛ bɛi ì wɑɑ dɛ ku dede Kirisi hɑi si bɑlɛ mɑ́i. ");
INSERT INTO mkl_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Debɛi, bɛirei ideu wɑ fɔ. Bɛi wɑ fɔ wee. Ide iyi ì wɑɑ dɛdɛu kù jĩiɛ, í wɑ si ɡɛlɛɛ mɔm do si idɔɛ. Ideu nŋui í jɛ idei nɑɑnɛ ku dɑsi iyi ɑ̀ wɑɑ wɑɑzo, iyi í ni, ");
INSERT INTO mkl_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","bii ì fɔ do ɡɛlɛɛ ì ni Jesui í jɛ Lɑfɛ̃ɛ, nɔ ì dɑsi nɑɑnɛ si idɔɛ iyi Ilɑɑɔ̃ í dedeɛ hɑi si bɑlɛ, ɑɑ bɑ fɑɑbɑ, ");
INSERT INTO mkl_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","domi do idɔi ɑmɑnɛ í yɑ dɑsiò nɑɑnɛ ku bɑ ku jɛ dee dee si wɑjui Ilɑɑɔ̃, nɔ do ɡɛlɛ mɔi í yɑ fɔò ide ku bɑ ku bɑò fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Tiɑi idei Ilɑɑɔ̃ í nɔ í fɔ í ni, inɛ iyi í dɑsiɛ nɑɑnɛ fei kɑɑ yɛ ɑnyɔ. ");
INSERT INTO mkl_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Bɛɛbɛi inɛ ɡɔ kù jɛ ikɑ̃, hɑi Zuifu ŋɑ hee ku bɔ do dimi mmu ŋɑ fei. Aŋɑ fei Lɑfɛ̃ɛ ɑkɑ̃i ɑ̀ nɛ. Amɑniɛ mɔ í jɛ ti inɛ ŋɑ iyi ɑ̀ wɑɑ tɔɔɛ fei. ");
INSERT INTO mkl_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Debɛi inɛ iyi wɑ tɔɔ Aɔ̃ Lɑfɛ̃ɛ fei ɑ́ bɑ fɑɑbɑ, si bɛi idei Ilɑɑɔ̃ í fɔ. ");
INSERT INTO mkl_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Nɔ bɛirei inɛ ŋɑ ɑɑ ce ɑ tɔɔɛ bii ɑ kù dɑsiɛ nɑɑnɛ. Mɑ̀ bɛirei ɑɑ ce ɑ dɑsiɛ nɑɑnɛ bii ɑ kù ɡbɔ ideɛ. Nɔ bɛirei ɑɑ ce ɑ ɡbɔ ideɛ bii inɛ ɡɔ kù ce wɑɑzoi ideu. ");
INSERT INTO mkl_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Nɔ bɛirei ɑɑ ce ɑ ce wɑɑzoi ideu bii kù jɛ inɛ ɡɔi í bɛ ŋɑ. Kukɔi idei Ilɑɑɔ̃ wɑ fɔ í ni, inɔ didɔ̃ nlɑi kunɑɑi inɛ ŋɑ iyi ɑ̀ dɑbii ɑ̀ wɑɑ sisi lɑɑbɑɑu jiidɑu. ");
INSERT INTO mkl_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ammɑ kù jɛ inɛ feii í jɛsi idei lɑɑbɑɑu jiidɑu. Bɛɛbɛi wɑlii Ezɑi mɔ í fɔ í ni, Lɑfɛ̃ɛ, yoo ŋɑi ɑ̀ dɑsi wɑɑzo nwɑu nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Bɛɛbɛ mɔi nɑɑnɛ ku dɑsi wɑ nɑɑi hɑi si ide iyi inɛ wɑ ɡbɔ. Nɔ ide iyi ɑ̀ wɑɑ ɡbɔu idei Kirisii. ");
INSERT INTO mkl_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ammɑ ǹ wɑ n beei, Zuifu ŋɑ ɑ kù ɡbɔ ideui? À ɡbɔɔ, domi ɑ̀ kɔɔ ɑ̀ ni, Woo ce wɑɑzo ŋɑu ɑ̀ dɑbii si ɑndunyɑ fei Nɔ inɛ fei í ɡbɔ ide nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","To, ǹ wɑ n bee mɑ́, inɛi Izirɛli ŋɑ ɑ kù ɡbɔ yɑɑsei ideu bɑ. À ɡbɔɔ, si bɛi Moizi í tɑko í kɔ nɑ iri nŋɑ í ni, Ilɑɑɔ̃ í ni, An dede iɡu nŋɛ do dimi ɡɔ iyi ɑ kù wɑɑ sɑɑlu bɛi dimi, Nɔ n dede idɔɔkɔ̃ nŋɛ do dimi hɑi nɛ bisi. ");
INSERT INTO mkl_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ezɑi mɔ í kɔ do wɔɔkɔ í ni, Ilɑɑɔ̃ í ni, Inɛ ŋɑ iyi ɑ kù wɑɑ dɛdɛɛm ŋɑi ɑ̀ yɛm, Nɔ ǹ nyisi ŋɑ ɑrɑm, kù nɔ kù jɛ ɑŋɑi ɑ̀ tɔɔm. ");
INSERT INTO mkl_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ammɑ si ɡɑ̃mɛi irii inɛi Izirɛli ŋɑ í kɔ í ni, Ilɑɑɔ̃ í ni, hɑi dɑɑkɔi ǹ to ɑwɔ bi hɑi ɡbɔ ide ilu itĩ ku yikɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Debɛi ǹ wɑ n beei, Ilɑɑɔ̃ í kɔsi inɛɛ ŋɑi? Aɑwo, kù jɛ bɛɛbɛ, domi ɑmu tɑkɑm inɛi Izirɛlii ǹ wɑ n jɛ, ǹ jɛ tɔkui Aburɑhɑmu si dimii Bɛnzɑmɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ilɑɑɔ̃ kù kɔsi inɛɛ ŋɑ iyi í tɑko í cicɑ hɑi kukpɛu. Mɑ̀ i kù mɑ̀ ŋɑ bɛi kukɔi idei Ilɑɑɔ̃ í fɔ ŋɑ si wɑɑti iyi Elii í bɔò tɑɑlei inɛi Izirɛli ŋɑ bi Ilɑɑɔ̃ í ni, ");
INSERT INTO mkl_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Lɑfɛ̃ɛ, inɛ ŋɑu ɑ̀ kpɑ wɑliiɛ ŋɑ nɔ ɑ̀ kɛkɛ bi kuweeɛ ŋɑ. Amu ɑkɑ̃i ǹ ɡbe iyi ǹ wɑ n jirimɑɛ, ɑ̀ nɔ ɑ̀ wɑɑ dɛ hundem ku nyɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ammɑ Ilɑɑɔ̃ í jɛɑɑ í ni, ǹ nɛ ɑmɑnɛ dubu mɛɛje mɑ́ iyi ɑ kù ɡulɛ si wɑjui iwɛ̃ iyi ɑ̀ yɑ kpe Bɑɑli. ");
INSERT INTO mkl_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Bɛɛbɛ mɔi, bɑɑ nsɛi inɛi Izirɛli mbɔ ŋɑ ɑ̀ wɑɑ jirimɑ Ilɑɑɔ̃, ɑŋɑ iyi í cicɑ nɑ didɔ̃ɛu. ");
INSERT INTO mkl_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Í cicɑ ŋɑi nɑ didɔ̃ɛ, kù jɛ nɑ icɛ. Bii í jɛ do icɛui, didɔ̃u kù jɛ didɔ̃ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ntɔ ntɔ bɛirei í ce. Inɛi Izirɛli ŋɑ ɑ kù bɑ mii iyi ɑ̀ wɑɑ dɛ. Si inɔ nŋɑ inɛ ŋɑ iyi Ilɑɑɔ̃ í cicɑi ɑ̀ bɑɑ. Inɛ ŋɑ iyi ɑ̀ ɡbe ɑ̀ lele idɔ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Nɑ irii nŋɑi kukɔi idei Ilɑɑɔ̃ í ni, Ilɑɑɔ̃ í dɑ nŋɑ si sisi njoo si idɔ. Nɔ í mu nŋɑ iju iyi ɑ kɑɑ yɔkɔ ɑ yɛò ilu. Nɔ í mu nŋɑ itĩ iyi ɑ kɑɑ yɔkɔ ɑ ɡbɔò ide hee do nnyi fei. ");
INSERT INTO mkl_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Nɔ Dɑvidi mɔ í ni, Jinɡɑu nŋɑ ku jɛ nŋɑ cɛkũm do tɑɑo, Nɔ ku nyi ku jɛ nŋɑ bi ku koosɛ mɑ́ Ku bɑ ɑ koo ɑ bɑ ijuukpɑ̃. ");
INSERT INTO mkl_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Jɔ̀ ilu kuku ku wɑ si iju nŋɑ ɑ mɑɑ̀ yɛ ilu. Nɔ i jɔ̀ ɑ yɑ bɑte ɑ mɑɑ ceò icɛ do ɑjɔ fei. ");
INSERT INTO mkl_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ŋɔi í jɔ̀ ǹ wɑ n bee, si wɑɑti iyi inɛi Izirɛli ŋɑ ɑ̀ koosɛ, ɑ̀ cukui hee do ɑjɔ fei? Aɑwo, kù jɛ bɛɛbɛ. Ammɑ nɑ kucuku nŋɑi í jɔ̀ dimi mmu ŋɑu mɔ ɑ̀ bɑò fɑɑbɑ ku bɑ iɡu nŋɑ ku dede si ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Debɛi, si bɛi kucukui inɛi Izirɛli ŋɑ í jɔ̀ hɑi jɛ Zuifu ŋɑ ɑ̀ bɑ ɑmɑnii Hunde, nɔ kukɑyei inɛi Izirɛli ŋɑ í kɔ̃ɔsi ɑmɑnii dimi mmu ŋɑ, zɑkɑ bɛirei ɑmɑnii dimi mmu ŋɑu ɑ́ lɑ ku to wɑɑti iyi inɛi Izirɛli ŋɑ fei ɑɑ nɑ ɑ bɑ kpɑ̃ɑi fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Iŋɛ dimi mmu ŋɑu bɛ, iŋɛi ǹ wɑ n bɑ ide ku fɔ, ɑmu iyi ǹ jɛ woo bɛ bi tu ŋɛ. Ǹ yɑ n mɑɑ nɛ inɔ didɔ̃i do icɛm iyi ǹ wɑ n ce. ");
INSERT INTO mkl_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Si icɛu bɛi ǹ wɑ n dɛ kpɑ̃ɑ n dedeò iɡui dimim ŋɑ, ku bɑ inɛ ɡɔ nŋɑ ŋɑ ɑ bɑ fɑɑbɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ilɑɑɔ̃ í jɔ̀ hɑi jɛ Zuifu ŋɑ ɑ̀ dɔ̃ do nŋu si wɑɑti iyi í jɔ̀ Zuifu ŋɑ titɑ̃. Debɛi, bɛirei ɑ́ yɛ si wɑɑti iyi ɑ́ ɡbɑ ŋɑ mɑ́. Nŋu bɛi ɑ́ jɔ̀ ɑŋɑ iyi ɑ̀ ku wo ɑ bɑɑ si kuwɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Si iyɑfũi pɛ̃ɛ iyi ɑ̀ kpo, bii pɛ̃ɛ sinte iyi ɑ̀ ceu í jɛ ti Ilɑɑɔ̃, debɛi pɛ̃ɛu fei ti Ilɑɑɔ̃i. Bɛɛbɛ mɔi bii icɑ̃i jĩi í jɛ ti Ilɑɑɔ̃, do ɑmɑɑwɔɛ ŋɑ fei ti Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ammɑ nsɛi ɑ̀ cɑfe ɑmɑɑwɔ ɡɔ ŋɑ hɑi si jĩi ndii olivi, nɔ iŋɛ iyi ì jɛ ɑmɑɑwɔi jĩi ndii sɑko, iŋɛi ɑ̀ sɑ̃si ɑɡbɛ nŋɑ. Nsɛi wee, iŋɛ mɔ ì wɑɑ bɑ inyi iyi wɑ nɑɑ si ɑmɑɑwɔ ŋɑu hɑi si icɑ̃u. ");
INSERT INTO mkl_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Nɑ nŋu, i mɑɑ̀ tɔɔ fufu ŋɑ si ɑmɑɑwɔ ŋɑ iyi ɑ̀ cɑfeu. Bɛirei ɑɑ ce i tɔɔ fufu ŋɑ. I jɔ̀ i mɑ̀ ŋɑ iyi kù jɛ iŋɛi ì wɑɑ mu icɑ̃u, icɑ̃u njɛi wɑ mu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Inɛ ɑkɑ̃ nŋɛ ɡɔ ɑ́ ni, ɑ̀ cɑfe ɑmɑɑwɔ ŋɑu bɛi ku bɑ ɑ sɑ̃sim si ɑɡbɛ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ntɔi, ɑ̀ dɑ ŋɑi nɑ nɑɑnɛ hɑi dɑsi nŋɑ, nɔ ɑwɔ mɔ ì wɑ ɑɡbɛu bɛi nɑ nɑɑnɛ ku dɑsiɛ. Mɑɑ̀ tɔɔ fufu, ɑmmɑ ce njo, ");
INSERT INTO mkl_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","domi bii Ilɑɑɔ̃ kù jɔ̀ ɑmɑɑwɔ sinte ŋɑu, ɑ́ nɑ ku jɔ̀ ɑwɔ mɔ? ");
INSERT INTO mkl_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Debɛi, cɔ jiidɑ ku jɛi Ilɑɑɔ̃ do kuɡɑɑbuɛ. Í ɡɑɑbu si inɛ ŋɑ iyi ɑ̀ cuku, ɑmmɑ í jɛ inɛ jiidɑ bi tɛɛ. Awɔ de leekĩ dim dim si jiidɑ ku jɛɛ. Bii kù jɛ bɛɛbɛ ɑɑ dɑ ɑwɔ tɑkɑɛ. ");
INSERT INTO mkl_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Bii ɑŋɑ mɔ ɑ kù mɔsi idɔ ku lele nŋɑ, Ilɑɑɔ̃ ɑ́ sindo ŋɑ si ɑɡbɛ bii ɑ̀ wɑu wo, domi ɑ́ yɔkɔ ku sindo ŋɑ si ɑɡbɛ nŋɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Bii Ilɑɑɔ̃ í dɑɛ wɑ hɑi si jĩi ndii olivii sɑko nɔ í mɑ́siɛ si jĩi ndii olivi iyi ɑ̀ wɑɑ loɡooɑ iyi kù jɛ icuɛ, debɛi, kɑɑ ɡɑɑbuɑɑ ku sindo ɑmɑɑwɔu si jĩi ndii nŋu tɑkɑɛ. ");
INSERT INTO mkl_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Iŋɛ inɛm ŋɑ, n kù bi ɑsiii ideu ihɛ̃ ku mɑnji nŋɛ hee ku jɔ̀ i mɑɑ cɔ ɑrɑ nŋɛ ilu bisi ŋɑ. Asiiu wee. Idɔi inɛi Izirɛli fiti mbɔ ŋɑu í lei titɑ̃ hee kukpɔi dimi mmu ŋɑ iyi ɑɑ bɑ fɑɑbɑu ku kɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Si bɛɛbɛ, inɛi Izirɛli ŋɑu fei ɑɑ bɑ fɑɑbɑu, si bɛi ɑ̀ kɔɔ ɑ̀ ni, Ilɑɑɔ̃ í ni, Woo Fɑɑbɑu ɑ́ nɑɑi hɑi Siɔ̃ɔ, Nɔ ku nyɑ lɑsɑbu hɑi mɑ̀ bɛɛrɛm hɑi si dimii Zɑkɔbu. ");
INSERT INTO mkl_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Iyi ihɛ̃i í jɛ ɑkɑbuu iyi ɑn dĩ do ɑŋɑ si wɑɑti iyi ɑn kpɑ idei dulum du ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Si tuubɑi lɑɑbɑɑu jiidɑu Zuifu ŋɑ ɑ̀ jɛ mbɛɛi Ilɑɑɔ̃, nɔ nŋu bɛi í bɑɑ í jɛ ɑrɑnfɑ̃ɑnii iŋɛ, ɑmmɑ si tuubɑi kucicɑ, ɑ̀ jɛ inɛ ŋɑ iyi Ilɑɑɔ̃ í bi hee nsɛi nɑ bɑlɑ nŋɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ilɑɑɔ̃ í bi ŋɑ hee nsɛi domi ci yɑ ce muɑ nɡbɑ nɔ ci yɑ sindɑ idɔ hɑi si inɛ ŋɑ iyi í kpe. ");
INSERT INTO mkl_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Tɑko wo ì dondɑ Ilɑɑɔ̃ ŋɑ, ɑmmɑ nsɛi Ilɑɑɔ̃ í too si ide hɑi ɡbɔi Zuifu ŋɑu í ceò ɑrɑɑre nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Nsɛi si bɛi Ilɑɑɔ̃ í ce nŋɛ didɔ̃ nɑ sɑɑbui ide hɑi ɡbɔ nŋɑu, bɛɛbɛ mɔi ɑ́ too si ɑrɑɑre iyi í nyisi ŋɛ ku bɑ ku ce ɑrɑɑrei ɑŋɑ mɔ. ");
INSERT INTO mkl_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ntɔ ntɔ, Ilɑɑɔ̃ í jɔ̀ inɛ fei í bɑɑ í jɛ ɑrui ide hɑi ɡbɔ, ku bɑ ku ce ɑrɑɑrei inɛ fei. ");
INSERT INTO mkl_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Irei ì ɡbɔ bɛi ɑmɑnii Ilɑɑɔ̃ do bisiɛ do kumɑ̀ɛ í lɑ í to. Inɛ ɡɔ kɑɑ yɔkɔ ku mɑ̀ yɑɑsei lɑsɑbuɛ. Inɛ ɡɔ mɔ kù nɔ kù wɛɛ iyi ɑ́ mɑ̀ kpɑ̃ɑɛ sɑ̃ɑ sɑ̃ɑ. ");
INSERT INTO mkl_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Bɛɛbɛi kukɔi idei Ilɑɑɔ̃ í ni, Yooi í mɑ̀ lɑsɑbui Aɔ̃ Lɑfɛ̃ɛ. Mɑ̀ yooi í muɑɑ bisi ɑjɔ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Yooi í tɑko í muɑɑ nɡɔɡɔ ku bɛi ku mɑɑ deɡbe ku sɑ̃ɑ nŋu ɡbese. ");
INSERT INTO mkl_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ilɑɑɔ̃i í jɛ irii mii fei, hɑi bi tɛɛi fei ndɛɛ wɑ nɑɑ. Nɔ mii fei í wɛɛi nɑ iriɛ. Amboe ku jɛ tɛɛ hɑi nsɛi hee do ɑjɔ fei. Ami. ");
INSERT INTO mkl_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Nɑ nŋu iŋɛ inɛm ŋɑ, ǹ wɑ n tɔɔ ŋɛi nɑ sɑɑbui ɑrɑɑre iyi Ilɑɑɔ̃ í ce nŋɛ, i nɑ Ilɑɑɔ̃ ɑrɑ nŋɛ. I jɔ̀ kuwɛɛ nŋɛ ku jɛɑɑ bɛi kuwee ɡɔ iyi í mɑ́ nɔ í sĩɑɑ si. Do yɑɑse bɛɛbɛi í sĩɑ i yɑ tɔɔ Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","I mɑɑ̀ yɑ ce kucei inɛi ɑndunyɑ ŋɑ, ɑmmɑ i jɔ̀ Ilɑɑɔ̃ ku mu nŋɛ lɑsɑbu titɔ̃ iyi ɑ́ kpɑɑsiò kuwɛɛ nŋɛ, ku bɑ i mɑ̀ iyi í jɛ idɔɔbii Ilɑɑɔ̃ ŋɑ. Idɔɔbiɛu wee, iyi í jɛ jiidɑ, iyi í dɔ̃ do iyi í kɔ̃ mɑm mɑm. ");
INSERT INTO mkl_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Nɑ didɔ̃ iyi Ilɑɑɔ̃ í muum, ǹ wɑ n sɔ̃ iŋɛ fei, i mɑɑ̀ jilɛ ɑrɑ nŋɛ tenɡi bii i kù to ŋɑ, ɑmmɑ inɛ fei ku jilɛ ɑrɑɛ si zɑkɑ bɛi Ilɑɑɔ̃ í muɑɑ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Si ɑrɑ ɑkɑ̃ ikɔ̃ ikɑ̃ ikɑ̃i í wɑ si nɔ ɑŋɑ fei do icɛ nŋɑi. ");
INSERT INTO mkl_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Bɛɛbɛ mɔi, bɑɑ bii ɑwɑ ɑ̀ kpɔ ɑ̀ jɛ ɑrɑ ɑkɑ̃ si Kirisi nɔ ɑ̀ dĩ si njɛi bɛi ikɔ̃ ikɑ̃ ikɑ̃i ɑrɑu. ");
INSERT INTO mkl_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Bɛɛbɛ mɔi ɑ̀ nɛ ɑmuɑ ikɑ̃ ikɑ̃ iyi Ilɑɑɔ̃ í ce nwɑ si didɔ̃ɛ. Inɛ iyi í nɛ ɑmuɑi ide iyi wɑ nɑɑ hɑi bi Ilɑɑɔ̃ ku sɔ̃ inɛ ŋɑ, ku ceò icɛ si bɛi nɑɑnɛ ku dɑsiɛ í to. ");
INSERT INTO mkl_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Inɛ iyi í nɛ ɑmuɑi ku ceɑ inɛ ŋɑ icɛ si iɡbɛu, ku coo. Inɛ iyi í nɛ ɑmuɑi inɛ ŋɑ ku kɔ si idei Ilɑɑɔ̃ ku kɔ ŋɑ si. ");
INSERT INTO mkl_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Inɛ mɔ iyi í nɛ ɑmuɑi inɛ ŋɑ ku muɑ ɡbuɡbɑ̃ ku coo. Inɛ mɔ iyi í yɑ yɔkɔ ku ce ɑmuɑ ku coo do inɔ ɑkɑ̃. Inɛ nɡbo ku ce icɛɛ do himmɑ. Inɛ iyi í nɛ ɑmuɑi ilu ɑre ŋɑ ku sobi ku coo do inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","I mɑɑ̀ jɔ̀ kubi nŋɛ ku jɛ do muɑfiti. I sɑɑ lɑɑlɔ nɔ i leekĩ si jiidɑ ku ce dim dim ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","I bi njɛ ŋɑ, i ce kookɑɑi i yɑ mɑ̀ò bɛɛrɛi njɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","I mɑɑ̀ jɔ̀ himmɑ nŋɛ ku kɑye, ɑmmɑ i yɑ mɑɑ ceɑ Aɔ̃ Lɑfɛ̃ɛ icɛ ŋɑ, nɔ i jɔ̀ Hundeɛ ku mɑɑ ce icɛ si ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","I wɛɛò inɔ didɔ̃ ŋɑ nɑ kpɑ̃ɑ ku cɔu. I temuɑ si wɑhɑlɑ ŋɑ. I mɑɑ̀ yɑ ɡbɛɛji do kutɔɔ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","I yɑ sobi inɛ ŋɑ iyi ɑ̀ jɛ ti Ilɑɑɔ̃ si bukɑɑtɑi mii iyi ɑ̀ bi. Nɔ i yɑ yɑɑɛ inɛ njoo ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","I yɑ weeɑ inɛ ŋɑ iyi ɑ̀ wɑɑ kpɑ̃ ŋɛ iju. I wee nŋɑ ŋɑ, i mɑɑ̀ ceekpe ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Inɛ ŋɑ iyi ɑ̀ wɑ si inɔ didɔ̃ i bɑ ŋɑ inɔ didɔ̃ ku kpɛ̃, inɛ ŋɑ mɔ iyi ɑ̀ wɑɑ kpɑtɑ i bɑ ŋɑ ku kpɑtɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","I yɑ nɛ ɑnu ɑkɑ̃ ŋɑ, i mɑɑ̀ jɔ̀ lɑsɑbui ɑrɑ ku so ku wɑ si ŋɛ, ɑmmɑ i yɑ kɑye ɑrɑ nŋɛ ŋɑ. I mɑɑ̀ yɑ jilɛ ɑrɑ nŋɛ ilu bisi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","I mɑɑ̀ yɑ sɑ̃ɑ inɛ ɡɔ lɑɑlɔ ŋɑ. I yɑ mɑɑ dɛ i ce iyi í jɛ jiidɑ si ɡɑ̃mɛi inɛ fei ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Bii í jɛ ɑ́ ce i ce kookɑɑi bɑɑ yoomɑ fei i jɔ̀ iŋɛò inɛ fei i yɑ dɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Iŋɛ kpɑɑsim ŋɑ i mɑɑ̀ yɑ dɛ i sɑ̃ɑ njɛ ɡbesei lɑɑlɔ ŋɑ, ɑmmɑ i yɑ jɔ̀ Ilɑɑɔ̃ ku sɑ̃ nŋɛ ɡbesei idɔɔkɔ̃, domi ɑ̀ kɔɔ ɑ̀ ni, Aɔ̃ Lɑfɛ̃ɛ í ni, Amui ɑn sɑ̃ ɡbesei idɔɔkɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Nɔ ɑ̀ kɔɔ mɑ́ ɑ̀ ni, Bii ɑri wɑ kpɑ mbɛɛɛ, nɑ́ɑ ijɛ ku jɛ. Bii ɑɡbɛ wɑ kpɑɑ, muɑɑ inyi ku mɔ, Domi bii ì wɑɑ ceɑɑ bɛɛbɛ, í yɛ bɛi inɑ nyɛnyɛi ì wɑɑ koɑɑ si iri. ");
INSERT INTO mkl_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Mɑɑ̀ jɔ̀ lɑɑlɔ ku kɑ̃miɑɛ, ɑmmɑ jɔ̀ i kɑ̃miɑɛ do jiidɑ ku ceɛ. ");
INSERT INTO mkl_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Inɛ fei ku jirimɑ ilɑɑlui ilɛɛ, domi ilɑɑlu kɑ̃mɑ kù wɛɛ iyi kù jɛ do kumɑ̀sii Ilɑɑɔ̃. Ilɑɑlu ŋɑ iyi ɑ̀ wɛɛ fei Ilɑɑɔ̃i í jilɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Nɑ nŋu, bii inɛ í dondɑ idei ilɑɑlu, ide iyi Ilɑɑɔ̃ í jilɛi í kɔsi. Nɔ inɛ ŋɑ iyi ɑ̀ wɑɑ kɔ ide dimi bɛɛbɛ, ɑ̀ wɑɑ dɛdɛɑ ɑrɑ nŋɑ tɑɑlei. ");
INSERT INTO mkl_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ntɔ ntɔ, woo ce jiidɑ ŋɑ ɑ kù nɛ ziɡiidɑ do inɛ ŋɑ iyi ɑ̀ wɑɑ mu ilɛu, í ɡbe woo ce lɑɑlɔ ŋɑ. Bii i kù bi njo ku muɛ si ɡɑ̃mɛi ilɑɑlu ŋɑu, ce jiidɑɛ, ɑɑ nɛ siɛ inɔ didɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ilɑɑlu ŋɑ ɑ̀ wɑɑ ce icɛi Ilɑɑɔ̃i nɑ ɑrɑnfɑ̃ɑni nŋɛ. Ammɑ bii ì wɑɑ ce lɑɑlɔɛ ŋɑ, i ce njo nŋɑ, domi ɑ kù wɑɑ mu tɑɑkubɑ si nɡbɛ. Aŋɑ mɔ woo ce icɛi Ilɑɑɔ̃ ŋɑi ku bɑ ɑ sɑ̃ ɡbesei idɔɔkɔ̃i Ilɑɑɔ̃ nɔ ɑ kpɑ̃ inɛ ŋɑ iyi ɑ̀ wɑɑ ce lɑɑlɔ iju. ");
INSERT INTO mkl_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Nɑ nŋu, ì nɛ i sũ nŋɑ iri ilɛ ŋɑi, nɔ kù jɛ si nɑ iyi í jɔ̀ ì wɑɑ ce njoi ijuukpɑ̃ nŋu ɑkɑ̃ ŋɑ, ɑmmɑ ku bɑ idɔ nŋɛ ku mɑɑ̀ yɛ tɑɑle nŋɛi. ");
INSERT INTO mkl_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Nŋui í nɔ í jɔ̀ ì wɑɑ sɑ̃ fiɑi lɛmpoo mɑ́ ŋɑ, domi inɛ ŋɑ iyi ɑ̀ wɑɑ mu ilɛu ɑŋɑ mɔ woo ce icɛi Ilɑɑɔ̃ ŋɑi nɔ ɑ̀ nɑ ɑrɑ nŋɑi mɑm mɑm. ");
INSERT INTO mkl_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","I sɑ̃ɑ inɛ fei iyi ì nɛ i sɑ̃ ŋɑ. Inɛ ŋɑ iyi ì nɛ i sɑ̃ɑ lɛmpoo i sɑ̃ nŋɑ ŋɑ. Inɛ iyi ì nɛ i sɑ̃ɑ fiɑi duɑni i sɑ̃ɑ lɑfɛ̃ɛ. Inɛ iyi ì nɛ i jirimɑ fei i jirimɑ lɑfɛ̃ɛ ŋɑ. Inɛ iyi ì nɛ i mɑ̀ bɛɛrɛɛ, i mɑ̀ɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","I mɑɑ̀ yɑ mu ɡbesei inɛ ɡɔ. Gbesei mii ɑkɑ̃i í nɛ ku wɑ si ɑnini nwɑ, nŋui í jɛ kubi, domi inɛ iyi í bi inɛ ŋɑ wɑ kɔ̃ woodɑ feii. ");
INSERT INTO mkl_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Ntɔ ntɔ, woodɑ ŋɑu ihɛ̃ iyi í ni, i mɑɑ̀ ce sɑkɑrɑ, nɔ i mɑɑ̀ kpɑ inɛ, nɔ i mɑɑ̀ ce ile, nɔ i mɑɑ̀ ce binɛ, do woodɑ ikɑ̃ ikɑ̃ iyi í ɡbe fei ɑɑ yɔkɔ ɑ tɔtɔɔ ŋɑ si woodɑ ɑkɑ̃. Woodɑ ɑkɑ̃u wee, bi inɛ mmu bɛi ì bi ɑrɑɛ. ");
INSERT INTO mkl_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Bii kubi í wɑ si ɡɑ̃mɛ nŋɛ i kɑɑ yɔkɔ i ceɑ njɛ lɑɑlɔ ŋɑ. Nɑ nŋu, bii ì bi njɛ ì wɑɑ jirimɑ woodɑ ŋɑu fei ŋɑi. ");
INSERT INTO mkl_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Í sĩɑ i ce bɛɛbɛ ŋɑ, domi ì mɑ̀ ŋɑ si wɑɑti bii ɑ̀ wɑ nsɛi. Í to i jĩ hɑi si iri njoo ŋɑ, domi wɑɑti iyi Lɑfɛ̃ɛ ɑ́ fɑɑbɑ wɑ mɑm mɑm í mɑɑi wɑ nsɛi í re wɑɑti iyi ɑ̀ sinti dɑsi nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Idũ í dũ wɑ koo, nɔ ɑmɛɛjumɑ́ í mɑɑi wɑ. Nɑ nŋu, kɑ jɔ̀ icɛi ilu kuku ku ce, nɔ kɑ so jĩnɛi iɡũ iyi ɑ́ jɔ̀ kɑ jɑbu si inyɑ kumɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","I jɔ̀ kɑ nɛ dee dee ɑwɑ iyi ɑ̀ jɛ inɛi inyɑ kumɑ́ ŋɑ. Kɑ mɑɑ̀ jɔ̀ ijɛ ku bi nwɑ do ɑtɛ̃ ku mɔ nwɑ ku lɑ ku cɑɑ, kɑ mɑɑ̀ nɛ ɑdɛi ɑbo do dɑɑ bɛɛtɛkɛ ku ce, nɔ kɑ jɔ̀ ijɑ do iɡu. ");
INSERT INTO mkl_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ammɑ i so dɑɑ titɔ̃i Jesu Kirisi Lɑfɛ̃ɛ nwɑ, nɔ i mɑɑ̀ jɔ̀ dɑɑi iŋɛ tɑkɑ nŋɛ ku mɑɑ nɛò ŋɛ i mɑɑ ceò binɛ mɑ́ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","I ɡbɑ inɛ iyi nɑɑnɛ ku dɑsiɛ kù nɛ ɡbuɡbɑ̃, nɔ i mɑɑ̀ yɑ yɛ tɑɑlei ide iyi wɑ lɑsɑbu. ");
INSERT INTO mkl_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Inɛ ihɛ̃ wɑ tɑmɑɑ si iyi nŋu ɑ́ yɔkɔ ku jɛ ijɛ fei. Inɛ ihɔ̃ mɔ iyi kù nɛ ɡbuɡbɑ̃ si nɑɑnɛ ku dɑsiɛu, ci yɑ ŋɔ iŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Inɛ iyi wɑ jɛ mii iyi í bɑ fei ku mɑɑ̀ dondɑ inɛ iyi ci yɑ jɛ mii fei, nɔ inɛ mɔ iyi ci yɑ jɛ mii iyi í bɑ fei, ku mɑɑ̀ yɛ tɑɑlei inɛ njɛ iyi wɑ jɛ mii fei, domi Ilɑɑɔ̃i í ɡbɑ lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Bɛirei ɑwɔ ì yɛ ì bɛi ì wɑɑ kiitiò ɑmɑɑcɛi inɛ mmu ɡɔ. Bii wɑ leekĩ si icɛɛ wɑlɑkɔ bii í nɔ í fũsi ɑwɔ mɔi idei irii lɑfɛ̃ɛɛi. Ammɑ ɑ́ mɑɑ leekĩi domi Aɔ̃ Lɑfɛ̃ɛ í nɛ ɡbuɡbɑ̃ ku muɑɑ ɡbuɡbɑ̃. ");
INSERT INTO mkl_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Inɛ ɡɔ ŋɑ ɑ̀ yɑ tɑmɑɑ bɛi ɑjɔ ɡɔ ŋɑ ɑ̀ re njɛ do bɛɛrɛi, nɔ inɛ ɡɔ ŋɑ mɔ ɑ̀ yɑ mɑɑ tɑmɑɑ mɑ̀ iju iyi í mɑ́ fei ɑkɑ̃i. Si ide ŋɑu ihɛ̃ í sĩɑ inɛ fei ku mu iyi í jɛ lɑsɑbui idɔɛ dim dim. ");
INSERT INTO mkl_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Inɛ iyi wɑ tɑmɑɑ ɑjɔ ɡɔ ŋɑ ɑ̀ re njɛ do bɛɛrɛ, wɑ cooi nɑ Aɔ̃ Lɑfɛ̃ɛ. Inɛ iyi wɑ jɛ ijɛ iyi í bɑ fei, nɑ irii Aɔ̃ Lɑfɛ̃ɛi wɑ jɔɔ, domi í yɑ sɑɑbu Ilɑɑɔ̃i titɑ̃ nɑ ijɛu. Inɛ mɔ iyi kù wɑɑ jɛ mii fei, nɑ irii Ilɑɑɔ̃i kù wɑɑ jɛ, í nɔ wɑ sɑɑbuɛ. ");
INSERT INTO mkl_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Kuwɛɛi inɛ kɑ̃mɑ nwɑ kù jɛ ti nŋu ɑkɑ̃, bɛɛbɛ mɔi do ikuɛ. ");
INSERT INTO mkl_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ntɔ ntɔ, bii ɑ̀ wɛɛ, ɑ̀ wɛɛi nɑ irii Lɑfɛ̃ɛ, bii ɑ̀ nɔ ɑ̀ ku mɔi, nɑ irii Lɑfɛ̃ɛi ɑ̀ ku. Nɑ nŋu, bii ɑ̀ wɑɑ wɛɛ wɑlɑkɔ bii ɑ̀ ku, ti Lɑfɛ̃ɛi ɑ̀ jɛ, ");
INSERT INTO mkl_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","domi Kirisi í ku nɔ í dede hɑi si bɑlɛ mɑ́ ku bɑ ku jɛ Lɑfɛ̃ɛi inɛ ŋɑ iyi ɑ̀ ku do inɛ ŋɑ iyi ɑ̀ wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","To, bii bɛɛbɛi, nɑ mii í ce ɑwɔ ì wɑɑ yɛ tɑɑlei kpɑɑsiɛ. Mɑ̀ nɑ mii í ce ì wɑɑ dondɑ kpɑɑsiɛ. Awɑ feii ɑɑ kɑ leekĩ ɑjɔ ɑkɑ̃ si wɑjui Ilɑɑɔ̃ ku kiiti nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Ajɔ nŋui kukɔi idei Ilɑɑɔ̃u ihɛ̃ ɑ́ kɔ̃ tenɡi bii í ni, Aɔ̃ Lɑfɛ̃ɛ í ni, Amui ǹ jɛ kuwɛɛ, inɛ fei ɑ́ nɑ ku ɡulɛ si wɑjum. Nɔ inɛ fei ku sɑɑbum do ɡɛlɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Bɛɛbɛ mɔi ɑwɑ fei ɑɑ kɑ fɔ tu wɑ si wɑjui Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nɑ nŋu, i mɑɑ̀ yɑ kiiti njɛ ŋɑ. Ammɑ ce lɑɑkɑi i mɑɑ̀ ti i ce nɡɔɡɔ iyi ɑ́ jɔ̀ kpɑɑsiɛ ku rɑrɑ ku dɑsi dulum. ");
INSERT INTO mkl_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Nɑ sɑɑbui Lɑfɛ̃ɛ Jesu ǹ mɑ̀ kɑm kɑm iyi sɔndɑ kɑ̃mɑ kù jɛ ìwɔ̀. Ammɑ bii inɛ ɡɔ wɑ doo sɔndɑ ɡɔ ìwɔ̀, bi tɛɛi í jɛ ìwɔ̀. ");
INSERT INTO mkl_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Bii inɔi kpɑɑsiɛ í fɔ nɑ ijɛ ɡɔ iyi ì wɑɑ jɛ, wɑ nyisi iyi i kù wɑɑ nɛ si kpɑ̃ɑi kubi mɑ́. Mɑɑ̀ jɔ̀ idei ijɛ ku jɔ̀ inɛ ɡɔ iyi Kirisi í ku nɑ iriɛ ku ce nfe. ");
INSERT INTO mkl_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Iyi ì yɛ í sĩɑɛ ku ce, mɑɑ̀ ti i coo do yɑɑse bɛi ɑ́ jɔ̀ inɛ ŋɑ ɑ fɔ lɑɑlɔɛ. ");
INSERT INTO mkl_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Bommɑi Ilɑɑɔ̃ kù jɛ idei kujɛ do kumɔ, bii kù jɛ dee dee ku jɛ do lɑɑkɑi ku sũ do inɔ didɔ̃ iyi Hundei Ilɑɑɔ̃ wɑ mu nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Inɛ iyi wɑ ceɑ Kirisi icɛ si yɑɑse bɛɛbɛ, lɑfɛ̃ɛi Ilɑɑɔ̃ ɑ́ bi, nɔ bɑɑ ɑmɑnɛ ŋɑ ɑɑ sɑɑbuɛ. ");
INSERT INTO mkl_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Nɑ nŋu, kɑ dɛ mii iyi ɑ́ nɑɑò lɑɑkɑi ku sũ wɑ do mii iyi ɑ́ mu nwɑ ɡbuɡbɑ̃ si nɑɑnɛ ku dɑsi nwɑ. ");
INSERT INTO mkl_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","I mɑɑ̀ bɛjɛ icɛi Ilɑɑɔ̃ nɑ idei ijɛ. Ntɔi, sɔndɑ kɑ̃mɑ kù jɛ ìwɔ̀, ɑmmɑ kù sĩɑ inɛ ɡɔ ku jɛ ijɛ iyi ɑ́ jɔ̀ kpɑɑsiɛ ku koosɛ. ");
INSERT INTO mkl_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Iyi í sĩɑ nŋui í jɛ i mɑɑ̀ ŋɔ iŋɑ, nɔ i mɑɑ̀ mɔ vɛ̃ɛ, nɔ i mɑɑ̀ ce nɡɔɡɔ bii í jɛ ɑ́ dɑsi kpɑɑsiɛ kurɑrɑ. ");
INSERT INTO mkl_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Mii iyi ì wɑɑ lɑsɑbu si ideu ihɛ̃, muu si idɔɛ, nɔ kú jɛ si ɡɑ̃mɛi ɑwɔ do Ilɑɑɔ̃ nŋu ɑkɑ̃. Ilu inɔ didɔ̃i inɛ iyi idɔɛ kù wɑɑ yɛ tɑɑleɛ si mii iyi wɑ ce. ");
INSERT INTO mkl_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ammɑ inɛ iyi wɑ sikɑ si ijɛ ɡɔ iyi wɑ jɛ, Ilɑɑɔ̃ ɑ́ yɛ tɑɑleɛ domi kù wɑɑ coo do nɑɑnɛ. Ntɔ ntɔ, mii iyi inɛ wɑ ce fei nɔ kù wɑɑ coo do nɑɑnɛ, dulum nii. ");
INSERT INTO mkl_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Nsɛi, ɑwɑ iyi ɑ̀ nɛ ɡbuɡbɑ̃ si nɑɑnɛ ku dɑsi, i jɔ̀ kɑ temuɑò ɡbuɡbɑ̃ ku kuɑi hɑi nɛ ɡbuɡbɑ̃ ŋɑ, nɔ kɑ mɑɑ̀ yɑ kɑ ce mii iyi ɑ́ dɔ̃ɑ ɑwɑ tɑkɑ nwɑ si. ");
INSERT INTO mkl_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Awɑ fei kɑ yɑ ce mii iyi ɑ́ dɔ̃ɑ kpɑɑsi nwɑ ŋɑ si nɑ ɑrɑnfɑ̃ɑni nŋɑ, ku bɑ nɑɑnɛ ku dɑsi nŋɑ ku bɔ wɑju. ");
INSERT INTO mkl_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kirisi tɑkɑɛ ci yɑ ce mii iyi ɑ́ dɔ̃ɑ nŋu tɑkɑɛ si, ɑmmɑ si bɛi ɑ̀ kɔɔ ɑ̀ ni, í sɔ̃ Ilɑɑɔ̃ í ni, inɛ ŋɑ iyi ɑ̀ buɛ, ɑrɑbu nŋɑ í bɑɑ sim. ");
INSERT INTO mkl_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Mii iyi ɑ̀ kɔ tɑko fei wo, ɑ̀ kɔɔi ku bɑ ku kɔ wɑ nɔ kɑ nɛ kpɑ̃ɑ ku cɔ hɑi si kukɔi idei Ilɑɑɔ̃, iyi wɑ mu nwɑ ɡbuɡbɑ̃ do temuɑ. ");
INSERT INTO mkl_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ilɑɑɔ̃, nŋu iyi wɑ mu nwɑ temuɑ do ɡbuɡbɑ̃, kú jɔ̀ iŋɛ duusɔ̃ɔ i nɛ ɑnu ɑkɑ̃ ŋɑ si bɛi ì yɔɔ si Jesu Kirisi ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ku bɑ iŋɛ fei i yɑ mɑɑ sɑɑbu Ilɑɑɔ̃ ɑjɔ do ɑnu ɑkɑ̃ ŋɑ, nŋu iyi í jɛ bɑɑi Lɑfɛ̃ɛ nwɑ Jesu Kirisi. ");
INSERT INTO mkl_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Nɑ nŋu, i yɑ ɡbɑ njɛ ŋɑ si bɛi Kirisi mɔ í ɡbɑ ŋɛ ku bɑ i nyisiò ɑmboei Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Ǹ wɑ n sɔ̃ ŋɛi iyi Kirisi nŋui í bɑɑ í jɛ woo ce icɛi Zuifu ŋɑu ku bɑ ide iyi ɑ̀ wɑ̃ò bɑlɑ nŋɑ ŋɑu ku kɔ̃, nɔ ku nyisiò iyi Ilɑɑɔ̃i í jɛ ilu ntɔ. ");
INSERT INTO mkl_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Jesu í nɑɑi mɑ́ ku bɑ dimi mmu ŋɑ mɔ ɑ sɑɑbu Ilɑɑɔ̃ nɑ ɑrɑɑreɛ si bɛi kukɔi idei Ilɑɑɔ̃ wɑ fɔ í ni, Nɑ ŋɔi í jɔ̀ ǹ wɑ n sɑɑbuɛ si inɔi dimi mmu ŋɑ. Nɔ n kɔ̃ iri n nyisiò ɑmboei iriɛ. ");
INSERT INTO mkl_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Nɔ í ni mɑ́, Iŋɛ dimi mmu ŋɑ i wɛɛò inɔ didɔ̃ do inɛi Ilɑɑɔ̃ ŋɑ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Nɔ í ni mɑ́, I sɑɑbu Aɔ̃ Lɑfɛ̃ɛ, iŋɛ dimi mmu ŋɑu fei, Iŋɛ fei i kɔ̃ iri i cũu. ");
INSERT INTO mkl_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Nɔ wɑlii Ezɑi mɔ í ni, Tɔkui Izɑi ɡɔ ɑ́ nɑ ku dede Ku jɛ ilɑɑlui dimi fei, Nɔ kpɑ̃ɑ ku cɔi dimi ŋɑu ɑ́ wɑ siɛ. ");
INSERT INTO mkl_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Nsɛi, Ilɑɑɔ̃, nŋu iyi wɑ mu nwɑ kpɑ̃ɑ ku cɔ, ku mu nŋɛ inɔ didɔ̃ do lɑɑkɑi ku sũ fei nɑ nɑɑnɛ iyi ì dɑsi ŋɑ ku bɑ kpɑ̃ɑ ku cɔ nŋɛ ku lɑ si ɡbuɡbɑ̃ iyi Hundei Ilɑɑɔ̃ í mu nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Iŋɛ inɛm ŋɑ, ɑmu tɑkɑm ǹ mɑ̀ kɑm kɑm iyi ì jɛ inɛ jiidɑ ŋɑ nɔ ì mɑ̀ mii iyi ì nɛ ku ce ŋɑ, ɑɑ nɔ i yɔkɔ i muɑ njɛ bisi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Do nŋu fei, do wɔɔkɔ nlɑ nlɑi n kɔ nŋɛ ide ɡɔ ŋɑ wɑ si idei tiɑu ihɛ̃, n ye ŋɛò ɡiɡii mii ŋɑ iyi ì mɑ̀ tɑ̃ ŋɑ. Ǹ kɔ nŋɛ wɑ bɛɛbɛi nɑ didɔ̃ iyi Ilɑɑɔ̃ í ceem ");
INSERT INTO mkl_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ǹ wɑ n jɛò woo ce icɛi Jesu Kirisi bi hɑi jɛ Zuifu ŋɑ. Ǹ wɑ n wɑɑzo lɑɑbɑɑu jiidɑi Ilɑɑɔ̃ bɛi woo wee ku bɑ hɑi jɛ Zuifu ŋɑ ɑ yɛ bɛi kuwee iyi ɑ́ dɔ̃ɑ Ilɑɑɔ̃ si, si nɑ iyi í jɔ̀ Hundeɛ í cicɑ ŋɑ í jɔ̀ ɑ̀ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Nɑ nŋu, nɑ sɑɑbui Jesu Kirisi, ǹ nɛ inɔ didɔ̃ si icɛm iyi ǹ wɑ n ceɑ Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","N kɑɑ n yɔkɔ n fɔ ide ɡɔ bii kù jɛ idei icɛ iyi Kirisi í ce si ide ku fɔm do si kookoosum ŋɑ ku bɑ hɑi jɛ Zuifu ŋɑ ɑ jirimɑ Ilɑɑɔ̃ ");
INSERT INTO mkl_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","nɑ sɑɑbui mɑɑmɑɑke dimi ikɑ̃ ikɑ̃ ŋɑ iyi ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃ í ce. Bɛɛbɛ mɔi ǹ wɑɑzo lɑɑbɑɑu jiidɑi Kirisi bii fei sɑ̃ɑ sɑ̃ɑ hɑi Zeruzɑlɛmu hee ku bɔ ikpɑ ilɛi Iliri. ");
INSERT INTO mkl_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Nɔ ǹ dɑsi idɔ n wɑɑzo lɑɑbɑɑu jiidɑu si ilɛ ŋɑ bii ɑ kù ɡbɔ idei Kirisi titɑ̃, ku bɑ n mɑɑ̀ n mɑ si icui ilei inɛ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Ǹ ce bɛɛbɛi ku bɑ n ce bɛi kukɔi idei Ilɑɑɔ̃ í fɔ, tenɡi bii í ni, Inɛ ŋɑ iyi ɑ kù fɔ ideɛ bi tu ŋɑ ɑjɔ kɑ̃mɑ, ɑɑ yɔɔ. Inɛ ŋɑ mɔ iyi ɑ kù ɡbɔ bɑɑuɛ wo, ɑɑ ɡbɔ yɑɑseɛ. ");
INSERT INTO mkl_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Tuubɑ nkpɔ nkpɔ isɛɛnɛ ŋɑu bɛi í yɑ mɑɑ ɡɑnjim n nɑɑ bi tu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ammɑ nsɛi, ǹ kpɑ irii icɛm si ilɛ ŋɑu bɛ, nɔ si nɑ iyi í jɔ̀ ǹ wɑ n bi n nɑɑ bi tu ŋɛ hɑi ɑdɔ̃ nkpɔ nkpɔ, ");
INSERT INTO mkl_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ǹ wɑ n tɑmɑɑ bii ǹ wɑ n bɔ ikpɑ ilɛi Ɛsipɑnyi, ɑn yɑɑ wɑ bi tu ŋɛ. Ǹ bi n yɛ ŋɛ n ce ɑjɔ minji bi tu ŋɛ bɛ kɑ kpɛ̃ inɔ didɔ̃, nɔ i sobim ŋɑ ku bɑ n bɔ Ɛsipɑnyiu. ");
INSERT INTO mkl_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ammɑ nsɛi titɑ̃ Zeruzɑlɛmui ǹ wɑ n bɔ n koo n sobi woo dɑsi Jesu nɑɑnɛ ŋɑ, ");
INSERT INTO mkl_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","domi woo dɑsi Jesu nɑɑnɛ ŋɑ iyi ɑ̀ wɑ ilɛi Mɑsedɔni do ilɛi Gɛrɛsi ɑ̀ tɔtɔɔ fiɑ do inɔ ɑkɑ̃ nɑ ilu ɑre ŋɑ iyi ɑ̀ wɑ si inɔi woo dɑsi Jesu nɑɑnɛ ŋɑu Zeruzɑlɛmu bɛ. ");
INSERT INTO mkl_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Do kubii ɑ̀ tɔtɔɔò fiɑu, ɑmmɑ ntɔ ntɔ ɡbesei ɑ̀ wɑɑ mu si nɑ iyi í jɔ̀ ɑmɑnii Ilɑɑɔ̃i iyi Zuifu ŋɑu ɑ̀ nɛ ɑ̀ kpɔ̃ɔ do dimi mmu ŋɑ. Bɛɛbɛ mɔi ɑ́ sĩɑ dimi mmu ŋɑu mɔ ɑ sobi ŋɑ do ɑmɑnii ɑndunyɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Wɑɑti iyi ɑn to Zeruzɑlɛmu n nɑ ŋɑ fiɑ iyi ɑ̀ tɔtɔɔu n kpɑò irii icɛu bɛ, ɑn bɔ Ɛsipɑnyi nɔ n yɑɑ wɑ n nɑɑ n yɛ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Ǹ mɑ̀ iyi kutom wɑ bi tu ŋɛ bɛ ɑ́ jɔ̀ Kirisi ku wee nŋɛ si mii nkpɔ nkpɔ. ");
INSERT INTO mkl_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Iŋɛ inɛm ŋɑ, ǹ wɑ n tɔɔ ŋɛi do irii Lɑfɛ̃ɛ nwɑ Jesu Kirisi do kubi iyi Hundei Ilɑɑɔ̃ wɑ mu nwɑ, í bɑm ku jɑbu si kutɔɔ nŋɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","I tɔɔ Ilɑɑɔ̃ ku nyɑm hɑi si ɑwɔi hɑi dɑsi Jesu nɑɑnɛ ŋɑ iyi ɑ̀ wɑ ilɛi Zudee, nɔ i ce kutɔɔ mɑ́ ŋɑ ku bɑ woo dɑsi Jesu nɑɑnɛ ŋɑu ɑ ɡbɑ ɑmuɑ iyi ǹ wɑ n bɔò Zeruzɑlɛmu do ɑwɔ minji. ");
INSERT INTO mkl_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Bɛɛbɛ mɔi ɑn to wɑ bi tu ŋɛ do inɔ didɔ̃ bii Ilɑɑɔ̃ í bi, nɔ n sĩmi keeke bi tu ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ilɑɑɔ̃, nŋu iyi wɑ mu nwɑ lɑɑkɑi ku sũ, ku wɛɛ do iŋɛ fei. Ami. ");
INSERT INTO mkl_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Ǹ wɑ n sɔ̃ ŋɛ iyi Feebe wecĩ nwɑ si kpɑ̃ɑi nɑɑnɛ ku dɑsi í jɛ ilu nɑɑnɛ. Woo ce icɛi inɛi iɡbɛi Jesu ŋɑi wɑ jɛ si ilui Sɑnkere. ");
INSERT INTO mkl_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","I ɡbɑ ɑbou nɑ iri Lɑfɛ̃ɛ si bɛi í jɔ woo dɑsi Jesu nɑɑnɛ ŋɑ ɑ ce. Nɔ i mɑɑ sobiɛ ŋɑ do bukɑɑtɑi mii iyi í bi si ɑninii iŋɛ fei, domi nŋu tɑkɑɛ í sobi inɛ nkpɔ, do ɑmu tɑkɑm. ");
INSERT INTO mkl_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","I ce Pirisilɑ do mɔkɔɛ Akilɑsi fɔɔ, kpɑɑsi woo ce icɛm ŋɑ si icɛi Jesu Kirisi, ");
INSERT INTO mkl_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ɑŋɑ iyi ɑ kù sɑɑlu bɑɑ kuwɛɛ nŋɑ ku bɑ ɑ fɑɑbɑ ti ɑmu. Kù jɛ ɑmu ɑkɑ̃i ǹ wɑ n sɑɑbu ŋɑ, hee do iɡbɛi inɛi Jesu ŋɑ iyi ɑ̀ jɛ dimi mmu ŋɑu fei ɑ̀ wɑɑ sɑɑbu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Nɔ i ce inɛi iɡbɛi Jesu ŋɑ iyi ɑ̀ yɑ tɔtɔɔ kpɑsɛ̃ nŋɑu fɔɔ. Nɔ i ceem Epɑnɛti kpɑɑsi jiidɑm nɔu fɔɔ, nŋu iyi í tɑko í dɑsi Kirisi nɑɑnɛ si ilɛi Azii. ");
INSERT INTO mkl_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Nɔ i ce Mɑɑri fɔɔ, nŋu iyi í ce icɛ ntɔ ntɔ nɑ iri nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Nɔ i ce Andoniku do Zuniɑ dimim ŋɑu fɔɔ, ɑwɑò ŋɑi ɑ̀ ce piisɔ̃ɔ ɑjɔ. À nɛ bɛɛrɛ nlɑ nlɑ si inɔi woo bɛ ŋɑu. À tɑko ɑ̀ dɑsi Kirisi nɑɑnɛ mɔm ɑmu mbɛ ǹ dɑsi. ");
INSERT INTO mkl_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Nɔ i ce Ampilɑtu fɔɔ, nŋu iyi í jɛ kpɑɑsi jiidɑm si kpɑ̃ɑi Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","I ce Uribɛ̃ɛ fɔɔ, kpɑɑsi woo ce icɛ nwɑ si icɛi Kirisi, do Sitɑki kpɑɑsi jiidɑm. ");
INSERT INTO mkl_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","I ce Apelɛsi fɔɔ, nŋu iyi í nyisi nɑɑnɛ ku dɑsiɛ ntɔ ntɔ si lɑɑkɑi ku cɔ. I ce inɛi kpɑsɛ̃i Arisitobu ŋɑ fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","I ce Herodiɔ̃ɔ dimim nɔu fɔɔ. I ce inɛi kpɑsɛ̃i Nɑɑsisi ŋɑ fɔɔ, ɑŋɑ iyi ɑ̀ dɑsi Lɑfɛ̃ɛ nɑɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","I ce Tiifɛni do Tiifozi fɔɔ, inɑɑbo ŋɑ iyi ɑ̀ wɑɑ ceɑ Lɑfɛ̃ɛ icɛu. Nɔ i ceem Pɛɛsidi inɑɑbo bɑɑkɔɔm nɔu mɔ fɔɔ, nŋu mɔ í ceɑ Lɑfɛ̃ɛ icɛ ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","I ce Rufusi fɔɔ, nŋu iyi wɑ ceɑ Lɑfɛ̃ɛ icɛ jiidɑ, do iyeɛ iyi wɑ jɛ bɛi iyei ɑmu mɔ si kpɑ̃ɑi nɑɑnɛ ku dɑsi. ");
INSERT INTO mkl_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","I ce Asɛnkiti fɔɔ, do Fileɡoni, do Herimɛsi, do Pɑtobɑsi, do Herimɑsi, do kpɑɑsi ŋɑ iyi ɑŋɑò ŋɑ ɑ̀ wɛɛ. ");
INSERT INTO mkl_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","I ce Filɔlɔɡu fɔɔ, do Zuli, do Neree, nŋu do wecĩɛ, do Olɛmpɑsi, do woo dɑsi Jesu nɑɑnɛ ŋɑ iyi ɑŋɑò ŋɑ ɑ̀ wɛɛ fei. ");
INSERT INTO mkl_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","I yɑ ce njɛ fɔɔ do kubi jiidɑ ŋɑ. Iɡbɛi inɛi Kirisi ŋɑ fei ɑ̀ wɑɑ ce ŋɛ fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ǹ wɑ n sɔ̃ ŋɛi, iŋɛ inɛm ŋɑ, i yɑ ce lɑɑkɑii inɛ ŋɑ iyi ɑ̀ yɑ nɑɑò njɛ ku fɛɛfɛ wɑ si ɑnini nŋɛ, nɔ ɑ jɔ̀ inɛ ɡɔ ŋɑ ɑ koosɛ si nɑɑnɛ ku dɑsi nŋɑ ɑ cuku. Aŋɑi ɑ̀ yɑ mɑɑ nyɑ cɔɔi cio iyi ì ɡbɔ ŋɑ. I jɔ̀ i jĩò inɛ dimi bɛɛbɛ ŋɑ ");
INSERT INTO mkl_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","domi inɛ dimi bɛɛbɛ ŋɑ ɑ kù wɑɑ ceɑ Kirisi Lɑfɛ̃ɛ nwɑ icɛ, í ɡbe inɔi ɑŋɑ tɑkɑ nŋɑ. Do ide didɔ̃ do idei inɛ ku lɛlɛ nŋɑ ŋɑui ɑ̀ yɑ wɑ inyii itĩi inɛ ŋɑ iyi ɑ ci yɑ ce lɑɑkɑi. ");
INSERT INTO mkl_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Iyi í jɛ ti iŋɛ mɔ, inɛ fei í mɑ̀ bɛi ì wɑɑ jirimɑ Lɑfɛ̃ɛ ŋɑ. Nɑ nŋu, ǹ wɛɛò inɔ didɔ̃ nɑ iri nŋɛ. Ammɑ ǹ bi í nɛ bisi ŋɑi ku bɑ i mɑ̀ bɛi ɑɑ yɑ ce jiidɑ ŋɑ, nɔ i jɛ inɛ ŋɑ iyi lɑɑlɔ ku ce í jɛ ìwɔ̀ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Kɑɑ kpɛ mɑ́, Ilɑɑɔ̃ nŋu iyi wɑ mu nwɑ lɑɑkɑi ku sũ, ɑ́ jɔ̀ i tɛɛsɛ Seetɑm ŋɑ. Didɔ̃i Lɑfɛ̃ɛ nwɑ Jesu ku wɛɛ do iŋɛ. ");
INSERT INTO mkl_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timɔtee kpɑɑsi woo ce icɛm wɑ ce ŋɛ fɔɔ, do Lusiusi, do Zɑsɔ̃ɔ do Sosipɑtɛɛ dimim ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Nɔ ɑmu Tɛtiusi, ɑmu iyi Pɔlu í sɔ̃m ide ŋɑu ihɛ̃ nɔ ǹ kɔɔ, ǹ wɑ n ce ŋɛ fɔɔ do irii Lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gɑyusi, ilu idem wɑ ce ŋɛ fɔɔ, nŋu iyi bi tɛɛi inɛi iɡbɛi Jesu ŋɑ fei ɑ̀ yɑ tɔtɔɔ. Erɑsitu, woo sinɡɑ fiɑi iluu do inɛ nwɑ Kɑɑtusi ɑ̀ wɑɑ ce ŋɛ fɔɔ. ");
INSERT INTO mkl_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Didɔ̃i Lɑfɛ̃ɛ nwɑ Jesu Kirisi ku wɛɛ do iŋɛ fei. Ami. ");
INSERT INTO mkl_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Kɑ sɑɑbu Ilɑɑɔ̃, nŋu iyi ɑ́ yɔkɔ ku mu nŋɛ ɡbuɡbɑ̃ nɑ sɑɑbui lɑɑbɑɑu jiidɑ do idei Jesu Kirisi iyi ǹ wɑ n ce wɑɑzoɛu. Ideui wɑ nyisi wɑ ɑsii iyi wɑ sinɡɑ wo hɑi ku kpɛ. ");
INSERT INTO mkl_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Ammɑ nsɛi í fitɑ ɡbuɡbɑ̃ɑ. Ide ŋɑ iyi wɑlii ŋɑu ɑ̀ kɔ si tiɑ nŋɑ ŋɑ í jɔ̀ dimi fei í mɑ̀ ɑsiiu. Nɔ Ilɑɑɔ̃i í jilɔɔ si bɛɛbɛ ku bɑ dimi fei ku jirimɑɛ si nɑɑnɛ ku dɑsi. ");
INSERT INTO mkl_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Nɑ nŋu, Ilɑɑɔ̃, nŋu ɑkɑ̃ iyi í jɛ ilu bisi do ntɔ, ɑmboe ku jɛ tɛɛ hee do ɑjɔ fei do sɑɑbui Jesu Kirisi. Ami.");
INSERT INTO mkl_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Amui Pɔlu, ɑmu iyi Ilɑɑɔ̃ í kpe si idɔɔbiɛ ǹ jɛ woo bɛi Jesu Kirisi. Amu do Sɔsitɛni kpɑɑsi nwɑu ");
INSERT INTO mkl_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ɑ̀ wɑɑ ce ŋɛ fɔɔ, iŋɛ inɛi iɡbɛi Ilɑɑɔ̃ ŋɑ iyi ì wɑ ilui Kɔrɛnti ŋɑ. À wɑɑ ce ŋɛ fɔɔ, iŋɛ iyi Ilɑɑɔ̃ í kpe ì jɛ tɛɛ ŋɑ, iŋɛ iyi í cicɑ í jilɛ i mɑɑ nɛ ɑnu ɑkɑ̃ do Jesu Kirisi ŋɑ. À ce iŋɛ fei fɔɔ hee do inɛ ŋɑ iyi ɑ̀ wɑ ilɛ bɑɑ yoomɑ fei, inɛ ŋɑ iyi ɑ̀ wɑɑ tɔɔ do irii Lɑfɛ̃ɛ nwɑ Jesu Kirisi, nŋu iyi í jɛ Lɑfɛ̃ɛi ɑwɑ fei. ");
INSERT INTO mkl_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Ilɑɑɔ̃ bɑɑ nwɑ do Lɑfɛ̃ɛ Jesu Kirisi ɑ mu nŋɛ didɔ̃ do lɑɑkɑi ku sũ. ");
INSERT INTO mkl_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Wɑɑti kɑ̃mɑ fei ǹ yɑ n mɑɑ n sɑɑbu Ilɑɑɔ̃i nɑ iri nŋɛ si nɑ iyi í jɔ̀ í mu nŋɛ didɔ̃ɛ nɑ ɑnu ɑkɑ̃ nŋɛ iyi ì ce do Jesu Kirisi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Ntɔ ntɔ, ɑnu ɑkɑ̃ nŋɛ iyi ì ce do Jesu Kirisi ŋɑ nŋui í jɔ̀ ì bɑ ɑmuɑ bɑɑ yoomɑ fei ì jɛò ilu ɑmɑni ŋɑ si idei Ilɑɑɔ̃ ku fɔ do ku mɑ̀. ");
INSERT INTO mkl_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Idei Kirisi iyi ɑ̀ wɑɑzo nŋɛu nŋui ì leekĩ si dim dim ŋɑ hee ");
INSERT INTO mkl_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ɑmuɑi Hundei Ilɑɑɔ̃ bɑɑ ɑkɑ̃ kù ɡɑiziɑ ŋɛ, iŋɛ iyi ì wɑɑ deɡbe wɑɑti iyi Lɑfɛ̃ɛ nwɑ Jesu Kirisi ɑ́ fɑɑtɑ wɑ. ");
INSERT INTO mkl_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Jesu Kirisii ɑ́ jɔ̀ i yɑ mɑɑ leekĩ dim dim ŋɑ hee kɔɔ ku bɑ i jɛ hɑi nɛ tɑɑle ŋɑ si ɑjɔ iyi ɑ́ nyi wɑ mɑ́. ");
INSERT INTO mkl_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Ilɑɑɔ̃ ilu nɑɑnɛi, nŋu iyi í kpe ŋɛ i ce ɑnu ɑkɑ̃ ŋɑ do Amɑɛ Jesu Kirisi Lɑfɛ̃ɛ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Iŋɛ kpɑɑsim ŋɑ, ǹ wɑ n tɔɔ ŋɛ do irii Lɑfɛ̃ɛ nwɑ Jesu Kirisi, i ce kookɑɑi i yɑ mɑɑ ɡbɔsi njɛ ŋɑ ku bɑ njɛ ku fɛɛfɛ ku mɑɑ̀ yɑ wɑ si ɑnini nŋɛ. I jɔ̀ i nɛ ɑnu ɑkɑ̃ dee dee ŋɑ, nɔ lɑsɑbu nŋɛ mɔ ku jɛ ɑkɑ̃, do mii iyi ì wɑɑ lele ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Iŋɛ inɛm ŋɑ, ǹ wɑ n fɔ bɛɛbɛi si nɑ iyi í jɔ̀ inɛi nyɑɑnzei Kolosee ŋɑ ɑ̀ sɔ̃m ɑ̀ ni ijɑ í yɑ wɑ si ɑnini nŋɛ. ");
INSERT INTO mkl_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Mii iyi í jɔ̀ ǹ wɑ n fɔ bɛɛbɛ wee. Ǹ ɡbɔ ɑ̀ ni inɛ ɡɔ í ni ti Pɔlui nŋu í jɛ, inɛ ihɛ̃ mɔ í ni ti Apoloi nŋu í jɛ, nɔ inɛ ihɔ̃ mɔ í ni ti Sefɑɑi nŋu í jɛ, nɔ inɛ mmu ɡɔ mɔ í ni ti Kirisii nŋu í jɛ. ");
INSERT INTO mkl_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Ì wɑɑ tɑmɑɑ bɛi ɑɑ kpɛ̃ Kirisi ikɔ bututu ŋɑi? Amu Pɔlu, ɑmu sisi ǹ ku si jĩi nɑ irii dulum du ŋɛ. Kù nɔ kù jɛ do irim nii ɑ̀ dɑsi ŋɛ inyi. ");
INSERT INTO mkl_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ǹ wɑ n sɑɑbu Ilɑɑɔ̃ do iyi n kù dɑsi inɛ ɡɔ nŋɛ inyi, bii kù jɛ Kirisipu do Gɑyusi. ");
INSERT INTO mkl_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Bɛɛbɛ mɔi inɛ ɡɔ kɑɑ yɔkɔ ku ni ɑ̀ dɑsi ŋɛ inyi do irim. ");
INSERT INTO mkl_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ammɑ ntɔi, ǹ dɑsi inɛi kpɑsɛ̃i Setefɑni ŋɑ mɔ inyi. To, ɑŋɑ bɑɑsi n kù mɑ̀ mɑ̀ ǹ dɑsi inɛ ɡɔ inyi mɑ́. ");
INSERT INTO mkl_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","N kù dɑsi inɛ nkpɔ inyi si nɑ iyi í jɔ̀ kù jɛ nɑ nŋui Kirisi í bɛm wɑ. Í bɛm wɑi n nɑ n sisi lɑɑbɑɑu jiidɑu. Lɑɑbɑɑu jiidɑu, kù jɛ do ɡɛlɛ didɔ̃i ǹ wɑ n sisiɛ, ku bɑ ikui Kirisi si ɑntɑi jĩi ku ɡɑɑuu ku mɑɑ̀ ce nfe. ");
INSERT INTO mkl_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Ntɔ ntɔ, idei ikui Kirisi si ɑntɑi jĩi ku ɡɑɑu í yɛi bɛi ide hɑi nɛ yɑɑse bi inɛ ŋɑ iyi ɑ̀ wɑ si kpɑ̃ɑi nfe ku ce. Ammɑ bi ɑwɑ iyi ɑ̀ wɑ si kpɑ̃ɑi fɑɑbɑu, ɡbuɡbɑ̃i Ilɑɑɔ̃i. ");
INSERT INTO mkl_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Mii iyi kukɔi idei Ilɑɑɔ̃ wɑ fɔ wee. Í ni, Ilɑɑɔ̃ í ni, An nyɑ lɑɑkɑii ilu lɑɑkɑi ŋɑ, Nɔ n kpɑ bisii ilu bisi ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","To, iwoi ilu bisi í wɑ mɔm. Iwoi woo kɔ inɛ ŋɑ si woodɑ í wɑ. Iwoi inɛ iyi inɛ ŋɑ ɑ̀ wɑɑ kpe woo mɑ̀i ɑndunyɑu í wɑ. Ilɑɑɔ̃ í nyisi iyi bisii ɑndunyɑu í yɛi bɛi idei sũmu. ");
INSERT INTO mkl_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Ntɔ ntɔ, inɛi ɑndunyɑ ŋɑ ɑ kù yɔkɔ ɑ kù mɑ̀ Ilɑɑɔ̃ do bisii ɑŋɑ tɑkɑ nŋɑ. Ilɑɑɔ̃ tɑkɑɛi í coo bɛɛbɛ. Ammɑ si bisiɛ mii iyi í sĩɑɑ wee. Inɛ ŋɑ iyi ɑ̀ dɑsiɛ nɑɑnɛ ɑ̀ bɑ fɑɑbɑ nɑ idei wɑɑzo iyi inɛ ɡɔ ŋɑ ɑ̀ wɑɑ cɔ bɛi idei sũmu. ");
INSERT INTO mkl_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Zuifu ŋɑ mɑɑmɑɑkei ɑ̀ yɑ mɑɑ bee, nɔ Gɛrɛki ŋɑ mɔ bisii ɑ̀ yɑ mɑɑ dɛ. ");
INSERT INTO mkl_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Ammɑ ɑwɑ, wɑɑzoi Kirisi iyi ɑ̀ kpɑkpɑ si ɑntɑi jĩi ku ɡɑɑuui ɑ̀ wɑɑ ce. Ideu bɛi í jɛ bɛi kutɑ bi ku koosɛ bi Zuifu ŋɑ nɔ í jɛ mɑ bɛi idei sũmu bi dimi mmu ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ammɑ bi inɛ ŋɑ iyi Ilɑɑɔ̃ í kpe, bɑɑ bii ɑ̀ jɛ Zuifu wɑlɑkɔ dimi mmu ŋɑ, Kirisii í jɛ ɡbuɡbɑ̃i Ilɑɑɔ̃ do bisiɛ. ");
INSERT INTO mkl_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Kirisii í jɛ ɡbuɡbɑ̃i Ilɑɑɔ̃ do bisiɛ bi tu ŋɑ domi idei Ilɑɑɔ̃ iyi inɛ ɡɔ ŋɑ ɑ̀ wɑɑ cɔ bɛi idei sũmuu í re bisii ɑmɑnɛ ŋɑ, nɔ icɛi Ilɑɑɔ̃ iyi inɛ ɡɔ ŋɑ ɑ̀ wɑɑ ni kù nɛ ɡbuɡbɑ̃u í re ɡbuɡbɑ̃i ɑmɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Iŋɛ kpɑɑsim ŋɑ, iŋɛ iyi Ilɑɑɔ̃ í kpe, i cɔ bɛi ì yɛ ŋɑ. Kù jɛ inɛ nkpɔ nŋɛi í jɛ ilu bisi si kuyɛi ɑmɑnɛ ŋɑ wɑlɑkɔ ilu ɡbuɡbɑ̃ wɑlɑkɔ ilu bɛɛrɛ. ");
INSERT INTO mkl_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ammɑ Ilɑɑɔ̃ í cicɑ mii ŋɑ iyi inɛi ɑndunyɑ ŋɑ ɑ̀ wɑɑ cɔ bɛi hɑi nɛ yɑɑse ŋɑ í dɑsiò ilu bisi ŋɑ ɑnyɔ, nɔ í cicɑ mɔnɡɔi ɑndunyɑ ŋɑ í dɑsiò ilu ɡbuɡbɑ̃ ŋɑ ɑnyɔ. ");
INSERT INTO mkl_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Nɔ Ilɑɑɔ̃ í cicɑ tɑɑkɑ ŋɑ do inɛ ŋɑ iyi ɑ̀ yɑ mɑɑ dondɑ, iyi ɑ kù jɛ nɡɔɡɔ si ɑndunyɑ í kɑyeò inɛ ŋɑ iyi ɑ̀ wɑɑ cɔ ɑrɑ nŋɑ bɛi inɛ nlɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Í ce bɛɛbɛi ku bɑ inɛ kɑ̃mɑ ku mɑɑ̀ yɔkɔ ku tɔɔ fufu si wɑjuɛ. ");
INSERT INTO mkl_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Ilɑɑɔ̃i í jɔ̀ ì nɛ ɑnu ɑkɑ̃ do Jesu Kirisi ŋɑ. Nɔ Kirisii í jɛ bisii Ilɑɑɔ̃ bi tu wɑ nɑ sɑɑbui ɑnu ɑkɑ̃ nwɑu iyi ɑ̀ ce do nŋu. Kirisii í nyɑ wɑ hɑi si dulum du wɑ. Do sɑɑbuɛi ɑ̀ jɛò dee dee nɔ ɑ̀ jɛò inɛi Ilɑɑɔ̃ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Nɑ nŋu, “inɛ iyi wɑ tɔɔ fufu ku tɔɔ nɑ irii Lɑfɛ̃ɛ.” Bɛɛbɛi kukɔi idei Ilɑɑɔ̃ í ni. ");
INSERT INTO mkl_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Iŋɛ kpɑɑsim ŋɑ, wɑɑti iyi ǹ nɑɑ bi tu ŋɛ n kù sisi idei Ilɑɑɔ̃ do bisi nlɑ ɡɔ wɑlɑkɔ do ɡɛlɛ didɔ̃ ɡɔ. ");
INSERT INTO mkl_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","N kù nɔ n kù dɑsi idɔ n sisi ide mmu ɡɔ si ɑnini nŋɛ bii kù jɛ idei Jesu Kirisi iyi ɑ̀ kpɑkpɑ si jĩi ku ɡɑɑu. ");
INSERT INTO mkl_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Nɔ wɑɑti iyi ǹ wɑ bi tu ŋɛu, do ɡbuɡbɑ̃ hɑi nɛi do njo do kuyɑyɑ nlɑ nlɑ. ");
INSERT INTO mkl_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Si idem do si wɑɑzom n kù dɛdɛ n lɛlɛ ŋɛ do bisii ɑmɑnɛ ŋɑ, ɑmmɑ ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃i ǹ jɔ̀ í kɑ̃miɑ ŋɛ. ");
INSERT INTO mkl_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Ǹ ce bɛɛbɛi ku bɑ nɑɑnɛ ku dɑsi nŋɛ ku mɑɑ̀ leekĩ si bisii inɛ ŋɑ, bii kù jɛ si ɡbuɡbɑ̃i Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Do nŋu fei, idei bisi ɡɔi ɑ̀ wɑɑ sisiɑ inɛ ŋɑ iyi ɑ̀ jĩɑ si nɑɑnɛ ku dɑsi nŋɑ. Ammɑ kù jɛ bisii ɑndunyɑu ihɛ̃ wɑlɑkɔ bisii inɛ nlɑ ŋɑu ɑŋɑ iyi ɑ̀ wɑɑ bɔ nfe ku ce. ");
INSERT INTO mkl_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Aɑwo, bisii ɑsiii Ilɑɑɔ̃ iyi í sinɡɑɑ ɑmɑnɛ ŋɑi ɑ̀ wɑɑ wɑɑzo. Bisiu Ilɑɑɔ̃ í ce sɔɔluɛi hɑi wɑɑti iyi kù tɑkɑ ɑndunyɑ ku bɑ kɑ kpɛ̃ ɑmboeɛ do nŋu tɑkɑɛ ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Bɑɑ inɛ ɑkɑ̃i ilu irii ɑndunyɑ ŋɑu ihɛ̃ kù mɑ̀ yɑɑseɛ, domi bii í jɛ ɑ̀ mɑ̀ɑi wo ɑ kɑɑ kpɑkpɑ Lɑfɛ̃ɛ si jĩi ku ɡɑɑu, nŋu iyi í nɛ ɑmboe fei. ");
INSERT INTO mkl_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ammɑ kukɔi idei Ilɑɑɔ̃ í ni, Iyi iju kù yɛ ɑjɔ kɑ̃mɑ, Nɔ itĩ kɑ̃mɑ mɔ kù ɡbɔɔ, Iyi kù nɔ kù lɔsi idɔi ɑmɑnɛ, Nŋui Ilɑɑɔ̃ í ceɑ inɛ ŋɑ iyi ɑ̀ buu sɔɔluɛ. ");
INSERT INTO mkl_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Nŋu bɛi Ilɑɑɔ̃ í jɔ̀ Hundeɛ í nyisi wɑ. Hundeɛu í yɔkɔ í nyisi wɑi si nɑ iyi í jɔ̀ í yɑ wusɛ fei ndɛɛ nɔ ku mɑ̀ hee do lɑsɑbui Ilɑɑɔ̃ tɑkɑɛ iyi wɑ mɑnji fei. ");
INSERT INTO mkl_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Mɑ̀ yooi í mɑ̀ lɑsɑbui ɑmɑnɛ bii kù jɛ hundei nŋu tɑkɑɛ iyi í wɑ siɛ. Bɛɛbɛ mɔi inɛ ɡɔ kù mɑ̀ lɑsɑbui Ilɑɑɔ̃ bii kù jɛ Hundeɛ. ");
INSERT INTO mkl_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Awɑ, kù jɛ lɑsɑbui ɑndunyɑi ɑ̀ bɑ, ɑmmɑ Hundei Ilɑɑɔ̃i ɑ̀ bɑ, ku bɑ kɑ mɑ̀ mii iyi Ilɑɑɔ̃ í mu nwɑ si didɔ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Nɔ ɑ kù wɑɑ tusɛ ɑsiiu do ide iyi wɑ nɑɑ hɑi si lɑsɑbui ɑmɑnɛ, bii kù jɛ hɑi bi Hundei Ilɑɑɔ̃. À yɑ tusɛɑ inɛ ŋɑ mii ndii Hundei do ide iyi wɑ nɑɑ hɑi bi Hundeu . ");
INSERT INTO mkl_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Inɛ ŋɑ iyi ɑ kù nɛ Hundei Ilɑɑɔ̃ ɑ kɑɑ ɡbɑ idei Hundei Ilɑɑɔ̃ domi bɛi idei sũmui í yɛ bi tu ŋɑ. A kɑɑ yɔkɔ ɑ ɡbɔ yɑɑseɛ domi do ɡbuɡbɑ̃i Hundei Ilɑɑɔ̃ nŋu ɑkɑ̃i ɑ̀ yɑ wũɑ idei Hundeu. ");
INSERT INTO mkl_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Inɛ iyi í nɛ Hundei Ilɑɑɔ̃ ɑ́ yɔkɔ ku kiiti si mii fei, ɑmmɑ inɛ ɡɔ kù wɛɛ iyi ɑ́ yɔkɔ ku kiiti lɑfɛ̃ɛ. ");
INSERT INTO mkl_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Kukɔi idei Ilɑɑɔ̃ wɑ fɔ í ni, yooi í mɑ̀ lɑsɑbui Aɔ̃ Lɑfɛ̃ɛ hee ku muɑɑ bisi. Kù wɛɛ. Ammɑ ɑwɑ ɑ̀ nɛ lɑsɑbu dimi ɑkɑ̃ do Kirisi. ");
INSERT INTO mkl_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Iŋɛ kpɑɑsim ŋɑ, n kù yɔkɔ n kù bɑ ŋɛ ide ku fɔ bɛi ǹ yɑ n fɔ do inɛ ŋɑ iyi ɑ̀ nɛ Hundei Ilɑɑɔ̃. Ammɑ ǹ bɑ ŋɛ ide ku fɔi bɛi inɛ ŋɑ iyi ɑ̀ wɑɑ too si idɔɔbii ɑrɑ, inɛ ŋɑ iyi ɑ̀ yɛ bɛi ɑmɑ kpɔtɔɔ ŋɑ si kpɑ̃ɑi Kirisi. ");
INSERT INTO mkl_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Cio iyi ǹ kɔ ŋɛ si í yɛi bɛi ɑmɔi ǹ nɑ ŋɛ, kù jɛ ijɛ kili, domi i kù to inɛ ŋɑ iyi ɑɑ jɛ ijɛ kili ŋɑ. I kù to bɑɑ nsɛi ŋɑ ");
INSERT INTO mkl_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","si nɑ iyi í jɔ̀ ì wɑɑ too idɔɔbii ɑrɑ titɑ̃ ŋɑ. Ntɔ ntɔ, iɡu do kɑkɔɔ í wɑ si ɑnini nŋɛ, nɔ iyi bɛ wɑ nyisi iyi ì wɑɑ too idɔɔbii ɑrɑ nŋɛi. Isɛɛnɛ nŋɛ ŋɑ mɔ í yɛi bɛi ti inɛi ɑndunyɑ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Bii inɛ ɡɔ nŋɛ wɑ ni ti Pɔlui nŋu í jɛ, nɔ inɛ ɡɔ mɔ wɑ ni ti Apoloi nŋu í jɛ, iŋɛ mɔ i kù tiɑ inɛi ɑndunyɑ ŋɑ iyi ɑ̀ ɡbe ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Yooi í jɛ Apolo. Mɑ̀ yooi í jɛ Pɔlu. Awɑ tɑkɑ nwɑ mɔ ɑmɑɑcɛi Ilɑɑɔ̃ ŋɑi. Awɑ fei, icɛ iyi Lɑfɛ̃ɛ í dɑsi wɑi ɑ̀ wɑɑ ce, ku bɑ i dɑsi nɑɑnɛ ŋɑ do sɑɑbui icɛ nwɑ. ");
INSERT INTO mkl_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Iŋɛ ì yɛi bɛi ikoi Ilɑɑɔ̃ ŋɑ tenɡi bii ɑ̀ ɡbɛ̃ ideɛ. Amu ǹ yɛi bɛi inɛ iyi wɑ ɡbɛ̃, Apolo mɔ bɛi inɛ iyi wɑ fɑ̃si inyi, ɑmmɑ Ilɑɑɔ̃i í jɔ̀ wɑ lɑ. ");
INSERT INTO mkl_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Nɑ nŋu, inɛ iyi wɑ ɡbɛ̃ do inɛ iyi wɑ fɑ̃si inyi ɑ kù jɛ nɡɔɡɔ, bii kù jɛ Ilɑɑɔ̃ iyi í jɔ̀ wɑ lɑ. ");
INSERT INTO mkl_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Woo ɡbɛ̃ do woo muɑ inyi ɑŋɑ fei ɑkɑ̃i, nɔ ɑŋɑ fei ɑɑ bɑ ribɑ nŋɑi si bɛi icɛ nŋɑ í to. ");
INSERT INTO mkl_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Ntɔ ntɔ ɑwɑ ɑ̀ wɑɑ ce icɛi do Ilɑɑɔ̃ ɑjɔ, nɔ iŋɛ ì yɛ ŋɑi bɛi ikoi Ilɑɑɔ̃. Iŋɛi ì yɛ mɑ́ ŋɑi bɛi ile iyi Ilɑɑɔ̃ wɑ mɑ. ");
INSERT INTO mkl_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Amu mɔ, nɑ sɑɑbui didɔ̃ iyi Ilɑɑɔ̃ í ceem, ɑmui ǹ nyɔ icui ileu bɛi woo mɑ iyi í nɛ lɑɑkɑi. Nsɛi inɛ mmu ɡɔi wɑ mɑ si ɑntɑɛ. Ammɑ inɛ fei ku ce lɑɑkɑi si yɑɑse bɛi wɑ mɑ si. ");
INSERT INTO mkl_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Iyi í jɛ idei icui ileu, ɑ̀ nyɔɔ tɑ̃ nɔ inɛ ɡɔ kɑɑ yɔkɔɛ ku nyɔ mmuɛ ɡɔ mɑ́. Jesu Kirisii í nɔ í jɛ icui ileu. ");
INSERT INTO mkl_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Nɔ inɛ ŋɑ iyi ɑ̀ wɑɑ mɑ si ɑntɑɛu, ti inɛ ɡɔ ŋɑ í yɛi bɛi ɑ̀ wɑɑ mɑ do wurɑ wɑlɑkɔ do isɔ jiidɑ wɑlɑkɔ do dimii kutɑ ku dɑɑnɑ ɡɔ ŋɑ . Ti inɛ ɡɔ ŋɑ mɔ í yɛi bɛi ɑ̀ wɑɑ mɑ do jĩi wɑlɑkɔ do tɑkɑ wɑlɑkɔ do fɔfɔ. ");
INSERT INTO mkl_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Ammɑ si ɑjɔi kiitiu Ilɑɑɔ̃ ɑ́ jɔ̀ icɛi inɛ fei ku fitɑ ɡbuɡbɑ̃ɑ. Ajɔ nŋu bɛi ɑ́ dɑsi icɛi inɛ fei si inɑ nɔ inɑui ɑ́ nyisi bɛi icɛi inɛ fei í yɛ. ");
INSERT INTO mkl_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Inɛ iyi kumɑɛ kù jo ɑ́ bɑ ribɑ. ");
INSERT INTO mkl_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ammɑ inɛ iyi icɛɛ í jo nŋui ɑ́ yɛ muse. Nŋu tɑkɑɛ ɑ́ bɑ fɑɑbɑ, ɑmmɑ ɑ́ yɛ bɛi inɛ iyi í cɑ̃ inɑ í fitɑò. ");
INSERT INTO mkl_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","I kù mɑ̀ ŋɑ iyi iŋɛi ì jɛ bi ku wɑi Ilɑɑɔ̃? I kù mɑ̀ ŋɑ iyi Hundeɛ í wɑ si ŋɛi? ");
INSERT INTO mkl_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Nɑ nŋu, bii inɛ ɡɔ í bɛjɛ bi ku wɑi Ilɑɑɔ̃, Ilɑɑɔ̃ mɔ ɑ́ bɛjɛ lɑfɛ̃ɛ. Á ce bɛɛbɛi si nɑ iyi í jɔ̀ bi ku wɑɛ í mɑ́, iŋɛi ì nɔ ì jɛ bi ku wɑu. ");
INSERT INTO mkl_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Inɛ ɡɔ ku mɑɑ̀ lɛlɛ ɑrɑɛ. Inɛ ɡɔ nŋɛ iyi í tɑmɑɑ nŋu í nɛ bisi si ɑndunyɑu ihɛ̃ ku jɔ̀ ku jɛ nnyɛi ku bɑ ku yɔkɔ ku jɛ ilu bisi ntɔ ntɔ. ");
INSERT INTO mkl_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Í sĩɑ ku ce bɛɛbɛi domi bisii ɑndunyɑ í yɛi bɛi idei sũmu si kuyɛi Ilɑɑɔ̃. Kukɔi idei Ilɑɑɔ̃ tɑkɑɛ í ni, Ilɑɑɔ̃ í yɑ mu ilu bisi ŋɑi do idei bisi lɑɑlɔi ɑŋɑ tɑkɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Kukɔi idei Ilɑɑɔ̃ í ni mɑ́, Aɔ̃ Lɑfɛ̃ɛ í mɑ̀ iyi lɑsɑbui ilu bisi ŋɑ nɡbɛi. ");
INSERT INTO mkl_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Mii fei tu ŋɛi. Nɑ nŋu, inɛ ɡɔ ku mɑɑ̀ tɔɔ fufu nɑ ɑmɑnɛ. ");
INSERT INTO mkl_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Hɑi Pɔlu do Apolo do Piɛɛ do ɑndunyɑ do kuwɛɛ do iku do iyi í wɛɛ nnyi do iyi wɑ nɑɑ ɑlɑ, fei ndɛɛ tu ŋɛi. ");
INSERT INTO mkl_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Iŋɛ mɔ ti Kirisii, Kirisi mɔ í jɛ ti Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Í sĩɑ i doo wɑ bɛi woo ce icɛi Kirisi ŋɑ iyi Ilɑɑɔ̃ í so idei ɑsiiɛ í dɑɑ si ɑwɔ. ");
INSERT INTO mkl_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Inɛ ŋɑ iyi ɑ̀ nɔ ɑ̀ dɑ nŋɑ mii ŋɑu si ɑwɔ í sĩɑ ɑ jɛ ilu nɑɑnɛ ŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Si kuyɛm kù jɛɛm tɑɑle bii ì wɑɑ kiitiim ŋɑ, wɑlɑkɔ bii ɑ̀ wɑɑ kiitiim si wɑjui ɑmɑnɛ ŋɑ. Bɑɑ ɑmu tɑkɑm, n ci yɑ kiiti ɑrɑm. ");
INSERT INTO mkl_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Do ntɔ, idɔm kù wɑɑ yɛ tɑɑlem, ɑmmɑ kù jɛ iyi bɛi wɑ nyisi iyi ǹ jɛ dee dee do ntɔ. Lɑfɛ̃ɛi ɑ́ kiitiim. ");
INSERT INTO mkl_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Nɑ nŋu, i mɑɑ̀ kiiti inɛ kɑ̃mɑ hɑi wɑɑti iyi Ilɑɑɔ̃ í jilɛu kù to. I deɡbe ɑjɔ iyi Lɑfɛ̃ɛ ɑ́ nyi wɑ. Mii iyi wɑ mɑnji si ilu kuku fei nŋui ɑ́ jɔ̀ ku fitɑ bɑntumɑ, nɔ ku jɔ̀ ɑ mɑ̀ lɑsɑbui idɔi ɑmɑnɛ ŋɑ. Wɑɑti bɛɛbɛi, inɛ fei ɑ́ ɡbɔ sɑɑbu iyi í jɛ tɛɛ hɑi bi Ilɑɑɔ̃. ");
INSERT INTO mkl_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Iŋɛ kpɑɑsim ŋɑ, ǹ so idei ɑmu do Apolou ihɛ̃i ku bɑ n nɑ ŋɛ ikɔ. Ǹ bi yɑɑse nwɑ ku nyisi ŋɛ bɛi ɑɑ ce i leekĩ si kukɔi idei Ilɑɑɔ̃ ŋɑ. Inɛ kɑ̃mɑ nŋɛ ku mɑɑ̀ tɔɔò inɛ ɑkɑ̃ fufu nɔ ku jɔ̀ inɛ ihɔ̃. ");
INSERT INTO mkl_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Ì tɑmɑɑ ì tiɑ inɛ ɡɔ ŋɑi? Mii ì nɛ ŋɑ iyi Ilɑɑɔ̃ kù mu nŋɛ. Mɑ̀ i kù mɑ̀ ŋɑ iyi nŋui í mu nŋɛ fei ndɛɛ. To, nɑ mii í ce ì wɑɑ tɔɔ fufu ŋɑ bɛi inɛ ŋɑ iyi ɑ̀ bɑ do ɑrɑ nŋɑ. ");
INSERT INTO mkl_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ì wɑɑ ce bɛi inɛ ŋɑ iyi ɑ̀ nɛ mii iyi ɑ̀ bi fei tɑ̃ ŋɑ, bɛi inɛ ŋɑ iyi ɑ̀ jɛ ilu ɑmɑni tɑ̃. Ì wɑɑ ce mɑ́ bɛi inɛ ŋɑ iyi ɑ̀ jɛ bommɑ nɔ ɑwɑ ɑ kù wɑ si. Á sĩɑ bii ì jɛ bommɑ do ntɔ ŋɑ ɑwɑɛ ŋɑ fei kɑ bubɑ si bommɑu ɑjɔ. ");
INSERT INTO mkl_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Ammɑ si kuyɛm, Ilɑɑɔ̃ í jilɛ ɑwɑ woo bɛ ŋɑui bɛi inɛi ɑnyi ŋɑ. À jɛ bɛi inɛ ŋɑ iyi ɑ̀ yɛ tɑɑle nŋɑ ku bɑ ɑ kpɑ ŋɑ . Í jɔ̀ ɑ̀ jɛ dɔ̃ɑnyi ŋɑ si wɑjui inɛ bɑɑ yoomɑ fei, hɑi ɑmɑlekɑ ŋɑ hee do ɑmɑnɛ ŋɑ fei. ");
INSERT INTO mkl_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Awɑ ɑ̀ wɑɑ cɔ wɑ bɛi sũmu ŋɑ nɑ irii Kirisi, ɑmmɑ iŋɛ ì wɑɑ cɔ ɑrɑ nŋɛ ilu bisi ŋɑ nɑ ɑnu ɑkɑ̃ nŋɛ do Kirisi. Awɑ ɑ kù nɛ ɡbuɡbɑ̃, ɑmmɑ iŋɛ ì wɑɑ cɔ ɑrɑ nŋɛ bɛi ilu ɡbuɡbɑ̃ ŋɑ. Iŋɛ ì jɛ ilu bɛɛrɛ ŋɑ ɑmmɑ ɑwɑ ɑ̀ jɛ hɑi nɛ bɛɛrɛ ŋɑ. ");
INSERT INTO mkl_vpl VALU