﻿USE sofia;
DROP TABLE IF EXISTS sofia.mjcNT_vpl;
CREATE TABLE mjcNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mjcNT_vpl WRITE;
INSERT INTO mjcNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ihya nyecú tandɨhɨ sɨvɨ nyɨvɨ ra Jesucristo tsa tsicoo̱ tsa ndi cumañi ca cacu ra. Nyɨvɨ ra David tan nyɨvɨ ra Abraham cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Sehe ra Abraham cuvi̱ tsi ra Isaac, tan sehe ra Isaac cuvi̱ tsi ra Jacob. Tan sehe ra Jacob cuvi̱ tsi ra Judá tsihin tandɨhɨ ra yañi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tan ra Fares tsihin ra Zara sehe ra Judá tsihin ña Tamar cuvi̱ tsi ra naha. Tan sehe ra Fares cuvi̱ tsi ra Esrom, ra cuvi̱ jutu ra Aram. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Tan sehe ra Aram cuvi̱ tsi ra Aminadab, jutu ra Naasón. Tan sehe ra Naasón cuvi̱ tsi ra Salmón. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Tan ra Booz, sehe ra Salmón tsihin ña Rahab cuvi̱ tsi ra. Tan sehe ra Booz tsihin ña Rut cuvi̱ tsi ra Obed, jutu ra Isaí. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Tan ra David, ra cuvi̱ rey, sehe ra Isaí cuvi̱ tsi ra. Tan sehe ra rey David tsihin ñaha tsa cuvi̱ ñasɨɨhɨ ra Urías cuvi̱ tsi ra Salomón. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Tan sehe ra Salomón cuvi̱ tsi ra Roboam, ra cuvi̱ jutu ra Abías. Tan sehe ra Abías cuvi̱ tsi ra Aza. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Tan sehe ra Aza cuvi̱ tsi ra Josafat, ra cuvi̱ jutu ra Joram. Tan sehe ra Joram cuvi̱ tsi ra Uzías. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Tan sehe ra Uzías cuvi̱ tsi ra Jotam, ra cuvi̱ jutu ra Acaz. Tan sehe ra Acaz cuvi̱ tsi ra Ezequías. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Tan sehe ra Ezequías cuvi̱ tsi ra Manasés, ra cuvi̱ jutu ra Amón. Tan sehe ra Amón cuvi̱ tsi ra Josías. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Tan sehe ra Josías cuvi̱ tsi ra Jeconías tsihin tandɨhɨ ra yañi ra. Tsicoo̱ ra naha quɨvɨ tɨɨ̱n ra ñuu Babilonia naha ra tsi nyɨvɨ Israel, tsa cua cuhun ñi cuvi ñi musu ra ñuu Babilonia can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tsa yaha̱ can, tan tsicoo̱ sehe ra Jeconías, tan ra ican cuvi̱ ra Salatiel, jutu ra Zorobabel. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Tan sehe ra Zorobabel cuvi̱ tsi ra Abiud, ra cuvi̱ jutu ra Eliaquim. Tan sehe ra Eliaquim cuvi̱ tsi ra Azor. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Tan sehe ra Azor cuvi̱ tsi ra Sadoc, ra cuvi̱ jutu ra Aquim. Tan sehe ra Aquim cuvi̱ tsi ra Eliud. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Tan sehe ra Eliud cuvi̱ tsi ra Eleazar, ra cuvi̱ jutu ra Matán. Tan sehe ra Matán cuvi̱ tsi ra Jacob. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Tan ra Jacob cuvi̱ jutu ra José, yɨɨ ña María. Juvin ña cuví sɨhɨ ra Jesús ra cuví Cristo, o cuñí tsi catyí, ra tsa jaquitsi̱ Nyoo tyin quɨhɨ ndaha tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tacan tsicoo̱ utsi cumi taahan tata ra Abraham nda cuanda cacu̱ ra David. Tan ra David, tsicoo̱ utsi cumi tata ra nda cuanda quɨvɨ tɨɨ̱n ra ñuu Babilonia naha ra tsi nyɨvɨ Israel. Tan nda cuanda quɨvɨ can tsicoo̱ utsi cumi ca tata ñi nda cuanda quɨvɨ cacu̱ ra Cristo. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tyehen cuvi̱ tan cacu̱ ra Jesucristo: tsa yaha̱ cundaa̱ tyiñu tsa cua tindaha ña María tsihin ra José. Tan tsa ndi cumañi ca naquihin ra tsi ña, ñihi̱ sehe ña tsa cuenda Tatyi Ii Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tan ra José, ra cua cuvi yɨɨ ña, vaha xaan iñi ra. Ña cuñí ra cuhva ra ticanuu tsi ña. Yacan cuenda tsica̱ iñi ra tsa nacoo xeehe ra tsi ña tan ña cua tindaha ca ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tan tsitsi tsa tsicá iñi ra yacan, quituvi̱ iin ángel Jutu Mañi yo nuu ra nu quixí ra. Tan nyehe̱ ra ñumaahna, tan catyí ángel can tsihin ra: ―José, tata ra David, ña ca̱ca iñi un quihin un tsi ña María cuvi ña ñasɨɨhɨ un, tyin sehe ña tsa cua cacu, sehe Tatyi Ii Nyoo cuví tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tan tsa yaha cacu lee can, cua jacunañi un tsi ra: Jesús. Tacan cua cunañi ra tyin cua jacacu ra tsi nyɨvɨ ra tsa iyó cuatyi ñuu ñayɨvɨ ―catyí ángel can tsihin ra José. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tacan cuvi̱ tyin tacan tan cundaa tsa caha̱n ra cuvi̱ ndusu yuhu Jutu Mañi yo taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tan catyi̱ ra tyehen: Ñaha yoco tsa ñaha ca coo yɨɨ, cua cuhun sehe ña. Tan cua coo iin sehe ña. Tan cua cunañi ra: Emanuel. Tan sɨvɨ can cuñí tsi catyi: “Nyoo iyó ra tsihin yo.” ");
INSERT INTO mjcNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tan tsa ndoto̱ ra José, javaha̱ ra tumaa catyi̱ ángel can tsihin ra. Quihi̱n ra tsi ña María tyin cuvi ña ñasɨɨhɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Maa tyin ña quixi̱ ra tsihin ña nda cuanda tsa yaha̱ cacu̱ sehe ña. Tan jacunañi̱ ra tsi lee can: Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Cacu̱ ra Jesús ñuu Belén tsa canyií nu cuví Judea. Tan quɨvɨ can ra cuví rey Judea nañí ra Herodes. Tacan tan tsaa̱ juhva ra naha nda ñuu Jerusalén. Quee̱ ra naha ityi nu caná ñicanyii. Tan ra tsitó xaan cuví ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tsica̱ tuhun ra naha tsi nyɨvɨ tan catyí ra naha: ―¿Nu maa nyií ra cuví rey cuenda nyɨvɨ Israel? Tyin ityi nu caná ñicanyii nyehe̱ ndi tiñuu tsa tsahá cuenda tyin cacu̱ ra ityi ihya. Tan vatsí ndi vatsí jacahnu ndi tsi ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Quɨvɨ tsa tsito̱ ra rey Herodes tsa caha̱n ra can naha ra, tuñu xaan cuñí ra cuvi̱. Tacan tucu tandɨhɨ nyɨvɨ ñuu Jerusalén can. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tacan tan cana̱ ra Herodes tsi tandɨhɨ ra jutu tsa cuví ityi nuu tsihin ra cuví jutu tan tsihin tandɨhɨ ra cuví maestro cuenda ley vehe ñuhu naha ra. Tan tsica̱ tuhun ra tsi ra naha numaa nda taahán tsi cacu ra Cristo. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tan nacaha̱n ra can naha ra tan catyí ra naha: ―Ñuu Belén tsa canyií Judea, ndacan taahán tsi cacu ra tyin tyehen tyaa̱ ra cuvi̱ ndusu yuhu Nyoo nu tutu taha̱n tsanaha: ");
INSERT INTO mjcNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Tan yooho Belén ñavin iin ñuu luhlu ñi cuví un tsa nuu tandɨhɨ maa ñuu tsa cayucú Judá tyin nuu yooho cua quita ra cua quɨhɨ ndaha tsi nyɨvɨ ñuu yu Israel. Maa ra cua jaha cuenda ra tsi ñi. Tacan catyí nu tutu Nyoo, ―catyí ra can naha ra tsihin ra Herodes. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tacan tan cana̱ xeehe ra Herodes tsi ra tsitó xaan can naha ra, tan tsica̱ tuhun ra tsi ra naha náa quɨvɨ tan náa hora quituvi̱ tiñuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tacan tan jacuhu̱n ra tsi ra naha nda ñuu Belén, tan catyí ra tsihin ra naha: ―Cu̱aahan ndo, tan nda̱ca tuhun vaha ndo tsa cuenda ra lee can. Tatun nañihi ndo tsi ra, qu̱itsi ca̱tyi tuhun ndo tsihin yu, tyin cuhun ndɨhɨ yu cujacahnu yu tsi ra ―catyí ra Herodes tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tsa tsiñi̱ ra tsa tsitó xaan can naha ra tsa caha̱n ra Herodes, tan quihi̱n ra naha ityi cuahán ra naha. Tan tiñuu tsa nyehe̱ ra naha ityi nu caná ñicanyii can, cuahán tsi ityi nuu ra naha. Tan tsicuɨñɨ̱ tsi maa maa sɨquɨ nu canyií ra lee can. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tan tsa nyehe̱ ra tsitó xaan can naha ra tyin tsicuɨñɨ̱ tiñuu can, sɨɨ xaan cuñí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tan quɨhvɨ̱ ra naha tsitsi vehe nu canyií lee can. Tan nyehe̱ ra naha tsi ra tsihin ña María, sɨhɨ ra. Tan tsicuɨñɨ̱ tsɨtɨ ra naha tyin jacahnu ra naha tsi lee can. Tacan tan nuña̱ ra naha yuhu caja tsa ndahá ra naha. Tan tava̱ ra naha regalo tsa cuví xuhun cuaan, tan cutu vixi, tan ndutya tami tsa nañí mirra. Tan tsaha̱ ra naha tsi lee can. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tsa yaha̱ tsa nyehe̱ ra naha tsi ra Jesús tan cuanuhu̱ ra naha. Tan tsa cuanuhu̱ ra naha nyehe̱ ra naha ñumaahna tan catyí tsi tyin ña taahán tsi cuhun ra naha cucatyi tuhun ra naha tsihin ra Herodes. Yacan cuenda sɨɨn ityi cuanuhu̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tsa yaha̱ cuahán ra tsa tsitó xaan can naha ra, tacan tan iin ángel Jutu Mañi yo quituvi̱ nuu ra José tsitsi ñumaahna. Tan catyí ángel can tsihin ra: ―Ndu̱vita, qu̱ihin tsi lee ihya, tsihin sɨhɨ ra, tan cu̱hun ndo nda ñuhu Egipto. Ndo̱o ndo ndacan nda cuanda cahan nyico yu tsihin un. Tyin ra Herodes cua nanducu ra tsi ra lee ihya tyin cuñí ra cahñi ra tsi ra ―catyí ángel can tsihin ra José. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tacan tan nduvita̱ ra José tsacuaa can. Tan quihi̱n ra tsi lee can tsihin sɨhɨ tsi. Tan cuahán ñi nda Egipto. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ndacan tsicoo̱ ñi nda cuanda tsa tsihi̱ ra Herodes. Tacan cuvi̱ tyin cundaa̱ tsa caha̱n ra cuvi̱ ndusu yuhu Jutu Mañi yo taha̱n tsanaha jaha̱ Nyoo. Tyehen catyi̱ ra: “Nda Egipto cana̱ yu tsi Sehe yu”, catyi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tsa ndi cumañi ca cúu ra Herodes tan ndi ndatú ra tsa quitsi nyico ra tsitó xaan can naha ra tan tsa tuvi̱ iñi ra Herodes tyin ra tsitó xaan can naha ra jandavi̱ ñaha ra naha tsi ra, tan nduxaa̱n xaan ra. Tan tava̱ tyiñu ra na cahñi andaru tsi tandɨhɨ ra nyihi tsa iyó ñuu Belén can tan inga ñuu tsa cayucú yatyin ñi, ra nyihi tsa ndi cacu̱ nda cuanda ra nyihi tsa uvi cuiya. Tacan javaha̱ ra tyin tsicá iñi ra tyin tacan cuiya ra Jesús tumaa catyi̱ ra tsitó xaan can naha ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tacan cuvi̱ tyin cundaa̱ tsa caha̱n Nyoo tan tyaa̱ ra Jeremías, ra cuvi̱ ndusu yuhu ra taha̱n tsanaha. Tyaa̱ ra tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Tsiñí yo iin ndusu ñuu Ramá, tsacú tsaa nyɨvɨ, tan iyo taahán ñi. Juvin ñi nyɨvɨ cuví tata ña Raquel, nyɨvɨ Israel, tsacú tsaa ñi tsa cuenda sehe ñi. Maa tyin ña cuñí ñi tsa naquihin ndaahvi nyɨvɨ tsi ñi tyin tsa yaha̱ tsihi̱ sehe ñi, catyí tsi nu tutu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Maa tyin tsa yaha̱ tsa tsihi̱ ra Herodes, tacan tan quituvi̱ nyico iin ángel Jutu Mañi yo nuu ra José nu quixí ra nda Egipto. Tan catyí ra tsihin ra: ");
INSERT INTO mjcNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Ndu̱vita, qu̱ihin tsi lee ihya tsihin sɨhɨ ra. Tan cu̱nuhu nyico ndo nda Israel, tyin tsa tsihi̱ nyɨvɨ nducu̱ cahñi tsi ra lee ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tacan tan nduvita̱ ra José, tan quihi̱n ra tsi lee can tan tsihin sɨhɨ ra. Tan cuanuhu̱ ñi nda Israel. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Maa tyin quɨvɨ tsito̱ ra José tyin ra Arquelao, sehe ra Herodes, cuví ra rey nda Judea, nayuhvi̱ ra tan ña cuñí ra cuhun ra ndacan. Tan cuanuhu̱ ñi nda Galilea tyin tacan jacoto̱ Nyoo tsi ra tsitsi ñumaahna. ");
INSERT INTO mjcNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tsa tsaa̱ ñi ican, tan cuahán ñi nda ñuu Nazaret, cua coo ñi. Tan ican tsicoo̱ ñi. Tacan cuvi̱ tyin cundaa̱ tsa caha̱n ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Tyin catyi̱ ra naha tyin ra Jesús ra ñuu Nazaret cua cuvi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Quɨvɨ tsa ndi iyó ñi ñuu Nazaret, ra Juan, ra jacoondutyá tsi nyɨvɨ, cuahán ra nu tsɨquɨ tsa iyó Judea. Tan quitsaha̱ caahán ra tuhun Nyoo tsihin nyɨvɨ tsa tsaá nu nyií ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tan catyí ra: ―Ndu̱ uvi iñi ndo cuatyi ndo tyin tsa cuñí tsaa quɨvɨ cundaca ñaha Nyoo tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juvin ra Juan cuví ra tsa caha̱n ra Isaías ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Tan tyaa̱ ra tsa tsaha̱ Nyoo tsi ra tyehen: Cua tyaa soho yo ndusu ra nu caná tsaa ra nu tsɨquɨ tan catyí ra: “Nu̱ña ndo iin ityi cuɨtɨ. Tan natyiso vaha ndo tsi ndo tyin tsa vatsi Jutu Mañi yo,” catyí tuhun tsa tyaa̱ ra Isaías. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tan ra Juan nditsí ra jahma tsinu̱ tsihin ixi camellu. Tan cinturón ra, ñɨɨ cuví tsi. Tan tica xama tsatsí ra tan tsihí ra ndutya ñuñu. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Quitsi̱ nyɨvɨ ñuu Jerusalén tan tandɨhɨ ñuu tsa cayucú Judea, tan nyɨvɨ tsa iyó yatyin ñi ityi yutya cahnu Jordán can; quitsi̱ tyaa soho ñi tuhun caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tan tsa yaha̱ nahma̱ ñi cuatyi ñi, ra Juan jacoondutya̱ ra tsi ñi yutya cahnu Jordán ican. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Maa tyin nyehe̱ ra Juan tyin cuaha xaan ra fariseo, ra tsa tyaá yahvi xaan ley vehe ñuhu, tan cuaha xaan ra saduceo, quitsi̱ ra naha tyin coondutya ra naha. Tan catyí ra tsihin ra naha: ―¡Nyooho, tumaa tata coo xaan cuví ndo! ¿A cuñí maa ndo tyin tsihin tsa coondutya ñi ndo tan ña cua tatsi tuñi ca Nyoo tsi ndo? Ña cuví. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Na̱sama ndo cuhva iyó ndo, na nyehe yo tyin tsa ndu uvi̱ iñi ndo cuatyi ndo nuu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Maa tyin ña ndu̱yaa ndo tan catyí ndo tyin nyɨvɨ tata ra Abraham cuví ndo. Tyin vasu tsihin yuu ihya, Nyoo cuví jananduvi ra nyɨvɨ ra Abraham. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tsa ndatú yatsa Nyoo tsi tandɨhɨ ndo tsa cuví ndo tumaa yutun tsa ña tsahá tsɨtɨ vaha. Cua tyahnya tun tan cua cayu tun, tacan cua javaha Nyoo tsihin ndo ―catyí ra Juan―. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tsa nditsa tyin yuhu jacoondutyá yu tsi nyɨvɨ tsihin ndutya, tan cuví tsi iin seña tyin tsa ndu uvi̱ iñi ñi cuatyi ñi. Maa tyin tsa yaha jacoondutya yu tsi ñi tsihin ndutya, vatsí inga ra cua jacoondutya tsi ñi tsihin Tatyi Ii Nyoo tan tsihin ñuhu̱ ihñi. Iyó ca tunyee iñi Nyoo tsi maa ra tan ñavin ca yuhu. Tan ndi tsa cuiso yu nditsan ra tan nduve yahvi nyaá yu, tyin maa ra cahnu ca cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tan ra ican ndahá ra pala tyin cua jandava ra trigu. Cua tava sɨɨn ra trigu vaha, tan cua natyihi vaha ra itsi. Tan cua cahmi ra tsahan tsa quita tsihin trigu can tsihin ñuhu̱ tsa ña cua ndahva maa ―catyí ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tacan tan quita̱ ra Jesús Galilea tan tsaa̱ ra yutya cahnu Jordán nu nyií ra Juan, tyin cuñí ra tsa jacoondutya ra Juan tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tsa jihna ñi ña cuñí ra Juan jacoondutya ra tsi ra, tan quitsaha̱ catyí ra tsihin ra: ―Cuñí un tsa jacoondutya yu tsi un, maa tyin ña taahán tsi tsa jacoondutya yu tsi un. Maa un taahán tsi jacoondutya tsi yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Maa tyin ra Jesús catyí ra tsihin ra: ―Tsa vityin, na cuvi tsi cuhva catyi̱ yu tsihin un. Tyin cuñí tsi tsa javaha yo tandɨhɨ tsa vaha tsa cuñí Nyoo ―catyí ra tsihin ra Juan. Tacan tan ndoo̱ ra Juan vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tsa yaha̱ tsicoondutya̱ ra Jesús tan quita̱ ra tsitsi ndutya. Tan nuña̱ andɨvɨ, tan ra Jesús nyehe̱ ra vatsí nuú Tatyi Ii Nyoo, tumaa iin paloma. Tan tsaa̱ tsi sɨquɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tacan tan caha̱n iin ndusu ityi andɨvɨ, tan catyí tsi tyehen: ―Ra ihya cuví Sehe yu, tan cuñí xaan yu tsi ra. Tan sɨɨ xaan cuñí yu tsihin ra ―catyí ndusu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tacan tan tsindaca̱ Tatyi Ii Nyoo tsi ra Jesús iin nu tsɨquɨ, tyin cua nducu cuhva nu ña vaha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tsicoo̱ nyitya ra uvi xico nduvi tan uvi xico tsacuaa. Tsa yaha̱ can tan quitsi̱ socó tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tacan tan natuhva̱ nu ña vaha nu nyaá ra, tyin cuñí nu nducu cuhva nu tsi ra. Tan catyí nu tsihin ra: ―Tatun Sehe Nyoo cuví tsi un, ca̱han tsihin yuu ihya, na nanduvi tsi paan ―catyí nu ña vaha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Maa tyin ra Jesús nacaha̱n ra tan catyí ra: ―Tuhun Nyoo tsa nyaá nu tutu catyí tsi tyin: “Ña maa ñi tsihin tsa catsi nyɨvɨ tan coonyito ñi, tyin coonyito ñi tsihin tandɨhɨ tuhun caahán Nyoo” ―catyí ra Jesús tsihin nu ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tacan tan quihi̱n nu ña vaha tsi ra. Tan cuahán ra tsihin nu nda ñuu ii Jerusalén. Tan jandaa̱ nu tsi ra jiñi vehe ñuhu cahnu. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tan catyí nu tsihin ra: ―Tatun Sehe Nyoo cuví tsi un, nda̱va nu nyaá un nu sucun ihya nda cuanda nu ñuhu. Tyin catyí tsi nuu tutu Nyoo tyehen: Nyoo cua tava tyiñu ra tsi ángel naha ra, cua jaha cuenda ra naha tsi un. Cua janahndɨ ra naha tsi un, tan ña cua nañi tsaha un nuu yuu. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tan nacaha̱n ra Jesús tan catyí ra: ―Tan juvin ñi catyí tuhun Nyoo: “Ña nducu cuhva un tsi Nyoo un” ―catyí ra Jesús tsihin nu ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tacan tan quihi̱n nu ña vaha tsi ra inga tsaha, tan cuahán ra tsihin nu iin jiñi yucu sucun. Tan janaha̱ nu tandɨhɨ tsa cahnu cuví nu ndacá ñaha rey tan ra cumí tyiñu naha ra tsi nyɨvɨ iyó nu ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tan catyí nu tsihin ra: ―Yuhu cuhva yu tandɨhɨ maa tsa janaha̱ yu tsi un, tatun yooho tan cuɨñɨ tsɨtɨ un nuu yu tan jacahnu un tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tacan tan nacaha̱n ra Jesús tan catyí ra tsihin nu: ―Cu̱aahan, cuihna. Tyin nyaá tuhun Nyoo catyí: “Ja̱cahnu tsi intuhun ñi maa Jutu Nyoo, tan ja̱ha tyiñu tyiñu ra.” ");
INSERT INTO mjcNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tacan tan cuahán nu ña vaha, tan ndoo̱ ra Jesús. Tan tsaa̱ ángel tan jatyinyee̱ ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Quɨvɨ tsa tsito̱ ra Jesús tyin ra Juan nyií ra vehe caa, cuahán ra nda Galilea. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Maa tyin ña ndoo̱ ra ñuu Nazaret, nu tsahnu̱ ra. Cuahán ra cua coo ra nda ñuu Capernaum, iin ñuu tsa canyií yatyin ñi yuhu miñi, nu ñuhu ra Neftalí yatyin ñuhu ra Zabulón. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tacan tan cundaa̱ tsa caha̱n ra Isaías, ra cuvi̱ ndusu yuhu Nyoo, taha̱n tsanaha. Tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñuhu ra Zabulón tan ñuhu ra Neftalí tsa cayucú yuhu miñi inga tsiyo yutya cahnu Jordán, tsa cuví Galilea nu iyó nyɨvɨ tsa ñavin nyɨvɨ Israel cuví. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nyɨvɨ iyó nu naa, ñi iyó nu iyó tixahñu tuhun tsiihi, nyehé ñi iin ñuhu̱ nditsin tsa jandunditsín nu yucú ñi, catyi̱ ra Isaías. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nda cuanda quɨvɨ can, tan quitsaha̱ caahán ra Jesús tuhun Nyoo tsihin nyɨvɨ, tan catyí ra tsihin ñi: ―Ndu̱ uvi iñi ndo cuatyi ndo tyin tsa cuñí tsaa quɨvɨ cundaca ñaha Nyoo tsi ndo ―catyí ra Jesús tsihin nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ra Jesús tsicá ra yuhu miñi tsa nañí Ndutya Ñuhu Galilea. Tan nyehe̱ ra tsi uvi taahan ra tsihin yañi ra, ra Simón tsa nañí tucu Pedro, tan ra Andrés. Ra tɨɨ́n tyaca cuví ra naha. Tan cañí ra naha traya ra naha nu ndutya. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tacan tan catyí ra Jesús tsihin nduvi taahan ra naha: ―Na̱ha ndo, qu̱itsi nyicun ndo tsi yu. Tan yuhu cua jatyinyee tsi ndo tyin tumaa tsa tɨɨ́n ndo tyaca, tacan cua ñihi ndo nyɨvɨ cua cuvi nyɨvɨ Nyoo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Juvin ñi cuhva can nacoo̱ ra naha traya can, tan cuahán ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Luxu ñi tsica̱ ra naha ityi nuu, tan nyehe̱ ra Jesús tsi inga uvi ca ra tsihin yañi ra: ra Jacobo tan ra Juan. Sehe ra Zebedeo cuví tsi ra naha. Yucú ra naha tsitsi iin yutun ndoo tsihin jutu ra naha naquicú ra naha traya. Tan cana̱ ra Jesús tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Juvin ñi cuhva can tan nacoo̱ ra naha tsi jutu ra naha tan yutun ndoo can, tan cuahán ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Cuahán ra Jesús tsicá ra tandɨhɨ ñuu cuenda Galilea jacuahá ra tsi nyɨvɨ tsitsi vehe ñuhu tan iin tan iin ñuu. Caahán ra tuhun vaha nácaa ndacá ñaha Nyoo tsi yo. Tan janduvaha̱ ra tsi nyɨvɨ cuuhví tsihin tandɨhɨ ñi nuu cuehe tsa yɨhɨ́ tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tacan tan tsito̱ tandɨhɨ nyɨvɨ ñuu cuenda Siria tuhun ra Jesús. Tan tsindaca̱ ñi tandɨhɨ nyɨvɨ cuuhví tsi ra: juhva ñi yɨhɨ́ tatyi ña vaha. Tan yɨhɨ́ ñi tsiihí naaha ñi. Tan yɨhɨ́ ñi ndohó ñi cuehe xii. Tan janduvaha̱ ra Jesús tsi tandɨhɨ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Cuaha xaan nyɨvɨ nyicún tsi ra Jesús: nyɨvɨ iyó ñuu tsa cayucú Galilea, nyɨvɨ tsa quee̱ nu utsi taahan ñuu tsa nañí Decápolis, nyɨvɨ iyó ñuu Jerusalén tan tandɨhɨ ca ñuu tsa cayucú Judea, tan nyɨvɨ iyó inga tsiyo yutya cahnu Jordán. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nyehe̱ ra Jesús tyin cuaha xaan nyɨvɨ, tan ndaa̱ ra iin nuu yucu. Tan tsicunyaa̱ ra ican. Tacan tan nyɨvɨ tsicá tsihin ra, tsinunduvi̱ ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tacan tan quitsaha̱ jacuahá ra tsi ñi tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nasocó Nyoo tsi tandɨhɨ nyɨvɨ tsa tsitó tyin tsiñí ñuhu ra tsi ñi, tan tsa cuenda ñi cuví nu ndacá ñaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Tan tandɨhɨ nyɨvɨ tsa cuiihya cuñí tsa cuenda cuatyi ñi, nasocó Nyoo tsi ñi tan ña cua coo ca ñi tucuiihya iñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Tan tandɨhɨ nyɨvɨ tsa ña cahnu jahá ñi tsi ñi, nasocó Nyoo tsi ñi, tan cua naquihin cuenda ñi ñuhu ñayɨvɨ tsa catyi̱ Nyoo tyin cuhva ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Tan tandɨhɨ nyɨvɨ tsa cuñí xaan javaha cuhva catyí Nyoo, nasocó Nyoo tsi ñi, tan cua jatyinyee ra tsi ñi tan cua cuvi javaha ñi cuhva cuñí maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Tan tandɨhɨ nyɨvɨ tsa cundaahví iñi tsi inga nyɨvɨ, nasocó Nyoo tsi ñi, tan cua cundaahvi iñi ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Tan tandɨhɨ nyɨvɨ tsa janduvaha̱ Nyoo añima, nasocó ra tsi ñi, tan cua nyehe ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Tan nyɨvɨ tsa nducú cuhva tsa coo vaha nyɨvɨ tsihin Nyoo tan tsihin inga nyɨvɨ, nasocó ra tsi ñi tan cua catyi ra tyin sehe ra cuví tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Tan tandɨhɨ nyɨvɨ tsa javahá cuhva cuñí Nyoo tan ndasɨ cuñí nyɨvɨ nyehe ñi tsi ñi, nasocó Nyoo tsi ñi, tan tsa cuenda ñi cuví nu ndacá ñaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Nasocó Nyoo tsi nyooho tsa caahán nyɨvɨ ndavaha ñi tsata, tan javahá ñi tsa uhvi tsi ndo, tan caahán ñi cuendu tsa ña nditsa sɨquɨ ndo tsa cuenda tsa tsinú iñi ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cu̱sɨɨ iñi ndo tun tacan javahá nyɨvɨ tsihin ndo; sɨɨ cu̱ñi ndo, tyin cahnu xaan tan sɨɨ xaan caá tsa cua ñihi ndo nda gloria. Tyin juvin ñi tacan javaha̱ nyɨvɨ tsa ña vaha tsihin tandɨhɨ ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Nyooho tsa tsinú iñi tsi yu, tumaa ñɨɨ vaha cuví ndo. Maa tyin tatun ñɨɨ, tan ndɨhɨ tsa uhva tsi, ña cua jandu uhva ca tsi tsa catsi yo. Ña vaha ca ñɨɨ can. Tacan tan javita yo can, tan cuañi nyɨvɨ tsata can. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nyooho cuví ndo tumaa ñuhu̱ tsa jandunditsín nu tsicá nyɨvɨ. Iin ñuu tsa canyií jiñi iin yucu, ña cua cuvi quɨhɨ xeehe tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ña tuhvá yo tyaá ñuhu̱ tyuma, tan tyihí xeehe yo itsi tsitsi iin caja. Tyin tuhvá yo tyaá ñuhu̱ tan tinyií yo itsi iin nu sucun tyin tacan tan jandunditsin tsi nu yucú yo tsitsi vehe yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tan tacan taahán tsi jandunditsin tucu nyooho tsihin ñuhu̱ Nyoo tsa iyó añima ndo nu tsicá nyɨvɨ. Tacan tan nyehe ñi tsa vaha tsa javahá ndo, tan jacahnu ñi tsi Jutu yo Nyoo, ra nyaá gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ña cu̱ñi ndo tyin yuhu vatsí janaa yu ley tsa tsaha̱ Nyoo tsi ra Moisés tyin tyaa ra. Tan ndi ña vatsí janaa yu tuhun tsa tyaa̱ tandɨhɨ ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Ñavin tyiñu can vatsí yu. Yuhu vatsí yu vatsí tyaa yahvi yu tsa caahán ley can, tan catyi tuhun yu tsihin ndo náa cuñí tsi catyí ley can. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tsa nditsa catyí yu tsihin ndo tyin tsitsi tsa ndi iyó ñuhu ñayɨvɨ tan andɨvɨ, ña cua naa ndi luxu ley tsa tyaa̱ ra Moisés tyin tandɨhɨ maa tsa tyaa̱ ra naha tan cua cundaa tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yacan cuenda, ra tsa ña tyaá yahvi cuhva catyí Nyoo, vasu iin tsa luhlu ñi; tan janahá ra tsi nyɨvɨ na javaha ñi tacan, luxu cuii ñi cua cuvi ra nu ndacá ñaha Nyoo. Maa tyin ra tsa tyaá yahvi tandɨhɨ, tan janahá ra tsi inga nyɨvɨ, cahnu xaan cua cuvi ra nu ndacá ñaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Catyí yu tsihin ndo tyin tun ña tyaá yahvi vaha ca ndo tsi Nyoo tan ñavin ca tumaa javahá ra cuví maestro cuenda ley vehe ñuhu naha ra, tan ra cuví fariseo naha ra, ña cuvi quɨhvɨ ndo nu ndacá ñaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Nyooho tsa cuaha tsaha tsiñi̱ ndo tsa catyi̱ Nyoo tsihin nyɨvɨ tsicoo̱ taha̱n tsanaha. Catyi̱ ra: “Ña cahñi ndo tsi nyɨvɨ, tyin tatun cahñi ndo nyɨvɨ, taahán tsi tsa cutuñi ndo.” ");
INSERT INTO mjcNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Maa tyin yuhu, catyí yu tsihin ndo, tyin vasu tsa cuxaán ñi ndo tsi iin nyɨvɨ, vasu tsa caahán nyaa ñi ndo tsi ñi, taahán tsi tsa cutuñi ndo nu ra cumi tyiñu. Tan tatun catyí ndo tyin soho xaan caá ñi, taahán tsi cuhun ndo anyaya tsa cuenda cuatyi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Tan yacan cuenda quɨvɨ cuahán un vehe ñuhu, tan ndahá un tsa cua jamañi un tsi Nyoo, tan nducuhún iñi un tyin iyó tsa javaha̱ un tsi yañi un, ");
INSERT INTO mjcNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na̱coo tsa cuahán tsihin un ityi nu altar vehe ñuhu. Tan cu̱hun jihna un ndacan un tucahnu iñi tsi yañi un. Tacan tan cuhun un nda vehe ñuhu inga tsaha, tan cu̱hva cuenda un tsa cua jamañi un tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tatun iin ra tsicán cuatyi tsaha un, tan cuahán un tsihin ra nda nu nyaá ra cumí tyiñu, ndu̱cu cuhva cahan un tsihin ra tyin tacan tan ña cundaca ra tsi un nu nyaá ra cumí tyiñu, tyin ra cumí tyiñu can cua nacuhva cuenda ra tsi un tsi ra juez. Tan ra juez can cua nacuhva cuenda ra tsi un tsi ra vitya naha ra. Tan ra vitya can cua tyihi ra naha tsi un vehe caa. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tan tsa nditsa catyí yu tsihin un tyin tun ña javaha un tacan ña cua tava ra naha tsi un vehe caa tun ña cua tyahvi un tandɨhɨ xuhun tsa cua ndacan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Nyooho tsa tsiñi̱ ndo tyin catyi̱ Nyoo taha̱n tsanaha tyin nyooho tsa iyó ñasɨɨhɨ, ña cua coo inga ñaha tsi ndo, tan ndi ñaha tsa iyó yɨɨ tan ña taahán tsi coo inga rayɨɨ tsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Maa tyin yuhu catyí yu tsihin ndo, nyooho tsa nyehé iin ñaha tan cuñí ndo coo ndo tsihin ña, tsa tsicoo̱ cuatyi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Tatun tinuu cuaha un janacavá tsi un tsitsi cuatyi, vaha taxin ca ta̱va un tinuu un tan ja̱vita un can. Tyin vaha ca quɨhvɨ un nu ndacá ñaha Nyoo tsihin intuhun ñi tinuu un, tan ñavin ca tsa cuhun un anyaya tsihin nduvi taahan tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","O tatun iin ndaha un janacavá tsi un tsitsi cuatyi, vaha taxin ca ca̱hnya un ndaha un tan ja̱vita un can. Tyin vaha ca tsa quɨhvɨ un nu ndacá ñaha Nyoo tsihin tsa lundu ndaha un, tan ñavin ca tsa nanɨɨ un tan cuhun un anyaya. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Tan juvin ñi catyi̱ Nyoo tsihin nyɨvɨ tsicoo̱ taha̱n tsanaha tyin yóo ra nacoo ihñi ñasɨɨhɨ ra, cuñí tsi tsa canɨ ra tutu tsa tindaha̱ ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Maa tyin catyí yu tsihin ndo tyin nduve ndatu iyó tsi rayɨɨ tsa nacoo ra ñasɨɨhɨ ra tatun ña quituvi̱ ña tsihin inga rayɨɨ. Tyin tatun nacoo ra tsi ña, tan ñavin tsa cuenda cuatyi can, cua coo cuatyi ra nuu Nyoo. Tan tatun quihin ña inga rayɨɨ cua coo ndɨhɨ cuatyi ña. Tan tacan ra tsa cua quihin tsi ña cua coo ndɨhɨ cuatyi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Tan tsiñi̱ ndɨhɨ ndo, tyin catyi̱ tucu Nyoo tsihin nyɨvɨ tsicoo̱ taha̱n tsanaha: “Tatun catyí ndo ‘naha Nyoo maa’ tyin cua javaha ndo iin tsa cua javaha ndo nuu ra, taahán tsi tsa javaha ndo can tan ña jandavi ñaha ndo.” ");
INSERT INTO mjcNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Maa tyin yuhu catyí yu tsihin ndo tyin ña cahan ndo “naha Nyoo maa”. Tan ña ca̱han ndo tuhun andɨvɨ, tyin yacan cuví nu nyaá Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tan ndi tuhun ñuhu ñayɨvɨ ihya ña ca̱han ndo, tyin ihya cuví nu tsañí Nyoo. Tan ndi ña ca̱han ndo tuhun ñuu Jerusalén, tyin ican cuví ñuu maa Nyoo tsa cuví ra Rey cahnu ca. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tan ndi ña ca̱han ndo tuhun jiñi ndo, tyin ña cuvi janducuitsin ndo tan ndi tsa jandutuun ndo ndi intuhun ixi jiñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Vaha ca ca̱han ndo iin ndaha ñi tun nditsa o tun ña nditsa tsa caahán ndo. Tyin tsa catyí ndo “naha Nyoo maa” nu ña vaha jacahán tsi ndo tsa cahan ndo tacan. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tan tsiñi̱ tucu ndo tsa catyi̱ Nyoo taha̱n tsanaha: “Tatun cañí nyɨvɨ tsi ndo, tan tavá ñi iin nuhu ndo, o iin tinuu ndo, taahán tsi tyin javaha ndɨhɨ ra cumi tyiñu tacan tsihin ñi, tumaa tsa javaha̱ ñi tsihin ndo.” ");
INSERT INTO mjcNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Maa tyin yuhu catyí yu tsihin ndo, tyin ña ja̱vaha ndo tsa ña vaha tsa javahá nyɨvɨ xaan cuñí nyehe tsi ndo. Tyin tun yóo cañí iin tsiyo nuu ndo, taahán tsi tsa cuhva ndɨhɨ ndo inga tsiyo na cañi ndɨhɨ ñi, tan ña cu̱xaan ndo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","O tatun tsicán ñi cuatyi tsaha ndo, tan cuñí ñi quihin nyaa ñi iin camisa ndo. Taahán tsi cuhva ndɨhɨ ndo chamarra ndo tsi ñi tan ña cua cuxaan ndo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O tatun yóo cuñí cundaca ndo ndaha tyiñu ñi iin kilómetro, taahán tsi cundaca ndo can uvi kilómetro. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tatun yóo nyɨvɨ tsicán tumañi iñi tsi ndo, cu̱hva ndo tsa nducu ñi. Ña ca̱tyi ndo tyin ña javaha ndo tumañi iñi can tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Tan tsiñi̱ tucu ndo tyin catyi̱ Nyoo taha̱n tsanaha: “cu̱ñi ndo tsi ra vaha iñi tsi ndo. Tan xaan cu̱ñi ndo nyehe ndo tsi ra xaan iñi tsi ndo.” ");
INSERT INTO mjcNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Maa tyin yuhu catyí yu tsihin ndo, cu̱ñi ndo tsi nyɨvɨ xaan iñi tsi ndo. Tan ja̱vaha ndo tsa vaha tsihin nyɨvɨ caahán tsi ndo, tan tsi nyɨvɨ ña cuñí nyehe tsi ndo. Tan nda̱can tahvi ndo tsi Nyoo tsa cuenda nyɨvɨ tsa caahán nyaa tsi ndo tan tsa cuenda ñi tsa jacuví tsa uhvi tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tatun javahá ndo tacan, cuví ndo sehe Jutu yo ra nyaá gloria. Tyin maa ra jacaná ra ñicanyii, tan jacuún ra savi nuu tyiñu jahá nyɨvɨ vaha tan nyɨvɨ ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tatun nyooho tan cuñí ndo tsi nyɨvɨ vaha iñi tsi ndo tan ndasɨ cuñí ndo nyehe ndo tsi nyɨvɨ xaan iñi tsi ndo, nduve tsa vaha cua ñihi ndo. Tyin juvin ñi tacan javahá tucu ra tavá xuhun cuenda ra ndacá ñaha nda ñuu Roma. Tan cuñí maa ndo tyin quiñi xaan iyó ra can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tatun tsahá ndo nacumi tsi maa ñi ra tsa vaha iñi tsi ndo tan ña jacuu ndo tacan tsihin inga ca nyɨvɨ, nduve tsa vaha xaan javahá ndo. Tyin juvin ñi tacan javahá nyɨvɨ tsa ña tsitó tuhun Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tumaa Jutu yo tsa nyaá gloria cuɨtɨ xaan iyó ra, tacan taahán tsi coo tucu nyooho. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ja̱ha ndo cuenda tan ña nduyaa ndo náa tumañi iñi javaha ndo tsi nyɨvɨ. Tyin tatun javaha ndo tumañi iñi tyin nyehe nyɨvɨ, Jutu yo, ra nyaá gloria, nduve náa cua cuhva ra tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tun cua javaha ndo tumañi iñi, ña cua jacoto ndo tsi inga nyɨvɨ tyin javahá ndo tumañi iñi. Ña ja̱vaha ndo tumaa icá ra tsa jahá tyin vaha xaan ra tan tsicá nuu ra naha nuyahvi tan tsitsi vehe ñuhu. Javahá ra naha tumañi iñi tyin na catyi nyɨvɨ tyin vaha xaan iñi ra naha. Yacan ñi ñihi̱ ra can naha ra, tan nduve náa cua cuhva Nyoo tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yacan cuenda quɨvɨ javahá ndo tumañi iñi tsi nyɨvɨ ndaahvi, ña ja̱coto ndo ndi tsi ra tsa vaha xaan ca iñi tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Xeehe ñi ja̱tyinyee ndo tsi ñi ndaahvi. Tan Jutu yo Nyoo cua nyehe ra tsa javahá ndo tacan. Tan cua cuhva ra tsa vaha tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Tatun cua ndacan tahvi ndo tsi Nyoo, ña ja̱vaha ndo tumaa javahá ra tsa jahá tyin vaha xaan ra naha. Tyin ra ican naha ra tuhvá ra naha tsicán tahvi tsi Nyoo nu tuvi nyɨvɨ, tan nyecú nyityi ra naha tsitsi vehe ñuhu o ityi cahnu tyin taahán iñi ra naha tsa cahan nyɨvɨ tyin vaha xaan ra naha. Tsa nditsa catyí yu tsihin ndo tyin yacan ñi ñihi̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Maa tyin nyooho quɨvɨ tsa ndacan tahvi ndo tsi Nyoo, ña ndacan tahvi ndo tsi ra nu nyehe nyɨvɨ tsi ndo. Quɨ̱hvɨ ndo tsitsi vehe ndo tan na̱casɨ ndo yuvehe ndo tan nda̱can tahvi ndo tsihin tsa nɨɨ iñi añima ndo. Tan intuhun ñi maa Nyoo Jutu yo cua nyehe ra tsa javahá ndo tacan tyin nuu maa ra tsicán tahvi ndo, tan ñavin nuu nyɨvɨ. Tan cua cuhva ra tsa vaha tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Tatun cua cahan ndo tsihin Nyoo, ñavin juvin ñi tuhun tsa nduve yahvi nyaa ca̱han ndo. Tacan javahá nyɨvɨ tsa ña tsitó tsi Nyoo. Cuñí maa ñi tyin tacan tan cua tyaa soho Nyoo tsa caahán ñi, tyin cuaha xaan tsaha caahán ñi juvin ñi tuhun tsa tsa yaha̱ caha̱n ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ña ja̱vaha ndo tacan. Tyin Nyoo tsa tsitó ra náa tsiñí ñuhu tsi ndo tsa ndi cumañi ca ndacan ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yacan cuenda nyooho, tatun cua ndacan tahvi ndo tsi Nyoo, tyehen ca̱tyi ndo: Jutu Mañi ndi, tsa nyaá un gloria. Jacahnú xaan ndi tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na quitsi tsa ndaca ñaha un nu ñuhu ñayɨvɨ ihya, tan na javaha tandɨhɨ nyɨvɨ tandɨhɨ cuhva cuñí maa un, tumaa cuví nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cu̱hva tsa catsi ndi tahan tahan quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ja̱ha tucahnu iñi tsi ndi náa tsa ña vaha javaha̱ ndi, tumaa tsa jahá maa ndi tucahnu iñi tsi nyɨvɨ tsa javahá tsa ña vaha tsi ndi. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ña cuhva un tsa nducu cuhva nu ña vaha tsi ndi, coto javaha ndi cuatyi nuu un. Tyin maa un cuví ra jacacú tsi ndi ndaha nu ña vaha. Tan maa un cuví ra ndacá ñaha tsi ndi. Tan iyó tandɨhɨ tunyee iñi tsi un. Tan taahán tsi tyin jacahnu tandɨhɨ nyɨvɨ tsi maa ñi un tandɨhɨ maa quɨvɨ tan na ña cundɨhɨ tsi. Na cuvi tsi tacan ñi. Tyehen taahán tsi ndacan tahvi ndo tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Tyin tatun nyooho tan jahá ndo tucahnu iñi tsi nyɨvɨ tsa javahá tsa ña vaha tsi ndo, tacan tucu Jutu yo ra nyaá gloria, cua jaha ra tucahnu iñi tsi maa ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Maa tyin tatun ña jaha ndo tucahnu iñi tsi nyɨvɨ tsa javahá tsa ña vaha tsi ndo, tacan tucu Jutu yo, ña cua jaha ra tucahnu iñi cuatyi maa ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tan catyí tucu ra Jesús tsihin nyɨvɨ: ―Quɨvɨ tsa iyó nyitya ndo tyin nanducú ndo tsi Nyoo, ña cuiihya nyehe ndo, tumaa javahá nyɨvɨ jahá tyin vaha xaan ñi. Tyin cahyɨ́ ñi nyaa nuu ñi tyin cuñí ñi tsa nyehe nyɨvɨ tyin iyó nyitya ñi tan nanducú ñi tsi Nyoo. Catyí yu tsihin ndo tyin yacan ñi ñihí ñi. Nduve ca naa cua cuhva Nyoo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Maa tyin nyooho quɨvɨ tsa iyó nyitya ndo tyin nanducú ndo tsi Nyoo, na̱catya ndo nuu ndo. Tan tyi̱hi ndo cuca jiñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tacan tan ña cua tuvi iñi nyɨvɨ tyin iyó nyitya ndo tan nanducú ndo tsi Nyoo. Tyin intuhun ñi maa Nyoo nyehé tsa javahá ndo tsa xeehe ñi. Tan cuaha tsa vaha cua cuhva ra tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ña ja̱caya ndo tsa cuca tsa iyó nu ñuhu ñayɨvɨ ihya. Tyin coto tɨvɨ tsi jaha tiquixin o jaha cuxi. O cuví quɨhvɨ ñasuhu, tan suhu nu tandɨhɨ tsa jacaya̱ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vaha ca ja̱caya ndo tsa cuca tsa iyó nda gloria. Tyin ña cua cundɨhɨ tsi ndacan. Tyin ña cuvi tɨvɨ tsi ndacan, tan nduve quɨtɨ jatɨvɨ itsi, ndi nduve ñasuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tyin nu natyihí vaha ndo tsa cuca, ican cua cunyaa ndɨhɨ añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Tinuu ndo cuví ñuhu̱ nditsin tsi ndo. Tatun vaha tinuu ndo, tanɨɨ cuñu ñuhu ndo tan iyó ñuhu̱ nditsin. Tan tuhun ihya cuñí tsi catyi tyin tatun iyó ñuhu̱ nditsin Nyoo añima ndo cuví ndo nyɨvɨ vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Maa tyin tatun ña vaha tinuu ndo, tandɨhɨ cuñu ñuhu ndo tan nyií tsi nu naa. Tan tacan tucu tatun nduve ñuhu̱ Nyoo iyó añima ndo, cuví ndo tumaa iin ra cuaa. Nu naa cuahán ndo tan ña cuví nyehe ndo ityi vaha tsa cuahán nu nyaá Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Iin musu ña cuvi coo uvi tsitoho ra. Tyin musu can cuñí ca ra tsi iin ra tan ñavin ca tsi inga ra. Tan tyaá yahvi ra tsi iin ra, tan ñavin ca tsi inga ra. Tan tacan tucu nyooho, ña cuví cuñi ndo tsi Nyoo, tan cuñi tucu ndo xuhun. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Yacan cuenda catyí yu tsihin ndo, tyin ña ca̱ca xaan iñi ndo nácaa ñihi ndo tsa catsi ndo tan tsa coho ndo. Ndi ña ca̱ca iñi ndo nácaa cua ñihi ndo jahma ndo. Tyin nu Nyoo nyaá yahvi ca ñayɨvɨ tsa iyó yo tan ñavin ca tsa catsi yo. Tan nyaá yahvi ca cuñu ñuhu yo tan ñavin ca jahma yo. Tyin maa ra tsahá ra ñayɨvɨ iyó yo. Tan ña yɨɨ cuhva ra inga tsa tsiñí ñuhu tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nye̱he ndo cuhva iyó saa. Ña tatsí tɨ itu. Tan ña jahá tyiñu tɨ. Tan ndi ña tyihí vaha tɨ tsa catsi tɨ. Maa tyin tsatsí tɨ tyin Jutu yo Nyoo ra nyaá gloria tsahá ra tsa catsi tɨ naha tɨ. Tan nuu Nyoo cahnu ca cuví nyooho tan ñavin ca saa can naha tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tan vasu ndi maa tsicá xaan iñi ndo maa tyin ña cua cuvi jandusucun ca ndo ndi luxu ca tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Tan tatun ndi luxu can ña cuví tsi ndo, ¿nácaa tsa tsicá xaan iñi ndo tsa cuenda jahma ndo? Nye̱he ndo nácaa iyó yutun ita tsitsi cuhu, tyin ña jahá tyiñu tun tan ndi ña taví tun yuhva. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Maa tyin catyí yu tsihin ndo tyin ndi ra cuví rey Salomón tsihin tandɨhɨ tsa cuca ra, tan ña tsinditsi̱ ra jahma sɨɨ ca caá tan ñavin ca tsa jacunditsí Nyoo tsi yutun ita can. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tatun tacan ñi jacunditsí Nyoo tsi yutun ita tsa iyó tsitsi cuhu vityin, tan tyaan cua cuvi tun nducu tan cayu tun. ¿A ña cua jatyinyee cuaha ca ra tsi ndo? Tyin nyooho cahnu ca cuví ndo nuu ra tan ñavin ca yutun ita can. Maa tyin maa ndo ña tsinú vaha iñi ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yacan cuenda ña cua caca xaan iñi yo tan catyí yo: “¿Náa cua catsi yo, o náa cua coho yo, o nácaa cua ñihi yo jahma cunditsi yo?” ");
INSERT INTO mjcNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tyin nyɨvɨ tsa ña tsitó tsi Nyoo tsicá xaan iñi ñi yacan. Maa tyin nyooho ña ca̱ca iñi ndo yacan tyin iyó Jutu yo Nyoo, ra nyaá gloria. Tan tsitó ra náa ndɨhɨ tsa tsiñí ñuhu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yacan cuenda, ca̱ca iñi ndo maa ñi maa tuhun Nyoo. Tan na̱nducu jihna ndo nácaa nacuhva cuenda ndo tsi ndo tsi ra na cundaca ñaha ra tsi ndo, tan na coo tsa vaha ra tsi ndo. Tyin tacan tan cua ñihi ndo tandɨhɨ tsa tsiñí ñuhu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jahá cuenda Nyoo tsi ndo vityin tan ityaan. Yacan ña caca iñi ndo tsa tsiñi ñuhu tsi ndo ityaan. Ca̱ca iñi ndo tan nye̱he ndo nácaa yahá ndo quɨvɨ vityin jahá Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ña cahan ndo tsa caá inga nyɨvɨ, tacan tan Nyoo ña cua cahan ra tsa caá ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tyin tumaa caahán ndo tsa caá inga nyɨvɨ, tacan cua javaha Nyoo tsihin ndo. Tan tumaa tsa javahá ndo tsihin inga nyɨvɨ, juvin ñi tacan cua javaha Nyoo tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Nacaa tyin nyehé un tsahan luhlu tsa nyií tinuu yañi un, tan ña jahá un cuenda yutun cahnu tsa nyií tinuu maa un? ");
INSERT INTO mjcNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tatun tinuu maa un nyií iin yutun cahnu, ¿nácaa cuví catyi un tsihin ra yañi un: “Na̱ha, na tava yu tsahan luhlu tsa nyií tinuu un”? ");
INSERT INTO mjcNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Yooho tsa jahá tyin vaha xaan un! Ta̱va jihna yutun cahnu tsa nyií tinuu un. Tyin tacan tan cuvi nyehe vaha un tsahan luhlu tsa cua tava un tinuu yañi un. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ña jañihi ndo cahan ndo tuhun Nyoo tsihin nyɨvɨ ña cuñí coto tyin coto cañi ñi tsi ndo. Tyin cuví ñi tumaa ina tsa caán xaan tsi ndo, tan tumaa quɨnɨ tsa tsacá tsaha iin ndaha tyiñu tsa yahvi nyaá, tyin caahán ñi tsa ndavaha ñi sɨquɨ tuhun Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Nda̱can ndo tsa tsiñí ñuhu tsi ndo tsi Nyoo. Tan cua cuhva ra tsi ndo. Na̱nducu ndo, tan cua nañihi ndo. Ca̱ñi ndaha ndo yuvehe, tan cua nuña. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tyin tandɨhɨ nyɨvɨ tsa tsicán tsi ra, cua cuhva ra tsa tsicán ñi. Tan ra tsa cua nanducu, cua nañihi ra. Tan ra tsa cañi ndaha yuvehe, cua nuña yuvehe nuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Tacan tucu nyooho tsihin sehe ndo. Tsahá ndo tsa vaha itsi naha tsi. Tun tsicán tsi paan, ¿a cua cuhva ndo iin yuu itsi? ");
INSERT INTO mjcNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O tatun tsicán tsi tyaca, ¿a cua cuhva ndo iin coo itsi? ");
INSERT INTO mjcNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nyooho vasu ndi maa quiñi iyó ndo, maa tyin tsitó ndo nácaa cuhva ndo tsa vaha tsi sehe ndo. Tan vihi ca maa Jutu yo, ra nyaá gloría, cuaha ca tsa vaha cua cuhva ra tsi ndo tatun ndacan ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Tumaa cuñí ndo tsa javaha nyɨvɨ tsa vaha tsihin ndo, tacan ja̱vaha tucu maa ndo tsa vaha tsihin ñi. Tyin tacan caahán ley tsa tsaha̱ Nyoo tsi ra Moisés tan tacan tucu nyaá nu tandɨhɨ libru tsa tyaa̱ ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Ndu̱cu ndo cuhva quɨhvɨ ndo yuvehe tɨhɨn. Tyin quiihin yuvehe, tan quiihin ityi tsa cuahán nda nu cunaa nyɨvɨ anyaya. Tan cuaha xaan nyɨvɨ cuahán ityi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Maa tyin tɨhɨn yuvehe tan cuɨñɨ ityi tsa cuahán nu cuahán nyɨvɨ tsa ñihí ñayɨvɨ nyito coo ñi. Maa tyin ña cuaha nyɨvɨ nañihí ityi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Ja̱ha ndo cuenda tsi ndo tsihin ra vatya naha ra. Tyin catyí ra naha tyin ndusu yuhu Nyoo cuví ra naha, maa tyin ña nditsa. Tyin vatsí ra naha tumaa mbee nu yucú ndo, jahá ra naha tyin ra vaha cuví ra naha. Maa tyin tumaa quɨtɨ xaan cuví ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nyooho cuví nacoto ndo tsi ra naha tsihin tsa javahá ra naha. Tumaa iin yutun ña vaha ña tsahá tun tsɨtɨ vaha, tacan cuví ra naha. Tyin iin tinyata ña cua cuhva tun mangu, tan ndi iñu nduhva ña cuvi cuhva tsi yucu vixi. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tan tacan tucu tandɨhɨ yutun vaha. Tsahá tun tsɨtɨ vaha. Tan tandɨhɨ yutun ña vaha, tsahá tun tsɨtɨ ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tyin yutun vaha, ña cuví cuhva tun tsɨtɨ ña vaha. Tan ndi yutun ña vaha ña cuví cuhva tun tsɨtɨ vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tan tandɨhɨ yutun tsa ña tsahá tsɨtɨ vaha, cahnya yo tsi tun. Tan cayu tun. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tan tacan tsihin tsa javahá nyɨvɨ, cuví nacoto ndo tsi ñi tatun nyɨvɨ vaha o nyɨvɨ ña vaha cuví ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ña tandɨhɨ nyɨvɨ tsa catyí tsihin yu: “Jutu Mañi yu, Jutu Mañi yu”, cua quɨhvɨ ñi nu ndacá ñaha Nyoo nda gloría. Maa tyin nyɨvɨ tsa javahá tsa catyí maa Nyoo Jutu yu, juvin ñi can cua quɨhvɨ nu ndacá ñaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Quɨvɨ tatsi tuñi Nyoo tsi nyɨvɨ, cuaha xaan ñi cua catyi ñi tsihin yu tyehen: “Jutu Mañi yu, nyuhu caha̱n ndi tuhun cun tsihin nyɨvɨ. Tan tsihin sɨvɨ un tava̱ ndi tatyi ña vaha tsa yɨhɨ̱ tsi ñi. Tan cuaha xaan tsa iyo javaha̱ ndi tsihin sɨvɨ un”, cua catyi ñi tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tacan tan yuhu cua catyi yu tsihin ñi: “Ña nacotó yu tsi nyooho. Ca̱tsiyo nyaha ndo nu nyaá yu tandɨhɨ nyooho tsa javahá maa maa ñi tsa ña vaha”, cua catyi yu tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Tacan catyí yu tsihin ndo, tyin nyɨvɨ tsa tsiñí tsa caahán yu tan javahá ñi cuhva cuñí yu, cuví ñi tumaa iin ra tsiñi tuñi tsa janduvita tyihyo tsaha vehe ra tsata cava. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tan quitsaha̱ cuún ñihi savi. Tan cuaha xaan ndutya ñuhu yaha̱ tsata vehe can. Tan ñihi xaan quitsaha̱ yɨhɨ́ tatyi. Maa tyin ña cuvi̱ janduva tsi vehe can, tyin vaha sama tyihyo tsaha tsi tsata cava. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Maa tyin nyɨvɨ tsa tsiñí tuhun caahán yu, tan ña javahá ñi cuhva cuñi yu; cuví ñi tumaa iin ra soho, ra tsa javaha̱ vehe nu nyɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tan quitsaha̱ cuún ñihi savi. Tan cuaha xaan ndutya ñuhu yaha̱ nu nyaá vehe ra. Tan ñihi xaan yɨhɨ̱ tatyi. Tan vehe can iin yaha cuii ñi nduva̱ tsi tan cunaa̱ tsi ―catyí ra Jesús tsihin ñi tsa nyicún tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cuhva tsa ndɨhɨ̱ caha̱n ra Jesús tsihin ñi, iyo xaan cuñi̱ ñi tsihin tsa caahán ra, ");
INSERT INTO mjcNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tyin caahán ra tumaa caahán iin ra ndacá ñaha. Tan ña caahán ra tumaa caahán ra maestro cuenda ley vehe ñuhu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cuhva tsa nuu̱ ra Jesús yucu can, cuaha xaan nyɨvɨ nyicún tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tan tsaa̱ iin ra ndohó cuehe tyaahyú, tan tsicuɨñɨ̱ tsɨtɨ ra nuu ra Jesús, tan catyí ra tsihin ra: ―Jutu Mañi yu, tatun yooho tan cuñí un, cuví janduvaha un tsi yu ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tacan tan tyiso̱ ndaha ra Jesús jiñi ra cuuhví can, tan catyí ra tsihin ra: ―Cuñí yu janduvaha yu tsi un. Cua nduvaha un vityin ―catyí ra. Tan iin yaha ñi nduvaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tacan tan catyí ra Jesús tsihin ra: ―Jihna, coto ñahñi ca̱tyi tuhun un tsihin nyɨvɨ. Maa tyin cu̱aahan nu nyaá ra cuví jutu, tan ja̱naha un tsi un tsi ra. Tan cu̱hva un tsa taahán tsi jamañi un nuu Nyoo tumaa catyí ley Nyoo tsa tyaa̱ ra Moisés. Tan cua cuvi tsi iin tsa ndaa tsi ra jutu can tan tsi nyɨvɨ tyin tsa nduvaha̱ un. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Quɨvɨ tsa tsaa̱ ra Jesús ñuu Capernaum, iin ra cuví capitán, ra ñuu Roma, tsaa̱ ra nu nyií ra Jesús tan caahán ndaahvi ra tsihin ra, ");
INSERT INTO mjcNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","tan catyí ra: ―Jutu Mañi yu, musu yu ñihi xaan cuuhví ra, canyií ra nu cama. Ña cuví nduvita ra tyin nduxii̱ ra, tan yaha xaan cuhva cuñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tan catyí ra Jesús tsihin ra: ―Cuhun maa yu tan cujanduvaha yu tsi ra ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nacaha̱n ra capitán can tan catyí ra: ―Jutu Mañi yu, ña cahnu cuví yu tan cuhun un yuvehe yu; tsihin tuhun ca̱han ñi un tan musu yu cua nduvaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tyin juvin ñi iyó ra yɨhɨ́ ndaha tsi yu. Tan iyó andaru tsa yɨhɨ́ ndaha tucu maa yu. Tan tatun cua tava tyiñu yu tsi iin ra can, cua cuhun ra. Tan tatun cana yu tsi inga ra, cua quitsi ra. Tan tatun tava tyiñu yu tsi musu yu, cua javaha ra cuhva cuñí yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tan tsa tsiñi̱ ra Jesús tsa caha̱n ra can, tan iyo xaan cuñí ra. Tan catyí ra tsihin nyɨvɨ tsa nyicún tsi ra: ―Tsa nditsa catyí yu tsihin ndo, tyin ñaha ca nañihi yu iin ra Israel tsa tsinú xaan iñi tumaa tsinú iñi ra ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tan catyí yu tsihin ndo tyin cuaha nyɨvɨ inga ñuu cua quitsi ityi nu caná ñicanyii, tan ityi nu tyisó ñicanyii, tan cua cunyecu ñi catsi ñi tsihin ra Abraham, ra Isaac tan ra Jacob nu ndacá ñaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tan nyɨvɨ tsa taahán tsi cuhun gloría, ña cua cuhun ñi, tyin cua cuhun ñi nu naa. Tan cua vacu tsaa ñi tan catsan ña cua cuvi nuhu ñi tsa cuenda tsa xaan cuñi ñi tyin nyehe ñi tundoho ―catyí ra Jesús tsihin nyɨvɨ nyicún tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tacan tan catyí ra tsihin ra capitán can: ―Cu̱aahan, tan na nduvaha musu un tsa cuenda tyin tsinú iñi un tsi yu ―catyí ra Jesús tsihin ra capitán. Tan juvin ñi cuhva can nduvaha̱ musu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tsa yaha̱ can, tan cuahán ra Jesús yuvehe ra Pedro. Tan nyehe̱ ra tsi ña tyiso ra, canyií ña nu tsito tyin yɨhɨ́ cahñi tsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tan tɨɨ̱n ra ndaha ña, tan iin yaha ñi quita̱ cahñi tsi ña. Tan nduvita̱ ña, tan quitsaha̱ nanducú ña tsa catsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tan tsa cunaaha, cuaha xaan nyɨvɨ yɨhɨ́ tatyi ña vaha tsindaca̱ nyɨvɨ tsi ra Jesús. Tan tsihin intuhun ñi tuhun caha̱n ra Jesús tan quita̱ tatyi ña vaha tsi ñi. Tan tandɨhɨ ñi cuuhví iin yaha ñi nduvaha̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tacan cuvi̱ tyin tacan tan cundaa̱ tsa caha̱n Jutu Mañi yo tsihin yuhu ra Isaías, ra cuvi̱ ndusu yuhu ra taha̱n tsanaha. Tan catyi̱ ra tyehen: “Maa ra quihi̱n ra cuehe tsa yɨhɨ́ tsi yo, tan quihi̱n nyaa ra tsa uhvi tsi yo.” ");
INSERT INTO mjcNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tan tsa nyehe̱ ra Jesús tyin cuaha xaan nyɨvɨ tsinu̱ nduvi nu nyií ra, catyí ra tsihin ra tsicá tsihin ra tyin cua yaha ra naha inga tsiyo miñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tacan tan tsaa̱ iin ra maestro cuenda ley vehe ñuhu tan catyí ra tsihin ra: ―Maestro, cuñí yu cunyicun yu tsi un tandɨhɨ ñi ityi nu cuahán un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tan ra Jesús catyí ra tsihin ra: ―Ñacuii iyó vehe tɨ. Tan saa iyó taca tɨ. Maa tyin yuhu Rayɨɨ tsa quee̱ nda gloria, nduve nu maa cunyanaa luxu jiñi yu iyó ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Inga ra tsa tsicá tsihin ra nacaha̱n ra tsihin ra: ―Taa, cu̱hva na cuhun jihna yu cucutsi yu tsi jutu yu, ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tan catyí ra Jesús tsihin ra: ―Na̱ha yooho qu̱itsi nyi̱cun un tsi yu. Tan nyɨvɨ ña iyó Nyoo añima na cucutsi tahan maa ñi tsi ñi tsitsi ñuhu tun tsihi ñi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tacan tan quɨhvɨ̱ ra tsitsi yutun ndoo tan ra tsicá tsihin ra cuahán ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tan ñihi xaan quitsaha̱ yɨhɨ́ tatyi nu miñi can, tan cuaha xaan ndutya quɨhvɨ̱ tsitsi yutun ndoo ra naha. Maa tyin ra Jesús quixí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tan ra tsicá tsihin ra jandoto̱ ra naha tsi ra, tan catyí ra naha: ―¡Jutu Mañi yu, ja̱cacu tsi yo, tyin cuñí cunaa yo! ");
INSERT INTO mjcNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tan catyí ra Jesús tsihin ra naha: ―¿Nacuenda yuuhví xaan ndo? ¡Nyooho tsa luxu xaan tsinú iñi tsi yu! ―catyí ra Jesús. Tacan tan nduvita̱ ra tan caha̱n ra tsihin tatyi tan tsihin ndutya, tan cutaxi̱n tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tan iyo xaan cuñí ra naha tan catyí ra naha: ―¿Yóo ra cuví ra ihya? Tyin nda cuanda tatyi tan nda cuanda ndutya tan tyaá yahvi tsi ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tacan tan tsaa̱ ra naha inga tsiyo miñi nda nu ñuhu Gadara. Tan tsaa̱ uvi taahan ra yɨhɨ́ tatyi ña vaha. Tan quita̱ ra naha nu ñaña cumí sandu. Xaan xaan ra naha, tan yoñi maa cuví yaha ityi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tan caná tsaa ra naha, tan catyí ra naha: ―¿Náa cuñí un tsihin ndi, yooho Jesús Sehe Nyoo? ¿A vatsí un vatsí janyehe un tundoho tsi ndi tsa ndi cumañi ca tsaa quɨvɨ? ―catyí ra naha jaha̱ tatyi ña vaha can. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tan yatyin ñi can yucú cuaha quɨnɨ tsatsí tɨ naha tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tan catyí nu tatyi ña vaha can tsihin ra Jesús: ―Tatun cua tava un tsi ndi, cu̱hva tsa quɨhvɨ ndi tsitsi quɨnɨ can naha tɨ ―catyí nu tatyi ña vaha can nahnu. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","―Vaha. Quɨ̱hvɨ ndo ―catyí ra Jesús. Tan quita̱ nu tatyi ña vaha can nahnu, tan quɨhvɨ̱ nahnu tsitsi tandɨhɨ quɨnɨ tsa nyecú can. Tan tandɨhɨ quɨnɨ can tsinu̱ tɨ naha tɨ tan cucoyo̱ tɨ naha tɨ iin xahva yuhu miñi can, tan tsihi̱ tɨ naha tɨ tsihin ndutya can. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tan ra jahá cuenda tsi quɨnɨ can, tsinú xaan ra naha cuahán ra naha tsitsi ñuu, tan nacatyi̱ tuhun ra naha tandɨhɨ tsa cuvi̱ tsi ra tsa yɨhɨ̱ tatyi ña vaha can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tacan tan tandɨhɨ nyɨvɨ ñuu can, tsaha̱n ñi tsinyehe̱ ñi tsi ra Jesús, tan caha̱n ndaahvi ñi tsihin ra na quita ra ñuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tacan tan quɨhvɨ̱ ra Jesús tsitsi iin yutun ndoo tan yaha̱ ra miñi, tan tsaa̱ ra nda ñuu nu iyó ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nu nyií ra ican, tsindaca̱ nyɨvɨ tsi iin ra cuuhví tsa ña cuví nacanda tyin nduxii̱ ra, tan canyií ra nu tsito. Tan tsa nyehe̱ ra Jesús tyin tsinú xaan iñi ñi tsi ra, quitsaha caahán ra tsihin ra cuuhví can: ―Ja̱ndu iin iñi un, sehe yu, tyin tsa tsicoo̱ tucahnu iñi cuatyi un ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tacan tan quitsaha̱ tsicá iñi juhva ra maestro cuenda ley vehe ñuhu tsa yucú ican naha ra: “Ra ihya tsicoo̱ cuatyi ra nu Nyoo tsihin tuhun caahán ra”, cuñí ra naha tsicá iñi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Maa tyin ra Jesús tsitó ra náa tsicá iñi ra naha, tan catyí ra tsihin ra naha: ―¿Nacuenda tsicá iñi ndo tsa ña vaha? ");
INSERT INTO mjcNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tyin ¿ndáa tsa yɨɨ ca catyí yo: a yɨɨ ca catyí yo: “Cuatyi un tsa yaha ndatsi”, o yɨɨ ca catyi yo: “Ndu̱vita tan ca̱ca un”? ");
INSERT INTO mjcNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Vityin cua janaha yu tsi ndo tyin yuhu Rayɨɨ tsa quee̱ nda gloria, iyó ndatu tsi yu nu ñuhu ñayɨvɨ ihya tyin jaha yu tucahnu iñi cuatyi ndo ―catyí ra Jesús. Tacan tan catyí ra tsihin ra cuuhví can: ―Ndu̱vita, na̱quihin tsito un tan cu̱anuhu nda yuvehe un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tacan tan nduvita̱ ra tan cuanuhu̱ ra nda yuvehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tan nyɨvɨ tsa nyehe̱ tsa cuvi̱, nayuhvi̱ xaan ñi. Tan quitsaha̱ jacahnú ñi tsi Nyoo tyin tsaha̱ ra tunyee iñi tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yaha can tan quita̱ ra Jesús ican. Tan nyehe̱ ra tsi iin ra tsa nañí Mateo, nyaá ra naquihín ra xuhun tsa tyahví nyɨvɨ Israel tsi ra ndacá ñaha. Tan catyí ra tsihin ra: ―Co̱hon tsihin yu. Tacan tan nduvita̱ ra Mateo tan cuahán ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tacan tan cuvi̱ tsi iin tsaha, ra Jesús cuahán ra nda vehe ra Mateo, cua catsi ra ixta. Tan cuaha xaan ra tavá xuhun cuenda ra ndaca ñaha tsaa̱, tan tsihin inga ca ra iyó cuatyi naha ra. Tan tsinyecu̱ ra naha iin ñi nu mesa tsihin ra Jesús tan tsihin ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tan tsa nyehe̱ ra fariseo naha ra tyin nyaá ra Jesús tsihin ra iyó cuatyi naha ra, tan tsica̱ tuhun ra naha tsi ra tsicá tsihin ra, tan catyí ra naha tsihin ra naha: ―¿Nacuenda tyin tsatsí ra maestro ndo tsihin ra tavá xuhun naha ra tan ra iyó cuatyi naha ra? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tsa tsiñi̱ ra Jesús tsa caahán ra naha, tan catyí ra tsihin ra naha: ―Ña tsiñí ñuhu doctor tsi nyɨvɨ iyó vaha, ñi ña cuuhví. Maa tyin nyɨvɨ cuuhví tsiñí ñuhu doctor tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cu̱aahan ndo tan cu̱tuhva ndo cuhva catyí nu tutu Nyoo, nu catyí tsi tyehen: “Yuhu cuñí yu tsa cundaahvi iñi ndo tsi nyɨvɨ, tyin yacan cuví tsa ñiñi xaan ca tan ñavin ca tsa cahñi ndo quɨtɨ tan cuhva cuenda ndo tsi yu.” Yuhu ña vatsí yu jatyinyee yu tsi nyɨvɨ tsa tsicá iñi tyin vaha ñi, vatsí yu jatyinyee yu tsi nyɨvɨ tsitó tyin iyó cuatyi ñi, na ndu uvi iñi ñi cuatyi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tacan tan ra nyicún tsi ra Juan, ra jacoondutya tsi nyɨvɨ, natuhva̱ ra naha nu nyaá ra Jesús tan tsica̱ tuhun ra naha tsi ra tan catyí ra naha: ―¿Nacuvi tyin nyuhu tan ra cuví fariseo naha ra, tuhvá ndi tsicoó nyitya tan ra tsicá tsihin yooho ña tuhvá ra naha coo nyitya? ");
INSERT INTO mjcNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tan nacaha̱n ra Jesús tan catyí ra: ―¿A cuví cunyecu cuiihya nyɨvɨ yucú vico tindaha tun nyií ra cua tindaha tsihin ñi? Maa tyin coo quɨvɨ cua quita ra tindaha ican nu yucú ñi. Tacan tan cua coo ñi tucuiihya iñi tan cua coo nyitya ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Ña tuhvá nyɨvɨ naquicú iin jahma tuuhu tsihin iin jahma tsaa, tyin cua nandɨyɨ nu naquicu̱ ñi tsihin tsa tsaa can, tan cua tyahnya tsi inga tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tan tacan tucu, ña cuví tyihí nyɨvɨ vinu tsaa tsitsi ñɨɨ tsaahnu tyin tatun tacan javaha ñi, cua tyahnya ñɨɨ can, tan cua tɨvɨ vinu can tan cua tɨvɨ ndɨhɨ tucu ñɨɨ can. Yacan cuenda taahán tsi tyihi yo vinu tsaa tsitsi ñɨɨ tsaa. Tyin tacan tan ña tyahnya ñɨɨ can tan ndi vinu can ña tɨvɨ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tsitsi tsa caahán ra Jesús tuhun ihya, tsaa̱ iin ra cumí tyiñu cuenda vehe ñuhu nyɨvɨ Judea tan tsicuɨñɨ̱ tsɨtɨ ra nuu ra Jesús, tan catyí ra: ―Ndi tsihi̱ cuii ñi sehe yu, maa tyin tatun yooho tan cuhun un tan tyiso ndaha un jiñi ña, cua nandoto ña ―catyí ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nduvita̱ ra Jesús tsihin ra tsicá tsihin ra tan cuahán ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tacan tan iin ñaha cuuhví natuhva̱ ña tsata ra Jesús. Tan ñaha can tsa iyó utsi uvi cuiya ndohó ña cuehe tsa cuún nɨñɨ ña. Tan tyanaa̱ ña ndaha ña jahma ra, ");
INSERT INTO mjcNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","tan cuñí ña tsicá iñi ña: “Tun nañi ndaha yu jahma ra cua nduvaha yu”, cuñí ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Maa tyin ra Jesús nanyico̱ coo ra tan nyehe̱ ra tsi ña, tan catyí ra tsihin ña: ―Ja̱ndunɨɨ iñi un, xihi, tsa nduvaha̱ un tyin tsinú iñi un ―catyí ra. Tan juvin ñi cuhva can tan tsicuɨñɨ̱ tsa cuún ñɨñɨ ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yaha̱ can tan tsaa̱ ra Jesús vehe ra cumí tyiñu can, tan nyehe̱ ra tyin ra música ndatú ra naha tsa cucutsi ra naha tsi ndɨyɨ can. Tan nyɨvɨ tsa yucú can iyo xaan tsacú ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tan catyí ra Jesús tsihin ñi: ―Qu̱ita ndo ihya. Ñaha luhlu ihya, ña tsihi̱ ña. Quixí ña ―catyí ra. Tan tsa caha̱n ra tacan quitsaha̱ tsacú naaha ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tan ra Jesús tava̱ ra tsi ñi ityi tsata vehe. Tacan tan quɨhvɨ̱ ra tsitsi vehe nu canyií ñaha can, tan tɨɨ̱n ra ndaha ñaha luhlu can, tan nduvita̱ ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tan tandɨhɨ nyɨvɨ iyó ityi ñuu can tsito̱ ñi tsa nandoto̱ ñaha luhlu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tsa quita̱ ra Jesús ican, tan uvi taahan ra cuaa nyicún tsi ra, caná tsaa ra naha tan catyí ra naha: ―¡Cu̱ndahvi iñi tsi ndi, yooho ra cuví tata ra David! ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tan tsa yaha̱ quɨhvɨ̱ ra Jesús tsitsi vehe, ra cuaa can, natuhva̱ ra naha nu nyaá ra, tan maa ra Jesús quitsaha̱ tsicá tuhun ra tsi ra naha tan catyí ra: ―¿A tsinú iñi ndo tyin cuví janduvaha yu tsi ndo? Tan nacaha̱n ra cuaa can naha ra tan catyí ra naha: ―Tsinú iñi ndi tsi un, Jutu Mañi yu ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tacan tan tyanaa̱ ra Jesús ndaha ra tinuu ra naha tan catyí ra tsihin ra naha: ―Na cuvi maa tumaa cuhva tsinú iñi ndo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tan nduvaha̱ tinuu ra naha. Tan catyí ra Jesús tsihin ra naha: ―Coto ñahñi catyi tuhun ndo tsihin ndi intuhun nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Maa tyin cuahán ra naha tan quitsaha̱ catyí tuhun ra naha tsa javaha̱ ra Jesús tsihin ra naha tsihin tandɨhɨ nyɨvɨ iyó ityi ñuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tsa cuahán ra naha, juhva nyɨvɨ tsindaca̱ ñi tsi iin ra ñɨɨhɨ́ tsa yɨhɨ́ tatyi ña vaha nu nyií ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tan tsa tava̱ ra Jesús tatyi ña vaha can, tacan tan nacaha̱n ra can. Tan iyo xaan cuñí nyɨvɨ, tan catyí ñi: ―Ñaha ca maa nyehe̱ yo ñuu Israel ihya ndi intuhun ra tavá tatyi ña vaha tsi nyɨvɨ ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Maa tyin ra cuví fariseo naha ra, catyí ra naha: ―Ra ihya tavá ra tatyi ña vaha tsihin tunyee iñi nu ña vaha tsa cuví ityi nuu tsihin nahnu ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ra Jesús tsaha̱n ra tandɨhɨ ñuu jacuahá ra tsi nyɨvɨ tsitsi vehe ñuhu intuhun intuhun ñuu. Caahán ra tuhun Nyoo nácaa ndacá ñaha ra tsi nyɨvɨ. Tan janduvahá ra tandɨhɨ nuu cuehe tsa ndohó ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tan tsa nyehé ra tsi nyɨvɨ, cundaahvi̱ xaan iñi ra nyehe̱ ra tsi ñi, tyin nyehé ñi tundoho tan iyó ñi tucuiihya iñi, tumaa mbee ticatyi tsa nduve tsitoho iyó. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tacan tan catyí ra tsihin ra tsicá tsihin ra: ―Tsa nditsa, cuaha xaan tyiñu iyó, maa tyin ra jahá tyiñu, ña cuaha ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yacan cuenda, nda̱can ndo tsi Ra Jatsii tyiñu ihya, na jaquitsi ca ra musu naquihin vaha cosecha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tacan tan cana̱ ra Jesús tsi tsa utsi uvi ra tsicá tsihin ra tan tsaha̱ ra ndatu tsi ra naha na tava ra naha tatyi ña vaha tsa yɨhɨ́ añima nyɨvɨ, tan na janduvaha ra naha tsi nyɨvɨ cuuhví náa ndɨhɨ ca nu cuehe tan tsa uhvi. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ihya nyaá sɨvɨ tsa utsi uvi ra tsicá tyiñu ra: jihna ca, ra Simón, tsa nañí tucu Pedro, tan ra yañi ra, ra Andrés; ra Jacobo tan ra Juan yañi ra, sehe ra Zebedeo cuví tsi ra naha; ");
INSERT INTO mjcNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tan ra Felipe; ra Bartolomé; ra Tomás; tan ra Mateo ra tava̱ xuhun cuenda ra ndacá ñaha; ra Jacobo sehe ra Alfeo; ra Lebeo tsa nañí tucu Tadeo; ");
INSERT INTO mjcNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","tan ra Simón ra nyií cuenda partido tsa cuñí cuhun cuatyi sɨquɨ ñuu Roma tsa ndacá ñaha tsi ñi; tan ra Judas Iscariote, ra tsa xico̱ tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tan tava̱ tyiñu ra Jesús tsi tsa utsi uvi ra can naha ra, tan catyí ra tsihin ra naha: ―Ña cu̱hun ndo nu iyó nyɨvɨ tsa ñavin nyɨvɨ Israel cuví, tan ndi ña qu̱ɨhvɨ ndo ñuu tsa cayucú Samaria. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cu̱aahan ndo nu yucú mbee tsa tsinaa̱ tsa cuví nyɨvɨ Israel. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cu̱aahan ndo cua cahan ndo tyin tsa tsaa̱ quɨvɨ tsa cua cundaca ñaha Nyoo tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ja̱nduvaha ndo tsi nyɨvɨ cuuhví, nyɨvɨ ndohó cuehe tyaahyú, tan nyɨvɨ yɨhɨ́ inga cuehe tsi. Ja̱nandoto ndo ndɨyɨ. Ta̱va ndo tatyi ña vaha yɨhɨ́ tsi nyɨvɨ. Tyin nyooho naquihín ndo tunyee iñi ihya tsa cuatu ñi, ja̱nduvaha ndo nyɨvɨ tsihin tsi, tan ña ndacan ndo xuhun tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ña cu̱iso ndo xuhun; ndi xuhun cuaan, ndi xuhun cuitsin, ndi xuhun cuaaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tan ña cu̱iso ndo ndi yunu tsa cuenda tsa caca ityi ndo. Intuhun ñi camisa tsa nditsín ndo cuhun tsihin ndo. Tan ña cu̱iso ndo inga pari nditsan. Tan ndi ña cu̱ndaha ndo yutun. Tyin ra jahá tyiñu, iyó ndatu tsi ra tsa coo yahvi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Tatun tsaa ndo iin ñuu cahnu o iin ñuu luhlu, ndu̱cu ndo iin nyɨvɨ vaha iñi, tan ndo̱o ndo yuvehe ñi nda cuanda quita ndo ñuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tatun cua quɨhvɨ ndo iin vehe, cu̱hva ndo nacumi tsi nyɨvɨ iyó yuvehe can. Tan ca̱tyi ndo tsihin ñi: “Na coo tsa vaha Nyoo añima ndo”. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tan tatun nyɨvɨ iyó yuvehe can tan nacotó ñi tyin tsiñí ñuhu tsa vaha can tsi ñi, cua ndoo can tsihin ñi. Maa tyin tatun ña tsitó ñi tyin tsiñí ñuhu tsa vaha can tsi ñi, na̱quihin nyico ndo can. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tan tatun ña cuñí nyɨvɨ quihin cuenda ñi tsi ndo, tan ndi ña cuñí ñi tyaa soho ñi tsa caahán ndo, tacan tan qu̱ita ndo yuvehe ñi, ñuu can, tan na̱quɨsɨ ndo nyaca ñuhu tsaha ndo tyin ndoo maa cuatyi ñi sɨquɨ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tsa nditsa catyí yu tsihin ndo tyin quɨvɨ cua tatsi tuñi Nyoo tsi nyɨvɨ, ñihi ca cua tatsi tuñi ra tsi ñi can tan ñavin ca nyɨvɨ ñuu Sodoma tan ñuu Gomorra. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Nye̱he ndo! Tumaa mbee ticatyi cuví ndo, tan jacuhún yu tsi ndo nu yucú quɨtɨ xaan. Nyityi ja̱ha ndo tsi ndo, tumaa coo. Maa tyin ja̱nduvita ndo iñi ndo tumaa paloma, ña xaan tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ja̱ha ndo cuenda tsi ndo tsihin nyɨvɨ tyin cua cuhva cuenda ñi tsi ndo tsi ra cumí tyiñu naha ra. Tan cua cañi ñi tsi ndo tsitsi vehe ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tan tsa cuenda yuhu, cua cundaca ñi tsi ndo nuu ra ndacá ñaha tan nuu rey. Tacan tan cuví cahan ndo tuhun yu nuu ra naha tan nuu nyɨvɨ tsa ñavin nyɨvɨ Israel cuví. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Maa tyin tatun nacuhva cuenda ñi tsi ndo tsi ra cumí tyiñu naha ra, ña caca iñi ndo nácaa cua cahan ndo, tyin tatun tsaa cuhva tsa cua cahan ndo, Nyoo cua cuhva ra tuhun cahan ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tyin ñavin maa ndo cua cahan, tyin maa Tatyi Ii Jutu yo Nyoo tsa iyó añima ndo cua cuhva ra tsa cahan ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Yɨhɨ́ rayɨɨ cua xico ra naha juvin ñi tsi ra yañi ra naha na cahñi ra naha tsi ra. Tan yɨhɨ́ ra cua xico ra sehe ra. Tan yɨhɨ nyɨvɨ cua cuxaan ñi tsi jutu ñi tan sɨhɨ ñi, tan cua cuhva cuenda ñi jutu ñi tan sɨhɨ ñi tsi nyɨvɨ na cahñi nyɨvɨ can tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tandɨhɨ nyɨvɨ, ndasɨ cua cuñi ñi nyehe ñi tsi ndo tsa cuenda yuhu. Maa tyin tatun ña jandɨhɨ ndo tsa tsinú iñi ndo tsi yu, tacan tan cua cacu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tatun nyaa ndaha ñi tsi ndo iin ñuu, cu̱hun ndo inga ñuu. Tyin tsa nditsa catyí yu tsihin ndo tyin tsa ndi cumañi ca cuhun ndo tandɨhɨ ñuu nu iyó nyɨvɨ Israel tan cua quitsi nyico yuhu, Rayɨɨ tsa quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Iin ra luhlu tsa tsicá escuela, ña cahnu cuví ra tan ñavin ca ra jacuahá tsi ra. Tan iin musu, ña cahnu ca cuví ra tan ñavin ca tsitoho ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ra tsicá escuela, ña cuví coto cuaha ca ra tan ñavin ca ra jacuahá tsi ra. Tan iin musu ña cuví cuu ra iin ra cahnu ca tan ñavin ca tsitoho ra. Yacan cuenda tatun maa yu, ra jatsii vehe, tan catyí nyɨvɨ tyin cuví yu Beelzebú, nu cuví ityi nuu tsihin nu ña vaha, tacan tucu cua catyi ñi tsihin nyɨvɨ cuenda yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Yacan cuenda ña na̱yuhvi ndo tsi nyɨvɨ, tyin nduve tsa nyií xeehe tsa ña cua quituvi. Tan nduve tsa xeehe tsa ña cua coto nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tandɨhɨ tsa caahán yu tsihin ndo tsacuaa, ca̱han ndo can tsinu cahñi. Tan tandɨhɨ tsa caahán xeehe yu tsihin ndo, nda̱a ndo jiñi vehe ca̱na tsaa ndo can, na coto tandɨhɨ nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ña na̱yuhvi ndo tsi nyɨvɨ tsahñí cuñu ñuhu yo, tyin ña cuví cahñi ñi añima yo. Vaha ca nayuhvi ndo tsi maa Nyoo, ra cuví janaa cuñu ñuhu ndo tan añima ndo tsitsi anyaya. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Saa ña yahvi nyaá tɨ. Cuví jata yo uvi taahan tɨ tsihin intuhun xuhun luhlu. Maa tyin ndi intuhun tɨ ña canacava tɨ nu ñuhu tatun ña cuhva maa Nyoo Jutu yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tyin nda cuanda ixi jiñi ndo tan tsitó Nyoo najava taahan tsi iyó, tyin tsa nacahvi̱ ra intuhun intuhun tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yacan cuenda ña na̱yuhvi ndo. Nyooho, nyaá yahvi ca ndo nu Nyoo tan ñavin ca tsa cuaha saa. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Tandɨhɨ nyɨvɨ tsa caahán catsi tsihin nyɨvɨ yóo ra cuví yu, tacan tucu yuhu cua cahan catsi yu tsihin Jutu yu ra nyaá gloría tyin nacotó yu tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Maa tyin nyɨvɨ cua tyihi xeehe tsi yu nuu inga nyɨvɨ, tacan tucu yuhu cua tyihi xeehe yu tsi ñi nuu Jutu yu ra nyaá gloría. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Ña cu̱ñi ndo tyin yuhu vatsí cuhva yu tsa coo taxin nyɨvɨ nu ñuhu ñayɨvɨ ihya. Yuhu vatsí yu vatsí cahan yu tuhun Nyoo tsihin ñi, tan cua natahvi ñi tsa cuenda yacan. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tyin yɨhɨ ñi cua tsinu iñi ñi tsi yu, maa tyin inga ñi ña cua tsinu iñi ñi. Tan yacan cuenda, iin ra cua cañi tahan ra tsihin jutu ra. Tan iin ñaha cua cañi tahan ña tsihin sɨhɨ ña. Tan inga ña cua cañi tahan ña tsihin tyiso ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tan yacan cuenda juvin ñi maa nyɨvɨ vehe ndo cua cuxaan iñi tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Nyɨvɨ tsa cuñí ca tsi jutu ñi a tsi sɨhɨ ñi tan ñavin ca tsi yuhu, ña cuví cuvi ñi nyɨvɨ cuenda yu. Tan nyɨvɨ cuñí ca tsi sehe yɨɨ ñi a sehe sɨɨhɨ ñi, tan ñavin ca tsi yuhu, ña cuví cuvi ñi nyɨvɨ cuenda yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tan nyɨvɨ tsa ña cuñí nyehe tundoho tan ndi ña cuñí ñi cuhva ñi ñayɨvɨ iyó ñi tsa cuenda yu, ña taahán tsi cuvi ñi nyɨvɨ cuenda yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tyin nyɨvɨ cuñi xaan ca ñayɨvɨ iyó ñi, cua cunaa ñi. Maa tyin nyɨvɨ cua cuhva ñayɨvɨ iyó ñi tsa cuenda yu, cua ñihi ñi ñayɨvɨ nyito coo ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Nyɨvɨ tsa naquihín cuenda tsi nyooho, tsi yuhu naquihín cuenda ñi, tan ñi naquihín cuenda tsi yuhu, quihín cuenda ñi tsi ra tsa jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nyɨvɨ naquihín cuenda tsi iin ra cuví ndusu yuhu Nyoo tyin Nyoo jaquitsi̱ tsi ra, cua ñihi ndɨhɨ ñi tsa vaha tsa cua ñihi ra cuví ndusu yuhu Nyoo can. Tan nyɨvɨ naquihín cuenda tsi iin ra vaha tsa cuenda tyin ra vaha cuví ra, juvin ñi tsa vaha tsa cua ñihi ra vaha can cua ñihi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tan yóo nyɨvɨ tsa cuhva intuhun vasu ndutya vitsin coho nyɨvɨ tsa nyicún tsi yu, cua ñihi ndɨhɨ ñi tsa cua cuhva Nyoo tsi ñi tsa nyicún tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tsa ndɨhɨ̱ caha̱n ra Jesús tsihin tsa utsi uvi ra tsicá tsihin ra, tacan tan quita̱ ra ican, tyin cua cahan ra tuhun Nyoo tsihin nyɨvɨ tsa iyó ñuu tsa cayucú ityi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tan ra Juan nyií ra vehe caa quɨvɨ can, tan ñihi̱ tuhun ra tsa javahá ra Cristo. Tacan tan jacuhu̱n ra tsi uvi taahan ra tsicá tsihin ra, na ndaca tuhun ra naha tsi ra Jesús. Tan cuahan ra naha nu nyií ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tan catyí ra naha tsihin ra: ―¿A juvin yooho cuví ra Cristo tsa nyaa tsa cua quitsi jacacu tsi ndi? O tatun ñavin un cuví, cuatu ndi tsi inga ra ―catyí ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nacaha̱n ra Jesús tan catyí ra: ―Cu̱aahan ndo tan ca̱tyi tuhun ndo tsihin ra Juan tandɨhɨ tsa nyehé ndo, tan tsa tsiñí ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tan ca̱tyi ndo tsihin ra: nyɨvɨ cuaa nanyehé ñi, nyɨvɨ coxo nacacá ñi, nyɨvɨ ndohó cuehe tyaahyú nduvahá ñi, nyɨvɨ soho nacuñí ñi, tan nandotó nyɨvɨ tsa tsa tsihi̱, tan nyɨvɨ ndaahvi tsiñí ñi tuhun Nyoo nácaa cua cacu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","’Tan ca̱tyi ndo tsihin ra tyin sɨɨ xaan cua cuvi tsi nyɨvɨ tsa nyicún tsi yu tun ña ndu uvi iñi ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tsa cuahán ra naha, tan quitsaha̱ caahán ra Jesús tuhun ra Juan tsihin nyɨvɨ, tan catyí ra: ―Quɨvɨ tsa tsaha̱n ndo tsinyehe̱ ndo nu tsɨquɨ, ¿náa cua nyehe ndo cuñí maa ndo? ¿A nyehe̱ ndo iin ndoo tsa janduva̱ tatyi? ");
INSERT INTO mjcNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿O náa cuví tsa tsinyehe̱ ndo? ¿A iin ra nditsí jahma vaha cua nyehe ndo? Ñavin. Tyin tsitó ndo tyin ra nditsí jahma vaha, iyó ra vehe ra cuví rey. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿A ña tsaha̱n ndo tsinyehe̱ ndo tsi iin ra cuví ndusu yuhu Nyoo? Juvin. Tyin ra ican cahnu ca cuví ra tan ñavin ca tandɨhɨ ra cuví ndusu yuhu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juvin ñi tuhun ra Juan cuví tsa nyaá nuu tutu Nyoo. Tan catyí tsi tyehen: Yuhu cua jacuhun yu iin ra cahan tuhun yu tsa ndi cumañi ca cuhun yu. Tyin natyiso vaha ra ityi nu cua cuhun un. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Tsa nditsa catyí yu tsihin ndo, tyin tsitsi tsa tandɨhɨ nyɨvɨ tsa tsicoo̱ tan nyɨvɨ iyó vityin, tan ña cahnu ca cuví ñi tan ñavin ca ra Juan, ra jacoondutyá tsi nyɨvɨ. Maa tyin ra tsa ndaca ñaha Nyoo añima, vasu ra lihli ñi cuví ra, cahnu ca ra cuví ra tan ñavin ca ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Nda cuanda quɨvɨ tsa tsaa̱ ra Juan tan nda vityin, nyɨvɨ ñihi iñi, nducú xaan ñi cuhva ñihi ñi tsa cundaca ñaha Nyoo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ra Moisés caha̱n ra tuhun nácaa cua cundaca ñaha Nyoo tsi nyɨvɨ, tan tacan tucu tandɨhɨ ra cuví ndusu yuhu Nyoo. Tacan tan quitsi̱ ra Juan jacoto̱ ra tsi nyɨvɨ tyin tsa tsaa̱ quɨvɨ tsa cua cundaca ñaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tan ra Juan cuví ra Elías ra tsa nyaá tsa cua quitsi, tun nyooho tan cuñí ndo tsinu iñi ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nyooho tsa iyó soho, tya̱a soho ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Náa tsihin jandu inducu yu tsi nyooho, nyɨvɨ tsa iyó quɨvɨ ihya? Tumaa ra nyihi cuví nyooho. Tyin ra nyihi jasɨquɨ nuyahvi. Caná tsaa tahan ra naha tan catyí ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tɨvɨ̱ ndi tiyoo tan ña tsañi̱ ndo yaa. Tan tsita̱ ndi yaa cuiihya, tan ña tsacu̱ ndo”, catyí ra nyihi. Tan tacan cuví nyooho tyin ndi intuhun cuhva ña taahán iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tyin ra Juan, ra jacoondutyá, quitsi̱ ra tan ña tsatsi̱ vaha ra, tan ña tsihi̱ ra vinu. Tan nyooho catyí ndo tyin tatyi ña vaha yɨhɨ́ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yaha̱ can tan tsaa̱ tucu yuhu Rayɨɨ tsa quee̱ nda gloria. Tan tsatsí yu tan tsihí yu. Tan catyí ndo tyin tsatsí xaan yu tan tsihí xaan yu vinu, catyí ndo. Tan ña taahán iñi ndo tsa cutahán yu tsihin ra iyó cuatyi naha ra tan tsihin ra tavá xuhun cuenda ra ndacá ñaha naha ra. Tan vasu ña naquihín cuenda ndo tuhun caahán ndi, maa tyin Nyoo tsahá ra tsa tsiñi tuñi ra tsi nyɨvɨ naquihín tuhun caahán yu tan tuhun caha̱n ra Juan, tan ñi ican cua janaha ñi tsi ndo tyin vaha tsa tsiñi tuñi Nyoo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tacan tan quitsaha̱ caahán ra Jesús tsihin nyɨvɨ tandɨhɨ ñuu nu javaha̱ ra cuaha tsa iyo, tyin ña nasama̱ ñi cuhva iyó ñi, tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Ndahvi nyooho, nyɨvɨ ñuu Corazin! ¡Ndahvi nyooho nyɨvɨ ñuu Betsaida! Tyin nyehé ndo tsa iyo tsa javahá yu tan ña nasama̱ ndo cuhva iyó ndo. Tan ñuu Tiro tan ñuu Sidón nduve tsa nyehe̱ ñi. Maa tyin tun tsatyin nyehe̱ ñi tsa nyehé nyooho vityin, numi xaan cua cunditsi ñi jahma tucuiihya iñi tan cua coso ñi nyaa nuu ñi: tyin ndu uvi iñi ñi cuatyi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Maa tyin catyí yu tsihin ndo tyin ñihi ca cua tatsi tuñi Nyoo tsi ndo tan ñavin ca ñi ñuu Tiro tan ñi ñuu Sidón. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tan nyooho nyɨvɨ ñuu Capernaum, cuñí maa ndo tyin cundaa ndo nda gloría, maa tyin cua nuu ndo nda cuanda nu yucú nyɨvɨ tsihi̱ anyaya. Tun tsatyin tsicoo̱ tsa iyo nyehe̱ ñi ñuu Sodoma tumaa tsa nyehé ndo ihya, ñuu can ña tsinaa̱ tsi tan iyó tsi nda cuanda vityin. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Maa tyin catyí yu tsihin ndo tyin quɨvɨ cua tatsi tuñi Nyoo tsi nyɨvɨ, ñihi ca cua tatsi tuñi ra tsi nyooho tan ñavin ca nyɨvɨ ñuu Sodoma. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Quɨvɨ can catyí ra Jesús tsihin Nyoo: ―Jacahnú yu tsi un, Jutu yu, ra ndacá ñaha gloría tan ñuhu ñayɨvɨ. Tyin tyihi̱ xeehe un tuhun ihya nuu ra tsitó xaan tan ra nyityi xaan naha ra. Tan jandunditsí un tuhun ihya nuu ra nyihi. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tacan Tyaa, tyin tacan cuñí maa un ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tacan tan catyí tucu ra tsihin nyɨvɨ: ―Jutu yu nacuhva̱ cuenda ra tandɨhɨ tsa iyó tsi ra tsi yu. Yoñi maa nacotó tsi yu tsa nditsa, intuhun ñi maa Jutu yu nacotó vaha tsi yu. Tan Jutu yu yoñi nacotó tsi ra tsa nditsa. Intuhun ñi maa yu, tsa cuví Sehe ra tsi yu, tsitó yu tsi ra. Tan nyɨvɨ tsa cuñí yu tsa nacoto tsi Jutu yu, cua janaha yu tsi ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tandɨhɨ nyooho tsa tatú tyin jahá tyiñu ndo, tan tsihin tundoho tsa iyó ndo, na̱ha ndo nu nyaá yu, tan yuhu cua cuhva yu tsa quitatu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cu̱hva ndo tsa cundaca ñaha yu tsi ndo tan cu̱tuhva ndo cuhva iyó yu. Tyin yuhu ña xaan yu tan ña cahnu jahá yu tsi yu. Tacan tan cua quitatu añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ña yɨɨ tsa cuhva ndo tsi ndo tsa cundaca ñaha yu. Tyin tsa tsahá yu cuiso ndo, yama tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iin quɨvɨ quitatú nyɨvɨ, yaha̱ ra Jesús mahñu nu iyó tsa tatsi̱ nyɨvɨ. Tan tsaa̱ soco tsi ra tsicá tsihin ra. Tan quitsaha̱ tuhún ra naha yoco trigu can tan tsatsí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tan tsa nyehe̱ ra fariseo naha ra yacan, catyí ra naha tsihin ra Jesús: ―Jihna, ra tsicá tsihin un javahá ra naha iin tyiñu tsa ña taahán tsi javahá yo quɨvɨ quitatú yo ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tan ra Jesús catyí ra tsihin ra naha: ―¿A ñaha ca cahvi ndo tsa javaha̱ ra David tsihin ra cutahan tsihin ra quɨvɨ tsa tsaa̱ soco tsi ra naha? ");
INSERT INTO mjcNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Quɨhvɨ̱ ra tsitsi vehe Nyoo, quihi̱n ra paan ii, tan tsatsi̱ ra naha. Tan ña taahán tsi catsi ra naha, ndi maa ra, tan ndi ra tsicá tsihin ra, tyin maa ñi maa ra cuví jutu naha ra taahán tsi catsi paan can. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O ñaha ca cahvi ndo nu ley nu catyí tsi tyin ra cuví jutu naha ra, jahá tyiñu ra naha tsitsi vehe ñuhu quɨvɨ quitatú yo? Tan ñavin cuatyi cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tan catyí yu tsihin ndo, tyin ihya nyaá ra tsa cahnu ca cuví tan ñavin ca vehe ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nyooho, ñaha ca cutuñi iñi ndo nu catyí tsi nu tuhun Nyoo tyehen: “Tsa cuñí ca yu javaha ndo cuví tsa cundaahvi iñi ndo nyehe ndo tsi nyɨvɨ tahan ndo, tan ñavin ca tsa cahñi ndo quɨtɨ tan jamañi ndo nuu yu.” Tun tsatyin cutuñí iñi ndo tuhun ihya, ña cua tyaa ndo cuatyi tsata nyɨvɨ tsa nduve cuatyi. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yuhu, Rayɨɨ tsa quee̱ nda gloria, iyó ndatu tsi yu tsa cahan yu tsihin intuhun intuhun ndo náa taahán tsi javaha ndo quɨvɨ quitatú yo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tacan tan quita̱ ra Jesús ican, tan cuahán ra vehe ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tan ican nyií iin ra tsa na ityi ndaha. Tan yucú tucu juhva ra nducú cuhva nácaa tan tyaa ra naha cuatyi tsi ra Jesús. Yacan cuenda tsica̱ tuhun ra naha tsi ra tan catyí ra naha: ―¿A catyí ley tyin vaha janduvaha yo tsi nyɨvɨ cuuhví quɨvɨ quitatú yo? ―catyí ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tan nacaha̱n ra Jesús tan catyí ra: ―¿Ndáa nyooho, tatun canacava iin mbee jana ndo tsitsi iin yavi quɨvɨ quitatú yo, a ña cua cuhun ndo tan tava ndo tsi tɨ? ");
INSERT INTO mjcNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tan ¿a ña nyaá yahvi ca iin nyɨvɨ tan ñavin ca mbee? Yacan cuenda taahán tsi javaha yo tsa vaha quɨvɨ quitatú yo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tacan tan catyí ra Jesús tsihin ra tsa na ityi ndaha can: ―Ja̱nacaa ndaha un ―catyí ra. Tan cuhva tsa janacaa̱ ra ndaha ra, iin yaha ñi nduvaha̱ tsi tumaa inga tsiyo. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tacan tan quita̱ ra fariseo naha ra cua natuhun tahan ra naha nácaa cua cahñi ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tsa tsito̱ ra Jesús tyin nducú ra naha tsi ra, quita̱ ra ican. Tan cuaha nyɨvɨ tsinyicu̱n tsi ra. Tan maa ra janduvaha̱ ra tsi tandɨhɨ ñi cuuhví. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tan catyí ra tsihin ñi tyin na ña catyi tuhun ñi yóo ra cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tacan cuvi̱ tyin tacan caha̱n ra Isaías, ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Tan tyehen tyaa̱ ra tuhun Nyoo: ");
INSERT INTO mjcNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ra ihya cuví musu yu, ra tsa nacatsi̱ vaha yu. Cuñí xaan yu tsi ra, tan sɨɨ xaan cuñí yu tsihin ra. Cua cuhva yu Tatyi Ii yu tsi ra. Tan cua jacoto ra tsi nyɨvɨ tsa ñavin nyɨvɨ Israel cuví, nácaa cua janduvaha yu tsi ñi nuu yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tan ña cua cahan yuhu ra tan ndi ña cua cana tsaa ra, tan ña cua cahan ñihi ra ityi cahnu. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tan ndi intuhun ndoo yacua, tan ña cua cahnu ndɨhɨ ra. Tan ndi ña cua ndahva ndɨhɨ ra tiñuhu lihli nu caná luxu yuhma. Nda cuanda coto tandɨhɨ nyɨvɨ tyin maa ra cuví ra ndacá ñaha tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tan tandɨhɨ nyɨvɨ, tan cua cuita iñi ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tacan tan tsindaca̱ nyɨvɨ tsi iin ra yɨhɨ́ tatyi ña vaha nu nyií ra Jesús, cuaa ra tan ñɨɨhɨ ra. Tan ra Jesús janduvaha̱ ra tsi ra. Tacan tan nacaha̱n ra, tan nanyehe̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iyo xaan cuñí tandɨhɨ nyɨvɨ, tan catyí ñi: ―¿A ñavin ra ihya cuví tata ra rey David? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tan cuhva tsa tsiñi̱ ra fariseo naha ra tsa caahán ñi, catyí ra naha: ―Tsihin tunyee iñi nu Beelzebú, nu cuví ityi nuu tsihin nu ña vaha nahnu, tavá ra ihya tatyi ña vaha ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Maa tyin ra Jesús tsitó ra tsa tsicá iñi ra naha, yacan cuenda catyí ra tsihin ra naha: ―Tatun ra ndacá ñaha naha ra tan cua natahvi ra naha, tan cua cañi tahan ra naha, tacan tan cundɨhɨ tyiñu tsa ndacá ñaha ra naha. Tan tatun iin ñuu o tandɨhɨ nyɨvɨ iin vehe tan cusɨɨn ñi, tacan tan cua tɨvɨ nu yucú ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tan tacan tucu tatun nu ña vaha tan tava nu juvin ñi tahan maa nu, cuñí tsi catyi tyin ña iin ñi cuví nahnu, tan cundɨhɨ tunyee iñi tsa iyó tsi nahnu. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tan nyooho catyí ndo tyin tsihin tunyee iñi nu Beelzebú tavá yu tsi nu tatyi ña vaha nahnu. Tun tsatyin tavá yu tsi nahnu tumaa cuhva catyí ndo, yóo tsahá tunyee iñi tsi ra nyicun tsi ndo tan tavá ra naha tsi nahnu. Maa ra naha cua cahan tsa nditsa tsihin ndo, tyin nyooho soho xaan tsicá iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yacan cuenda catyí yu tsihin ndo, tyin yuhu tavá yu tatyi ña vaha tsihin tunyee iñi Tatyi Ii Nyoo. Tan cuñí tsi catyi yacan tyin nditsa tyin tsa tsaa̱ cuhva ndacá ñaha Nyoo nu yucú ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Tan ¿yóo cuví quɨhvɨ tsitsi vehe iin ra xaan, tan quihin nyaa ra ndaha tyiñu ra? Yoñi. Maa tyin tatun cuhñi jihna ra tsi ra can, tacan tan cuví quihin nyaa ra tandɨhɨ tsa iyó tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Nyɨvɨ tsa ña nyaá tumañi iñi tsihin yu, ñi xaan iñi tsi yu cuví ñi. Ñi tsa ña jatyinyeé tsi yu tsa caahán yu tuhun Nyoo tsihin nyɨvɨ, cuñí tsi catyi tyin ña tsahá ñi tsa coto nyɨvɨ tuhun caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Yacan cuenda catyí yu tsihin ndo tyin Nyoo jahá ra tucahnu iñi cuatyi nyɨvɨ, tan tsihin náa tsa ña vaha caahán ñi, maa tyin tatun cua cahan ñi ndavaha ñi sɨquɨ Tatyi Ii Nyoo, yacan nditsa, ña cua jaha Nyoo tucahnu iñi tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tan yóo nyɨvɨ tsa caahán tsa ndavaha ñi sɨquɨ yuhu Rayɨɨ tsa quee̱ nda gloria, Nyoo cua jaha ra tucahnu iñi tsi ñi tsa cuenda can. Maa tyin nyɨvɨ tsa caahán tsa ndavaha ñi sɨquɨ Tatyi Ii Nyoo, ña cua coo tucahnu iñi tsi ñi tsa cuenda cuatyi can, ndi ñuu ñayɨvɨ ihya, tan ndi inga ñuu ñayɨvɨ tsa cua coo. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Iin yutun vaha tsahá tun tsɨtɨ vaha. Tan iin yutun ña vaha tsahá tun tsɨtɨ ña vaha. Nacotó yo tatun yutun vaha cuví tun tsa cuenda tsɨtɨ tun. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Nyooho, nyɨvɨ caquiñi tumaa tata coo xaan cuví ndo! ¿Nacaa cuví quitá tsa vaha yuhu ndo, tan nyɨvɨ caquiñi cuví ndo? Tyin tsa quitá tsitsi añima yo, yacan caahán yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nyɨvɨ vaha, vaha caahán ñi tyin yɨhɨ́ tsa vaha añima ñi. Tan nyɨvɨ caquiñi, tsa caquiñi caahán ñi, tyin tsa caquiñi yɨhɨ́ tsitsi añima ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Tan yuhu catyí yu tsihin ndo tyin quɨvɨ cua tatsi tuñi Nyoo tsi tandɨhɨ nyɨvɨ, cua cuhva cuenda ñi tandɨhɨ tuhun tsa ña vaha caha̱n ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tyin tsa cuenda tsa caahán ndo, tan cua catyi Nyoo tun vaha ndo o ña vaha ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tacan tan juhva ra fariseo tan ra maestro cuenda ley vehe ñuhu catyí ra naha tsihin ra Jesús: ―Maestro, cuñí ndi tyin javaha un iin tsa iyo tyin tacan tan coto ndi tun Sehe Nyoo cuví tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tan nacaha̱n ra Jesús tan catyí ra: ―Nyɨvɨ ña vaha tan nyɨvɨ tsa nyicún inga nyoo cuñí ñi nyehe ñi tsa iyo. Maa tyin ña cua nyehe ñi tsa iyo, intuhun ñi tsa cua nyehe ñi, tumaa tsa javaha̱ Nyoo tsihin ra Jonás ra cuvi̱ ndusu yuhu ra taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tyin tumaa tsinyii̱ ra Jonás tsitsi tyaca cahnu uñi quɨvɨ tan uñi tsacuaa, tacan cua cunyii yuhu Rayɨɨ tsa quee̱ nda gloria tsitsi ñuhu uñi quɨvɨ tan uñi tsacuaa. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tan quɨvɨ cua tatsi tuñi Nyoo tsi tandɨhɨ nyɨvɨ, cua nduvita nyɨvɨ tsicoo̱ ñuu Nínive taha̱n tsanaha tan cua catyi ñi na tatsi tuñi Nyoo tsi nyooho nyɨvɨ tsa iyó vityin. Tan cua catyi ñi tyin cua cunaa ndo, tyin maa ñi tsa cuví ñi ñuu Nínive, nasama̱ ñi cuhva iyó ñi quɨvɨ caha̱n ra Jonás tuhun Nyoo tsihin ñi. Tan ihya nyií ra cahnu ca cuví tan ñavin ca ra Jonás. Tan ña cuñí ndo tyaa soho ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tan tacan tucu ñaha tsa tsindaca̱ ñaha ityi Sur, cua nduvita ña quɨvɨ cua cutuñi nyɨvɨ tan cua catyi ña tyin cua cunaa nyooho nyɨvɨ iyó vityin, tyin maa ña, vasu cañi ñuu ña maa tyin quitsi̱ ña, quitsi̱ tyaa̱ soho ña tsa nyityi tsa caha̱n ra Salomón. Tan vityin cahnu ca ra caahán tsihin ndo tan ñavin ca ra Salomón. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Tatun iin nu tatyi ña vaha quita̱ nu tsitsi añima iin nyɨvɨ, tsicá nuu nu ñuhu ityi, nanducú nu iin nu quitatu nu. Tan ña nañihi maa nu nu quitatu nu. Tacan tan tsicá iñi nu: ");
INSERT INTO mjcNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Cunuhu yu nda vehe yu nu quee̱ yu.” Tacan tan cuahán nyico nu añima nu quee̱ nu. Tan nyehe̱ nu tyin ndɨɨ xaan, tan yoñi iyó, tan sɨɨ xaan caá. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tacan tan cua quihin nu utsa taahan ca tatyi ña vaha, tsa yaha ca caquiñi tan ñavin ca maa nu. Tacan tan iin caa ñi quɨhvɨ tandɨhɨ tatyi ña vaha can añima ñi can. Yacan cuenda, yaha ca ndasɨ cua coo ñi tan ñavin ca tsa ndi cumañi ca quita nu. Tan tacan cua cuvi tsi nyɨvɨ quiñi iyó ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ndi caahán ca ra Jesús tsihin nyɨvɨ, tan tsaa̱ sɨhɨ ra tan yañi ra, tan nyecú ñi ityi tsata vehe, tan cuñí ñi cahan ñi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tacan tan jacoto̱ iin ra tsi ra Jesús, tan catyí ra: ―Sɨhɨ un tsihin ra yañi un naha ra nyecú ñi tsata vehe. Tan cuñí ñi cahan ñi tsihin un. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tan nacaha̱n ra Jesús tan catyí ra tsihin ra can: ―¿Yóo cuví sɨhɨ yu tan yóo cuví yañi yu? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tacan tan janaha̱ ndaha ra nu nyecú ra tsicá tsihin ra, tan catyí ra: ―Ra ihya naha ra cuví sɨhɨ yu tan yañi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tyin tandɨhɨ nyɨvɨ tsa javahá cuhva cuñí Jutu yu, ra nyaá gloría, juvin ñi can cuví yañi yu, tan cuhva yu, tan sɨhɨ yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Quɨvɨ can quita̱ ra Jesús vehe nu nyií ra tan cuahán ra, tsicunyaa̱ ra yuhu miñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tan cuaha xaan nyɨvɨ ndu ii̱n nu nyaá ra, yacan cuenda quɨhvɨ̱ ra tsitsi iin yutun ndoo tan tsinyaa̱ ra. Tan tandɨhɨ nyɨvɨ ndoo̱ ñi yuhu ndutya. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tacan tan quitsaha̱ jacuahá ra tsi ñi tan caahán ra tsihin ñi tsihin iin cuhva, tan catyí ra: ―Quita̱ iin ra vehe ra. Cuahán ra nu iyó tyiñu jahá ra, cuatatsí ra tsɨtɨ trigu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tan cuhva tsa quɨtɨ́ ra tsɨtɨ can, cucoyo̱ juhva tsi yuhu ityi. Tan quitsi̱ saa tan tsatsi̱ tɨ tsɨtɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tan juhva ca tsɨtɨ can cucoyo̱ tyañu yuu nu ña cuaha nyahyu yɨhɨ́. Tan ican cana̱ tsɨtɨ can tsa numi ñi tyin ña cuaha nyahyu yɨhɨ́ tyañu yuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Maa tyin cuhva tsa cana̱ ñicanyii, numi ñi na ityi̱ tsi, tyin ña cunu yɨhɨ́ yoho tsaha tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Juhva ca tsɨtɨ can cucoyo̱ tyañu iñu. Tan quɨvɨ cana̱ trigu can tsahnu̱ tsi iin caa ñi tsihin iñu can, tan iñu can numi xaan ca tsahnu̱ tsi tan tsahñi̱ tsi trigu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Maa tyin juhva ca tsɨtɨ can cucoyo̱ nu ñuhu vaha. Tan quɨvɨ tsahnu̱ tsi, vaha xaan tsaha̱ tsi tsɨtɨ. Tyin tsa iin tsɨtɨ can, cientu tsɨtɨ quita̱ tsihin tsi. Tan inga tsɨtɨ can, uñi xico, tan inga tsi oco utsi tsɨtɨ tsaha̱ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Tatun nyaá soho ndo, tya̱a soho ndo tuhun caahán yu! ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tacan tan natuhva̱ ra tsicá tsihin ra Jesús, tan tsica̱ tuhun ra naha tsi ra, tan catyí ra naha: ―¿Nacuenda tyin tsihin cuhva ñi jacuahá un tsi nyɨvɨ, tan ña catyí tuhun catsi un tsihin ñi? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tan nacaha̱n ra Jesús tan catyí ra: ―Tsi nyooho jacotó Nyoo tuhun xeehe, cuhva ndacá ñaha ra, maa tyin nyɨvɨ ihya ña cuví coto ñi tsa tsaha̱ Nyoo tsi nyooho. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tyin tandɨhɨ nyɨvɨ tsa cutuñí iñi tsa caahán yu tan javahá ñi, cuaha ca cua cutuñi iñi ñi. Tan nyɨvɨ tsa ña cutuñí iñi, tan ña cuñí ñi javaha ñi, cua quihin nyaa ndɨhɨ yu tsa luxu ñi tsa tsitó ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yacan cuenda caahán yu tsihin ñi tsihin cuhva, tyin nyehé ñi tan cuví tsi tumaa tsa ña nyehé ñi. Tsiñí ñi maa tyin ña cutuñí iñi ñi, tumaa tsa ña tsiñí ñi cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tyin tacan tan cundaa tsa caha̱n ra Isaías ra cuví ndusu yuhu Nyoo taha̱n tsanaha, tan catyí ra: Tsa nditsa tyin nyooho tsiñí ndo tuhun yu, maa tyin ña cutuñí iñi ndo. Cua nyehe ndo tsa javahá yu, tan ña cua cutuñi iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tyin tsa ndundava̱ xaan añima nyɨvɨ ihya, tan ña catsi vaha tsiñí ñi. tan ndasɨ́ tinuu ñi, na ña cua nyehe ñi tsihin tinuu ñi, tan ña cua cuñi ñi tsihin soho ñi. Tan ndi ña cua cutuñi iñi ñi tsihin añima ñi. Tan ndi ña cua nanducu ñi tsi yu, na janduvaha yu tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Maa tyin sɨɨ xaan cuví tsi nyooho, tyin nyehé ndo tsihin tinuu ndo, tan tsiñí ndo tsihin soho ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tsa nditsa catyí yu tsihin ndo, tyin cuaha xaan ra cuvi̱ ndusu yuhu Nyoo tan cuaha xaan nyɨvɨ vaha, cuñi̱ ñi nyehe ñi tsa nyehé nyooho tsa javahá yu, maa tyin ña nyehe̱ ñi. Tan cuñi̱ ñi tyaa soho ñi tandɨhɨ tsa tsiñí nyooho vityin, maa tyin ña tsiñi̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Tya̱a soho ndo tsa cuñí tsi catyi cuhva tsa caha̱n yu tsa cuenda ra tsa tatsí tsɨtɨ trigu can: ");
INSERT INTO mjcNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nyɨvɨ tsa tsiñí tuhun nácaa cuñí Nyoo cundaca ñaha ra añima ñi, tan ña cutuñí iñi ñi, cuví ñi tumaa nu cucoyo̱ tsɨtɨ trigu yuhu ityi. Tan quitsi̱ nu ña vaha tan quihi̱n nyaa nu tuhun Nyoo tsa iyó añima ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tan tumaa nu cucoyo̱ tsɨtɨ can tyañu yuu, juvin ñi nyɨvɨ tsa tsiñí tuhun Nyoo cuví can. Tan sɨɨ xaan naquihi̱n vaha ñi itsi juhva ñi quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tyin nduve ñuhu cunu ican, yacan cuenda cana̱ tsɨtɨ can, maa tyin ña cuví cuhun yoho tsi. Tan tacan cuví nyɨvɨ can. Juhva ñi quɨvɨ tsinú iñi ñi. Maa tyin quɨvɨ tsa quitsahá nyehe ñi tundoho, tan caahán ndasɨ nyɨvɨ tsata ñi tsa cuenda tuhun Nyoo, tacan tan jandɨhɨ́ ñi tsa tsinú iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tan tumaa nu cucoyo̱ tsɨtɨ can tsitsi iñu, juvin ñi nyɨvɨ tsa tsiñí tuhun Nyoo cuví can. Tsiñí ñi, maa tyin ña cuñí ñi javaha ñi tumaa tsiñí ñi. Tyin tyaá xaan ca iñi ñi tundoho ñayɨvɨ tan ñavin ca tuhun Nyoo. Tan nyiyo ca iñi ñi tsa cuca. Tan tandɨhɨ tuhun can jatyañú tsi tsi ñi, tan cuví ñi tumaa yutun tsa ña tsahá tsɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tan ñuhu vaha nu cucoyo̱ tsɨtɨ can, yacan cuví inga nyɨvɨ tsa tsiñí tuhun Nyoo, tan cutuñí iñi ñi, tan javahá ñi tandɨhɨ tuhun caahán ra. Yɨhɨ́ ñi cuví ñi tumaa tsɨtɨ tsa cana̱ tan tsaha̱ tsi iin cientu tsɨtɨ, tan inga ñi cuví ñi tumaa tsɨtɨ tsa tsahá uñi xico, o tumaa tsɨtɨ tsa tsahá oco utsi tsɨtɨ intuhun intuhun. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tan caha̱n tucu ra Jesús inga cuhva ihya tsihin ñi; tan catyí ra: ―Tsa ndacá ñaha Nyoo tsi nyɨvɨ cuví tsi tumaa iin ra tsa tatsi̱ tsɨtɨ trigu nu ñuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tan cuhva tsa quixí tandɨhɨ ra jahá tyiñu naha ra, quɨhvɨ̱ iin ra xaan iñi tsi ra jatsii can, tan quɨtɨ̱ ra tsɨtɨ cuhu ña vaha, tan cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tan quɨvɨ cana̱ tsɨtɨ trigu can, tan cana̱ yoco tsi, cana̱ ndɨhɨ tucu cuhu ña vaha can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tacan tan ra cuví musu can naha ra, tsaha̱n ra naha tsicatyi̱ tuhun ra naha tsihin tsitoho ra naha: “Tata, maa ñi tsɨtɨ trigu tatsi̱ ndi, ¿tan nacuenda tyin cana̱ cuhu ña vaha can?” catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tan nacaha̱n ra can tan catyi ra: “Iyó iin ra xaan iñi tsi yu javaha̱ tsehe, tun cuvi.” Tacan tan musu can, catyí ra naha tsihin tsitoho ra: “¿A cuñí un tyin cuhun ndi tan tuhun ndi cuhu ña vaha can?” ");
INSERT INTO mjcNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tan tsitoho ra naha catyí ra: “Ña tu̱hun ndo, tyin coto tuhun ndɨhɨ ndo trigu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ja̱ña ndo, na cuahnu maa tsi iin caa ñi tsihin trigu can, tatun tsa tsitsa tsi, tacan tan cua tava tyiñu yu na tuhun jihna ra naha cuhu ña vaha can, tan cuhñi ra naha cuenda jucun, tan cahmi ra naha. Tan yaha can tan natyihi vaha ra naha tsa vaha can tsitsi yaca yu.” ");
INSERT INTO mjcNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tacan tan caha̱n ra Jesús inga cuhva ihya tsihin ñi tan catyí ra: ―Tsa ndacá ñaha Nyoo tsi nyɨvɨ cuví tsi tumaa iin tsɨtɨ mostaza tsa tatsi̱ iin ra nu ñuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tyin tsɨtɨ can lihli ñi tsi tan ñavin ca tandɨhɨ ca tsɨtɨ. Maa tyin quɨvɨ tsahnu̱ tsi cuví tsi iin yutun. Tan quitsi̱ saa, tan javahá tɨ taca tɨ soco tun ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tan caha̱n ra Jesús inga cuhva ihya tsihin ñi tan catyí ra: ―Tsa ndacá ñaha Nyoo tsi nyɨvɨ cuví tsi tumaa yutsan iya tsa nasaca̱ nuu iin ñaha tsihin uñi jahma yutyi paan. Tyin tumaa ndaá tandɨhɨ yutsan paan can jahá tsa luxu ñi yutsan iya can, tacan cuví tsa ndacá ñaha Nyoo tsi yo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tandɨhɨ tuhun can caha̱n ra Jesús tsihin nyɨvɨ tsihin cuhva. Tan tandɨhɨ tsa caha̱n ra tsihin ñi ña caha̱n catsi maa ra, maa ñi maa tsihin cuhva caha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tacan cuvi̱ tyin tacan tan cundaa tsa caha̱n Jutu Mañi yo tsihin yuhu ra cuvi̱ ndusu yuhu ra taha̱n tsanaha tan tyaa̱ ra tyehen: Tsihin cuhva cua cahan yu tsihin nyɨvɨ. Cua cahan yu tsihin ñi tuhun tsa yɨhɨ́ xeehe nda cuanda tsa javaha̱ Nyoo ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tacan tan jacunuhu̱ ra Jesús tsi nyɨvɨ, tan quɨhvɨ̱ ra tsitsi vehe nu nyií ra. Tan natuhva̱ ra tsicá tsihin ra nu nyaá ra, tan catyí ra naha tsihin ra: ―Ca̱tyi tuhun tsihin ndi náa cuñí tsi catyi tsa caha̱n un tsihin nyɨvɨ tsa cuenda cuhu ña vaha tan trigu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tacan tan quitsaha̱ catyí ra Jesús tsihin ra naha: ―Ra tsa tatsi̱ tsɨtɨ trigu can cuví yuhu Rayɨɨ tsa quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tan ñuhu can cuví nyɨvɨ iyó nu ñuhu ñayɨvɨ. Tan tsɨtɨ trigu can cuví nyɨvɨ tsa ndacá ñaha Nyoo. Tan cuhu ña vaha can cuví nyɨvɨ tsa nyicún tsi nu ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tan nu tsa tatsi̱ cuhu ña vaha can, nu ican cuví nu ña vaha juvin ñi nu tsa xaan iñi tsi yu. Tan quɨvɨ cua naquihin yu tyiñu jahá yu, yacan cuñí tsi catyí quɨvɨ cua cundɨhɨ ñuhu ñayɨvɨ. Tan ra tsa cua naquihin tsɨtɨ can, cuví ra ángel naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tumaa jataca̱ ra naha cuhu ña vaha can tyin cayu tsi, tacan cua cuvi quɨvɨ cua cundɨhɨ ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yuhu Rayɨɨ tsa quee̱ nda gloria cua jaquitsi yu ángel tan jataca ra naha tsi nyɨvɨ natyuhu tsi inga nyɨvɨ na javaha ñi tsa ña vaha tan inga nyɨvɨ tsa iyó cuatyi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tan cua tyihi ra naha tsi ñi tsitsi ono nu cayú ñuhu̱. Tan ican cua vacu tsaa ñi tan cahyu ña cua cuvi nuhu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nyooho tan nyɨvɨ javahá cuhva cuñí Nyoo cua quituvi ndo nuu Jutu yo. Tan cua cuvi ndo tumaa tsa nditsin ñuhu̱ ñicanyii, nu ndacá ñaha Jutu yo. Tatun iyó soho ndo, tya̱a soho ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Tsa ndacá ñaha Nyoo tsi nyɨvɨ cuví tsi tumaa xuhun cuaan tsa yɨhɨ́ xeehe tsitsi ñuhu. Tan iin ra nañihi̱ ra xuhun cuaan can, tan tyihi̱ xeehe nyico ra inga tsaha, tan sɨɨ xaan cuñí ra cuanuhu ra tan xico̱ ra tandɨhɨ tsa iyó tsi ra. Tacan tan jata̱ ra ñuhu nu yɨhɨ́ xeehe xuhun cuaan can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Tan tsa ndacá ñaha Nyoo tsi nyɨvɨ, cuví tucu tsi tumaa iin ra najatá yuu xiñu tan naxicó nyico ra, ");
INSERT INTO mjcNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","tan tsa ñihi̱ ra iin tsa yahví xaan nyaá, xico̱ ra tandɨhɨ maa tsa cumi̱ ra, tan jata̱ ra yuu xiñu vaha can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Tan juvin ñi cuví tucu tsa ndacá ñaha Nyoo tsi nyɨvɨ tumaa iin traya tsa cañí ra naha nu ndutya ñuhu, tan ñihí ra naha tandɨhɨ nuu tyaca. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tan tsa tsitu̱ traya can tsihin tyaca, tavá ra naha traya can nu ityi. Tan ican nacatsí ra naha tsi tɨ, naquihín vaha ra naha quɨtɨ vaha tsitsi iin tyica, tan javitá ra naha quɨtɨ ña vaha can. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tan tacan cua cuvi quɨvɨ naa ñayɨvɨ, cua quitsi ángel, quitsi tava sɨɨn ra naha tsi nyɨvɨ vaha tan nyɨvɨ ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tan cua tyihi ra naha tsi nyɨvɨ ña vaha can anyaya nu cayú ñuhu̱, nu cua vacu tsaa ñi tan cahyu ña cua cuvi nuhu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tacan tan ra Jesús tsica̱ tuhun ra tsi ra tsicá tsihin ra, tan catyí ra tsihin ra naha: ―¿A cutuñi̱ iñi ndo tandɨhɨ tsa caha̱n yu? Tan nacaha̱n ra naha tan catyí ra naha: ―Cutuñi̱ iñi ndi, Jutu Mañi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tacan tan catyí ra Jesús tsihin ra naha: ―Iin ra cuví maestro cuenda ley tsa tsitó maa ra tuhun tsahnu tan tatun cua coto ndɨhɨ ra nácaa ndacá ñaha Nyoo tsihin tandɨhɨ tuhun tsaa tsa caahán yu, cua cuvi ra tumaa iin ra jatsii vehe tan cua jacuaha ra nduvi taahan tuhun vaha can tsi nyɨvɨ ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tsa ndɨhɨ̱ caha̱n ra Jesús cuhva ihya tan quita̱ ra cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tan tsaa̱ nyico ra ñuu ra. Tan quitsaha̱ jacuahá ra tsitsi vehe ñuhu ñuu can. Tan iyo cuñí nyɨvɨ tan catyí ñi: ―¿Nu maa tahan cutuhva̱ ra ihya tsa tsitó xaan ra? ¿Tan nácaa cuví javaha ra tsa iyo? ");
INSERT INTO mjcNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tyin sehe ra tahví yutun can cuví tsi ra. Tan ña María cuví sɨhɨ ra. Tan yañi ra cuví tsi ra Jacobo, ra José, ra Simón tan ra Judas. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tan cuhva ra iyó tucu ñi ityi nu iyó yo. Tun tacan, ¿nu maa tahan cutuhva̱ ra tandɨhɨ tsa tsitó ra? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tan yacan cuenda ña cuñí ñi tyaa yahvi ñi tsi ra. Maa tyin ra Jesús catyí ra tsihin ñi: ―Tandɨhɨ nyɨvɨ tandɨhɨ ñi ityi jahá ñi tsa ñayɨvɨ tsi ra ndusu yuhu Nyoo, maa tyin nyɨvɨ ñuu ra ña tyaá yahvi ñi tsi ra tan ndi nyɨvɨ vehe ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tan ña cuaha tsa iyo javaha̱ ra ñuu ra tsa cuenda tyin ña tsinú iñi ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Quɨvɨ can ra Herodes, ra ndacá ñaha nɨcahnu nu cuví Galilea, ñihi̱ tuhun ra tsa javahá ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tan catyí ra tsihin ra yucú tsihin ra: ―Ra ican cuví ra Juan, ra jacoondutya̱ tsi nyɨvɨ, ra tsa tsihi̱ tan vityin nandoto̱ nyico ra. Yacan cuenda iyó tunyee iñi tsi ra tsa javahá ra tsa iyo. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tacan catyi̱ ra tyin juvin ñi maa ra tava̱ tyiñu tyin tɨɨn ra naha tsi ra Juan. Tan cuhñi ra naha tsi ra tsihin cadena, tan tyihi ra naha tsi ra vehe caa. Tacan javaha̱ ra Herodes tyin xaan cuñí ra tyin catyi̱ ra Juan tyin ña vaha tsa cumí ra tsi ña Herodías tyin ña ican cuví ñasɨɨhɨ ra Felipe, yañi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yacan cuenda ra Herodes cuñi̱ ra cahñi ra tsi ra Juan, maa tyin yuuhví ra tsi nyɨvɨ, tyin tandɨhɨ ñi tsinú iñi ñi tyin ra Juan, ndusu yuhu Nyoo cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tan iin quɨvɨ iyó vico ra Herodes, tan sehe ña Herodías quitsaha̱ tsañí ña yaa nu yucú ñi vico can. Tan taha̱n xaan iñi ra Herodes. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tan catyí ra: ―Naha Nyoo tyin cua cuhva yu náa cua ndacan ñaha tyuvaa ihya tsi yu ―catyí ra Herodes. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tacan tan natyuhu̱ sɨhɨ ña tsi ña, na cahan ña tsihin ra Herodes. Tacan tan catyí ña tyehen tsihin ra: ―Cu̱hva jiñi ra Juan, ra jacoondutyá tsi nyɨvɨ, tsi yu nu iin coho ―catyi̱ ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tsa tsiñi̱ ra rey Herodes tsa caha̱n ña, nducuiihya̱ cuñí ra. Maa tyin tsa cuenda tsa caha̱n ra tyin tandɨhɨ tsa cua ndacan ña tan cua cuhva ra, yacan cuenda ña cuvi jandaví ñaha ra tyin tandɨhɨ nyɨvɨ yucú vico can tan tsiñi̱ ñi tsa caha̱n ra. Yacan cuenda tava̱ tyiñu ra na cuhva ra naha jiñi ra Juan tsi ña nu iin coho. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tan tava̱ tyiñu ra na cucahnya ra naha jucun ra Juan nu nyií ra vehe caa. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tacan tan tsindaca̱ ra naha jiñi ra Juan tsi ña, nyií tsi nu iin coho. Tan tsaha̱ ra naha tsi ñaha tyuvaa can. Tan maa ña nacuhva̱ cuenda ña tsi sɨhɨ ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tacan tan tsaa̱ ra nyicu̱n tsi ra Juan naha ra tan naquihi̱n ra naha cuñu ñuhu ra, tan tyihi̱ ra naha tsitsi ñuhu. Yaha̱ can tan tsaha̱n ra naha tsijacoto̱ ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tsa tsito̱ ra Jesús tsa taha̱n ra Juan, quihi̱n ra iin yutun ndoo, tan cuahán intuhun ñi maa ra nu taxin caa. Tan tsa tsito̱ nyɨvɨ, quita̱ ñi ñuu ñi, tan cuahán tsihin tsaha ñi nu nyií ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tsa quita̱ ra Jesús tsitsi yutun ndoo can, tan nyehe̱ ra tyin cuaha xaan nyɨvɨ nyicún tsi ra. Tan cundaahvi̱ iñi ra nyehe̱ ra tsi ñi. Tan janduvaha̱ ra tsi nyɨvɨ cuuhví tsa tsaa̱ tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tan tsa cuñí cuaa̱, tacan tan natuhva̱ ra tsicá tsihin ra Jesús nu nyaá ra, tan catyí ra naha tsihin ra: ―Tsa cueñi xaan, tan yoñi nyɨvɨ iyó yatyin ñi ihya. Yacan cuenda vaha ca ca̱han un tsihin nyɨvɨ ihya na cunuhu ñi nda ñuu cujata ñi tsa catsi ñi ―catyí ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tan ra Jesús catyí ra: ―Nduve náa nducu ñi cuhun ñi. Cu̱hva nyooho tsa catsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tan nacaha̱n ra naha tan catyí ra naha: ―Nduve maa náa iyó ihya. Uhun taahan ñi paan, tan uvi taahan ñi tyaca iyó. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tan catyí ra Jesús: ―Nda̱ca ndo can tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tacan tan catyí ra tsihin nyɨvɨ tyin na cunyecu ñi nu cuhu can. Yaha̱ tsa tsinyecu̱ ñi tan quihi̱n ra uhun taahan paan can, tan nduvi tyaca can. Tan nanyehe̱ ndaa ra ityi sɨquɨ, tan nacuhva̱ ra tyahvi nyoo tsi Nyoo tan tsahnu̱ cuatyi ra paan can. Tan tsaha̱ ra tsi ra tsicá tsihin ra, na tsatsa ra naha tsi nyɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tan tandɨhɨ nyɨvɨ tsatsi̱ ñi tan ndaha vaha iñi ñi. Yaha̱ can tan ndoo̱ ca tsa ñahñu, tan jacutu̱ ra naha utsi uvi tyica tsihin tsa ñahñu ican. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tan tsa tandɨhɨ ñi tsa tsatsi̱ can, quita̱ maa tumaa uhun mil tsa maa ñi maa rayɨɨ. Tan sɨɨn maa ñiñaha tan tsa nyihi. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tsa yaha can tan catyí ra Jesús tsihin ra tsicá tsihin ra, na quɨhvɨ ra naha tsitsi yutun ndoo, tan na yaha sava ra naha nu miñi can tan cuhun ra naha inga tsiyo. Tan tsitsi tsa cuahán ra can naha ra, ra Jesús ndoo̱ ra tan catyí ra tsihin nyɨvɨ tyin na cuhun ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tsa yaha̱ tsa jacunuhu̱ ra tsi ñi, tan ndaa̱ ra yucu can cua ndacan tahvi intuhun ñi maa ra tsi Nyoo. Maa tyin tsitsi tsa nyií ra can tan cuaa̱. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tan tsitsi tsa tsicán tahvi ra tsi Nyoo, yutun ndoo can tsa cuahán cuii tsi nda mahñu miñi. Tan ndutya miñi can cañí tsi tsi yutun ndoo can tsa cuenda tyin ñihi xaan yɨhɨ́ tatyi nu cuahán ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tan tsa cua tuvi cuahán ndɨhɨ ra Jesús nu cuahán ra naha tsihin yutun ndoo can, tan tsicá tsihin tsaha ra cuahán ra nu ndutya. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tan cuhva tsa nyehe̱ ra naha tsi ra, tsicá ra nu ndutya can, nayuhvi̱ xaan ra naha. Tan caná tsaa ra naha, tan catyí ra naha: ―¡Jihna ndo xin. Tatyi vatsí can! ");
INSERT INTO mjcNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Maa tyin nacaha̱n ra Jesús tsihin ra naha, tan catyí ra: ―¡Ña na̱yuhvi ndo tyin maa yu cuví! ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tacan tan nacaha̱n ra Pedro tan catyí ra: ―Jutu Mañi yu, tatun maa un vatsí juvin, cu̱hva tsa quitsi ndɨhɨ yu nu vatsí un. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tan ra Jesús catyí ra tsihin ra: ―Na̱ha jiin. Tacan tan quita̱ ra Pedro tsitsi yutun ndoo can, tan quitsaha̱ tsicá ra nu ndutya tan cuahán ra nda nu vatsí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Maa tyin cuhva tsa tuvi̱ iñi ra tyin ñihi xaan quitsaha̱ yɨhɨ́ tatyi, nayuhvi̱ xaan ra, tacan tan quitsaha̱ cuñí nyee ra, tan quitsaha̱ caná tsaa ra tan catyí ra: ―¡Ja̱cacu tsi yu, Jutu Mañi yu! ");
INSERT INTO mjcNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tan iin yaha ñi tɨɨ̱n ra Jesús ndaha ra, tan catyí ra tsihin ra: ―¿Nacuenda tsa nayuhvi̱ un, yooho tsa luxu xaan tsinú iñi tsi yu? ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tan cuhva tsa quɨhvɨ̱ ra naha tsitsi yutun ndoo can, cutaxi̱n tatyi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tacan tan ra yucú tsitsi yutun ndoo can tsicuɨñɨ̱ tsɨtɨ ra naha nuu ra Jesús, tan catyí ra naha tsihin ra: ―Nditsa nditsa tyin Sehe Nyoo cuví tsi yooho ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tsa yaha̱ sava ra naha miñi can, tsaa̱ ra naha ñuhu Genesaret. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tan cuhva tsa nacoto̱ nyɨvɨ iyó ican tsi ra Jesús tyin juvin ra cuví, jacoto̱ ñi tsi tandɨhɨ nyɨvɨ iyó tanɨɨ cahnu can. Tan tsindaca̱ ñi tandɨhɨ nyɨvɨ cuuhví nu nyií ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tan caahán ndaahvi ñi tsihin ra, na cuhva ra tsa tɨɨn ñi vasu luxu jahma ra. Tan tandɨhɨ ñi tsa tɨɨ̱n jahma ra, nduvaha̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tacan tan juhva ra cuví fariseo tan ra cuví maestro cuenda ley vehe ñuhu quee̱ ra naha ñuu Jerusalén. Tan tsaha̱n ra naha nu nyií ra Jesús tan tsica̱ tuhun ra naha tsi ra, tan catyí ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Nacuenda ña javahá ra tsicá tsihin un naha ra cuhva nacoo̱ tsii tsaahnu yo?, tyin catyi̱ ra ican naha ra tyin iyó iin cuhva ndoo ndaha yo tsa ndi cumañi ca catsi yo, maa tyin ra tsicá tsihin un ña tyaá yahvi ra naha tuhun tsahnu can ―catyi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tan tsica̱ tuhun ra Jesús tsi ra naha, tan catyí ra: ―¿Nacuenda tyaá yahvi xaan ca ndo tuhun tsahnu tsa iyó ndo tan ña cuñí ndo tyaa yahvi ndo tsa caahán Nyoo? ");
INSERT INTO mjcNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tyin Nyoo catyí ra: “Tya̱a yahvi ndo tsi jutu ndo tan tsi sɨhɨ ndo, tyin tandɨhɨ nyɨvɨ tsa caahán ndavaha ñi sɨquɨ jutu ñi o sɨhɨ ñi, cua cúu ñi”, catyí Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Maa tyin nyooho catyí ndo tyin cuví catyi ndo tsihin jutu ndo o tsihin sɨhɨ ndo tyehen: “Ña cuví jatyinyee yu tsi un tyin tsa tsaha̱ yu tandɨhɨ tsa iyó tsi yu tsi Nyoo.” ");
INSERT INTO mjcNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tatun tsa catyi̱ ndo yacan, ña cuñí tsi tsa jatyinyee ndo tsi jutu ndo o tsi sɨhɨ ndo, catyí ndo. Tan yacan cuví tsa javahá ndo vityin, tyaá tsiyo ndo tsa caahán Nyoo tan tyaá yahvi xaan ca ndo tuhun tsahnu tsa iyó ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Nyooho cuñí ndo tyin vaha xaan ndo, maa tyin ña nditsa ndo! Nditsa tsa caha̱n ra Isaías, ra cuvi̱ ndusu yuhu Nyoo, sɨquɨ ndo jaha̱ Nyoo. Tan catyí ra tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nyɨvɨ ihya, jacahnú ñi tsi yu tsihin yuhu ñi. Maa tyin ñavin tsihin tsa nɨɨ iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yacan cuenda nduve yahvi nyaá jacahnú ñi tsi yu. Tyin maa ñi tuhun caahán jacuahá ñi, tan ñavin tuhun yu jacuahá ñi. Catyi̱ ra Isaías tuhun ndo jaha̱ Nyoo, catyí ra Jesús tsihin ra ican naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tacan tan cana̱ ra Jesús tsi nyɨvɨ tan catyí ra tsihin ñi: ―Tya̱a soho ndo tsa caahán yu, tan ndu̱cu ndo cuhva cutuñi iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tyin nyɨvɨ tsa tɨvɨ́ nuu Nyoo, ñavin tsa quɨhvɨ́ yuhu ñi jatɨvɨ́ tsi ñi. Tyin tɨvɨ́ ñi jahá tsa quitá yuhu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tacan tan natuhva̱ ra tsa tsicá tsihin ra Jesús tan catyí ra naha tsihin ra: ―¿A tsitó un? Ra fariseo naha ra ndasɨ xaan cuñí ra naha tsa tsiñi̱ ra naha tsa caha̱n un. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tan maa ra Jesús nacaha̱n ra tan catyí ra: ―Tandɨhɨ yutun tsa ña tatsi̱ Jutu yu, ra nyaá gloria, cua tuhun ra nda cuanda yoho tun. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ja̱ña ndo tsi ra fariseo naha ra tyin ra cuaa cuví ra naha, tan janahá ra naha ityi tsi inga ra cuaa. Tan tatun iin ra cuaa tan janahá ra ityi tsi inga ra cuaa, nduvi taahan ra naha cua nacava ra naha tsitsi yavi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tacan tan quitsaha̱ catyí ra Pedro tsihin ra Jesús: ―Ca̱tyi tuhun tsihin ndi náa cuñí tsi catyi tsa caha̱n un nañi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tacan tan ra Jesús catyí ra tsihin ra naha: ―Ndi nyooho tan ña cutuñí ndɨhɨ iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A ña cutuñí iñi ndo tyin tsa tsatsí yo, tsitsi yo cuahán tsi? Yaha̱ can tan cua quita nyico tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Maa tyin tuhun tsa quitá yuhu yo, tsitsi añima yo queé can tan nyɨvɨ tɨvɨ́ ñi nuu Nyoo jahá tsa caahán ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tyin tsa caquiñi tsicá iñi ñi tsitsi añima ñi quitá can, tan cuñí ñi cahñi ñi nyɨvɨ. Cuñi ñi suhu ñi. Yɨhɨ́ nyɨvɨ caahán ñi cuendu, o jacuñí nyaa ñi tsi inga ca nyɨvɨ. Yɨhɨ́ ra cuñí ra coo inga ñaha ra, o ñiñaha iyó yɨɨ tsicá nuu ñi tsihin inga rayɨɨ. Yɨhɨ́ ra tsicoó ra tsihin ñaha tan ña tindaha ra tsihin ña. Tan yɨhɨ́ rayɨɨ quixí ra tsihin juvin ñi maa rayɨɨ. Tan ñiñaha yɨhɨ́ ñi quixí ñi tsihin juvin ñi maa ñaha. Tan tandɨhɨ ca maa tsa caquiñi tsa javahá ñi tsihin cuñu ñuhu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yacan cuví tsa jatɨvɨ́ tsi nyɨvɨ nuu Nyoo. Tyin tsa ña nacatyá ñi ndaha ñi tsa ndi cumañi ca catsi ñi, ña jatɨvɨ́ can tsi ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Quita̱ ra Jesús ñuu can tan cuahán ra ityi ñuu Tiro tan Sidón. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tan ityi can iyó iin ñaha Canaán. Tan tsa nyehe̱ ña tsi ra Jesús natuhva̱ ña nu nyaá ra tan caná tsaa ña tan catyí ña: ―Jutu Mañi yu, tata ra David, cu̱ndaahvi iñi tsi yu, tyin sehe yu yɨhɨ́ tatyi ña vaha tsi ña, tan nyehé xaan ña tundoho jahá nu ―catyí ña tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Maa tyin tumaa tsa ña tsiñi̱ ñi ra Jesús jahá ra tsi ra tan ña nacaha̱n ra tsa iin yaha ñi. Tacan tan natuhva̱ ra tsicá tsihin ra tan catyí ra naha tsihin ra: ―Ca̱han tsihin ña na cunuhu ña tyin utsan xaan yo tsa caná tsaa ña tsata yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tacan tan catyí ra Jesús tsihin ra naha: ―Vatsí yu jaha̱ Nyoo ñuu Israel tyin naquihin ndaahvi yu nyɨvɨ ñuu can tsa cuví ñi tumaa mbee tsa cuanaá. Tan tsa cuenda nyɨvɨ can vatsí yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tan ñaha can natuhva̱ ña nu nyaá ra tan tsicuɨñɨ̱ tsɨtɨ ña nuu ra, tan catyí ña tsihin ra: ―Jutu Mañi yu, ¡ja̱tyinyee tsi yu! ");
INSERT INTO mjcNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tan ra Jesús catyí ra tsihin ña: ―Ña vaha tsa quihin nyaa yo paan yuhu sehe yo, tan cuhva yo catsi ina ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Maa tyin ña ndasɨ cuñí ña tsa caha̱n ra, tan catyí ña tsihin ra: ―Nditsa, Jutu Mañi yu. Maa tyin nda cuanda ina tan tsatsí tɨ titsehe tsa cucoyo̱ xuu mesa tsitoho tɨ ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tacan tan catyí ra Jesús tsihin ña: ―Yooho ñaha, tsinú xaan iñi un tsi yu. Na cuvi maa cuhva tsicá iñi un. Tan juvin ñi cuhva can tan nduvaha̱ sehe ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tsa yaha̱ yacan tan ra Jesús cuahán ra ityi yuhu miñi Galilea, tan ndaa̱ ra iin jiñi yucu tan ican tsinyaa̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tan cuaha xaan nyɨvɨ cuahán ñi nu nyaá ra cuandacá ñi nyɨvɨ cuuhví tyin janduvaha ra tsi ñi. Yɨhɨ́ ñi coxo ñi, cuaa ñi, ñɨɨhɨ ñi, lundu ñi. Tan yɨhɨ́ ñi yɨhɨ́ inga ca nu cuehe tsi ñi. Tan tsaqui̱n nyecu ñi tsi tandɨhɨ ñi cuuhví can nu nyaá ra Jesús. Tan janduvaha̱ ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tan iyo xaan cuñí nyɨvɨ can nyehé ñi tyin nacaha̱n ñi ñɨɨhɨ tan nduvaha̱ ñi lundu, tan nacacá ñi coxo, tan nanyehé ñi cuaa. Tan quitsaha̱ jacahnu xaan ñi tsi Nyoo ñi, tsa cuví ñi nyɨvɨ Israel. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tacan tan cana̱ ra Jesús tsi ra tsicá tsihin ra, tan catyí ra tsihin ra naha: ―Ndaahvi xaan cuñí yu nyehé yu tsi nyɨvɨ ihya, tyin tsa uñi quɨvɨ yucú ñi ihya tsihin yo, tan nduve náa catsi ñi. Tan ña cuñí yu jacunuhu yu tsi ñi yuvehe ñi tyin ñaha ca catsi ñi, tan coto cúu naaha ñi ityi cuanuhú ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tacan tan ra tsicá tsihin ra catyí ra naha tsihin ra: ―¿Tan numaa cua ñihi yo tsa catsi nyɨvɨ cuaha ihya, tyin ihya nduve nyɨvɨ iyó? ");
INSERT INTO mjcNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tacan tan ra Jesús tsica̱ tuhun ra tsi ra naha tan catyí ra: ―¿Najava taahan paan ndahá ndo? Tan catyí ra naha: ―Utsa taahan ñi, tan uvi taahan ñi tyaca nyihi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tan catyí ra tsihin nyɨvɨ na cunyecu ñi nu ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tacan tan quihi̱n ra tsa utsa paan can tan tyaca can, tan nacuhva̱ ra tyahvi nyoo tsi Nyoo. Tan quitsaha̱ tsahnú cuatyi ra paan tsihin tyaca, tan tsaha̱ ra tsi ra tsicá tsihin ra tyin na tsatsa ra naha tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tandɨhɨ ñi tsatsi̱ ñi, tan ndaha̱ vaha iñi ñi. Tan tsa ndɨhɨ̱ tsatsi̱ ñi tan naquihi̱n ra naha tsa ñahñu tsa ndoo̱ can tan quita̱ utsa tyica cuvi̱ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tan ra tsa tsatsi̱ can naha ra quita̱ maa cumi mil ra naha tan sɨɨn maa ñiñaha tan tsa nyihi. ");
INSERT INTO mjcNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yaha̱ can tan jacunuhu̱ ra tsi ñi, tan quɨhvɨ̱ ra tsitsi yutun ndoo, tan cuahán ra ityi Magdala. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tacan tan ra fariseo naha ra tan ra saduceo naha ra tsaha̱n ra naha nu nyií ra Jesús, tyin cuñí ra naha nducu cuhva ra naha tsi ra. Tan catyí ra naha na javaha ra iin tsa iyo tsihin tunyee iñi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Maa tyin nacaha̱n ra Jesús tan catyí ra tsihin ra naha: ―Tsa cueñi, tuhvá ndo catyí: “Sɨɨ xaan caa ityaan cua cuvi tyin cuaaha xaan nu vico”. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tan tsa tuvi catyí tucu ndo tyin ña sɨɨ maa caa cua cuvi, tyin iñi naaha xaan tan cuaaha xaan vico, catyí ndo. ¿Nacuenda tyin tsitó tucu ndo yacan tan tsa cuví vityin ña cuví nacoto ndo, nyooho ra jandaví ñaha? ");
INSERT INTO mjcNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nyɨvɨ tsa iyó vityin, quiñi xaan iyó ñi tan ña tsinú iñi ñi tsi Nyoo. Maa ñi tsa iyo cuñí ñi nyehe ñi. Maa tyin yuhu ña cua javaha yu tsa iyo nyehe ñi, tyin tumaa tsa cuvi̱ tsi ra Jonás, yacan ña cua nyehe ñi ―catyí ra Jesús tsihin ra naha; tsahan cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cuhva tsa yaha̱ ra tsicá tsihin ra Jesús inga tsiyo miñi can, nducuhu̱n iñi ra naha tyin nduve paan tsa catsi ra naha ndahá ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tacan tan catyí ra Jesús tsihin ra naha: ―Ja̱ha ndo cuenda tsi ndo tsihin yutsan iya ra fariseo tan ra saduceo naha ra ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tacan tan quitsaha̱ natuhún tahan ra naha tan catyí ra naha: ―¿A ñavin tyin nduve paan ndahá yo catsi yo, yacan cuenda caahán ra tyehen tsihin yo? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tan tsa tuvi̱ iñi ra Jesús tsa tsicá iñi ra naha, catyí ra tsihin ra naha: ―Nyooho tsa luxu ñi tsinú iñi tsi yu, ¿nacuenda tyin tsicá xaan iñi ndo tyin nduve tsa catsi ndo ndahá ndo? ");
INSERT INTO mjcNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿A ñaha ca cutuñi iñi ndo? ¿A ña nducuhún iñi ndo quɨvɨ tsa jacatsi̱ yu tsi uhun mil rayɨɨ tsihin uhun taahan ñi paan, tan najava taahan tyica jacutu̱ ndo tsihin tsa ñahñu tsa ndoo̱ can? ");
INSERT INTO mjcNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿A tsa naá ndɨhɨ tucu iñi ndo quɨvɨ tsa jacatsi̱ yu cumi mil rayɨɨ, tan najava taahan tyica jacutu̱ ndo tsihin tsa ndoo̱ tsa utsa taahan ñi paan? ");
INSERT INTO mjcNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nacuenda ña tuví iñi ndo tyin ñavin tuhun paan caahán yu tsa catyi̱ yu tyin na jaha ndo cuenda tsi ndo tsihin yutsan iya ra fariseo tan ra saduceo naha ra? ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tacan tan cutuñi̱ iñi ra naha tyin ñavin tsa cuenda yutsan iya paan can caahán ra, maa tyin na jaha ra naha cuenda tsi ra naha tsihin tsa jacuahá ra fariseo tan ra saduceo naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cuhva tsa tsaa̱ ra Jesús ityi ñuu Cesarea Filipo, tsica̱ tuhun ra tsi ra tsicá tsihin ra tan catyí ra: ―¿Náa catyí nyɨvɨ? ¿Yóo ra cuví yu, Rayɨɨ tsa quee̱ nda gloria? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tan nacaha̱n ra naha tan catyí ra naha: ―Yɨhɨ́ nyɨvɨ catyí ñi tyin ra Juan ra jacoondutya̱ tsi nyɨvɨ cuví un. Tan inga nyɨvɨ catyí ñi tyin ra Elías cuví un, tan yɨhɨ́ tucu ñi catyí ñi tyin ra Jeremías, o inga ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha cuví un. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tacan tan catyí ra tsihin ra naha: ―Tan nyooho, ¿yóo ra cuví yu, catyí ndo? ");
INSERT INTO mjcNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tacan tan nacaha̱n ra Simón Pedro tan catyí ra: ―Yooho cuví ra Cristo, Sehe Nyoo nyitó ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tan nacaha̱n ra Jesús tan catyí ra: ―Sɨɨ xaan cuví tsi yooho, Simón, sehe ra Jonás, tyin ñavin nyɨvɨ janaha̱ tuhun ihya tsi un, tyin maa Jutu yu, ra nyaá gloria janaha̱ tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tan yuhu catyí yu tsihin un tyin yooho cuví ra Pedro. Tan sɨquɨ cava ihya, cua javaha yu vehe ñuhu yu. Tan ña cua tanɨ tsi jaha tuhun tsiihí. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yuhu cua cuhva yu ndaha tucu tsa cuenda nu ndacá ñaha Nyoo tsi un. Tan tandɨhɨ tsa cuhñi un ihya nu ñuhu ñayɨvɨ, tsa nuuhñí jaha̱ Nyoo nda gloria. Tan tandɨhɨ tsa ndatsi un ihya nu ñuhu ñayɨvɨ, tsa ndatsi̱ maa Nyoo nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tacan tan catyi̱ ra Jesús tsihin ra tsicá tsihin ra tyin ña cahan ra naha tsihin nyɨvɨ tun juvin ra cuví ra Cristo ra tsa quee̱ nu nyaá Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nda quɨvɨ can quitsaha̱ catyí ra Jesús tsihin ra tsicá tsihin ra, tyin cuñí tsi tsa cuhun ra ñuu Jerusalén. Tan ra cuví mandoñi naha ra, tan ra jutu tsa cuví ityi nuu naha ra, tan ra maestro cuenda ley vehe ñuhu naha ra, tan cua janyehe xaan ra naha tundoho tsi ra. Tan catyí ra tyin cua cahñi ra naha tsi ra, maa tyin tsa tsinu uñi quɨvɨ cua nandoto ra inga tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tacan tan quihi̱n ra Pedro tsi ra tan quita̱ sɨɨn ra tsihin ra tan quitsaha̱ caahán ra tsihin ra Jesús tyin ña vaha tsa caahán ra tan catyí ra: ―Na ña cuhva Nyoo tsa tahan un tacan, Jutu Mañi yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tan nanyico̱ coo ra Jesús, tan quitsaha̱ caahán ra tsihin ra Pedro: ―¡Ja̱tsiyo nyaha tsi un, cuihna! Tyin cuñí un casɨ un tsi yu. Tyin yooho ña tsicá iñi un cuhva cuñí Nyoo, tyin cuhva cuñí nyɨvɨ tsicá iñi un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tacan tan ra Jesús catyi̱ ra tsihin ra tsicá tsihin ra: ―Tatun ndáa nyooho cuñí cunyicun tsi yu, ca̱hnya iñi ndo tsa cuñí maa ndo javaha ndo, tacan tan cuvi javaha ndo tsa cuñí Nyoo. Tan ña cua ndu uvi iñi ndo tsa yɨhɨ́ ndo cuenda yu, vasu tandɨhɨ quɨvɨ nyehé ndo tundoho. Tyin yacan cuví cruu tsa taahán tsi cuiso ndo tatun cua cunyicun ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tan nyooho tsa ña cuñí nyehe tundoho, tan ña cuñí ndo cuhva ndo ñayɨvɨ iyó ndo tsa cuenda yu, cua nyehe ndo tundoho anyaya. Maa tyin nyooho tsa cua cuhva ñayɨvɨ ndo tsa cuenda yu, cua cacu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tyin nduve yahvi nyaá tsa cua ñihi ndo tandɨhɨ tsa iyó nu ñuhu ñayɨvɨ tun añima ndo tan ña cua cacu tsi. Tyin nduve maa náa tsihin tan cuvi tyahvi ndo tan ña cua cunaa añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tyin yuhu, Rayɨɨ tsa quee̱ nda gloria, cua quitsi nyico yu inga tsaha, maa tyin tsihin tsa cahnu cuví Jutu yu, tan cua quitsi ángel tsihin yu. Tacan tan cua tyahvi yu tsi intuhun intuhun ndo tsa cuenda tsa javaha̱ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tan tsa nditsa catyí yu tsihin ndo, tyin yɨhɨ́ nyooho tsa yucú ihya vityin, cua nyehe ndo nu vatsí yu tsa cua cundaca ñaha yu, tsa ndi cumañi ca cúu ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tan tsa yaha̱ iñu quɨvɨ, tan quihi̱n ra Jesús tsi ra Pedro tan ra Jacobo, tan ra Juan yañi ra Jacobo. Tan cuahán ra iin yucu sucun xaan tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tan ican nasama̱ cuhva caá ra Jesús nuu ra yucú tsihin ra. Tan xiñu xaan nuu ra cuvi̱ tumaa xiñu ñicanyii. Tan jahma ra cuitsin xaan tsi cuvi̱ tumaa cuitsin ñuhu̱. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tacan tan nyehe̱ ra naha tsi ra Moisés tan ra Elías, natuhún ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tan quitsaha̱ caahán ra Pedro tsihin ra Jesús, tan catyí ra: ―Jutu Mañi yu, vaha xaan tyin yucú ndi ihya. Tatun cuñí un, javaha ndi uñi taahan tyahva, iin tsi tsi maa un, tan inga tsi tsi ra Moisés, tan iin tsi tsi ra Elías ―catyí ra Pedro tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tsitsi tsa caahán ra Pedro, quitsi̱ iin vico tsa xiñu xaan sɨquɨ ra naha. Tan tyasɨ̱ tsi tsi ra naha. Tan tsiñi̱ ra naha iin ndusu tsa caahán tsitsi vico can tan catyí tsi tyehen: ―Ra ihya cuví Sehe yu, tan cuñí xaan yu tsi ra. Tan sɨɨ xaan cuñí yu tsihin ra. Tya̱a yahvi ndo tsa caahán ra ―catyí ndusu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tsa tsiñi̱ ra tsicá tsihin ra Jesús tuhun ihya, tsicava̱ tsihin nuu ra naha nda nu ñuhu, tyin nayuhvi̱ xaan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tacan tan natuhva̱ ra Jesús nu cayucú ra naha, tan tɨɨ̱n ra tsi ra naha, tan catyí ra: ―Ndu̱vita ndo, tan ña na̱yuhvi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tan cuhva tsa nanyehe̱ ra naha, intuhun ña ra Jesús nyaá, tan nduve inga uvi ca ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tan cuhva tsa vatsí nuu ra naha yucu can, catyí ra Jesús tsihin ra naha: ―Ña ca̱han ndo tsa nyehe̱ ndo ihya tsihin nyɨvɨ. Tsa yaha tsa cúu Rayɨɨ tsa quee̱ nda gloria tan nandoto ra, tacan tan cua cahan ndo can ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tacan tan tsica̱ tuhun ra tsicá tsihin ra tsi ra, tan catyí ra naha: ―¿Nacuenda tyin ra maestro cuenda ley vehe ñuhu naha ra caahán ra naha tyin jihna ca ra Elías taahán tsi quitsi? ");
INSERT INTO mjcNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tan nacaha̱n ra Jesús tan catyí ra: ―Tsa nditsa tyin jihna ca ra Elías cua quitsi tan cua janduvaha ra tandɨhɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Maa tyin yuhu catyí yu tsihin ndo tyin tsa yaha̱ quitsi̱ ra Elías, tan ña nacoto̱ nyɨvɨ tsi ra, tan javaha̱ ñi tsihin ra tandɨhɨ cuhva cuñi̱ maa ñi. Tan tacan tucu yuhu, Rayɨɨ tsa quee̱ nda gloria, cua janyehe ñi tundoho tsi yu ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tacan tan cutuñi̱ iñi ra naha tyin tuhun ra Juan, ra jacoondutya, caahán ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cuhva tsa tsaa̱ ra naha nu yucú nyɨvɨ, natuhva̱ iin ra tan tsicuɨñɨ̱ tsɨtɨ ra nuu ra Jesús, tan catyí ra tsihin ra: ");
INSERT INTO mjcNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Tata, cu̱ndaahvi iñi tsi sehe yu, tyin yɨhɨ́ cuehe tsiihí naaha tsi ra, tan tuhvá ra nduva ndasava, tan cuaha xaan tundoho nyehé ra jahá cuehe can. Tan yɨhɨ́ tsaha nduvá ra nu ñuhu̱ tan cayú ra, tan nduvá tucu ra nu yɨhɨ́ ndutya. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tan tsindaca̱ yu tsi ra tsi ra tsicá tsihin un, maa tyin ña cuvi̱ janduvaha̱ ra naha tsi ra ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tan nacaha̱n ra Jesús tan catyí ra: ―¡Nyooho, nyɨvɨ tsa ña tsinú iñi cuví ndo! ¡Tan caquiñi ndo! ¿Ndáa nda quɨvɨ cua cunyii yu tsihin ndo? ¿Tan ndáa nda quɨvɨ cua cunyee iñi yu tsihin ndo, tyin nyooho ña tsinú vaha maa iñi ndo tsi yu? Ti̱ndaca ndo tsi ra luhlu tsi yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tacan tan tava̱ ra Jesús tsi nu tatyi ña vaha can, tan quita̱ nu tsi ra luhlu can. Tan juvin ñi cuhva can nduvaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tsa yaha̱ can tan tsica̱ tuhun sɨɨn ra tsicá tsihin ra Jesús tsi ra tan catyí ra naha: ―¿Nacuenda tyin nyuhu ña cuvi̱ tava ndi tatyi ña vaha can? ");
INSERT INTO mjcNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tan ra Jesús nacaha̱n ra tan catyí ra: ―Tyin luxu cuii ñi tsinú iñi ndo tsi yu. Tsa nditsa catyí yu tsihin ndo tyin tun tsinú iñi ndo tsi yu, tumaa iin tsɨtɨ mostaza, cuví catyi ndo tsihin yucu ihya na catsiyo tsi tan cuhun tsi inga ityi, tan yucu ihya cuhun tsi inga ityi. Tan nduve tsa ña cua cuvi javaha ndo tatun nditsa tsa tsinú iñi ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Maa tyin tahan tatyi ña vaha can, quita nu maa ñi tsihin tsa coonyitya yo tan ndacan tahvi yo tsi Nyoo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yucú ra naha Galilea can, tan ra Jesús catyí ra tsihin ra naha: ―Yuhu, Rayɨɨ tsa quee̱ nda gloria, iin ra cua nacuhva cuenda ra tsi yu tsi ra xaan iñi tsi yu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tan cua cahñi ra naha tsi yu. Maa tyin tsa tsinu uñi quɨvɨ tan cua nandoto yu ―catyí ra. Tsa tsiñi̱ ra naha tuhun ihya, cuiihya xaan cuñí ra naha cuvi̱. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cuhva tsa tsaa̱ ra Jesús tan ra tsicá tsihin ra ñuu Capernaum, ra tavá xuhun cuenda vehe ñuhu naha ra, tsaha̱n ra naha tsinyehe̱ ra naha nu nyií ra Pedro tan tsica̱ tuhun ra naha tsi ra tan catyí ra naha: ―¿A ña tuhvá ra jacuahá tsi ndo tyahví xuhun tsa cuenda vehe ñuhu cahnu? ―catyí ra naha tsihin ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tan nacaha̱n ra Pedro tan catyí ra: ―Tuhvá ra. Tan tsa quɨhvɨ̱ ra Pedro tsitsi vehe nu iyó ra naha, jihna ca ra Jesús nacaha̱n tan catyí ra: ―¿Nacaa cuñí yooho, Simón? ¿Yóo tsi quihín ra cuví rey tsa iyó nu ñuhu ñayɨvɨ ihya yahvi? ¿A tsi nyɨvɨ ñuu maa ra o tsi inga nyɨvɨ? ");
INSERT INTO mjcNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nacaha̱n ra Pedro tan catyí ra: ―Tsi inga nyɨvɨ. Tan catyí ra Jesús tsihin ra: ―Tun tacan, nyɨvɨ ñuu maa ra ña taahán tsi tyahvi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Maa tyin ña cuñí yo tsa cahan ra naha sɨquɨ yo, yacan cuenda vaha ca tsa cuhun un yuhu miñi can, tan jacuhun un yɨquɨ tucu un tsitsi ndutya. Tan tyaca tsa cua ñihi un tsa jihna ñi, tsitsi yuhu tɨ cua ñihi un xuhun. Tan tsihin yacan ñi cua tyahvi un tsa cuenda yo ―catyí ra Jesús tsihin ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Quɨvɨ can natuhva̱ ra tsicá tsihin ra Jesús nu nyaá ra, tan tsica̱ tuhun ra naha tsi ra tan catyí ra naha: ―¿Yóo ra cahnu ca cuví nu ndacá ñaha Nyoo? ");
INSERT INTO mjcNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tacan tan ra Jesús cana̱ ra tsi iin ra luhlu, tan tyaa̱ ra tsi ra mahñu ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tan catyí ra: ―Tsa nditsa catyí yu tsihin ndo, tyin tatun nyooho tan ña cua nasama ndo cuhva iyó ndo tan ña janduluhlu ndo tsi ndo tumaa ra nyihi, ña cua cuvi quɨhvɨ ndo nu ndacá ñaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tyin ra tsa cahnu ca cuví nuu Nyoo, juvin ra cuví ra tsa janduluhlú tsi, tumaa ra luhlu ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nyɨvɨ tsa naquihín tsi iin nyɨvɨ tumaa ra luhlu ihya, tyin tsinú iñi ñi tsi yu, yuhu naquihín cuenda ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Tatun yóo nyɨvɨ natyuhú tsi iin nyɨvɨ tsa ñaha ca tsinú vaha iñi tsi yu, na javaha ñi tsa caquiñi, vaha ca na cunuhñi iin yuu yoso vee jucun ñi natyuhu̱ can, tan cujanehñi nyɨvɨ tsi ñi nu cunu ndutya ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ndahvi nyɨvɨ ñuu ñayɨvɨ, tyin tacan iyó tsa jatɨvɨ́ tsi ñi! ¡Tan ndahvi tucu ra ndaahvi tsa jatɨvɨ́ tsi ñi! ");
INSERT INTO mjcNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Yacan cuenda tatun ndaha un o tsaha un javahá tsa ña vaha, ca̱hnya can tan ja̱vita un. Tyin vaha ca quɨhvɨ un nu coo un tsihin Nyoo tsihin tsa lundu ndaha un o lundu tsaha un, tan ñavin ca tsa nanɨɨ un tan jacuhun Nyoo tsi un nu cayú ñuhu̱ tsa ña cua ndahva maa. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tun javahá un tsa ña vaha jahá tinuu un, ta̱va can tan ja̱vita un. Tyin vaha ca quɨhvɨ un nu coo un tsihin Nyoo tsihin intuhun tinuu un, tan ñavin ca tsa jacuhun Nyoo tsi un tsihin nduvi tinuu un nu cayú ñuhu̱ tsitsi anyaya. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ña caca iñi ndo tyin ra nyihi cuenda yu ihya nduve yahvi nyaá ra naha nuu Nyoo, tyin yuhu catyí yu tsihin ndo tyin cahnu ca cuví ra naha tyin ángel jahá cuenda tsi ra naha nduvi tan niñu, nyecú ra naha nuu Jutu yu, ra nyaá gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tyin yuhu, Rayɨɨ tsa quee̱ nda gloria, vatsí jacacu yu tsi nyɨvɨ tsa cuanaa. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Nacaa cuñí nyooho? Tatun iin ra tan iyó iin cientu mbee jana ra, tan cunaa intuhun tɨ, ¿a ña nacoo ra tsa cumi xico tsahun cumi tɨ nu yucú tɨ, tan cuhun ra cunanducu ra tsi quɨtɨ tsa cuanaa can? ");
INSERT INTO mjcNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tan tatun nañihi ra tsi tɨ, tsa nditsa tyin sɨɨ ca cua cuñi ra tsihin quɨtɨ can, tan ñavin ca tsihin tsa cumi xico tsahun cumi quɨtɨ tsa ña tsinaa̱. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tan tacan tucu, Jutu yo ra nyaá gloria, ña cuñí ra tsa cunaa ndi intuhun nyɨvɨ tsa cuví tumaa ra nyihi ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tatun ra yañi un tan javaha̱ ra tsa ña vaha tsi un, ca̱han tsihin intuhun ñi maa ra tan ca̱tyi un tsihin ra tyin ña vaha cuhva javaha̱ ra. Tan tatun tyaa yahvi ra tuhun caahán un, tsa jaha̱ canaa un tsi ra inga tsaha cuenda Nyoo cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Maa tyin tatun ña tyaa yahvi ra tsi un, tacan tan ca̱na un tsi iin o uvi ra tyin cuvi ra naha tsa ndaa tsa cuenda tsa cua cahan un tsihin ra can. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tatun ña tyaa yahvi ra ndi maa tsi ra tsa tsaha̱n tsihin un naha ra, tacan tan ca̱han tsihin tandɨhɨ nyɨvɨ yucú vehe ñuhu. Tan tatun ña tyaa yahvi ra tsi ñi vehe ñuhu, tacan tan ja̱ha ndo tumaa tsa ñavin ra yɨhɨ́ tuhun Nyoo cuví ra tan cuví ra tumaa ra caquiñi tsa tavá xuhun cuenda ra ndacá ñaha nda ñuu Roma. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Tsa nditsa catyí yu tsihin ndo, tyin tandɨhɨ tsa cuhñi ndo ihya nu ñuhu ñayɨvɨ, tsa nuuhñi tsi jaha̱ maa Nyoo nda gloria. Tan tandɨhɨ tsa ndatsi ndo ihya nu ñuhu ñayɨvɨ, tsa ndatsi maa Nyoo nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Tan juvin ñi catyí tucu yu tsihin ndo, tatun uvi ndo ihya nu ñuhu ñayɨvɨ, tan tsa natuhu̱n tahan ndo tan tsicán ndo tsi Jutu yu, ra nyaá gloria, cua cuhva ra yacan tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tyin nu yucú uvi o uñi nyɨvɨ tan jacahnú ñi tsi yu, ican nyaá yu mahñu ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tacan tan tsaha̱n ra Pedro tsindaca̱ tuhun ra tsi ra Jesús tan catyí ra: ―Jutu Mañi yu, tatun ra yañi yu tan javahá ra tsa ña vaha tsihin yu, ¿najava taahan tsaha taahán tsi jaha yu tucahnu iñi tsi ra? ¿A utsa taahan tsaha? ");
INSERT INTO mjcNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tan nacaha̱n ra Jesús tan catyí ra: ―Catyí yu tsihin un tyin ñavin utsa taahan ñi tsaha; nda cumi cientu cumi xico utsi tsaha taahán tsi jaha un tucahnu iñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Yacan cuenda tsa ndacá ñaha Nyoo tsi nyɨvɨ cuví tsi tumaa iin rey tsa nacana̱ tsi tandɨhɨ musu ra tyin cua nyehe ra nácaa nyaá cuenda ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tan cuhva tsa quitsaha̱ natavá ra cuenda, tan tsindaca̱ ra tsi iin musu tsa cuaha millón pesu nyaá cuenda tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tan musu can nduve náa tsihin tyahvi ra tsi tsitoho ra, yacan cuenda tsitoho ra catyí: “Xi̱co ndo tsi ra iin cahnu ñi tsihin ñasɨɨhɨ ra, tan tsihin sehe ra tan tandɨhɨ tsa iyó tsi ra tan tsihin xuhun quita can cua tyahvi ra tsa nyaá cuenda ra tsi yu.” ");
INSERT INTO mjcNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tacan tan musu can tsicuɨñɨ̱ tsɨtɨ ra nuu tsitoho ra, tan caha̱n ndaahvi ra tsihin ra, tan catyí ra: “Tata, ja̱ha tumañi iñi, cu̱atu un luxu, tan tyahvi yu tandɨhɨ tsa nyaá cuenda yu tsi un nda ñihi yu xuhun”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tan cundahvi̱ iñi tsitoho ra tsi ra, tan jaha̱ ra tucahnu iñi tsi ra, tan janaa̱ ra tandɨhɨ tsa nyaá cuenda ra, tan jandoo̱ nuña ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Maa tyin cuhva tsa quita̱ musu can, nañihi̱ ra tsi iin ra vaha iñi tsi ra tsa cuví musu tumaa maa ra. Tan ra vaha iñi can nyaá cuenda ra luxu ñi tsi ra. Tan tɨɨ̱n ra tsi ra can, tan quitsaha̱ tɨɨ́n ra jucun ra, tan catyí ra tsihin ra: “Tya̱hvi tsa nyaá cuenda un tsi yu.” ");
INSERT INTO mjcNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tacan tan tsicuɨñɨ̱ tsɨtɨ ra can nuu ra, tan caha̱n ndaahvi ra tsihin ra tan catyí ra: “Cu̱atu luxu tan nda ñihi yu xuhun tan cua tyahvi yu tandɨhɨ tsa nyaá cuenda yu tsi un”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Maa tyin maa ra ña cuñi̱ ra cuatu ra, tan tsaha̱n ra tsityihi̱ ra tsi ra can vehe caa nda cuanda tsa tyahvi̱ ra tsa nyaá cuenda ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tsa nyehe̱ inga ca musu tsa javaha̱ ra, cuiihya xaan cuñí ra naha, tan tsaha̱n ra naha tsinacatyi̱ tuhun ra naha tsihin tsitoho ra naha tsa ña vaha tsa javaha̱ ra can. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tacan tan tsitoho ra can tava̱ tyiñu ra na quitsi ra can. Tan tsa tsaa̱ ra, tan catyí ra tsihin ra: “Musu ña vaha cuví un. Yuhu jaha̱ yu tucahnu iñi tandɨhɨ tsa nyaá cuenda un tsi yu, tyin caha̱n ndaahvi un tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tacan cuñi̱ tsi tsa cundaahvi iñi un tsi ra vaha iñi tsi un tumaa tsa cundaahvi̱ iñi maa yu nyehe̱ yu tsi un”, catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tan cuxaa̱n xaan tsitoho ra, tan tava̱ tyiñu ra na tatsi tuñi ra naha tsi ra nda cuanda tsa tyahvi ra tandɨhɨ tsa nyaá cuenda ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tan nu ndɨhɨ caha̱n ra Jesús, tan catyí ra tyehen: ―Tacan cua javaha tucu Jutu yu, ra nyaá gloria, tsihin nyooho tatun ña jaha ndo tucahnu iñi tsi nyɨvɨ ndo tsihin tsa nɨɨ iñi añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tsa yaha̱ tsa caha̱n ra Jesús tuhun ihya, tan quita̱ ra cuenda Galilea can, tan cuahán ra cuenda Judea inga tsiyo yutya cahnu Jordán, ityi nu caná ñicanyii. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cuaha xaan nyɨvɨ tsinyicu̱n tsi ra, tan janduvaha̱ ra tsi nyɨvɨ cuuhví. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tacan tan juhva ra fariseo naha ra natuhva̱ ra naha nu nyaá ra Jesús, tyin cuñí ra naha nducu cuhva ra naha tsi ra tyin tacan tan cuvi tyaa ra naha cuatyi sɨquɨ ra. Tan tsica̱ tuhun ra naha tsi ra tan catyí ra naha: ―¿A vaha tsa nacoo rayɨɨ tsi ñasɨɨhɨ ra tsa cuenda náa ñi tɨsɨhɨ tsaha̱ ña tsi ra? ");
INSERT INTO mjcNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tan nacaha̱n ra tan catyí ra: ―¿A ña tuhvá ndo cahví nu tutu Nyoo nu catyí tsi tyin ra tsa javaha̱ tsi ndo nda quɨvɨ jihna ñi, javaha̱ ra rayɨɨ tan ñaha? ");
INSERT INTO mjcNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tan catyí tsi tyehen: “Taahán tsi nacoo rayɨɨ tsi jutu ra tan sɨhɨ ra, tan ndu iin ra tsihin ñasɨɨhɨ ra. Tan tsa nduvi taahan ñi cua cuvi ñi tumaa tsa intuhun ña nyɨvɨ.” ");
INSERT INTO mjcNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yacan cuenda, ñavin ca uvi taahan ñi, maa tyin nduvi ñi intuhun ña nyɨvɨ cuví ñi. Yacan cuenda, ña taahán tsi tsa nacoo tahan ñi tsi ñi tyin maa Nyoo tsa jandu ii̱n tsi ñi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tacan tan tsica̱ tuhun ra naha tsi ra Jesús tan catyí ra naha: ―¿Nacuenda tsa tyaa̱ ra Moisés tyin cuví canɨ iin rayɨɨ tutu cuenda ley ra tan nacoo ra ñasɨɨhɨ ra? ");
INSERT INTO mjcNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tan ra Jesús catyí ra tsihin ra naha: ―Tsa cuenda tsa ndava añima ndo, yacan cuenda, tsaha̱ ra Moisés ndatu tsa nacoo ndo ñasɨɨhɨ ndo. Maa tyin quɨvɨ jihna ñi ñavin tacan tsicoo̱ nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yuhu catyí yu tsihin ndo tyehen: Ra tsa nacoo̱ ñasɨɨhɨ, tan ñavin tsa cuenda tsa quituvi̱ ña tsihin inga rayɨɨ, tan tindaha̱ ra tsihin inga ñaha, tsicoó cuatyi ra nuu Nyoo. Tan ra tsa tindaha̱ tsihin ñaha tsa nacoo̱ rayɨɨ can, juvin ñi tsicoó tucu cuatyi ra can ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tacan tan ra tsicá tsihin ra, catyí ra naha tsihin ra: ―Tatun tacan taahán tsi coo rayɨɨ tsihin ñasɨɨhɨ ra, vaha ca ña tindaha yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tan ra Jesús catyí ra tsihin ra naha: ―Ña tandɨhɨ nyɨvɨ cuví naquihin cuenda tuhun ihya. Maa tyin nyɨvɨ tsa tsaha̱ Nyoo cuví naquihin cuenda ñi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tsa ña tindaha nyɨvɨ, cuaha ñi cuenda cuví tsi. Yɨhɨ́ ñi ña cuñí ñi tindaha ñi tyin iin cuhva caa maa ñi nda cacu̱ ñi. Tan inga ñi ña cuñí ñi tindaha ñi tyin tsa nducapu̱n ñi jaha̱ nyɨvɨ. Tan yɨhɨ́ ñi ña tindaha̱ ñi tsa cuenda tsa cuñí ñi javaha ñi maa ñi maa tyiñu Nyoo, na nducuaha ca añima tsa ndacá ñaha Nyoo. Tandɨhɨ nyɨvɨ tsa cuví javaha yacan na javaha ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tacan tan quitsi̱ ndaca nyɨvɨ juhva tsa nyihi tsi ra Jesús tyin na tyiso ndaha ra jiñi tsi naha tsi, tan ndacan tahvi ra tsa cuenda tsi. Maa tyin ra tsicá tsihin ra quitsaha̱ caahán ra naha tsi nyɨvɨ tsa cuahán tsihin tsa nyihi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Maa tyin ra Jesús catyí ra: ―Ja̱ña ndo tsi tsa nyihi na quitsi maa tsi naha tsi nu nyaá yu. Tan ña casɨ ndo. Tyin nyɨvɨ ndacá ñaha Nyoo cuví ñi tumaa tsa nyihi ihya ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tacan tan tyiso̱ ndaha ra jiñi tsi naha tsi. Yaha̱ can tan cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Iin ra tyuvaa tsaha̱n ra tsindaca̱ tuhun ra tsi ra Jesús tan catyí ra: ―Maestro, vaha xaan un. ¿Náa taahán tsi javaha yu tan cuvi coo yu ñayɨvɨ nyito tsa ña cua naa maa? ");
INSERT INTO mjcNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tan ra Jesús catyí ra tsihin ra: ―¿Nacuenda catyí un tyin ra vaha cuví yu? Intuhun ñi maa Nyoo cuví ra vaha. Tan tsa catyí un tyin vaha yu, nacotó un tyin Nyoo cuví yu. Maa tyin tatun cuñí un coo un ñayɨvɨ tsa ña cua naa maa, ja̱vaha tandɨhɨ tuhun tsa tsaha̱ Nyoo tyin javaha yo ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tan ra tyuvaa can catyí ra: ―¿Ndáa tsa cuví can? Tan ra Jesús catyí ra tsihin ra: ―Ña ca̱hñi un nyɨvɨ. Ña co̱o inga ñaha tsi un. Ña su̱hu un tsa tsii nyɨvɨ. Ña ca̱han un cuendu sɨquɨ nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tya̱a yahvi tsi jutu un tan tsi sɨhɨ un. Tan cu̱ñi tsi nyɨvɨ, tumaa tsa cuñí un tsi maa un. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tan ra tyuvaa can, catyí ra tsihin ra: ―Tandɨhɨ maa yacan tan tyaá yahvi yu nda tahan luhlu yu tan nda cuanda vityin. ¿Náa ca cumañí tsi yu? ");
INSERT INTO mjcNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tan ra Jesús catyí ra tsihin ra: ―Tatun cuñí un tsa iin ndaha ñi cuvi un iin ra cuɨtɨ nuu Nyoo, cu̱aahan tan xi̱co un tsa iyó tsi un, tan cu̱hva un tsi nyɨvɨ ndaahvi, tan qu̱itsi nyicun un tsi yu. Tacan tan coo tsa cuca tsi un nda gloria ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Maa tyin cuhva tsa tsiñi̱ ra tyuvaa can tsa caha̱n ra Jesús tsihin ra, cuiihya xaan cuñí ra cuvi̱ tan cuanuhu̱ ra tyin cuca xaan ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tacan tan ra Jesús catyí ra tsihin ra tsicá tsihin ra: ―Tsa nditsa catyí yu tsihin ndo tyin yɨɨ xaan tan cuví nacuhva cuenda nyɨvɨ cuca tsi ñi na cundaca ñaha Nyoo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Catyí yu tsihin ndo inga tsaha, tyin vasu yɨɨ xaan yaha iin camellu xuu iin yɨquɨ tucu, maa tyin yɨɨ xaan ca tsa quɨhvɨ iin nyɨvɨ cuca nu ndacá ñaha Nyoo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tsa tsiñi̱ ra tsicá tsihin ra Jesús tsa caha̱n ra, iyo xaan cuñí ra naha, tan quitsaha̱ tsicá tuhun tahan ra naha, tan catyí ra naha: ―Tun tacan, yoñi cua cuvi cacu ");
INSERT INTO mjcNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tacan tan nanyehe̱ ra Jesús nu nyecú ra naha tan catyí ra: ―Nyɨvɨ ña cuví javaha ñi yacan, maa tyin Nyoo cuví javaha ra tandɨhɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tacan tan quitsaha̱ caahán ra Pedro tsihin ra: ―Jutu Mañi yu, nyuhu tandɨhɨ maa tsa iyó tsi ndi nacoo̱ ndi tan nyicún ndi tsi un. ¿Náa cua ñihi ndi? ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tan nacaha̱n ra Jesús tan catyí ra: ―Tsa nditsa catyí yu tsihin ndo, tyin quɨvɨ tsa cua ndutsaa tandɨhɨ tsa iyó, yacan cuví quɨvɨ cua cunyaa yuhu Rayɨɨ tsa quee̱ nda gloria nu tyayu sɨɨ xaan caá tan cua cundaca ñaha yu. Tan nyooho tsa nyicún tsi yu, cua cunyecu ndɨhɨ ndo nu utsi uvi taahan tyayu sɨɨ caá. Tan cua cundaca ñaha ndo tsi tandɨhɨ nyɨvɨ cuví tata tsa utsi uvi taahan sehe ra Israel. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tan tandɨhɨ nyooho tan tandɨhɨ inga nyɨvɨ tsa nacoo̱ vehe, o yañi ñi, o cuhva ñi, o jutu ñi, o sɨhɨ ñi, o ñasɨɨhɨ ñi, o sehe ñi, o ñuhu ñi, tsa cuenda yuhu, cua ñihi ñi iin cientu ca tsaha sɨquɨ can, tan cua ñihi tucu ñi ñayɨvɨ nyito tsa ña cua naa maa coo ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Cuaha xaan nyɨvɨ cuahán ityi nuu vityin, ñi ican cua cuhun nu ndɨhɨ ña. Tan cuaha xaan nyɨvɨ cuahán nu ndɨhɨ vityin, ñi ican cua cuhun ityi nuu. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Tsa ndacá ñaha Nyoo tsi nyɨvɨ, cuví tsi tumaa iin ra iyó cora uvas. Tan tuvi ñi quita̱ ra cuahán ra cuanducú ra musu jaha tyiñu nu tyiñu jahá ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tan ndoo̱ ra tuhun tsihin musu can tyin cua tyahvi ra yahvi tsa iin quɨvɨ. Tan jacuhu̱n ra tsi ra naha cua jaha tyiñu ra naha nu iyó tyiñu jahá ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yaha̱ can tan cuahán ra inga tsaha cuhva caa ɨɨn tsa tuvi. Tan nyehe̱ ra tsi juhva ca ra yucú taxin nuyahvi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tan catyí ra tsihin ra naha: “Cu̱aahan ndɨhɨ tucu nyooho ja̱ha tyiñu ndo nu tyiñu jahá yu, tan cua tyahvi maa yu tsi ndo nácaa taahán tsi tsi ndo.” Tacan tan cuahán ndɨhɨ tucu ra can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tan tsitoho cora can quita̱ ra inga tsaha tsa ora. Tan juvin ñi musu nducú ra. Tan caa uñi tsa tseñi, quita̱ ra inga tsaha nducú ra musu. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yaha̱ can tan quita̱ nyico ra caa uhun tsa tseñi tan nyehe̱ ra yucú taxin juhva ca ra naha nuyahvi can. Tan catyí ra tsihin ra naha: “¿A nduve tyiñu jahá ndo? tyin nduvi nduvi yucú taxin ndo nuyahvi ihya.” ");
INSERT INTO mjcNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tan nacaha̱n ra can naha ra tan catyí ra naha: “Yucú taxin maa ndi tyin nduve tyiñu jahá ndi tan yoñi tavá tyiñu tsi ndi.” Tacan tan catyí ra tsihin ra naha: “Cu̱aahan ndɨhɨ ndo ja̱ha tyiñu ndo nu tyiñu jahá yu. Tan tyahvi maa yu tsi ndo nácaa taahán tsi tsi ndo”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tan cuhva tsa cua cuaa, tsitoho tyiñu can catyí ra tsihin ra yɨhɨ́ ndaha musu can: “Na cana un tsi musu, tan tya̱hvi un tsi ra naha. Qu̱itsaha tyahvi un tsi ra tsa quɨhvɨ̱ nu ndɨhɨ naha ra, tan nu cua ndɨhɨ tan tya̱hvi un tsi ra tsa quɨhvɨ̱ tsa jihna ñi naha ra”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tacan tan tsaa̱ ra tsa quɨhvɨ̱ caa uhun tsa tseñi can naha ra. Tan intuhun intuhun ra naha quihi̱n ra naha yahvi nanɨɨ iin quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yaha̱ can, tan cuhva tsa taha̱n tsi tsi ra tsa quɨhvɨ̱ tsa jihna ñi can naha ra, cuñí maa ra naha tyin cuaha ca cua tyahvi ra tsi ra naha. Maa tyin inducu ñi yahvi iin quɨvɨ quihi̱n ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tan cuhva tsa quihi̱n ra naha, quitsaha̱ caahán ra naha tsi tsitoho tyiñu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Tan catyí ra naha: “Ra tsa tsaa̱ nu ndɨhɨ ihya naha ra, intuhun ñi hora jaha̱ tyiñu ra naha. Tan iin ñi yahvi tyahvi̱ un tsi ra naha tsihin tucu nyuhu tan nduvi nduvi jaha̱ tyiñu ndi nu ihñi”, catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Maa tyin nacaha̱n tsitoho tyiñu can, tan catyí ra tsihin iin ra can: “¡Tsaa!, nduve tsa ña vaha javaha̱ yu tsihin un. ¿A ñavin yahvi tsa iin quɨvɨ ndoo̱ yo tuhun tyin cua tyahvi yu tsi un? ");
INSERT INTO mjcNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Qu̱ihin yahvi un, tan cu̱anuhu. ¿A nduve ndatu iyó tsi yu tsa tyahvi yu tsi ra tsa quɨhvɨ̱ nu ndɨhɨ iin ñi cuhva tsa tyahvi̱ yu tsi yooho? ");
INSERT INTO mjcNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿A nduve ndatu iyó tsi yu tsa javaha yu náa cuñí maa yu tsihin xuhun yu? ¿A ndasɨ cuñí un tyin vaha iñi yu tsihin inga ra can naha ra?” catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tacan nyɨvɨ quɨhvɨ̱ nu ndɨhɨ, cuhun ñi ityi nuu. Tan nyɨvɨ cuahán ityi nuu, nda nu ndɨhɨ ña cua cuhun ñi. Tyin cuaha xaan nyɨvɨ nacaná Nyoo, maa tyin juhva ñi ñi nacatsí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cuhva tsa cuñí cuhun ra Jesús nda ñuu Jerusalén, cana̱ sɨɨn ra tsi tsa utsi uvi ra tsicá tsihin ra tan catyí ra tsihin ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Nyehe̱ ndo tyin cuahán yo Jerusalén vityin. Tan ndacan cua nacuhva cuenda nyɨvɨ tsi yuhu, Rayɨɨ tsa quee̱ nda gloria, tsi ra jutu tsa cuví ityi nuu naha ra, tan tsi ra maestro cuenda ley vehe ñuhu naha ra, tan cua catyi ra naha tyin taahán tsi cúu yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tan cua nacuhva cuenda ra naha tsi yu tsi ra ñuu Roma naha ra, tyin vacu nducu ra naha tsi yu. Tan cañi ra naha tsi yu. Tan cahñi ra naha tsi yu nu cruu. Maa tyin tsa tsinu uñi quɨvɨ cua nandoto yu ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tacan tan ñasɨɨhɨ ra Zebedeo natuhva̱ ña nu nyií ra Jesús tsihin nduvi sehe ña, ra Jacobo tan ra Juan. Tan tsicuɨñɨ̱ tsɨtɨ ña nuu ra tyin cua ndacan ña iin tumañi iñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tan tsica̱ tuhun ra Jesús tsi ña tan catyí ra: ―¿Náa cuñí un? Tan catyí ña: ―Quɨvɨ tsa cunyaa un nu ndacá ñaha un nda gloria, cu̱hva tsa cunyaa nduvi sehe yu xiin un. Na cunyaa iin ra tsiyo cuaha un, tan inga ra tsiyo satyin un. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Maa tyin nacaha̱n ra Jesús tan catyí ra: ―Nyooho ña tsitó ndo tsa tsicán ndo. ¿A cuví nyehe nyooho tundoho tsa cua nyehe yuhu? ¿A cuví cuhun ndo tuhun tsiihí tumaa cua cuhun yuhu? ―catyí ra. Tan nacaha̱n ra naha tan catyí ra naha: ―Cuví maa. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tan catyí ra Jesús tsihin ra naha: ―Tsa nditsa tyin cua nyehe ndo tundoho, tan cua cuhun ndo tuhun tsiihí tumaa cuhun yuhu tuhun tsiihí. Maa tyin tsa cunyaa ndo tsiyo cuaha yu tan tsiyo satyin yu, ñavin yuhu taahán tsi cuhva yacan tsi ndo, tyin tsa tsitó maa Jutu yu yóo cua cuhva ra can ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tan tsa tsiñi̱ tsa utsi ca ra tsicá tsihin ra Jesús yacan, cuxaa̱n ra naha tsi nduvi ra can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Maa tyin cana̱ ra Jesús tsi ra naha tan catyí ra tsihin ra naha: ―Tsa tsitó maa ndo, tyin ra ndacá ñaha tsi nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya, ñihi xaan ndacá ñaha ra naha tsi ñi. Tan ra cuví ityi nuu tsihin ra naha nduyaa xaan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Maa tyin ñavin tacan taahán tsi javaha nyooho. Tyin ra tsa cuñí nducahnu ca cuvi nu Nyoo, cuñí tsi cuví ra musu tandɨhɨ nyooho. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tan ndáa nyooho tsa cuñí ndo cuví ndo ityi nuu, cuñí tsi cuví ndo musu tandɨhɨ ca ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tumaa yuhu, Rayɨɨ tsa quee̱ nda gloria, ña vatsí yu tyin jatyinyee nyɨvɨ tsi yu. Maa tyin yuhu vatsí yu vatsí jatyinyee yu tsi maa ñi, tan cua cuhva yu ñayɨvɨ yu tsa cuenda ñi. Tyin tsihin yacan cua tyahvi yu cuatyi tandɨhɨ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cuhva tsa cua quita ra Jesús ñuu Jericó tsihin ra tsicá tsihin ra, cuaha xaan nyɨvɨ cuahán cua nyicun tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tan yuhu ityi can nyecú uvi taahan ra cuaa. Tan cuhva tsa tsiñi̱ ra naha tyin cua yaha ra Jesús, quitsaha̱ caná tsaa ra naha. Tan catyí ra naha: ―¡Jutu Mañi yu, tata ra David, cu̱ndaahvi iñi tsi ndi! ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tan nyɨvɨ quitsaha̱ caahán ñi tsihin ra naha na casɨ ra naha yuhu ra naha. Maa tyin ñihi ca cana̱ tsaa ra naha: ―¡Jutu Mañi yu, tata ra David, cu̱ndaahvi iñi tsi ndi! ");
INSERT INTO mjcNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tacan tan tsicuɨñɨ̱ ra Jesús tan cana̱ ra tsi nduvi taahan ra cuaa can, tan tsica̱ tuhun ra tsi ra naha tan catyí ra: ―¿Náa cuñí ndo javaha yu tsi ndo? ");
INSERT INTO mjcNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tan nacaha̱n ra naha tan catyí ra naha: ―Jutu Mañi yu, ja̱nanyehe tsi ndi. ");
INSERT INTO mjcNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tacan tan cundaahvi̱ iñi ra Jesús tsi ra naha, tan tɨɨ̱n ra tinuu ra naha. Tan iin yaha ñi nanyehe̱ ra naha, tan cuɨtɨ cuanyicún ndɨhɨ ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tsa cua tsaa ra naha ñuu Jerusalén, tan tsaa̱ ra naha ñuu Betfagé, yatyin ñi yucú Olivo nu iyó yutun olivo. Tacan tan tava̱ tyiñu ra Jesús tsi uvi ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tan catyí ra tsihin ra naha: ―Cu̱aahan ndo ñuu tsa canyií ityi nuu ihya. Tan ican cua ñihi ndo iin urru sɨɨhɨ, nuuhñí tɨ. Tan ndacá tɨ iin urru luhlu. Nda̱tsi ndo tsi tɨ, tan quitsi̱ ndaca ndo tsi tɨ naha tɨ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tan tatun yóo tsicá tuhun tsi ndo: “¿Náa cuú ndo tsi tɨ naha tɨ?”, tan ca̱tyi ndo tsihin ñi: “Tyin tsiñí ñuhu tɨ naha tɨ tsi maa ra ndacá ñaha, maa tyin numi ñi cua quitsi ndaca nyico ndi tsi tɨ naha tɨ”, ca̱tyi ndo tsihin ñi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tacan cuvi̱ tyin cundaa tsa caha̱n ra cuvi̱ ndusu yuhu Jutu Mañi yo taha̱n tsanaha nu catyi̱ ra tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ca̱han ndo tsihin nyɨvɨ ñuu Sión: “Nye̱he ndo, vatsí rey ndo nu iyó ndo. Ndaahvi ñi vatsí ra yosó ra iin urru luhlu, sehe iin quɨtɨ tsa tuhvá nyisó carga”, catyi̱ ra cuvi̱ ndusu yuhu Nyoo can. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tacan tan cuahán ra tsicá tsihin ra Jesús, tan javaha̱ ra naha tumaa tsa caha̱n ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Quitsi̱ ndaca ra naha tsi tɨ tsihin sɨhɨ tɨ. Tan tyiso̱ ra naha jahma ra naha tsata tɨ, tan ndaa̱ ra Jesús tsi tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tan cuaha xaan nyɨvɨ tsaqui̱n ñi jahma ñi nu ñuhu ityi nu cuahán ra, tan inga ñi tsahnya̱ ñi ndaha yutun tsaqui̱n ñi tsitsi ityi. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tan nyɨvɨ tsa cuahán ityi nuu tan ityi tsata, quitsaha̱ caná tsaa ñi tan catyí ñi: ―¡Cahnu xaan cuví ra cuví tata ra rey David! ¡Cahnu xaan cuví ra tsa jaquitsi̱ Jutu Mañi yo Nyoo! ¡Tan na jacahnu yo tsi Nyoo ra nyaá gloria! ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cuhva tsa tsaa̱ ra Jesús ñuu Jerusalén can, tandɨhɨ maa nyɨvɨ ñuu quitsaha̱ cuvaá jahá ñi, tan cuaha xaan ñi tsicá tuhun tahan ñi tsi ñi, tan catyí ñi: ―¿Yóo ra cuví ra ihya? ");
INSERT INTO mjcNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tan catyí ñi: ―Ra Jesús, ra cuví ndusu yuhu Nyoo, ra ñuu Nazaret tsa canyií Galilea cuví ra ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yaha̱ can tan quɨhvɨ̱ ra Jesús tsitsi vehe ñuhu cahnu Nyoo. Tan tava̱ ra tsi tandɨhɨ nyɨvɨ jatá tan xicó ican. Tan janduva̱ ra mesa nu nasamá ñi xuhun. Tan janduva̱ ra tyayu nu xicó ñi paloma. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tan catyí ra tsihin nyɨvɨ: ―Nu tutu Nyoo catyí tyin vehe Nyoo, nu tsicán tahvi yo tsi ra cuví tsi, tan tacan cua cunañi tsi. Tan nyooho jananduvi̱ ndo vehe ihya, vehe ñasuhu ―catyí ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tan tsa tsito̱ juhva ra cuaa tan ra coxo naha ra tyin nyií ra Jesús tsitsi vehe ñuhu cahnu, quɨhvɨ̱ ra naha tan janduvaha̱ ra Jesús tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tan nyehe̱ ra jutu tsa cuví ityi nuu naha ra tan ra maestro cuenda ley vehe ñuhu cahnu naha ra tyin javaha̱ ra Jesús tsa iyo. Tan tsiñi̱ ra naha tyin caná tsaa tsa nyihi tsitsi vehe ñuhu, tan catyí tsa nyihi can: ―¡Cahnu xaan cuví ra cuví tata ra rey David! ―catyí tsi naha tsi. Tacan tan cuxaa̱n ra naha tsa tsiñi̱ ra naha tsa caahán tsa nyihi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tan catyí ra naha tsihin ra Jesús: ―¿A tsiñí un tsa caahán tsa nyihi can? Tan nacaha̱n ra Jesús tan catyí ra: ―Tsiñí yu. Maa tyin ¿a ñaha ca cahvi nyooho nu tutu Nyoo nu catyí tsi tyehen? Jutu Mañi yu, tsa nyihi tan lee tsa ndi tyaxín sɨɨ xaan tsitá tsi naha tsi jahá un. Tan vaha xaan jacahnú tsi tsi un, catyí tsi, ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tacan tan nacoo̱ ra tsi ra naha, tan quita̱ ra ñuu can cuahán ra ñuu Betania. Tan ican ndoo̱ ra tsacuaa can. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tan tsa tuvi cuii ñi inga quɨvɨ can, vatsí nyico ra Jesús nda ñuu Jerusalén, tan tsaa̱ soco tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tan nyehe̱ ra nyaá iin yutun higo yatyin ñi yuhu ityi can. Tan natuhva̱ ra nu nyaá tun, maa tyin nduve maa náa nañihi̱ ra nuu tun. Maa ñi ndaha tun iñi. Tacan tan catyí ra tsihin tun: ―¡Ndi inga tsaha ña cua cuhva ca un tsɨtɨ! Tan juvin ñi cuhva can na ityi̱ tun. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tan tsa nyehe̱ ra tsicá tsihin ra tsa javaha̱ ra tsi tun, iyo xaan cuñí ra naha, tan tsica̱ tuhun ra naha tsi ra tan catyí ra naha: ―¿Nacuenda tsa numi xaan na ityi̱ yutun higo can? ");
INSERT INTO mjcNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tan nacaha̱n ra Jesús tan catyí ra: ―Tsa nditsa catyí yu tsihin ndo, tyin tatun tsinú iñi ndo tan ña ndu uvi iñi ndo, ñavin tsa javaha̱ yu tsihin yutun higo ihya ñi cuví javaha tucu nyooho, tyin cuví ndɨhɨ tucu catyi ndo tsihin yucu ihya: “Cu̱atsiyo ihya tan cuhun un nda tsitsi ndutya ñuhu.” Tan cua cuhun tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tan tandɨhɨ tsa cua ndacan ndo nu cua ndacan tahvi ndo tsi Nyoo, tatun tsinú iñi ndo tyin cua cuhva ra, cua ñihi ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yaha̱ can tan quɨhvɨ̱ ra Jesús tsitsi vehe ñuhu cahnu, tan tsitsi tsa jacuahá ra ican, natuhva̱ ra jutu tsa cuví ityi nuu naha ra nu nyaá ra, tan ra cuví mandoñi ñuu Israel naha ra. Tan tsica̱ tuhun ra naha tsi ra tan catyí ra naha: ―¿Yóo tava̱ tyiñu tsi un tsa javahá un tyehen? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Tan nacaha̱n ra Jesús tan catyí ra: ―Yuhu tucu cuñí yu ndaca tuhun yu tsi nyooho. ¿Yóo jaquitsi̱ tsi ra Juan tyin jacoondutya ra tsi nyɨvɨ? ¿A Nyoo jaquitsi̱ tsi ra, o nyɨvɨ? Tatun catyi tuhun ndo tsihin yu, cua catyi tuhun tucu yuhu tsihin ndo yóo tava̱ tyiñu tsi yu tsa javahá yu tyehen ―catyí ra Jesús tsihin ra naha. Tacan tan ra ican naha ra quitsaha̱ caahán yuhu tahan ra naha, tan catyí ra naha: ―Tatun catyí yo tyin Nyoo jaquitsi̱ tsi ra Juan, cua catyi ra tsihin yo: “Tun tacan, ¿nacuenda ña tsinu̱ iñi ndo tsi ra?” ");
INSERT INTO mjcNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tan tatun catyi yo tyin nyɨvɨ jaquitsi̱ tsi ra, yuuhví yo coto cuxaan nyɨvɨ tsi yo, tyin tandɨhɨ ñi tsinú iñi ñi tyin ra Juan, cuenda Nyoo caha̱n ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tacan tan catyí ra naha tsihin ra Jesús: ―Ña tsitó ndi. Tacan tan ra Jesús catyí ra tsihin ra naha: ―Tan ndi yuhu, tan ña catyi tuhun yu tsihin ndo yóo tava̱ tyiñu tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ra Jesús catyí ra tsihin ra cumi tyiñu vehe ñuhu naha ra: ―¿Nacaa catyí ndo cuenda tsa cua cahan yu ihya? Iin rayɨɨ, iyó uvi taahan sehe ra. Tan catyí ra tsihin iin sehe ra: “Cu̱aahan cua jaha tyiñu nu iyó tyiñu jahá yu.” ");
INSERT INTO mjcNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tan nacaha̱n sehe ra tan catyí ra: “¡Ña cuhun yu!” Maa tyin yaha̱ can tan nasama̱ cuhva tsicá iñi ra tan tsaha̱n ra tsijaha̱ tyiñu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yaha̱ can tan jutu ra caha̱n ra tsihin inga sehe ra. Tan catyí tucu ra tsihin ra na cuhun ra cujaha tyiñu ra. Tan ra ican numi ñi quihi̱n ra tyiñu tan catyí ra: “Vaha, tyaa, cuhun maa yu.” Maa tyin ña tsaha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tsitsi tsa nduvi taahan ra can naha ra, ¿ndáa ra javaha̱ tsa caha̱n jutu ra? ―catyí ra Jesús. Tan nacaha̱n ra naha tan catyí ra naha: ―Ra tsa caha̱n ra tsihin tsa jihna ñi. Tan catyí ra Jesús tsihin ra naha: ―Tsa nditsa catyí yu tsihin ndo, tyin nyɨvɨ caquiñi tumaa ra tsa tavá xuhun cuenda ra ndacá ñaha tan ñi sɨɨ iñi caca nuu, jihna ca ñi cua quɨhvɨ nu ndacá ñaha Nyoo tan ñavin ca nyooho. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tyin ra Juan, ra jacoondutya̱ tsi nyɨvɨ, quitsi̱ ra jacuaha̱ ra tsi ndo nácaa taahán tsi coo cuɨtɨ ndo, tan nyooho ña tsinu̱ iñi ndo tsi ra. Maa tyin ra tavá xuhun naha ra tan ñi sɨɨ iñi caca nuu tsinu̱ iñi ñi tsi ra. Tan nyooho vasu ndi maa nyehe̱ ndo yacan, maa tyin ña nasama̱ ndo cuhva iyó ndo, tan ña tsinu̱ iñi ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Tya̱a soho ndo inga cuhva ihya: Tsicoo̱ iin rayɨɨ, tan iyó ñuhu ra. Tan tatsi̱ ra yoho yucu vixi tsa nañí uvas, tan tyihi̱ ra cora. Tan javaha̱ ra iin nu cua tava ra ndutya uvas can. Tan javaha̱ tucu ra iin vehe sucun tyin cuvi jaha cuenda ra tandɨhɨ. ’Yaha̱ can tan tsaha̱ nuu ra ñuhu can tsi juhva ra cua jaha tyiñu naha ra, tan cuahán ra inga ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tan tsa tsaa̱ quɨvɨ tsa iyó uvas can, jacuhu̱n ra tsi juhva musu ra, na ndacan ra naha tsi ra jahá tyiñu can naha ra, na cuhva ra naha juhva uvas tsa taahán tsi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Maa tyin ra jahá tyiñu can tɨɨ̱n ra naha tsi musu can naha ra, tan cañi̱ ra naha tsi iin ra. Tan inga ra tsahñi̱ ra naha, tan cañi̱ ra naha yuu tsi inga ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tacan tan tsa inga tsaha, cuaha ca musu jacuhu̱n tsitoho cora can tan ñavin ca tsa jihna ñi. Maa tyin tumaa tsa javaha̱ ra naha tsihin ra tsa tsaha̱n jihna naha ra, tacan ñi javaha̱ nyico ra naha tsihin ra ihya naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Nu ndɨhɨ jacuhu̱n ra tsi maa maa sehe ra, tyin cuñí maa ra tyin cua tyaa yahvi ra naha tsi sehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Maa tyin cuhva tsa nyehe̱ ra jahá tyiñu can naha ra tsi sehe ra, natuhu̱n tahan ra naha tan catyí ra naha: “Ra ihya cua ndoo tsihin tandɨhɨ tsa iyó ihya. Na cahñi yo tsi ra tan ndoo maa yo tsihin cora ihya”, catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tacan tan tɨɨ̱n ra naha tsi ra, tan tava̱ ra naha tsi ra ityi tsata cora can, tan tsahñi̱ ra naha tsi ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tacan tan tsica̱ tuhun ra Jesús tsi ra naha tan catyí ra: ―Quɨvɨ cua quitsi ra jatsii ñuhu can, ¿náa cua javaha ra tsihin ra jahá tyiñu can naha ra? ");
INSERT INTO mjcNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tan nacaha̱n ra naha tan catyí ra naha: ―Ña cua cuatu ra, tyin cua cahñi ra tsi ra caquiñi can naha ra. Tan cua cuhva nuu ra ñuhu can tsi inga ra jaha tyiñu naha ra, tan quɨvɨ coo uvas, cua nacuhva cuenda ra naha juhva tsa taahán tsi tsi ra cuví tsitoho cora can. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tacan tan catyí ra Jesús tsihin ra naha: ―¿A ñaha ca cahvi̱ nyooho nu tutu Nyoo nu catyí tsi tyehen? Yuu tsa javita̱ ihñi ra javahá vehe, Yacan cuví yuu tsa ñiñi ca. Jutu yo Nyoo cuví ra tsa javaha̱ tandɨhɨ can. Tan iyo xaan cuñí yo nyehé yo, catyí tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Yacan cuenda catyí yu tsihin ndo tyin ña cua cuhva Nyoo cuhun ndo nu ndacá ñaha ra. Tan cua cuhva ra tsi nyɨvɨ tsa javahá cuhva cuñí ra tyin nditsa tsahá ñi tsi ñi cundaca ñaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tan tsa cuenda yuu can, yóo nyɨvɨ tsa nduva sɨquɨ tsi, cua tahnu cuatyi ñi. Tan tatun yuu can tan canacava tsi sɨquɨ yóo nyɨvɨ, cua taxin nyihi ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Cuhva tsa tuvi̱ iñi ra jutu tsa cuví ityi nuu can naha ra tan ra fariseo naha ra tyin cuenda maa ra naha caha̱n ra Jesús cuhva ihya, ");
INSERT INTO mjcNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","cuñi̱ ra naha tɨɨn ra naha tsi ra, maa tyin yuuhví ra naha tsi nyɨvɨ tyin tsinú iñi ñi tyin ra Jesús caahán ra cuenda Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Quitsaha̱ caahán ra Jesús tsihin nyɨvɨ inga tsaha tsihin cuhva, tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Tsa ndacá ñaha Nyoo tsi nyɨvɨ cuví tsi tumaa iin rey tsa javaha̱ iin vico tsa cuenda tsa cua tindaha sehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tan jacuhu̱n ra tsi musu ra na cucana ra naha tsi nyɨvɨ tsa jacoto̱ ra tyin cuhun ñi, maa tyin ñi ican, ña cuñi̱ ñi cuhun ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tan jacuhu̱n nyico ra inga ca musu ra, tan catyi̱ ra tsihin ra naha: “Ca̱han ndo tsihin ñi na quitsi ñi, tyin tsa iyó vaha tsa cua catsi yo. Tan tsa tsahñi̱ yu indɨquɨ tan inga quɨtɨ xaahan. Tan tsa iyó vaha tandɨhɨ. Yacan na quitsi ñi”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Maa tyin ñi ican ña tyaa̱ yahvi ñi tsa caha̱n ra. Iin ra tsaha̱n ra nu iyó cora ra, inga ra tsaha̱n ra nu jahá tyiñu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tan inga ra naha tɨɨ̱n ra naha tsi musu rey can naha ra tan cañi̱ xaan ra naha tsi ra naha nda cuanda tsahñi̱ ra naha tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tacan tan ra rey can cuxaa̱n xaan ra, tan jacuhu̱n ra tsi andaru ra na cucahñi ra naha tsi ra tsa tsahñi̱ tsi musu can naha ra, tan cahmi ra naha ñuu ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tacan tan catyí ra rey can tsihin musu ra: “Tandɨhɨ tan tsa iyó vaha tsa cuenda vico tindaha, maa tyin ñi cana̱ yu, ña taahán tsi tsa quitsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cu̱aahan ndo ityi cahnu tan ca̱na ndo tsi tandɨhɨ nyɨvɨ tsa nañihi ndo na quitsi ñi vico tindaha”, catyí ra rey can. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Musu can cuahán ra naha tandɨhɨ ñi ityi, tan jandu ii̱n ra naha tsi tandɨhɨ nyɨvɨ nañihi̱ ra naha: ñi caquiñi tan ñi vaha iñi. Tacan tan tsitu tsitsi vehe ra tsihin nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Tacan tan quɨhvɨ̱ ra rey can cua nyehe ra tsi tandɨhɨ nyɨvɨ tsa yucú vico yuvehe ra. Tan nyehe̱ ra tyin nyaá iin ra tsa nduve jahma vico tindaha nditsí. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tan catyí ra rey tsihin ra: “Tsaa, ¿nacuenda nyií un ihya tan nduve jahma vico tindaha nditsi un?” Tan ña nacaha̱n maa ra can. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tacan tan catyí ra rey can tsihin ra tyihí mesa can naha ra: “Cu̱hñi ndo tsaha ra tan ndaha ra, tan ta̱va ndo tsi ra nu naa ityi tsata vehe. Ican cua vacu ra, tan catsan ña cua cuvi nuhu ra”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tyin cuaha xaan nyɨvɨ nacana̱ Nyoo, maa tyin juhva ñi ñi nacatsi̱ ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tacan tan cuahán ra fariseo naha ra tan ndoo̱ ra naha tyiñu tyin cua jacahan ra naha tsi ra Jesús iin tsa ña vaha, tyin tacan tan cuvi tyaa ra naha cuatyi sɨquɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tan jacuhu̱n ra naha tsi juhva ra yɨhɨ́ cuenda ra naha, iin caa ñi tsihin juhva ra yɨhɨ́ cuenda ra Herodes. Tan catyí ra naha tsihin ra Jesús: ―Maestro, tsitó ndi tyin tsa nditsa caahán un. Tan tsihin tsa nditsa janahá un ityi Nyoo. Tan inducu ñi cuñí un nyehe un tsi nyɨvɨ cuca tan nyɨvɨ ndaahvi. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Nacaa tsicá tucu iñi yooho: A vaha tyahví yo tsa tsicán ra ndacá ñaha nda ñuu Roma, o ña vaha? ");
INSERT INTO mjcNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tan ra Jesús tuvi̱ iñi ra tyin ña vaha cuhva tsicá iñi ra naha, tan catyí ra tsihin ra naha: ―Nyooho tsa jahá tyin vaha xaan ndo, tan ña nditsa. ¿Nacuvi tyin nducú cuhva ndo tsi yu? ");
INSERT INTO mjcNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ja̱naha jihna ndo iin xuhun tsa tuhvá yo tyahví tsi ra ndacá ñaha tsi yu ―catyí ra. Tan tsindaca̱ ra naha iin xuhun tsa nañí denario tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tan tsa nyehe̱ ra Jesús xuhun can, tsica̱ tuhun ra tsi ra naha tan catyí ra: ―¿Yóo nuu tan yóo sɨvɨ nyaá ihya? ");
INSERT INTO mjcNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tan nacaha̱n ra naha tan catyí ra naha: ―Nuu ra ndacá ñaha. Tacan tan catyí ra Jesús tsihin ra naha: ―Tun tacan jiin, cu̱hva ndo tsa tsii ra ndacá ñaha tsi ra, tan cu̱hva ndo tsa tsii Nyoo tsi maa ra ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tsa tsiñi̱ ra naha tsa caha̱n ra Jesús, iyo xaan cuñi̱ ra naha. Tan cuahán ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Juvin ñi quɨvɨ can juhva ra cuví saduceo naha ra tsaha̱n ra naha nu nyií ra Jesús. Tan ra cuví saduceo can ña tsinú iñi ra naha tsa cua nandoto ndɨyɨ quɨvɨ tsa cua naa ñuu ñayɨvɨ. Yacan cuenda tsica̱ tuhun ra naha tsi ra Jesús, tan catyí ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, ra Moisés catyi̱ ra tyin tatun iin ra tindaha̱ tan tsihi̱ ra tan ña tsicoo̱ sehe ra, taahán tsi tsa tindaha yañi ra tsihin ñasɨɨhɨ ra. Tacan tan cua coo sehe ra tsihin ña tsa cuenda ra yañi ra tsa tsihi̱. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Vaha. Tun iin ra tan iyó utsa sehe yɨɨ ra, tan ra tsa jihna ñi tindaha̱ ra. Tan nduve sehe ra tsicoo̱ tsihin ñasɨɨhɨ ra tan tsihi̱ ra. Ndoo̱ ñasɨɨhɨ ra tsi yañi ra tsa tsinu uvi. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tan juvin ñi tsihi̱ ndɨhɨ ra can. Tan ndoo̱ ñaha can tsihin ra tsa tsinu uñi, maa tyin juvin ñi tacan taha̱n ndɨhɨ ra. Tan inducu ñi taha̱n tandɨhɨ tsa utsa ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tan nu ndɨhɨ ña tsihi̱ ndɨhɨ maa ñaha can. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tatun nditsa tsa cua nandoto nyɨvɨ tsihi̱, ¿ndáa tsa utsa taahan ra can naha ra cua cuvi yɨɨ ña? Tyin tandɨhɨ maa ra naha tindaha̱ tsihin ña ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tan nacaha̱n ra Jesús tsihin ra naha tan catyí ra: ―Nyooho, caahán soho ñi maa ndo, tsa cuenda tyin ña tsitó ndo tsa nyaá nu tutu Nyoo, tan ndi ña tsitó ndo nácaa tsa cahnu cuví tunyee iñi tsa iyó tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tyin quɨvɨ cua nandoto nyɨvɨ tsihi̱, ndi ña cua tindaha ñi, tan ndi ña cua cuhva ñi sehe sɨɨhɨ ñi tindaha, tyin cua cuvi ñi tumaa cuví ángel tsa iyó gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tyin tuhun Nyoo tsahá cuenda tsi nácaa cuví tuhun tsa cua nandoto nyɨvɨ tsa tsihi̱. ¿O ñaha ca cahvi ndo nu tsahá cuenda Nyoo tuhun can tsi ndo? tan catyí tsi tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yuhu cuví Nyoo cuenda ra Abraham, tan ra Isaac tan ra Jacob.” Ihya nyehé yo tyin nyito añima ra can naha ra, vasu tsanaha tsihi̱ ra naha. Tyin Nyoo ñavin Nyoo cuenda nyɨvɨ tsihi̱ cuví ra, tyin Nyoo cuví ra Nyoo cuenda nyɨvɨ nyito ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tan tsa tsiñi̱ nyɨvɨ tsa caahán ra Jesús, iyo xaan cuñí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tsa tsito̱ ra fariseo naha ra tyin ra Jesús tyasɨ̱ ra yuhu ra saduceo naha ra, ndu ii̱n ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tan iin ra tsa nyií tsihin ra naha cuví ra maestro cuenda ley vehe ñuhu tan cuñi̱ ra nducu cuhva ra tsi ra Jesús. Tan tsica̱ tuhun ra tsi ra, tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿ndáa ley cuví tsa ñiñi ca? ");
INSERT INTO mjcNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tan catyí ra Jesús tsihin ra: ―“Cu̱ñi tsi Jutu Mañi yo Nyoo tsihin tsa nɨɨ iñi un tan tsihin tsa nɨɨ iñi añima un, tan tsihin tandɨhɨ tsa tsiñi tuñi jiñi un.” ");
INSERT INTO mjcNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ley ihya cuví tsa ñiñi ca, tan tsa jihna ñi taahán tsi javaha yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tan tsa tsinu uvi, tsa yatyin inducu ñi caahán tsi tumaa caahán tsa jihna ñi tan catyí tsi tyehen: “Cu̱ñi tsi nyɨvɨ tahan un tumaa cuñí un tsi maa un.” ");
INSERT INTO mjcNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tatun tyaá yahvi ndo nduvi taahan ley ihya, tsa tyaá yahvi ndɨhɨ ndo tandɨhɨ ca ley tsa tyaa̱ ra Moisés jaha̱ Nyoo, tan tandɨhɨ tuhun tsa jacuaha̱ ra cuví ndusu yuhu Nyoo taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tsitsi tsa ndi yucú ra fariseo naha ra nu ndu ii̱n ra naha, ");
INSERT INTO mjcNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ra Jesús tsica̱ tuhun ra tsi ra naha, tan catyí ra: ―¿Nacaa tsicá iñi nyooho cuenda ra cuví Cristo? ¿Yóo tata cuví ra, cuñí maa ndo? Tan nacaha̱n ra naha tan catyí ra naha: ―Tata ra David cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tacan tan ra Jesús catyí ra tsihin ra naha: ―Tun tacan, ¿nacuenda jacaha̱n Tatyi Ii Nyoo tsi ra David tyin ra ndacá ñaha tsi ra cuví ra Cristo tan catyí ra tyehen?: ");
INSERT INTO mjcNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nyoo caha̱n tsihin Jutu Mañi yu, ra Cristo, tan catyí ra tsihin ra: “Cu̱nyaa xiin cuaha yu nda cuanda caquin yu tsi ra xaan iñi tsi un naha ra tsaha un”, catyí ra David. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Nacaa cuví cuú tucu ra Cristo tata ra David, tan juvin ñi maa ra David catyi̱ ra tyin ra Cristo Jutu Mañi ra cuví tsi ra? ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tan yoñi maa cuvi̱ nacaha̱n nu caha̱n ra ndi intuhun maa tuhun. Tan nda quɨvɨ can, yoñi ca maa cuñí nducu tuhun tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tacan tan ra Jesús catyí ra tsihin tandɨhɨ nyɨvɨ, tan tsihin ra tsicá tsihin ra: ");
INSERT INTO mjcNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ra cuví maestro cuenda ley naha ra tan ra cuví fariseo naha ra taahán tsi tsa jacuahá ra naha cuhva catyí ley tsa tyaa̱ ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yacan cuenda tya̱a yahvi ndo tsa caahán ra naha tan ja̱vaha ndo tandɨhɨ cuhva caahán ra naha tsihin ndo. Maa tyin ña ja̱vaha ndo cuhva javahá ra naha, tyin maa ra naha, sɨɨn tsa jacuahá ra, tan sɨɨn tsa javahá ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Janducuahá ca ra naha ley tsa tsaha̱ Nyoo taha̱n tsanaha. Tan cuñí ra naha tsa javaha nyɨvɨ tandɨhɨ can. Maa tyin ña cunyee ñi javahá ñi tandɨhɨ can, tan ndi maa ra naha tan ña cuñí ra naha javaha ra naha can. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tyin maa ra naha tyaá ra naha caja ñɨɨ nu yɨhɨ́ tuhun Nyoo nutyaan ra naha tan soco ra naha, maa tyin nahnu ca can tan ñavin ca tsa nyecú tsi inga ca nyɨvɨ. Tan tsinditsí ra naha jahma nañi ca tan ñavin ca tsa iyó tsi inga ca nyɨvɨ. Javahá ra naha tandɨhɨ can tyin na nyehe nyɨvɨ tyin vaha xaan ca ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tan nu vaha ca, cuñí ra naha cunyecu ra naha nu iyó vico tan catsi ra naha. Tan nu vaha ca cuñí ra naha cunyecu ra naha tsitsi vehe ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tan nu tsicá nuu ra naha cuñí ra naha tyin cuhva nyɨvɨ nacumi tsi ra naha tyin jahá ñi tsa ñayɨvɨ tsi ra naha. Tan cuñí tucu ra naha tsa catyi ñi “maestro” tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Maa tyin nyooho, ña cu̱hva ndo tsa cahan nyɨvɨ “maestro” tsihin ndo. Tyin intuhun ñi maa ra Cristo cuví maestro tsa nyií tsihin ndo, tan tandɨhɨ ca maa ra naha yañi ndo cuví tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tan ña cahan ndo Jutu ndo tsihin ndi intuhun rayɨɨ ñuu ñayɨvɨ ihya, tyin intuhun ñi ra nyaá gloria cuví Jutu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tan ña cahan ndo tyin ra cuví ityi nuu cuví ndo, tyin intuhun ñi maa ra Cristo cuví nuu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ra tsa jahá tyiñu tyiñu tandɨhɨ ca ra naha, ra ican cuví ra cahnu ca nu yucú ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tyin ra cahnu jahá tsi ra, cua janduluhlu Nyoo tsi ra. Tan ra ña cahnu jahá tsi ra cua nducahnu ra jaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ndahvi nyooho ra cuví maestro cuenda ley vehe ñuhu tan nyooho ra cuví fariseo tyin jahá ndo tyin vaha xaan ndo, tan ña nditsa! Tyin tyasɨ́ ndo yuvehe nu ndacá ñaha Nyoo, tan ña cuvi quɨhvɨ nyɨvɨ. Tan ndi maa ndo ña quɨhvɨ ndo, tan ndi ña tsahá ndo tsa quɨhvɨ nyɨvɨ tsa cuñí quɨhvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ndahvi nyooho ra cuví maestro cuenda ley tan nyooho ra cuví fariseo. Jahá ndo tyin vaha xaan ndo, tan ña nditsa! Iyo ña cuahán tucu ndo cua ndacan tahvi ndo tsi Nyoo nu tuvi nyɨvɨ tyin jahá ndo tyin vaha xaan ndo. Maa tyin nduve náa catyí tyin quihín nyaa ndo vehe ñi ndaahvi tsa tsihi̱ yɨɨ tyin ña cuví tyahvi ñi xuhun tsa tsicán ndo tsi ñi. Yacan cuenda cahnu ca tundoho cua nyehe ndo jaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ndahvi nyooho ra maestro cuenda ley vehe ñuhu tan nyooho ra fariseo! ¡Jahá ndo tyin vaha xaan ndo, tan ña nditsa! Tyin nanducú ndo nɨɨ cahnu nu ñuhu ñayɨvɨ tyin cuñí ndo nañihi ndo vasu intuhun nyɨvɨ cunyicun tsi ndo. Tatun tsa quɨhvɨ̱ ñi cuenda ndo, quiñi ca iyó ñi jahá ndo, tan ñavin ca maa ndo. Tan cua cuhun ñi anyaya tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ndahvi nyooho ra ndaahvi! Tyin cuñí ndo jaquihin ityi ndo tsi nyɨvɨ, ¡maa tyin cuaa ndo! Caahán ndo tyin yóo nyɨvɨ cua cahan “Naha Nyoo” tsa cuenda vehe ñuhu, nduve ñi náa cua cuvi tsi ñi tun ña tyaa yahvi ñi tsa cahan ñi. Maa tyin tun cua cahan ñi “Naha Nyoo” tsa cuenda xuhun cuaan tsa iyó vehe ñuhu, tacan tan taahán tsi javaha ñi tsa cahan ñi, catyí ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Soho xaan ndo tan cuaa ndo! ¿Ndáa tsa cahnu ca cuví? ¿A xuhun cuaan can, a vehe ñuhu tsa jandu ií tsi xuhun cuaan can? ");
INSERT INTO mjcNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tan juvin ñi catyí tucu ndo tyin yóo nyɨvɨ cua cahan “Naha Nyoo” tsa cuenda altar tsa iyó vehe ñuhu, nduve ñi náa cua cuvi tsi ñi tun ña tyaa yahvi ñi tsa cahan ñi. Maa tyin tun cua cahan ñi “Naha Nyoo” tsa cuenda tsa jamañí ñi nu altar, tacan tan taahán tsi javaha ñi tsa cahan ñi, catyí ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Soho xaan ndo tan cuaa ndo! ¿Ndáa tsa cahnu ca cuví? ¿A tsa jamañí ndo nu altar can, o maa altar tsa jandu ií tsa jamañí ndo? ");
INSERT INTO mjcNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tyin nyɨvɨ caahán “Naha Nyoo” tsa cuenda altar can, ñavin cuenda altar ñi caahán ñi tuhun, tyin caahán ndɨhɨ ñi tsa cuenda tandɨhɨ tsa yosó nu altar can. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tan nyɨvɨ caahán “Naha Nyoo” tsa cuenda vehe ñuhu cahnu, ñavin cuenda vehe ñuhu ñi caahán ñi tuhun, tyin nda cuanda cuenda Nyoo caahán ñi tuhun, tyin iyó ra ican. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tan tacan tucu nyɨvɨ tsa caahán “Naha Nyoo” tsa cuenda gloria; nda cuanda tyayu Nyoo tan cuanda maa Nyoo caahán ñi tuhun, tyin maa ra cuví ra nyaá ndacá ñaha ndacan. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ndahvi nyooho ra cuví maestro cuenda ley vehe ñuhu tan nyooho ra cuví fariseo! Jahá ndo tyin vaha xaan ndo tyin cahví ndo ndaha menta tan tsɨtɨ anis tsihin tsɨtɨ comino, tacan tan tavá ndo intuhun tsi tsa iin iin utsi, tan tsahá ndo tsi Nyoo. Maa tyin ña tyaá yahvi ndo ley nahnu ca tsa taahán tsi javaha yo: tsa javahá yo tsa vaha tsihin tandɨhɨ nyɨvɨ, tsa cundaahvi iñi yo tsi ñi, tsa tsinú iñi yo tsi Nyoo tan ña nacoo yo tsi ra. Cuñí tsi javaha ndo tandɨhɨ can, tan ña cua jandɨhɨ ndo tsa cuhva ndo diezmo can. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nyooho ra cuaa, cuñí ndo jaquihin ityi ndo tsi nyɨvɨ, maa tyin ña cuví, tyin maa ndo ña jahá ndo cuenda cuatyi nahnu tsa javahá ndo, tan numi xaan nyehé ndo cuatyi nyihi ñi. Tan cuví tsi tumaa tsa tavá ndo tyucun luhlu nu tsa tsatsí ndo tan coco ndo iin camellu. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ndahvi nyooho ra cuví maestro cuenda ley vehe ñuhu tan nyooho ra cuví fariseo! ¡Jahá ndo tyin vaha xaan ndo, tan ña nditsa! Tyin tumaa nacatyá ndo vasu tan coho, tan ityi tsata ñi tsi nacatyá ndo tan ña nacatyá ndo ityi tsitsi, tyin ityi tsitsi can, nu ña nacatyá ndo, ican cuví añima ndo tan tsitu tsi tsihin tsa caquiñi: tsa suhú ndo tan tsa tsicá iñi ndo tsa coo cuaha ndaha tyiñu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Nyooho ra fariseo cuaa! Na̱catya jihna ndo ityi tsitsi vasu tan coho, tacan tan cua ndoo ndɨhɨ ityi tsata. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ndahvi nyooho ra cuví maestro cuenda ley vehe ñuhu tan nyooho ra cuví fariseo! ¡Jahá ndo tyin vaha ndo, tan ña nditsa! Tyin cuví ndo tumaa iin ñaña ndɨyɨ tsa nacahyɨ̱, tyin ityi tsata tsi sɨɨ xaan caá, maa tyin ityi tsitsi tsitu yɨquɨ ndɨyɨ, tan tandɨhɨ nuu tsa caquiñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tacan cuví nyooho, tyin cuñí nyɨvɨ tyin vaha xaan iñi ndo, maa tyin añima ndo ican quitá tsa jandaví ñaha ndo tan tandɨhɨ tsa caquiñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ndahvi nyooho ra cuví maestro cuenda ley vehe ñuhu, tan nyooho ra cuví fariseo! ¡Jahá ndo tyin vaha xaan ndo, tan ña nditsa! Tyin jandutyaquɨ́ ndo ñaña ra cuvi̱ ndusu yuhu Nyoo, tan nacahyɨ́ ndo ñaña nyɨvɨ vaha tsicoo̱ taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tacan tan catyí ndo: “Tun tsatyin tsicoo̱ yo quɨvɨ tsicoo̱ tsii tsaahnu yo, ña cua jatyinyee yo tsi ra tsahñi̱ tsi ra cuvi̱ ndusu yuhu Nyoo”, catyí ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","¡Tsihin yacan ñi tan nacotó ndo tyin cuví ndo tata nyɨvɨ tsahñi̱ tsi ra cuvi̱ ndusu yuhu Nyoo! ");
INSERT INTO mjcNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Yacan vityin nye̱he maa ndo na jaha ndo, ja̱vaha ndɨhɨ ndo tsa javaha̱ tsii tsaahnu ndo, tun cuñí ndo! ");
INSERT INTO mjcNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Nyooho nyɨvɨ caquiñi cuví ndo, tan nyɨvɨ cuví tata coo! ¿Nacaa cua cacu ndo tan ña cua cuhun ndo anyaya? Ña cua cuvi. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yacan cuenda cua jaquitsi yu tsi ra cuví ndusu yuhu Nyoo nu yucú ndo, cua jaquitsi tucu yu tsi ra tsitó xaan naha ra nu yucú ndo, tan ra maestro naha ra cua tsaa ra naha nu yucú ndo. Maa tyin nyooho cua cahñi ndo tsi juhva ra, tan cua tyaa ndo tsi inga ra naha nu cruu. Tan inga ra naha cua cañi ndo tsi ra naha tsitsi vehe ñuhu. Tan cunyaa ndaha ndo tsi ra naha tan iin tan iin ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yacan cuenda, tsata nyooho cua cunyaa cuatyi tsa cuenda tandɨhɨ ra vaha tsa tsahñi̱ tsii tsaahnu ndo nda cuanda tsihi̱ ra Abel tan nda cuanda quɨvɨ tsihi̱ ra Zacarías, sehe ra Berequías, tsa tsahñi̱ ra naha tsitsi vehe ñuhu yatyin nu nyaá altar tsa yosó tsa jamañí yo tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tsa nditsa catyí yu tsihin ndo, tyin tandɨhɨ cuatyi can cua coso sɨquɨ nyooho, nyɨvɨ tsa iyó vityin ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Ñuu Jerusalén! ¡Ndahvi nyooho nyɨvɨ ñuu Jerusalén! Tyin tsahñi̱ ndo tsi ra cuvi̱ ndusu yuhu Nyoo. Tan cañi̱ ndo yuu tsi tandɨhɨ ra tsa jaquitsi̱ Nyoo nu yucú ndo. Tan yuhu cuaha xaan tsaha cuñí yu jaha cuenda yu tsi ndo, tumaa iin ndɨvɨ sɨɨhɨ tsa jahá cuenda tsi sehe tɨ, tan naquihín vaha tɨ sehe tɨ tsitsi nditsin tɨ, maa tyin ña cuñi̱ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nye̱he ndo vityin, tyin tsa nacoo̱ ihñi Nyoo tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tan catyí yu tsihin ndo, tyin ña cua nyehe ca ndo tsi yu nda cuanda quita quɨvɨ tsa cua catyi ndo tyin cahnu xaan cuví ra vatsí tsihin sɨvɨ Nyoo Jutu yo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Quita̱ ra Jesús tsitsi vehe ñuhu cahnu can, tan tsa cuñí cuhun ra, tan natuhva̱ ra tsicá tsihin ra nu nyaá ra, tan quitsaha̱ caahán ra naha cuhva caá vehe ñuhu can tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Maa tyin nacaha̱n ra Jesús tan catyí ra: ―¿A nyehé ndo tandɨhɨ tsa iyó ihya? Tsa nditsa catyí yu tsihin ndo, tyin ihya ndi intuhun ca yuu tan ña cua coso tsata inga tsi. Tandɨhɨ maa can tan cua tanɨ ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tacan tan cuahán ra naha yucu Olivo. Tan cuhva tsa nyaá ra Jesús ican, ra tsicá tsihin ra tsaha̱n ra naha nu nyaá ra tan nducú tuhun xeehe ra naha tsi ra tan catyí ra naha: ―Cuñí ndi tsa catyi tuhun un tsihin ndi, ama cua cuvi tandɨhɨ tsa caha̱n un. ¿Nacaa tan coto ndi tatun tsa cuyatyin tsa cua quitsi un inga tsaha tan tsa cua naa ñuhu ñayɨvɨ? ");
INSERT INTO mjcNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tacan tan nacaha̱n ra Jesús: ―Ja̱ha vaha ndo cuenda coto jandavi ñaha nyɨvɨ tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tyin cuaha xaan ra cua quitsi, tan cua cutyiñu ra naha sɨvɨ yu, tan cua catyi ra naha: “Yuhu cuví ra Cristo, ra tsa jaquitsi̱ Nyoo.” Tan cuaha nyɨvɨ cua jandavi ñaha ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tan cua ñihi tuhun ndo tyin iyó cuatyi tan cañí tahan nyɨvɨ ityi can tan ityi ihya. Maa tyin ña na̱yuhvi ndo, tyin tacan taahán maa tsi cua cuvi tsa ndi cumañi ca naa ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tyin nyɨvɨ iin ñuu cua cañi tahan ñi tsihin nyɨvɨ inga ñuu. Tan cua coo cuatyi iin ñuu tsihin inga ñuu. Tan cua coo tama, tan cua coo cuehe, tan cuaha ñi ityi cua taan ñihi. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tandɨhɨ yacan cua cuvi nu ndi cua quitsaha nyehe nyɨvɨ tundoho. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Tacan tan cua cuhva cuenda nyɨvɨ tsi ndo tsi ra cumi tyiñu naha ra na tatsi tuñi ra naha tsi ndo. Tan cua cahñi ra naha tsi ndo. Tan tandɨhɨ nyɨvɨ iyó nu ñuhu ñayɨvɨ ndasɨ cua cuñi ñi nyehe ñi tsi ndo tsa cuenda yuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Quɨvɨ can cuaha xaan nyɨvɨ cua jaña ñi tsa tsinú iñi ñi tsi yu, tan ndasɨ cua cuñi ñi nyehe tahan ñi tsi ñi. Tan cua naxico ñaha tahan ñi tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tan cuaha xaan ra caahán cuendu cua coo, tan cua catyi ra naha tyin cuenda Nyoo caahán ra naha. Tan cuaha xaan nyɨvɨ cua jandavi ñaha ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tan cuaha xaan tsa caquiñi cua coo. Yacan cuenda cua jandɨhɨ ñi tsa cuñí tahan ñi tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Maa tyin nyɨvɨ tsa tsinú iñi tsi yu nda cuanda nu ndɨhɨ, tan ña cua ndu uvi iñi ñi, cua cacu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tan tanɨɨ cahnu ñuhu ñayɨvɨ cua nacutya tuhun vaha tsa cuenda cuhva tsa ndacá ñaha Nyoo. Tan quɨvɨ cua coto nyɨvɨ tandɨhɨ ñuu tuhun vaha ihya, tacan tan cua naa ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ra Daniel, ra cuvi̱ ndusu yuhu Nyoo, tyaa̱ ra nu tutu Nyoo tyin coo tsa cua janducaquiñí, tsa cua jatɨvɨ. Quɨvɨ tsa cua nyehe ndo can tsitsi vehe ñuhu Nu Ii, (nyooho tsa cahví, na cutuñi iñi ndo). ");
INSERT INTO mjcNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tyin quɨvɨ can, nyɨvɨ tsa iyó Judea taahán tsi tsa quita ñi ican tan cuhun ñi ityi yucu. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tan nyɨvɨ yucú jiñi vehe, cua nuu ñi, maa tyin ña cua quɨhvɨ ñi tsitsi vehe ñi tan tava ñi tsa iyó tsitsi vehe ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tan nyɨvɨ yucú tsitsi cuhu ña cua cunuhu jihna ñi cunaquihin ñi jahma ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ndahvi ñiñaha tsa ñuhú sehe quɨvɨ can! O tatun iyó sehe ñi tsa tyaxín, ¡ndahvi ñi can! ");
INSERT INTO mjcNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nda̱can ndo tsi Nyoo na ña tahan tsi cunu ndo quɨvɨ vitsin, tan ndi quɨvɨ quitatú yo. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tyin tundoho tsa cua nyehe nyɨvɨ quɨvɨ can, ñaha ca maa coo can nda quɨvɨ tsa tsinu̱ ñuhu ñayɨvɨ. Tan ndi ityi nuu ca ña cua nyehe nyɨvɨ tundoho tacan inga tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tyin tatun ña cua janducuɨtɨ Nyoo quɨvɨ can, yoñi maa cua cacu. Maa tyin cua janducuɨtɨ ra tsa cuenda tsa cuñí ra tsi nyɨvɨ nacatsi̱ maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Tatun yóo cua cahan tsihin ndo: “Jihna ndo, ihya nyaá ra Cristo” o “Nye̱he ndo, ndacan nyaá ra Cristo”, ña tsi̱nu iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tyin cua quitsi ra jandavi ñaha naha ra tan cua catyi ra naha tyin ra Cristo cuví ra naha. Cua catyi ra naha tyin ndusu yuhu Nyoo cuví ra naha. Tan cua javaha ra naha seña tan tsa iyo nahnu tyin cua jandavi ñaha ra naha nda cuanda nyɨvɨ tsa nacatsi̱ maa Nyoo tun tsatyin cuvi jaha ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Vaha tyin tsa tsitó ndo vityin ihya, ja̱ha ndo cuenda tsi ndo quɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yacan cuenda tatun catyí nyɨvɨ tsihin ndo: “Nye̱he ndo, va ra Cristo nyií nu tsɨquɨ can”, Ña cu̱hun ndo. O tatun catyí ñi tsihin ndo: “Nye̱he ndo, nyií ra tsitsi cuartu ihya”, ña tsi̱nu iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tyin tumaa tsa cañí tatsa savi nyehé yo xiñu xaan nda ityi nu caná ñicanyii tan nda cuanda ityi nu tyisó ñicanyii, tacan cua cuvi quɨvɨ quitsi yuhu, Rayɨɨ tsa quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tumaa natacá nditsii nu cayucú tsa iñi, tacan cua nataca nyɨvɨ yɨhɨ́ cuenda yu quɨvɨ quitsi yu inga tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Tan tsa yaha tsa cua nyehe nyɨvɨ tundoho, ñicanyii cua ndunaa tsi, yoo ña cua jandunditsin ca tsi, tan tiñuu cua cucoyo tiñuu, tan tandɨhɨ tsa iyó andɨvɨ cua nacanda. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tacan tan cua quituvi seña ityi andɨvɨ tyin vatsí yuhu Rayɨɨ tsa quee̱ nda gloria. Cua quitsi yu nu vico ityi andɨvɨ tsihin tunyee iñi cahnu tan tsihin tsa cahnu cuví Nyoo. Tan tandɨhɨ nyɨvɨ iyó nu ñuhu ñayɨvɨ, cua vacu tsaa xaan ñi tsa cua nyehe ñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tan cuaha ángel cuenda yu cua jaquitsi yu tyin ñihi cua tɨvɨ ra naha cutu tan cua jandu iin ra naha tsi nyɨvɨ nacatsi̱ maa Nyoo. Cua quita ñi tanɨɨ cahnu nu ñuhu ñayɨvɨ, nda cuanda nu ndɨhɨ ñuhu ñayɨvɨ tan nda cuanda nu ndɨhɨ andɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Cu̱tuñi iñi ndo iin cuhva yutun tsa nañí higo: Tatun tsa yutya soco tun, tan tsa cana̱ ndaha yutya tun, nyooho tsitó ndo tyin tsa cua coo tsɨtɨ tun. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tan juvin ñi tacan, tatun tsa cuví tandɨhɨ yacan nyehé ndo, cua coto ndo tyin tsa cuyatyin quitsi yu; tan tsa nyanaá yu yuvehe cuví tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tsa nditsa catyí yu tsihin ndo tyin tandɨhɨ yacan cua cuvi jihna, tsa ndi cumañi ca cúu nyɨvɨ iyó nu ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tan coo quɨvɨ cua cunaa andɨvɨ tan tsihin ñuhu ñayɨvɨ, maa tyin tuhun caahán yuhu, ña cua cundɨhɨ tsi tyin cua cundaa tandɨhɨ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Maa tyin quɨvɨ tan hora tsa cua cuvi yacan, yoñi tsitó, ndi ángel iyó gloria tan ña tsitó ra naha. Intuhun ñi maa Nyoo Jutu yo tsitó. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Tumaa cuvi̱ quɨvɨ tsa tsicoo̱ ra Noé, tacan cua cuvi quɨvɨ tsa cua quitsi nyico yuhu Rayɨɨ tsa quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Quɨvɨ tsa ndi cumañi ca cuun savi xaan, nyɨvɨ can, tsatsí ñi, tsihí ñi, tindahá ñi, tan tsahá ñi tsi sehe sɨɨhɨ ñi tindaha nda cuanda quɨvɨ quɨhvɨ̱ ra Noé tsitsi yutun ndoo. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tan sana iñi ñi tan tsaa̱ savi tan tañi̱ tandɨhɨ ñi. Tan tacan sana iñi ñi tan cua tahan tsi quɨvɨ quitsi nyico yuhu Rayɨɨ tsa quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tan tatun yucú uvi taahan rayɨɨ tsitsi cuhu quɨvɨ can, intuhun ñi ra cua quihin yu, tan cua nacoo yu tsi inga ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tan quɨvɨ can uvi taahan ñaha cua nyico ñi. Intuhun ña cua naquihin yu, tan inga ña cua ndoo ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Cu̱atu vaha ndo tyin ña tsitó ndo náa hora cua quitsi ra ndacá ñaha tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tan co̱to ndo tuhun ihya tyin tatun iin tsitoho vehe tan tsitó ra náa cuhva cua quɨhvɨ ñasuhu tsitsi vehe ra, cua cuatu vaha ra tan ña cua cuhva ra tsa quɨhvɨ ñasuhu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yacan cuenda nyooho, cu̱atu vaha ndo. Tyin sana iñi ndo, tan cua quitsi nyico yuhu Rayɨɨ tsa quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Musu tsa tyaá soho tsa caahán tsitoho ra, juvin ra cuví musu vaha. Tyin jahá cuenda ra vehe tsitoho ra. Tan vaha hora tsahá ra tsa catsi tandɨhɨ ca musu. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tan sɨɨ xaan cuñí ra cuví musu vaha can, tatun cuhva tsa jahá tyiñu ra tan tsaa tsitoho ra. Tyin tyaá yahvi ra tandɨhɨ tsa taahán tsi ica ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tan tsa nditsa catyí yu tsihin ndo, tyin tsitoho ra cua nacuhva ra tandɨhɨ cuii tsa cumí ra, cua quɨhɨ ndaha ra, tyin vaha tyaá yahvi ra tsihin tyiñu jahá ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Maa tyin iin musu ña vaha tsicá iñi ra tyin cua cucuee tsitoho ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tacan tan quitsaha cañí ra tsi inga musu, tan tsatsí ra tan tsihí ra nyixi tsihin ra tsiñi naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tacan tan sana iñi ra tan cua tsaa tsitoho ra quɨvɨ tsa ña ndatú ra tsi ra, tan hora tsa ña tsitó ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tacan tan tsitoho ra ñihi xaan cua tatsi tuñi ra tsi ra tumaa tuhvá maa ra icá tsihin nyɨvɨ tsa jahá tyin vaha xaan ñi tan ña icá ñi tsa vaha. Tacan tan cua vacu ra cuví musu ña vaha can tan cahyu ña cua cuvi nuhu ra tsa nyehé ra tundoho. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Tsa ndacá ñaha Nyoo tsi nyɨvɨ cuví tsi tumaa utsi taahan ñaha yoco tsa quihi̱n lámpara tsa yɨhɨ́ acetye tan cuahán ñi iin vico tindaha tyin cua jatahan ñi tsi ra tsa cua tindaha. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Uhun taahan ñi, soho xaan ñuhú iñi ñi, tan inga uhun taahan ñi can catsi xaan tsicá iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ñi tsa soho ñuhú iñi can, nyisó ñi lámpara ñi maa tyin ña quihi̱n ñi juhva ca acetye tsa natyihi ñi tsitsi lámpara ñi tatun ndɨhɨ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tan ñi tsa catsi tsicá iñi can, nyisó sɨɨn ñi inga yutyi acetye tsa cua natyihi ñi tsitsi lámpara can tatun ndɨhɨ acetye tsa yɨhɨ́ tsitsi lámpara can. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tan ra tsa cua tindaha can cucueé xaan ra, tacan tan tɨɨ̱n ñumaahna tsi tandɨhɨ ñi, tan quixi̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tacan tan maa ñuu tsiñi̱ ñi iin ndusu tsa catyí tyehen: “¡Tsa vatsí ra tsa cua tindaha! ¡Qu̱ita ndo, ja̱tahan ndo tsi ra!” ");
INSERT INTO mjcNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tandɨhɨ ñi can nduvita̱ ñi tan quitsaha̱ janduvahá ñi lámpara ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tacan tan quitsaha̱ caahán tsa uhun ñi soho ñuhú iñi can tsihin inga uhun ñi can tan catyí ñi: “Cu̱hva ndo juhva acetye ndahá ndo tsi ndi, tyin cuñí ndahva lámpara ndi”, catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Maa tyin ñi yoco tsa catsi tsicá iñi can nacaha̱n ñi tyehen: “Ña cua cuhva ndi tyin coto ña cua cutahan tsi tsa cuenda ndi tan ndi tsa cuenda nyooho. Vaha ca cuhun maa ndo cujata ndo nu cuyahví tsi.” ");
INSERT INTO mjcNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Maa tyin tsitsi tsa cuahán tsa uhun ñi soho ñuhú iñi can cuajata ñi acetye, tan tsaa̱ ra tsa cua tindaha can. Tan ñi yoco tsa ndatú vaha can, quɨhvɨ̱ ñi tsihin ra tsitsi vehe nu cua coo vico tindaha. Tan tsicundasɨ̱ yuvehe can. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Yaha̱ can tan tsaa̱ nyico ñi soho ñuhú iñi can, tan catyí ñi: “¡Yooho tata! ¡Nu̱ña yuvehe na quɨhvɨ ndi!”, catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Maa tyin maa ra nacaha̱n ra, tan catyí ra: “Tsa nditsa catyí yu tsihin ndo tyin ña nacotó yu tsi ndo.” ");
INSERT INTO mjcNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tacan tan quitsaha̱ caahán ra Jesús: ―Cu̱atu vaha ndo, tyin ña tsitó ndo ndáa quɨvɨ tan náa hora cua quitsi nyico yuhu Rayɨɨ tsa quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Tsa ndacá ñaha Nyoo tsi nyɨvɨ cuví tsi tumaa iin rayɨɨ tsa nyaá cua quita cuhun inga ñuu nu cañi. Tan cana̱ ra tsi musu ra, tan tsaha̱ cuenda ra xuhun ra tsi ra naha tyin jaha cuenda ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iin ra tsaha̱ ra uhun mil xuhun, tan inga ra tsaha̱ ra uvi mil xuhun, tan inga ra tsaha̱ ra iin mil. Tsaha̱ ra tsi intuhun intuhun ra nácaa cuhva tsitó ra jaha tyiñu ra naha tan cua nandaa sɨquɨ xuhun can. Tacan tan cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Musu tsa quihi̱n uhun mil xuhun can, ñihi jaha̱ tyiñu ra tsihin xuhun can, tan jaha̱ canaa ra inga uhun mil ca sɨquɨ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tan juvin ñi tacan tucu ra tsa quihi̱n uvi mil can, jaha̱ canaa ra uvi mil ca tsihin xuhun can. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Maa tyin ra tsa quihi̱n intuhun ñi mil can, tsaha̱n ra tan tsatya̱ ra iin yavi tsitsi ñuhu tan tyihi̱ xeehe ra xuhun tsitoho ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Cuaha quɨvɨ yaha̱ tan tsaa̱ nyico tsitoho musu can. Tan quitsaha̱ natavá cuenda ra tsihin intuhun intuhun ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jihna ca ra tsa quihi̱n uhun mil xuhun can tsaa̱, tan nacuhva̱ cuenda ra uhun mil ca sɨquɨ can, tan catyí ra: “Taa, uhun mil tsaha̱ un tsi yu, ju̱hun inga uhun mil ihya tsa jaha̱ canaa yu sɨquɨ tsi.” ");
INSERT INTO mjcNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tan tsitoho ra catyí ra tsihin ra: “Vaha. Iin musu vaha xaan cuví un. Tan javaha̱ un tandɨhɨ tsa caha̱n yu tsihin un. Luxu ñi xuhun tsaha̱ yu tsi un tan vaha xaan tsatyiñu̱ un itsi. Vityin cuaha ca cua cuhva cuenda yu tsi un. Qu̱ɨhvɨ nu vaha ihya, tan sɨɨ cu̱ñi un tsihin yu.” ");
INSERT INTO mjcNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yaha̱ can tan tsaa̱ musu tsa quihi̱n uvi mil xuhun can, tan catyí ra: “Taa, uvi mil ñi tsaha̱ un tsi yu, ju̱hun uvi mil ca ihya tsa jaha̱ canaa yu sɨquɨ tsi.” ");
INSERT INTO mjcNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tan catyí tsitoho ra tsihin ra: “Vaha. Iin musu vaha xaan cuví un, tan javaha̱ un tandɨhɨ tsa caha̱n yu tsihin un. Luxu ñi xuhun tsaha̱ yu tsi un tan vaha xaan tsatyiñu̱ un itsi. Vityin cuaha ca cua cuhva cuenda yu tsi un. Quɨ̱hvɨ nu vaha ihya, tan sɨɨ cu̱ñi un tsihin yu”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tan cuhva tsa tsaa̱ musu tsa quihi̱n intuhun ñi mil xuhun can, catyí ra tsihin tsitoho ra: “Taa, yuhu tsitó yu tyin xaan xaan un tan cuñí un naquihín un xuhun nu ña jahá tyiñu un, tan cuñí un naquihin un cosecha nu ña tatsi̱ un. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yacan cuenda nayuhvi̱ yu tan tsaha̱n yu tan tyihi̱ xeehe yu xuhun un tsitsi ñuhu. Ju̱hun xuhun ihya tsa tsaha̱ un tsi yu”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tacan tan nacaha̱n tsitoho ra, tan catyí ra tsihin ra: “Musu ña vaha cuví un, tan musu jutsan cuví yooho. Tatun tsitó un tyin naquihín yu nu ña jaha̱ tyiñu yu, tan quihín yu cosecha nu ña tatsi̱ yu, ");
INSERT INTO mjcNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿nácaa tyin ña tsityihi̱ un xuhun yu nu banco? Tun tsatyin tacan javaha̱ un, tsa cua quitsi nyico yu cuvi naquihin yu xuhun can tsihin xuhun sɨquɨ tsa jaha̱ canaa tsi”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tacan tan quitsaha̱ caahán ra tsihin ra tsa yucú can naha ra: “Qu̱ihin nyaa ndo tsa iin mil tsa ndahá ra, tan cu̱hva ndo tsi ra tsa ndahá utsi mil. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tyin nyɨvɨ jahá tyiñu vaha tsihin tsa iyó tsi ñi, cua cuhva ca yu tsi ñi, tan cua coo cuaha tsi ñi, nda cuanda ndoo ca. Maa tyin nyɨvɨ tsa ña cuñí jaha tyiñu tsihin tsa tsahá yu, nda cuanda tsa luxu tsa cumí ñi, cua quihin nyaa ndɨhɨ yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tan musu tsa ña tsiñí ñuhu tsi yu ihya, ta̱va ndo tsi ra nacuhun ra nu naa ityi tsata, tan ndacan cua vacu tsaa ra, tan cahyu ña cua cuvi nuhu ra tsihin tsa nyehé ra tundoho.” ");
INSERT INTO mjcNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Quɨvɨ cua quitsi nyico yuhu Rayɨɨ tsa quee̱ nda gloria, cua quitsi yu tsihin cuaha ángel cuenda yu. Tan cua cunyaa yu tyayu sɨɨ caá tan cua cundaca ñaha yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tandɨhɨ cuii nyɨvɨ iyó nanɨɨ cahnu nu ñuhu ñayɨvɨ cua nataca ñi nuu yu. Tan cua natava sɨɨn yu tsi intuhun intuhun ñi, tumaa ra jahá cuenda mbee tavá sɨɨn ra tsi mbee ticatyi tan tavá sɨɨn tucu ra tsi mbee chivo. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tan cua tyaa yu tsi mbee ticatyi can tsiyo cuaha yu, tan inga mbee can cua tyaa yu tsiyo satyin yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tacan tan yuhu tsa cuví yu Rey cua catyi yu tsihin nyɨvɨ nyecú tsiyo cuaha yu: “Na̱ha nyooho nyɨvɨ tsa nasoco̱ Jutu yu. Na qui̱hin cuenda ndo nu cua cunyecu ndo nu ndacá ñaha Nyoo, tyin tsa cuenda maa ndo javaha̱ ra ihya quɨvɨ javaha̱ ra ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tyin quɨvɨ tsisoco̱ yu, nyooho tsaha̱ ndo tsa tsatsi̱ yu. Quɨvɨ na ityi̱ iñi yu, tsaha̱ ndo ndutya tsihi̱ yu. Tan quɨvɨ tsica̱ nuu yu cuví yu ra inga ñuu, tsaha̱ ndo nu quixi̱ yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Quɨvɨ cumañi̱ jahma yu, tsaha̱ ndo jahma tsinditsi̱ yu. Quɨvɨ cuhvi̱ yu, tsinyehe̱ ndo nu canyií yu. Tan quɨvɨ tsinyii̱ yu vehe caa, tsinyehe̱ ndo nu nyií yu”. Tacan cua cahan yu tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tan ñi tsa vaha iñi can cua ndaca tuhun ñi tsi yu, tan catyi ñi: “Jutu Mañi yu, ¿ama nyehe̱ ndi tsisoco̱ un, tan tsaha̱ ndi tsa tsatsi̱ un? ¿Ama nyehe̱ ndi na ityi̱ iñi un tan tsaha̱ ndi tsa tsihi̱ un? ");
INSERT INTO mjcNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ama nyehe̱ ndi tsi un tsica̱ nuu un cuví un ra inga ñuu tan tsaha̱ ndi vehe nu quixi̱ un? ¿Ama cumañi̱ jahma un, tan tsaha̱ ndi jahma tsinditsi̱ un? ");
INSERT INTO mjcNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ama nyehe̱ ndi cuhvi̱ un, o tsinyii̱ un vehe caa, tan tsaha̱n ndi tsinyehe̱ ndi tsi un?” cua catyi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tan yuhu tsa cuví Rey cua catyi yu tsihin ñi: “Tsa nditsa catyí yu tsihin ndo, tyin tandɨhɨ tumañi iñi tsa javaha̱ ndo tsi ra ndaahvi, ra yañi yu, tsi yuhu javaha̱ ndo tumañi iñi”, cua catyi yu tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Tacan tan yuhu tsa cuví Rey cua cahan yu tsihin nyɨvɨ tsa yucú tsiyo satyin yu tyehen: “Ca̱tsiyo ndo nuu yu, nyooho, nyɨvɨ taahán tsi cuhun anyaya. Cu̱aahan ndo nu ñuhu̱ tsa ña cua ndahva maa. Tsinu̱ anyaya can tyin ican cua coo nu ña vaha tan tatyi ña vaha cuenda nu. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tyin tsisoco̱ yu tan nyooho ña tsaha̱ ndo tsa catsi yu. Na ityi̱ iñi yu tan ña tsaha̱ ndo ndutya coho yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tsica̱ nuu yu cuví yu iin ra inga ñuu, tan ña tsaha̱ ndo nu cusu yu. Cumañi̱ jahma yu tan ña tsaha̱ ndo jahma cunditsi yu. Nacuhvi̱ yu tan tsinyii̱ yu vehe caa, maa tyin ña tsaha̱n ndo tsinyehe̱ ndo tsi yu nu tsinyii̱ yu”, cua catyi yu tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tacan tan cua catyi ñi tsihin yu: “Jutu Mañi yu, ¿ama nyehe̱ ndi tsisoco̱ un, o na ityi̱ iñi un, o tsicá nuu un cuví un ra inga ñuu, o nduve jahma un, o nacuhvi̱ un, o tsinyii̱ un vehe caa, tan ña jatyinyee̱ ndi tsi un?” cua catyi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tan yuhu tsa cuví yu Rey cua catyi yu tsihin ñi: “Tsa nditsa caahán yu tsihin ndo tyin tandɨhɨ maa tsa ña javaha̱ ndo tsihin nyɨvɨ ndaahvi ihya, ña javaha̱ ndɨhɨ ndo tsihin yu, cuví can”, cua catyi yu tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tacan tan ñi can cua cuhun ñi nu cayú ñuhu̱ tsa ña cua ndahva maa. Tan nyɨvɨ vaha can cua cuhun ñi coo ñi ñayɨvɨ nyito tsa ña cua naa maa. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cuhva tsa ndɨhɨ̱ caha̱n ra Jesús tandɨhɨ tuhun can, tan quitsaha̱ catyí ra tsihin ra tsicá tsihin ra: ");
INSERT INTO mjcNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Nyooho tsitó ndo tyin ndi cumañi uvi ca quɨvɨ tan tahan tsi vico pascua. Tan yuhu, Rayɨɨ tsa quee̱ nda gloria, cua cuhva cuenda nyɨvɨ tsi yu na tyaa ra cumi tyiñu tsi yu nu cruu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Quɨvɨ can jutu tsa cuví ityi nuu naha ra, tan ra maestro cuenda ley vehe ñuhu naha ra, tan ra mandoñi ñuu naha ra, ndu ii̱n ra naha nuquehe vehe tyiñu ra Caifás, ra jutu tsaahnu tsa cuví ityi nuu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tan jandaa̱ ra naha tyiñu nácaa cua jandavi ñaha ra naha tsi ra Jesús tan tɨɨn ra naha tsi ra tan cahñi ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tan catyí ra naha: ―Ña cua cahñi yo tsi ra quɨvɨ maa vico, coto nduvaa xaan nyɨvɨ ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ra Jesús nyií ra ñuu Betania, vehe ra Simón, ra tsa yɨhɨ̱ cuehe tyaahyu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tan natuhva̱ iin ñaha nu nyaá ra Jesús, ndahá ña iin yutyi yuu vaha tsitú can yɨhɨ́ ndutya tami. Tan yahvi xaan nyaá ndutya tami can. Tan ra Jesús nyaá ra yuhu mesa, tan ñaha can tyoso̱ ña ndutya can jiñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tsa nyehe̱ ra tsicá tsihin ra, nduxaa̱n ra naha tan catyí ra naha: ―¿Nacuenda jatɨvɨ̱ ña ndutya tami can? ");
INSERT INTO mjcNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Vaha ca tun tsatyin xico̱ ña can, tan ñihi cuaha ña xuhun tsihin can. Tan cuvi jatyinyee ña tsi nyɨvɨ ndaahvi tsihin xuhun can ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tan tsa tsiñi̱ ra Jesús tsa caahán ra naha, tacan tan catyí ra tsihin ra naha: ―¿Nacuenda cuñí ndo jandu uvi iñi ndo tsi ñaha ihya? Tan tsa javahá ña tsihin yu, tsa vaha cuví tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tyin nyɨvɨ ndaahvi tandɨhɨ ñi quɨvɨ cua coo ñi tsihin ndo, maa tyin yuhu, ña naha ca cua cunyii yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tyoso̱ ña ndutya tami sɨquɨ cuñu ñuhu yu, tyin janduvaha̱ ña itsi tyin cua cuhun tsi tsitsi ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tsa nditsa catyí yu tsihin ndo, tyin tandɨhɨ ñi nu cua cahan nyɨvɨ tuhun Nyoo tanɨɨ cahnu ñuhu ñayɨvɨ, cua nacatyi tuhun tucu ñi tsa javaha̱ ñaha ihya, na nducuhun iñi nyɨvɨ tsi ña ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tacan tan iin ra tsicá tsihin ra Jesús, ra tsa nañí Judas Iscariote, tsaha̱n ra tsicaha̱n ra tsihin ra jutu tsa cuví ityi nuu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tan catyí ra tsihin ra naha: ―¿Nacaa cua tyahvi ndo tsi yu tatun cuhva cuenda yu tsi ra Jesús tsi ndo? Tacan tan ra jutu can naha ra tsaha̱ ra naha oco utsi xuhun cuitsin tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tan nda quɨvɨ can tan quitsaha̱ nducú ra Judas cuhva cua nacuhva cuenda ra tsi ra Jesús tsi ra jutu can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Quɨvɨ jihna ñi tsa quitsaha̱ vico nu tsatsí nyɨvɨ paan tsa nduve yutsan iya yɨhɨ́, ra tsicá tsihin ra Jesús natuhva̱ ra naha nu nyaá ra tan quitsaha̱ tsicá tuhun ra naha tsi ra tan catyí ra naha: ―¿Numaa cuñí un tsa cujanduvaha ndi tsa cuxiñi un cuenda vico pascua ihya? ");
INSERT INTO mjcNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tan catyí ra Jesús tsihin ra naha: ―Cu̱aahan ndo tsitsi ñuu nda vehe rayɨɨ ihya. Tan ca̱tyi ndo tsihin ra: “Ra Maestro catyí ra tyin tsa yatyin cua cúu ra, tan vehe maa un cua jacahnu ndi vico pascua”, ca̱tyi ndo tsihin ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tacan tan javaha̱ ra naha cuhva caha̱n ra Jesús tsihin ra naha. Tan janduvaha̱ ra naha tsa cuxiñi ra naha vico pascua can. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tsa cunaaha tan tsicunyaa̱ ra Jesús nu mesa tsihin tandɨhɨ utsi uvi ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tan tsitsi tsa tsatsí ra naha, catyí ra Jesús tsihin ra naha: ―Tsa nditsa catyí yu tsihin ndo tyin iin nyooho cua xico ndo tsi yu tsi ra xaan iñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tan nducuihya̱ xaan cuñí ra naha, tan quitsaha̱ tsicá tuhun tan iin tan iin ra naha tsi ra tan catyí ra naha: ―Jutu Mañi yu, ¿a ñavin yuhu cuví can? ");
INSERT INTO mjcNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tan nacaha̱n ra Jesús tan catyí ra: ―Ra tsa tsatsí iin ñi coho tsihin yu, ra ican cua xico tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yuhu, Rayɨɨ tsa quee̱ nda gloria, cua tahan yu tumaa tsa caahán nu tutu Nyoo. Maa tyin ndahvi ra ndaahvi tsa cua xico tsi yu. Vaha vihi ca tun tsatyin ña cacu̱ ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tacan tan nacaha̱n ra Judas, ra tsa xico̱ tsi ra, tan catyí ra: ―Maestro, ¿a yuhu cuví can? Tan nacaha̱n ra Jesús, tan catyí ra: ―Juvin un. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tsitsi tsa tsatsí ra naha, ra Jesús quihi̱n ra paan tan nacuhva̱ ra tyahvi nyoo tsi Nyoo, tan tsahnu̱ sava ra, tan tsaha̱ ra tsi ra tsicá tsihin ra, tan catyí ra tsihin ra naha: ―Ca̱tsi ndo. Paan ihya cuví tumaa cuñu ñuhu yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yaha̱ can tan quihi̱n tucu ra vasu vinu, tan nacuhva̱ ra tyahvi nyoo tsi Nyoo, tan jayaha̱ ra tsi tandɨhɨ ra naha tan catyí ra: ―Co̱ho tandɨhɨ ndo vinu ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tyin cuví tsi tumaa nɨñɨ yu. Tan tsihin nɨñɨ yu cua cundaa tyiñu tsa ndoo̱ Nyoo tsihin ndo, tyin cua catɨ nɨñɨ yu tsa cuenda tsa vaha tsi nyɨvɨ cuaha, tyin tsihin nɨñɨ yu cua coo tucahnu iñi cuatyi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tan catyí yu tsihin ndo, tyin ña cua coho ca yu tahan vinu tsa cuvi ndutya uvas ihya, nda cuanda tsa coho yu vinu tsaa tsihin ndo nda nu ndacá ñaha Jutu yu gloria ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tsa yaha̱ tsa tsita̱ ra naha iin yaa Nyoo, tan cuahán ra naha yucu Olivo. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tacan tan quitsaha̱ caahán ra Jesús tsihin ra naha: ―Tandɨhɨ nyooho tan cua nacoo ihñi ndo tsi yu vityin tsacuaa ihya. Tyin nu tutu Nyoo catyí tsi tyehen: “Cua cahñi yu tsi ra jahá cuenda mbee ticatyi jana yu, tan mbee can cua natsatsa tɨ naha tɨ”, catyí tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Maa tyin tsa yaha̱ nandoto yu, jihna ca yu cua cuhun Galilea, tsa ndi cumañi ca cuhun nyooho. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tacan tan nacaha̱n ra Pedro tan catyí ra: ―Vasu ndi maa tandɨhɨ ra tan ndu uvi iñi ra naha tsa nyicún ra naha tsi un, maa tyin yuhu ña cua ndu uvi iñi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tacan tan catyí ra Jesús tsihin ra: ―Tsa nditsa catyí yu tsihin un tyin juvin ñi maa tsacuaa vityin, tsa ndi cumañi ca vacu tsitooho, uñi tsaha cua cahan un tyin ña nacotó un tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tan ra Pedro catyí ra: ―Vasu ndi maa cúu yu tsihin un, maa tyin ña cua catyi yu tyin ña nacotó yu tsi un ―catyí ra. Tan juvin ñi tacan catyí tandɨhɨ ca ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tacan tan tsaa̱ ra Jesús tsihin ra tsicá tsihin ra iin nu iyó cuaha yutun nu nañí Getsemaní, tan catyí ra tsihin ra naha: ―Cu̱nyecu ndo ihya tsitsi tsa cuahán yu ndacan cua ndacan tahvi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tan quihi̱n ra tsi ra Pedro tan nduvi sehe ra Zebedeo cuahán tsihin ra. Tan quitsi̱ tucuiihya iñi cahnu tsi ra, tan tsa tuñu cuñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tacan tan catyí ra tsihin ra naha: ―Cahnu xaan tucuiihya iñi nyaá añima yu, nda cuanda cuñí cahñi ña can tsi yu. Ndo̱o ndo ihya tan co̱o nyito ndo tsihin yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tacan tan cuahán ra Jesús luxu ca ityi nuu tan tsicuɨñɨ̱ tsɨtɨ ra tan tsaqui̱n ra nuu ra nda nu ñuhu, tan tsicán tahvi ra tsi Nyoo tan catyí ra: ―Tyaa, tun tsatyin cuvi jatsiyo nyaha un tundoho ihya sɨquɨ yu, vaha xaan. Maa tyin na ña cuvi cuhva cuñí maa yu, tan na cuvi cuhva cuñí maa un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tacan tan tsaa̱ ra nu yucú ra tsicá tsihin ra, tan nyehe̱ ra tyin quixí ra naha. Tan catyí ra tsihin ra Pedro: ―¿A ña cuví coo nyito ndo tsihin yu vasu tan intuhun hora? ");
INSERT INTO mjcNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Co̱o nyito ndo, tan nda̱can tahvi ndo tsi Nyoo; tacan tan ña cua javaha ndo cuhva cuñí nu ña vaha. Tsa nditsa tyin añima ndo, cuñí xaan tsi nanducu tsi tsi Nyoo, maa tyin cuñu ñuhu ndo cuví tsa vita cuñí ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tan tsa tsaha̱n ra tsa tsinu uvi tsaha, tsica̱n tahvi ra tyehen: ―Tyaa, tatun ña cuvi tsa jatsiyo nyaha un tundoho ihya sɨquɨ yu, na cuvi cuhva cuñí maa un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tacan tan tsaa̱ ra inga tsaha tan nyehe̱ ra tyin quixí nyico ra tsicá tsihin ra, tyin tsicundasɨ̱ maa tinuu ra naha tsihin tsa cuñí xaan ra naha cusu ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tacan tan nacoo̱ ra tsi ra naha, tan cuahán ra tsa tsinu uñi tsaha cua ndacan tahvi ra. Tan tsica̱n tahvi ra tsi Nyoo juvin ñi maa tsihin tuhun tsa tsa yaha̱ caha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tacan tan tsaa̱ nyico ra nu yucú ra tsicá tsihin ra, tan catyí ra tsihin ra naha: ―Vityin cu̱su ndo tan qu̱itatu ndo. Tyin tsa tsaa̱ cuhva tsa cua nacuhva cuenda ra can tsi Rayɨɨ tsa quee̱ nda gloria tsi ra iyó cuatyi naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ndu̱vita ndo, co̱hon ndo. Tyin tsa vatsí ra tsa xico̱ tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ndi caahán ca ra Jesús yacan, tan tsaa̱ ra Judas, ra tsa cuví iin ra tsicá tsihin ra Jesús. Tan tsihin ra Judas tsaa̱ tucu cuaha xaan nyɨvɨ ndahá mityi tan yutun jacuhu̱n ra cuví jutu tsa cuví ityi nuu naha ra tan ra cuví mandoñi nyɨvɨ Israel naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tan ra Judas, ra tsa tsahá cuenda tsi ra Jesús, tsa yaha̱ tsaha̱ ra iin seña tsi ra can naha ra, tyin coto ra naha yóo cua tɨɨn ra naha. Tyin tsa yaha̱ caha̱n ra tsihin ra naha: ―Ra tsa cua tyayuhu yu, ra ican cuví ra tsa cua tɨɨn ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tacan tan natuhva̱ ra Judas nu nyaá ra Jesús tan catyí ra: ―Nacumi tsi un, Maestro. Tan tyayuhu̱ ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tacan tan nacaha̱n ra Jesús tan catyí ra tsihin ra: ―¿Náa tyiñu vatsí un ñih? Tacan tan natuhva̱ ra can naha ra tan tɨɨ̱n ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tacan tan iin ra cutahán tsihin ra Jesús, tava̱ ra mityi tan tsahnya̱ ra soho musu jutu tsaahnu tsa cuví ityi nuu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tan catyí ra Jesús tsihin ra: ―Na̱tyihi mityi un tsitsi vena un. Tyin tandɨhɨ nyɨvɨ tsa cañí tahan tsihin mityi, juvin ñi tsihin mityi cua cúu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿A ña tsitó un tyin tatun yuhu tan cuñí yu, cuví ndacan yu tsi Jutu yu, tan maa ra cua jaquitsi ra vityin vityin yaha ca uñi xico utsi mil ángel, tan jacacu ra naha tsi yu? ");
INSERT INTO mjcNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Maa tyin tatun tacan javaha yu, ¿nácaa cua cundaa tsa nyaá nu tutu Nyoo nu catyí tsi tyin taahán maa tsi tsa tahan yu tyehen? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tacan tan catyí ra Jesús tsihin tandɨhɨ nyɨvɨ: ―¿A vatsí tɨɨ́n ndo tsi yu tumaa cua tɨɨn ndo iin ñasuhu? tyin ndahá ndo mityi tan yutun. Tandɨhɨ quɨvɨ tsinyii̱ yu jacuaha̱ yu tsi ndo tsitsi vehe ñuhu cahnu, tan ña tɨɨ̱n ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tandɨhɨ yacan cuví tyin tacan tan cundaa cuhva catyí tuhun Nyoo, tsa tyaa̱ ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Tacan tan tandɨhɨ ra tsicá tsihin ra, tsinu̱ ra naha. Tan ndoo̱ intuhun ña maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tan ra tsa tɨɨ̱n tsi ra Jesús, tsindaca̱ ra naha tsi ra nuu ra Caifás, ra jutu tsaahnu tsa cuví ityi nuu. Tan iin cahnu ñi yucú ra maestro cuenda ley vehe ñuhu naha ra ican tan ra mandoñi naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tan ra Pedro cuahán ra tsata ra naha, tan tsaa̱ ra nda nuquehe vehe ra Caifás can. Tan quɨhvɨ̱ ra tan ndoo̱ ra nyií ra tsihin vitya can naha ra, tyin cua nyehe ra nácaa cua quita tuhun can. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ra jutu tsa cuví ityi nuu naha ra, tan ra mandoñi naha ra, tan tandɨhɨ ra cumí tyiñu naha ra, nducu̱ ra naha tsi ra cahan cuendu sɨquɨ ra Jesús. Tyin tacan tan cuvi cahñi ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Maa tyin ña ñihi̱ maa ra naha cuatyi tyaa ra naha sɨquɨ ra, vasu ndi maa cuaha nyɨvɨ tsaha̱n ñi tsicaha̱n ñi cuendu sɨquɨ ra. Tan nu ndɨhɨ tuhun, tsaa̱ uvi ca tsa ndaa tsa caahán cuendu. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tan catyí ra naha: ―Ra ihya, catyi̱ ra tyin cuví canɨ ra vehe ñuhu cahnu Nyoo, tan tsitsi tsa uñi quɨvɨ cua janduvita ra tsi inga tsaha ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tacan tan ra jutu tsa cuví ityi nuu can, nduvita̱ ra, tan catyí ra tsihin ra Jesús: ―¿A ña nacahan un nu caahán ra ihya naha ra? ¿A nditsa tsa caahán ra ihya naha ra, o ña nditsa? ");
INSERT INTO mjcNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Maa tyin ra Jesús ña nacaha̱n ra. Tacan tan catyí ra jutu tsaahnu tsa cuví ityi nuu tsihin ra: ―Tsihin sɨvɨ Nyoo nyitó, catyí yu tsihin un tyin ca̱tyi un tsa nditsa vaha. ¿A ra Cristo Sehe Nyoo cuví tsi un? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tan catyí ra Jesús tsihin ra: ―Juvin yu cuví. Tan catyí tucu yu tsihin ndo, tyin cua nyehe ndo tsi yuhu, Rayɨɨ tsa quee̱ nda gloria, cunyaa yu xiin cuaha Nyoo ra iyó tandɨhɨ tunyee iñi, tan cua nyehe ndo nu cua quitsi yu nu vico ityi andɨvɨ inga tsaha ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tacan tan ra jutu tsaahnu tsa cuví ityi nuu can tsahnya̱ ra jahma ra tumaa iin seña tyin cuñí maa ra tyin ña vaha tsa caahán ra Jesús, tan catyí ra tsihin tandɨhɨ ca ra naha: ―Ra ihya tsicoo̱ cuatyi ra nuu Nyoo tsihin tsa caahán ra. ¡Nye̱he ndo vityin! Ña cuñí ca tsi tsa nducu yo inga tsa ndaa tyin tsa tsiñi̱ maa ndo tsa ña vaha tsa caha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Náa catyí ndo vityin? Tan nacaha̱n ra naha tan catyí ra naha: ―Iyó cuatyi ra, yacan taahán tsi tsa cúu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tacan tan tɨvɨ̱ sɨɨ ra naha nuu ra tan cañi̱ ra naha tsi ra. Inga ra cañi̱ ra naha nuu ra tsihin tsɨquɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tan catyí ra naha tsihin ra: ―Tatun nditsa tyin ra Cristo cuví un, ¡na̱coto yóo cañi̱ tsi un! ");
INSERT INTO mjcNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tsitsi tsa ndi nyií ra Pedro nuquehe ityi tsata vehe can, tan iin ñaha tsa cuví musu jutu can, natuhva̱ ña nu nyaá ra tan catyí ña tsihin ra: ―Yooho tucu tsica̱ un tsihin ra Jesús, ra Galilea can. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tan ra Pedro catyí ra nuu tandɨhɨ nyɨvɨ yucú can: ―Ña tsica̱ yu tsihin ra can. Ña tsitó yu náa caahán un. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tacan tan cuahán ra Pedro ityi yuvehe nu cuví yuhu cora, tan nyehe̱ inga ña tsi ra, tan catyí ña tsihin ra yucú can: ―Juvin ñi tsica̱ ndɨhɨ tucu ra ihya tsihin ra Jesús, ra ñuu Nazaret ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tan inga tsaha tyihi̱ xeehe̱ ra Pedro tsa nacotó ra tsi ra tan catyí ra: ―Naha Nyoo tyin ña nacotó yu tsi ra can. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tañi cuii ca, tan ra yucú can natuhva̱ ra naha nu nyaá ra Pedro tan catyí ra naha tsihin ra: ―Nditsa tyin ra vaha iñi tsi ra can cuví yooho, tyin cuhva caahán ra Galilea naha ra, caahán un. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tacan tan iyo xaan caahán ra tan catyí ra: ―Tsitó vaha Nyoo tyin ña nacotó yu tsi ra can, tan na cahñi maa Nyoo tsi yu tatun ña nditsa tsa caahán yu ―catyí ra. Tan juvin ñi cuhva can navacu̱ tsitooho. ");
INSERT INTO mjcNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tacan tan nducuhu̱n iñi ra Pedro tsa caha̱n ra Jesús tsihin ra: “Tsa ndi cumañi ca vacu tsitooho, yooho tsa yaha̱ caha̱n un uñi tsaha tyin ña nacotó un tsi yu”, catyi̱ ra Jesús, nducuhu̱n iñi ra. Tacan tan quita̱ ra ican, tan tsacu̱ xaan ra tsa cuiihya cuñí ra tsa javaha̱ ra tacan. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tan tsa tuvi̱ inga quɨvɨ, tandɨhɨ ra jutu tsa cuví ityi nuu naha ra tan ra mandoñi ñuu can naha ra, ndoo̱ ra naha tyiñu tsa cua cahñi ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tan nuuhñí ra jaha̱ ra naha. Tan tsaha̱n ra naha tsinacuhva̱ cuenda ra naha tsi ra nuu ra Poncio Pilato, ra ndacá ñaha tsa quee̱ nda ñuu Roma. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tsa nyehe̱ ra Judas, ra tsa xico̱ tsi ra Jesús, tyin cua cúu ra, tan ndu uvi̱ iñi ra tsa javaha̱ ra, tan nacuhva̱ ra tsa oco utsi xuhun cuitsin can tsi ra jutu tsa cuví ityi nuu naha ra, tan tsi ra mandoñi ñuu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tan catyí ra: ―Tsicoo̱ cuatyi yu, tyin tsaha̱ cuenda yu tsi iin ra nduve cuatyi na cúu ra. Tan nacaha̱n ra naha tan catyí ra naha: ―¿Nacuenda nyuhu? ¡Nye̱he maa yooho! ");
INSERT INTO mjcNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tacan tan tyoso̱ ihñi ra Judas xuhun can tsitsi vehe ñuhu cahnu, tan quita̱ ra cuahán ra tsityihi̱ ra yoho jucun ra tan ticaa̱ ra tsi ra iin nu yutun, tan tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ra cuví ityi nuu tsihin jutu can naha ra naquihi̱n ra naha xuhun can tan catyí ra naha: ―Ña cuví tyihi yo xuhun ihya tsitsi caja nu yɨhɨ́ xuhun tsa tsahá nyɨvɨ tsi Nyoo tyin xuhun tsa cuyahvi̱ ra tsa cua catɨ nɨñɨ cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tacan tan ndoo̱ ra naha tyiñu, tyin cua jata ra naha ñuhu tsa nañí “Ñuhu Ra Javahá Quɨsɨ” tsihin xuhun can. Tyin coo nu cucutsi ra naha tsi nyɨvɨ inga ñuu tun tsiihí ñi ñuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yacan cuenda nañí ñuhu can nda cuanda vityin “Ñuhu Cuenda Tsa Tsatɨ̱ Nɨñɨ Nyɨvɨ”. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tacan cuvi̱ tyin cundaa̱ tsa tyaa̱ ra Jeremías, ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha nu catyí tsi tyehen: “Juvin ñi maa ra naha quihi̱n nyico tsa oco utsi xuhun cuitsin, tsa jata̱ ra naha tsi ra Cristo. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tan tsihin can, jata̱ ra naha ñuhu tsa nañí ‘Ñuhu Ra Javahá Quɨsɨ’, tacan catyi̱ Jutu Mañi yo tsihin yu”, catyí tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tsindaca̱ ra mandoñi can naha ra tsi ra Jesús nuu ra ndacá ñaha, tan ra can tsica̱ tuhun ra tsi ra, tan catyí ra: ―¿A yooho cuví rey cuenda nyɨvɨ Israel? Tan ra Jesús catyí ra tsihin ra: ―Juvin yu, tumaa cuhva catyí maa un. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tan cuhva tsa tyaa̱ ra jutu can naha ra tan ra mandoñi naha ra cuatyi sɨquɨ ra, ña nacaha̱n maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tacan tan catyí ra Pilato tsihin ra: ―¿A ña tsiñí un tandɨhɨ tsa caahán ra naha sɨquɨ un? ");
INSERT INTO mjcNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Maa tyin ra Jesús ña nacaha̱n maa ra. Tan iyo xaan cuñí ra ndacá ñaha can tyin ña nacaha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tan vico pascua tuhvá ra ndacá ñaha jañá intuhun ra yucú vehe caa. Ndáa ra tsa nacatsi maa nyɨvɨ, juvin ra cua quita nuña. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tan quɨvɨ can nyií iin ra tsa nañí Barrabás vehe caa. Tan tandɨhɨ nyɨvɨ tsitó tuhun ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tan cuhva tsa ndu ii̱n nyɨvɨ, ra Pilato tsica̱ tuhun ra tsi ñi, tan catyí ra: ―¿Ndáa ra cuñí ndo tsa tava nuña yu? ¿A ra Barrabás, o ra Jesús, ra tsa nañí Cristo? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tyin tsitó ra tyin tsa cuenda tsa ndasɨ cuñí ra jutu can naha ra nyehe ra naha tsi ra Jesús, yacan cuenda tsaha̱ cuenda ra naha tsi ra tsi ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tsitsi tsa nyaá ra Pilato nu tyayu ra, nu jahá tyiñu ra, jacuhu̱n ñasɨɨhɨ ra tyiñu tsi ra tan catyí ña: “Ña tyi̱hi un tsi un tsihin ra vaha can. Tyin cuñi nyehe̱ yu ñumaahna tsa cuenda ra. Tan jayuhvi̱ xaan tsi tsi yu”, catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Maa tyin ra jutu can naha ra tan ra mandoñi naha ra, cuñihi̱ ra naha natyuhú ra naha tsi nyɨvɨ na ndacan ñi tsa jaña ra Pilato tsi ra Barrabás, tan na cúu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tacan tan ra ndacá ñaha catyí ra tsihin ñi inga tsaha: ―Tsitsi tsa nduvi ra naha, ¿ndáa ra cuñí ndo tsa jaña yu? Tan nacaha̱n ñi, tan catyí ñi: ―Ja̱ña tsi ra Barrabás. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tan ra Pilato tsica̱ tuhun ra tsi ñi, tan catyí ra: ―¿Tan náa cua javaha yu tsihin ra Jesús tsa nañí Cristo ihya? Tandɨhɨ ñi nacaha̱n ñi tan catyí ñi: ―¡Tya̱a tsi ra nu cruu na cúu ra! ");
INSERT INTO mjcNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tacan tan catyí ra Pilato tsihin ñi: ―Tan ¿náa tsa ña vaha javaha̱ ra? Maa tyin maa ñi cana̱ tsaa ñi inga tsaha tan catyí ñi: ―¡Tya̱a tsi ra nu cruu na cúu ra! ");
INSERT INTO mjcNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tsa nyehe̱ ra Pilato tyin ña cuvi̱ jaha ra tsi nyɨvɨ, tyin ñihi xaan cuvaá jahá ñi. Tacan tan tsica̱n ra ndutya, tan nacatya̱ ra ndaha ra nuu nyɨvɨ can, tan catyí ra: ―Ña cua ndoo cuatyi tsa cua cúu ra vaha ihya sɨquɨ yuhu, tyin sɨquɨ nyooho cua ndoo cuatyi can. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tan tandɨhɨ nyɨvɨ nacaha̱n ñi, tan catyí ñi: ―Na ndoo maa tsi sɨquɨ ndi tan sɨquɨ sehe ndi. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tacan tan ra Pilato jaña̱ ra tsi ra Barrabás, tan tava̱ tyiñu ra na ndoho ra Jesús, tan nacuhva̱ cuenda ra tsi ra tsi ra andaru naha ra na cúu ra nu cruu. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tacan tan ra andaru cuenda ra Pilato, ra ndacá ñaha can tsindaca̱ ra naha tsi ra Jesús nda vehe tyiñu ra Pilato, tan jandu ii̱n ra naha tsi tandɨhɨ ca andaru nu nyaá ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tacan tan tava̱ ra naha jahma ra tan jacunditsi̱ ra naha iin jahma cuaaha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tan tyihi̱ ra naha iin corona tsa tsinu̱ tsihin iñu jiñi ra. Tan tsaha̱ ra naha iin yutun tatun na cundaha ra tsihin ndaha cuaha ra. Tacan tan tsicuɨñɨ̱ tsɨtɨ ra naha nuu ra, tan tsacu̱ nducu ra naha tsi ra tan catyí ra naha: ―¡Nacumi tsi un, yooho Rey cuenda nyɨvɨ Israel! ");
INSERT INTO mjcNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tan tɨvɨ̱ sɨɨ ra naha tsi ra. Tan quihi̱n ra naha yutun tatun can tan cañi̱ ra naha jiñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tsa yaha̱ tsa tsacu̱ nducu ra naha tsi ra tan tava̱ ra naha jahma cuaaha tsa nditsí ra, tan jacunditsi̱ nyico ra naha jahma maa ra tsi ra. Tacan tan cuahán ra naha tsihin ra cua cahñi ra naha tsi ra nu cruu. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tsa quita̱ ra naha ican, taha̱n ra naha tsi iin ra ñuu Cirene, tsa nañí Simón. Tan jañiñi̱ ra naha tsi ra na cuiso ra cruu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tan tsaa̱ ra naha iin nu nañí Gólgota, tan cuñí tsi catyí “Yɨquɨ Jiñi Ndɨyɨ”. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tan ican tsaha̱ ra naha vinu nasaca̱ tsihin ndutya uva xaan coho ra Jesús. Tan tsa yaha̱ tsa tsihi̱ ra luxu can, ña cuñí ca ra coho ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tan tsa yaha̱ tsa tyaa̱ ra naha tsi ra nu cruu, tacan tan ra andaru can quihi̱n ra naha jahma ra tan tava̱ cuenda ra naha tyin cua nyehe ra naha ndáa ra jaha canaa intuhun intuhun jahma ra. Tacan cuvi̱ tyin cundaa̱ tuhun tsa tyaa̱ iin ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha nu catyí tsi tyehen: “Tava̱ cuenda ra naha tan tsatsa̱ ra naha jahma yu”, catyí tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tacan tan tsinyecu̱ ra naha ican tyin jaha cuenda ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tan ityi jiñi ra tyaa̱ ra naha letra tsa catyí nacuenda cua cúu ra. Tan catyí tsi tyehen: “Ra ihya cuví ra Jesús, rey cuenda nyɨvɨ ñuu Israel.” ");
INSERT INTO mjcNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tan tyaa̱ tucu ra naha uvi taahan ra suhu tsihin ra nu uvi taahan ca cruu. Iin ra tyaa̱ ra naha xiin cuaha ra, tan inga ra xiin satyin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tan nyɨvɨ tsa yahá ican, caahán ñi tsi ra, tan javicó ñi jiñi ñi tsa tsacú nducu ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tan catyí ñi tsihin ra: ―¡Yooho tsa caha̱n un tyin cua canɨ un vehe ñuhu cahnu, tan tsitsi tsa uñi quɨvɨ tan cua janduvaha nyico un itsi, ja̱cacu tsi maa un vityin nu cruu juvin, tatun nditsa tyin Sehe Nyoo cuví tsi un! ―catyí ñi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tan juvin ñi tacan tsacú nducu ra jutu tsa cuví ityi nuu naha ra tsi ra, tan ra maestro cuenda ley vehe ñuhu naha ra tan ra fariseo naha ra, tan ra mandoñi ñuu naha ra. Tan natuhún tahan ra naha tan catyí ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Jacacu̱ ra tsi inga nyɨvɨ, maa tyin ña cuví jacacu ra tsi maa ra. Tun nditsa tyin Rey cuenda nyɨvɨ Israel cuví ra, na nuu ra nu cruu can, tan cua tsinu iñi yo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nditá xaan iñi ra tsi Nyoo, vityin na jacacu Nyoo tsi ra, tatun nditsa tyin cuñí ra tsi ra. Tyin catyi̱ ra tsihin yo tyin Sehe Nyoo cuví tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tan nda cuanda nu ñasuhu nahnu tsa nyaá nu cruu xiin ra tan tsacu̱ nducu ndɨhɨ nahnu tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tacan tan ndunaa̱ tanɨɨ cahnu ñuhu ñayɨvɨ tsa ora tan nda cuanda caa uñi tsa tseñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tan juvin ñi cuhva can, ñihi xaan cana̱ tsaa ra Jesús. Tan catyí ra: ―Elí, Elí, ¿lama sabactani? ―tan cuñí tsi catyí: Nyoo Jutu yu, Nyoo Jutu yu, ¿nacuenda nacoo̱ ihñi un tsi yu? ");
INSERT INTO mjcNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Juhva ra yucú can naha ra, tsiñi̱ ra naha tsa caha̱n ra, tan catyí ra naha: ―Ra Elías, ra cuvi̱ ndusu yuhu Nyoo tsanaha, caná tsaa ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tan juvin ñi cuhva can, cuahán iin ra cua quihin ra iin yahma cuhva caá catyi, tan jatyii̱ ra tsihin vinu iya, tan tyaa̱ ra nu yutun, tan jatuhva̱ ra yuhu ra Jesús tyin na coho ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Maa tyin inga ra naha catyí ra naha: ―Ña cu̱hva naha un can tsi ra; na nyehe jihna yo tatun cua quitsi jacacu ra Elías tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Inga tsaha cana̱ tsaa ñihi ra Jesús, tacan tan tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tan juvin ñi cuhva can ndata̱ sava jahma tsa ticaá tsitsi vehe ñuhu cahnu tyasɨ Nu Ii Xaan, nda cuanda ityi sɨquɨ tan nda cuanda ityi tsaha. Tan ñihi xaan taa̱n. Tan tahvi̱ cuatyi cava nahnu. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tan nuña̱ yuhu ñaña. Tan cuaha nyɨvɨ tsa tsinú iñi tsi Nyoo tan tsihi̱ ñi, nandoto̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tan tsa yaha̱ nandoto̱ ra Jesús quita̱ ñi nu ñaña tan quɨhvɨ̱ ñi tsitsi ñuu Jerusalén, tan cuaha nyɨvɨ nyehe̱ tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tacan tan ra capitán tan ra andaru tsa jahá cuenda tsi ra Jesús, nayuhvi̱ xaan ra naha tsa taa̱n, tan tsa nyehe̱ ra naha inga ca tsa cuvi̱. Tan catyí ra naha: ―Nditsa nditsa cuii, tyin Sehe Nyoo cuví tsi ra ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Cuaha ñiñaha tsa tsinyicu̱n tsi ra Jesús nda Galilea tan jatyinyee̱ ñi tsi ra, yucú ñi nyehé ñi ndasava. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tan juhva ñi ican cuví ñi ihya: ña María tsa quee̱ Magdala, tan ña María sɨhɨ ra Jacobo tan ra José, tan ñasɨɨhɨ ra Zebedeo. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cuhva tsa cuñí cuaa, quitsi̱ iin ra cuca tsa nañí José, ra ñuu Arimatea. Tan tsinú iñi ra tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tan tsaha̱n ra tsicaha̱n ra tsihin ra Pilato, tan tsica̱n ra cuñu ñuhu ra Jesús. Tacan tan tava̱ tyiñu ra Pilato na cuhva ra andaru naha ra cuñu ñuhu ra Jesús tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tacan tan quihi̱n ra José cuñu ñuhu ra, tan cava̱ nuu ra iin jahma cuitsin vaha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tan tyihi̱ ra cuñu ñuhu ra Jesús tsitsi iin ñaña tsaa tsa cuví iin yavi yuu tsa tava̱ tyiñu ra tsatya̱ ra naha. Tan tsa yaha̱ tsa nacasɨ̱ ra yuhu ñaña can tsihin iin yuu cahnu, tan cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tan ña María tsa quee̱ Magdala, tan inga ña María, ndoo̱ ñi yucú ñi yuhu ñaña can. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tan tsa inga quɨvɨ, quɨvɨ quitatú nyɨvɨ cuví can, tan ra jutu tsa cuví ityi nuu naha ra, tan ra fariseo naha ra tsaha̱n ra naha tsicaha̱n ra naha tsihin ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tan catyí ra naha tsihin ra: ―Yooho taa, nducuhu̱n iñi ndi tyin ra vatya can, catyi̱ ra taha̱n nyito ra tyin tsa yaha̱ tsa uñi quɨvɨ tsa cua cúu ra tan cua nandoto ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yacan cuenda ta̱va tyiñu na jaha cuenda vaha ra andaru naha ra ñaña can, nda yaha tsa uñi quɨvɨ, coto cuhun ra tsica̱ tsihin ra tsa tsacuaa, tan suhu ra naha cuñu ñuhu ra. Yaha can tan cua catyi ra naha tsihin nyɨvɨ tyin tsa nandoto̱ ra. Tatun tacan cua cuvi, yaha ca cuhva cua cuvi tan ñavin ca tsa jihna ñi ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tan ra Pilato catyí ra: ―Qu̱ihin ndo andaru ihya. Cu̱aahan ndo, tan ja̱ha cuenda vaha ndo ñaña can, nácaa cunyee maa ndo jaha cuenda ndo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tacan tan cuahán ra naha, tan jaha̱ cuenda vaha ra naha ñaña can, tan tyaa̱ ra naha iin tsa tyaa̱ ra naha tsata yuu tsa ndasɨ́ can tyin tatun nacanda yuu can coto ra naha. Tan nacoo̱ ra naha tsi ra andaru jahá cuenda ra naha ican. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tsa yaha̱ quɨvɨ tsa quitatú nyɨvɨ, cuhva tsa cuñí cunditsin, nu quitsaha̱ tsaha vitya, tan ña María tsa quee̱ Magdala can, tan inga ña María tsaha̱n ñi nu ñaña. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tan ñihi xaan taa̱n tyin quitsi̱ iin ángel Jutu Mañi yo quee̱ ra andɨvɨ, tan tsaa̱ ra nu ñaña can. Tan jatsiyo̱ ra yuu tsa ndasɨ́ yuhu can, tan tsicunyaa̱ ra tsata can. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tan xiñu xaan ra, tumaa tsa cañí tatsa. Tan cuitsin xaan jahma ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Cuhva tsa nyehe̱ ra andaru can naha ra tsi ra, nayuhvi̱ xaan ra naha tan quitsaha̱ nɨhɨ́ ra naha, tan nda cuanda tsihi̱ naaha ra naha tsihin tsa yuuhví ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tacan tan catyí ángel can tsihin ñiñaha can: ―Ña na̱yuhvi ndo. Yuhu tsitó yu tyin ra Jesús tsa tsihi̱ nu cruu nanducú ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yoñi ca ra nyií ihya, tyin tsa nandoto̱ ra, tumaa catyi̱ ra. Na̱ha ndo tan nye̱he ndo nu tinyii̱ ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ja̱numi xaan ndo cuhun ndo cucatyi tuhun ndo tsihin ra tsica̱ tsihin ra tyin tsa nandoto̱ ra, tan tsa cuahán ra nda Galilea, cua cuatu ra tsi ra naha ndacan. Yacan cuví tsa catyí tuhun yu tsihin ndo ―catyí ángel can tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tacan tan numi ñi quita̱ ñi nu ñaña can. Yuuhví ñi, tan sɨɨ xaan cuñí tucu ñi. Tan tsinú xaan ñi cuahán ñi cua catyi tuhun ñi tsihin ra tsica̱ tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tan cuhva can quituvi̱ ra Jesús nuu ñi tan tsaha̱ ra nacumi tsi ñi. Tacan tan natuhva̱ ñi nu nyaá ra tan tsicuɨñɨ̱ tsɨtɨ ñi nuu ra tan jacahnu̱ ñi tsi ra, tan tsicunumi̱ nyaa ñi tsaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tan catyí ra tsihin ñi: ―Ña na̱yuhvi ndo. Cu̱aahan ndo cujacoto ndo tsi yañi yu tyin na cuhun ra naha nda Galilea, tan ndacan cua ñihi tahan ndi ―catyí ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tsitsi tsa cuahán ñi can, juhva andaru tsa jaha̱ cuenda ican, cuahán ra naha nda ñuu, cua nacatyi tuhun ra naha tsa cuvi̱ can tsihin ra jutu tsa cuví ityi nuu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tacan tan ra jutu can naha ra tsaha̱n ra naha tsicaha̱n ra naha tsihin ra mandoñi ñuu naha ra na natuhun tahan ra naha nácaa cua javaha ra naha. Tacan tan cuaha xaan xuhun tsaha̱ ra naha tsi ra andaru can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tan catyí ra naha tsihin ra naha: ―Nyooho cua cahan ndo tyin tsa tsacuaa tsitsi tsa quixí ndo, tsaha̱n ra tsica̱ tsihin ra Jesús tan quihi̱n ra naha cuñu ñuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tan tatun cua coto ra ndacá ñaha tuhun ihya, cua nyehe maa ndi nácaa cua cahan ndi tsihin ra, tan nyooho ña caca iñi ndo. Nduve náa cua tahan ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tacan tan quihi̱n ra andaru can xuhun can, tan cuahán ra naha cuajavahá ra naha cuhva catyi̱ ra naha tsihin ra naha. Tan nda quɨvɨ vityin tan tacan caahán nyɨvɨ ñuu Israel. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tan tacan, tandɨhɨ tsa utsi iin ra tsica̱ tsihin ra, cuahán ra naha nda Galilea nda yucu nu catyi̱ maa ra Jesús tsihin ra naha tyin cuhun ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tan cuhva tsa nyehe̱ ra naha tsi ra Jesús, jacahnu̱ ra naha tsi ra, maa tyin juhva ra naha uvi ñi tsicá iñi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tacan tan natuhva̱ ra Jesús nu nyecú ra naha tan catyí ra tsihin ra naha: ―Nyoo tsaha̱ ra tsa cundaca ñaha yuhu tandɨhɨ andɨvɨ tan nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yacan cuenda, cu̱aahan ndo tandɨhɨ nu iyó nyɨvɨ, tandɨhɨ ñi ñuu, tan ca̱tyi ndo tsihin ñi na cunyicun ñi tsi yu. Tan ja̱coondutya ndo tsi ñi tsihin sɨvɨ Jutu yo Nyoo tan tsihin sɨvɨ yuhu Sehe ra, tan tsihin sɨvɨ Tatyi Ii ra. ");
INSERT INTO mjcNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tan ja̱cuaha ndo tsi ñi na tyaa yahvi ñi tandɨhɨ tsa catyi̱ yu tyin javaha ndo. Tan co̱to ndo tyin yuhu cunyaa yu tsihin ndo tandɨhɨ quɨvɨ nda cuanda naa ñayɨvɨ ―catyí ra Jesucristo tsihin ra tava̱ tyiñu ra. Tan na cuvi tsi tacan ñi.");
INSERT INTO mjcNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tyehen quitsaha̱ tuhun ra Jesucristo, Sehe Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tsanaha ra Isaías, ra cuvi̱ ndusu yuhu Nyoo, tyaa̱ ra nácaa cua quitsi ra Jesucristo, Sehe Nyoo. Tan catyí tsi tyehen: Cua jacuhun yu iin ra cua jacoto tsi nyɨvɨ na janduvaha ñi tsi ñi tsa ndi cumañi ca cuhun un nu yucú ñi, catyí Nyoo tsihin ra Cristo. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Cua tyaa soho yo ndusu ra nu cana tsaa ra nu tsɨquɨ, tan catyí ra: “Nu̱ña ndo iin ityi cuɨtɨ tan na̱tyiso vaha ndo tsi ndo tyin tsa vatsí Jutu Mañi yo”, catyí tuhun tsa tyaa̱ ra Isaías. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tacan cuvi̱; quitsi̱ ra Juan nu tsɨquɨ, tan javaha̱ ra cuhva tyaa̱ ra Isaías. Catyi̱ ra tsihin nyɨvɨ tyehen: “Ndu̱ uvi iñi ndo cuatyi ndo tan co̱ondutya ndo tyin tacan tan jaha Nyoo tucahnu iñi tsi ndo tsa cuenda cuatyi ndo.” ");
INSERT INTO mjcNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tan tandɨhɨ nyɨvɨ iyó ñuu tsa cayucú Judea tumaa ñuu Jerusalén tan inga ca ñuu tsaha̱n ñi tsityaa̱ soho ñi tuhun caahán ra Juan. Tsa tsiñi̱ ñi tsa caahán ra, ndu uvi̱ iñi ñi cuhva iyó ñi tan nahma̱ ñi cuatyi ñi nu Nyoo. Tacan tan tsicoondutya̱ ñi yutya Jordán. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tan jahma ra Juan tsinu̱ tsi tsihin ixi camellu. Tan cinturón ra cuví ñɨɨ. Tan maa ñi tica xama tsatsí ra, tan tsihí ra ndutya ñuñu tsa iyó tsitsi cuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Caahán ra tuhun Nyoo tsihin nyɨvɨ tan catyí ra: ―Tsa yatyin cuii quitsi ra tsa cahnu ca cuví tan ñavin ca yuhu. Tan ndi ña taahán tsi tsi yu tsa ndatsi yu ñɨɨ nditsan ra, tyin cahnu ca cuví maa ra tan ñavin ca yuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yuhu jacoondutyá yu tsi ndo tsihin ndutya ñi. Maa tyin maa ra cua jacoondutya ra tsi ndo tsihin Tatyi Ii Nyoo ―catyí ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Quɨvɨ can quita̱ ra Jesús ñuu Nazaret, tsa canyií Galilea, tan cuahán ra nu nyií ra Juan yutya Jordán tyin jacoondutya ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tsa quita̱ ra Jesús tsitsi ndutya tsa yaha̱ tsicoondutya̱ ra, nuña̱ andɨvɨ tan nyehe̱ ra vatsí nuú Tatyi Ii Nyoo sɨquɨ ra tan caá tsi tumaa caá iin paloma. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tan nacaha̱n iin ndusu ityi andɨvɨ tan catyí tsi tsihin ra tyehen: ―Yooho cuví Sehe yu tan cuñí xaan yu tsi un. Tan sɨɨ xaan cuñí yu nyehé yu tsi un ―catyí ndusu can. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tsa yaha̱ tsa tsicoondutya̱ ra Jesús tan tsindaca̱ Tatyi Ii Nyoo tsi ra nu tsɨquɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tan tsinyii̱ ra ican uvi xico quɨvɨ nu nduve nyɨvɨ iyó, maa ñi quɨtɨ xaan iyó. Tan nducu̱ cuhva nu ña vaha tsi ra. Yaha̱ can tan tsaa̱ ángel Nyoo tan jatyinyee̱ ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tsa yaha̱ tsa tyihi̱ nyɨvɨ tsi ra Juan vehe caa, tan tsinuhu̱ ra Jesús Galilea tan caahán ra tsihin nyɨvɨ nácaa ndacá ñaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tan catyí ra: ―Tsa tsaa̱ quɨvɨ tsa cua cundaca ñaha Nyoo tsi nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya. Yacan cuenda ndu̱ uvi iñi ndo cuatyi ndo, tan tsi̱nu iñi ndo tuhun tsa jacacú Nyoo tsi nyɨvɨ ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iin quɨvɨ cuahán ra Jesús tsicá ra yuhu miñi tsa nañí Ndutya Ñuhu Galilea. Tan nyehe̱ ra tsi ra Simón tan ra Andrés, yañi ra Simón, cañí ra naha traya ra naha nu ndutya, tyin ra tɨɨ́n tyaca cuví ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tan catyí ra Jesús tsihin ra naha: ―Na̱ha ndo, qu̱itsi nyicun ndo tsi yu, tan yuhu cua jatyinyee yu tsi ndo tyin tumaa tsa tɨɨ́n ndo tyaca ihya, tacan cua ñihi ndo nyɨvɨ cua cuvi nyɨvɨ Nyoo ―catyí ra Jesús tsihin ra Simón tan tsihin ra Andrés. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Juvin ñi cuhva can tan nacoo̱ ra naha traya can, tan cuahán ra naha cuanyicún ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ña cuaha ñi tsica̱ ra naha, tan nyehe̱ ra Jesús tsi uvi taahan sehe ra Zebedeo, ra Jacobo tan ra Juan. Yucú ra naha tsitsi iin yutun ndoo naquicú ra naha traya. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Cana̱ ra tsi nduvi taahan ra naha. Tan nacoo̱ ra naha tsi ra Zebedeo, jutu ra naha, tsitsi yutun ndoo can tsihin ra cuví musu ra naha. Tan cuahán ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tsa tsaa̱ ra Jesús ñuu Capernaum tsihin ra tsicá tsihin ra, quɨhvɨ̱ ra Jesús tsitsi vehe ñuhu quɨvɨ quitatú nyɨvɨ. Tacan tan quitsaha̱ jacuahá ra tuhun Nyoo tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tan iyo xaan cuñí ñi tsa tsiñí ñi tsa caahán ra, tyin jacuahá ra tumaa iin ra iyó vaha ndatu. Ña caahán ra cuhva caahán ra maestro cuenda ley vehe ñuhu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tan tsitsi vehe ñuhu can nyií iin ra yɨhɨ́ tatyi ña vaha. Tan cana̱ tsaa ra tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Nacuvi tyihí un tsi un tsihin nyuhu, yooho Jesús, ra ñuu Nazaret? ¿A vatsí un vatsí janaa un tsi ndi? Yuhu nacotó vaha yu tsi un, tan tsitó yu tyin Sehe Ii Nyoo cuví un ―catyí ra can tsihin ra Jesús jaha̱ nu tatyi ña vaha can. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tacan tan nduxaa̱n ra Jesús tsi nu tan catyí ra tsihin nu: ―¡Ña ca̱han ca un! ¡Qu̱ita tsi ra ihya! ―catyí ra tsihin nu. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tacan tan quitsaha̱ nɨhɨ rayɨɨ can jaha̱ nu. Tan ñihi xaan cana̱ tsaa ra jaha̱ nu, tan quita̱ nu tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tandɨhɨ nyɨvɨ iyo xaan cuñí ñi tan tsicá tuhun tahan ñi tsi ñi, tan catyí ñi: ―¿Náa cuví tsa nyehé yo ihya? ¿Náa tuhun tsaa jacuahá ra ihya? ¡Tyin iyó vaha tunyee iñi tsi ra, nda cuanda tatyi ña vaha tan tyaá yahvi tsi ra! ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tan numi ñi tsito̱ nyɨvɨ iyó tandɨhɨ ñuu tsa cayucú Galilea tuhun ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tsa ndɨhɨ̱ jacuaha̱ ra Jesús tsi nyɨvɨ tsitsi vehe ñuhu, quita̱ ra cuahán ra vehe ra Simón tan ra Andrés. Tan cuahán ndɨhɨ ra Jacobo tan ra Juan tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tan ña tyiso ra Simón cuuhví ña tsihin cahñi canyií ña nu tsito. Tan catyí tuhun nyɨvɨ ña tsihin ra Jesús tyin cuuhví ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tacan tan natuhva̱ ra Jesús yuhu tsito nu canyií ña, tɨɨ̱n ra ndaha ña, tan cañihi̱ ra tsi ña. Juvin ñi cuhva can, quita̱ cahñi tsi ña, tan quitsaha̱ nanducú ña tsa catsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tsa tsa cuñí cuaa tsa tsa yaha̱ tyiso̱ ñicanyii, tandɨhɨ nyɨvɨ cuuhví tan nyɨvɨ yɨhɨ́ tatyi ña vaha tsindaca̱ nyɨvɨ tsi ñi nu nyií ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tan ndu ii̱n tandɨhɨ nyɨvɨ ñuu can nu yucú ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tan janduvaha̱ ra tsi tandɨhɨ ñi tsa yɨhɨ́ sɨɨn sɨɨn cuehe, tan cuaha tatyi ña vaha tava̱ ra. Maa tyin ña tsaha̱ ra tsa cahan tatyi ña vaha can, tyin tsitó nahnu yóo ra cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ra Jesús nduvita̱ ra tsa ndi naa ca inga quɨvɨ, quita̱ ra ñuu can tan cuahán ra iin nu taxin caá cuandacán tahvi ra tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tsa nyehe̱ ra Simón tyin nduve ra, tacan tan cuahán ra tsihin tandɨhɨ ca ra naha cuananducú ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tan tsa nañihi̱ ra naha tsi ra, catyí ra naha tsihin ra: ―Tandɨhɨ nyɨvɨ tan nanducú ñi tsi un ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Maa tyin catyí ra tsihin ra naha: ―Co̱hon ndo ñuu tsa cayucú yatyin ñi ihya, tyin cuñí tsi cahan ndɨhɨ yu tuhun Nyoo ican, tyin yacan tyiñu vatsí yu ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tan tacan tsica̱ ra Jesús caahán ra tuhun Nyoo tsihin nyɨvɨ tsitsi vehe ñuhu tan iin tan iin ñuu tsa cayucú Galilea. Tan tava̱ ra tatyi ña vaha tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tsa ndi cuahán ra Jesús tsicá ra tan quita̱ iin ra ndohó cuehe tyaahyú tsicuɨñɨ̱ tsɨtɨ ra nuu ra, tan catyí ra tsihin ra: ―Tun yooho tan cuñí un, cuví janduvaha un tsi yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tan cundaahvi̱ iñi ra Jesús nyehe̱ ra tsi ra, tan tyiso̱ ndaha ra jiñi ra, tan catyí ra tsihin ra: ―Cuñí yu janduvaha yu tsi un. Tan vityin tsa nduvaha̱ un ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tsa caha̱n ra Jesús tacan tsihin ra, juvin ñi cuhva can tan nduvaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tacan tan catyí ra Jesús tyin tsa cuvi cunuhu ra, maa tyin caha̱n vaha xaan ra tsihin ra na javaha ra tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Coto ca̱tyi tuhun un tsihin nyɨvɨ yóo janduvaha̱ tsi un. Maa tyin cu̱aahan nu nyaá ra cuví jutu, tan ja̱naha un tsi un tsi ra. Tan cu̱hva tsa catyi̱ ra Moisés tyin cuhva ndo tsa cuenda tsa nduvaha̱ ndo tun cuhvi̱ ndo. Yacan cua cuvi tsa ndaa tsi ra jutu tan tsi nyɨvɨ tyin tsa nduvaha̱ un ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Maa tyin ra ican cuahán ra, tan quitsaha̱ catyí tuhun ra tsihin tandɨhɨ nyɨvɨ nácaa nduvaha̱ ra. Yacan cuenda ña cuvi̱ ca quɨhvɨ nditsin ra Jesús tsitsi ndi intuhun maa ñuu. Tan tsicá ra ityi tsata ñuu ñi nu nduve nyɨvɨ iyó, maa tyin tandɨhɨ ñi ityi tan quita̱ nyɨvɨ, tan tsinyehe̱ ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tsa yaha̱ juhva quɨvɨ tan cuahán ra Jesús ñuu Capernaum inga tsaha. Tan tsa tsito̱ nyɨvɨ tyin tsaa̱ nuhu ra yuvehe ra, ");
INSERT INTO mjcNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","iin yaha ñi ndu cuaha ñi yuvehe ra tan ña tsitaha̱n maa ñi tsitsi vehe tan ndi yuvehe. Tan caahán ra tuhun Nyoo tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tacan tan tsaa̱ cumi taahan rayɨɨ nyisó ra naha iin ra xii. Cuñí ra naha cuhun ra naha tsihin ra nda nu nyaá ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Maa tyin ña cuvi̱ yaha ra naha yuvehe tan cuhun ra naha nu nyaá ra Jesús tyin cuaha xaan nyɨvɨ nyecú yuvehe can. Yacan cuenda ndaa̱ ra naha jiñi vehe, tan jatsiyo̱ ra naha juhva tyiyo ndɨhɨ cuhva nu nyaá ñi ra Jesús. Tacan tan januu̱ ra naha tsi ra cuuhví can nu nyaá ra Jesús tsihin iin tsito. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tsa nyehe̱ ra Jesús tyin tsinú xaan iñi ra can naha ra, catyí ra tsihin ra cuuhví can: ―Vityin, tsa jaha̱ yu tucahnu iñi tsi un tsa cuenda tandɨhɨ cuatyi un ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tan nyecú juhva ra cuví maestro cuenda ley vehe ñuhu naha ra ican, tacan tan quitsaha̱ tsicá iñi ra naha tuhun ihya: ");
INSERT INTO mjcNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nacuenda tyin caná iñi ra ihya caahán ra tyehen? Tan intuhun ñi maa Nyoo cuví ra jahá tucahnu iñi tsi yo. Tsicoo̱ cuatyi ra nuu Nyoo tsa cuenda tsa caahán ra tacan”, cuñí ra naha, tsicá iñi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Maa tyin ra Jesús iin yaha ñi tuvi̱ iñi ra cuhva tsicá iñi ra naha. Tan catyí ra tsihin ra naha: ―¿Nacuenda tsicá iñi ndo tacan? ");
INSERT INTO mjcNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Náa yɨɨ ca cahan yo; “Cuatyi un tsa yaha̱ ndatsi̱”, o catyi yo: “Ndu̱vita, na̱quihin tsito un tan ca̱ca”? ");
INSERT INTO mjcNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vaha. Cua janaha yu tsi ndo tyin yuhu, tsa cuví yu Rayɨɨ quee̱ nda gloria, iyó ndatu tsi yu nu ñuhu ñayɨvɨ ihya tsa jaha yu tucahnu iñi tsi nyɨvɨ tsa cuenda cuatyi ñi ―catyí ra Jesús tsihin ra naha. Tacan tan nacaha̱n ra tsihin ra cuuhví can: ");
INSERT INTO mjcNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Catyí yu tsihin un; ndu̱vita, na̱quihin tsito un, tan cu̱anuhu yuvehe un ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tan iin yaha ñi nduvita̱ ra cuuhví can, naquihi̱n ra tsito ra, tan cuanuhu̱ ra. Tan iyo xaan cuñí tandɨhɨ maa nyɨvɨ tsa nyehe̱ can, tan quitsaha̱ jacahnú ñi tsi Nyoo, tan catyí ñi: ―Ndi iin tsaha maa tan ñaha ca nyehe yo tsehe ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsa yaha̱ yacan tan cuahán ra Jesús yuhu miñi inga tsaha. Tacan tan tsaa̱ cuaha nyɨvɨ nu nyií ra, tan quitsaha̱ jacuahá ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tsa ndɨhɨ̱ jacuaha̱ ra tsi ñi, tan cuanuhú ra. Tan tsa cuahán ra yaha̱ ra nu nyaá vehe nu tyahví nyɨvɨ xuhun cuenda ra ndacá ñaha ñuu Roma, tan ican nyaá ra Leví, sehe ra Alfeo, naquihín cuenda ra xuhun can. Nyehe̱ ra Jesús tsi ra, tan catyí ra tsihin ra: ―Co̱hon tsihin yu. Tacan tan nduvita̱ ra Leví, tan cuahán ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yaha̱ can tan cuahán ra Jesús cuacatsí ra yuvehe ra Leví tsihin ra tsicá tsihin ra. Tsinyaa̱ ra nu mesa tan tsinyecu̱ ndɨhɨ tucu ra tavá xuhun cuenda ra ndacá ñaha tan inga ca nyɨvɨ iyó cuatyi. Tyin cuaha xaan nyɨvɨ nyicún tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Maa tyin tsa nyehe̱ ra cuví maestro cuenda ley vehe ñuhu tan ra cuví fariseo naha ra tyin tsatsí ra Jesús tsihin ra tavá xuhun tan ra iyó cuatyi, catyí ra naha tsihin ra tsicá tsihin ra: ―¿Nacuenda tyin tsatsí tan tsihí ra maestro ndo tsihin ra tavá xuhun tan ra iyó cuatyi? ");
INSERT INTO mjcNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tsa tsiñi̱ ra Jesús tsa caha̱n ra naha tan catyí ra: ―Yuhu ña vatsí yu vatsí jatyinyee yu tsi nyɨvɨ cuñí tyin vaha iyó ñi; vatsí yu vatsí jatyinyee yu tsi nyɨvɨ tsitó tyin iyó cuatyi ñi tumaa nyɨvɨ cuuhví, tyin nyɨvɨ cuuhví tsiñí ñuhu doctor tsi ñi. Maa tyin nyɨvɨ vaha cuñí, ña tsiñí ñuhu doctor tsi ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Iin tsaha tsa iyó nyitya ra tsicá tsihin ra Juan tan ra tsicá tsihin ra fariseo naha ra, tsaha̱n juhva nyɨvɨ nu nyií ra Jesús, tan tsica̱ tuhun ñi tsi ra, tan catyí ñi: ―¿Nacuenda tyin tsicoó nyitya ra tsicá tsihin ra Juan tan ra tsicá tsihin ra fariseo naha ra, tan ra tsicá tsihin yooho ña tsicoó nyitya ra naha? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nacaha̱n ra Jesús tan catyí ra: ―¿A cuví coo nyitya nyɨvɨ yucú nu iyó vico tindaha tun ndi nyií ra cua tindaha tsihin ñi? Ña cuví coo nyitya ñi tun ndi nyií ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Maa tyin coo quɨvɨ ña cua cunyii ca ra tsihin ñi. Tacan tan cua coo nyitya ñi ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tan catyí ra Jesús: ―Ña tuhvá nyɨvɨ natyaá jahma tsaa iin jahma tuuhu, tyin jahma tsaa can cua nandɨyɨ can tan cua nducahnu ca nu ndata̱ jahma tuuhu can jaha can. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tacan tucu ñi ñɨɨ yɨhɨ́ vinu tun tyihí yo vinu tsaa tsitsi ñɨɨ tsaahnu cua ndata ñɨɨ can, tan cua catɨ vinu can tan cua tɨvɨ can. Yacan cuenda cuñí tsi tsa tyihi yo vinu tsaa tsitsi ñɨɨ tsaa ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Iin tsaha yaha̱ ra Jesús tsitsi tsa tatsi̱ nyɨvɨ tan cuví tsi quɨvɨ quitatú ñi. Tan tsa yaha̱ ra tsicá tsihin ra quitsaha̱ tuhún ra naha yoco trigu. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tacan tan tsa nyehe̱ ra fariseo naha ra can quitsaha̱ caahán ra naha tsihin ra Jesús: ―¡Nye̱he tsa javahá ra tsicá tsihin un naha ra! Jahá tyiñu ra naha tan ña taahán tsi jahá tyiñu yo quɨvɨ ihya ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tan nacaha̱n ra Jesús tsihin ra naha: ―¿A ñaha ca cahvi ndo nu tutu nu tsahá cuenda tsi tsa javaha̱ ra David tan ra cutahán tsihin ra quɨvɨ tsisoco̱ ra naha? ");
INSERT INTO mjcNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ra David quɨhvɨ̱ ra tsitsi vehe Nyoo quɨvɨ cuvi̱ ra Abiatar jutu tsaahnu cuví ityi nuu. Tan quihi̱n ra paan ii, tsa taahán tsi catsi maa ñi maa ra jutu naha ra. Maa ra tan tandɨhɨ ra cutahán tsihin ra tsatsi̱ ra naha paan can ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tacan tan catyí ra Jesús tsihin ra naha: ―Nyoo javaha̱ ra quɨvɨ quitatú yo tyin tacan tan cuví quitatu cuñu ñuhu yo; tan ñavin maa yo tsinu̱ tsa cuenda quɨvɨ quitatú yo. ");
INSERT INTO mjcNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yacan cuenda yuhu tsa cuví yu Rayɨɨ quee̱ nda gloria, iyó ndatu tsi yu tsa cahan yu tsihin intuhun intuhun ndo náa taahán tsi javaha ndo quɨvɨ quitatú yo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tsa quɨhvɨ̱ ra Jesús inga tsaha tsitsi vehe ñuhu, nyií iin ra na ityi iin ndaha ican. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tan ra cuví fariseo naha ra nducú cuhva ra naha tsi ra Jesús tan nducú ra naha cuhva nyehé ra naha tun cua janduvaha ra tsi ra na ityi ndaha can tyin cuví tsi quɨvɨ quitatú nyɨvɨ. Tyin tun cua janduvaha ra tsi ra can, tacan tan cua cuvi tyaa ra naha cuatyi sɨquɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tacan tan catyí ra Jesús tsihin ra na ityi ndaha can: ―Ndu̱vita nyityi tan cu̱nyaa un mahñu ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tacan tan tsica̱ tuhun ra tsi ra tsa yucú ican naha ra, tan catyí ra tsihin ra naha: ―¿Náa taahán tsi javaha yo quɨvɨ quitatú yo? ¿A taahán tsi javaha yo tsa vaha o tsa ña vaha? ¿A taahán tsi janduvaha yo nyɨvɨ, o cahñi yo tsi ñi? ―catyí ra Jesús. Maa tyin ña nacaha̱n ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tacan tan nanyehe̱ xaan ra Jesús nuu ra naha, tan nducuiihya̱ cuñí ra tyin ña cuñí ra naha cutuñi iñi ra naha. Tan catyí ra tsihin ra cuuhví can: ―Ja̱ndundoo ndaha un. Tacan tan jandundoo̱ ra can ndaha ra, tan iin yaha ñi nduvaha̱ ndaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tacan tan quita̱ ra fariseo naha ra, tan quitsaha̱ natuhún tahan ra naha tsihin ra yɨhɨ́ cuenda ra rey Herodes, nácaa cua cahñi ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Maa tyin ra Jesús tan ra tsicá tsihin ra cuahán ra naha yuhu miñi, tan cuaha nyɨvɨ iyó Galilea cuahán cuanyicún tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tsa tsito̱ nyɨvɨ tyin nahnu xaan tsa iyo javahá ra, cuaha ñi tsaha̱n nu nyií ra tyin cuñí ñi nyehe ñi tsi ra. Quee̱ ñi ñuu tsa cayucú Judea tumaa ñuu Jerusalén tan inga ca ñuu, tan ñuu tsa cayucú Idumea, tan ñuu tsa cayucú inga tsiyo yutya Jordán. Tan quee̱ tucu juhva ñi ñuu Tiro tan ñuu Sidón tan tandɨhɨ ca ñuu tsa cayucú yatyin nu cayucú nduvi ñuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tsa nyehe̱ ra Jesús tsaá nyɨvɨ, catyí ra tsihin ra tsicá tsihin ra na caquin nyaa vaha ra naha iin yutun ndoo tyin tun cua ndutuvi ca nyɨvɨ, cuvi quɨhvɨ ra tsitsi yutun ndoo can tyin tacan tan ña cua tindahñi ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tsa cuaha xaan nyɨvɨ janduvaha̱ ra, yacan cuenda tsaha̱n cuaha ca nyɨvɨ cuuhví nu nyií ra. Tsicá iñi maa ñi tyin tun nañí luxu ndaha ñi tsi ra tan cua nduvaha ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yɨhɨ ñi cuuhví can yɨhɨ́ tatyi ña vaha tsi ñi. Tan tsa natuhvá ñi tsa yɨhɨ́ tatyi ña vaha nu nyaá ra Jesús tsicuɨñɨ̱ tsɨtɨ ñi, tan nu tatyi ña vaha tsa yɨhɨ́ tsi ñi cana̱ tsaa nu tan catyí nu tsihin ra: ―¡Yooho cuví Sehe Nyoo! ");
INSERT INTO mjcNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tan tandɨhɨ ñi cuhva tsa caahán tatyi ña vaha yóo ra cuví ra, tyasɨ́ ra nu cahan nu. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsa yaha̱ yacan tan ndaa̱ ra Jesús iin yucu tan cana̱ ra tsi ra tsa cuñi̱ maa ra cana ra. Tacan tan cuahán ra naha nu nyií ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tan tsitsi tsa tandɨhɨ ra tsa cana̱ ra, nacatsi̱ ra utsi uvi ra naha tyin caca ra naha tsihin ra, tan caca ra naha cahan ra naha tuhun Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tan tsaha̱ ra ndatu tsi ra naha tsa janduvaha ra naha tsi nyɨvɨ cuuhví, tan tava ra naha tatyi ña vaha yɨhɨ́ tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ihya nyecú sɨvɨ ra naha: ra Simón, tsa jacunañi̱ tucu ra Jesús Pedro; ");
INSERT INTO mjcNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","tan nduvi sehe ra Zebedeo, ra Jacobo tan ra Juan. Juvin ra tsa jacunañi̱ ra Jesús Boanerges. Tan tuhun ihya cuñí tsi catyi: “ra caahán tumaa ñihi caahán savi”. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tan tandɨhɨ ca ra naha nañí ra naha tyehen: Andrés; Felipe; Bartolomé; Mateo; Tomás; tan ra Jacobo, sehe ra Alfeo; ra Tadeo; tan inga ra nañí tucu Simón, iin ra tsa cuñí cuhun cuatyi sɨquɨ ñuu Roma tsa ndacá ñaha tsi ñi; ");
INSERT INTO mjcNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tan ra Judas Iscariote, tsa xico̱ tsi ra Jesús. Tsa yaha̱ yacan tan cuahán ra Jesús tsitsi iin vehe tsihin ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tan nducuaha̱ nyɨvɨ nu yucú ra naha inga tsaha, tan nda cuanda ña cuyatyi ca ra naha catsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tsa tsito̱ nyɨvɨ ra Jesús tyin nyií ra ican, tsaha̱n ñi tsiquihi̱n ñi tsi ra tyin cunuhu ra tsihin ñi, tyin catyí nyɨvɨ tsihin ñi tyin ndusaná iñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Juhva ra maestro cuenda ley vehe ñuhu naha ra quee̱ ra naha nda ñuu Jerusalén tan tsaa̱ ra naha nu nyií ra Jesús tan catyí ra naha: ―Ra ihya tavá ra tatyi ña vaha tsi nyɨvɨ tsihin tunyee iñi nu Beelzebú, tsa cuví ityi nuu tsihin tandɨhɨ tatyi ña vaha ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsa tuvi̱ iñi ra Jesús tyin tacan caahán ra naha, cana̱ ra tsi ra naha tan tsaha̱ ra iin cuhva tsi ra naha, tan catyí ra tsihin ra naha: ―¿A cuví tavá nu ña vaha juvin ñi maa tahan nu? Ña cuví. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tyin tun ra ndacá ñaha naha ra tan cua natahvi sava ra naha, tan cua quitsaha cañi tahan ra naha, cua cundɨhɨ tsa ndacá ñaha ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tacan tucu ñi tun nyɨvɨ iyó iin caa ñi iin vehe tan cañi tahan ñi, cua cusɨɨn ñi tan ña cua cuvi coo vaha ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tan tun nu ña vaha tan ndusɨɨn nu tan nduvita iin nu sɨquɨ inga nu, ¿náa cua tahan nahnu? Cua ndusɨɨn nahnu tan cua cundɨhɨ nahnu. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Yoñi cuví quɨhvɨ tsitsi vehe iin ra xaan tan suhu ra tsa iyó tsi ra, tun ña cuhñi jihna ra tsi ra. Maa ñi cuñí tsi cuhñi jihna ra tsi ra jatsii vehe can tan cuvi quɨhvɨ ra suhu ra tsa tsii ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Tsa nditsa catyí yu tsihin ndo tyin cuví coo tucahnu iñi tsi nyɨvɨ tsa cuenda tandɨhɨ nuu cuatyi javahá ñi, tan tsa cuenda tucu tsa caahán ñi tsa ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Maa tyin tun cahan ñi ndavaha ñi sɨquɨ Tatyi Ii Nyoo, ña cua jaha maa Nyoo tucahnu iñi tsi ñi; cua coo cuatyi ñi yoso cuahan quɨvɨ ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tacan caha̱n ra Jesús tsihin ra maestro cuenda ley vehe ñuhu naha ra, tyin catyí ra naha tyin tatyi ña vaha yɨhɨ́ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tacan tan tsaa̱ sɨhɨ ra Jesús tan yañi ra nu nyií ra, maa tyin ndoo̱ ñi ityi tsata vehe, tan catyi ñi tsihin ra nyecú ican naha ra tyin cana ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tan catyí nyɨvɨ nyecú nanɨɨ canduvi xiin ra Jesús tsihin ra: ―Sɨhɨ un, yañi un tan cuhva un nanducú ñi tsi un nyecú ñi tsata vehe can ―catyí ñi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Maa tyin catyí ra: ―¿Yóo cuví sɨhɨ yu tan yañi yu? ");
INSERT INTO mjcNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tacan tan nanyehe̱ ra nanɨɨ canduvi nu nyaá ra, tan catyí ra: ―Nyɨvɨ nyecú ihya cuví sɨhɨ yu, yañi yu tan cuhva yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tyin tandɨhɨ nyɨvɨ javahá cuhva cuñí Nyoo, juvin ñi cuví yañi yu, cuhva yu tan sɨhɨ yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Quitsaha̱ jacuahá ra Jesús inga tsaha yuhu miñi. Tan cuaha xaan nyɨvɨ ndu ii̱n nu nyií ra. Tan tsa cuenda tsa cuaha xaan ñi cuvi̱, quɨhvɨ̱ ra tsitsi yutun ndoo tsa canyií nu ndutya yuhu miñi can, tan tsinyaa̱ ra tsitsi can. Tan ndoo̱ tandɨhɨ maa nyɨvɨ nu nyɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tacan tan cuaha xaan tsa jacuaha̱ ra tsi ñi tsihin cuhva. Tan tsitsi tsa jacuahá ra tsi ñi, catyí ra tsihin ñi: ");
INSERT INTO mjcNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Tya̱a soho ndo tsa cua cahan yu. Iin ra quita̱ ra yuvehe ra. Tan cuahán ra cua tatsi ra trigu nu ñuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tan cuhva tsa quɨtɨ́ ra tsɨtɨ trigu can, cucoyo̱ juhva tsi yuhu ityi. Maa tyin quitsi̱ saa tan tsatsi̱ tɨ naha tɨ itsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tan juhva ca tsɨtɨ can cucoyo̱ tsi nu yuu nu ña cuaha nyahyu yɨhɨ́. Tan numi ñi cana̱ tsɨtɨ can tyin ña cuaha nyahyu yɨhɨ́ tyañu yuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Maa tyin tsa cana̱ ñicanyii, iin yaha ñi na ityi̱ tsi tyin ña cunu cuahán yoho tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tan juhva ca tsɨtɨ can cucoyo̱ tsi tyañu iñu. Quɨvɨ cana̱ tsɨtɨ can, tsahnu̱ tsi iin caa ñi tsihin iñu can. Maa tyin iñu can numi ca tsahnu̱ can tan tsahñi̱ can trigu can. Yacan cuenda ña tsaha̱ trigu can tsɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Maa tyin juhva ca tsɨtɨ can cucoyo̱ tsi nu ñuhu vaha. Cana̱ tsi tan tsahnu̱ tsi, tan cuaha tsɨtɨ tsaha̱ tsi. Tyin tsa intuhun tsɨtɨ can, tsaha̱ tsi oco utsi tsɨtɨ tsitsi yoco tsi. Tan inga tsɨtɨ can tsaha̱ tsi uñi xico, tan inga tsi tsaha̱ tsi iin cientu ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tan catyí nyico ra tsihin ñi: ―Nyooho tsa iyó soho, tya̱a soho ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tsa yaha̱ yacan tan ndoo̱ maa ña ra Jesús tsihin ra tsicá tsihin ra tan nyɨvɨ nyicún tsi ra. Tan tsica̱ tuhun ñi: ―¿Náa cuñí tsi catyí tsa caha̱n un nañi? ");
INSERT INTO mjcNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tan catyí ra tsihin ñi: ―Maa Nyoo catyí tyin jacotó yu tsi ndo tuhun xeehe nácaa ndacá ñaha ra. Maa tyin inga ca nyɨvɨ jacotó yu can tsi ñi tsihin cuhva ñi tyin ña cuñí ñi cunyicun vaha ñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tyin vasu ndi maa nyehé ñi tsa javahá yu, cua cuví tsi tumaa tsa ña nditsin nyehé ñi; vasu ndi maa tsiñí ñi, ña cua cutuñí iñi ñi tsa caahán yu. Tan ndi ña cua nasama ñi cuhva iyó ñi tan ndi ña cua jaha Nyoo tucahnu iñi tsi ñi tsa cuenda cuatyi ñi ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tan catyí ndɨhɨ ra tsihin ñi: ―Tun ña cutuñí iñi ndo tuhun caha̱n yu nañi, ndi ña cua cutuñi iñi ndo tandɨhɨ ca tsa cua jacuaha yu tsi ndo tsihin cuhva ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ra tatsí trigu can cuví ra caahán tuhun Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yɨhɨ́ nyɨvɨ cuví ñi tumaa nu cucoyo̱ tsɨtɨ trigu yuhu ityi tyin tsiñí ñi tuhun Nyoo, maa tyin yaha̱ can, tan iin yaha ñi naá nyico iñi ñi tsa caahán Nyoo tsihin ñi tyin quihín nyaa nu ña vaha tuhun Nyoo tsa tatsi̱ ra añima ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tan juhva nyɨvɨ cuví ñi tumaa nu cucoyo̱ tsɨtɨ trigu tsata yuu tyin sɨɨ xaan cuñí ñi tsiñí ñi tuhun Nyoo juhva ñi quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Maa tyin ña ndoó tsi añima ñi tan ña cuví cuahnu ñi tan juhva ñi quɨvɨ tsinú iñi ñi, yacan cuenda cuví ñi tumaa nu cucoyo̱ tsɨtɨ tsata yuu tyin tsata yuu can luxu cuii ñi nyahyu yɨhɨ́. Yacan cuenda ña tsahnu̱ tsi tyin ña ñihi̱ tsi nu cuhun yoho tsi. Tacan cuví nyɨvɨ can, tyin quɨvɨ vatsí tundoho sɨquɨ ñi, tan caahán nyɨvɨ tsi ñi tsa cuenda tuhun Nyoo, ndu uví iñi ñi tan jandɨhɨ ñi tsa tsinú iñi ñi tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tan juhva nyɨvɨ cuví ñi tumaa nu cucoyo̱ tsɨtɨ tyañu iñu tyin tsiñí ñi tuhun Nyoo, ");
INSERT INTO mjcNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","maa tyin tsicá xaan iñi ñi tundoho ñayɨvɨ ihya tan ña tsicá iñi ñi tuhun Nyoo. Nyiyo iñi ñi tsa cuca, tan cuñí ñi coo tandɨhɨ tsa iyó nu ñuhu ñayɨvɨ ihya tsi ñi. Tan tandɨhɨ yacan jatyañú can tsi ñi, tan cuví ñi tumaa cuví yutun tsa ña tsaha̱ tsɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Maa tyin nyɨvɨ tsa tsiñí tuhun Nyoo tan naquihín vaha ñi itsi, tan javahá ñi tandɨhɨ tsa caahán tsi, juvin ñi cuví tumaa ñuhu vaha nu cucoyo̱ tsɨtɨ can tyin tsɨtɨ tsa cucoyo̱ can cana̱ vaha tsi, tsahnu̱ tsi, tan yɨhɨ tsi tsaha̱ tsi oco utsi tsɨtɨ. Inga tsi tsaha̱ tsi uñi xico tsɨtɨ, tan inga tsi tsaha̱ tsi cientu tsɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tan catyí tucu ra tyehen tsihin ñi: ―¿A tsicán yo ñuhu̱ tyuma tan tyihí xeehe yo can tsitsi iin caja o xuu tsito? Ñavin. Tyin tyuma can tinyií yo can iin nu sucun tyin tacan tan janditsin can nanɨɨ tsitsi vehe. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tyin nduve tsa yɨhɨ́ xeehe tan ña cua quituvi, tan ndi tsa xeehe tan ña cua coto nyɨvɨ. Tyin tandɨhɨ maa tan cua quita nu nditsin tan coto yo can. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nyooho tsa iyó soho, tya̱a soho ndo tsa caahán yu ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tan catyí tucu ra: ―Tya̱a soho vaha ndo tsa caahán yu tyin tun tyaá yahvi ndo tuhun tsiñí ndo, cuaha ca tsa cua cuhva Nyoo tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tyin nyɨvɨ tyaá soho tsa caahán yu, cuaha ca cua cuhva Nyoo tsi ñi. Maa tyin nyɨvɨ tsa ña tyaá soho, cua quihin nyaa ra nda cuanda tsa luxu tsa iyó tsi ñi tsa tsa yaha̱ ñihi̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tan catyí tucu ra Jesús: ―Tsa ndacá ñaha Nyoo tsi nyɨvɨ cuví tsi tumaa tsɨtɨ tsa tatsí nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tyin nyɨvɨ tatsí ñi maa ñi tsɨtɨ can tan cuanuhú ñi yuvehe ñi. Tan tatun tsa yaha cuaha quɨvɨ tsa tatsi̱ ñi, tacan tan cuahán ñi cuanyehé ñi inga tsaha. Tsa tsaá ñi tsa cana̱ tsi, tsa tsahnu̱ tsi. Maa tyin ña tsitó ñi nácaa caná tsi tan tsahnú tsi, ");
INSERT INTO mjcNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","tyin juvin ñi maa ñuhu jacuahnú itsi. Tsa jihna ñi caná nuu tsi, yaha can tan quitá yoco tsi. Tsa yaha quita yoco tsi, tacan tan tsahá tsi tsɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tan tatun tsa tsitsa tsɨtɨ tsi, tacan tan jocón ñi itsi tyin tsa taha̱n maa tsi quɨvɨ coyo tsi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tan catyí tucu ra Jesús: ―¿Nacaa cuví tsa ndacá ñaha Nyoo tsi nyɨvɨ? ¿A cuví jandu inducu yo itsi tsihin náa tsihin? Cuví. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tyin cuví tsi tumaa iin tsɨtɨ mostaza tsa tatsí nyɨvɨ. Tsɨtɨ can cuví tsa nyihi ca tan ñavin ca tandɨhɨ ca tsɨtɨ tsa iyó nu ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Maa tyin tsa yaha tatsi tsi, caná tsi tan ndunahnú tsi, tan cuví tsi yutun tumaa nducuaya. Ndunahnú soco tun, tan cuahán saa cua quitatu tɨ naha tɨ nuu tun. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tacan jacuaha̱ ra Jesús tsi nyɨvɨ, tsihin cuaha cuhva, ndɨhɨ cuhva cuvi̱ cutuñí iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tan tandɨhɨ tsaha tsa caha̱n ra tsihin ñi maa ñi maa tsihin cuhva caha̱n ra. Maa tyin caha̱n catsi ra tsihin ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tsa tseñi juvin ñi maa quɨvɨ can, catyí ra Jesús tsihin ra tsicá tsihin ra: ―Co̱hon ndo inga tsiyo miñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tacan tan ra Jesús tan ra tsicá tsihin ra nacoo̱ ra naha tsi nyɨvɨ tan quɨhvɨ̱ ra naha tsitsi yutun ndoo nu nyaá maa ra Jesús, tan cuahán ra naha. Tan cuanyicún tucu inga ca yutun ndoo nu yɨhɨ́ juhva nyɨvɨ tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tan quitsaha̱ yɨhɨ́ tatyi xaan nu miñi can, tan jacuhún tsi ndutya tsitsi yutun ndoo nu yucú ra naha, tan quitsaha̱ cuñí cutu yutun ndoo can. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tan ra Jesús canyií ra quixí ra tsa yatyin xuu yutun ndoo can, tan nyanaá iin jahma jiñi ra. Jandoto̱ ra naha tsi ra, tan catyí ra naha tsihin ra: ―¡Maestro! ¿a ña jahá un cuenda tyin cuñí nyee yo? ");
INSERT INTO mjcNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tacan tan nduvita̱ ra Jesús tan jacutaxi̱n ra tatyi xaan can. Tan catyí ra tsihin ndutya: ―¡Taxin ñi! Tan cutaxi̱n tatyi can tan ndutya can. Tacan tan taxin cuii ñi cuví. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tacan tan catyí ra Jesús tsihin ra tsicá tsihin ra: ―¿Nacuenda yuuhví xaan ndo? ¿A ña tsinu iñi ndo? ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Maa tyin iyo xaan cuñí ra naha tsa nyehe̱ ra naha tsa cuvi̱. Tan tsicá tuhun tahan ra naha tan catyí ra naha: ―¿Yóo ra cuví ra ihya? Tyin nda cuanda tatyi tan ndutya tyaá yahvi tsi naha tsi tsi ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tsaa̱ ra naha inga tsiyo miñi nda nu ñuhu cuenda Gadara. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tsa quita̱ ra Jesús tsitsi yutun ndoo, tan quita̱ iin ra yɨhɨ́ tatyi ña vaha nu ndaa cumi santu, tan tsaa̱ ra nu nyaá ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tan nu ndaa can iyó maa ra can. Tsaahñí ñi tsi ra, maa tyin ña cuví maa ndoo taxin ra. Ndi tsihin cadena tan ña cuví cunuhñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cuaha xaan tsaha tsahñi̱ nyɨvɨ tsaha ra tan ndaha ra tsihin cadena, maa tyin tsaahnyá cuatyi ra can. Tan yoñi maa cuví cunyee tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tan tsicá nuu maa ra caná tsaa ra jiñi yucu tan nu ndaa cumi santu tsa tsa cuaa tan tsa tsinu cahñi. Tan jañicueehé ra tsi ra tsihin yuu. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Maa tyin ndi cañi ca quita̱ ra Jesús, tan nyehe̱ ra can tsi ra, tan tsinú xaan ra tsaha̱n ra, tsicuɨñɨ̱ tsɨtɨ ra nuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tan cana̱ tsaa ra tan catyí ra: ―¿Nacuenda tyihí un tsi un tsihin yuhu, yooho Jesús, Sehe Nyoo, nyaá gloria? Tsihin sɨvɨ Nyoo caahán ndaahvi yu tsihin un, ña ja̱nyehe un tundoho tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tacan catyí nu tatyi ña vaha can tsihin ra Jesús tyin tsa yaha̱ caha̱n ra tsihin nu tyehen: ―¡Yooho tatyi ña vaha, ja̱ña tsi ra ihya! ―catyi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tan ra Jesús tsica̱ tuhun ra tsi nu, tan catyí ra: ―¿Náa nañí un? Tan catyí nu tatyi ña vaha can tsihin ra: ―Yuhu nañí yu Legión, tyin cuaha xaan ndi. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tan caahán ndaahvi nu tsihin ra Jesús na ña jacuhun cañi ra tsi nahnu. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Yatyin ñi yucu can yucú cuaha quɨnɨ tsatsí tɨ naha tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tacan tan catyí tandɨhɨ nahnu tsihin ra Jesús: ―Ja̱cuhun tsi ndi tsitsi quɨnɨ nyecú ican, tan cu̱hva ndatu tsa quɨhvɨ ndi tsitsi tɨ naha tɨ ―catyí nahnu. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tacan tan tsaha̱ ra Jesús ndatu tsi nahnu, tan quɨhvɨ̱ nahnu tsitsi quɨnɨ can. Quita̱ nahnu tsi ra can tan quitá tumaa uvi mil quɨnɨ yucú can. Tsa quɨhvɨ̱ nahnu tsitsi tɨ naha tɨ, quitsaha̱ tsinú tɨ naha tɨ, tan yaha̱ tɨ naha tɨ yuhu xahva tan cucoyo̱ tɨ naha tɨ tsitsi miñi, tan tsihi̱ tɨ naha tɨ tsitsi ndutya. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tacan tan ra jahá cuenda quɨnɨ can naha ra, nayuhvi̱ xaan ra naha tan tsinú xaan ra naha cuahán ra naha cuanuhú ra naha cuacatyí tuhun ra naha tsa cuvi̱ can tsihin nyɨvɨ ñuu can tan inga ca nyɨvɨ tsa taahán ra naha ityi cuhu. Tan tandɨhɨ nyɨvɨ tsa caha̱n ra naha tsihin, tsaha̱n ñi tsinyehe̱ ñi tsa cuvi̱ can. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cuhva tsa tsaa̱ ñi nu nyií ra Jesús, nayuhvi̱ xaan ñi tsa nyehe̱ ñi tsi ra tsa yɨhɨ̱ tatyi ña vaha can. Nyaá taxin ra, nditsí ra jahma, tan vaha cuñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tan tandɨhɨ maa nyɨvɨ tsa nyehe̱ tsa taha̱n ra can tan tsa taha̱n quɨnɨ can, catyi̱ tuhun ñi can tsihin inga ca nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tacan tan quitsaha̱ caahán ndaahvi ñi tsihin ra Jesús, na ña ndoo ra nu ñuhu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tsa tsa cua quɨhvɨ nyico ra Jesús tsitsi yutun ndoo can, ra tsa yɨhɨ̱ tatyi ña vaha can caahán ndaahvi ra tsihin ra Jesús na cuhva ra cuhun ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Maa tyin ña tsaha̱ ra Jesús cuhun ra tsihin ra, tan catyí ra tsihin ra: ―Cu̱anuhu yuvehe un nu iyó nyɨvɨ un, tan ca̱tyi tuhun tsihin ñi tandɨhɨ tsa javaha̱ Jutu Mañi yo Nyoo tsihin un, tan nácaa cundaahvi̱ iñi ra tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tacan tan cuanuhú ra tan quitsaha̱ catyí tuhun ra tsihin nyɨvɨ iyó tandɨhɨ ñuu tsa cayucú Decápolis tandɨhɨ tsa javaha̱ ra Jesús tsihin ra. Tan iyo xaan cuñí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tsa tsaa̱ ra Jesús tsihin yutun ndoo nda inga tsiyo miñi can, tsaa̱ cuaha nyɨvɨ nu tsaa̱ ra. Tan ndoo̱ ra yuhu miñi ican. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tacan tan tsaa̱ iin ra nyisó tyiñu vehe ñuhu, nañí ra Jairo. Cuhva tsa nyehe̱ ra tsi ra Jesús, tsicuɨñɨ̱ tsɨtɨ ra nuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tan caahán ndaahvi ra tsihin ra tan catyí ra: ―Co̱hon tsihin yu yuvehe yu tan tyi̱so ndaha un jiñi ñaha sehe yu, na nduvaha ña tyin tsa cuñí cúu cuii ña ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tacan tan cuahán ra Jesús tsihin ra, tan cuaha xaan nyɨvɨ cuahán cuanyicún tsi ra, nda cuanda catyihí tahan ña maa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tsihin nyɨvɨ can cuahán ndɨhɨ iin ñaha cuuhví. Ñaha ihya tsa quitá maa utsi uvi cuiya ndohó ña cuehe tsa cuún nɨñɨ ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tan cuaha xaan tundoho nyehe̱ ña tsihin tsa cuaha doctor. Tandɨhɨ xuhun ña janaa̱ ña tsihin ra naha, maa tyin nduve maa náa catyi janaa̱ ña xuhun ña tyin vihi ca nduñihi̱ cuuhvi ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tsa tsiñi̱ ña caahán nyɨvɨ tyin tsaa̱ ra Jesús, natuhva̱ ña ityi tsata ra tan tɨɨ̱n ña jahma ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tyin tsicá iñi maa ña: “Tatun tɨɨn yu vasu tan jahma ra, cua nduvaha yu”. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tsa tɨɨ̱n ña jahma ra iin yaha ñi cutaxi̱n tsa cuún nɨñɨ ña. Tan tuvi̱ iñi cuñu ñuhu ña tyin tsa janduvaha̱ ra tsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tsa tuvi̱ iñi ra Jesús tyin nduvaha̱ iin nyɨvɨ tsihin tunyee iñi tsa iyó tsi ra. Tacan tan nanyico̱ coo ra ityi tsata ra tan tsica̱ tuhun ra tan catyí ra: ―¿Yóo tɨɨ̱n jahma yu? ");
INSERT INTO mjcNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tacan tan catyí ra tsicá tsihin ra: ―¿Nacuenda tsicá tuhun ca un: yóo tɨɨ̱n jahma un? tan nyehé vaha un tyin cuaha xaan nyɨvɨ nyicún tsi un tan tyañu xaan jahá ñi ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Maa tyin ra Jesús nanyehe̱ ra nanɨɨ ñi tyin cuñí ra coto ra yóo tɨɨ̱n jahma ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tacan tan ñaha can tsaha̱n ña tsicuɨñɨ̱ tsɨtɨ ña nuu ra Jesús tyin tsitó vaha ña tyin tsa nduvaha̱ ña. Yuuhví ña tan nɨhɨ́ ña tsaha̱n ña tsicatyi̱ tuhun ña tandɨhɨ tsa nditsa tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tan catyí ra Jesús tsihin ña: ―Nduvaha̱ un tyin tsinú iñi un. Na cuhun vaha un, tan na ña cuhvi ca un ―catyí ra Jesús tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ndi caahán ca ra Jesús tan tsaa̱ nyɨvɨ quee̱ yuvehe nu cuahán ra, tan catyí ñi tsihin ra jatsii vehe can, ra nyisó tyiñu vehe ñuhu: ―Tsa tsihi̱ ñaha luhlu sehe un. Ña ca̱han yuhu ca un tan ña ja̱tyañu ca un tsi ra Maestro ihya ―catyí ñi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Maa tyin ra Jesús ña tyaa̱ yahvi ra tsa caahán ñi, tan catyí ra tsihin ra nyisó tyiñu vehe ñuhu: ―Ña na̱yuhvi un; tsi̱nu iñi yooho ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tan ña tsaha̱ ra cuhun cuaha nyɨvɨ tsihin ra. Tan quihi̱n ra tsi ra Pedro tan ra Jacobo tan ra Juan, yañi ra Jacobo cuahán ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tsa tsaa̱ ra naha yuvehe ra nyisó tyiñu vehe ñuhu, nyehe̱ ra Jesús tyin tsacú xaan nyɨvɨ tan caná tsaa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Quɨhvɨ̱ ra tsitsi vehe tan tsicá tuhun ra tsi ñi: ―¿Nacuvi tyin iyo xaan jacuvaá ndo, tan tsacú xaan ndo? Ñaha luhlu ihya quixí ña; ñavin tsihi̱ ña ―catyí ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Maa tyin ña tsinu̱ iñi ñi tan tsacu̱ naaha ñi nyehé ñi tsi ra. Tacan tan tava̱ ra tsi tandɨhɨ ñi nuquehe, tan quihi̱n ra tsi jutu ñaha luhlu tsa tsihi̱ can tan sɨhɨ ña tan ra tsa tsaa̱ tsihin ra, tan quɨhvɨ̱ tandɨhɨ ñi nu canyií ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tan tɨɨ̱n ra ndaha ña, tan catyí ra tsihin ña: ―Talita cumi ―tan cuñí tsi catyí tsi tyehen: Catyí yu tsihin yooho ñaha luhlu, ¡ndu̱vita! ");
INSERT INTO mjcNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Juvin ñi cuhva can tan nduvita̱ ña, tan nacaca̱ ña. Utsi uvi cuiya ña. Tan tsa nyehe̱ nyɨvɨ tsa iyo tsa javaha̱ ra Jesús, iyo xaan cuñí ñi cuvi̱. ");
INSERT INTO mjcNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Maa tyin ra Jesús ñihi tsaha̱ cuenda ra tsi ñi tyin na ña cahan ñi tsa nyehe̱ ñi tsihin ndi intuhun maa nyɨvɨ. Tan tava̱ tyiñu ra tsi sɨhɨ ña na cuhva ña tsa catsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tacan tan quita̱ ra Jesús ican, tan cuanuhu̱ ra nda ñuu ra. Tan ra tsicá tsihin ra cuahán ndɨhɨ ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tan tsa taha̱n tsi quɨvɨ quitatú nyɨvɨ, tacan tan cuahán ra naha vehe ñuhu tan quitsaha̱ jacuahá ra Jesús tsi nyɨvɨ. Tan cuaha ñi yucú tyaá soho ñi tsa caahán ra. Iyo cuñí ñi tsa tsiñí ñi tsa caahán ra, tan catyí ñi: ―¿Numaa tahan cutuhva̱ ra ihya tandɨhɨ tsa tsitó ra? ¿Yóo tsaha̱ tsa tsiñi tuñi iñi ra? ¿Tan nácaa cutuhva̱ ra javahá ra tsa iyo? ");
INSERT INTO mjcNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tan ra tahví yutun cuví ra. Tan sehe ña María cuví ra. Tan yañi ra cuví ra Jacobo, ra José, ra Judas, tan ra Simón, tan ñiñaha cuhva ra iyó ñi nu iyó yo ihya ―catyí ñi. Tan ña cuñi̱ ñi tyaa yahvi ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Maa tyin catyí ra tsihin ñi: ―Tandɨhɨ ñi ityi tan jahá tandɨhɨ nyɨvɨ tsa ñayɨvɨ tsi ra cuví ndusu yuhu Nyoo, maa tyin nyɨvɨ ñuu ra, tan nyɨvɨ ra, tan nyɨvɨ vehe ra ña tyaá yahvi ñi tsi ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tan tyiso̱ ndaha ra jiñi juhva nyɨvɨ cuuhví, tan janduvaha̱ ra tsi ñi, maa tyin ña cuvi̱ javaha̱ ra inga ca tsa iyo. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tan iyo cuñí ra tyin ña tsinú iñi ñi tsi ra. Tacan tan cuahán ra cuajacuahá ra tsi nyɨvɨ iyó tandɨhɨ ñi ñuu nyihi tsa cayucú yatyin ñi ñuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tsa yaha̱ yacan tan cana̱ ra tsi tsa utsi uvi ra tsicá tsihin ra, tyin jacuhun ra tsi ra naha cucahan ra naha tuhun Nyoo. Tacan tan quitsaha̱ jacuhún ra uvi uvi ra naha. Tan tsaha̱ ra ndatu tsi ra naha tsa tava ra naha tatyi ña vaha tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tan catyí ra tsihin ra naha tyin ña cundaha ra naha tsa cundaha ra naha; ndi marali, ndi tsa catsi ra naha, tan ndi xuhun. Nduve náa cundaha ra naha; maa tyin cuví cundaha ra naha yutun ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tan cunyaa nditsan tsaha ra naha. Tan ña cundaha ra naha inga nditsi jahma, na cuhun ra naha tsihin cuhva nditsi ñi maa ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tan catyí ra tsihin ra naha: ―Cuhva tsa tsaa ndo iin ñuu, quɨhvɨ ndo iin vehe, tan ndo̱o ndo ican nda cuanda quita ndo ñuu can. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tan tatun tsaa ndo iin ñuu tan ña naquihin cuenda nyɨvɨ iyó ñuu can tsi ndo, tan ña cuñi ñi tyaa soho ñi tsa cua cahan ndo, qu̱ita ndo ican tan na̱quɨsɨ ndo nyaca tsaha ndo tan yacan janaha tyin ndoo cuatyi ñi sɨquɨ ñi. Tsa nditsa catyí yu tsihin ndo, tyin quɨvɨ cua tatsi tuñi Nyoo tsi nyɨvɨ, ñihi ca cua tatsi tuñi ra tsi ñi can tan ñavin ca nyɨvɨ ñuu Sodoma tan ñuu Gomorra ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tacan tan cuahán ra naha cuacahán ra naha tuhun Nyoo tsihin nyɨvɨ. Tan catyí ra naha tyin na ndu uvi iñi ñi cuatyi ñi, tan na nanducu ñi tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tan cuaha ñi nyɨvɨ tava̱ ra naha tatyi ña vaha. Tan tyihi̱ ra naha acetye tsi nyɨvɨ cuuhví tan nduvaha̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ra rey Herodes tsitó ra tsa javahá ra Jesús tyin tandɨhɨ nyɨvɨ tan caahán ñi tsa javahá ra, tan tsicá iñi ra tyehen: ―Ra ihya cuví ra Juan, ra jacoondutya̱ tsi nyɨvɨ, ra tsa tsihi̱. Vityin nandoto̱ ra. Juvin ra cuví can, yacan cuenda iyó tunyee iñi tsi ra ―cuñí ra Herodes, tsicá iñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yɨhɨ nyɨvɨ catyí ñi: ―Ra Elías, ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha, cuví ra. Tan catyí tucu inga ñi: ―Ndusu yuhu Nyoo cuví ra, tumaa ra tsicoo̱ taha̱n tsanaha naha ra ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tsa tsiñi̱ ra Herodes tandɨhɨ tsa caahán nyɨvɨ, tan catyí ra: ―Ra ihya cuví ra Juan tsa tava̱ tyiñu yu tyahnya jucun. Vityin nandoto̱ ra ―catyí ra Herodes. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tacan catyí ra tyin juvin ñi maa ra tava̱ tyiñu na tyihi ra naha tsi ra Juan vehe caa tan cuhñi ra naha tsi ra tsihin carena. Tacan javaha̱ ra Herodes tsihin ra Juan tsacatyi ña Herodías tsa cuvi̱ ñasɨɨhɨ ra Felipe yañi ra. Ra Herodes quihi̱n ra tsi ña Herodías tyin cuvi ña ñasɨɨhɨ ra ");
INSERT INTO mjcNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tan tsa tacan javaha̱ ra, catyi̱ ra Juan tsihin ra tyin ña vaha tsa quihi̱n ra tsi ña Herodías tyin ñasɨɨhɨ yañi ra cuví ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yacan cuenda ndasɨ cuñí ña Herodías nyehé ña tsi ra Juan. Cuñí ña cahñi ña tsi ra, maa tyin ña cuví, ");
INSERT INTO mjcNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tyin ña tsahá ra Herodes tyin tsitó ra tyin ra vaha cuví ra Juan tan cuɨtɨ iyó ra nuu Nyoo, tan yuuhví ra Herodes tsi ra. Yacan cuenda jahá cuenda vaha ra tsi ra. Vasu ndi maa ña cutuñí iñi ra Herodes tandɨhɨ tsa caahán ra Juan, maa tyin vaha cuñí ra tyaá soho ra tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Maa tyin tsa taha̱n tsi quɨvɨ cacu̱ ra Herodes javaha̱ ra iin vico. Tan cana̱ ra tsi ra cumí tyiñu naha ra, tan ra yɨhɨ́ ndaha andaru naha ra, tan nyɨvɨ cuca tsa iyó ityi Galilea. Quɨvɨ ihya tsica̱n ña Herodías tsa cuñí ña tsi ra Herodes. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tyin ñaha sehe ña tsaha̱n ña tsicuañi̱ ña yaa nu iyó vico ra Herodes. Tan taha̱n xaan iñi ra Herodes tan ra nyecú cuxiñí tsihin ra cuhva tsañí ña. Tacan tan catyí ra Herodes tsihin ña: ―Nda̱can tsi yu náa cuñí maa un. Náa tahan ñi maa tsi cua ndacan un tsi yu cua cuhva maa yu can tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tsitó maa Nyoo tyin cua cuhva yu tsa cua ndacan un. Tun ndacan un sava ñuhu tsa ndacá ñaha yu, cua cuhva yu can tsi un ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tacan tan quita̱ ña, cuahán ña cuandacá tuhun ña tsi sɨhɨ ña tan catyí ña: ―¿Náa ndacan yu tsi ra? Tan catyí sɨhɨ ña: ―Nda̱can jiñi ra Juan, ra jacoondutya̱ tsi nyɨvɨ tsi ra ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tacan tan numi ñi quɨhvɨ̱ nyico ñaha tyuvaa can nu nyií ra rey Herodes, tan catyí ña tsihin ra: ―Cuñí yu jiñi ra Juan, ra jacoondutya̱ tsi nyɨvɨ. Ca̱hnya jucun ra tan tinyii un jiñi ra nuu iin coho, cuhva un tsi yu vityin vityin ñi ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tacan tan cuiihya xaan cuñí ra rey can cuvi̱. Maa tyin tsa cuenda tsa caha̱n ra tyin cua cuhva maa ra tsa cua ndacan ña, ña cuñí ra jandaví ñaha ra tsi ña tyin tandɨhɨ maa nyɨvɨ yucú vico can tan tsiñi̱ ñi tsa caha̱n ra, yacan cuenda tsaha̱ ra tsa tsica̱n ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Numi ñi tava̱ tyiñu ra rey can tsi iin andaru na cuquihin ra jiñi ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tsaha̱n andaru can tsitsi vehe caa, tan tsahnya̱ ra jucun ra Juan. Tan tsindaca̱ ra jiñi ra Juan tsi ñaha tyuvaa can, nyií tsi nu iin coho. Tan nacuhva̱ cuenda ña can tsi sɨhɨ ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tsa tsito̱ ra nyicún tsi ra Juan tsa cuvi̱, tsaha̱n ra naha tsiquihi̱n ra naha cuñu ñuhu ra, tan tsicutsi̱ ra naha can. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tsa yaha̱ yacan tan ndu ii̱n ra tsicá tyiñu ra Jesús tsihin ra, tan catyi̱ tuhun ra naha tsihin ra tandɨhɨ tsa javaha̱ ra naha, tan tsa jacuaha̱ ra naha nu tsaha̱n ra naha tsicaha̱n ra naha tuhun Nyoo tsihin nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tan catyí ra Jesús tsihin ra naha: ―Co̱hon ndo iin nu taxin caa, quitatu yo luxu. Tacan catyi̱ ra tsihin ra naha tyin cuaha xaan nyɨvɨ cuahán tan vatsí, tan ndi ña cuyatyi ra naha catsi ra naha jahá ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tacan tan quɨhvɨ̱ ra Jesús tsihin ra naha tsitsi iin yutun ndoo tan cuahán ra naha iin nu taxin caa. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Maa tyin cuaha xaan nyɨvɨ nyehe̱ ñi cuahán ra naha. Tan nacotó ñi tsi ra Jesús. Tacan tan cuahán ñi tsihin tsaha ñi, quita̱ ñi tandɨhɨ ñi ñuu tan jihna ca ñi tsaa̱ nu cua tsaa ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cuhva tsa tsaa̱ ra naha, quita̱ ra Jesús tsitsi yutun ndoo tan nyehe̱ ra tyin cuaha xaan nyɨvɨ yucú ican. Tan cundaahvi̱ iñi ra nyehe̱ ra tsi ñi, tyin yucú ñi tumaa tsiyucú mbee tun nduve ra jahá cuenda tsi tɨ naha tɨ. Tacan tan quitsaha̱ jacuahá ra cuaha xaan tuhun vaha tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tsa tsa cua cuiso ñicanyii, tan natuhva̱ ra tsicá tsihin ra Jesús xiin ra tan catyí ra naha tsihin ra: ―Tsa cueñi xaan, tan nduve nyɨvɨ iyó yatyin ñi ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Vaha ca jacunuhu un tsi nyɨvɨ tyin ihya nduve tsa catsi ñi. Tan na cujata ñi paan catsi ñi vehe tsa iyó tsitsi cuhu ihya tan ñuu tsa cayucú yatyin ñi ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Maa tyin nacaha̱n ra Jesús, tan catyí ra: ―Cu̱hva nyooho tsa catsi ñi. Tacan tan nacaha̱n ra naha tan catyí ra naha: ―Vasu ndi maa jaha tyiñu ndi iñu yoo, ña cua ñihi ndi xuhun jata ndi paan catsi tandɨhɨ nyɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tan catyí ra Jesús tsihin ra naha: ―Nye̱he jihna ndo najava paan ndahá ndo ―catyí ra. Cuhva tsa tsito̱ ra naha najava paan ndahá ra naha, tacan tan tsicaha̱n ra naha tsihin ra tan catyí ra naha: ―Ndahá ndi uhun taahan ñi paan tan uvi taahan ñi tyaca. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tacan tan catyí ra tsihin nyɨvɨ na cunyecu ñi nu cuhu can. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tan tsinyecu̱ cuenda cientu tan cuenda uvi xico utsi ñi tsa iin cuhva tsinyecu̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tacan tan quihi̱n ra Jesús tsa uhun paan can tan nduvi tyaca can. Tan nanyehe̱ ndaa ra ityi sɨquɨ, tan nacuhva̱ ra tyahvi nyoo tsi Nyoo, tsa yaha̱ tan tsahnu̱ cuatyi ra paan can, tan tsaha̱ ra can tsi ra tsicá tsihin ra tyin tsatsa ra naha can tsi nyɨvɨ. Tsa ndɨhɨ tsatsa̱ ra naha paan can, tan tsatsa̱ ndɨhɨ ra naha tyaca. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tsatsi̱ tandɨhɨ ñi tan ndaha̱ iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tan jacutu̱ ra naha utsi uvi tyica tsihin paan tan tyaca tsa ndoo̱. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tan uhun mil rayɨɨ tsatsi̱ paan can. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tacan tan catyí ra Jesús tsihin ra tsicá tsihin ra na yaha sava ñi ra naha nu miñi can tan cuhun cuee ñi ra naha nda ñuu Betsaida tsitsi tsa ndi jacunuhu ra tsi nyɨvɨ yuvehe ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tsa yaha̱ cuanuhu̱ nyɨvɨ, tacan tan cuahán ra Jesús cuandacán tahvi ra tsi Nyoo iin jiñi yucu. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tsa tsa cuñi cuaa, yutun ndoo nu cuahán ra tsicá tsihin ra Jesús tsa cuahán can nda mahñu miñi, tan maa ra ndi nyií ra yuhu miñi can. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tan tsa nyehe̱ ra tyin ña cuví jacacá vaha ra naha yutun ndoo jahá tatyi, tacan tan cuahán tsihin tsaha ra nu ndutya nu cuahán ra naha tsa tsa cuñí tuvi, nyicún tsicá nyicún tsicá ñi ra tsi ra naha. Tan tsa cua yaha tsiyo ra nu cuahán ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Maa tyin tsa nyehe̱ ra naha tsicá ra nu ndutya, tsica̱ iñi ra naha tyin tatyi cuví ra, tacan tan quitsaha̱ caná tsaa ra naha ");
INSERT INTO mjcNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tyin tandɨhɨ ra naha nyehe̱ ra naha tsi ra tan nayuhvi̱ ra naha. Maa tyin nacaha̱n ra tan catyí ra tsihin ra naha: ―¡Ña na̱yuhvi ndo tyin maa yu cuví! ");
INSERT INTO mjcNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tacan tan quɨhvɨ̱ ra tsitsi yutun ndoo nu yucú ra naha, tan tsa yaha̱ quɨhvɨ̱ ra, iin yaha ñi cutaxi̱n tatyi can. Tan iyo xaan cuñí ra naha cuvi̱ ");
INSERT INTO mjcNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tyin ñaha ca cutuñi iñi ra naha tsa iyo tsa javaha̱ ra tsihin paan, tyin ndi ndava añima ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yaha̱ sava ra naha nu miñi can tan tsaa̱ ra naha Genesaret inga tsiyo yuhu miñi can, tan tsahñi̱ ra naha yutun ndoo can yatyin ñi yuhu ndutya. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cuhva tsa quita̱ ñi ra naha tsitsi yutun ndoo can, tan nacoto̱ nyɨvɨ tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tacan tan tsinú xaan ñi cuahán ñi cuajacotó ñi tsi nyɨvɨ iyó nanɨɨ cahnu ityi can tyin tsaa̱ ra Jesús. Tan tsaa̱ cuaha nyɨvɨ quee̱ tandɨhɨ ñi ñuu nu nyií ra, tan yucú nyɨvɨ cuuhví nu tsitó tsaa̱ tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tan tandɨhɨ ñi ityi nu cuahán ra tsitsi ñuu nyihi o tsitsi ñuu nahnu, o tsitsi cuhu, tsaquín nyɨvɨ nyɨvɨ cuuhví yuhu ityi. Tan caahán ndaahvi ñi tsihin ra na cuhva ra tɨɨn ñi cuuhví can vasu tan yuhu jahma ra tan nduvaha ñi. Tan tandɨhɨ maa nyɨvɨ tsa tɨɨ̱n jahma ra nduvaha̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tacan tan tsaa̱ juhva ra fariseo tan juhva ra maestro cuenda ley vehe ñuhu tsa quee̱ ñuu Jerusalén naha ra nu nyií ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ra ihya naha ra nyehe̱ ra naha tyin juhva ra tsicá tsihin ra Jesús ña nacatya̱ ra naha ndaha ra naha tan tsatsí ra naha tumaa catyí maa costumbre ra naha. Tsa cuenda yacan catyí ra naha tyin ña vaha javaha̱ ra can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tyin ra fariseo naha ra javahá ra naha tumaa catyí costumbre tsii tsaahnu ra naha tacan tucu ñi tandɨhɨ ca nyɨvɨ Israel ña cuví catsi ñi tun ña nacatyá ñi ndaha ñi cuaha tsaha tumaa iyó maa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tan tatun ña nacatya ñi ndaha ñi tsa tsaá ñi quee ñi nuyahvi, ña cuvi catsi ñi. Iyó cuaha ca costumbre tsa tuhvá ñi javahá tumaa tsa nacatyá ñi vasu, jarra, tan tandɨhɨ ndaha tyiñu tsa tsinú tsihin caa tsa iyó tsi ñi tan nda cuanda cama ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tacan tan tsica̱ tuhun ra fariseo tan ra maestro cuenda ley naha ra tsi ra Jesús, tan catyí ra naha: ―¿Nacuenda tyin ña javahá ra tsicá tsihin un naha ra cuhva nacoo̱ tsii tsaahnu yo naha ra? Tyin ña nacatyá jihna ra naha ndaha ra naha tumaa iyó maa yo tan tsatsí ra naha ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tan nacaha̱n ra Jesús, tan catyí ra: ―Nditsa tsa caha̱n ra Isaías, ra cuvi̱ ndusu yuhu Nyoo tuhun nyooho tsa jahá ndo tyin vaha xaan ndo tan ña nditsa ndo. Tyin catyi̱ ra tyehen: Nyɨvɨ ihya jacahnú ñi tsi yu tsihin yuhu ñi. Maa tyin ñavin tsihin tsa nɨɨ iñi añima ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yacan cuenda nduve yahvi nyaá jacahnú ñi tsi yu, tyin maa ñi maa tuhun caahán nyɨvɨ jacuahá ñi tan ñavin tuhun yu jacuahá ñi, catyi̱ ra Isaías tuhun ndo jaha̱ Nyoo, catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tyin nyooho nacoo̱ ndo cuhva caahán Nyoo, tan nyicún ndo cuhva caahán nyɨvɨ ñi, tumaa tuhvá ndo nacatya ndaha tyiñu ndo, tan inga ca tsa tuhvá ndo javahá. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nyooho tyaa̱ tsiyo ndo tuhun caahán Nyoo, tacan tan javahá ndo tuhun tsahnu tsa nacoo̱ tsii tsaahnu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tyin catyí ley Nyoo tsa tyaa̱ ra Moisés: “Tya̱a yahvi ndo tsi jutu ndo tan tsi sɨhɨ ndo, tyin tandɨhɨ nyɨvɨ tsa cua cahan ndavaha ñi tsi jutu o tsi sɨhɨ, cua cúu ñi” catyí ley Nyoo tsa tyaa̱ ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Maa tyin nyooho catyí ndo tyin cuví catyí iin nyɨvɨ tsihin jutu ñi o sɨhɨ ñi tyehen: “Ña cuvi jatyinyee yu tsi un tyin tandɨhɨ tsa iyó tsi yu cuví tsi Corbán.” (Tuhun ihya cuñí tsi catyí: “Tsa ndɨhɨ can tsaha̱ cuenda yu tsi Nyoo.”) ");
INSERT INTO mjcNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tan tatun catyí nyɨvɨ tacan, ña cuñí ca tsi jatyinyee ñi tsi jutu ñi o tsi sɨhɨ ñi, catyí ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yacan cuví tsa javahá ndo vityin, tyaá tsiyo ndo tuhun caahán Nyoo, tsahan tyaá yahvi ca ndo tuhun tsahnu cuhva iyó maa ndo. Tan cuaha ca tsa tacan caá javahá ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tacan tan cana̱ nyico ra Jesús tsi nyɨvɨ tan catyí ra tsihin ñi: ―Tya̱a soho vaha tandɨhɨ ndo tsa cua cahan yu, tan ndu̱cu ndo cuhva cutuñi iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tsa quɨhvɨ́ yuhu nyɨvɨ, ña cuví jatɨvɨ tsi tsi ñi. Tsa jatɨvɨ́ tsi ñi cuví tsa quitá añima ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nyooho tsa iyó soho, tya̱a soho ndo tsa caahán yu ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tsa yaha̱ nacoo̱ ra Jesús tsi nyɨvɨ, tan quɨhvɨ̱ ra tsitsi vehe, tacan tan tsica̱ tuhun ra tsicá tsihin ra náa cuñí tsi catyi tsa caha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tan catyí ra tsihin ra naha: ―¿A ndi nyooho tan ña cutuñi̱ iñi ndo? ¿A ña tsitó ndo tyin tsa quɨhvɨ́ tsitsi yo ña cuví jatɨvɨ tsi tsi yo? ");
INSERT INTO mjcNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tyin tsitsi yo quɨhvɨ́ tsi tan ñavin añima yo. Yaha can tan quitá tsi tsitsi cuñu ñuhu yo ―catyí ra Jesús. Tsihin tsehe janaha̱ ra tyin tandɨhɨ nyayu tan vaha catsi yo itsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tan catyí tucu ra: ―Tsa quitá añima nyɨvɨ, yacan jatɨvɨ́ tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tyin tsa caquiñi tsa tsicá iñi ñi tsitsi añima ñi quitá can, tacan tan rayɨɨ cuñí ra coo inga ñaha tsi ra, o ñiñaha cuñí ñi coo inga rayɨɨ tsi ñi. Yɨhɨ́ ra tsicoó ra tsihin inga ñaha tan ña tindaha̱ ra tsihin ña. Yɨhɨ rayɨɨ tsicoó ra tsihin ra ndusɨɨhɨ. Tan yɨhɨ ñiñaha tsicoó ñi tsihin ñi nduyɨɨ. Tan yɨhɨ́ ñi cuñi ñi cahñi ñi nyɨvɨ, ");
INSERT INTO mjcNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","o cuñí ñi suhu ñi. Yɨhɨ́ ñi cuñí ñi coo tsa tsii inga nyɨvɨ tsi ñi; yɨhɨ́ ñi javahá ñi tsa caquiñi; yɨhɨ́ ñi jandaví ñaha ñi; yɨhɨ́ ñi iyó inga viciu tsi ñi; yɨhɨ́ ñi nyiyo iñi ñi; yɨhɨ́ ñi caahán ñi cuendu; yɨhɨ́ ñi cahnu jahá ñi tsi ñi; yɨhɨ́ ñi soho javahá ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tandɨhɨ tsa ña vaha ihya, quitá can tsitsi añima nyɨvɨ, tan jatɨvɨ́ can tsi ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tsa yaha̱ yacan tan quita̱ ra Jesús ñuu can, tan cuahán ra ñuhu nu canyií ñuu Tiro tan ñuu Sidón. Tsa tsaa̱ ra ican, quɨhvɨ̱ xeehe ra tsitsi iin vehe tyin ña cuñí ra coto nyɨvɨ numaa nyií ra. Maa tyin ña cuvi̱ cunyii xeehe ra ");
INSERT INTO mjcNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","tyin yatyi xaan tsito̱ sɨhɨ iin ñaha tyuvaa tsa yɨhɨ́ tatyi ña vaha nu nyií ra. Tacan tan cuahán ña nu nyií ra. Tsa tsaa̱ ña tan tsicuɨñɨ̱ tsɨtɨ ña nuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ñaha can, ñavin ñaha Israel cuví ña, tyin ñaha ñuu Sirofenicia cuví ña. Tsaa̱ ña nu nyií ra Jesús tan caahán ndaahvi ña tsihin ra tyin na tava ra tatyi ña vaha yɨhɨ́ tsi sehe ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Maa tyin catyí ra Jesús tsihin ña: ―Ña ca̱han yuhu ca un; na catsi jihna nyɨvɨ Israel, ñi cuví sehe Nyoo, tyin ña vaha quihin nyaa yo paan yuhu sehe yo tan cuhva yo itsi catsi ina ―catyí ra Jesús tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tan nacaha̱n ña tan catyí ña: ―Nditsa, Jutu Mañi yu, maa tyin nda cuanda ina cuví ndatú tɨ tan tsatsí tɨ titsehe tsa cucoyó xuu mesa jahá sehe tsitoho tɨ ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tacan tan catyí ra Jesús tsihin ña: ―Vaha caahán un. Tan tsa cuenda tsa caahán un tacan tsa yaha̱ quita̱ tatyi ña vaha tsi sehe un. Cu̱anuhu vityin ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tan cuhva tsa tsaa̱ ña yuvehe ña, canyií taxin sehe ña nu cama, tyin tsa yaha̱ quita̱ tatyi ña vaha tsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Quita̱ nyico ra Jesús ñuhu nu canyií ñuu Tiro, tan yaha̱ ra ñuu Sidón, tan cuahán ra inga ca ñuu tsa cayucú Decápolis. Yaha̱ ra ican tan tsaa̱ ra miñi Galilea. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tsa tsaa̱ ra Jesús ican, tsaha̱n nyɨvɨ tsindaca̱ ñi iin ra soho tsa ña cuví cahan nu nyií ra. Caha̱n ndaahvi ñi tsihin ra na tyiso ra ndaha ra jiñi ra can. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tacan tan quihi̱n ra tsi ra can cuahán tsiyo tsihin ra nu nduve nyɨvɨ. Tan tyaxi̱n ra nundaha ra tsitsi soho ra can, tan tɨvɨ̱ sɨɨ ra, tan tɨɨ̱n ra nu yaa ra can. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tacan tan nanyehe̱ ndaa ra ityi andɨvɨ. Tan ixta̱ tatyi ra, tan catyí ra: ―¡Efata! ―tan tuhun ihya cuñí tsi catyí: ¡Nu̱ña! ");
INSERT INTO mjcNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tan tsihin can nuña̱ soho ra can, tan nduvaha̱ yaa ra, tan cuvi̱ nacaha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tan catyí ra Jesús tsihin ñi tyin ña cahan ñi can tsihin nyɨvɨ, maa tyin vasu ndi maa caahán ra tacan tsihin ñi, cuñihi̱ ca ñi caahán ñi tsa javaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iyo cuñí ñi tan catyí ñi: ―Tandɨhɨ tsa javahá ra tan vaha javahá ra itsi. Nyɨvɨ soho nacuñí ñi jahá ra tan nyɨvɨ ñɨɨhɨ nacahan ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Quɨvɨ can nataca̱ cuaha nyico nyɨvɨ nu nyií ra Jesús. Tan nduve maa tsa catsi ñi iyó. Tacan tan cana̱ ra Jesús tsi ra tsicá tsihin ra, tan catyí ra tsihin ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ndaahvi xaan cuñí yu nyehé yu nyɨvɨ ihya, tyin tsa uñi quɨvɨ yucú ñi tsihin yo, tan nduve ca tsa catsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tyin tun jacuhun yu tsi ñi yuvehe ñi tsa ndi cumañi ca catsi ñi, cua cúu naaha ñi ityi cuhun ñi, tyin yɨhɨ́ ñi cañi xaan quee̱ ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tan nacaha̱n ra tsicá tsihin ra, tan catyí ra naha: ―¿Maa tyin nácaa cuhva yo tsa catsi nyɨvɨ ihya, tan nduve nyɨvɨ iyó ihya tan xico ñi tsa catsi yo? ");
INSERT INTO mjcNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tan tsica̱ tuhun ra Jesús tsi ra naha, tan catyí ra: ―¿Najava paan ndahá ndo? Tan catyí ra naha: ―Utsa taahan ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tacan tan catyí ra tsihin nyɨvɨ na cunyecu ñi nu ñuhu. Tsa yaha̱ caha̱n ra yacan, tacan tan quihi̱n ra tsa utsa paan can, tan nacuhva̱ ra tyahvi nyoo tsi Nyoo tsa cuenda can. Tsahan tsahnu̱ cuatyi ra can tan tsaha̱ ra can tsi ra tsicá tsihin ra, tyin tsatsa ra naha can tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tan ndahá tucu ra naha juhva tyaca nyihi. Tsaha̱ ndɨhɨ ra Jesús tyahvi nyoo tsi Nyoo tsa cuenda can, tacan tan tsaha̱ ra can tsi ra naha tyin tsatsa ra naha tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tandɨhɨ ñi tsatsi̱ ñi, tan ndaha̱ vaha iñi ñi. Tsa ndɨhɨ̱ tsatsi̱ ñi tan jacutu̱ ra naha utsa tyica tsihin tsa ndoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tan quita̱ maa cumi mil nyɨvɨ jacatsi̱ ra. Yaha̱ can tan jacunuhu̱ ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tsa yaha̱ cuanuhu ñi, tacan tan quɨhvɨ̱ ra tsihin ra tsicá tsihin ra tsitsi iin yutun ndoo. Tan cuahán ra naha ityi Dalmanuta. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tsaa̱ ra fariseo naha ra nu nyií ra Jesús, tan quitsaha̱ caahán yuhu tahan ra naha tsihin ra. Nducú cuhva ra naha tsi ra tun nditsa tyin Nyoo jaquitsi̱ tsi ra, yacan cuenda catyí ra naha tsihin ra tyin javaha ra iin tsa iyo nyehe ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tacan tan ra Jesús ñihi xaan ixta̱ tatyi ra, tan catyí ra: ―¿Nacuenda tyin tsicán nyɨvɨ iyó vityin tsa iyo? Tsa nditsa catyí yu tsihin ndo tyin ña cua nyehe ndo ndi intuhun tsa iyo ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tacan tan nacoo̱ ra tsi ra naha, tan quɨhvɨ̱ nyico ra tsitsi yutun ndoo tan cuahán ra inga tsiyo miñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ra tsicá tsihin ra Jesús naa̱ iñi ra naha cundaha ra naha tsa catsi ra naha. Tan intuhun ñi paan ndahá ra naha yucú ra naha tsitsi yutun ndoo can. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tacan tan catyí ra Jesús tsihin ra naha: ―Ja̱ha ndo cuenda tsi ndo tsihin yutsan iya ra fariseo naha ra tan ra Herodes ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tan ra tsicá tsihin ra quitsaha̱ natuhún tahan ra naha tan catyí ra naha: ―Caahán ra tyehen tsihin yo tyin nduve paan ndahá yo catsi yo ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tsa tuvi̱ iñi ra Jesús tsa tsicá iñi ra naha, tan catyí ra tsihin ra naha: ―¿Nacuenda tsicá xaan iñi ndo tyin nduve tsa catsi ndo ndahá ndo? ¿A ñaha ca cutuñi iñi ndo? ¿A ñaha ca coto ndo? ¿Nacuenda ndi ndava xaan añima ndo? ");
INSERT INTO mjcNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nyecú tinuu ndo, tan ña nyehé ndo. Nyecú soho ndo, tan ña tsiñí ndo. ¿A ña nducuhún iñi ndo tsa javaha̱ yu ");
INSERT INTO mjcNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","quɨvɨ tsa jacatsi̱ yu uhun mil rayɨɨ tsihin uhun taahan ñi paan? ¿A ña ñuhú iñi ndo najava tyica jacutu̱ ndo tsihin tsa ndoo̱? ―catyí ra Jesús, tsica̱ tuhun ra tsi ra tsicá tsihin ra. Nacaha̱n ra naha tan catyí ra naha: ―Utsi uvi tyica. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tan catyí nyico ra Jesús tsihin ra naha: ―Tan quɨvɨ jacatsi̱ yu cumi mil nyɨvɨ tsihin utsa taahan ñi paan, ¿najava tyica jacutu̱ ndo tsihin tsa ndoo̱? Nacaha̱n ra naha tan catyí ra naha: ―Utsa taahan tyica. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tacan tan catyí ra Jesús tsihin ra naha: ―¿A ñaha ca cutuñi iñi ndo? ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tsa yaha̱ yacan tan cuahán ra Jesús tsihin ra tsicá tsihin ra nda ñuu Betsaida. Tsa tsaa̱ ra naha ican, tsindaca̱ nyɨvɨ ñuu can iin ra cuaa nu yucú ra naha. Tan caha̱n ndaahvi ñi tsihin ra Jesús tyin tɨɨn ra tsi ra cuaa can tan janduvaha ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tacan tan tɨɨ̱n ra ndaha ra cuaa can, tan quihi̱n ra tsi ra cuahán tsihin ra ityi tsata ñuu. Tyaa̱ sɨɨ ra nu ndaha ra tan tɨɨ̱n ra tinuu ra can, tan tyiso̱ ra ndaha ra soco ra can, tan tsica̱ tuhun ra tsi ra tun nditsin nyehé ra luxu. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ra cuaa can nanyehe̱ ra tan catyí ra: ―Nyehé yu juhva nyɨvɨ, tan caá ñi tumaa caá yutun, maa tyin tsicá ñi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tacan tan tɨɨ̱n nyico ra Jesús tinuu ra inga tsaha, tan nanyehe̱ vaha ra tan nduvaha̱ ra. Nanyehe̱ catsi vaha ra tandɨhɨ tsa iyó. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tacan tan jacunuhu̱ ra Jesús tsi ra yuvehe ra, tan catyí ra tsihin ra: ―Ña qu̱ɨhvɨ un tsitsi ñuu ihya tan ña na̱catyi tuhun tsehe tsihin nyɨvɨ ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yaha̱ can tan cuahán ra Jesús tsihin ra tsicá tsihin ra ñuu tsa cayucú yatyin ñi ñuu Cesarea tsa javaha̱ ra Felipe. Tsitsi tsa cuahán ra naha, tan tsica̱ tuhun ra Jesús tsi ra naha, tan catyí ra: ―¿Náa caahán nyɨvɨ tuhun yu? ¿Yóo ra cuví yu catyí ñi? ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nacaha̱n ra naha tan catyí ra naha: ―Yɨhɨ́ nyɨvɨ catyí ñi tyin ra Juan, ra jacoondutya̱ tsi nyɨvɨ, cuví un. Inga ñi catyí ñi tyin ra Elías. Yɨhɨ́ ñi catyí tucu ñi tyin inga ra cuvi̱ ndusu yuhu Nyoo cuví un ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tacan tan tsica̱ tuhun ra tsi maa ra naha, tan catyí ra: ―Tan nyooho, ¿yóo ra cuví yu, cuñí ndo? Tan nacaha̱n ra Pedro tsihin ra: ―Yooho cuví ra Cristo, ra jacacú tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Maa tyin caha̱n ra Jesús tsihin tandɨhɨ ra naha tyin ña ca̱han ra naha can tsihin ndi intuhun maa nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tacan tan quitsaha̱ jacuahá ra tyin Rayɨɨ tsa quee̱ nda gloria cua nyehe xaan ra tundoho. Tan ña cua tsinu iñi ra mandoñi naha ra tan ra jutu cuví ityi nuu tsihin ra jutu naha ra tsi ra tan ndi ra maestro cuenda ley vehe ñuhu naha ra tan ña cua naquihin cuenda ra naha tsi ra. Catyí ra Jesús tsihin ra naha tyin cua cahñi nyɨvɨ tsi ra maa tyin cua nandoto ra tsa tsinu uñi quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tacan caha̱n catsi ra tsihin ra naha. Tacan tan quihi̱n ra Pedro tsi ra cuahán tsihin ra tsata vehe tan quitsaha̱ caahán ra tsihin ra Jesús tyin ña vaha tsa caha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Maa tyin ra Jesús nanyico̱ coo ra, tan nanyehe̱ ra nu nyecú inga ra tsicá tsihin ra. Tan quitsaha̱ caahán ra tsihin ra Pedro, tan catyí ra: ―¡Cu̱atsiyo nuu yu ihya, cuihna! Tyin yooho ña tsicá iñi un tumaa tsicá iñi Nyoo, tyin tsicá iñi un tumaa tsicá iñi nyɨvɨ ―catyí ra Jesús tsihin ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tacan tan cana̱ ra Jesús tsi nyɨvɨ tan tsi ra tsicá tsihin ra tan catyí ra: ―Tatun ndáa nyooho cuñí cunyicun tsi yu, ca̱hnya iñi ndo nacoo ndo tsa cuñí maa ndo javaha ndo, tyin tacan tan cuvi javaha ndo cuhva cuñí Nyoo. Tan ña cua ndu uvi iñi ndo tsa yɨhɨ́ ndo cuenda yu, vasu ndi maa tandɨhɨ quɨvɨ nyehé ndo tundoho tsa cuenda yu. Tyin yacan cuví cruu tsa taahán tsi cuiso ndo tun cunyicun ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tyin nyooho tsa ña cuñí nyehe tundoho tan cuhva ndo ñayɨvɨ ndo tsa cuenda yu, cua nyehe ndo tundoho anyaya. Maa tyin nyooho tsa cua cuhva ñayɨvɨ tsa cuenda yu tan tsa cuenda tuhun Nyoo, cua cacu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tyin nduve yahvi nyaá cua ñihi ndo tandɨhɨ tsa iyó nu ñuhu ñayɨvɨ ihya tun ña cua cacu añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tyin nduve maa náa tsihin tyahvi ndo tan cuvi cacu añima ndo tan ña cunaa tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tyin nyɨvɨ cua nducahan nuu tsa cuenda yu tan tsa cuenda tuhun caahán yu quɨvɨ cahan ñi tsihin nyɨvɨ caquiñi tsa ña tyaá yahvi tuhun Nyoo, yuhu Rayɨɨ tsa quee̱ nda gloria cua nducahan nuu yu nyehe yu tsi ñi quɨvɨ quitsi yu tsihin ángel cuenda Nyoo Jutu yu tan tsihin tsa sɨɨ caá ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","’Tan tsa nditsa catyí yu tsihin ndo, tyin yɨhɨ́ nyooho tsa yucú ihya vityin, cua nyehe ndo nácaa ndacá ñaha Nyoo tsihin tunyee iñi ra tsa ndi cumañi ca cúu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tsa yaha̱ iñu quɨvɨ, tacan tan quihi̱n ra Jesús tsi ra Pedro, ra Jacobo, tan ra Juan cuahán tsihin ra iin yucu sucun. Ican nasama̱ cuhva caá ra tan nyehe̱ ra yucú tsihin ra can. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Xiñu̱ xaan tan cuitsin xaan jahma ra cuvi̱ tumaa cuitsin vico. Ndi intuhun maa nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya tan ña cuví janducuitsin ñi jahma tumaa cuitsin jahma ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tan nyehe̱ ra naha tyin nyaá ra Elías tan ra Moisés tsihin ra, natuhún ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tacan tan catyí ra Pedro tsihin ra Jesús: ―Maestro, ¡vaha xaan tyin yucú ndi ihya! Cua javaha ndi uñi taahan tyahva; iin tsa cuenda un, iin tsa cuenda ra Moisés, tan iin tsa cuenda ra Elías ―catyí ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Caha̱n ra tacan tyin ña tsitó ra náa cahan ra tyin maa ra tan ra yucú tsihin ra nayuhvi̱ xaan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tacan tan nuu̱ iin vico sɨquɨ ra naha tan tyasɨ̱ tsi tsi ra naha. Tan tsitsi vico can nacaha̱n iin ndusu tan catyí tsi: ―Ra ihya cuví Sehe yu, tan cuñí xaan yu tsi ra. Tya̱a yahvi ndo tsa caahán ra ―catyí ndusu can. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tan cuhva tsa nanyehe̱ ra naha, nduve ca ra Elías tan ra Moisés nyaá, intuhun ña maa ra Jesús nyaá. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tan cuhva tsa vatsí nuu ra naha yucu can, catyí ra Jesús tsihin ra naha tyin ña cahan naha ra naha tsa nyehe̱ ra naha. Cuví cahan maa ra naha can nda yaha nandoto Rayɨɨ quee̱ nda gloria, tan rayɨɨ can cuví maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yacan cuenda ña caha̱n maa ra naha tuhun can, tan natuhún tahan ra naha náa cuñí tsi catyi tuhun tsa cua nandoto ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tacan tan tsica̱ tuhun ra naha tsi ra Jesús tan catyí ra naha: ―¿Nacuenda tyin catyí ra cuví maestro cuenda ley vehe ñuhu naha ra tyin jihna ca ra Elías taahán tsi quitsi nu ñuhu ñayɨvɨ ihya inga tsaha? ");
INSERT INTO mjcNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tan nacaha̱n ra, tan catyí ra: ―Nditsa tyin jihna ca ra Elías taahán tsi quitsi tsa ndi cumañi ca quitsi yuhu tyin janduvaha ra tandɨhɨ. ¿Tan náa catyí tuhun Nyoo cuenda yuhu Rayɨɨ quee nda gloria? Catyí tsi tyin cua nyehe yu tundoho, tan ña cua cuñi nyɨvɨ nyehe ñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Maa tyin yuhu catyí yu tsihin ndo tyin tsa yaha̱ quitsi̱ ra Elías. Tan nyɨvɨ javaha̱ ñi tsihin ra cuhva cuñi̱ maa ñi, tumaa catyí maa tutu Nyoo tyin cua tahan ra ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tsa yaha̱ yacan tan cuahán ra naha nu yucú tandɨhɨ ca ra tsicá tsihin ra naha. Tsa tsaa̱ ra naha ican, nyehe̱ ra naha tyin yucú cuaha nyɨvɨ nanɨɨ canduvi. Tan yucú tucu ra maestro cuenda ley vehe ñuhu naha ra, tan caahán yuhu tahan ra naha tsihin ra tsicá tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tsa nyehe̱ nyɨvɨ can tsi ra Jesús, iyo xaan cuñí tandɨhɨ ñi cuvi̱. Tacan tan tsaha̱n ñi nu nyaá ra tsicuhva̱ ñi nacumi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tacan tan tsica̱ tuhun ra tsi ñi tan catyí ra: ―¿Nacuenda caahán yuhu tahan ndo? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tacan tan nacaha̱n iin ra tsa nyaá tyañu tandɨhɨ nyɨvɨ can, tan catyí ra: ―Maestro, vatsí yu vatsí ndacá yu sehe yu tsi un tyin yɨhɨ́ tatyi ña vaha tsi ra tan nduñɨɨhɨ̱ ra jaha̱ nu. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tyin tandɨhɨ ñi nu tɨɨ́n tatyi can tsi ra, janduvá nu tsi ra, tan quita tiñuu yuhu ra, tan jacahyú ra nuhu ra, tan janduyutún nu tsi ra. Tsa yaha̱ caha̱n yu tsihin ra tsicá tsihin un naha ra tyin tava ra naha tatyi ña vaha can, maa tyin ña cuvi̱ tava ra naha tsi nu ―catyí ra can tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nacaha̱n ra Jesús tan catyí ra: ―¡Nyooho nyɨvɨ ña tsinú iñi tan caquiñi! ¿Ndáa nda quɨvɨ cua cunyii yu tsihin ndo? ¿Tan najava ca quɨvɨ cua cunyee iñi yu nyehe yu tsi ndo tyin ña tsinú vaha iñi ndo tsi yu? Nda̱ca ndo tsi ra luhlu can tsi yu ihya ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tacan tan tsindaca̱ jutu ra luhlu can tsi ra tsi ra Jesús. Tan cuhva tsa nyehe̱ nu tatyi ña vaha can tsi ra Jesús, janduva̱ nu tsi ra luhlu can tan quitsaha̱ tsicó tuvi ra nu ñuhu jahá nu. Tan quita̱ tiñuu yuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tacan tan tsica̱ tuhun ra Jesús tsi jutu ra luhlu can tan catyí ra: ―¿Ama quitsaha̱ taahán ra tyehen? Tan nacaha̱n jutu ra luhlu can, tan catyí ra: ―Nda ndi luhlu xaan ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tan cuaha tsaha tyihi̱ tatyi ña vaha can tsi ra nu cayú ñuhu̱, tan nu ndutya. Cuñí nu cahñi nu tsi ra. Maa tyin tun cuví javaha un náa javaha un tsihin ra, cu̱ndaahvi iñi tsi ndi, tan ja̱tyinyee tsi ndi ―catyí jutu ra luhlu can tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tan catyí ra Jesús tsihin ra: ―Tun tsinú iñi un, tandɨhɨ tan cua cuvi tyin tsa cuenda ra tsa tsinú iñi tandɨhɨ tan cuví ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tacan tan cana̱ tsaa jutu ra tan catyí ra tsihin ra Jesús: ―¡Tsinú iñi yu! ¡Ja̱tyinyee tsi yu na tsinu ca iñi yu! ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cuhva tsa nyehe̱ ra Jesús tyin cuaha nyɨvɨ ndu ii̱n nu nyaá ra, tacan tan tava̱ ra tatyi ña vaha can, tan catyí ra tsihin nu: ―Yooho tatyi ña vaha tsa janduñɨɨhɨ́ tan jasohó tsi ra ihya, qu̱ita tsi ra catyí yu tsihin un. Ja̱ña tsi ra, tan ña qu̱ɨhvɨ ca un tsi ra ―catyí ra Jesús tsihin nu tatyi ña vaha can. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tacan tan quiñi xaan cana̱ tsaa nu tatyi can tan janduva̱ nu tsi ra inga tsaha, tan quita̱ nu tsi ra. Tan jacúu naaha nu tsi ra. Tan cuñí maa nyɨvɨ tyin tsa tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Maa tyin ra Jesús tɨɨ̱n ra ndaha ra luhlu can, tan cañihi̱ ra tsi ra, tan tsinyaa̱ nyityi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tacan tan quɨhvɨ̱ ra Jesús tsitsi iin vehe, tan tsica̱ tuhun ra tsicá tsihin ra tsi ra tan catyí ra naha: ―¿Nacuenda tyin ña cuvi̱ tava nyuhu tatyi ña vaha can? ");
INSERT INTO mjcNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tacan tan catyí ra Jesús: ―Tsa cuenda tyin tahan tatyi ña vaha ihya ña cuví quita nu jaha yo tun ña coonyitya yo tan ña ndacan tahvi yo tsi Nyoo ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Quɨvɨ tsa quita̱ ra Jesús ican, tan ra tsicá tsihin ra yaha̱ ra naha ñuhú Galilea. Tan ña cuñí ra Jesús tsa coto nyɨvɨ iyó ican tyin nyií ra nu iyó ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tyin jacuahá ra tsi ra tsicá tsihin ra tan catyí ra tsihin ra naha: ―Yuhu Rayɨɨ tsa quee̱ nda gloria cua nacuhva cuenda nyɨvɨ tsi yu tsi ra xaan iñi tsi yu. Tan cua cahñi ra naha tsi yu. Maa tyin cua nandoto yu tsa tsinu uñi quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Maa tyin ra ican naha ra ña cutuñí iñi ra naha tsa caahán ra tsihin ra naha. Tan ña cuñí ra naha ndaca tuhun ra naha tsi ra tyin yuuhví ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tan tsa tsaa̱ ra Jesús ñuu Capernaum tan ra tsicá tsihin ra, tsa tsa yucú ra naha tsitsi vehe, tan tsica̱ tuhun ra Jesús tsi ra naha tan catyí ra: ―¿Náa natuhún xaan ndo ityi vatsí yo? ―catyí ra tsica̱ tuhun ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tsa caha̱n ra Jesús tacan, taxin ña cuvi̱ ra naha, tyin ityi vatsí ra naha natuhun ra naha yóo ra cahnu ca cuví tsa nuu tandɨhɨ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tacan tan tsinyaa̱ ra Jesús tan cana̱ ra tsi tandɨhɨ tsa utsi uvi ra tsicá tsihin ra, tan catyí ra tsihin ra naha: ―Nyooho tsa cuñí cuvi ityi nuu, cuñí tsi cuví ndo nda nu ndɨhɨ ña tsa nuu tandɨhɨ ndo, tan jatyinyee ndo tsi tandɨhɨ nyɨvɨ ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tacan tan quihi̱n ra iin ra luhlu tyaa̱ ra mahñu ra naha. Tan tyihi̱ jucun ndaha ra tsi ra luhlu can, tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nyɨvɨ naquihin iin nyɨvɨ tumaa ra luhlu ihya, yuhu naquihin cuenda ñi. Tyin naquihin cuenda ñi tsi ñi tsa cuenda tsa cuñí ñi tsi yu. Tan nyɨvɨ naquihin cuenda tsi yuhu, naquihin cuenda tucu ñi tsi ra tsa jaquitsi̱ tsi yu tan ñavin maa ñi maa yu naquihin cuenda ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tacan tan catyí ra Juan tsihin ra Jesús: ―Maestro, nyehe̱ ndi iin ra tavá tatyi ña vaha tsi nyɨvɨ tsihin sɨvɨ un. Maa tyin tyasɨ̱ ndi nu javaha ra tacan tyin ñavin tsihin yo tsicá ra ―catyí ra Juan tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Maa tyin catyí ra Jesús tsihin ra: ―Ña ca̱sɨ ndo nu javaha nyɨvɨ tacan. Tyin ndi intuhun ñi tsa javaha tsa iyo tsihin sɨvɨ yu tan ña cua cana iñi ñi cahan ñi ndavaha ñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tyin nyɨvɨ tsa ña xaan iñi tsi yo, tsihin yo cutahán ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tan nyɨvɨ tsa cua cuhva vasu tan iin yatsin ndutya coho ndo tyin tsinú iñi ndo tsi yu, cua cuhva Nyoo tsa cua cuhva ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Nyɨvɨ cua natyuhu tsi iin nyɨvɨ tsa ñaha ca tsinú vaha iñi tsi yu tyin javaha ñi tsa caquiñi, vaha ca cuhñi nyɨvɨ yuu yoso vee jucun ñi tan cujanehñi ñi tsi ñi tsitsi nu cunu ndutya ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tatun ndaha un javahá tsa ña vaha, ca̱sɨ nu javahá can tacan. Tatun ña cuví, ca̱hnya can tan ja̱vita un, tyin vaha ca quɨhvɨ un coo un tsihin Nyoo tsihin tsa nduve iin ndaha un tan ñavin ca tsa cuhun un anyaya nu cayú ñuhu̱ tsa ña cua ndahva maa tsihin nduvi ndaha un. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tyin tindacu tsa iyó ican ña cua cúu maa can, tan ña cua ndahva maa ñuhu̱ ndi iin tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tatun tsaha un tan javahá tsa ña vaha, ca̱sɨ nu javahá can tacan. Tatun ña cuví, ca̱hnya can tan ja̱vita un, tyin vaha ca cuhun un coo un tsihin Nyoo tsihin tsa intuhun ñi tsaha un tan ñavin ca tsa cuhun un tsihin nduvi tsaha un anyaya nu ña cua ndahva maa ñuhu̱. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tyin tindacu tsa iyó ican ña cua cúu maa can, tan ña cua ndahva maa ñuhu̱ ndi iin tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tun tinuu un javahá tsa ña vaha, ca̱sɨ nu javahá can tacan. Tatun ña cuví, ta̱va can tan ja̱vita un tyin vaha ca quɨhvɨ un nu ndacá ñaha Nyoo tsihin iin tinuu un tan ñavin ca tsa jacuhun Nyoo tsi un anyaya tsihin nduvi tinuu un. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tyin tindacu tsa iyó ican ña cua cúu maa can, tan ña cua ndahva maa ñuhu̱ ndi iin tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Maa tyin tandɨhɨ nyɨvɨ nyicún tsi yuhu, ñi tsa nyehé tundoho tsa cuenda yu cuví tsi tumaa tsa cayú ñi tsihin ñuhu̱, tyin tsihin yacan cua nduvaha ñi jahá Nyoo, tumaa tuhvá nyayu nduvahá tsihin ñɨɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Vaha xaan ñɨɨ. Maa tyin tun ndɨhɨ tsa uhva tsi, ña jandu uhva ca tsi tan ña cuvi ca cuatyiñu nyɨvɨ itsi. Yacan cuenda nyooho, ña jandɨhɨ ndo tsa coo tuhun Nyoo añima ndo tyin cuví tsi tumaa ñɨɨ. Tyin tacan tan cuvi coo taxin ndo tsihin tahan ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Quita̱ ra Jesús ñuu Capernaum tan cuahán ra cuenda Judea inga tsiyo yutya Jordán. Tan ndu ii̱n cuaha nyico nyɨvɨ nu nyií ra, tacan tan quitsaha̱ jacuahá ra tsi ñi tumaa tuhvá maa ra javahá. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tacan tan natuhva̱ juhva ra fariseo naha ra nu nyaá ra Jesús, tan nducú ra naha cuhva tyaa ra naha cuatyi tsi ra. Tan tsica̱ tuhun ra naha tsi ra tatun vaha nacoo rayɨɨ ñasɨɨhɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tacan tan nacaha̱n ra Jesús tan catyí ra: ―¿Náa catyi̱ ra Moisés tyin javahá ndo? ");
INSERT INTO mjcNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tan nacaha̱n ra naha tan catyí ra naha: ―Ra Moisés catyi̱ ra tyin cuví canɨ ndi tutu cuenda ley ndi, tacan tan cuvi nacoo ndi ñasɨɨhɨ ndi ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tacan tan catyí ra Jesús tsihin ra naha: ―Catyi̱ ra Moisés tyin cuví javaha ndo tacan tsa cuenda tsa ndava añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Maa tyin quɨvɨ jihna ñi, quɨvɨ javaha̱ Nyoo tandɨhɨ maa tsa iyó, catyí nu tutu ra tyin javaha̱ ra rayɨɨ tan ñaha. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Yacan cuenda taahán tsi nacoo rayɨɨ jutu ra tan sɨhɨ ra tan ndu iin ra tsihin ñasɨɨhɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Tan nduvi ñi cua cuvi ñi tumaa intuhun ña nyɨvɨ.” Yacan cuenda ñavin ca uvi taahan ñi, tyin intuhun ña nyɨvɨ cua cuvi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yacan cuenda, ña cuví jasɨɨn nyɨvɨ tsa jandu ii̱n Nyoo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yaha̱ can tan cuanuhu̱ ra nda yuvehe, tan quitsaha̱ nducú tuhun nyico ra tsicá tsihin ra sɨquɨ tuhun can. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tan catyí ra Jesús tsihin ra naha: ―Ra tsa cua nacoo ñasɨɨhɨ tan quihin ra inga ñaha, cua coo cuatyi ra nu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tacan tucu ñi ñaha: Tun nacoo ña tsi yɨɨ ña tan tindaha ña tsihin inga rayɨɨ, juvin ñi cua coo tucu cuatyi ña ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tacan tan tsindaca̱ nyɨvɨ juhva tsa nyihi tsi ra Jesús tyin tyiso ra ndaha ra jiñi tsi naha tsi tan nasoco ra tsi naha tsi. Maa tyin ra tsicá tsihin ra quitsaha̱ cuxaán ra naha tsi nyɨvɨ cuahán cuandacá tsa nyihi. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Maa tyin tsa nyehe̱ ra Jesús tsa javahá ra naha tacan, cuxaa̱n ra tsi ra naha, tan catyí ra: ―Cu̱hva ndo tsa quitsi tsa nyihi nu nyaá yu. Ña ca̱sɨ ndo itsi naha tsi tyin nyɨvɨ ndacá ñaha Nyoo cuví ñi tumaa cuví tsa nyihi tyin tsinú iñi ñi tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tan tsa nditsa catyí yu tsihin ndo tun ña cuita iñi nyɨvɨ tsi Nyoo tumaa nyitá iñi iin ra luhlu tsi jutu ra, ña cua cuvi quɨhvɨ ñi nu ndacá ñaha Nyoo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tacan tan quihi̱n ra intuhun intuhun tsa nyihi can tan tyiso̱ ndaha ra jiñi tsi naha tsi, tan tsica̱n tahvi ra tsi Nyoo na nasoco̱ ra itsi naha tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yaha̱ yacan tan cuahán ra Jesús. Tan tsinú xaan iin rayɨɨ cuahán ra cuanyicún ra tsi ra. Tsa taha̱n ra tsi ra, tsicuɨñɨ̱ tsɨtɨ ra nuu ra, tan tsica̱ tuhun ra tsi ra, tan catyí ra: ―Maestro, vaha xaan un. ¿Náa taahán tsi javaha yu tan cuvi coo yu ñayɨvɨ nyito tsa ña cua naa maa? ―catyí ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tan catyí ra Jesús tsihin ra: ―¿Nacuenda catyí un tyin ra vaha cuví yu? Tan intuhun ñi ra vaha iyó tan ra ican cuví Nyoo. Tan tsa catyí un tyin vaha yu, nacotó un tyin Nyoo cuví yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yooho tsitó un tsa catyí Nyoo tyin javaha yo: “Ña coo inga ñaha tsi un. Ña cahñi un nyɨvɨ. Ña suhu un. Ña cahan un cuendu. Ña jandavi ñaha un tsi nyɨvɨ. Tya̱a yahvi tsi jutu un tan tsi sɨhɨ un” ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nacaha̱n ra tan catyí ra: ―Maestro, tandɨhɨ tuhun ihya tan tyaá yahvi yu itsi nda ndi luhlu yu tan nda cuanda vityin ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tacan tan sɨɨ cuñí ra Jesús nyehé ra tsi ra. Tan catyí ra tsihin ra: ―Intuhun ña tsa cumañi javaha un. Cu̱aahan yuvehe un tan xico un tandɨhɨ tsa iyó tsi un, tan cuhva un xuhun can tsi nyɨvɨ ndaahvi. Tacan tan coo tsa cuca tsi un nda gloria. Yaha can tan quitsi un quitsi nyicun un tsi yu vasu ndi maa nyehe un tundoho tan cahñi nyɨvɨ tsi un ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tsa tsiñi̱ ra tyuvaa can tsa caha̱n ra Jesús tacan, cuiihya xaan cuñí ra cuvi̱, tan tsihin tucuiihya iñi cuanuhu̱ ra yuvehe ra tyin cuca xaan ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tacan tan nanyehe̱ ra Jesús nanɨɨ canduvi nu nyaá ra, tan catyí ra tsihin ra tsicá tsihin ra: ―¡Yɨɨ xaan tan cuvi nacuhva cuenda nyɨvɨ cuca tsi ñi tsi Nyoo na cundaca ñaha ra tsi ñi! ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tsa tsiñi̱ ra tsicá tsihin ra tsa caahán ra, iyo xaan cuñí ra naha cuvi̱. Maa tyin catyí tucu ra tsihin ra naha inga tsaha: ―¡Sehe yu, nyɨvɨ tyaá xaan jiñi tandɨhɨ tsa cuca, yɨɨ xaan tan quɨhvɨ ñi nu ndacá ñaha Nyoo! ");
INSERT INTO mjcNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yatyi ca cuvi yaha iin camellu xuu iin yɨquɨ tucu, tan ñavin ca tsa quɨhvɨ iin nyɨvɨ cuca nu ndacá ñaha Nyoo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tsa tsiñi̱ ra naha tuhun ihya, iyo xaan cuñí ra naha cuvi̱, tan quitsaha̱ tsicá tuhun tahan ra naha, tan catyí ra naha: ―Tun tacan, ¿yóo cua cacu? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tacan tan nanyehe̱ ra Jesús tsi ra naha tan catyí ra tsihin ra naha: ―Nyɨvɨ ña cuví javaha ñi tsehe, maa tyin Nyoo cuví javaha ra tyin tsa cuenda Nyoo nduve maa tsa yɨɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tacan tan catyí ra Pedro tsihin ra: ―Jutu Mañi yu, tandɨhɨ maa tsa iyó tsi ndi nacoo̱ ndi can tan nyicún ndi tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nacaha̱n ra Jesús tan catyí ra: ―Tsa nditsa catyí yu tsihin ndo tyin tandɨhɨ nyooho tan tandɨhɨ inga ca nyɨvɨ tsa cua nacoo vehe, o yañi, o cuhva, o jutu, o sɨhɨ, o ñasɨɨhɨ, o sehe, o ñuhu, tsa cuenda yuhu tan tsa cuenda tsa jacoto ñi tsi nyɨvɨ tyin cuñí Nyoo jacacu ra tsi ñi, ");
INSERT INTO mjcNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cua ñihi ñi cientu ca tsaha sɨquɨ tsa nacoo̱ ñi nu ñuhu ñayɨvɨ ihya. Cua ñihi ñi vehe, cua ñihi ñi nyɨvɨ cua cuvi yañi ñi, cuhva ñi, sɨhɨ ñi, sehe ñi, tan cua ñihi tucu ñi ñuhu ñi, vasu ndi maa cua janyehe nyɨvɨ tundoho tsi ñi. Tan nu inga ñuhu ñayɨvɨ tsaa tsa vatsí, cua ñihi ñi ñayɨvɨ nyito tsa ña cua naa maa coo ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Cuaha ñi nyɨvɨ cuahán ityi nuu vityin, cua cuhun ñi nda nu ndɨhɨ ña. Tan nyɨvɨ cuahán nu ndɨhɨ ña vityin, cuaha ñi cua cuhun ityi nuu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tsa tsa cuñí cuhun ra Jesús tan ra tsicá tsihin ra ñuu Jerusalén, cuahán ra Jesús ityi nuu tandɨhɨ nyɨvɨ tsa cuahán cuanyicún tsi ra. Iyo xaan cuñí ñi tan tsihin tsa yuuhví ñi cuahán ñi. Tacan tan tava̱ sɨɨn ra tsi tsa utsi uvi ra tsicá maa tsihin ra. Tan quitsaha̱ catyí tuhun ra tsihin ra naha tsa cua tahan ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tan catyí ra: ―Vityin tsa cua cuyatyin yo ñuu Jerusalén nu cua nacuhva cuenda nyɨvɨ tsi yuhu, Rayɨɨ quee̱ nda gloria. Cua cuhva cuenda ñi tsi yu tsi ra jutu cuví ityi nuu naha ra, tan tsi ra maestro cuenda ley vehe ñuhu naha ra. Ra ihya naha ra cua catyi ra naha tyin taahán tsi cúu yu tan cua nacuhva cuenda ra naha tsi yu tsi ra ñuu Roma naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cua vacu nducu ra naha tsi yu, cua cañi ra naha tsi yu, cua tɨvɨ sɨɨ ra naha tsi yu. Tan cua cahñi ra naha tsi yu. Maa tyin cua nandoto yu tsa tsinu uñi quɨvɨ ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tacan tan ra Jacobo tan ra Juan, sehe ra Zebedeo, natuhva̱ ra naha nu nyaá ra Jesús, tan catyí ra naha tsihin ra: ―Maestro, ja̱ha tumañi iñi tan javaha un tsa cua ndacan ndi tsi un ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tacan tan tsica̱ tuhun ra Jesús tsi ra naha tan catyí ra: ―¿Náa cuñí ndo javaha yu? ");
INSERT INTO mjcNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tan nacaha̱n ra naha tan catyí ra naha: ―Cuñí ndi tsa cuhva un cunyecu ndi tsihin un nu ndacá ñaha un, iin ndi xiin cuaha un, tan inga ndi xiin satyin un ―catyí ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tacan tan catyí ra Jesús tsihin ra naha: ―Nyooho ña tsitó ndo náa tsicán ndo. ¿A cuví nyehe ndo tundoho tsa cua nyehe yuhu? ¿A cuví cúu ndo tumaa cua cúu yu? ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tan nacaha̱n ra naha: ―Cuví maa. Tan catyí ra Jesús ―Nditsa tyin cua nyehe ndo tundoho tan cua cúu ndo tumaa cua tahan yuhu. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Maa tyin tsa cunyaa iin ndo xiin cuaha yu tan iin ndo xiin satyin yu, ñavin yuhu taahán tsi cuhva yacan, tyin maa Nyoo cua catyi yóo cua ñihi can ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tsa tsiñi̱ tsa utsi ca ra tsicá tsihin ra Jesús yacan, cuxaa̱n ra naha tsi ra Jacobo tan ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Maa tyin cana̱ ra Jesús tsi ra naha tan catyí ra tsihin ra naha: ―Tsa tsitó ndo tyin ra ndacá ñaha tsi nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya, ñihi xaan ndacá ñaha ra naha tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Maa tyin ñavin tacan taahán tsi javaha nyooho tyin ra tsa cuñí cuvi ra cahnu ityi nuu Nyoo, cuñí tsi cuvi ra musu tandɨhɨ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tan nyooho tsa cuñí cuví ityi nuu, cuñí tsi cuví ndo musu tandɨhɨ ca ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tyin yuhu, Rayɨɨ tsa quee̱ nda gloria, ña vatsí yu tyin cuñí yu jatyinyee nyɨvɨ tsi yu. Yuhu vatsí yu vatsí jatyinyee yu tsi maa ñi tan cuhva yu ñayɨvɨ yu tsa cuenda ñi tumaa iin tsa tyahvi yu tan jacacu yu cuaha ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tacan tan tsaa̱ ra naha ñuu Jericó. Tan yaha ñi ra naha ñuu can. Tan cuhva tsa cua quita ra Jesús ñuu can tsihin ra tsicá tsihin ra, cuaha nyɨvɨ cuahán cua nyicun tsi ra naha. Tan ityi yaha̱ ra naha nyaá iin ra cuaa nañí Bartimeo, sehe ra Timeo, tsicán ra caridaa. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tan cuhva tsa tsito̱ ra cuaa can tyin tsa cua cuyatyin yaha ra Jesús, ra ñuu Nazaret, nu nyaá ra, quitsaha̱ caná tsaa ra, tan catyí ra: ―¡Jesús, tata ra David, cu̱ndaahvi iñi tsi yu! ―catyí ra caná tsaa ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tacan tan quitsaha̱ cuxaan nyɨvɨ tsi ra tan catyí ñi tsihin ra na cutaxin ra, maa tyin cuñihi̱ ca ra caná tsaa ra tan catyí ra: ―¡Tata ra David, cu̱ndaahvi iñi tsi yu! ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tacan tan tsicuɨñɨ̱ ra Jesús tan catyí ra: ―Cu̱aquihin ndo tsi ra. Tan tsiquihi̱n ra naha tsi ra cuaa can tan catyí ra naha tsihin ra: ―Ja̱ndu iin iñi un. Ndu̱vita, co̱hon tyin caná ra tsi un ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tacan tan janehñi̱ ra jahma ndasɨ ra nda sava. Tan cuahan ra iin yaha ñi nda nu nyaá ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tacan tan tsica̱ tuhun ra Jesús tsi ra: ―¿Náa cuñí un javaha yu? Tan nacaha̱n ra cuaa can tan catyí ra: ―Maestro, cuñí yu janduvaha un tinuu yu na nanyehe nyico yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tan catyí ra Jesús tsihin ra: ―Cu̱anuhu. Tsa nduvaha̱ un tyin tsinú iñi un tsi yu. Juvin ñi cuhva can tan nanyehe̱ ra can. Tan cueta cuahán ra cuanyicún ra tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tsa tsa cuñi tsaa ra Jesús tan nyɨvɨ nyicún tsi ra nda ñuu Jerusalén, yatyin nu canyií ñuu Betfagé tan ñuu Betania, tan yatyin ñi yucu nu iyó yutun Olivo, tan catyí ra Jesús tsihin uvi ra tsicá tsihin ra: ");
INSERT INTO mjcNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","―Cu̱aahan ndo ñuu tsa canyií ityi nuu ihya. Tsa tsaa ndo ican cua nañihi ndo iin urru. Quɨtɨ yoco cuví tɨ, nyaá tɨ nuuhñí tɨ, tan ñaha ca quɨhɨ tyayu tɨ. Nda̱tsi ndo tsi tɨ, tan qu̱ihin ndo tsi tɨ quitsi ndaca ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tatun cusana ndaca tuhun nyɨvɨ tsi ndo: “¿Nacuu ndo urru ihya?” Tacan tan ca̱tyi ndo tsihin ñi: “Tsiñí ñuhu tɨ tsi Jutu Mañi yo, maa tyin cua jaquitsi nyico ñi maa ra tsi tɨ”, ca̱tyi ndo tsihin ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tacan tan cuahán ra naha, tan tsa tsaa̱ ra naha, nañihi̱ ra naha urru can nuuhñí tɨ tsitsi ityi tsata yuhu iin cora. Tan ndatsi̱ ra naha tsi tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tan catyí juhva ra yucú ican naha ra tsihin ra naha: ―¿Náa javahá ndo? ¿Nacuenda ndatsí ndo urru can? ―catyí ra naha tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tacan tan nacaha̱n ra naha tumaa caha̱n ra Jesús tsihin ra naha. Tan tsaha̱ ra can naha ra quihin ra naha urru can. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tacan tan tsindaca̱ ra naha urru can tsi ra Jesús. Tyiso̱ ra naha jahma ra naha tsata tɨ, tan tsicoso̱ ra Jesús tsi tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tan tsaqui̱n cuaha nyɨvɨ jahma ñi tsitsi ityi nu yaha̱ ra, tan inga ñi tsahnya̱ ñi ndaha yutun tan tsaqui̱n ñi tsitsi ityi. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tacan tan nyɨvɨ tsa cuahán ityi nuu ra tan ityi tsata ra, quitsaha̱ caná tsaa ñi tan catyí ñi: ―¡Cahnu xaan cuví Nyoo! ¡Na jacahnu yo tsi Jutu Mañi yo, ra tsa jaquitsi̱ Nyoo! ");
INSERT INTO mjcNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Na jacahnu yo tsi ra vatsí cundaca ñaha tumaa tsindaca̱ ñaha ra David, tsii tsaahnu yo! ¡Cahnu xaan cuví ra nyaá gloria! ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tacan tan quɨhvɨ̱ ra Jesús tsitsi ñuu Jerusalén, tan cuahán ra vehe ñuhu cahnu. Tan tsa yaha̱ nyehe̱ ra tandɨhɨ tsa iyó nuquehe vehe ñuhu can, cuahán ra ñuu Betania tsihin tsa utsi uvi ra tsicá tsihin ra tyin tsa cueñi xaan. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tsa tuvi inga quɨvɨ tsa quita̱ ra Jesús tan ra tsicá tsihin ra ñuu Betania, tsaa̱ soco tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tsa quita̱ ra naha ndasava nyehe̱ ra Jesús nu nyaá iin yutun higo tsa iyó numa. Tsaha̱n ra tsinyehe̱ ra tun iñi tsɨtɨ tun, maa tyin nduve tsɨtɨ tun, maa ñi maa ndaha tun iñí, tyin ñaha ca tahan tsi quɨvɨ cuhva tun tsɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tacan tan caha̱n ra Jesús tsi tun, tan catyí ra: ―Ndi iin sava ca quɨvɨ ña cua quee ca tsɨtɨ catsi nyɨvɨ nuu un ―catyí ra tsihin tun. Tan tsiñí ra tsicá tsihin ra tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tsa tsaa̱ ra naha ñuu Jerusalén, cuahán nyico ra Jesús vehe ñuhu cahnu tan quitsaha̱ jacunú ra nyɨvɨ xicó tan jatá tsa yucú nuquehe yuvehe ñuhu can. Janduva̱ ra mesa nu nyecú nyɨvɨ samá xuhun nyɨvɨ. Tan janduva̱ tucu ra tyayu nu nyecú nyɨvɨ xicó paloma. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tan ña tsaha̱ ca ra yaha sava ñi nuquehe vehe ñuhu can tsihin ndaha tyiñu. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tan quitsaha̱ jacuahá ra tsi nyɨvɨ, tan catyí ra: ―¿A ña tsitó ndo tyin nu tutu Nyoo catyí tsi tyin vehe Nyoo cua cunañi tsi tyehen: “vehe nu cua ndacan tahvi nyɨvɨ queé nanɨɨ nu ñuhu ñayɨvɨ tsi Nyoo”? Tan nyooho jananduvi̱ ndo itsi vehe ñasuhu ―catyí ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tsa tsiñi̱ ra jutu cuví ityi nuu naha ra tan ra maestro cuenda ley vehe ñuhu naha ra tsa caahán ra, tan quitsaha̱ nducú ra naha cuhva cahñi ra naha tsi ra tyin yuuhví ra naha nyehe ra naha tsi ra tsa cuenda tsa janahá ra tsi nyɨvɨ tan yuuhví tucu ra naha tyin tsa cuaha xaan nyɨvɨ nyicún tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Maa tyin tsa tsa cuñí cuaa, quita̱ ra Jesús ñuu can tsihin ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tsa tuvi inga quɨvɨ, yaha̱ nyico ra naha nu nyaá yutun higo tsa caha̱n ra Jesús. Tan nyehe̱ ra naha tyin na ityi tun tan nda cuanda yoho tun na ityi. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tacan tan tsa nyehe ra Pedro yutun higo can, nducuhu̱n iñi ra tsa javaha̱ ra Jesús tan catyí ra tsihin ra Jesús: ―¡Maestro, jihna! Tsa na ityi̱ yutun tsa caha̱n un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nacaha̱n ra Jesús, tan catyí ra: ―Tsi̱nu iñi ndo tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tyin tsa nditsa catyí yu tsihin ndo tyin nyɨvɨ cua cahan tsihin yucu ihya tyehen: “Cu̱atsiyo ihya tan cu̱aahan tsitsi ndutya ñuhu”, tan tatun tsinú iñi ñi tyin cua cundaa tsa caha̱n ñi tan ña uvi tsicá iñi ñi, cua cundaa tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yacan cuenda catyí yu tsihin ndo tyin tandɨhɨ tsa cua ndacan ndo tsi Nyoo tsa cua ndacan tahvi ndo tsi ra, tun tsinú iñi ndo tyin tsa naquihi̱n cuenda ndo can, cua naquihin ndo can. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tan tsa cua ndacan tahvi ndo tsi Nyoo, tun nducuhún iñi ndo tyin xaan cuñí ndo tsihin nyɨvɨ, ja̱ha ndo tucahnu iñi tsi ñi, tyin tacan tan jaha Jutu ndo, ra nyaá gloria, tucahnu iñi tsi maa ndo tsa cuenda cuatyi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Maa tyin tun ña jaha ndo tucahnu iñi tsi nyɨvɨ, ndi Jutu ndo, ra nyaá gloria, tan ña cua jaha ra tucahnu iñi tsi maa ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tacan tan tsaa̱ nyico ra naha ñuu Jerusalén. Tsa nyií ra Jesús tsicá nuu ra nuquehe vehe ñuhu cahnu, natuhva̱ ra jutu cuví ityi nuu naha ra, tan ra maestro cuenda ley vehe ñuhu naha ra, tan ra mandoñi nyɨvɨ Israel naha ra nu nyaá ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tan tsica̱ tuhun ra naha tsi ra tan catyí ra naha: ―¿Yóo tava̱ tyiñu tsi un tsa javahá un tyehen? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Tan nacaha̱n ra Jesús, tan catyí ra: ―Cuñí tucu yuhu ndaca tuhun yu tsa ndaca tuhun yu tsi nyooho. ¿Yóo jaquitsi̱ tsi ra Juan tyin jacoondutya ra tsi nyɨvɨ? ¿A Nyoo o nyɨvɨ? Tatun catyi tuhun ndo tsihin yu yóo jaquitsi̱ tsi ra, cua catyi tuhun tucu yuhu tsihin nyooho yóo tava̱ tyiñu tsi yu javahá yu tyehen ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tacan tan quitsaha̱ caahán yuhu tahan ra naha, tan catyí ra naha: ―Tun catyi yo tyin Nyoo jaquitsi̱ tsi ra Juan, cua catyi ra tsihin yo tyehen: “Tun Nyoo jaquitsi̱ tsi ra, ¿nacuenda ña tsinu̱ iñi ndo tsa caha̱n ra?” ");
INSERT INTO mjcNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿A vaha tun catyi yo tyin nyɨvɨ jaquitsi̱ tsi ra? Ña cuvi ―catyí ra naha, tyin yuuhví ra naha tsi nyɨvɨ, tyin tandɨhɨ ñi tan tsinú iñi ñi tyin ndusu yuhu Nyoo cuvi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tacan tan catyí ra naha tsihin ra Jesús: ―Ña tsitó ndi. Tacan tan catyí ra Jesús tsihin ra naha: ―Tun ña tsitó ndo, ndi yuhu tucu, tan ña cua catyi tuhun yu tsihin ndo yóo tava̱ tyiñu tsi yu tsa javahá yu tyehen ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tacan tan quitsaha̱ caahán ra Jesús tsihin ra naha tsihin cuhva ihya, tan catyí ra: ―Tsicoo̱ iin rayɨɨ tsa tatsi̱ yoho yucu vixi tsa nañí uva, ra ican tyasɨ̱ ra iin cora nanɨɨ canduvi nu tatsi̱ ra yucu vixi can. Tan javaha̱ ra iin nu cua tava ra ndutya uvas can. Tan javaha̱ tucu ra iin vehe sucun tyin tacan tan cuvi jaha cuenda ra nanɨɨ cahnu nu ndaha tyiñu ra. ’Tsa yaha̱ yacan tan tsaha̱ nuu ra ñuhu can tsi juhva rayɨɨ tyin jaha tyiñu ra naha tsihin tsi. Tacan tan cuahán ra inga ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tsa taha̱n tsi quɨvɨ iyó uvas can, jacuhu̱n ra iin musu ra tyin ndacan ra juhva tsa taahán tsi tsi ra tsi ra jahá tyiñu can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Maa tyin ra ican naha ra tɨɨ̱n ra naha tsi ra. Tan cañi̱ ra naha tsi ra. Tan jacunuhu̱ ra naha tsi ra tsihin ndaha ndɨɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tacan tan tsitoho ñuhu can jacuhu̱n nyico ra inga musu, maa tyin cañi̱ ra naha tsi ra can tsihin yuu, tan tahvi̱ ra naha jiñi ra, tan caha̱n nyaa ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tsitoho ñuhu can jacuhu̱n nyico ra inga musu. Tan tsahñi̱ ra naha tsi ra. Yaha̱ yacan tan cuaha ca ra naha jacuhu̱n ra. Maa tyin cañi̱ ra naha tsi juhva ra naha tan tsahñi̱ ra naha juhva ca ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Tan cumañi intuhun ña ra tsa cuví jacuhun ra. Tan ra ican cuví sehe ra tsa cuñí xaan ra. Nu ndɨhɨ tuhun jacuhu̱n ra sehe ra tyin cuñí maa ra tsicá iñi ra: “Tun jacuhun yo sehe yo, cua tyaa yahvi ra naha tsi ra tyin sehe yo cuví ra”, cuñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Maa tyin tsa nyehe̱ ra jahá tyiñu can naha ra tsi ra sehe ra, natuhu̱n tahan ra naha tan catyí ra naha: “Ra ihya cua naquihin cora ihya. Yacan vaha ca cahñi yo tsi ra, tan ndoo maa yo tsihin can”, catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tacan tan tɨɨ̱n ra naha tsi ra tan tsahñi̱ ra naha tsi ra. Tan tava̱ ra naha cuñu ñuhu ra ityi tsata cora can ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tacan tan tsica̱ tuhun ra Jesús tsi ra naha tan catyí ra: ―¿Náa cua javaha tsitoho ñuhu can? Cua cuhun ra tan cua cahñi ra tsi ra jahá tyiñu can naha ra. Tan cua cuhva nuu ra ñuhu can tsi inga ca ra naha tyin jaha tyiñu ra naha tsihin can. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿A ñaha ca cahví ndo nu tutu Nyoo nu catyí tsi tyehen? Yuu tsa javita̱ ra javahá vehe naha ra, yacan cuví yuu tsa tsiñí ñuhu ca. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maa Nyoo Jutu yo jaha̱ tsa cahnu ca cuví yuu ihya. Tan iyo xaan cuñí yo nyehé yo can, catyí tsi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tacan tan ra jutu cuví ityi nuu naha ra, tan ra maestro cuenda ley vehe ñuhu naha ra, tan ra mandoñi naha ra nducu̱ ra naha cuhva tyihi ra naha tsi ra Jesús vehe caa tyin tsitó ra naha tyin tuhun maa ra naha caahán ra tsa tsatyiñu̱ ra cuhva can. Maa tyin ña tɨɨ̱n ra naha tsi ra tyin yuuhví ra naha nyehe ra naha tsi nyɨvɨ. Nacoo̱ ra naha tsi ra, tan cuahán ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tacan tan jacuhu̱n ra naha juhva ra yɨhɨ cuenda ra Herodes tan juhva ra fariseo naha ra nu nyií ra Jesús tyin nducu ra naha cuhva cahan ra Jesús iin tsa ña vaha tyin tacan tan cuvi tyaa ra naha cuatyi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tsa tsaa̱ ra can naha ra tan quitsaha̱ caahán ra naha tsihin ra Jesús tan catyí ra naha: ―Maestro, tsitó ndi tyin tsa nditsa caahán un. Tan inducu ñi cuñí un nyehe un nyɨvɨ cuca tan nyɨvɨ ndaahvi. Tan nditsa tyin ityi Nyoo janahá un. Yacan cuenda cuñí ndi ndaca tuhun ndi tsehe tsi un: ¿A vaha cuhva yo tsa tsicán ra ndacá ñaha tsi yo, ra tsa nyaá nda ñuu Roma, o ña vaha? ¿A taahán tsi tyahvi yo can, o ña taahán tsi? ―catyí ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tan tsitó ra Jesús tyin ñavin tsa vaha tsicá iñi ra naha, yacan cuenda catyí ra tsihin ra naha: ―¿Nacuvi tyin nducú cuhva ndo tsi yu? Nda̱ca ndo iin xuhun tsi yu ihya, na nyehe yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tsindaca̱ ra naha xuhun can tsi ra. Tsa nyehe̱ ra can tan tsica̱ tuhun ra tsi ra naha, tan catyí ra: ―¿Yóo nuu tan yóo sɨvɨ nyaá tsata xuhun ihya? ―catyí ra tsihin ra naha. Nacaha̱n ra naha tan catyí ra naha: ―Nuu ra ndacá ñaha tan sɨvɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tacan tan catyí ra Jesús tsihin ra naha: ―Tun tacan, cu̱hva ndo tsa tsii ra ndacá ñaha tsi ra, tan cu̱hva ndo tsa tsii Nyoo tsi Nyoo ―catyí ra Jesús tsihin ra naha. Tan iyo xaan cuñí ra naha tsihin tsa nacaha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tacan tan cuahán juhva ra saduceo naha ra nu nyií ra Jesús. Tan ra saduceo can naha ra catyí ra naha tyin ña cua nandoto nyɨvɨ. Yacan cuenda caha̱n ra naha tyehen tan catyí ra naha tsihin ra Jesús: ");
INSERT INTO mjcNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, ra Moisés tyaa̱ ra nácaa taahán tsi javaha yo tatun iin rayɨɨ tsihi̱ tan ndoo̱ ñasɨɨhɨ ra tan nduve sehe ña tsicoo̱ tsihin ra. Catyí ra tyin taahán tsi tindaha yañi ra tsihin ñaha can. Tyin tacan tan cua coo sehe ra tsihin ña tsa cuenda ra yañi ra tsa tsihi̱. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Iin tsaha iin rayɨɨ tsicoo̱ utsa sehe yɨɨ ra. Ra tsa jihna ñi tindaha̱ ra tsihin iin ñaha, maa tyin nduve sehe ra tsicoo̱ tsihin ña, tan tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tacan tan tindaha̱ ra yañi ra tsa tsinu uvi tsihin ñaha tsa ndoo̱ can. Maa tyin juvin ñi ña tsicoo̱ sehe ra tsihin ña tan tsihi̱ ra. Juvin ñi tacan taha̱n tucu ra tsa tsinu uñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tandɨhɨ tsa utsa ra naha tindaha̱ ra naha tsihin ñaha can. Tan ndi intuhun ra naha tan ña tsicoo̱ sehe ra naha tsihin ña. Tan nu ndɨhɨ tuhun, tsihi̱ ndɨhɨ maa ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tan vityin, tun nditsa tsa cua nandoto nyɨvɨ, ¿ndáa tsa utsa taahan ra can naha ra cua cuvi yɨɨ ña quɨvɨ cua nandoto ñi? Tyin tandɨhɨ maa ra naha tan tindaha̱ ra naha tsihin ña ―catyí ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tacan tan nacaha̱n ra Jesús tan catyí ra tsihin ra naha: ―Caahán soho ñi maa nyooho, tyin ña tsitó ndo tsa catyí tuhun Nyoo, tan ndi ña tsitó ndo nácaa tsa cahnu cuví tunyee iñi tsa iyó tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quɨvɨ cua nandoto nyɨvɨ, ndi ña cua tindaha ñi tan ndi ña cua tindaha sehe ñi, tyin cua cuvi ñi tumaa ángel iyó gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tan tuhun tsa cua nandoto nyɨvɨ, ¿a ñaha ca cahvi̱ ndo nu libru tsa tyaa̱ ra Moisés nu catyí tsi nácaa caha̱n Nyoo tsihin ra nu cayú yutun iñu? Tyin catyi̱ ra tsihin ra tyehen: “Yuhu cuví Nyoo ra Abraham, ra Isaac, tan ra Jacob”, catyi̱ Nyoo tsihin ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ihya nyehé yo tyin nyito añima ra can naha ra vasu ndi maa tsanaha tsihi̱ ra naha tyin Nyoo ñavin Nyoo nyɨvɨ tsihi̱ cuví ra, tyin Nyoo cuví ra Nyoo nyɨvɨ nyito. Yacan cuenda catyí yu tyin nyooho caahán soho ñi maa ndo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ña naha ñi tan tsaa̱ iin ra maestro cuenda ley vehe ñuhu, tan tsiñi̱ ra tsa caahán ra Jesús tsihin ra saduceo can naha ra. Tan cuhva tsa tsito̱ ra tyin ra Jesús vaha nacaha̱n ra tsihin ra naha, tsica̱ tuhun ra tsi ra tan catyí ra: ―Tsitsi tsa tandɨhɨ ley, ¿ndáa tsa ñiñi ca cuñí tsi javaha yo? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tan nacaha̱n ra Jesús tan catyí ra: ―Ley tsa jihna ñi tan ñiñi ca cuñí tsi javaha yo tsa nuu tandɨhɨ ley, cuví ley ihya: “Nyooho nyɨvɨ Israel, tya̱a soho ndo: intuhun ñi maa Nyoo Jutu yo iyó. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cu̱ñi ndo tsi Jutu Mañi yo Nyoo tsihin tsa nɨɨ iñi ndo, tan tsihin tsa nɨɨ iñi añima ndo, tan tsihin tandɨhɨ tsa tsiñi tuñi jiñi ndo, tan tsihin tandɨhɨ tunyee iñi tsa iyó tsi ndo.” Ley ihya cuví tsa ñiñi ca tan tsa jihna ñi taahán tsi javaha yo. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tan tsa tsinu uvi tsa yatyin inducu ñi caahán tsi tsihin tsa jihna ñi tan catyí tsi tyehen: “Cu̱ñi tahan ndo tsi ndo tumaa cuñí ndo tsi maa ndo.” Nduve ca ley tsa ñiñi ca javaha yo tsa nuu nduvi tsehe ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tacan tan ra maestro cuenda ley can catyí ra tsihin ra: ―Vaha xaan nacaha̱n un, Maestro. Nditsa tsa caahán un. Intuhun ñi Nyoo iyó, tan nduve inga ca Nyoo iyó. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tan tsa cuñí yo tsi Nyoo tsihin tsa nɨɨ iñi yo, tan tsihin tandɨhɨ tsa tsiñi tuñi jiñi yo, tan tsihin tsa nɨɨ iñi añima yo, tan tsihin tandɨhɨ tunyee iñi iyó tsi yo, tan tsa cuñí tahan yo tsi yo tumaa cuñí yo tsi maa yo, tandɨhɨ yacan tan cahnu ca cuví can tan ñavin ca tsa jamañí yo tsi Nyoo, tsa tsahñí yo quɨtɨ tan tsahmí yo can nu altar ―catyí ra maestro cuenda ley can tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tsa nyehe̱ ra Jesús tyin vaha nacaha̱n ra tsihin tsa catsi jiñi ra, tan catyí ra tsihin ra: ―Luxu cuii ña tan ñihi un cuhva nácaa nacuhva cuenda un añima un tsi Nyoo na cundaca ñaha ra tsi un ―catyí ra Jesús tsihin ra. Ndi intuhun ca maa nyɨvɨ tan ña cana̱ ca iñi ñi ndaca tuhun ñi náa ndaca tuhun ñi tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jacuahá ra Jesús tsitsi vehe ñuhu cahnu, tan catyí ra: ―¿Nacuenda tyin catyí ra maestro cuenda ley vehe ñuhu naha ra tyin tata ra David cuví ra Cristo? ");
INSERT INTO mjcNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tan juvin ñi maa ra David catyi̱ tuhun ra Cristo tyehen: Nyoo caha̱n ra tsihin Jutu Mañi yu, tan catyí ra: “Cu̱nyaa xiin cuaha yu ihya nda cuanda caquin yu tsi ra xaan iñi tsi un naha ra tsaha un”, catyi̱ ra David taha̱n tsanaha jaha̱ Tatyi Ii Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Nacaa cuví cuú tucu ra Cristo tata ra David, tan juvin ñi maa ra David catyi̱ tyin ra Cristo cuví Jutu Mañi ra? ―catyí ra Jesús. Tan cuaha nyɨvɨ yucú tyaá soho tsa caahán ra tan sɨɨ xaan cuñí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Quitsaha̱ jacuahá ra Jesús tan catyí ra tyehen: ―Ja̱ha ndo cuenda tsi ndo tsihin ra maestro cuenda ley vehe ñuhu naha ra, tyin taahán xaan iñi ra naha cunditsí ra naha jahma nañi tan caca nuu ra naha nuyahvi na jaha ndo tsa ñayɨvɨ tsi ra naha, tan cuhva ndo nacumi tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tan nanducú ra naha tyayu vaha ca cunyecu ra naha tsitsi vehe ñuhu. Tan tsa cua catsi ra naha nu iyó vico, nanducú ra naha nu vaha ca cunyecu ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tan quihín nyaá ra naha vehe ñi ndaahvi tsa tsihi̱ yɨɨ tyin ña cuví tyahvi ñi xuhun tsa tsicán ra naha tsi ñi. Tan cuñí ra naha tsa vaha cahan nyɨvɨ tuhun ra naha. Yacan cuenda naha tsicán tahvi ra naha tsi Nyoo nu tuvi nyɨvɨ. Maa tyin nduve náa catyi javahá ra naha tacan tyin ñihi ca cua tatsi tuñi Nyoo tsi ra naha ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iin tsaha nyií ra Jesús tsitsi vehe ñuhu cahnu tan nyaá ra yatyin ñi nu nyií tsatun nu tyihí nyɨvɨ xuhun tsa tsahá ñi tsi Nyoo. Tan nyehé ra nu tyihí nyɨvɨ xuhun tsitsi tsatun can. Tan cuaha nyɨvɨ cuca tyihí ñi cuaha xaan xuhun. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tsitsi tsa nyaá ra ican tsaa̱ iin ñaha ndaahvi tsihi̱ yɨɨ, tan tyihi̱ ña uvi taahan ñi xuhun nyihi tsa caaha xaan nyaá. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tacan tan cana̱ ra Jesús tsi ra tsicá tsihin ra, tan catyí ra tsihin ra naha: ―Tsa nditsa catyí yu tsihin ndo tyin nuu Nyoo cuaha ca xuhun tsaha̱ ñaha ndaahvi ihya tan ñavin ca inga nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tyin tsahá ñi tsa ndoo̱ sɨquɨ xuhun ñi. Maa tyin ñaha ihya tyihi̱ ña tandɨhɨ tsa iyó tsi ña ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cuhva tsa cua quita ra Jesús tsitsi vehe ñuhu cahnu can, iin ra tsicá tsihin ra catyí ra tsihin ra: ―¡Maestro, nye̱he jihna tsa sɨɨ caá yuu yɨhɨ́ vehe ihya! ¡Nye̱he tsa nahnu vehe ihya! ―catyí ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Maa tyin nacaha̱n ra Jesús, tan catyí ra tsihin ra: ―Nditsa nahnu vehe ihya tan sɨɨ caá tsi nyehé yo vityin. Maa tyin catyí yu tsihin un tyin coo quɨvɨ nduve ca maa náa cua ndoo ihya. Ndi intuhun yuu tan ña cua coso tahan tsi tsihin inga tsi, tyin tandɨhɨ maa tsi tan cua tanɨ tsi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tacan tan cuahán ra Jesús tsihin ra tsicá tsihin ra yucu yutun Olivo tsa canyií inga tsiyo nu nditsin nyehé tsi vehe ñuhu cahnu. Tsa tsinyaa̱ ra Jesús ican, ra Pedro, ra Jacobo, ra Juan, tan ra Andrés tsica̱ tuhun xeehe ra naha tsi ra tan catyí ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Cuñí ndi tsa catyi tuhun un tsihin ndi ama cua cuvi tandɨhɨ tsa caha̱n un. ¿Nacaa tan coto ndi tatun tsa cuyatyin cundaa tandɨhɨ can? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nacaha̱n ra Jesús tan catyí ra: ―Ja̱ha ndo cuenda tsi ndo coto jandavi ñaha nyɨvɨ tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tyin cuaha xaan nyɨvɨ cua quitsi, tan cua cuatyiñu ñi sɨvɨ yu, tan cua catyi ñi: “Yuhu cuví ra Cristo, ra tsa jaquitsi̱ Nyoo.” Tan cuaha xaan nyɨvɨ cua jandavi ñaha ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Maa tyin tun ñihi tuhun ndo tyin iyó cuatyi tan cañí tahan nyɨvɨ ityi can tan ityi ihya, ña nayuhvi ndo tyin tacan taahán maa tsi cuvi tsa ndi cumañi ca naa ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tyin nyɨvɨ iin ñuu cua cañi tahan ñi tsihin nyɨvɨ inga ñuu, tan cua coo cuatyi iin ñuu tsihin inga ñuu. Tan cuaha ñi ityi cua taan ñihi, tan cua coo tama, tan cua nduvaa nyɨvɨ. Vasu ndi maa nyehe nyɨvɨ tundoho ihya, ña cua naa naha ñuhu ñayɨvɨ tyin ndi nyaa ca cua nyehe ñi tundoho. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Maa tyin ja̱ha ndo cuenda tsi ndo tyin cua cuhva cuenda nyɨvɨ tsi ndo tsi ra cumí tyiñu naha ra. Tan cua cañi ñi tsi ndo tsitsi vehe ñuhu. Cua cuhva cuenda ñi tsi ndo tsi ra cumi tyiñu tan tsi ra cuví rey tsacatyi yuhu. Tyin tacan tan cuvi cahan ndo tuhun yu nuu ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tyin tsa ndi cumañi ca naa ñuhu ñayɨvɨ, cuñí tsi coto tandɨhɨ nyɨvɨ inga ñuu tyin Nyoo jacacú ra tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tan cuhva tsa cua cundaca ñi tsi ndo nuu ra cumi tyiñu naha ra, ña ca̱ca iñi ndo náa cua cahan ndo. Tyin juvin ñi maa hora can tan cua cuhva Nyoo tsa cahan ndo. Tyin ñavin maa ndo cua cahan; tyin maa Tatyi Ii Nyoo cua cahan. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Yɨhɨ́ ra naha cua nacuhva cuenda ra naha juvin ñi maa yañi ra naha tan cua ndacan ra naha tsa cúu ra can naha ra. Yɨhɨ nyɨvɨ cua nacuhva cuenda ñi juvin ñi maa sehe ñi. Tan yɨhɨ́ ñi cua nacuhva cuenda ñi nda cuanda jutu ñi tan sɨhɨ ñi tyin cúu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tandɨhɨ nyɨvɨ iyó nu ñuhu ñayɨvɨ ndasɨ cua cuñi ñi nyehe ñi tsi ndo tsacatyi yuhu. Maa tyin nyooho tsa cua cunyee iñi tsinú iñi tsi yu nda nu ndɨhɨ, cua cacu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Tandɨhɨ nyooho tsa cahví nu tutu Nyoo nu tyaa̱ ra Daniel, ra cuvi̱ ndusu yuhu Nyoo tsa tsicoo̱ taha̱n tsanaha, cu̱tuñi iñi ndo tyin iyó tsa janducaquiñi tan tsa jatɨvɨ. Quɨvɨ tsa nyehe ndo tyin tsa nyií yacan nu ña taahán tsi cunyii can, nyooho nyɨvɨ iyó Judea, qu̱ita ndo ñuu ndo tan cuhun ndo ityi yucu. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nyooho tsa cua cuyucu jiñi vehe quɨvɨ can, cua nuu ndo, maa tyin ña cua nuu ndo tsa quɨhvɨ ndo tsitsi vehe ndo tan tava ndo tsa iyó tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nyooho tsa cua cuyucu tsitsi cuhu, ña cua cunuhu jihna ndo cuquihin ndo jahma ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ndahvi ñiñaha tsa ñuhú sehe quɨvɨ can! ¡Tan ndahvi ñi iyó sehe lee tsa ndi tyaxín! ¡Ndahvi ñi! ");
INSERT INTO mjcNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nda̱can tahvi ndo tsi Nyoo na ña tahan tsi cunu ndo quɨvɨ vitsin. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tyin tundoho tsa cua nyehe nyɨvɨ quɨvɨ can, ñaha ca maa coo can ndaha tsinu̱ maa ñuhu ñayɨvɨ nda cuanda vityin. Tan ndi ityi nuu ca tan ña cua nyehe nyɨvɨ tahan tundoho can inga tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tun tsatyin Jutu Mañi yo tan ña jandɨhɨ ra tsa cua nyehe yo tundoho quɨvɨ can, yoñi maa cua cacu. Maa tyin cua jandɨhɨ ra can tsa cuenda tsa cuñí ra tsi nyɨvɨ yɨhɨ cuenda ra, nyɨvɨ nacatsi̱ vaha maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Tatun catyi nyɨvɨ tsihin ndo: “Jihna ndo, ihya nyaá ra Cristo” o “Nye̱he ndo, ican nyaá ra Cristo”, ña tsinu iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tyin cua quitsi nyɨvɨ jandavi ñaha tan cua catyi ñi tyin ra Cristo cuví ñi. Cua catyi ñi tyin ndusu yuhu Nyoo cuví ñi. Maa tyin ña nditsa ñi. Cua javaha ñi tsa nyityi, tan tsa iyo nahnu tyin cua jandavi ñaha ñi nda cuanda nyɨvɨ nacatsi̱ maa Nyoo, tatun cunyee ñi javaha ñi tacan. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Maa tyin nyooho ja̱ha cuenda vaha ndo tsi ndo vityin tsa tsa tsitó ndo tandɨhɨ yacan tsa ndi cumañi ca tahan tsi quɨvɨ can ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tan catyí nyico ra Jesús tyehen: ―Maa tyin tsa cua yaha nyehe nyɨvɨ tundoho quɨvɨ can, cua ndunaa ñicanyii, yoo ña cua jandunditsin ca tsi, ");
INSERT INTO mjcNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tan cua cucoyo tiñuu. Tan tandɨhɨ tsa iyó andɨvɨ tan cua nacanda tsi naha tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tacan tan cua nyehe ndo tsi yuhu, Rayɨɨ tsa quee̱ nda gloria, vatsí yu nu vico tsihin tunyee iñi cahnu tan tsihin tsa cahnu cuví Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tan cuaha ángel cuenda yu cua jaquitsi yu tyin jandu iin ra naha nyɨvɨ nacatsi̱ maa Nyoo. Cua quita ñi nanɨɨ cahnu nu ñuhu ñayɨvɨ, nda nu ndɨhɨ ñuhu ñayɨvɨ tan nda nu ndɨhɨ andɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Cu̱tuñi iñi ndo cuhva iyó yutun tsa nañí higo: Tun tsa nduyutyá soco tun tan cana̱ ndaha yutya tun, tsitó ndo tyin tsa cua quee tsɨtɨ tun. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tan juvin ñi tacan, tatun tsa cuví tandɨhɨ tsa iyo tsa caahán yu tuhun tsihin ndo, cua coto ndo tyin tsa cuyatyin quitsi yu; tan tsa nyanaá yu yuvehe cuví tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tsa nditsa catyí yu tsihin ndo tyin tsa ndi cumañi ca cúu nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya tan cua cuvi tandɨhɨ tsa caahán yu tuhun tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tan coo quɨvɨ cua cundɨhɨ andɨvɨ tan cua cundɨhɨ ñuhu ñayɨvɨ, maa tyin tuhun caahán yuhu, ña cua cundɨhɨ maa tsi tyin tandɨhɨ tsi tan cua cundaa tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Maa tyin quɨvɨ tan hora tsa cua cuvi tandɨhɨ yacan, yoñi maa tsitó can, ndi maa ca ángel tan ña tsitó ra naha, ndi yuhu tsa cuví yu Sehe Nyoo tan ña tsitó yu. Intuhun ñi maa Nyoo Jutu yo tsitó ama cua javaha ra tandɨhɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Yacan cuenda co̱o nyito vaha ndo, tan ja̱ha cuenda ndo tsi ndo, tan nda̱can tahvi ndo tsi Nyoo, tyin ña tsitó ndo náa quɨvɨ tan náa cuhva cua quitsi nyico yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tumaa iin rayɨɨ tsa cua cuhun nu cañi. Ra ican tsa ndi cumañi ca cuhun ra, tsahá cuenda ra vehe ra tsi musu ra. Tan tsahá ra tyiñu tsi intuhun intuhun ra naha. Tan tava tyiñu ra tsi ra jahá cuenda yuvehe na jaha cuenda vaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yacan cuenda nyooho co̱o nyito ndo tyin ña tsitó ndo náa cuhva cua quitsi yu tsa cuví yu tumaa tsitoho vehe can, tyin cuvi quitsi yu tsa cua cunaaha, maa ñuu, o cuhva tsacú tsitooho, o tsa cua cana ñicanyii. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yacan cuenda co̱onyito vaha ndo tan ña cusu ndo tyin sana iñi ndo tan cua quitsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tsa caahán yu tsihin nyooho, caahán tucu yu tsihin tandɨhɨ ca nyɨvɨ: Co̱o nyito ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tsa ndi cumañi uvi quɨvɨ ca tan tahan tsi vico pascua tan vico nu tuhvá nyɨvɨ tsatsí paan tsa nduve yutsan iya yɨhɨ́. Ra jutu tsa cuví ityi nuu naha ra tan ra maestro cuenda ley vehe ñuhu naha ra nducú ra naha cuhva tɨɨn xeehe ra naha tsi ra Jesús tan cahñi ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Maa tyin natuhu̱n tahan ra naha tan catyí ra naha: ―Ña cua tɨɨn naha yo tsi ra quɨvɨ maa vico tyin coto nduvaa xaan nyɨvɨ ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tsa ndi cumañi ca tahan tsi vico can, nyií ra Jesús ñuu Betania, vehe ra Simón, ra tsa tsindoho̱ cuehe tyaahyu. Tsitsi tsa nyaá ra Jesús tsatsí ra, tsaa̱ iin ñaha ndahá ña iin yutyi tsa tsinu̱ tsihin yuu tsa nañí alabastro. Tsitu̱ can yɨhɨ́ ndutya tami tsa nañí nardo. Tan yahvi xaan nyaá ndutya tami can. Nuña̱ ña yuhu yutyi can tan tava̱ ña ndutya tami can tan tyihi̱ ña can jiñi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Maa tyin juhva ra tsa yucú ican naha ra nduxaa̱n ra naha tan catyí ra naha: ―¿Nacuenda tyin jatɨvɨ̱ ñaha ihya ndutya tami can? ");
INSERT INTO mjcNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tun tsatyin xico̱ ña can, cuaha xaan xuhun cua ñihi ña tsihin can, tan cuvi jatyinyee ña tsi nyɨvɨ ndaahvi tsihin xuhun can ―catyí ra naha. Tan cuxaa̱n ra naha tsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Maa tyin ra Jesús catyi̱ ra: ―¡Ja̱ña ndo tsi ña! ¿Nacuenda cuñí ndo jandu uvi iñi ndo tsi ña? Tan tsa vaha javahá ña tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tyin nyɨvɨ ndaahvi tandɨhɨ ñi quɨvɨ cua cuyucu ñi tsihin ndo, maa tyin yuhu, ña naha ca cunyii yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ñaha ihya javaha̱ ña ndɨhɨ cuhva cuvi̱ ñi javahá ña. Tyihi̱ ña ndutya tami cuñu ñuhu yu, tumaa tuhvá maa yo javahá tsihin cuñu ñuhu nyɨvɨ tsa ndi cumañi ca quɨhvɨ ñuhu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tsa nditsa catyí yu tsihin ndo, tyin tandɨhɨ ityi nu cua cahan nyɨvɨ tuhun Nyoo nanɨɨ cahnu nu ñuhu ñayɨvɨ, cua cahan ñi tuhun ñaha ihya tan tsa javaha̱ ña, tyin tacan tan ña naa iñi nyɨvɨ tsi ña ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tsa yaha̱ yacan tan quita̱ iin ra tsitsi tsa utsi uvi ra tsicá tsihin ra Jesús. Ra ihya cuví ra Judas Iscariote. Tsaha̱n ra tsicaha̱n ra tsihin ra jutu cuví ityi nuu naha ra, tan jandaa̱ ra tyiñu tsihin ra naha tyin cua cuhva cuenda ra tsi ra Jesús tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cuhva tsa tsiñi̱ ra naha tsa caahán ra, sɨɨ xaan cuñí ra naha cuvi̱, tan catyi̱ ra naha tsihin ra tyin cuhva ra naha xuhun tsi ra. Tacan tan quitsaha̱ nducú ra Judas cuhva cuhva cuenda ra tsi ra Jesús tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Quɨvɨ jihna ñi tsa quitsaha̱ vico nu tsatsí nyɨvɨ paan tsa nduve yutsan iya yɨhɨ́ tan quɨvɨ tuhvá ñi tsahñí mbee lee tan jamañí ñi tsi Nyoo, ra tsicá tsihin ra Jesús tsica̱ tuhun ra naha tsi ra, tan catyí ra naha: ―¿Numaa cuñí un cuhun ndi janduvaha ndi tsa cuxiñi un cuenda vico pascua ihya? ");
INSERT INTO mjcNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tacan tan tava̱ tyiñu ra tsi uvi taahan ra naha tan catyí ra tsihin ra naha: ―Cu̱aahan ndo tsitsi ñuu, tan ican cua nañihi ndo iin rayɨɨ yosó soco iin quɨyɨ ndutya. Tsa nyehe ndo tsi ra, cu̱anyicun ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tsa tsaa ndo yuvehe nu cua quɨhvɨ ra, ca̱tyi ndo tyehen tsihin tsitoho vehe can: “Ra Maestro cuñí ra coto ra numaa nyaá cuartu nu cua jacahnu ra vico tsihin ra tsicá tsihin ra”, ca̱tyi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tan cua janaha ra iin cuartu cahnu nu tsinu uvi pisu tsi ndo. Tsa nduvaha̱ maa tsitsi tsi jaha̱ ra, Ja̱vaha ndo tsa cuxiñi yo tsitsi vehe can―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tacan tan cuahán ra naha. Tsa tsaa̱ ra naha tsitsi ñuu can, nañihi̱ ra naha tandɨhɨ maa cuhva catyi̱ ra Jesús tsihin ra naha. Tan javaha̱ ra naha tsa cua cuxiñi ra naha cuenda vico pascua. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tsa ndɨhɨ̱ javaha̱ ra naha tsa cua cuxiñi ra naha, tacan tan cuahán nyico ra naha nu nyií ra Jesús. Tan tsa cunaaha, cuahán ra Jesús, cuacuxiñí ra tsihin tsa utsi uvi ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tan cuhva tsa nyecú ra naha tsatsí ra naha nu mesa, tan catyí ra Jesús: ―Tsa nditsa catyí yu tsihin ndo tyin iin nyooho tsa tsatsí tsihin yu cua xico tsi yu tsi ra xaan iñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tacan tan nducuiihya̱ xaan cuñí ra naha, tan quitsaha̱ tsicá tuhun tan iin tan iin ra naha tsi ra, tan catyí ra naha: ―¿A yuhu? Tacan tan tsicá tuhun tucu inga ra tan catyí ra: ―¿A yuhu? ");
INSERT INTO mjcNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tan nacaha̱n ra Jesús tan catyí ra: ―Ña tandɨhɨ ndo. Intuhun ñi ra tsitsi tsa utsi uvi ndo. Tan ra ican cuví ra tsa jatyií paan iin ñi tsitsi coho tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tyin yuhu, Rayɨɨ tsa quee̱ nda gloria, cua tahan yu tumaa caahán maa nu tutu Nyoo tyin cua tahan yu. Maa tyin ¡ndahvi ra ndaahvi tsa cua xico tsi yu! Vaha ca tun tsatyin ña cacu̱ ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tan tsitsi tsa tsatsí ra naha, tacan tan quihi̱n ra Jesús iin paan tan nacuhva̱ ra tyahvi nyoo tsi Nyoo tsa cuenda can, tan tsahnu̱ sava ra can, tan tsaha̱ ra can tsi ra tsicá tsihin ra, tan catyí ra: ―Ca̱tsi ndo paan ihya tyin tsehe cuví tumaa cuñu ñuhu yu ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tsa yaha̱ yacan quihi̱n ndɨhɨ ra vasu nu yɨhɨ́ vinu. Tsa yaha̱ tsaha̱ ra tyahvi nyoo tsi Nyoo, tacan tan tsaha̱ ra can tsi ra naha. Tandɨhɨ ra naha tan tsihi̱ ra naha vinu tsa yɨhɨ́ tsitsi vasu can. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Tan catyí ra tsihin ra naha: ―Vinu ihya cuví tumaa nɨñɨ yu tyin tsihin nɨñɨ yu cua ndoo Nyoo tuhun tsaa tsihin ndo tyin cua catɨ nɨñɨ yu tsa cuenda tsa vaha tsi nyooho tan tsa vaha tsi cuaha nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tsa nditsa catyí yu tsihin ndo tyin ña cua coho ca yu vinu tsa cuví ndutya yucu vixi uva, nda cuanda coho yu vinu tsaa nda nu ndacá ñaha Nyoo quɨvɨ tsaa yu ndacan ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tsa ndɨhɨ̱ tsita̱ ra naha yaa Nyoo, tan cuahán ra naha yucu yutun Olivo. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tacan tan catyí ra Jesús tsihin tandɨhɨ ra naha: ―Tandɨhɨ maa ndo tan cua nacoo ihñi ndo tsi yu tsa cuaa vityin tyin catyí nu tutu Nyoo tyehen: “Tandɨhɨ mbee ticatyi jana yu cua cuhun tsiyo tɨ naha tɨ sɨɨn sɨɨn ityi tyin cua cahñi yu tsi ra jahá cuenda tsi tɨ naha tɨ”, catyí tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Maa tyin tsa yaha nandoto yu, jihna ca yu cua cuhun Galilea tsa ndi cumañi ca cuhun nyooho ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tacan tan catyí ra Pedro tsihin ra: ―Vasu ndi maa nacoo ihñi tandɨhɨ ra naha tsi un, maa tyin yuhu ña cua nacoo ihñi maa yu tsi un ―catyí ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Maa tyin ra Jesús catyí ra tsihin ra: ―Tsa nditsa catyí yu tsihin un, tyin tsa cuaa vityin, tsa ndi cumañi ca vacu tsitooho tsa tsinu uvi tsaha, uñi tsaha cua cahan un tyin ña nacotó un tsi yu ―catyí ra Jesús tsihin ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Maa tyin jañiñi̱ ra Pedro tan catyí ra: ―Vasu ndi maa cúu yu tsihin un, maa tyin ña cua catyi yu tyin ña nacotó yu tsi un ―catyí ra Pedro. Tan juvin ñi tacan catyí tandɨhɨ ca ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tacan tan tsaa̱ ra Jesús tan ra tsicá tsihin ra iin nu nañí Getsemaní. Tan catyí ra Jesús tsihin ra naha: ―Ndo̱o ndo ihya tsitsi tsa cuahán yu ndacan cua ndacan tahvi yu tsi Nyoo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tan quihi̱n ra tsi ra Pedro, ra Jacobo tan ra Juan cuahán tsihin ra. Tan tsaa̱ tucuiihya iñi cahnu tsi ra tan tuñu cuñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tan catyí ra tsihin ra naha: ―Cuiihya xaan cuñí yu; cahñi ña maa tucuiihya iñi ihya tsi yu, cuñí yu. Ndo̱o ndo ihya, tan ña cusu ndo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tacan tan cuahán ra luxu ca ityi nuu. Tan tsicuɨñɨ̱ tsɨtɨ ra nu ñuhu tan tsaqui̱n ra nuu ra nda nu ñuhu. Tan tsica̱n tahvi ra tsi Nyoo tan catyí ra: ―Tun tsatyin cuvi ña cuhva un nyehe yu tundoho tsa cua nyehe yu ―catyí ra tsica̱n tahvi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tan tsa tsicán tahvi ra, catyí ra: ―Jutu Mañi yu, tsa cuenda yooho nduve tsa ña cuví javaha un. Tun yooho tan cuñí un cuví jatsiyo un tundoho ihya sɨquɨ yu. Maa tyin na cuvi maa cuhva cuñí maa un, tan ñavin cuhva cuñí maa yu ―catyí ra Jesús tsica̱n tahvi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tacan tan cuahán ra nu nacoo̱ ra tsi uñi ra tsicá tsihin ra. Tsa tsaa̱ ra nu yucú ra naha, nyehe̱ ra tyin quixí ra naha. Tan catyí ra tsihin ra Pedro: ―Simón, ¿a quixí un? ¿Nacuenda ña cunyee̱ iñi un coo nyito un tsihin yu ndi intuhun hora? ");
INSERT INTO mjcNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ña cusu ndo; nda̱can tahvi ndo tsi Nyoo, tyin tacan tan ña cua javaha ndo cuhva cuñí nu ña vaha. Tsa nditsa tyin añima ndo cuñí xaan tsi nanducu tsi tsi Nyoo, maa tyin cuñu ñuhu ndo cuví tsa vita cuñí ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tacan tan cuahán nyico ra inga tsaha. Tan tsica̱n tahvi ra tsi Nyoo juvin ñi tsihin tuhun tsa caha̱n ra tsa jihna ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tacan tan tsaa̱ nyico ra inga tsaha, nu yucú ra naha tan nyehe̱ ra tyin quixí nyico ra naha, tyin tsindasɨ̱ maa tinuu ra naha jaha̱ ñumaahna. Tan ña tsitó ra naha náa nacahan ra naha tsihin ra. Ndi maa ra tan ña caha̱n ca ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tan cuahán nyico ra. Tsa tsaa̱ ra nu yucú ra naha tsa tsinu uñi tsaha, catyí ra: ―Cu̱su vaha ndo vityin, tan qu̱itatu ndo tyin tsa cundaa̱ tyiñu. Ra tsa cua cuhva cuenda tsi yu tsi ra xaan iñi tsi yu naha ra tsa vatsí ra tyin tsa taha̱n tsi hora tsa cua cuhva cuenda ra tsi yuhu, Rayɨɨ tsa quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndu̱vita ndo, co̱hon ndo tyin tsa vatsí ra tsa xico̱ tsi yu ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ra jutu cuví ityi nuu naha ra, tan ra maestro cuenda ley vehe ñuhu naha ra, tan ra mandoñi nyɨvɨ Israel naha ra; cuaha xaan nyɨvɨ jacuhu̱n ra naha tsihin ra Judas, iin ra tsicá tsihin ra Jesús, tyin tɨɨn ñi tsi ra Jesús. Juhva ñi ndahá mityi tan juhva ñi ndahá yutun. Ndi caahán ca ra Jesús nyaá ra tan tsaa̱ ra Judas tsihin nyɨvɨ cuaha can. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tsa ndi cumañi ca cuhun ra Judas, ra tsa xico̱ tsi ra Jesús, tsa catyi̱ maa ra tsihin nyɨvɨ náa cua javaha ra tan coto ñi ndáa ra cuvi ra Jesús. Tan caha̱n ra tyehen: ―Ra tsa cua tyaa yuhu yu, ra ican cuví ra Jesús tsa cua quihin ndo. Qu̱ihin ndo tsi ra tan ja̱ha cuenda vaha ndo coto cunu ra ―catyi̱ ra nu quitsi̱ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tsa tsaa̱ ra Judas nu nyií ra Jesús natuhva̱ ra nu nyaá ra tan catyí ra tsihin ra: ―Maestro. Tan tyaa̱ yuhu ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tacan tan quihi̱n ra naha tsi ra Jesús cuahán tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Maa tyin iin ra nyií tsihin ra Jesús, tava̱ ra mityi ra tan tsahnya̱ ra soho musu ra jutu tsaahnu cuví ityi nuu. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tacan tan catyí ra Jesús tsihin ra quihi̱n tsi ra: ―¿A ñasuhu cuví yuhu? tyin vatsí ndo vatsí quihin ndo tsi yu tsihin mityi tan yutun. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ndɨhɨ quɨvɨ tsinyii̱ yu jacuaha̱ yu tsi ndo tsitsi vehe ñuhu cahnu, tan ña quihi̱n ndo tsi yu. Tandɨhɨ tsehe cuví tyin tacan tan cundaa tsa catyí nu tutu Nyoo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tacan tan tsinu̱ tandɨhɨ ra tsicá tsihin ra, tan ndoo̱ intuhun ña maa ra jaha̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Maa tyin ndoo̱ intuhun ca ra tyuvaa tan cuahán ra cuanyicún ra tsi ra, ndasɨ ra tsihin iin ticatyi tan tɨɨ̱n ndɨhɨ ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Maa tyin nacoo̱ ihñi ra ticatyi can tan tsinu̱ tandɨɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tacan tan tsindaca̱ ra naha tsi ra Jesús tsi ra jutu tsaahnu cuví ityi nuu tan ndu ii̱n tucu tandɨhɨ ra jutu cuví ityi nuu naha ra tan ra cuví mandoñi nyɨvɨ Israel naha ra, tan ra maestro cuenda ley vehe ñuhu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ra Pedro nyicún tsica nyicún tsica ñi ra tsi ra naha cuahán ra. Tan tsaa̱ ra nda nuquehe yuvehe ra jutu tsaahnu cuví ityi nuu can. Tan ndoo̱ ra tuñú ra ñuhu̱ tsihin ra vitya naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ra cuví jutu ityi nuu naha ra, tan tandɨhɨ ca ra cumí tyiñu naha ra nducú ra naha cuatyi tyaa ra naha sɨquɨ ra Jesús, tyin tacan tan cuvi cahñi ra naha tsi ra. Maa tyin ña ñihi̱ maa ra naha cuatyi tyaa ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Cuaha xaan nyɨvɨ caha̱n cuendu sɨquɨ ra, maa tyin ña nacatsí tahan maa tuhun caahán ndi intuhun ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yɨhɨ́ ñi nduvita̱ ñi tan caha̱n ñi maa ñi maa cuendu sɨquɨ ra, tan catyí ñi: ");
INSERT INTO mjcNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nyuhu tsiñi̱ ndi tsa caha̱n ra tan catyi̱ ra tyehen: “Yuhu cua canɨ yu vehe ñuhu cahnu tsa javaha̱ nyɨvɨ. Tan cua janduvita yu inga vehe ñuhu tsitsi tsa uñi quɨvɨ ñi. Maa tyin ñavin tahan vehe ñuhu tsa javahá nyɨvɨ” catyi̱ ra ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Vasu ndi maa tacan caahán ñi, maa tyin ña nacatsi̱ tahan maa tsa caha̱n ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tacan tan nduvita̱ ra jutu tsaahnu cuví ityi nuu mahñu tandɨhɨ ra yucú ican naha ra, tan tsica̱ tuhun ra tsi ra Jesús, tan catyí ra: ―¿A ña cua nacahan un nu caahán nyɨvɨ ihya? ¿A nditsa tsa caahán ñi, o ña nditsa? ―catyí ra ");
INSERT INTO mjcNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Maa tyin ña nacaha̱n maa ra Jesús tan nduve maa náa caha̱n ra. Tacan tan ra jutu tsaahnu cuví ityi nuu tsica̱ tuhun ra tsi ra inga tsaha, tan catyí ra: ―¿A yooho cuví ra Cristo, Sehe Nyoo ii tsa tsahá tsa vaha? ");
INSERT INTO mjcNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tan ra Jesús catyí ra tsihin ra: ―Juvin. Nyooho cua nyehe ndo tsi yuhu, Rayɨɨ tsa quee̱ nda gloria, nyaá yu xiin cuaha Nyoo, ra iyó tandɨhɨ tunyee iñi, tan cua nyehe tucu ndo nu quitsi yu nu vico ityi andɨvɨ ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tacan tan tsahnya̱ ra jutu tsaahnu cuví ityi nuu jahma ra tumaa iin seña tyin ña taahán iñi ra tsa caahán ra Jesús tyin cuñí maa ra tyin ña vaha tsa caahán ra, tan catyí ra: ―Ña tsiñí ñuhu ca tsa nducu yo tsi ra cuvi tsa ndaa. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tyin tsa tsiñi̱ maa ndo tsa caha̱n ra. Tsicoo̱ cuatyi ra nuu Nyoo tsihin tuhun caha̱n ra. ¿Náa catyí ndo vityin? ―catyí ra. Tacan tan nacaha̱n tandɨhɨ ra naha tan catyí ra naha tyin taahán tsi cúu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tacan tan quitsaha̱ tɨvɨ́ sɨɨ juhva ra naha tsi ra. Tyasɨ̱ ra naha nuu ra, tan cañi̱ ra naha tsi ra tsihin tsɨquɨ tan catyí ra naha tsihin ra: ―¡Ca̱han tsihin ndi yóo cañi̱ tsi un! ―catyí ra naha tsihin ra. Tan cañi̱ tucu ra vitya naha ra nuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tsitsi tsa ndi nyií ra Pedro nuquehe tsata vehe ra jutu tsaahnu cuví ityi nuu, tsaa̱ iin ñaha cuví musu ra jutu can. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Cuhva tsa nyehe̱ ñaha can tsi ra Pedro nyaá ra tuñú ra ñuhu̱, quitsaha̱ nyehé xaan ña tsi ra, tan catyí ña tsihin ra: ―Tsica̱ tucu yooho tsihin ra Jesús, ra ñuu Nazaret can ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Maa tyin ra Pedro tyihi̱ xeehe ra, tan catyí ra: ―Yuhu ña nacotó yu tsi ra can, tan ndi ña tsitó yu náa caahán un ―catyí ra tsihin ña. Tacan tan quita̱ ra ityi yuhu cora. Tan tsacu̱ ñi tsitooho. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tacan tan ñaha can nanyehe̱ nyico ña nu nyaá ra inga tsaha tan catyí ña tsihin ra nyecú ican naha ra: ―Ra vaha iñi tsi ra can cuví ra ihya ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Maa tyin tyihi̱ xeehe nyico ra inga tsaha. Tacan tan ña naha ñi tan catyí ra yucú ican naha ra tsihin ra Pedro: ―Nditsa tyin ra vaha iñi tsi ra can cuví yooho, tyin ra Galilea cuví un, tan caahán un tumaa caahán nyɨvɨ Galilea ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tacan tan iyo xaan caahán ra Pedro, tan catyí ra: ―¡Tsitó vaha maa Nyoo tyin ña nacotó yu tsi ra tsa caahán ndo tuhun! ¡Na cahñi maa Nyoo tsi yu tun ña nditsa yu tsa caahán yu! ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Juvin ñi cuhva can navacu̱ tsitooho tsa tsinu uvi tsaha. Tacan tan nducuhu̱n iñi ra Pedro tsa caha̱n ra Jesús tsihin ra: “Tsa ndi cumañi ca vacu tsitooho uvi tsaha, yooho tsa yaha̱ caha̱n un uñi tsaha tyin ña nacotó un tsi yu.” Tsa nducuhu̱n iñi ra Pedro tsehe, quitsaha̱ ra tsacú ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tan tsa tuvi̱ inga quɨvɨ ndu ii̱n ra jutu cuví ityi nuu naha ra tsihin ra mandoñi naha ra tsihin ra maestro cuenda ley vehe ñuhu naha ra, tan tandɨhɨ ca ra cumí tyiñu tsa yɨhɨ́ ndaha tsi nyɨvɨ Israel. Nuuhñí ñi maa ra Jesús tan tsindaca̱ ra naha tsi ra nuu ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tan tsica̱ tuhun ra Pilato tsi ra, tan catyí ra: ―¿A juvin un cuví rey nyɨvɨ Israel? Nacaha̱n ra Jesús tan catyí ra: ―Juvin yu, tumaa caahán maa un. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tan cuaha xaan cuendu caha̱n ra cuví jutu ityi nuu naha ra sɨquɨ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tacan tan tsicá tuhun nyico ra Pilato tsi ra inga tsaha, tan catyí ra: ―¿A ña cua nacahan maa un? Nye̱he, cuaha xaan cuatyi tyaá ra naha sɨquɨ un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Maa tyin ra Jesús ña nacaha̱n maa ra. Yacan cuenda ña ñihi̱ ra Pilato náa cahan ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vico pascua tuhvá ra Pilato nacoó nuña iin ra yucú vehe caa. Tan tavá ra ndáa ra cuñí maa nyɨvɨ tyin tava ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Quɨvɨ can nyií iin ra nañí Barrabás vehe caa, tsihin inga ca ra tsahñi̱ nyɨvɨ nu cuvaa̱ nyɨvɨ sɨquɨ ra ndacá ñaha. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tan tsaha̱n nyɨvɨ tsicaha̱n ñi tsihin ra Pilato na jaña ra iin ra yucú vehe can tumaa tuhvá maa ra javahá. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tan nacaha̱n ra Pilato, tan catyí ra: ―¿A cuñí ndo tsa jaña yu tsi ra cuví Rey ndo? ");
INSERT INTO mjcNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tacan caha̱n ra tyin tuví iñi ra tyin tsaha̱ cuenda ra jutu cuví ityi nuu naha ra tsi ra Jesús tsi ra tsa cuenda tsa ndasɨ cuñí ra naha nyehe ra naha tsi ra tyin cuaha nyɨvɨ nyicún tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Maa tyin ra jutu cuví ityi nuu can naha ra natyuhu̱ ra naha tsi nyɨvɨ tsa cahan ñi na tava ra Pilato tsi ra Barrabás vehe caa. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tacan tan tsica̱ tuhun ra Pilato tsi ñi, tan catyí ra: ―¿Tun tacan, náa cuñí ndo javaha yu tsihin ra tsa jacunañi̱ ndo Rey cuenda ndo? ―catyí ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tacan tan cana̱ tsaa ñi, tan catyí ñi: ―¡Tya̱a tsi ra nu cruu na cúu ra! ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tan catyí ra Pilato tsihin ñi: ―Maa tyin, ¿náa tsa ña vaha javaha̱ ra? ―catyí ra. Ñi ican quitsaha̱ caná tsaa nyico ñi tan catyí ñi: ―¡Tya̱a tsi ra nu cruu na cúu ra! ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tacan tan tsa cuñí ra Pilato ndoo vaha ra nuu nyɨvɨ, tava̱ ra tsi ra Barrabás vehe caa. Tsa yaha̱ tava̱ ra tsi ra can, tava̱ tyiñu ra na ndoho ra Jesús. Tsa yaha̱ ndoho̱ ra Jesús, tan tsaha̱ cuenda ra tsi ra tsi andaru na ticaa ra naha tsi ra nu cruu. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tacan tan tsindaca̱ ra andaru can naha ra tsi ra nuquehe vehe tyiñu. Tan jandu ii̱n ra naha tandɨhɨ ca andaru. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tan jacunditsi̱ ra naha iin jahma cuaaha tuun tsi ra. Tan javaha̱ ra naha iin corona iñu. Tan tyihi̱ ra naha can jiñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tsa yaha̱ yacan tan quitsaha̱ caná tsaa ra naha tsata ra tan tsacú nducu ra naha tsi ra, tan catyí ra naha: ―¡Nacumi tsi un, yooho Rey nyɨvɨ Israel! ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tan cañi̱ ra naha jiñi ra tsihin yutun, tan tɨvɨ̱ sɨɨ ra naha tsi ra. Tan tsicuɨñɨ̱ tsɨtɨ ra naha nuu ra jahá ra naha tyin jacahnú ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tsa yaha̱ tsacu̱ nducu ra naha tsi ra, tava̱ ra naha jahma cuaaha tuun tsa jacunditsi̱ ra naha tsi ra. Tacan tan jacunditsi̱ nyico ra naha jahma maa ra tsi ra. Tan cuahán ra naha tsihin ra cuaticaá ra naha tsi ra nu cruu. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ityi cuahán ra naha taha̱n ra naha iin ra ñuu Cirene tsa nañí Simón. Tan cuví ra jutu ra Alejandro tan ra Rufo. Ndi vatsí nuhu ra quee̱ ra cuhu. Cuhva tsa cua yaha ra, jañiñi̱ ra andaru naha ra tsi ra na cuiso ra cruu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tan tsindaca̱ ra naha tsi ra Jesús iin nu nañí Gólgota, tan cuñí tsi catyi Yɨquɨ Jiñi Ndɨyɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tan ican jacoho̱ ra naha vinu saca̱ nuu tsihin numeri tsa nañí mirra tsi ra. Maa tyin ra Jesús ña cuñi̱ ra coho ra can. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tsa yaha̱ tyaa̱ ra andaru naha ra tsi ra nu cruu, quihi̱n ra naha jahma ra tan tava̱ cuenda ra naha tyin cuñí ra naha coto ra naha yóo cua jaha canaa intuhun intuhun jahma can. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tyaa̱ ra naha tsi ra nu cruu caa ɨɨn tsa tuvi. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tan letra tsa tyaa̱ ra naha jiñi cruu ra, catyí tsi nacuenda cua cúu ra. Tan catyí tsi tyehen: “Ra ihya cuví Rey nyɨvɨ Israel.” ");
INSERT INTO mjcNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tan tyaa̱ ndɨhɨ ra naha uvi taahan ñasuhu tsihin ra. Iin iin ra naha tsa iin nu cruu. Iin ra xiin cuaha ra, tan inga ra xiin satyin ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tacan cuvi̱ tan cundaa̱ cuhva catyí nu tutu Nyoo tyehen: “Javaha̱ nyɨvɨ tsihin ra tumaa javahá ñi tsihin ra caquiñi.” ");
INSERT INTO mjcNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tan nyɨvɨ yahá ican jacuñí nyaa ñi tsi ra, tan javicó ñi jiñi ñi tsa tsacú nducu ñi tsi ra, tan catyí ñi: ―¡Jaan! ¡Yooho tsa caha̱n tyin cua canɨ un vehe ñuhu cahnu, tan tsitsi tsa uñi quɨvɨ cua janduvaha nyico un itsi, ");
INSERT INTO mjcNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ja̱cacu tsi un vityin tan nu̱u nu cruu juvin! ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tan juvin ñi tacan tsacú nducu tucu ra jutu cuví ityi nuu naha ra tsi ra tan ra maestro cuenda ley vehe ñuhu naha ra, tan natuhun tahan ra naha tan catyí ra naha: ―¡Jacacu̱ ra tsi inga ca nyɨvɨ, maa tyin ña cuví jacacu ra tsi maa ra! ");
INSERT INTO mjcNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tun nuu ra nu cruu vityin nyehe yo, tacan tan cua tsinu iñi yo tyin juvin ra cuví ra Cristo, Rey cuenda yo tsa cuví yo nyɨvɨ Israel ―catyí ra naha. Tan nda cuanda nu ñasuhu tsa ticaá nu cruu nduvi tsiyo xiin ra tan tsacu̱ nducu ndɨhɨ nahnu tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cuhva tsa cua tahan hora, ndunaa̱ nanɨɨ cahnu nda cuanda caa uñi tsa tseñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tan juvin ñi cuhva can cana̱ tsaa ra Jesús tsihin tandɨhɨ tunyee iñi ra, tan catyí ra: ―Eloi, Eloi, ¿lama sabactani? ―tan cuñí tsi catyí: Nyoo Jutu yu, Nyoo Jutu yu, ¿nacuenda nacoo̱ ihñi un tsi yu? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Juhva ra yucú ican naha ra tsiñi̱ ra naha tsa caha̱n ra tan catyí ra naha: ―¡Jihna ndo! Caná tsaa ra tsi ra Elías, ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tacan tan tsinú xaan iin ra tsiquihi̱n ra iin yahma tsa caá tumaa caá catyi, tan jatyii̱ ra can tsihin vinu iya. Tan tyaa̱ ra can iin nu yutun tan jatuhva̱ ra yuhu ra Jesús tyin coho ra vinu can, tan catyí ra: ―Na cuatu nuu yo. Nyehe yo tun quitsi ra Elías januu ra tsi ra nu cruu can ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tacan tan ñihi xaan cana̱ tsaa ra Jesús, tan tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tan jahma tsa ticaá tsitsi vehe ñuhu cahnu ndata̱ sava tsi, nda sɨquɨ tan nda cuanda ityi tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tan ra capitán tsa yɨhɨ́ ndaha andaru tsa nyaá yatyin ñi nu ticaá ra Jesús nyehe̱ ra nácaa cana̱ tsaa ra, tan nácaa tsihi̱ ra, tacan tan catyí ra: ―Nditsa nditsa cuii tyin Sehe Nyoo tsi ra ihya ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tan ndasava ñi nyecú tucu juhva ñiñaha nyehé ñi. Tan mahñu ñi can nyií ña María tsa quee̱ ñuu Magdala, tan ña María sɨhɨ ra José tan ra Jacobo ra tyuvaa ca. Tan nyií tucu ña Salomé. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ñiñaha ihya tsinyicu̱n ñi tsi ra Jesús, tan jatyinyee̱ ñi tsi ra quɨvɨ tsica̱ nuu ra ityi Galilea. Tan yucú cuaha tucu ñiñaha inga ñuu tsa tsaa̱ tsihin ra ñuu Jerusalén ican. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Quɨvɨ tsa tuhvá nyɨvɨ janduvaha tsa catsi ñi cuenda inga quɨvɨ tuhvá ñi quitatu, juvin ñi tseñi can ");
INSERT INTO mjcNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","tsaa̱ ra José ra ñuu Arimatea nu nyií ra Pilato. Ra José can cuví ra iin ra nyisó tyiñu cahnu vehe tyiñu, tan ndatú tucu maa ra tsi ra tsa cua jaquitsi Nyoo tyin cundaca ñaha nu ñuhu ñayɨvɨ. Ña nayuhvi̱ ra tan tsaha̱n ra tsindaca̱n ra cuñu ñuhu ra Jesús tsi ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tsa tsito̱ ra Pilato tyin tsa yaha̱ tsihi̱ ra Jesús, iyo xaan cuñí ra. Tacan tan cana̱ ra tsi iin capitán tan tsica̱ tuhun ra tsi ra tun nditsa tyin tsa tsihi̱ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tan tsa tsito̱ vaha ra Pilato tyin tsa yaha̱ tsihi̱ ra Jesús, tava̱ tyiñu ra na cuhva ra andaru naha ra cuñu ñuhu ra tsi ra José. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tacan tan tsijata̱ ra José iin jahma cuitsin tsa tsinu̱ tsihin jahma vaha tsa nañí linu, tan januu̱ ra cuñu ñuhu ra Jesús nu cruu. Yaha can tan cava̱ nuu ra jahma can cuñu ñuhu ra. Tacan tan tyihi̱ ra cuñu ñuhu ra tsitsi iin ñaña tsa nyaá nduvaha̱ tsitsi iin cava. Tan tyasɨ̱ ra yuhu ñaña can tsihin iin yuu cahnu. ");
INSERT INTO mjcNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tan ña María, tsa quee̱ ñuu Magdala, tan ña María, sɨhɨ ra José, tsaha̱n ñi, tsinyehe̱ ñi nu tinyii̱ ra José can cuñu ñuhu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tsa yaha̱ quɨvɨ quitatú nyɨvɨ, ña María ñuu Magdala, tan ña María sɨhɨ ra Jacobo, tan ña Salomé jata̱ ñi ndutya tami tyin cuñí ñi cuhun ñi cutyihi ñi can cuñu ñuhu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tacan tan cuahán ñi nu nyaá ñaña ra tsa cunditsi̱n cuii ñi quɨvɨ quitsaha̱ vitya. Tan tsaa̱ ñi ican cuhva tsa cua cana̱ cuii ñi ñicanyii. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tan ityi cuahán ñi natuhu̱n tahan ñi tan catyí ñi: ―¿Yóo cua jatsiyo yuu yuhu ñaña can? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Maa tyin cuhva tsa tsaa̱ ñi nyehe̱ ñi tyin tsa catsiyo̱ yuu cahnu tsa ndasɨ́ yuhu ñaña can. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tan cuhva tsa quɨhvɨ̱ ñi tsitsi cava nu nyaá ñaña can, nyehe̱ ñi nyaá iin ángel tsiyo cuaha. Tan caá ra tumaa caá iin ra tyuvaa. Nditsí ra jahma cuitsin cañi. Tan nayuhvi̱ xaan ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Maa tyin catyí ra tsihin ñi: ―Ña na̱yuhvi ndo. Tsitó yu tyin nanducú ndo tsi ra Jesús, ra ñuu Nazaret, ra tsa tsihi̱ nu cruu. Maa tyin nduve ca ra nyií ihya vityin tyin tsa nandoto̱ ra. Nye̱he ndo nu tinyii̱ ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cu̱aahan ndo tan jacoto ndo tsi ra Pedro tan tsi inga ca ra tsica̱ tsihin ra Jesús. Tan ca̱tyi ndo tsihin ra naha tyin tsa cuahán ra Galilea tan cua cuatu ra tsi ra naha ndacan, tumaa catyi̱ maa ra tsihin ra naha tsa ndi cumañi ca cúu ra ―catyí ángel can tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tacan tan tsinú xaan ñi cuahán ñi, tyin nɨhɨ́ ñi jahá tsa yuuhví ñi. Tan ña caha̱n maa ñi tsa cahan ñi tsihin ndi intuhun maa nyɨvɨ tyin yuuhví xaan ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ra Jesús nandoto̱ ra quɨvɨ quitsahá vitya. Tan quituvi̱ ra jihna cuii ca nuu ña María ñuu Magdala. Juvin ña cuví ña tsa tava̱ ra utsa tatyi ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tsaha̱n ña tsijacoto̱ ña tsi ra tsicá tsihin ra, tyin yucú ra naha tsihin tucuiihya iñi tan tsacú ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maa tyin cuhva tsa tsiñi̱ ra naha tyin nyito ra Jesús tan nyehe̱ ña tsi ra, ña tsinu̱ iñi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsa yaha̱ yacan, tan quituvi̱ ra Jesús nuu uvi ra tsa cuahán ityi cuhu naha ra. Maa tyin sɨɨn cuhva caá ra nyehe̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tan tsinuhu̱ ra naha tsijacoto̱ ra naha tsi tandɨhɨ ca ra naha. Maa tyin juvin ñi ña tsinu̱ iñi ra naha tsa caha̱n ra can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yaha yacan tan quituvi̱ ra Jesús nuu tandɨhɨ tsa utsi iin ra tsa tsica̱ tsihin ra, tsitsi tsa nyecú ra naha nu mesa. Tan cuxaa̱n ra tsi ra naha tsa cuenda tsa ña tsinú iñi ra naha, tan tsa cuenda tucu tsa ndava añima ra naha tan ña tsinu̱ iñi ra naha tsa caha̱n nyɨvɨ tsa nyehe̱ tsi ra tsa yaha̱ nandoto̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tan catyí ra tsihin ra naha: ―Cu̱aahan ndo nanɨɨ cahnu nu ñuhu ñayɨvɨ, tan ca̱han ndo tuhun Nyoo tsihin tandɨhɨ nyɨvɨ, tan ca̱tyi ndo tsihin ñi nácaa jacacú Nyoo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tan nyɨvɨ tsa cua tsinu iñi tan coondutya ñi, cua cacu ñi. Maa tyin ñi tsa ña cua tsinu iñi cua ndoo cuatyi ñi sɨquɨ ñi tan cua cunaa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tan tandɨhɨ tsa iyo ihya cua javaha nyɨvɨ tsa cua tsinu iñi tsi yu: Tsihin sɨvɨ yu cua tava ñi tatyi ña vaha, tan cua cahan ñi inga yuhu tsa ña tuhvá ñi cahan. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cua tɨɨn ñi coo, tan tatun coho ñi o catsi ñi tsa yɨhɨ́ venenu, ña cua jacuehe can tsi ñi. Cua tyiso ndaha ñi jiñi nyɨvɨ cuuhví, tan cua nduvaha nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tsa ndɨhɨ̱ caha̱n Jutu Mañi yo Jesús tsihin ra naha, tacan tan ndaa̱ ra andɨvɨ, tan tsinyaa̱ ra xiin cuaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tacan tan ra tsica̱ tsihin ra quita̱ ra naha tan tsaha̱n ra naha tandɨhɨ ñi ityi tsicaha̱n ra naha tuhun Nyoo nácaa jacacú ra tsi yo. Juvin ñi maa Jutu Mañi yo jatyinyee̱ tsi ra naha tyin tsaha̱ ra tsa javaha ra naha cuaha tsa iyo. Tan tsihin yacan nyehe̱ nyɨvɨ tyin nditsa tsa caahán ra naha. Tan na cuvi tsi tacan ñi.");
INSERT INTO mjcNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Cuaha ñi nyɨvɨ nducu̱ ñi cuhva tyaa ñi nuu tutu tandɨhɨ tsa cuvi̱ nu yucú ndi ihya. Tyaa̱ ñi cuhva ");
INSERT INTO mjcNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","nacatyí tuhun nyɨvɨ tsihin yo, ñi tsa nyehe̱ tan caha̱n tuhun ra Jesús nda quɨvɨ jihna ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tan yuhu tucu tsa yaha̱ cahvi̱ yu tan nducu̱ tuhun vaha yu tandɨhɨ tsa cuvi̱ nda nu quitsaha̱. Yacan cuenda cuñí yu tyaa yu tuhun ihya tsa cuenda un, yooho Teófilo, nda nu quitsaha̱ tan nda nu ndɨhɨ̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tyin tacan tan coto un tyin nditsa tsa jacuaha̱ nyɨvɨ tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Quɨvɨ tsa cuví ra Herodes rey tanɨɨ cahnu cuenda Judea, tsicoo̱ iin ra cuví jutu, nañí ra Zacarías. Tan yɨhɨ́ ra cuenda ra cuví jutu naha ra tsa nañí Abías. Tan ñasɨɨhɨ ra nañí ña Elisabet. Tata ra Aarón, ra cuvi̱ jutu taha̱n tsanaha, cuví ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tan nduve maa cuatyi ñi nuu Nyoo. Tyin vaha xaan tyaá yahvi ñi tuhun caahán Nyoo Jutu yo. Tan yoñi maa cuví tyaa cuatyi tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tan nduve maa sehe ñi tsicoo̱. Tyin ña Elisabet, ña cuví coo sehe ña. Tan tsa tsahnu xaan nduvi taahan ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Iin quɨvɨ taahán tsi tandɨhɨ ra jutu tsa cutahan tsihin ra Zacarías, tsa jaha tyiñu ra naha tyiñu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tan cuhva iyó maa ra cuví jutu naha ra, tava̱ ra naha suerte, ndáa ra cua tahan tsi quɨhvɨ tsitsi vehe ñuhu Jutu Nyoo, tyin cahmi ra cutu. Quɨvɨ can taha̱n tsi tsi ra Zacarías. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tan cuaha nyɨvɨ yucú ityi tsata vehe ñuhu tsicán tahvi ñi tsi Nyoo, tsitsi tsa tsahmí ra cutu can. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tan tsitsi tsa ndi nyií ra ican tan quituvi̱ iin ángel Jutu Nyoo nu nyií ra. Tan nyaá nyityi ángel can ityi xiin cuaha nu nyaá altar nu tsahmí ra cutu. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tan tsa nyehe̱ ra Zacarías tsi ángel ican, iyo xaan cuñi̱ ra. Tan nayuhvi̱ xaan ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tan ángel ican catyí ra tsihin ra: ―Zacarías, ña nayuhvi un. Tyin Nyoo tsiñi̱ ra tsa caha̱n un tsihin ra. Tan cua coo iin sehe ña Elisabet ñasɨɨhɨ un. Tan cua cunañi ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sɨɨ xaan cua cuñi un. Tan cuaha xaan nyɨvɨ cua cusɨɨ ndɨhɨ iñi quɨvɨ cua cacu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tyin sehe un, cahnu xaan cua cuvi ra nuu Nyoo Jutu yo. Ña cua coho ra vinu tan ndi nyixi. Tan ñihi xaan cua quɨhɨ Tatyi Ii Nyoo tsi ra tsa ndi cumañi ca cacu ra tan tandɨhɨ tyembu tsa cua coo ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tan cuaha xaan nyɨvɨ Israel cua cunyicun ñi tsi Jutu yo Nyoo jaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juvin ra cua cuhun ityi nuu Jutu Mañi yo. Tan cua coo tunyee iñi Nyoo tsi ra. Tan cua quɨhɨ xaan Tatyi Ii Nyoo tsi ra. Tyin cua cuvi ra tumaa ra Elías, ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Tan cua cuhva cuenda ra nácaa coo vaha nyɨvɨ iyó sehe tsihin sehe ñi. Tan cua janaha ra tsi nyɨvɨ caquiñi, na tyaa yahvi ñi tuhun caahán Nyoo. Tacan cua janduvaha ra tsi nyɨvɨ tan cua cuatu vaha ñi tsi Nyoo ―catyí ángel tsihin ra Zacarías. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tan tsica̱ tuhun ra Zacarías tsi ángel can, tan catyí ra: ―¿Nacaa tan coto yu tyin nditsa tsa cua coo sehe ñasɨɨhɨ yu? Tyin yuhu tsa tsahnu xaan yu. Tan tacan tucu ñasɨɨhɨ yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tan ángel can nacaha̱n ra tan catyí ra: ―Yuhu Gabriel nañí yu. Tan tsicá yu tyiñu Nyoo. Maa ra tava̱ tyiñu tsi yu tyin jacoto yu tyiñu ihya tsi un tan jacoto yu tuhun vaha ihya tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tan vityin cua nduñɨɨhɨ un. Tyin ña tsinú iñi un tsa caahán yu tsihin un. Tan ña cua cuvi cahan un nda cuanda tsa yaha cacu sehe ñasɨɨhɨ un. Tan nda quɨvɨ cundaa tandɨhɨ tsa caha̱n yu tsihin un ―catyí ángel ican tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tan nyɨvɨ tsa ndatú tsi ra Zacarías ityi tsata vehe ñuhu, iyo xaan cuñí ñi tyin cucuee xaan ra tsitsi vehe ñuhu can. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tan cuhva tsa quita̱ ra Zacarías, ña cuví maa cahan ra tsihin ñi. Tan tuvi̱ iñi ñi tyin iyó tsa nyehe̱ ra tsitsi vehe ñuhu can. Tacan tan quitsaha̱ caahán ra tsihin ñi tsihin ndaha ra. Tyin ña cuví cahan ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tan quɨvɨ ndɨhɨ̱ tyiñu jahá ra Zacarías vehe ñuhu can, tan cuanuhu̱ ra yuvehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tsa yaha̱ quɨvɨ can tan tsicuhu̱n sehe ñasɨɨhɨ ra, ña Elisabet. Tan ña quita̱ maa ña tsata vehe tsa tandɨhɨ tsa uhun yoo. Tan tsicá iñi ña: ");
INSERT INTO mjcNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Tyehen javaha̱ Jutu Mañi yu tsihin yu, tyin tacan tan ña cahan nyaa ca nyɨvɨ tsi yu”, cuñí ña tsicá iñi ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tsa quita̱ iñu yoo tsa ñuhú sehe ña Elisabet, tan jacuhu̱n Nyoo tsi ra ángel Gabriel ñuu Nazaret tsa canyií Galilea. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tyin cahan ra tsihin iin ñaha yoco tsa nañí María. Tan tsa nyaa̱ maa tsa cua tindaha ña tsihin ra nañí José, ra cuví tata ra rey David. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tan quɨhvɨ̱ ángel ican nu iyó ña María. Tan catyí ra tsihin ña: ―Nacumi tsi un, María. Ñihí un tumañi iñi nuu Nyoo. Maa ra iyó tsihin un. Tan nasocó xaan ca ra tsi un tan ñavin ca tandɨhɨ ca ñaha ―catyí ángel ican tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tan tsa tsiñi̱ ña tsa caha̱n ra, iyo xaan cuñí ña tsa caha̱n ra. Tan tsica̱ iñi ña: “¿Nacuenda tacan caahán ra ihya nacumi tsi yo?” tsicá iñi ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tan catyí ángel ican: ―Ña na̱yuhvi un, María, tyin ñihí un tumañi iñi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vityin cua cuhun sehe un. Tan cua cunañi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Cahnu xaan ra cua cuvi ra. Tan Sehe Nyoo cahnu cua cuvi ra. Tan cua cuvi ra rey jaha Nyoo Jutu yo, tumaa cuvi̱ ra David, tsii tsaahnu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tyin cua cundaca ñaha ra tsi nyɨvɨ Israel tandɨhɨ maa tyembu. Tan ña cua ndɨhɨ maa tsa cundaca ñaha ra ―catyí ángel can tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tacan tan tsica̱ tuhun ña María tsi ángel, tan catyí ña: ―¿Nacaa cua cuvi can? Tyin yuhu, ñaha ca coo yɨɨ yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tan nacaha̱n ángel tan catyí ra: ―Maa Tatyi Ii Nyoo cua quitsi sɨquɨ un. Tan tunyee iñi Nyoo, ra nyaá gloria, cua quitsi tan cua casɨ tsi sɨquɨ un tumaa iin vico. Yacan cuenda Ra Ii tsa cua cacu cua cunañi ra Sehe Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tacan tucu ña Elisabet ña tsatsin un cua cacu iin sehe ña vasu tsa tsahnu ña. Tan catyí nyɨvɨ tyin ñaha can ña cuví coo sehe ña. Maa tyin vityin tsa ñuhú sehe ña. Tsa iñu yoo tsa ñuhú sehe ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tyin Nyoo nduve tsa ña cuví jaha ra ―catyí ángel tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tan catyí ña María: ―Yuhu cuví yu musu Jutu Mañi yo. Na javaha maa ra cuhva catyí un ―catyí ña. Tacan tan cuahán ángel can. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tan iin quɨvɨ can, numi ñi cuahán ña María iin ñuu tsa canyií Judea nu maa ñi maa yucu iyó. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tan quɨhvɨ̱ ña tsitsi vehe ra Zacarías. Tan nacuhva̱ ña nacumi tsi ña Elisabet. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tan tsa tsiñi̱ ña Elisabet tsa caha̱n ña María, tan natuñu̱ sehe ña tsitsi ña. Tan ñihi nyaá Tatyi Ii Nyoo tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tan ñihi xaan nacaha̱n ña, tan catyí ña: ―Nyoo nasocó xaan ra tsi un, María, tan ñavin ca tandɨhɨ ca ñiñaha. Tan nasoco̱ ra tsi sehe un. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tan yóo cuví yuhu? Tyin quitsi̱ sɨhɨ Jutu Mañi yu quitsi̱ nyehe ña nu nyaá yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cuhva tsa tsiñi̱ yu tsa caha̱n un, tan natuñu̱ sehe yu tsitsi yu. Tyin sɨɨ xaan cuñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tan sɨɨ xaan cuñí tucu maa añima un tyin tsinú iñi un. Tyin cua cuvi cuhva tsa caha̱n Nyoo tsihin un ―catyí ña Elisabet. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tan catyí ña María: ―Jacahnú yu tsi Nyoo tsihin tandɨhɨ añima yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tan sɨɨ xaan cuñí añima yu tsihin Nyoo ra jacacú tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tyin cuví yuhu iin ñaha ndaahvi tan Nyoo nyehe̱ ndaahvi ra tsi yu. Tan vityin tandɨhɨ quɨvɨ cua cahan nyɨvɨ tyin cahnu xaan tumañi iñi ñihi̱ yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tyin Nyoo, cahnu xaan cuví ra. Tan cahnu tsa javahá ra tsihin yu. Tan ii xaan sɨvɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tan ndaahvi cuñí ra tsihin tandɨhɨ nyɨvɨ tsa cua coo tan tyaa yahvi ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cahnu xaan tsa javahá ra tsihin tunyee iñi tsa iyó tsi ra. Jatsiyo̱ ra tsi nyɨvɨ tsa cahnu xaan tsicá iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Quinyaa̱ ra tunyee iñi iyó tsi nu cuví rey. Tan cua janducahnu ra tsi nyɨvɨ ndaahvi. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tsahá Nyoo tsa vaha tsi nyɨvɨ cuñí coto tsa vaha. Tan nyɨvɨ cuca tsa cuñí tyin nduve tsa tsiñí ñuhu tsi ñi, tsihin ndaha ndɨɨ ñi, jacuhún ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jatyinyeé ra tsi nyɨvɨ Israel tsa cuví ñi musu ra. Tan ña naá iñi ra tsi ñi. Nyehé ndaahvi ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tumaa cuhva catyi̱ Nyoo tsihin ra Abraham, tsii tsaahnu yo, tan tsihin sehe ra, tacan ñi javahá maa Nyoo ―catyí ña María. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tan ña María ndoo̱ ña tsihin ña Elisabet uñi yoo. Tan tsa yaha̱ uñi yoo can tan cuanuhu̱ ña nda yuvehe ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsa tsaa̱ quɨvɨ tsa cacu̱ sehe ña Elisabet, jacacu̱ ña iin rayɨɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tan nyɨvɨ vehe ña tsihin nyɨvɨ tsa iyó yatyin ñi yuvehe ña, sɨɨ xaan cuñí ñi. Tacan tucu maa ña. Tyin vaha xaan tsa javaha̱ Nyoo tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tan tsa quita̱ una quɨvɨ tsa cacu̱ ra, tan tyaa̱ ra naha tuñi Nyoo tsi ra tumaa cuhva iyó maa ñi. Tan cuñí ra naha tsa cunañi ra Zacarías tumaa nañí maa jutu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Maa tyin sɨhɨ ra catyí ña: ―Ña cuví. Tyin Juan cua cunañi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tan catyí ra naha: ―¿Nacuenda jacunañí un Juan tsi ra? Tan yoñi nyɨvɨ ndo nañí tacan ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tan quitsaha̱ tsicá tuhun ra naha tsihin ndaha ra naha tsi jutu ra. Tyin coto ra naha náa sɨvɨ cuñí ra tsa cunañi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tan tsica̱n jutu ra iin vitu, tan nuu vitu ican tyaa̱ ra: “Juan cua cunañi ra”, tyaa̱ ra. Tan tandɨhɨ maa ra ican naha ra iyo xaan cuñí ra naha tsa tacan. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Juvin ñi maa hora can nacaha̱n ra Zacarías. Tan quitsaha̱ jacahnú ra tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tan tandɨhɨ maa nyɨvɨ iyó yatyin yuvehe ñi, iyo xaan cuñí ñi cuvi̱. Tan tandɨhɨ maa nyɨvɨ tsa iyó yucu iyó Judea ican nacatyí tuhun tahan ñi tsa cuvi̱ can. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tan tandɨhɨ maa nyɨvɨ tsa tsito̱ can, tsicá iñi ñi, tan tsicá tuhun tahan ñi tsi ñi: ―¿Yóo ra cua cuvi ra lee ihya? ―catyí ñi. Tyin nditsa, Nyoo nasocó xaan ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ra Zacarías jutu ra Juan, ñihi nyaá Tatyi Ii Nyoo tsihin ra. Tan tsaha̱ cuenda ra tsa caahán Nyoo tsihin ra, tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","―Cahnu xaan ra cuví Jutu yo Nyoo cuenda yo nyɨvɨ Israel. Tyin quitsi̱ ra nu yucú yo, tsa cuví yo nyɨvɨ maa ra. Tan jacacú ra tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tan tsaha̱ ra iin ra tsa cahnu xaan cuví tsi yo, ra cua jacacu tsi yo. Tata ra David, ra tsa cuvi̱ musu Nyoo cuvi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tacan cua javaha ra, catyi̱ Nyoo taha̱n tsanaha, quɨvɨ caha̱n ra cuvi̱ ndusu yuhu ra, tan catyi̱ ra naha tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Cua jacacu Nyoo tsi yo ndaha nu xaan iñi tsi yo, tan nuu tandɨhɨ nu tsa ndasɨ cuñí nyehe tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tan cua cundaahvi iñi ra nyehe ra tsi nyɨvɨ yo tsa tsicoo̱ taha̱n tsanaha. Tan cua nducuhun iñi ra tsa caha̱n ra tsihin ñi taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Caha̱n maa Nyoo tsihin ra Abraham, tsii tsaahnu yo, ");
INSERT INTO mjcNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tan catyi̱ ra tyin cua jacacu ra tsi yo ndaha nu xaan iñi tsi yo. Tyin ña cua nayuhvi ca yo jacahnu yo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tan maa ra cua janaha ra cuhva coo yo. Tan vaha cua coo yo nuu ra tan coo yo maa ñi tsa cuenda maa ra tandɨhɨ quɨvɨ tsa cua coo yo ñayɨvɨ ―catyí ra Zacarías. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tan catyí ra Zacarías tsihin lee can: ―Sehe luhlu yu, yooho cua cuvi un ndusu yuhu Nyoo, ra nyaá gloria. Tyin cuhun un ityi nuu Jutu Mañi yo. Tan cua cahan un tuhun ra tsihin nyɨvɨ tyin tsa cuñí quitsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tan cua jacoto un tsi nyɨvɨ tyin cua jaha Nyoo tucahnu iñi tsi ñi. Tacan tan cacu añima ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tyin Jutu yo Nyoo cuñí ra tsi yo. Tan cundaahví xaan iñi ra tsi yo. Tan cua jaquitsi ra iin ra jatyinyee tsi yo. Tan cuvi ra tumaa ñuhu̱ ñicanyii. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tyin cua janaha ra ñuhu̱ nditsin nu iyó nyɨvɨ nu naa, nu ndatú tuhun tsiihí tsi ñi. Cua janaha ra ityi ra tsi yo, ityi vaha ―catyí ra Zacarías. ");
INSERT INTO mjcNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tan ra luhlu can cua cuahnu ca ra. Ñihi xaan tsicoo̱ tunyee iñi tsi ra tsihin Tatyi Ii Nyoo. Tan tsicoo̱ ra iin tsɨquɨ ndɨɨ nda cuanda quɨvɨ tsa nacoto̱ nyɨvɨ Israel tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Quɨvɨ ican tsicoo̱ iin ra ndacá ñaha, ra cuví rey cahnu, nañí ra Augusto. Tava̱ tyiñu ra tsi ra nyisó tyiñu naha ra na tyaa ra naha sɨvɨ tandɨhɨ nyɨvɨ tanɨɨ cahnu ñuu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ihya cuvi̱ tsa jihna ñi tsinyaa̱ sɨvɨ nyɨvɨ. Tan ra Cirenio cuví ra ra ndacá ñaha tandɨhɨ ñuu nu cuví Siria. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tan tandɨhɨ nyɨvɨ cuanuhu̱ ñi ñuu ñi, tyin cua ndaca ñi sɨvɨ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yacan quee̱ ra José ñuu Nazaret tsa canyií Galilea. Tan cuahán ra ñuu Belén tsa canyií Judea, nu cacu̱ ra rey David, tyin tata ra David cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Cuahán ra cuandacá ra sɨvɨ ra tsihin ña María, tan tsa nyaá maa tsa cua tindaha ñi. Tan ñuhú sehe ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tan tsa ndi yucú ca ñi ñuu Belén ican tan quitsaha̱ cuuhví tsitsi ña tyin tsa cua cacu sehe ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tan ican cacu̱ sehe nuu ña. Tan cava̱ nuu ña jahma tsi ra. Tan nacaqui̱n ña tsi ra tsitsi iin canuva nu tsatsí quɨtɨ itya. Tyin ña ñihi̱ ñi iin vehe coo ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yatyin ñi ñuu Belén can yucú ra jahá cuenda mbee tsa tsacuaa. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tan sana iñi ra naha quituvi̱ iin ángel Nyoo. Tan jandunditsi̱n Jutu yo Nyoo tanɨɨ cahnu nu yucú ra naha. Tan nayuhvi̱ xaan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","―Ña na̱yuhvi ndo ―catyí ángel can―. Tyin vatsí cahan yu iin tsa vaha xaan tsihin ndo. Sɨɨ xaan cua cuñí tandɨhɨ cuii maa nyɨvɨ tsa cuenda tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vityin nda ñuu ra David cacu̱ iin ra cua jacacu tsi nyɨvɨ. Cuví ra Cristo, ra cuví Jutu Mañi yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tan tsihin cuhva ihya cua nacoto ndo tsi ra: cua nañihi ndo tsi ra lee ican, cavá nuu ra jahma tan canyií ra tsitsi iin canuva nu tsatsí quɨtɨ ―catyí ángel can tsihin ra jahá cuenda mbee can. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tan juvin ñi cuhva ican quituvi̱ cuaha xaan ángel tsihin ángel can, tan jacahnú xaan ra naha tsi Nyoo, tan catyí ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Cahnu xaan cuví Nyoo, ra nyaá gloria. Tan nu ñuhu ñayɨvɨ, na coo tsa vaha añima nyɨvɨ tsa ñihí tumañi iñi Nyoo, catyí ra ángel naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tacan tan tsa cuanuhu̱ ángel ican nda gloria. Tan catyí iin tan inga ra jahá cuenda mbee can naha ra: ―Co̱hon ndo Belén. Cunyehe yo náa cuvi̱. Tyin maa Jutu yo Nyoo jacoto̱ tsi yo ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tacan tan numi xaan cuahán ra naha, tan nañihi̱ ra naha tsi ra lee can tsihin ña María tan tsihin ra José. Tan canyií ra lee can tsitsi iin canuva nu tsatsí quɨtɨ itya. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tan cuhva tsa nyehe̱ ra naha tsi ra, quitsaha̱ natuhún ra naha tandɨhɨ tuhun caha̱n ángel tsihin ra naha tsa cuenda lee ican tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tan tandɨhɨ nyɨvɨ tsa tsiñi tuhun caahán ra naha, iyo xaan cuñí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maa tyin ña María naquihi̱n cuenda ña tuhun ican tsitsi añima ña, tan tandɨhɨ tuhun ican tsicá iñi ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tan cuanuhu̱ ra jahá cuenda mbee ican naha ra. Tan jacahnú xaan ra naha tsi Nyoo tsa cuenda tandɨhɨ tsa nyehe̱ ra naha tan tsa tsiñi̱ ra naha. Tyin cundaa̱ cuhva tsa catyi̱ ángel ican tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tsa ndu una̱ quɨvɨ ra Jesús, tan tyaa̱ ñi tuñi Nyoo tsi ra tyin tacan catyí tuhun tsahnu maa ñi. Tan jacunañi̱ ñi Jesús tsi ra. Juvin ñi maa sɨvɨ tsa catyi̱ ángel tsihin ña María quɨvɨ tsa ndi cumañi ca cuhun ra Jesús tsitsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tan tsa yaha̱ quɨvɨ cuhva catyí ley Nyoo tsa tyaa̱ ra Moisés tsa cuenda tsa nduvaha ña nuu Nyoo tsa cacu̱ sehe ña; tacan tan cuahán ñi tsihin ra lee nda ñuu Jerusalén, tyin tyaa cuenda ñi tsi ra ndaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tacan ñi javaha̱ ñi tyin catyí ley Nyoo tyin: “Tandɨhɨ sehe nuu ñi tsa cuví rayɨɨ, cua tyaa cuenda ñi tsi ra ndaha Jutu yo Nyoo”, catyí ley ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tan tsaha̱n ñi tsijamañi̱ ñi uvi taahan quɨtɨ, tyin tacan catyí maa ley Jutu yo Nyoo, nu catyí tsi tyehen: “Cu̱hva ndo uvi taahan curuu a uvi taahan paloma”, catyí ley can. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tan quɨvɨ can iyó iin ra ñuu Jerusalén nañí ra Simeón. Iin ra cuɨtɨ xaan cuví ra, tan jacahnú ra tsi Nyoo. Ndatú ra nda cacu ra cua jacacu tsi ra tsihin tandɨhɨ ca nyɨvɨ ñuu Israel ican. Tan nyaá Tatyi Ii Nyoo tsihin ra Simeón. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tan jacoto̱ Tatyi Ii tsi ra tyin ña cúu naha ra tsa ndi cumañi ca nyehe ra tsi ra Cristo, ra cua jaquitsi Jutu yo Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tan Tatyi Ii jacuhu̱n ra tsi ra Simeón can nda vehe ñuhu. Tan juvin ñi cuhva can tsaa̱ jutu ra tan sɨhɨ ra Jesús tsihin maa ra nu cuví vehe ñuhu cahnu can, tyin javaha ñi cuhva catyí maa ley. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tan cuhva tsa tsaa̱ ñi nu nyaá ra Simeón tan quihi̱n ra Simeón tsi ra Jesús. Tan tyihi̱ jucun ndaha ra tsi ra. Tacan tan quitsaha̱ jacahnú ra tsi Nyoo, tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","―Jutu Mañi yu, vityin tsa cundaa̱ cuhva tsa catyi̱ maa un tsihin yu, tsa cuví yu musu un, cuví jaña ndaha un tsi yu vityin, tan na cúu yu tsihin tsa vaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tyin tsa nyehe̱ tsihin nuu yu tsi ra cua jacacu tsi ndi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tsa iyó ra ihya ityi nuu tandɨhɨ nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tan cua cuvi ra ñuhu̱ tsa cua jandunditsin añima nyɨvɨ tsa ñavin nyɨvɨ Israel cuví. Tan cahnu ca cua jaha ra tsi nyɨvɨ Israel, tsa cuví ndi nyɨvɨ cuenda maa un ―catyí ra Simeón. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tan ra José tsihin sɨhɨ ra Jesús, iyo xaan cuñí ñi tsa tsiñi̱ ñi tsa caha̱n ra Simeón tsa cuenda lee ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tacan tan tsica̱n tahvi ra Simeón tsa cuenda ñi. Tan catyí ra tsihin ña María sɨhɨ ra Jesús: ―Nye̱he tsi lee ihya. Cuaha xaan nyɨvɨ Israel ñuu Nyoo cua tsinu iñi tsi ra quɨvɨ coto ñi tuhun ra, tan cua cacu ñi. Maa tyin cuaha ñi ña cua tsinu iñi ñi tsi ra. Nyoo tsaha̱ ra tsi ra tan cuví ra tumaa seña tsa cuenda yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tacan tan coto tandɨhɨ yo náa tsicá iñi nyɨvɨ tun tsinú iñi ñi o ña tsinú iñi ñi tsi ra. Maa tyin tsa cuenda yooho, María, tsehe cuví tumaa iin mityi xaan tsa cua yaha añima un ―catyí ra Simeón tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tan ican, tsitsi vehe ñuhu cahnu can, nyií tucu iin ñaha tsa cuví ndusu yuhu Nyoo. Nañí ña Ana, tan sehe ra Fanuel, iin ra cuvi̱ tata ra Aser, cuví tsi ña. Tan tsa tsahnu xaan ña. Tan nda luhlu ña tan tindaha̱ ña, maa tyin utsa cuiya ñi tsicoo̱ ña tsihin yɨɨ ña tan tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tan vityin tsa cumi xico cumi cuiya ña. Tan ña quitá maa ña tsitsi vehe ñuhu cahnu can, tyin nduvi tan ñiñu jacahnú ña tsi Nyoo, tan tsicán tahvi ña tan iyó nyitya ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tan juvin ñi tsa ndi nyií ca ra José tan ña María tsihin lee ican, tan tsaa̱ ña Ana nu yucú ñi. Tan quitsaha̱ nacuhvá ña tyahvi nyoo tsi Nyoo. Tan caha̱n ña tuhun ra Jesús tsihin tandɨhɨ nyɨvɨ tsa yucú ican, nyɨvɨ tsa ndatú tsa cacu ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tacan tan tsa yaha̱ tsa javaha̱ ñi tandɨhɨ maa tsa taahán tsi javaha ñi cuhva catyí ley Jutu yo Nyoo, tan cuanuhu̱ ñi nda ñuu Nazaret tsa canyií Galilea nu cuví ñuu maa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tan ra luhlu Jesús vatsí cuahnu ca ra. Tan cua ndunyee ca ra, tan tsihin tsa tsiñi tuñi tsi maa ra. Tan Nyoo nasocó xaan ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ra José tsihin sɨhɨ ra Jesús tuhvá ñi tsicá vico pascua nda ñuu Jerusalén ndɨhɨ ñi cuiya. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tan tsa quita̱ tsa utsi uvi cuiya ra Jesús, tan tsaha̱n tandɨhɨ ñi nda ñuu Jerusalén, cuhva tuhun tsa iyó maa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tan quɨvɨ ndɨhɨ̱ vico, tan vatsí nuhu ñi, maa tyin ra luhlu Jesús ndoo̱ ra ñuu Jerusalén can. Tan ña jaha̱ jutu ra tan sɨhɨ ra cuenda. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tsicá iñi maa ñi tyin vatsí maa ra tyañu tandɨhɨ nyɨvɨ ican. Tan ndɨhɨ̱ iin quɨvɨ tsicá ityi ñi. Tacan tan quitsaha̱ nanducú ñi tsi ra tyañu nyɨvɨ nacotó tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Maa tyin ña nañihí ñi tsi ra. Tacan tan cuahán ñi nda ñuu Jerusalén inga tsaha cuananducú ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tan tsa yaha̱ uñi quɨvɨ tan nañihi̱ ñi tsi ra tsitsi vehe ñuhu cahnu ican. Nyaá ra tyañu ra cuví maestro cuenda ley vehe ñuhu naha ra. Tyaá soho ra tuhun caahán ra naha. Tan tsicá tuhun ra tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tan tandɨhɨ nyɨvɨ tsiñí tsa caahán ra, iyo xaan cuñí ñi tsihin tsa tsiñi tuñi tsa iyó tsi ra, tan tsihin tsa nacatyí tuhun ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cuhva tsa nyehe̱ jutu ra tan sɨhɨ ra tsi ra, iyo xaan cuñi̱ ñi, tan sɨhɨ ra catyí ña tsihin ra: ―Sehe luhlu yu. ¿Nacuvi tyin javaha̱ un tyehen? Jutu un tan yuhu tuñú xaan cuñí ndi tan nanducú xaan ndi tsi un ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tacan tan catyí ra Jesús: ―¿Nacuenda nanducú ndo tsi yu? ¿A ña tsitó ndo tyin ñiñi ca cuñí tsi nyehé yu tyiñu Jutu yu? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Maa tyin ña cutuñi̱ iñi ñi tsa caahán ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tacan tan cuanuhu̱ ra tsihin ñi nda ñuu Nazaret. Tan vaha javahá ra tyin tyaá yahvi ra tsi ñi. Tan sɨhɨ ra naquihi̱n vaha ña tandɨhɨ tuhun ihya tsitsi añima ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tan ra Jesús cua cuahnu ca ra tan tsaá ca tsa tsiñi tuñi jiñi ra. Tan sɨɨ xaan cuñí Nyoo tsihin ra, tacan tucu nyɨvɨ, sɨɨ xaan cuñí ñi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tsa quita̱ tsahun cuiya tsa cuví ra Tiberio rey cahnu, tan ra Poncio Pilato ndacá ñaha Judea. Tan ra Herodes ndacá ñaha ra Galilea. Tan yañi ra, ra Felipe ndacá ñaha ra Iturea tsihin Traconite. Tan ra Lisanias ndacá ñaha ra Abilinia quɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Tan ra Anás tsihin ra Caifás cuví ra naha jutu tsaahnu tsa cuví ityi nuu. Quɨvɨ can caha̱n Nyoo tsihin ra Juan sehe ra Zacarías iin nu tsɨquɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tan ra Juan tsicá nuu ra tandɨhɨ ñuu tsa cayucú yatyin ñi yutya cahnu Jordán, caahán ra tuhun Nyoo tsihin nyɨvɨ. Tan catyí ra tsihin ñi tyin na ndu uvi iñi ñi cuatyi ñi tan coondutya ñi. Tacan tan Nyoo cua jaha ra tucahnu iñi cuatyi ñi, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tumaa caahán tuhun tsa nyaá nu libru tsa tyaa̱ ra Isaías, ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Tan catyí ra: Cua tyaa soho yo ndusu ra nu caná tsaa ra nu tsɨquɨ tan catyí ra: “Nu̱ña ndo iin ityi cuɨtɨ tan na̱tyiso vaha ndo tsi ndo tyin tsa vatsi Jutu Mañi yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tumaa tsa tahví ndo yucu tan jandutú ndo xahva cunu, jandoó ndo ityi yacua, tan janduvahá ndo nu quiñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tacan tan tandɨhɨ nyɨvɨ cua nyehe ñi tsi ra tsa cua jaquitsi Nyoo tyin jacacu ra tsi yo.” Tacan tan caha̱n ra Juan tsihin nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tan tsa cuahán nyɨvɨ tsa cuñí ñi jacoondutya ra tsi ñi, tan catyí ra tsihin ñi: ―¡Nyooho cuví ndo tumaa tata coo! ¿A cuñí ndo tyin tsihin tsa coondutya ñi ndo tan ña cua tatsi tuñi ca Nyoo tsi ndo? Ña cuvi. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yacan na̱sama ndo cuhva iyó ndo, na nyehe yo tyin tsa ndu uvi̱ iñi ndo cuatyi ndo nuu Nyoo. Tan ña nduyaa ndo cahan ndo tyin nyɨvɨ tata ra Abraham cuví ndo. Tyin cuanda tsihin yuu ihya, Nyoo cuví jananduvi ra iin nyɨvɨ ra Abraham. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tsa ndatú yatsa Nyoo tsi tandɨhɨ ndo tyin cuví ndo tumaa yutun tsa ña tsahá tsɨtɨ vaha, cua tyahnya tun tan cua cayu tun, tacan cua javaha Nyoo tsihin ndo ―catyí ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tacan tan nducu̱ tuhun ñi tsi ra tan catyí ñi: ―¿Tan nácaa javaha ndi? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tacan tan nacaha̱n ra Juan: ―Ra tsa iyó uvi taahan jahma, taahán tsi cuhva ra intuhun tsi tsi ra tsa nduve jahma. Tan ra tsa iyó tsa catsi, taahán tsi cuhva ra luxu catsi ra tsa nduve tsa catsi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tan tsaa̱ tucu ra tsa tavá xuhun cuenda ra ndacá ñaha nda ñuu Roma, tsa cuñí ra naha coondutya ra naha. Tan nducú tuhun ra naha tsi ra Juan: ―Maestro, ¿nácaa javaha tucu nyuhu? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tan catyí ra Juan tsihin ra naha: ―Cuhva catyí ley ñi ta̱va ndo xuhun. Tan ña jandaa ca ndo yahvi. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tacan tan tsica̱ tuhun tucu andaru naha ra tsi ra: ―Tan nyuhu tucu, ¿nácaa javaha ndi? ―catyí ra naha. Tan nacaha̱n ra Juan tan catyí ra: ―Ña qu̱inyaa ca ndo tsa tsii nyɨvɨ. Tan ña ja̱yuhvi ca ndo tsi ñi. Ña tya̱a ndo cuatyi tsi ñi tatun nduve cuatyi ñi. Tan ndo̱o ndo vaha tsihin yahvi ndo ―catyí ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tan quɨvɨ can tandɨhɨ nyɨvɨ ndatú ñi tsi ra Cristo. Tan tsicá iñi ñi tun juvin ra Juan cuví Cristo. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Maa tyin ra Juan catyí ra tsihin tandɨhɨ ñi: ―Tsa nditsa tyin jacoondutyá yu tsi ndo tsihin ndutya. Maa tyin vatsí inga ra tsa cahnu ca cuví, tan iyó ca tunyee iñi Nyoo tsi ra tan ñavin ca yuhu. Yacan cuenda ña taahán tsi tsi yu ndi tsa cuvi yu musu ra tan ndatsi yu ñɨɨ nditsan ra. Tan ra ican cua jacoondutya ra tsi ndo tsihin Tatyi Ii Nyoo, tan tsihin ñuhu̱ ihñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tan ra ican ndahá ra pala tyin cua jandava ra trigu. Cua natava sɨɨn ra trigu vaha tan cua naquɨhvɨ vaha tsi jaha ra. Tan cua cahmi ra tsahan tsa quita tsihin trigu can tsihin ñuhu̱ tsa ña cua ndahva maa ―catyí ra Juan tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tan tacan caha̱n ra Juan tsihin nyɨvɨ can. Tan náa ndɨhɨ ca maa cuhva caha̱n ra tan jacoto̱ ra tsi ñi nácaa tsa cua quitsi Sehe Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tacan tucu ñi nduxaa̱n ra Juan tsi ra Herodes, ra ndacá ñaha Galilea, tsa cuenda tsa naquihi̱n ra tsi ña Herodías, ñasɨɨhɨ ra Felipe, yañi ra, tsihin tsa cuenda náa ndɨhɨ tsa ña vaha javahá ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Maa tyin ña tyaa̱ yahvi maa ra Herodes tuhun caha̱n ra Juan. Nu ndɨhɨ tuhun tinyii̱ ra tsi ra Juan tsitsi vehe caa. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tsa ndi cumañi ca cuhun ra Juan vehe caa tan jacoondutya̱ ra tsi tandɨhɨ nyɨvɨ. Tan jacoondutya̱ ndɨhɨ ra tsi ra Jesús. Tsa yaha̱ tsicoondutya̱ ra, tsica̱n tahvi ra tsi Nyoo, tacan tan nuña̱ andɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tan nuu̱ Tatyi Ii Nyoo sɨquɨ ra tumaa iin paloma. Tan caha̱n iin ndusu ityi sɨquɨ andɨvɨ, tan catyí tsi tyehen: ―Yooho cuví Sehe yu, tan cuñí xaan yu tsi un. Tan sɨɨ xaan cuñí yu nyehé yu tsi un ―catyí ndusu ican tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tan tsa iyó maa tan oco utsi cuiya ra Jesús tan quitsaha̱ jahá tyiñu ra tyiñu Nyoo. Tan tandɨhɨ nyɨvɨ cuñí maa ñi tyin sehe ra José cuví tsi ra. Tan ra José, sehe ra Elí cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Tan ra Elí, sehe ra Matat cuvi̱ tsi ra. Tan ra Matat, sehe ra Leví cuvi̱ tsi ra. Tan ra Leví, sehe ra Melqui cuvi̱ tsi ra. Tan ra Melqui, sehe ra Jana cuvi̱ tsi ra. Tan ra Jana, sehe ra José cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Tan ra José, sehe ra Matatías cuvi̱ tsi ra. Tan ra Matatías, sehe ra Amós cuvi̱ tsi ra. Tan ra Amós, sehe ra Nahum cuvi̱ tsi ra. Tan ra Nahum, sehe ra Esli cuvi̱ tsi ra. Tan ra Esli, sehe ra Nagai cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Tan ra Nagai, sehe ra Maat cuvi̱ tsi ra. Tan ra Maat, sehe ra Matatías cuvi̱ tsi ra. Tan ra Matatías, sehe ra Semei cuvi̱ tsi ra. Tan ra Semei, sehe ra José cuvi̱ tsi ra. Tan ra José, sehe ra Judá cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Tan ra Judá, sehe ra Joana cuvi̱ tsi ra. Tan ra Joana, sehe ra Resa cuvi̱ tsi ra. Tan ra Resa, sehe ra Zorobabel cuvi̱ tsi ra. Tan ra Zorobabel, sehe ra Salatiel cuvi̱ tsi ra. Tan ra Salatiel, sehe ra Neri cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Tan ra Neri, sehe ra Melqui cuvi̱ tsi ra. Tan ra Melqui, sehe ra Adi cuvi̱ tsi ra. Tan ra Adi, sehe ra Cosam cuvi̱ tsi ra. Tan ra Cosam, sehe ra Elmodam cuvi̱ tsi ra. Tan ra Elmodam, sehe ra Er cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Tan ra Er, sehe ra Josué cuvi̱ tsi ra. Tan ra Josué, sehe ra Eliezer cuvi̱ tsi ra. Tan ra Eliezer, sehe ra Jorim cuvi̱ tsi ra. Tan ra Jorim, sehe ra Matat cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Tan ra Matat, sehe ra Leví cuvi̱ tsi ra. Tan ra Leví, sehe ra Simeón cuvi̱ tsi ra. Tan ra Simeón, sehe ra Judá cuvi̱ tsi ra. Tan ra Judá, sehe ra José cuvi̱ tsi ra. Tan ra José, sehe ra Jonán cuvi̱ tsi ra. Tan ra Jonán, sehe ra Eliaquim cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Tan ra Eliaquim, sehe ra Melea cuvi̱ tsi ra. Tan ra Melea, sehe ra Mainán cuvi̱ tsi ra. Tan ra Mainán, sehe ra Matata cuvi̱ tsi ra. Tan ra Matata, sehe ra Natán cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tan ra Natán, sehe ra David cuvi̱ tsi ra. Tan ra David, sehe ra Isaí cuvi̱ tsi ra. Tan ra Isaí, sehe ra Obed cuvi̱ tsi ra. Tan ra Obed, sehe ra Booz cuvi̱ tsi ra. Tan ra Booz, sehe ra Salmón cuvi̱ tsi ra. Tan ra Salmón, sehe ra Naasón cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Tan ra Naasón, sehe ra Aminadab cuvi̱ tsi ra. Tan ra Aminadab, sehe ra Aram cuvi̱ tsi ra. Tan ra Aram, sehe ra Esrom cuvi̱ tsi ra. Tan Esrom, sehe ra Fares cuvi̱ tsi ra. Tan ra Fares, sehe ra Judá cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Tan ra Judá, sehe ra Jacob cuvi̱ tsi ra. Tan ra Jacob, sehe ra Isaac cuvi̱ tsi ra. Tan ra Isaac, sehe ra Abraham cuvi̱ tsi ra. Tan ra Abraham, sehe ra Taré cuvi̱ tsi ra. Tan ra Taré, sehe ra Nacor cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Tan ra Nacor, sehe ra Serug cuvi̱ tsi ra. Tan ra Serug, sehe ra Ragau cuvi̱ tsi ra. Tan ra Ragau, sehe ra Peleg cuvi̱ tsi ra. Tan ra Peleg, sehe ra Heber cuvi̱ tsi ra. Tan ra Heber, sehe ra Sala cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Tan ra Sala, sehe ra Cainán cuvi̱ tsi ra. Tan ra Cainán, sehe ra Arfaxad cuvi̱ tsi ra. Tan ra Arfaxad, sehe ra Sem cuvi̱ tsi ra. Tan ra Sem, sehe ra Noé cuvi̱ tsi ra. Tan ra Noé, sehe ra Lamec cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Tan ra Lamec, sehe ra Matusalén cuvi̱ tsi ra. Tan ra Matusalén, sehe ra Enoc cuvi̱ tsi ra. Tan ra Enoc, sehe ra Jared cuvi̱ tsi ra. Tan ra Jared, sehe ra Mahalaleel cuvi̱ tsi ra. Tan ra Mahalaleel, sehe ra Cainán cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Tan ra Cainán, sehe ra Enós cuvi̱ tsi ra. Tan ra Enós, sehe ra Set cuvi̱ tsi ra. Tan ra Set, sehe ra Adán cuvi̱ tsi ra. Tan ra Adán, sehe Nyoo cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tan ñihi nyaá Tatyi Ii Nyoo tsihin ra Jesús tsa yaha̱ tsicoondutya̱ ra, quita̱ ra yutya Jordán tan cuanuhu̱ ra. Tan quihi̱n Tatyi Ii Nyoo tsi ra, tan tsaha̱n ra iin nu cuví nu tsɨquɨ ");
INSERT INTO mjcNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","nu tsinyii̱ ra uvi xico nduvi. Tan ña tsatsi̱ maa ra tandɨhɨ quɨvɨ ican. Yaha̱ can tan quitsi̱ tsa tsisocó ra. Tan nducú cuhva nu ña vaha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tan catyí nu tsihin ra: ―Tatun juvin Sehe Nyoo cuví tsi un, ca̱han tsihin yuu ihya, na nanduvi tsi paan catsi un. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tan ra Jesús nacaha̱n ra tan catyí ra: ―Tuhun Nyoo tsa nyaá nu tutu, catyí tsi tyin ña maa ñi tsihin tsa catsi nyɨvɨ coonyito ñi, tyin coonyito ñi tsihin tandɨhɨ tuhun caahán Nyoo ―catyí ra Jesús tsihin nu ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tacan tan quihi̱n nu ña vaha tsi ra Jesús, cuahán ra iin jiñi yucu sucun. Tan iin yaha ñi janaha̱ nu tandɨhɨ tsa cuca nu ndacá ñaha nu ñuu ñayɨvɨ ihya tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tan catyí nu tsihin ra: ―Cuhva yu tandɨhɨ tsa nyehé un tun cuñí un tyin maa Nyoo tsaha̱ tsa cundaca ñaha yu tandɨhɨ can, tan ndáa ra cuñí yu cuhva yu can, cuvi tsii ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tatun yooho tan cuɨñɨ tsɨtɨ un nuu yu ihya tan jacahnu un tsi yu, tandɨhɨ can cua cuhva yu tsi un ―catyí nu ña vaha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tan nacaha̱n ra Jesús, tan catyí ra: ―Ja̱tsiyo nyaha tsi un nuu yu, cuihna. Tyin nu tutu Nyoo catyí: “Ja̱cahnu tsi intuhun ñi maa Jutu Nyoo. Tan tyiñu intuhun ñi maa ra taahán tsi javaha un.” ");
INSERT INTO mjcNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tacan tan quihi̱n nu ña vaha tsi ra Jesús inga tsaha. Tan cuahán nu tsihin ra nda ñuu Jerusalén. Tan jandaa̱ nu tsi ra iin nu sucun xaan nda jiñi vehe ñuhu cahnu. Tan catyí nu tsihin ra: ―Tatun Sehe Nyoo cuví tsi un, nda̱va nu nyaá un ihya nda cuanda nu ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tyin catyí tsi nu tutu Nyoo tyin: Nyoo cua tava tyiñu ra tsi ángel ra tan jaha cuenda ra naha tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Cua janahndɨ ra naha tsi un. Tan ña cua nañi tsaha un nu yuu. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tacan tan nacaha̱n ra Jesús tan catyí ra: ―Tan juvin ñi catyí tuhun Nyoo: “Ña ndu̱cu cuhva xaan un tsi Nyoo un” ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tan tsa ndɨhɨ̱ nducu cuhva nu ña vaha tsi ra Jesús, tacan tan nacoo̱ nuu nu tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tan tsa yaha̱ tsa nducu̱ cuhva nu ña vaha tsi ra Jesús tan cuanuhu̱ ra nda Galilea tsihin tsa tsitú tunyee iñi Tatyi Ii Nyoo tsi ra. Tan tsitó nyɨvɨ tuhun ra nɨɨ cahnu Galilea can. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tan jacuaha̱ ra tsi nyɨvɨ nu cuví vehe ñuhu tandɨhɨ ñi ñuu. Tan tandɨhɨ ñi jacahnu̱ ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tacan tan tsaa̱ nyico ra Jesús ñuu Nazaret nu tsahnu̱ ra. Tan iin quɨvɨ quitatú nyɨvɨ, quɨhvɨ̱ ra tsitsi vehe ñuhu, tumaa tsa tuhvá maa ra tsicá. Tan nduvita̱ ra cua cahvi ra tuhun Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tan tsaha̱ ra naha iin libru tsa tyaa̱ ra Isaías ra cuvi̱ ndusu yuhu Nyoo. Tan cuhva tsa nuña̱ ra, nañihi̱ ra iin nu catyí tsi: ");
INSERT INTO mjcNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Iyó Tatyi Ii Nyoo tsihin yu, tyin maa Nyoo tava̱ tyiñu tsi yu cahan yu tuhun ra tsihin nyɨvɨ ndaahvi. Tan janduvaha yu tsi nyɨvɨ tsa uhvi añima. Tan maa ra tava̱ tyiñu tsi yu tyin jacoto yu tsi nyɨvɨ yɨhɨ́ ndaha nu ña vaha, tyin tsa cua quita nuña ñi tan maa ra cua jacacu tsi ñi. Tan cua jananyehe yu tsi nyɨvɨ cuaa. Tan cua nacoo nuña yu tsi nyɨvɨ tsa iyó tundoho. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tan jacoto yu tsi nyɨvɨ tyin tsa quita̱ quɨvɨ tsa nyaá Nyoo tumañi iñi tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tacan tan ndɨhɨ̱ cahvi̱ ra tan nacasɨ̱ ra nuu libru can. Tan nacuhva̱ ra tsi iin ra tsa jatyinyeé tsihin tyiñu vehe ñuhu can. Tan tsinyaa̱ ra Jesús. Tacan tan tandɨhɨ nyɨvɨ tsa nyecú ican, ndoo̱ ñi tsa nyehé ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tacan tan catyí ra tsihin ñi: ―Vityin quɨvɨ ihya tsa cundaa̱ cuhva catyí tuhun Nyoo tsa cahvi̱ yu tsiñi̱ ndo ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tan tandɨhɨ nyɨvɨ tsa nyecú can, vaha xaan caha̱n ñi tuhun ra. Tan iyo xaan cuñí ñi tsihin tandɨhɨ tsa vaha tsa caha̱n ra. Tacan tan quitsaha̱ tsicá tuhun tahan ñi: ―¿A ñavin ra ihya cuví sehe ra José? ");
INSERT INTO mjcNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tan nacaha̱n ra Jesús: ―Tsa nditsa tyin tyehen tsicá iñi ndo nyehé ndo tsi yu: “Yooho ra janduvahá tsi nyɨvɨ, ja̱nduvaha jihna tsi maa un.” Tan cuñí tucu ndo catyí ndo: “Tandɨhɨ tsa javaha̱ un ñuu Capernaum tsitó ndi, ja̱vaha ndɨhɨ tucu can ñuu maa un ihya.” ");
INSERT INTO mjcNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tan caha̱n ra Jesús inga tsaha, tan catyí ra: ―Tsa nditsa tyin ndi intuhun ra cuví ndusu yuhu Nyoo, tan ña tsinú iñi nyɨvɨ ñuu ra naha tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tan tsa nditsa tyin cuaha xaan ñi ndaahvi tsa tsihi̱ yɨɨ tsicoo̱ Israel ihya quɨvɨ tsa tava̱ Nyoo tyiñu tsi ra Elías, ra cuvi̱ ndusu yuhu ra, tan ra ican cuvi̱ iin ra Israel ihya tsica̱ ra caha̱n ra tuhun Nyoo. Tan quɨvɨ can ña cuu̱n maa savi uñi cuiya sasava. Tan tsicoo̱ tama cahnu xaan. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tan ñavin tsa cuenda ndi intuhun maa ñi Israel ihya tava̱ Nyoo tyiñu tsi ra Elías cuahán ra. Maa tyin tsaha̱n ra jatyinyee̱ ra tsi iin ñaha ndaahvi tsihi̱ yɨɨ tsa tsicoo̱ ñuu Sarepta tsa canyií Sidón. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","’Tacan tucu quɨvɨ tsica̱ inga ra cuvi̱ ndusu yuhu Nyoo cuenda nyɨvɨ Israel, ra Eliseo. Cuaha xaan ra cuuhví tsihin cuehe tyaahyú tsicoo̱ Israel ihya, tan ndi intuhun ra naha tan ña nduvaha̱ ra naha. Nduvaha̱ intuhun ñi ra Naamán ra quee̱ ñuu Siria ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tsa yaha̱ tsiñi̱ ñi tandɨhɨ tuhun can, tandɨhɨ nyɨvɨ tsa yucú tsitsi vehe ñuhu can xaan xaan cuñí ñi cuvi̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tan nduvita̱ ñi. Tan tava̱ ñi tsi ra Jesús nda jiñi yucu sucun nda yuhu ñuu, tsa cuñi̱ ñi janacava ñi tsi ra ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Maa tyin ra Jesús yaha̱ ra tyañu ñi tan cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tan cuahán ra Jesús ñuu Capernaum tsa canyií Galilea. Tan jacuahá ra tsi nyɨvɨ tsitsi vehe ñuhu tandɨhɨ sauru, quɨvɨ tuhvá nyɨvɨ quitatú. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tan iyo xaan cuñí ñi tsihin tsa caha̱n ra. Tyin ñihi xaan caha̱n ra tumaa tuhvá ra cumí tyiñu caahán. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tan iin quɨvɨ nyií ra Jesús vehe ñuhu tan iin ra yɨhɨ́ tatyi ña vaha catyí ra caná tsaa ra jaha̱ tatyi ña vaha can: ");
INSERT INTO mjcNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Yooho Jesús, ra ñuu Nazaret, ja̱ña tsi ndi. ¿Náa nducú un tyihí un tsi un tsihin ndi? ¿A vatsí un vatsí janaa un tsi ndi? Yuhu nacotó vaha yu tsi un. Yooho cuví Sehe Ii Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tacan tan nduxaa̱n ra Jesús tsi tatyi ña vaha tsa yɨhɨ́ tsi ra can tan catyí ra: ―Ta̱xin ñi coo yooho. Qu̱ita tsi ra ihya ―catyí ra Jesús tsihin nu. Tacan tan nyehé ñi nyɨvɨ nduva̱ ra can nu ñuhu jaha̱ tatyi ña vaha can, tan nduve ca náa javaha̱ nu tsi ra can. Tan quita̱ nu cuahán nu. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tandɨhɨ nyɨvɨ tsa nyehe̱ can, iyo xaan cuñí ñi tan yuuhví ñi cuvi̱. Tan quitsaha̱ tsicá tuhun tahan ñi: ―¿Náa tuhun cuví tsa caahán ra ihya? Tyin nda cuanda tsihin tatyi ña vaha tan ñihi caahán ra, tan quitá tatyi ña vaha ican ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tacan tan tandɨhɨ ñi ityi quita̱ natuhu̱n nyɨvɨ tuhun ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tacan tan quita̱ ra Jesús tsitsi vehe ñuhu can. Tan cuahán ra vehe ra Simón. Tan nu tsaa̱ ra can, canyií ña tyiso ra Simón cuuhví ña tan ñihi xaan yɨhɨ́ cahñi tsi ña. Tacan tan caahán ndaahvi ñi tsihin ra na janduvaha ra tsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tacan tan natuhva̱ ra nu canyií ña tan nacañi̱ nuu ra jiñi ra tan caha̱n ra tsihin cahñi can na quita tsi. Tacan tan quita̱ cahñi can iin yaha ñi, tan nduvita̱ ña can, quitsaha̱ nanducú ña tsa catsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tan tsa tyiso̱ ñicanyii, tandɨhɨ nyɨvɨ tsa iyó ñi cuuhví vehe ñi tsihin sɨɨn sɨɨn nuu cuehe, quitsi̱ ndaca ñi tsi ñi can tsi ra Jesús. Tan tyiso̱ ndaha ra jiñi intuhun intuhun ñi cuuhví can tan janduvaha̱ ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tan cuaha xaan nyɨvɨ quita̱ tatyi ña vaha tan cana̱ tsaa nahnu, tan catyí nahnu: ―Yooho cuví Sehe Nyoo. Maa tyin ra Jesús nduxaa̱n ra tsi nahnu tan ña tsaha̱ ra tsa cahan nahnu, tyin tsitó nahnu tyin juvin ra cuví Cristo. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tsa tuvi inga quɨvɨ, tan quee̱ ra Jesús ñuu can. Tan cuahán ra iin nu taxin caá. Tan nyɨvɨ nanducú ñi tsi ra. Tan tsaa̱ ñi nda nu nyií ra ican. Tan cuñí ñi tsa ña cuhun ca ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tacan tan catyí ra Jesús tsihin ñi: ―Ndi cuñí ca tsi jacoto yu tsi nyɨvɨ tandɨhɨ ca ñuu nácaa tan quɨhvɨ Nyoo añima ñi tan cundaca ñaha ra tsi ñi. Tyin yacan cuenda vatsí yu nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tan tacan ñi tsicá ra Jesús caahán ra tuhun Nyoo vehe ñuhu tandɨhɨ ñi ñuu tsa cayucú Galilea. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iin quɨvɨ nyaá ra Jesús yuhu miñi nu cuví Genesaret. Tan tsaa̱ cuaha xaan nyɨvɨ, tyin cuñí ñi tyaa soho ñi tuhun Nyoo. Tan tɨhɨn xaan nyií ra Jesús tyañu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tan nyehe̱ ra uvi taahan yutun ndoo yatyin ñi yuhu miñi ican. Yoñi yucú tsitsi yutun ndoo can tyin tsa quita̱ ra tɨɨ́n tyaca. Tan nacatyá ra naha traya. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tacan tan quɨhvɨ̱ ra Jesús tsitsi iin yutun ndoo tsa cuví tsii ra Simón. Tan catyí ra Jesús tsihin ra Simón tyin na jacuhun ra can nda mahñu miñi. Tacan tan tsinyaa̱ ra Jesús tsitsi yutun ndoo can. Tan quitsaha̱ caahán ra tsihin nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cuhva tsa ndɨhɨ̱ caha̱n ra tsihin ñi, tan catyí ra tsihin ra Simón: ―Ja̱cuhun yutun ndoo nda nu cunu ca. Tan ja̱cuhun traya tyin tacan tan tɨɨn ndo tyaca. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tan nacaha̱n ra Simón tan catyí ra: ―Maestro, tsa jaha̱ tyiñu xaan ndi ñiñu maa tan ndi intuhun maa tyaca ña ñihi̱ ndi. Maa tyin tatun maa un catyí, cua jacuhun nyico ndi traya. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cuhva tsa jacuhu̱n nyico ra naha traya ra, tan cuaha xaan tyaca ñihi̱ ra naha. Ndɨhɨ maa traya can quitsaha̱ tyaahnyá tsihin tsa vee tyaca can. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tacan tan jandaha̱ ra naha tsi ra tsa yucú inga yutun ndoo tyin quitsi ra naha cutahan ra naha tsihin ra naha. Tacan tan tsaa̱ ra can naha ra. Tan jacutu̱ ra naha nduvi taahan yutun ndoo can tsihin tyaca. Tan cuñi̱ nyee yutun ndoo ra naha tsihin tsa tsitú tyaca. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tsa nyehe̱ ra Simón Pedro tsa cuvi̱ tacan, tan tsicuɨñɨ̱ tsɨtɨ ra nuu ra Jesús, tan catyí ra tsihin ra: ―Ja̱tsiyo tsi un nuu yu, Jutu Mañi yu, tyin yuhu ra iyó cuatyi cuví yu ―catyí ra Simón. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tyin ra Simón tsihin tandɨhɨ ra yucú tsihin ra, nayuhvi̱ xaan ra naha tsa cuenda tsa cuaha xaan tyaca ñihi̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tacan tucu ra cutahán tsihin ra Simón: ra Jacobo tan ra Juan, sehe ra Zebedeo, nayuhvi̱ xaan ra naha. Tan ra Jesús catyí ra tsihin ra Simón: ―Ña na̱yuhvi un, tyin vityin tan nda nu cuahán ca tsi ityi nuu, tumaa tsa tɨɨ̱n ndo tyaca ihya, tacan cua ñihi un nyɨvɨ cua cuvi nyɨvɨ Nyoo, tan cua tava un tsi ñi nu caquiñi, na quɨhvɨ ñi cuenda Nyoo ―catyí ra Jesús tsihin ra Simón. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tacan tan tava̱ ra naha yutun ndoo can nda nu ñuhu ityi. Tan nacoo̱ ra naha tandɨhɨ tsa iyó tsi ra naha. Tan cuahán ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iin quɨvɨ nyií ra Jesús iin ñuu nu iyó iin ra ndohó cuehe tyaahyú. Tan tsa nyehe̱ ra tsi ra Jesús, tan tsicuɨñɨ̱ tsɨtɨ ra nuu ra. Tan nacañi̱ nuu ra jiñi ra nda nu ñuhu. Tan caahán ndaahvi ra tsihin ra Jesús, tan catyí ra: ―Jutu Mañi yu, tun yooho tan cuñí un, cuví janduvaha un tsi yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tacan tan tyiso̱ ndaha ra Jesús jiñi ra cuuhví can, tan catyí ra: ―Cuñí yu janduvaha yu tsi un. Cua nduvaha un vityin ―catyí ra Jesús tsihin ra cuuhví can. Tan iin yaha ñi nduvaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tacan tan catyí ra Jesús tsihin ra: ―Coto catyi tuhun un tsihin nyɨvɨ. Intuhun ñi tsa cua cahan yu tsihin un, cu̱aahan nu nyaá ra cuví jutu. Tan ja̱naha tsi un tsi ra. Tan cu̱hva tsa taahán tsi jamañi un tumaa tsa caahán ley tsa tyaa̱ ra Moisés, tan cua cuvi tsi iin tsandaa tsi ra jutu can tan tsi nyɨvɨ tyin tsa nduvaha̱ un ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Vasu ndi maa tsa ña cuñí ra Jesús tsa coto nyɨvɨ, ñihi ca quitá tuhun ra. Tan cuaha xaan nyɨvɨ ndu iín tyin cuñí ñi tyaa soho ñi tsa caahán ra tan janduvaha ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Maa tyin ra Jesús, jatsiyó, jatsiyó ñi ra tsi ra nu iyó nyɨvɨ. Tan cuahán ra nu taxin caá, cua ndacan tahvi ra tsi Nyoo Jutu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iin quɨvɨ jacuahá ra Jesús tsi nyɨvɨ. Tan yucú juhva ra fariseo, ra tyaá yahvi xaan ley Nyoo tsa tyaa̱ ra Moisés tsanaha. Tan yucú tucu juhva ra maestro cuenda ley vehe ñuhu ican. Quita̱ ra naha ñuu Jerusalén, tan inga ñuu nyihi tanɨɨ cahnu Galilea tan Judea. Tan iyó xaan tunyee iñi Nyoo tsi ra Jesús tsa janduvaha ra tsi nyɨvɨ cuuhví. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tacan tan tsaa̱ ra naha tan nyisó ra naha iin ra cuuhví tsihin cuehe xii nu tsito. Tan cuñí ra naha quɨhvɨ ra naha tsitsi vehe tan caquin ra naha tsi ra cuuhví can nu nyií ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Maa tyin ña ñihi̱ ra naha nu quɨhvɨ ra naha tyin tuvi xaan nyɨvɨ. Tacan tan ndaa̱ ra naha ityi jiñi vehe. Tan jatsiyo̱ ra naha tyiyo. Tacan tan januu̱ ra naha tsi ra cuuhví can nuu nyií ra Jesús tyañu nu tuvi nyɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tan nyehe̱ ra Jesús tyin tsinú xaan iñi ra naha tsi ra. Tan catyí ra tsihin ra cuuhví can: ―Tsa tsicoo̱ tucahnu iñi tsi un, tsa cuenda cuatyi un ―catyí ra Jesús tsihin ra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tacan tan ra maestro cuenda ley vehe ñuhu tsihin ra cuví fariseo, quitsaha̱ tsicá iñi ra naha: “¿Yóo ra cuví ra ihya? Tsicoo̱ cuatyi ra nuu Nyoo tsa cuenda tsa caahán ra. Tyin catyí ra tyin tsa tsicoo̱ tucahnu iñi tsi ra can, tan intuhun ñi maa Nyoo cuví jaha tucahnu iñi tsi yo”, cuñí ra naha tsicá iñi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Maa tyin ra Jesús tsitó ra tsa tsicá iñi ra naha. Tan catyí ra tsihin ra naha: ―¿Nacuenda tsicá iñi ndo tacan? ");
INSERT INTO mjcNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Náa tsa yɨɨ ca catyí yo? ¿A yɨɨ catyi yo: “Cuatyi un tsa yaha̱ ndatsi”, a yɨɨ ca catyi yo tsihin iin nyɨvɨ xii: “Ndu̱vita tan ca̱ca un”? ");
INSERT INTO mjcNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Maa tyin vityin cua janaha yu tsi ndo tyin yuhu Rayɨɨ tsa quee̱ nda gloria iyó ndatu tsi yu tsa jahá yu tucahnu iñi tsi ndo ―catyí ra Jesús. Tsa yaha̱ caha̱n ra tacan, tan catyí ra tsihin ra cuuhví can: ―Ndu̱vita. Na̱quihin tsito un tan cu̱anuhu yuvehe un. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tan nduvita̱ ra can, tan naquihi̱n ra tsito ra. Tan cuanuhu̱ ra yuvehe ra, juvin ñi jacahnú ra tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tandɨhɨ nyɨvɨ iyo xaan cuñí ñi. Tan yuuhví xaan ñi. Tan jacahnú ñi tsi Nyoo, tan catyí ñi: ―Vityin nditsa nyehé yo tsa iyo xaan ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yaha̱ can tan quita̱ ra Jesús vehe can. Tan nanyehe̱ ra tsi iin ra tsa tavá xuhun cuenda ra ndacá ñaha iyó nda ñuu Roma. Tan nañí ra Leví. Tan nyaá ra nu tyahví nyɨvɨ. Tan catyí ra Jesús tsihin ra: ―Co̱hon tsihin yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tacan tan nduvita̱ ra Leví. Tan nacoo̱ ra tandɨhɨ tsa iyó tsi ra. Tan cuahán ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tacan tan javaha̱ ra Leví iin vico cahnu vehe ra cuenda ra Jesús. Tan cuaha xaan ra tavá xuhun cuenda ra ndacá ñaha nyecú ra naha nu mesa. Tan nyecú tucu inga nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tan ra fariseo naha ra tsihin ra cuví maestro cuenda ley vehe ñuhu naha ra, quitsaha̱ caahán nyaa ra naha tsi ra tsicá tsihin ra Jesús: ―¿Nacuvi tsatsí ndo tan tsihí ndo tsihin ra tavá xuhun naha ra tan tsihin ra iyó cuatyi naha ra? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tan ra Jesús nacaha̱n ra, tan catyí ra: ―Ña tsiñí ñuhu doctor tsi ra tsa vaha maa. Ra cuuhví, cuví ra tsiñí ñuhu doctor. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yuhu ña vatsí yu jatyinyee yu tsi nyɨvɨ tsa tsicá iñi tyin vaha ñi, vatsí yu jatyinyee yu tsi nyɨvɨ tsitó tyin iyó cuatyi ñi, tan cuví nasama ñi cuhva iyó ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tacan tan tsica̱ tuhun ra naha tsi ra Jesús, tan catyí ra naha: ―Ra tsicá tsihin ra Juan tsicoó nyitya ra naha, tan ña tsatsí ra naha tan nanducú ra naha tsi Nyoo, tan tacan tucu ra cuví fariseo naha ra. Maa tyin ra tsicá tsihin yooho, ndɨhɨ quɨvɨ tsatsí ra naha tan tsihí ra naha. ¿Nacuvi? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tan nacaha̱n ra Jesús, tan catyí ra: ―¿A cuví coonyitya nyɨvɨ yucú vico tindaha jaha ndo tatun nyií ra tsa cua tindaha tsihin ñi? Ña cuvi. Tyin sɨɨ cuñí ñi, tan cuñí ñi catsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Maa tyin cua quita quɨvɨ tsa cua jatsiyo ra tindaha ican tsi ra nu yucú ñi. Tacan tan cua coonyitya ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tacan tan caha̱n tucu ra Jesús iin cuhva tsihin nyɨvɨ, tan catyí ra: ―Yoñi tsaahnyá iin jahma tsaa, tan naquicú ñi tsihin jahma tuuhu. Tyin tatun javaha ñi tacan, nandɨyɨ jahma tsaa can. Tan ña ndoo vaha tsi tsihin jahma tuuhu can. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tan tacan tucu, ña cuví tyihi nyɨvɨ vinu tsaa tsitsi ñɨɨ tsaahnu. Tyin cua tyahnya ñɨɨ can tsihin vinu tsaa can. Tan cua tɨvɨ vinu can tan tɨvɨ ndɨhɨ tucu ñɨɨ tsaahnu can. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yacan cuenda taahán tsi tyihi yo vinu tsaa tsitsi ñɨɨ tsaa. Tyin tacan tan nduvi taahan tsi tan cua jaha cuenda tahan tsi itsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tan yoñi tsihí vinu tsahnu, tan cuñí ñi coho ñi vinu tsaa. Tyin catyí ñi, vaha ca vinu tsahnu. Vinu tsahnu can cuñí tsi catyí tyin cuví tsi cuhva iyó maa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iin quɨvɨ quitatú nyɨvɨ, yaha̱ ra Jesús mahñu tsa tatsi̱ nyɨvɨ. Tan ra tsicá tsihin ra tuhún ra naha yoco trigu. Tan joco̱n ra naha can tsihin ndaha ra naha. Tan tsatsi̱ ra naha tsɨtɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tacan tan catyí ra fariseo naha ra tsihin ra naha: ―¿Nacuenda javahá ndo iin tyiñu tsa ña taahán tsi javaha yo quɨvɨ quitatú yo? ");
INSERT INTO mjcNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tan nacaha̱n ra Jesús, tan catyí ra: ―¿A ñaha ca cahvi ndo nu tsahá cuenda tsi tsa javaha̱ ra David tan ra cutahán tsihin ra quɨvɨ tsa tsisoco̱ ra naha? ");
INSERT INTO mjcNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Quɨhvɨ̱ ra tsitsi vehe Nyoo. Tan quihi̱n ra paan tsa tyiso̱ nyɨvɨ nuu altar Nyoo. Tan tsatsi̱ ra. Tan tsaha̱ ndɨhɨ ra tsi ra tsa cutahán tsihin ra. Tan maa ñi maa ra cuví jutu naha ra taahán tsi catsi paan can ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tacan tan catyí ra Jesús: ―Rayɨɨ tsa quee̱ nda gloria iyó ndatu tsi ra tsa cahan ra tsihin intuhun intuhun ndo náa taahán tsi javaha ndo quɨvɨ quitatú yo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Inga quɨvɨ quitatú nyɨvɨ quɨhvɨ̱ ra Jesús tsitsi vehe ñuhu. Tan quitsaha̱ jacuahá ra tsi nyɨvɨ. Tan nyehe̱ ra tsi iin ra tsa na ityi̱ ndaha cuaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tan ra cuví maestro cuenda ley vehe ñuhu naha ra tsihin ra cuví fariseo naha ra, nducú cuhva ra naha tsi ra Jesús, tatun janduvaha ra tsi ra cuuhví ican quɨvɨ quitatú nyɨvɨ, tyin tacan tan cuvi tyaa ra naha cuatyi tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Maa tyin ra Jesús tsitó ra tsa tsicá iñi ra naha. Tan catyí ra tsihin ra na ityi̱ ndaha can: ―Ndu̱vita. Cu̱nyaa nyityi mahñu ra naha ihya. Tacan tan ra na ityi̱ ndaha can nduvita̱ ra. Tan tsinyaa̱ nyityi ra mahñu ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tacan tan catyí ra Jesús tsihin ra nyecú ican naha ra: ―Cua nducu tuhun yu iin cuhva tsi ndo. ¿Náa taahán tsi javaha yo quɨvɨ quitatú yo? ¿A taahán tsi javaha yo tsa vaha, a tsa ña vaha? ¿A taahán tsi jacacu yo tsi nyɨvɨ, o cahñi ndɨhɨ yo tsi ñi? ");
INSERT INTO mjcNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tacan tan ra Jesús nyehé ra intuhun intuhun ra naha. Yaha̱ can tan catyí ra tsihin ra tsa na ityi̱ ndaha can: ―Ca̱ñihi ndaha un. Tacan tan ra na ityi̱ ndaha ican cañihi̱ ra ndaha ra. Tan nduvaha̱ ndaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Maa tyin ra yucú ican naha ra, cuxaa̱n ra naha. Tan quitsaha̱ tsicá tuhun tahan ra naha tsi ra naha: ―¿Nacaa javaha yo tan cuvi casɨ yo nu caahán ra Jesús ihya? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Quɨvɨ ican ndaa̱ ra Jesús iin yucu. Tan ñiñu maa tsica̱n tahvi ra tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tan tsa tuvi, cana̱ ra tsi tandɨhɨ ra nyicún tsi ra. Tan nacatsi̱ ra utsi uvi taahan ra naha. Tan jacunañi̱ ra tsi ra naha apóstol, tan cuñí tsi catyi tsi “ra tsa tava̱ tyiñu Nyoo”. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tan ihya nyaá sɨvɨ tandɨhɨ tsa utsi uvi ra naha: ra Simón, ra tsa jacunañi̱ ra Cristo “Pedro”; tan yañi ra, ra Andrés; tan ra Jacobo; ra Juan; ra Felipe; ra Bartolomé; ");
INSERT INTO mjcNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ra Mateo; ra Tomás; ra Jacobo, sehe ra Alfeo; tan ra Simón ra nyanaá cuví ra cuenda partido tsa cuñí cuhun cuatyi sɨquɨ ñuu Roma tsa ndacá ñaha tsi ñi; ");
INSERT INTO mjcNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","tan ra Judas, yañi ra Jacobo; tan ra Judas Iscariote, ra tsa xico̱ tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tacan tan nuu̱ ra Jesús yucu ican tsihin tsa utsi uvi ra naha. Tan ndu ii̱n nyɨvɨ tsa nyicún tsi ra tsaha yucu can. Tan tsaa̱ cuaha tucu nyɨvɨ quee̱ ñuu Jerusalén tsihin tandɨhɨ ca ñuu cayucú Judea, tsihin tucu nyɨvɨ quee̱ ityi yuhu ndutya ñuhu tsa cayucú yatyin ñi ñuu Tiro tsihin ñuu Sidón. Tan tsaa̱ ñi tyin tyaa soho ñi tuhun caahán ra Jesús. Tan tandɨhɨ nyɨvɨ cuuhví cuñí ñi tsa janduvaha ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tan tandɨhɨ nyɨvɨ tsa yɨhɨ́ tatyi ña vaha janduvaha̱ ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tan tandɨhɨ ñi cuñí ñi tɨɨn ñi tsi ra, tyin janduvaha ra tsi ñi tsihin tunyee iñi tsa iyó tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tacan tan nanyehe̱ ra Jesús tsi ra tsicá tsihin ra. Tan catyí ra tsihin ra naha: ―Tandɨhɨ nyooho tsa ndaahvi, sɨɨ xaan cua cuñi ndo, tyin taahán tsi cundaca ñaha Nyoo tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Tandɨhɨ nyooho tsa tsisocó vityin, sɨɨ xaan cua cuñi ndo. Tyin coo quɨvɨ ña cua cusoco ca maa ndo. Tan tandɨhɨ nyooho tsa tsacú tsa cuiihya cuñí ndo, sɨɨ xaan cua cuñi ndo tyin ña cua coo ca ndo tucuiihya iñi. Tan cua vacu naaha xaan ndo tsihin tsa sɨɨ cuñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Cu̱sɨɨ iñi ndo, quɨvɨ ndasɨ cuñi nyɨvɨ nyehe ñi tsi ndo, quɨvɨ tava ñi tsi ndo nu iyó ñi, quɨvɨ nduxaan ñi tsi ndo, quɨvɨ catyi ñi tyin nyɨvɨ ña vaha cuví ndo tyin tsinú iñi ndo tsi maa yu tsa cuví yu Rayɨɨ quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sɨɨ cu̱ñi ndo quɨvɨ can tyin tacan tucu javaha̱ nyɨvɨ ñi taha̱n tsanaha. Cuxaa̱n ñi tsi ra cuvi̱ ndusu yuhu Nyoo. Nda̱va ndo tsihin tsa sɨɨ cuñí ndo. Tyin cahnu xaan ndatu cua ñihi ndo nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Maa tyin ndahvi nyooho, ñi cuca. Tyin vityin sɨɨ xaan cuñí ndo tsihin tandɨhɨ tsa cuca ndo. Maa tyin cua coo quɨvɨ maa ñi maa tundoho cua nyehe ndo. Tyin nduve tsa cua ñihi ndo nu nyaá Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Tan ndahvi nyooho tsa cuñí maa ndo tyin nduve tsa cumañi tsi ndo tsa vityin, tyin coo quɨvɨ cua cusoco ndo. Nyooho tsa sɨɨ cuñí vityin, ndahvi nyooho, tyin coo quɨvɨ cua coo ndo tucuiihya iñi. Tan cua vacu xaan ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tan ndahvi nyooho tsa vaha caahán nyɨvɨ tuhun ndo. Tyin tacan caa tucu nyɨvɨ tsicoo̱ tsanaha, vaha xaan caha̱n ñi tuhun ra tsa caha̱n tsa ña nditsa tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Tandɨhɨ nyooho tsa tsiñí tsa caahán yu, catyí yu tsihin ndo tyin: Cu̱ñi ndo tsi nyɨvɨ xaan iñi tsi ndo. Ja̱vaha ndo tsa vaha tsihin nyɨvɨ tsa ndasɨ cuñí nyehe tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ca̱han ndo tsa vaha tsihin nyɨvɨ tsa caahán ndavaha ñi tsi ndo. Tan nda̱can tahvi ndo tsi Nyoo tsa cuenda nyɨvɨ caahán nyaa tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tatun iin ra cañí iin tsiyo nuu ndo, cu̱hva ndɨhɨ ndo inga tsiyo, nacañi ndɨhɨ maa ra. Tatun iin ra quinyaá tsaqueta nditsí ndo, cu̱hva ndɨhɨ ndo camiseta ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Cu̱hva ndo náa ndɨhɨ tsicán nyɨvɨ tsi ndo. Tatun quinyaá ñi náa tsa iyó tsi ndo, ña ndacan ca ndo can tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tumaa cuñí ndo tsa javaha nyɨvɨ tsa vaha tsihin ndo, tacan ja̱vaha tucu maa ndo tsa vaha tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tatun cuñí ndo tsi maa ñi maa nyɨvɨ tsa cuñí tsi ndo, nduve tsa vaha javahá ndo. Tyin tacan icá tucu nyɨvɨ quiñi iyó. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tan tatun tsihin nyɨvɨ tsa vaha icá tsihin ndo, tan icá ndo tsa vaha, tan ña icá ndo tsa vaha tsihin inga nyɨvɨ, nduve tsa vaha icá ndo cuví can, tyin nyɨvɨ caquiñi, tacan icá tucu ñi can. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tatun javahá ndo tumañi iñi tsi iin nyɨvɨ, tan nyitá iñi ndo tyin cua javaha tucu ñi can tumañi iñi tsi ndo, nduve tsa vaha icá ndo. Tyin nyɨvɨ caquiñi, tacan icá ñi. Tatun náa tumañi iñi javahá ñi tsi nyɨvɨ vaha iñi tsi ñi, ndatú ñi tsa nacuhva tucu ñi can tumañi iñi tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Maa tyin nyooho, cu̱ñi ndo tsi nyɨvɨ xaan iñi tsi ndo. Tan ja̱vaha ndo tsa vaha tsihin ñi. Tan cu̱hva nuu ndo náa nducú ñi. Maa tyin ña cuatu ndo náa tumañi iñi cua nacuhva ñi tsi ndo. Tacan tan cahnu xaan tsa cua ñihi ndo nuu Nyoo tan cua cuvi ndo sehe maa Nyoo, ra nyaá gloria. Tyin Nyoo vaha iñi ra nda cuanda tsihin nyɨvɨ tsa ña nacuhvá tyahvi nyoo tsi ra, tan tsihin nyɨvɨ caquiñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cu̱ uhvi iñi ndo tsi nyɨvɨ, tumaa uhvi cuñí Nyoo Jutu yo nyehé ra tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ña ca̱han nyaa ndo tsi nyɨvɨ, tacan tan Nyoo ña cua cahan nyaa ra tsi maa ndo. Ña catyi ndo tsa cuhun ñi anyaya, tacan tan ña cua jacuhun Nyoo tsi ndo anyaya. Ja̱ha ndo tucahnu iñi tsi nyɨvɨ. Tan Nyoo cua jaha ra tucahnu iñi tsi maa ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cu̱hva ndo tsa tsiñí ñuhu tsi nyɨvɨ. Tacan tan cua cuhva tucu maa Nyoo tsa tsiñí ñuhu tsi maa ndo. Cuaha cua cuhva ra tsi ndo. Tyin tumaa cuhva cua cuhva ndo tsi nyɨvɨ, tacan cuhva cua cuhva Nyoo tsi ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tan tsaha̱ ra Jesús cuhva ihya tsi ñi, tan catyí ra: ―Iin ra cuaa ña cuví janaha ra ityi tsi inga ra cuaa. Tyin nduvi taahan ra naha ña nyehé ra naha ityi cuahán ra naha. Tan cuví canacava ra naha tsitsi iin xahva. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ndi intuhun ra cutuhvá ña cua cuvi coto ra tsa tsitó ra jacuahá tsi ra. Tyin ndi quitsaha̱ cahví ra. Cua coto ra nda ndɨhɨ cahvi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Nacaa tyin nyehé un tsahan luhlu tsa nyií tinuu yañi un, tan ña jahá un cuenda yutun cahnu tsa nyií tinuu maa un? ");
INSERT INTO mjcNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tatun tinuu maa un nyií iin yutun cahnu, ¿nácaa cua cuvi catyi un tsihin ra yañi un: “Na̱ha, na tava yu tsahan luhlu tsa nyií tinuu un.”? ¡Yooho tsa jahá tyin vaha xaan un! Ta̱va jihna yutun cahnu tsa nyií tinuu maa un. Tyin tacan tan cuvi nyehe vaha un tsahan luhlu tsa cua tava un tinuu yañi un. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Iin yutun vaha tsahá tun yucu vixi, yucu vaha. Tan iin yutun ña vaha tsahá tun yucu ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tandɨhɨ yutun nacotó yo tsi tun tsihin tsɨtɨ tun. Tyin tiñata, ña cua cuhva tun mangu. Tan ndi intuhun iñu nduuhva ña cua cuhva tun uvas tsa cuví yucu vixi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tan tacan tandɨhɨ nyɨvɨ vaha, vaha caahán ñi, tyin yɨhɨ́ tsa vaha añima ñi. Maa tyin nyɨvɨ ña vaha, maa ñi maa tsa ña vaha caahán ñi tyin yɨhɨ́ tsa caquiñi añima ñi. Tyin tsihin yuhu yo caahán yo tandɨhɨ tsa quitá tsitsi añima yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Nacuenda catyí ndo tsihin yu, “Jutu Mañi yu, Jutu Mañi yu”, tan ña javahá ndo tsa caahán yu? ");
INSERT INTO mjcNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Vityin cua catyi yu tsihin ndo yóo ndacú nyooho tsa vatsí ndo tsi maa yu, tan tyaá soho ndo tsa caahán yu, tan javahá ndo cuhva catyí yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Cuví ndo tumaa cuví iin ra tsitó janduvita vehe. Tyin jihna ca tahvi̱ cunu xaan ra tan taha̱n ra yuu. Tan tyaa̱ ra tyihyo tsaha vehe can tsata yuu can. Tan quɨvɨ nduñihi̱ cuún savi, ndutya can tsatya̱ xaan tsi tsaha vehe, maa tyin vehe can ña tanɨ̱ maa tsi tyin vaha xaan quita̱ tyihyo tsaha tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Maa tyin nyɨvɨ tsa tsiñí tsa caahán yu tan ña javahá ñi tsa caahán yu, cuví ñi tumaa iin ra javaha̱ vehe tan ña vaha javaha̱ ra itsi. Tyin nduve tyihyo tsaha tsi javaha̱ ra. Tan quɨvɨ tsaa̱ savi, tan cuñihi̱ cuún savi, tan yaha̱ ndutya cuaha tsaha vehe can. Tan vehe can, iin yaha ñi tanɨ̱ tsi ―tacan catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ndɨhɨ̱ caha̱n ra Jesús tsihin nyɨvɨ, tacan tan cuanuhu̱ ra inga tsaha nda ñuu Capernaum. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tan ñuu can iyó iin ra capitán. Tan iyó iin musu ra tsa cuñí xaan ra. Tan cuuhví ra can. Tan tsa cuñí cúu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tan tsa tsitó ra capitán can tuhun ra Jesús, tacan tan tava̱ tyiñu ra tsi juhva ra cuví ra tsahnu ñuu Israel naha ra na cahan ra naha tsihin ra Jesús, tyin na quitsi ra janduvaha ra tsi musu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Tacan tan tsaa̱ ra tsahnu ican naha ra nu nyií ra Jesús. Tan quitsaha̱ caahán ndaahvi ra naha tsihin ra tan catyí ra naha: ―Iyó iin ra capitán cuenda ñuu Roma. Tan vaha xaan nyɨvɨ cuví ra tsihin yo tsa cuví yo nyɨvɨ Israel. Nda cuanda javaha̱ ña ra iin vehe ñuhu yo. Tan taahán tsi tyin jatyinyee un tsi ra. Tyin cuuhví xaan musu ra. Tan cuñí ra tyin janduvaha un tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tacan tan cuahán ra Jesús tsihin ra naha. Maa tyin tsa ndi cumañi ca tsaa ra nda vehe ra capitán can, tan ra capitán can tava̱ tyiñu ra tsi ra vaha iñi tsi ra. Tacan tan tsaa̱ ra naha nu nyií ra Jesús. Tan catyí ra naha tsihin ra Jesús: ―Taa, catyí ra capitán tyin ña jatyañu un tsi un tsa cuhun un nda yuvehe ra. Tyin ña cahnu cuví ra tan cuhun un vehe ra, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yacan ña cana iñi ra quitsi ra nu nyií un. ¿A ña jaha un tumañi iñi tsi ra, tyin ihya cahan un iin tuhun, tan cua nduvaha musu ra, catyí ra? ");
INSERT INTO mjcNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tyin maa ra, capitán cuví ra. Tan ndacá ñaha rey tsi ra. Tan maa ra ndacá ñaha ra tsi ra cuatyi cutahán tsihin ra. Tatun tavá tyiñu ra tsi iin ra cuatyi ican, na cuhun ra, cuahán ra. Tatun catyí ra tsihin inga ra, na quitsi ra, vatsí ra. Tatun jacuhún ra tsi inga ra, na jaha tyiñu ra, cua jaha tyiñu ra. Tan tacan tucu yooho, tatun catyí un na nduvaha musu ra, tacan tan cua nduvaha ra ―catyí ra vaha iñi tsi ra capitán can naha ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tsa tsiñi̱ ra Jesús tsa caha̱n ra can naha ra, tan iyo xaan cuñí ra. Tan nanyehe̱ ra tsi nyɨvɨ tsa nyecú tsihin ra, tan catyí ra: ―Nditsa nditsa tyin tsinú xaan iñi ra capitán can. Ñaha ca nañihi yu tsi ndi intuhun ra Israel tsa tsinú xaan iñi tumaa ra ican ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tacan tan cuanuhu̱ ra vaha iñi tsi ra capitán can naha ra. Tan tsa tsaa̱ ra naha nda yuvehe, tan nyehe̱ ra naha tyin tsa nduvaha̱ musu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tsa yaha̱ yacan tan cuahán ra Jesús iin ñuu tsa nañí Naín. Tan cuahán tucu ra tsicá tsihin ra. Tan cuahán ndɨhɨ tucu cuaha xaan nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tacan tan cuhva tsa cua tsaa ra yatyin ñuu ican, nyehe̱ ra tyin cuaha xaan nyɨvɨ quitá ñi ñuu ican. Tan nyisó ra naha iin ndɨyɨ, cua cutsi ra naha sehe iin ñaha ndaahvi tsa tsihi̱ yɨɨ. Tan intuhun ñi maa ra cuví sehe ña, tan tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tan tsa nyehe̱ ra Jesús tsi ña, tan cundaahvi̱ iñi ra nyehe̱ ra tsi ña. Tan catyí ra tsihin ña: ―Ña vacu un. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tsahan natuhva̱ ra tan tɨɨ̱n ra tsatun tsa nyií ndɨyɨ can. Tacan tan ra nyisó tsi ndɨyɨ can naha ra tsicuɨñɨ̱ ra naha. Tan catyí ra Jesús tsihin ndɨyɨ can: ―Ndu̱vita, yooho ra tyuvaa ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tacan tan nduvita̱ ndɨyɨ can. Tan nacunyaa̱ ra. Tacan tan quitsaha̱ caahán ra. Tan ra Jesús nacuhva̱ cuenda ra tsi ra tsi sɨhɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tsa nyehe̱ ñi tsa tacan nandoto̱ ra jaha̱ ra Jesús tan yuuhví xaan ñi, tan quitsaha̱ jacahnú ñi tsi Nyoo. Tan catyí ñi: ―Cahnu xaan ra cuví ndusu yuhu Nyoo tsaa̱ nu yucú yo ihya. Tan catyí tucu ñi: ―Maa Nyoo cuví ra vatsí nu iyó yo, vatsí jatyinyee ra tsi yo ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tan tandɨhɨ maa nyɨvɨ tanɨɨ cahnu Judea, tsito̱ ñi tsa javaha̱ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tan ra tsicá tsihin ra Juan naha ra nacatyi̱ tuhun ra naha tsa javaha̱ ra Jesús. Tacan tan cana̱ ra Juan tsi uvi taahan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tan tava̱ tyiñu ra tsi ra naha na cuhun ra naha nu nyií ra Jesús, tan ndaca tuhun ra naha tsi ra tatun juvin ra cuví Cristo, ra tsa cua jaquitsi Nyoo. Tyin tatun ñavin ra Cristo cuví ra, cuatu ra naha tsi inga ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tacan tan ra tsa jacuhu̱n ra Juan, cuahán ra naha. Tan tsaa̱ ra naha nu nyií ra Jesús. Tan catyí ra naha: ―Ra Juan, ra jacoondutyá, tava̱ tyiñu ra tsi ndi tyin ndaca tuhun ndi tsi un tatun juvin un cuví Cristo, ra tsa cua jaquitsi Nyoo. Tyin tatun ñavin un, cuatu ndi tsi inga ra ―catyí ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tan tsa ndi yucú ra tsa jacuhu̱n ra Juan naha ra tan cuaha xaan nyɨvɨ cuuhví janduvaha̱ ra Jesús. Tan tacan tucu nyɨvɨ yɨhɨ́ tatyi ña vaha. Tan cuaha tucu nyɨvɨ cuaa nanyehe̱ ñi jaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tacan tan catyí ra Jesús tsihin ra tsa jacuhu̱n ra Juan naha ra: ―Cu̱aahan ndo. Tan na̱catyi tuhun ndo tsihin ra Juan tandɨhɨ tsa nyehe̱ ndo, tan tandɨhɨ tsa tsiñi̱ ndo. Tan ca̱tyi ndo tsihin ra: ra cuaa nanyehe̱ ra, ra coxo nacaca̱ ra, ra ndoho̱ cuehe tyaahyú nduvaha̱ ra, ra soho nacuñi̱ ra, ndɨyɨ nandoto̱, tan caahán yu tuhun Nyoo tsihin ñi ndaahvi nácaa cacu ñi. Tan ca̱tyi ndo tsihin ra tyin ");
INSERT INTO mjcNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","sɨɨ xaan cuñí ñi nyicún tsi yu tun ña ndu uví iñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cuahán ra tsa jacuhu̱n ra Juan naha ra, tan quitsaha̱ caahán ra Jesús tuhun ra Juan tsihin nyɨvɨ. Tan catyí ra: ―¿Náa nyehe̱ ndo quɨvɨ tsaha̱n ndo nuu tsɨquɨ ndɨɨ ican? ¿A nyehe̱ ndo iin ndoo tsa janduva̱ tatyi? ");
INSERT INTO mjcNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿A iin ra tsa nditsí jahma vaha nyehe̱ ndo? Ñavin. Tyin tsitó ndo tyin ra nditsí jahma vaha, iyó ra tsihin tsa vaha tan iyó ra vehe ra cuví rey. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿A ña nyehe̱ ndo tsi iin ra cuví ndusu yuhu Nyoo? Juvin. Cahnu ca cuví ra tan ñavin ca ra ndusu yuhu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juvin ñi tuhun ra Juan cuví tsa nyaá nuu tutu tsa tyaa̱ ra Isaías taha̱n tsanaha. Tan caahán Nyoo tuhun ra tyehen: Yuhu cua jacuhun yu iin ra cua cahan tuhun yu tsa ndi cumañi ca cuhun un. Na natyiso vaha ra ityi nu cua cuhun un. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Tan catyí yu tsihin ndo tyin tsitsi tsa tandɨhɨ ra tsa cacu̱ jaha̱ ñiñaha, yoñi ra cuví ndusu yuhu Nyoo tsa cahnu ca tumaa ra Juan, ra jacoondutyá. Maa tyin ra tsa ndacá ñaha Nyoo añima vasu iin ra luhlu cuii ñi cuví ra, maa tyin cahnu xaan ca cuví ra tan ñavin ca ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Tandɨhɨ nyɨvɨ tan ra tavá xuhun naha ra, tsa tsicoondutya̱ jaha̱ ra Juan, nacoto̱ ñi tyin cuhva javahá Nyoo, cuɨtɨ xaan tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Maa tyin tandɨhɨ ra fariseo tsihin ra maestro cuenda ley vehe ñuhu, ña cuñí ra naha tsa jacoondutya ra Juan tsi ra naha, tyin ña cuñí ra naha quihin ra naha tsa tsahá Nyoo tsi ra naha ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tan catyí tucu ra: ―¿Náa cua jandu inducu yu tsihin nyooho, nyɨvɨ iyó quɨvɨ ihya? ¿Yóo caá tumaa caá ndo? ");
INSERT INTO mjcNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tumaa ra nyihi cuví nyooho. Tyin ra nyihi jasɨquɨ́ nuyahvi. Tan caná tsaa tahan ra naha, tan catyí ra naha: “Tɨvɨ̱ ndi tiyoo tan ña tsañi̱ ndo yaa. Tan tsita̱ ndi yaa cuiihya, tan ña tsacu̱ ndo”. catyí ra nyihi. Tan tacan ñi cuví nyooho tyin ndi intuhun cuhva ña taahán iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tyin ra Juan, ra jacoondutyá, quitsi̱ ra tan ña tsatsí vaha ra. Tan ña tsihi̱ ra vinu. Tan nyooho catyí ndo tyin tatyi ña vaha yɨhɨ́ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tan quitsi̱ tucu yuhu tan cuví yu Rayɨɨ tsa quee̱ nda gloria. Tan tsatsí yu tan tsihí yu. Tan nyooho catyí ndo tyin tsatsí xaan yu tan tsihí xaan yu vinu. Tan ña taahán iñi ndo tsa cutahán yu tsihin ra iyó cuatyi naha ra, tan tsihin ra tavá xuhun naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Maa tyin catyí yu tsihin ndo tyin tsa tsiñi tuñi Nyoo tsahá ra tsi nyɨvɨ naquihín tuhun caahán yu tan tuhun caahán ra Juan. Tan maa ñi cua janaha tsi ndo tyin vaha tsa tsiñi tuñi Nyoo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Iin ra fariseo tsa nañí Simón jacoto̱ ra tsi ra Jesús tyin cuhun ra cucatsi ra nda yuvehe ra. Tan tsaa̱ ra Jesús vehe ra, tan tsicunyaa̱ ra nu mesa. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tacan tan iin ñaha sɨɨ iñi ñuu ican tsito̱ ña tyin nyií ra Jesús ican. Tan tsaa̱ ña tsihin iin yutyi yuu xiñu tsitú tsi ndutya tami. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tan tsinyaa̱ ña yatyin ñi tsaha ra. Tan quitsaha̱ tsacú ña tyin ndu uví iñi ña cuatyi ña. Tan cuún ndutya nuu ña. Tan tsihin ndutya nuu ña nacatyá ña tsaha ra Jesús. Yaha̱ can tan jana ityi̱ ña tsaha ra tsihin ixi jiñi ña. Tan tyayuhu̱ ña tsaha ra. Tacan tan tyoso̱ ña ndutya tami ican tsata tsaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tsa nyehe̱ ra fariseo can tsa tacan ica̱ ña, tan tsicá iñi ra: “Tatun nditsa tsa Nyoo jaquitsi̱ tsi ra ihya, cua nacoto ra yóo ñaha tɨɨ́n tsaha ra, tyin ñaha ican, ñaha iyó cuatyi cuví ña.” ");
INSERT INTO mjcNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tacan tan ra Jesús catyí ra tsihin ra fariseo ican: ―Yooho Simón, iyó iin tsa cua cahan yu tsihin un ―catyí ra tsihin ra. Tacan tan nacaha̱n ra Simón, tan catyí ra: ―Vaha, ca̱han tsihin yu, Maestro ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tan catyí ra Jesús tyehen tsihin ra: ―Uvi taahan rayɨɨ nyaá cuenda ra xuhun tsi iin ra tsa tuhvá tsahá nuu xuhun. Tan iin ra ican nyaá cuenda ra uhun cientu denario. Tan inga ra nyaá cuenda ra uvi xico utsi ñi denario. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tan nduvi taahan ra, ña cuví tyahvi ra naha. Tan ra tuhvá tsahá nuu xuhun ican, jaha̱ ra tucahnu iñi tsi nduvi taahan ra naha. Tan vityin ca̱tyi tsihin yu, yooho Simón, ¿ndáa ra cua cuñi ca tsi ra tsa tsahá nuu xuhun ican? ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tacan tan nacaha̱n ra Simón, tan catyí ra: ―Ra tsa cuaha ca jahá ra tucahnu iñi tsi ―catyí ra. Tacan tan catyí ra Jesús: ―Nditsa tsa caahán un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tacan tan nanyehe̱ ra Jesús tsi ñaha ican, tan catyí ra tsihin ra Simón: ―¿A nyehé un tsi ñaha ihya? Yuhu quɨhvɨ̱ yu tsitsi vehe un, tan ña tsaha̱ un ndutya tsa ndoo tsaha yu tumaa cuhva tsa iyó yo. Tan ñaha ihya nacatya̱ ña tsaha yu tsihin ndutya nuu ña. Tan jana ityi̱ ña tsihin ixi jiñi ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yooho ña tyayuhu̱ un ndaha yu, tumaa cuhva tsa iyó yo, maa tyin maa ña nda cuanda tsa quɨhvɨ̱ yu ihya tan ña jandɨhɨ́ ña tsa tyayuhú ña tsaha yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tan yooho ña tyihi̱ un acetye jiñi yu, maa tyin ñaha ihya tyihi̱ ña ndutya tami tsaha yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tan catyí yu tsihin un, yooho Simón, vasu cahnu xaan cuatyi ña, maa tyin jahá yu tucahnu iñi tsi ña. Yacan cuenda cuñí xaan ña tsi yu. Tan nyɨvɨ tsa jahá yu tucahnu iñi luxu ñi cuatyi ñi, luxu ñi cuñí ñi tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tacan tan catyí ra Jesús tsihin ña can: ―Cuatyi un tsa yaha̱ catsiyo̱, tyin tsa jaha̱ Nyoo tucahnu iñi tsi un ―catyí ra Jesús tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tacan tan ra yucú tsihin ra quitsaha̱ tsicá iñi ra naha: “¿Yóo ra cuví ra ihya? tyin jahá ra tucahnu iñi cuatyi nyɨvɨ.” ");
INSERT INTO mjcNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tacan tan catyí ra Jesús tsihin ñaha ican: ―Cu̱aahan vityin, tsa cacu̱ un tyin tsinu̱ iñi un tsi yu. Cu̱aahan tsihin tsa vaha ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsa yaha̱ can, tan cuahán ra Jesús tsicá ra iin iin ñuu nahnu tan iin iin ñuu nyihi. Tan caahán ra tsihin nyɨvɨ. Tan jacotó ra tsi ñi tuhun vaha nácaa cuñí Nyoo cundaca ñaha ra tsi ñi. Tan tsa utsi uvi taahan ra tsa tava̱ tyiñu ra, cuahán ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tan cuahán tucu juhva ñiñaha tsa janduvaha̱ ra: ñi cuhvi̱ tan ñi yɨhɨ̱ tatyi ña vaha. Tan tsihin ñi cuahán ña María tsa quee̱ ñuu Magdala, tan juvin ña cuví ña yɨhɨ̱ utsa tatyi ña vaha tan nduvaha̱ ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tan cuahán tucu ña Juana, ñasɨɨhɨ ra Chuza, ra cumí tyiñu cuenda ra Herodes, tan ña Susana tsihin tandɨhɨ ca ñiñaha tsa jatyinyeé tsi ra Jesús tsihin tsa iyó tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tan cuaha xaan nyɨvɨ quee̱ ñi iin iin ñuu, tyin cua nyehe ñi nu caahán ra Jesús tuhun Nyoo. Tan tuvi xaan ñi nyecú, tan quitsaha̱ caahán ra tsihin ñi tsihin iin cuhva tsaha̱ cuenda ra, tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Quita̱ iin ra vehe ra. Cuahán ra nu iyó tyiñu jahá ra, tyin cua tatsi ra tsɨtɨ trigu nu ñuhu ra. Tan cuhva tsa tatsí ra quɨtɨ́ ra tsɨtɨ can, tan cucoyo̱ juhva yuhu ityi. Tan tsañi̱ nyɨvɨ tsata can. Tan quitsi̱ saa tan tsatsi̱ tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tan juhva ca tsɨtɨ can cucoyo̱ tyañu yuu. Cana̱ tsɨtɨ ican. Maa tyin na ityi̱ tsi tyin luxu cuii ñi ñuhu yɨhɨ́ tsaha tsi. Tan nduve catsin. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tan juhva ca tsɨtɨ cucoyo̱ tyañu iñu. Maa tyin quɨvɨ cana̱ trigu iin caa ñi tsihin iñu can, iñu can tsahñi̱ tsi trigu can. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Maa tyin juhva ca tsɨtɨ cucoyo̱ nu ñuhu vaha. Tan quɨvɨ tsahnu̱ tsi, vaha xaan tsaha̱ tsi tsɨtɨ. Tyin tsa iin ñi tsɨtɨ ican, cientu tsɨtɨ quita̱ tsihin tsi ―catyí ra Jesús. Tan tsa yaha̱ tsaha̱ ra cuhva can, tan quitsaha̱ caná tsaa ra tyin na tyaa soho nyɨvɨ, tan catyí ra: ―Tatun iyó soho ndo, tya̱a soho ndo tuhun caahán yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yaha̱ can tan ra tsicá tsihin ra, nducu̱ tuhun ra naha tsi ra náa cuñí tsi catyi cuhva tsa caha̱n ra tsihin nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tacan tan catyí ra tsihin ra naha: ―Tsi nyooho jacotó Nyoo tuhun xeehe, nácaa ndacá ñaha ra. Maa tyin tandɨhɨ ca ñi ican, tsihin cuhva ñi caahán yu tsihin ñi. Tacan tan nyehé ñi tan cuví tsi tumaa tsa ña nditsin nyehé ñi, tan tsiñí ñi maa tyin ña cua cutuñi iñi ñi náa tuhun cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Cuhva tsa tsaha̱ yu tsi ñi, cuñí tsi catyi tsi tyehen: tsɨtɨ can, tuhun Nyoo cuví tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tan nu cucoyo̱ tsɨtɨ trigu ican yuhu ityi, nyɨvɨ tsa tsiñi̱ tuhun Nyoo cuví can. Maa tyin quitsi̱ nu ña vaha tan quinyaa̱ nu tuhun Nyoo tsi ñi tan coto tsinu iñi ñi tan cacu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tan nu cucoyo̱ tsɨtɨ can tyañu yuu, juvin ñi nyɨvɨ tsa tsiñi̱ tuhun Nyoo cuví can. Sɨɨ xaan naquihi̱n vaha ñi itsi juhva ñi quɨvɨ. Maa tyin ña yɨhɨ́ vaha yoho ñi, juhva ñi quɨvɨ tsinu̱ iñi ñi, tan quɨvɨ tsa quitsaha̱ nyehé ñi tundoho, tan jandɨhɨ̱ ñi tsa tsinú iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tan nu cucoyo̱ tsɨtɨ tyañu iñu, juvin ñi nyɨvɨ tsiñi̱ tuhun Nyoo cuví can. Tsiñi̱ ñi tuhun Nyoo maa tyin ña nasama̱ ñi cuhva iyó ñi. Tyin yɨhɨ́ ñi, tyaá ca iñi ñi tuhun tundoho tan ñavin ca tuhun Nyoo. Tan inga ñi, nyiyo ca iñi ñi tsa cuca. Tan inga tucu ñi sɨɨ ca cuñí ñi tsihin tsa sɨɨ caá tsa iyó nu ñuhu ñayɨvɨ. Tan cuví ñi tumaa cuví yutun tsa ña tsaha̱ tsɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Maa tyin nu cucoyo̱ tsɨtɨ nu ñuhu vaha, yacan cuví nyɨvɨ tsa tsiñi̱ tuhun Nyoo, tan vaha añima ñi tyin tsinú iñi ñi tsihin tanɨɨ añima ñi. Tan vaha tyaá soho ñi tuhun Nyoo, tan ña naá maa iñi ñi tuhun ra. Tan javahá ñi tandɨhɨ tuhun caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Ndi intuhun yo ña tyaá yo ñuhu̱ tyuma tan tyihí xeehe yo xuu tsito a inga nu xeehe. Tyaá yo ñuhu̱ tyuma maa tyin tsaquín nyaa yo can iin nu sucun, tacan tan quɨhvɨ́ nyɨvɨ tsitsi vehe maa tyin nditsin. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tyin nduve iin tsa nyií xeehe, tan ña cua quituvi can. Tan ndi intuhun tsa xeehe, tan ña cua quita tsi nu nditsin, tan tsahan nacoto yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yacan cuenda tya̱a soho ndo tuhun caahán yu. Tyin tatun tyaá yahvi ndo tuhun caahán yu, cuaha ca cua janaha yu tsi ndo. Maa tyin tatun ña cua tyaa soho ndo, tacan tan cua quinyaa Nyoo nda cuanda tsa luxu ñi tsa cuñí maa ndo tyin cumí ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tacan tan tsaa̱ sɨhɨ ra Jesús tsihin yañi ra nu nyií ra. Maa tyin ña cuvi̱ tsaa ñi tyin tuvi xaan nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tacan tan jacoto̱ nyɨvɨ nyecú ican tsi ra Jesús, tan catyí ñi: ―Sɨhɨ un tsihin ra yañi un naha ra nyecú ñi tsata vehe. Tan cuñí ñi cahan ñi tsihin un. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tacan tan nacaha̱n ra Jesús, tan catyí ra: ―Tandɨhɨ maa nyɨvɨ tsa tyaá soho tuhun Nyoo tsa caahán yu tan tyaá yahvi ñi itsi, juvin ñi cuví sɨhɨ yu, tan juvin ñi cuví yañi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cuví tsi iin quɨvɨ quɨhvɨ̱ ra Jesús tsitsi iin yutun ndoo tsihin ra tsicá tsihin ra. Tan catyí ra tsihin ra naha: ―Co̱hon ndo inga tsiyo miñi ihya. Tacan tan cuahán ra naha tsihin yutun ndoo ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tan tsa ndi cuahán ca ra naha mahñu miñi ican, quixí ra Jesús. Tacan tan sana iñi ra naha tan tsaa̱ tatyi ñihi xaan. Tan quitsaha̱ tyihí tsi ndutya tsitsi yutun ndoo ican. Tan cuñí nyee yutun ndoo can tyin cuaha xaan ndutya quɨhvɨ̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tacan tan jandoto̱ ra naha tsi ra Jesús. Tan catyí ra naha tsihin ra: ―¡Maestro! ¡Maestro! Tsa cuñí nyee yo tsitsi ndutya ―catyí ra naha. Tacan tan nduvita̱ ra Jesús. Tan caahán ra tsihin tatyi can tan tsihin ndutya can, na cutaxin tsi. Tan cutaxi̱n tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tacan tan catyí ra tsihin ra tsicá tsihin ra: ―¿Nacuvi yuuhví ndo? ¿Numaa cuahán tsa tsinú iñi ndo? ―catyí ra tsihin ra naha. Maa tyin ra ican naha ra, nayuhvi̱ xaan ra naha. Tan iyo xaan cuñí ra naha. Tan quitsaha̱ tsicá tuhun tahan ra naha: ―¿Yóo ra cuví ra ihya? Tyin nda cuanda tatyi tan ndutya tan tyaá yahvi tsi tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tacan tan tsaa̱ ra naha nda Gadara tsa canyií yuhu miñi ityi nuu Galilea tsa canyií inga tsiyo miñi can. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tan quita̱ ra Jesús tsitsi yutun ndoo ican. Tan ican tsaa̱ iin ra ñuu tsa canyií Gadara can tsijataha̱n ra tsi ra. Tan tsanaha xaan yɨhɨ́ tatyi ña vaha tsi ra, tan ña nditsí ca maa ra jahma. Tan ña iyó ra vehe ra. Tsicá nuu ñi maa ra nu ñaña cumí santu. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Tan tuhvá tatyi ña vaha ican jacunú sana nu tsi ra. Tan yacan cuenda tuhvá ñi tsaahñí ndaha ra tan tsaha ra tsihin cadena. Maa tyin tatyi ña vaha ican tsahá tunyee iñi tsi ra tsa cahnya ra can. Tan jacunú nu tsi ra. Tan tsindacá nu tsi ra iin nu nduve maa nyɨvɨ iyó. Ra ican tsaa̱ ra nu nyií ra Jesús. Tan cuhva tsa nyehe̱ ra can tsi ra Jesús, tsicuɨñɨ̱ tsɨtɨ ra nuu ra. Tan caná tsaa ra tan catyí ra: ―¿Nacuvi tyihí un tsi un tsihin yuhu, yooho Jesús, Sehe Nyoo nyaá gloria? Tsicán yu tsi un ña ja̱nyehe un tundoho tsi yu ―catyí ra yɨhɨ́ tatyi ña vaha ican tsihin ra Jesús, tyin ra Jesús tava̱ tyiñu ra tsi nu tsa quita nu tsi ra ndaahvi ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tan nducu̱ tuhun ra Jesús tsi tatyi ña vaha ican, tan catyí ra: ―¿Náa nañí un? Tan tatyi ña vaha ican jacaha̱n nu tsi ra can, tan catyí ra: ―Nyuhu nañí ndi, Legión. Tacan catyí ra tyin cuaha xaan tatyi ña vaha yɨhɨ́ tsi ra. Cuenda mil nahnu yɨhɨ́ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tacan tan catyí nahnu tsihin ra Jesús tyin ña jacuhun ra tsi nahnu tsitsi Yavi Cunu nu cua nyehe nahnu tundoho tan ña cuvi maa quita nahnu. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tan tsica̱n nahnu tsi ra Jesús na cuhva ra quɨhvɨ nahnu tsitsi quɨnɨ tsa yucú yuhu miñi ican tsatsí tɨ naha tɨ. Tacan tan tsaha̱ ra Jesús ndatu tsa quɨhvɨ nahnu tsitsi quɨnɨ ican naha tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tan quita̱ nahnu tsi ra ndaahvi can. Tan quɨhvɨ̱ nahnu tsitsi quɨnɨ ican naha tɨ. Tacan tan tsinu̱ quɨnɨ can naha tɨ. Tan yatyin ican nyaá iin xahva cunu yuhu miñi ican. Ican cucoyo̱ tɨ naha tɨ tsitsi miñi ican. Tan tsihi̱ tɨ naha tɨ tsitsi ndutya. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tacan tan ra jahá cuenda tsi quɨnɨ ican naha ra, nayuhvi̱ xaan ra naha. Tan tsinú ra naha cuahán ra naha cua nacatyi tuhun ra naha tsa cuvi̱ can tsihin nyɨvɨ nda ñuu. Tan tandɨhɨ ñi nyɨvɨ tsa nyehe̱ ra naha, tan nacatyi̱ tuhun ra naha tsa cuvi̱ ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tacan tan tsaha̱n nyɨvɨ tsinyehe̱ ñi náa tsa cuvi̱, tan tsaa̱ ñi nu nyií ra Jesús. Tan nañihi̱ ñi tsi ra tsa tsa yaha̱ quita̱ tatyi ña vaha can. Nyaá ra tsaha ra Jesús. Tan tsa ñuhú ra jahma. Tan tsa vaha cuñí jiñi ra. Tan nayuhvi̱ xaan ñi cuvi̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tacan tan tandɨhɨ ñi tsa nyehe̱ tsa cuvi̱ ican, nacatyí tuhun ñi tsihin tandɨhɨ ca nyɨvɨ nácaa quita̱ tatyi ña vaha tsi ra ndaahvi can, tan nduvaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Tacan tan tandɨhɨ nyɨvɨ iyó Gadara can quitsaha̱ caahán ñi tsihin ra Jesús na cunuhu ra ityi nu quee̱ ra. Tyin nayuhvi̱ xaan ñi tsa javaha̱ ra tsihin nu tatyi ña vaha ican. Tacan tan ra tsa quita̱ nu tatyi ña vaha can nahnu, caha̱n ndaahvi ra tsihin ra Jesús, na cuhva ra cuhun ndɨhɨ ra tsihin ra. Maa tyin catyí ra Jesús tsihin ra: ―Cu̱anuhu yuvehe un. Tan cu̱hva cuenda un tsi nyɨvɨ vehe un náa ndɨhɨ tsa javaha̱ Nyoo tsihin un ―catyí ra. Tacan tan ra Jesús quɨhvɨ̱ ra tsitsi yutun ndoo ican. Tan cuanuhu̱ ra tsihin ra tsicá tsihin ra. Tacan tan ra ndaahvi tsa nduvaha̱ ican, cuanuhu̱ ra nda ñuu ra. Tan ityi cuahán ra nacatyí tuhun ra tsihin tandɨhɨ nyɨvɨ ñuu ican nácaa janduvaha̱ ra Jesús tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Quɨvɨ tsa tsaa̱ ra Jesús inga tsaha tsa tsaha̱n ra inga tsiyo miñi can, cuaha xaan nyɨvɨ ndatú tsi ra. Tan sɨɨ xaan cuñí ñi tyin tsaa̱ nyico ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tacan tan tsaa̱ iin ra tsa nañí Jairo, ra cuví ityi nuu vehe ñuhu, tan tsicuɨñɨ̱ tsɨtɨ ra nuu ra Jesús. Tan quitsaha̱ caahán ndaahvi ra tsihin ra na cuhun ra vehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tyin iyó iin ñaha sehe ra, tan iyó utsi uvi cuiya ña. Tan tsa cuñí cúu ña jahá cuehe. Tacan tan cuahán ra Jesús vehe ra. Tan cuaha xaan nyɨvɨ cuahán tsihin ra, tan tyañu xaan nu cuahán ra tyañu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tan tsihin nyɨvɨ ican cuahán iin ñaha cuuhví. Tsa iyó utsi uvi cuiya ndohó ña cuehe tsa cuún nɨñɨ ña. Tan tsa ndɨhɨ maa xuhun ña janaa̱ ña tsihin doctor tan ña nduvaha̱ ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Maa tyin tsaa̱ ña nu cuahán ra Jesús, ityi tsata ra. Tan tɨɨ̱n ña jahma ra. Tan iin yaha ñi, tan tsicuɨñɨ̱ tsa cuún nɨñɨ ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tacan tan catyí ra Jesús: ―¿Yóo tɨɨ̱n jahma yu? Tan tandɨhɨ ñi cuahán tsihin ra catyí ñi: ―Yoñi. Tan ra Pedro tsihin ra cutahan tsihin ra, catyí ra naha tsihin ra Jesús: ―Maestro, cuaha xaan nyɨvɨ cuahán tsihin un, tan tyañu xaan nu cuahán un. Tan juvin ñi maa ñi tyandahñí tsi un. Tan nducú tuhun ca un “¿Yóo tɨɨ̱n jahma yu?” ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Maa tyin ra Jesús catyí ra: ―Tsitó maa yu tyin iyó iin nyɨvɨ tɨɨ̱n jahma yu, tyin tuvi̱ iñi yu cuahán juhva tunyee iñi tsa iyó tsi yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tacan tan ñaha can nyehé ña tyin tsa tsitó ra. Tan quitsaha̱ nɨhɨ́ ña tsihin tsa yuuhví ña. Tan tsicuɨñɨ̱ tsɨtɨ ña nuu ra. Tan nacatyi̱ tuhun ña tsihin ra nacuenda tɨɨ̱n ña jahma ra, tan nácaa nduvaha̱ ña iin yaha ñi ican. Tan tsiñí tandɨhɨ nyɨvɨ tsa nacatyí tuhun ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tacan tan catyí ra Jesús tsihin ña: ―Tsa nduvaha̱ un tyin tsinú iñi un tsi yu. Cu̱aahan tsihin tsa vaha ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ndi caahán ca ra Jesús, tan tsaa̱ ñi iin ra quee̱ vehe ra Jairo, ra cuví ityi nuu vehe ñuhu. Tan catyí ra tsihin ra Jairo: ―Sehe un tsa yaha̱ tsihi̱ ña. Ña cuhva ca un tɨsɨhɨ tsi ra Maestro ihya ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Maa tyin tsa tsiñi̱ ra Jesús tsa caha̱n ra ican, tan catyí ra tsihin ra Jairo: ―Ña nayuhvi un. Tsi̱nu iñi. Tan ña sehe un cua nduvaha ña ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tan cuhva tsa tsaa̱ ra Jesús vehe ra Jairo, ña tsaha̱ ra quɨhvɨ nyɨvɨ tsitsi vehe. Maa ñi maa ra Pedro tan ra Jacobo tan ra Juan tan jutu ñaha luhlu can tsihin sɨhɨ ña quɨhvɨ̱ ñi tsitsi vehe nu canyií ñaha luhlu tsa tsihi̱ can. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tan tandɨhɨ ñi tsacú xaan ñi tsa cuenda tyin tsihi̱ ña. Maa tyin ra Jesús catyí ra tsihin ñi: ―Ña va̱cu ca ndo. Tyin ña tsihi̱ ña. Quixí ña ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Maa tyin tsacú naaha ñi tsa caahán ra tacan. Tan ña tsinú iñi ñi, tyin tsitó ñi tyin tsa tsihi̱ ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tacan tan tɨɨ̱n ra Jesús ndaha ña. Tan tsaa nacaha̱n ra tan catyí ra tsihin ña: ―Ndu̱vita, ñaha luhlu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tacan tan nandoto̱ ña. Tan iin yaha ñi nduvita̱ ña. Tan catyí ra Jesús: ―Cu̱hva ndo tsa catsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tan jutu ña tsihin sɨhɨ ña, iyo xaan cuñí ñi. Maa tyin catyí ra Jesús tsihin ñi tyin yoñi maa tsihin cua cahan ñi tsa cuvi̱ ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Cana̱ ra Jesús tsa utsi uvi taahan ra tsicá tsihin ra. Tan tsaha̱ ra tunyee iñi cahnu tsi ra naha tyin cuvi tava ra naha tatyi ña vaha tsi nyɨvɨ, tan cuvi janduvaha ra naha tsi nyɨvɨ cuuhví. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tan tava̱ tyiñu ra tsi ra naha na cahan ra naha nácaa ndacá ñaha Nyoo tsi nyɨvɨ. Tan tava̱ tucu ra tyiñu tsi ra naha na janduvaha ra naha tsi nyɨvɨ cuuhví. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tan catyí ra tsihin ra naha: ―Nduve tsa cuiso ndo ityi cuhun ndo, ndi tatun ña cundaha ndo. Ndi marali tan ndi tsa catsi ndo tan ña cundaha ndo. Tan ndi xuhun ña cundaha ndo. Tan iin nditsi ñi jahma ñuhú ndo cuhun tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tan ndáa cuví ñi vehe tsaa ndo, ndo̱o ndo ican nda cuanda quita quɨvɨ tsa cuhun ndo inga ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tan nu ña cuñí nyɨvɨ tyaa soho ñi tsa caahán ndo, qu̱ita ndo ñuu ican. Tan na̱quɨsɨ ndo nyaca ñuhu tsaha ndo. Tan yacan janahá tyin ndoó cuatyi ñi sɨquɨ ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tacan tan cuahán ra naha tandɨhɨ maa ñuu. Tan caahán ra naha tuhun Nyoo tan nácaa cuñí tsi tan cacu ñi. Tan janduvaha̱ ra naha tsi nyɨvɨ cuuhví. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ra Herodes, ra cuví ra ndacá ñaha tanɨɨ cahnu Galilea, ñihi̱ tuhun ra tsa javahá ra Jesús. Tan ña ñihí vaha ra cuhva yóo ra cuví ra. Tyin yɨhɨ́ nyɨvɨ catyí ñi tyin ra Juan nandoto̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tan yɨhɨ́ ñi catyí ñi tyin ra Elías quituvi̱ nyico. Tan yɨhɨ́ ñi catyí ñi tyin inga ra cuvi̱ ndusu yuhu Nyoo tsanaha nandoto̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Maa tyin catyí ra Herodes: ―Maa maa yu tyihi̱ tyiñu tsa tyahnya jucun ra Juan. Tun tacan, ¿yóo ra cuví ra tsa caahán xaan nyɨvɨ tuhun catyí ñi tsiñí yu tyin cuaha xaan tsa iyo javahá ra? ―catyí ra. Tan ra Herodes can nducú xaan ra cuhva nyehe ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tan cuhva tsa tsaa̱ nyico ra tava̱ tyiñu ra Jesús, tan nacatyi̱ tuhun ra naha tsihin ra Jesús tandɨhɨ maa tsa cuvi̱ nu tsaha̱n ra naha. Tacan tan tava̱ sɨɨn ra Jesús tsi ra naha tan cuahán ra naha yatyin ñi iin ñuu tsa nañí Betsaida. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Maa tyin cuhva tsa ñihi̱ tuhun nyɨvɨ tyin cuahán ra Jesús ndacan, tan cuahán ñi nda nu nyií ra. Tan naquihi̱n cuenda ra tsi ñi. Tacan tan quitsaha̱ caahán ra tsihin ñi nácaa ndacá ñaha Nyoo tsi ñi. Tan janduvaha̱ ra tsi nyɨvɨ cuuhví. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tan tsa tseñi cuii ña, tsa utsi uvi taahan ra tsicá tsihin ra Jesús catyí ra naha tsihin ra: ―Ca̱han tsihin nyɨvɨ ihya, na cunuhu ñi na quitatu ñi, na nanducu ñi tsa catsi ñi ñuu tsa canyií yatyin ñi ihya, tyin ihya nduve maa tsa catsi yo iyó ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tacan tan catyí ra Jesús tsihin ra naha: ―Cu̱hva nyooho tsa catsi ñi ―catyí ra. Tacan tan catyí ra naha: ―Nduve maa tsa iyó ihya. Uhun taahan ñi paan, tan uvi taahan ñi tyaca iyó. Maa tyin ña ñihi tsa catsi tandɨhɨ nyɨvɨ ihya. Ndi maa cuhun ndi cujata ndi, maa tyin ña cua ñihi tsa catsi ñi tyin cuaha xaan ñi ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tyin vasɨquɨ quitá maa uhun mil rayɨɨ yucú ican. Tan sɨɨn maa ñiñaha tsihin sehe ñi. Tacan tan ra Jesús catyí ra tsihin ra naha: ―Na cunyecu nyɨvɨ tsa uvi xico utsi taahan ñi iin iin nu cunyecu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tacan tan tsicunyecu̱ tandɨhɨ ñi jaha̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tan quihi̱n ra Jesús uhun taahan paan ican tsihin uvi taahan tyaca ican. Tan nanyehe̱ ndaa ra ityi andɨvɨ, tan nacuhva̱ ra tyahvi nyoo tsi Nyoo tsa cuenda can. Tan tsahnya̱ sava ra paan tan tyaca ican. Tan tsaha̱ ra tsi ra tsicá tsihin ra, na tsatsa ra naha can tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tacan tan tandɨhɨ ñi tsatsi̱ ñi, tan ndaha vaha iñi ñi. Yaha̱ can tan ndoo̱ ca tsa ñahñu, tan jacutu̱ ra naha utsi uvi taahan tyica tsihin tsa ñahñu ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Iin quɨvɨ quita̱ sɨɨn ra Jesús tsihin ra tsicá tsihin ra. Tan tsica̱n tahvi ra tsi Nyoo. Tan nu ndɨhɨ̱ tsica̱n tahvi ra, tan tsica̱ tuhun ra tsi ra tsicá tsihin ra tan catyí ra tsihin ra naha: ―¿Náa catyí nyɨvɨ tuhun yu, yóo ra cuví yu, catyí ñi? ");
INSERT INTO mjcNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tan nacaha̱n ra tsicá tsihin ra, tan catyí ra naha: ―Yɨhɨ́ ñi catyí ñi tyin ra Juan, ra jacoondutya̱ tsi nyɨvɨ, cuví un. Tan yɨhɨ́ ñi catyí ñi tyin ra Elías cuví un. Tan yɨhɨ́ ñi catyí ñi tyin inga ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha cuví un ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tacan tan nducu̱ tuhun ra Jesús tsi ra naha, tan catyí ra: ―Tan nyooho, ¿yóo ra cuví yuhu, cuñí maa ndo? Tan nacaha̱n ra Pedro, tan catyí ra: ―Yooho cuví ra Cristo, ra tsa quee̱ nu nyaá Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tan catyí ra Jesús tsihin ra naha tyin ña cahan ra naha can tsihin nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tacan tan catyí ra tsihin ra naha inga tsaha: ―Yuhu Rayɨɨ tsa quee̱ nda gloria cuví yu. Tan taahán tsi tyin cuaha xaan tundoho cua nyehe yu. Tan ra cuví mandoñi naha ra, tan ra cuví jutu tsa cuví ityi nuu naha ra, tsihin ra maestro cuenda ley naha ra ña cua tsinu iñi ra naha tsi yu. Tan cua cahñi ra naha tsi yu. Maa tyin tsa tsinu uñi quɨvɨ cua nandoto yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tacan tan catyí ra tsihin ra naha: ―Nyooho tsa cuñí cunyicun tsi yu, ca̱hnya iñi ndo tsa cuñí maa ndo javaha ndo, tacan tan cuvi javaha ndo tsa cuñí Nyoo. Ña ndu uvi iñi ndo tsa yɨhɨ́ ndo cuenda yu vasu tandɨhɨ quɨvɨ nyehé ndo tundoho. Tyin yacan cuví tumaa cruu tsa taahán tsi cuiso ndo tatun cua cunyicun ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tan nyooho tsa ña cuñí nyehe tundoho tan ña cuñí ndo cuhva ndo ñayɨvɨ iyó ndo tsa cuenda yu, cua nyehe ndo tundoho anyaya. Maa tyin nyooho tsa cua cuhva ñayɨvɨ iyó ndo tsa cuenda yu, cua cacu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nduve yahvi nyaá cua ñihi ndo tandɨhɨ tsa iyó nu ñuhu ñayɨvɨ ihya, tun ña cua cacu añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tyin tatun cahan nuu ndo tsa xaan cuñí nyɨvɨ nyehé ñi tsi ndo tsacatyi yuhu, tan tsacatyi tuhun caahán yu, cua nducahan tucu nuu maa yu nyehe yu tsi ndo na tsaa quɨvɨ quitsi yu inga tsaha. Tyin cua quitsi nyico yuhu Rayɨɨ tsa quee̱ nda gloria tsihin tsa cahnu cuví yu, tan tsa cahnu cuví Nyoo Jutu yo, tan ángel tsa cuenda ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tan tsa nditsa catyí yu tsihin ndo tyin yɨhɨ́ ndo tsa nyecú ndo ihya vityin, ña cua cúu ndo nda cuanda yaha nyehe ndo nácaa cuví nu ndacá ñaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Una quɨvɨ yaha̱ tsa caha̱n ra Jesús yacan, tan ndaa̱ ra iin yucu tyin cua ndacan tahvi ra tsi Nyoo. Tan cuahán ra Pedro, ra Jacobo tan ra Juan tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tan tsa ndi tsicán tahvi ca ra Jesús, tan nasama̱ cuhva caá nuu ra tan jahma ra. Sɨɨ xaan cuitsin tsi tan xiñu tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tacan tan quituvi̱ uvi taahan ra natuhún tsihin ra, ra Moisés tan ra Elías. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tan nditsin xaan nu yucú ra naha. Tan caahán ra naha cuenda tsa cua nyehe ra Jesús tundoho ñuu Jerusalén tan cua cúu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tan vasu cuñí xaan ra Pedro naha ra cusu ra naha, maa tyin ña quixi̱ maa ra naha tyin nyehé ra naha tsa nditsin cuví nu nyaá ra Jesús tsihin ra nyecú tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cuhva tsa cuahán ra tsinyecu̱ tsihin ra Jesús, tan catyí ra Pedro: ―Maestro, vaha xaan tsa yucú ndi ihya. Na javaha ndi uñi taahan tyahva, iin tsi maa un, iin tsi ra Moisés, tan iin tsi ra Elías ―catyí ra Pedro, maa tyin ña tsitó ra tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tan tsa ndi caahán ca ra tan quitsi̱ iin vico sɨquɨ ra naha. Tan nayuhvi̱ xaan ra naha tsa quɨhvɨ̱ ra naha tsitsi vico ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tacan tan tsitsi vico ican tsiñi̱ ra naha iin ndusu tsa catyí: ―Juvin ra ihya cuví Sehe yu, tan cuñí xaan yu tsi ra. Tya̱a soho ndo tsa caahán ra ―catyí ndusu ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tan tsa yaha̱ caha̱n ndusu ican, tan nanyehe̱ ra naha tyin intuhun ña maa ra Jesús nyaá ican. Tan yoñi maa tsihin caha̱n ra naha tsa nyehe̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tan tsa inga quɨvɨ tsa nuu̱ ra Jesús yucu ican, cuaha xaan nyɨvɨ tsijataha̱n tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tacan tan cana̱ tsaa iin ra cuahán tsihin nyɨvɨ cuaha tsa tsijataha̱n tsi ra Jesús, tan catyí ra: ―Maestro, ja̱ha tumañi iñi. Cu̱ndaahvi iñi tsi sehe yu. Tyin intuhun ñi maa ra cuví sehe yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tan tuhvá tatyi ña vaha quɨhvɨ́ tsi ra. Tan tuhvá ra caná tsaa jahá nu. Tan janduvá nu tsi ra ndasava. Tan quitá tiñuu yuhu ra. Quiñi xaan taahán ra jahá nu. Tan ña cuñí maa nu tatyi ña vaha ican jaña nu tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tsa caha̱n yu tsihin ra tsicá tsihin un na tava ra naha tsi nu tatyi ña vaha ican, maa tyin ña cuvi̱ tava̱ ra naha tsi nu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tacan tan nacaha̱n ra Jesús tan catyí ra: ―Nyooho, nyɨvɨ ña tsinú vaha iñi. Tan caquiñi ndo. ¿Najava taahan ca quɨvɨ cunyaa yu tsihin ndo tan cunyee iñi yu nyehe yu tsi ndo nda cuanda cutuhva ndo tan tsinu iñi ndo tsi yu? Tan catyí ra tsihin ra ican: ―Nda̱ca sehe un tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tan cuhva tsa natuhva̱ ra luhlu can nu nyaá ra Jesús, tan janduva̱ nu tatyi ña vaha ican tsi ra ndasava. Maa tyin ra Jesús tava̱ ra tsi nu tatyi ña vaha ican. Tan janduvaha̱ ra tsi ra. Tacan tan nacuhva̱ cuenda ra tsi ra tsi jutu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tan tandɨhɨ nyɨvɨ, iyo xaan cuñí ñi tsa cahnu tsa javaha̱ Nyoo nu yucú ñi. Tsitsi tsa iyo cuñí nyɨvɨ tsa javaha̱ ra Jesús, tan catyí ra tsihin ra tsicá tsihin ra: ");
INSERT INTO mjcNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Tya̱a soho vaha ndo tuhun caahán yu. Tan ña naa iñi ndo. Tyin Rayɨɨ tsa quee̱ nda gloria, cua cuhva cuenda nyɨvɨ tsi ra tsi ra xaan iñi tsi ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Maa tyin ra tsicá tsihin ra ña cutuñí iñi ra naha nacuenda caha̱n ra tacan. Tyin Nyoo ña tsaha̱ ra tsa cutuñi iñi ra naha. Tan yuuhví ra naha nducu tuhun ra naha tsi ra Jesús náa cuví tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tacan tan ra tsicá tsihin ra quitsaha̱ caahán yuhu tahan ra naha, ndáa ra cahnu ca cuví tsitsi tsa utsi uvi taahan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tan tsitó ra Jesús tsa tsicá iñi ra naha, tan quihi̱n ra iin ra luhlu. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tan catyí ra tsihin ra naha: ―Tatun tsihin sɨvɨ yu naquihín cuenda ndo tsi iin nyɨvɨ tsa ña cahnu jahá ñi tsi ñi tumaa ra luhlu ihya, tsi yuhu naquihín cuenda ndo cuví can. Tan tatun naquihín cuenda ndo tsi yu, tsi maa Nyoo tsa jaquitsi̱ tsi yu, naquihín cuenda ndo. Tyin nu yucú ndo, ra tsa ña cahnu cuví, juvin ra cuví ra cahnu cuví nuu Nyoo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tacan tan ra Juan catyí ra tsihin ra Jesús: ―Maestro, nyehe̱ ndi tsi iin ra tavá tatyi ña vaha. Caahán ra sɨvɨ un tan tavá ra tatyi ña vaha. Maa tyin ña tsaha̱ ca ndi javaha ra tacan. Tyin ñavin tsihin yo tsicá ra ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tacan tan catyí ra Jesús tsihin ra: ―Ña casɨ ndo tsi ra. Tyin ra ican, ñavin ra xaan iñi tsi yo cuví ra, juvin ra cutahán tsihin yo cuví ra ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tuvi̱ iñi ra Jesús tyin tsa nyaa naa yatyin quɨvɨ tsa cunuhu ra gloria. Tan jandu ii̱n ra iñi ra, tan quihi̱n ra ityi tan cuahán ra ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tan tava̱ tyiñu ra na cuhun ra tsicá tsihin ra ityi nuu ca. Tan cuahán ra naha nda iin ñuu cuenda Samaria, tyin nducú ra naha nu quitatu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Maa tyin nyɨvɨ Samaria ican, ña cuñí ñi tsa ndoo ra ndacan, tyin tuví iñi ñi tyin Jerusalén cuahán ra, tan nyɨvɨ Samaria ndasɨ cuñí ñi nyehe ñi tsi nyɨvɨ ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tan tsa tsitó ra Jacobo tan ra Juan tsa ña tsahá ñi Samaria ican tsa ndoo ra ican, catyí ra naha tsihin ra Jesús: ―Jutu Mañi ndi, ¿A cuñí un tsa ica yo tumaa ica̱ ra Elías? Cua ndacan yo tsi Nyoo na jaquitsi ra ñuhu̱ andɨvɨ tyin cayu ñi Samaria ican tyin ña cuñí ñi tsa ndoo yo ñuu ñi ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tacan tan nyehe̱ ra Jesús nuu ra naha. Tan cuxaa̱n ra tsi ra naha tan catyí ra: ―Ta̱xin ñi ndo. Ña vaha tsicá iñi ndo tyin ña cutuñí iñi ndo náa tyiñu vatsí yuhu. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tyin Rayɨɨ tsa quee̱ nda gloria, ña vatsí ra tyin janaa ra tsi nyɨvɨ, maa tyin vatsí ra tyin jacacu ra tsi ñi ―catyí ra. Tacan tan cuahán ra naha inga ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tan tsitsi tsa tsicá ityi ra naha, quita̱ iin ra, tan catyí ra tsihin ra Jesús: ―Jutu Mañi yu, cuñí yu cunyicun yu tsi un. Tan cuhun yu tsihin un tandɨhɨ ñi ityi cuhun un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tacan tan catyí ra Jesús tsihin ra: ―¿A nditsa un? Tyin ñicuii iyó vehe tɨ. Tan saa iyó taca tɨ. Maa tyin Rayɨɨ tsa quee̱ nda gloria ndi nu cava jiñi ra tan nduve iyó ―catyí ra tsihin ra ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tacan tan catyí ra Jesús tsihin inga ra: ―Co̱hon tsihin yu. Tacan tan nacaha̱n ra ican, tan catyí ra: ―Taa, cu̱atu nuu tsi yu, na cuhun jihna yu cucutsi yu tsi jutu yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tacan tan ra Jesús nacaha̱n ra tan catyí ra tsihin ra: ―Na̱coo tsi nyɨvɨ ña iyó Nyoo añima na cucutsi tahan maa ñi tsi ñi tsitsi ñuhu tun tsihi ñi. Maa tyin yooho cu̱aahan cahan un tuhun Nyoo tsihin nyɨvɨ na cuhva cuenda ñi tsi ñi tsi Nyoo na cundaca ñaha ra tsi ñi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tacan tan catyí inga ra tsihin ra Jesús: ―Cuñí yu cunyicun yu tsi un, tata. Maa tyin cu̱hva na cuhun jihna yu cucahan yu tsihin nyɨvɨ vehe yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tan ra Jesús catyí ra tsihin ra: ―Tumaa iin ra tahví ñuhu tsihin indɨquɨ, tatun nanyehe tsata ra, ña quita vaha yucun nu jahá tyiñu ra. Tan tacan cuví iin ra nyicún tsi yu, tatun cuñí nyico ra tsa tsa nacoo̱ ra, ña cuvi cuhva ra tsi ra cundaca ñaha Nyoo ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tsa yaha̱ can tan nacatsi̱ Jutu Mañi yo Jesús tsi inga uñi xico utsi ca ra naha. Tan jacuhu̱n ra tsi ra naha tandɨhɨ ñi ñuu, uvi uvi ra cuahan tsa iin nu cuahán ra nu cua cuhun ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tan catyí ra tsihin ra naha: ―Tumaa iin itu cahnu xaan, tacan cuví tyiñu jahá yu. Maa tyin cumañi xaan musu. Yacan cuenda nda̱can ndo tsi Nyoo na jaquitsi ca ra musu, tyin jatyinyee ra naha tsi ndo cahan ndo tuhun Nyoo tsihin nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tan cu̱aahan ndo tan nye̱he ndo tyin cua jacuhun yu tsi ndo tumaa mbee mahñu lobo tsa cuví quɨtɨ xaan. Tyin lobo tuhvá tɨ tsahñí tsi mbee. Tan tacan tucu cua cuñi nyɨvɨ cahñi ñi tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tan ña cua cuiso ndo ndi marali tan ndi nu yɨhɨ xuhun ndo, tan ndi inga pari nditsan ndo ña cuiso ndo. Ja̱numi ndo. Tun taahán ndo nyɨvɨ ityi cuahán ndo cu̱hva ndo nacumi tsi ñi tan ña cucuɨñɨ ndo natuhun ndo tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cuhva tsa quɨhvɨ ndo tsitsi vehe iin nyɨvɨ, ca̱han ndo tsihin ñi. Tan ca̱tyi ndo, na coo tsa vaha añima ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tan tacan tucu tatun iyó nyɨvɨ vaha iñi vehe ican, cua ndoo tsa vaha can tsihin ñi. Maa tyin tatun yoñi ñi vaha añima, ña cua ndoo tsa vaha tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tan ndo̱o ndo juvin ñi maa vehe ican. Tatun tsahá ñi tsa catsi ndo, ca̱tsi ndo. Tatun tsahá ñi tsa coho ndo, co̱ho ndo itsi. Tyin ra jahá tyiñu, iyó ndatu tsi ra tsa catsi ra tsa jahá canaa ra. Iin ñi maa vehe ican cuyucu ndo nda cuanda tsa tsaa quɨvɨ tsa cuhun ndo inga ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tan nu tsaa ndo iin ñuu tan vaha cahan ñi tsihin ndo, ca̱tsi ndo tandɨhɨ tsa cuhva ñi catsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tan ja̱nduvaha ndo tsi ñi cuuhví ñuu ican. Tan ca̱tyi ndo tsihin ñi: “Tsa nyanaá yatyin Nyoo, ra cuñí quɨhvɨ añima ndo cundaca ñaha ra tsi ndo.” ");
INSERT INTO mjcNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Maa tyin tatun tsaa ndo iin ñuu tan ña cuñí nyɨvɨ tyaa soho ñi tsa caahán ndo, qu̱ita ndo ityi cahnu. Tan ca̱tyi ndo tsihin ñi: ");
INSERT INTO mjcNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Nda cuanda nyaca ñuhu ñuu ndo tsa iñí tsaha ndi, tan cua naquɨsɨ ndi. Tyin cuñí tsi catyi tyin cuatyi ndo ndoó can sɨquɨ ndo. Tyin Nyoo nyanaá yatyin ra tsihin ndo tan ña tyaá soho ndo tsa caahán ra nácaa cuñí tsi tsa cundaca ñaha ra tsi ndo.” Tacan ca̱tyi ndo tsihin ñi ―catyí ra Jesús tsihin ra tsa uñi xico utsi can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tan catyí tucu ra tsihin ra naha: ―Quɨvɨ cua tatsi tuñi Nyoo tsi nyɨvɨ, yaha ca cuhva cua nyehe nyɨvɨ ñuu ican tundoho tan ñavin ca nyɨvɨ tsicoo̱ taha̱n tsanaha ñuu Sodoma, ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Tan catyí ra Jesús: ―¡Ndahvi nyooho, nyɨvɨ ñuu Corazin! Tan ¡ndahvi nyooho nyɨvɨ ñuu Betsaida! Tyin nyehé ndo tsa iyo javahá yu, tan ña cuñí ndo nasamá ndo cuhva iyó ndo. Maa tyin nyɨvɨ ñuu Tiro tan ñuu Sidón nduve tsa nyehe̱ ñi. Maa tyin tun tsatyin nyehe̱ ñi tsa nyehé nyooho vityin, numi xaan cua cunditsi ñi jahma tucuiihya iñi tan cunyecu ñi nu nyaa: tsa ndu uvi iñi ñi cuatyi ñi cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yacan cuenda, nyooho nyɨvɨ ñuu Corazin tsihin ñuu Betsaida, ñihi ca cua tatsi tuñi Nyoo tsi ndo tan ñavin ca nyɨvɨ ñuu Tiro tan nyɨvɨ ñuu Sidón can. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tan nyooho nyɨvɨ ñuu Capernaum, cuñí maa ndo tyin cundaa ndo nda cuanda andɨvɨ. Maa tyin cua nuu ndo nda cuanda nu yucú ndɨyɨ anyaya, tyin ña tyaá yahvi ndo tuhun Nyoo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tan catyí ra tsihin tsa uñi xico utsi taahan ra can naha ra: ―Nyɨvɨ tsa tyaá soho tsa caahán nyooho, tsa caahán yuhu tyaá soho ñi. Tan nyɨvɨ ña tyaá soho tsa caahán nyooho, tsa caahán yuhu ña tyaá yahvi ñi. Tan ñi ña tyaá yahvi tsa caahán yuhu, tsa caahán ra tsa jaquitsi̱ tsi yu, ña tyaá yahvi ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ihya cuví nu tsaa̱ nyico tsa uñi xico utsi ra tsa tsaha̱n tsicaha̱n tuhun Nyoo tsihin nyɨvɨ. Tan sɨɨ xaan cuñí ra naha. Tan catyí ra naha tsihin ra Jesús: ―Jutu Mañi nyuhu, nda cuanda nu tatyi ña vaha tan tyaá yahvi nahnu tsa caha̱n ndi tsihin sɨvɨ un ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tacan tan catyí ra Jesús tsihin ra naha: ―Tacan tyin yuhu nyehe̱ yu andɨvɨ nu canacava̱ nu ña vaha, nu nañí Satanás. Tumaa cañí iin tatsa savi, tacan canacava̱ nu. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tan maa yuhu, tsaha̱ tunyee iñi tsi ndo tyin cuví cañi tahan ndo tsihin nu ña vaha. Tan cuví cuañi ndo tsata coo tan tujuhma, tan nduve tsa cua jaha tɨ naha tɨ tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Maa tyin ña cusɨɨ xaan iñi ndo tyin cuví tava ndo tatyi ña vaha ican. Cusɨɨ ca iñi ndo tyin nyaá sɨvɨ ndo nu libru Nyoo nda gloria ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tacan tan sɨɨ xaan cuñí ra Jesús jahá Tatyi Ii Nyoo, tan catyí ra: ―Jacahnú yu tsi un, Jutu yu, tyin yooho cuví ra ndacá ñaha andɨvɨ tan nu ñuhu ñayɨvɨ ihya. Tyin maa un janahá un tuhun maa un tsi nyɨvɨ ndaahvi ihya. Tan ña janahá un tsi un tsi ra tsitó tan ra nyityi. Tacan cuví tsi Jutu yu tyin tacan cuñí maa un ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tan catyí ra Jesús tsihin tandɨhɨ ra naha: ―Tandɨhɨ maa tsaha̱ Jutu yu tsi yu. Yoñi tsitó tsi yu, intuhun ñi maa Jutu yu tsitó tsi yu. Tan yoñi tsitó yóo ra cuví Sehe Nyoo, intuhun ñi maa Jutu ra tsitó tsi ra. Tan yoñi tsitó yóo ra cuví Nyoo Jutu, intuhun ñi Sehe ra tsitó tsi ra. Tan coto tucu nyɨvɨ tsa cuñí Sehe Nyoo jacoto ra tsi ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tacan tan nanyehe̱ ra nu nyecú ra tsicá tsihin ra. Tan caahán xeehe ra tsihin ra naha: ―Sɨɨ xaan cuñí nyooho tan nyɨvɨ tsa iyó vityin tyin nyehé ndo tsa javahá yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tyin cuaha xaan rey tan ra cuví ndusu yuhu Nyoo taha̱n tsanaha, cuñi̱ ra naha nyehe ra naha tsa nyehé nyooho vityin. Maa tyin ña nyehe̱ ra naha. Tan cuñi̱ ra naha tyaa soho ra naha tsa tsiñí nyooho vityin. Maa tyin ña tsiñi̱ ra naha ―catyí ra Jesús tsihin ra tsa tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tacan tan tsaa̱ iin ra maestro cuenda ley vehe ñuhu. Tan quitsaha̱ tsicá tuhun ra tsi ra Jesús, tyin nducú cuhva ra tsi ra. Tan catyí ra: ―Maestro, ¿nácaa cua javaha yu tan cuhun yu coo yu ñayɨvɨ nyito tsa ña cua naa maa? ");
INSERT INTO mjcNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tacan tan nacaha̱n ra Jesús, tan catyí ra tsihin ra: ―¿Náa catyí nu ley? ¿Nacaa catyí tsa cahvi̱ un? ");
INSERT INTO mjcNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tacan tan nacaha̱n ra maestro cuenda ley ican tan catyí ra: ―Catyí ley tyin cu̱ñi yo tsi Nyoo tsihin tanɨɨ añima yo tan tsihin tandɨhɨ cuhva tsicá iñi yo, tan tsihin tandɨhɨ tunyee iñi tsa iyó tsi yo, tan tsihin tandɨhɨ tsa tsiñi tuñi tsa iyó tsi yo. Tan cu̱ñi yo tsi nyɨvɨ tumaa tsa cuñí yo tsi maa yo. Tacan catyí ley ―catyí ra ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tacan tan catyí ra Jesús tsihin ra: ―Nditsa tsa caahán un. Tacan ja̱vaha un tan coo un ñayɨvɨ nyito tsa ña cua naa maa ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Maa tyin ra maestro cuenda ley can cuñí ra cuvi ra ra vaha nuu ra Jesús, tan catyí ra tsihin ra: ―¿Tan yóo nyɨvɨ cuñi yu? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tacan tan nacaha̱n ra Jesús, tan catyí ra: ―Iin ra quee̱ ñuu Jerusalén cuahán ra nda ñuu Jericó. Tan taha̱n ra tsi nu ñasuhu nahnu. Tan suhu̱ nahnu tandɨhɨ maa tsa nyisó ra, nda cuanda jahma ra. Tan cañi̱ nahnu tsi ra nda cuanda tsaqui̱n taxin ña nahnu tsi ra. Tan nacoo̱ ihñi nahnu tsi ra ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tacan tan yaha̱ iin ra cuví jutu ityi can. Maa tyin tsa nyehe̱ ra tsi ra canyií ican, ndasava ñi yaha̱ tsiyo ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tacan tan yaha̱ tucu iin ra yɨhɨ́ cuenda vehe ñuhu, ra cuví tata ra Leví. Maa tyin tsa nyehe̱ ra tsi ra canyií ican, juvin ñi ndasava yaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tacan tucu iin ra Samaria yaha̱ ra juvin ñi ityi can. Tan nyehe̱ ra tsi ra canyií ican, tan quitsi̱ tsa ndaahvi cuñí ra nyehé ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tan natuhva̱ ra nu canyií ra, tan quitsaha̱ tyaá ra numeri tsi ra, tyihi̱ ra acetye tsihin vinu nu uhvi can. Tan tyaa̱ ra iin jahma vita nu uhvi can. Yaha̱ can tan jandaa̱ ra tsi ra tsata burru jana ra, tan quihi̱n ra tsi ra, cuahán tsihin ra nu nyaá iin vehe. Tan jaha̱ cuenda ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tan tsa inga quɨvɨ tsa cuñí cuhun ra Samaria. Tan tava̱ ra uvi taahan xuhun. Tan tsaha̱ ra tsi ra jatsii vehe can. Tan catyí ra tsihin ra: “Ja̱ha cuenda vaha tsi ra ihya. Tan cu̱hva tsa catsi ra. Tan ja̱ta un numeri tsi ra na nduvaha ñi ra. Tatun cuñí ca tsi xuhun, tyahvi maa yu tsi un tsa quitsi nyico yu”, catyí ra. Tacan tan cuahán ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nu ndɨhɨ̱ nacatyi̱ tuhun ra Jesús, tan nducu̱ tuhun ra tsi ra maestro can, tan catyí ra: ―Vaha. ¿Tsa uñi taahan ra naha, tan ndáa ra cuví ra vaha iñi tsi ra ndaahvi tsa tsinyaa̱ ndaha nu ñasuhu nahnu? ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tacan tan catyí ra maestro ican: ―Ra tsa cundaahvi̱ iñi tsi ra ―catyí ra. Tacan tan catyí ra Jesús: ―Cu̱aahan tan i̱ca tucu yooho tacan tsihin nyɨvɨ tsa nyehé tundoho ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tan quihi̱n ra Jesús ityi cuahán ra. Tan tsaa̱ ra iin ñuu. Tan ican iyó iin ñaha tsa nañí Marta. Tan tsaa̱ ra vehe ña. Tan tsaha̱ ña quɨhvɨ ra tsitsi vehe ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tan ña Marta, iyó iin tahan ña nañí María. Tan ña María tsicunyaa̱ ña yatyin ñi tsaha ra Jesús, tyin tyaa soho ña tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tan ña Marta cuaha xaan tyiñu javahá ña. Tan tsaa̱ ña nu nyaá ra Jesús, tan catyí ña tsihin ra: ―Yooho tata. ¿A ña tsicá iñi yooho tyin ña tahan yu nacoo̱ ña tsi intuhun ñi maa yu tsihin tyiñu ihya? Ca̱han tsihin ña na jatyinyee ña tsi yu ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Maa tyin ra Jesús catyí ra tsihin ña: ―Marta, Marta, tsicá xaan iñi un tan tuñu xaan cuñí un tsihin tyiñu can. ");
INSERT INTO mjcNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maa tyin iyó intuhun tsa ñiñi ca taahán tsi caca iñi yo. Tan ña María ihya nacatsi̱ ña tyiñu vaha ca javahá ña. Tan yoñi cuví quinyaa can tsi ña ―catyí ra Jesús tsihin ña Marta. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cuví iin tsaha tsa tsicán tahvi ra Jesús. Tsa ndɨhɨ̱ tsica̱n tahvi ra, tan catyí iin ra tsicá tsihin ra: ―Ja̱naha nácaa ndacan tahvi ndi tsi Nyoo, tumaa janaha̱ ra Juan tsi ra tsica̱ tsihin ra ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tacan tan catyí ra Jesús tsihin ra: ―Cua cuhva yu cuhva tsi ndo nácaa. Tyehen nda̱can tahvi ndo, ca̱tyi ndo: Jutu Mañi ndi, yooho tsa nyaá un gloria. Jacahnú xaan ndi tsi un. Na quitsi quɨvɨ tsa ndaca ñaha un nu ñuhu ñayɨvɨ ihya. Na javaha nyɨvɨ nu ñuhu ñayɨvɨ ihya tandɨhɨ cuhva cuñí maa un, tumaa cuhva cuví nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cu̱hva tsa catsi ndi tan yaha ndi iin iin quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ja̱ha tucahnu iñi tsi ndi tsa cuenda cuatyi ndi. Tyin nyuhu jahá tucu maa ndi tucahnu iñi tsi nyɨvɨ xaan iñi tsi ndi. Ña cua cuhva un tsa nducu cuhva nu ña vaha tsi ndi. Tan ja̱cacu tsi ndi tan ña cua cunyee nu ña vaha tsihin ndi. Tacan nda̱can tahvi ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tan catyí tucu ra: ―Na catyi yo tyin iin nyooho iyó iin ra vaha iñi tsi ndo, tan tsaa̱ ra vehe ndo tsa tsa cuaa tan catyí ra tsihin ndo: “Ja̱ha tumañi iñi tsi, xin. Cu̱hva nuu uñi taahán paan tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tyin iin ra vaha iñi tsi yu ndi tsaa̱ ra yuvehe yu. Tan cañi xaan quee̱ ra. Tan nduve tsa cuhva yu catsi ra.” ");
INSERT INTO mjcNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tan nyooho cua nacahan ndo tan catyi ndo tsihin ra: “Ña jatyañu un tsi yu, xin. Tyin ndasɨ́ yuvehe yu. Tan ndi quixí yu tsihin sehe yu. Tan ña cuví nduvita yu tan cuhva yu tsa cuhva yu tsi un tsa vityin.” Tacan cua catyi ndo tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tan catyí yu tsihin ndo. Vasu ra vaha iñi ndo cuví tsi ra can, ña cua nduvita ndo tan cuhva ndo tsa nducú ra tsa numi ñi. Maa tyin tatun caahán yuhu ra tsihin ndo, jandatsan ra yuvehe ndo tan caná tsaa ra tsi ndo tsa ña cua cuvi cusu ndo, tacan tan cua nduvita ndo tan cuhva ndo tsa nducú ra. Tacan tan ña cua jatyañu ca ra tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tan tacan tucu nyooho tsihin Nyoo, nda̱can ndo tsi ra. Tan cua cuhva ra tsi ndo. Na̱nducu ndo tan cua ñihi ndo. Ja̱ndatsan ndo yuvehe tan cua nuña. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tyin tatun ndacan ndo, cua ñihi ndo. Tatun nanducu ndo, cua nañihi ndo. Tatun cua jandatsan ndo yuvehe, cua nuña tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Tacan tucu nyooho tsa iyó sehe. Tuhvá ndo tsahá tsa vaha tsi sehe ndo. Ña tuhvá ndo cuhva iin yuu itsi tun tsicán tsi paan. Tan ña tuhvá ndo cuhva iin coo itsi tun tsicán tsi tyaca. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tan ña tuhvá ndo cuhva tujuhma tsi sehe ndo tatun tsicán tsi ndɨvɨ catsi tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nyooho quiñi iyó ndo, maa tyin tsitó ndo nácaa cuhva ndo tsa vaha tsi sehe ndo. Tan vihi ca maa Jutu Mañi yo, ra nyaá gloria, cuhva ra Tatyi Ii ra cunyaa añima ndo tun ndacan ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ra Jesús tava̱ ra tatyi ña vaha tsa janduñɨɨhɨ̱ tsi iin rayɨɨ. Tsa quita̱ nu tatyi can tsi ra can, cuvi̱ nacaha̱n ra. Tacan tan iyo xaan cuñí nyɨvɨ tsa nyehe̱ ñi tsa cuvi̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tan yɨhɨ́ ñi catyí ñi: ―Ra ihya, tavá ra tatyi ña vaha tsihin tunyee iñi nu Beelzebú nu cuví ityi nuu tsihin tandɨhɨ tatyi ña vaha ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tan yɨhɨ́ ñi cuñí ñi nducu cuhva ñi tsi ra, tan tsicán ñi tsi ra Jesús na javaha ra iin tsa iyo tsa quita andɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Maa tyin ra Jesús tsitó ra tsa tsicá iñi ñi. Tan catyí ra tsihin ñi: ―Tatun ra ndacá ñaha naha ra tan natahvi ra naha, tan cañi tahan ra naha, tacan tan cundɨhɨ tyiñu tsa ndacá ñaha ra naha. Tan tatun iin vehe tan natahvi nyɨvɨ tsihin tahan ñi, tacan tan cua tɨvɨ nu yucú ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tan tacan tucu nu ña vaha, tatun natahvi nahnu, cua cundɨhɨ tunyee iñi tsa iyó tsi nahnu. Caahán yu tyehen tsihin ndo, tyin catyí ndo tyin tsihin tunyee iñi nu Beelzebú tavá yu tsi nu tatyi ña vaha nahnu. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Maa tyin tun tsatyin tavá yu tsi nahnu tumaa cuhva catyí ndo, nda̱ca tuhun ndo tsi ra nyecú tsihin ndo yóo tsahá tunyee iñi tsi ra naha tan tavá ra naha tsi nahnu. Maa ra naha cua cahan tsa nditsa tsihin ndo tyin nyooho soho xaan tsicá iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Maa tyin catyí yu tsihin ndo tyin yuhu tavá yu tatyi ña vaha tsihin tunyee iñi Nyoo. Tan cuñí tsi catyi yacan tyin nditsa tyin Nyoo, ra taahán tsi cundaca ñaha tsi nyɨvɨ, tsa tsaa̱ ra nu yucú ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Tatun iin ra tan iyó xaan tunyee iñi tsi ra tan nyisó ra mityi ra, tan jahá cuenda ra vehe ra, nu yɨhɨ́ xeehe vaha ndaha tyiñu ra tsitsi vehe ra, tsa ña cua cuvi quinyaa ñasuhu. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Maa tyin tatun quitsi iin ra tsa cuaha ca tunyee iñi iyó, tan cañí tahan ra tsihin ra, tan cuví jaha canaa ra tsi ra, tacan tan quinyaa ra ndaha tyiñu ra tan natsatsa ra tsi ra vaha iñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nyɨvɨ ña jahá tyiñu tsihin yu, jatɨvɨ́ ñi tyiñu jahá yu. Tan tatun ña caahán ñi tuhun Nyoo tsihin nyɨvɨ, tyin cunyicun ñi tsi yu; cuñí tsi catyi tsi tyin ña tsahá ñi tsa cunyicun nyɨvɨ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Tatun iin nu tatyi ña vaha quita̱ nu tsi iin nyɨvɨ, tsicá nuu nu iin ñuhu ityi, nanducú nu nu quitatu nu. Maa tyin ña nañihí maa nu nu quitatu nu, tacan tan tsicá iñi nu: “Cunuhu nyico yu nda vehe yu nu quee̱ yu.” ");
INSERT INTO mjcNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tacan tan tsaa̱ nyico nu añima nu quee̱ nu. Tan nyehé nu tyin ndɨɨ xaan tan sɨɨ xaan caá. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tacan tan cua quihin nu utsa taahan ca tatyi ña vaha tsa yaha ca caquiñi tan ñavin ca maa nu. Tacan tan iin caa ñi cua quɨhvɨ tandɨhɨ nahnu añima ñi ican. Yacan cuenda yaha ca caquiñi ñi tan ñavin ca tsa jihna ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tsitsi tsa ndi caahán ca ra Jesús yacan, tan cana̱ tsaa iin ñaha tsa nyií mahñu nyɨvɨ ican. Tan catyí ña: ―¡Náa tsa sɨɨ cuñí ñaha tsa jacacu̱ tsi un, ñaha tsa jacaxi̱n tsi un! ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Maa tyin ra Jesús catyí ra: ―Sɨɨ xaan ca cuñi nyɨvɨ tsa tsiñí tuhun caahán Nyoo tan tyaá yahvi ñi itsi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tacan tan tsaa̱ ca nyɨvɨ nu nyií ra Jesús. Tan catyí ra tsihin ñi: ―Nyɨvɨ tsa iyó vityin quiñi xaan iyó ñi. Tan nyiyo xaan iñi ñi. Cuñí ñi nyehe jihna ñi tsa iyo. Maa tyin intuhun ñi tsa iyo cua nyehe ñi, yacan cuví tsa javaha̱ Nyoo tsihin ra Jonás, ra cuvi̱ ndusu yuhu Nyoo tsanaha. Nduve inga ca tsa iyo cua nyehe ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tumaa tsa janaha̱ ra Jonás tsi nyɨvɨ ñuu Nínive taha̱n tsanaha tyin ii Nyoo, tacan tucu yuhu, Rayɨɨ tsa quee̱ nda gloria, janahá yu tsi nyɨvɨ tsa iyó vityin tyin ii Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Quɨvɨ cua tatsi tuñi Nyoo tsi nyɨvɨ, cua nandoto ñaha cuvi̱ reina ityi sur taha̱n tsanaha, tan cua catyi ña tyin cuhun ndo anyaya tyin maa ña vasu cañi ñuu ña, maa tyin quitsi̱ ña, quitsi̱ tyaa soho ña tsa tsiñi tuñi tsa caha̱n ra Salomón. Tan vityin cahnu ca cuví ra nyaá tsihin ndo tan ñavin ca ra Salomón. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tan quɨvɨ cua cutuñi tandɨhɨ nyɨvɨ, cua nandoto nyɨvɨ tsicoo̱ ñuu Nínive taha̱n tsanaha, tan cua catyi ñi tyin nyooho nyɨvɨ tsa iyó vityin cuhun ndo anyaya, tyin nyɨvɨ Nínive ican, nasama̱ ñi cuhva iyó ñi quɨvɨ caha̱n ra Jonás tuhun Nyoo tsihin ñi. Tan vityin cahnu ca cuví ra nyaá tsihin ndo tan ñavin ca ra Jonás. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ndi intuhun ndo tan ña tuhvá ndo tyaá ñuhu̱ tyuma tan tyihí xeehe ndo can, a tinyií ndo can tsitsi iin caja. Tyin ñuhu̱ can taahán tsi cunyii can nu sucun. Tyin tatun quɨhvɨ nyɨvɨ tsitsi vehe ndo, nditsin. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tinuu yo, iin ñuhu̱ nditsin cuví tsi tsa cuenda cuñu ñuhu yo. Tan tacan tucu tsa nditsin Nyoo, tsa cuenda añima yo. Tatun iyó tsa nditsin jahá Nyoo añima yo, vaha nyɨvɨ cuví yo. Tatun nduve tsa nditsin jahá Nyoo añima yo, tumaa iin ra cuaa cuví yo, ña cuví nyehe yo ityi vaha tsa cuahán nu nyaá Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yacan cuenda ja̱ha ndo cuenda tsi ndo, na coo tsa nditsin jahá Nyoo añima ndo, tan ña coo tsa naa. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tatun tsitú añima ndo tsihin tsa nditsin jahá Nyoo, nduve ca maa tsa naa iyó tsihin ndo, tyin jandunditsín tsi tanɨɨ cahnu ndo. Tumaa tsa nyaá iin ñuhu̱ tyuma jandunditsín tsi tanɨɨ cahnu ndo cuví can ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tsa ndɨhɨ̱ caha̱n ra Jesús tsihin nyɨvɨ, iin ra fariseo, catyí ra tsihin ra, na cuhun ra cucatsi ra yuvehe ra. Tan tsaa̱ ra Jesús vehe ra. Tan quɨhvɨ̱ ra tsicunyaa̱ ra nu mesa. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tacan tan ra fariseo ican iyo cuñí ra tyin ña nacatya̱ ra Jesús ndaha ra tsa ndi cumañi ca catsi ra, tumaa cuhva iyó maa ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Maa tyin Jutu Mañi yo Jesús catyí ra tsihin ra: ―Nyooho, ra cuví fariseo, tumaa tsa tsata ñi vasu tan coho nacuhvá ndo. Maa tyin ityi tsitsi, quiñi xaan caá can tyin ña nacatyá ndo can. Tacan cuví nyooho. Tyin cuñí nyɨvɨ tyin vaha ndo. Maa tyin xeehe ñi suhú ndo tan javahá ndo tsa ña vaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ndava xaan iñi ndo. ¿A ña tsitó ndo tyin ra tsa javaha̱ ityi tsata ndo, juvin ñi maa ra javaha̱ ityi tsitsi ndo? ");
INSERT INTO mjcNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Taahán tsi javaha ndo tumañi iñi tsi nyɨvɨ ndaahvi, tan jatyinyee ndo tsi ñi tsihin tanɨɨ añima ndo. Ja̱vaha ndo tsa vaha tsihin ñi, tacan tan nduvaha tucu ityi tsitsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ndahvi nyooho ra fariseo! tyin nyooho, cahví ndo ndaha menta tan ndaha lura tan náa ndɨhɨ ca yucu tsa tsatsí ndo, tan tavá ndo intuhun tsi tsa iin iin utsi tan tsahá ndo tsi Nyoo, maa tyin ña tyaá yahvi ndo tsa vaha tsa cuñí Nyoo javaha yo tan tsa cuñí yo tsi ra. Taahán tsi tsa cu̱ñi vaha ca ndo tsi Nyoo tan ja̱vaha ndo cuhva cuñí ra, tan ña jandɨhɨ ndo tsa cuhva ndo diezmo can. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ndahvi nyooho tsa cuví ndo fariseo! tyin cuñí ndo cunyaa ndo nu tyayu vaha tsitsi vehe ñuhu. Tan cuñí ndo tsa tyaa yahvi nyɨvɨ tsi ndo nuyahvi. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ndahvi nyooho ra maestro cuenda ley, tan nyooho ra fariseo! Vaha xaan jahá ndo tsi ndo tan ña nditsa ndo. Cuví ndo tumaa iin ñaña ndɨyɨ tsa ña nditsin ca canyií. Tyin tsañí nyɨvɨ tsata can tan ña tsitó ñi tyin nyií ndɨyɨ tsitsi ñaña ican. Tyin nduve ca cuhva canyií nu nyií ndɨyɨ ican. Cuñí maa nyɨvɨ tyin vaha ndo, tan ña tsitó ñi tyin ña vaha añima ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tacan tan nacaha̱n iin ra maestro cuenda ley vehe ñuhu, tan catyí ra: ―Maestro, tsa catyí un tacan, caahán nyaa ndɨhɨ un tsi ndi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tacan tan catyí ra Jesús tsihin ra naha: ―¡Ndahvi tucu nyooho ra maestro cuenda ley vehe ñuhu! tyin jacuahá ca ndo ley tsa tsaha̱ Nyoo taha̱n tsanaha. Tan ña taahán tsi. Tan yoñi ndoyó carga can, tan jañiñi ca ndo na javaha nyɨvɨ can, tan maa ndo ndi luxu ña jatyinyeé ndo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ndahvi nyooho! tyin janduvahá vaha ndo ñaña nu ñuhú yɨquɨ ra cuvi̱ ndusu yuhu Nyoo tsa tsahñi̱ ra cuvi̱ tsii tsaahnu ndo taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yacan cuñí tsi catyi tyin ndoó ndo vaha tsa javaha̱ tsii tsaahnu ndo naha ra. Tyin tsii tsaahnu ndo tsahñi̱ ra naha tsi ra cuvi̱ ndusu yuhu Nyoo. Tan nyooho janduvahá ca ndo ñaña ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yacan cuenda catyi̱ Nyoo taha̱n tsanaha tsihin tsa tsiñi tuñi ra tyin cua jaquitsi ra tsi ra cua cuvi ndusu yuhu ra tan ra caca tyiñu ra nu iyó ndo. Tan cua cahñi ndo juhva ra naha tan inga ra cua jacunu ndo tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tan nditsa tyin tacan javahá ndo. Nyoo cua tatsi tuñi ra tsi ndo tan tsi nyɨvɨ iyó vityin tsa cuenda tandɨhɨ ra cuvi̱ ndusu yuhu ra tsa tsahñi̱ tsii tsaahnu ndo naha ra nda cuanda tsinu̱ ñuhu ñayɨvɨ tan nda cuanda vityin. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nda cuanda nɨñɨ ra Abel tsa tsatɨ̱ tsa tsahñi̱ ra Caín yañi ra tsi ra, tan nda cuanda nɨñɨ ra Zacarías tsa tsahñi̱ nyɨvɨ tsitsi vehe ñuhu yatyin nu nyaá altar. Yacan cuenda catyí Nyoo tyin cua tatsi tuñi ra tsi nyɨvɨ tsa iyó vityin tsa catyí cuatyi nyɨvɨ tsa tsicoo̱ taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ndahvi nyooho ra maestro cuenda ley vehe ñuhu! tyin tumaa tsa tyihí xeehe ndo ndaha tucu yuvehe nu quɨhvɨ́ nyɨvɨ ityi nu nyaá Nyoo. Tan ndi maa ndo ña quɨhvɨ́ ndo nu nyaá Nyoo. Tan ndi ña tsahá ndo tsa quɨhvɨ inga nyɨvɨ tsa cuñí quɨhvɨ ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ndɨhɨ caha̱n ra Jesús tacan. Tan ra maestro cuenda ley vehe ñuhu naha ra tsihin ra fariseo naha ra, nduxaa̱n xaan ra naha tan quitsaha̱ nducú tuhun xaan ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tyin cuñí ra naha tsa cahan ra Jesús iin tsa ña vaha, tyin tacan tan cuvi tyaa ra naha cuatyi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Cuenda mil nyɨvɨ ndu ii̱n nda cuanda catyihí tahan ña ñi, tyin cuaha xaan ñi. Tacan tan ra Jesús caha̱n jihna ra tsihin ra tsicá tsihin ra: ―Ja̱ha ndo cuenda tsi ndo tsihin ra fariseo naha ra tsihin cuatyi ra tsa cuví tumaa yutsan iya. Tyin ndaá paan jahá yutsan iya, tan tacan cuví cuatyi ra can naha ra. Tyin jahá ra naha tyin vaha ra. Maa tyin ña cuví tyihi xeehe ra naha cuatyi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tyin nduve iin tsa yɨhɨ́ xeehe tan cuñí yo, tyin ña cua quituvi. Tan nduve tsa xeehe tan cuñí yo, tyin ña cua coto nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yacan cuenda, náa ndɨhɨ tsa caahán ndo nu xeehe, cua quita tsi nu nditsin. Tan náa ndɨhɨ tsa caahán ndo tsitsi vehe ndo, cua cana tsaa nyɨvɨ jiñi vehe. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Tan catyí yu tsihin ndo tsa cuví ndo ra vaha iñi tsi yu, tyin ña na̱yuhvi ndo tsi nu tsahñí cuñu ñuhu yo. Tyin yaha can tan nduve ca tsa cuví javaha nu tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Maa tyin cua catyi yu tsihin ndo yóo taahán tsi nayuhvi ndo. Na̱yuhvi ndo tan tya̱a yahvi ndo tsi Nyoo, ra cuví quinyaa tsa nyito ndo. Tan yaha yacan tan cuví tyihi ra tsi ndo anyaya. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Saa, ña yahvi nyaá tɨ. Cuví jata yo uhun taahan tɨ tsihin uvi ñi xuhun. Vasu ndi maa nyihi ñi tɨ, Nyoo ña naá iñi ra tsi ndi intuhun tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tan nyooho, nyaá yahvi ca ndo nu Nyoo tan ñavin ca tsa cuaha saa can, tan nda cuanda ixi jiñi ndo tan tsitó Nyoo najava taahan tsi iyó tyin tsa nacahvi̱ ra intuhun intuhun tsi. Yacan cuenda ña na̱yuhvi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Catyí yu tsihin ndo tyin tandɨhɨ nyooho tsa janahá ndo tsi nyɨvɨ tyin tsinú iñi ndo tsi yu, tacan tucu maa yu, cua cahan yu tuhun ndo nuu ángel Nyoo nda gloria. Tyin yuhu Rayɨɨ nda gloria quee̱ yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Maa tyin nyooho tsa janahá ndo tyin ña tsinú iñi ndo tsi yu, tacan tucu maa yu, cua cahan yu nuu ángel Nyoo tyin ñavin nyɨvɨ cuenda yu cuví ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tan vasu cuxaan nyɨvɨ tsi yuhu, Rayɨɨ tsa quee̱ nda gloria, Nyoo cua jaha ra tucahnu iñi tsi ñi. Maa tyin nyɨvɨ caahán tsa ndavaha ñi sɨquɨ Tatyi Ii Nyoo ña cua coo tucahnu iñi tsi ñi cuenda yacan. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Quɨvɨ tsa cua cundaca nyɨvɨ tsi ndo tsitsi vehe ñuhu, nu juez, a nuu ra cumí tyiñu naha ra, ña caca iñi ndo náa tuhun cua nacahan ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tyin cuhva tsa cua nacahan ndo, cua cuhva maa Tatyi Ii Nyoo náa tuhun taahán tsi cahan ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iin ra tsa nyií tsihin nyɨvɨ cuaha tsa ndu ii̱n nu nyií ra Jesús, catyí ra tsihin ra Jesús: ―Maestro, ca̱han tsihin ra yañi yu na natahvi ra tsa tsii jutu ndi, cuhva ra tsa taahán tsi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tacan tan catyí ra Jesús tsihin ra: ―¿Tsaa, yóo tsaha̱ tsi yu tsa cuví yu juez tan natahvi yu ndaha tyiñu ndo? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tan yaha̱ can tan catyí ra nuu nyɨvɨ cuaha can: ―Ja̱ha xaan ndo cuenda tan ña nyiyo xaan iñi ndo tyin ña tsiñí ñuhu tsa coo cuaha ndaha tyiñu yo tan coonyito yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tacan tan tsaha̱ cuenda ra Jesús iin cuhva tsi tandɨhɨ nyɨvɨ, tan catyí ra: ―Tsicoo̱ iin ra cuca. Tan cuaha xaan ndaha tyiñu ñihí ra nu jaha̱ tyiñu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tacan tan tsicá iñi ra: “¿Nacaa javaha yu? Nduve nu quɨhɨ tandɨhɨ ndaha tyiñu ihya.” ");
INSERT INTO mjcNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tan catyí ra: “Tsa tsitó yu nácaa cua javaha yu. Cua canɨ yu tandɨhɨ yaca nyihi yu, tan cua javaha yu tsa nahnu ca, tan natyihi yu tandɨhɨ ndaha tyiñu can tsihin tandɨhɨ ca tsa iyó tsi yu tsitsi can. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tacan tan cua catyi yu tsihin yu: Cuaha xaan ndaha tyiñu naquihi̱n vaha un, tan vityin cuahán maa cuiya, qu̱itatu, ca̱tsi vaha, co̱ho vaha, tan cu̱sɨɨ iñi.” ");
INSERT INTO mjcNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tan Nyoo catyí ra tsihin ra can: “Ra soho, tsacuaa vityin cua cúu un, tan tsa naquihi̱n vaha un ¿Yóo tsii cua cuví yacan?” catyí Nyoo tsihin ra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tacan cuví iin ra tsa jatacá tan tyihí vaha ra tsa cuca tsi ra; maa tyin nuu Nyoo ra ndaahvi cuví ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tacan tan catyí ra Jesús tsihin ra tsicá tsihin ra: ―Tacan ñi catyí yu tsihin ndo, ña caca xaan iñi ndo nácaa ñihi ndo tsa catsi ndo, tan ndi jahma tsa cunditsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tyin nyaá yahvi ca ñayɨvɨ tsa nyito yo tan ñavin ca tsa catsi yo. Tan nyaá yahvi ca cuñu ñuhu yo tan ñavin ca tsa nditsí yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ja̱ha ndo cuenda saa tyin ña jahá tyiñu tɨ. Tan ndi ña tyihí vaha tɨ tsa catsi tɨ. Maa tyin tsatsí tɨ, tyin Nyoo tsahá ra tsa catsi tɨ. Tan nuu Nyoo nyaá yahvi ca nyooho tan ñavin ca saa. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tan vasu ndi maa tsicá xaan iñi ndo maa tyin ña cuví jandusucun ndo luxu ca tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tatun ndi luxu can tan ña cuví jahá ndo, ¿nacuenda tsa tsicá xaan iñi ndo tandɨhɨ ca tsa tsiñí ñuhu tsi ndo? ");
INSERT INTO mjcNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ja̱ha ndo cuenda nácaa iyó yutun ita tyin ña jahá tyiñu tun tan ndi ña taví tun yuhva. Maa tyin catyí yu tsihin ndo tyin ndi ra rey Salomón tsihin tandɨhɨ tsa cuca ra tan ña sɨɨ caá tsa tsinditsi̱ ra tumaa tsa jacunditsí Nyoo tsi yutun ita ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tatun tacan ñi jacunditsí Nyoo tsi yutun ita tsa iyó nu tsɨquɨ vityin, tan ityaan cua cayu tun tsitsi horno, tan nyooho cahnu ca cuví ndo nuu ra tan ñavin ca yutun ita. ¿A ña cua cuhva ra tsa cunditsi ndo? Maa tyin maa ndo ña tsinú vaha iñi ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ña caca xaan iñi ndo tuhun tsa catsi ndo tan tsa coho ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tyin nyɨvɨ tsa ña tsinú iñi tsi Nyoo tsicá iñi ñi yacan. Maa tyin Jutu yo Nyoo tsitó ra náa tsiñí ñuhu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vaha ca tsa nducu ndo nácaa cuhva cuenda ndo tsi ndo tsi Nyoo na cundaca ñaha ra tsi ndo. Tan cuhva tucu ra tandɨhɨ tsa tsiñí ñuhu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ña nayuhvi nyooho, mbee jana yu. Ña cuaha ndo maa tyin Jutu yo Nyoo cuñí ra tsi ndo. Yacan cuenda cua cuhva ra quɨhvɨ ndo nu ndacá ñaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xi̱co ndo tsa iyó tsi ndo. Tan jatyinyee ndo tsi nyɨvɨ ndaahvi. Tatun javahá ndo tacan, jacayá ndo tsa vaha nuu nyaá Nyoo. Tyin nuu nyaá Nyoo ña ndɨhɨ tsa vaha. Tyin yoñi yóo jatɨvɨ́ can ndacan, ndi nu ñasuhu, tan ndi quɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tyin nuu iyó tsa cuca ndo, ican cuví nu nyita iñi ndo. Tan ndacan cua coo ndɨhɨ añima ndo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Cu̱atu vaha ndo tsi yu tsihin ñuhu̱ nditsin Nyoo quɨvɨ quitsi yu inga tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tan cu̱vi ndo tumaa musu tsa ndatú tsi tsitoho ra naha náa cuhva quitsi ra tsa cuahán ra iin vico tindaha. Tan ndatú ra naha, tyin tacan tan numi ñi cua nuña ra naha yuvehe cuhva tsa jandatsan tsitoho ra naha tsa tsaa ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Tan sɨɨ xaan cua cuñi ra naha nyehe ra naha tsi ra cuví tsitoho ra naha. Tyin ndatú ra naha tsi ra nda cuanda tsa tsaa ra, vasu ñuu taxin, vasu tsa naha ca. Tan cua tyaa ra tsi ra musu ican naha ra yuhu mesa tan cuhva ra tsa catsi ra naha. Tacan tan sɨɨ xaan cua cuñi musu can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tan co̱to ndo tyin tatun tsitoho vehe, tan tsitó ra náa cuhva cua quɨhvɨ ñasuhu vehe ra, cua jaha ra cuenda vehe ra. Tan ña cua cuhva ra quɨhvɨ nu ñasuhu ican tsitsi vehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tan tacan cuví tucu nyooho, cu̱atu ndo. Tyin yuhu, Rayɨɨ tsa quee̱ nda gloria, sana iñi ndo tan cua quitsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tacan tan quitsaha̱ nducú tuhun ra Pedro tsi ra Jesús: ―Jutu Mañi yu, ¿yóo cuenda caahan un yacan? ¿A tsa cuenda maa ñi maa ndi, a tsa cuenda tandɨhɨ nyɨvɨ? ");
INSERT INTO mjcNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tacan tan nacaha̱n ra Jesús, tan catyí ra tsihin ra: ―Musu tsa tyaá soho tsa caahán tsitoho ra, juvin ra cuví musu vaha. Tyin jahá cuenda ra vehe tsitoho ra. Tan vaha cuhva tsahá ra tsa catsi tandɨhɨ ca musu ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tan sɨɨ xaan cuñí musu ican tatun cuhva tsa jahá tyiñu ra, tan cua tsaa tsitoho ra. Tyin tyaá yahvi ra tandɨhɨ tsa taahán tsi ica ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tan catyí yu tsihin ndo tyin tsa nditsa. Tyin tsitoho ra cua nacuhva ra tandɨhɨ tsa cumí ra, cua quɨhɨ ndaha ra. Tyin vaha tyaá yahvi ra tsihin tyiñu jahá ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Maa tyin tatun tsicá iñi musu ican tyin naha xaan cuahán tsitoho ra, tan quitsaha̱ cañí ra tsi inga musu tsa cutahán tsihin ra tan ñiñaha jahá tyiñu ican, tan ña cuñí ra jaha tyiñu ra. Tyiñu tsatsí ñi tan tyiñu tsiñí nyixi ñi iyó ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tacan tan sana iñi ra cua tsaa tsitoho ra quɨvɨ tsa ña ndatú ra tsi ra, tan cuhva tsa ña tsitó ra. Tacan tan ñihi xaan cua tatsi tuñi tsitoho ra tsi ra, tumaa tuhvá maa ra icá tsihin nyɨvɨ tsa ña tsiñú iñi tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Tan iin musu tsa tsitó nácaa iyó tsitoho ra tan ña javahá ra cuhva cuñí tsitoho ra, cuaha xaan tundoho cua nyehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Maa tyin tatun iin musu tsa ña tsitó, tan javaha ra tsa ña vaha, cua tatsi tuñi tsitoho ra tsi ra, maa tyin luxu ñi. Tyin ña tsito̱ ra can, tan javaha̱ ra. Tatun iin musu tan cuaha tsa tsaha̱ tsitoho ra tsi ra, cuaha tyiñu taahán tsi nacuhva cuenda ra tsi tsitoho ra. Tan ra tsa cuaha xaan yɨhɨ́ ndaha can, cuaha xaan tyiñu taahán tsi nacuhva cuenda ra tsi tsitoho ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Tumaa tsa jatahán yu ñuhu̱ nu ñuhu ñayɨvɨ, tacan cuví tyiñu vatsí yu. ¡Tan cuñí xaan yu tsa nacayu catyin ña ñuhu̱ ihya! ");
INSERT INTO mjcNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tyin nyaá cua yaha yu iin tundoho cahnu, tan cahnu xaan tundoho iyó yu nda cuanda ndɨhɨ tyiñu jahá yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Cuñí maa ndo tyin tsa vatsí cuhva yu tsa taxin coo ndo nu ñuhu ñayɨvɨ ihya. Maa tyin yuhu vatsí yu tyin jasɨɨn yu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tyin tsa vityin tan ityi nuu ca, uhun taahan nyɨvɨ iin vehe ñi cua cusɨɨn ñi. Uñi taahan ñi cua cañi tahan tsihin uvi taahan ñi. Tan uvi taahan ñi cua cañi tahan tsihin uñi taahan ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tan ra iyó sehe, cua cañi tahan ra tsihin sehe ra. Tan ra cuví sehe can cua cañi tahan ra tsihin jutu ra. Tan ñaha iyó sehe sɨɨhɨ cua cañi tahan ña tsihin sehe sɨɨhɨ ña. Tan ña cuví sehe sɨɨhɨ can cua cañi tahan ña tsihin sɨhɨ ña. Tan ñaha cuví tyiso cua cañi tahan ña tsihin tsanu ña. Tan ñaha cuví tsanu can cua cañi tahan ña tsihin tyiso ña ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Catyí tucu ra Jesús tsihin nyɨvɨ cuaha tsa yucú ican: ―Tatun nyehé ndo tyin tsa yɨhɨ́ vico, catyí ndo tyin tsa cua cuun savi. Tan tacan tsa cuii cuví. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tatun tsa nyehé ndo tyin tsa yɨhɨ́ tatyi quee̱ ityi ndutya ñuhu, catyí ndo tyin tsa cua ndu ihñi. Tan quita tsa cuii nu caahán ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nyooho jahá ndo tsa tsitó xaan ndo, tan nacotó ndo tandɨhɨ tsa cuví andɨvɨ, tan tandɨhɨ tsa cuví nu ñuhu ñayɨvɨ ihya. Tan ¿nacuenda tsa ña nacotó ndo náa tyembu iyó ndo vityin? ");
INSERT INTO mjcNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Nacuenda ña jahá ndo cuenda, ndáa tsa vaha tan ndáa tsa ña vaha? ");
INSERT INTO mjcNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tatun iin ra tsicán cuatyi tsaha ndo tan cuahán ndo tsihin ra nu nyaá ra cumí tyiñu, ityi cuahán ndo ndu̱cu ndo cuhva coo vaha ndo tsihin ra tsa ndi cumañi ca tsaa ndo nu nyaá ra cumí tyiñu. Coto nacuhva cuenda ra tsi ndo tsi juez. Tan juez ican cua nacuhva cuenda ra tsi ndo tsi ra vitya naha ra. Tan ra vitya naha ra cua tyihi ra naha tsi ndo tsitsi vehe caa. ");
INSERT INTO mjcNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tatun tacan cua cuvi, catyí yu tsihin ndo tyin ña cua quita ndo nda cuanda tyahvi ndo tandɨhɨ tsa taahán tsi tyahvi ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tacan tan juvin ñi quɨvɨ can nyecu juhva ra naha. Tan quitsaha̱ nacatyí tuhun ra naha tsihin ra Jesús tsa javaha̱ ra Pilato tsihin juhva ra Galilea naha ra. Tyin tava̱ ra tyiñu na cahñi andaru naha ra tsi ra Galilea tsa tsijamañi̱ quɨtɨ jana ra naha tsi Nyoo. Tan tacan saca̱ nuu nɨñɨ ra ican naha ra tsihin nɨñɨ quɨtɨ tsa tsijamañi̱ ra ican naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tan nacaha̱n ra Jesús tan catyí ra tsihin ra naha: ―¿A tsicá iñi nyooho tyin cahnu xaan ca cuatyi ra Galilea ican naha ra tan ñavin ca tandɨhɨ ca ra ñuu ra naha, tan yacan tsihi̱ ra naha? ");
INSERT INTO mjcNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ñavin. Tyin tatun nyooho tan ña nasama ndo cuhva iyó ndo, tacan cua cunaa ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tan tsa tsahun uñi taahan ra tsihi̱ can naha ra tsa canacava̱ torre Siloé ican tsata ra naha, ¿a cuaha ca cuatyi ra naha tan ñavin ca inga ra tsa tsicoo̱ ñuu Jerusalén, cuñí maa ndo? ");
INSERT INTO mjcNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ñavin. Tyin tatun nyooho tan ña nasama ndo cuhva iyó ndo, cua cunaa ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tacan tan tsaha̱ cuenda ra Jesús iin cuhva ihya. Tan catyí ra: ―Iin ra iyó yutun tsa nañí higuera tsi ra. Tan nyaa tun nu ñuhu ra. Tan tsaha̱n ra tsinyehe̱ ra tatun iñi tsɨtɨ tun. Tan nyehe̱ ra tyin nduve. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tan catyí ra tsihin ra jahá cuenda tsi tun: “Tsa uñi cuiya tsa tyito ñi quitsi̱ nyehe̱ yu tatun iyó tsɨtɨ tun. Tan nduve maa tsɨtɨ tun iñi. Ca̱hnya tsi tun. Tyin nyaá cuatu ñi maa tun nu ñuhu ihya. Tyin nduve tsɨtɨ tsahá tun”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Maa tyin ra tsa jahá cuenda ñuhu ican catyí ra: “Taa, ña cua cahnya naha yo tsi tun vityin. Na cunyaá nuu maa tun inga cuiya ihya. Cua janduvita yu ñuhu tsaha tun tan cua tyihi yu ñuhu tyaahyú. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Vasɨquɨ tacan tan cua cuhva tun tsɨtɨ. Maa tyin tatun ña cuhva tun tsɨtɨ, tacan tan cahnya yo tsi tun”, catyí ra tsa jahá cuenda ñuhu can ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iin quɨvɨ tsa quitatú nyɨvɨ, jacuahá ra Jesús tsi nyɨvɨ tsitsi vehe ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tan ican nyaá iin ñaha tsa yɨhɨ́ tatyi ña vaha. Tan tsa tsahun uñi cuiya cuuhví ña tsa tɨhɨ́ tsata ña. Tan ña cuví ndundoo ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tacan tan nyehe̱ ra Jesús tsi ña. Tan cana̱ ra tsi ña. Tan quitsaha̱ caahán ra tsihin ña, tan catyí ra: ―Tsa nduvaha̱ un. Nduve ca cuehe ndohó un ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tacan tan tyisó ra ndaha ra jiñi ña. Tan iin yaha ñi tan ndundoo̱ ña. Tacan tan quitsaha̱ jacahnú ña tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Maa tyin ra cuví ityi nuu vehe ñuhu, cuxaa̱n xaan ra tsi ra. Tyin quɨvɨ quitatú janduvaha̱ ra tsi ña. Tan catyí ra tsihin nyɨvɨ nyecú ican: ―Iyó iñu taahan quɨvɨ taahán tsi jaha tyiñu yo. Tacan quɨvɨ qu̱itsi ndo cuvi ndo numeri. Tan ña quitsi ndo quɨvɨ quitatú yo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tacan tan Jutu Mañi yo Jesús catyí ra tsihin ra: ―Nyooho tsa jahá ndo tyin vaha ndo. ¿A ña ndatsí tucu nyooho quɨtɨ jana ndo tan jacohó ndo ndutya tsi tɨ quɨvɨ quitatú yo? ");
INSERT INTO mjcNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tan tacan tucu ñaha ihya, tata ra Abraham cuví tsi ña. Tan tsa tsahun uñi cuiya tsa nuuhñí ña tsihin cuehe ihya jahá nu ña vaha. Tan yoñi ndatsi tsi ña. ¿A ña taahán tsi ndatsi yo tsi ña vasu ndi maa quɨvɨ quitatú yo cuví vityin? ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tacan tan cuhva tsa caha̱n ra Jesús yacan, tandɨhɨ maa nu xaan iñi tsi ra nducahan nuu nahnu. Maa tyin tandɨhɨ ca maa nyɨvɨ sɨɨ xaan cuñí ñi tsihin tsa cahnu tsa iyo javaha̱ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tacan tan catyí ra Jesús: ―¿Náa cuví tsa ndacá ñaha Nyoo tsi yo? ¿Tan náa tsihin jandu inducu yo itsi? ");
INSERT INTO mjcNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tumaa iin tsɨtɨ mostaza, tacan cuví tsi. Tyin iin ra tatsi̱ ra iin tsɨtɨ ican nu ñuhu ra, tan cana̱ iin yutun luhlu, tan tsahnu̱ tun. Tan cuví tun iin yutun cahnu xaan. Tacan tan tsaa̱ saa naha tɨ nuu yutun ican. Tan javaha̱ tɨ taca tɨ nuu tun. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tacan tan catyí ra Jesús inga tsaha: ―¿Náa ca tsihin jandu inducu yu nácaa ndacá ñaha Nyoo tsi yo? ");
INSERT INTO mjcNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cuví tsi tumaa yutsan iya tsa nasacá nuu iin ñaha tsihin uñi jahma yutyi paan. Tyin tumaa ndaá tanɨɨ yutsan paan ican jahá yutsan iya ican, tacan cuví tsa ndacá ñaha Nyoo tsi yo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ityi cuahán ra Jesús ñuu Jerusalén caahán ra tuhun Nyoo tsihin nyɨvɨ tandɨhɨ ñi ñuu nu yahá ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tan iin ra tsicá tuhun ra tsi ra: ―Jutu Mañi yu, ¿a cuaha maa nyɨvɨ cua cacu? ―catyí ra. Tacan tan nacaha̱n ra Jesús, tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Na̱nducu ndo cuhva quɨhvɨ ndo yuvehe tɨhɨn. Tyin tacan cuví quɨhvɨ ndo nu ndacá ñaha Nyoo. Tyin cuaha xaan ndo cuñí ndo quɨhvɨ ndo ndacan, tan ña cuvi. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tyin tumaa tsitoho iin vehe, tacan cuví Nyoo. Tan tsitoho vehe ican cua nacasɨ ra yuvehe. Tacan tan nyooho tsa nyecú ndo ityi tsata cua jandatsan ndo yuvehe, tan cua catyi ndo: “Nu̱ña yuvehe.” Tan ra ican cua catyi ra tsihin ndo: “Ña tsitó yu ndáa ityi quee̱ nyooho.” ");
INSERT INTO mjcNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tacan tan nyooho cua catyi ndo: “Nyuhu tsatsi̱ ndi tan tsihi̱ ndi tsihin un. Maa un jacuaha̱ un tuhun Nyoo tsi ndi ityi nu nyecú vehe ndi”, cua catyi ndo tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Maa tyin ra ican cua nacahan ra tsihin ndo tan cua catyi ra: “Tsa catyi̱ yu tsihin ndo tyin ña tsitó yu ndáa ityi quee̱ ndo. Ca̱tsiyo nyaha ndo nu nyaá yu tandɨhɨ nyooho nyɨvɨ javahá tsa ña vaha” ");
INSERT INTO mjcNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tacan tan cua vacu ndo tan catsan ña cua cuvi nuhu ndo tsa cua nyehe ndo tsi ra Abraham tsihin ra Isaac tan ra Jacob, tan tsihin tandɨhɨ ra cuvi̱ ndusu yuhu Nyoo tsa tsicoo̱ taha̱n tsanaha. Tyin nyecú ra naha nu ndacá ñaha Nyoo. Tan nyooho ndoo̱ ndo ityi tsata. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tan cua quitsi nyɨvɨ ityi ndutya ñuhu, tan ityi norte, tan ityi nu caná ñicanyii, tan ityi nu tyisó ñicanyii. Tan cua cunyecu ñi catsi ñi tsihin Nyoo nu ndacá ñaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tan juhva nyɨvɨ tsa cuahán ityi nuu vityin, ñi can cuhun nu ndɨhɨ. Tan juhva nyɨvɨ tsa cuahán nu ndɨhɨ ña, ñi can cua cuhun ityi nuu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Juvin ñi maa quɨvɨ can tsaa̱ juhva ra fariseo. Tan catyí ra naha tsihin ra Jesús: ―Qu̱ita ihya tyin ra Herodes cuñí ra cahñi ra tsi un ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tan catyí ra Jesús tsihin ra naha: ―Cu̱aahan ndo tan cahan ndo tsihin ra tsa cuví tumaa ñicuii, tyin nda cuanda quita quɨvɨ tsa ndɨhɨ tyiñu jahá yu tsa tavá yu tatyi ña vaha tsi nyɨvɨ tan tsa janduvahá yu tsi nyɨvɨ cuuhví tsihin cuehe, tacan tan cundɨhɨ tyiñu jahá yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Maa tyin nda cuanda tahan tsi tsa ndɨhɨ maa tyiñu jahá yu, tacan tan cuhun maa yu cua cúu yu nda ñuu Jerusalén. Tyin ña cuví cúu iin ra cuví ndusu yuhu Nyoo ityi tsata ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Ndahvi nyooho nyɨvɨ Jerusalén! tyin tsahñí ndo tsi ra cuví ndusu yuhu Nyoo. Tan cañí ndo yuu tsi tandɨhɨ ra tsa jaquitsi̱ Nyoo nu yucú ndo. Tan yuhu cuaha xaan tsaha cuñí yu jaha cuenda yu tsi ndo, tumaa jahá cuenda iin ndɨvɨ sɨɨhɨ sehe tɨ, tan naquihín vaha tɨ tsi tɨ naha tɨ tsitsi nditsin tɨ. Maa tyin maa ndo ña cuñí ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nye̱he ndo vityin tyin tsa nacoo̱ yu tsi ndo. Tan catyí yu tsihin ndo tyin ña cua nyehe ca ndo tsi yu nda cuanda quita quɨvɨ tsa cua catyi ndo tyin cahnu xaan ra vatsí tsihin sɨvɨ Nyoo Jutu yo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cuví tsi iin quɨvɨ quitatú nyɨvɨ. Tan ra Jesús cuahán ra cua catsi ra vehe iin ra cuví ityi nuu tsihin ra fariseo naha ra. Tan juhva ca ra fariseo ican ndatú ra naha nyehé ra naha náa cuatyi cuví tyaa ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tacan tan yatyin ñi nuu ra Jesús nyaá iin ra cuuhví tsa iyó cuiñu. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tan catyí ra Jesús tsihin ra maestro cuenda ley vehe ñuhu naha ra tan tsihin ra fariseo naha ra: ―¿A vaha janduvaha yo nyɨvɨ cuuhví quɨvɨ quitatú yo? ¿Náa catyí ley Nyoo? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tacan tan tandɨhɨ ra naha, taxin ña tsinyecu̱ ra naha. Tacan tan tyiso̱ ndaha ra Jesús jiñi ra cuuhví can. Tan janduvaha̱ ra tsi ra. Tan catyí ra tsihin ra na cunuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tacan tan catyí ra Jesús tsihin ra fariseo naha ra: ―Tatun nyooho tan canacava̱ iin burru jana ndo, a inga quɨtɨ jana ndo, tsitsi xahva, ¿a ña cua tava ndo tsi tɨ tsa numi ñi, vasu ndi maa quɨvɨ quitatú yo cuví? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tacan tan taxin ña tsinyecú ra fariseo naha ra. Tyin ña ñihi̱ ca ra naha náa nacahan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nyehe̱ ra Jesús tyin tandɨhɨ ra nyecú vico ican nacatsi̱ ra naha tyayu vaha ca cunyecu ra naha. Tacan tan tsaha̱ cuenda ra tyehen tsi ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ndáa quɨvɨ cuhun ndo vico tindaha, ña nanducu ndo tyayu vaha ca cunyecu ndo. Tyin coto quitsi inga ra tsa cahnu ca cuvi tan ñavin ca maa ndo, ");
INSERT INTO mjcNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tan coto quitsi ra tsa cana̱ tsi ndo tan catyí ra tsihin ndo: “Cu̱hva tyayu can tyin cunyaa ra ihya.” Tacan tan nyooho tsihin tsa cahan nuu ndo, tan cua cuhva ndo tyayu can. Tacan tan cua cunyecu ndo nu ndɨhɨ ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Maa tyin catyí yu tsihin ndo, tyin ndáa quɨvɨ cana ra tsi ndo, cu̱aahan ndo, tan ñavin nu vaha cunyecu ndo. Tyin tacan tan cua quitsi maa ra tsa cana̱ tsi ndo tan cua cahan ra tsihin ndo: “Amigos, na̱ha ndo, cu̱nyecu ndo nu tyayu vaha ihya.” Tan tacan cua jacahnu ca ra tsi ndo nu nyɨvɨ nyecú yuhu mesa tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tyin ra tsa cahnu jahá tsi maa ra, cua tahan ra ticanuu. Tan ra tsa ndaahvi jahá tsi ra, cahnu ca cua cuvi ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tacan tan catyí tucu ra tsihin ra cana̱ tsi ra nu iyó vico can: ―Ndáa quɨvɨ coo vico vehe un, ña cua cana un tsi ra vaha iñi tsi un, ndi tsi ra yañi un, ndi tsi ra cuví nyɨvɨ un, ndi tsi nyɨvɨ nyecú yuvehe un, ñi cuca. Tyin ñi ican cuví cana tucu ñi tsi maa un, na coo tucu vico vehe maa ñi. Tacan tan nacahnya ñi cuenda tsa tsaha̱n ñi vico vehe un. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Maa tyin catyi yu tsihin un tyin ndáa quɨvɨ coo vico vehe un, ca̱na tsi nyɨvɨ ndaahvi, nyɨvɨ cuuhví, nyɨvɨ coxo, tan tsihin nyɨvɨ cuaa. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tacan tan sɨɨ cua cuñí un, tyin ñi ican ña cua cuvi natyahvi ñi tsi un. Maa tyin cua natyahvi Nyoo tsi un quɨvɨ cua nandoto un tsihin nyɨvɨ vaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tan tsiñi̱ iin ra tsa nyaá yuhu mesa ican tsa caahán ra Jesús. Tan catyí ra tsihin ra: ―Sɨɨ xaan cua cuñi nyɨvɨ tsa cua catsi nu ndacá ñaha Nyoo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tacan tan catyí ra Jesús tsihin ra: ―Iin ra ican jacoo̱ ra iin vico cahnu xaan vehe ra. Tan cana̱ ra cuaha xaan nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tacan tan tsaa̱ cuhva tsa cua cuxiñi ñi, tan jacuhún ra tsi musu ra na cuquihin ra tsi ñi, tyin tsa taha̱n tsi cuhva cuxiñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Maa tyin tandɨhɨ ñi ican quitsaha̱ caahán ñi tyin ña cua cuhun ñi. Tan iin ra ican catyí ra: “Ndi jata̱ yu iin ñuhu. Tan cuñí tsi cuhun yu cunyehe yu itsi. Yacan tsicán yu na jaha ra tucahnu iñi tsi yu tyin ña cua cuhun yu.” ");
INSERT INTO mjcNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tacan tan inga ra ican catyí ra: “Ndi jata̱ ñi yu uhun taahan yunta. Tan cuhun yu cunyehe yu tatun vaha tɨ naha tɨ. Yacan tsicán yu tumañi iñi tsi ra na jaha ra tucahnu iñi tsi yu, tyin ña cua cuvi cuhun yu.” ");
INSERT INTO mjcNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tacan tan inga tucu ra ican catyí ra: “Ndi tindaha̱ cuii ñi yu, tan ña cua cuvi cuhun yu”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tacan tan musu ra ican cuanuhu̱ ra. Tan catyí tuhun ra tandɨhɨ tsa cuvi̱ ican tsihin ra tsitoho ra. Tsa tsiñi̱ tsitoho ra tsa tacan, tan cuxaa̱n xaan ra. Tan catyí ra tsihin musu ra: “Cu̱aahan vityin tandɨhɨ maa ityi. Tan qu̱itsi ndaca un tsi nyɨvɨ ndaahvi, nyɨvɨ cuuhví, nyɨvɨ coxo, tan tsihin nyɨvɨ cuaa”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tan tsa yaha̱ tsaa̱ nyico musu ican tan catyí ra tsihin ra tsitoho ra: “Tsa javaha̱ yu tandɨhɨ maa tsa caha̱n un tsihin yu. Tan nuña ca tsitsi vehe”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tacan tan tsitoho ra catyí ra tsihin ra: “Cu̱aahan cua nducu ca nyɨvɨ tandɨhɨ maa ityi. Tan ja̱ñiñi un tsi ñi na quitsi ñi, tyin na cutu tsitsi vehe yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tyin catyí yu tsihin un tyin ndi intuhun ñi tsa cana̱ yu tsa jihna, ña cua catsi ñi tsihin yu”, catyí ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cuaha xaan nyɨvɨ nyicún tsi ra Jesús. Tacan tan nanyehe̱ ra tsi ñi, tan catyí ra tsihin ñi: ");
INSERT INTO mjcNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tandɨhɨ nyooho tsa nyicún tsi yu, tatun cuñí ca ndo tsi nyɨvɨ ndo tan ñavin ca tsi yuhu, ñavin cuenda yu yɨhɨ́ ndo. Tan tatun cuñí ca ndo tsi maa ndo tsa nuu yuhu, ñavin cuenda yu yɨhɨ́ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tyin nyooho tsa ña cuñí nyehe tundoho tsa cunyicun ndo tsi yu, ña taahán tsi cuvi ndo nyɨvɨ cuenda yu, tyin tsa nyehé ndo tundoho, yacan cuví cruu tsa taahán tsi cuiso ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tyin tun cua javaha ndo iin vehe, nacañí nuu jihna ndo jiñi ndo tan tyihi tuñi iñi ndo tun quita vehe cahnu can tsihin xuhun tsa nyií tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tyin tatun quitsaha̱ jandaá ndo vehe ican, tan ña cuvi jandɨhɨ ndo tyin nduve ca xuhun ndo, cua vacu nducu nyɨvɨ tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tan cua catyi ñi: “Ra ican quitsaha̱ javahá ra vehe ra, tan ndi ña cuví jandɨhɨ ra can”, cua catyi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A tatun iin rey tan cuñí ra cañi tahan ra tsihin inga rey ¿a ña cunyaa jihna ra tan nyehe ra tatun ñihi tsa utsi mil ñi andaru tsa cuahán tsihin ra cua cañi tahan ra naha tsihin inga rey tsa vatsí tsihin oco mil andaru ican? ");
INSERT INTO mjcNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tan tatun tsitó ra tyin ña cua cuvi jaha canaa ra tsi inga rey ican, tacan tan cañi ca vatsí inga rey ican, tan cua jacuhun ra tsi musu ra tyin na catyi tuhun ra naha tsihin inga rey ican na jandɨhɨ taxin ra itsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tan tacan cuví nyooho. Tatun ña cahnya iñi ndo tandɨhɨ maa tsa cuñí ndo tan tandɨhɨ tsa cumí ndo, ña cua cuvi cunyicun ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Vaha ñɨɨ tyin jacu uhvá tsi tsa catsi yo. Maa tyin tatun ndɨhɨ tsa uhva tsi, ña vaha ca tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nduve ca tyiñu cuví javaha tsi. Ndi ña cuví jatyinyee tsi tsi ñuhu. Tan javitá yo itsi tyin ña vaha ca tsi. Nyooho tsa iyó soho, tya̱a soho ndo tuhun caahán yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tandɨhɨ ra tavá xuhun cuenda ra ndacá ñaha nda ñu Roma, tan ra iyó cuatyi naha ra, natuhva̱ ra naha nu nyií ra Jesús, tan tyaá soho ra naha tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tacan tan ra fariseo naha ra tsihin ra maestro cuenda ley vehe ñuhu naha ra quitsaha̱ caahán nyaa ra naha tsi ra Jesús, tan catyí ra naha: ―Ra ihya, caahán ra tsihin ra iyó cuatyi naha ra. Tan tsatsí ra tsihin ra naha ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tacan tan ra Jesús tsaha̱ cuenda ra cuhva ihya, tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Nyooho tsa iyó iin cientu mbee jana, tun cunaa intuhun tɨ, ¿a ña cua nacoo ndo tsi tandɨhɨ ca tɨ, tan cunanducu ndo tsi mbee tsa cunaa can nda cuanda tsa nañihi ndo tsi tɨ? ");
INSERT INTO mjcNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tan tsa yaha nañihi ndo tsi tɨ, tyiso soco ndo tsi tɨ. Tan sɨɨ xaan cua cuñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tan tsa tsaa nyico ndo vehe ndo, tan ndu iín ndo tsihin ra vaha iñi tsi ndo tan tsihin nyɨvɨ iyó yatyin yuvehe ndo, tacan tan catyí ndo tsihin ñi tyin na cusɨɨ ndɨhɨ iñi ñi tsihin ndo tyin nañihi̱ ndo mbee jana ndo tsa tsinaa̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tan catyí yu tsihin ndo, tyin tacan tucu sɨɨ xaan ca cuñí ángel Nyoo tsa iyó gloria tsacatyi intuhun ra tsa iyó cuatyi tan nasamá ra cuhva iyó ra, tan ñavin ca tsa cumi xico tsahun cumi taahan nyɨvɨ tsa nduve cuatyi tan ña cuñí ca tsi tsa nasama ñi cuhva iyó ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Tan catyí yu tsihin ndo, tyin tatun iin ñaha tan iyó utsi taahan xuhun ña, tan cuanaá iin xuhun ña, cua tyaa ña iin candili. Tan cua tɨhvɨ ña tanɨɨ tsitsi vehe ña. Tan cua nanducu ña xuhun can nda cuanda tsa nañihi ña can. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tan tsa yaha nañihi ña, cua cuhun ña cunanducu ña tsi ñi vaha iñi tsi ña, tsihin nyɨvɨ tsa iyó yatyin yuvehe ña, tan cua cahan ña tsihin ñi: “Cu̱sɨɨ ndɨhɨ iñi ndo tsihin yu tyin tsa nañihi̱ yu xuhun yu tsa tsinaa̱”, cua catyi ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tan catyí yu tsihin ndo tyin tacan tucu sɨɨ cuñí ángel Nyoo tsacatyi intuhun ra iyó cuatyi tan ndu uvi iñi ra cuatyi ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tacan tan tsahá cuenda ra Jesús inga cuhva ihya tan catyí ra: ―Iin ra, iyó uvi taahan sehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tan ra tsa luhlu ca caahán ra tsihin jutu ra tyin na nacuhva ra tsa taahán tsi tsi ra. Tacan tan jutu ra natahvi̱ sava ra tsa tsii ra tan tsaha̱ ra tsi nduvi taahan sehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tan ña cuaha ñi quɨvɨ tan ra luhlu ican xico̱ ra tandɨhɨ maa tsa tsaha̱ jutu ra tsi ra. Tan jandu ii̱n ra xuhun ra, tan quihi̱n ra ityi, cuahán ra iin ñuu cañi xaan. Tan ndacan tsicoo̱ ra tan janaa̱ ra tandɨhɨ maa xuhun ra tsihin tusɨɨ iñi. Tan quiñi xaan icá ra tsicá nuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tacan tan tsaa̱ tama ityi nu iyó ra. Tan quitsaha̱ tsisocó ra tyin tandɨhɨ xuhun ra janaa̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tacan tan tsaha̱n ra tsinducu̱ ra tyiñu jaha ra tsihin iin ra ñuu ican. Tan ra can jacuhun ra tsi ra iin nu iyó quɨnɨ jana ra, tyin jaha cuenda ra tsi tɨ naha tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tan cuví tsi iin tsaha tsisocó xaan ra can. Tan nduve maa tsa catsi ra iyó, ndacua cuñí ra catsi ra tsa tsatsí quɨnɨ ican naha tɨ. Tan yoñi maa tsaha̱ tsa catsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tacan tan nducuhu̱n iñi ra tsi jutu ra. Tan nacañí jiñi ra: “¿Náa tsa cuaha ra naha jahá tyiñu tsihin jutu yo? Tan nduve tsa cumañi tsi ra naha. Tan yoo vityin cuñí cúu yo jahá soco. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Vityin cua cunuhu yo nu nyaá jutu yo. Tan cua catyi yo tsihin ra tyin tsicoo̱ cuatyi yo nuu Nyoo tan tacan tucu nuu maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tan ña taahán ca tsi tsi yo tsa cuví yo sehe ra, tan na jaha ra tyin iin musu ña ra cuvi tsi yo” cuñí ra tsicá iñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Tacan tan quihi̱n ra ityi cuanuhu̱ ra nda vehe jutu ra. Tan cañi ca vatsí ra tan nyehe̱ jutu ra tsi ra, tan cundaahvi iñi ra nyehé ra tsi sehe ra. Tan tsinu̱ xaan ra tsijataha̱n ra tsi ra. Tan tsinumi̱ nyaa ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tacan tan catyí ra tsihin jutu ra: “Tyatya, tsicoo̱ cuatyi yu nuu Nyoo tan tsicoo̱ cuatyi yu nuu tucu maa un. Tan yacan ña taahán ca tsi tsi yu tsa cuví yu sehe un”, catyí ra tsihin jutu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Maa tyin jutu ra tava̱ tyiñu ra, tan catyí ra tsihin musu ra: “Ta̱va ndo jahma vaha tan ja̱cunditsi ndo tsi ra ihya. Tan tyi̱hi ndo iin xehe nundaha ra. Tan tyihi ndɨhɨ ndo zapatu tsaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tan ca̱hñi ndo iin becerru tsa xaahan vaha ca, tyin catsi yo tsi tɨ. Tyin vityin cua coo yo vico. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tyin ra sehe yu ihya tsa tsihi̱ ra cuñi̱ maa yu, tsica̱ iñi yu. Cuñí maa yu tyin ña cua nyehe ca yu tsi ra, tan tsaa̱ nyico ra”, catyí jutu ra can. Tacan tan quitsaha̱ tsicoo̱ ñi vico. Tan sɨɨ xaan cuñí ñi tyin tsaa̱ nuhu nyico ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Tacan tan inga sehe ra, ra tsa tsitsa, nyií ra tsicuhu. Tan tsa cua tsaa nuhu ra nda yuvehe ra, tan tsiñi̱ ra tyin iyó yaa. Tan tuvi̱ iñi ra tyin tsañí ñi yaa. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tacan tan tsa cuyatyin ra nda yuvehe ra tan cana̱ ra tsi iin musu ra. Tan tsica̱ tuhun ra tsi ra can náa cuví xaan can. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tacan tan musu can catyí ra: “Ra yañi un tsaa̱ nuhu ra. Tan yacan tava̱ jutu un tyiñu tyin na cahñi ra naha iin becerru xaahan. Tyin vaha tsaa̱ ra yañi un, tan nduve náa taha̱n ra”, catyí musu can tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tacan tan nduxaa̱n xaan cuñí ra can. Tan ña cuñí ra quɨhvɨ ra tsitsi vehe. Tan jutu ra tsaha̱n ra tsicaha̱n ndaahvi ra tsihin ra, tyin na quɨhvɨ ra tsitsi vehe. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tacan tan nacaha̱n ra can tan catyí ra tsihin jutu ra: “¿Náa tsa cuaha cuiya jahá tyiñu yu tsihin un? Tan tyaá yahvi xaan yu tsa caahán un. Maa tyin ndi intuhun mbee luhlu ñaha ca cuhva un tsi yu tyin coo vico jaha yu tsihin ra vaha iñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Maa tyin vityin tsaa̱ nuhu nu sehe un ihya, nu tsa janaa̱ xuhun tsihin ñaha sɨɨ iñi. Tan tsaha̱ un iin becerru quɨtɨ xaahan tsi nu”, catyí ra tsihin jutu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tacan tan nacaha̱n jutu ra tan catyí ra tsihin ra: “Sehe yu, yooho tsihin maa yu nyaá un tandɨhɨ quɨvɨ. Tan tandɨhɨ tsa cumí yu, tsii un cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tan vityin taahán tsi tyin javaha yo vico ihya, tan cusɨɨ iñi yo. Tyin tsaa̱ nuhu ra yañi un, ra tsa tsihi̱, cuñi̱ maa yu. Tumaa tsa nandoto̱ nyico ra cuví can, tyin tsinaa̱ ra, tan nañihi̱ yo tsi ra inga tsaha”, catyí ra tsihin sehe ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tacan tan catyí ra Jesús tsihin ra tsicá tsihin ra: ―Iyó iin ra, cuca xaan ra. Tan iyó iin ra yɨhɨ́ ndaha tandɨhɨ tyiñu jahá ra cuca can. Tan tsaha̱n iin musu ra tsicatyi̱ tuhun ra tsihin ra cuca ican, tyin ra yɨhɨ́ ndaha tyiñu ican, janaá ra tandɨhɨ tsa iyó tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tacan tan cana̱ ra cuca ican tsi ra tan catyí ra tsihin ra: “Tsa cuaha xaan cuatyi javahá un quitsi̱ nu nyaá yu. Vaha ca na̱cuhva cuenda un tandɨhɨ tyiñu tsa javahá un tsi yu. Tyin ña cua jaha tyiñu ca un tsihin yu”, catyí ra cuca can tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tacan tan ra yɨhɨ́ ndaha tyiñu can tsicá iñi ra: “¿Nacaa cua javaha yu vityin? Tsitoho yu ña cuñí ca ra tsa jaha tyiñu yu tsihin ra. Tan nduve tunyee iñi iyó tsi yu tsa jaha tyiñu yu tsihin ñuhu. Tan cahán xaan nuu yu caya yu tsitsi ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Maa tyin tsa tsitó yu nácaa cua javaha yu, tacan tan vaha cua cuñi nyɨvɨ tsihin yu quɨvɨ tsa nduve ca tyiñu cua jaha yu, tan vaha cua tsaa yu vehe ñi”, tsicá iñi ra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tacan tan cana̱ ra tsi intuhun intuhun ra tsa nyaá cuenda tsi tsitoho ra. Tan catyí ra tsihin iin ra ican: “¿Náa nyaá cuenda un tsi tsitoho yu?” catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tacan tan nacaha̱n ra ican tan catyí ra: “Yuhu nyaá cuenda yu cumi mil litru acetye.” Tacan tan ra yɨhɨ́ ndaha tyiñu ican catyí ra tsihin ra: “Qu̱ihin un inga tutu ihya. Tan tya̱a un uvi mil ñi. Tan ja̱vita un tutu tsaahnu ican”, catyí ra. Tacan ica̱ ra can, tan cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tacan tan tsaa̱ inga ra. Tan tsicá tuhun tucu ra tsi ra ican: “¿Náa nyaá cuenda un tsi tsitoho yu?” Tan nacaha̱n ra ican: “Nyaá cuenda yu iin mil arroba trigu”, catyí ra. Tacan tan catyí ra yɨhɨ́ ndaha tyiñu ican: “Qu̱ihin inga tutu, tan tya̱a un una cientu ñi arroba. Tan ja̱vita un tutu tsaahnu can”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tacan tan tsito̱ tsitoho ra tsa ña vaha tsa javaha̱ ra. Tan iyo xaan cuñí ra cuca can, tyin yatyi xaan ñihi̱ ra cuhva ica ra ―catyí ra Jesús. Tan catyí ra tsihin ra tsicá tsihin ra: ―Nyɨvɨ nu ñuhu ñayɨvɨ ihya tsa ña tyaá yahvi tsi Nyoo yatyi xaan ca jahá ñi tsi ñi tan ñavin ca nyɨvɨ tsa iyó ñuhu̱ nditsin Nyoo añima. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Tan catyí yu tsihin ndo, tyin cuatyiñu ndo tsa cuca tsa iyó nu ñuhu ñayɨvɨ ihya, tan jatyinyee ndo tsi nyɨvɨ. Tan quɨvɨ tsa cua ndɨhɨ tsa cuca, cua ñihi ndo coo ndo nu ña cua naa maa. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Tatun tsitó ndo cuatyiñu vaha ndo tsa luxu ñi tsa iyó tsi ndo, tacan tucu tatun cuaha coo tsi ndo cua cuatyiñu vaha ndo itsi. Tyin tatun ña tsitó ndo cuatyiñu ndo tsa luxu ñi tsa iyó tsi ndo, tacan ña cua coto tucu ndo cuatyiñu ndo tatun cuaha coo tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tan catyí yu tsihin ndo, tatun ña javahá ndo tsa vaha tsihin tsa iyó tsi ndo nu ñuhu ñayɨvɨ ihya, Nyoo ña cua cuhva ra tsa vaha tsa iyó gloria tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tyin tandɨhɨ tsa iyó tsi ndo, maa Nyoo tsaha̱ nuu itsi tsi ndo. Tan tatun ña javahá ndo tumañi iñi tsihin tsi, ña cua cuhva ra tsa cuvi tsii ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Iin musu ña cuví coo uvi taahan tsitoho ra. Tyin musu ican cua cuñi ca ra tsi iin ra, tan ñavin ca tsi inga ra. Tan vaha ca cua tyaa yahvi ra tsa cahan iin ra, tan inga ra, ña cua tyaa yahvi ra tsa cahan ra can. Ña cua cuvi cuñi ndo tsi Nyoo tatun cuñi tucu ndo tsa cuca ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tan tsa tsiñi̱ ra fariseo naha ra tandɨhɨ tsa caha̱n ra Jesús, tacan tan quitsaha̱ tsacú nducu ra naha tsi ra. Tyin maa ra fariseo naha ra cuñí xaan ra naha xuhun. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tacan tan catyí ra Jesús tsihin ra naha: ―Vaha xaan jahá maa ndo tsi ndo nuu nyɨvɨ. Maa tyin tsa tsitó Nyoo tyin ña vaha añima ndo. Tandɨhɨ tsa cahnu cuñí maa nyɨvɨ, Nyoo ña cuñí ra nyehe ra yacan. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Ley tsa tsaha̱ Nyoo tsi ra Moisés tyin tyaa ra, tan tsihin tuhun tsa tyaa̱ ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha, yacan cuví tsa janaha̱ ityi tsi nyɨvɨ nda cuanda quɨvɨ tsa quitsi̱ ra Juan. Tan ra Juan quitsaha̱ caahán ra tuhun vaha tyin tsa cuñí quitsi Nyoo tyin cua cundaca ñaha ra. Tan tandɨhɨ nyɨvɨ nducú xaan ñi cuhva tsa quɨhvɨ ñi nu ndacá ñaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Tan catyí yu tsihin ndo, tyin vasu cunaa andɨvɨ tan nu ñuhu ñayɨvɨ ihya, maa tyin tsa cuví ley Nyoo tsa tyaa̱ ra Moisés, ña cua cunaa tsi tyin cua cundaa tandɨhɨ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Tatun iin rayɨɨ tan iyó ñasɨɨhɨ ra, tan nacoo ihñi ra tsi ña, tan tindaha ra tsihin inga ñaha, coo cuatyi ra nuu Nyoo. Tan tatun tindaha inga rayɨɨ tsihin ñaha tsa nacoo yɨɨ, coo tucu cuatyi ra can nuu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Tsicoo̱ iin ra cuca. Tan vaha xaan jahma tsinditsi̱ ra. Tan tandɨhɨ quɨvɨ iyó vico jahá ra tan tsatsí vaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tan tsicoo̱ tucu iin ra ndaahvi tsa tsinañi̱ Lázaro. Tan ra ihya cuaha xaan ndɨhyɨ iñí tsi ra. Tan nyaá ra yuvehe ra cuca ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ra ndaahvi can, cuñí ra catsi ra, vasu tsa cucoyó xuu mesa ra cuca can. Tan nda cuanda ina tan tsaá tɨ naha tɨ nu nyaá ra, tan tsacayaá tɨ nu uhvi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tan iin quɨvɨ tsihi̱ ra ndaahvi can. Tan ángel maa Nyoo na quihi̱n tsi ra tan tsindaca̱ ra naha tsi ra nda nu nyaá ra Abraham gloria. Tacan tan tsihi̱ tucu ra cuca can. Tan tsicutsi̱ ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tacan tan ra cuca ican nyehé xaan ra tundoho nu nyií ra anyaya. Tan nanyehe̱ ra nu cañi xaan nu nyaá ra Abraham tsihin ra Lázaro. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tacan tan cana̱ tsaa ra cuca can tan catyí ra: “Tyatya Abraham, cu̱ndaahvi iñi tsi yu. Ja̱quitsi tsi ra Lázaro tan na jatyii ra luxu nundaha ra. Tan na jatoo ra ndutya nu yaa yu. Tyin nyehé xaan yu tundoho nu cayú ñuhu̱ ihya”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tan ra Abraham catyí ra tsihin ra: “Ndu̱cuhun iñi tyin vaha xaan tsicoo̱ un nu ñuhu ñayɨvɨ. Tan ra Lázaro, tuhun ndaahvi tsicoo̱ ra. Tan vityin vaha iyó ra ihya, tan yooho nyehé un tundoho. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tan inga tucu tuhun, tyin mahñu nu yucú yo ihya cunu xaan xahva. Tan ra yucú nyehe ña cuví cuhun ra naha nu nyií un. Tan ndi ra yucú nu nyií un, ña cuví quitsi ra naha nyehe”, catyí ra Abraham tsihin ra cuca can. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tacan tan catyí ra cuca ican: “Tyatya Abraham, ja̱ha tumañi iñi tsi yu. Ja̱cuhun tsi ra Lázaro nda vehe jutu yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tyin iyó uhun taahan ca ra yañi yu naha ra. Tan cuñí yu tyin catyi tuhun ra Lázaro tsihin ra naha nácaa nyií yu nyehé yu tundoho ihya, coto quitsi ndɨhɨ ra naha ihya”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tacan tan catyí ra Abraham: “Iyó ley tsa tyaa̱ ra Moisés. Tan iyó tuhun tsa tyaa̱ ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Na tyaa yahvi ra yañi un naha ra, tun cuñi ra naha”, catyí ra Abraham. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tacan tan catyí ra cuca ican: “Tyatya Abraham. Ña cua tyaa yahvi ra naha. Maa tyin tatun yóo tsa nandoto̱, tan cuhun cucahan tsihin ra naha, tacan tan cua tyaa soho ra naha tan cua nasama ra naha cuhva iyó ra naha”, catyí ra cuca ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tan ra Abraham catyí ra: “Tatun ña cuñí ra naha tyaa yahvi ra naha tuhun tsa tyaa̱ ra Moisés tan tuhun tsa tyaa̱ ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha, vasu ndi maa nandoto iin nyɨvɨ tan cahan ñi tsihin ra naha ña cua tsinu iñi ra naha.” ");
INSERT INTO mjcNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tyehen catyí ra Jesús tsihin ra tsicá tsihin ra: ―Tacan ñi iyó tsa quiñi caá tsa jatɨvɨ́ tsi nyɨvɨ. Maa tyin ndahvi ra ndaahvi tsa jatɨvɨ́ tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vaha taxin ca na cunuhñi iin yuu jucun ra, tan jacuhun nyɨvɨ tsi ra nu ndutya ñuhu. Coto jatɨvɨ ca ra tsi nyɨvɨ ndi nasama cuhva iyó. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Ja̱ha vaha ndo cuenda tsi ndo. Tatun iin ra cutahán tsihin ndo tan javaha ra tsa ña vaha tsihin ndo, ca̱han ndo tsihin ra tyin ña vaha tsa javaha̱ ra. Tun nasama ra cuhva iyó ra, ja̱ha ndo tucahnu iñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tan ndi maa javaha ra tsa ña vaha tsihin ndo utsa tsaha tsa iin quɨvɨ, tatun tandɨhɨ tsa utsa tsaha tan catyí ra tsihin ndo tyin ndu uvi iñi ra tsa javaha̱ ra; tandɨhɨ tsa utsa taahan tsaha can, ja̱ha ndo tucahnu iñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tacan tan catyí ra tava̱ tyiñu ra Jesús tsihin ra: ―Cu̱hva tsa tsinu ca iñi ndi tsi un ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tan catyí ra Jesús tsihin ra naha: ―Tatun tsinú iñi ndo tsi yu vasu tumaa cuhva iin tsɨtɨ mostaza tsa luhlu cuii ñi tsi, cua cahan ndo tsihin yutun cahnu tsa nañí sicómoro tsa nyaá ihya: “Na tuhun tsi un, tan cunyaa un nda nu ndutya ñuhu.” Tan cua tyaa yahvi tun tsa cua cahan ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tan catyí ra Jesús: ―Tatun iin nyooho tan iyó iin musu ndo, tan tsaa ra tsa tsaha̱n ra tsicuhu tsijaha̱ tyiñu ra, a tsijaha̱ cuenda ra quɨtɨ jana ndo, ¿a catyí ndo tsihin ra: “Cu̱nyaa tan catsi un”? Ña tuhvá ndo cahan tacan tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Maa tyin tyehen tuhvá ndo caahán tsihin ra: “Ja̱vaha tsa cuxiñi yu. Tan tyi̱hi un tsa catsi yu. Tsa yaha tsa catsi yu, tacan tan catsi tucu maa un”, tacan tuhvá ndo caahán tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ndi ña tuhvá ndo nacuhvá tyahvi nyoo tsi ra tyin javaha̱ ra náa tyiñu tava̱ ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tacan tucu maa ndo tsihin Nyoo. Quɨvɨ ndɨhɨ javaha ndo tandɨhɨ tsa caha̱n ra tsihin ndo, taahán tsi catyi ndo tsihin ra: “Nyuhu nduve náa ca tyiñu cuaha xaan javaha̱ ndi. Tyiñu tsa tava̱ ñi un tsi ndi, yacan ñi javaha̱ ndi. Tan ña yaha ca javaha̱ ndi.” ");
INSERT INTO mjcNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Cuahán ra Jesús ityi ñuu Jerusalén tan yaha̱ ra nu cuví xahñu Samaria tsihin Galilea. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tan nu tsaa̱ ra iin ñuu, quita̱ utsi taahan ra cuuhví tsihin cuehe tyaahyú. Tan tsicuɨñɨ̱ ra naha ndasava. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tan cana̱ tsaa ra naha tan catyí ra naha: ―Yooho, Maestro Jesús, cu̱ndaahvi iñi tsi ndi ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tan tsa nyehe̱ ra Jesús tsi ra naha tan catyí ra tsihin ra naha: ―Cu̱aahan ndo, cujanaha ndo tsi ndo tsi ra jutu tyin tsa nduvaha̱ ndo. Tacan tan cuahán ra naha. Tan ityi cuahán ra naha tan nduvaha̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tacan tan tsa nyehe̱ iin ra ican tyin tsa nduvaha̱ ra, vatsí tsihin tsata nyico ra nu nyií ra Jesús. Tan quitsaha̱ caná tsaa ra, jacahnú ra tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tan tsa tsaa̱ ra nu nyií ra Jesús, tsicuɨñɨ̱ tsɨtɨ ra, tan nacañi̱ nuu ra jiñi ra nda nu ñuhu nuu ra Jesús. Tan nacuhva̱ ra tyahvi nyoo tsi ra. Ra tsa nduvaha̱ ihya, ra Samaria cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tacan tan catyí ra Jesús: ―¿A ñavin utsi taahan ndo nduvaha̱? ¿Náa inga ɨɨn taahan ca ra naha? ");
INSERT INTO mjcNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿A intuhun ñi maa ra inga ñuu ihya vatsí, vatsí jacahnú tsi Nyoo? ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tacan tan catyí ra tsihin ra tsa nduvaha̱ ican: ―Ndu̱vita, cu̱aahan. Nduvaha̱ un tyin tsinú iñi un tsi Nyoo ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tsica̱ tuhun ra fariseo naha ra tsi ra Jesús, tan catyí ra naha: ―¿Ama cua quitsi Nyoo cua cundaca ñaha ra? Tacan tan catyí ra Jesús: ―Ñavin tsa nyehé yo cuví tsa ndacá ñaha Nyoo ihya nu ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ña cua cuvi catyi nyɨvɨ: “Juvin ra nyií ihya, juvin ra nyií ityi ican.” Tyin Nyoo tsa tsaa̱ ra mahñu ndo, tan ndacá ñaha ra tsi nyɨvɨ yɨhɨ́ cuenda ra ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yaha̱ yacan tan catyí ra tsihin ra tsicá tsihin ra: ―Cua tsaa quɨvɨ tsa cua cuñi ndo nyehe ndo tsi yuhu Rayɨɨ quee̱ nda gloria. Maa tyin ña cua nyehe ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yɨhɨ ñi cua catyi ñi tsihin ndo: “Ihya nyií ra.” Inga ñi cua catyi ñi: “Ndacan nyií ra.” Maa tyin coto cuhun ndo cunyehe ndo. Tan ña cunyicun ndo tsi ra can tyin ñavin yu cuvi can. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tyin tandɨhɨ nyɨvɨ cua nyehe tsi yuhu, Rayɨɨ tsa quee̱ nda gloria, quɨvɨ cua quitsi nyico yu inga tsaha. Tumaa tsa nyehé tandɨhɨ nyɨvɨ nu cañi tatsa savi tan quituvi ñuhu̱ tatsa can nɨɨ canduvi andɨvɨ, tacan cua cuvi quɨvɨ cua quitsi yu inga tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Maa tyin cua nyehe jihna yu tundoho cahnu xaan. Tyin nyɨvɨ tsa iyó vityin, ndasɨ cua cuñi ñi nyehe ñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tumaa quɨvɨ tsa tsicoo̱ ra Noé, tacan cua cuvi quɨvɨ cua quitsi nyico yuhu Rayɨɨ quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Quɨvɨ tsicoo̱ ra Noé, tsatsí nyɨvɨ. Tsihí ñi. Tindahá ñi. Tan tsaha̱ ñi sehe sɨɨhɨ ñi tindaha, nda cuanda quɨvɨ quɨhvɨ̱ ra Noé tsitsi yutun ndoo tan cuu̱n savi xaan. Tan tandɨhɨ ñi can tsihi̱ ñi jaha̱ ndutya. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tacan tucu cuvi̱ quɨvɨ tsicoo̱ ra Lot. Tsatsí ñi. Tsihí ñi. Jatá ñi. Xicó ñi. Tatsí ñi itu. Tan javahá ñi vehe ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tan quɨvɨ tsa quita̱ ra Lot ñuu Sodoma ican, cuu̱n ñuhu̱ tsihin azufre tsa quee̱ nda andɨvɨ. Tan tsahñi̱ ñuhu can tandɨhɨ nyɨvɨ Sodoma. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tacan cua cuvi quɨvɨ quitsi nyico yu tsa cuví yu Rayɨɨ quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Tatun nyecú ndo nuquehe quɨvɨ quitsi yu, ña quɨhvɨ ndo tsitsi vehe tan tava ndo ndaha tyiñu ndo. Tan tatun yucú ndo tsitsi cuhu, ña cunuhu ca ndo yuvehe ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ndu̱cuhun iñi ndo tsa taha̱n ñasɨɨhɨ ra Lot. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tandɨhɨ nyooho tsa cuñí tsa iyó nu ñuhu ñayɨvɨ ihya, cua cunaa ndo. Tan tandɨhɨ nyooho tsa ña tyaá yahvi tsa iyó nu ñuhu ñayɨvɨ ihya, cua cacu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Tan catyí yu tsihin ndo tyin tsacuaa can, uvi taahan nyɨvɨ cua cava iin nu tsito. Iin ñi cua naquihin yu. Tan inga ñi cua ndoo ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tan uvi taahan ñiñaha, iin caa ñi cua nyico ñi quɨvɨ can. Intuhun ña cua naquihin yu. Tan inga ña cua ndoo ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tan catyí yu tsihin ndo tyin uvi taahan ra cua cuyucu tsicuhu. Intuhun ra cua naquihin yu, tan inga ra cua ndoo ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tsa tsiñi̱ ra naha tsa caha̱n ra Jesús tacan, tsica̱ tuhun ra naha tsi ra: ―¿Numaa tahan cua cuvi yacan, Jutu Mañi yu? ―catyí ra naha. Tacan tan nacaha̱n ra Jesús, tan catyí ra: ―Nu canyií ndɨyɨ, ican cua nataca nditsii. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tsahá cuenda ra Jesús iin cuhva ihya. Tyin iin nyita ñi cuñí tsi tsa ndacan tahvi ra naha tan ña cundɨhɨ iñi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tan catyí ra: ―Iyó iin ñuu tsa nyaá iin ra cuví juez. Tan juez ican ña tyaá yahvi maa ra tsi Nyoo. Tan ndi nyɨvɨ tan ña tyaá yahvi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tan juvin ñuu ican iyó iin ñaha ndaahvi tsa tsihi̱ yɨɨ. Tan tsaahán ña tsicahán ña tsihin ra can, tyin tsicán ña cuatyi tsaha iin nu xaan iñi tsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tan juez ican ña tyaá yahvi nu tsa caahán ña. Ña jandaa̱ maa nu tyiñu tsicán ña. Tan tsanaha xaan tsicán ña. Tacan tan quitsaha̱ tsicá iñi nu juez can: “Vasu ndi maa ña tsinú iñi yu tsi Nyoo, tan nduve náa cuenda yu tsi nyɨvɨ, ");
INSERT INTO mjcNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","maa tyin ñaha ihya tsahá xaan ña tɨsɨhɨ tsi yu. Tan yacan cuenda vaha ca cua jacacu yu tsi ña. Tyin coto ña jaña ña tsa vatsí ña, tan cuhva ca ña tɨsɨhɨ tsi yu”, cuñí ra tsicá iñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tacan tan catyí Jutu Mañi yo, ra Jesús: ―Tacan catyi̱ ra juez caquiñi can. Ra juez can ra caquiñi xaan cuví ra maa tyin jatyinyee̱ ra tsi ñaha ndaahvi ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tan vihi ca cuví Nyoo tsihin yo, ¿a ña cua jatyinyee ra tsi nyɨvɨ tsa nacatsi̱ ra tsa tsicán ñi tsi ra nduvi tan ñiñu? ¿A cuatu xaan ca ra tan jatyinyee ra tsi ñi? ");
INSERT INTO mjcNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Catyí yu tsihin ndo, tyin numi ca cua jatyinyee ra tsi ñi. Maa tyin quɨvɨ tsa cua quitsi nyico yu tsa cuví yu Rayɨɨ tsa quee̱ nda gloria, tsitó Nyoo tun nañihi ca yu tsi nyɨvɨ tsa tsinú tsa cuii iñi tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tacan tan tsaha̱ cuenda ra Jesús iin cuhva cuenda ra tsa vaha xaan jahá tsi maa ra naha, tan ndasɨ cuñí ra naha nyehé ra tsi inga nyɨvɨ. Tan catyí ra: ");
INSERT INTO mjcNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Iyó uvi taahan ra cuahán vehe ñuhu cua ndacan tahvi ra naha tsi Nyoo. Iin ra ican ra fariseo cuví ra. Tan inga ra can ra tavá xuhun cuenda ra ndacá ñaha nda ñuu Roma cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tan ra fariseo ican nduvita̱ nyityi ra, tan quitsaha̱ caahán ra tsihin Nyoo. Tan catyí ra: “Jutu Mañi yu, nacuhvá yu tyahvi nyoo tsi un tyin yuhu ñavin tumaa inga nyɨvɨ cuví yu. Tyin iyó ñi suhú ñi. Quiñi icá ñi. Tan yɨhɨ́ ra naha iyó ñasɨɨhɨ ra tan iyó inga ñaha ra naha. Tan ña cuví yu tumaa ra tavá xuhun ihya. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tyin yuhu uvi tsaha tsicoó nyitya yu tsa iin vitya. Tan tsahá yu utsi taahan xuhun tsa iin iin cientu tsa jahá canaa yu tsi un”, catyí ra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tan ra tsa tavá xuhun can tsa cañi luxu nyaá ra. Tan ña cana̱ iñi ra nanyehe ndaa ra. Tan cañí ndaha ra yɨquɨ nyica ra tyin ndu uví iñi ra cuatyi ra. Tan catyí ra: “Jutu Mañi yu, cu̱ndaahvi iñi tsi yu tyin cuaha xaan cuatyi yu iyó”, catyí ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tan catyí nyico ra Jesús tyehen: ―Catyí yu tsihin ndo tyin Nyoo jaha̱ ra tucahnu iñi tsi ra tavá xuhun ican. Janaa̱ Nyoo cuatyi ra tan cuanuhu̱ ra nda yuvehe ra. Maa tyin ra fariseo ican, nduve tucahnu iñi tsicoo̱ tsi ra, tyin nyɨvɨ tsa cahnu xaan jahá ñi tsi ñi, ña cahnu cuví ñi jahá Nyoo, tan nyɨvɨ tsa ndaahvi jahá tsi, cua jacahnu Nyoo tsi ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tacan tan quitsi̱ ndaca nyɨvɨ tsa nyihi tsi ra Jesús tyin tyiso ndaha ra jiñi tsi naha tsi. Maa tyin cuhva tsa nanyehe̱ ra tsicá tsihin ra tyin cuaha tsa nyihi tsaá nu nyaá ra, cuxaan ra naha tan ña tsaha̱ ra naha cuhun tsa nyihi can. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tacan tan cana̱ ra Jesús tsi ra naha, tan catyí ra tsihin ra naha: ―Ja̱ña ndo na quitsi maa tsi naha tsi nu nyaá yu. Tan ña casɨ ndo. Tyin nyɨvɨ tsa ndacá ñaha Nyoo, cuví ñi tumaa tsa nyihi ihya. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tan catyí yu tsihin ndo tyin tatun ña nyitá iñi ndo tsi Nyoo, tumaa nyitá iñi iin tsa luhlu ihya tsi jutu tsi, ña cua cuvi quɨhvɨ ndo nu ndacá ñaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tacan tan iin ra tsa cuví ityi nuu cuenda vehe ñuhu tsica̱ tuhun ra tsi ra Jesús, tan catyí ra: ―Maestro, ra vaha cuví un. ¿Nacaa cua javaha yu tan coo yu ñayɨvɨ tsa ña cua naa maa? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tacan tan catyí ra Jesús tsihin ra: ―¿Nacuenda catyí un tyin ra vaha cuví yu? Tan intuhun ñi maa Nyoo cuví ra vaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yooho tsitó un tandɨhɨ tuhun tsa tsaha̱ Nyoo tyin javaha yo: “Tsa ña coo inga ñaha tsi un. Ña cahñi un nyɨvɨ. Ña suhu un. Ña cahan un cuendu sɨquɨ nyɨvɨ. Tan tyaa yahvi un tsi jutu un tan sɨhɨ un” ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tacan tan ra ican catyí ra: ―Tandɨhɨ maa yacan tan tyaá yahvi yu nda taha̱n luhlu yu tan nda cuanda vityin ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tsa tsiñi̱ ra Jesús tsa caha̱n ra can, tacan tan catyí ra tsihin ra: ―Maa tyin cumañi javaha un inga tsa taahán tsi javaha yo. Xi̱co tandɨhɨ tsa iyó tsi un. Tan cuhva un xuhun can tsi nyɨvɨ ndaahvi. Tan quitsi nyicun un tsi yu. Tacan tan coo tsa cuca tsi un nda gloria ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Maa tyin tsa tsiñi̱ ra tsa caha̱n ra Jesús, nducuiihya xaan cuñí ra, tyin cuca xaan ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tan tsa nyehe̱ ra Jesús tyin nducuiihya̱ cuñí ra, tan catyí ra: ―Yɨɨ xaan tan cuví nacuhva cuenda nyɨvɨ cuca tsi ñi na cundaca ñaha Nyoo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yatyi xaan ca cuvi yaha iin camellu xuu iin yɨquɨ tucu, tan ñavin ca tsa quɨhvɨ iin nyɨvɨ cuca nu ndacá ñaha Nyoo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tan nyɨvɨ tsa tsiñi̱ tsa caha̱n ra catyí ñi: ―Tatun tacan, ¿yóo cua cuvi cacu? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tacan tan ra Jesús catyí ra: ―Tandɨhɨ tsa ña cuví javahá nyɨvɨ, Nyoo cuví javahá ra tandɨhɨ ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tacan tan ra Pedro catyí ra: ―Jutu Mañi yu, nyuhu tandɨhɨ maa tsa iyó tsi ndi nacoo̱ ndi, tan nyicún ndi tsi un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tacan tan catyí ra Jesús tsihin ra: ―Tsa nditsa catyí yu tsihin ndo, tyin tandɨhɨ nyooho tsa nacoo̱ vehe, a ñasɨɨhɨ ndo, a yañi ndo, a jutu ndo, a sehe ndo tsacatyi tsa tsahá ndo tsa cundaca ñaha Nyoo tsi ndo, ");
INSERT INTO mjcNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","cuaha xaan tsa vaha cua ñihi ndo ñuu ñayɨvɨ ihya tan inga ñayɨvɨ tsa cua coo, cua ñihi ndo ñayɨvɨ tsa ña cua naa maa ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tan cana̱ sɨɨn ra Jesús tsi tsa utsi uvi taahan ra tsicá tsihin ra, tan catyí ra tsihin ra naha: ―Vityin cuhun yo nda ñuu Jerusalén. Tyin ndacan cua cundaa tyiñu Rayɨɨ tsa quee̱ nda gloria: tandɨhɨ tyiñu tsa tyaa̱ ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tyin ra xaan iñi tsi yu naha ra cua nacuhva cuenda ra naha tsi yu tsi ra inga ñuu, ra tsa ñavin ra ñuu Israel cuví. Tan cua vacu nducu ra naha tsi yu. Tan cua cahan nyaa ra naha tsi yu. Tan cua tɨvɨ sɨɨ ra naha nuu yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tan cua cañi ra naha tsi yu, tan cua cahñi ra naha tsi yu, maa tyin tsa tsinu uñi quɨvɨ tan cua nandoto yu inga tsaha ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Maa tyin ña cutuñí iñi ra tsicá tsihin ra tsa caha̱n ra, tan ndi ña tsitó ra naha náa tuhun caha̱n ra tsihin ra naha. Tyin ña cuví cutuñi iñi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Cuhva tsa cua tsaa ra Jesús ñuu Jericó, tan yuhu ityi ican nyaá iin ra cuaa, cayá ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tacan tan tsiñi̱ ra cuvaa tsa yahá cuaha nyɨvɨ. Tan tsica̱ tuhun ra náa cuenda ñihi xaan cuvaa. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tan catyí tuhun nyɨvɨ tsihin ra tyin ra Jesús, ra ñuu Nazaret, vatsí. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tacan tan quitsaha̱ caná tsaa ra tan catyí ra: ―¡Yooho Jesús, tata ra rey David! ¡Cu̱ndaahvi iñi tsi yu! ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tan ra tsa cuahán ityi nuu ican naha ra, catyí ra naha tsihin ra, nacasɨ ra yuhu ra. Maa tyin tsaa ca cana̱ tsaa ra, tan catyí ra: ―¡Yooho, tata ra rey David! ¡Cu̱ndaahvi iñi tsi yu! ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tacan tan tsicuɨñɨ̱ ra Jesús. Tan tava̱ tyiñu ra na cuhun ra naha cuquihin ra naha tsi ra. Tan cuhva tsa tsaa̱ ra nu nyaá ra Jesús, tan nducú tuhun ra Jesús tsi ra: ");
INSERT INTO mjcNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Náa cuñí un javaha yu tsihin un? Tacan tan ra cuaa ican nacaha̱n ra, tan catyí ra: ―Jutu Mañi yu, cuñí yu nanyehe yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tacan tan catyí ra Jesús tsihin ra: ―Na̱nyehe. Tsa nduvaha̱ tinuu un tyin tsinú iñi un tsi yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tan iin yaha ñi, nanyehe̱ ra cuaa can. Tan cueta cuahán ra nyicún ra tsi ra Jesús. Tan jacahnú ra tsi Nyoo. Tan tandɨhɨ nyɨvɨ tsa nyehe̱ tsa cuvi̱ can, jacahnú ndɨhɨ tucu maa ñi tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tacan tan quɨhvɨ̱ ra Jesús ñuu Jericó. Tan cua yaha ra tsitsi ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tan ñuu can iyó iin ra cuca xaan, nañí ra Zaqueo. Tan cuví ra ityi nuu tsihin ra tavá xuhun cuenda ra ndacá ñaha nda ñuu Roma. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ra ihya cuñí xaan ra nacoto ra tsi ra Jesús. Tan ña cuví nyehe ra tsi ra tyin cuaha xaan nyɨvɨ cuahan tsihin ra. Tan maa ra ndɨquɨ xaan ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tacan tan tsinú xaan ra cuahán ra ityi nuu, tan ndaa̱ ra iin nu yutun cahnu tsa nañí sicómoro tsa nyaá yuhu ityi nu cua yaha ra Jesús, tan cuví nyehe ra tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tan cuhva tsa quita̱ ra Jesús nu nyáá yutun can, nanyehe̱ ndaa ra ityi sɨquɨ tan nyehe̱ ra tsi ra Zaqueo. Tan catyí ra tsihin ra: ―Zaqueo, ja̱numi nu̱u un nu yutun juvin. Tyin vityin cuñí tsi tsa cuhun yu yuvehe un ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tacan tan numi xaan nuu̱ ra Zaqueo. Tan sɨɨ xaan cuñí ra. Tan quihi̱n ra tsi ra Jesús cuahán tsihin ra yuvehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tan tsa nyehe̱ nyɨvɨ tsa tacan cuvi̱, tandɨhɨ ñi quitsaha̱ caahán nyaa ñi tsi ra Jesús. Tan catyí ñi tyin ndoó ra vehe iin ra iyó cuatyi. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tan nu nyecú ra naha tsitsi vehe, ra Zaqueo tsinyaa̱ nyityi ra. Tan catyí ra tsihin ra Jesús: ―Jutu Mañi yu, yuhu cua cuhva yu sava tsa iyó tsi yu tsi nyɨvɨ ndaahvi. Tan tatun jandavi̱ ñaha yu tsi nyɨvɨ tan suhu̱ yu tsa tsii ñi, vityin cua nacuhva cuenda yu cumi taahan ca tsaha tsi ñi ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tacan tan catyí ra Jesús: ―Vityin cacu̱ un, tan nyɨvɨ ra Abraham cuví tsi un. Tyin nacuhva̱ cuenda un tsi un tsi Nyoo tumaa nacuhva̱ cuenda ra Abraham tsi ra tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tyin yuhu, Rayɨɨ tsa quee̱ nda gloria, vatsí yu vatsí nanducu yu tan vatsí jacacu yu tsi nyɨvɨ tsa cuanaa̱ maa ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tan tsitsi tsa tsiñí nyɨvɨ tsa caahán ra Jesús, tan quitsaha̱ tsahá cuenda ra inga cuhva ihya tsi ñi. Tyin tsa cuñí tsaa ra ñuu Jerusalén. Tan nyɨvɨ cuñí maa ñi tyin tsa cua quitsaha cundaca ñaha ra ndacan. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tacan tan catyí ra: ―Tsicoo̱ iin ra cuca tan tsa cuñí cuhun ra iin ñuu cañi. Tyin ndacan cua quihin cuenda ra tyiñu tsa cuvi ra rey, tyin tacan tan cua quitsi nuhu nyico ra ñuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tsa ndi cumañi ca cuhun ra, cana̱ ra utsi taahan musu ra. Tan tsaha̱ cuenda ra iin xuhun tsi iin iin ra naha. Tan catyí ra tsihin ra naha: “Ja̱ha tyiñu ndo tsihin xuhun ihya nda cuanda quitsi nyico yu”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Maa tyin nyɨvɨ ñuu ra, ndasɨ cuñí ñi nyehé ñi tsi ra tan ña cuñí ñi tsa cundaca ñaha ra tsi ñi. Tan jacuhu̱n ñi tsi ra cuhun cunyicun tsi ra, tyin cahan ra naha tyin ña cuñí ñi tsa cundaca ñaha ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Maa tyin ra ican cuvi̱ maa ra rey. Tacan tan tsaa̱ nyico ra nda ñuu ra. Tan quɨvɨ tsa tsaa̱ ra, cana̱ ra tsi musu ra, ra tsa nacoo̱ ra xuhun tsihin. Tyin cuñí ra coto ra nácaa xuhun jaha̱ canaa xuhun ra tsa nacoo̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tan tsaa̱ iin ra ican. Tan catyí ra: “Yooho taa, jaha̱ canaa yu utsi taahan ca sɨquɨ xuhun tsa nacoo̱ un tsi yu”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tacan tan catyí ra rey can tsihin ra: “Vaha xaan. Yooho cuví musu vaha. Tyin javaha̱ un ndɨhɨ tyiñu tsa tava̱ yu tsi un. Tan vityin cua cundaca ñaha un utsi taahan ñuu”, catyí ra rey can tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tacan tan tsaa̱ tucu inga ra tsa tsaha̱ ra xuhun. Tan catyí ra: “Ju̱hun xuhun ihya. Jaha̱ canaa yu uhun taahan ca sɨquɨ xuhun tsa nacoo̱ un tsi yu”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tacan tan catyí ra rey tsihin ra: “Yooho cua cundaca ñaha un uhun taahan ñuu”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tacan tan tsaa̱ tucu inga ra can. Tan catyí ra: “Ju̱hun xuhun tsa tsaha̱ un tsi yu. Yuhu naquihin vaha yu itsi tsitsi pañitu. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tyin yuuhví xaan yu tsi un, tyin yooho xaan xaan un. Tyin tuhvá un naquihin tsa ñavin tsa tatsi̱ un. Tan naquihín un ndaha tyiñu quita̱ nu jaha̱ tyiñu inga nyɨvɨ”, catyí ra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tacan tan ra rey ican catyí ra tsihin ra: “Yooho musu ña vaha cuví un. Vityin juvin ñi tsihin tsa caha̱n un tsi yu, cua cahan yu tsi un. Tatun tsitó un tyin yuhu xaan yu, tan tsitó un tyin naquihín yu tsa ña tatsi̱ yu, tan naquihín yu ndaha tyiñu inga nyɨvɨ, ");
INSERT INTO mjcNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿nacuvi tyin ña tsityihi̱ un xuhun yu banco tyin tsaa yu maa tyin tsa nandaa xuhun yu?” catyí ra rey can. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tan catyí ra tsihin ra nyecú ican: “Qu̱inyaa ndo xuhun tsa tsaha̱ yu tsi ra ihya, tan cu̱hva ndo tsi ra tsa jaha̱ canaa utsi taahan ca sɨquɨ tsa tsaha̱ yu tsi ra”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tacan tan catyí ra naha tsihin ra rey can: “Maa tyin ra ican, tsa iyó utsi taahan tsi ra”, catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tacan tan ra rey ican catyí ra: “Maa tyin catyí yu tsihin ndo tyin ra tsa vaha ca jaha̱ tyiñu tsihin tsa tsaha̱ yu tsi ra, cuaha ca cua cuhva yu tsi ra. Tan ra tsa tsaha̱ yu luxu ñi, tan ña cuñí ra jahá tyiñu ra tsihin tsi, cua quinyaa yu tandɨhɨ can tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tan tandɨhɨ nyɨvɨ xaan iñi tsi yu, ñi tsa ña cuñí tsa cundaca ñaha yu tsi ñi, nda̱ca ndo tsi ñi nyehe, tan cahñi ndo tsi ñi nuu yu ihya”, catyí ra rey can ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tsa yaha̱ caha̱n ra Jesús yacan, tan jañihi̱ ra cuahán ra ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tacan tan tsa cuñí tsaa ra ñuu Betfagé tsihin ñuu Betania, yatyin ñi iin yucu tsa nañí Olivo, tyin maa ñi maa yutun olivo iyó ican. Tava̱ tyiñu ra tsi uvi taahan ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Tan catyí ra tsihin ra naha: ―Cu̱aahan ndo ñuu tsa canyií yatyin ñi ihya. Ican cua nañihi ndo iin burru luhlu, quɨtɨ tsa ñaha ca quɨhɨ tyayu. Nuuhñí tɨ. Nda̱tsi ndo tsi tɨ. Tan qu̱itsi ndaca ndo tsi tɨ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tatun yóo tsicá tuhun tsi ndo: “¿Nacuenda ndatsí ndo tsi tɨ?” ca̱tyi ndo tsihin ñi: “Ndatsí ndi tsi tɨ tyin tsiñí ñuhu tɨ tsi ra ndacá ñaha.” ");
INSERT INTO mjcNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tacan tan ra tsicá tsihin ra, cuahán ra naha. Tan nañihi̱ ra naha tsi tɨ tumaa tsa caha̱n maa ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tan cuhva tsa ndatsí ra naha tsi tɨ, tsaa̱ tsitoho tɨ. Tan nducu̱ tuhun ra can naha ra tsi ra naha tan catyí ra: ―¿Nacuenda ndatsí ndo burru ihya? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tacan tan nacaha̱n ra can naha ra: ―Ndatsí ndi tsi tɨ tyin tsiñí ñuhu tɨ tsi ra ndacá ñaha ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tacan tan quihi̱n ra naha tsi tɨ. Tan tsindaca̱ ra naha tsi tɨ nu nyií ra Jesús. Tan tyiso̱ ra naha jahma ra naha tsata tɨ. Tacan tan jandaa̱ ra naha tsi ra Jesús tsata tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tacan tan cuahán ra Jesús. Tan cuaha xaan nyɨvɨ cuahán tsihin ra tsaquín ñi jahma ñi nu ñuhu ityi nu cua yaha ra, yosó ra burru ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tsa tsa cua cuyatyin tandɨhɨ nyɨvɨ tan ra Jesús nu iñi nuu yucu Olivo, quitsaha̱ caná tsaa tandɨhɨ ñi tsinú iñi tsi ra tsihin tsa sɨɨ cuñí ñi. Tan jacahnú ñi tsi Nyoo tyin cuaha xaan tsa iyo javaha̱ ra nyehe̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tan catyí ñi: ―¡Na jacahnu yo tsi ra Rey ihya tyin vatsí ra tsihin sɨvɨ Nyoo Jutu yo! ¡Tan na coo tsa taxin andɨvɨ! ¡Tan na jacahnu yo tsi Nyoo! ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tacan tan juhva ra fariseo tsa cuahán tsihin ñi, catyí ra naha: ―Maestro, ja̱cutaxin tsi nyɨvɨ ihya ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tan nacaha̱n ra Jesús tan catyí ra: ―Tatun nyɨvɨ ihya tan cutaxin ñi, yuu cua cana tsaa, tan cua jacahnu tsi tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tacan tan tsa tsaa̱ ra Jesús yatyin ñi yuhu ñuu Jerusalén, nanyehe̱ ra ñuu can tan quitsaha̱ tsacú ra tsa cuiihya cuñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tan catyí ra: ―Vaha xaan tun tsatyin cuvi coto ndo tan cutuñí iñi ndo nácaa ñihi ndo tsa taxin coo añima ndo vityin ihya. Maa tyin xeehe xaan yɨhɨ́ tsa vaha can, tan ña cuví nañihi ndo can. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Coo quɨvɨ cua nyehe ndo tundoho jaha nu xaan iñi tsi ndo cua tyihi cutu nahnu tsi ndo. Tandɨhɨ ityi cua quitsi nahnu. Tan cañi tahan nahnu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tan cua caquin nahnu tsi ndo nu ñuhu tan cua cahñi nahnu tsi ndo. Tan ndi intuhun ca yuu tsa yosó toto tan ña cua nacoo ca nahnu. Tacan cua cuvi tyin maa ndo ña cuñí ndo nacoto ndo tyin tsa vatsí Nyoo, vatsí jacacu ra tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tacan tan quɨhvɨ̱ ra Jesús tsitsi cora vehe ñuhu cahnu. Tan quitsaha̱ tavá ra tandɨhɨ nyɨvɨ xicó tan nyɨvɨ jatá tsa yucú nu quehe. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tan catyí ra tsihin nahnu: ―Nu tutu Nyoo catyí tyin vehe Nyoo, nu tsicán tahvi yo tsi ra cuví tsi. Tan nyooho jananduvi̱ ndo itsi vehe ñasuhu ―catyi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tan tandɨhɨ quɨvɨ tsaahán ra Jesús tsijacuaha̱ ra tsi nyɨvɨ tsitsi vehe ñuhu cahnu can. Maa tyin ra jutu tsa cuví ityi nuu naha ra, tan ra maestro cuenda ley vehe ñuhu naha ra, tan ra cuví mandoñi ñuu Jerusalén can, nducú ra naha cuhva cahñi ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Maa tyin ña ñihí maa ra naha nácaa javaha ra naha tyin tandɨhɨ nyɨvɨ tan vaha tyaá soho ñi tsa caahán ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Iin quɨvɨ jacuahá ra Jesús tsi nyɨvɨ tsitsi vehe ñuhu cahnu, tan caahán ra nácaa jacacú Nyoo tsi ñi. Tan tsaa̱ ra jutu tsa cuví ityi nuu naha ra tsihin ra maestro cuenda ley vehe ñuhu naha ra, tan tsihin tucu ra cuví mandoñi naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tan catyí ra naha tsihin ra Jesús: ―Ca̱tyi tuhun tsihin ndi ¿yóo tava̱ tyiñu tsi un javaha un tyiñu ihya? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tacan tan ra Jesús catyí ra tsihin ra naha: ―Yuhu cuñí tucu yu nducu tuhun yu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Yóo jaquitsi̱ tsi ra Juan tyin jacoondutya ra tsi nyɨvɨ? ¿A Nyoo jaquitsi̱ tsi ra, a nyɨvɨ? ");
INSERT INTO mjcNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tacan tan ra ican naha ra quitsaha̱ caahán yuhu tahan ra naha tan catyí ra naha: ―Tun catyí yo tyin Nyoo jaquitsi̱ tsi ra Juan, cua catyi ra tsihin yo nacuenda ña tsinu̱ iñi yo tsa caha̱n ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tun catyí tucu yo tyin nyɨvɨ jaquitsi̱ tsi ra, tandɨhɨ nyɨvɨ cua cahñi ñi tsi yo tsihin yuu. Tyin tandɨhɨ ñi, tan cuñí ñi tyin ndusu yuhu Nyoo cuvi̱ ra Juan ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tacan tan nacaha̱n ra naha tsihin ra Jesús tyin ña tsitó ra naha yóo tava̱ tyiñu tsi ra Juan jacoondutya ra tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tacan tan ra Jesús catyí ra tsihin ra naha: ―Ndi yuhu, tan ña cua catyi tuhun yu tsihin ndo yóo tava̱ tyiñu tsi yu tsa javaha yu tyiñu ihya. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tacan tan tsaha̱ cuenda ra Jesús iin cuhva ihya tsi nyɨvɨ: ―Iin ra, tatsi̱ cuaha ra nu ñuhu ra yoho tsɨtɨ yucu tsa cua cuvi vinu. Yaha̱ can tan tsaha̱ nuu ra ñuhu can tsi juhva ra jahá tyiñu. Tacan tan naha cuahán ra inga ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tan quɨvɨ tsa iñí tsɨtɨ nu yoho can, tacan tan jacuhu̱n ra iin musu tyin naquihin ra juhva tsɨtɨ tsa taahán tsi tsi maa ra. Maa tyin cañi̱ xaan ra jahá tyiñu ican naha ra tsi musu can. Tan nundɨɨ ra jacunuhu̱ ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tacan tan tsitoho yoho can jacuhu̱n ra inga musu. Juvin ñi cañi̱ xaan ra can naha ra tsi ra. Tan caha̱n nyaa ra naha tsi ra. Tan jacunuhu̱ ra naha tsi ra. Tan juvin ñi nduve tsa tsaha̱ ra naha cuiso ra cunuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tacan tan ra cuví tsitoho yoho can jacuhu̱n nyico ra inga ra. Maa tyin juvin ñi tacan javaha̱ nyico ra naha tsihin ra can. Tan jañicueehe̱ ra naha tsi ra. Tan tava̱ ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Yaha̱ can tan catyí tsitoho ñuhu ican: “¿Nacaa cua javaha yu vityin? Vaha ca cua jacuhun yu sehe yu, ra tsa cuñí xaan yu. Vasɨquɨ cua tyaa yahvi ra naha tsi ra, tyin sehe yu cuví tsi ra”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Maa tyin tsa nyehe̱ ra jahá tyiñu can naha ra tsi ra sehe ra, natuhún tahan ra naha: “Juvin ra ihya cua ndoo tsihin ñuhu ihya tatun cúu jutu ra. Vaha ca na cahñi yo tsi ra. Tacan tan ndoo maa yo tsihin ñuhu ihya”, catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tacan tan tava̱ ra naha tsi sehe tsitoho ñuhu ican ityi tsata cora, tan tsahñi̱ ra naha tsi ra ―catyí ra Jesús. Tacan tan catyí ra Jesús tsihin nyɨvɨ nyecú ican: ―¿Náa cua javaha tsitoho ñuhu ican tsihin ra can naha ra tyin tsahñi̱ ra naha sehe ra? ");
INSERT INTO mjcNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Catyí yu tsihin ndo tyin cua quitsi ra tan cua cahñi ra tsi ra jahá tyiñu ican naha ra. Tan cua cuhva ra ñuhu ican tsi inga ra naha ―catyí ra Jesús. Tan tsa tsiñi̱ nyɨvɨ tsa caahán ra, nayuhvi̱ xaan ñi cuvi̱. Tan catyí ñi: ―¡Ña cuñi Nyoo tahan yo tacan! ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Maa tyin ra Jesús nanyehe̱ ra nuu ñi tan catyí ra: ―Tun tacan tsicá iñi ndo ¿náa cuñí tsi catyi tsa nyaá nu tutu Nyoo? Tyin catyí tsi tyehen: Yuu tsa ña cuñi̱ ra javaha̱ vehe cuatyiñu ra, yacan cuví yuu tsa tsiñí ñuhu ca. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yóo nyɨvɨ cua canacava tsata yuu can, cua tahnu cuatyi ñi. Tan tatun maa yuu can canacava tsata ñi cua taxin nyihi ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tan ra jutu tsa cuví ityi nuu naha ra tan ra maestro cuenda ley vehe ñuhu naha ra, tuvi̱ iñi ra naha tyin tsa caha̱n ra Jesús tacan, tsi maa ra naha nañi̱ can. Tan cuñí ra naha tɨɨn ra naha tsi ra tyin cahñi ra naha tsi ra. Maa tyin ña tsitó maa ra naha nácaa javaha ra naha, tyin nayuhvi̱ ra naha tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tacan tan jacuhu̱n ra naha tsi juhva ra nducu cuhva tsi ra Jesús. Tan jaha̱ ra naha tyin ra vaha cuví ra naha. Tyin tacan tan coto ra naha náa tsa ña vaha cua cahan ra Jesús tan cuví tɨɨn ra naha tsi ra. Tan cuhva cuenda ra naha tsi ra tsi ra ndacá ñaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yacan tsica̱ tuhun ra naha tsi ra Jesús: ―Maestro, tsitó ndi tyin vaha tsa caahán un. Tan jacuahá un tsa vaha tsi nyɨvɨ. Tan ñavin cuhva iyó ñi nyehé un maa tyin nyehé un cuhva iyó añima ñi. Tan maa ñi maa tsa nditsa tyin ityi Nyoo janahá un. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ca̱tyi tsihin ndi ¿a vaha tsa tyahvi yo tsa tsicán ra ndacá ñaha nda ñuu Roma tsi yo, a ña vaha? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tan ra Jesús tuvi̱ iñi ra tyin nducu cuhva ra naha tsi ra. Tan catyí ra tsihin ra naha: ―¿Nacuenda cuñí ndo nducu cuhva ndo tsi yu? ");
INSERT INTO mjcNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ja̱naha jihna ndo iin xuhun tsi yu, na nyehe yu. ¿Yóo nuu nyaá xuhun can tan yóo sɨvɨ nyaá can? ―catyí ra. Tacan tan nacaha̱n ra naha: ―Nuu ra ndacá ñaha, ra cuví rey cahnu, nyaá can tan juvin ñi sɨvɨ ra nyaá can ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tacan tan catyí ra Jesús: ―Tun tacan, cu̱hva ndo xuhun can tsi ra ndacá ñaha tyin tsii maa ra cuví tsi. Tan cu̱hva ndo tsi Nyoo tsa taahán tsi tsi ra ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tan ña cuví maa jandavi ñaha ra naha tsi ra Jesús tsihin tsa caahán ra tacan tsihin nyɨvɨ. Tan iyo xaan cuñí ra naha tsa nacaha̱n ra. Tan taxin ña cuvi̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsa yaha̱ can tan tsaa̱ juhva ra cuví saduceo nu nyií ra Jesús. Maa ra naha cuví ra tsa catyí tyin ña nandoto nyɨvɨ tun tsa tsihi̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tacan tan catyí ra naha tsihin ra Jesús: ―Maestro, jandoo̱ ra Moisés tyiñu ihya tyin tatun iin ra tsihi̱ tan nandoo̱ ñasɨɨhɨ ra, tatun nduve sehe ra tsicoo̱ tsihin ña, taahán tsi tsa tindaha ra cuví yañi ra tsihin ña, tan coo sehe ra tsihin ña tsa cuenda ra yañi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Maa tyin cuñí ndi coto ndi nácaa, tyin tsicoo̱ iin ra tan tsicoo̱ utsa sehe ra. Tan ra tsa ñihi ca tsicoo̱ ñasɨɨhɨ ra, maa tyin nduve sehe ñi tsicoo̱, tan tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tacan tan naquihi̱n ra tsa tsinu uvi tsi ña can. Tan nduve tucu sehe ñi tsicoo̱. Tan tsihi̱ tucu ra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tan juvin ñi tacan javaha̱ ra tsinu uñi. Tandɨhɨ tsa utsa ra naha javaha̱ tacan. Ndi intuhun ra tan ña tsicoo̱ sehe ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tan nu ndɨhɨ tuhun tsihi̱ ndɨhɨ maa ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tan cuñí ndi coto ndi yóo ra cua cuvi yɨɨ ña tsitsi tsa tandɨhɨ tsa utsa taahan ra naha quɨvɨ cua nandoto nyɨvɨ ―catyí ra saduceo naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tacan tan nacaha̱n ra Jesús, tan catyí ra: ―Ihya nu ñuhu ñayɨvɨ, rayɨɨ tan ñaha tindahá ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Maa tyin nyɨvɨ tsa nacatsi̱ Nyoo tyin nandoto ñi tan coo ñi nu ndacá ñaha ra, ña tindaha ca ñi tan ndi ña cua cuhva ca ñi sehe ñi tindaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tan nduve tuhun tsiihí iyó ndacan tyin cua cuvi ñi tumaa ángel. Tan cua cuvi ñi sehe Nyoo tyin nandoto̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tan tsa cuenda tuhun tsa nandotó ndɨyɨ. Tsa nditsa cuví tsi tyin yacan jacoto̱ ra Moisés nu nacatyi̱ tuhun ra nácaa cayú taca iñu can. Tsihin can jacoto̱ ra tsi yo tyin nyɨvɨ tsiihí cua nandoto ñi. Tyin catyi̱ ra: “Jutu yo Nyoo cuenda ra Abraham, tan cuenda ra Isaac, tan cuenda ra Jacob”, catyí ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tacan catyi̱ ra tyin Nyoo, ñavin Nyoo cuenda nyɨvɨ tsiihí cuví ra. Nyoo cuenda nyɨvɨ nyito cuví ra. Tyin tsa cuenda Nyoo tandɨhɨ yo tan nyito añima yo vasu tsa tsihi̱ cuñu ñuhu yo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tacan tan juhva ra maestro cuenda ley vehe ñuhu naha ra catyí ra naha: ―Vaha xaan nacaha̱n un, Maestro ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tacan tan ña caná ca maa iñi ra naha nducu tuhun ra naha náa inga ca nducu tuhun ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tacan tan tsica̱ tuhun ra Jesús tsi ra naha: ―¿Nacuenda catyí yo tyin ra Cristo tata ra David cuví tsi ra? ");
INSERT INTO mjcNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Tyin juvin ñi maa ra David catyí ra nu libru Salmo: Caahán Nyoo Jutu yu tsihin Jutu Mañi yu, ra Cristo, tan catyí ra tsihin ra: “Cu̱nyaa xiin cuaha yu nda cuanda cuhva yu tsi nu xaan iñi tsi un tyin cuhvi tsaha un tsi nahnu”, catyi̱ Nyoo tsa tsatyiñu̱ ra yuhu ra David taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Nacaa tsa tata ra David cuví tucu ra Cristo, tan juvin ñi maa ra David catyí tyin Jutu Mañi ra cuví tsi ra Cristo? ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tandɨhɨ nyɨvɨ tsiñi̱ ñi tsa caha̱n ra Jesús tsihin ra tsicá tsihin ra nu caha̱n ra tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ja̱ha ndo cuenda tsi ndo tsihin ra maestro cuenda ley vehe ñuhu naha ra. Tyin taahán xaan iñi ra naha cunditsi ra naha jahma nañi. Tan cuahan ra naha nuyahvi, cuñí ra naha tsa cuhva nyɨvɨ yucú nuyahvi nacumi tsi ra naha tsihin tsa jaha ñi tsa ñayɨvɨ tsi ra naha. Tan nanducú ra naha tyayu vaha cunyecu ra naha tsitsi vehe ñuhu, tan nu cuahán ra naha vico. ");
INSERT INTO mjcNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tan naha tsicán tahvi ra naha tsi Nyoo nu tuví, tsa cuñí ra naha tsa nyehe nyɨvɨ tan catyi ñi tyin vaha xaan nyɨvɨ cuví ra naha. Maa tyin juvin ñi maa ra naha cuví ra quinyaá vehe ñi ndaahvi tsa tsihi̱ yɨɨ tyin ña cuví tyahvi ñi xuhun tsa tavá ra naha tsi ñi. Yacan ñihi xaan cua tatsi tuñi Nyoo tsi ra naha ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tan nyehe̱ ra Jesús tyin cuaha xaan nyɨvɨ cuca tyihí ñi xuhun tsitsi caja tsa nyií tsitsi vehe ñuhu cahnu. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tan nyehe̱ tucu ra tsi iin ñaha ndaahvi tsa tsihi̱ yɨɨ. Tan tyihi̱ ña uvi taahan ñi xuhun nyihi. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tan catyí ra: ―Tsa nditsa catyí yu tsihin ndo tyin nuu Nyoo cuaha ca xuhun tyihi̱ ñaha ndaahvi ihya tan ñavin ca tandɨhɨ ñi cuca can. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tyin tsa ndoo̱ ña tyihí ñi. Tan ñaha ihya tyihi̱ ña tandɨhɨ tsa iyó tsi ña ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tacan tan juhva nyɨvɨ natuhún ñi tuhun cuenda vehe ñuhu cahnu ican. Tan catyí ñi tyin sɨɨ xaan caá yuu. Tan sɨɨ xaan caá tsa jamañi̱ nyɨvɨ. Tacan tan catyí ra Jesús: ");
INSERT INTO mjcNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Coo quɨvɨ tan cua tanɨ tandɨhɨ tsa nyehé ndo ihya. Tan ndi intuhun ca yuu tan ña cua coso ca sɨquɨ inga tsi. Ndɨhɨ tsi cua canɨ nu xaan iñi tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tacan tan nducú tuhun nyɨvɨ tsi ra Jesús, tan catyí ñi: ―Maestro, ¿ama cua cuvi tandɨhɨ tsa caahán un ihya? ¿Nacaa tan coto ndi tatun tsa cuyatyin tsa naa ñuhu ñayɨvɨ? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tacan tan catyí ra Jesús: ―Ja̱ha vaha ndo cuenda, coto jandavi ñaha nyɨvɨ tsi ndo. Tyin cuaha xaan ra cua quitsi, tan cua cuatyiñu ra naha sɨvɨ yu, tan cua catyi ra naha: “Yuhu cuví Cristo, ra tsa jaquitsi̱ Nyoo. Tyin tsa cuñí naa ñuu ñayɨvɨ”, cua catyi ra. Maa tyin ña cunyicun ndo tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tan quɨvɨ cua ñihi tuhun ndo tyin tsa iyó cuatyi tan ñihi cañí tahan nyɨvɨ, ña nayuhvi ndo. Tyin tandɨhɨ can taahán tsi cuvi tsa jihna ñi. Maa tyin cumañi ca tsaa quɨvɨ tsa cua naa ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tan catyí tucu ra: ―Nyɨvɨ iyó iin ñuu cua cañi tahan ñi tsihin nyɨvɨ inga ñuu. Tan cua coo cuatyi. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tan ñihi xaan cua taan. Tan cua coo tama. Tan cua coo cuehe tandɨhɨ ñi ityi. Tan cua nyehe nyɨvɨ tsa yuuhví ityi andɨvɨ. Tan cuaha xaan tsa iyo nahnu tsa ña tuhvá nyɨvɨ nyehe tan cua nyehe ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Maa tyin tsa ndi cumañi ca cuvi yacan, cua cuxaan iñi nyɨvɨ tsi ndo. Tan cua ndacan ñi cuatyi tsaha ndo. Tyin cua cutuñi ndo tan cua cuhva cuenda ñi tsi ndo tsi ra jutu. Tan cua tyihi ñi tsi ndo tsitsi vehe caa. Tan cua cundaca ñi tsi ndo nuu rey tan nuu ra ndacá ñaha tsacatyi sɨvɨ yuhu. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tacan tan cuví cahan ndo tuhun yu tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Maa tyin ja̱ha ndo cuenda tan ña cua caca iñi ndo náa tuhun cua nacahan ndo tsihin ra ndacá ñaha ican. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tyin yuhu cua cuhva yu tuhun cua cahan ndo. Tan cua cuhva yu tsa nyityi jiñi ndo nu cua cahan ndo. Ndi intuhun nu xaan iñi tsi ndo tan ña cuvi jaha nahnu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Maa tyin nyɨvɨ cua cuhva cuenda ñi tsi ndo tsi nu xaan iñi tsi ndo. Nda cuanda jutu ndo tan sɨhɨ ndo, ra cuví yañi ndo, nyɨvɨ ndo, tan ra vaha iñi tsi ndo cua cuhva cuenda ra naha tsi ndo tsi nu xaan iñi tsi ndo. Tan yɨhɨ́ nyooho cua cahñi nyɨvɨ tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tandɨhɨ nyɨvɨ tan ndasɨ cua cuñi ñi nyehe ñi tsi ndo tsacatyi yuhu. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Maa tyin ndi intuhun ixi jiñi ndo tan ña cua cunaa. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tatun ña ndu uvi iñi ndo tsa nyicun ndo tsi yu, cua cacu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Quɨvɨ cua nyehe ndo tyin nɨɨ canduvi yuhu ñuu Jerusalén ihya nyecú andaru, coto ndo tyin tsa cuñi naa ñuu ihya. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tan nyɨvɨ iyó ñuu tsa cayucú Judea, cua cunu ñi tan cuhun xeehe ñi ityi yucu. Tan nyɨvɨ iyó ñuu Jerusalén ihya, cua quita ñi. Tan nyɨvɨ iyó tsitsi cuhu, ña cua quitsi nuhu ñi ñuu ihya. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tyin yacan cuví quɨvɨ tsa cua tatsi tuñi Nyoo tsi nyɨvɨ ñuu ihya. Tyin tsa cua cuvi tandɨhɨ cuhva catyí nu tutu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tan ndahvi ñiñaha tsa ñuhú sehe quɨvɨ can. Tan ndahvi ñi tsa iyó sehe lee tsa ndi tyaxín. Tyin cuaha xaan tundoho cua nyehe ñi tan tandɨhɨ nyɨvɨ. Tyin cahnu xaan tsa uhvi cua nyehe nyɨvɨ ñuu Jerusalén ihya cua jaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Andaru cua cahñi ra naha tsi juhva nyɨvɨ tsihin mityi. Tan cua tɨɨn ra naha juhva ñi tan cundaca ra naha tsi ñi ñuu nahnu. Tan nyɨvɨ tsa ñavin nyɨvɨ Israel cuví, cua cuyucu ñi ñuu Jerusalén ihya nda cuanda quɨvɨ tsa catyí maa Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Tacan tan cuaha tsa iyo cua nyehe nyɨvɨ nu ñicanyii, tan nu yoo, tan nu tiñuu. Tan ihya nu ñuhu ñayɨvɨ cua nayuhvi ñi tsihin tsa iyo cua nacatyin ndutya ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tan cua cúu naaha ñi tsihin tsa yuuhví ñi tsa tsicá iñi ñi náa ndɨhɨ tsa cua cuvi ihya nu ñuhu ñayɨvɨ. Tyin nda cuanda tsa iyó andɨvɨ cua nacanda tan taan. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tacan tan cua nyehe ñi tsi yuhu, Rayɨɨ tsa quee̱ nda gloria, vatsí nuu yu tsitsi vico tsihin tunyee iñi Nyoo, tan tsihin tsa cahnu cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tan cuhva tsa cua quitsaha yacan tan ja̱ndu iin ndo iñi ndo tan cu̱sɨɨ iñi ndo tyin numi xaan cua cacu ndo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tacan tan tsaha̱ cuenda ra Jesús iin cuhva ihya, tan catyí ra: ―Ja̱ha ndo cuenda yutun higuera, tsihin tandɨhɨ ca yutun. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tatun tsa nduyutyá numa tun tsa cuyatyin cuun savi. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tan tacan tucu nyooho, tatun tsa nyehe ndo tyin tsa quitsaha̱ cuví tandɨhɨ tsa caha̱n yu tsihin ndo, co̱to ndo tyin tsa nyanaá quɨvɨ tsa cundaca ñaha Nyoo nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Maa tyin tsa nditsa catyí yu tsihin ndo tyin yacan cua cuvi jihna tsa ndi cumañi ca cúu nyɨvɨ tsa iyó nu ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Coo quɨvɨ cua naa andɨvɨ tan ñuhu ñayɨvɨ, maa tyin tuhun caahán yu, ña cua cundɨhɨ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Tan ja̱ha ndo cuenda tsi ndo coto ndundava iñi ndo tsihin tsa cua javaha ndo tsa caquiñi, a tsa coho ndo nyixi, a tsa caca xaan iñi ndo tundoho ñayɨvɨ ihya. Ja̱ha ndo cuenda coto ndundava iñi ndo tsihin yacan. Tan coto sana iñi ndo tan quita quɨvɨ cua quitsi yu tan cua quitsi tundoho cua nyehe ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tyin tacan cua cuvi, tandɨhɨ nyɨvɨ iyó nu ñuhu ñayɨvɨ, sana iñi ñi tan tumaa iin tsa cua nacasɨ Nyoo nu yucú ñi tan ña cua cuvi quita ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Maa tyin nyooho cu̱atu ndo. Nda̱can tahvi ndo tsi Nyoo tandɨhɨ quɨvɨ, na jacacu ra tsi ndo. Tan ña nyehe ndo tandɨhɨ tundoho tsa cua coo. Nda̱can tahvi ndo, tacan tan cua cuvi tsaa ndo nu nyaá yuhu, Rayɨɨ tsa quee̱ nda gloria ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tan tandɨhɨ quɨvɨ jacuahá ra Jesús tsi tandɨhɨ nyɨvɨ tsitsi vehe ñuhu cahnu. Tan tsa tsacuaa tsicá ra yucu Olivo. ");
INSERT INTO mjcNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tan tandɨhɨ nyɨvɨ tsaá ñi tsitsi vehe ñuhu cahnu ndɨhɨ tsa tuvi, tyin tyaa soho ñi tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tan tsa nyanaá yatyin quɨvɨ tsa cua coo vico pascua, vico nu tuhvá nyɨvɨ tsatsí paan tsa nduve yutsan iya yɨhɨ́. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tan ra jutu tsa cuví ityi nuu naha ra tsihin ra maestro cuenda ley vehe ñuhu naha ra, nducú xaan ra naha cuhva cahñi ra naha tsi ra Jesús. Maa tyin yuuhví ra naha tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tacan tan quɨhvɨ̱ nu ña vaha tsi nu Judas Iscariote. Tan nu ihya cuví iin tsa utsi uvi taahan ra tsa nacatsi̱ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tan nu ihya, tsaha̱n nu tsicaha̱n nu tsihin jutu tsa cuví ityi nuu tan tsihin ra yɨhɨ́ ndaha tsi ra jahá cuenda vehe ñuhu cahnu naha ra. Tan natuhu̱n tahan ra naha nácaa cua cuhva cuenda nu Judas tsi ra Jesús tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tan ra ican naha ra sɨɨ xaan cuñí ra naha. Tan tyihi̱ ra naha cuhva tyin cuhva ra naha xuhun tsi ra Judas. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tan ra Judas ndoo̱ ra vaha. Tan quitsaha̱ nducú ra cuhva ama cua nacuhva cuenda ra tsi ra Jesús tsi ra can naha ra, cuhva tsa nduve nyɨvɨ yucú tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tan tsaa̱ quɨvɨ tsa cuvi vico tsa tsatsí nyɨvɨ paan tsa nduve yutsan iya yɨhɨ́. Tan juvin ñi quɨvɨ ican tuhvá ñi tsahñí iin mbee luhlu tsa vico pascua can. Tyin catsi ñi tsi tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tan ra Jesús jacuhu̱n ra tsi ra Pedro tsihin ra Juan, tan catyí ra tsihin ra naha: ―Cu̱aahan ndo cujanduvaha ndo mbee tsa cua cuxiñi yo cuenda vico pascua ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tacan tan nducú tuhun ra naha tsi ra: ―¿Numaa cuñí un javaha ndi tsa cuxiñi yo? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tacan tan catyí ra Jesús tsihin ra naha: ―Cu̱aahan ndo tsitsi ñuu. Ican cua nañihi ndo tsi iin ra nyisó iin quɨyɨ ndutya. Cu̱aahan ndo tsata ra tan quɨhvɨ ndo vehe nu quɨhvɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tan ca̱tyi ndo tsihin tsitoho vehe can: “Ra cuví Maestro, cuñí ra coto ra numaa nyaá cuartu nu cua cuxiñi ra tsihin ra tsicá tsihin ra, tyin jacahnu ra vico pascua.” Tacan ca̱tyi ndo tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tacan tan cua janaha ra iin cuartu cahnu ityi sɨquɨ, nu tsinu uvi pisu tsi ndo. Tan tsa nduvaha̱ maa tsi. Tan ndacan cua javaha ndo tsa cuxiñi yo ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tacan tan cuahán ra naha. Tan nañihi̱ ra naha tandɨhɨ tumaa tsa caha̱n ra Jesús. Tacan tan na ica̱ vaha ra naha tsa cuxiñi ra naha cuenda vico pascua. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tacan tan tsa taha̱n tsi cuhva tsa cuxiñi ra Jesús tsihin tandɨhɨ ra tava̱ tyiñu ra, tsinyecu̱ ra naha yuhu mesa. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tacan tan catyí ra Jesús: ―Cuñí xaan yu cuxiñi yu tsihin ndo cuenda vico pascua ihya tsa ndi cumañi ca nyehe yu tundoho tan cúu yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tan catyí yu tsihin ndo tyin ña cua catsi ca yu inga tsaha tsa cuenda vico ihya, nda cuanda tahan tsi inga tsaha nda nu ndacá ñaha Nyoo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tacan tan quihi̱n ra iin vasu vinu. Nacuhva̱ ra tyahvi nyoo tsi Nyoo. Yaha̱ can tan catyí ra tsihin ra nyecú tsihin ra: ―Qu̱ihin ndo tsehe. Tan co̱ho ndo luxu luxu. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tyin catyí yu tsihin ndo tyin ña cua coho ca yu vinu nda cuanda quitsi Nyoo tan quitsaha cundaca ñaha ra nu ñuhu ñayɨvɨ ihya ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yaha̱ can tan quihi̱n ra paan, tan tsaha̱ ra tyahvi nyoo tsi Nyoo, tan tsahnya̱ sava ra can. Tsahan tsaha̱ ra can tsi ra naha. Tan catyí ra tsihin ra naha: ―Paan ihya cuví tumaa cuñu ñuhu yu. Tyin cua cuhva cuenda yu tsi yu tan cúu yu tsa cuenda tsa vaha tsi maa ndo. Tacan cuñí tsi ndu̱cuhun iñi ndo tsi yu tan cu̱xiñi ndo tyehen ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tan tsa yaha̱ cuxiñi̱ ra naha, tacan tan quihi̱n ra vasu vinu, tan catyí ra: ―Tsihin vinu ihya ndoó Nyoo tyiñu tsihin ndo vityin. Tyin vinu tsa yɨhɨ́ tsitsi vasu ihya, tumaa nɨñɨ yu cuví tsi. Tan tsa vaha tsi nyooho tan cua catɨ nɨñɨ yu. Tan cua cúu yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Maa tyin vityin, ra tsa cua nacuhva cuenda tsi yu tsi ra xaan iñi tsi yu, iin ñi nu yosó ndaha ra tsihin ndaha yu nu mesa ihya. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tyin yuhu, Rayɨɨ tsa quee̱ nda gloria, cua tahan yu tumaa tsa nyaá maa tsa cua tahan yu. Maa tyin ¡ndahvi ra tsa cua nacuhva cuenda tsi yu! ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tacan tan ra tsicá tsihin ra Jesús quitsaha̱ nducú tuhun tahan ra naha, ndáa ra cua nacuhva cuenda tsi ra Jesús tsi ra xaan iñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yaha̱ can tan quitsaha̱ caahán yuhu tahan ra tsicá tsihin ra Jesús, ndáa ra cahnu ca cuví. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tan ra Jesús catyí ra: ―Tsitó nyooho tyin ra ndacá ñaha tsi nyɨvɨ iyó nu ñuhu ñayɨvɨ, ñihi xaan ndacá ñaha ra naha tsi ñi. Tan cuñí ra naha tyin catyi nyɨvɨ tyin jatyinyeé ra naha tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Maa tyin nyooho ña taahán tsi javaha ndo tumaa javahá ra ican naha ra. Tyin tatun cuñí ndo cuvi ndo ra cuví ityi nuu, taahán tsi janduluhlu ndo tsi ndo. Tan tatun cuñí ndo cundaca ñaha ndo, cuñí tsi tsa cuvi ndo musu tandɨhɨ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tyin nu ñuhu ñayɨvɨ ihya, ra cuví ityi nuu cuví ra tsa ña jahá tyiñu. Tan nyaá ra yuhu mesa tan musu ra tsahá tsa catsi ra. Maa tyin yuhu, ra cuví ityi nuu cuví yu, tan cuví yu musu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Tan nyooho cuví ndo tsa nyecú tsihin yu tandɨhɨ nu nyehe̱ yu tundoho. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yacan cuenda, yuhu tsaha̱ yu iin nu cua cundaca ñaha ndo tumaa tsa tsaha̱ Jutu yu tsa cundaca ñaha yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tyin cua catsi ndo tan cua coho ndo nu mesa tsihin yu nda nu ndacá ñaha yu. Tan ndacan cua cunyecu ndo cundaca ñaha ndo nyɨvɨ cuví tata tsa utsi uvi sehe ra Israel. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tacan tan catyí ra Jesús tsihin ra Pedro: ―Nye̱he vaha un, yooho Simón. Tyin nu ña vaha tsa tsica̱n ndatu nu tsi Nyoo tsa nducu cuhva nu tsi ndo tyin cuñí nu tsa ndu uvi iñi ndo tsa tsinú iñi ndo tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Maa tyin tsica̱n tahvi xaan yu tsi ra tsa cuenda un, na ña jandɨhɨ un tsa tsinú iñi un tsi yu. Tan tsa ndu uvi iñi un cuatyi un, tan natsinu vaha nyico iñi un tsi yu, cua jatyinyee un tsi ra yañi un naha ra tsa ña cua jandɨhɨ ra naha tsa tsinú iñi ra naha tsi yu ―catyí ra Jesús tsihin ra Simón. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tan ra Simón catyí ra tsihin ra: ―Jutu Mañi yu, tsa ndu̱ iin vaha iñi yu tsa cuhun yu tsihin un vasu vehe caa, vasu cúu yu tsihin un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tacan tan catyí ra Jesús tsihin ra: ―Pedro, catyí yu tsihin un tyin vityin tsa ndi cumañi ca vacu tsitooho, yooho cua catyi un uñi tsaha tyin ña nacoto un tsi yu ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tacan tan tsica̱ tuhun ra Jesús tsi ra tsicá tsihin ra tan catyí ra tsihin ra naha: ―Ndu̱cuhun iñi ndo quɨvɨ tsa jacuhu̱n yu tsi ndo tsa caha̱n ndo tsihin nyɨvɨ, tan nduve tsa tsindaha̱ ndo, ndi marali, ndi xuhun, ndi inga pari nditsan ndo. ¿A cumañi̱ tsa cumañi̱ tsi ndo quɨvɨ can? ―catyí ra Jesús. ―Nduve ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tacan tan catyí ra Jesús tsihin ra naha: ―Maa tyin vityin, tatun iyó marali ndo, cu̱ndaha ndo. Tan tatun iyó xuhun ndo, cu̱ndaha ndo. Tatun nduve mityi ndo, xi̱co ndo iin jahma ndo tan ja̱ta ndo mityi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tyin catyí yu tsihin ndo, tyin tandɨhɨ tuhun yu tsa nyaá nu tutu Nyoo cua cundaa tsi, tyehen catyí tsi: “Cua tatsi tuñi nyɨvɨ tsi ra tumaa tsa cuví ra iin ra caquiñi.” Tacan catyí tuhun yu nu tutu Nyoo. Tan tandɨhɨ tsa catyí tsi tsa cuenda yu cua cundaa tsi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tacan tan catyí ra tsicá tsihin ra: ―Ihya nyecú uvi taahan mityi ―catyí ra naha. ―Tsa iyó vaha ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tacan tan quita̱ ra Jesús vehe nu nyií ra. Tan cuahán ra yucu Olivo, cuhva tuhvá maa ra tsicá. Tan ra tsicá tsihin ra cuahán ra naha nyicún ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tan tsa tsaa̱ ra naha ndacan, catyí ra tsihin ra naha: ―Nda̱can tahvi ndo tsi Nyoo tyin tacan tan ña cuvi jaha canaa nu ña vaha tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tacan tan cuahán ra Jesús tsa cañi luxu ca, tumaa tsa cañi tsaá iin yuu tun cañi yo can. Tacan tan tsicuɨñɨ̱ tsɨtɨ ra. Tan quitsaha̱ caahán ra tsihin Nyoo, ");
INSERT INTO mjcNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","tan catyí ra: ―Tyatya Jutu yu, tun yooho tan cuñí un, ja̱tsiyo tundoho tsa cua nyehe yu ihya. Maa tyin na ña cuvi cuhva cuñí maa yu. Na cuvi cuhva cuñí maa un ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tacan tan quituvi̱ iin ángel Nyoo, tyin cuhva ra tunyee iñi tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tan tsitsi tsa nyehé xaan ra Jesús tundoho tsa cuiihya xaan cuñí ra, tan ñihi ca tsica̱n tahvi ra tsi Nyoo. Tan cuaha xaan tyeen ra quitá tan tsatɨ́ tsi nu ñuhu, tan caá tsi tumaa caá nɨñɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tacan tan nduvita̱ ra tsa ndɨhɨ̱ caha̱n ra tsihin Nyoo. Tan cuahán nyico ra nu yucú ra tsicá tsihin ra. Tan nyehe̱ ra tyin quixí ra naha, tsa cuenda tsa cuiihya xaan cuñí ra naha, ña cunyee̱ iñi ra naha ñumaahna tan quixi̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tacan tan catyí ra Jesús tsihin ra naha: ―¿Nacuenda quixí ndo? Ndu̱vita ndo. Tan nda̱can tahvi ndo tsi Nyoo, tyin tacan tan ña cuvi jaha canaa nu ña vaha tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ndi caahán ca ra Jesús yacan, tan tsaa̱ cuaha ra catsaa̱. Tan ityi nuu, vatsí nu Judas, iin ra tsicá tsihin ra Jesús. Tan natuhva̱ nu nu nyaá ra Jesús tyin tyayuhu nu tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tacan tan caha̱n ra Jesús tsihin nu: ―Yooho Judas, ¿a tsihin tsa cua tyayuhu un tsi yu, tan cua nacuhva cuenda un tsi yuhu Rayɨɨ tsa quee̱ nda gloria tsi nu xaan iñi tsi yu nahnu? ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tan ra nyecú tsihin ra Jesús quitsaha̱ nducú tuhun ra naha tsi ra: ―Jutu Mañi ndi ¿a vaha cahnya ndi tsi ra naha tsihin mityi? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tacan tan iin ra can, tsahnya̱ ra soho tsiyo cuaha iin ra tsa cuví musu ra jutu tsaahnu tsa cuví ityi nuu. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Maa tyin ra Jesús catyí ra tsihin ra: ―Ja̱ña ndo. Vaha ñi ―catyí ra. Tacan tan tɨɨ̱n ra Jesús soho ra ican tan janduvaha̱ ra itsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tan ra jutu tsa cuví ityi nuu naha ra tsihin ra yɨhɨ́ ndaha tsi ra jahá cuenda vehe ñuhu naha ra, tan ra cuví mandoñi naha ra, juvin ra naha cuví ra tsaha̱n tsitɨɨn tsi ra Jesús. Tan catyí ra Jesús tsihin ra naha: ―¿A vatsí tɨɨn ndo tsi yu tumaa tɨɨ́n ndo iin ñasuhu? tyin ndaha ndo mityi tan yutun. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndɨhɨ quɨvɨ tsinyii̱ yu tsitsi vehe ñuhu cahnu, tan ña tɨɨn ndo tsi yu ndacan. Maa tyin vityin tsaa̱ cuhva tsa ndunaa̱ tyin nu ña vaha ndacá ñaha. Yacan cuenda vatsí tɨɨn ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tacan tan tɨɨ̱n ra naha tsi ra Jesús. Tan tsindaca̱ ra naha tsi ra nda vehe ra jutu tsaahnu tsa cuví ityi nuu. Tan ra Pedro ndasava ñi cuahán ra nyicún ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tan tsa tsaa̱ ra naha vehe ra jutu tsaahnu tsa cuví ityi nuu, jataha̱n ra tsa cuví musu naha ra ñuhu̱ nuquehe. Tan tsinyecu̱ ra naha tanɨɨ canduvi nu cayú ñuhu̱ can. Tan tsinyaa̱ ndɨhɨ ra Pedro tyañu ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tan tsa ndunditsín tsa cayú ñuhu̱ ican, tacan tan iin ñaha tsa cuví musu jutu can, nyehe̱ ña tsi ra Pedro. Tan catyí ña: ―Ra ihya tsicá tucu ra tsihin ra can ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Maa tyin ra Pedro catyí ra: ―Yuhu ña nacotó yu tsi ra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tañi ñi tan nyehe̱ tucu inga nyɨvɨ tsi ra Pedro, tan catyí ñi tsihin ra: ―Yooho, cuenda ra ican cuví un ―catyí ra. Tan ra Pedro catyí ra: ―Ña nditsa ");
INSERT INTO mjcNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tan tsa yaha̱ iin hora, tan nyehe̱ tucu inga ra tsi ra Pedro tan catyí ra tsihin ra: ―Tsa nditsa tyin juvin ra ihya cuví iin ra tsa tsicá tsihin ra can. Tyin juvin ra Galilea cuví ra ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tacan tan catyí ra Pedro: ―Ña tsitó yu náa caahán un ―catyí ra. Tan juvin ñi cuhva can, tsitsi tsa ndi caahán ca ra Pedro tan navacu̱ ñi iin tsitooho. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tacan tan ra Jesús nanyehe̱ ra nuu ra Pedro. Tan ra Pedro nducuhu̱n iñi ra tsa caha̱n ra Jesús tsihin ra: “Tsa ndi cumañi ca navacu tsitooho, yooho tsa cahan un uñi tsaha tyin ña nacotó un tsi yu.” ");
INSERT INTO mjcNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tacan tan quita̱ ra Pedro ityi tsata vehe. Tan tsacu̱ xaan ra tsa cuiihya cuñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tacan tan ra jahá cuenda tsi ra Jesús, quitsaha̱ tsacú nducu ra naha tsi ra. Tan cañi̱ ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tsahñi̱ ra naha jahma nuu ra, tan quitsaha̱ cañí ra naha nuu ra. Tan catyí ra naha tsihin ra: ―Na̱coto yóo ra cañí tsi un ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tan cuaha xaan ca maa tsa caha̱n nyaa ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tan tsa cunditsi̱n inga quɨvɨ, tan ndu ii̱n ra cuví mandoñi tsahnu ñuu can tsihin ra jutu tsa cuví ityi nuu naha ra, tan tsihin ra maestro cuenda ley vehe ñuhu naha ra. Tan quihi̱n ra naha tsi ra Jesús, cuahán tsihin ra nda nu cua coo Junta Cahnu. Tan nducu̱ tuhun ra naha tsi ra Jesús: ");
INSERT INTO mjcNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ca̱tyi tuhun tsihin ndi tun juvin ra Cristo cuví un ―catyí ra naha tsihin ra. Tan ra Jesús nacaha̱n ra tan catyí ra: ―Tatun catyi yu tsihin ndo tyin juvin yu cuví, ña cua tsinu iñi ndo tsa cahan yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tan tatun nducu tuhun tucu maa yu tsi ndo, ña cua nacahan ndo, tan ndi ña cua jaña ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Maa tyin vityin tan ityi nuu ca, Rayɨɨ tsa quee̱ nda gloria cua cunyaa ra xiin cuaha Nyoo, ra tsa iyó tandɨhɨ tunyee iñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tacan tan tandɨhɨ ra naha tsica̱ tuhun ra naha tsi ra: ―Tun tacan, Sehe Nyoo cuví tsi un ―catyí ra naha. Tacan tan nacaha̱n ra Jesús tan catyí ra: ―Juvin, sehe Nyoo tsi yu tumaa catyí maa ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tacan tan natuhu̱n tahan ra naha: ―Tsiñí ndo tsa caahán ra. Ña cuñí ca tsi tsandaa. Tyin tsa tsiñi̱ maa yo tsa caha̱n ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tacan tan nduvita̱ tandɨhɨ ra naha. Tan tsindaca̱ ra naha tsi ra Jesús nda nu nyaá ra Pilato, ra ndacá ñaha quee̱ nda ñuu Roma. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tacan tan quitsaha̱ tyaá ra naha cuatyi tsi ra Jesús nuu ra Pilato tan catyí ra naha tsihin ra: ―Ra ihya, jatɨvɨ́ ra tsi nyɨvɨ tsihin tsa caahán ra tsihin ñi, tyin caahán ra tyin ña vaha tsa tyahvi ndi xuhun tsi ra ndacá ñaha nda ñuu Roma. Tan caahán tucu ra tyin cuví ra Cristo, ra tsa jaquitsi̱ Nyoo tyin cuvi ra rey ―catyí ra naha tsihin ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tacan tan ra Pilato tsica̱ tuhun ra tsi ra Jesús: ―¿A yooho cuví Rey cuenda nyɨvɨ Israel? ―catyí ra. Tan nacaha̱n ra Jesús tan catyí ra: ―Juvin, tumaa catyí maa un. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tacan tan catyí ra Pilato tsihin ra jutu tsa cuví ityi nuu naha ra, tan tsihin nyɨvɨ: ―Nduve cuatyi ra ihya ―catyí ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Maa tyin jañihi̱ ca ñi caahán ñi. Tan catyí nyico ñi: ―Cahnu xaan cuatyi ra. Tyin cuaha xaan tɨsɨhɨ tsahá ra, tyin jacuahá ra tsi nyɨvɨ. Tsa jihna ñi quitsaha̱ caahán ra tsihin nyɨvɨ iyó ñuu tsa cayucú Galilea. Tan nanɨɨ ityi vatsí ra, jacuahá ra tsi nyɨvɨ. Tan vityin tsa tsaa̱ ra Judea ihya tan juvin ñi yacan javahá ra ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cuhva tsa tsiñi̱ ra Pilato yacan, tan nducu̱ tuhun ra tatun ra Galilea cuví ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tan catyí nyɨvɨ tsihin ra tyin juvin. Tacan tan jacuhu̱n ra Pilato tsi ra nda nu nyaá ra Herodes. Tyin ra Herodes cuví ra ndacá ñaha Galilea can. Tan quɨvɨ can nyií ra ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tan cuhva tsa nyehe̱ ra Herodes tsi ra Jesús, sɨɨ xaan cuñí ra. Tyin tsanaha xaan cuñí ra nyehe ra tsi ra. Tyin ñihi̱ tuhun ra tyin cuaha xaan tsa iyo javahá ra. Tan cuñí xaan ra nyehe ra iin tsa iyo tsa cua javaha ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tan cuaha xaan tsa nducu̱ tuhun ra Herodes tsi ra Jesús. Maa tyin ra Jesús ña nacaha̱n maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ican nyecú ndɨhɨ tucu ra jutu tsa cuví ityi nuu naha ra, tan ra maestro cuenda ley vehe ñuhu naha ra. Tan tyaa̱ xaan ra naha cuatyi tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tacan tan ra Herodes tsihin andaru cuenda ra, tsacu̱ nducu ra naha tsi ra. Tan jacunditsi̱ nuu ra naha iin jahma yahvi tan sɨɨ caá tsi ra Jesús, tumaa caá tsa tuhvá rey tsinditsí. Tacan tan jacuhu̱n nyico ra Herodes tsi ra nda nu nyaá ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tan quɨvɨ can ra Pilato tsihin ra Herodes nduvaha̱ iyó ra naha. Tyin nu quitsi̱ quɨvɨ, ña cuvi̱ nyehé tahan ra naha tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tacan tan ra Pilato jandu ii̱n ra tsi ra jutu tsa cuví ityi nuu naha ra, tan ra cumí tyiñu vehe ñuhu naha ra, tan tsihin tandɨhɨ nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tan catyí ra tsihin ñi: ―Nyooho quitsi̱ ndaca ndo tsi ra ihya nu nyaá yu. Tan catyí ndo tyin jatɨvɨ́ ra tsi nyɨvɨ. Maa tyin yuhu tsa jacutuñi̱ yu tsi ra nuu ndo. Tan nduve cuatyi ra tumaa cuhva caha̱n ndo can nañihi̱ yu. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Tan ndi ra Herodes tan ña nañihi̱ ra ndi intuhun cuatyi ra. Yacan jaquitsi̱ nyico ra tsi ra inga tsaha nu nyaá yu. Nye̱he ndo tyin nduve cuatyi ra. Tan yacan ña taahán tsi tsa cúu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yacan cuenda cua tatsi tuñi yu tsi ra. Yaha can tan cua jaña yu tsi ra ―catyí ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tacan catyí ra Pilato tyin tsitsi vico ican, taahán tsi tsa jaña ra iin ra yucú vehe caa, tumaa tuhvá maa ra icá. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Maa tyin tandɨhɨ nyɨvɨ iin caa ñi cana̱ tsaa ñi tan catyí ñi: ―Ca̱hñi tsi ra Jesús. Tan ja̱ña tsi ra Barrabás ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tan ra Barrabás can nyií ra vehe caa tsa cuenda tsa cañi̱ tahan ra tsihin ra cumí tyiñu ñuu can. Tan inga tuhun tyin tsahñi̱ ra nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tan ra Pilato cuñí ra jaña ra tsi ra Jesús. Tan quitsaha̱ caahán ra tsihin nyɨvɨ can inga tsaha tyin cua jaña ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Maa tyin nyɨvɨ tsaa ca cana̱ tsaa ñi: ―¡Tya̱a tsi ra nu cruu. Na cúu ra nu cruu! ");
INSERT INTO mjcNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","―¿Náa tsa ña vaha javaha̱ ra ihya? Tan nyehé yu tyin ña taahán tsi tsa cúu ra. Cua tatsi tuñi ñi yu tsi ra, tan cua jaña yu tsi ra ―catyí ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Maa tyin nyɨvɨ cana̱ tsaa ca ñi, tan catyí ñi tyin nacahñi ra tsi ra Jesús nu cruu. Tan maa ñi tan tsihin ra jutu tsa cuví ityi nuu naha ra, ñihi̱ ñi tsa cuñí ñi tyin cana̱ tsaa xaan ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tacan tan javaha̱ ra Pilato cuhva caha̱n ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tan jaña̱ ra tsi ra Barrabás, ra tsa nyií vehe caa tsa cuenda tsa cañi̱ tahan ra tsihin ra cumí tyiñu tan tsa cuenda tsa tsahñi̱ ra nyɨvɨ. Tan nacuhva cuenda ra Pilato tsi ra Jesús tsi ñi cuhva cuñí maa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tacan tan quihi̱n andaru tsi ra Jesús. Tan cuahán ra tsihin ra naha. Tan tɨɨ̱n tucu ra naha tsi iin ra ñuu Cirene nañí Simón. Ra ican ndi vatsí nuhu ra quee̱ ra cuhu. Tan jañiñi̱ ra naha tsi ra tsa cuiso ra cruu ra Jesús. Tan cuhun ra ityi tsata ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tan cuaha xaan nyɨvɨ cuahán ityi tsata ra Jesús. Tan cuaha xaan ñiñaha tsacú xaan ñi tsa cuiihya cuñí ñi tsacatyi tundoho taha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Maa tyin ra Jesús nanyehe̱ ra nuu ñi. Tan catyí ra tsihin ñi: ―Tandɨhɨ nyooho, ñiñaha ñuu Jerusalén ihya, ña vacu ndo tsacatyi yuhu. Va̱cu ndo, tsacatyi maa ndo tan tsacatyi sehe ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tyin cua quitsi quɨvɨ cua nyehe xaan ndo tundoho. Tan cua cahan nyɨvɨ tsi tandɨhɨ ndo tsa cuví ndo ñaha tsa ña cuví coo sehe. Tan cua cahan ñi tsihin ndo: “Vaha xaan tyin nduve sehe ndo tsicoo̱ tyin cuaha xaan tundoho nyehé yo vityin”, cua catyi ñi tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tyin quɨvɨ can cua cuñi ñi nduva yucu tsata ñi tan quɨhvɨ xeehe ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tyin tatun tyehen icá nyɨvɨ tsihin iin yutun vaha, yaha ca cuhva cua ica ñi tsihin yutun ityi ―catyí ra Jesús tsihin ñiñaha ñuu Jerusalén can. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tan quihi̱n tucu andaru can naha ra tsi uvi taahan ra iyó cuatyi, tyin cahñi ndɨhɨ ra naha tsi ra naha iin caa ñi tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tacan tan tsaa̱ ra naha iin nu nañí Yɨquɨ Jiñi Ndɨyɨ. Tan ican tyaa̱ ra naha tsi ra Jesús nu cruu. Tan tacan tyaa̱ ndɨhɨ tucu ra naha tsi nduvi taahan ra iyó cuatyi can naha ra. Iin ra tyaa̱ ra naha nuu cruu xiin cuaha ra Jesús. Tan inga ra can tyaa̱ ra naha nuu cruu xiin satyin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tan cuhva tsa nyaá ra Jesús nu cruu can, tan catyí ra: ―Tyatya, Jutu yu, ja̱ha tucahnu iñi tsi ra naha. Tyin ña tsitó ra naha náa javahá ra naha tsihin yu ―catyí ra. Tacan tan andaru can naha ra tava̱ ra naha suerte tsihin jahma ra Jesús, tyin nyehe ra naha ndáa ra cua jaha canaa jahma can. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tan nyɨvɨ nyecú ñi nyehé ñi. Tan ra cumí tyiñu vehe ñuhu naha ra, tsacú nducu ra naha nyehé ra naha tsi ra Jesús. Tan catyí ra naha: ―Jacacu̱ ra tsi inga nyɨvɨ. Na jacacu ndɨhɨ tucu maa ra tsi ra vityin, tun nditsa tsa ra Cristo, ra tsa jaquitsi̱ Nyoo, cuví ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tan juvin ñi caha̱n nyaá ra andaru can naha ra tsi ra. Tan natuhva̱ ra naha nu ticaá ra. Tan tsaha̱ ra naha vinu iya tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tan catyí ra naha tsihin ra: ―Tatun rey cuenda nyɨvɨ Israel cuví un, ja̱cacu tsi un ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tan jiñi cruu nu nyaá ra Jesús nyaá iin tsa tyaa̱ ra Pilato tsihin sahan griego, sahan latín, tan sahan hebreo. Tyehen caahán letra can: “Juvin ra ihya cuví Rey cuenda nyɨvɨ ñuu Israel” ―catyí letra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tan iin ra tsa iyó cuatyi tsa nyaá nu cruu xiin ra Jesús, quitsaha̱ caahán nyaa ra tsi ra: ―Tatun nditsa tyin ra Cristo cuví un, ja̱cacu tsi un. Tan ja̱cacu ndɨhɨ tsi nyuhu ―catyí ra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Maa tyin inga ra can catyí ra tsihin ra: ―¿A ña yuuhví un tsi Nyoo? Tyin juvin ñi tundoho tsa taahán ra ihya, tan taahán un vityin. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Maa yo nyehé yo tundoho maa tyin iyó cuatyi yo. Tan ra ihya nduve cuatyi ra iyó ―catyí ra can. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tacan tan catyí ra can tsihin ra Jesús: ―Yooho Jesús, ndu̱cuhun iñi tsi yu quɨvɨ cundaca ñaha un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tacan tan ra Jesús nacaha̱n ra tsihin ra tan catyí ra: ―Tsa nditsa caahán yu tsihin un tyin juvin ñi vityin tan cua cunyaa un tsihin yu nda paraíso nu yucú añima nyɨvɨ tsinú iñi tsi Nyoo ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tacan tan cuhva ora quitsaha̱ ndunaá nu ñuhu ñayɨvɨ, nda cuanda caa uñi tsa tseñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tyin ndunaa̱ ñicanyii. Tan jahma tsa ticaá tsitsi vehe ñuhu cahnu, ndata̱ sava tsi. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tacan tan cana̱ tsaa ra Jesús tan catyí ra: ―Tyatya, Jutu yu, tyaa cuenda yu añima yu ndaha un ―catyí ra. Tan cuhva tsa caha̱n ra tacan, tan tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tan ra cuví capitán cuenda andaru can naha ra, nyehe̱ ra tandɨhɨ tsa cuvi̱. Tan jacahnu̱ ra tsi Nyoo, tan catyí ra: ―Nduve tsa cuii cuatyi ra ihya tsicoo̱ ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tan tandɨhɨ nyɨvɨ tsa nyecú ican, nyehe̱ ñi tsa cuvi̱. Tan cuahán ñi tan quitsaha̱ cañí ndaha ñi yɨquɨ nyica ñi. Tyin tsitó ñi tyin ña vaha tsa javaha̱ ñi tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tan tandɨhɨ nyɨvɨ tsa nacotó tsi ra Jesús, tan ñiñaha tsa tsinyicu̱n tsi ra nda Galilea, nyecú ñi ndasava. Tan nyehe̱ ñi tandɨhɨ tsa cuvi̱ can. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tan iyó iin ra vaha, nañí ra José. ra ñuu Arimatea tsa canyií Judea. Tan cuví ra iin ra cuví ityi nuu cuenda Junta Cahnu nyɨvɨ Israel. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Tan ra José can ndatú ra quɨvɨ tsa cua cundaca ñaha Nyoo. Tan ña ndoo̱ ra vaha tsihin tsa javaha̱ ra cutahán tsihin ra, ra cuví jutu tsa cuví ityi nuu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tacan tan tsaha̱n ra José can tsindaca̱n ra cuñu ñuhu ra Jesús tsi ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tan yaha̱ tsa januu̱ ra José can cuñu ñuhu ra Jesús nu cruu, cava̱ nuu ra iin jahma tsi ra. Tan cuahán ra cua cutsi ra tsi ra tsitsi iin ñaña tsaa tsa cuví yavi yuu tsa javaha̱ nyɨvɨ tan ñaha ca quɨhvɨ ndɨyɨ tsitsi can. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tan viernes cuví can, quɨvɨ tsa janduvahá nyɨvɨ tsa catsi ñi tsa sabaru, quɨvɨ quitatú ñi. Tan tsa cua tahan tsi quɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tan tandɨhɨ ñiñaha tsa quee̱ tsihin ra Jesús Galilea, cuahán ñi cua nyehe ñi tsitsi yavi yuu can. Tan nyehe̱ ñi cuhva canyií cuñu ñuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tan cuanuhu̱ ñi nda yuvehe ñi. Tan janduvaha̱ ñi ndutya tami tyin cua tyihi ñi cuñu ñuhu ra Jesús. Tacan tan quitatu̱ ñi inga quɨvɨ can tumaa catyí maa tuhun tsa tsaha̱ cuenda Nyoo tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tsa tuvi̱ tumingu quɨvɨ nu quitsahá vitya, cuahán ñiñaha can nu ñaña ra Jesús. Tan nyisó ñi ndutya tami tsa janduvaha̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tan cuhva tsa tsaa̱ ñi, nyehe̱ ñi tyin tsa cuatsiyo̱ yuu tsa ndasɨ́ yuhu ñaña can. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tan quɨhvɨ̱ ñi tsitsi ñaña can, maa tyin ña nañihi̱ ñi cuñu ñuhu Jutu Mañi yo Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tan yucú ñi tsihin tsa yuuhví ñi. Tan ña tsitó ñi náa cua javaha ñi. Tan sana iñi ñi quituvi̱ uvi taahan rayɨɨ nuu ñi. Tan xiñu xaan jahma nditsí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tan tsihin tsa yuuhví ñi, tan tsaqui̱n ñi jiñi ñi nda nu ñuhu. Tacan tan catyí ra can naha ra tsihin ñi: ―¿Nacuenda nanducú ndo tsi ra nyito nu yucú ndɨyɨ? ");
INSERT INTO mjcNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nduve ca ra nyií ihya, tyin tsa nandoto̱ ra. Ndu̱cuhun iñi ndo tsa caha̱n ra tsihin ndo quɨvɨ tsica̱ ra Galilea. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Catyi̱ ra tyin taahán tsi nacuhva cuenda nyɨvɨ tsi ra ndaha ra iyó cuatyi naha ra. Tyin cuví ra Rayɨɨ tsa quee̱ nda gloria. Tan taahán tsi tyin cahñi ra can naha ra tsi ra nu cruu. Maa tyin tsa tsinu uñi quɨvɨ cua nandoto ra. Tacan catyi̱ ra tsihin ndo ―catyí ángel can naha ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tacan tan nducuhu̱n iñi ñi tsa caha̱n ra Jesús quɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tan cuanuhu̱ ñi. Tan nacatyi̱ tuhun ñi tsihin tsa utsi iin ra tsa tava̱ tyiñu ra Jesús tan tsihin tandɨhɨ ca nyɨvɨ tsa tsinyicu̱n tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tan ñiñaha tsa tsicatyi̱ tuhun tsihin ra naha cuví ñi: ña María Magdalena, ñaha quee̱ Magdala, tan ña Juana, tsihin ña María sɨhɨ ra Jacobo, tan tsihin juhva ca ñiñaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Maa tyin ra tava̱ tyiñu ra Jesús cuñí maa ra naha tyin caahán ñi maa ñi. Tan ña tsinú iñi ra naha tsa caahán ñi. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Maa tyin ra Pedro nduvita̱ ra tan tsinú xaan ra cuahán ra cua nyehe ra tsitsi ñaña nu tinyii̱ ra naha ra Jesús tatun nditsa. Tan nyehe̱ ra tsitsi yavi yuu can tyin jahma tsa tsindasɨ̱ ña ra canyií nda sava. Tacan tan cuanuhu̱ ra yuvehe nu yucú tandɨhɨ ca ra naha. Tan iyo xaan cuñí ra tsa cuvi̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Juvin ñi maa quɨvɨ can, uvi taahan ra tsinyicu̱n tsi ra Jesús cuahán ra naha ñuu Emaús, tumaa utsi iin kilómetro tsa queé yo ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tan cuahán ra naha tan natuhún tahan ra naha náa ndɨhɨ tsa cuvi̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tan tsitsi tsa natuhún ra naha, tan ra Jesús taha̱n ra tsi ra naha ityi cuahán ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Maa tyin vasu nyehé ra naha tsi ra Jesús, maa tyin ña nacotó ra naha tsi ra. Tyin tumaa iin tsa tyasɨ́ tsi nuu ra naha, tan ña cuví nacoto ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tacan tan nducu̱ tuhun ra Jesús tsi ra naha: ―¿Náa natuhún xaan ndo? ¿Nacuenda cuiihya xaan cuñí ndo? ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tan iin ra tsa nañí Cleofas nacaha̱n ra tan catyí ra: ―Tandɨhɨ nyɨvɨ tsitó tsa cuvi̱ ñuu Jerusalén. ¿A ra inga ñuu cuví yooho tyin ña tsito̱ un tsa cuvi̱? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tacan tan catyí ra Jesús tsihin ra naha: ―¿Náa cuvi̱? Tan nacatyi̱ tuhun ra naha tsihin ra: ―Tuhun ra Jesús ra ñuu Nazaret. Tyin cuvi̱ ra iin ra cuvi̱ ndusu yuhu Nyoo. Tan tsihin tunyee iñi cahnu Nyoo javaha̱ ra tsa cahnu tan caha̱n ra tsa vaha nuu Nyoo tan nuu tandɨhɨ nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Maa tyin ra jutu tsa cuví ityi nuu naha ra tan ra cumí tyiñu cuenda vehe ñuhu, tsaha̱ cuenda ra naha tsi ra tsi ra ndacá ñaha cuenda ñuu Roma. Tan tsahñi̱ ra naha tsi ra. Tan tsihi̱ ra nu cruu. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tan vityin tsa quita̱ uñi quɨvɨ tsa cuvi̱ yacan. Tan nyuhu cuñí maa ndi tyin juvin ra cua jacacu tsi yo tsa cuví yo nyɨvɨ Israel. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Maa tyin vityin iyo xaan cuñí ndi tsa nacatyi̱ juhva ñiñaha tsihin ndi. Tyin maa ñi tsaha̱n ñi nu ñaña ra tsa tuvi̱. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tan nduve ca cuñu ñuhu ra canyií. Tan nacatyi̱ tuhun ndɨhɨ ñi tyin nyehe̱ ñi uvi taahan ángel. Tan catyí ángel can naha ra tsihin ñi tyin ra Jesús nyito ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yaha̱ yacan tan tsaha̱n tucu juhva ra cutahán tsihin ndi tsinyehe̱ ra naha nu ñaña. Tan nyehe̱ ra naha tyin tsa nditsa cuví tsa caha̱n ñiñaha can. Maa tyin ña nyehe̱ ra naha tsi ra Jesús ―catyí ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tacan tan catyí ra Jesús tsihin ra naha: ―Luxu xaan cutuñí iñi ndo. Tan cuee xaan tan tsinu iñi ndo tuhun tsa caha̱n ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿A ña tsitó ndo tyin taahán tsi tsa nyehe̱ jihna ra Cristo tundoho? Yaha can tan tahan tsi cua ñihi ra tyiñu tsa cua cundaca ñaha ra ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tacan tan quitsaha̱ tsahá cuenda ra nácaa cuahán tuhun maa ra nu tutu Nyoo. Tan quitsaha̱ caahán ra tuhun tsa tyaa̱ ra Moisés taha̱n tsanaha. Tan yaha̱ can tan caha̱n ra tuhun tandɨhɨ libru tsa tyaa̱ ra cuvi̱ ndusu yuhu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tan cuhva tsa tsaa̱ ra naha nda ñuu Emaús, nu cuahán ra naha, tan jahá ra Jesús tyin cañi ca cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tacan tan catyí ra naha tsihin ra na ndoo ra tsihin ra naha. Tan catyí ra naha: ―Ndo̱o tsihin ndi tyin tsa cua cuiso ñicanyii ―catyí ra naha. Tacan tan cuahán ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tan cuhva tsa tsinyaa̱ ra yuhu mesa tsihin ra naha, quihi̱n ra paan. Tan tsaha̱ ra tyahvi nyoo tsi Nyoo. Tan tsahnu̱ sava ra, tan tsaha̱ ra tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tan iin yaha ñi nuña̱ nuu ra naha tan nacoto̱ ra naha tsi ra Jesús. Maa tyin ra Jesús naa̱ ihñi ñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tacan tan quitsaha̱ natuhún tahan ra naha tan catyí ra naha: ―Yacan cuenda vaha xaan cuñí añima yo tsa vatsí ra tsihin yo, tan tsahá cuenda ra tuhun Nyoo tsa nyaá nu tutu Nyoo tsi yo ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ña ndatu̱ ca ra naha, tan cuanuhu̱ ra naha nda ñuu Jerusalén. Tan ñihi̱ tahan ra naha tsihin tsa utsi iin ra tsa tava̱ tyiñu ra Jesús, ndu ii̱n ra naha tsihin juhva ra nyecú tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tacan tan tsa utsi iin ra can naha ra nacatyi̱ tuhun ra naha tsihin ra tsa ndi tsaa̱ can naha ra: ―Nditsa tyin Jutu Mañi yo nandoto̱ ra. Tyin ra Simón nyehe̱ ra tsi ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tacan tan ra tsa ndi tsaa̱ can nacatyí tuhun ndɨhɨ ra naha nácaa natuhu̱n ra Jesús tsihin ra naha ityi cuahán ra naha ñuu Emaús, tan nácaa nacoto̱ ra naha tsi ra nu tsahnu̱ sava ra paan. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ndi natuhún ca ra naha yacan tan quituvi̱ ra Jesús tyañu ra naha. Tan tsaha̱ ra nacumi tsi ra naha, tan catyí ra: ―Na coo tsa vaha añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tacan tan nayuhvi̱ xaan ra naha. Tan cuñí ra naha tyin tatyi ndɨyɨ cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tacan tan catyí ra Jesús tsihin ra naha: ―¿Nacuenda yuuhví xaan ndo? ¿Tan nacuenda tsicá xaan iñi ndo? ");
INSERT INTO mjcNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nye̱he ndo ndaha yu. Tan nye̱he ndo tsaha yu. Tyin juvin ñi maa yu cuví. Tɨ̱ɨn ndo tsi yu tan co̱to ndo. Tyin tatyi ndɨyɨ nduve cuñu ñuhu can iyó. Tan nduve yɨquɨ can tumaa tsa nyehé ndo tsi yuhu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tan cuhva tsa caha̱n ra yacan, tan janaha̱ ra ndaha ra tsihin tsaha ra tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Maa tyin maa ra naha, tsa cuenda tsa iyo cuñí ra naha tan sɨɨ cuñí ra naha, nda cuanda ña cuví ca tsinú vaha iñi ra naha. Yacan nacaha̱n ra Jesús tsihin ra naha: ―¿A iyó tsa catsi yo? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tacan tan tsaha̱ ra naha luxu tyaca tyihyo tsihin ndutya ñuñu tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tan quihi̱n ra. Tan quitsaha̱ tsatsí ra nu nyecú ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tan catyí ra tsihin ra naha: ―Tandɨhɨ tsa taha̱n yu, yacan cuví tsa catyi̱ yu tsihin ndo quɨvɨ can. Tan catyi̱ yu tsihin ndo tyin tacan cua cuvi, tumaa cuhva nyaá tuhun tsa tyaa̱ ra Moisés tan ra cuvi̱ ndusu yuhu Nyoo tan tsihin tsa nyaá nu libru salmo ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tacan tan tsaha̱ cuenda ra Jesús cuhva catyí nu tutu Nyoo. Tan cutuñi̱ iñi tandɨhɨ ra naha jaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tacan tan catyí ra Jesús tsihin ra naha tyin tacan nyaá nu tutu Nyoo tyin taahán tsi tsa cúu ra Cristo. Tan tsa tsinu uñi quɨvɨ cua nandoto ra. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tan taahán tsi coto nyɨvɨ tuhun ra Cristo, tyin tatun ndu uvi iñi ñi cuatyi ñi, cua coo tucahnu iñi tsi ñi. Tan jihna ñi cua cahan ra naha tsihin sɨvɨ ra Cristo ñuu Jerusalén, yaha can tan tandɨhɨ ca ñuu tanɨɨ cahnu nu ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tan catyí tucu ra Jesús tsihin ra naha: ―Tan nyooho cuví tsandaa tsa cuenda tandɨhɨ tsehe. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tan cua jaquitsi maa yu Tatyi Ii Nyoo sɨquɨ ndo tumaa tsa catyi̱ Jutu yu tyin cuhva ra tsi ndo. Maa tyin ndo̱o ndo Jerusalén ihya. Tan ña qu̱ita ndo nda cuanda tsa ñihi ndo tunyee iñi Nyoo tsa cua quitsi tsi ndo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tacan tan ra Jesús cuahán ra tsihin tandɨhɨ ra tsica̱ tsihin ra nda ñuu Betania. Tan cañihi̱ ra ndaha ra. Tan nasoco̱ ra tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tan tsitsi tsa nasocó ra tsi ra naha, nandaa̱ ra andɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tacan tan tandɨhɨ ra naha quitsaha̱ jacahnú ra naha tsi ra. Tan sɨɨ xaan cuñí ra naha, cuanuhu̱ ra naha nda ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tan tandɨhɨ quɨvɨ tsiyucu̱ ra naha tsitsi vehe ñuhu cahnu, jacahnú xaan ra naha tsi Nyoo. Tan na cuvi tsi tacan ñi.");
INSERT INTO mjcNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nda quɨvɨ jihna ñi, nda ndi cumañi ca coo tandɨhɨ tsa iyó, tan tsa iyó maa ra cuví Tuhun tsa Caahán Nyoo. Nyií ra tsihin Nyoo. Tan Nyoo cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tan iyó ra tsihin Nyoo nda quɨvɨ jihna ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tan tsihin ra, javaha̱ Nyoo tandɨhɨ cuii maa tsa iyó. Tan nduve tsa javaha̱ Nyoo tsa intuhun ñi maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ra tsa cuví Tuhun tsa Caahán Nyoo iyó ñayɨvɨ nyito tsa ña cua naa maa tsi ra. Tan juvin ñayɨvɨ can, cuví ñuhu̱ tsa jandunditsín añima nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tan ñuhu̱ can, jandunditsín tsi nu naa. Tan tsa naa can ña cuví jandahva can ñuhu̱ nditsin can. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tsicoo̱ iin ra tsa jaquitsi̱ Nyoo, nañí ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Quitsi̱ ra cuvi̱ ra tsa ndaa. Tyin caha̱n ra tumañi iñi cuenda ra cuví ñuhu̱ can, tyin tacan tan tsinu iñi tandɨhɨ nyɨvɨ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ra Juan, ñavin ñuhu̱ can cuví ra. Iin tsa ndaa cuenda ra cuví ñuhu̱ can cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tyin ñuhu̱ nditsa can, ndi cua quitsi tsi nu ñuhu ñayɨvɨ, tan cua jandunditsín tsi añima tandɨhɨ nyɨvɨ tsa iyó nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ra cuví Tuhun tsa Caahán Nyoo quitsi̱ ra nu ñuhu ñayɨvɨ. Tan juvin ñi maa ra tsihin Jutu ra javaha̱ ra naha ñuhu ñayɨvɨ. Maa tyin nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya, ña nacoto̱ ñi tsi ra tsa ra Cristo cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Quitsi̱ ra nu iyó nyɨvɨ ñuu ra, nyɨvɨ Israel, tan ña naquihi̱n vaha ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Maa tyin tandɨhɨ nyɨvɨ tsa naquihi̱n vaha tsi ra, tan tsinú iñi ñi tyin ra Cristo cuví ra, tsaha̱ ra ndatu tsi ñi tsa cuví ñi sehe Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Juvin ñi nacacu̱ tsaa. Maa tyin ñavin tumaa tsa cacu̱ ñi tsa culee̱ ñi cuenda cuñu ñuhu ñi. Tan ndi ñavin tsa cuenda tsa cuñí iin rayɨɨ coo ra tsihin iin ñaha. Ñavin tsa cuenda tsa cuñí nyɨvɨ coo sehe ñi. Maa tyin nacacu̱ tsaa ñi jaha̱ maa Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tan ra cuví Tuhun tsa Caahán Nyoo nanduvi̱ ra iin rayɨɨ. Tan tsicoo̱ ra tsihin yo. Tan nyehe̱ ndi tsa cahnu cuví ra. Tan cahnu cuví ra tyin Sehe mañi Jutu Nyoo cuví tsi ra. Tsitu̱ ra tsihin tsa nditsa tan tsa vaha. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Tan ra Juan can caha̱n ra tumañi iñi tsa cuenda ra, tan catyí ra: ―Juvin ra ihya cuví ra tsa caha̱n yu tuhun quɨvɨ can, tyin ra tsa vatsí ityi tsata yu, cahnu ca cuví ra tan ñavin ca maa yu. Tyin nda quɨvɨ cacu̱ yu tan tsa iyó maa ra ―catyí ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tandɨhɨ yo naquihín yo tumañi iñi cahnu tsa tsahá ra tsi yo, tyin nasocó xaan ra tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ra Moisés tsaha̱ cuenda ra ley Nyoo tsi yo. Maa tyin ra Jesucristo tsahá ra tsa naquihin yo tsa vaha Nyoo. Tan caahán ra tsa nditsa tsihin yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tan nduve maa yóo nyehé tsi Nyoo. Intuhun ñi maa Sehe mañi maa ra tsa iyó iin caa ñi tsihin ra nyehé tsi ra. Juvin ra cuví ra tsa tsahá tsa coto yo tsi Jutu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ra cuví ityi nuu tsihin nyɨvɨ Israel tsa iyó ñuu Jerusalén, tava̱ tyiñu ra naha tsi ra jutu naha ra tsihin inga ca ra cuenda vehe ñuhu naha ra, ra cuví tata ra Leví, na cuhun ra naha nu nyií ra Juan tan ndaca tuhun ra naha tsi ra yóo ra cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tan tsica̱ tuhun ra naha tsi ra Juan tan catyí ra tsihin ra naha: ―Yuhu ñavin ra Cristo ra tsa cua jaquitsi Nyoo cuví yu ―catyí ra tan ña tyihi̱ xeehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tacan tan tsica̱ tuhun nyico ra naha tsi ra Juan: ―¿Yóo ra cuví un? ¿A ra Elías, ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha cuví un? ―catyí ra naha tsihin ra. Tan ra Juan nacahan ra: ―Ñavin ra ican cuví yu. Tan cuñihi̱ ca ra naha tsica̱ tuhun ra naha tsi ra, tan catyí ra naha: ―Tun tacan, ¿a ra cuví ndusu yuhu Nyoo tsa nyaá tsa cua quitsi cuví un? Tan nacaha̱n nyico ra Juan tan catyí ra: ―Ñavin. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tan tsica̱ tuhun nyico ra naha tsi ra Juan inga tsaha: ―¿Yóo ra cuví un? Tyin cuñí tsi catyi tuhun ndi tsihin ra tsa tava̱ tyiñu tsi ndi yóo ra cuví un ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tan nacaha̱n ra Juan: ―Yuhu cuví ndusu iin ra tsa cana tsaá nu tsɨquɨ, tsa catyí: “Nu̱ña ndo tsitsi añima ndo tyin tsa vatsí Jutu Mañi yo.” Tumaa caha̱n ra Isaías ra cuvi̱ ndusu yuhu Nyoo tuhun yu taha̱n tsanaha ―catyí ra Juan tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ra fariseo naha ra cuví ra tava̱ tyiñu tsi ra can naha ra, na ndaca tuhun ra naha tsi ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tan tsica̱ tuhun nyico ra naha tsi ra: ―Tatun ñavin ra Cristo, ra tsa cua jaquitsi Nyoo cuví un, ¿nacuvi tyin jacoondutyá un tsi nyɨvɨ? tan ndi ñavin ra Elías cuví un, tan ndi ñavin ra cuví ndusu yuhu Nyoo cuví un ―catyí ra naha tsihin ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tan nacaha̱n ra Juan tan catyí ra: ―Yuhu jacoondutyá yu tsi nyɨvɨ tsihin ndutya. Maa tyin mahñu ndo nyií iin ra tsa ña nacotó ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tan cahnu ca cuví ra can tan ñavin ca yuhu. Ña cahnu cuví yuhu ndi tsa cuví yu musu ra tan cuvi ndatsi yu ñɨɨ nditsan ra ―catyí ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tandɨhɨ yacan cuvi̱ nu nañí Betábara tsa canyií inga tsiyo yutya cahnu Jordán nu tsinyii̱ ra Juan jacoondutya̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tsa inga quɨvɨ nyehe̱ ra Juan tsi ra Jesús cuahán ra nu nyií ra, tacan tan catyí ra Juan: ―Nye̱he jihna ndo, ra ihya cuví Mbee Ticatyi Luhlu jana Nyoo ra tsa quihín nyaa cuatyi nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tuhun ra caha̱n yu quɨvɨ catyi̱ yu tsihin ndo tyin ityi tsata yu vatsí inga ra tsa cahnu ca cuví tan ñavin ca maa yu, tyin tsa iyó maa ra tan tsicoo̱ yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ndi yuhu tan ña nacoto̱ yu tsi ra quɨvɨ can. Maa tyin vityin vatsí yu jacoondutyá yu tsihin ndutya tyin tacan tan nacoto nyɨvɨ Israel ñuu yu tsi ra ―catyí ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tan catyí nyico ra Juan: ―Yuhu nyehe̱ yu Tatyi Ii Nyoo tsa quitsi̱ ityi andɨvɨ tan quitsi̱ tsi tumaa iin paloma, tan ndoo̱ tsi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yuhu ñaha ca nacoto yu yóo ra cuví ra quɨvɨ can. Maa tyin Nyoo, ra tsa tava̱ tyiñu tsi yu jacoondutya yu tsi nyɨvɨ tsihin ndutya, catyi̱ ra tsihin yu: “Quɨvɨ nyehe un Tatyi Ii, vatsí nuú tsi sɨquɨ iin rayɨɨ, tan ndoo tsi tsihin ra, juvin ra can cuví ra tsa cua jacoondutya tsi nyɨvɨ tsihin Tatyi Ii yu”, catyi̱ Nyoo tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yuhu tsa yaha̱ nyehe̱ yu tsi ra. Tan cuví yu tsa ndaa tyin juvin ra cuví Sehe Nyoo ―catyí ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tsa inga quɨvɨ nyií nyico ra Juan nu nyií ra tan yucú ndɨhɨ uvi taahan ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tan nyehe̱ ra naha, yahá ra Jesús, tan catyí ra Juan: ―Nye̱he jihna ndo, ra ican cuví Mbee Ticatyi Luhlu jana Nyoo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tsa tsiñi̱ nduvi taahan ra nyicún tsi ra Juan tsa caha̱n ra, tacan tan cuahan ra naha cuanyicun ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tacan tan nanyehe̱ ra Jesús ityi tsata ra, tan nyehe̱ ra tyin nyicún ra naha tsi ra, tan catyí ra: ―¿Náa nanducú ndo? Tacan tan nacaha̱n ra naha tan catyí ra naha: ―Maestro, ¿numaa iyó un? ");
INSERT INTO mjcNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tan catyí ra Jesús tsihin ra naha: ―Co̱hon ndo tsihin yu, tan nyehe ndo ―catyí ra tsihin ra naha. Tacan tan cuahán ra naha tsihin ra. Tan nyehe̱ ra naha nu iyó ra. Tan ican yucu ra naha tan cuaa, tyin tsaa̱ ra naha ndacan tumaa caa cumi tsa tseñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Iin ra tsa tsiñi̱ tsa caha̱n ra Juan tan tsinyicu̱n ra tsi ra Jesús ra ican cuví ra Andrés, yañi ra Simón Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tan ra Andrés numi xaan tsinanducu̱ ra tsi yañi ra, ra Simón Pedro, tan catyí ra tsihin ra: ―Nañihi̱ ndi tsi ra tsa cuví Mesías ―catyí ra. Tan tuhun Mesías can cuñí tsi catyí, ra Cristo, o cuñí tucu tsi catyí, ra tsa nacatsi̱ vaha Nyoo tyin quitsi ra cuvi ra rey tsa cuenda yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tacan tan quihi̱n ra Andrés tsi ra Simón yañi ra cuahán tsihin ra nu nyií ra Jesús. Tsa nyehe̱ ra Jesús tsi ra Simón, tan catyí ra tsihin ra: ―Yooho Simón, sehe ra Jonás cuví tsi un. Maa tyin cua cunañi un Cefas ―catyí ra tsihin ra. Tan Cefas cuví tsi yuhu griego, tan cuñí tsi catyí tsi “Pedro”, tan tsa nduvi sɨvɨ can, cuñí tsi catyí tsi “cava”, tumaa iin yuu cahnu. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tsa inga quɨvɨ tyaa̱ ra Jesús cuhva tsa cuhun ra Galilea. Tacan tan nañihi̱ ra tsi ra Felipe. Tan catyí ra tsihin ra: ―Na̱ha qu̱itsi nyicun un tsi yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ra Felipe ihya, ra ñuu Betsaida cuví ra. Tan ican iyó tucu ra Andrés tan ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tacan tan tsaha̱n ra Felipe tsinanducu̱ ra tsi ra Natanael. Tan catyí ra tsihin ra: ―Nyehe̱ ndi tsi ra tsa tyaa̱ ra Moisés tuhun nu libru ley Nyoo, ra tsa caha̱n tucu ra cuvi̱ ndusu yuhu Nyoo tuhun taha̱n tsanaha. Tan nañí ra Jesús. Sehe ra José ra ñuu Nazaret cuví tsi ra ―catyí ra Felipe tsihin ra Natanael. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tan catyi̱ ra Natanael: ―¿A cuví quita tsa vaha ñuu Nazaret can? ―catyí ra tsihin ra Felipe. Tan nacaha̱n ra Felipe tan catyí ra: ―Na̱ha tan nye̱he un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tacan tan tsa cua cuyatyin ra Natanael nu nyií ra Jesús. Tan nanyehe̱ ra Jesús tyin vatsí ra, tan quitsaha̱ catyí ra: ―¡Jihna ndo! Ihya vatsí iin ra tsa nditsa nditsa tyin ra ñuu Israel cuví ra, tyin ña tuhvá ra jandaví ñaha ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tacan tan tsica̱ tuhun ra Natanael tsi ra: ―¿Nacaa tsa tsitó un tsi yuhu? Tan nacaha̱n ra Jesús tan catyí ra: ―Yuhu tsa nyehe̱ maa yu tsi un tsa ndi cumañi ca cana ra Felipe tsi un, tsa ndi nyií un tsaha yutun higo can ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tacan tan quitsaha̱ catyí ra Natanael: ―Jutu Mañi yu, yooho cuví Sehe Nyoo. Tan juvin un cuví rey cuenda nyuhu tsa cuví yo nyɨvɨ Israel. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tan catyí ra Jesús tsihin ra Natanael: ―¿A tsinú iñi un tsi yu tsa cuenda tyin catyí yu tyin nyehe̱ yu tsi un tsaha yutun higo? Maa tyin nahnu ca tsa cua nyehe un tan ñavin ca yacan ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tan catyí ra Jesús tsihin ra naha: ―Tsa nditsa catyí yu tsihin ndo tyin nyooho cua nyehe ndo cua nuña andɨvɨ tan cuaha xaan ángel Nyoo cua ndaa, tan cua nuu ra naha sɨquɨ yuhu Rayɨɨ tsa quee̱ nda gloria ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tsa yaha̱ uñi quɨvɨ tan tsicoo̱ iin vico tindaha ñuu Caná tsa canyií Galilea. Tan ican nyií sɨhɨ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tan nyɨvɨ javaha̱ vico can cana̱ ndɨhɨ ñi tsi ra Jesús tan tsihin tandɨhɨ ra tsicá tsihin ra tyin cuhun ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tacan tan cuahán ra naha. Tan tsitsi tsa yucú ra naha nu iyó vico can, tan ndɨhɨ̱ vinu ñi javaha̱ vico can. Tacan tan catyí sɨhɨ ra Jesús tsihin ra: ―Nduve ca vinu ñi ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tan catyí ra Jesús tsihin ña: ―¿Náa tsa ndɨhɨ iñi yo yacan, Miyan? Tyin ñaha ca tsaa hora yu ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Maa tyin sɨhɨ ra caha̱n ña tsihin ra tsa tyihí mesa nu iyó vico can naha ra: ―Ja̱vaha nyooho tandɨhɨ tsa cua cahan ra tsihin ndo ―catyí ña tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tan nyecú iñu quɨsɨ yuu nahnu tsa yɨhɨ́ ndutya tsa tuhvá ra Israel naha ra tsatyiñú nu nacatyá xaan ra naha ndaha ra naha cuhva tsa iyó maa ra naha. Tan intuhun intuhun quɨsɨ can tsitahan uvi xico utsi, a uñi xico utsi, litru ndutya tsitsi can. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tacan tan catyí ra Jesús tsihin ra tsa tyihí mesa can naha ra: ―Ja̱cutu ndo quɨsɨ ihya tsihin ndutya ―catyí ra tsihin ra naha. Tacan tan tsitu̱ cuii quɨsɨ can jaha̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tacan tan catyí ra Jesús tsihin ra naha: ―Vityin ta̱va ndo juhva tan cu̱ndaca ndo tsi ra cuví ityi nuu cuenda vico ihya ―catyí ra Jesús tsihin ra naha. Tan tacan ica̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ra cuví ityi nuu cuenda vico can tsihi̱ ra naha ndutya tsa nanduvi̱ vinu. Maa tyin ña tsitó ra naha nu maa quee̱ can. Maa ñi maa ra tsa tyihí mesa can naha ra tsitó, tyin maa ra naha tava̱ ndutya can. Tacan tan ra cuví ityi nuu cuenda vico can cana̱ ra tsi ra tsa tandaha can. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Tan catyí ra tsihin ra: ―Tandɨhɨ nyɨvɨ, jihna ca vinu vaha tuhvá ñi tava. Yaha can tan tatun tsa tsihi̱ xaan nyɨvɨ, tacan tan tava ñi vinu ndaahvi. Maa tyin yooho tsicumi̱ vaha un vinu vaha. Tan nda vityin tava̱ un can ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tsa javaha̱ ra Jesús ñuu Caná tsa canyii Galilea, yacan cuví tsa iyo tsa jihna ñi javaha̱ ra tan janaha̱ ra tsa cahnu cuví ra tsi nyɨvɨ. Tan ra tsicá tsihin ra tsinu̱ iñi ra naha tsi ra tyin ra ican cuví ra tsa jaquitsi̱ Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsa yaha̱ yacan tan cuahán ra ñuu Capernaum tsihin sɨhɨ ra tan tsihin yañi ra. Tan cuahan ndɨhɨ ra tsicá tsihin ra. Tan ican tsiyucu̱ ñi juhva quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tsa cua tahan tsi quɨvɨ vico pascua tsa jacahnú nyɨvɨ Israel. Yacan cuenda cuahán ra Jesús ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tsa tsaa̱ ra ñuu can, quɨhvɨ̱ ra nuquehe vehe ñuhu cahnu, tan nyehe̱ ra yucú cuaha nyɨvɨ xicó ñi nuquehe can. Yɨhɨ́ ñi xicó ñi indɨquɨ, mbee ticatyi, tan paloma. Tan yucú ndɨhɨ tucu nyɨvɨ nasamá xuhun. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tsa nyehe̱ ra Jesús tandɨhɨ yacan, tacan tan javaha̱ ra iin yoho. Tan tsihin yoho can jacunu̱ ra tsi tandɨhɨ nyɨvɨ nuquehe vehe ñuhu iin cahnu ñi tsihin mbee tan tsihin indɨquɨ jana ñi. Tan ñi nasamá xuhun can, jatucuatyi̱ ra xuhun ñi nu ñuhu tan janduva̱ ra mesa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tan catyí ra tsihin ñi xicó paloma: ―¡Ta̱va ndo paloma can ihya! ¡Ña ja̱vaha ndo vehe Jutu yu tumaa iin nuyahvi! ―catyí ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tacan tan ra tsicá tsihin ra, nducuhu̱n iñi ra naha tsa catyí nu tutu Nyoo tyehen: “Cuiñu xaan yu vehe un”, catyí tsi, nducuhu̱n iñi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tacan tan ra cuví ityi nuu tsihin nyɨvɨ Israel quitsaha̱ tsicá tuhun ra naha tsi ra Jesús: ―¿Náa seña javaha un nyehe ndi tan janaha un tyin nditsa tsa tsaha̱ Nyoo ndatu tsi un tsa javaha un yacan? ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tan nacaha̱n ra Jesús tan catyí ra: ―Ca̱nɨ ndo vehe ñuhu ihya, tan tsitsi tsa uñi quɨvɨ ñi tan cua janduvita nyico yu itsi inga tsaha ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tacan tan quitsaha̱ catyí ra nyecú ican naha ra tsihin ra: ―Uvi xico iñu cuiya jaha̱ tyiñu ra naha tan tsinu̱ vehe ñuhu ihya. ¡Tan yooho catyí un tyin tsitsi tsa uñi quɨvɨ ñi tan cua janduvita un itsi inga tsaha! ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Maa tyin ñavin tuhun vehe ñuhu can caha̱n ra Jesús, tyin caha̱n ra tuhun cuñu ñuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yacan cuenda tandɨhɨ ra tsicá tsihin ra nducuhu̱n iñi ra naha yacan quɨvɨ nandoto̱ ra. Tan cutuñi̱ iñi ra naha tyin tuhun tsa nyaá nuu tutu Nyoo caahán tsi cuenda ra Jesús. Tan tsinu̱ iñi ra naha tsa caha̱n ra Jesús tan tsa nyaá nu tutu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tsitsi tsa ndi nyií ra Jesús ñuu Jerusalén, quɨvɨ iyó vico pascua, cuaha xaan nyɨvɨ quitsaha̱ tsinú iñi tsa caahán ra tsa cuenda tsa cuaha tsa iyo javaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Maa tyin ra Jesús ña nɨɨ cuñí ra nyehé ra tsi tandɨhɨ ñi tyin tsitó ra cuhva tsicá iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ña tsiñiñuhu̱ tsa nacatyi tuhun yo tsihin ra nácaa iyó nyɨvɨ, tyin tsa tsitó maa ra náa iyó tsitsi añima yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tsicoo̱ iin ra cuví fariseo tsa nañí Nicodemo. Tan cuví ra iin ra cuví ityi nuu tsihin ra Israel naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ra Nicodemo ihya, tsaha̱n ra nu nyií ra Jesús iin tsacuaa. Tan catyí ra tsihin ra: ―Maestro, tsitó ndi tyin Nyoo tava̱ tyiñu tsi un tsa quitsi un jacuaha un tsi ndi. Tyin yoñi nyɨvɨ tan cuví javaha ñi tsa iyo tsa javahá un, tatun nduve Nyoo iyó tsihin ñi ―catyí ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tacan tan catyí ra Jesús tsihin ra: ―Tsa nditsa catyí yu tsihin un tyin tatun ña cua nacacu tsaa nyɨvɨ inga tsaha, ña cua cuvi nyehe ñi nu ndacá ñaha Nyoo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tacan tan tsica̱ tuhun ra Nicodemo tsi ra Jesús tan catyí ra tsihin ra: ―¿Nacaa cuví cacu iin rayɨɨ inga tsaha tatun tsa tsahnu ra? ¿A cuví quɨhvɨ nyico ra tsitsi sɨhɨ ra tan nacacu tsaa ra inga tsaha? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nacaha̱n ra Jesús tan catyí ra: ―Tsa nditsa catyí yu tsihin un tyin ñavin tsihin tsa cacu nyɨvɨ tsihin cuñu ñuhu ñi tan cuví quɨhvɨ ñi nu ndacá ñaha Nyoo. Maa tyin ñiñi xaan cuñí tsi nacacu tsaa ñi tsihin Tatyi Ii Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tyin nyɨvɨ cacu̱ tsihin cuñu ñuhu, cuñu ñuhu ñi cuví ñi. Tan nyɨvɨ nacacu̱ tsaa tsihin Tatyi Ii Nyoo, Tatyi Ii Nyoo iyó añima ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ña cu iyo iñi un tsa caahán yu tsehe tsihin un tyin tandɨhɨ nyɨvɨ cuñí tsi nacacu tsaa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tumaa tsa yɨhɨ́ tatyi tandɨhɨ ñi ityi tan tsiñí un cucayú vatsí tsi, maa tyin ña tsitó un numaa ityi quee̱ tsi, tan ndáa ityi cuahán tsi; tacan cuví tandɨhɨ nyɨvɨ nacacu̱ tsaa tsihin Tatyi Ii Nyoo ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tacan tan nducu̱ tuhun nyico ra Nicodemo tsi ra inga tsaha tan catyí ra: ―¿Nacuenda caahán un tacan? ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nacaha̱n ra Jesús tan catyí ra: ―Yooho tsa cuví un maestro cuenda nyɨvɨ Israel, taahán tsi coto un tsehe. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tsa nditsa catyí yu tsihin un tyin caahán ndi tsa tsitó ndi tan cuví ndi tsa ndaa tsa cuenda tsa nyehe̱ ndi. Maa tyin nyooho ña tsinú iñi ndo tsa caahán ndi tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tatun ña tsinú iñi ndo tsa caahán yu tuhun nu ñuhu ñayɨvɨ ihya tsihin ndo, ¿nácaa cua tsinu iñi ndo tatun cua cahan yu tuhun gloria tsihin ndo? ");
INSERT INTO mjcNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Yoñi tsaha̱n gloria tsinyehe̱ nácaa iyó. Intuhun ñi maa yuhu Rayɨɨ tsa quee̱ nda gloria nyehé yu nácaa iyó gloria, tyin ndacan quee̱ yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tumaa tsa ticaa̱ ra Moisés iin coo tsa tsinu̱ tsihin caa nu yutun iin nu tsɨquɨ, tacan cua ticaa nyɨvɨ tsi yuhu Rayɨɨ tsa quee̱ nda gloria nuu cruu. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Tacan tan tandɨhɨ nyɨvɨ tsa tsinú iñi tsi yu, ña cua cunaa ñi. Tan cua coo ñi ñayɨvɨ nyito tsa ña cua naa maa. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Nyoo cuñí xaan ra tsi tandɨhɨ nyɨvɨ iyó nu ñuhu ñayɨvɨ. Yacan cuenda tsaha̱ ra tsa cúu Sehe mañi ra nu cruu tsa cuenda ñi. Tyin tacan tan tandɨhɨ ñi tsa tsinú iñi tsi Sehe ra, ña cunaa ñi, tan coo ñi ñayɨvɨ nyito tsa ña cua naa maa. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tyin Nyoo jaquitsi ra tsi Sehe ra nu ñuhu ñayɨvɨ tyin jacacu ra tsi nyɨvɨ, tan ña jaquitsi ra tsi ra tsa jacunaa ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Yacan cuenda nyɨvɨ tsa tsinú iñi tsi yu tsa cuví yu Sehe Nyoo ña cua cunaa ñi, maa tyin nyɨvɨ tsa ña tsinú iñi tsi yu, tsa cunaa̱ ñi tyin ña tsinú iñi ñi tsi yu tsa cuví yu Sehe mañi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nyɨvɨ ña tsinú iñi, tsa cunaa̱ ñi. Tyin quɨvɨ quitsi̱ yu jandunditsi̱n yu nu ñuhu ñayɨvɨ, ña naquihi̱n cuenda ñi tsi yu tyin taahán xaan ca maa iñi maa ñi iyó ñi nu naa tyin maa ñi tsa ña vaha javahá ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tandɨhɨ nyɨvɨ javahá tsa ña vaha, ña taahán iñi ñi coo ñi nu nditsin, tyin ña cuñí ñi tsa quituvi tsa ña vaha javahá ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Maa tyin nyɨvɨ taahán iñi tsa nditsa, naquitá ñi nu nditsin tyin tacan tan nyehe nyɨvɨ tyin javahá ñi cuhva cuñí Nyoo tyin nyaá ra tsihin ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tsa yaha̱ yacan, ra Jesús tan ra tsicá tsihin ra cuahán ra naha nu cuví Judea. Tan ndoo̱ ra naha ican juhva quɨvɨ, tyin jacoondutyá ra naha tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tacan tucu ra Juan nyií ra jacoondutyá ra tsi nyɨvɨ nu cuví Enón yatyin ñi nu cuví Salim, tyin ican ñuhú cuaha ndutya. Tan tsaá nyɨvɨ tan tsicoondutyá ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yacan javaha̱ ra Juan tsa ndi cumañi ca quɨhvɨ ra vehe caa. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tacan tan quitsaha̱ caahán yuhu tahan juhva ra tsicá tsihin ra Juan tsihin inga ca ra naha tsa cuenda tsa janduvaha nyɨvɨ tsi ñi nuu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tacan tan cuahán ra naha nu nyií ra Juan. Tan catyí ra naha tsihin ra: ―Maestro, ra tsa tsinyii̱ tsihin un inga tsiyo yutya cahnu Jordán, ra tsa caha̱n un tuhun tsihin ndi, vityin jacoondutyá ndɨhɨ ra tsi nyɨvɨ tan tandɨhɨ nyɨvɨ nyicún tsi ra ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tacan tan catyí ra Juan tsihin ra naha: ―Ndi intuhun yo tan nduve náa cuví javaha yo, tun tsatyin ña tsahá Nyoo tunyee iñi ra tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nyooho tsa tsitó maa ndo tyin ñavin yuhu cuví ra Cristo tyin tsiñi̱ maa ndo tsa caha̱n yu quɨvɨ catyi̱ catsi yu tyin ra jaquitsi̱ Nyoo ityi nuu ra Cristo cuví yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tyin nu iyó vico tandaha, ra tsa nyaá xiin ñaha yoco can, juvin ra cuví ra cua tindaha tsihin ña. Tan ra vaha iñi tsi ra nyií ra ican. Tan cusɨɨ́ iñi ra tsiñí ra tsa caahán ra tsa cua tindaha. Tan tacan tucu yuhu, sɨɨ cuñí yu tyin naquihín nyɨvɨ tuhun caahán ra Jesús tan nyicún ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Maa ra cuví ra cahnu ca cuvi. Tan yuhu cua nduluhlu yu nuu ra tyin tacan taahán maa tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Ra tsa quee̱ nda gloria, cahnu ca cuví ra tan ñavin ca tandɨhɨ nyɨvɨ. Tyin nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya, cuenda nu ñuhu ñayɨvɨ cuví ñi. Tan caahán ñi tuhun tsa iyó nu ñuhu ñayɨvɨ. Maa tyin ra tsa quee̱ nda gloria, cahnu cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tan caahán ra tsa nyehé ra tan tsa tsiñí ra, maa tyin yoñi tsinú iñi tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tatun yoo tan tsinú iñi yo tsa caahán ra, cua cuví yo tsa ndaa tyin Nyoo ña vatya ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tyin ra tsa jaquitsi̱ Nyoo, tuhun Nyoo caahán ra tyin Nyoo ña tyihi̱ cuhva ra Tatyi Ii ra tan tsaha̱ ra itsi tsi ra. Tsaha̱ ra nanɨɨ Tatyi Ii ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nyoo Jutu yo cuñí ra tsi Sehe ra. Tan nacuhva̱ cuenda ra tandɨhɨ maa tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nyɨvɨ tsa tsinú iñi tsa caahán Sehe Nyoo, iyó ñi ñayɨvɨ nyito tsa ña cua naa maa. Maa tyin nyɨvɨ tsa ña cuñí tsinu iñi tsi ra, ña cua coo ñi ñayɨvɨ nyito. Tan cua tatsi tuñi Nyoo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tsa tsito̱ ra cuví fariseo naha ra tyin cuaha xaan ca nyɨvɨ nyicún tsi ra Jesús tan ñavin ca ra Juan. Tan cuaha xaan ñi tsicoondutya̱. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Maa tyin ñavin maa ra Jesús jacoondutyá tsi ñi, tyin ra tsicá tsihin ra jacoondutyá tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tan quɨvɨ tsa tsito̱ ra Jesús tyin tsito̱ ra naha yacan, quee̱ ra Judea can tan cuanuhu̱ ra nda nu cuví Galilea. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tsa cuahán ra, yaha ra nu cuví Samaria tyin cuñí tsi yaha ra ican. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tacan tan tsaa̱ ra iin ñuu tsa canyií Samaria tsa nañí Sicar yatyin ñi nu cuví ñuhu ra Jacob nu tsaha̱ ra tsi ra José sehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ican nyaá iin soco pila tsa catyí nyɨvɨ tyin tsii ra Jacob cuví. Tsa quita̱ ra Jesús nu nyaá soco can tan tsinyaa̱ ra yuhu soco can tyin tatu xaan ra tyin cañi xaan ityi tsica̱ ra tan maa hora cuví. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ra tsicá tsihin ra, yoñi ra naha nyecú tsihin ra tyin cuahán ra naha tsitsi ñuu, cua jata ra naha tsa catsi ra naha. Juvin ñi cuhva can tan tsaa̱ iin ñaha Samaria tyin cua tava ña ndutya tsitsi soco can. Tacan tan catyí ra Jesús tsihin ña: ―Cu̱hva luxu ndutya coho yu ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tacan tan ñaha Samaria can catyí ña tsihin ra: ―Yooho tsa cuví un iin ra ñuu Israel, ¿nacuvi tyin tsicán un ndutya coho un tsi yuhu tsa cuví yu ñaha Samaria? ―catyí ña. (Tacan catyi̱ ña tyin nyɨvɨ Israel ña vaha iyó ñi tsihin nyɨvɨ Samaria.) ");
INSERT INTO mjcNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tacan tan nacaha̱n ra Jesús tan catyí ra: ―Tun tsatyin tsitó un tsa tsahá Nyoo, tan tsitó un yóo ra cuví ra tsicán ndutya tsi un, maa un cua ndacan ndutya tsi yu. Tan cua cuhva yu ndutya nyito tsi un ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tacan tan catyí ña tsihin ra: ―Tatta, cunu xaan soco ihya. ¿Nacaa tava tucu un ndutya cuhva un tsi yu? tan ndi nduve náa ndaha un ¿Nu maa cua quihin un ndutya nyito can cuhva un coho yu? ");
INSERT INTO mjcNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ra Jacob tsii tsahnu yo, nacoo̱ ra soco ihya tsi ndi. Juvin ihya tsihi̱ maa ra ndutya tan tsihin tandɨhɨ sehe ra. Tan juvin ñi ihya tsihi̱ tucu quɨtɨ jana ra naha. ¿A cahnu ca ra cuví yooho tan ñavin ca ra can? ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tacan tan nacaha̱n ra Jesús tan catyí ra tsihin ña: ―Tandɨhɨ nyɨvɨ tsihí ndutya ihya, cua na ityi nyico iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Maa tyin nyɨvɨ tsihí ndutya tsa tsahá yuhu, ña cua na ityi ca iñi ñi. Tyin ndutya tsa tsahá yuhu cua cana tsi tsitsi añima ñi tumaa caná ndutya iin ndohyo, tyin iin ndohyo ña tuhvá tsi ndoco. Tan tacan cua coo ñi ñayɨvɨ nyito ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tacan tan quitsaha̱ caahán ña tsihin ra: ―Yooho tatta, cu̱hva ndutya can coho yu na ña na ityi ca iñi yu, tan ndi ña quitsi ca yu quitsi tava yu ndutya tsitsi soco ihya ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tacan tan catyí ra Jesús tsihin ña: ―Cu̱aahan cua quihin yɨɨ un tan qu̱itsi ndo ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tan nacaha̱n ña tan catyí ña: ―Nduve yɨɨ yu iyó. Tacan tan catyí ra Jesús tsihin ña: ―Nditsa tsa caahán un, tyin nduve yɨɨ un iyó. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tyin tsa uhun yɨɨ un tsicoo̱, tan ra cumí tsi un vityin ñavin yɨɨ un tsi ra. ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tsa tsiñi̱ ña tsa caha̱n ra tacan, quitsaha̱ catyí ña tsihin ra: ―Yooho tatta, tuví iñi yu tyin ra cuví ndusu yuhu Nyoo cuví un. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tsii tsahnu ndi, ra ñuu ihya naha ra, jacahnu̱ ra naha tsi Nyoo yucu ihya. Maa tyin nyooho tsa cuví nyɨvɨ Israel catyí ndo tyin nda Jerusalén taahán tsi jacahnu yo tsi Nyoo ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tacan tan nacaha̱n ra Jesús tan catyí ra tsihin ña: ―Tsi̱nu iñi tsa caahán yu tsihin un. Tyin vatsí hora tsa cua jacahnu ndo tsi Jutu yo Nyoo. Maa tyin ña tsiñiñuhu̱ ca tsa quitsi ndo yucu ihya, a cuhun ndo nda Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyooho nyɨvɨ Samaria, ña tsitó ndo yóo jacahnú ndo. Maa tyin nyuhu tsitó ndi yóo jacahnú ndi. Tan tsitó ndi tyin cua jacacu iin ra Israel tsi nyɨvɨ jaha Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Maa tyin cua tsaa hora, tan hora can iyó yo vityin tyin nyɨvɨ tsa nditsa jacahnú tsi Nyoo Jutu yo, cua jacahnu ñi tsi ra tsihin añima ñi tan tsihin tsa nditsa. Tumaa jaquihín ityi maa Tatyi Ii Nyoo tsi ñi. Tyin Nyoo Jutu yo tacan cuñí ra javaha ñi tsa jacahnú tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tyin Nyoo Tatyi Ii cuví ra. Tan nyɨvɨ jacahnú tsi ra cuñí tsi jacahnú ñi tsi ra tsihin tsa nditsa tumaa jaquihín ityi maa Tatyi Ii tsi ñi ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tan nacaha̱n ña tan catyí ña tsihin ra: ―Yuhu tsitó yu tyin cua quitsi ra cuví Mesías, ra Cristo, ra cuví rey tsi yo. Tan quɨvɨ quitsi ra, maa ra cua nacatyi tuhun tandɨhɨ tsihin yo ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tacan tan nacaha̱n ra Jesús tan catyí ra tsihin ña: ―Ra tsa caahán un tuhun can, juvin ra caahán tsihin un ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tacan tan tsaa̱ nyico ra tsicá tsihin ra, tan iyo xaan cuñí ra naha tyin natuhún ra Jesús tsihin iin ñaha. Maa tyin ndi intuhun ra naha tan ña caná iñi ra naha ndaca tuhun ra naha náa cuñí ra, o ndaca tuhun ra naha tsi ra nacuenda natuhún ra tsihin ñaha can. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tacan tan nacoo̱ ña quɨyɨ ña tan cuanuhu ña nda ñuu. Tan catyí ña tsihin nyɨvɨ: ");
INSERT INTO mjcNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Co̱hon ndo cu̱nyehe ndo tsi iin ra tsa caha̱n tandɨhɨ cuhva iyó yu. ¿A ñavin ra Cristo tsa cua jaquitsi Nyoo cuví ra? ―catyí ña tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tacan tan quita̱ nyɨvɨ ñuu can tan cuahán ñi cua nyehe ñi nu nyií ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tan tsa ndi cumañi ca tsaa ñi nu nyií ra, ra tsicá tsihin ra, jañiñí ra naha tsi ra na catsi ra luxu. Tan catyí ra naha tsihin ra: ―Maestro, ca̱tsi luxu ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Maa tyin catyí ra Jesús tsihin ra naha: ―Yuhu iyó iin tsa tsatsí yu tan nyooho ña tsitó ndo náa cuví can ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tacan tan ra tsicá tsihin ra, quitsaha̱ natuhún tahan ra naha, tan catyí ra naha: ―¿A iyó yóo quitsi̱ quitsi̱ ndaca tsa catsi ra? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Maa tyin ra Jesús catyí ra tsihin ra naha: ―Tsa tsatsí yuhu juvin tsi cuví tsa javahá yu cuhva cuñí ra tsa jaquitsi̱ tsi yu, tan javahá yu tyiñu tsaha̱ ra tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nyooho catyí ndo: “Ndi cumañi cumi yoo ca tan tahan tsi naquihin vaha yo tsa tatsi̱ yo.” Maa tyin yuhu catyí yu tsihin ndo: Nye̱he ndo tyin tsa ndɨhɨ tsa tatsi̱ ndo cuaan tan tsa nyecú vaha tsi tsa cua naquihin vaha yo itsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ra tsa naquihín vaha can ñihí ra yahvi ra. Tan tsa naquihín vaha ra, cuví tsi nyɨvɨ tsa cua coo ñayɨvɨ nyito tsa ña cua naa maa. Tacan tan ra tsa tatsi̱ tan ra tsa naquihín cusɨɨ iñi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tan iyó iin cuhva tuhvá nyɨvɨ caahán tan catyí ñi tyin sɨɨn nyɨvɨ tatsí tan sɨɨn nyɨvɨ naquihín vaha. Tan nditsa yacan. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yuhu jacuhu̱n yu tsi ndo tyin cua cahnu ndo nɨñɨ tsa iyó nu ña jaha̱ tyiñu ndo, nu jaha̱ tyiñu inga ra. Tan nyooho cucahnu ndo tan cua naquihin vaha ndo nɨñɨ can ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tan cuaha xaan nyɨvɨ ñuu Samaria can quitsaha̱ tsinú iñi ñi tsi ra Jesús tsa cuenda tsa caha̱n ñaha can, tyin catyí ña: “Caha̱n ra tsihin yu tandɨhɨ cuhva iyó yu”, catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Cuhva tsa tsaa̱ ñi nu nyií ra Jesús, tan caha̱n ndaahvi ñi tsihin ra na ndoo ra tsihin ñi. Tan ndoo̱ ra tsihin ñi uvi quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tan cuaha ca nyɨvɨ quitsaha̱ tsinú iñi ñi tsa tsiñi̱ ñi tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tacan tan quitsaha̱ catyí ñi tsihin ñaha can: ―Vityin tsinú iñi ndi, maa tyin ñavin tsa cuenda tsa caha̱n un tsihin ndi, tyin tsiñi̱ maa ndi tsihin soho ndi tsa caahán ra, tan tsitó vaha ndi tyin juvin ra cuví ra Cristo ra jacacú tsi nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tsa yaha̱ uvi quɨvɨ tan quee̱ ra Jesús nu cuví Samaria tan cuahán ra ityi nu cuví Galilea, nu cacu̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Vasu ndi maa juvin ñi maa ra caha̱n tyin iin ra cuví ndusu yuhu Nyoo, nyɨvɨ ñuu ra ña jahá ñi tsa ñayɨvɨ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tacan tan tsa tsaa̱ ra Galilea, nyɨvɨ iyó ican, vaha caahán ñi tsihin ra, tyin tsaha̱n ñi vico Jerusalén, tan nyehe̱ ñi tsa vaha tsa javaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tacan tan cuanuhu nyico ra Jesús nda ñuu Caná tsa canyií Galilea nu nanduvi̱ ndutya vinu jaha̱ ra. Tan iyó iin ra nyisó tyiñu cahnu nuu rey. Ra ican iyó iin sehe ra tsa cuuhví nda ñuu Capernaum. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Quɨvɨ tsa tsito̱ ra can tyin tsa tsaa̱ nyico ra Jesús nda Galilea tsa tsaha̱n ra nda Judea, tsaha̱n ra tsinyehe̱ ra tsi ra Jesús. Tan tsica̱n ra tumañi iñi tsi ra na cuhun ra vehe ra tan janduvaha ra tsi sehe ra, tyin tsa cuñí cúu cuii ña sehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tacan tan catyí ra Jesús tsihin ra: ―Nyooho ña cua tsinu iñi ndo tatun ña nyehe jihna ndo tsa iyo ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Maa tyin ra can catyí ra tsihin ra Jesús: ―Yooho taa, co̱hon ñi tsihin yu tsa ndi cumañi ca cúu sehe yu ―catyí ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tacan tan catyí ra Jesús tsihin ra: ―Cua̱nuhu yuvehe un. Sehe un nyito ra, tsa nduvaha̱ ra ―catyí ra tsihin ra. Tacan tan ra can tsinu̱ iñi ra tsa caha̱n ra Jesús tan cuanuhu̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tsa tsa cuyatyi̱n ra yuvehe ra, quita̱ musu ra tan caahán ra naha tsihin ra: ―¡Taa, sehe un nyito ra; tsa nduvaha̱ ra! ");
INSERT INTO mjcNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tacan tan quitsaha̱ tsica̱ tuhun ra tsi ra naha náa hora quitsaha̱ vaha cuñí ra. Tan catyí ra naha tsihin ra: ―Icu cuhva caa iin tsa yaha̱ hora quita̱ cahñi tsi ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tacan tan tsito̱ ra can, tyin hora can caha̱n ra Jesús tsihin ra, “Cu̱anuhu tyin sehe un nyito ra, tsa nduvaha̱ ra.” Tan maa ra can tsihin tandɨhɨ nyɨvɨ ra quitsaha̱ tsinú iñi ñi tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yacan cuví tsa iyo tsa tsinu uvi javaha̱ ra Jesús tsa tsaa̱ nyico ra Galilea tsa yaha tsaha̱n ra Judea. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tsa yaha̱ can tan cuahán ra Jesús ñuu Jerusalén inga tsaha tyin nyɨvɨ ñuu Israel jacahnú ñi iin vico. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tan yuhu cora cahnu ñuu can iyó iin yuvehe tsa nañí Yuvehe Cuenda Mbee Ticatyi. Tan yatyin ñi nyaá iin vehe cahnu. Tan tsitsi vehe can ñuhú ndutya. Tan tsa tsihin yuhu hebreo nañí vehe can Betesda. Tan iyó uhun corredor. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tan ican yucú cuaha nyɨvɨ cuuhví: ñi cuaa, ñi coxo, tan ñi ndohó cuehe xii. Ndatú ñi náa hora nacanda ndutya can. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tyin nda naha nda naha ñi tan nuú iin ángel tan jacandá ra ndutya can. Tan nyɨvɨ tsa quɨhvɨ́ jihna tsa yaha̱ ñi nacandá ndutya can, nduvahá ñi vasu ndi maa cuehe cahnu ndohó ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tan ican canyií iin ra cuuhví tan tsa iyó oco tsahun uñi cuiya cuuhví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tsa nyehe̱ ra Jesús tsi ra ican canyií ra, tuvi̱ iñi ra tyin tsa cuaha xaan cuiya cuuhví ra. Tan tsica̱ tuhun ra tsi ra ndaahvi can, tan catyí ra: ―¿A cuñí un nduvaha un? ");
INSERT INTO mjcNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tan ra cuuhví can nacaha̱n ra tan catyí ra: ―Tata, yoñi maa tyihí tsi yu tsitsi ndutya ihya tatun tsa nacandá tsi. Tyin tahán ñi tsaha tsa cuñí yu quɨhvɨ yu, inga nyɨvɨ quɨhvɨ́ jihna ―catyí ra cuuhví can tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tacan tan catyí ra Jesús tsihin ra: ―Ndu̱vita, na̱quihin yuvi un tan ca̱ca un ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Juvin ñi hora can tan nduvaha̱ ra, naquihi̱n ra yuvi ra, tan nacaca̱ ra. Maa tyin quɨvɨ quitatú nyɨvɨ cuví quɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yacan ra cuví ityi nuu tsihin nyɨvɨ Israel catyí ra naha tsihin ra tsa nduvaha̱ can: ―Quɨvɨ quitatú yo cuví vityin, yacan cuenda ña taahán tsi cuiso un yuvi un ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tan ra tsa nduvaha̱ can nacaha̱n ra tan catyí ra: ―Ra tsa janduvaha̱ tsi yu, catyi̱ ra tsihin yu: “Na̱quihin yuvi un tan ca̱ca un”, catyí ra tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tacan tan quitsaha̱ tsicá tuhun ra naha tsi ra, tan catyí ra naha: ―¿Yóo ra caha̱n tsihin un tyin naquihin un yuvi un tan caca un? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Maa tyin ra tsa nduvaha̱ can ña tsitó ra yóo janduvaha̱ tsi ra. Tyin cuaha xaan nyɨvɨ nyecú ican, tan ra Jesús nduve ca ra nyaá tyin tsa cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yaha̱ can tan nañihi̱ ra Jesús tsi ra tsa nduvaha̱ can tsitsi vehe ñuhu cahnu, tan catyí ra tsihin ra: ―Jihna, vityin tsa nduvaha̱ un, ña javaha ca un tsa ña vaha, tyin coto quitsi inga tundoho cahnu ca sɨquɨ un ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tacan tan tsaha̱n ra tsicaha̱n ra tsihin ra Israel naha ra tyin ra Jesús cuví ra janduvaha̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tsa cuenda tsa janduvaha̱ ra Jesús tsi ra can quɨvɨ quitatú nyɨvɨ, xaan xaan cuñí ra Israel naha ra nyehe ra naha tsi ra. Tan cuñí ra naha cahñi ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Maa tyin ra Jesús catyí ra tsihin ra naha: ―Maa Jutu yu, nda vityin tan jahá tyiñu ra. Tan jahá tyiñu tucu yuhu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tan tsa cuenda tsa caha̱n ra yacan, xaan ca cuñí ra Israel can naha ra. Tan ñihi ca cuñí ra naha cahñi ra naha tsi ra tyin cuñí maa ra naha tyin ña jahá ra Jesús tsa cahnu cuví quɨvɨ quitatú nyɨvɨ, tan inga tucu tuhun, iin ñi cuví ra tsihin Nyoo jahá ra tsi ra tyin catyí ra tyin jutu ra cuví tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tacan tan catyí ra Jesús tsihin ra naha: ―Tsa nditsa caahán yu tsihin ndo tyin yuhu, Sehe Nyoo cuví tsi yu, tan nduve tsa javahá yu tsa maa ñi maa yu. Tyin javahá yu tsa nyehé yu javahá Jutu yu. Tandɨhɨ tsa javahá Jutu yu tan javahá tucu maa yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tyin cuñí xaan ra tsi yu, tyin Sehe ra cuví tsi yu, tsa cuenda yacan janahá ra tandɨhɨ tsa javahá ra tsi yu. Tan nahnu ca tsa cua janaha ra tsi yu, tan nyooho iyo cua cuñi ndo nyehe ndo can. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tumaa janandotó Nyoo Jutu yu ndɨyɨ, tan tsahá ra ñayɨvɨ coo ñi, tacan tucu yuhu tsa cuví yu Sehe ra, tsahá yu ñayɨvɨ coo nyɨvɨ cuñí maa yu cuhva yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tacan Nyoo Jutu yu, ña jandaa ca ra cuatyi ndi intuhun nyɨvɨ tyin tsa tsaha̱ ra ndatu tsi yuhu tsa cuví yu Sehe ra tyin jandaa yu cuatyi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tacan icá Nyoo Jutu yu tsa cuñí ra jacahnu nyɨvɨ tsi Sehe ra tumaa tsa jacahnú maa ñi tsi maa ra. Nyɨvɨ tsa ña jacahnú tsi yuhu tsa cuví yu Sehe Nyoo, ndi Jutu yu tan ña jacahnú ñi. Tyin maa ra jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Tan tsa nditsa caahán yu tyin nyɨvɨ tyaá soho tsa caahán yu tan tsinú iñi ñi tsi ra tsa jaquitsi̱ tsi yu, iyó ñi ñayɨvɨ nyito tsa ña cua naa maa. Tan ña cua cuhun ca ñi anyaya tsa catyi cuatyi ñi tyin tsa jacacu̱ Nyoo tsi ñi tan ña yɨhɨ ndaha ca tuhun tsiihí tsi ñi, tan tsaha̱ ra ñayɨvɨ nyito iyó ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nyɨvɨ; tumaa ndɨyɨ cuví ñi. Tan tsa nditsa caahán yu tsihin ndo tyin vatsí quɨvɨ cua cuñi ñi ndusu Sehe Nyoo. Tan nyɨvɨ tsa cua tyaa yahvi tsa caahán ra, cua coo ñi ñayɨvɨ nyito tsa ña cua naa maa. Tan vityin cuví quɨvɨ tsa caahán yu tuhun. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tyin Nyoo Jutu yu iyó ra ñayɨvɨ nyito tsa ña cua naa maa. Tan tsaha̱ ra ndatu can tsi yuhu tsa cuví yu Sehe ra tyin cuhva yu ñayɨvɨ can coo nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tan tsaha̱ tucu Nyoo ndatu tsi yu tsa jandaa yu cuatyi nyɨvɨ, tyin Rayɨɨ quee̱ nda gloria cuví yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ña iyo cu̱ñi ndo tsa caahán yu tyehen, tyin cua tsaa̱ quɨvɨ tsa cuñi ndɨyɨ yucú tsitsi ñaña ndusu Sehe Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tan cua quita ñi tsitsi ñaña ñi. Tacan tan nyɨvɨ tsa javaha̱ tsa vaha cua nandoto ñi tyin coo ñi ñayɨvɨ nyitó. Maa tyin nyɨvɨ tsa javaha̱ tsa ña vaha cua nandoto ñi tyin cuhun ñi anyaya nu cua tatsi tuñi Nyoo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Yuhu ña cuví javaha yu tsa javahá yu tsa intuhun ñi maa yu. Yuhu jandaá yu cuatyi nyɨvɨ tumaa cuhva tava̱ tyiñu maa Jutu yu tsi yu. Tan cuhva jandaa yu cuatyi, vaha tsi, tyin ña javahá yu cuhva cuñí maa yu, tyin javahá yu cuhva caahán maa Jutu yu, ra tsa jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tan tatun juvin ñi maa yu cuví tsa ndaa tsa cuenda yu, nduve yahvi nyaá tsa ndaa can. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Maa tyin iyó inga ra cuví tsa ndaa cuenda yu. Tan yuhu tsitó yu tyin tsa caahán ra cuenda yu, yacan cuví tsa ndaa tan tsa nditsa. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nyooho tava̱ tyiñu ndo na ndaca tuhun ra naha tsi ra Juan. Tan tuhun tsa caha̱n ra, tsa nditsa cuví tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Maa tyin yuhu ña tsiñiñuhu̱ tsa cuví rayɨɨ tsa ndaa tsa cuenda yu. Maa tyin caahán yu tuhun tsa caha̱n ra Juan tsihin ndo tsa cuenda tsa vaha tsi maa ndo, tyin tacan tan tsinu iñi ndo tsi yu tan cacu ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ra Juan cuvi̱ ra tumaa iin lámpara tsa cayú tan jandunditsín tsi. Tan nyooho juhva ñi quɨvɨ cusɨɨ iñi ndo tsihin ñuhu̱ nditsin can. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Maa tyin yuhu iyó iin tsa ndaa vaha ca tsi yu tan ñavin ca tsa caaha̱n ra Juan. Tyin tandɨhɨ tsa javahá yuhu, maa Jutu yu catyí tsihin yu na javaha yu can. Tan yacan cuví tsa ndaa tsa nyehé ndo tyin nditsa tyin maa Jutu yu jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tacan tucu Jutu yu, ra tsa jaquitsi̱ tsi yu, cuví ra tsa ndaa tsa cuenda yu. Nyooho ñaha ca cuñi ndo ndusu ra, tan ndi ñaha ca nyehe ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tan ña ndoó tuhun ra tsa caahán yu tsihin ndo tsitsi añima ndo tyin ña tsinú iñi ndo tyin Nyoo jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nyooho tsihin cuenda xaan cahví ndo nu tutu Nyoo, tyin cuñí maa ndo tyin nuu tsi cua ñihi ndo ñayɨvɨ nyito tsa ña cua naa maa coo ndo. Maa tyin tutu Nyoo can, tuhun yuhu caahán tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Tan nyooho ña cuñí ndo quitsi ndo nu nyaá yu tan cuhva yu ñayɨvɨ nyito coo ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Yuhu ña nducú yu tsa jacahnu nyɨvɨ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tyin yuhu tsitó yu tsi ndo tan tsitó yu tyin ña cuñí ndo tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yuhu vatsí yu cuenda Jutu yu tan nyooho ña naquihín ndo tsa caahán yu. Maa tyin tatun inga ra cua quitsí tsa cuenda maa ra, ra ican cua tsinu iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nyooho ña cuví tsinu iñi ndo tsi yu tyin cuñí ndo nduvaha ndo nuu nyɨvɨ tahan ndo. Tan ña nducú ndo nduvaha ndo nuu Nyoo, tan intuhun ñi maa ra cuví Nyoo tsa iyó. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ña caca iñi ndo tyin cua ndacan yu cuatyi tsaha ndo nuu Jutu yu. Nyooho cuñí maa ndo tyin ley tsa tyaa̱ ra Moisés cua cundaca tsi ndo gloria. Maa tyin ra Moisés cuví ra tsicán cuatyi tsaha ndo tyin ña jacuví ndo ley tsa tyaa̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tyin tun tsatyin nditsa tsa tsinú iñi ndo tsa caha̱n ra Moisés, tacan cua tsinu ndɨhɨ iñi ndo tsa caahán yuhu. Tyin tuhun yuhu cuví tsa tyaa̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Maa tyin tatun ña tsinú iñi ndo tuhun tsa tyaa̱ ra, ¿nácaa cua tsinu iñi ndo tsa caahán yuhu? ―catyí ra Jesús tsihin ra cuví ityi nuu tsihin ra Israel naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tsa yaha̱ yacan, tan cuahán ra Jesús inga tsiyo miñi cahnu tsa nañí Ndutya Ñuhu Galilea. Tan juvin ñi nañí tucu tsi Miñi Tiberias. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cuaha xaan nyɨvɨ cuahán nyicun tsi ra tyin nyehé ñi tsa iyo tsa javahá ra tyin janduvahá ra tsi nyɨvɨ cuuhví. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tacan tan ra Jesús ndaa̱ ra iin yucu tan tsinyaa̱ ra ican tsihin ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tan tsa cuyatyin cuii tahan tsi quɨvɨ vico pascua tsa jacahnú nyɨvɨ Israel. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tan nyehe̱ ra Jesús tyin cuaha xaan nyɨvɨ nyicún tsi ra, tacan tan quitsaha̱ caahán ra tsihin ra Felipe: ―¿Numaa cua jata yo tsa catsi nyɨvɨ cuaha ihya? ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Caahán ñi maa ra tsihin ra Felipe tyin nducú cuhva ra tsi ra náa cua cahan ra, tyin tsa tsitó maa ra Jesús náa cua javaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tacan tan nacaha̱n ra Felipe tan catyi̱ ra: ―Xuhun tsa quihin yo tsa jaha̱ tyiñu yo tsa uvi cientu quɨvɨ, ndi ña cua cutahan can jata yo luxu tsa catsi nyɨvɨ ihya ―catyí ra Felipe. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tan inga ra tsa nyicún tsi ra Jesús, ra Andrés, yañi ra Simón Pedro, catyí ra tsihin ra Jesús: ");
INSERT INTO mjcNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ihya nyií iin ra luhlu ndaha uhun taahan paan cebada tan uvi taahan tyaca. Maa tyin ndi nduve náa cuví yacan tyin cuaha xaan nyɨvɨ ihya ―catyí ra Andrés. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tacan tan catyí ra Jesús tsihin ra naha: ―Ca̱han ndo tsihin tandɨhɨ nyɨvɨ na cunyecu ñi ―catyí ra. Tan cuaha xaan itya ican tan tsinyecu̱ ñi, uhun mil rayɨɨ, tan sɨɨn maa ñi ñaha tsihin tsa nyihi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tacan tan quihi̱n ra Jesús paan can tan tsa yaha̱ tsaha̱ ra tyahvi nyoo tsi Nyoo, tan tsaha̱ ra can tsi ra tsicá tsihin ra. Tan ra can naha ra, tsaha̱ ra naha can tsi tandɨhɨ nyɨvɨ tsa nyecú can. Juvin ñi tacan ica̱ nyico ra tsihin tyaca can. Tan tsatsi̱ ndaha iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tan cuhva tsa ndaha iñi ñi, ra Jesús catyí ra tsihin ra tsicá tsihin ra: ―Na̱quihin vaha ndo tsa ñahñu tsa ndoo̱ tyin tacan tan ña tɨvɨ tsi ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Naquihi̱n vaha ra naha can, tan jacutu̱ ra naha utsi uvi tyica tsihin tsa ñahñu tsa ndoo̱ tsa uhun taahan paan can. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tacan tan tsa yaha̱ nyehe̱ nyɨvɨ can tsa iyo tsa javaha̱ ra Jesús, tan catyí ñi: ―Nditsa tsa cuii tyin ndusu yuhu Nyoo cuví ra ihya, juvin ra nyaá tsa quitsi maa nu ñuhu ñayɨvɨ ihya ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Maa tyin tsa tuvi̱ iñi ra Jesús tyin cuñí ñi tsa quihin ñi tsi ra tsihin tsa ñiñi tyin cuvi ra rey cuenda ñi, tacan tan cuahán nyico ra jiñi yucu nu sucun ca tyin cunyii intuhun ñi maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tsa cunaaha, nuu̱ ra tsicá tsihin ra Jesús yuhu miñi can. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tan quɨhvɨ̱ ra naha tsitsi yutun ndoo tyin cua yaha sava ra naha mahñu miñi can tan cua tsaa ra naha ñuu Capernaum. Tsa cunaaha tan ra Jesús ñaha ca maa tsaa ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tacan tan tsaa̱ tatyi ñihi. Tan iyo nduvita̱ ndutya miñi can. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tsa tsa yaha̱ ra naha uhun a iñu kilómetro tsihin yutun ndoo can tan nyehe̱ ra naha vatsí ra Jesús tsicá ra nu ndutya. Tsa nyehe̱ ra naha tyin tsa cua cuyatyin ra nu cuahán yutun ndoo can, nayuhvi̱ xaan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Maa tyin catyí ra Jesús tsihin ra naha: ―¡Maa yu cuví, ña na̱yuhvi ndo! ");
INSERT INTO mjcNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tacan tan tsaha̱ ra naha quɨhvɨ ra Jesús tsitsi yutun ndoo can. Tan iin yaha ñi tsaa̱ ra naha yuhu miñi nu cuahán ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tsa tuvi inga quɨvɨ tan tsito̱ nyɨvɨ tsa ndoo̱ inga tsiyo miñi can tyin ra tsicá tsihin ra Jesús tsa cuahán ra naha tsihin iin yutun ndoo tsa iyó ican. Intuhun ñi maa can iyó. Tan tsito̱ ñi tyin ña cuahán ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Maa tyin tsaa̱ taahan ca yutun ndoo tsa quee̱ ñuu Tiberias yatyin ñi nu nacuhva̱ Jutu Mañi yo tyahvi nyoo tsi Nyoo tan tsatsi̱ nyɨvɨ paan. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tacan tan tsa nyehe̱ nyɨvɨ tyin nduve ra Jesús tan ndi ra tsicá tsihin ra, quɨhvɨ̱ ñi tsitsi yutun ndoo tsa tsaa̱ tan cuahán ñi nda ñuu Capernaum cua nanducu ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tsa tsaa̱ ñi inga tsiyo miñi can, nañihi̱ ñi tsi ra Jesús. Tan tsica̱ tuhun ñi tsi ra: ―Maestro, ¿náa cuhva tsaa̱ un ihya? ―catyí ñi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Maa tyin catyí ra Jesús tsihin ñi: ―Tsa nditsa catyí yu tsihin ndo tyin nyooho nanducú ndo tsi yu maa tyin ñavin cuenda tsa nyehe̱ ndo tsa iyo tsa javaha̱ yu. Nanducú ndo tsi yu tyin tsatsi̱ ndo tan ndaha iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ña ja̱ha tyiñu ndo cuenda tunyee iñi tsa tsatsí ndo tsa cua ndɨhɨ ñi maa, ja̱ha tyiñu ndo cuenda tunyee iñi tsa catsi ndo tsa ña cua ndɨhɨ tan tsahá tsi ñayɨvɨ nyito tsa ña cua naa maa coo ndo. Yacan cuví tsa catsi ndo tsa cua cuhva yuhu tsi ndo tyin Nyoo Jutu yu tava̱ tyiñu ra tsi yu tyin yuhu cuví Rayɨɨ tsa quee̱ nda gloria ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tacan tan quitsaha̱ tsicá tuhun ñi tsi ra tan catyí ñi: ―¿Náa taahán tsi javaha ndi tan cuví javaha ndi cuhva cuñí Nyoo? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tacan tan catyí ra Jesús tsihin ñi: ―Tsa cuñí Nyoo javaha ndo, cuví tsa tsi̱nu iñi ndo tsa caahán yuhu, ra tsa jaquitsi̱ ra ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tan tsica̱ tuhun nyico ñi tsi ra, tan catyí ñi: ―¿Náa tsa iyo javaha un nyehe ndi tan tsinu iñi ndi tsa caahán un? ");
INSERT INTO mjcNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tsii tsahnu ndi tsatsi̱ ñi maná nu tsɨquɨ, tumaa tsa caahán tuhun Nyoo tyehen: “Andɨvɨ quee̱ paan tsatsi̱ nyɨvɨ jaha̱ Nyoo” ―catyí ñi tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tan nacaha̱n ra Jesús tan catyí ra: ―Tsa nditsa caahán yu tsihin ndo. Ñavin ra Moisés tsaha̱ paan tsa quee̱ andɨvɨ tsatsi̱ ñi, tyin maa Nyoo Jutu yu cuví ra tsahá paan nditsa tsa quee̱ andɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tyin paan tsa tsahá Nyoo, yacan cuví ra tsa quee̱ andɨvɨ. Tan juvin ra cuví ra tsahá ñayɨvɨ nyito coo nyɨvɨ iyó nu ñuhu ñayɨvɨ ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tacan tan quitsaha̱ catyí ñi tsihin ra: ―Taa, cu̱hva paan can catsi ndi tandɨhɨ ñi quɨvɨ ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tan nacaha̱n ra Jesús tan catyí ra tsihin ñi: ―Yuhu cuví paan tsa tsahá tsa coo nyito añima ndo. Nyɨvɨ nyicún tsi yu ña cua cusoco ca ñi, tan ñi tsinú iñi tsa caahán yu ña cua na ityi iñi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Maa tyin tumaa tsa caahán yu tsihin ndo, nyehé vaha ndo tsi yu, maa tyin ña cuñí ndo tsinu iñi ndo tyin juvin yu cuví ra tsa cuví jatyinyee tsi ndo ");
INSERT INTO mjcNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tandɨhɨ nyɨvɨ tsa tsaha̱ Nyoo Jutu yu tsi yu, nyicún ñi tsi yu, tan ñi tsa nyicún tsi yu, naquihín vaha yu tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tyin yuhu tsa quee̱ andɨvɨ; vatsí yu vatsí javahá yu cuhva cuñí ra tsa jaquitsi̱ tsi yu. Ña vatsí yu vatsí javaha yu cuhva cuñí ñi maa yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tan cuhva cuñí ra tsa jaquitsi̱ tsi yu, yacan cuví tsehe: tsa ña cunaa ndi intuhun nyɨvɨ tsa tsahá ra tsi yu, tan janandoto yu tsi ñi nu cua cundɨhɨ quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jutu yu, ra tsa jaquitsi̱ tsi yu, cuñí ra tyin tandɨhɨ nyɨvɨ tsa cutuñi iñi tyin Sehe Nyoo cuví tsi yu, tan tsinu iñi ñi tsa caahán yu, cua coo ñi ñayɨvɨ nyito tsa ña cua naa maa. Tan juvin ñi yu cua janandoto tsi ñi nu cua cundɨhɨ quɨvɨ ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tsa cuenda tsa caha̱n ra Jesús yacan, tan quitsaha̱ caahán nyaa nyɨvɨ Israel tsi ra tyin catyí ra: “Yuhu cuví paan tsa quee̱ andɨvɨ”, catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tacan tan quitsaha̱ catyí ñi: ―¿A ñavin ra Jesús sehe ra José cuví ra ihya? Yoo tsitó vaha yo tsi jutu ra tan tsi sɨhɨ ra. ¿Nacaa tsa catyí ra tyin andɨvɨ quee̱ ra? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tacan tan catyí ra Jesús tsihin ñi: ―Ja̱ndɨhɨ ndo tsa caahán nyaa ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yoñi maa nyɨvɨ cuví quitsi quitsi nyicún tsi yu tatun ñavin Jutu yu, ra tsa jaquitsi̱ tsi yu, caná tsi ñi. Tan cua janandoto yu tsi ñi nu cua cundɨhɨ quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nu libru tsa tyaa̱ ra cuví ndusu yuhu Nyoo caahán tsi tyehen: “Nyoo cua jacuaha ra tsi tandɨhɨ nyɨvɨ” catyí tsi. Yacan cuenda nyɨvɨ tsa tyaá soho tuhun tsa caahán Nyoo Jutu yu tan cutuhvá ñi tsa caahán ra, juvin ñi nyicún tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ñavin tsa tyin nyehe̱ ñi tsi Nyoo Jutu yu, tyin yoñi nyehe̱ tsi ra. Intuhun ñi maa yu nyehé tsi ra. Tan juvin yu cuví ra tsa quee̱ nu nyaá ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tsa nditsa catyí yu tsihin ndo tyin nyɨvɨ tsa tsinú iñi tsa caahán yu tsa iyó ñi ñayɨvɨ nyito tsa ña cua naa maa. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yuhu cuví paan tsa tsahá tsa coo nyito añima ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tsii tsaahnu ndo tsatsi̱ ñi maná nu tsɨquɨ, maa tyin juvin ñi tsihi̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Maa tyin yuhu, tuhun paan tsa quee̱ andɨvɨ caahán yu tsihin ndo, tyin nyɨvɨ tsa cua catsi paan can, ña cua cúu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Juvin ñi maa yu cuví paan nyito tsa quee̱ andɨvɨ. Nyɨvɨ tsa cua catsi paan ihya ña cua cundɨhɨ tsa coo ñi, tyin paan tsa cua cuhva yu, yacan cuví cuñu ñuhu yu. Tan cua cuhva yu ñayɨvɨ tsa iyó yu tsa cuenda tandɨhɨ nyɨvɨ iyó nu ñuhu ñayɨvɨ ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tacan tan nyɨvɨ Israel can quitsaha̱ natuhún tahan ñi tan catyí ñi: ―¿Nacaa cua cuhva ra tsa catsi yo cuñu ñuhu ra? ");
INSERT INTO mjcNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tan catyí ra Jesús: ―Tsa nditsa catyí yu tsihin ndo, tyin yuhu cuví Rayɨɨ tsa quee̱ nda gloria, tan tatun nyooho tan ña cua catsi ndo cuñu ñuhu yu, tan ña coho ndo nɨñɨ yu, ña cuvi coo ndo ñayɨvɨ nyitó. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nyɨvɨ tsatsí cuñu ñuhu yu tan tsihí ñi nɨñɨ yu, iyó ñi ñayɨvɨ nyito tsa ña cua naa maa. Tan yuhu cua janandoto yu tsi ñi nu cua cundɨhɨ quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tyin cuñu ñuhu yu yacan cuví paan tsa nditsa tsa taahán tsi catsi ñi, tan nɨñɨ yu cuví vinu tsa nditsa tsa taahán tsi coho ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nyɨvɨ tsatsí cuñu ñuhu yu tan tsihí ñi nɨñɨ yu, iin ñi cuví ñi tsihin yu. Tan iin ñi cuví yu tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jutu yu, ra tsa jaquitsi̱ tsi yu, Nyoo nyito cuví ra. Tan yuhu iyó yu tsihin tunyee iñi ra. Tan juvin ñi tacan tucu nyɨvɨ tsatsí cuñu ñuhu yu, cua coo ñi tsihin tunyee iñi tsa iyó tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tuhun paan tsa quee̱ andɨvɨ caahán yu. Paan ihya ñavin tumaa maná tsa tsatsi̱ tsii tsaahnu yo cuví tsi, tyin juvin ñi tsihi̱ ñi. Nyɨvɨ tsatsí paan tsa cuví cuñu ñuhu yu, ña cua cundɨhɨ maa tsa coo ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Juvin yacan jacuaha̱ ra Jesús nu ndu ii̱n nyɨvɨ tsitsi vehe ñuhu ñuu Capernaum. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Cuaha xaan nyɨvɨ nyicún tsi ra Jesús. Tan cuhva tsa tsiñi̱ ñi yacan catyí ñi: ―Tuhun tsa caahán ra ihya, yɨɨ xaan naquihin vaha yo itsi. Yoñi maa cua tsinu iñi tsa caahán ra ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tacan tan tuvi̱ iñi ra Jesús tyin ña cuñí ñi naquihin ñi tsa caahán ra. Tan tsica̱ tuhun ra tsi ñi: ―¿A ndasɨ cuñí ndo tsa caahán yu ihya? ");
INSERT INTO mjcNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tan ¿náa cua javaha ndo tatun nyehe ndo tsi yuhu Rayɨɨ tsa quee̱ nda gloria nandaa nyico yu inga tsaha ityi nu quee̱ yu? ");
INSERT INTO mjcNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tatyi Ii Nyoo tsahá ñayɨvɨ nyito. Tan cuñu ñuhu, ña jatyinyeé tsi tsa coo yo ñayɨvɨ can. Tan tsa caahán yuhu tsihin ndo, Tatyi Ii Nyoo cuví tsi tan tsahá tsi tsa coo nyitó añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Maa tyin yɨhɨ́ ndo ña tsinú iñi ndo tsi yu ―catyí ra Jesús. Tyin nda quɨvɨ jihna tan tsa tsitó maa ra yóo ña cua tsinú iñi tsi ra tan yóo cua xico tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tan catyí ra: ―Yacan cuenda catyí yu tsihin ndo tyin yoñi nyɨvɨ cuví quitsi nyicun tsi yu tatun ñavin maa Nyoo Jutu yu caná tsi ñi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nda quɨvɨ can, tan cuaha xaan nyɨvɨ nyicún tsi ra Jesús nacoo̱ ñi tsi ra. Tan ña tsicá ca ñi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tacan tan tsica̱ tuhun ra Jesús tsi tsa utsi uvi ra tsicá tsihin ra, tan catyí ra: ―¿A cuñí ndɨhɨ tucu nyooho cuhun ndo? ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Maa tyin nacaha̱n ra Simón Pedro tan catyí ra: ―Jutu Mañi yu, ¿yóo cunyicun ndi? Tan intuhun ñi maa un caahán tuhun ñayɨvɨ nyito tsa ña cua naa maa. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nyuhu tsinú iñi ndi, tan tsitó ndi tyin yooho cuví ra Cristo Sehe Nyoo nyito. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tan nacaha̱n ra Jesús tan catyí ra: ―¿A ñavin yuhu nacatsi̱ tsi tandɨhɨ tsa utsi uvi ndo? Tan intuhun ndo yɨhɨ́ nu ña vaha ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tuhun tsa caahán ra Jesús ihya, tuhun ra Judas Iscariote sehe ra Simón cuví can. Tyin ra Judas cuví ra cua cuhva cuenda tsi ra Jesús tsi nu xaan iñi tsi ra, vasu iin ra tsa utsi uvi can cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tsa yaha̱ yacan, tan nyií ra Jesús tsicá nuu ra nu cuví Galilea. Ña cuñí ra cuhun ra nu cuví Judea tyin ra cuví ityi nuu tsihin nyɨvɨ Israel can naha ra cuñí ra naha cahñi ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tan tsa cuyatyin quɨvɨ vico tsa jacahnú nyɨvɨ Israel ndɨhɨ ñi cuiya. Tan nañí tsi Vico Tyahva. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yacan cuenda catyí ra yañi ra Jesús tsihin ra: ―Ña ndoo un ihya. Cu̱aahan Judea tyin nyɨvɨ nyicún tsi un tsa iyó ndacan nyehe ñi tyiñu javahá un. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tyin tatun cuñí yo tsa coto nyɨvɨ tsi yo, ña javahá xeehe yo tsa javahá yo. Tan yooho tatun nditsa tsa javahá un, ja̱vaha can nuu tandɨhɨ nyɨvɨ ―catyí tandɨhɨ yañi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tacan catyí ra naha tyin ndi tsa cuví ra naha yañi ra tan ña tsinú iñi ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tacan tan catyí ra Jesús tsihin ra naha: ―Ñaha ca tsaa hora tsa cuhun yuhu. Maa tyin nyooho ndáa quɨvɨ ñi cuví cuhun ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tyin vaha cuñí nyɨvɨ nyehé ñi tsi ndo, maa tyin yuhu ndasɨ cuñí ñi nyehé ñi tsi yu tsa cuenda tyin caahán catsi yu tsihin ñi tyin ña vaha tsa javahá ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cu̱aahan nyooho vico can. Yuhu ña cuhun yu tyin ñaha ca tsaa hora tsa taahán tsi cuhun yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yaha̱ can tan ndoo̱ ra nu cuví Galilea. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tsa yaha̱ cuahán yañi ra Jesús vico can, tsahan cuahán ndɨhɨ ra, maa tyin cuahán xeehe ñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tan ra cuví ityi nuu tsihin nyɨvɨ Israel nanducú ra naha tsi ra nu iyó vico can, tan nducú tuhun tahan ra naha tsi ra naha: ―¿Numaa nyií ra can? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tan caahán nyɨvɨ yucú vico can tuhun ra. Yɨhɨ́ ñi catyí ñi: “Iin ra vaha cuví ra.” Tan inga ñi catyí ñi: “Ña vaha ra, jandaví ñaha ra tsi nyɨvɨ”, catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Maa tyin yoñi caahán nditsin tuhun ra tsa cuenda tsa yuuhví ñi tsi ra cuví ityi nuu can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tsa cusava iyó vico tan tsaa̱ ra Jesús tsitsi vehe ñuhu cahnu tan quitsaha̱ jacuaha ra tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tan ra cuví ityi nuu can iyó cuñí ra naha tan quitsaha̱ natuhun tahan ra naha: ―¿Nacaa tyin tsitó ra ihya tan ña cahvi̱ ra? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tan nacaha̱n ra Jesús tan catyí ra: ―Tuhun tsa jacuahá yu, ñavin tsa cuenda maa yu cuví tsi, maa tyin cuenda ra tsa jaquitsi̱ tsi yu cuví tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tatun yɨhɨ́ nyooho tsa cuñí javaha cuhva cuñí Nyoo, cua coto ndo tyin cuenda Nyoo jacuahá yu tan ñavin tsa cuenda maa yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nyɨvɨ tsa caahán cuenda maa ñi, caahán ñi tyin cuñí ñi tsa jacahnu nyɨvɨ tsi ñi. Maa tyin ra nducú tsa jacahnu nyɨvɨ tsi Nyoo, ra tsa jaquitsi̱ tsi ra, ra ican caahán tsa nditsa. Tan ña jandaví ñaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿A ña nditsa tyin ra Moisés tsaha̱ ra ley tsi ndo? Maa tyin ndi intuhun nyooho tan ña tyaá yahvi ndo ley can. ¿Nacuenda cuñí ndo cahñi ndo tsi yu? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tan nacaha̱n nyɨvɨ tan catyí ñi tsihin ra: ―Tatyi ña vaha yɨhɨ́ tsi yooho. Yoñi cuñí cahñi tsi un ―catyí ñi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tan catyí ra Jesús: ―Tsacatyi tsa javaha̱ yu tsa iyo quɨvɨ quitatu yo, yacan ndasɨ cuñí ndo nyehé ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Maa tyin ra Moisés catyí ra tsihin ndo tyin coo ndo tsihin tsa cunyaa tuñi Nyoo tsi sehe yɨɨ ndo. Vasu ñavin ra quitsaha̱ tsihin tuhun can, maa tyin nyɨvɨ cuví nyɨvɨ ra ityi tsata, jihna ca ñi javaha̱ tacan. Yacan cuenda javahá ndo can vasu taahán tsi quɨvɨ quitatu yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tan vityin, vaha tatun tsa cuenda tsa ña cuñí ndo cumañi ndo ley ra Moisés tan javahá ndo tuhun can vasu quɨvɨ quitatú yo cuví. Maa tyin tatun tacan javahá ndo, ¿nacuenda tyin cuxaan ndo tsi yu tsa janduvaha̱ yu tsi ra can quɨvɨ quitatú yo? ");
INSERT INTO mjcNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ña tyaa ndo cuatyi sɨquɨ nyɨvɨ tatun ña tsitó vaha ndo náa javahá ñi. Cu̱atu ndo nda nyehe vaha ndo, tacan tan coto ndo nácaa tatsi tuñi ndo tsi ñi tsihin tsa ndaa tan tsihin tsa nditsa. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tacan tan juhva nyɨvɨ iyó Jerusalén, quitsaha̱ tsicá tuhun ñi: ―¿A ñavin ra ihya nanducú xaan ra naha tyin cua cahñi ra naha tsi ra? ");
INSERT INTO mjcNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Caahán nditsin ra tsihin nyɨvɨ. Tan yoñi caahán náa caahán tsihin ra. Vasɨquɨ tsinú ndɨhɨ maa iñi ra cuví ityi nuu naha ra tyin juvin ra ihya cuví ra Cristo ra cuví rey tsa jaquitsi̱ Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yoo tsitó vaha yo nu quee̱ ra ihya, tan quɨvɨ quitsi ra Cristo yoñi maa cua coto numaa ityi cua quee̱ ra ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ra Jesús nyií ra tsitsi vehe ñuhu jacuahá ra, tan tsitó ra tsa natuhún nyɨvɨ, yacan cuenda ñihi caha̱n ra tan catyí ra: ―¡Nyooho cuñí maa ndo tyin nacotó ndo tsi yu tan tsitó ndo numaa quee̱ yu! Maa tyin yuhu ña vatsí yu cuenda maa yu. Yuhu vatsí yu cuenda ra tsa jaquitsi̱ tsi yu, ra tsa cuví tsa nditsa. Nyooho ña nacotó ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yuhu nacotó yu tsi ra tyin cuenda ra vatsí yu, tan maa ra jaquitsi̱ tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tacan tan cuñí ra naha tyihi ra naha tsi ra tsitsi vehe caa. Maa tyin ndi intuhun ra naha tan ña caná iñi ra naha tɨɨ̱n ra naha tsi ra tsa cuenda tyin ñaha ca tahan tsi quɨvɨ tsa taahán maa tsi tɨɨn ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Maa tyin cuaha xaan nyɨvɨ tsinu̱ iñi tsi ra. Tan catyí ñi: ―Ra ihya cuví ra Cristo. ¿A cuaha ca tsa iyo cua javaha inga ra tatun quitsi ra tan ñavin ca ra ihya? ―catyi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tsa tsiñi̱ ra fariseo naha ra tsa caahán nyɨvɨ tuhun ra Jesús, maa ra naha tan ra cuví ityi nuu tsihin ra jutu naha ra, jacuhu̱n ra naha vitya cuenda vehe ñuhu, na tɨɨn ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tacan tan catyí ra Jesús: ―Juhva cuii ña quɨvɨ cua cunyaa yu tsihin ndo. Yaha̱ can tan cuacunuhu yu nu nyaá ra tsa jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nyooho cua nanducu ndo tsi yu. Maa tyin ña cua nañihi ndo tsi yu. Tyin ña cua cuvi cuhun ndo nu cua cunyaa yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tacan tan quitsaha̱ natuhún tahan ra cuví ityi nuu tsihin nyɨvɨ Israel naha ra: ―¿Numaa cua cuhun ra ihya tsa ña cua nañihi yo tsi ra? ¿A cuhun ra nu iyó ra Israel ñuu Grecia naha ra tyin jacuaha ra tsi nyɨvɨ iyó Grecia can? ");
INSERT INTO mjcNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Náa cuñí tsi catyi tsa caahán ra tsihin yo? Tyin catyi ra: “Cua nanducu ndo tsi yu maa tyin ña cua nañihi ca ndo tsi yu tyin ña cua cuvi cuhun ndo nu cua cunyaa yu” ―tacan caahán yuhu tahan ra naha tuhun ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Quɨvɨ ndɨhɨ tsicoo̱ vico, yacan cuví quɨvɨ tsa ñiñi ca. Tan quɨvɨ can nduvita̱ ra Jesús tan ñihi caahán ra tan catyí ra: ―Tatun ndáa nyooho na ityi iñi ndo, na̱ha ndo tan tsi̱nu iñi ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tyin nyɨvɨ tsa tsinú iñi tsa caahán yu, cua cunu ndutya nyito tsitsi añima ñi tumaa tsinú ndutya iin yutya, tumaa catyí maa nu tutu Nyoo ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Maa tyin tsihin yacan cuñí ra catyi ra tyin ñi tsinú iñi tsi ra cua ñihi ñi Tatyi Ii Nyoo, tyin quɨvɨ can ñaha ca quitsi Tatyi Ii Nyoo tyin ra Jesús, ñaha ca cunuhu ra nda gloria nu cua jacahnu Jutu ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Juhva nyɨvɨ tsa tsiñi̱ yacan, catyí ñi: ―Nditsa tsa cuii tyin ra ihya cuví ndusu yuhu Nyoo tsa nyaá tsa cua quitsi ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tan inga ñi catyí ñi: ―Ra ican cuví ra Cristo ra tsa jaquitsi̱ Nyoo ―catyí ñi. Maa tyin inga nyɨvɨ catyí ñi: ―¿Nacaa tyin ra Galilea cua cuvi ra Cristo? ");
INSERT INTO mjcNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tyin nu tutu Nyoo catyí tsi tyin ra Cristo cua cuvi ra nyɨvɨ tata ra rey David, tan ra ñuu Belén tsa canyií nu cuví Galilea cua cuvi ra, tumaa ra David ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tacan tan nyɨvɨ can natahvi̱ sava ñi tsa cuenda ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yɨhɨ́ ñi cuñí ñi quihin ñi tsi ra tan tyihi ñi tsi ra tsitsi vehe caa. Maa tyin yoñi tɨɨ̱n tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tacan tan ra vitya tsa iyó vehe ñuhu cahnu can, cuanuhu ra naha nu yucú ra fariseo naha ra tsihin ra cuví ityi nuu tsihin ra jutu naha ra. Tan tsica̱ tuhun ra naha tsi ra vitya can naha ra tan catyí ra naha: ―¿Nacuenda ña quihi̱n ndo tsi ra? ");
INSERT INTO mjcNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tan catyí ra vitya can naha ra: ―¡Ndi intuhun tsaha tan yoñi tuhva caahán tumaa caahán ra can! ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tacan tan catyí ra fariseo naha ra tsihin ra vitya can naha ra: ―¿A jandavi̱ ñaha ndɨhɨ ra can tsi nyooho? ");
INSERT INTO mjcNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nye̱he ndo tyin ndi intuhun ra cuví ityi nuu tsihin ndi, tan ra cuví fariseo naha ra, tan ña tsinú iñi ra naha tsi ra can. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Maa ñi maa nyɨvɨ ña tsitó ley nyicún tsi ra. Tan ña vaha ñi nuu Nyoo ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tacan tan ra Nicodemo, ra tsa tsaha̱n nu nyií ra Jesús tsa tsacuaa, cuví ndɨhɨ tucu ra fariseo, tan catyí ra tsihin ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Catyí ley tyin ña cuví tatsi tuñi yo tsi iin nyɨvɨ tatun ñaha ca cuñi jihna yo tsa caahán ra, tan coto yo náa javaha̱ ra ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tacan tan nacaha̱n ra naha tan catyí ra naha tsihin ra: ―¿A juvin ñi ra Galilea cuví ndɨhɨ tucu yooho? Ca̱hvi nu tutu Nyoo tan nye̱he un, tyin ndi intuhun ra cuví ndusu yuhu Nyoo tan ña nyaá tsi tsa quitsi ra nda Galilea ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tacan tan cuanuhu intuhun intuhun ra naha nda yuvehe ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Maa tyin ra Jesús cuahán ra yucu Olivo. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tsa cunditsin inga quɨvɨ, cuahán nyico ra Jesús inga tsaha vehe ñuhu cahnu. Tan tandɨhɨ nyɨvɨ natuhva̱ ñi nu nyií ra. Tan tsinyaa̱ ra tan quitsaha̱ caahán ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tacan tan ra jacuahá ley vehe ñuhu tan ra cuví fariseo naha ra tsaa̱ ra naha tsihin iin ñaha iyó yɨɨ tyin tɨɨ̱n ra naha tsi ña nu tsicoo̱ cuatyi ña tsihin inga rayɨɨ. Tan tyaa̱ ra naha tsi ña mahñu nyɨvɨ tsa nyecú can. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tan quitsaha̱ catyí ra naha tsihin ra Jesús: ―Maestro, tɨɨ̱n ndi tsi ñaha ihya nu tsicoo̱ cuatyi ña tsihin inga rayɨɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tyin ley tsa tyaa̱ ra Moisés catyí tsi tyin ñiñaha tsa javahá tacan taahán tsi cahñi yo tsi ñi tsihin yuu. Tan yooho, ¿nácaa catyi un? ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Caahán ra naha yacan tsihin ra Jesús tsa cuenda tsa nducú cuhva ra naha tsi ra tan tyaa ra naha cuatyi sɨquɨ ra. Tacan tan tsinyaa̱ tyayɨɨ ra Jesús nu ñuhu tan quitsaha̱ tyaá ra letra nu ñuhú tsihin nundaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Maa tyin nducú tuhun ca ra naha tsi ra, tacan tan nduvita̱ nyityi ra tan catyí ra tsihin ra naha: ―Nyooho tsa nduve cuatyi jihna ca ndo qu̱ihin yuu tan ca̱ñi ndo tsi ña ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tan tsinyaa̱ tyayɨɨ nyico ra tan quitsaha̱ jañihí ca ra tyaá ra letra nu ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tsa tsiñi̱ ra naha tsa caahán ra tacan, tuvi̱ iñi ra naha tyin iyó tucu cuatyi maa ra naha. Tan quitsaha̱ quitá intuhun intuhun ra naha, jihna ca ra tsahnu naha ra quita̱. Cuhva tsa ndɨhɨ̱ ra naha quita̱ cuahán tan ndoo̱ intuhun ña maa ra Jesús tsihin ñaha can mahñu nu nyecú nyɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tacan tan nduvita̱ nyityi ra Jesús tan nyehe̱ ra tyin tsa cuahán ra naha tan ndoo̱ intuhun ña ñaha can. Tacan tan catyí ra tsihin ña: ―¿Numaa cuahán ra tsa tyaa̱ cuatyi sɨquɨ un naha ra vityin? ¿Yoñi, ndi intuhun ca ra tsa catyí tyin taahán tsi cúu un? ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tan nacaha̱n ña tan catyí ña: ―Ndi intuhun ra, Tatta. Tacan tan catyí ra Jesús tsihin ña: ―Ndi yuhu tan ña catyí yu tyin taahán tsi cúu un. Cu̱aahan vityin. Tan ña ja̱vaha ca un cuatyi ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tacan tan caha̱n nyico ra Jesús tsihin nyɨvɨ inga tsaha, tan catyí ra tsihin ñi: ―Yuhu cuví ra tsa jandunditsín añima nyɨvɨ iyó nu ñuhu ñayɨvɨ. Yóo nyɨvɨ tsa nyicún tsi yu, cua coo ñi iin ñayɨvɨ nyito nu nditsin. Tan ña cua caca nuu ñi nu naa ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tacan tan ra cuví fariseo naha ra catyí ra naha tsihin ra: ―Yooho, caahán un tumañi iñi tsa cuenda maa un. Yacan cuenda nduve yahvi nyaá can ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nacaha̱n ra Jesús tan catyí ra: ―Vasu juvin ñi maa yu caahán tumañi iñi tsa cuenda yu, maa tyin tsa caahán yu iyó yahvi tsi tyin yuhu tsitó yu numaa ityi quee̱ yu tan numaa ityi cua cuhun yu. Maa tyin nyooho ña tsitó ndo numaa ityi quee̱ yu tan numaa ityi cua cuhun yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyooho yatyi xaan caahán ndo tsa caa nyɨvɨ. Maa tyin yuhu, ña caahán yu tsa caa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tyin tatun cahan yu tsa caa nyɨvɨ, tsa nditsa cua cahan yu. Tyin ñavin intuhun ñi maa yu nyehé tsa iyó añima ñi, tyin Jutu yu ra tsa jaquitsi̱ tsi yu, ra ican nyehé iin caa ñi tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nu ley nyooho nyaá tyin tatun uvi ra tsahá tsa ndaa, cuñí tsi tsinú iñi yo tsa caahán ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tan vityin vaha tyin juvin ñi maa yu cuví tsa ndaa tsa cuenda maa yu. Tan Jutu yu, ra tsa jaquitsi̱ tsi yu, cuví inga tsa ndaa ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tacan tan tsica̱ tuhun ra naha tsi ra: ―¿Numaa nyií jutu un? Tan catyí ra Jesús: ―Nyooho ña tsitó ndo tsi yuhu. Tan ndi Jutu yu tan ña tsitó ndo. Tun tsatyin tsitó ndo tsi yu, coto ndɨhɨ ndo tsi Jutu yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tuhun ihya caha̱n ra Jesús tsitsi tsa jacuahá ra tsitsi vehe ñuhu cahnu, nu nyií caja nu tyihí nyɨvɨ xuhun. Maa tyin yoñi tyihi̱ tsi ra vehe caa, tyin ñaha ca tahan tsi quɨvɨ tsa taahán tsi cuhun ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tacan tan quitsaha̱ caahán nyico ra Jesús tsihin ra Israel naha ra tan catyí ra: ―Yuhu cua cuhun yu, tan cua nanducu ndo tsi yu, maa tyin cua cúu ndo tan cua ndoo cuatyi ndo sɨquɨ ndo. Tyin nu cua cuhun yuhu, nyooho ña cua cuvi cuhun ndo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tacan tan catyí ra Israel naha ra: ―¿A cua cahñi maa ra tsi ra? tyin catyí ra tyin ña cua cuvi cuhun yo nu cuahán ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tacan tan catyí ra Jesús: ―Nyooho ra cuenda nu ñuhu ihya cuví ndo. Maa tyin yuhu nda ityi sɨquɨ quee̱ yu. Nyooho cuenda ñuhu ñayɨvɨ ihya cuví ndo. Maa tyin yuhu ñavin cuenda nu ñuhu ñayɨvɨ ihya cuví yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yacan cuenda catyí yu tsihin ndo tyin cua cúu ndo tan cua ndoo cuatyi ndo sɨquɨ ndo. Tyin tatun ña tsinú iñi ndo tsa yuhu cuví ra jatsiyó cuatyi ndo, cua ndoo cuatyi ndo sɨquɨ ndo quɨvɨ cúu ndo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tacan tan quitsaha̱ tsicá tuhun ra naha tsi ra, tan catyí ra naha: ―¿Yóo ra cuví yooho? Nacaha̱n ra Jesús tan catyí ra: ―Tsa yaha caha̱n yu tsihin ndo nda quɨvɨ jihna. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Cuaha xaan ca tsa ndi cumañi cahan yu tsihin ndo, tan ndi cumañi cahan yu cuhva iyó ndo. Maa tyin tsa caahán yu tsihin nyɨvɨ iyó nu ñuhu ñayɨvɨ, cuví tsi tsa tsiñi̱ yu tsa caahán ra tsa jaquitsi̱ tsi yu. Tan maa ra caahán tsa nditsa ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Maa tyin ra Israel naha ra ña cutuñi̱ iñi ra naha tatun tuhun Nyoo Jutu yo caha̱n ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yacan cuenda catyi̱ ra tsihin ra naha: ―Cua tyaa ndo tsi yuhu, ra cuví Rayɨɨ tsa quee̱ nda gloria, nu cruu. Tacan tan cua coto ndo tyin yuhu cuví yu tsa caahán yu tyin cuví yu, tan cua coto ndo tyin tyiñu jahá yu ñavin tsa cuenda maa yu javahá yu can, maa tyin caahán yu tsa janahá Jutu yu tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tyin Jutu yu, ra tsa jaquitsi̱ tsi yu, nyií ra tsihin yu. Tan ña nacoó ra tsi yu tsa maa ñi maa yu. Tyin yuhu javahá yu maa ñi maa cuhva cuñí ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tsa caha̱n ra Jesús yacan, cuaha xaan ra naha quitsaha̱ tsinú iñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tacan tan catyí ra Jesús tsihin nyɨvɨ Israel, tsa quitsaha̱ tsinú iñi tsi ra: ―Tatun nyooho tan jañihi ca ndo tyaa yahvi ndo cuhva jacuahá yu tsi ndo, cua tsaa ndo cuvi ndo nyɨvɨ tsa nditsa yɨhɨ cuenda yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tan cua coto ndo tsa nditsa. Tan tsa nditsa can cua tava nuña tsi ndo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tan nacaha̱n ra naha tan catyí ra naha: ―Nyuhu nyɨvɨ tata ra Abraham cuví ndi. Ndi iin tsaha tan ñaha ca cuvi ndi musu nyɨvɨ. ¿Nacaa tsa catyí yooho tyin quita nuña ndi? ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tan catyí ra Jesús: ―Tsa nditsa catyí yu tsihin ndo tyin tandɨhɨ nyɨvɨ javahá tsa caquiñi, musu cuenda tsa caquiñi cuví ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Iin musu ña ndoo cuii ra vehe tsitoho ra. Maa tyin ra cuví sehe tsitoho vehe can, ndoo cuii ra vehe jutu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yacan cuenda tatun yuhu tsa cuví yu Sehe Nyoo tan jacacu yu tsi ndo, tsa nditsa cuii tyin ña cua cundaca ñaha ca tsa ña vaha tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tsa tsitó yu tyin tata ra Abraham cuví ndo. Maa tyin yɨhɨ́ ndo cuñí ndo cahñi ndo tsi yu, tyin ña naquihín vaha ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yuhu caahán yu tsa janaha̱ Jutu yu tsi yu. Tan nyooho javahá ndo tsa caahán ra cuví jutu ndo tsihin ndo ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tan nacaha̱n ra naha tan catyí ra naha: ―Jutu ndi cuví tsi ra Abraham ―catyí ra naha. Maa tyin ra Jesús catyí ra tsihin ra naha: ―Tun tsatyin nditsa tsa tata ra Abraham cuví tsi ndo, cua javaha ndo tsa javaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Maa tyin nyooho, vasu caahán yu tsihin ndo tsa nditsa tsa janaha̱ Nyoo tsi yu, nyooho cuñí ndo cahñi ndo tsi yu. ¡Ra Abraham ña javaha̱ ra tacan! ");
INSERT INTO mjcNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nyooho javahá ndo tumaa javahá jutu ndo ―catyí ra tsihin ra naha. Tacan tan nacaha̱n ra naha tan catyí ra naha: ―Nyuhu ñavin sehe ndaahvi tsi ndi. Iyó intuhun jutu ndi tan ra ican cuví Nyoo ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tacan tan catyí ra Jesús: ―Tun tsatyin nditsa tyin Nyoo cuví jutu ndo, cua cuñi ndo tsi yu. Tyin yuhu quee̱ yu nu nyaá ra tan tsaa̱ yu ihya. Ña vatsí yu cuenda maa yu, tyin maa Nyoo jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Nacuenda ña cutuñí iñi ndo tsa caahán yu tsihin ndo? Tsa cuenda tyin ña cuñí ndo tyaa soho ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Cuihna cuví jutu ndo. Tan sehe nu tsi ndo. Tan cuñí ndo javaha ndo cuhva cuñí nu. Tan nu ña vaha can cuví nu tsahñí nyɨvɨ nda quɨvɨ jihna. Tan ña javahá nu tsa nditsa. Ndi iin tsaha ña caahán nu tsa nditsa. Maa ñi maa tsa jandavi ñaha nu tsi nyɨvɨ tyin cuñí nu tsa coo ñi cuhva iyó nu tyin vatya xaan nu. Tan jutu nyɨvɨ vatya cuví nu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tan yuhu caahán yu tsa nditsa, maa tyin nyooho ña tsinú iñi ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ndáa nyooho tan cuví janaha ndo tyin iyó cuatyi yu? Ndi intuhun ndo. Tan tsa tacan caahán yu tsa nditsa, ¿nácaa tsa ña tsinú iñi ndo tsi yu? ");
INSERT INTO mjcNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nyɨvɨ cuenda Nyoo tyaá soho ñi tuhun caahán ra. Maa tyin nyooho ñavin nyɨvɨ cuenda Nyoo cuví ndo, yacan cuenda ña cuñí ndo tyaa soho ndo tsa caahán yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tacan tan catyí ra Israel naha ra tsihin ra: ―¿A ña nditsa tyin yooho ra ñuu Samaria cuví un, tan yɨhɨ́ tatyi ña vaha tsi un? ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tan nacaha̱n ra Jesús tan catyí ra: ―Nduve tatyi ña vaha yɨhɨ́ tsi yuhu. Tsi Jutu yu jacahnú yu. Tan nyooho caahán ndo ndavaha ñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yuhu ña nducú yu tsa jacahnu nyɨvɨ tsi yu, maa tyin iyó iin ra nanducú tsa jacahnu ñi tsi yu. Tan maa ra cua jandaa cuatyi ndo tatun ña jacahnú ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tsa nditsa catyí yu tyin nyɨvɨ tsa tyaá yahvi tsa caahán yu ña cua tsaa tuhun tsiihí añima ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tacan tan nacaha̱n ra Israel can naha ra tan catyí ra naha: ―Vityin tsitó vaha ndi tyin yɨhɨ́ tatyi ña vaha tsi un. Tyin ra Abraham tan tandɨhɨ ca ra cuví ndusu yuhu Nyoo tsihi̱ ra naha. Tan yooho catyí un tyin nyɨvɨ tyaá yahvi tsa caahán un ña cua cúu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿A cahnu ca ra cuví yooho tan ñavin ca ra Abraham jutu yo? Maa ra tsihi̱ ra tan tacan tucu ra cuví ndusu yuhu Nyoo. ¿Yóo ra cuví yooho cuñí maa un? ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tan nacaha̱n ra Jesús tan catyí ra: ―Tatun juvin ñi maa yu jacahnú tsi yu, nduve yahvi nyaá yacan. Maa tyin ra jacahnú tsi yu, juvin ra cuví Jutu yu. Tan juvin ra cuví ra tsa caahán nyooho tuhun tyin Nyoo ndo cuví tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Maa tyin ña nacotó ndo tsi ra. Tan yuhu, nacotó yu tsi ra. Tun tsatyin catyí yu tyin ña nacotó yu tsi ra, cuví yu iin ra vatya tumaa nyooho. Maa tyin yuhu nditsa tsa nacotó yu tsi ra, tan tyaá yahvi yu tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ra Abraham tsii tsaahnu yo sɨɨ xaan cuñi̱ ra tyin cua nyehe ra quɨvɨ cua quitsi yuhu nu ñuhu ñayɨvɨ. Nyehe̱ ra quitsi̱ yu tan sɨɨ xaan cuñi̱ ra ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tacan tan catyí ra Israel can naha ra tsihin ra Jesús: ―Ndi ñaha ca quita uvi xico utsi cuiya un, ¡tan catyí un tyin nyehe̱ un tsi ra Abraham! ");
INSERT INTO mjcNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tan nacaha̱n ra Jesús tan catyí ra: ―Tsa nditsa catyí yu tsihin ndo tyin nda ndi cumañi ca coo ra Abraham tan tsa iyó maa yuhu ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tacan tan quihi̱n ra naha yuu tyin cua cañi ra naha tsi ra Jesús. Maa tyin iin yaha ñi quɨhvɨ̱ xeehe ra tan yaha̱ ra mahñu ra naha tan quita̱ ra tsitsi vehe ñuhu can cuahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Cuhva tsa yaha̱ ra Jesús iin nu yaha̱ ra, nyehe̱ ra tsi iin ra cuaa nda cacu̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tan quitsaha̱ tsicá tuhun ra tsicá tsihin ra tsi ra: ―Maestro, ¿nacuvi tyin cuaa ra ihya cacu̱ ra? ¿A tsa cuenda cuatyi jutu ra tan sɨhɨ ra, o tsa cuenda cuatyi maa ra? ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tan nacaha̱n ra Jesús tan catyí ra: ―Ñavin tsa cuenda cuatyi maa ra, tan ndi ñavin tsa cuenda cuatyi jutu ra tan sɨhɨ ra. Cuaa maa ra tyin tacan tan cuví janaha Nyoo tunyee iñi ra tsi nyɨvɨ tsa cuenda ra can. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tsa tsinu cahñi, cuñí tsi tsa javaha yu tyiñu ra tsa jaquitsi̱ tsi yu. Tyin tsa yatyin cuii cua cuaa tan ña cua cuvi ca jaha tyiñu yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tsa ndi nyií yu nu ñuhu ñayɨvɨ ihya, ñuhu̱ jandunditsín cuenda nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya cuví yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tsa yaha̱ tsa caha̱n ra Jesús tacan, tan tɨvɨ̱ sɨɨ ra nu ñuhu̱. Tan jatyii̱ ra luxu nyahyu tsihin sɨɨ ra tan tyaa̱ ra tinuu ra cuaa can. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tacan tan catyí ra tsihin ra cuaa can: ―Cu̱aahan cua nacatya nuu un nda tanque Siloé. ―Sɨvɨ can cuñí tsi catyí: “Jacuhu̱n Yu Tsi Un.” Tacan tan ra cuaa can tsaha̱n ra tsinacatya̱ ra nuu ra. Tan cuhva tsa tsaa̱ nyico ra, tsa nyehé ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tacan tan nyɨvɨ iyó yatyin yuvehe ra, tan nyɨvɨ tsa nyehe̱ tsi ra tsa ndi cuaá ra catyí ñi: ―¿A ñavin ra ihya cuví ra tuhvá tsinyaá tsicán xuhun? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tan yɨhɨ́ ñi catyí: ―Juvin ra. Inga ñi catyí ñi: ―Ñavin ra cuví can, maa tyin tacan caá ra. Maa tyin maa ra catyí ra: ―Juvin yu cuví ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tacan tan quitsaha̱ tsicá tuhun ñi tsi ra: ―¿Tan nácaa tyin cuví nyehé un vityin? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tan catyí ra: ―Ra tsa nañí Jesús, ra ican jatyii̱ nyahyu tan tyaa̱ ra tinuu yu tan catyí ra tsihin yu: “Cu̱aahan cua nacatya nuu un nda tanque Siloé.” Tacan tan tsaha̱n yu. Tan tsa yaha̱ nacatya̱ yu nuu yu tan nanyehe̱ yu ―catyí ra tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tacan tan quitsaha̱ tsicá tuhun ñi tsi ra: ―¿Tan numaa nyií ra can vityin? Tan catyí ra tsihin ñi: ―Ña tsitó yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tacan tan tsindaca̱ ñi tsi ra tsa nduvaha̱ can nuu ra cuví fariseo naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tyin quɨvɨ tsa jatyii̱ ra Jesús nyahyu tan janduvaha̱ ra tsi ra can, cuví tsi quɨvɨ quitatú nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yacan cuenda ra cuví fariseo naha ra tsica̱ tuhun nyico ra naha tsi ra nácaa tyin nyehé ra. Tan catyí ra tsihin ra naha: ―Tyaa̱ ra nyahyu tinuu yu, tan nacatya̱ nuu yu tan vityin nditsin nyehé yu ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tacan tan catyí juhva ra fariseo naha ra: ―Ra tsa javaha̱ yacan ñavin cuenda Nyoo cuví ra, tyin ña tyaá yahvi ra quɨvɨ quitatú yo ―catyí ra naha. Maa tyin catyí inga ra naha ―¿Nacaa tsa cuví javaha̱ ra tsa iyo ihya tatun ra iyó cuatyi cuví ra? ―catyí ra naha. Tan sɨɨn sɨɨn tsa caahán ra naha. Tan natahvi̱ sava ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tan tsica̱ tuhun nyico ra naha tsi ra nduvaha̱ can inga tsaha, tan catyí ra naha tsihin ra: ―¿Tan yooho, náa catyí un tuhun ra tsa janduvaha̱ tinuu un? ―catyí ra naha. Tan nacaha̱n ra tan catyí ra: ―Yuhu catyí yu tyin ra cuví ndusu yuhu Nyoo cuví ra ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Maa tyin ra cuví ityi nuu tsihin nyɨvɨ Israel ña cuñí ra naha tsinu iñi ra naha tsa cuaa̱ ra can tan nanyehe̱ ra. Nda cuanda cana̱ ra naha tsi jutu ra tan tsi sɨhɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tan tsica̱ tuhun ra naha tsi ñi, tan catyí ra naha: ―¿A ra ihya cuví sehe ndo tsa catyí ndo tyin cuaá ra cacu̱ ra? ¿Nacaa tsa cuví nyehé ra vityin? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nacaha̱n jutu ra tan sɨhɨ ra tan catyí ñi: ―Tsitó ndi tyin ra ihya cuví sehe ndi. Tan cuaa ra quɨvɨ cacu̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Maa tyin ña tsitó ndi nácaa tsa cuví nyehé ra vityin. Tan ndi ña tsitó ndi yóo janduvaha̱ tinuu ra. Nda̱ca tuhun maa ndo tsi ra. Tsa iyó tucu maa cuiya ra. Tan cuví nacatyi tuhun maa ra tsihin ndo ―catyí ñi tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jutu ra tan sɨhɨ ra caahán ñi tacan tsa cuenda tyin yuuhví ñi tsi ra cuví ityi nuu tsihin nyɨvɨ Israel naha ra, tyin tsa natuhu̱n tahan ra naha tyin cua tava cuii ra naha tsi nyɨvɨ vehe ñuhu, tun cahan ñi tyin ra Jesús cuví ra Cristo, ra tsa jaquitsi̱ Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yacan cuenda catyi̱ ñi: “Nda̱ca tuhun ndo tsi maa ra. Ra tsa ñihi cuví ra.” ");
INSERT INTO mjcNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tacan tan cana̱ nyico ra naha tsi ra tsa nduvaha̱ can inga tsaha. Tan catyí ra naha tsihin ra: ―Nda nuu Nyoo ca̱han tsa nditsa tsihin ndi. Tyin nyuhu tsitó ndi tyin ra ican, ra iyó cuatyi cuví ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tacan tan nacaha̱n ra tsa nduvaha̱ can tan catyí ra: ―Yuhu ña tsitó yu tatun ra iyó cuatyi cuví ra, a ñavin. Intuhun ñi tsa tsitó yu tyin yuhu ra cuaa cuví yu, maa tyin vityin nditsin nyehé yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tan tsica̱ tuhun nyico ra naha tsi ra inga tsaha tan catyí ra naha: ―¿Náa ica̱ ra tsihin un? ¿Nacaa ica̱ ra tan nanyehe̱ un? ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tan catyí ra: ―Tsa caha̱n yu tsihin ndo, tan ña tyaá yahvi ndo tsi yu. ¿Náa cuenda cuñí ndo tsa cahan yu inga tsaha? ¿A cuñí ndɨhɨ ndo cunyicun ndo tsi ra can? ");
INSERT INTO mjcNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tacan tan nduxaa̱n ra naha tsi ra, tan catyí ra naha: ―Yooho tsa yɨhɨ́ un cuenda ra, maa tyin nyuhu cuenda ra Moisés ra tsa tsicoo̱ tsa naha yɨhɨ́ ndi. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nyuhu tsitó ndi tyin Nyoo caha̱n tsihin ra Moisés taha̱n tsa naha. Maa tyin ra can, ndi ña tsitó ndi numaa quee̱ ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tacan tan nacaha̱n ra tsa nduvaha̱ can tan catyí ra: ―¡Naa tsa iyo cahnu cuví tsehe! Nyooho ña tsitó ndo numaa quee̱ ra, tan jananyehe̱ ra tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tsitó vaha yo tyin Nyoo ña tyaá soho ra nu caahán ra iyó cuatyi. Maa tyin ra jacahnú tsi ra tan icá ra cuhva cuñí ra, tyaá soho Nyoo tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ndi iin tsaha tan ñaha ca cuñi yo tatun iyó iin ra jananyehe̱ tsi iin ra cuaá nda cacu̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tun tsatyin ra ihya tan ñavin cuenda Nyoo vatsí ra, nduve tsa cuví javaha ra ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tacan tan catyí ra naha tsihin ra: ―Yooho ra iyó cuatyi cuví un nda cacu̱ un. ¿Tan cuñí un jacuaha un tsi nyuhu? ―catyí ra naha. Tan tava̱ cuii ra naha tsi ra vehe ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tsitó ra Jesús tyin tava̱ ra naha tsi ra tsa janduvaha̱ ra vehe ñuhu. Tan tsa ñihi̱ tahan ra tsihin ra tan catyí ra tsihin ra: ―¿A tsinú iñi yooho tsa caahán Rayɨɨ tsa quee̱ nda gloria? ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tan nacaha̱n ra tan catyí ra: ―Ca̱tyi tuhun tsihin yu, taa, yóo ra cuví ra tyin tsinú iñi yu tsi ra ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tan catyí ra Jesús: ―Tsa nyehe̱ un tsi ra. Tan juvin ra natuhún tsihin un ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tacan tan tsicuɨñɨ̱ tsɨtɨ ra tsaha ra Jesús tan catyí ra tsihin ra: ―Tsinú iñi yu tsi un, Jutu Mañi yu ―catyí ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tan catyí ra Jesús: ―Yuhu vatsí yu tyin catyi tuhun yu tsa iyó añima nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya. Tyin nyɨvɨ cuaa, ñi ña tsitó tuhun Nyoo cua nanyehe ñi tyin coo tuhun Nyoo añima ñi. Tan nyɨvɨ cuñí tyin nditsin nyehe ñi, catyí ñi tyin tsitó ñi tuhun Nyoo, coto ñi tyin cuaa ñi tyin ña tsinú iñi ñi tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tacan tan juhva ra fariseo tsa nyecú tsihin ra Jesús tsiñi̱ ra naha tsa caahán ra, tan catyí ra naha tsihin ra: ―¿A cuaa ndɨhɨ tucu nyuhu? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tacan tan catyí ra Jesús tsihin ra naha: ―Tun tsatyin cuaa ndo cua coto ndo tyin tsiñí ñuhu tuhun Nyoo tsi ndo, tan ña cua coo cuatyi ndo. Maa tyin catyí ndo tyin nyehé ndo tan tsitó ndo, yacan cuenda ndoó cuatyi ndo sɨquɨ ndo ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Caahán nyico ra Jesús tan catyí ra: ―Tsa nditsa catyí yu tsihin ndo, tatun iin ra cua quɨhvɨ tsitsi cora mbee ticatyi, tan ñavin yuhu cora quɨhvɨ́ ra, ra ican cuví ñasuhu. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Maa tyin ra tsa quɨhvɨ́ ityi yuhu cora, ra jahá cuenda mbee can cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ra nyií yuhu cora can nuña ra tyin quɨhvɨ ra jahá cuenda mbee can. Tan mbee can nacotó tɨ naha tɨ ndusu ra. Intuhun intuhun tɨ tan iyó sɨvɨ tɨ jahá ra, caná ra tsi tɨ tan tavá ra tsi tɨ ityi tsata cora. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tsa yaha̱ tava̱ ra tsi tɨ, tan cuahán ra ityi nuu tan nyicún tɨ naha tɨ tsi ra, tyin nacotó tɨ ndusu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Maa tyin tatun nyɨvɨ tsa ña nacotó tɨ ndusu, tsinú tɨ nuu ñi tan ña cuahán tɨ cuanyicún tɨ tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tyehen caha̱n ra Jesús tsihin nyɨvɨ. Maa tyin maa ñi ña cutuñí iñi ñi náa tuhun caahán ra tsa caahán ra tacan. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tacan tan catyí ra Jesús tsihin nyɨvɨ inga tsaha: ―Tsa nditsa catyí yu tsihin ndo, yuhu cuví tumaa iin yuhu cora nu quɨhvɨ́ nyɨvɨ yɨhɨ cuenda yu tan cuví ñi tumaa mbee ticatyi jana yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tandɨhɨ ra tsa quitsi̱ tsa ndi cumañi quitsi yu, ra suhu cuví ra naha. Maa tyin mbee jana yu ña tyaa̱ yahvi tɨ naha tɨ tsa caha̱n ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yuhu cuví yuvehe gloria. Nyɨvɨ tsa cua quɨhvɨ̱ yuvehe can, cua cacu ñi tan ña cua cuhun ca ñi anyaya. Tan cuví ñi tumaa mbee tsa quɨhvɨ́ tan quitá tsitsi cora can. Tan ñihí tɨ cuhu tsatsí tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Iin ra ñasuhu, vatsí ra, vatsí suhu ra, vatsí cahñi ra, vatsí jatɨvɨ ra. Maa tyin yuhu vatsí yu tyin coo vaha ndo ñayɨvɨ nyitó tsa ña cua naa maa. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yuhu cuví ra vaha jahá cuenda mbee. Tyin ra jahá cuenda mbee tsahá ra ñayɨvɨ ra tsa cuenda mbee can. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Maa tyin ra cuví musu, tatun nyehé ra vatsí lobo tsa cuví quɨtɨ xaan, nacoó ra mbee jana tsitoho ra. Tan tsinú ra. Tyin ñavin jana maa ra cuví tsi tɨ naha tɨ. Tacan tan cua tɨɨn quɨtɨ xaan can tsi mbee can. Tan jacunu tɨ tsi mbee can ityi can tan ityi ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Musu can tsinú ra tyin jahá tyiñu ra tsa cuenda xuhun ñi. Tan ña jahá cuenda vaha ra tsi mbee can, tyin ñavin jana ra cuví tsi tɨ naha tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Yuhu cuví ra jahá cuenda vaha mbee jana yu. Tan nacotó yu tsi tɨ naha tɨ. Tan nacotó tucu maa tɨ naha tɨ tsi yu, ");
INSERT INTO mjcNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tumaa tsa nacotó Jutu yu tsi yu, tan yuhu nacotó yu tsi ra. Yuhu tsahá yu ñayɨvɨ yu cuenda mbee jana yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Iyó tucu inga mbee jana yu tsa ña yɨhɨ́ tsitsi cora ihya. Cuñí tsi tsa cuhun yu cunaquihin yu tsi tɨ naha tɨ. Tan cua tyaa yahvi tɨ tsi yu. Tan iin ñi nu cua quɨhɨ tandɨhɨ tɨ. Tan cua coo intuhun ñi ra cua jaha cuenda tsi tɨ naha tɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Jutu yu cuñí ra tsi yu tyin tsahá yu ñayɨvɨ yu tsacatyi nyɨvɨ. Maa tyin yaha can, tan cua nacuhva nyico ra ñayɨvɨ yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yoñi cuvi quihin nyaá ñayɨvɨ yu, tyin tsa iyó iñi maa yu tan tsahá yu can. Iyó ndatu tsi yu tsa cuhva yu ñayɨvɨ yu tan cúu yu, tan iyó tucu ndatu tsi yu tsa naquihin nyico yu can inga tsaha. Yacan cuví tyiñu tsa tyaa̱ Jutu yu tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tsa tsiñi̱ nyico ra tsa cuví ityi nuu tsihin nyɨvɨ Israel naha ra tsa caahán ra Jesús tacan, natahvi̱ sava nyico ra naha inga tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tan cuaha xaan ra naha catyí: ―¿Nacuenda tyaá yahvi ndo tsi ra can? Tan tatyi ña vaha yɨhɨ́ tsi ra, sana jiñi ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tan inga tucu ra naha catyí: ―Yoñi nyɨvɨ yɨhɨ́ tatyi ña vaha tan cuví cahan ñi tacan. ¿A cuví jananyehe tatyi ña vaha can tsi iin ra cuaa? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yoo vitsin cuví tan nyɨvɨ iyó ñuu Jerusalén jacahnú ñi vico tsa cuenda nu natsinú cuiya nu nacuhva̱ cuenda ñi vehe ñuhu cahnu. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tan ra Jesús tsicá nuu ra vehe ñuhu can ityi nu nañi corredor ra Salomón. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tan tsinu nduvi ra cuví ityi nuu tsihin nyɨvɨ Israel naha ra tsi ra Jesús. Tan quitsaha̱ tsicá tuhun ra naha tsi ra: ―¿Ama cua cahan catsi un tsihin ndi tatun juvin un cuví ra Cristo ra tsa jaquitsi̱ Nyoo? Ca̱han catsi tsihin ndi vityin ihya ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tan catyí ra Jesús: ―Tsa yaha̱ caha̱n yu tsihin ndo, tan ña tsinu̱ iñi ndo tsa caha̱n yu. Tyiñu javahá yu nuu Jutu yu yacan cuví tsa ndaa tsa cuenda yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Maa tyin nyooho ña tsinú iñi ndo tsi yu tyin ñavin mbee jana yu cuví tsi ndo. Tumaa cuhva tsa caha̱n jihna yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mbee jana yu nacotó tɨ naha tɨ ndusu yu, tan yuhu nacotó yu tsi tɨ naha tɨ. Tan nyicún tɨ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yuhu tsahá yu ñayɨvɨ nyito tsa ña cua naa maa coo tɨ. Tan ña cua cunaa tɨ. Tan ndi yoñi cuví quihin nyaa tsi tɨ naha tɨ tsitsi ndaha yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Maa Jutu yu tsaha̱ tsi tɨ naha tɨ tsi yu. Tan cahnu ca cuví maa ra tan ñavin ca tandɨhɨ nyɨvɨ. Tan yoñi cuví quihin nyaa tsi tɨ tsitsi ndaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yuhu tan Nyoo Jutu yu, iin ñi cuví ndi ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tacan tan ra cuví ityi nuu tsihin nyɨvɨ Israel can quihi̱n nyico ra naha yuu tyin cañi ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tan catyí ra Jesús tsihin ra naha: ―Cuaha xaan tsa vaha javaha̱ yu nuu ndo tsihin tunyee iñi Jutu yu. ¿Tan ndáa tsa ña taahán iñi ndo tyin cua cañi ndo tsi yu tsihin yuu? ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tan catyí ra cuví ityi nuu tsihin nyɨvɨ Israel can naha ra: ―Ñavin tsa cuenda tsa vaha javaha̱ un cua cañi ndi tsi un tsihin yuu, cua cañi ndi tsi un tsa cuenda tyin tsicoo̱ cuatyi un nuu Nyoo tsihin tsa caahán un. Tyin iin rayɨɨ ñi cuví un, tan jahá un tumaa tsa Nyoo cuví un ―catyí ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tacan tan catyí ra Jesús tsihin ra naha: ―Nu tutu Nyoo nyaá tyin Nyoo catyí ra: “Nyooho nyoo cuví ndo”, catyí Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tsitó yo tyin tsa caahán tuhun Nyoo, ña cua cuvi catyi yo tyin ña nditsa. Tan Nyoo jacunañí ra nyoo tsi nyɨvɨ naquihín tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Tatun maa Nyoo nacatsi̱ tsi yuhu tan jaquitsi̱ ra tsi yu nu ñuhu ñayɨvɨ ihya ¿nácaa tsa catyí nyooho tyin iyó cuatyi yu nuu Nyoo tsa caahán yu tyin Sehe Nyoo cuví tsi yu? ");
INSERT INTO mjcNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tatun ña javahá yu tsa javahá Jutu yu, ña tsi̱nu iñi ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Maa tyin tatun javahá yu, vasu ña cua tsinu iñi ndo tsi yu, maa tyin tsi̱nu iñi ndo tyiñu javahá yu. Tacan tan coto catsi ndo tyin Nyoo Jutu yu iin ñi cuví ra tsihin yu. Tan iin ñi cuví yu tsihin Nyoo Jutu yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Inga nyico tsaha cuñi̱ ra naha tyihi ra naha tsi ra vehe caa, maa tyin ra Jesús cuahán ñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tacan tan cuanuhu̱ ra ityi nu caná ñicanyii inga tsiyo yutya cahnu Jordán nu jacoondutya̱ ra Juan tsa jihna, tan ndoo̱ ra ican. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cuaha nyɨvɨ tsaha̱n tsinyehe̱ tsi ra, tan catyí ñi: ―Nditsa, vasu ndi intuhun tsa iyo ña javaha̱ ra Juan, maa tyin tandɨhɨ tsa caha̱n ra cuenda ra ihya tan nditsa ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tan cuaha xaan nyɨvɨ tsa iyó ityi can tsinu̱ iñi tsa caahán ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ñuu Betania tsicoo̱ iin ra cuuhvi tsa nañí Lázaro. Tan ñuu can iyó ña María tsihin ña Marta tahan ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ña María, cuhva ra Lázaro, juvin ña cuví ñaha tsa tyoso̱ ndutya tami tsaha Jutu Mañi yo, tan jana ityi̱ ña tsaha ra tsihin ixi jiñi ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tacan tan nduvi taahan ñi, ña María tan ña tahan ña, jacoto̱ ñi tsi ra Jesús tan catyí ñi: ―Ra vaha iñi tsi un, cuuhví xaan ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tsa tsiñi̱ ra Jesús yacan tan catyí ra: ―Cuehe can ña cua cahñi can tsi ra. Cuuhví ra tyin quɨvɨ nduvaha ra cua nyehe nyɨvɨ tyin cahnu xaan cuví Nyoo tan tacan tucu Sehe ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Cuñí xaan ra Jesús tsi ña Marta tan ña tahan ña, tan ra Lázaro cuhva ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Maa tyin quɨvɨ tsa tsiñi̱ ra tyin cuuhví ra Lázaro, ndoo̱ ra uvi quɨvɨ ca nu nyií ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tacan tan catyí ra tsihin ra tsicá tsihin ra: ―Cohon nyico ndo inga tsaha nda Judea ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tacan tan ra tsicá tsihin ra catyí ra naha tsihin ra: ―Maestro, ñaha ca ndunaha tsa cuñi̱ ra cuví ityi nuu tsihin nyɨvɨ Israel naha ra cahñi ra naha tsi un tsihin yuu. Tan vityin, cuñí nyico un cuhun un inga tsaha ¿Nacuenda? ");
INSERT INTO mjcNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tan catyí ra Jesús: ―¿A ñavin utsi uvi hora iyó tsa iin quɨvɨ? Tyin tatun tsinu cahñi tsicá nuu iin ra, ña cua nduva ra tyin nditsin nyehé ra ñuhu̱ tsa jandunditsín nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Maa tyin tatun tsacuaa tsicá nuu ra, cuvi nduva ihñi ra tyin nduve ñuhu̱ Nyoo jandunditsín nu cuahan ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tacan tan quitsaha̱ catyí nyico ra Jesús: ―Ra vaha iñi tsi yo, ra Lázaro, quixí ra. Maa tyin cuhun yu jandoto yu tsi ra ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tacan tan catyí nyico ra tsicá tsihin ra: ―Taa, tatun quixí ra, cuñí tsi catyí can tyin cua nduvaha ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Maa tyin ra Jesús cuñí ra catyi ra tyin ra Lázaro tsa tsihi̱ ra. Tan ra tsicá tsihin ra, cuñí maa ra naha tyin nditsa tsa quixí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tacan tan caha̱n catsi ra Jesús tsihin ra naha: ―Ra Lázaro tsa tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tan cusɨɨ́ iñi yu tyin yoñi yu nyií ndacan. Tyin tacan vaha ca tsa cuenda nyooho na tsinu iñi ndo tsa caahán yu. Co̱hon ndo cunyehe yo tsi ra ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tacan tan ra Tomás, tsa jacunañi̱ ra naha “tɨnɨhɨ”, catyí ra tsihin inga ra tsicá tsihin ra Jesús: ―Co̱hon ndɨhɨ yo tyin cúu yo iin caa ñi tsihin ra ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tsa tsaa̱ ra Jesús Betania, ñihi̱ tuhun ra tyin tsa cumi quɨvɨ nyií ra Lázaro tsitsi ñuhú. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ñuu Betania can canyií tsi yatyin ñi nu canyií ñuu Jerusalén, tumaa iin cuhva tsa uvi kilómetro sasava. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tan cuaha ra cuví ityi nuu tsihin nyɨvɨ Israel cuahan cua nyehe nu nyií ña Marta tan ña María cua jatyinyee ra naha tsi ñi tyin tsihi̱ cuhva ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tan ñihi̱ tuhun ña Marta tyin tsa cua tsaa ra Jesús. Tan cuahán ña cua jatahan ña tsi ra. Maa tyin ña María ndoo̱ ña yuvehe. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tan catyí ña Marta tsihin ra Jesús: ―Jutu mañí yu, tun tsatyin ihya nyii̱ maa un, ña cua cúu cuhva yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Maa tyin yuhu tsitó yu tyin Nyoo cua javaha ra tandɨhɨ tsa ndacan un tsi ra ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tan catyí ra Jesús tsihin ña: ―Cuhva un cua nandoto ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tan catyí ña Marta: ―Nditsa, tsitó yu tyin cua nandoto ra quɨvɨ nandoto ndɨyɨ nu cua cundɨhɨ quɨvɨ ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tacan tan catyí ra Jesús tsihin ña: ―Yuhu cuví ra janandotó ndɨyɨ. Tan tsahá yu tsa coo nyitó nyɨvɨ. Nyɨvɨ tsinú iñi tsa caahán yu, vasu tsa tsihi̱ ñi maa tyin coo nyico ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tan tandɨhɨ ñi nyitó tan tsinú iñi ñi tsi yu, ña cua cúu ñi. ¿A tsinú iñi un tsa caahán yu ihya? ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tan catyí ña: ―Tsinú iñi yu, Jutu Mañi yu, tyin yooho cuví ra Cristo Sehe Nyoo, ra tsa nyaá tsa quitsi nu ñuhu ñayɨvɨ ihya ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tsa yaha̱ tsa caha̱n ña Marta tacan, tan tsaha̱n ña tsiquihi̱n ña tsi ña María tahan ña, tan xeehe ñi caha̱n ña tsihin ña: ―Tsa tsaa̱ Ra Maestro ihya. Tan caná ra tsi un ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tsa tsiñi̱ ña María tsa caahán ña, numi xaan ña nduvita̱ ña, tan cuahán ña nu nyií ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tan ñaha ca quɨhvɨ ra Jesús tsitsi ñuu hora can, ndi nyií ra nu nañihi̱ ña Marta tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tan nda yuvehe ña María, yucú ra cuví ityi nuu tsihin nyɨvɨ Israel jatyinyeé ra naha tsi ñi. Tan nyehe̱ ra naha tyin numi quita̱ ña. Tan cuñí maa ra naha tyin cuahán ña nu ñaña cua vacu ña. Tan cuahán ndɨhɨ ra naha tsata ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tan cuhva tsa tsaa̱ ña María nu nyií ra Jesús tsicuɨñɨ̱ tsɨtɨ ña tsaha ra, tan catyí ña: ―Jutu Mañi yu, tun tsatyin nyií un ihya, ña tsihi̱ ra cuhva yu ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tsa nyehe̱ ra Jesús tyin tsacú ña María tan tsacú ra Israel tsa cuahan tsihin ña, nducuiihya xaan cuñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tan tsica̱ tuhun ra tsi ñi: ―¿Nu maa tinyii̱ ndo tsi ra? ―catyí ra. Tan catyí ñi: ―Jutu Mañi yu, co̱hon tan nye̱he un ―catyí ñi tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tan tsacu̱ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tacan tan catyí ra Israel can naha ra: ―Nye̱he ndo tyin yaha̱ xaan cuñi̱ ra tsi ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Maa tyin catyí juhva ra naha: ―Ra ihya jananyehe̱ ra tsi ra cuaa. ¿Nacuvi tyin ña cuví ica ra iin cuhva tan ña cúu ra Lázaro ihya? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nducuiihya xaan cuñí nyico ra Jesús inga tsaha tan natuhva̱ ra nu ñaña can. Tyin tsitsi yavi yuu cuví can. Tan ndasɨ́ iin yuu yuhu can. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tan catyí ra Jesús: ―Ja̱tsiyo ndo yuu can ―catyí ra. Tan ña Marta, cuhva ndɨyɨ can, catyí ña: ―Maa tyin tsa caná xico iñi, Jutu Mañi yu, tyin tsa cumi quɨvɨ tsa nyií ra ican ―catyí ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Maa tyin catyí ra Jesús tsihin ña: ―¿A ña caahán yu tsihin un tyin tatun tsinú iñi un, cua nyehe un tsa cahnu cuví Nyoo? ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tacan tan jatsiyo̱ ra naha yuu can. Tan nanyehe̱ ndaa ra Jesús ityi andɨvɨ, tan catyí ra: ―Tyatya, Jutu Mañi yu, tyahvi nyoo tsi un tyin tsiñi̱ un tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yuhu tsitó yu tyin maa ñi maa tsiñí un tsa caahán yu. Maa tyin tyehen caahán yu tsa cuenda tsa vaha tsi nyɨvɨ nyecú ihya, na tsinu iñi ñi tyin maa un jaquitsi̱ tsi yu ―catyí ra Jesús tsihin Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tsa yaha̱ tsa caha̱n ra tacan, cana̱ tsaa ra, tan catyí ra: ―¡Lázaro, qui̱ta nu nyií un juvin! ");
INSERT INTO mjcNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tan quita̱ ra tsa tsihi̱ can, cavá nuu iin jahma tsi ra, tan nuuhñi ndaha ra tan tsaha ra tsihin jahma. Tan nuuhñí nuu ra tsihin iin jahma tumaa javahá nyɨvɨ Israel tsihin ndɨyɨ. Tan catyí ra Jesús tsihin nyɨvɨ nyecú ican: ―Nda̱tsi ndo tsi ra. Tan ja̱ña ndo tsi ra na cuhun ra ―catyí ra Jesús tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tan cuaha xaan ra cuví ityi nuu tsihin nyɨvɨ Israel tsa tsaha̱n tsihin ña María quitsaha̱ tsinú iñi ra naha tsa nyehe̱ ra naha tsa javaha̱ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Maa tyin juhva ra naha tsaha̱n ra naha tsijacoto̱ ra naha tsi ra fariseo naha ra tsa javaha̱ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tacan tan ra fariseo can naha ra tan ra cuví ityi nuu tsihin ra jutu naha ra jatitaha̱n ra naha tsi ra tuhvá ndu iín naha ra tan catyí ra naha: ―¿Nacaa cua javaha yo? Tyin cuaha xaan tsa iyo javahá ra can. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tatun cuhva yo tsa javaha ca ra tacan, tandɨhɨ nyɨvɨ tan cua tsinu iñi ñi tsi ra. Tan ra cumí tyiñu nda ñuu Roma cua quitsi ra naha tan cua canɨ ra naha vehe ñuhu yo tan ñuu yo ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Maa tyin ra Caifás ra tsahnu tsa cuví ityi nuu tsihin ra jutu naha ra cuiya can, caha̱n ra tan catyí ra tsihin ra naha: ―Nyooho nduve maa náa tsitó ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ndi ña cutuñí iñi ndo tyin vaha ca tsa cúu intuhun ñi rayɨɨ tsa cuenda tandɨhɨ nyɨvɨ ñuu, tan ñavin ca tsa cúu tandɨhɨ yo ―catyí ra Caifás. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ra Caifás can ñavin tsa cuñí maa ra tan caahán ra, tyin ra cuví ityi nuu tsihin tandɨhɨ jutu cuví ra cuiya can, yacan cuenda maa Nyoo jacaha̱n tsi ra nu catyi̱ ra tyin ra Jesús cua cúu ra tsa cuenda tandɨhɨ nyɨvɨ ñuu Israel. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tan ñavin tsa cuenda maa ñi maa nyɨvɨ can, maa tyin cua jandu iin ra tsi tandɨhɨ nyɨvɨ cuví sehe Nyoo tsa iyó tandɨhɨ ca ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tacan tan nda quɨvɨ can tan ra cuví ityi nuu tsihin nyɨvɨ Israel can naha ra, nducú ra naha cuhva cahñi ra naha tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yacan cuenda ña tsicá nuu nditsin ca ra Jesús nu iyó nyɨvɨ Israel. Quee̱ ra Judea can. Tan cuahán ra iin ñuu tsa nañí Efraín tsa canyií yatyin ñi nu tsɨquɨ, nu cuví ñuhu ityi. Tan ndoó ra ican tsihin ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ña cuaha ca quɨvɨ tan tahan tsi vico cuenda nyɨvɨ Israel, vico tsa nañí pascua. Tan cuaha xaan nyɨvɨ quee̱ ñi ñuu ñi tan cuahán ñi nda ñuu Jerusalén cua javaha ñi tsa tuhvá maa ñi javahá tsa janduvahá ñi tsi ñi nuu Nyoo tsa ndi cumañi ca tahan tsi quɨvɨ vico can. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nanducú ñi tsi ra Jesús. Tan cuhva tsa nyecú ñi tsitsi vehe ñuhu cahnu can tan tsicá tuhun tahan ñi, tan catyí ñi: ―¿Nacaa cuñí nyooho? ¿A cua quitsi ra can vico ihya, o ña cua quitsi ra? ―catyí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tan ra cuví fariseo tan ra cuví ityi nuu tsihin jutu, catyí ra naha tyin tatun ndáa nyɨvɨ tsitó nu nyií ra Jesús, na ca̱tyi tuhun ñi. Tyin cuquihin ra naha tsi ra tyin cunyii ra vehe caa. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cumañi iñu quɨvɨ ca tsa tahan tsi vico pascua, tan tsaa̱ ra Jesús ñuu Betania nu iyó ra Lázaro, ra tsa janandoto̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ican javaha̱ ñi tsa cuxiñi̱ ra Jesús. Ña Marta tyihi̱ ña coho nu mesa. Tan tsinyaa̱ ra Jesús nu mesa. Tan nyaá ndɨhɨ tucu ra Lázaro tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tacan tan quihi̱n ña María tumaa sava litru ndutya tami tsa tsinu̱ tsihin maa ñi maa yucu tsa nañí nardo, iin tsa yahvi xaan nyaá. Tan tyiso̱ ña ndutya tami can tsaha ra Jesús. Yaha̱ can tan jana ityi ña tsaha ra tsihin ixi jiñi ña. Nanɨɨ cahnu maa tsitsi vehe can tsitu̱ xico ndutya tami can. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tan ican nyií tucu ra Judas Iscariote, sehe ra Simón. Cuví ra iin ra tsicá tsihin ra Jesús. Tan juvin ñi maa ra cuví ra tsa cua xico tsi ra Jesús tsi nu xaan iñi tsi ra nahnu. Tan quitsaha̱ catyí ra Judas can tsihin ñi can: ");
INSERT INTO mjcNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Nacuenda ña xico̱ ndo ndutya tami ihya tsi nyɨvɨ, tan cuhva ñi cuenda mil tsi ndo tsa cuenda can, (uñi cientu denario) tan jatyinyee ndo tsi nyɨvɨ ndaahvi? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Caahán ra Judas yacan tyin ra ñasuhu cuví ra, ñavin tsa cundaahví iñi ra nyehé ra tsi nyɨvɨ ndaahvi. Tyin maa ra yɨhɨ́ ndaha yɨtɨn nu yɨhɨ́ xuhun ra naha, tan tuhvá ra suhu tsa tyihí ra naha tsitsi yɨtɨn can. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tacan tan catyí ra Jesús tsihin ra: ―Ja̱ña tsi ña, tyin ñaha ihya javaha̱ ña tyehen tsa cuenda tsa cua quɨhvɨ cuñu ñuhu yu tsitsi ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nyɨvɨ ndaahvi tacan ñi nyecú maa ñi tsihin ndo, maa tyin yuhu ña cua cunyaa ca yu tsihin ndo tacan ―catyí ra Jesús tsihin ra Judas. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Cuaha xaan nyɨvɨ Israel ñihi̱ tuhun ñi tyin ra Jesús nyií ra Betania, tan tsaha̱n ñi ican. Ñavin intuhun ñi ra Jesús cuñí ñi nyehe ñi tyin cuñí ndɨhɨ tucu ñi nyehe ñi tsi ra Lázaro, ra tsa janandoto̱ ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tacan tan ra cuví ityi nuu tsihin jutu natuhu̱n tahan ra naha tyin cua cahñi ndɨhɨ ra naha tsi ra Lázaro. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tyin tsa cuenda ra tan cuaha xaan nyɨvɨ Israel quitá tsiyo ñi tan quitsaha̱ tsinú iñi ñi tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Cuaha xaan nyɨvɨ tsaa̱ ñi ñuu Jerusalén tsa cuví vico pascua. Tan tsa inga quɨvɨ tsito̱ ñi tyin ra Jesús cua tsaa ra ñuu can. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tacan tan tsahnya̱ ñi ndaha ndicaha tan cuahán ñi cua jatahan ñi tsi ra Jesús. Tan caná tsaa ñi, tan catyí ñi: ―¡Cahnu xaan cuví Nyoo! ¡Nasoco xaan Nyoo tsi ra vatsí ihya tsihin tunyee iñi Nyoo! ¡Nasoco xaan Nyoo tsi Rey cuenda yo nyɨvɨ Israel! ―catyí ñi, caná tsaa ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tan ñihi̱ ra Jesús iin burru tan tsicoso̱ ra tsi tɨ tumaa catyí maa nu tutu Nyoo tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ña na̱yuhvi ndo nyɨvɨ ñuu Sión Nye̱he ndo, vatsí Rey ndo. Yosó ra iin burru ―catyí tsi nu tutu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Quɨvɨ can ra tsicá tsihin ra Jesús, ña cutuñí iñi ra naha tsa nyaá nu tutu Nyoo. Maa tyin tsa yaha̱ cuanuhu ra Jesús nda gloria, nducuhu̱n iñi ra naha tyin tandɨhɨ yacan nyaá can nu tutu Nyoo tyin tacan cua tahan ra. Tan tacan tsa cuii taha̱n ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nyɨvɨ tsa nyehe̱ quɨvɨ tsa cana̱ ra Jesús tsi ra Lázaro tsitsi ñaña, quɨvɨ janandoto̱ ra tsi ra, nacatyí tuhun ñi tsa nyehe̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yacan cuenda cuaha xaan nyɨvɨ tsijataha̱n tsi ra Jesús, tyin tsito̱ ñi tsa iyo tsa javaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tacan tan ra cuví fariseo catyí ra naha natuhun tahan ra naha: ―Tsa nyehé maa ndo tyin nduve maa náa cuví javahá yo, tyin tandɨhɨ nyɨvɨ tan cuahán ñi cuanyicún ñi tsi ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yucú tucu juhva ra Grecia mahñu nyɨvɨ tsa tsaha̱n tsijacahnu̱ vico ñuu Jerusalén. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tacan tan natuhva̱ ra Grecia can naha ra nu nyaá ra Felipe, ra quee̱ ñuu Betsaida tsa canyií Galilea, tan caha̱n ndaahvi ra naha tsihin ra tan catyí ra naha: ―Taa, cuñí ndi cahan ndi tsihin ra Jesús ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tan tsaha̱n ra Felipe tsicaha̱n ra tsihin ra Andrés. Tan tsaha̱n nduvi ra naha tsicatyi̱ tuhun ra naha tsihin ra Jesús tyin ra Grecia can cuñí ra naha cahan ra naha tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tan nacaha̱n ra Jesús, tan catyí ra: ―Vityin tsa tsaa̱ hora tsa cunuhu nyico yu nda nu quee̱ yu, tan cua jacahnu jutu yu tsi yu, tsa cuví yu Rayɨɨ tsa quee̱ nda gloria. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tsa nditsa catyí yu tsihin ndo tyin tatun iin tsɨtɨ tan ña cua quɨhvɨ tsi ñuhu̱ tan ña tyahyu tsi, intuhun ñi tsɨtɨ cua cuvi tsi. Maa tyin tatun tyahyu tsi, ndutsaa tsi inga tsaha tan cua coo cuaha ca tsɨtɨ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nyɨvɨ tsa cuñí xaan ñayɨvɨ iyó ñi, cua cunaa ñi. Maa tyin nyɨvɨ ña cuñí ñayɨvɨ iyó ñi nu ñuhu ñayɨvɨ ihya, cua ñihi ñi ñayɨvɨ nyitó tsa ña cua naa maa coo ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ndáa nyooho nyɨvɨ cuñí javaha tyiñu nuu yu, naha ndo qu̱itsi nyicun ndo tsi yu. Tan nu cunyaa yu, cunyaa ndɨhɨ nyooho tsa jahá tyiñu tyiñu yu. Tyin nyɨvɨ jahá tyiñu tyiñu yu, cua jacahnu jutu yu tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Vityin tsicá xaan iñi yu. Tan ¿náa cua cahan yu? ¿A catyí yu tsihin Jutu yu na jatsiyo ra tundoho tsa nyaá cua nyehe yu? Ña cua cahan yu tacan tyin tsa cuenda yacan vatsí yu nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Vaha ca cahan yu tsihin Jutu yu tan catyi yu: “Jutu Mañi yu, ja̱cahnu sɨvɨ un” ―catyí ra Jesús. Tacan tan caha̱n iin ndusu ityi andɨvɨ tan catyí tsi tyehen: ―Tsa yaha̱ jacahnu̱ yu sɨvɨ yu, tan cua jacahnu nyico yu inga tsaha ―catyí ndusu can. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tan nyɨvɨ nyecú ican, tsiñi̱ ñi ndusu can, tan catyí ñi tyin savi caha̱n. Tan inga ñi catyí tyin iin ángel caha̱n tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tacan tan catyí ra Jesús tsihin ñi: ―Ñavin tsa cuenda tsa vaha tsi yuhu caha̱n ndusu can, tyin tsa cuenda tsa vaha tsi maa ndo cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vityin cuví cuhva tsa cua tatsi tuñi Nyoo tsi nyɨvɨ iyó nu ñuhu ñayɨvɨ. Tan vityin cuví cuhva cua tava cuii Nyoo tsi nu ndacá ñaha nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tan cuhva tsa cua ticaa nyɨvɨ tsi yu nu cruu, yacan cuví cuhva cua ixta yu tandɨhɨ nyɨvɨ cuhun ñi tsihin yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Caahán ra tacan tsa cuenda tsa cuñí ra cutuñi iñi ñi tyin tacan cua cúu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tan nacaha̱n nyɨvɨ tan catyí ñi tsihin ra: ―Tuhvá ndi tsiñí cahví ra naha nu libru ley yo tyin ra cuví Cristo cua coo nyitó ra tan ña cua cúu maa ra. ¿Nacaa tsa catyí yooho tyin cua ticaa nyɨvɨ tsi Rayɨɨ quee̱ nda gloria nu cruu? Tan ¿yóo ra cuví Rayɨɨ tsa quee̱ nda gloria tsa caahán un tuhun? ―catyí ñi, tsicá tuhun ñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tacan tan catyí ra Jesús tsihin ñi: ―Ñuhu̱ tsa jandunditsín nu nyecú ndo, juhva ña quɨvɨ iyó tsi. Ca̱ca ndo ityi nu nditsin tsitsi tsa ndi iyó tsa nditsin. Coto sana iñi ndo tan ndunaa. Tyin nyɨvɨ tsicá nu naa ña tsitó ñi nu maa cuahán ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tsi̱nu iñi ndo tsi yuhu ra cuví ñuhu̱ nditsin, tsitsi tsa ndi nyií yu tsihin ndo. Tacan tan cuví ndo nyɨvɨ iyó nu nditsin. Tsa yaha̱ caha̱n ra Jesús tacan tan jatsiyo̱ ñi ra tsi ra nuu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Vasu ndi maa cuaha xaan tsa iyo javahá ra Jesús nuu nyɨvɨ maa tyin ña tsinú maa iñi ñi tsa caahán ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tyin taahán tsi tsa cuvi tumaa tsa caha̱n ra Isaías ra cuvi̱ ndusu yuhu Nyoo, nu caha̱n ra tyehen: Jutu Mañi yu, yoñi cuñí tsinu iñi tsa caahán ndi. Yoñi cutuñí iñi tunyee iñi tsa iyó tsi un, Jutu Mañi yu, catyi̱ ra Isaías taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tsa cuenda tsa nyaá nu tutu, yacan cuenda ña cuví tsinu iñi ñi tyin juvin ñi tyaa̱ nyico tucu ra Isaías tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nyoo jacuaa̱ ra tsi ñi. Tan jandundava̱ ra añima ñi, tan ña cua nyehe ñi tsihin tinuu ñi, tan ña cua cutuñi iñi ñi tsihin añima ñi, tan ndi ña cua nacuhva cuenda ñi tsi ñi tsi ra tan janduvaha ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ra Isaías caha̱n ra tyehen tyin nyehe̱ ra tsa cahnu cuví Jutu Mañi yo Jesús, tan caha̱n ra tuhun ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Cuaha xaan nyɨvɨ Israel tsinú iñi tsi ra Jesús. Tan nda cuanda juhva ra cuví ityi nuu naha ra. Maa tyin ña jandunditsi̱n ra naha tsi ra naha nuu nyɨvɨ tyin yuuhví ra naha tsi ra cuví fariseo naha ra. Coto tava cuii ra can naha ra tsi ra naha vehe ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tyin cuñí ra naha nduvaha ra naha nuu nyɨvɨ tan ñavin nuu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ñihi caahán ra Jesús, tan catyí ra: ―Nyɨvɨ tsa tsinú iñi tsi yu, ñavin tsi maa ñi maa yu tsinú iñi ñi, tyin tsinú ndɨhɨ iñi ñi tsi ra tsa jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tan nyɨvɨ tsa nyehé tsi yu, nyehé ndɨhɨ ñi tsi ra tsa jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yuhu cuví tumaa ñuhu̱ nditsin tan vatsí yu jandunditsín yu nu ñuhu ñayɨvɨ ihya, tyin nyɨvɨ tsinú iñi tsi yu ña cua ndoo ñi nu naa. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Maa tyin tatun yɨhɨ́ ndo tsiñí ndo tsa caahán yu, tan ña javahá ndo tsa caahán yu, ñavin yuhu tatsi tuñi tsi ndo. Tyin ña vatsí yu nu ñuhu ñayɨvɨ ihya tyin tatsi tuñi yu tsi nyɨvɨ. Vatsí yu tyin vatsí jacacú yu tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nyɨvɨ tsa ña cuñí naquihin vaha tsa caahán yu tan ña cuñí ñi javaha ñi tumaa cuhva cuñí yu, iyó tsa cua tatsi tuñi tsi ñi. Tuhun tsa caahán yu, yacan cua tatsi tuñi tsi ñi nu cua cundɨhɨ quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tyin ñavin cuenda maa yu caahán yu. Jutu yu, ra tsa jaquitsi̱ tsi yu, tsaha̱ ra tyiñu tsi yu caahán ra náa cua cahan yu tan náa cua jacuaha yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tan tsitó yu tyin tyiñu tsa tsaha̱ ra, tsahá tsi ñayɨvɨ nyitó tsa ña cua naa maa coo nyɨvɨ. Yacan cuenda, tandɨhɨ tsa caahán yu, caahán yu cuhva catyí maa Jutu yu tsa cahan yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tsa ndi cumañi ca iin quɨvɨ tan tahan tsi vico pascua, tsa tsitó maa ra Jesús tyin tsa cua tsaa hora tsa cua quita ra nu ñuhu ñayɨvɨ ihya tan cunuhu ra nu nyaá Jutu ra. Tacan ñi maa cuñí xaan ra tsi nyɨvɨ cuenda ra tsa iyó nu ñuhu ñayɨvɨ ihya. Tan vityin cua janaha ra tsi ñi tyin cuñí xaan ra tsi ñi tyin cua cúu ra tsa cuenda ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tan cuxiñi̱ ra Jesús tsihin ra tsicá tsihin ra. Tan quɨhvɨ̱ nu ña vaha añima ra Judas Iscariote sehe ra Simón tan natyuhu̱ nu tsi ra na xico ra tsi ra Jesús tan cuhva cuenda ra tsi ra Jesús tsi nu xaan iñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Maa tyin ra Jesús tsitó ra tyin tsaha̱ Jutu ra tandɨhɨ tyiñu tsi ra tyin quɨhɨ ndaha ra. Tan tsitó ra tyin nu nyaá Nyoo quee̱ ra tan juvin ñi ndacan cua cunuhu nyico ra. Tan nyaá ra Jesús cuxiñí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tacan tan nduvita̱ ra tan tava̱ ra jahma tsa nditsí ra ityi tsata, tan tsahñi̱ ra iin toalla tsitsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tacan tan tyihi̱ ra ndutya tsitsi iin tsicoho tan quitsaha̱ nacatyá ra tsaha ra tsicá tsihin ra. Tan jana ityi̱ ra tsaha ra naha tsihin toalla can. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tan tsa cua nacatya ra tsaha ra Simón Pedro tan catyí ra Simón tsihin ra: ―Jutu Mañi yu, ¿a yooho cua nacatya tsaha yu? ");
INSERT INTO mjcNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tacan tan catyí ra Jesús: ―Vityin ña cutuñí iñi un tsa javahá yu, maa tyin cutuñi iñi maa un nu cuahán ca tsi quɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Maa tyin ra Pedro catyí ra tsihin ra: ―Ndi iin tsaha tan ña cua cuhva yu nacatya un tsaha yu. Tan catyí ra Jesús tsihin ra: ―Tatun ña cua nacatya yu tsaha un, ñavin ca cuenda yu cua cuvi un. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tacan tan catyí ra Pedro tsihin ra Jesús: ―Tun tacan, Jutu Mañi yu, ñavin tsaha ñi yu nacatya un. Na̱catya nda cuanda ndaha yu tan jiñi yu ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Maa tyin catyí ra Jesús tsihin ra: ―Nyɨvɨ tsa ndi tsityi̱, ña cuñí tsi tsa ndoo nanɨɨ cahnu cuñu ñuhu ñi. Tsaha ña ñi cuñí tsi ndoo, tyin tsa ndoo maa nanɨɨ ñi. Nyooho tsa ndoo̱ maa ndo, vasu ña tandɨhɨ ndo ndoo̱ ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Caha̱n ra tsa ña tandɨhɨ ra naha ndoo tyin tsitó ra yóo cua xico tsi ra tsi nu xaan iñi tsi ra nahnu. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tsa yaha̱ nacatya̱ ra Jesús tsaha ra tsicá tsihin ra, tan tsinditsi̱ nyico ra jahma ra, tan tsinyaa̱ nyico ra inga tsaha nu mesa tan catyí ra tsihin ra naha: ―¿A cutuñí iñi nyooho tsa javaha̱ yu tsihin ndo? ");
INSERT INTO mjcNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nyooho caahán ndo tsihin yu, “Maestro tan Jutu Mañí yu”, tan nditsa tyin yacan cuví yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yuhu tsa cuví yu Ra Jacuahá tan Jutu Mañi ndo, nacatya̱ yu tsaha ndo, tan tacan cuñí tsi tsa nacatya tahan maa ndo tsaha ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yuhu tsaha̱ yu iin cuhva tsi ndo tyin ja̱vaha ndo tumaa cuhva javaha̱ maa yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tsa nditsa catyí yu tsihin ndo tyin ndi iin musu tan ña cahnu ca cuví ra tan ñavin ca tsitoho ra. Tan ndi iin ra tsa cuahán tyiñu, tan ña cahnu ca cuví ra tan ñavin ca ra tsa tava̱ tyiñu tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tatun cutuñí iñi ndo yacan, tan javahá ndo can, sɨɨ xaan cua coo ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ñavin tsa cuenda tandɨhɨ ndo caahán yu. Yuhu tsitó maa yu yóo nacatsi̱ yu. Maa tyin cuñí tsi tsa cuvi tumaa caahán tuhun Nyoo tyehen: “Ra tsa tsatsi̱ paan tsihin yu, juvin ra cua xico ñaha tsi yu tsi nu xaan iñi tsi yu”, catyí tsi nu tutu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Caahán yu tyehen tsihin ndo tsa ndi cumañi ca cuvi can tyin quɨvɨ cua cuvi yacan, cua tsinu iñi ndo tyin yuhu cuví ra tsa iyó nda ndi cumañi ca coo tandɨhɨ tsa iyó. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tsa nditsa catyí yu tsihin ndo tyin nyɨvɨ naquihin vaha tsi nyɨvɨ tsa jacuhún yu tsi ñi, maa yu naquihin vaha ñi cuví can. Tan nyɨvɨ tsa naquihín vaha tsi yuhu, naquihín vaha ndɨhɨ ñi tsi ra tsa jaquitsi̱ tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tsa yaha̱ tsa caha̱n ra Jesús yacan, tan quitsaha̱ nducuiihyá xaan cuñi añima ra, tan catyí catsi ra: ―Tsa nditsa catyí yu tsihin ndo, tyin iin nyooho cua xico ndo tsi yu tsi nu xaan iñi tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tacan tan ra tsicá tsihin ra, quitsaha̱ nyehé nuu tahan ra naha, tan ña tsitó ra naha yóo tuhun caahán ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iin ra tsicá tsihin ra Jesús nyanaá ra tsi ra nu nyaá ra cuxiñí ra. Tan ra ican cuví ra tsa cuñí xaan ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tan ra Simón Pedro javaha̱ ra seña tsi ra can, na ndaca tuhun ra yoó tuhun caahán ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tacan tan ra ican tsinyaá naa ca ra tsi ra Jesús, tan tsica̱ tuhun ra tsi ra: ―Jutu Mañi yu, ¿yoó ra cuví ra tsa caahán un tuhun? ");
INSERT INTO mjcNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tan nacaha̱n ra Jesús tan catyí ra: ―Cua jatyii yu luxu paan, tan ra tsa cua cuhva yu itsi, ra ican cuví ra ―catyí ra. Tacan tan quihi̱n ra luxu paan tan jatyii̱ ra, tan tsaha̱ ra tsi ra Judas Iscariote, sehe ra Simón. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tsa quihi̱n ra Judas paan can tan quɨhvɨ̱ nu ña vaha añima ra. Tacan tan ra Jesús catyí ra tsihin ra: ―Tsa tsicá iñi un javaha un, ja̱numi ja̱vaha can ―catyí ra Jesús tsihin ra Judas. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Maa tyin ndi intuhun ra tsa nyecú nu mesa can, ña cutuñí iñi ra naha nacuenda caha̱n ra tacan tsihin ra can. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ra Judas cuví ra yɨhɨ́ ndaha yɨtɨn nu yɨhɨ́ xuhun, yacan cuenda yɨhɨ́ ra naha cuñi̱ maa ra naha tyin cuñí ra Jesús tsa cujata ra tsa tsiñí ñuhu tsi ra naha tsa cuenda vico can, a cuhva ra juhva xuhun can tsi nyɨvɨ ndaahvi, cuñi̱ maa ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tsa yaha̱ quihi̱n ra Judas paan can, tacan tan quita̱ ra. Tan tsacuaa cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tsa yaha̱ tsa cuahán ra Judas, tan catyí ra Jesús: ―Vityin cua nyehe nyɨvɨ tsa cahnu cuví yuhu Rayɨɨ tsa quee̱ nda gloria. Tan cua nyehe ñi tsa cahnu cuví Nyoo tsa cuenda yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tatun Rayɨɨ tsa quee̱ nda gloria jacahnú ra tsi Nyoo, tacan tucu Nyoo cua jacahnu ra tsi ra. Tsa tsaa̱ quɨvɨ cua jacahnu ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sehe yu, ña naha ca cua cunyii yu tsihin ndo. Nyooho cua nanducu ndo tsi yu, maa tyin tumaa tsa caha̱n yu tsihin ra cuví ityi nuu tsihin yo nyɨvɨ Israel can naha ra, caahán yu tsihin ndo vityin, tyin ña cua cuvi cuhun ndo nu cua cuhun yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tsahá yu iin tyiñu tsaa tsi ndo: Cu̱ñi tahan ndo tsi ndo. Tumaa tsa cuñí maa yu tsi ndo, tacan cuñí tsi tsa cuñí tahan ndo tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tatun cuñí tahan ndo tsi ndo, tandɨhɨ nyɨvɨ tan cua coto ñi tyin nyɨvɨ nyicún tsi yu cuví ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ra Simón Pedro tsica̱ tuhun ra tsi ra Jesús tan catyí ra: ―Jutu Mañi yu, ¿nu maa cua cuhun un? ―catyí ra. Tan nacaha̱n ra Jesús tan catyí ra: ―Nu cuhun yuhu, ña cua cuvi cunyicún un tsi yu vityin. Maa tyin nu cuahán ca tsi quɨvɨ, tan cunyicun un tsi yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tacan tan catyí ra Pedro tsihin ra: ―Jutu Mañi yu, ¿nácaa tsa ña cua cuvi cunyicun yu tsi un vityin? Tan tsa iyó vaha iñi yu tsa cuhva yu ñayɨvɨ yu tsa cuenda un ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tan nacaha̱n ra Jesús tan catyí ra: ―¿A nditsa tsa cuhva un ñayɨvɨ un tsa cuenda yu? Tsa nditsa catyí yu tsihin un, tyin tsa ndi cumañi ca vacu tsaa tsitooho, yooho cua cahan un uñi tsaha tyin ña nacotó un tsi yu ―catyí ra Jesús tsihin ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tan catyí ra Jesús: ―Ña caca xaan iñi ndo. Tsi̱nu iñi ndo tsi Nyoo, tan tsi̱nu ndɨhɨ iñi ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Vehe Jutu yu cuaha xaan nu coo ndo iyó. Tun tsatyin ñavin tacan, tsa naha catyi̱ tuhun yu tsihin ndo. Tan cua cuhun yu cua janduvaha yu iin nu coo ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tsa yaha̱ tsa cuhun yu janduvaha yu nu coo ndo, tan cua quitsi nyico yu inga tsaha, quitsi naquihin yu tsi ndo tyin cuyucu ndo nu cua cunyaa yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nyooho tsa tsitó maa ndo nu maa cuhun yu, tan tsa tsitó ndo ityi. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tan catyí ra Tomás tsihin ra: ―Jutu Mañi yu, ña tsitó ndi nu maa cua cuhun un. Tan ¿nácaa coto ndi ityi? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tan catyí ra Jesús: ―Yuhu cuví ityi tsa cuahán gloria. Tan yuhu cuví tsa nditsa. Tan juvin ñi yuhu cuví ra tsahá ñayɨvɨ coo ndo. Tan tsa cuenda yuhu ñi, tan cuvi tsaa ndo nu nyaá Jutu yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tan tsa nacotó ndo tsi yu, tan tsa cuenda yacan nacotó ndɨhɨ ndo tsi Jutu yu. Nda vityin tan nu cuahán ca tsi ityi nuu, cua nacoto ndɨhɨ ndo tsi ra, tyin tsa nyehé ndo tsi ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tacan tan catyí ra Felipe tsihin ra: ―Jutu Mañi yu, cu̱hva jihna nyehe ndi tsi Nyoo Jutu yo, tan tsihin yacan ñi tan ndoo ndi vaha. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tan nacaha̱n ra Jesús, tan catyí ra: ―Yooho Felipe, tsa naha xaan nyií yu tsihin ndo, tan ¿nácaa tsa caahán un tsa ña nacotó un tsi yu? Nyɨvɨ tsa nyehé tsi yu, nyehé ndɨhɨ ñi tsi Nyoo Jutu yu. Tan ¿nácaa tsa caahán un tsihin yu: “Cu̱hva jihna nyehe ndi tsi Nyoo Jutu yo”? ");
INSERT INTO mjcNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A ña tsinú iñi un tyin iin ñi cuví yu tsihin Nyoo Jutu yu? Tan maa ra iin ñi cuví ra tsihin yu. Tsa caahán yu tsihin ndo, ñavin yuhu caahán yacan. Jutu yu tsa iyó tsihin yu, maa ra javahá tyiñu ra tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tsi̱nu iñi ndo tsi yu tyin iin ñi ra cuví yu tsihin Nyoo Jutu yu. Tan Nyoo Jutu yu iin ñi cuví ra tsihin yu. Tatun ña tsinú iñi ndo yacan, cuví tsinu iñi ndo tsi yu tsa cuenda tyiñu Nyoo Jutu yu tsa javahá yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tsa nditsa caahán yu tsihin ndo tyin nyɨvɨ tsinú iñi tsi yu, cua javaha ndɨhɨ ñi tsa javahá yu. Tan cahnu ca tsa cua javaha ñi, tyin yuhu cuhun yu nu nyaá Nyoo Jutu yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tan tandɨhɨ tsa cua ndacan ndo tsi jutu yu tsihin sɨvɨ yu, cua ñihi ndo can tyin tacan tan jacahnu cuaha ca nyɨvɨ tsi Nyoo Jutu yu tsa cuenda yuhu tsa cuví yu Sehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yuhu cua javaha yu náa ndɨhɨ tsa ndacan ndo tsa cuenda yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tatun cuñí ndo tsi yu, tya̱a yahvi ndo tsa caahán yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Tan ndacan tahvi maa yu tsi Nyoo Jutu yu na jaquitsi ra iin ra cua cuhva tunyee iñi tsi ndo. Tan ra ican cuví Tatyi Ii Nyoo, ra tsa caahán tsa nditsa. Tan iin nyita ñi maa cua cunyaa ra tsihin ndo. Maa tyin nyɨvɨ tsa taahán ca iñi tsa iyó nu ñuhu ñayɨvɨ ihya, ña cua cuvi naquihin ñi Tatyi Ii Nyoo tyin ña nyehe ñi tsi ra. Tan ndi ña tsitó ñi tsi ra. Maa tyin nyooho tsitó ndo tsi ra tyin nyaá ra tsihin ndo tan tacan ñi cua ndoo ra tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ña cua nacoo cuii yu tsi ndo. Cua quitsi nyico yu nu yucú ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Juhva cuii ña quɨvɨ, tan nyɨvɨ cuenda nu ñuhu ñayɨvɨ ña cua nyehe ca ñi tsi yu. Maa tyin nyooho cua nyehe ndo tsi yu. Tyin yuhu nyito yu, yacan cuenda nyooho cua coo ndɨhɨ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Quɨvɨ can cua coto ndo tyin yuhu iin ñi cuví yu tsihin Jutu yu. Tan nyooho iin ñi cuví ndo tsihin yu. Tan yuhu iin ñi cuví yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nyɨvɨ tsa tyaá yahvi tsa caahán yu, tan javahá ñi cuhva caahán yu, ñi ican cuví ñi tsa cuñí tsi yu. Tan ñi tsa cuñí tsi yu, Jutu yu cua cuñi ra tsi ñi. Tan cuñí ndɨhɨ tucu maa yu tsi ñi tan cua janaha yu tsi ñi yóo ra cuví yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tan catyí ra Judas, ñavin ra Judas Iscariote, inga ra. ―Jutu Mañi yu, ¿nácaa tsa nyuhu ñi cua janaha un tsi un, tan ñavin tsi tandɨhɨ nyɨvɨ iyó nu ñuhu ñayɨvɨ? ");
INSERT INTO mjcNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nacaha̱n ra Jesús tan catyí ra: ―Nyɨvɨ cuñí tsi yu, javahá ñi tsa caahán yu. Tan Jutu yu cuñi ra tsi ñi. Tan quitsi ndi nu yucú ñi tan coo ndi tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nyɨvɨ ña cuñí tsi yu, ña javahá ñi tsa caahán yu. Tan tuhun tsa caahán yu tsa tyaá soho ndo, ñavin tuhun maa yu cuví tsi, tyin tuhun caahán Jutu yu, ra tsa jaquitsi̱ tsi yu, cuví tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Caahán yu tandɨhɨ tuhun ihya tsihin ndo tsitsi tsa ndi nyií yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Maa tyin nu cuahán ca tsi ityi nuu cua jaquitsi Jutu yu Tatyi Ii ra tsihin sɨvɨ yu. Tan cua jatyinyee ra ican tsi ndo, tan cua cuhva ra tunyee iñi tsi ndo, tan cua janaha ra tandɨhɨ tsi ndo. Tan cua janducuhun iñi ra tsi ndo tsa tsa yaha̱ caha̱n yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Jandoó yu iin tsa taxin coo añima ndo, tumaa tsa taxin cuñí añima maa yu. Yacan tsahá yu tsi ndo. Ñavin tumaa tsa taxin tsa ñihí ndo nu ñuhu ñayɨvɨ ihya. Ña ca̱ca xaan iñi ndo tan ña na̱yuhvi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tsiñi̱ ndo tsa caha̱n yu nu catyi̱ yu tyin cua cuhun yu tan cua quitsi nyico yu nu yucú ndo. Tatun cuñí ndo tsi yu, cua cusɨɨ iñi ndo tyin catyí yu tyin cuahan yu nu nyaá Jutu yu. Tyin cahnu ca cuví Jutu yu tan ñavin ca maa yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Caahán yu tyehen tsihin ndo tsa ndi cumañi ca cuhun yu, tyin quɨvɨ cuhun yu, cua tsinu iñi ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ña cuaha ca cua cahan yu tsihin ndo. Tyin vatsí nu ndacá ñaha nu ñuhu ñayɨvɨ ihya. Maa tyin ña ndacá ñaha nu tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tyin tacan tan coto nyɨvɨ iyó nu ñuhu ñayɨvɨ, tyin yuhu cuñí yu tsi Nyoo Jutu yu, tan javahá yu tyiñu tava̱ ra tsi yu. ’Ndu̱vita ndo, tan co̱hon ndo, na cua tsiyo yo ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Yuhu cuví yoho tsa cuví uvas tsa nditsa. Tsa cuví uvas cuví tsi tumaa yoho nditsaahan ndɨvɨ maa tyin yucu vixi cuví tsi. Tan Jutu yu cuví ra jahá cuenda yoho can. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tsaahnyá ra soco tsa ña tsahá tsɨtɨ. Tan nacahnya ra nuu yoho yucu tsa tsahá tsɨtɨ, tan janduvahá ra can, tyin tacan tan cuhva cuaha ca tsi tsɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tsa yaha̱ janduvaha̱ Jutu yu tsi nyooho tsihin tsa jacuahá yu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ja̱ñihi ca ndo ndu iin ndo tsihin yu, tumaa tsa iin ñi cuví yu tsihin ndo. Tumaa iin soco yoho can ña cuvi cuhva tsi tsɨtɨ tsa maa ñi maa tsi, tun ña nyanaá tsi tsata yoho cahnu can, tacan nyooho, ña cua cuvi javaha ndo tsa vaha tatun ña iin ñi cuvi ndo tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yuhu cuví yoho cahnu. Tan nyooho cuví soco yoho can. Nyɨvɨ tsa nyanaá tsi yu, tan nyanaá yu tsi ñi, cuaha tsa vaha javahá ñi. Tyin nduve náa cuví javaha ñi tatun ña nyanaá ñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nyɨvɨ tsa ña nyanaá tsi yu, cua javita Jutu yu tsi ñi, tumaa javitá yo soco yutun tsa ña tsahá tsɨtɨ. Na ityi can tan jatacá yo can, tsahan tsahmí yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Tatun tacan ñi nyanaá maa ndo tsi yu, tan ña naa iñi ndo tsa jacuahá yu tsi ndo, tacan tan cuví nda̱can ndo náa cuñí maa ndo tsi yu, tan yuhu cua cuhva yu tsa cua ndacan ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tatun cuaha tsa vaha javahá ndo, jacahnú xaan ndo tsi Jutu yu cuví can. Tan tsihin yacan janahá ndo tyin cuví ndo nyɨvɨ tsa nditsa nyicún tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yuhu cuñí yu tsi ndo, tumaa tsa cuñí Jutu yu tsi yu. Ña naa iñi ndo cuhva cuñí yu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tatun tyaá yahvi ndo tsa caahán yu, ña cua naa iñi ndo tyin cuñi yu tsi ndo. Tumaa tsa javahá maa yu, tyaá yahvi yu tsa caahán Jutu yu. Ña naa iñi yu tsa cuñí xaan ra tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Caahán yu tyehen tsihin ndo tyin na cusɨɨ iñi ndo tsihin yu. Tan cusɨɨ ca iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tuhun tsa caahán yu tsihin ndo, yacan cuví tsehe: cu̱ñi tahan ndo tsi ndo, tumaa tsa cuñí maa yu tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tatun yaha xaan cuñí tahan yo tsi yo, cana maa iñi yo cuhva yo ñayɨvɨ iyó yo tsa cuenda inga yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nyooho cuví ra vaha iñi tsi yu tatun javahá ndo tsa caahán yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ña caahán ca yu tyin musu yu cuví tsi ndo, tyin iin musu ña tsitó ra náa javahá tsitoho ra. Caahán yu tyin ra vaha iñi tsi yu cuví ndo, tyin tandɨhɨ tsa caahán Jutu yu tsihin yu tan jacotó yu itsi tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ñavin nyooho nacatsi̱ tsi yuhu tyin maa yu nacatsi̱ tsi ndo. Tan tavá tyiñu yu tsi ndo tsa cuhun ndo tan jaha tyiñu ndo. Tan tyiñu jahá ndo cua quita vaha tsi, tumaa iin itu tsa vaha xaan cuvaha. Tan cuaha xaan nɨñɨ cua coo, tan ña cua tɨvɨ maa tsi. Tacan tan cua cuhva Jutu yu tandɨhɨ tsa ndacan ndo tsi ra tsihin sɨvɨ yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tyehen caahán yu tsihin ndo: Cu̱ñi tahan ndo tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tatun ndasɨ cuñí nyɨvɨ taahán iñi tsa iyó nu ñuhu ñayɨvɨ ihya nyehe ñi tsi ndo, co̱to ndo tyin jihna ca maa yu ndasɨ cuñí ñi nyehe ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tun tsatyin nyɨvɨ cuenda nu ñuhu ñayɨvɨ ihya cuví ndo, cua cuñi nyɨvɨ tsi ndo tumaa tsa cuñí tahan maa ñi tsi ñi. Maa tyin nyooho tsa nacatsi̱ yu tsi ndo mahñu ñi. Yacan cuenda ndasɨ cuñí ñi nyehe ñi tsi ndo, tyin ñavin ca nyɨvɨ cuenda nu ñuhu ñayɨvɨ ihya cuví ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ndu̱cuhun iñi ndo tsa caha̱n yu tsihin ndo, tyin ndi iin musu tan ña cahnu ca cuví ra tan ñavin ca tsitoho ra. Tatun tyaá yahvi nyɨvɨ tsa caahán yu tsihin ñi, tacan cua tyaa yahvi ndɨhɨ ñi tsa jacuahá ndo tsi ñi. Tan tatun ndasɨ́ icá ñi tsihin yu, ndasɨ cua ica ndɨhɨ ñi tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tandɨhɨ yacan cua ica ñi tsihin ndo tsa catyi yuhu, tyin ña nacotó ñi tsi ra tsa jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tun tsatyin ña quitsi̱ yu caha̱n yu tsihin ñi, nduve cuatyi ñi. Maa tyin vityin nduve náa sɨquɨ cua tyaa ñi cuatyi ñi, tyin tsa yaha̱ caha̱n yu tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nyɨvɨ tsa ndasɨ cuñí nyehé tsi yu, ndasɨ cuñí ndɨhɨ ñi nyehé ñi tsi Jutu yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nduve cuatyi ñi, tun tsatyin ña javahá yu tsa ña cuví javaha inga nyɨvɨ. Maa tyin tsa nyehe̱ ñi tandɨhɨ yacan. Vasu ndi maa tsa nyehe̱ ñi can maa tyin ndasɨ cuñí ñi nyehé ñi tsi yu, tan tsi Jutu yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Maa tyin tandɨhɨ yacan cuvi̱, tyin cuñí tsi cundaa tumaa cuhva caahán nu tutu ley tsa jacuahá ñi tsa caahán tyehen: “Nduve vihi náa tsaha, tan ndasɨ cuñi̱ ñi nyehe ñi tsi yu”, catyí tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Maa tyin cua quitsi Tatyi Ii, ra tsa caahán tsa nditsa. Ra ican cuví ra tsa cua cuhva tunyee iñi tsi ndo. Quɨvɨ cua tsaa yu nu nyaá Jutu yu tan cua jaquitsi ndi Tatyi Ii nu yucú ndo. Tan cua cahan ra tumañi iñi tsa cuenda yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tan nyooho tucu cua cahan ndo tumañi iñi tsa cuenda yu, tyin yucú ndo tsihin yu nda quɨvɨ quitsaha̱ jahá tyiñu yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Caahán yu tyehen tsihin ndo tyin tacan tan ña jandɨhɨ ndo tsa tsinú iñi ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Cua tava cuii nyɨvɨ tsi ndo vehe ñuhu. Tan coo quɨvɨ cua cahñi ñi tsi ndo, tan cua cuñi ñi tyin tyiñu Nyoo javahá ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tacan cua ica ñi tyin ña nacoto ñi tsi Jutu yu tan ndi tsi maa yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Caahán yu tsehe tsihin ndo tyin quɨvɨ tsa cua cuvi tumaa cuhva caahán yu tsihin ndo, cua nducuhun iñi ndo tyin tsa yaha̱ caha̱n yu tuhun ihya tsihin ndo. ’Ña caha̱n yu tyehen tsihin ndo nda jihna tyin ndi nyií maa yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Maa tyin vityin cua cuhun yu tyin cunyaa yu tsihin ra tsa jaquitsi̱ tsi yu. Ndi intuhun ndo tan ña tsicá tuhun ndo tsi yu nu maa cua cuhun yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tyin tsa nducuiihya cuñi ndo tsa caahán yu tyehen tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Caahán yu tsa nditsa tsihin ndo tyin vaha ca tsa cuhun yu cuenda tsa vaha tsi maa ndo. Tyin tatun ña cuhun yu, ña cua quitsi Tatyi Ii tsa cua cuhva tunyee iñi tsi ndo. Maa tyin tatun cuhun yu, cua jaquitsi yu tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tan quɨvɨ quitsi ra, cua jacoto ra tsi nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya tyin iyó cuatyi ñi. Tan cua janaha ra ityi vaha tsi ñi, cuhva coo vaha ñi. Tan cua jacoto ra tsi ñi tyin cua cutuñi ñi nuu Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Cua jacoto ra tsi ñi tyin iyó cuatyi ñi tyin ña tsinú iñi ñi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Cua jacoto ra tsi ñi tyin iyó ityi vaha, cuhva coo vaha ñi tyin yuhu cua cuhun yu nu nyaá Jutu yu tan ña cua nyehe ca ndo tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tan cua coto ñi tyin cua jandaa Nyoo cuatyi ñi tyin tsa yaha̱ cundaa̱ cuatyi nu cuví cuihna, nu ndacá ñaha nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Tan cuaha ca tsa nyaá cahan yu tsihin ndo, maa tyin ña cua cutuñi iñi ndo can vityin. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Quɨvɨ quitsi Tatyi Ii tsa caahán tsa nditsa, maa ra cua janaha tandɨhɨ tsa nditsa tsi ndo. Tyin ñavin cuenda maa ra cua cahan ra, tyin cua cahan ra tandɨhɨ tsa tsiñí ra. Tan cua jacoto ra náa cua cuvi nu cuahán ca tsi ityi nuu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Cua jacahnu ra tsi yu, tyin cua naquihin ra tuhun yu tan cua janaha ra can tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tandɨhɨ tsa iyó tsi Jutu yu, tsii maa yu cuví ndɨhɨ can. Yacan cuenda caahán yu tyin Tatyi Ii cua naquihin ra tuhun yu, tan cua janaha ra tsi nyooho. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Ña naha cuii ca tan ña cua nyehe ca ndo tsi yu, maa tyin yaha can tan cua nyehe nyico ndo tsi yu, tyin yuhu cua cuhun yu nu nyaá Jutu yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tacan tan juhva ra tsicá tsihin ra, tsicá tuhun tahan ra naha tan catyí ra naha: ―¿Náa cuñi tsi cahan yacan? Catyí ra tsihin yo tyin ña naha cuii ca tan ña cua nyehe ca yo tsi ra, tan yaha can tan cua nyehe nyico yo tsi ra inga tsaha tyin cua cuhun ra nu nyaá Jutu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Náa cuñí tsi catyi tsa “ña naha cuii ca” can? Ña cutuñí iñi yo náa tuhun caahán ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tan tuvi̱ iñi ra Jesús tyin cuñí ra naha ndaca tuhun ra naha tsi ra, tan catyí ra: ―Yuhu caha̱n yu tsihin ndo tyin ña naha cuii ca tan ña cua nyehe ca ndo tsi yu, maa tyin yaha can tan cua nyehe nyico ndo tsi yu. ¿A yacan cuví tsa tsicá tuhun tahan ndo tsi ndo? ");
INSERT INTO mjcNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tsa nditsa caahán yu tsihin ndo tyin nyooho cua nducuiihya iñi ndo tan cua vacu ndo, maa tyin nyɨvɨ cuenda nu ñuhu ñayɨvɨ cua cusɨɨ iñi ñi. Vasu cuiihya cuñí ndo vityin, tucuiihya iñi can cua nanduvi tsi tsa sɨɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cuhva tsa cua cacu sehe iin ñaha, nyehé ña tundoho. Maa tyin tsa yaha cacu lee can, ndi ña ñuhu ca iñi ña tsa uhvi can tsa cuenda tsa sɨɨ cuñí ña tyin cacu̱ iin lee sehe ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tacan tucu nyooho vityin, cuiihya xaan cuñí ndo. Maa tyin cua nyehe nyico yu tsi ndo inga tsaha. Tacan tan cua cusɨɨ nyico iñi añima ndo. Tan yoñi cuví quihin nyaa tsa sɨɨ can tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Quɨvɨ can nduve ca tsa cua ndaca tuhun ndo tsi yu. Tsa nditsa caahán yu tsihin ndo tyin Nyoo Jutu yu cua cuhva ra tandɨhɨ tsa ndacan ndo tsi ra tsihin sɨvɨ yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nda vityin tan ñaha ca ndacan ndo tsa ndacan ndo tsihin sɨvɨ yu. Nda̱can ndo tan cua ñihi ndo tan cusɨɨ xaan iñi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Maa ñi maa tsihin tsa jandu inducú yu tuhun jacuahá yu tsi ndo. Maa tyin nu cuahán ca tsi, ñavin ca tsihin cuhva can cua jacuaha yu tsi ndo, maa tyin cua catyi tuhun catsi yu tuhun Jutu yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Quɨvɨ can tsihin sɨvɨ yu cua ndacan ndo tsa ndacan ndo tsi ra. Tan ña tsiñí ñuhu ca tsa cahan ndaahvi yu tsihin Jutu yu tsa cuenda ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tyin maa Nyoo Jutu yu cuñí ra tsi ndo. Cuñí ra tsi ndo tyin nyooho cuñí ndo tsi yu, tan tsinú iñi ndo tyin nu nyaá Nyoo quee̱ yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nu nyaá Jutu yu quee̱ yu tyin quitsi̱ yu nu ñuhu ñayɨvɨ ihya. Maa tyin vityin cua nacoo yu ñuhu ñayɨvɨ ihya tyin cua cunuhu nyico yu nu nyaá ra ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tacan tan catyí ra tsicá tsihin ra: ―Vityin nditsa, caahán catsi un tsihin ndi. Ñavin ca tsihin cuhva caahán un tsihin ndi. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vityin nyehé ndi tyin tsitó un tandɨhɨ cuii maa, tan ña tsiñí ñuhu ca tsa ndaca tuhun ndi tsi un tan coto un tsa tsicá iñi ndi. Yacan cuenda tsinú iñi ndi tyin nu nyaá Nyoo quee̱ un ―catyí ra naha tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tan catyí ra Jesús: ―Tan vityin ¿a tsinú iñi ndo tsi yu? ");
INSERT INTO mjcNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Maa tyin caahán yu tsihin ndo tyin tsa vatsí hora. Tan vityin cuví hora tsa cua cuhun ndo sɨɨn sɨɨn ityi. Tan cua nacoo ndo tsi yu. Maa tyin ñavin intuhun ñi yu cua ndoo, tyin Jutu yu nyaá ra tsihin yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Caahán yu tandɨhɨ tsehe tsihin ndo na coo tsa taxin añima ndo tsa cuenda tsa iin ñi cuví ndo tsihin yu. Nu ñuhu ñayɨvɨ ihya cua nyehe ndo tundoho, maa tyin ja̱nyee ndo iñi ndo, tyin yuhu tsa jaha̱ canaa yu tsa ña vaha tsa iyó nu ñuhu ñayɨvɨ ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tsa yaha̱ caha̱n ra Jesús yacan, nanyehe̱ ndaa ra ityi andɨvɨ tan catyí ra: ―Jutu Mañi yu, tsa tsaa̱ hora vityin. Ja̱cahnu tsi yu tsa cuví yu sehe un, tyin tacan tan jacahnu tucu maa yu tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tyin tava̱ tyiñu un tsi yu tsa quɨhɨ ndaha yu tandɨhɨ nyɨvɨ, tan cuhva yu ñayɨvɨ nyitó tsa ña cua naa maa tsi tandɨhɨ nyɨvɨ tsa tsaha̱ un tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tatun nacotó ñi tsi un tyin intuhun ñi maa un cuví Nyoo tsa nditsa, tan nacotó ñi tsi yuhu ra Jesucristo ra tsa jaquitsi̱ un, tacan tan cuví coo ñi ñayɨvɨ nyitó tsa ña cua naa maa. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Tsa jacahnu̱ yu tsi un nu ñuhu ñayɨvɨ ihya tan tyiñu tsa tava̱ tyiñu un tsi yu tsa ndɨhɨ tsi javaha̱ yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tan vityin, Jutu Mañi yu, cua quitsi nuhu nyico yu nu nyaá un, tan cuñí yu tyin nacuhva un tsa cahnu cuví yu tsihin un tsi yu, tumaa tsa tsicoo̱ maa tsi yu nda ndi cumañi ca tsinu ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Tandɨhɨ ra tsa tsaha̱ un tsi yu naha ra, ra tsa natava̱ vaha un mahñu nyɨvɨ iyó nu ñuhu ñayɨvɨ ihya, jacoto̱ yu tsi ra naha yóo ra cuví yooho. Tsii maa un cuví tsi ra naha tan tsaha̱ un tsi ra naha tsi yu. Tan tyaá yahvi ra naha tsa caahán un. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Vityin tsitó ra naha tyin tandɨhɨ tsa tsaha̱ un tsi yu, nu nyaá un quee̱ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tyin catyi̱ tuhun yu tsihin ra naha tsa caha̱n un tsihin yu, tan naquihi̱n vaha ra naha itsi. Tan tsitó ra naha tyin nditsa tsa quee̱ yu nu nyaá un, tan tsinú iñi ra naha tyin maa un jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Yuhu tsicán tahvi yu tsi un tsa cuenda ra naha. Ña tsicán tahvi yu tsa cuenda tandɨhɨ nyɨvɨ, maa tyin tsicán tahvi yu tsa cuenda ra tsa tsaha̱ un tsi yu naha ra, tyin tsi maa un cuví ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tandɨhɨ nyɨvɨ tsa cuví tsii un, tsahá tucu un tsi ñi tsi yu. Tan maa ñi janahá tsa cahnu cuví yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Yuhu ña cua ndoo ca yu nu ñuhu ñayɨvɨ ihya, maa tyin maa ra naha cua ndoo ra naha nu ñuhu ñayɨvɨ ihya. Tan yuhu cua cunyaa nyico yu tsihin un. Ja̱ha cuenda tsi ra tsa tsaha̱ un tsi yu tsihin tunyee iñi tsa iyó tsi maa un, Jutu Mañi yu. Tan na iin ñi cuvi ra naha, tumaa tsa iin ñi cuví maa yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Quɨvɨ tsinyii̱ yu nu ñuhu ñayɨvɨ ihya tsihin ra naha, jaha̱ cuenda yu tsi ra tsa tsaha̱ un tsi yu naha ra tsihin tunyee iñi tsa iyó tsi un. Tan jaha̱ cuenda yu tsi ra naha. Tan ndi intuhun ra naha tan ña tsinaa̱ ra naha. Maa tyin ra tsa tsa nyaá maa tsa cunaa, ra ican ñi cuví ra cuanaa̱ tan quita̱ cuhva tumaa tsa catyí nu tutu maa un. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Vityin tsa cua quitsí yu nu nyaá un, maa tyin tsitsi tsa ndi nyií yu nu ñuhu ñayɨvɨ ihya, caahán yu tsehe, tyin na cusɨɨ iñi ra naha tumaa tsa sɨɨ cuñí maa yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yuhu caha̱n yu tsihin ra naha tsa caahán un, maa tyin nyɨvɨ cuenda nu ñuhu ñayɨvɨ ndasɨ cuñí ñi nyehe ñi tsi ra nyicún tsi yo naha ra, tsa cuenda tyin ñavin ra cuenda nu ñuhu ñayɨvɨ cuví ra naha. Tumaa yuhu, ñavin ra cuenda nu ñuhu ñayɨvɨ cuví yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ña tsicán yu tsi un tsa tava un tsi ra nyicún tsi yo naha ra nu ñuhu ñayɨvɨ ihya, maa tyin ja̱ha cuenda tsi ra naha coto náa jaha nu ña vaha tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tumaa yuhu ñavin ra cuenda nu ñuhu ñayɨvɨ cuví yu, tacan tucu ra ihya naha ra, ñavin ra cuenda nu ñuhu ñayɨvɨ cuví ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ja̱cu ii tsi ra naha tsihin tsa nditsa, na javaha ra naha maa ñi maa cuhva cuñí maa un. Tyin tsa caahán un, yacan cuví tsa nditsa. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tumaa tsa jaquitsi̱ un tsi yuhu nu yucú nyɨvɨ iyó nu ñuhu ñayɨvɨ, tacan cua jacuhun ndɨhɨ tucu yuhu tsi ra tsa nyicún tsi yo, nacahan ra naha tuhun yo tsihin nyɨvɨ tsa ñaha ca coto tuhun yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tan tsa cuenda tsa vaha tsi maa ra naha, jacu ii maa yu tsi yu tyin tacan tan cuví jacu ii tucu maa ra naha tsi ra naha tsihin tsa nditsa. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ñavin tsa cuenda ra ihya ñi naha ra tsicán tahvi yu tsi un. Tsicán tahvi ndɨhɨ tucu yu tsi un tsa cuenda nyɨvɨ tsa cua tsinu iñi tsi yu, tsa cuenda tsa cua cahan ra ihya naha ra ityi nuu ca. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tsicán yu tsi un na iin ñi cuvi ñi tsihin inga ñi. Tan na iin ñi cuvi ñi tsihin yo, Jutu Mañi yu. Tumaa yooho nyaá un tsihin yu tan yuhu nyaá yu tsihin un, na iin ñi cuví ñi tsihin yo, tyin tacan tan tandɨhɨ nyɨvɨ iyó nu ñuhu ñayɨvɨ cua tsinu iñi ñi tyin maa un jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yuhu tsaha̱ yu tsa cahnu cuví un tsi ñi nyicún tsi yo. Juvin ñi maa tsa cahnu cuví un tsa tsaha̱ un tsi yu tyin tsihin yacan na iin ñi cuví ñi, tumaa yooho tsihin yuhu, iin ñi cuví yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yuhu nyií yu tsihin ñi. Tan yooho nyaá un tsihin yu tyin tacan tan iin ña nyɨvɨ cua cuvi ñi. Tan coto tandɨhɨ nyɨvɨ iyó nu ñuhu ñayɨvɨ tyin maa un jaquitsi̱ tsi yu, tan cuñí xaan un tsi ñi nyicún tsi yo, tumaa tsa cuñí maa un tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Jutu Mañi yu, maa un tsaha̱ tsi ñi tsi yu. Tan cuñí yu tsa cunyaa ñi tsihin yu nu cua cunyaa yu, tan na nyehe ñi tsa cahnu cuví tsa tsaha̱ un tsi yu, tyin cuñí un tsi yu nda ndi cumañi ca tsinu ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Jutu Mañi yu, ra vaha cuví un, tan nyɨvɨ cuenda nu ñuhu ñayɨvɨ ña tsitó ñi tsi un, maa tyin yuhu tsitó yu tsi un. Tan ra nyicún tsi yo ihya tsitó ra naha tyin maa un jaquitsi̱ tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tsa caha̱n yu tsihin ra naha yóo ra cuví un, tan cua cahan nyico tucu yu inga tsaha, tyin tumaa cuhva cuñí un tsi yu, tacan cua cuñi tahan ra naha tsi ra naha. Tan yuhu cunyaa yu añima ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tsa yaha̱ tsa caha̱n ra Jesús yacan, tacan tan cuahán ra tsihin ra tsicá tsihin ra inga tsiyo yutya Cedrón. Tan ican iyó iin cora yutun tata. Tan ican quɨhvɨ̱ ra Jesús tsihin ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tan ra Judas, ra tsa xico̱ tsi ra, tsitó ra nu cuahán ra Jesús tyin ican tuhvá ra Jesús tsaahán tsihin ra tsicá tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tan ican tsaa̱ ra Judas tsihin andaru cuaha tan cuaha ra vitya cuenda vehe ñuhu tsa jacuhun ra cuví ityi nuu tsihin jutu naha ra tan ra cuví fariseo naha ra. Tsaa̱ ra naha ican, nyisó ra naha mityi, tan nyisó ra naha lámpara tan ñuhu̱ yɨtɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tan ra Jesús tsa tsitó maa ra tandɨhɨ tsa cua tahan ra. Quita̱ ra tan tsica̱ tuhun ra tsi ra naha: ―¿Yóo nanducú ndo? ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tan catyí ra naha tsihin ra: ―Ra Jesús ra ñuu Nazaret. Tan catyí ra Jesús: ―Yuhu cuví ―catyí ra. Tan ra Judas, ra tsa xico̱ tsi ra Jesús tsi nu xaan iñi tsi ra nahnu, nyií ndɨhɨ ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Cuhva tsa caha̱n ra Jesús: “Yuhu cuví”, tandɨhɨ ra naha nacaca̱ tsata ra naha tan nduva̱ ra naha nu ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tacan tan tsica̱ tuhun nyico ra Jesús tsi ra naha inga tsaha, tan catyí ra: ―¿Yóo nanducú ndo? Tan catyí ra naha: ―Ra Jesús ra ñuu Nazaret. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tan catyí ra Jesús: ―Tsa caha̱n yu tsihin ndo tyin yuhu cuví. Tatun yuhu nanducú ndo, ja̱ña ndo tsi ra tsicá tsihin yu naha ra na cunuhun ra naha ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yacan caha̱n ra Jesús tyin na cundaa tsa caha̱n ra nda ityi tsata ca nu catyi̱ ra: “Ra tsa tsaha̱ Jutu yu tsi yu, ndi intuhun ra naha tan ña tsinaá ra naha.” ");
INSERT INTO mjcNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tacan tan tava̱ ra Simón Pedro mityi tsa ndahá ra tan tsahnya̱ ra soho cuaha iin ra tsa nañí Malco. Ra ican cuví musu ra jutu tsaahnu tsa cuví ityi nuu tsihin ra jutu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Maa tyin ra Jesús catyí ra tsihin ra Pedro: ―Na̱tyihi mityi un tsitsi vena un. Tatun Nyoo Jutu yu tan cuñí ra tsa nyehe yu tundoho, taahán tsi tsa nyehe yu can ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tacan tan andaru can tsihin capitán ra naha, tan vitya cuenda vehe ñuhu naha ra, tɨɨ̱n ra naha tsi ra Jesús, tan tsahñi̱ ra naha tsi ra, ");
INSERT INTO mjcNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","tacan tan tsindaca̱ ra naha tsi ra yuvehe ra Anás, tyin ra Anás can tyiso ra Caifás cuví tsi ra. Tan cuiya can ra Caifás can cuví ra jutu tsaahnu cuví ityi nuu tsihin jutu. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ra Caifás can cuví ra tsa caha̱n tsihin ra cuví ityi nuu tsihin nyɨvɨ Israel naha ra tyin vaha ca tsa cúu intuhun ñi rayɨɨ tsa cuenda tandɨhɨ nyɨvɨ ñuu. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ra Simón Pedro tan inga ra tsa tsica̱ tsihin ra Jesús, nyicún ra naha tsi ra Jesús nu cuahán ra nuquehe yuvehe ra Anás, ra jutu tsaahnu cuvi̱ ityi nuu tsihin jutu. Tan nacotó ra jutu can tsi inga ra can. Yacan cuenda quɨhvɨ̱ ra can tsihin ra Jesús nuquehe ra jutu can. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Maa tyin ra Pedro ndoo̱ ra ityi tsata vehe. Yacan cuenda quita̱ ra tsa nacotó ra jutu can, tan caha̱n ra tsihin ñaha tsa nyaá yuvehe can. Tan jayaha̱ ra tsi ra Pedro ityi tsitsi nuquehe can. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tacan tan ñaha tsa nyaá yuvehe can tsica̱ tuhun ña tsi ra Pedro, tan catyí ña: ―¿A ñavin yooho cuví iin ra tsica̱ tsihin ra can? Tan catyí ra Pedro: ―Ñavin. Ñavin yu cuví ―catyí ra tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tacan tan ra cuví musu tan ra vitya naha ra tsa yucú ican, jataha̱n ra naha ñuhu̱ tyin vitsin xaan. Tan nyecú nyityi ra naha tuñu ra naha ñuhu̱. Tan nyií ndɨhɨ tucu ra Pedro tuñu ra ñuhu̱ tsihin ra naha ican. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tacan tan ra jutu tsaahnu can quitsaha̱ tsicá tuhun ra tsi ra Jesús yoo ra cuví ra tsicá tsihin ra, tan náa jacuahá ra tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tan catyí ra Jesús tsihin ra: ―Yuhu nuu tandɨhɨ nyɨvɨ caha̱n yu. Tan jacuaha̱ yu tsi ñi tsitsi vehe ñuhu ñuu tan ñuu tan tsitsi vehe ñuhu cahnu ñuu ihya nu tuhvá tandɨhɨ nyɨvɨ Israel ndu iin. Tan nduve nu caha̱n xeehe yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Nacuenda tsicá tuhun un tsi yuhu? Vaha ca nda̱ca tuhun un tsi nyɨvɨ tsa tsiñi̱ tsa caha̱n yu, tan maa ñi cua catyi tuhun náa caha̱n yu tsihin ñi tyin maa ñi tsitó náa caha̱n yu ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cuhva tsa caahán ra Jesús yacan, tan iin vitya vehe ñuhu tsa yucu ican, cañi̱ ra iin tsiyo nuu ra Jesús tan catyí ra: ―¿A tacan taahán tsi nacahan un nu caahán ra jutu tsaahnu cuví ityi nuu? ―catyí ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tan catyí ra Jesús: ―Tatun caha̱n yu iin tsa ña vaha, ca̱han tsihin yu nda tsa ña vaha caha̱n yu. Maa tyin tatun caha̱n yu tsa vaha, ¿nacuvi tyin cañi̱ un tsi yu? ―catyí ra Jesús tsihin ra can. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yaha̱ can tan nuuhñi ra Jesús, tan jacuhu̱n ra Anás tsi ra nu nyaá ra Caifás, ra jutu tsaahnu cuví ityi nuu tsihin jutu cuiya can. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tan nyaá nyityi ra Pedro tuñu ra ñuhu̱. Tan catyí ra naha tsihin ra: ―¿A ñavin yooho cuví iin ra tsicá tsihin ra can? ―catyí ra naha tsihin ra. Tan ra Pedro tyihi̱ xeehe ra, tan catyí ra: ―Ñavin. Ñavin yu cuví ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tacan tan iin ra cuví musu ra jutu tsaahnu cuví ityi nuu tsihin jutu, iin ra tsa cuví nyɨvɨ ra tsa tsahnya̱ ra Pedro soho, quitsaha̱ tsicá tuhun ra tsi ra tan catyí ra: ―¿Atu ñavin un cuví tsa nyehe̱ yu tsihin ra can tsitsi cora yutun tata can? ―catyí ra tsihin ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tan tyihi̱ xeehe nyico ra Pedro inga tsaha. Juvin ñi cuhva can tan navacu̱ ñi iin tsitooho. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yaha̱ can tan quita̱ ra naha tsihin ra Jesús yuvehe ra Caifás tan tsindaca̱ ra naha tsi ra vehe tyiñu ra ndacá ñaha. Tsa cua cunditsin tan ra Israel ña quɨhvɨ̱ ra naha tsitsi vehe tyiñu can tyin ñavin vehe nyɨvɨ Israel cuví can. Tyin ica tsa quɨhvɨ̱ ñi Israel vehe ndavaha ñi tyin coto ña cua cuvi cuxiñi ñi quɨvɨ vico pascua. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yacan cuenda quita̱ ra Pilato tyin cahan ra tsihin ra naha, tan catyi ra: ―¿Náa cuatyi tyaá ndo sɨquɨ ra ihya? ―catyí ra Pilato tsihin ra cuví ityi nuu tsihin nyɨvɨ Israel naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tan nacaha̱n ra Israel naha ra tan catyí ra naha: ―Tun tsatyin ñavin iin ra iyó cuatyi cuví ra, ña cua cuhva cuenda ndi tsi ra tsi un ―catyí ra naha tsihin ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tacan tan catyí ra Pilato tsihin ra naha: ―Qu̱ihin ndo tsi ra, tan ta̱tsi tuñi ndo tsi ra tumaa catyí maa ley ndo. Tan nacaha̱n ra Israel can naha ra tan catyí ra naha: ―Maa tyin nyuhu nyɨvɨ Israel nduve ndatu iyó tsi ndi tsa cahñi ndi tsi nyɨvɨ ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tacan cundaa̱ tsa caha̱n ra Jesús nácaa cua cúu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Yaha̱ can tan quɨhvɨ̱ nyico ra Pilato tsitsi vehe tyiñu can inga tsaha. Tan cana̱ ra tsi ra Jesús tan tsica̱ tuhun ra tsi ra: ―¿A yooho cuví rey cuenda nyɨvɨ Israel? ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tan catyí ra Jesús: ―¿A tsa cuñí ñi maa un tsicá tuhun un tsehe tsi yu o iyó inga nyɨvɨ natyuhu̱ tsi un cuhva caha̱n un tsihin yu? ―catyí ra Jesús tsihin ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tan catyí ra Pilato: ―Ñavin ra ñuu Israel cuví yuhu. Juvin ñi maa ra ñuu maa un naha ra tan ra cuví ityi nuu tsihin jutu ñuu maa un cuví ra tsaha̱ cuenda tsi un tsi yu. ¿Náa javaha̱ un? ―catyí ra tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tacan tan nacaha̱n ra Jesús tan catyí ra: ―Nu ndacá ñaha yu ñavin cuenda nu ñuhu ñayɨvɨ ihya cuví tsi. Tun tsatyin ndacá ñaha yu nu ñuhu ñayɨvɨ ihya, ra nyicún tsi yu cañi tahan ra naha tyin tacan tan yoñi cua cuhva cuenda tsi yu ndaha ra Israel naha ra. Maa tyin nu ndacá ñaha yu, ñavin cuenda ihya cuví tsi ―catyí ra Jesús tsihin ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tacan tan catyí ra Pilato tsihin ra: ―¿Tun tacan, rey cuví maa un? ―catyí ra Pilato tsihin ra Jesús. Tan nacaha̱n ra Jesús tan catyí ra: ―Rey cuví yu tumaa tsa caahán maa un. Yacan cuenda cacu̱ yu tan vatsí yu nu ñuhu ñayɨvɨ ihya, tyin cahan yu tsa nditsa. Tandɨhɨ nyɨvɨ tsa tyaá yahvi tsa nditsa, tyaá soho ñi tsa caahán yu ―catyí ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tan catyí ra Pilato tsihin ra: ―¿Tan náa cuví tsa nditsa? ―catyí ra. Tsa yaha̱ tsa tsica̱ tuhun ra Pilato yacan, quita̱ ra tsicaha̱n nyico ra tsihin ra Israel naha ra inga tsaha tan catyí ra: ―Yuhu ña nañihi maa yu ndi intuhun cuatyi ra ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Maa tyin nyooho iyó ndo tuhun tsa tsicán ndo na tava yu tsi iin ra nyií vehe caa tsa iyó vico pascua ihya. ¿A cuñí ndo tava yu tsi ra tsa cuví rey cuenda ndo tsa cuví ndo nyɨvɨ Israel? ―catyí ra Pilato tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tacan tan quitsaha̱ caná tsaa tandɨhɨ ra naha tan catyí ra naha: ―¡Ña tava un tsi ra can! ¡Ta̱va tsi ra Barrabás! ―catyí ra naha. Tan ra Barrabás can cuví ra iin ñasuhu. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tacan tan quihi̱n ra Pilato tsi ra Jesús tan tava̱ tyiñu ra na cañi andaru tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tan andaru can javaha̱ ra naha iin corona iñu tan tyihi̱ ra naha jiñi ra Jesús. Tan jacunditsi̱ ra naha iin jahma tunduuhva tsi ra, tahan tsa tuhvá ra cuví rey tsinditsí. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tacan tan natuhva̱ ra naha nu nyáá ra tan caahán nyaa ra naha tsi ra, tan catyí ra naha: ―¡Nacumi tsi un yooho Rey cuenda nyɨvɨ Israel! ―catyí ra naha, tan cañí ra naha nuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tacan tan quita̱ nyico ra Pilato inga tsaha tan catyí ra tsihin ra naha: ―Nye̱he ndo tyin cua tava yu tsi ra ityi nuu ndo tyin nyehe ndo tyin ndi iin cuatyi ra ña nañihí yu ―catyí ra Pilato tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tan quita̱ ra Jesús yɨhɨ́ corona iñu jiñi ra, tan nditsí ra jahma tunduuhva can. Tacan tan catyí ra Pilato tsihin ra naha: ―¡Ma ra nyaá ihya! ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cuhva tsa nanyehé ra cuví ityi nuu tsihin jutu naha ra tan ra vitya naha ra tsi ra, quitsaha̱ caná tsaa ra naha tan catyí ra naha: ―¡Tya̱a tsi ra nu cruu na cúu ra! ―catyí ra naha. Maa tyin catyí ra Pilato tsihin ra naha: ―Qu̱ihin ndo tsi ra tan ca̱hñi maa ndo tsi ra nu cruu tyin yuhu ndi intuhun cuatyi ra tan ña nañihí yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Maa tyin nacaha̱n ra Israel can naha ra tan catyí ra naha: ―Iyó iin ley tsi ndi, tan cuhva catyí ley ndi, cuñí tsi tsa cúu ra tyin jahá ra tsa Sehe Nyoo cuví tsi ra ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tsa tsiñi̱ ra Pilato yacan, tan nayuhvi̱ xaan ca ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tan quɨhvɨ̱ nyico ra inga tsaha tsitsi vehe tyiñu, tan tsica̱ tuhun ra tsi ra Jesús: ―¿Nu maa quee̱ yooho? ―catyí ra tsihin ra. Maa tyin ra Jesús ña nacaha̱n maa ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tacan tan catyí ra Pilato tsihin ra: ―¿Nacuenda ña caahán un tsa caahán yu? ¿A ña tsitó un tyin ra cumí tyiñu cuví yu tan iyó ndatu tsi yu tsa tyaa yu tsi un nu cruu, tan iyó tucu ndatu tsi yu tsa tava nuña yu tsi un? ―catyí ra Pilato tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tan nacaha̱n ra Jesús tan catyí ra: ―Tun tsatyin ña tsaha̱ Nyoo tyiñu can tsi un, nduve ndatu cua coo tsi un tsa tatsi tuñi un tsi yu. Yacan cuenda, ra tsa quitsi ndaca tsi yu ndaha un, cahnu ca cuatyi ra can naha ra iyó tan ñavin ca yooho ―catyí ra Jesús tsihin ra Pilato. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tsa ndɨhɨ caha̱n ra Jesús yacan, tan quitsaha̱ nducú ra Pilato cuhva jaña ra tsi ra, maa tyin ra Israel caná tsaa ra naha tsata ra, tan catyí ra naha: ―¡Tatun jaña un tsi ra, ñavin amigo ra César, ra cuví rey cahnu, cuví tsi un! Tyin tandɨhɨ ra tsa caahán tyin rey cuví ra naha, ra xaan iñi tsi rey cahnu cuví ra naha ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tacan tan tsa tsiñi̱ ra Pilato yacan, tava̱ tyiñu ra na quita ra Jesús ityi tsata vehe. Tan tsinyaa̱ ra Pilato nu nañí Gabata nu tuhvá ra jandaá cuatyi nyɨvɨ. Tan tsihin yuhu hebreo cuñí tsi catyí: “Nu canyií yuu”. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tan cuví tsi iin quɨvɨ tsa ndi cumañi ca coo vico pascua, cuhva tsa cua tahan hora. Tacan tan catyí ra Pilato tsihin ra Israel can naha ra: ―¡Ihya nyaá rey ndo! ");
INSERT INTO mjcNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Maa tyin cana̱ tsaa ra Israel naha ra tan catyí ra naha: ―¡Na cúu ra! ¡Na cúu ra! ¡Tya̱a tsi ra nu cruu! ―catyí ra naha. Tan catyí ra Pilato tsihin ra naha: ―¿A tyaa yu tsi ra cuví rey ndo nu cruu? Maa tyin ra cuví ityi nuu tsihin jutu catyí ra naha: ―Yoñi ca rey iyó. Intuhun ñi maa ra César, ra cuví rey cahnu ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tacan tan tsaha̱ cuenda ra Pilato tsi ra Jesús tsi ra naha na tyaa ra naha tsi ra nu cruu. Tan quihi̱n andaru tsi ra, cuahán ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tan nyisó ra Jesús cruu ra, cuahán ra iin nu nañí: “Yɨquɨ Jiñi Ndɨyɨ”. Tan tsihin yuhu hebreo nañí tsi Gólgota. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ndacan tyaa̱ ra naha tsi ra nu cruu tsihin nduyu. Tan tyaa̱ ra naha uvi taahan ca ra naha xiin ra. Ticaa̱ ra naha iin ra nu cruu tsa nyaá tsiyo cuaha ra. Tan inga ra tyaa̱ ra naha tsiyo satyin ra. Tan ticaa̱ ra naha tsi ra Jesús mahñu. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tan tava̱ tyiñu ra Pilato na cunyaa letra jiñi cruu can. Tan catyí tsi tyehen: “Ra Jesús ra ñuu Nazaret, Rey cuenda nyɨvɨ ñuu Israel.” ");
INSERT INTO mjcNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tan cuaha nyɨvɨ Israel cahvi̱ ñi tsa caahán can, tyin yatyin ñi ñuu ñi cuví nu tsaquinyaa̱ ra naha cruu ra Jesús. Tan nyaá letra can tsihin yuhu hebreo, tan yuhu griego, tsihin yuhu latín. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yacan cuenda ra cuví ityi nuu tsihin jutu caha̱n ra naha tsihin ra Pilato: ―Ña tyaa un: “Rey cuenda nyɨvɨ ñuu Israel”, vaha ca tyaa un: “Ra ihya catyí ra tyin rey cuenda nyɨvɨ ñuu Israel cuví ra” ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Maa tyin catyí ra Pilato: ―Tsa tsa yaha̱ tyaa̱ yu, nandoo maa tsi tacan ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tsa yaha̱ tyaa̱ ra andaru can naha ra tsi ra Jesús nu cruu, naquihi̱n ra naha jahma ra. Tsa cumi taahan ra naha quihi̱n luxu luxu jahma ra. Tan ndoo̱ jahma ra tsa quicu̱ cañi ñi tsa tsindasɨ̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tan andaru can natuhún tahan ra naha: ―Ña cua cahnya yo itsi. Jasɨquɨ suuhva jihna yo na nyehe yo yóo cua jaha canaa jahma can ―catyí ra naha. Tacan cuvi̱ tumaa caahán nu tutu Nyoo nu catyí tsi tyehen: “Tsatsa̱ tahan ra naha luxu luxu jahma yu tan jasɨquɨ̱ suuhva ra naha tsihin tsi, nyehe̱ ra naha yóo ra jaha canaa itsi.” Tan yacan cuvi tsa javaha̱ ra andaru can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tan nyáá sɨhɨ ra Jesús yatyin ñi nu nyaá cruu ra. Tan nyáá tucu tahan ña, tan ña María ñasɨɨhɨ ra Cleofas, tan ña María quee̱ ñuu Magdala. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tan nanyehe̱ ra Jesús tsi sɨhɨ ra, nyáá ña yatyin ñi. Tan nanyehe̱ tucu ra tsi ra tsa tsica̱ tsihin ra, ra tsa cuñí xaan ra. Tan catyí ra tsihin sɨhɨ ra: ―Miya, va ra sehe un nyáá tsihin un juvin ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tacan tan catyí ra tsihin ra tsa cuñí xaan ra: ―Tsaa, va sɨhɨ un nyáá tsihin un juvin ―catyí ra tsihin ra. Nda quɨvɨ can tan quihi̱n ra tsi ña, cuahan tsihin ra yuvehe ra. Tan jaha̱ cuenda ra tsi ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tsa yaha̱ yacan, tsa nyehe̱ ra Jesús tyin tsa ndɨhɨ̱ tyiñu jaha̱ ra. Tacan tan catyí ra: ―Na ityi iñi yu ―catyí ra. Tan tsihin yacan cundaa̱ tsa nyaá nu tutu Nyoo nu caahán tsi nácaa cua cúu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tan ican nyaá iin quɨyɨ nu yɨhɨ́ vinu iya. Tacan tan jatyii̱ ra naha tsa cuví yahma tumaa caa catyi tsihin vinu iya can. Tan tyaa̱ ra naha yacan nu iin yutun hisopo. Tan jandaa̱ ra naha tan tyanaa̱ ra naha can yuhu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tsihi̱ ra Jesús vinu can tan catyí ra: ―Tsa iyó vaha tandɨhɨ vityin ―catyí ra. Tacan tan nacañi̱ nuu ra jiñi ra tan tsihi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tsa ndi cumañi intuhun ña quɨvɨ tan tahan tsi quɨvɨ vico cahnu pascua, tan ra cuví ityi nuu tsihin nyɨvɨ Israel ña cuñí ra naha tsa ndoo cuñu ñuhu ra tsa tsihi̱ can naha ra nu cruu quɨvɨ quitatú, tyin quɨvɨ quitatú, quɨvɨ ii cuví tsi tsa cuenda ra naha. Yacan cuenda tsica̱n ra naha tumañi iñi tsi ra Pilato na tava tyiñu ra na cahnu andaru sɨhɨn ra tsa ticaa nu cruu can naha ra, tyin tacan tan numi ñi cúu ra naha, tan jatsiyo ra naha cuñu ñuhu ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tacan tan cuahán andaru nu nyecú cruu can. Tan tsahnu̱ ra naha sɨhɨn iin ra ticaá iin tsiyo xiin ra Jesús. Tan tsahnu̱ nyico ra naha sɨhɨn inga ra tsa ticaa inga tsiyo xiin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Maa tyin cuhva tsa natuhva̱ ra naha nu ticaá ra Jesús, nyehe̱ ra naha tyin tsa tsihi̱ maa ra. Yacan cuenda ña tsahnu̱ ca ra naha sɨhɨn ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Maa tyin iin andaru can tutsi̱ ra yoco xaan yɨquɨ naha ra Jesús. Tan quita̱ nɨñɨ tan ndutya. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ra tsa nacatyí tuhun yacan, ra tsa nyehe̱ vaha cuví ra. Tan tsa nditsa caahán ra, tyin maa ra tsitó tyin tsa nditsa caahán ra, tacan tan tsinu ndɨhɨ tucu iñi nyooho. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tacan cuvi̱ tyin tacan tan cundaa tsa catyí tuhun Nyoo nu catyí tsi: “Ndi intuhun yɨquɨ ra tan ña tahnu.” ");
INSERT INTO mjcNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tan iyó inga nyico nu catyí tsi nu tutu Nyoo tyehen: “Cua nyehe nyɨvɨ tsi ra tsa tutsi̱ ra naha yoco xaan.” ");
INSERT INTO mjcNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tsa yaha̱ yacan, ra José ra ñuu Arimatea tsica̱n ndatu ra tsi ra Pilato na cuhva ra tsa naquihin ra cuñu ñuhu ra Jesús. Tan ra José can cuví ra iin ra yɨhɨ́ cuenda ra Jesús vasu tsa xeehe ñi tsa cuenda tsa yuuhví ra tsi ra cuví ityi nuu tsihin nyɨvɨ Israel. Tacan tan tsaha̱ ra Pilato ndatu tsi ra, tan tsaha̱n ra José tsinaquihi̱n ra cuñu ñuhu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tsaha̱n ndɨhɨ tucu ra Nicodemo, ra tsa tsaha̱n tsicaha̱n tsihin ra Jesús tsa tsa cuaa. Tsaa̱ ra tsihin ndutya tami. Tan iin ndutya tami tsa nañí mirra nasaca̱ nuu tsihin inga tsa nañí áloe. Tan quita̱ tsi tumaa oco utsi kilu tsa tandɨhɨ tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tacan tan ra José tsihin ra Nicodemo quihi̱n ra naha cuñu ñuhu ra Jesús tan cava̱ nuu ra naha tsi ra tsihin jahma cuɨñɨ tsa tyihi̱ ra naha ndutya tami can, tumaa iyó maa nyɨvɨ Israel tun cua cutsi ñi ndɨyɨ tsitsi ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yatyin nu tsahñi̱ ra naha tsi ra Jesús nu cruu iyó iin cora yutun tata. Tan tsitsi cora can nyaá iin ñaña tsaa nu ñaha ca cuyucu ndi intuhun ndɨyɨ. ");
INSERT INTO mjcNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ican ñi tinyii̱ ra naha cuñu ñuhu ra Jesús tyin yatyin ñi nyaá ñaña can tan tsa cua tahan tsi quɨvɨ quitatú nyɨvɨ Israel. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tsa naa ca tsa cuvi̱ tumingu, ña María quee̱ ñuu Magdala tsaha̱n ña nu ñaña ra Jesús. Tan nyehe̱ ña tyin nduve ca yuu ndasɨ́ yuhu ñaña can. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tacan tan tsinú xaan ña cuahán ña nu nyií ra Simón Pedro tan inga ra tsica̱ tsihin ra Jesús, ra tsa cuñí xaan ra Jesús. Tan catyí ña tsihin ra naha: ―Quihi̱n nyɨvɨ cuñu ñuhu Jutu Mañi yo tsitsi ñaña, tan ña tsitó yo nu maa tsindaca̱ ñi itsi ―catyí ña María tsihin ra Pedro tan tsihin inga ra can. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tacan tan ra Pedro tan inga ra can cuahán ra naha nu ñaña. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tan cuahán nduvi taahan ra naha iin caa ñi, tsinú ra naha. Maa tyin ñihi ca tsinú inga ra can tan ñavin ca ra Pedro, jihna ca ra can tsaa̱ nu ñaña. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Quitsaha̱ nyehé ihñi ra tsitsi ñaña, tan nyehe̱ ra jahma cuɨñɨ tsa cava̱ nuu cuñu ñuhu ra Jesús, canyií can. Maa tyin ña quɨhvɨ̱ ra tsitsi ñaña. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yaha̱ can tan tsaa̱ ndɨhɨ ra Simón Pedro tsata ra, tan ra ican quɨhvɨ̱ ra tsitsi ñaña can. Juvin ñi nyehe̱ ndɨhɨ ra can jahma can canyií tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tan juvin ñi nyehe̱ ndɨhɨ ra tyin jahma tsa tsindasɨ̱ jiñi ra Jesús, ña iin ñi nu canyií can tsihin inga jahma can, yɨhɨ́ tahnu can tan cayucú sɨɨn can. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tacan tan quɨhvɨ̱ ndɨhɨ inga ra tsica̱ tsihin ra Jesús can, ra tsa tsaa̱ tsa jihna nu ñaña can. Tan nyehe̱ ra tsa cuvi̱ can, tan tsinu̱ iñi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tyin tsa jihna, ña cutuñí iñi ra naha tsa caahán nu tutu Nyoo, tyin ra Jesús cuñí tsi tsa nandoto ra tsa yaha cúu ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tacan tan cuanuhu ra tsica̱ tsihin ra Jesús nda yuvehe ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maa tyin tsa tsaa̱ nyico ña María, ndoo̱ ña nyaá ña tsacú xaan ña ityi tsata ñaña can. Tan tsitsi tsa tsacú ña, nyehé ihñi ña tsitsi ñaña can. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Tan nyehe̱ ña uvi taahan ángel nditsí ra naha jahma cuitsin, nyecú ra naha nu tsicava̱ cuñu ñuhu ra Jesús. Iin ra nyaá ityi nu tsicava̱ jiñi ra, tan inga ra nyaá ityi nu tsicava̱ tsaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tan tsica̱ tuhun ra ángel can naha ra tsi ña tan catyí ra naha: ―¿Nacuvi tsacú xaan un? Tan catyí ña: ―Tsacú maa yu tyin quihi̱n nyɨvɨ tsi Jutu Mañi yu, tan ña tsitó yu nu maa tinyií ñi tsi ra ―catyí ña tsihin ángel can. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ndi caahán ca ña yacan, tan nanyico coo ña tan nyehe̱ ña tsi ra Jesús ican. Maa tyin ña tsitó ña tatun ra Jesús cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tacan tan tsica̱ tuhun ra Jesús tsi ña: ―¿Nacuenda tsacú un? ¿Yóo nanducú un? ―catyí ra tsihin ña. Cuñí maa ña tyin ra jahá cuenda cora yutun tata can cuví ra. Tan catyí ña: ―Tatta, tatun yooho quihi̱n tsi ra Jesús, ca̱han tsihin yu nu maa tsindaca̱ un tsi ra, tyin cunaquihin yu tsi ra ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tacan tan catyí ra Jesús tsihin ña: ―¡María! ―catyí ra tsihin ña. Tan nanyehe̱ ña tan caha̱n ña tsihin ra tsihin yuhu hebreo, tan catyí ña: ―¡Raboni! ―Tan cuñí tsi catyí can: “Maestro”. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Tan catyí ra Jesús tsihin ña: ―Ña tɨ̱ɨn un tsi yu, tyin ñaha ca cuhun yu nu nyaá Jutu yu. Maa tyin cu̱aahan tan ca̱han un tsihin tandɨhɨ yañi yu tyin cuahan yu nu nyaá Jutu yu, tan juvin ñi Jutu ndɨhɨ ndo cuví tsi ra. Cuahan yu nu nyaá Nyoo yu, tan juvin ñi Nyoo ndo cuví tsi ra ―catyí ra Jesús tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tacan tan tsaha̱n ña María ñuu Magdala can tsijacoto̱ ña tsi ra tsica̱ tsihin ra Jesús tyin nyehe̱ ña tsi ra tan caha̱n ra yacan tsihin ña. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Juvin ñi maa quɨvɨ can nu quitsaha vitya, tsa cua cuaa tan ndu ii̱n ra tsica̱ tsihin ra Jesús. Tan ndasɨ vaha yuvehe nu yucú ra naha tsa cuenda tsa yuuhví ra naha tsi ra cuví ityi nuu tsihin nyɨvɨ Israel. Tan ra Jesús quituvi̱ ra tan tsinyaa̱ nyityi ra mahñu ra naha. Tan tsaha̱ ra nacumi tsi ra naha, tan catyí ra: ―Na coo tsa taxin añima ndo ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tsa yaha̱ tsa caha̱n ra yacan tan janaha̱ ra ndaha ra tan xiin ra tsi ra naha. Tan ra ican naha ra sɨɨ xaan cuñí ra naha tsa nyehe̱ ra naha tsi Jutu Mañi yo. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tan catyí nyico ra Jesús inga tsaha tsihin ra naha: ―Na coo tsa taxin añima ndo. Tumaa tsa tava̱ Jutu yu tyiñu tsi yu, tacan tavá nyico tucu yuhu tyiñu tsi nyooho ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tacan tan tɨvɨ̱ ra tsi ra naha tan catyí ra tsihin ra naha: ―Na̱quihin ndo Tatyi Ii Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nyɨvɨ tsa jahá ndo tucahnu iñi, iyó tucahnu iñi tsi ñi. Tan nyɨvɨ tsa ña jahá ndo tucahnu iñi, nduve tucahnu iñi iyó tsi ñi ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Maa tyin ra Tomás, iin rq tsica̱ tsihin ra Jesús, ra tsa catyí ñi: “ra tɨnɨhɨ”, yoñi ra nyií tsihin ra naha tsa tsaha̱n ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yaha̱ can tan nacatyi̱ tuhun ra tsica̱ tsihin ra Jesús tsihin ra: ―Nyehe̱ ndi tsi Jutu Mañi yo ―catyí ra naha tsihin ra. Maa tyin ra Tomás catyí ra: ―Tun ña nyehe yu ndaha ra nu caahví nu quɨhvɨ nduyu, tan ña cuaxin yu nundaha yu nu yɨhɨ̱ nduyu can, tan ña cuaxin yu ndaha yu yɨquɨ naha ra, ña cua tsinu iñi yu ―catyí ra Tomás. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tsa yaha̱ una quɨvɨ yucú nyico ra tsica̱ tsihin ra Jesús tsitsi iin vehe. Tan nyií ra Tomás tsihin ra naha. Tacan tan vasu ndi maa ndasɨ vaha yuvehe, maa tyin ra Jesús quɨhvɨ̱ ra tan tsinyaa̱ nyityi ra mahñu ra naha. Tan tsaha̱ ra nacumi tsi ra naha tan catyí ra: ―Na coo tsa taxin añima ndo. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tacan tan quitsaha̱ catyí ra tsihin ra Tomás: ―Cu̱axin nundaha un nu caahví ndaha yu ihya. Tan cu̱axin ndaha un yɨquɨ naha yu. Tan ña cuvi un ra ndava iñi. Tsi̱nu iñi ―catyí ra Jesús tsihin ra Tomás. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tacan tan nacaha̱n ra Tomás tan catyí ra: ―¡Jutu Mañi yu! ¡Tan Nyoo yu! ―catyí ra Tomás. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tan catyí ra Jesús tsihin ra: ―Yooho Tomás, vityin tsinú iñi un tyin nyehé un tsi yu. Sɨɨ ca cuñí nyɨvɨ tsa nduve tsa nyehe̱ tan tsinú iñi ñi ―catyí ra Jesús tsihin ra Tomás. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Cuaha ca tsa iyo javaha̱ ra Jesús nuu ra tsica̱ tsihin ra, maa tyin ña tandɨhɨ tsi nyaá nu libru ihya. ");
INSERT INTO mjcNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tsinyaa̱ tsa nyaá tyin tacan tan tsinu iñi ndo tyin ra Jesús cuví ra Cristo, ra cuví Sehe Nyoo, tan coo ndo ñayɨvɨ nyitó tsa ña cua naa maa. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tsa yaha̱ can tan quituvi̱ ra Jesús nuu ra tsica̱ tsihin ra inga tsaha. Tyehen quituvi̱ ra yatyin ñi yuhu miñi Tiberias: ");
INSERT INTO mjcNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Iin ñi nu yucú ra Simón Pedro tan ra Tomás tsa nañí: “ra tɨnɨhɨ”, tan ra Natanael, ra ñuu Caná nu cuví Galilea. Tan yucú ndɨhɨ sehe ra Zebedeo naha ra tan uvi taahan ca ra tsica̱ tsihin ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tan catyí ra Simón Pedro tsihin ra naha: ―Cuahan yu cua tɨɨn yu tyaca ―catyí ra. Tan catyí ra naha tsihin ra: ―Cuhun ndɨhɨ ndi tsihin un ―catyí ra naha. Cuahán ra naha tan quɨhvɨ̱ ra naha tsitsi iin yutun ndoo, maa tyin tsacuaa can ndi intuhun maa tyaca ña ñihi̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tsa cuñi cunditsin tan quituvi̱ ra Jesús nu nyɨtɨ yuhu miñi can. Maa tyin ra tsica̱ tsihin ra, ña nacoto̱ ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tacan tan catyí ra tsihin ra naha: ―Nyooho ra cuatyi, ¿a ñaha ca ñihi ndo tyaca? Tan nacaha̱n ra naha tan catyí ra naha: ―Ñaha ca ñihi ndi. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tacan tan nacaha̱n ra Jesús tan catyí ra: ―Cu̱axin ndo traya ndo tsiyo cuaha yutun ndoo juvin, tan cua ñihi ndo tyaca ―catyí ra Jesús tsihin ra naha. Tacan ica̱ ra naha. Yaha can tan ndacua ña cuvi̱ ca tava ra naha traya can nu ndutya, tsa cuenda tsa cuaha tyaca yɨhɨ́ tsitsi can. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tan ra tsa cuñí xaan ra Jesús catyí ra tsihin ra Pedro: ―¡Jutu Mañi yo cuví ra! ―catyí ra tsihin ra Pedro. Tsa tsiñi̱ ra Simón Pedro tyin Jutu Mañi yo cuví ra, tsinditsi̱ ra jahma ra, tyin tava̱ ra can tsa cua tɨɨn ra tyaca, tan quɨhvɨ ra cuahán ra tsitsi ndutya can. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tan inga ra tsa tsica̱ tsihin ra Jesús tsaa̱ ra naha nda yuhu miñi can tsihin yutun ndoo, ixtá ra naha traya can tyin tsitu cuii can tsihin tyaca, tyin yatyin ñi yuhu miñi can yucu ra naha tumaa iin cientu metru ñi. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tsa nuu̱ ra naha nu ñuhu, nyehe̱ ra naha iin nu cayú tuun ñuhu̱. Tan canyií iin tyaca tsihin paan nuu tuun ñuhu̱ can. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tan catyí ra Jesús tsihin ra naha: ―Nda̱ca ndo taahan tyaca tsa ndi tɨɨ̱n ndo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tan ndaa̱ ra Simón Pedro nu yutun ndoo tan quitsaha̱ ixtá caa ra traya tyin tsitu cuii can yɨhɨ́ tyaca nahnu. Cientu uvi xico utsi uñi tɨ yɨhɨ́ tsitsi can. Tan vasu cuaha xaan tɨ, maa tyin ña tanɨ̱ traya can. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tacan tan catyí ra Jesús tsihin ra naha: ―Na̱ha ndo tyin curumusa ndo ―catyí ra Jesús tsihin ra naha. Tan ndi intuhun ra tsica̱ tsihin ra, ña cana̱ iñi ra naha ndaca tuhun ra naha yóo ra cuví ra tyin tsitó ra naha tyin Jutu Mañi yo cuví ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tacan tan natuhva̱ ra Jesús tan quihi̱n ra paan can, tan tsaha̱ ra tsi ra naha. Tan juvin ñi tacan ica̱ ra tsihin tyaca. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yacan cuví nu tsinu uñi tsaha quituvi̱ ra Jesús nuu ra tsica̱ tsihin ra tsa yaha̱ nandoto̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tsa yaha̱ tsa curumusa ra Jesús, tan tsica̱ tuhun ra tsi ra Simón Pedro: ―Simón, sehe ra Jonás, ¿a cuñí ca un tsi yu tan ñavin ca ra ihya naha ra? Nacaha̱n ra Pedro tan catyí ra: ―Tacan Jutu Mañi yu, maa un tsitó tyin cuñí yu tsi un ―catyí ra Pedro. Tan catyí ra Jesús tsihin ra: ―Cu̱hva tsa catsi mbee nyihi jana yu ―catyí ra Jesús tsihin ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tsica̱ tuhun nyico ra Jesús tsi ra inga tsaha: ―Simón sehe ra Jonás, ¿a cuñí un tsi yu? ―catyí ra Jesús tsihin ra. Nacaha̱n ra Pedro tan catyí ra: ―Jutu Mañi yu, maa un tsitó tyin cuñí yu tsi un ―catyí ra Pedro tsihin ra. Tan catyí ra tsihin ra: ―Ja̱ha cuenda mbee jana yu ―catyí ra Jesús tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tan tsinu uñi tsaha tsica̱ tuhun nyico ra tsi ra: ―Simón, sehe ra Jonás, ¿a cuñí un tsi yu? ―catyí ra Jesús tsihin ra. Cuhva tsa tsica̱ tuhun ra tsi ra tsa tsinu uñi tsaha tatun cuñí ra tsi ra, ra Pedro nducuiihya xaan cuñí ra, tan catyí ra tsihin ra: ―Jutu Mañi yu, maa un tsitó nácaa añima yu tan maa un tsitó tyin cuñí yu tsi un ―catyí ra. Tan catyí ra Jesús tsihin ra: ―Ja̱ha cuenda mbee jana yu. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tsa nditsa caahán yu tsihin un tyin tsa ndi tyuvaa un tsinditsi̱ maa un jahma un tan cuahán maa un nu cuñí un cuhun un. Maa tyin tatun tsa tsahnu un, cua janacaa un ndaha un tan inga ra cua jacunditsi jahma un tsi un. Tan cua cundaca ra tsi un nu ña cuñí un cuhun un ―catyí ra Jesús tsihin ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tsa caha̱n ra Jesús yacan, cuñí ra cahan ra nácaa cua cúu ra Pedro tan cua jacahnu ra tsi Nyoo tacan. Yaha̱ can tan catyí ra Jesús tsihin ra Pedro: ―¡Na̱ha qu̱itsi nyicun un tsi yu! ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tacan tan natsico̱ coo ra Pedro tan nyehe̱ ra tyin nyicún inga ra tsa tsica̱ tsihin ra Jesús tsi ra naha, ra tsa cuñí xaan ra Jesús. Juvin ra tsinyanaa̱ tsi ra Jesús tsa cuxiñi̱ ra quɨvɨ can. Tan tsica̱ tuhun ra tsi ra tan catyí ra: “Jutu Mañi yu, ¿yóo ra cua xico tsi un?” catyi̱ ra, tsica̱ tuhun ra quɨvɨ tsa ndi cumañi ca cúu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cuhva tsa nyehe̱ ra Pedro tsi ra, tsica̱ tuhun ra tsi ra Jesús: ―Jutu Mañi yu, tan ra ihya, ¿náa cua tahan ra? ―catyí ra tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nacaha̱n ra Jesús tan catyí ra: ―Tatun cuñí maa yu tsa coo ra nda cuanda quitsi yu inga tsaha, ¿náa cuenda yooho? Co̱hon yooho tsihin yu ―catyi ra Jesús tsihin ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tacan tan iin yaha ñi tsinu̱ tuhun ihya nu nyecú yañi yo tyin ra ican, ña cua cúu ra. Maa tyin ña catyi̱ ra Jesús tsa ña cua cúu ra can. Tyin catyí ra: “Tatun cuñí yuhu tsa coo ra nda cuanda quitsi yu inga tsaha, ¿náa cuenda yooho?” ");
INSERT INTO mjcNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yuhu cuví ra can, ra tsa caha̱n ra Jesús tuhun. Tan nyehe̱ yu tandɨhɨ cuii maa tsa cuvi̱ tan tyaa̱ yu nu libru ihya. Yuhu tsitó yu tyin tandɨhɨ tsa tyaa̱ yu, tsa nditsa caahán tsi. ");
INSERT INTO mjcNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iyó cuaha ca tsa javaha̱ ra Jesús. Tun tsatyin tsicunyaa̱ tandɨhɨ can nu libru, tsicá iñi yu tyin ndi ña cua cutahan can nanɨɨ cahnu nu ñuhu ñayɨvɨ. Tan na cuvi tsi tacan ñi.");
INSERT INTO mjcNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yooho Teófilo, quɨvɨ tsa jacuhu̱n yu tutu tsa jihna ñi can tsi un, tyaa̱ yu tandɨhɨ tsa quitsaha̱ javahá ra Jesús tan tandɨhɨ tsa jacuaha̱ ra nda quɨvɨ jihna ñi, ");
INSERT INTO mjcNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tan nda quɨvɨ nandaa̱ ra andɨvɨ. Tan tsa ndi cumañi ca nandaa ra andɨvɨ, nacatsi̱ ra tsi ra apóstol cuenda ra. Tan tsihin tunyee iñi Tatyi Ii Nyoo tava̱ tyiñu ra tsi ra naha tyin caca ra naha tyiñu ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tan cuaha xaan tundoho nyehe̱ ra Jesús tan tsihi̱ ra. Tan tsa yaha̱ tsa tsihi̱ ra, nandoto̱ ra tan quituvi̱ ra nu yucú ra tsa tava̱ tyiñu ra. Tan tsitsi tsa uvi xico quɨvɨ, cuaha xaan tsaha quituvi̱ ra nu yucú ra naha, tyin na coto ra naha tyin nditsa tsa nyito ra. Tan caha̱n ra Jesús tsihin ra naha nácaa ndacá ñaha Nyoo tsi yo. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tsa ndi nyií ra Jesús tsihin ra naha, tan catyí ra tsihin ra naha: ―Ña cua quita ndo Jerusalén ihya, nda cuanda naquihin ndo tsa catyi̱ Jutu yu tyin cuhva ra tsi ndo, tumaa tsa caha̱n yu tsihin ndo quɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nditsa tyin tsihin ndutya jacoondutya̱ ra Juan tsi nyɨvɨ. Maa tyin nyooho ña cuaha ca quɨvɨ tan coondutya ndo tsihin Tatyi Ii Nyoo ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tsa ndu ii̱n ra tava̱ tyiñu ra Jesús, tan tsica̱ tuhun ra naha tsi ra tan catyí ra naha: ―Jutu Mañi yu, ¿a vityin ñi cua jacacu un tsi ñuu Israel ihya tsa ña cua cundaca ñaha ca ra ñuu Roma tsi yo? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tan nacaha̱n ra Jesús tan catyí ra tsihin ra naha: ―Ña taahán tsi coto nyooho ndáa quɨvɨ cua cuvi tsa cua javaha Nyoo Jutu yo. Intuhun ñi maa ra cua cahan ama cua cuvi tsi. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tyin quɨvɨ tsa cua quitsi Tatyi Ii Nyoo sɨquɨ ndo cua naquihin ndo tunyee iñi ra, tan cua quita ndo tan cua cahan ndo tuhun yu ñuu Jerusalén ihya tan tandɨhɨ ñuu tsa cayucú Judea tan Samaria, tan nda cuanda nanɨɨ cahnu ñuhu ñayɨvɨ ―catyí ra Jesús tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tan tsa yaha̱ tsa caha̱n ra Jesús tuhun ihya, tan tsitsi tsa nyehé ra naha tsi ra, nandaa̱ ra andɨvɨ, tan quɨhvɨ̱ ra tsitsi vico. Tacan tan ña nyehe̱ ca ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tan cuhva tsa nyehé ndaá ra naha andɨvɨ, quituvi̱ uvi taahan ángel Nyoo tsa nditsí jahma cuitsin yatyin ñi nu nyecú ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tan catyí ángel can naha ra tsihin ra tava̱ tyiñu ra Jesús: ―Nyooho ra Galilea, ¿nacuenda nyehé ndaa xaan ndo andɨvɨ? Ra Jesús tsa nyehe̱ ndo nandaa̱ ihya, juvin ra cua quitsi inga tsaha, tan tyehen cua nyehe nyico ndo tsi ra ―catyí ángel tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tacan tan quita̱ ra tava̱ tyiñu ra Jesús nu tsiyucu̱ ra naha yucu nu iyó yutun olivo. Tan cuanuhu̱ ra naha ñuu Jerusalén. Tan yatyin ñi canyií ñuu can, tumaa sava hora ñi tan tsaa yo. Tyin sava hora ñi cuví caca nyɨvɨ quɨvɨ quitatú ñi, tyin tacan catyí maa ley tsa tyaa̱ ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tsa tsaa̱ ra naha ñuu Jerusalén can, ndaa̱ ra naha nu tsinu uvi pisu vehe nu iyó ra naha. Tan ra tsa yucú can, cuví ra ihya naha ra: ra Pedro, ra Jacobo, ra Juan, ra Andrés, ra Felipe, ra Tomás, ra Bartolomé, ra Mateo, ra Jacobo sehe ra Alfeo, tan ra Simón ra tsa cuñí tsa nasama ra ndacá ñaha, tan tsihin ra Judas yañi ra Jacobo. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tan tandɨhɨ ra ican naha ra ndu iín ra naha tandɨhɨ quɨvɨ tan tsicán tahvi ra naha tsi Nyoo. Tan yucú ndɨhɨ tucu yañi ra Jesús tsihin ra naha, tan tsihin ña María sɨhɨ ra, tan cuaha ca maa ñiñaha. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tan tsa tandɨhɨ nyɨvɨ tsa ndu iín quɨvɨ can quitá maa cientu oco ñi. Tacan tan nduvita̱ ra Pedro. Tan catyí ra tsihin ñi: ");
INSERT INTO mjcNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nyooho yañi, tsa nyaá tucu maa tsa taha̱n ra Jesús cuhva ihya tan vityin tsa cundaa̱ tsa caha̱n ra David jaha̱ Tatyi Ii Nyoo nu catyi̱ ra tyin ra Judas cua cuhva cuenda ra tsi ra Jesús tsi ra xaan iñi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tan ra Judas cuví ra iin ra tsa tsinyii̱ tsihin yo. Tan iin caa ñi jaha̱ tyiñu ra tsihin yo. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Maa tyin tsaha̱n ra, tan jata̱ ra ñuhu tsihin xuhun tsa ñihi̱ ra tsa xico̱ ra tsi ra Jesús. Yaha̱ can tan canacava̱ ra tsihin jiñi ra, tan ndata̱ tsitsi ra tan quita̱ tandɨhɨ tsɨtɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tan quɨvɨ tsa tsito̱ nyɨvɨ iyó Jerusalén ihya tsa tsihi̱ ra, jacunañi̱ ñi ñuhu can Acéldama. Tan tsa tsihin yuhu maa ñi cuñí tsi catyí Ñuhu cuenda tsa Tsatɨ̱ Nɨñɨ Nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tyin nu libru Salmo catyí tsi cuenda ra Judas tyehen: Na ndoo maa vehe ra. Tan ña coo nyɨvɨ tsitsi vehe can. Tan catyí tucu tsi: Inga ra cua jaha tyiñu tyiñu tsa javaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Tan vityin yucú ra tsa cutaha̱n tsihin yo quɨvɨ tsinyii̱ Jutu Mañi yo Jesucristo tsihin yo; nda quɨvɨ jacoondutya̱ ra Juan tsi ra, tan nda quɨvɨ nandaa̱ ra cuahán ra andɨvɨ. Tan vityin ñiñi cuñí tsi tsi inga ra cuvi tsandaa tsihin yo tsa cuenda tsa nandoto̱ ra Cristo ―catyí ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tacan tan cana̱ ra naha tsi uvi taahan ra naha. Cana̱ ra naha tsi ra José tsa nañí Barsabás, tan juvin ñi nañí tucu ra Justo; tan cana̱ tucu ra naha tsi ra Matías. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tan tsica̱n tahvi ra naha tsi Nyoo tan catyí ra naha tyehen: ―Jutu Mañi yu, yooho tsitó un tsa tsicá iñi ndi tsihin añima ndi. Ja̱naha tsi ndi tsitsi tsa uvi taahan ra ihya naha ra, ndáa ra tsa nacatsi̱ maa un, ");
INSERT INTO mjcNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tyin cuiso ra tyiñu tsa jacunaa̱ ra Judas tsa cuenda cuatyi ra, tan cuahán ra nu taahán maa tsi cuhun ra ―catyí ra naha, tsica̱n tahvi ra naha tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tacan tan tava̱ cuenda ra naha ndáa ra cua tahan tsi cuiso tyiñu can. Tan taha̱n tsi tsi ra Matías. Ra ican cuví ra taha̱n tsi cutahan tsihin tsa utsi iin ra tsa tava̱ tyiñu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tsaa̱ quɨvɨ vico Pentecostés, tan ndu ii̱n tandɨhɨ nyɨvɨ tsa tsinú iñi tsi ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tan sana iñi ñi tan tsiñi̱ ñi cucayu ityi andɨvɨ. Tumaa cucayu tsa vatsí tatyi xaan. Tan iyo xaan cuví tsitsi vehe nu yucú ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tacan tan quituvi̱ tumaa iin ñuhu̱ tan tsaa̱ tsi sɨquɨ intuhun intuhun ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tan tandɨhɨ ñi tsitu̱ ñi tsihin Tatyi Ii Nyoo. Tan quitsaha̱ caahán ñi inga yuhu cuhva tsa jacaha̱n maa Tatyi Ii Nyoo tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tan quɨvɨ can cuaha xaan ra ñuu Israel tsaa̱ ra naha ñuu Jersualén. Ra vaha tsicá tsihin Nyoo cuví ra naha. Quee̱ ra naha tandɨhɨ ñuu tsa cayucú nu ñuhu ñayɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tan tsa tsiñi̱ ra can naha ra tsa iyo xaan cuví nu yucú nyɨvɨ cuenda ra Cristo, tan cuahán ra naha tan ndu ii̱n ra naha tsihin ñi. Tan ña tsitó ra naha náa tsa caca iñi ra naha, tyin intuhun intuhun ra naha tsiñí ra yuhu ra naha tsa caahán ñi jahá Tatyi Ii Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iyo xaan cuñí ra naha tan quitsaha̱ natuhún tahan ra naha tan catyí ra naha: ―¿A ñavin nyɨvɨ ñuhu Galilea cuví tandɨhɨ ñi tsa caahán ihya? ");
INSERT INTO mjcNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nacuenda tyin tsiñí yo caahán ñi cuhva caahán intuhun intuhun yo? ");
INSERT INTO mjcNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ihya yucú yo tsa cuví yo nyɨvɨ quee̱ Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO mjcNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto, tan nyɨvɨ quee̱ ityi nuu ca Cirene ityi Africa. Tan yucú tucu yo tsa cuví yo nyɨvɨ ñuu Roma tan iyó yo ñuu ihya. Tan juhva yo cuví yo nyɨvɨ Israel nda quɨvɨ cacu̱ yo. Tan inga yo cuví yo nyɨvɨ nanduvi̱ cuenda nyɨvɨ Israel tan nyicún yo ley tsa tyaa̱ ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Iyó tucu yo tsa cuví yo nyɨvɨ quee̱ Creta tan Arabia. Maa tyin tandɨhɨ yo tan tsiñí yo tyin tsihin yuhu tsa caahán maa yo caahán ñi. Tan nacatyí tuhun ñi tsa cahnu tsa javahá Nyoo ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tandɨhɨ ra naha, iyo xaan cuñí ra naha, tan tsicá tuhun tahan ra naha tan catyí ra naha: ―¿Náa cuñí tsi catyi tandɨhɨ tsa cuví ihya? ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Maa tyin inga ra jacuñí nyaa ra naha tsi ñi, tan catyí ra naha tyin tsiñí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tacan tan nduvita̱ ra Pedro tsihin tsa utsi iin ca ra tava̱ tyiñu ra Jesús. Tan ñihi caha̱n ra tan catyí ra: ―Nyooho yañi, tsa cuví ndo ra ñuu Israel, tan tandɨhɨ nyooho tsa iyó ñuu Jerusalén ihya. Cuñí tsi tsa coto ndo tuhun ihya. Tan tya̱a soho vaha ndo tsa cua cahan yu tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tyin cuñí maa ndo tyin tsiñí ndi. Maa tyin ñavin nyixi tsihi̱ ndi, tyin ña tuhvá nyɨvɨ coho nyixi hora ihya, tyin ndi jatyaan. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Maa tyin tsa cuví ihya cuví tsa caha̱n ra Joel, ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Tyin catyi̱ ra: ");
INSERT INTO mjcNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nu cua ndɨhɨ quɨvɨ, catyí Nyoo, cua jaquitsi yu Tatyi Ii yu sɨquɨ tandɨhɨ nyɨvɨ. Tan cua cahan sehe ndo tsa cuenda yu. Tan ra cuatyi tan ñi cuatyi cua janaha yu tsa iyo tsi ñi. Tan nyɨvɨ tsahnu cua nyehe ñi ñumaahna jaha yu. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Cua jacuhun yu Tatyi Ii yu sɨquɨ ñi tsa jaha tyiñu tsa cuenda yu. Tan cua cahan ñi tsa cuenda yu, catyí Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tan catyi̱ ra tyin cua janaha ra tsa iyo cua nyehe nyɨvɨ ityi andɨvɨ. Tan ityi nu ñuhu ñayɨvɨ cua javaha ra tsa iyo, seña nɨñɨ, seña ñuhu̱, tan vico yuhma. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tan ñicanyii cua ndunaa tsi. Tan yoo cua nducuaaha tsi tumaa cuaaha nɨñɨ. Tandɨhɨ tuhun caahán ra ihya cua cuvi tsi tsa ndi cumañi ca tahan tsi quɨvɨ quitsi Jutu Mañi yo. Tan quɨvɨ cua quitsi ra, iyo xaan cua cuvi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tan tandɨhɨ nyɨvɨ tsa tsicán tahvi tsi ra cua cacu ñi, catyi̱ ra Joel jaha̱ Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tsa yaha nacatyi̱ tuhun ra Pedro yacan, tacan tan catyí ra tsihin ra naha: ―Nyooho ra Israel, tya̱a soho ndo tsa cua cahan yu ihya. Ra Jesús, ra ñuu Nazaret, maa Nyoo nacatsi̱ tsi ra, tan tsa janaha̱ Nyoo tsi yo tyin nditsa tsa nacatsi̱ ra tsi ra, tsaha̱ ra tunyee iñi tsi ra tan cuaha xaan tsa iyo tan tsa nyityi tan seña javaha̱ ra. Tan tsa tsitó maa ndo tandɨhɨ tsa caahán yu ihya. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Maa tyin quɨvɨ nacuhva̱ cuenda ndo tsi ra, javaha̱ ndo tumaa cuhva tyaa̱ maa Nyoo cuhva nda quɨvɨ jihna ñi. Tyin tsaha̱ cuenda ndo tsi ra tsi ra caquiñi. Tan ticaa̱ ra naha tsi ra nu cruu. Tsahñi̱ ra naha tsi ra jaha̱ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Maa tyin Nyoo janandoto̱ ra tsi ra. Jacacu̱ ra tsi ra tyin ña cuvi cundaca ñaha tuhun tsiihi tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tyin ra David caha̱n ra tuhun cahan ra Cristo taha̱n tsanaha, tan catyí ra: Tacan ñi nyehé yu tsi Nyoo Jutu yu ityi nuu yu. Maa ra nyaá ra ityi xiin cuaha yu tan nduve náa cuví jayuhvi tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yacan cuenda sɨɨ xaan cuñí yu. Tan jacahnú yu tsi Nyoo tsihin tsa sɨɨ cuñí yu. Tan cuñu ñuhu yu cua quitatu tsi tyin tsitó yu tyin cua nandoto yu inga tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tyin yooho, Nyoo Jutu yu, ña cua nacoo ihñi un añima yu nu yucú añima nyɨvɨ tsa tsihi̱, tan ndi ña cua cuhva un tsa tyahyu cuñu ñuhu yu. Tyin sehe ii maa un cuví tsi yu. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tan janaha̱ un tsi yu ityi nu coo yu ñayɨvɨ ña cua naa maa. Tan cua jacutu un tsi yu tsihin tusɨɨ iñi tyin maa un nyaá tsihin yu, catyí ra David caha̱n ra tsa caha̱n ra Cristo taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Nyooho yañi, tsitó vaha yo tyin ra David tsii tsaahnu yo tsihi̱ ra tan quɨhvɨ̱ ra tsitsi ñuhu. Tan ñaña ra ndi nyaá tsi ihya vityin. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Maa tyin ra David cuvi̱ ra iin ndusu yuhu Nyoo. Tan tsitó ra tyin Nyoo catyi̱ ra tyin juvin ñi tata maa ra cua cuvi ra Cristo. Tan ra Cristo, cuví ra cua cundaca ñaha tumaa tsa tsindaca̱ ñaha ra David. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tan ra David tumaa tsa tyin nyehe̱ ra tsa cua cuvi nu cuahán ca tsi ityi nuu. Tan caha̱n ra tuhun tsa caha̱n ra Cristo. Tan catyi̱ ra tyin ña cua ndoo añima ra nu yucú añima nyɨvɨ tsa tsihi̱. Tan ndi ña cua tyahyu cuñu ñuhu ra, catyi̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tan ra Jesús can janandoto̱ Nyoo tsi ra. Tan tandɨhɨ maa ndi cuví ndi tsandaa tsa cuenda tsa nandoto̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jutu Nyoo jacahnu̱ ra tsi ra Jesús, tan tsihin ndaha cuaha ra cañihi̱ ra tsi ra nda gloria. Tan ra Jesús naquihi̱n cuenda ra Tatyi Ii tsa catyi̱ Jutu yo Nyoo taha̱n tsanaha tyin cuhva ra tsi yo. Tan yacan cuví tsa tsaha̱ ra tsi ndi vityin. Juvin tsi cuví tsa nyehé ndo tan tsiñí ndo. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tyin ñavin ra David nandaa̱ ityi andɨvɨ. Maa tyin maa ra David caha̱n ra tuhun ra Jesús, tan catyí ra: Jutu Mañi yo Nyoo catyí ra tsihin Jutu Mañi yu ra Cristo: “Cu̱nyaa xiin cuaha yu ");
INSERT INTO mjcNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tsitsi tsa cua caquin yu tsi ra xaan iñi tsi un tsaha un”, catyi̱ ra David jaha̱ Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tacan caha̱n ra Pedro tsihin ra naha, tan catyí tucu ra: ―Nyooho tan tandɨhɨ ca nyɨvɨ Israel, co̱to vaha ndo tyin tuhun ra Jesús, yacan cuví tsa caahán yu tsihin ndo ihya. Ticaa̱ ndo tsi ra nu cruu. Maa tyin cuví ra Jutu Mañi yo, tan cuví tucu ra Cristo ra ndacá ñaha tsi yo jaha̱ Nyoo ―catyí ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cuhva tsa tsiñi̱ ra naha tsa caha̱n ra Pedro tuhun ihya, cuiihya xaan cuñí ra naha cuvi̱. Tan tsica̱ tuhun ra naha tsi ra Pedro tan tsi tandɨhɨ ca ra tava̱ tyiñu ra Jesús, tan catyí ra naha: ―Yañi, ¿nácaa javaha ndi vityin? ―catyí ra naha tsihin ra tava̱ tyiñu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tacan tan catyí ra Pedro tsihin ra naha: ―Intuhun intuhun ndo ndu̱ uvi iñi ndo cuatyi ndo tan na̱sama ndo cuhva iyó ndo. Tan co̱ondutya ndo tsihin sɨvɨ ra Jesucristo. Tan cua jaha ra tucahnu iñi cuatyi ndo. Tacan tan cua cuhva Nyoo Tatyi Ii ra tsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tyin taha̱n tsanaha catyi̱ Nyoo tyin cuhva ra Tatyi Ii ra tsi yo, tan tsi sehe yo, tan tsi nyɨvɨ tsa cañi iyó. Tyin tandɨhɨ nyɨvɨ tsa cua nacana Jutu Nyoo cua cuhva ra Tatyi Ii ra tsi ñi ―catyí ra Pedro. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tsihin tuhun ihya tan tsihin inga ca tuhun, ra Pedro tsaha̱ cuenda ra tsi ra naha tan catyí ra tsihin ra naha: ―Ndu̱cu ndo cuhva na jacacu Nyoo tsi ndo, coto cunaa ndo tsihin nyɨvɨ caquiñi iyó nu ñuhu ñayɨvɨ ihya ―catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tacan tan tandɨhɨ ra tsa tyaa̱ yahvi tuhun caha̱n ra Pedro tsicoondutya̱ ra naha. Tan quitá tumaa uñi mil nyɨvɨ tsa tandɨhɨ ñi, tan ndu ii̱n ñi tsihin nyɨvɨ yɨhɨ́ cuenda ra Jesucristo. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tan tandɨhɨ quɨvɨ ndu iín tandɨhɨ ñi, tan nɨɨ iñi ñi tyaá soho ñi tsa jacuahá tandɨhɨ ra tava̱ tyiñu ra Jesucristo tsi ñi. Tan iin ñi cuví ñi tsihin tahan ñi, tan tsicán tahvi ñi tan tsatsí ñi paan tan tsihí ñi vinu tyin tacan tan ña cua naa iñi ñi tyin tsihi̱ ra Cristo tsa cuenda cuatyi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tan cuaha tsa iyo javaha̱ tandɨhɨ ra tsa tava̱ tyiñu ra Jesucristo jaha̱ Nyoo. Tan tandɨhɨ ñi iyo cuñí ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tandɨhɨ ñi yɨhɨ́ cuenda ra Cristo iin caa ñi iyó ñi tsihin tsa iyó tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Xicó ñi tsa iyó tsi ñi. Tan tsatsá ñi xuhun ñi tsi nyɨvɨ tahan ñi cuhva tsa tsiñí ñuhu tsi intuhun intuhun ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tandɨhɨ quɨvɨ tan ndu iín ñi nda vehe ñuhu cahnu. Tan nda yuvehe ñi iin caa ñi tsatsí ñi paan tan tsihí ñi vinu. Tan sɨɨ cuñí ñi tsatsí ñi tyin iin ñi cuví ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tan jacahnú ñi tsi Nyoo. Tan vaha caahán tandɨhɨ nyɨvɨ tuhun ñi. Tan iin tan iin quɨvɨ tan nducuahá ca nyɨvɨ quɨhvɨ́ cuenda Jutu Mañi yo Jesús tyin jacacú ra tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Iin quɨvɨ cuahán ra Pedro tsihin ra Juan vehe ñuhu cahnu. Cuví tsi cuhva caa uñi tsa tseñi, cuhva tsa tuhvá nyɨvɨ Israel cuahán cuandacán tahvi tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tan iin ra ndaahvi, coxo ra nda quɨvɨ cacu̱ ra, nyaá ra yuhu cora vehe ñuhu cahnu can tandɨhɨ maa quɨvɨ. Tyin tsindacá ñi tsi ra na ndacan ra xuhun tsi nyɨvɨ quɨhvɨ́ yuhu cora can, tan nañí tsi Yuhu Cora Sɨɨ Caá. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tacan tan nyehe̱ ra coxo can tsi ra Pedro tsihin ra Juan tsa cua quɨhvɨ ra naha yuhu cora can. Tan tsica̱n ra xuhun tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tan nyehe̱ ra Pedro tan ra Juan tsi ra. Tan ra Pedro catyí ra tsihin ra: ―Nye̱he tsi ndi ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tacan tan quitsaha̱ nyehé ra coxo can tsi ra naha. Cuñí maa ra tyin iyó tsa cua cuhva ra naha tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Maa tyin ra Pedro catyí ra tsihin ra: ―Nduve xuhun cuitsin tan xuhun cuaan iyó tsi yu, tan cuhva yu tsi un. Maa tyin tsa iyó tsi yu cua cuhva yu tsi un. Tsihin sɨvɨ ra Jesucristo ra ñuu Nazaret, ndu̱vita tan ca̱ca ―catyí ra Pedro tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tacan tan tɨɨ̱n ra Pedro ndaha cuaha ra tan cañihi̱ ra tsi ra. Tan juvin ñi cuhva can nacoo̱ tunyee iñi nduvi taahan tsaha ra tan jucun tsaha ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tacan tan ra coxo can ndava̱ ra, tan nduvita̱ ra tsinyaa̱ nyityi ra. Tan quitsaha̱ tsicá ra. Tan quɨhvɨ̱ ra tsihin ra naha tsitsi cora vehe ñuhu can, tsicá ra, tan ndavá ra, jacahnú ra tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tandɨhɨ nyɨvɨ nyehe̱ ñi tsi ra tyin tsicá ra tan jacahnú ra tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tan iyo xaan cuñí ñi tan yuuhví ñi tsa cuenda tsa nduvaha̱ ra can. Tyin nacotó ñi tsi ra. Tyin juvin ra cuví ra tsa tuhvá tsinyaá Yuhu Cora Sɨɨ Caá can tsicán ra xuhun tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ra coxo tsa nduvaha̱ can, ña jañá maa ra tsi ra Pedro tan ra Juan. Tan tandɨhɨ nyɨvɨ iyo cuñí ñi, tan tsinú xaan ñi tsaa̱ ñi nu cuví corredor cuenda ra Salomón tyin cua nyehe ñi tsi ra coxo can tyin tsa nduvaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tsa nyehe̱ ra Pedro yacan, tan catyí ra tsihin nyɨvɨ can: ―Nyooho ra Israel, ¿nacuenda iyo xaan cuñí ndo? Tan ¿nacuenda nyehé xaan ndo tsi nyuhu? ¿A cuñí maa ndo tyin tsihin tunyee iñi maa ndi, a tsa cuenda tsa catsi iyó ndi nuu Nyoo, tan cuvi̱ janduvaha̱ ndi tsi ra coxo ihya? ");
INSERT INTO mjcNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ñavin maa nyuhu janduvaha̱ tsi ra. Nyoo ra cuví Nyoo tsii tsaahnu yo, ra Abraham, ra Isaac tan ra Jacob, ra ican jacahnu̱ tsi Sehe ra tan tsaha̱ ra tunyee iñi tsi ra, ra tsa tsaha̱ cuenda ndo tsi ra Pilato, ra cumí tyiñu. Tan ra Pilato cuñi̱ ra jaña ra tsi ra. Maa tyin nyooho ña tsaha̱ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Taha̱n tsi tsa ndacan ndo tsa jaña ra tsi ra vaha, tan ra ii can, maa tyin nyooho tsica̱n ndo tsa jaña ra tsi iin ra tsahñí ndɨyɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tan nyooho tsahñi̱ ndo tsi ra tsa tsahá ñayɨvɨ nyito coo yo tsihin Nyoo. Maa tyin Nyoo Jutu yo janandoto̱ ra tsi ra. Tan ña ndoo̱ ra nu yucú añima nyɨvɨ tsa tsihi̱. Tan nyuhu cuví ndi tsandaa tsa cuenda tsa nandoto̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tan juvin ra Jesús cuví ra tsa tsaha̱ tunyee iñi tsi ra coxo ihya tan nduvaha̱ tsaha ra, tyin tsinú iñi ndi tyin iyó tunyee iñi tsi ra Jesús. Yacan cuenda nduvaha̱ tsaha ra ihya, tan nacotó vaha ndo tsi ra. Tan tandɨhɨ nyooho nyehe̱ ndo tyin nduvaha̱ ra tsa cuenda tsa tsinú iñi ndi. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Tsitó yu, ―catyí ra Pedro― tyin quɨvɨ tsa tsahñi̱ ndo tsi ra Jesús, ña tsitó ndo tyin ña vaha tsa javahá ndo. Tan tacan tucu ra cuví ityi nuu tsihin ndo, ña tsitó ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Maa tyin tacan jacuvi̱ ndo tan cundaa̱ tsa caha̱n ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha, tyin catyí ra naha tyin ra Cristo cua nyehe ra tundoho. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yacan cuenda ndu̱ uvi iñi ndo cuatyi ndo, tan na̱cuhva cuenda ndo añima ndo tsi Nyoo, na ndatsi cuatyi ndo. Tacan tan sɨɨ xaan cua cuñi añima ndo jaha tunyee iñi Jutu Mañi yo. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tacan tan cua jaquitsi ra tsi ra Jesús ra cuví Cristo, na quitsi ra inga tsaha. Tyin nda quɨvɨ jihna ñi tyaa̱ Nyoo cuhva tyin quitsi ra tsa cuenda yo. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Taahán tsi tsa ndoó ra Jesucristo gloria tsa vityin nda cuanda quɨvɨ cua jandutsaa Nyoo tandɨhɨ maa tsa iyó. Tumaa cuhva catyi̱ ra cuví ndusu yuhu Nyoo taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tyin tacan catyi̱ ra Moisés tsihin tsii tsaahnu yo: “Cua jaquitsi Jutu yo Nyoo tsi ra tsa cua cahan tuhun ra. Tan juvin ñi nyɨvɨ yo cua cuvi ra. Tan cua cahan ra tuhun Nyoo tsihin ndo tumaa caahán yuhu. Tya̱a yahvi ndo tandɨhɨ tsa cua cahan ra tsihin ndo. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tyin tandɨhɨ nyɨvɨ tsa ña cua tyaa soho tsa cua cahan ra, cua cunaa ñi, tyin ña cua cutahan ñi tsihin nyɨvɨ tsa nacatsi Nyoo”, catyi̱ ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Tan tacan tucu tandɨhɨ ra cuví ndusu yuhu Nyoo nda quɨvɨ tsicoo̱ ra Samuel tan nda cuanda vityin, jacoto̱ ra naha tsa cuví vityin. ");
INSERT INTO mjcNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tandɨhɨ tsa catyí Nyoo tyin cuhva ra tsi yo, caha̱n ra cuví ndusu yuhu Nyoo taha̱n tsanaha. Tandɨhɨ can tsii maa ndo cuví can. Tan tyiñu tsa ndoo̱ Nyoo tsihin ra Abraham tsii tsaahnu yo, juvin ñi tsa cuenda maa ndo cuví yacan. Tyin catyi̱ Nyoo tsihin ra Abraham: “Tandɨhɨ nyɨvɨ tsa iyó nu ñuhu ñayɨvɨ cua nasoco yu tsi ñi tsa cuenda nyɨvɨ tata un.” ");
INSERT INTO mjcNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tan yacan cuenda quɨvɨ janandoto̱ Nyoo tsi Sehe ra, jihna ca nu yucú ndo jacuhu̱n ra tsi ra, tyin nasoco ra tsi ndo, tan intuhun intuhun ndo nacoo ndo tsa caquiñi iyó ndo ―catyí ra Pedro tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ndi caahán ca ra Pedro tan ra Juan tsihin nyɨvɨ, tan tsaa̱ ra cuví jutu naha ra tsihin ra cuví ityi nuu tsihin ra jahá cuenda vehe ñuhu, tan tsihin ra cuví saduceo naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nduxaa̱n xaan ra naha tyin ra Pedro tan ra Juan jacuahá ra naha tsi nyɨvɨ tan catyí ra naha tyin nditsa tsa cua nandoto nyɨvɨ tsa tsa tsihi̱, tyin ra Jesús nandoto̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tacan tan tɨɨ̱n ra naha tsi nduvi taahan ra tava̱ tyiñu ra Jesús can naha ra. Tan tyihi̱ ra naha tsi ra naha vehe caa. Tan ndoo̱ ra naha nda cuanda inga quɨvɨ tyin tsa cueñi cuví cuhva can. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Maa tyin cuaha ñi tsa tsiñi̱ tuhun caahán ra Pedro quitsaha̱ tsinú iñi ñi. Tan ndu ii̱n ñi tsihin nyɨvɨ yɨhɨ́ cuenda ra Jesús. Tan tsa tandɨhɨ ñi quitá maa uhun mil cuví tsa maa ñi maa rayɨɨ naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tsa tuvi inga quɨvɨ, nda ñuu Jerusalén ndu iin tandɨhɨ ra cumí tyiñu cuenda nyɨvɨ Israel, tan tsihin ra tsahnu, tan tsihin ra cuví maestro cuenda ley tsa tyaa̱ ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tan nyií tucu ra Anás ra jutu tsaahnu cuví ityi nuu. Tan nyií tucu ra Caifás, tan ra Juan, tan ra Alejandro. Tan yucú ndɨhɨ tucu tandɨhɨ rayɨɨ tsa cuví nyɨvɨ ra jutu tsaahnu cuví ityi nuu. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tacan tan tava̱ tyiñu ra naha na cuquihin ra naha tsi ra Pedro tan ra Juan. Tan tsindaca̱ ra naha tsi ra naha nda mahñu nu yucú ra naha. Tan tsica̱ tuhun ra naha tsi ra naha, tan catyí ra naha: ―¿Yóo tsaha̱ ndatu tsi ndo tsa janduvaha ndo tsi ra can? ¿Yóo tsaha̱ tunyee iñi tsi ndo tsa javaha ndo tyehen? ―catyí ra naha tsihin ra Pedro tan ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tan ra Pedro tsitú ra tsihin Tatyi Ii Nyoo. Tan nacaha̱n ra tsihin ra naha: ―Nyooho ra ndacá ñaha Israel ñuu yo ihya, tan nyooho ra tsahnu. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Vityin tsicá tuhun ndo tsi ndi tsa cuenda tsa vaha tsa cuvi̱ tsi ra coxo ihya, tyin cuñí ndo coto ndo nácaa nduvaha̱ ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yacan cuenda cua catyi tuhun ndi tsihin ndo na coto tandɨhɨ nyɨvɨ Israel. Tyin ra ihya nyaá ra nuu tandɨhɨ ndo, tyin nduvaha̱ ra tsihin tunyee iñi tsi ra Jesucristo, ra ñuu Nazaret, ra tsa tsaha̱ cuenda ndo na cúu ra nu cruu. Maa tyin Nyoo janandoto̱ ra tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tan juvin ra Jesús cuví yuu tsa tsiñí ñuhu ca tsa ña cuñí ra javahá vehe cuatyiñu ra, tumaa cuhva catyí nuu tutu Nyoo. Tan nyooho cuví ra javahá vehe tan ña cuñí ndo yuu tsa tsiñí ñuhu ca can. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yoñi inga ra cuví jacacú tsi yo. Tyin intuhun ñi maa ra tsaha̱ Nyoo tyin jacacu ra tsi yo ―catyí ra Pedro tsihin ra can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tan ra cumí tyiñu can naha ra iyo xaan cuñí ra naha tsiñí ra naha tsa caahán ra Pedro tan ra Juan tyin nɨɨ xaan iñi ra naha caahán ra naha, tan ñavin ra cahvi̱ scuela cuví ra naha. Tacan tan nacoto̱ ra naha tsi ra naha tyin ra ican naha ra cuví ra tsa tsica̱ tsihin ra Jesús quɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tan ra tsa nduvaha̱ can, nyaá nyityi ra tsihin ra naha. Yacan cuenda ña cuví cahan ra cumi tyiñu can naha ra tsa ndavaha ñi sɨquɨ ra Pedro tan ra Juan. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tacan tan catyi̱ ra cumi tyiñu naha ra tsihin ra naha: ―Qu̱ita nduñi taahan nyooho tsata vehe. Tan quita̱ ra naha. Tan ndoo̱ ra cumi tyiñu can naha ra natuhún tahan ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tan catyí ra naha: ―¿Náa javaha yo tsihin ra ihya naha ra? Tyin tandɨhɨ maa nyɨvɨ Jerusalén tsitó ñi tsa iyo tsa javaha̱ ra naha. Tan ña cua cuvi catyi yo tyin ña nditsa. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Maa tyin ña cuñí yo tsa cuaha ca nyɨvɨ coto tuhun ihya, yacan cuenda vaha ca tsa casɨ yo tsi ra naha, tan cahan yo tsihin ra naha na ña cahan ca ra naha tuhun ra Jesús tsihin nyɨvɨ ―catyí ra cumi tyiñu naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tacan tan cana̱ ra cumí tyiñu tsi ra Pedro tan ra Juan. Tan catyi̱ ra naha tsihin ra naha tyin ndi luxu ca maa tan ña cahan ca ra naha tuhun ra Jesús. Tan na ña jacuaha ca ra naha tsi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Maa tyin ra Pedro tan ra Juan nacaha̱n ra naha tan catyí ra naha: ―Tyi̱hi tuñi ndo iñi ndo tan nye̱he ndo tatun vaha ca tsa tyaa yahvi ndi tsi maa ndo o vaha ca tsa tyaa yahvi ndi tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tyin nyuhu ña cuví tsa jandɨhɨ́ ndi tsa nacatyí tuhun ndi tsa nyehe̱ ndi tan tsa tsiñi̱ ndi ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tacan tan tyasɨ̱ nyico ra cumi tyiñu naha ra tsi ra Pedro tan ra Juan. Tan jaña̱ ra naha tsi ra naha tyin ña ñihi̱ ra naha nácaa tatsi tuñi ra naha tsi ra naha. Tyin tandɨhɨ nyɨvɨ tan jacahnú ñi tsi Nyoo tsa cuenda tsa cuvi̱ can. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tyin rayɨɨ tsa nduvaha̱ can, tsa yaha̱ uvi xico cuiya ra, tan tacan cuiya taha̱n ra tundoho tan nduvaha̱ ra jaha̱ Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tan tsa quita̱ ra Pedro tan ra Juan, cuahán ra naha nu yucú nyɨvɨ yɨhɨ́ cuenda ra Jesús. Tan nacatyí tuhun ra naha tandɨhɨ tsa caha̱n ra tsahnu naha ra tan ra jutu tsa cuví ityi nuu naha ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Cuhva tsa tsiñi̱ tandɨhɨ ñi, tan iin caa ñi quitsaha̱ tsicán tahvi ñi tsi Nyoo. Tan catyí ñi: ―Jutu Mañi yu, yooho javaha̱ un andɨvɨ tan ñuhu ñayɨvɨ. Javaha̱ un ndutya ñuhu. Tan tandɨhɨ ca tsa iyó, maa un javaha̱. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tan yooho tsihin Tatyi Ii un jacaha̱n un tsi ra David taha̱n tsanaha. Tan catyí ra: ¿Nacuenda tsa nduxaán nyɨvɨ ña tsitó tsi Nyoo? ¿Nacuenda tsicá iñi ñi tuhun tsa nduve yahvi nyaá? ");
INSERT INTO mjcNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Rey naha ra tan tsihin ra tsa ndacá ñaha nu ñuhu ñayɨvɨ ihya nduvita̱ ra naha sɨquɨ un, Jutu Mañi yu, tan sɨquɨ ra Cristo, ra nyisó tyiñu maa un, catyi̱ ra David. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Jutu Mañi yu, nditsa tyin ra Herodes, tan ra Poncio Pilato ndu ii̱n ra naha ñuu Jerusalén ihya tsihin ra ñuu Roma naha ra tan tsihin ra ñuu Israel naha ra tyin cahñi ra naha tsi ra Jesús Sehe ii un, tsa nacatsi̱ vaha maa un. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tan tacan javaha̱ ra naha, tumaa cuhva tsa catyi̱ maa un taha̱n tsanaha tyin cua cuvi. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tan vityin, Jutu Mañi yu, nye̱he tyin cuñí ra naha casɨ ra naha tsi ndi. Tan cu̱hva tsa nɨɨ coo iñi ndi tyin tyiñu maa un javahá ndi, Jutu Mañi yu. Tan na ña nayuhvi̱ ndi cahan ndi tuhun maa un. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tan tsihin tunyee iñi maa un tan cua nduvaha nyɨvɨ cuuhví, tan cua nyehe ndi seña tan tsa iyo tsa cuenda tunyee iñi ra Jesús Sehe ii un ―catyí ñi, tsicán tahvi ñi tsi Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tan cuhva tsa ndɨhɨ̱ tsica̱n tahvi ñi tsi Nyoo tan taa̱n nu yucú ñi. Tan tandɨhɨ ñi tsitu̱ ñi tsihin Tatyi Ii Nyoo tan caha̱n ñi tuhun Nyoo tsihin tsa ña yuuhví ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tandɨhɨ ñi tsa tsinú iñi, iin ñi cuví ñi, tan iin ñi cuhva tsicá iñi ñi. Ndi intuhun ñi tan ña catyí ñi tyin tsa tsii maa ñi cuví tsa iyó tsi ñi, tyin tsii tandɨhɨ ñi cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tan tsihin tunyee iñi cahnu, caahán ra tava̱ tyiñu ra Jesús tuhun tsa nandoto̱ Jutu Mañi yo Jesús. Tan Nyoo nasocó xaan ra tsi tandɨhɨ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tan ndi intuhun ñi tan nduve tsa cumañí tsi ñi tyin tandɨhɨ ñi tsa iyó vehe o ñuhu ñi, xicó ñi can. Tan cua ndaca ñi xuhun can ");
INSERT INTO mjcNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tsi ra tava̱ tyiñu ra Jesús. Tan maa ra naha natsatsá xuhun can tsi intuhun intuhun nyɨvɨ cuhva tsa tsiñí ñuhu tsi ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tacan javaha̱ iin ra tsa nañi José. Ra ican cuví ra tata ra Leví. Tan cacu̱ ra ñuhu Chipre tsa canyií mahñu ndutya ñuhu. Tan ra tava̱ tyiñu ra Jesús jacunañi̱ ra naha tsi ra Bernabé. Tan sɨvɨ can cuñí tsi catyí: ra jandu iín iñi nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tan ra Bernabé can xico̱ ra ñuhu ra. Tan tsaha̱ ra xuhun can tsi ra tava̱ tyiñu ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Maa tyin iin ra tsa nañí Ananías tsihin ña Safira, ñasɨɨhɨ ra, xico̱ ñi iin ñuhu. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tan tyihi̱ xeehe ñi juhva xuhun. Tacan tan ra Ananías tsindaca̱ ra xuhun tsa ndoo̱ ña tsi ra tava̱ tyiñu ra Jesús. Tan catyí ra tyin tandɨhɨ xuhun tsa cuyahvi̱ ñuhu cuví can. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tacan tan catyí ra Pedro tsihin ra: ―Yooho Ananías, ¿nacuenda tsa tsaha̱ un tsa quɨhvɨ̱ nu ña vaha añima un? Tyin cuñí un jandavi ñaha un tsi Tatyi Ii Nyoo, tan catyí un tyin tandɨhɨ xuhun tsa cuyahvi̱ ñuhu can cuví tsehe, tan ña nditsa un tyin ndoo̱ juhva xuhun can tsi un. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tsii un cuvi̱ ñuhu can, tan tsii un cuví xuhun tsa ñihi̱ un cuenda ñuhu can. ¿Nacuenda tsa cuñí un jandavi ñaha un tsi Nyoo tan catyí un tyin tandɨhɨ xuhun can tsaha̱ un? Maa tyin ñavin tsi nyuhu jandaví ñaha un, tyin tsi maa Nyoo jandaví ñaha un ―catyí ra Pedro tsihin ra Ananías. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tsa tsiñi̱ ra Ananías tuhun tsa caha̱n ra Pedro, nduva̱ ra tan tsihi̱ ra. Tan tsa tsito̱ nyɨvɨ tuhun ihya tan nayuhvi̱ xaan ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tacan tan tsaa̱ ra cuatyi naha ra tan cava̱ nuu ra naha jahma cuñu ñuhu ra Ananías. Tan tsaha̱n ra naha tsindaca̱ ra naha tsi ra nu ndaa cumi santu. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Yaha̱ uñi hora tan tsaa̱ ñasɨɨhɨ ra Ananías tan quɨhvɨ̱ ña nu yucú ra tava̱ tyiñu ra Jesús, tyin ña tsitó ña tsa cuvi̱. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tan quitsaha̱ tsicá tuhun ra Pedro tsi ña tan catyí ra tsihin ña: ―¿A tyehen ñi cuví xuhun tsa cuyahvi̱ ñuhu ndo? ―catyí ra Pedro tsihin ña. Tacan tan nacaha̱n ña tan catyí ña tsihin ra: ―Tacan ñi cuví xuhun tsa cuyahvi̱ tsi ―catyí ña tsihin ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tacan tan catyí ra Pedro tsihin ña: ―¿Nacuenda tsa natuhu̱n tahan ndo tan cuñí ndo jandavi ñaha ndo tsi Tatyi Ii Jutu Mañi yo Nyoo? Ican vatsí ra tsa tsaha̱n tsindaca̱ tsi yɨɨ un nu ndaa cumi santu. Tan vityin cua cundaca ndɨhɨ ra naha tsi un ―catyí ra Pedro tsihin ña Safira. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tan juvin ñi cuhva can tan nduva̱ ña tsaha ra Pedro, tan cueta tsihi̱ ña. Tan quɨhvɨ̱ ra cuatyi can naha ra, tan nyehe̱ ra naha tyin canyií ña tsihi̱ ña. Tan cañihi̱ ra naha tsi ña, tan tsindaca̱ ra naha tsi ña nu ndaa cumi sandu. Tan tinyii̱ ra naha tsi ña xiin yɨɨ ña. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tan tandɨhɨ nyɨvɨ yɨhɨ́ cuenda ra Cristo, tan tandɨhɨ nyɨvɨ tsa tsito̱ tuhun can, nayuhvi̱ xaan ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Cuaha seña tan tsa iyo javaha̱ ra tava̱ tyiñu ra Jesús nu yucú nyɨvɨ. Tan tandɨhɨ ñi yɨhɨ́ cuenda ra Cristo ndu iín ñi nu cuví corredor cuenda ra Salomón. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tan nyɨvɨ tsa inga cuenda ña caná iñi ñi cutahan ñi tsihin ñi yɨhɨ́ cuenda ra Cristo. Maa tyin nyɨvɨ can vaha caahán ñi sɨquɨ ñi yɨhɨ́ cuenda ra Cristo. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tan cuaha xaan nyɨvɨ quitsaha̱ tsinú iñi tsi Jutu Mañi yo Jesús, tahan ñi rayɨɨ tan ñaha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tan nda cuanda tavá ñi tsi nyɨvɨ cuuhví ityi cahnu, tsaquín ñi tsi ñi nu tsito. Tyin tatun cua yaha ra Pedro tan yaha tixahñu ra sɨquɨ ñi cua nduvaha ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tacan tucu nyɨvɨ iyó yatyin ñi ñuu Jerusalén can, cuandacá ñi tsi nyɨvɨ cuuhví tan nyɨvɨ tsa yɨhɨ́ tatyi ña vaha. Tan nduvaha̱ tandɨhɨ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tacan tan ra jutu tsaahnu tsa cuví ityi nuu, tan ra yɨhɨ́ cuenda ra cuví saduceo naha ra, ndasɨ cuñí ra naha nyehé ra naha tsi ra tava̱ tyiñu ra Jesús tsa cuenda tsa vaha tsa javahá ra naha tsihin tunyee iñi tsa tsaha̱ Nyoo tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tacan tan tɨɨ̱n ra naha tsi ra naha. Tan tyihi̱ ra naha tsi ra naha vehe caa. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Maa tyin tsa cuaa can quitsi̱ iin ángel tsa jaquitsi̱ Jutu Mañi yo, tan nuña̱ ra yuvehe caa can. Tan tava̱ ra tsi ra naha. Tan catyí ra tsihin ra naha: ");
INSERT INTO mjcNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Cu̱aahan ndo tan cu̱nyacu nyityi ndo vehe ñuhu cahnu. Tan na̱catyi tuhun ndo tsihin nyɨvɨ nácaa coo ñi ñayɨvɨ nyito tsa iyó ndo ―catyí ángel can tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tsa tsiñi̱ ra naha tsa caha̱n ra ángel can, tan cuahán ra naha. Tan tsa tuvi inga quɨvɨ can nañihi̱ nyɨvɨ tsi ra naha vehe ñuhu cahnu. Tan quitsaha̱ jacuahá ra naha tsi ñi. Tan tsitsi tsa jacuahá ra naha tsi ñi, tan ndu ii̱n ra jutu tsaahnu tsa cuví ityi nuu tan ra tsa yucú tsihin ra. Tan cana̱ ra naha tsi ra cumi tyiñu cuenda nyɨvɨ Israel tyin coo ra naha junta. Tacan tan tava̱ tyiñu ra naha na cuquihin ra naha tsi ra tava̱ tyiñu ra Jesús nu yucú ra naha vehe caa can. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Maa tyin cuhva tsa tsaa̱ ra vitya naha ra tsitsi vehe caa can, ña nañihi̱ ra naha tsi ra naha. Tan cuanuhu̱ ra naha cua nacatyi tuhun ra naha tsihin ra jutu tsaahnu tsa cuví ityi nuu. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Tan catyí ra naha tsihin ra: ―Ndasɨ́ yuvehe caa can tan tsaa̱ ndi. Tan andaru, yucú ra naha yuvehe jahá cuenda ra naha. Maa tyin cuhva tsa nuña̱ ndi yuvehe can, yoñi maa nañihi̱ ndi ―catyí ra naha tsihin ra jutu tsaahnu tsa cuví ityi nuu. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tacan tan ra jutu tsaahnu tsa cuví ityi nuu can tsihin ra yɨhɨ́ ndaha tsi tandɨhɨ ra tsa jahá cuenda vehe ñuhu can tan tsihin ra jutu tsa cuví ityi nuu naha ra, tsiñi̱ ra naha tsa caha̱n ra vitya naha ra tsihin ra naha tan iyo xaan cuñí ra naha. Tan natuhu̱n tahan ra naha nácaa javaha ra naha tan cundɨhɨ tuhun can. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tacan tan tsaa̱ iin ra tan catyí ra: ―Ra tsa tyihi̱ ndo vehe caa can naha ra, yucú ra naha vehe ñuhu jacuahá ra naha tsi nyɨvɨ ―catyí ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tacan tan ra yɨhɨ́ ndaha tsi ra jahá cuenda vehe ñuhu can, tsaha̱n ra tsihin ra vitya naha ra, tan tsiquihi̱n ra naha tsi ra tava̱ tyiñu ra Jesús tsihin tsa vii ñi tan ña cañi̱ ra naha tsi ra naha, tyin yuuhví ra naha tsi nyɨvɨ coto cañi ñi yuu tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tsindaca̱ ra naha tsi ra tava̱ tyiñu ra Jesús nuu ra cumi tyiñu vehe ñuhu cahnu. Tan ra jutu tsaahnu tsa cuví ityi nuu catyí ra tsihin ra tava̱ tyiñu ra Jesús: ");
INSERT INTO mjcNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Nyuhu tsa caha̱n vaha xaan ndi tsihin ndo tyin ña cahan ca ndo tuhun ra Jesús. Maa tyin nyooho ña tyaa̱ soho ndo tsa caha̱n ndi. Tan tsa ndɨhɨ maa tsitsi ñuu Jerusalén jacotó ndo tuhun ra. Tan cuñí ndo tyaa ndo cuatyi can sɨquɨ ndi tyin tsihi̱ ra ―catyí ra jutu tsaahnu tsa cuví ityi nuu tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tacan tan nacaha̱n ra Pedro tan inga ra tava̱ tyiñu ra Jesús, tan catyí ra naha: ―Taahán tsi tyaa yahvi jihna ndi tsi Nyoo tan ñavin ca tsi nyooho. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nyoo cuenda tsii tsaahnu yo juvin ra janandoto̱ tsi ra Jesús, ra tsa ticaa̱ ndo nu cruu tan tsahñi̱ ndo. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tan ra Jesús cuví ra tsa jacahnu̱ xaan Nyoo, tan tyaa̱ ra tsi ra xiin cuaha ra, tyin cua cundaca ñaha ra tandɨhɨ maa. Tan intuhun ñi maa ra cuví ra jacacú tsi yo. Tyin tacan tsahá ra cuhva tsi yo tsa cuví yo nyɨvɨ Israel na ndu uvi iñi yo cuatyi yo tan jaha ra tucahnu iñi cuatyi yo. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tan nyuhu cuví ndi tsandaa tsa cuenda tandɨhɨ yacan. Tan tacan cuví tucu Tatyi Ii Nyoo tsa tsaha̱ Nyoo cunyaa añima nyɨvɨ tyaá yahvi tsi ra ―catyí ra Pedro tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tan tsa tsiñi̱ ra naha tsa caha̱n ra Pedro, nduxaa̱n xaan ra naha. Tan cuñi̱ ra naha cahñi ra naha tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Maa tyin tsihin ra cumi tyiñu can naha ra nyií iin ra cuví fariseo tsa nañí Gamaliel. Tan cuví ra maestro cuenda ley Nyoo tsa tyaa̱ ra Moisés. Tan nyɨvɨ tyaá yahvi xaan ñi tsi ra. Tan ra Gamaliel can, nduvita̱ nyityi ra. Tan caahán ra na quita ra tava̱ tyiñu ra Jesús tañi ñi. Tacan tan quita̱ ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tan quitsaha̱ caahán ra Gamaliel can tsihin tandɨhɨ ca ra cumí tyiñu naha ra, tan catyí ra: ―Yoo, ra tsa ndacá ñaha tsi nyɨvɨ Israel, ja̱ha yo cuenda tsi yo tsihin tsa cua javaha yo tsi ra ican naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ndu̱cuhun iñi ndo tyin tsa iyó juhva quɨvɨ nduvita̱ iin ra tsa tsinañi̱ Teudas. Tan catyi̱ ra tyin cuví ra iin ra vaha. Tan quita̱ maa tumaa cumi cientu rayɨɨ tsinyicu̱n tsi ra. Maa tyin yaha̱ can tsahñi̱ nyɨvɨ tsi ra. Tan tandɨhɨ ra tsa tsinyicu̱n tsi ra cuanuhu̱ ra naha ñuu ra naha. Tan tsindɨhɨ̱ tuhun can. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yaha̱ can tan nu cuahán ca tsi ityi nuu, quɨvɨ nacahvi̱ ra gobiernu tsi nyɨvɨ, tan nduvita̱ ra Judas ra ityi Galilea. Tan cuaha xaan nyɨvɨ tsinyicu̱n tucu tsi ra can. Maa tyin juvin ñi tsahñi̱ nyɨvɨ tsi ra. Tan tandɨhɨ ñi tsa tsinyicu̱n tsi ra cuanuhu̱ ñi ñuu ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yacan cuenda ja̱ña yo tsi ra ihya naha ra. Tan ña cua tyihi yo tsi yo tsihin ra naha tyin tatun tuhun iin rayɨɨ ñi cuví tsa jacuahá ra naha, cua cundɨhɨ tuhun can. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Maa tyin tatun nditsa tyin tuhun Nyoo cuví tsa jacuahá ra naha, ña cua cuvi casɨ yo. Ja̱ha yo cuenda tsi yo tyin ña vaha cañí tahan yo tsihin Nyoo ―catyí ra Gamaliel tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tandɨhɨ ra naha ndoo̱ ra naha vaha tsa ña cua cahñi ra naha tsi ra naha. Tacan tan cana̱ ra naha tsi ra tava̱ tyiñu ra Jesús. Tan catyí ra cumí tyiñu naha ra tsihin ra vitya naha ra na cañi ra naha tsi ra naha. Tan tyasɨ̱ ra naha nu cahan ra naha tuhun ra Jesús. Tacan tan jaña̱ ra naha tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tan quita̱ ra naha nuu ra cumí tyiñu. Tan sɨɨ xaan cuñí ra naha tyin tsaha̱ Nyoo ndatu tyin nyehé ra naha tundoho tsa cuenda ra Jesús. ");
INSERT INTO mjcNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tan ña jandɨhɨ̱ ra naha tsa caahán ra naha. Tan tandɨhɨ quɨvɨ jacuahá ra naha tuhun ra Jesucristo vehe ñuhu tan vehe nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tan nu cuahán ca tsi quɨvɨ cuaha xaan nyɨvɨ yɨhɨ́ cuenda ra Cristo cuvi̱. Tacan tan nyɨvɨ tsa caahán yuhu griego quitsaha̱ caahán ñi sɨquɨ nyɨvɨ tsa caahán yuhu hebreo tan catyí ñi tyin cuhva tsa tsatsá ra naha tsa catsi ñi tandɨhɨ quɨvɨ ña jahá vaha ra naha cuenda tsi ñi ndaahvi grecia tsa tsihi̱ yɨɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tacan tan tandɨhɨ tsa utsi uvi taahan ra tava̱ tyiñu ra Jesús jandu ii̱n ra naha tsi tandɨhɨ nyɨvɨ yɨhɨ́ cuenda ra Cristo. Tan catyí ra naha tsihin nyɨvɨ can: ―Ña vaha tsa jandɨhɨ ndi tsa caahán ndi tuhun Nyoo tan tsa tsatsá ndi tsa catsi ndo. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yacan cuenda, nyooho yañi, na̱nducu ndo utsa taahan ra nu yucú yo ihya, ra vaha iyó tsihin Nyoo, ra tsa iyó tsa tsiñituñi iñi, ra tsitú tsihin Tatyi Ii Nyoo. Tan cuhva yo tyiñu ihya tsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tan nyuhu cua jañihi ndi ndacan tahvi ndi tsi Nyoo, tan cua jacuaha ca ndi tuhun Nyoo ―catyí ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tandɨhɨ ñi tan ndoo̱ ñi vaha. Tan nacatsi̱ ñi tsi ra Esteban. Tyin tsinú xaan iñi ra tsi Nyoo. Tan tsitú ra tsihin Tatyi Ii Nyoo. Tan nacatsi̱ tucu ñi tsi ra Felipe, tan ra Prócoro, tan ra Nicanor, tan ra Timón, tan ra Parmenas, tan ra Nicolás tsa cuví ra iin ra ñuu Antioquía, tan nanduvi̱ ra iin ra Israel. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tacan tan tsindaca̱ ñi tsi ra naha nu nyecú ra tava̱ tyiñu ra Jesús. Tan tyiso̱ ndaha ra naha jiñi intuhun intuhun ra naha tan tsica̱n tahvi ra naha tsi Nyoo tsa cuenda ra can naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tan tsityá ca tuhun Nyoo. Tan nducuaha̱ ca ñi yɨhɨ́ cuenda ra Cristo ñuu Jerusalén. Tan cuaha xaan ra cuví jutu cuenda nyɨvɨ Israel natsinu̱ ndɨhɨ iñi ra naha tuhun ra Cristo. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ra Esteban cuví ra iin ra tsa tsitú tsihin tunyee iñi Nyoo. Tan vaha xaan nyɨvɨ cuví ra tyin tsitú añima ra tsihin tsa vaha tsi Nyoo. Tan cuaha xaan tsa iyo tan seña javahá ra nu yucú nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tacan tan juhva ra tsa tsicá vehe ñuhu ñuu Israel tsa nañí Vehe Ñuhu Cuenda Nyɨvɨ Ndoó Nuña cutaha̱n ra naha tsihin juhva ra ñuu Cirene naha ra, tan cutaha̱n ndɨhɨ juhva ra ñuu Alejandría naha ra, tan ra ityi Cilicia naha ra, tan ra ityi Asia naha ra. Tan quitsaha̱ caahán yuhu tahan ra naha tsihin ra Esteban. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Maa tyin ña cuvi̱ jaha̱ canaa ra naha tsi ra, tyin ra Esteban caahán ra tsihin tsa tsiñituñi jiñi ra tsa tsaha̱ Tatyi Ii Nyoo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tacan tan tyahvi̱ ra can naha ra tsi juhva ra na cahan ra naha cuendu sɨquɨ ra Esteban tan catyi ra naha tyin ra Esteban caahán ra ndavaha ñi sɨquɨ ra Moisés, tan sɨquɨ Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yacan cuenda tandɨhɨ nyɨvɨ can quitsaha̱ cuvaá ñi tan tsihin ra tsahnu naha ra tan ra cuví maestro cuenda ley Nyoo. Tacan tan tɨɨ̱n ra naha tsi ra Esteban. Tan tsaha̱n ra naha tsindaca̱ ra naha tsi ra nu ndu iín ra cumí tyiñu cuenda vehe ñuhu nyɨvɨ Israel. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tan nducu̱ ra naha tsi ra cahan cuendu sɨquɨ ra Esteban. Tan maa ra naha catyí ra naha tyehen: ―Ra Esteban ihya, ña jandɨhɨ́ ra tsa caahán ra ndavaha ñi sɨquɨ vehe ñuhu yo tan sɨquɨ ley Nyoo tsa tyaa̱ ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tan tsiñi̱ ndi tsa caahán ra tyin ra Jesús, ra Nazaret can, cua canɨ ra vehe ñuhu cahnu ihya. Tan cua nasama ra cuhva iyó yo tsa jacuaha̱ ra Moisés tsi yo ―catyí ra tsa caahán cuendu sɨquɨ ra Esteban. ");
INSERT INTO mjcNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tacan tan ra cumí tyiñu naha ra tan ra nyecú ican nyehe̱ ra naha tsi ra Esteban tyin tumaa caá nuu iin ángel, tacan caá nuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tacan tan ra jutu tsaahnu tsa cuví ityi nuu tsica̱ tuhun ra tsi ra Esteban, tan catyí ra: ―¿A nditsa tsa caahán ra ihya naha ra sɨquɨ un? ");
INSERT INTO mjcNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tacan tan nacaha̱n ra Esteban tan catyí ra: ―Nyooho yañi, tan nyooho ra tsahnu, tya̱a soho ndo tuhun tsa cua cahan yu. Jutu yo Nyoo, ra cahnu ca, quituvi̱ ra nuu tsii tsaahnu yo, ra Abraham, quɨvɨ nyií ra ityi Mesopotamia tsa ndi cumañi ca cuhun ra coo ra nda ñuu Harán. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tan catyi̱ ra tsihin ra: “Na̱coo ñuu un, tan tsi tandɨhɨ nyɨvɨ un. Tan cu̱hun cun inga ñuu tsa cua janaha yu tsi un” catyi̱ Nyoo tsihin ra Abraham. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tacan tan ra Abraham quita̱ ra nu iyó nyɨvɨ Caldea ityi Mesopotamia, tan cuahán ra nda ñuu Harán. Tan ndacan cuví nu tsihi̱ jutu ra. Yaha can jaquitsi̱ Nyoo tsi ra ñuhu nu iyó yo ihya vityin. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Maa tyin nduve ñuhu tsaha̱ Nyoo tsi ra quɨvɨ can. Ndi luxu maa nu cuañi ra tan ña tsaha̱ Nyoo. Maa tyin catyi̱ ra tsihin ra Abraham tyin cua cuhva ra. Tan tsa cua cúu ra tan Nyoo cua cuhva ra ñuhu tsi sehe ra. Tacan caha̱n Nyoo tsihin ra Abraham, vasu tsa ñaha ca coo sehe ra quɨvɨ can. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tan inga tucu tuhun caha̱n Nyoo tsihin ra tyin nyɨvɨ tata ra cua coo ñi inga ñuu. Tan cua cuvi ñi musu nyɨvɨ ñuu can. Tan maa nyɨvɨ ñuu can cua quɨhɨ ndaha ñi tsi ñi. Tan cua nyehe ñi tundoho cumi cientu cuiya. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Maa tyin caha̱n tucu Nyoo tsihin ra tyehen: “Nyɨvɨ tata un cua nyehe ñi tundoho jaha nyɨvɨ ñuu can. Yacan cuenda yuhu cua tatsi tuñi yu tsi nyɨvɨ ñuu can. Tan tsa cua yaha yacan tan cua quita nyɨvɨ cuvi tata un ñuu can tan cua quitsi ñi ihya. Tan cua jacahnu ñi tsi yu” catyi̱ Nyoo tsihin ra Abraham. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","’Tacan natuhu̱n Nyoo tsihin ra. Tan ndoo̱ ra tuhun tsihin ra. Tan Nyoo tsaha̱ ra iin cuhva tsa cua javaha ñi coto naa iñi ñi tsa caha̱n ra. Tsaha̱ cuenda ra tyin tandɨhɨ ñi sehe yɨɨ ñi tsa cua coo tan cuñí tsi cunyaa tuñi ra itsi naha tsi. Tan tsa yaha̱ una quɨvɨ tsa cacu̱ ra Isaac, sehe ra Abraham, tacan javaha̱ ra tsi ra. Tan juvin ñi tacan javaha̱ ndɨhɨ tucu ra Isaac tsi ra Jacob, sehe ra. Tan ra Jacob tucu tsihin utsi uvi taahan sehe ra, tyaa̱ ra tuñi can tsi intuhun intuhun sehe yɨɨ ra. Tan ra ican naha ra cuví tsii tsaahnu yo. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Tan tsa utsi iin taahan ca sehe ra Jacob ndasɨ cuñi̱ ra naha nyehe̱ ra naha tsi ra José yañi ra naha, tsa cuenda tyin cuñi̱ ca jutu ra naha tsi ra can. Yacan cuenda xico̱ ra naha tsi ra José na cuvi ra iin musu nda Egipto. Maa tyin ra José, ña nacoo̱ Nyoo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tan jacacu̱ ra tsi ra nu nyehé ra tundoho. Tan tsaha̱ ra tsa nyityi jiñi ra tsi ra José. Tan tsaha̱ ra tsa vaha coo ra nuu ra Faraón, ra cuvi̱ rey Egipto. Tan rey can tsaha̱ ra tsa cuví ra José ra cumí tyiñu ñuu tsa cayucú Egipto can. Tan tsindaca̱ ñaha ndɨhɨ tucu ra vehe maa rey. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Tacan tan tsicoo̱ tama nanɨɨ cahnu ityi Egipto tan ityi Canaán. Tan nyehe̱ xaan nyɨvɨ tundoho. Tan tandɨhɨ tsii tsaahnu yo ña ñihi̱ ra naha tsa catsi ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Maa tyin quɨvɨ tsito̱ ra Jacob tyin iyó tsa catsi ra naha nda Egipto, tan jacuhu̱n ra tsi sehe ra na cunducu ra naha tsa catsi ra naha. Tan tsaha̱n ra naha iin tsaha. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tan tsa tsinu uvi tsaha tsa tsaha̱n ra naha, ra José jacoto̱ ra tsi ra naha tyin yañi ra naha cuví tsi ra. Tacan tan tsito̱ ra Faraón yóo tata cuví ra José. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tacan tan tava̱ tyiñu ra José na quitsi ra Jacob jutu ra, tsihin tandɨhɨ nyɨvɨ ra. Tan cuvi̱ ñi uñi xico tsahun taahan nyɨvɨ. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tan tacan cuvi̱ tsa cuahán ra Jacob cua coo ra ñuhu Egipto can. Yaha̱ can tan tsihi̱ ra ndacan. Tan tsihi̱ ndɨhɨ tucu tandɨhɨ sehe ra, ra cuví tsii tsaahnu yo naha ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tacan tan tsaa̱ quɨvɨ tsa tsindaca̱ ñi yɨquɨ ra Jacob tan yɨquɨ sehe ra nda Siquem. Tan ican quɨhvɨ̱ yɨquɨ tandɨhɨ ra naha tsitsi ñuhu nu jata̱ ra Abraham iin ñaña tsi sehe ra Hamor taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Maa tyin tsa ndi cumañi ca quita nyɨvɨ Egipto, nyɨvɨ ra Abraham tsa iyó Egipto can cuaha xaan ñi cuvi̱. Tan tsa nyanaa yatyin quɨvɨ tsa cua cuhva Nyoo ñuhu tsi ñi tumaa tsa caha̱n catsi ra tsihin ra Abraham. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tacan tan quitsaha̱ ndacá ñaha iin rey tsa ña nacoto̱ tsi ra José. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rey can jandavi̱ ñaha ra nyɨvɨ yo. Tan janyehe̱ xaan ra tundoho tsi ñi, tan jañiñi̱ ra tsi ñi na nacoo ñi tsi sehe ñi tsa ndi cacú tyin na cúu tsi. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tan juvin ñi quɨvɨ can cacu̱ ra Moisés. Tan taha̱n xaan iñi Nyoo tsi ra. Tan uñi yoo jacuahnu̱ sɨhɨ ra tsi ra nda yuvehe ña. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Yaha can ña cuví ca tyihi xeehe sɨhɨ ra tsi ra. Tan nacoo̱ ña tsi ra tsitsi iin tyica yuhu yutya. Tacan tan sehe sɨɨhɨ ra rey Egipto can nañihi̱ ña tsi ra. Tan naquihi̱n ña tsi ra. Tan jacuahnu̱ ña tsi ra, tumaa tsa sehe maa ña cuvi̱ tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yacan cutuhva̱ ra Moisés tandɨhɨ tsa tsitó ñi Egipto. Tan vaha xaan caha̱n ra tan vaha javaha̱ ra jaha̱ tunyee iñi tsa tsaha̱ Nyoo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Tan tsa quita̱ uvi xico cuiya ra Moisés cuñi̱ ra cuhun ra cunyehe ra nu iyó nyɨvɨ Israel, nyɨvɨ ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tacan tan iin quɨvɨ nyehe̱ ra nu cañí iin ra Egipto can tsi iin ra Israel. Tacan tan tsahñi̱ ra Moisés tsi ra Egipto can tyin cañí xaan ra tsi ra Israel, ra ñuu ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Cuñí maa ra Moisés can tyin nyɨvɨ Israel can cutuñí iñi ñi tyin Nyoo jaquitsi̱ tsi ra tyin jacacu ra tsi ñi. Maa tyin ña tuvi̱ iñi ñi tsa tacan cua cuvi. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tacan tan tsa inga quɨvɨ can nyehe̱ ra Moisés tsi uvi taahan ra Israel, cañí tahan ra naha. Tan ra Moisés, cuñí ra tsa ña cañi tahan ca ra naha, tan quitsaha̱ catyí ra: “Ña vaha tsa cañí un tsi ra yañi un” catyí ra tsihin ra naha. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tacan tan ra tsa cañí tsi inga ra can tindahñi̱ ra tsi ra Moisés, tan catyí ra tsihin ra: “¿Yóo tava̱ tyiñu tsi un tyin cundaca ñaha un tan cuvi un juez tsa cuenda ndi? ");
INSERT INTO mjcNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A cuñí un cahñi un tsi yu tumaa tsa tsahñi̱ un tsi ra Egipto icu?” catyí ra tsihin ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cuhva tsa tsiñi̱ ra Moisés tsa caha̱n ra can, tsinu̱ ra. Tan cuahán ra nda ñuu Madián. Ndacan ñihi̱ ra ñasɨɨhɨ ra. Tan ndacan tsicoo̱ uvi taahan sehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Yaha̱ uvi xico cuiya. Tacan tan iin quɨvɨ tsicá nuu ra Moisés nu tsɨquɨ yatyin yucu tsa nañí Sinaí. Tan nyehe̱ ra cayú iin yutun iñu. Tacan tan quituvi̱ iin ángel tsitsi ñuhu̱ tsa cayú can. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Iyo xaan cuñi̱ ra Moisés tsa nyehé ra yacan. Tan natuhva̱ ra nu cayú iñu can tyin nyehe vaha ra, tan tsiñi̱ ra ndusu Jutu Mañi yo. Tan catyí ndusu can tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yuhu cuví Nyoo cuenda tsii tsaahnu un, Nyoo cuenda ra Abraham, tan ra Isaac, tan ra Jacob” catyi̱ ndusu can tsihin ra. Tacan tan ra Moisés quitsaha̱ nɨhɨ́ ra tsihin tsa yuuhví ra. Tan ña cana̱ iñi ra nanyehe ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tan quitsaha̱ catyí tucu Jutu Mañi yo tsihin ra: “Ta̱va nditsan tsaha un tyin ñuhu nu tsañí un, ñuhu ii cuví tsi. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yuhu nyehé yu tandɨhɨ tundoho tsa nyehé nyɨvɨ cuenda yu ñuhu Egipto can. Tan tsiñí yu ndusu ñi tsa tsacú tsaa ñi. Yacan vatsí nuú yu tyin jacacu yu tsi ñi. Na̱ha, tyin jacuhun yu tsi un nda Egipto” catyi̱ Nyoo tsihin ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Quɨvɨ can ña cuñi̱ nyɨvɨ Israel tsi ra Moisés tsa cundaca ñaha ra tsi ñi, tan catyi̱ ñi tsihin ra: “¿Yóo tava̱ tyiñu tsi un tyin cundaca ñaha un tan cuvi un juez tsa cuenda ndi?”, catyi̱ ñi tsihin ra. Vasu ña cuñi̱ ñi tsa cundaca ñaha ra tsi ñi, maa tyin Nyoo tava̱ tyiñu ra tsi ra tyin cuvi ra nuu tsihin ñi, tan jacacu ra tsi ñi. Tyin tacan catyi̱ ángel tsa quituvi̱ nuu ra nu iñu tsa cayú can. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tan ra Moisés can tava̱ tsi nyɨvɨ Israel ñuhu Egipto can tsihin tsa javaha̱ ra tsa iyo tan seña ñuu can, tan nu yaha̱ ñi nda nu Ndutya Ñuhu Cuaaha, tan nu tsica̱ nuu ñi nu tsɨquɨ tsitsi tsa uvi xico cuiya. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","’Tan juvin ñi maa ra Moisés can cuví ra tsa caha̱n tsihin nyɨvɨ Israel tan catyi̱ ra tyehen: “Nyoo cua jaquitsi ra tsi iin ra cuví ndusu yuhu ra tumaa jaquitsi̱ ra tsi maa yu. Tan cua cuvi ra iin ra Israel tumaa maa yo. Tan taahán tsi tyaa yahvi yo tsi ra” catyi̱ ra Moisés. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tan maa ra Moisés can cuahán ra tsihin nyɨvɨ tsii tsaahnu yo nu tsica̱ nuu ñi nu tsɨquɨ can. Tan ra ican cuví ra tsa caha̱n ángel tsihin nda yucu Sinaí. Tan ra ican naquihi̱n cuenda ra tuhun Nyoo nácaa coo nyɨvɨ, tan tyaa̱ ra tuhun can nu tutu tyin tacan tan coto yo. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Maa tyin nyɨvɨ tsii tsaahnu yo ña tyaa̱ yahvi ñi tsi ra. Tava̱ tsiyo ñi tsi ra. Tan cuñi̱ ñi cunuhu ñi nda Egipto. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yacan cuenda cuhva tsa nyií ra Moisés yucu Sinaí, tan caha̱n nyɨvɨ tsihin ra Aarón tan catyi̱ ñi: “Ja̱vaha taahan nyoo cuhun ityi nuu ndi. Tyin ña tsitó yo náa taha̱n ra Moisés, ra tsa tava̱ tsi yo Egipto” catyi̱ ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tacan tan javaha̱ ñi iin indɨquɨ xuhun cuaan. Tan tsahñi̱ ñi quɨtɨ tyin cuhva cuenda ñi tsi tsitoho can. Tan sɨɨ xaan cuñi̱ ñi tsicoo̱ ñi vico cuenda tsitoho tsa javaha̱ ñi tsihin ndaha ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tacan tan Nyoo jatsiyo̱ ra tsi ñi. Tan jaña̱ ndaha ra tsi ñi tyin cua jacahnu ñi ñicanyii, tan yoo, tan tandɨhɨ tiñuu tsa iyó ityi andɨvɨ. Tyin tyehen tyaa̱ ra cuvi̱ ndusu yuhu Nyoo nu libru taha̱n tsanaha: Nyooho nyɨvɨ Israel, ¿A tsahñi̱ ndo quɨtɨ tyin cuhva cuenda ndo tsi maa yu tsitsi tsa uvi xico cuiya tsa tsica̱ nuu ndo nu tsɨquɨ? Ñavin. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tyin jacahnu̱ ndo tsi nyoo tsa nañí Moloc, tan jacahnu̱ ndɨhɨ tucu ndo tsi nyoo tsa nañí Renfán tsa caá tumaa caá iin tiñuu tsa iyó andɨvɨ. Juvin ñi maa ndo javaha̱ tsitoho can, tan jacahnú tucu ndo. Yacan cuenda yuhu cua tava yu tsi ndo ñuu ndo, tan cua jacuhun yu tsi ndo iin nu cañi ca ityi nuu ñuu Babilonia, catyi̱ Nyoo tsihin ñi. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Nu tsica̱ nuu tsii tsaahnu yo nu tsɨquɨ can, tsicumi̱ ra naha iin vehe ñuhu tsa tsinu̱ tsihin ñɨɨ quɨtɨ. Tan tsitsi vehe can tsicumi̱ ra naha tabla yuu tsa nyaá ley Nyoo nuu. Tan ra Moisés tava̱ tyiñu ra na javaha ñi vehe ñuhu can ityi tsata, tumaa cuhva janaha̱ maa Nyoo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yaha can tan ra Josué cuvi̱ ra ityi nuu tsihin ñi. Tacan tan quihi̱n ñi vehe ñuhu can tan vatsí ñi tsihin tsi nu iyó yo ihya vityin. Tyin Nyoo tava̱ ra tsi nyɨvɨ tsicoo̱ ñuhu ihya tan nacuhva̱ cuenda ra ñuhu ihya tsi ñi Israel, nyɨvɨ yo. Tan tsatyiñu̱ ñi vehe ñuhu can nda cuanda quɨvɨ tsicoo̱ ra rey David. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tan ra rey David ñihi̱ ra tumañi iñi nuu Nyoo. Tan cuñi̱ ra javaha ra iin vehe vaha nu coo Nyoo. Juvin ñi Nyoo jacahnu̱ ra Jacob taha̱n tsanaha. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Maa tyin ra Salomón javaha̱ ra vehe Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Vasu ña iyó Nyoo tsitsi vehe ñuhu tsa javahá nyɨvɨ. Tumaa caha̱n ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha tyehen: ");
INSERT INTO mjcNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Andɨvɨ cuví tyayu nu nyaá yu ndacá ñaha yu. Tan ñuhu ñayɨvɨ, yacan cuví nu tsañí tsaha yu. Tatun javaha nyooho iin vehe ¿a cuñí maa ndo tyin coo yu tsitsi can? ¿Tan maa nda cua na ica vaha ndo tyin quitatu yu, cuñí maa ndo? ");
INSERT INTO mjcNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿A ña tsitó ndo tyin maa yu javaha̱ andɨvɨ tan ñuhu ñayɨvɨ? catyi̱ ra cuví ndusu yuhu Nyoo jaha̱ Nyoo. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Maa tyin nyooho ―catyí ra Esteban― tacan ñi tuhvá maa ndo jandavá ndo iñi ndo. Tan ña cuñí ndo naquihin ndo tuhun caahán Nyoo. Tacan ñi ña tyaá yahvi ndo tsi Tatyi Ii Nyoo. Inducu ñi caá ndo tsihin tsii tsaahnu yo. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tsii tsaahnu yo cuxaa̱n ra naha tan tsahñi̱ ra naha tsi tandɨhɨ ra cuvi̱ ndusu yuhu Nyoo taha̱n tsanaha. Tan ra ican naha ra catyi̱ tyin cua quitsi iin ra vaha. Tan tsa quitsi̱ ra vityin, nyooho xico̱ ñaha ndo tsi ra tsi ra xaan iñi tsi ra, tan tsahñi̱ ndo tsi ra. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nyooho naquihi̱n cuenda ndo ley Nyoo tsa tsaha̱ ángel tsi ndo, maa tyin ña cuñí ndo tyaa yahvi ndo tsa caahán ley can ―catyí ra Esteban. ");
INSERT INTO mjcNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tsa tsiñi̱ ra cumí tyiñu vehe ñuhu cahnu naha ra tuhun ihya, xaan xaan cuñi̱ ra naha, ndacua jacahyu̱ nuhu ra naha nyehé ra naha tsi ra Esteban. 