﻿USE sofia;
DROP TABLE IF EXISTS sofia.mizNT_vpl;
CREATE TABLE mizNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mizNT_vpl WRITE;
INSERT INTO mizNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Xuꞌu é Mateú u ne, iꞌa kakaꞌán u iña táta viꞌi Jesucristu, iꞌxá ika Dāvii, iꞌxá ika Ābraan. ");
INSERT INTO mizNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Xíō iꞌxá Abraan é nani Īsaa; xíō iꞌxá Isaa é nani Jācoo; xíō iꞌxá Jacoo é nani Jūdaa; xíō ení ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Xíō iꞌxá Judaa é nanī Fare ní Zara (dɨꞌɨ ñā ne, Tamaa nani ña); xíō iꞌxá Fare é nani Ēruun; xíō iꞌxá Eruun é nani Āraan; ");
INSERT INTO mizNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","xíō iꞌxá Araan é nani Aminādaa; xíō iꞌxá Aminadaa é nani Nāsuun; xíō iꞌxá Nasuun é nani Sālmuun; ");
INSERT INTO mizNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","xíō iꞌxá Salmuun é nanī Boó (dɨꞌɨ ñā né, Raa nani ña); xíō iꞌxá Boo é nani Ōbeé (dɨꞌɨ ñā né, Ruu nani ña); xíō iꞌxá Obee é nani Isāii; ");
INSERT INTO mizNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","xíō iꞌxá Isaii é nani Dāvii, ña e kúvi rei. Ēni viꞌi rei Davií san ni ñadɨ̄ꞌɨ kií, ñadɨ̄ꞌɨ́ Uriá, ne, xíō iꞌxá ña é nani Salāmuun. ");
INSERT INTO mizNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Xíō iꞌxá Salamuun é nani Robōaan; xíō iꞌxá Roboaan é nani Ābia; xíō iꞌxá Abia é nanī Asa; ");
INSERT INTO mizNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","xíō iꞌxá Asa é nani Josāfaa; xíō iꞌxá Josafaa é nani Jōraan; xíō iꞌxá Joraan é nani Ūzia; ");
INSERT INTO mizNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","xíō iꞌxá Uzia é nani Jōtaan; xíō iꞌxá Jotaan é nani Ācaa; xíō iꞌxá Acaa é nani Ezēquia; ");
INSERT INTO mizNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","xíō iꞌxá Ezequia é nani Manāsee; xíō iꞌxá Manasee é nani Āmuun; xíō iꞌxá Amuun é nani Jōsia; ");
INSERT INTO mizNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","xío ūun iꞌxá Josia é nani Jecōniá ne, xíō ení ña dɨ. Ntoo ña ntuvi dá xee ñáꞌa, ña ñuú Babiloniá san ne, kueꞌen níꞌi ña ña Israeé san ñuú ña kān é nantōꞌo ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Dā rkontûvi xíō iꞌxá Jeconia é nani Salātiee; xíō iꞌxá Salatiee é nani Zorobābee; ");
INSERT INTO mizNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","xíō iꞌxá Zorobabee é nani Abīuu; xíō iꞌxá Abiuu é nani Eliāquiin; xíō iꞌxá Eliaquiin é nani Āsoo; ");
INSERT INTO mizNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","xíō iꞌxá Asoo é nani Sādoo; xíō iꞌxá Sadoo é nani Āquiin; xíō iꞌxá Aquiin é nani Elīuu; ");
INSERT INTO mizNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","xíō iꞌxá Eliuu é nani Lāzaa; xíō iꞌxá Lazaa é nani Mātaan; xíō iꞌxá Mataan é nani Jācoo; ");
INSERT INTO mizNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","xíō iꞌxá Jacoo é nani Jōseé, dɨvi xɨ̄ɨ Maríā. Maríā sán ne, dɨꞌɨ Jēsuú, dɨvi ñā é kākaꞌan o é Cristu, ña é taxnuu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Xío ūxkɨmi úvata ñā nté Abraan un tsi nté Davii. Xíō tuku uxkɨmi úvata ñā nté Davii un tsi da nté kueꞌen niꞌi ña ña Israeé san ñuú Babiloniá ne, xíō tuku uxkɨmi úvata ñā un tsi da nté ntūvi e káku Cristú san. ");
INSERT INTO mizNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Dukuan ō kúvi da káku Jesucristu: María, dɨꞌɨ Jēsuú ne, e xéꞌe ñā xuꞌu ña e tántaꞌa ña ni Jōseé ne, ntá tsi diꞌna dá kuntoo niꞌi tāꞌan ña ne, kūtuni ña tsí ñuꞌu iꞌxá ña kuenta iña Espíritū Sántū san. ");
INSERT INTO mizNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Dōo vaꞌá ñaꞌa xɨɨ ña Joseé san. Ña ni ntío ña é kāꞌan kíni ñaꞌa san iña Maríā. Dukuān né, dē kuení ña é diin diin tsi naxtuvī mii ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ntá tsi da nɨɨ kadē kuení ña ne, xée ūun ánje Xuva kō ñuu éni kān, kakaꞌan ña: —Jōsee, iꞌxá ika Dāvii, ñá ku uꞌvī o é nākiꞌin Maríā é kuvi ña ñadɨ̄ꞌɨ o, tsí iꞌxa é nakāku ña ne, ñuꞌu kuenta iña Espíritū Sántū san. ");
INSERT INTO mizNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nakāku ña uun iꞌxa tií ne, xntēén dɨvī í é Jēsuu, tsí dɨvi ñā é nakakū ñá ña ñuú ña, ña é iō kuetsí i —kaꞌan ánjē san. ");
INSERT INTO mizNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Un ntɨꞌɨ sāꞌa kúvi vata koo é kūntaa é kākaꞌan ña é kaꞌán naa Xuva ko: ");
INSERT INTO mizNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Kuꞌun īꞌxá uun ñadɨ̄ꞌɨ kuétsī, ña é vāta kiní ñatīí ne, nakāku ña uun iꞌxa tii é kunani ña Emānuee, kaꞌan ña. Emanueé ne, kani túꞌun: Xuva kō nuu méꞌñu ña kō. ");
INSERT INTO mizNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dā ntóto Joseé ne, dē ntaa ñá vatā ó kakaꞌan ánje Xuva kō san. Nākiꞌi ñá ñadɨꞌɨ̄ ña, ");
INSERT INTO mizNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ntá tsi ña ni kántoo niꞌi tāꞌan ña da nté ita ntíꞌxin ntuvi e káku iꞌxá ña. Xnteē ñá dɨvī í é Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kāku Jesuu ñuú Beleen ntuvi dá inúu rei Heróde ñūú tsikan. Kidáā né, ēka ña e dóo kiꞌin inī í san ñuú e dóo ikā ne, xée ña ñūú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ntátsixeꞌe ñā: —¿Míꞌi ntu tūví rei iña ñá Israee, ña é dā ve káku san? Īní ntɨ kɨ́mī e kéne e táꞌxi kuenta íña ñá nte ñúú ntɨ kān. Dukuān é vēꞌxí ntɨ é kunūu iní ntɨ ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dā téku rei Heródē sán ne, dōo dé kuení ña, ni ūn ntɨɨ́ ntɨ̄ɨ́ ña ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kāna ña un ntɨɨ́ ntɨ̄ɨ tóꞌō dutú san nī mastrú leí san, tsixeꞌe ña ñā: —¿Míꞌi ntu kāku ñá nanī Cristu, ña táxnuu Xuva kō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ntákaꞌan ñá ni ñā: —Ñuú Beleen é kāduku ntée ñuú Judea, tsí kuan ō kaꞌan ñá kaꞌán naa Xuva ko kídaā: ");
INSERT INTO mizNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Dɨvin, ñūú Beleen é tūvín ñuú Judaa, kaꞌnun vata ntáa é un ntɨɨ́ ntɨ̄ɨ́ ñuú naꞌnu mí ntoo ña ntádē kûꞌvé ñuú Judaa. Ntá tsi dií dií ka kuiko ñuꞌu ñāꞌa o, tsí nte ñúu o kan vēꞌxí uun ñaꞌa, ña kada kûꞌvé iña ñaꞌa ko, ñá Israeé san. Kuan ō kaꞌan ña —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kidáā né, kāna xuꞌu Heródē ña dóo kiꞌin inī í san, tsixeꞌe ña ñā nee ntúvi ntiꞌxe é kii díto kɨ́mī san. ");
INSERT INTO mizNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kidáā né, taxnūu ña ña ñuú Beleén san, kakaꞌan ña: —Kueꞌēn ntó, nantuku vāꞌá nto iꞌxá san. Te nāniꞌi nto í ne, taxnūu nto túꞌūn vata koo é kikunúu ini kó i dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Dā téku ña é kākaꞌán reí san ne, kuéꞌēn ká ña. Īní ña tsí dɨvī kɨ́mī e íni ña ñuú ña kān né, odo nūú nuu ña, kuéꞌēn da nté xee mí tuví iꞌxá san. ");
INSERT INTO mizNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Dā íni ña kɨ́mī sán ne, ñá tē nté kaa diní ña. ");
INSERT INTO mizNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dá kūkɨ́ꞌvi ña má viꞌi kān né, īní ña iꞌxá san ni dɨꞌɨ i Māríā ne, ínchɨtɨ ñā mí tuví ne, ínūu iní ña i. Nākaán ña etun ñá ne, xéꞌe ña īꞌxá san doméni e kúvi oro, ni kūtú, nī choꞌo vîdin e dóo nuu áꞌvi. ");
INSERT INTO mizNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kidáā ne, xéꞌe Xuva ko ūun xénī é kākaꞌan é ña ku ntiko koó ña mí tuví Heródē. Dukuān ne, tuku itsi kunúꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dā kunúꞌu ña ne, īní Josee ánje Xuva kō ñuu éni kān. Kaꞌan ánjē san: —Nakuntítsin, kiꞌin īꞌxá san ni dɨꞌɨ ī né, kueꞌen náneꞌen ñuú Egítō. Ikan kuntōo nto da nté kāꞌán u ni ō. Tsí kiꞌxi rei Heródē é nantuku ña īꞌxá san é kaꞌnī ñá i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nákuntītsí ña ne, kīꞌi ña iꞌxá san ni dɨꞌɨ ī, kueꞌen níꞌi ña ña ñūú Egíto, kuān te niñu. ");
INSERT INTO mizNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ikān tsi kantóo ña dā nté xiꞌi Heródē san. Sáꞌā kúvi vata koo é kūntaa é kākaꞌan ñáꞌa, ña é kaꞌán naa Xuva ko nte kídaā: “Nté ñūu Egítō nákaná u iꞌxá ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Dā kútuni Heródē tsí ña ni de ntáa ña dóo kiꞌin inī í san ne, kūdiin kuéꞌen ña. Taxnūu ña sntadun é kaꞌnī ñá un ntɨɨ́ ntɨ̄ɨ́ iꞌxa tii é ntoo ñuú Beleén, ni ñūu é ntoo etsin ikān, iꞌxa é īó uvi kuia í, ō é dií ka kuetsī, vata ō ita ntíꞌxin ntuvi é kaꞌan ña dóo kiꞌin inī í san. ");
INSERT INTO mizNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kidáā né, kūntaá vata ō kaꞌan ña é kaꞌán naa Xuva ko nte éma tsi, ñá nani Jerēmia: ");
INSERT INTO mizNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Dîtó un tsi nte ñuú Ramaa ntákachuꞌu ntáa ña, ntaéku ña. Un ntɨɨ́ ntɨ̄ɨ́ ñadɨ̄ꞌɨ́ Israeé ne, ntaéku nteé ña iꞌxá ña. Ña ni ntío ña ntukaꞌnu iní ña, tsí é xiꞌi ntɨ́ꞌɨ iꞌxá ña, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ntá tsi dā xiꞌi Heródē ne, kéni Josee é xee uun ánje Xuva kō, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Nakuntítsin, kiꞌin īꞌxá san ni dɨꞌɨ ī, kunúꞌu nto ñuú Israee, tsí e xíꞌi ña é ncho kaꞌní iꞌxá san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nákuntītsí ña ne, kīꞌi ña iꞌxá san ni dɨꞌɨ ī ne, dá kunúꞌu ña ñuú Israee. ");
INSERT INTO mizNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ntá tsi dā téku ña é dɨvi tsi īꞌxá Heródē, ñá nani Arquēlau, nakunúu ña naa ñá ne, úꞌvī ña é ntiko koō ña. Kūtuni ña ñuu éni kān ne, da díta ña itsi ñuú Galilea. ");
INSERT INTO mizNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kuéꞌen ña, kūkuntóo ña ñuu é nani Nazāree. Dukuan ō kúntaa é kākaꞌan ña é kaꞌán naa Xuva ko kídaā: “Kaꞌan ñáꞌa san tsí nazarenu ña”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ntuvi tsikán ne, xée Juaan Baūtista ñuu itsi é nani Jūdea, kakaꞌan ntódo ña, ");
INSERT INTO mizNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kakaꞌan ña: —¡Natɨvi iní nto, tsí e xée ētsin ntuvi é kiꞌxi Xuva ko, kixkadā kúꞌvē ña! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ña é kaꞌán naa Xuva ko kídaā, ñá nani Isāiá ne, kakaꞌan ñá iñá Juaán san dá kākaꞌan ña: Dîtó tatsin úun ñaꞌa, ña e dóo ntii kākaꞌan ñuu itsí kān: “Nakōo túꞌvē ntó itsi Xuva kō; Ntantaa ntó itsi ña”, kaꞌan ña, kaꞌan Ísaiá san. ");
INSERT INTO mizNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ínūú Juaán san doo e kúvi idi kameu. Ñɨɨ íꞌxi ña ne, ñɨɨ kúvi dɨ. Skuntí ini éꞌxi ña ne, īni xiꞌi ñá ntudin ñuñu. ");
INSERT INTO mizNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntoo ñuú Jerusaleén ni ñūú Judeá, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñuu é ntoo etsin nú ntūte kaꞌnu é nani Jōrdaán ne, kuéꞌen ñā mí nuu Juaán san. ");
INSERT INTO mizNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Natɨ̄vi iní ña kuétsi ñā ne, da ítsi ntute ña ntaꞌa Juaán san nú ntute kaꞌnu san. ");
INSERT INTO mizNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ntá tsi dā íni Juaán san tsí tɨ̄tɨ́n ña fariseú san nī ña saduceú san xée ñā é kūtsi ntute ña ne, kakaꞌan ñá ni ñā: —¡Ntōꞌo é tatá koo kúvi nto! ¿Xoó ntu kakaꞌan í ni ntō é kūnu nto é ña níꞌi nto é ntoꞌo nto ntaꞌa Xuva kō? ");
INSERT INTO mizNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Vií nto é vāꞌá vata koo e díto é natɨ̄vi iní ntiꞌxe nto. ");
INSERT INTO mizNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ñá ku kaꞌān nto: “Ntɨꞌɨ́ ne, Abraan úva ikā ntɨ”, é kuān o ntákaꞌan nto. Tsí kakaꞌán u ni ntō tsí kuvi vií Xuva kō é ntāda ña xuú san iꞌxá Abraán, tē dɨ́ ntio ña. ");
INSERT INTO mizNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","É iō tuꞌve kaá ntee é nakɨ̄ɨn ña utun san. Da nēé ka utun é ña taꞌxi kɨtɨ vaꞌá ne, nakɨ̄ɨn ña ne, dá kaꞌmi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Xuꞌú ne, ntute kadáꞌvi ú nto dá kanakutsi ntute ú nto é nātɨvi iní nto kuétsi ntō, ntá tsi ña é dā vé véꞌxi ne, dií ka kaꞌnu ña é xuꞌu. Ntē ña váꞌa u é kuidō ú ntiꞌxen ñā. Dɨvi ñā ne, Espíritū Sántū san ni ñúꞌu dáꞌvi ña nto. ");
INSERT INTO mizNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Niꞌi ntaꞌa ña ūtun é kākani ña kɨtɨ trigú ne, dá nākaxnúu ña é vāꞌá ne, dá nātsuꞌun váꞌa ña. Ntá tsi e ña kaidiáꞌvi ne, kaꞌmi ña meꞌñú ñuꞌu é ña kantáꞌva —kaꞌán Juaán san. ");
INSERT INTO mizNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kidáā ne, véꞌxi Jēsuu nte ñúú Galileá, ne, xée ñā nú ntute kaꞌnu Jordaán san, mí nuu Juaán san, vata koo é kūtsi ntute ña ntaꞌa Juaán san. ");
INSERT INTO mizNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ña ni ntío Juaán san é nakūtsi ntute ña ña, ne, kakaꞌan ña: —Xuꞌu é kantio ko é dɨvi nto nakūtsi ntute nto ko. ¿Vá kūvi ntu é xuꞌú nakūtsi ntute ú nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ntá tsi kakaꞌan Jésuu ni ña: —Kuan tsī koo, tsi é vāꞌá ō é kāda ntaa o é un ntɨꞌɨ̄ é kāꞌan Xúva kō —kaꞌan ña. Kidáā ne, kakaꞌán Juaán san tsí vií ña. ");
INSERT INTO mizNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Dā kúvi ítsi ntute Jesuú ne, ntii ña diñɨ ntute kān ne, ura dúꞌva tsi i nákaan e dukún kan ne, īní ña Espíritu Xuva kō, é īnu ña vata kaa paloma, kátavi ntódo ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kakaꞌan tátsin nte e dukún kān: —Sáꞌā é Iꞌxá miī kó e dóo kakuinimá ko. Dōo diní ko ni ñā —kaꞌan tátsín san. ");
INSERT INTO mizNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kidáā ne, íntēka Espíritū Sántū san Jésuu ñuu itsí kān é kōto nteé tóꞌō e ña váꞌā san ñá te kōꞌxó nteē ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Úvi dīkó ntuvi, úvi dīkó niñu ña ni eꞌxí ña ne, kidáā né, kākɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kidáā ne, xéē tóꞌō e ña váꞌā san ne, kakaꞌan ni ña: —Tē nuu é ntaā i é Iꞌxa Xuva ko kúvin ne, káꞌan ni xūú san na ntūví tañúꞌū —kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ntá tsi kakaꞌan Jésuu: —É ūve naꞌa kakaꞌan Túꞌun Xuva kō: “Ñá te da mii tsī tañúꞌu kāntio ñaꞌa é nīꞌi ña ntuvi iña ña, tsí un ntɨɨ́ ntɨ̄ɨ́ túꞌūn é kākaꞌan Xúva kō.” Kuān ó uve naꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kidáā ne, kueꞌen níꞌi tóꞌō e ña váꞌā san ña ñuú Jerusaleen, mí tuvi xúkun Xuva kō. Xntitsī ña míꞌī e dií ka dūkun rkɨ úkūn sán ne, ");
INSERT INTO mizNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kakaꞌan ni ña: —Tē nuu é ntaā i é Iꞌxa Xuva ko kúvin ne, nakōꞌxon kúñu ō, tsí uve naꞌa kakaꞌan Túꞌun Xuva kō: Taxnūu ña ánje ñā é kuēnta víi ña o. Kurkāa ña o vata koo é ña nákɨꞌɨ́n xuu. Kuān ó uve naꞌa —kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kakaꞌan Jésuu ni i: —Tsí uve naꞌa xtúku kakaꞌan Túꞌun Xuva kō: “Ñá ku koto ntēen Tóꞌo o, Xuva ō.” Kuān ó uve naꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kuēꞌen níꞌi xtūku tóꞌō e ña váꞌā san ña. Kúxēe ña uun xuku mi dóo dūkún ne, náñēꞌe ña un ntɨɨ́ ntɨ̄ɨ́ ñuu é īó ñuxiví sa. Ñá tē nté kaa váꞌā o. ");
INSERT INTO mizNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kakaꞌan tóꞌō e ña váꞌā san ni ña: —Te nākunchɨ́tɨn nūú ko, te kunuu inī ó ko ne, taꞌxi u é kadā kûꞌven un ntɨɨ́ ntɨ̄ɨ́ ñuú san —kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kidáā ne, kakaꞌan Jésuu ni i: —Kūnun, tóꞌō e ña váꞌā, tsí uve naꞌa kakaꞌan Túꞌun Xuva kō: “Da mii tsi Xuva kō é kunuu inī ó ña, da mii tsi tsīñu ña é vīin.” Kuān ó uve naꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kidáā né, xtūvi mii tóꞌō e ña váꞌā san ña ne, xéē ánje Xuva kō é viī ñá ña kuenta. ");
INSERT INTO mizNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dā téku Jesuu tsí nuu kutū Juaán ne, kuéꞌen ña ñūú Galilea. ");
INSERT INTO mizNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ntāka ña ñuú Nazaree é tuvi ñuú Galileá ne, kuéꞌen ñā é kutuvī ñá ñuú Capernau, é tuví diñɨ míni kaꞌnu san, etsin nú rāxa Zabúluun ni nú rāxa Néftalii. ");
INSERT INTO mizNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dukuan ō kúntaa é kākaꞌan ñá kaꞌán naa Xuva ko kídaā, ñá nani Isāia: ");
INSERT INTO mizNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñuú Zabuluún ni ñūú Neftalií ne, ñuu é ntoo etsin diñɨ míni kaꞌnu kān, uun xo diñɨ ntute kaꞌnu Jordaán san, ñuú Galilea, mí ntoo ñaꞌa, ña é ña te ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ñaꞌa, ña ntoo ikan mí nēé ni kuētsí i ne, īní ña ñuꞌu é kāxiꞌí nuu kaꞌnu. Ñaꞌa, ña ntoo ní ntatɨ dóxiꞌí ne, xiꞌí nuu kaꞌnu mí ntoo ña. Kuan ō kaꞌan Isáia. ");
INSERT INTO mizNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nté ntūvi tsikan éni ntuꞌu Jēsuu kakaꞌan ntódo ña: —Natɨvi iní nto, tsí dokó sa xee ntúvi é kixkadā kûꞌvé Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Dā íka Jesuu úun xo diñɨ míni Galileá san ne, īní ña Simuun, ña é kākaꞌan ña é Pedrú, ni enī ñá, Andree. Ntánakuītá nuu ñá xunu ña nú ntute kān, tsí ntátɨɨn ña tsákā. ");
INSERT INTO mizNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kakaꞌan Jésuu ni ña: —Kuntīkɨn ntó ko ne, taꞌxi ú nto tsiñu é kāna nto ñaꞌa é kuntīkɨn ñá ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ura tsí i xtúvī mii ña xunu ñá ne, íntīkɨn ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kuéꞌēn ká ña, ne, īní ña uvi ñāꞌá ka ñaꞌa, ñá nani Sāntiau ni ení ña Juaan. Ntuvi ña é iꞌxá Zebedeu ña. Ñúꞌu ña tun ntōó ni uva ñā, ntántaváꞌa ña xunu ña mí ntátsin. Kāna Jesuu ñá ne, ");
INSERT INTO mizNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ura tsí i xtúvī mii ña tún ntōó ña ni uva ñā ne, íntīkɨn ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Īka Jesuu kanɨ́ɨ ñūú Galilea, nakuāꞌa ña ñaꞌa san má ūkún ña Israee. Kakaꞌan ntódo ña túꞌūn vaꞌá san kuenta iña i é kixkadā kûꞌvé Xuva kō. Kantaváꞌa ña un ntɨɨ́ ntɨ̄ɨ́ kuiꞌi, un ntɨɨ́ ntɨ̄ɨ́ nuu i é kākuvi ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kūtuni ñáꞌa iña ñá kanɨɨ ñūú Siria ne, ntēka ña un ntɨɨ́ ntɨ̄ɨ́ ña nchokuví san, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña e ntákuvi kuiꞌi, o te ūꞌvi kúñu ñā, o te ñūꞌu e ña váꞌā nima ñá, o te kāxiꞌi míi ñā, o tē natɨ́ɨn ña ne, ntaváꞌa ña ña, un ntɨɨ́ ntɨɨ̄ ña. ");
INSERT INTO mizNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ñá te da dīi ñaꞌa intíkɨn ñá ña nté ñūú Galilea, nté ñūu é nani Ūꞌxi Ñúú ne, nté Jerusāleen, nté Jūdea, nté ñūu é ntoo uun xo diñɨ ntute kaꞌnu é nani Jōrdaan. ");
INSERT INTO mizNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dā íni Jesuu tsí ña te da díi ñaꞌá san ne, kuxée ña dɨkɨ ukú san. Dā itúvi ña ne, xéē ña ntántīkɨn ña mí tuví ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Eni ntuꞌu ñā nakuaꞌa ña ña, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Nté kuān nte vaꞌá ni ñāꞌa, ña é kūtuni i tsí ña kúvi vii ña te ña xntii Xuva ko ña, tsí ntáduku ntée ña mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ʼNté kuān nte vaꞌá ni ñāꞌa, ña nuu ntaꞌxa nima í, tsi náxnuu kaꞌnu Xuva kō nima ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ʼNté kuān nte vaꞌá ni ñāꞌa, ña é ña ntáde kaꞌnu, tsí kanɨɨ ñūxiví sa niꞌi ña kídaā. ");
INSERT INTO mizNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ʼNté kuān nte vaꞌá ni ñāꞌa, ña é kanɨɨ̄ nima í ncho kutúꞌve i iña Xuva ko, tsí kuéꞌe ña é kūtuꞌve váꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ʼNté kuān nte vaꞌá ni ñāꞌa, ña é kantuntāꞌví ini i taꞌan i, tsí ntuntāꞌví ini Xuva ko ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ʼNté kuān nte vaꞌá ni ñāꞌa, ña é ntūntoo nima í, tsi kiní ña Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ʼNté kuān nte vaꞌá ni ñāꞌa, ña é ntántukū é vāꞌá koo kuntoo ni tāꞌan i, tsí kaꞌan Xúva kō tsí dɨvi ñā é iꞌxā ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ʼNté kuān nte vaꞌá ni ñāꞌa, ña é ntántoꞌo i tsí kuíntiꞌxe ña Xuva kō, tsí ntáduku ntée ña mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ʼNté kuān nte vaꞌá ni ntō dá ntákaꞌan kíni ñaꞌa san íña nto, dá ntádē xení ña ni ntō, dá ntákaꞌan ña dovete e ntáde nto é kīni kaa da ntáde nto é ntio ko. ");
INSERT INTO mizNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kūntoo dínī nto, ñá ku kuntoo ntaꞌxa ntō, tsí niꞌi ntó doméni é vāꞌá kueꞌen e dukún kān, tsí kuān o dé xení ñaꞌa san ni ñá kaꞌán naa Xuva ko, ña intóo kídaā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ʼDɨvi ntō ne, vata ntáa ñɨɨ ntáa nto ñuxiví a. Ntá tsi tē ña tuví ka díkō ñɨɨ́ san ne, ña kúvi ntūváꞌa ka. Ñá vādá ka mí kaidiáꞌvi i. Kate ó ne, kaka nuu ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ʼVata ntáa ñūꞌu ntáa nto ñuxiví a. Tē uun ñuú tuví dɨkɨ uku kán ne, ña kúvi kutūvi xuꞌu. ");
INSERT INTO mizNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ntē ña kañíi ñaꞌa san kantílīn vata koo é xnuu xuꞌū ña má kɨdɨ. Tsí xkaa iko dukūn ña vata koo é nāxiꞌí nuu kanɨɨ̄ má viꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Vata ntáa ñūꞌu é kaxiꞌí nuu ntáa nto da ntáde ntō é vāꞌa. Kuan kōo vií nto é vāꞌá vata koo é na kīní ñaꞌa ne, na kāꞌan ñá tsi dóo kaꞌnu Xuva kō, ña tuví e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ʼÑá ku dē kuení nto te véꞌxī ú é nakuītá u lei Muíseé san ni tūꞌun é kāꞌan ñáꞌa, ña é kaꞌán naa Xuva ko kídaā. Ñá te vēxnákuītá u leí san, tsí véꞌxī ú é na kūntaa é kākaꞌan leí san. ");
INSERT INTO mizNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tsí nuu é ntaā i é kākaꞌán u ni ntō tsí da nté ntɨ̄ꞌɨ e dukún kān, da nté ntɨ̄ꞌɨ ñuxiví sa ne, ñá kunāa nté uun letra, nté uun puntu leí san da nté kūntaa ntɨ́ꞌɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Xoó ñaꞌa, ña é ña káde kuenta leí san, kuān te dií ka lúꞌntī né, kuān ó kanakuāꞌa ña tuku ñaꞌa é kuān koo vií ña dɨ́ ne, ñá tē neé nuu áꞌvi ña mí kadē kûꞌvé Xuva kō. Ntá tsi xoó ñaꞌa, ña é kāde ntaá leí san ne, kuān ó kanakuāꞌa ña ñaꞌa san é kuān koo vií ña dɨ́ ne, dōo kaꞌnu ñaꞌa ña mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kakaꞌán u ni ntō: ñá kɨ̄ꞌɨn nto mí tuví Xuva ko tē ña dií dií ka váꞌa koo vii nto é kāꞌan Xúva ko vatā ó ntáde ña fariseú san nī mastrú leí san. ");
INSERT INTO mizNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ʼIni nto tsí kakaꞌan ñátā san kídaā: “Ñá kaꞌnī ntó ñaꞌa, tsí xoo é kaꞌní i ñaꞌa ne, níꞌi ña e dóo ntoꞌo ña”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ntá tsi xuꞌú kakaꞌán u ni ntō né, tē xoó kudiin í ni tāꞌan i ne, níꞌi ña é ntōꞌo ña. Xoo é kākaꞌan i é kīni kaa iña taꞌan i ne, kuéꞌē ña tsiñu i é ntōꞌo ña. Xoo é kākaꞌan i tsí tuntu táꞌan i ne, kɨ́ꞌɨn ñā dôꞌvi kan. ");
INSERT INTO mizNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ʼTē kixtúvī ntó doméni ntaꞌa Xúva kō nú nāa ñá kān ne, kidáa nakaꞌan ntō é iō nuu i é kāꞌan ntée taꞌan nto nto ne, ");
INSERT INTO mizNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","xtuvī mii ntó doméní san nú nāá san ne, kueꞌēn nto mí tuví taꞌan nto. Diꞌna ntuváꞌa nto ni tāꞌan nto ne, kidáa kuēꞌé nto doméni ntaꞌa Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ʼTe kɨ̄ꞌɨn niꞌi taꞌan nto nto ntaꞌa ña tsíñu i ne, ntuváꞌa nto ni ña itsi kān, vata koo é ña tsiꞌi kuétsi ña nto ntaꞌa ña tsiñu i san. Tsí dɨvi ñā ne, káꞌan ña nī mau kui nuu ne, xnuu kutu ña ntō. ");
INSERT INTO mizNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tsí nuu é ntaā i é kākaꞌán u ni ntō tsí ña ntíi nto dā nte ntáꞌvi ntɨꞌɨ nto diuꞌun é katāvi nto. ");
INSERT INTO mizNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ʼÉ īni nto tsí kakaꞌán lei Muísee: “Ñá ku kukīdi niꞌi nto ñádɨ̄ꞌɨ é ña te ñádɨ̄ꞌɨ míi ntō”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ntá tsi xuꞌú kakaꞌán u ni ntō: Tē xoó ñaꞌa ntio ña é viī ña é kini kaa ni ñadɨ̄ꞌɨ dá kaito ña ña ne, vata te kīdi niꞌi ña ña, tsí edé kuení ña é viī ña é kīni kaa san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ʼTe ntūxnúu kuāꞌa nto kade i é viī nto é kīni kaa ne, tavá nto, dá nakuitā nto. Dií kaa váꞌā ó te kūnaá ntuxnūú nto é kɨ̄ꞌɨn ntó kanɨɨ̄ kúñu ntō dôꞌvi kan. ");
INSERT INTO mizNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te ntāꞌa kuaꞌa nto kade i é viī nto é kīni kaa ne, kaꞌnté nto, dá nakuitā nto. Dií ka váꞌā o é kūnaá ntaꞌa nto é kɨ̄ꞌɨn ntó kanɨɨ̄ kúñu ntō dôꞌvi kan. ");
INSERT INTO mizNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ʼKuān ó kakaꞌan ña intóo kídaā dɨ: “Xoó ñatīi é naxtuvī mii ña ñadɨꞌɨ́ ña ne, da miī é nakatsin ña tutú ña”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ntá tsi xuꞌú ne, kakaꞌán u ni ntō: Tē xoó ñatīí xtuvī mii ña ñadɨꞌɨ́ ña ne, tē ña ni ide ñadɨꞌɨ́ san é kini kaa ni tuku ñatīí ne, kaxéꞌe ñatīí san itsi é vīí ñadɨꞌɨ̄ ña é kīni kaa. Tē xoó ñaꞌa natántaꞌa niꞌi ña ñadɨ̄ꞌɨ́ san ne, kade ña é kini kaa ni ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ʼÉ tēkú nto dɨ dá kakāꞌan ñátā san: “Tē xeꞌé nto xuꞌu nto ni Xuva kō né, da miī é kāda ntaa nto”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ntá tsi kakaꞌán u ni ntō, ñá ku dotō tsí kakuniꞌi nto da nēé ka nuu i. Ñá ku dotō tsí kakuniꞌi ntō e dukún kān, tsí ikan kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ñá ku dotō tsí kakuniꞌi nto ñūxiví sa, tsí ñuxiví sa nteku ntiꞌi dɨꞌɨn Xuva kō. Ñá ku dotō tsí kakuniꞌi nto ñūú Jerusaleen, tsí ikān ñuú Rei, ña e dóo kaꞌnu. ");
INSERT INTO mizNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ñá ku dotō tsí kakuniꞌi nto dɨ̄kɨ nto, tsi nté uun idi nto ña kuvi vií nto é ntukuīꞌxín, o ntuntēe. ");
INSERT INTO mizNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dá ntákaꞌan ntó ne, da mii tsī é kāꞌan nto tsí kuvi ne, o ña kúvi. Tē nteku é kāꞌan ntó ne, kade nto é kanañēꞌe tóꞌō e ña váꞌā san nto é viī nto. ");
INSERT INTO mizNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ʼÉ tēkú nto tsí kakaꞌán lei Muísee: “Tē xoó tavā i ntuxnúū ntó ne, tavá nto ntuxnūú ña dɨ. Tē xoó tavā i núꞌu ntō ne, tavá nto núꞌu ñā dɨ”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ntá tsi xuꞌú ne, kakaꞌán u ni ntō tsí ña náā ntó nī ña kini ntáa san. Te kuēꞌé nuu ña vinuu ntó ne, kuéꞌe ntō é na kuēꞌé nuu ña é uun sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tē xoó kakiꞌni nteē í nto é kuētsi e kuéꞌe nto ña duꞌnu ntó ne, kuéꞌe nto ñā kutuun ntó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tē kade ñaꞌa é kuētsi kuido nto iña ñá uun sīin né, ikā ká kueꞌēn niꞌi nto íña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te da xōó ka ñaꞌa kaikan ñá nto ne, kuéꞌe ntō nee iña é kaīkan ña. Ñá ku dēvíni nto tē xoó ñaꞌa ncho nakiꞌi nteé ña iña nto. ");
INSERT INTO mizNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ʼÉ tēkú nto tsí kakaꞌan ñáꞌa: “Kuinima ntó taꞌan nto, ne, ña ku kuinima ntó ña kadē xení ni ntō”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ntá tsi xuꞌú kakaꞌán u ni ntō e kuinima ntó ña kadē xení ni ntō. Kaꞌan ntáꞌvī ntó iña ña é kainúu ntiꞌu nto. ");
INSERT INTO mizNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kidáā ne, kuvi ntiꞌxe nto iꞌxá Xuva kō, ña tuví e dukún kān. Tsí kataꞌxi Xuva kō é dadɨɨ tsi kaxiꞌí nuu ngantií san mí ntoo ñaꞌa, ña é vāꞌá, nī mí ntoo ñaꞌa, ña é kīni ntáa san, ne, kataxnūu ña é dadɨɨ tsi o kakɨɨn daví san mí ntoo ñaꞌa, ña é vāꞌá, nī mí ntoo ñaꞌa, ña é kīni ntáa san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Te da mii tsī kuinima ntó ñaꞌa, ña é kakuinima í nto ne, ¿míꞌi ntu nīꞌi nto é vāꞌá ntaꞌa Xuva kō? Kuān ó de ña ntaído diuꞌún san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te da mii tsi tāꞌan ntó kaꞌan ntó ni ñā ntiusí ne, ¿neé ntu é kāꞌan nto e dóo váꞌā ó kade nto? ¿Ñā ntu te kuán o de ñaꞌā, ña é ña ntákuintiꞌxe i Xuva kō dɨ? ");
INSERT INTO mizNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dɨvi ntō ne, vií nto é vāꞌá ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, vatā ó de Xuva kō, ña tuví e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ʼDá kāde nto nuu i é vāꞌá ne, ña kú de nto nūu ñaꞌa da ti é kāꞌan ñá tsi dóo vaꞌá ñaꞌa nto. Tsi kidáā ne, ña táꞌxi Xuva kō, ña tuví e dukún kān, doméni é kāduku ntée nto. ");
INSERT INTO mizNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Dukuān ne, dá kaxntii nto ña ntāꞌví san ne, ñá ku kaꞌān ntó ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa vatā ó de ñaꞌa é rkɨ xaa ña ntéku e ntákaꞌan ñá ni ñāꞌa má ūkún kān, méꞌñu itsi kān dɨ. Kuān ó de ña vata koo é kāꞌan ñáꞌa san tsi dóo vaꞌá ñaꞌa ña. Nuu é ntaā i é kākaꞌán u ni ntō, tsí e dɨ́vi tsi tsīkan doméni é nīꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ntá tsi dá kaxntii nto ña ntāꞌví san ne, nté ña váꞌa tiin niꞌi ntō ña ku ntáa nto ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Xntii xuꞌū ntó ña. Tsí ini Xúva kō neé ntáde xuꞌū ntó ne, dɨvi ña taꞌxī ña doméni é kāduku ntée nto. ");
INSERT INTO mizNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ʼDā ntákaꞌan ntâꞌví nto ne, ñá ku kaꞌān ntó vatā ó de ña ntaéni ntaꞌví san. Tsi dóo ntio ña é kuntitsī ña kaꞌan ntâꞌví ña má ūkún kān, méꞌñu itsi kān dɨ́, vata koo é kīní ñaꞌa san ña. Nuu é ntaā i é kākaꞌán u ni ntō tsí e dɨ́vi tsi tsīkan doméni é nīꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ntá tsi dá kakāꞌan ntâꞌví nto ne, kukunūu nto mí xoxó ñaꞌa ne, nakadɨ̄ ntó xiꞌí nto. Kidáā ne, diin diin tsi káꞌan ntâꞌví nto ni Xuva kō. Xuva kō ne, ini ña neé é diin diin tsi kade ntó ne, táꞌxi ñā é vāꞌá iña nto. ");
INSERT INTO mizNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ʼDá kakāꞌan ntâꞌví nto ne, ñá ku dotō tsí kaꞌan ntó vatā ó ntáde ñaꞌa, ña é ñá ini Xúva kō. Tsí tē dóo kiꞌin ito kāꞌan ña é dɨvi dɨvi tsī ne, kuétsī é tēkú Xuva ko ñā, kuiní ña. ");
INSERT INTO mizNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ñá ku kuān xkoó de nto, tsí Xuva kō ne, ini ña nee ntɨ́ꞌɨ ntɨꞌɨ kantio nto diꞌna dá kākan ntó ntaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Duꞌva koo kaꞌan ntâꞌví nto: Xuvā ntɨ é tuví nto e dukún kān, na nakuiko ñuꞌū ntɨ́ dɨvī nto. ");
INSERT INTO mizNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kixkada kúꞌvē ntó iñá ntɨ. Vií nto é ntio nto ñuxiví a, vatā tsi ó de nto e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tāꞌxi nto ita é kāꞌxí ntɨ é vīꞌa é uten, vatā ó ntántio ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kada kaꞌnu iní nto nī ntɨ kuétsī ntɨ́, vatā ó kade kaꞌnu iní ntɨ ni ñāꞌa, ña e ntáde é kini kaa nī ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ñá ku dā váꞌa ntō é ntōꞌo ntɨ́ ntaꞌa tóꞌō e ña váꞌā san, ntá tsi xntii ntō ntɨ é ña vií ntɨ é kīni kaa é ntio i é vīí ntɨ. Tsí dɨvi ntō é kadē kúꞌvē nto; dɨvi ntō e dóo iō nto é viī ntó ne, dɨvi ntō e dóo kaꞌnu nto ntii dañu ntūvi. Kuan tsi koo na kōo. Kuan kōo kaꞌan ntó ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ʼTsí te kāda kaꞌnu iní nto ni ñāꞌa dá ntáde ña é kini kaa ni ntō né, kada kaꞌnu iní Xuva ko ni ntō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ntá tsi tē ña kada kaꞌnú ini nto ni ñāꞌa dá ntáde ña é kini kaa ni ntō ne, ñá kada kaꞌnū iní Xuva ko ni ntō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ʼDá ntaíntoo ixu ntō ne, ñá kū xkuntóo ntaꞌxa ntó vatā ó de ña ntaéni ntaꞌví san. Ntánakoto ntaꞌxa ña vata koo é kūtuni ñáꞌa tsí ña ntaéꞌxi ña. Nuu é ntaā i é kākaꞌán u ni ntō tsí e dɨ́vi tsi tsīkan doméni é nīꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ntá tsi dá ntoo ixu ntō né, nekɨ̄n ntó dɨkɨ ntó ne, kɨtɨ nto dɨ, ");
INSERT INTO mizNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","vata koo é ña kutúni ñáꞌa san é ña ntaéꞌxi nto. Tsí Xuva kō ne, ini ñá nēe é diin diin tsi ntáde ntó ne, niꞌi nto é vāꞌá ntaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ʼÑá ku nātee kuitɨn nto é vāꞌá iña nto ñuxiví a, tsí iꞌa ne, kaduku tɨ ne, ō kakuduꞌxe káa nto ne, ō teꞌú ne, ō kɨꞌɨn duꞌu. ");
INSERT INTO mizNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ntá tsi natee kuitɨn nto é vāꞌá iña nto e dukún kān. Tsí ikān ne, ña túvi kɨtɨ é duku tɨ iña nto, ntē ña téꞌu, ntē xoxó ña duꞌu é kiꞌi dúꞌu ña iña nto. ");
INSERT INTO mizNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tsí dā míꞌī ká ñuꞌu váꞌa é vāꞌá iña ntó ne, ikān tuví nima ntó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ʼNtuxnúu kō ne, vata kaa ñuꞌu é kāxiꞌí nuu kúñu ko kāa. Te vāꞌá ntuxnūú nto ne, kanɨɨ̄ kúñu nto kāxiꞌí nuu. ");
INSERT INTO mizNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ntá tsi tē ña váꞌa ntuxnūú nto ne, kanɨɨ̄ kúñu nto ñɨnēe. Te ñūꞌú san kuneé ne, kuneé kueꞌen. Ñɨnēé kueꞌen kúñu ntō. ");
INSERT INTO mizNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ʼÑa kúvi kada tsiñu o ni ūvi ñaꞌa tóꞌo kō é uun kaa tsi. Tsí te ntio ko ñá uun ña ne, ñá uun sán ne, ñá ntīo ko ña. Tsí uun ñaꞌa ña ne, kuiko ñuꞌu o ñā; ñá uun sán ne, ñá kuiko ñuꞌu o ñā. Dukuān ne, ña kúvi kada tsiñu ō é nɨɨ̄ kuéꞌen ini ko īña Xuva kó te dadɨɨ tsi kadā kuení ko nté koo kukuika ō. ");
INSERT INTO mizNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ʼDukuān ne, kakaꞌán u ni ntō: Ñá ku dē kuení nto ntuvi iña nto, míꞌi kīꞌxi é kōꞌo é kāꞌxi nto, míꞌi kīꞌxi doo é kunūu nto. ¿Ñā ntu te dií dií ka nuu áꞌvi ntuvi iña nto é vata kaa e é kāꞌxi nto? ¿Ñā ntu te dií dií ka nuu áꞌvi kúñu ntō é doo san é kunūu nto? ");
INSERT INTO mizNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Koto nto láa, kɨtɨ ntaíko e dukún kān. Ñá tē ntaítu tɨ, ntē ña te ntátaꞌvi tɨ. Ña túvi xāka tɨ mí ñuꞌu váꞌa é kāꞌxi tɨ. Ntá tsi kaxéꞌe Xuva kō, ñá tuví e dukún kān, e ntaéꞌxi tɨ. ¿Vá dií ka ntu nuu áꞌvi a láa san é dɨvi ntō? ");
INSERT INTO mizNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Vá kūvi vií ntu nto é kuēꞌnu ká nto te dāva métru, kuān te dóo kutsuꞌun ntō? ");
INSERT INTO mizNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ʼ¿Nté kui kuān nte ntádē kuení nto nēe é kunūu nto? Koto nto itá laa san nté ō ntaéꞌnu má kūꞌu kan. Ntē ña ntáde tsiñu, ntē ña ntákanɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ntá tsi nté rei Salamuun ña ni xío doo ña e dóo vaꞌá vata kaa laa sán, kuān te dóo kuika ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tē xeꞌé Xuva kō é kuān nte váꞌa ito laa san é kāntíto vevií ne, utén koko meꞌñú ñuꞌu kán ne, ¿ñā ntu te dií dií ka taꞌxi ña é kunūu nto, ntoꞌo é ña ini kuintíꞌxe ntiꞌxe nto? ");
INSERT INTO mizNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dukuān ne, ñá ku kutsuꞌun ntō, ñá ku kaꞌān nto: “¿Míꞌi ntu kīꞌxi é koꞌo ō, é kāꞌxi o? ¿Míꞌi ntu kīꞌxi é kunuu kutāvi o?” Ñá ku kuān xkoó kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tsí ñaꞌa, ña e ñá ini Xúva kō ne, ntánantuku ña ūn ntɨɨ́ ntɨ̄ɨ́ nuu i sáꞌa. Ntá tsi ini Xúva kō, ña tuví e dukún kān, tsí ntátaan núu nto un ntɨɨ́ ntɨ̄ɨ́ nuu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ntá tsi diꞌna ntukū nuu iní nto é nantuku ntō é kadē kûꞌvé Xuva kō ne, vií nto é vāꞌa é ntio ña. Kidáā ne, taꞌxi ña un ntɨɨ́ ntɨ̄ɨ́ nuu i é ntátaan núu nto. ");
INSERT INTO mizNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dukuān ne, ñá ku ntɨꞌɨ inī nto nté koo vií nto uten, tsí utén ne, īó ka ntuvi é ntɨꞌɨ iní nto. Tsí utén utén ne, xée miī é ntɨꞌɨ iní nto nēe é viī nto. ");
INSERT INTO mizNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ʼÑá ku kāꞌan ntée nto tuku ñaꞌa, vata koo é ña kaꞌan ntée ña nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tsí vata tsī ó kakaꞌan ntée nto tuku ñaꞌa ne, kuan kōo kaꞌan ntée ña nto dɨ. Vatā ó kakii kúꞌvē ntó ne, kuan koo kuntēkú kūꞌve ntó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Nté kui kaiton ntun utsi xákā é nuu ntuxnūú taꞌan o ne, ñá kaīton ntuꞌu é nuu ntuxnúu o? ");
INSERT INTO mizNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Te kāꞌán ni tāꞌan o: “Tāꞌxin ntuxnúu o, na nātavá u utsi xákā é nūu san”, koo kaꞌan, ntá tsi ¿míꞌi ntu kūvi kinin é natāvan, tsí ntuꞌu san núu ntuxnúu o? ");
INSERT INTO mizNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Dɨvīn é kaeni ntaꞌvín, diꞌna natāván ntuꞌu é nūu ntuxnúu o ne, kidáa kūvi kinin é natāván utsi xákā san é nuu ntuxnūú taꞌan o. ");
INSERT INTO mizNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ʼÑá ku kuēꞌé nto tínā sán nuu i e kúviko san. Tē ñaꞌá ne, tɨɨn tɨ nto. Ntē ña ku xéꞌe nto kutsín san xoꞌo kɨtɨ e áꞌvi san, tsí kaka nuu tɨ. Kidáā né, ntuku kuiꞌī tɨ́ nto. ");
INSERT INTO mizNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ʼKákan nto ntaꞌa Xuva kō ne, níꞌi ntō. Nantuku ntō né, naniꞌi nto. Nakeꞌxen ntō xiꞌí ne, nakaán ña é kɨ̄ꞌví nto. ");
INSERT INTO mizNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Da xōó ka ñaꞌa é kakan ña ne, niꞌi ña. Da xōó ka ñaꞌa é nantuku ñā ne, níꞌi ñā. Da xōó ka ñaꞌa é nakeꞌxen ñā xiꞌí san ne, nakaan. ");
INSERT INTO mizNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ʼ¿Vá iō ntú nto, te kaīkán iꞌxá nto tañúꞌū ne, vá xūu ntu kuéꞌe nto i? ");
INSERT INTO mizNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O te kākán tsákā ne, ¿vá kōo ntu kuéꞌe nto i? ");
INSERT INTO mizNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ntōꞌo é kīni kaa nima ntó ne, kaxéꞌe nto é vāꞌá iꞌxá nto. ¿Ñā ntu te dií dií ka taꞌxi Xuva kō, ña tuví e dukún kān, é vāꞌá, tē xoó kakan í ña? ");
INSERT INTO mizNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ʼDa nēé ka nuu i é ntio nto é vīí ñaꞌa ni ntō né, kuan kōo vií nto ni ñā dɨ. Tsi sáꞌa kakāꞌan lei Muísee, ni ña ntákaꞌán naa Xuva ko kídaā. ");
INSERT INTO mizNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ʼKūkɨ́ꞌvi nto xiꞌi é ña niꞌí san. Tsi dóo nīꞌí xiꞌi é kañeꞌe dôꞌvi kan. Ñá tē neé ntii tūꞌun é kɨ̄ꞌɨn o itsi tsíkan ne, ñá te da dīi ñaꞌa ntáñeꞌe ña ikān. ");
INSERT INTO mizNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ntá tsi ña te niꞌí xiꞌi mí kuīta ntíꞌxin ō é nīꞌi ko ntuví vaꞌá iña ko. Dōó ntii tūꞌun é kɨ̄ꞌɨn o itsí sāꞌá ne, ñá tɨ̄tɨ́n ñaꞌa ntánanīꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ʼKuenta tsí vií nto ña e ntákaꞌán naa Xuva ko, ña é ña te nuu é ntaā i ntákaꞌan. Ntio ña é kadā kuení nto é vāta ntáa leꞌntu ntáa ña, ntá tsi nima ñá ne, vata ntáa tína kūꞌu ntáa. ");
INSERT INTO mizNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kutuni ntó nee ñáꞌa ntiꞌxe ña tē íni nto nté o de ña. ¿Vá ntákii ntu tɨntiꞌo xoꞌo iñū? ¿Vá ntákii ntu kɨtɨ ígu tun veñuu? ");
INSERT INTO mizNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Te vāꞌá utun sán ne, váꞌā kɨtɨ i. Tē ña váꞌa utun sán ne, ñá vāꞌá kɨtɨ i dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Te vāꞌá utun sán ne, ña kíi kɨtɨ é ña váꞌā. Tē ña váꞌa utun sán ne, ña kíi kɨtɨ é vāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Da nēé ka utun é ña kakíi kɨtɨ vaꞌá ne, nakɨɨn ō né, kaꞌmi ō. ");
INSERT INTO mizNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dukuān ne, kutuni ko nté kaa utun san te kīi kɨ́tɨ i. ");
INSERT INTO mizNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ʼKuān te dóo tɨtɨ́n ñaꞌa ntákaꞌan ña e Tóꞌo ñā ko, ntá tsi ña te un ntɨꞌɨ ña xēe ñá ntaꞌa Uva kō. Da mii tsī ña e dé ntaa é kākaꞌan Úvā ko, ñá tuví e dukún kān, é xēe ña. ");
INSERT INTO mizNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ntuvi tsikán ne, ñá te da dīi ñaꞌa káꞌan ñá nī ko: “Tōꞌó ntɨ, ntɨꞌɨ́ ne, káꞌān ntɨ́ kuenta iña ntó ne, nakúnū ntɨ́ é ña váꞌa kuēnta iña nto. Nuu i é dóo naꞌnu é idé ntɨ kuenta iña ntó dɨ”, koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kidáā ne, káꞌān ú ni ñā: “Xuꞌú ne, ñá īní u nto. ¡Koo xio nto, tsí ña váꞌā ó ni ide nto!”, koo kaꞌán u ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ʼDá xōó ka ñaꞌa é kātekú i é kākaꞌán u, te kāda ntaa ña túꞌūn é kākaꞌán u ne, vata kaa ña e dóo kiꞌin inī í kaa ña, ña é xntītsí viꞌi i nú xuú san. ");
INSERT INTO mizNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dá kɨ̄ɨn davi nuꞌú san ne, ēꞌnu ntute san. Un váꞌa tsi ínu tatsín ne, dúku nūu tatsín san nú viꞌi ña kān, ntá tsi ña ni kɨ́ɨn viꞌí san, tsí ntitsi kutu nú xūú san. ");
INSERT INTO mizNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Dá xōó ka ñaꞌa, ña é kātekú i é kākaꞌán u ne, ntá tsi ña káde ntaa ña túꞌūn kó ne, vata ntáa ña tuntu ntáa ña, ña é xntītsí viꞌi i nú ñutɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dā kɨ́ɨn davi nuꞌú san ne, ēꞌnu ntute. Un váꞌa tsi īnu tatsín ne, dúku nūu tatsín san nú viꞌi ña kān ne, uun ito tsī kɨ́ɨn. Kūnaá kueꞌen viꞌi ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Dā kúvi kaꞌan Jésuu sáꞌā ne, koó dā kúduꞌva ñaꞌa san é kuan ō nakuaꞌa ña ña, ");
INSERT INTO mizNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tsí nakuaꞌa ña ña vatā ó kanakuāꞌa ñaꞌa, ña e dóo kiꞌin inī i. Ñá te ni nakuaꞌa ña ña vatā ó de mastrú leí san. ");
INSERT INTO mizNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Dá kūntíi Jesuu xúku san ne, ñá te da dīi ñaꞌa intíkɨn ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Xée ūun ñaꞌa, ña kanakóꞌxo kúñu ī, mí tuví ña ne, ínchɨtɨ ña nūu ñá, kakaꞌan ña: —Tōꞌó, tē ntio nto ne, kuvi ntaváꞌa nto ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nákāa Jesuu ntaꞌa ñá ne, tɨɨn ntaꞌa ña ñā ne, dá kakāꞌan ña: —Ntio ko. ¡Ntuváꞌan! —kaꞌan ña. Ura tsí i ntuváꞌa ña ne, ntɨ̄ꞌɨ kuiꞌí san. ");
INSERT INTO mizNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kakaꞌan Jésuu ni ña: —Kuenta tsí viin. Ñá ku kāꞌan ni ñaꞌa nté o kuvi o, ntá tsi kuēꞌen mí tuví dutú san, nañēꞌen ña kúñu ō. Da kidáa kuēꞌén doméni iña Xuva ko é kākaꞌan lei Muísee, vata koo é kūtuni ñáꞌa san tsi é ntuváꞌan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dā xee ñá ñuú Capernaú ne, xéē tóꞌō é uun sientu sntadún san mí tuví ña ne, ");
INSERT INTO mizNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kakaꞌan ñá ni ñā: —Tōꞌó, tuví ña kade tsiñu iñá ko nú viꞌī kó kān ne, nautun ña. Ñá tē nté kaa kantoꞌo ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kidáā ne, kakaꞌan Jésuu ni ña: —Kɨ́ꞌɨ̄n u, dá ntaváꞌā ú ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ntá tsi kakaꞌan tóꞌō sntadún san ni ñā: —Tōꞌó, ñá tē neé nuu áꞌvī u é kɨ̄ꞌɨn nto nú viꞌī kó kān. Te da mii tsī é kaꞌan ntó ne, ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Xuꞌú ne, īó ña kade kúꞌve iña kó ne, kade ú tóꞌō sntadún san dɨ. Te kāꞌán u ni ūun ñaꞌa é na kɨ̄ꞌɨn ñá ne, kɨ́ꞌɨn ntīꞌxe ña. Te kāꞌán u ni tūku ñaꞌa é kīꞌxi ña ne, kiꞌxi ntiꞌxe ña. Te kāꞌán u nī ña kade tsiñu iñá ko é viī ñá tsiñu tsikán ne, kada ntaa ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Da kúduꞌva Jesuú da téku ña é kākaꞌan tóꞌō sntadún san ne, kakaꞌan ñá nī ña ntántīkɨn ña: —Nuu é ntaā i é kākaꞌán u ni ntō. Váta kīní u uun ñaꞌa, ña e dóo kakuintíꞌxe i, nté ña ñuú Israee. ");
INSERT INTO mizNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ne, kaꞌán u ni ntō tsí tɨ̄tɨ́n ñaꞌa kiꞌxi ña da míꞌī ká ñuú ñuxiví san é kuntoo ña, kaꞌxí dadɨɨ ña ni ñata ika ko Ābraan ni Ísaa ni Jácoo nú mēsa mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ntá tsi ñaꞌa, ñá kuini i é duku ntée ña kuntōo ña mí kadē kûꞌvé Xuva kō ne, nakuītá nuu Xuva ko ñā mí dií ka ikā, mí dóo nee. Ikān e kueku ña ne, nakaꞌxí kaꞌñɨ̄ ña núꞌu ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kidáā ne, kakaꞌan Jésuu ni tóꞌō sntadún san: —Kunúꞌun. Kuan koo na kūví vata tsī o kuíntiꞌxe o —kaꞌan ña. Ura dúꞌva tsi i ntuváꞌa ña kade tsiñu iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Dá kūkɨ́ꞌvi ña má viꞌī Pedru kán ne, īní Jesuu é tuví ntaa ñuntɨ́ɨ Pedrú san e dóo kaxéꞌe ña kaꞌni. ");
INSERT INTO mizNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kidáā né, tɨɨn ntaꞌa Jēsuu ntáꞌa ña ne, ura dúꞌva tsi i ntikó ña kaꞌni sán ne, dā nakuntítsi ña, de váꞌa ña é kāꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dā kuáa vaꞌá ne, xée ñāꞌa san mí tuví Jesuu. Dōó tɨtɨ́n ñaꞌa ntánteka ña ña é ñūꞌu é ña váꞌā nima i. Jesuú ne, uun tsi túꞌun ñā nakuíta ña é ña váꞌā san ne, ntāváꞌa ña ña nchokuví san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kuan ō kúvī vata koo é kūntaa é kākaꞌan Ísaia, ña é kaꞌán naa Xuva ko kídaā: “Mii ñā é ntāꞌa ña kuiꞌi ko ne, mii ñā ído ñā nuu i é ntántoꞌo kō”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Dā íni Jesuu tsí ña te nté kaa ñaꞌa ntátavi núu ña ña ne, kakaꞌan ña tsí kɨꞌɨn ña, kuita ntiꞌxin ña uun xo diñɨ mínī san. ");
INSERT INTO mizNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Xée ūun mastrú leí san, ne, kakaꞌan ñá ni ñā: —Mastrú, kuntīkɨ́n u nto dā míꞌī ka mí kɨ̄ꞌɨn nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kakaꞌan Jésuu ni ña: —Xteé san ne, īó mâvi tɨ mí kaintoo váꞌa tɨ. Lāá, kɨtɨ ntaíko e dukún kān né, īó taka tɨ mí kañuꞌu váꞌa tɨ dɨ. Ntá tsi xuꞌú é vēxkúvī ú ñatīí ne, ña túvī mí kutūví daꞌna dɨkɨ́ ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tuku ña ntɨniꞌi ñā né, kakaꞌan ñá ni ñā: —Tōꞌó ntɨ, taꞌxi nto é diꞌna kikuꞌxí u uvā kó ne, da kidáa kuntīkɨ́n u nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ntá tsi kakaꞌan Jésuu ni ña: —Kuntīkɨ́n ko. Xtuvīn miin ñá ntɨ̄xɨ́ san, na kūꞌxí taꞌan ña ña ntɨ̄xɨ́ niꞌi ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kidáā ne, ñúꞌu ña tun ntōó san nī ña ntántīkɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Un váꞌa tsi ínu tatsín san kídaa, dā nté kūkɨ́ꞌvi ntute san iní tun ntōó san. Ntá tsi kakidi Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kuéꞌēn ña ntántīkɨn ñá ne, nantóto ña ñā, ntákaꞌan ña: —¡Nakakū ntó ntɨ, Tóꞌō ntɨ, tsí doko sa téni ō! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kakaꞌan Jésuu ni ña: —¿Nté kui ntaúꞌvī ntú nto? ¿Nté kui ña kueꞌe ntu ntákuintiꞌxe nto? —kaꞌan ña. Kidáā ne, nákuntītsí ña, kakaꞌan ñá ni tātsín san ni ntūte sán ne, kūkadin. ");
INSERT INTO mizNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Koó dā kúduꞌva ña ñuꞌu tun ntōó san, ntátsixeꞌe tāꞌan ña: —¿Neé ntu ñaꞌa ña sāꞌa? Tsí un tsi nte tátsín san ni ntūte san kade ntaa é kākaꞌan ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Dā xee ñá uun xo diñɨ ntute san mí tuví ñuu é nani Gādará ne, úvi ñatīi ntíi ña nú ñaña kapūsantu kán ne, xée ētsin ña mí tuví Jesuu. Ñúꞌū é ña váꞌā san nima ñá ntuvi ñá ne, dōo diin ña. Ntaûꞌví ñaꞌa san é kuīta ntíꞌxin ña mí ntoo ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ntákachuꞌu ntáa ñatīí san, ntákaꞌan ña: —¿Ntē ntú koo vií nto nī ntɨ́, Iꞌxá Xuva kō? ¿Vēxnántoꞌo ntu nto ntɨ́ diꞌna dá xēe ntúvi ī é ntōꞌo ntɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Daꞌa sán ne, ñuꞌu kutsin, ntaéꞌxi tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ntaíkan é ña váꞌā san da xeꞌe ntaꞌa Jésuu: —Te nakuitā ntó ntɨ ne, taꞌxī nto é kɨ̄ꞌví ntɨ nima kútsín san —kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kakaꞌan Jésuu: —Kuēꞌen —kaꞌan ña. Ne, ntīi é ña váꞌā san nima ñátīí san, kúkɨ̄ꞌví nima kútsín san. Un ntɨɨ́ ntɨ̄ɨ́ kutsín san ínu tɨ, kueꞌen tɨ́ xɨꞌntɨ kán, ne, nákōꞌxó nuu tɨ kúñu tɨ̄ nu mínī san. Ikān ténī ntɨɨ́ ntɨɨ̄ tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Īnu ña ntáde kuenta kútsín san, kunúꞌu ñā ñuú ña kān ne, kaꞌan ntáa ñá ni ñāꞌa san un ntɨꞌɨ̄ e kúvi, nté ō kúvi ni ñāꞌa, ña é ñūꞌu é ña váꞌā san nima i. ");
INSERT INTO mizNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Un ntɨɨ́ ntɨ̄ɨ́ ña ñuú i sán ne, xée ñā mí tuví Jesuu. Dā íni ña ña ne, ntákaꞌan ñáꞌa san ni Jésuu, na viī ñá da xeꞌe, na ntāka ña ñuú tsikan. ");
INSERT INTO mizNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kidáā ne, ínūu Jesuu tún ntōó ne, ítā ntiꞌxin ña mínī sán ne, náxee ña ñuú miī ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kidáā ne, xee níꞌi ñāꞌa san uun ñaꞌa, ñá xiꞌi dáva kúñu ī, ntekú ña chidō. Dā íni Jesuu tsi dóo ntákuintiꞌxe ña vexníꞌi ñā sán ne, kakaꞌan ñá nī ñá xiꞌi dáva kúñu ī san: —Ō dáꞌ, naxnuu ini o, tsí e dé kaꞌnu iní u ni ō kuétsi ō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ntá tsi mastrú leí san ne, dē kuení mii ñā: “É kuān ó kakaꞌan ñá sāꞌá ne, dotō tsí kakaꞌan ña túꞌūn é da mii tsi Xuva ko kūvi kaꞌan ña”, dé kuení ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ntá tsi ini Jésuu neé ntádē kuení ña, ne, kakaꞌan ña: —¿Nté kui dóo kīni o ntádē kuení ntu nto? ");
INSERT INTO mizNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Nee iña é dií ka ña ntii tuꞌun é kāꞌán u, te kuinī ntó, ō é kāꞌán u: “Kada ntaa kaꞌnu iní u kuétsi ō”, ō é kāꞌán u: “Nakuntítsin ne, kakan ve”? ");
INSERT INTO mizNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ntá tsi ntio ko é kūtuni nto tsí kuvi vií u, xuꞌu é vēxkúvi ú ñatīi, é kāda kaꞌnu iní u kuétsi ntō ñuxiví a —kaꞌan ña. Kidáā ne, kakaꞌan ñá nī ñá xiꞌi dáva kúñu ī san: —¡Nakuntítsin ne, nakiꞌin chido ō né, kūnúꞌun nú viꞌi o kān! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kidáā ne, nákuntītsí ña, kunúꞌu ña nú viꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dā íni ñaꞌa san sáꞌā né, dōo uꞌví ña. Ntákaꞌan ña tsi dóo kaꞌnu Xuva kō é xēꞌé ña é kūvi vií ñaꞌa san vatā o dé Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Dā ntáka Jesuu íkān ne, kuéꞌēn ká ña. Īní ña uun ñatīi, ñá nani Māteu. Tuví ña mí kaido ña diuꞌun xôó san iña ñá ñuú Roma. Kakaꞌan ñá ni ñā: —Kuntīkɨ́n ko —kaꞌan ña. Nákuntītsí Mateú san ne, kuéꞌen ña kūntikɨn ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Uun ito ne, dá tuví Jesuu má viꞌi kān ne, ñá te da dīi ña ntaído diuꞌun xôó san xee ña, ni tuku ñaꞌa, ña kini ntáa dɨ. Dadɨɨ tsi intóo ña nú mēsa ni Jésuu ni ña ntántīkɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dā íni ña fariseú san ne, tsixeꞌe ñā ña ntántīkɨn Jésuu: —¿Nté kui ntaéꞌxi dadɨɨ ntú mastru ntó san nī ña ntaído diuꞌun xôó san ni ña iō kuetsí i san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Dā téku Jesuú ne, kakaꞌan ñá ni ñā: —Ña é vāꞌá o ni ī ne, ña ntántio ña medíkū; mii tsī ña ntánchokuví san. ");
INSERT INTO mizNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kueꞌēn ntó ne, nakuāꞌa nto túꞌūn saꞌa, vata koo é kūtuni nto nee iñá ncho kaꞌan sáꞌā: “Ñá tē doméni é ntio ko, tsi é ntīo kó ne, na ntūntaꞌví ini nto taꞌan nto.” Kuan ō kaꞌan Xúva kō. Tsí xuꞌú ne, ñá te ñaꞌa é vāꞌa véxnantuku ú, tsí ñaꞌa é iō kuetsí i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kidáā ne, xéē ña ntántīkɨ́n Juaán san mí tuví Jesuú ne, tsixeꞌe ña ñā: —¿Nté kui ntɨꞌɨ́ nī ña fariseú san ne, ntaíntóo ixū ntɨ, ntá tsi ña ntántīkɨn ntó ne, ña ntáde ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —¿Vá kuntoo ntaꞌxa ntu ña kaxee viko mí tántaꞌa ñaꞌa dá tuví dukuān ña tántaꞌa san ni ñā? Tsi xée ūra i é ntāka ña tántaꞌa san mí ntōo ña ne, kidáā né, kuntoo ixu ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ʼTe nāteé nuu ō doo tsudé ne, ñá nāxnteé nuu o doo é vāta natɨ́xɨ̄ duꞌnu áta kō mí ntátsin, tsí ntatsin xtuku te natɨxɨ̄ doo xée sán ne, dií dií ka kukueꞌe ntatsin. ");
INSERT INTO mizNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ntē ña tsuꞌun o ntute tɨ́ntiꞌo xee ini tsáꞌa atā e kúvi ñɨɨ, tsí ntatsin ñɨɨ sán ne, katɨ ntɨꞌɨ ntute tɨ. Nté ñɨ̄ɨ san ña kaidiáꞌvi ká i dɨ. Tsí tsuꞌun o ntūte tɨntiꞌo xee ini tsáꞌa ñɨɨ xēé, vata koo é xntii ntuvi nuu i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Da nɨɨ kākaꞌan Jésuu ni ñá ne, xée ūun ñaꞌa ña tsiñu i, inchɨ́tɨ ña nūu Jésuú ne, kakaꞌan ña: —Dā ve xíꞌi a diókō ko. Ntá tsi te kīꞌxi nto ne, te tɨɨn ntaꞌa nto ī né, ntoto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nákuntītsí Jesuú ne, kuéꞌen ñā kántīkɨn ñá ña, ni ūn ntɨɨ́ ntɨ̄ɨ́ ña ntántīkɨn ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kidáā ne, véꞌxi uun ñadɨ̄ꞌɨ́ ata Jesuu. Ñadɨ̄ꞌɨ́ san ne, é ūxuvi kuía é kaetɨ nɨñɨ ña. Xée ētsin ña ata Jésuú ne, tɨɨn ntaꞌa ña ntēte doo ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tsí dé kuení ña: “Te da mii tsi dūꞌnu ña tɨɨn ntáꞌa ú ne, ntuváꞌa u”, kuini ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Xkokōto Jésuu áta ñā ne, īní ña ña. Kakaꞌan ñá ni ñā: —Ō dáꞌ, naxnuu ini o, tsi é ntuváꞌan, tsi kuíntiꞌxe o ko —kaꞌan ña. Ne, ura dúꞌva tsi i ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Dā xee Jésuu nú viꞌī ña tsiñu i sán ne, īni ña ña ntánakueku san; tēkú ña é kō da ntákachuꞌu ntáa ñaꞌa san ntaéku ña ne, ");
INSERT INTO mizNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","kakaꞌan ñá ni ñā: —Koo xio nto. Ñá te ni xīꞌí tun; kūdii kakidí tun —kaꞌan ña. Da xkuntée ñaꞌa san Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ntá tsi dā kíñuꞌu ña ñaꞌa san kíꞌi kān ne, kúkɨ̄ꞌví ña má viꞌi kān ne, írkāa ña ntaꞌa tún ne, nákuntītsí tun. ");
INSERT INTO mizNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kidáā né, kūtuní un ntɨɨ́ ntɨ̄ɨ́ ña ñuú i é ntoo etsin nté ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dā ntáka Jesuu íkān ne, uvi ñáꞌa, ña kuāá, kuntīkɨn ñá ña, ntákana ña ña: —¡Ntūntaꞌví ini nto ntɨ́, Iꞌxá ika Dāvii! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dā ita ntíꞌxin Jesuú san má viꞌi kān ne, xée etsin ña kuāá san mí tuví ña. Kakaꞌan Jésuu ni ña: —¿Ntákuintiꞌxe ntu nto e kuvi vií u sáꞌā? —kaꞌan ña. —Ntákuintiꞌxe ntɨ́ nto, Tóꞌō ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kidáā ne, tɨɨn ntaꞌa ña ntuxnūu ñá, kakaꞌan ña: —Na kūví vata tsī ó ntákuintiꞌxe nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kidáā né, nāxiꞌi ntuxnúu ña. Dōó kaꞌan Jésuu ni ña: —Kuenta tsí vií nto vata koo é ña kutúni ñáꞌa san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ntá tsi ura tsí i dá kunúꞌu ña ne, eni ntuꞌu ñā ntákaꞌan ñá ni ūn ntɨɨ́ ntɨ̄ɨ́ ña ñuú tsikan nté ō dé Jesuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dā ve tsi ntáka Jesuu ni ña ntántīkɨn ñá ne, xee níꞌi ñaꞌa san uun ña ñɨꞌɨ, ña nuu é ña váꞌā nima i. ");
INSERT INTO mizNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dā nakuíta Jesuu é ña váꞌā san ne, nākaꞌan ñá ñɨꞌɨ san. Koó dā kúduꞌva ñaꞌa sán ne, ntákaꞌan ña: —¡Nté uun ito vata kíni o é kuan koo kūvi ñuú Israee! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ntá tsi ña fariseú san ne, ntákaꞌan ña: —Kūdii tóꞌō e ña váꞌā san kaxeꞌe é kūvi vií ña sāꞌá nakuitā ñá é ña váꞌā san —kaꞌan ñá iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Īka Jesuu un ntɨɨ́ ntɨ̄ɨ́ ñuú kuetsi ni ūn ntɨɨ́ ntɨ̄ɨ́ ñuú naꞌnu, kanakuāꞌa ña má viꞌī mi ntánataká nuu ña Israeé san, kakaꞌan ntódo ña túꞌūn é vāꞌá san iña mí kadē kûꞌvé Xuva kō. Kantaváꞌa ña da nēé ka nuu i kuíꞌi e ntákuvi ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Dā íni ña é ña te da díi ñaꞌá san ne, ntūntaꞌví ini ña ña tsi dóo ntántoꞌo ña é xoxo káde i ña kuenta. Vata ntáa leꞌntu é xoxo páxtu tɨ ntáa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesuú ne, kakaꞌan ñá nī ña ntántīkɨn ña: —Dōó iō ñáꞌa é vāta tekú ña túꞌun Xuva kō, ntá tsi ña tɨtɨ́n ñaꞌa ña ntákaꞌan ntódo san. Vata ntáa matu e dóo kuáan ne, xōxó kueꞌe ñáꞌa é taꞌvi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Dukuān ne, kákan ntō Tóꞌo ītú san na taxnūu ña ñaꞌa, ña ntáde tsiñu, e kitáꞌvi ña ītú san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kāna Jesuu úxuvi ñáꞌa, ña é vīí pustru ñá ne, xéꞌe ñā é kuvi nakuitā ña é ña váꞌā san, é kūvi ntaváꞌa ña ñaꞌa san un ntɨɨ́ ntɨ̄ɨ́ nuu i é ntákuvi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Duꞌva nanī pustru, ña é uxuví san: ña é kuvi ūun ne, Simuun ña (Pedru nani ñá dɨ), ni enī ñá, Andree; ni Sāntiaú, ni enī ñá, Juaan, ntuvi íꞌxá Zebedeu; ");
INSERT INTO mizNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, ni Bártulu, ni Tūmaá, ni Māteu, ñá kaido diuꞌun xôo; ni Sāntiau, iꞌxá Alfeú, ni Tādeú, ");
INSERT INTO mizNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ni Sīmuun, ñá kaduku ntée ña uve taꞌan Zelote, ni Júda Iscāriote, ña é dīko Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Taxnūu Jesuu ña é uxuvi ñáꞌa san ne, kakaꞌan ñá ni ñā: —Ñá ku ñeꞌē nto mi ña ntákuintiꞌxe ña Xuva kō; ntē ña ku ñeꞌé nto mí ntoo ña Samariá san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ntá tsi kueꞌēn nto mí ntoo ña Israee, ña é vāta ntáa a leꞌntu é kunaa ntáa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Da nɨɨ̄ ntaíka nto ne, káꞌan ntōdó nto tsí é xee étsin ntuvi dá kani ntuꞌu Xuva ko kadā kúꞌvē ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ntaváꞌa nto ña nchokuvi; nantōto nto ña xiꞌi; ntaváꞌa nto ña é ntee kuiꞌi é kānakóꞌxo kúñu ī; nakūnu nto é ña váꞌā san. Dómēni níꞌi nto é kūvi vií nto sáꞌā. Dukuān ne, ña kíꞌi nto xāꞌví i nee é viī nto. ");
INSERT INTO mizNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ʼÑa kuído nto ōro, nté diuꞌun kuiꞌxin, nté diuꞌun kuaan, ");
INSERT INTO mizNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nté itɨ̄n nto é kūꞌun iña ntó itsi kān. Nté ña kuniꞌi nto uun naꞌa dúꞌnu nto, nté ntiꞌxen nto é nādama nto, nté tatun ntō, tsí ña ntáde tsiñu ne, da miī é nīꞌi ña é kaꞌxī ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ʼDa nēé ka ñuú, tē lúꞌnti te kāꞌnu, mí xēe ntó ne, ntuku ntō xoó ñaꞌa, ña é vāꞌá ne, kuntoo nto ni ña dā nté ntāka nto ñuú tsikan. ");
INSERT INTO mizNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Te kūkɨ́ꞌvi ntō má viꞌi kān ne, káꞌan nto ni ñā Ntiusi. ");
INSERT INTO mizNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te vāꞌá ntiꞌxe ñaꞌa sán ne, káꞌan nto, na kuēꞌé Xuva kō é kūntoo váꞌa ña. Tē ña váꞌa ñaꞌa ña ne, ñá kuntoo váꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tē ña taꞌxi ña é kuntōo nto ne, o ña kuintíꞌxe ña é ntákaꞌan ntó ne, nakɨdɨ nto ntiꞌxen nto xákā ñuú san te ntaka nto ikān. ");
INSERT INTO mizNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nuu é ntaā i é kākaꞌán u ni ntō tsí dií ka váꞌa kōo iña ñuú Sodoma ni ñuú Gomora é kōo iña ñuú tsikan ntuvi tē xeꞌé Xuva kō é ntōꞌo ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ʼ¡Koto nto! Kataxnūu ú nto é kɨ̄ꞌɨn ntó vatā ó kañeꞌe a léꞌntu méꞌñū tína kūꞌú san. Kantio e dóo ntíto víí nto vatā ó de koó san, ntá tsi vií nto vata kaa paloma, é ña te díin tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kuenta tsí vií nto, tsí ñaꞌa sán ne, kɨꞌɨn níꞌi ña nto nūu ña tsíñu i sán ne, kani ña nto ntuku iní viꞌi mi ntánataká nuu ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ntada ña nto kuenta ntáꞌa ña tsiñu naꞌnu i san ni ntāꞌa reí san kuenta iñá ko vata koo é kāꞌan ntó kuenta iñá ko ni ña, ni ñāꞌa, ña e ñá ini Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ntá tsi te ntāda ña nto kuenta ntáꞌa ña tsiñu i sán ne, ñá ku itsuꞌun ntō nee é kāꞌan nto. Tsí taꞌxi Xuva kō nté koo kaꞌan ntó ura tsíkan. ");
INSERT INTO mizNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ña te míi ntō é kāꞌan nto kídaā, tsi Espíritū Sántū san taꞌxi ña túꞌūn é kāꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ʼÑatīí san ne, ntada ña kuenta éní ña ntaꞌa ñaꞌa e kaꞌní ña ña ne, uva īꞌxá san ne, kuan kōo vií ña ni iꞌxā ñá dɨ; iꞌxá san ne, kiꞌi nchuꞌvi ñá uva ñā ne, kaꞌní ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ñá ntīo kueꞌen ñaꞌa san nto kuenta iñá ko. Ntá tsi xoó ñaꞌa kutíi ña dā nté nainu xtuku ú ne, nakáku ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Dā ntádē xení ña ni nto ūun ñuú ne, kunu nto kueꞌēn ntó tuku ñuu. Tsí nuu é ntaā i é kākaꞌán u ni ntō, ñá kunēꞌé nto xee nto un ntɨɨ́ ntɨ̄ɨ́ ñuu é ntoo ñuú Israee díꞌna dá nainu xtúku ú, xuꞌu é vēxkúvi ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ʼNté uun ña kanakuāꞌa san é dií ka kaꞌnu ñaꞌa ña é mastru ñá ne, nté uun ña kade tsiñu san é dií ka kaꞌnu ñaꞌa ña e tóꞌo ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vata ō kúvi mastrú san ne, kuan kōo kuvi ña ntántīkɨn ñá dɨ. Vata ō kúvi tóꞌo ñā ne, kuan kōo kuvi ña kade tsiñu iña ñá dɨ. Tē ntákaꞌan ñáꞌa tsí xuꞌú e tóꞌō e ña váꞌā sán u ne, kuan tsi kōo kaꞌan ñá iña ntó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ʼÑá ku uꞌvī ntó ñaꞌa. Tsí ña tuví nee iña é tuvi xuꞌú vevii é ña tuvi dîtó rkontûvi; ña túvī nee é ntáde xuꞌu o vevii é ña kutúni ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nēe é kākaꞌán u ni ntō dá nēé ne, káꞌan nto ni ñāꞌa sán ntuvi a. Nēe é tekú nto é kākaꞌan xúꞌu ú ni ntō ne, kachuꞌu ntó nte dɨkɨ viꞌi nto kan. ");
INSERT INTO mizNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ñá ku uꞌvī ntó ñaꞌa, ña é kūvi kaꞌní da miī kúñu kō, ntá tsi ña kuvi kaꞌní ña nima ko. Xuva kō é uꞌvī ntó ña, tsí dɨvi ñā é kuvi nantɨ̄ꞌɨ ña nima kó nī kúñu kō dôꞌvi kan. ");
INSERT INTO mizNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ʼKūdii uun séntavu ntádiko ña uvi a láā skuaán san. Ntá tsi nté uun tɨ ña kuví tɨ, te Xuva kō ña ntío ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ntōꞌó ne, un tsi nté idi dɨkɨ nto ntántéꞌvi. ");
INSERT INTO mizNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dukuān ne, ñá ku uꞌvī nto, tsí dií dií ka nuu áꞌvi nto é vāta ntáa a láā sán, kuān te tɨtɨ́n tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ʼUn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntákaꞌan nuu ñaꞌa san e ini ña kó ne, káꞌān ú ni Uvā kó, ña tuví e dukún kān, tsí ini ú ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ntá tsi tē xoó ñaꞌa kakaꞌan ñá ni ñāꞌa san e ñá ini ñá ko ne, káꞌān ú ni Uvā kó, ña tuví e dukún kān, tsi ñá īni ú ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ʼTē kuiní nto ne, véꞌxī u é kūntoo váꞌa ñaꞌa ñuxiví a. Ñá te vēꞌxí u é kūntoo váꞌa ña, tsi véꞌxī u é na nāa núu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tsi véꞌxī u é na nāa núu iꞌxá ni uva ī, é nāa núu dióko ña ni dɨꞌɨ̄ ña, é nāa núu énu ña ni ñuntɨɨ ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kiꞌi nchuꞌvi ña ñaviꞌi mii ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ʼTē xoó ñaꞌa é dií ka ntio ña dɨꞌɨ ña ni uva ñā é xūꞌú ne, ñá tē neé nuu áꞌvi ña é kuntīkɨn ñá ko. Ne, tē xoó ñaꞌa é dií ka ntio ña iꞌxá ña ō dióko ñā é xūꞌú ne, ñá tē neé nuu áꞌvi ña é kuntīkɨn ñá ko. ");
INSERT INTO mizNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tē xoó ñaꞌa ña ntío ña kuví ña kuenta iñá ko dá kantīkɨn ñá ko ne, ñá tē neé nuu áꞌvi ña é kuntīkɨn ñá ko. ");
INSERT INTO mizNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tē xoó ñaꞌa dóo ntio ña é koo é vāꞌá ntuvi iña ña ñuxiví a ne, ñá nīꞌi ña é vāꞌá e dukún kān. Ntá tsi tē xoó ñaꞌa nakunáa ña ntuvi iña ña ñuxiví a kuenta iñá ko ne, níꞌi ña ntuvi vāꞌá iña ña e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ʼTē xoó ñaꞌa kade ña ni ntō é vāꞌá ne, dɨvī ú kade ña nī ko é vāꞌá dɨ. Tē xoó ñaꞌa e váꞌā ó de ña nī kó ne, váꞌā ó de ña nī ña táxnūu kó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tē xoó ñaꞌa e váꞌā ó de ña ni ūun ñaꞌa kuenta iña i é kākaꞌan ñá naa Xuva kó ne, níꞌi ña é vāꞌá vata kaa doméni é kāduku ntée ña ntákaꞌán naa Xuva ko. Tē xoó ñaꞌa e váꞌā ó de ña ni ūun ñaꞌa, tsi dóo vaꞌá ñaꞌa ña ne, níꞌi ña é vāꞌá vata kaa doméni é kāduku ntée ña é vāꞌá ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tē xoó ñaꞌa kuéꞌe ña uun eꞌxin ntute vīꞌxin é kōꞌo uun á na kuetsi, na kantīkɨ́n ko ne, nuu é ntaā i é kākaꞌán u ni ntō tsí niꞌi ntiꞌxe ña doméni —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dā kúvi teé tsiñu Jesuu úxuvi ñáꞌa pustru ñá ne, ntaka ña ikan, kūkaꞌan ntódo ña taꞌán ñuu taꞌán ñuú, kanakuāꞌa ña ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Da nɨɨ nuu kutū Juaán ne, kūtuni ña un ntɨꞌɨ̄ nuu i é kade Cristú ne, taxnūu ña ña ntántīkɨn ña ");
INSERT INTO mizNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","é tsixeꞌe ña Jēsuu té dɨvi ntiꞌxe ñā é kāꞌan ñátā san kídaā tsí kiꞌxi ña, o te kuntetū ká ña tuku ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kakaꞌan Jésuu ni ña: —Kueꞌēn nto mí tuví Juaán ne, káꞌan nto ni ñā nuu i é ntátekú nto ni nūu i é ntaíni nto. ");
INSERT INTO mizNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Káꞌan ntō tsi náxiꞌí ntuxnūú ña kuāá, tsi nákaka ña xnéꞌe, tsí ntuváꞌa ñá kanakóꞌxo kúñu ī, tsi nátekú ña loꞌō, tsi ntóto ña xiꞌi, tsí kakaꞌan ntódo u túꞌūn vaꞌá iña Xuva ko ni ñá ntāꞌví san. ");
INSERT INTO mizNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Nté kuān nte váꞌā ó ni ñaꞌa, ña é ña kákukaꞌan núu i ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dā kunúꞌu ña ntántīkɨ́n Juaán san ne, eni ntuꞌu Jēsuu kakaꞌan ñá nī ñāꞌa, ña e dóo tɨtɨ́n, ña ntántoo san, kuenta iñá Juaan: —¿Nee iñá ntu ixkoto nto má kūꞌu kan? ¿Vá ixkoto ntú nto choo é kākantá nuu da kainu tatsín san? ");
INSERT INTO mizNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Nté kui ñeꞌe ntu nto? ¿Ō é kōto ntu nto uun ña kuika, ña é nuu doo e dóo vaꞌa? Ña kuān ntáa sán ne, nú viꞌī reí san ntoo ña. ");
INSERT INTO mizNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Nté kui ñeꞌe ntu nto? ¿Ō é kīni ntó uun ñaꞌa, ña kakaꞌán naa Xuva ko? Juaán ne, kakaꞌan ntíꞌxe ña naa Xuva ko ne, dií ka kaꞌnu ñaꞌa ña é da xōó ka ñaꞌa, ña e ntákaꞌán naa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tsí uve naꞌa túꞌun Xuva ko, kākaꞌan íña ña: Iꞌa taxnūu ú maú ko é kodo nuū ña, é nakōo túꞌve ña itsi mí kɨ̄ꞌɨn, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nuu é ntaā i é kākaꞌán u ni ntō tsí xoxó ñaꞌa, ña e káku ñuxiví a, e dií ka kaꞌnu ñaꞌa ña é Juaan Bautista. Ntá tsi xoo ñaꞌa é dií ka lúꞌnti ñā mí kadē kûꞌvé Xuva kō ne, dií ka kaꞌnu ñaꞌa ña é Juaán san. ");
INSERT INTO mizNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ʼNté ntūvi dá eni ntuꞌū Juaan kakaꞌan ntódo ña ne, un tsi da nté vevií ne, ncho vií ñaꞌa san dúꞌxen ni ñāꞌa, ña ntáduku ntée Xuva kō. Ña ntákudiin san ne, ncho nantɨ̄ꞌɨ ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Un tsi da nté xeé Juaán san ne, un ntɨɨ́ ntɨ̄ɨ́ ña ntákaꞌán naa Xuva ko kídaa, nī lei Muísee ne, ntákaꞌan ñá nté koo kuvi ntuvi dá kixkadā kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tē ntio nto é kuīntiꞌxe nto ne, tsí Juaán san ne, dɨvi ñā é Elia ña. ");
INSERT INTO mizNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Xoo é kātekú i ne, na kīni ña. ");
INSERT INTO mizNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ʼ¿Nee iñá ntu é natee taꞌan o ñaꞌa san, ña ntántoo vevii, ña é ñá ncho tekú i? Vata ntáa iꞌxá e ntánadɨkɨ nu âꞌví kān ntáa ña, iꞌxa é ntákaꞌan níꞌi tāꞌan i: ");
INSERT INTO mizNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Nakuékū ntɨ choo iña viko ña tántaꞌa san ne, ñá ni iteꞌe ntō; īta ntaꞌxa ntɨ́ vatā ó kaita ña da kaíntuꞌxi ñaꞌa ne, ña ni éku ntō”, kaꞌan na. ");
INSERT INTO mizNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tsí kiꞌxi Juaán san ne, ntē ñá ini xiꞌi ñá ne, ntē ñá ini eꞌxi ñá ne, ntákaꞌan ñaꞌa san tsí nuu é ña váꞌā nima ña. ");
INSERT INTO mizNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Vevií ne, xéē ú, xuꞌu é vēxkúvi ú ñatīí ne, kaeꞌxí u ne, kaxiꞌi ú ne, ntákaꞌan ña tsi dóo ini eꞌxí u, dóo ini xiꞌi ú dɨ ne, ntákaꞌan ña tsí xuꞌú ne, dōo váꞌa tiin ú nī ña ntaído diuꞌun xôó san nī ña kini ntáa san. Ntá tsi kutuni ko tsi dóo kiꞌin īní ntiꞌxe Xuva kō da ntaíni o nté o de ña ntántīkɨn ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kidáā né, eni ntuꞌu Jēsuu kade tíi ña nī ña ñuú i san, mí dóo kiꞌin itó ede ña nuu i é dóo naꞌnu, tsí ña ni nátɨvi īní ña kuétsi ña. Kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ña ntáꞌvi ide ntu nto, ña ñuú Coraziin! ¡Ña ntáꞌvi ide ntu nto, ña ñuú Betsaida! Tē dɨ́ ni īni ña ñuú Tiru ni ñá ñuú Siduun núu i e dóo naꞌnu é īni nto ne, nté ēmá tsi é nātɨvi iní kueꞌen ñá ne, ínūu ña doo lakɨ́ ne, dáꞌvi ñā dɨkɨ ña xáā vátā xkoó ini ña dá ntoo ntaꞌxa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ntá tsi kakaꞌán u ni nto, tē xee ntúvī é xntēkú kūꞌvé Xuva kō ne, níꞌi ntō e dií dií ka ntoꞌo nto é vāta káa ñuú Tiru ni Síduun, tsí ña ni kuintíꞌxe nto ko. ");
INSERT INTO mizNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Dɨvi ntō, ña ñuú Capernaú ne, dōó kuika ntō né, dōo ntáde naꞌnu ñaꞌa nto. Ntá tsi nakuītá nuu ña nto dôꞌvi kan, tsí ña ni kuintíꞌxe nto ko. Tē dɨ́ ni īni ña ñuú Sodoma núu i e dóo naꞌnu é īni ntó ne, tuvi dukuan ñuú tsikan nté vevii. ");
INSERT INTO mizNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ntá tsi kakaꞌán u ni ntō tsí dií ka donchuꞌvi koo ntoꞌo nto, é vatā o kúvi ñūú Sodomá tē xee ntúvī é xntēkú kūꞌvé Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kidáā ne, kakaꞌan Jésuu: —Ntadiáꞌvi nto, Xuvā ko, Tóꞌō e dukún kān ni ñūxiví a dɨ, tsí xnuu xuꞌū ntó nuu i é nuu é ntaā í san é ña kiní ña dóo kiꞌin inī í san nī ña dóo tuꞌvé i sán dɨ ne, nañēꞌe ntó ña ntāꞌví san. ");
INSERT INTO mizNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kuán ō dé nto, tsí kuan ō ntío nto é viī nto —kaꞌan ñá ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kakaꞌan xtúku Jesuu: —É taꞌxi Xuva kō é un ntɨꞌɨ nuu i ntāꞌa ko. Xōxó ñaꞌa é īni ntíꞌxe ña xoo é Iꞌxá Xuva ko, da mii Uvā kó ini ña. Xōxó īni i xoo é Xuva kō, da mii tsi Iꞌxā ñá, ni da xōó ka ñaꞌa é ntio Iꞌxá ña é kūtuni ña. ");
INSERT INTO mizNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kiꞌxi nto, un ntɨɨ́ ntɨɨ̄ nto e ntákuitā nto kuenta iña tsíñu e ntáde nto, ni kuēnta iña i e ntántoꞌo nto ne, taꞌxi u é kūntoo daꞌna nto. ");
INSERT INTO mizNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kuntīkɨn ntó ko ne, nakuāꞌa ú nto. Tsí ña te díin u, ñá te kaꞌnu ñāꞌa ú ne, níꞌi nto dāꞌna. ");
INSERT INTO mizNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ñá vīꞌxín kaa itsi ko, ntē ña ntii tuꞌún tsiñu é tāꞌxi ú nto dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kidáā ne, ítā ntiꞌxin Jesuu má trigu kán ntuvi dá iō dáꞌna. Ntákakɨn ña ntántīkɨn ñá ne, tɨ̄ɨn ña xoko trigú san ne, da éꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ntá tsi dā íni ña fariseú san ne, ntákaꞌan ñá ni Jēsuu: —Uun ō ntáde ña ntántīkɨn nto é dóo xií kaa é vīi o ntuvi dá iō dáꞌna —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kakaꞌan Jésuu ni ña: —¿Vāta nakuaꞌa ntu nto nte o dé Davii da kákɨn ña kídaa, ni ña ntɨniꞌi ñā? ");
INSERT INTO mizNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kúkɨ̄ꞌví ña má viꞌi Xuva kō né, ēꞌxí ña tañúꞌu kuiko e dóo xií kaa é kaꞌxī ña, tsí da mii tsi dūtú san ntaéꞌxí ña tañúꞌu tsikan. ");
INSERT INTO mizNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ō vata nakuaꞌa ntu nto mí uve naꞌa kakaꞌan léi Muísee? É dūtú san ntáde tsiñu ña ini ukún kaꞌnu kān ntuvi dá iō dáꞌna ne, ña túvi nēe nuu i é kīni kaa ntáde ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kakaꞌán u ni ntō tsí iꞌa tuví e dií ka kaꞌnu é xukún kaꞌnu san. ");
INSERT INTO mizNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ñá īni nto neé ncho kaꞌan Xúva kō dá kakāꞌan ña sáꞌā: “Ñá tē doméni é ntio ko, tsi é ntio kó ne, na ntūntaꞌví ini nto taꞌan nto”, kaꞌan ña. Tē dɨ́ ni ñeꞌe dɨkɨ ntíꞌxe nto sáꞌā ne, ñá ni kāꞌan ntée nto ñaꞌa, ña é ña tuvi kuétsi ī. ");
INSERT INTO mizNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tsí xuꞌu é vēxkúvi ú ñatīí ne, xuꞌu é kadē kûꞌvé u ntuvi dá iō dáꞌna dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ntāka Jesuu íkān ne, kúkɨ̄ꞌví ña iní viꞌī mí ntánataká nuu ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ikān tuví uun ñatīí, ña é itsi ntáꞌa i. Tsixeꞌe ñāꞌa san Jésuu: —¿Ña xíi kaa ntu é ntaváꞌa o ñaꞌa ntuvi dá iō dáꞌna? —kaꞌan ña. Kuan ō kaꞌan ñá vata koo é nīꞌi ña é tsiꞌi kuétsi ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kakaꞌan Jésuu ni ña: —Xoó ñaꞌa nto, te ūun kudii á leꞌntu nto īó tɨ ne, te kōꞌxó nuu tɨ xavi ntuvi dá iō dáꞌna ne, ¿ñā ntu natavá nto tɨ? ");
INSERT INTO mizNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Ñā ntu te dií ka nuu áꞌvi ñaꞌa san é a leꞌntu? Dukuān ne, ñá te xīi kaa é vīi o é vāꞌá ntuvi dá iō dáꞌna —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kidáā ne, kakaꞌan ñá ni ñatīí san: —Nakaan ntaꞌa o —kaꞌan ña. Nákaa ntiꞌxe ña ntaꞌa ña ne, ntuváꞌa vata tsi kaa ntaꞌa ña é uun san. ");
INSERT INTO mizNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kidáā ne, ntíi ña fariseú san ne, natíin ña nté koo kaꞌní ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kūtuni Jesuu nté ō dé ña fariseú san. Ntáka ña ikān ne, ñá te da dīi ñaꞌa intíkɨn ñá ña ne, ntaváꞌa ña un ntɨɨ́ ntɨ̄ɨ́ ña nchokuví san. ");
INSERT INTO mizNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kakaꞌan ñá ni ñāꞌa san é ña káꞌan ña nte o dé ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kuan ō kaꞌan ñá vata koo é kūntaa é kākaꞌan ñá kaꞌán naa Xuva ko kídaā, ñá nani Isāia: ");
INSERT INTO mizNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Iꞌa tuví ña kade tsiñu iñá ko, ña e nákaxnúu ú, dɨvi ñā e dóo ntio ko, e dóo diní ko ni ñā. Taxnūu ú Espíritū Sántū kó ni ñā ne, kaꞌan ntódo ña dá kanɨɨ ñūxiví san nté koo niꞌi ña é vāꞌá ntaꞌa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ñá nāa núu ña, ntē ña káchuꞌū ña. Ntē xoxo tekú i tátsin ña itsi kān. ");
INSERT INTO mizNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ntē ña káꞌnu ka ña choo é tāꞌnu, ntē ña nantáꞌva ña metsa é dā vé kakene uꞌme un tsi da nté kūvi vií ña é kōo é vāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kuenta iña ñá ne, kuntetu dá kanɨɨ ñūxiví san é niꞌi i é vāꞌá ntaꞌa Xuva kō, kaꞌan Ísaia. ");
INSERT INTO mizNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Xee níꞌi ña uun ñatīi mí tuví Jesuu. Ñatīí san ne, skuaa ña ne, ñɨꞌɨ ñā dɨ, tsí nuu é ña váꞌā nima ña. Ntaváꞌa Jesuu ñá ne, nakaꞌan ñá ne, nākoto ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Koó dā kúduꞌva un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, ntákaꞌan ña: —¿Vá ña sāꞌá ntu é iꞌxá ika Dāvii? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ntá tsi dā téku ña fariseú san ne, kaꞌan ña: —Kūdii Belsébuu, tóꞌō e ña váꞌā san, kaxéꞌe é kākuvi kade ña kanakunu ña é ña váꞌā san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ini Jésuu nee é ntádē kuení ña ne, kakaꞌan ñá ni ñā: —Da nēé ka ñuu mi ntánāa míi ñā ne, kunaa. Uun ñuú, ō uun ñaviꞌi é kuvi ña uvi dava ña ne, ñá kūtíi ña, tsí kīi nteé xio taꞌan mii ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Te miī tóꞌō e ña váꞌā san kanakūnu é ña váꞌa nīꞌi i ne, ntánāa míi i. ¿Nté ntu koo niꞌi ntii i é viī í, kuan? ");
INSERT INTO mizNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dɨvi ntō ne, ntákaꞌan nto é kanakūnu u é ña váꞌā san kuenta iña Belsébuu, tóꞌō e ña váꞌā san. ¿Xoó ntu kuenta iña í kanakūnu ña ntántīkɨn nto é ña váꞌā san? Ña ntántīkɨn ntó san ne, dɨvi ñā é ini ña tsí ña te kuenta iña tóꞌō e ña váꞌā san é kūvi nakunu o é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Xuꞌú ne, kuenta iña Espíritu Xuva kō san é kanakūnu ú e ña váꞌā san. Dukuān ne, e xée Xuva kō mí ntoo nto é kadē kúꞌvē ñá iña nto ve. ");
INSERT INTO mizNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ʼ¿Xoó ntu kuvi kɨ́ꞌvi i má viꞌi ña dóo xení i é kiꞌi dúꞌu iña ñá tē ña diꞌna kiꞌní ña ña? Kidáā ne, kuvi ntada ixu ña viꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ʼXoo é ña kákuiniꞌi ī kó ne, ñá kañēꞌe ñá da xeꞌé ko. Xoo é ña kánatee kuitɨn i iñá ko ne, katsoo xaa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ʼTsíkān é kākaꞌán u ni ntō tsí kada kaꞌnu iní Xuva ko ni ñāꞌa san kuétsi ña, da nēé ka nuu i é viī ña, é kāꞌan ña, ntá tsi te kāꞌan kíni ña iña Espíritū Sántū sán ne, ñá kada kaꞌnū iní Xuva ko ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Xoo é kāꞌan ntée i ko, xuꞌu é vēxkúvī ú ñatīí ne, kuvi kada kaꞌnu iní Xuva ko ni ñā, ntá tsi xoo é kāꞌan ntée i Espíritū Sántū sán ne, ñá kada kaꞌnū iní Xuva ko ni ñā nté vevii, nté ntūvi é vēꞌxi. ");
INSERT INTO mizNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ʼTe vāꞌá utun sán ne, váꞌā kɨtɨ i. Tē ña váꞌa ūtun sán ne, ña váꞌā kɨtɨ i. Kutuni ko nté kaa utun san te kīi kɨtɨ i. ");
INSERT INTO mizNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Tatá koo nto! ¿Nté koo kuvi kaꞌan nto é vāꞌa dá ña váꞌā nima nto? Da nēé ka é nuu tsitu nima kó ne, dɨvī é kākaꞌan xúꞌu kō. ");
INSERT INTO mizNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ña é vāꞌá ñaꞌa ne, váꞌā nima ñá ne, váꞌā ó kakaꞌan ña. Ña é ña váꞌa ñāꞌa ne, nuu tsitu nima ñá é kīni kaa, ne, kakaꞌan ñá é kīni kaa. ");
INSERT INTO mizNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ntá tsi kakaꞌán u ni ntō, tsí dɨvi ntūvi é taꞌxi Xuva kō é ntōꞌo nto ne, káꞌān un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa nté kui kuan ō kaꞌan ñá da nēé ka túꞌūn é dotō tsí kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tsi kídaā ne, káꞌan Xuva ko te vāꞌá nto, o tē ña váꞌa nto kuenta iña i é kāꞌan nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kidáā ne, nantíko kōó mastrú leí san nī ña fariseú san, ntákaꞌan ñá ni Jēsuu: —Mastrú, ntio ntɨ é viī ntó uun nuu i é dóo kaꞌnu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ntá tsi nantiko koó ña, kakaꞌan ña: —Koó da ña kini ntáa san, ña é ña ntákuintiꞌxe i san, ntio ña nuu i e dóo kaꞌnu. Ntá tsi ñá kīní ka ña nuu i e dóo kaꞌnu, mii tsī nuu i é idé ña kaꞌán naa Xuva ko kídaā, ñá nani Jōnaa. ");
INSERT INTO mizNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tsí vata ō kúvi Jonaá san é uni ntúvi, uni níñu inúu ña ini iꞌxi tsáka kaꞌnu sán ne, kuan koo kunūu ntúꞌxi u, xuꞌu é vēxkúvi ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Viꞌi a vé ne, xée ntūvi é kāꞌan Xúva ko xōo e váꞌa i ne, xoo é ña váꞌa i, ña ntántoo ntuvi sāꞌa. Kidáā ne, ña ñuú Nínive san ne, káꞌan ntēé ña ña. Tsí ña ñuú Nínive sán ne, nātɨvi iní ña da téku ña é kākaꞌan ntódo Jonaa. Vevií ne, iꞌa xee ú e dií ka kaꞌnu ñaꞌa u é Jonaa. ");
INSERT INTO mizNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Uun ká tuku ne: Ñadɨ̄ꞌɨ, ñá é īdé reina ñuú Sebá ne, nákuntītsí ña é kāꞌan ntée ña ña ntántoo vevii. Tsí dɨvi ñā é kīꞌxi ña uun ñuú e dií ka ikā vata koo é tekū ña túꞌūn e dóo kiꞌin inī i, é kākaꞌan rei Salamuun. Vevií ne, iꞌa xee ú e dií ka kaꞌnu ñaꞌa u é Salamuun. ");
INSERT INTO mizNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ʼTe ntīí uun é ña váꞌā san nima ñáꞌa ne, dotō tsí kaika ñuú itsi, kanantukū míꞌi kūtuví daꞌna, ntá tsi ña kaníꞌi. ");
INSERT INTO mizNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kidáā né, kadē kuení i: “Ntiko kōó u nú viꞌī kó kān mí ntáka u”, dé kuení i. Dā náxeé ne, ixu dukuān. É ntūntoo ne, kaníne ve. ");
INSERT INTO mizNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kɨ́ꞌɨ̄n né, kuntēka ká uꞌxe é ña váꞌā e dií dií ka kini ntáā é dɨvī. Kɨ́ꞌvī ntɨꞌɨ nima ñáꞌa sán ne, ikan kuntōo. Kidáā ne, dií dií ka kini koo kuvi ni ñāꞌa san é dīꞌna. Kuan kōo kuvi ñaꞌa, ña é kīni ntáa, ña ntántoo vevii —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kakaꞌan dúkuan Jesuu ni ñáꞌa sán da xée dɨꞌɨ ña ni enī ñá ne, ntáñɨ̄ ña kíꞌi kān e ncho kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Uun ñaꞌa ne, kakaꞌan ñá ni ñā: —Dɨꞌɨ nto ni enī ntó ne, ntáñɨ̄ ntée ña kíꞌi kān e ncho kaꞌan ñá ni ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ntá tsi nantíko koō ñá, kakaꞌan ñá ni ñā: —¿Xoó ntu é dɨꞌɨ̄ ko? ¿Xoó ntu é ení ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kāta nteé ña ntaꞌa ña mí ntoo ña ntántīkɨn ñá ne, kakaꞌan ña: —Ña sāꞌa é dɨꞌɨ̄ kó ni ēní ko. ");
INSERT INTO mizNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tsí da xōó ka ñaꞌa, ña é kade é ntio Uvā kó, ña é tuví e dukún kān né, dɨvi ñā é ēní ko, dɨvi ñā é tāꞌan kó, dɨvi ñā é dɨꞌɨ̄ kó dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dɨvi tsi ntūvi tsikan kíi Jesuu nú viꞌī sán ne, kuéꞌen ña kukūtúvi ña diñɨ mínī san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Un váꞌa tsi tɨ̄tɨ́n ñaꞌa nátaká nuu ña mí tuví ña. Dukuān ne, ínuu ña tun ntōó san ne, ikan tsī itúvi ña. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntáñɨ̄ ñá diñɨ ntute san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ñá te da dīi núu i e ntáa ña ni ñāꞌa san é kanakuāꞌa ña ña. Kakaꞌan ña: —Uun ntuvi ne, uun ñaꞌa kúkāté xaa ña ntɨkɨn. ");
INSERT INTO mizNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Da nɨɨ̄ kaeté xaa ña ntɨkɨn sán ne, īó ne, kóꞌxo itsī san. Xéē láā sán ne, ēꞌxí tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Īó ntɨkɨn sán ne, kóꞌxō mí dóo xuu mí ña túvi kuēꞌe ntéꞌu. Váta tsī e náꞌa ne, kēne xuku i, tsí ña túvī mí kɨ̄ꞌɨn xóꞌo i. ");
INSERT INTO mizNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ntá tsi da dóo naíꞌnī ne, xiꞌi dîí xuku i. Tsí ña ni naniꞌi xoꞌo i ntéꞌu ne, ítsī. ");
INSERT INTO mizNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Īó ntɨkɨn sán ne, kóꞌxō mí kaa xuku íñū. Xíꞌi nūu xuku váꞌā san, tsí un tavi nuu tsi xuku íñū san da éꞌnu. ");
INSERT INTO mizNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Īó ntɨkɨn sán ne, kóꞌxo ñuꞌu vāꞌá ne, kīi kɨtɨ i. Īó e kíi uun sientu kɨ́tɨ i é uun ditsin í ne, īó ne, kii te ūni díko ne, īó e kíi te ōko uꞌxi. ");
INSERT INTO mizNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Xoo e katéku í ne, na kīni —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kidáā ne, véꞌxī ña ntántīkɨn ñá ne, kakaꞌan ñá ni ñā: —¿Nté kui kuān ó kantaa ntu nto ni ñāꞌa san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kakaꞌan Jésuu ni ña: —Ntōꞌó ne, ntáduku ntée nto é kūtuni nto nuu i é iō xuꞌu iña i mí kadē kûꞌvé Xuva kō, ntá tsi ña ntáduku ntée tuku ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tsí xoo ñáꞌa, ña é iō iña í ne, níꞌī ká ña ne, kuéꞌē ká koo iña ña. Ntá tsi xoó ñaꞌa, ña é ña tuvi íña í ne, nakiꞌi ka é iō iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Dukuān né, kuān ó kantaa ú ni ñāꞌa san, tsí kuān te ntaíto ña ne, ña ntaíni ña. Kuān te ntátekú ña ne, ña ntaíni ña. Ña ntaéni túꞌun ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","É kūntaa ntíꞌxe vatā ó kakaꞌan Ísaia, ña é kaꞌán naa Xuva ko, dá kakāꞌan ña kídaā: Kuān te tekú ña, ntá tsi ña kɨ́ꞌɨn dɨkɨ ña; kuān te koto ña, ntá tsi ña kiní ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tsí ña sāꞌá ne, é ntukaꞌxī nima ñá ne, vata te neé nuu ntído loꞌxo ña ne, kantiꞌu núu ña, vata koo é ña kiní ña, vata koo é ña tekú ña, vata koo é ña kani tútun ña, vata koo é ña káꞌān ñá nī ko é ntaváꞌa ú ña, kuan ō kaꞌan Xúva kō, kaꞌan Ísaia. ");
INSERT INTO mizNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ʼNtá tsi ntoꞌó ne, dōo diní nto tsi ntaíní nto ne, ntátekú nto. ");
INSERT INTO mizNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nuu é ntaā i é kākaꞌán u ni ntō tsí ña te da díi ña ntákaꞌán naa Xuva ko kídaā ne, un váꞌa tsi ncho kini ña é ntaíni nto vevii, ntá tsi ña ni iní ña. Ncho tekú ña é ntátekú nto, ntá tsi ña ni tekú ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ʼKini nto sáꞌa īña ñá kaeté xaa ntɨkɨn san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Te tēkú ñaꞌa túꞌun īña i mí kadē kûꞌvé Xuva kō né, tē ña kani tútun ña ne, kiꞌxi tóꞌō e ña váꞌā san ne, nakiꞌi nuu túꞌūn é īnúu nima ñá, vatā ó de láā sán ni ntɨ̄kɨn é kōꞌxó itsi san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Dɨvi ntɨ̄kɨn é kōꞌxo mi dóo xuú ne, vata kaa túꞌūn vaꞌá san kaa, e ntátekú ñaꞌa san ne, ura tsí i xkúntee iní ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ntá tsi da ñā ni kuintíꞌxe váꞌa ña ne, ña náꞌa tsī kutíi ña. Tē ntákaꞌan ntée ñaꞌa san ña ne, tē ntáde xení ña ni ñā kuenta iña i e kuíntiꞌxe ña ne, ura tsí i xtuvī mii ña e kuíntiꞌxe ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ntɨ̄kɨn é kōꞌxó nuu mí kaa xuku íñu sán ne, vata kaa da ntátekú ñaꞌa san túꞌūn vaꞌá san kaa, ntá tsi dií dií ka ntio ña é īó ñuxiví sa. Ntánantuku ñā diuꞌun é kukuika ñā ne, ntákunáa inī ña túꞌūn vaꞌá san. Ña kaidiáꞌvi ká i iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ntɨkɨn é kōꞌxó nuu ñuꞌu vāꞌá san ne, vata kaa te téku uun ñaꞌa ne, kuintiꞌxe ña. Kade ña é kākaꞌán ne, iō ntúvi vāꞌá iña ña. Vata kaa ditsin utun váꞌā san kaa, e kíi uun sientu kɨ́tɨ i, o te ūni díko, o te ōko uꞌxi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ntāa xtuku Jesuu nuu i sáꞌa, kakaꞌan ña: —Mí kadē kûꞌvé Xuva kō ne, vata kaa uun ñaꞌa, ña e éte xaa ntɨkɨn trigu máña ña kan, kāa. ");
INSERT INTO mizNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ntá tsi da nɨɨ̄ ntákidi ñáꞌa san ne, xée ūun ñaꞌa, ña kakuneꞌu iní i ni ñā né, ēté xaa ña ntɨkɨn é ña váꞌā san má trīgú san ne, da ínu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dā kéne xuku trigú san ne, ntaꞌá kɨtɨ i ne, kēne xuku é ña váꞌā sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Xéē ña ntáde tsiñu iña tóꞌo vīꞌi sán ne, ntákaꞌan ñá ni ñā: “¿Ñá te ntɨkɨn vāꞌá ntu éte xaa nto máña nto kān? ¿Míꞌi ntu vēꞌxi xuku é ña váꞌā san?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kakaꞌan tóꞌo vīꞌi sán ni ñā: “Á tē ñá kakuneꞌu iní i nī ko éte xaa ña ntɨkɨn é ña váꞌā san”, kaꞌan ña. Kidáā ne, ntákaꞌan ñá ntáde tsiñu san ni ñā: “¿Ntio ntu nto é tūꞌun ntɨ́ xuku é ña váꞌā san?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ntá tsi kakaꞌan tóꞌo ñā: “Ñáꞌā, tsí dā ná tūꞌun nto xuku trigú san ni xūku é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Na kueꞌnu miī ntuvi nuu i da nté xēe ntúvi é taꞌvi ō. Kidáā ne, káꞌān ú ni ña kataꞌvī sán te dīꞌna tuꞌun ña xuku é ña váꞌā sán ne, na ntada ña dōko í dá kāꞌmi ña. Kidáā né, na tsūꞌun váꞌa ña kɨtɨ trigú san ini xaká ko”, kaꞌan ña —kuan ō kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ntāa xtuku Jesuu úun nuu i, kakaꞌan ña: —Mí kadē kûꞌvé Xuva kō ne, vata kaa uun ñaꞌa, ña e éte xaa ntɨkɨn kuli mâña i kan, kaa. ");
INSERT INTO mizNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Dií ka kuetsi ntɨ̄kɨn kúlí san é un ntɨɨ́ ntɨ̄ɨ́ ntɨkɨn, ntá tsi dā kúnaꞌnu ne, dií ka naꞌnu xuku i; vata ntáa utun ntáa. Ntáxee láā, kɨtɨ ntaíko e dukún kān ne, ikān ntáde váꞌa tɨ taka tɨ má ntaꞌa i kān —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ntāa xtuku ña uun nuu i, kakaꞌan ña: —Mí kadē kûꞌvé Xuva kō ne, vata kaa uꞌxen íā kaa, é kānadaká ñadɨ̄ꞌɨ́ san uni xkuꞌve árina váta koo é nāneñu uꞌxen san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nteé nteé tsi kakaꞌan Jésuu ni ún ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. Da mii kuēꞌen tsí nuu i sáꞌa kantaa ñá ni ñā dá kakāꞌan ñá ni ñā kuenta iña i mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kuān o dé ña vata koo é kūntaa é kākaꞌan ñá kaꞌán naa Xuva ko kídaā: Ntaa ú ni ntō nuu i sáꞌa, káꞌān ú nuu i é iō xuꞌu un tsi nte dá dé kûꞌvé Xuva ko ñūxiví san, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kidáā né, ntāka Jesuu mí dóo ntoo ñaꞌa sán ne, kɨ́ꞌvi ñā má viꞌi kān. Xéē ña ntántīkɨn ñá ne, ntaíkan ña é kāꞌan ñá nee iñá ncho kaꞌan é ntāa ña iña xuku é ña váꞌā san e éꞌnu máña ña kān. ");
INSERT INTO mizNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kakaꞌan Jésuu: —Ña éte xaa ntɨkɨn vāꞌá san ne, vata kaa xuꞌu é vēxkúvi ú ñatīí kaa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mâña ñá kān né, vata kaa kanɨɨ ñūxiví san kaa. Ntɨkɨn vāꞌá san ne, vata ntáa ña ntáduku ntée Xuva kō ntáa. Ntɨkɨn é ña váꞌā san ne, vata ntáa ña ntáduku ntée tóꞌō e ña váꞌā san ntáa. ");
INSERT INTO mizNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ña kakuneꞌu iní i nī kó ne, vata kaa ña éte xaa ntɨkɨn é ña váꞌā san kaa ña ne, tōꞌo é ña váꞌā san ña. Ntuvi é taꞌvi ō ne, vata kaa ntuvi tē ntɨ́ꞌɨ ñuxiví sa kaa. Ña ntátaꞌvi sán ne, vata ntáa ánje Xuva kō ntáa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Vata ō ntáda ña dōko i é ña váꞌā sán ne, ēꞌmi ña né, kuan koo kuvi tē ntɨ́ꞌɨ ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Xuꞌu é vēxkúvi ú ñatīí ne, taxnūu ú ánjē ko mí kadē kûꞌvé Xuva kō ne, nakuitā ñá un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña e ntáde é vīí tuku ñaꞌa é kini kaa, nī ña é ntáde miī é kīni kaa san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Katé nuu ña ña iní ñuꞌu dūꞌxé san. Un váꞌa tsi kueku ñaꞌa sán ne, nakaꞌxí kaꞌñɨ̄ ña núꞌu ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kidáā ne, xoó ñaꞌa, ña ntáde é ntio Xuva kō ne, xiꞌí nuu kaꞌnu ña mí kadē kûꞌvé Xuva kō, vatā ó kaxiꞌí nuu ngántií san. Xoo é kātekú i ne, na kīni i. ");
INSERT INTO mizNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ʼMí kadē kûꞌvé Xuva kō ne, vata kaa uun nuu i e dóo vaꞌa é nuu ntúꞌxi má ñuꞌu kan kāa. Nāniꞌi uun ñaꞌa ne, ikan tsī náxnuu ntúꞌxi xtuku ña. Ñá tē nté kaa diní ña. Kɨ́ꞌɨn ñā né, nadiko ntɨ̄ꞌɨ ña é īó iña ñá ne, dá kuīin ña ñuꞌu san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ʼMí kadē kûꞌvé Xuva kō ne, vata kaa uun ña kadiko kaa, ña é kanantukū kɨtɨ e dóo nuu áꞌvi i, e dóo vaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Uun tsi kɨtɨ e dóo vaꞌa, é nuu áꞌvi kueꞌen nāniꞌi ñá ne, kɨ́ꞌɨn ñā né, nadiko ntɨ̄ꞌɨ ña é īó iña ñá ne, dá kuīin ña tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ʼMí kadē kûꞌvé Xuva kō ne, vata kaa xunu kaa, é kanakuītá nuu ñaꞌa san ini míni kān é tavā ñá un ntɨɨ́ ntɨ̄ɨ́ nuu tsákā san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dā tsítū ne, nantíi ña diñɨ ntute kān. Ikān intóo ña nakaxnúu ña tɨ. Tsāká vāꞌá san ne, nātsuꞌun ña tɨ ini xiká san. Kɨtɨ é ña váꞌā san ne, ēte ñá tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kuan koo kuvi tē ntɨ́ꞌɨ ñuxiví sa dɨ. Kiꞌxi ánje Xuva kō ne, nakaxnúu ña xoo é vāꞌá i, xoo é ña váꞌa i. ");
INSERT INTO mizNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nakuitā ñá xoo é ña váꞌa i méꞌñu ñūꞌu duꞌxé san. Ikān dóo kueku ñaꞌa san ne, nakaꞌxí kaꞌñɨ̄ ña núꞌu ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","—¿Ntáñeꞌe dɨkɨ ntɨ́ꞌɨ ntu nto un ntɨꞌɨ nūu i sáꞌa? —tsixeꞌe Jēsuu ña. —Ntáñeꞌe dɨkɨ́ ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kidáā ne, kakaꞌan ñá ni ñā: —Un ntɨɨ́ ntɨ̄ɨ́ mastrú lei, da ntánakuaꞌa ña iña i mí kadē kûꞌvé Xuva kō ne, vata kaa tóꞌo vīꞌi san kaa ña. Tsi tóꞌo vīꞌi sán ne, kanatava ña é xēé nī é atā san mí ñuꞌu váꞌa iña ña dá ntio ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Dā kúvi ntáa Jesuu sáꞌā né, ntaka ña ikān. ");
INSERT INTO mizNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kuéꞌen ña ñūu míi ñā ne, nakuáꞌa ña ñaꞌa má viꞌī mi ntánataká nuu ña Israeé san. Koó dā kúduꞌva ñaꞌa sán ne, ntákaꞌan ña: —¿Míꞌi ntū nakuaꞌa ñá sāꞌa e dóo ini ña, e dóo kade ña nuu i é dóo kaꞌnu san? ");
INSERT INTO mizNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ñā ntu te dɨvi ña é iꞌxá ña kade vaꞌa utun? ¿Ñā te María ntu dɨꞌɨ ñā? ¿Ñā ntu te ení ña Santiau ni Jósee ni Símuun ni Júdā? ");
INSERT INTO mizNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ñā te dɨvi taꞌan ña taꞌnú ntoo ñuú ko ā dɨ? ¿Míꞌi ntu vēꞌxi é dóo kiꞌin īní ña sāꞌá kuan? —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ncho kudiin ñáꞌa san ni ñā, ntá tsi kakaꞌan Jésuu ni ña: —Ña kakaꞌán naa Xuva kó ne, ntaíko ñuꞌu ñāꞌa san ña; ntá tsi ña ñuú mii ña nī ñaviꞌi ña ne, ña ntaíko ñuꞌu ña ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ñá kuēꞌe núu ī e dóo naꞌnu ide ña ikān, tsí ña ni kuintíꞌxe ñaꞌa san ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ntuvi sāꞌá ne, Heródē, ña é de kuꞌvé iña ñuú Galileá ne, tēkú ña iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kakaꞌan ñá nī ña ntáde tsiñu iña ña: —Ña tsīkán ne, á tē Juaan Bautista ña. Á tē ntóto ñā e xiꞌi ña. Dukuān é kūvi ide ña nuu i e dóo kaꞌnu san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tsí Heródē sán ne, tɨ̄ɨn ña Juaán ne, kīꞌní ña ña ne, xnuu kutu ña ñā kuenta iña Heródia, ñadɨ̄ꞌɨ́ ení ña, ñá nani Fēlipe. ");
INSERT INTO mizNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tsí kakaꞌán Juaan ni Heródē: —Dōo xii kaa é nakiꞌi nto ñadɨ̄ꞌɨ́ ení nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heródē sán ne, ntīo ña é kāꞌní kueꞌen ñá Juaán san, ntá tsi uꞌví ña ñaꞌa san, tsi dé kuení ñaꞌa san tsí Juaán san ne, ña kakaꞌán naa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ntá tsi dā xee víko é kāku Heródē ne, ítēꞌe dióko Herōdia nuu ñaꞌá san, ña vexkáꞌxi viko san. Ñá tē nté kaa dīní Heródē san kídaā ne, ");
INSERT INTO mizNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","xéꞌe ña xuꞌu ña nī dioko Herodia tsí nuu é ntāa ntíꞌxe i é kuēꞌé ña tún da nēé ka é kākán tun. ");
INSERT INTO mizNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tsiꞌi dɨꞌɨ̄ tún dɨkɨ́ tun nēe é kākán tun ne, kakaꞌán tun: —Tāꞌxi nto kó dɨkɨ́ Juaan Bautista vevíi. Xntekū nto nú kōꞌo —kaꞌán tun ni Hērode. ");
INSERT INTO mizNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kidáā né, kūntaꞌxa iní rei Heródē san. Ntá tsi kakaꞌan ñá te kuan kōo kuvi, tsí méꞌñū ñaꞌá san xeꞌé ña xuꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Taxnūu ña é na kāꞌnté tuꞌun ña dɨkɨ́ Juaán san viutun kān. ");
INSERT INTO mizNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Xntekū ñá dɨkɨ́ Juaan nú kōꞌo ne, xéꞌe ñā tún, dā nakuéꞌē tún dɨꞌɨ̄ tun. ");
INSERT INTO mizNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dā xeé ña ntántīkɨ́n Juaán san ne, nākiꞌi ña kúñu ñā ne, ixkúꞌxi ña ñā. Kidáā ne, kuéꞌen ña kūkoto ñá Jēsuu nté ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Dā téku Jesuu nté ō kúvi Juaan Bautistá san ne, ínuu ña tun ntōó ne, kuéꞌen ñā mí xoxó ñaꞌa. Ntá tsi dā kútuni ñáꞌa sán ne, kuéꞌen ña kūntikɨn ñá ña. Ntaíka ña dɨ́ꞌɨn ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Dā ntíi Jesuu tún ntōó san ne, īní ña tsí ña te nté kaa tɨtɨ́n ñaꞌa. Ntúntāꞌví ini ña ña ne, ntaváꞌa ña ña nchokuví san, ña é ntēka ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dā kuáa ne, xéē ña ntántīkɨn ñá ne, ntákaꞌan ña: —Xoxó kantoo i iꞌa. É kuāá ve. Taxnūu nto ñaꞌa san é na kɨ̄ꞌɨn ña ñúu kuetsī san vata koo é kuīin ña é kāꞌxí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ntá tsi kakaꞌan Jésuu ni ña: —Ñá kuētsi é kɨ̄ꞌɨn ña. Dɨvi nto kuēꞌé xnto é kāꞌxí ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kidáā ne, nantíko koō ña, ntákaꞌan ñá ni ñā: —Úꞌun kūdii tañúꞌu īó ni ūvi kudii a tsákā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kakaꞌan Jésuu: —Tāꞌxi nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kidáā ne, kakaꞌan ñá ni ñāꞌa san é na kuntōo ña nu ité sān. Kīꞌi ña uꞌun tañúꞌū sán ni ntūvi a tsákā sán ne, īto ña e dukún kān ne, nākuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō né, kātsin dava ña tañúꞌū sán ne, xéꞌe ñā ña ntántīkɨn ña é na tsīꞌi ña ntaꞌa ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ēꞌxí ntaꞌa ñaꞌa san, un ntɨɨ́ ntɨɨ̄ ña. Kidáā ne, natákā ñá taꞌvi ī é ntoó ka ne, natsuꞌun tsitu ña ūxuví ka xika. ");
INSERT INTO mizNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ñá te da ūꞌun míil ñatīí san éꞌxi ña. É ntē ña ni kaꞌvi ña ñadɨꞌɨ́ san, nté īꞌxá san. ");
INSERT INTO mizNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kidáā ne, kakaꞌan Jésuu ni ña ntántīkɨn ña é kūꞌun ña iní tun ntōó san e kɨ́ꞌɨn ña uun xo diñɨ ntute san. Dɨvi ñā ne, ítūví ka ña da nté ntaka ntɨꞌɨ ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dā nátaxnūu ña ñaꞌa san kunúꞌu ñā ne, kúxee ña xuku kān vata koo é da mii tsi ñā kaꞌan ntâꞌví ña. Dā kuáa ne, ínuu mii ña ikān né, ");
INSERT INTO mizNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","dōo kuíka tun ntōó san méꞌñū mínī san. Un váꞌa tsi kanaduku ntúte san ata tún ntōó e dóo kainu tatsín san. ");
INSERT INTO mizNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dá vēꞌxi túvi ne, kuéꞌen Jēsuu mí ñūꞌu ña, kaika ña nú ntūte san. ");
INSERT INTO mizNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ntá tsi dā íni ña ntántīkɨn ñá ña tsí kaika ña nú ntūte sán ne, ñá tē nté kaa ntaúꞌvī ña. Ntákachuꞌu ntáa ña, ntákaꞌan ña: —¡Un kaa ña ntɨ̄xɨ! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ntá tsi ura tsí i kakaꞌan ñá ni ñā: —¡Ñá ku uꞌvī nto, tsí xuꞌu! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kakaꞌán Pedru ni ña: —Te dɨvi ntiꞌxe ntō, Tóꞌō, káꞌan ntō é na kīꞌxi u mí kaika nto nú ntūte san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kakaꞌan Jésuu: —Kiꞌxin ni —kaꞌan ña. Pedrú ne, ntīi ña tún ntōó san ne, īka ña nú ntūte san é kɨ̄ꞌɨn ña mí ntitsí Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ntá tsi dā íni ña tsi dóo kainu tatsín san ne, úꞌvī ñá ne, iñɨ ntuꞌu kūkií ntoꞌo ña iní ntute san. Un ntíi tsī kána ña: —¡Xntii ntō ko, Tóꞌō! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ura tsí i nakurkáa Jesuu ntáꞌa ña ne, nātava ña ña. Kakaꞌan ñá ni ñā: —¡Nté ō ntú iña o é ña kákuintiꞌxe o! ¿Nté kui ña ni kuintíꞌxe ntu o? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dā nakúꞌun ña ntuvi ñá tun ntōó san ne, kūkadin tatsín san. ");
INSERT INTO mizNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ñá ñuꞌu iní tun ntōó san ne, nákunchɨtɨ ña nūu Jésuu, ntákaꞌan ña: —¡Nuu é ntaā i tsí Iꞌxá Xuva ntiꞌxe ko ntō! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dā kúvi ita ntíꞌxin ña ntute sán ne, xée ña ñūu é nani Genesāree. ");
INSERT INTO mizNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dā íni ñaꞌa san, ña ntántoo ikān, e véꞌxi Jesuú ne, taxnūu ña túꞌun īña un ntɨɨ́ ntɨ̄ɨ́ ñuú tsikán ne, ntēka ñaꞌa san ña ntánchokuví san, un ntɨɨ́ ntɨɨ̄ ña. ");
INSERT INTO mizNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Īkan ña Jesuu é kuān te ntete dóo ña na tɨɨn ntáꞌa ñā. Ña é tɨɨn ntaꞌā sán ne, ntūváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kidáā ne, xéē ña fariseu ní mastrú leí san, ña ntoo ñuú Jerusaleén, nte mí tuví Jesuú ne, ntákaꞌan ñá ni ñā: ");
INSERT INTO mizNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Nté kui ña ntáde ntaa ña ntántīkɨn ntó vatā xkoó ini ñáta kō? Tsí ña ntántaꞌa ña dá ntaéꞌxi ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kakaꞌan Jésuu ni ña: —¿Nté kui dɨvi ntō ne, ña ntáde ntaa nto é kākaꞌan Xúva kō, é ntio nto kuntīkɨn ntó vatā xkoó ini míi ntō? ");
INSERT INTO mizNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tsí kakaꞌan Xúva kō: “Kuiko ñuꞌu nto uva nto ni dɨꞌɨ ntō”, kaꞌan ña. Káꞌan xtūku ña dɨ: “Xoo é kāꞌan kíni i iña uva i ni iña dɨꞌɨ í ne, da miī é kūvi i”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ntá tsi ntōꞌó ne, ntákaꞌan nto tsí kuvi kaꞌan ñáꞌa san ni uva ña ni dɨꞌɨ ñā: “Ña kúvi xntīi ú nto, tsí iñá ko ne, nākuéꞌe ú ntaꞌa Xuva kō.” ");
INSERT INTO mizNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Te kuan kōo kaꞌan ñá ne, ñá kantīo é xntii ña uva ñā nté dɨꞌɨ ñā, kaꞌan nto. Dukuān ne, ntáde nto vatā xkoó ini ñáta ntō e ntánakuitā nto é kākaꞌan Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ntákaꞌan ntó tsi ntáde ntaa nto é kākaꞌan Xúva kō, ntá tsi ña ntáā. Dōo váꞌā o kaꞌan Ísaia kuénta iña nto dá kakāꞌan ñá naa Xuva ko: ");
INSERT INTO mizNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ña sāꞌá ne, kūdii rkɨ xaa ña ntéku da ntákaꞌan ñá e dóo ntánuu iní ña ko, ntá tsi ña te ntánɨɨ̄ nima ñá e ntánuu iní ña ko. ");
INSERT INTO mizNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","E ntaā í e ntánuu iní ña ko, tsi e ntánakuāꞌa ñá ne, da mii tsī e ntákaꞌan ñáꞌa san. Kuan ō kaꞌan ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kidáā né, kāna ña ñaꞌa sán ne, kakaꞌan ñá ni ñā: —Kini nto né, na kɨꞌɨn dɨkɨ nto: ");
INSERT INTO mizNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ñá te dɨ̄vi é kakɨꞌvi ini xúꞌu ko kān kade i é kakudentū nima ko, ntá tsi nee iña é ntii xuꞌu kō né, dɨvī é kade i é kakudentū nima ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kidáā ne, xéē ña ntántīkɨn ña mí tuví ña ne, tsixeꞌe ña ñā: —¿Kútuni ntú nto é kūdiin ñá fariseú san da téku ña é kākaꞌan nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kakaꞌan Jésuu: —Da nēé ka utun é ña ni íꞌxi Uvā kó ne, nātuꞌun ña uun tsi nte xóꞌo i. ");
INSERT INTO mizNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Na koo mii nto ñā. Vata ntáa ña kuāa ntáa ña é dotō tsi ntántēka ña ñaꞌa. Te uun ña kuāá nteka ña ña kuāa niꞌi ña ne, ntuvi tsí ña kóꞌxo nuu ña xaví san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kidáā ne, kakaꞌán Pedru ni ña: —Káꞌan nto nī ntɨ́ nee iñá ncho kaꞌan núu i sáꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kakaꞌan Jésuu ni ña: —¿Vāta tekú kueꞌen xntú nto? ");
INSERT INTO mizNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ñá ini ntú nto tsí da nēé ka é kākɨ́ꞌvi xuꞌu kō ne, kaita ntiꞌxin iꞌxí ko kān ne, da kidáa ntīi xtuku kúñu kō? ");
INSERT INTO mizNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ntá tsi nēe é kīni kaa é kakii xuꞌu kō né, ntē nima ko kakéne ne, dɨvī é kade i é kakudentu ō. ");
INSERT INTO mizNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tsi nté nima ko kakéne é kinī ó kadā kuení kō, é kāꞌni o ñaꞌa, é kadā xení o ni ñadɨ̄ꞌɨ́ tuku ñaꞌa, é kadā xení o ni ñadɨ̄ꞌɨ́, ña vata tántaꞌa, e kiꞌi dúꞌu ō, é kāꞌan ó dovete, é kāꞌan kíni o iña ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sáꞌa kāde i e ntákudentū ñaꞌa sán nuu Xuva ko. Ntá tsi te ña ntaꞌa o da kaꞌxi o vatā xkoó ini ntó ne, ña te dɨ́vi ī é kade i é kakudentu ō nuu Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ntāka Jesuu íkān ne, kuéꞌen ña ētsin ñuú Tiru ni ñuú Siduun. ");
INSERT INTO mizNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ikān tuví uun ñadɨ̄ꞌɨ́, ña véꞌxi ñuú Canaán ne, ñéꞌe ñā mí tuví Jesuú ne, kakaꞌan ña: —¡Ntuntāꞌví ini nto ko, Tóꞌō, Iꞌxá Davii! ¡Un váꞌa tsi kantoꞌo diókō kó kuenta iña é ña váꞌā san é nuu nimá tun! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nté uun túꞌūn ña ni káꞌan Jésuu ni ña. Kidáā ne, xéē ña ntántīkɨn ñá ne, kakaꞌan ñá ni ñā é na nakunu ña ñadɨ̄ꞌɨ́ san. Kaꞌan ña: —Nakūnu nto ña, tsi dóo duꞌxen kaꞌān ña é ntīkɨn ñá kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kakaꞌan Jésuu: —Taxnuu Xuva kō ko é xntiī ú da mii tsī ña kúnaa, ña ntáduku ntée tatá ña Israee —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ntá tsi xée etsin ñadɨ̄ꞌɨ́ san ne, ínchɨtɨ ña nūu ña ne, kakaꞌan ña: —¡Vií nto da xeꞌe, Tóꞌo, xntii ntō ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kakaꞌan Jésuu ni ña: —Ñá vāꞌá ō é nakiꞌi o tañúꞌū é kāꞌxí iꞌxá kō dá kuēꞌé ō tínā san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ñadɨ̄ꞌɨ́ san ne, kakaꞌan ña: —Nuu é ntaā i é kākaꞌan nto, Tóꞌō, ntá tsi tínā sán ne, ntaéꞌxi tɨ utsi i é kākoꞌxo má mēsa tóꞌo tɨ̄ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kidáā ne, kakaꞌan Jésuu ni ña: —Dōo váꞌā ó kakuintiꞌxe o. Kuan koo na kuvi vatā ó ntio o —kaꞌan ña. Ura dúꞌva tsi i ntuváꞌa dióko ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ntāka Jesuu íkān ne, kuéꞌen ña dīñɨ míni Galileá san. Kúxee ña xuku kān né, ikān itúvi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ñá te da dīi da díi ñaꞌa xée ña mí tuví ña ne, ntēka ña ña xnéꞌe, ña niꞌi kuiꞌí i, ña kuāá, ña ñɨꞌɨ̄, ni tɨ̄tɨ́n ka ña ntánchokuví san. Tsōo ña ñaꞌa san nú dɨ̄ꞌɨ́n Jesuú ne, ntaváꞌa ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Koó dā kúduꞌva ñaꞌa san da íni ña e ntákaꞌan ñá ñɨꞌɨ̄ san, e ntuváꞌa ña niꞌi kuiꞌí i san, e nakaka ña xneꞌé san, e nakiní ña kuāá san. Ntákaꞌan ña e dóo kaꞌnu Xuva ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kidáā ne, kāna Jesuu ñá ntántīkɨn ñá ne, kakaꞌan ñá ni ñā: —Kantuntaꞌví ini kó un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san tsi é īta ntíꞌxin uni ntúvi e ntántoo ña iꞌa nī ko. Ña túvī ka é kaꞌxī ña. Ñá ntīo kó nataxnūu ú ña é kuan tsī koo, tsi ntákakɨn ña, tsí dā ná koo vita ña itsi kān dókō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ntákaꞌan ñá ntántīkɨn ña: —¿Míꞌi ntu kikīꞌi o tañúꞌū iꞌa mí xoxo ntoo i? ¿Nté ntu koo xee táꞌan é kaꞌxī ña, é ñā te da díi ñaꞌá san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kakaꞌan Jésuu ni ña: —¿Tɨtɨ̄n ntú tañúꞌū niꞌi nto? —kaꞌan ña. Nantíko koō ña, ntákaꞌan ña: —Úꞌxe kūdii tañúꞌu ni ūvi kudii a tsákā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kakaꞌan Jésuu ni ñáꞌa san é na kuntoo ña ñuꞌu kān. ");
INSERT INTO mizNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kīꞌi ña e uꞌxé tañúꞌū sán nī tsákā sán ne, nākuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō. Kidáā ne, taꞌvi dāva ñá ne, xéꞌe ñā ña ntántīkɨn ña é na tsīꞌi ña ntaꞌa ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ēꞌxí ntaꞌā ñá, un ntɨɨ́ ntɨɨ̄ ña. Dā kúvi ne, natáka ña é ntoó ka ne, úꞌxe xīka nátsuꞌun tsītu ká ña taꞌvi ī. ");
INSERT INTO mizNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ñá te da kɨ̄mi míil ñatīí san éꞌxi ña ne, ntē ña ni intéꞌvi ñadɨ̄ꞌɨ́ san, nté iꞌxá san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nataxnūu ña ñaꞌa san kídaā ne, nákunūu Jesuu tún ntōó san ne, da kuéꞌen ña ñūú Madala. ");
INSERT INTO mizNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Xéē ña fariseú san nī ña saduceú san é ncho koto nteé ña Jesuu. Ntaíkan ña te nañēꞌe ñá ña uun nuu i e dóo kaꞌnu é vēꞌxí e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ntá tsi kakaꞌan Jésuu ni ña: —Da kakuáā ne, ntákaꞌan nto: “Váꞌa iñɨ̄ teváā, tsi dóo dito xntɨvi e dukún kan”, xkoó kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tévāá ne, ntákaꞌan nto: “Dōo xóo iñɨ̄ vevii, tsi dóo ñuꞌu viko xéꞌe i kan”, kaꞌan nto. Te īni nto nté iñɨ̄ da ntaíto nto e dukún kān, ¿nté kui ñá ini ntu nto nté koo kuvi ñuxiví sa, da ntaíto nto nté o kakuvi vevii? ");
INSERT INTO mizNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ña kini ntáa, ña ntáde é kīni kaa sán ne, dɨvi ñā ntaíkan ña nuu i e dóo kaꞌnu, ntá tsi ña kuéꞌē ká Xuva ko nūu i é ntio ña, tsí da mii nūu i váta ō kúvi Jonaá san —kaꞌan ña. Kidáā né, ntāka Jesuu íkān né, tsoo mii ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dā xee ñá ntántīkɨn ña uun xo diñɨ ntute sán ne, kūtuni ña tsí kunánī ña é kuīdo ña tañúꞌū. ");
INSERT INTO mizNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kakaꞌan Jésuu ni ña: —Kini nto ne, kuenta tsí vií nto ni ūꞌxen íā iña ñá fariseu ni ñá saduceú san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kidáā ne, ntákaꞌan ñá ni tāꞌan ña: —Kuan ō kaꞌan ñá, tsi ña ni ído ō tañúꞌū san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Īni Jesuu née iña ntádē kuení ña ne, kakaꞌan ña: —¡Mpá! ¿Nté kui ña ntákuintiꞌxe váꞌa ntu nto? ¿Nté kui ntaítsuꞌun ntu nto tē ña ni ido nto tañúꞌū san? ");
INSERT INTO mizNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Vāta kutúni ntú nto? ¿Ñā ntu nakaꞌan nto tsí uꞌun tañúꞌū san éꞌxi uꞌun míil ñāꞌa sán ne, tɨ̄tɨ́n xiká ka ñuꞌu taꞌvi ī e ntóo ka é natāká nto? ");
INSERT INTO mizNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ntē ña ntu nakaꞌan nto e uꞌxe tsi tañúꞌū san e éꞌxi kɨmi míil ñāꞌa sán ne, tɨ̄tɨ́n xiká ka ñuꞌu taꞌvi ī e ntóo ka é natāká nto? ");
INSERT INTO mizNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nté kui ña kañeꞌe dɨkɨ ntu nto e ña te iña tañúꞌu ntīꞌxe san kakaꞌán u? Kuenta tsí vií nto ni ūꞌxen íā iña ñá fariseu ni ñá saduceú san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kidáā né, kūtuni ña tsí ña te kakáꞌan ña iña uꞌxen íā é kaidáka tañúꞌū san, tsí kakaꞌan ñá iña nuu i é ntánakuāꞌa ña fariseu ni ñá saduceú san. ");
INSERT INTO mizNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Dā xee Jésuu ñuú é nani Cesārea Filipú ne, kakaꞌan ñá nī ña ntántīkɨn ña: —Xuꞌu é vēxkúvi ú ñatīí ne, ¿neé ntu ñaꞌa ú, te kāꞌan ñáꞌa san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nantíko koō ña, ntákaꞌan ñá: —Iō ñá ne, ntákaꞌan ña tsí Juaan Bautista nto. Iō ñá ne, ntákaꞌan ña tsí Elia nto. Īo xtúku ña ne, ntákaꞌan ñá tsi Jeremia ntó, ō tuku ñaꞌa ña kakaꞌán naa Xuva ko nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kakaꞌan Jésuu ni ña: —Ntōꞌó ne, ¿xoó ñaꞌa ntu ú, te kuinī nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kakaꞌan Símuun Pedru: —Cristu ntó, Iꞌxá Xuva kō ña kantíto san nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kakaꞌan Jésuu ni ña: —Nté kuān nte váꞌā ó ni o, Sīmuun, iꞌxá Jonaa. Sáꞌā ne, ña te ñáꞌa ni nañēꞌe ñá o, tsí mii tsi Uvā kó, ña tuví e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kakaꞌán u ni ō tsí dɨvīn é Pedrú ne, dɨvī ó ne, xúu nchó kaꞌan. Nú xūu saꞌá xntītsí u xúkūn ko. Ña kúvi vīí doxiꞌí san nī ñaꞌa, ña ntákuintiꞌxe i ko. ");
INSERT INTO mizNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Taꞌxí u o ntakāá iña i mí kadē kûꞌvé Xuva kō e dukún kān. Da xōó ka ñaꞌa, ña é īó kuetsí i ñuxiví a ne, káꞌān tsí ña kúvi kɨ́ꞌvi ña e dukún kān. Kuan kōo vií Xuva kō e dukún kān dɨ. Da xōó ka ñaꞌa, ña é ntuváꞌa ni Xuva ko ñuxiví a ne, káꞌān tsí kuvi kɨ́ꞌvi ña e dukún kān. Kuan kōo vií Xuva ko ni ñā e dukún kān dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kidáā ne, kakaꞌan ñá nī ña ntántīkɨn ña é ña ku kaꞌán kueꞌen tsí ña ni da xōó ka ñaꞌa é Cristu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nté ntūvi tsikán ne, eni ntuꞌu Jēsuu kakaꞌan ñá nī ña ntántīkɨn ña é kantio é kɨ̄ꞌɨn ñá ñuú Jerusaleen. Ikān ne, ñá te da dīi núu ī dóo ntoꞌo ña ntaꞌa ñatā sán nī tóꞌō dutú nī mastrú leí san. Kaꞌní ña ña ne, te kūvi uni ntúvi ne, ntoto xtuku ña, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kidáā ne, kuéꞌen xīo Pedrú san ni ñā né, ikān de tíi ña ni Jēsuu, kákaꞌan ña: —Ñá te sāꞌá e ntio Xuva ko, Tóꞌō. Ñá te kuan kōo kuvi nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ntá tsi xkokoto Jēsuú ne, kakaꞌan ñá nī Pedru: —¡Ñá kuān xkoó kaꞌan, tsí kakaꞌan vátā ó kakaꞌan tóꞌō e ña váꞌā san! Ñá ku koton ntēén ko. Ñá te vatā ó kade kuení Xuva kō é kadē kuení o, tsí vata tsī ó de ñaꞌa san káden —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kidáā ne, kakaꞌan Jésuu ni ña ntántīkɨn ña: —Tē xoó ncho kuntīkɨn í ko ne, ñá vīí ka ña é ntio mii ña, ntá tsi na kuntīkɨn ñá ko, kuān te na kuví ña. ");
INSERT INTO mizNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tē xoó ntio i é nakāku ntuvi iña í ne, kunaá ña ntii dañu ntūvi. Ntá tsi tē xoó nakunaa i ntuvi iña i kuenta iñá ko ne, níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi. ");
INSERT INTO mizNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Neé ntu niꞌi ñatīí san te nīꞌi ña dá kanɨɨ ñūxiví sa, te nākunaá ña é tduiña ña? ¿Nté ntu kaa ntáꞌvi ñatīí san é tduiña ña? ");
INSERT INTO mizNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tsí xuꞌu é vēxkúvi ú ñatīí ne, kiꞌxi ú nī ánjē ko. Dōó kaꞌnu ñaꞌa ú, vatā ó kaꞌnu Uva kō. Kidáā ne, ntanáa ú ni ñāꞌa nee iñá idé ña xé un xé un ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nuu é ntaā i é kākaꞌán u ni ntō. Iō ñáꞌa e ntáñɨ̄ ñá iꞌa vevií ne, ña kúvī ñá da nté kinī ña é kixkadā kûꞌvé u ñuxiví sa —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dā kúvi iñu ntúvi ne, ntēká Jesuu Pedrú san ni Sāntiau, ni ení ña, ñá nanī Juaan, kueꞌen níꞌi ña ña ūun xuku e dóo dūkún ne, ");
INSERT INTO mizNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","nuu tsi ña ne, nadama kúñu Jēsuu. Nuu ña ne, xiꞌí nuu vatā ó kaxiꞌí nuu ngántii san ne, dóō é nuu ñā né, ntukuiꞌxīn kueꞌen. ");
INSERT INTO mizNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ura tsíkan ntii dîtó Muisee ni Élia, ñá kaꞌán naa Xuva ko kídaā ne, ntákaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kidáā ne, kakaꞌán Pedru ni Jésuu: —Dōo váꞌā o tsí ntoo ntɨ́ iꞌa, Tóꞌō. Tē ntio nto ne, xntītsí ntɨ uni á viꞌi íꞌa, uun iña nto, uun iña Muísee ne, uun iña Éliá dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Da nɨɨ kākaꞌán Pedrú san ne, xée ūun viko e dóo kaxiꞌí nuu mí ntoo ña ne, távi nūu ña. Kakaꞌan tátsin Xúva kō méꞌñū vikó san: —Ña sāꞌá ne, Iꞌxá miī kó, ña e dóo ntio ko. Dōo diní ko ni ñā. Kini nto é kākaꞌan ña —kaꞌan tátsín san. ");
INSERT INTO mizNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dā téku ña ntántīkɨn ñá san sáꞌā ne, nántūvé ña kúñu ña ñuꞌu kān né, dōo uꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ntá tsi véꞌxi Jēsuú ne, tɨɨn ntaꞌa ña ñā ne, kakaꞌan ña: —¡Nakuntáñɨ̄ nto! ¡Ñá ku uꞌvī nto! —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Dā íto ña ne, xōxó ka ña nguiī san. Da mii tsi Jēsuu ntítsi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dá kūntíi ña xuku sán ne, kakaꞌan Jésuu ni ña: —Ñá ku kaꞌān ntó ni da xōó ka ñaꞌa nee e íni nto da nté nantōto ú rkontûvi é xiꞌí u, xuꞌu é vēxkúvi ú ñatīi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ntátsixeꞌē ña ntántīkɨn ña: —¿Nté kui ntákaꞌán ntu mastrú leí san é dīꞌna Eliá san kíꞌxi ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kakaꞌan Jésuu ni ña: —Nuu é ntaā i tsí diꞌna Elia kíꞌxi ña ne, xtūví tuꞌvē ña é un ntɨꞌɨ̄. ");
INSERT INTO mizNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ntá tsi kakaꞌán u ni ntō tsi e kíꞌxi Elia, ntá tsi ña ni kutúni ñáꞌa san te dɨvi ñā né, ide ña ni ña da nēé ka é ntio ña. Kuan kōo ntoꞌo kó ntaꞌa ña dɨ, xuꞌu é vēxkúvi ú ñatīi —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kidáā ne, kutuni ña ntántīkɨn ña tsí kakaꞌan ñá iña Juaan Baútista. ");
INSERT INTO mizNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dā xeé ña mi dóo ntoo ñaꞌa ne, véꞌxi uun ñatīi mí tuví Jesuu. Ínchɨtɨ ña nūu ñá ne, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Tōꞌó, ntuntāꞌví ini nto iꞌxá ko, tsí kaxiꞌi míi nā ne, xntii nto nā. Dōó kantoꞌo na. Nuu nuu tsi kantava nuu na nchúꞌun kān ne, kakoꞌxó nuu na nú ntute kān dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","E kíxniꞌi ú na é ntāváꞌa ña ntántīkɨn ntó na, ntá tsi ña ni kuvi vií ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kakaꞌan Jésuu: —¡Nté o ntu! ¿Nté kui ña ntákuintiꞌxe ñaꞌa sán ko, ña e ntáde é kīni kaa? ¿Tɨ̄tɨ́n ka ntu ntuvi kutíi ú ni ntō? Kixníꞌi nto na īꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","De tíi Jesuu ni é ña váꞌā san ne, ntīi é ña váꞌā san é nuu nima na. Ura dúꞌva tsi ntuváꞌa na. ");
INSERT INTO mizNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kidáā ne, xéē ña ntántīkɨn ña mí tuví Jesuú ne, tsixeꞌe ña ñā: —¿Nté kui ña ni kuvi vií ntu ntɨ é nakūnu ntɨ́ e ña váꞌā san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kakaꞌan Jésuu ni ña: —Tsí ña te kanɨɨ̄ nima ntó ntákuintiꞌxe nto. Nuu é ntaā i é kākaꞌán u ni ntō tsí kuān te un síin kueꞌen tsi ntákuintiꞌxe nto ne, kuān te vata kaa uun kudii ntɨkɨn kulí san é kuintiꞌxe nto ne, kuvi kaꞌan ntó ni xūku san: “Kuēꞌén ikān”, ne, kɨ́ꞌɨ̄n. Ña túvī neé kueꞌen tsi é ña kuvi vií nto. ");
INSERT INTO mizNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ntá tsi e ña váꞌa vāta kaa sáꞌa ne, ña ntíi tē ña kuntóo ixu ō né, tē ña dóo kaꞌan ntâꞌví ō dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dá ntoo ña ñuú Galileá ne, kakaꞌan Jésuu ni ña: —Xuꞌu é vēxkúvi ú ñatīí ne, ntuvi ú kuenta ntáꞌa ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kaꞌní ña kó ne, te kūvi uni ntúvi ne, ntoto xtuku u —kaꞌan ña. Dōo kántoo ntaꞌxa ña ntántīkɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Dā xee Jésuu ñuú Capernau ni ña ntántīkɨn ñá ne, véꞌxi ña ntaído diuꞌun xôo iña xúkūn san mí tuví Pedrú san ne, ntákaꞌan ña: —¿Ña kantáꞌvi ntu mastru ntó diuꞌun xôó san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kakaꞌán Pedrú san: —Kantáꞌvi ña —kaꞌan ña. Dā kɨ́ꞌvi Pedrú san má viꞌi kān ne, diꞌna kakaꞌan Jésuu ni ña: —¿Nté ntu de kuéni o, Simuun? ¿Xoó ntu ntaꞌa i ntaído rei ñúxiví san diuꞌun xôó ni diūꞌun iña ñuꞌú san? ¿Ntaꞌa ña ñuú mii ñā né, ō ntaꞌa ña tuku ñuú san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kakaꞌán Pedru: —Ntaꞌa ña tuku ñuu —kaꞌan ña. Kidáā ne, kakaꞌan Jésuu ni ña: —Dukuān ne, ñá kantio é ntáꞌvi ña ñuú mii ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ntá tsi vata koo é ña kudíin ña ne, kueꞌēn nu míni kān ne, nakuitan xuꞌve é kantīkɨn kaa xuꞌu tsákā san. Tavan da nēé ka tsákā, kɨtɨ é tɨɨn diꞌna. Dá ntɨ̄kán xuꞌu tɨ ne, naníꞌi o uun diuꞌun kuetsi. Kiꞌin ne, da ntaꞌvin diuꞌun xôo ó ne, íñā kó dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ntuvi tsikán ne, xéē ña ntántīkɨn ña mí tuví Jesuú ne, ntákaꞌan ña: —¿Xoó ntu é dií ka kaꞌnu i mí kadē kûꞌvé Xuva kō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kāná Jesuu úun iꞌxá san ne, xtuvī ñá i méꞌñū ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kakaꞌan ñá ni ñāꞌa san: —Nuu é ntaā i é kākaꞌán u ni nto: Tē ña nadáma nto nima nto é kuintiꞌxe nto vatā ó de a iꞌxá kuetsī sán ne, ña kúvi kɨ̄ꞌví nto mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Xoó ñaꞌa, ña é ña káde kaꞌnu vata kaa iꞌxa saꞌá ne, dɨvi ñā é dií ka kaꞌnu ña mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Xoó ñaꞌa é kiꞌi ña uun iꞌxá vata kaa sáꞌa kuēnta iñá ko ne, vata te xūꞌu kíꞌi ña ko. ");
INSERT INTO mizNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ʼNtá tsi da xōó ka ñaꞌa é kuēꞌé ña itsi é vīi é kini kaa da nēé ka iꞌxá san é kakuintiꞌxe i kó ne, dií ka váꞌā ó te kunūꞌni uun xuu xodo kaꞌnu dúkun ñá ne, na kunuu ntoꞌo mii ñā má ntute ñuꞌu kān. ");
INSERT INTO mizNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ntāꞌvi ide ñá ñuxiví a tē kade ña é vīí tuku ñaꞌa kuétsī! Kuan tsi īó nuu i é kīni kaa, ntá tsi ¡ntāꞌvi ide ñaꞌa san, ña é kaxéꞌe itsi é vīí taꞌan ña é kīni kaa san! ");
INSERT INTO mizNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ʼTe ntāꞌa nto, o te dɨ̄ꞌɨ́n nto kade i é viī nto é kīni kaa san ne, kaꞌnté nto ne, nakuitā nto. Dií ka váꞌā ó te uꞌntu nto xēe ntó e dukún kān, te kāka xnéꞌe nto, é xēe niꞌi nto ntuvi ntáꞌa nto, ntuvi dɨ́ꞌɨn ntō dôꞌvi kan mi dóo kaiꞌxi ñúꞌú san. ");
INSERT INTO mizNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te ntūxnúu nto kade i é viī nto é kīni kaa sán ne, tavá nto ne, nakuitā nto. Dií ka váꞌā ó te xēe ntó e dukún kan ni ūun tsi ntuxnúu nto, é xēe niꞌi nto ntuvi ntúxnūu nto dôꞌvi kan mi dóo kaiꞌxi ñúꞌú san. ");
INSERT INTO mizNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ʼKoto ntó tē ña kadá kuení nto tē ña nuu áꞌvi iꞌxá san. Tsí kakaꞌán u ni ntō tsí e dukún kān ne, ánjē san é kade ña i kuentá ne, utén utén ntoo ña ntaꞌa Xuva kō, ña é tuví e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tsí xuꞌu é vēxkúvi ú ñatīí ne, véꞌxī u é nakākú u ñaꞌa, ña ntákunaá san. ");
INSERT INTO mizNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ʼ¿Nee iñá ntu ntádē kuení nto? Te ūun ñaꞌa né, īó uun sientu á leꞌntu ña ne, uun xtɨ kunaa tɨ ne, ¿ñā ntu te tsoo míi ña kɨtɨ kɨmi díko xeꞌun kɨmí san má kūꞌu kan dá kɨ̄ꞌɨn ña kínantúku ña kɨ̄tɨ uun, kɨtɨ kunaá san? ");
INSERT INTO mizNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Te nāniꞌi ña tɨ́ ne, nuu é ntaā i é kākaꞌán u ni ntō, tsí dií dií ka diní ña ni kɨ̄tɨ nániꞌi ña san é kɨtɨ kɨmi díko xeꞌun kɨmí, kɨtɨ ña ni kunáa san. ");
INSERT INTO mizNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kuān ó ni Uva kō, ña tuví e dukún kān. Ñá ntīo ña é kūnaa nté uun iꞌxá san. ");
INSERT INTO mizNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ʼTē kade taꞌan nto é kini kaa ni ntō né, kueꞌēn ntó mí tuví ña ne, káꞌan nto ni ñā nte o dé ña, da mii xnto ni ñā. Te kīni ña é kākaꞌan ntó ne, é ntūváꞌa nto ni tāꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ntá tsi tē ña kini ña é kākaꞌan ntó ne, kuntēka nto uun ne, ō uvi ñaꞌá ka ñaꞌa vata koo é kīni ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tē ña ntío ña kini ña e ntákaꞌan ñá tsīkán ne, káꞌan nto nī ña ntákuintiꞌxe i san, ña ntánataká nuu má ūkún kān. Tē ña ntío ña kini ña ña ntákuintiꞌxe i sán ne, ña kú de ká nto ña kuenta. Vií xnto kuenta tsí vata ntáa ñaꞌa, ña é ña ntákuintiꞌxe i, nī ña ntaído diuꞌun xôó san. ");
INSERT INTO mizNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ʼNuu é ntaā i é kākaꞌán u ni ntō: Da xōó ka ñaꞌa é kāꞌan ntó ni ñā ñuxiví a e ña kuvi kɨꞌɨn ña mí tuví Xuva kō ne, kuan tsi kōo kaꞌan Xúva ko ni ñā e dukún kān dɨ. Da xōó ka ñaꞌa é kāꞌan ntó ni ñā ñuxiví a é kūvi kɨꞌɨn ña mí tuví Xuva kō né, kuan kōo kaꞌan Xúva ko ni ñā e dukún kān dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ʼSáꞌa kākaꞌan xtúku ú ni ntō tsí te ūun tsi ntáde nto nima ntó uvi ñáꞌa nto da ntaíkan ntó ntaꞌa Xuva kō ne, Xuva kō, ña tuví e dukún kān ne, taꞌxi ña é ntaíkan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Dā míꞌī ka mí nataká nuu uvi uni ñáꞌa kuenta iñá ko ne, ikān tuví u méꞌñu ñā dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kidáā ne, xéē Pedru, kakáꞌan ñá ni Jēsuu: —Tōꞌó, ¿kiꞌin ito ntū kada kaꞌnu iní u ni tāꞌan ko dá kadē xení ña nī ko? ¿Vá ūꞌxe íto ntu? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Ñá kāꞌán u ni o te da mii tsī é ūꞌxe íto, tsí un tsi nté kɨ̄mí sientu kɨmi díko uꞌxi íto. ");
INSERT INTO mizNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ʼKuvi kaꞌan ó tsi mí kadē kûꞌvé Xuva kō ne, vata kaa uun rei é iō tɨtɨ́n ña ntáde tsiñu iña ñá kaa. Ntio ña natava ñá kuenta ñá ntáde tsiñu iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dā éni ntuꞌu ña tāvá ña kuentá san ne, xee níꞌi ña uun ñaꞌa, ña tanūu diuꞌun é vāta kaa uvi diko uun kuía xáꞌvi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ña ni kúvi ntanáa ña. Dukuān ne, kakaꞌan tóꞌo ñā é diko ña ñā, ni ña dɨꞌɨ̄ ñá, ni iꞌxā ñá, ni un ntɨꞌɨ̄ é īó iña ña, vata koo é na ntūnaa é tanūu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nákunchɨtɨ̄ ña kade tsiñu san núu ñá ne, íkan ña dā xeꞌe, kakaꞌan ña: “Na kūtíi ká nto nī ko, Tóꞌō. Ntanáa ntɨꞌɨ u é tanūu u”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ntūntaꞌví ini tóꞌo ñā ñá ne, nangava ña ñā né, nakadɨ̄ ñá kuenta ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Dā ntíi ña kade tsiñu san viꞌi tóꞌo ñā né, tāꞌán ña uun ñaꞌa, ña é kade tsiñu dadɨɨ ni ñā. Ña sāꞌá ne, tanūu ña diuꞌun taꞌan ña é vāta kaa uun sientu ntúvi xáꞌvi ñā. Ñaꞌa, ña é tanūu ña iña í san ne, írkāa ña dukun ña é nakuēꞌne ña ña ne, kakaꞌan ña: “Ntáꞌvīn ko é tanūun”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nákunchɨtɨ ña tanūu san núu ñá ne, kaikan ña kakaꞌan ña: “Na kūtíī ká nto nī kó, tsi ntáꞌvi ntɨ̄ꞌɨ́ u”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ntá tsi ña ni ntío ña tsikán ne, tsiꞌi kuétsi ña ñā ne, xnuu kutu ña ña dā nte ntáꞌvi ña é ita nūu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Dā íni ña ntáde tsiñu, ña nguiī san, nté ō kúvi ne, dōo dé kuení ña. Kuéꞌen ñā ne, káꞌan ña nī tóꞌo ñā nté ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kidáā né, kāna tóꞌo ña ña kuān ó de sán ne, kakaꞌan ñá ni ñā: “Ñá tē nté kaa kinī ó kaden. Xuꞌú ne, nakādɨ́ u kuenta ó tsi íkān kó da xeꞌe. ");
INSERT INTO mizNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Nté kui ña ni ntuntaꞌví ini ntu o taꞌan o, vatā o dé u ni ō?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kūdiin kuéꞌēn tóꞌo ña ni ñā né, ntāda ña ña kuenta ntáꞌa maú san é xnuu kutu ña ña dā nté ntanáa ntɨꞌɨ ña é tanūu ña —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Da kidáā ne, kakaꞌan ña: —Kuān koo vií Uva kō, ña tuví e dukún kan, ni nto tē ña kada kaꞌnú ini nto kanɨɨ̄ nima ntó ni tāꞌan nto dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Dā kúvi kaꞌan Jésuu sáꞌā né, ntāka ña ñuú Galileá ne, kuéꞌen ña ñūú Judea é tuví uun xo diñɨ ntute kaꞌnu Jordaán san. ");
INSERT INTO mizNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ñá te da dīi da díi ñaꞌa ntīkɨn ñá ña ne, ikān ntaváꞌa ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Véꞌxī ña fariseú san mí tuví Jesuu é kōto nteé ña ña ne, tsixeꞌe ña ñā: —¿Kākaꞌan ntú lei Muísee é xīi kaa é natsoo miī ntɨ́ ñadɨ̄ꞌɨ́ ntɨ dá nēé ka nuu i kuvi? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kakaꞌan Jésuu ni ña: —¿Vāta nakuáꞌa ntu nto túꞌun Xuva kō mí kākaꞌan tsí dɨvi ñā é dēváꞌa ña ñaꞌa ne, dē kúꞌvē ñá ñatīí ni ñadɨ̄ꞌɨ é kuntōo dadɨɨ ña? ");
INSERT INTO mizNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dukuān né, xtuvī mii ñátīí san uva ña ni dɨꞌɨ ñā é kuntōo dadɨ́ɨ ña ni ñadɨꞌɨ̄ ña. Uun tsi kúñū kúvi ña ntuvi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Viꞌi a vé ne, ñá te ūvi ñáꞌa ká ña, tsí uun sá ña. Dukuān ne, ña váꞌā o é nantii ntee taꞌan ñāꞌa san neé e teé taꞌan Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ntátsixeꞌe ña Jēsuu: —¿Nté kui kakaꞌan ntú Muisee é kuvi natsoo miī ntɨ́ ñadɨ̄ꞌɨ́ ntɨ kuan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kakaꞌan Jésuu ni ña: —Dā xe dóo kaꞌxi nima ntó ne, dukuān e táꞌxi Muisee é natsoo mii nto ñadɨꞌɨ̄ nto, ntá tsi ña te kuán o ni ntio Xuva ko nte ntúvi diꞌna. ");
INSERT INTO mizNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kakaꞌán u ni ntō tsí da xōó ka ñaꞌa é natsoo mii ña ñadɨꞌɨ̄ ña, ntá tsi tē ña te neé ni ide ñadɨ̄ꞌɨ́ san é kini kaa ni tuku ñatīí san ne, tē natántaꞌa ñatīí san ni tuku ñadɨ̄ꞌɨ́ ne, kade ña kuētsi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ntákaꞌan ña ntántīkɨn ña: —Te kuan kōo kuvi uun ñatīí ni ñadɨꞌɨ̄ ñá ne, dií ka váꞌā ó ē ña tántaꞌa ō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ntá tsi kakaꞌan Jésuu ni ña: —Ñá te ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa é kūtíi ña é nīꞌi ña sáꞌā, tsí mii tsi ñā é xeꞌe Xúva kō é kuan koo kuntōo ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Īó ñatīi é ña kuvi kóo iꞌxá ña, tsi e dúkuan kāa ña da káku ña. Iō túku ñatīí ne, ñaꞌa san ide ña e ña kuvi koo iꞌxá ña. Iō túku ñatīí ne, ña ntío ña tántaꞌa ña kuenta iña tsiñu e ntáde ña iña Xuva ko. Xoo kutíi i e kuintíꞌxe i sáꞌā né, na kuīntiꞌxe i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kidáā ne, xee níꞌi ña īꞌxá san mí tuví Jesuu é tɨɨn ntaꞌa ñā í, é kāꞌan ntâꞌví ña iña i. Ña ntɨniꞌi Jēsuú san ne, de tíi ña ni ñā ntánteka iꞌxá san, ");
INSERT INTO mizNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ntá tsi kakaꞌan Jésuu: —Kuéꞌe ntō itsi é na kīꞌxi iꞌxá san mí tuví u. Ñá ku kādɨ́ nuu nto i, tsí ñaꞌa é īó nima í vatā ó nima íꞌxá san ne, dɨvi ñā é kāduku ntée ña mí kadē kûꞌvé Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dā kúvi tɨ́ɨn ntaꞌa ntɨꞌɨ ña ī ne, da kidáā ntáka ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Xée uun ñatīi mí tuví Jesuú ne, tsixeꞌe ñā: —Mastrú, ¿neé ntu nuu i é vāꞌá kantio é vīí u vata koo é nīꞌí ko ntuví vaꞌá iñá ko ntii dañu ntūvi? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kakaꞌan Jésuu ni ña: —¿Nté kui katsixeꞌēn kó iña é vāꞌa? Da mii Xuva kō é vāꞌá ña. Te ntio o ntuvi vāꞌá iña o ntii dañu ntúvi ne, kadan ntaan é kākaꞌan Xúva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kidáā ne, kakaꞌan ña: —¿Neé ntu é kāda ntaa u? —kaꞌan ña. Kakaꞌan Jésuu: —Ñá ku ēꞌnín ñaꞌa. Ñá ku nakiꞌin ñadɨ̄ꞌɨ ñáꞌa. Ñá ku kīꞌin dúꞌun. Ñá ku kāꞌán dovete. ");
INSERT INTO mizNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kuikon ñuꞌun uva o ni dɨꞌɨ ō. Kuinima ó taꞌan o vatā ó kakuinima míi ō kúñu ō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kakaꞌan ñá ni ñā: —É un ntɨꞌɨ sāꞌá kade ntaa ú ntē da ku lúꞌntī u. ¿Neé ka ntu é kākunaa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kakaꞌan Jésuu ni ña: —Tē ncho viin é un ntɨꞌɨ̄ é vāꞌá ne, kuēꞌén, nadikon īña o ne, kuéꞌēn diuꞌún san ña ntāꞌví san vata koo e níꞌi o nuu i é vāꞌa é dukún kān. Kidáā né, kixntikɨ̄n ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dā téku ña é kākaꞌan Jésuú ne, kuntaꞌxa iní ña, tsi dóo kuika ña. Kuan tsi ō ntaka ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kakaꞌan Jésuu ni ñá ntántīkɨn ña: —Nuu é ntaā i é kākaꞌán u ni ntō. Tsi dóo ntii tuꞌun é xee ñá kuiká san mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kakaꞌán xtuku ú ni ntō tsí dií ka ña ntii tuꞌun é kɨ̄ꞌví uun kameu xávī xɨ́kɨ natee ō san é kɨ̄ꞌví uun ña kuiká san mí kadē kûꞌvé Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dā téku ña ntántīkɨn ñá sáꞌā ne, koó dā kúduꞌva ña. Ntákaꞌan ña: —¿Xoó ntu kūvi nakáku i kuan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Īto Jesuu ñá ne, kakaꞌan ñá ni ñā: —Ñaꞌa sán ne, ña kúvi nakākú mii ña nima ñá, ntá tsi Xuva kō ne, un ntɨɨ́ ntɨ̄ɨ́ kuvi vií ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kidáā ne, kakaꞌán Pedru: —Ntɨꞌɨ́ ne, é xtuvī mii ntɨꞌɨ́ ntɨ é kuntīkɨ́n ntɨ nto. ¿Nee iñá ntu niꞌi ntɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō tsí ikan ñūxiví xēé san ne, kutūví u, xuꞌu é vēxkúvī ú ñatīi, nú teu kaꞌnú ko ne, dɨvi ntō e ntántīkɨn ntó ko ne, kuntōo nto uxuvi teu naꞌnú san dɨ, kadā kúꞌvē nto iñá uxuvi táta ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Da xōó ka ñaꞌa, ña é xtuvī mii i viꞌi i, ō ení ña, ō taꞌan ñá, o uva ñā, o dɨꞌɨ ñā, ō iꞌxá ña, o ñūꞌu ña kuenta iñá ko ne, níꞌi ña ūun sientu íto ká xtuku. Níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ntá tsi tɨtɨ́n ñaꞌa, ña é odo nūu vevií ne, nte áta i kan kuntōo ña te kúvi ne, ña é ntoo ata i kān vevií ne, kodo nuū ñá kídaā. ");
INSERT INTO mizNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ʼMí kadē kûꞌvé Xuva kō ne, vata kaa tóꞌo vīꞌí san kaa. Tévāá tsi kañeꞌe ñá, kaixntuku ñā xoó kada tsiñu i matú ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kakaꞌan ñá ni ñāꞌa san tsi ntáꞌvi nɨɨ ña ña ntūvi é kāda tsiñu ña ne, taxnūu ña ña matú ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kaeku ɨɨn teváa ne, īní ña tsi ntâñɨ́ ka tuku ñaꞌa nú āꞌví kān é ña te neé ntáde ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kakaꞌan ñá ni ñā: “Kūkada tsiñu nto matú ko kān ne, ntáꞌvi vaꞌa ú nto”, kaꞌan ña. Ne, kuéꞌen ña kūkada tsiñu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kuan tsī ó de ña dá kii xtúku ña da káꞌñu ntuvi ne, kaeku uni kuáa dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dā kaéku uꞌun kuáa ne, kii xtūku ña ne, níꞌī ká ña ñaꞌa, ña é ña tuví nee é vii. Kakaꞌan ñá ni ñā: “¿Nté ntū ó de nto iꞌa? ¿Nté kui ña ntáde tsiñu ntu nto?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ntákaꞌan ñá ni ñā: “Ñá ni nīꞌí ntɨ xoó taꞌxi i ntɨ́ tsiñu”, kaꞌan ña. Kakaꞌan tóꞌo ī sán ni ñā: “Kueꞌēn ntó matú ko kan kūkada tsiñu nto dɨ”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Dā kúneé ne, kakaꞌan tóꞌo tsīñu sán ni ña odo nūú nuu tsiñú san: “Kūkaná nto ña ntáde tsiñu sán ne, ntáꞌvi nto ñā, diꞌna ña é xeé rkontuvi. Nté ata i na ntīi ña xee nte díꞌna”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ña xee kaéku uꞌun kuáa ne, níꞌi ña xāꞌví ña é uun ntúvi. ");
INSERT INTO mizNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ña xee díꞌna ne, dií ka kueꞌe níꞌi ña, kuíni ña. Ntá tsi kuédadɨɨ tsi niꞌi ña é un é un ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dā ntuáꞌvi ña ne, káꞌan ntēé ña tóꞌo tsīñu san, ");
INSERT INTO mizNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ntákaꞌan ña: “Uun ura kúdii dé tsiñu ñaꞌa san, ña xeé rkontuvi é ntɨꞌɨ́ ne, dadɨɨ tsi o ntuáꞌvī ntɨ́ ni ñā. Ntɨꞌɨ́ ne, nɨɨ ntuvī dé tsiñu ntɨ. Dōo ntóꞌo ntɨ́ kaꞌni san”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kakaꞌan tóꞌo tsīñu san ni ña: “Ñá te kāde u é kini kaa ni ntō. ¿Ña ni káꞌan ntú nto nī ko tsi váꞌā o xaꞌví nto dá kākaꞌán u ni ntō? ");
INSERT INTO mizNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kūniꞌi nto xáꞌvi ntō né, kueꞌēn nto. Xuꞌú ne, ncho vii ú nī ña xee da rkontuví san vatā o dé u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Vá ña kuvi ntu vií u é ntio kó nī diuꞌún ko? ¿Ō ntákuneꞌu iní ntu nto tsí ña kade víni u?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kuan kōo kuvi ni ña véꞌxi ata i kán dɨ; diꞌna ña kodo núu ña ne, ña é odo nūú diꞌna ne, kuntōo ña nte ata i kan. Tsí kuān te tɨtɨ́n ñaꞌa kana ú ña ne, ñá tɨ̄tɨ́n ña kuéꞌe u é kodo nuū ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dá kuēꞌen Jésuu itsi Jerusaleén ne, nakana xio ña uxuvi ñáꞌa ña ntɨniꞌi ñā ne, kakaꞌan ñá ni ñā: ");
INSERT INTO mizNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Kiní nto, tsí kɨꞌɨn o ñuú Jerusaleen. Ikān ntada ña kó kuenta ntáꞌa tóꞌō dutú san nī mastrú leí san. Káꞌan ñā tsí kuví u, xuꞌu é vēxkúvi ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ntada ña kó kuenta ntáꞌa ña tuku ñuú vata koo é kīni dɨ́kɨ ña ko ne, natii nuu ña kó xoꞌo. Xnteē ñá ko ntiká krusi kán dɨ. Ntá tsi ntoto xtuku ú te kuvi ūni ntúvi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kidáā ne, xée dɨꞌɨ īꞌxá Zebedeú san mí tuví Jesuu, xee níꞌi ña iꞌxā ña. Nakunchɨtɨ ña nūu ña ne, íkan ña da xeꞌe. ");
INSERT INTO mizNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kakaꞌan Jésuu ni ña: —¿Nee iñá ntu ntio nto? —kaꞌan ña. Kakaꞌan ñá ni ñā: —Káꞌan nto na kadā kûꞌvé dadɨɨ ntuvi iꞌxá ko ni ntō mí kadā kúꞌvē nto; uun chí ne, diñɨ kuaꞌa nto ne, uun chí ne, diñɨ datsin nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ntá tsi kakaꞌan Jésuu ni ña: —Ñá īni nto nee é kaikan nto. ¿Kūtíi ntu ntō é ntōꞌo nto é vāta koo ntoꞌo ko? —kaꞌan ña. Ntuvi ñátīí san ntákaꞌan ñá ni ñā: —Kuvi vií ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kakaꞌan Jésuu ni ña: —Ntoꞌo ntiꞌxe nto vata koo ntoꞌo ko, ntá tsi ña te xúꞌú kaduku ntée u é kuēꞌé u xoó kutūvi í diñɨ kuaꞌa kó, ō xoó kutūvi í diñɨ datsin ko, tsí Xuvā ko e dé kuꞌvē ña xoo é kuntoo dadɨɨ i nī ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Dā kútuni uꞌxi ñáꞌa ña nguiī sán ne, kūdiin ñá nī Juaan ni Sántiaú san. ");
INSERT INTO mizNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ntá tsi kána Jesuu ñá ne, kakaꞌan ñá ni ñā: —Īni ntó tsi tóꞌō ña é ña te ñá Israeé ne, dōo ntáde naꞌnu ña ni ñāꞌa ña. Dōó ntii ntádē kúꞌvē ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ñá ku kuān xkoó de nto. Da xōó ka ñaꞌa nto é ncho vií kaꞌnu nto ne, xntii nto tāꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Da xōó ka ñaꞌa nto é ncho kodo nuū ntó ne, xntii nto tāꞌan ntó, ");
INSERT INTO mizNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","vatā ó de ú, xuꞌu é vēxkúvi ú ñatīi. Ñá te vēꞌxi u é xntii ñāꞌa sán ko, tsí véꞌxī u é xntīi ú ña ne, é kuēꞌé u ntuvi iñá ko kuenta iña ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Dā ntáka ña ñuú Jericoó ne, ñá te da dīi da díi ñaꞌa ntántīkɨn ñá Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Uvi ñá kuāa san ntántoo ña diñɨ itsi san. Dā téku ña tsi kuítā ntiꞌxin Jesuú ne, un ntii tsī ntákaꞌan ña: —¡Ntuntāꞌví ini nto ntɨ́, Iꞌxá ika Dāvii, ña táxnuu Xuva kō é kadā kúꞌvē ntó iñá ntɨ! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ntáde tíi ñaꞌa san ni ña, ntákaꞌan ña é diin diin tsi kuntōo ña. Ntá tsi da dií dií ka ntii ntákaꞌan ña: —¡Ntuntāꞌví ini nto ntɨ, Tóꞌō, Iꞌxá ika Dāvii! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Íntītsí Jesuú ne, kāna ña ña. Kakaꞌan ña: —¿Nee iñá ntu é ntio nto é vīí u ni ntō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ntákaꞌan ñá ni ñā: —Nakaán nto ntuxnūú ntɨ, Tóꞌō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ntuntāꞌví ini Jesuu ñá ne, tɨɨn ntaꞌa ña ntūxnúu ñā ne, ura tsí i náxiꞌí ntuxnūú ña. Kidáā ne, íntīkɨn ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Dā xee étsin ña ñuú Jerusāleen, dá ntoo ña ñuú Befagee mí tuví xuku Olivú san ne, taxnūu Jesuu úvi ñaꞌa ña ntántīkɨn ña, ");
INSERT INTO mizNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kakaꞌan ñá ni ñā: —Kueꞌēn ntó ñuu é tuví daꞌa san. Ikān ne, naniꞌi nto uun búru é ntee tɨ́ɨn tɨ ni iꞌxā tɨ. Nantuté nto tɨ ne, dá kixniꞌi nto tɨ̄. ");
INSERT INTO mizNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te tsixeꞌe ñāꞌa san nto nté kui kánantute nto tɨ́ ne, káꞌan ntō tsi tóꞌo nto kāntio ña tɨ. Tē kúvi dé tsiñu niꞌi ña tɨ ne, ura tsí i nataxnūu ña tɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kuan ō kúvi vata koo é kūntaa é kākaꞌan ña é kaꞌán naa Xuva ko kídaā: ");
INSERT INTO mizNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Káꞌan nto nī ña ñuú Siuun: “Koto nto, tsi véꞌxi reí nto mí ntoo nto. Ñá te kāꞌnu ñaꞌa kade ña; ntekú ña buru, uun a búru, kɨtɨ é vāta xoo kuntéku í tɨ, iꞌxá buru ntíi, kɨtɨ kaido san.” Kuan kōo kaꞌan nto, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kuéꞌēn ña ntántīkɨn ñá ne, de ntaa ña vatā ó kakaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kueꞌen níꞌi ña būrú san ni iꞌxā tɨ́ ne, tsodo ña dōo ña áta iꞌxá tɨ ne, ikān intéku Jesuu tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ñá te da dīi ñaꞌa ntáñɨ̄ ñá ikān né, tsōo ña doo ñá itsi kān. Iō ñá ne, katsin ña ntáꞌa utun ne, tsoo ña itsi san. ");
INSERT INTO mizNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ñá te da dīi ñaꞌa odo nuú ña nuu ñá ne, ñá te da dīi ñaꞌa véꞌxi ña atā ñá dɨ. Un ntɨɨ́ ntɨɨ̄ ña ntákaꞌan ña: —¡Dōo váꞌa Iꞌxá ika Dāvii, ña táxnuu Xuva kō! ¡Na xnuu viko Xuva ko ñā, ña é vēꞌxí kuenta iña ña! ¡Dōo káꞌnu Xuva kō, ña tuví e dukún kān! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dā xee ñá ñuú Jerusaleén ne, un ntɨɨ́ ntɨ̄ɨ́ ña ñuú i san ne, itsuꞌun ñā, ntákaꞌan ña: —¿Xoó ñaꞌa ntu ña sāꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ntákaꞌan ñáꞌa san, ña vexníꞌi ña: —Ña sāꞌá ne, ña é kākaꞌán naa Xuva ko, ñá nani Jēsuu, ñá vēꞌxi ñuú Nazaree é tuví ñuú Galilea —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kúkɨ̄ꞌví Jesuu má ūkún Xuva kō ne, nakúnu ña ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña e ntádikō, ña e ntáñii kɨtɨ é kuēꞌé ña doméni iña Xuva ko. Ini ukún san ntoo ña. Nantáva Jēsuu mesa ñáꞌa, ña ntánadama diuꞌún san, ni sīa ña ntádiko pāloma. ");
INSERT INTO mizNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kakaꞌan ñá ni ñā: —É ūve naꞌa túꞌun Xuva kō: “Viꞌi kó ne, viꞌi mí kaꞌan ntâꞌví ñaꞌa”, kaꞌan. Ntá tsi ntōꞌó ne, ntáde nto mâvi ñá duꞌu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Dá tūví Jesuu má ūkún kān ne, véꞌxi ña kuāá san nī ña xneꞌé ne, ntāváꞌa ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ntá tsi kúdiin tóꞌō dutú san nī mastrú leí san dā íni ña nté ō dé Jesuu nuu i e dóo naꞌnu san. Īní ña tsí un ntii tsī ntákaꞌan iꞌxá san má ūkún kān: “¡Dōó kaꞌnu Iꞌxá ika rei Dāvii!” Kuān o ntákaꞌan iꞌxá san. ");
INSERT INTO mizNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ntákaꞌan ñá ni Jēsuu: —¿Ña katéku ntu nto tsí dovéte ntákaꞌan iꞌxá san iña nto? —kaꞌan mastrú leí san. Kakaꞌan Jésuu ni ña: —Katekú ko nté ō ntákaꞌan. Vāta kiní ntu nto mí kakāꞌan túꞌun Xuva kō: Iꞌxá kuetsī sán ni īꞌxá ɨkɨn ne, xéꞌe Xuva kō é kāta é vāꞌá kueꞌen Xúva kō. Kuan ō kaꞌan —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kidáā né, ntāka Jesuu mí ntoo ña ne, kuéꞌen ña ñūú Betania mí itúvi ña uun ñúu. ");
INSERT INTO mizNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tévāá, dā ntíko kōo ñá ñuú Jerusaleén ne, kakakɨn Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Īní ña uun tun ígu dīñɨ itsi san. Kuéꞌen ñā mí ntitsí ne, da mii xūku í uve. Kakaꞌan ña: —¡Ña kóō ká kɨtɨ o! —kaꞌan ña. Ura dúꞌva tsi i ítsi ūtun san. ");
INSERT INTO mizNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Koó dā kúduꞌva ña ntántīkɨn ña da íni ña utun san. Ntákaꞌan ña: —¿Nté ō ntu é uun daꞌna tsi ítsi tun ígū san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō: Te kuintiꞌxe nto Xuva ko, tē ña kadá kuení nto é ña kuvi vií ña ne, ñá te sāꞌá tsi é kūvi vií nto, vatā o dé u nī tun ígū san. Tsí kuvi kaꞌan ntó ni xūku sáꞌā dɨ: “Kuēꞌén, kōꞌxón nuun ntute ñuꞌu san.” Te kuan kōo kaꞌan ntó ne, kuan kōo kuvi. ");
INSERT INTO mizNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Da nēé ka é kakan ntó ntaꞌa Xuva kō dá ntákaꞌan ntâꞌví nto ne, te kanɨɨ inī ntó ne, níꞌi ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Dá kūkɨ́ꞌvi Jesuu má ūkún kān ne, véꞌxī tóꞌō dutú san ni ñatā san mí tuví Jesuu dá kanakuāꞌa ña ñaꞌa sán ne, ntákaꞌan ñá ni ñā: —¿Nté o ntu é kūvi vií nto nuu i é kade nto? ¿Xoó ntu de kúꞌvē i é viī nto sáꞌā? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kakaꞌan Jésuu ni ña: —Tsixēꞌé u nto uun nuu í dɨ. Te nantiko koō ntó ne, kidáa kāꞌán u ni ntō nté ō kúvi é kūvi vií u nuu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Xoó ntu de kúꞌvē i é nakūtsi ntute Juaan ñáꞌa san? ¿Xuva ntu kō de kúꞌvē ñá, o kūdii ñaꞌa ntú san de kúꞌvē ña? —kaꞌan ña. Ntákaꞌan míi tóꞌō dutú san ni ñatā san: —Te kāꞌan o tsí Xuva kō de kúꞌvē ñá ne, kidáā ne, tsixeꞌe ña kō nté kui ña ni kuintíꞌxe kō Juaan. ");
INSERT INTO mizNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ntá tsi te kāꞌan o tsí kūdii ñaꞌá san de kúꞌvē ñá ne, uꞌvī kó te kūdiin ñaꞌá san ni kō tsí ñá kaꞌán naa Xuva kó Juaán san, kuiní ña —kuan ō dé kuení ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dukuān ne, ntákaꞌan ñá ni Jēsuu: —Ñá iní ntɨ —kaꞌan ña. Kakaꞌan Jésuu ni ña: —Ntē ña kaꞌán u dɨ xoó de kúꞌvē i é vīí u sáꞌā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kakaꞌan Jésuu: —¿Nee iñá ntu kadē kuení nto iña nuu i sáꞌa? Uun ñatīí ne, xío ūvi iꞌxá ña. Kuéꞌen ñā mí tuví iꞌxá nuu í san ne, kakaꞌan ña: “Ō daꞌ, kukutun vevíi”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kakaꞌan na: “Ñá kɨ̄ꞌɨ́n u”, kaꞌan na. Ntá tsi dā ku e víꞌi ne, nātɨvi iní na ne, kuéꞌen nā. ");
INSERT INTO mizNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kidáā ne, kuéꞌen uva nā mí tuví iꞌxa é kui ūví ne, dadɨɨ tsi o kakaꞌan ñá ni nā. Na sāꞌá ne, kakaꞌan na: “Kɨ́ꞌɨ̄n ú, ūva”, kaꞌan na, ntá tsi ña ni ñéꞌe na. ");
INSERT INTO mizNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Neé ntu naꞌa dé ntaa na é ntio uva nā, kuan? —kaꞌan Jésuu. —Iꞌxa nuu í san —kaꞌan ña. Kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō, tsí diꞌna xee ña ntaído diuꞌun xôó san ni ñadɨ̄ꞌɨ́ kini ntáa san mí kadē kûꞌvé Xuva kō é dɨvi ntō. ");
INSERT INTO mizNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tsi dá kīꞌxi Juaan Bautistá ne, kakaꞌan ñá ni ntō nté koo vií nto é vāꞌa, ntá tsi ña ni kuintíꞌxe nto ña. Da mii tsī ña ntaído diuꞌun xôó san ni ñadɨ̄ꞌɨ kini kaa san kuíntiꞌxe ña ña. Kuān te íni nto nté ō dé ña kini ntáa san ne, ñá ni nātɨvi iní nto, ntē ña ni kuintíꞌxe nto é kākaꞌan Juaán san —kaꞌan Jésuu—. ");
INSERT INTO mizNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ʼKini tuku nto nuu i sáꞌa. Uun tóꞌo vīꞌi ne, íꞌxi ñā xoꞌo tɨntiꞌo. De váꞌa ña xaku diñɨ i kān. Ēte nuu ña xavi mí kādin ñá tɨntiꞌó san ne, xntitsī ñá uun viꞌi dūkun mí kotō dítō ña. ʼKidáā ne, tsuꞌun nteé ña tuku ñaꞌa é viī ñá kuentá ne, dá kueꞌēn ñá tuku ñuu. ");
INSERT INTO mizNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dā xee ntúvi é tɨ̄ɨn ña kɨtɨ i ne, taxnūu ña ña ntáde tsiñu iña ña e kínakuido ñá vata kaa é kāduku ntée ña mí ñūꞌu ña ñuꞌu ntee é tātá san. ");
INSERT INTO mizNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ña ñuꞌu ntee é tātá san ne, tɨ̄ɨn ña ña ntáde tsiñu san. Uun ñaꞌa ñā né, nákāꞌxí vaꞌa ñá ña. Uun ña ne, ēꞌní kueꞌen ñá ña. Uun ña ne, xeꞌe xúu ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Taxnūu xtuku tóꞌo ī sán dií ka tɨtɨ́n ña ntáde tsiñu iña ña e ña táxnūu diꞌna ña. Kuan tsi ō dé xtuku ña ñuꞌu nteé xoꞌo tɨntiꞌó san ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ʼDa rkontûví ne, taxnūu ña iꞌxá mii ñā, tsí da miī é kuiko ñūꞌu ñaꞌa san iꞌxá mii ña, kuíni ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ntá tsi dā íni ña ñuꞌu ntee xoꞌo tɨntiꞌó san tsi véꞌxi mii īꞌxa tóꞌo ñā ne, ntákaꞌan ñá ni tāꞌan ña: “Na sāꞌá ne, na kiꞌi na iña uva na tē xiꞌi ña. Kɨ́ꞌɨn ō ne, kaꞌní o nā. Kidáā ne, níꞌi ko īña uva na”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tɨ̄ɨn ña na ne, nákuitā ñá na ata ī mí kaeꞌnu xoꞌo tɨntiꞌó san ne, eꞌní ña na —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kidáā né, katsixeꞌe Jēsuu: —Tē xee míi tóꞌō xoꞌo tɨntiꞌó san ne, ¿nté koo vií ntu ña nī ña ñuꞌu ntee é tatā ña? —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ntákaꞌan ñátā san ni tóꞌō dutú san: —Uun ito tsi kaꞌní kueꞌen ña ña ñuꞌu ntee, ña é kīni ntáa san. Kidáā ne, kuéꞌe ñā é tātá san ntaꞌa tuku ñaꞌa, ña é nakuéꞌe i ña kɨtɨ tɨntiꞌó san ntuvi te tɨ̄ɨn ña tɨ, vata kaa é kāduku ntée ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kakaꞌan xtúku Jesuu ni ña: —Vāta nakuaꞌa ntu nto mí ūve naꞌa kakaꞌan túꞌun Xuva kō: Xuu é nakuītá ña ntádamá san ne, dɨvi kūvi xuu kuꞌve etɨ́ viꞌi san. Sáꞌā né, Xuva kō de kúꞌvē ñá ne, íña kō né, dōo váꞌā o dé ña, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Dukuān ne, kakaꞌán u ni ntō tsí nakiꞌi Xuva ko tsīñu nto ne, nakuéꞌe xio ña tuku ñaꞌa, ña é īni de ntáa é ntio ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kuenta iña xuú san ne, da xōó ka ñaꞌa, ña é nākɨꞌɨ́ xuú san ne, táꞌnu kueꞌen ñā. Ntá tsi da xōó ka ñaꞌa, ña é kōꞌxó ntōdó xuú san ne, tádin kuēꞌen ñá dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Dā téku tóꞌō dutú san nī ña fariseu núu i sáꞌa ne, kueꞌen dɨ́kɨ ña é kākaꞌan Jésuu íña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ntá tsi kuān té ncho tɨɨn ña Jesuú ne, úꞌvī ñá un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, tsi ntádē kuení ñaꞌa san tsí Jesuú ne, ñá kaꞌán naa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ntāa xtuku Jesuu núu i sáꞌa ni ñā. Kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Mí kadē kûꞌvé Xuva kō ne, vata kaa uun rei, ña é dé kaꞌnu viko dá tántaꞌa iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Taxnūu ña ña ntáde tsiñu iña ña é kāna ña ñaꞌa san é kāꞌan ñá ni ña te kīꞌxi ña viko san. Ntá tsi ña ni ntío ñaꞌá san kiꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Taxnūu xtuku ña tuku ñaꞌa, ña ntáde tsiñu iña ñá ne, kakaꞌan ñá ni ñā: “Kūkaná nto ñaꞌa san, ña é kāꞌan niꞌí u nte díꞌna. Káꞌan ntō tsi é iō tuꞌve é kāꞌxi o. Ēꞌní u duntɨkɨ́ ko ni kɨ̄tɨ e dóo váꞌā ó ni ī. É iō tuꞌvé ntɨꞌɨ́ ve. Na kīꞌxi xña viko e tántaꞌa iꞌxá ko”, kaꞌán reí san. ");
INSERT INTO mizNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ña ni íde ñāꞌa san kuéntá ne, xío kuēꞌen ña. Uun ña ne, kukútu ñā ne, uun ña ne, kudíko ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ña nguiī sán ne, tɨ̄ɨn ña ña ntáde tsiñu iña reí san ne, dē xení ña ni ñā né, ēꞌní ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Un váꞌa tsī kúdiin reí san ne, taxnūu ña sntadun ña é kaꞌnī ñá ña éꞌni ña ntáde tsiñu iña ñá ne, é na kāꞌmi ña ñuú ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kidáā ne, kakaꞌan ñá nī ña ntáde tsiñu iña ña: “Iō tuꞌvé viko e tántaꞌa iꞌxá ko, ntá tsi ña e kána ú ne, ñá ni de ntāa ña é kīꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dukuān né, kueꞌēn ntó itsi kān ne, káꞌan nto ni da xōó ka ñaꞌa é nīꞌi nto é kīxkaꞌxí ña, kuān te tɨtɨ́n ña”, kaꞌán reí san. ");
INSERT INTO mizNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kuéꞌēn ña ntáde tsiñu iña ñá itsi kān ne, xee níꞌi ña ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña é niꞌi ña, kuān te váꞌa ñaꞌa ña, kuān té ña váꞌa ñaꞌa ña. Dā xee un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, tsitu kuēꞌen ñáꞌa san viꞌi mí kākuvi viko san. ");
INSERT INTO mizNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ʼNtá tsi dā xee reí san é kōto ña ña xee sán ne, īni ña é tuví uun ñaꞌa, ña é ña tuvi dúꞌnu váꞌa i iña vikó san. ");
INSERT INTO mizNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kakaꞌan ñá ni ñā: “O dee, ¿nté kui táꞌxi ntu ña é kɨ̄ꞌví nto iꞌa, tsí ña te núu nto doo váꞌa nto iña vikó san?”, kaꞌan ña. Ntá tsi nté uun ña ni káꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kidáā ne, kakaꞌan reí san nī ña ntáxntii ñā: “Kiꞌní nto ntaꞌa ña sāꞌá ni dɨ̄ꞌɨ́n ña dɨ́ ne, nakene iko nto ñā kíꞌi kān mi dóo nee. Ikān dóo kueku ñaꞌa san ne, nakaꞌxí kaꞌñɨ̄ ña núꞌu ñā”, kaꞌán reí san. ");
INSERT INTO mizNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tsí kuān te tɨtɨ́n ñaꞌa kana ú ña ne, ñá te tɨtɨ̄n ñá nakaxnúū ú ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kidáā né, ntāka ña fariseú san ne, ntántukū nuu iní ña nté koo vií ña é nadāna ña Jesuu núu i é kākaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Taxnūu ña ña ntántīkɨn ñá nī ña ntántīkɨ́n Heródē san mí tuví Jesuu. Ntákaꞌan ña: —Mastrú, iní ntɨ tsi nuu é ntaā i é kākaꞌan nto, tsí kanakuāꞌa ntiꞌxe nto iña Xuva ko. Ñá kāde nto kuenta née iñá ntádē kuení ñaꞌa san. Ntē ña kaúꞌvī ntó ña, kuān te naꞌnu ñáꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Káꞌan nto vē, nee iñá kadē kuení nto. ¿Vāꞌá ntu o é kuēꞌé ō diuꞌun xôó san ntaꞌa ña tsiñu naꞌnu i ñuú Romá san ne, ō ñaꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ntá tsi ini Jésuu tsi dóo kinī o dé kuení ña iña ñá ne, kakaꞌan ña: —¿Nté kui ntaíto nteé nto ko, ntōꞌo e ntaéni ntaꞌví nto ñaꞌa? ");
INSERT INTO mizNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nañēꞌe ntó ko diuꞌun e ntáꞌvi nto diuꞌun xóō nto —kaꞌan ña. Xéꞌe ña ña ūun diuꞌun é kōto nteé ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kakaꞌan Jésuu ni ña: —¿Xoó ntu nuu i é ntee íꞌa? ¿Xoó ntu dɨvī í e ntée naꞌá san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ntákaꞌan ña: —Íña ña tsiñu naꞌnu i ñuú Romá san —kaꞌan ña. Kidáā ne, kakaꞌan Jésuu ni ña: —Nakuéꞌe nto ntaꞌa ña tsiñu naꞌnu i san nee é kāduku ntée ña ne, nakuéꞌe nto ntaꞌa Xuva ko nēe é kāduku ntée ña dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dā téku ña sáꞌā ne, koó dā kúduꞌva ña. Ntaka ña ikān ne, kúnūꞌú ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ntuvi tsikán ne, xéē ña saduceú san mí tuví Jesuu. Ña sāꞌá ne, ña ntóto xtuku o tē xiꞌi o, kuíni ña. Tsixeꞌe ña Jēsuu: ");
INSERT INTO mizNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Mastrú, káꞌān Muísee tsí te kūví uun ñatīí ne, ñá ni xīó iꞌxá ña ne, kuétsī e tántaꞌa ení ña ni ñadɨ̄ꞌɨ kií san vata koo é kōo iꞌxá ña kuenta iña ení ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Viꞌi a vé ne, ña ntoo niꞌī ntɨ́ ne, xío ūꞌxe ñáꞌa ení ña. Iꞌxa nuu í san ne, tántaꞌa ña, ntá tsi xiꞌi ñá diꞌna dá kōo iꞌxá ña. Kidáā ne, tántaꞌa xtuku ení ña ni ñadɨ̄ꞌɨ kií san. ");
INSERT INTO mizNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kuan ō kúvi nī ña é kuvi ūví san dɨ, nī ña é kuvi ūní san, dā nte tántaꞌa ñadɨ̄ꞌɨ kií san nī ña é kuvi ūꞌxe san. ");
INSERT INTO mizNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dā xiꞌi ntɨ́ꞌɨ ña ne, kidáā ne, xíꞌi ñadɨ̄ꞌɨ́ san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dukuān né, te ntoto xtuku ō né, ¿Xoó ntu kuvi ntiꞌxe ñadɨ̄ꞌɨ i é ūꞌxe ñáꞌa san? Tsí un ntɨɨ́ ntɨɨ̄ ña tántaꞌa niꞌi ña ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ntá tsi kakaꞌan Jésuu ni ña: —Ntádana nto, tsi ñá ini nto nté o kakaꞌan túꞌun Xuva kō, ntē ñá ini nto e dóo kaꞌnu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tsí te ntoto xtuku ō ne, ña tántaꞌa ká ñaꞌa, tē tií, te ñadɨ̄ꞌɨ. Tsí vata ntáa ánje Xuva kō ntáa ō e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kuenta iña í te ntoto xtuku ō né, vāta ntu nakuaꞌa nto mí kakaꞌan túꞌun Xuva kō: ");
INSERT INTO mizNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Xuꞌú ne, Xuva Ābraan, Xúva Īsaa, Xúva Jācoó san u”, kaꞌan ña. Xuva kō ne, ñá te Xuvā ñá xiꞌí san ña, tsí Xuvā ña ntantíto san ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dā téku ña ntâñɨ íkān ne, koó dā kúduꞌva ñā nuu i é nañeꞌe ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dā téku ña fariseú san tsí ña tuví nee iña é kūvi kaꞌan ñá saduceú san dá kaꞌan Jésuu iña ñá ne, nátaká nuu ña fariseú san. ");
INSERT INTO mizNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Uun ñaꞌa, ñá ini váꞌa leí san ne, īto nteé ña Jesuu, kakáꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Mastrú, ¿neē ntú tuꞌun e dií ka kaꞌnu é kāꞌan Xúva kō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kakaꞌan Jésuu ni ña: —“Kuinima nto Tóꞌo nto Xuva ko kanɨɨ̄ nima ntó, kanɨɨ̄ é tduiña nto, kanɨɨ ūꞌxen dɨkɨ nto.” Kuan ō kaꞌan Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sáꞌā e túꞌūn e dií ka kaꞌnu é dīꞌna kada ntaa o. ");
INSERT INTO mizNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dókō sá dadɨɨ ni tūꞌun é kuvi ūví san. Kakaꞌan: “Kuinima ntó taꞌan nto vatā ó kakuinima míi nto kúñu ntō”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Te kāda ntaa ntó ntuvi nuu i sáꞌa ne, kuan kōo kada ntaa nto un ntɨɨ́ ntɨ̄ɨ́ lei Muísee ni un ntɨɨ́ ntɨ̄ɨ́ túꞌūn e ntákaꞌan ñá kaꞌán naa Xuva kó san dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dá ntōo ká ña fariseú san ne, ");
INSERT INTO mizNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","tsixeꞌe Jēsuu ña: —¿Nee iñá ntu ntádē kuení nto iña Cristu, ña táxnuu Xuva kō? ¿Xoó ntu iꞌxá i ña? —tsixeꞌe ñā. Nantíko kōó ña fariseú san, kakaꞌan ña: —Iꞌxá ika Dāvii ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kakaꞌan Jésuu ni ña: —Te īꞌxá ikā ñá ña ne, ¿nté kui kakaꞌan ntú Davii é Tóꞌo ña ña, vata ō xeꞌe Espíritū Sántū san ña é kāꞌan ña? Tsí kaꞌan Dávii kídaā: ");
INSERT INTO mizNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kakaꞌan Xúva ko nī Tóꞌō ko: “Kutūvín diñɨ kuaꞌa ko é xntiīn kó dā nté kūvi vii ú nī ña ntaínchuꞌvi o.” Kuan ō kaꞌan Dávii. ");
INSERT INTO mizNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Te kāꞌan Dávii tsi Tóꞌo ña ñā ne, ¿nté ntu koo kaꞌan ña tsí iꞌxá ña ña dɨ? —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nté uun ña ña ni kuvi nantiko koó ña nté uun túꞌūn. Nté ntūvi tsikán ne, ña ni ntío ká ñaꞌa san tsixéꞌē ká ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kidáā ne, kakaꞌan Jésuu ni un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán, nī ña ntántīkɨn ña: ");
INSERT INTO mizNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Mastrú leí san nī ña fariseú san ne, ntánakuāꞌa ña ntó nēe é ncho kaꞌán lei Muíseé san. ");
INSERT INTO mizNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dukuān ne, kini nto é ntákaꞌan ñá ne, vií nto vatā ó ntákaꞌan ña, ntá tsi ña vií nto vatā ó de ña, tsí ña ntáde ña vatā ó ntánakuāꞌa ña nto. ");
INSERT INTO mizNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dōo ntátee tsiñu ña ñaꞌa núu i e dóo ntii tūꞌun e ña kutíi ñaꞌa san, ntá tsi mii ñā ne, ña ntío ña tɨɨn ntaꞌa ñā nté un siin. ");
INSERT INTO mizNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Un ntɨꞌɨ̄ e ntáde ña ne, ntáde ña vata koo é kīni ñaꞌa san. Ntátsuve ña tūtú e dóo nīꞌí xteén ña ni ntāꞌa ña, tutu é ūve naꞌa túꞌun Xuva kō. Ñá tē nté kaa nani ntete duꞌnu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ncho kuntōo ña míꞌī e dií ka váꞌā ó viꞌi viko sán ne, ncho kuntōo ña sia é ntoo un tsi nte núu i kan ini ukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ntio ña é kāꞌan ún ntɨɨ́ ntɨ̄ɨ́ ñaꞌa ntiusi ni ña nú āꞌví kān ne, é kāꞌan ún ntɨɨ́ ntɨ̄ɨ́ ñaꞌa tsí mastru ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ʼNtá tsi ña ku kaꞌán ñaꞌa tē mastru ñá nto, tsí uun tsi Mastru nto. Un ntɨɨ́ ntɨɨ̄ ntó ne, taꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ñá ku kaꞌān ntó Uva nto ni da xōó ka ñaꞌa ñuxiví a, tsí uun tsi Uva ntō, ña é tuví e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ñá ku dā váꞌa nto é kāꞌan ñáꞌa san e tóꞌo ña ntō, tsí mii tsī ú e Tóꞌo ntō, xuꞌu é nāni ú Cristu. ");
INSERT INTO mizNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ntōꞌo é dií ka naꞌnu ñaꞌa nto ne, kada tsiñu nto iña táꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ntoꞌo e ntáde naꞌnu ñaꞌa nto ni tāꞌan nto ne, vií Xuva kō é nainu xuvi ntō. Ntōꞌo é ña ntáde naꞌnu ñaꞌa nto ne, Xuva kō taꞌxi ña é ntunaꞌnu ñaꞌa nto. ");
INSERT INTO mizNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ʼNtá tsi ¡ntāꞌvi ide ntó, ña vete, mastrú leí nī ña fariseu!, tsi úvi nuu i é ntáde nto. Tsí ntánakadɨ núu nto itsi mí kadē kûꞌvé Xuva kō. Nté mii ntō ña ntío nto é kuīta ntíꞌxin nto ne, ntē ña ntaxéꞌe nto itsi é kuīta ntíꞌxin tuku ñaꞌa, ña e dóo ncho kuíta ntiꞌxin. ");
INSERT INTO mizNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ʼ¡Ntāꞌvi ide ntó, ña vete, mastrú leí nī ña fariseu!, tsi úvi nuu i é ntáde nto. Ntánakiꞌi nto viꞌi ñadɨ̄ꞌɨ kií san ne, dōó naꞌa ntákaꞌan ntâꞌví nto vata koo é tēe xuꞌu nto e ntáde nto. Dukuān ne, dií dií ka niꞌi nto é ntōꞌo nto. ");
INSERT INTO mizNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ʼ¡Ntāꞌvi ide ntó, ña vete, mastrú leí nī ña fariseu!, tsi úvi nuu i ntáde nto. Ña túvī míꞌī é ña kɨ́ꞌɨn nto vata koo é viī nto é kuintiꞌxe kuān té uun kúdii ñaꞌa vatā o ntákuintiꞌxe nto. Kidáā, dá kakuīntiꞌxe ña ne, ntáde nto é kūvi ña é dií dií ka kini kaa é dɨvi ntō. Dadɨɨ kɨꞌɨn ntó ni ñā dôꞌvi kan. ");
INSERT INTO mizNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ʼ¡Ntāꞌvi ide nto! tsí ntōꞌó ne, vata ntáa ña kuāa ntáa nto, ña é dotō tsí kanañēꞌe túku ñaꞌa nté koo kɨ̄ꞌɨn ña. Ntákaꞌan nto: “Tē xoó ñaꞌa kakuniꞌi ñā xúkūn sán ne, ñá tē neé kaidiáꞌvi. Ntá tsi te kakuniꞌi ña ōro é naxeꞌe ini ukún san ne, da miī é viī ña é kākaꞌan ña”, xkoó kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ña kuāá tuntu! ¿Nee iñá ntu é dií ka nuu áꞌvi: ōró san ne, o xūkún san é kāde i e kúviko oro san? ");
INSERT INTO mizNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ntákaꞌan nto: “Tē xoó ñaꞌa kakuniꞌi ña nāá san ne, ñá tē neé kaidiáꞌvi. Ntá tsi te kakuniꞌi ñā doméní san é ntēku nú nāá san ne, da miī é viī ña é kākaꞌan ña”, xkoó kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ña kuāa! ¿Nee iñá ntu é dií ka nuu áꞌvi: doméní san ne, ō nú nāá san mí kade i e kúviko doméní san? ");
INSERT INTO mizNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Xoó ñaꞌa é kakuniꞌi ña nāá san ne, kakuniꞌi ña nāá san nī é un ntɨꞌɨ̄ é ntekú nuu i kan. ");
INSERT INTO mizNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Xoó ñaꞌa é kakuniꞌi ña xūkún san ne, kakuniꞌi ña Xuva kō dɨ, tsí tóꞌo xūkún san ña. ");
INSERT INTO mizNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Xoó ñaꞌa é kakuniꞌi ñā é dukún kān ne, kakuniꞌi ña Xuva kō dɨ, tsí ikān tuví ña, kadē kúꞌvē ña. ");
INSERT INTO mizNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ʼ¡Ntāꞌvi ide ntó, ña vete, mastrú lei ni ña fariseu!, tsi úvi nuu i é ntáde nto. Tsi ntánakuéꞌe nto ntaꞌa Xuva ko uun taꞌvi ī é uꞌxi xuku mínū ngatsí, ni ānií, ni kōminú san, ntá tsi ña ntáde nto kuenta née iña é dií ka nuu áꞌvi é kākaꞌan leí san, mí kākaꞌan é vīi o é vāꞌá ni taꞌan kō, é ntuntāꞌví ini ko ñā, é kuintiꞌxe ko Xuva kō. Ña xtúvī mii nto é viī ntó tsikan, ntá tsi kantio é viī nto sáꞌā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Vata ntáa ña kuāa ntáa nto é dotō tsi ntánañeꞌe nto tuku ñaꞌa nté koo kɨ̄ꞌɨn ña! ¡Ntōꞌó ne, ntákaꞌan ntée nto ñaꞌa, ña é ña kuéꞌe nuu i é kīni kaa ntáde, ntá tsi dɨvi ntō ne, dií dií ka kueꞌe kuétsi ntō! ");
INSERT INTO mizNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ʼ¡Ntāꞌvi ide ntó, ña vete, mastrú lei ni ña fariseu! ¿Nté kui ata tásá xntu san ni ata kóꞌó san ntánakate nto? Tsi iní i kān ne, dentu kueꞌen kuenta iña í e dóo dúꞌu nto, e dóo ntio nto é un ntɨꞌɨ̄. ");
INSERT INTO mizNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseu kuaa! Diꞌna nakate nuu nto tásá san ni kōꞌó san dɨ ne, kidáā ne, ntoo atá i dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ʼ¡Ntāꞌvi ide ntó, ña vete, mastrú lei ni ña fariseu! Vata ntáa nú ñañā é naxeꞌe dúꞌxe kuīꞌxin ata i ntáa nto. Dōo tí ntaa é koto ō ne, ntá tsi iní i kān ne, ñuꞌu tsitu xɨkɨ tēꞌú ni nūu i é dentū. ");
INSERT INTO mizNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kuān ntáa nto dɨ, tsi dóo vaꞌá nto, kuiní ñaꞌá san, ntá tsi dóo vete nto, tsí ñuꞌu tsitū nima nto é kīni kaa, e úvi nuu i ntáde nto. ");
INSERT INTO mizNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ʼ¡Ntāꞌvi ide ntó, ña vete, mastrú lei ni ña fariseu! Ntáde váꞌa nto ñañā ñá kaꞌán naa Xuva ko kídaā ne, ntántakutu nto ñaña ñāꞌa, ña e dóo vaꞌá ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ntákaꞌan nto: “Tē dɨ́ ni kántoo ntɨ́ ntuvi dá ntoo uva ikā ntɨ́ ne, ña ni xntíī ntɨ́ ña é kaꞌnī ñá ña ntákaꞌán naa Xuva ko san.” Kuān ó ntákaꞌan ntó, kuān té ña ntáa. ");
INSERT INTO mizNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","É kuān ó ntákaꞌan ntó ne, ntákaꞌan nto tsí iꞌxá ntiꞌxe nto ña éꞌni ña kaꞌán naa Xuva ko san, tsí dé nɨɨ̄ kueꞌen ñáꞌa nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ntōꞌó ne, nantɨ̄ꞌɨ ntó nēe e éni ntuꞌu uva ata ntō. ");
INSERT INTO mizNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ʼ¡Ntōꞌó ne, vata ntáa iꞌxá e ña váꞌā ntáa nto, vata ntáa tatá koo ntáa nto! ¿Nté ntu koo nakáku nto te kāꞌan Xúva kō é kɨ̄ꞌɨn nto dôꞌvi kan? ");
INSERT INTO mizNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dukuān né, taxnūu ú ña kaꞌán naa ko mí ntoo nto, nī ña e dóo kiꞌin inī í, nī mastrú san. Iō ñá ne, kaꞌní nto ña. Iō ñá ne, xnteē ntó ña ntiká krusi kan. Iō ñá ne, natii nuu nto ña xoꞌo má viꞌī mi ntánataká nuu nto. Iō ñá ne, kadā xení nto ni ñā da míꞌī ká ñuú mí kɨ̄ꞌɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kaxntēé naꞌa Xúva ko kuēnta ntó kuenta iña un ntɨɨ́ ntɨ̄ɨ́ ña é vāꞌá ñaꞌa, ña é xiꞌi, uun tsi nté iꞌxá Adaán san, ñá nani Ābee, ña é ña ni ide núu ī é kīni kaa ne, uun tsi da nté Zacaria, íꞌxá Berequia, ña e éꞌní nto méꞌñū má viꞌī mí kuviko nī nú nāa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nuu é ntaā i é kākaꞌán u ni ntō tsí niꞌi ña ntántoo vevii é ntōꞌo ña kuenta iña i é un ntɨꞌɨ nūu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ʼ¡Ña ntáꞌvi ide ntu nto, ñuú Jerusaleen! Kaeꞌní nto ña ntákaꞌán naa Xuva ko. Kaxéꞌe xuu nto ña é taxnuu Xuva kō é kāꞌan ñá ni ntō. Dōó kiꞌin itō ntío ko é nātee taꞌan ntɨꞌɨ ú nto vatā ó kanatsiꞌi tsúꞌūn san á iꞌxá tɨ má ntīꞌxin tɨ, ntá tsi ña ni ntío nto. ");
INSERT INTO mizNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kiní nto ve, tsí ña kuntóo ká ñaꞌa ñuú nto kān. ");
INSERT INTO mizNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tsí kakaꞌán u ni ntō tsi nté uun itó ka ña kiní nto kó dā nté kāꞌan nto: “Dōó kaꞌnu ñaꞌa, ña é vēꞌxí naa Xuva ko”, koo kaꞌan nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ntīi Jesuu má ūkún kān. Kuéꞌēn ká ña itsi kān dá xee ña ntántīkɨn ña, ntákaꞌan ñá e na kōto ña úkūn sán e dóo váꞌā o. ");
INSERT INTO mizNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ntá tsi kakaꞌan Jésuu ni ña: —¿Ñā ntu kaíni nto é un ntɨꞌɨ sāꞌa? Nuu é ntaā i é kākaꞌán u ni ntō, tsí ña tuvi nté uun xuu é ōdo ntiꞌi taꞌan vevii é ña nakátsin ñaꞌa san rkontûvi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Dá tūví Jesuu tɨ́ꞌɨ i é nani Ōlivú ne, xée ētsin ña ntántīkɨn ña, tsíxeꞌe ña ñā: —Káꞌan nto vē: ¿Amá ntu kuvi sáꞌā? ¿Nté ntu koo kuvi te xee ntúvi e nainu nto, te ntɨꞌɨ ñuxiví sa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kakaꞌan Jésuu ni ña: —Kuenta tsí vií nto e ña xoxo kaní ntaꞌví i nto. ");
INSERT INTO mizNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tsi dóo tɨtɨ́n ñaꞌa kaꞌan ña é dɨvi ñā é Cristu ña. Kaꞌan ña: “Xuꞌu é Cristú u”, koo kaꞌan ña. Ñá te da dīi ñaꞌa kaní ntaꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tekú nto tsi é xio xío kakuvi duꞌxēn. Ntá tsi koto nto tē ña kuꞌví nto. Tsí kantio é kuān koo kuvi. Ntá tsi vata xée ntuvi e ntɨ́ꞌɨ ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tsí nāa uun ñuú ni tūku ñuu. Ña tsiñu naꞌnu i sáꞌā ne, naa ñá ni tūku ña tsiñu i. Kutamá ne, táan dā míꞌī ká ñuu. ");
INSERT INTO mizNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Te kūvi sáꞌā né, dā ve kaiñɨ ntuꞌu é ntōꞌo ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ʼKidáā ne, ntada ñá nto kuenta ntáꞌa ñaꞌa, ña é kadā xení ni ntō, é kaꞌnī ñá nto. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san kuneꞌu iní ña ni nto kuēnta iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ntuvi tsikán ne, dōó tɨtɨ́n ñaꞌa xtuvī mii ña e ntákuintiꞌxe ña ko. Káꞌan ntēé taꞌan ña. Kuneꞌu iní ña ni tāꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dōó tɨtɨ́n ñaꞌa kiꞌxi ña é kāꞌan ñá tsi naa Xuva ko kakaꞌan ñá ne, ñá te da dīi ñaꞌa kaní ntaꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tsi dóo kukueꞌe é kīni kaa e ntáde ña ne, xtuvī mii ña é kākuinima ñá taꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ntá tsi xoó ñaꞌa é kūtíi ñā da nté tē ntɨ́ꞌɨ ntuvi tsikán ne, nakáku ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Túꞌūn vaꞌá iña mí kadē kûꞌvé Xuva kō ne, káꞌān ntodó ñaꞌa dá kanɨɨ ñūxiví, vata koo é kīni un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa. Kidáā ne, ntɨꞌɨ ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ʼUun ntuvi ne, kūví vata ō kaꞌan Dániee, ñá kaꞌán naa Xuva ko kídaā. Kiní nto tsí kuntitsi uun nuu i e dóo kīni kaa, nuu i é ña ntío kueꞌen Xúva ko, mēꞌñú i mí dóo kuikó san. (Xoó ntánakuāꞌa i né, na kɨ̄ꞌɨn dɨkɨ ña.) ");
INSERT INTO mizNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kidáā ne, ña ntántoo ñuú Judeá ne, na kūnu ña kɨꞌɨn ñá nte xúku kān. ");
INSERT INTO mizNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Xoó ñaꞌa, ña ntoo daꞌna dɨkɨ viꞌi i kán ne, ñá kunēꞌé ña nuu ña má viꞌi ña kān é kīꞌi ña iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Xoó ñaꞌa, ña é ñuꞌu mâtú i kān ne, ñá kunēꞌé ña kínakiꞌí ña kutuun ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ntāꞌvi ide ñá ñuꞌu iꞌxá i ntuvi tsikán, nī ñá e ntánatsitsi iꞌxá i! ");
INSERT INTO mizNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kákan nto ntaꞌa Xuva kō e ña kantío é kūnu nto ntuvi víꞌxin, nté ntūvi dá iō dáꞌna. ");
INSERT INTO mizNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kidáā ne, un váꞌa tsi ntoꞌo ñaꞌa san. Váta kīní ñaꞌa e dóo ntoꞌo ña nuu i é kīni kaa sáꞌa nte ntúvi é iñɨ ntuꞌu ñūxiví sa. Nté uun ito ka ñá kuan kōo kuvi dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tē ña nantɨꞌɨ Xuva ko ntuvi tsíkán ne, nté uun ñaꞌa ña nakáku ña. Ntá tsi nainu Xúva ko ntūvi tsikan da xe dóo kakuinima ñá ña nákaxnúu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ʼTe kākaꞌán uun ñaꞌa ni ntō kídaā: “Koto nto, tsí iꞌa tuví Cristu”, o te kākaꞌan ña: “Ikān tuví ña”, ne, ñá ku kuintīꞌxe nto ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tsí kiꞌxi ña veté ne, kaꞌan ña tsí Cristu ña. Tuku ña veté san ne, kaꞌan ña tsí kakaꞌan ñá naa Xuva ko. Vií ña nuu i é kīní ñaꞌa san ne, vií ña nuu i e dóo naꞌnu é kāni ntaꞌví ña ñaꞌa san. Tē dɨ́ kuvi ne, un tsi nte ñá ntákuintiꞌxe i ko kaní ntaꞌví ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Koto nto, tsi é diꞌna kakaꞌán u ni ntō é kuān koo kuvi. ");
INSERT INTO mizNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Dukuān né, te kākaꞌan ñá ni ntō: “Koto nto tsí tuví ña má kūꞌu kan”, ne, ñá ku ñeꞌē nto. Te kākaꞌan ña: “Tuví ña má viꞌi kān”, ne, ñá ku kuintīꞌxe nto. ");
INSERT INTO mizNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tsí vatā ó kaxiꞌí nuu nté uun diñɨ i e dukún kān un tsi nté tuku diñɨ i kān né, kuan kōo xiꞌí nuu kaꞌnu ú ne, da née inī xnto nainu ú, xuꞌu é vēxkúvī ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dā míꞌī ká tuví kúñu tēꞌú ne, ikān ntátaká nuu skuilú san. ");
INSERT INTO mizNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ʼUra tsí i tē ntɨ́ꞌɨ e dóo ntántoꞌo ñaꞌa ntuvi tsikán ne, kuneé ngantií san; ntē ña xiꞌí nuu ká xoó san. Kóꞌxō kɨ́mī san e dukún kān ne, kantá nuu e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kidáā ne, ntii díto nuu i e dukún kan īña kó, xuꞌu é vēxkúvī ú ñatīi. Kidáā ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa ñuxiví sa ne, uꞌvī ña. Kiní ña tsi véꞌxī ú, xuꞌu é vēxkúvī ú ñatīi, méꞌñū viko é ñuꞌu e dukún kān. Kiní ña tsi dóo iō ntii kó, tsi dóo kaꞌnu u. ");
INSERT INTO mizNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Taxnūu ú ánjē kó e dóo ntii nakuēku ña trunpetá ne, natee taꞌan ña ñaꞌa, ña é nakaxnúu ú, dā míꞌī ka mí ntoo ña da kanɨɨ ñūxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ʼKoto nto tun ígū sán ne, kiní nto: Dá dā vé ute ntaꞌa utun san, dá dā vé kakene xuku í ne, ini nto tsí dokó sa xee ntúvi kaꞌni. ");
INSERT INTO mizNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kuan kōo kuvi dɨ́ te inī ntɨꞌɨ ntó nuu i tsíkan. Kutunī nto tsí é ntītsí nteé u xiꞌi nto. ");
INSERT INTO mizNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nuu é ntaā i é kākaꞌán u ni ntō tsí ña kuví ñaꞌa, ña ntántoo ntuvi sáꞌa, dā nté kuvi ntɨꞌɨ nuu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","E dukún kan ni ñūxiví sa ne, kunaa, ntá tsi túꞌūn kó ne, ñá kunāa kueꞌen. ");
INSERT INTO mizNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ʼNtá tsi nté uun ñaꞌa ñá ini ña neé ura kuvi sáꞌā, nté ánje Xuva kō, ña ntoo e dukún kān, nté xuꞌu é Iꞌxā ñá ko ñá iní u. Da mii Uvā kó ini ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ʼVata ō kúvi ntuvi dá ītúvi ña ata ika ko Nōeé ne, kuan kōo kuvi te nainú u dɨ, xuꞌu é vēxkúvī ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tsi kidáā ne, ntuvi diꞌna dá nakuntéku ntute ñuxiví san ne, ntaéꞌxī ña ntáxiꞌi ña ne, ntatántaꞌa ña. Kuan ō dé ña da nté xee ntúvi é kɨ̄ꞌví Noee íni arká san. ");
INSERT INTO mizNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ñá ni kutūni ña nté koo kuvi ña dā nté xee ntúte san é natavi núu ña un ntɨɨ́ ntɨɨ̄ ña. Kuan kōo kuvi te nainú u dɨ, xuꞌu é vēxkúvī ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kidáā ne, uvi ñáꞌa ñatīí san ne, ntaítu ña. Uun ña kɨ́ꞌɨn ña nī kó ne, uun ña kutuvī mii ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Úvi ñadɨ̄ꞌɨ́ san ne, ntántiko ña. Uun ña kɨꞌɨn ñá nī kó ne, uun ña kutuvī mii ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ʼKoto nto ve, tsi ñá ini ntó nee ntúvi, neé ura nainú u, xuꞌu é Tóꞌo ntō ko. ");
INSERT INTO mizNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ntá tsi kuenta tsí vií nto. Tē dɨ́ īni tóꞌo vīꞌi san neé ura kíꞌxi ña duꞌú san niñú a ne, koo túꞌvē ñá ne, ñá kuēꞌé ña é kiꞌi dúꞌu ña duꞌú san iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dukuān ne, koo túꞌvē nto ve. Tsí ura dá ña kantétu nto ne, ura í tsikan naínú u. ");
INSERT INTO mizNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ʼXoó ñaꞌa, ña kade tsiñu e dóo ini de ntáa ña, ña e dóo kiꞌin inī í ne, kaꞌan tóꞌo ñā é kuvi kodo nuū ñá iña viꞌi ña, é kuēꞌé ña é kāꞌxí ña ntáde tsiñu niꞌi ña te xee úra i. ");
INSERT INTO mizNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","¡Nté kuī váꞌa nī ña é kade tsiñu te kāde ntaa ñá tē xee tóꞌo ñā! ");
INSERT INTO mizNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nuu é ntaā i é kākaꞌán u ni ntō tsi kuéꞌe tóꞌo ñā é kūnteé ntaꞌa ña un ntɨɨ́ ntɨ̄ɨ́ iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ntá tsi te ña kade tsiñu san kini kaa ña ne, kadē kuení ña te kukuií ka tóꞌo ñā ne, ");
INSERT INTO mizNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kade xení ña nī ña ntáde tsiñu niꞌi ñā né, da mii kuēꞌen tsi e ntáxiꞌi ntaéꞌxi ña nī ña kɨꞌvi niꞌi ñá ne, kidáā ne, da née inī ñá naxee tóꞌo ña ");
INSERT INTO mizNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ūun ntuvi dá ña kantétu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kidáā ne, taꞌxi tóꞌo ña ñā. Káꞌan ñā tsí niꞌi ña é ntōꞌo ña é kāduku ntée ña vete. Ikān né, dōó kueku ña ne, nakaꞌxí kaꞌñɨ̄ ña núꞌu ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ʼMí kadē kûꞌvé Xuva kō ne, vata kaa uꞌxi ñádɨ̄ꞌɨ kuétsī é kuēꞌen niꞌí tun kantílīn tun é kuēꞌén tun é nāniꞌi taꞌán tun ña da vé tántaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Úꞌun ñāꞌa tún ne, ña túvi dɨ̄kɨ́ tun nté koo vií tun. Úꞌun ñāꞌa tún ne, dōó iō dɨkɨ́ tun é vīí tun. ");
INSERT INTO mizNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Taꞌnu é ña tuvi dɨ́kɨ í san ne, dā kueꞌen niꞌí tun kantílīn tún ne, ña ni ídō tún asete. ");
INSERT INTO mizNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ntá tsi taꞌnu íō dɨkɨ í ne, odō tún tsáꞌa āseté tun ni kāntílīn tun. ");
INSERT INTO mizNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Da nɨɨ kākukuii ña da vé tántaꞌa sán ne, kídī tun. ");
INSERT INTO mizNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Dā kú dava ñúu ne, kakaꞌan ñáꞌa: “Koto nto tsi véꞌxi ña da vé tántaꞌa san. Kueꞌēn ntó te nāniꞌi taꞌan nto ña”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nákuntāñɨ́ tun, un ntɨɨ́ ntɨ̄ɨ́ tun, vata koo é tsoo túꞌve tún kantílīn tun. ");
INSERT INTO mizNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kidáā ne, ntákaꞌan táꞌnu é ña tuvi dɨ́kɨ í san ni tāꞌnu e dóo iō dɨkɨ í san: “Tāꞌxi kudii nto áseche nto, tsí kantaꞌva míī kanchílīn ntɨ”, kaꞌán tun. ");
INSERT INTO mizNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ntá tsi nantiko koó taꞌnu íō dɨkɨ í san: “Á chē ña xee táꞌan iñá ntɨ che tāꞌxi ntɨ́ nto. Dií ka váꞌā ó che kuēꞌen ntó, kūkuiín nto iña mii nto nu âꞌví kān”, kaꞌán tun. ");
INSERT INTO mizNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Da nɨɨ kuēꞌen tún kūkuiín tun ne, kidáā xeé ña da vé tántaꞌa san. Taꞌnu é iō tuꞌvé i ne, kúkɨ̄ꞌví tun má viꞌi kān mí kakūvi viko sán ne, nakādɨ tóꞌo vīꞌi sán xiꞌí san. ");
INSERT INTO mizNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Dā rkontûví ne, xée tāꞌnú nguiī sán ne, ntákaꞌán tun: “¡Nakaán nto xiꞌi nto, tóꞌo vīꞌi!”, kaꞌán tun. ");
INSERT INTO mizNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ntá tsi kakaꞌan tóꞌo vīꞌi san: “Nuu é ntaā i é kākaꞌán u ni ntō, tsí ña iní u nto”, kaꞌan ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kidáā ne, kakaꞌan Jésuu ni ña: —Kuntōo túꞌve ntó ve, tsí ña ini nto nee ntúvi, neé ura é naínú u. ");
INSERT INTO mizNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ʼMí kadē kûꞌvé Xuva kō ne, vata kaa uun ñaꞌa kaa, ña é dā ve kɨꞌɨn túku ñuu. Kāna ña ña ntáde tsiñu iña ñá ne, xéꞌe ñā é kuēnta víi ña iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ʼXéꞌe ña ūun ña kade tsiñu san uꞌun míil diuꞌún san. Uun ñaꞌa ñā né, uvi míil. Ña kuvi ūní san ne, xéꞌe ña ña ūun míil. Xéꞌe ñā é un é un ña vata tsi kaa kutíi ña kuenta víi ña. Kidáā ne, kuéꞌen ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ña é niꞌi í uꞌun míil sán ne, ura tsí i kueꞌen ñá ne, dé tsiñu niꞌi ña é uꞌun míil sán ne, níꞌi ka xtūku ña uꞌun míil ka. ");
INSERT INTO mizNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kuan tsī o dé ña é nīꞌi i uvi míil sán dɨ. Níꞌī ká xtukú ña uvi míil ká dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ntá tsi ña é niꞌi i uun míil sán ne, ēte ña xavi ne, íꞌxi ñā diuꞌun tóꞌo ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ʼDā kú naꞌa ne, nāxee tóꞌō ña ntáde tsiñu san ne, nadita ñá kuenta. ");
INSERT INTO mizNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ña é nīꞌi i é uꞌun míil sán ne, nāxee ñá ne, nākuéꞌe ñā tóꞌo ña ūꞌun míil ká xtuku é nīꞌi ña. Kakaꞌan ñá nī tóꞌo ñā: “É ūꞌun míil e táꞌxi nto kó ne, iꞌa niꞌi xtuku ká u uꞌun míil ká iña nto”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kakaꞌan tóꞌo ña ni ñā: “Dōo váꞌā o den, e dén ntaan. Tsí da xe dén ntaan un sīin e táꞌxī ú o ne, kuéꞌē ká xtuku táꞌxī ú o é kadān kuꞌven. Kiꞌxin nī kó, kutūvin dînín nī ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ña é nīꞌi i uvi míil sán ne, nāxee ñá dɨ. Kakaꞌan ñá nī tóꞌo ñā: “É ūvi míil e táꞌxi ntō kó ne, iꞌa niꞌi ká u uvi míil ká xtuku, é nīꞌí ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kakaꞌan tóꞌo ña ni ñā: “Dōo váꞌā o dén, e dén ntaan. Tsi dén ntaan é un siin e táꞌxī ú o ne, kuéꞌē ká xtuku táꞌxī ú o é kadān kúꞌvēn. Kiꞌxin nī kó, kūtuvin dínin nī ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ña é nīꞌi i uun míil sán ne, xée ñā dɨ. Kakaꞌan ñá ni tōꞌó ña: “Iní u tsi dóo diin nto. Katava nto mí ña ni íꞌxi nto ne, kataꞌvi nto mí ña ni itu nto. ");
INSERT INTO mizNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Dukuān ne, ûꞌví ko ne, ixkúꞌxī ú diuꞌun nto. Uꞌun nto diuꞌun nto”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ntá tsi kakaꞌan tóꞌo ña ni ñā: “Dɨvīn né, dōo kini iden, dōó duꞌxen ō. Inin tsí katāvá u mí ña ni íꞌxī ú ne, kataꞌvī ú mí ña ni itú u. ");
INSERT INTO mizNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Nté kui ña ni xtuvín ntun diuꞌún ko mí kueꞌnu iꞌxá i, vata koo é te ntiko kōó u ne, naniꞌí ko diuꞌún ko ni īꞌxa i?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kidáā ne, kakaꞌan ñá ni ña ntoo ikān: “Nakiꞌi nto é uun míil é nīꞌi ñá ne, kuéꞌe nto ñā é nīꞌi i uꞌxi míil san. ");
INSERT INTO mizNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tsí da xōó ka ñaꞌa é īo iña ñá ne, níꞌī ká ña; kukuika ñā. Ntá tsi ña é ña kuéꞌe īó iña í ne, nakiꞌi ká ña é īó iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ña é ña váꞌā ó kade tsiñu sán ne, kiñuꞌu nto ña kíꞌi kān mi dóo nee. Ikān né, dōó kueku ña ne, kaꞌxí kaꞌñɨ̄ ña núꞌu ñā”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ʼTē naínú u, xuꞌu é vēxkúvī ú ñatīí ne, dōó kaꞌnu ñaꞌa u. Kiꞌxi ú ni ūn ntɨɨ́ ntɨ̄ɨ́ ánjē kó ne, kutūví u nú tēú ko e dóo kaꞌnu u. ");
INSERT INTO mizNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nataká nuu un ntɨɨ́ ntɨ̄ɨ́ ña ñuxiví san nuú ko ne, tsoo xio ú ña, é un é un ña, vatā ó katsoo xio paxtú san ndiꞌu ñá ni lēꞌntu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A leꞌntú san ne, tsoo ú tɨ diñɨ kuaꞌa kó ne, ndiꞌu sán ne, tsoo ú tɨ diñɨ datsin ko. ");
INSERT INTO mizNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kidáā ne, xuꞌu é Rei ú kaꞌán u nī ña ntoo diñɨ kuaꞌa ko: “Kiꞌxi nto, tsi dóo ntio Uva kó nto. Kuntōo nto mí kadē kûꞌvé Xuva kō tsi é īó tuꞌve iña nto un tsi nte díꞌna dá de kúꞌvē ñá ñuxiví san. ");
INSERT INTO mizNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tsí dā kákɨ̄n kó ne, taꞌxī nto é kāꞌxí u. Dā itsí ko ne, taꞌxī nto é kōꞌo u. Kuān te xio ñuú véꞌxī ú ne, dōo diní nto é kutūví u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Dá kantɨ̄ɨ́ u ne, taꞌxī nto doo é kunūu u. Dá nchokuví u ne, īxkoto niꞌni nto ko. Dá inuu kutu ú ne, īxkoto niꞌni nto ko”, koo kaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kidáā ne, káꞌān ña é vāꞌá ñaꞌa san ní ko: “¿Amá ntu ini ntɨ e kákɨn ntō ne, tāꞌxí ntɨ é kāꞌxi nto? ¿Amá ntu ini ntɨ e itsi ntó ne, tāꞌxí ntɨ é kōꞌo nto? ");
INSERT INTO mizNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Amá ntu ini ntɨ́ e xio ñuú veꞌxi nto ne, tāꞌxí ntɨ mí kutuvī nto? ¿Amá ntu ini ntɨ e kantɨɨ́ nto ne, tāꞌxí ntɨ doo é kunūu nto? ");
INSERT INTO mizNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Amá ntu íni ntɨ é nchokuví nto, o nuu kutu ntō ne, ixkóto nīꞌni ntɨ́ nto?”, koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kidáā ne, xuꞌu é Reí u ne, káꞌān ú ni ñā: “Nuu é ntaā i é kākaꞌán u ni ntō, tsí da kuān ó de nto ni tāꞌan nto, ña é dií ka dutsi ne, vata te xūꞌu kuán o de nto nī ko”, koo kaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ʼKidáā ne, xuꞌu é Reí u ne, káꞌān ú nī ña ntoo diñɨ datsin kó: “Kunu nto nuú ko, ña kini ntáa. Kueꞌēn nto mí kaiꞌxi ñúꞌu ntii dañu ntūvi, é de kûꞌvé u iña tóꞌō e ña váꞌā san nī ánje ī. ");
INSERT INTO mizNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tsí dā kákɨn kó ne, ña ni táꞌxi ntō é kāꞌxí u. Dā itsí ko ne, ña ni táꞌxi ntō é kōꞌo u. ");
INSERT INTO mizNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","É xīo ñuú véꞌxī ú ne, ña ni táꞌxi ntō mí kutūví u. Íntɨ̄ɨ́ u ne, ña ni táꞌxi nto dōo é kunūu u. Nchokuví u ne, ínuu kutū ú ne, ñá ni īxkoto níꞌni nto ko”, koo kaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kidáā né, tsixeꞌe ñāꞌa sán ko: “¿Amá ntu kákɨn ntō? ¿Amá ntu itsi nto? ¿Míꞌi ntū é xio ñuú veꞌxi nto? ¿Amá ntu kantɨ́ɨ nto, ō é nchokuví nto, o inuu kutu ntō ne, ña ni xntíi ntɨ́ nto?”, koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kidáā ne, káꞌān ú ni ñā: “Nuu é ntaā i é kākaꞌán u ni ntō, tsí te ña ni xntii nto taꞌán nto, ña é dií ka ntāꞌví san ne, ña ni xntíi nto kó dɨ”, koo kaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kidáā ne, kɨ́ꞌɨn ñā mí nīꞌi ña é ntoꞌo ña ntii dañu ntūvi. Ntá tsi ña é vāꞌá san ne, kuntoo ña ni Xuva ko ntii dañu ntūvi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Dā kúvi kāꞌan Jésuu sáꞌā ne, kakaꞌan ñá nī ña ntántīkɨn ña: ");
INSERT INTO mizNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Ini nto tsí uvi ntúvi ve xee viko dá nātavá Xuva kō ña Israee ñuú Egítō. Kidáā ne, xuꞌu é vēxkúvī ú ñatīí ne, ntada ñá ko kuenta ntáꞌa ñaꞌa san é naxnteē ñá ko ntiká krusi kan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ntuvi tsikán ne, nataká nuu tóꞌō dutú san ni ñatā san má viꞌi kāꞌnu dutu ñá odo nūu, ñá nani Caīfaa. ");
INSERT INTO mizNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nātíin ña ni tāꞌan ña nté koo tɨɨn xuꞌū ñá Jesuu é kāꞌní ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ntá tsi ntákaꞌan ña: —Ñá vīi o méꞌñū vikó san vata koo é ña kudíin ñaꞌá san ni kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Dá tūví Jesuu ñuú Betania, má viꞌi Sīmuun (ña é kānakóꞌxo kúñu ī kídaā) ne, ");
INSERT INTO mizNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","xée uun ñadɨ̄ꞌɨ mí tuví ña, niꞌi ntaꞌa ña ūun xuxu choꞌo vîdin e dóo nuu áꞌvi. Dáꞌvi ña dɨ̄kɨ Jésuu chóꞌo vídin san da túvi ña nú mēsa kan. ");
INSERT INTO mizNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ntá tsi kudiin ña ntántīkɨn ña da íni ña ne, kakaꞌan ña: —¿Nté kui doto xntu kanatɨvi ñá choꞌo vîdín san? ");
INSERT INTO mizNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tē dɨ́ ni diko ñā né, dōo kueꞌé diuꞌun níꞌi ña. Kidáā ne, kuvi kuéꞌe ña diuꞌún san ñá ntāꞌvi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ntá tsi tēkú Jesuu nee iña ntádē kuení ña ne, kakaꞌan ñá ni ñā: —Ñá ku natēku duꞌxen ntó ña, tsí nuu i é vāꞌá kade ña nī ko. ");
INSERT INTO mizNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ña túvī nté uun ntuvi é ña kuntóo ña ntāꞌví san ni ntō, ntá tsi xuꞌú ne, ñá nāꞌá ka kutuví u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dā daꞌví ña kúñū kó choꞌo vîdín san ne, kaxtūví tuꞌve ñá ko é kuntūꞌxí u. ");
INSERT INTO mizNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nuu é ntaā i é kākaꞌán u ni ntō tsí dā míꞌī ká e ntákaꞌan ntódo ña túꞌūn vaꞌá san kuenta iñá ko kanɨɨ ñūxiví sa ne, káꞌan ñāꞌa nté ō dé ñadɨ̄ꞌɨ́ saꞌá ne, nakaꞌan ña ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kidáā ne, uun ñaꞌa ñā é uxuvi ñáꞌa san, ñá nanī Júda Iscārioté ne, kuéꞌen ñā mí ntoo tóꞌō dutú san, ");
INSERT INTO mizNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kakaꞌan ñá ni ñā: —¿Nté ntu kaa taꞌxi nto kó te ntāda ú kuenta Jésuu ntáꞌa nto? —kaꞌan ña. Xéꞌe ña ña ōko uꞌxí diuꞌun kuiꞌxín ne, ");
INSERT INTO mizNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","nté ūra tsikan ntúkū nuu iní ña nté koo ntada ña kuenta Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dā kíi ūun viko da nátava Xuva kō ña Israee ñuú Egítō sán ne, xéē ña ntántīkɨn ña mí tuví Jesuú ne, ntákaꞌan ña: —¿Míꞌi ntū ntio nto é xtūví tuꞌvé ntɨ é kāꞌxi ntó iña vikó sāꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kakaꞌan Jésuu ni ña: —Kueꞌēn ntó ñuú Jerusaleen, nú viꞌī ña tsikán ne, káꞌan nto ni ñā: “Kakaꞌan Mástrú san: É dokó sa xee ura iñá ko. Iꞌa nú viꞌi nto kān kaꞌxí u iña vikó san nī ña ntántīkɨ́n ko”, koo kaꞌan nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kuan ō dé ña ntántīkɨn ñá vata ō kaꞌan ñá ne, ikan xtūví tuꞌvē ña é kāꞌxi ñá iña vikó san. ");
INSERT INTO mizNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dā kuáā ne, íntōo dadɨɨ Jesuu ní uxuvi ñáꞌa, ña ntántīkɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Da ntaéꞌxi ña ne, kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō, tsí uun nto ne, díko ntō ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ñá tē nté kaa íntoo ntaꞌxa ña ne, é un é un ña ntátsixeꞌe ña ñā: —¿Vá dɨvi ntū u, Tóꞌō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kakaꞌan Jésuu ni ña: —Ña é dadɨɨ tsi xnuu ntóꞌo tañúꞌu i ini koꞌó san nī kó ne, dɨvi ñā e díko ñá ko. ");
INSERT INTO mizNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Xuꞌu é vēxkúvī ú ñatīí ne, kuví u vatā ó uve naꞌa túꞌun Xuva kō, ntá tsi ntāꞌvi ide ña é dīkó ko. Dií ka váꞌā ó tē dɨ́ ña ni kaku ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Júdā, ña é dikō ñá ne, tsixeꞌe ñā: —¿Vá xūꞌú ntu, Tóꞌō? —kaꞌan ña. Kakaꞌan Jésuu ni ña: —Kuān ó kakaꞌan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Da nɨɨ̄ ntaéꞌxī ñá ne, kīꞌi Jesuu tañúꞌū sán ne, nākuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō ne, kátsin dava ña ne, xéꞌe ñā ña ntántīkɨn ñá, kakaꞌan ña: —Kiꞌi ntó, kaꞌxí nto. Sáꞌā ne, kúñū kó —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kīꞌi ña eꞌxin sán ne, nākuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō ne, xéꞌe ña ña, kakaꞌan ña: —Koꞌo nto, un ntɨɨ́ ntɨɨ̄ ntó, ");
INSERT INTO mizNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","tsi sáꞌā ne, nɨ́ñɨ̄ ko é xēꞌé u xuꞌu kó é kātɨ ú kuenta iña dóo tɨtɨ́n ñaꞌa san vata koo é nakate Xuva kō kuetsí ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kakaꞌán u ni ntō tsí ña koꞌó ka ú ntute tɨntiꞌó sa dā nté koꞌō dadɨɨ ú ni ntō ntute tɨntiꞌó xēé san mí kadē kûꞌvé Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dā kúvi íta ña nchuꞌun iña Xuva kó ne, ntīi ña, kueꞌen ña xuku Olívu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kidáā ne, kakaꞌan Jésuu ni ña: —Un ntɨɨ́ ntɨɨ̄ nto kunu nto kó niñú ve. Tsí kuān ó uve naꞌa túꞌun Xuva kō é kākaꞌan: “Kaꞌní u paxtú san ne, kaka xaa un ntɨɨ́ ntɨ̄ɨ́ a leꞌntu san”, kaꞌan túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ntá tsi te ntoto xtuku ú ne, kɨ́ꞌɨ̄n ú, kodo nūú u ñuú Galilea —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedrú ne, kakaꞌan ñá ni Jēsuu —Kuān té un ntɨɨ́ ntɨɨ̄ ñá kunu ña nto ne, ñá kuan koo vīí u —kaꞌán Pedru. ");
INSERT INTO mizNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesuú ne, kakaꞌan ñá ni ñā. —Nuu é ntaā í kakaꞌán u ni ō tsí niñú ve ne, diꞌna dá kāna lɨ́ꞌxɨ̄ sán ne, é uni īto kaꞌan tsí ña inín ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kakaꞌan xtúku Pedru ni ña: —Kuān te kuví u ni ntō ne, ñá kāꞌán u e ñá iní u nto —kaꞌan ña. Kuan ō kaꞌan un ntɨɨ́ ntɨ̄ɨ́ ña ntántīkɨn ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kidáā ne, kueꞌen níꞌi Jēsuu ña mí é nani Getsemānii. Kakaꞌan ñá nī ña ntántīkɨn ña: —Kuntōo nto iꞌa, na kɨ̄ꞌɨ́n u daꞌa san, kikaꞌan ntâꞌví u —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ntēka ña ntuvi íꞌxá Zebedeú san nī Pedru. Dōo kúntaꞌxa iní ña. Dōo dé kuení ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kidáā ne, kakaꞌan ñá nī ntuni ñáꞌā san: —Dóko sā ña kutií u e dóo nuu ntaꞌxa nimá ko. Kuntōo nto iꞌa ne, kuntitō ntó nī ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kuéꞌēn ká ña un sīin ne, nakani ɨtɨ ña da nté tantée xteen ña ñuꞌu kān ne, dá kakāꞌan ntâꞌví ña, kakaꞌan ña: —Ūvá, te kūvi né, tāꞌxi nto é ña ntoꞌó ko. Ntá tsi ña te é ntio mii ko, tsí nté koo é ntio nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nāxee ña mí ntoo ña ntántīkɨn ñá ne, ntákidi ña. Kakaꞌan ñá nī Pedru: —¿Nté uun urá ntu ña ni kutii nto kuntito nto nī ko? ");
INSERT INTO mizNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kuntito nto ne, kaꞌan ntáꞌvī ntó vata koo é ña vií nto é kīni kaa. Nima ntó ne, ncho vii é vāꞌa, ntá tsi kúñu ntō ne, ñá kākutíi i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Dā kúvi uvi íto kueꞌen ñá kūkaꞌan ntâꞌví ña ne, kakaꞌan ña: —Uva, tē ña kuvi kuíta ntiꞌxin sáꞌā é ña ntoꞌó ko ne, na kuān koo kuví vatā ó ntio nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Dā náxee xtúku ña ne, ntákidi xtuku ntuni ñá ntántīkɨn ña, tsí kantadɨ́ mii ntuxnūú ña maꞌna. ");
INSERT INTO mizNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tsoo mii xtūku ña ña ne, dá kuēꞌen ñá, kukaꞌan ntâꞌví xtuku ña é kūvi uni íto. Kuan tsī o kakaꞌan ntâꞌví xtuku ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kidáā ne, naxeé xtuku ña mí ntoo ña ntántīkɨn ñá ne, kakaꞌan ñá ni ñā: —¿Ntákidi dúkuan ntu ntō? ¿Ntoo daꞌna ntu nto? Koto nto tsi e xée ūra í ve é xuꞌu é vēxkúvī ú ñatīí ne, ntada ña ko kuenta ntáꞌa ña kini ntáa san. ");
INSERT INTO mizNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nakuntáñɨ̄ nto, kɨ́ꞌɨn ō, tsi é xee ña é dikó ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Da nɨɨ kākaꞌan dúkuan ñā ne, xéē Júdā, uun ñaꞌa ña é uxuvi ñáꞌa san. Ñá tē nté kaa ñaꞌa ntéka ña, ña odo káa ni ūtun. Véꞌxi ña kuēnta iña tóꞌō dutú san ni ñatā san. ");
INSERT INTO mizNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ña é diko ñá ne, é kāꞌan ñá ni ñāꞌa san: —Xoó ñaꞌa, ña é kaꞌxí u xuꞌu i ne, dɨvi ña tɨ̄ɨn nto ña —kaꞌán Júdā. ");
INSERT INTO mizNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ura tsí i xee ña mí tuví Jesuu, kakáꞌan ña: —Soꞌo ntō dá, Mastru —kaꞌan Júdā. Ne, ēꞌxí ña xuꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kakaꞌan Jésuu ni ña: —Viín nee iña é vēꞌxin é vīin —kaꞌan ña. Kidáā ne, xée ñāꞌa sán ne, tɨ̄ɨn ña Jesuu é kɨꞌɨn niꞌi ña ñá nuu ña tsiñu naꞌnu i san. ");
INSERT INTO mizNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Uun ñaꞌa, ña ntántīkɨn Jésuú ne, tāvá ña káa ñā ne, ēꞌní ña ña kade tsiñu iña dutu ñá odo nūú san. Nákuītá tuꞌun ña loꞌxo ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kidáā ne, kakaꞌan Jésuu ni ña: —Nāxnuu váꞌan káa o. Xoó ñaꞌa é naā ñá nī káā ne, káā kuvi niꞌi ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Vá ña kuvi ntu káꞌān ú ni Uvā kó, kuiní nto ne, ura dúꞌva tsi i táxnūu ña uni diko uꞌxi míil ánje ñā? ");
INSERT INTO mizNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ntá tsi tē dɨ́ kuan kōo ne, ¿nté ntu koo kuntaa vatā ó kakaꞌan túꞌun Xuva kō é da miī é kuān koo kuvi? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ura tsíkán ne, kakaꞌan Jésuu ni ñáꞌa san: —¿Vēꞌxí ntu nto é tɨ̄ɨn nto uun ña duꞌu, é kuan o odo ntō káa nto ni ūtun san é vēxtɨ́ɨn nto ko? Utén utén tuví u má ūkún nto kān ne, ña ni tɨ́ɨn nto ko. ");
INSERT INTO mizNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ntá tsi kuan kōo kuví vatā ó kakaꞌan túꞌun Xuva kō, vata koo é kūntaa é kākaꞌan ñá kaꞌán naa Xuva ko kídaā —kaꞌan Jésuu. Un ntɨɨ́ ntɨ̄ɨ́ ña ntántīkɨn Jésuú ne, inu ña ne, xtuvī mii ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ña e tɨ́ɨn Jesuú ne, kueꞌen níꞌi ña ña mí tuví dutu ñá odo nūú san, ñá nani Caīfaa. Ikān ntoo mastrú lei ni ñátā, ña ntádē kûꞌvé san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ntá tsi ntīkɨn íka Pedrú san ña dá ntē xee ña nu kíꞌi kān nú viꞌī dutu ñá odo nūú san. Kúkɨ̄ꞌví ña iní i kān né, ikān itúvi ña nī sntadún san vata koo é kōto ntodo ña nté koo kuvi Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Dutu ñá odo nūú san ni ūn ntɨɨ́ ntɨ̄ɨ́ ña tsiñu i sán ne, ntuku ñā ña é dāꞌví dovete ata Jesuu, vata koo é kāꞌan ña é na kuvī ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ntá tsi kuān te tɨtɨ́n ña vete xee ña ne, ñá tē kuédadɨɨ ni kāꞌan ñá vata koo é kuēꞌé ña ña doxiꞌí san. Kidáā ne, xée ūvi ñaꞌá ne, ");
INSERT INTO mizNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ntákaꞌan ña: —Ñatīí saꞌá ne, kakaꞌan ña: “Kuvi nanūu u xúkun Xuva kō sán ne, úni ntūvi tsí naxntītsi xtúku u”, kaꞌan kú ña —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nákuntītsí dutu ñá odo nūú san ne, kakaꞌan ña: —¿Ña tuvi ntu é nantiko koō nto? ¿Nee iñá ntu sáꞌā é ntákaꞌan ñáꞌa san iña nto? —kaꞌan dútu ñá odo nūú san ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ntá tsi nte un siin ña ni káꞌan Jésuu. Kidáā ne, kakaꞌan dútu ñá odo nūú san ni Jēsuu: —Kakaꞌán u ni ntō nuu Xuva ko, ña kantíto san, kaꞌan ntó nī kó tē Cristu ntíꞌxe nto, te Īꞌxá Xuva ko ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kidáā ne, kakaꞌan Jésuu ni ña: —É kākaꞌan ntú ku nto. Ntá tsi kakaꞌán u ni ntō tsí viꞌi a vé ne, kiní nto ko, xuꞌu é vēxkúvī ú ñatīi, te tuví u diñɨ kuaꞌa Xuva kō, ña e dóo ntii inī í san. Kiꞌxi ú méꞌñū viko e dukún kān —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kidáā né, kūdiin dútu ñá odo nūú san ni ñā ne, ntata ña dōo ñá vatā xkoó ini ñá ne, kakaꞌan ña: —¡Dōó kinī ó kakaꞌan ña tsí dadɨɨ ña ni Xuva kō! ¿Vá kāntio ká ntu ko ñāꞌa, ña é ntada ntaa? É tekū nto tsi dóo kinī ó kakaꞌan ñá iña Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nté o kadē kuení nto? —kaꞌan ña. Nantíko kōó ña nguiī san, ntákaꞌan ña: —Iō kuetsí ña. Kuétsī é kuvī ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kidáā né, tɨ̄ꞌvi dɨɨ́ na nuu ñá ne, ēꞌní ña ña ne, xéꞌē nuu na vinuu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ntákaꞌan na: —Káꞌan ntō ve, Cristu: ¿Xoó ntu éꞌni i nto? —kaꞌan na. ");
INSERT INTO mizNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kuan tsi ō itúvi Pedrú san nu kíꞌi kān. Xée ūun taꞌnu kade tsiñu nú viꞌī dutú san mí tuví ña ne, kakaꞌán tun: —Dɨvi ntō né, dadɨɨ tsi kaika nto ni Jēsuu, ña véꞌxi ñuú Galileá san —kaꞌán tun. ");
INSERT INTO mizNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ntá tsi núu un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san kakáꞌan ña: —Ñá īní u nee é kākaꞌan nto —kaꞌán Pedru. ");
INSERT INTO mizNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dā ntíi ña xiꞌi kán ne, é tūku taꞌnu kade tsiñu íni tún ña ne, kakaꞌan tún nī ña ntâñɨ étsin san: —Ña sāꞌá ne, dadɨɨ kaika ña ni Jēsuu, ña véꞌxi ñuú Nazaree —kaꞌán tun. ");
INSERT INTO mizNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kakaꞌan xtúku Pedru e ñá ini ñá ña. Kakaꞌan ña: —Ni Úva kō, ñá īní u ña sāꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dā ku e víꞌi ne, xéē ña ntâñɨ́ san ne, ntákaꞌan ñá nī Pedru: —Nuu é ntaā i é ntoꞌo ne, kaduku ntée nto ña tsikan, tsí kakaꞌan ntó vatā ó kakaꞌan ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kidáā ne, kakaꞌan ña é na kuēꞌé Xuva ko ñā é na ntōꞌo ñá tē ña nuu é ntaā i é kākaꞌan ña. Kakaꞌan ña: —Nuu é ntaā i, ñá īni ntíꞌxe ú ña tsīkan —kaꞌan ña. Ura dúꞌva tsi i kána lɨ́ꞌxɨ̄ san. ");
INSERT INTO mizNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kidáā né, nakaꞌān Pedru é kākaꞌan Jésuu ni ña: “Diꞌna dá kāna lɨ́ꞌxɨ̄ sán ne, úni īto kaꞌan e ñá inín ko”, kaꞌan ña. Kidáa ne, kīi Pedrú ne, ēkú kueꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dā tuví ne, un ntɨɨ́ ntɨ̄ɨ tóꞌō dutú san ni ñatā sán ne, nātaká nuu ña é kāꞌan ña é na kūví Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kīꞌní ña ña ne, kueꞌen níꞌi ña ña nūu Pílatu, ña tsiñu kaꞌnu i iña ñuú Roma. ");
INSERT INTO mizNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Júdā, ña é diko Jésuu, dā kútuni ña tsí kuví Jesuú ne, nātɨvi iní ña ne, ntāda xtuku ña kuenta é ōko uꞌxí diuꞌun kuiꞌxín san ntaꞌa tóꞌō dutú ni ñatā san. ");
INSERT INTO mizNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kakaꞌan ña: —Ēdé u kuétsī, tsí ña té nee é kini kaa ni īdé ña é kuvī ña —kaꞌan ña. Ntá tsi ntákaꞌan ñá ni ñā: —Ñá tē neé kuenta iñá ntɨ. Kuenta iña míi ō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ēté xaa Júdā sán diuꞌún san má ūkún kān né, ntīi ña, kueꞌen ñá ne, nakuéꞌne mii ñā kúñu ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ntá tsi nátaka tóꞌō dutú san diuꞌún san ne, ntákaꞌan ña: —Dōo xií kaa é xnūu o diuꞌun sáꞌa ini etun mí ñuꞌu é kāxéꞌe ñaꞌa san doméni iña Xuva ko, tsí nɨñɨ é īnuu áꞌvi sáꞌā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ēdé kuení ña ne, ñīi ña ñuꞌu iña ñá kade váꞌa kɨ́dɨ̄ nteꞌú san mí kuntūꞌxí ña véꞌxi xio ñuu. ");
INSERT INTO mizNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dukuān ne, kakaꞌan ñá Ñuꞌú Nɨñɨ ñuꞌú san un tsi nté vevii. ");
INSERT INTO mizNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kuan ō kúntaa vata ō kaꞌan ñá kaꞌán naa Xuva ko kídaā, ñá nani Jerēmia, dá kāꞌan ña: “Kīꞌi ña é oko uꞌxí diuꞌun kuiꞌxín san, (dɨvi xāꞌví e ntákaꞌan ña Israeé san tsi ntáꞌvi ña iña ñá ne), ");
INSERT INTO mizNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","xéꞌe ñā diuꞌún san é ñīi ña ñuꞌu ña kade váꞌa kɨ́dɨ̄ sán, vata ō kaꞌan Xúva ko nī ko.” Kuan ō kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Íntītsí meꞌñu Jesuu núu ña tsiñu naꞌnu i ne, tsixeꞌe ña tsiñu i san ña: —Dɨvi ntō ne, ¿vá Rei iña ñá Israee ntú nto? —kaꞌan ña. Kakaꞌan Jésuu ni ña: —É kākaꞌan ntú ku nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Da nɨɨ̄ ntátsiꞌi kuetsi tóꞌō dutú san ni ñatā san ñá ne, ñá ni kāꞌan kuéꞌen tsi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kidáā ne, kakaꞌan Pílatú san ni ñā: —¿Ña katéku ntu nto e dóo tɨtɨ́n nuu i ntátsiꞌi kuetsi ña nto? —kaꞌan Pílatú san. ");
INSERT INTO mizNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ntá tsi nté uun túꞌūn ña ni káꞌan ña. Koó dā kúduꞌva ña tsiñu naꞌnu i san. ");
INSERT INTO mizNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dá kakuvi viko sāꞌá ne, kanantíi ña tsiñu naꞌnu i san da xōó ka ñaꞌa, ña ñuꞌu kutu san, ña é ntio ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ntuvi tsikán ne, nuu kutu uun ñatīi, ña é īní un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ñá nani Barābaa. ");
INSERT INTO mizNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dā nátaká nuu ñaꞌa sán ne, kakaꞌan Pílatú san ni ñā: —¿Xoó ñaꞌa ntu ntio nto é nantīi ú ña: Barabaá san ne, o Jēsuu, ña e ntákaꞌan ñáꞌa tsí Cristu ñá, ña vexnákakū nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tsí ini ña é ñaꞌa sán ne, doneꞌu ini ntáda ña kuenta Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Da nɨɨ̄ tuví Pilatu kádē kúꞌvē ñá ne, taxnuu ñadɨꞌɨ̄ ña túꞌūn, kakaꞌan ña: “Ñá ku kiꞌnin nūun iña ñá saꞌa, ña e dóo vaꞌá ñaꞌa san, tsi dóo kantoꞌo kó vevii e dóo kinī o kénī kó kuenta iña ña”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ntá tsi tóꞌō dutú san ni ñatā san tsíꞌi ña dɨkɨ ñaꞌa san é na kākan ña é ntīi Barabaá san ne, na kūví Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kakaꞌan xtúku ña tsiñu naꞌnu i san ni ñā: —¿Xoó ntu é ntuvi ñá saꞌá ntio nto é nantīi u? —kaꞌan ña. Ntákaꞌan ñáꞌa san: —¡Barabaa! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kakaꞌan Pílatú san ni ñā: —¿Nté ntu koo vií u ni Jēsuu, ña é ntákaꞌan nto é Cristu ña? —kaꞌan ña. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntákaꞌan ña: —¡Naxnteē ntó ña krusi! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kakaꞌan Pílatú san ni ñāꞌa san: —¿Nté kui? ¿Neé ntu nuu i é kīni kaa é idé ña? —kaꞌan ña. Ntá tsi dií dií ka ntii ntákaꞌan ña: —¡Naxnteē ntó ña krusi! —ntákachuꞌu ña, ntákaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dā íni Pilatú san tsí ña kuvi vií ña, tsí e éni ntuꞌu ñāꞌa san kudiin ñá ne, kīꞌi ña ntute né, ntaꞌa ñā nuu ñaꞌá san. Kakaꞌan ña: —Ña túvi kuētsí ko te kūví ñatīí sāꞌa. Mii nto ini nto nté koo vií nto ni ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, ntákaꞌan ña: —Kuenta iña míi ntɨ é kuvī ñá, dɨvī ntɨ́ ni īꞌxá ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kidáā ne, nantii ña Barābaa, tsí kuan ō ntío ñaꞌa san. Dā kúvi natií nuu ña Jesuu xóꞌō ne, da táxnūu ña ña é naxnteē ñá ña ntiká krusi kan. ");
INSERT INTO mizNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kidáā ne, sntadun ñá tsiñu naꞌnu i san ne, kueꞌen níꞌi ña Jēsuu má viꞌī méꞌñu kān. Nātaká nuu un ntɨɨ́ ntɨ̄ɨ́ sntadun, ñá ntoo ikān, mí tuví Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nantɨ́ɨ̄ ñá ña ne, xnūu ña ña doo kueꞌe. ");
INSERT INTO mizNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Dēváꞌa ña leꞌé iñū né, xntekū ñá dɨkɨ Jésuu. Xniꞌnī ña uun chɨɨn ntaꞌa kuaꞌa ña ne, ínchɨtɨ ña nūu ñá ne, da narkɨ́nteē ñá ña, ntákaꞌan ña: —¡Na kutūví vaꞌā ntó, Rei iña ñá Israee! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tɨ̄ꞌvi dɨɨ́ ña nuu ñá ne, kīꞌí ña chɨ̄ɨn é niꞌi ntaꞌa ñā ne, da káni ña dɨkɨ Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dā kúvi narkɨ́nteē ñá ña ne, nākiꞌi ña doo kueꞌé san ne, naxnūu xtuku ña ña doo mii ña. Kidáā ne, kueꞌen níꞌi ña ñā é naxnteē ñá ña ntiká krusi kan. ");
INSERT INTO mizNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dá kuēꞌen ña ítsi kān né, tāꞌán ña uun ñatīi, ña véꞌxi ñuú Cirene, ñá nani Sīmuun. Ēde ña ña kuétsi é kuīdo ña krusi Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dā xee ña mí nani Gōlgota, é kāni túꞌun Xɨkɨ Dɨkɨ́ Ntɨxɨ ne, ");
INSERT INTO mizNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","xéꞌe ña ntute tɨntiꞌo é kādaká rkave é kōꞌo ña. Dā íto nteé ña ne, ña ni ntío ña koꞌo ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dā kúvi naxnteē ñá ña ntiká krusi kán ne, nādɨkɨ́ sntadún san xoo é nīꞌi i doo Jésuu, é un é un ña. Kuan ō dé ña vatā ó uve naꞌa kakaꞌan túꞌun Xuva kō: “Kātsin dava ña doó ko. Nadɨkɨ ña xoo é nīꞌi i dúꞌnú ko”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kidáā ne, íntōo ña é kuēnta víi ña ña ikān. ");
INSERT INTO mizNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Xnteē ñá uun taꞌvi rkunu dɨ̄kɨ́ krusi kan é kākaꞌan neé kuetsi é idé ña. Taꞌvi rkunū sán ne, kakaꞌan: “Ña sāꞌá ne, Jesuu, Rei iña ñá Israee”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Xnteē ñá uvi ñaꞌa ña duꞌú ntiká krusi kán ni ñā ntuvi tsikán dɨ. Uun ñaꞌa ña ne, diñɨ kuaꞌa ña ne, uun ñaꞌa ña diñɨ datsin ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Da xōó ka ñaꞌa, ña é īta ntíꞌxin ne, nārkɨ́nteē ñá ña, nakuíko ña dɨ̄kɨ ñá ne, ");
INSERT INTO mizNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ntákaꞌan ña: —Ntōꞌo é kānakatsin nto xúkūn sán ne kanaxntitsi xtúku nto té kuvi ūni ntuvi ne, ¡nakākú mii nto kúñu nto vē! Te nuu é ntaā i é Īꞌxá Xuva ntiꞌxe ko ntō né, ¡nāntii ntee mii nto kúñu ntō ntiká krusí san! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kuan ō dé tóꞌō dutú san, nī mastrú leí san, ni ñatā sán dɨ. Nārkɨ́nteē ñá ña, ntákaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ña sāꞌá ne, nakakū ñá tuku ñaꞌa, ntá tsi ña kuvi nakakú mii ñā kúñu ñā. Kakaꞌan ña tsí Rei iña ñá Israeé san ña. Te ntīi ntee mii ña krusí san ve ne, kuintiꞌxe ntɨ́ ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kakaꞌan ñá tsí kakuintiꞌxe ña Xuva kō. Na nakākú Xuva ko ña ve, tē ntio ntiꞌxe ña ña. Tsí kakaꞌan ña é Iꞌxá Xuva ko ñā —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ña duꞌú san é uve dadɨɨ ña ni ñā ntiká krusi kán ne, nārkɨ́nteē ñá ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kūneé da kanɨɨ ñūxiví san da káꞌñu ntuvi un tsi da nté kaeku uni kuáa. ");
INSERT INTO mizNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ura tsikán ne, dōó ntii kaꞌan Jésuu, kakaꞌan ña: —Elii, Elii, ¿lama sabatani? (é kani túꞌun: Xuvā kó, Xuvā kó, ¿nté kuī xtúvī mii ntu ntó ko?) —kuan ō kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tēkú ña ntáñɨ étsin ne, ntákaꞌan ña: —Kakana ña ñá kaꞌán naa Xuva ko kídaā, ñá nani Ēlia —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ura tsí i kueꞌen úun ñaꞌa ne, koó da kaīnu ña, kúkiꞌí ña uun doo é xnuu ntoꞌo ña ntɨdi íā né, xntekū ñá dɨkɨ chɨ́ɨn sán ne, xéꞌe ñā é kōꞌo Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ntá tsi ña nguiī sán ne, ntákaꞌan ña: —Nakoo mii nto ñā. Koto o tē kiꞌxi Eliá san é nakakū ñá ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kidáā ne, kachuꞌu ntáa Jesuú ne, xíꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ura dúꞌva tsi í ne, ntáta ntāa dôxi é rkaa iko īni ukun kan, nte dɨ́kɨ í un tsi nte xéꞌe i kān. Táān ne, ntɨ́ka xūú san. ");
INSERT INTO mizNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nakaan ñáña ñāꞌa sán ne, tɨtɨ́n ña kuíntiꞌxe i, ña é xiꞌi sán ne, ntōto ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ntīi ña nú ñaña ñā da ntóto Jesuú ne, kuéꞌen ñāꞌa san ñuú Jerusaleen. Tɨtɨ́n ñaꞌa íni ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Dā íni tóꞌō sntadún san ni ña ntoo niꞌi ñā, ña ntáde Kuenta Jésuu, tsí taán ne, dā íni ña kuán ō kúvi ne, koó dā kúduꞌva ña. Ntákaꞌan ña: —Iꞌxá Xuva ntiꞌxe ko ña sāꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tɨtɨ́n ñadɨ̄ꞌɨ́, ña véꞌxī nté ñūú Galilea, ñá ntántīkɨn Jésuu é xntii ña ñā ne, ntáñɨ ika ñā, ntaíto dítō ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maria Madálena ni María, dɨꞌɨ Sāntiau ni Jóseé san, ni dɨꞌɨ īꞌxá Zebedeú san ne, ntâñɨ́ dadɨɨ ña ni ñadɨ̄ꞌɨ, ñá nguiī san. ");
INSERT INTO mizNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dā kuáā ne, xée ūun ña kuika, ña ñuú Arimatea, ñá nani Jōsee, ñá kantīkɨn Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kuéꞌen ñā mí tuví Pilatú ne, ntákan ñā kúñu Jēsuu. Kidáā ne, kakaꞌan Pílatú san é nākuéꞌe ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nākiꞌi Joseé san kúñu ñā ne, dá xnuu taꞌán ña ña doo xee e dóo vaꞌá ne, ");
INSERT INTO mizNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","xnuu ñá ña ini ñaña mii ñā é dā ve éte nuu ña ini xuú san. Ēdɨ́ nuu ñá uun xuu kaꞌnu xiꞌi ñáña sán ne, dā ntaka ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ntá tsi Maria Madálena ni Maria ñá uun sán ne, ñūꞌu nteé ña nú ñañā san. ");
INSERT INTO mizNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tévāá duꞌva tsi ntuvi dá iō dáꞌna ne, nātaká nuu tóꞌō dutú san nī ña fariseú san mí tuví Pilatú ne, ");
INSERT INTO mizNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ntákaꞌan ña: —Ntánakaꞌán ntɨ tsí kaꞌan ñá veté san dá kāntíto dukuan ñā tsí te kuvi uni ntúvi ne, ntoto xtuku ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dukuān ne, káꞌan nto na nākadɨ́ vaꞌā ñá ñañā san da nté tē kúvi uni ntúvi, vata koo é ña kɨ́ꞌɨ̄n ña ntántīkɨn ñá ne, natava ña kúñu ñā. Kidáā ne, kuvi kaꞌan ñá ni ñāꞌa san tsí e ntóto tóꞌo ñā é xiꞌi ña. Dií dií ka kini kaa dovete sáꞌa é vata kaa dovete é kāꞌan diꞌna ña é ntōto ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kakaꞌan Pílatu ni ña: —Dikan ntâñɨ́ sntadun é kuēnta víi ña. Kueꞌēn ntó ni ña, nakadɨ̄ kutu ntó te kūvi vií nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kuéꞌen ñā né, nakadɨ̄ kutu ñá ñañā san. Ēdɨ́ nuu ña xume ntíkō diñɨ i mí ntee táꞌan xuú san ni ñañā san. Ñūꞌu ntee sntadún san é kuēnta víi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dā ita ntíꞌxin ntuvi dá iō dáꞌna, dá tuvi é kuvi ūun ntuvi vité san ne, kuéꞌen María Madālena ni María ñá uun san é kūkoto ntodo ñá ñañā san. ");
INSERT INTO mizNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kidáā ne, un váꞌa tsi taan. Tsi ntíi uun ánje Xuva kō nte e dukún kān. Kīꞌxi ña, náxtixio ña xuú san ne, dā itúvi ntiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Núu ñā ne, vata kaa dá kāxiꞌi núu kaa ne, kuiꞌxīn kueꞌen dóo ña vata katsi. ");
INSERT INTO mizNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ñá tē nté kaa uꞌví sntadún san dá ini ña ña. Koó dā ntanɨ́ꞌɨ ña ne, vata dɨ́ tē xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ntá tsi kakaꞌan ánje Xuva ko ni ñadɨ̄ꞌɨ́ san: —Ñá ku uꞌvī nto, tsí iní u e ntánantuku nto Jēsuu, ña intée ntiká krusí san. ");
INSERT INTO mizNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Xóxō ña, tsí e ntóto ña vata ō kaꞌan ña. Kiꞌxi nto, koto nto míꞌi īnúu ña ne, ");
INSERT INTO mizNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kuēꞌen náneꞌe nto, kūkoto ntó ña ntántīkɨn ñá tsi e ntóto ña é xiꞌi ña. Dīꞌna ña kɨ́ꞌɨn ña é ntōꞌó ñuú Galilea. Ikan nāniꞌi taꞌan nto ña. Sáꞌa tsī é kāꞌán u ni ntō —kaꞌan ánjē san. ");
INSERT INTO mizNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ura tsí i ntáka ñadɨ̄ꞌɨ́ san nú ñaña kān. Úꞌvī ña, ntá tsi dóo diní ña dɨ. Koó dā ntaínu ñā kueꞌen ña é kāꞌan ñá nī ña ntántīkɨn Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Da née ini tsí ña nániꞌi taꞌan ña Jesuú ne, kakaꞌan ñá ntiusi ni ña. Kuéꞌen etsin ñadɨ̄ꞌɨ́ san mí ntitsí Jesuú ne, ínchɨtɨ ña nūu ñá ne, tɨɨn ntaꞌa ña dɨ̄ꞌɨ́n ña, da ntákaꞌan ña e dóo kaꞌnu ñaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kidáā ne, kakaꞌan Jésuu ni ña: —Ñá ku uꞌvī nto. Kueꞌēn ntó, kukoto ntó taꞌan ko, na kɨ̄ꞌɨn ñá ñuú Galileá ne, ikan kinī ñá ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Da nɨɨ kuēꞌen ñádɨ̄ꞌɨ́ san itsi kān né, īó sntadún san é kuēꞌen ña ñuú Jerusaleen, kúnakoto ñá tóꞌō dutú san un ntɨꞌɨ̄ é kúvi. ");
INSERT INTO mizNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dā xee un ntɨɨ́ ntɨ̄ɨ́ ñatā san e kána ña ne, natíin ña ni ñā. Dōo kueꞌe diuꞌun xeꞌé ña sntadún san ne, ");
INSERT INTO mizNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ntákaꞌan ña: —Káꞌan nto ni ñāꞌa san: “Xéē ña ntántīkɨn ña niñú ne, kīꞌi dúꞌu ñā kúñu ña da nɨɨ̄ ntákidí ntɨ”, koo kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te tēkú tóꞌo ntō e ntákaꞌan ntó ne, káꞌān ntɨ́ ni ñā vata koo é ña kuéꞌe ña é ntōꞌo nto —kaꞌan ñá nī sntadún san. ");
INSERT INTO mizNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kīꞌi sntadún san diuꞌún san ne, ide ña vata ō kaꞌan tóꞌō dutú san. Kuan tsī ó ntákaꞌan ñá Israeé san un tsi nté vevii. ");
INSERT INTO mizNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kidáā ne, kuéꞌen ūꞌxi ɨ́ɨn pustrú san ñuú Galilea. Kuéꞌen ña xūku mí taxnūu Jésuu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dā íni ña ña ne, ínūu iní ña ña. Ntá tsi iō ñá e ña ni kuintíꞌxe ña te dɨvi ntīꞌxe ña é Jēsuu ña. ");
INSERT INTO mizNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Xée Jēsuu mí ntoo ña ne, kakaꞌan ñá ni ñā: —É taꞌxi Xuva kō é kadā kûꞌvé u un ntɨꞌɨ̄ é tuví ñuxiví a nī e dukún kān dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dukuān é kākaꞌán u ni ntō é kueꞌēn ntó kanɨɨ ñūxiví sa ne, káꞌan nto vata koo é kuīntiꞌxe ñaꞌa san un ntɨɨ́ ntɨ̄ɨ́ ñuú san túꞌūn kó ne, nakūtsi ntute nto ña kuenta iña Xuva ko, kuenta iñá ko, xuꞌu é Iꞌxā ñá, ni kuēnta iña Espíritū Sántū san. ");
INSERT INTO mizNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nakuāꞌa nto ñá na kāda ntaa ña é un ntɨɨ́ ntɨ̄ɨ́ vatā ó kakaꞌán u ni ntō. Kunūu meꞌñu ú nto ntii dañu ntūví un tsi da nté ntɨ̄ꞌɨ ñuxiví sa. Kuan tsi koo na kōo —kaꞌan Jésuu.");
INSERT INTO mizNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dukuān o iñɨ ntuꞌu e dóo váꞌā ó kakaꞌan túꞌun īña Jesúcristu, dɨ́vi Īꞌxá Xuva kō, ña tuví e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nté ntūvi diꞌna uve naꞌa kakaꞌan Ísaia, ña é kaꞌán naa Xuva ko kídaā, tsí duꞌvā ó kakaꞌan Xúva ko ni Iꞌxā ña: Diꞌna taxnūu ú uun ñaꞌa, ña é xtūví tuꞌvé itsi o, ne, dá taxnūu ú o. ");
INSERT INTO mizNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Uun tatsín ne, dōo ditó kakaꞌan ñuu itsí kān: “Nākoo túꞌvē ntó itsi vaꞌa, tsí e véꞌxi Xuva kō”, kaꞌan, kaꞌan Ísaia san. ");
INSERT INTO mizNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ña é taxnuu Xuva kō ne, dɨvī Juaan, ña é kaika má kūꞌu kan é kanakūtsi ntute ña ñaꞌa san. Kakaꞌan ña é diꞌna natuꞌvi ñaꞌa san kuétsi ña ne, dá kutsi ntute ña. Dukuān é kāda kaꞌnu iní Xuva ko ni ñā kuetsí ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Un ntɨɨ́ ntɨ̄ɨ́ ña ñuú Judea ni ñá ñuú Jerusaleén, dā xee ñá ne, natɨ̄vi iní ña kuetsi ña ne, da itsi ntute ña ntaꞌa Juaán san méꞌñu ntūte kaꞌnu é nani Jōrdaan. ");
INSERT INTO mizNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dóō Juaán san ni ñɨ̄ɨ íꞌxi ña ne, ñɨɨ kameu kúvi. E ini éꞌxi ña ne, skunti; ini xiꞌi ñá ntūdín ñuñu. ");
INSERT INTO mizNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kakaꞌan ntódo ña ni ñāꞌa san: —Viꞌi a vé ne, xée uun ñaꞌa ñatīi, ña é dií ka kaꞌnu ñaꞌa é xuꞌu. Ntē ña té nee nuu áꞌvi ko é nākoó tɨxɨ̄ u é nāntuté u ntiꞌxen ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Xuꞌú ne, kūdii ntute kadáꞌvi ú nto dá kanakūtsi ntute ú nto. Ntá tsi dɨvi ñā ne, Espíritū Sántū taꞌxi ña nto é kunūu ña nima nto —kaꞌan Juaan. ");
INSERT INTO mizNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ntuvi tsikán ne, ntaka Jesuú ñuú mii ñā é nani Nazāree, é tuví ñuú Galilea. Xée ñā mí tuví Juaan. Juaán san ne, nakútsi ntute ña Jesuu méꞌñu ntūte kaꞌnu é nani Jōrdaan. ");
INSERT INTO mizNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kidáā né, dā ntíi Jesuu diñɨ ntute kaꞌnu san ne, īni ña tsí nákaan e dukún kan ne, ikān ntíi Espíritū Sántū san é vata kaa uun paloma é īrkaá nuu dɨkɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kakaꞌan tátsin Xúva kō nte e dukún kān: —Dɨvīn é Iꞌxá miī ko e dóo kakuinimá ko o. Ñá te nté kaa diní nu nimá ko kuenta iña o —kaꞌan Xúva ko ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Espíritū Sántū sán ne, kueꞌen níꞌi ña Jesuu ñuu itsí kān. ");
INSERT INTO mizNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Úvi dīkó ntuvi, úvi dīkó niñu íka Jesuu íkān. Kaika ña mí ntaíka kɨtɨ kuꞌu san. Ikān xée tóꞌō e ña váꞌā san ne, ntio i é kōꞌxo Jesuu núu i é kīni kaa. Ntá tsi xee ánjē san é kade ña ña kuenta. ");
INSERT INTO mizNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dā inúu kutu Juaan viútun sán ne, xée Jēsuu ñuú Galilea, kakaꞌan ntódo ña, kakaꞌan ña nté kuān nte váꞌā ó kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kakaꞌan ña: —E xée ūra í ve. Ña náꞌā ka dá kixkadā kûꞌvé Xuva kō. Dukuān né, natuꞌvi ntó kuetsi nto ne, kuintiꞌxe nto túꞌūn é vāꞌá san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kaika Jesuu díñɨ míni Galileá san ne, ikān nániꞌi ña Simuun ni ení ña, ñá nani Āndree. Ntánakuītá nuu ña xunu ña iní ntute san, tsí dɨvi tsīñu ntáde ña é tsāká ntátava ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kakaꞌan Jésuu ni ña: —Kuntīkɨn ntó ko. Ñá tāvá ka nto tsákā, tsí viꞌi a vé ne, káꞌan nto ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa é na ntūváꞌa nima ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kidáā ne, ura tsí i tsoo mii ña xunu ña ne, dá kuēꞌen ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kūdii tsi kuéꞌen Jesuú ne, nāniꞌi taꞌan ña ni Sántiau ni ení ña, ñá nanī Juaan. Ntuvi ña é īꞌxá Zebedeu. Ñuꞌu ña ni uva ñā iní tun ntoō ñá, ntántaváꞌa ña xunu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kidáā né, kāna Jesuu ña é kuntīkɨn ñá ña ne, ura tsí i xtúvi mii ña uva ña nī ña ntáde tsiñu iña ña iní tun ntōó san, dá kuēꞌen ñá kuntīkɨn ñá Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xée ña ñūu é nani Capērnau. Ntuvi é ntoo kadin ñaꞌa sán ne, kuéꞌen Jēsuu má viꞌī mi ntánataká nuu ña Israeé ne, eni ntuꞌu ñā nakuaꞌa ña ñaꞌá san. ");
INSERT INTO mizNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ñaꞌa sán ne, dōo vaꞌá kuinī ñá da téku ña é kuān nte váꞌā ó kakaꞌan Jésuu. Ñá te ni kāꞌan ñá ni ña vatā ó kakaꞌan mastrú lei íña Xuva ko, tsi dóo iō ña é kāꞌan ña dá kanakuāꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tuví uun ñaꞌa má ūkún kān, ña é nuu e ña váꞌā nima i. Kakaꞌan ñátīí san: ");
INSERT INTO mizNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Nté kui kānateñu nuu nto ntɨ́, Jesuu, ñá ñuú Nazaree? ¿Vēxkáꞌni ntu nto ntɨ? Iní ntɨ nto, tsí Xuva kō táxnūu ña nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ntá tsi de tíi Jesuu ni é ña váꞌā san, kakaꞌan ña: —¡Ntiin iꞌa, tsí ña te íña o sáꞌā! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Īde é ña váꞌā san é xiꞌi mii ñatīí san ne, dōó ntii kachuꞌu ntáa é ña váꞌā san da ntíi, kueꞌen. ");
INSERT INTO mizNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Koó dā kúduꞌva ña ntâñɨ́ san ne, ntákaꞌan ña: —¿Xoó ñaꞌa ntu ña sāꞌa e kúvi idé ña é nakūnu ña é ña váꞌā san? Ña sāꞌá ne, e túku o kadē kúꞌvē ña. Kakutíi ña kanakūnu ña é ña váꞌā san. ¿Né ntu nchuꞌún kanakuāꞌa ña kō? ¿Ō nchuꞌún xeé ntu, ne, nté kaa? —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ura dúꞌva tsi i kútuni un ntɨɨ́ ntɨ̄ɨ́ ña ñuú ntaꞌvi san, ñuú e ntáduku ntée ñuú Galilea, nté ō dé Jesuu, tsí dóo ntákaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Dā ntáka Jesuu mí ntánataká nuu ña Israeé san ne, kueꞌen níꞌi ña Santiau ní Juaan nú viꞌi Sīmuun. Ikān tuví Andreé dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kakaꞌan ñáviꞌi Sīmuun ni Jésuu tsí etsin ñuntɨ́ɨ Sīmuun. Tuví ntaa ña má viꞌi ña kān, tsí kaꞌni kaxéꞌe ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kúkɨ̄ꞌví Jesuu má viꞌī mí tuví ña ne, karkāa ña ntaꞌa ña, náxntitsī ñá ña. Ura tsí i ntikó ña kaꞌni. Kidáā ne, kuéꞌen ña, kūkaváꞌa ña é kāꞌxí ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dā kuáā, da idó nuu ngántii sán ne, ñá tē nté kaa ñaꞌa xee ña mí tuví Jesuu, xee níꞌi ña ña nchokuví ni ñā é ñuꞌu é ña váꞌā nima i. ");
INSERT INTO mizNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Un ntɨɨ́ ntɨ̄ɨ́ ña ñuu í san ne, nātaká nuu ña xiꞌi kan. ");
INSERT INTO mizNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ñá tē nté kaa ñaꞌa ntaváꞌa Jesuú da nēé ka kuiꞌi ntákuvi ña. Nakúnu ñā é ña váꞌā san é ñūꞌu nima ñáꞌa san dɨ. Ñá ni xēꞌé Jesuu itsi é kāꞌan é ña váꞌā san xoo é dɨvi ñā, tsí e ña váꞌā san ne, ini tsí Iꞌxá Xuva ko ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tévāá duꞌva tsi, dá ntɨkɨn niꞌnī ká ne, nákuntītsí Jesuu, kuéꞌen ñā mí xoxó ñaꞌa, tsí ntio ña é kunuu mii ñā é kāꞌan ñá ni Xuva kō, ña tuví e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simuun ni ñá ntoo niꞌi ñā ne, íxnantuku ña Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Dā nániꞌi ña ñá ne, ntákaꞌan ña: —Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntánantuku ña ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kakaꞌan Jésuu ni ña: —Xio ñuu é ntoo etsin iꞌa kɨꞌɨn o ve. Ikān kíkaꞌan ntódo ú dɨ, tsí dukuān é vēꞌxi u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dōo íka ña é un ntɨꞌɨ ītsi ñuú Galilea. Kakaꞌan ntódo ña má viꞌī mi ntánataká nuu ña Israeé san un ntɨɨ́ ntɨ̄ɨ́ ñuú san ne, nakūnu ña é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xée ūun ñaꞌa, ña kanakoꞌxo kúñu ī, mí tuví Jesuu. Kanchɨtɨ ña, kakaꞌan ña: —Tē ntio nto ne, kuvi ntaváꞌa nto ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kidáā ne, ntuntaꞌví ini Jesuu ña. Tɨɨn ntaꞌa ña ñā ne, kakaꞌan ña: —Ntio ko. Ntuváꞌan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ura tsí i ntɨ́ꞌɨ kuiꞌí san ne, ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nataxnūu Jesuu ñá ne, dōo kaꞌan ñá ni ñā: ");
INSERT INTO mizNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ñá ku kāꞌan tsín ni ñāꞌa nté ō kúvi é ntuváꞌan. Kuēꞌén ve mí tuví dutú san, na kōto nteé ña o ne, dá nakuēꞌen sintiáꞌvi ntaꞌa Xuva kō tsi é ntuntoo kúñu o, vatā ó kakaꞌan Muísee é vīin. Dukuan kōo é kūtuni ñáꞌa tsí ntuváꞌan —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ntá tsi ña ntuváꞌa sán ne, kuéꞌen ña itsi kān né, ikān éni ntuꞌu ña kākaꞌan ñá ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san nté ō dé Jesuu é ntaváꞌa ña ña. Dukuān ne, ña ni kúvi xee ditó ka Jesuu nté uun ká ñuu. Da mii tsī e íka ña mí xoxó ñaꞌa. Ntá tsi dóo kiꞌin itsi ñūu véꞌxi ñaꞌa san é nātaká nuu ña mí tuví ña é ntio ña kini ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dā kútɨtɨ́n ntuvi ne, nāxee Jésuu ñuu é nani Capērnau. Ura tsí i kútuni ñáꞌa san é tuví ña uun viꞌi. ");
INSERT INTO mizNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ñá tē nté kaa ñaꞌa nátaká nuu ña; ntē ña ni xee táꞌan viꞌi san é kuntōo ña má viꞌi kān é kīni ña é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kidáā ne, xée kɨ̄mi ñaꞌa, odo ña uun ñaꞌa, ña xiꞌi kúñu ī. ");
INSERT INTO mizNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ñá nī kúvi kuīta ntíꞌxin ña má viꞌī mí tuví Jesuu, tsí ña te nté kaa ñaꞌa ntáñɨ̄ ña. Dukuān ne, kúxēe ña dɨkɨ viꞌi kan né, nākaán ña un siin dɨkɨ̄ viꞌí san mí tuví Jesuu. Mí kantīí ne, nákīí ña chidō é nuu ña xiꞌi kúñu ī san iní viꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dā íni Jesuu tsí ña odō ña xiꞌi kúñu ī sán ne, nɨɨ̄ kuéꞌen ini ña ntákuintiꞌxe ña ne, kakaꞌan ñá nī ña nchokuví san: —É ntōo kuétsi o vē, daꞌ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Īó mastrú lei Xúva kō é ntoo ña ne, ntádē kuení ña: ");
INSERT INTO mizNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nté kui kuān ó kakaꞌan ntú ña sāꞌa? ¿Ña kaíko ñuꞌu ntu ña Xuva kō? Tsí xoxó ñaꞌa ñuxiví sa é kūvi nakate ña kuétsi kō. Da mii tsi Xuva kō é kūvi vií ña”, dé kuení ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kūtuni Jésuu nté ō ntádē kuení ña ne, kakaꞌan ñá ni ñā: —¿Nté kui kuān ó ntádē kuení nto? ");
INSERT INTO mizNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Neé ntu e dií ka ña víꞌxin kaa é kāꞌán u ni ña sāꞌá, te kuinī nto? ¿Ō kaꞌán ntu u: “É ntōo kuétsi o”, ō kaꞌán ntu u: “Nakuntítsin, kuniꞌin chido ō, kunúꞌūn nú viꞌi o kān”, koo kaꞌán u? ");
INSERT INTO mizNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ntio ko é na kūtuni nto tsí xuꞌu é vēxkúvi ú ñatīí ne, kuvi nakate u kuétsi ntō ñuxiví sa —kaꞌan Jésuu ni mastrú leí san. Kidáā ne, kakaꞌan ñá nī ña xiꞌi kúñu ī san: ");
INSERT INTO mizNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Dɨvīn é kākaꞌán u ni ō ne, nakuntítsin, kuniꞌin chido ō, kunúꞌūn nú viꞌi o kān —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ura tsí i nakuntítsi ña, nákiꞌi ña chido ñā ne, kúnūꞌú ña nú viꞌi ña kān. Koó dā kúduꞌva ñaꞌa san ne, nánūꞌu ñá iní ña Xuva kō, ntákaꞌan ña: —Váta ūun ito kini o é kuān ó kakuvi, é kāntuváꞌa ñaꞌa san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kidáā ne, kuéꞌen xtūku Jesuu diñɨ míni Galilea. Dōo xee ñáꞌa san mí tuví ña ne, nakuáꞌa ña ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kuéꞌēn ká Jesuu ítsi kān né, ikān nániꞌi ña uun ñaꞌa, ñá nani Lēvii, iꞌxá Alfeu. Tuví Levii nú viꞌī mí kaido ña diuꞌun xôo iña ñuú Roma. Kakaꞌan Jésuu ni ña: —Kuntīkɨ́n ko —kaꞌan ña. Nákuntītsí Levií ne, kuéꞌen ña ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Uun ntuvi ne, tuví Jesuu nú viꞌi Lēvii, ntaéꞌxi ña. Ñá te da dīi ña ntaído diuꞌun xôó san ntoo ña nú mesa, ni ñá iō kuetsí i. Ikān tuví Jesuu ni ña ntɨníꞌi ñā. Tsí ña te da díi ñaꞌa san ntántīkɨn ñá Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ntá tsi mastrú lei ni ñá fariseú san ne, īní ña tsí ntaéꞌxí dadɨɨ Jesuu ni ñá kini ntáa san, nī ña ntaído diuꞌún san ne, ntákaꞌan ñá ni ña ntɨniꞌi Jēsuu: —¿Nté kui ntaéꞌxí dadɨɨ ntu mastru ntó nī ña kini ntáa san, nī ña ntaído diuꞌún san? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tēkú Jesuu é ntákaꞌan ñá ne, kakaꞌan ñá ni ñā: —Ñaꞌa é vāꞌá o ni ī ne, ñá vādá ntio ña medíkū; tsí ña nchokuví tsi san é ntio ña medíkū. Xuꞌu é vēxkúvi ú ñatīí ne, ñá tē ña é vāꞌá san kanantukū u, tsí ñá iō kuetsí i san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ña ntɨniꞌī Juaan ni ñá ntɨniꞌī ña fariseú san ne, dukuān xkoó ini ña é kuntoo ixu ñā. Xée ñāꞌa san, ntátsixeꞌe ña Jēsuu: —¿Nté kui ña kuan xkoó ini ntú ña ntɨniꞌi ntō é kuntoo ixu ña vatā ó de ña ntɨniꞌī Juaan ni ñá ntɨniꞌī ña fariseú san? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesuú ne, kakaꞌan ña: —¿Vá kuvi ntu kuntoo ixu ñāꞌa, ña ntóo viko mí katántaꞌa ñaꞌa, te tuví dukuan ñatīí, ña tántaꞌa san? Ñáꞌā, tsí kaꞌxí ntɨꞌɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ntá tsi tē xee úra i é ntaka ña tántaꞌa sán ne, kidáā né, īó ntuvi é kuntoo ixu ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ʼÑá tē doo xée san naxntēé nuu o doo tsude, tsí doo xée sán ne, kanatɨxɨ tē ntóo. Kidáā ne, ntátsin ntɨꞌɨ ne, dií dií ka kini koo kuvi. ");
INSERT INTO mizNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tē xnuu váꞌa o ntute tɨntiꞌo xee iní ñɨɨ̄ sán ne, ñá te ñɨɨ ata kūꞌun, tsí ntata té kukāve. Uun ito tsi kunaá ntute tɨntiꞌo san ni ñɨɨ ī sán dɨ. Tsí ntute tɨntiꞌo xeé san ne, kantio é kūꞌun iní ñɨɨ xēe —kaꞌan Jésuu, kánañēꞌe ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ntuvi dá iō dáꞌna ne, kuéꞌen Jēsuu ni ña ntɨníꞌi ñā, ítā ntiꞌxin ña mí kaa trigú san. Ña ntɨniꞌi Jēsuú ne, kātsin ña xoko trigu é kāꞌxí ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Īní ña fariseú san é kuān ó de ña ne, ntákaꞌan ña: —¿Nté kui ntákatsin ntu ña xoko trigú san? Ñá vāꞌá ō é kada tsiñu o ntūvi dá iō dáꞌna, tsi dóo xii kaa é kuān koo vii o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ntá tsi kakaꞌan Jésuu: —¿Ña íni ntú nto nté ō dé uvata ko Dāvii da taan núu ña ni ña ntɨniꞌi ñā da kákɨn ña? ");
INSERT INTO mizNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tsí kɨꞌví ña iní viꞌi Xuva kō kidáā dá tuví dutu ñá odo nūu, ñá nani Abīata. Davií ne, íkan ña tāñúꞌu kuíko san é kāꞌxi ñá ni ña ntɨniꞌi ña, kuān te dóo xií kaa, tsí da mii tsī dutú san é kūvi kaꞌxí ña tañúꞌū e kúviko san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kakaꞌan Jésuu ni ñá fariseú san: —Tsí Xuva kō ne, ñá te nī de kúꞌvē ñá ñaꞌa vata koo é na kāda kaꞌnu ña ntuvi dá iō dáꞌna, tsí dē kúꞌvē ñá ntuvi dá iō dáꞌna vata koo é na kūntoo daꞌna ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Xuꞌu é vēxkúvi ú ñatīí ne, kuvi kāꞌán u nee iña é vāꞌa é vīi o ntúvi dá iō dáꞌna —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kuéꞌen xtūku Jesuu má viꞌī mi ntánataká nuu ña Israee. Ikān tuví uun ñaꞌa, ña e kádun ntaꞌa i. ");
INSERT INTO mizNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ntâñɨ́ ñaꞌa má viꞌī san, ntaíto díto ña te ntāváꞌa Jesuu ña kádun ntaꞌa i ntuvi dá iō dáꞌna. Tsí ntántukū nuu iní ña nté koo tsiꞌi kuétsi ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kakaꞌan Jésuu ni ña kádun ntaꞌa i san: —Kuntītsín méꞌñū ñaꞌa san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kidáā né, tsixeꞌe Jēsuu ñá nguiī san: —¿Nee iñá ntu é dií ka váꞌā o é vīi o ntuvi dá iō dáꞌna, te kuinī nto: é vīi o é vāꞌá ne, ō é kīni kaa? ¿É ntaváꞌa o ñaꞌa ne, ō é nakunaa o ña? —kaꞌan ñá, tsixeꞌe ña ñā. Koó dā diin diin sa intóo ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Dā íto Jesuu ñáꞌa san ne, dōó dutsi kuíni ña ne, dōo uꞌvi kakúvi ña é kuān nte káꞌxi nima ñáꞌa san. Kidáā ne, kakaꞌan ñá nī ña kádun ntaꞌa i san: —Nakāan ntáꞌa o —kaꞌan ña. Nákāa ñá ntaꞌa ña ne, ura dúꞌva tsi i ntuváꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kidáā né, ntāka ña fariseú san, kueꞌen ñá, kūnatiín ña ni ña ntɨniꞌi Hēródē nté koo kaꞌní ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kuéꞌen Jēsuu ni ña ntɨníꞌi ñā diñɨ míni Galilea. Ñá te da dīi ña ñuú Galilea ntántīkɨn ñá Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Dōó kiꞌin itsi vēꞌxí ñaꞌa san é kinī ñá Jesuu da téku ña nee ntɨ́ꞌɨ ntɨꞌɨ nuu i é kade ña. Dōó tɨtɨ́n ñaꞌa ntáka ña ñuú Judea, Jerusáleen, Idúmeá, ni ñūu é ntoo xio diñɨ ntute kaꞌnu é nani Jōrdaán ne, xée ñā é kīni ña é kākaꞌan ña. Véꞌxi ñā nte ñúú Tiru ni Síduun. ");
INSERT INTO mizNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kakaꞌan Jésuu ni ña ntɨníꞌi ñā é na kutūví tuꞌve tsi úun tun ntōo é kunūu ña vata koo é ña taꞌu núu ña méꞌñū ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ñá te da dīi ñá nchokuví san ntaváꞌa ña ña. Dukuān ne, un tsi ntátɨꞌvi nuu taꞌan ña é ntio ña tɨɨn ntaꞌa ña Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Dā íni é ña váꞌā san Jésuú ne, nákunchɨtɨ̄ nú xeꞌe ña. Dōó ntiī kachuꞌu ntáa, kakaꞌan: —Dɨvīn é Iꞌxá mii Xuva ko ō —kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","—Ñá ku kuān xkoó kaꞌan xoó ñaꞌa u méꞌñū ñaꞌa san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kidáā ne, kúxēe Jesuu rkɨ́ uku kán ne, kāna ña xoó ñaꞌa e ntío ña. Ne, xée ñā mí tuví Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kidáā ne, nákaxnuu Jesuu uxuvi ñáꞌa, ña é kuntɨniꞌi ñā. Taxnūu Jesuu ña é na kɨ̄ꞌɨn ña, kíkaꞌan ña túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xéꞌe Jēsuu ítsi é kūvi ntaváꞌa ña ña ntánchokuví san nī é nakūnu ña é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Uxúvi ñaꞌa ña sāꞌa, ña é nakaxnúu Jesuu: Simuun, é kākaꞌan Jésuu é Pedru kunáni ña; ");
INSERT INTO mizNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiau, iꞌxá Zebedeú, ni enī ña, ñá nanī Juaan, ntuvi ña é xntántēe Jesuu ña é Boanege ña, é kāni túꞌun Iꞌxa É Kākatsin, tsí dóo dutsi ini ña; ");
INSERT INTO mizNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andree, Félipe, Bartulúmee, Máteu, Túmaa, Sántiau, iꞌxá Alfeu, Tádeu, tuku Símuun; ");
INSERT INTO mizNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Júda Scarīote, ña é diko Jésuu. Rkontûví ne, xée Jēsuu nú viꞌī ñaꞌa ne, kúkɨ̄ꞌví ñā má viꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ntá tsi dóo tɨtɨ́n ñaꞌa xee ntikɨn ñá ña, é ntē ña ni kunéꞌe kaꞌxí ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kūtuni ñáviꞌi Jesuu é kuān ó kantoꞌo ña ne, xée ñā é nākuntéka ña ña, tsí kakuluku Jésuu, kuíni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mastrú lei, ña véꞌxi ñuú Jerusaleén ne, ntákaꞌan ña: —Ñatīí saꞌá ne, nteé kɨmi ña īña é ña váꞌā é nani Belsēbuu. Dukuān é kakuvi kanakūnu ña é ña váꞌā san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kidáā né, kāna Jesuú mastrú leí san ne, náñēꞌe ñá ña, kakaꞌan ñá ni ñā: —¿Nté ntu koo vii tóꞌō e ña váꞌā san é nakuīta é ñā váꞌa niꞌi ī? ");
INSERT INTO mizNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tē ntánāa míi ña ñuu i sán ne, ntánakunaá ña ñuú ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tē ntánāa míi ñaꞌa sán nī ñavíꞌi ña ne, ntánakūnaá ña ñaviꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Te miī tóꞌō e ña váꞌā san naa núu miī ne, ¿nté ntu koo kutíi i? Tsí kanakunaa mii tsi kúñu ī. ");
INSERT INTO mizNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ʼNté uun xoxo kuvi kɨ́ꞌvi i iní viꞌi ña dóo ntii inī í san é kiꞌi dúꞌu iña ñá tē ña diꞌna kiꞌní ña ña dóo ntii inī í san. Kidáā ne, kuvi kiꞌi dúꞌu ña é un ntɨꞌɨ īña ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ʼNuu é ntaā i é kākaꞌán u ni ntō tsí kuvi vií Xuva ko nākate ña un ntɨɨ́ ntɨ̄ɨ kuétsī é īó iña ñaꞌa, nī é ntákaꞌan kíni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ntá tsi ña kada kaꞌnú ini Xuva ko ni ñāꞌa te ntákaꞌan kíni ña iña Espíritū Sántū san. Koo kuétsi ña ntii dañu ntūvi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Duꞌvā ó kakaꞌan Jésuu, tsí ntákaꞌan ñáꞌa san é nuu é ña váꞌā nima ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kidáā ne, xée dɨꞌɨ Jēsuu ni ení ña. Ntáñɨ̄ ntée ña ña nu kíꞌi kān, ntákaꞌan ñá ni ñāꞌa san é ncho kaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ña ntoo niꞌi Jēsuú ne, ntákaꞌan ñá ni ñā: —Dɨꞌɨ nto ni enī ntó ne, ntáñɨ̄ ntée ña nto kíꞌi kān, ntánantuku ña ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kidáā ne, kakaꞌan Jésuu: —¿Xoó ntu é dɨꞌɨ̄ ko? ¿Xoó ntu é ēní ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kidáā né, īto Jesuu ñáꞌa san, ña ntoo diñɨ ña ne, kakaꞌan ña: —Un ntɨɨ́ ntɨ̄ɨ́ ña sāꞌá ne, dɨꞌɨ̄ kó ña, ení ko ni tāꞌan ko. ");
INSERT INTO mizNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tsí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña e ntáde é ntio Uva kó ne, dɨvi ñā é ēní ko ña ne, taꞌan kó ña; dɨvi ñā é dɨꞌɨ̄ kó ña dɨ —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ēni ntuꞌu xtuku Jesuu kánakuāꞌa ña ñaꞌa san diñɨ mínī san. Ñá te da dīi ñaꞌa nátaká nuu ña. Dukuān ne, kúxēe Jesuu íni tun ntōo é tuví nu mínī sán ne, itúvi ña. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, ntoo ña nú ñutɨ kan. ");
INSERT INTO mizNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tɨtɨ́n nuu i kakaꞌan Jésuu é kanakuāꞌa ña ñaꞌa san iña Xuva ko. Kantaa ña uun nuu i ni ñāꞌa san, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Kini nto é kākaꞌán u ni ntō: Uun ñaꞌa ne, kuéꞌen ña, kūtsoó ña ntɨkɨn. ");
INSERT INTO mizNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dá katsōo ña né, īó ntɨkɨn san é itsi kan kōꞌxo. Kidáā ne, xée láā, éꞌxi tɨ ntɨkɨn san. ");
INSERT INTO mizNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Īó ntɨkɨn sán ne, kóꞌxo neꞌu xuú san mí ña kuéꞌe ntéꞌu iō. Uun dáꞌna tsi kéne xuku i, tsí ña tuvi kuéꞌe nteꞌu é kāka xoꞌo i. ");
INSERT INTO mizNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dā naíꞌni ne, kādún xoꞌo ī ne, xíꞌī, tsí ña tuvi kuéꞌe nteꞌu mí kāka xoꞌo i. ");
INSERT INTO mizNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Īó ntɨkɨn sán ne, kóꞌxō mí kākene xuku íñū. Ntá tsi da kéne xuku íñū mi kéne xuku vaꞌá san ne, távi nūu xuku vaꞌá san ne, xíꞌī; ña ni kíi kɨ̄tɨ i. ");
INSERT INTO mizNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tuku ntɨkɨn sán ne, kóꞌxo ñuꞌu vāꞌa. Kēne xuku í ne, kukaꞌnu. Oko úꞌxi kɨ̄tɨ i kíi tɨ é uun dítsin ī. É tūku ditsin í ne, úni dīkó kɨtɨ i kíi tɨ. É ūun ká ditsin í ne, uun sientu tɨ́ kíi tɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kakaꞌan ña: —Xoo é kātekú i ne, na kīni i —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Dā kunúꞌu ñaꞌa sán ne, uxuvi ñá ntɨniꞌi Jēsuú nī ña intóo ká ne, tsixeꞌe ña Jēsuu nee iñá ntu kani túꞌun nuu i é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kidáā ne, kakaꞌan Jésuu ni ña: —Ntōꞌó ne, kataꞌxi Xuva ko é kūtuni nto nté o kadē kúꞌvē ña. Ntá tsi ña nguiī sán ne, ñá īni ña. Dukuān né, da mii kuēꞌen tsi túꞌūn é ña káñeꞌe dɨkɨ ñáꞌa san kakaꞌán u ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kakuvi vata ō kaꞌan Ísaia kídaā, tsí kuān te ntaíni ña, ntá tsi ña te ntaíni ntíꞌxe ña. Ntátekú ña é kākaꞌán u, ntá tsi ña ntáñeꞌe dɨkɨ ña. Dukuān ne, ñá natūꞌvi ña kuétsi ñā ne, ñá kada kaꞌnū iní Xuva ko ni ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tsixeꞌe Jēsuu ña: —¿Ñá nī ñeꞌe dɨkɨ ntu nto é kākaꞌán u? ¿Nté koo kɨꞌɨn dɨkɨ ntu nto te kāꞌán ka ú ni ntō kuan? ");
INSERT INTO mizNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tsí ñaꞌa, ña kakaꞌan túꞌun Xuva kō né, vata kaa ñaꞌa, ña katsoo ntɨkɨn san, kaa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Iō ñáꞌa ne, dā téku ña túꞌun Xuva kō ne, vata kaa nteꞌu ítsi san mí koꞌxó ntɨkɨn san kaá nima ña. Tsí ura tsí i da téku ña túꞌun Xuva kō ne, véꞌxi tóꞌō e ña váꞌā san é nakiꞌi túꞌūn san é īnúu nima ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Iō ñá e dóo diní ña e ntátekú ña túꞌun Xuva kō. Dɨvi ñā ne, vata kaa kudii ntéꞌu nú xūú san mí koꞌxó ntɨkɨn san kaa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ntá tsi ña naꞌa kakutíi i, tsí ña tuvi kuéꞌe xoꞌo i. Ña sāꞌá ne, ña náꞌa ntáxnuu ña nima ña é kākaꞌan Xúva kō. Tē nee iña é ntoꞌo ña, o tē dóo kini o ntákaꞌan ñáꞌa tsí kuintiꞌxe ña túꞌun Xuva kō né, xtuvī mii ña é kuntīkɨn ñá Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Iō ñá e ntátekú ña túꞌun Xuva kō ne, vata ntáa nteꞌu mí kākene xuku íñū mí kōꞌxó ntɨkɨn san ntáa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ña ni éꞌnu ntɨ̄kɨn san, tsí xuku íñu san tɨ́ɨn nuu ditsin i. Kuan tsī ó kakuvi ni ñāꞌa sán dɨ. Dōo ntántɨꞌɨ iní ña nee iñá vií ña. É kukuika ña ñuxiví sa é ntio ña. Ntaéni ntaꞌví mii ñā kúñu ñā tsí diuꞌun dóo ntio ña, ne, ntio ña da nēé ka ntɨꞌɨ̄ é īó ñuxiví sa. Ña ntákuneꞌe ña é viī ña kuenta túꞌun Xuva kō. Dukuān ne, ña ntaéꞌnu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Iō ñá e dóo váꞌā o téku ña túꞌun Xuva kō. Dɨvi ñā ne, vata ntáa nteꞌu vaꞌá san mí kōꞌxó nuu ntɨkɨn san ntáa ña. Tsí ntákuintiꞌxe ña túꞌun Xuva kō ne, ntáde ntaa ña é kākaꞌan Xúva kō. Īó ntuvi vāꞌá iña ña. Vata ntáa ditsin i mi kíi oko uꞌxi, uni díko, ni ūun sientu kɨ́tɨ i ntáa ña —kuan ō kaꞌan Jésuu ni ñá ntoo niꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kakaꞌan xtúku Jesuu ni ña: —Te nātuún o kāntílīn má viꞌi kān ne, ¿vá ma etun ntú kan xtuvi o, ō má itó kān? ¿Ñā ntu te xntekú dukún ō vata koo é nāxiꞌí nuu? ");
INSERT INTO mizNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nee iña é vīi xúꞌu o vēvií ne, kutuni ñáꞌa sán rkontûvi. ");
INSERT INTO mizNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Xoo é ntátekú i ne, na kīni i é kākaꞌán u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kakaꞌan xtúku ña: —Kini váꞌa nto é kaini nto. Vata tsī o xntéku kúꞌvē ntó ne, dadɨɨ tsi kúꞌve i nīꞌi ntó ne, ntekú ka niꞌi ntó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tsí ñaꞌa, ña é īo iña í ne, dií ka kueꞌe níꞌi ña, ntá tsi ñaꞌa, ña é ña tuvi íña í ne, kunaá ntɨꞌɨ iña ña —kaꞌan Jésuu ni ñá ntoo niꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kakaꞌan xtúku Jesuu: —Mí kadē kûꞌvé Xuva kō né, vata kaa uun ñaꞌa, ña katsoo ntɨkɨn matú i. ");
INSERT INTO mizNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ña sāꞌá ne, kakidi ñá niñú a ne, dá kanākuntítsi ña ntuvi ā. Tē ita ntíꞌxin ntuvi ne, kene ntɨkɨn san, dá kēne xuku i. Ntē ñá ini ña nté ō kúvi kéne, ");
INSERT INTO mizNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","tsí nteꞌú san kade miī é kēne ntɨkɨn san. Diꞌna tsi xuku i kakéne ne, dá ntɨ̄ka íta i. Kidáā ne, kakii kɨtɨ i. ");
INSERT INTO mizNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tē íꞌxe tɨ ne, tɨɨn ña tɨ, tsí xee ntúvi ī —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kakaꞌan Jésuu: —¿Nee iñá ntu é ntudadɨɨ vatā o mí kadē kûꞌvé Xuva kō? ¿Ō neé ntu kuvi ntada dadɨɨ o ni ī? ");
INSERT INTO mizNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mí kadē kûꞌvé Xuva kō ne, vata kaa uun ntɨkɨn kuli kaa. Ntɨkɨn kulí san ne, dií ka kuetsī é da nēé ka ntɨkɨn é kūꞌxí ō. ");
INSERT INTO mizNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ntá tsi tē kantúꞌxi ne, kaeꞌnu da nte dií ka dukun é da nēé ka tuku xuku. Lāá san ne, katsodo tɨ tāka tɨ́ ntaꞌa i mí vētɨ, tsi dóo naꞌnu xuku ī —kaꞌan Jésuu ni ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Núu ī é vāta kaa sáꞌa kantaa Jesuu dá kanakuāꞌa ña ñaꞌa san un tsi da nte míꞌi kɨ̄ꞌɨn dɨkɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Da mii kuēꞌen tsí nuu i sáꞌa kantaa ña ni ñā. Ntá tsi dá ntoo mii ña ni ña ntɨniꞌi ñā ne, xéꞌe ñā é kūtuni ña nee ntɨ́ꞌɨ ntɨꞌɨ kani túꞌun é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dā kuáa ntuvi tsikán ne, kakaꞌan Jésuu ni ña ntɨníꞌi ñā: —Kuíta ntiꞌxin o ūun xo diñɨ ntute san ve —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kidáā né, ña ntɨniꞌi Jēsuu tsóo mii ña ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, dá kūxée ña iní tun ntōo mí nuu Jesuu. Tɨtɨ́n ñaꞌa kūxée ña tuku tun ntōo é kɨ̄ꞌɨn ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kidáā ne, iñɨ ntúꞌu ínu tātsín ō ne, uun ito tsi kukɨ́ꞌvi ntūte iní tun ntōó san un tsi da nte tsítu ntute. ");
INSERT INTO mizNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesuú ne, kakidi ña ata tún ntōó san, xɨꞌɨ téu ña doo dɨ́kɨ. Nantóto ña ntɨniꞌi Jēsuu ña, ntákaꞌan ñá ni ñā: —¡Mastrû! ¿Ñā ntu te káde nto kuenta é dóko sa téni ō? —kaꞌan ñá ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kidáā ne, nákuntītsí Jesuu, dá kakāꞌan ñá ni tātsin ni ntuté san: —¡Nakunúun kadin! ¡Diin diin tsi kutūvin! —kaꞌan ña. Xíō kadin tatsin ni ntuté san. ");
INSERT INTO mizNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kidáā ne, kakaꞌan Jésuu ni ña ntɨníꞌi ñā: —¿Nté kui ntaúꞌvī ntú nto? ¿Ña ntákuintiꞌxe ntu nto tsi dóo kaꞌnu Xuva kō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dā kúduꞌva ña ntɨniꞌi ñā ne, ntánatíin mii ñā: —¿Nēe ñáꞌa ntu ña sāꞌa é un tsi nte tatsin ni ntuté san ntáde ntaa é kākaꞌan ña? —kaꞌan ñá ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xée ña ūun xo diñɨ mínī san, nté ñūu é nani Gādara. ");
INSERT INTO mizNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Dā ntíi Jesuu tún ntōó san ne, xée ētsín uun ñatīi, ña é ñuꞌu é ña váꞌā nima i. Kapusantú kān véꞌxi ñatīí san, ");
INSERT INTO mizNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","tsí ikān nuu ña mí ntoo ñaña ñāꞌa san. Xōxó kuvi xnūꞌni í ña, nté kadena. ");
INSERT INTO mizNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kiꞌin itō xnúꞌni ñā kadena dɨ́ꞌɨn ña ni ntāꞌa ña, ntá tsi uun ito tsi kátsin tuꞌun ña kadená san. Nté uun xoxo ni kuvi vií i ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nté ntūvi nte níñu kaika ña má kūꞌu kán, nī nú ñañā sán dɨ; ñá te xkūtíkadin ña. Un váꞌa tsi kakachuꞌu ntáa ña, kaxéꞌe ña xuú san kúñu ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ikā ká veꞌxí Jesuú ne, koó da kainu ñatīí san kueꞌen ña, kukunchɨ́tɨ ña nuu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Dōó ntii kakaꞌan: —¿Nté kui kanatekū duꞌxen ntu ntó ntɨ, Jesuu, Iꞌxá Xuva kō, ña tuví e dukún kān? Natekū ntó Xuva kō tsí ña ku nakutsuꞌun ntō ntɨ —kaꞌan é ña váꞌā san é ñuꞌu nima ñátīí san. ");
INSERT INTO mizNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tsí kakaꞌan Jésuu ni é ña váꞌā san: —¡Ntiin nima ñá sāꞌa, é ña váꞌā! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tsixeꞌe Jēsuu ña: —¿Nté ntu nanin? —kaꞌan ña. —Ligiuun naní ntɨ, tsí ña te da dií ntɨ —kaꞌan é ña váꞌā san é ñuꞌu nima ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Īkan dá xeꞌe ntaꞌa Jesuu: —Vií nto da xeꞌe, ñá ku nakunū ntó ntɨ é kɨ̄ꞌɨ́n ntɨ xio ñuu —kaꞌan é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ikan tsi ētsin ne, ñá te da dīi kútsin ñuꞌu tɨ, ntaéꞌxi tɨ má kūꞌu kan. ");
INSERT INTO mizNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kidáā ne, íkan é ña váꞌā san da xeꞌe ntaꞌa Jesuu: —Taꞌxi nto na kūꞌun ntɨ́ nima kútsín san —kaꞌan é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kakaꞌan Jésuu tsí kuvi. Kidáā né, ntīi é ña váꞌā san nima ñátīí san ne, kuéꞌen, kūkuꞌun nima kútsín san. Ñá te da ūvi míil kútsín san ne, īnu tɨ un ntɨɨ́ ntɨɨ̄ tɨ́, kueꞌen tɨ rkɨ deꞌve kán ne, ikan tsī éte nuu tɨ kúñu tɨ̄ ini mínī san, ne, uun ito tsi téni ntɨꞌɨ tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ña ntáde kuenta kútsín san ne, koó dā ntaínu ña kunúꞌu ña, kantaa ña ni ñāꞌa san ítsi kan nī má ñūu kan nté ō kúvi ni kūtsin ña. Ñaꞌa sán ne, kuéꞌen ña, ūn ntɨɨ́ ntɨɨ̄ ñá, kūkoto ditó ña nté ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Xée ñāꞌa san mí ntitsí Jesuú ne, īní ña ñatīí san, ña é dīꞌna ñuꞌu é ña váꞌā san nima i. Vevií ne, diin diin sá tuví ña. É nakunūu ña duꞌnu ña, tsí é ntūváꞌa ña. Ña xeé san ne, dōo uꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ñaꞌa, ña ini nté ō kúvi ne, ntákaꞌan ñá nī ña ñuú ña nté ō kúvi nī ña lukú san, nté ō kúvi ni kūtsín san da téni tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ña ñuu i sán ne, ntákaꞌan ñá ni Jēsuu é na ntāka ña ñuú ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dā nakunúu xtuku Jesuu tún ntōó san ne, ñatīí, ña é ñūꞌu é ña váꞌā nima í ne, íkan ñā é kɨ̄ꞌɨn ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ntá tsi ña ni ntío Jesuu é kuntēka ña ña. Kakaꞌan Jésuu ni ña: —Kūnúꞌūn nú viꞌi o kān. Káꞌan nī ñaviꞌi o nté ō dé Tóꞌo o ni ō. Káꞌān nté ō ntúntaꞌví ini ña o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kidáā ne, kúnūꞌú ña nú viꞌi ña kān, da ntáa ña ni ūn ntɨɨ́ ntɨ̄ɨ́ ña ntoo ñuú Decapuli nté ō dé Jesuu ni ña. Ñaꞌa sán ne, koó dā kúduꞌva ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nákunūu xtuku Jesuu tún ntōó san, kuéꞌen ña, nāxee ña tuku diñɨ mínī san. Ñá tē nté kaa ñaꞌa nátaká nuu ña mí xee Jésuu díñɨ mínī san. ");
INSERT INTO mizNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ikan vēꞌxí uun ñaꞌa, ña nteé ntaꞌa i xiꞌi úkūn ña Israeé san, ñá nanī Jairu. Dā íni ña Jesuú ne, ínchɨtɨ ña nūu ñá ne, ");
INSERT INTO mizNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kakaꞌan ña: —Dóko sā kúvi iꞌxá ko. Kiꞌxi nto, tɨɨn ntaꞌa ntō í, na kūtíi ntuváꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kidáā ne, kuéꞌen Jēsuu ni ña. Ñá te da dīi ñaꞌa kuéꞌen ñá dɨ. Dōo táꞌu nūu Jesuu méꞌñū ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Véꞌxi uun ñaꞌa ñadɨ̄ꞌɨ́, ña nchokuví san, méꞌñū ñaꞌa sán dɨ. É uxuvi kuíā e nteé kɨmi ña kuīꞌi é kaetɨ nɨñɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ñá te da dīí ntaꞌa medíku ñeꞌe ñá ne, dōo ntóꞌo ña. Uun ito tsi nantɨꞌɨ ñá diuꞌun ñá ne, ntē dúkuan ña ni ntuváꞌa ña; dā dií dií ka kúkaꞌvī ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dā téku ña é kāntaváꞌa Jesuu ñáꞌa sán ne, kuéꞌen ñā, nuu taꞌán ña méꞌñū un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ata Jésuu, da tɨ́ɨn ntaꞌa ña dōo Jésuu, ");
INSERT INTO mizNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","tsí dé kuení mii ña te da mii tsī é tɨɨn ntaꞌa ña dōo Jésuú ne, ntuváꞌa ña, kuiní ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kidáā ne, ura tsí i tuꞌu é kaetɨ nɨñɨ ña. Kūtuni ña tsí é ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesuú ne, kūtuni ña tsí kuvi idé ña ntaváꞌa ña ña nchokuví san. Xkokōto ña méꞌñū ñaꞌa sán ne, dā tsíxeꞌe ñā: —¿Xoó ntu tɨɨn ntaꞌa i dōó ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ntá tsi ña ntɨniꞌi ñā ne, ntákaꞌan ña: —Dōó kataꞌu nūu nto, tsí ña te nté kaa ñaꞌa ntáñɨ̄ ña. ¿Nté kui kuān ó kakaꞌan ntú nto tē xoo tɨ́ɨn ntaꞌa i ntō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ntá tsi Jesuú ne, kaito ña ñaꞌa san, kánantuku ñā xoo ñáꞌa ña tɨ́ɨn ntaꞌa ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kidáā ne, véꞌxi ñadɨ̄ꞌɨ́ san, tsí ini ña tsí ntuváꞌa ña ne, ínchɨtɨ ña nūu Jésuu. Koó dā kanɨ́ꞌɨ ña é kauꞌvī ña. Kakaꞌan ntáa ña tsí dɨvi ñā e tɨ́ɨn ntaꞌa ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kidáā ne, kakaꞌan Jésuu ni ña: —É ntūváꞌan ve, tsí kuíntiꞌxe o. Vā váꞌa tsi kunúꞌun, tsí é ntūváꞌan kueꞌen ve —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nɨɨ dukuan kākaꞌan Jésuu ni ñadɨꞌɨ́ san ne, xée ñāꞌa, ña véꞌxī nte nú viꞌī Jairu, ña é nchokuvi dióko ī. Ñaꞌa sán ne, ntákaꞌan ña: —E xíꞌi dióko ntō. ¿Nté kui kanatekū duꞌxén ka ntú nto Mastrú san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ña ni íde Jesuu kuénta é ntákaꞌan ñáꞌa san, ntá tsi kakaꞌan ñá ni uva īꞌxá san: —Ñá ku uꞌvī ntó; kuintiꞌxe nto Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ñá ni xēꞌé Jesuu itsi é kɨ̄ꞌví ñaꞌa san ni ña; mii tsī Pedru ni Sántiau ní Juaan, ení Santiaú san. ");
INSERT INTO mizNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Dā xee Jésuu ni ña nú viꞌī ña nteé ntaꞌa i xiꞌi úkūn sán ne, dōo dito ntaéku ñaꞌa san é ntaéku nteé ña diókō Jairu. ");
INSERT INTO mizNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kidáā ne, kúkɨ̄ꞌví Jesuu má viꞌi kān ne, kakaꞌan ñá ni ñāꞌa san: —¿Nté kuān nte dúꞌxen eku ntu ntō? Tsí iꞌxá san ne, ñá te ni xīꞌi, tsí kūdii kakídi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ntá tsi ñaꞌa sán ne, da ntáxkuntée ña é kākaꞌan Jésuu, tsí ini ña tsí e xíꞌi kueꞌen iꞌxá san. Ntá tsi kíñuꞌu Jesuu un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san nu kíꞌi kān. Da mii tsi dɨꞌɨ īꞌxá san ni uva i, nī ntuni ñáꞌa ña ntɨniꞌi ñā kúkɨ̄ꞌví niꞌi ñā mí tuví iꞌxá san. ");
INSERT INTO mizNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dā karkáa Jesuu ntáꞌa i ne, kakaꞌan ñá ni ī: —Talita, kumi (é kāni túꞌun: Nākuntítsin, laꞌ) —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kidáā ne, nákuntītsí iꞌxá san ne, nakaka, tsí é uxuvi kuíā i. Koó dā kúduꞌva ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesuú ne, kakaꞌan ñá ni uva īꞌxá san é ña ku kaꞌán ña ni ñāꞌa san nté ō kúvi ntóto a dióko ñā. Kakaꞌan ñá ni dɨꞌɨ ī é na kuēꞌé ña é kāꞌxi. ");
INSERT INTO mizNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ntāka Jesuu ñuú mí tuví ña ne, dá kūnúꞌu ña ñuú mii ña ni ña ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Dā xee ntúvi dá iō dáꞌna ne, eni ntuꞌu Jēsuu kánakuāꞌa ña ña Israeé san má viꞌī mi ntánataká nuu ña. Ña ntáteku í ne, koó dā kúduꞌva ña, ntákaꞌan ña: —¿Xoó ntu nakuāꞌa i ñá saꞌa é kuān ó kakaꞌan ña? ¿Míꞌi ntu vēꞌxi e dóo kiꞌin inī ña, é kakuvi kade ña un ntɨꞌɨ nūu i e dóo naꞌnu? ");
INSERT INTO mizNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Vá ñā te dɨvi ntu ña kade váꞌa utun, iꞌxá Maríā? Ini o ení ña, Santiau, Jósee, Júda, ni Sīmuun. Vata te īꞌa ntoo taꞌan ña ñuú kō dɨ —kaꞌan ña. Dukuān ne, ñá ni kuintīꞌxe ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ntá tsi Jesuú ne, kakaꞌan ñá ni ñā: —Da míꞌī ká ñuú ne, ntaíko ñuꞌu ñāꞌa san ña kakaꞌán naa Xuva ko. Ntá tsi ña ñuú mii ñā ne, ñá ini iko ñuꞌu ña ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ikān ne, ña ni kúvi viī ña nté uun nuu i e dóo kaꞌnu. Nteꞌvi tsī ña nchokuví san tɨ́ɨn ntaꞌa ña ñā ne, ntaváꞌa ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Koó dā kúduꞌva Jesuu é xoxo ni kuintíꞌxe i ña. Kidáā ne, e tuku e túku ñuú kueꞌen ña, kunañéꞌe ñá ñaꞌa san túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kidáā né, kāna Jesuu uxuvi ñáꞌa ña ntɨniꞌi ñā ne, uvi uvi ñáꞌa ña táxnūu ña ña. Xéꞌe ñā é kūvi vií ña nakūnu ña é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kakaꞌan Jésuu é ña te neé kuido ña é ntio ña itsi kān. Ntē ña kuido ña é kāꞌxí ña; nté diuꞌún ña kuido ña; da mii tsi tatun ñā é kɨtuun ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kuvi kɨꞌɨ ña ntiꞌxen ña, ntá tsi ña kuido ña dúꞌnu ña é nadama ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kakaꞌan Jésuu ni ña: —Tē xee ntó uun viꞌi ne, ikan tsi kuntōo nto da nté ntāka nto ñuú san. ");
INSERT INTO mizNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tē ña taꞌxi ña viꞌi ña é kuntōo nto, o tē ña ntío ña kini ña é ntákaꞌan ntó ne, nakɨdɨ ntō ntiꞌxen nto nteꞌu ñuú san ne, dá ntāka ntó ikān. Kuan kōo kutuni ñáꞌa san tsi íō kuetsí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kidáā ne, kuéꞌen ña, kūkaꞌan ntódo ña ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, na nātɨvi iní ña kuétsi ñā né, na kuintiꞌxe ña Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dōó tɨtɨn é ña váꞌā é ñūꞌu nima ñáꞌa san nakunu ña. Nákutsi nūu ña asete ñá nchokuví san ne, ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kūtuní rei Heródē nté ō dé Jesuu, tsí ntákaꞌan un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. Iō ñá ntákaꞌan ña: —Á tē e ntóto Juaan Bautista. Dukuān né, dōó iō ña é kūvi vií ña nuu i e dóo naꞌnu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Iō ñá ne, ntákaꞌan ña: —Ña sāꞌá ne, á tē ña é kaꞌán naa Xuva ko kídaā, ñá nani Ēlia —kaꞌan ñáꞌa san. Tuku ñaꞌa ne, ntákaꞌan ña: —Kuan kāa ntíꞌxe ña, vata kaa ña kaꞌán naa Xuva ko kídaā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ntá tsi dā téku Heróde nūu i sáꞌa ne, kakaꞌan ña: —Dɨvi ñā é Juaan, é nakɨꞌɨ tūꞌún u dukun ña. Á tē ntóto ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tsí mii Hēródē táxnūu ña é tɨ̄ɨn ña Juaán san. Xnuu kutu ña ñā viutun kuenta iña ñádɨ̄ꞌɨ ení ña, tsi Heródē sán ne, nakiꞌi ña ñadɨ̄ꞌɨ́ ení ña, ña nani Fēlipe, é kūvi tún ñadɨꞌɨ̄ ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tsí kakaꞌan Juaan ni Heródē san tsi dóo xii kaa é nakiꞌi ña ñadɨ̄ꞌɨ́ ení ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Táꞌnu dɨ̄ꞌɨ́, táꞌnu nani Herōdiá ne, dōó dutsi kuíni tún nī Juaán san ne, ncho kaꞌní tun ña, ntá tsi ña ni kuvi, ");
INSERT INTO mizNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tsí Heródē ne, úꞌvī ñá Juaan, tsí ini ña tsi dóo vaꞌá ñaꞌa ña ne, kade ntaa ña un ntɨꞌɨ̄ é ntio Xuva ko. Dōo diní ña da téku ña é kākaꞌan Juaán san, ntá tsi un tsi kúdana iní ña nté koo vií ña é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ntá tsi xee ntúvi e ntúku nuu ini Herodia nté koo vií ña nī Juaán san. Tsí da táva Heródē viko ña ntuvi da káku ña ne, xée ūn ntɨɨ́ ntɨ̄ɨ́ ña tsiñu i ñuú san, nī tóꞌō sntadún san, ni ñāꞌa, ña ntoo naꞌnu ñuú Galilea, é kāꞌxi ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kidáā ne, xéē dióko Herōdiá san mí kakuvi viko sán ne, iteꞌē tun. Dōo inténi Heródē né, dōo inténi ña xeé san dɨ da íteꞌē tun. Kidáā ne, kakaꞌan Heródē sán nī tun: —Kákān kó nee iña é ntio o ne, dá tāꞌxi ú o. ");
INSERT INTO mizNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Xéꞌe ña xuꞌu ña, kakaꞌan ña: Kuān te dava ñuꞌu mí kadē kûꞌvé u kákan ne, taꞌxi u —kaꞌán rei Heródē san. ");
INSERT INTO mizNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ntīi tún ne, kútsixeꞌē tún dɨꞌɨ̄ tun: —¿Nee iña é vāꞌá kakán u? —kaꞌan tún, tsixeꞌē tun. —Kákan dɨ̄kɨ́ Juaan Bautista —kaꞌan táꞌnu dɨꞌɨ̄ tun. ");
INSERT INTO mizNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kaxkainu tún kueꞌen tun mí tuví rei Heródē ne, kakaꞌán tun: —Nchio ko é tāꞌxi nto vevií tsi dɨkɨ́ Juaan Bautista; kunūu iní tɨchiꞌi —kaꞌán tun. ");
INSERT INTO mizNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dōo kúntaꞌxa iní rei Heródē san, tsí e xeꞌé ña xuꞌu ña nuu un ntɨɨ́ ntɨ̄ɨ́ ña ntoo viko san. Ña ni kúvī ká natɨ̄vi iní ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ura tsí i táxnūu ña sntadún san é nā kíkiꞌí ña dɨkɨ́ Juaan. ");
INSERT INTO mizNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kuéꞌēn sntadún san ne, ēꞌnte túꞌun ña dɨkɨ́ Juaán ne, dā xee niꞌi ña, nuu iní tɨtiꞌí san. Xéꞌe ña tāꞌnú dɨ̄ꞌɨ́ san, da nakuéꞌe tún dɨꞌɨ̄ tun. ");
INSERT INTO mizNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dā kútuní ña ntɨniꞌī Juaán san ne, kūnakíꞌi ña kúñu ñā, dá kūkuꞌxí ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Rkontûví ne, nāxeé ña ntɨniꞌi Jēsuu é īxkaꞌan ntódo ña ni ñāꞌa sán ne, ntaa ña ni Jēsuu ún ntɨꞌɨ̄ é idé ña, é nakuaꞌa ña ñaꞌá san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kakaꞌan Jésuu ni ña: —Niꞌí nto, kɨ́ꞌɨn ō, kíkūntóo daꞌna ō mí xoxó ñaꞌa —kaꞌan ña. Tsi dóo ntánaxee ñáꞌa; ntē ñá ntákuneꞌé ña é kāꞌxí ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nakúꞌun ña tun ntōó san ne, dá kuēꞌen ña mí xoxó ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ntá tsi dóo tɨtɨ́n ñaꞌa san íni ña ña dá kuēꞌen ñá ne, nakiní ña xoó ñaꞌa ña. Kīi ntɨɨ́ ntɨ̄ɨ́ ña ñuú i san, kuéꞌen ña. Koó dā ntaínu ña kueꞌen ña mí kuēꞌen Jésuu ni ña ntɨníꞌi ñā ne, diꞌna ñaꞌa sán xeé ña é dɨvi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Dā xee tún ntōo é nuu Jesuu díñɨ ntute kān né, īní ña tsí ña te nté kaa ñaꞌa xee ña. Ntūntaꞌví ini Jesuu ña, tsí ntántétu ñaꞌa san xoo é kāꞌan í ni ñā iña Xuva ko, vata tsī ó ntántétu a leꞌntú san xoo é kɨꞌɨn niꞌi i tɨ é kīkaꞌxí tɨ tē xoxó tóꞌo tɨ̄. Kidáā ne, ñá te da dīi núu ī é nāñéꞌe Jesuu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Dā kuáā ne, xée etsin ña ntɨniꞌi Jēsuu, ntákaꞌan ñá ni ñā: —É dōo kuáa ne, xoxó ntoo i iꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nataxnūu nto ñaꞌa sán, nā kíkuiín ña é kāꞌxí ña. Na kɨ̄ꞌɨn ñá rantsú san, o na kɨ̄ꞌɨn ñá xio ñuu, kintúku ñā é kāꞌxí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ntá tsi Jesuu kakáꞌan ña: —Dɨvi nto kuēꞌé nto é kāꞌxí ñaꞌa san —kaꞌan ña. —¿Míꞌi ntū? Kuān te kíkuiín ntɨ uvi sientu aꞌví tañúꞌū ne, ¿míꞌi ntu xēe táꞌan é kāꞌxí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san? —kaꞌan ñá ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kidáā né, kakaꞌan Jésuu ni ña: —Kūkoto nto: ¿tɨtɨ̄n ntú tañúꞌu odo nto? —kaꞌan ña. Īxkóto ñā ne, da ntákaꞌan ña: —Úꞌun tsī tañúꞌu ni ūvi tsákā san ió tɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kidáā ne, kakaꞌan Jésuu é na kuntōo ñaꞌa san nú ité san é xio xío kuntōo ña: ");
INSERT INTO mizNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","kuenta úvi díko uꞌxi ña, kuenta siéntu ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kidáā né, kīꞌi Jesuu é ūꞌun tañúꞌū sán nī ntuvi tsákā san. Da ntániꞌi ña nuu ña e dukún kān ne, nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō. Kidáā né, kātsin dava ña, ");
INSERT INTO mizNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","dā xeꞌé ña éꞌxi ntaꞌa un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Dā kúvī éꞌxi ñaꞌa sán ne, natáka ña ntɨniꞌi ña taꞌvī tañúꞌu nī tsákā san é ntoó ka. Uxúvi xīká ka tsítū é ntoo. ");
INSERT INTO mizNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Uꞌun míil ñatīí san éꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kidáā ne, kakaꞌan Jésuu ni ña ntɨníꞌi ñā: —Kueꞌēn ntó, kūnakuꞌún nto iní tun ntōó san ne, kueꞌēn ntó uun xo diñɨ ntute san mí tuví ñuú Betsaida. Nɨɨ dukuan na kāꞌán u ni ñāꞌa san é na ntāka ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Dā nátaxnūu ña ñaꞌa sán ne, kuéꞌen ñā má kūꞌu kán, kūkaꞌan ntâꞌví ña ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dā kúneé ne, nuu tun ntōó san méꞌñū ntute san. Jesuú ne, ítuvī mii ñá ñuꞌu kan. ");
INSERT INTO mizNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Īní ña tsi dóo ntántoꞌo ña ntɨniꞌi ñā, ntánakaka ña tun ntōó san, tsi dóo kainu tatsin. Dā dokó sa tuví ne, xée Jēsuu mí ñūꞌu ña méꞌñū ntute san. Ntitsí Jesuu nú ntūte san, kaíka ña, vata tsi tē ncho kuido ntúu ña ña, ");
INSERT INTO mizNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ntá tsi dā íni ña ntɨniꞌi ña ñā, ñá ñuꞌu tun ntōó san, é kaika ña nú ntūte sán ne, dōo uꞌví ña, tsí ntɨxɨ, kuiní ña. Un ntii tsī ntáchuꞌu ntáa ña, ");
INSERT INTO mizNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tsi íni ntɨꞌɨ ña ña ne, úꞌvī kueꞌen ña. Ntá tsi ura tsí i kakaꞌan Jésuu ni ña: —¡Na kōo ntii nto! Ñá ku uꞌvī nto, tsí xuꞌu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kidáā ne, kúxēe ña iní tun ntōo mí ñūꞌu ña ne, ura tsí i xío kadin tatsín san. Koó dā kúduꞌva ña ntɨniꞌi ñā é kuān o idé ña. ");
INSERT INTO mizNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tsí ña ní ñeꞌe dɨkɨ ñá ntɨniꞌi ñā san nté ō kúvi da kátsin dava Jesuu tañúꞌū san da éꞌxi un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. Tsí vata kutúni ña xoó ñaꞌa é Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dā kúvi ita ntíꞌxin ña mínī sán ne, xée ña ñūu é nani Genesāree. Ikān né, kīꞌní ña tun ntōó san diñɨ ntute san. ");
INSERT INTO mizNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ura tsí i da ntíi ña iní tun ntōó san ne, kūtuni ñáꞌa san tsí dɨvi Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Koó dā ntaínu ña, kueꞌen ña kanɨɨ ñūú tsikan, kūkuidó ña ña nchokuví san. Chidō san tsódo ña ñā ne, kueꞌen níꞌi ña ña dā míꞌī ka é kākaꞌan ñáꞌā é tuví Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Dā míꞌī ka mí kuēꞌen Jésuú ne, kuān te ñuú naꞌnu, kuān te ñuú kuetsi, kuān te má kūꞌú ne, ikān xee niꞌi ñaꞌá san ñá nchokuví san, dā tsóo ña ña mí kāxíō xáꞌvī. Ña ntánchokuví san ne, ntaíkan ña itsi te kuēꞌé Jesuu é tɨɨn ntaꞌa ña kuān te da míi tsi ntēte doo ña. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña tɨ́ɨn ntaꞌa dōo ñá, ntūváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kidáā ne, xée ētsin ña fariseú san mí tuví Jesuu. Nātaká nuu ña nī mastrú lei, ña véꞌxi ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ini ña tsí ña ntɨniꞌi Jēsuú ne, ña ni ntáꞌa ñā. Kuan tsi ō éꞌxi ña é dentu ntāꞌa ña. —¿Nté kui kuān ó de ntu ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Tsí kuān xkoó ini ña fariseu ni un ntɨɨ́ ntɨ̄ɨ́ ña Israeé san, é ña kaéꞌxi ña tē ña diꞌna ntoo váꞌa ntáꞌa ña, vatā o idé ñata ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tē náxee ña é ñēꞌe ña nu âꞌví ne, ñá īni eꞌxí ña tē ña diꞌna dáꞌvi ña ntute kúñu ñā. Dōó īó ka xtuku nuu i é xkoó ini ña é īni de ntáa ña: é ntūntoo eꞌxin e ntáxiꞌi nuu ña, ni sālú, ni kɨ̄dɨ́, ni ītó ña.) ");
INSERT INTO mizNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Dukuān ne, ña fariseú san nī mastrú lei ntátsixeꞌe ña Jēsuu: —¿Nté kui ña ntɨniꞌi ntō ne, ña ntáde ña vatā xkoó ini ñáta kō? ¿Nté kui ña ntántaꞌa ntu ña diꞌna dá kaꞌxi ña? —kaꞌan ñá, tsixeꞌe ña Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ntá tsi Jesuú ne, kakaꞌan ña: —Ntōꞌó ne, ñá te kanɨɨ̄ nima ntó ntánuu iní nto Xuva kō. Tsí nuu é ntaā i é kākaꞌan úvata ko Isāia íña nto da xntée naꞌa ña túꞌun Xuva kō é kākaꞌan: Ña sāꞌá ne, kūdii rkɨ́ xaa ña ntéku é kākaꞌan ña é kānuu iní ña ko; ñá tē nima ñá kakene. ");
INSERT INTO mizNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kuān te kanúu ini ña kó ne, ñá vādá kaidiáꞌvi i, tsí ña te leí ko é ntánakuāꞌa ña ñaꞌa san, tsí kūdii lei é de váꞌa ñaꞌa, ña ntoo ñuxiví sa, ntánañēꞌe ñá ña, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tsí ntōꞌó ne, ntánakunaá nto lei Xúva kō ne, vata tsī xkoó ini ñáꞌa san ntáde ntaa nto. Tsi xkoó ini nto é ntōo nuu salu ni vásu é ntáxiꞌi nuu nto ne, dōó tɨtɨ́n ka nuu i é xkoó ini nto —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kakaꞌan xtúku ña ni ñā: —¿Vāꞌá ntu ō ntáde nto, kuiní nto, é kuān o ntánakuitā ntó lei Xúva kō vata koo é nakuntīkɨn nto nte xkoó ini nto iña mii nto? ");
INSERT INTO mizNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tsí vatā ó kakaꞌan Muísee: “Kuiko ñuꞌu o uva ko ni dɨꞌɨ kō”, ne, “Xoo é kīni koo kaꞌan í ni uva i, ni dɨꞌɨ ī ne, kuvi”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ntá tsi dɨvi ntō ne, ntaxéꞌe nto itsi é kāꞌan ñáꞌa san ni uva ña, ni dɨꞌɨ ñā: “Ña kúvi xntīi ú nto, tsí un ntɨꞌɨ īñá ko ne, é nākuéꞌē ú ntaꞌa Xuva kō”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Da é kuān ó kakaꞌan ñá ne, ntaxéꞌe nto itsi é ña xntii ña uva ña ni dɨꞌɨ ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kuān ó ntánakunaá nto é kākaꞌan Xúva kō ne, é tūku nuu i ntánaxtuvī nto. Dōó kiꞌin nuū i ntáde nto é kuān xkoó ini nto —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kidáā né, kāna Jesuu un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, kakaꞌan ñá ni ñā: —Kini nto ve, un ntɨꞌɨ kueꞌen dúꞌva nto. Kini váꞌa nto é kākaꞌán u ni ntō: ");
INSERT INTO mizNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ña túvī nee iña é kaēꞌxí ñaꞌa é kade i é kudentu ñā. Mii tsī é kākene nima ñá é dentū. ");
INSERT INTO mizNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tē xoó katekú i ne, na kīni —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dā xntáñɨ mii ña ñaꞌá san ne, kúkɨ̄ꞌví ña iní viꞌi san. Ña ntɨniꞌi ñā né, tsixeꞌe ña ñā kídaā: —¿Nee iñá ntu kani túꞌun é kākaꞌan nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kakaꞌan Jésuu ni ña: —Ntōꞌó ne, ¿ñā ntu ntátekú nto dɨ? ¿Ñá ini ntú nto tsí ña tuví nee iña é kaēꞌxí ñaꞌa é kakiꞌxi nte kiꞌi kan é kade i é kakudentū nima ña? ");
INSERT INTO mizNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tsí ña te nima ñá kakɨ́ꞌvi, tsí mii tsi īni iꞌxí ña kakɨ́ꞌvi ne, dá kantīi kúñu ñā —kaꞌan ña. Dukuān ne, nee iña é ntaéꞌxi ó ne, váꞌā; ña te déntū. ");
INSERT INTO mizNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kakaꞌan ñá dɨ: —É kakēne nima ñáꞌa sán ne, dɨvī é kade i é kakudentu ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tsí un tsi nté nima ñá kakene e ntádē kuení ña é kīni kaa, e ntáde ña é kini kaa ni ñadɨ̄ꞌɨ ñáꞌa san, e ntáde luku ña, e ntaéꞌní ña ñaꞌa, ");
INSERT INTO mizNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","e ntáde ña é kīni kaa, e ntaéni ntâꞌví ña ñaꞌa, e ntáde xení ña, e ntákuneꞌu iní ña, e ntákaꞌan ñá dovete, e dóo naꞌnu ncho vií ña, e ntáde tuntu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","É un ntɨꞌɨ̄ é kīni kaa sán ne, nima ñá kakene. Dukuān é ntákudentu ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kidáā né, ntāka Jesuu, xée ētsin ña diñɨ ñuú Tiru ni ñūú Siduun. Ikan kūkɨ́ꞌvi ña má viꞌi kān. Ña ni ntío ñā é kūtuni ñáꞌa san mí tuví ña. Ntá tsi ña ni kúvi kutūvi xuꞌú ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ura tsí i dá kutuni úun ñadɨ̄ꞌɨ mí tuví ña ne, xée ñā, nakunchɨ́tɨ ña nūu ña. Diōkó ñadɨ̄ꞌɨ́ san ne, nuu é ña váꞌā nimá tun. ");
INSERT INTO mizNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ñadɨ̄ꞌɨ́ san ne, tuku ñuu véꞌxi ña. Ñá te ña Israee ña, tsí ñuú Sirofenicia véꞌxi ña. Íkan ña ntāꞌa Jesuu é na nakūnu ña é ña váꞌā san é nuu nima dióko ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Dá kakāꞌan Jésuu ni ña: —¿Nté kui xntii ntū ú o? Tsí ña te ña Israeen. Diꞌna ña Israeé san xntiī ú ña. Tsí ñá vāꞌá ō é kiꞌi ō é kaēꞌxi iꞌxá san ne, dá kuēꞌé ō é kāꞌxi tínā san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nāntíko kōó ñadɨ̄ꞌɨ́ san, kakaꞌan ña: —Ntáa nchiꞌxe, Mastru. ¿Ntá tsi vá ñā che ntaéꞌxi ntu chínā sán utsi ita é ntánakōꞌxo iꞌxá san má mēsa? —kaꞌan ñádɨ̄ꞌɨ́ san. ");
INSERT INTO mizNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kakaꞌan Jésuu ni ña kídaā: —Dōo váꞌā ó kakaꞌan. Kunúꞌun ve, tsi é ntīi é ña váꞌā san nima dióko ō —kaꞌan ñá ni ñadɨ̄ꞌɨ́ san. ");
INSERT INTO mizNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dá kūnúꞌu ña ne, nāxee ña nú viꞌi ña kān. Ikān tuví ntaa dióko ñā nú ītó tun. Ntīi ntiꞌxe é ña váꞌā san é īnúu nimá tun. ");
INSERT INTO mizNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kidáā né, ntāka Jesuu ñuú Tirú ne, ítā ntiꞌxin ña ñuú Siduun. Kūntii ña ñuú Decapulí, ne, xée ñā nu míni Galilea. ");
INSERT INTO mizNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ikān ne, xee níꞌi ñaꞌa san uun ñáꞌa, ña loꞌō ne, ñá kakūvi kaꞌan vaꞌá ña. Íkan ñāꞌa san é na tɨɨn ntaꞌa Jēsuu ña é na ntāváꞌa ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesuú ne, kueꞌen niꞌi xío ña ña, tsi dóo ntâñɨ́ ñaꞌa san. Nákɨꞌvī ñá rkɨntaꞌa ña ini loꞌxo ña ne, dáꞌvi ñā dɨ́ɨ ña rkɨntaꞌa ña ne, da tɨ́ɨn ntaꞌa ñā rkɨ xaa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kidáā né, ntāa niꞌi ña nuu ña e dukún kān né, dā xkóo kani ña, kakaꞌan ña: —¡Efata! (é kāni túꞌun: ¡Nakaan!) —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ura tsí i nákaan loꞌxo ña. Ntūváꞌa xaa ña dɨ. É kākaꞌan vaꞌá ña ve. ");
INSERT INTO mizNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kakaꞌan Jésuu ni ñáꞌa san é ñā ku kaꞌán ña ni da xōó ka ñaꞌa nte o kúvi. Ntá tsi vata tē da nakuaꞌa Jésuu ña é kuān koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Koó dā kúduꞌva ñaꞌa san, ntákaꞌan ña: —¡Ñá tē nté kaa váꞌā o é kade ña sāꞌa! Un tsi nté ña loꞌo kāntaváꞌa ña. Un tsi nté ña ñɨꞌɨ̄ sán nákaꞌan ñá dɨ —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ntuvi tsikán ne, dōo kueꞌe ñaꞌa nátaká nuu ña. Ña túvī é kāꞌxí ña. Kāna Jesuu ña ntɨníꞌi ñā ne, kakaꞌan ñá ni ñā: ");
INSERT INTO mizNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Kantuntāꞌví ini kó ñaꞌa san, tsi é uni ntūvi é ntoo ña nī ko. Ña túvī nee iñá kaꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te nataxnūu ú ña é na nūꞌu ñá nu viꞌi ña kān é ñā káꞌxi ña ne, koó vitā ñá itsi kān, tsí iō ñá ne, dōó ika vēꞌxí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ntá tsi ña ntɨniꞌi ñā ne, ntákaꞌan ña: —¿Nté ntu koo niꞌi ña é kāꞌxí ña? Tsí kūdii ñuu itsi iꞌa, mí xoxó ñuꞌu i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ntá tsi Jesuú ne, tsixeꞌe ña ñā: —¿Tɨtɨ̄n ntú tañúꞌu odo ntō? —Úꞌxē sa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kidáā ne, kakaꞌan Jésuu ni ñaꞌá san é na kūntoo ña ñuꞌu san. Kīꞌi ña tañúꞌū sán ne, da nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō. Kātsin dava ña tañúꞌū sán ne, dā xeꞌé ña ña ntɨniꞌi ñā é na tsīꞌi ña é kāꞌxí ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Odō ká kudii ña tsákā sán dɨ. Nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva ko kuēnta iña í, dā xeꞌé ña ña ntɨniꞌi ñā é na tsīꞌi ña é kāꞌxí ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dā kúvi éꞌxi ntāꞌá ñaꞌa sán ne, natákā ñá taꞌvi ī é ntoó ka. Úꞌxē ká xika i nátsuꞌun tsitu ñā é ntoó san. ");
INSERT INTO mizNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ñá te da kɨ̄mi míil ñátīí san éꞌxi ña. Kidáā né, nataxnūu ña ñaꞌa san é na nūꞌu ñá viꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kidáā ne, kuéꞌen Jēsuu ni ñá ntɨníꞌi ñā, nakúꞌun ña īní tun ntōó san é kɨ̄ꞌɨn ñá ñuu é nani Damānuta. ");
INSERT INTO mizNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Xéē ña fariseú san é kōto nteé ña Jesuu. Eni ntuꞌu ñā ntatíin nuu ña, ntákaꞌan ñá ni ñā: —¿Nté ntu koo kutuní ntɨ tē nuu é ntaā i é kākaꞌan nto? Vií nto uun nuu i e dóo kaꞌnu, na kīní ntɨ nuú ntɨ, tē nuu é ntaā i é vēꞌxí nto ntaꞌa Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesuú ne, un tsi xkóo kani ña, kakaꞌan ña: —¿Nté kuān nte ntaíkan ntu ña ntoo vevii nuu i e dóo kaꞌnu? Nuu é ntaā i é kākaꞌán u ni ntō: Ñá vīí u nté uun nuu i e dóo kaꞌnu é kinī ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kidáā né, tsoo mii Jēsuu ñá ne, nákunūu xtuku ña tun ntōó san, kueꞌen ñá xio diñɨ ntute san. ");
INSERT INTO mizNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ña ntɨniꞌi Jēsuú ne, kūnáa inī ña é kuīdo ña é kaꞌxī ña. Uun kudii tañúꞌū san níꞌi ña iní tun ntōó san. ");
INSERT INTO mizNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kakaꞌan Jésuu ni ña: —Koto xnto uꞌxen ia īña ñá fariseú san ni īña Heródē dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nātiín mii ña ntɨniꞌi ñā kídaā, ntákaꞌan ña: —¿Nee iñá ntu kani túꞌun é kākaꞌan ñá iña uꞌxen íā san? ¿Ō dé ña tuvi ntu tañúꞌu niꞌi ō né, ō nté ō ntu? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kūtuni Jésuu é ntánatíin ña ne, kakaꞌan ñá ni ñā: —¿Nté kuān o ntákaꞌan ntú nto é ña tuvi tañúꞌū? ¿Vāta ntu kiní nto? ¿Vāta ntu kɨ́ꞌɨn dɨkɨ nto é kākaꞌán u ni ntō? ¿Nté kuān nte káꞌxi ntu nto? ");
INSERT INTO mizNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Īó ntuxnūú nto ne, ña ntaíni nto. Īó tutun ntó ne, ña ntátekú nto. ¿Ña nakaꞌan ntu nto nuu i é dóo kaꞌnu é idé u víꞌi, ");
INSERT INTO mizNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","dā kátsin dava u é ūꞌun tsí tañúꞌū sán ne, úꞌūn míil ñāꞌa san éꞌxi ña? ¿Tɨtɨ̄n ntú xika i é ntoó ka san nataká nto? —kaꞌan Jésuu ni ña ntɨníꞌi ñā. —Uxúvī ka —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Dā kátsin dava u uꞌxe tañúꞌū sán ne, kɨ́mī míil ñāꞌa san éꞌxi ña ne, ¿tɨ̄tɨ́n ka ntu xika i é ntoó ka nataká nto? —kaꞌan Jésuu, tsíxeꞌe ña ñā. —Úꞌxē ka —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Ntē dúkuān ña ntáñeꞌe dɨkɨ ntu nto? —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Xée ña ñūú Betsaida. Ñaꞌa sán ne, xee níꞌi ña uun ña kuāá ne, íkan ña ntāꞌa Jesuu é na tɨɨn ntaꞌa ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesuú san ne, írkaa ña ntaꞌa ña kuāá san ne, ñeꞌe níꞌi ña ña diñɨ ñuú san. Kidáā ne, nákāꞌa ña dɨ́ɨ ña ntuxnūú ña kuāá san ne, dā xntékū ñá ntaꞌa ña dɨkɨ ña. Tsixeꞌe ña ñā: —¿É kainín ntun ve? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nākaán ña kuāá san ntuxnūú ña ne, dá kakāꞌan ña: —Kainí u ñatīi vata ntáa utun ntáa ña, ntá tsi ntaíka ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kidáā né, tɨɨn ntaꞌa xtūku ñá ntuxnūú ña kuāá san. Nākiní vaꞌā ñá un ntɨꞌɨ̄ kídaā. ");
INSERT INTO mizNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kidáā né, nataxnūu Jesuu ña é na nūꞌu ña nú viꞌi ña kān: —Kūnúꞌun ntaan tsin; ñá ku kuīta ntíꞌxin má ñūú san. Ñá kū xoo kaꞌan niꞌin —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kidáā ne, kuéꞌen Jēsuu ni ña ntɨníꞌi ña ñūú kuetsī é ntoo ñuú Cesarea Filipu. Dá kuēꞌen ñá itsi kān né, tsixeꞌe Jēsuu ña: —¿Nté ntū ó ntákaꞌan ñáꞌa san iñá ko? ¿Xoó ntu ñaꞌa ú, te kuīní ñaꞌa san? —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ña ntɨniꞌi ñā ne, ntákaꞌan ña: —Iō ñá ne, Juaan Bautista nto, kaꞌan ña. Iō ñá ne, Elia nto, kaꞌan ña. Īo túku ña ne, ña é kaꞌán naa Xuva ko nto, kaꞌan ña —kaꞌan ñá ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Ntōꞌó ni, ¿xoó ntu ñaꞌa ú, te kuinī nto? —kaꞌan ña. —Ntōꞌo é Cristu ntó, ña táxnuu Xuva kō —kaꞌán Pedru. ");
INSERT INTO mizNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kidáā ne, kakaꞌan Jésuu ni ña é ña ku kaꞌán ña ni ñāꞌa san xoó ñaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kidáā né, eni ntuꞌu Jēsuu nañéꞌē ñá ña ntɨniꞌi ñā tsí dɨvi ñā é vēxkúvi ña ñatīí ne, da miī e dóo kiꞌin nuū i é ntōꞌo ña. Tsí ñatā sán, ni dūtu ñá odo nūú, nī mastrú leí san ne, un ntɨɨ́ ntɨɨ̄ ñá ña xkuntée iní ña ña ne, kaꞌní ña ña, ntá tsi tē kúvi uni ntúvi ne, ntoto xtuku ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kakaꞌan ntáa ña nuu i sáꞌa ni ña ntɨniꞌi ñā. Pedrú ne, kueꞌen níꞌi ña Jēsuu mí xoxo ntáñɨ̄ í ne, eni ntuꞌu ñā de tíi ña ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ntá tsi Jesuú ne, xkokōto ña mi ntâñɨ́ ña ntɨniꞌi ña, ña nguiī sán ne, dē tíi ña nī Pedru, kákaꞌan ña: —¡Duꞌxēn! ¡Kiin nteén xion! tsí túꞌūn é kākaꞌan ní ko ne, xuꞌu tóꞌō e ña váꞌā san kakéne. Ñá te kadē kuení o vatā ó kade kuení Xuva kō, tsí kadē kuení o vatā ó ntáde kuení ñaꞌa san —kaꞌan Jésuu ní Pedru. ");
INSERT INTO mizNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kidáā né, kāna Jesuu ña ntɨníꞌi ña ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, kakaꞌan ñá ni ñā: —Tē xoó ñaꞌa ntio ña é kuntīkɨn ñá ko ne, ña kúvi vīí ka ña nee iña é ntio mii ña, tsí utén uten é kuntīkɨn ñá ko, kuān te kuví ña. ");
INSERT INTO mizNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tsí tē xoó ñaꞌa ncho nakakū ñá ntuvi iña ñá ne, da nākunaá ña ntuvi iña ña. Ntá tsi xoó ñaꞌa é nākunaá ña ntuvi iña ña kuenta iñá ko ni kuēnta iña túꞌūn vaꞌá iña Xuva kó ne, nakáku ña ne, níꞌi ña ntuvi vāꞌá iña ña ntaꞌa Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Míꞌi ntū kaidiáꞌvi é nīꞌi ko é un ntɨꞌɨ̄ é īó ñuxiví sa, te nākunaá o nima ko? ");
INSERT INTO mizNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Nee iñá ntu e dóo nuu áꞌvi i é nadama o ntūvi iña ko? ");
INSERT INTO mizNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tē xoó ñaꞌa kukaꞌan nuu ña kuenta iñá ko nī kuenta iña túꞌūn ko méꞌñū ña ntoo ñuxiví sa, ña é ña ntákuintiꞌxe i, ña kini ntáa sán ne, xuꞌu é vēxkúvi ú ñatīí ne, kukaꞌan nuú ko ñá dɨ tē naínu u. Tē naínú u ne, nainu niꞌí u ánjē, ña e dóo vaꞌa. Kidáā ne, kiní nto tsi dóo kaꞌnu ú, vatā ó kaꞌnu uva miī kó, ña tuví e dukún kān —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesuú ne, kakaꞌan xtúku ña: —Nuu é ntaā i é kākaꞌán u ni ntō tsí iō ntó ne, ña kúvī ntó da nté kinī nto tsí Xuva kō né, dōó iō ña é viī ña é kadā kúꞌvē ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Dā ita ntíꞌxin iñu ntúvi ne, Jesuú ne, kueꞌen níꞌi ñā Pedru, Sántiau ní Juaán san, kuéꞌen ña ūun xuku mi dóo dūkun, mí xoxó ñaꞌa. Ikān né, nādama kúñu Jēsuu núu ntuni ñáꞌa, ñá ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Īñɨ ntúꞌu kāxiꞌí nuu doo ña. Ntukuiꞌxīn kueꞌen, e nté uun ñaꞌa ña kuvi nakáte ña vatā ó kuīꞌxin. ");
INSERT INTO mizNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kidáā né, ntīi dîtó Elia ni Muísee, ña xiꞌí nte kídaā, ne, ntatíin ña ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kidáā ne, kakaꞌán Pedrú san: —Mastru, ¡ñá tē nté kaa váꞌā o é ntoo ntɨ́ ni ntō iꞌa! Xntāñɨ́ ntɨ uni viꞌi xóꞌo vē: uun iña nto, uun iña Muíseé, ni ūun iña Élia —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dotō tsí kakaꞌan ñá, tsi dóo uꞌvī ñá, ntuni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kidáā ne, nákunūu taꞌán ña vikó san ne, méꞌñū vikó san véꞌxi tatsín san é kākaꞌan: —Ña sāꞌa é Iꞌxá miī ko e dóo kakuinimá ko ña. Kīni nto é kāꞌan ña —kaꞌan tátsín san. ");
INSERT INTO mizNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ña ntɨniꞌi Jēsuú san ne, ura í da xkókōto ña ne, ntoko ñuꞌu mii ntuvi ñáꞌa san. Da miī sá Jesuu ntítsi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dā ntáka ña rkɨ ukú san ne, kakaꞌan Jésuu ni ña: —Ñá kū dɨ́ ntaa nto ni ñāꞌa san nuu i é ini nto vevii da nte rkontûví tē xiꞌí u ne, ntoto xtuku ú, xuꞌu é vēxkúvi ú ñatīi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dukuān ne, ñá ni kāꞌan ñá ni ñāꞌa san, ntá tsi tsixeꞌe taꞌan mii ñā, ntákaꞌan ña: —¿Nté kui kuān ó kakaꞌan ntú ña é kuvī ñá ne, dá ntōto xtuku ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kidáā né, tsixeꞌe ña Jēsuu: —¿Nté kui ntákaꞌan ntú mastrú leí san é kuētsi é dīꞌna Eliá san naxee ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesuú ne, kakaꞌan ña: —Nuu é ntāa ntíꞌxe i é dīꞌna Eliá san kiꞌxi ña vata koo é nātɨvi iní ñaꞌa san kuétsi ñā, nakuntíkɨ̄n ñá Xuva kō. Ini nto tsí nte ntúvi diꞌna uve naꞌa Túꞌun Xuva ko īñá ko, xuꞌu é vēxkúvi ú ñatīi. Uve naꞌa nté koo ntoꞌo ko ñuxiví a ne, dōó kada xení ñaꞌa san ní ko. ");
INSERT INTO mizNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ntá tsi kakaꞌán u ni ntō tsí e kíꞌxi ntiꞌxe Eliá san. Īde ñaꞌa san ni ña nee iña é ntio ña, vatā ó uve naꞌa kakaꞌan túꞌun Xuva kō nté koo kuvi ni ñā. Kuan ō kúvi ntiꞌxe —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Dā ntíko koō ña mí ntoo ña ntɨniꞌi ña, ña nguiī sán ne, īní ña tsí ña te da díi ñaꞌa nátaká nuu ña ni ñā. Ikān ntâñɨ́ mastrú leí san dɨ, ntatíin nuu ña ni ña ntɨniꞌi Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, da íni ña Jesuú ne, koó dā kúduꞌva ña. Koó dā ntaínu ña kueꞌen ña, kukaꞌan ñá ni ñā ntiusi. ");
INSERT INTO mizNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kidáā né, tsixeꞌe Jēsuu ña: —¿Nee iñá ntu ntatíin nuu nto ni ña tsīkan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Uun ñaꞌa, ña nuu taꞌan méꞌñū ñaꞌa sán ne, kakaꞌan ña: —Mastru, iꞌa vexníꞌi ú iꞌxá ko, tsí e ña váꞌā san káde i é ñɨꞌɨ̄. ");
INSERT INTO mizNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Da míꞌī ká kaika iꞌxá ko ne, e ña váꞌā san katɨ́ɨn i, da kaxéꞌe ntēe í ñuꞌu kān. Kakēne tiñú xuꞌu i. Kanakuiō ne, kanakaꞌxí kaꞌñɨ̄ núꞌu ī dɨ. É dōo kúkāꞌvi. É kākaꞌán u ni ña ntɨniꞌi ntō é na nakūnu ña é ña váꞌā san, ntá tsi ña ni kuvi vií ña —kaꞌan úva īꞌxá san. ");
INSERT INTO mizNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kidáā ne, kakaꞌan Jésuu: —¡Ña ntâꞌví nto, ñaꞌa é ña ntákuintiꞌxe nto! É tɨ̄tɨ́n ntuvi tuví u ni ntō ne, váta kuintīꞌxe nto ko. ¿Tɨtɨ̄n ntú ntuvi kutuví ka ú ni ntō da nté kuīntiꞌxe nto ko? Kixniꞌi nto īꞌxá san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kidáā ne, xee níꞌi ntīꞌxe ña iꞌxá san. Dā íni e ña váꞌā san Jesuú ne, īde é xiꞌi míi iꞌxá san ne, ntáva ñuꞌu kān. Dōó itsuꞌūn ne, tiñu kéne xuꞌu i. ");
INSERT INTO mizNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kidáā né, tsixeꞌe Jēsuu úva ī: —¿Ē tɨ́tɨn ntu ntuvi kuán ó kakuvi iꞌxá nto? —kaꞌan Jésuu. Kakaꞌan úva īꞌxá san: —Nté dā ku lúꞌntī. ");
INSERT INTO mizNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","É dōó kiꞌin itō nakóꞌxo nuu é ña váꞌā san i nchúꞌun kān, nú ntute kān dɨ, é ncho kaꞌní iꞌxá ko. Ntá tsi te kūvi vií nto é ntūváꞌa ne, vií nto da xeꞌé, xntii ntō ntɨ —kaꞌan úva ī. ");
INSERT INTO mizNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—¡Míꞌi ntū é ña kuvi vií u! tsí te kākuintiꞌxe o ne, ña túvī nee iña é ña kuvi vií Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kidáā ne, un ntii tsi kākaꞌan úva īꞌxá san: —¡Kakuintiꞌxe ko! ¡Xntii ntō ko é dií ka na kuīntiꞌxe ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dā íni Jesuu tsi dóo ntánataká nuu ñaꞌa sán ne, de tíi ña nī é ña váꞌā san, kakaꞌan ña: —Xōꞌon, é ña váꞌā é kaden é ñɨꞌɨ īꞌxá sa nī é loꞌō dɨ́, xuꞌu é kadē kûꞌvé u ne, káꞌān u é ntīin nima íꞌxá san. Ña kúvi nakunúun xtukun nima i —kaꞌan Jésuu ni é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","E ña váꞌā sán ne, kachuꞌu ntáa. Nākuio iꞌxá san ne, dā ntíi e ña váꞌā san. Iꞌxá san ne, vata kaa ntɨ́xɨ kāa. Ñaꞌa sán ne, ntákaꞌan ña: —¡E xíꞌi īꞌxá san! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ntá tsi Jesuú ne, írkāa ña ntaꞌa i, ntániꞌi ña i ne, da nakuntítsi. ");
INSERT INTO mizNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dá kūkɨ́ꞌvi Jesuu má viꞌi kān ne, diin diin tsi tsixeꞌe ña ntɨniꞌi ña ñā: —¿Nté kui ña ni kuvi vií ntu ntɨ é nakūnu ntɨ é ña váꞌā san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kakaꞌan Jésuu: —E ña váꞌā é kuān ntáa sán ne, ña kúvi vīi o é nakūnu o í tē ña káꞌan ntaꞌví ō, tē ña kuntoó ixu ō dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kidáā né, ntāka Jesuu íkān, kueꞌen níꞌi ña ña ntɨniꞌi ñā. Kuéꞌen ñā, ítā ntiꞌxin ña ñuú Galilea. Ña ni ntío Jesuu é kūtuni ñaꞌa san mí ntaíka ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tsí Jesuú ne, kaxéꞌe ña kuenta é kūtuni ñá ntɨniꞌi ñā nté koo kuví ña: —Xuꞌu é vēxkúvi ú ñatīí ne, ntuví u kuenta ntáꞌa ñaꞌa, ña é kāꞌní ko. Ntá tsi tē kúvi uni ntúvi xiꞌí u ne, ntoto xtuku u —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ntá tsi ña ntɨniꞌi ñā ne, ñá nī ñeꞌe dɨkɨ ña nee iña é kākaꞌan ñá, ne, úꞌvī ña é tsixeꞌe ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xée ñā ñuú Capernau. Dā intóo ña má viꞌi kān né, katsixeꞌe Jēsuu ña ntɨníꞌi ñā: —¿Nee iñá ntu ntatíin nto dá vēꞌxi o itsi kan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ña ntɨniꞌi ñā ne, diin diin tsi intóo ña; nté uun ña ña ni káꞌan ñā. Tsi dá vēꞌxí ña itsi kān ne, ntatíin mii ñā xoo é dií ka kaꞌnu ñaꞌa i. ");
INSERT INTO mizNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kidáā ne, katuví daꞌna Jēsuú ne, kāna ña uxuvi ñáꞌa, ña ntɨniꞌi ñā, kakaꞌan ñá ni ñā: —Te iō nto é ncho kodo nuū ntó ne, vií nto ña tuví ata i kān. Vií nto ña ntáde tsiñu iña un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kidáā né, kīꞌi Jesuu uun iꞌxá san ne, dā xntítsī ñá i méꞌñu ña ntɨniꞌi ñā. Kánīꞌi nteé ña iꞌxá san ne, kakaꞌan ñá ni ña ntɨniꞌi ñā: ");
INSERT INTO mizNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Xoo é kantuntāꞌví ini i iꞌxá vata kaa sáꞌa kuenta iñá ko ne, vata tsi te miī ú kantuntāꞌví ini ña kó, ni ñā táxnūu kó dɨ —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juaán san ne, kakaꞌan ña: —Mastru, iní ntɨ uun ñaꞌa, ña é kanakūnu é ña váꞌā san kuenta iña nto. Ntá tsi ña tsīkán ne, ñá te ntɨniꞌi ña kō. Dukuān ne, ñá ni xēꞌé ntɨ itsi é kuān koo vií ña —kaꞌán Juaan. ");
INSERT INTO mizNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ntá tsi nantiko koó Jesuu, kakáꞌan ña: —Ñá ku kāꞌnté nuu nto é kuān koo vií ña. Te kuēnta iñá ko kade ña nuu i e dóo kaꞌnu ne, ña kúvi kāꞌan kíni ña iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tē xoó ñaꞌa ña kainchuꞌvi ñá kō ne, kaduku ntée ña kō. ");
INSERT INTO mizNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nuu é ntaā i é kākaꞌán u ni ntō. Da xōó ka ñaꞌa, ña é kataꞌxi ntute é kōꞌo nto tsí ntántīkɨn ntó ko ne, níꞌi ñā é vāꞌá ntaꞌa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ʼDa xōó ka é kade i é vīi iꞌxa é kākuintiꞌxe i ko é kīni kaa ne, dií ka váꞌā o iña ñá te kunūꞌní nuu xuu dúkun ñā, dá nakuītá nuu ña ña nú ntute ñuꞌu kān. ");
INSERT INTO mizNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Te ntāꞌa nto kade i é viī nto é kīni kaa ne, dií ka váꞌā ó te kaꞌntē ntó ntaꞌa nto. Tsí dií ka váꞌā o é kɨ̄ꞌɨn ntó ntaꞌa Xuva kō é ūun tsi ntaꞌa nto, naa i é kɨ̄ꞌɨn nto dôꞌvi kán nī ntuvi ntáꞌa nto, tsí ikān kaiꞌxi ñúꞌū é ña kantáꞌva. ");
INSERT INTO mizNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ikān né, ñá kākukadin é ntaéꞌxi tɨntákū san; ntē ña kantáꞌva ñúꞌú san. ");
INSERT INTO mizNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te dɨ̄ꞌɨ́n nto kade i é viī nto é kīni kaa ne, dií ka váꞌā o é kaꞌntē ntó dɨ. Tsí dií ka váꞌā o é kɨ̄ꞌɨn ntó ntaꞌa Xuva kō é uꞌntu nto, naa i é kɨ̄ꞌɨn ntó nī ntuvi dɨ́ꞌɨn ntō dôꞌvi kan, mí ña kantáꞌva ñúꞌú san. ");
INSERT INTO mizNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ikān ne, ñá kākukadin é ntaéꞌxi tɨntákū san; ntē ña kantáꞌva ñúꞌú san. ");
INSERT INTO mizNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te ntuxnūú nto kade i ne, dií ka váꞌā o é tāva nto. Tsí dií ka váꞌā o é kɨ̄ꞌɨn ntó ntaꞌa Xuva kō é ūun tsi ntúxnūú nto, naa i é kɨ̄ꞌɨn nto dôꞌvi kán nī ntuvi ntúxnūú nto. ");
INSERT INTO mizNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ikān ne, ñá kākukadin é ntaéꞌxi tɨntákū san; ntē ña kantáꞌva ñúꞌú san. ");
INSERT INTO mizNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ʼVatā ó idiáꞌvi ñɨɨ́ san é ña tɨ́vi kúñū é kuēꞌe o doméni iña Xuva kó ne, kuān ó kaidiáꞌvi nuu i é ntoꞌo kō, vata koo é ña tɨ́vi nima kó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ñɨ́ɨ̄ sán ne, váꞌā. Ntá tsi tē ña véñɨɨ́ ka ne, ¿míꞌi ntū kaidiáꞌvi ká i? ¿Nté ntu koo ntuveñɨɨ xtúku? Vií nto vata kaa ñɨɨ váꞌa. Kuenta tsí vií nto é ña natɨví nto nima nto. Váꞌa koo kuntoo nto ni tāꞌan nto —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ntāka Jesuu ñuú Capernau, kuéꞌen ña dīñɨ ñuú Judeá dā nté xee ña xio diñɨ ntute Jordaán san. Ñá te da dīi ñaꞌá xee xtúku ña, nātaká nuu ña mí tuví ña ne, nakuáꞌa Jēsuu ña vatā xkoó ini ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kidáā ne, xée ētsin ña fariseú san dɨ é kōto nteé ña Jesuu. Tsixeꞌe ña ña tē ña xíi kaa é naxtuvī mii ñátīí san ñadɨꞌɨ̄ ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nantíko kōó Jesuu, kakáꞌan ña: —¿Nte ntū ó kakaꞌan Muísee é viī nto? —kaꞌan Jésuu. Kakaꞌan ñá fariseú san: ");
INSERT INTO mizNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Muiseé ne, tāꞌxi ña itsi é ntaváꞌa o tūtu iña ñadɨꞌɨ́ kō ne, dá kūvi ntii nteé xio taꞌan o ni ñadɨꞌɨ̄ ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ntá tsi Jesuú ne, kakaꞌan ña: —Un váꞌa tsi doꞌo ntō. Dukuān é xntéku kūꞌvé Muisee é viī nto. ");
INSERT INTO mizNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ntá tsi ntē dá de kûꞌvé Xuva ko ñūxiví sa ne, “de kúꞌvē ñá ñatīí ni ñadɨ̄ꞌɨ”. ");
INSERT INTO mizNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Dukuān ne, xtúvī mii ñátīí san uva ña ni dɨꞌɨ ñā vata koo é kuntoo ña ni ñadɨꞌɨ̄ ñá ne, ");
INSERT INTO mizNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","uun tsi kúñū kúvi ña ntuvi ña.” Sáꞌā ne, kani túꞌun é ñā té uvi ñaꞌá ka ña, tsí uun tsi kúñū kúvi ña ntuvi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dukuān né, nēe é teé taꞌan Xuva kō ne, ña kúvi nātsoo xio ñaꞌa san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dá ntōo ña nú viꞌi kān né, tsixeꞌe xtuku ña ntɨniꞌi ñā nuu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kakaꞌan Jésuu ni ña: —Xoó ñaꞌa é natsoo mii ña ñadɨꞌɨ̄ ña, dá nātántaꞌa xtuku ña ne, dōó kinī ó kade ña nuu ñadɨꞌɨ́ ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","O te ñadɨ̄ꞌɨ́ san naxtuvī mii ña xɨɨ ña, dá nātántaꞌa xtuku ña ni tuku ñatīí san ne, dɨvi ñā kade ña é kīni kaa nuu xɨɨ ña dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ñaꞌa sán ne, xee níꞌi ña iꞌxá kuetsī nuu Jésuu vata koo é tɨɨn ntaꞌa ña ī. Ntá tsi ña ntɨniꞌi Jēsuú ne, ntáde tíi ña nī ña xee niꞌi iꞌxá i san. ");
INSERT INTO mizNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ntá tsi dā kútuni Jésuú ne, dōó dutsi kuiní ña ni ña ntɨniꞌi ñā. Kakaꞌan ñá ni ñā: —Kuéꞌe ntō itsi é na kīꞌxi iꞌxá kuetsī san mí tuví u. Ñá ku kādɨ́ nuu nto itsi é kīꞌxi; tsí mí kadē kûꞌvé Xuva kō ne, kaduku ntée ña vata ntáa iꞌxá kuetsī san. ");
INSERT INTO mizNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nuu é ntaā i é kākaꞌán u ni ntō tsí te xōo ñáꞌa é ña kákuintiꞌxe ña vatā ó de uun iꞌxa luꞌntí ne, ñá kadūku ntée ña mí kadē kûꞌvé Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Īdo nteé Jesuu iꞌxá san xe un xé ūn, da tɨ́ɨn ntaꞌa ña ī e náxnuu viko ña i. ");
INSERT INTO mizNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dā nákaka Jesuu ítsi kān é kɨ̄ꞌɨn ñá ne, uun ñatīí ne, koó da kaxkaīnu ña xee ña, inchɨ́tɨ ña nūu Jésuu, tsíxeꞌe ña ñā: —Mastrû, ntoꞌó e dóo vaꞌá nto, ¿nté ntu koo vií u é nīꞌí ko ntuvi vāꞌa iñá ko ntii dañu ntūvi? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ntá tsi Jesuú ne, kakaꞌan ñá ni ñā: —¿Nté kui kakaꞌan ntun e dóo vaꞌá u? Tsí da mii tsi Xuva kō e dóo vaꞌá ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","É īnín lei e xtúvi Xuva kō é kākaꞌan: “Ñá kāꞌní o ñāꞌa; ñá viī o é kini kaa ni ñadɨ̄ꞌɨ; ñá kīꞌi dúꞌu ō; ñá dāꞌví o ñāꞌa dovete; ñá kanī ntaꞌví o ñāꞌa, ne, na kuiko ñuꞌu o uva ko ni dɨꞌɨ kō” —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ñatīí san ne, nantíko koō ñá, kakaꞌan ña: —Mastru, é un ntɨꞌɨ̄ lei tsíkan káde ntaa ú nte da ku lúꞌntī u —kaꞌan ña kuiká san. ");
INSERT INTO mizNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dā íto Jesuu ñá ne, dōó kuinima ñá ña. Kakaꞌan ña: —Uun sá nuu i é kākunaá ka: Kuēꞌén, kunadikon un ntɨꞌɨ̄ é kāduku ntée o ne, dá kuēꞌén diuꞌun i iña ña ntâꞌví san. Kidáā ne, niꞌi o nee iña é dokuika ntiꞌxé san e dukún kān. Dá kiꞌxin, kixntīkɨ́n ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ntá tsi dōo ntɨ́ꞌɨ iní ña é kuān ó kakaꞌan Jésuu. Dōó ntaꞌxa kunúꞌu ña, tsi dóo īo iña ña e dóo nuu áꞌvi. ");
INSERT INTO mizNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kidáā né, xkokōto Jesuu, kakáꞌan ñá ni ña ntɨniꞌi ñā: —¡Ñá tē nté kaa ntii tūꞌun é kɨ̄ꞌɨn ña kuiká san mí kadē kûꞌvé Xuva kō! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Koó dā kúduꞌva ña ntɨniꞌi ñā é kuān ó kakaꞌan ña. Ntá tsi kakaꞌan xtúku Jesuu: —Kini nto, īꞌxá ko, ¡ñá tē nté kaa ntii tūꞌun é kɨ̄ꞌɨn ñáꞌa, ña é kākuinima í diuꞌún san, mí kadē kûꞌvé Xuva kō! ");
INSERT INTO mizNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dií ka ña ntii tuꞌun é kɨ̄ꞌví kameú san xavi xɨ́kɨ natēe é kɨ̄ꞌɨn ñá kuiká san mí kadē kûꞌvé Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Koó dā kúdana iní ña ntɨniꞌi ñā é kuān ó kakaꞌan ña. Ntátsixeꞌe tāꞌan ña: —Kidáā né, ¿xoó ñaꞌa ntu kuvi vií ña é nākáku ña kuan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Īto Jesuu núu ñá ne, dá kakāꞌan ñá ni ñā: —Ñaꞌa sán ne, ña kúvi viī ña é nākáku mii ñā. Ntá tsi Xuva kō ne, kuvi vií ña, tsí ña tuví nee iña é ña kuvi vií ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kidáā ne, kakaꞌán Pedru ni ña: —Ntɨꞌɨ́ ne, tsoo mii ntɨ̄ꞌɨ ntɨ́ iñá ntɨ é vēxntíkɨ́n ntɨ nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nantíko kōó Jesuu, kakáꞌan ña: —Nuu é ntaā i é kākaꞌán u ni ntō: Tē xoó ñaꞌa tsoo mii ña vīꞌi ña, ení ña, taꞌan ña, uva ña, dɨꞌɨ ñā, iꞌxá ña, o ñūꞌu ña kuenta iñá ko ni kuēnta iña túꞌūn vaꞌá san ne, ");
INSERT INTO mizNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dií dií ka kueꞌe níꞌi ña ñuxiví a é vata kaa viꞌi ñá, ení ña, taꞌan ña, dɨꞌɨ ñā, iꞌxá ña, ni ñūꞌu ña. Ntá tsi dóo ntoꞌo ña dɨ, tsí kada xení ñaꞌa san ni ñā. Ntá tsi tē ntɨ́ꞌɨ ñuxiví sa ne, níꞌi ñā é kuntoo ña ni Xuva ko ntii dañu ntūvi. ");
INSERT INTO mizNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ntá tsi ña te da díi ñaꞌa, ña e dóo naꞌnu ñaꞌa vevií ne, ñá vādá nuu áꞌvi ká ña kídaā; ñaꞌa, ña é ña vádā nuu áꞌvi vevií ne, dōó naꞌnu ñaꞌa kuvi ña rkontûvi —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kuéꞌen ña itsi kan, kūntáa ña ñuú Jerusaleen. Odo nūú Jesuú ne, áta ña vēꞌxí ña ntɨniꞌi ñā. Koó dā ntákuduꞌva ña ntɨniꞌi ñā san. Dōo ûꞌví ña nguiī san, ña ntántīkɨn ña. Kidáā ne, xio kueꞌen níꞌi xtuku Jésuu ña ntɨníꞌi ñā né, dā éni ntuꞌu ña kākaꞌan ñá ni ñā nté koo ntoꞌo ña: ");
INSERT INTO mizNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Ntaa o ñūú Jerusaleén ne, xuꞌu é vēxkúvi ú ñatīí ne, ikan ntāda ña kó kuenta ntáꞌa dutu ñá odo nūú nī mastrú leí san ne, dɨvi ña kāꞌan ña é kūví u. Ntada ña kó kuenta ntáꞌa ñaꞌa, ña é ña te ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ña tsīkán ne, kini dɨkɨ́ ña kó ne, tɨꞌvi dɨɨ́ ña nuú ko. Kani diín ña ko, dá kāꞌní kueꞌen ñá ko. Kidáā né, tē kúvi uni ntúvi ne, ntoto xtuku u —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kidáā ne, xée ētsin Santiau ní Juaan, iꞌxá Zebedeu, ntákaꞌan ñá ni Jēsuu: —Mastru, vií nto da xeꞌe, tāꞌxi nto nee iña é kākán ntɨ ntaꞌa nto ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Nee iñá ntu ntio nto é tāꞌxi u? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Tāꞌxi nto é kuntōo ntɨ́ diñɨ nto tē xee nto mí kadā kúꞌvē nto. Uun ñaꞌā ntɨ́ ne, diñɨ kuaꞌa nto kutuví ntɨ; uun ñaꞌā ntɨ́ ne, diñɨ datsin nto kutuví ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ntá tsi kakaꞌan Jésuu ni ña: —Ñá īni ntó nee iña é ntaíkan nto. ¿Kūtií ntu nto é dadɨɨ ntoꞌo nto nī kó un ntɨɨ́ ntɨ̄ɨ́ nuu i é ntōꞌo ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Kutíi ntɨ, ¿nté kui ñaꞌa? —kaꞌan Sántiau ní Juaan. Kakaꞌan Jésuu ni ña: —Ntoꞌo ntiꞌxe nto vata tsi koo ntoꞌo ko. ");
INSERT INTO mizNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ntá tsi é kuntōo nto diñɨ kuaꞌa ko o diñɨ datsin kó ne, ña kúvi tāꞌxi u, tsí mii Uva ko īni ña xoo é kuntōo i diñɨ ko —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dā téku ña uꞌxi ñáꞌa ká san ne, dōo kúdiin ña ni Sāntiau ní Juaan. ");
INSERT INTO mizNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kidáā né, kāna Jesuu ñá uxuvi ñáꞌa san, kakaꞌan ñá ni ñā: —Ini nto tsí ñaꞌa, ña odo nūu iña ñaꞌa, ña é ña te ña Israeé ne, dōo ntáde kaꞌnu ña kúñu ñā. Ña tsiñu i sán ne, dōó ntii ntádē kúꞌvē ña iña ñaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ntá tsi dɨvi ntō ne, ñá te kuan koo viī nto. Tē xoó ñaꞌa ncho vií kaꞌnu ña ne, kantio é xntii ña ntō un ntɨɨ́ ntɨɨ̄ nto. ");
INSERT INTO mizNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Xoó ñaꞌa, ña ncho kodo nūu iña ntó ne, kantio é viī ñá vata kaa ña ntáde tsiñu iña ñá nguiī san. ");
INSERT INTO mizNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nté xūꞌu é vēxkúvi ú ñatīí ne, ñá te vēꞌxí u ñuxiví a é vīí kaꞌnu u, tsí véꞌxi ú vata koo é xntīi ú ñaꞌa san. Xuꞌú ne, véꞌxi u e ntáꞌvi u kuétsi ī é ña te da díi ñaꞌa san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kidáā ne, xée ña ñūu é nani Jerīcoo. Ntāka xtuku Jesuu ni ña ntɨníꞌi ñā ne, ñá te da dīi ñaꞌa ntántīkɨn ñá ña. Diñɨ itsi mí kuēꞌen ñá ne, tuví uun ña kuāá, kaikan ña diuꞌun. Bartimeu nani ña, tsí uva ñā ne, Timeu nani ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Dā kútuni ña tsi véꞌxi Jesuu, ña ñuú Nazareé san ne, dōó ntii kākaꞌan ña: —¡Ō Jésuu, Iꞌxá Davii, ntuntāꞌví ini nto ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ñaꞌa sán ne, dē tíi ña ni ñā: —¡Duꞌxēn! ¡Ñá ku kuān xkoó kaꞌan! —kaꞌan ña. Ntá tsi ña kuāá san ne, da dií dií ka ntii kākaꞌan ña: —¡O Iꞌxá Davii, ntuntāꞌví ini nto ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Íntītsí Jesuu, kakáꞌan ña: —Kana nto ña —kaꞌan ña. Kana ña ña kuāá san ne, ntákaꞌan ñá ni ñā: —Nāxnuu kaꞌnu nto iní nto. Nakuntítsi nto, tsí kakana ña nto —kaꞌan ñáꞌa san nī á ña kuāá san. ");
INSERT INTO mizNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kidáā né, xtuvī mii ña kútuun ñá ne, nákuntītsí ntaa ña, kueꞌen ña mí ntitsí Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Dā tsíxeꞌe Jēsuu ña: —¿Nee iñá ntu ntio o é vīí u iña o? —kaꞌan ña. —Mastrû, ntio ko é nāxiꞌi ntúxnūú ko —kaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesuú ne, kakaꞌan ñá ni ñā: —Kūnúꞌun ve. Tsí e kuíntiꞌxe o kó ne, ntuváꞌan ve —kaꞌan Jésuu. Ura dúꞌva tsi i náxiꞌí ntuxnūu ñá kuāá san ne, dá kuēꞌen ñá, kuntikɨ̄n ñá Jesuu mí kuēꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Xée ētsin ña ñuú Jerusaleen, mí ntoo ñuú Befagee ni ñuú Betania má xūku é nani Ōlivu. Jesuú ne, taxnūu ña uvi ñaꞌa ñá ntɨniꞌi ñā, ");
INSERT INTO mizNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kakaꞌan ñá ni ñā: —Kueꞌēn ntó ñuú luꞌnti é tuví daꞌa san. Ura tsí i te kūkɨ́ꞌvi nto ikān ne, naniꞌi nto uun a búru kɨtɨ ntee tɨ́ɨn é ntē vata xoó kunteku í tɨ. Nantuté nto tɨ ne, kixníꞌi nto tɨ īꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tē xoó ñaꞌa tsixeꞌe ña ntō é kuān ó de nto ne, káꞌan ntō tsi Tóꞌo ko kāntio ña tɨ; vevií nantiko koō ñá tɨ, koo kaꞌan ntó ni ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kuéꞌen ñā né, nāniꞌi ña uun a búru san, ntee tɨ́ɨn tɨ atá viꞌi é tuví itsi kān. ");
INSERT INTO mizNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ña ntâñɨ́ ikān ne, ntátsixeꞌe ñā: —¿Nté koo vií nto burú san é kānantuté nto tɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nantíko koō ñá, kakaꞌan ñá vatā ó kakaꞌan Jésuu ni ñá ne, xéꞌe ñāꞌa san itsi é kɨ̄ꞌɨn niꞌi ña búrú san. ");
INSERT INTO mizNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nāxee niꞌi ña búrú san mí kāntétu Jesuu. Xntekū ñá kutuun ña áta tɨ́ ne, dā kantéku Jesuu tɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ñá te da dīi ñaꞌá san tsóo ña kutuun ñá itsi kān dɨ. Iō ñá ne, kātsin ña nta utun má kūꞌu kán ne, tsoo ña itsi kān. ");
INSERT INTO mizNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ñá tē nté kaa ñaꞌa odo nuū ñá nuu Jésuú ne, ñá te da dīi ña véꞌxi ata ñá dɨ. Un ntɨɨ́ ntɨɨ̄ ña koó dā vantiñɨ ña ntákaꞌan ña: —¡Dōó kaꞌnu Xuva kō! ¡Ñá tē nté kaa váꞌā o iña ñá véꞌxi ntaꞌa Xuva kō! ");
INSERT INTO mizNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Na naxnuu viko Xuva kō ña vexkádā kûꞌvé iña ko, é viī ñá Rei naa úvata ko Dāvii! ¡Dōó kaꞌnu Xuva kō, ña tuví e dukún kān! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Xée Jēsuu ñuú Jerusaleén ne, dá kūkɨ́ꞌvi ña ini ukún kaꞌnu san. Ito ña un ntɨꞌɨ̄ é īó iní i kān. Dā kuáā né, ntīi ña, kueꞌen ña ñuú Betania ni ña uxuvi ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tévāá tsi ntáka ña ñuú Betaniá ne, kakakɨn Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Īni ika ña tsí ntitsi uun tun ígū é ūve xuku i. Kūkóto ntōdó ña tē ntaꞌá kɨtɨ i. Ntá tsi dā xee ñá ne, da mii xūku í uve, tsí vata xee ntúvī é kīi kɨtɨ i. ");
INSERT INTO mizNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kidáā né, kakaꞌan Jésuu ni tun ígū san: —Nté uun ito ña koó ka kɨtɨ o é kāꞌxí ñaꞌa san —kaꞌan ñá ni ūtun san. Tēkú ña ntɨniꞌi ñā é kuān ó kakaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nāxee xtúku ña ñuú Jerusaleén ne, kuéꞌen Jēsuu má ūkún kaꞌnu san. Ikān éni ntuꞌu ñā nakunu ña ña ntádiko ni ñā ntáñii ini ukún san. Nantáva ña mesa mí ntoo ña ntánadama diuꞌún san ne, nantáva ña sia mí ntoo ña ntádiko palomá san. ");
INSERT INTO mizNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ñá ni xēꞌé ña itsi é kuīta ntíꞌxin ñaꞌa san má ūkún san tē nee iñá odo ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dá kanakuāꞌa ña ñaꞌa, ña ntoo ini ukún san ne, kakaꞌan ñá ni ñā: —¿Ñā ntu te uve náꞌa nte díꞌna é kākaꞌan Xúva kō: “Tsí viꞌi kó ne, viꞌi mí kaꞌan ntâꞌví ñaꞌa, ña dā míꞌī ká ñuu i”, kaꞌan ña? Ntá tsi ntōꞌó ne, viꞌi ña dūꞌu káde nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dā téku dutu ñá odo nūú nī mastrú leí san ne, kidáā né, ntukū nuu iní ña nté koo kaꞌní ña Jesuu. Tsí ntaúꞌvī ñá Jesuu, tsí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, ncho kini ká ña túꞌūn é kanakuāꞌa Jesuu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ntá tsi dā kuáa ne, Jesuu ni ña ntɨníꞌi ñā né, ntāka ña ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Utén san ne, dā ntíko kōo xtúku ña ni ña ntɨniꞌi ñā ne, ítā ntiꞌxin ña mí ntitsi tun ígū san. Īní ña tsí xiꞌi dií kueꞌen, un tsi nte dítsin i. ");
INSERT INTO mizNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kidáā ne, nánūꞌú Pedrú san iní ña é kākaꞌan Jésuú ne, kakaꞌan ña: —Un kaa, Mastru. Dɨvī tun ígū san é kāꞌan ntée nto i ne, e xiꞌi dîi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kakaꞌan Jésuu ni ña: —Kuintiꞌxe nto Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nuu é ntaā i é kākaꞌán u ni nto: tē xoó kaꞌan í ni xūku sáꞌā: “Kuēꞌen dáꞌan vé, na kōꞌxón nuun méꞌñu ntute ñuꞌu kān”, né, te kanɨɨ̄ nima ñá kakuintiꞌxe ña é kuān koo kuvi ne, kuān koo kuvi ntiꞌxe. ");
INSERT INTO mizNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Dukuān ne, kakaꞌán u ni ntō: nee iña é kākan ntó ntaꞌa Xuva kō da ntákaꞌan ntâꞌví nto ne, kuintiꞌxe nto tsí niꞌi ntó ne, níꞌi ntīꞌxe nto. ");
INSERT INTO mizNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Dā ntákaꞌan ntâꞌví nto ne, te īó xoo é kanāa núu niꞌi ntō ne, kada kaꞌnu iní nto ni ñā vata koo é Xuva kō, ñá tuví e dukún kān, kada kaꞌnu iní ña ni nto kuētsí nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tsí tē ña kada kaꞌnú ini nto ni tāꞌan nto kuétsi ñā ne, nté Xuva kō, ña tuví e dukún kān, ña kada kaꞌnú ini ña ni nto kuētsí nto dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kidáā né, nāxee xtúku ña ñuú Jerusaleen. Kaika Jesuu ini ukún kaꞌnu kān né, ikan tsī xee dútu ñá odo nūú nī mastrú leí ni ñatā sán ne, ");
INSERT INTO mizNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ntátsixeꞌe ña Jēsuu: —¿Xoó ntu kakaꞌan i é kuān koo vií nto? ¿Xoó ntu táꞌxi i itsi é kuān koo vii nto nuu i sáꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nantíko kōó Jesuu, kakáꞌan ña: —Xuꞌú ne, ntio kó tsixeꞌē ú nto dɨ. Te kūvi kaꞌan nto é tsixeꞌē ú nto ne, dá kāꞌán u xoo táꞌxi i itsi é kade u. ");
INSERT INTO mizNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Xoó ntu xeꞌé i itsi Juaán san é nakūtsi ntute ña ñaꞌa san? ¿O Xuva kō né, o kūdii ñaꞌa ntú san xeꞌé ña? Káꞌan nto vē —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kidáā ne, ntatíin nuu mii ñā: —Te kāꞌan o tsí Xuva kō xeꞌé ña ña itsi ne, káꞌan ñā: “¿Nté kui ña ni kuintíꞌxe nto ña kuan?” koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Nté koo kuvi te kāꞌan o tsí ñaꞌa san xeꞌé ña ña itsi? —kaꞌan ña. Tsi ntaúꞌvī ñá ñaꞌa san, tsí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntákuintiꞌxe ña tsí ntaꞌa Xuva kō niꞌi ntíꞌxe Juaán san é kūvi vií ña. ");
INSERT INTO mizNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Dukuān ne, nantíko koō ñá, ntákaꞌan ña: —Ñá īní ntɨ —kaꞌan ña. Kidáā ne, kakaꞌan Jésuu: —Xuꞌú ne, ntē ñá kaꞌán u dɨ xoo táꞌxi i itsi é kuān ó kade u —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kidáā né, eni ntuꞌu Jēsuu ntáa ña nuu i é nañéꞌē ñá ñaꞌa san: —Uun ñatīí ne, íꞌxi ña xoꞌo tɨntiꞌō. Ēdɨ́ nuu ña xákū ntíkō diñɨ i. Uvi ítsī éte nuu ña nú xuu kaꞌnu san mí kādin núu ña tɨntiꞌō sán ne, dā xntítsi tsíñu ña uun viꞌi dūkun mí kunūu ña é vīí kuenta xóꞌo tɨntiꞌō san. ʼKidáā ne, xéꞌe ña ñāꞌa san é na kūntoo taan ña é viī ña kuenta xóꞌo tɨntiꞌō sán ne, dā kíi ña, kueꞌen ñá xio ñuu e dóo ikā. ");
INSERT INTO mizNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Xée ntūvi é tɨ̄ɨn ña tɨntiꞌó san. Tōꞌó i ne, taxnūu ña uun ñaꞌa ña ntáde tsiñu é nā kínakuīdó ña é kāduku ntée ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ntá tsi ña ntáde kuentá san ne, ña ni ntío ña nakuéꞌe ña é kāduku ntée tóꞌo ī. Ēꞌní diīn ñá ña táxnūu tóꞌo ī san. Nté uun kɨtɨ i ña ni xéꞌe ña é kunīꞌi ña é kūvi iña tóꞌo ñā; da mii ntāꞌa ña kunúꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kidáā né, taxnūu xtuku tóꞌo ī san uun ñáꞌa ka ña ntáde tsiñu san. Ntá tsi ña ntáde kuentá san ne, ntuku kuiꞌī ñá dɨkɨ ña táxnūu ña. Dōo dé xení ña ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tōꞌó i san ne, taxnūu xtuku ña uun ñaꞌa ká ña. Ntá tsi éꞌni kueꞌen ñá ña. Kidáā ne, ñá te da dīi ña ntáde tsiñu san táxnūu ká ña. Iō ñá ne, ēꞌní diīn ñá ña. Iō ñá ne, ēꞌní kueꞌen ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ʼKoó da ūun sá ña ntoo ña: dɨvi īꞌxá mii ñā e dóo kakuinima ña. Kidáā né, taxnūu ña iꞌxá ña. Kuiní ña tsí te kuiko ñūꞌu ñaꞌa san iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ntá tsi ña ntáde kuentá san ne, ntánatíin ña: “Ña sāꞌá ne, iꞌxa tóꞌo ī, ña é nākunteé ntaꞌa i tē xiꞌi ña. Kīkáꞌni o ñā ne, kidáā ne, kuvi iña ko un ntɨ́ꞌɨ̄ é īo iña ña”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tɨ̄ɨn ña ña, da éꞌni kueꞌen ñá ña, dā ínakuido káva ña ña ata xákū san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kidáā ne, katsixeꞌe Jēsuu: —¿Nté koo vii tóꞌo ī san ve? Mii ña kɨ̄ꞌɨn ñá ve, kaꞌní ntɨꞌɨ ña ña ntáde kuenta xóꞌo tɨntiꞌō san, dá nakuéꞌe ña tuku ñaꞌa, ña é vīí kuenta. ");
INSERT INTO mizNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ʼNtōꞌó ni, ¿vāta nakuaꞌa ntu nto Túꞌun Xuva kō? Tsí kakaꞌan: Xúū é nāntii níꞌni ña xntîtsí viꞌi sán ne, dɨvī é kūvi xuu núu i. ");
INSERT INTO mizNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sáꞌā dé kûꞌvé Xuva kō é kōo ne, ñá tē nté kaa váꞌā ó, kuiní ntɨ. Kuān ó uve naꞌa nte diꞌna Túꞌun Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ña tsiñu i sán ne, kūtuni ña tsí dɨvi kuēnta iña ñá é kāntáa ña nuu i sáꞌa. Ntukū nuu iní ña nté koo vií ña é tɨ̄ɨn ña Jesuu. Ntá tsi uꞌví ña ñaꞌa sán ne, xnuu mii ña Jēsuu, kuéꞌen ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kidáā ne, táxnūu ñaꞌa san ña fariseu ni ña ntántīkɨn rei Heródē san mí tuví Jesuu. Ncho vií ña vata koo é kāꞌan Jésuu nuu i e dóo xíi kaa, vata koo é nāniꞌi itsi ña nté koo dáꞌvi ña ña dovete. ");
INSERT INTO mizNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Xée ñā mí tuví Jesuú ne, ntákaꞌan ñá ni ñā: —Mastru, iní ntɨ tsí kakaꞌan nto é nuu é ntaā i. Iní ntɨ tsí dadɨɨ tsi kaiko ñuꞌu ntō un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, dadɨɨ tsi kade nto ni ña, kuān te ntaꞌví ña, kuān te kuika ña. Kanañēꞌe ntó ntɨ é nuu é ntaā í vata ō xtûví Xuva ko īñá ntɨ. ¿Vāꞌá ntu ō é ntáꞌvi ō diuꞌun xôó san ntaꞌa ña tsiñu i san, ō ñaꞌa, te kuiní nto? ¿Ntáꞌvi ntu ō né, ō ña ntáꞌvi ō? —kaꞌan ñá, tsixeꞌe ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesuú ne, kūtuni ña tsí da ntaéni dɨkɨ́ ña ña. Kakaꞌan ñá ni ñā: —¿Nté kui ntaíto nteé ntu nto ko? Tāꞌxi nto uun diuꞌun kuiꞌxín san, na kōto nteé u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Xéꞌe ña ñā ne, da tsíxeꞌe Jēsuu ña: —¿Xoó ntu dɨkɨ i é ntēé diuꞌun sáꞌa? ¿Xoó ntu dɨvī í e nteé naꞌa? —kaꞌan ña. —Dɨ́kɨ̄ Césa ni dɨvī ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kidáā ne, kakaꞌan Jésuu ni ña: —Váꞌa ō é nākuéꞌe o ntāꞌa ña tsiñu naꞌnu i nee iña é kāduku ntée ña ne, váꞌa ō é nākuéꞌe o ntaꞌa Xuva kō nee iña é kāduku ntée ña dɨ —kaꞌan ña. Koó dā kúduꞌva ñaꞌa san e dóo ini Jesuu nté koo nantiko koō ña é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Xéē ña saduceú san dɨ. Ña sāꞌá ne, ñá tē ntákuintiꞌxe ña tē ntántoto ña xiꞌí san. Da ntaéni dɨkɨ́ ña Jesuu, ntákaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Mastrû, uve naꞌa mí kakāꞌan Muísee nté koo vií o tē xiꞌí ení kō. Tē xiꞌi ñá ne, ítuvī mii ñadɨꞌɨ́ ña ne, ña ni xīó iꞌxá ña ne, nātántaꞌa ení ña ni ñadɨ̄ꞌɨ kií san vata koo é na kōo iꞌxá ña iña ení ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Uun ito ne, xío ūꞌxe ení ña. Iꞌxá nuu í san ne, tāntaꞌa ña. Dā xiꞌi ñá ne, váta kōó iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ení ña, ña é kuvi ūví san ne, tantaꞌa ña ni ñadɨ̄ꞌɨ kií san. Dā xiꞌi ñá dɨ ne, váta kōó iꞌxá ña. Ení ña, ña é kuvi ūní san ne, kuan tsi ō kúvi ni ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kidáā ne, é un é un ña tántaꞌa ña ni ñadɨ̄ꞌɨ́ san. Dā kúvi ne, xíꞌi ña ntɨꞌɨ ūꞌxe ñáꞌa ña ne, nté uun iꞌxá ña ña ni xío. Kidáā ne, xíꞌi ñadɨ̄ꞌɨ kií san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tē ntóto ña xiꞌí san ne, ¿xoó ntu ñadɨ̄ꞌɨ́ i kuvi ña? Tsí un ntɨꞌɨ̄ ña uꞌxe ñáꞌa san e tántaꞌa ña ni ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dá kakāꞌan Jésuu ni ña: —Ñá vāꞌá ō e ntádē kuení nto, tsi ñá ini nto nté o uve naꞌa Túꞌun Xuva kō ne, ñá īni nto tsi dóo īo é vīí Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Dá ntōto ña xiꞌí san ne, ñá nātántaꞌa ká ñatīí san. Ña xoxó ka é kuēꞌé i itsi é tantaꞌa ñadɨ̄ꞌɨ́ san dɨ. Tsí kuntoo ña vatā ó ntántoo ánjē san e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kuenta iña i e ntóto ña xiꞌí san ne, ¿vāta nakuaꞌa ntu nto tutu e xtûví Muiseé san, mí uve naꞌa iña xuku é kaiꞌxi? Ikan kākaꞌan Xúva ko ni Muīsee: “Xuꞌú ne, Xuva uvata ika nto Ābraan ni Ísaa ni Jácoo”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Xuva kō ne, ñá te Xuvā ñá xiꞌí san, tsí Xuvā ñá ntantíto san. Dukuān né, kūdii dovete ntákuintiꞌxe nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Xée ūun mastrú leí ne, tēkú ña é kākaꞌan Jésuu ni ñá saduceú san. Īní ña tsi dóo váꞌā ó kakaꞌan Jésuu é kanantiko koō ña. Tsixeꞌē mastrú leí san dɨ: —¿Neé ntu túꞌūn e táꞌxi Xuva kō é dií ka kaꞌnu é kāda ntaa o? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nantíko kōó Jesuu, kakáꞌan ña: —É kuvi ūun sán ne: “Kiní nto, ña Israee: uun tsi Xuva kō e dóo kaꞌnu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kuinima ntó Xuva ko kanɨɨ̄ nima ntó, kanɨɨ̄ é tduiña nto, kanɨɨ ūꞌxen dɨkɨ nto. Nɨɨ̄ kuéꞌen ini nto kunuu inī ntó ña.” ");
INSERT INTO mizNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","É kuvi ūví san ne: “Kuinima ntó taꞌan nto vata tsī ó kakuinima ntó kúñu mii ntō.” Ña túvī ká xtuku é kadā kûꞌve é vata kaa sáꞌa —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kakaꞌán mastrú leí san: —Ntáa ntīꞌxe, Mastru. Nuu é ntaā i é kākaꞌan nto, tsi úun tsi Xuva kō. Xoxó ka xtúku Xuva kō, tsí mii tsi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na kuīnima kó ña kanɨɨ̄ nima kó, kanɨɨ ūꞌxen dɨkɨ ko, nɨɨ kuéꞌen ini kō ne, na kuīnima kó taꞌan ko vata tsī ó kakuinima kó kúñu mii kō. Tē kada ntaa o sáꞌā ne, dií ka kaidiáꞌvi é un ntɨɨ́ ntɨ̄ɨ́ doméni é kāꞌmi o nú nāa kan íña Xuva ko, o da nēé ka doméni é kuēꞌé o ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iní Jesuu tsi dóo váꞌā ó nantiko koó ña ne, kakaꞌan ñá ni ñā: —Ña íka tsi tūví nto mí kadē kûꞌvé Xuva kō —kaꞌan ña. Kidáā ne, nté uun xoxo ni tsixeꞌe ká i Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Dá kanakuāꞌa ká Jesuu ñaꞌa san má ūkún kaꞌnu kān né, kakaꞌan ñá ni ñā: —¿Nté kui ntákaꞌan ntu mastrú leí san tsí ña é taxnuu Xuva kō é kuvi ña Cristú ne, iꞌxa íka rei Dāvii ña? ");
INSERT INTO mizNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tsí nte díꞌna kakaꞌan Dávií san vata ō nañéꞌe Espíritū Sántū san ña: Kakaꞌan Xúva ko nī Tóꞌō ko: “Kutūvín diñɨ kuaꞌa ko da nté kūvi tsoo ú ña ntaínchuꞌvi ō nú xēꞌe o”, kaꞌan Xúva kō, kaꞌan Dávii. ");
INSERT INTO mizNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Nté ō ntu é Cristú san ne, iꞌxá ika Dāvii kúvi ña? Tsí mii Dāvií san kakaꞌan ñá tsi Tóꞌo ñā kúvi ña —kaꞌan Jésuu. Ñá te da dīi ñaꞌá san dóo xkúntee iní ña é kīni ña túꞌūn é kākaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesuú ne, dá kanakuāꞌa ña ñaꞌa sán ne, kakaꞌan ña: —Koto xnto mastrú lei, ñá e dóo naꞌnu ncho vií san. Dōó xkuntée iní ña duꞌnu nani da ntaíka ña itsi kān. Dōó ntio ña é kuiko ñuꞌu ñāꞌa san ña, é kāꞌan ñá ntiusi ní ña núu ñaꞌa san nu âꞌví kān. ");
INSERT INTO mizNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Má ūkún kān dɨ́ ne, dōó ntio ña é kuntōo ña nte nuu i kan. Tē xee ñá viko sán ne, dōó ntio ña é nīꞌi kuntoó ña míꞌī e dií ka váꞌā o. ");
INSERT INTO mizNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ntaéni ntáꞌvi ña ñadɨ̄ꞌɨ kií san vata koo é nakiꞌi ña un tsi nte víꞌi ña. Dōó naꞌa ntákaꞌan ntâꞌví ña, vata koo é kadā kuení ñaꞌa san tsi dóo vaꞌá ñaꞌa ña. Ntá tsi ña sāꞌá ne, dií ka kueꞌe níꞌi ña é ntoꞌo ña ntaꞌa Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tuví Jesuu má ūkún kān ne, tuví nteē ña etún diuꞌun mí ntátsuꞌun ñaꞌa san. Kaito ntee ña nté o de ñaꞌa san é ntátsuꞌun ña diuꞌun. Īni ña tsí ña kuiká san ne, ñá tē nté kaa diuꞌun ntáxeꞌé ña. ");
INSERT INTO mizNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kidáā ne, véꞌxi uun ñadɨ̄ꞌɨ kií san ne, xnūu ña uvi kúdii á diuꞌun kuetsí san e dóo xuvi nuu áꞌvi. ");
INSERT INTO mizNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kidáā né, kāna Jesuu ña ntɨníꞌi ñā ne, kakaꞌan ñá ni ñā: —Nuu é ntaā i é kākaꞌán u ni ntō: Tsí ñadɨ̄ꞌɨ kií sāꞌá ne, dií ka nuu áꞌvi é xēꞌé ña é ūn ntɨɨ́ ntɨ̄ɨ́ ña nguiī san e ntátsuꞌun ña diuꞌun ña ini etún san. ");
INSERT INTO mizNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tsí ña nguiī sán ne, dōó īó iña ñá ne, kūdii diuꞌun é kāntoo e ntáxeꞌé ña. Ntá tsi ñadɨ̄ꞌɨ kií san ne, kuān té ña te neé īó iña ñá ne, nɨɨ̄ kuéꞌen ini ña xeꞌé ña un ntɨꞌɨ̄ é īó iña ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dā ntáka Jesuu má ūkún kaꞌnu kān ne, kakaꞌan úun ña ntɨniꞌi ñā: —¡Un kaa dií xuú san, Mastru! ¡Ñá te da kūdii! ¡Xūkún san dɨ! ¡Ñá tē nté kaa váꞌā o! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kakaꞌan Jésuu: —Koto váꞌa nto xúkūn e dóo váꞌā ó san, é ña te da kúdii. Ntá tsi véꞌxī ntuvi é nantatsin kueꞌen. Nté uun ká xuu ña kodo ntiꞌi táꞌān ka kídaā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Dā itúvi Jesuu tɨ́ꞌɨ i é nani Ōlivú ne, dōo dîto tuví xúkūn san. Pedru, Sántiau, Juaan, ni Ándreé ne, xée ētsin ña nuu Jésuu, ntákaꞌan xuꞌú ña ni ña, tsixeꞌe ña ñā: ");
INSERT INTO mizNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Káꞌan nto vē amá kuān koo kuvi é kākaꞌan nto. ¿Neé ntu nuu i é tāꞌxi Xúva kō é na kūtuní ntɨ tē xee úra i é kūvi? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kidáā né, eni ntuꞌu Jēsuu kakáꞌan ñá ni ñā: —Kuenta tsí vií nto é ña kaní ntaꞌvi nté uun ñaꞌa san nto. ");
INSERT INTO mizNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tsi dóo tɨtɨ́n ñaꞌa kiꞌxi ña é vata te xūꞌú ne, káꞌan ñā: “Xuꞌu é Cristú u”, koo kaꞌan ña. Dōó tɨtɨ́n ñaꞌa san kaní ntaꞌví ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ʼTē kútuni nto tsí kakuvi duꞌxēn da ntátekú nto tsi ntákaꞌan ñáꞌa san iña duꞌxén ne, ñá ku uꞌvī nto. Tsi kuétsī é kuān koo kuvi, ntá tsi vata xee táꞌan ntuvi é ntɨ̄ꞌɨ ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tsí uun ñuú san ne, nāá ni tūku ñuu. Uun reí ne, naā ñá ni tūku reí san. Dōó kiꞌin itsi ñūú san ne, táān; kutama ñáꞌa sán dɨ. Tē kúvī sáꞌā né, dā ve nuu i é īñɨ ntuꞌu é ntōꞌo ñaꞌa, ña ntoo ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ʼNtōꞌó ne, kuenta tsí vií nto. Tsí ñaꞌa sán ne, ntada ña nto kuenta ntáꞌa ña tsiñu i sán ne, kaꞌní diīn ñá nto má viꞌī mi ntánataká nuu ña Israeé san. Nuu ña tsiñu naꞌnu i, nuu reí san kuntāñɨ́ meꞌñū ntó dɨ vata koo é kāꞌan nto nté kui ntántīkɨn ntó ko. ");
INSERT INTO mizNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Diꞌna dá ntɨ̄ꞌɨ ñuxiví sa ne, kɨ́ꞌɨn ñāꞌa, kíkaꞌan ntódo ña túꞌūn vaꞌá san dá kanɨɨ kāꞌnu ñuxiví san. ");
INSERT INTO mizNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Te tɨ̄ɨn ña nto ne, ntada ña nto kuenta ntáꞌa ña tsiñu i sán ne, ñá ku kadā kuení nto nté koo kaꞌan nto. Tsí taꞌxi Xuva kō é kāꞌan ntó tē xee úra i é kāꞌan nto. Ñá te kene mii ntō é kāꞌan nto, tsí Espíritū Sántū san taꞌxi ña túꞌūn é kāꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kidáā né, ñatīí san ne, ntada ña ení mii ña kuēnta ntáꞌa ña tsiñu i é kaꞌnī ñá ña. Uva īꞌxá san ne, ntada ña iꞌxá ña kuenta ntáꞌa ña dɨ. Iꞌxá san ne, tsiꞌi kuétsi uva i ni dɨꞌɨ ī ne, ntada ña kuenta ntáꞌa ña tsiñu i dɨ é kaꞌnī ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ñá ntīo kueꞌen ñáꞌa san nto, ntá tsi tē xoo é ña xtuví mii ī é kuīntiꞌxe i kó dā nté ntɨ̄ꞌɨ ntuvi iña ñá ne, nakáku ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ʼTē íni nto tsi é ntītsi nuu i é kīni kaa san má ūkún kaꞌnu kān míꞌī e dóo xii kaa ne, ntōꞌo é ntoo nto ñuú Judeá ne, kunu nto kueꞌēn ntó, kukūntoó xuꞌū ntó ata uku kan. ");
INSERT INTO mizNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tē xoó ñaꞌa tuví daꞌna ña ata viꞌi ña kan kídaā ne, ñá ku ntɨ̄ꞌví ña má viꞌi kān e kínakíꞌi ña iña ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tē xoó ñaꞌa nuu ña matú ña kān ne, ñá ku nūꞌu ña e kínantúku ña kutuun ña é kɨꞌɨn niꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ntāꞌvi ide ñádɨ̄ꞌɨ, ña é ñūꞌu iꞌxá i! ¡Ntāꞌvi ide ñádɨ̄ꞌɨ, ña é kanatsītsi iꞌxá i kídaā! ");
INSERT INTO mizNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kákan nto ntaꞌa Xuva kō é ña kuan kōo kúvi dá ntūvi víꞌxin. ");
INSERT INTO mizNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tsi kídaā né, un váꞌa tsi ntoꞌo ñaꞌa. Un tsi nte dá de kûꞌvé Xuva ko ñūxiví sa ne, vata ntóꞌo ñāꞌa san vata koo ntoꞌo ña ntuvi tsikan. Ntē ña kuan koo ntóꞌo xtuku ñaꞌa san é kuān koo ntoꞌo ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tē dɨ́ ña ni dé kûꞌvé Xuva kō é ntudutsi ntūvi tsikán ne, nté uun ñaꞌa ña nakáku ña. Ntá tsi ntadutsi ña ntuvi tsikan kuenta iña ñaꞌá san, ña e dóo kakuinima Xúva kō, ña é nakaxnúu ña é kūvi iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ʼKidáā né, tē xoó kaꞌan í ni ntō: “¡Koto nto! ¡Ikān tuví Cristu!”, ne, ñá ku kuintīꞌxe nto é kākaꞌan ñá naa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tsí iō ñáꞌa, ña é kīꞌxi kídaā ne, káꞌan ñā é Cristu ña. Káꞌan ñā tsí kakaꞌan ñá naa Xuva ko. Vií ña nuu i e dóo naꞌnu ne, vií ña nuu i e dóo vaꞌa. Ntá tsi da ntaéni ntaꞌví ña ñaꞌa san. Tē dɨ́ kuvi vií ña ne, un tsi nte ña nakaxnúu Xuva kō kaní ntaꞌví ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kuenta tsí vií nto. Dukuān é dīꞌna kakaꞌán u ni nto ūn ntɨɨ́ ntɨ̄ɨ́ nuu i sáꞌā nté koo kúvi. ");
INSERT INTO mizNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ʼKidáā ne, rkontûví e dóo ntoꞌo ñaꞌa, ña ntoo ñuxiví a ne, kuneé ngántii, kuneé xoo. ");
INSERT INTO mizNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kóꞌxo kɨ̄mi é ūve e dukún kān dɨ́ ne, kantá nuu e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Xuꞌu é vēxkúvi ú ñatīí ne, nainú u meꞌñú vikó san. Kidáā ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san kiní ña tsi dóo kaꞌnu ú ne, dōó īó ko é vīí u é un ntɨꞌɨ̄. ");
INSERT INTO mizNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kidáā né, taxnūu u ánjē é nākuido ña un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña é nākaxnúu u. Dā míꞌī ká ñuxiví sa mí ntoo ña un tsi nte e dukún kān nakuido ánjē san ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ʼKoto nto nté o de tun ígū san. Te ūte ntaꞌa i é da ve kantɨka xúku ī ne, ini o tsí dokó sa xee ntuví kaꞌni san. ");
INSERT INTO mizNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kuan kōo dɨ́, tē ntaíní nto tsi é kakūvi un ntɨɨ́ ntɨ̄ɨ́ nuu i sáꞌā é kākaꞌán u ni ntō vevií ne, kutuni nto tsi dóko sā xee ntúvī é nainú u ñuxiví a. ");
INSERT INTO mizNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Átā xiꞌi xnto túvi u. Nuu é ntaā i é kākaꞌán u ni ntō, tsí kuntaa é un ntɨꞌɨ̄ é kākaꞌán u ni nto dīꞌna dá ntɨ̄ꞌɨ ntuvi iña ñá ntoo ñuxiví sa vevii. ");
INSERT INTO mizNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kuān te ntɨꞌɨ ñuxiví sa nī e dukún kān ne, ntá tsi túꞌūn é kākaꞌán u ni ntō ne, ña ntɨ́ꞌɨ̄. ");
INSERT INTO mizNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ʼNtá tsi xoxó ini í nee ntúvi ō neé ura kúntaa é kākaꞌán u; nté uun ánjē, ña ntoo e dukún kan, nté xuꞌu é vēxkúvi ú ñatīí ne, ñá īní u; mii tsi Uvā ko é ini ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ʼDukuān ne, koto váꞌa nto. Na kōo túꞌve nto, tsi ñá ini nto amá xee ntúvi tsikan. ");
INSERT INTO mizNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sáꞌā né, vata kaa uun ñatīí, ña é tūví tuꞌve e dóo ika kɨ̄ꞌɨn ñá, ne, xtuvī ñá viꞌi ña ntaꞌa ña ntáde tsiñu iña ña. Káꞌan ña nī é un é un ña ntáde tsiñu iña ña nté koo vií ña ne, xtuvī ñá uun ñaꞌa, ña é kōto xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ntōꞌó ne, koto váꞌa nto dɨ, tsí ñá ini nto neé ura naínú u: tē kuaa vaꞌá ne, o dava ñūu, o ura í tē kána lɨ́ꞌxɨ, o tē tuví vaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tē ntákidi dúkuan ntō ne, da née inī ntó nainú u. ");
INSERT INTO mizNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ntá tsi nuu i é kākaꞌán u ni ntō ne, kakaꞌán u ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san: ¡Kuntitō nto! ¡Ñá kū xkúkidi naá nto! —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kakunaá ka uvi ntúvi dá xēe viko da ntánakaꞌan ña nté ō nakáku Xuva kō ña Israeé san ñuú Egítō. Kidáā ne, ñá kāꞌxi ña tañúꞌū é kadāka úꞌxen iā. Tōꞌó dutu ní mastrú leí san ne, ntukū nuu iní ña nté koo vií ña é diin diin tsi tɨɨn ña Jesuu é kaꞌnī ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ntatíin mii ñā: —Ña tɨ́ɨn o ña ntūvi viko san, vata koo é ña kudíin ñaꞌa san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tuví Jesuu ñuú Betania nú viꞌi Sīmuun, ña é nakoꞌxo kúñu ī kídaā. Dá ntōo ña, ntaéꞌxi ña ne, xée uun ñadɨ̄ꞌɨ́, niꞌi ña uun xuxu e kúvi xuu mí nuu choꞌo vîdin e dóo nuu áꞌvi. Taꞌvi ña xuꞌū i ne, dáꞌvī ntɨꞌɨ ña choꞌo vîdín san dɨkɨ Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dā íni ña ntoo sán ne, dōó dutsi kuiní ña. Ntatíin mii ñā: —¿Nté kui natɨvī ntú ña choꞌo vîdín sa? ");
INSERT INTO mizNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Dií ka váꞌā ó tē dɨ́ ni nadiko ñā ne, níꞌi ña te ūní sientu, dá kuēꞌé ña ña ntāꞌvi —kaꞌan ña. Dōó dutsi kuiní ña ni ñadɨ̄ꞌɨ́ san. ");
INSERT INTO mizNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ntá tsi Jesuú ne, kakaꞌan ña: —Koo mii nto ñā. ¿Nté kui ntánatekū duꞌxen ntu nto ña? Dōo váꞌā ó de ña nī ko. ");
INSERT INTO mizNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nguentúvi ntoo niꞌi nto ña ntāꞌví san ne, amá ntio nto ne, kuvi xntii nto ñā. Ntá tsi xuꞌú ne, ña náꞌā ká kutūví u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ñadɨ̄ꞌɨ́ saꞌá ne, īde ña é kūvi vií ña. Dáꞌvi ñā kó choꞌo vîdín san diꞌna dá kuntuꞌxi u. ");
INSERT INTO mizNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nuu é ntaā i é kākaꞌán u ni ntō: Dā míꞌī ká kɨꞌɨn ñáꞌa é kikaꞌan ntódo ña túꞌūn vaꞌá san iña Xuva ko dá kanɨɨ ñūxiví sa ne, káꞌan ñā é kuān nte váꞌā o dé ñadɨ̄ꞌɨ́ san nī kó ne, nakaꞌan ñāꞌa san ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Uun ña ntɨniꞌi Jēsuu, ñá nanī Júda Scārioté ne, kuéꞌen ñā mí ntoo tóꞌō dutú san ne, tíin ña ni ñā nté koo vií ña é diko ña Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dā téku tóꞌō dutú san é kākaꞌan Júdā né, dōó diní ña. Xéꞌe ñā xuꞌu ña e ntáꞌvi ña ña te kuvi vií ña. Júdā sán ne, ntukū nuu iní ña nté koo vií ña é diko ña Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kidáā ne, xée ntūvi é kii viko da kaꞌxi ña tañúꞌū é ña kadáka uꞌxen iā, ntuvi da ntaéꞌní ña iꞌxá leꞌntú san é kāꞌxí ña iña vikó san. Ntákaꞌan ñá ntɨniꞌi Jēsuu ni ña: —¿Míꞌi ntū ntio nto é kīkaváꞌa ntɨ é kāꞌxi o vikó san? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kidáā né, teé tsiñu Jesuu úvi ñáꞌa, ña ntɨniꞌi ñā ne, kakaꞌan ñá ni ñā: —Kueꞌēn ntó má ñūú san. Tē xee ntó ikān ne, taꞌán nto uun ñatīí, ña niꞌi xoó ntute sán ne, kuntīkɨn ntó ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Neé viꞌi mí kɨ̄ꞌví ña ne, káꞌan nto nī tóꞌo vīꞌi san: “Kakaꞌan Mástrú ntɨ: ¿Míꞌi ntū má viꞌi kuntōo ntɨ́ ni ña ntɨniꞌī ntɨ é kāꞌxí ntɨ iña vikó san?”, koo kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kidáā né, nañēꞌe ñá nto uun má viꞌi kāꞌnu iní viꞌi dūkún san. É iō tuꞌve. Ikān ne, kaváꞌa nto é kāꞌxi o iña vikó san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kuéꞌen ña ntɨniꞌi ñā ne, xée ña ñūú Jerusaleen. Nāniꞌi ntiꞌxe ñá vatā ó kakaꞌan Jésuú ne, ikān de váꞌa ña é kāꞌxí ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Dā kuáā ne, xée Jēsuu ni uxuvi ñáꞌa ña ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dā intóo ña ntaéꞌxi ñá ne, kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō: Uun ñaꞌa nto, ña é kaēꞌxí dadɨɨ nto nī kó vevií ne, diko ntō ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kūntaꞌxa iní ña ntɨniꞌi ñā kídaā ne, é un é un ña tsixeꞌe ña Jēsuu: —¿Vá xuꞌú ntu u? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kakaꞌan Jésuu ni ña: —Uxúvi ñāꞌa nto ntaéꞌxi dadɨɨ nto nī ko. Uun tsi koꞌo kaexnúu ú nī ña dikō ko. ");
INSERT INTO mizNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tsí xuꞌu é vēxkúvi ú ñatīí ne, kuntaá vata tsī ó uve naꞌa nte díꞌna. Ntá tsi ntaꞌvi idé ña sāꞌá, ña dikó ko. Dií ka váꞌā ó tē dɨ́ ña ni kāku ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dā ntaéꞌxi ñá ne, kīꞌi Jesuu tañúꞌū san. Nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō né, kātsin dava ña tañúꞌū sán ne, xéꞌe ña ña ntɨniꞌi ñā, kakaꞌan ña: —Kiꞌi nto sáꞌā, tsi kúñū ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kidáā né, kīꞌi ña eꞌxin é ñūꞌu ntute tɨntiꞌo. Diꞌna nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō né, dā xeꞌé ña é kōꞌo un ntɨɨ́ ntɨ̄ɨ́ ña ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kakaꞌan Jésuu ni ña: —Sáꞌā é nɨñɨ́ ko é kātɨ ú kuenta iña ñá te da díi ñaꞌá san, vata ō xtúvi Xuva kō da táꞌxi ña xuꞌu ña kuenta iña núu ī é xēe é viī ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nuu é ntaā i é kākaꞌán u ni ntō: Ña kóꞌō ká u ntute tɨntiꞌó san da nté ntūvi é kōꞌo ú ntute tɨntiꞌo xeé san mí kadē kûꞌvé Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dā kúvi íta ña nchuꞌun Xúva kō ne, kuéꞌen ña ūun tɨꞌɨ i é nani Ōlivu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ikān ne, kakaꞌan Jésuu ni ña ntɨníꞌi ñā: —Un ntɨɨ́ ntɨɨ̄ ntó xtuvī mii ntó ko ve, vata tsī ó uve naꞌa kakaꞌan: “Kaꞌní u paxtú san ne, da míꞌī ká kunu á leꞌntú san”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ntá tsi tē ntóto xtuku ú ne, diꞌna ú kɨ́ꞌɨ̄n ú ñuú Galilea é dɨvi ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kakaꞌán Pedru ni ña: —Kuān te un ntɨɨ́ ntɨɨ̄ ñá xtuvī mii ña nto, xuꞌú ne, ñá xtuvī mii ú nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ō: Niñú sāꞌa, diꞌna dá kāna lɨ́ꞌxɨ̄ san uvi íto ne, úni īto kaꞌan tsí ña inín ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dā dií dií ka ntii kakaꞌán Pedru: —¡Ñaꞌá ni san! Kuān te kuví u ni ntō ne, ñá kāꞌán u é ñá iní ú nto —kaꞌan ña. Kuan ō kaꞌan un ntɨɨ́ ntɨ̄ɨ́ ña ntɨniꞌi ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kuéꞌen Jēsuu ni ña ntɨníꞌi ñā uun itsi é nani Getsemānii. Kakaꞌan ña: —Kuntoo nto iꞌa, nɨɨ dukuan na kɨ̄ꞌɨ́n u daꞌa kān, kíkaꞌan ntâꞌví u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Da mii tsī Pedru, Sántiau ní Juaán san kueꞌen níꞌi ña. Kidáā né, dōo uꞌvi kakúvi nima Jésuu; dōo kúntaꞌxa iní ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kakaꞌan ñá ni ñā: —Vevií ntɨka nimá ko dontɨ́ni. Dóko sā kúvi ú dontaꞌxa. Kuntōo nto iꞌa ne, ñá ku xkukídi nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kuéꞌēn ká Jesuu ún siin ne, nákūtínteɨ ña ñuꞌu kān. Íkan ña ntaꞌa Xuva ko te kūvi ne, ña kóo ura í e dóo ntoꞌo ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kakaꞌan ña: —Uvā, uva miī ko, kuvi vií nto un ntɨꞌɨ̄. Tāꞌxi nto é ña kuan kōo ntóꞌo ko. Ntá tsi ña te vata kaa é ntio mii ko, tsí vata kaa é ntio mii nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nāxee ña mí ntoo ña uni ñáꞌa san ne, ntákidi ña. Kidáā ne, kakaꞌan ñá nī Pedru: —Simuun Pedru, ¿nté kui kakidin ntun? ¿Nté uun ura ñá ni kutíin ntun kuntītón nī ko? ");
INSERT INTO mizNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kuntitō xnto. Kákan nto ntaꞌa Xuva kō é ña kóꞌxo nto nuu i é kīni kaa. Kuān te ntío nto é viī nto é vāꞌá ne, ña kúvī, tsí e kuíni kúñu ntō é viī nto é kīni kaa —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kuéꞌen xtūku Jesuu, kúkaꞌan ntâꞌví ña ni Xuva kō né, kuan tsī ó kakaꞌan ñá vata tsī ó kakaꞌan ña dá kāꞌan díꞌna ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dā náxee xtúku ña ne, ntákidi xtúku ña, tsi dóo tavī ñá maꞌna. Ñá ni kutūni ini ña nté koo kaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","É kūvi uni íto kueꞌen Jésuu, kúkaꞌan ntâꞌví ña, ne, dā náxee xtúku ña ne, kakaꞌan ña: —¿Ntákidi dúkuan ntu ntō? ¿Ntoo daꞌna ntu nto dɨ? Xée ō tsí kukidi nto ve, tsí e xée ūra i é ntuvī ú kuenta ntáꞌa ña kini ntáa, dɨvī u é vēxkúvi ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nakuntáñɨ̄ nto, kɨ́ꞌɨn o vē, tsí e véꞌxi ña dikó ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Dá kakāꞌan dúkuan Jesuú ne, xéē Júdā, uun ñaꞌa ñá uxuvi ñáꞌa ña ntɨniꞌi ñā. Ñá te da dīi ñáꞌa san nteka ña. Odo ñā káa, odo ña ūtun. Tōꞌó dutú nī mastrú leí ni ñatā sán ne, taxnūu ña ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Júdā sán ne, nté dīꞌna tíin ña nī tóꞌō dutú san: —Xoó ñaꞌa é kāꞌxi ú xuꞌu i ne, é dɨvi ñā. Tɨɨn nto ña, kunteka váꞌa nto ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dā xee Júdā sán ne, ura tsí i kuéꞌen ñā mí ntitsí Jesuu, káꞌan ñá ni ñā: —¡Mastru! —kaꞌan ña. Ēꞌxí ña xuꞌu Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kidáā né, tɨ̄ɨn ñaꞌa san Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ntá tsi uun ñaꞌa ña ntitsí etsin ne, tāvá ña káa ñā, da éꞌnte tuꞌun ña loꞌxo ñá kade tsiñu iña tóꞌō dutú san. ");
INSERT INTO mizNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesuú ne, kakaꞌan ñá ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san: —¿Nté kuān ntu ódo nto káa ni ūtun é vextɨ́ɨn nto ko? ¿Vá ña duꞌu ntú u? ");
INSERT INTO mizNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nguentúvi itúvī ú ni ntō má ūkún kan, kanakuāꞌa ú nto ne, ña ni tɨ́ɨn nto ko. Ntá tsi kuān koo kuvi vata koo é kūntaa é ūve naꞌa Túꞌun Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kidáā ne, un ntɨɨ́ ntɨ̄ɨ́ ña ntɨniꞌi Jēsuú ne, xtuvī mii ña ña, ínu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Uun na tīí kuetsī sá ne, ntikɨ̄n ná Jesuu. Da miī doo kuiꞌxín katinúu na. Tɨ̄ɨn ña na ne, ");
INSERT INTO mizNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","dá xtuvī mii na dóo na. Koó da kantɨ̄ɨ́ na ínu na. ");
INSERT INTO mizNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Íntēka ña Jesuu mí tuví dutu ñá odo nūu iña ñá Israee. Nātaká nuu un ntɨɨ́ ntɨ̄ɨ tóꞌō dutu ni ñáta nī mastrú leí san. ");
INSERT INTO mizNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrú ne, íntīkɨn íka ña Jesuu ún tsi da nté xee ña nú viꞌī dutu ñá odo nūú san. Ítūví Pedru ni ña ntáde tsiñu iña dutu ñá odo nūú san nu kíꞌi kān mí ntátuní ña nchúꞌun kān. ");
INSERT INTO mizNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tōꞌó dutú san ni ūn ntɨɨ́ ntɨ̄ɨ́ ña tsiñu i ne, ntántukū nuu iní ña nēe é tsiꞌi kuétsi ña Jesuu, vata koo é na kuvī ña, ntá tsi ña ni níꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ñá te da dīi ñaꞌa daꞌví ña ña dovete, ntá tsi ña ni kudadɨ́ɨ e ntákaꞌan ñá ni ña nguiī san. ");
INSERT INTO mizNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Iō ñá nakuntáñɨ̄ ña é dāꞌví ña dovete Jesuu, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Tēkú ntɨ é kākaꞌan Jésuú ne: “Nakatsín u xúkun kaꞌnu sa é de váꞌa ñaꞌa san. Tē kúvi uni ntúvi ne, naxntītsí u túku xukun é ña te ñaꞌa kada váꞌa ña”, kaꞌan kú ña —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ntá tsi ña ni kudadɨ́ɨ ña é un ntɨꞌɨ̄ e ntákaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kidáā ne, nákuntītsí dutu ñá odo nūú san méꞌñū ñaꞌa sán ne, kakaꞌan ñá ni Jēsuu: —¿Ña kuvi ntu nantiko koon é kuan ō ntákaꞌan ñaꞌa sa íña o? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ntá tsi Jesuú ne, diin diin tsi katúvi ña. Nté uun túꞌūn ña ni káꞌan ña. Kakaꞌan xtúku dutu ñá odo nūú san: —¿Vá dɨvin ntun é Cristu? ¿Iꞌxá Xuva ntu ko ō? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Dɨvī u —kaꞌan Jésuu—. Kiní nto ko, xuꞌu é vēxkúvi ú ñatīi, é kutūví u diñɨ kuaꞌa Uvā ko, ña dóo kaꞌnu san. Kiní nto ko te nainu u méꞌñū viko san dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dutu ñá odo nūú san ne, kūdiin ña é kuān ó kakaꞌan Jésuu. Kātsin diin ña dúꞌnu ñá ne, kakaꞌan ña: —Ñá vādá ntio ká ko ñaꞌa, ña é tsiꞌi kuétsi ña sāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","É tēkú nto é kuān nte kini o kakaꞌan ña tsí Iꞌxá mii Xuva ko ñā ne, ¿nté ō ntádē kuení ntu nto? —kaꞌan ñá, tsixeꞌe ña ñāꞌa san. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, ntákaꞌan ña tsí kantio é kūví Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Iō ñá ne, tɨ̄ꞌvi dɨɨ́ ña Jesuu. Ēdɨ́ nuu ña doo ntuxnúu ña ne, da éꞌni ña ña, ntákaꞌan ña: —¡Kaꞌan ve xoo éꞌni i o! —kaꞌan ña. Un tsi nte ña ntáde kuenta xúkūn sán ne, xēꞌe nuu ña nuu Jésuú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dá tuví dukuān Pedru nu kíꞌi kān ne, xée ūun taꞌnu kade tsiñu iña dutu ñá odo nūu. ");
INSERT INTO mizNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Īni tun tsí katuní Pedru nchúꞌun kān. Kaito nteé tun ña, kakaꞌán tun: —Dɨvīn né, dadɨɨ kaikan ni Jēsuu, ña véꞌxi ñuú Nazaree —kaꞌán tun. ");
INSERT INTO mizNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ntá tsi Pedrú ne, kakaꞌan ña: —Ñá īní u ña; ntē ña katéku ko é kākaꞌan nto —kaꞌan ña. Kidáā ne, kuéꞌen ña xiꞌi kan. Ura tsí i kána lɨ́ꞌxɨ̄ san. ");
INSERT INTO mizNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Īní taꞌnu kade tsiñu iña dutú san ña ne, kakaꞌán tun nī ña ntâñɨ: —Ña sāꞌá ne, ña ntɨniꞌi Jēsuu —kaꞌán tun. ");
INSERT INTO mizNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kakaꞌan xtúku Pedru tsí ñaꞌa. Da kū e víꞌi ne, kakaꞌan ña ntâñɨ́ san nī Pedru: —Dɨvīn ntiꞌxen é ntɨniꞌin Jēsuu. Tsí dɨvīn ne, ña ñuú Galilea —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kidáā né, eni ntuꞌū Pedru kakáꞌan ña: —Na taꞌxi Xuva kō é ntōꞌo kó tē ña te nuu é ntaā i é kākaꞌán u ni ntō e ñá iní u xoo é kākaꞌan nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ura tsí i ne, kāna xtuku lɨ́ꞌxɨ̄ san. Kidáā nákaꞌan Pedru nté ō kaꞌan Jésuu ni ña tsí diꞌna dá kāna lɨ́ꞌxɨ̄ san uvi íto ne, úni īto kaꞌán Pedru tsi ñá īni ña xoo é Jēsuu. Dā nákaꞌan ñā né, dōo éku ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dā tuví ne, nātaká nuu tóꞌō dutú, ni ñata, nī mastrú leí, ni ūn ntɨɨ́ ntɨ̄ɨ́ ña tsiñu i san, ntatíin ña nté koo vií ña ni Jēsuu. Kidáā né, kīꞌní ña Jesuú ne, dā kueꞌen niꞌi ña ña mí tuví Pilatu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatú ne, tsixeꞌe ña Jēsuu: —¿Dɨvīn ntun é Rei iña ñá Israee? —kaꞌan ñá, tsixeꞌe ñā. —Kuān ó vatā ó kakaꞌan —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dōó tɨtɨ́n nuu i é ntátsiꞌi kuétsi tóꞌō dutú san Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kidáā ne, kakaꞌan xtúku Pilatu ni Jésuu: —¿Ñā ntu kuvi káꞌan? Koton tsi ñá te da dīi núu ī e ntátsiꞌi kuétsi ñaꞌa san o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Koó dā kúduꞌva Pilatú san dá ña ni kaꞌan kuéꞌen tsi Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kuia kuíā dá kaxee víko e nákaꞌan ñāꞌa san nté ō nakáku Xuva kō ña Israeé san ñuú Egítō né, vatā xkoó ini Pílatú san ne, kanantīi ñá uun ñaꞌa ña ñuꞌu kutū san, ntá tsi ñaꞌa san ntaíkan ña xōo ñáꞌa é ntio ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tɨtɨ́n ñaꞌa ñuꞌu kutu ña viūtun san ntuvi tsikan, tsí naá ña ni ña tsiñu ī sán ne, ēꞌní ña ñaꞌa. Uun ñaꞌa ñā né, Barabaa nani ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ñá te da dīi ñaꞌá san xee ña, ntákaꞌan ñá ni Pīlatu té nantīi ña uun ñaꞌa ña ñuꞌu kutu viūtun san, vatā ó de ña kuia kuia dá kakuvi viko sāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kakaꞌan Pílatu ni ñaꞌá san: —¿Ntio ntu nto é nantiī ú Rei iña ñá Israeé san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tsi kútuni Pílatu tsi tóꞌō dutú san kuneꞌu iní ña ni Jēsuu. Dukuān e ntáda ña ña kuenta ntáꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ntá tsi tóꞌō dutú san ne, ntákaꞌan ñá ni ñāꞌa san é kāꞌan ñá ni Pīlatu é na nantīi ña Barabaá san. ");
INSERT INTO mizNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kakaꞌan xtúku Pilatu ni ñaꞌá san: —¿Nté ntu koo vií u ni ña sāꞌá kuan, ña e xntánteē ntó Rei iña ñá Israee? —kaꞌan ña, tsíxeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Koó da vāntiñɨ ñáꞌa san ntákaꞌan ña: —¡Naxnteē ntó ña ntiká krusi kan! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kakaꞌan Pílatu ni ña: —¿Nté kui san? ¿Neé ntu kuetsi idé ña sāꞌa? —kaꞌan ña, tsíxeꞌe ñā. Ntá tsi dā dií dií ka vāntiñɨ ñáꞌa san ntákaꞌan ña: —¡Naxnteē ntó ña ntiká krusi kan! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatú san ne, ña ni ntío ña é kūdiin ñáꞌa san ni ñá, ne, nantíi ña Barābaa. Kidáā ne, kakaꞌan Pílatu ni sntadún san é na kāni ña Jesuu xóꞌo ūme ne, dá ntāda ña ña kuenta ntáꞌa sntadún san é na naxnteē ñá ña ntiká krusi. ");
INSERT INTO mizNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sntadún san ne, kueꞌen níꞌi ña Jēsuu nu kíꞌi viꞌi mēꞌñú san. Kāna ña un ntɨɨ́ ntɨ̄ɨ́ sntadun, ñá ntoo ikān, na nātaká nuu ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Naxnūu ña Jesuú doo kueꞌe, ne, de váꞌa ña leꞌe e kúvi ntuku íñū né, dā xntéku ña dɨkɨ Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ntákaꞌan sntadún san ni ñā: —¡Ntiusi o, Rei iña ñá Israee! —kaꞌan na. ");
INSERT INTO mizNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kāni na chɨɨn dɨkɨ Jésuú ne, tɨ̄ꞌvi dɨɨ́ na ña dɨ. Nakani ɨtɨ ná nuu ña, ntaéni dɨkɨ́ na ña e ntaíko ñuꞌu na ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Dā kúvi narkɨ́nteē ná ña ne, natāvá na doo kueꞌe é nuu ña, dā náxnuu na ña doo mii ña. Kidáā ne, kueꞌen níꞌi na ñā é naxnteē ná ña ntiká krusi. ");
INSERT INTO mizNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ítā ntiꞌxin uun ñaꞌa, ñá nani Sīmuun, úva Alējandru ni Rúfu, ña véꞌxi ñuú Cirene. Xeꞌe kuétsi na sntadún san Simuun é na kuīdo ña krusi Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kueꞌen níꞌi na Jēsuu uun itsi mí nani Gōlgota, é kāni túꞌun: Xkɨdɨkɨ Ntɨ́xɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Xéꞌē na sntadún san é kōꞌo Jesuu ntúte tɨntiꞌo íā é kadāka chóꞌō é nanī mira. Ntá tsi ña ni xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kidáā ne, náxnteē ná Jesuu ntíkā krusi kan. Nākaꞌnté dava na doo ñá ne, dā nadɨkɨ́ nteē na, nee é niꞌi na, xé un xé un nā. ");
INSERT INTO mizNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kaeku ɨɨn teváa náxnteē ná Jesuu ntíkā krusi kan. ");
INSERT INTO mizNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dā de váꞌa na taꞌvi rkunū e nteé naꞌa kakaꞌan nee é kuētsí ña. Dɨ́kɨ̄ krusí san xntée ná taꞌvi rkunū san é ūve naꞌa kakáꞌan: “Rei iña ñá Israee”. ");
INSERT INTO mizNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xnteē ná uvi ñaꞌa ñá duꞌu ntíkā krusi kán dɨ é kūví dadɨɨ ña ni Jēsuu. Uun ñaꞌa ñā ne, ntitsí krusi ña diñɨ datsin Jesuú ne, uun ñaꞌa ñā ne, ntitsí krusi ña diñɨ kuaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kuntaa vatā ó uve naꞌa Túꞌun Xuva kō mí kakāꞌan: “Kuvi dadɨɨ ña ni ña kini ntáa san”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ña ntaíta ntíꞌxin sán ne, dōó kini ntákaꞌan ñá ni Jēsuu. Ntánakuiko ña dɨ̄kɨ ña, ntákaꞌan ña: —Dɨvīn é kanakatsin xukún kaꞌnu sán ne dá naxntītsín xtukun te kuvi uni ntúvi ne, ");
INSERT INTO mizNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","nakākún miin kúñu ō ve. Ntii nteen miin ntíkā krusí san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tōꞌó dutu ni mastrú leí san ne, narkɨ́nteē ñá Jesuú dɨ. Ntánatíin mii ña: —Kuvi nakakū ñá tuku ñaꞌa sán ne, ntē ña kakúvi ntu ku nakāku mii ña kúñu ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tē Rei iña ñá Israee ntíꞌxe ña ne, o tē ña é taxnuu ntiꞌxe Xuva kō né, na ntīi ntee mii ña ntiká krusi kan. Kidáā ne, kini ó ne, kuintiꞌxe kō dɨ —kaꞌan ña. Ntuvi ñáꞌa, ñá uve niꞌi ña ntīká krusi kán ne, dōó kini kaꞌan ñá ni ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dā káꞌñu ntuvi ne, un tsi da nte kaeku uni kuáa ne, kūneé da kanɨɨ ñūxivi. ");
INSERT INTO mizNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ura tsíkan ne, un ntii tsī kéne Jesuu, kakáꞌan ña: —Eluii, Eluii, ¿lama sabatani? (é kāni túꞌun: Xuvā kó, Xuvā ko, ¿nté kui xtuvī mii ntó ko?) —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dā téku ña ntâñɨ étsin sán ne, ntákaꞌan ña: —Kini nto ña. Vata te kakana ña ña kaꞌán naa Xuva ko, ñá nani Ēlia —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Uun ñaꞌa ñā né, kaxkainu ña kueꞌen ña, kuxnúu ntoꞌo ña tɨꞌntɨ dóo san iní ntute tɨntiꞌo ía, dā xnuu ntído ña dɨkɨ útun, dā xeꞌé ña é kōꞌo Jesuu. Kakaꞌan ña: —Na koo mii nto ñā. Koto o ve te kīꞌxi ntíꞌxe Eliá san é nāntii nteé ña ña ntiká krusi kan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kidáā né, kāchuꞌu ntáa Jesuu, ntíꞌxi nuu kakan inī ñá ne, xíꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ntáta ntāa dôxi é rkaa íko má ūkún kaꞌnu san. Nte dɨ́kɨ i un tsi nte xeꞌe i ntíi. ");
INSERT INTO mizNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Uun tóꞌō é uun sientu sntadún san ntitsí ña nuu Jésuu. Dā íni ña nté ō xiꞌi Jésuú ne, kakaꞌan ña: —Nuu é ntāa ntíꞌxe i é ña sāꞌá ne, Iꞌxá Xuva ko ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ntaíto díto ika ñadɨ̄ꞌɨ́ san dɨ. Ikān ntâñɨ Maria Madálena, María, dɨꞌɨ Sāntiau lúꞌnti ni enī ñá Joseé, ni ñadɨ̄ꞌɨ, ñá nani Salūmeé dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ñadɨꞌɨ̄ saꞌá ne, ntántīkɨn ñá Jesuu é xntii ña ñā da itúvi ña ñuú Galilea. Dōó tɨtɨ́n ka ñadɨ̄ꞌɨ́, ña xee niꞌi Jésuu ñuú Jerusaleen, ntâñɨ ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Dā kuáa ntuvi vierné san, ntuvi é koo túꞌve tsí utén ne, ntuvi iō dáꞌna, ");
INSERT INTO mizNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","xée Jōsee, ña véꞌxi ñuú Arimatea. Ña sāꞌá ne, dōó ntaíko ñuꞌu ñaꞌa san ña, tsí ña tsiñu i ña. Kantétu ña ntūvi dá kada kúꞌve Xuva kō. Naxnuu kaꞌxi ñā nima ñá ne, kuéꞌen ñā mí tuví Pilatu é ntākan ña kúñu Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Koó dā kúduꞌva Pilatú san tsí e xiꞌi Jésuu. Kāna ña tóꞌō sntadún san, tsíxeꞌe ña ña tē nuu é ntaā i é xiꞌi Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kakaꞌan tóꞌō sntadún san tsí nuu é ntaā i. Kidáā ne, xéꞌe Pīlatu ítsi é na nākuníꞌi Joseé san kúñu Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseé san ne, ñīi ña doo váꞌa é nāxnuu taꞌán ña Jesuu. Nántii ntēé ña ña ntiká krusi kán, dā náxnuu táꞌan ña ña doó san, dā xtúvi ntuvē ñá ña iní ñañā mí ete nuu ña ini xuú san. Xnuu ntiꞌu ñá xiꞌi ñáñā san uun xuú kaꞌnu. ");
INSERT INTO mizNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Madálena ni María, dɨꞌɨ Jōseé ne, ntâñɨ ña, ntaíto dito ña mí kaintúꞌxi Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dā ntɨ́ꞌɨ ntuvi dá iō dáꞌna ne, Maria Madálena, María, dɨꞌɨ Sāntiau lúꞌntī sán, ni Salūmeé ne, ñīi ña choꞌo e dóo váꞌa ñeꞌe é daꞌvi ña ata dóo é nuu taꞌan kúñu Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tēvaá duꞌva tsi da véꞌxi tuví ntuvi domingú san ne, kuéꞌen ñadɨ̄ꞌɨ́ san nú ñaña Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ntánatíin mii ñā: —¿Xoó ntu kuvi naxtuvī xio i xuu kaꞌnú san é kantīꞌu núu xiꞌi ñáñā san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Dā íto ña ne, ñá kantīꞌú ka xuu kaꞌnú san xiꞌi ñáñā san. ");
INSERT INTO mizNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kɨ́ꞌvi ña īní i kān né, īní ña tsí tuví uun ñatīí diñɨ kuaꞌa ñañā san. Nuu ña doo kani, doo kuiꞌxin. Ña dɨ̄ꞌɨ́ san ne, dōo uꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kakaꞌan ñátīí san ni ñā: —Ñá ku uꞌvī nto. Iní u tsí ntánantuku nto Jēsuu, ña ñuú Nazaree, ña é intée ntiká krusi kan. Xôxó ka ña íꞌa. É ntōto ña. Koto nto mí inuu ntúꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kueꞌēn ntó, kukoto nto Pedrú, ni ña ntɨniꞌi Jēsuu, tsí e díꞌna ña kodo nuū ñá nuꞌu ñá ñuú Galileá ne, ikan nakinī ntó ña, vatā ó kākaꞌan ñá ni ntō —kaꞌan ñátīí san. ");
INSERT INTO mizNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ntaka ñadɨ̄ꞌɨ́ san nú ñaña kān ne, koó dā ntaínu ña kueꞌen ña. Un váꞌa tsi ntanɨ́ꞌɨ ña, tsi dóo ntaúꞌvī ña. Nté uun ñaꞌa ña ni kaꞌan níꞌi ña, tsi dóo uꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dā ntóto Jesuu ntuvi domingú ne, diꞌna ntii dítō ña nuu Mária Madálena, dɨvi ñā é natāva Jesuu úꞌxē é ña váꞌā san é ñūꞌu nima ña kídaā. ");
INSERT INTO mizNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kuéꞌen Māriá san mí ntoo ña ntɨniꞌi Jēsuu. Dōó ntoo ntaꞌxa ña ne, dōo ntaéku ña. Kakaꞌan María san ni ña tsí e ntóto Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ntá tsi da téku ña é kāntíto Jesuú ne, ñá ni kuintīꞌxe ña ña. Kuān te kakáꞌan María tsí mii ñā íni ña Jesuú ne, ñá ni kuintīꞌxe ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Rkontûví ne, ntii dîto xtúku Jesuu nuu uvi ñáꞌa ña ntɨniꞌi ñā da ntaíka ña itsi má kuꞌu kān, ntá tsi e túku ito ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ntuvi ñá sāꞌá ne, kuéꞌen ña, kūkóto ña ña nguiī sán tsi íni ña Jesuu. Ntá tsi ña ni kuintíꞌxe ña ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Rkontûví ne, ntīi dîtó Jesuu mí ntoo uꞌxi ɨ́ɨn ñaꞌa ña ntɨniꞌi ñā, ntaéꞌxi ña. Dē tíi Jesuu ni ña tsi dóo kaꞌxī nima ñá, tsi dóo loꞌo ñā é kuintiꞌxe ña e ntóto ña, kuān te ntákaꞌan ñáꞌa san tsí é īní ña ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kakaꞌan Jésuu ni ña: —Kueꞌēn ntó ve, kukaꞌan nto túꞌūn vaꞌá san kuenta iñá ko ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san dá kanɨɨ ñūxivi. ");
INSERT INTO mizNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xoó ñaꞌa é kuintiꞌxe ña ne kutsi ntute ña ne, nakākú Xúva ko ñā. Ntá tsi xoó ñaꞌa, ña é ña kuintíꞌxe i ne, ñá kada kaꞌnū iní Xuva ko ni ña kuētsí ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Xoó ñaꞌa é kuintiꞌxe ña ne, kuvi vií ña nakuitā ñá e ña váꞌā san kuenta iñá ko. Kuvi kaꞌan ña túꞌūn xee e ñá ini ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Te kurkāa ña koó ne, o te kōꞌo ña é kadāka choꞌo é kaxiꞌi ó san ne, ña kúvī ña. Tɨɨn ntaꞌa ñā ña nchokuví ne, ntuváꞌa ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kidáā né, dā kúvi kaꞌan Tóꞌo ko Jēsuu ni ña ntɨníꞌi ñā ne, kúntāa ña e dukún kān, kunakutúvi ña diñɨ kuaꞌa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ña ntɨniꞌi ñā ne, kuéꞌen ña, kūkaꞌan ña túꞌūn vaꞌá san iña Jésuu dá kanɨɨ ñūxivi. Tōꞌó ko Jēsuú ne, xntii ña ñā ne, xéꞌe ñā é kūtuni ñáꞌa san tsí nuu é ntaā i é ntákaꞌan ñá, tsi xéꞌe ñā é kūvi vií ña nuu i e dóo naꞌnu san. Kuan tsī kaa é kāꞌán u ni ntō.");
INSERT INTO mizNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ñá tē nté kaa ñāꞌa ncho kada váꞌa ña tutú nté ō kúvi nuu i é īta ntíꞌxin iña ko. ");
INSERT INTO mizNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Vata tsī o nañéꞌē ñá kō, ña é īni nté ō kúvi, ña ntáduku ntée é kāꞌan ntódō túꞌūn sán un tsi nte dá iñɨ ntuꞌu ne, ");
INSERT INTO mizNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","kuan kōo ncho xntée nāꞌá u dɨ, e dóo nántukū u nté ō kúvi ntiꞌxe un tsi nte dá iñɨ ntuꞌu. Vata te vāꞌá ō é kāda váꞌā ú tutú saꞌá iña nto, Teófilu, e dóo kaiko ñuꞌū ú nto, vata koo é ntāa ú ni ntō un ntɨꞌɨ nūu i é vatā o kúvi, ");
INSERT INTO mizNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","vata koo é kīní vaꞌā ntó nee iña é nuu é ntaā i é nāñéꞌe ñá nto. ");
INSERT INTO mizNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ntuvi dá idé Heródē rei iña ñuú Judeá ne, ítūví uun dutu íña ñá Israee, ñá nani Zacāria, ña é ūve taꞌan dutu tatá viꞌi ñá nani Ābia. Ñadɨꞌɨ̄ ñá ne, Isabee nani ña. Dɨvī ká tatá viꞌi dutu Ároon ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacariá san ni ñadɨꞌɨ̄ ñá Isabeé ne, ntuvi ña e dóo vaꞌá ña nuu Xuva ko; dōo dé ntaa ñá lei Xúva kō. Ntē ña tuvi neé nuu i é kaꞌan ntée ñaꞌa san ña, nté uun ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ntá tsi ña ni xío iꞌxá ña, tsí Isabeé san ne, ña ni kúvi kōo íꞌxá ña; ntuvi ñá ne, é dōo áta ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Uun ntuvi ne, dúku ntēé dutu, ñá ntoo niꞌi Zacāria, é kāda tsiñu ña ini ukún Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Vata xkoó ini dutú san ne, váꞌā ntuvi Zacariá san é dūku ntée ña é kɨ̄ꞌví ña ini ukún kaꞌnu Xuva kō é kíkaꞌmí ña kútū. ");
INSERT INTO mizNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Da nɨɨ̄ kaiꞌxi kútū sán ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntáñɨ̄ ña, ntákaꞌan ntâꞌví ña kíꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kidáā ne, xée ūun ánje Xuva kō mí tuví Zacaria. Ntitsi ánjē san diñɨ kuaꞌa nú tēu mí kaiꞌxi kútū. ");
INSERT INTO mizNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dā íni Zacariá san ánjē sán ne, un tsi kúduꞌva iní ña nee é viī ña; ñá tē nté kaa uꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Da kidáa kakāꞌan ánjē san ni ña: —Ō Zácaria, ñá ku uꞌvī o, tsí Xuva kō né, tēkú ña é kākaꞌan ntaꞌvin. Tsí viꞌi a vé ne, koo iꞌxá ña dɨꞌɨ̄ ó Isabeé ne, Juaan kunáni. ");
INSERT INTO mizNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ñá te da dīi ñaꞌa san dóo dini ña te káku iꞌxá san. Dɨvīn dɨ, dóo kaꞌnu kuinī ó te káku īꞌxá ñadɨ̄ꞌɨ ó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tsí iꞌxá o ne, dōó kaꞌnu ñaꞌa kúvi nuu Xuva ko. Ntē ña koꞌo iꞌxá san vinu, nté ntute kini kaa. Kunuu tsitū Espíritū Sántū nima í nté dīꞌna dá káku. ");
INSERT INTO mizNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ña sāꞌá ne, vií ña é ñā te da díi ña ñuú Israee nakuntíkɨ̄n ñá Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Diꞌna ña xee ña dá xēe Tóꞌo kō. Dadɨɨ tsi iō ñá é viī ñá vatā o idé profeta Élia, ña é kaꞌán naa Xuva ko kídaā; dadɨɨ tsi nima ñá ni ñā. Vií ña é na nākaꞌan váꞌa iꞌxá san ni ūva i. Vii ña é na ntūváꞌa nima ñá xení i san vata koo é na viī ña é vāꞌa; vií ña é na kōo tûꞌvé ñaꞌa sán tē xee Tóꞌo kō —kaꞌan ánjē san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tsixeꞌe Zacāriá san ánjē san: —¿Nté koo kutuní ko te nuu é ntaā i sáꞌā? Tsí xuꞌú ne, dōo átā ú; ñadɨ̄ꞌɨ́ ko dɨ —kaꞌan Zácaria. ");
INSERT INTO mizNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kidáā ne, kakaꞌan ánjē san: —Grabiee nání u. Xuꞌu é vēꞌxi u é vāta kaa e táxnuu Xuva kō ko é kāꞌán u ni o tūꞌun e dóo vaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Viꞌi a vé ne, tsí ña ni kuintíꞌxe o é kākaꞌán u nī ó ne, kuñɨꞌɨn vē. Ña kúvī ká kāꞌan un tsi da nte te xee táꞌan ntuvi é kāku iꞌxá o, vatā ó kakaꞌán u nī o —kaꞌan ánjē san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nɨɨ dukuān ntantétu ñaꞌa san Zacariá san nu kíꞌi kān. Kidáa ne, tsixeꞌe taꞌan ña, ntákaꞌan ña: —¿Nté kuān nté kakukuií ntu Zacariá san ini ukún kān? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dā ntíi Zacariá san ma ukún kān ne, é ña ni kúvī ká kaꞌan ña. Kidáā né, kūtuni ñáꞌa san é īo é īni ña ini ukún kān. Koó da ntāꞌa ña kakuvi é kākaꞌan ña, tsí kúñɨꞌɨ ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dā inú kava tsiñu é kade Zacariá san ne, kúnūꞌú ña nú viꞌi ña kān. ");
INSERT INTO mizNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Rkontûví ne, ñadɨꞌɨ̄ ñá, Isabeé ne, ñúꞌū iꞌxá ña. Uꞌun xóō é ntē ña vádā mí ni ñēꞌe ña é dé kuení ña: ");
INSERT INTO mizNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Dóo váꞌā o dé Xuva ko nī kó vevii e táꞌxi ña é kōo iꞌxá ko vata koo é ña nantii níꞌnī ká ñaꞌa sán ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Dā kúvi iñu xoó ne, Xuva kō né, taxnūu ña uun ánjē, ñá nani Grābiee é kɨ̄ꞌɨn ña uun ñuu é nani Nazāree, é kāduku ntée ñuú Galilea, ");
INSERT INTO mizNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","é kīkoto níꞌni ña uun ñadɨ̄ꞌɨ kuétsi, ñá nani Māria. Dɨvi ñā ne, e tuví ntetu ña é kani víꞌi ña ni uun ñatīi, ñá nani Jōsee, tatá viꞌi rei Davii. ");
INSERT INTO mizNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kúkɨ̄ꞌvi ánjē san mí tuví ñadɨ̄ꞌɨ́ san ne, kakaꞌan ñá ni ñā: —¡Ntiusi o! Dɨvīn é nakaxnúu Xuva ko ō é naxnuu viko ña o. Dɨvīn ne, dóo nuu méꞌñu Xuva ko ō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Koó dā kúduꞌva ña é kākaꞌan ánjē san ni ña. Da dé kuení mii ñā: “¿Nté kui kuān ó kakaꞌan ñá sāꞌá nī ko?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kidáā ne, kakaꞌan ánjē san ni ña: —Ñá ku uꞌvī ó, Maria, tsí niꞌi o é vāꞌá ntaꞌa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Viꞌi a vé ne, kuꞌun iꞌxá o. Koo uun iꞌxá o, iꞌxá tii é kunani Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dɨvī né, dōó kaꞌnu ñaꞌa kúvi. Kunani īꞌxá Xuva kō, ña e dóo kaꞌnu kueꞌen. Xéꞌe Xuva kō é kuvi ña rei, vata kaa uvata ika ña, rei Dāvii, ");
INSERT INTO mizNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","é kodo nuū ñá iña tatá viꞌi ñá Israeé san ntii dañu ntūvi, é ntē ña ntɨ́ꞌɨ —kaꞌan ánjē san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kidáā ne, katsixeꞌe Mariá san ánjē san: —¿Nté ntu koo kuvi sáꞌā? Tsí xuꞌú ne, ñá te tūvi níꞌi ú ñatīi —kaꞌan Máriá san. ");
INSERT INTO mizNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kidáa kākaꞌan ánjē san ni ña: —Kiꞌxi Espíritū Sántū méꞌñu ō. Xuva kō e dóo kaꞌnu ñaꞌa ña ne, kūnuu méꞌñu kunuu dava ña o. Dāꞌví nuu ña o ntatɨ ñā vata kaa viko san. Dukuān ne, iꞌxa é kaku sán ne, dóo vaꞌa kúvi. Kunani iꞌxá Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Viꞌi a vé ne, ñaviꞌi o Isabeé ne, koo iꞌxá ña dɨ, kuān te dóo ata ñā. Dɨvi ñā e ntákaꞌan ñaꞌa san é ña kuvi koo iꞌxá ña ne, é kīꞌi iñu xoo é ñuꞌu iꞌxá ña vevii. ");
INSERT INTO mizNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tsí Xuva kō ne, ña túvī nee iña é ña kuvi vií ña —kaꞌan ánjē san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kidáā ne, kakaꞌan Mária: —Xuꞌú ne, ña kade tsiñu iña Xuva ko kúvi u. Na vīi Xúva ko nī kó vatā ó kakaꞌan ntó nī ko —kaꞌan ña. Da kidáā ne, kuéꞌēn ánjē san. ");
INSERT INTO mizNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ntuvi tsikán ne, kantɨ́ꞌɨ tsi kueꞌen María, kúntāa ña ñuú mí kaduku ntée Judea. ");
INSERT INTO mizNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kidáā ne, xée ñā nú viꞌi Zacāriá ne, kakaꞌan ñá ni Isābeé ntiusi. ");
INSERT INTO mizNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Dā téku Isabeé san ntiusi ñá ne, kāntá nuu iꞌxá san ini iꞌxí ña kān. Isabeé san ne, nuu tsitu Espíritū Sántū san nima ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kidáā ne, un nɨɨ kuéꞌen ini ña kakaꞌan ñá: —¡Dɨvīn e dií dií ka naxnuu víko Xuva ko ō é un ntɨɨ́ ntɨ̄ɨ́ ñadɨ̄ꞌɨ́ san! ¡É nāxnuu viko ña iꞌxá o é nuu ini iꞌxí o kān dɨ! ");
INSERT INTO mizNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Xoó ntu ñaꞌa kúvi u é vēꞌxí dɨꞌɨ̄ Tóꞌō kó, vexkoto niꞌni ña ko? ");
INSERT INTO mizNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tsí ura tsí i da téku ko ntiusi ó ne, iꞌxá ko ne, kāntá nuu ini iꞌxí ko kān e dóo diní i. ");
INSERT INTO mizNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Nché kuān nche váꞌā o é kākuinchiꞌxe o, tsi sáꞌā ne, kuntaa vátā ó kakaꞌan Xúva ko ni ō! —kaꞌan Ísabee ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kidáā ne, kakaꞌan Mária: Dōó kaꞌnu kuiní ko kuenta iña Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nimá ko ne, dōó nuu dîni kuenta iña Xuva ko, ña é nakākú ko. ");
INSERT INTO mizNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tsí Xuva kō né, ntūntaꞌví ini ña ko, xuꞌu é da kade tsiñu ú iña ña. Un tsi nché vevií ne, é nchii dañu ntūví kaꞌan ñáꞌa san tsi dóo váꞌa ntuvi ko. ");
INSERT INTO mizNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tsí Xuva kō né, dōó iō ña é viī ña; dōó kaꞌnu e táxnūu ña iñá ko. ¡Dɨvi ñā e dóo vaꞌá ña! ");
INSERT INTO mizNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nguentúvi tsi kantuntaꞌví ini ña ñaꞌa, da xōó ka ñaꞌa, ña é kānuní i ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","E nañéꞌe Xúva kō kó tsi dóo kaꞌnu ña; īde ña é ntɨꞌɨ miī é ncho vií ñaꞌa, ña e dóo naꞌnu ñaꞌa kuiní i; ");
INSERT INTO mizNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","naīnu ñá ña é naꞌnu ñaꞌa san, nántaa dūkun ñá ña ntāꞌví san. ");
INSERT INTO mizNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Xéꞌe ña un ntɨꞌɨ̄ é vāꞌa é nchio ñaꞌa, ña é ntátaan núu i. Dá nakūnu ña ña kuiká san, koó da mii ntāꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xnchii ña ñāꞌa ña, ñá Israee, ña kade tsiñu iña ña; ñá ni kūnáa ini ña é ntuntaꞌví ini ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Dukuan ō xeꞌé Xuva ko xūꞌu ñá ni ñata kō, ni Ābraan ni iꞌxá ña, nchii dañu ntūvi. Kuan ō kaꞌan Mária. ");
INSERT INTO mizNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kidáā ne, kátūví Maria ni Isábeé te ūni xoo. Rkontûví ne, kúnūꞌún ña nú viꞌi ña kān. ");
INSERT INTO mizNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Dā kúntaa ntúvī é kāku iꞌxá Isabeé ne, xío ūun iꞌxa tii. ");
INSERT INTO mizNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kidáā ne, kuéꞌen ñaviꞌi ña, kūkoto níꞌni ña ña, tsi dóo kaꞌnu kuīni ña e káku iꞌxá Isabee. Ini ña tsí Tóꞌo kō né, dōo váꞌa ntuvi xéꞌe ña iña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Dā kúvi una ntúvi ne, kueꞌen níꞌi ñā iꞌxá san é kāꞌnté nuu ña un siin kúñū é ixi i, vata ō kaꞌan Xúva kō. Ntīo ñaꞌa san é kunani vata nani uva i Zacāriá ne, ");
INSERT INTO mizNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ntá tsi dɨꞌɨ ī né, kakaꞌan ña: —Ñáꞌā, tsí Juaan kunáni —kaꞌan Ísabee. ");
INSERT INTO mizNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kidáā ne, ntákaꞌan ñáviꞌi ña: —Ntá tsi xoxó ñaviꞌi o, ña é kuan nanī —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dukuān ne, koó dā ntaꞌa ña kakuvi é tsixeꞌe ña ūva iꞌxá san vata koo é kūtuni ña nté koo kunani. ");
INSERT INTO mizNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Uva ī ne, íkan ña uun taꞌvi rkunū ne, da kidáā xntée naꞌa ña é Juaan kunáni. Koó dā kúduꞌva ña ntâñɨ́ san é kuān o xntée naꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ura dúꞌva tsi i nákaꞌan Zácariá san. Eni ntuꞌu ña kākaꞌan ña tsi dóo kaꞌnu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Un ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña ne, koó dā kúduꞌva ña. Da kanɨɨ kāꞌnu ñuú Judeá san e dóo ntákaꞌan ñáꞌa san nté ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Un ntɨɨ́ ntɨ̄ɨ́ ña e téku i ne, da dé kuení mii ñā: —¿Neé ntu é vīi iꞌxá san tē kúkaꞌnu? —kaꞌan ña. Tsí kutuní ñaꞌa san tsi dóo nuu méꞌñu Xuva ko ī. ");
INSERT INTO mizNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacaria, úva īꞌxá san ne, nuu tsitu Espíritū Sántū nima ñá, kakaꞌan ñá túꞌūn é xēꞌé Xuva kō é kāꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Na kāꞌan un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa tsi dóo kaꞌnu Xuva kō, Tóꞌō ña Israee, tsi véꞌxi ñā, vexnákakū ñá ñaꞌa ña! ");
INSERT INTO mizNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tsi táxnūu ña ña e dóo ntii inī i é nakakū ñá kō, uun iꞌxá ika rei Dāvii, ña é dé tsiñu iña Xuva ko, ");
INSERT INTO mizNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","vata ō táꞌxi Xuva ko xūꞌu ña nte ntúvi diꞌna, vata ō ntákaꞌan ñá kaꞌán naa ña, ña e dóo vaꞌa: ");
INSERT INTO mizNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","é nantii ña kō míꞌī ntaínchuꞌvi ñáꞌa san ko, nī mí ntáde xení ña ni kō, ");
INSERT INTO mizNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","é ntuntaꞌví ini ña ni ñata kō, ña intóo ntuvi diꞌna, é ntē ña kunánī ña é kada ntáa ña nuu i e dóo vaꞌa é kākaꞌan ñá ni ñā kídaā. ");
INSERT INTO mizNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dɨvi nuū i é kākaꞌan Xúva kō nte ntúvi diꞌna ni uva ata ko Ābraan tsí nuu é ntaā i é viī ña é kākaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","é nakāku ñá ko ntaꞌa ña ntaínchuꞌvi ko vata koo é vīi o nee iña é kākaꞌan ña, é ntē ña uꞌví kō, ");
INSERT INTO mizNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","vata koo é kuvi kuntoo dadɨɨ o ni ñā é vīi ó nee iña é vāꞌá da kanɨɨ ntuvi kō. ");
INSERT INTO mizNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Dɨvin, īꞌxá miī kó, viꞌi a vé ne, káꞌan ntōdon túꞌun Xuva kō, ña é dií ka kaꞌnu, tsí dɨvīn ne, kɨ́ꞌɨn kodōn núun nuu Xuva ko, viin é koo túꞌve ñaꞌa san te xee míi Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dɨvin kuēꞌen é kūtuni ñáꞌa ña tsí nakate Xuva ko kuētsí ña vata koo é nakáku ña. ");
INSERT INTO mizNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tsí Xuva kō né, dōó kantuntaꞌví ini ña kō né, taxnūu ña iꞌxá ña nte e dukún kān vata kaa ntuve ngántii é kakene tevaá duꞌva tsi, ");
INSERT INTO mizNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","vata koo é nāxiꞌí nuu ña iña ñá ntoo mi dóo nee, mí katāvi núu ña ntatɨ̄ doxiꞌi. Nañēꞌe ñá ko ītsi mí kaka ō vata koo é kūntoo váꞌa o. Dukuan ō kaꞌan Zacária. ");
INSERT INTO mizNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kūkaꞌnu Juaán san ne, dōo kutúꞌve ña iña Xuva ko. Má kūꞌu kan inúu ña un tsi da nté xee ntúvī é kiī ña é kīní ña Israeé san ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ntuvi tsikán ne, taxnūu Césa Agustu túꞌūn da míꞌī ká ñuu é uve taꞌan ñūú Roma, kakaꞌan ña é na nākuvé naꞌa un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sáꞌā e kúvi uun ito é nakuvé naꞌa ñáꞌa san dá nūu Círeniu, kade kúꞌvē ña ñuú Siria. ");
INSERT INTO mizNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa ntánuꞌu ña ñuú ña é nākuvé naꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Dukuān né, ntīi Jósee ñuú Nazaree é kāduku ntée Galilea. Kidáā ne, kuéꞌen ña ñūú Beleen é kāduku ntée Judea, ñuú mí káku rei Davii, tsí Joseé ne, dɨvi tātá viꞌi Davii ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kuéꞌen ña, ntūvi ñá ni Māria, tsí dɨvi ñā é kūntaa túꞌun ñā é kani viꞌi ña ni Jōsee. Maria sán ne, é ñūꞌu iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Da nɨɨ̄ ntoo ña ñuú Beleén ne, xée ntūvi é kāku iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ikān káku iꞌxá ña, iꞌxá nuu i. Náxtīnuu ñá i doo ne, dā xnúu ña i ini etun mí ñūꞌu e ntaéꞌxí kɨtɨ, tsí ña vádā ka mí vāꞌá o é kuntōo ña iní viꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Etsin ñuú Beleén ne, ñuꞌu paxtu má kūꞌu kan, ntáde ñā kuenta léꞌntú ña niñú san. ");
INSERT INTO mizNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dā née inī ña, xéē ánje Xuva kō mí ñūꞌu ña. Nāxiꞌí nuu Xuva ko ntuve ñā kanɨɨ ntíkō diñɨ i mí ñūꞌu ña ne, dōo uꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ntá tsi kakaꞌan ánjē san ni ña: —Ñá ku uꞌvī nto. Tsi dóo vaꞌá túꞌun nīꞌi ú ve. Núu i sāꞌa é kūntoo dínī nto, un ntɨꞌɨ kueꞌen dúꞌva nto, vata kaa nto é ntoo nto ñuxiví san. ");
INSERT INTO mizNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tsí ñuu Dávií ne, é kāku uun iꞌxa é nakakū nto. Dɨvi Crīstu; dɨvi ñā é Tóꞌo kō. ");
INSERT INTO mizNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Vata koo é nāniꞌi nto iꞌxá san ne, naniꞌi nto i kátīnuu dóo, nuu ntaá ini etun mí ñūꞌu e ntaéꞌxí kɨtɨ —kaꞌan ánjē san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ura tsikán ne, ñá te da dīi ánjē san ntii díto ña, e ntákaꞌan ña e dóo kaꞌnu Xuva kō: ");
INSERT INTO mizNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Dōó kaꞌnu kueꞌen Xúva kō, ña tuví e dukún kān! ¡Ñuxiví a ne, váꞌa koo kuntōo ñaꞌa, ña e dóo vaꞌá iña Xuva ko! kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kidáā ne, kuntāa ánjē san e dukún kān. Paxtú san ne, eni ntuꞌu ñā ntákaꞌan ñá xe un xé un ñā: —Kɨ́ꞌɨn o Bēleén ve, kíkoto ntódo ō nee iñá ntu é kākuvi é tāꞌxi Tóꞌo ko kūtuni ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kantɨ́ꞌɨ duꞌva tsi kueꞌen ña, kunantúku ña Maria ni Jósee ni iꞌxá san. Dā nániꞌi ña ñá ne, ikān nuu ntaa iꞌxá san ini etun mí ñūꞌu é ntaéꞌxí kɨtɨ san. ");
INSERT INTO mizNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dā íni ña i ne, ntántaa ña nté o kakaꞌan ánje ni ñā iña iꞌxá san. ");
INSERT INTO mizNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Un ntɨɨ́ ntɨ̄ɨ́ ña téku i ne, koó dā kúduꞌva ña é kuān o ntákaꞌan páxtú san. ");
INSERT INTO mizNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ntá tsi María sán ne, xnuu váꞌa ña nima ñá é un ntɨꞌɨ̄ é dé kuení ña nuu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Dá kūnúꞌu paxtú san ne, ntaíta ña nchuꞌún Xuva kō ntánakuéꞌe ña sintiáꞌvi ntaꞌa ña kuenta iña i un ntɨɨ́ ntɨ̄ɨ é téku ña nī e íni ña, tsí kúntaa un ntɨɨ́ ntɨ̄ɨ́ vatā ó kakaꞌan ánjē san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dā kúvi una ntúvi ne, ēꞌnté nuu ña un síin kúñū é ixi iꞌxá san vatā xkoó ini ña. Kidáā ne, xntánteē ñá i é Jēsuu kunáni, dɨvi dɨ̄vi é kākaꞌan ánjē sán ni Māría nte díꞌna dá kūꞌun iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Dā xee táꞌan ntuvi é ntuntoo ña, vatā ó kakaꞌan lei Muíseé ne, kueꞌen níꞌi ña īꞌxá san ñuú Jerusaleen é ntāda ña i kuenta ntáꞌa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dé ntaa ña sáꞌā, tsí kuān ó kakaꞌan lei íña Xuva ko: “Un ntɨɨ́ ntɨ̄ɨ íꞌxa tii, iꞌxa nuu í ne, kuntoo xio kuenta iña Xuva ko”, kaꞌán leí san. ");
INSERT INTO mizNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kuéꞌen ña, kūntído ña doméni nú nāa kán dɨ, vatā ó kakaꞌán lei íña Xuva ko: uun naꞌa paloma ntɨ́kɨ́n o ūvi páloma naꞌnu. ");
INSERT INTO mizNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ntuvi tsikán ne, kátūví uun ñatīí ñuú Jerusaleen, ñá nani Sīmiuun ña e dóo vaꞌá ñaꞌa, e dóo kanuu iní ña Xuva kō. Kantétu ña amá kiꞌxi ña nakākú ñuú Israee. Espíritū Sántū sán tuvī niꞌi ñá Simiuún ne, ");
INSERT INTO mizNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","xéꞌe ñā é kūtuni Símiuun tsí ña kuví ña tē ña diꞌna kiní ña Cristu, ña táxnuu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kidáā ne, kuéꞌen ñā má ūkún kān, tsí Espíritū Sántū sán ne, náñēꞌe ñá ña é kuān koo vií ña. Dɨvi tsi ntuvi tsīkan kuéꞌen niꞌi Jóseé san ni Māríā san iꞌxá ña Jesuu má ūkún kān dɨ é ntāda ñá i kuenta vátā ó kakaꞌan leí san. ");
INSERT INTO mizNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kidáā né, kīꞌi Simiuún san i, iníꞌi nteé ña i ne, dā kidáa kākaꞌan ntâꞌví ña ni Xuva kō, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Xuvā kó, viꞌi a vé ne, é vāꞌá o é tāꞌxi nto itsi é na kūví u ve, tsi é kuntaa vatā ó kakaꞌan ntó nī ko. ");
INSERT INTO mizNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","É īní u nuú ko ve, ña e véxnakākú ntɨ, ");
INSERT INTO mizNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ña e táxnūu nto é kīni un ntɨɨ́ ntɨ̄ɨ ñá ntoo ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Dɨvi ñā naxiꞌí nuu ña ñuxivi vata kaa ñuꞌu é kaxiꞌí nuu nuu ko. Dōo xiꞌí nuu kaꞌnu ña iña ñaꞌa nto, ña ñuú Israeé san dɨ. Kuan ō kaꞌan Símiuun. ");
INSERT INTO mizNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Uva Jēsuu ni dɨ́ꞌɨ ñā ne, koó dā kúduꞌva ña da téku ña é kākaꞌan Símiuun íña iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kidáā né, nāxnuu viko Simiuún san ña ne, dá kakāꞌan ñá ni Māría, dɨꞌɨ Jēsuu: —Koton tsí iꞌxa saꞌá ne, véꞌxī é vīi e dóo tɨtɨ́n ñaꞌa ña Israee sán ne, kóꞌxo ñā né, ō nakuntáñɨ̄ ñá kuenta iña i. Dōó tɨtɨ́n ñaꞌa san koto ña i ne, nantii niꞌni ña i, ");
INSERT INTO mizNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","vata koo é dukuan koo kūtuni nté ō ntádē kuení ntiꞌxe ñaꞌa san. Dɨvīn dɨ́, dōo uꞌvi kuvi ó, vata tē káā é ūvi nuu i niꞌni ntído nima ó dɨ —kaꞌan Símiuún san ni Māríā. ");
INSERT INTO mizNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Íkān ntitsi úun ñadɨ̄ꞌɨ́, ña e dóo atā, ñá nanī Ana, ña é kaꞌán naa Xuva ko. Iꞌxá Fanuee, tatá viꞌi Asee. Dutsi kuia ña tántaꞌa ña ne, uꞌxe kuía tsi īntóo niꞌi taꞌan ña ni xɨ̄ɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","É īta ntíꞌxin kɨmi díko kɨmi kuia é ntukíi ñā. Ñá nī ntíi kuēꞌen ña má ūkún kān. Ntē ntúvi ntē níñu kanuu iní ña Xuva kō ne, kaitúvi ixu ña ne, kakaꞌan ntâꞌví ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ura dúꞌva tsi i xeé Aná san mí ntōo ña ne, eni ntuꞌu ña kānakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō, ne, kakaꞌan ñá iña iꞌxá san ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, ña ntantétu xoo é xee i é nakakū ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kidáā ne, da kúvi dé ntaa ntɨ́ꞌɨ ñā é kākaꞌán lei Xúva kō ne, kúnūꞌú ña ñuú Galilea, un tsi nté ñuú mii ñā, mí nani Nazāree. ");
INSERT INTO mizNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ikān éni ntuꞌu iꞌxá san éꞌnu. Dōó ntii éꞌnu. Dōó kiꞌin inī i. Dōo kuínima Xúva ko ī. ");
INSERT INTO mizNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kuia kuía ntáñeꞌe uva Jēsuu ni dɨꞌɨ ñá ñuú Jerusaleen dá kakuvi viko da nátava Xuva kō ña Israee ñuú Egítō. ");
INSERT INTO mizNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Dā xee táꞌan uxuvi kuía Jesuú ne, kuéꞌen ntɨ̄ꞌɨ ña ñuú Jerusaleen váta xkoó ini ña da kaxío viko san. ");
INSERT INTO mizNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Dā inú kava viko sán ne, ítuvī mii Jésuu Jerusaleen, é ntē ña ni iní dɨꞌɨ ñā, nté uva ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Te kūntíꞌxi iꞌxá ña méꞌñu ñāꞌa san, kuíni ña. Uun ntuvi va váꞌa ñúꞌu ña ītsi da kútuni ña é ña te ntīkɨ́n ntu iꞌxá ña ña. Kidáā ne, eni ntuꞌu ña nántuku ña ñā méꞌñu ñāviꞌi ña ni ña ini ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ñá ni nāniꞌi ñá ña. Kidáā né, ntiko kōo xtúku ña, kueꞌen ñá, kūnantúku ña ña ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dā kúvi uni ntúvi ne, nāniꞌi ñá ña ini ukún kān. Ntoo niꞌi ña mastrú lei, kaini ña e ntákaꞌan ñá ne, katsixeꞌe Jēsuú san ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Un ntɨɨ́ ntɨ̄ɨ́ ña e téku i ne, koó dā ntákuduꞌva ña, tsi dóo ntíto Jesuú san ne, dōó ini ña nté koo nantiko kōo ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Dā íni uva ñā ne, koó dā kúduꞌva ña. Dɨꞌɨ ñā né, kakaꞌan ña: —Iꞌxá miī ko, ¿nché kui kuān o dén ntun nī ntɨ? ¿Ñá inin ntun tsí ntuví ntɨ uva ō né, dōo ntántɨꞌɨ iní ntɨ ntánantukū ntɨ́ o? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kidáā ne, kakaꞌan Jésuu ni ña: —¿Nté kui ntánantuku ntu ntō ko? ¿Ñā ntu íni nto tē kantio é iꞌa kutūví u má viꞌi Uvā ko? —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ntá tsi ña ni ñéꞌe dɨkɨ ñā nee iña é kākaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kidáā ne, kúnūꞌú Jesuu ni úva ñā ñuú Nazareé ne, dē ntaa ntɨ́ꞌɨ ña nēe e teé tsiñu uva ña ñā. Dɨꞌɨ ñā ne, xnuu váꞌa ntɨꞌɨ ña sáꞌā nima ña. ");
INSERT INTO mizNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesuú ne, kuéꞌēn éꞌnu ña. Dōo kúkiꞌin inī ñá dɨ. Dōo kuínima Xúva ko ña, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Dā kúvi xeꞌun kuia é īdé Tiberiu ña é kadē kûꞌve un ntɨɨ́ ntɨ̄ɨ ñuú é kāduku ntée Romá ne, kidáa odo nūu Poncio Pílatu ñuú Judeá ne, odo nūu Heródē ñuú Galileá dɨ. Ení Heródē, ñá nani Fēlipé ne, odo nuū ñá ñuú Traconite ni ñūú Ituriá dɨ. Ña nani Līsaniá ne, odo nuū ñá ñuú Abilinia. ");
INSERT INTO mizNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anaa ni Caífaa ne, ntáde ña dutu ñá odo nūu. Ntuvi tsikán ne, xée tūꞌún Xuva kō ntaꞌa Juaan Bautista, iꞌxá Zacaria, mí tuví ña ñuu itsí kān. ");
INSERT INTO mizNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kidáā ne, kuéꞌēn Juaán san, ita ntíꞌxin ña dá kanɨɨ dīñɨ ntute kaꞌnu é nani Jōrdaan, kakaꞌan ntódo ña ni ñāꞌa san é na nātɨvi iní ña kuétsi ña ne, na kūtsi ntute ña dɨ, vata koo é na kāda kaꞌnu iní Xuva ko ni ña kuētsí ña. ");
INSERT INTO mizNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sáꞌā kúvi vata ō xnteé naꞌa ña kaꞌán naa Xuva ko, ñá nani Isāia, kakáꞌan ña: Xée ñūu îtsí kān uun tatsin é un ntii tsi kākaꞌan: “Nākoo túꞌve ntó itsi Xuva kō; nakaán nuu nto itsi ntaa mí kɨ̄ꞌɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Un ntɨɨ́ ntɨ̄ɨ́ xɨꞌntɨ́ ne, ntadɨ́ nuu. Míꞌi īó xuku ni tɨꞌɨ̄ í ne, ntuntaa. Itsi mi dóo nakutáꞌnu ne, ntuntaá dɨ. Itsi mí ña váꞌā o ne, ntuváꞌa dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kidáā ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san kiní ña ña é taxnúu Xuva kō é nakakū ñá kō”, kuan ō kaꞌan tatsín san. Duꞌva ō kaꞌan Isáiá san. ");
INSERT INTO mizNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ñá tē nté kaa ñaꞌa xée ña mí tuví Juaan é ntio ña é nakūtsi ntute ña ña ne, kakaꞌan Juaán san ni ñā: —¡Ntōꞌo é tatá koo nto e dóo kīni ntáa nto! ¿Xóo ntu kakāꞌán i ni ntō é kūvi nakáku nto é ntōꞌo nto é taꞌxi Xuva kō ve? ");
INSERT INTO mizNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Váꞌa tsī koo vií nto vata koo e díto é nadama ntiꞌxe nima nto. Ñá ku kaꞌān ntó ni tāꞌan nto: “Xoꞌō né, tatá viꞌi Abraan o”. Kakaꞌán u tsí Xuva kō ne, kuvi ntada ña xuu tatá Abraán tē dɨ́ ntio ña. ");
INSERT INTO mizNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dukuān ne, é iō tuꞌve káa ntee é nakɨ̄ɨn ntɨꞌɨ ña utun sán un tsi nte nú ditsin i. Un ntɨɨ́ ntɨ̄ɨ́ utun é ña kakíi kɨtɨ vāꞌá i ne, katsin ña ne, dá kāꞌmí ña —kuān o kaꞌán Juaán san ni ñāꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kidáā né, tsixeꞌe ñāꞌa san ña: —¿Ntē ntú koo vií ntɨ kuan? —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dá kakāꞌan Juaán san ni ñā kídaā: —Xoo é īó uvi duꞌnu i ne, na kuēꞌé ña kunūu tuku ñaꞌa, ña é ña tuvi dúꞌnu i. Tē xoo é īo é kaeꞌxí i ne, na kuēꞌé ña dava na kāꞌxí ñaꞌa, ña é ña tuvi é kāꞌxi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Véꞌxī ña ntaído diuꞌun xôó dɨ é kūtsi ntute ña ne, dā tsíxeꞌe ñā Juaan: —Mastrú, ¿ntē ntú koo vií ntɨ dɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ne, dá kakāꞌán Juaan: —Ña kuído nto vata kaa ntaído nto diuꞌun xôó san; mii tsī é kuido nto vatā ó kakaꞌan leí san —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sntadún san dɨ́ ne, tsixeꞌe ñā dɨ: —Ntɨꞌɨ́ ni, ¿ntē ntú koo vií ntɨ? —kaꞌan ña. Ne, kakaꞌán Juaan: —Ña kuído dúꞌu nto nté uun iña ñaꞌa; ntē ña ku nauꞌví nto ña. Ntē ña ku daꞌví nto ña dovete tē ña te neé kade ña. Ñá kākán ka nto xáꞌvi nto, tsí e dɨ́vi tsī é kaniꞌi nto —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ñaꞌa sán ne, ntaítsuꞌun ñā ntantétu ña. Ntádē kuení mii ña tē nté kaa ne, Juaán san é Cristu ña. ");
INSERT INTO mizNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ntá tsi Juaán san ne, kakaꞌan ñá ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san: —Xuꞌú ne, kūdii ntute kadáꞌvi ú nto da kanakūtsi ntute ú nto ne, ntá tsi véꞌxi ūun ñaꞌa, ña e dií dií ka kaꞌnu é xuꞌu, é ntē ña kainuu áꞌvi ko é nantúte ú xoꞌo ntiꞌxen ña. Dɨvi ñā ne, ñá tē ntúte dāꞌvi ñá nto, tsí Espíritū Sántu sán dāꞌví nuu ña nto, ni ñūꞌu é kaiꞌxi. ");
INSERT INTO mizNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dɨvi ñā né, niꞌi ntaꞌa ña ūtun é kāni ña trigu é nātsoo xio ña xáka i. Nātsuꞌun váꞌa ña trigú san ini aka ña, ntá tsi kaꞌmi ña xáka san méꞌñu ñūꞌú san mí ña ntáꞌva —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ne, tɨtɨ́n ka nuu i é kākaꞌán Juaán san ni ñāꞌa san dá kakaꞌan ntódo ña ni ñā túꞌūn vaꞌá san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ntá tsi de tíi Juaán san nī ña tsiñu kaꞌnu i, ña Heródē, tsi nákiꞌi Heródē san ñadɨ́ꞌɨ ení ña Felipe, ñá nani Herōdia. Dē tíi ña ni ñā kuenta iña é un ntɨꞌɨ nuū i é kīni kaa é idé ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ntá tsi dā téku Heródē ne, tuku nuu i idé túku ña: tsí xnúu kutu ñā Juaán san viutun. ");
INSERT INTO mizNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dá kanakūtsi ntute Juaán san un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, ītsi ntute Jesuu ntáꞌa Juaán san dɨ. Dá kakāꞌan ntâꞌví Jesuú ne, ura dúꞌva tsi nákaan xíꞌi e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dítō tsi véꞌxi daxi daxi Espíritū Sántū san vata kaa paloma é nākuntéku dɨkɨ ñá ne, dā téku ña uun tatsín e dukún kān é kākaꞌan: —Dɨvīn é iꞌxá miī kó e dóo ntio ko. Dɨvīn é nakaxnúu ú o —kaꞌan tátsín san ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","É kūvi oko uꞌxi kuia Jésuú san da éni ntuꞌu ñā edé tsiñu ña. Dɨvi ñā né, iꞌxá Josee ña, kuíni ñaꞌa san. Joseé san ne, iꞌxá Elii. ");
INSERT INTO mizNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elií san ne, iꞌxá Mataa. Mataá san ne, iꞌxá Levii. Levií san ne, iꞌxá Melqui. Melquí san ne, iꞌxá Jana. Janá san ne, iꞌxá Josee. ");
INSERT INTO mizNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseé san ne, iꞌxá Matatia. Matatiá san ne, iꞌxá Amoo. Amoó san ne, iꞌxá Nauun. Nauún san ne, iꞌxá Eli. Elí san ne, iꞌxá Nagai. ");
INSERT INTO mizNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaí san ne, iꞌxá Maa. Maá san ne, iꞌxá Matatia. Matatiá san ne, iꞌxá Semei. Semeí san ne, iꞌxá Josee. Joseé san ne, iꞌxá Judaa. ");
INSERT INTO mizNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judaá san ne, iꞌxá Juanaan. Juanaán san ne, iꞌxá Resa. Resá san ne, iꞌxá Zorobabee. Zorobabeé san ne, iꞌxá Salatiee. Salatieé san ne, iꞌxá Neri. ");
INSERT INTO mizNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerí san ne, iꞌxá Melqui. Melquí san ne, iꞌxá Adi. Adí san ne, iꞌxá Cosan. Cosán san ne, iꞌxá Elmadaan. Elmadaán san ne, iꞌxá Ee. ");
INSERT INTO mizNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eé san ne, iꞌxá Jesuu. Jesuú san ne, iꞌxá Eliezee. Eliezeé san ne, iꞌxá Joriin. Joriín san ne, iꞌxá Mataa. ");
INSERT INTO mizNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Mataá san ne, iꞌxá Levii. Levií san ne, iꞌxá Simiuun. Simiuún san ne, iꞌxá Judaa. Judaá san ne, iꞌxá Josee. Joseé san ne, iꞌxá Jonaa. Jonaá san ne, iꞌxá Eliaquiin. ");
INSERT INTO mizNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquiín san ne, iꞌxá Melea. Meleá san ne, iꞌxá Mena. Mená san ne, iꞌxá Matata. Matatá san ne, iꞌxá Nataan. ");
INSERT INTO mizNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nataán san ne, iꞌxá Davii. Davií san ne, iꞌxá Isaii. Isaií san ne, iꞌxá Obee. Obeé san ne, iꞌxá Boo. Boó san ne, iꞌxá Sala. Salá san ne, iꞌxá Nasuun. ");
INSERT INTO mizNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasuún san ne, iꞌxá Aminadaa. Aminadaá san ne, iꞌxá Amiin. Amiín san ne, iꞌxá Arni. Arní san ne, iꞌxá Eruun. Eruún san ne, iꞌxá Fare. Faré san ne, iꞌxá Judaa. ");
INSERT INTO mizNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judaá san ne, iꞌxá Jacoo. Jacoó san ne, iꞌxá Isaa. Isaá san ne, iꞌxá Abraan. Abraán san ne, iꞌxá Taree. Tareé san ne, iꞌxá Nacoo. ");
INSERT INTO mizNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacoó san ne, iꞌxá Seruu. Seruú san ne, iꞌxá Ragau. Ragaú san ne, iꞌxá Pelee. Peleé san ne, iꞌxá Hebe. Hebé san ne, iꞌxá Sala. ");
INSERT INTO mizNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salá san ne, iꞌxá Cainaan. Cainaán san ne, iꞌxá Afasaa. Afasaá san ne, iꞌxá Seen. Seén san ne, iꞌxá Noee. Noeé san ne, iꞌxá Lamee. ");
INSERT INTO mizNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameé san ne, iꞌxá Matusaleen. Matusaleén san ne, iꞌxá Enoo. Enoó san ne, iꞌxá Jaree. Jareé san ne, iꞌxá Malalee. Malaleé san ne, iꞌxá Cainaan. ");
INSERT INTO mizNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainaán san ne, iꞌxá Enoo. Enoó san ne, iꞌxá See. Seé san ne, iꞌxá Adaan. Adaán san ne, iꞌxá Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesuú ne, nuu tsitu Espíritū Sántū sán nima ñá, ntiko koō ña é ñeꞌē ña nú ntute kaꞌnu é nani Jōrdaan. Kueꞌen níꞌi Espíritū Sántū san ña, kuéꞌen ña ñūu îtsí kān mí xoxó ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ikān itúvi ña uvi díko ntuvi ne, ntá tsi tóꞌō e ña váꞌā san ne, īto nteé ña. Ñá ni ēꞌxí kueꞌen ña ntuvi é itúvi ña ikān. Dā rkontûví ne, kākɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kidáā né, kakaꞌan tóꞌō e ña váꞌā san ni ña: —Tē nuu é ntaā i é iꞌxá Xuva ko ō né, viin é nantūvi xuu sáꞌa tañúꞌū —kaꞌan tóꞌō e ña váꞌā san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ña: —Tūꞌún Xuva kō ne, kakaꞌan: “Ñá te da mii tsi tāñúꞌū san kantío ñaꞌa san, tsí kantio ña un ntɨꞌɨ̄ túꞌūn é kākaꞌan Xúva kō”, kaꞌan —kaꞌan ñá ni ī. ");
INSERT INTO mizNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kidáā ne, kúxee niꞌi tóꞌō e ña váꞌā san ña uun itsi mi dóo dūkun. Uun daꞌna tsi nañéꞌē ña un ntɨɨ́ ntɨ̄ɨ́ ñuu é īó da kanɨɨ ñūxiví ne, ");
INSERT INTO mizNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","kakaꞌan ni Jésuú san: —Xuꞌú taꞌxi u é kadā kûꞌven dá kanɨɨ ñūxiví san. Taꞌxi u é un ntɨꞌɨ̄ e dóo vaꞌá san é kūví iña o. Tsí xuꞌú ne, é ntūvi kuenta ntáꞌa ko é un ntɨꞌɨ̄ sáꞌā ne, kuéꞌē ú da xōó ka tsi é ntio ko. ");
INSERT INTO mizNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Te nakūnchɨ́tɨn nūú ko ne, te kunūu ini ó ko ne, é un ntɨꞌɨ kūvi iña o —kaꞌan ni Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ñá ni ī: —Tūꞌún Xuva ko ne, kākaꞌan: “Kunūu ini o Tóꞌo o Xuva ō. Da mii tsi ñā é kuīntiꞌxe o ña”, kaꞌan —kaꞌan ñá nī tóꞌō e ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kidáā ne, kueꞌen níꞌi tóꞌō e ña váꞌā san ña ñuú Jerusaleen. Nakáa ñā dɨkɨ xúkun kaꞌnu míꞌī e dií dií ka dukún ne, dá kakāꞌan ni ña: —Tē nuu é ntaā i é dɨvīn é Iꞌxá Xuva kō ne, nakōꞌxón nuun kúñu ō un tsi nte íꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tsí kakaꞌan túꞌun Xuva kō: Tsí taxnūu ña ánje ñā é viī ñá o kuenta, é kūnuu méꞌñu kūnuu dava ña o. ");
INSERT INTO mizNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kūrkaa ánjē san o, vata koo é ña nákɨꞌɨn nté uun xuu, kaꞌan —kaꞌan tóꞌō e ña váꞌā san ni Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ne, nántiko kōó Jesuu, kakáꞌan ñá ni ī: —Duꞌvā ó kakaꞌan túꞌun Xuva kō dɨ: “Ñá ku ntē dúkuan kōto nteen Tóꞌo o Xuva ō”, kaꞌan —kaꞌan ñá nī é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Dā ña ni kuvi vii tóꞌō e ña váꞌā san nté koo vii é kōꞌxó ntēé Jesuú ne, kīi nteé xio, kueꞌen. ");
INSERT INTO mizNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nāxee Jésuu ñuú Galilea, nuu tsitu nima ñá Espíritū Sántū san é viī ñá tsiñu ña. É da míꞌī ká ñuú ntákaꞌan ñáꞌa san íña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nakuáꞌa ña ñāꞌa san taꞌán ñuu taꞌán ñuu má viꞌī mi ntánataká nuu ña Israee. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntákaꞌan ñá e dóo vaꞌá Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kidáā né, nāxee Jésuu ñuú Nazaree, mí éꞌnu ña. Ntuvi dá iō dáꞌna ne, kuéꞌen ñā má viꞌī mí nataká nuu ña Israee váta xkoó ini ña. Nákuntītsí ña é nakuāꞌa ña túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Xéꞌe ña ña tūtu é de váꞌa ña kaꞌán naa Xuva ko, ñá nani Isāia. Nākaán ña ne, nāniꞌi ña mí duꞌvā ó kakaꞌan: ");
INSERT INTO mizNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu Xuva kō ne, nuu méꞌñu nuu dava ña ko, tsí dɨvi ñā teé tsiñu ña ko é kāꞌán u túꞌūn é vāꞌá ni ña ntāꞌvi. Dɨvi ñā táxnūu ña ko é kāꞌán u ni ña ñuꞌu kutū nté koo nakáku ña, nī é nākaán u ntuxnúu ña kuāa, nī é nakākú u ña ntáde xení ñaꞌa ni ī, ");
INSERT INTO mizNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nī é kāꞌán u tsi é xee ntúvi e dóo vaꞌá koo vií Xuva ko ni ñāꞌa. Kuān ó kakaꞌan túꞌūn é nakuāꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kidáā ne, naxtínuu Jesuu tútú san ne, dā nakuéꞌe ña ña kaxntiī nú viꞌī mi ntánataká nuu ña ne, nákutūví xtuku ña. Un ntɨɨ́ ntɨ̄ɨ́ ña ntoo sán ne, ntaíto ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kidáā ne, éni ntuꞌu Jēsuu kakáꞌan ñá ni ñā: —Tūꞌún saꞌá ne, é vevii é kākuntaa vata kaa e téku nto dá kanakuāꞌa ú nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, váꞌā ó ntákaꞌan ñá iña Jésuu. Da kúduꞌva ña é kuān nte váꞌā ó kakaꞌan ña. Ntatíin mii ñā, ntákaꞌan ña: —¿Ñā ntu te iꞌxá Josee ñá sāꞌa? —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dá kakāꞌan Jésuu ni ña: —Ncho kaꞌan ntó nī kó vatā ó ntákaꞌan ñáꞌa san: “Tē nuu é ntaā i é medíku ntō ne, ntaváꞌa mii ntō kúñu ntō.” O ncho kaꞌan ntó nī ko: “Vatā o téku ntɨ́ nēe é idé nto ñuú Capernaú ne, kuān koo vií nto iꞌa dɨ, ñuú mii ntō”, te kuan kōo é ncho kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ʼNuu é ntaā i é kākaꞌán u tsi nté uun ñaꞌa ña kaꞌán naa Xuva ko ne, ñá ntīo ñaꞌa san, ña ñuú mii ñā, é kīni ña túꞌūn é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nuu é ntaā i é kākaꞌán u tsi ñá te da dīi ñadɨꞌɨ́ kií san ntoo ña ñuú Israee ntuvi da itúvi Elia. Dā kidáā ne, ña ni kɨ́ɨn kuēꞌen tsi davi uni kuia nte dáva ne, dōo kútama ñaꞌa san da kanɨɨ ñūú san. ");
INSERT INTO mizNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ntá tsi ña ni taxnúu Xuva kō Eliá san e kixntíi ña ñadɨ̄ꞌɨ kii, ña ñuú Israee, tsi táxnūu ña ña é kixntíi ña uun ñadɨ̄ꞌɨ kii, ña ñuú Sareta, ñuu é tuvi étsin Siduun. ");
INSERT INTO mizNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ñá te da dīi ña ntákuvi kuiꞌi é kānakoꞌxo kúñu ī ntóo ña ñuú Israee ntuvi da katúvi ña kaꞌán naa Xuva ko, ñá nani Elīseu, ntá tsi nté uun ñaꞌa, ña ntánchokuvi, ña ni ntuváꞌa ña. Tsí mii tsi Nāmaan, ña ñuú Siria, ntuváꞌa ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ntá tsi ña ntoo iní viꞌi mí nataká nuu ña Israeé ne, un váꞌa tsi kúdiin ña dā téku ña é kuān ó kakaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nákuntāñɨ́ ñaꞌa sán ne, nakunu ña Jesuu ñuú ña. Kueꞌen níꞌi ña ñā rkɨ uku é nakōꞌxó nuu ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ntá tsi kíi niꞌni Jēsuu méꞌñū ñaꞌa san, kuéꞌen ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesuú ne, kuéꞌen ña ñūú Capernau é tuví ñuú Galileá ne, ikan kanakuāꞌa ña ñáꞌa san ntúvi dá iō dáꞌna. ");
INSERT INTO mizNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Koó dā kúduꞌva ñaꞌa san túꞌūn é kanakuāꞌa ña ña, tsi dóo ini Jesuu nee é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Má viꞌī mí nataká nuu ña Israeé san ne, tuví uun ñatīi, ña é nuu é ña váꞌā nima í ne, un ntii tsi kākaꞌan: ");
INSERT INTO mizNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Na koo mii ntō ntɨ! ¿Neé ntu viī ntó nī ntɨ́, Jesuu, ña ñuú Nazaree? ¿Vēꞌxí ntu nto é nākunaá nto ntɨ? Xuꞌú ne, iní u nto, tsí dɨvi ntō e dóo vaꞌá nto iña Xuva ko —kaꞌan ni Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kidáā ne, de tíi Jesuu ni é ña váꞌā san, kakaꞌan ñá ni ī: —¡Diin tsi kutūvin! ¡Ntiin nima ñátīí sāꞌa! —kaꞌan ñá nī e ña váꞌā san. Kidáā né, un ntii tsi nāntava é ña váꞌā san ña ñuꞌu kan, méꞌñū un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san da ntíi nima ña. Ntē ña ni níꞌi kuiꞌí ña da ntii é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Dōo uꞌví ñaꞌa san un ntɨɨ́ ntɨɨ̄ ñá da íni ña. Ntátsixeꞌe taꞌan mii ñā: —¿Neē ntú tuꞌun sáꞌā? Ña sāꞌá ne, ¿nté kui dóo iō ña é viī ña? Tsi dá mii tsi kākaꞌan ñá ne, kūvi idé ña nakúnu ña é ña váꞌā san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Da míꞌī ká ñuú san ntákaꞌan ñá iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kidáā ne, nákuntītsí Jesuu, ntáka ña viꞌi mi ntánataká nuu ña Israeé san ne, kuéꞌen ñā nú viꞌi Sīmuun Pedru. Ikān tuví ñuntɨ́ɨ ña ne, dōo kaxéꞌe ña kaꞌni. Íkan ña dā xeꞌe ntáꞌa Jesuu é na ntāváꞌa ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nákuntēɨ Jesuu nuu ñadɨꞌɨ́ san mí tuví ntaa ña ne, kakaꞌan ña é na ntīkó kaꞌni san. Ura tsí i nakuntítsi ña, da de váꞌa ña é kāꞌxí Jesuu ni ñáꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ura da kaído nuu ngántií san ne, xée ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, xee níꞌi ña ñaꞌa ña, ña ntánchokuví san, mí tuví Jesuu. Dōó tɨtɨ́n nuu kuíꞌi ntákuvi ña. Tɨɨn ntaꞌa Jēsuu ñáꞌa san xe un xé un ñā, ntaváꞌa ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ñá te da dīi ña ntánchokuví san ne, ntīi é ña váꞌā sán nima ña. Koó dā ntákachuꞌu ntáa é ña váꞌā san, ntákaꞌan: —¡Dɨvi ntō é Iꞌxá Xuva ko ntō! —kaꞌan. Ntá tsi de tíi Jesuu ni é ña váꞌā san. Ñá ni xēꞌé ña itsi é kāꞌan, tsí ini tsí dɨvi ñā é Cristu ña, ña e táxnuu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Dā tuví ne, kuéꞌen Jēsuu díñɨ ñūú san mí xoxo ntóo i. Ntá tsi ñaꞌa sán ne, dōo nántuku ña ñā. Xée ñāꞌa san mí tuví ña ne, ñá ni nataxā ñá ña, tsí ña ni ntío ñaꞌá san é kɨ̄ꞌɨ́n ka ña. ");
INSERT INTO mizNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ntá tsi kakaꞌan Jésuu: —Da miī é kɨ̄ꞌɨ́n ka ú xio ñuú san, kikaꞌán u ni ñāꞌa san túꞌūn é vāꞌa iña i mí kadē kûꞌvé Xuva kō, tsí dɨvi tsiñu sāꞌa e táxnuu Xuva kō ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kuéꞌen ñā ne, kukaꞌan ntódo ña ni ñāꞌa má viꞌī mi ntánataká nuu ña Israeé san dá kanɨɨ ñūú Judea. ");
INSERT INTO mizNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Uun ntuvi ne, ntitsí Jesuu díñɨ míni kāꞌnu é nani Genesāree. Ñá te da dīi ñáꞌa xee ña é kīni ñá Jesuu. Un tsi tavi núu ña ñā e dóo ntio ña é kīni ña túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Īní Jesuu úvi tun ntōo íxū é ntoo diñɨ ntute kān ne, ña ntátava tsákā sán ne, é ntii ña tun ntōó san é nakate ña xunu ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kidáā ne, kúxēe Jesuu iní tun ntōo Simuún san ne, dā ikan ñá ña da xeꞌe é na nakɨ̄ꞌɨn íka ká ña iní ntute san tun ntōó san. Kidáā né, eni ntuꞌu ña kākaꞌan ñá ni ñāꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Dā kúvi kaꞌan ñá ni ñāꞌa sán ne, kidáā ne, kakaꞌan ñá ni Sīmuun: —Kuēꞌen niꞌi nto tún ntōó san iní ntute mí kūnú san ne, dá nakuītá nuu nto xunu nto, dá tɨ̄ɨn nto tsákā san —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simuún san ne, kakaꞌan ña: —Mastru, kuéꞌen nīñu vétun é ñūꞌu ntɨ, ntáde tsiñu ntɨ́ ne, nté uun tsákā ña ni níꞌí ntɨ tɨ. Ntá tsi te dɨvi nto kāꞌan ntó ne, nakuītá nuu xtuku ntɨ́ xunú ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kuān o dé ntiꞌxe ña ne, nɨɨ kuēꞌen tsí ñuꞌu tsitu tsákā san xunú ña dā nátavā ña. Dókō sá ni ntātsin tuꞌun xunú ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kidáā né, īde ña ntaꞌa ña ni ñá ñuꞌu tuku tun ntōó san vata koo é kīꞌxi ña, kixntíi ña ñā. Kīꞌxi ña ne, natsítu kuēꞌen ñá ntuvi tún ntōó san. Dókō sá te ni ntīí ntoko tun ntōó ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Dā íni Simuun Pedrú san nté ō kúvi ne, nākunchɨ́tɨ ntāa ña nuu Jésuu, dá kakāꞌan ña: —Kii nteé xio nto ko, Tóꞌō, tsí xuꞌú ne, dōó iō kuetsí ko —kaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tsi dóo ūꞌví Simuún san, ni ūn ntɨɨ́ ntɨ̄ɨ́ ña nguiī san, tsi dóo kueꞌe tsákā táva ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kuan ō kuíni Santiaú san dɨ nī Juaan, iꞌxá Zebedeu, ña é dadɨɨ ntáde tsiñu ni Sīmuún san. Ntá tsi kakaꞌan Jésuu ni Símuun kídaā: —Ñá ku uꞌvī o. Tsí vatā o den da tɨ́ɨn o tsákā ne, un tsi nté vevií ne, kuan kōo niꞌi o ñaꞌa, ña é kuntīkɨn Xúva kō dɨ —kaꞌan ñá ni Sīmuun. ");
INSERT INTO mizNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kidáā né, ntii niꞌi ña tun ntōó san diñɨ ntute kān né, dā tsóo mii ntɨ̄ꞌɨ ña iña ña, dá kuēꞌen ñá, kuntikɨn ñá Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Uun ntuvi ne, tuví Jesuu uun ñuú ne, xée uun ñatīi, ña é kanakoꞌxo kúñu ī. Dā íni ña Jesuú ne, nákūtínteɨ ña ñuꞌu kān, kaikan ña dá xeꞌe: —Tōꞌó, tē ntio nto ne, kuvi nakuitā ntó kuiꞌí ko —kaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kidáa ne, tɨɨn ntaꞌa Jēsuu ñá, kakaꞌan ñá ni ñā: —Ntio ko. ¡Na ntūváꞌan ve! —kaꞌan ñá ni ñā. Ura dúꞌva tsi i kueꞌen ntíꞌxe kuiꞌi é kanakoꞌxo kúñu ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kidáā ne, kakaꞌan Jésuu ni ña: —Nté uun ñaꞌa san ña ku káꞌan niꞌin ña. Mii tsī é kuēꞌén ntaꞌa dutú san na kinī ñá o. Kuēꞌen niꞌin doméni iña i é ntūváꞌan san vata ō kaꞌan Muísee, vata koo é un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san kutúni ña tsi é ntuntoon kuiꞌi é kākuvi o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ntá tsi da dií dií ka kūxée nuu túꞌun īña Jésuu. Ñá te nté kaa ñaꞌa nataká nuu ña é kīni ña é kākaꞌan Jésuú nī é ntuváꞌa ña kuiꞌi ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ntá tsi Jesuú ne, kīi nteé xio ña mí xoxó ñaꞌa ntoo ña ne, ikan kūkaꞌan ntâꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Uun ntuvi ne, tuví Jesuu, kakaꞌan ñá ni ñāꞌa san. Ikān ntoo ña fariseu ni mastrú leí dɨ, ña véꞌxi da kanɨɨ ñūú Galilea, ñuú Judeá, ni ñūú Jerusāleen. Dōo xéꞌe Xuva kō é kūvi vií Jesuu é ntaváꞌa ña ña ntánchokuvi. ");
INSERT INTO mizNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kidáā ne, xee níꞌi ña uun ñatīi, ña natɨ́ɨn, ntēkú ña chidō. Ncho kɨ́ꞌvi niꞌi ña ña īní viꞌi kan é xtuvī ñá ña nuu Jésuu, ");
INSERT INTO mizNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ntá tsi ña ni naníꞌi ña nté koo kɨ́ꞌvi ña, tsí ña te nté kaa ñaꞌa ntáñɨ̄ ña. Dukuān ne, kúxēe ña rkɨ víꞌi kan, dā nakuído ña xkɨtɨ tsió san ne, da nákiī ñá ña nchokuví san, kanɨɨ tsi ña ni chido ñā, nuu Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dā íni Jesuu tsi dóo ntánuu iní ña vexníꞌi ñā ne, kakaꞌan ñá nī ña nchokuví san: —Vevií ne, é dē kaꞌnu iní u ni o kuētsí o ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kidáā ne, mastrú leí san nī ña fariseú san ne, eni ntuꞌu ñā ntádē kuení mii ñā: “¿Neē ntú ñaꞌa ña sāꞌa é dotō tsí kakaꞌan ñá túꞌūn e dóo xii kaa? Tsí xoxo kuvi vií i é kāda kaꞌnu iní i ni kuētsí kō. Mii tsi Xuva kō é kūvi vií ña.” Kuān ó ntádē kuení ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ntá tsi Jesuú ne, kūtuni ña nté ō ntádē kuení ñaꞌa san ne, tsixeꞌe ña ñā: —¿Nté kuān ó ntádē kuení ntu nto? ");
INSERT INTO mizNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Neé ntu é dií ka ña ntii túꞌūn é kāꞌán u, te kuinī nto: “É ntōo kuétsi o vē”, o te kāꞌán u: “Nakuntítsin ve, nakakan”? ");
INSERT INTO mizNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nañēꞌé u nto tsí xuꞌu é vēxkúvī ú ñatīí ne, kuvi vií u é nakate u kuétsi ñāꞌa ñuxiví sa —kaꞌan ña. Kidáā ne, kakaꞌan ñá nī ña natɨ́ɨn san: —Nākuntítsin vé ne, dá nakiꞌin chido ō ne, dá kūnúꞌūn nú viꞌi o kān —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ura tsí i nakuntítsi ña natɨ́ɨn san méꞌñu ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ne, da nákiꞌi ña chido ñā, kunúꞌu ña nú viꞌi ña kān, kakaꞌan ñá e dóo kaꞌnu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, koó dā kúduꞌva ña, ntákaꞌan ña e dóo kaꞌnu Xuva kō. Dukuān úꞌvī ñá dɨ, ntákaꞌan ña: —Nté uun ito vata kiní o nuu i e dóo kaꞌnu e íni o vevii —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Dā kúvi sáꞌā né, ntīi Jesuu, kuéꞌen ña. Xée ñā mí tuví ña kaido diuꞌun xôo iña ñuú Roma. Levii nani ña. Tuví ña uun itsi mí kaido ña diuꞌun xôó ne, kakaꞌan Jésuu ni ña: —Kuntīkɨ́n ko —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kidáā ne, nákuntītsí Levií san. Tsoo mii ntɨ̄ꞌɨ ña iña ña, kuéꞌen ña, kantikɨ̄n ñá Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Da rkontûví ne, tsūꞌun Levií san viko nú viꞌi ña kan kuēnta iña Jésuu. Ñá te da dīi ñáꞌa, ña ntánataka diuꞌun xôo iña ñuú Romá san, nátaká nuu ña. Kidáā ne, uun tsi itsi intóo ntɨɨ́ ntɨɨ̄ ña nú mesa. ");
INSERT INTO mizNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ntá tsi ña fariseú san ni mastrú lei é dadɨɨ tsi ntáde tsiñu ña ne, eni ntuꞌu ñā ntákaꞌan ntée ña ña ntántīkɨn Jésuu, ntákaꞌan ña: —¿Nté kui ntaéꞌxí dadɨɨ nto nī ña ntánataka diuꞌun xôo iña ñuú Romá san, ni ña iō kuetsí i dɨ? —kaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Xoó ñaꞌa, ña é vāꞌá ne, ñá kantīo ña medíkū. Tsí mii tsī ña ntánchokuví san é ntio ña medíkū. ");
INSERT INTO mizNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ñá te ña é vāꞌá san ña é vexnantukū u, tsí ña iō kuetsí i san, vata koo é na natɨ̄vi iní ña kuétsi ña —kaꞌan ñá nī ña fariseu. ");
INSERT INTO mizNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ntákaꞌan ñá ni Jēsuu: —Ña ntántīkɨn Juaán san nī ña ntántīkɨn fariseú san ne, dōo ini xkuntoo ixu ñā; dōo ini kaꞌan ntâꞌví ña dɨ. Ntá tsi ña ntántīkɨn ntó ne, nguentúvi tsi ntáxiꞌi ntaéꞌxi ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —¿Vá kūvi ntu vií nto é ña káꞌxi ñaꞌa san mí iō víko e ntatántaꞌa ña da ntóo niꞌi ña ña e tántaꞌa san? ");
INSERT INTO mizNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ntá tsi tē xee úra i é kɨꞌɨn niꞌi ña ña e tántaꞌa sán ne, da kidáa kuntoo ixu ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kantaa ña ni ñā nuu i sáꞌa dɨ: —Nté uun xoxo kaꞌnté i uun taꞌvi duꞌnu xée i é nākunteé nuu duꞌnu ata. Te kuan kōo vií ña ne, natɨvī ñá duꞌnu xée san ne, ñá vāꞌá ito ka, tsí ña te dadɨ́ɨ tekú doo xée san nī doo atá san. ");
INSERT INTO mizNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ntē xoxo tsuꞌun i ntute tɨntiꞌo xeé san iní ñɨɨ atā san, tsí ntute tɨntiꞌo xeé san ne, dōó ntii inī í ne, ntáta ñɨɨ atā san. Ñɨɨ san ni ntūte tɨntiꞌo sán ne, ntuvi kunáa te ntāta. ");
INSERT INTO mizNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dukuān é kantio é kūꞌun ntute tɨntiꞌo xeé san iní ñɨɨ xēé san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Xoo e ntáxiꞌi i ntute tɨntiꞌo atā sán ne, ñá vādá ntio i ntute tɨntiꞌo xeé san, tsí dií ka váꞌa xiꞌi ntute tɨntiꞌo atā san é ntute tɨntiꞌo xeé san, kuiní i —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Uun ntuvi dá iō dáꞌna ne, kuéꞌen Jesuu ni ña ntɨníꞌi ñā, ítā ntiꞌxin ña má trīgu kan. Ña ntɨniꞌi ñā né, tāvá ña xoko trigú san, dā xiín nuu ña ntaꞌa ña ne, dā éꞌxi ña ntɨkɨn i san. ");
INSERT INTO mizNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kidáā né, iō ñá fariseú san ne, tsixeꞌe ña ñā: —¿Nté kuān ó ntáde ntu nto? Tsi dóo xií kaa é kuān koo vii o ntuvi dá iō dáꞌna —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nantíko kōó Jesuu, kakáꞌan ña: —¿Vá ña ntu ni nakuaꞌa nto nté ō dé Davii ni ña ntɨníꞌi ña uun ntuvi da dóo kákɨn ña? ");
INSERT INTO mizNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tsí kukɨ́ꞌvi ña iní viꞌi Xuva kō né, dā kíꞌi ña tañúꞌū e kúviko iña Xuva kó ne, dā éꞌxi ña, dɨvi ña nī ña ntɨníꞌi ña, kuān te da mii tsi dutú san é kūvi kaꞌxí ña tañúꞌū e kúviko san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kakaꞌan xtúku Jesuu: —Xuꞌu é vēxkúvi ú ñatīí ne, kadē kûꞌvé u iña ntúvi dá iō dáꞌna san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tuku ntuvi dá iō dáꞌna ne, kuéꞌen Jēsuú san má viꞌī mi ntánataká nuu ña Israeé san ne, eni ntuꞌu ña kanakuāꞌa ña ñaꞌa san. Ikān tuví uun ñatīí, ña natɨ́ɨn ntaꞌa i. ");
INSERT INTO mizNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mastrú leí san nī ña fariseú san ne, ntaíto xuꞌū ñá Jesuu nté koo vií ña, tē ntaváꞌa ña ñaꞌa ntúvi dá iō dáꞌna san ne, vata koo é nīꞌi tsi ña nté koo tsiꞌi kuétsi ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ntá tsi Jesuú ne, iní ña nee e ntádē kuení mastrú leí san nī ña fariseú san ne, kakaꞌan ñá ni ñatīi, ña natɨ́ɨn ntaꞌa i san: —Nākuntítsin ne, dá kuntītsin méꞌñū ña ntoo san —kaꞌan ña. Nákuntītsí ña ne, íntītsí ña méꞌñū ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kidáā ne, kakaꞌan Jésuu ni ña nguií san: —Iō é tsixēꞌe ú nto ve. ¿Neé ntu é vāꞌá vii o ntuvi dá iō dáꞌna? ¿Ō vii o é vāꞌá ne, ō vii o é kīni kaa? ¿O nakākú o ñāꞌa sán ne, o nākunaá o ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Īto díto Jesuu un ntɨɨ́ ntɨ̄ɨ́ ña ntoo diñɨ ña ne, dá kakāꞌan ñá ni ñatīí san: —Katan nteén ntaꞌa o —kaꞌan ña. Kuān o dé ntiꞌxe ñatīí san ne, ura tsí i ntuváꞌa ntaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ntá tsi ña nguiī sán ne, dōo kúdiin ña. Eni ntuꞌu ñā ntákaꞌan ña neé ntu é viī ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ntuvi tsikán ne, kuéꞌen Jēsuú uun itsi xukū mí kūkaꞌan ntâꞌví ña. Nɨɨ nīñú san kakaꞌan ntâꞌví ña ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dā tuví ne, kāna ñá un ntɨɨ́ ntɨ̄ɨ́ ña ntántīkɨn ñá ne, da nākaxnúu ña uxuvi ñáꞌa xoo é vīí i pustru ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ña sāꞌa é nakaxnúu ña é viī ñá pustru ña: Simuun, ña e xntánteē ña é Pedru kunáni ña; ni Āndree, ení Simuun; ni Sāntiau, Juaan, Felipe, Bartulumee, ");
INSERT INTO mizNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateu, Tumaa, ni Sántiau, iꞌxá Alfeu; ni Sīmuun, ña xntánteē ña é Zeloté dɨ; ");
INSERT INTO mizNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nī Júdā, ení Santiau; ni tūku Júdā, ñá é vēꞌxí ñuú Iscariote, dɨvi ñā é diko ña Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Dá kūntíi Jesuu ni pústru ña xuku sán ne, íntītsí ña mí nenī núu ne, ikān nátaká nuu un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntántīkɨn ñá ne, ñá tē nté kaa ñaꞌa san nátaká nuu ña ntuvi tsikán dɨ, ña é vēꞌxí da míꞌī ká ñuú Judea ni Jerusáleén dɨ, ni ñūú Tiru ni Síduun, ñuu é ntoo diñɨ ntute ñuꞌu kān. Xée ñā é kinī ña é kākaꞌan Jésuú ne, é ntaváꞌa ña ña nēe kuiꞌi ntákuvi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ña ntántoꞌo i é ñuꞌu é ña váꞌā nima í ne, ntuváꞌa ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dukuān ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ncho tɨ́ɨn ntaꞌa ña Jēsuu, tsí ini ña tsi dóo iō ñá é viī ña é ntaváꞌa ña un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Īto Jesuu ña ntɨníꞌi ña ne, dá kakāꞌan ñá ni ñā: —Nté kuān nte váꞌā o iña nto é ña tuví neé iō nto, tsí kaduku ntée nto mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ʼNté kuān nte váꞌā o iña nto é vevií e ntákakɨn nto, tsí rkontûví ne, ntaꞌa nto. ʼNté kuān nte váꞌā o iña nto é vevií ne, ntaéku nto, tsí rkontûví ne, naxkuntée nto. ");
INSERT INTO mizNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ʼNté kuān nte váꞌā o iña nto dá ña ntío kueꞌen tsí ñaꞌa sán nto, da tsoó mii ña ntō, da ntákaꞌan ntée ña nto, da ntánantii níꞌni ña nto tsi ntántīkɨn ntó ko, xuꞌu é vēxkúvi ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Na nākunuu díni kueꞌén nima nto. Un tsi kantíta mii ntō e dóo dîní nto ntuvi dá kuan kōo vií ña ni ntō. Tsí dɨvi ntō ne, níꞌi nto ūun doméni é taꞌxi Xuva kō. Tsí kuān o dé xení ñata ñā, ña intóo nte ntúvi diꞌna, nī ña kaꞌán naa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ʼNtá tsi ña ntáꞌvi ide ntú nto, xoo é dóo kuika i, tsi é nīꞌi nto é intoo dínī nto. ");
INSERT INTO mizNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ʼÑa ntáꞌvi ide ntú nto, xoo é dóo īó iña i vevii, tsí rkontûví ne, dōo ntoꞌo nto é kāꞌxi nto. ʼÑa ntáꞌvi ide ntú nto, xoo é dóo dîní i vevii, tsí rkontûví ne, kueku nto ne, kuntoo ntaꞌxa nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ʼÑa ntáꞌvi ide ntú nto tē un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, dōo váꞌā ó ntákaꞌan ñá iña nto, tsí kuān o dé ña intóo kídaa nī ña é dotō tsi ntákaꞌan ña é kaꞌan ñá naa Xuva ko, ntá tsi ña te ntáā e ntákaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ʼNtá tsi ntōꞌo e ntaíni nto ne, kakaꞌán u ni ntō: Kuinima ntó xoo é ña ntío i nto. Váꞌa kō vií nto nī ña ntaínchuꞌvi ntó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nāxnuu viko nto ña e ntákaꞌan ntée nto. Kantáꞌvī ntó iña ña ntákaꞌan kíni iña nto. ");
INSERT INTO mizNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tē xoó ñaꞌa kaxéꞌe nuu ña vinuu ntó ne, kuéꞌe ntō tɨnuu nto é ūun xo ká san dɨ, na kuēꞌé ka ñá dɨ. Tē xoó ñaꞌa kanakiꞌi nuu ña kutuun ntó ne, kuéꞌe nto dūꞌnu ntó dɨ, na kunīꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Da xōó ka ñaꞌa, ña é kaikan kudii neé ntio i ne, kuéꞌe ntō. Te kiꞌi ña da nēé ka iña ntó ne, ñá ku ntāka nto. ");
INSERT INTO mizNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Vií nto ni tāꞌan nto vatā ó ntio nto é viī ñá ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ʼTē ntákuinima ntó da mii tsī ña é kākuinima í nto ne, ¿neé ntu sintiáꞌvi niꞌi nto? Un tsi nté ña kini ntáa san kuān ó ntáde ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Te vāꞌá o ntáde nto é da mii tsi ni ñāꞌa, ña é vāꞌá o ntáde ni ntō ne, ¿neé ntu sintiáꞌvi niꞌi ntó dɨ? Tsí un tsi nte ñá kini ntáa sán ne, kuān ó ntáde ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te xntii nto tāꞌan nto vata koo é na xntii ña ntō ne, ¿neé ntu sintiáꞌvi niꞌi nto? Tsí ña kini ntáa sán ne, kuān o xntíi ña tāꞌan ña vata koo é na xntii tāꞌan ña ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ntá tsi ntoꞌó ne, kuinima ntó ña ntákuneꞌu iní i ni ntō. Váꞌa kōo vií nto ni ñāꞌa. Xntii nto tāꞌan nto é ña kuntétu nto te xntii ña ntō dɨ. Kidáā né, dōó kaꞌnu nuu i é taꞌxi Xuva ko ntō. Kidáā ne, kuvi ntiꞌxe nto iꞌxá Xuva kō, ña e dóo kaꞌnu. Tsí dɨvi ñā e dóo váꞌā ó kade ña nī ña kini ntáa san, ña e ñá ini é nakuéꞌe sintiáꞌvi ntaꞌa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Vata tsī o ntúntaꞌví ini Xuva ko ntō ne, kuan tsi kōo ntuntaꞌví ini nto taꞌan nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ʼÑá kū kaꞌan ntée nto taꞌan nto. Dukuān ne, ñá kaꞌan ntée Xuva ko ntō dɨ. Ñá ku nakuitā ntó taꞌan nto ne, dukuān ne, ñá nakuītá Xuva ko ntō dɨ. Kada kaꞌnu iní nto ni tāꞌan nto ne, kuan kōo kada kaꞌnu iní Xuva ko ni ntō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vata tsī koo kuéꞌe nto ne, kuan tsī koo niꞌi nto. Kūꞌvé vaꞌá niꞌi nto. Nakuédin nuu ña, nakɨdɨ nuu ña ne, kunuu tsitu kuēꞌen da nté nakuīdo káva. Tsí dɨvi tsī kúꞌvē é kānakii kúꞌvē ntó ne, dɨvi tsī kúꞌve nātaꞌxi ña nto dɨ —kuan ō kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kidáā ne, nañéꞌē ñá ñaꞌa san nté koo vií ña, kakaꞌan ña: —¿Vá kūvi ntu vií uun ña kuāá san nañēꞌe ñá tuku ña kuāa míꞌi kɨ̄ꞌɨn ña? ¿Ñā ntu kóꞌxo nuu ña ntuvi ñá xavi? ");
INSERT INTO mizNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nté uun ña kanakuāꞌa sán ne, ñá tē káꞌnu ñaꞌa ña vata kaa mastru ña. Ntá tsi tē ntɨ́ꞌɨ̄ kútuꞌve ña ne, kudadɨɨ ña ni mastru ña. ");
INSERT INTO mizNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ʼ¿Nté kui kaiton ntun xáka ūtun é nūu ntuxnúu tāꞌan o? Tsí nte ña kaínin ntuꞌu é nūu ntuxnúu mii ō. ");
INSERT INTO mizNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tē ña kaínin ntuꞌu é nūu ntuxnúu mii ō ne, ¿nté kui dōto tsí kakaꞌan ntún ni tāꞌan o é na tāꞌxi ña nuu ña é natāvan xáka ūtun é nūu ntuxnúu ña? Dɨvīn e dá mii tsi rkɨ xaa o ntéku é kākaꞌán ne, diꞌna natāvan ntuꞌu é nūu ntuxnúu mii ō vata koo é kūvi kinín vāꞌan é natāvan xáka ūtun é nūu ntuxnúu tāꞌan o. ");
INSERT INTO mizNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ʼÑa túvi utun vāꞌa é kātaꞌxi kɨtɨ é ña váꞌā. Nté utun ña váꞌā san ña katáꞌxi kɨtɨ é vāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Da nēé ka utun, kutuni ko neé utun dá kakii kɨtɨ i. Ñá kakīi igú san utun iñu, ntē ña kakíi tɨntiꞌó san má xuku íñū. ");
INSERT INTO mizNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ñatīi, ña é vāꞌá ne, kakaꞌan ña nee é vāꞌa, tsí nuu é vāꞌá san nima ña. Ñatīi, ña é kīni kaa ne, kakaꞌan ña é kīni kaa, tsí nuu é kīni kaa nima ña. Tūꞌun é kākene xuꞌu ña ne, nima ñá kakene. ");
INSERT INTO mizNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ʼ¿Nté kui nuu nuu xntu ntákaꞌan nto tsí xuꞌu é Tóꞌo ntō ne, ntá tsi ña ntáde ntaa nto nee é kākaꞌán u ni ntō? ");
INSERT INTO mizNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kaꞌán u ni ntō xoo é kantīkɨn ntíꞌxe i ko, xoo é katekú ntiꞌxe i ne, kade ntaa é kākaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ña sāꞌá ne, vata kaa uun ñatīi, ña é kaxntitsi viꞌi sán ne, diꞌna kaete nuu kunū ñá ne, xtuvī ñá etɨ i san nú xūu. Dā éꞌnu ntute sán ne, dōó ntii duku ntée viꞌi san. Ntá tsi ña ni kuvi kantá nuu, tsi dóo kutū tuví etɨ́ i. ");
INSERT INTO mizNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Xoó ñaꞌa é katekú i ntá tsi ña te kade ntaa ña é kākaꞌán u ni ñā ne, vata kaa uun natīi, na é xntītsí viꞌi i da mii tsī nú ñūꞌu sán ne; ntē ña ni de váꞌa na etɨ́ viꞌi sán ne, dā éꞌnu ntute sán ne, dōó ntii duku ntée ne, uun ito tsi nántatsin á viꞌi san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Dā kúvi kaꞌan Jesuu ni ñáꞌa sán ne, kuéꞌen ña ñūú Capernau. ");
INSERT INTO mizNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ikān tuví uun ñaꞌā tóꞌō sntadun, ña ñuú Roma. Tuví uun ña kade tsiñu iña ña, ña e dóo ntio ña ne, dōó nchokuví ña. E dóko sā kúvi ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Da téku tóꞌō sntadún san tsi ntákaꞌan ñáꞌa san iña Jésuú ne, taxnūu ña ñata, ña odo nūu ña Israee, e kíkakan ñá dā xeꞌe ntaꞌa Jesuu é na kɨ̄ꞌɨn ña, kintaváꞌa ña ña kade tsiñu san. ");
INSERT INTO mizNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dā xee ñátā san mí tuví Jesuú ne, ntákaꞌan ñá ni ñā: —Vií nto da xeꞌe, xntii kudii nto tóꞌō sntadún san, tsi dóo vaꞌá ñaꞌa ña, ");
INSERT INTO mizNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tsi dóo kakuinima ñá ñuú kō ne, mii ñā xntítsi ña viꞌi mí ntánataká nuu ña ñuú ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kidáā ne, kuéꞌen Jēsuu ni ñátā san. Ntá tsi dóko sā xee ña nú viꞌi ña kān né, taxnūu tóꞌō sntadún san ña dóo váꞌa tiin niꞌi ñā é kūkaꞌan ñá ni ñā: —Tōꞌó, ñá tē nté sa váꞌa ñaꞌa u é kuīta ntíꞌxin nto nú viꞌī ko. ");
INSERT INTO mizNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ntē ña te nté sa váꞌa ñaꞌa u é xēé u un tsi nte mí tuví nto, kuiní ko. Ntá tsi te mii tsī é kāꞌan ntó ne, ntūváꞌa ña kade tsiñu iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tsí xuꞌú ne, īó tóꞌō kó dɨ, ña odo nūu iñá ko ne, dōó tɨtɨ́n sntadún ko é odo nūu ú iña ñá dɨ, é kātee tsiñú u ña nēe é vií ña. Te kāꞌán u ni ñā é kɨ̄ꞌɨn ñá ne, kɨ́ꞌɨn ñā. Te kāꞌán u ni ñā é na kīꞌxi ña ne, kiꞌxi ña. Te taxnūu ú ña ntáde tsiñu iñá ko é viī ña sáꞌā ne, vií ña —kaꞌan tóꞌō sntadún san. ");
INSERT INTO mizNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Koó dā kúduꞌva Jesuu da téku ña sáꞌā. Kaito ña un ntɨɨ́ ntɨ̄ɨ́ ña ntántīkɨn ñá ne, kakaꞌan ñá ni ñā: —Nuu é ntaā i é kākaꞌán u: Váta kīní u nté uun ñaꞌa ña Israee é vata kaa ñatīi sáꞌa e dóo kanuu iní ña ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dā náxee ña e táxnūu tóꞌō sntadún san nú viꞌi ña kān ne, é ntūváꞌa tsi ña kade tsiñu iña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Rkontûví ne, kuéꞌen Jēsuu uun ñuu é nani Nāiin. Kuéꞌen ña ni ña ntɨniꞌi ñā ne, ñá tē nté kaa ñaꞌa kueꞌen ña, kuntikɨ̄n ñá ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Dā xee étsin ña mí kɨ̄ꞌví ña má ñūú san ne, véꞌxi ñāꞌa, ña odo ñā xiꞌi e kíkuꞌxí ña ña. Ñá te da dīi ña má ñūú san íntīkɨn ñá ña dɨ. Ñatīi, ña xiꞌí san ne, kuan tsī kaa uun kudii ña iꞌxá ñadɨ̄ꞌɨ kií san. ");
INSERT INTO mizNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dā íni Jesuu ñádɨ̄ꞌɨ́ san ne, ntūntaꞌví ini ña ña, kakaꞌan ña: —Ña kuékūn kan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kidáā ne, kuéꞌen ētsin ña ne, dā tɨ́ɨn ntaꞌa ña chidō sán ne, íntāñɨ dáꞌna ña. Kidáā ne, kakaꞌan Jésuu ni ñá xiꞌí san: —Xuꞌú kakaꞌán u ni ō ne: ¡Nakuntítsin! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ura tsí i nakuntítsi ña xiꞌí san ne, eni ntuꞌu ñā nákaꞌan ña. Jesuú ne, ntáda ña ña kuenta ntáꞌa dɨꞌɨ ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dā íni ñaꞌa sán é kuān o dé Jesuú ne, dōo uꞌví ña, un ntɨɨ́ ntɨɨ̄ ñá ne, eni ntuꞌu ñā nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō, ntákaꞌan ña: —Tsí uun ñaꞌa ña kaꞌán naa Xuva ko, ña e dóo kaꞌnu ne, é xee dîtó ñā mí ntoo ō ve. Tsí Xuva kō ne, xée ña ñūú kō é xntii ña kō —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dá kanɨɨ ñūú Judea ni diñɨ í kūtuni ña nté ō dé Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ña ntántīkɨn Juaan Bautistá ne, ntaa ña ni ña un ntɨɨ́ ntɨ̄ɨ́ nuu i nté ō dé Jesuu. Kidáā né, kāna Juaán san uvi ñáꞌa, ña ntántīkɨn ñá ne, ");
INSERT INTO mizNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","dā táxnūu ña ña ntaꞌa Jesuu é tsixeꞌe ña te dɨvi ntīꞌxe ña ña é kīꞌxi sán ne, o te kuntētu ká ña uun ká tuku ñáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ña e táxnūu Juaán san ne, xée ētsin ña, ntákaꞌan ñá ni Jēsuu: —Taxnūu Juaan Bautistá ntɨ é tsixeꞌē ntɨ́ te dɨvi nto ñā é kīꞌxi sán ne, o kuntētu ká ntɨ uun ká tuku ñáꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ura dúꞌva tsi i ne, ñá tē nté kaa ñaꞌa ntaváꞌa Jesuu, ña e ntákuvi kuiꞌí san, nī ña e ntántoꞌo i, nī ña é ñūꞌu é ña váꞌā nima í dɨ. Tɨtɨ́n ña kuāá nāxiꞌí nuu ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ñá nī ña táxnuu Juaán san: —Kueꞌēn ntó, kukaꞌan ntó nī Juaan nee é íni nto, nee é téku nto. Ntaa nto ni ñā tsí ña kuāá ne, é nāxiꞌí ntuxnūú ña; ña natɨ́ɨn i ne, é nākaka ña; ña ntánakoꞌxo kúñu ī ne, é ntūntoo ña kuiꞌi ña; ña loꞌō ne, é nātekú ña; ña xiꞌí ne, é ntōto ña; ñá ntāꞌví ne, é tēkú ña túꞌūn é vāꞌá san nté koo nakáku ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Nté kui váꞌā ó xoo ñáꞌa, ña é ña natɨvi iní i é kantīkɨ́n ko! —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Dā kunúꞌu ña táxnuu Juaán san ne, eni ntuꞌu Jēsuu kakáꞌan ñá ni ñāꞌa san iñá Juaán san, kakaꞌan ña: —¿Neé ntu ixkoto ditó nto ñuu itsí kān? ¿Vá ñeꞌe ntú nto é ixkoto nto uun ñatīi, ña é dotō tsí kakaꞌan, vata kaa uun choo é kākantá nuu dá kadūku tátsin? ");
INSERT INTO mizNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Neé ntu ixkoto nto? ¿Vá ixkoto ntú nto uun ñatīi, ña e dóo vaꞌá doo i? É īni nto tsí ña e dóo vaꞌá doo i, ña é iō ntɨ́ꞌɨ da nēé ka tsi é ntio i ne, ñá tē ñuu itsí kān ñuꞌu ña, tsi nú viꞌī rei kan ntóo ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Neé ntu ixkoto nto? ¿Īxkoto ntú nto uun ñaꞌa ña kaꞌán naa Xuva ko? Nuu é ntaā i tsí dɨvi ñā ne, kakaꞌan ñá naa Xuva ko, ntá tsi dií dií ka kaꞌnu ñaꞌa ña é ña kaꞌán naa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tsí dɨvi ñā é ūve naꞌa iña ña Túꞌun Xuva kō mí kakāꞌan: Taxnūu ú uun ñaꞌa, ña é kunīꞌi túꞌūn san, diꞌna dá xeen, vata koo é nākoo túꞌve ña itsi o. Kuān ó uve naꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kakaꞌán u ni ntō tsi é un ntɨꞌɨ ñatīi, ña ntoo ñuxiví san ne, nté uun ña ña te dóo naꞌnu ñaꞌa ña vata kaa Juaán san. Ntá tsi ña é kāduku ntée mí kadē kûꞌvé Xuva kō ne, kuān te é dií ka dutsi ntaa ña ne, dií ka naꞌnu ñaꞌa ká ña é Juaán san. ");
INSERT INTO mizNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ʼUn ntɨɨ́ ntɨ̄ɨ́ ña tekú i é kākaꞌan Juaán san ne, ede ntaa ña é kākaꞌan Xúva kō. Un tsi nte ña ntaído diuꞌun xôo iña ñuú Romá san dɨ ítsi ntute ña ntaꞌa Juaán san ne, ");
INSERT INTO mizNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ntá tsi ña fariseú san nī mastrú leí san ne, ña ni ntío ñā é nakūtsi ntute Juaán san ña ne, kuān o nantii níꞌni ña é vāꞌa koo vií Xuva ko ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ʼ¿Nté ntu koo ntada dadɨɨ ú ña ntoo vevii? ¿Ntē ntu ntáa ña? ");
INSERT INTO mizNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Vata ntáa iꞌxá kuetsī é ntoo nu âꞌví i, ntánadɨ̄kɨ, é un tsi ntákachuꞌú ni tāꞌan i: “Nakuekū ntɨ́ choo, ntá tsi nté uun nto ñá ni iteꞌe ntō. Īta ntaꞌxa ntɨ́ ne, nté uun nto ña ni éku nto”, xkoó kaꞌan iꞌxá san. Kuān ntáa ña ntoo vevií dɨ, ");
INSERT INTO mizNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","tsi véꞌxī Juaan Bautista é ntē ña kaéꞌxi ña tañúꞌu ne, ntē ña kaxiꞌí ña ntute tɨntiꞌó dɨ ne, ntákaꞌan nto tsí nuu é ña váꞌā nima ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kidáā ne, xeé u, xuꞌu é vēxkúvi ú ñatīi. Xuꞌú ne, kaeꞌxí u, kaxiꞌí u ne, da ntákaꞌan nto tsi dóo kueꞌe kaeꞌxí u, dōo kueꞌe kaxiꞌí u. Ntákaꞌan nto dɨ tsí xuꞌú ne, dōo váꞌa tiin ú nī ña kini ntáa, nī ña ntaído diuꞌun xôo iña ñuú Romá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ntá tsi kutuni xoo é kiꞌin īní ntiꞌxe i te kīni o rkontûvi nté koo kuvi —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Uun ñaꞌa, ña fariseú ne, kāna ña Jesuu é kikaꞌxí ña nú viꞌi ña kān. Dā xee ñá ne, ítūví ña nú mesa kan. ");
INSERT INTO mizNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kidáā ne, xée uun ñadɨ̄ꞌɨ́, ña ñuú ikān, ña e dóo iō kuetsí ne, da kutuni ña tsí tuví Jesuu nú viꞌī ña fariseú san ne, xée ñā, niꞌi ña uun xuxu e kúvi xuu é nani alābastru é nūu tsitu choꞌo vîdin. ");
INSERT INTO mizNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ítūví ña nú dɨ̄ꞌɨ́n Jesuu, kaéku ña ne, nākate ña dɨ́ꞌɨn Jēsuu ntuté nūú ña. Kidáā né, īdi ña naítsī ña dɨꞌɨn ña, da tánuu ña dɨ́ꞌɨn ña ne, dā daꞌví ña dɨ́ꞌɨn ñā choꞌo vîdín san. ");
INSERT INTO mizNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ña fariseu, ña kána Jesuú ne, dā íni ña sáꞌā né, dē kuení ña: “Tē dɨ́ ña kakaꞌan ntíꞌxe naa Xuva ko ñatīí saꞌá ne, kutuni ñá nee ñáꞌa ñadɨ̄ꞌɨ́ saꞌá, ña katɨɨn ntaꞌa ñā. Tsí ñadɨ̄ꞌɨ́ saꞌá ne, dōó iō kuetsí ña.” Kuan ō dé kuení ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kidáā ne, kakaꞌan Jésuu ni ña fariseú san: —Simuún, iō kúdii é kāꞌán u ni ō —kaꞌan ña. Kidáā ne, kakaꞌan fáriseú san: —Káꞌan ntō, Mastrú —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ne dá kantāa Jesuu ni ña, kakaꞌan ña: —Uvi ñáꞌa ñatīi itá nuu ñā diuꞌun é nakiꞌi ntée ña iña ñá kuiká san ne, uun ñaꞌa ñā ne, úꞌūn sientu diúꞌun kuīꞌxín san itá nuu ña. Ña uun ñaꞌa sán ne, úvi dīko uꞌxi tsi. ");
INSERT INTO mizNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ña ni kúvi ntáꞌvi ña diuꞌun é nakiꞌi ntée ña ne, īde ña da xeꞌe nákadɨ̄ ñá kuenta é itá nuu ña ntuvi ña. Káꞌan nto vē: ¿Xoo é ntuvi i é dií ka kuinima í ña kuiká san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kidáā ne, kakaꞌan Símuún san: —Vata te ñatīi, ña é dií ka kuēꞌe itá nuu san —kaꞌan ña. Kakaꞌan Jésuu: —Váꞌā o é kākaꞌan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kidáā ne, kaito Jesuu ñádɨ̄ꞌɨ́ san ne, dá kakāꞌan ñá ni Sīmuun: —Koton ñadɨ̄ꞌɨ saꞌa. Xuꞌú ne, xéē u nú viꞌi ō né, ntē ña ni taꞌxin ntute é ntōo dɨ́ꞌɨ̄n ko. Ntá tsi ñadɨ̄ꞌɨ́ saꞌá ne, nakate ña dɨ́ꞌɨ̄n kó ntute núu ña ne, idi mii ñā naítsi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ntē ña ni éꞌxin xuꞌu kó vata xkoó ini o ne, ntá tsi ñadɨ̄ꞌɨ́ sāꞌá ne, un tsi nte dá xee ú ne, katanuu ña dɨ́ꞌɨ̄n ko. ");
INSERT INTO mizNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ntē ña ni dáꞌvin dɨkɨ́ ko nté un siin aseté san. Ntá tsi dɨvi ñā ne, dáꞌvi ña dɨ̄ꞌɨ́n ko choꞌo vîdin. ");
INSERT INTO mizNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dukuān é kākaꞌán u tsí kuān te ñá tē nté kaa kueꞌe kuétsi ña īó ne, ntá tsi kutuni tsí e dé kaꞌnu iní Xuva ko ni ñā, tsi dóo kuínima ña. Ntá tsi ñaꞌa, ña é dutsi kūdii e ntáde kaꞌnu iní o ni ñā ne, un sīin kudií kakuinima ñá kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kidáā ne, kakaꞌan ñá ni ñadɨ̄ꞌɨ́ san: —É dē kaꞌnu iní u ni ō kuétsi ō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ñaꞌa, ña é vexkáꞌxi ni ña ne, eni ntuꞌu ñā ntátsixeꞌe ñā: —¿Xoō ntu ñáꞌa ña sāꞌa, é un tsi nte kuétsi ñāꞌa san kade kaꞌnu iní ña ni ñā? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ntá tsi Jesuú ne, kakaꞌan ñá ni ñadɨ̄ꞌɨ́ san: —Tsi kuíntiꞌxe o Xuva kō ne, é ntūváꞌa nima ó ve. Va váꞌa tsi kuēꞌén ve, ñá ku kadā kuení ka o —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Rkontûví da kúvi sáꞌā ne, kaika Jesuu taꞌán ñuu taꞌán ñuu, kakaꞌan ntódo ñā túꞌun īña Xuva ko nté o kadē kúꞌvē ña. Uxúvi ñāꞌa pustrú san ntɨniꞌi ña ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Īó ñadɨ̄ꞌɨ́ ne, ntikɨ̄n ñá ña, ña é ntaváꞌa ña é ñūꞌu é ña váꞌā san nima í nī ña é ntuváꞌa kuiꞌi e ntákuvi i. Ñadɨ̄ꞌɨ́ san ne: María Madalena nani ña, ña e ntíi uꞌxe é ña váꞌā nima í, ");
INSERT INTO mizNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nī Juana, ñádɨ̄ꞌɨ ñá nani Cūsa, ña dé tsiñu iña Heródē; ñá nani Sūsaná ne, nī ña te da díi ka ñadɨ̄ꞌɨ, kueꞌen ñá vata koo é xntii ña ña nēe é īó iña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ñá te da dīi ñaꞌa kíi ña ñuú ña é kinī ñá Jesuu. Dōo táka nuu ñaꞌa sán ne, kidáa ne, ntāa Jesuu ni ña uun nuu i, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Uun ñatīí, ña kataꞌxi tatá ne, kuéꞌen ña kūtaꞌxí ña tatá ña. Uun itsi ne, kóꞌxo ntɨ̄kɨn san itsi kán ne, ixkanúu ñaꞌa sán ne, ēꞌxi láa sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Uun itsi xtuku ne, kóꞌxō tuku ntɨ́kɨn san neꞌu xuú san ne, dā kéne ne, ura tsí xiꞌi dii, tsí kakunaá ntute mí koꞌxo. ");
INSERT INTO mizNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kóꞌxō xtuku ntɨkɨn san má kūꞌu íñu kān. Ēꞌnu dadɨɨ ni xuku íñū sán ne, ítāvi núu kueꞌen xúku íñū san i ne, xíꞌī dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ntá tsi uun itsi xtuku ne, kóꞌxō nuu ntɨkɨn san ñúꞌu vāꞌa. Kidáa ne, ēꞌnu né, dōo váꞌa kúvi. Kīi te uun sientu kɨ́tɨ i é un é un ditsin i —kaꞌan ña. Sáꞌa kākaꞌan Jésuú ne, nɨɨ̄ kuéꞌen ini ña kakaꞌan ña: —¡Te īó loꞌxo ntó ne, kini nto! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kidáā né, tsixeꞌe ña ntɨniꞌi ña ñā neé kani túꞌun nuu i sáꞌa é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ne, kakaꞌan Jésuu: —É taꞌxi Xuva kō é kūtuni ntó nuu i e dóo xūꞌú iō iña i mí kadē kúꞌvē ña. Ntá tsi ña nguiī sán ne, da kantaa ú ni ñā nuu i sáꞌa ne, ntaíto ña ne, ō ntaíni ña, ntá tsi ña kɨ́ꞌɨn dɨkɨ ña neé kani túꞌun. ");
INSERT INTO mizNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ʼNuu i sáꞌā ne, kani túꞌun: Ntɨ̄kɨ́n san ne, dɨvī é vata kaa túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Uun itsi mí kakóꞌxo ntɨkɨn san itsi kán ne, kani túꞌun vata ntáa ñaꞌa, ña téku i, ntá tsi véꞌxi tóꞌō e ña váꞌā san, véxnakiꞌi túꞌun Xuva kō é ñuꞌu nima ñáꞌa san vata koo é ña kuintíꞌxe ña, vata koo é ña nakáku ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mī koꞌxó nuu ntɨkɨn san neꞌu xuú san ne, vata ntáa ñaꞌa, ña e dóo dîní i é kātekú i túꞌun Xuva kō ne, kuīntiꞌxe ña, ntá tsi ña kuéꞌe ni kuīntiꞌxe ña. Vata ntáa utun é ña tuvi kuéꞌe xóꞌo i ntáa ña. Kuīntiꞌxe ña é uun daꞌna. Ntá tsi ntuvi dá kātaan núu ña ne, kaxtuví xio ña túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mī koꞌxó nuu ntɨkɨn san má xūku íñū sán ne, vata ntáa ñaꞌa, ña e téku i túꞌūn sán ne, dukuan dukuān sá ne, kakunáa inī ña. Tsi é tūku e túku é kadē kuení ña: é nīꞌi ñá diuꞌun, é viī ñá nee iña é ntio ña ne, dukuān ña kaxio váꞌa iña ña. Vata ntáa utun é ña kaéꞌnu váꞌa kɨtɨ i ntáa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ntá tsi mí koꞌxo ntɨkɨn sán ñuꞌu vaꞌá ne, vata ntáa ñaꞌa, ñá iō nima váꞌa i ne, é iō tuꞌvé ña é kīni ña túꞌun Xuva kō, é viī ñá kuenta túꞌūn san. Ñá nātɨvi iní ña. Vata ntáa utun e dóo váꞌa kakii kɨtɨ i san ntáa ña —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kidáā ne, kantaa ña ni ña nuu i iña ñúꞌu é nāxiꞌí nuu, kakaꞌan ña: —Nté uun xoxo tuún i ñuꞌú san ne, dá dāꞌví nuu. Ntē ña xtuví ña má ītó ña. Tsí xnteku dukún ña vata koo é nāxiꞌí nuu kanɨɨ̄ má viꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Vata tsi kaa nuu i sáꞌā ne, ña túvī nee iña é kutuvī xuꞌu é ña nátidito, nté uun nuu i é iō xuꞌu é ña kiní o rkontûvi, tsi dá miī é nātidito. ");
INSERT INTO mizNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ʼDukuān ne, kini vaꞌá nto túꞌūn é kāꞌán u, tsí ñaꞌa, ñá iō iña í ne, níꞌī ká ña. Ntá tsi ña é ña tuvi íña í ne, nakuido nteé ña un tsi nté nuu i é kuini ña é īo íña ña —kaꞌan Jésuu ni ñaꞌá san. ");
INSERT INTO mizNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kidáā ne, xée dɨꞌɨ Jēsuu ni ení ña. Ntá tsi ña ni kuvi xée ētsin ña mí tuví Jesuu, tsí ña te nté kaa ñaꞌa ntoo ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kidáā ne, xée ūun ñaꞌa, kakaꞌan ñá ni Jēsuu: —Dɨꞌɨ nto ni enī ntó ne, ntáñɨ̄ ntée ña nto kíꞌi kān é ncho kiní ña nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nantíko kōó Jesuu, kakáꞌan ña: —Xoo é katekú i túꞌun Xuva kō ne, kade ntaa túꞌun ñā, dɨvi ñā é dɨꞌɨ̄ kó ni ēní ko ni tāꞌan ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Uun ntuvi ne, ínuu Jesuu tún ntōó ni ña ntɨniꞌi ñā, kakaꞌan ña: —Xio diñɨ ntute san kɨ́ꞌɨn ō ve —kaꞌan ña. Kuéꞌen ñā kídaā. ");
INSERT INTO mizNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Da ntaíta ntiꞌxin ña nu ntuté san ne, kídi Jēsuu. Kidáā ne, un ntii tsi vēꞌxí tatsín san méꞌñū ntute san. Iñɨ ntúꞌu nátsitu tun ntōó san ntute ne, dókō sá ni tēni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kidáā ne, kuéꞌen ña kūnantoto ña Jésuu, kakaꞌan ñá ni ñā: —¡Mastru! ¡Mastru! ¡Dóko sā téni ō! —kaꞌan ña. Nákuntītsí Jesuú ne, kakaꞌan ña é nākoó daꞌna tātsín san ni ntūte é kānakuntáñɨ ntaa. Ura tsí i xío kadin ne, diin diin sa kúvi. ");
INSERT INTO mizNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kidáā ne, kakaꞌan ñá ni ña ntɨniꞌi ñā: —¿Nté kui ntaúꞌvī ntú nto? ¿Míꞌi ntu kuēꞌen é ntákuintiꞌxe nto? —kaꞌan ña. Ntá tsi ña ntɨniꞌi ñā né, dōo uꞌví ña. Koó dā kúduꞌva ini ña, ntákaꞌan ñá xe un xé un ñā: —¿Xoó ñaꞌa ntu ña sāꞌa, ña é kākaꞌan ni tátsín san ni ntūte san é nākoó kadin ne, ura tsí i xío kadin ntiꞌxe? ¡Un tsi nte tátsín san ni ntūte san kade ntaa é kākaꞌan ña! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kidáā ne, xée ña ñūú Gadara é tuví tuku diñɨ ntute é ñūú Galilea. ");
INSERT INTO mizNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ntii Jesuu díñɨ ntute sán ne, ikan tsi vēꞌxí uun ñatīi, ña má ñūú san, ña é ñūꞌu é ña váꞌā nima i. Ñá te dā vévii é ña te núū ká ña duꞌnu ña; ntē ña te túvī ká ña nú viꞌi ña kān. Da nɨɨ kuēꞌen tsí kapusantu kán nuu ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Dā íni ña Jesuú ne, nákunchɨ̄tɨ́ ntaa ñá nuu ñá ne, un ntii tsī kéne ña, kakaꞌan ña: —¿Neé ntu kaduku ntée nto iñá ko, Jesuu, iꞌxá Xuva kō, ña tuví e dukún kān? ¡Vií nto da xeꞌe, ñá ku kini nteē ntó ko! —kaꞌan é ña váꞌā san ni Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kuan ō kaꞌan ña, tsí Jesuú ne, kakaꞌan ñá nī é ña váꞌā san é na ntīi nima ñátīí san. Dōó kiꞌin ito kūkɨ́ꞌvi é ña váꞌā san nima ñá, kuān te ntákiꞌní ñaꞌa san ntaꞌa ña ni dɨ̄ꞌɨ́n ña kadená ne, kanakɨꞌɨ tuꞌun, tsí e ña váꞌā sán ne, kaxntíi ña da tī é kūnu ña é kɨ̄ꞌɨn ña ñuu itsi. ");
INSERT INTO mizNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ntá tsi Jesuú ne, tsixeꞌe ñā: —¿Ntē ntú nanin? —kaꞌan ña. —Ntɨꞌɨ́ ne, Ligiuun naní ntɨ —kaꞌan. Kuan ō kaꞌan ña, tsí ña te da díi e ña váꞌā san é ñūꞌu níma ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Íkān é ña váꞌā san ntaꞌa Jésuu é ña taxnuu ña í ini totsin kan. ");
INSERT INTO mizNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Daꞌa san ne, ñá tē nté kaa ñuꞌu kutsín san ntaéꞌxí tɨ xuku san ne, ntákaꞌan é ña váꞌā san te kūvi ntɨ́ꞌvi nima kútsín san. Jesuú ne, xéꞌe ña ītsi. ");
INSERT INTO mizNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kidáā ne, ntīi é ña váꞌā san nima ñátīí san ne, dā kukɨ́ꞌvi nima kútsín san. Kidáā né, īnu kutsín san, kueꞌen tɨ un tsi nte mí nuu ntute san ne, ikan tsī téni ntɨꞌɨ tɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ña e ntáde kuenta kútsín san ne, dā íni ña nte o kúvi ne, kuéꞌen ñā, koo da ntaínu ña, kuntaá ña nī ña ntoo má ñūú san nī ña ntoo má kūꞌu kan nté ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ñaꞌa sán ne, ntīi ña, kukoto dîtó ña nté ō kúvi. Dā xee ña mí tuví Jesuú ne, ikān tuvi tɨxɨ ñátīí san nú dɨ̄ꞌɨ́n Jesuu, ña e ntíi é ña váꞌā san nima i. E nákunūu ña duꞌnu ña ne, e váꞌā ó kadē kuení ña. Kidáā né, dōo uꞌví ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ña é īni nte o kúvi ne, ntántaa ña nté ō ntuváꞌa ña é ñūꞌu é ña váꞌā sán nima i. ");
INSERT INTO mizNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Un ntɨɨ́ ntɨ̄ɨ ña ñuú Gadará ne, eni ntuꞌu ñā ntaíkan ña da xeꞌe é na ntāka Jesuu ñuú ña, tsi dóo ntaúꞌvī ña. Dukuān ne, nákunūu Jesuu tún ntōó san ne, dā kunúꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ñatīí, ña e ntíi é ña váꞌā sán nima í ne, kakaꞌan ña é kɨ̄ꞌɨn ñá ni Jēsuu. Ntá tsi Jesuú ne, kakaꞌan ñá ni ñā é na kutuvī ña. Kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Kunúꞌun nú viꞌi ō ve, ntaan ni ñāꞌa san nté ō dé Xuva ko ni ō —kaꞌan Jésuu. Kidáā ne, kuéꞌen ñatīí san, kuntáa ña ni ñāꞌa san da kánɨɨ̄ má ñūú san nté ō dé Jesuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ntá tsi dā náxee Jésuu túku diñɨ ntute sán ne, ñá tē nté kaa diní ñaꞌa san e náxee ña, tsí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntantétu ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ikan tsī xeé uun ñatīi, ñá nanī Jairu, ña odo nūu iña viꞌi mí ntánataká nuu ña Israeé san. Ña sāꞌá ne, nakutuvi nteɨ ñā nú dɨ̄ꞌɨ́n Jesuú ne, kaikan ñá da xeꞌe ntaꞌa Jesuu é kɨꞌɨ̄n ña nú viꞌi ña kān. ");
INSERT INTO mizNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kuan tsī kaa uun a dióko ñā né, īó tun te ūxuvi kuiá tun ne, dóko sā kúvi tun. Kidáā ne, kuéꞌen Jesuú ne, ñá tē nté kaa ñaꞌa ntántīkɨn ñá ña. Un tsi taꞌu nuu ña méꞌñu ñāꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ikān nuu taꞌán uun ñadɨ̄ꞌɨ, ña é ña kaxio daꞌna é kaetɨ nɨñɨ ña. É uxuvi kuía é kuān ó kantoꞌo ña ne, é dōo kueꞌé diuꞌun nantɨ́ꞌɨ ña nī medíkū. É nantɨ́ꞌɨ ñā é un ntɨꞌɨ̄ é īo íña ña ne, ntē ña ni ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ñadɨ̄ꞌɨ́ saꞌá ne, xée ētsin ña ata Jésuu. Tɨɨn ntaꞌa ña ntēte duꞌnu Jésuú ne, ura tsí i ntuváꞌa ña é kaetɨ nɨñɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kidáā né, tsixeꞌe Jēsuu ñáꞌa san: —¿Xoó ntu tɨ́ɨn ntaꞌa ī ko? —kaꞌan ña. Un ntɨɨ́ ntɨɨ̄ ñá ne, ntákaꞌan ña tsí ña te dɨvi ña e tɨ́ɨn ntaꞌa ña ñā. Pedrú san ne, kakaꞌan ña: —Mastrú, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntánataꞌu nūu ña nto ne, ntátsiꞌi ntido ña nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ntá tsi Jesuú ne, kakaꞌan xtúku ña: —Īó xoo tɨ́ɨn ntaꞌa ī ko. Tsí kutuní ko tsí kúvi ntuváꞌa ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dā kutuní ñadɨ̄ꞌɨ́ san tsí ña kuvi kuxuꞌú ña ne, koó da kānɨ́ꞌɨ ñā, nakunchɨ́tɨ ña nú dɨ̄ꞌɨ́n Jesuu. Kidáā ne, kakaꞌan ña méꞌñū un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san tsí iō nuu i é tɨɨn ntaꞌa ña Jēsuú ne, kakaꞌan ña tsí ura tsi ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kidáā ne, kakaꞌan Jésuu ni ña: —Iꞌxá ko, é ntuváꞌan ve, tsí nuu é ntaā i e kuíntiꞌxe o ko. Vāꞌa váꞌa tsi koo kunúꞌun ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kakaꞌan dúkuan Jēsuu dá xēe uun ñaꞌa, ñá nīꞌi túꞌūn iña ñá odo nūu íña viꞌi mí ntánataká nuu ña Israeé san ne, kakaꞌan ña: —Diōkó nto ne, e xíꞌi ñā. Ñá ku nāteku duꞌxén ka nto mastrú san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ntá tsi téku Jēsuú ne, kakaꞌan ñá ni ñā: —Ñá ku uꞌvī o. Mii tsī é kuintiꞌxe o ne, ntuváꞌa dióko ō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kidáā né, dā xee ña nú viꞌi ña kān ne, ñá ni xēꞌé Jesuu é kɨ̄ꞌvi nté uun ñaꞌa; mii tsī Pedru ni Sántiau ni Juaán san, ni uva īꞌxá san ni dɨꞌɨ̄ i. ");
INSERT INTO mizNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Un ntɨɨ́ ntɨɨ̄ ñá ntoo sán ne, ntaéku ña, tsi é xiꞌi iꞌxá san. Ntá tsi kakaꞌan Jésuu ni ña: —Ña kuéku ká nto, tsi táꞌnu kūdií san ne, ñá te ni xīꞌí tun, tsí kūdii kakidí tun —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Un ntɨɨ́ ntɨɨ̄ ñá xkuntée ña ña, tsi íni ñāꞌa san tsi é xiꞌi ntíꞌxe a iꞌxá san. ");
INSERT INTO mizNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kidáā ne, kárkāa Jesuu ntaꞌa i ne, un ntii tsi kākaꞌan ña: —¡Tāꞌnú kudii, nakuntítsin! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ura tsí i ntóto tún ne, nákuntītsí tun ne, kakaꞌan Jésuú é na kuēꞌé ña é kāꞌxí tun. ");
INSERT INTO mizNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Uvā tún ni dɨꞌɨ̄ tún ne, koó dā kúduꞌva ña é kuan ō kúvi. Ntá tsi Jesuú ne, kakaꞌan ña é ña káꞌan ñá nī nté uun ñaꞌa san nté ō kúvi ntóto tun. ");
INSERT INTO mizNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesuú ne, nātaká nuu ña uxuvi ñáꞌa ña ntɨniꞌi ñā ne, xéꞌe ñā é kūvi vií ña kada kúꞌvē ña iña é ña váꞌā san é nakuitā ñá i, nī é kūvi vií ña ntaváꞌa ña ñaꞌa san da nēé ka nuu kuíꞌi e ntákuvi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Taxnūu ña ña é kíkaꞌan ntódo ña túꞌūn iña i mí kadē kûꞌvé Xuva ko, nī é ntaváꞌa ña ña nchokuvi. ");
INSERT INTO mizNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kakaꞌan ñá ni ñā: —Ñá kū neé kuido nto é kɨꞌɨn ntó itsi kān; nté tatūn, nté itɨn, nté tāñúꞌū, nté diuꞌun, nté uun naꞌa duꞌnu nto ña kuníꞌi nto. ");
INSERT INTO mizNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dā míꞌī ká viꞌi mí xēe ntó ne, kuntōo nto un tsi da nté ntāka nto ñuú san. ");
INSERT INTO mizNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dā míꞌī ká ñuú san mí ña ntío ña é kuntōo nto ne, ntaka nto ikān ne, nakɨdɨ nto xáka dɨ̄ꞌɨ́n nto vata koo é kunīꞌi ña kuenta é nakūnaá mii ñā kúñu ñā é ña ni ntío ña túꞌun Xuva kō —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kidáā ne, kuéꞌen ñā, ita ntíꞌxin ña taꞌán ñuu taꞌán ñuu, ntákaꞌan ña túꞌūn é vāꞌá san nté koo nakáku ñaꞌa san ne, dā míꞌī ka mí kuēꞌen ñá ne, ntaváꞌa ña ña nchokuvi. ");
INSERT INTO mizNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rei Heródē né, tēkú ña e ntákaꞌan ñáꞌa san iña Jésuu é un ntɨꞌɨ nūu i é kade ña ne, un tsi kúdana iní ña, tsí iō ñá ne, ntákaꞌan ña tsí Juaan Bautistá ne, é ntōto ña ve é xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Iō ñá ne, ntákaꞌan ñá tsi é ntii díto ña kaꞌán naa Xuva ko, ñá nani Ēliá ne, iō ñá dɨ ne, ntákaꞌan ñá tsí ña kaꞌán naa Xuva ko, ña ntivú dɨ ne, e ntóto ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kidáā ne, kakaꞌan Heródē san: —Tsí xuꞌu ntu ku é taxnūu u é kaꞌntē ñá dɨkɨ́ Juaán san ne, ¿xōo ntú ñaꞌa ña tsīkán kuān, e dóo katekú ko é ña te nté kaa nuu i é kade ña? —kaꞌan ña. Dukuān né, ntukū nuu ini Heródē san nté koo kiní ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dā náxee ñá ntɨniꞌi ñā ne, ntaa ña ni Jēsuu nté o dé ña. Kidáā ne, kueꞌen níꞌi xio Jesuú san ña ntɨniꞌi ñā uun ñuu é nani Bētsaida. ");
INSERT INTO mizNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ntá tsi dā kútuni ñáꞌā sán ne, íntikɨ̄n ñá Jesuu. Jesuú san ne, dōo váꞌā o dé ña ni ñā, kakaꞌan ñá ni ñā iña mí kadē kûꞌvé Xuva kō ne, ntaváꞌa ña ña nchokuvi. ");
INSERT INTO mizNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dā kuáā ne, xée etsin ña ntɨniꞌi ñā san mí tuví Jesuu, ntákaꞌan ña: —Káꞌan nto ni ñāꞌa san, na kɨ́ꞌɨn ña, kintúku ña mí kuntoo daꞌna ña ne, na kintúku ñā é kaꞌxī ña da míꞌī ká ñuu é ntoo étsin iꞌa. Tsí iꞌa ne, ña túvī nee iñá iō kueꞌen tsi é kaꞌxī ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ntá tsi Jesuú ne, kakaꞌan ñá ni ñā: —Mii nto kuēꞌé nto ña é kaꞌxī ña —kaꞌan ña. Ne, kakaꞌan ñá ntɨniꞌi ñā: —Kūdii uꞌún sa tañúꞌu ni ūví sa tsáka iō tɨ. ¿Vá kikuiín ntu ntɨ é kāꞌxí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tsí iō ñá te ūꞌun míil ñatīí san ntoo ña. Ntá tsi Jesuú ne, kakaꞌan ñá ni ña ntɨniꞌi ñā: —Káꞌan nto, na kuntōo ña uvi díko uꞌxi uvi díko uꞌxi ñáꞌa ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kuan ō dé ña ne, íntōo ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kidáā né, kīꞌi ntɨꞌɨ Jesuu é ūꞌun tañúꞌu ni ūvi tsákā. Īto ña e dukún kān ne, dā nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō. Kātsin dava ña ne, dā xeꞌé ña ña ntɨniꞌi ñā é tsīꞌi ña ntaꞌa ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ēꞌxi ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san da nté ku e ntáꞌa ña. Dā kúvi éꞌxi ña ne, nákuꞌun tsitū ká uxuvi xiká utsi i é ntoó ka. ");
INSERT INTO mizNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Uun ntuvi ne, kakaꞌan ntâꞌví Jesuu é da mii tsi ña ni ña ntɨniꞌi ñā ntoo ña ne, tsixeꞌe Jēsuu ña: —¿Neē ntú ñaꞌa ú, tē kaꞌan ñáꞌa san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nantíko koō ñá, ntákaꞌan ña: —Iō ñá ne, ntákaꞌan ña tsí Juaan Bautista nto. Iō ñá ne, ntákaꞌan ña tsí Elia nto. Iō túku ña ne, ntákaꞌan ña tsí ña kaꞌán naa Xuva ko, ña ntivu ntó, ña e ntóto xtuku é xiꞌi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Dɨvi ntō ní, ¿neé ñaꞌa ú, te kuinī nto? —kaꞌan Jésuu. Pedrú ne, nantíko koō ñá, kakaꞌan ña: —Dɨvi ntō é Cristu nto, ña e táxnuu Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ntá tsi dóo kaꞌan Jésuu é ña ku kaꞌán ña nī nté uun ñaꞌa nuu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kakaꞌan ña: —Xuꞌu é vēxkúvi ú ñatīí ne, kantio e dóo ntoꞌo ko. Dōó nantii niꞌni ñatā sán ko, dɨvi ña nī tóꞌō dutú san nī mastrú lei. Kaꞌní ña kó ne, ntá tsi tē kúvi uni ntúvi ne, ntoto u —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kidáā ne, kakaꞌan ñá ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san: —Tē xoó ncho kuntīkɨ́n i kó ne, ña kú de ká ña kuenta íña mii ña ne, utén utén san ne, na kuntikɨ̄n ñá ko, kuān te dóo ntoꞌo dadɨɨ ña nī ko. ");
INSERT INTO mizNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Xoo é ncho nakakū mii i ntuvi iña í ne, kunaá ña. Ntá tsi tē xoo nakunaá i ntuvi iña í kuenta iñá ko ne, nakáku ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Neé ntu kaidiáꞌvi ñatīí san te nīꞌi ñá kanɨɨ ñūxiví san, te kūnaá mii ntu ñā ne, o tē natɨ́vi mii ñā kúñu ñā? ");
INSERT INTO mizNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tē xoó kakukaꞌan nuu i túꞌūn kó ne, xuꞌu é vēxkúvi ú ñatīí ne, kuan kōo kukaꞌan nuú ko í dɨ ntuvi dá nainú u é koó dā káxiꞌi nuu kaꞌnú u vata kaa Uvā kó nī ánje ñā, ña e dóo vaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nuu é ntaā i é kāꞌán u ni nto ne, iō nto é ntoo nto iꞌa vevií ne, ña kúvī ntó tē ña diꞌna kiní nto míꞌi kadē kûꞌvé Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","E kúvi te ūna ntúvī é kuān ó kakaꞌan Jésuu ni ñá ne, kúxēe ña uun xuku mí kūkaꞌan ntâꞌví ña. Kuéꞌen ña nī Pedru ni Sántiau ní Juaan. ");
INSERT INTO mizNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nɨɨ dukuan kākaꞌan ntâꞌví ña ne, nādama nuu ña. Dóo ñā né, ntukuiꞌxīn kueꞌén ne, dōo kaxiꞌí nuu. ");
INSERT INTO mizNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kidáā ne, xee dîtó uvi ñaꞌa ñátīi, ntatíin ña ni ñā. Ña sāꞌá ne, Muisee ni Élia. ");
INSERT INTO mizNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Un tsi kaxiꞌí nuu kaꞌnu ntīkó diñɨ ña. Ntatíin ña nté koo kada ntaa Jésuu é kuvī ñá ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kuān te dóo ncho kidí Pedru ni ña ntɨníꞌi ña ne, kuan tsī ó intíto ña da íni ña Jesuu e dóo kaxiꞌí nuu ña, nī ntuvi ñátīi, ña ntâñɨ niꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kidáā né, kīi nteé xio ñatīí san Jesuu, kuéꞌen ñā ne, kakaꞌán Pedrú san: —Mastru, ¡nté kui váꞌa ō é ntoo o īꞌa! Viꞌi a vé ne, kada váꞌa ō uni á viꞌi xóꞌō san, uun iña nto, uun iña Muísee, ni uun iña Élia —kaꞌan ña. Ntá tsi Pedrú san ne, dotō tsí kakaꞌan ña; ntē ña íni ña ne nuu i é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nɨɨ dukuan kākaꞌan ñá ne, xée uun vīkó ne, nākunuu táꞌan dava ña ni ntatɨ ī né, dōo uꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kidáā ne, méꞌñū viko véꞌxi uun tātsín, kakaꞌan: —Ña sāꞌa é Iꞌxá miī kó, ña e dé kûꞌvé u. Kini váꞌa nto nee é kākaꞌan ña —kaꞌan tátsín san. ");
INSERT INTO mizNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dā kúvi kaꞌan tátsín ne, īní ña tsí da mii tsi Jēsuu tuví ña. Kidáā ne, diin diin tsi ntoo ña. Tɨtɨ́n ntuvi e nté uun xoxo ni káꞌan í ni tūku ñaꞌa nee iña é īni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Utén san ne, dā núu ña xuku ne, ñá tē nté kaa ñaꞌa kukuetú itsi ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kidáā né, uun ñaꞌa ñatīí, ña é nuu taꞌan méꞌñū ñaꞌa sán ne, un ntii tsi kākaꞌan ña: —Mastru, vií nto da xeꞌe, koto nto iꞌxá ko, tsí kuan tsī kaa uun iꞌxá ko. ");
INSERT INTO mizNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kiní nto tsí uun é ña váꞌā san katɨ́ɨn i ne, kade é uun ito tsi kakachuꞌu ntáa ne, kaxiꞌi míī ne, kakii tiñu xúꞌu i dɨ. Kantuku kuīꞌi é ña váꞌā san i ne, ñá ncho nangāvá iꞌxá ko. ");
INSERT INTO mizNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","E íkān ú da xeꞌe ntaꞌa ña ntɨniꞌi ntō é nakuitā ña é ña váꞌā san ne, ña ni kúvi viī ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nantíko kōó Jesuu, kakáꞌan ña: —¡Ntoꞌō é ntoo nto vevií ne, ntē ña ntákuintiꞌxe nto! ¡Dōó doꞌo nto! ¿Nté ntu kaa ntuvi é kutūví u ni ntō, é kūtíī kó nimá ko ni ntō? —kaꞌan ña. Kidáā ne, kakaꞌan ñá ni uva īꞌxá san: —Taꞌxin iꞌxá o iꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dā vé kaxee étsīn á na kudií san ne, nantáva é ña váꞌā san na nte ñúꞌu kān. Ēde e xiꞌi míi xtūku na. Ntá tsi Jesuú ne, dē tíi ña nī é ña váꞌā san. Ntāváꞌa ña na kudií san ne, nakuéꞌe ña na ntaꞌa uva nā. ");
INSERT INTO mizNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san koó dā kúduꞌva ña ne, dōó kaꞌnu kuíni ña ni Xuva kō. Nɨɨ dukuān ntaíto díto ñaꞌa san nēe é kade Jesuú ne, kakaꞌan ñá ni ña ntɨniꞌi ñā: ");
INSERT INTO mizNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Kini váꞌa nto é kākaꞌán u ne, ñá ku kūnáa inī nto; tsí xuꞌu é vēxkúvī ú ñatīí ne, ntuví u kuenta ntáꞌa ña ñuú i san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ntá tsi ña ntɨniꞌi ñā ne, ñá ni ñēꞌe dɨkɨ ña túꞌūn é kākaꞌan Jésuu, tsi dóo xūꞌú o, kuiní ña. Dōo ntaúꞌvī ña é tsixeꞌe ña Jēsuu nee iña é kāni túꞌun é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kidáā né, eni ntuꞌu ñā ntánatíin ña xoó ntu ñaꞌa ña é dií ka kainuu áꞌvi i. ");
INSERT INTO mizNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Dā kútuni Jésuu nee iña é ntádē kuení ña ne, kīꞌi ña uun iꞌxá san, xtuvī ñá i díñɨ ñā ne, ");
INSERT INTO mizNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","dá kakāꞌan ñá ni ñāꞌa san: —Xoo é kiꞌi i uun a iꞌxá sa kuenta iñá ko ne, vata tsi te xūꞌú kiꞌi ña ko. Xoo é kīꞌi i kó ne, vata tsi te kīꞌi ña ña táxnūu ko. Dukuān ne, xoó ñaꞌa, ña é ña kainuu áꞌvi iña nto, kuinī ntó ne, dɨvi ñā e dií dií ka kainuu áꞌvi ña kuenta iña Xuva ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nantíko kōó Juaán san, kakaꞌan ña: —Mastru, é īní ntɨ uun ñaꞌa, ña é kakaku niꞌi dɨvī nto é kanakuita ñā é ña váꞌā san. Ntɨꞌɨ́ ne, ña ni ntíō ntɨ é kuān koo vií ña, tsí ña te kaduku ntée ña kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ntá tsi kakaꞌan Jésuu ni ña: —Ñá ku kuān xkoó de nto ni ñā, tsi xoo é ña kakaꞌan ntée i kō ne, kakuiniꞌi ña kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dā dokó sa xee ntúvi é ntāa Jesuu e dukún kān ne, kakaꞌan ña tsí da miī é kɨ̄ꞌɨn ñá ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Diꞌna dá kɨꞌɨn ñá ne, taxnūu ña ñaꞌa é kɨ̄ꞌɨn ñá uun ñuú luꞌnti é tuví ñuú Samaria, é nantuku ñā míꞌi kutūví daꞌna Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ntá tsi ña ñuú Samariá san ne, ña ni ntío ñā é kutūví Jesuu ñuú ña, tsi é kūtuni ña é Jerusaleen kɨ́ꞌɨn ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tēkú ña ntántīkɨn ñá, Santiau ní Juaán ne, ntákaꞌan ña: —Tōꞌó, ¿ntio ntu nto é kākán ntɨ é na kīi ñuꞌu e dukún kān é na kōko kueꞌen ñá, vatā o dé Eliá san? —kaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ntá tsi xkókōó Jesuú ne, dē tíi ña ni ñā, kakaꞌan ña: —¿Ña íni ntú nto xoo é ntántīkɨn nto? ");
INSERT INTO mizNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tsí xuꞌu é vēxkúvi ú ñatīí ne, ñá te vēꞌxí u é nākunaá u ñaꞌa san, tsí véꞌxī u é nakākú u ña —kaꞌan ña. Kidáā ne, kuéꞌen ña ūun ka túku ñuú luꞌnti. ");
INSERT INTO mizNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nɨɨ dukuan kuēꞌen ñá itsi kān ne, uun ñaꞌa ne, kakaꞌan ñá ni Jēsuu: —Ntio ko é kuntīkɨ́n u nto dā míꞌī ka mí kɨꞌɨ̄n nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kakaꞌan Jésuu ni ña: —Ñúkuīí san ne, iō xavi tɨ mí kaintoo váꞌa tɨ. Lāá, kɨtɨ ntaíko e dukún san ne, iō taka tɨ. Ntá tsi xuꞌu é vēxkúvi ú ñatīí ne, ña túvī míꞌi kutūví daꞌna dɨkɨ́ ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kakaꞌan Jésuu ni túku ñáꞌa: —Kuntīkɨ́n ko —kaꞌan ña. Ntá tsi kakaꞌan ñáꞌa san: —Tōꞌó, kuntētu kudii nto. Diꞌna nā kíkuꞌxí u uvā kó —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ntá tsi kakaꞌan Jésuu ni ña: —Na koo miī ña xiꞌí san. Nā kíkuꞌxí ña ntɨ̄xɨ́ niꞌi ña ñā. Dɨvīn né, kuēꞌén kūkaꞌan ntódon ni ñāꞌa iña i mí kadē kûꞌvé Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kakaꞌan túku ñaꞌa sán ni ñā: —Kuntīkɨ́n u nto, Tóꞌō. Ntá tsi tāꞌxi nto é dīꞌna kíkaꞌán u nī ña ntoo nú viꞌī kó kān —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ne, kakaꞌan Jésuu ni ña: —Xoó ñaꞌa, ña é ña kaíka ntaa itsi Xúva kō ne, ñá vādá mí kaidiáꞌvi ña mí kadē kûꞌvé Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Rkontûví ne, nākaxnúu xtuku Xúva kō uni díko uxuvi ñáꞌa. Uvi úvi ñāꞌa ña táxnuu ña é kodo nuū ñá, kɨꞌɨn ña da míꞌī ká ñuú mí dā vé kɨꞌɨn ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kakaꞌan ñá: —Dōó kueꞌe tsíñu iō, ntá tsi ña ntáde tsiñu ne, ñá tɨtɨ̄n ña. Dukuān ne, kákan nto ntaꞌa tóꞌo tsīñu san é na taxnūu ká ña ña é kāda tsiñu. ");
INSERT INTO mizNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Viꞌa ve ne, kueꞌēn nto. Ntá tsi koto nto, tsí vata ntáa a leꞌntú san ntáa nto é ñā te díin nto, ntá tsi taxnūú u nto é kɨ̄ꞌɨn nto mí ntoo ña dóo diin san, é vāta ntáa ñañā ntáa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ñá kū kuído nto ītɨ́n nto, nte é kāñúꞌu diuꞌun nto, nté ntīꞌxen nto. Ñá ku kāꞌan ntó ntiusi ni ña ntaíka itsi kān. ");
INSERT INTO mizNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dā míꞌī ká viꞌi mí xēe ntó ne, nāxnuu viko nto viꞌi san. Káꞌan ntō é na vāꞌá tsi koo kuntōo ña nú viꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te ikān tuví uun ñaꞌa, ña é ña te dūꞌxen dɨ́kɨ í ne, kuntaa é kūntoo váꞌa ña nú viꞌi ñā. Ntá tsi tē ña kuan ó ne, ñá kuntāa é kūntoo váꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Uun tsi viꞌi san kuntóo nto ne, ñá nadāma nto. Kaꞌxí nto ne, koꞌo nto nee é iō, tsí ña kaika má tsiñu sán ne, váꞌa ō é nakiꞌī ña xáꞌvi ñā. Ñá ku īka nto taꞌán viꞌi taꞌán viꞌi. ");
INSERT INTO mizNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tē xee ntó uun ñuu mí ntio ña nto ne, kaꞌxí nto nee iña é tāꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ntaváꞌa nto ña ntánchokuví san mí kɨ̄ꞌɨn nto. Káꞌan nto ni ñā tsi é veꞌxi étsin ntuvi é kadā kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ntá tsi tē xee ntó uun ñuu mi é ña ntío ña nto ne, ntii nto itsi kān ne, káꞌan ntō: ");
INSERT INTO mizNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“¡Un tsi nte xákā ñuú nto é tɨɨn dɨ́ꞌɨ̄n ntɨ́ ne, nakɨdɨ ntɨ́ vata koo é na kūtuni nto tsi ñá váꞌa o ni ide nto nī ntɨ! Ntá tsi kini nto sáꞌā, tsi mí kadē kûꞌvé Xuva kō ne, é xee étsin nte mí ntoo ntō”, kuan kōo kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ntá tsi kakaꞌán u ni ntō tsí tē xee ntúvi é ntɨ̄ꞌɨ ñuxiví sa ne, dií dií ka kueꞌe ntoꞌo ña ñuú tsikan é vata kaa ña ñuú Sodoma. ");
INSERT INTO mizNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ʼ¡Ña ntáꞌvi ide nto, ña ñuú Coraziin! ¡Ña ntáꞌvi ide nto, ña ñuú Betsaida! tsí tē dɨ́ ni kuvi nūu í e dóo naꞌnu san ñūú Tiru ni ñuú Siduun é vata ō kúvi ñuú nto ne, ēmá tsi e natúꞌvi ña kuétsi ñā, nté ēmá tsi ñuꞌú ña doo kueñɨ ne, dáꞌvi ña xāa kúñu ñā e dóo ntoo ntaꞌxa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ntá tsi tē xee ntúvi é ntɨ̄ꞌɨ ñuxiví san ne, dií ka iō é ntoꞌo nto é vata kaa ña ñuú Tiru nī ña ñuú Siduun. ");
INSERT INTO mizNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dɨvi ntō ní, ña ñuú Capernaú ne, ¿kɨ̄ꞌɨn ntú nto un tsi nte e dukún kan, te kuinī nto? ¿Míꞌi ntū? Tsí un tsi nte e kunú kan kɨ̄ꞌɨn nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kakaꞌan túku ña ni ña ntɨniꞌi ñā: —Xoo é kainí i túꞌun ntō ne, vata tsi te miī ú kainí ña. Xoo é kanakuītá i nto ne, vata tsi te xūꞌú kanakuitā ñá ko dɨ. Xoo é kanakuitā í ko ne, kanakuitā ñá ña táxnūu kó dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ntɨꞌɨ ūni díko uxuvi ñáꞌa sán ne, dōó diní ña náxee ña, ntákaꞌan ña: —Tōꞌó, un tsi nte é ña váꞌā san ntákuintiꞌxe i ntɨ́ da ntákaꞌán ntɨ kuenta iña nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kakaꞌan Jésuu ni ña: —Nuu é ntaā ntíꞌxe i tsí iní u dá kōꞌxó tóꞌō e ña váꞌā san e dukún kān é vata kaa ntuve ñūꞌu dá kāxiꞌí nuu. ");
INSERT INTO mizNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ini nto tsí xuꞌu táꞌxī u é kūvi vií nto é kāka nuú nto koó san, ō tduꞌmé san. Tāꞌxí u é kūvi vií nto nī é ña váꞌā sán, kuān te dóo ntīi, é ntē ña váda nto niꞌi kuiꞌi. ");
INSERT INTO mizNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ntá tsi ña ku nakunuu dîní nima nto tsí é ña váꞌā san ntákuintiꞌxe i nto, ntá tsi na nākunuu dîní nima nto tsi é ūve naꞌa dɨ́vī ntó e dukún kān —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ura dúꞌva tsi i xéꞌe Espíritū Sántu san é nākunuu dîni kuéꞌen nima Jésuú ne, kakaꞌan ña: —Xuva, Tōꞌó e dukún kan ni ñūxiví san, nataꞌxi ú sintiáꞌvi ntaꞌa nto, tsí nañéꞌe ntó ña ntâꞌví san nuu i é xtúvi xuꞌú nto iña ña e dóo kiꞌin inī í, ña e dóo tuꞌvé i. Dukuān ó de nto, Xuvā, tsí kuan ō ntío nto —kaꞌan ña—. ");
INSERT INTO mizNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ʼXuvā kó ne, kuān o ntío ña é tāꞌxi ñá ko é un ntɨꞌɨ nūu i é īo. Nté uun xoxo íni i xoo é iꞌxá Xuva kō; mii tsi Xuva ko īni ña. Nté uun xoxo íni i xoo é Xuva kō; mii tsi iꞌxā ñá, nī ña é ncho kuéꞌe īꞌxá ña é kūtuni ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kidáā né, īto ña ñá ntɨniꞌi ñā sán ne, diin diin tsi kakaꞌan xío ña ni ñā: —¡Nté kui váꞌā ó xoo é kainí i nuu i é ntaíní nto! ");
INSERT INTO mizNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tsí kaꞌán u ni ntō tsí ña te da díi ña kaꞌán naa Xuva ko ni rēí san ntio ña é kīní ña sáꞌā e ntaíní nto, ntá tsi ña ni kuvi kiní ña. Ntio ña é tekū ña sáꞌā e ntátekú nto, ntá tsi ña ni kuvi tekú ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Uun mastrú leí san ne, nákuntītsí ña, kakaꞌan ñá ni Jēsuu é kōto nteé ña ña nté koo kaꞌan ña. Tsixeꞌe ña ñā: —Mastrú, ¿ntē ntú koo vií u vata koo é nīꞌí ko ntuvi vāꞌá iñá ko ntii dañu ntūvi? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesuú ne, kakaꞌan ña: —¿Nte ntū ó uve naꞌa lei e xtûví Xuva kō? ¿Nte ntū ó kakaꞌan, te kuiní o? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nantíko kōó mastrú leí san, kakaꞌan ña: —“Na kuīnima kó Xuva ko da kanɨɨ̄ nima kó, nɨɨ kuéꞌen ini kō, kanɨɨ̄ é kadē kuení kō né, na kuīnima kó taꞌan ko vata tsī ó kakuinima míi kō kúñu kō” —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kidáā ne, kakaꞌan Jésuu: —Váꞌā ó vata ō nantiko koón kakaꞌan. Te kuān koo viin sáꞌā ne, níꞌi o ntuvi vāꞌá iña o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ntá tsi mastrú leí san ne, ntīo ña é nadaꞌan ñā kúñu ñā né, tsixeꞌe ña Jēsuu: —Ntá tsi ¿xoó ntu é taꞌan ntiꞌxe i ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Uun ñatīí ne, ntīi ña ñuú Jerusaleen, kuéꞌen ña ītsi ñuú Jericoo. Ítā ntiꞌxin ña mí ñūꞌu ña duꞌú ne, īdo dúꞌu ña iña ña. Nātavá ña un tsi nte dúꞌnu ñá ne, ēꞌní ña ña. Dā náxtūvi íxī ñá ña itsi kān e dóko sā kúvi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dā ku e víꞌi ne, ítā ntiꞌxin uun dutu ítsi san. Īní ña ñatīí san ne, dá xio diñɨ itsi san inteé xio ña, kueꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kuan tsī o ita ntíꞌxin uun ñaꞌa ña levita, ñá kaxntii dūtú ne, dā íni ña ña niꞌi kuiꞌí i san ne, dá xio diñɨ itsi san díta ña, kuéꞌen ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ntá tsi uun ñatīí, ña véꞌxi ñuú Samariá ne, dɨvi tsi itsī san ítā ntiꞌxin ña dɨ. Dā íni ña ña niꞌi kuiꞌí i sán ne, ntuntāꞌví ini ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kidáā ne, xée ētsin ña mí tuví ña ne, dé choꞌo ñá ña mí niꞌi kuiꞌí ña. Nakútsi nūu ña asete ni vínu mí niꞌi kuīꞌí san ne, kīꞌní nuu ña doo. Kidáā né, xntekū ñá ña ata idú ña, dā kueꞌen niꞌi ña ña uun viꞌi mí kutuvī ña. Ikan īdé ña ña kuenta. ");
INSERT INTO mizNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tévāá san ne, ña ñuú Samariá ne, tāvá ña uví diuꞌún kuīꞌxin é kuēꞌé ña tóꞌo vīꞌi sán ne, kakaꞌan ñá ni ñā: “Vií kudii nto kuenta ñátīí saꞌa. Te kuēꞌe nantɨꞌɨ ñá iña ntó ne, ntaꞌvi ú tē ntíko kōó u”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Viꞌi a vé ne, káꞌān: ¿Xoó ntu é ntuni i e kúvi taꞌan ntiꞌxe ñatīí, ña ntúku kuīꞌi ña duꞌú san, te kuinī o? —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ne, kakaꞌan mástrú leí san ni Jēsuu: —Ña ntúntaꞌví ini i ña san —kaꞌan ña. Kidáā ne, kakaꞌan Jésuu: —Kuēꞌén ne, kuan tsi kōo viín dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesuu ni ña ntɨníꞌi ñā ne, da kueꞌen dá kueꞌen ña itsi kān ne, xée ña ūun ñuu. Ikān né, uun ñadɨ̄ꞌɨ́, ñá nanī Martá ne, xéꞌe ña vīꞌi ña é kutūví Jesuú san. ");
INSERT INTO mizNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Uun taꞌan ña, ñá nani Māriá ne, ítūví etsin ña nú dɨ̄ꞌɨ́n Jesuu é kīni ña é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ntá tsi Martá san ne, dōó kadē kuení ña, tsi dóo iō tsíñu ñā é viī ña. Xée ētsin ña mí tuví Jesuú ne, kakaꞌan ñá ni ñā: —Tōꞌó, ¿ñā ntu te káde nto kuenta tsí taꞌan kó ne, ñá te kaxnchíi tún ko nu tsiñu ko? Káꞌan nto, na xnchii kūdií tun ko —kaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ntá tsi Jesuú ne, nantíko koō ñá, kakaꞌan ñá ni ñā: —¡Aí, Marta! Dōó kadē kuení o. ¿Nté kuān nte kueꞌe ntu núu i é kadē kuení o? ");
INSERT INTO mizNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ntá tsi uun tsi nuu i e dóo nuu áꞌvi. Mariá ne, é nakaxnúu ña uun nuu i e dóo váꞌa é ntē xoxo kuvi nakiꞌi núu i iña ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Uun ntuvi ne, tuví Jesuu, kakaꞌan ntâꞌví ña. Dā kúvi kaꞌan ntâꞌví ña ne, uun ñaꞌa ña ntɨniꞌi ñā ne, kakaꞌan ñá ni ñā: —Tōꞌó, nañeꞌē ntó ntɨ nté koo kaꞌan ntâꞌví ntɨ vatā o nañéꞌe Juaan Bautista ñaꞌa, ña ntɨníꞌi ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kakaꞌan Jésuu ni ña: —Dā ntákaꞌan ntâꞌví nto ne, duꞌva koo kaꞌan nto: Xuvā ntɨ́, ña tuví e dukún kān, na kuiko ñuꞌu ñāꞌa sán nto. Na kīꞌxi ntuvi é kixkadā kúꞌvē ntó ñuxiví a. Vata tsī ó de nto e dukún kān ne, kuān tsi koo vií nto ñuxiví a dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Taꞌxī nto é kāꞌxi ntɨ é vīꞌa é ūten. ");
INSERT INTO mizNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kada kaꞌnu iní nto nī ntɨ kuétsī ntɨ, vata tsī ó ntáde kaꞌnu iní ntɨ ni un ntɨꞌɨ tāꞌan ntɨ, ña tanuu iñá ntɨ. Ñá ku dā váꞌa ntō é kōꞌxó ntēé ntɨ é kōto ntee é ña váꞌā sán ntɨ. Kuan kōo kaꞌan ntó ni Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kakaꞌan xtúku Jesuu ni ña: —Vií ka o kuēntá ni: Te ūun ntó īó ña dóo váꞌa tiin niꞌi ntō ne, kɨ́ꞌɨn nto dava ñūu nú viꞌi ña kān, káꞌan ntō: “Ña táꞌxi kudii nto uni íta nto te nākiꞌi nteé u, ");
INSERT INTO mizNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tsí uun ñaꞌa ña dóo váꞌa tiin niꞌī ú ne, dā ve xee ña nú viꞌī kó kān é vēꞌxí ña itsi kān ne, ña túvī neé kueꞌen tsi é kuēꞌe ú kaꞌxí ña”, koo kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿Vá kāꞌan ntú ña tuvi má viꞌi kān: “Ñá ku natēku duꞌxen ntó ko, tsi xiꞌí ko ne, é kantiꞌu. E tuví ntāá u ni īꞌxá ko. Ña kúvi nākuntítsi u é tāꞌxi u é ntio nto”, koo kaꞌan ña? ");
INSERT INTO mizNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ntá tsi kakaꞌán u ni ntō tsí, kuān té ña ntio ña nakuntítsi ña é kuēꞌé ña é kaikán ña váꞌa tiin niꞌi ñā ne, kuéꞌe ña vata kaa é kantio ña vata koo é ña natekú duꞌxen ká ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Dukuān é kākaꞌán u ni ntō: Kákan ntō ne, níꞌi ntō. Nantuku ntō ne, naniꞌi ntó dɨ. Te nakeꞌxen ntō xiꞌí ne, nakaán ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tsí xoo é kaikan ī ne, níꞌi i. Xoo é kanantuku ī ne, naniꞌi í dɨ. Xoo é kanakeꞌxen ī xiꞌí ne, nakaán ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ʼTe ūun nto é uva īꞌxá nto ne, tē kaikan iꞌxá nto tsákā é kāꞌxí ne, ¿vá kuēꞌé ntu nto i koo é kāꞌxi? ");
INSERT INTO mizNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O tē kaikan ntɨ́vi é kāꞌxí ne, ¿vá kuēꞌé ntu nto i tduꞌme é kāꞌxi tɨ? ");
INSERT INTO mizNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ntá tsi ntōꞌo é kini ntáa ntō ne, ini nto é kuēꞌé nto é vāꞌá iña iꞌxá nto. ¿Ñā ntu te dií dií ka ini Xúva kō, ña é tuví e dukún kān, é kuēꞌé ña un tsi nte Espíritū Sántū san xoo é kaikan i ntáꞌa ña? —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Uun ntuvi ne, kanakuītá Jesuu é ña váꞌā san e dé ñɨꞌɨ uun ñaꞌa ñatīi. Dā ntíi ne, kūvi nákaꞌan ñá ñɨꞌɨ̄ san. Koó dā kúduꞌva ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ntá tsi iō ñá ne, ntákaꞌan ña: —Ñatīí saꞌá ne, kanakuitā ñá é ña váꞌā san tsí kaxeꞌe Belsēbuu, tóꞌō e ña váꞌā, é kūvi vií ña nakūnu ña i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Iō ñá ne, ncho koto nteé ña ña. Íkan ñā é viī ñá nuu i e dóo kaꞌnu é vēꞌxí e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ntá tsi kutuni Jésuu nee e ntádē kuení ñaꞌa sán ne, kakaꞌan ñá ni ñā: —Dā míꞌī ká ñuú mi ntánāa núu ña ni tāꞌan ña ne, kunaá ñuú ña. Tē ntánāa núu mii ña nī ña viꞌi ña ne, kɨɨn viꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dukuān né, tē tóꞌō e ña váꞌā sán naa ni tāꞌan í ne, ¿nté ntu koo kuvi vii? Sáꞌa kakāꞌán u ni ntō, tsi ntákaꞌan nto tsí kataꞌxi Belsebuú san é kūvi vií u nákuīta ú e ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ntá tsi te kuān ó ne, ¿xoó ntu kaxéꞌe ī é kūvi vií ñaꞌa nto é nakuitā ñá é ña váꞌā san? Dukuān né, mii ñā ntánañēꞌe ña tsí ña te nuu é ntaā i e ntákaꞌan ntó iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ntá tsi te Xuva ko kātaꞌxi ña é kākuvi vií u é kanakuītá u é ña váꞌā san ne, kani túꞌun tsi é xee Xúva kō mí ntoo nto é kadā kúꞌvē ñá iña nto. ");
INSERT INTO mizNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ʼTe uun ñatīí, ña e dóo ntii inī í ne, dōó iō tuꞌvé ña é kade ña kuenta víꞌi ña ne, ñá te neé kuvi iña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ntá tsi te vēꞌxí uun ñaꞌa, ña é dií ka ntii īní ka xtúku i é naā ñá ni ñā ne, kuvi vií ña ni ñā. Kidáā ne, nakuido ña un ntɨꞌɨ káā é kanadaꞌan nūu ña kúñu ña nī é un ntɨꞌɨ īña ñá, dá kuēꞌé xio ña é ido ñā san. ");
INSERT INTO mizNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ʼXoo é ña kañéꞌe i da xeꞌe kó ne, kakaꞌan ntée ña ko. Xoo é ña kaxntíī ko é natāká u ne, da dií ka kaeté xaa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ʼTē ntíi uun é ña váꞌā nima ñáꞌa sán ne, kaika ñuu itsí kān, kantukū míꞌi kūtuví daꞌna. Tē ña ni naníꞌi í ne, kada kuení i: “Ntiko kōó u, núꞌū u nú viꞌī kó kān mí kii u”, koo kada kuení i. ");
INSERT INTO mizNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Te nāxeé ne, naniꞌí i nima ñátīí san vata kaa uun viꞌi mí dóo váꞌa ntúntoo, mí dóo váꞌā o ntúvaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kidáā ne, kɨ́ꞌɨn xtūku kínakueka úꞌxē ká e ña váꞌā e dií dií ka kini ntáa. Kidáā ne, un ntɨꞌɨ̄ é ūná san kɨ́ꞌvi é kuꞌun nima ñátīí san. Kidáa ne, dā dií dií ka natɨ́vi ña é vata kaa díꞌna —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nɨɨ dukuan kākaꞌan Jésuu sáꞌā né, uun ñaꞌa ñadɨ̄ꞌɨ́, ña tuvi méꞌñū ñaꞌa sán ne, kachuꞌu ntáa ña: —¡Nté kui váꞌa ñadɨ̄ꞌɨ, ña é nakáku nto, ña é nātsitsí nto! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ntá tsi dɨvi ñā ne, kakaꞌan ña: —¡Nté kui dóo váꞌā o xoo é kainí i túꞌūn é kākaꞌan Xúva ko ne, dē ntaa ña! —kaꞌan Jésuu ni ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dā dóo nátaká nuu ñaꞌa san mí tuví Jesuú ne, eni ntuꞌu ña kākaꞌan ña: —Ñaꞌa, ña ntoo vevií ne, dōó kini ntáa ña. Ntaíkān ñá nuu i e dóo kaꞌnu, ntá tsi ña kuéꞌe Xuva ko ña nuu i san, mii tsi é kuēꞌé ña nuu i é vata ō kúvi nī ña kaꞌán naa Xuva ko, ñá nani Jōnaa. ");
INSERT INTO mizNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tsí vata ō kúvi Jonaa nuu i iña ñaꞌa, ña intóo ñuú Nínive kidáā ne, xuꞌu é vēxkúvi ú ñatīí ne, kuan kōo kuvi ú nuu i iña ñá ntoo iꞌa vevii. ");
INSERT INTO mizNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tē xee ntúvī é kōto nteé Xuva ko ñāꞌa, ne ñáꞌa ña ne, nakuntítsi reina iña ñuu é tuví nte díñɨ i kān e dóo ikā ne, tsiꞌi kuétsi ña ña, tsí reiná san ne, un váꞌa tsi ika vēꞌxí ña é kīni ñá un ntɨꞌɨ̄ é īní rei Salamuún san. Koto nto ve, tsí e xee úun ñaꞌa, ña é dií ka kaꞌnu ñaꞌa é Salāmuun. ");
INSERT INTO mizNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ña intóo ñuu Nínive kidáā ne, nakuntáñɨ̄ ñá tē xee ntúvi é koto nteé Xuva ko ñāꞌa sán ne, tsiꞌi kuétsi ña ña ntoo vevii. Tsí ña ñuu Nínive sán ne, nātɨvi iní ña kuétsi ña dā téku ña túꞌūn é kākaꞌan Jonaá san. Koto nto, tsí e xée ūun ñaꞌa, ña é dií ka kaꞌnu ñaꞌa é Jonaa. ");
INSERT INTO mizNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ʼNté uun xoxo natúun i ñuꞌu é kutuvī xuꞌu, nte é kutuvi má ētún san, tsí kuntekū dukun vata koo é naxīꞌi nuu mí kɨ̄ꞌví ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tsí ntuxnuu kó ne, vata kaa ñuꞌu é kāxiꞌí nuu kúñu kō kaa. Te vāꞌá ntuxnuu kó ne, kanɨɨ̄ kúñu ko kāxiꞌí nuu. Tē ña váꞌa ntuxnuu kó ne, kūñú ko ne, kutuví nee. ");
INSERT INTO mizNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kuenta tsí viin tsí dā née ini o ne, ñúꞌū é īo íña o ne, kūnee. ");
INSERT INTO mizNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Te kanɨɨ tsī kúñu o īó ñuꞌu ne, nté un siin ña kákunee ne, kinin un ntɨꞌɨ̄ é vāꞌá ne, vata kaa te ñuꞌu kaxiꞌí nuu kúñu ō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Dā kúvi kaꞌan Jésuú ne, kāna uun ñaꞌa ña fariseú ña é kīkáꞌxi ña nú viꞌi ña kān. Kúkɨ̄ꞌví ña, itúvi ña nú mesa kán ne, ");
INSERT INTO mizNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","dā kúduꞌva ña fariseú san dá ini ña tsí ña ni dē ntáa Jesuu vátā xkoó ini ña é ntaꞌa ña dīꞌna dá kaꞌxí ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ntá tsi Jesuú ne, kakaꞌan ña: —Ntōꞌó, ña fariseú ne, ntánakate nto ata vásu ntó ni kōꞌo nto, ntá tsi nima ntó ne, nuu tsitu nuū i é kīni kaa e ntáde nto, e ntadúꞌu nto. ");
INSERT INTO mizNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Nté kui kuān nte túntu ntú nto! ¿Vá ña íni ntu nto tsí ña é de kúꞌve ata i kān ne, dɨvi tsi ñā é idé kúꞌvē ña iní i kān dɨ? ");
INSERT INTO mizNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ntá tsi kuéꞌe nto ña ntāꞌvi é nuu nima ntó ne, dukuān né, ntuntoo ntiꞌxe kanɨɨ̄ kúñu ntō. ");
INSERT INTO mizNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ʼNtá tsi ¡ña ntaꞌví ide ntú nto, ña fariseu! Ntōꞌó ne, dōó kuenta ntáde nto ntánakii xio nto uun taꞌvi ī é ūꞌxí san iña é un ntɨꞌɨ nuū i xuku choꞌo nto é nakuéꞌe nto ntaꞌa Xuva kō vata tsī o é kākaꞌan leí san, ntá tsi ña ntáde nto kuenta táꞌan nto te viī nto é vāꞌá ni ñā; ntē ña ntákuinima ntó Xuva kō. Sáꞌā é kantio é viī ntó da ntánakuéꞌe nto ntaꞌa Xuva kō é kāduku ntée ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ʼ¡Ña ntaꞌví ide ntú nto, ña fariseu!, tsi nú viꞌī mí ntánataká nuu nto ne, dōó ntio nto é kuntōo nto nte nuu i kán ne, dōó ntio nto é kuiko ñuꞌu ñaꞌa san nto itsi mí ntaíka nto. ");
INSERT INTO mizNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ʼ¡Ña ntaꞌví ide ntú nto! tsí ntōꞌó ne, vata ntáa ñañā é ña dîtó tuvi má ñuꞌu kān ntáa nto. Dā nêní tsi ñaꞌa san, ntaído ntíta ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kidáā ne, nantíko kōó uun mastrú leí san, kakaꞌan ña ni Jésuu: —Mastru, dá kuān ó kakaꞌan ntó ni ña tsīkán ne, vata te kakaꞌan kíni nto nī ntɨ́ dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ntá tsi kakaꞌan Jésuu: —¡Ña ntaꞌví ide ntú nto dɨ, é mastrú lei nto! tsí ntánakuído nto ñaꞌa san da nte koo é ña kutíi ká ña. Ntá tsi ntōꞌó ne, nté un siin ña nchó tɨɨn ntaꞌa nto. ");
INSERT INTO mizNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ʼ¡Ña ntaꞌví ide ntú nto! tsí vatā o dé ñata ntō, ña intóo kídaā e éꞌní ña ña ntákaꞌán naa Xuva ko ne, kuan tsī ó ntáde nto dɨ e ntáde váꞌa nto ñaña ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sáꞌā é kataꞌxi kuenta é kūtuni tsí dadɨɨ tsi nima ntó ni ñata ntō, ña intóo kídaā. Dɨvi ñata ntō san éꞌní ña ña ne, dɨvi ntō ntáde váꞌa nto ñaña ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ʼTsí kakaꞌan Xúva kō, ña dóo kiꞌin inī: “Taxnūu ú ña kaꞌán naa kó ni pūstrú ko mí ntoo ña. Iō ñá ne, kaꞌní ñaꞌa san ña. Iō ñá ne, kada xení ñaꞌa san ni ñā.” Kuan ō kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dukuān é vevií ne, Xuva kō ne, ntákan ñá kuenta ñáꞌa, ña ntoo vevii, kuenta iña nɨ́ñɨ e étɨ un ntɨɨ́ ntɨ̄ɨ́ ña kaꞌán naa Xuva ko, ña é xiꞌi un tsi nté da iñɨ ntuꞌu ñúxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ēꞌní ña ña ntákaꞌán naa Xuva ko nte ntúvi diꞌna da éꞌni ña Abeé san un tsi da nte rkontûvi da éꞌni ña Zacaria. Ēꞌní ña ña má ūkún kān méꞌñū nú naa kan ni má viꞌī e dóo kuíkó san. Dukuān é kākaꞌán u tsí Xuva kō ne, ntákan ña kuenta íña ñá xiꞌí san nī ña é ntoo vevii. ");
INSERT INTO mizNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ʼ¡Ña ntaꞌví ntu nto, mastrú lei!, tsi dóo kutu niꞌi nto ntakāá xiꞌi mí ntákūtúꞌve ñaꞌa san. Ntē ña ntakɨ́ꞌvi mii nto, ntē ña da váꞌa nto é kɨ̄ꞌví ñaꞌa, ña é ntio i é kūtúꞌve i —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Dá kakāꞌan Jésuu nuu i sáꞌā ne, mastrú leí san nī ña fariseú san ne, dōó kudiin ñá ni ñā. Eni ntuꞌu ñā ntánakutsuꞌun ña ñā é ña te da díi nuu i tsixeꞌe ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ini xuꞌū ñá te neé nuū i é kūvi xnteé ixi ñá ña kuenta iña túꞌūn é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dukuān ne, ñá tē nté kaa nté kaa ñaꞌa nátaká nuu ña. Uun ito tsi ntaédin nuu taꞌan ña. Dā éni ntuꞌu Jēsuu kakaꞌan ñá ne, diꞌna tsi ña ntɨniꞌi ñā kakaꞌan ñá ni ñā: —Kuenta tsí vií nto ni uꞌxen iā ña fariseu. Tsi dɨ́vi ñā né, da rkɨ xaa ña odo ntákaꞌan ña, ñá te kanɨɨ̄ nima ñá ntákaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tsí ña túvī nee iña é koo xūꞌú iña ko é ña nátidito; ntē ña tuví ne nuu i é ntē xoxo kiní i. ");
INSERT INTO mizNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Dukuān ne, un ntɨɨ́ ntɨ̄ɨ e ntákaꞌan nto mí nēé san ne, kūtuni ñáꞌā san mí kāxiꞌí nuu ntuve ngántii san. Nēe é diin diin tsi ntákaꞌan nto dá kāntiꞌú xiꞌi ntó ne, uun ito tsi kachuꞌu ña, kaꞌan ña nté rkɨ viꞌi kan. ");
INSERT INTO mizNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ʼNtōꞌo e dóo váꞌa tiin ú ni ntō ne, kakaꞌán u ni ntō é ña ku uꞌví nto xoo é kaꞌní i kúñu kō. Tsí te kúvī ne, ña túvī nee é kuvi vií ka ñá ni kō. ");
INSERT INTO mizNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ntá tsi kakaꞌán u ni ntō xoo é dií ka uꞌvī nto. Uꞌvī ntó ña é kūvi nakiꞌi ntuvi iña nto ne, da katé nuu ña nto dôꞌvi kan. Dɨvi ñā é uꞌvi ntíꞌxe nto ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ʼ¿Ñā ntu te kadíko ña ūꞌun láā san é ūvi kúdii diúꞌun san? Ntá tsi nté uun tɨ ña kakunáa ini Xúva ko tɨ̄. ");
INSERT INTO mizNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dɨvi ntō né, un tsi nté idi dɨkɨ nto ntántéꞌvi kui kui uun. Dukuān ne, ñá ku uꞌvī nto. Tsí dɨvi ntō ne, dií dií ka nuu áꞌvi nto é vata ntáa láa, kɨtɨ é ña te da díi san. ");
INSERT INTO mizNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ʼNtá tsi kakaꞌán u ni ntō tsí un ntɨꞌɨ ntō xoo é kanakiní i ko nuu ñaꞌa san vevií ne, xuꞌu é vēxkúvi ú ñatīí ne, nakiní u ña nuu ánje Xuva kō kídaā. ");
INSERT INTO mizNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ntá tsi xoo é kākukaꞌan nuu i é kāꞌán i iñá ko nuu ñaꞌa san vevií ne, kuan kōo vií u ni ñā nuu ánje Xuva kō kídaā. ");
INSERT INTO mizNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ʼDa xōó ka é kaꞌan ntée i ko, xuꞌu é vēxkúvi ú ñatīí vevií ne, kuvi kada kaꞌnu iní Xuva ko ni ñā. Ntá tsi xoo é kaꞌan kíni i iña Espíritū Sántū ne, ñá kada kaꞌnū iní Xuva ko ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ʼTē kueꞌen niꞌi ña nto viꞌi mí nataká nuu ña Israeé ne, ō kɨꞌɨn niꞌi ña nto ntáꞌa ña kaxntēku kûꞌve sán ne, ō ntáꞌa ña tsiñu naꞌnu i ne, ñá ku kadā kuení nto nté koo nantiko koō ntó, nee é kāꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tsí tē xee úra i é kāꞌan ntó ne, Espíritū Sántū sán nañēꞌé ña nto nté koo kaꞌan nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Uun ñāꞌa, ña nuu taꞌan méꞌñū ñaꞌa sán ne, kakaꞌan ñá ni Jēsuu: —Mastru, káꞌan nto ni ēní ko, na tāꞌxi na é kāduku ntée ú iña uvá ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ntá tsi Jesuú ne, kakaꞌan ñá ni ñā: —¿Xoó ntu kakaꞌan i é kadā kûꞌvé u iña nto, é kēꞌnté dava ú iña nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kidáā ne, kakaꞌan xtúku ña ni ñāꞌa san: —Kuenta tsí vií nto tē ña kunéꞌū iní nto é īó iña taꞌan nto. Tsí ña te nee é īó iña ko é kade i é vāꞌá koo kuntoo o ñūxiví sa —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kidáā né, ntaa ña ni ñā uun nuu i: —Uun ñatīi, ña dóo kuikā né, dōo váꞌa kúvī é tātá ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kidáā né, dōo dé kuení ña, kakaꞌan ña: “¿Neé ntu vii ú ve? Tsí ña túvī ka míꞌī natsoo vaꞌá u é tātá ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dā dé kuení ña, kakaꞌan ña: “É īní u neé vii ú ve. Nakɨɨ̄n ú a viꞌi atā sán ne, dá xntītsí u uun é dií ka kaꞌnu ka. Ikan nātsuꞌun váꞌa ntɨꞌɨ u é tātá ko ni un ntɨꞌɨ̄ é īó iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kidáā ne, káꞌan miī ú ni nīmá ko: Nima míi ko, dɨvīn ne, ñá tē nté kaa iña o é ntoo váꞌa ve. Kutuvín daꞌnan ve. Kaꞌxín ne, koꞌon; na nākunuu dîní nima o.” Kuan kōo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ntá tsi Xuva ko ne, kākaꞌan ña: “¡Nté kuān nte túntun ntun! tsí niñú ve kuvin. Iña o é ntoo váꞌa ne, ¿xōo ntú iña i kuvi?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dukuan ō ntákuvi ñaꞌa, ña e ntátsoo váꞌa dokuika iña mii i, ntá tsi dóo ntaꞌvī ñá nuu Xuva ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kakaꞌan Jésuu ní ña ntɨniꞌi ñā: —Sáꞌa kāꞌán u ni ntō: Ñá ku dē kuení nto nee é kāꞌxi nto; ntē ña ku de kueni nto nee é kuꞌun kutāvi nto. ");
INSERT INTO mizNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tsí ntuvi iña kó ne, dií ka nuu áꞌvi é vāta kaa é kāꞌxi o. Dií ka nuu áꞌvi kúñu kō é vāta kaa dóo é kuꞌun ō. ");
INSERT INTO mizNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Koto nto nté o de rkáka san: Ñá katāꞌxi tɨ é tātá, ntē ña katáꞌvi tɨ, ntē ña tuvi míꞌī ntánatsoo váꞌa tɨ iña tɨ́ dɨ. Ntá tsi Xuva kō ne, kaxéꞌe ña é kāꞌxi tɨ. Ntōꞌó ne, ¿ñā ntu te dií dií ka nuu áꞌvi nto é vāta ntáa láa san? ");
INSERT INTO mizNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nté uun ñaꞌa nto ña kuvi vií nto é kuēꞌnu ka kúñu nto, nté un síin ka, kuān te dóo kadā kuení nto. ");
INSERT INTO mizNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tē ña kuvi vií nto nte un síin sāꞌá ne, ¿nté kui ntádē kuení ntu nto tuku nuu i? ");
INSERT INTO mizNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ʼKóto nto nté o ntaéꞌnu láa san, é ntē ña ntáde tsiñu ne, ntē ña ntánakuido xuꞌve. Ntá tsi kakaꞌán u ni ntō tsí rei Salamuún ne, kuān te dóo vaꞌa kueꞌen dóo ñá ne, ñá tē nté sa váꞌa ito ña é vata ntáa láa san. ");
INSERT INTO mizNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Te Xuva ko kāxéꞌe ña e dóo váꞌa ito kuꞌu é kaa má kūꞌú kān vevií ne, tevāá ne, tutun kuvi ne, ¿ñā ntu te dií ka kueꞌe kuenta víi ña nto nēe é kuꞌun nto, ntōꞌo é ña ntákuintiꞌxe nto? ");
INSERT INTO mizNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dukuan ne, ñā ku nantɨ́ꞌɨ nto iní nto é ntuku ntō é kāꞌxi nto. ");
INSERT INTO mizNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tsí ñaꞌa, ña é ña ini Xúva kō né, dōo ntaítsuꞌun ña īña é un ntɨꞌɨ nuū i sáꞌa. Ntá tsi dɨvi ntō né, īó uun Xuva ntō, ña é īní nee é ntátaan núu nto. ");
INSERT INTO mizNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ntukū nuu iní nto nēe e váꞌā é viī nto é ntio Xuva ko ne, níꞌi ntō é un ntɨꞌɨ nuū i sáꞌā. ");
INSERT INTO mizNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ʼÑá ku uꞌvī ntó, a leꞌntu míī ko. Ñá tē nté sa tɨtɨ́n nto, ntá tsi Xuva kō ne, iō ñá dodîni é tāꞌxi ña nto é vāꞌá iña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nadiko ntō é īó iña nto ne, dá kuēꞌé nto ña ntátaan núu i san. Kuan kōo kaváꞌa nto itɨ́n nto é ña kakuátā é kuntōo váꞌa iña ntó e dukún kan ntii dañu ntūvi. Tsi íkān ne, ña kakɨ́ꞌvi ña duꞌu, ntē ña kadúku tɨ́ iña ko. ");
INSERT INTO mizNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Míꞌi ntōo é nuu áꞌvi iña ntó ne, ikan kuntōo nima ntó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ʼNa kōo túꞌve nto duꞌnu nto ni ñūꞌu é nātuún nto. ");
INSERT INTO mizNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Vií nto vata tsī o dé ña ntáde tsiñu, ña ntantétu tóꞌo i, ñā é ñeꞌe mi tántaꞌa ñaꞌa. Tē náxee ñá ne, kanakeꞌxen ñā xiꞌí ne, ura tsí i nakaan. ");
INSERT INTO mizNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nté kui dîni tóꞌō ña ntáde tsiñu san e ntántíto ña te naxēé ña. Nuu é ntaā i é kākaꞌán u ni ntō tsí dɨvi tsī tóꞌo ñā ne, nákuntēé ña donúu ñā ne, da káꞌan ñā tsí na kuntōo ña ntáde tsiñu san nú mēsa ñá ne, mii toꞌo ñā tsuꞌun koꞌo ña é kāꞌxí ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nté kui váꞌa ña ntáde tsiñu san, tsí kuān te davá ñūú ne, ō e veꞌxi túvi ne, ntantíto ña tē née tóꞌo ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Na kūtuni nto sáꞌā. Tē dɨ́ ini tóꞌō viꞌi san neé ura kiꞌxi ñá duꞌú san ne, koo túꞌve ña kuntētu ña. Ñá kuēꞌé ña itsi é kɨ̄ꞌví ña duꞌú san má viꞌi ñā é kiꞌi dúꞌu ña iña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kuan dɨvi ntō dɨ́ ne, na kōo túꞌve nto, tsí dā née inī nto ntuvi dá ña ntántétu nto xee ña vexkúvi ñatīi —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedrú ne, katsixeꞌe ñā: —Tōꞌó, ¿vá kantáa ntu nto nuu i sáꞌa é da mii tsi īña mii ntɨ́ ne, ō iña un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kakaꞌan Tóꞌo kō: —¿Xoó ntu é ña ntáde tsiñu odo nūu, ña é dií ka vāꞌa, ña é dií ka kade ntaa, ña é kākaꞌan tóꞌo ī é kodo nūu ñá iña ñá ntoo nú viꞌi ñā é kuēꞌé ña é kāꞌxí ña te xee úra i? ");
INSERT INTO mizNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","¡Nté kui váꞌa ña ntáde tsiñu, ña kade ntaá san! Tē náxee tóꞌo ñā ne, é un ntɨꞌɨ kāde ntaa ñá vatā o uvé tsiñu ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nuu é ntāa ntíꞌxe i é kākaꞌán u tsi tóꞌo ña ne, xtuvī ñá ña é kuēnta víi ña é un ntɨꞌɨ̄ é īo íña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ntá tsi te ña ntáde tsiñu san kade kuení ña tsí kukuií ka dá nāxee tóꞌo ñā ne, kani ntuꞌu ña kadā xení ña ni ña ntáde tsiñu niꞌi ña, te tīí, te ñadɨ̄ꞌɨ́ ne, kani ntuꞌu ñā é kōꞌo ña, é kāꞌxí ña, é kada kɨꞌvi ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kidáā ne, da née inī tsí ña naxee tóꞌo ñā ntuvi dá ña kantétu ña, tsí ña íni ña neé ura naxée ña. Kidáā ne, nakiꞌi ña tsiñu ñā ne, natee xío ña ña é kɨ̄ꞌɨn ñá ni ñāꞌa, ña é ña ini de ntáa san. ");
INSERT INTO mizNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ʼÑa ntáde tsiñu, ña é īní nēe e ntío tóꞌo ī ntá tsi ña te īó tuꞌvé ña, ntē ña ni de ntáa ña é kākaꞌan tóꞌo ñā né, dōo nakáꞌxi vaꞌa tóꞌo ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ntá tsi ña ntáde tsiñu, ña e ñá ini nee e ntío tóꞌo ī ntá tsi idé ña nee iña e ñá ini ña ne, níꞌi ñā é ntōꞌo ña dɨ, ntá tsi ña dóo nee. Tsí xoo é dií ka kueꞌe níꞌi i ne, dií ka kueꞌe kantio é kueꞌé ña ña nguiī san. Xoo é dií ka kueꞌe ntada ña kuénta ntáꞌa i ne, dií ka kueꞌe kantio é kāda ntaa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ʼVéꞌxī u e xnteé ñuꞌu ú ñuxiví sa. ¡Dōó ntio kó tē dɨ́ kaiꞌxi vevíi! ");
INSERT INTO mizNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Īo úun nuu i e dóo ntoꞌo kó rkontûví ne, un váꞌa tsi kantɨꞌɨ iní ko un tsi da nte inú kava. ");
INSERT INTO mizNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Vá vēꞌxí ntu ú vata koo é kuntoo váꞌa ñaꞌa san ñuxiví sa, te kuinī nto? ¡Ñaꞌa ní san! tsí veꞌxí u é kii nteé xio taꞌan ñaꞌa san kuenta iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tsí un tsi nte vevií ne, kii nteé xio taꞌan ñaꞌa. Uꞌun ñáꞌa san uun tsi viꞌi ntoo ña. Uni ñáꞌa ña naa núu ña nī ña uvi ñáꞌa sán ne, ña uvi ñaꞌa sán ne, naa núu ña nī ña uni ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Uva ī ne, naa núu ña ni iꞌxā ña. Iꞌxá ña ne, naa núu ña ni uva ñā. Dɨꞌɨ ñā ne, naa núu ña nī dióko ñā. Diōkó ña ne, naa núu ña ni dɨꞌɨ ñā. Ñúntɨ̄ɨ́ ña ne, naa núu ña nī énu ñā. Ēnú ña ne, naa núu ña nī ñuntɨ́ɨ ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kakaꞌan Jésuu ní ñaꞌa san: —Tē íni nto tsí ñuꞌu vikó san xeꞌe i kán ne, ura tsi ntákaꞌan nto é kɨ̄ɨn davi. Kuan kōo kuvi ntiꞌxe. ");
INSERT INTO mizNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dá kaīnu tatsin xéꞌe ī kán ne, ntákaꞌan nto é vēꞌxí ntuvi kaꞌni. Kuan kōo kuvi ntiꞌxe. ");
INSERT INTO mizNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ntoꞌó ne, da mii tsī rkɨ xaa nto nteku é ntákaꞌan nto. Ntoꞌó e dóo íni nto é kāꞌan nto nté koo kúvi e dukún kan ni ñūxiví a ne, ¿nté kuī ña ntáñeꞌe dɨkɨ ntu nto núu i é kataꞌxi Xuva kō nté koo kuvi ntuvi é ntoo o vevii? ");
INSERT INTO mizNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ʼ¿Nté kui ña káde kúꞌven míin nee é vāꞌa iña nto? ");
INSERT INTO mizNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tē xoó ñaꞌa kɨꞌɨn níꞌi ña o ntaꞌa ña tsíñu i é tsiꞌi kuétsi i ō ne, koón ntiin nātiin váꞌan ni ña itsi kān vata koo é ña kɨ́ꞌɨn niꞌi ña o ntaꞌa ña tsíñu i san. Tsí tē ña tsiñu i san ntada ña o kuénta ntáꞌa sntadún san ne, xnuu kutu ña ō viutun. ");
INSERT INTO mizNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kakaꞌán u ni ō tsí ña ntiin viútun san un tsi da nte ntáꞌvin ntɨꞌɨn é kakan ña —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ntuvi tsikán ne, iō ñá san ne, kuéꞌen ñā mí tuví Jesuú ne, ntaa ña ni ñā tsí Pilatú san ne, ēꞌní ña ña ñatīi, ña ñuú Galileá ne, da nádaká ña nɨñɨ ña ni nɨñɨ kɨtɨ́ san é kuēꞌé ña doméni íña Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesuú ne, kakaꞌan ña: —¿Vá dií ka ntu iō kuetsí ña kuān o kúvi san é vata ntáa ña ñuú ña, te kuinī nto, é kuān o ntóꞌo ña? ");
INSERT INTO mizNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kaꞌán u tsí ñaꞌa. Ntá tsi dɨvi nto, tē ña nadáma nto nima ntó ne, un ntɨꞌɨ ntō kuví nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Un ntɨꞌɨ̄ ña xeꞌun uni ñáꞌa san xiꞌi ñá da núu viꞌi dūkun é nani Silūeé ne, ¿dií ka ntu iō kuetsí ña é vata ntáa ña é īntóo ñuú Jerusaleén, te kuinī nto? ");
INSERT INTO mizNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kaꞌán u tsí ñaꞌa. Ntá tsi dɨvi nto, tē ña nadáma nto nima ntó ne, kuví ntɨꞌɨ ntō dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kidáā ne, kantáa Jesuu núu i sáꞌā: —Uun ñatīí ne, íꞌxi ña uun utun ígu ñuꞌu ña. Kuéꞌen ña kūkoto ntódo ña te kākii kɨtɨ ígū sán ne, nté uun tɨ ña kakii tɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kidáā ne, kakaꞌan ñá nī ña kade kuenta útun san: “Koto nto tsi é uni kuíā é kakiꞌxi da tāꞌán u ne, nté uun igu sán vata níꞌi ko tɨ. Nakɨ̄ɨn nto utun tɨ vata koo é ntūnîné ñuꞌu san, tsi é ntaā i é ntitsi”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ntá tsi ña kade kuenta útun sán ne, kakaꞌan ña: “Na kūntitsi mií ka uun kuiá, nɨɨ dukuan naxtīvitá u nteꞌu nú ditsín i ne, dá tsōo ú choꞌo é kuēꞌnu váꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Te kīi kɨtɨ i kidáā ne, váꞌa ō. Tē ñaꞌá ne, dá nakɨ̄ɨn nto”, kaꞌan ña. —Kuan ō ntáa Jesuu nuu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Uun ntuvi dá iō dáꞌnā ne, kanañēꞌe Jesuu ñáꞌa san nú viꞌī mí ntánataká nuu ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ikān tuví uun ña dɨ̄ꞌɨ, e xéꞌun uni kuīa é nchokuví ña. Tsí uun é ña váꞌā san dé tɨꞌɨ ñā. Ña ni kúvi ntuntāa ña nté un síin. ");
INSERT INTO mizNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dā íni Jesuu ñá ne, kāna ña ña, kakaꞌan ñá ni ñā: —É ntuváꞌan kuiꞌi o vé —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kidáā ne, xntee táꞌan Jesuu ntáꞌa ña ñadɨ̄ꞌɨ́ san. Ura tsí i ntuváꞌa ña ne, dā éni ntuꞌu ña kākaꞌan ña tsi dóo kaꞌnu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ntá tsi tóꞌō viꞌi mí ntánataká nuu ña ne, dōo kúdiin ña tsí ntaváꞌa Jesuu ñáꞌa san ntuvi dá iō dáꞌna ne, kakaꞌan ñá ni ñāꞌa san: —Íñu ntuvi īo é kada tsiñu ō né, dɨvi tsi ntūvi é kūvi kiꞌxi nto dá kuchōꞌo nto; ñá te ntūvi dá iō dáꞌna san kiꞌxi nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kidáā ne, kakaꞌan Jésuu: —Ntōꞌó ne, da miī rkɨ xaa nto nteku e ntákaꞌan nto. ¿Ñā ntu ntánantuté nto duntɨkɨ nto ni búru nto é kɨ̄ꞌɨn tɨ kikoꞌó tɨ ntute ntuvi dá iō dáꞌna san? ");
INSERT INTO mizNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tsí ña dɨ̄ꞌɨ́ saꞌá ne, tatá viꞌi Abraan ña, ntá tsi é kūvi xeꞌun uni kuía e nteé kɨmi ña kuīꞌi sáꞌa é xēꞌé é ña váꞌā san ña. ¿Vá ñā ntu kuvi nakuitá u kuiꞌi ña ntuvi dá iō dáꞌna? —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dá kāꞌan Jésuu sáꞌā ne, un ntɨꞌɨ ñā ntaínchuꞌvi ña kúkaꞌan nuu ña é kuān ó kakaꞌan Jésuu ni ña. Ntá tsi ñaꞌa sán ne, dōó diní ña e dóo kaꞌnu nuu i é idé Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kidáā ne, kakaꞌan Jésuu: —¿Nté ō ntu mí kadē kûꞌvé Xuva kō? ¿Nee iñá ntu é kuvi ntada dadɨɨ o? ");
INSERT INTO mizNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Vata kaa kudii uun tsɨ́kɨ̄n kuli é kuetsi kuēꞌen e kaíꞌxi uun ñatīi má iña ñá kān ne, kēne un tsi da nte kúvi utun. Kukaꞌnu ne, un tsi nte láa, kɨtɨ ntaíko, de váꞌa tɨ taka tɨ́ ntaꞌa i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ntá tsi kakaꞌan Jésuú dɨ: —¿Nee iñá ntu ntada dadɨɨ ú vata kaa mí kadē kûꞌvé Xuva kō? ");
INSERT INTO mizNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tsi mí kadē kûꞌvé Xuva kō ne, vata kaa uun tɨꞌntɨ úꞌxen iā e kíꞌi uun ñadɨ̄ꞌɨ́ san ne, dā nadaka ña uꞌxen san ni uni xkúꞌve utsi trigu un tsi da nte náneñu váꞌa úꞌxen san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesuú ne, ítā ntíꞌxin ña ñuú naꞌnu ni ñūú kuetsi, kanakuāꞌa ña ñaꞌa san mí īta ntíꞌxin ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Uun ñaꞌa ñá ne, kēne ña, kakaꞌan ña: —Mastru, ¿ña tɨtɨ́n ntu ñaꞌa san, ña é kanakáku? —kaꞌan ñá, tsixeꞌe ñā. Jesuú ne, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Koó ntii nto kūkɨ́ꞌvi nto xiꞌi mí ña niꞌí san. Tsí kakaꞌán u ni ntō tsí ña te da díi ñaꞌa ncho kɨꞌví ña, ntá tsi ña níꞌi ña é kɨ̄ꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dā nákādɨ́ Tóꞌo vīꞌi san xiꞌi ñá ne, ntōꞌo é ñuꞌu mii nto kíꞌi kān né, nakeꞌxen ntō xiꞌí san, káꞌan ntō: “Nakaán nto xiꞌi nto, na kɨ̄ꞌví ntɨ”, koo kaꞌan nto. Ntá tsi dɨvi ñā ne, káꞌan ña: “Ntoꞌó ne, ntē ñá īní u mí vēꞌxí nto”, koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kidáā ne, kani ntuꞌu nto kāꞌan nto: “Ntɨꞌɨ́ ne, ēꞌxí dadɨɨ ntɨ́ ni ntō; xīꞌi dadɨɨ ntɨ́ ni ntō dɨ. Tsí nakuāꞌa nto ñaꞌa san itsi ñuú miī ntɨ”, koo kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ntá tsi nantiko kōo ñá, kaꞌan ña: “É kākaꞌán u tsi ñá īní u nto. Kii nteé xio nto ko, tsí un ntɨꞌɨ ntō ntáde nto é kīni kaa.” Kuan kōo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ikān ne, kueku nto ne, nakaꞌxí kaꞌñɨ̄ nto núꞌu nto tē íni nto Abraan ni Ísaa ni Jácoó, ni ūn ntɨɨ́ ntɨ̄ɨ́ ña kaꞌán naa Xuva ko tsí ntoo ña mí kadē kûꞌvé Xuva kō. Ntá tsi ntoꞌó ne, é ñuꞌu mii ntō kíꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Xée ñāꞌa, ñá vēꞌxí dā míꞌī ká diñɨ ñuxiví sa, kixkúntōo ña, kaꞌxí dadɨɨ ña ni Xuva kō mí kadē kúꞌvē ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kini nto tsi kidáa ne, īó ñaꞌa vevií ne, dōó naꞌnu ñaꞌa ña iꞌa ñuxiví sa, ntá tsi ña naꞌnu ñáꞌa ká ña ntaꞌa Xuva kō. Iō ñáꞌa é ña te naꞌnu ñáꞌa ña íꞌa ne, dɨvi ñā e dóo naꞌnu ñaꞌa ña ntaꞌa Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ntuvi tsikán ne, xéē ña fariseu, kakáꞌan ña ni Jēsuu: —Ntaka nto iꞌa, tsí Heródē sán ne, ncho kaꞌní ña nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ntá tsi dɨvi ñā ne, nantíko koō ñá, kakaꞌan ña: —Kueꞌēn ntó ne, kaꞌan nto ni ñukuíi tsikan tsí vevií ni ūtén ne, nakuita ká u é ña váꞌā san ne, ntaváꞌa ká u ña nchokuví san dɨ. Īdá ne, ntɨ̄ꞌɨ tsiñu ko. ");
INSERT INTO mizNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ntá tsi kantio é kɨ̄ꞌɨ́n ka ú itsi kān vevií ni ūtén ni īdá dɨ. Tsí ña kúvī é kūví ña kaꞌán naa Xuva ko tē ña te ñuú Jerusaleén kuví ña. Kuan kōo kaꞌan ntó ni nā —kaꞌan Jésuu—. ");
INSERT INTO mizNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ʼ¡Dōo uꞌvi kakúvi ko kuenta iña nto, ña ñuú Jerusaleen! ¡Tsi ntaéꞌní nto ña e ntákaꞌan túꞌun Xuva kō ne, ntáxéꞌe xuu nto ña é taxnuu Xuva ko kuēnta iña nto! ¡Ñá tē nté kaa kiꞌin itō ncho nataká nuu ú iꞌxá nto vatā ó de tsúꞌūn san é kānataká nuu tɨ iꞌxá tɨ má ntiꞌxin tɨ, ntá tsi ña ni ntío nto! ");
INSERT INTO mizNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Koto ntō tsí xtuvī mii Xuva ko viꞌi nto ve. Ntá tsi kakaꞌán u ni ntō tsi nté uun ito ká ña kīni ntó ko un tsi da nté tē xee ntúvi é kāꞌan nto: “¡Nté kui váꞌa ō é vēꞌxí ña véꞌxi kuenta iña Xuva ko!”, koo kaꞌan nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Uun ntuvi dá iō dáꞌna ne, kuéꞌen Jēsuu, kúkaꞌxí ña nú viꞌi ña odo nūu iña ñá fariseu. Ntaíto xūꞌú ña nguiī san nté koo vií Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ikān tuví nuu Jésuu úun ñatīi, ñá katsitu kuīñu. ");
INSERT INTO mizNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesuú ne, tsixeꞌe ñā mastrú leí san nī ña fariseú san, kakaꞌan ñá ni ñā: —¿Vá kūvi ntu ntaváꞌa ú ña nchokuví san ntuvi dá iō dáꞌna, ō ña kúvi ntu? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ñaꞌa sán ne, diin diin sá kantóo ña. Kidáa ne, kīꞌi Jesuu ñá nchokuví san ne, dā ntaváꞌa ña ña, dā nátaxnūu ña ña é na nūꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kakaꞌan ñá nī ña fariseú san: —¿Vá iō ntú nto te īꞌxá nto o te dūntɨkɨ nto kóꞌxo nuu tɨ ini pusu kán ne, vá ña natavá ntu nto tɨ, kuān te ntuvi dá iō dáꞌna? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ña ni kúvi nantiko kōo kueꞌen tsí ña é kākaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Dā íni Jesuu tsí ñaꞌa, ña xeé viꞌi viko sán ne, ntánakaxnúu ña míꞌī e dóo váꞌā o é kuntōo ña nú mesá san ne, kakaꞌan Jésuu ni ña núu i sáꞌa: ");
INSERT INTO mizNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Tē xoó kakana i é kɨ̄ꞌɨn ntó viko mí kātántaꞌa ñaꞌa sán ne, tē xee ntó ne, ñá kū xkutúvi ntō nte nuu i kan, tsí te kīꞌxi tuku ñaꞌa, ña é dií ka kaꞌnu ñaꞌa é dɨvi ntō ne, ");
INSERT INTO mizNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kidáā ne, xéē ña é kāna ña nto ntuvi ntó ne, káꞌan ña ni ntō: “Xio kudii kutuví nto, tsí ña sāꞌá ne, kutuvī ñá iꞌa”, koo kaꞌan ñá ni ntō. Kidáā ne, kukaꞌan nuu nto nakuntítsi nto, kikutúvi nto un tsi nte ata i kan. ");
INSERT INTO mizNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ntá tsi tē xee nto mí kākana ña nto é kīkaꞌxi nto ne, kūkutúvi nto un tsi nte ata i kan. Kidáā ne, tē xee ña e kána nto sán ne, káꞌan ñā: “Kuítā ntiꞌxin nto nte nuu i san”, koo kaꞌan ña. Kidáā ne, kuiko ñuꞌu ñā ntántoo nú mesá san nto. ");
INSERT INTO mizNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tsí xoo é kade kaꞌnu mii ī kúñu ī ne, tē kúvi ne, níꞌi ñā dokaꞌan; ntá tsi xoo é dutsi i vevií ne, rkontûví ne, dií ka kukaꞌnu ñaꞌa ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kakaꞌan xtúku ña ni ñatīí, ña e kána ña: —Dá kāde váꞌa nto é kāꞌxí ñaꞌa nú viꞌi nto kān ne, ña ku kána nto ña e dóo váꞌa tiin niꞌi ntō, nté ēní nto, nté ñaviꞌi nto, nté ñā kuika, ña ntoo etsin nú viꞌi ntō. Tsí dɨvi ñā né, kāna ña nto dɨ é kikáꞌxi nto nú viꞌi ña kān né, kuan kōo ntúdadɨɨ ña ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ntá tsi da ntáde nto viko ne, kana nto ña ntāꞌví san, nī ña e dúkuan ntāꞌví da káku, nī ña natɨ́ɨn i san, ni ña kuāá san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kidáā ne, dōo diní nto. Tsí dɨvi ñā ne, ña kúvi ntudadɨɨ ña ni ntō. Ntá tsi dɨvi ntō ne, níꞌi nto é vāꞌá iña nto ntuvi te ntóto ñaꞌa, ña é īde é vāꞌá ñuxiví sa —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dā téku ña sáꞌā ne, uun ña é tuví nu mesa kán ne, kakaꞌan ñá ni Jēsuu: —¡Nté kui váꞌa o xoo e kaeꞌxí dadɨɨ i mí kadē kûꞌvé Xuva kō! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kakaꞌan Jésuu ni ña: —Uun ñatīí ne, dōó kaꞌnu viko idé ña. Ñá tē nté kaa ñaꞌa san kána ña é kīkáꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dā xeé ura i é kāꞌxí ña ne, taxnūu ña ña kade tsiñu iña ña é kūkoto ñá ñaꞌa san: “Kueꞌēn ntó ve, tsi é iō tuꞌvé ntɨꞌɨ”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ntá tsi un ntɨɨ́ ntɨɨ̄ ñá ne, éni ntuꞌu ñā ntákaꞌan ña nté kui ña ni kuvi kɨ́ꞌɨn ña. Ña é kuvi ūun sán ne, kakaꞌan ña: “Ñuꞌu da ve ñíī ú ne, kantio é kɨ̄ꞌɨ́n u kikoto ntódo u. Vií nto da xēꞌe, kada kaꞌnú ini nto nī ko tsí ña kúvi kɨ́ꞌɨn ú ve”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tuku ñaꞌa ne, kakaꞌan ña: “Dā ve ñíī ú uꞌun náꞌa dūntɨkɨ ne, kantio é kikoto ntée ú tɨ tē vaꞌá tɨ. Vií nto da xēꞌe, kada kaꞌnú ini nto nī ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ña uun ká xtuku sán ne, kakaꞌan ña: “Xuꞌú ne, dā ve kúvi tántaꞌa ú ne, dukuān ne, ña kúvi kɨ̄ꞌɨ́n u”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dā náxee ña táxnūu ñá ne, kantaa ntɨꞌɨ ña nī tóꞌo ñā nee iña é kākaꞌan ñá mí ñeꞌe ña. Kidáā né, kūdiin tóꞌo ñā ne, kakaꞌan ñá nī ña kade tsiñu iña ña: “Kuēꞌen náneꞌen nú āꞌví kan ni itsi kaꞌnu kān, ni da kanɨɨ̄ má ñūú san, dá kuntēkan ña ntaꞌví san, kixniꞌin ña iꞌa, ni ñā dúkuan ntāꞌví da káku, ni ña kuāá san, ni ñā natɨ́ɨn sán dɨ”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Dā ku e víꞌi ne, nāxee ña táxnuu ña, kakaꞌan ñá nī tóꞌo ñā: “É de ntáa u é kākaꞌan nto, ntá tsi dóo kaniné ka”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kidáā ne, kakaꞌan tóꞌo ña ni ñā: “Kuēꞌen ítsi naꞌnu kan ne, kuēꞌén un tsi nte nu ráxa kān, káꞌan ni da xōó ka ñaꞌa, kuétsī é viīn ñá na kīꞌxi ñá vata koo é na tsītu ña ma víꞌi ko. ");
INSERT INTO mizNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tsí kakaꞌán u ni ntō tsi nté uun ñaꞌa, ña kana díꞌna ú ne, ñá nīꞌi kuéꞌen tsi ña é kāꞌxí ña”, kaꞌan tóꞌo ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ñá tē nté kaa ñaꞌa ntántīkɨn ñá Jesuu. Jesuú ne, xkokōo ñá ata ña, kakaꞌan ñá ni ñāꞌa san: ");
INSERT INTO mizNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Tē xoó ñaꞌa kiꞌxi ña é ncho kuntīkɨn ñá ko ne, ña kúvi viī ñá tē ñá dií ka kueꞌe ntío ña ko é vata kaa ntío ña uva ña ni dɨꞌɨ ñā, ni ñadɨꞌɨ̄ ñá ni īꞌxá ña, ni enī ñá ni tāꞌan ñá, nī kúñu mii ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tsí ña kúvi viī ñá tē ña ntío ña nākunáa ña kúñu ñā é kuntīkɨn ñá ko. ");
INSERT INTO mizNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Te iō ntó ne, ntio nto é xntitsī ntó viꞌi kaꞌnu ne, ¿vá ña ntu te diꞌna kutuví nto kadā kuení nto nté kaa nantɨꞌɨ nto, te xēe táꞌan ntu diuꞌun nto é kuvi kuntītsi? ");
INSERT INTO mizNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tē ñá ne, xtuvī ntó etɨ́ viꞌi sán ne, é ntaā i kutuvi dava. Un ntɨɨ́ ntɨ̄ɨ́ ña kainí ne, kani ntuꞌu ñā kaꞌan kíni ña iña nto: ");
INSERT INTO mizNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ñatīí saꞌá ne, eni ntuꞌu ña kāde váꞌa ña viꞌi ña ne, ntē ña ni kuvi vií ña nantɨ̄ꞌɨ ñá”, koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ō te uun reí san ncho víi ña duꞌxen ni tūku reí ne, ¿vá ña ntu te diꞌna kutuví ña kadā kuení ña te xēe táꞌan uꞌxi míil sntadun ña é kōó ntii ña viī ñá duꞌxen ni tūku rei, ñá īó ōko míil sntadun i? ");
INSERT INTO mizNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tē íni ña tsí ña kuvi vií ña ne, taxnūu ña túꞌūn ntaꞌa tuku reí san dá tuvi íka ká ña é kākan ña e nté koo kuntōo váꞌa ña ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Dukuān né, te xōó ñaꞌa, ña é ña xtuví mii i ūn ntɨ́ꞌɨ īña í ne, ña kúvi kuntīkɨn ñá ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kakaꞌan xtúku Jesuu nuu i sáꞌa dɨ: —Ñɨ́ɨ̄ sán ne, dōo vaꞌa. Ntá tsi tē kúnaa díko i ne, ¿nté ntu koo ntuveñɨɨ́ ka xtúku? ");
INSERT INTO mizNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ñá vādá mi kainuu áꞌvi ká i; da miī sa é nakuīta o. Xoo é kātekú i ne, na kīni i —kaꞌan Jésuu ni ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Un ntɨɨ́ ntɨ̄ɨ ña ntaído diuꞌun xôo iña ñuú Roma ni túku ñaꞌa, ña é iō kuetsí i ne, xée ētsin ña mí tuví Jesuu é kīni ña é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dukuān ne, ña fariseú san nī mastrú leí san ne, ntákaꞌan kíni ña iña Jésuu, kakáꞌan ña: —Ñatīí saꞌá ne, ntaíka dadɨɨ ña nī ña é iō kuetsí i ne, ntaéꞌxí dadɨɨ ña ni ñā dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kidáā ne, kantaa Jesuu kuénta iña i sáꞌā: ");
INSERT INTO mizNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Xoó ñaꞌa ntu nto, te īó uun sientu léꞌntu ntó, tē kunaá tɨ uun tɨ ne, ñā ntu te tsoo míi nto kɨtɨ kɨmi díko xeꞌun kɨmí san, dá kɨ̄ꞌɨn nto, kínantúku nto kɨ̄tɨ kúnaá san da nte ko é naniꞌi nto tɨ? ");
INSERT INTO mizNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tē nániꞌi ntó tɨ ne, nakuntéku dokó nto tɨ ne, dōo dîní nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tē náxee nto nú viꞌi nto kān ne, kana nto ña váꞌa tiin niꞌi nto nī ña nú viꞌi ntō ne, káꞌan ntō: “Na nākunuu dîní nima ntó nī ko, tsí e nániꞌí ko á leꞌntú ko, kɨtɨ kúnaa”, koo kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Dukuān ne, káꞌān ú ni ntō tsí dií ka iō dodîní e dukún kān te uun ñāꞌa, ñá iō kuetsí i, natɨvi iní ña kuétsi ñā, é vāta kaa ña kɨmi díko xeꞌun kɨmi ñáꞌa san, ña é vāꞌa, ña é ña tuvi kuétsi ī nuu Xuva ko —kaꞌan Jésuu—. ");
INSERT INTO mizNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ʼUun ñadɨ̄ꞌɨ́ ne, īó uꞌxi diuꞌun kuiꞌxín iña ña. Tē kúnaa úun ne, ¿vá ñā ntu natúun ña ñuꞌu ña ne, dá neꞌxīn ñá da kanɨɨ̄ má viꞌi ña kān? Kukuií kuduꞌva tsi nantuku ñā da nte ko é naniꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tē nániꞌi ñá ne, nataká nuu ntɨꞌɨ ña ni ñadɨ̄ꞌɨ, ña váꞌa tiin niꞌi ña, nī ña ntoo etsin nú viꞌi ña kān, káꞌan ñā: “Nā nakunuu díni nima ntó nī kó, tsi é nāniꞌí ko diuꞌún ko e kúnaa”, koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kakaꞌán u ni ntō tsí dukuān dîni ánje Xuva ko kuēnta iña ñá iō kuetsí i tē nátɨvi iní ña kuétsi ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kakaꞌan Jésuú san dɨ: —Uun ñatīí ne, īó uvi iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na dutsī sán ne, kakaꞌan ná ni uva nā: “Ūvá, taꞌxi nto iña nto é kāduku ntée u”, kaꞌan na. Kidáa ne, ēꞌnté dava ña é tātá ña é duku ntée na. ");
INSERT INTO mizNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ntē vata kutɨ́tɨn ntuvi ne, iꞌxá ña, na dutsī sán ne, nātsuꞌun váꞌa ntɨꞌɨ na íña ná ne, dá kuēꞌen ná tuku ñuú mí doto tsi nántɨꞌɨ lúku na diuꞌun na. Īde na un ntɨɨ́ ntɨ̄ɨ núu i é kīni kaa vata kaꞌán ini míi nā. ");
INSERT INTO mizNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ntá tsi dā ntɨ́ꞌɨ kuēꞌen diuꞌun ná ne, xée ntūvi da dóo kutama da kanɨɨ ñūu tsíkán ne, iñɨ ntúꞌū kúnaa nteē na é kāꞌxí na. ");
INSERT INTO mizNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kidáā ne, kuéꞌen nā, kuntúku na tsiñu ni uun ñatīi, ña ñuú tsikán ne, taxnūu ña ná rantsu ña é kɨ̄ꞌɨn na, kikuenta víi na kutsin ña. ");
INSERT INTO mizNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ntīo na é kāꞌxí na é kaeꞌxí kutsín san da nte ko é ntaꞌa na ne, ntá tsi xoxo ni xéꞌe ī é kāꞌxí na. ");
INSERT INTO mizNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kidáā né, dē kuení mii na, kākaꞌan na: “¡Nté ntu kaa dií ña ntáde tsiñu iō ñá nú viꞌi uvā kó kān é iō é ntaéꞌxí ña ne, ntē dúkuan kāntóo ka. Xuꞌú ne, kaxiꞌí u dóko iꞌa! ");
INSERT INTO mizNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Á te nūꞌú u mí tuví uvā kó kān ne, káꞌān ú ni ñā: Ūva, é ntuku kuētsí u ni Xuva ko, ni dɨvi ntō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ña nuu áꞌvi ká u é kāꞌán ka nto é iꞌxā ntó ko. Viꞌi a vé ne, vií nto nī kó vatā ó de nto nī ña ntáde tsiñu iña nto. Kuan kōo káꞌān ú ni ñā”, kaꞌan na. ");
INSERT INTO mizNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kidáā ne, nákunūu itsi na, kunúꞌu na mí tuví uva nā. ʼIkā ká veꞌxí na, íni uva na nā né, ntuntāꞌví ini ña na. Koó da kaxkainu uva nā kúnakuētú itsi ña na ne, nánume ña na, da éꞌxi ña xuꞌu na. ");
INSERT INTO mizNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kidáā ne, kakaꞌan ná ni uva nā: “Ūva, é kōꞌxo nteé u nuu Xuva ko, ni dɨvi ntō dɨ. Ñá tē nee nuu áꞌvi ká ko é kāꞌán nto é īꞌxá nto ko”, kaꞌan na. ");
INSERT INTO mizNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ntá tsi uva nā ne, kakaꞌan ñá ni ña ntáde tsiñu iña ña: “Nantukū náneꞌe nto duꞌnu é dií ka vaꞌa dá nākunúu iꞌxá ko. Naxnūu nto diꞌi ntáꞌa i dɨ. Na nākɨꞌɨ́ ntiꞌxen váꞌā sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kūkueká nto duntɨkɨ, kɨtɨ dií ka deꞌén ne, dá kaꞌnī ntó tɨ dá kāꞌxi o tɨ é vīi o vikó san. ");
INSERT INTO mizNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tsí iꞌxá ko sá ne, e xíꞌi, kuíni ko, ntá tsi e ntóto xtuku. É kūnaá iꞌxá ko, kuíni ko, ntá tsi é naniꞌí ko i ve”, kaꞌan ña. Kidáa ne, eni ntuꞌu ñā idé ña viko san. ");
INSERT INTO mizNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ʼNtá tsi iꞌxá ña, na kuvi atā sán ne, nuu na má tsīñu na. Dā náxee étsin na nú viꞌi na kān né, tēkú na e dóo kaeku strumentú ne, ntaíteꞌe ñaꞌa sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kidáā né, kāna na uun ña kade tsiñu sán ne, tsixeꞌe nā: “¿Neé ntu kakuvi iꞌa?”, kaꞌan na. ");
INSERT INTO mizNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ña kade tsiñu sán ne, kakaꞌan ñá ni nā: “É nāxee ení o. Uva ō ne, táxnūu ña é kūví uun duntɨkɨ, kɨtɨ dóo deꞌén san, tsi váꞌa tsi ō náxee na”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kidáa ne, kūdiín ení na, na kuvi atā sán ne, ntē ña ni ntio na ntɨ́ꞌvi na má viꞌi na kān. ");
INSERT INTO mizNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kakaꞌan ná ni uva nā: “Dɨvi ntō ne, ini nto tsi éma tsi kaxntiī ú nto, é ntē ña kadé doꞌō ú ni ntō nté uun ito ne. Ntá tsi ntē ña kataꞌxí nto nté uun kudii a ndiꞌú san é vīí u viko ko nī na váꞌa tiin niꞌī u. ");
INSERT INTO mizNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ntá tsi vevií ne, nāxee iꞌxá nto na sāꞌá, na é dotō tsí nantɨꞌɨ́ diuꞌun nto ni ñadɨ̄ꞌɨ́ kinī ntáa sán ne, kaeꞌní ka nto duntɨkɨ, kɨtɨ dóo deꞌén san”, kaꞌan ení na, na kuvi atā san. ");
INSERT INTO mizNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Kidáā ne, kakaꞌan úva na ni nā: “Iꞌxá miī kó, xoꞌōn né, nɨɨ̄ kueꞌen tsí ntuvi tuvín nī kó. Un ntɨꞌɨ̄ é īó iñá ko ne, íña ō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ntá tsi vevií ne, e váꞌa ō é vīi o víko, tsi é nakūnuu dîní nimá ko, tsí na ení o ne, e xíꞌi na, kuíni ko, ntá tsi kantíto na. É kūnáa na, kuíni ko, ntá tsi é naniꞌí ko ná ve”, kaꞌan úva na ni nā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesuú ne, kantaa ña ni ña ntɨniꞌi ñā nuu i sáꞌa dɨ: —Uun ñatīí kuika ne, xío uun ñāꞌa, ña intée ntaꞌa i tsīñu ña. Ntákaꞌan ñáꞌa san tsí ña sāꞌá ne, dotō tsí kanantɨꞌɨ ña diuꞌun tóꞌo ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kidáa ne, kāna tóꞌo ña ñā, kakaꞌan ñá ni ñā: “¿Neé ntu nuu i sáꞌa é kākaꞌan ñáꞌa san íña o? Ntadan kó kuenta tsíñu o ve, tsí ña kunteé ntaꞌa ká o tsiñu ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kidáā ne, dóo dé kueni ña nteé ntaꞌa i tsiñu san: “¿Nté ntu koo vií u ve? Tsi tóꞌō kó ne, nakiꞌi ña tsiñu ko. Ña túvi ntiī ko é kīkutú u ne, kakukaꞌan nuú ko é kākán u doméní dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","É īní u nté koo vií u ve, vata koo é nakiꞌi ñaꞌa sán ko nú viꞌi ña kān dá ña tuví ka tsiñu ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kidáā né, kāna ña ña kui uun kui uun ña, ña é tanūu diuꞌun tóꞌo ñā. Tsixeꞌe ñā ña xee díꞌna san: “¿Ntē ntú kaa tanūu nto iña tóꞌō ko?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nantíko koō ñá, kakaꞌan ña: “Tanūu ú uun sientu varii ásete”, kaꞌan ña. Kidáā ne, kakaꞌán ña nteé ntaꞌa i tsiñu san: “Ūꞌun kuenta o. Kantɨ́ꞌɨ sá kutūvin, dá xntēén naꞌan uvi díko uꞌxi várii tsi”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kidáā né, tsixeꞌē xtuku ñá tukú ñaꞌa san: “¿Ntē ntú kaa tanūu nto?”, kaꞌan ña. Dɨvi ñā ne, kakaꞌan ña: “Uun sientu etún trigu”, kaꞌan ña. Kidáā ne, kakaꞌan ña: “Ūꞌun kuenta o. Kɨmi díko tsi xnteén naꞌan ve”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tōꞌó ña ne, īní ña tsi ña nteé ntaꞌa i tsiñu, ña e dóo kīni kaa sán ne, dōo ntíto ña nté koo vií ña. Tsí ña ntáduku ntée ñuxiví sa ne, dií ka ntíto ntáde ña ni tāꞌan ña é vāta kaa ñaꞌa, ña ntáduku ntée Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ʼXuꞌú ne, kakaꞌán u ni ntō é na kada tsiñu niꞌi ntō diuꞌun nto é īo ñuxiví sa vata koo é na nīꞌi nto ñaꞌa, ña váꞌa tiin niꞌi ntō, vata koo é, tē ntɨ́ꞌɨ diuꞌun ntó ne, koo xoo é nākuído i nto mí kuntōo nto ntii dañu ntūvi. ");
INSERT INTO mizNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ʼUun ñaꞌa, ña é kade ntaa núu i é dutsī né, kuan kōo kada ntaa ña nuu i e dóo kaꞌnu dɨ. Ñaꞌa, ña é ña kada ntáa nuu i é dutsí ne, ntē ña kada ntáa ña nuu i é kaꞌnu dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ntá tsi tē ñá ini de ntáa nto nī diuꞌun é iō ñuxiví sa ne, ¿xoó ntu é ntāda i kuenta ntáꞌa nto nuu i é vāꞌa ntíꞌxe? ");
INSERT INTO mizNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tē ñá ini de ntáa nto nī nuu i iña túku ñáꞌa ne, ¿xoó ntu taꞌxi i é kūvi iña mii nto? ");
INSERT INTO mizNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ʼNté uun ñaꞌa, ña kade tsiñu ne, ña kúvī é koo uvi tóꞌo ñā é uun ito tsi. Tsí kada xení ña nī ña uun ñaꞌa sán ne, ña uun ñaꞌa ká san ne, kuinima ñá ña. O ña uun ñaꞌa sán ne, kuiníꞌi ña ña ne, ña é uun ká san ne, ñá viī ñá ña kuenta. Ña kúvi vīi o tsíñu Xuva ko tē dóo kakuinima kó diuꞌún san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ña fariseú san ne, dōó kuinima ñá diuꞌun. Dukuān né, eni ntuꞌu ñā ntákaꞌan kíni ña iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ntá tsi kakaꞌan Jésuu ni ña: —Dɨvi ntō ne, ntáde nto e dóo vaꞌá nto nuu ñaꞌá san, ntá tsi Xuva kō ne, ini ña nte ntáa nima nto. Tsí nuu i e ntáde kaꞌnu ñaꞌa sán ne, ñá ntīo kueꞌen tsí Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ʼLei é xntēé naꞌa Muísee ni túꞌūn é kaꞌan ñá kaꞌán naa Xuva ko ne, idiáꞌvi un tsi nte ntúvī da íka Juaan. Ntá tsi nte ntúvi tsikán ne, e ntákaꞌan ntódo ñaꞌa san túꞌūn vaꞌá san iña i mí kadē kûꞌvé Xuva kō ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntáxio ntii ñā é kɨ̄ꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ʼNtá tsi dií ka ña ntii tuꞌun é ntɨꞌɨ̄ e dukún kan nī ñuxiví a é nadāma uun kudii letra íña leí san. ");
INSERT INTO mizNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ʼTe uun ñatīí kanaxtuvī mii ña ñadɨꞌɨ́ ña ne, tē tántaꞌa ña ni tuku ñadɨ̄ꞌɨ́ san ne, kade ña é koꞌxo nteē ña nuu Xuva ko. Xoo é kātántaꞌa i ni tuku ñadɨ̄ꞌɨ́, ña e náxtimii xɨ̄ɨ í ne, kade ña é kākóꞌxo nteē ña nuu Xuva kó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ʼUun ñatīí kuika ne, dōo vaꞌá duꞌnu ña. Da mii kuēꞌen tsí viko kade ña utén utén; dōó kaꞌnu kade ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ikān tuví uun ñatīi, ña e dóo ntāꞌví, ña é nanī Lázaru. Dōó kateꞌu kúñu ñā. Tuví nteē ñá etɨ́ xiꞌi ñá kuiká san. ");
INSERT INTO mizNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Vevií tsi kāꞌxí ña é kakóꞌxo má mēsa ñá kuiká san. Un tsi nte tínā sán ne, kaxée ētsin tɨ é ncho nauvi tɨ mí katēꞌú san. ");
INSERT INTO mizNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Uun ntuvi ne, xíꞌī á ña ntāꞌví san. Kueꞌen níꞌi ánjē san ña é kutuvī ñá ni Ābraan, mí ntoo ña xiꞌi, ña e ntántīkɨn Xúva kō, mi dóo váꞌā o. Xíꞌi ñā kuiká san dɨ́ ne, kántūꞌxí ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ʼDā dóo kantoꞌo ña kuiká san dôꞌvi kán ne, ntāniꞌi ña nuu ñá, īní ña Abraán san e dóo ikā ntáñɨ ña nī Lázaru san. ");
INSERT INTO mizNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kidáa ne, kāna ña kuiká san ña, kakaꞌan ña: “Uvatā kó Abraan, na ntuntāꞌví ini nto ko. Taxnūu nto Lázaru san vata koo é na natsiī ña rkɨntaꞌa ña ntuté san ne, dá kīꞌxi kudii ña nantikó ña xaa ko, tsí ña te nté kaa kantoꞌo ko íꞌa mí kaīꞌxí san”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ntá tsi kakaꞌan Ábraán san ni ñā: “Iꞌxá ko, na nakaꞌān o tsí dɨvīn né, dōo váꞌā o kueꞌén o ntúvi diꞌna. Ntá tsi Lázaru sán ne, dōo ntóꞌo ña diꞌna. Vevií ne, e níꞌi ñā é vāꞌá iꞌa ne, dɨvīn ne, kantóꞌo o. ");
INSERT INTO mizNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Uun ká tuku nuu í dɨ: Īó uun xɨꞌntɨ kunu méꞌñū ntɨ́ ni ntō. Dukuān né, tē xoó ñaꞌa ntoo ña iꞌa é ncho kɨꞌɨn ña íkān ne, ña kúvi kɨ̄ꞌɨn ña. Nté ña ntoo ikān ne, ña kúvi kīꞌxi ña iꞌa dɨ”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ʼKidáā ne, kakaꞌan á ña kuiká san: “Vií nto da xeꞌe, úvā kó Abraan, taxnūu nto Lázaru san nú viꞌi uvā kó kān ");
INSERT INTO mizNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","vata koo é na kāꞌan ñá ni ēní ko, ña uꞌun ñaꞌa ká san, vata koo é ña ku kiꞌxi ña iꞌa mi dóo kantoꞌo ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ntá tsi kakaꞌan Ábraan: “Dɨvi ñā ne, ntoo niꞌi ña túꞌūn e xntée naꞌa Muísee ni ña kaꞌán naa Xuva ko san é nakuāꞌa ña. Na viī ñá kuenta sáꞌā”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kidáā ne, nantíko kōo ñá kuiká san, kakaꞌan ña: “Kuvi ní, uvā kó Abraan, ntá tsi tē dɨ́ ntoto uun ñaꞌa ña xiꞌí san ne, dā kíkoto ñá ña ne, á te natɨ̄vi iní ña kuétsi ñā”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ntá tsi Abraán san ne, kakaꞌan ña: “Tē ña ntáde ña kuenta túꞌūn é kākaꞌan Muísee ni ña kaꞌán naa Xuva ko ne, nté dukuān ña kuintíꞌxe ña, kuān te ntoto ña xiꞌí san”, kaꞌan Ábraán san —kaꞌan Jésuú san ni ñāꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kakaꞌan Jésuu ni ña ntɨníꞌi ñā: —Nɨɨ kuēꞌen tsí ntuvi īó nuu i é ntava nuu ō é kīni kaa san. Ntá tsi te xōo ñáꞌa kaxéꞌe ña itsi é vīí taꞌan ña é kīni kaa sán ne, ¡ntāꞌvi ide ña! ");
INSERT INTO mizNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tē xoó ñaꞌa kade ña é ntava nuu uun á iꞌxá san nuu i é kīni kaa sán ne, dií ka váꞌā ó tē dɨ́ ni nakuīta núu ña ña nú ntute ñuꞌu kān, kunūꞌní nuu dukun ña xuu xódó san. ");
INSERT INTO mizNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kuenta tsí vií nto. ʼTe nēe nuu i káde taꞌan nto ne, kada tíi nto ni ñā vata koo é ña kuan koo víi ña. Te nātɨvi iní ña ne, kada kaꞌnu iní nto ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Te kadē xení ña ni ntō né, kuān té uꞌxe íto é uun ntuvi ne, te ntiko koō ñá uꞌxe íto é kāꞌan ñá ni ntō tsí ña váꞌa o dé ña ni ntō ne, kada kaꞌnu iní nto ni ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ña ntɨniꞌi ñā sán ne, ntákaꞌan ñá nī Tóꞌo kō: —Tāꞌxi ká nto e dií dií ka kuintiꞌxe ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kidáā ne, kakaꞌan Xúva kō: —Tē dɨ́ kuintiꞌxe nto ne, kuān té un síin vata kaa uun a tsɨ́kɨn kulí sa ne, kuvi kaꞌan ntó ni utun sāꞌa: “Nenen iꞌa ne, da nākuntúꞌxin xion má ntute ñuꞌu kān”, koo kaꞌan nto. Utun sán ne, kuintiꞌxe i é kākaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ʼTe iō nto é īó ña kade tsiñu iña nto, ña é kaixkutu ñúꞌu nto ō kade ña kuenta kɨ́tɨ nto ne, tē náxee ña nú viꞌi nto kān ne, ¿vá kākaꞌan ntú nto: “Kuítā ntíꞌxin, kutūvin nú mesá san”? ");
INSERT INTO mizNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ñáꞌā, tsí kakaꞌan nto: “Kadan vaꞌān é kāꞌxi u kuenta kuáa ne, kuntēen donúu o, tsuꞌun kóꞌōn é kāꞌxi u. Tē kúvi éꞌxi ú, kúvi xíꞌi ú ne, dá kidáa kutūvín, kaꞌxín dɨ”, xkoó kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Vá kānakuéꞌe ntu nto sintiáꞌvi ntāꞌa ña kade tsiñu iña nto é kāde ntaa ñá tsiñu e teé tsiñu nto ña? ");
INSERT INTO mizNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Dukuān né, te dɨvi ntō dé ntaa ntɨ́ꞌɨ nto é ntio Xuva ko ne, kantio é kāꞌán ka nto: “Ntɨꞌɨ́ ne, ñá tē ña kade tsiñu é kaidiáꞌvi ntɨ, tsí kūdii idé ntɨ nuu i é kākaꞌan nto”, koo kaꞌan nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dā kueꞌen Jésuu ñuú Jerusaleén ne, ítā ntíꞌxin ña ñuú Samaria ni Gálilea. ");
INSERT INTO mizNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dā xee ñá uun ñuu lúꞌnti ne, véꞌxi ūꞌxi ñáꞌa ña ntánchokuvi e ntánakoꞌxo kúñu ñā, ntá tsi kantáñɨ ikā ñá ne, ");
INSERT INTO mizNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","un tsi ntákachuꞌu ña, ntákaꞌan ña: —¡Jesuu, Mastrú, na ntuntāꞌví ini kudii ntó ntɨ! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Dā íni Jesuu ñá ne, kakaꞌan ña: —Kueꞌēn ntó, kūnañéꞌe nto kúñu nto dūtú san —kaꞌan ña. Da nɨɨ tsi kuēꞌen ñá ne, ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kidáā ne, uun ña ne, īní ña é ntuváꞌa ña. Ntiko koō ñá ne, nɨɨ̄ kuéꞌen ini ña kakaꞌan ña e dóo kaꞌnu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nákunchɨtɨ ntāa ña nuu Jésuu. Un tsi nte ñúꞌu kān nakuntéɨ ña é nakuéꞌe ña sintiáꞌvi ntaꞌa ña. Ñatīí saꞌá ne, ña ñuú Samaria ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kidáā ne, kakaꞌan Jésuu: —¿Ñā ntu te un ntɨ́ꞌɨ nto é uꞌxi ñáꞌa nto e ntuváꞌa nto kuiꞌi nto? ¿Míꞌi ntu kuēꞌen ña ɨɨn ñáꞌa ká san? ");
INSERT INTO mizNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Da mii xntu ñā véꞌxi tuku ñuú san e ntíko koō ña é kākaꞌan ña e dóo kaꞌnu Xuva kō? —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kidáā ne, kakaꞌan Jésuu ni ñátīí san: —Nakuntítsin, dā kunúꞌun nú viꞌi o kan vē, tsi é ntūváꞌan, tsi kuíntiꞌxe ō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ña fariseú san ne, ntátsixeꞌe ñā amá kixkadā kûꞌvé Xuva kō. Nantíko kōó Jesuu, kakáꞌan ña: —Ñā dîtó te kini o núu ko mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ña kúvi kāꞌan o te iꞌa túvi, o te ikān tuvi, tsi é ñūꞌu taꞌán o ī —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kidáā ne, kakaꞌan ñá ni ña ntɨniꞌi ñā: —Xée ntūvi é ntio nto kini nto kuān te uun ntúvi tsi vata kaa ntuvi dá tuví u, xuꞌu é vēxkúvi ú ñatīí ne, ntá tsi ña kiní ka ntó ko. ");
INSERT INTO mizNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iō ñáꞌa sán ne, káꞌan ñā: “Iꞌa tuví ña”, o “Ikān tuví ña”, koo kaꞌan ña; ntá tsi ña ku kuintíꞌxe nto ña; ñá ku ñeꞌē nto é kuntīkɨn ntó ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tsí xuꞌu é vēxkúvi ú ñatīí ne, tē xee ntúvi é nainú u ne, xiꞌí nuu da kanɨɨ dūꞌva e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ntá tsi diꞌna ne, dōó ntoꞌo nto ne, kadā xení ñaꞌa san ni nto, ña ntántoo ntuvi tsikan. ");
INSERT INTO mizNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Vata ō kúvi ntuvi da íka Noeé san ne, kuan kōo kuvi dɨ́ ntuvi dá nainú u ñūxiví a. ");
INSERT INTO mizNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ntáxiꞌi ntaéꞌxi ñaꞌa san, ntánatántaꞌa taꞌan ña dɨ, un tsi da nte ntúvī é kūkɨ́ꞌvi Noeé san arká san. Dā née inī ñá da nakuntéku ntute sán ne, xíꞌi ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kuan tsi ō kúvi ntuvi da íka Loó san dɨ. Ñaꞌa sán ne, ntáxiꞌi ntaéꞌxi ña, ntáñii ña dɨ́ ne, ntádiko ñā dɨ. Ntátaꞌxi ña tatá ne, ntáxntañɨ̄ ñá viꞌi dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ntá tsi dɨvi tsi ntūvi da ntáka Loó san ñuú Sodoma ne, kóꞌxo ñūꞌu dúꞌxē nte e dukún kan, ni xūu é kaiꞌxi vatā ó kakɨɨn daví san ne, uun ito tsi ntɨ́ꞌɨ ñaꞌa sán xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kuan kōo kuvi dɨ́ tē xee ntúvi é kuēꞌé Xuva ko kūtuni ñáꞌa san xoo ñáꞌa ntiꞌxe u. ");
INSERT INTO mizNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ʼNtuvi tsikán ne, tē xoó ñaꞌa odo vídin ña rkɨ viꞌi ña kán ne, ñá ku ntɨ̄ꞌví ña iní viꞌi ña kān é kɨ̄nakiꞌí ña iña ña. Ña ñuꞌu má kūꞌu kán ne, ntē ña ku naxée ña nú viꞌi ña kān dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nakaꞌan nto ñadɨ̄ꞌɨ́ Loo nté ō kúvi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Xoó ñaꞌa é ntio ña é nakakū ñá ntuvi iña ñá ne, nakunaá ña. Ntá tsi xoo ñáꞌa é kanakunaá ña ntuvi iña ña kuenta iñá ko ne, nakáku ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ʼSáꞌa kakāꞌán u ni ntō tsí niñu tsikan ne, ntoo uvi ñáꞌa san, é uun tsi nu ito ntákidi dádɨɨ ña. Uun ña ne, nakiꞌi Xuva ko ñā ne, uun ña ne, kutuvī mii ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Uvi ñáꞌa ñadɨ̄ꞌɨ ntántiko ña. Uun ña ne, nakiꞌi Xuva ko ñā; uun ña ne, kutuvī mii ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Uvi ñáꞌa ñatīí ñuꞌu ña má kūꞌu kán ne, uun ñaꞌa ñā né, nakiꞌi Xuva ko ñā; uun ñaꞌa ñā né, kutuvī mii ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kidáā ne, ntátsixeꞌe ña Jēsuu: —¿Míꞌi ntū é kuān koo kuvi sáꞌā? —kaꞌan ña. Nántiko kōó Jesuu, kakáꞌan ña: —Mí ntōo kúñu tēꞌú san ne, ikān ntaíko nūu skuilú san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesuú ne, kantaa ña uun nuu i é nañéꞌe ña é kāꞌan ntâꞌví ō é nɨɨ kuēꞌen tsí ntuvi é ntē ña natɨvi iní kō. ");
INSERT INTO mizNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kakaꞌan ña: —Xío uun ña kaxntēkú kûꞌvé san uun ñuu é ntē ña kaúꞌvī ñá Xuva kō né, ntē ña kaíko ñuꞌu ña ñāꞌa sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dɨvi tsi ñūú tsikán ne, tuví uun ñadɨ̄ꞌɨ kii é īó duꞌxen īña ña. Kuéꞌen ña ntaꞌa ña kaxntēkú kûꞌvé san, kukakan ña kuétsi kuēnta iña ñá kanaa núu niꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Dā dóo kútɨtɨ́n ntuvi ne, ña ni íde ña kaxntēkú kûꞌvé san ñá kuenta. Ntá tsi da rkontûví ne, dē kuení ña: “Ña kaûꞌví ko Xuva ko, ntē ña kaíko ñūꞌú u ñaꞌa sán dɨ, ");
INSERT INTO mizNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ntá tsi ñadɨ̄ꞌɨ kií, ña sāꞌá ne, dōó kanatekū duꞌxen ñá ko. Nadaꞌān ú ña vata koo é ña kiꞌxí ka ña é natekū duꞌxén ka ñá ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ʼSáꞌā é kākaꞌan ñá kaxntēkú kûꞌve, ña dóo kini kaa san. ");
INSERT INTO mizNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xuva kō ni, ¿vá ñā ntu te nadáꞌan ña xoo é nakaxnúu ña é kūvi iña ña, ña é kaikan ntáꞌa ña ntē ntúvi ntē níñu? ¿Vá viī ntú Xuva kō é kuntētu ña? ");
INSERT INTO mizNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Káꞌān u tsí nadaꞌan ña ñā é nte ña kukuíi. Ntá tsi te vēꞌxi u, xuꞌu é vēxkúvī ú ñatīí ne, ¿vá nāniꞌí ka ntú ko ñaꞌa, ña e ntákuintiꞌxe i ñuxiví a? —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kantaa Jesuu úun ká xtuku nuu i iña ñá e dóo vaꞌá, kuiní mii ī, ña ntánantii niꞌni tuku ñāꞌa. Kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Uvi ñáꞌa ñatīí ne, kuéꞌen ñā má ūkún kan, kūkaꞌan ntâꞌví ña. Uun ña ne, ña fariseu. Ña uun ñaꞌa ká san ne, ña kaido diuꞌun xôo íña ñuú Roma. ");
INSERT INTO mizNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ña fariseú san ne, ntitsí ña ne, duꞌvā ó kakaꞌan ntâꞌví ña: “Xuvā kó, kanataꞌxi ú sintiáꞌvi ntaꞌa nto tsí xuꞌú ne, ñá te vāta ntáa ña nguiī san kaa u: é dūꞌú ña, kini ntáa ña ne, iō kuetsí ña dɨ; ntē ña te váta kaa ña kaido diuꞌun xôó san kaa ú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Xuꞌú ne, úvi īto é uun vite kaitúvi ixú u. Kuéꞌe kanatāꞌxi ú ntaꞌa nto vata kaa é kāniꞌí ko”, kaꞌan ñá fariseú san. ");
INSERT INTO mizNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ntá tsi ña kaido diuꞌun xôó san ne, dōo íka kātuví ña; ntē ña ni ntaa níꞌi ña dɨ̄kɨ ña ni nuu ña e dukún kān. Da mii tsī e kaxéꞌe ña ntaꞌa ña nima ñá, kakaꞌan ña: “¡Xuva ko, na ntūntaꞌví ini nto ko, tsí xuꞌú ne, dōó iō kuetsí ko!”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kakaꞌán u ni ntō tsí ña kaido diuꞌun xôó san ne, é dé kaꞌnu iní Xuva ko ni ñā kuetsí ña, kúnūꞌú ña viꞌi ña. Ntá tsi ña fariseú san ne, ñáꞌā. Tsí ña é kade kaꞌnu miī kúñu ī né, dōo kakóꞌxo nteē ñá ntaꞌa Xuva kō. Á ña ntāꞌví san ne, dɨvi ñā e dóo kaꞌnu ñaꞌa ña ntaꞌa Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kueꞌen níꞌi ñāꞌa san iꞌxá ña mí tuví Jesuu váta ko é na tɨɨn ntaꞌa ña ī. Ntá tsi dā íni ña ntɨniꞌi ñā né, eni ntuꞌu ñā de tíi ña ni ña vexníꞌi iꞌxá i. ");
INSERT INTO mizNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kidáa ne, kāna Jesuú ña, kakaꞌan ñá ni ñā: —Kuéꞌe nto ītsi é na kiꞌxi mii īꞌxá san ntaꞌa ko. Ñá ku kādɨ́ nuu nto, tsi mí kadē kûꞌvé Xuva kō ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa ne, vata ntáa iꞌxá san ntáa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nuu é ntaā i é kākaꞌán u ni ntō: Xoó ncho kɨ́ꞌvi i mí kadē kûꞌvé Xuva ko ne, da miī é kuintiꞌxe ña Xuva ko vatā ó kakuintiꞌxe iꞌxá san. Tē ñaꞌá ne, ña kúvi kɨ̄ꞌví ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Uun ñatīí, ña odo nūú ne, katsixeꞌe ña Jēsuu: —Mastru vaꞌá, ¿neé ntu vii ú vata koo é nīꞌí ko ntuvi vāꞌa iñá ko ntii dañu ntūvi? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nantíko kōó Jesuu, kakáꞌan ña: —¿Nté kui kakaꞌan ntun é vāꞌá u? Tsí xoxo e váꞌa i; mii tsi Xuva kō e dóo vaꞌá ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Inin nté o kakaꞌan túꞌūn e xtúvi Xúva kō: “Ñá ku kukīdi niꞌi nto ñadɨꞌɨ, ña é ña te ñádɨ̄ꞌɨ míi ō. Ñá ku ēꞌnín ñaꞌa. Ñá ku dūꞌun. Ñá ku kāꞌán dovete iña ñaꞌa. Kuikon ñuꞌun uva ō, ni dɨꞌɨ ō dɨ”, kaꞌan —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kakaꞌan ñátīí san: —É un ntɨꞌɨ sāꞌá ne, é dē ntaa ntɨ́ꞌɨ ú un tsi nte dá ku lúꞌnti u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Dā téku Jesuu sáꞌā ne, nantíko koō ñá, kakaꞌan ña: —Uun sá nuu i é kākunaá iña o: nadikon ntɨ̄ꞌɨn neé īo iña ó ne, dá tsiꞌin ntaꞌa ña ntāꞌví san, tsí kuan kōo é koo dokuika iña o e dukún kān. Kidáā ne, kiꞌxin, dá kuntīkɨ́n ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ntá tsi dā téku ñatīí san sáꞌā né, dōo kúntaꞌxa iní ña, tsi dóo kuika ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Īní Jesuu tsí dóo kúntaꞌxa iní ña ne, kakaꞌan ña: —¡Nté kui dóo ntii tūꞌun é kɨ̄ꞌví ña kuiká san mí kadē kûꞌvé Xuva kō! ");
INSERT INTO mizNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Dií ka ña ntii tuꞌun é kɨ̄ꞌví uun kameú san xavi xɨ́kɨ san é vāta kaa ña kuiká san é kɨ̄ꞌví ña mí kadē kûꞌvé Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ña téku i sán ne, ntákaꞌan ña: —¿Xoó ntu é kūvi nakáku i kuan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nantíko kōó Jesuu, kakáꞌan ña: —Nee iña é ña kuvi vií ñaꞌa sán ne, Xuva kō ne, kuvi vií ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedrú ne, kakaꞌan ña: —Ntɨꞌɨ́ ne, é tsoo mii ntɨ̄ꞌɨ ntɨ́ iñá ntɨ e ntántīkɨ́n ntɨ nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesuú ne, kakaꞌan ña: —Nuu é ntaā i é kākaꞌán u: Da xōó ka ñaꞌa é xtuvī mii ña viꞌi ña, o dɨꞌɨ ña, o ēní ña, o uva ñā, ō iꞌxá ña kuenta iña i mí kadē kûꞌvé Xuva kō ne, ");
INSERT INTO mizNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dií ka kueꞌé ka niꞌi ña ñuxiví a; rkontûví ne, níꞌi ña é vāꞌá ntaꞌa Xuva ko ntii dañu ntūvi —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kāna xio Jesuú san uxuvi ñáꞌa ña ntɨniꞌi ñā ne, dá kakāꞌan ñá ni ñā: —Vevií ne, kɨ́ꞌɨn o ñūú Jerusaleen, mí kuntaa é un ntɨꞌɨ̄ é uve naꞌa e ntákaꞌan ñá kaꞌán naa Xuva ko san kuenta iñá ko, xuꞌu é vēxkúvi ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tsí ntada ña kó kuenta ntáꞌa ña véꞌxi tūku ñuú san é kadā xení ña nī ko, é viī ña é kini kaa nī ko, é tɨꞌvi dɨɨ́ ña kó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kani ña kó ñɨɨ é kanuꞌni nuu utun ne, dá kaꞌnī ñá ko dɨ, ntá tsi te kúvi uni ntúvi ne, ntoto xtuku u —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ntá tsi ña ntɨniꞌi ñā ne, ñá ni ñēꞌe dɨkɨ ña; ntē ñá ini ña nee iña é kākaꞌan Jésuu, tsí nuu i sáꞌa ne, dōó xūꞌú ō kakaꞌan ña; ntē ña ni kuvi kɨ́ꞌɨn dɨkɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kuéꞌen Jēsuú ne, dā xee étsin ña ñuú Jericoó ne, ikān tuví uun ña kuāá itsi kān, kaikan ñá doméni. ");
INSERT INTO mizNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Da téku ña é ña te nté kaa ñaꞌa san ntaíta ntíꞌxin ña ne, katsixeꞌe ñā neé kakuvi. ");
INSERT INTO mizNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ntákaꞌan ñáꞌa san tsi Jésuú ne, ikan kuīta ntíꞌxin ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kidáa ne, un ntii tsi kakana ña kuāá san: —¡Jesuu, iꞌxá Davii, na ntuntāꞌví ini nto ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ña odo nūú ne, de tíi ña ni ñā vata koo é na kūtuvi kadin ña. Ntá tsi dā dií dií ka ntii kána ña: —¡Iꞌxá Davii, na ntuntāꞌví ini nto ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kidáā ne, kántītsí Jesuú ne, dā táxnuu ña ñā é kūkueká ña á ña kuāá san. Dā xee ñá ne, tsixeꞌe Jēsuu ña: ");
INSERT INTO mizNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Neé ntu ntio o é vīí u ni ō? —kaꞌan ña. Ña kuāá san ne, kakaꞌan ña: —Mastru, ntio ko é ntūváꞌa ntuxnuú ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesuú san ne, kakaꞌan ña: —Nakoton ve. É ntūváꞌa ntuxnúu o vē, tsí nɨɨ̄ kuéꞌen ini o kuíntiꞌxe o —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ura dúꞌva tsi i náxiꞌí nuu ñá kuāá san ne, dá kuēꞌen ña kuntikɨn ñá Jesuu, kakáꞌan ñá tsi dóo kaꞌnu Xuva kō. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, dā íni ña nuu i sáꞌa ne, ntákaꞌan ña e dóo kaꞌnu Xuva kō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Xée Jēsuu ñuú Jericoo. Ítā ntíꞌxin ña méꞌñū ñuú san. ");
INSERT INTO mizNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ikān tuví uun ñatīi, ñá nani Zāqueu, ña é odo nūu iña ña ntaído diuꞌun xôo íña ñuú Roma. Dōó kuika ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ña sāꞌá ne, dōó ncho kiní ña xoo ñáꞌa é Jēsuu ña, ntá tsi ña ni kuvi kiní ña, tsí ña te nté kaa ñaꞌa ntáñɨ nteē ñá ña ne, Zaqueú san ne, dōo lúꞌnti ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kidáā ne, kuéꞌen ña ōdó nuū ña ne, kúxēe ña rkɨ utun é ntitsi ítsi kān mí kuīta ntíꞌxin Jesuu é kinī ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Dā ita ntíꞌxin Jesuu íkān né, īto ña rkɨ utún san, kakaꞌan ña: —Zaqueu, kamá san nuun ve, tsí vevií ne, kantio é kutūví u nú viꞌi o kān —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kidáā ne, kantɨ́ꞌɨ duꞌva tsī núu ñā e dóo diní ña é kɨ̄ꞌɨn Jesuu nú viꞌi ña kān. ");
INSERT INTO mizNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dā íni ñaꞌa sán ne, un ntɨɨ́ ntɨɨ̄ ña ntákaꞌan kíni ña é kuēꞌen Jésuu kúkutúvi ñā nú viꞌī ña é iō kuetsí i. ");
INSERT INTO mizNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kidáā ne, nákuntītsí Zaqueu, kakaꞌan ñá ni Jēsuu: —Koto nto, Mastru. Kuéꞌē ú ña ntāꞌví san dava é un ntɨꞌɨ̄ é īó iñá ko. Tē xoó ñaꞌa kiꞌi dúꞌu ú iña ñá ne, nantiko kōó u kɨmi itó ka xtúku —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kakaꞌan Jésuu: —Ē vevií xee ntúvi é nakáku ña ntoo nú viꞌi sāꞌa, tsí ñatīí saꞌá ne, tatá ntiꞌxe Abraan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tsí xuꞌu é vēxkúvi ú ñatīí ne, véꞌxī u é kanantukū ú ña ntákunaa vata koo é nakākú u ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dā ntaíni ñaꞌa san é kākaꞌan Jésuu núu i sáꞌa ne, ntaa ña ni ña ūun nuu i, tsí e xee étsin ña ñuú Jerusaleén ne, kūtuni ña tsi ntádē kuení ñaꞌa san tsi é vevií xee ntúvī é kuiñɨ ntuꞌū é kadā kûꞌvé Xuva ko ñūxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kakaꞌan ña: —Uun ñatīí, ña e dóo kaꞌnu ñaꞌa ne, kuéꞌen ña tūku ñuu vata koo é nīꞌi ña é viī ñá rei. Rkontûví ne, ntiko koō ñá. ");
INSERT INTO mizNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Diꞌna dá kiī ña é kɨ̄ꞌɨn ñá ne, kāna ña uꞌxi ñáꞌa, ña ntáde tsiñu iña ñá ne, kuéꞌē diuꞌún san xeꞌé ña ña, xe un xé un ñā, kakaꞌan ña: “Kada tsiñu niꞌi ntō diuꞌun sáꞌa un tsi da nté nāxeé u”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ntá tsi ña ñuú mii ñā né, kūnéꞌū iní ña ni ñā. Taxnūu ña ña é kūkaꞌan ni ñá odo nūú san: “Ñá ntīo ntɨ́ ñatīí sāꞌa é viī ñá rei iñá ntɨ”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ʼNtá tsi kūkúꞌvē ña é viī ñá reí ne, ntiko koō ña, náxee ña ñuú ña kān. Dā náxee ñá ne, taxnūu ña é kīkaná ña ña ntáde tsiñu iña ña, ña é xēꞌé ña diuꞌun, vata koo é kūtuni ñá te kuēꞌe iꞌxá diuꞌun ña éꞌnu é xe un xé un ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ña é kuvi ūun sán ne, ntāda ña kuenta, kakáꞌan ña: “Tōꞌo, diúꞌun ntō ne, úꞌxi īto nteku éꞌnu”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kakaꞌán reí san: “Nté kui dóo váꞌā o, tsí dɨvīn né, dōo vaꞌá kaden tsiñun. Viꞌi a vé ne, kadān kúꞌven uꞌxi ñuu, tsi dén ntaan kuān te nté kaa kudii é tāꞌxí u o”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Xée xtuku ña uun ñaꞌa sán ne, kakaꞌan ña: “Tōꞌo, diúꞌun ntō ne, úꞌun īto ká xtuku niꞌi é vāta kaa”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Dukuān ne, kakaꞌan xtúku reí san ni ñā dɨ́: “Dɨvīn ne, kada kûꞌven uꞌun ñúu”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ʼKidáā ne, xée ña uun ñaꞌa ká san, kakaꞌan ña: “Tōꞌo, iꞌa niꞌi ú diuꞌun nto é xtuví vaꞌá u, e xnúu taꞌán u dodúkun ko. ");
INSERT INTO mizNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tsí uꞌví ko nto, tsí dɨvi ntō né, uun ñatīi e dóo kaꞌxī nima nto. Kanakuido nto nee iña é ña ni tsoo ntó ne, katɨɨn nto é tāta mí ña ni íꞌxi nto”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kidáā ne, kakaꞌán reí san: “Dɨvīn é ña váꞌā o ni den tsíñun, vatā ó kakaꞌán ne, nuu é ntaā i e dóo kaꞌxī nimá ko. Tsí inin tsí kanakuido ú nee iña é ña ni tsoó u ne, katɨɨn u mí ña ni íꞌxi ú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Dukuān ne, ¿nté kui ña ni de tsiñu níꞌin ntun diuꞌún ko vata koo é nīꞌi kúdii kó iꞌxá i tē náxeé u nú viꞌī ko?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kakaꞌan ñá nī ña ntoo san: “Nakiꞌi nto diuꞌún san ne, dá kuēꞌé nto ña é kuvi ide uꞌxi íto san”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ntákaꞌan ña: “Tōꞌo, ntá tsi ña tsīkán ne, é io ūꞌxi íto ká xtuku iña ña”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nantíko kōó reí san, kakaꞌan ña: “Sáꞌā ne, káꞌān u: Xoo é iō iña í ne, níꞌī ká ña, ntá tsi xoo é ña tuvi íña í ne, nakíꞌi ntɨꞌɨ ña, kuān té ña kuéꞌe é iō íña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kuenta iña ña é ntákuneꞌu iní i nī kó ne, ña é ña ni ntio i é viī ú reí ne, kixníꞌi nto ña īꞌa ne, dá kaꞌnī ntó ña nuú ko”, kaꞌán reí san —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Dā kúvi kaꞌan Jésuu sáꞌā ne, kuéꞌēn ká ña ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dā dokó sa xee ña ñuú Befagee ni ñuú Betaniá etsin nú xūku é nani Ōlivú ne, taxnūu ña uvi ñaꞌa, ñá ntɨniꞌi ñā, ");
INSERT INTO mizNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kakaꞌan ñá ni ñā: —Kueꞌēn ntó ñuú luꞌnti é tūvi étsin iꞌa. Tē xee ntó ne, ikān ntee tɨɨn uun a búru é ntē vata xoxó kuntēku í tɨ. Nantuté nto tɨ ne, dá kixniꞌi nto tɨ̄. ");
INSERT INTO mizNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tē xoó tsixeꞌe ī nté kui kanantuté nto a búru sán ne, káꞌan ntō tsi Tóꞌo nto kāntio ña tɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kuéꞌen ñā táxnuu ña san ne, nāniꞌi ña é un ntɨꞌɨ vatā ó kakaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dā nántuté ña burú san ne, katsixeꞌē tóꞌo tɨ̄: —¿Nté kui kanantuté ntu nto burú ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nantíko koō ña, ntákaꞌan ña: —Tōꞌó kāntio ña tɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kueꞌen níꞌi ña tɨ̄ mí tuví Jesuu. Tsido ña dōo ñá ata a búru sán ne, dā nakaa ña Jésuu áta tɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ñaꞌa sán ne, tsōo ña doo ña ítsi kān mí ita ntíꞌxin Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dā xee étsin ña mí dokuntíi xuku Olívu sán ne, un ntɨɨ́ ntɨ̄ɨ́ ña ntántīkɨn ñá ne, dōo diní ña. Kidáā né, uun tsi vāntiñɨ ña ntákaꞌan ñá e dóo kaꞌnu Xuva ko kuēnta iña i é un ntɨꞌɨ nūu i e dóo kaꞌnu é idé ña e íni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ntákaꞌan ña: —¡Dōó kaꞌnu Rei, ñá vēꞌxí ntaꞌa Xuva kō! ¡Na taꞌxi Xuva kō é kuntoo váꞌa o ni ñā viꞌi antɨvi! ¡Dōó kaꞌnu Xuva ko, ñā tuví e dukún kān! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kidáa ne, iō ñá fariseú, ña ñuꞌu taꞌan méꞌñu ñāꞌa sán ne, ntákaꞌan ña: —Mastru, kada tíi nto nī ña ntántīkɨn nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ntá tsi nantiko kōo Jesuu, kakáꞌan ña: —Te ñāꞌa san koo kádin ñā ne, un tsi nte xúú san kani ntuꞌu kāchuꞌu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Dā xee étsin Jesuu ñuú Jerusaleén ne, īto ña ñuú san ne, da éku ña kuénta iña í, ");
INSERT INTO mizNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kakaꞌan ña: —¡Tē dɨ́ ni īnín kuān te uun ntúvi vevii e nté koo kutūvín vaꞌan! Ntá tsi vevií ne, núu i sāꞌá ne, dōó xuꞌu íō. Ña kúvi kīnin. ");
INSERT INTO mizNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Viꞌi a vé ne, véꞌxi ntūvi é kini kaa iña o é ña ntaínchuꞌvi ó ne, kada xení ña ni ō. Kidáa ne, xntitsī ña ntóꞌō é kādɨ́ nuu ña ntíko diñɨ o. ");
INSERT INTO mizNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dá uun ito tsi nāntɨꞌɨ ntodó ña o. Kaꞌní ña ñaꞌa o. Nākatsin ntɨɨ́ ntɨɨ̄ ñá da nēé ka e kátūví iña o, tsí ña ni kutúni ō ura dá kiꞌxí Xuva kō é nakakū ñá o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kidáā ne, kúkɨ̄ꞌví Jesuu má ukún kaꞌnu kān né, eni ntuꞌu ñā kíñuꞌu ñā ña ntádikō nu kíꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kakaꞌan ñá ni ñā: —Tūꞌún Xuva kō ne, kakaꞌan: “Viꞌi kó ne, viꞌi mí kaꞌan ntâꞌví ñaꞌa”, kaꞌan Xúva kō. Ntá tsi dɨvi ntō ne, ntáde tsiñu niꞌi nto vata kaa viꞌi ña duꞌu —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Utén utén xee Jésuu ini ukún kān é nañēꞌe ñá ñaꞌa san. Ntá tsi tóꞌo dūtu ni mastrú lei, ni ña tsíñu i ne, ntánantukū nuu iní ña nté koo kaꞌní ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ntá tsi ña ni kuvi níꞌi ña nté koo vií ña, tsí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, ntaíni va váꞌa sa ña é kākaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Uun ntuvi ne, tuví Jesuu má ukún kan, kanañēꞌe ñá ñaꞌa san nté koo nakáku ña. Xée dūtu ñá odo nūu, ni mastrú leí san, ni ñatā san. ");
INSERT INTO mizNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kidáā ne, ntákaꞌan ñá, tsixeꞌe ña Jēsuu: —Kaꞌan ntó nī ntɨ: ¿Xoó ntu kakaꞌan i é kuān koo vií nto sáꞌā? ¿Xoó ntu teé tsiñu i nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kidáā ne, kakaꞌan Jésuu: —Xuꞌú dɨ ne, tsixeꞌē ú nto uun nuu i. Nantiko koō ntó, kaꞌan nto: ");
INSERT INTO mizNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Xoó ntu teé tsiñu ī Juaan é kuan kōo nakutsi ntute ña ñaꞌa san: Xuva kō né, ō ñaꞌa san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kidáa ne, eni ntuꞌu ñā natíin mii ñā, ntákaꞌan ña: —Te kāꞌan o é Xuva kō teé tsiñu ña ña ne, nantiko koō ñá, kaꞌan ña: “¿Nté kui ña ni kuīntíꞌxe ntu nto ña kuan?”, koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ntá tsi te kāꞌan o tsí ñaꞌa san teé tsiñu ña ña ne, kudiin ñáꞌa sán ne, kuéꞌe xuu ña kō. Tsí un ntɨꞌɨ ñāꞌa sán ne, iō ntaa íña ña tsí Juaán san ne, kakaꞌan ñá kuenta iña Xuva ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dukuān ne, nantíko koō ña, ntákaꞌan ñá tsi ñá ini ña xoo teé tsiñu i Juaan é nakūtsi ntute ña ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ña: —Xuꞌú dɨ ne, ña káꞌan ú xoo teé tsiñu i ko é kūvi vií u nuu i sáꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kidáa ne, eni ntuꞌu Jēsuu kántaa ña nuu i sáꞌa, kakaꞌan ñá ni ñāꞌa san: —Uun ñatīí ne, íꞌxi ña xōꞌo tɨntiꞌo mâña ñá kān. Rkontûví ne, dēꞌxé ña é tāta ña é kada tsiñu niꞌi tāan tuku ñaꞌa. Kidáā ne, kuéꞌen ña xīo ñuu. Dā kútɨtɨ́n ntuvi kueꞌen ñá ne, ");
INSERT INTO mizNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","taxnūu ña ña kade tsiñu iña ña e kíkakan ña é kadūku ntée tóꞌo ñā, ntá tsi dā xee ñá kade tsiñu sán ne, ēꞌní ña ña, dá nantīko koó ña ña da mii ntāꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kidáā né, taxnūu tóꞌo tɨ̄ntiꞌó san uun ká tuku ñaꞌa, ña kade tsiñu iña ña, ntá tsi ña tsīkán dɨ ne, dōó kini ō kaꞌan ñá ni ñā né, ēꞌní ña ña dɨ. Da mii tsi ntāꞌa ña ntíko koō ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tōꞌó i sán ne, taxnūu xtuku ña ña kade tsiñu iña ña, ñá kuvi ūní san. Ntá tsi ña ñuꞌu ntaꞌa ī tɨntiꞌó san ne, ntuku kuiꞌī xtúku ña ña ne, dā kíñuꞌu ña ña kíꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ʼKidáā né, tōꞌó ñuꞌu sán ne, kakaꞌan ña: “¿Neé ntu vii ú ve? Á te taxnūu ú iꞌxá miī ko. Da miī é kuiko ñuꞌu ña ñā”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ntá tsi ña ñuꞌu ntaꞌa tɨntiꞌo sán ne, dā íni ña iꞌxá ña ne, ntákaꞌan ñá xe un xé un ñā: “Ña sāꞌa é dūku ntée ña iña uva ña. Kaꞌní o ña vata koo é xoꞌo vīí o tóꞌo ñūꞌu san”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dukuān né, kīñuꞌu ña ña ñuꞌu uva ñā ne, dā éꞌni kueꞌen ñá ña —kuan ō kaꞌan Jésuu ni ñáꞌa san. Kidáa ne, tsixeꞌe Jēsuu: —¿Neé ntu vīi tóꞌo ī sán nī ñá ñuꞌu ntaꞌa ī é tātá san, te kuinī nto? ");
INSERT INTO mizNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Viꞌi a vé ne, á te kɨ̄ꞌɨn ña kikáꞌni ña ña ñuꞌu ntaꞌa ī san, dá tsuꞌun ntaꞌa ña é tāta ña tuku ñáꞌa —kaꞌan Jésuu. Ntá tsi dā téku ñaꞌa san sáꞌā ne, ntákaꞌan ña: —¡Nté kui sa! ¡Ña te kuan koo kúvi! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ntá tsi Jesuú ne, īto ña ña ne, dá kakāꞌan ñá ni ñā: —Viꞌi a vé ne, kaꞌan nto neé kani túꞌun é ūve naꞌa sáꞌa: Xúū é nantii níꞌni ña xntâñɨ víꞌi sán ne, dɨvī e dií ka nuu áꞌvi i, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Da xōó ka ñaꞌa, ña é ntāva ntodo nú xūu sáꞌa ne, táꞌnu kuēꞌen ña. Ntá tsi te xōo ñáꞌa kóꞌxo nuu xuú san ata ñá ne, un tsi kuvi utsi kúñu ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tōꞌó dutú san nī mastrú leí san ne, ntīo ña é tɨ̄ɨn ña Jesuu úra í tsíkan, tsi kútuni ña é kāntaa Jesuu núu i sáꞌa kuenta iña ña, ntá tsi uꞌvī ñá ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kidáa ne, taxnūu ña ñaꞌa é kīkoto xúꞌu ña Jesuú ne, īde sá ña vatā ó de ñaꞌa, ña e dóo váꞌa, tsi ntántukū nuu iní ña nté koo tsiꞌi kuétsi ña Jesuu ntáꞌa ña tsiñu i. ");
INSERT INTO mizNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kidáa ne, tsixeꞌe ña Jēsuu: —Mastru, iní ntɨ tsi nuu é ntaā i é un ntɨꞌɨ̄ é kākaꞌan nto dá kanañēꞌe ntó ntɨ ne, iní ntɨ tsí ña káde nto kuenta ñáꞌa san nte ntáa ña, tsí kakaꞌan ntáa nto nté koo kuntoo o vatā ó ntio ntiꞌxe Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dukuān né, ¿vāꞌá ntu ō e ntáꞌvi ō diuꞌun xôó san iña ñuú Romá ne, ō ña váꞌa ntu ō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ntá tsi Jesuú ne, kūtuni ña é ña te nɨɨ kuéꞌen ini ña katsixeꞌe ñā ne, kidáā ne, kakaꞌan ñá ni ñā: —¿Nté kui ncho koto nteé ntu nto ko? ");
INSERT INTO mizNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Viꞌi a vé ne, nāñeꞌe ká nto ko uun diuꞌún san. ¿Xoō ntú nuu i é ntēé san; ō xoó ntu dɨvī í e ntée naꞌá san? —kaꞌan ña. Nantíko koō ñá, ntákaꞌan ña tsí nuu ña tsiñu kaꞌnu i ñuú Roma ntée. ");
INSERT INTO mizNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kidáā ne, kakaꞌan Jésuu: —Kuéꞌe ntō ña tsiñu kaꞌnu i san nee é kāduku ntée ña ne, kuéꞌe nto Xuva kō nee iña é iña ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ña ni kúvi nīꞌi ña nté koo tsiꞌi kuétsi ña Jesuu kuénta iña túꞌūn é kākaꞌan ñá méꞌñū ñaꞌa san. Koó dā kúduꞌva ña é kuān nte íni ña nté koo nantiko koō ñá ne, diin diin sa intóo ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Rkontûví ne, kuéꞌēn ña saduceú san, kukoto ñá Jesuu. Tsí dɨvi ñā ne, ña ntákuintiꞌxe ña te nuu é ntaā i é ntoto o tē xiꞌi o. Dukuān né, tsixeꞌe ña Jēsuu núu i sáꞌa: ");
INSERT INTO mizNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Mastru, ini nto tsí Muiseé ne, xntée naꞌa ña tsí te uun ñatīí kuví ña ne, ntukíi ñadɨꞌɨ̄ ña é ntē ña ni xío iꞌxá ña ne, kantio é nātántaꞌa ñadɨ̄ꞌɨ kií san ni ēní xɨɨ ña vata koo é kōo iꞌxá ña ni ñā kuenta iña ñá xiꞌí san. ");
INSERT INTO mizNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Uun ito ne, īó uꞌxe ñáꞌa ení ña. Ña é kuvi ūun sán ne, tántaꞌa ña ne, xíꞌi ña dīꞌna dá kōo iꞌxá ñadɨꞌɨ̄ ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ña é kuvi ūví san ne, natántaꞌa ña ni ñadɨ̄ꞌɨ kií san. Xíꞌi ñā dɨ́ ne, nté uun iꞌxá ña ña ni xío. ");
INSERT INTO mizNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kidáa ne, nātántaꞌa ña é kuvi ūní san ni ñadɨ̄ꞌɨ́ san. Dukuān né, un ntɨꞌɨ ñā e kúvi uꞌxe ñáꞌa sán ne, xíꞌi ntɨ̄ꞌɨ ña e nté uun iꞌxá ña ña ni xío. ");
INSERT INTO mizNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kidáā ne, xíꞌi ñadɨ̄ꞌɨ́ san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Viꞌi a vé ne, tē ntóto ña da xiꞌí ña ne, ¿xoó ntu é kuvi ña dɨꞌɨ ī ña? Tsí un ntɨꞌɨ̄ ña é uꞌxe ñáꞌa san tántaꞌa ña ni ñadɨ̄ꞌɨ́ san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ña: —Ñuxiví sa ne, ñatīí ni ñadɨ̄ꞌɨ́ san ne, ntátántaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ntá tsi tē xoo é nīꞌi i é xēe e dukún kān ne, ntoto dadɨɨ ña nī ña xiꞌí san ikān ne, tē tií te ña dɨꞌɨ̄ ñá ne, ña tántaꞌa ká ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tsí ña kuví ka ña, tsí ntuvi ña vata ntáa ánjē san, ntuvi ña iꞌxá Xuva kō, tsi e ntóto ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Uun tsi nte míi Muīsee kakáꞌan ña tsí ntoto ña xiꞌí san da xntée naꞌa ña iña xuku é kaiꞌxi san. Ikān ne, kakaꞌan ña tsí Xuva kō né, dɨvi Xuva Ābraan ni Ísaa ni Jácoo. ");
INSERT INTO mizNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Xuva kō ne, ñá te Xuva ñā xiꞌi i, tsí Xuvā ña ntantíto ña. Tsí kuenta iña Xúva kó ne, é un ntɨꞌɨ ñā ntantíto ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kidáā né, īó mastrú leí san ne, ntákaꞌan ña: —Váꞌā ó kakaꞌan ntó, Mastru —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kidáā ne, úꞌvī ña e tsíxeꞌē ká ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesuú ne, tsixeꞌe ñā: —¿Nté kui kuān ó kakaꞌan ntú nto é Cristú ne, iꞌxá Davii ña? ");
INSERT INTO mizNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dɨvi tsi Dāvii kakáꞌan ña ini tutú Sálmū san: Xuva kō ne, kakaꞌan ñá nī Tóꞌō ko: “Kutūvín diñɨ kuaꞌa kó san ");
INSERT INTO mizNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","un tsi da nté natsiꞌi ú ña ntaínchuꞌvi o má xeꞌē ó san”, kaꞌan ña. Kuan ō kaꞌan Dávii. ");
INSERT INTO mizNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ntá tsi ¿nté ntu koo kuvi vií Cristu iꞌxá ika Dāvii? Tsí mii Dāvií san ne, kakaꞌan ña e Tóꞌo ña ñā —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntaíni ña dá kakāꞌan Jésuu ni ña ntɨníꞌi ñā: ");
INSERT INTO mizNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Kuenta tsí vií nto nī mastrú lei, tsí dóo ini xkuꞌun ña doo nani, taꞌan i e ntañúꞌu ña e dóo kiꞌin inī í san, da ntaíka ña. Dōó ntio ña é kāꞌan ñáꞌa san ni ñā ntiusi da ntaíka ña méꞌñū ñuú san. Tē xee ñá má viꞌī mí ntánataká nuu ña Israeé san ni vīꞌi viko sán ne, ntánantuku ñā míꞌī e dií ka váꞌā o é kuntōo ña. ");
INSERT INTO mizNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ña tsīkán ne, ntánakuido nuu ña viꞌi ñadɨ̄ꞌɨ kií san. Ntá tsi dóo naꞌa ntákaꞌan ntâꞌví ña vata koo é ña kutuni ñáꞌa san te dóo kini ntáa ña. Ña kuān ntáa sán ne, dií ka kueꞌe níꞌi ña é ntoꞌo ña ntaꞌa Xuva kō —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesuú ne, ntāniꞌi ña nuu ña, kaito ña ña kuika nté o de ña e ntátsuꞌun ña diuꞌun ini etún san. ");
INSERT INTO mizNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ikān dɨ́ ne, īní ña uun ñadɨ̄ꞌɨ kií ntāꞌví, kaxnūu ña úvī diuꞌun kuaán kuetsī sán ini etún san. ");
INSERT INTO mizNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kidáā ne, kakaꞌan Jésuu: —Nuu é ntaā i é kākaꞌán u tsi dií ka nuu áꞌvi diuꞌun é kaxnuu ñadɨ̄ꞌɨ ntâꞌví san é vāta kaa e tsúꞌun un ntɨꞌɨ ña nguiī san. ");
INSERT INTO mizNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tsí ña nguiī sán ne, kūdii diuꞌun é ntoó ka iña ña xeꞌé ña, ntá tsi ñadɨ̄ꞌɨ ntâꞌví san ne, xéꞌe ntɨ̄ꞌɨ ña vata kaa é īó iña ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iō ñáꞌa sán ne, ntákaꞌan ña tsi xúkūn kaꞌnu sán ne, ñá tē nté kaa váꞌā o, tsi dóo vaꞌá xuu kúvi, nī é iō iní i kān é xēꞌé ñaꞌa san doméni. Kidáā ne, kakaꞌan Jésuu: ");
INSERT INTO mizNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Véꞌxi ntūvi é un ntɨꞌɨ sāꞌa e ntaíní nto ne, nantatsin ntɨꞌɨ. Nté uun ká xuu ña kodo ntiꞌi táꞌan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kidáa ne, tsixeꞌe ña ñā: —Mastru, ¿amá ntu é kuān koo kuvi sáꞌa? ¿Neé ntu nuu i kuvi diꞌna dá kuan kōo kuvi? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kakaꞌan Jésuu: —Kuenta tsí vií nto vata koo é ña kaní ntaꞌví ñaꞌa san nto, tsi ñá te da dīi ñáꞌa kiꞌxi ña é kāꞌan ña é dɨvi ñā é Cristu ña ne, káꞌan ñā tsi é xee ntûvi i é ntɨꞌɨ ñūxiví sa dɨ, ntá tsi ña ku xkuntíkɨn ntó ña. ");
INSERT INTO mizNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Te tēkú nto mí kakuvi duꞌxēn, mí ntánāa ñáꞌa sán ne, ñá ku uꞌvī ntó, tsi sáꞌā ne, kuétsī é kuān koo kuvi diꞌna, ntá tsi vata xée ntúvi é ntɨ̄ꞌɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kidáā ne, kakaꞌan xtúku ña ni ñā: —Uun ñuú ne, nāá ni tūku ñuú san ne, ña tsiñu i sán ne, vií ña duꞌxen ni tūku ña tsiñu i. ");
INSERT INTO mizNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Iō vadá ñuú san ne, dōó ntii tāan; kutamá ñaꞌa sán ne, kunūu kuiꞌi e dóo ntii inī i, e dóo katɨ́ɨn ñaꞌa san. Koo nuu i e dóo donchuꞌví koo kuvi é vēꞌxí e dukún kān dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ʼNtá tsi diꞌna dá kuvi un ntɨꞌɨ sāꞌá ne, dɨvi ntō ne, tɨɨn ña nto. Kada xení ña ni ntō. Kɨꞌɨn níꞌi ña ntō é kōto nteé ña nto viꞌi mí ntánataká nuu ña Israee. Tsuꞌun kutu ña nto viūtun. Kɨꞌɨn níꞌi ña nto ntāꞌa rei ni ñá tsiñu kaꞌnu i san dɨ kuenta iña i e ntákuintiꞌxe nto ko. ");
INSERT INTO mizNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kuan kōo niꞌi nto itsi é ntaa nto ni ñāꞌa kuenta iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tsun rkó tsiñu nto vií nto é ña koo túꞌvē nto diꞌna nté koo nantiko koō nto é nadaꞌan ntō kúñu ntō. ");
INSERT INTO mizNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tsí xuꞌú taꞌxi u túꞌūn e dóo kukiꞌin inī ntó vata koo e nté uun ña ntaínchuꞌvi nto ña kuvi vií ña ni ntō, é ntē ña kuvi kaꞌan ntée ña nto. ");
INSERT INTO mizNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ntá tsi dɨvi ntō ne, dáꞌvī ñaꞌa san nto dóvete, un tsi nté uva nto, ni ēní nto, nī ñaviꞌi ntó, nī ña dóo váꞌa tiin niꞌi ntō dɨ. Iō ntó ne, kaꞌní ña nto. ");
INSERT INTO mizNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dá kanɨɨ ñūxiví san ne, ñá ntīo kueꞌen ñáꞌa san nto kuenta iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ntá tsi nté uun idi dɨkɨ nto ña kunáa. ");
INSERT INTO mizNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na kūtií nto nima ntó ne, kuan kōo niꞌi ntó ntuvi iña nto. ");
INSERT INTO mizNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ʼNtá tsi tē íni nto tsi ntántiꞌu nuu sntadún san ñuú Jerusaleén ne, kidáa ne, kūtuni nto tsi e xée ntúvi é nantatsin ntɨꞌɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kidáā ne, ña ntoo ñuú Judeá ne, na kūnu ñá, ntaa ñá rkɨ uku kan. Ña ntoo ñuú Jerusaleén ne, na ntii ña, kɨ̄ꞌɨn ña. Ña ñuꞌu má kūꞌu kán ne, ñá ku naxēé ka ña viꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tsí ntuvi tsikán ne, kiní ñaꞌa san dóxo, tsí da miī é kūntaa ntɨ́ꞌɨ é ūve naꞌa kakaꞌan túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ntāꞌvi ide ñádɨ̄ꞌɨ, ña é ñuꞌu iꞌxá i ntuvi tsikán, ni ñadɨ̄ꞌɨ, ña ntánatsītsí iꞌxá i! tsí ña te kúꞌve ntoꞌo ñaꞌa san, tsí uun doxo kaꞌnu kuvi ñuú saꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Iō ñá ne, kaꞌní nuu ña ñā káa. Iō ñá ne, kɨꞌɨn níꞌi ña ña viūtun é tuku e túku ñuu dá kanɨɨ ñūxiví sa. Ñaꞌa, ña é ña ni kuintíꞌxe i Xuva kō ne, kodo ntíꞌi ña ñūú Jerusaleen un tsi da nté ku é kūntaa ntúvi e xtúvi Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ʼKidáā ne, koo dóxo é kīni o núu ngántii, ni xōo, ni kɨ́mī san. Ñuxiví sa ne, dōo kúdana ñaꞌa un ntɨɨ́ ntɨ̄ɨ́ ñuú san ne, dōo úꞌvī ña e dóo donchūꞌví koo kuvi ntute ñuꞌu kān é kākaꞌan ñuꞌu. ");
INSERT INTO mizNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ñaꞌa sán ne, kūví nuu ña e dóo ntaúꞌvī ña e ntádē kuení ña nee iña é kākuvi ñuxiví sa. Un váꞌa tsi kantá nuu nuu i é īó e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kidáā ne, kiní ña tsí xuꞌu é vēxkúvī ú ñatīí ne, nainú u méꞌñū viko nuꞌu e dóo iō ko é vīí u é un ntɨꞌɨ̄, e dóo kaxiꞌí nuu kaꞌnu u. ");
INSERT INTO mizNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Te īñɨ ntuꞌu é kuān koo kuvi sáꞌa ne, nākuntáñɨ̄ nto, ntaa niꞌi nto dɨkɨ nto, tsí ntuvi tsikán ne, nakáku nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kakaꞌan ñá kuenta iña i sáꞌa: —Koto nto utun ígu san, o da nēé ka utun. ");
INSERT INTO mizNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tē íni nto tsí kanakōdó xuku i ne, kutuni ntó tsi é vēꞌxi étsin ntuvi kaꞌni. ");
INSERT INTO mizNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Dukuān né, tē íni nto é kuān koo kuvi sáꞌa ne, kutuni ntó tsi é vēꞌxi étsin ntuvi é kadā kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ʼNuu é ntaā i é un ntɨꞌɨ sāꞌá kuntaa díꞌna dá kūví ñaꞌa, ña ntántoo vevii. ");
INSERT INTO mizNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","E dukún kan ni ñūxiví sa ne, ntɨꞌɨ̄, ntá tsi túꞌūn é kākaꞌán u ne, da miī é kuntaa. ");
INSERT INTO mizNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ʼKuenta tsí vií nto. Ñá ku dā váꞌa nto é na ntūkaꞌxi nima ntó é viī nto é kīni kaa. Ñá ku nakuinī nto kúñu ntō é kada kɨꞌvi ntō. Ñá ku ntē dúkuan kadā kuení nto nee é kantio nto ñuxiví a, vata koo é ña da née inī nto xee ntúvi tsikan, ");
INSERT INTO mizNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","é vata kaa chitō. Tsi véꞌxi ntiꞌxe ntuvi tsīkan iña un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, ña ntoo da kanɨɨ dūꞌva ñuxiví a. ");
INSERT INTO mizNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Na kōo túꞌvē ntó ne, nguentúvi tsi kaꞌan ntâꞌví nto vata koo é nakáku nto é un ntɨꞌɨ nūu i é kuān koo kuvi, vata koo é kūvi xee ntó ntaꞌa ko, xuꞌu é vēxkúvī ú ñatīi —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ntuvi ā ne, tuví Jesuu má ukún kan, kanañēꞌe ñá ñaꞌa san. Niñú a ne, rkɨ uku é nani Ōlivu kañéꞌe ña. ");
INSERT INTO mizNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tévāá duꞌva tsi ntáxee ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san má ukún kān é kīni ña é kākaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","E xée ētsin viko da ntaéꞌxí ña tañúꞌū é ña kadáka uꞌxen íā. Viko sāꞌá ne, é nakaꞌān ña Israeé san nté ō nakáku Xuva ko ña dā ntáka ña ñuú Egítō. ");
INSERT INTO mizNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kidáā né, tōꞌó dutu ní mastrú leí san ne, ntukū nuu iní ña nté koo kaꞌní ña Jesuu, tsi ntaúꞌvī ñá ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kidáā ne, kúkīi é ña váꞌā san nima Júda, ñá nani Iscāriote, ña é uun ñaꞌa uxuvi ñáꞌa pustrú san. ");
INSERT INTO mizNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ña sāꞌá ne, kuéꞌen ña, kūkoto ñá tóꞌō dutu ni ñá odo nūú ini ukún kān, nté koo vií ña é ntāda ña kuenta Jésuu ntáꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kidáā né, dōo diní ña. Xéꞌe ñā xuꞌu ña é kuēꞌé ña diuꞌun Júdā san. ");
INSERT INTO mizNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Dɨvi ñā dɨ́ ne, xéꞌe ñā xuꞌu ñá ne, dā éni ntuꞌu ña ntukū nuu iní ña nté koo ntada ña Jesuu kuénta ntáꞌa dutu é ntē xoxó kiní i. ");
INSERT INTO mizNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kidáā ne, xée ntūvi é kāꞌxí ña tañúꞌū é ña kadáka uꞌxen íā ne, dɨvi tsi ntūvi dɨ́ ne, kantio é kaꞌnī ñá a leꞌntu iña vikó san. ");
INSERT INTO mizNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kidáā né, taxnūu Jésuú Pedru ní Juaán san, kakaꞌan ña: —Kueꞌēn ntó, kūtsoo túꞌve nto é kāꞌxi o iña viko san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dɨvi ñā né, tsixeꞌe ñā: —¿Míꞌi ntū ntio nto é kāda váꞌa ntɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nantíko kōó Jesuu, kakáꞌan ña: —Te kūkɨ́ꞌvi nto ñuú san ne, naniꞌi taꞌan nto úun ñatīi, ñá niꞌi uun xoó ntute. Kuntīkɨn ntó ña un tsi nte nú viꞌi mí ntɨ̄ꞌvi ña ne, ");
INSERT INTO mizNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","dá kāꞌan ntó nī tóꞌo vīꞌi san: “Katsixeꞌē Mastrú san nto: ¿Míꞌi ntu vāꞌá o mí kūvi kaꞌxí u nī pustrú ko iña vikó san?”, kuan kōo kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kidáā né, nañēꞌe ñá nto uun neꞌu viꞌi kaꞌnu mí odo ntiꞌi taꞌan san mí iō tuꞌvé ne, ikan kāda váꞌa nto é kāꞌxi o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kuéꞌen ñā né, nāniꞌi ntíꞌxe ña un ntɨꞌɨ̄ é kākaꞌan Jésuú ne, dā de váꞌa ña é kāꞌxí ña kuenta iña vikó san. ");
INSERT INTO mizNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Dā xee úra í ne, Jesuu ní pustru ñá ne, kántōo ña nú mesa kan. ");
INSERT INTO mizNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kidáā ne, kakaꞌan Jésuu: —Ñá tē nté kaa ntio ko é kāꞌxí dadɨɨ ú ni nto viko sāꞌa diꞌna dá kūví u. ");
INSERT INTO mizNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Káꞌān ú ni ntō tsi nté uun ito ká ña kaꞌxí ka ú iña viko san un tsi da nté kūntaa é un ntɨꞌɨ īña Xuva ko mí kadē kúꞌvē ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kidáā né, kīꞌi ña eꞌxin é ñuꞌu ntute tɨntiꞌó ne, dā nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō, kakaꞌan ña: —Kiꞌi nto sáꞌā ne, dá koꞌo dava nto ni tāꞌan nto xe un xé un ntō. ");
INSERT INTO mizNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Káꞌān ú ni ntō tsi nté uun ito ña koꞌó ka ú ntute tɨntiꞌo un tsi da nté kiꞌxi Xuva ko, kīxkada kúꞌvē ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kidáa ne, kīꞌi ña tañúꞌū san, da nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō. Kātsin dava ña é kāꞌxí ña, kakaꞌan ña: —Sáꞌā né, kūñú ko é ntūvi kuenta dóxiꞌí kān kuenta iña nto. Vii nto sáꞌā vata koo é nakaꞌan ntō ko nté ō dé u kuenta iña nto —kaꞌan Jésuú san. ");
INSERT INTO mizNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kuan ō dé ña ni eꞌxin san dɨ dā kuvi éꞌxi ña, kakaꞌan ña: —Eꞌxin sāꞌá ne, núu ī é xēe é taꞌxi Xuva ko xūꞌu ña é kātɨ ú nɨñɨ́ ko kuenta iña nto. ");
INSERT INTO mizNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ntá tsi vevií ne, ñatīi, ña diko xuꞌú ko ne, tuví dadɨɨ ña nī ko nú mesá sa. ");
INSERT INTO mizNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Vevií ne, xuꞌu é vēxkúvi ú ñatīí ne, da miī é kɨ̄ꞌɨ́n u itsi e táꞌxi Xuva kō, ntá tsi ¡ñā ntu ntáꞌvi ide á ñatīi, ña é diko xūꞌú ko san! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kidáa ne, eni ntuꞌu ñā ntátsixeꞌe tāꞌan ña xe un xé un ñā: —¿Xoō ntu ñáꞌa, ña diko xūꞌu ñá san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kidáā ne, ntánatíin ñā kuenta iña i xoo é dií ka nuu áꞌvi i, te kuinī ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ntá tsi kakaꞌan Jésuu: —Rei iña ña túku ñuú san ne, dōo ntádē kúꞌvē ñá iña ñá ñuú ña. Ntá tsi ntákaꞌan míi ñā e dóo váꞌā ó de ña ni ñāꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ntá tsi dɨvi ntō ne, ñá ku kuān xkoó de ntō. Dā xóo ká ñaꞌa nto, ña dóo nuu áꞌvi i ne, na viī ña vata tsi kaa uun ña kuetsī, ña é kui dutsi i. Xoo é kade kúꞌve i ne, na viī ñá vata kaa ña é kaxntiī. ");
INSERT INTO mizNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Xoó ntu é dií ka nuu áꞌvi i kuan: ña tuví ntu nú mesá san ne, ō ña katsuꞌun koꞌo? ¿Ñā ntu te ñá tuvi nú mesá san? Ntá tsi xuꞌú ne, vata kaa ña katsuꞌun koꞌo san kaa u é tuví u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ʼDɨvi ntō né, nɨɨ kuēꞌen tsí ntuvi é ntoo nto nī ko dá kantoꞌo kó da nēé ka nuu i. ");
INSERT INTO mizNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Xuꞌú ne, taꞌxi ú itsi é kadā kúꞌvē ntó vata ō táꞌxi uva kō é kada kúꞌve u. ");
INSERT INTO mizNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mí kadē kûꞌvé u ne, dadɨɨ tsi koꞌo káꞌxi o ni ntō nú mesá ko. Kuan koo kuntōo nto é kadā kúꞌvē nto íña uxuvi táta ña Israeé san dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sáꞌa kākaꞌan Jésuu: —¡Aí, Simuun! Koton tsí tóꞌō e ña váꞌā san ne, kaikan o é kɨ̄dɨ́ nuu o vatā ó de o nī trigu. ");
INSERT INTO mizNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ntá tsi xuꞌú ne, é īkán u kuenta iña o vata koo é ña xtuvín miin é kākuintiꞌxe o. Dɨvīn né, te ntiko kōon é kuintiꞌxe o kó ne, xntiin ēní o vata koo é dií ka kuintiꞌxe ña dɨ —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kakaꞌan Símuún san: —Tōꞌo, é iō tuꞌvé u é kɨ̄ꞌɨ́n u ni nto, kuān te viútun, kuān te dóxiꞌí kān dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ña: —Pedru, kakaꞌán u ni ō tsí vevií ne, diꞌna dá kāna lɨ́ꞌxɨ̄ sán ne, úni īto kaꞌan tsí ñá inín ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kidáā né, tsixeꞌe Jēsuu ña ntɨníꞌi ñā: —Dā táxnūu ú nto é kɨ̄ꞌɨn nto e nté ītɨn ntó ne, nté ñɨ̄ɨ e kañúꞌu diuꞌun nto, nté ntīꞌxen ntó dɨ, ¿vá neé ntu kunaá nteē nto? —kaꞌan Jésuu. —Ñá tē nee —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kidáā ne, kakaꞌan Jésuu: —Ntá tsi vevií ne, nadama. Xoo é īó itɨ́n i ne, na kuīdo ñá, ni ñɨ̄ɨ é xkuꞌún diuꞌun ña. Xoo é ña tuvi káa i ne, na nadiko ña kūtuun ñá ne dá kuīin ña káa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tsí kakaꞌán u ni ntō tsí kantio é kūntaa ntɨ́ꞌɨ é kākaꞌan túꞌun Xuva kō: “Ide ña ni ña vatā ó de ña nī ñá iō kuetsí i”, kaꞌan. Tsi é un ntɨꞌɨ̄ é ūve naꞌa kuenta iñá ko ne, kuetsi é kūntaa ntɨ́ꞌɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ña ntɨniꞌi ñā ne, ntákaꞌan ña: —Tōꞌó, iꞌa īó uvi káa —kaꞌan ña. Dɨvi ñā ne, kakaꞌan ña: —Xée ō tsi sáꞌā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kidáā né, kīi Jesuu, kuéꞌen ña xūku é nani Ōlivu vátā xkoó ini ña. Ña ntɨniꞌi ñā ne, ntántīkɨn ñá ña, kueꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dā xee ña íkān ne, kakaꞌan Jésuu ni ña: —Kantáꞌvī ntó vata koo é ña kóꞌxo nto nuu i é kīni kaa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kidáa ne, kīi nteé xio Jesuu, kuéꞌen ika ñā vata kaa mí nakuita ō xuu. Nákunchɨtɨ ñā é kaꞌan ntâꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kakaꞌan ña: —Ūvá, tē ntio nto ne, nakakū ntó ko é kantoꞌo kó nuu i sáꞌa. Ntá tsi ña vií nto é ntio kó, tsi é ntio mii ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kidáā ne, véꞌxi ūun ánjē iña Xuva ko é xntii ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","É kuān nte kantóꞌo ña ne, nɨɨ̄ kuéꞌen ini ña kakaꞌan ntâꞌví ña ne, uun tsī katoó naꞌnu nte ñúꞌu kan tīin ña é vata ito nɨñɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Dā kúvi kaꞌan ntâꞌví ña ne, nákuntītsí ña, kueꞌen ña mí ntoo ña ntɨniꞌi ñā. Dɨvi ñā ne, e ntákidi ña, tsi dóo kuntaꞌxa iní ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kidáā ne, kakaꞌan Jésuu ni ña: —¿Nté kui kuān nte ntákidi ntú nto? Nakuntáñɨ̄ ntó ne, dá kaꞌan ntâꞌví nto vata koo é ña kóꞌxo nto nuu i é kīni kaa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kakaꞌan dúkuan Jesuu da xée ñáꞌa san é ña te da dií ña. Ña é nanī Júdā, ña é kuvi ūxuvi ñáꞌa pustru ñá ne, odo nuū ña véꞌxi ña nuu ñaꞌá san ne, dā xee ñá mí tuví Jesuú san ne, dā éꞌxi ña xuꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kidáā ne, kakaꞌan Jésuu: —Xoꞌōn, Júdā, ¿vá xūꞌu ntu kó kaꞌxin é dikōn kó, xuꞌu é vēxkúvi ú ñatīi? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ña ntántoo ni Jēsuú san ne, ntaíto ña nee é kuvi ne, tsixeꞌe ñā: —Tōꞌó, ¿kaꞌní nuu ntu o ñā káa san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Uun ñaꞌa ñā né, ntuku kuiꞌī ñá ña kade tsiñu iña tóꞌō dutú san, ēꞌnté ña loꞌxo kuaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ntá tsi kakaꞌan Jésuu: —Na koo mii nto ñā. Kuan tsi koo na kōo —kaꞌan ña. Kidáā ne, tɨɨn ntaꞌa Jēsuu lóꞌxo ña kade tsiñu san ne, ntuváꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kidáā ne, kakaꞌan ñá nī tóꞌō dutu ni ñá odo nūu ini ukún kan, ni ñatā san, ña xee é tɨɨn ña: —Dɨvi ntō ne, odo nto káa ni ūtun, é vāta te ña duꞌú u. ");
INSERT INTO mizNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Da ītúvī ú ni ntō utén utén ini ukún kān ne, ntē ña ni tɨɨn ntáꞌa ntō ko, ntá tsi ura í e dóo neé sa ne, dɨvi ūra i é kāduku ntée nto e ntáde ntō nuu i é kīni kaa —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kidáa ne, tɨ̄ɨn ña Jesuu, kuéꞌen niꞌi ña ña nú viꞌī dutu ñá odo nūú san. Kuéꞌēn Pedru, kántikɨn íka ika tsi ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ikān tɨ́vi ña ñuꞌu nu kíꞌi kān ne, da túni ña ntíkō diñɨ nchúꞌūn san. Kátūvi Pedrú san ni ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kidáā né, uun ñadɨ̄ꞌɨ, ña é kade tsiñu sán ne, īní ña é ikān tuví Pedrú san nchúꞌūn san katúni ña ne, íntēꞌá ña ña ne, kakaꞌan ña: —Ña sāꞌá ne, dadɨɨ íka ña ni ña tsīkan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ntá tsi Pedrú san ne, tee xuꞌū ña, kakaꞌan ñá ni ñadɨ̄ꞌɨ́ san: —Xuꞌú ne, ñá īní u ña é kākaꞌan ntó san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Dā kú e víꞌi ne, é tūku ñaꞌa íni ña ña ne, kakaꞌan ña: —Dɨvīn né, kakuiniꞌi o ña tsīkan —kaꞌan ña. Ntá tsi Pedrú san ne, kakaꞌan ña: —¡Ñāꞌá ni san! Ña te dɨ́vī ú —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Dā kúvi uun urá ne, é tūku ña kakaꞌan ña: —Nuu é ntaā ntíꞌxe i tsí ña sāꞌá ne, dadɨɨ íka ña ni ña tsīkan, tsí dadɨɨ ñuu ña ñuú Galilea —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kidáā ne, kakaꞌán Pedru ni ña: —Ñá īní u nee é kākaꞌan nto —kaꞌan ña. Ura dúꞌva tsi i dá kakāꞌán Pedrú ne, kāna tsi lɨ́ꞌxɨ̄ san. ");
INSERT INTO mizNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kidáa ne, xkokōtó Jesuu, mí tuví Pedru. Kidáā ne, nánūꞌú Pedru iní ña nté o kakaꞌan Jésuu ni ña tsí diꞌna dá kāna lɨ́ꞌxɨ̄ sán ne, úni īto kaꞌan ñá e ñá ini ñá xoo ñáꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kidáa ne, kīí Pedru kíꞌi kān ne, dōo éku ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ñatīí, ña ntáde kuenta Jésuú ne, nārkɨ́nteē ñá ña ne, ēꞌní ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ēdɨ́ ña ntuxnúu Jesuú ne, dā ntákaꞌan ñá ni ñā: —Káꞌān ve, ¿xoó ntu éꞌni i o? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dōó tɨtɨ́n ka nuu i é ntákaꞌan kíni ña ni ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Dā tuví san ne, nátaká nuu ñatā ña Israeé san nī tóꞌō dutu ní mastrú leí san. Kueꞌen níꞌi ña Jēsuu méꞌñū ña tsiñu naꞌnu i ne, dā íkān tsíxeꞌe ña ñā: ");
INSERT INTO mizNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Káꞌan é nuu é ntaā i te Cristu ntíꞌxen —kaꞌan ña. Dɨvi ñā né, kakaꞌan ña: —Te kāꞌán u tsí dɨvī ú ne, ntē ña kuintíꞌxe nto ko. ");
INSERT INTO mizNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Te tsixeꞌē ú nto dɨ́ ne, ntē ña nantiko koó nto é kāꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ntá tsi un tsi nté vevií ne, xuꞌu é vēxkúvī ú ñatīí ne, tuví u diñɨ kuaꞌa Xuva kō, ña é dií ka kaꞌnu kueꞌen —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kidáā ne, un ntɨɨ́ ntɨɨ̄ ña tsíxeꞌe ña ñā: —Kidáa ne, ¿dɨvi ntūn é iꞌxá Xuva kō kuan? —kaꞌan ña. Kakaꞌan Jésuu: —Mii xntō ntákaꞌan ntó nee ñáꞌa u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kidáā ne, ntákaꞌan ña: —¿Míꞌi ntū kantio ká kō ña é kāꞌan ntaa? Tsí tutun mii ko téku ko e kéne ña kakaꞌan ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kidáā ne, un ntɨɨ́ ntɨɨ̄ ñá nakuntáñɨ̄ ñá ne, dā kueꞌen niꞌi ña Jésuu ntáꞌa Pilatu. ");
INSERT INTO mizNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ikān éni ntuꞌu ñā daꞌví ña ña dovete, ntákaꞌan ña: —E níꞌī ntɨ́ ñatīi saꞌa é kanatɨvī ñá ñuú ntɨ. Kakaꞌan ñá tsí ña váꞌa ō e ntáꞌvi ntɨ́ diuꞌun xôo íña ñuú Romá san. Kakaꞌan ñá dɨ tsí dɨvi ñā é Cristu ñá, dɨvi ñā é kuvi ña reí dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kidáa ne, tsixeꞌe Pīlatú san Jesuu: —¿Vá dɨvin ntūn é kūvin Rei iña ñá Israeé san? —kaꞌan ña. —Mii xnto kākaꞌan nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kidáā ne, kakaꞌan Pílatu ni tóꞌō dutu ní ñaꞌa san: —Ñá kānaniꞌí ko kuétsi ñatīí saꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dā dií dií ka xío ntii ñāꞌa san, ntákaꞌan ña: —Véꞌxi ña, kanakutsuꞌun ña ñāꞌa san nchúꞌun é kanañēꞌe ñá kanɨɨ ñūú Judeá ne, nté ñūú Galileá ne, un tsi nte íꞌa dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dā téku Pilatu sáꞌa ne, tsixeꞌe ña te ñatīí saꞌá ne, ña ñuú Galilea ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Dá kakāꞌan ña tsí dɨvi ñūu ñá ne, taxnūu ña ña ntaꞌa Heródē, ña tsiñu naꞌnu i ñuú Galilea, tsí tuví ña ñuú Jerusaleen ntúvi tsikan. ");
INSERT INTO mizNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Dā íni Heródē san Jésuú ne, dōo diní ña tsí e tɨ́tɨn ntuvi é ntio ña é kinī ñá ña, tsi téku ña e ntákaꞌan ñáꞌa san íña ña. Ntio ña é kinī ña é vīí ña nuu i e dóo kaꞌnu. ");
INSERT INTO mizNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dōo tsíxeꞌe ña ñā, ntá tsi ña ni káꞌan kueꞌen tsí Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ikān ntâñɨ tóꞌō dutú san nī mastrú leí san, e dóo ntátsiꞌi kuetsi ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kidáā ne, Heródē san ni sntadun ñá ne, dē xení ña ni Jēsuu. Nārkɨ́nteē ñá ña ne, naxnūu ña ña duꞌnu e dóo vaꞌa vata kaa é kainúu rei. Kidáā né, nataxnūu xtuku Heródē san ña ntaꞌa Pilatú san. ");
INSERT INTO mizNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ntuvi tsikán ne, dōo váꞌā o tiin Pilatú san ni Hēródē sán, kuān te ntuvi díꞌna ne, dōo ínchuꞌvi taꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kidáā ne, Pilatú san ne, nātaká nuu ña nī tóꞌō dutú san, nī ña tsiñu i, ni ñāꞌa sán ne, ");
INSERT INTO mizNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","dá kakāꞌan ñá ni ñā: —Dɨvi ntō é vēxníꞌi nto ñatīí saꞌá ntaꞌa kó ne, ntákaꞌan nto tsí kanatɨvī ñá ñaꞌa san, ntá tsi xuꞌú ne, tsixeꞌē ú ña nuu ntó ne, ñá ni nanīꞌí ntɨ kuétsi ñā nté uun nuu i vatā o ntákaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nte Heródē ña ni naníꞌi ña kuétsi ñā. Dukuān é nataxnūu xtuku ña ña ntaꞌa ko. Koto nto tsí ña té neé ni īde kueꞌen tsí ña é kuvī ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nantoꞌo ú ña ne, dá nakāka xaa ú ña —kaꞌan Pílatú san. ");
INSERT INTO mizNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tsi dá kakūvi viko sá ne, da miī é nakāka xaa Pilatú san uun ñaꞌa, ña ñuꞌu kutu, xoó ñaꞌa é ntio ñaꞌa san é ntīi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ntá tsi kuédadɨɨ tsī éni ntuꞌu ñā ntákachuꞌu ña: —¡Kaꞌní nto ña sāꞌá ne, nakāka xaa nto Barabaá san! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabaá san ne, nuu kutu ñā, tsí idé ña duꞌxen nī ña ñuu í ne, ēꞌní ña ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatú san ne, ntīo ña é nakāka xaa ña Jesuú ne, kakaꞌan xtúku ña ni ñāꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ntá tsi dií dií ka ntii káchuꞌu xtúku ña: —¡Na xnteē ntó ña ntiká krusi kan! ¡Na xnteē ntó ña ntiká krusi kan! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","É kuvi ūni íto kākaꞌan xtúku Pilatú san: —¿Nee iñá ntu é kīni kaa idé ña? Tsí ña kánaniꞌí ko kuétsi ñā é kuētsi é kuvī ña. Nantoꞌo ú ña ne, dá nakāka xaa ú ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ntá tsi ñaꞌa sán ne, ntaxío ntii ña ntákaꞌan ña tsí da miī é na nākuntée ña ntīká krusí san. Un tsi vāntiñɨ ña ntákaꞌan ña. Kūvi idé ña niꞌi ña é ntio ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatú san ne, íde ña vatā o ntákaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nakáka xaa ña ñatīi, ña nuu kutu viutun san kuenta iña i é idé ña duꞌxen nī e éꞌní ña ñaꞌa sán dɨ, ntá tsi ntāda ña kuenta Jésuú san ntaꞌa ñaꞌa san vata koo é viī ñá ni ñā nee é ntio ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dā kueꞌen niꞌi ña Jesuu é na xnteē ñá ña ntiká krusí ne, tɨɨn ña uun ñatīi, ña ñuú Cirene, ñá nani Sīmuun, ñá véꞌxi uun rantsu. Kuétsī é īdé ñaꞌa san ña é kunīꞌi ña krusí san é kuntīkɨn ñá ata Jésuú san. ");
INSERT INTO mizNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ñá tē nté kaa ñaꞌa ntántīkɨn ñá ña ne, ñá te da dīi ñádɨ̄ꞌɨ́ san dóo uꞌvi ntákuvi ña, ntaéku ña kuenta iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dā íto Jesuú san ñadɨ̄ꞌɨ́ san ne, kakaꞌan ña: —Ntoꞌó, ñadɨ̄ꞌɨ́ Jerusaleen, ñá ku ntē dúkuan ēku nto kuenta iñá ko, ntá tsi kueku nto kuenta iña mii nto ni iꞌxá nto. ");
INSERT INTO mizNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tsi véꞌxi ntūvi é kāꞌan nto: “Nté kuān nte vaꞌá ñaꞌa san, ña é ña ni kuvi kóo iꞌxá i, nī ña é ña ni ñúꞌu īꞌxá i íꞌxi i, nī ña é ña ni natsitsi íꞌxá dɨ”, koo kaꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kidáā né, kani ntuꞌu ñāꞌa san káꞌan ña é na nūu xuku san mí ntántoo ña, é ntio ña é kutāvi núu ña é kunuu xūꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ntá tsi te kuan ō ntáde niꞌi ña utun xɨꞌɨ̄ sán ne, ¿ntē ntú koo vií ña ni ūtun itsí san kuan? —kaꞌan Jésuú san. ");
INSERT INTO mizNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kueꞌen níꞌi ña ūvi ñaꞌa ña kini ntáa é dādɨɨ kaꞌní ña ña ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dā xee ñá xuku é nani Xkɨ̄dɨkɨ Ntɨ́xɨ sán ne, ikān náxnteē ñá Jesuu ntíkā krusi, ní ntuvi ñáꞌa ña kini ntáa san: uun ña ne, diñɨ kuaꞌa Jesuu intée ña; uun ña ne, diñɨ datsin ña intée ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesuú ne, kakaꞌan ña: —Ūvá, kada kaꞌnu iní nto ni ñā, tsi ñá ini ñá nee iña ntáde ña —kaꞌan ña. Sntadún san ne, nārkɨ́nteē ñá doo Jésuu xoo é kūvi vií i niꞌi i. ");
INSERT INTO mizNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ñaꞌa sán ne, ntáñɨ̄ ña, ntaíto ña ne, un tsi nté ña tsiñu i san ntánarkɨ́nteē ñá Jesuu, ntákaꞌan ña: —Ña sāꞌá ne, nakākú ña tuku ñaꞌa. Viꞌi a vé ne, na nakākú mii ñā kúñu ña, tē nuu é ntaā i é Cristu, ña é nakaxnúu Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sntadún san ne, nārkɨ́nteē ñá ña. Xée ētsin ña ne, xéꞌe ña ntɨ̄di íā é kōꞌo ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ntákaꞌan ñá ni ñā: —Te dɨvīn é Rei iña ñá Israeé ne, nakākún miīn kúñu ō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nteé letra dɨ́kɨ krusí san é kākaꞌan túꞌūn griegú, ni tūꞌún latiín, ni tūꞌún hebreu, kakáꞌan: “Ña sāꞌa é Rei iña ñá Israee”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Uun ñaꞌa ñā duꞌú san, ña nteé ntiká krusí san ne, kakaꞌan ña: —¡Tē nuu é ntaā i é Cristún ne, nakākún miīn kúñu ō ne, nakākún ntɨ dɨ! —kaꞌan na. ");
INSERT INTO mizNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ntá tsi ña uun ñaꞌa sán ne, kakaꞌan ñá ni tāꞌan ña: —¿Ña kaúꞌvī ntú o Xuva kō? Tsí dɨvīn né, dɨvi tsi nūu i kantóꞌo o dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ntá tsi xoꞌō né, iō nuu i e ntántoꞌo kō, tsi ntantáꞌvi o kuētsí kō e ntúku nuu ō. Ntá tsi ña sāꞌá ne, ñá tē neé kueꞌen tsí ni īde ña é kīni kaa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kidáā ne, kakaꞌan ña: —Jesuu, na nakaꞌan ntō kó tē xee nto mí kadā kúꞌvē nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kidáā ne, kakaꞌan Jésuu: —Nuu é ntaā i é kākaꞌán u ni ō tsí vevií kutūvín dadɨɨn nī ko mí ntántoo ña kuíntiꞌxe i, ña é xiꞌi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Un tsi nte da káꞌñu ntuvi ne, un tsi nte kaeku uni kuáa ne, kūneé da kanɨɨ ñūxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kūnee ngántií san. Uvi dávā ntíi dôxi é rkāa nuu ini ukún kaꞌnu kān. ");
INSERT INTO mizNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kidáā né, un ntii tsī káchuꞌu ntáa Jesuu, kakáꞌan ña: —¡Ūva, ntada ú kuenta nímá ko ntaꞌa nto ve! —kaꞌan ña. Dā kúvi kāꞌan ña sáꞌa ne, xíꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Dā íni tóꞌō sntadun ñá ñuú Romá san nté ō kúvi ne, kakaꞌan ña tsi dóo kaꞌnu Xuva kō. Kakaꞌan ña: —Nuu é ntaā i é ñatīí saꞌá ne, dōo vaꞌá ña; ña túvi kuētsí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Un ntɨꞌɨ kueꞌen dúꞌva ña ntaíto neé kuvi ne, kúnūꞌú ña, koó dā ntaxéꞌe ña ntaꞌa ña nima ñá e dóo uꞌvi ntákuvi ña. ");
INSERT INTO mizNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Un ntɨɨ́ ntɨ̄ɨ ñá ini Jesuú, ni ñadɨ̄ꞌɨ, ña ntántīkɨn ñá un tsi nte ñúu Galileá ne, intáñɨ ika ñā, ntaíto ña nté ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Uun ñatīi, ñá nani Jōsee, ña véꞌxi ñuú Arimatea é kāduku ntée ñuú Judeá ne, dōo vaꞌá ñaꞌa ña. Úvē taꞌan ña ña tsiñu naꞌnu i san iña ñá Israee. ");
INSERT INTO mizNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ña sāꞌá ne, kantétu ñā amá xee ntúvi é kadā kûꞌvé Xuva kō. Ñá ni kui dadɨɨ ña ni ña tsiñu i, ña nguiī san. ");
INSERT INTO mizNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dɨvi ñā ne, kuéꞌen ña, kūkoto ña Pilatú san é ntākan ña kúñu Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kidáā ne, nanúu ña ña ntīká krusí san ne, dā náxnuu taꞌán ña ña doo kuiꞌxin e dóo vaꞌá ne, dā kukúꞌxi ña ña iní ñañā mí kāntii iní xuu, mí vāta kunuu ntúꞌxi ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ntuvi tsikán ne, ntuvi e ntáxio túꞌve ña é kuiñɨ ntuꞌu ntúvi é iō dáꞌna san. ");
INSERT INTO mizNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ñadɨ̄ꞌɨ́, ña vexníꞌi Jēsuu un tsi nte ñuú Galileá ne, kuéꞌen ñā né, dā íto nuu ña ñañā san, ntaíto ña nté ō kanúu kúñu Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kidáā ne, kúnūꞌú ñā ne, da de váꞌa ña ntute choꞌo vîdin e dóo vá xkonuu, ni ūꞌxen xukú san dɨ. Kidáā ne, íntoo daꞌna ñadɨ̄ꞌɨ́ san ntuvi dá iō dáꞌna san, vatā ó kakaꞌan túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ntuvi dá nakiꞌi o vīté san ne, kuéꞌen xtuku ñadɨ̄ꞌɨ́ san nú ñaña Jēsuu, niꞌi ña choꞌo vîdin é de váꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dā xee ñá ne, īní ña tsí xuu é ītávī núu nú ñañā sán ne, é xīo nakutúvi. ");
INSERT INTO mizNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kúkɨ̄ꞌví ña, ntá tsi ña ni naníꞌi ka ña kúñū Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Koó dā kúduꞌva ña. Ntē ñá iní ka ña nté koo vií ña. Kidáā ne, da née inī ña íni ña uvi ñatīi é ntañɨ etsin ña nuu ña. Ñuꞌu ña doo kuíꞌxin é kāxiꞌí nuu kueꞌen. ");
INSERT INTO mizNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ñá tē nté kaa uꞌví ñadɨ̄ꞌɨ́ san, naxkāꞌnu nteɨ ña dɨkɨ ña nte ñúꞌu kān. Ntá tsi ñatīí san ne, kakaꞌan ña: —¿Nté kui ntánantuku ntu nto ña é kāntíto san méꞌñū ña xiꞌí san? ");
INSERT INTO mizNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Xóxō ñá iꞌa, tsi e ntóto ña. Nakaꞌan ntō nté o kaꞌan ña dá itúvi ká ña ñuú Galilea. ");
INSERT INTO mizNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Dɨvi ñā é vēxkúvi ña ñatīí ne, kaꞌan ña é da miī é ntūvi ña kuenta ntáꞌa ñá iō kuetsí i é na xnteē ñá ña ntiká krusi kan. Ntá tsi tē kúvi uni ntúvi xiꞌi ñá ne, ntoto xtuku ña, kaꞌan ña —kaꞌan ñátīí san. ");
INSERT INTO mizNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kidáā ne, nánūꞌu ñádɨ̄ꞌɨ́ san iní ña túꞌūn é kākaꞌan Jésuú san ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Dā ntáka ña nú ñañā sán ne, ntántaa ña un ntɨꞌɨ sāꞌá ni ūꞌxi ɨ́ɨn pustrú san, ni ña nguiī sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ña niꞌi túꞌun īña pustrú san ne: Maria Madálena, ní Juana, ni María, dɨꞌɨ Sāntiaú san dɨ, ni ñadɨ̄ꞌɨ́, ña nguiī san. ");
INSERT INTO mizNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Da ntákaꞌan ñádɨ̄ꞌɨ́ san, kuiní pustrú san da téku ña. Ntē ña ni kuintíꞌxe ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ntá tsi Pedrú ne, kīi ña, koó da kaīnu ña kueꞌen ñá nú ñañā san. Dā íto nuu ña iní i kān ne, koó da miī sá doo kuiꞌxín san íni ña. Kidáā ne, kúnūꞌú ña nú viꞌi ña kān. Koó dā kúduꞌva ña é kuan ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dɨvi tsi ntūvi tsikán ne, uvi ñáꞌa ña ntɨniꞌi Jēsuu kuéꞌen ña ñūú Emauu, ñuu é tuví te ūꞌxi ɨ́ɨn kilumétru é un tsi nté Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kuéꞌen ñā, ntántaa ña un ntɨꞌɨ nuū i e kúvi. ");
INSERT INTO mizNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nɨɨ dukuān ntatíin ña ne, xée Jēsuú san, eni ntuꞌu ñā ntaíka dadɨɨ ña ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kuān te íni ña Jesuú san ne, ñá ni kutūni ña xoo ñáꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kidáā né, tsixeꞌe Jēsuu ña: —¿Neé ntu e ntántaa nto dā veꞌxí nto ítsi kān? —kaꞌan ña. Íntāñɨ́ ntaꞌxa ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Uun ñaꞌa ña, ñá nanī Cliofá san ne, kakaꞌan ña: —¿Vá xīo ñuú ntu véꞌxi nto e ñá ini nto nté ō kúvi ñuú Jerusaleen ntúvi saꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kidáā ne, kakaꞌan Jésuu: —¿Ntē ntu o kúvi? —kaꞌan ña. Ntákaꞌan ña: —Ntántaa ntɨ́ kuenta iña Jésuu, ña véꞌxi ñuú Nazaree. Dɨvi ñā ne, ña é kaꞌán naa Xuva ko ña. Dōó iō ña é viī ña; dōó ini ña nté koo kaꞌan ña núu Xuva ko, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ntá tsi tóꞌō dutú san nī ña tsiñu i sán ne, ntāda ña ña kuentá vata koo é na kuvī ñá ne, xnteē ñá ña ntiká krusi kan. ");
INSERT INTO mizNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ntɨꞌɨ́ ne, ntantétu ntɨ é dɨvi ñā é nakakū ñá ña Israeé san. Ntá tsi vevií ne, é kūvi uni ntúvī é īta ntíꞌxin un ntɨꞌɨ sāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Iō ñá dɨ̄ꞌɨ́, ña ntɨniꞌī ntɨ́ ne, dā kúduꞌva ntɨ́ nuu i e ntákaꞌan ña. Tsí tevaá duꞌva tsi ñeꞌe ña nú ñañā san. ");
INSERT INTO mizNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ntá tsi ña ni naníꞌi ña kúñu Jēsuú ne, ntiko koō ña, náxee xtúku ña mí ntoo ntɨ́ kān. Ntántaa ñā tsi xée ánjē san nuu ña. Ntákaꞌan ánjē san tsí Jesuú ne, kantíto ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kidáa ne, iō ñá ntɨniꞌī ntɨ́ ne, ñéꞌe ñā nú ñañā san, ixkoto ntódo ña. Īní ña vatā o ntákaꞌan ñádɨ̄ꞌɨ́ san ne, ntá tsi ña ni iní ña Jesuu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kidáā ne, kakaꞌan Jésuu ni ña: —¿Neé ntu dɨkɨ dɨ́kɨ nto é ña ni kuintíꞌxe nto é un ntɨꞌɨ̄ e ntákaꞌan ñá kaꞌán naa Xuva ko? ");
INSERT INTO mizNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Vá ñā ntu te kantío é ntōꞌo Cristu, ña táxnuu Xuva kō, diꞌna dá kuēꞌé Xuva kō é kodo nuū ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kidáā né, eni ntuꞌu ñā nañéꞌe ñá ña nté o kakaꞌan túꞌun Xuva ko kuēnta iña ña. Eni ntuꞌu ñā nté tutu é de váꞌa Muiseé ne, ni un ntɨꞌɨ tūtu é de váꞌa ña kaꞌán naa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Dā xee étsin ña ñuú mí kɨ̄ꞌɨn ñá ne, íde Jesuú vata tsi te kɨ̄ꞌɨ́n ka ña itsi kān. ");
INSERT INTO mizNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ntá tsi tee kóo ña ña, ntákaꞌan ña: —Kutuvī ntó nī ntɨ tsí e kuáa vevii. E dóko sā kúnee —kaꞌan ña. Kidáā ne, kuéꞌen Jēsuu é kuntoo ña ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dā intóo dadɨɨ ña ni ñā nú mesa kán ne, kīꞌi Jesuu tañúꞌū ne, da nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō. Dā kátsin dava ña tañúꞌū sán ne, dā tsíꞌi ña ntaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ura dúꞌva tsi i náxiꞌi nuu ñá ne, kūtuni ña tsí dɨvi ñā é Jēsuu. Kidáā né, ntoko ñuꞌu mii Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kidáā ne, ntákaꞌan ñá xe un xé un ñā: —¿Ñā ntu te ntáa e dóo diní ñuꞌu nima kó dá kantaa ñá ni ko dā véꞌxi o ítsi kān, dá kanañēꞌe ñá kō túꞌun Xuva kō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ura dúꞌva tsi i nakuntáñɨ ña, ntíko koō ñá, kūnúꞌu xtuku ña ñuú Jerusaleen, mí nāniꞌi taꞌan ña uꞌxi ɨ́ɨn ñaꞌa pustru é nātaká nuu ña ni ña ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ntákaꞌan pustrú san ni ñā: —Nuu é ntāa ntíꞌxe i e ntóto Jesuu. É īní Simuun ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kidáā ne, ntuvi ña ntántaa ña nté ō kúvi itsi kān ne, nté ō nákiní ña Jesuú dā kátsin dava ña tañúꞌū san. ");
INSERT INTO mizNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ntoo dukuan ñā, ntákaꞌan ñá nuu i sáꞌa ne, da née inī xñá ntii dîto Jesuú san méꞌñu ñā, kakaꞌan ñá ni ñā: —Váꞌa tsi koo kuntōo nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dōó uꞌví ña. Ntádē kuení ña tē ntaíní ña ntatɨ ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ntá tsi kakaꞌan Jésuú san: —¿Nté kui kuān nte ntaúꞌvī ntú nto? ¿Nté kui kuān ó ntádē kuení nto? ");
INSERT INTO mizNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Koto nto ntaꞌa kó ni dɨ̄ꞌɨ́n ko. Dɨvi tsī ú. Koto nto kó ne, tɨɨn ntaꞌa ntō kó dɨ, tsí te uun ntatɨ ñāꞌa ne, ña túvī kúñu ī, nté xɨkɨ i vata kaa ú xuꞌu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Dā kúvi kaꞌan ña sáꞌā ne, náñēꞌe ñá ña ntaꞌa ña ni dɨ̄ꞌɨ́n ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dā íni ña ntoo sán ne, nakuꞌun dîní nima ñá, ntá tsi koó dā ntákuduꞌva ña é ña ni kuintíꞌxe ña é dɨvi ntiꞌxe ñā. Jesuú ne, kakaꞌan ñá ni ñā: —¿Īo ntú kudii é kāꞌxi ó iꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kidáā ne, xéꞌe ña ñā un síin tsákā, kɨtɨ kádun nuu. ");
INSERT INTO mizNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kīꞌi ña né, dā éꞌxi ña méꞌñū ña ntoo san. ");
INSERT INTO mizNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kidáā ne, kakaꞌan ña: —E kúvi kó ne, dɨvī é kākaꞌán u dá tūvi dukuan ú ni ntō. É kākaꞌán u tsí kantio é kūntaa un ntɨꞌɨ̄ é ūve naꞌa tutu é de váꞌa Muiseé san nī ña kaꞌán naa Xuva ko, ni tūtu é nanī Sálmū dɨ, mi é kākaꞌan kuénta iñá ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kidáā ne, náñēꞌe ñá ña é nakīni váꞌa ña túꞌun Xuva kō ne, ");
INSERT INTO mizNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","kakaꞌan ña: —Kuān ó uve naꞌa tsí Cristú ne, kantio é kuvī ñá ne, kantio é ntōto ña dɨ tē kúvi uni ntúvi. ");
INSERT INTO mizNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kantio é kaꞌan ntódo nto ni ñāꞌa san kuénta iña ñá kanɨɨ ñūú Jerusaleen ni dá kanɨɨ ñūxiví san dɨ. Kuéꞌe nto na kūtuni ñáꞌa san kuénta iña ña tsí da miī é kantio é natɨ̄vi iní ña kuétsi ñā ne, dukuān ne, kada kaꞌnu iní Xuva ko ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Dɨvi ntō é ini nto ne, ntada ntaa ntó nuu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kiní nto ve tsí xuꞌú ne, taxnūu ú Espíritu Xuva ko kuēnta iña ntó, vatā o táꞌxi Xuva ko xūꞌu ña nte díꞌna. Ntá tsi kuntōo xnto iꞌa ñuú Jerusaleén san un tsi da nté tē niꞌi nto ntíi ntō é taꞌxi Xuva kō —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kidáā ne, kueꞌen níꞌi Jēsuu ña ntɨníꞌi ñā diñɨ ñuú san, un tsi nte ñuú Betania. Ntāniꞌi ña ntaꞌa ña ne, dā náxnuu viko ña ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nɨɨ dukuan kānaxnuu viko ña ña ne, kīi nteé xio ña ña, kuntáa ña e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ña intóo sán ne, ntákaꞌan ña tsi dóo kaꞌnu Xuva kō. Kidáā né, ntiko koō ña, kunúꞌu ña ñuú Jerusaleen e dóo diní ñuꞌu nima ña. ");
INSERT INTO mizNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nɨɨ kuēꞌen tsí ntuvi ntoo ña má ukún kān, ntákaꞌan ña tsi dóo kaꞌnu Xuva kō.");
INSERT INTO mizNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nte dá iñɨ ntuꞌu ñúxiví sa ne, e dúkuan tuvi Túꞌūn san. Tuví dadɨɨ ña ni Xuva kō né, Xuva ko ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dɨvi ñā é tuví dadɨɨ ña ni Xuva ko ūun tsi nte dá iñɨ ntuꞌu ñúxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Un ntɨɨ́ ntɨ̄ɨ é īó ne, mii ñā de kúꞌvē ña. Ña túvī nee iñá te ña ni de kúꞌvē ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dɨvi ñā é kantito ña ne, tāꞌxi ña un ntɨꞌɨ̄ é īo. Ntuvi iña ñá ne, kaxiꞌí nuu iña ko un ntɨɨ́ ntɨ̄ɨ o. ");
INSERT INTO mizNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kaxiꞌí nuu ñuꞌú san mi dóo neé ne, ña kúvi vīi é nēé san nántaꞌva. ");
INSERT INTO mizNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Xío uun ñāꞌa, ña táxnuu Xuva kō, ñá nanī Juaan. ");
INSERT INTO mizNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dɨvi tsīñu ña é kāda ntaa ña iña ñuꞌú san, vata koo é na kuīntiꞌxe un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san Xuva ko kuēnta iña túꞌūn é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ñá tē dɨ́vi ñā e kúvi ñā ñuꞌú san, tsí da ti tsi táxnuu Xuva ko ñā é kāꞌan ñá kuenta iña ñúꞌú san. ");
INSERT INTO mizNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ña e kúvi ñuꞌu ntiꞌxe ne, véꞌxi ña ñūxiví san ne, nāxiꞌí nuu ña iña un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Īka ña ñuxiví sa ne, kuān te mii ña de kúꞌvē ñá ne, ña ntoo ñuxiví sa ne, ñá ni nakīní ña ña xoo ñáꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xée ña ñūú mii ñā, ntá tsi ña ñuú ña ne, ña ni ntío ña nakīní ña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ntá tsi xoo ñáꞌa, ña é nakīní ña ne, xéꞌe ñā é kūvi ña iꞌxá Xuva kō, da xōó ka ñaꞌa, ña e ntákuintiꞌxe i ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kuvi ña iꞌxá Xuva kō ne, ñá tē ntákaku ña vata ō ntákaku ñaꞌa ñuxivi; ñá te ñāꞌa san ntáde ña é kōo iꞌxá ña, tsí mii Xuva kō ntío ña é kūvi ña iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Dɨvi Tūꞌún tsikán ne, kuvi ñatīí ne, íntoo ña ni kō. Iní o tsi dóo vaꞌá ña ne, dōo kakuinima ñá kō. Da mii tsī é nuu é ntaā í kakaꞌan ña. Váꞌā kueꞌen ñá vata ō vaꞌá Xuva kō, tsí da xé Iꞌxá mii ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juaan sán ne, kakaꞌan ñá kuenta iña ña: —Ña sāꞌá ne, dɨvi ñā é kākaꞌán u kuenta iña ña. Dɨvi ñā é véꞌxi ña ata kō ne, dií ka kaꞌnu ñaꞌa ña é xuꞌu, tsí dií ka diꞌna tuví ña da káku u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","É nīꞌi ko, un ntɨɨ́ ntɨ̄ɨ o, é vāꞌá iña ña, e dá mii tsī é ntēkú ka doméni e táꞌxi ña kō. ");
INSERT INTO mizNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tsí leí san ne, xée ntāꞌa Muísee, ntá tsi e dóo kakuinima Xúva ko ko, ni tūꞌun é nuu é ntaā í san ne, xée kuēnta iña Jesúcristu. ");
INSERT INTO mizNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nté uun ito vata xoó kiní i Xuva kō. Ntá tsi Iꞌxá mii ñā e dóo kakuinima ñá ne, kantada ntaa ñá ni kō nté kaa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ña Israee, ñá ntoo Jerusaleén ne, taxnūu ña dutú san nī ña levitá san é tsixeꞌe ñā Juaán san xoo ñáꞌa ntu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juaán san ne, kantada ntaa ñá, kakaꞌan ñá ni ñā: —Ña te dɨ́vi u é Cristú u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tsixeꞌe xtuku ña ñā: —¿Xoó ntu ñaꞌa nto kuan? ¿Ō ña Elia ntú nto, kuān? —kaꞌan ña. —Ñāꞌá ni san —kaꞌán Juaan. —¿Vá dɨvi ntu ntō ña kaꞌán naa Xuva ko, ña tsíkan? —kaꞌan ña. —Ñáꞌā —kaꞌan Juaan. ");
INSERT INTO mizNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kidáā ne, ntákaꞌan ñá ni ñā: —Káꞌan nto xoo ñáꞌa nto vata koo é kūvi kaꞌan ntɨ́ nī ña táxnūu ntɨ. ¿Nté ntu koo kaꞌan nto kuenta iña mii nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kidáā ne, kakaꞌán Juaan: —Xuꞌú ne, kūdii uun tatsin é kaika má kūꞌu kan, é kakana: “Na kōo túꞌve ntó itsi ntaa kuénta iña Tóꞌo kō”, vata ō xntée naꞌa ñá kaꞌán naa Xuva ko, ñá nani Isāia, kídaā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ña táxnūu ña fariseu é kāꞌan ñá nī Juaán ne, ");
INSERT INTO mizNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","tsixeꞌe ña ñā: —¿Nté kui kanakūtsi ntute ku nto ñaꞌa sán tē ña te Crístu nto, tē ña te Élia nto, tē ña te dɨvi ña kaꞌán naa Xuva ko ntō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kakaꞌán Juaan ni ña: —Xuꞌú ne, kūdii ntute kánakūtsi ntute ú ñaꞌa san. Ntá tsi ntitsí uun ñaꞌa méꞌñu ntō, ña é vāta kíni nto. ");
INSERT INTO mizNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dɨvi ñā ne, rkontûvi véꞌxi ña é xūꞌu, ntá tsi dɨvi ñā né, odo nuū ña é xuꞌu. Tsí xuꞌú ne, ñá tē neé nuu áꞌvi ko, nté nantīi ú ntiꞌxen ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Sáꞌā kúvi ñuú Betania, dɨvi ñūu é tuví uun xo diñɨ ntute kaꞌnu é nani Jōrdaan, mí kanakūtsi ntute Juaán san ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Utén san ne, īní Juaan tsí véꞌxi Jesuu mí tuví ña ne, kakaꞌan ñá ni ñāꞌa san: —¡Un kaa Á Leꞌntu Xúva kō, ña e ntáꞌvi kuétsi i īña un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntántoo ñuxiví sa! ");
INSERT INTO mizNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Dɨvi ñā é kākaꞌán u ni ntō tsí rkontûvi véꞌxi uun ñaꞌa, ña é odo nūu kueꞌen é xuꞌu, tsí e dúkuān tuví ña da káku u. ");
INSERT INTO mizNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nté xuꞌu ñá īní u xoo ñáꞌa ña, ntá tsi véꞌxī u, véxnakutsi ntūte ú ñaꞌa san vata koo é ña Israeé san ne, na nā kiní ña ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kakaꞌan xtúku Juaan: —Īní u Espíritu Xuva kō dá vēꞌxí ña nte e dukún kān é vāta kaa paloma káa ña ne, kántēkú ntiꞌi ña ata tsío ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Xuꞌú ne, ntē vata kutúni ko xoo ñáꞌa ña, ntá tsi ña táxnūu ko é nakūtsi ntute ú ñaꞌa sán ne, kakaꞌan ñá nī ko: “Te kīní nto tsí inu ñúꞌu Espíritū mí ntitsi úun ñaꞌa, te kutuvī niꞌi ña ñá ne, dɨvi ñā é kuēꞌé ña é kūnuu Espíritū Sántū nima ñáꞌa san.” Kuan ō kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Xuꞌú ne, īní u ña ve ne, kaꞌán u ni ntō tsí dɨvi ñā é Iꞌxá mii Xuva ko ñā —kaꞌán Juaan. ");
INSERT INTO mizNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Utén san ne, ntâñɨ xtúku Juaan ni uvi ñáꞌa, ña ntántīkɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dā íni ña tsi ita ntíꞌxin Jesuú ne, kakaꞌán Juaan: —¡Un kaa Á Leꞌntu Xúva kō! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ntúvi ñaꞌa, ña ntántīkɨ́n Juaán san ne, tēkú ña é kuān ó kakaꞌan ñá ne, kuéꞌen ña, kūntíkɨn ña Jēsuu kídaā. ");
INSERT INTO mizNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Xkokoto Jesuu áta ña ne, īní ña tsi ntántīkɨn úvi ñāꞌa ñaꞌá san ñá ne, dá kakāꞌan ñá, tsixeꞌe ñā: —¿Neé ntu ntánantuku ntō? Ntákaꞌan ñá ni ñā: —Mastru, ¿míꞌi ntū tuví nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kakaꞌan ñá ni ñā: —Kixkóto nto —kaꞌan ña. Kuéꞌen ñā né, īní ña mí tuví Jesuú ne, ikān intóo ña ni ña ntūvi tsikan ūun ñúu, tsí e kuáa xee ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Uun ñaꞌa, ña e téku i é kākaꞌán Juaán ne, kuntíkɨn ña Jesuu. Andree náni ña. Ení Simuun Pedru ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Diꞌna nántuku ña ēní ña Simuún ne, kakaꞌan ñá ni ñā: —É nāniꞌí ntɨ Mesia, ña e ntákaꞌan ña é Cristu, ña táxnuu Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ntēka Andreé ña mí tuví Jesuu. Īto Jesuu ñá ne, kakaꞌan ña: —Dɨvīn né, Simuun, iꞌxá Juaan. Ntá tsi xntántēe ú o Cefa —kaꞌan ña. (Cefá ne, Pedru káni túꞌun é griegu.) ");
INSERT INTO mizNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Utén san ne, kakaꞌan Jésuu tsí kɨꞌɨn ña ñuú Galilea. Ikān nániꞌi ñá Felipé ne, kakaꞌan ñá ni ñā: —Kuntīkɨ́n ko ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipé ne, ñuú Betsaida véꞌxi ña, ikan ñūú Andree ni Pedrú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipé ne, nántuku ña Natānaeé ne, kakaꞌan ñá ni ñā: —É nāniꞌí ntɨ ña é kākaꞌan Muísee íni librú leí san, nī é kākaꞌan ñá kaꞌán naa Xuva kó dɨ. Dɨvi Jēsuu, iꞌxá Josee, ña véꞌxi ñuú Nazaree —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kidáā ne, kakaꞌan Natánaee ni ña: —¿Vá iō ntu é vāꞌa e kií nuu ñuú Nazaree? —kaꞌan ña. Kakaꞌan Félipe ni ña: —Kīxkóton ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Dā íni Jesuu tsi véꞌxi Natanaee mí tuví ña ne, kakaꞌan ña: —Un kaa ntíꞌxe uun ñaꞌa ña Israee. Ñá īni eni ntaꞌví ña ñaꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kakaꞌan Nátanaee ni ña: —¿Nté ō íni ntu nto ko? —kaꞌan ña. Kakaꞌan Jésuu ni ña: —Īní u o dá nuun má tun ígu san diꞌna dá kāna Felipe o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kakaꞌan Nátanaee ni ña kídaā: —Mastru, Iꞌxá Xuva ntiꞌxe ko ntō. Rei iña ñá Israeé san nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kakaꞌan Jésuu ni ña: —¿Kakuintiꞌxe o tsí da xé kakaꞌán u é īní u o má tun ígu san? Ntá tsi da ve kinín nuu i é dií ka naꞌnu é vāta kaa nuu i sáꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kakaꞌan xtúku Jesuu: —Nuu é ntaā i é kākaꞌán u ni ntō: Viꞌi a vé ne, kiní nto e dukún kān é kantii ne, kiní nto ánje Xuva kō kantaa kantíi ña mí tuví u, xuꞌu é vēxkúvi ú ñatīi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dā kúvi uni ntúvi ne, viko kakuvi é katántaꞌa ñaꞌa ñuú Canaa é kāduku ntée ñuú Galilea. Ikān tuví dɨꞌɨ Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kāna ña Jesuu ni ña ntɨníꞌi ñā é kɨ̄ꞌɨn ña víko sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dā ntɨ́ꞌɨ ntute tɨntiꞌō sán ne, kakaꞌan dɨ́ꞌɨ Jēsuu ni ña: —Ña túvī ká ntute tɨntiꞌō san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kakaꞌan Jésuu ni ña: —¿Nté kui kuān ó kakaꞌan ntú nto nī kó, ñadɨ̄ꞌɨ, tsí vata xée ura i íñá ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kidáā ne, kakaꞌan dɨ́ꞌɨ ña nī ña ntátsuꞌun koꞌo san: —Vií nto nee iña é kāꞌan iꞌxá ko ni ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ikān ne, īó iñu kɨdɨ é kūvi xuu, e dé tsiñu niꞌi ña e ntúntoo ña vatā xkoó ini ña. É un é un kɨ́dɨ̄ ne, kakii kúꞌve te uun siēntu lítru. ");
INSERT INTO mizNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kakaꞌan Jésuu ni ña: —Tsuꞌun tsitu nto ntūte kɨ́dɨ san —kaꞌan ña. Tsuꞌun tsitu ña ntūte un tsi nte xúꞌu i ne, ");
INSERT INTO mizNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","kakaꞌan Jésuu ni ña: —Kiꞌi ntodó nto ne, kueꞌēn niꞌi nto mí tuví vartuma kuinúu san —kaꞌan ña. Kuān o dé ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Dā íto ntee vartuma kuinúu sán ntute e ntúvi ntute tɨntiꞌō sán ne, ñá ni inī ña míꞌi vēꞌxi. Ntá tsi ña ntátsuꞌun koꞌo sán ne, ini ña, tsí dɨvi ñā táva ña. Kāna vartuma kuinúu san ñatīi, ñá dā ve tántaꞌa sán ne, ");
INSERT INTO mizNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kakaꞌan ñá ni ñā: —Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, diꞌna katsuꞌun ña ntute tɨntiꞌō é dií ka vaꞌá san. Ntá tsi te īta ntíꞌxin kueꞌe xiꞌi ña ntántoo sán ne, kidáā táva ña ntute tɨntiꞌō é ña te nté sa vaꞌa. Ntá tsi dɨvi ntō ne, dá ntē vevií katavá nto ntute tɨntiꞌō é dií ka vaꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sáꞌa īdé Jesuu ñuú Canaa é kāduku ntée ñuú Galileá ne, kūvi diꞌna nuu i e dóo kaꞌnu idé ña vata koo é kūtuni ñáꞌa san tsi dóo kaꞌnu ñaꞌa ña. Kidáā né, kuīntiꞌxe ña ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kidáā ne, kuéꞌen ña ñūú Capernau ni dɨꞌɨ ña ni enī ñá, ni ña ntɨniꞌi ñā dɨ. Ikān intóo ña te ūvi uni ntúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Dā doko sá xee ntuvi viko e nákaꞌan ña Israeé san ntuvi da nátāvá Xuva ko ñā ñuú Egítō ne, kúntāa Jesuu ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dā kukɨ́ꞌvi ñā má ūkún kaꞌnu kān né, nāniꞌi ña ña ntádiko duntɨkɨ, leꞌntú, ni pālomá san. Ikān ntoo ña ntánadama diuꞌún dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dā íni Jesuú ne, de váꞌa ña uun xoꞌo xume ne, dā táꞌxi nūu ña ñaꞌā sán, nakúnu ña ñā má ūkún kan, ni ūn ntɨɨ́ ntɨ̄ɨ duntɨkɨ́ ni lēꞌntú ne, nantáva ña mēsa ñá ntánadama diuꞌún san. ");
INSERT INTO mizNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kakaꞌan ñá nī ña ntádiko pālomá san: —Kueꞌēn niꞌi nto láa san kíꞌi kān. Ña kú de nto viꞌi Uvā kó viꞌi xáꞌvī —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kidáā né, ña ntɨniꞌi ñā san nánūꞌu ña iní ña tsí kuān ó uve naꞌa kakaꞌan túꞌun Xuva kō: “Dōo uꞌvi kakúvi ko é kuān ó ntáde niꞌi ña viꞌi Uvā ko”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kidáā ne, tsixeꞌē ña Israeé san ña: —¿Neé ntu nuu i e dóo kaꞌnu nañéꞌe ntó ntɨ kuān, vata koo é nīꞌi itsi nto é viī nto sáꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kidáā ne, kakaꞌan Jésuu ni ña: —Nakatsin nto xúkūn saꞌá ne, tē kúvi uni ntúvi naxntītsi xtúku u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kidáā ne, ntákaꞌan ñá Israeé san: —Úvi dīko iñu kuia dé tsiñu ñaꞌa e xntítsi ña xúkūn sán ne, dɨvī ntó ne, úni ntuvi tsi naxntitsī ntó, kaꞌan nto —kaꞌan ñá Israee. ");
INSERT INTO mizNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ntá tsi xúkūn é kākaꞌan Jésuú ne, kūñú mii ñā kúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Dukuān né, dā ntóto Jesuu rkontûvi é xiꞌi ñá ne, nánuꞌu ña ntɨniꞌi ña inī ña tsí kuan ō kaꞌan ñá saꞌá ne, kuīntiꞌxe ña túꞌun Xuva kō é ūve naꞌá san, ni tūꞌun é kākaꞌan Jésuu ni ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Dá tūví Jesuu ñuú Jerusaleen ntuvi dá ñuꞌu viko, ñá te da dīi ñaꞌa kuíntiꞌxe ña ña dá ini ña nuu i e dóo naꞌnu é idé ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ntá tsi Jesuú ne, ñá ni intée ini ña ñaꞌa san, tsí ini ña nte ntáa nima ña. ");
INSERT INTO mizNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ña ni ntío é kāꞌan ñáꞌa san ni ñā nte ntáa taꞌan ña, tsí ini ña nté ntaa nima ún ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Xío ūun ñaꞌa ña fariseu, ñá nani Nicōdemu, ñá tsiñu ñuú Israee. ");
INSERT INTO mizNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Xée ñā é nīñu mí tuví Jesuú ne, kakaꞌan ñá ni ñā: —Mastru, iní ntɨ tsí taxnuu Xuva ko ntō é nañeꞌē ntó ntɨ. Tsí nté uun ñaꞌa ña kuvi vií ña nuu i e dóo kaꞌnu vatā ó de nto tē ña te Xuva ko túvi niꞌi ña ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ō: Xoxó kuvi kini i mí kadē kûꞌvé Xuva ko tē ña kaku é kuvi uvi ito —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kakaꞌan Nicódemu ni ña: —¿Nté ntu koo kaku xtuku o tē kuáta ō? ¿Vá kūvi ntu nakunuu xtuku o ini iꞌxí dɨꞌɨ kō é kaku xtuku ō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ō: Xoo é ña kaku i ni ntute ni Ēspíritū ne, ña kúvi kɨ̄ꞌví ña mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nee é kakaku nī kúñū né, kūñu kúvi; ntá tsi nee é kakaku ni Ēspíritū ne, Espíritu kāduku ntée. ");
INSERT INTO mizNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ñá ku da kudūꞌva o é kākaꞌán u ni ō é kantio é kāku xtukun. ");
INSERT INTO mizNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tátsīn sán ne, kainu da míꞌī ka mí ntio i. Kuān te díto é kākaꞌan ñuꞌú ne, ntá tsi ntē ña kutúni mí vēꞌxí, ntē ña kutúni mí kɨ̄ꞌɨ́n dɨ. Kuan tsi īó iña un ntɨ́ꞌɨ ñāꞌa, ña é kakuniꞌi Ēspíritu Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kidáā né, tsixeꞌe xtuku Nicōdemu: —¿Nté ntū ó sáꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nantíko kōó Jesuu, kakáꞌan ña: —Dɨvīn é mastrun iña ñá Israeé ne, ¿vá ña ntu inin sáꞌā? ");
INSERT INTO mizNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nuu é ntaā i é kākaꞌán u ni ō. Ntákaꞌán ntɨ nēe é īní ntɨ. Ntántaa ntɨ́ nēe é iní ntɨ, ntá tsi dɨvi ntō ne, ña ntákuintiꞌxe nto nēe é ntákaꞌán ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tē ña ntákuintiꞌxe nto é kākaꞌán u ni nto iña i é īó ñuxiví sa ne, ¿nté ntu koo kuintiꞌxe nto te kāꞌán u ni ntō iña i é īó e dukún kān? ");
INSERT INTO mizNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ʼTsi nté uun ñāꞌa vata ntaa ña e dukún kān. Mii tsī u é vēꞌxí u e dukún kān é vēxkúvi ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Vata tsī o dé Muisee é xkaa dukūn ñá koó san ñuu itsí kān né, kuan tsī koo ntaa ntita dūkún u dɨ, xuꞌu é vēxkúvi ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Da xōó ka ñaꞌa é kuīntiꞌxe i kó ne, níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ʼE vánchuꞌūn ntío Xuva ko ñūxiví sa ne, tāꞌxi ña Iꞌxá mii ñā, vata koo é un ntɨꞌɨ ñāꞌa, ña é kakuintiꞌxe i ña ne, ñá kunāá ña, tsí ntii dañu ntuvi kuntoo ña ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tsi ñá ni taxnuu Xuvā kó ko, xuꞌu é Iꞌxā ñá, ñuxiví sa é na nākunaá u nto, tsí táxnūu ña ko é nakākú u nto. ");
INSERT INTO mizNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ʼXoo é kākuintiꞌxe i kó ne, ñá nīꞌi ña é ntōꞌo ña kuenta iña kuétsi ña. Ntá tsi xoo é ña kákuintiꞌxe i kó ne, é īo é ntōꞌo ña, tsí ña ni kuintíꞌxe ña ko, xuꞌu é Iꞌxá mii Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Dukuān ne, níꞌi ña é ntōꞌo ña, tsí xee ñúꞌú san ñuxiví a, ntá tsi dií dií ka xkúntee iní ña mí nēe é mí kaxiꞌí nuu san, tsí da mii kuēꞌen tsi é kīni kaa ntáde ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Da xōó ka ñaꞌa, ña é kade é kīni kaa ne, ña ntío kueꞌen tsí ña ñuꞌú san. Ntē ña kaxee étsin ña mí kāxiꞌí nuu, vata koo é ña tídito nuu i é kāde ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ntá tsi xoo ñáꞌa, ña é kade é nuu é ntaā í ne, kaika ña mí kāxiꞌí vata koo é na tīdito tsí kade ntaa ña vatā ó kakaꞌan Xúva kō é viī ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dā kúvī sáꞌā ne, kuéꞌen Jēsuu ni ña ntɨníꞌi ña ñūú Judea. Ikān intóo ña, ntánakutsi ntute ña ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juaán dɨ ne, kanakūtsi ntute ña ñaꞌa, ña ñuú Enoo é tuvi étsin ñuú Saliin, tsí dóo iō ntúte ikān. Ntáñeꞌe ñáꞌa san ne, ntaítsi ntute ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tsí vata kúnuu kutū Juaan. ");
INSERT INTO mizNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Íō ña ntántīkɨ́n Juaán ne, eni ntuꞌu ñā ntátiin nuu ña nī uun ñaꞌa ña Israee kuénta iña í vatā xkoó ini ña é ntántoo ña kúñu ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kuéꞌen ñā mí tuví Juaán ne, ntákaꞌan ñá ni ñā: —Mastru, ña itúvi niꞌi nto diñɨ ntute kaꞌnu Jordaán san, ña é kākaꞌan ntó nī ntɨ́ ne, é kanakūtsi ntute ña ñaꞌa dɨ. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntáñeꞌe ñá ntaꞌa ña ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kidáā ne, kakaꞌán Juaan ni ña: —Ña túvī nee iña é nīꞌi kó tē ña te Xuva ko táꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tēkú nto loꞌxo mii ntō é kākaꞌán u tsí ña te xuꞌu é Cristú u, ntá tsi xuꞌu diꞌna táxnūu ña ko. ");
INSERT INTO mizNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Xuꞌú ne, vata kaa ña váꞌa tiin niꞌī ña é da vé tántaꞌa kaa u. Dukuān dîni ña da téku ña é kākaꞌan ñá tántaꞌa san. Dukuān dîní ko dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dɨvi ñā ne, kantio é dií ka kaa dukún ka ña. Xuꞌú ne, kantio é nainu xuví u —kaꞌán Juaan. ");
INSERT INTO mizNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ña véꞌxi e dukún kān ne, dií dií ka kaꞌnu ñaꞌa ña é un ntɨꞌɨ ō. Ña véꞌxi ñuxiví a ne, ñuxiví sa kaduku ntée ña. Kakaꞌan ñá iña i é īó ñuxiví sa. Ntá tsi ña véꞌxi e dukún kān ne, dií ka kaꞌnu ñaꞌa ña é un ntɨɨ́ ntɨɨ̄ o. ");
INSERT INTO mizNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kakaꞌan ñá nēe é īni ñá, nēe e téku ña, ntá tsi ña ntákuintiꞌxe ñaꞌa san é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Xoó ñaꞌa, ña é kakuintiꞌxe i é kākaꞌan ñá ne, ini ña tsí nuu é ntaā í kakaꞌan Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ña véꞌxi ntaꞌa Xuva kō ne, kakaꞌan ña túꞌun Xuva kō, tsi kaxéꞌe Xuva kō Espíritu ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dōó kuinima Xúva ko Iꞌxā ñá ne, xéꞌe ñā é kadā kúꞌvē ñá da nēé ka ntɨꞌɨ nuu i. ");
INSERT INTO mizNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Xoo é kākuintiꞌxe i Iꞌxá Xuva kō ne, īó ntuvi vāꞌá iña ña ntii dañu ntúvi. Xoo é ña kakuintiꞌxe i Iꞌxá ña ne, ña túvi ntuvi vāꞌá iña i tsí ntii dañu ntūvi kuéꞌe Xuva kō é ntōꞌo ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kūtuni ñá fariseú san tsí dií ka ntántīkɨn ñaꞌa san Jesuú ne, dií ka tɨtɨ́n ñaꞌa kanakūtsi ntute ña é Juaán; ");
INSERT INTO mizNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","kuān te ñá te mii Jésuu kánakūtsi ntute ñá ñaꞌa san, tsí ña ntɨniꞌi ñā san. ");
INSERT INTO mizNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tēkú Jesuu sáꞌa ne, ntāka ña ñuú Judea, kúnūꞌú xtuku ña ñuú Galilea. ");
INSERT INTO mizNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Dá kuēꞌen ñá itsi kān ne, ítā ntiꞌxin ña ñuú Samaria. ");
INSERT INTO mizNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Xée ña ñūú Sica é kāduku ntée ñuú Samariá san. Ikān tuvi étsin ñúꞌu é xēꞌé Jacoo íña iꞌxá ña Josee. ");
INSERT INTO mizNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ikān tuví pusu é xtûví Jacoo. Dōo kuitá Jesuu, tsí dóo kueꞌe íka ña ne, ínūu daꞌna ña uun xo diñɨ pusú san. E dóko sa káꞌñu ntuvi kídaā. ");
INSERT INTO mizNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Xée uun ñadɨ̄ꞌɨ́, ña ñuú Samaria, é tavā ñá ntute ne, kakaꞌan Jésuu ni ña: —Tāꞌxin kudiin ntuté san na kōꞌó u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Tsí ña ntɨniꞌi ñā ne, kuéꞌen ñā má ñūú san, kukuiín ña é kāꞌxí ña.) ");
INSERT INTO mizNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kakaꞌan ñádɨ̄ꞌɨ, ña ñuú Samariá san, ni Jēsuu: —¿Nté kui xuꞌú ntu kaikan ntó ntute é kōꞌo nto? Tsí xuꞌú ne, ña ñuú Samariá u ne, ntoꞌó ne, ña Israee nto —kaꞌan ña. (Tsí ñá vāꞌá odo niꞌi tāꞌan ña Israeé san nī ña ñuú Samariá ne, ntē ña ntákaꞌan niꞌi taꞌan ñá dɨ.) ");
INSERT INTO mizNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ñá ni ñadɨ̄ꞌɨ́ san: —Tē dɨ́ inin neé kataꞌxi Xúva kō doméni; tē dɨ́ inin xoo ñáꞌa kaikan ñá ntute ne, dɨvīn é kākan ntúte ntaꞌa ña ne, taꞌxi ña ntute é kataꞌxi ntuvi vāꞌá iña o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kakaꞌan ñádɨ̄ꞌɨ́ san ni ñā: —Ntá tsi ña túvi nee iña é tāvá nuu nto ntute san, tsí dóo kūnu pusú san. ¿Míꞌi ntu tāva nto ntute é taꞌxi ntuvi vāꞌá iña kó kuan? ");
INSERT INTO mizNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Vá dií ka kaꞌnu ntu nto é uva ata ko Jācoo? Tsí dɨvi ñā xtúvi ña pusú saꞌá ne, iꞌa xíꞌi ña ntute, ni iꞌxā ñá, ni kɨ̄tɨ ña dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Xoó ñaꞌa é kaxiꞌi ntute sāꞌá ne, da nuu da kuií tsi kaitsi ñá ntute. ");
INSERT INTO mizNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ntá tsi tē xoó koꞌo i ntute é tāꞌxí u ne, nté uun ito ñá ītsí ka ña ntute. Ntute é kuēꞌé u ne, vata kaa mí kakene mii ntūte é kataꞌxi ntuvi vāꞌá iña ña ntii dañu ntúvi, kuan kāa nima ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kakaꞌan ñádɨ̄ꞌɨ́ san ni ñā: —Ún tāꞌxi nto kó ntute tsikán ni, vata koo é ña itsí ka kó ntute ne, ñá kixtāvá ka ú ntute iꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kakaꞌan Jésuu ni ña: —Kunakuekán xɨɨ o ne, dá kīꞌxin xtukun. ");
INSERT INTO mizNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nantíko kōó ñadɨ̄ꞌɨ́ san, kakaꞌan ñá ni ñā: —Xôó xɨɨ ko —kaꞌan ña. Kakaꞌan Jésuu ni ña kídaā: —Váꞌā ó kakaꞌan tsí xoó xɨɨ o. ");
INSERT INTO mizNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tsi é ūꞌun xɨɨ o ne, ña é tuvin niꞌin vevií ne, ñá te xɨɨ mii ō. Nuu é ntaā i é kākaꞌan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kakaꞌan ñádɨ̄ꞌɨ́ san ni ñā: —Dɨvi ntō ne, kutuní ko ve tsí ña é kākaꞌán naa Xuva ko nto. ");
INSERT INTO mizNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tatá viꞌi ntɨ́, ña intóo diꞌna ne, iꞌa kixkaꞌan ntâꞌví ña ni Xuva kō rkɨ ukú saꞌa, ntá tsi dɨvi ntō é ña Israee ntó ne, ntákaꞌan nto é ntio é kɨ̄ꞌɨn o ñuú Jerusaleen é kāꞌan ntâꞌví o ni Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kidáā ne, kakaꞌan Jésuu ni ña: —Na kuīntiꞌxe o é kākaꞌán u ni ō: Tsi véꞌxī ura é ña kiꞌxí ka nto nte íꞌa, nté ñuú Jerusaleen é kaꞌan ntâꞌví nto ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ntē ña ini nto xoo é ntánuu iní nto, ntá tsi ntɨꞌɨ́ ne, iní ntɨ xoo é ntánuu iní ntɨ, tsí tatá Israee véꞌxī ña é nakākú un ntɨꞌɨ ñāꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ntá tsi véꞌxi ntuvi ne, dɨvī é ntoo ō vevií, é ñaꞌa, ña ntánuu iní ntiꞌxe i Xuva kō né, kanɨɨ̄ nima ñá ntikɨ̄n ña é nuu é ntaā i. Ña kuān ntáa san, dɨvi ñā é kanantuku Xuva kō é nanūꞌu ñá iní ña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tsí Xuva kō ne, vata kaa tatsín kaa ña; ña kúvi kīní o ña. Xoó ñaꞌa é ntio ña é kuīnima ntíꞌxe ña Xuva kō ne, ntio é nɨɨ kueꞌén ini ña nanūꞌu ñá iní ña ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kakaꞌan ñádɨ̄ꞌɨ́ san ni ñā: —Ini u tsí kiꞌxi uun ñaꞌa, ña taxnuu Xuva kō, ña é kunanī Cristu. Tē xee ñá ne, dɨvi ña nañēꞌe ñá ko é un ntɨꞌɨ̄ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kakaꞌan Jésuu ni ña kídaā: —Dɨvī san xuꞌu é kākaꞌan níꞌin —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kidáā ne, naxee ñá ntɨniꞌi ñā. Koó dā kúduꞌva ña é kākaꞌan ñá ni uun ñadɨ̄ꞌɨ. Ntá tsi nté uun ñaꞌa ña ña ni kene iní ña é tsixeꞌe ña ñā nté koo, ō nee núu i ntatíin ña ni ñadɨ̄ꞌɨ́ san. ");
INSERT INTO mizNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ikan tsī xtúvi mii ñadɨ̄ꞌɨ́ san xoó ña, dá kūnúꞌu ña má ñūú san, kakaꞌan ñá ni ñāꞌa san: ");
INSERT INTO mizNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Kamá san nto, kixkoto nto uun ñatīi, ña é kākaꞌan ní ko nee ntɨ́ꞌɨ ntɨꞌɨ é idé u. ¿Vá ñā ntu te dɨvi ña é Cristu ña, ña táxnuu Xuva kō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kidáā né, kīi ña, kueꞌen ñá ni ñā mí tuví Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nɨɨ dukuan ña ntɨniꞌi Jēsuú ne, xeꞌe kuétsi ña ñā é kāꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ntá tsi kakaꞌan Jésuu ni ña: —Īo é kāꞌxí u e ñá ini nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ntátsixeꞌe tāꞌan ña: —¿Vá xoó ntu e kíxniꞌi i é kāꞌxí ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kakaꞌan Jésuu ni ña: —É kāꞌxí u ne, dɨvī é kāda ntaa u é ntio ña táxnūu ko, é vīi ntɨ́ꞌɨ ú tsiñu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Vá ñā ntu té xkoó kaꞌan nto: “Kakunaá kɨmi xôo dá taꞌvi ō”? Xuꞌú ne, kakaꞌán u ni ntō: Koto nto itú san, tsi e dóo kakuaan é taꞌvi o vē. ");
INSERT INTO mizNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Xoo é kitaꞌvi i ne, ntuáꞌvi ña; nakuido ña nuu i e dóo nuu áꞌvi i ntii dañu ntūvi. Kidáā ne, ña ntaíꞌxi san kuntoo díni dadɨɨ ña nī ña ntátaꞌvi san te kúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nuu é ntaā í vata xkoó kaꞌan ña tsí uun ña kataꞌxi tatá ne, tuku ña katáꞌvi i. ");
INSERT INTO mizNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","É taxnūú u nto é kitáꞌvi nto mí ña ni ixkúꞌxi nto. Tuku ñaꞌa dé tsiñu ña ne, dɨvi ntō vaꞌá nto tsiñu ña ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ñá te da dīi ña ñuú Samariá san kuíntiꞌxe ña Jesuu kuénta iña i e ntáa ñadɨ̄ꞌɨ́ san ni ñā, dá kakāꞌan ña: “Ña tsīkán ne, kakaꞌan ñá nī ko é un ntɨꞌɨ̄ é idé u diꞌna”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Dā xee ñá ñuú Samaria mí tuví Jesuú ne, tēe koó ña ña é kutuvī ña. Íntoo ña ni ña ūvi ntúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kidáā ne, dií dií ka kueꞌe ñaꞌa san kuíntiꞌxe ña Jesuu kuénta iña túꞌūn é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ntákaꞌan ñáꞌa sán ni ñadɨ̄ꞌɨ́ san: —Ntákuintiꞌxe ntɨ́ ve, ntá tsi ñá te da mii tsī é kākaꞌan ntó nī ntɨ, tsí téku mií ntɨ é kākaꞌan ña. Kūtuní ntɨ tsí dɨvi ntīꞌxe ña ña kixnákaku ñuxiví sa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dā kúvi uvi ntúvi ne, ntaka ña ikān, kúnūꞌú ña ñuú Galilea. ");
INSERT INTO mizNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tsí vata ō kaꞌan míi Jesuú ne, nté uun ñaꞌa, ña kakaꞌán naa Xuva ko ne, ñá tē ntaíko ñuꞌū ña ñuú ña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ntá tsi dā náxee Jésuu ñuú Galileá ne, dōo diní ñaꞌa san é vēꞌxi ña. Tsí da xé ñeꞌe ña ñuú Jerusaleen da kúvi viko sán ne, īní ña nee ntɨ́ꞌɨ ntɨꞌɨ nuu i é idé Jesuu íkān. ");
INSERT INTO mizNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nāxee xtúku Jesuu ñuú Canaa é kāduku ntée ñuú Galilea, mí ntáda ña ntute kuīí san ntute tɨntiꞌo. Ñuú Capernaú san ne, ikān tuvi úun ñatīí, ña kade tsiñu iñá reí ne, ētsin iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Dā téku ña tsí e ntáka Jesuu ñuú Judeá ne, nāxee ña ñuú Galileá ne, kuéꞌen ñā mí tuví ña, kúkoto ñá te kɨ̄ꞌɨn ñá, kintaváꞌa ña iꞌxá ña, tsí dokó sa kúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kakaꞌan Jésuu ni ña: —Tē ña kiní nto nuu i é tāꞌxi kuentá, tē ña kiní nto nuu i e dóo kaꞌnu ne, ñá kuintīꞌxe nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kakaꞌan ñá tsiñu kaꞌnu i iñá reí san ni ñā: —Vií nto da xēꞌe, kɨꞌɨn kúdii nto, tsí dokó sa kúvi iꞌxá ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kidáā ne, kakaꞌan Jésuu ni ña: —Kunúꞌu nto nú viꞌi nto kān, tsí iꞌxá nto ne, kantíto —kaꞌan ña. Kuīntiꞌxe ña tsiñu i san é kākaꞌan Jésuu ni ñá ne, kúnūꞌú ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dā ve tsi kunúꞌu ña itsi kān ne, véxnākuetu itsi ña ntáde tsiñu iña ña. Ntákaꞌan ñá ni ñā tsí kantíto iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kidáā né, tsixeꞌe ña ñā neé ura iñɨ ntúꞌu ntuváꞌa iꞌxá ña. Ntákaꞌan ñá ni ñā: —Iku kaeku uun kuáa ntíko kaꞌni san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kūtuní uva iꞌxá san tsí dɨvi tsi ūra é kākaꞌan Jésuu ni ña tsí kantíto iꞌxá ña. Kidáā né, kuīntiꞌxe ña Jesuu, ni un ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sáꞌa kuvi ūvi núu i e dóo kaꞌnu é idé Jesuu da ntáka ña ñūú Judea, da náxee ña ñuú Galilea. ");
INSERT INTO mizNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Dā kútɨtɨ́n ntuvi ne, īde tuku ña Israeé san viko ne, kúntāa Jesuu ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ikān ne, tuví uun ntóꞌo mí kāñúꞌu ntute etsin Xiꞌi Leꞌntú san é nani Bētseda é tūꞌun hébreu. Īó uꞌun corídoo díñɨ ntute sán ne, ");
INSERT INTO mizNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ñá te da dīi ñá nchokuví san ntoo ña ñuꞌu kān. Iō ñá ne, skuaā ña, xnéꞌē ña, ñá natɨ́ɨn i dɨ́ ne, ntantétu ña neé ura tē kanta nuu ntute san. ");
INSERT INTO mizNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tsí un véꞌxi ne, kakaꞌan ñá é kanainu uun ánjē nú ntūte san ne, kakanta nuu ntūte san. Xoó ñaꞌa é diꞌna nakōꞌxó nuu i kúñu ī iní ntute sán tē kánta ne, ntūváꞌa ña da nēé ka nuu kuíꞌi kakúvi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ikān tuví uun ñatīi é ōko xeꞌun uni kuíā é nchokuví ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iní Jesuu ña mí tuví ntaa ñá ne, kutūni ña tsí ña te dá vevii tuví nteē ñá ikān. Kakaꞌan ñá ni ñā: —¿Ntio ntu o é ntuváꞌan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kakaꞌan ñá natɨ́ɨn i san ni ña: —Xōxó ñaꞌa xntii ī ko é nakīí ntoꞌo kó iní ntute san te kánta ntute san. Dā ve tsi ncho kɨ́ꞌvi ú ne, é tūku ñaꞌa kúnēꞌé ña kūkɨ́ꞌvi ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kakaꞌan Jésuu ni ña: —Nakuiñɨn. Nakíꞌin xuvi o ne, nakakan ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ura tsí i ntuváꞌa ña. Ntaa niꞌi ña xuvi ña ne, nakaka ña. Ntuvi tsikán ne, ntuvi iō dáꞌna. ");
INSERT INTO mizNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Dukuān ne, ntáde tíi ña Israeé san ni ña dā vé ntuváꞌa san: —Vevií ne, ntuvi é ntoo daꞌna ō. Ña kuvi é ntaa niꞌi nto xuvi ntō vevii —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kakaꞌan ñá ni ñā: —Ña é ntaváꞌa kó ne, dɨvi ña kākaꞌan ñá nī ko: “Ntaan niꞌin xuvi o ne, nakakan ve” —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kidáa ne, tsixeꞌe ña ñā: —¿Xoó ntu ñaꞌa kakaꞌan ñá ni ō é na ntaan niꞌin xuvi ō ne, dá nakakan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ntá tsi ña ntuváꞌa sán ne, ñá īni ña xoo ñáꞌa ña ntaváꞌa ña. Tsi Jesuú ne, kīi nteé xio ña méꞌñū ñaꞌa san é ña te da díi ña ntoo ña ikān. ");
INSERT INTO mizNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dā rkontûvi nániꞌi tāꞌan Jesuu ña ini ukún kaꞌnu sán ne, kakaꞌan ñá ni ñā: —Koton ve, tsi é ntuváꞌan. Ñá ku vīín kan é kīni kaa, tsí tē ñáꞌa ne, dií ka kueꞌe kuiꞌi níꞌi o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ñatīí san ne, ntāka ña, kueꞌen ña, kakaꞌan ñá ni ñā Israeé san tsí Jesuu náni ña é ntaváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Dukuān ne, íntīkɨn nuu iní ña Israeé san Jesuu. Ncho kaꞌní ña ña, tsí idé ña sáꞌa ntuvi é iō dáꞌna. ");
INSERT INTO mizNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ntá tsi kakaꞌan Jésuu ni ña: —Uvā kó ne, kade tsiñu ña un tsi nte vevií ne, dukuān é xūꞌú ne, kade tsiñu ú dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Dukuān ne, dií dií ka ncho kaꞌní ña Israeé san ña. Ñá te da mii tsī é ña ni de ntáa ña é kūtuví daꞌna ña ntuvi dá iō dáꞌna, tsí da xé kakaꞌan ña tsí Xuva kō né, dɨvi ñā é uva mii ñā ne, kade ña tsí dadɨɨ ña ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kidáā ne, kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō: Ña kúvi neé vii u é kuenta iña mií ko, xuꞌu é Iꞌxā ñá ko. Tsi dá miī é viī ú vatā ó de Uvā ko. Da nēé ka nuu i é kade ña ne, dɨvi tsī kade ú dɨ, xuꞌu é Iꞌxā ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tsi dóo kakuinima Úvā kó ko, xuꞌu é Iꞌxā ñá ko ne, kanañēꞌe ñá ko é un ntɨꞌɨ nuū i é kāde ña. Nuu i é dií dií ka naꞌnu nañēꞌe ñá ko vata koo é un tsi kudūꞌva nto. ");
INSERT INTO mizNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Vatā ó de Uvā kó é kanantōto ña ña xiꞌí san ne, vata ō kaxeꞌé ña ntuvi iña ñá ne, kuān o táꞌxi ña kó dɨ é kūvi vií u kuéꞌē ú ntuvi iña i dá xōó ka tsi é ntio ko. ");
INSERT INTO mizNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ñá te mii Uvā kó é kāꞌan ñá xoo é váꞌa i, xoo é ña váꞌa i, tsi é naxnuu ntaꞌa ñā ko é xūꞌu vií u sáꞌa, ");
INSERT INTO mizNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","vata koo é kuan tsi koo kuiko ñuꞌu ntō kó xuꞌú vatā o ntaíko ñuꞌu nto Uvā ko. Xoo é ña kaíko ñuꞌu ī kó ne, ñá te kaiko ñuꞌu ña Uvā kó dɨ, tsí dɨvi ñā é táxnūu ña ko. ");
INSERT INTO mizNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ʼNuu é ntaā i é kākaꞌán u ni ntō: Xoó ñaꞌa, ña é katekú i túꞌūn kó ne kakuintiꞌxe ña ña táxnūu kó dɨ ne, níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi. Ñá nīꞌi ña é ntōꞌo ña. Tsí é itā ntíꞌxin doxiꞌí san iña ñá ne, e níꞌi ña ntuvi vāꞌá iña ñá ve. ");
INSERT INTO mizNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nuu é ntaā i é kākaꞌán u ni ntō tsi véꞌxi ūra ne, e xéē vevii, é tēkú un ntɨɨ́ ntɨ̄ɨ ña xiꞌí san tatsín ko, xuꞌu é Iꞌxá Xuva kō u. Xoó ñaꞌa é kaeni tutun ñá ne, níꞌi ña ntuvi vāꞌá iña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tsí vata tsi kaa Uvā ko, é īó ntuvi iña mii ñá ne, kuan tsi ō táꞌxi ña ko é kōo ntuvi iña mií ko dɨ, tsí xuꞌu é Iꞌxá mii ñā né, ");
INSERT INTO mizNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","tāꞌxi ña ko é kadā kûꞌvé u é un ntɨꞌɨ īña ñaꞌa, tsí xuꞌu é vēxkúvī ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ñá ku da kudūꞌva nto é kākaꞌán u sáꞌa, tsí xee úra i é un ntɨꞌɨ̄ ña xiꞌí san tekú ña tatsín ko. ");
INSERT INTO mizNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Kidáa ne, ntii ñā nú ñaña ñā. Xoó ñaꞌa é ēdé ña é vāꞌá ne, ntoto ña é nīꞌi ña ntuví vaꞌá iña ña. Ntá tsi xoo ñáꞌa é ēdé ña é kīni kaa ne, ntoto ña é nīꞌi ña dôꞌvi kan. ");
INSERT INTO mizNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ʼÑa kúvī nee iña é vii ú kuenta iña mií ko. Vata tsī o tékū ko é kākaꞌan Úvā kó ne, kuan tsī ó kade kûꞌvé u dɨ́ ne, váꞌa tsī ó e kade kûꞌvé u, tsi ñá te kuēnta iña mií ko kade u, tsí kuenta iña Xuva ko, ña táxnūu ko. ");
INSERT INTO mizNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ña kúvi ntantaa u iña mií ko, tsí ña kaidiáꞌvi. ");
INSERT INTO mizNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ntá tsi iō ña é ntantaa ña kuenta iñá ko. Iní u tsí kakaꞌan ñá nee iña é nuu é ntaā i iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ntoꞌó taxnūu nto ña é tsixeꞌē Juaan iñá ko ne, nee iña é nantíko koō ñá ne, nuu é ntaā i. ");
INSERT INTO mizNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ntá tsi ña káde ú kuenta é kākaꞌan ñáꞌa san iñá ko. Da ti tsi kakaꞌán u ni nto sāꞌá vata koo é kūvi nakáku nto. ");
INSERT INTO mizNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juaán ne, vata kaa ñuꞌu é kaiꞌxí ne, kaxiꞌí nuu ne, dōo diní nto é kuntōo daꞌna nto mí kāxiꞌí nuu ñuꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ntá tsi īó xoo é ntāda ntaa í iñá ko é dií ka nuu áꞌvi ka é vāta kaa é kāꞌán Juaan. Tsí tsiñu é kade ú vevií ne, mii tsī é kāntada ntaa é Uvā kó xnúu ntāꞌa ña ko. ");
INSERT INTO mizNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tsí Uvā kó, ña e táxnūu kó ne, mii ña kāntada ntaa ñá iñá ko. Nté uun ito vata téku nto tátsin ña. Ntē vata kiní nto ña nté kaa ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ntē ña ni kánūu nima ntó túꞌun ñā dɨ. Tsí ña ni kuīntíꞌxe nto ña táxnuu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Dōo váꞌā ó ntánakuaꞌa váꞌa nto túꞌun Xuva kō é ūve naꞌa vata koo é nīꞌi ntó ntuví vaꞌá iña ntó ntii dañu ntūvi, kuiní nto. Dɨvī kuenta iñá ko é ūve naꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ntá tsi ñá ntio nto kuntīkɨn ntó ko vata koo é nīꞌi ntó ntuví vaꞌá iña nto. ");
INSERT INTO mizNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ʼXuꞌú ne, ñá te kantukū u é kada kaꞌnu ñaꞌa sán ko. ");
INSERT INTO mizNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ntá tsi xuꞌú ne, iní u nto ne ñáꞌa nto é ña te ntákuinima ntíꞌxe nto Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Xuꞌú ne, véꞌxī ú kuenta iña Uvá ko ne, ña ntío nto é kutūví u ni ntō. Ntá tsi te tūku ñáꞌa kiꞌxi ña kuenta iña mii ñá ne, kidáā né, xtuvī ntó ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Nté ntu koo kuintiꞌxe nto ve? Tsí kūdii ntáde naꞌnu mii xnto tāꞌan nto, ntá tsi ña ntáde nto kuenta te kaꞌan Xúva kō tsi dóo vaꞌá nto. ");
INSERT INTO mizNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ñá ku dē kuení nto te xūꞌú tsiꞌi kuétsi ú nto nuu Uvá ko, tsí mii Muīseé san, ña ntántīkɨn nto. ");
INSERT INTO mizNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tsí tē dɨ́ ni kuīntiꞌxe nto é kākaꞌan Muíseé ne, kuintiꞌxe nto kó dɨ, tsí dɨvi kuēnta iñá ko é kāꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ntá tsi tē ña kuintíꞌxe nto e xntée naꞌa ñā ne, ¿nté ntu koo kuintiꞌxe nto túꞌūn kó kuan? —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Dā kúvī sáꞌā ne, Jesuú ne, kuéꞌen ña xīo diñɨ míni Galīlea, dɨ́vi tsī é kākaꞌan ña é Tiberiá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ñá te da dīi da díi ñáꞌa san ntántīkɨn ñá ña, tsí da xé īni ña nuu i e dóo kaꞌnu é kade ña, tsí kantaváꞌa ña ña ntánchokuví san. ");
INSERT INTO mizNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kúxēe Jesuu rkɨ́ ukú ne, da intóo daꞌna ña ni ña ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","E dokó sa xée ētsin viko é nátava Xuva kō ña Israee ñuú Egítō, viko é kanatsuꞌun kaꞌnu ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Dā xkókoto Jesuú ne, īní ña tsí ña te da díi ñaꞌa ntántīkɨn ñá ña ne, kakaꞌan ñá ni Fēlipe: —¿Míꞌi ntū kíkuiin o é kāꞌxí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Da ti tsi kakaꞌan ña é ntio ña é kōto nteé ña Felipe nté koo kaꞌan ña. Tsí ini míi ñā nté koo vií ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kakaꞌan Félipe ni ña: —Ntē ña xee táꞌan é ūvi sientu âꞌví tañúꞌu kuiin ō é kāꞌxi un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, kuān té un síin —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Uun ñaꞌa ña ntɨniꞌi ñā, ñá nani Āndree, ení Simuun Pedrú ne, kakaꞌan ñá ni ñā: ");
INSERT INTO mizNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Iꞌa ntitsí uun na kudii, na é niꞌi úꞌūn tañúꞌu sēvada ni úvi tsákā san, ntá tsi ¿nté ntu koo vii o sáꞌa é ña te da díi ñaꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kidáā ne, kakaꞌan Jésuu: —Káꞌan nto ni ñāꞌa sán, na kūntoo ña —kaꞌan ña. Tsi dóo váꞌā o nú ité san ne, ikan īntóo ña, vata ūꞌun míil é da mii tsi ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kidáa ne, kīꞌi Jesuu tañúꞌū sán ne, dā nakuéꞌe ña sintiáꞌvi ntaꞌa Xuva kō. Kātsin dava ñá, dā tsíꞌi ña ntaꞌa ñaꞌa san, ña ntoo nú īté san. Kuan tsī o dé ña nī tsákā sán dɨ. Xéꞌe ñā vata kaa e kutíi ñaꞌa san é kaꞌxí ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dā kúvi éꞌxi ntāꞌa ñá ne, kakaꞌan Jésuu ni ña ntɨníꞌi ñā: —Nakuido nto utsi i é ntoó ka vata koo é ña te neé kate —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nākuido ña é ntoó ka ne, uxúvī ká xika útsi tañúꞌū san kúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kidáa ne, dā íni ñaꞌa san nuu i e dóo kaꞌnu é idé Jesuú ne, ntákaꞌan ña: —Nuu é ntaā i tsí ña sāꞌá ne, dɨvi ñā é kākaꞌán naa Xuva ko, ña é kīꞌxí ñuxiví a —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ntá tsi Jesuú ne, kūtuni ña tsí ntio ñaꞌa san ña é kueꞌe kuétsi ña ña é viī ñá rei. Kidáā né, kīi nteé xio ña ñaꞌa sán ne, dā kuntáa xtuku ña rkɨ uku, mí kutuvī mii ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dā kuáā ne, kúntīí ña ntɨniꞌi Jēsuu nú ntūte san. ");
INSERT INTO mizNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kidáā ne, ñúꞌu ña īní tun ntōó san ne, īñɨ ntúꞌu ita ntíꞌxin ña méꞌñū ntute san é kɨ̄ꞌɨn ñá ñuú Capernau. É dōo kúneé ne, váta xēe Jesuu mí ñūꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kidáā né, dōo ido ntúte san, tsi dóo ntii kainu tatsin. ");
INSERT INTO mizNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dā ku íka tun ntōó san te ūꞌún ne, o īñu kilumétru ne, īní ña Jesuu é vēꞌxí ña dɨ́ꞌɨn ña, kaika ña nú ntūte san. Dā xee étsin ña nú tun ntōó san ne, dōo úꞌvī ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ntá tsi kakaꞌan Jésuu ni ña: —Ñá ku uꞌvī nto, tsí xuꞌu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kidáā né, dōo diní ña tsí kūxée Jesuu iní tun ntōó san ne, ura tsí xee ñá diñɨ ntute san mí kɨ̄ꞌɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Dā tuví teváā sán ne, ña ñuꞌu uun xo diñɨ ntute sán ne, kūtuni ñá tsí ña ntɨniꞌi Jēsuú ne, ntāka ña dɨvi tsi tun ntōó san ntíko kōo niꞌi ña, ntá tsi ña ni ñéꞌe Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nɨɨ̄ dukuan ntánaxee tun ntōo é vēꞌxí ñuú Tiberia, etsin mi éꞌxi ña tañúꞌū é nakuéꞌe Tóꞌo kō sintiáꞌvi ntaꞌa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Dā íni ñaꞌa san tsí xoxó Jesuu ni ña ntɨníꞌi ñā ne, nakúꞌun ña tun ntōó san, kueꞌen ña ñuú Capernau, kúnantúku ña Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Dā nániꞌi taꞌan ña uun xo diñɨ ntúte sán ne, tsixeꞌe ña ñā: —Mastrú, ¿nté ntu ō xee ntó iꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kidáā ne, kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u tsí da ti tsi ntánantuku ntō ko tsí da xe táꞌxi ú e éꞌxi ntaꞌā nto, ntá tsi ntē ña te ni ñéꞌe dɨkɨ nto nuu i e dóo kaꞌnu e íni nto é idé u. ");
INSERT INTO mizNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ñá ku kada tsīñu nto é nīꞌi nto tañúꞌū é kantɨ́ꞌɨ te kāꞌxi o. Kada tsiñu nto vata koo é nīꞌi nto tañúꞌū é kataꞌxi ntuvi vāꞌá iña nto ntii dañu ntúvi, tsí kaxntiī. Táñūꞌú saꞌá taꞌxi ú, xuꞌu é vēxkúvi ú ñatīi, tsí e xntée Uvā kó ko seu ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kidáā ne, tsixeꞌe ñāꞌa san ña: —¿Ntē ntú koo kada tsiñu ntɨ́ vatā ó ntio Xuva ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nantíko kōó Jesuu, kakáꞌan ña: —Sáꞌa tsīñu é ntio Xuva ko é viī nto: Na kuīntiꞌxe nto ña táxnūu ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kidáa ne, tsixeꞌe ñā: —¿Neé ntu nuu i nañéꞌe ntó ntɨ vata koo é kuīntiꞌxe ntɨ́ nto tē íni ntɨ? ¿Neé ntu nuu i e dóo kaꞌnu vií nto? ");
INSERT INTO mizNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Uva ata ika kō ne, éꞌxi ña é nani mānaa ñuu itsí kān. Tsí vatā ó uve naꞌa kakáꞌan é Xuva kō ne, xéꞌe ñā tañúꞌū é vēꞌxí e dukún kān é kāꞌxí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kidáā ne, kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō: Ñá te Muīsee ni taꞌxi ña tañúꞌū é vēꞌxí e dukún kān, tsí mii Uvā kó táꞌxi ña tañúꞌū é nuu é ntaā i é vēꞌxí e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tsí tañúꞌū é kataꞌxi Xuva kō né, dɨvī é vēꞌxí e dukún kān, é kataꞌxi ntuvi vāꞌá iña ña ñuxiví sa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ntákaꞌan ñá ni Jēsuu: —Tāꞌxi nto ntɨ́ tañúꞌu tsīkan utén utén ni —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kidáā ne, kakaꞌan Jésuu ni ña: —Xuꞌu e kúvi ú tañúꞌū é taꞌxi ntuvi vāꞌá iña nto. Xoó ñaꞌa, ña é kuntīkɨn í ko ne, nté uun ito ká ña kakɨn ña. Xoó ñaꞌa, ña é kakuintiꞌxe i kó ne, nté uun ito ka ña ítsī ñá ntute dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ntá tsi vatā ó kakaꞌán u ni ntō é kuān té ini ntó ko ne, ntá tsi vata kuintíꞌxe nto ko. ");
INSERT INTO mizNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tsí un ntɨꞌɨ ñā é kataꞌxi Uvā kó ne, ntaꞌa kó xee ña. Xoó ñaꞌa, ña é kantīkɨ́n ko ne, nté uun ito ña kiñūꞌu ú ña kíꞌi kān. ");
INSERT INTO mizNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tsi véꞌxi ú e dukún kān é vīí u vatā ó ntio ña é taxnūu ko, ñá tē dɨkɨ tsi mií ko vií u. ");
INSERT INTO mizNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Sáꞌā táꞌxi ña é vīí u: é ña nakunáa u nté uun e xnúu ntaꞌa ñā ko, tsí nantōto ntɨꞌɨ ú ña ntuvi te ntɨ́ꞌɨ ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tsí Uvā ko ntio ña é na kīní un ntɨꞌɨ ñāꞌa sán ko, xuꞌu é Iꞌxā ñá ne, na kuīntiꞌxe ña ko. Níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi ne, nantōtó u ña ntuvi te ntɨ́ꞌɨ ñuxiví sa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Dukuān ne, káꞌan ntēé ña Israeé san ña, tsí kakaꞌan ña é dɨvi ñā kúvi ña tañúꞌū é vēꞌxí e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ntákaꞌan ñáꞌa san: —¿Vá ña ntu te ña sāꞌa é Jēsuu, iꞌxá Josee? Tsí ini o úva ña ni dɨꞌɨ ñā. Dá kakāꞌan xkú ña tsí e dukún kan vēꞌxí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dukuān ne, kakaꞌan Jésuu ni ña: —E xée ō tsí kaꞌan ntée nto kó ni tāꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Xoxó kuvi kuntīkɨ́n i ko tē ña te Uvá ko táxnuu ña i, vata ō táxnuu ña kó dɨ ne, nantōtó u ña ntuvi te ntɨ́ꞌɨ ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tsí vatā ó uve naꞌa kakaꞌan ña kaꞌán naa Xuva ko: “Mii Xuva ko nañēꞌe ña un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san”, kaꞌan ña. Dukuān né, dā xóo ká ñaꞌa, ña é kateku í ña, é kakutúꞌve i é kākaꞌan Úvā kó ne, kantīkɨn ñá ko dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ʼNté uun xoxo vata kiní i Uva kō. Mii tsī u é vēꞌxí u ntaꞌa ña é īní u ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nuu é ntaā i é kākaꞌán u ni ntō tsí xoo ñáꞌa, ña é kuintiꞌxe i kó ne, níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Xuꞌu é tañúꞌū é taꞌxi ntuvi vāꞌá san. ");
INSERT INTO mizNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tsí uva ata ika ntō ne, eꞌxí ña manaa ñuu itsí kān né, dā dúkuan tsi xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ntá tsi xoo ñáꞌa, ña é kāꞌxí i tañúꞌū é vēꞌxí e dukún kān ne, ña kúvī ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Xuꞌu kúvi ú tañúꞌū é kāntíto é vēꞌxí e dukún kān. Xoó ñaꞌa, ña é kāꞌxí tañúꞌu sāꞌá ne, níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi. Táñūꞌu é tāꞌxi ú ne, kūñú miī kó kúvi. Taꞌxí u kúñū ko é nīꞌi ña ñuxiví sa ntuvi iña ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kidáa ne, tsixeꞌe tāꞌan ña Israeé san, ntákaꞌan ña: —¿Ntē ntú koo taꞌxi ña sāꞌa kúñu ñā é kāꞌxi o, é kuān ó kakaꞌan ñá sa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō: Tē ña káꞌxi nto kúñū ko, xuꞌu é vēxkúvi ú ñatīí, tē ña koꞌo nto nɨ́ñɨ́ ko dɨ́ ne, ña túvi ntuvi vāꞌá iña nto. ");
INSERT INTO mizNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tsí xoo ñáꞌa, ña é kāꞌxí kúñū kó, nī ña é kōꞌo nɨñɨ́ ko ne, níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi ne, nantōto ú ña ntuvi tē ntɨ́ꞌɨ ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tsi kúñū kó ne, ita ntíꞌxe nto kuvi; nɨñɨ́ ko ne, ntute ntiꞌxe nto kúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xoo é kāꞌxí i kúñū kó, nī é kōꞌo nɨñɨ́ ko ne, nuu ña nimá ko ne, nuu ú nima ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Uva kō, ña táxnūu kó, īó ntuvi iña ña. Dukuān né, īó ntuvi iñá ko kuenta iña ña. Xoo é kāꞌxí i kúñū kó ne, níꞌi ña ntuvi vāꞌá iña ñá kuenta iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kakaꞌán u kuenta iña tañúꞌū é vēꞌxí e dukún kān. Táñūꞌú saꞌá ne, ñá te vāta kaa manaa e éꞌxi ñata ntō, ña intóo kídaā, tsí dā dúkuan tsi xiꞌi ña. Ntá tsi xoó ñaꞌa, ña é kāꞌxi tañúꞌū saꞌá ne, níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sáꞌa kākaꞌan Jésuu dá nañéꞌe ña ña Israeé san má viꞌī mí ntánataká nuu ña ñuú Capernau. ");
INSERT INTO mizNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dōó tɨtɨ́n ña ntántīkɨn ñá ne, dā téku ña sáꞌa ne, ntákaꞌan ña: —Dōo viꞌxín ō túꞌūn saꞌa. ¿Xoó ntu kutií i é kɨꞌɨn dɨkɨ i? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kūtuni Jésuu tsí ña ni xkúntee iní ña é kākaꞌan ñá ne, kakaꞌan ñá ni ñā: —¿Ñá xkúntee iní ntu nto é kākaꞌán u san? ");
INSERT INTO mizNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ntē ntú koo kuvi tē íni nto ko, xuꞌu é vēxkúvi ú ñatīí, te kūntáa u e dukún kān míꞌī e dúkuān tuví u? ");
INSERT INTO mizNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tsí Espíritū sán ne, dɨvi ñā é kātaꞌxi ña ntuvi iña ko. Ña kuntīto ó te da mii tsī kúñu kō. Tūꞌun é kākaꞌán u ni nto ne, dɨvī é vata kaa espíritū é kataꞌxi ntuvi vāꞌá iña nto. ");
INSERT INTO mizNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ntá tsi iō ntó ne, ña ntákuintiꞌxe nto é kākaꞌán u —kaꞌan ña. Tsí iní Jesuu nte díꞌna xoo é kuintíꞌxe i ña ne, xoo é nadíko i ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kakaꞌan ña: —Dukuān é kākaꞌán u ni nto dīꞌna tsí xoxó kuvi kuntīkɨn í ko tē ña te Uvá ko táꞌxi ña i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nté ntūvi tsikán ne, dōó tɨtɨ́n ña ntántīkɨn ña, kii nteé xio ña ña. Ñá nī kántīkɨ́n ka ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kidáā né, tsixeꞌe Jēsuu ña é uxuvi ñáꞌa, ña ntántīkɨn ña: —¿Ncho kɨꞌɨn ntú nto dɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nantíko kōó Simuun Pedru, kakáꞌan ña: —Xoó ka ntu é kuntīkɨ́n ntɨ, tsi túꞌun ntō né, dɨvī é kataꞌxi ntuvi vāꞌá iñá ntɨ ntii dañu ntūvi. ");
INSERT INTO mizNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ntɨꞌɨ́ ne, é kuīntiꞌxe ntɨ, é īni vaꞌá ntɨ dɨ tsí dɨvi ntō é Cristu nto, ña e dóo vaꞌá nuu Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kakaꞌan Jésuu ni ña: —¿Vá ñā ntu te ni nakaxnúu ú nto, é uxuvi ñáꞌa nto? Ntá tsi uun ñaꞌa ntō ne, e ña váꞌa kúvi nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kakaꞌan ñá iña Júda Iscariote, iꞌxá Simuun. Tsí dɨvi ñā é diko ña Jēsuu rkontûvi, kuān té kaduku ntée ña uxuvi ñáꞌa, ña ntɨniꞌi ñā san. ");
INSERT INTO mizNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Dā kúvī sáꞌā ne, īka Jesuu ñuú Galilea. Ñá ni ntīo ká ña kɨ̄ꞌɨn ña ñuú Judeá san, tsí ncho kaꞌní ña Israeé san ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Dóko sā xee ntúvi e ntáde ña Israee víko é kāñúꞌu ña viꞌi xoꞌo. ");
INSERT INTO mizNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Dukuān ne, ntákaꞌan éní Jesuu ni ña: —Ñá ku kutūvín iꞌa. Kuēꞌén ñuú Judea vata koo é na kīní ña ntɨniꞌi ō san núu ī é kaden. ");
INSERT INTO mizNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tsí te xōo ñáꞌa ntio ña é kutuvī ditó ña ne, ñá tē neé ka vii xuꞌú ña. Tē ncho viin nuu i e dóo kaꞌnu ne, kuēꞌen mí kīní ñaꞌa san o é da kanɨɨ ñūxivi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nté enī ñá ña ni kuintíꞌxe ña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kidáā ne, kakaꞌan Jésuu ni ña: —Váta xēe ura iñá ko, ntá tsi dɨvi ntō ne, kuvi vií nto da nēé ka ura nee iña é ntio nto vii nto. ");
INSERT INTO mizNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ñá te nēe nuu i kainchuꞌvi ñáꞌa nto. Ntá tsi xuꞌú ne, dōo ntaínchuꞌvi ñá ko, tsí da xé kakaꞌan ntáa ú ni ñā nee é kīni kaa ntáde ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kueꞌēn ntó viko san. Xuꞌú ne, ñá kɨ̄ꞌɨ́n u vevii, tsí vata xee úra iñá ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Dā kúvi kaꞌan ña sáꞌa ni ñā ne, ítūví ka ña ñuú Galilea. ");
INSERT INTO mizNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ntá tsi dā kueꞌen éní ña viko sán ne, da rkontûvi kíi ña, kueꞌen ñá dɨ. Ntá tsi ña ni ñeꞌe ditó ka ña, tsí diin diin sá kueꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ntánantukū ña Israeé san ña mí kakuvi viko sán ne, ntákaꞌan ña: —¿Míꞌi ntū tuví ñatīi tsíkan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Dōo ntákaꞌan ñáꞌa san kuénta iña ña. Iō ñá ne, ntákaꞌan ña: “Ñatīi tsikán ne, dōo vaꞌá ñaꞌa ña.” Iō ñá ne, ntákaꞌan ña: “Ñaꞌá ni san. Kūdii kaéni ntaꞌví ña ñaꞌa”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ntá tsi xoxó ni kāꞌan ntée i ñā méꞌñu ñāꞌa san, tsí uꞌví ña ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Dā kúdava viko sán ne, kúkɨ̄ꞌví Jesuu íni ukún kan, eni ntuꞌu ñā nañéꞌe ñá ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Koó dā kúduꞌva ña Israeé san, ntákaꞌan ña: —¿Nté kuān nte íni ntú ña sāꞌa? Tsí ntē ña ni nakuáꞌa ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kidáā ne, nantíko kōó Jesuu, kakáꞌan ña: —É kanañēꞌé u ntó ne, ñá te dɨ̄kɨ mií ko kakiꞌxi, tsí iña ña táxnuu ko. ");
INSERT INTO mizNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tē xoó ntio i é viī i é ntio Xuva kō ne, kutuni ñá te ntaꞌa Xuva ko vēꞌxi é kanañēꞌé u san, o te dɨkɨ mií ko katavá u. ");
INSERT INTO mizNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Xoo é katavá i dɨkɨ mií i é kākaꞌán ne, da ti tsi kanantuku ñā é vāꞌá iña mii ña. Ntá tsi xoo é kanantuku ī é vāꞌá iña ña táxnuu i ne, kakaꞌan ña é nuu é ntaā i. Ñá tē nee iña é kīni kaa nuu nima ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ʼ¿Vá ña ntu te dɨvi ntō e táꞌxi Muisee lei? Ntá tsi nté uun nto ña ntáde ntaa nto é ūve naꞌa. ¿Nté kui ntánantukū nuu iní ntu nto nté koo kaꞌní nto ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ntákaꞌan ñáꞌa san: —¡Vá ña váꞌa ntu nuu nima o! ¿Xoó ntu ncho kaꞌní i o? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Uun kudii núu i é idé u ne, un tsi da ntákuduꞌva nto. ");
INSERT INTO mizNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muiseé ne, náñēꞌe ñá nto vatā xkoó ini nto é tēꞌnté un siin kúñū é īxi nto. (Ntá tsi ña te Muísee ni xtuví ña kuān xkoó ini nto, tsí uva ata ika kō, ña intóo nte kidaa.) Ntōꞌó ne, kuān te ntuvi íō dáꞌna, kaeꞌnté nto é īxi íꞌxa tií san. ");
INSERT INTO mizNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tē kuvi teꞌnte é īxi íꞌxa tií san ntuvi é iō dáꞌna vata koo é kāda ntaa nto lei Muíseé ne, ¿nté kui ntákudiin ntu nto ní ko e ntaváꞌa ú ñatīí san kanɨɨ̄ kúñu ñā ntuvi dá iō dáꞌna? ");
INSERT INTO mizNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ñá ku kāꞌan ntée nto ñaꞌa san dá dotō tsí ntaíni nto ña, ntá tsí te kāꞌan ntó iña ñaꞌá san ne, koto váꞌa nto nee iña é ntákaꞌan nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Īó ña ñuú Jerusaleén san éni ntuꞌu ñā tsíxeꞌe taꞌan ñā: —¿Vá ña ntu te ñá sāꞌa é ntánantuku ñāꞌa san é kaꞌnī ñá ña? ");
INSERT INTO mizNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Un kaa ña ntitsi ña, kakaꞌan ñá ni ñāꞌa san, ntá tsi nté xoxo kakaꞌan í ni ñā. ¿Tē kuiní ntu ña tsiñu i san é dɨvi ntīꞌxe ña é Cristu ña? ");
INSERT INTO mizNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Xoꞌō ne, ini ntú ku ō míꞌi vēꞌxí ña sāꞌa. Tsí te vēꞌxí Cristú ne, nté uun xoxó ini i míꞌi kii ña te vēꞌxí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kidáā ne, un ntii tsī kéne Jesuu, kakáꞌan ña mí kanakuāꞌa ña ñaꞌa san ini ukún ña Israee: —Te īni ntó ko ne, ini nto míꞌi vēꞌxí u. Ntá tsi ña te ni kiꞌxí u é miī ú ntio ko, tsí ña kakaꞌan é nuu é ntaā i san táxnūu ña ko. Ntoꞌó ne, ntē ñá ini ntó ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ntá tsi xuꞌú ne, iní u ña, tsi íkan vēꞌxí u mí tuví ña ne, dɨvi ñā e táxnūu ña ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kidáā né, ncho tɨɨn ña ña, ntá tsi nté uun xoxo ni tɨɨn ntáꞌa i ña, tsí vata xee táꞌan ura íña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ntá tsi ña te da díi ña kuíntiꞌxe i ña ne, ntákaꞌan ña: —Tē xee ñá táxnuu Xuva kō ne, ¿vá kūvi ntu vií ña e dií ka kueꞌe núu ī e dóo kaꞌnu vatā ó de ña sāꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tēkú ña fariseu e ntákaꞌan ñáꞌa san íña Jésuu. Ña fariseu ni dútu ñá odo nūú san ne, tēé tsiñu ña ña mau ukun é tɨ̄ɨn ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kidáā ne, kakaꞌan Jésuu ni ña: —Uun daꞌna sá kutūví u ni ntō dá ntāa ú, kínakutúvi ú nī ña táxnūu ko. ");
INSERT INTO mizNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Dōó nantuku ntō ko, ntá tsi ña naníꞌi ntó ko. Ntē ña kuvi xée nto mí kíkutúvi u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kidáā né, ēni ntuꞌu ña Israeé san ntátsixeꞌe taꞌan ñā: —¿Míꞌi ntu ntēe kíkutúvi ña sāꞌa é ña kuvi naníꞌi ko ña? ¿Vá kɨ̄ꞌɨn ntú ña xio ñuú san mí kaintóo xaa tātá ña Israeé? ¿Vá ikan ntu kɨ̄ꞌɨn ña, kinakuáꞌa ña ñaꞌa, ña é ña ntákuintiꞌxe i Xuva kō san? ");
INSERT INTO mizNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nee iñá ntu kani túꞌun é kākaꞌan ña: “Nantuku ntō kó, ntá tsi ña naníꞌi ntó ko, tsi ña kúvi xēe nto mí kutūví u”? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ntuvi da īnú kava viko kaꞌnu sán ne, nákuntītsí Jesuu, kakáꞌan ña: —Tē xoo é kaitsi i ntúte ne, na kīꞌxi ña mí tuví u, na kōꞌo ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tsí vatā ó uve naꞌa kakaꞌan Túꞌun Xuva kō ne, xoo é kuintiꞌxe i kó ne, nima ñá kene ntute vāꞌa é ña katúꞌu nté un síin —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kakaꞌan ñá kuenta iña Espíritū Sántū é kunūu ña nima í xoo é kuintíꞌxe i ña. Tsí vata taꞌxi Xúva kō Espíritū Sántū san, tsí vata ntáa Jesuu e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Īó ñaꞌa san, da téku ña é kākaꞌan ñá ne, ntákaꞌan ña: —Ña sāꞌá ne, ña kaꞌán naa Xuva ntíꞌxe ko ñā, ña kakaꞌan túꞌun Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Iō ñá ne, ntákaꞌan ña: —Ña sāꞌá ne, Cristu ña —kaꞌan ña. Ntá tsi iō ñá ne, ntákaꞌan ña: —¿Vá ñūú Galilea ntú sa kiꞌxi Cristu? ");
INSERT INTO mizNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Ñā ntu te uve náꞌa kakáꞌan tsí Cristú ne, tatá viꞌi Davii ña? Kiꞌxi ña ñuú Beleen, tsí ikan ñūú Davii —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Dukuān ne, kii nteé xio ñaꞌa san kuénta iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iō ñá ne, ncho kɨꞌɨn niꞌi ñá ña viutun, ntá tsi nté uun ña ña ni kene iní ña tɨ́ɨn ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nāxee mau ukun mí ntoo dutu ñá odo nūú nī ña fariseú san ne, tsixeꞌe ña māu ukún san: —¿Nté kui ña ni kántēka ntu nto ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Máu ūkún san ne, nantíko koō ñá, kakaꞌan ña: —Nté uun ito vata tekú ntɨ xoó kakaꞌan í vatā ó kakaꞌan ñá tsikan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kidáā ne, ntákaꞌan ñá fariseú san ni nā: —¿Vá éni ntaꞌví ntu ña nto dɨ? ");
INSERT INTO mizNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Vá ntákuintiꞌxe ntu ña odo nūú iña nto nī ña fariseú san? ");
INSERT INTO mizNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ntá tsi ñaꞌa, ña e ñá īní leí san ne, da miī é nīꞌi ña é kuntēka é kīni kaa ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemu, ña é ixkoto níꞌni Jesuu dá kuáā ne, ña fariseu ñá dɨ ne, kakaꞌan ñá ni tāꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Vá kakaꞌan ntu leí san é dotō tsi dáꞌvi o kuētsí kaꞌnu ñaꞌa san te vata kiní o nee iña é kade ña, tē nté ō kakaꞌan ñá dɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nantíko koō ñá, ntákaꞌan ña: —¿Vá ña Galilea ntú nto dɨ? Nākuaꞌa ixi nto é ūve naꞌa é kākaꞌan Xúva kō, tsí ñuú Galileá san ne, nté uun ñaꞌa é kaꞌán naa Xuva ko vata túvi ditó ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kidáā né, nādita ña itsi ña xe un xé un ñā, kunúꞌu ñā nú viꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ntá tsi Jesuú ne, kuéꞌen ñā tɨꞌɨ i má Tun Ōlivu kan. ");
INSERT INTO mizNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Dā tuví utun sán ne, nee xtúku ña má ūkún kān. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa xee xtúku ña mí tuví ña. Ítūvi tɨxɨ ñá ne, dá kanakuāꞌa ña ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mastrú lei ni ñá fariseú san ne, xée ñā mí tuví Jesuú ne, nteka ña uun ñadɨ̄ꞌɨ, ña é natúvi, ña é nuu niꞌi uun ñatīi é ña te dɨvi xɨɨ ña. Xntitsī ñá ñadɨ̄ꞌɨ́ san méꞌñū ñaꞌa sán ne, ");
INSERT INTO mizNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","kakaꞌan ñá ni Jēsuu: —Mastrú, ñadɨ̄ꞌɨ́ saꞌá ne, natúvi ña é kade ña é kini kaa ni ñatīí san. ");
INSERT INTO mizNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kakaꞌan lei Muísee tsi kuéꞌe xuu o ñaꞌa, ña kuān ó ntáde san. Dɨvi ntō ni, ¿nté kaꞌan nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Da ti tsi ntákaꞌan ña é kōto nteé ña ña vata koo é nīꞌi ña uun núu ī é tsiꞌi kuétsi ña ña. Ntá tsi Jesuú ne, ítuvī tɨxɨ ñá ñuꞌu kan ne, dā káꞌu ña rkɨntaꞌa ña nú nteꞌú san, é vata tsi tē ña ni tekú ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kiꞌin itō tsíxeꞌe ña Jesuú ne, da kidáa ne, nākuiñɨ ñá, kakaꞌan ña: —Xoó ñaꞌa, ña é ña tuvi kuétsi ī ne, diꞌna ña na kani ntuꞌu ña nakɨ̄ꞌɨn ñá xuú san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nákutītɨxɨ xtúku ña ne, dā káꞌu xtūku ña nú nteꞌú san. ");
INSERT INTO mizNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Dā téku ñaꞌa san sáꞌa ne, eni ntuꞌu ñā ntáka ña kui uun kui uun ña. Diꞌna tsi ñatā san ntáka ña. Dā kúvi ne, koó da miī sá Jesuu ntií koó ña ni ñadɨ̄ꞌɨ́ san. ");
INSERT INTO mizNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kidáā ne, nákuntītsí Jesuu, kátsixeꞌē ñá ñadɨ̄ꞌɨ́ san: —¿Míꞌi ntū ntâñɨ́ ka ña katsiꞌi kuétsi o? Nté uun ká xoxó katsiꞌi kuétsi ká i o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ñadɨ̄ꞌɨ́ san ne, nantíko koō ñá, kakaꞌan ña: —Nté uun ká ña, Mastru —kaꞌan ña. Kidáā ne, kakaꞌan Jésuu ni ña: —Nté xuꞌú ña tsiꞌi kuétsi ú o. Kuēꞌén ve ne, ña ku ídēn ka é kīni kaa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kidáā ne, kakaꞌan xtúku Jésuu ni ñáꞌa san: —Xuꞌú e kúvi ú ñuꞌu é kaxiꞌí nuu ñuxiví sa. Xoo é kuntīkɨn í ko ne, ña káka mí nēe, tsí naxiꞌí nuu ú itsi ntuvi iña ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dukuān ne, ntákaꞌan ñá fariseu ni ña: —Xoꞌōn né, da ti tsi kakaꞌan kuénta iña míi o. É kākaꞌán ne, ñá tē neé nuu áꞌvi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Kuān te xuꞌú kantada ntaa ú kuenta iña mií ko ne, ntá tsi nuu é ntaā i é kākaꞌán u ni ntō. Tsí iní u míꞌi vēꞌxi ú ne, iní u míꞌi kɨ̄ꞌɨ́n u dɨ. Ntá tsi dɨvi nto ne, ntē ñá ini nto míꞌi vēꞌxi ú, ntē ñá ini nto míꞌi kɨ̄ꞌɨ́n u dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ntoꞌó ne, ntádē kúꞌvē ntó vatā ó ntádē kueni ña ntoo ñuxiví sa, ntá tsi xuꞌú ne, nté uun ñaꞌa ña kade kûꞌvé u nté o de ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ntá tsi tē dɨ́ kadā kûꞌvé u ne, váꞌa koo kadā kûꞌvé u dɨ, tsí ña te da míi tsi ú, tsí ntuví u Uvā kó, ña táxnuu ko. ");
INSERT INTO mizNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Uve naꞌá lei nto tsí te ūvi ñaꞌa ntada ntaa ña é dadɨɨ tsi ntákaꞌan ñá ne, nuu é ntaā i e ntákaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Xuꞌú ne, kuvi ú uun é ntada ntaa u iñá ko ne, Uvā kó, ña táxnuu kó ne, dɨvi ña kuvi ūvi ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kidáa ne, tsixeꞌe ñāꞌa san ña: —¿Míꞌi ntū tuvi úva o? —kaꞌan ña. Nantíko kōó Jesuu, kakáꞌan ña: —Ntoꞌó ne, ñá īni ntó xoo ñáꞌa ú ne, ntē ñá ini nto xoo é Uvā ko. Tē dɨ́ ini ntó ko ne, ini nto Uvā kó dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sáꞌa kākaꞌan Jésuu dá kanakuāꞌa ña ñaꞌa má ūkún ña Israee, mí ñuꞌu váꞌa etún diuꞌun iña ukun. Ntá tsi xoxó ni tɨ̄ɨn i ña, tsí vata xée úra íña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kakaꞌan xtúku Jesuu ni ñáꞌa san: —Kɨ́ꞌɨ̄n ú ve ne, nantuku ntō ko, ntá tsi dɨvi ntō ne, kuví nto kuenta iña kuétsi nto. Tsi mí kɨ̄ꞌɨ́n u ne, ña kúvi kɨ̄ꞌɨn nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ña Israeé san ne, ntákaꞌan ñá ni tāꞌan ña: —¿Vá kaꞌni mii ntú ña kúñu ñā é kuān ó kakaꞌan ña tsi mí kɨ̄ꞌɨn ñá ne, ña kúvi kɨ̄ꞌɨn o? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kakaꞌan Jésuu ni ña: —Ntoꞌó ne, ñuxiví sa ntoo nto. Xuꞌú ne, e dukún kan vēꞌxí u. Ntoꞌó ne, ñaꞌa ñuxiví sa nto. Ntá tsi xuꞌú ne, ñá tē ña ñuxiví sa u. ");
INSERT INTO mizNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Dukuān é kuan ō kaꞌán u ni ntō tsí kuví nto kuenta iña kuétsi nto. Tsí tē ña kuintíꞌxe nto kó é dɨvī ú ne, da miī é kūvi nto kuenta iña kuétsi nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kidáā né, tsixeꞌe ña ñā: —¿Xoó ñaꞌa ntun dɨvīn kuan? —kaꞌan ña. Kakaꞌan Jésuu ni ña: —Nté dīꞌna kakaꞌán u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Dōó tɨtɨ́n nuu i é ntio koo kaꞌán u ni ntō: nee ñáꞌa nto, nte ntáa nto dɨ. Ntá tsi ña táxnūu kó ne, dɨvi ñā é kākaꞌan ña é nuu é ntaā i. Tūꞌun é kākaꞌán u ni ntō iꞌa ñuxiví sa ne, dɨvī e téku ko é kākaꞌan ñá nī ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ntá tsi ña ni ñéꞌe dɨkɨ ña te kakaꞌan ñá iña Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Dukuān ne, kakaꞌan Jésuu ni ña: —Tē náxkaa dukun ntó ko, xuꞌu é vēxkúvi ú ñatīí ne, da kidáa kutūni nto tsí dɨvi ntīꞌxe u. Kutuni ntó tsí ña te neé kade u é dɨkɨ mií ko. Tsí vatā o nañéꞌe Úvā kó ko ne, dukuān ó kakaꞌán u ni ntō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tsí ña táxnūu kó ne, nuu méꞌñu nuu dava ñā ko. Nté uun ito vata xtuví mii ñá ko, tsí nguentúvi kade ú nee iña é ntio ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Dā kaꞌan Jésuu sáꞌa ne, dōó tɨtɨ́n ñaꞌa kuíntiꞌxe ña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kidáā ne, kakaꞌan Jésuu ni ñá Israee, ña kuíntiꞌxe i ña: —Te kāda ntaa nto túꞌūn kó ne, kuvi kuntīkɨn ntó ko. ");
INSERT INTO mizNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kiní nto nee iña é nuu é ntaā í ne, dɨvī é nakāka xaa nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ñaꞌa sán ne, ntákaꞌan ñá ni ñā: —Ntɨꞌɨ́ ne, tatá viꞌi Abraán ntɨ. Nté uun ito vata kada tsíñu ntɨ é kuētsi iña tuku ñáꞌa. ¿Nté kuān ó kakaꞌan nto é nakāka xaa ntɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō: Xoo é kade i kuétsi ne, ntáde tsiñu ña iña kuétsi san. ");
INSERT INTO mizNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ña kade tsiñu sán ne, da tuví taan ña nú viꞌī tóꞌo ñā. Ntá tsi iꞌxá san ne, nguentúvi tsi tuví ni uva ī. ");
INSERT INTO mizNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dukuān né, te xūꞌu é Īꞌxá Xuva kō ú nakāka xaa ú nto ne, kaka xaa ntiꞌxe nto. ");
INSERT INTO mizNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iní u tsí tatá viꞌi Abraan nto. Ntá tsi ntánantuku ntō nté koo kaꞌní nto ko, tsí ña ntío nto kuintiꞌxe nto túꞌūn é kākaꞌán u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Xuꞌú ne, kakaꞌán u nee iña é īní u iña Uvá ko. Dɨvi ntō ne, ntáde nto nee iña é īni nto iña uva ntó dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ntákaꞌan ñá ni ñā: —¡Ntɨꞌɨ́ ne, Abraan úvā ntɨ! —kaꞌan ña. Nantíko kōó Jesuu, kakaꞌan ñá ni ñā: —Tē dɨ́ nuu é ntāa ntíꞌxe i é iꞌxá Abraan ntó ne, ntáde nto vatā o dé Abraán san. ");
INSERT INTO mizNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ntá tsi ntánantukū nuu iní nto nté koo kaꞌní nto ko, xuꞌu é kākaꞌán u ni ntō é nuu é ntaā i e téku ko é kākaꞌan Xúva kō. Abraán ne, nté uun ito ña ni íde ña sáꞌā. ");
INSERT INTO mizNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ntoꞌó ne, ntáde nto vatā o de úva mii ntō —kaꞌan ña. Kidáā ne, ntákaꞌan ña: —¡Ntɨꞌɨ́ ne, ñá te īꞌxa ntaꞌví ntɨ! tsi úun tsi uvā ntɨ́, dɨvi ñā é Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kakaꞌan Jésuu ni ña: —Tē dɨ́ dɨvi uva ntiꞌxe nto Xuva kō né, kuinima ntó ko tsí dɨvi ntāꞌa ña véꞌxi u é tūví u vevii. Ñá te kuēnta iña mií ko véꞌxi u, tsí dɨvi ñā táxnuu ña ko. ");
INSERT INTO mizNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Nté kui ña kúvi ntu kɨ́ꞌɨn dɨkɨ nto túꞌūn ko? Tsí da xé ña ntío nto kiní nto é kākaꞌán u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ntoꞌó ne, ntaꞌa uva ntō, tóꞌō e ña váꞌā san véꞌxi nto. Tsí ncho vií nto nee iña é ntio i. Dɨvī né, dukuan tsī ó kaeꞌní ñaꞌa nte ntúvi díꞌna. Ñá te īni kaꞌan túꞌūn é nuu é ntaā i, tsí ntē ña tuvi é nuu é ntaā i nuu nima i. Dá kakāꞌan dóveté ne, nima míi i kākene é kākaꞌan. Tsi dóo vete ne, kuān ó kanañēꞌe iꞌxá i dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ntá tsi xuꞌú ne, é nuu é ntaā i kakaꞌán u ni ntō, ntá tsi ntoꞌó ne, ña ntákuintiꞌxe nto ko é kākaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Vá iō ntú nto, uun ñaꞌa ntō, é kūvi nañeꞌe ntó ko mí kōꞌxó ntee u? Te kākaꞌán u é nuu é ntaā í ne, ¿nté kui ña ntákuintiꞌxe ntu nto ko? ");
INSERT INTO mizNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xoo é kāduku ntée i Xuva kō ne, kaini ña túꞌun Xuva kō. Ntá tsi ntoꞌó ne, ña ntátekú nto, tsí ña te Xuva ko ntáduku ntée nto —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kidáā ne, ntákaꞌan ña Israeé san ni ñā: —Nuu é ntāa ntíꞌxe i é kākaꞌán ntɨ tsí ña ñuú Samaria nto, tsí nuu é ña váꞌā sán nima nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Nté uun é ña váꞌā san ña tuvi núu nimá ko. Xuꞌú ne, kaiko ñuꞌū ú Uvā ko, ntá tsi ntoꞌó ne, ña ntío nto kuiko ñuꞌu ntō ko. ");
INSERT INTO mizNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ñá te xūꞌu ntío ko é kada kaꞌnu ñáꞌa sán ko, tsí īó xoó ntio i é kuān koo. Dɨvi ñā kada kúꞌvē ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nuu é ntaā i é kāꞌán u ni ntō: Xoo é kāda ntaa i túꞌūn é kākaꞌán u ne, ñá kūví ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kidáā ne, ntákaꞌan ñá Israee ni ña: —É īni ntíꞌxe ntɨ́ ve tsí nuu ntiꞌxe é ña váꞌā sán nima nto. Abraán san ni un ntɨꞌɨ̄ ña kaꞌán naa Xuva kó san ne, xíꞌi ñā ne, ¿nté kui dɨvi nto kākaꞌan ntó é ña níꞌi ntɨ doxiꞌí san te kāda ntaá ntɨ túꞌun ntō? ");
INSERT INTO mizNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Vá dií ka ntu kaꞌnu ñaꞌa nto é vata kaa uvatā ntɨ́ Abraan? Dɨvi ñā ne, xíꞌi ña, ni un ntɨꞌɨ̄ ña kaꞌán naa Xuva ko. Dɨvīn né, ¿neé ntu ñaꞌa kúvin kuan, te kuīni o? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Tē dɨ́ xuꞌu kaꞌán u tsi dóo kaꞌnu ñaꞌa ú ne, ñá vādá kadiáꞌvi túꞌūn ko. Ntá tsi Uvā kó kakaꞌan ña tsi dóo kaꞌnu ñaꞌa ú, dɨvi tsi ñā é ntákaꞌan nto é Uva nto ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ntoꞌó ne, ñá īni ntó ña, ntá tsi xuꞌú ne, iní u ña. Tē dɨ́ kaꞌán u e ñá īní u ñá ne, kantaku vēte ú vatā ó de nto. Ntá tsi íni ntiꞌxé u ña ne, kade ntaá u é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Dōo diní uvata nto Ābraan tsi dóo ncho kiní ña ntuvi é xēé u ñuxiví a. Dā íni ña ne, ñá tē nté kaa diní ña —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kidáā ne, ntákaꞌan ñá Israeé san ni ñā: —Ntē vata xéen uvi díko uꞌxi kuia ó ne, ¿é kakāꞌán sa xkun e ínin Ábraan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kakaꞌan Jésuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō. É dukuān tuví u diꞌna dá kaku Ábraan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kidáā né, īdo ña Israeé san xuu é kuēꞌé xuu ña ñā, ntá tsi Jesuú ne, ntii xuꞌū ñá ini ukún kān ne, dá kuēꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Dā ita ntíꞌxin Jesuú ne, īní ña uun ñatīí, ña e dúkuan kuāa da káku. ");
INSERT INTO mizNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ña ntɨniꞌi ñā né, tsixeꞌe ña ñā: —¿Nté kui e dúkuan kuāá ña sāꞌa nté da káku ña? ¿Kuētsí mii ntu ñā né, o kuētsi úva ña, o kuētsí dɨꞌɨ ñā? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Nté uun ña, ña túvi kuétsi ña. Tsí kuaā ña é da ti tsi na kīni ñaꞌa san nee iña é kūvi vií Xuva ko īña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Vevii é ntuvī né, na ntɨ̄ꞌɨ o tsiñu iña ña é táxnūu ko. Tsi nté uun xoxo kuvi kada tsíñu ká i tē kunee. ");
INSERT INTO mizNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Vevii é tuví u ñuxiví a ne, xuꞌú e kúvi ú ñuꞌu é kaxiꞌí nuu ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Dā kúvi kaꞌan ña sáꞌa ne, ētɨ ña dɨ́ɨ ña ñuꞌu kān ne, de váꞌa ña un síin ntóꞌxō san, dá nakutsi núu ña nuu á ña kuāá san, ");
INSERT INTO mizNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","kakaꞌan ñá ni ñā: —Kuēꞌén, kukɨ̄tɨ́n ve mí ñuꞌu váꞌa ntute Silueé san —kaꞌan ña. (Tūꞌún Silueé san ne, kani túꞌun E Táxnūu Ña.) Kuéꞌen ña, kūkɨtɨ́ ña. Dā ntíko koō ñá ne, é nāxiꞌí nuu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kidáā ne, ña ntoo etsin nú viꞌi ña kān, ñá ini é kuaā ñá ne, ntátsixeꞌe taꞌan ñā: —¿Vá ñā ntu te ña saꞌa é xkūtúvi ña, kaikan ñá diuꞌun ítsi kān? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Iō ñá ne, ntákaꞌan ña: —Dɨvi ntīꞌxe ñá saꞌa —kaꞌan ña. Iō ñá dɨ ne, ntákaꞌan ña: —Ñaꞌá ni san, ntá tsi vata te kuan ito ñā —kaꞌan ña. Ntá tsi mii ña kakāꞌan ña: —Dɨvī ú xuꞌu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kidáā ne, tsíxeꞌe ñāꞌa sán ña: —¿Nté kui kúvin ntun nákoton ve? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nantíko koō ñá, kakaꞌan ña: —Ñatīí, ñá nani Jēsuú ne, de váꞌa ña ntóꞌxō sán, dā xntáꞌa ña ntuxnūú ko, dá kakāꞌan ñá nī kó: “Kuēꞌén, kūkɨtɨn mí ñuꞌu ntute Silueé san”, kaꞌan ña. Ñéꞌe ntīꞌxe ú ne, dā kúvi kɨ́tɨ ú ne, ura dúꞌva tsi i nákotó u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tsixeꞌe ña ñā kídaā: —¿Míꞌi ntū tuví ñatīí tsikan? —kaꞌan ña. —Ñá īní u míꞌi tūví ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kuēꞌen níꞌi ña ña kuāá san, ña náxiꞌí ntuxnūú i, mí ntoo ña fariseu. ");
INSERT INTO mizNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tsí ntuvi iō dáꞌna da de váꞌa Jesuu ntóꞌxō é nakutsi núu ña ntuxnūú ña kuāá san. ");
INSERT INTO mizNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kidáā né, tsixeꞌē ña fariseu ña nté ō náxiꞌí ntuxnūú ña. Kakaꞌan ñá nī ña fariseu: —Ntōꞌxo xntáꞌa ña ntuxnūú ko. Dā kɨ́tɨ ú ne, nāxiꞌi nuú ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kidáā ne, íō ñá fariseu, kakáꞌan ña: —Ñá te ntaꞌa Xuva ko vēꞌxí ña tsikan, tsí ña kaíko ñuꞌu ña ntūvi dá iō dáꞌna —kaꞌan ña. Ntá tsi iō ñá ne, kakaꞌan ña: —¿Nté ntu koo kuvi vií ñá iō kuetsí i uun nuu i e dóo kaꞌnu vatā o dé ña tsikan? —kaꞌan ña. Ñā te úun tsī ntádē kuení ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tsixeꞌe xtūku ña ña ntuváꞌa san: —¿Nté ō dé kuení o iña ña é nakaan ntuxnūú o san? —kaꞌan ña. Kakaꞌan ñá tsikan: —Xuꞌú kuiní ko ne, ña kakaꞌán naa Xuva ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ntá tsi ña Israeé san ne, ña ni kuintíꞌxe ña tē nuu é ntaā i é kuaā ña, ntá tsi é kainí ña ve, dá ntē kána ña uva ña ni dɨꞌɨ ñā, ");
INSERT INTO mizNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","tsíxeꞌe ña ñā: —¿Vá dɨvi ntu iꞌxā ntó ña sāꞌa? ¿Ntāa ntu káꞌan nto e dúkuan kuāa ña nté da káku ña? ¿Nté ntu ō kúvi náxiꞌí nuu ña ve? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kidáā ne, kakaꞌan úva ña ni dɨꞌɨ ñā: —Iní ntɨ tsí iꞌxá ntɨ ña ne, dukuan kuāa ña nté da káku ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ntá tsi ñá iní ntɨ nte o kúvi náxiꞌí nuu ña ve. Ntē ñá iní ntɨ xoo nákaan i ntuxnūú ña. Tsixeꞌe nto ñā, tsí e dukún kuia ñá ne, kuvi kaꞌan míi ña ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kuan ō kaꞌan úva ña ni dɨꞌɨ ñā, tsí da xe úꞌvī ñá ña Israeé san. Tsi ntánatíin ña Israeé san te xōo ñáꞌa é kāꞌan ña tsí nuu é ntaā i é Xuva kō táxnuu ña Jesuú ne, natavá ña ña ini ukún kān. ");
INSERT INTO mizNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Dukuān é kuan ō kaꞌan úva ña ni dɨꞌɨ ñā tsí e dukún kuia ñá ne, é kuvi kaꞌan míi ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kāna xtuku ña ña náxiꞌi ntuxnúu i sán ne, ntákaꞌan ñá ni ñā: —Kuiko ñuꞌu nto Xuva kō. Iní ntɨ tsí ña tsikán ne, iō kuetsí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nantíko kōo ñátīí san, kakaꞌan ña: —Ñá īní u te iō kuetsí ña ō ñaꞌa, ntá tsi é iní u ne, kuāá u nte díꞌna, ntá tsi vevií ne, é kainí u ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tsixeꞌe xtuku ña ñā: —¿Neé ntu dé niꞌi ña o dā nákaán ña ntuxnūú o? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nantíko koō ñá, kakaꞌan ñá ni ñā: —É kākaꞌan ntú ku ú ni ntō. Ntá tsi ntē ña ni ide ntó ko kuenta. ¿Nté kui ntio ntu nto é kaꞌan xtúku ú ni ntō? ¿Vá ncho kuntīkɨn ntú nto ña dɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kidáā ne, náuꞌvī ñá ña, ntákaꞌan ñá ni ñā: —Xoꞌōn né, kuntīkɨn ñá tsīkan. Ntɨꞌɨ́ ne, Muisee ntántīkɨ́n ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Iní ntɨ tsí Xuva kō káꞌan ñá ni Muīseé, ntá tsi ñá tsīkán ne, ntē ñá īní ntɨ míꞌi vēꞌxí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nantíko kōo ñátīí san, kakaꞌan ñá ni ñā: —¡Mpá! ¿Nté ō ntu e ñá īni nto míꞌi vēꞌxí ña? Tsí dɨvi ñā ne, nakaán ña ntuxnūú ko. ");
INSERT INTO mizNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ini ntú ku o tsí Xuva kō ne, ñá kaīni ña ñá iō kuetsí i, tsí da ti tsi ña é kanuu iní i ña, nī ña é kade ntaa é ntio ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nté uun ito vata tekú ko īña ña é kakuvi nakaan ntuxnūú ña e dúkuan kuāa nté da káku. ");
INSERT INTO mizNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tē dɨ́ ña te ntaꞌa Xuva ko ni kīꞌxi ñá ne, ñá tē neé kuvi vií ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nantíko koō ñá, ntákaꞌan ñá ni ñā: —Xoꞌōn é iō kuetsí o nté da kákun ne, ntio sá ku o é nakuāꞌan ntɨ́ ve —kaꞌan ña. Kidáā ne, kíñuꞌu ña ña ini ukún kān. ");
INSERT INTO mizNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tēkú Jesuu é kiñúꞌu ña ñatīí san. Dā nániꞌi taꞌan ñá ne, tsixeꞌe ña ñā: —¿Kākuintiꞌxe ntu o ña vexkúvi ñatīi? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nantíko koō ñá, kakaꞌan ñá ni Jēsuu: —Káꞌan nto nī ko xoo ñáꞌa, vata koo é kuīntiꞌxe kó ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kakaꞌan Jésuu ni ña: —É īnin ña. Dɨvī u é kākaꞌan níꞌin vevii —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kidáā ne, nákunchɨtɨ ntāa ña nuu Jésuu, kakaꞌan ña: —Kakuintiꞌxe ko é ntoꞌo é Tóꞌo kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kidáā ne, kakaꞌan Jésuu: —Xuꞌú ne, véꞌxī ú ñuxiví a é kadā kûꞌvé u, vata koo é na kīní ña kuāá san ne, vata koo é ña kiní ka ña é vāꞌá ntuxnūú i san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Īó ña fariseu, ña ntáñɨ étsin ne, tēkú ña dá kakāꞌan ñá sāꞌá ne, ntákaꞌan ñá ni ñā: —Ntɨꞌɨ́ ne, ¿vá kuaā ntú ntɨ dɨ? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kakaꞌan Jésuu ni ña: —Tē dɨ́ kuāa ntíꞌxe nto ne, ña túvi kuētsí nto. Ntá tsi ntákaꞌan nto tsi kainí nto. Dukuān né, iō kuetsí nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kidáā ne, kakaꞌan Jésuu: —Nuu é ntaā i é kākaꞌán u ni ntō: xoó ñaꞌa, ña é dotō tsí kakɨ́ꞌvi ini aku mí ñūꞌu leꞌntú san, tē ña té xiꞌi kan kukɨ́ꞌvi ña ne, ña duꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ntá tsi ña é kakɨ́ꞌvi xiꞌi kán ne, dɨvi ñā é paxtu ntíꞌxe ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ña nteé ntaꞌa i xiꞌi áku sán ne, nakaán ña tē xee páxtú san. Paxtú san ne, nākana ña tɨ, kui uun kui uun xtɨ, kána dɨvī ñá tɨ ne, ntátekú tɨ tatsin ña. Kidáā ne, kakiñuꞌu ña tɨ é kɨ̄ꞌɨn tɨ́ ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tē kúvi kií ntɨꞌɨ tɨ ne, dá kɨ̄ꞌɨn ñá, kodo nuū ñá, kuntīkɨn tɨ́ ña, tsí ini tɨ́ tatsin ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ntá tsi ña ntaíntíkɨn tɨ́ tuku ñáꞌa. Ntaínu tɨ ña, tsí ña ini tɨ́ tatsin ña xoo ñáꞌa ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sáꞌā nátee taꞌan Jesuu, kakaꞌan ñá ni ñā, ntá tsi ña ni ñéꞌe dɨkɨ ña nee iñá ncho kaꞌan túꞌūn saꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kidáā ne, kakaꞌan xtúku Jesuu ni ña: —Nuu é ntaā i é kākaꞌán u ni ntō: Xuꞌu e kúvi ú xiꞌi mí kantɨ́ꞌvi á leꞌntú san. ");
INSERT INTO mizNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Da xóō ká ñaꞌa, ña kiꞌxi díꞌna é xuꞌú ne, kūdii ñá duꞌu ña. Ntá tsi ña ni íde leꞌntú san ñá kuenta. ");
INSERT INTO mizNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Xuꞌú ne, xíꞌī san kúvi u. Xoo é kɨ̄ꞌví i kuenta iñá ko ne, nakáku ña. Níꞌi ñā é vāꞌa é vata kaa leꞌntu, kɨtɨ kantɨ́ꞌvi, kɨtɨ kantii ne, ntániꞌi tɨ́ ite vaꞌa é kāꞌxi tɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ʼÑa duꞌú san ne, da ti tsi kantukū nuu iní ña nté koo kiꞌi dúꞌu ña tɨ, nté koo kaꞌní ña tɨ, vata koo é nantɨ̄ꞌɨ ña tɨ. Ntá tsi xuꞌú ne, véꞌxī ú vata koo é nīꞌi tɨ ntuví vaꞌá iña tɨ, é ña te neé kunaá nteē tɨ nté un siin. ");
INSERT INTO mizNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Xuꞌu é paxtu vaꞌá u. Paxtu vaꞌá san ne, uun tsi nte ntúvi iña ña kaxéꞌe ña kuenta iña léꞌntu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ña kade tsiñu, ña é dā ti tsi kantuáꞌvi é kade ña tɨ kuenta, é ña te dɨvi ñā é tóꞌo tɨ, tē íni ña tsi véꞌxi kɨtɨ kueꞌɨ̄ sán ne, kuan tsī ó katsuꞌun mii ña lēꞌntú san da kainu ña. Kidáā né, kɨtɨ kueꞌɨ̄ sán katɨ́ɨn tɨ tɨ ne, dá katsoo xaa tɨ tɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ña tsīkán ne, dā ti tsi kade ña tɨ kuenta é kaxɨꞌɨ áꞌvi ña; ñá te kuēnta iña ñá te kūnaá tɨ ne, o ñáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","ʼXuꞌu é paxtu vaꞌá u. Vata tsi kaa Uvā ko é īni ñá ko ne, iní u ñá dɨ. Kuān ó iní u leꞌntú ko ne, ini tɨ́ ko dɨ. Uun tsi nté ntūvi iñá ko kuéꞌe ú kuenta iña tɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ñuꞌu ká tuku leꞌntú ko é ña te kaduku ntée tɨ xáku sāꞌa. Ntio é kínakueká u tɨ́ dɨ ne, kiní tɨ tatsín ko dɨ. Kidáā ne, uun sá nakuvé taꞌan tɨ, uun sá paxtu tɨ ntuví dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ʼDukuān né, dōó kakuinimá Uvā kó ko, tsi nté ntūvi iñá ko kaxéꞌe u. Ntá tsi naniꞌi xtúku kó ntuvi iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nté uun xoxo kúvi nakíꞌi ntuvi iñá ko. Miī u kuéꞌe ú ne, mii tsī ú nakiꞌí u dɨ. Tsí kuan ō kaꞌan Úvā kó nī ko é vīí u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nāteꞌnte dáva ña Israeé san da téku ña túꞌūn saꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tɨtɨ́n ña ntákaꞌan ña: —Nuu é ña váꞌā nima ña. Kūdii kákuluku ña. ¿Nté kui ntáde ntu nto kuenta é kākaꞌan ñá sa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ntá tsi ña nguiī sán ne, ntákaꞌan ña: —Ñá te kuān ó kakaꞌan ña é nuu é ña váꞌā nima i. ¿Vá kūvi ntu vii é ña váꞌā san nakaan nuu ñá kuāá san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ntuvi vīꞌxín kídaā da nátsuꞌun kaꞌnu ña viko é nakaꞌan ña ntūvi da ntáda ña kuenta xúkūn ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tuví Jesuu má ukún kān, kaika ña Coridoo Sálamuun. ");
INSERT INTO mizNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Uun tsi tavi núu ñá Israeé san Jesuu, ntákaꞌan ñá ni ñā: —¿Amá ntu kaꞌan ntaan ní ntɨ xoo ñáꞌan? Tē nuu é ntaā i é dɨvīn é táxnuu Xuva kō ne, kaꞌan ntáan tsīn vevii; ñá ku tee xūꞌun —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —É kākaꞌan ntú ku ú ni ntō, ntá tsi ña ntákuintiꞌxe nto ko. Tsí tsiñu é kade ú kuenta iña Uvá ko ne, dɨvī é kantada ntaa iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ntá tsi ntoꞌó ne, ña ntákuintiꞌxe nto, tsí ña te dɨvi ntō é leꞌntú ko, vatā ó kakaꞌán u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tsí leꞌntú ko ne, ntátekú tɨ tatsín ko. Iní u tɨ́ ne, ntántīkɨn tɨ́ ko dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Xuꞌú ne, kaxéꞌe ú ntuvi iña tɨ ntii dáñu ntūvi. Nté uun ito ña kunáa tɨ, tsi nté uun xoxo kuvi nakuido núu i tɨ ntaꞌa ko. ");
INSERT INTO mizNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Uvā kó, ña ntáda tɨ kuenta ntáꞌa kó ne, dií ka kaꞌnu ña é da xóo ká ñaꞌa. Nté uun xoxo kuvi nakuido núu i tɨ ntaꞌa Uvā ko. ");
INSERT INTO mizNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Uun tsi kúvī ú ni Uvā ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kidáā né, īdo xtuku ña Israeé san xuu é kuēꞌé xuu ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesuú ne, kakaꞌan ñá ni ñā: —É nañēꞌé u nto tɨtɨ́n nuu i é vāꞌa e táꞌxi Uvā ko é vīí u. ¿Neé ntu nuu i é ncho kuéꞌe xuu ntō ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nantíko kōo ña Israeé san, ntákaꞌan ñá ni ñā: —Ñá te kuēnta iña núu i é vāꞌa e kuéꞌe xuū ntɨ́ o, tsí da xé kakaꞌan túꞌūn e dóo xii kaa íña Xuva ko. Tsí xoꞌōn ne, kūdii ñá ñuxiví san kúvin ne, dadɨɨ ncho viín vata kaa Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —¿Ñā ntu te uve náꞌa kakaꞌan leí san iña nto: “Xuꞌú kaꞌán u tsí ntiusi kúvi nto”, kaꞌan? ");
INSERT INTO mizNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tsí ntiusi xntánteē ña é dɨvi ntaꞌa ī e xee túꞌun Xuva kō ne, ña kúvi kuīdo ntíta o lei e xtúvi Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Te duꞌva ntū ó kakaꞌan Xúva kō ne, ¿nté kui ntákaꞌan ntú nto tsí ña váꞌa o kakaꞌán u tsí xuꞌu é Iꞌxá Xuva kō u? Tsí xuꞌú ne, nté diꞌna nákaxnúu ña ko é kīꞌxi ú ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tē ña te tsiñu iña Uvá ko kadé u ne, na koo mii kuīntiꞌxe nto ko. ");
INSERT INTO mizNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ntá tsi kade u. Kuān té ña kuintíꞌxe ntō kó xuꞌú ne, kuintiꞌxe nto tsiñu é kade ú vata koo é kūtuni ntó, na kuīntiꞌxe nto tsí uun tsi kúvi ú ni Uvā kó, uun tsi kuvi ña nī kó dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dukuān né, ntukū nuu iní xtuku ña nté koo tɨ́ɨn ña ña, ntá tsi ña ni kuvi vií ña, tsi ntií niꞌni ña ntaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kidáā né, ntiko kōo xtúku Jesuu, kuéꞌen ña ūun xo diñɨ ntute kaꞌnu é nani Jōrdaan, mí dīꞌna nakutsi ntúte Juaan ñáꞌa san. Ikān kanúu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ñá te nté kaa ñaꞌa xee xtúku ñā mí nuu ña ne, ntákaꞌan ñá ni ñā: —Nté uun nuu i é dóo kaꞌnu ña ni idé Juaán san, ntá tsi un ntɨꞌɨ̄ é kāꞌan ñá iña ñá saꞌá ne, nuu é ntaā i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Dōo tɨtɨ́n ñaꞌa san kuíntiꞌxe ña Jesuu íkān dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ítūví uun ñatīi, ña nchokuvi, ñá nanī Lázaru, ñuú Betania. Ikan ñūú María san ni tāꞌan ña, ñá nanī Martá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María, taꞌan Lázaru sán ne, dɨvi ñā é daꞌvi ña choꞌo vîdín san Jesuú ne, idi ña naítsi ña dɨ́ꞌɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Dukuān ne, xéꞌe ña kuēnta ntáꞌa Jesuu tsí taꞌan ña, ña e dóo váꞌa tiin niꞌi Jēsuú ne, ētsin ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ntá tsi dā téku Jesuu sáꞌa ne, kakaꞌan ña: —Ñá te kuīꞌi é kuvī ña sáꞌa. Tsí da ti é na kīní ñaꞌa san tsi dóo kaꞌnu Xuva kō, vata koo é na kīní ña tsi dóo kaꞌnu Iꞌxá Xuva kō dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kuān te dóo kuinima Jésuu Márta ni Mária, ni taꞌan ña Lázaru ne, ");
INSERT INTO mizNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","dā téku ña tsi étsin Lázaru sán ne, ítūví ka ña uvi ntúvi mí tuví ña kān. ");
INSERT INTO mizNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kidáā ne, kakaꞌan ñá ni ña ntɨniꞌi ñā: —Kɨ́ꞌɨn xtuku o ñūú Judea —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ntá tsi ña ntɨniꞌi ñā ne, ntákaꞌan ñá ni ñā: —Mastru, vátā e náꞌa ntu ku ntántukū nuu iní ña Israeé san e kuéꞌe xuu ña ntō ne, ¿vá kɨ̄ꞌɨn xtúku ntu nto ikān? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nāntíko kōo Jésuu, kakáꞌan ñá ni ñā: —¿Vá ña ntu te ntáā é uxuvi ura ió ntuvi ā? Tē xoó kaika i ntuvi ā ne, ñá kānakɨꞌɨ́ ña, tsí kaxiꞌi. ");
INSERT INTO mizNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ntá tsi tē xoo é kaika i niñú a ne, kanakɨꞌɨ́ ña, tsí kakunáa ntēe ñuꞌú san mí kaika ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Dā kúvi kaꞌan ña sáꞌa ne, kakaꞌan ñá ni ñā: —Lázaru, ña e dóo vá tiin niꞌi ō ne, e kídi ñā. Ntá tsi kɨ̄ꞌɨ́n u ve vata koo é nantōtó u ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kidáā ne, ntákaꞌan ña ntɨniꞌi ñā: —Te kākidi ñá ne, é kantuváꞌa ña ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ntá tsi Jesuú ne, ncho kaꞌan ña tsí e xíꞌi ña, ntá tsi ña ntɨniꞌi ñā ne, maꞌná san xee ña, kuiní ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kidáā ne, xéꞌe Jēsuu kútuni ntaa ña, kakáꞌan ña: —E xíꞌī Lázaru. ");
INSERT INTO mizNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Dōó diní ko é xoxó u ikān, tsí dií ka váꞌā o xtuku é kuenta iña nto, vata koo é na kuīntiꞌxe nto ve. Ntá tsi kɨꞌɨn ó ve mí tuví ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kidáā ne, kakaꞌan Túmaá san, ña e ntántēe Iꞌxa Uví ne, kakaꞌan ñá ni enī ñá, ña nguiī san: —Kɨ́ꞌɨn ō vé, na kūví dadɨɨ o ni ña ikān —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Dā xee Jésuu íkān ne, kūtuni ña tsi e ntúkɨmi ntuvi Lázaru san. ");
INSERT INTO mizNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ñuú Betaniá ne, etsin tsi tuví ñuú Jerusaleén te io te ūni kilumétru tsi é ikā. ");
INSERT INTO mizNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ñá te da dīí ña Israeé san xee ña nú viꞌī Marta ni Mária é kuēꞌé ña dokaꞌan nuú ini kuenta iña taꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ura dúꞌva tsi dā kútuní Marta tsi véꞌxi ētsin Jesuú ne, kuéꞌen ña, kūkuetú itsi ña ña. Ntá tsi Maríā ne, ítuvī mii ña nú viꞌi ña kān. ");
INSERT INTO mizNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kidáā ne, kakaꞌan Márta ni Jésuu: —Tē dɨ́ iꞌa tuví nto ne, ñá ni xīꞌi táꞌān ko. ");
INSERT INTO mizNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ntá tsi iní u tsí, kuān te vevíi kakan nto ntaꞌa Xuva ko da nēé ka nuu í ne, taꞌxi ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kakaꞌan Jésuu ni ña: —Taꞌan o ne, ntoto xtuku ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Kakaꞌán Marta ni ña: —Iní u tsí ntoto ña ntuvi te ntɨ́ꞌɨ ñuxiví sa tē ntóto ntɨꞌɨ ña xiꞌí san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kakaꞌan Jésuu ni ña: —Xuꞌu é kanantōtó u ñaꞌa. Xuꞌu é kataꞌxí u ntuvi iña ñá dɨ. Xoo é kuintiꞌxe i kó ne, kuān té xiꞌí ne, ntoto xtuku. ");
INSERT INTO mizNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Xoó ñaꞌa é kāntíto ká ña ne, te kuīntiꞌxe ña kó ne, ña kúvī ñá ntii dañu ntūvi. ¿Kakuintiꞌxe ntu o sáꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Kakaꞌan ñá ni ñā: —Kakuintiꞌxe kó nto, Mastru, tsí dɨvi ntō ña é táxnuu Xuva ko, dɨvi ntō é Iꞌxá Xuva ko ntō, ña é kīꞌxi ñuxiví sa —kaꞌan Mártá san. ");
INSERT INTO mizNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Dā kúvi kaꞌan ña sáꞌa ne, ntiko kōo ñá kunúꞌu ña ne, dā kána xūꞌu ña taꞌan ña Maria, kakáꞌan ña: —E xéē Mástru ko iꞌa, kakana ña o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ura dúꞌva tsi dā téku Mariá ne, nákuntītsi náneꞌe ña, kueꞌen ñá, kukoto ña mí tuví Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Váta xēe ña má ñūú san, tsí ikān tuvi dukuan ña mi nániꞌi taꞌan ñá Marta. ");
INSERT INTO mizNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ña Israee, ñá ntoo nú viꞌi ña kān, ña ntaxéꞌe dokaꞌnú inī sán ne, dā íni ña Maria é kantɨ́ꞌɨ duꞌva tsi nákuntitsi ña ne, kīi ña, kuntikɨn ñá ña. Tsí kukuéku ña nú ñaña tāꞌan ña, kuíni ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kidáa ne, dā xee Mária mí tuví Jesuú ne, nákunchɨtɨ ntāa ña nú dɨ̄ꞌɨn Jesuu, dá kakāꞌan ñá ni ñā: —Mastrû, tē dɨ́ tuví nto iꞌa ne, taꞌan kó ne, ñá ni xīꞌi ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Dā íni Jesuu tsí kaeku Maria ni ñá Israeé san ne, dōo uꞌvi kúvi ña. Kuntaꞌxa iní ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kakaꞌan ñá ni ñā: —¿Míꞌi ntu ixkūꞌxí nto ñā? —kaꞌan Jésuu. Ntákaꞌan ñá ni ñā: —Niꞌí nto, kíkoto ntódo ō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesuú ne, ēku ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kidáā ne, ntákaꞌan ña Israeé san: —Koto ntō kuan. ¡Ntē ntu kaa dii ntío ña ña! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ntá tsi iō ñá ne, ntákaꞌan ña: —Ña sāꞌá ntu ku é kúvi īdé ña nakáan nuu ñá kuāá san. ¿Nté kui ña ni kuvi vií ntu ña vata koo é ña kuvi Lázaru san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesuú ne, dōo uꞌvi kúvi xtuku ña dā xee ña nú ñañā san. Mâvi kúvi ne, xúu kantīꞌu nuu mí kuīta ntíꞌxin ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kakaꞌan Jésuu: —Nakiꞌi nto xuú san —kaꞌan ña. Márta, taꞌan ña xiꞌí san ne, kakaꞌan ñá ni ñā: —Mastru, á tē dóo kaxkonūu ña ve, tsí e ntu kɨmi ntuvi ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —¿Ñā ntu te kakaꞌán u ni ō tsí te kākuintiꞌxe o ne, kinin nté kaa dií kaꞌnu Xuva kō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kidáā né, nākiꞌi ña xuú san ne, dā ntániꞌi Jesuu núu ña e dukún kān ne, kakaꞌan ña: —Ō Úva, ntadiáꞌvi nto tsi téku nto é kākaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","É īní u tsí nguentúvi kaini nto nee é kākaꞌán u ni ntō. Ntá tsi kakaꞌán u é na tēkú ña ntâñɨ íꞌa vata koo é na kuīntiꞌxe ña tsi nuu é ntaā i é dɨvi ntō táxnūu nto ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Dā kúvi kāꞌan Jésuu sáꞌa ne, nɨɨ̄ kuéꞌen ini ña kána ña: —¡Ntiin dikan, Lázaru! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ntīi ntiꞌxe ña ntɨxɨ́ san ikān. Katinuu ntaꞌa ña ni dɨ̄ꞌɨ́n ña doó san ne, katavi núu nuu ña uun doo dúkun. Kakaꞌan Jésuu ni ñáꞌa san: —Nantuté nto ña, na nākaka ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kidáā ne, kuintiꞌxe tɨtɨ́n ña Israeé san, ña é ntēka Mariá, dā íni ña nuu i é idé Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ntá tsi iō ñá ne, kuéꞌen ña kūkaꞌan véte ña nī ña fariseú san nté ō dé Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kidáa ne, nātaká nuu dutu ñá odo nūú nī ña fariseú san, da ntákaꞌan ña: —¿Neé ntu vii o ve? Tsi dóo kuēꞌe núu i e dóo naꞌnu é kāde ña sáꞌā. ");
INSERT INTO mizNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tē xtúvi ō ñá ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san kuintíꞌxe ña ña. Kidáā né, kiꞌxi ña odo nūú ñuú Romá ne, nakatsin ntɨꞌɨ ña xúkun ko ni ñūú kō dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Uun ñaꞌa, ñá nani Caīfaa, dutu ñá odo nūu kuia tsikán ne, kakaꞌan ñá ni ñā: —Ntoꞌó ne, ñá tē neé ini nto. ");
INSERT INTO mizNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Ñā ntu te dií ka váꞌā o, kuiní nto, te uun ñaꞌa tsi kūví kuenta iña ko é un ntɨꞌɨ ō vata koo é ña kunáa ñūú kō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ntá tsi ña te dɨ́kɨ tsi mii ñā é kākaꞌan ña sáꞌa, tsí da xé dutu ñá ódo nūu kuia tsíkan ne, Xuva kō xeꞌé ña é kāꞌan ñá tsi Jesuú san ne, kuví ña kuenta iña ñuú ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ñá te da mii tsi ñuū ñá dɨ, tsí vata koo é nātaká nuu ntɨɨ́ ntɨ̄ɨ́ iꞌxá Xuva ko dā míꞌī ka mí ntántoo ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nté ntūvi tsikán ne, ntukū nuu iní ña nté koo kaꞌní ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dukuān é Jesuú ne, ña ni íka ditó ka ña méꞌñū ña Israeé san, tsi kií ña ñuú Judeá san, kuéꞌen ña dīñɨ i ñuu itsí san ne, dā xee ñá ñuu é nani Ēfraín ne, ikān intóo ña ni ña ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dóko sā xee víko dá nakaꞌan ñā da nátava Xuva kō ña Israee ñuú Egítō ne, ñá te da dīi ñá ñuꞌu rantsú san ne, kúntāa ña ñuú Jerusaleen díꞌna dá xēe víko san vatā xkoó ini ña é ntāntoo ña kúñu ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dōo nántuku ña Jēsuú ne, ntatíin ña ni tāꞌan ña da nɨɨ ntáñɨ̄ ñá ini ukún kān: —¿Vá ña ntu kiꞌxi ña vikó saꞌá, te kuinī nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tsi é kākaꞌan tóꞌō dutú san nī ña fariseú san ne, tē xoo iní i mí tuví Jesuú ne, na kāꞌan ñá vata koo é kūvi tɨɨn ña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Íñu ntūvi diꞌna dá kūvi vikó san ne, xée Jēsuu ñuú Betania. Ikān tuví Lázaru, ña nantōto ña dá xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Dēváꞌa ña é kāꞌxí dadɨɨ ña ni Jēsuu kuénta kuáa. Martá ne, tsūꞌun koꞌo ña. Lázaru ne, tuví dadɨɨ ña nī ña ntoo nú mesá san. ");
INSERT INTO mizNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kidáā ne, kiꞌi María dāva lítru choꞌo vîdin e dɨ́ miī nardu kúvi. Ñá te nté kaa nuu áꞌvi. Dáꞌvi ña dɨ̄ꞌɨ́n Jesuú ne, dā naítsi ña idi ña. Īka díko choꞌo vîdín san kanɨɨ̄ má viꞌi ña kān. ");
INSERT INTO mizNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ntá tsi ntee táꞌan uun ñaꞌa ña ntɨniꞌi ñā, ñá nanī Júda Iscāriote, iꞌxá Simuun, dɨ́vi ñā é rkontûvi diko ña Jésuú ne, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Nté kui ña ni nadíko ntu ña choꞌo vîdín sa uní sientú ne, dá kuēꞌé ña diuꞌun i iña ñá ntāꞌví san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ntá tsi Júdā sán ne, ñá te ni kāꞌan ña sáꞌā é kantuntāꞌví ini ña ña ntāꞌví san. Kakaꞌan ña sáꞌa, tsí kūdii ñá duꞌu ña. Dɨvi ñā nteé ntaꞌa ña itɨ́n diuꞌún san ne, kaido miī ña é ñuꞌu iní i. ");
INSERT INTO mizNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesuú ne, kakaꞌan ña: —Koo mii nto ñā. Tsí e dúkuan kāxnuu váꞌa ña choꞌo vîdín san iñá ko te īntúꞌxi u. ");
INSERT INTO mizNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tsí ña ntaꞌví san ne, nguentúvi tsi kuntoo ña ni ntō, ntá tsi xuꞌú ne, ñá te nguentúvi é kinī ntó ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ñá te da dīi ñá Israeé san ne, kūtuni ña é tuví Jesuu ñuú Betaniá ne, xée ñā mí tuví ña, ne, ñá te da mii tsī é kinī ñá Jesuú san, tsí da ti tsi é kinī ña Lázaru, ña é nantōto Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ntá tsi tóꞌō dutú san ne, ntukū nuu iní ña nté koo kaꞌní ña Lázaru san. ");
INSERT INTO mizNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tsí da xé dɨvi kuetsí ña é ña te da díi ña Israeé san ntaúve xío ña tsi ntákuintiꞌxe ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ñá te da dīi ñáꞌa kuéꞌen ña ñuú Jerusaleen é kūvi viko dá natāvá Xuva kō ña Israeé san ñuú Egítō. Utén san ne, kutuni ña é vēꞌxí etsin Jesuu ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kidáā né, kātsin ña ntaꞌa tun ñuú san ne, dā kíi ña, kuēꞌen ña, kukuetú itsi ña ña. Un tsi ntákachuꞌu ña, ntákaꞌan ña: —¡Ntadiáꞌvi Xuva kō! ¡Nté kui dóo vaꞌá ña é vēꞌxí kuenta iña Xuva ko, ña é kūvi Rei iña ñá Israee! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Dā nániꞌi Jesuu uun a búru ne, íntēkú ña tɨ, vatā ó uve naꞌa kakaꞌan túꞌun Xuva kō: ");
INSERT INTO mizNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ñá ku uꞌvī o, ñúu Siuun. Un kaa Rei o, véꞌxi ña, ntekú ña uun a búru, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ñá ni ñēꞌe dɨkɨ ñá ntɨniꞌi ñā san nuu i sáꞌa kídaā. Ntá tsi dā kuntáa Jesuu e dukún kān ne, nánūꞌu ñá iní ña tsí kuān o úve naꞌa kakaꞌan iña ña é kuān koo vií ñaꞌa san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ña é ntoo niꞌi ñā da nantoto ña Lázaru e kána ña ña ntē nú ñaña ña kān ne, ntákaꞌan ñá neé ini ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Dukuān ne, ñá te da dīi da díi ñáꞌa kueꞌen ña é kūkuetú itsi ña ña, tsí da xé kutuni ña e dóo kaꞌnu nuu i idé ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kidáā ne, ntákaꞌan ñá fariseú san ni tāꞌan ña: —Íni nto ve, tsí ña te neé kuvi vií nto. ¡Tsí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ntaíntīkɨn ñá ña! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ntádaka núu ña griegú san méꞌñū ña xee ñuú Jerusaleen é kada kaꞌnu ña Xuva kō viko san. ");
INSERT INTO mizNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ña sāꞌá ne, xée ētsin ña mí ntitsí Felipe, ña véꞌxi ñuú Betsaida é kadūku ntée ñuú Galileá ne, ntákaꞌan ñá ni ñā: —Ntio ntɨ́ kiní ntɨ Jesuu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipé ne, kuéꞌen ña kūkoto ñá Andree. Kidáā ne, ntuvi ñá kūkaꞌan ñá ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesuú ne, kakaꞌan ñá ni ñā: —E xée ētsin ura é nāxiꞌí nuu kaꞌnu ú, xuꞌu é vēxkúvi ú ñatīi. ");
INSERT INTO mizNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nuu é ntaā i é kākaꞌán u ni ntō tsí tē ña kuví nuni tatá san tē koꞌxó nuu ñuꞌu kān né, kuan tsī kaa tuvi. Ntá tsi te kūví ne, ñá te da dīi nuni katáꞌxi. ");
INSERT INTO mizNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Xoo e dóo kakuinima i ntuvi iña i ne, kunaá ña. Ntá tsi xoo é ña ntío i ntuvi iña i iꞌa ñuxiví sa ne, níꞌi ña ntuvi vāꞌá iña ña ntii dañu ntúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Xoó ñaꞌa é ntio ña kada tsiñu ña iñá ko ne, na kuntīkɨn ñá ko. Míꞌi tūví u ne, é ikan kutūví ña kade tsiñu iña kó nī ko. Xoo é kade tsiñu iña kó ne, kada kaꞌnu Uvā kó ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ʼ¡Dóo kakuntaꞌxa iní ko ve! ¿Nee iñá ntu kaꞌán u? ¿Kāꞌan ntú u na nakākú Uvā kó ko nuu i sáꞌa? ¿Neé ntu kaꞌán u? Tsi é dɨvi tsīñu véꞌxi u é ntōꞌo ko sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ūva, naxiꞌí nuu kaꞌnu ntō ve —kaꞌan Jésuú san. Kidáā né, kīi díto tatsín, nte e dukún kan kākaꞌan: —É nāxiꞌí nuu ú ne, ntá tsi nāxiꞌí nuu xtuku u —kaꞌan tatsín san. ");
INSERT INTO mizNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Dā téku ña ntáñɨ étsin sán tatsín san ne, kakatsin, kuiní ña. Iō ñá ne, ntákaꞌan ñá tsi ánje kākaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nantíko kōó Jesuu, kakáꞌan ña: —Ñá te kuēnta iñá ko tatsin sáꞌa, tsí dɨvi kuēnta iña nto. ");
INSERT INTO mizNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","E xée ntūvi é kadā kûꞌvé Xuva ko īña ñúxiví sa ve. Viꞌi a vé ne, nantīi ña ña é kadē kûꞌvé ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Xuꞌú ne, te kūntaá dukún u ñuꞌu sá ve ne, vii ú vata koo é na kuntīkɨn un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sáꞌa kakāꞌan ña vata koo é kūtuni ñáꞌa san nté koo kuví ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Dukuān ne, nantíko koó ñaꞌa san, ntákaꞌan ñá ni ñā: —Tēkú ntɨ tsí uve naꞌa kakáꞌan leí san tsí ña táxnuu Xuva kō sán ne, ntii dañu ntuvi kutuvī ña. ¿Nté kuan ntū ó kakaꞌan é ña vexkúvi ñatīí ne, ntaa ña e dukún kān? ¿Xoó ñaꞌa ntiꞌxe ntu é vēxkúvi ñatīí kuan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kidáā ne, kakaꞌan Jésuu ni ña: —Dutsī sá ntuvi xiꞌí nuu ñuꞌu mí ntoo nto. Kaka ká nto viꞌi a iō ñuꞌú san iña nto vata koo é ña kuaá nto itsi nto. Tsí ña kaika mí nēé ne, ntē ñá ini ña mí kɨ̄ꞌɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Na kuīntiꞌxe nto ñuꞌú san viꞌi a īó ka vata koo e xiꞌí nuu kuntōo nto —kaꞌan ña. Dā kúvi kaꞌan Jésuu sáꞌa ne, kuéꞌen ña kūkutúvi xuꞌu ña mí ñā naníꞌi ñáꞌa san ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kuān te ña te da díi núu i e dóo kaꞌnu idé ña nuu ñaꞌá san ne, ñá ni kuintīꞌxe ña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kuān o ntúntaa vatā ó kakaꞌan túꞌun Isāia, ñá kaꞌán naa Xuva ko, dá kakāꞌan ña: ¿Xoó ntu kuíntiꞌxe i túꞌūn é kākaꞌán o? ¿Xoó ntu é nañéꞌe Xuva kō nuu i e dóo kaꞌnu é kākuvi kade ña? kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Dukuān ne, ña ni kúvi kuintīꞌxe ña, vatā ó kakaꞌan xtúku Isaiá san: ");
INSERT INTO mizNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Tsí Xuva kō ne, nanée ñá nuu ña. Dé kaꞌxi ña dɨ̄kɨ ñá dɨ vata koo é ña kuvi kiní ña, ntē ña kuvi kɨ́ꞌɨn dɨkɨ ñá, vata koo é ña kuvi kuntíkɨn ñá ko ne, ñá ntaváꞌa ú ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Sáꞌa kākaꞌan Isaiá san, tsí nte díꞌna íni ña nté koo naxiꞌí nuu kaꞌnu Jesuú ne, kakaꞌan ñá kuenta iña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ntá tsi tɨtɨ́n ña odo nūú san ne, kuīntiꞌxe ña ña. Ntá tsi ña ni káꞌān ditó ña méꞌñū ñaꞌa san, tsí da xé ūꞌví ña ña fariseú san tē da natava ña ña má viꞌī mí ntánataká nuu ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tsí dií ka ntio ña é vāꞌá koo kaꞌan ñáꞌa san iña ñá, naa i é vāꞌá koo kaꞌan Xúva ko īña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Un ntii tsī kéne Jesuu, kakáꞌan ña: —Xoo é kākuintiꞌxe i kó ne, ñá te da mii tsī ú kakuintiꞌxe ña, tsí kakuintiꞌxe ña Uvā kó, ña e táxnūu ko. ");
INSERT INTO mizNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Xoo é kainí i kó ne, kainí ña ña e táxnūu kó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Xuꞌú e kúvi ú ñuꞌu é vēꞌxí u, vexnaxiꞌí nuu u ñuxiví sa vata koo é da xōó ka ñaꞌa, ña é kuintiꞌxe i kó ne, ña káka ña mí nēé san. ");
INSERT INTO mizNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tē xoó kateku i túꞌūn ko, ntá tsi ña káde ntaa ña, ñá te xūꞌú kadā kûꞌvé u iña ña. Tsi ñá te vēꞌxí u ñuxiví sa vata koo é kadā kûꞌvé u iña ñáꞌa san, tsi véꞌxī ú vata koo é na nākáku ña. ");
INSERT INTO mizNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Xoo é ña ntío i ko, é ña káde kuenta túꞌūn kó ne, īó xoo é kadā kúꞌvē í iña ñá tē xee ntúvi é ntɨ̄ꞌɨ. Kidáā ne, niꞌi ña é ntoꞌo ña kuenta iña túꞌūn ko, tsí ña ni kuintíꞌxe ña é kākaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tsí ña te dɨ̄kɨ tsi mií ko kakene túꞌūn é kākaꞌán u san. Tsí Uvā kó, ña táxnūu kó ne, dɨvi ña kākaꞌan ña nté koo kaꞌán u, nté koo nakuāꞌa ú ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iní u tsi túꞌun Uvā kó ne, dɨvī é taꞌxi ntuvi vāꞌá iña nto ntii dañu ntūvi. Xuꞌú ne, da nēé ka túꞌūn é kākaꞌán u ne, kakaꞌán u vatā ó ntio Uvā ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Dā xee étsin viko da táva Xuva kō ña Israee ñuú Egítō ne, ntoo Jesuu ni ña ntɨníꞌi ñā, ntaéꞌxi dadɨɨ ña kuenta kuáa. Ini Jésuu tsí e xée ūra i é ntāka ña ñuxiví sa é kɨ̄ꞌɨn ña, kínakūtúvi dadɨɨ́ ña ni Xuva kō. Nɨɨ kuēꞌen tsí ntuvi kuínima ñá ñaꞌa ña, ña ntoo ñuxiví a. Nté uun ntūvi ñá ni xtuví mii ñā é kuinima ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ntá tsi Júda Iscāriote, iꞌxá Simuún ne, é tsīꞌi tóꞌō e ña váꞌā san dɨ́kɨ ña é diko ña Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesuú ne, é īni ña tsí ntaꞌa Xuva ko vēꞌxí ña ne, é īni ña tsí ntaa xtuku ña ntaꞌa Xuva kō dɨ. E īni ña tsí e xnúu ntaꞌa Xuva ko ña un ntɨꞌɨ nūu i. ");
INSERT INTO mizNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kidáā ne, nákuntītsí ña é tuví ña nú mēsa kán ne, dā nátavā ñá duꞌnu ña, dā kíꞌi ña doó ne, xnteē ñá íꞌxi ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kidáā né, xnūu ña ntute ini tɨtiꞌí ne, éni ntuꞌu ñā nákate ña dɨ́ꞌɨn ña ntɨniꞌi ñā, da naítsi ñá doo é ntee íꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Dā xee ña mí tuví Simuun Pedrú ne, kakaꞌán Pedrú san ni ñā: —¿Vá dɨvi ntu nto nākate nto dɨ́ꞌɨ̄n ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Vevií ne, váta kɨ̄ꞌɨn dɨkɨ o nee iña é kade u. Ntá tsi kɨꞌɨn dɨkɨ o rkontûvi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedrú ne, kakaꞌan ñá ni ñā: —¡Nté uun ito ña da váꞌa ko é nakate nto dɨ́ꞌɨ̄n ko! —kaꞌan ña. Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Tē ña nakáte ú dɨ́ꞌɨn ō ne, ñá kadūkun ntéen ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kakaꞌan xtúku Simuún Pedru ni ña: —¡Dukuān ne, ñá te da mii tsi dɨ̄ꞌɨ́n ko nakate nto ni; tsí ntaꞌa kó ni dɨ̄kɨ́ ko dɨ! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesuú ne, kakaꞌan ñá ni ñā: —Xoo e ítsi i ne, ñá ntīo é ntuntoo ká xtuku kanɨɨ̄ kúñu ī, tsí da mii tsi dɨ́ꞌɨn ī kantio é ntōo. Tsi e ntúntoo kanɨɨ̄ kúñu ñā. Kuan ntūntoo nto dɨ́, kuān té ña te un ntɨ́ꞌɨ ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tsí ini ña xoo é diko i ñā. Dukuān é kakaꞌan ña tsí ña te un ntɨ́ꞌɨ ñā e ntúntoo ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Dā kúvī nákate ña dɨ́ꞌɨn ña ntɨniꞌi ñā ne, nákunūu xtuku ña duꞌnu ña. Dā nakutúvi ña nú mesa kán ne, dá kakāꞌan ñá ni ñā: —¿Kañeꞌe dɨkɨ ntú nto nee iña idé u ni ntō? ");
INSERT INTO mizNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ntákaꞌan nto tsí mastru ntó ko, tōꞌó nto kó ne, váꞌā ó vatā o ntákaꞌan nto, tsí dɨvi ntīꞌxe u. ");
INSERT INTO mizNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Te xūꞌu é mastru ntó nī tóꞌo ntō ne, nakate ú dɨ́ꞌɨn ntō né, kuan tsī koo vií nto, nakate nto dɨ́ꞌɨn tāꞌan nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tsí xuꞌu díꞌna ú nañēꞌe ú nto nté koo vií nto ne, kuan tsī koo vií nto vatā o dé u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nuu é ntaā i é kākaꞌán u ni ntō tsí ña te dií ka kaꞌnu ña kade tsiñu san e tóꞌo ñā. Ntē ña te dií ka kaꞌnu ña táxnūu tóꞌo ī san é ña e táxnūu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Te kāñeꞌe dɨkɨ nto sáꞌa ne, kada ntaa ntó ne, dōo diní koo kuntōo nto. ");
INSERT INTO mizNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ʼÑá te kuēnta iña nto un ntɨ́ꞌɨ ntō é kākaꞌán u sáꞌa. Iní u xoo é nakaxnúu u. Ntá tsi kuntaa vatā o úve naꞌa kakáꞌan túꞌun Xuva kō tsi dɨ́vi ñā é kaeꞌxí dadɨɨ nī kó ne, dɨvi ña ntāa ña atá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Sáꞌa kākaꞌán u ni ntō diꞌna da kúvi, vata koo te kúntaá ne, kuintiꞌxe nto é dɨvi ntīꞌxé u. ");
INSERT INTO mizNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nuu é ntaā i é kākaꞌán u ni ntō tsí xoo é kaiko ñúꞌu i ña táxnūu ú ne, kaiko ñúꞌu ña kó dɨ; xoo é kaiko ñuꞌu i kó ne, kaiko ñuꞌu ña ña táxnūu kó dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Dā kúvi kaꞌan Jésuu sáꞌa ne, dōó kuntaꞌxa iní ña ne, kakaꞌan ña: —Nuu é ntaā i é kākaꞌán u ni ntō: Tsí uun ñaꞌa nto ne, diko ntō ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ito ña ntɨniꞌi Jēsuú san taꞌan ña, xe un xé un ñā, tsi ñá ini ña xoo iña i é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Uun ñaꞌa ñā e dóo kuinima Jésuú ne, tuví ña diñɨ ña, kaeꞌxí ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Īde Simuún Pedrú san ntaꞌa ña nī ña tuví diñɨ Jesuu é tsixeꞌe ña ñā xoó kuenta iña í é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kidáā ne, diin diin tsi katsixeꞌe ña Jēsuu: —Mastru, ¿xoó ntu é kuān ó kakaꞌan ntó san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nantíko kōó Jesuu, kakáꞌan ña: —Dɨvi ñā é kuēꞌé u tañúꞌū é xnūu ntoꞌo ú san —kaꞌan ña. Kidáā né, xnuu ntoꞌo ña uun taꞌvī tañúꞌū sán ne, xéꞌe ñā Júdā, iꞌxá Simuun Scarioté san. ");
INSERT INTO mizNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Dā éꞌxi Júdā san tañúꞌu sán ne, ura tsí i kukɨ́ꞌvi tóꞌō e ña váꞌā sán nima ña. Kidáā ne, kakaꞌan Jésuu ni ña: —Kantɨ́ꞌɨ dúꞌva tsi viin nee iña é ncho viin —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ntá tsi nté uun ña ntoo ntaéꞌxi nú mesá san ña ni kutúni ña nté kui kuān ó kakaꞌan ñá ni ña sāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tsi Júdā sán ne, dɨ́kɨ i ña, ña nteé ntaꞌa i diúꞌun san. Iō ñá kuiní ña ne, kakaꞌan Jésuu ni ñá tē kíkuiín ña é kantio ña iña vikó san, o te kuēꞌé ña diuꞌun ña ntâꞌví san. ");
INSERT INTO mizNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ura tsí i da kúvi éꞌxi Júdā tañúꞌū sán ne, kīi ña kueꞌen ña é nīñu. ");
INSERT INTO mizNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Dā kíi Júdā san kuéꞌen ñá ne, kakaꞌan Jésuu: —Vevií ne, xuꞌu é vēxkúvi ú ñatīí ne, kaxiꞌí nuu kaꞌnu u. Dukuān ne, kaxiꞌí nuu kaꞌnu Xuva kō dɨ́ kuenta iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Te kāxiꞌí nuu kaꞌnu Xuva ko kuēnta iñá ko ne, kanaxiꞌí nuu kaꞌnu ña kó vatā ó kaxiꞌí nuu kaꞌnu mii ñā ne, ura tsí i kuan kōo vií ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Iꞌxá miī kó, ña náꞌā ká kutuví dadɨɨ ú ni ntō. Nantuku ntō ko, ntá tsi, vatā ó kakaꞌán u nī ña Israeé san ne, kuan kōo kaꞌán u ni ntō dɨ tsí ña kuvi kɨ́ꞌɨn ntō mí kɨ̄ꞌɨ́n u. ");
INSERT INTO mizNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Xtuvī niꞌí u nto túꞌūn xeé san: é na kuīnima ntó taꞌan nto, xe un xé un ntō. Vata tsī ó kakuinimá ko nto ne, kuan tsi koo na kuīnima ntó taꞌan nto dɨ́, ");
INSERT INTO mizNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","vata koo tē íni ñaꞌa san tsi ntákuinima ntó taꞌan nto ne, kutuni ña tsi ntántīkɨn ntó ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kakaꞌan Símuun Pedru ni ña: —¿Míꞌi ntu kɨ̄ꞌɨn nto, Tóꞌō? —kaꞌan ña. Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Mí kɨ̄ꞌɨ́n u ne, ña kúvi kɨ̄ꞌɨn ní ko vevii, ntá tsi da nté rkontûví ne, nakuntîkɨ́n ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedrú ne, kakaꞌan ñá ni ñā: —Tōꞌó, ¿nté kui ña kuvi ntu kuntikɨ́n u nto vevii? ¡Kuān te kuéꞌe ú ntuvi iñá ko kuenta iña nto! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nantíko kōo xtúku Jesuu, kakáꞌan ñá ni ñā: —¿Vá nuu é ntāa ntíꞌxe ntu i é kuēꞌen ntuvi iña o kuénta iñá ko? Tsí nuu é ntaā i é kākaꞌán u ni ō tsí diꞌna dá kāna lɨ́ꞌxɨ̄ sán ne, úni īto kaꞌan tsi ñá inín ko xoo ñáꞌa u —kaꞌan ña—. ");
INSERT INTO mizNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ʼÑá ku dē kuení nto. Kuntee inī ntó Xuva kō né, kuntee inī ntó ko dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Má viꞌi Uvā kó ne, dōó īo mí kuntoo ō. Tē dɨ́ ña kuān ó ne, ñá ni kāꞌán u ni ntō. Kɨ́ꞌɨ̄n ú, kixtúvi tuꞌvé u mí kuntōo nto. ");
INSERT INTO mizNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Te kuēꞌén u é xtūví tuꞌvé u mí kuntōo nto ne, kiꞌxi xtuku ú, kixnakueká u nto, vata koo é kuntoo dadɨɨ nto nī ko mí kutuví u. ");
INSERT INTO mizNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ini ntó itsi san é xēe nte mí kɨ̄ꞌɨ́n u —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kakaꞌan Túmaá san ni ñā: —Mastru, ñá īní ntɨ míꞌi kɨ̄ꞌɨn nto. ¿Ntē ntú koo naníꞌi ntɨ itsi i san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ne, kakaꞌan Jésuu ni ña: —Xuꞌu e kúvi u ítsi nto; kakaꞌán u é nuu é ntaā i né, tāꞌxi ú ntuvi iña nto. Xoxó kuvi xee i ntáꞌa Uvā kó tē ña te kuénta iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tē dɨ́ ini ntíꞌxe nto kó ne, ini ntó Uvā kó dɨ. Nte vevií ne, é īni ntó xoo ñáꞌa ña, tsi é dukuan īní nto ña dɨ —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kakaꞌan Félipé san ni ñā: —Nañēꞌe ntó ntɨ Uva ntō ni. Kuan tsī kaa é ntio ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kakaꞌan Jésuu ni ña: —¿Nté ō ntu, Felipe? Ñá te dā vévii ntoo dadɨɨ ú ni ntō né, ¿ntē vata kinín ko? Xoo e íni i kó ne, é īni ñá Uvā kó dɨ. ¿Nté kuān ó kaikan ntun é nañēꞌé u o Uvā ko? ");
INSERT INTO mizNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Vá ñā ntu te kákuintiꞌxe o tsi úun tsī kúvi ú ni Uvā ko, tsi úun tsī kúvi Uvā kó nī kó dɨ? Tsi túꞌūn san é kākaꞌán u ni ntō ne, ñá te dɨ̄kɨ tsi mií ko katavá u, tsí Uvā kó e nuu méꞌñu nuu dava ñā kó ne, mii ñā kade ña nuu i e dóo vaꞌá san. ");
INSERT INTO mizNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na kuīntiꞌxe nto ko é kākaꞌán u tsi úun tsī kúvi ú ni Uvā kó ne, uun tsi ña nī kó dɨ. Tē ña ntákuintiꞌxe nto é kākaꞌán u ne, kuān te nuu i é kadé u san na kuīntiꞌxe nto. ");
INSERT INTO mizNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nuu é ntaā i é kākaꞌán u ni ntō tsí te xōo ñáꞌa é kuintiꞌxe ña kó ne, vií ña nuu i é kadé u dɨ. Ō dií ka kaꞌnu ká nuu i vií ña, tsí ntaa u mí tuvi Úvā ko. ");
INSERT INTO mizNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Da nēé ka nuu i é kākan ntó ntaꞌa kó ne, vii ú vata koo é xīꞌí nuu kaꞌnu Uvā kó kuenta iñá ko, xuꞌu é Iꞌxā ña. ");
INSERT INTO mizNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Da nēé ka ntɨꞌɨ nūu i é kākan ntó ntaꞌa kó ne, taꞌxí u nto. ");
INSERT INTO mizNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ʼTē ntákuinima ntíꞌxe ntō kó ne, kada ntaa nto túꞌūn é xtūví u. ");
INSERT INTO mizNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kákān ú ntaꞌa Uvā kó, na taxnūu ña uun ñaꞌa, ña é xntii ntō né, kunuu méꞌñu kunuu dava ña nto ntii dañu ntūvi. ");
INSERT INTO mizNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Espíritu sāꞌá ne, dɨvi ñā é tāꞌxi ña é kūtuni nto nee iña é nuu é ntaā i. Ña kúvi kuintīꞌxe ña ñuxiví sa ña, tsí ña kuvi kiní ña ña, ntē ñá īni ñá xoo ñáꞌa ña. Ntá tsi dɨvi ntō ne, ini ntó ña, tsí nuu ña nima ntó ne, nuu méꞌñu ña ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ʼÑá te tsoo mii kuēꞌén u nto, tsí kiꞌxi xtuku ú mí ntoo nto. ");
INSERT INTO mizNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ña náꞌā ká kukuii dā ña kiní ka ña ñuxiví san ko. Ntá tsi dɨvi ntō ne, kiní nto ko. Tsí niꞌi nto ntúvi iña nto vatā ó īó ntuvi iñá ko dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ntuvi tsikán ne, kutuni nto tsí uun tsi kúvi ú ni Uvā kó ne, uun tsi kúvi nto nī kó ne, kuan dɨvī ú ni ntō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Xoo é kaeni tutun i túꞌūn é xtûví u ne, kade ntaa ña ne, dɨvi ñā é kākuinima ntíꞌxe ña ko. Xoo é kākuinima í ko ne, kuinima Úvā kó ña dɨ. Xuꞌú ne, kuinimá ko ñá dɨ ne, ntii dîtó u é kīni ñá ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Júdā, ña uun san, ña é ña te Iscarioté ne, kakaꞌan ñá ni Jēsuu: —Mastru, ¿nté kui ntii díto nto nuú ntɨ ne, ntá tsi nuu ñá ñuxiví san ne, ña ntii díto nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nantíko kōó Jesuu, kakaꞌan ñá ni ñā: —Xoo é kākuinima í ko ne, kade ntaa ña túꞌūn e xtûví u. Kuinima Úvā kó ña ne, kixkuntoo dadɨɨ ntɨ́ ni ña, ntuví u ni Uvā ko. ");
INSERT INTO mizNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Xoo é ña kákuinima í ko ne, ñá kāde ntaa ña túꞌūn é kākaꞌán u. Tsi túꞌūn é kākaꞌán u ni ntō ne, ñá te dɨ̄kɨ mií ko é kākaꞌán u, tsí dɨvi tūꞌún Uvā ko, ña é táxnūu ko. ");
INSERT INTO mizNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ʼNúu i sāꞌa kakaꞌán u ni ntō viꞌi a tuvi dukuán ka ú ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ntá tsi Espíritū Sántū san, ña é xntii ntō, ña é táxnuu Uvā kó kuenta iñá ko ne, dɨvi ña nañēꞌe ñá nto é un ntɨꞌɨ nuū i. Taꞌxi ña é nakaꞌan nto un ntɨꞌɨ̄ é kākaꞌán u ni ntō nte díꞌna. ");
INSERT INTO mizNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ʼTe kuēꞌén u ne, taꞌxí u é vāꞌá koo kuntōo nto, vatā ó tuví u, ñá te vatā ó kataꞌxi ña ñuxiví sa. Ñá ku dē kuení nto; ntē ña ku uꞌví nto. ");
INSERT INTO mizNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tsí kakaꞌán u ni ntō é kɨ̄ꞌɨ́n u, ntá tsi kiꞌxi xtuku u é kutūví u ni ntō. Te nūu é ntaā i é ntákuinima ntó ko ne, kūntoo dínī nto, tsí kakaꞌán u tsi kɨ́ꞌɨ̄n ú ntaꞌa Uvā ko. Tsí dií ka kaꞌnu Uvā ko é xuꞌu. ");
INSERT INTO mizNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Sáꞌa kākaꞌan ntáa ú ni ntō diꞌna dá kūvi vata koo é, tē kúntāá ne, kuintiꞌxe nto kídaā. ");
INSERT INTO mizNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ʼÑá kuēꞌé ka kaꞌán u ni nto vē, tsi véꞌxī é kadē kûꞌve ñuxiví sa. Ñá tē neé kuvi vií nī ko, ");
INSERT INTO mizNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ntá tsi vií u vata ō kaꞌan Úvā kó, vata koo é kūtuni ñá ñuxiví sa tsi dóo kakuinimá ko Uvā ko. Nakuntáñɨ̄ ntó ve, dá kɨ̄ꞌɨn o —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kakaꞌan xtúku Jesuu: —Xuꞌu é vata kaa xoꞌo tɨntiꞌo é nuu é ntaā i kaá u. Uvā kó ne, dɨvi ñā é kuēnta káde ña. ");
INSERT INTO mizNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Te ūun ntidin i ña kakíi tɨntiꞌo í ne, kaꞌnté ña. Ntá tsi te kakii tɨntiꞌo í ne, kaꞌnté ntodo ñá nuu i vata koo é kuēꞌe kɨ́tɨ i kii tɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ntoꞌó ne, é ntūntoo nto kuenta iña túꞌūn é kākaꞌán u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kuve taꞌan nto kó vatā ó ntee táꞌan ú nto. Tsí te da mii tsi ntīdin i sán, tē ña ntee táꞌan xoꞌo i sán ne, ña kúvi kīi kɨtɨ i. Kuan ntōꞌó dɨ, nté uun nto ña te neé kuvi vií nto tē ña ntee táꞌan nto ko. ");
INSERT INTO mizNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ʼXuꞌú ne, xoꞌo i kúvi u; dɨvi ntō né, ntidin ī kúvi nto. Xoo é ntee táꞌan i kó ne, ntee táꞌan ú ña dɨ́ ne, dōó kueꞌe é vāꞌá vií ña. Tē ña te ntee táꞌan nto kó ne, ñá tē neé kuvi vií nto. ");
INSERT INTO mizNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Xoó ñaꞌa é ña ntee táꞌan i kó ne, kiñuꞌu ña ña kíꞌi kān vata kaa ntidin i e kádun e ntánakuido ñaꞌa san e ntátsuꞌun ña nchúꞌun kān é kōko. ");
INSERT INTO mizNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ʼTe kunteē táꞌan nto kó, te kunuu inī nto túꞌūn kó ne, kákan nto da nēé ka é ntio nto ne, níꞌi ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Dōo xiꞌí nuu kaꞌnu Xuva ko tē dóo kuēꞌe núu i é vāꞌa vií nto. Kuan kōo ntuvi ntíꞌxe nto ña ntɨniꞌī ko. ");
INSERT INTO mizNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Vatā ó kakuinima Úvā kó ko ne, kuān ó kakuinimá ko ntó dɨ. Ñá ku xtuvī mii nto é kāka nto itsí ko, tsi dóo kakuinimá ko nto. ");
INSERT INTO mizNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Te kāda ntaa nto túꞌūn é xtūví u ne, ña xtúvī mií u é kākuinimá ko nto, vatā o dé ntaa u é kākaꞌan Úvā kó ne, ñá kaxtuvī mii ña é kākuinima ñá ko dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ʼKakaꞌán u ni nto sāꞌá vata koo é na kūntoo dínī ntó nī kó vatā ó tuvi dîní u dɨ. Kidáā ne, kunuu díni kueꞌén nima nto. ");
INSERT INTO mizNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sáꞌā e túꞌūn ko é xtūví u: Na kuīnima ntó taꞌan nto vatā ó kakuinimá ko nto. ");
INSERT INTO mizNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Te nūu é ntaā i é kākuinima kuéꞌen ko ña e dóo váꞌa tiin niꞌi ō ne, un tsi nte ntúvi iña ko kuéꞌe o kuēnta iña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ntoꞌó ne, ña e dóo váꞌa tiin niꞌī ú nto te viī nto é kākaꞌán u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Viꞌi a vé ne, ñá kāꞌán ka u te ña ntáde tsiñu iñá ko nto, tsí ña ntáde tsiñu sán ne, ñá īni ña neé kade tóꞌo ñā. Ntá tsi ña e dóo váꞌa tiin niꞌī ú kakaꞌán u nto, tsí kakaꞌan ntɨ́ꞌɨ ú ni ntō nee iñá kakaꞌan Úvā kó nī ko. ");
INSERT INTO mizNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ña te dɨ́vi ntō nakaxnúu ntō ko, tsí xuꞌu nakaxnúu ú nto ne, teé tsiñú u nto é kɨ̄ꞌɨn nto, kinakáxa nto é vāꞌá san vata koo é na xntiī. Kidáā né, da nēé ka nuu i é kākan ntó ntaꞌa Uvā kó kuenta iñá ko ne, níꞌi ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sáꞌa tsī é xtūví u é viī nto: é na kuīnima ntó taꞌan nto. ");
INSERT INTO mizNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ʼTē ntaínchuꞌvi ñá ñuxiví san ntó ne, na kūtuni nto tsí diꞌna u ínchuꞌvi ñá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tē dɨ́ kudadɨɨ nto nī ña ñuxiví san ne, dōó ntio ña nto. Ntá tsi ña te iꞌa ntáduku ntée ká nto, tsí nakaxnúu ú nto ñuxiví san. Dukuān ne, ntaínchuꞌvi ñá nto. ");
INSERT INTO mizNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nanūꞌu ntó iní nto túꞌūn é kākaꞌán u ni ntō: Tsi nté uun ña kade tsiñu ne, ñá tē dií ka kaꞌnu ñaꞌa ña e tóꞌo ñā. Vata ō dé xení ña nī kó ne, kuan kōo kada xení ña ni ntō dɨ. Tē dɨ́ ni dē ntaa ña túꞌūn kó ne, kada ntaa ña e ntákaꞌan ntó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Un ntɨꞌɨ sāꞌá nantōꞌo ña nto kuenta iñá ko, tsi ñá īni ña ña táxnūu ko. ");
INSERT INTO mizNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ʼTē dɨ́ ña ni kíꞌxi u é kixkaꞌán u ni ñā ne, ña túvi kuētsí ña. Ntá tsi vevií ne, ña túvī ká dokaꞌan núu ini kuenta iña kuétsi ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Xoo é kainchuꞌví ko ne, kainchuꞌvi ña Úvā kó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ña túvi kuētsí ña tē dɨ́ ña ni īní ña nuu i é idé u e nté uun ká xtuku ñaꞌa ña kuvi vií ña. Ntá tsi kuān te íni ñá ko ne, ntē dúkuan ña ntío kueꞌen ñá ko, nté Uvā kó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ntá tsi kuan ō kúvi vata koo é ntūntaa mí ūve naꞌa lei íña ña é kākaꞌan: “Īnchuꞌvi ñá ko é ntē ña tuví nee nuu i”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ʼNtá tsi tē xee Espíritū é nuu é ntaā í san, ña véꞌxi ntaꞌa Uvā ko é xntii ña ntō né, dɨvi ña ntāda ntaa ña kuenta iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Dɨvi nto ntāda ntaa nto kuenta iñá ko dɨ, tsí ntoꞌó ne, intóo dadɨɨ ō un tsi nte dá iñɨ ntuꞌu. ");
INSERT INTO mizNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ʼNúu i sāꞌá kakaꞌán u ni ntō vata koo é ña natɨvi iní nto e ntántīkɨn ntó ko te kúvi. ");
INSERT INTO mizNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tsí nakunu ña nto má viꞌī mí ntánataká nuu ña Israeé san. Xée ntūvi te xoó kaꞌní i nto ne, tsiñu Xuva kō kade ña, kuiní ña. ");
INSERT INTO mizNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sáꞌa viī ñá ni ntō tsí vata kiní ña Uvā kó, nté xūꞌú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ntá tsi kakaꞌán u sáꞌa ni ntō vata koo tē xee ntúvi tsīkán ne, nanuꞌu ntó iní nto tsí dɨvī é kākaꞌán u ni ntō. ʼÑá ni kāꞌán u ni nto sāꞌá nte dá iñɨ ntuꞌu, tsí da xé tuví dadɨɨ ká u ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ntá tsi vevií ne, kɨ́ꞌɨ̄n ú ve, kínakutúvi dadɨɨ ú nī ña táxnūu ko. Nté uun nto ña kátsixeꞌe ntō ko mí kɨ̄ꞌɨ́n u. ");
INSERT INTO mizNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Da uun kakuvi, dōó ntoo ntaꞌxa nto é kuan ō kaꞌán u ni nto sāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ntá tsi kakaꞌan ntáa ú ni ntō tsí dií ka váꞌā o íña nto é kɨ̄ꞌɨ́n u. Tsí tē dɨ́ ña kɨ́ꞌɨn ú ne, ña kúvi kīꞌxi ña é xntii ntō. Ntá tsi te kuēꞌén u ne, taxnūu ú ña é kunuu méꞌñu ña ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te vēꞌxí ña ne, nañeꞌe ñá ña ñuxiví san nee iña é kuētsí ña, nee iña é vāꞌá koo vií ña ne, nté koo kada kúꞌve Xúva ko īña ña dɨ: ");
INSERT INTO mizNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","kuenta iña kuétsi ī é ña ni kuintíꞌxe ña ko; ");
INSERT INTO mizNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kuenta iña i é viī ña é vāꞌa, tsi kɨ́ꞌɨ̄n u mí tuví Uvā kó ne, ñá kīní ka ntó ko; ");
INSERT INTO mizNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","kuenta iña i é kadā kûꞌvé Xuva ko īña ñá vatā o dé ña ni ña odo nūú iña ñá ñuxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ʼDōó tɨtɨ́n ka nuu i é ncho kaꞌán u ni ntō, ntá tsi ña kutíi nto é tēku ntɨ́ꞌɨ nto vevii. ");
INSERT INTO mizNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ntá tsi te vēꞌxi Espíritū é nuu é ntaā í san ne, nañēꞌe ñá nto é un ntɨꞌɨ̄ nee iña é nuu é ntāa ntíꞌxe i. Tsi ñá te dɨ̄kɨ tsi mii ña káꞌan ña, tsí nee iña é tekū ñá ne, dɨvī é kaꞌan ñá ni nto ne, nañēꞌe ña nto nté koo kuvi rkontûvi. ");
INSERT INTO mizNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dɨvi ñā né, kada kaꞌnu ña ko, tsí niꞌi ña nee iña e iñá ko ne dá taꞌxī ña é kūtuni nto. ");
INSERT INTO mizNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Un ntɨꞌɨ̄ é īó iña Uvá ko ne, kaduku ntée ú dɨ. Dukuān é kākaꞌán u tsí nañēꞌe ñá nto nee iña iñá ko é nīꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ʼÑa náꞌā ká kiní nto ko, ntá tsi ña naꞌá ka xtúku ne, nakiní xtuku nto ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kidáā ne, iō ñá ntɨniꞌi Jēsuú ne, tsixeꞌe tāꞌan ña xe un xé un ñā: —¿Nee iñá ntu kani túꞌun sáꞌa é kākaꞌan ñá ni kō tsí ña naꞌá ka kiní o ñā ne, ña náꞌā ká xtuku ne, nakiní xtuku o ñā, tsí kɨꞌɨn ñá ntaꞌa Uva ñā? ");
INSERT INTO mizNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Nee iñá ntu kani túꞌun é kākaꞌan ña é ña naꞌá ka? Ñá kāñeꞌe dɨkɨ kó ne nuu i é kuān ó kakaꞌan ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kūtuni Jésuu tsí ncho tsixeꞌe ña ña kuenta iña i sáꞌa ne, kakaꞌan ñá ni ñā: —¿Ntátsixeꞌe taꞌan ntu ntō nee iñá ncho kaꞌán u dā kaꞌán u tsí ña naꞌá ka kiní nto ko, ña náꞌā ka dá nakīní xtuku nto ko? ");
INSERT INTO mizNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nuu é ntaā i é kākaꞌán u ni ntō tsi kuéku nto ne, kuntaꞌxa iní nto dɨ, nɨɨ̄ dukuan ña ñuxiví san ne, kuntoo dínī ña. Ntá tsi kuān te kuntaꞌxa iní nto vevií ne, rkontûví ne, nadama dontaꞌxá san dodîni. ");
INSERT INTO mizNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Vata kaa ñadɨ̄ꞌɨ, ña é dā vé kaku iꞌxá i ne, kantɨꞌɨ iní ña tsí e xee úra i. Ntá tsi tē kúvī káku iꞌxá ña ne, kunánī ñá e kaexnúu kúñu ña, tsi dóo diní ña kuenta iña i e káku iꞌxá ña é dā vé xee ñúxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Dɨvi ntō dɨ́ ne, ntántɨꞌɨ iní nto vevii. Ntá tsi nakiní xtuku ú nto ne, nakuꞌun dîní nima ntó kídaā, uun dodîni e nté uun xoxo kuvi kaꞌnté nuu i. ");
INSERT INTO mizNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ʼNtuvi tsikán ne, ñá tē neé tsixeꞌē ká nto ko. Nuu é ntaā i é kākaꞌán u ni ntō tsí da nēé ka ntɨꞌɨ nuu i é kākan ntó ntaꞌa Uvā kó ne, taꞌxi ña te kākan ntó kuenta iñá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Vevií ne, váta kākan nto nté uun nuu i kuenta iñá ko. Kákan ntō ne, níꞌi ntō, vata koo é kūntoo díni kueꞌen nto. ");
INSERT INTO mizNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ʼKantada dadɨɨ ú nuu i sáꞌa, kakaꞌán u ni ntō. Ntá tsi véꞌxī ntuvi é ña te kuan koo kaꞌán ka u, tsí kaꞌan ntáa ú ni nto īña Uvá ko. ");
INSERT INTO mizNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ntuvi tsikán ne, kákan nto kuenta iñá ko. Ntá tsi ña te kakaꞌán u ni ntō te kākán u ntaꞌa Uvā kó kuenta iña nto. ");
INSERT INTO mizNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tsi Úvā kó ne, mii ñā dóo kakuinima ñá nto, tsí da xe ntákuinima ntó ko ne, ntákuintiꞌxe nto é vēꞌxi ú ntaꞌa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tsí ntaꞌa Uvā ko kíi ú, véꞌxī ú ñuxiví sa. Vevií ne, ntaka ú ñuxiví sa dá ntāa xtuku u mí tuví Uvā ko —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ntákaꞌan ñá ntɨniꞌi ña ni ñā: —Vevií ne, kakaꞌan ntáa nto, é ña te kántada dadɨɨ ká nto. ");
INSERT INTO mizNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","É īní ntɨ ve tsi íni nto un ntɨɨ́ ntɨ̄ɨ núu i. Ntē ña ntio é xoxo tsixéꞌe i ntō. Dukuān e ntákuintiꞌxe ntɨ tsi véꞌxi nto ntaꞌa Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —¿Ntákuintiꞌxe ntu nto ve? ");
INSERT INTO mizNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ntá tsi e xée ūra í ne, vevií duꞌva tsi nakuite xáa nto. Da díta da díta xnto itsi nto, xtuvī mii ntó ko. Ntá tsi ña te da mii tsí u tuví u, tsí tuvi niꞌi Úvā kó ko. ");
INSERT INTO mizNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kakaꞌán u ni nto un ntɨꞌɨ sāꞌá vata koo é kūntoo váꞌa nto, xoo é kantīkɨn í ko. Ñuxiví a ne, dōó ntoꞌo nto. Ntá tsi kaꞌxi vií nto nima ntó, tsi e kúvi idé u ni ñūxiví sa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Dā kúvi kaꞌan Jésuu núu i sáꞌa ne, ntāa niꞌi ña nuu ñá e dukún kān, dá kakāꞌan ña: —Ūva, e xée ūra í ve. Nāxiꞌí nuu kaꞌnu nto kó, xuꞌu é Iꞌxā ntó ve, vata koo é nāxiꞌí nuu kaꞌnu ú nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tsi táꞌxi nto tsiñu ko é kodo nūú u iña un ntɨꞌɨ kueꞌen dúꞌva ñaꞌa san vata koo é kuēꞌé u ntuví vaꞌá iña ña ntii dañu ntúvi, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña e nátsuꞌun ntaꞌa nto ko. ");
INSERT INTO mizNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sáꞌā é ntuvi vāꞌá iña ña: te īni ñá nto, dɨvi ntō é Xuva ntiꞌxe ko nto, ni Jesūcristu, xuꞌu e táxnūu nto. ");
INSERT INTO mizNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ʼXuꞌú ne, é dē kaꞌnu ú nto ñuxiví sa. É nantɨ́ꞌɨ u tsiñu e teé tsiñu nto ko é vīí u. ");
INSERT INTO mizNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Vevií ne, naxiꞌí nuu kaꞌnu nto kó ntaꞌa nto ve, Ūvá, vata tsī o náxiꞌí nuu kaꞌnu nto kó ntē díꞌna dá iñɨ ntuꞌu ñúxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ʼÑa é nakaxnúu nto iꞌa ñuxiví sa é tsuꞌun ntaꞌa ntō kó ña ne, é nañēꞌé u ña xoo é dɨvi ntō. Tsí dɨvi īña ntó ña ne, nátsuꞌun ntaꞌa ntō kó ña ne, dɨvi ñā kuíntiꞌxe ña túꞌun ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ini ñá ve tsí da nēé ka nuu i e táꞌxi nto kó ne, ntaꞌa nto véꞌxi. ");
INSERT INTO mizNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tsi é nañéꞌe ú ña túꞌūn e táꞌxi nto ko. Tēkú ña ne, kutuni ña é nuu é ntaā i tsí ntaꞌa nto véꞌxi u. Kuīntiꞌxe ña tsí dɨvi ntō táxnūu nto ko. ");
INSERT INTO mizNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ʼMiī ña é kaikán u kuenta iña ña. Ñá te kuēnta iña ñá ñuxiví san, tsí kuenta iña ña e táꞌxi nto ko, tsí dɨvi īña nto ña. ");
INSERT INTO mizNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Un ntɨꞌɨ̄ nee iñá īó iñá ko ne, íña ntō dɨ; nee iña é īña ntó ne, íñā kó dɨ. Dɨvi ñā ne, náxiꞌí nuu kaꞌnu ña ko. ");
INSERT INTO mizNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ʼXuꞌú ne, ñá kutūví ka ú ñuxiví sa, ntá tsi dɨvi ñā né, kuntōo ká ña ñuxiví sa. Tsí xuꞌú ne, kɨ̄nakutúvī ú ni ntō. Ūvá, dɨvi ntō é vāꞌá kueꞌen nto ne, kūnuu méꞌñu kunuu dava nto ña e táꞌxi nto ko vata koo é uun tsi kuvi ña vatā ó uun tsi kúvī ú ni ntō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dā itúvi dadɨɨ ú ni ñā iꞌa ñuxiví sa ne, xuꞌú nadaꞌan ú ña kuenta iña ntó, un ntɨɨ́ ntɨɨ̄ ña e táꞌxi nto kó ne, īde ú ña kuenta. Nté uun ñaꞌa ña ña ni kunáa ña (da mii tsi ñā e dúkuan kúnaá san), vata koo é kuntaa vatā ó uve naꞌa kakaꞌan túꞌun ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ʼViꞌi a vé ne, ntiko kōó u mí tuví nto dan. Núu i sāꞌá kakaꞌán u da tuví ka u ñuxiví sa vata koo é na nākuꞌun dîni nima ñá vatā ó nuu dîni nimá ko dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","É nakuéꞌe ú ña túꞌun ntō. Ntá tsi ña ñuxiví sa ne, ntaínchuꞌvi ñá ña, tsí ña te ntáduku ntée ká ña ñuxiví sa vata kaa u é ntē ña te ña ñuxiví sa ú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ñá te kaīkán u ntaꞌa nto te natavā ntó ña ñuxiví sa, tsi é na kūnuu méꞌñu kunuu dava nto ña nuu i é kīni kaa san. ");
INSERT INTO mizNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ñá te ntáduku ntée ña ñuxiví sa, vata kaa ú xuꞌú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kuéꞌe ntō é viī ñá da mii kuēꞌen tsi é vāꞌa é ntio nto, tsí ini ña túꞌun ntō é nuu é ntaā i. ");
INSERT INTO mizNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Vata ō táxnuu nto kó ñuxiví sa ne, kuan koo taxnūu ú ña méꞌñū ña ñuxiví sa dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kuenta iña ñá ne, ntada ú ntuvi iñá ko kuenta ntáꞌa nto vata koo é na ntāda ña ntuvi iña ña kuénta ntáꞌa nto dɨ é na viī ñá nee iña é nuu é ntaā i. ");
INSERT INTO mizNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ʼÑá te da mii tsi kuēnta iña ña sáꞌa é kākaꞌan ntâꞌví u, tsí kuenta iña ña é kuintiꞌxe i ko rkontûvi kuenta iña túꞌun ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kaikan u é uun tsi na kūvi ña, un ntɨ́ꞌɨ ñā, vata tsi kaa o xoꞌō dɨ́, Ūva, é uun tsi kúvī ú ni ntō ne, uun tsi kúvi nto nī kó dɨ. Te uun tsi na kuvi ña ni kō dɨ vata koo é na kuīntiꞌxe ña ñuxiví sa tsí dɨvi ntiꞌxe ntō táxnuu nto ko. ");
INSERT INTO mizNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Naxiꞌí nuu kaꞌnu ú ña vatā ó naxiꞌí nuu kaꞌnu nto kó vata koo é uun tsi na kūvi ña vata kaa ú ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tsi úun tsi kúvī ú ni ñā ne, uun tsi kúvi nto nī kó dɨ, vata koo é uun tsi kuvi ntiꞌxe ña. Kidáā ne, kutuni ñá ñuxiví sa tsí dɨvi ntō táxnuu nto kó ne, dōó kakuinima ntó ña vatā ó kakuinima ntó ko dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ʼŌ Úva, dɨvi ntō tsúꞌun ntaꞌa nto ñā kó ne, ntio ko é kuntoo dadɨɨ ña nī ko mí kutūví u, vata koo é na kinī ñá ko é kāxiꞌí nuu kaꞌnu ú ntaꞌa nto. Tsí kakuinima ntó ko un tsi nte díꞌna dá iñɨ ntuꞌu ñúxiví sa. ");
INSERT INTO mizNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ō Úva, dɨvi ntō e dóo vaꞌá nto. Ña ñuxiví sa ne, ñá īni ñá nto. Ntá tsi xuꞌú ne, iní u nto ne, ña sāꞌá ini ñá tsí dɨvi ntō táxnūu nto ko. ");
INSERT INTO mizNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","É kākaꞌan ntaa ú ni ñā xoo ñáꞌa ntiꞌxe nto ne, kuan kōo vií ka ú dɨ vata koo é na kuīnima ntó ña vatā ó kakuinima ntó ko ne, vata koo é miī ú kutūví u ni ñā —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Dā kúvi kaꞌan Jésuu sáꞌa ne, kuéꞌen ña ni ña ntɨniꞌi ña ūun xo diñɨ xɨꞌntɨ ntúte Cedruun. Ikān kukɨ́ꞌvi ña má utun tatá kan ni ña ntɨniꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Júdā, ña diko Jésuú ne, ini vaꞌá ña ikān, tsi dóo kiꞌin ito kānakuntóo dadɨɨ Jesuu ni ña ntɨníꞌi ña ikān. ");
INSERT INTO mizNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Dukuān né, ntēka Júdā sntadun ni ña ntáde kuenta xúkūn, ña e táxnūu tóꞌō dutú nī ña fariseú san. Xée ña ikān, odo ña ñūꞌú, ni chūꞌun, ni káa é kāꞌní nuu ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ntá tsi é īni Jésuu un ntɨ́ꞌɨ nūu i neé kuvi ña ne, kīi ña, kakaꞌan ñá ni ñāꞌa san: —¿Xoó ñaꞌa ntu ntánantuku ntō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nantíko koō ñá, kakaꞌan ñá ni ñā: —Jesuu, ñá ñuú Nazaree ntánantukū ntɨ́ ña —kaꞌan ña. Kakaꞌan Jésuu ni ña: —Dɨvī ú xuꞌu —kaꞌan ña. Júdā, ña é diko ñá san ne, ntitsí dadɨɨ ña ni ñāꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Dā kaꞌan Jésuu tsí dɨvi ñā ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san nákaka ata ñā; ntāva ña kueꞌen ñá ñuꞌu kān. ");
INSERT INTO mizNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kidáa ne, tsixeꞌe xtūku Jesuu ña: —¿Xoó ñaꞌa ntu ntánantuku ntō? —kaꞌan ña. Ntákaꞌan xtúku ña: —Jesuu, ñá ñuú Nazaree —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Dā nantiko koó xtuku Jesuu, kakáꞌan ñá ni ñā: —É kākaꞌan xtúku ú ni ntō tsí dɨvī ú xuꞌu. Te xūꞌú ntánantuku ntō kó ne, na kɨ̄ꞌɨn ká ña nguiī san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kuan ō kaꞌan ñá vata koo é kūntaa túꞌūn é kāꞌan ña: “Ūvá, ña e táꞌxi nto kó ne, nté uun ña ña ni kunáa ña”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kidáā ne, Simuun Pedru táva nuu ña káa ñā né, dā éꞌnte tuꞌun ña loꞌxo ña káde tsiñu iña dútu ñá odo nūú san; nákɨꞌɨ tūꞌun ñá loꞌxo kuaꞌa ña. Ña kade tsiñu sán ne, Malcu náni ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesuú ne, kakaꞌan ñá nī Pedru kídaā: —Nāxnuu váꞌan káa ō. ¿Vá ñā ntu te ntoꞌó ko dontɨ̂ni é taꞌxi Uvā kó ko é ntōꞌo ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sntadún san, nī tóꞌo ña, nī ña ntáde kuenta xúkūn ña Israeé san ne, tɨ̄ɨn ña Jesuu, da kíꞌni kutu ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Diꞌna intéka ña ña mí tuví Anaa, ñuntɨ́ɨ dūtu ñá odo nūú kuia tsikan, ñá nani Caīfaa. ");
INSERT INTO mizNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Dɨvi Caīfaá ne, é kākaꞌan ñá tsi dií ka váꞌā ó te ūun tsi ñaꞌa kuví ña kuenta iña un ntɨɨ́ ntɨ̄ɨ́ ña ñuu í san. ");
INSERT INTO mizNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ña ntɨniꞌi ñā, ña uun ká san, ni Sīmuun Pedrú ne, ntīkɨn ñá Jesuu. Ini dútu ñá odo nūú san ña ntɨniꞌi ñā, ña é uun sán ne, dukuān ne, kúkɨ̄ꞌví ña ni Jēsuu iní viꞌi dutu ñá odo nūú san. ");
INSERT INTO mizNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ntá tsi Pedrú ne, da nuū ntitsí ña atá xiꞌi kan. Kidáā ne, kuéꞌen ña ntɨniꞌi ñā, ñá ini dútu ñá odo nūú san, kakaꞌan ñá ni tāꞌnu nteé ntaꞌa i xiꞌí san te kūvi kuíta ntíꞌxin Pedru iní viꞌi kān dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Taꞌnu nteé ntaꞌa ī xiꞌí san ne, tsixeꞌē tún Pedru: —¿Vá ña ntu te dɨvi ntō é kantīkɨn ntó ña tsikan? —kaꞌán tun. —Ñaꞌa ní san, ñá te xūꞌu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tsí da xe dóo viꞌxín ne, ña ntáde tsiñu nī ña ntáde kuenta xúkūn sán ne, tūún ña ñuꞌú ne, dā ntátuní ña. Ikān ntitsí dadɨɨ Pedrú san ni ñā, katuní ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kidáā né, tsixeꞌe dūtu ñá odo nūú san Jesuu kuénta iña ñá ntɨniꞌi ñā ne, kuenta iña nchúꞌūn é kanakuāꞌa ña ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Xuꞌú ne, kakaꞌan ntaá u méꞌñū ñaꞌa san un ntɨꞌɨ kueꞌen dúꞌva ña. Nguentúvi tsi nakuāꞌá u ña má viꞌī mí ntánataká nuu ña Israeé san ne, ini ukún kaꞌnu sán dɨ. Nté uun nuu i ña ni káꞌan xuꞌú u. ");
INSERT INTO mizNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Nté kui miī ú katsixeꞌe ntu ntō ko? Tsixeꞌe nto ñāꞌa san, ña téku i nté o kakaꞌán u. Dɨvi ña īni ña nee iña é kākaꞌán u —kaꞌan Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dá kakāꞌan ña sáꞌa ne, uun ñaꞌa ña ntáde kuenta xúkūn sán, ña ntitsí etsin ne, xēꞌe nuu ña vinuu Jesuu, kakáꞌan ñá ni ñā: —¿Nté kui kuan ntū ó kanantiko kōón kakaꞌan ni dútu ñá odo nūú san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Tē ña váꞌa o kakaꞌán u ne, káꞌan nto nee iña é ña váꞌā ó san ni. Ntá tsi te vāꞌá o kakaꞌán u ne, ¿nté kui xéꞌe nuu ntun vinuú ko kuan? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kīꞌni kutu ña ña kídaā né, dā táxnūu Anaá san ña mí tuví dutu ñá odo nūu, ñá nani Caīfaa. ");
INSERT INTO mizNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Da nɨɨ̄ ntitsí Pedru, katúni ña nchúꞌun kān ne, kakaꞌan ñáꞌa san ni ñā: —¿Vá ña ntu te dɨvīn é ntɨniꞌin ña tsīkán dɨ? —kaꞌan ña. Ntá tsi dɨvi ñā ne, kakaꞌan ña: —Ñaꞌá ni san, ñá te xūꞌu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kidáa ne, uun ñaꞌa ña ntáde tsiñu iña dútu ñá odo nūú san, ñaviꞌi ña e éꞌnte Pedru lóꞌxo í ne, kakaꞌan ñá ni ñā: —¿Vá ña ntu te dɨvīn é ini ú o ni ñā má utun tatá kān? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ntá tsi Pedrú ne, kakaꞌan xtúku ña tsi ñá ini ñá ña ne, ura dúꞌva tsi i kána lɨ́ꞌxɨ̄ san. ");
INSERT INTO mizNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kidáā né, ntāka ña nú viꞌi Caīfaá ne, dā kueniꞌi ña Jésuu iní viꞌi mēꞌñú ña ñuú Roma. Dā ve véꞌxi katúvi. Ña Israeé san ne, ña dɨ́ ni kɨ̄ꞌví ña iní viꞌi meꞌñú san vata koo é ña naxeꞌé ña ntaꞌa ña. Tsí te kuan kōo ne, ña kúvi kāꞌxí ña viko san. ");
INSERT INTO mizNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Dukuān né, ntīi Pilatu nu kíꞌi kān, kakaꞌan ña: —¿Neē ntú nuu i ntátsiꞌi kuétsi nto ña sāꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nantíko koō ñá, ntákaꞌan ñá ni ñā: —Tē dɨ́ ña kini kaa ña ne, ña ntádā ntɨ́ ña kuenta ntáꞌa nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kidáā ne, kakaꞌan Pílatu ni ña: —Kueꞌēn niꞌi nto ñá ni. Kada kúꞌvē ntó iña ñá kuenta iñá lei míi ntō —kaꞌan ña. Ntá tsi ña Israeé san ne, ntákaꞌan ñá ni ñā: —Dōo xii kaá te ntɨ̄ꞌɨ kuéꞌe ntɨ doxiꞌi dā xóo ká ñaꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Dukuan ō kúvi vatā ó kakaꞌan Jésuu nté koo kúvi tē xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kidáā ne, kúntɨ̄ꞌví xtuku Pilatu iní viꞌi mēꞌñú san, dā kána ña Jesuu, kátsixeꞌe ña ñā: —¿Vá dɨvin ntūn é Rei iña ñá Israee? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —¿Vá kuēnta iña mii ntú nto é kuān ó kakaꞌan ntó san ne, o dē xé tuku ñaꞌa san kakaꞌan ñá ni ntō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nantíko kōó Pilatu, kakáꞌan ña: —¿Vá ña Israee ntú u? Ña ñuú mii o nī tóꞌō dutú san ne, dɨvi ñā ntáda ña o kuenta ntáꞌa ko. ¿Neé ntu den? —kaꞌan Pilatú san. ");
INSERT INTO mizNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nantíko kōó Jesuu, kakáꞌan ña: —Ñá te ñūxiví sa kade ú rei. Tē dɨ́ ñuxiví sa kade kûꞌvé u ne, nté duꞌxen vīí ña ntáde tsiñu iñá ko vata koo é xoxo ntada í ko kuenta ntáꞌa ña Israeé san; ntá tsi ña te iꞌa káde kûꞌvé u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kakaꞌan Pílatu ni ña kídaā: —¿Vá dukuan ntū é rei ntíꞌxen? —kaꞌan ña. Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Mii nto kākaꞌan nto é reí u. E dɨvi tsiñu káku u. Dukuān ne, véꞌxī ú ñuxiví sa vata koo é kāꞌán u nee iña é nuu é ntaā i. Xoo é ntio i é nuu é ntaā í ne, katekú ña é kākaꞌán u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tsixeꞌe Pīlatu ña kídaā: —¿Nee iñá ntu é nuu é ntaā í kuan? —kaꞌan ña. Dā kúvi tsixeꞌe ña sāꞌá ne, kii xtuku ña, kakaꞌan ñá nī ña Israeé san: —Nté uun kuétsi ña sāꞌá ña kánaniꞌí ko. ");
INSERT INTO mizNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ntá tsi ntoꞌó ne, vatā xkoó ini nto é nantiī ú uun ñaꞌa ña nuu kutū méꞌñū viko sá ne, ¿ntio ntu nto é nantiī ú Rei iña ñá Israee? —kaꞌan Pílatu. ");
INSERT INTO mizNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Un ntɨɨ́ ntɨɨ̄ tsí ñaꞌa san káchuꞌu ña, ntákaꞌan ña: —¡Ñá te ña tsīkan nantii ntó ña, tsí Barabaá san! —kaꞌan ña. Barabaá san ne, ña kaeꞌní ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kidáā né, kīꞌi Pilatú san Jesuú ne, da táxnūu ña é natīnuu ña ña xoꞌo ume. ");
INSERT INTO mizNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sntadún san ne, de váꞌa ña leꞌe e kúvi ntuku íñu, da xntéku ña dɨkɨ Jésuú ne, da xnúu ña ña doo tînta. ");
INSERT INTO mizNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Xée ētsin ña mí ntītsí ña ne, da ntákaꞌan ñá ni ñā: —¡Ntiusi ntó, Rei iña ñá Israee! —kaꞌan ñá, dā kátu nuu ña vinuu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kīi xtuku Pilatú san ne, kakaꞌan ñá ni ñāꞌa san: —Un kaa ña sāꞌa é nantii ú ña nuu nto vata koo é na kūtuni nto tsí ña ni naníꞌi ko nté uun kuétsi ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kidáa ne, ntīi Jesuu é ntēku leꞌe íñu san dɨkɨ ñá ne, nuu ña doo tîntá san. Kakaꞌan Pílatú san ni ñāꞌa san: —¡Un kaa ñatīi saꞌa! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dá ini tóꞌō dutú san nī ña ntáde kuenta xúkūn sán ne, un tsi ntákachuꞌu ña ntákaꞌan ña: —¡Na nākuntée ña ntiká krusi! ¡Na nākuntée ña ntiká krusi! —kaꞌan ña. Kidáā ne, kakaꞌan Pílatú san ni ñā: —Kuēꞌen niꞌi mii nto ñá ni, dá naxnteē ntó ña ntiká krusi kan. Tsí xuꞌú kaꞌán u ne, ña túvī nee kuetsí ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Dā nantíko kōó ña Israeé san, ntákaꞌan ñá ni ñā: —Lei iñá ntɨ ne, kakaꞌan tsí da miī é kuvī ña, tsí dotō tsí kakaꞌan ña é Īꞌxá Xuva ko ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Dā téku Pilatú san sáꞌa ne, dií ka ūꞌvi xtúku ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kúntɨ̄ꞌví xtuku ña iní viꞌi meꞌñú san ne, dá kakāꞌan ñá ni Jēsuu: —¿Míꞌi ntu ñūu véꞌxin? —kaꞌan ña. Ntá tsi Jesuú ne, ñá ni kāꞌan kueꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dukuān ne, kakaꞌan Pílatú san ni ñā: —¿Nté kui ña kakáꞌan ntún nī ko? ¿Vá ña ntu ínin tsí kuvi vií u naxntēe ú o ntiká krusí, o kuvi nakāka xaa ú o? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nantíko kōó Jesuu, kakáꞌan ñá ni ñā: —Ntē ña kuvi kadan kúꞌven īñá ko tē ña te Xuva ko ni taꞌxi ña o. Dukuān ne, dií ka iō kuetsí ña e ntáda kó kuenta ntáꞌa o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nté ūra tsikán ne, ntukū nuu iní Pilatú san nté koo nantīi ña ña. Ntá tsi ña Israeé san ne, un tsi ntákachuꞌu ña ntákaꞌan ña: —¡Te nantii nto ña sāꞌá ne, ñá te vāꞌá tiin nto nī Cesa! tsí te xōo ñáꞌa é kākaꞌan ña é rei ñá ne, kakaꞌan ntée ña Cesá san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Dā téku Pilatu sáꞌa ne, nantíi ña Jēsuu. Kidáā ne, nákutūví ña nú mesa víꞌi meꞌñú san mí nani Gābata, é kāni túꞌun Nú Xūú san é tūꞌun hébreu. ");
INSERT INTO mizNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Dā káꞌñu ntuvi sispre víkó san ne, kakaꞌan Pílatú san nī ña Israeé san: —¡Un kaa rei nto! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ntá tsi un tsi ntákachuꞌu ñaꞌa san ntákaꞌan ña: —¡Kuēꞌen niꞌi ntó ña! ¡Kuēꞌen niꞌi ntó ña! ¡Dá naxnteē ntó ña ntiká krusi kan! —kaꞌan ñáꞌa san. Kakaꞌan xtúku Pilatú san ni ñāꞌa san: —¿Vá naxntēe ntú u rei nto ntíkā krusi kan? —kaꞌan ña. Nántiko kōo tóꞌō dutú san, ntákaꞌan ña: —Xoxó ka xtúku é reí ntɨ, tsí da mii tsī Cesá san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kidáā né, ntāda kuenta Pílatú san Jésuu é na naxnteē ñá ña ntiká krusi kan. Tɨ̄ɨn ña ña né, dā kueꞌen niꞌi ña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ntīi Jesuu, ntéku dokó ña krusi ña, kueꞌen ña mí nani Gōlgota é kāni túꞌun Xkɨdɨkɨ Ntɨ́xɨ kān é tūꞌun hébreu. ");
INSERT INTO mizNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ikān náxnteē ñá ña ntiká krusí san ni ūvi ñaꞌá ka ñatīi. Uun ña nteé ña diñɨ kuaꞌa ña ne, uun ña nteé ña diñɨ datsín ña. Jēsuú ne, nuu méꞌñu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatú san ne, táxnūu ña kuváꞌa taꞌvi rkunū é kuntēé dɨkɨ́ krusí san é kākaꞌan: “Jesuu, ñá ñuú Nazaree, Rei iña ñá Israee”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Dōó tɨtɨ́n ña Israeé san nakuáꞌa ña túꞌūn saꞌá, tsí mi náxnteē ñá Jesuu ntiká krusí ne, ētsin ñuú kaꞌnu. Úni tūꞌún san uve naꞌa: túꞌun hēbreu, latiín, ni tūꞌún griegú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tōꞌó dutu íña ñá Israeé san ne, ntákaꞌan ñá ni Pīlatú san: —Ñá ku xnteē nto: “Rei iña ñá Israee”. Dií ka váꞌā ó te xnteē nto: “Ña é kākaꞌan é Rei iña ñá Israee” —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ntá tsi Pilatú san ne, nantíko koō ñá, kakaꞌan ña: —Ē xntée naꞌa ú ne, é kuan tsī koo —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Dā kúvī náxntēé sntadún san Jesuu ntiká krusí san ne, kīꞌi ña doo ñá ne, dā kátsin dava ña kɨmi taꞌvi. Uun taꞌvi uun taꞌvī niꞌi ñá xe un xé un ñā. Dā kíꞌi ña duꞌnu kani ñá dɨ, ntá tsi duꞌnu ñá ne, kantāa tsi nte dukun i un tsi nte xúꞌu i; ña túvī míꞌi xɨ̄ꞌɨ taꞌan. ");
INSERT INTO mizNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Dukuān ne, sntadún san ne, ntákaꞌan ñá ni tāꞌan ña: —Ñá nakatsin o sāꞌa; dií ka váꞌā ó te nadɨ̄kɨ ó xoo e níꞌi i —kaꞌan ña. Kuan ō dé ña vata koo é kuntaa vatā ó uve naꞌa kakaꞌan túꞌun Xuva kō: “Kātsin dava ña doó ko. Nadɨkɨ ña xoo é nīꞌi i dúꞌnú ko”, kaꞌan. Kuān o dé sntadún san. ");
INSERT INTO mizNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Dɨꞌɨ Jēsuu ni taꞌan dɨ́ꞌɨ ña, María, ñadɨ̄ꞌɨ Cliofa, ni María Madālená ne, ntáñɨ étsin ña nú krusí san mí ntēé Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Dā íni Jesuu dɨ́ꞌɨ ña ni ña ntɨniꞌi ñā, ña e dóo kuinima ñá ne, kakaꞌan ñá ni dɨꞌɨ ñā: —Nakunúu ntaꞌa nto īꞌxá nto dan —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dá kakāꞌan xtúku ña ni ña ntɨniꞌi ñā: —Nakunúun ntaꞌan dɨꞌɨ ō dan —kaꞌan ña. Nté ntūvi tsikán ne, nákunuu ntaꞌa ña ntɨniꞌi ñā sán dɨꞌɨ Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Dā kúvī sáꞌa ne, īní Jesuu tsi é kuntaa ntɨ́ꞌɨ vatā ó uve naꞌa kakaꞌan túꞌun Xuva kō ne, kakaꞌan ña: —Kaitsí ko ntute —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ikān tuví uun kɨ́dɨ ntɨ̄di íā ne, xnuu ntoꞌo ña uun tɨꞌntɨ dóó ne, dā xntídō ñá dɨkɨ chɨ́ɨ̄n ne, da xníꞌni ña xuꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Dā kúvī xíꞌi ña ntɨ̄di íā sán ne, kakaꞌan ña: —É kūntaa ntɨ́ꞌɨ ve —kaꞌan ña. Kidáā né, nāxkaꞌnu nteɨ ña dɨkɨ ñá ne, xíꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ntuvi sāꞌá ne, ntuvī é koo tuꞌve iña víko kaꞌnu san. Ña Israeé ne, ña ni ntío ña é kūve ka kúñu ña ntīká krusi ntuvi dá iō dáꞌna, tsi dóo kaꞌnu ntuvi tsikan. Dukuān ne, kakaꞌan ñá ni Pīlatú san te kuēꞌé ña itsi é kaꞌnu ña xkɨdáꞌnta ña uve ntiká krusí san vata koo é na kūví kantɨ́ꞌɨ ña ne, dá kūvi nanuu nteé ña ña ntiká krusi. ");
INSERT INTO mizNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kidáā ne, kuéꞌen sntādún san, kukaꞌnu ña xɨ̄kɨ dáꞌnta ña ata iko dīñɨ Jesuú san. ");
INSERT INTO mizNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ntá tsi dā xee étsin ña mí rkāa nteé Jesuú ne, kūtuni ña tsi é xiꞌi ña. Dukuān ne, ñá ni ēꞌnu ña xɨkɨ dáꞌnta ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ntá tsi uun ñaꞌa sntadún san ne, iꞌxi nūu ña káa ñā má xkɨntika Jēsuú ne, ura tsí i kíi nɨñɨ ni ntute. ");
INSERT INTO mizNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Xuꞌu é kantaa ú ni nto sāꞌá ne, īní u nee iña kúvi. Kakaꞌan ntáa ú ni ntō vata koo é na kuīntiꞌxe nto dɨ, tsí iní u tsi nuu é ntaā i é kākaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","É un ntɨꞌɨ nūu i sáꞌa kúvi vata koo é kuntaa vatā ó uve naꞌa kakaꞌan túꞌun Xuva kō: “Nté uun xɨkɨ ña ña ni táꞌnu”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Uun ká xtuku nuu i kakáꞌan túꞌun Xuva kō dɨ: “Kiní ñaꞌa san ña é iꞌxi nūu ña káa kúñu ñā”, kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Dā ita ntíꞌxin kúvi sáꞌa ne, véꞌxi uun ñāꞌa, ñá nani Jōsee, ña ñuú Arimatea. Kuintiꞌxe xuꞌū ña Jesuu tsí da xé ūꞌví ña ña Israeé san. Dɨvi ña īkan ñá ntaꞌa Pilatú san te kuēꞌé ña itsi é nakiꞌi ña kúñu Jēsuu. Pilatú san ne, xéꞌe ña ītsi é kuān koo vií ña. Kidáā ne, ixnakíꞌi ña kúñu Jēsuú ne, dā kueꞌen niꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ikan tsī xee Nícodemu, ña é ñeꞌe é nīñu, ixkaꞌan ñá ni Jēsuu, ódo ñā vata oko uꞌxi kílū choꞌo vídin é kadāka dúꞌxe utun ni ūꞌxen xaví san. ");
INSERT INTO mizNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ntuvi ña nákiꞌi ña Jesuú ne, dā náxtinuu ñá ña doo kuiꞌxin e xntáꞌa ña uꞌxen choꞌó san vatā xkoó ini ñá Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mī náxnteē ñá Jesuu ntíká krusí san ne, ikan ētsin má utun tata. Ikān tuví uun ñaña xēe mí é vāta xoxo kunuu ntúꞌxi ī. ");
INSERT INTO mizNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ikan tsī xnuu ntúꞌxi ña Jesuu, tsi íkan ētsin tuví ñañā san, tsí da xé kuenta iña i é kāxio tûꞌve víko iña ñá Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ntuvi dá nakiꞌi vité san ne, ntɨkɨn nīꞌni ká kueꞌen María Madālena nú ñaña kān. Dā íto ña ne, īní ña tsí e xío tuví xuu é katāvi núu xuꞌu ñañā san. ");
INSERT INTO mizNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kaxkainu ña kueꞌen ña mí ntoo Simuun Pedru ni ña ntɨníꞌi ñā, ña e dóo kuinima Jésuu. Kakaꞌan ñá ni ñā: —É nātavá ña Mastru ko nú ñaña ña kān né, ntē ñá īni o míꞌi kūnaxnúu ña ña —kaꞌan Maríā san. ");
INSERT INTO mizNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kidáā né, kīi Pedru ni ña ntɨníꞌi ñā, ña uun san, kueꞌen ñá nú ñaña kān. ");
INSERT INTO mizNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ntuvi ñá koo da ntaínu ña kueꞌen ña, ntá tsi dií ka inú ka ña é ña uun san. Diꞌna ña xee ña nú ñañā san. ");
INSERT INTO mizNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Náxkāꞌnu nteɨ ña dɨkɨ ña, íto niꞌni ña iní ñañā sán ne, īní ña doó san, ntá tsi ña ni kɨ́ꞌvi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kidáā ne, xée Sīmuun Pedrú san ne, dā kukɨ́ꞌvi ña īní ñañā sán ne, ikān íni ña doó san. ");
INSERT INTO mizNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Taꞌvi dōo é ītínuu dɨkɨ Jésuú ne, ñá te tūví dadɨɨ ká ni dōo kaꞌnú san, tsí e xío tuví kataꞌnu vaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kidáā ne, kúkɨ̄ꞌví ña uun ñaꞌa sán dɨ, ña é xee díꞌna nú ñañā sán ne, dā íni ña ne, kuīntiꞌxe ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ntá tsi vata kɨ́ꞌɨn dɨkɨ ña é uve naꞌa kakaꞌan túꞌun Xuva kō tsí da miī é ntoto ña tē xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kidáā né, ntiko kōó ña ntɨniꞌi ñā, kunúꞌu ña nú viꞌi ña kān. ");
INSERT INTO mizNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ntá tsi Maríā sán ne, ntitsí ña diñɨ ñáña san, kaéku ña. Kuan tsī ó kaeku ña, náxkāꞌnu nteɨ ña dɨkɨ ña, íto niꞌni ña iní ñañā sán ne, ");
INSERT INTO mizNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","īní ña uvi ñaꞌa ánjē san é ñuꞌu ña doo kuiꞌxin. Ntoo ña nú xuu mí intéku kúñu Jēsuu. Uun ñaꞌa ña tuví ña dɨkɨ́ ñañā sán ne, uun ñaꞌa ña tuví ña xeꞌe i kan. ");
INSERT INTO mizNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tsixeꞌe ña ñā: —¿Nté kui kaekun ntun, ñadɨ̄ꞌɨ? —kaꞌan ña. —Tsí kueꞌen niꞌi ña Mastru kó ne, ntē ñá iní u míꞌī xnúu ña ña —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Dā ve tsi kakaꞌan ña sáꞌa ne, xkokōto ñá ne, ikan tsī íni ña Jesuu ntítsí ña, ntá tsi ña ni iní ña te dɨvi Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesuú ne, tsixeꞌe ña ñā: —¿Nté kui kaekun ntun, ñadɨ̄ꞌɨ? ¿Xoó ñaꞌa ntu kanantukūn? —kaꞌan ña. Ña kaito ntodo útun tatá san, kuíni Maríā sán ne, kakaꞌan ñá ni ñā: —Te dɨvi nto kuēꞌen niꞌi ntó ña ne, káꞌan nto nī ko míꞌī náxnuu nto ñā vata koo é kɨ̄ꞌɨ́n u, kínakiꞌí u ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dá kakāꞌan Jésuu ni ña: —¡Maríā! —kaꞌan ña. Dā xkókoto ña, kakaꞌan ñá ni ña tūꞌun hébreú san: —¡Rabuni! (é kāni túꞌun Mastru) —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dá kakāꞌan Jésuu ni ña: —Ñá kū dɨ́ tɨɨn ntaꞌān ko, tsí vata ntáā u mí tuví Uvā ko. Ntá tsi kuēꞌen mí ntántoo ení ko ne, káꞌan ni ñā tsí ntaa u mí tuví Uvā ko, é dɨvi ña Uva ntō dɨ, tsí uun tsi Xuva ko ni ntō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kidáā ne, kuéꞌen Māría Madālená san, kukaꞌan ñá ni ña ntɨniꞌi ñā: —¡É īní u Mastru kó ve! —kaꞌan ña. Kidáa ne, ntaa ña ni ña tūꞌun é kākaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Dā kuáa dɨvi tsi ntūvi é kuvi uun vité san ne, kantīꞌu tsí xiꞌí san mí ntoo ña ntɨniꞌi ñā, tsí da xe ntaúꞌvī ñá ña Israeé san. Ikan tsi kūkɨ́ꞌvi Jesuu, ntítsí ña méꞌñu ña kān ne, kakaꞌan ñá ni ñā: —Váꞌa tsi koo kuntōo nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Dā kúvi kaꞌan ña sáꞌā ne, náñēꞌe ñá ña ntaꞌa ña ni xkɨntika ñā. Ñá tē nté kaa nakuꞌun díni nima ñá ntɨniꞌi ñā da íni ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kidáā ne, kakaꞌan xtúku Jesuu ni ña: —Váꞌa tsi koo kuntōo nto. Vata ō táxnuu Uvā kó ko ne, kuan koo taxnūu ú nto dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Dā kúvi kaꞌan ña sáꞌa ne, tɨ̄ꞌví nteē ñá ña, kakaꞌan ña: —Nakiꞌi nto Espíritū Sántū san. ");
INSERT INTO mizNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Da xōó ka ñaꞌa é kāda kaꞌnu iní nto ni ña kuētsí ña ne, é ntɨ̄ꞌɨ kuétsi ñā. Ntá tsi da xōó ka ñaꞌa é ña kada kaꞌnú ini nto ni ña kuētsí ña ne, é kuan tsī koo kuétsi ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ntá tsi Tumaá san, uun ñaꞌa ña é kuvi uxuvi ñáꞌa ña ntɨniꞌi ñā, ña e ntántēe Iꞌxa Uví ne, xóxō ña da ntii dîtó Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ntá tsi ntákaꞌan ñá ntɨniꞌi ña, ña nguiī san ni ña: —É īní ntɨ Mastru kó ve —kaꞌan ña. Ntá tsi Tumaá san ne, kakaꞌan ñá ni ñā: —¿Vá ntāa ntu? Tē ña kiní u mí dūku tsɨkɨ́ san ntaꞌa ña, tē ña nakɨꞌví u rkɨntaꞌá ko mí dūkú san ne, o tē ñá nakɨꞌví u ntaꞌa ko mí kanúu xkɨntika ñā dɨ́ ne, ña kúvi kuintīꞌxe ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Dā kúvi ūna ntúvi ne, ntoo xtuku ña ntɨniꞌi ñā má viꞌi kān né, ikān tuví Tumaá san dɨ. Kantiꞌu tsí xiꞌi ntóo ña, ntá tsi xee xtúku Jesuu, ntítsi ña méꞌñu ñā, kakaꞌan ña: —Váꞌa tsi koo kuntōo nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kidáā ne, kakaꞌan ñá ni Tūmaá san: —Nakɨ̄ꞌvín rkɨntaꞌa o iꞌa ne, koton ntaꞌa kó san ve. Tāꞌxin ntaꞌa o, dá nakɨ̄ꞌvín xkɨntikā kó san. Ñá ku kuān nte dóꞌon; na kuīntiꞌxe o ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nantíko kōó Tumaá san, kakaꞌan ñá ni ñā: —¡Tōꞌó miī ko! ¡Xuva ntīꞌxe ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kidáā ne, kakaꞌan Jésuu ni ña: —Viꞌi a vé ne, kakuintiꞌxe o tsí da xe ínin ko. Ntá tsi ¡nté kui vaꞌá ñaꞌa, ña é kakuintiꞌxe i kó kuān te vata kiní ña ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ñá te da dīí ka nuu i é idé Jesuu núu ñá ntɨniꞌi ñā é ña ni úve naꞌa tutú saꞌa. ");
INSERT INTO mizNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ntá tsi nuu i sáꞌa ūve naꞌa vata koo é kuīntiꞌxe nto tsí Jesuú ne, dɨvi ñā é táxnuu Xuva ko ñā né, dɨvi ñā é Īꞌxá Xuva ko ñā dɨ. Te kuīntiꞌxe nto ña ne, níꞌi nto ntuvi vāꞌá iña ntó kuenta iña ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dā rkontûvi e kúvi sáꞌa ntii dîtó Jesuu mí ntoo ña ntɨniꞌi ñā etsin nu míni kāꞌnu é nani Tīberia. Sáꞌā kúvī da ntii díto ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ikān ntoo dadɨɨ Simuun Pedrú san ni Tūmaa, ña e ntántēe Iꞌxa Uví, ni Natanāee, ña véꞌxi ñuú Canaa é kāduku ntée ñuú Galilea, nī ntuvi iꞌxá Zebedeu, ni ūví ka xtúku ña ntɨniꞌi Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simuun Pedrú san kakaꞌan ñá ni ñā: —Xuꞌú ne, tsāká kitáva u —kaꞌan ña. Ntákaꞌan ñá ni ñā: —Kɨ́ꞌɨ̄n ntɨ́ ni ntō dɨ —kaꞌan ña. Kuéꞌen ñā, ñuꞌú ña tun ntōó san. Ntá tsi niñu tsikán ne, nté uun tsákā ña ni tavá ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ntá tsi dā veꞌxi túvi ne, ikān ntii dîtó Jesuu, ntítsi ña diñɨ ntute san. Ntá tsi ña ntɨniꞌi ñā ne, ñá ni īni ñá te dɨvi Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kidáā ne, kakaꞌan Jésuu ni ña: —Ō dáꞌ, ¿vāta ntu níꞌi nto tsákā san? —kaꞌan ña. —Vátā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesuú ne, kakaꞌan ñá ni ñā: —Nakuītá nuu nto xunu nto diñɨ kuáꞌa nto sán ne, ikan nīꞌi ntó tɨ —kaꞌan ña. Kuān o dé ntiꞌxe ña ne, ntē ña ni kuvi natavá ka ña xunu san e dóo ñuꞌu tsitu kuēꞌen tsákā san. ");
INSERT INTO mizNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ña ntɨniꞌi ñā, ña e dóo kuinima Jésuú ne, kakaꞌan ñá nī Pedrú san: —¡Dɨvī mastru kó ña! —kaꞌan ña. Dā ve tsi téku Pedrú san é dɨvī Tóꞌo ñā ne, nákunūu ña duꞌnu ña, tsí kantɨɨ́ ña nuu ña, dā entíta ña iní ntute san. ");
INSERT INTO mizNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Da nɨɨ vēꞌxí ña nguiī sán iní tun ntōó san, ntáñuꞌu ña taraxá san é ñuꞌu tsitu tsákā san. Ñá te nté sa ikā ñuꞌu ña nú ntūte san; īó te ūun sientu métrū. ");
INSERT INTO mizNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dā núu ña tun ntōó san nú ñutɨ kán ne, ikān íni ña é kaiꞌxi ngɨ́ñuꞌu, nteku ítun tsákā san ni tañúꞌū san. ");
INSERT INTO mizNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kakaꞌan Jésuu ni ña: —Na kīꞌxi nto uvi a tsáka, kɨtɨ dā ve táva nto san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kūxee xtuku Simuun Pedrú san iní tun ntōó san ne, kanañuꞌu ña taraxá san ñuꞌu kān. Uun ito tsi ñúꞌu tsitu kuēꞌen taraxá san tsáka naꞌnu ntɨꞌɨ, uun sientu uvi díko uxuni tɨ. Kuān te dóo kueꞌe tɨ́ ne, ntē ña ni ntatsin táraxá san. ");
INSERT INTO mizNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kakaꞌan Jésuu ni ña: —Kixkáꞌxi nto kuenta teváa —kaꞌan ña. Kidáā ne, nté uun ñaꞌa ña ña ni kene iní ña tsixeꞌe ña ñā xoo ñáꞌa ña, tsí da xé ini ña tsí dɨvi ntīꞌxe ña é Tóꞌo ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Xée ētsin Jesuú ne, dā nánuu ntáꞌa ña tañúꞌū sán, xeꞌé ña ña. Kuan tsī o dé ña nī tsákā sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","E sáꞌā kúvi ūni íto e ntii dîtó Jesuu núu ñá ntɨniꞌi ña dā ntóto ña é xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Dā kuvi éꞌxi ña ne, kakaꞌan Jésuu ni Símuun Pedru: —Simuun, íꞌxá Juaan, ¿vā dií dií ka ntu kakuinima ó ko é sāꞌa? —kaꞌan ña. Kakaꞌán Pedru ni ña: —Ini ntú ku nto, Mastru, tsí ntio kó nto —kaꞌan ña. Kakaꞌan Jésuu ni ña: —Kuéꞌēn é kāꞌxí a leꞌntú ko sán ni —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","É kūvi uvi íto tsixeꞌe Jēsuu ña: —Simuun, íꞌxá Juaan, ¿kakuinima ntú o ko? —kaꞌan ña. Kakaꞌan ñá ni ñā: —Nuu é ntaā i, Mastru. Ini nto tsí ntio kó nto —kaꞌan ña. Kakaꞌan Jésuu ni ña: —Kuenta víin leꞌntú ko sán ni —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","É kūvi uni íto tsixeꞌe xtuku ña ñā: —Simuun, íꞌxá Juaan, ¿ntio ntu o ko? —kaꞌan ña. Pedrú san ne, dōo uꞌvi kúvi ña é uni íto tsixeꞌe ña ña tē ntío ña ña ne, kakaꞌan ñá ni ñā: —Mastru, dɨvi nto īni nto é un ntɨꞌɨ̄. Dɨvi nto īni nto tsí ntio kó nto —kaꞌán Pedrú san. Kakaꞌan Jésuu ni ña kídaā: —Kuéꞌēn é na kāꞌxi leꞌntú ko sán ni. ");
INSERT INTO mizNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nuu é ntaā i é kākaꞌán u ni ō. Dā kúvin ñatīí kuetsī ne, nákunūun duꞌnu o dá kɨ̄ꞌɨn da míꞌī ka mí ntio o. Ntá tsi tē kuátān ne, koó da nakāan ntáꞌa o ne, tuku ñaꞌa naxnūu ña o duꞌnu ó ne, dá kɨ̄ꞌɨn niꞌi ña o míꞌī ña ntío o é kɨ̄ꞌɨn. ");
INSERT INTO mizNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kuan ō kaꞌan Jésuu vata koo é kūtuní Pedru nté koo kuvi tē xiꞌi ña, vata koo é kāꞌan ñáꞌa tsi dóo kaꞌnu Xuva kō. Kidáā ne, kakaꞌan ñá ni ñā: —¡Kuntīkɨ́n ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Dā xkókoto Pedru ata ñá ne, īní ña tsí kantīkɨ́n ña uun ñaꞌa ña, ña e dóo kuinima Jésuu, ña e itúvi diñɨ ña da éꞌxi dadɨɨ ña da kúvi viko san, ña é tsixeꞌe xoo ñáꞌa é diko i ñā. ");
INSERT INTO mizNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Dā íni Pedru ñá ne, katsixeꞌe ña Jēsuu: —Ña sāꞌá ne, ¿nté ntu koo kuvi ña? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kakaꞌan Jésuu ni ña: —Tē ntio ko é kutuvī ñá da nté nainu xtúku ú ne, ¿vá neē ntú kuenta iña o? ¡Dɨvīn né, kuntīkɨ́n ko! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Dukuān ne, kuiní ña ntákuintiꞌxe i san tsí ña kuví ntiꞌxe ña tsikan. Ntá tsi ña te ni káꞌan Jésuu e ña te kuví ña. Da mii tsī é kākaꞌan ña: “¿Vá neē ntú kuenta iña ó te ntio ko é kutūví ka ña dā nté nainu xtúku u?”, kuan ō kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Dɨvi ña ntɨniꞌi Jēsuu, ña tsikán ne, dɨvī ú xuꞌu é kantaa ú ni ntō nee iña e íni u. Xuꞌu tée naꞌá u túꞌūn saꞌa. Ini o tsí nuu é ntaā i é kākaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesuú ne, dií ka tɨ̄tɨ́n ka nuu i é idé ña dɨ. Tē dɨ́ ni ūve naꞌa un ntɨɨ́ ntɨ̄ɨ sáꞌa ne, á te ntē ña xee táꞌan ñuxiví sa é kuntōo tutu é ūve naꞌa kakaꞌan íña ña.");
INSERT INTO mizNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Xuꞌú é Lucá u ne, táxnūú u tutú ntaꞌa nto, Teófilu. Tutú é dé vaꞌá diꞌná u ne, ntaa ú ni nto un ntɨꞌɨ̄ é edé Jesuu, ni un ntɨꞌɨ̄ é nakuāꞌa ña ñaꞌa nté ntūvi dá eni ntuꞌu ñā ");
INSERT INTO mizNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","da nté ntūvi é kūntáa ña e dukún kān. Diꞌna dá kūntáa ña e dukún kān né, dē kúꞌvē ñá uxuvi ñáꞌa, ña é vīí pustru íña ña ne, náñēꞌe ñá ña nté koo vií ña. Tsí xeꞌe Espíritū Sántū é kūtuni ña nté koo kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kidáā ne, xíꞌi ñā ntiká krusi. Ntá tsi da rkontûvi é xiꞌi ñá ne, mii ñā ntii díto ña mí ntoo pustru ña. Dōó kiꞌin itō ntii díto ká ña da nté xee táꞌan uvi díko ntuvi. Dōó kueꞌe edé ña vata koo é kuīntiꞌxe pustru ña tsí ntoto ntiꞌxe ña ne, kakaꞌan ñá ni ñā iña mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dā intóo dadɨɨ ká ña nī pustru ñá ne, kakaꞌan ñá ni ñā é ña ku ntaka ña ñuú Jerusaleen. —Kuntētu ntó iꞌa da nté niꞌi nto é kākaꞌan Úvā kó, vata ō kaꞌán u ni nto kídaā. ");
INSERT INTO mizNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","É īni nto tsí Juaán ne, ntute nakutsi ntúte ña kō; ntá tsi ña kukuíi ka dá nainu míi Ēspíritū Sántū san é kunūu ñá nima nto —kaꞌan Jésuu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ña nátaká nuu ni Jēsuú ne, tsixeꞌe ña ñā: —¿Vevií ntu é nakāku ntó ñuú ña Israeé san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kidáā né, kakaꞌan Jésuu ni ña: —Ñá te ntōꞌo é kāduku ntée nto é kūtuni nto nee ntúvi vií Uvā kó nuu i é viī ña. Tsí kuenta iña mii ña é kade ña. ");
INSERT INTO mizNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ntá tsi te īnuu Espíritū Sántū san é kunuu ña nima ntó ne, dɨvi ña xntii ña ntō é kāꞌan ntó xoo ñáꞌa ú ni ña ntoo ñuú Jerusaleén san. Da kidáā né, kueꞌēn ntó ñuú Judea ni ñuú Samaria ne, kuēꞌén ka nto dá kanɨɨ ñūxivi. Kueꞌēn ntó, kukaꞌan ntódo nto ni ñāꞌa xoo ñáꞌa ú —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Dā kúvi kaꞌan Jésuú ne, kūntáa ña e dukún kān. Mēꞌñú viko nuꞌu kuntáa ña ne, ñá ni īní ka pustru ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kuan tsī o ntáñɨ̄ ña, ntaíto díto ña e dukún kān mí kūntáa ña ne, dā nénī ñá xee uvi ánje Xuva kō, ñuꞌu ña doo kuiꞌxin. ");
INSERT INTO mizNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ntákaꞌan ánjē sán ni ñā: —Ō ñá ñuú Galilea, ¿nté kuān nté ntaíto díto ntu nto e dukún kān? Tsí dɨvi tsi Jēsuu, ña é nakiꞌi Xuva kō né, vata tsī ó kūntáa ña e dukún ne, kuan tsī koo nainu xtúku ña ñuxiví a —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kidáā ne, ntáka ña xuku é nani Ōlivú san. Ntíko koō ñá, kunúꞌu ña ñuú Jerusaleen é ña tuvi nté uun kilumetru. ");
INSERT INTO mizNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Dā náxee xtúku ña ne, kúxee ña má vīꞌi nínu kān. Dɨvī ña ntoo sán ne: Pedru, ní Juaan, ni Sántiau, ni Ándree, ni Félipe, ni Túmaa, ni Bártulu, ni Máteu, ni túku Santiau, iꞌxá Alfeu, ni Símuun Zélote, ni Júda, ení Santiau. ");
INSERT INTO mizNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nguentúvi ntánataká nuu un ntɨɨ́ ntɨɨ̄ ñá, ni ēní Jesuu, ni dɨ́ꞌɨ ñā María, ni tuku ñadɨ̄ꞌɨ́ dɨ, é ntákaꞌan ntâꞌví ña ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Uun ntuvi ne, nátaká nuu vata te uun sientu oko ñaꞌa, ña kuíntiꞌxe i Jesuu. Kidáā ne, nákuntītsí Pedru é kāꞌan ñá ni ñā ne, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Eni, é īni nto tsí da miī é kuvi nee iña é kākaꞌan Espíritū Sántū sán ne, nté ntūvi diꞌna xeꞌé ña túꞌūn é xntée naꞌa Davii íña Júdā san. Tsi Júdā sán ne, dɨvi ñā é intéka ña ñaꞌa é tɨ̄ɨn ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Dɨvi ñā ne, dadɨɨ tsi pustru ntɨ́ ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ntá tsi é īni ntó nté ō kúvi ña. Tsi kíꞌi ña diuꞌun é diko ña Jēsuú ne, ñīi ñá uun itsi ñūꞌu. Kidáā ne, kanteɨ ña, koꞌxó ña. Ntáta īꞌxí ña ne, uun ito tsi kíi ntɨꞌɨ itɨ́ ña ne, xíꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tēku ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntoo ñuú Jerusaleen, nté ō kúvi ña. Dukuān né, īntántēé ñuꞌu san Aceldama, é kāni túꞌun Ñūꞌu Nɨñɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kuān ó uve naꞌa libru é nanī Salmu, kakaꞌan: Na kuīñɨ ixu viꞌi ña ve; xōxó kuntōo ká i ikān, kaꞌan líbrú san. Xío ūve naꞌa túku, kakaꞌan: É tūku ñaꞌa nakunúu ña naa ña, é viī ñá tsiñu é edé ña, kaꞌan líbrú san. ");
INSERT INTO mizNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ʼIꞌa ntoo ñaꞌa é dadɨɨ tsi íka ntɨ́ ni ñā nguentúvi dá kātúvi Tóꞌo ko Jēsuu ní ntɨ, ");
INSERT INTO mizNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","nté ntūvi dá itsi ntute ña ntaꞌa Juaan un tsi da nté ntūvi é kūntáa ña viꞌi antɨ̄vi. É kāntio ne, uun ñaꞌa kuntee táꞌan ña ntɨ́ é ntuvi nɨɨ̄ ntɨ́ uxuvi ñáꞌa ntɨ é ntāda ntaá ntɨ nee é īni ntɨ́, é kāꞌán ntɨ ni ñaꞌā tsí nuu é ntaā i e ntóto Jesuu dá xiꞌi ña —kaꞌán Pedru. ");
INSERT INTO mizNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kidáā ne, nakaxnúu ña úvi ñaꞌa: uun ñaꞌa, ñá nani Jōseé Barsabaa (Justo náni ña dɨ), ni ūun ñaꞌa, ñá nani Mātia. ");
INSERT INTO mizNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ntákaꞌan ntâꞌví ña kídaā: —Xuva, dɨvi ntō é īni nto nimá ntɨ xe un xé un ntɨ́ ne, tāꞌxi ntó na kūtuní ntɨ xōo ñáꞌa é ntio nto ");
INSERT INTO mizNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","é viī ñá pustru nto, é nakunúu ña naa Júda. Tsí Júdā ne, nákunāá ña tsiñu ña dá kuan ō dé ña é kīni kaa, dá kuēꞌen ñá mí kadūku ntée ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dā kúvi kaꞌan ntâꞌví ña ne, nadɨ́kɨ ñá te kīi xoo ñáꞌa é vīí pustrú san. Dā kíi ne, dúku ntēé Matiá san. Ura tsí i intee táꞌan ña ni ūꞌxi ɨ́ɨn pustru, ñá nguiī san. ");
INSERT INTO mizNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dā xee táꞌan ntuvi é kūvi viko iña ñá Israee, viko é nani Pentecōsteé ne, dadɨɨ ntoo ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dā nénī ñá uun káñuꞌū tsí nte e dukún kan, vatā ó te tātsin dóo ntii kainu ne, koó da kakeꞌxen nī kava má viꞌī mí ntoo ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kidáā ne, ntii díto ñuꞌu kaiꞌxi. Kaxiꞌí nuu ñuꞌu san dɨkɨ ñá xe un xé un ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kidáā ne, ínūu Espíritū Sántū san nima ñá ne, eni ntuꞌu ñā ntákaꞌan ña é tūku e túku túꞌūn, tsí xeꞌe Espíritū Sántū san é kūvi kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ntuvi sāꞌá ne, xee ntɨɨ́ ntɨ̄ɨ́ tatá viꞌi ña Israee, ña e dóo ntaínuu iní i Xuva kō. Dā míꞌī ká ñuu véꞌxi ña, xée ña ñūú Jerusaleen é viī ñá nchuꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Dā tékū ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san tsi dóo ntii kakaꞌan ñuꞌú ne, ikan tsī nátaká nuu ntɨɨ́ ntɨɨ̄ ña. Ña é da ve xée sán ne, é tūku e túku túꞌūn ntákaꞌan ña. Koó dā kúduꞌva ña da téku ña túꞌun ñā e ntákaꞌan ña kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Koó dā kúdana iní ña ne, ntánatíin ña ni tāꞌan ña, ntákaꞌan ña: —¿Vá ña ntu te ña ñuú Galilea, ña kuān ó ntákaꞌan san? ");
INSERT INTO mizNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nté kuī ntátekú ntu ko tūꞌun é ntákaꞌan ña, vata tsi tē dadɨɨ túꞌun ko ni ñā? ");
INSERT INTO mizNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tsí xoꞌō ne, é xīo xío ñuu ko: ñuú Partia, ni ñūú Media, ni ñūú Elan, ni ñūú Mesopotamia, ni ñūú Judea, ni ñūú Capadocia, ni ñūú Puntu, ni ñūú Asia, ");
INSERT INTO mizNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ni ñūú Frigia, ni ñūú Panfilia, ni ñūú Egítō né, iō ñá ne, véꞌxi ñā un tsi nte ñuu África, é díi ka ikā é ñuú Cirene. Iꞌa ntoo ña ñuú Romá dɨ; iō ñá ne, ña Israee ña; iō ñá ne, dadɨɨ tsi ntántīkɨn ñá Xuva ko nī ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Iꞌa ntoo ña ñuú Cretá dɨ, nī ña ñuú Arabia. Ntá tsi un ntɨɨ́ ntɨ̄ɨ o ntáteku ko é ntántaa ña ni kō nté o de Xuva kō e dóo kaxntii ña kō né, dɨvi tsi tūꞌún mii kō ntákaꞌan ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Koó dā kúduꞌva ña nee iña é kākuvi ne, ntátsixeꞌe tāꞌan ña: —¿Míꞌi ntu vēꞌxi é kuan ō ntáde ñaꞌa san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ntá tsi iō ñá ne, da ntáxkuntée ña, ntákaꞌan ña: —Tē dóo ñuꞌu tsitū nima ña vínu xee —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kidáā ne, nákuntāñɨ́ dadɨɨ Pedru ni pustru ñá uꞌxi ɨ́ɨn san é kāꞌan ñá ni ñāꞌa sán ne, un ntii tsī kéne ña, kakaꞌan ñá ni ñā: —Un ntɨꞌɨ kuēꞌen dúꞌva ntō, ña ñuú Judea ni ñá ñuú Jerusaleén ne, viꞌa ve ne, kini váꞌa nto é kaꞌán ntɨ ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ñaꞌa sāꞌá ne, ña te kɨ́ꞌvi ñā. Ini nto tsí dā ve kaeku ɨɨn teváa. ");
INSERT INTO mizNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ñāꞌá ni san, tsi sáꞌa ne, kakuvi vata ō kaꞌan Jóee dá kaꞌan ñá naa Xuva ko é ūve naꞌa nté ntūvi diꞌna, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Te xēe táꞌān ntuvi é ntɨ̄ꞌɨ ñuxiví ne, táxnūú u Espíritū Sántū ko é kunūu ña nima ñáꞌa, ña ntoo dá kanɨɨ ñūxivi. Kidáā ne, káꞌan iꞌxā ntó, te tíi, te ñadɨ̄ꞌɨ, naá ko. Na kuetsī sán ne, vata koo kuvi é nākueni na, kiní na é nāñeꞌé u na. Ñatā sán ne, ñuu ení kān nañēꞌé u ña nté koo kuvi rkontuvi. ");
INSERT INTO mizNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ntuvi tsikán ne, taxnūú u Espíritū Sántū ko é kunūu ña nima ñá ntáde tsiñu kuenta iñá ko, te tíi, te ñadɨ̄ꞌɨ ñá ne, da kidáa kāꞌan ñá naá ko. ");
INSERT INTO mizNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Taꞌxi ú kuenta é dukún kān ne, ñuxiví a kii nɨñɨ́ ne, koko ñuꞌú ne, dōo kene uꞌme vata kaa viko nuꞌu. ");
INSERT INTO mizNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kuneé ngantií ne, koko kuēꞌe kueꞌé xoo, vata ito nɨñɨ, diꞌna tē xee táꞌan ntuvi é naīnu Tóꞌo kō. Kidáa ntūvi e dóo kaꞌnu, e dóo váꞌa ō. ");
INSERT INTO mizNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dā xoó ka ñaꞌa, ña é kaku niꞌi i Tóꞌo kō ne, nakáku ña, kaꞌan Jóeé san kídaā. ");
INSERT INTO mizNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ʼUn ntɨꞌɨ kuēꞌen dúꞌva nto, ñatīí Israee, kini váꞌa nto é kāꞌán ntɨ ni ntō: Tsí Jesuu, ñá ñuú Nazareé ne, dɨvi ñā e dóo vaꞌá ña ni Xuva kō. É īni ntó tsí xeꞌé Xuva kō é kūvi vií ña nuu i e dóo naꞌnu méꞌñu ntō né, dōo kueꞌe kuénta táꞌxi ña vata koo é na kūtuni nto tsí mii Xuva kō táxnūu ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ntá tsi dā ntúvi ña kuenta ntáꞌa nto, vata tsi ō dé kûꞌvé Xuva ko ntē ntúvi diꞌna ne, dɨvi ntō tɨ́ɨn nto ña ne, ēꞌní nto ña dā xeꞌé nto itsi é naxnteē ñá kini ntáa san ña ntíkā krusi. ");
INSERT INTO mizNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ntá tsi Xuva kō ne, nantóto ña ña dá xiꞌi ña. Ña ni kúvi vīí doxiꞌí san ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tsí kuān ó uve naꞌa nte ntúvi diꞌna, kakaꞌán rei Davii kuénta iña ña: Iní u tsí nguentúvi katuví u ni Xuva kō. Ñá kauꞌvī kueꞌén ko, tsí dɨvi ñā kunuu méꞌñu kūnuu dava ña ko. ");
INSERT INTO mizNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Dukuān é nakūnuu dîní nimá ko ne, dōó diní ko, kakaꞌán u. Nakutúvi vāꞌá kueꞌen kúñū ko, ");
INSERT INTO mizNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tsi ñá xtuvī mii ntó nimá ko doxiꞌí kān; ntē ña taꞌxi nto é tēꞌu kúñū ko, tsí xuꞌu é iꞌxā nto e dóo vaꞌá u. ");
INSERT INTO mizNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Dɨvi ntō nañéꞌē ntó ko nté koo niꞌí ko ntuví vaꞌá iñá ko. Xuꞌú ne, nakunúu dini kueꞌén nimá ko é kutūví dadɨɨ ú ni ntō. Kuan ō kaꞌan Dávií san kídaā. ");
INSERT INTO mizNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ʼĒni, é īni nto tsí xiꞌi úva ata ko Dāvií ne, dā intúꞌxi ña. Tsí iꞌa tuvi dukuan ñáña ñā mí īntúꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ntá tsi Davií ne, kakaꞌan ñá naa Xuva ko é kuān ó kakaꞌan ña. Ini ña tsí Xuva kō xeꞌé ña xuꞌu ña tsí uun iꞌxá ika ña kunūu naa ña é viī ñá rei iñá ko, xoꞌō e ñá Israee o. ");
INSERT INTO mizNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dukuān né, vata tsī ó te nte díꞌna íni Davii nté koo kuvi ne, kaꞌan ña kuenta iña é ntoto Cristu dá xiꞌi ña, tsí ña kunuu mii nima ña mí ñuꞌu nima ñá xiꞌi; ntē ña téꞌu kúñu ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ne, kuan ō kúvi ntiꞌxe, tsí Xuva kō ne, nantóto ña Jesuu. Un ntɨɨ́ ntɨ̄ɨ́ ntɨ é uxuvi ñáꞌa ntɨ́, ntáde ntaá ntɨ tsí iní ntɨ tsí nuu é ntaā i é ntóto ña dá xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kidáā ne, kúntāa ña é kutuvī ñá ntaꞌa kuaꞌa Xuva kō é kada kúꞌvē ñá, tsi dóo iō ñá é viī ña. Kidáā ne, táxnuu Xuva kō Espíritū Sántū sán, vatā ó kakaꞌan ñá nte díꞌna ne, dɨvi ñā kade ña é un ntɨꞌɨ̄ é ntaíni nto nī é ntátekú nto é kākúvi vevii. ");
INSERT INTO mizNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tsí ña te rei Davií san ña é kūntáa viꞌi antɨ̄vi, tsí mii Dāvii kakáꞌan ña: Kakaꞌan Xúva ko nī Tóꞌō kó: “Kutūvín diñɨ kuaꞌa kó, ");
INSERT INTO mizNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","dā nté kūvi vii ntɨ́ꞌɨ ú nī ña ntaínchuꞌvi o”, kaꞌan Xúva kō. Kuan ō kaꞌan Dávii kídaā. ");
INSERT INTO mizNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ʼNa kūtuni ntɨɨ́ ntɨ̄ɨ́ ña Israeé san tsí nuu é ntaā i tsí dɨvi Jēsuu, ña é náxnteē nto ntíkā krusí ne, dɨvi ñā é nakaxnúu Xuva ko ñā é viī ñá Tóꞌo kō, é viī ñá Cristu, ña é nakākú kō —kaꞌán Pedru ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Dā téku ñaꞌa san é kākaꞌan ñá ni ñā né, dōo uꞌvi kúvi ña. Tsixeꞌe ñā Pedru ní pustru ñá nguiī san: —Ēni, ¿nté ntu koo vií ntɨ é ntūváꞌā ntɨ́ ni Xuva ko vē? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kidáā ne, kakaꞌán Pedru ni ñā: —Natuꞌvi nto kuétsi nto ntaꞌa Xuva kō ne, kutsi ntute nto xé un xé un nto kuēnta iña Jésuu, vata koo é kāda kaꞌnu iní Xuva ko kuētsí nto ne, taꞌxi ña Espíritū Sántū é kunūu ña nima nto. ");
INSERT INTO mizNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tsi táꞌxi Xuva ko xūꞌu ña é kuān koo vií ña ni ko ni iꞌxā kó, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, kuān te dóo ikā ntoo ña, da xōó ka ñaꞌa e kána Xuva kō é kūvi ña iña ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Dōó naꞌa kākaꞌán Pedru ni ñá ne, dōó kueꞌe é kākaꞌan ñá ni ñā. Kaxéꞌe ña ña itsi, kakaꞌan ña: —Kii nteé xio nto ña kini ntáa san ve —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dōo tɨtɨ́n ñaꞌa kuíntiꞌxe ña é kākaꞌan ñá ne, itsi ntute ñā. Iō ñá te ūni míil ñāꞌa, ña é nakuvé taꞌan ntuvi tsikan nī ña kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ña sāꞌá ne, dōo dé ntaa ña un ntɨꞌɨ̄ é nañéꞌe pustrú san ña ne, dōo dé ntaa ña nataká nuu ña é kātsin dava ña tañúꞌu nī é kāꞌan ntâꞌví ña ni Xuva kō dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Xuva kō né, dōo xntíi ña pustrú san é viī ñá nuu i e dóo naꞌnu, e dóo tɨtɨ́n kuenta xéꞌe ña. Ñaꞌa sán ne, koó dā kúduꞌva ña ne, dōo uꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ña kuíntiꞌxe i sán ne, dadɨɨ tsi ika ña ne, uun tsi nima ña. Kaxntii tāꞌan ñá ni da nēé ka é īo iña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dīko ña iña míi ña ne, dā nákeꞌnté dava ña diuꞌun i, tsíꞌi ña ntaꞌa taꞌan ña xé un xé un ña vata kaa é kātaan núu ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Utén utén nátaká nuu ña ini ukún kaꞌnu kān ne, dadɨɨ éꞌxi ña nú viꞌi ña kān, katsín dava ña tañúꞌū. Dōo diní ñuꞌu nima ñá ne, ntē ña ni de náꞌnu ña ni tāꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Da mii kuēꞌen tsi é nānuꞌu ñá iní ña Xuva kō ne, dōo váꞌa kaꞌan ñáꞌa san íña ña. Utén utén ne, dukuān ntákutɨ̄tɨ́n ñaꞌa, ña nakáku Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Uun ntuvi ne, kuéꞌēn Pedru ní Juaan, kuntáa ña má ūkún kaꞌnu kān dá kaeku uni kuáa, ura i é ntákaꞌan ntâꞌvi ñáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dā xee ña xiꞌi úkun kán ne, īní ña é vēxníꞌi ñaꞌa san uun ñátīi, ña é natɨ́ɨn dɨꞌɨn i nté dā káku. Utén utén kaxee niꞌi ña ña ne, kaxtúvi nteē ñá ña xiꞌi úkun kān, xiꞌi é nanī E Dóo Vaꞌa. Ikān xkutúvi ñá, kaikan ñá doméni ntaꞌa ña ntáxee má ūkún kān. ");
INSERT INTO mizNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dā íni ña tsí véꞌxi Pedru ní Juaan é kɨ̄ꞌvi ña má ūkún kān ne, íkan ñā diuꞌún doméni ntaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedru ní Juaán ne, īto ña ña ne, kakaꞌán Pedrú san ni ñā: —Koton nuú ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kidáā né, īto ñá nuu ña tē nee kuéꞌe ña ña, kuiní ña. ");
INSERT INTO mizNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ntá tsi Pedrú ne, kakaꞌan ñá ni ñā: —Ña túvi kuēꞌen tsí diuꞌún ko. Ntá tsi īó iñá ko é tāꞌxi ú o: kuenta iña Jesúcristu, ña ñuú Nazaree, káꞌān ú ni ō: Nakuntítsin, kakan ve —kaꞌán Pedru. ");
INSERT INTO mizNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kidáā ne, írkāa Pedru ntáꞌa ña é xntii ña ñā nakuiñɨ ñá ne, ura tsí i ntuváꞌa dɨ́ꞌɨn ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Koó dā kaentíta ntaa ña nakuntítsi ña ne, dā éni ntuꞌu ñā kaika ña. Kúkɨ̄ꞌví dadɨɨ ña nī Pedru ní Juaan má ūkún kān ne, koó dā kaentíta eninú ña kaika ña, kakaꞌan ñá e dóo kaꞌnu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Īní ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san é kaika ña, kananuꞌu ñá ini ña Xuva kō ne, ");
INSERT INTO mizNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","koó dā kúduꞌva ñaꞌa san dá ini ña é ntūváꞌa ña, tsí ini ña é dɨvi ñā é kaitúvi nteē ña xiꞌi é nanī E Dóo Vaꞌá san é kaikān ñá doméni. ");
INSERT INTO mizNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ñatīí san ne, kuan tsī ó karkaa ña Pedru ní Juaan, é ña ni ntío ña é nangāva ña ña. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, koó dā kúduꞌva ña ne, ntaínu ñā, véꞌxi ña mí ntoō ñá, uun itsi ini ukun kan mí é nani Corīdoo Salámuun. ");
INSERT INTO mizNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Dā íni Pedru é véꞌxi ñaꞌa sán ne, kakaꞌan ñá ni ñā: —Ō ñá Israee, ¿nté kui koo da ntákuduꞌva ntu nto é kuan ō kúvi? ¿Nté kui kuān nte ntaíntéꞌa ntu nto ntɨ? ¿Vá dɨvi ntū ntɨ́ kuvi idé ntɨ é ntūváꞌa ña sāꞌa? ¿Va dóo ntu īó ntɨ é ntaváꞌa ntɨ́ ña xnēꞌe? Kuān te dóo ntaínuu ini ntɨ́ Xuva kō ne, ¿vá kūvi ntu vií ntɨ ntaváꞌa ntɨ́ ña sāꞌa? ");
INSERT INTO mizNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ñaꞌá ni san, tsí Xuva kō, ña inúu ini uva ata ko Ābraan ni Ísaa ni Jácoó ne, dɨvi ñā de kúꞌvē ñá é mii iꞌxā ñá Jesuu kodó nuū ña. Dɨvi ñā é ntáda nto ña kuenta ntáꞌa ña tsíñu i. Dā ntío Pilatu é nangāva ña ña ne, dɨvi ntō ne, ña ni ntío ntō. ");
INSERT INTO mizNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesuú ne, dōo váꞌa ña. Ña túvi nee kuetsí ña. Ntá tsi ña ni ntio nto é nangāva ña ña. Dɨvi ntō ne, íkan ntō é nantii ña uun ñaꞌa ñatīi, ña éꞌni ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Dukuan ō éꞌni nto ña kataꞌxi ntuvi iña ko. Ntá tsi Xuva kō ne, nantóto ña ña. Ntɨꞌɨ́ ne, iní ntɨ tsí nuu é ntaā i é kuan ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Vevií ne, dɨvi Jēsuu kúvi idé ña é ntūváꞌa ña sāꞌá, ña é kainí nto, tsí dá kaku niꞌi ña Jēsuú ne, nakunúu ntii ña. Tsí dá kuíntiꞌxe ña Jesuú ne, kutíi ña ntuvaꞌa váꞌa ña, vata tsi ō kaini ntó un ntɨꞌɨ ntō ve. ");
INSERT INTO mizNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ʼÉ īní u, ení, tsí dɨvi nto ni ña odo nūú iña nto ne, ña ni ínī ntó xoo ñáꞌa é Jesuu da éꞌni nto ña. ");
INSERT INTO mizNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ntá tsi dukuan ō dé ntaa Xuva kō é kākaꞌan ña nté ntūvi diꞌna dá ntákaꞌan ñá kaꞌan naa ña é da miī é ntōꞌo Cristu, ña nakaxnúu ña. ");
INSERT INTO mizNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Dukuān ne, nadama nto nima kíni kaa nto ne, nakuníꞌi nto nima váꞌá nto. Xnūu nto nima nto é kākaꞌan Xúva kō, vata koo é nākate ña kuétsi ntō. Kidáā ne, taꞌxi ña é nakunuu dîní nima ntó ne, ");
INSERT INTO mizNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","taxnuu ña Jesucristu, ña é nakaxnúu ña nte ntúvi diꞌna é kodo nuū ñá kuenta iña ko. ");
INSERT INTO mizNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Vevií ne, da miī é kutuvī ñá viꞌi antɨ̄vi, kantétu ña dā nté xee táꞌan ntuvi é ntāvaꞌa xeé xtuku Xuva ko ñūxiví, vatā ó ntákaꞌan ñá kaꞌán naa Xuva ko, ña intóo nte e náꞌa, dá xeꞌé Xuva kō é kūtuni ña nté koo kuvi. ");
INSERT INTO mizNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tsí Muiseé ne, kakaꞌan ñá ni ñata kō, ña intóo kídaā: “Xuva kō né, taxnūu ña uun ñaꞌa é dɨvi tsi tātá ko, é kaꞌan ña naa ña, vata tsī o táxnūu ña ko. Kini vaꞌa váꞌa nto nee ntɨ́ꞌɨ ntɨꞌɨ é kāꞌan ñá ni ntō, ");
INSERT INTO mizNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","tsí te xoo ñáꞌa ña ntío ña kuintiꞌxe ña é kākaꞌan ñá ne, kunaá ña. Kii nteé xio taꞌan ña ña Israee”, kaꞌan Muísee nte kídaā. ");
INSERT INTO mizNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ʼKuan ō kaꞌan ntɨɨ́ ntɨ̄ɨ́ ña kaꞌán naa Xuva ko. Diꞌna Samuee, ni ún ntɨɨ́ ntɨ̄ɨ́ ña kaꞌán naa Xuva ko, ña é vēꞌxí ata ña, ntákaꞌan ntódo ña nté koo kuvi vevii. ");
INSERT INTO mizNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Xuva kō ne, xéꞌe ña xuꞌu ñá uva ata ntō, ña intóo diꞌna. Kuvi iña ntó dɨ, tsí ntoo nto naa ña vevii. Tsí Xuva kō ne, kakaꞌan ñá ni Ābraan: “Kuenta iña íꞌxá nto ntuviko un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntoo dá kanɨɨ ñūxivi”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dukuān né, dā táxnuu Xuva ko Iꞌxā ñá ne, diꞌna kuenta iña ntó táxnuu ña, vata koo é ntāviko ña nto, vata koo é nātuꞌvi nto kuétsi ntō —kaꞌán Pedru ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedru ní Juaán ne, ntákaꞌan dúkuan ña ni ñāꞌa san dá xee dutu íña ñá Israee, ni tóꞌō sntadun íña úkūn kaꞌnu, nī ña saduceu. ");
INSERT INTO mizNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Dōó dutsī kuiní ña nī Pedru ní Juaan, tsí ntánakuāꞌa ña ñaꞌa san tsí nuu é ntaā i é ntoto xtuku o tē xiꞌi o, tsí ntóto Jesuu dá xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kidáā né, tɨ̄ɨn ña ña, tsúꞌun kutu ña ñā viꞌi utun. Uun ñúū ñúꞌu kutu ñā, tsí e kuáa da tɨ́ɨn ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ntá tsi dóo tɨtɨ́n ñaꞌa kuíntiꞌxe ña da téku ña túꞌūn é kākaꞌan ña. Kidáā ne, xée tāꞌan te uꞌun míil ñaꞌa kuíntiꞌxe ña Jesuu, é da mii kuēꞌen tsí ñatīí san ne, kaxio ñadɨ̄ꞌɨ́ san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Utén sān ne, un ntɨɨ́ ntɨ̄ɨ́ ña odo nūú iña ñá Israeé san, ni ñata, nī mastru lei iña úkūn sán ne, nātaká nuu ña ñuú Jerusaleen, ");
INSERT INTO mizNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ni dūtu, ñá odo nūu, ña nani Ānaá, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña, ni Caīfaa, ní Juaan, ni Aléjandrú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kidáā né, kāná ña Pedru ní Juaan é xntáñɨ meꞌñū ñá ña, da tsíxeꞌe ña ñā: —¿Xoó ntu táꞌxi i itsī é kuān koo vií nto? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedrú ne, dōó nuu Espíritū Sántū nima ñá, kakaꞌan ña: —Un ntɨɨ́ ntɨɨ̄ ntó, ñata, ña odo nūú iña ñá Israee: ");
INSERT INTO mizNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","te ntio nto tsixeꞌe ntō ntɨ́ nté ō xntíī ntɨ́ ña xneꞌé ne, nté ō kúvi ntuváꞌa dɨ́ꞌɨn ñā ne, ");
INSERT INTO mizNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kini váꞌa nto ve é kākaꞌán ntɨ ni ntō, tsí ntio ntɨ́ é kūtuni ntó ni ūn ntɨɨ́ ntɨ̄ɨ́ ña Israee tsí Jesucristu, ñá ñuú Nazaree, ña naxntéē ntó ntiká krusi, ña nantóto Xuva kō né, dɨvi ñā kúvi idé ña é ntūváꞌa ña sāꞌa. Iꞌa ntitsí ña nuu ntoo. Ini nto tsí ña vádā ká ña ntuvi. ");
INSERT INTO mizNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesuú ne, vata kaa xuu núu i kaa ña. Dɨvi ntō ne, vata ntáa ña ntáxntāñɨ́ viꞌi ntáa nto, é nākuíta nto xuu e dií ka vaꞌá, xuu e kúvi xuu núu i. ");
INSERT INTO mizNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tsí xōxó xtuku ka é kuvi nakākú i kō, tsí mii tsi Jēsuu é kūvi vií ña. Kuan ō dé kûꞌvé Xuva kō —kaꞌán Pedru ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ña tsiñu i sán ne, koó dā kúduꞌva ña dá ini ña tsí ña te kauꞌvi kuéꞌen tsi Pedru ní Juaan é kaꞌan ña, kuān té ñá te tuꞌve ña, ñá te naꞌnu ñāꞌa ña. Da kidáā kútuni ña é dadɨɨ íka ña ni Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ikān ntitsí ña ntuváꞌa sán dɨ. Dukuān ne, ñá ni kútuni ñá nté koo kaꞌan ntée ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kidáā ne, nantíi ña ña méꞌñū juntá san ne, da ntánatíin mii ñā, ");
INSERT INTO mizNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ntákaꞌan ña: —¿Nté ntu koo vii o ni ñā? É īní ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntoo ñuú Jerusaleen, tsí idé ña uun nuu i é dóo kaꞌnu. Ña kúvi kāꞌan o té ña nuu é ntaā i. ");
INSERT INTO mizNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ntá tsi ña ntío ko é kūkueꞌe núu i. Dukuān ne, kuéꞌe o ña ītsi e nté uun ito ka ña kaꞌan xtúku ña kuenta iña Jésuu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kidáā né, kāna xtuku ña ña, kakaꞌan ñá ni ñā: —Nté uun ito ka ñá ku kāꞌán ka nto ni ñāꞌa kuenta iña Jésuu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ntá tsi Pedru ní Juaán ne, nantíko koō ñá, kakaꞌan ñá ni ñā: —Mii nto kadā kuení nto ve. ¿Nee iña é dií ka vaꞌa é vīí ntɨ, te kuinī nto: é kuintiꞌxe ntɨ é ntákaꞌan ntó ne, ō é kuintiꞌxe ntɨ é kākaꞌan Xúva kō? ");
INSERT INTO mizNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ntɨꞌɨ́ ne, da miī é kāꞌán ntɨ ni ñaꞌa un ntɨꞌɨ̄ é īní ntɨ é edé Jesuu, un ntɨꞌɨ̄ e téku ntɨ é nakuāꞌa ñá ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ña tsiñu i sán ne, da mii tsī de tíi ña ni ñā né, dā nakaka ña ña. Ña ni kúvi kuēꞌé ña ña é ntōꞌo ña, tsi úꞌvī ñá tē dóo kaꞌan ñáꞌa san. Tsí un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ne, da mii kuēꞌen tsi ntákaꞌan ña e dóo kaꞌnu Xuva kō é kuan ō kúvi. ");
INSERT INTO mizNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tsí ña xneꞌe, ña é kuan ō ntuváꞌa dɨ́ꞌɨn ī sán ne, e ítā ntiꞌxin uvi díko kuia ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Dā ntíi Pedru ní Juaan víꞌi utun kān ne, kuéꞌen ñā mí ntoo taꞌan ña, ña kuíntiꞌxe i, kuntáa ña ni ñā nee ntɨ́ꞌɨ ntɨꞌɨ nuu i é kākaꞌan dutu ñá odo nūú san ni ñatā san ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Dā téku taꞌan ña ne, uun tsi nima ñá kaꞌan ntâꞌvi ntɨɨ́ ntɨɨ̄ ñá ni Xuva kō: —Xuvā, dɨvi ntō é Xuva ntiꞌxe ntɨ́ nto; dɨvi ntō e dóo kaꞌnu nto. Mii ntō dé kúꞌvē ntó e dukún kan ni ñūxiví a, ni ntute ñuꞌu kān, ni un ntɨꞌɨ̄ é īo. ");
INSERT INTO mizNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mii nto ni Ēspíritū Sántu ntō ne, xéꞌe nto túꞌūn é kāꞌan ña kade tsiñu iña nto, rei Davií san, dá kakāꞌan ñá naá nto nté ntūvi diꞌna, kakaꞌan ña: ¿Nté kui dóo ntákudiin ñá tuku ñuú san? ¿Nté kui doto tsī ó ntántukū nuu iní ñaꞌa san? ");
INSERT INTO mizNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kuntañɨ̄ ntée ntɨɨ́ ntɨ̄ɨ́ rei iña ñúxivi, nātaká nuu ntɨɨ́ ntɨ̄ɨ́ predente ñúú san dá ntāa ña ata Xuva ko ní Cristu, ña nakaxnúu Xuva kō, kaꞌan Dávií san kídaā. ");
INSERT INTO mizNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ʼKuan ō kúvi ntiꞌxe tsí rei Heróde ni Pōncio Pilatú ne, nātaká nuu ña má ñūú a nī ña Israee ni ña é ña te ña Israee, nátee taꞌan ña xuꞌu ñá, ntukū nuu iní ña nté koo kaꞌní ña Iꞌxá nto Jesuu, ña e dóo vaꞌá, ña nakaxnúu nto. ");
INSERT INTO mizNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dukuan ō dé ntaa ña un ntɨꞌɨ nuu i vata tsi ō dé kúꞌvē ntó nte ntúvi diꞌna é kuān koo kuvi. ");
INSERT INTO mizNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Viꞌa ve ne, koto nto, Xuvā, nté o ntáde ña e ntaínchuꞌvi ñá ntɨ. Xntii ntō ntɨ́ é ña ku uꞌví ntɨ é kāꞌan ntódo ntɨ́ ni ñāꞌa san túꞌun nto, tsí iña nto kade tsiñu ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nátānteé nto ntaꞌa nto ña nchokuvi, ntaváꞌa nto ñā. Xntii ntō ntɨ́ é kūvi vií ntɨ nuu i e dóo naꞌnu, e kueꞌe kuenta kueꞌe u ña kuenta iña Íꞌxá nto Jesuu e dóo vaꞌá ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Dā kúvi kaꞌan ntâꞌví ña ne, tēꞌxén nuu viꞌi mí ntoo ña. Ínūu Espíritū Sántū nima ñá, un ntɨɨ́ ntɨɨ̄ ñá ne, eni ntuꞌu ñā ntákaꞌan ntódo ña túꞌun Xuva kō, tsí ña te ntaúꞌvi kueꞌen tsí ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Un ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i sán ne, uun tsi nima ña, uun tsi é ntádē kuení ña. Nté uun ña ña ni de víni ña é ntio taꞌan ña. Tē nee iña é io īña ñá ne, ñá ni kāꞌan ñá te īña mii ña, tsí iña ntɨɨ́ ntɨɨ̄ ñá, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pustrú san ne, dōó iō dɨkɨ ña é kāꞌan ñá ni ñāꞌa tsí ntóto Jēsuu dá xiꞌi ña. Dōo váꞌa ō intóo ña, tsí Xuva ko īnuu méꞌñu ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nté uun ña ña ni taan núu ña, tsí tē xoó ñaꞌa é īó ñuꞌu í ne, ō viꞌi i ne, nadiko ñā ne, dá xēe niꞌi ñá diuꞌun i ");
INSERT INTO mizNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","é ntāda ña kuenta ntáꞌa pustrú san. Kidáā ne, nakeꞌnté dava ña, na kuīdo taꞌan ña, xoo ñáꞌa é kātaan núu i. ");
INSERT INTO mizNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kuān o dé uun iꞌxá ña Levii, ñá nani Jōsee, ñá vēꞌxí ñuú Chipre. Pustrú san ne, xntánteē ñá ña Bernabee, é kāni túꞌun Ña Kanaxnuu Kaꞌnu Nima Ko. ");
INSERT INTO mizNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Dɨvi ñā né, nadiko ña ñūꞌu ña ne, da xee niꞌi ñá diuꞌun i, ntāda ña kuenta ntáꞌa pustrú san. ");
INSERT INTO mizNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","É tuku ñatīi, ña é nani Anānia, ni ñádɨꞌɨ̄ ña, ña é nani Sāfirá ne, nádiko ña uun itsi ñūꞌu ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ntá tsi ña sāꞌá ne, kīꞌi ña diuꞌun í ne, xnūu váꞌa ña dava é kūvi iña mii ña. É ntōó ka kúdii ne, ntada ña kuenta ntáꞌa pustrú san. —Kuān sá kaa diuꞌun i —kaꞌan ña. Ñadɨꞌɨ̄ ñá ne, uun tsi xuꞌu ntáde ña é kuān koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kidáā ne, kakaꞌán Pedru ni ña: —Anania, ¿nté kui xnúu ntu nto nima nto é kākaꞌan Tóꞌō é ña váꞌā san? ¿Nté kui kakaꞌan ntú nto dovete nī Espíritū Sántū dá kīꞌi nto dava diuꞌun ñuꞌu san é kuvi iña mii nto? ");
INSERT INTO mizNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ñá ntu te īña mii nto ñuꞌu sán diꞌna dá nadiko ntō? ¿Ñá ntu te īña mii ntó diuꞌun í dɨ? ¿Nté kui kene iní ntu nto é kuan ō dé nto? Tsí ña te ñaꞌá san é kaeni ntaꞌví nto ña, tsí mii Xuva kō —kaꞌán Pedru ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiá ne, dā téku ña é kākaꞌan ñá ni ñā ne, nantúve ña ne, xíꞌi ñā. Dōo uꞌví ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san da kútuni ña nte o kúvi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kidáā ne, xée na kuetsī ne, dáꞌvī nuu na kúñu ña dōó ne, dā kueꞌen níꞌi na ña, kúkuꞌxí na ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Dā ita ntíꞌxin uni úra ne, xée ñadɨꞌɨ̄ ña. Váta kutūni ñá nte o kúvi xɨɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedrú ne, tsixeꞌe ña ñā: —Káꞌan vē: ¿Dūꞌva ntu kaa inuu áꞌvi ñūꞌu é nádiko ntō? —kaꞌan ña. —Kuan tsī kaa inuu áꞌvi —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kidáā ne, kakaꞌán Pedru ni ña: —¿Nté kuī kéne iní ntu o ni xɨ̄ɨ o é kuan ō dé vete nto nī Espíritū Sántū? Iꞌa kuntíꞌxi na kuetsī, na ixkúꞌxi xɨɨ o. Viꞌa ve ne, kikuꞌxí na o dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ura tsí i nantúve ña nuú Pedrú ne, xíꞌi ñā. Kidáā ne, xée na kuetsī sán ne, īní na tsi é xiꞌi ña. Tāvá na ña é kíkūꞌxí na ña diñɨ xɨɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Un ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i sán nī ña ñuu i sán ne, dōo uꞌví ña da kútuni ña nte o kúvi. ");
INSERT INTO mizNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pustrú san ne, dōó kueꞌe kuénta xēꞌé ña; dōó kiꞌin itō idé ña nuu i e dóo naꞌnu méꞌñū ñaꞌa san. Un ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i sán ne, dadɨɨ nátaká nuu ña ini ukún kaꞌnu kān mí nani Corīdoo Salámuun. ");
INSERT INTO mizNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ñá nguiī sán ne, dōo uꞌví ña é kuve taꞌan ña ña, kuān te dóo váꞌa kaꞌan ñáꞌa san iña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ntá tsi dā dií dií ka kuíntiꞌxe ñaꞌa san Tóꞌo ko Jesūcristú ne, dōo tɨtɨ́n ña nákuve taꞌan ña ña kuíntiꞌxe i san, te tíi te ñadɨꞌɨ̄ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Xee níꞌi ña ña nchokuví dɨ, tsōo ña ña nú ito, tsōo ña ña nú xūvi ítsi kān vata koo te āma kuita ntíꞌxin Pedrú ne, kuān té ntatɨ kúdii ña duku ntée ña ne, ntuváꞌa ña, kuiní ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Xée ñāꞌa san, ña ntoo etsin ñuú Jerusaleén dɨ. Ñá te da dīi ñá xee ña, odo ñā ña nchokuví, ni ña ñuꞌū é ña váꞌā nima í ne, un ntɨɨ́ ntɨɨ̄ ñá ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kidáā ne, dutu ñá odo nūú ni ūn ntɨɨ́ ntɨ̄ɨ́ ña saduceu, ñá ntɨɨ niꞌi ñā né, kūneꞌu iní ña nī pustrú san. ");
INSERT INTO mizNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tɨ̄ɨn ña ña, tsúꞌun kutu ña ñā viꞌi utun. ");
INSERT INTO mizNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ntá tsi dɨvi tsi nīñú san xee uun ánje Xuva kō, nákaán ña xiꞌi viꞌi utun, da nantíi ñā pustrú san, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Kueꞌēn ntó, kuntañɨ̄ ntó ini ukún kaꞌnu kān ne, káꞌan nto ni ñāꞌa san nté koo niꞌi ña ntuvi xēé iña ña —kaꞌan ñá nī pustrú san. ");
INSERT INTO mizNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kuéꞌen ñā. Dā tuví ne, kúntɨ̄ꞌví ña ini ukún kaꞌnu kān ne, dā éni ntuꞌu ña nakuāꞌa ña ñaꞌá san. Dā xee dútu ñá odo nūú san ni ña ntɨɨ niꞌi ñā né, tāvá ña junta káꞌnu ni ūn ntɨɨ́ ntɨ̄ɨ́ ñata, ña odo nūú iña ñá Israeé ne, dā teé tsiñu ña maú san é kinakueká ña pustrú san viꞌi utun kān. ");
INSERT INTO mizNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Dā xee ñá viꞌi utun kān ne, ¿míꞌi ntu kīꞌxi ká pustrú san? Xoxó ka ña. Kuan tsi ō ntíko kōo maú san. Ntántaa ña nī ña ñeꞌe júntā san, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Dā xeé ntɨ viꞌi utun kān ne, é kantīꞌú xiꞌi i ne, ikān ntáñɨ̄ ntée sntadún san atá xiꞌi i kan, ntáde ña kuenta; ntá tsi dā nákaán ntɨ xiꞌi í ne, xoxó ñuꞌu ká i —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dutu ñá odo nūú san nī tóꞌō sntadun úkūn kaꞌnu sán ne, dā téku ña é ntákaꞌan máú san ne, dōo ítsuꞌun ña nté koo naīnú kava ña nuu i sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ura tsí i xee úun ñatīi, kakaꞌan ñá ni ñā: —Un ntáa ña é tsuꞌun kutu ntō viꞌi utun. Ikān ntáñɨ̄ ñá ini ukún kān, ntánakuāꞌa ña ñaꞌa san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kidáā ne, ñéꞌē tóꞌō sntadún san ni māú san, ixnatɨ́ɨn ña ñā. Ntá tsi diin diin tsi nátɨɨn ña ña, tsi úꞌvī ñá te kuēꞌé xuu ñāꞌa san ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Dā náxee niꞌi ña ñá ne, kueꞌen níꞌi ña ña méꞌñū junta káꞌnú san ne, dá kakāꞌan dútu ñá odo nūú san ni ñā: ");
INSERT INTO mizNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Ntɨꞌɨ́ ne, un ntii tsi kaꞌán ntɨ ni ntō é ña ku nakuaꞌá ka nto ñaꞌa san kuenta iña Jésuu. Dɨvi ntō né, dā dií dií ka ntáde nto. É īni ntɨɨ́ ntɨ̄ɨ́ ña ñuú Jerusaleen túꞌūn é ntánakuāꞌa nto ña ne, ntadáꞌvi ntō ntɨ́ kuétsi ī é xiꞌi Jésuu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kidáā ne, Pedru ní pustru ñá nguiī sán ne, nantíko koō ñá, ntákaꞌan ña: —Dií dií ka nuu áꞌvi é kuīntiꞌxe ntɨ́ Xuva kō é ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dɨvi tsi Xuva kō, ña é inúu ini uva ata kō, ña é intóo nte ntúvi diꞌna ne, dɨvi ñā nantoto ñá Jesuu, ña éꞌní nto dá náxnteē ntó ña ntiká krusi kan. ");
INSERT INTO mizNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Xuva kō ntáa niꞌi ña ña, kuntáa ña é kutuvī ñá diñɨ kuaꞌa ña, é kodo nuū ña, é nakakū ñá kō. Dukuān né, te nātuꞌvi o kuétsi ko, xoꞌō é ña Israeé ō ne, niꞌi ko é kāda kaꞌnu iní Xuva ko ni ko kuētsí kō. ");
INSERT INTO mizNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sáꞌā é ntaxéꞌe ntɨ́ kuenta, ni Espíritū Sántū san, tsí taꞌxi Xuva kō Espíritū Sántū é kunūu ña nima ko te kuíntiꞌxe ko ñā —kaꞌán pustrú san. ");
INSERT INTO mizNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dā téku ña tsiñu i san é ntákaꞌan ñá ne, dōó dutsī kuiní ña. Ncho kaꞌní ña pustrú san. ");
INSERT INTO mizNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ntá tsi uun ñaꞌa, ña farīseu, ñá nani Gamālieé ne, mastrú lei iña ñá Israee ñá, ne, dōo íko ñuꞌu ñāꞌa san ña. Dɨvi ñā ne, nákuntītsí ña, kakaꞌan ñá te nantīi ña pustrú san kiꞌi kan uun daꞌna. ");
INSERT INTO mizNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kidáā ne, kakaꞌan ñá nī ña tsiñu i san: —Ña Israeé, kadā kuení vaꞌā ntó nté koo vií nto ni ña sāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tsí emá tsi ne, xío uun ñatīi, ñá nanī Teudá ne, dōó kaꞌnu ncho vií ña. Xío te kɨ̄mí sientu ñátīí, ña ntīkɨn ña. Ntá tsi dā kúvi ne, ñaꞌa éꞌní ña ña ne, kidáā nákuite xáa ntɨɨ́ ntɨ̄ɨ́ ña ntɨɨ niꞌi ñā. Kidáā ne, xíō daꞌna. ");
INSERT INTO mizNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Rkontûví, ntuvi dá nakaꞌvi ña ñāꞌa sán ne, ñá nanī Júdā, ña ñuú Galileá ne, dōó kaꞌnu ncho vií ña ne, ñá te da dīi ñaꞌa intíkɨn ñá ña dɨ. Ntá tsi xiꞌi ñá dɨ ne, dā nákuite xáa ntɨɨ́ ntɨ̄ɨ́ ña intíkɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Dukuān é kākaꞌán u ni ntō é na tsoo mii nto ña sāꞌa. Ñá ku kini ntēé ka ntó ña. Tsí te kuēnta iña ñáꞌa é ntánakuāꞌa ña ne, koó daꞌna miī. ");
INSERT INTO mizNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ntá tsi te kuēnta iña Xuva ko é ntánakuāꞌa ña ne, ña kúvi viī nto é kini nteē ntó ña. Kuenta tsí vií nto ve vata koo é ña kaꞌan ntée nto Xuva kō —kaꞌan Gámalieé san. ");
INSERT INTO mizNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Xíō ntaa iní ña tsiñu i san é kākaꞌan ña. Kidáā ne, nákana ña pustrú san é ntīꞌxi xtuku ña. Dā náxee ñá ne, nátiī nuu ña ña xoꞌó ne, dá kakāꞌan ñá ni ñā é ña ku kaꞌán ka ña iña Jésuu. Kidáā ne, nakáka ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Dā ntíi pustrú san méꞌñū juntá san ne, dōo diní ña, tsí xeꞌé Xuva kō é ntōꞌo ña kuenta iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ñá ni tee dāꞌna kueꞌen tsí ña é nakuāꞌa ña ñaꞌá san. Nguentúvi ntákaꞌan ntódo ña ni ñāꞌa san kuenta iña Jésuu ini ukún kaꞌnu kan nī nú viꞌi ñāꞌa sán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ntuvi tsikán ne, kūtɨtɨ́n ña kuíntiꞌxe i Cristu. Kidáā ne, xío ñāꞌa e ntákaꞌan túꞌūn griegu éni ntuꞌu ñā tsiꞌi kuétsi ñā ña ntákaꞌan túꞌun hēbreú san, ntákaꞌan ñá tsí ñadɨ̄ꞌɨ kii, ña ntákaꞌan túꞌūn griegú san ne, ñá kuēꞌe tsi ntániꞌi ña mí kāxɨꞌɨ é kāꞌxi ñá utén utén, tsi dií ka kueꞌe ntániꞌi ñadɨ̄ꞌɨ kii, ña ntákaꞌan túꞌun hēbreú san. ");
INSERT INTO mizNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Dukuān ne, uxúvi ñāꞌa pustrú san kāna ña un ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i san é nataká nuu ña. Kidáā ne, kakaꞌan ñá ni ñā: —Tē ntɨꞌɨ́ vií ntɨ tsiñu é kuēnta vií ntɨ ñaꞌa sán ne, ña kúvi vīí ntɨ é nakuāꞌa ntɨ́ nto túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Dií ka váꞌā ó, ení, dɨvi ntō nakaxnúu nto uꞌxe ñáꞌa ñaꞌa nto é koto ña tsiñu sāꞌa. Nakaxnúu nto ñatīi, ña e dóo ini nté koo vii i, ña e dóo nuu Espíritū Sántū nima i, ña ntaíko ñuꞌu ñaꞌa sán ne, dɨvi ñā é viī ñá tsiñu é kuēnta vii ña ña ñaꞌa san, é tsīꞌi ña é kāꞌxí ñadɨ̄ꞌɨ kií san. ");
INSERT INTO mizNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Dɨvī ntɨ́ ne, da mii tsī é kāꞌan ntâꞌví ntɨ nī é nakuāꞌa ntɨ́ ñaꞌa túꞌun Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ñá nguiī sán ne, xkúntee iní ña é ntákaꞌan pústrú san. Kidáā né, nākaxnúu ña uꞌxe ñáꞌa, vatā ó kaꞌan ña: diꞌna Esteba, ña e dóo kainuu iní i Xuva kō, e dóo nuu Espíritū Sántū nima ña; kidáā ne, Felipe, ni Prócuru, ni Nicānoo, ni Tīmuún, ni Pārmena, ni Cúlaa. Culaá san ne, ñuú Antioquia véꞌxi ña, ntá tsi kantīkɨn ñá Xuva ko vatā o dé ña Israee dá éni ntuꞌu ñā kuíntiꞌxe ña Cristu. ");
INSERT INTO mizNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ntēka ña uꞌxe ñáꞌa ñatīí san, kueꞌen niꞌi ña ña mí ntoo pustrú san. Pustrú san ne, xntekū ñá ntaꞌa ña dɨkɨ ñá uꞌxe ñáꞌa sán ne, kaꞌan ntáꞌvī ñá iña ña da xnuú ntaꞌa ña ña tsīñu san. ");
INSERT INTO mizNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kidáā né, dōo ite xáa túꞌun Xuva kō né, kūtɨtɨ́n ña kuíntiꞌxe i Tóꞌo ko Jēsuu, ña ntoo ñuú Jerusaleen. Ikān ne, tɨtɨ́n dutu ñá Israee kuíntiꞌxe ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebá san ne, dōó kiꞌin itō idé ña nuu i e dóo kaꞌnu, tsí Xuva kō dóo xntíi ña ña ne, nāxnuu viko ña ña. Koó dā kúduꞌva ñaꞌa san da íni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ntá tsi īó ña véꞌxi úkūn é nanī Ña Nakáku, nī ña véꞌxi ñuú Cirene, ñuú Alejandria, ñuú Ciliciá, nī ñuu Ásiā ne, ñá nī xkúntee iní ña é kākaꞌan Ésteba. Tuku ō dé kuení ña ne, eni ntuꞌu ñā ntánāa núu ña ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ntá tsi ña ni kuvi vií ña ni ñā, tsi dóo váꞌā ó kakaꞌan ña, tsí xeꞌe Espíritū Sántū san é kūtuni ña nté koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kidáā ne, ntáꞌvi ña ñaꞌa san é dāꞌví ña Esteba dóvete. Tsīꞌi ña dɨkɨ ña é kāꞌan ña tsí kākaꞌan kíni Esteba iña Muísee ni íña Xuva kó dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Dukuan ō nateñu núu ña ñaꞌa sán, ni ñata, nī mastrú lei Xúva kō. Kidáā né, dā nénī tsi Esteba, tɨ́ɨn ña ña, kueꞌen niꞌi ña ña mí ntoo ñá odo nūu, ntáde ña junta. ");
INSERT INTO mizNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Xee níꞌi ñā ña é kāꞌan dóveté san ne, ntákaꞌan ña: —Ña sāꞌá ne, dōó kakaꞌan ntée ña viꞌi Xuva kō né, dōó kinī ó kakaꞌan ñá iña leí san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tēkú ntɨ é kākaꞌan ña tsí Jesuu, ñá ñuú Nazareé ne, nakatsin ña viꞌi Xuva kō ne, nadama ña é vatā xkoó ini ō e xtûví Muisee —kaꞌan ñá kaꞌan dóveté san. ");
INSERT INTO mizNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kidáā ne, un ntɨɨ́ ntɨ̄ɨ́ ña odo nūú san nī ña ntoo sán ne, īto ña Estebá ne, īní ña nuu ña e xiꞌí nuu vatā ó kaxiꞌí nuu nuu ánjē. ");
INSERT INTO mizNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kidáā ne, kakaꞌan tóꞌō dutu íña ñá Israeé san, katsixeꞌe ña Ēsteba: —¿Ntāa ntu é ntákaꞌan ñá sāꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kidáā né, eni ntuꞌu Ēsteba kakáꞌan ñá ni ñā: —Un ntɨꞌɨ kuēꞌen dúꞌva nto, te kuetsi te naꞌnu nto, kini nto é kākaꞌán u ni ntō: Ini nto tsí Xuva kō, ña dóo kaꞌnu, ntii díto ñá nuu uva áta ko Ābraan nte ntúvi diꞌna, dá tūvi dukuan ña ñuú Mesopotamia, diꞌna dá kɨ̄ꞌɨn ña é kikutúvi ña ñuú Haraan. ");
INSERT INTO mizNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ne, kakaꞌan Xúva ko ni Ābraan: “Xtuvīn miin ñuú o ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi o, kuēꞌén xio ñuu mí nañēꞌé u o ve”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kidáā ntáka Abraan ñuú Caldea, kuéꞌen ña, kukutuví ñá ñuú Haraan. Rkontûví ne, xíꞌi uva ñā né, Xuva kō kíxnteká ña ña, xee ña ñuu sáꞌa mí ntoo ó vevii. ");
INSERT INTO mizNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ntá tsi Xuva kō ñá ni xēꞌé ña ñuꞌu é kūvi iña mii ña, nté un siin. Ntá tsi xeꞌé ña xuꞌu ña é dā nte rkontûvi kuéꞌe ña ña ñuꞌú san. Tē xiꞌi ñá ne, kuvi iña iꞌxá ña ni īꞌxá ika ñā dɨ́, kuān te ntuvi tsíkán ne, váta kōo iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Sáꞌa kākaꞌan Xúva ko ni Ābraan: “Iꞌxá o ne, xio ñuú kuntōo ña; ñá te ñūú mii o kuntoo ña. Kidáā né, dōo kini koo vií ñaꞌa san ni ñā. Kīꞌi ña ña é kuētsi é kāda tsiñu ña iña ña. Kɨ́mī sientu kuia é kuan koo nantōꞌo ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ntá tsi kuéꞌē u é ntōꞌo ña ñuu tsíkan e kuán koo nantōꞌo ña iꞌxá o. Kidáa ntīi iꞌxá o ñuu tsíkan, naxee ñá ñuu sáꞌa ne, iꞌa tsi kuntoo ña, kunuu inī ñá ko”, kaꞌan Xúva ko ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kidáā ne, xéꞌe Xuva ko xuꞌu ña ni Ābraán ne, dē kúꞌvē ña é tēꞌnte un siin kúñū é īxi un ntɨɨ́ ntɨ̄ɨ́ iꞌxa tií san vata koo é dîto e ntáduku ntée ña Xuva kō. Dukuān né, dā káku iꞌxá ña é nani Īsaá ne, dē ntaa Ábraan, éꞌnté ña kúñū é īxi i da kúvi ūna ntúvi káku ne, kuan tsī o dé Isaa ni íꞌxá ña é nani Jācoó ne, kuan tsī o dé xtuku Jacoo ni ún ntɨɨ́ ntɨ̄ɨ́ iꞌxá ña, dɨvi ñā é uva ūxuvi tátá ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ʼIꞌxá Jacoó san ne, kūneꞌu iní ña ni enī ña, ñá nani Jōseé ne, díko ña Jōseé san. Ña ñuú Egítō ñíi ña ña é kāda tsiñu ñá iña ña. Ntá tsi ínūu méꞌñu Xuva ko Jōseé san ne, ");
INSERT INTO mizNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nákākú ña ña é kāntoꞌo ña. Xéꞌe ñā e dóo kiꞌin īní Josee nté koo vií ña ne, xéꞌe ñā e dóo kuinima reí ñuú Egítō sán ña, dɨvī rei, ñá nani Farāuun. Reí san ne, nākaxnúu ña Josee é kodo nuū ñá ñuú Egíto nī nú viꞌi ña kān dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ʼKidáā ne, kútama ñuú Egíto ni ñūú Canaan. Ñá ni nīꞌi ñáta kō é kāꞌxi ña. Dōo ntóꞌo ña dókō. ");
INSERT INTO mizNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ntá tsi xee túꞌūn ntaꞌa Jacoo tsí īó trigu ñúú Egítō sán ne, táxnūu ña iꞌxá ña, dɨvi uva ata ika kō. ");
INSERT INTO mizNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dā kúvi uvi íto ñeꞌe ñá ne, da kidáā xeꞌé Josee kútuni ña é ēni míi ña ñā ne, kidáā kútuni Fárauun é ñaviꞌi Joseé san ne, tatá Israee ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kidáā ne, táxnūu Josee túꞌūn é kɨ̄ꞌɨn úva ña Jācoo, ni ún ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña, kikuntóo ña ñuú Egítō. Úni dīko xeꞌun ñáꞌa ña ");
INSERT INTO mizNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","xée ña é kuntōo ña ñuú Egítō. Ikān xiꞌí Jacoó ni ñata kō, ña intóo diꞌna. ");
INSERT INTO mizNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Dā rkontûvi dá xiꞌi ñá ne, kueꞌen níꞌi ña ña ñūú Siqueén ne, ikan īntúꞌxi ña ñaña e ñíi Abraan ntáꞌa iꞌxá Hamoo. ");
INSERT INTO mizNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ʼE dóo káxa ñá Israeé san ñuú Egítō da xee étsin ntuvi é ntūntaa é kākaꞌan Xúva ko dā xeꞌé ña xuꞌu ña ni Ābraan. ");
INSERT INTO mizNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kidáā ne, xée tūku ñaꞌa é viī ñá rei ñuú Egítō ne, rei tsikán ne, ña ni ínī ñá xoo e Jósee. ");
INSERT INTO mizNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rei saꞌá ne, ēni ntaꞌví ña ñata kō né, dōo nantóꞌo ña ña. Dē kúꞌvē ña é nakuitā ñá un ntɨꞌɨ īꞌxa tií san é dā ve kakaku vata koo é na kūvi, tsí ntio ña é nantɨ̄ꞌɨ ña tatá kō. ");
INSERT INTO mizNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ntuvi tsikán ne, káku Muisee. Uni xóo xtúvi xuꞌu ña i má viꞌi ña kān é nakuēꞌnu ña i, tsi dóo ntio Xuva ko ī. ");
INSERT INTO mizNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Dā ña ni kuvi vií ka ña ni ī né, da miī é xtuví xaa ña i. Kidáā né, dɨvi tsī diókō reí san kíꞌi ña i ne, nakuéꞌnu ña i vata tsi te iꞌxá mii ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Dukuān ne, kutúꞌve Muiseé san é un ntɨꞌɨ̄ é īni ña Egíto ne, dōo íni ña nté koo kaꞌan ñá ne, dōó iō ña é viī ñá nee ntɨ́ꞌɨ ntɨꞌɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ʼDā ntɨꞌɨ ña uvi díko kuiá ña ne, dē kuení ña é kɨ̄ꞌɨn ña, kikoto níꞌni ña ñaꞌa ña, ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ikān íni ña tsí uun ñaꞌa ña Egíto kanantōꞌo ña uun ñaꞌa ña Israee. Muiseé ne, nadáꞌan ña ñāꞌa ña, ña Israeé san ne, ēꞌní ña ña Egítō san. ");
INSERT INTO mizNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kuiní ña té kūtuni ñaꞌa ña é Xuva kō táxnūu ña ña é nakákū ñá ña. Ntá tsi ñá te kuan ō ni ñeꞌe dɨ́kɨ ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tuku ntuvi ne, taꞌan túku Muisee úvi ñaꞌa ñá Israee, ntánaā ñá ne, ntio ña é nakaꞌnté nuu ña, kakaꞌan ña: “¿Nté kui kuān ó de ntu nto? Tsí ñá vāꞌá ō é naa o ni taꞌan kō”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kidáā ne, uun ñaꞌa ña, ña é kadē xení ni tāꞌan i ne, tɨꞌvi nūu ña Muisee, kakáꞌan ña: “¿Xoó ntu kakaꞌan i é kadā kúꞌvē nto iñá ntɨ, é xntēkú kuꞌvē ntó ntɨ? ");
INSERT INTO mizNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Vá kaꞌnī ntú nto ko vata ō éꞌni nto ña Egítō san iku?”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Dā téku Muisee é kākaꞌan ñá ne, īnu ña ñuú Egítō, kuéꞌen ña, kukutúvi ñá ñuú Madiaan. Ikān éni viꞌi ña ne, xío ūvi iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ʼÍtā ntiꞌxin uvi díko kuiá ne, uun ntuvi kaika Muisee má kūꞌu kan etsin xuku é nani Sināii. Ikān íni ñá é kaīꞌxi ntáꞌa utun sán ne, ntii díto uun ánje Xuva kō méꞌñū ñuꞌu é kaīꞌxí san. ");
INSERT INTO mizNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Koó dā kúduꞌva Muisee da íni ña ne, xée ētsin ña é koto díto ña. Tēkú ña tatsin Xúva kō é kākaꞌan ñá ni ñā: ");
INSERT INTO mizNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Xuꞌú ne, Xuva ñáta o Ābraan, Ísaa, ni Jácoo”, kaꞌan ña. Koó dā kanɨ́ꞌɨ Muisee e dóo ūꞌví ña ne, úꞌvī ñá é kōto ña ñuꞌu san. ");
INSERT INTO mizNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ne, kakaꞌan Xúva ko ni ñā: “Nantīin ntiꞌxen o, tsí ñuꞌu mí ntītsín san ne, ñuꞌu kuîko. ");
INSERT INTO mizNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Xuꞌú ne, é iní u é kuān nte ntántóꞌo ñaꞌa ko ñuú Egítō. É tēkú ko e dóo ntaꞌví o ntátaan nuu ña. Dukuān é vēꞌxi ú é nakākú u ña. Niꞌín ve, tsí nataxnūu ú o ñuú Egítō”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ʼKuān te nántii niꞌni ñata kō san Muisee dá ntákaꞌan ña: “¿Xoó ntu kakaꞌan i é kadā kúꞌvē nto iñá ntɨ, é xntēkú kuꞌvē ntó iñá ntɨ?”, ne, dɨvi ñā é taxnuu Xuva kō é kadā kúꞌvē ntíꞌxe ña, é nakakū ñá ña Israeé san, tsí kuān ó kakaꞌan Xúva ko ni ñā da ntii dîto ánjē san méꞌñu ūtun é kaīꞌxí san. ");
INSERT INTO mizNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Dɨvi Muīseé san é nátava ña ñata kō san da ntáka ña ñuú Egítō. Dɨvi ñā e dé ña nuu i e dóo naꞌnu. Dōo kueꞌe kuénta xeꞌé ña dā intóo ña ñuú Egíto, dā ita ntíꞌxin ñata ko Ntute Ñuꞌu Kuēꞌé ne, da nɨɨ̄ íka ña uvi díko kuia má kūꞌu kán dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Dɨvi tsi Muīsee é kākaꞌan ñá nī ña Israeé san: “Xuva ko ne, taxnūu ña uun ñaꞌa, ña é kaꞌán naa ña vata tsī ó de ú xuꞌu, uun ñaꞌa, ña é dɨvi tsi tāta ko”, kaꞌan Muísee. ");
INSERT INTO mizNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Muisee xtúku tsi san é itúvi ña ni ñata kō da nátaká nuu ña má kūꞌu kán ne, dɨvi ña kākaꞌan ñá nī ánjē rkɨ uku Sínaii da xeꞌé Xuva kō túꞌun ñā é kātaꞌxi ntuvi iña ko é kāda ntaa o. ");
INSERT INTO mizNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ʼNtá tsi ñata kō sán ne, ña ni ntío ña kuintīꞌxe ña Muiseé ne, nántii nīꞌni ña ña. Tɨ̄vi ínī ña e ntáka ña ñuú Egíto ne, ntīo ña é ntiko kōo xtúku ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kidáā né, kakaꞌan ñáꞌa sán ni Āroon: “É ntīo ntɨ́ ne, kāda váꞌa nto é kūvi xuva ko, é kodo nūú nuu ko, tsí ñá ini o nté ō kúvi ni Muīsee, ñá natavā ko ñuú Egítō”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kidáā ntaváꞌa naā ñá uun iꞌxá duntɨkɨ e kúvi tɨ xuva ñā né, ēꞌní ña kɨtɨ kantíto ntiꞌxe é kāꞌmi ña tɨ nuu kɨ́tɨ ntuváꞌa nāá san vata kaa doméni é kuēꞌé ña tɨ. Tāvá ña dodîni iña xuva ñā e ntaváꞌa nāa míi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Xuva kō né, tsoo mii ña ñā kídaa, ku ika ña ñā ne, xéꞌe ñā é dotō tsí kunuu inī ña ngántii ni xoo ni ūn ntɨɨ́ ntɨ̄ɨ́ xntɨvi é īó e dukún kan, vatā ó uve naꞌa iní tutu é de váꞌa ña é kākaꞌán naa Xuva ko kídaā: ¿Amá ntu táꞌxi nto kó doméni kɨtɨ éꞌni nto da íka nto má kuꞌu kan da nɨɨ̄ é ūvi díko kuiá san? ");
INSERT INTO mizNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Da mii kuēꞌen tsi é ido nto viꞌi doo iña xuva nto Moloó ne, īdo nto xntɨvi iña xuva nto Refaan. Ñá te dɨvī ú ntánuu iní nto ko, tsí kudii e ntávaꞌa nāa mií nto ntánuu iní nto. Dukuān né, natāvá u nto ñuú nto ne, natsoo ú nto dií ka ikā é ñuú Babilonia, kaꞌan Xúva ko nī ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ʼDā íka ñata kō má kūꞌu kán ne, ínīꞌi ñá viꞌi doo e kúvi xúkūn, mí ñuꞌu váꞌa lei iña Xuva ko, dɨvī é ntávaꞌa nāá ñaꞌa san vata tsi ō nañéꞌe Xuva kō Muisee. ");
INSERT INTO mizNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Xúkūn viꞌi doó san ne, kuvi iña ñáta kō kídaa ne, kuan tsī ó ntaído ñā dá xee ñá ni Jōsuee dá idé ña duꞌxen nī ña xio ñuu, é kíꞌi ña ñuꞌu ña, tsí Xuva kō nantii ña ña é ña te ña Israeé san vata koo é kūvi kuntoó ñata ko ñūú saꞌa. Ne, iꞌa katúvi xúkūn viꞌi doó san nté ntūvi dá itúvi rei Davii. ");
INSERT INTO mizNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Rei Davií san ne, dōó ntio Xuva ko ñā. Ncho xntitsī ñá xúkun kāꞌnu iña Xuva ko, é dɨvi tsi Xuva ñata ko Jācoo; ");
INSERT INTO mizNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ntá tsi rei Salamuun kúvi idé ña xntítsī ñá xúkūn san. ");
INSERT INTO mizNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ntá tsi Xuva kō, ña e dóo kaꞌnu sán ne, ñá te īni ukun e xntítsī ñaꞌa san kutuví ña. Tsí vatā ó kakaꞌan ña é kākaꞌán naa Xuva kó ne: ");
INSERT INTO mizNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Viꞌi antɨvi ā tuví u, kadē kûꞌvé u. Ñuxiví san ne, vata kaa teu é nteku ntiꞌi dɨ̄ꞌɨn ko kaa. ¿Nté ntu kaa viꞌi é xntitsi ntō iñá ko? ¿Ō míꞌi ntu kūtuví daꞌna u? ");
INSERT INTO mizNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ñā ntu te xúꞌu e dé kûꞌvé u neé ntɨꞌɨ ntɨꞌɨ é īo? kaꞌan Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ʼUn ntɨꞌɨ kuēꞌen dúꞌva nto ne, ¿nté kuān nte lóꞌo ntu nto? ¿Ña ntátekú kueꞌen xnto? Vata tsi tē ña íni nto xoo é Xuva kō. Ñá ntákuintiꞌxe kueꞌen xnto é kākaꞌan Espíritū Sántū san. Dadɨɨ xnto ni ñata ntō. ");
INSERT INTO mizNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Dōo nantóꞌo ña da xōó ka ñaꞌa, ña é kaꞌán naa Xuva kó ne, ēꞌní ña ñaꞌa, ña é kākaꞌan é kiꞌxi uun ñatīí, ña e dóo vaꞌa é taxnuu Xuva kō. Vevií ne, é kīꞌxi ñá ne, dɨvi ntō díko nto ñā né, ēꞌní nto ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dɨvi ntō niꞌi ntó lei iña Xuva ko e kíxniꞌi ánjē san kídaa ne, ntē ña ni kuintíꞌxe nto leí san. —Kuan ō kaꞌan Ésteba ni ñá odo nūu iña ñá Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Dā téku ñaꞌa san é kākaꞌan Éstebá ne, kūdiin kuéꞌen ña. Vevií tsi kaꞌxí kueꞌen ñá ña, kuiní ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ntá tsi Estebá ne, dōo nuu Espíritū Sántū nima ña. Ntāa niꞌi ña nuu ñá e dukún kan, īní ña Xuva kō e dóo kaxiꞌí nuu kaꞌnu ña ne, ntitsí Jesuu díñɨ kuaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kidáā né, kakaꞌan ña: —¡Un kaa é kainí u! Nākaán viꞌi antɨ̄vi ne, kainí u Ña Vexkúvi Ñatīi, ntitsí ña diñɨ kuaꞌa Xuva kō —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ntá tsi dutú san ne, kūdiin kuéꞌen ña é kuān ó kakaꞌan ña. Ēdɨ́ ña loꞌxo ñá ne, koó da vāntiñɨ ña tɨ́ɨn ña Esteba, ");
INSERT INTO mizNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","kueꞌen níꞌi ña ña diñɨ ñuú kān né, ikān xeꞌé xuu ña ñā. Ña ntátsiꞌi kuétsi ñā sán ne, tsoo váꞌa ña doo ña ntaꞌa uun ná kuetsī, ná nanī Saúlū. ");
INSERT INTO mizNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ntá tsi, da nɨɨ̄ ntáxeꞌé xuu ña ñā ne, kakaꞌan ntâꞌví Esteba, kakaꞌan ña: —Tōꞌó ko Jesuu, nakiꞌi nto nimá ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kidáā ne, nakunchɨ́tɨ ña ne, un ntii tsi kākaꞌan ña: —¡Xuvā, kaꞌnu vií nto nima ntó ni ña sāꞌa tsí kuān ó ntáde ña nī ko! —kaꞌan ña. Dā kúvi kaꞌan ña sáꞌa ne, xíꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saúlū ne, iō ñá dodîni é kāꞌní ñaꞌa san Esteba. Dɨvi tsi ntūvi tsikan iñɨ ntuꞌu é dóo ntánantōꞌo ñaꞌa san ña ntákuintiꞌxe i Jesuu, ña ntoo ñuú Jerusaleen. Ne, īnu ntɨɨ́ ntɨɨ̄ ñá, dotō tsí kueꞌen ña, kukuntóo ña ñuú Judea ni ñuú Samaria. Miī sá pustrú san kantóo ña ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ntá tsi iō ñaꞌa, ña é dóo ntánuu iní i Xuva kō né, dɨvi ñā iꞌxí ña Estebá ne, dōo éku nteé ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Da nɨɨ̄ Saúlū né, kuan tsī ó de ña, kanantōꞌo ña ña ntákuintiꞌxe i san. Kataꞌvi ña xiꞌi ñaꞌa sán ne, katavá ña ña, te tií te ñadɨ̄ꞌɨ, é tsuꞌun kutu ña ña viꞌi utun kān. ");
INSERT INTO mizNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ntá tsi ña kuíntiꞌxe i, ña e éka ñuú Jerusaleén ne, taꞌán ñuu taꞌán ñuú kueꞌen ña, ntákaꞌan ntódo ña túꞌūn vaꞌá iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Uun ñaꞌa, ñá nani Fēlipé ne, kuéꞌen ñā uun ñuu é kāduku ntée ñuú Samariá ne, ikan kākaꞌan ñá ni ñāꞌa iñá Cristu. ");
INSERT INTO mizNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nātaká nuu ñaꞌa san é kīni ña é kākaꞌan ñá ne, uun ito tsi kuíntiꞌxe ntɨɨ́ ntɨɨ̄ ñá é kākaꞌan Félipe. Ntaíni vaꞌa váꞌa sa un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san é kākaꞌan ñá ni ñā ne, ntaíní ña tsí kade ña nuu i e dóo naꞌnu. ");
INSERT INTO mizNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Xíō ñaꞌa, ña é ñūꞌu é ña váꞌā nima í ne, koó dā ntákachuꞌu ntáa é ña váꞌā san da ntántii nima ñáꞌa san. Ne, dōo tɨtɨ́n ña natɨ́ɨn nī ña xneꞌé dɨ ne, ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Uun ito tsi nákuꞌun dini kueꞌen nima ñáꞌa san, ña ntoo ñuu tsíkan. ");
INSERT INTO mizNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ntá tsi uun ñatīi, ñá nani Sīmuún ne, tatān ña. Ēmá tsi kade tatan ña, kaeni ntaꞌví ña ña ntoo ñuú Samaria, kakaꞌan ñá tsi dóo kaꞌnu ñaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, te kuetsi te naꞌnu ña ne, dōó ntaíni ña é kākaꞌan ñá ni ñā ne, kuíntiꞌxe ña ña, ntákaꞌan ña: —Ña sāꞌá ne, dōó iō ñá é viī ñá. Vatā ó kade Xuva kō kade ña —kaꞌan ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Dōo kuíntiꞌxe ñaꞌa san ña, tsí koó dā ntákudúꞌva ña nuu i é kākuvi kade ña. Tsi éma tsi kuān ó de ña, kaeni ntaꞌví ña ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ntá tsi dá xee Félipé ne, eni ntuꞌu ñā kakaꞌan ntódo ña iña i mí kadē kûꞌvé Xuva kō, kakaꞌan ñá kuenta iña Jesúcristu. Kuīntiꞌxe ñaꞌa sán ne, tɨtɨ́n ña ítsi ntute ña, te tií te ñadɨ̄ꞌɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Uun tsi nte Simuun kuíntiꞌxe ña, ítsi ntute ña dɨ́ ne, dā éni ntuꞌu ñā intíkɨn ñá Felipe. Koó dā kúduꞌva ña é kaīni ña nuu i é dóo naꞌnu san ni e dóo kueꞌe nuu i é edé ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kidáā ne, xée tūꞌun ntaꞌa pustru, ñá ntoo ñuú Jerusaleen, tsí e kuíntiꞌxe ña ñuú Samaria túꞌun Xuva kō né, ikān táxnuu ña Pedru ní Juaan, kuéꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Dā xee ña ñuú Samariá ne, kaꞌan ntáꞌvī ñá iña ñá ntoo ikān vata koo é nīꞌi ña Espíritū Sántū. ");
INSERT INTO mizNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tsí nté uun ña vata kunūu Espíritū Sántū nima ña; mii tsi kuēnta iña Tóꞌo ko Jēsuu ítsi ntute ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kidáā ne, Pedru ní Juaan xntéku ña ntaꞌa ña dɨkɨ ñáꞌa san ne, inúu Espíritū Sántū nima ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dā íni Simuun tsí niꞌi ñaꞌa san Espíritū Sántū san dá xntéku pustrú san ntaꞌa ña dɨkɨ ñá ne, kaxeꞌe kuétsi ña ña diuꞌun, ");
INSERT INTO mizNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kakaꞌan ña: —Taꞌxī nto é kūvi vií u vatā ó de nto, vata koo é tē xntekú u ntaꞌa ko dɨkɨ ñáꞌá san ne, níꞌi ña Espíritū Sántū sán dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kidáa kakāꞌán Pedru ni ña: —¡Ñá tē diuꞌun o é ntio ko! ¡Na kūnaán miīn ní diuꞌun o, tsí kuān ó kadē kuení o é kuiin diuꞌun o é kataꞌxi Xuva kō doméni! ");
INSERT INTO mizNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ñá te sāꞌa é kāduku ntéen, tsí ña te váꞌa nima o nuu Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Natuꞌvin kuetsi o, kákan ntaꞌa Xuva kō é kāda kaꞌnu iní ña ni ō é kuān ó kadē kuení o. ");
INSERT INTO mizNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tsí dɨvin ne, dōo kûvé nima o, dōo kúkaven ni kuētsí o —kaꞌán Pedru ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kidáā ne, kakaꞌan Símuun: —Mii nto kākan ntó ntaꞌa Xuva kō é ña kuan koo kúvi ko vatā ó kakaꞌan ntó san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pustrú san ne, dā kúvi kaꞌan ntódo ña túꞌun Xuva ko, ni dā kúvi ntaa ña ni ñāꞌa é un ntɨꞌɨ̄ e íni ña ne, kúnūꞌú ña ñuú Jerusaleen. Ítā ntiꞌxin ña tɨtɨ́n ñuu é kāduku ntée ñuú Samariá dɨ ne, ikān kaꞌan ntódo xtuku ña túꞌūn vaꞌá iña Jesúcristu. ");
INSERT INTO mizNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kidáā ne, ntii dîto uun ánje Xuva ko nūu Félipe, kákaꞌan ña: —Kuēꞌen máa i kān mí nuu ítsi é kaīta ntíꞌxin ñuú Jerusaleen é kāñeꞌe ñuú Gaza —kaꞌan ña. Itsi sāꞌá ne, da miī má kūꞌu mí xoxo ntoó i. ");
INSERT INTO mizNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipé ne, kuéꞌen ñā ne, itsi kān táꞌan ña uun ñaꞌa ñatīí, ña véꞌxi ñuú Etiopía. Ña tsīkán ne, ña tsiñu i, dɨkɨ í ña iñá reina ñuú Etiopía, ñá nani Cāndace. Itsi kan vēꞌxí ña saꞌa é ñeꞌe ña ñuú Jerusaleen é viī ñá nchuꞌún iña Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ntiko koō ñá ñuú ña kān ne, nuu váꞌa ña iní viꞌi é kāñuꞌu ídu. Nuu ña, kanakuāꞌa ña tutu é de váꞌa Isaía, ña kakaꞌán naa Xuva ko nte ntúvi diꞌna. ");
INSERT INTO mizNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kidáā ne, kakaꞌan Espíritū Sántū sán ni Fēlipe: —Kuēꞌén, kūntikɨn víꞌi é kāñuꞌu idú san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Koó dā kainu ña, kueꞌen ñá ne, xēe ntíkɨn ña viꞌi é kāñuꞌu idú san. Tēkú ña é kanakuāꞌa ña ñuú Etiopía san tutu é de váꞌa Isaía ne, tsixeꞌe ña ñā: —¿Kāñeꞌe dɨkɨ ntu nto é kanakuāꞌa nto san? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ña ñuú Etiopía san ne, kakaꞌan ña: —¿Míꞌi ntu? Dōó xuꞌū ó kakaꞌan. ¿Xoó ntu kuvi vií i nañēꞌe í ko neé kani túꞌun? Kixkene nto, kutuvī ntó diñɨ ko —kaꞌan ñá ni ñā. —Kuvi dɨ —kaꞌan Félipe. ");
INSERT INTO mizNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mí kanakuāꞌa ña túꞌun Xuva kō né, duꞌvā ó kakaꞌan: Tsí ntēka ña ña é kaꞌnī ñá ña vata kaa uun a leꞌntu é kāꞌni ña i; vata tsi kaa uun a leꞌntu e dóo toꞌo, é ña te kaítsuꞌūn dá kādeté ña idi i ne, kuān koo kuvi ña; diin diin tsi kutuvī ñá dɨ; ñá kāꞌan kueꞌen tsí ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nantii niꞌni ña ña ne, ñá ni ñēꞌe meꞌñu ña é kūtuni ña kuétsi ñā. ¿Míꞌi ntu xio iꞌxá ña? Tsí nákiꞌi ñaꞌa san ntuvi iña ña ñúxiví sa. Sáꞌa kakāꞌan túꞌun Xuva kō mí nakuaꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kidáā né, katsixeꞌē ña ñuú Etiopía san Felipe, kákaꞌan ña: —Vií nto da xeꞌe, káꞌan nto nī ko: ¿Xoó ntu iña i é kākaꞌan ñá sāꞌá, ña é kākaꞌán naa Xuva ko? ¿Īña mii ntu ña kakáꞌan ñá ne, ō iña tuku ñáꞌa? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kidáā né, eni ntuꞌu Fēlipe, kakaꞌan ñá ni ña, kanañēꞌe ñá ña nee é kani túꞌun túꞌun Xuva kō mí kanakuaꞌa ña ne, kakaꞌan ñá ni ña īña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kidáā né, dā ita ntíꞌxin ña uun itsi mí īo ntúte ne, kakaꞌan ñá ñuú Etiopía san: —Iꞌa īo ntúte. ¿Vá ña kuvi ntu te kutsi ntuté u vevii? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Nté kui ñaꞌa, te kanɨɨ̄ nima ntó kakuintiꞌxe nto —kaꞌan Félipe. Ne, kakaꞌan ñá ñuú Etiopía san: —Kakuintiꞌxé ko tsí Jesucristú ne, Iꞌxá Xuva ko ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kidáā ne, kakaꞌan ña é nākuntitsi daꞌna idú san. Nūu ña, ntuvi ñá Felipe, kuéꞌen ña nú ntute san ne, ikan tsī nakutsi ntúte Felipé san ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Dā ntíi ña diñɨ ntute kān ne, xio kueꞌen níꞌi Espíritū Sántū san Felipe. Nte kidáā ña ni iní ka ña ñuú Etiopía san ña; ne, dōó diní ña, nakunuu itsi xtuku ña. ");
INSERT INTO mizNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipé ne, é ñūú Azoto túvi ña dá kutuni ñá ne, īka ña taꞌán ñuu taꞌán ñuu, kakaꞌan ntódo ña túꞌūn vaꞌá iña Jésuu un tsi da nté xee ña ñuú Cesarea. ");
INSERT INTO mizNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Da nɨɨ kākudiin dukuan Saúlū ne, kainchuꞌvi ñá ña kuíntiꞌxe i Tóꞌo ko Jēsuu, ncho kaꞌní ña ña. Dukuān ne, kuéꞌen ña, kūkoto ñá tóꞌō dutu. ");
INSERT INTO mizNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Íkan ña tūtú é kuēꞌé ña un ntɨꞌɨ dūtu úkun ñūú Damascu é nīꞌi ña itsi é tɨ̄ɨn ña ña é kuíntiꞌxe i Jesuu, te tíi te ñadɨ̄ꞌɨ, é kɨ̄ꞌɨn niꞌi ña ña viꞌi utun ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ntá tsi da xee étsin ña diñɨ ñuú Damascú ne, koó dā kúduꞌva ña dá xiꞌí nuu ñuꞌu é vēꞌxi e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nantúve Saúlu ñuꞌu kān ne, kidáā téku ña uun tatsin é kākaꞌan ni ña: —Saúlū, ¿nté kui kanantōꞌon ntun ko? —kaꞌan tátsín san. ");
INSERT INTO mizNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kidáa ne, tsixeꞌē Saúlū: —¿Xoó ntu ñaꞌa nto? —kaꞌan ña. Ne, kakaꞌan tátsín san: —Xuꞌu é Jesuu. Dɨvī ú e dóo kanantōꞌon ko. ¿Nté kui kantukun kuīꞌin míin ntun kúñu ō? —kaꞌan ñá nī Saúlū san. ");
INSERT INTO mizNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saúlū ne, koó da kānɨ́ꞌɨ kanteɨ ña, kakaꞌan ña: —Tōꞌo, ¿neé ntu ntio nto é vīí u? —kaꞌan ña. Ne, kakaꞌan Jésuu ni ña: —Nakuntítsin, kuēꞌén ñuú Damascú ne, ikan kāꞌan ñá nee iña é vīin —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ñatīi, ña ntaíka dadɨɨ nī Saúlū né, dōo úꞌvī ña, tsí téku ña tatsín san, ntá tsi nté uun xoxo ni iní ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kidáā ne, nákuntītsí Saúlū é tūví ña ñuꞌu kān. Ntá tsi dā nákaán ña ntuxnúu ña ne, ñá ni xīꞌí kueꞌen tsi. Kañūꞌu ña ntaꞌa ña, kueꞌen níꞌi ña ña ñuú Damascu. ");
INSERT INTO mizNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ikān katúvi ña uni ntúvi ne, ñá ni xīꞌí nuu ña; ntē ña ni eꞌxí ña ne, nté ntūte ña ni xiꞌi ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ñuú Damascú san tuví uun ñaꞌa ña kuíntiꞌxe i Jesuu, ñá nani Anānia. Kakaꞌan Tóꞌo ko ni ñā, vata tsi tē ntitsí ña nuu ña, kakaꞌan ñá ni ñā: —¡Ō né, Anania! —kaꞌan ña. —Iꞌa tuví u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kidáā ne, kakaꞌan Tóꞌo ko ni ñā: —Nakuntítsin ne, kuēꞌén itsi é nani Ītsi Ntaa. Ne, ikan kuēꞌén, tsixeꞌēn nú viꞌi Júda te tuví uun ñatīi, ñá nanī Saúlū, ñá vēꞌxi ñuú Tarsu. Tsí vevií ne, ikān tuví ña, kakaꞌan ntâꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ne, é xéꞌe ú é kinī ñá tsí uun ñatīi, ñá nani Anānia, ntitsí ña nuu ña, kúkɨ̄ꞌví ña iní viꞌi ña kān né, xntekū ñá ntaꞌa ña dɨkɨ ñá vata koo é nāxiꞌí ntuxnúu ña —kaꞌan Tóꞌo ko ni Anāniá san. ");
INSERT INTO mizNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiá ne, ntíko koō ñá, kakaꞌan ña: —Ini ntó, Tóꞌō, tsí é dóo ntákaꞌan ñaꞌa iña ñá sāꞌa. Ntákaꞌan ñá tsi dóo kini idé ña ni ña kuíntiꞌxe i nto, ña ntoo ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Vevií ne, xee ña iꞌa, niꞌi ña tutú é xeꞌe tóꞌō dutú san é tɨ̄ɨn ña un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña é ntákaku niꞌi dɨvī nto —kaꞌan Ánania. ");
INSERT INTO mizNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ntá tsi kakaꞌan Tóꞌo ko ni ñā: —Ña té īni. Kueꞌēn kán, tsi é nakaxnúu ú ñatīí saꞌa é kāꞌan ña kuenta iñá ko ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña túku ñuú, ni ña odo nūu íña ñá ne, nī ña Israeé san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nañēꞌé u ña é ña te nté kaa īó é ntōꞌo ña kuenta iñá ko —kaꞌan Tóꞌo ko ni Anāniá san. ");
INSERT INTO mizNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kidáā ne, kuéꞌen Anānia nú viꞌī mí tuví Saúlū. Kúkɨ̄ꞌví ña ne, xntekū ñá ntaꞌa ña dɨkɨ ña, kakáꞌan ña: —Ení ko, Saúlū, ña ini nto tsí Tóꞌo ko Jēsuú ne, dɨvi ñā é ntii dítō ña míꞌi ītsi véꞌxi nto ne, dɨvi ñā táxnūu ña ko é vēꞌxi ú vata koo é na nāxiꞌí xtuku ntuxnūú nto ne, vata koo é kunūu Espíritū Sántū san nima nto —kaꞌan Ánaniá san. ");
INSERT INTO mizNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ura dúꞌva tsi i ntíi ntee vata kaa diden é nuu ntiꞌu ntuxnúu ña ne, nākiní xtuku ña. Kidáā ne, nákuntītsí Saúlū ne, ura tsí i ítsi ntute ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kidáā né, ēꞌxí ña ita ne, nakunúu ntii ñā. Kūkuií ña katúvi ña ni ñā kuíntiꞌxe i, ña ntoo ñuú Damascu. ");
INSERT INTO mizNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ura tsí i eni ntuꞌū Saúlu kākaꞌan ntódo ña ini ukún ña Israee, kákaꞌan ñá tsí Jesuú ne, dɨvi ñā é Iꞌxá Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ne, ntaíni ña Saúlū ne, koó dā kúduꞌva ña da téku ña é kākaꞌan ña. Ntákaꞌan ñáꞌa san: —¿Ñā ntu te ñá sāꞌa e dóo inchuꞌvi ña ña kuíntiꞌxe Jesuu, ñá ntoo ñuú Jerusaleen? ¿Ñā ntu te iꞌa véꞌxi ña, vextɨɨn xtuku ña ñaꞌa é kūnteka ña ña ntaꞌa tóꞌō dutu? —kaꞌan ñáꞌa san, ntátsixeꞌe tāꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ntá tsi Saúlū ne, dií ka xio ntii ña kakaꞌan ntódo ña. Un tsi kúdana iní ña Israee, ñá ntoo ñuú Damascu, tsí Saúlū ne, kanañēꞌe ña ña tsí Jesuú ne, dɨvi ñā é Cristu ñá, dɨvi ñā é intétu o ni ñata kō é kixnakakū ñá kō. ");
INSERT INTO mizNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Dā kú tɨtɨ́n ntuvi ne, ña Israeé san natée taꞌan ña xuꞌu ña, ntukū nuu iní ña nté koo kaꞌní ña Saúlū san. ");
INSERT INTO mizNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ntá tsi kútuní Saúlū é kuān koo vií ña ni ñā. Ntē ntúvi, ntē níñu ntantétu ña ña xiꞌi kan mí kīi ña diñɨ ñuú san, é kaꞌnī ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ntá tsi ña kuíntiꞌxe i Jesuú san ne, xnūu ña Saúlu īni xika kaꞌnu niñú a ne, nanúu ña ña ntīká ntoꞌo é kāntiꞌu núu diñɨ ñuú san ne, dukuan ō nakáku ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Dā náxeé Saúlu ñūú Jerusaleén ne, ntio ña é kuntoo dadɨɨ ña nī ña kuíntiꞌxe i san; ntá tsi un ntɨɨ́ ntɨɨ̄ ña úꞌvī ñá ña, tsí ña ni kuintíꞌxe ña te nūu é ntaā i é kuíntiꞌxe Saúlu Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ntá tsi uun ñaꞌa, ñá nani Bernābeé ne, intéka ña ña ntaꞌa pustru, kántaa ña nī pustrú san nté ō íni Saúlū Tóꞌo ko Jēsuu ítsi kān ne, nté ō kakaꞌan Tóꞌo ko ni ñā ne, nté ō dé ña da itúvi ña ñuú Damascu, é ntē ña ni uꞌví kueꞌen ña kakaꞌan ntódo ña iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saúlū ne, kátūví ña ñuú Jerusaleen, ika dadɨɨ ña nī pustrú san da míꞌī ká mí ñēꞌe ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ñá te kauꞌvī ñá kakaꞌan ñá iña Tóꞌo ko Jēsuu, kánantiko koō ñá túꞌūn é ntákaꞌan ña Israee, ñá ntákaꞌan túꞌūn griegu; ntá tsi ña Israeé san ne, dōo ntuku nuu ini ña nté koo kaꞌní ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Dā kútuni ña kuíntiꞌxe i sán ne, ntēka ña Saúlu ñūú Cesareá ne, ikān táxnuu tuku ña ña ñūú Tarsu. ");
INSERT INTO mizNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Da kidáā ne, kántōo váꞌa un ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i da míꞌī ka mí ntoo ña: ō ñuú Judeá ne, ō ñuú Galilea, ō ñuú Samaria. Dōo váꞌa ō intóo ña ne, dōo ntánuu iní ña Tóꞌo ko Jēsuu. Nāxnuu kaꞌnu Espíritū Sántū nima ñá dɨ ne, dōo kútɨtɨ́n ña kídaā. ");
INSERT INTO mizNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Da nɨɨ̄ kaika Pedru taꞌán ñuu taꞌán ñuú, kaito níꞌni ña ña kuíntiꞌxe i ne, nakuíta ntíꞌxin ña, íto niꞌni ña ña kuíntiꞌxe i, ña ntoo ñuú Lidá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ikān nániꞌi ña uun ñatīi, ñá nani Ēnea. E una kuía ntēkú ña nú ītó ña é natɨ́ɨn ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedrú ne, kakaꞌan ñá ni ñā: —Nakuntítsin, Enea, tsí Jesucristú ne, é ntāváꞌa ña o. Naxntītsin íto o vē —kaꞌan ña. Eneá ne, ura dúꞌva tsi i nakuntítsi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Un ntɨɨ́ ntɨ̄ɨ́ ña ntoo ñuú Lida ni ñá ntoo ñuú Saruún ne, iní ña é nakuntítsi ña. Kidáā né, tsoo mii ñā é ntántīkɨn ña díꞌna ne, eni ntuꞌu ñā intíkɨn ña Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Xío uun ñadɨ̄ꞌɨ, ña kuíntiꞌxe i, ñá nani Tābita (é ncho kaꞌan Dórcā é tūꞌún griegu), ña tuví ñuú Jope. Ñadɨ̄ꞌɨ́ saꞌá ne, dōo váꞌā o dé ña, dōo xntíi ña ña kataan núu i. ");
INSERT INTO mizNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ntuvi tsikán ne, iñɨ ntúꞌū nchókuví ña ne, xíꞌi ñā. Dā kúvī ntántoo ña ña ne, xtuvī ñá ña má viꞌī nínu kān, tsí ūvi odo ntiꞌi táꞌan viꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tuvi étsin ñuú Jopé san ñuú Lida, mí tuví Pedru. Īní ña kuíntiꞌxe i san tsí ikān tuví ña ne, táxnūu ña uvi ñaꞌa ñátīi é kūkoto ña ña: —Kantɨ́ꞌɨ̄ sá nto kueꞌēn ntó ñuú Jope —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kidáā ne, kuéꞌēn Pedru ni ña. Dā xee ñá ne, kueꞌen níꞌi ña ña má viꞌī mí tūví ntāa ñá xiꞌí san. Un ntɨɨ́ ntɨ̄ɨ́ ñadɨ̄ꞌɨ kií ntoo ña, ntaéku nteé ña ña. Náñēꞌe ñá Pedru dáꞌma ni dūꞌnu e dé váꞌa Dórcā dá katúvi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kidáā né, kīi ñuꞌu Pedru ñá, un ntɨɨ́ ntɨɨ̄ ñá ne, inchɨ́tɨ ña, kakaꞌan ntâꞌví ña. Kidáā ne, kaito ña nuu ñá xiꞌí san, kakaꞌan ña: —¡Tābita! ¡Nakuntítsin! —kaꞌan ña. Ura dúꞌva tsi i nákaán ña nuu ña ne, dā íni ña Pedrú san ne, nákutuvī tɨxɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Irkāa Pedru ntáꞌa ña, naxntitsī ñá ña. Kidáā ne, kána ña ña kuíntiꞌxe i san ni ñadɨ̄ꞌɨ kií san, náñēꞌe ñá ña tsi e ntóto ña. ");
INSERT INTO mizNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntoo ñuú Jopé ne, téku ña é kuan ō kúvi ne, ñá te da dīi ña kuíntiꞌxe ña Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedrú ne, kūkuií ka ña katúvi ña ñuú tsikan nú viꞌi Sīmuun, ña é katsoo itsi ñɨɨ kɨtɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ñuú Cesareá ne, tūví uun ñatīi, ñá nani Cōrneliu, ñá de kúꞌve iña uun sientu sntadun é nani Itālianu. ");
INSERT INTO mizNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ña sāꞌá ne, dōo vaꞌá ñaꞌa ña ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña. Kuān te ñá te ña Israee ña, ntá tsi dōo kanúu ini ña Xuva kō né, dōo íni xntii ña nee é kātaan núu ña Israee, é nguentúvi ini kaꞌan ntâꞌvi ña ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Uun ntuvi dá kaeku uni kuáa ne, koó dā kúduꞌva Corneliu dá xēe núu ña uun ánje Xuva kō. Kakaꞌan ánjē sán ni ñā: —¡Córneliu! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Corneliú ne, dōo uꞌví ña da íto ña nuu ánjē sán ne, katsixeꞌe ña ñā: —¿Neé ntu ntio nto, Tóꞌō? —kaꞌan ña. Kidáā ne, kakaꞌan ánjē san: —É tēkú Xuva kō é kākaꞌan ntâꞌvín ni ñā ne, ini ña tsí kaxntiin ña kataan núu i. ");
INSERT INTO mizNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Viꞌa ve ne, taxnūun ñaꞌa ñuú Jope é kikana ña uun ñaꞌa, ñá nani Sīmuun Pedru. ");
INSERT INTO mizNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tuví ña nú viꞌi tuku Simuun, ña katsoo itsi ñɨɨ kɨtɨ. Diñɨ́ ntute ñuꞌu kān tuví viꞌi ña. Sīmuun Pedrú san ne, kaꞌan ñá ni ō nté koo viin —kaꞌan ánjē sán ni Cōrneliu. ");
INSERT INTO mizNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Dā ntáka ánjē san da kúvi kaꞌan ñá ni ñā ne, kidáā kána ña uvi ñaꞌa ña kade tsiñu iña ñá, ni sntādun, ña e dóo kaxntii ña, ña e dóo kanuu iní i Xuva kō, ");
INSERT INTO mizNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","kantaa ntɨ́ꞌɨ ña ni ña vata ō kaꞌan ánjē san ni ña, dā táxnūu ña ña é kɨ̄ꞌɨn ñá ñuú Jope. ");
INSERT INTO mizNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tévāá san ne, dā xee étsin ña ñuú Jópe ne, dɨvi tsi ūra kuxée Pedru rkɨ́ viꞌi kān é kūkaꞌan ntâꞌví ña, tsí é kāꞌñú ntuvi. ");
INSERT INTO mizNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dōó kakakɨn ña, ntá tsi da nɨɨ kākuváꞌa é kāꞌxi ñá ne, vata kuvi é nakueni o, ");
INSERT INTO mizNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","iñɨ ntúꞌū íni ña é nákaan e dukún kān ne, véꞌxi vāta kaa uun doo mánta kaꞌnu é kantīkɨn kútū ngɨmi ntíkō diñɨ i ne, un tsi nte mi túvi ña nakutúvi. ");
INSERT INTO mizNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ini doo mánta sán ñuꞌu un ntɨꞌɨ kɨtɨ, kɨtɨ īó kɨmi dɨ́ꞌɨn i, ni kɨ̄tɨ ntáñuꞌu xído i, ni un ntɨꞌɨ nūu láa san, kɨtɨ ntaíko e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kidáā né, tēkú ña uun tátsín i é kākaꞌan ni ña: —O ne, Pedru, kaꞌnín kɨtɨ sāꞌa, dá kāꞌxín tɨ —kaꞌan tátsín san. ");
INSERT INTO mizNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ntá tsi nantiko kóo Pedru, kakaꞌan ña: —¡Ñáꞌā, Tóꞌō! tsí nté uun ito vata kaꞌxí u kɨtɨ kuān ntáa san, kɨtɨ é kaꞌan nto é ña váꞌa é kaꞌxi o. Tsí dóo xii kaa é kuān koo kaꞌxí u é ña Israeé u —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ntá tsi kakaꞌan xtúku tatsín san ni ñā: —Nuu i é ntantoo Xúva kō ne, ñá ku kāꞌan té ña váꞌa —kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Úni īto kuan o kúvi. Kidáā ne, kúntāa doo mántá san e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedrú ne, koó dā kúdana iní ña nee iñá kani túꞌun é xēe núu ña ne, dɨvi tsi ūra í xee ñátīí san, ña e táxnūu Corneliu, ntáñɨ̄ ntée ña ña, ntátsixeꞌe ña vīꞌi Simuun. ");
INSERT INTO mizNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tsixeꞌe ña xiꞌi kan te ikān tuví ña nani Sīmuun Pedru. ");
INSERT INTO mizNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedrú ne, nteku dukuan ñá rkɨ viꞌi kan, kadē kuení ña nuu i é xēe núu ña. Kidáā ne, kakaꞌan Espíritū Sántū sán ni ñā: —Pedrú, kuēꞌén, kūkoton, tsí uni ñaꞌa ntánantuku ña ō. ");
INSERT INTO mizNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kuēꞌén ni ñā míꞌi kɨꞌɨn niꞌi ña o. Kuān te ñá te ña Israee ña, ñá ku dē kueni o, tsí xuꞌú kakaꞌán u é kīxkueka ña o —kaꞌan Espíritū Sántū san. ");
INSERT INTO mizNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nūu Pedru mí ntâñɨ ñátīí san, ña táxnūu Corneliu. Kidáā ne, kakaꞌán Pedru: —Xuꞌu é ntánantuku ntō ko. ¿Neē ntú tsiñu véꞌxi nto? —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nantíko koō ñá, kakaꞌan ña: —Ña nani Cōrneliu, tóꞌō sntadun, táxnūu ña ntɨ. Dōo vaꞌá ñaꞌa ña, dōo kanuu iní ña Xuva kō ne, dōo váꞌa tiin ñá ni ūn ntɨɨ́ ntɨ̄ɨ́ ña Israee. É kākaꞌan ánje Xuva ko ni ñā é kāna ña nto é kɨ̄ꞌɨn nto nú viꞌi ña kān vata koo é kinī ña nee iña é kāꞌan ntó ni ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kidáā ne, kakaꞌán Pedru ni ña: —Kuítā ntiꞌxin nto má viꞌi a, kuntōo daꞌna nto —kaꞌan ña. Tévāá san ne, kuéꞌēn Pedru ni ñá ne, kaxio ña kuíntiꞌxe i, ña ntoo ñuú Jope, é kuēꞌen ñá ni ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Uun ká tuku ntuvi ne, xée ña ñūú Cesarea. Ikan kāntétu Corneliu ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña nī ña váꞌa tiin niꞌi ñā, ña e kána ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Dā xeé Pedru nú viꞌi ña kān ne, véꞌxi Cōrneliu, nákunchɨtɨ ña nūu ña é kunuu ini ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ntá tsi Pedrú ne, naxntitsī ñá ña, kakaꞌan ña: —Nakuntítsi nto, tsí ñatīí niꞌi tsi ko ntō —kaꞌan ñá ni Cōrneliu. ");
INSERT INTO mizNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ntatíin ña, kūntɨ́ꞌvi ña iní viꞌi kān né, īní Pedru e dóo ntoo ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ne, kakaꞌan ñá ni ñāꞌa san: —Ini nto tsi dóo xii kaa é kuntōo dadɨɨ ñá Israee ni ña tuku ñuu; ntá tsi dā vé nañēꞌe Xúva kō ko tsí ña kúvi kāꞌán u te ña váꞌa da xōó ka ñaꞌa, kuān té ña te ña Israee ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Dukuān ne, ñá ni de dīkó u é kīꞌxi ú da kána nto ko. Káꞌan nto vē: ¿neé ntu tsiñu kána nto ko? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kidáā ne, kakaꞌan Córneliu: —Dā kú kɨmi ntuví ne, ura sáꞌa tuví u, kakaꞌan ntâꞌví u má viꞌī kó a ne, dā nêní ko ntitsi uun ñatīí nuú ko, ña e dóo kaxiꞌí nuu doo í ne, ");
INSERT INTO mizNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","kakaꞌan ñá nī ko: “Córneliu, é tēkú Xuva kō é kākaꞌan ntâꞌvín ni ñā ne, ini ña tsí kaxntiin ña kataan núu i. ");
INSERT INTO mizNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Viꞌa ve ne, taxnūun ñaꞌa ñuú Jope é kíkaná ña ña nani Sīmuun Pedru. Tuví ña nú viꞌī tuku Simuun, ñá katsoo itsi ñɨɨ kɨtɨ, ña tuví diñɨ ntute ñuꞌu kān. Te kīꞌxi ña ne, īo é káꞌān ñá ni ō”, kaꞌan ñá nī ko. ");
INSERT INTO mizNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Dukuān ne, ura dúꞌva tsi i táxnūu ú túꞌūn é kiꞌxī ntó ne, dōo váꞌā o dé nto é vēꞌxí nto. Vevií ne, iꞌa ntoo ntɨꞌɨ ntɨ́ nuú Xuva kō é kīni ntɨ́ un ntɨꞌɨ̄ e ntío Xuva kō é kāꞌan ntó nī ntɨ —kaꞌan Córneliu. ");
INSERT INTO mizNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kidáā né, eni ntuꞌū Pedru, kakáꞌan ñá ni ñā: —Vevií ne, kutuní ko tsí nuu é ntaā i é dadɨɨ tsi ntío Xuva ko kō, un ntɨɨ́ ntɨɨ̄ ó, kuān te ñá Israee o, kuān te xio ñuú kō, ");
INSERT INTO mizNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","tsí nakiꞌi ña da xóo ka ñaꞌa e kuíntiꞌxe i ña, e kade é vāꞌá, da míꞌī ká ñuu ñuxiví a. ");
INSERT INTO mizNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tsí Xuva kō ne, káꞌan ña nī ña Israee nté koo kuntoo váꞌa o ni ña kuēnta iña i é edé Jesucristu, dɨvi ñā é Tóꞌo ko, ūn ntɨɨ́ ntɨɨ̄ o. ");
INSERT INTO mizNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","É īni nto nte o kúvi dá kanɨɨ ñūú Judea ni ñuú Galilea. Tsí diꞌna Juaan Bautista íka ña, kakaꞌan ntódo ña é nātɨvi iní ko kuētsí kō ne, kutsi ntute ō. ");
INSERT INTO mizNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kidáā ne, xée Jesuu, ña véꞌxi ñuú Nazaree. Tsí Xuva kō ntío ña é kūvi vií ña nee ntɨ́ꞌɨ ntɨꞌɨ, tsi dóo nuu Espíritū Sántū nima ña. Kidáā né, īka ña, kade ña nuu i é vāꞌá, kantaváꞌa ña ñaꞌa é ñuꞌu ntaꞌa tóꞌō é ña váꞌā san. Tsí mii Xuva kō nuu méꞌñu ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Dɨvī ntɨ́ ne, kuvi ntada ntaá ntɨ tsí īní ntɨ un ntɨꞌɨ̄ é edé ña da íka ña ñuú Judea ni ñuú Jerusaleen. Ñaꞌa éꞌni ña ña, é naxnteē ñá ña ntíkā krusi kan. ");
INSERT INTO mizNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ntá tsi da kúvi uni ntúvi ne, nantóto Xuva ko ñā ne, táꞌxi ña é kīní ntɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ñá te un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ni īni ña ña da ntoto ña, ntá tsi miī ntɨ́ ini ntɨ́ ña. Tsí nte díꞌna nákaxnuu Xuva kō ntɨ́ é ntāda ntaá ntɨ nee é īni ntɨ. Tsí ntɨꞌɨ́ ne, dadɨɨ intóo ntɨ́ ni ñā ne, dadɨɨ éꞌxi ntɨ́ ni ña da ntóto ña é xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kidáā né, Xuva kō tée tsiñu ña ntɨ é ntāda ntaá ntɨ tsí dɨvi Jēsuú, ña e dé kûꞌvé Xuva kō é xntēkú kuꞌvē ñá un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntántito ne, ō ña xiꞌi. ");
INSERT INTO mizNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tsí nte ntúvi diꞌna ntákaꞌan ñá kaꞌán naa Xuva ko tsí da xōó ka ñaꞌa, ña é kuīntiꞌxe i Jesuú ne, kada kaꞌnu iní Xuva ko ni ña kuētsí ña kuenta iña Jésuu —kaꞌán Pedru ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kakaꞌan dúkuān Pedru ni ña da xee Espíritū Sántū, inúu ña nima ña ntaíni túꞌūn san, un ntɨɨ́ ntɨɨ̄ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ña kuíntiꞌxe i, ña Israee, ñá véꞌxi dadɨɨ ni Pēdrú ne, koó dā kúduꞌva ña é kuān ó inúu Espíritū Sántū nima ñáꞌa san, kuān te ñá te ña Israee ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tsi téku ña é ntákaꞌan ña túꞌūn e ñá ini ñá ne, ntákaꞌan ña e dóo kaꞌnu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Kidáā ne, kakaꞌán Pedru: —¿Nté kui ña kuvi kutsi ntúte ña sāꞌa? Tsí é ntūdadɨɨ ña ni ko é dadɨɨ nuu Espíritū Sántū nima ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kidáā ne, xéꞌe ña ītsi é kūtsi ntute ñaꞌa san kuenta iña Jesúcristu. Dā kúvi itsi ntute ña ne, ntákaꞌan ñá ni Pēdrú te kūkuií ka ñá kutuvī ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Xée tūꞌun ntaꞌa pustrú san nī ña kuíntiꞌxe i, ña ntoo ñuú Jerusaleen, tsí e kuíntiꞌxe ña é ña te ña Israee túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ntá tsi dā ntíko kōo Pedru ñuú Jerusaleén ne, dōo ntákaꞌan ña kuíntiꞌxe i, ña Israeé san, ntátsiꞌi kuétsi ña ña, ");
INSERT INTO mizNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ntákaꞌan ña: —¿Nté kui kɨ́ꞌvi ntu ntō má viꞌi ña é ña te ña Israee? ¿Nté kui éꞌxi dadɨɨ ntu nto ni ñā? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kidáā ne, eni ntuꞌū Pedru kantáa ña ni ña un ntɨꞌɨ̄ e kúvi nte dá iñɨ ntuꞌū, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Xuꞌú ne, dā itúvi ú ñuú Jope, kakaꞌan ntâꞌví u ni Xuva kō ne, xée nūú ko uun doo mánta káꞌnu é kantīkɨn kútu ngɨmi ntíkō diñɨ i. Nte e dukún kān véꞌxi ne, un tsi nte mi túvi ú nakutúvi. ");
INSERT INTO mizNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Dā íto váꞌa ú doo mántá san ne, īní u odo da nēé ka nuu kɨtɨ é īó kɨmi dɨ́ꞌɨn i, kɨtɨ diin, ni kɨ̄tɨ ntáñuꞌu xído i, nī láa, kɨ̄tɨ ntaíko e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kidáā téku ko uun tatsin é kākaꞌan ní ko: “Nakuntítsin, Pedru, kaꞌnín kɨtɨ san, dá kaꞌxīn tɨ”, kaꞌan tátsín san. ");
INSERT INTO mizNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ntá tsi xuꞌú ne, kakaꞌán u: “¡Ñáꞌā, Tóꞌō! tsí nté uun ito vata kuan koo vií u ni kɨ̄tɨ é kāꞌan nto é ña váꞌa é kāꞌxi o”, kaꞌán u. ");
INSERT INTO mizNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kidáā ne, kakaꞌan xtúku tátsín san nte e dukún kān, kakaꞌan: “É ntantoo Xuva kō ne, ñá ku kāꞌan té ña váꞌa”, kaꞌan tátsín san. ");
INSERT INTO mizNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Úni ito kuan ō kúvi ne, dá kūntáa e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ura dúꞌva tsi i xee úni ñaꞌa ñatīí nú viꞌī mí tuví u. Nté ñūú Cesarea véꞌxi ña, vexnántuku ñā ko. ");
INSERT INTO mizNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kidáā ne, kakaꞌan Espíritū Sántū san ní ko é ña ku dé kuení ko é kɨ̄ꞌɨ́n u ni ñatīí san mí kɨꞌɨn niꞌi ñá ko, kuān té ña te ña Israee ña. Dadɨɨ ñeꞌé u, ni ntɨꞌɨ īñu ení ko ña sāꞌa, kɨ́ꞌvī ntɨꞌɨ ntɨ́ iní viꞌi ñatīi, ñá nani Cōrneliu. ");
INSERT INTO mizNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Corneliú san ne, kántaa ña nī ntɨ́ nté ō íni ña uun ánje Xuva kō, ntitsí ña má viꞌi ña kān ne, kakaꞌan ánjē sán ni ñā: “Taxnūún ñaꞌa ñuú Jope, na kīkoto ñá uun ñaꞌa, ñá nani Sīmuun Pedru, ");
INSERT INTO mizNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","tsí dɨvi ña kāꞌan ñá ni ō nté koo nakākú Xuva ko o ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi o”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kidáā né, dā éni ntuꞌū ú kakaꞌán u ni ñāꞌa sán ne, ura tsí i xée Espíritū Sántū san, inúu ñá nima ún ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, vata tsī ó inúu ñá nima ko xoꞌo dá iñɨ ntuꞌū. ");
INSERT INTO mizNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kidáā né, nakaꞌān kó túꞌūn é kākaꞌan Tóꞌo ko Jēsuu kídaā dá kakāꞌan ña: “Nuu é ntaā i tsí Juaán ne, ntute nakutsi ntúte ña nto. Ntá tsi xuꞌú ne, ña te ntúte nakūtsi ntute ú nto, tsí taꞌxi u é kunūu Espíritū Sántū nima nto”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Vevií ne, te Xuva ko kāxéꞌe ña tuku ñaꞌa vata tsi ō táꞌxi ña ko xoꞌō dá kuíntiꞌxe kō Tóꞌo ko Jesūcristú ne, ña kúvi kāꞌnté nuu ú neé ncho vii ña —kaꞌán Pedru ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Dā téku ñaꞌa san é kākaꞌán Pedru ni ñá ne, ñá ni kāꞌán ka ña. Da mii tsī é dé kaꞌnu ña Xuva kō ne, ntákaꞌan ña: —Nuu é ntāa ntíꞌxe i tsí kaxéꞌe Xuva kō é vāꞌá iña ña é ña te ña Israeé dɨ. Tsí kaxéꞌe ña é kūvi natɨvi iní ña kuétsi ñā dɨ́ ne, dukuān é nīꞌi ña ntuví vaꞌá iña ña ntaꞌa Xúva ko vata ō niꞌi ko xoꞌo —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ña kuíntiꞌxe i san kuéꞌen ña, kukuntóo ña un tsi nte ñuú Fenicia ni ñūú Chipre, ni ñuú Antioquiá dɨ dā dóo nantoꞌo ñaꞌa san ña dá xiꞌi Ésteba. Ikān ntákaꞌan ntódo ña túꞌūn é vāꞌá san. Ntá tsi da mii tsī é ntákaꞌan ñá nī ña Israeé san; ñá ni kāꞌan ñá ni ñāꞌa, ña é ña te ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ntá tsi xío ña kuíntiꞌxe i, ña véꞌxi ñuú Cirene ni ñūú Chipré ne, dā xee ñá ñuú Antioquiá ne, eni ntuꞌu ñā ntákaꞌan ñá ni ñāꞌa, ña é ña te ña Israee túꞌūn vaꞌá iña Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Xuva kō xntíi ña ña ne, dukuān né, tɨtɨ́n ñaꞌa, ña é ña te ña Israeé san tsóo mii ña nēe é kuíntiꞌxe diꞌna ña ne, eni ntuꞌu ñā kuíntiꞌxe ña Tóꞌo kō. ");
INSERT INTO mizNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Dā téku ña kuíntiꞌxe i, ña ntoo ñuú Jerusaleen, é kuíntiꞌxe ña é ña te ña Israeé ne, kidáā táxnūu ña Bernabee, kuéꞌen ña ñuú Antioquia. ");
INSERT INTO mizNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Dā xeé ña ikān né, īní ña tsí dóo váꞌā o dé Xuva ko ni ñāꞌa sán ne, nakunuu dîní nima ña. Kidáā ne, xéꞌe ña itsi un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san, ntákaꞌan ña: —Uun tsi nima ntó kuintiꞌxe nto Tóꞌo ko Jēsuu. Ñá ku xtuvī mii nto ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tsí Bernabeé san ne, dōo vaꞌá ñaꞌa ña. Dōó nuu Espíritū Sántū nima ñá ne, dōo kuíntiꞌxe ña Xuva kō. Kidáā né, dōó kukueꞌe ñaꞌa, ña kuíntiꞌxe i Tóꞌo kō. ");
INSERT INTO mizNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kidáā ne, kuéꞌen Bernābee ñuú Tarsu, kúnantúku ñā Saúlū. ");
INSERT INTO mizNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ikān nániꞌi ña ña ne, ñeꞌe níꞌi ña ña ñuú Antioquia. Ikān kantóo ña nī ña kuíntiꞌxe i san uun kuia nɨɨ. Dōo tɨtɨ́n ñaꞌa nakuāꞌa ña. Dɨvi ñūú Antioquiá san éni ntuꞌu ñā xntánteē ñá cristianu ña kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ntuvi tsikán ne, xío ña ntákaꞌán naa Xuva ko ñuú Jerusaleen. Xée ña sāꞌa ñuú Antioquia. ");
INSERT INTO mizNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ne, uun ñaꞌa ña, ñá nani Āgabú ne, nákuntītsí ña méꞌñū ña kuíntiꞌxe i san, kakaꞌan ntódo ña túꞌūn é xeꞌé Espíritū Sántū é kūtuni ña, kakaꞌan ñá e dóo koo tama dá kanɨɨ ñūxivi. Ne, kuan ō kúvi ntíꞌxe ntuvi dá de kúꞌve ñá nanī Claudiu. ");
INSERT INTO mizNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kidáā ne, ña kuíntiꞌxe i, ña ntoo ñuú Antioquiá ne, xíō ntaa iní ña é xntii ña tāꞌan ña, ña ntoo ñuú Judea, váta tsi kaa kutíi nuu ña. ");
INSERT INTO mizNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Dukuān né, tēe tsiñu ña Bernabee ni Saúlū é kɨ̄ꞌɨn niꞌi ña doméni iña ña kuíntiꞌxe i ntaꞌa ñata, ña odo nūú ñuú Judea. ");
INSERT INTO mizNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ntuvi tsikán ne, eni ntuꞌū rei Heróde kanakutsuꞌun ñā ña kuíntiꞌxe i. ");
INSERT INTO mizNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tēe tsiñu ña sntadún san é kīkaꞌní ña Santiau, ení Juaan. Kāa é ntiko ntuví o diñɨ i éꞌnté tuꞌun ña dɨ̄kɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Dā íni Heróde é xkúntee ini ña Israeé san é kuān o dé ña ne, tɨ̄ɨn ña Pedrú dɨ. Sáꞌā kúvi da kúvi viko é nakaꞌan ñā nté ō nakáku Xuva ko ñā ñuú Egítō. ");
INSERT INTO mizNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Dā tɨ́ɨn ña Pedrú ne, xnuu kutu ña ñā viꞌi utun, tsóo ña kɨmi ítsī kɨmi kɨmi sntadun é viī ñá ña kuenta. Un tsi da nté kuīta ntíꞌxin viko, da kidáa natavā ñá ña é xntītsí meꞌñu ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ntá tsi da nɨɨ nuu kutū Pedrú ne, ntákaꞌan ntâꞌví ña kuíntiꞌxe i san íña ña nté ntūvi nte níñu. ");
INSERT INTO mizNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Uun niñu diꞌna dá xēe ntúvi e xtûví Heróde é natavā ñá Pedru é xntītsí meꞌñu ñá ña ne, kakidí Pedru méꞌñū sntadun, kanúꞌni ña uvi kádena. Ntáñɨ̄ ntée sntadun áta xiꞌi kán dɨ, e ntáde ña kuenta xíꞌi viꞌi útun san. ");
INSERT INTO mizNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kidáā ne, véꞌxī ánje Xuva kō ne, xiꞌí nuu iní viꞌi utun kān. Ánjē sán ne, tɨɨn ntaꞌa ñā Pedru vata koo é nantōto ña ña ne, dā náxntitsī ñá ña, kakaꞌan ña: —¡Kamán san, nakuntítsin! —kaꞌan ña. Kidáā ne, kadena é kānúꞌni ntaꞌa ña ne, kóꞌxō. ");
INSERT INTO mizNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kakaꞌan ánjē sán ni ñā: —Naxnūꞌnín doo íꞌxi o, nakuníꞌnin ntiꞌxen o —kaꞌan ña. Dā kúvi ña ne, kakaꞌan xtúku ña: —Nakunúun kutuun ó ne, kuntīkɨ́n ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kidáā né, ntīi ña, kuntíkɨn ña ánjē san. Ntá tsi ña ni kutúni ña tē nuu é ntaā i. Da ñuu éni kān, kuiní ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Dā ita ntíꞌxin ña uvi itsi mí ntoo sntadún san ne, xee ñá uun xiꞌi e kúvi káā é kantii itsi kaꞌnu kān ne, nākaan míī xiꞌí san. Kīi ña, kueꞌen ña nte mí ntíi tuku itsi. Da kidáā xtúvī mii ánjē san ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dā ntútuni Pedrú ne, kakaꞌan ña: —Nuu é ntāa ntíꞌxe i tsí Xuva kō ne, táxnūu ña ánje ñā é nakakū ñá ko, tsí Heróde ni ūn ntɨɨ́ ntɨ̄ɨ́ ña Israeé san ncho kaꞌní ña ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Dā kútuní Pedru tsí nuu é ntaā i é nakáku ña viꞌi utun kān ne, kuéꞌen ñā nú viꞌi Māria, dɨꞌɨ̄ Juaan, ñá nanī Marcú dɨ. Ikān né, dōó ntoo ñaꞌa, ntákaꞌan ntâꞌví ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nakeꞌxen ñā xiꞌí ne, véꞌxi ūun taꞌnú kuetsī, taꞌnú nanī Rode, é kūkotó tun xoo ñáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Dā téku tun é tātsín Pedrú ne, ñá ni nakāán tun xiꞌí san, tsí dóo dîní tun ne, kaxkainu ntaá tun, kueꞌén tun, kukotó tun ñaꞌa san, tsí ntitsí ntēé Pedru atá xiꞌi kan. ");
INSERT INTO mizNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ntá tsi ña ni kuíntiꞌxe ñaꞌa san. Tē da kakaꞌán tun, kuiní ña. Ntá tsi nɨɨ̄ kueꞌén ini tún kakaꞌán tun tsí nuu é ntaā i. Kidáā ne, kakaꞌan ñá é kūdii ntɨ́xɨ Pedru é īní tun. ");
INSERT INTO mizNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ntá tsi Pedrú ne, ntitsí ntēe dúkuan ña, kanakeꞌxen ñā xiꞌi kan. Dā nákaán ña xiꞌí san ne, īní ña tsí dɨvi ntīꞌxe ña. Koó dā kúduꞌva ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ntá tsi Pedrú ne, kanakuiko ñā ntaꞌa ña vata koo é ña ku neé kaꞌan ñaꞌa san. Kidáā ne, kántaa ña ni ñā nté ō dé Xuva ko ni ñā dá natavā ñá ña viꞌi utun kān, kakaꞌan ña: —Kueꞌēn ntó, kukoto nto Santiau ni ún ntɨɨ́ ntɨ̄ɨ́ ení kō vata koo é kūtuni ña —kaꞌan ña. Kidáa ne, ntāka Pedru, kuéꞌen ñā xio itsi. ");
INSERT INTO mizNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Dā tuví ne, un váꞌa tsi itsuꞌun sntadún san, tsí xoxó ka Pedrú san viꞌi utun kān. ");
INSERT INTO mizNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Reí Heróde sán ne, dōo nantúku ña ñā, ntá tsi ña ni naniꞌi kuéꞌen ñá ña. Kidáā né, dōo tsíxeꞌe ñā sntadun, ñá ntáde kuenta xíꞌí san, nte o kúvi ntií Pedru. Dā kúvi tsíxeꞌe ña ñā ne, kakaꞌan ña é na kūví ntɨɨ́ ntɨ̄ɨ́ sntadún san. Dɨvi tsi ntūvi kíi Heróde ñuú Judea, kuéꞌen ña kukutúvi ña ñuú Cesarea. ");
INSERT INTO mizNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heróde ne, dōo kúdiin ña nī ña ntoo ñuú Tíru ni ñūú Siduun. Ntá tsi xee ñáꞌa san, ntákaꞌan ñá nī ñá nanī Blastu, ñá kade tsiñu iña reí san. Ntákaꞌan ña tsí ntio ña é ntūváꞌa ña nī reí san, ntio ña é kuntōo váꞌa ña, tsí dɨvi tsi ñūú reí san e ntákii un ntɨɨ́ ntɨ̄ɨ́ e ntaéꞌxi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Heróde ne, xtuvī ñá uun ntuvi é kāꞌan ñá ni ñā. Dā xee ntúvī sán ne, nákunūu ña doo váꞌa ña, nákutūví ña nú tēu ñá ne, dā éni ntuꞌu ña kākaꞌan ñá ni ñāꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ñáꞌā sán ne, koó da vāntiñɨ ña, ntákaꞌan ña: —¡Ñá te da ñaꞌa ña kakaꞌan, tsí Xuva kō! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kidáā ne, ura dúꞌva tsi i xée ūun ánje Xuva ko, ntuku kuiꞌī ñá Heróde, tsí dóo kaꞌnu ncho vií ña ne, ñá te ni de kaꞌnu ña Xuva kō. Kidáā ne, tɨntaku tsi éꞌxi tɨ ña ne, xíꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ntá tsi kidáā ne, ñá te da dīi ñaꞌa téku ña túꞌun Xuva kō né, dōo kútɨtɨ́n ña kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabee ni Saúlū né, dā ntɨ́ꞌɨ tsiñu ña ñuú Jerusaleén ne, ntíko kōo xtúku ña ñuú Antioquia ní Juaan, ña é nanī Marcú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ña kuíntiꞌxe i, ña ntoo ñuú Antioquia ne, iō ñá ne, ntákaꞌan ñá naa Xuva ko; iō ñá ne, ntánakuāꞌa ña ñaꞌa túꞌun Xuva kō. Ña sāꞌá ne: Bernabee, ni Símuun, ñá nani Ña Nteē dɨ́; ni Lūciu, ña véꞌxi ñuú Cirene; ni Manāeen, ña éꞌnu dadɨɨ ni Hērode, ñá odo nūu ñuú Galilea; nī Saúlū dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Uun ntuvi sāꞌá ne, ntoo ña, ntákaꞌan ntâꞌví ña ni Xuva kō; ntoo ixu ñā dɨ. Kidáā né, kakaꞌan Espíritū Sántū san ni ña: —Nakaxnúu nto Bernabee ni Saúlū é viī ñá tsiñu é ntio ko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kidáā né, dā kúvi kaꞌan ntâꞌví ña, dā kúvi intóo ixu ñā né, xntekū ñá ntaꞌa ña dɨkɨ Bernábee ni Saúlū, da táxnūu ña ña é kɨ̄ꞌɨn ña, kikadá tsiñu ña iña Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kidáā ne, kuéꞌen ñā, ntuvi ña, e táxnūu Espíritū Sántū sán ña, xée ña ñūú Seleucia. Ikān ñúꞌu ña tun ntōó kaꞌnu é kɨ̄ꞌɨn ñá ñuú Chipre, ñuu é tuví méꞌñu ntute ñuꞌu kān. ");
INSERT INTO mizNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Dā xee ñá ñuú Salamina é tuví diñɨ ntute ñuꞌu kān né, ikān éni ntuꞌu ñā kaꞌan ntódo ña túꞌun Xuva kō ini ukún ña Israee. Ntɨɨ niꞌi ñā Juaan, é xntii na ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kuéꞌen ñā, ita ntíꞌxin ña kanɨɨ ñūú san dá ntē xee ñá ñuú Pafu. Ikān nániꞌi ñá uun ñaꞌa ña Israee, ñá nani Barjēsuu, ñá tatan. Kaeni ntaꞌví ña ñaꞌa é kākaꞌan ñá naa Xuva ko; ntá tsi ñá tē nuu é ntaā i é kākaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ña sāꞌá ne, dōo váꞌa tiin ña ni ña tsiñu i ña odo nūu, ñá nanī Sergiu Paulu, ña e dóo kiꞌin inī i. Kakana Sergiu Paulú san Bernabee ni Saúlū, tsí ntio ña kini ña túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ntá tsi ña tatan Barjesuu, ñá nani Ēlima dɨ́ ne, ēꞌnté nuu ña vata koo é ña kuintíꞌxe Sergiu Paulú san. ");
INSERT INTO mizNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kidáā ne, Saúlū, ñá nanī Pablú dɨ ne, dōo xntíi Espíritū Sántu ñā né, īto vaꞌa váꞌa ña Elima, ");
INSERT INTO mizNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kakaꞌan ña: —Xōꞌon e dóo kaenin ntaꞌvín ñaꞌa, e dóo kini ó den, xōꞌon é iꞌxá Tóꞌō é ña váꞌa, xōꞌon é ña ntío o é vāꞌá, ¿amá ntu teén daꞌnan é kanāxnteén xoꞌon itsi vāꞌá iña Xuva ko? ");
INSERT INTO mizNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Viꞌa ve ne, Xuva ko tāꞌxi ña o é ntōꞌo o, é kūkuaan ne, ñá īní o nēe ntúvi naxiꞌí nuu o —kaꞌán Pablu ni ña. Ura dúꞌva tsi i kúneé kueꞌen nuu ña. Kaika ña, kantuku ñā xoo é kuñuꞌu i ña, tsí ña kaíni kueꞌén ka ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Dā íni Sergiu Paulú san é kuan ō kúvi ña ne, kuīntiꞌxe ña Tóꞌo ko Jēsuu, tsí koó dā kúduꞌva ña é kuān nte váꞌa túꞌūn é kākaꞌán Pablu iña Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kidáā né, ntāka Pablu ni ún ntɨɨ́ ntɨ̄ɨ́ taꞌan ña ñuú Pafu, ñúꞌu ña tun ntōó kaꞌnu, xée ña ñuú Perge, é kaduku ntee ñuú Panfilia; ntá tsi Juaán ne, tsoo mii ña ña, kunúꞌu ña ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kidáā né, ntāka ña ñuú Perge, kueꞌen ña xio ñuu é nani Antiōquia, é kāduku ntee ñuú Pisidia. Ikān ne, ntuvi dá ntoo daꞌna ña ne, kúkɨ̄ꞌví ña ini ukún ña Israeé ne, ikān intóo ña uun daꞌna. ");
INSERT INTO mizNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kidáā ne, da kúvi nakuaꞌa ñaꞌá san tutú lei Muísee ní tutú e de váꞌa ña kaꞌán naa Xuva ko ne, ña odo nūu iña úkūn sán ne, kāna ña Pablu ni Bernábee, kakaꞌan ñá ni ñā: —Ēní, te iō kúdii é kāꞌan nto é kuēꞌe nto itsi ñaꞌa sán ne, káꞌan nto ni ñā vevii —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kidáā ne, nákuntītsí Pablu, káde ña ntaꞌa ña é diin diin tsi na kuntōo ñaꞌa sán ne, kakaꞌan ña: —Un ntɨꞌɨ kuēꞌen dúꞌva nto, ña Israee ni ña nguíī san, ña ntaíko ñuꞌu Xuva kō ne, kini nto é kāꞌán u ni ntō: ");
INSERT INTO mizNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Xuva kō, ña é nakaxnúu uva ata kō ña Israee, ña intóo kídaā né, de kaꞌnu ña ñata kō da intóo ña ñuú Egítō, é ña te ñuú mii ñā. Xío ntii Xuva kō nátavā ñá ñata ko ñūú tsikan. ");
INSERT INTO mizNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ne, kutíi Xuva kō nima ñá ni ñā da dóo duꞌxen dé ña da nɨɨ̄ íka ña má kūꞌu kan é uvi díko kuiá san. ");
INSERT INTO mizNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Uun ito tsi nantɨ́ꞌɨ Xuva kō é ūꞌxe ñuu naꞌnu é intóo ñuú Canaán ne, dā eꞌnté dava ña ñuꞌu san, xéꞌe ña un ntɨɨ́ ntɨ̄ɨ́ ñata kō. ");
INSERT INTO mizNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ʼRkontûví ne, de kúꞌvē ñá ña kada kúꞌve iña ñaꞌa san kɨmi sientu nte dáva kuia, uun tsi nte ntúvi da íka Samuee, ñá kaꞌán naa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kidáā ne, íkan ñata kō sán uun rei é kadā kúꞌvē ña. Xéꞌe Xuva ko Sāuu, iꞌxá Kii, ñatīí tatá Benjamiin, é viī ñá rei íña ña uvi díko kuia. ");
INSERT INTO mizNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Rkontûví da nantii Xuva ko Sāuú ne, naxnūu ña Davii é viī ñá rei iña ña. Kakaꞌan Xúva ko īña Dávii: “Iní u tsí Davii, iꞌxá Isaií ne, uun tsi nima ñá nī ko. Viī ñá da nēé ka nuu i é ntio ko”, kaꞌan Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Taxnuu Xuva ko ūun iꞌxá ika Dāvií, dɨvi Jēsuu, é nakakū ñá ko, xoꞌō é ña Israee ó, vata ō kaꞌan Xúva kō kídaā. ");
INSERT INTO mizNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Tsí diꞌna Juaan kíꞌxi ña, kixkaꞌan ntódo ña ni ūn ntɨɨ́ ntɨ̄ɨ́ ña Israeé san é na nātɨvi iní ña kuétsi ñā ne, na kūtsi ntute ña. Da kidáa kīꞌxi Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Diꞌna da kuví Juaán ne, kakaꞌan ña: “¿Xoó ntu ñaꞌa u, té kuinī nto? Ñá te xūꞌú é nakaxnúu Xuva kō é kadā kûꞌvé u iña nto, tsí dɨvi ñā né, dā ve véꞌxi ña. Xuꞌú ne, ntē ña nuu áꞌvi u é nantīi ú ntiꞌxen ña, tsí dɨvi ñā é kāꞌnu ñaꞌa ña”, kaꞌán Juaan. ");
INSERT INTO mizNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ʼĒní ko, iꞌxá tatá Abraan, ni ñá nguiī san, ña ntaíko ñuꞌu Xuva kō ne: íña nto túꞌūn e táxnūu ña nté koo nakáku ō. ");
INSERT INTO mizNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tsí ña ntoó ñuú Jerusaleen ni ñá odo nūú san ne, ñá ni kutūni ñá xoó ntiꞌxe é Jesuu dá kīꞌxi ña. Ntē ña ni ñéꞌe dɨkɨ ña túꞌūn é ūve naꞌa é ntákaꞌan ñá kaꞌán naa Xuva ko, ña intóo kídaā. Ntánakuāꞌa ña túꞌūn san ma ukún kān vata dá sábadu, ntá tsi ña ni ini ña é dɨvi tsi ña dé ntaā ñá vata ō uve naꞌa kakaꞌan, dá kaꞌan ña é kūví Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kuān té ña tuví nēe kuetsí ña, ntá tsi ikan ña ntaꞌa Pīlatu é na kuēꞌé ña itsi é kāꞌní ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ne, dā kúvi dé ntaa ntɨ́ꞌɨ ña un ntɨꞌɨ̄ é ūve naꞌa é kūvi Jesuú ne, nántii ntēé ña ña ntiká krusí ne, kueꞌen níꞌi ña ña nú ñaña ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ntá tsi Xuva kō nantóto ñá ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ne, dōó kiꞌin itō ká ntii díto ña. Íni ñaꞌa ña, dɨvi ñāꞌa é dadɨɨ ntáka ña ñuú Galilea é xee ñá ñuú Jerusaleen. Dɨvi ña sāꞌa ntáda ntaá ña ni ñāꞌa san nee e íni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ʼDɨvī ntɨ́ dɨ ne, ntántaa ntɨ́ ni ntō túꞌūn e dóo váꞌa é kākaꞌan Xúva ko ni ñata kō, ña intóo diꞌna. ");
INSERT INTO mizNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Vevií ne, é dē ntaa Xúva kō é kākaꞌan ñá ni ñata kō kídaā, tsí nantóto xtūku ñá Jesuu kuénta iña ko xoꞌo. Vata ō úve naꞌa ini sálmu é kuvi ūví ne: “Dɨvīn é iꞌxá miī ko. E táꞌxi ú ntuvi iña o vevii”, kaꞌan Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nté dīꞌna kakaꞌan Xúva kō tsí nantōto ña ña vata koo é ña teꞌu kúñu ña tē xiꞌi ña, tsí uve naꞌa kakáꞌan ña: “Nuu é ntaā i é tāꞌxi ú o é vāꞌá, vata tsi ō kaꞌán u ni Dāvii”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Dukuān ne, é tūku sálmu úve naꞌa, kakaꞌan: “Ñá kuēꞌé nto itsi é tēꞌu kúñu īꞌxá nto, ña e dóo vaꞌa”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tsí Davií ne, nuu é ntaā i e xntíi ña ña intóo dá ītúvi ña, vatā ó kākaꞌan Xúva kō é viī ña. Dā xiꞌi ñá ne, dadɨɨ kantúꞌxi ña ni ñata ñā ne, téꞌū kúñu ñā dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ntá tsi kúñu Jēsuu é nantóto Xuva kō ne, ñá ni tēꞌu. ");
INSERT INTO mizNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Sáꞌa kākaꞌán u ni ntō, tsí ntio ko é kūtuni nto, ení, tsí kuenta iña Jésuu é kūvi vií Xuva kō kada kaꞌnu iní ña ni ko kuētsí kō. ");
INSERT INTO mizNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ne, kuenta iña ñá dɨ ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña é kuíntiꞌxe i ña ne, nakate Xuva ko kuetsi ñā. Tsí ña ni kúvi vīí lei Muíseé san nakate kuétsi kō; ntá tsi dɨvi Jēsuú ne, kūvi idé ña é ntuntoo kuétsi kō. ");
INSERT INTO mizNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kuenta tsí vií nto vata koo é ña ntoꞌo nto vatā ó uve naꞌa ntákaꞌan ñá intóo diꞌna, ña kaꞌán naa Xuva ko, é kākaꞌan: ");
INSERT INTO mizNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Koto nto, un ntɨɨ́ ntɨɨ̄ ntó ve, vata ō nto é kanantii niꞌni ña nto ne, koó dā kúduꞌva nto vé te inī ntó nté koo vií u ne, kuan tsī koo kunaá nto. Tsí xuꞌú ne, vií u uun nuu i e dóo kaꞌnu é ña kuintíꞌxe kueꞌen nto, kuān te káꞌan ñáꞌa ni ntō tsí nuu é ntaā i. Kuan ō kaꞌan Xúva kō kídaā —kaꞌán Pablu. ");
INSERT INTO mizNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Dā ntíi Pablu ni ña ntɨɨ níꞌi ñā ukún ña Israeé san ne, ntákaꞌan ñáꞌa san ni ñā: —Vií nto da xeꞌe, kiꞌxí xtuku nto sábadu vité ve, kixntaa ntó nī ntɨ́ vatā ó kantaa ntó vevii —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ne, dā ntíi ña ma ukún kān ne, tɨtɨ́n ña Israee ni ña túku tatá, ña é dadɨɨ tsi kuíntiꞌxe i Xuva kō ne, kuntíkɨn ñā Pablu ni Bernábee. Dɨvi ñā ne, ntákaꞌan ñá ni ñāꞌa san te ña tee dáꞌna ña é kuntīkɨn ñá Xuva kō, tsí dɨvi ñā é xntíi ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","É kuvi ūvi sabadú san ne, da kanɨɨ ñūú san nátaká nuu ña é kinī ñá túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kidáā né, īní ña Israeé san e vánchuꞌun tɨ̄tɨ́n ñaꞌa ntoo ña ne, dōo kúneꞌu iní ña. Ēni ntuꞌu ña kaꞌan ntée ña Pablú ne, káꞌan kīni ña iña ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pablu ni Bernábeé ne, ñá ni ūꞌví kueꞌen ña é nantiko koō ñá ne, kakaꞌan ña: —Diꞌna nto é ña Israee nto é kāntio é kāꞌán ntɨ ni ntō túꞌun Xuva kō, ntá tsi ña ncho kini nto túꞌun ñā. Mii ntō ntádē kuení nto é ña te neé nuu áꞌvi nto é nīꞌi nto ntuví vaꞌá ntaꞌa Xúva kō. Dukuān ne, xio kɨꞌɨ́n ntɨ, kikaꞌan ntódo ntɨ túꞌun Xuva ko nī ña é ña te ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tsí kuān o dé kûꞌvé Xuva kō, kakaꞌan ñá ni kō: É xtūví u o é vīin vata kaa uun ñuꞌu íña ñá xio ñuu, ña é ña te ña Israee, vata koo é na nākáku ñaꞌa dá kanɨɨ ñūxivi, kaꞌan Xúva kō —kaꞌán Pablu. ");
INSERT INTO mizNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Dā téku ña ntoo san, ña é ña te ña Israeé ne, nákuꞌun díni kueꞌén nima ñá, ntákaꞌan ñá tsi dóo kaꞌnu túꞌun Xuva kō ne, un ntɨɨ́ ntɨɨ̄ ña é nakaxnúu Xuva kō é nīꞌi ña ntuví vaꞌá iña ñá ne, kuīntiꞌxe ntɨɨ́ ntɨɨ̄ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kidáā ne, kueꞌen níꞌi ñaꞌa san túꞌun Xuva kō. Kuéꞌen ñā, ntákaꞌan ñá ni ñāꞌa san da míꞌī ka mí ntaíka ña ñuú saꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ntá tsi ña Israeé san ne, ntákaꞌan ñá ni ñadɨ̄ꞌɨ, ña e dóo vaꞌá ñaꞌa, ña e dóo ntánuu iní i Xuva ko, ni ñata, ña odo nūú ñuú san. Tsiꞌí ña dɨkɨ ña é natēñu nuu ña Pablu ni Bernábee, é nantīi ña ña ñuú san. ");
INSERT INTO mizNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ntá tsi Pablu ni Bernábeé ne, nakɨdɨ ña xáka dɨꞌɨn ña vata koo é kūtuni ñáꞌa san é ña váꞌa o ni ide ña ni ñā ne, dá kueꞌēn ñá ñuú Iconiu. ");
INSERT INTO mizNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ntá tsi ña kuíntiꞌxe i sán ne, dōo dîní ña ntoo ña, tsi dóo nuu Espíritū Sántū nima ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Dā xeé Pablu ni Bernábee ñuú Iconiú ne, kúkɨ̄ꞌví ña ini ukún ña Israeé ne, eni ntuꞌu ña kākaꞌan ntódo ña ni ñāꞌa san. Dōo váꞌā ó kakaꞌan ña. Dukuān ne, vánchuꞌun tɨ̄tɨ́n ña Israee ni ñáꞌa é ña te ña Israeé dɨ, kuíntiꞌxe ña Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ntá tsi iō ñá Israee é ña ni kuintíꞌxe ña. Dɨvi ñā nateñu núu ña ña é ña te ña Israeé san ne, tsīꞌi ña dɨkɨ ña é kadā kuení kini ña iña ña kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kidáā né, naꞌā intóo Pablu ni Bernábee ñuú tsikan ne, ñá ni ūꞌví kueꞌen ña é kāꞌan ntódo ña, tsí ini ña tsí Xuva ko kaxntii ña ñā. Ntákaꞌan ña é kuān nte váꞌā o dé Xuva ko ni kō. Xuva kō né, ntāda ntaa ña é kākaꞌan ñá iña ña, tsí xeꞌé ña ntii ñā é kūvi vií ña nuu i e dóo naꞌnu, e dóo kueꞌe kuenta kuéꞌe ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ntá tsi ña ntoo ñuu tsikán ne, ñá te dadɨɨ tsī ó ntádē kuení ña; tsi íō ñá ne, ña Israee ntántīkɨn ñá ne, iō ñá ne, pustrú san ntántikɨ̄n ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kidáā ne, ña Israeé san ni ña nguiī sán ne, nātee táꞌan ña xuꞌu ña ni ña odo nūu iña ña, é ntukū nuu iní ña nté koo nantōꞌo ña pustrú san ne, nté koo kueꞌé xuu ña ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ntá tsi kútuni Pablu ni Bernábeé ne, īnu ña, kueꞌen ña ñuú Listra ni ñuú Derbe, ñuu é ntáduku ntée ñuú Licaunia. Kuéꞌen ñā ntíkō diñɨ ñuú san dɨ, ");
INSERT INTO mizNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ntaíka ña, ntákaꞌan ntódo ña túꞌūn vaꞌá iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ñuú Listrá ne, ítūví uun ñatīi, ña natɨ́ɨn dɨ́ꞌɨn ī. E dúkuan kāa ña nte da káku ña. Nté uun ito ña ni kuvi kaka ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ña sāꞌá ne, tekú ña é kākaꞌan Páblu. Pablú ne, īto váꞌa váꞌa ña ña ne, kūtuni ña tsí nɨɨ̄ kueꞌén ini ña intée ini ña é kūvi ntuváꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kidáā ne, un ntíi tsi kākaꞌán Pablu ni ña: —¡Nakuntítsin! —kaꞌan ña. Koó dā kaentíta ntaa ñatīí san nakuntítsi ña ne, eni ntuꞌu ña kaīka ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Dā íni ñaꞌa san é kúvi idé Pablu ntaváꞌa ña ña ne, koó da vañɨ ñā ntatíin ña: —¡É iꞌa xée úvi ñāꞌa é uva kō é vēꞌxí nte e dukún kān ne, vata ntáa ñatīi ntáa! —kaꞌan ñáꞌa san é tūꞌún Licaunia ntákaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ntákaꞌan ña é Bernābeé ne, dɨvi uva ñā, ñá nanī Zeú ne, ntákaꞌan ña é Pablú ne, dɨvi uva ñā, ñá nanī Herme, tsí dɨvi ñā é kākaꞌan ntódo ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kidáā ne, xée dutu úkun Zeu é tuví diñɨ ñuú kān. Xée ña, ntēka ña duntɨkɨ ni leꞌe é ntukutu lāa. Tsí ntio ñaꞌa san é kaꞌnī ñá duntɨkɨ́ san é kuēꞌé ña doméni iña pústrú san, tsí xuva ñā, kuíni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ntá tsi dā kútuni Bernábee ni Páblu é ncho vií ñaꞌa sán ne, nākatsin ña duꞌnu ñá vata xkoó ini ña da dóo uꞌvi kakúvi ña ne, koó dā ntaínu ña kueꞌen ña méꞌñū ñaꞌa san ne, un ntii tsī kaꞌan ñá ni ñā: ");
INSERT INTO mizNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¿Nté kui kuān ó ntáde ntu nto? Ntɨꞌɨ́ ne, ñatīí niꞌī ntɨ́ nto. É veꞌxi ntɨ é kāꞌan ntódo ntɨ́ ni ntō vata koo é xtuvī mii nto é dótō tsi ntaíntíkɨn nto é ña kaidiáꞌvi vata koo é kuntīkɨn ntó Xuva kō, ña kantíto. Dɨvi ñā de kúꞌvē ñá viꞌi antɨ̄ví ni ñūxiví, ni ntute ñuꞌu, ni un ntɨꞌɨ̄ é īó da míꞌī ka. ");
INSERT INTO mizNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ntuvi diꞌna ne, xéꞌe Xuva kō é kuntīkɨn ñáꞌa da nēé ka itsi e ntío ña; ñá ni ēꞌnté nuu ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ntá tsi ña ni tsoo mií kueꞌen ñá nto, tsi náñeꞌe ñá nto é Xuva ntiꞌxe ko ñā da é dóo váꞌā o dé ña ni ntō. Tsí kanakɨɨn ña davi nte e dukún kān ne, kataꞌxi ña é kūvi é tata, kataꞌxi ña é kōꞌo é kāꞌxi ntó, kanaxnuu dínī ñá nima nto. ");
INSERT INTO mizNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Sáꞌā kaꞌán pustrú san ni ñā. Ntá tsi dá kuētsi kúvi idé ña éꞌnte nuu ña é kāꞌní ñaꞌa san duntɨkɨ́ san kuenta iña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kidáā ne, xéē ña Israee, ña véꞌxi ñuú Antioquia ni ñuú Iconiu, tsíꞌi ña dɨkɨ ñaꞌá san é kuēꞌé xuu ña Pablu. Dā kúvi ne, kīi ñuꞌu ña ña diñɨ ñuú san, tsí e xíꞌi ña, kuīní ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ntá tsi ña kuíntiꞌxe i sán ne, nātaká nuu ña, ntáñɨ̄ ntée ña ña. Kidáā ne, nákuntītsí Pablu, kúkɨ̄ꞌví xtuku ña má ñūú Listra. Utén san ne, kuéꞌen ñā, ntuvi ñá Bernabee, ñuú Derbe. ");
INSERT INTO mizNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Dā kúvi kaꞌan ntódo ña túꞌūn vaꞌá san ñuú Derbé ne, kūvi idé ña e dóo tɨtɨ́n ñaꞌa kuíntiꞌxe ña Jesuu. Kidáā ne, ntíko koō ñá, ita ntíꞌxin xtuku ña ñuú Listra, ni ñuú Iconiu, ni ñuú Antioquia. ");
INSERT INTO mizNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ikān ne, nátsuꞌun kaꞌnu ña nima ñá kuíntiꞌxe i san, ntákaꞌan ñá ni ñā é ña ku tee dáꞌna ñā é kuintiꞌxe ña Xuva kō ne, xéꞌe ñā é kūtuni ña tsí kueꞌe īo é ntoꞌo ko ñūxiví a é xēe o mí kadē kûꞌvé Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kidáā ne, nakaxnúu ña ñatā, ña é kodo nūu é un é un xúkun ña kuíntiꞌxe i. Kaꞌan ntáꞌvī ñá, intóo ixu ña ne, dā ntáda ña ña kuenta ntáꞌa Tóꞌo kō, ña é intée ini ña. ");
INSERT INTO mizNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kidáā ne, ítā ntiꞌxin ña, ntuvi ña, dá kanɨɨ ñūú Pisidia, xee ña ñuú Panfilia. ");
INSERT INTO mizNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kuéꞌen ña, kūkaꞌan ntódo ña ñuú Pergé ne, dá kuēꞌen ña ñuú Ataliá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ikān ñuꞌú ña tun ntōó kaꞌnu, kuéꞌen ña, náxee ña ñuú Antioquia, mí eka ña da táxnūu ña kuíntiꞌxe i san ña é viī ñá tsiñu é xeꞌe Xúva ko ñā. Ne, é kūvi dé ntaa ntɨ́ꞌɨ ña tsiñu san. ");
INSERT INTO mizNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Dā ve tsi náxee ña ñuú Antioquiá ne, kāna ña un ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i san é na nātaká nuu ña ne, dá ntaa ña ni ña un ntɨꞌɨ̄ nté ō dé Xuva ko ni ñā, nté ō xeꞌé ña itsi é kuīntiꞌxe ñaꞌa, ña é ña te ña Israeé san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kidáā né, dōó naꞌa īntóo ña nī ña kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ntuvi tsikán ne, xío ñatīi, ña e éka ñuú Judea, xee ña ñuú Antioquiá ne, ikān éni ntuꞌu ñā ntánañēꞌe ña ña kuíntiꞌxe i san, ntákaꞌan ña: —Tē ntio nto nakáku nto ntaꞌa Xuva kō né, da miī é tēꞌnte un siin kúñū é ixi nto, vata ō xtúvi Muísee é vīi o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ntá tsi Pablu ni Bernábeé ne, ñá nī xkúntee iní kueꞌen tsí ña é ntákaꞌan ñá tsikan. Dukuān ne, ña kuíntiꞌxe i sán ne, nakaxnúu ña Pablu, ni Bernábeé, ni uvi uní ka ení ña, ña kuíntiꞌxe i dɨ, táxnūu ña ña é kɨ̄ꞌɨn ñá ñuú Jerusaleen, kíkoto ña pustrú san, ni ñata, ña odo nūú iña ña kuíntiꞌxe i san, tsíxeꞌe ña kuēnta iña i é kākaꞌan ñáꞌa san é viī ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kuéꞌēn ña kuíntiꞌxe i san, kuntéka itsi ña ña. Dā ita ntíꞌxin ña ñuú Fenicia ni ñuú Samariá ne, ikān ntáa ña ni ñā nté ō kuíntiꞌxe ña é ña te ña Israeé san, é tsoo mii ñā e kuíntiꞌxe diꞌna ña ne, eni ntuꞌu ñā ntántīkɨn ñá Xuva kō. Dā téku ña kuíntiꞌxe i sán ne, dōo dîní ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Dā xeé Pablu ni Bernábee ñuú Jerusaleén ne, kuéꞌen ñā mí ntoo ña kuíntiꞌxe i san, nī pustrú san, ni ñata, ña odo nūú iña ñá ne, dōo diní ña dá xee ña. Ikan tsī ntáa ña ni ña un ntɨꞌɨ̄ nté ō dé Xuva ko ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ntá tsi īó ña fariseu, ña kuíntiꞌxe i, ntákaꞌan ña tsí da miī é tēꞌnté kúñū é īxi ña é ña te ña Israeé san, é da miī é kāda ntaa ña lei Muíseé dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kidáā né, mii tsī pustrú san ni ñata, ña odo nūú iña ña kuíntiꞌxe i san, nátaká nuu ña, ntánatíin ña nté koo kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Dā ku e víꞌi ntánatíin ña ne, nákuntītsí Pedru, kakaꞌan ñá ni ñā: —Ení, é īni nto tsí Xuva kō ne, nté dīꞌna nakaxnúu ña ko é kāꞌán u ni ñāꞌa, ña é ña te ña Israeé san, túꞌūn vaꞌá iña Tóꞌo ko Jēsuu vata koo é kuīntiꞌxe ña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Xuva kō ini ñá nima ko nté ntaa ne, náñēꞌe ñá kō tsí intée ini ña é kīꞌi ña ñaꞌa, ña é ña te ña Israeé san, tsí xeꞌé ña é kunūu Espíritū Sántū nima ñá vata tsī o dé ña ni ko xoꞌō dá kuintiꞌxe ko ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Vevií ne, é ntudadɨɨ ña ni kō, tsí Xuva kō ntántoo ña nima ñá dɨ dā kuíntiꞌxe ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Viꞌa ve ne, ¿nté kui kakini nteē ntó Xuva kō? Ña kúvi nakuido ō ñaꞌa san é kada ntaa ña un ntɨꞌɨ̄ e xkoó ini o e xtûví ñata kō é vīi o. Tsí nté ñata kō, nté xoꞌō, ñá ni kūtíi o kāda ntaa o. ");
INSERT INTO mizNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","É īni nto tsí doméni tsi nakáku o ntaꞌa Xuva kō ne, dómēni tsi nakaku ña é ña te ña Israeé san dɨ́ tē kuíntiꞌxe ña —kaꞌán Pedru ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kidáā ne, diin diin tsi nakuntoo ña vata koo é kīni váꞌa ña é ntákaꞌan Pablu ni Bernábee, é ntaa ña ni ña un ntɨꞌɨ nuū i e dóo naꞌnu é edé Xuva ko nī ña é ña te ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Dā kúvi ntáa ntɨꞌɨ ña ne, eni ntuꞌu Sāntiau kakáꞌan ñá ni ñā: —Kini nto ve é kākaꞌán u ni nto, ēni: ");
INSERT INTO mizNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ntāa Simuun Pedru ní kō nte o dé Xuva kō. Tsi nté dīꞌna xeꞌé ña itsi é niꞌi ña é ña te ña Israeé san é vāꞌá ntaꞌa ña, ña é nākaxnúu ña é kuvi iꞌxá ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Sáꞌā né, vata tsī ó uve naꞌa nte díꞌna dá kaꞌan ñá kaꞌán naa Xuva ko: ");
INSERT INTO mizNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Da kidáā ne, ntiꞌxi ú, naxtūví u uun iꞌxá Davii é viī ñá rei vata o dé Davii da itúvi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kidáā ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña é ña te ña Israee, ña é nakaxnúū ú é kūvi ña iñá ko ne, dɨvi ñā nantúku ñā kó é kuntīkɨn ñá ko. ");
INSERT INTO mizNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Sáꞌa kākaꞌan Xúva kō; nté dīꞌna táꞌxi ña kútūní ko tsí kuan kōo kuvi, kaꞌan ñá kaꞌán naa ña kídaā. ");
INSERT INTO mizNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ʼDukuān ne, káꞌān ú tē ña nateñu núu ō ña é ña te ña Israeé san e xtúvī mii ña é kuintiꞌxe diꞌna ña vata koo é kuntīkɨn ñá Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mii tsī é taxnuu o tūtú iña ña, káꞌan o ni ñā é ñá ku kāꞌxi ñá kúñū kɨtɨ é intáa ntēé xuva ñā, ña inúu ini ñā ne, ña vii ña é kini kaa ni ñadɨ̄ꞌɨ́ ne, ñá kāꞌxi ñá kúñū kɨtɨ é ña ni kii ntɨ́ꞌɨ nɨñɨ i, nté nɨñɨ́ tɨ ña káꞌxi ña. Sáꞌa tsi kāꞌán ō é viī ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tsí ini ñaꞌa é kuān koo vii o nté ntūvi diꞌna. Tsí dā míꞌi ka ñuú iō ñá ntákaꞌan ntódo lei Muísee, tsí vata dá sábadu ntánakuāꞌa ña leí san má ūkún ña Israeé san —kaꞌan Sántiau. ");
INSERT INTO mizNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kidáā ne, pustrú san ni ñatā sán, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñá kuíntiꞌxe i sán ne, íntēe iní ña é nakaxnūu ña uvi ñaꞌa ení ña é kɨꞌɨ̄n ñá nī Pablu ni Bernábee ñuú Antioquia. Nakaxnúu ña Juda Barsabaa ni Sílā. Ñatīí saꞌá ne, dōó naꞌnu ñaꞌa ña iña ña kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Táxnūu ña tutú dɨ é kɨ̄ꞌɨn niꞌi ña. Kakaꞌan tutú san: “Ntɨꞌɨ é pustrú ntɨ, ni ñata, ña odo nūú, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñá kuíntiꞌxe i ne, taxnūu ntɨ́ ntiusi iña ení ntɨ, ña é ña te ña Israee, ña ntoo ñuú Antioquia, ni ñūú Siria, ni ñūú Cilicia dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Dā vé kutuní ntɨ tsi íō ñaꞌa, ña ñeꞌe ñuú mí ntoo nto, ña é nāteñu núu ña nto vata koo é nādama nto é ntákuintiꞌxe nto. Ña tsīkán ne, ntákaꞌan ña tsí da miī é tēꞌnte kúñū é ixi ntó, da miī é kāda ntaa nto lei Muísee. Ntá tsi ña te ntɨ́ꞌɨ ní taxnūu ntɨ́ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Dukuān né, un tsi dē kuení ntɨ é nākaxnúu ntɨ́ uvi ñaꞌa ení ntɨ é taxnūu ntɨ́ ña é kɨꞌɨn ña ni Bernābee ní Pablu, ení kō, ña dóo kakuinima ko. ");
INSERT INTO mizNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Dɨvi ñā ne, ñá ni uꞌvī niꞌi ña ntuvi íña ña, é kuān te na kuví ña kuenta iña Tóꞌo ko Jesūcristu. ");
INSERT INTO mizNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Dukuān ne, táxnūu ntɨ́ Júda nī Sílā, é kāꞌan míi ña ni ntō, é nañēꞌe ñá nto un ntɨꞌɨ sāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sáꞌā xío ntaa iní ntɨ nī Espíritū Sántū, é ña váꞌa ō é nantōꞌo ntɨ́ nto. Mii tsi nuū i sáꞌa é kantio é viī nto: ");
INSERT INTO mizNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ña káꞌxi nto kúñū kɨtɨ e xntáa ntēé ñaꞌa xuva ñā; ñá kaꞌxī ntó nɨñɨ tɨ, nté kɨtɨ é ña ni kii váꞌa nɨñɨ tɨ. Ñá viī nto é kini kaa ni ñadɨ̄ꞌɨ́ dɨ. Sáꞌa tsī é kāꞌán ntɨ ni ntō: Te kāda ntaa nto sáꞌa ne, váꞌa koo kuntōo nto”, kaꞌan ñá ini tutú san. ");
INSERT INTO mizNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kidáā né, kīi ña, kueꞌen ña mí táxnūu ña ña ñuú Antioquia. Dā náxee ñá ikān né, kāna ña un ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i san é na nātaká nuu ña é kuēꞌé ña ña tutú san. ");
INSERT INTO mizNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Dā kúvi nakuaꞌa ña tutú san ne, nákuꞌun dîní nima ñá, tsi dóo váꞌā ó kakaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Júda nī Sílā ne, ña ntákaꞌán naa Xuva ko dɨ́ ne, dōo nátsuꞌun kaꞌnu ña nima ñá kuíntiꞌxe i san, ntaxéꞌe ña ña itsi nté koo vií ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Dā kú tɨtɨ́n ntuvi ntoo ña ikān ne, ña kuíntiꞌxe i san nátsuꞌun itsi ña ña, kakaꞌan ñá ni ñā: —Vaꞌa váꞌa tsi kunúꞌu nto mí ntoo ení nto, ña táxnūu nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ntá tsi Sílā né, ntīo ña é kūkuií ka ña, kutuvī ñá ñuú Antioquia. Ñá ni nūꞌu kantɨ́ꞌɨ ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablu ni Bernábeé dɨ ne, kántoo ña ni ñā. Dōo tɨtɨ́n ka ña kantóo ña é nakuāꞌa ña ñaꞌa san, kakaꞌan ntódo ña túꞌūn Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Dā kú tɨtɨ́n ntuvi ne, kakaꞌan Páblu ni Bernábee: —Kɨ́ꞌɨn xtuku ō, kikoto níꞌni o ení kō, ña kuíntiꞌxe i san, da míꞌī ká ñuu mí ñeꞌe o, íxkaꞌan ntódo ō túꞌūn Tóꞌo ko Jēsuu. Kikoto ntódo ō nté o de ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","—Kuvi ni —kaꞌan Bernábee—. Ntá tsi kunteka ō Juaan Marcú dɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","—Ñáꞌā —kaꞌán Pablu—. Tsí dɨvi ñā né, tsoo mii ña kō dá ñeꞌe o ñuú Panfilia. Ñá ni de ntaā ñá tsiñu ña —kaꞌán Pablu. ");
INSERT INTO mizNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kidáā ne, naa núu ña ntuvi ñá ne, kīi nteé xio táꞌan ña. Bernabeé ne, kuéꞌen ña, ntēka ñá Juaan Marcu. Ñuꞌu ña tun ntōó kaꞌnu, kuéꞌen ña ñuú Chipre. ");
INSERT INTO mizNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablú ne, nākáxnúu ña Sílā é kɨ̄ꞌɨn niꞌi ña ña. Kuéꞌen ñā, ntuvi ña, da kúvi kaꞌan ntâꞌví ení ña iña ña. Ntákaꞌan ña é na kūnuu méꞌñu, kūnuu dava Xuva ko ña. ");
INSERT INTO mizNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kidáā ne, ítā ntiꞌxin ña ñuú Siria ni ñūú Ciliciá ne, ntánatsuꞌun kaꞌnu ña nima ñá kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablú ne, xée ña ñūú Derbé ne, dá kuēꞌen ñá ñuú Listra. Ikān ne, nániꞌi ña uun ñaꞌa, ña kuíntiꞌxe i, ñá nani Timōteu. Dɨꞌɨ ñā ne, ña Israeé ne, kakuintiꞌxe ña Jesuu. Uva ñā ne, ñá te ña Israeé ña, tsí ña griegu. ");
INSERT INTO mizNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Un ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i, ña ñuú Listra, ni ña ñuú Iconiú ne, kakaꞌan ñá tsi dóo vaꞌá ñaꞌa Timoteu. ");
INSERT INTO mizNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ntío Pablu é dadɨɨ kɨꞌɨn ñá ni ñā, ntá tsi diꞌna teꞌnte kúñū é ixi ñá vata koo é ña kadá kuení kini ña Israee, ñá ntoo mí kɨ̄ꞌɨn ña, tsí ini ntɨɨ́ ntɨɨ̄ ñá tsí uva ñā ne, ña griegu. ");
INSERT INTO mizNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Un ntɨɨ́ ntɨ̄ɨ́ ñuu mí kaita ntiꞌxin ñá ne, xéꞌe ñā é kūtuni ení ña, ña kuíntiꞌxe i san, túꞌūn e táxnūu pustrú san ni ñata, ña odo nūu iña ña kuíntiꞌxe i ñuú Jerusaleen, é kākaꞌan ñá ni ñā nté koo vií ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Dukuān ne, dií dií ka nɨɨ̄ kueꞌén ini ñaꞌa san kuíntiꞌxe ña Xuva kō. Utén utén kakutɨtɨ́n ña kuíntiꞌxe i. ");
INSERT INTO mizNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ña ni xéꞌe Espíritū Sántu ītsi é kɨ̄ꞌɨn ña, kikaꞌan ntódo ña túꞌūn san ñuú Asia, tsí xio ñuu ntío ña é kɨ̄ꞌɨn ña. Dukuān ne, ñuú Frigia ni ñuú Galacia ita ntíꞌxin ña ne, ");
INSERT INTO mizNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","xée ña dīñɨ ñuú Misia. Kidáā ne, ntio ña é kɨ̄ꞌɨn ña nte ñuú Bitinia, ntá tsi Espíritū Sántū sán ne, ña ni ntío xtūku ña é kɨ̄ꞌɨn ñá ikān. ");
INSERT INTO mizNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Dukuān ne, ído ntūú ña ñuú Misia, kúntīí ña ñuú Troa, mí kanaxee tún ntōó naꞌnu. ");
INSERT INTO mizNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Niñu tsikán ne, xée nūú Pablu úun ñatīí, ña ñuú Macedonia. Ntitsí ña, kakaꞌan ña: “Kiꞌxi kudii nto ñuú ntɨ, dá xntii ntō ntɨ”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Dá kuān o íni Pablú ne, xío ntiī ntɨ́ é kɨ̄ꞌɨ́n ntɨ ni ña ñūú Macedonia, tsí kútuní ntɨ tsí mii Xuva ko kākana ña ntɨ é kɨ̄ꞌɨ́n ntɨ, kikaꞌan ntódo ntɨ́ nī ña ntoo Macedonia túꞌūn vaꞌá san. ");
INSERT INTO mizNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kidáā ne, ñúꞌū ntɨ́ tun ntōó kaꞌnu ñuú Troa, kueꞌen ntáa ntɨ́ ñuu é tuvi méꞌñu ntute ñuꞌu kān, ñuu é nani Samōtracia. Utén san ne, xéē ntɨ́ ñuú Neapoli. ");
INSERT INTO mizNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Da kidáā xeé ntɨ ñuú Filipu, mí ntoo ña véꞌxi ñuú Roma. Dɨvi ñūu é dií ka kaꞌnu é un ntɨɨ́ ntɨ̄ɨ́ ñuu é kāduku ntée ñuú Macedonia. Tɨtɨ́n ntuvi intóo ntɨ́ ikān. ");
INSERT INTO mizNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Dā xee ntúvi iō dáꞌna ne, ntīi ntɨ́ diñɨ ñuú san, kueꞌén ntɨ diñɨ ntute kaꞌnu kān mí é dukuān xkoó kaꞌan ntâꞌví ñaꞌa san, kuíni ntɨ. Ikan tsī ñuꞌú ntɨ, ntákaꞌan ntódo ntɨ́ ni ñadɨ̄ꞌɨ́, ña nátaká nuu ikān, túꞌūn vaꞌá iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Uun ñaꞌa, ñá nanī Lidiá ne, ñuú Tiatira véꞌxi ña. Doo kuéꞌe kadiko ña. Ña sāꞌá ne, dōó kanuu iní ña Xuva kō. Xuva kō dé vitā ñá nima ñá vata koo é kinī ña é kākaꞌán Pablú ne, kuīntiꞌxe ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kidáā ítsi ntuté ña ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña ne, kakaꞌan ñá nī ntɨ: —Te kadē kuení nto é nuu é ntaā i e kuíntiꞌxe kó Tóꞌo ko Jesūcristú ne, kiꞌxi nto, kixkúntōo nto nú viꞌī kó kān —kaꞌan ña. Xēꞌe kuétsi ña ntɨ é kuntōo ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Uun ntuvi ñeꞌe xtúku ntɨ mí é dukuān xkoó kaꞌan ntâꞌví ña. Dá kuēꞌén ntɨ itsi kān né, tāꞌán ntɨ ni ūun taꞌnú kuetsī, taꞌnú nuu é ña váꞌā nima í ne, dōo kueꞌé diuꞌun niꞌí tun iña tóꞌō tún tsí kanakoto ntodó tun. ");
INSERT INTO mizNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Táꞌnu sāꞌá ne, íntīkɨ́n tun ntɨ́ ne, koó da kākachuꞌu ntáa tún, kakaꞌán tun: —Ñatīí saꞌá ne, ntáde tsiñu ña kuenta iña Xuva ko, ña e dóo kaꞌnu ne, ntákaꞌan ñá ni kō nté koo nakáku o ntaꞌa Xuva kō —kaꞌán tun. ");
INSERT INTO mizNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tɨtɨ́n ntuvi kuan o dé tun, da nté ña ni kutíī ká Pablú nima ña. Kidáā né, xkokōto ña, kakaꞌan ñá nī é ña váꞌā san é nuu nimá tun: —Kuenta iña Jesúcristu, ntíin nimá tun —kaꞌan ña. Ne, ura dúꞌva tsi i ntíi é ña váꞌā san. ");
INSERT INTO mizNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tōꞌó tun ne, dā kútuni ña tsí ña tuví ka nté koo niꞌi ñá diuꞌún ne, tɨ̄ɨn ña Pablu ni Sílā, íntēka ña ña ntaꞌa ña tsíñu i un tsi nte meꞌñú i kān. ");
INSERT INTO mizNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ntāda ña ña kuenta ntáꞌa toꞌo, kakaꞌan ña: —Ñatīí saꞌá ne, ña Israee ñá ne, ntánatēñu nuu ña ña ñuú kō. ");
INSERT INTO mizNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Tsí un ntɨꞌɨ̄ é vatā xkoó ini ña ñuú ña kān ntánañēꞌe ñá kō ne, ña kúvi viī o, tsí xoꞌō ne, ña ñuú Roma o —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kidáā ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ínchuꞌvi ñá ña ne, xéꞌe tōꞌó san itsi é nantɨɨ̄ ñá ña ne, dā natií nuu ña ña ntuku. ");
INSERT INTO mizNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Un váꞌa tsi natií nuu ña ñá ne, dā tsúꞌun kutu ña ñā viꞌi utun. Tēe tsiñu ña ña kade kuenta xíꞌi viꞌi útun é kuēnta tsí vií ña vata koo é ña ntii ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ña kade kuenta xíꞌi viꞌi útun sán ne, dē ntaa ña é kākaꞌan tóꞌó san ne, tsúꞌun kutu ñā Pablu ni Síla ūun tsi nte iní i kān ne, ini útun tsuꞌun ntido ña dɨ́ꞌɨn ña vata koo é ña kaka ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Dā kú dava ñuú ne, ñuꞌu Pablu ni Sílā, ntákaꞌan ntâꞌví ña, ntaíta ña nchuꞌún Xuva kō ne, ntaíni ntɨɨ́ ntɨ̄ɨ́ ña ñuꞌu kutū san. ");
INSERT INTO mizNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dā nénī ña dá un váꞌa tsi ntiī táan. Dá kanɨɨ̄ viꞌi utun san kantá nuu. Kidáā né, nākaan míi ūn ntɨɨ́ ntɨ̄ɨ́ xiꞌi viꞌi utun sán ne, ntīi nuu taꞌan ntɨꞌɨ kadena é odō kútu dɨ̄ꞌɨ́n ña ñuꞌu kutū san. ");
INSERT INTO mizNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Da kidáā ntóto ña kade kuenta xíꞌi viꞌi útun san. Dā kútuni ña tsí kantii ntaa ntɨ́ꞌɨ xiꞌi viꞌi útun sán ne, ura tsí i táva ña káa ñā é kāꞌni mii ña kúñu ñā, tsi é ntīí ntɨꞌɨ ña ñuꞌu kutū san, kuíni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ntá tsi Pablú ne, un ntii tsī kaꞌan ña: —¡Ñá ku kuān xkoó de ntō! tsí ntɨꞌɨ́ ne, iꞌa ñuꞌu ntɨꞌɨ ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kidáā ne, ña kade kuenta xíꞌi viꞌi útun sán ne, íkan ña ñūꞌú ne, kaxkainu ña kukɨ́ꞌvi ña iní viꞌi utun kān. Koó da kānɨ́ꞌɨ ña inchɨ́tɨ ña nú dɨ̄ꞌɨ́n Pablu ni Sílā. ");
INSERT INTO mizNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kidáā ne, nantíi ña ñā viꞌi utun sán ne, tsixeꞌe ña ñā: —Dɨvi ntō, ¿nté ntu koo vií u é nakáku ú ntaꞌa Xuva kō? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","—Kuintiꞌxe nto Tóꞌo ko Jesūcristú ne, nakaku ntó ntaꞌa Xuva ko, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi nto dɨ —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ne, ntákaꞌan ntódo ña ni ñā túꞌūn vaꞌá iña Xuva kó, ni ūn ntɨɨ́ ntɨ̄ɨ́ ña ntoo nú viꞌi ña kān dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Dɨvi tsi nīñú san ne, ña kade kuenta xíꞌi viꞌi útun sán ne, nākate nuu ña mí niꞌi kuiꞌí Pablu ni Sílā. Kidáā né, ītsi ntute ña, ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kidáā ne, kúxee niꞌi ñā Pablu ni Síla īní viꞌi ña kān né, ikān xeꞌé ña é kāꞌxi ña. Dōo dîní ña ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña tsi e kuíntiꞌxe ña Xuva ko vē. ");
INSERT INTO mizNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Dā tuví ne, táxnūu toꞌó san mau é kūkoto ná te nantīi ña Pablu ni Sílā. ");
INSERT INTO mizNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kidáā ne, kākaꞌan ñá kade kuenta xíꞌi viꞌi útun san: —É tāꞌxi toꞌo ítsi é nantīi ú nto. É kūvi ntii nto ve ne, váꞌā o váꞌa tsi kuēꞌen nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ntá tsi Pablú ne, kakaꞌan ña: —¿Míꞌi ntū? Tsi ntɨꞌɨ́ ne, ña ñuú Romá ntɨ ne, dɨvi ñā natií nuu ña ntɨ́ ntuku méꞌñū ñaꞌa san dá vāta xntekú kuꞌvē ñá leí san iñá ntɨ. Dotō tsi tsúꞌun kutu ñā ntɨ́ viꞌi utun. Vevií ne, ntio ña é nantii xuꞌū ñá ntɨ. ¡Ñáꞌā! Na kiꞌxi mii ñā, dá nantīi ña ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kidáā né, ntiko kōó maú san, kunúꞌu na ne, ntaa na ni tōꞌó san é kākaꞌán Pablu. Toꞌó san ne, dōo uꞌví ña da kútuni ña tsí ña ñuú Roma. ");
INSERT INTO mizNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kidáā ne, kuéꞌen ña, kūnakaꞌnu ña iní Pablu ni Sílā ne, kidáā ne, nantíi ña ña, kakaꞌan ña: —Vií nto da xeꞌe, ntii nto ñuú ntɨ —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Dā ntíi ña viꞌi utun sán ne, kúnūꞌú ña nú viꞌī Lidia. Ikān nátaká nuu ña un ntɨɨ́ ntɨ̄ɨ́ ení ña, ña kuíntiꞌxe i sán ne, nāxnuu kaꞌnu ña iní ña. Da kidáā ntíi ña, kueꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kuéꞌēn Pablu ni Sílā, ita ntíꞌxin ña ñuú Anfipoli ni ñūú Apolonia, xée ña ñūú Tesalonica, mí tuví xúkūn ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Vata xkoó ini Pablú ne, ñéꞌe ñā má ūkún kan ntūvi dá iō dáꞌna. Úni īto ñeꞌe ña é tiín ña ni ñāꞌa san, ");
INSERT INTO mizNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","kanañēꞌe ña ña mí uve naꞌa Túꞌun Xuva kō nte díꞌna é da miī é ntōꞌo Cristu, ña nakaxnúu Xuva kō ne, da miī é ntotō xtuku ña te xiꞌi ña. Kakaꞌan ña: —Dɨvi tsi Jēsuu é kākaꞌán ntɨ ni ntō né, dɨvi ñā é Cristu ñá, dɨvi ñā é taxnuu Xuva ko ñā —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Iō ñá Israeé san ne, kuīntiꞌxe ña é kākaꞌan Páblu ne, kúdadɨɨ ñá nī Pablu ni Sílā. Ñá te da dīi ñá griegu, ña é ntánuu iní i Xuva ko, ni ñadɨ̄ꞌɨ, ña e dóo naꞌnu ñaꞌa ne, kuīntiꞌxe ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ntá tsi ña Israee, ña é ña ni kuintíꞌxe i ne, kūneꞌu iní ña ni ñā. Kidáā né, īde ña é nātaká nuu natīi kini ntáa, na é dotō tsí ntáñɨ̄ dúꞌxen nu âꞌví kān. Nātaká nuu na ne, dā nakutsúꞌun na da kanɨɨ ñūú san. Kidáā ne, íntīꞌu na nú viꞌi ña nani Jāsuun, ntánantuku nā Pablu ni Sílā é ntāda na ña kuenta ntáꞌa ña tsíñu i. ");
INSERT INTO mizNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ntá tsi ña ni naníꞌi na ña. Mii tsi Jāsuun, ni túku ení ña, ña kuíntiꞌxe i san naníꞌi na. Ntáñūꞌu na ña, kueꞌen niꞌi na ña ntaꞌa ña tsíñu i san ne, koó da vāntiñɨ na ntákaꞌan na, ntátsiꞌi kuétsi nā Pablu ni Sílā: —Ña sāꞌá ne, da kanɨɨ ñūxiví a ntaíka ña, ntánakutsúꞌun ña ñāꞌa. Vevií ne, un tsi nte íꞌa xee ñá ve ne, ");
INSERT INTO mizNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasuún san ne, xéꞌe ña vīꞌi ña é kuntōo ña. E ntáde ña sáꞌa ne, dōo xíi kaa. Ñá te kaiko ñuꞌu ña rei ñuú Roma, tsí ntákaꞌan ña é iō túku rei, ñá nani Jēsuu —kaꞌan na. ");
INSERT INTO mizNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ni ña tsíñu i san ne, dōo ítsuꞌun ña da téku ña sáꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kidáā né, kīꞌi ña diuꞌun Jásuun ni ña ntɨɨ níꞌi ña ne, nangáva ña ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Dā kuáa ne, táxnūu ña kuíntiꞌxe i san Pablu ni Sílā é na kɨ̄ꞌɨn ñá ñuú Berea. Dā xee ñá ikān ne, kuéꞌen xtūku ña má ūkún ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ña Israee, ñá ntoo ñuú Bereá san ne, dií ka vita ini ña é ña ntoo ñuú Tesalonica, tsí nɨɨ̄ kueꞌén ini ña ntaíni ña Túꞌun Xuva kō ne, utén uten nántuku ñā mí ūve naꞌa Túꞌun Xuva kō da nté kutuni ñá tē nuu é ntaā i é kākaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Dukuan ne, dōó tɨtɨ́n ña Israee kuíntiꞌxe ña, nī ña griegú dɨ, tē tií te ñadɨ̄ꞌɨ́, kuān te dóo naꞌnu ñaꞌa ña ne, kuīntiꞌxe ña dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ntá tsi dā kútuni ñá Israee, ñá ntoo ñuú Tesalonica, é kākaꞌan ntódo xtuku Pablu túꞌun Xuva ko ñūú Bereá ne, xée ñā é nakutsuꞌun xtūku ña ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ntá tsi ña kuíntiꞌxe i sán ne, ura tsí i táxnūu ña Pablu é na kɨ̄ꞌɨn ña nu ntute ñuꞌu kan. Mii tsī Síla ni Timōteu kántoo mii ña ñūú Berea. ");
INSERT INTO mizNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ña ixntéka itsi Pablú ne, kuéꞌen ña ni ñā un tsi nte ñuú Atena. Dā ntíko kōo xtúku ña, kakaꞌan ñá nī Síla ni Timōteu é na kɨ̄ꞌɨn kantɨ́ꞌɨ ña, kíkuntóo ña nī Pablu. ");
INSERT INTO mizNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nɨɨ dukuān tuví Pablu ñuú Atena é kantétu ña Síla ni Timōteú ne, dōo dé kuení ña dá īni ña tsí ña ntoo ñuú Atená ne, da miī kueꞌen tsi sántu ntūváꞌa naa íō iña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Dōó kiꞌin itō ñeꞌe ña má ūkún kān é natíin ña nī ña Israeé san ni ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntánuu iní i Xuva kō. Utén utén ñeꞌe ña nu âꞌví kān dɨ́, kakaꞌan ñá nī ña ntánataká nuu ikān. ");
INSERT INTO mizNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ikān ne, xíō ñaꞌa, ña ntántīkɨn túku nchuꞌun iña ñá nani Epīcurú ne, xíō túku ñaꞌa, ña ntántīkɨ́n nchuꞌun é nani ēstoicu. Ña sāꞌá ne, ntákaꞌan ña: —¿Neé ntu kani túꞌun é kuān nte kakáꞌan ña? —kaꞌan ña. Íō ñá ne, ntákaꞌan ña: —Vata tē é tūkú xuva ncho nañeꞌē ñá kō —kaꞌan ña. Tsí Pablú ne, kakaꞌan ntódo ña túꞌūn vaꞌá iña Jésuú ne, kakaꞌan ñá e ntóto xtuku ña dá xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kidáā ne, ntánteka ñā Pablu, kueꞌen níꞌi ña ña uun mí nani Areōpagu, mí é dukuān ntánataká nuu ñata ña odo nūu, ntaxéꞌe ña itsi ña ñuú i san. Tsixeꞌe ñā Pablu: —Káꞌan kūdii ntó, na kīni ntɨ neé nchuꞌun xee é vexníꞌi ntō. ");
INSERT INTO mizNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tsí ntɨꞌɨ́ ne, ñá te kāñeꞌe dɨkɨ́ ntɨ é kākaꞌan nto, tsí tuku nchuꞌun é iní ntɨ. Nañēꞌe kudii ntó ntɨ nee é kani túꞌun é kākaꞌan nto —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tsí ña ñuú Atena ni ña da xee ntóo ikān né, da mii kuēꞌen tsi nchó kini ña nee é dā ve kakuvi é natíin ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kidáā ne, nákuntītsí Pablu méꞌñū ñaꞌa san Areopagu kán ne, kakaꞌan ñá ni ñā: —Dɨvi ntō, ña ñuú Atena, é īní u tsí dōó īó xuva ntō e ntánuu iní nto. ");
INSERT INTO mizNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Dā ítā ntiꞌxin ú ñuú nto, kaito dîtó u nee ntɨ́ꞌɨ ntɨꞌɨ iña nto e ntánuu iní nto ne, nāniꞌí ko uun nú naa kan mí ūve naꞌa kakaꞌan: “Iña xúva kō, ña e ñá ini o xoo ñáꞌa”, kaꞌan. Dɨvi tsi xuva ntō, ña e ñá ini ntó ne, dɨvi Xuva kō é kākaꞌán u ni ntō vevii. ");
INSERT INTO mizNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ʼTsí Xuva kō né, dē kúꞌvē ñá ñuxiví ni un ntɨꞌɨ̄ é īo. Dɨvi ñā Tóꞌō e dukún kan ni ñūxiví a. Ña te víꞌī mí de váꞌa ñaꞌa tuví ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nté ña túvi nee iña é kūvi kuéꞌe o ñā, tsí ña tuví nee iña é kātaan núu ña. Mii ña kātaꞌxi ña ntuvi iña ko ni tatsin é taꞌni o, ni un ntɨꞌɨ̄ é īó iña ko, xe un xé un ō. ");
INSERT INTO mizNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ʼUun tsi nɨñɨ ko dé kûꞌvé Xuva ko un ntɨɨ́ ntɨɨ̄ o é ntoo o da kanɨɨ ñūxiví a. Mii ñā de kúꞌvē ña nté kaa ntuvi kuntoo o ñūxiví a nī míꞌi ñūú kuntoo o, xe un xé un ō. ");
INSERT INTO mizNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kuān o dé Xuva kō, tsi ntío ña é nantuku o ñā, un ntɨɨ́ ntɨɨ̄ o, da nté koo é naniꞌí ko ña. Ntá tsi ña te nté sa ikā tuví ña, ");
INSERT INTO mizNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","tsí dɨvi ña taꞌxi ña ntuvi iña ko, nī é kakantá nuu o, nī é tuví ō. Kuān ó uve naꞌa, kakaꞌan ñáta ntō, ña de váꞌa tutú san, kakaꞌan ña: “Xoꞌō ne, iꞌxá Xuva ko ō”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tē nuu é ntaā i é īꞌxá Xuva kō kúvi ō ne, ña kúvi kāꞌan o é Xuva ko da nēé ka ntɨꞌɨ, tē kaá kuaan, tē kaá kuīꞌxín, o xuu e ntávaꞌa naa ñaꞌa vata ō dé kuení mii ña é vata kaa Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ntuvi diꞌna ne, dé kaꞌnu iní Xuva ko nī ña intóo kídaā e kuán o dé ña, tsí ña ni iní ña nté koo vií ña. Ntá tsi vevií ne, ntio Xuva kō é nadama ō nima kíni kaa ko. ");
INSERT INTO mizNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tsi e xtûví Xuva ko ūun ntuvi é xntēkú kuꞌvē ñá da kanɨɨ ñūxivi. Tsí é nakaxnúu ña uun ñatīi, ña é xntēku kûꞌve. É īni ó xoo ñáꞌa, tsí nantóto Xuva ko ñā dá xiꞌi ña —kaꞌan ña. Dukuan ō kaꞌán Pablu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Dā téku ñaꞌa san é kākaꞌán Pablu é ntóto xtuku uun ñaꞌa é xiꞌi ñá ne, iō ña ntáxkuntée ña ña. Iō ñá ne, ntákaꞌan ña: —Dá nte ūun ká tuku ntuvi kaꞌan ntó nī ntɨ́ sáꞌa —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kidáā né, kīi Pablu, kuéꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Iō ñá ne, kantīkɨn ñá Pablú ne, kuīntiꞌxe ña é kākaꞌan ña. Uun ñaꞌa ñā ne, Dionisiu náni ña; tsiñu ña Areopagu. Uun ñadɨ̄ꞌɨ́, ña nani Dāmarí dɨ ne, īó ka tuku ñaꞌa kuíntiꞌxe i dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kidáā né, ntīí Pablu ñuú Atena, kuéꞌen ña ñuú Corintu. ");
INSERT INTO mizNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ikān nániꞌi ña uun ñatīi, ñá Israee, ñá nani Āquila. Ñuu é nanī Pontu véꞌxi ña. Vata e náꞌa xee ña, ntuvi ñá ñadɨꞌɨ̄ ña, ñá nani Prīsila. Tsí e ntíi ña ñuú Italia da nakunú rei Claudiu ún ntɨɨ́ ntɨ̄ɨ́ ña Israeé san ñuú Roma. Kuéꞌēn Pablu, kúkoto níꞌni ña ña ne, ");
INSERT INTO mizNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ikan tsī katúvi ña ni ñā. Dadɨɨ tsi de váꞌa ña viꞌi doo, tsí dɨvi tsi tsīñu ini ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Vatā dá iō dáꞌna ne, kañeꞌé Pablu má ūkún kan, kanañēꞌe ña ña Israeé san nī ña é ña te ña Israeé san dɨ nté koo kuintiꞌxe ña Tóꞌo ko Jesūcristu. ");
INSERT INTO mizNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Dā xeé Síla ni Timōteu, é vēꞌxí ña ñuú Macedoniá ne, nguentúvi kakaꞌan ntódo Pablu túꞌūn vaꞌá san, kakaꞌan ñá nī ña Israeé san tsí Jesuú ne, dɨvi ñā é Cristu, ñá nakaxnúu Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ña Israeé san ne, naa núu ña ni ñā ne, dōó kini kaꞌan ñá ni ñā. Dukuān ne, Pablú ne, nākɨdɨ ña doo ña vata koo é kuēꞌé ña kuenta é ñā te váꞌa ō ntáde ña. Kakaꞌan ñá ni ñā: —Kuenta iña mii nto ve te ña níꞌi nto é vāꞌá ntaꞌa Xuva kō. Xuꞌú ne, ña túvi kuētsí ko, tsí é kākaꞌán u ni ntō. Viꞌa ve ne, xio ñuú kɨꞌɨ́n u, kíkaꞌan ntódo ú ni tūku ñaꞌa, ña é ña te ña Israee —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kidáa ne, ntīi ña má ūkún kān, kuéꞌen ña má viꞌī ñá nanī Justo, ña dóo kanuu iní i Xuva kō. Etsin tsi mí ntitsi xúkūn san tuví viꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ña odo nūu ini ukun, ñá nanī Crispú ne, kuīntiꞌxe ña Tóꞌo ko Jesūcristu ni ún ntɨɨ́ ntɨ̄ɨ́ ñaviꞌi ña. Ñá te da dīi ñaꞌa, ña ñuú Corintú dɨ, dā téku ña é kākaꞌán Pablú ne, kuīntiꞌxe ña ne, ītsi ntute ña. ");
INSERT INTO mizNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Uun niñú ne, vata tsi tē íni Pablu é kākaꞌan Xúva ko ni ñā: —Ñá ku uꞌvī o é kāꞌan ntódon. Kuan tsī koo kaꞌan vátā ó den, ");
INSERT INTO mizNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","tsí xuꞌú kunuu méꞌñū ú o. Xōxó kuvi víi i ni o, tsi dóo iō ñáꞌa ko ñuú saꞌa —kaꞌan Xúva ko ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kidáā ne, uun kuia nte dáva kātúvi ña ñuú Corintu, nakuáꞌa ña ñaꞌa san túꞌun Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ntuvi tsikán ne, dā inúu ñá nani Gāliuun, de kúꞌvē ñá ñuú Acayá ne, nātaká nuu ña Israeé san ne, tɨ̄ɨn ña Pablu, kueꞌen níꞌi ña ña ntaꞌa ña tsíñu i ne, ");
INSERT INTO mizNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ikān tsíꞌi kuétsi ña ña, ntákaꞌan ña: —Ñatīí saꞌá ne, kanañēꞌe ñá ñaꞌa é kūnuu ini ñá Xuva kō, ntá tsi ña te vatā ó kakaꞌan leí san. Dōo xíi kaa é vīi o é kākaꞌan ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Dā vata kani ntúꞌu Pablu káꞌan ñá ne, diꞌna ña tsiñu kaꞌnu i Galiuún san kakaꞌan ñá nī ña Israeé san: —Tē dɨ́ dóo xii kaa ntiꞌxé nuu i é kanañēꞌe ña ne, kiní u é ntátsiꞌi kuétsi nto, ¿nté kui ñaꞌa? ");
INSERT INTO mizNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ntá tsi ntōꞌó ne, kūdii kuénta iña lei míi nto ntánāa núu nto. Mii nto kadā kúꞌvē ntó ve. Ñá te xūꞌu é kāduku ntée ú sáꞌa —kaꞌan ñá ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kidáā ne, kīi ñuꞌu ña ña kíꞌi kān ne, ");
INSERT INTO mizNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ña ntáñɨ̄ ntée kān né, ntāva ntodó ña ñá odo nūu iña úkūn, ñá nani Sōstené ne, ikan tsī éꞌni diín ña ña nuu ña tsíñu i san. Ntá tsi Galiuún san ne, ña ni íde ña kuenta. ");
INSERT INTO mizNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablú ne, naꞌā itúvi ña ñuú Corintu. Kidáā ne, kakaꞌan ñá ni ēní ña ña kuíntiꞌxe i san é nūꞌu xtúku ña ñuú Siria. Kántēká ña Prisila ni xɨ́ɨ ña Aquila, kuéꞌen ña. Diꞌna dá ntáka ña ñuú Cencreá ne, kūntɨɨ́ tduꞌu dɨ́kɨ́ Pablu váta koo é kueꞌe ña kuenta tsí xeꞌé ña xuꞌu ña ni Xuva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kidáā ne, ñúꞌu ña tun ntōó kaꞌnu, xee ñá ñuú Efesú ne, ikān kantóo mii Prīsila ni Áquila. Pablú ne, diꞌna dá ntaka ña ne, kuéꞌen ñā má ūkún kān é kāꞌan ñá nī ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ña Israeé san ne, ntákaꞌan ña: —Vií nto da xeꞌe, kutuvī ká nto nī ntɨ —kaꞌan ña. Ntá tsi ña ni ntío Pablu. ");
INSERT INTO mizNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Dā ntáka ña ne, kakaꞌan ña: —Da miī é kantio é kutūví u ñuú Jerusaleen é kūvi viko. Te Xuva kō ntio ñá ne, ntiꞌxi xtuku ú, ntixkoto niꞌni ú nto —kaꞌan ña. Kidáā ne, nákunūu ña tun ntōó kaꞌnu da ntáka ña ñuú Efesu, kuéꞌen ña. ");
INSERT INTO mizNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Dā xee ñá ñuú Cesareá ne, diꞌna ñuú Jerusaleen ita ntíꞌxin ña é kāꞌan ñá ntiusi ni ña kuíntiꞌxe i sán ne, da kidáā ntíi ña, kueꞌen ña ñuú Antioquia. ");
INSERT INTO mizNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Dā kú tɨtɨ́n ntuvi itúvi ña ikān né, eni ntuꞌū xtuku ña ika ña. Ítā ntiꞌxin xtuku ña ñuú Galacia ni ñuú Frigia é xntíi ña ña kuíntiꞌxe Xuva ko, nātsuꞌun kaꞌnu ña iní ña. ");
INSERT INTO mizNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ntuvi tsikán ne, xée uun ñatīi, ñá nani Āpolo, ñuú Efesu. Ñuú Alejandria véꞌxi ña, ntá tsi ña Israee ña. Ña sāꞌá ne, dōo váꞌā ó kakaꞌan ña, kakaꞌan ntódo ña; dōó ini ña túꞌun Xuva kō é ūve naꞌa nte díꞌna. ");
INSERT INTO mizNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Dōo ini ñá nchuꞌun Xúva kō dɨ. Nɨɨ̄ kueꞌén ini ña kakaꞌan ntódo ña ne, nuu é ntaā í un ntɨꞌɨ̄ é kākaꞌan ñá iña Jésuu, kuān te mii tsi é nakutsi ntute Juaan Bautista íni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ñá te kauꞌvī ña, kakaꞌan ntódo ña ini ukún ña Israeé san. Dā téku Prisila ni Áquila é kākaꞌan ñá ne, kāna xio ña ña ne, náñēꞌé ka ñá ña iña Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apoló ne, ntio ña é kɨ̄ꞌɨn ñá ñuú Acáya. Xíō ntaa iní ña kuíntiꞌxe i san. Táxnūu ña tutú ntaꞌa ña kuíntiꞌxe i, ña ntoo ñuú Acaya, na vāꞌá koo nakuetu ña Apoló san tē xee ña ikan. Dā xee ñá ñuú Acayá ne, dōó kueꞌe xntíi ña ña kuíntiꞌxe i Jesuu, tsí dóo váꞌā o dé Xuva ko ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tsí Apoló ne, dōó ini ña nté koo kaꞌan ñá nī ña Israeé san méꞌñū ñaꞌa san, kanañēꞌe ñá ña tsí nuu é ntāa ntíꞌxe i tsí Jesuú ne, dɨvi ñā é Cristú, dɨvi ñā é nakaxnúu Xuva ko ñā é kodo nuū ñá, vatā ó uve naꞌa túꞌun Xuva kō nte díꞌna. ");
INSERT INTO mizNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nɨɨ dukuān tuví Apolo ñuú Corintú ne, kuéꞌēn Pablu, ita ntíꞌxin ña itsí rkɨ uku kan, xée ña ñuú Efesu. Ikān nániꞌi ña tɨtɨ́n kudii ña kuíntiꞌxe i san. ");
INSERT INTO mizNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pablú ne, kakaꞌan ñá ni ña, katsixeꞌe ña ñā: —¿Inúu ntu Espíritū Sántū nima nto da kuíntiꞌxe nto? —kaꞌan ña. —Á te ñaꞌa. Ntē vata kiní ntɨ xoo é Espíritū Sántū —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kidáā né, katsixeꞌē xtuku Pablu: —¿Neé ntu nchuꞌun e íni nto dá itsi ntute nto? —kaꞌan ña. —Nchuꞌūn é kākaꞌan Juaan Baútista —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablú ne, kakaꞌan ña: —Tsí Juaán ne, nákutsi ntūte ña ñaꞌa vata koo é kuēꞌé ña kuenta é nādama ña nima kíni kaa ña. Ntá tsi Juaán ne, kakaꞌan ñá te kuíntiꞌxe ko uun ñaꞌa, ña é dā ve véꞌxi. Ña tsīkán ne, e xée ñā. Jesuu nani ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Dā téku ñaꞌa san é kākaꞌan ñá ne, ītsi ntute xtuku ña, ntákaku niꞌi ña Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Kidáā né, dā xntékú Pablu ntáꞌa ña dɨkɨ ñá ne, ínūu Espíritū Sántū nima ñá ne, eni ntuꞌu ñā ntákaꞌan ñá tuku túꞌūn e ñá ini ñá ne, ntákaꞌan ñá túꞌūn é xeꞌé Xuva ko ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","É un ntɨꞌɨ ñā ne, iō ñá te ūxuvi ñáꞌa ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Uni xóo ñeꞌé Pablu má ūkún ña Israee. Ñá ni uꞌvī kueꞌen ña é kāꞌan ña. Kakaꞌan ntódo ña, kakaꞌan ña tsí Xuva kō né, dɨvi ñā é kadē kúꞌvē ña. Kakaꞌan ñá ni ñā é vāꞌá vata koo é kuīntiꞌxe ña Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ntá tsi iō ñá ne, dōó kaꞌxi nima ña. Ña ni ntío ña kuintīꞌxe ña ña. Ntákaꞌan xení ña iña túꞌūn vaꞌá san. Kidáā ne, xio kueꞌén Pablu, tsóo mii ña ña ne, kántēka ña ña kuíntiꞌxe i san, kueꞌen niꞌi ña ña nú viꞌī skuela mí nakuāꞌa ñá nani Tīranú ne, ikān natíin ña ni ñā utén uten. ");
INSERT INTO mizNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Uvi kuíā é kuān o dé ña. Dukuān ne, un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntoo da kanɨɨ ñūú Asia, tē ña Israeé, tē ña é ña te ña Israeé ne, tēkú ña túꞌūn Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Xuva kō ne, xéꞌe ñā é kūvi vií Pablu nuu i e dóo naꞌnu é nté uun ito vata kiní ñaꞌa é kuān koo kúvi. ");
INSERT INTO mizNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ntáñeꞌe niꞌi ñaꞌá san da nēé ka doo é tɨɨn ntaꞌā Pablu, te doo dúkūn, o tē doo núu ne, ntáxéꞌe ña ña nchokuví san ne, ntuváꞌa ña. Ntīi ntɨꞌɨ é ña váꞌā é ñūꞌu nima ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ntuvi tsikán ne, iō ñá Israee é ntaíka ña, ntánatava ña é ña váꞌā é ñūꞌu nima ñáꞌa san. Ntákaku niꞌi ña Tóꞌo ko Jēsuu dá natavā ñá ne, ntákaꞌan ña: —Kuenta iña Jésuu, ña é kākaꞌan ntódo Pablu íña i, kaꞌán u ni ō: ¡Ntíin nīma ña! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Duꞌva ō dé uꞌxe éni, iꞌxá dutu ñá odo nūu iña ñá Israee, ñá nani Ēseva. ");
INSERT INTO mizNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Uun ntuvi ne, nantíko kōo é ña váꞌā san: —Xuꞌú ne, iní u xoo e Jésuu. Iní u xoo é Pablú dɨ. Ntá tsi ntoꞌó ne, ¿xóo ntu ñaꞌa nto? —kaꞌan. ");
INSERT INTO mizNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kidáā ne, kūdiin ñá ñuꞌu é ña váꞌā san nima í, ntāva ntodó ña ñatīí, ña uꞌxe ñáꞌa san. Kūvi dé e ña váꞌā sán ni ñā niꞌi kuíꞌī ñá ne, koó dā ntántɨɨ́ ña kíi ña nú viꞌi ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa, ña ntoo ñuú Efesú, tē ña Israeé, tē ña é ña te ña Israeé ne, kūtuni ñá nte o kúvi ne, dōo uꞌví ña ne, dōo váꞌa kaꞌan ñá iña Tóꞌo ko Jēsuu. ");
INSERT INTO mizNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ñá te da dīi ña kuíntiꞌxe i xee ña é nānaꞌma ña kuétsi ña mēꞌñú ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ñá te da dīi ñá tātán xee ñá dɨ. Xee níꞌi ña tutu é ntánakoto ntodó ña. Kidáā né, ēꞌmi ña tutú san méꞌñū ñaꞌa san. Kántēꞌví tutú san nté kaa xee táꞌan xáꞌvi ī ne, ínūu áꞌvi te ūvi díko uꞌxi miil diuꞌun kuíꞌxin. ");
INSERT INTO mizNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Dukuān ne, ñá te da dīi ñaꞌa kuintíꞌxe ña túꞌun Xuva kō, tsi kútuni ña tsí Xuva kō né, dōó iō ntíi tūꞌún ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Rkontûví dá ita ntíꞌxin sáꞌā ne, kakaꞌán Pablu é kɨ̄ꞌɨn ña, kikoto niꞌní ña ña ntoo ñuú Macedonia ni ñá ntoo ñuú Acaya nté o de ña ne, dá kɨ̄ꞌɨn ña un tsi nte ñuú Jerusaleen. —Tē ntáka ú ñuú Jerusaleén ne, kuétsī é kɨ̄ꞌɨ́n u ñuú Roma —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kidáā ne, táxnūu ña uvi ñaꞌa, ña é xntii ñā, ñá nani Timōteu ni Rastú ne, odo nuū ñá, kueꞌen ña ñuú Macedonia. Nɨɨ dukuān kúkuií ka Pablu itúvi ña ñuú Asia. ");
INSERT INTO mizNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ntuvi tsikán ne, kuvi duꞌxen kuēnta iña túꞌūn vaꞌá iña Jésuu. ");
INSERT INTO mizNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tsí uun ñatīi, ñá nani Dēmetriú ne, kāá kuīꞌxín kade tsiñu niꞌi ña, kantaváꞌa naa ña xúkun kuetsī vata ntáa xúkūn santu é nanī Diana. Tɨtɨ́n ñaꞌa ntáde tsiñu niꞌi ñā ne, kuéꞌē diuꞌun ntániꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetriú ne, kāna ña ña ntáde tsiñu niꞌi ña ni un ntɨꞌɨ ñāꞌa, ña ntáde tsiñu sáꞌa. Nātaká nuu ña ne, kakaꞌan ñá ni ñā: —Dɨvi ntō ne, ini ntó tsi dóo vaꞌá ntuvi iña ko é ntáde o tsiñu sāꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ntá tsi é kūtuni nto tsí kaika uun ñatīi, ñá nanī Pablu, kakáꞌan ntódo ña, kakaꞌan ñá tsi santu é ntaváꞌa nāá ñaꞌa ne, ñá tē nuu é ntaa ī é Xuva kō. Ne, kūvi idé ña e dóo tɨtɨ́n ñaꞌa kuíntiꞌxe ña é kākaꞌan ña. Ñá te da mii tsi ñuū ko, tsí da kanɨɨ ñūú Asia. ");
INSERT INTO mizNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Sáꞌā né, dōo xii kaa; tē ñaꞌá ne, ntɨꞌɨ tsiñu kō. Ñá te da mii tsi tsiñu kō dɨ́, tsí dɨꞌɨ kō Dianá dɨ ne, ñá kuiko ñuꞌū ká ñaꞌa xúkun ñā. Tsí dɨꞌɨ kō né, dōó kaꞌnu ñaꞌa ña. Da kanɨɨ ñūú Asiá ne, da kanɨɨ ñūxivi ntaíko ñuꞌu ñāꞌa san ña —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Dā téku ñaꞌa san é kākaꞌan ñá ne, dōo kúdiin ña. Un tsi vāntiñɨ ña ntákachuꞌu ña, ntákaꞌan ña: —¡Dōo kaꞌnu dɨ́ꞌɨ kō Diana, tóꞌo ñūú Efesu! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kidáā né, tɨ̄ɨn ña uvi ñaꞌa, ña ñuú Macedonia, ña íka dadɨɨ nī Pablu, ñá nanī Gayu ni Áristarcú ne, ntaíñuꞌu kaduun ña ña ini ntoꞌo mí nátaká nuu ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablú ne, ntio ña é kɨ̄ꞌvi ña dɨ é kāꞌan ñá ni ñāꞌa san, ntá tsi ña ni ntío ña kuíntiꞌxe i san é kɨ̄ꞌvi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Uun ñaꞌa ña váꞌa tiin niꞌi ña, ña odo nūu ñuú Asia dɨ́ ne, táxnūu ña tutú ntaꞌa Pablu é ña ku kɨ́ꞌvi ña íkān. ");
INSERT INTO mizNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Un tsi vāntiñɨ ñáꞌa san, ntákachuꞌu ña ne, é tūku e túku nuu i ntákaꞌan ña. Dōo tɨtɨ́n ña ne, ntē ñá ini ña nee tsíñu nátaká nuu ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kidáā ne, ña Israeé san tsíꞌi ntido ñá uun ñaꞌa, ñá nani Alējandru, é na kāꞌan ntódo ña ni ñāꞌa san. Alejandrú san ne, kade ña ntaꞌa ña é diin diin tsi na kuntōo ñaꞌa san, tsí ntio ña nadaꞌan ñā ña Israeé san. ");
INSERT INTO mizNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ntá tsi dā kútuni ñáꞌa san tsí Alejandrú ne, ña Israee ñá ne, koó da vāntiñɨ ña ntákachuꞌu ña. Úvi ūra ntákachuꞌu ña, ntákaꞌan ña: —¡Dōo kaꞌnu dɨ́ꞌɨ kō Diana, tóꞌo ñūú Efesu! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kidáā né, kūvi dé strivanu, intóo kadin ñáꞌa san. Ne, kakaꞌan ñá ni ñā: —Ō ñá ñuú Efesu, kini nto é kāꞌán ntɨ ni ntō. Ini ntɨɨ́ ntɨ̄ɨ́ ñaꞌa tsí ñuu ko Éfesú ne, kaduku ntée ñuu ko é viī ó kuenta xúkun īña dɨꞌɨ kó Diana, ña é dóo kaꞌnu, é viī ó kuenta sántu ña é kōꞌxó e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Xōxó kuvi kaꞌan i te ñáꞌa. Dukuān né, diin diin tsi kuntōo nto. Diꞌna kada kuení nto nté koo vií nto. ");
INSERT INTO mizNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tsí ñatīí sāꞌa, ña é vēxníꞌi ntō ne, ñá ni kāꞌan kíni ña iña dɨꞌɨ ko. ");
INSERT INTO mizNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tē nee iña é tsīꞌi kuétsi Demetriu ni ña ntáde tsiñu niꞌi ña ne, kantií viꞌi meꞌñú kān; ntoo ña ntáxntēkú kūꞌve. Na kɨ̄ꞌɨ́n ka ña, kikaꞌan ñá nī ña tsiñu i te nēé nuu i tsiꞌi kuétsi taꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tē neé ka tuku nuu i é ntio nto kaꞌan ntó ne, kuvi kaꞌan nto dá kōo junta. ");
INSERT INTO mizNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tsi dóo īó kuenta te kūdiin ña tsiñu kaꞌnu i ñuú Roma é kuān ó de ō. Tsí duꞌxen iña ña tsiñu kaꞌnu i ntáde ō vevii, kuiní ña. ¿Neé ntu kaꞌan o ni ña te tsixeꞌe ña kō nté kui vāntiñɨ ntu o ntóo ō iꞌa? —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Dā kúvi kaꞌan ñá ne, nantáka ña ñāꞌa san, kunúꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Dā intóo kadin ñaꞌa sán e dóo itsuꞌun ña ne, Pablú ne, kāna ña ña kuíntiꞌxe i san é kuēꞌe ña ña itsi. Kidáā né, nānume taꞌan ña ne, dā ntíi ña, kueꞌen ña ñuú Macedonia. ");
INSERT INTO mizNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Dā míꞌī ká ñuu mí kaika ña ne, dōo kakaꞌan ñá ni ñāꞌa san vata koo é kīí nima ña. Kidáā ne, xée ña ñūú Grecia. ");
INSERT INTO mizNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Uni xóō katúvi ña ikān. Kidáā né, ntīo ña é kuꞌun ña tun ntōó kaꞌnu é nūꞌu ñá ñuú Síria dá kútuni ña tsí ntántukū nuu iní ña Israeé san. Dukuān ne, ntíko koō ñá itsi ñuú Macedonia, kunúꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tɨtɨ́n kudii ñaꞌa kueꞌen niꞌi ñá dɨ. Kueꞌen níꞌi ña Sopater, iꞌxá Piru, ña ñuú Berea; ni Arīstarcu ni Ségundu, ña ñuú Tesalonica; nī Gáyu, ña ñuú Derbe; ni Timōteu; ni Tīquicu ni Trófimu, ña ñuú Asia. ");
INSERT INTO mizNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Odo nuū ñá, kueꞌen ña ñuú Troa ne, ikān intétu ña ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ntɨꞌɨ́ ne, dā inú kava viko é ntaéꞌxi ña tañúꞌu dukuān ne, ntīi ntɨ́ ñuú Filipu. Ñúꞌū ntɨ́ tun ntōo, kuéꞌen ntɨ. Dā kúvi ūꞌun ntúvi ne, xeé ntɨ, nāniꞌi taꞌan ntɨ́ ña ñuú Troa. Ikān ne, uun vité intóo ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kuaá sabadu nátaká nuu ntɨɨ́ ntɨ̄ɨ́ ntɨ é nakatsin dava ntɨ́ tañúꞌu, vatā o dé kûꞌvé Tóꞌo ko Jesūcristu. Pablú ne, kuan tsī ó kakaꞌan ntódo ká ña dá ku davā ñúu, tsí ntaka ñá teváa san. ");
INSERT INTO mizNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kuéꞌe ñūꞌu kaíꞌxi iní viꞌi nínu kān mí nátaká nuu ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Uun natīi, ná nani Eūticu ne, ntéku na ventana kan. Dā dóo naꞌa kakaꞌán Pablú ne, xée nā maꞌna ne, uun ito tsi kídi na. Kidáā ne, kóꞌxo na un tsi nte ñúꞌu kān. Tsí viꞌi sán ne, úni ōdo ntiꞌi taꞌan. Dā ínakiꞌí ña na ne, e xíꞌi nā. ");
INSERT INTO mizNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pablú ne, nūu ña mí tuví na ne, katavi ntódo ña na, nánume ña na ne, kakaꞌan ñá ni ñāꞌa san: —Ñá ku dē kuení nto. ¡Kantíto na! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kidáā ne, kúxēe xtúku Pablu má viꞌī nínu kān ne, dā nákatsin dava ña tañúꞌū san, da eꞌxí ña ne, dá kakāꞌan ntódo xtuku ña un tsi da nté tuvi. Da kidáā ntáka ña, kunúꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ñaꞌa sán ne, kunuꞌu níꞌi ña natīí san, ntūkaꞌnu iní ña tsí kantíto na. ");
INSERT INTO mizNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ntɨꞌɨ́ ne, odo nūú ntɨ, nakuꞌún ntɨ tun ntōo, ñéꞌē ntɨ́ ñuú Asuun. Pablú ne, dɨ̄ꞌɨ́n ña kaika ña. Nakunúu ña tun ntōó san té xee ña, káꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nāniꞌi taꞌán ntɨ ña ñuú Asuún ne, ikān nakúꞌun dadɨɨ ntɨ́ ni ña tun ntōó san, dá kuēꞌén ntɨ ni ña ñūú Mitilene. ");
INSERT INTO mizNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tévāá san ntíi ntɨ́, kueꞌén ntɨ, ído ntūú ntɨ ñuú Quio. Tévāá xtuku ne, xéē ntɨ́ ñuú Samu. Íntōo daꞌna ntɨ́ ñuú Trogiliu ne, dá tevāa xeé ntɨ ñuú Miletu. ");
INSERT INTO mizNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ntio Pablu é kuīdo ntúu ña ñuú Efesu váta koo é ña kukuíi ña ñuu Ásiā, tsí ntio ña é kantɨ́ꞌɨ xee ña ñuú Jerusaleen, váta koo é kutuvī ñá te kūvi viko é kākaꞌan ñá Israee é viko é kanakuéꞌe ña sintiáꞌvi iña é tāta. ");
INSERT INTO mizNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Dā xeé ntɨ ñuú Miletú ne, taxnūú Pablu túꞌūn é kīꞌxi ntɨɨ́ ntɨ̄ɨ́ ñata, ña odo nūú iña ña kuíntiꞌxe i ñuú Efesu. ");
INSERT INTO mizNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Dā xee ñátā sán ne, kakaꞌán Pablu ni ña: —Īni nto nté ō dé u é tuví u ni ntō nté ntūvi dá xee ú ñuu Ásia ā. ");
INSERT INTO mizNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Tsí kuenta iña Xúva kō kade tsiñu u. Ñá te kāꞌnu ncho vií u. Īni nto nté kaa ntute nūú ko étɨ ú kuenta iña ntó ne, nté ō ntóꞌo kó ntaꞌa ña Israeé san dā ntúku nuu iní ña nté koo vií ña nī ko. ");
INSERT INTO mizNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ñá te ni dē víni u é kāꞌán u ni ntō nee ntɨ́ꞌɨ ntɨꞌɨ é kāntio é kūtuni nto. Tsí kanakuāꞌá u nto méꞌñū ñaꞌa ne, nú viꞌi mii nto nakuāꞌá u nto dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Dadɨɨ tsi kakaꞌán u ni ñāꞌa, te ñá Israee, te ña é ña te ña Israee ñá ne, na xtuvī mii ña é kīni kaá ne, na viī ña é vāꞌa. Kakaꞌán u ni ña te kuīntiꞌxe ña Tóꞌo ko Jesūcristu. ");
INSERT INTO mizNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Viꞌa ve ne, da miī é kɨ̄ꞌɨ́n u ñuú Jerusaleen, kakáꞌan Espíritū Sántu nī ko. Ntē ñá īní u nté koo kuvi ko íkan tē xee u. ");
INSERT INTO mizNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Dɨvi tsī é dā míꞌī ká ñuú kañeꞌé u ne, kataꞌxi Espíritū Sántū é kūtuní ko tsí da miī é ntōꞌo kó, da miī é xnuu kutu ñā kó viꞌi utun te xeé u ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ntá tsi ñā té ini kuān té kuví u, te kāda ntáa ú tsiñu e táꞌxi Tóꞌo ko Jēsuu é vīí u: dɨvi tsi tsīñu ko é kākaꞌan ntódo u túꞌūn vaꞌá iña Xuva ko e dóo kakuinima ñá kō. ");
INSERT INTO mizNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ʼDɨvi ntō ne, é kākaꞌan ntódo ú ni nto īña Xuva ko, nté koo kuntoo o ntāꞌa ñá ne, iní u tsí ña kiní ka nto kó ñuxiví a. ");
INSERT INTO mizNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Dukuān ne, kini váꞌa nto é kākaꞌán u ni ntō, tsí nté uun nto ña kuvi káꞌan nto te ña ni de ntáa ú iña nto. ");
INSERT INTO mizNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tsí ña te ni dé vini kueꞌén u é kāꞌán u ni ntō é un ntɨꞌɨ̄ é kākaꞌan Xúva kō. ");
INSERT INTO mizNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kuenta tsí vií ntō kúñu nto ni ūn ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i san é táꞌxi Espíritū Sántū é dɨvi nto kodo nuū ntó iña ña. Vií nto vatā ó de paxtu é kade ña kuenta á leꞌntu ña. Kuenta tsí vií nto un ntɨɨ́ ntɨ̄ɨ́ ña kuíntiꞌxe i Tóꞌo kō san, tsí nɨñɨ míi ña étɨ ña kuenta iña ña dá xiꞌi ña. ");
INSERT INTO mizNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Iní u tsí rkontuvi dá ntaka ú ne, kiꞌxi ñaꞌa é nakutsuꞌun ña nto, vata tsī ó de xteé, kɨtɨ diin, é ña te kántuntāꞌví ini tɨ a leꞌntú san. ");
INSERT INTO mizNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Iō ñáꞌa iña ntó dɨ ne, kuān koo vií ña dɨ. Tsí kaꞌan ñá dovete é ntio ña é kintīkɨn ña kuíntiꞌxe i sán ña. ");
INSERT INTO mizNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kuenta tsí vií nto é ña kani ntaꞌví ña nto. Ñá ku kūnáa inī ntó tsí xuꞌú ne, uni kuía katúvi u, nakuáꞌa ú nto nte ntúvi nte níñu ne, ñá te un siin ntute nūú ko étɨ ú kuenta iña ntó xe un xé un ntō. ");
INSERT INTO mizNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ʼViꞌa ve né, kuntoo niꞌi nto Xuva kō. Kuntoo niꞌi nto tūꞌun vaꞌá san é kākaꞌan ñá dɨ. Tsi dóo kaidiáꞌvi túꞌun Xuva kō é kūtúꞌve nto, vata koo é nīꞌi nto é vāꞌa é kāduku ntée iꞌxá Xuva kō, vata koo é dadɨɨ kuve taꞌan nto ni ūn ntɨɨ́ ntɨ̄ɨ́ ña é nakaxnúu Xuva kō é kūvi iꞌxá mii ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Xuꞌú ne, ñá tē ni ntío ko nee iña, ō diuꞌún ne, ō doo váꞌa iña ñaꞌa. ");
INSERT INTO mizNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ini nto tsí miī ú dé tsiñu ú vata koo é nīꞌí ko nee iña é ntio kó, nee iña é ntio ña ntɨɨ niꞌī ú dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Dukuan tsī o dé u vata koo é nañēꞌé u nto nté koo vií nto. Tsí te kuan kōo ne, kuvi xntii o taꞌan kō nee é kataan núu ña. Tsí nakaꞌan ko tūꞌun é kākaꞌan Tóꞌo ko Jēsuú ne: “Dií dií ka dîní ña kaxeꞌé san é ña kanakíꞌi san”, kaꞌan ña. —Sáꞌā kaꞌán Pablu ni ña. ");
INSERT INTO mizNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Dā kúvi kaꞌan ñá ne, ínchɨtɨ ñā, kakaꞌan ntâꞌví ña ni ñatā san. ");
INSERT INTO mizNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ēku ntɨɨ́ ntɨɨ̄ ña. Kidáā né, nanume taꞌan ña nī Pablu, eꞌxí ña xuꞌu ña. ");
INSERT INTO mizNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Dōo uꞌvi kúvi ña tsí kakaꞌan ña tsí ña kiní ka ña ña. Kidáā ne, kueꞌen níꞌi ñā Pablu un tsi nte mi túvi tun ntōó san. ");
INSERT INTO mizNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Dā tsóo mii tāꞌan ntɨ́ ni ñatā, ña ñuú Efesú san ne, nakúꞌūn ntɨ́ iní tun ntōó san é kɨ̄ꞌɨ́n ntɨ. Kueꞌen ntáa ntɨ́ ñuu é nanī Koo. Uun ká tuku ntuvi xeé ntɨ ñuú Ródā ne, da xeé ntɨ ñuú Patara. ");
INSERT INTO mizNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ikān nániꞌí ntɨ uun tun ntōo é kɨ̄ꞌɨn ñuú Fenicia. Ñúꞌū ntɨ́ tun ntōó san, kueꞌén ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dā kíi ditó ntɨ ñuú Chipré ne, ido ntūú ntɨ diñɨ datsin ntɨ́ ne, dá kuēꞌén ka ntɨ́ ñuú Siria. Dā xeé ntɨ ñuú Tirú ne, ikān itúvi daꞌna tun ntōó san vata koo é natavā ña xídō san. ");
INSERT INTO mizNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ikān nániꞌí ntɨ ña kuíntiꞌxe i Jesuú ne, dadɨɨ intóo ntɨ́ ni ña ūun vite. Un ntɨɨ́ ntɨɨ̄ ñá ntákaꞌan ñá nī Pablu: —Ñá ku ñeꞌē ntó ñuú Jerusaleen —kaꞌan ña. Tsi é xeꞌe Espíritū Sántū san kútuni ña te dóo ntoꞌo Pablu te kɨ́ꞌɨ̄n ñá ikān. ");
INSERT INTO mizNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ntá tsi da xee táꞌan ntuvi ne, ntīi ntɨ́, kueꞌén ntɨ. Íntēka itsi un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa sán ntɨ ni ñadɨꞌɨ̄ ñá ni iꞌxā ñá, íntēka ña ntɨ́ nte díñɨ ñuú kān. Dā xeé ntɨ ni ña diñɨ ntute ñuꞌu kān ne, ntánchɨtɨ̄ ntɨ́, ntákaꞌan ntâꞌví ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kidáā né, nānume taꞌan ntɨ́ ni ñā. Dā nákuꞌún ntɨ iní tun ntōó san ne, kúnūꞌú ñaꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ntīi ntɨ́ ñuú Tiru, kuéꞌen ntɨ́ ñuú Tolemaida. Ikān ixkoto níꞌni ntɨ ení kō, ña kuíntiꞌxe i san. Uun ñúū kantóō ntɨ́ ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Dá tevāá ne, ntīi ntɨ́, kueꞌén ntɨ ñuú Cesarea. Ikān ñeꞌé ntɨ nú viꞌi Fēlipe, ña kakaꞌan ntódo túꞌūn vaꞌá san. Dɨvi ñā é nakaxnúu ña da nakaxnúu ña uꞌxe ñáꞌa, ña é xntiī san. ");
INSERT INTO mizNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Īó kɨmi dióko ñā, taꞌnú ña ni tántaꞌa, taꞌnu ntákaꞌan náa Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Dā kú tɨtɨ́n ntuvi ntoo ntɨ́ ikān ne, xée uun ñatīi, ña véꞌxi ñuú Judea, ñá nani Āgabu. Ña kaꞌán naa Xuva ko ñá dɨ, tsí kaxéꞌe Xuva ko kūtuni ña nté koo kuvi. ");
INSERT INTO mizNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Dā xee ñá mí ntoo ntɨ́ ne, kīꞌi ña nguenuu íꞌxi Pablu, kiꞌní nuu ña ntaꞌa ña ni dɨ̄ꞌɨ́n ña, kakaꞌan ña: —Kakaꞌán Espíritū Sántū tsí kuān koo kuvi tóꞌō nguenuu sáꞌa, tsí ña Israee, ñá ntoo ñuú Jerusaleén ne, kuān koo kiꞌní ña ña ne, dá ntāda ña ña kuenta ntáꞌa ñaꞌa, ña é ña te ña Israee —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Dā téku ntɨ é kākaꞌan ñá ne, un ntɨɨ́ ntɨ̄ɨ́ ntɨ ni ña ntoo ikān ne, ntákaꞌán ntɨ nī Pablu: —Vií nto da xeꞌe, ñá ku ñeꞌē ntó ñuú Jerusaleen —kaꞌán ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ntá tsi Pablú ne, kakaꞌan ña: —¿Nté kui dóo ntántɨꞌɨ iní nto kuenta iñá ko? Tsí dóo uꞌvi kúvi ko é kuān ó ntákaꞌan nto. Vevií ntɨká nimá ko. Xuꞌú ne, é iō tuꞌvé ko. Ñā té ini, kuān té koo kútu u, kuān té kuví u ñuú Jerusaleen kuénta iña Tóꞌo ko Jēsuu —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Dā ña ni kuvi vií ntɨ ni ñā ne, ñá ni kāꞌán ka ntɨ. Mii tsī é kākaꞌán ntɨ: —Nā kuvi nee iña é ntio Xuva ko —kaꞌán ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kidáā ne, natsoo váꞌa ntɨ́ iñá ntɨ, dá kūntáa ntɨ́ nī Pablu ñuú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Dadɨɨ kueꞌén ntɨ nī ña kuíntiꞌxe i, ña véꞌxi ñuú Cesarea. Kueꞌen níꞌi ñā ntɨ́ nú viꞌī mí kuntōo ntɨ́, viꞌi ñatīi, ña véꞌxi ñuú Chipre, ñá nani Nāsuun. Dɨvi ñā ne, nté ntūvi diꞌna kuíntiꞌxe ña Jesuu. ");
INSERT INTO mizNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Un ntɨɨ́ ntɨ̄ɨ́ taꞌan ko, ña kuíntiꞌxe i sán ne, dōo diní ña dá xeé ntɨ ñuú Jerusaleen. Dōo váꞌā o dé ña nī ntɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Dā kúvi uvi ntúvi ntoo ntɨ́ ne, ñéꞌē ntɨ́ nī Pablu, ixkoto níꞌni ntɨ́ Jacóbo. Ikān ntoo ntɨɨ́ ntɨ̄ɨ́ ñata, ña odo nūú san dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablú ne, kakaꞌan ñá ni ñā ntiusi ne, dá kantaa ña ni ñā é un ntɨꞌɨ̄ é xeꞌé Xuva kō e kúvi idé ña méꞌñū ña é ña te ña Israee. ");
INSERT INTO mizNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Dā téku ña é kākaꞌán Pablú ne, dōo ntákaku niꞌi ña Xuva kō. Kidáā ne, kakaꞌan ñá nī Pablu: —Ini ntó, eni, tsí ña te nté kaa miil taꞌan ko ña Israee é kuíntiꞌxe ña Tóꞌo ko Jesūcristu. Un ntɨɨ́ ntɨɨ̄ ñá ne, ntákaꞌan ñá tsi da miī é kāda ntaa o lei é xtûví Muisee. ");
INSERT INTO mizNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tsí e téku ña tsí dɨvi ntō né, kanakuāꞌa nto ña Israee é ntoo xio ñuu é ña kantío é kāda ntaa ña lei é xtûví Muisee, é ña kantío é kāꞌnté ña kúñū é ixi iꞌxá ña ne, é ña kantío é viī ñá vata xkoó ini o dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Viꞌa ve ne, ¿nté ntu koo vii o ve? Tsí da miī é nataká nuu ña tē kútuni ñá tsi é xeé nto. ");
INSERT INTO mizNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Sáꞌa viī nto: Iꞌá ntoo kɨmi ñátīi, ña é xeꞌé xuꞌu i Xuva kō tsí iō é viī ña. ");
INSERT INTO mizNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kuēꞌen níꞌi nto ñátīí saꞌa é dadɨɨ ntuntoo nto ni ña ntaꞌa Xuva kō. Xntii nto ña nēe kataan núu ña dɨ, vata koo é kūvi kuntɨɨ́ dɨkɨ ña. Dukuān koo kutuni ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san tsí ñá tē nuu é ntaā i é ntákaꞌan ñá iña nto. ");
INSERT INTO mizNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kutuni ñá tsí dɨvi ntō ne, kade ntaa ntɨ́ꞌɨ nto leí san. Ña kuíntiꞌxe i san, ña é ña te ña Israeé ne, e táxnūu ntɨ́ tutú ntaꞌa ña te mii tsi sāꞌá é ña kuvi vií ña: ñá kāꞌxi ñá kúñū é xntáa ntēé ñaꞌa san nú nāa ña; ñá kāꞌxi ñá nɨñɨ kɨ́tɨ; ñá kāꞌxi ñá kúñu kɨ̄tɨ é kuéꞌne; ñá viī ña é kini kaa ni ñadɨ̄ꞌɨ táꞌan ña. Sáꞌa tsi kakāꞌán ntɨ ni ñā é ña vii ña —kaꞌan ñátā san ní Pablu. ");
INSERT INTO mizNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kidáā ne, kueꞌen níꞌi Pablu kɨmi ñáꞌa, ñatīí san. Utén san ne, dadɨɨ ntúntoo ña ni ña ntāꞌa Xúva kō ne, da kɨ́ꞌvi ña ini ukún kaꞌnu é kuēꞌé ña kutuni dutú san nté kaa ntuvi da nte te kuvi ntúntoo ña, tsí da kidáa kāꞌmi ña kɨtɨ nú nāa kan é kuēꞌé ña doméni iña Xuva ko. ");
INSERT INTO mizNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ntá tsi dá dokó sa xee táꞌan uꞌxe ntúvi ne, ña Israee, ña véꞌxi ñuu Ásiā né, dā íni ña tuví Pablu má ūkún kān ne, nákutsuꞌun ña ūn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san. Tɨ̄ɨn ña Pablú ne, ");
INSERT INTO mizNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","koó da vāntiñɨ ña, ntákaꞌan ña: —¡Ō né, ña Israee, xntii ntō ntɨ! Ña sāꞌá ne, dɨvi ñā é kaika ña dá kanɨɨ ñūxivi, kanakuáꞌa ña ñaꞌa é kāꞌan ntée ña ko, xoꞌo ña Israee. Kakaꞌan ntée ña lei Muíseé ne, ñá te kaiko ñuꞌu ña xūkún saꞌa. Vevií ne, ntɨɨ niꞌi ñā ña é ña te ña Israee, kakɨ́ꞌvi niꞌi ña ña má ūkún a ne, ntáde dentu ña xūkún saꞌa e dóo kuíko —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Sáꞌā ntákaꞌan ña, tsí nté vīꞌi íni ña é ntɨɨ niꞌī Pablu úun ñatīi, ña véꞌxi ñuú Efesu, ñá nani Trōfimú ne, te kɨ̄ꞌví niꞌi ña ña ini ukún kaꞌnu kān, kuiní ña. ");
INSERT INTO mizNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dōo ntaítsuꞌun ñaꞌa san da kanɨ́ɨ ñūú san. Un ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ne, koó dā ntáxkainu ña, véꞌxi ña. Tɨ̄ɨn ña Pablu, ntáñūꞌu ña ña, nátavā ñá ña má ūkún kan ne, dā nákadɨ kutu ña xiꞌi úkūn san. ");
INSERT INTO mizNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Vevií tsi kaꞌní ña Pablu dá xee túꞌun ntāꞌa tóꞌō sntadun ñuú Roma tsí dóo ntaítsuꞌun ñaꞌa san da kanɨɨ ñūú Jerusaleen. ");
INSERT INTO mizNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ura tsí i kána ña sntadún san ni ña odo nūú iña ñá ne, koó dā ntáxkainu ña, xee ña mi nátaká nuu ñaꞌa san. Dā íni ñaꞌa san tsí e xee tóꞌō sntadún san ni ūn ntɨɨ́ ntɨ̄ɨ́ sntadún san ne, tēé daꞌna ña e ntaéꞌní ña Pablu. ");
INSERT INTO mizNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kidáā ne, xée ētsin tóꞌō sntadún san, tɨ́ɨn ña Pablú ne, kakaꞌan ña é kōo kútu ña ūvi kádena. Da kidáā tsíxeꞌe ña xōo ñáꞌa ña ne, nté ō dé ña. ");
INSERT INTO mizNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ntá tsi koó da vāntiñɨ ñáꞌa san, ntákachuꞌu ña ne, é tūku e túku nuu i ntákaꞌan ña. Ntē ña ni kuvi teku tóꞌō sntadún san é ntákaꞌan ña. Dukuān ne, kakaꞌan ña é kɨ̄ꞌɨn niꞌi ñá Pablu mí ntoo sntadún sān. ");
INSERT INTO mizNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Dā xée ētsin ña nú rkueɨ kán ne, da miī é intéku doko sntadún san Pablu, tsí dóo ntákudiin ñáꞌa san. ");
INSERT INTO mizNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ntántīkɨn ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san ña, ntákachuꞌu ña: —¡Kaꞌní nto ña! —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Dá dā vé kukɨ́ꞌvi ña ni ñā iní i mí ntoo sntadún san ne, kakaꞌán Pablu ni tóꞌō sntadún san: —Iō nuu i é kāꞌán u ni ntō —kaꞌan ña. —¿Vá kakāꞌan ntún túꞌūn griegu? —kaꞌan tóꞌō sntadún san—. ");
INSERT INTO mizNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Ñā ntu te dɨ́vīn é ña ñuú Egítō, ña e dóo nakutsúꞌun ñaꞌa sán kidáā é viī ñá duꞌxen iña ña tsiñu kaꞌnu i, ña é nteka kɨmi míil ña dɨkɨ dúꞌxen san má kūꞌu kan? —kaꞌan ñá, tsixeꞌe ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","—¡Ñāꞌá ni san! —kaꞌán Pablu—. Xuꞌú ne, ña Israeé u. Vēꞌxí u ñuú Tarsu, ñuu é kāduku ntée ñuú Cilicia, é ña te ñuú luꞌnti. Vií nto da xeꞌe, taꞌxi kudii nto itsi é kāꞌán u ni ñāꞌa san —kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","—Káꞌan kān ní —kaꞌan tóꞌō sntadún san. Kidáā ne, ntitsí Pablu nú rkueɨ kan, kade ña ntáꞌa ña tē diin diin tsi kuntōo kadin ñaꞌa san. Dā intóo kadin ña ne, eni ntuꞌū Pablu kakáꞌan ñá ni ñā túꞌūn hebreu: ");
INSERT INTO mizNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Un ntɨꞌɨ kuēꞌen dúꞌva nto, te kuetsi te naꞌnu ntó, kini nto é kākaꞌán u ni ntō é kanadaꞌān ú kúñū ko —kaꞌán Pablu. ");
INSERT INTO mizNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Dā téku ñaꞌa san tsí túꞌūn hebreu kakáꞌan ña ne, diin diin tsi kantóo ña. Pablú ne, kakaꞌan ña: ");
INSERT INTO mizNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Xuꞌú ne, ña Israeé u. Tsí kaku ú ñuú Tarsu é kāduku ntée ñuú Cilicia, ntá tsi éꞌnu ú ñuú Jerusaleen. Iꞌa nakuaꞌá u ntaꞌa mastru Gámaliee. Kūtúꞌvē kó un ntɨꞌɨ vatā ó kakaꞌan lei e xtûví ñata kō, ña intóo diꞌna. Xuꞌú ne, nɨɨ̄ kueꞌén ini ko dé ntaa u é un ntɨꞌɨ̄ é kākaꞌan Xúva kō, vata tsī ó ntáde ntɨɨ́ ntɨɨ̄ ntó vevii. ");
INSERT INTO mizNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ixntíkɨ̄n ú ña kuíntiꞌxe i Jesuú san ne, ntuku kuīꞌí u ña, e ntío ko é kūví ntɨꞌɨ ña. Ixtɨ́ɨ̄n ú ña, te tīí, te ñadɨꞌɨ̄ ñá, e tsúꞌun kutū ú ña viꞌi utun kān. ");
INSERT INTO mizNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Iní dutu ñá odo nūú ni ūn ntɨɨ́ ntɨ̄ɨ́ ña tsiñu i san tsí nuu é ntaā i é kākaꞌán u ni ntō. Tsí dɨvi ñā táꞌxi ña tutu é kɨ̄ꞌɨn níꞌi ú iña ñá Israee, ñá ntoo ñuú Damascu. Ikān ñeꞌé u ínantukū ú ña kuíntiꞌxe i san e kɨꞌɨn niꞌi u ña ñuú Jerusaleen váta koo é niꞌi ña é ntōꞌo ña. ");
INSERT INTO mizNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ʼDá nūu ú itsi kān é dokó sa xee ú ñuú Damascú ne, dā káꞌñu ntuvi ne, dā nêní ko xiꞌí nuu ñuꞌu ntíkō diñɨ ko, ñuꞌu é dóo kaxiꞌí nuu é vēꞌxí e dukún kān. ");
INSERT INTO mizNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Uun ito tsi nantúvē ú ñuꞌu kān. Kidáā téku kó tatsin é kākaꞌan ní ko: “Saúlū, Saúlū, ¿nté kui kantukun kuiꞌīn ntún ko?”, kaꞌan tátsín san. ");
INSERT INTO mizNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Kidáā ne, tsixeꞌē u: “¿Xoó ñaꞌa ntu nto, Tóꞌō?”, kaꞌán u. Dɨvi ñā ne, kakaꞌan ña: “Xuꞌú ne, Jesuu, ñá ñuú Nazareé u. Dɨvī u é kantukun kuīꞌín ko”, kaꞌan ñá nī ko. ");
INSERT INTO mizNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ña ntɨɨ niꞌī ú ne, dā kúduꞌva ña dá ini ña tsí kaxiꞌí nuu, ntá tsi ña ni tekú ña tatsin é kākaꞌan ní ko. ");
INSERT INTO mizNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Xuꞌú ne, kakaꞌán u: “¿Neé ntu ntio nto é vīí u ve, Tóꞌō ko?”, kaꞌán u. Kidáa kākaꞌan Tóꞌo ko nī kó: “Nakuntítsin ve. Kueꞌēn kán ñuú Damascu. Ikan tāꞌxi ñá kutuni o un ntɨꞌɨ̄ nté ō kukûꞌve tsiñu é vīin”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Xuꞌú ne, kukuāá u da xiꞌí nuu ñuꞌú san. Dukuān né, ña ntɨɨ niꞌī ú ne, ntáñūꞌu ña ko, ixntéka ña kó ñuú Damascu. ");
INSERT INTO mizNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ʼIkān tuví uun ñatīi, ñá nani Anānia, ñá e dóo kade ntaa lei Muísee. Un ntɨɨ́ ntɨ̄ɨ́ ña Israee, ñá ntoo ñuú Damascú ne, dōo váꞌa kaꞌan ñá iña ña. ");
INSERT INTO mizNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Xée ña, ntītsí ña diñɨ kó ne, kakaꞌan ñá nī kó: “Ō éni Saúlu, na nāxiꞌí nuu nto”, kaꞌan ña. Ura tsí i naxiꞌí nuú ko ne, kakuvi kainí u ña. ");
INSERT INTO mizNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Kidáā ne, kakaꞌan ñá nī kó: “Xuva kō, ña é inúu ini ñata kō ne, nté ntūvi diꞌna é nakaxnúu ña nto é kūtuni nto nee iña é ntio ña, é kinī ntó Iꞌxá ña, ña e dóo vaꞌa, é tekū ntó tatsin ñá dɨ. ");
INSERT INTO mizNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tsí ntaa nto ni ñaꞌa un ntɨꞌɨ̄ é īni nto; káꞌan ntɨꞌɨ nto ni ñā é un ntɨꞌɨ̄ e téku nto é kākaꞌan Xúva ko ni ntō. ");
INSERT INTO mizNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Viꞌa ve ne, ñá ku kukuīí ka nto. Kueꞌēn ntó, kukutsí ntute nto. Nakate nto kuétsi ntō, kaku niꞌi nto dɨ̄ví Jesuu”, kaꞌan ñá nī ko. ");
INSERT INTO mizNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ʼDā ntíko kōó u, naxee ú Jerusaleén a ne, ñéꞌē ú, ixkaꞌan ntâꞌví u má ūkún kaꞌnu kān. Kidáā ne, vata kúvi é nakuení u, ");
INSERT INTO mizNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","īní u Tóꞌo ko Jēsuu, kakaꞌan ñá nī kó: “Kantɨ́ꞌɨ̄ sá kuēꞌen. Ntakan ñuú Jerusaleén ve, tsí ña ntoo iꞌa ne, ñá kuintīꞌxe ña é kākaꞌan kuenta iñá ko”, kaꞌan ña. ");
INSERT INTO mizNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ne, kakaꞌán u ni ñā: “Xuvā kó, é īni ntɨɨ́ ntɨ̄ɨ́ ñaꞌa san nté o dé u é ñēꞌé u má ūkún kān, e íxtɨɨn ú ña kuíntiꞌxe i nto. Tsi dóo nakáꞌxi vaꞌá u ña ne, da tsúꞌun kutū ú ña viꞌi utun kān. ");
INSERT INTO mizNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ntitsi dîtó u da xeꞌé xuu ñaꞌa san Ésteba, ñá kakaꞌan ntódo túꞌun ntō. Tsi kúdadɨɨ ko é kaꞌnī ñá ña ne, xuꞌu íto ú doo ña ntáxeꞌé xuu ña”, kaꞌán u ni ñā. ");
INSERT INTO mizNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ntá tsi kakaꞌan xtúku Tóꞌo ko nī ko: “Kueꞌēn kán ni, tsí taxnūu ú o e dóo ika kɨ̄ꞌɨn. Tsí kɨꞌɨn mí ntoo ñaꞌa, ña é ña te ña Israee”, kaꞌan ñá nī ko —kaꞌán Pablu. ");
INSERT INTO mizNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ntaíni ñaꞌa san é kākaꞌán Pablu da nté kakaꞌan ña tsí kɨꞌɨn ña mí ntoo ñaꞌa, ña é ña te ña Israee. Kidáā né, eni ntuꞌu ñā ntákachuꞌu ña: —¡Kaꞌní nto ña! ¡Ña kúvī ká kutuvī ñá ñuxiví a! —kaꞌan ña. ");
INSERT INTO mizNT_