﻿USE sofia;
DROP TABLE IF EXISTS sofia.mitNT_vpl;
CREATE TABLE mitNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mitNT_vpl WRITE;
INSERT INTO mitNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ñà‑yòhó nduú tutu nacání sàhà ana nduú xìì Jesucristu. Iin yohòtéhè‑yá nduú David, te iin yohòtéhè David mà nduú Abraham. ");
INSERT INTO mitNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Te Abraham yucán, nì ìa iin dèhe‑ne nani Isaac. Te Isaac mà, nì ìa stná iin dèhe‑ne nani Jacob. Te Jacob mà, nì ìa stná iin dèhe‑ne nani Judá, xi stná cuàhà ñani‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Te Judá mà, nì cacu ùì dèhe‑ne, iin‑ne nani Fares, te inga‑nè nani Zara. Te Tamar nani dihi Zara mà. Daaní, Fares ma, nì ìa stná iin dèhe‑ne nani Esrom. Te Esrom mà, nì ìa stná iin dèhe‑ne nani Aram. ");
INSERT INTO mitNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Te Aram mà, nì ìa stná iin dèhe‑ne nani Aminadab. Te Aminadab mà, nì ìa stná iin dèhe‑ne nani Naasón. Te Naasón mà, nì ìa stná iin dèhe‑ne nani Salmón. ");
INSERT INTO mitNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Te Salmón mà, nì ìa stná iin dèhe‑ne nani Booz. Te Rahab nani dihi Booz. Daaní, nì nandàhà Booz mà xì Rut, te iin dèhe‑ne nani Obed. Daaní, Obed mà, nì ìa stná iin dèhe‑ne nani Isaí. ");
INSERT INTO mitNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Te Isaí mà, nì ìa stná iin dèhe‑ne nì sanduu rey David. Daaní, David mà, nì ìa stná iin dèhe‑ne nani Salomón. Te dihi Salomón mà nduú nècuàchì ñaha nì sanduu ñahàdìhí Urías antes. ");
INSERT INTO mitNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Daaní, nì ìa stná iin dèhe Salomón mà nani Roboam. Te Roboam mà, nì ìa stná iin dèhe‑ne nani Abías. Te Abías mà, nì ìa stna iin dèhe‑ne nani Asa. ");
INSERT INTO mitNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Te Asa mà, nì ìa stná iin dèhe‑ne nani Josafat. Te Josafat mà, nì ìa stná iin dèhe‑ne nani Joram. Te Joram mà, nì ìa stná iin dèhe‑ne nani Uzías. ");
INSERT INTO mitNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Te Uzías mà, nì ìa stná iin dèhe‑ne nani Jotam. Te Jotam mà, nì ìa stná iin dèhe‑ne nani Acaz. Te Acaz mà, nì ìa stná iin dèhe‑ne nani Ezequías. ");
INSERT INTO mitNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Te Ezequías mà, nì ìa stná iin dèhe‑ne nani Manasés. Te Manasés mà, nì ìa stná iin dèhe‑ne nani Amón. Te Amón mà, nì ìa stná iin dèhe‑ne nani Josías. ");
INSERT INTO mitNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Te Josías mà, nì ìa stná iin dèhe‑ne nani Jeconías, xi stná dava ga ñani‑nè. Te divi tiempu yucán nì catavà tè‑ñuu Babilonia nèhivì raza‑ndà cuàhàn‑nè presu ndè ñuù‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Daaní, na ndoó‑né ñuu Babilonia yucán, dandu nì ìa stná iin dèhe Jeconías mà nani Salatiel. Te Salatiel mà, nì ìa stná iin dèhe‑ne nani Zorobabel. ");
INSERT INTO mitNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Te Zorobabel mà, nì ìa stná iin dèhe‑ne nani Abiud. Te Abiud mà, nì ìa stná iin dèhe‑ne nani Eliaquim. Te Eliaquim mà, nì ìa stná iin dèhe‑ne nani Azor. ");
INSERT INTO mitNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Te Azor mà, nì ìa stná iin dèhe‑ne nani Sadoc. Te Sadoc mà, nì ìa stná iin dèhe‑ne nani Aquim. Te Aquim mà, nì ìa stná iin dèhe‑ne nani Eliud. ");
INSERT INTO mitNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Te Eliud mà, nì ìa stná iin dèhe‑ne nani Eleazar. Te Eleazar mà, nì ìa stná iin dèhe‑ne nani Matán. Te Matán mà, nì ìa stna iin dèhe‑ne nani Jacob. ");
INSERT INTO mitNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Te Jacob mà, nì ìa stná iin dèhe‑ne nani José. Te divi José mà nduú iì María dihi Jesucristu. ");
INSERT INTO mitNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ñàyùcàndùá, nsidaa xìì‑yá yucán, ùxìn cùmì ní sanduu‑ne dècuèndè tiempu xi Abraham xì dècuèndè tiempu xi David. Daaní, ndoó ùxìn cùmì gá‑nè dècuèndè tiempu xi David xì dècuèndè quìvì cuàhàn‑nè presu ñuu Babilonia. Daaní, después ndoó ùxìn cùmì gá‑nè dècuèndè tiempu xi Cristu. ");
INSERT INTO mitNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cunaha‑nsiá, dohó nì cuu na ní tùinuù Jesucristu. Sànì ndiadi tnùhu nandàhà dihi‑yá María xì José. Doco tàñáha ga coo‑ne xì nècuàchìmà, te nì sàcùñuhu méè xi‑ne nì quida Espíritu Ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ñàyùcàndùá, nì nacani ini José ñà‑chicá vàha tàhndè tnùhu xi‑ne cahan‑né, doco mà cáchí vate‑néà, vàchi nècuàchì vàha nduú‑né, te có‑cùní‑nè cuitnùhu nèhivì María. ");
INSERT INTO mitNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Doco na nacání íì ini‑nè quida‑ne ducán, nì sàní‑nè nì ndecunu iin ángel xi Stoho‑ndà Señor nùù‑né, te dohó nì cachi ángel mà xì‑né: ―Cunini‑ní, José, descendencia xi David; màsà yúhî‑nî nandàhà‑ní xì María. Vàtùni cunduu‑ne ñahàdìhí‑ní, vàchi méè xi‑ne ñuhu‑ma, méè sàhà Espíritu Ìì xí Dios nduú‑vé. ");
INSERT INTO mitNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Te icúmí‑vê tùinuù‑vé, cunduu‑ve iin méè tiàa, te Jesús cunani‑vé, vàchi icúmí‑yâ dacácu‑ya nèhivì xí‑yá nùù cuàchi‑ne ―nì cachi ángel. ");
INSERT INTO mitNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pues divi ducán nì cuu nsidaájàn sàhà‑ñá nì cùú ndisa ñà‑ndùá nì cachitnùhu Stoho‑ndà Señor antes na ní càhàn iin ana cáhàn cuenta xi‑ya, te nì cachi‑nè: ");
INSERT INTO mitNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Cunaha‑nsiá, icúmí coo méè xi iin ñahà chìì nduú señorita; te nú sànì tùinuù‑vé, dandu cunani‑vé Emanuel, vàchi cuní cachà mà ñà‑sànì quesaa Dios cutnahá‑yá xì‑ndà nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Daaní, nì nsicuìhnú ini José, te nacua nì cachi ángel mà xì‑né, divi ducán nì quida‑ne, nì nandàhà‑né xì María ñà‑cunduu nècuàchìmà ñahàdìhí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Doco cónì ía‑ne xì nècuàchìmà dècuèndè nì tùinuù méè mà. Te Jesús nì sàcùnani‑vé. ");
INSERT INTO mitNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tiempu xi rey Herodes nì sandua na ní tùinuù Jesús ñuu tii Belén iá ladu Judea. Dandu nì casaà nècuàchì nchichí ñuu Jerusalén; ladu ndé caná orá nì quixi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Te nì ndàcàtnùhù‑né: ―¿Índù iá méè nì tùinuù‑xí, divi méè cunduu rey xi nècuàchì Judea? Vàchi ndé caná orá sànì xini‑nsì sìtnúù cachítnùhu sàhà‑yá; te vichi vàxi‑nsi cahvi‑nsíyà ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dandu rey Herodes, na ní xinitnùhu‑tè ñà‑ndùá ndácàtnùhù nècuàchìmà, nì ndulocó‑te, mii‑té xi nsidaa gá stná nèhivì ñuu Jerusalén. ");
INSERT INTO mitNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ñàyùcàndùá, nì cana‑tè dùtù chicá xí‑idònùù, xì stná nècuàchì dacuahá ley ìì, te nì xìcàn tnùhù‑té nùù‑né índù ñuu cuàhàn tùinuù Cristu. ");
INSERT INTO mitNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Te nì naxiconihí‑né nùù‑té, cachí‑nè: ―Divi ñuu tii Belén iá ladu Judea. Vàchi ducán nì tiaa iin nècuàchì nì càhàn cuenta xi Dios sànaha ndé cachí‑yà: ");
INSERT INTO mitNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Cunaha mii‑nsiá nècuàchì ñuu Belén iá ladu Judea: màdì ñuu chicá có‑ndiàá nduú ndé ndoó‑nsiá; còó, divi ñà‑chicá ndiaá nduá nùù nsidaa ñuu nahnú ladu xi‑nsia, vàchi divi ñuu mii‑nsiá icúmí tùinuù mii‑yá ana cusahnú, te icúmí‑yâ cunuù‑yá nèhivì xí, divi nèhivì raza‑nsià Israel. ");
INSERT INTO mitNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Daaní, nì cana dèhé Herodes nècuàchì nchichí mà, te nì ndàcàtnùhù váha stná‑te nùù‑né índù tiempu meru nì tùi sìtnúù mà. ");
INSERT INTO mitNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dandu nì techuún‑tené cùhùn‑nè ñuu Belén, cachí‑te xi‑né: ―Cuahán‑nsià ñuu mà, te ndàcàtnùhù váha‑nsia nansa ndisa iá sàhà méè mà, dandu nacachitnùhu‑nsia xìˊ, vàchi yùhù, cuní stnáì cùhìn cahvi stnáì‑vè ―nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Daaní, na ní nsihi nì sàcùnaha nècuàchì nchichí mà nùù‑té ñà‑jaàn, dandu nì quihin‑ne ichì cuàhàn‑nè. Te cunaha‑nsiá, yucán nì natùi tu sìtnúù nì xini‑nè antes ladu xínu orá. Te nì sàcòdònùù‑sí nùù‑né nì sàà‑si nì ndòo‑sì dìquì‑xí nacua ndé iá méè mà. ");
INSERT INTO mitNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ñàyùcàndùá, yáha ga nì cudiì ini‑nè na ní xini tu‑ne sìtnúù mà. ");
INSERT INTO mitNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dandu nì caquìhvi‑ne vehe, te nì xini‑nè méè mà xì dihi‑vé nani María. Te nì tutuyuhu‑né ñuhù nùù‑vé, te nì cahvi‑névè. Dandu nì nacuna‑ne ñà‑ñùhú ñà‑cuìcà‑né, te nì dàcútâhvì‑néyà, divi oro xì inciensu xì tàtnà nani mirra. ");
INSERT INTO mitNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Doco después nì sàní‑nè nì cachitnùhu Dios xì‑né ñà‑ìá peligru: màsà náyàha‑ne ndé iá rey Herodes. Ñàyùcàndùá, inga ichì nì naquihin‑ne mànuhù‑né ñuu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dandu, na sámànuhù nècuàchì nchichí, nì sàní stná José, nì xini‑nè iin ángel nì quixi nùù Stoho‑ndà Señor. Te dohó nì cachi ángel mà: ―Ndacuiìn‑ní, tnii‑ní méè, te cundaca‑nívè xì mamá xi‑ve cuahán‑nsià ñuu Egipto cunudèhé‑nsià. Te divi ñuu mà icúmí‑nsiâ cundoo‑nsia ndè cachi sàì cachitnùhi xì‑nsiá. Vàchi icúmí Herodes nanducu‑tévê ñà‑cahnì‑tévê ―nì cachi ángel mà. ");
INSERT INTO mitNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ñàyùcàndùá, mate ñuú nduá, doco nì ndacuiin José nì saca‑ne méè mà xì dihi‑vé, te nì quihin‑ne ichì cuàhàn‑nè ñuu Egipto. ");
INSERT INTO mitNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Te ñuu mà nì sandoo‑ne dècuèndè nì xìhì Herodes. Te divi ducán nì cuu sàhà‑ñá ni cuú ndísá palabra yohó nì cachitnùhu Stoho‑ndà Señor antes na ní càhàn iin ana cáhàn cuenta xi‑ya: “Dècuèndè ñuu Egipto nì cani Dèhemanìˊ ñà‑ndixi‑ya”. ");
INSERT INTO mitNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Daaní, na ní xini Herodes cónì ndúlócô nècuàchì nchichí sàhà ñà‑ndùá nì cachì‑te, dandu yáha ga nì xìdà inì‑te. Ñàyùcàndùá, nì techuún‑te soldadu nì sàhàn nì casahnì xì nsidaa méè tiàa ndoó ñuu Belén xì inicutu stná ladu yucán, nsidaa luchi cuati xicá ùì cuìà cuàhàn tìxi‑xi, nì casahnì‑tévê, vàchi ñà‑jaàn nduú tiempu nì cachi nècuàchì nchichí na ní ndàcàtnùhù Herodes nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ñàyùcàndùá, quìvì jaàn nì cuu ndisa ñà‑ndùá nì cachitnùhu Jeremías sànaha na ní càhàn‑nè cuenta xi Dios, te dohó nì cachi‑nè: ");
INSERT INTO mitNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Tiacú tnaná cuáhà‑né ladu ñuu Ramá. Sacú nècuàchì ñahà, te cána‑ne, divi nècuàchì descendencia xi Raquel. Sàhà méè xi‑ne sacú‑né; nì mà cùì cahnde ini‑nè, vàchi còò cá‑vè. ");
INSERT INTO mitNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Daaní, José, iá va‑ne ñuu Egipto. Dandu nì sàà quìvì nì xìhì rey Herodes. Te nì sàní tu José inga xichi, nì xini‑nè iín iin ángel nì quixi nùù Stoho‑ndà Señor, ");
INSERT INTO mitNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","te cachí ángel mà xì‑né: ―Ndacuiìn‑ní, cuaca‑ní méè xì dihi‑vé, te naxicocuíìn‑nsià ñuu Israel, vàchi sànì xìhì nèhivì cuní cahnì xì‑vé. ");
INSERT INTO mitNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ñàyùcàndùá, nì ndacuiin José, nì saca‑nevè xì dihi‑vé mànuhù tú‑né ñuu Israel. ");
INSERT INTO mitNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Doco nì xinitnùhu‑ne sàdàndàcú dèhe Herodes mà nani Arquelao, cusáhnû‑te lugar xi nsì‑yua‑té ladu Judea. Ñàyùcàndùá, nì yùhí‑nè nùhù‑nè ladu mà. Daaní, inga xichi nì sàní‑nè, nì cachitnùhu Dios ñà‑ndisa iá peligru. Ñàyùcàndùá, nì yàha‑ne chicá nùù‑xí dècuèndè ladu Galilea, ");
INSERT INTO mitNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","nì sàà‑nè iin ñuu tii nani Nazaret, te yucán nì candòo‑ne. Pues, divi ducán nì cuu sàhà ñà‑nì cùú ndisa palabra nì cacachitnùhu profeta xi Dios sànaha ñà‑divi ñuu Nazaret cunduu ñuu‑yà, cachi nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Daaní, después nì quixi Juan Bautista yucù iá ladu Judea. Te nì quesaha‑né cáhàn‑nè sàhù yucán, ");
INSERT INTO mitNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","cachí‑nè xì nèhivì ñà‑nì náxícócuîìn ini‑nè sàhà cuàchi‑ne, vàchi sà‑ìtúú cuni‑nè cusahnú mii‑yá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Pues divi Juan mà nduú ana nì cachitnùhu Isaías sàhà‑xí na ní càhàn‑nè cuenta xi Dios, te nì tiaa‑ne dohó: Tiacú cáhàn fuerte ana cáhàn yucù, te cachí‑nè xì‑ndà ñà‑nsidandoo‑nda (anima‑ndà) na ian nduvíi ichì ndé yàha Stoho‑ndà Señor, te ichì ndáà cundua. (Ducán nì cachi Isaías sànaha.) ");
INSERT INTO mitNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Te Juan mà, dòò idì sìcamellu nì sandixi‑ne, te iìn quísi nì cuyucun siuhma tìxi‑ne. Te sìca xì ndudi ñùñù yucù nduá nìsa itiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Daaní, cuàhà nèhivì ñuu Jerusalén xì cuàhà stná nèhivì ladu Judea, xì stná nèhivì ndoó yatni yùte Jordán, nsidaa‑né nì casaà‑nè nùù Juan yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Te nì cuhiì‑né nì quida nècuàchìmà ini yùte mà na ní dàtúi‑ne cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Doco nì xini Juan ñà‑vàxi stná cuàhà nècuàchì fariseu xì cuàhà stná nècuàchì saduceu, cuní‑nè cuhiì stná‑nè. Ñàyùcàndùá nì cachi‑nè xì nècuàchìmà: ―Mii‑nsiá, na quidá còò, ducán quidá‑nsiá, vàxi‑nsia yohó xinúdèhé‑nsià nùù castigu icúmí quixi. ¿Ana divi nì cachi xì‑nsiá ñà‑quida‑nsia ducán? ");
INSERT INTO mitNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cunaha‑nsiá, xiñuhu quida ndisa‑nsia cumplir nacua ndiá ìcà quida‑nda na naxícócuîìn ndisa ini‑ndà sàhà cuàchi‑nda. ");
INSERT INTO mitNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ni màsà cáhàn cuadú‑nsià cachi‑nsià inì‑ni mii‑nsiá ñà‑divi Abraham nduú yohòtéhè stná‑nsià, te ñàyùcàndùá còò ni‑iñàha cuu xi‑nsiá. Vàchi cunaha‑nsiá, dècuèndè stná yùù ndoó yohó, vàtùni nanduu stná nahi descendencia xi Abraham, nú cuní Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Te vichi sà‑ìá cuàhàn (cachi‑yà índù nèhivì nìhì‑xì castigu), na ian cuàhàn‑ndà nacàxin‑nda yutnù có‑càná fruta, te nihi‑nda hacha cahnde‑ndànú coco‑nù. Pues ducán icúmí cuu stná xì nèhivì có‑quìdá víi. ");
INSERT INTO mitNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Vàchi yùhù, tècuìí quidá íìˊ mii‑nsiá na cuú‑nsiá arrepentir; doco nchícùn gà vàxi ana chicá cahnú poder‑xi nùù yùhù: te ni có‑nâtùi (cundui nahi mozo xi‑ya) ñà‑chindeí quee ndìsàn‑yá. Doco mii‑yá, tìxi Espíritu Ìì xí Dios icúmí‑yâ quida iì‑yá anima‑nsià. Te na quidá ñuhu, ducán icúmí‑yâ quida stná‑yà xì‑nsiá (dandáñúhú stnâ‑yà ñà‑có‑ndiàá). ");
INSERT INTO mitNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Te vichi sà‑ìá cuàhàn‑yà quida‑ya na ian quida‑nda xi trigu, dandiachi‑ndañá xì yutnù chipála dècuèndè ndiachi nsihí trigu ndoó nùù ñuhù, dandu nùnìá, chivàha‑ndañá, doco mihì‑ñá, coca. Te divi ducán icúmí‑yâ quida stná‑yà (xì nèhivì ñuhìví: nèhivì xí mii‑yá, càcu‑ne; doco nèhivì dava ga), nicanicuahàn icúmí‑nê coco‑ne ―nì cachi Juan. ");
INSERT INTO mitNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Daaní, nì quee Jesús ladu Galilea, cuàhàn‑yà yùte Jordán ndé iá Juan, vàchi cuní‑yà quida iì nècuàchìmà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Doco nècuàchìmà, có‑cùní‑nè, vàchi cachí‑nè xì‑yá: ―Yùhù xiñuhí cuhiìˊ quida mii‑ní, màdìá mii‑ní quixi‑ní nùù yùhù, (te cuhiì‑ní). ");
INSERT INTO mitNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Dandu nì cachi‑yà xì‑né: ―Ducanicoó vichi, vàchi ducán xiñuhu quida‑nda sàhà‑ñá quida ndisa‑nda nsidaa ñà‑ndùá ndiá ìcà‑ndà. Dandu nì candisá Juan, te nì quida iì‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Daaní, nì nsihi nì cuhiì‑yá, te nì quee‑ya nùù tècuìí, dandu nì nuna ansivi, te nì xini‑yà mànuu Espíritu Ìì xí Dios vàxi‑ya na iin sì‑lomá, meru dìquì Jesús mànuu‑ya vàxi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dandu nì tiacu nì càhàn iin ana cáhàn ansivi, cachí‑yà: ―Dèhemanìˊ nduú ana yohó, te cudíì cuáhà inì sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Daaní, nihí Espíritu Ìì Jesús nì sàhàn ñà‑coo‑ya yucù dàná, vàchi yucán cuàhàn ñà‑malu quida‑sì lucha dacà‑síyâ. Ñàyùcàndùá, nì quihin‑ya ichì cuàhàn‑yà, ");
INSERT INTO mitNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","te yucán iá‑yà ùì dico quìvì ndui te ñuú; te iníhíì‑yá, iá dòcó‑yà. Ñàyùcàndùá, cuàhà doco xíhì‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dandu nì tnàtuu ñà‑malu, vàchi cuní‑si dacà‑síyâ, te nì cachì‑si xi‑yá: ―Nú ndisa Dèhemanì Dios nduu‑ní, dandu cachì‑ní xì yùù jaàn ñà‑nì nándúá pan cuxi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Doco nì cachi‑yà xì‑sí: ―Còó, vàchi dohó cachí nùù tutu ìì: “Màdì cuisì pan cutiacu nèhivì; còó, vàchi xiñuhu cucumi stná‑nè nsidaa palabra ìì cachí Dios”. ");
INSERT INTO mitNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Daaní, nì saca‑sìyá cuàhàn‑si xi‑yá ñuu ìì Jerusalén, te nì chicoo‑sìyá ndè dìnì veheñùhu cahnú, ");
INSERT INTO mitNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","te nì cachì‑si xi‑yá: ―Nú ndisa Dèhemanì Dios nduu‑ní, dandu dandiachi‑ní mii‑ní, vàchi ducán cachí nùù tutu ìì: Icúmí Dios dandacú‑yá nùù ángel xi‑ya ñà‑cundiaa‑nè mii‑ní. Te cachí stná tutu mà: Icúmí ángel natnii ndahà‑né mii‑ní ñà‑màsà máquìhi sàhà‑ní ni‑iin yùù. ");
INSERT INTO mitNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dandu nì cachi Jesús xì‑sí: ―Cachí stná tutu ìì: “Màsà quídá cánûú‑ndá ñà‑có‑cùní Stoho‑ndà Señor”. ");
INSERT INTO mitNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Daaní, nì saca‑sìyá cuàhàn‑si xi‑yá dìnì iin yucù ducún sàstnùhù, te nì dàcùní‑siyá nsidanicuú ñuu iá ñuhìví xì nsidaa ñà‑vico iá yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Dandu nì cachì‑si xi‑yá: ―Yùhù dacútâhvìˊ mii‑ní nsidaa ñuu jaàn nú ni mácuììn sìsì‑ní nùí, te cahvi‑ní yùhù. ");
INSERT INTO mitNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Doco nì cachi‑yà xì‑sí: ―Cuahán‑nî, Satanás, vàchi dohó cachí stná nùù tutu ìì: “Cuisì mii Stoho‑ndà Dios ndiá ìcà‑ndà cahvi‑nda, te cunucuachi‑nda nùù‑xí”. ");
INSERT INTO mitNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dandu nì nacoo‑sìyá cuàhàn‑si, te nì caquesaa ángel nì nacuàhandee ini xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Daaní, na ní xinitnùhu Jesús ndiadí Juan (Bautista) vehecàa, dandu mànuhù‑yá ñuu‑yà Nazaret iá ladu Galilea. ");
INSERT INTO mitNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Doco cónì cuèé‑yà yucán. Còó, nì quihin‑ya ichì cuàhàn‑yà ñuu Capernaum iá yuhù mar ladu ndé cachí xì‑né ladu Zabulón xì Neftalí. ");
INSERT INTO mitNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yucán cuáhàn‑yà coo‑ya sàhà ñá‑nì cùú ndisa palabra nì cachitnùhu Isaías sànaha na ní càhàn‑nè cuenta xi Dios, cachí‑nè: ");
INSERT INTO mitNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ladu Zabulón xì ladu Neftalí ndé yáha ichì yatni mar, yucán sànì dàtnúù fuerte Dios ini anima nèhivì. Stná inga ladu yùte Jordán, xì inicutu stná ladu Galilea ndé ndoó nèhivì có‑ìnáhá xí‑yâ, ");
INSERT INTO mitNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","pues yucán sànì dàtnúù ndiaha stná‑yà anima‑nè; vàchi nèhivì nsidaa lugar mà, nìsa xìca‑ne ichì ñáa, te cuàhàn‑nè ndañuhu dahuun‑ne nì cùí, doco vichi sànì dàtnúù‑yà sàxìnítnùní‑nè na ian nì natùi nuù‑né, nì cachi Isaías. ");
INSERT INTO mitNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dandu divi tiempu mà nì quesaha Jesús cáhàn‑yà sàhù xì nèhivì, cachí‑yà: ―Naxicocuíìn inì‑nsia sàhà cuàchi‑nsia, vàchi sà‑ìtúú tiempu cuni‑nsià cusahnú mii‑yá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Xicá Jesús yuhù mar iá Galilea, te nì xini‑yà ùì ñàní nani Simón Pedro xì Andrés, dacaná‑né ñunù xí‑né mahì tècuìí, vàchi nècuàchì tavá siaca nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Te nì cachi‑yà xì‑né: ―Cunchicùn‑nsià yùhù, vàchi mà cúndúú gá‑nsià nècuàchì tavá xi siaca. Còó, vàchi icúmî dacuahí mii‑nsiá ñà‑cunduu‑nsia nècuàchì tavá xi nèhivì (ichì malu). ");
INSERT INTO mitNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dandu nècuàchìmà, vichi vichi nì nacoo‑ne ñunù xí‑né, te cuàhàn‑nè nchícùn‑nèyà. ");
INSERT INTO mitNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Daaní, nì sàà‑yà chicá nùù‑xí, te nì xini‑yà inga ùì ñàní nani Jacobo xì Juan; dèhe iin tiàa nani Zebedeo xínduu‑ne, te ndoó‑né nùù lancha xi‑ne, cutnáhâ‑né xì yua‑né nácàhmá‑nè ñunù xí‑né. Te nì cana stná‑yà ndúì‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Te hora mà nì nacoo‑ne yua‑né nùù lancha mà, te nì tenchicùn‑nèyà cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Daaní, nì xìcanuu Jesús inii ladu Galilea, te nì chinaha‑yà nèhivì ini iin iin veheñùhu, nì càhàn‑yà xì‑né ñà‑ndùú razón ndiaha sàhà ñuhìví ìì xí Yua‑nda Dios. Te nì dàndúvàha stná‑yà nèhivì ndohó nsidanuu clase cuèhè. ");
INSERT INTO mitNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ñàyùcàndùá, ndè inii ladu Siria nì xìtià fama‑yà. Sàhà ñà‑jaàn cuàhà gá nècuàchì cuhí ndacá nèhivì nì quixi nùù‑yá, xínduu‑ne nèhivì ndohó quidá iin cuèhè, ò iin dolor, te xínduu stná‑nè ana ñuhú ñà‑malu anima‑xi, xì stná nèhivì xíhì ìhí, ò néhivì sànì nduyutnu. Doco nsidaa‑né, nì dàndúvàha‑yanè. ");
INSERT INTO mitNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ñàyùcàndùá, yáha ga cuàhà nèhivì nì tenchicùn xì‑yá, xínduu‑ne nèhivì nì quixi ladu Decápolis, xì stná ñuu Jerusalén, xì stná ladu Judea, xì stná inga ladu yùte Jordán. ");
INSERT INTO mitNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dandu nì xini Jesús ndoó cuàhà gá nèhivì. Ñàyùcàndùá, nì nana‑ya iin yucù, te nì sàcòo‑ya yucán. Dandu nì tnàtuu nsidaa nècuàchì dacuahá‑yá nùù‑yá, ");
INSERT INTO mitNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","te nì quesaha‑yá chináhá‑yànè; te dohó nì cachi‑yà xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Nansicáhán nècuàchì ndahvi inì‑xi, vàchi sànì nìhìtáhvì‑né ñuhìví ìì xí mii‑yá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Nansicáhán nècuàchì ndoó tnùnsí ini vichi, vàchi contentu icúmí‑nê nàcùndoo‑ne después. ");
INSERT INTO mitNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Nansicáhán nècuàchì nihnú mánì inì‑xi, vàchi ñuhìví ndutahvì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Nansicáhán nècuàchì yáha ga cuní quida viì, vàchi icúmí Dios chindee‑yánè ñà‑quida viì ndisa‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Nansicáhán nècuàchì tùha cundehè ndàhví xì ñanìtnaha‑xi, vàchi icúmí Dios cundehè ndàhví stná‑yà mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Nansicáhán nècuàchì iá ndoo anima‑xi, vàchi icúmí‑nê cuni‑nè nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Nansicáhán nècuàchì nachíndóó víi xi ñanìtnaha‑xi, vàchi icúmí‑nê cunduu ndisa‑ne dèhe Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Nansicáhán nècuàchì nú icúmí‑nê ndoho‑ne sàhà iin chuun viì nì quida‑ne, vàchi sànì nìhìtáhvì‑né ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Nansicáhán stná mii‑nsiá na cánàhá nèhivì xì‑nsiá sàhí, te ò quidá quini‑ne xì‑nsiá, te ò dacuidádiquí stná‑nè mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Vàchi quìvì quida‑ne ducán, dandu ni cúdíì inì‑nsia, te cundoo‑nsia contentu, vàchi iin ñà‑vàha cahnú cucumi‑nsiá ndè ansivi. Vàchi ducán nìsa quida quini stná nèhivì sànaha xi nècuàchì nìsa cahàn cuenta xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Mii‑nsiá, nahi chuun quidá ììn, ducán quidá stná‑nsià ñuhìví yohó. Doco nú sànì ndañuhu ñà‑ádì xán, dandu mà cúí nduhadì gá‑ñà. Vàchi còò cá chuan, ñàyùcàndùá saté uun nèhivì‑ñá, te sánihni‑neà. ");
INSERT INTO mitNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Na quidá stná orá datnúù, ducán quidá stná mii‑nsiá ñuhìví yohó. Te ducán nduú stná‑nsià na iin ñuu tuí dìnì iin yucù, vàchi mà cúí coo dèháˋ nùù nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Stná iin lámpara, có‑nàcuícun‑ndañá ñà‑coo dèháˋ tìxi iin ìcà; còó. Sácùnùú ducún‑ñà sàhà‑ñá cutnuà, te cutùi nùù nsidaa nèhivì quíhvi vehe. ");
INSERT INTO mitNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ducán xiñuhu quida stná mii‑nsiá: quida‑nsia obra vàha sàhà‑ñá cundehè nèhivì, dandu naquimanì‑né Yuandiáhá‑nsiâ iá ansivi, vàchi na ian datnúù‑nsià nùù nècuàchìmà nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Màsà cúcáhán‑nsiâ vàxi dacúxíóé ley nì sàha Moisés. Mà dácûxíóé ley mà, ni mà dácûxíó stnáì palabra nì cachi profeta nì sacahàn cuenta xi Dios. Còó, yùhù vàxi sàhà ñà‑nì cùú ndisa nsidaa ñà‑ndùá cachí palabra mà. ");
INSERT INTO mitNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Te ñà‑ndáà nduá cachíˋ xì‑nsiá yohó, mate nsihi ansivi xi ñuhìví, doco mà nunca ndañuhu ni‑iin palabra xi ley mà, te ni‑iin xaan tii xán dècuèndè cuu ndisa nsidaa ñà‑ndùá cacháˋ. ");
INSERT INTO mitNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ñàyùcàndùá, nú cô‑quìdá iin tiàa cumplir mate iin ley chicá tii nduá, te ducán chináhá‑nè nèhivì, pues divi tiàa‑ma cunduu ana chicá có‑ndiàá na sáà quìvì cusahnú mii‑yá iá ansivi. Doco nú ni quidá ndisa‑ne cumplir ñà‑ndùá cachí ley xi‑ya, te ducán chináhá‑nè ñanìtnaha‑ne, dandu cunduu‑ne ana chicá ndiaá na sáà quìvì cusahnú‑yá ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Vàchi yùhù cachíˋ xì‑nsiá, chicá viì xiñuhu quida‑nsia nùù nècuàchì ley xi veheñùhu, xì nùù stná nècuàchì fariseu, vàchi nú coó, mà nunca sàà‑nsià cuni‑nsià ñuhìví ìì xí mii‑yá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Mii‑nsiá, sànì inini‑nsia palabra nì cachi nècuàchì sànaha ñà‑màsà cáhni stnaha‑nda; doco te nú ni quida‑nda ducán, dandu icúmí ndundaà sàhámà. ");
INSERT INTO mitNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Doco yùhù cachíˋ, mate cuísi ni cuídà ini‑nsià sàhà ñanìtnaha‑nsia, doco icúmí ndundaà sàhà stnámà. Te nú ni cachí‑nsià xì ñanìtnaha‑nsia neciu‑nè, dandu icúmí ndundaà stná sàhájàn nùù juez chicá cusáhnû; doco nú ni cachí‑nsià xì ñanìtnaha‑nsia tonto‑nè, dandu cuidadu cundoo‑nsia, vàchi dècuèndè ñuhu andea ndiatu‑xi‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ni cachí‑ndà cuàhàn iin nèhivì veheñùhu, nihí‑né promesa nacuàhatahvì‑né Dios lugar ndé cahvi nèhivì mii‑yá. Doco te nú sànì sàà‑nè yucán, te nì nsinuu ini‑nè iá cuàchi‑ne nùù ñanìtnaha‑ne, ");
INSERT INTO mitNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","dandu (màsà cuáha‑ne) promesa mà; yucan ni ndóa, te ni cúhùn‑nè nùù ñanìtnaha‑nemà, te cuicahnú stnahá ini‑nè sàhà‑né. Cuisì nú ducán, dandu vàtùni naxicocuíìn‑nè veheñùhu mà ñà‑cuàha‑ne promesa mà. ");
INSERT INTO mitNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Nú sànì sanicuàchi iin tiàa sàhà iin‑nsia, te ndacá‑te mii‑nsiá cuàhàn nùù tè‑nìhí chuun, dandu chicá vàha nacòovàha yachì‑nsià xì‑té na cuáhàn‑nsià ichì, còtó sàà‑te xi‑nsiá nùù juez, te dayáha juez mà‑nsiá ndahà comandante ñà‑cundiadi‑nsià vehecàa. ");
INSERT INTO mitNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Vàchi ñà‑ndáà nduá cachíˋ xì‑nsiá yohó, nú ducan ni cuu‑xi‑nsiá, dandu mà quéé‑nsiá dècuèndè nú sànì dànáà nsìhí‑nsiá nsidaa ñà‑ndùá iníhícá‑nsiâ. ");
INSERT INTO mitNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Sà‑ìnáhá‑nsiâ nansa nì cachi nècuàchì sànaha ñà‑màsà cáhàn‑ndà xí inga ana có‑ndùú nècuàchì vehe‑nda, nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Doco yùhù, (más gà) cachíˋ xì‑nsiá vichi, vàchi nú cuisì indéhe iin tiàa iin nècuàchì ñahà, te xího‑téné, dandu dava‑ni queámà na ian sànì quida‑tè cuàchi xi nècuàchìmà, vàchi iá cuàchi ma anima‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ñàyùcàndùá, nú nduchìnúù‑nsiá, cuníà quida‑nsia iin cuàchi, dandu chicá vàha tavà‑nsiáñà, dacaná‑nsiáñà, vàchi chicá vàha ni ndáñúhú iyuhu iin xaan xí‑nsiá, te màdìá sàà inii cuerpu xi‑nsia andea. ");
INSERT INTO mitNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te ni cachí‑ndà nú ndahàcuàhá‑nsià cuníà quida‑nsia iin cuàchi, dandu chicá vàha ni táhndèà dacaná‑nsiáñà, vàchi chicá vàha ni ndáñúhú iyuhu iin xaan xí‑nsiá, te màdìá sàà inii iquìcúñú‑nsià andea. ");
INSERT INTO mitNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Nìsa cachi stná nèhivì (sànaha): “Nú cuàhàn‑nsià cate stnàhá‑nsiá, dandu xiñuhu cuyucun iin tutu índù itúámà”, nìsa cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Doco yùhù cachíˋ, nú ni caté iin tiàa ñahàdìhí‑te, te màdìá nì cáhàn‑ña xi inga tiàa nduá, dandu cuàchi cundua nú ni nándàhà tú‑ña, vàchi (còá dìsáhà‑xí) cate nècuàchì primeru mà‑ñá. Te iin nècuàchì nandàhà xì ñahà nì xìtià mà, divi‑ni nsidá cuàchi stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Sà‑ìnáhá stnâ‑nsià nì cachi nècuàchì sànaha: “Nú ni chínáhá‑ndá Stoho‑ndà Dios ñà‑quida‑nda iñàha, dandu fuerza icúmí‑ndá quida ndisa‑ndañá cumplir”. ");
INSERT INTO mitNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Doco yùhù cachíˋ, màsà nunca chinaha‑nsiá Dios sàhà iin chuun: ni màsà ndácùcahan‑nsiá ansivi, te chinaha‑nsiá mii‑yá sàhà ni‑iñàha, vàchi meru lugar ndé dandacú‑yá nduá (te solo mii‑yá dandacú‑yá nùá). ");
INSERT INTO mitNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni màsà ndácùcahan stná‑nsià quìvì ñuhìví yohó, vàchi nahi lugar ndé ndetátú sàhà‑yá nduá. Ni màsà ndácùcahan stná‑nsià quìvì ñuu Jerusalén, vàchi divi ñuu mii‑yá nduá, te rey fuerte nduú stná‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni màsà ndácùcahan stná‑nsià dìnì‑nsiá, vàchi có‑dàndàcú‑nsiá sàhà dìnì‑nsiá ñà‑chicata‑nsia idì ndèhí, te ò idì cuxín, (mii‑yá cachi‑yà). ");
INSERT INTO mitNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nú cuní‑nsià cachi‑nsià iin ñà‑ndácuisì, dandu jaan, ò á coó cachi‑nsià, vàchi nú más gà ni cachí‑nsià, dandu ñà‑vàxi nùù ñà‑malu nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Sà‑ìnáhá stnâ‑nsià nìsa cachi‑nè: “Nú ni tavá nèhivì iin nduchìnúù‑ndà, dandu xiñuhu quee stná iin nduchìnúù mii‑né. Te ò nú iin nùhu‑nda ni tavá‑né, dandu ni queé stná iin nùhu mii‑né”. ");
INSERT INTO mitNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Doco yùhù cachíˋ, màsà dúcun ndahà tnàhà‑ndà xì nècuàchì quidá quíní xí‑ndá. Vàchi nú ni caní‑né nùù‑ndà ladu cuàhá‑ndà, dandu ni cuáha stná‑ndà inga ladu‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Te nú sanícuàchi‑ne sàhà‑ndà, te candiáá‑nè dùhnù‑ndà, dandu ni cuáha stná‑ndàné dòò‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te nú ni tnií‑nèndó ñà‑fuerza cunsida‑nda carga xi‑ne iin dava hora, dandu inga dava hora gà ni cúnsídá‑ndáñâ. ");
INSERT INTO mitNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te nú xîcàn iin nèhivì iñàha nùù‑ndà, dandu ni cuáha‑ndané; te nú cuní toó‑né iñàha, dandu màsà cuídáhán‑ndáñâ nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Sà‑ìnáhá stnâ‑nsià dohó nìsa cachi nèhivì sànaha: “Icúmí‑ndá cuu ini‑ndà sàhà nècuàchì cutnáhá vàha xi‑nda, doco nèhivì xiní ùhì xì‑ndà, ni cuní ùhì stná‑ndàné”, nìsa cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Doco yùhù cachíˋ, xiñuhu cuu ini‑ndà sàhà nèhivì xiní ùhì xì‑ndà te casàhú viì‑ndà xì nèhivì xícàn chìhán dìquì‑ndà; te obra vàha ni quidá stná‑ndà sàhà nèhivì có‑xìñùhù xì‑ndà; te nú cânàhá‑nè xì‑ndà, te quidá quini‑ne xì‑ndà, dandu ni cácàn tàhvì‑ndà nùù Dios sàhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Cunaha‑nsiá, nú ni quidá‑nsiá ducán, dandu cunduu ndisa‑nsia dèhe Yuandiaha‑nsiá iá ansivi, vàchi mii‑yá, dandacú‑yá ñà‑xìnu orá nùù nsidanicuú nèhivì, vàha‑ne ò malu‑nè. Te dacuún stná‑yà dàvì nùù nsidaa nèhivì, a quidá víi‑né, ò có‑quìdá víi‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Vàchi nú cuisì nèhivì cuú ini xì sàhà‑nsiá cuú stná inì‑nsia sàhà‑xí, dandu mà níhì‑nsiá premiu sàhájàn. Dècuèndè nècuàchì iá cuàchi‑xi nahi tè‑dàchíyàhvi (ñuu‑ndà yohó), quidá stná‑nè ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te nú cuisì tnaha‑nsia cásàhú xì‑nsiá, pues màdì obra ndiaha nduájàn, vàchi divi ducán quidá stná nèhivì có‑ìnáhá xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ñàyùcàndùá, xiñuhu quida viì ndisa‑nsia nacua quidá Yuandiaha‑nsiá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Màsà quídá‑nsiá obra xi‑nsia sàhà‑ñá cundehè nèhivì, vàchi nú sàhà ñà‑jaàn nduá, dandu còò ñà‑vàha nìhì‑nsiá sàhámà nùù Yuandiaha‑nsiá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ñàyùcàndùá, nú cuàhàn‑nsià dacútâhvì‑nsiá nècuàchì ndahví, màsà cátétnùhu‑nsia ñà‑jaàn. Vàchi ducán quidá nèhivì datiaá uun nduú nèhivì vàha, quidá váté‑nê obra xi‑ne veheñùhu ò calle sàhà‑ñá cuní‑nè ndee vàha‑ne nùù nèhivì. Te ñà‑ndáà nduá cachíˋ xì‑nsiá yohó: cuisì ñà‑jaàn cunduu ñà‑vàha nìhì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Doco mii‑nsiá, na quidá‑nsiá iin obra, quida dèhé‑nsiàñà, dandu coo dèháˋ nùù nèhivì. Doco nùù Yua‑nda Dios, còó, vàchi indéhe‑yá, te nùù mii‑yá icúmí‑nsiâ nìhì‑nsiá ñà‑vàha xi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Na xícàn tàhvì‑nsiá nùù Dios, màsà quídá‑nsiá na quidá nècuàchì datiaá uun nduú nèhivì vàha. Vàchi mii‑né, cudíì ini‑nè cuita‑ne nacuatu‑ne veheñùhu ò esquina sàhà‑ñá cundehè nèhivì‑né. Doco ñà‑ndácuisì nduá yohó cachíˋ: cuisì ñà‑cundehè nècuàchìmàné cunduu ñà‑vàha xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Doco ndohó, na xícàn tàhvì‑ndà nùù Yua‑nda Dios, ni nánsìhvi‑nda ini vehe‑nda, te nacadi‑ndà yehè; dandu miiní‑yá iníní‑yá na cáhàn‑ndà xì‑yá. Te indéhe‑yá, mate nèhivì, còó, có‑xìní‑nè ñà‑ndùá quìdà‑ndà. Dandísá nìhì‑ndà iin ñà‑vàha xi‑nda nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Na cáhàn‑ndà xì‑yá, màsà cáchí‑ndà iin‑ni iñàha cuàhà xichi na quidá nècuàchì có‑ìnáhá xí Dios, vàchi mà chíndéâmà. Mii‑né, tuxí ini‑nè icúmí Dios cunini‑yanè ñà‑cuàhà guá cáhàn‑nè, doco còó. ");
INSERT INTO mitNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ñàyùcàndùá, màsà quídá‑nsiá na quidá mii‑né. Vàchi Yuandiaha‑nsiá, mate táñâha ga cachi‑nsià xì‑yá índù necesidad icúmí‑nsiâ, doco sà‑ìnáhá‑yâ. ");
INSERT INTO mitNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ñàyùcàndùá, nahi palabra yohó cachi‑nsià na xícàn tàhvì‑nsiá nùù‑yá: Yua‑nsí Dios iá ansivi, ni ndácùcahan tnùñuhu nèhivì quìvì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Te yàchì ni sáà stná tiempu cusahnu‑ní ñuhìví yohó, xícàn tàhvì‑nsí. Te nacua quidá ana ndoó ansivi ñà‑ndùá dandacu‑ní, divi ducan ni quidá stná nèhivì ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pan xi‑nsi iin quìvì iin quìvì, taxi tahvi‑níà nùù‑nsí vichi. ");
INSERT INTO mitNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Te cuicahnú inì‑ní sàhà cuàchi iníhícá‑nsî, nacua xicáhnû stná ini nsiùhù sàhà nèhivì iníhícá nùù‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Te chindee‑ní nsiùhù ñà‑màsà dáca nèhivì nsiùhù; te dacácu stná‑ní nsiùhù nùù ñà‑malu nicanicuahàn. Vàchi cuisì mii‑ní nduu‑ní rey ndiaha cusáhnû dandacu inicutu, te cuisì mii‑ní ndiaha‑ní nicanicuahàn. Amén. (Ducán cachi‑nsià.) ");
INSERT INTO mitNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Vàchi nú ni cuícáhnû inì‑nsia sàhà nèhivì nì quida quini xi‑nsiá, dandu stná Yuandiaha‑nsiá iá ansivi, cuicahnú stná ini‑yà sàhà cuàchi mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Doco nú màsà cuícáhnû ini‑nsià sàhà nèhivì dava ga, dandu mà cuícáhnû stná ini‑yà sàhà cuàchi mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Na iníhíì‑nsiá ndoó dòcó‑nsià, màsà dátiáâ‑nsiá cuhúún ini‑nsià. Vàchi ducán xíquida stná nècuàchì datiaá uun nduú nèhivì vàha, quidá cánûú‑nê ndoó‑né tnùnsí ini sàhà‑ñá cundaà ini nèhivì iníhíì‑né. Te ñà‑ndácuisì nduá cachíˋ xì‑nsiá vichi: cuisì ñà‑jaàn cunduu ñà‑vàha nìhì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Doco mii‑nsiá (màsà quídá‑nsiá ducán). Na iníhíì‑nsiá nùù Dios, quisi‑nsia, te nduviì dínì‑nsiá ");
INSERT INTO mitNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sàhá màsà cúndáà ini nèhivì iníhíì‑nsiá; cuisì Yua‑nda Dios cundaà inì‑xi, vàchi indéhe‑yá, mate có‑tùí‑yá nùù nèhivì; doco indéhe‑yá, te cuàhatahvì stná‑yànsià ñà‑vàha xi‑nsia (sàhámà). ");
INSERT INTO mitNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Màsà dácâyà‑nsià ñà‑cuìcà‑nsiá ñuhìví yohó, vàchi icúmíâ cusiquidi‑ñá, te ò nana ditnu‑ña, te ò quíhvi tècuìhnà quida cuihna xán. ");
INSERT INTO mitNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Còó, dècuèndè gloria ni cáyà‑ñà, vàchi yucán mà nunca cusiquidiá, ni mà náná dítnú‑ñá, ni mà quíhvi stná tècuìhnà quida cuihna xán. ");
INSERT INTO mitNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ducán quida‑nsia, vàchi ndé quida‑nda cuenta iá ñà‑cuìcà‑ndà, divi lugar yucán cuàhàn‑ndà cunihnu cuahà ini anima‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Nduchìnúù‑ndà nduú ñà‑tùínúù iquìcúñú‑ndà. Ñàyùcàndùá, nú iá vàha ma, dandu vàtùni cutuì nuù‑ndà ñà‑quida‑nda nsidanicuú iñàha. ");
INSERT INTO mitNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Doco nú cuhíà, dandu inicutu nácuììn tnùù. Te ducán stná xì anima nèhivì, nú iín tnúú ndê xiñuhu datnúù mii‑yá, dandu ¡ndahví‑nè! Vàchi tnùndoho nduá, nú ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Iin peón, mà cúí cundoo ùì patrón xi‑tè, vàchi nú ducán, dandu iin‑ne coo manì nùù‑té, te inga‑nè cundehè úhì‑te. Te ò ni cachí‑ndà, iin‑ne cahíchì inì‑te, te inga‑nèmà coo vàha xi‑té. Te ducán iá stná xì mii‑nsiá, nú cuú inì‑nsia sàhà dìhùn, dandu mà cúí cunucuachi stná‑nsià nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Ñàyùcàndùá, yùhù cachíˋ xì‑nsiá, màsà nácání ini‑nsià sàhà vida xi‑nsia nansa nìhì‑nsiá ñà‑cuxi‑nsia coho‑nsia, te cundixi‑nsia. Còó, vàchi màdì cuísi ñà‑cuxi‑nda ndùá xiñuhu sàhà‑ñá cucumi‑nda iin vida ndiaha; te cuerpu xi‑nda, chicá ndiaáˋ nùù sìcoto ndixi‑nda. ");
INSERT INTO mitNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cundehè‑nsiá laa ndavá ansivi, có‑xìtú‑si, ni có‑chîvàha‑sì nùnì, vàchi còò cosecha ndaníhí‑si. Còó, cuisì nùù Yuandiaha‑nda iá ansivi níhì‑sí ñà‑ìtiácù‑si. Pues náhà xìcà, chicá ndiaá mii‑nsiá nùù quisì mà. ");
INSERT INTO mitNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ñàyùcàndùá, mate yáha ga ni cahní‑nsiá dìnì‑nsiá, te nacání ini‑nsià, uun‑ni queámà, vàchi mà níhì‑nsiá cuahnu ga‑nsià ni‑inga dava metro. ");
INSERT INTO mitNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Ni màsà nácání stná inì‑nsia sàhà ñà‑ndùá cundixi‑nsia. Cundehè‑nsiá nansa sahnú ita yucù. Có‑quìdáchúûn‑yá, ni có‑quìdá vàha stná‑yà sìcoto. ");
INSERT INTO mitNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Doco chicá ndiaha náhà ita mà nùù rey Salomón (nìsa ìa sànaha), mate yáha ga vico nì sandixi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iin ita, yùcù‑ni nduá (có‑ndiàá ndisa); quìvì vitni iáˋ campu, te tnaa sànì ìchà, vihini quèa xìtnù coca. Doco mate ducán nduá, ndiaha gá nì quidavàha Dios ita‑ñà. Ñàyùcàndùá, vihi gá icúmí‑yâ cuàhatahvì stná‑yà ndohó (ñà‑ndùá xiñuhu). Doco mii‑nsiá, iyuhu gá xiníndísâ‑nsiá mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","’Pues yùhù cachíˋ, màsà nácání ini‑nsià, te màsà cáchí‑nsià: “¿Índù tùi ñà‑cuxi‑nsi coho‑nsi, te cundixi‑nsi?” ");
INSERT INTO mitNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vàchi nèhivì nsidaa raza gà ndoó ñuhìví, divi ñà‑jaàn nduá nandúcú‑nê. Doco mii‑nsiá, iá Yuandiaha‑nsiá ansivi, te sà‑ìnáhá‑yâ xiñuhu nsidaájàn nùù‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ñàyùcàndùá, xiñuhu nanducu‑nsiá (nansa chivàha viì‑nsiá ley xi), ñuhìví ìì xí‑yá, te quida‑nsia cumplir ñà‑vàha cuní‑yà quida‑nda, dandísá nìhì stná‑nsià nsidaa gá ñà‑ndùá quidámánì nùù‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Te màsà nácání inì‑nsia sàhà ñà‑ndùá cui yàha‑nsia tnaa idá, vàchi nú sànì sàà quìvì mà, dandu (nsidaámà icúmíâ quee viá), mate ni nácání cuáhà ini‑nsià. Nsìquívì iá cuàhà ñà‑ndùá yáha‑nsia, ñàyùcàndùá có‑xìñùhù nacani stná ini‑nsià sàhà tnaa idá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","(Dandu nì cachi stná Jesús:) ―Màsà dácuídâ cuàchi stnahá‑nsiá, dandu mà dácuídâ cuàchi stná Dios mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Vàchi nacua quidá mii‑nsiá dacuidá cuàchi stnahá‑nsiá, divi ducán icúmí stná‑yà quida‑ya xì‑nsiá. Vàchi vara chitácùhá‑nsià, divi icúmí stná‑nsià cuitacùhá‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","’Iin nèhivì, ¿índù chuun (indéhe‑né falta xi ñanìtnaha‑ne, te xítnùhu‑ne nècuàchìmà)? Vàchi ducán queámà na ian cuní‑nè cundehè‑né iin mihì tìì inácáá ini nduchìnúù nècuàchìmà, te nduchìnúù mii‑né, iin yutnù cahnú nduá inácáá. ");
INSERT INTO mitNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Te nú ducán, ¿índù chuun cachí‑nè xì ñanìtnaha‑nemà: “Nacoo‑ní yùhù nì tàví mihì tìì inácáá cucuíín nduchìnúù‑ní”? ");
INSERT INTO mitNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nècuàchì cachí ducán, datiaá úún‑né ndiaá ndisa‑ne. Vàchi dihna xiñuhu quee yutnù cahnú nduchìnúù mii‑né, dandu vàtùni cutùi viì núù‑né ñà‑tavà‑né mihì tìì inácáá nduchìnúù ñanìtnaha‑nemà. ");
INSERT INTO mitNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’(Mà váha ndatnuhu‑nda xi nèhivì nansa ni nì cui sàhà) yà‑ìì, còtó quida‑ne xì‑ndà na quidá sìhina cuehé. (Uun‑ni queá ñà‑cachi‑ndà palabra ndiaha xi nèhivì síquinì mà), vàchi na quidá cochí quidá stná‑nè, vàchi mate sìdiqui yáha ga ndiaá ni chíndóó‑ndá nùù‑sí, doco cuànihni sàhà‑síâ. ");
INSERT INTO mitNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Càcàn tàhvì‑nsiá, te nìhì‑nsiá. Nanducu‑nsiá (ñà‑vàha nùù‑yá), te icúmíâ tùia. Càhàn‑nsià, te nuna yehè‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vàchi nsidaa ana xícàn tàhvì, icúmí‑nê nìhìtáhvì ndisa‑ne, te nsidaa ana nandúcú xí ñà‑vàha, icúmí‑nê nìhì‑néà; te nsidaa ana xícàn tàhvì yehè‑yá, icúmí‑yâ nacuna‑ya nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Nú ni cácàn iin dèhe‑nsia pan cuxan, divi pan cuàha‑nsiañà, màdì yúù. ");
INSERT INTO mitNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Te nú cuñu siaca xícàn, pues divi cuñu quisì mà cuàha‑nsiañà, màdì cóò. ");
INSERT INTO mitNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Cunaha‑nsiá, mate nèhivì cuáchi nduú‑nsiá, doco tùha‑nsia cuàha‑nsia dèhe‑nsia ñà‑ìá viì. Ñàyùcàndùá, vihi gá icúmí Yuandiaha‑nsiá iá ansivi cuàha‑yansià ñà‑vàha nú ni cácàn tàhvì‑nsiá nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ñàyùcàndùá, nacua cuní mii‑nsiá quida nèhivì xì‑nsiá, divi ducán quida stná‑nsià xì mii‑né. Vàchi ñà‑jaàn nduá cachí nùù nsidaa tutu nduú ley xi Dios, xì nùù stná tutu nì tiaa profeta nìsa cahàn cuenta xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Quìhvi‑nsia yehè cuiín sáà (gloria), vàchi xica yehè ichì cahnú cuàhàn ndé ndañuhu‑nda, te cuàhà gá nèhivì quíhvi yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Doco sitníhì yehè, te cuiín ichì cuàhàn ndé cutiacu ndiaha‑nda; te sàhà‑ñá nduá ichì cuiín, ñàyùcàndùá sacu nèhivì ndácùhun xán. ");
INSERT INTO mitNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Cuidadu cundoo‑nsia xì nèhivì tnùhù dananí úún cáhàn cuenta xi Dios, vàchi cutu vàxi‑ne (datiaá úún‑né mànì ini‑nè) nahi riì mansu, doco anima‑nè, còó, nahi lobu dana, ducán iáˋ. ");
INSERT INTO mitNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Doco cuisì cundehè‑ndà ñà‑ndùá quidá‑né, dandu cundaà ini‑ndà nansa ndisa iá anima‑nè. Te ducání iá stná xì‑né na iá xì yutnù fruta, mà cuáha yutnù ìñù ni‑iin sì‑uva, te mà cuáha stná yùcù iñu ni‑iin stná sìhigu. ");
INSERT INTO mitNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mà cúí, vàchi nsidaa yutnù vàha, puru fruta vàha sáha‑nù. Te yutnù còò chuun xi, cutu ñà‑chìcuéhè sáha‑nù. ");
INSERT INTO mitNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Doco iin yutnù vàha, mà cúí cuàha‑nù iin fruta chicuéhè. Ni‑iin stná yutnù còò chuun‑xi, mà cuáha‑nù ni‑iin quisì vídì. ");
INSERT INTO mitNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Te nsidaa yutnù có‑sâha xi ñà‑ìá viì, icúmí‑nû tàhndè‑nu, te quèe‑nù ñuhu coco‑nù. ");
INSERT INTO mitNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ñàyùcàndùá, na quida‑nda xi iin yutnù, nacúní‑ndànú sàhà fruta‑nu, ducán nacúní stná‑ndà nèhivì sàhà ñà‑ndùá quidá‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Cuàhà nèhivì cachí‑nè xìˊ: “Stoho‑nsì Señor nduu‑ní”. Doco màdì nsidaa nècuàchìmà sàà‑nè cundoo‑ne ñuhìví ìì xí Yuamánìˊ iá ansivi; cuisì nèhivì quidá ndisa xi ñà‑ndùá cuní‑yà, divi sàà yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Te cunaha‑nsiá, na sáà quìvì (xìnu tiempu), dandu icúmí cuàhà nèhivì cachi‑nè xìˊ: “Stoho‑nsì Señor, sànì càhàn‑nsì cuenta xi‑ní, te nì ndacùcahan‑nsí quìvì‑ní; dècuèndè nì tavà stná‑nsì ñà‑malu ñuhú ini nèhivì, te cuàhà gá stná milagru nì quida‑nsi na ní ndacùcahan‑nsí quìvì‑ní”, cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dandu yùhù naxiconihí nùù‑né, te cachì: “Tàcùníˋ nsiohó; cuahán‑ndâ iladu, vàchi cuàhà ñà‑chìcuéhè sànì quida‑ndá”. ");
INSERT INTO mitNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ñàyùcàndùá, nsidaa nèhivì iníní xí ñà‑ndùá cachíˋ, te quidá ndisa‑neà cumplir, nduú‑né na iin tiàa nchichí nì nanducu xi iin xaan ndé iá cavà fuerte, te yucán nì chinduhù‑né vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Daaní, nì quesaha nì cuun dana dàvì, te nì xìnu tèñuhu cuáhà. Dandu nì dàñà stná tàchì fuerte, te nì dùcùn nsidaámà ìcà vehe ma. Doco cónì ndùáˋ, vàchi nùù cavà fuerte indúhá. ");
INSERT INTO mitNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","’Doco cunaha‑nsiá, nèhivì iníní uun xi ñà‑ndùá cachíˋ, te có‑quìhín casu‑nè, na iin tiàa ndañuhu nduú‑né, divi na iin tiàa nì quidavàha xi vehe‑xi dìquì ñusì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Vàchi na ní quesaha nì cuun dana dàvì, te nì dàñà stná tàchì fuerte, dandu nì xìnu tèñuhu cuáhà yucán. Te nì dùcùn nsidaámà ìcà vehe ma. Te nì ndua ìá nì chàhmà dahuan ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Daaní, na ní nsihi nì càhàn‑yà xì nèhivì ducán, dandu nì ndulocó‑nè sàhà ñà‑ndùá chináhá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Vàchi na iin nèhivì tùha dandacú, ducán nì chinaha‑yànè, màdì nahi modo chináhá nècuàchì ley xi veheñùhu. ");
INSERT INTO mitNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Daaní, nì nuu Jesús yucù yucán, te cuàhà gá nèhivì nì tenchicùn xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Te cunaha‑nsiá, yucán nì tnàtuu stná iin tiàa icúmí cuèhè lepra, te nì tutuyuhu‑né ñuhù sàhà‑yá, cachí‑nè xì‑yá: ―Señor, nú cuní‑nî, vàtùni dandúvàha‑ní yùhù. ");
INSERT INTO mitNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dandu nì chituu Jesús ndahà‑yá nùù‑né, te nì cachi‑yà: ―Juùn. Vichi duha ni ndúvàha‑ní, cachíˋ xì‑ní. Dandu divi hora nì cachi‑yà xì‑né ducán, nì ndañuhu cuèhè xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dandu nì cachi‑yà xì‑né: ―Cunaha‑ní, màsà cáchì‑ní ni‑iñàha xi nèhivì. Cuisì cuahán‑nî nùù dùtù dacúndêhe‑nínè ìcà‑ní, dandu nacuàha‑ní promesa xi Dios nacua cachí ley xi Moisés sàhà‑ñá cundaà ini nèhivì ñà‑sànì nduvàha‑ní ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Daaní, nì nasaa Jesús ñuu Capernaum, te yucán nì tnàtuu iin capitán romanu, nì sacundahví‑nè nùù‑yá, ");
INSERT INTO mitNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","cachí‑nè: ―Señor, iá iin mozo xi cuhí, indúhu‑né cama vehi; sànì dàñà íì cuerpu‑nè, te yáha ga ndohó‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dandu nì cachi Jesús xì capitán mà: ―Jaàn másàì dandúvàhi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te nì naxiconihí capitán mà nùù‑yá, cachí‑nè: ―Señor, có‑nâtùi yàha‑ní vehi. Cuisì dandacu‑ní xì palabra xi‑ní, te nduvàha mozo xi. ");
INSERT INTO mitNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Vàchi yùhù, ndoó stná ana dandacu‑xi nùí, te mií, dandacú stnáì nùù soldadu xi. Nú ni cachíˋ xì iin‑tè: “Cuahán”, dandu cùhùn‑te; te ò nú ni cachíˋ xì ingà‑te: “Naha”, dandu quixi‑tè; te na cachí stnáì xì iin mozo xi: “Dohó quido”, dandu ducán quida‑te ―nì cachi capitán mà. ");
INSERT INTO mitNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nì nsihi nì inini Jesús ñà‑jaàn, dandu nì ndulocó‑yà, te nì cachi‑yà xì nèhivì xínchicùn xì‑yá: ―Cunaha‑nsiá, tàñáha ga cunì ni‑iin nèhivì ñuu‑ndà Israel yohó ndudává xí capitán yohó, vàchi cuàhà gá xiníndísâ‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Te cachí stnáì xì‑nsiá, icúmí nataca cuàhà gá nèhivì quixi inicutu ñuhìví dècuèndè ndé xínu orá xì ndé quécahnu‑ya, te nataca‑nè cutnahá‑né xì Abraham xì Isaac xì Jacob ñà‑cundoo‑ne (vicò) ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Doco nèhivì dava ga cuàhàn cundoo ñuhìví ìì mà nì cùí, icúmí‑nê ndiachi‑né fuera ndé iín tnúú; te yucán icúmí‑nê cuacu fuerte‑nè, te càna nùhu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Daaní, nì cachi Jesús xì capitán mà: ―Vàtùni nùhù‑ní vichi, te nacua sànì xinindisa‑ní, divi ducán icúmí coo ―nì cachi‑yà. Dandu divi hora yucán nì nduvàha mozo xi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Daaní, nì sàà Jesús vehe Pedro, te yucán nì xini‑yà cuhí dìdo‑ne ñahà; indúhu‑né, nácuàha yocá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ñàyùcàndùá, nì tnii‑ya ndahà‑né, te nì cuxio cuèhè mà. Dandu nì ndacuiin‑nè nì quesaha‑né nì xinucuachi‑né nùù‑yá xì compañeru‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Daaní, nì cuñaà, te yucán nì sàà stná cuàhà gá nèhivì, ndacá‑né cuàhà nècuàchì inácáá ñà‑malu inì‑xi. Te cuisì‑ní nì càhàn‑yà xì iin iin nècuàchìmà nì dàndàcú‑yá nùù‑sí, te nì quee dahuun‑sì nùù‑né. Te nsidaa gá stná nècuàchì cuhí nì casaà yucán, nì dàndúvàha stná‑yànè. ");
INSERT INTO mitNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ducán nì quida‑ya sàhà ñà‑nì cùú ndisa ñà‑ndùá nì cachitnùhu nèhivì xí Dios nani Isaías na ní cachi‑nè palabra yohó: “Mii‑yá nì dàcúxíó‑yá cuèhè xi‑nda, vàchi nì nacuida‑ya ñà‑ndùá dandoho xi‑nda”. ");
INSERT INTO mitNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na ní xini Jesús sànì tnàtuu cuàhà gá nèhivì nùù‑yá, dandu nì cachi‑yà xì nècuàchì dacuahá‑yá ñà‑nì cúhùn‑nè xì‑yá ndè inga ladu mar. ");
INSERT INTO mitNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Te daa nì tnàtuu stná iin nècuàchì ley xi veheñùhu, cachí‑nè xì‑yá: ―Maestro, dispuestu iéˋ cunchicuìn mii‑ní ndéni nì cui ni cúhùn‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Doco nì cachi‑yà xì‑né: ―Lusu, iá nchihò‑sí; te laa ndavá ansivi, iá stná tacà‑si; doco yùhù ana nduú Tnaha Nèhivì Ñuhìví, còò ni‑iin lugar ndé cunduhí cùdì. ");
INSERT INTO mitNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Daaní, inga nèhivì nduú iin ana dacuahá‑yá, nì cachi stná‑nè xì‑yá: ―Señor mío, dihna ni núhì vehi coo guè dècuèndè nú sànì ndùxin yué (dandu cunchicuìn mii‑ní). ");
INSERT INTO mitNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dandu nì cachi‑yà xì‑né: ―Còó. Cunchicùn dahuun‑ní yùhù. Nècuàchì còò vida (ndiaha nùù anima‑xi), divi ni cúxin xi nsìi xi. ");
INSERT INTO mitNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","24","Daaní, nì nana Jesús lancha, mii‑yá xì nècuàchì dacuahá‑yá, te cuàhàn‑yà xì‑né nùù mar. Doco nì quesaha caná ndéé tàchì, te nì nacuahnu todò tècuìí, te cuàhà gá‑te nì quèe stná ini lancha. Doco mii‑yá, quídì naà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ñàyùcàndùá, nì nataca nècuàchì dacuahá‑yá ndé indúhu‑yá, te nì dànsícuìhnu ini‑nèyà, cachí‑nè xì‑yá: ―¡Stoho‑nsì Señor! ¡Dacácu‑ní nsiùhù, vàchi cuàhàn‑ndà càhà‑ndà! ");
INSERT INTO mitNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Dandu nì cachi‑yà xì‑né: ―¿Índù chuun yúhî guâ‑nsià, te có‑càhvì‑nsiá xì Dios? Dandu nì ndacuiin‑yà nì càhàn‑yà nì sadi‑yà nùù tàchì xì nùù tècuìí mar mà. Te (vichi vichi) nì nàcuììn dàdí uun inicutu. ");
INSERT INTO mitNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dandu nì candulocó nècuàchìmà nì cachi‑nè: ―¿Índù clase tiàa nduú ana yohó ñà‑dècuèndè tàchì xì mar iníní xí‑nê? ");
INSERT INTO mitNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Daaní, nì sàà Jesús inga ladu mar yucán ndé nduú ñuu Gadara. Te yucán nì caquee ùì nèhivì mahì cueva ndé xí‑indùxin nsìi, te nì tnàtuu‑ne nùù‑yá. Ndúì‑nè, ñuhú ñà‑malu ini‑nè, te dana sàstnùhù‑né, mà cùì yáha ni‑iin nèhivì ichì yucán ndé ndoó‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Te nì càna ndee‑né, cachí‑nè xì‑yá: ―Mii‑ní, Dèhemanì Dios nduu‑ní. ¿Ndíà cunduu‑ní nsiùhù? ¿A váxi‑ní dandoho‑ní nsiùhù, mate tá sâà hora ndoho‑nsi? ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Te xica yucán ndoó cuáhà stná cochi xixáhan‑sì. ");
INSERT INTO mitNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ñàyùcàndùá, nì sacundahví nsidaa ñà‑malu mà nùù‑yá, cacháˋ: ―Nú cuàhàn‑ní tavà‑ní nsiùhù, dandu dayáha‑ní nsiùhù ini cochi cuàhà yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dandu nì cachi‑yà xán: ―Cuahán‑ndâ, cachíˋ. Dandu nì caquee nsiha nì sàcùñuha ini cochi yucán. Ñàyùcàndùá, carrera nì canuu nsihi‑sì candiaa yucán, te nì còyo‑sì ndè mar nì càhà‑si. ");
INSERT INTO mitNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dandu tè‑ndiàá xì cochi mà, yáha ga nì yùhí‑te; te mànuhù‑té carrera ndé nduú ñuu yucán, nì cachitnùhu‑tè xì nèhivì ñuu mà ñà‑ndùá nì cuu, xì sàhà stná nècuàchì nìsa ñuhu ñà‑malu inì‑xi. ");
INSERT INTO mitNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ñàyùcàndùá, nì caquee nsihi nèhivì ñuu mà nì casaà‑nè ndé iá Jesús; te na ní xini‑nèyà nì sacundahví‑nè nùù‑yá ñà‑nì quèé dahuun‑ya ladu xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Daaní, nì nana tu Jesús lancha, te nì yàha‑ya mar mànuhù‑yá inga ladu ndé nduú ñuu‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Te yucán nì tnàtuu nèhivì nsida‑xi iin nècuàchì cuhí nì dàñà íì cuerpu‑xi, indúhu‑né camilla. Ñàyùcàndùá, na ní xini‑yà ñà‑cuàhà guá xíxinindisá nèhivì yucán mii‑yá, nì cachi‑yà xì nècuàchì cuhí mà: ―Màsà cúhúún inì‑ní, hijo, vàchi yùhù xicáhnû inì sàhà cuàchi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Doco cunaha‑nsiá, yucán ndoó stná dava maestru xi ley xi veheñùhu, te nacání ini‑nè: “¡Mà ndóo ini Dios sàhà ñà‑ndùá nì cachi Jesús mà!” ");
INSERT INTO mitNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Doco mii‑yá, ináhá‑yâ nansa nacání ini nècuàchìmà, ñàyùcàndùá nì cachi‑yà xì‑né: ―¿Índù chuun có‑nàcání víi inì‑nsia? ");
INSERT INTO mitNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Cachi‑nsià xìˊ: ¿índù milagru nduú ñà‑chicá ùhì quida‑nda: a ñá‑cachi uun‑nda (xi nècuàchì cuhí) ñà‑xìcáhnû ini‑ndà sàhà cuàchi‑ne, te ò ñá‑cachi‑ndà xì‑né ni ndácuíín‑nè, te nacaca‑ne? ");
INSERT INTO mitNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pues yùhù ana nduú Tnaha Nèhivì Ñuhìví, cuàhìn quide iñàha sàhà‑ñá cundaà ini‑nsià iá ndisa derechu cuicahnú inì sàhà cuàchi nèhivì ñuhìví. Dandu nì cachi‑yà xi nècuàchì cuhí mà: ―Ndacuiìn‑ní, ndanihi‑ní camilla xi‑ní, te xuhun‑ní vehe‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dandu, nì ndacuiin nècuàchìmà, mànuhù‑né vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na ní xini nèhivì cuáhà itá yucán ñà‑ndùá nì cuu, dandu nì yùhí‑nè, te nì naquimanì stná‑nè Dios; vàchi nì xini‑nè iá ndisa ana nì nìhìtáhvì cuáhà nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Daaní, nì quee Jesús lugar yucán cuàhàn‑yà. Te nì xini‑yà yucán iá iin tiàa nani Mateo, iá‑nè nùù mesa ndé dachíyàhvi‑ne. Te nì cachi‑yà xì‑né: ―Nahà‑ní cunchicùn‑ní yùhù. Dandu nì ndacuiin nècuàchìmà cuàhàn stná‑nè xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Daaní, después iá‑yà iin vehe xixí‑yá, te cutnáhâ stná‑yà xì cuàhà nècuàchì dachíyàhvi, xì cuàhà gá stná inga nèhivì cachí‑nè iá cuàchi‑xi; xíndoo nsidaa‑né xixí‑né xì‑yá xì nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te nì caxini nècuàchì fariseu nansa quidá‑yá (xixí‑yá xì nècuàchìmà), te nì càhàn‑nè xì nècuàchì dacuahá‑yá mà, cachí‑nè: ―¿Índù chuun cutnáhâ maestru xi‑nsia xixí‑né xì cuàhà tè‑dàchíyàhvi, xì dava ga stná nèhivì cuáchi? ");
INSERT INTO mitNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Doco nì tiacu Jesús ñà‑càchí‑nè ducán; ñàyùcàndùá nì cachi‑yà xì‑né: ―Màdì nècuàchì ndáa vàha xiñuhu xi ana quidatatna xi‑né. Còó, nècuàchì cuhí xiñuhu xi ana quidatatna xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ñàyùcàndùá, cuahán‑nsià dacuahá‑nsiá nansa cuní cachi Dios nùù tutu ìì ndé cachí‑yà: “Chicá cudíì inì ñà‑cundehè ndahví stnahá‑nsiá, te màdìá cuàha‑nsia yùhù iin promesa”, cachí‑yà. Vàchi yùhù, màdì nèhivì nihnú ndàcuisì inì‑xi vàxi càhàn xìˊ ñà‑naxicocuíìn ini‑nè. Còó, nèhivì cuáchi vàxi nanduquí áma naxicocuíìn ini‑nè sàhà cuàchi‑ne ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dandu nì catnàtnuu nècuàchì nchícùn xì Juan Bautista, te nì ndàcàtnùhù‑né nùù‑yá, cachí‑nè: ―Nsiùhù xì stná nècuàchì fariseu, iníhíì cuáhà‑nsí ndoó dòcó‑nsì, doco nècuàchì dacuahá mii‑ní, còó, có‑ìníhíì‑né. ¿Índù chuun? ");
INSERT INTO mitNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Dandu nì cachi‑yà xì‑né: ―Nècuàchì ndoó vicò nándàhà, ¿a cúí cundoo‑ne tnùnsí ini na meru ndoó‑né cutnáhâ‑né xì noviu? Còó. Doco vàxi iin quìvì mà cóó gá noviu nùù‑né; dandísá tiempu yucán icúmí‑nê cunihiì‑né cundoo dòcó‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Sìcoto saa, màsà nácàhmá‑ndàñá nùù ñá‑tùhú, vàchi nú ducán, dandu dandánsíá ndé nì nacàhmá, te chicá ndatá sìcoto tuhú mà. Dandu ñà‑sànì ndàtà dahuun sicoto‑mà cundua. ");
INSERT INTO mitNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Stná vinu, nú vinu saa nduá, dandu mà dáquêe nèhivì‑ñá ini itni iìn tuhú, vàchi nú ducán, dandu ndàtà‑ñá, te cuìtià vinu, te cuchicuehe stná iìn mà. Ñàyùcàndùá, nú vinu saa nduá, dandu itni iìn sàà ni quéa, te ducán còò ni‑iñàha cuu xán, ni stná iìn mà. ");
INSERT INTO mitNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na cáhàn va Jesús ducán xì nèhivì, dandu nì sàà stná iin nècuàchì dandacú, te nì tutuyuhu‑né ñuhù nùù sàhà‑yá, cachí‑nè xì‑yá: ―Làcà ní quesaha xíhì nihni dèheyoquí; doco nú ni cúhùn‑ní, te chitàndòò‑ní ndahà‑ní dìquìá, dandu nanihìtáhvìá ñuhìví ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ñàyùcàndùá, nì ndacuiin‑yà cuàhàn‑yà xì‑né. Te cutnáhâ stná‑nè xì nsidaa nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Doco nìsa ìa stná iin nècuàchì ñahà cuhí cuèhè nìì. Sàcuàhàn‑nè ùxìn ùì cuìà ndohó‑né ducán. Ñàyùcàndùá, nì quixi‑ne ladu yàtà‑yá, te nì dàcúhùn canúú‑nê dìnìndàhá‑nè nùù sìcoto xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Vàchi nihnú ini‑nè: “Nú ni dúcùn ndahí mate sícotò‑ni xi‑ya, dandu nduvàhi”. ");
INSERT INTO mitNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dandu mii‑yá, nì nacuico‑yá yàtà‑yá, te nì xini‑yà nècuàchì ñahà mà, te nì cachi‑yà xì‑né: ―Màsà cúhúún inì‑ní, hija, vàchi sànì nduvàha‑ní ñà‑nì xinindisa‑ní. Dandu divi momentu mà nì nduvàha nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Daaní, nì sàà‑yà vehe nècuàchì dandacu‑ma, te nì xini‑yà yucán ndoó cuàhà nèhivì xì stná tè‑sìví, sacú ndéé‑nê, te tnaná‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ñàyùcàndùá, nì cachi‑yà xì‑né: ―Quee‑nsia fuera, vàchi ñahà chìì yohó, cónì xíhì ndisa‑ñà, quídì uun ni‑ñà. Doco nèhivì mà, nì sàcùndiaa uun‑neyà. ");
INSERT INTO mitNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dandu mii‑yá, nì dàcúhùn‑yà nsidaa‑né fuera, te nì quìhvi‑ya ndé indúhu ñahà chìì mà. Dandu nì tnii‑ya ndahà‑ñá, te nì dàndácòo‑yàña (vàchi sànì natiacù‑ña). ");
INSERT INTO mitNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Daaní, inicutu ladu yucán nì xìtià palabra nansa nì quida‑ya milagru mà. ");
INSERT INTO mitNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na ní quee‑ya lugar mà, dandu yucán nì tenchicùn stná ùì nècuàchì cuaá mii‑yá, cána‑ne, cachí‑nè xì‑yá: ―Mii‑ní descendencia ìì xí David, cundehè ndahví‑nî nsiùhù. ");
INSERT INTO mitNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dandu nì yàha‑ya ini vehe, te ndè yucán nì casaà stná nècuàchìmà, nchícùn‑nèyà. Dandu nì cachi‑yà xì‑né: ―¿A xiníndísâ ndisa‑nsia ñà‑vàtùni dandúvàhi mii‑nsiá? ―Jaan, Señor ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dandu nì chituu‑ya dìnìndàhá‑yà nduchìnúù‑né, te nì cachi‑yà: ―Nacua sànì xinindisá‑nsiá, divi ducán ni coo‑xi‑nsiá, cachíˋ. ");
INSERT INTO mitNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dandu nì natùi nùù‑né. Te nì chinaha‑yánè, cachí‑yà xì‑né ñà‑màsà cúnítnùhu nèhivì sàhà ñà‑ndùá nì quida‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Doco mii‑né, nì caquee‑ne nì nacani‑ne sàhà‑yá xì nsidaa nèhivì ndoó inicutu ladu yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Meru queé nècuàchì cuaá mà, te nì quesaa stná itnii nèhivì ndaca‑xi iin nècuàchì ìhìn inácáá stná iin ñà‑malu inì‑xi. ");
INSERT INTO mitNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dandu nì tavà Jesús ñà‑malu mà, te nì nìhì‑né nì nacahàn viì‑né. Ñàyùcàndùá, nì ndulocó nèhivì, cachí‑nè: ―Có‑xìní‑ndà ni‑iin ñà‑ndiaha jaàn ñuu‑ndà Israel yohó. ");
INSERT INTO mitNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Doco nècuàchì fariseu, nì cacachi‑nè sàhà‑yá: ―Còó. Sàhà‑ñá chindéé jefe xi ñà‑malu‑nè, ñàyùcàndùá vàtùni tavà‑né dava ga ñà‑malu. ");
INSERT INTO mitNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Daaní, chicá más nì xìcanuu Jesús ladu yucán nì nacàhin‑ya nsidaa ñuu nahnú xì ñuu cuati, dacuahá‑yá nèhivì sáhàn veheñùhu iin iin ñuu, te cachítnùhu‑ya razón ndiaha sàhà ñuhìví ìì xí Dios. Te nì dàndúvàha stná‑yà nèhivì ndohó nsidanuu clase cuèhè. ");
INSERT INTO mitNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Te na ní xini‑yà yáha ga cuàhà nèhivì ndoó, dandu nì cuhi gà ini‑yànè, vàchi ndoó‑né nahi riì còò stohò‑xi. ");
INSERT INTO mitNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dandu nì cachi‑yà xì nècuàchì dacuahá‑yá: ―Ñà‑ndáà nduá (cuàhà nèhivì tàñáha ga cunindisá); te na iin cosecha cahnú ndaníhí‑ndá nduú‑né, doco sacu nèhivì nduú ana (chindéé xí‑ndá) ndanchítóá. ");
INSERT INTO mitNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ñàyùcàndùá, càcàn tàhvì‑nsiá nùù Lamú dandacú sàhà chuun yohó ñà‑nì téchúûn gá‑yà nèhivì cùhùn quida xi chuun (ìì xí‑yá mà), vàchi na ian ndaníhí‑ndá iin cosecha ndiaha nduá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Dandu nì cana Jesús ùxìn ùì nècuàchì dacuahá‑yá, te nì sàhatahvì‑yánè ñà‑tavà‑né ñà‑malu ñuhú ini nèhivì. Te nì nìhìtáhvì stná‑nè dandúvàha‑ne nècuàchì cuhí ndohó nsidanuu clase cuèhè. ");
INSERT INTO mitNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cunaha‑nsiá, dohó nani ùxìn ùì nècuàchì dacuahá‑yá mà: primeru iá Simón; te Pedro nani stná‑nè; daaní, iá stná ñani‑nè Andrés, xì stná dèhe Zebedeo nani Jacobo, xì ñani Jacobo mà nani Juan. ");
INSERT INTO mitNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Te iá stná Felipe, xì Bartolomé, xì Tomás, xì tè‑dàchíyàhvi nani Mateo, xì stná dèhe Alfeo nani Jacobo, xì stná Lebeo; te Tadeo nduú inga quìvì Lebeo mà. ");
INSERT INTO mitNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Daaní, iá stná Simón nì sanduu iin nècuàchì partidu cachí‑nè nècuàchì Canaán, te nì ìa stná Judas Iscariote, divi nècuàchì nì cahin xì‑yá nùù tè‑xídandacú. ");
INSERT INTO mitNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pues divi ùxìn ùì nèhivì yucán nì techuún Jesús (cùhùn‑nè cacanuu‑ne). Te dohó nì cachi‑yà xì‑né quida‑ne: ―Màsà cúhùn‑nsià ladu ndé ndoó nècuàchì inga raza, ni màsà cúhùn stná‑nsià ndé ndoó nècuàchì samaritanu. ");
INSERT INTO mitNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Còó, cuisì‑ní ndé ndoó nèhivì raza‑ndà Israel ni cúhùn‑nsià, vàchi nahi riì nì tùcù xínduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cuahán‑nsià cachitnùhu‑nsia xì‑né ñà‑sà‑ìtúú tiempu cusahnú mii‑yá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Dandúvàha‑nsia nècuàchì cuhí, te danátiácú‑nsià nècuàchì nsìi. Te nècuàchì icúmí cuèhè xíhì cuñù‑xi, dacúxíó‑nsiá cuèhè quini ma, te tavà‑nsiá ñà‑malu nùù nèhivì inácáà‑si inì‑xi. Te màsà quídá‑nsiá cobrar nùù nèhivì, vàchi uun‑ni sànì nìhìtáhvì stná‑nsià ñà‑quida‑nsia ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ni dìhùn oro, ni dìhùn plata, ni dìhùn yahá màsà cúníhí‑nsiá cùhùn ini itni xi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni morral màsà cúníhí‑nsiá cùhùn ichì. Cuisì‑ní iin‑ni dùhnù‑nsiá cunihi‑nsia, xì ndìsàn sà‑ìnáì‑nsià, xì stná bastón xi‑nsia. Cuisì ñà‑jaàn‑ní cunihi‑nsia cùhùn, vàchi iin nèhivì quidáchúûn, xiñuhu cuàha nèhivì‑né raya xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Daaní, nú sànì sàà‑nsià iin ñuu, ò iin ranchu, dandu nanducu‑nsiá vehe iin nècuàchì vàha, te iin‑ni cundoo‑nsia yucán ndè cachi sàà quìvì quee‑nsia ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Te nú sànì sàà‑nsià vehe iin nèhivì, casàhú viì‑nsiá xì‑né ñà‑nì cúndóó cueé‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te nú nduú‑né nèhivì vàha, dandísá, ducán icúmí cuu xi‑né, doco nú mà váha‑ne, dandu ni cúnàhá ñà‑ndùá nì cachi‑nsià xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te nú có‑cùní‑nè dayáha‑ne mii‑nsiá, te ò có‑cùní‑nè cunini‑ne palabra nihí‑nsiá, dandu quee‑nsia vehe ma, te ò ñuu mà, te nacatù‑nsiá sàhà‑nsiá ñà‑nì cóyo yàcá xi lugar mà. ");
INSERT INTO mitNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Vàchi cunaha‑nsiá, chicá cuàhà castigu icúmí nèhivì ñuu mà nìhì‑né na sáà quìvì juiciu, te chicá menos icúmí nìhì nèhivì malu ñuu Sodoma xì ñuu Gomorra. ");
INSERT INTO mitNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Cunaha‑nsiá, dana ga nèhivì ndé techúîn mii‑nsiá cacanuu‑nsia, nahi quisì íhì nduú‑né, te mii‑nsiá nduú‑nsiá nahi riì. Ñàyùcàndùá, xiñuhu ñà‑cunchito tùha‑nsia, te coo mansu stná‑nsià na iin loma. ");
INSERT INTO mitNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cuidadu gà cundoo‑nsia sàhà nèhivì, vàchi dava‑ne icúmí‑nê quida‑ne mii‑nsiá entregar nùù tè‑nìhí chuun, te yucán ñàhnì cuií‑nsià ini veheñùhu xi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Te sàhà‑ñá nchícùn‑nsià yùhù, ñàyùcàndùá icúmí‑nê datnátuu‑ne mii‑nsiá nùù gobiernu xì nùù rey, dandu datúi‑nsia nùù nècuàchìmà ñà‑ndùá xiníndísâ‑nsiá, te cunini stná cuàhà gá nèhivì inga raza. ");
INSERT INTO mitNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Doco na sáà‑nsià nùù tè‑xídandacu‑ma, màsà nácání inì‑nsia índù palabra naxiconihí‑nsiá nùù‑té, vàchi divi hora mà icúmí‑nsiâ nìhìtáhvì‑nsiá nansa cachi‑nsià xì‑té. ");
INSERT INTO mitNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Vàchi màdì mii‑nsiá cunduu ana cuàhàn càhàn; còó, mii Espíritu Ìì xí Yuandiaha‑nsiá cuàhàn dachítnùní xì ini‑nsià nansa cachi‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Te tiempu yucán, dècuèndè tnaha nèhivì icúmí quida xi‑né entregar (nùù autoridad) ñà‑cui‑nè, mate ñání‑nè, ò déhe‑ne nduú nècuàchìmà. Ndè stná yuadíhí‑nê icúmí‑nê nacuni ùhì‑nè, te canicuàchi stnahá‑né sàhà‑né ñà‑cui‑nè. Ducán icúmí‑nê quida‑ne (quìvì yucán). ");
INSERT INTO mitNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Te mii‑nsiá, sàhà‑ñá ndácùcahan‑nsiá yùhù, ñàyùcàndùá icúmí nsidaa nèhivì cuni ùhì‑nènsià. Doco nú iin‑ni ni cúníhnú vàha inì‑nsia dècuèndè cachi sàà xìnu tiempu, dandísá icúmí‑nsiâ càcu‑nsia nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Te nú quidá quíní nèhivì xì‑nsiá iin ñuu, dandu cunudèhé‑nsià ndè inga ñuu. Vàchi cunaha‑nsiá, tàñáha ga nacàhin‑nsia nsidanicuú ñuu raza‑ndà Israel, te sànì naxicocuíìn yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Cunaha‑nsiá, màdìá chicá tùha iin nècuàchì làcà dacuahá nuu iin maestru; te ò iin peón, màdìá chicá ndiaá‑te nùù lamú xi‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Cuisì nú sànì sàà iin nècuàchì dacuahá cunduu‑ne nahi maestru xi‑ne, dandu cudíì ini‑nè sàhájàn. Stná iin peón, nú sànì sàà stná‑te cunduu‑tè nahi lamú xi‑tè, dandu cudíì stná inì‑te sàhájàn. Doco nú cachí nèhivì sàhà iin nècuàchì sahnú ñà‑ndùú‑né ñà‑malu Beelzebú, dandu chicá mà úhì càhàn quini stná‑nè sàhà nèhivì vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ñàyùcàndùá, màsà yúhî‑nsià nèhivì. Cunaha‑nsiá, còò ni‑iñàha cui coo dèhé nicanicuahàn; icúmíâ tùia, te icúmí nèhivì cunitnùhu stná‑nè sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Doco mii‑nsiá, ñà‑ndùá cachíˋ xì‑nsiá (na ndoó cuaán‑nda) ndé iín tnúú, ñà‑jaàn cachitnùhu‑nsia inicutu ndé tuí. Te nú nì càhàn cayí xì‑nsiá iñàha, dandu mii‑nsiá, nana‑nsia dìnì vèhé, te càhàn vate ndee‑nsiá ñà‑ndùá nì cachì. ");
INSERT INTO mitNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Te màsà yúhî‑nsià nèhivì cuní cahnì xì‑nsiá, vàchi cuisì iquìcúñú‑nsià cunduu ñà‑cui, doco anima‑nsià, mà cúí cahnì‑néà. Nàyùcàndùá, mii‑yá nduú ana xiñuhu yùhí‑nsià, vàchi icúmí ndisa‑ya poder daquée‑ya nèhivì nùù andea ndé ndañuhu dahuun anima‑nè xì stná iquìcúñú‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Sà‑ìnáhá‑nsiâ ñà‑ùì chòlìhì dicó‑né cùmì tuní, doco mate ducán iyuhu ndiaá‑si, ni‑iin‑sì mà sáà cui nú có‑chîtnùní ini Yuandiaha‑nsiá Dios ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Te divi ducán stná mii‑nsiá (inúù stná‑yà mii‑nsiá), dècuèndè ináhá‑yâ nadaa idìdínì iin iin‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ñàyùcàndùá, màsà yúhî‑nsià, vàchi chicá ndiaá‑nsià nùù laa cuati ma. ");
INSERT INTO mitNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Nú cachí vate nèhivì ñà‑ndùú‑né nèhivì xí, dandu yùhù cachi stnáì xì Yuamánìˊ iá ansivi ñà‑divi nèhivì xí nduú stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Doco nú ni chídèhé‑nè ñà‑ndùú‑né nèhivì xí, dandu yùhù stná, icúmî nacuaà stnáì mii‑né nùù Yuamánìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Màsà cúcáhán‑nsiâ a váxi yùhù ñuhìví yohó ñà‑cucumi nèhivì paz. Còó. Mà cúndóó mánì‑né; icúmí‑nê cundoo‑ne náâ stnàhá‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Vàchi ñà‑nì quesaì ñuhìví yohó, icúmí cuni ùhì iin tiàa yua‑té, te cuni ùhì stná iin ñahà chìì dihi‑ñá, te ò iin nècuàchì ñahà, cuni ùhì stná‑nè dìdo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Vàchi dècuèndè tnaha‑ne cuni ùhì xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Doco nú chicá cuú ini iin nèhivì sàhà yua‑né, ò dihi‑né, te màdì yúhù, dandu có‑nâtùi‑ne cunduu‑ne nèhivì xí. Te ò nú chicá cuú ini‑nè sàhà dèhe‑ne, te màdì yúhù, dandu có‑nâtùi stná‑nè cunduu‑ne nèhivì xí. ");
INSERT INTO mitNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Te nú màsà cóó‑né dispuestu cunchicùn‑nè yùhù mate icúmí‑nê cunsida stná‑nè cruz xi‑ne (te sàà‑nè cui stná‑nè), dandu có‑nâtùi‑ne cunduu‑ne nèhivì xí. ");
INSERT INTO mitNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nsidaa ana cuní dacácu xi vida‑xi, cutu ñà‑dandáñúhú‑nêàmà quea. Doco nú sàhà yùhù ndañuhu vida xi‑ne, dandu ñà‑sànì càcu ndisa‑ne nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Nú cudíì ini nèhivì xì palabra cachí mii‑nsiá, dandu davani queá na ian sànì xinindisá stná‑nè yùhù. Te nú sànì xinindisá‑né yùhù, dandu ñà‑sànì xinindisá stná‑nè mii‑yá ana nì techuun‑xí nduú stná. ");
INSERT INTO mitNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Te nú quixi iin nècuàchì profeta cáhàn cuenta xi Dios, te cudíì ini nèhivì xì palabra cachí‑nè, dandu dava‑ni nìhìtáhvì stná nèhivì mà nùù‑yá na ian nduú stná‑nè iin profeta. Te divi ducání stná xì ndéni tiàa nì cui vàha inì‑xi, nú cudíì ini nèhivì xì ñà‑ndùá cachí‑nè, dandu davani nìhìtáhvì stná‑nè nahi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dècuèndè, stná nèhivì chicá nduú nèhivì ùún, nú ni cuáha‑nsianè chii tècuìí coho‑ne sàhà‑ñá nchícùn‑nè yùhù, dandu seguru nìhìtáhvì stná‑nsià sàhámà nùù Dios ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nì nsihi nì sàcùnaha nèhivì dacuahá‑yá nansa quida‑ne, dandu cuàhàn mii‑yá ñà‑cacanuu‑ya ñuu te ñuu chinaha‑yà nèhivì, càhàn‑yà xì‑né ñà‑ndùú razón ndiaha xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Daaní, Juan, iá‑nè vehecàa, te nì xinitnùhu‑ne ñà‑ndiaha guá milagru quidá Cristu. Ñàyùcàndùá, nì techuún‑né iin ùì nèhivì dacuahá‑né ñà‑nì cúhùn‑nè nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ñàyùcàndùá, nì sàà nècuàchìmà nì ndàcàtnùhù‑né nùù‑yá, cachí‑nè: ―¿A ndísá mii‑ní nduú ana ndiaha icúmí quesaa, te ò inga ana vàxi cundiatu‑nsi? ");
INSERT INTO mitNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Dandu nì cachi‑yà xi nèhivì mà: ―Cuahán‑nsià cachitnùhu‑nsia xì Juan sàhà ñà‑ndùá iníní‑nsiá, xì ñà‑ndùá indéhe‑nsiá yohó, ");
INSERT INTO mitNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","nansa cuú xi nècuàchì cuaá, níhì‑né natùinuù‑né, te nèhivì xicá cuéhê, níhì stná‑nè nacaca viì‑né; te nèhivì nì xìhì cuñù‑xi, níhì‑né nduvàha‑ne; te nèhivì dòhò, níhì‑né natiacu‑nè; te nèhivì nì xìhì, ndanchító stná‑nè natiácú‑nè; te nèhivì ndahví, níhìtáhvì stná‑nè cunini‑ne razón ndiaha xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ñàyùcàndùá, nú cudíì ini nèhivì modo xi, dandu contentu icúmí‑nê cundoo‑ne ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Daaní, na sámànuhù nèhivì nì quixi ma, dandu nì quesaha Jesús cáhàn‑yà xì nèhivì sàhà Juan, te dohó nì cachi‑yà: ―Na ní caquee‑nsia ñuu‑nsià cuàhàn‑nsià yucù cundehè‑nsiá Juan, ¿a cuáhàn‑nsià cundehè‑nsiá iin nèhivì (tùha dàma dìnì‑xí) na iin yutnù ndóyo quidá tàchì? (Còó.) ");
INSERT INTO mitNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Doco nú coó, dandu ¿nansa iá‑nè cahan‑nsiá? ¿A nduú‑né iin nèhivì ndixí vico? Còó, vàchi nèhivì ndixí vico, vehe rey ndoó‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pues nú màdì dùcán, dandu ¿nansa iá nècuàchìmà cahan‑nsiá? ¿A iin profeta cáhàn cuenta xi Dios nduú‑né? Pues ñà‑ndáà nduá. Doco màdì cuísi profeta nduú‑né, vàchi chicá más ndiaá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Vàchi divi nècuàchìmà nduú ana cáhàn tutu ìì sàhà‑xí ndé (cachí Dios palabra yohó): Cunaha‑ní, cuàhìn techuín iin tiàa, te dihna‑ne yàha‑ne càhàn‑nè xì nèhivì ñà‑ndùú razón xi, te ducán (nsida viì‑né anima‑nè), na ian nduviì iin ichì, dandu después yàha stná mii‑ní (Cristu), cachí Dios nùù tutu mà. ");
INSERT INTO mitNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Te yùhù cachíˋ xì‑nsiá, nùù nsidaa nèhivì nì tùinuù‑xí ñuhìví, còò inga‑nè chicá nì quìdá ndiaha nùù Juan Bautista. Doco cachí stnâì xì‑nsiá, chicá ndiaha coo xi ana cuàhàn cuni tiempu cusáhnû mii‑yá iá ansivi, mate nèhivì ùún nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Cunaha‑nsiá, dècuèndè quìvì nì quesaha Juan Bautista cáhàn‑nè sàhù xì dècuèndè vichi, cuàhà gá nèhivì sáhandee fuerte ini‑nè ñà‑nìhì‑né cundoo‑ne ñuhìví ìì xí mii‑yá iá ansivi. Yáha ga sáhandee ini‑nè, te vàtùni sàcuàhàn cuàhà‑né níhìtáhvì‑né cundoo‑ne yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Vàchi antes cuàhà nècuàchì profeta nìsa cahàn cuenta xi Dios, nì cachitnùhu‑ne (sàhà tiempu dandacú‑yá). Stná ley (xi Moisés), nì cachitnùhu stnáˋ sàhámà. Te ducán nìsa ìa ndè cachi nì quesaa Juan (Bautista). ");
INSERT INTO mitNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Te cunaha‑nsiá, divi Juan mà nduú Elías (nì cachi nècuàchì sànaha) icúmí naxicocuíìn. Te nú cuní‑nsià, vàtùni mànìhì inì‑nsia sàhà ñà‑jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ni cúníní vàha nsidaa‑nsiá ñà‑ndùá cachíˋ xì‑nsiá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Dandu nì cachi tu‑ya: ―Cuàhìn cachì xì‑nsiá nansa quidá nèhivì tiempu vichi. Cunaha‑nsiá, dohó quidá‑né na ian quidá ñà‑cuati ndoó idádiquí ini iin ñuu, dava cána xì tnaha, cacháˋ: “Siví‑nsì, doco nsiohó, có‑ìtásáhá‑ndâ; daaní, xitó tàsi‑nsi, doco nsiohó, có‑sàcù‑ndá”. ");
INSERT INTO mitNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Te ducán iá stná xì Juan xì yùhù, vàchi nì quixi nècuàchìmà nìsa ìa‑ne yohó, cónì sáxíxí‑né comida vàha, ni cónì sáxíhí stná‑nè (vinu), ñàyùcàndùá nì cachi nèhivì sàhà‑né: “(Tè‑locó nduú‑te), sànì cundee ñà‑malu nùù‑té”. ");
INSERT INTO mitNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Daaní, nì quesaa stná yùhù ana nduú Tnaha Nèhivì Ñuhìví, te tùha stnáì cuxi comida vàha, te xihí (vinu), doco cachí stná nèhivì xìˊ ñà‑yáha ga ndadí, te cachí stná‑nè ñà‑tùhe coho cuahí, dècuèndè iá vàha stnáì xì tè‑dàchíyàhvi, xì stná nsidaa gá nèhivì cuáchi, cachí‑nè. Doco cunaha‑nsiá, nú ndisa ñà‑nchìchí ndiaha nduá quìdà‑ndà, dandu icúmí sàà‑mà cunahà claruà después. ");
INSERT INTO mitNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Daaní, nì quesaha Jesús chináhá‑yâ nèhivì ñuu ndé nì quida guá‑yà cuàhà milagru xi‑ya, doco cónì náxícócuîìn ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Dohó nì cachi‑yà: ―¡Ndahví nècuàchì ñuu Corazín! Te ¡ndahví stná nècuàchì ñuu Betsaida! Vàchi cuàhà milagru fuerte sànì xini‑nè (te cónì ndúlócô‑nè). Doco cunaha‑nsiá, nú ducání ni coó stná milagru mà ñuu Tiro ò ñuu Sidón nì cùí, dandísá, yàchì naxicocuíìn ini nècuàchì ñuu mà sàhà cuàchi‑ne, te nàcùndixi ndahví‑nè, te nàcùndoo stná‑nè mahì yàà tutnù, cunduamà seña ñà‑ndisa cuhí ini‑nè mii‑né sàhà cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Doco yùhù cachíˋ xì‑nsiá, chicá iyuhu castigu icúmí nìhì nèhivì ñuu Tiro mà xì nèhivì ñuu Sidón mà na sáà quìvì juiciu, te chicá fuerte coo castigu xi ñuu Corazín xi ñuu Betsaida. ");
INSERT INTO mitNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Daaní, stná nècuàchì ñuu Capernaum, mate tuxí ini‑nè nana ducún‑nè ndè gloria, doco còó, ndè andea icúmí‑nê nuu‑ne. Vàchi cuàhà milagru fuerte nì quida Dios ñuu‑nè (te cónì ndúlócô‑nè). Doco nú ducán nì quida‑ya milagru mà ñuu (malu) Sodoma, dandu iá ìì ñuu mà ñuhìví yohó nì cùí. ");
INSERT INTO mitNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Doco yùhù cachíˋ xì‑nsiá, chicá iyuhu castigu icúmí nìhì nècuàchì ñuu Sodoma‑mà na sáà quìvì juiciu, te chicá fuerte coo castigu xi nècuàchì ñuu Capernaum ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Daaní, quìvì yucán nì (naquimanì) Jesús Yua‑yá Dios, cachí‑yà: ―Yùhù ndeníhí vàhi mii‑ní, Yuamánìˊ; mii‑ní nduu‑ní Stoho ansivi xi ñuhìví, te palabra (ìì xí‑nî), sànì chitnùní inì‑ní ndòo dèháˋ nùù nècuàchì nchichí, doco nùù nècuàchì (nihnú ndáhví inì‑xi) nahi ñà‑cuati, sànì dàtnúù‑ní sàxìnítnùní‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ducán iá, vàchi ñà‑jaàn nduá nì chitnùní ini mii‑ní ―nì cachi‑yà xì Yuamánì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dandu nì cachi stná‑yà (xì nèhivì): ―Nùù Yuamánìˊ sànì nìhìtáhvìˊ dandacuí nùù nsidanicuú iñàha. Te còò ni‑iin nèhivì ináhá ndisa ana nduú yùhù, cuisì Yuamánìˊ Dios. Te mii‑yá, cuisì yùhù ináhî ana ndisa nduú‑yá, cuisì yùhù xì stná nèhivì cuníˋ cundaà inì‑xi sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Nahà‑nsia nùí, nsidaa mii‑nsiá nècuàchì cuhúún inì‑xi, te có‑cùndéé gâ inì‑xi, dandu nìhì‑nsiá ndòo dadí ndiaha inì‑nsia quide. ");
INSERT INTO mitNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","(Quida‑nsia ñà‑ndùá cachíˋ xì‑nsiá) na ian nsidá‑nsiá yugu‑xi quidáchúûn‑nsiá. Daaní, dacuahá stná‑nsià palabra vàha xi, vàchi yùhù, mànì inì, te ndahvi inì, vàtùni ndòo dadí ndiaha anima‑nsià quide. ");
INSERT INTO mitNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Te mate na ian nsidá‑nsiá yugu‑xi quidáchúûn‑nsiá nùí nduá, doco yugu ñama nduú‑nu, te chuun sáhi‑nsià, ñà‑mà úhì nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Daaní, iin quìvì descansu nì quìhvi Jesús iin itu, te nì yàha‑ya yucán, cutnáhâ stná‑yà xì nècuàchì dacuahá‑yá. Dandu nì xìhì‑nè doco. Ñàyùcàndùá, nì quesaha‑né nì casahnù‑nè sìcàyòcó nùnì trigu itá yucán, te nì saxì‑néà. ");
INSERT INTO mitNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Doco nècuàchì fariseu, nì xini‑nè ñà‑ndùá quidá nècuàchìmà, ñàyùcàndùá nì cachi‑nè xì‑yá: ―Cundehè‑ní nansa quidá nècuàchì dacuaha‑ní, quidá‑né iin chuun có‑sâha ley xi‑nda quida‑nda quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dandu nì cachi‑yà xì‑né: ―¿A cónì càhví‑nsiá (nùù tutu ìì) ndé cacháˋ nansa nì quida David na ní xìhì stná‑nè doco xi compañeru‑nè? ");
INSERT INTO mitNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Vàchi nì quìhvi‑ne ini veheñùhu xi Dios, te nì xixi‑ne dìtà vídì ìì yucán, mate ni mii‑né ni compañeru‑nè, có‑sâha ley mà cuxi‑neà, cuisì nècuàchì dùtù. ");
INSERT INTO mitNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Te ò inga casu, ¿a cónì càhví stná‑nsià nùù ley ìì nansa quidá dùtù quìvì descansu, quidá‑né (chuun ìì) ini veheñùhu, có‑chîvàha ndisa‑ne quìvì mà, doco màdì cuáchi nduá nùù‑né? ");
INSERT INTO mitNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Doco yùhù cachíˋ xì‑nsiá, yohó iá ana chicá ndiaá nùù veheñùhu xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","(Náhà xìcà) cumánì gá cundaà ini‑nsià sàhà ñà‑ndùá cachí Dios nùù tutu ìì. Vàchi dohó cachí‑yà: “Yùhù chicá cudíì inì ñà‑cundehè ndahví stnahá‑nsiá, te màdì ñá‑cuàha guá‑nsià yùhù promesa”, cachí‑yà. Nú ni sáà‑nsià cundaà ini‑nsià sàhájàn nì cùí, dandu mà dácuídâ cuàchi‑nsia nèhivì còò falta xi. ");
INSERT INTO mitNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Cunaha‑nsiá, yùhù ana nduú Tnaha Nèhivì Ñuhìví, dandacú stnáì sàhà nansa quida nèhivì quìvì descansu ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Daaní, nì quihin Jesús ichì cuàhàn‑yà veheñùhu, te nì quìhvi‑ya yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Te yucán iá stná iin tiàa nì ìchì dahuun iin ndahà‑xí. Doco veheñùhu ma ndoó stná nèhivì cuní daquée cuàchi dìquì‑yá, te sàháyùcàndùá nì cachi‑nè xì‑yá: ―¿Amádi cuáchi nduá dandúvàha‑nda nèhivì nú quìvì descansu nduá? ");
INSERT INTO mitNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Te nì cachi‑yà xì‑né: ―Ni cachí‑ndà iá iin riì xí‑nsiá, te sànì nacava‑sì xìchi, pues ¿amádi cúhùn‑nsià tavà‑nsiási xìchi ma, mate quívì descansu nduá? ");
INSERT INTO mitNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Cunaha‑nsiá chicá ndiaá iin tiàa nùù iin riì. Ñàyùcàndùá cundáà ini‑ndà, vàtùni iá ñà‑quida‑nda chuun viì quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dandu nì cachi‑yà xì tiàa ma: ―Chitanini‑ní ndahà‑ní. Dandu nì chitanini nècuàchìmà ndahà‑né, te momentu mà nì nduvàha dahuan nahi ñà‑inga mà. ");
INSERT INTO mitNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ñàyùcàndùá, nì caquee nècuàchì fariseu yucán, nì candatnuhu‑né nansa cui dandáñúhú‑nêyà. ");
INSERT INTO mitNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Doco ináhá‑yâ ñà‑ndùá ndatnúhú‑nê, ñàyùcàndùá nì quee‑ya lugar mà cuàhàn‑yà. Te nì tenchicùn stná cuàhà gá nèhivì. Te nì dàndúvàha‑ya nsidaa nècuàchì cuhí xi‑ne, doco nì chinaha‑yá nècuàchìmà ñà‑màsà cáchí‑nè xì nèhivì ana divi nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ducán nì cachi‑yà xì‑né sàhà ñà‑nì cùú ndisa ñà‑ndùá nì cachitnùhu Isaías sànaha na ní nacani‑ne palabra yohó nì (cachi Dios sàhà Dèhemanì‑yá): ");
INSERT INTO mitNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ana yohó nduú ana xinúcuáchí nùí, vàchi sànì nacàxin mii‑yá. Cuú ínì sàhà‑yá, te cudíì ínì sàhà nansa quidá‑yá. Nùù anima‑yà cuàhìn caquìn Espíritu Ìì xí, dandu cachitnùhu‑ya xì nèhivì nsidaa ñuu nansa iá modo ndiaha xí. ");
INSERT INTO mitNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mà náâ‑yà xì nèhivì, ni mà cácánúú‑yá calle ndàhì ndee‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Te nèhivì (yáha ndahví) na iin ndòò cuàhàn ndañuhu, mà cúcúú dana‑ya xì‑né. Còó. (Mànì gá) quida‑ya xì‑né na ian quidá nèhivì ni mà dándâhvà xì ñà‑có‑tnûù vàha. Te ducán icúmí cunduu modo xi‑ya dècuèndè cundee palabra vàha xi‑ya, te sàà‑yà cundee dahuun‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dècuèndè stná nèhivì inga raza, tnùndé ini xi mii stná‑nè cunduu‑ya, te divi quìvì mii‑yá icúmí‑nê ndacùcahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Daaní, ndacá‑né iin tiàa inácáá ñà‑malu anima‑xi vàxi nùù‑yá, te cuaá stná nècuàchìmà, te ihin stná‑nè. Dandu nì dàndúvàha‑ya nècuàchìmà, te nì nìhì‑né nì nacahàn‑nè, te nì natùi stná nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ñàyùcàndùá, nì ndulocó nèhivì cuáhà yucán, te nì ndàcàtnùhù‑né nùù‑né, cachí‑nè: ―¿A víhíní nduú Jesús (nècuàchì ndiaha) descendencia xi David (icúmí ndecunu)? ");
INSERT INTO mitNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Doco iníní nècuàchì fariseu nansa cachí nèhivì mà, ñàyùcàndùá nì cachi‑nè: ―Còó, vàchi ñà‑malu cusáhnû nani Beelzebú, divi nduú ana chindéé, te ducán tavá Jesús ñà‑malu. ");
INSERT INTO mitNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Doco ináhá‑yâ nansa nacání ini nècuàchìmà, ñàyùcàndùá nì cachi‑yà xì‑né: ―Nú ni táhndè dava nècuàchì xídandacú nùù iin ñuu, te náâ stnàhá‑né, dandu mà cúí dandacú gá‑nè nùù ñuu mà. Stná nèhivì ndoó ñuu mà, nú ni táhndè dava‑ne, mà cóó gà stná ñuu mà. Te ò nèhivì ndoó iin vehe, nú náâ stnàhá‑né, dandu mà cúí cundoo tàcá gà‑nè vehe ma. ");
INSERT INTO mitNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Te nú ducán ni cúndúú stná nacua cachí mii‑nsiá, ñà‑tàvá stnahá ñà‑malu xi Satanás, dandu ñà‑sànì tàhndè dava stná‑si cunduajàn nì cùí, mà cúí dandacú gá quisì cusáhnû má nùù tnaha‑sì, nú ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","’Mii‑nsiá, cachí‑nsià ñà‑chìndéé sì‑Beelzebú yùhù na taví ñà‑malu. Doco còó, vàchi nèhivì xí mii stná‑nsià, tùha stná‑nè tavà‑né ñà‑malu. Te ¿ana dìpódèr‑xi quidá‑néàmà? (Amádi poder xi Dios chindéé xí‑nê.) Ñàyùcàndùá, vàtùni cachi mii‑né xì‑nsiá ñà‑cónì càchí viì‑nsiá sàhí. ");
INSERT INTO mitNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Cunaha‑nsiá, Espíritu Ìì xí Dios nduú ana chindéé xî taví‑si, ñàyùcàndùá náhà xìcà, vichi sànì sàà tiempu cuni‑nsià nansa dandacú ndiaha mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Iin tiàa ndacuì, mà cúí quìhvi ndevàha nèhivì vehe‑tè nansa‑ni nì cui ñà‑tavà‑né ñà‑ìcúmí‑tê. Còó, vàchi dihna icúmí‑nê chicuhni‑nète, dandu vàtùni quida‑neàmà. ");
INSERT INTO mitNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Nsidaa ana có‑ìá favor xi, contra xi nduú‑né. Te nsidaa ana có‑chìndéé xî danátáquì nèhivì xí, ducán nduá na ian taxi‑né nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ñàyùcàndùá, yùhù cachíˋ xì‑nsiá, vàtùni cuicahnú ini Dios sàhà nsidanicuú cuàchi nèhivì, xì nsidanicuú modo cáhàn ùhí‑nè dìquì‑yá; doco nú ni cáhàn ùhí‑nè dìquì Espíritu Ìì xí‑yá, dandu mà níhì‑né cuicahnú ini‑yà sàhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mate ni cáhàn ùhí nèhivì dìquì yùhù ana nduú Tnaha Nèhivì Ñuhìví, doco vàtùni nìhì‑né cuicahnú ini Dios sàhà‑né. Doco nú dìquì Espíritu Ìì ni cáhàn ùhí‑nè, dandu mà nunca sàà‑yà cuicahnú ini‑yà sàhà‑né, ni tiempu ndoo‑nda ñuhìví yohó, te ni stná tiempu cundoo‑nda inga ñuhìví nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Nú ni cachí‑ndà vàha iin yutnù fruta, dandu cuní cachàmà vàha stná fruta sáha‑nù. Te nú ni cachí‑ndà còò chuun yutnù fruta mà, dandu cuní cachàmà ñà‑còò chuun stná fruta‑nu, vàchi sàhà fruta‑nu cundáà ini‑ndà a yútnu vàha nduú‑nu, ò á coó. ");
INSERT INTO mitNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Cunaha‑nsiá, nahi anima còò, ducán iá anima mii‑nsiá (nècuàchì fariseu), vàchi malu sàstnùhù‑nsiá. Ñàyùcàndùá, mà cùì cáhàn‑nsià ñà‑ìá viì. Vàchi cuisì ñà‑ñùhú chitu ini anima‑ndà nduá cáhàn‑ndà sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Iin nècuàchì vàha, cuàhà ñà‑vàha ñuhú ini anima‑nè, te ñàyùcàndùá divi palabra vàha ma nduá cachí‑nè. Doco iin nècuàchì malu, cuàhà ñà‑chìcuéhè ñuhú ini anima‑nè, ñàyùcàndùá, ñà‑chìcuéhè mà nduá cachí stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Te yùhù cachíˋ xì‑nsiá, na sáà quìvì juiciu, dandu icúmí nsidaa nèhivì nacuàha‑ne cuenta índù chuun nì cachi‑ne nsidaa palabra chicuéhè mà. ");
INSERT INTO mitNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vàchi nacua nì cachi‑nè yuhù‑né, divi ducán icúmí ndundaà sàhà‑né (nùù Dios), a cuáhàn‑nè càcu‑ne, te ò cuáhàn‑nè ndañuhu‑né ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Daaní, (nì sàà) dava maestru ley xi veheñùhu, xì stná dava nècuàchì fariseu, te nì cachi‑nè xì‑yá: ―Maestro, cuní‑nsì quida‑ní iin milagru fuerte cundehè‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dandu nì cachi‑yà xì‑né: ―Cuisì nèhivì malu te sìquini xícàn coo iin milagru cundehè‑né, a ndísá icúmí yùhù poder cahan‑né. Doco mà níhì‑né cundehè‑né inga milagru, cuisì ñà‑ndùá (nì xini nèhivì sànaha) na ní cuu milagru xi Jonás, iin profeta nìsa cahàn cuenta xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Vàchi na ian nì ndòo Jonás mà ini tìxi iin siaca cahnú ùnì ndui te ùnì ñuú, divi ducán icúmí cuu stná xì yùhù ana nduú Tnaha Nèhivì Ñuhìví, cunacaa stnáì tìxi ñuhù ùnì ndui te ùnì ñuú. ");
INSERT INTO mitNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","’Na quívì cuu juiciu, te màcuìta nsidaa nèhivì tiempu vichi (nùù Dios), dandu yucán icúmí màcuìta stná nèhivì ñuu sànaha nani Nínive, te daquée cuàchi‑ne dìquì nèhivì tiempu vichi, vàchi nèhivì ñuu mà, nì naxicocuíìn ini‑nè na ní càhàn Jonás xì‑né. Doco nèhivì vichi, còó, mate sánì quesaa ana chicá ndiaá nùù Jonás mà. ");
INSERT INTO mitNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Daaní, yucán icúmí nàcuììn stná nècuàchì ñahà reina nìsa dandacú nùù ladu sur sànaha. Te daquée cuàchi stná‑nè dìquì nèhivì tiempu vichi, vàchi dècuèndè iin ñuu chicá xica ní quixi‑ne ñà‑cunini‑ne cáhàn nchichí rey Salomón. Doco cunaha‑nsiá, vichi sànì quesaa ana chicá ndiaá nùù Salomón mà, (doco có‑ndùlócô nèhivì). ");
INSERT INTO mitNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Nú sànì quee iin ñà‑malu ini iin nèhivì, dandu xicánúú‑si yáha‑sì lugar ìchí, nandúcú‑sî ndé coo dadí‑si. Te nú nì cundaà inì‑si mà cùì, ");
INSERT INTO mitNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","dandu cachí‑si: “Còó, chicá vàha nùhì ini anima ndé nìsa ìe antes, vàchi vehi nduá”. Ñàyùcàndùá, mànuhù‑sí anima nèhivì mà, doco nú nì xinì‑si còò inga ana inácáá, dandu quidá‑si cuenta na ian sànì ndundoa, te nì nducutá. ");
INSERT INTO mitNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ñàyùcàndùá, cuàhàn‑si nácuàca‑sì inga ùsà tnaha‑sì chicá tùha quini, te quíhvi nsihi‑sì ini anima nècuàchìma ñà‑cuñuhu‑sì yucán. Sàhájàn, chicá pesadu nácòo‑ne nùù antes. Te cunaha‑nsiá, divi ducán icúmí cuu stná xì nèhivì malu tiempu vichi ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Cáhàn va Jesús xì nèhivì, te yucán nì sàà dihi‑yá xì stná ñani‑yà. Itá‑né tùvèhé, cuní‑nè càhàn‑nè xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dandu nì cachitnùhu iin nèhivì xì‑yá: ―Cunaha‑ní, tùvèhècàˊ iín mamá xi‑ní, xì stná ñanì‑ní; cuní‑nè càhàn‑nè xì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Dandu nì cachi Jesús xì nèhivì nì cachitnùhu ma: ―¿Ana divi nduú mamá xi (cahan‑ní)? Te ò ¿ana divi xínduu ñanì? ");
INSERT INTO mitNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dandu nì chitanini‑ya ndahà‑yá, nì quida‑ya señalar nsidaa nèhivì dacuahá‑yá mà, te nì cachi‑yà: ―Divi nècuàchì yohó xínduu nahi mamá xi, ò nahi ñanì. ");
INSERT INTO mitNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vàchi nsidanicuú ana quìdà‑xì ñà‑ndùá cuní Yuamánìˊ iá ansivi, divi mii‑né xínduu‑ne nahi ñanì, nahi cùhe, te nahi dihi stnáì. ");
INSERT INTO mitNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Daaní, divi quìvì yucán, nì quee Jesús vehe ma cuàhàn‑yà ndè yuhù mar. ");
INSERT INTO mitNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Te yucán nì nataca cuàhà gá nèhivì nùù‑yá: ñàyùcàndùá nì quècahnu‑ya ini iin lancha, te yucán nì sàcòo‑ya. Te nèhivì cuáhà mà, yuhù mar nì sàcùndoo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dandu nì dàcuàhá‑yánè cuàhà iñàha, nì nacani‑ya xì‑né cuàhà historia nduú nahi ejemplu. Te dohó nì cachi‑yà: ―Cunaha‑nsiá, nìsa ìa iin nècuàchì xìtú, te nì quee‑ne cuàhàn‑nè chihi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te nì sate uun‑ne tata mà. Te dava‑ña nì còya nùù ichì. Dandu nì quixi laa nì saxì‑síâ. ");
INSERT INTO mitNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te dava stná tata mà nì còya nùù cavà ndé còò cuáhà ñuhù. Te yàchì nì xìtià, vàchi có‑ndòó cucún ñuhù yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Doco na ní dùcàn orá, dandu nì xìxàn nì quida cahnì, te nì ìchà, vàchi cónì níhàˊ yohá. ");
INSERT INTO mitNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Daaní, dava stná tata mà, mahì iñù nì còya; te na ní sahnu iñù mà, dandu nì dàdáhvia viu cuati yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Doco dava stná tata mà, nùù ñuhù váha nì còya, te nì cuàha viá, ùhùn dico gà tantu nì cana, te ò dava ga‑ñà, ùnì dico ga tantu, te ò dava gà, òcò ùxìn gà tantu nì cuàha. ");
INSERT INTO mitNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ni cúníní vàha nsidaa‑nsiá ñà‑ndùá cachíˋ ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Daaní, nì catnàtuu nècuàchì dacuahá‑yá nùù‑yá, te nì cachi‑nè: ―¿Índù chuun puru ejemplu nacání‑nî xì nèhivì? ");
INSERT INTO mitNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Dandu nì cachi‑yà xì‑né: ―Mii‑nsiá, sànì nìhìtáhvì‑nsiá cundaà inì‑nsia nansa cuní cachi palabra sàhà ñuhìví ìì xí mii‑yá iá ansivi, mate antes nìsa ìa dèhé palabra mà. Doco nèhivì dava ga, cónì níhìtáhvì‑né mànìhì ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Vàchi nècuàchì sàñùhú (ñà‑vàha) inì‑xi, chicá más icúmí‑nê nìhìtáhvì‑né sàhà‑ñá cucumi‑né más gà. Doco nèhivì có‑ñùhú ndisa (ñà‑vàha) inì‑xi, dècuènde iyuhu (ñà‑vàha) sàñùhú ini‑nè, icúmíâ cuxio dahuan. ");
INSERT INTO mitNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ñàyùcàndùá, puru ejemplu cáhìn xì nèhivì yohó, vàchi mate indéhe cuáhà‑né, doco quidámáxìní‑nè; te mate iníní cuáhà stná‑nè, doco có‑sânìhì ini‑nè na ian doho‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ducán quidá‑né, te ducán sànì cuu ndisa stná ñà‑ndùá nì cachitnùhu Isaías sànaha (na ní tiaa‑ne palabra yohó nì cachi Dios): Mii‑nsiá, cuàhà gá icúmí‑nsiâ cunini‑nsia, doco mà sáà‑nsià mànìhì inì‑nsia. Te cuàhà gá icúmí‑nsiâ cundehè‑nsiá, doco mà cúndáà ndisa inì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Vàchi nsidaa nèhivì raza‑nsià yohó, quidámáxìní‑nè na ian ùhì tiacú‑nè. Te quidá‑né na ian danácuánì‑nè nùù‑né. Vàchi có‑cùní‑nè cundehè‑né (ichì yùhù), ni có‑cùní stná‑nè cunini‑ne, ni có‑cùní stná‑nè mànìhì ini‑nè, ni có‑cùní stná‑nè natnahnù‑nè ichì yùhù, te ducán nsida viìˊ anima‑nè, nì cachi Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Doco mii‑nsiá, ndiaha gá iá xì‑nsiá vichi, vàchi cundáà inì‑nsia sàhà ñà‑ndùá indéhe‑nsiá; sánìhì inì‑nsia sàhà ñà‑ndùá iníní‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Vàchi cunaha‑nsiá, cuàhà gá nècuàchì profeta sànaha, xì cuàhà gá más nèhivì xí Dios, nsidaa‑né nìsa cuni sàstnùhù‑né cundehè‑né ñà‑ndiaha íì sànì xininùù‑nsiá vichi, doco cónì níhìtáhvì‑né ducán. Yáha ga nìsa cuni‑nè cunini‑ne palabra ndiaha sànì inini‑nsia vichi, doco cónì níhìtáhvì‑né ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Vichi cunini vàha‑nsia, vàchi cuàhìn quide explicar nansa cuní cachi ejemplu sàhà nècuàchì xìtù‑mà. ");
INSERT INTO mitNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Cunaha‑nsiá, nú sànì xìtià ley xi ñuhìví ìì xí Dios, te iníní iin nèhivì, doco có‑cùndáà vàha ini‑nè sàhà‑ñá, dandu vàxi ñà‑malu, te dacúxíó‑si palabra xi Dios iá ini anima nècuàchìmà. Ñàyùcàndùá nacua nì cuu xi tata nì còyo yuhù íchî, ducán‑ní cuú xi stná nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Daaní, nahi tata nì còyo nùù cavà nduú nèhivì iníní xí palabra ìì, te vichi vichi cudíì gá ini‑nè sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Doco na ian cuú xi viu còò yohò‑xí, ducán cuú stná xì‑né; iyuhu gá quidándéé ini‑nè. Vàchi nú sànì yàha‑ne iin tnùndoho, ò nú sànì quida quini nèhivì xì‑né, dandu luegu naxícócuîìn ini‑nè, te nacóó‑né palabra mà. ");
INSERT INTO mitNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Daaní, nahi tata nì còyo mahì iñù nduú nèhivì iníní xí palabra xi Dios, doco cuàhà gá nacání ini‑nè sàhà vida xi‑ne ñuhìví yohó; cuàhà gá xího‑né coo cuica‑né; ñàyùcàndùá, dandahvíàmàné, te sadíàmà nùù palabra xi‑ya ini‑nè, mà cùì níhìndèè palabra mà chindeá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Daaní, nahi tata nì còyo nùù ñuhù vàha nduú nèhivì iníní xí palabra xi‑ya, te cundáà ini‑nè, te quidá ndisa‑neà cumplir; quidá‑né na iin viu nì cana viì, a sea cunduu‑ne nahi viu nì cana ùhùn dico tantu, te ò viu nì cana ùnì dico tantu, te ò ñá‑nì cana òcò ùxìn tantu. ");
INSERT INTO mitNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Daaní, nì nacani Jesús xì‑né inga ejemplu, te dohó nì cachi‑yà: ―Ley xi ñuhìví ìì xí mii‑yá iá ansivi, ducán iáˋ nacua nì cuu na ní chihi iin tiàa ñà‑ndùú tata vàha trigu itu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Doco iá iin tè‑xìní ùhì xì‑né, te na quídì‑nè, mii‑né xì nsidaa compañeru‑nè, dandu nì sàà tèmà nì chihi stná‑te tata yùcù chicuéhè mahì itu‑nèmà, te cuàhàn‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Daaní, nì xìtià viu cuati ma, nì sahnua, te nì cana sìcàyòcó‑ñà. Dandu nì natùi stná ñà‑ndùú yùcù chicuéhè mà. ");
INSERT INTO mitNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Te na ní caxini peón nansa iá, nì sàhàn‑te nì cachitnùhu‑tè xì lamú xi‑tè, cachí‑te: “Señor, amádi tata vàha nduá nì chihi‑ní itù‑nímà. Te ¿índù chuun nì xìtià guá yùcù chicuéhè?” ");
INSERT INTO mitNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Dandu nì cachi lamú mà xì‑té: “Divi tè‑xìní ùhì‑xìˊ nì quida xán”. Dandu nì cachi peón mà xì‑né: “¿A cuní‑nî cùhùn‑nsì tnuhu‑nsi yùcù mà?” ");
INSERT INTO mitNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","“Còó”, cachí‑nè, “Còtó tnuhu stná‑nsià viu. Chicá vàha ducání ni coá dècuèndè nú sànì sahnu ndúìà, te sà‑ìá ndanchito cosecha. Dandu quìvì mà cuàhìn cachì xì‑nsiá ñà‑dihna yùcù chicuéhè datacá‑nsià, cunuhnià manojo, te coca. Daaní después, (tàhndè viì) trigu, te nàcòovàha nùnìá”. ");
INSERT INTO mitNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Daaní, nì nacani tu‑ya xì‑né inga ejemplu, te dohó nì cachi‑yà: ―Ley xi ñuhìví ìì xí mii‑yá iá ansivi, ducán iáˋ nacua nì quida iin tiàa na ní chihi‑ne iin tata yutnù mostaza itu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tata mà nduú tata chicá cuati iá ñuhìví, doco nú sànì sahnua, yutnù nàhnú nduú‑nu, dècuèndè laa ndavá ansivi vàxi stná quidávàha tacà‑xi mahì‑nú. ");
INSERT INTO mitNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","’Ñuhìví ìì xí mii‑yá iá ansivi, ducán nduá nahi tàtnà nsidátáchí xí yusàn pan, vàchi divia nì quihin iin nècuàchì ñahà nì dàquée‑ne mahì ùnì maquila yusàn harina, te nì ndutachi nsihá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nsidaa palabra jaàn nì nacani‑ya xì nèhivì cuáhà yucán, vàchi cuisì‑ní ejemplu nì nacani‑ya xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ñàyùcàndùá, ducán nì cuu ndisa palabra nì cachitnùhu iin profeta sànaha na ní càhàn‑nè nì quida Dios, te dohó nì cachi‑nè: (Cachí Dios): cuàhà ejemplu cuàhìn nacani xì nèhivì. Cuàhìn datúi cuàhà iñàha nùù‑né, cuàhà palabra nì ìa dèhé dècuèndè nì sàcòo ñuhìví, nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Daaní, nì ndaquìndèè Jesús xì nèhivì cuáhà yucán, te nì nansìhvi‑ya vehe. Te nì catnàtuu nèhivì dacuahá‑yá, cachí‑nè xì‑yá: ―Cachì‑ní xì‑nsí nansa cuní cachi ejemplu sàhà yùcù chicuéhè iá itu mà. ");
INSERT INTO mitNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Dandu nì cachi‑yà xì‑né: ―Nècuàchì nì chihi xi tata vàha ma nduú yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Te itu mà nduú ñuhìví yohó. Te tata vàha ma nduú nèhivì cusáhnû Dios nùù‑xí, doco tata chicuéhè mà nduú nèhivì xí ñà‑malu. ");
INSERT INTO mitNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Te tiàa nì chihi tata chicuéhè mà, divi nduú ñà‑malu xiní ùhì xìˊ. Daaní, quìvì nì ndanchito cosecha mà, divi quìvì xìnu tiempu yohó nduá. Te peón nì ndanihi xi cosecha mà, divi nduú ángel xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Te nacua nì cuu xi yùcù chicuéhè mà, nì sàcùnuhnià, te nì xìxàn, ducán icúmí cuu stná (xì nèhivì malu) na xínu tiempu yohó. ");
INSERT INTO mitNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Vàchi yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî techuín ángel xi cùhùn‑nè tavà‑né nsidaa ana dàtúcù xì ñanìtnaha‑xi, xì nsidaa gá stná ana quìdà‑xì ñà‑có‑ndiàá, te mà cúndóó gá‑nè ñuhìví xi, ");
INSERT INTO mitNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","vàchi icúmí‑nê ndiachi‑né ini xìtnù ndé xíxìn ñuhu, te yucán icúmí‑nê cuacu fuerte‑nè, te càna nùhu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dandu icúmí sàà meru tiempu xi nèhivì ndàcuisì inì‑xi; ndiaha gá icúmí coo xi‑né, na ian ndiaha gá orá, ducán ndiaha coo xi‑né quìvì sàà Yua‑nda Dios cusahnú‑yá ñuhìví yohó. Ni cúníní vàha nsidaa‑nsiá ñà‑ndùá cachíˋ xì‑nsiá yohó. ");
INSERT INTO mitNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Ñuhìví ìì xí mii‑yá iá ansivi, ducán iáˋ nahi dìhùn cuáhà índùxin dèhé nùù iin ñuhù, te nì ndacùhun iin tiàa‑ña. Ñàyùcàndùá nì nachidèhé‑nèà, cudíì gá ini‑nè. Dandu mànuhù‑né nì dicò nsìhí‑né ñà‑ìcúmí‑nê, te nì sàhàn‑nè nì xiin‑ne ñuhù mà. ");
INSERT INTO mitNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Inga ejemplu. Ducán iá ñuhìví ìì xí‑yá nacua nì quida iin nècuàchì dìcó te nacuíín, nducú‑né sì‑diqui perla chicá vico cuiin‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Por fin nì tùi iin sì‑diqui chicá nsiaha. Ñàyùcàndùá nì sàhàn‑nè nì dicò nsìhí‑né ñà‑ìcúmí‑nê, te nì xiin‑ne sì‑diqui nsiaha ma. ");
INSERT INTO mitNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Inga ejemplu. Ducán iá ñuhìví ìì xí mii‑yá iá ansivi na iin ñunù chìcáá‑nè mahì mar, te quíhvi nsidanuu clase siaca inià. ");
INSERT INTO mitNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dandu nú sànì chituá, tavá‑néà yuhù mar, te nácùndoo‑ne nacàxin‑ne siaca ma. Siaca viì, nácòovàha‑sì ìcà sìcàté, te siaca chicuéhè, xítià‑si. ");
INSERT INTO mitNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Te divi ducán icúmí coo stná quìvì xìnu tiempu yohó. Icúmí caquesaa ángel xi Dios, te nacàxin‑ne nèhivì, cuaán cuita nèhivì malu, te cuaán cuita nèhivì vàha. ");
INSERT INTO mitNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dandu icúmí nèhivì malu mà ndiachi‑né ini xìtnù ndé xîxìn ñuhu, te yucán icúmí‑nê cuacu fuerte‑ne, te càna nùhu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dandu nì ndàcàtnùhù Jesús nùù nèhivì yucán: ―¿A sánì cundaà ini‑nsià sàhà nsidaájàn? ―Jaan, Stoho‑nsì Señor ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Dandu nì cachi‑yà: ―Iin nècuàchì cuàhàn chinaha xì ley ìì, nú sànì dàcuàhá vàha‑ne sàhà ñuhìví ìì xí mii‑yá iá ansivi, dandu (cuaha‑ni iá, vàchi ináhá‑nê ley sànaha, te ináhá stnâ‑nè ley saa), te ducán queé stnámà na iin tiàa ndoó vàha cuàhà traste xi, vàtùni tavà‑né iin ñà‑saa, te tavà stná‑nè iin ñà‑sànaha. ");
INSERT INTO mitNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nì nsihi nì nacani Jesús ejemplu jaàn, dandu nì quihin‑ya ichì mànuhù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Te na sánì nasaa‑yà ñuu‑yà, dandu cuàhàn‑yà veheñùhu, te nì quesaha‑yá dacuahá‑yá nèhivì yucán. Ñàyùcàndùá, nì ndulocó nècuàchìmà, cachí‑nè: ―¿Índù nì xini‑ndà nì cunchichí guâ nècuàchì yohó, te quidá stná‑nè milagru? ");
INSERT INTO mitNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Amádi déhe nècuàchì tùha yàcún yutnù nduú‑né, te dihi‑né nduú María, te ñani‑nè nduú Jacobo, xì José, xì Simón, xì Judas? ");
INSERT INTO mitNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Te cùha‑ne, yohó xíndoo stná‑nè ndé ndoo‑nda. Pues nú ducán, dandu ¿índù nì nìhìtáhvì guá‑nè quidá‑né ducán? Ñà‑jaàn nduá nì cacachi nèhivì, ");
INSERT INTO mitNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","vàchi nì cuduchi ini‑nè sàhà‑yá. Dandu nì cachi‑yà xì‑né: ―Iin ana cáhàn cuenta xi Dios, nú inga ñuu ni cáhàn‑nè, dandu siempre quidáñúhú nèhivì‑né yucán; doco nú ñuu mii‑né, ò vehe‑ne, còó, có‑quìdáñúhú nècuàchìmà‑né ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ñàyùcàndùá, mànìcùí quida‑ya milagru fuerte ñuu‑yàmà, vàchi có‑xìníndísâ‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Daaní, tiempu yucán nì xinitnùhu rey Herodes ñà‑cuàhà guá quidá Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Te nì cachì‑te xi nèhivì xí‑te: ―Ádi nsì‑Juan Bautista nduú Jesús, te sànì natiacu‑nè vichi, te ñàyùcàndùá quidá‑né cuàhà milagru ―nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Vàchi Herodes mà nduú ana nì chicadi xì Juan vehecàa. Ducán nì quida‑tè sàhà ñahàdìhí ñanì‑te Felipe nani Herodías. ");
INSERT INTO mitNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Vàchi nì cachi Juan xì‑té ñà‑có‑sâha Dios lugar coo‑tè xì ñahà mà. ");
INSERT INTO mitNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ñàyùcàndùá, cuní‑te cahnì‑ténê, doco yúhî‑te nèhivì ñuù‑te, vàchi quidá‑né cuenta ñà‑iin nèhivì yuhù núù Dios nduú nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Doco nì sàà quìvì nì naxìnu‑tè cuìà, te nì quida‑tè vicò. Te vicò mà nì ìtasaha dèhe Herodías mà nùù nèhivì (nì casaà) yucán, te cuàhà gá nì cudiì ini Herodes. ");
INSERT INTO mitNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ñàyùcàndùá, nì chinaha‑té Dios dacútâhvì‑téñâ ndéni iñàha nì cui ni cácàn‑ña. ");
INSERT INTO mitNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dandu (nì sàhàn‑ña) nùù dihi‑ñá, te nì sàcùnaha‑ñá (nansa càcàn‑ña), te ñàyùcàndùá nì cachì‑ña xi rey mà: ―Dìnì Juan Bautista cuníˋ taxi‑ní, cunacaà ini iin charola quixi. ");
INSERT INTO mitNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Dandu nì cuhuun ini rey mà, doco sàhà‑ñá sànì chinaha guá‑te Dios, te sàhà stná compañeru‑te ndoó indéhe yucán, ñàyùcàndùá nì dàndàcú‑te ñà‑nì còó nacua nì xìcàn ñahà chìì mà, ");
INSERT INTO mitNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","nì sàha‑tè orden, te nì quendodò dínì ndómà vehecàa. ");
INSERT INTO mitNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Te nihí nèhivì dìnì‑ndà nì nansìhvi ndé iá‑te, inácáà ini iin charola. Ñàyùcàndùá, nì tnii ñahà chìì mà‑ñá nì sàhàn nì sàha‑ñà dihi‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Dandu nì quixi nècuàchì nìsa dacuahá Juan nì ndanihi‑ne nsìi ma nì sùxin‑ne. Dandu cuàhàn‑nè cachitnùhu‑ne xì Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na ní nsihi nì inini Jesús, dandu nì quècahnu‑ya ini iin lancha, cuàhàn cuaán‑yá inì‑nu dècuèndè iin xaan ndé có‑ndòó nèhivì. Doco nì xinitnùhu nèhivì cuàhàn‑yà, te ñàyùcàndùá nì caquee stná‑nè ñuu‑nè nì tenchicùn‑nèyà ñuhù íchî. ");
INSERT INTO mitNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sàhámà (na ní sàà‑yà yucán), te nì quee‑ya nùù lancha mà, dandu nì xini‑yà ndoó cuàhà gá nèhivì. Te nì cuhi ini‑yànè; ñàyùcàndùá nì dàndúvàha‑ya cuàhà nècuàchì cuhí xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Te na ní cuaà, dandu nì catnàtuu nècuàchì dacuahá‑yá nùù‑yá, cachí‑nè: ―Vichi sàcuàhàn nì cuaà, te lugar yohó, còò ni‑iin vehe. Ñàyùcàndùá ndaquìndèè‑ní xì nèhivì ni cúhùn‑nè ñuu cuati yatni cuiin‑ne ñà‑cutiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Doco nì cachi‑yà xì‑né: ―Còò necesidad cùhùn‑nè inga xaan; mii‑nsiá dacuxí‑nsiánè. ");
INSERT INTO mitNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dandu nì cachi‑nè: ―Cuisì ùhùn pan nihí‑nsí, xì ùì siaca. ");
INSERT INTO mitNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Te nì cachi‑yà: ―Cunihi‑nsiañà quixi. ");
INSERT INTO mitNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dandu nì dàndàcú‑yá ni mácùndoo nsidaa nèhivì yucán nùù yùcù cuati. Te nì tnii‑ya ùhùn pan mà xì ùì siaca, te nì ndacoto ndiaá‑yà dìquì‑xí, nì naquimanì‑yá Dios sàhà‑ñá. Dandu nì dàcuàchí‑yáñà nì sàha‑ya nècuàchì dacuahá‑yá, te mii‑né, nì dasàn‑néà nùù nsidaa nèhivì ndoó yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Te nsidaa‑né nì xixi‑ne nì ndenuu ini‑nè. Te pedazu nì ndòo ga nì chitu ùxìn ùì ìcà. ");
INSERT INTO mitNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pues cunaha‑nsiá, nsidaa nèhivì nì xixi ma, nahi ùhùn mil tiàa nì sanduu‑ne, te cuaán nduú stná nècuàchì ñahà xì ñà‑cuati. ");
INSERT INTO mitNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Vichi duha nì cachi Jesús xì nècuàchì dacuahá‑yá ñà‑nì mácùñuhu‑ne ini lancha te cùhùn cuèé‑nè nùù‑xí yàha‑ne inga ladu mar, doco mii‑yá, cuàhàn‑yà danácuîtià‑yà nèhivì cuáhà yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Te na sánì ndaquìndèè‑yá xì nsidaa nèhivì mà, dandu nì nana cuaán‑yá iin yucù nì càhàn‑yà xì Yuamánì‑yá Dios. Daaní, na ní cuñaà, iá mindaa‑yá yucù yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Doco lancha mà, sàcuàhàn‑nu dava mahì mar, te cuàhà gá sànì nacuahnu todò tècuìí. Ñàyùcàndùá ndé ndiàchì nìhní‑nu, vàchi yáha ga ndee caná tàchì ladu nùù‑nú. ");
INSERT INTO mitNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Daaní, sinduhá nì sàà‑yà yucán xicándódo‑yá nùù tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Doco na ní caxini‑nè vàxi‑ya, nì cayùhí cuàhà‑né, te nì càna ndee‑né, cachí‑nè: ―¡Duma nduá! ");
INSERT INTO mitNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Doco vichi vichi nì cachi‑yà xì‑né: ―Nacuàhandee inì‑nsia, vàchi yùhù nduí. Màsà yúhî‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dandu nì cachi Pedro xì‑yá: ―Stoho‑nsì Señor, nú divi nduu‑ní, cachì‑ní xìˊ caqui nùù tècuìí sàì ndé vàxi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Dandu nì cachi‑yà xì‑né: ―Nahà‑ní. Ñàyùcàndùá, nì nuu Pedro nùù lancha mà nì quesaha‑né nì xìcandodò stná‑nè nùù tècuìí cuàhàn‑nè ndé vàxi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Doco na ní xini‑nè ñà‑ndee guá caná tàchì, dandu nì yùhí‑nè, te nì quesaha‑né cuàhàn‑nè càhà‑nè ini tècuìí mà nì cùí. Ñàyùcàndùá, nì ndàhì ndee‑né, cachí‑nè: ―¡Stoho‑nsì Señor, dacácu‑ní yùhù! ");
INSERT INTO mitNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dandu vichi duha nì chitanini‑ya ndahà‑yá nì tnii‑yanè, te nì cachi‑yà xì‑né: ―Iyuhu gá xiníndísá‑nî. Chicá vàha màsà cóó‑nî xì duda. ");
INSERT INTO mitNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dandu nì nana‑ya lancha, mii‑yá xì stná Pedro. Te vichi duha nì cucuiìn tàchì. ");
INSERT INTO mitNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Te nì tnàtuu nsidaa nècuàchì ñuhú ini lancha mà nì sàcuìtasisi‑né nùù‑yá, cachí‑nè: ―¡Ndisa, Dèhemanì Dios nduu‑ní! ");
INSERT INTO mitNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Daaní, na sánì yàha‑ya xì‑né mar mà, dandu nì sàà‑yà ñuhù íchî iin ñuu nani Genesaret. ");
INSERT INTO mitNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Te nì nacuni nèhivì ñuu mà‑yá, te nì cachitnùhu‑ne xì nsidaa gá nèhivì ladu yucán. Ñàyùcàndùá, yucán nì casaà cuàhà‑né nùù‑yá ndacá‑né nsidaa nècuàchì cuhí xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Te nì sacundahví‑nè nùù‑yá áma cuáha‑ya dùcùn ndahà úún‑né siquiera orilla sìcoto xi‑ya. Te nsidaa nèhivì nì dùcùn ndahà‑xí ducán, nì nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Daaní, ñuu Jerusalén nì caquee dava nècuàchì fariseu, xì dava stná nècuàchì ley xi veheñùhu vàxi‑ne, te nì casaà‑nè nùù Jesús. Te nì cachi‑nè xì‑yá: ");
INSERT INTO mitNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Nècuàchì dacuahá mii‑ní, ¿índù chuun có‑quìdá‑né estilu xi xìì‑ndà? Vàchi na cuáhàn‑nè cuxi‑ne, có‑ndàhá‑né (nacua cachí estilu xi‑nda). ");
INSERT INTO mitNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Dandu nì cachi‑yà xì nècuàchìmà: ―Te mii‑nsiá tu, ¿índù chuun có‑quìdá stná‑nsià ñà‑ndùá nì dàndàcú Dios? Vàchi iladu nacóó‑nsiá ley xi‑ya, te chívàha‑nsia ñà‑ndùú estilu xi mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Vàchi dohó nì cachi‑yà: ni coó tnùñuhu xi‑nda nùù yuadíhí‑ndá. Te nú ni cáhàn ùhì iin nèhivì dìquì iin yuadíhí‑nê, dandu icúmí‑nê cui‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Doco mii‑nsiá, tucu quidá‑nsiá, vàchi cachí‑nsià vàtùni cachi iin nèhivì xì yuadíhí‑nê: “Mà cùì chindeí mii‑nsiá xì ñá‑ndùá icúmî, vàchi sànì cachì sàhà nsidaámà ñà‑ndùá dìhùn ìì”. ");
INSERT INTO mitNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Te nú ducán sànì cachi nècuàchìmà, dandu còò cá obligación icúmí‑nê ñà‑chindee‑né yuadíhí‑nê, cachí‑nsià. Ñàyùcàndùá, sàhà estilu xi‑nsiamà iladu sànì nacoo‑nsia ley nì cachi Dios, te cuisì estilu xi mii‑nsiá chívàha‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Ndahví‑nsià! ¡Vàha ga‑nsià cahan‑nsiá, doco dananí úún‑nsiá! (Náhà xìcà) ñà‑ndácuisì nduá nì cachitnùhu Isaías sàhà‑nsiá sànaha na ní tiaa‑ne ñà‑ndùá nì cachi Dios, te dohó nì cachi‑yà: ");
INSERT INTO mitNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nèhivì yohó, yuhù‑né quidáñúhú‑nê yùhù. Doco ini anima‑nè, còó, vàchi xica iéˋ cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Cahvi‑né yùhù tuxí‑né, doco có‑ndiàáˋ, vàchi nèhivì ùún nduú ana nì quidavàha xi ley chináhá‑nè nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dandu nì cana Jesús nèhivì cuáhà mà ñà‑tnàtuu‑ne nùù‑yá, te nì cachi‑yà xì‑né: ―Cunini vàha‑nsia, te cundaà ini‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mà cúnsídá cuàchi nèhivì sàhà ni‑iin ñà‑xìxí‑né; còó. Doco palabra queé yuhù‑né na cachí‑nè iñàha, ñà‑jaàn ndisa dacuidá cuàchi xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dandu nì nataca nècuàchì dacuahá‑yá nùù‑ya, te nì cachi‑nè: ―Cunaha‑ní, cudúchí ini nècuàchì fariseu sàhà ñà‑ndùá nì cachì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dandu nì naxiconihí‑yá nùù‑né, cachí‑yà: ―(Có‑quìdámà), vàchi nú iá iñàha ñuhìví yohó có‑ndùú ñà‑nì chitnùní ini Yuamánìˊ iá ansivi, dandu icúmíâ ndañuhá na ian ndañuhu yùcù tnuhu‑nda itu. ");
INSERT INTO mitNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nacóó‑nsiá nècuàchì fariseu mà, vàchi quidá‑né na ian quidá iin nècuàchì cuaá cuní dacúndéhe xi inga nècuàchì cuaá ichì. Te (ináhá‑ndá) nú ducán ni quida‑nda, cutu sáà‑ndà dacóyo nihni stnaha‑nda xìchi. ");
INSERT INTO mitNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Dandu nì cachi Pedro xì‑yá: ―Nacani‑ní xì‑nsí nansa cuní cachi ejemplu nì cachì‑ní (xì nècuàchìmà). ");
INSERT INTO mitNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dandu nì cachi‑yà xì‑né: ―¿A có‑cùndáà stná ini mii‑nsiá? ");
INSERT INTO mitNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A có‑ìnáhá‑nsiâ nansa cuu‑xi comida xixi‑nda, quéa yuhù‑ndà, dandu yáha ndè tìxi‑nda, te después quea? ");
INSERT INTO mitNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Doco palabra queé yuhù‑ndà, divi ñà‑ñùhú ini anima‑ndà nduá. Te divi ñà‑jaàn ndisa dacuidá cuàchi xi anima nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vàchi ini anima‑nè ñuhú cuàhà cuàchi, te divi sàhámà nacání quini guá ini‑nè, te sahní stnahá‑né, te ò cáhàn‑nè xì inga nècuàchì có‑ndùú nècuàchì vehe‑ne, te ò iá‑nè xì ndéni nèhivì ní cui mate tà nándàhà‑né. Te divi sàhà ñà‑ndùá ñuhú ini anima‑ne, ñàyùcàndùá xího stná‑nè quida cuihna‑né, te cuní‑nè dandahví stnahá stná‑nè, ò cáhàn quini‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Divi cuàchi jaàn nduá dacuidá cuàchi xi anima nèhivì, doco ñà‑có‑ndàhà‑ndà na xixi‑nda, có‑dàcuìdá cuàcha‑ndó. ");
INSERT INTO mitNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Dandu nì quee Jesús ladu yucán cuàhàn‑yà ladu ñuu Tiro xì ñuu Sidón. ");
INSERT INTO mitNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Te yucán nì tnàtuu iin nècuàchì ñahà raza cananeu nùù‑yá, ndáhì‑nè, cachí‑nè xì‑yá: ―Señor, mii‑ní nècuàchì descendencia xi David, cundehè ndahví‑nî yùhù, vàchi yáha ga fuerte dandohó iin ñà‑malu dèheyoquí. ");
INSERT INTO mitNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Doco Jesús, cónì náxícóníhî‑yá nùù nècuàchìmà. Dandu nì catnàtuu nècuàchì dacuahá‑yá, cachí‑nè xì‑yá: ―(Quida‑ní favor xícàn‑nè), dandu taxi‑nínè, vàchi ndé cuñáñá‑nsî ñà‑ndáhì guá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dandu nì cachi‑yà (xì nècuàchì dacuahá‑yá): ―Cuisì nùù nècuàchì raza‑ndà Israel nì techuún Dios yùhù càhàn xìˊ, vàchi nahi riì nì tùcù xínduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dandu nì tnàtuu nècuàchì ñahà mà nì sàcuììn sìsì‑né nùù‑yá, cachí‑nè xì‑yá: ―Chindee‑ní yùhù, Señor mío. ");
INSERT INTO mitNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Dandu nì cachi‑yà xì‑né: ―(Ùhì quide ñà‑ndùá xícàn‑ní, vàchi) có‑ndùá ducán dacúxíó‑ndá dìtà nùù dèhe‑nda, te cuàha‑nda sìhina cuati. ");
INSERT INTO mitNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Doco nì cachi‑nè xì‑yá: ―Ñà‑ndáà nduá Señor. Doco cunaha‑ní, dècuèndè stná sìhina cuati, níhì stná‑si iyuhu xèhè dìtà cóyo tìxi mesa xi stohò‑si. (Ñàyùcàndùá, chindee sacu stná‑ní yùhù.) ");
INSERT INTO mitNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dandu nì cachi‑yà xì‑né: ―Cuàhà gá xiníndísá‑nî. Ñàyùcàndùá, ducán ni coó nacua xícàn‑ní. Ñàyùcàndùá, divi hora jaàn nì nduvàha dèheyoco‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Dandu nì quee Jesús ladu yucán cuàhàn‑yà ichì mar de Galilea. Te na nchícùn‑yà ichì mà, nì nana‑ya iin yucù nì sàcòo‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Te cuàhà ga nèhivì nì nataca nùù‑yá yucán, ndacá‑né nècuàchì cuhí xi‑ne, xínduu‑ne nècuàchì xicá cuéhê, xì nècuàchì cuaá, xì nècuàchì ìhìn, xì nècuàchì cuhí ndahà‑xí, vàchi cuàhà gá cuèhè ndohó‑né. Te nì chitànduhù‑ñánê nùù‑yá, te nì dàndúvàha‑yanè. ");
INSERT INTO mitNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ñàyùcàndùá, nì ndulocó nèhivì cuáhà mà na ní xini‑nè nansa nì cuu nì nacahàn nècuàchì ìhìn, te nì nduvìtá ndahà nècuàchì cuhí ndahà‑xí; stná nècuàchì xicá cuéhê, nì nacaca viì stná‑nè, te nì natùinuù stná nècuàchì cuaá. Te nèhivì nì xini mà, cuàhà gá nì naquimanì‑né Dios ñà‑cuàhà guá sànì chindee‑yá nèhivì ñuu‑nè Israel. ");
INSERT INTO mitNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Daaní, nì cana‑ya nècuàchì dacuahá‑yá ñà‑tnàtuu‑ne nùù‑yá, te nì cachi‑yà xì‑né: ―Cuhí inì nèhivì yohó, vàchi vichi sàcuàhàn‑ndà ùnì quìvì ndoó‑né cutnáhâ‑né xì‑ndà yohó, te còò cá ñà‑cuxi‑ne. Te có‑cùníˋ nacuitià‑nè nùhù‑nè nú tàñáha ga cuxi‑ne, vàchi vihini cuìtá‑nè ichì núhù‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dandu nì cacachi nècuàchì dacuahá‑yá: ―Doco ¿índù nìhì‑ndà ñà‑cutiacu‑nè ñà‑cuàhà guá‑nè? vàchi yucù nduá yohó. ");
INSERT INTO mitNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Te nì ndàcàtnùhù‑yá nùù‑né: ―¿Nadaa pan nihí‑nsiá? ―Ùsà‑ñà xì iin ùì siaca cuati ―cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dandu nì dàndàcú‑yá ni mácùndoo viì nsidaa nèhivì mà ñuhù. ");
INSERT INTO mitNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Te nì tnii‑ya ùsà pan xì stná siaca ma, te nì naquimanì‑yá Dios sàhà‑ñá, dandu nì dàcuàchí‑yáñà nì sàha‑ya nècuàchì dacuahá‑yá, te mii‑né, nì dasàn‑néà nùù nèhivì cuáhà mà. ");
INSERT INTO mitNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Te nì xixi nsidaa‑né nì ndenuu ini‑nè. Dandu después nì dàtàcá‑nè ùsà canasta nì chitu ñá‑nì cuyodò gá. ");
INSERT INTO mitNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cunaha‑nsiá, nsidaa nècuàchì tiàa nì xixi ma, cùmì mil nì sanduu‑ne, te cuaán nduú nècuàchì ñahà xì stná ñà‑cuati. ");
INSERT INTO mitNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Daaní, nì dànácuîtià‑yà nèhivì mà, te nì nana tu‑ya iin lancha cuàhàn‑yà dècuèndè ladu ñuu Magdala. ");
INSERT INTO mitNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Dandu nì quixi nècuàchì fariseu xì nècuàchì saduceu, te nì xìcàn‑nè ñà‑nì quìdá‑yá iin milagru cundehè‑né, te cundua seña cudíì ndisa ini Dios sàhà‑yá. Ducán nì xìcàn‑nè, áma níhìndèè‑né daquée cuàchi‑ne dìquì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Doco mii‑yá, nì cachi‑yà xì‑né: ―Nú nì cuaà, te cuahá laa ansivi, dandu cachí‑nsià: “Seña nduá ñà‑ìcúmí cuun dàvì”. ");
INSERT INTO mitNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Daaní, dàtnàà tu, nú color cuahá iá ansivi, te ndiaha gá itá vìcò, dandu cachí‑nsià: “Vàxi dàvì vitni”. ¡Ndahví‑nsià! Dananí uun‑nsia nchichí‑nsià, vàchi mate vàtùni nacuni‑nsià seña iá ansivi, doco mà cùì nacuni stná‑nsià índù tiempu nduá vichi. ");
INSERT INTO mitNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","’Nèhivì tiempu vichi, malu cuàhà‑né, vàchi có‑càhvì sàhnú víi gá‑nè Dios, cutu milagru‑ni xícàn‑nè cundehè‑né. Doco mà níhì‑né cundehè‑né milagru cuní‑nè, cuisì milagru nì cuu xi Jonás sànaha ―nì cachi Jesús. Dandu nì nacoo‑yanè cuàhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dandu nì caquee nècuàchì dacuahá‑yá, cuàhàn‑nè (xì‑yá) inga ladu mar yucán. Doco nì nandòdó‑né cunihi‑ne pan cùhùn. ");
INSERT INTO mitNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Dandu nì cachi‑yà xì‑né: ―Cundehè‑nsiá, cuidadu gà ni cúndóó‑nsiá sàhà tàtnà nsidátáchí xí pan xi nècuàchì fariseu xì stná nècuàchì saduceu. ");
INSERT INTO mitNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dandu nì quesaha‑né ndatnúhú‑nê, cachí‑nè: ―Ádi sáhà ñà‑còò pan nihi‑nda vàxi, ñàyùcàndùá cachí‑yà xì‑ndà ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Dandu nì cundaà ini‑yà ñà‑ndùá ndatnúhú‑nê, ñàyùcàndùá nì cachi‑yà xì‑né: ―Mii‑nsiá, iyuhu gá xiníndísâ‑nsiá. Có‑xìñùhù ndatnuhu‑nsiá sàhà‑ñá còò pan nihí‑nsiá vàxi. ");
INSERT INTO mitNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yùhù xiníˋ tàñáha ga cundaà inì‑nsia. ¿A có‑nsìnúú inì‑nsia sàhà ùhùn pan (nì xixi) ùhùn mil tiàa, te nadaa ga ìcà pedazu pan nì ndòo nì dàtàcá‑nsià? ");
INSERT INTO mitNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Te ¿a có‑nsìnúú gá stná inì‑nsia sàhà ùsà pan nì xixi cùmì mil nèhivì, te nadaa ga ìcà pedazu pan nì ndòo stná? ");
INSERT INTO mitNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Xiñuhu cundaà ini‑nsià ñà‑màdì pan ndisa cáhìn sàhà‑xí na ní cachì xì‑nsiá ñà‑nì càquín‑nsià cuidadu sàhà ñà‑nsìdátáchí xí pan xi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dandu nì sàà nècuàchì dacuahá‑yá nì cundaà ini‑nè sàhà ñà‑ndùá nì cachi‑yà, màdì ñá‑nsìdátáchí xí pan ndisa nduá cáhàn‑yà sàhà‑xí. Còó, sàhà ley chináhá nècuàchì fariseu xì nècuàchì saduceu, divi nduá cáhàn‑yà sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Daaní, cuàhàn Jesús xì nècuàchì dacuahá‑yá ndè ladu ñuu Cesarea de Filipo. Te nì ndàcàtnùhù‑yá nùù‑né, cachí‑yà: ―Yùhù ana nduú Tnaha Nèhivì Ñuhìví, ¿índù nècuàchì nduí cachí nèhivì? ");
INSERT INTO mitNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Te nì cachi‑nè xì‑yá: ―Dava‑ne cachí‑nè Juan Bautista nduu‑ní, te dava‑ne, Elías nduu‑ní, cachí‑nè. Daaní, dava tu‑ne cachí‑nè ñà‑ndùù‑ní Jeremías, te ò inga profeta sànaha nì sacahàn cuenta xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dandu nì cachi‑yà xì‑né: ―Doco mii‑nsiá, ¿ana nduí cachí‑nsià? ");
INSERT INTO mitNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Dandu nì cachi Simón Pedro xì‑yá: ―Divi Cristu Dèhemanì Dios iá nicanicuahàn nduu‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dandu nì cachi‑yà xì‑né: ―¡Nansicáhán mii‑ní, Simón dèhe Jonás! vàchi màdì nèhivì ñuhìví yohó nì dàtnúù ini xì‑ní ñà‑nì cundaà inì‑ní ducán. Còó, divi Yuamánìˊ iá ansivi nduú ana nì dàtnúù xì sàxìnítnùní‑nî. ");
INSERT INTO mitNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Te yùhù cachíˋ xì mii‑ní, Pedro, ñà‑ìcúmí‑nî cunduu‑ní na iin cavà fuerte ndé cuàha iin vehe. Te vehe‑ma cundua nahi nèhivì‑xí icúmí danátáquì. Te mate (ni queé) nsihi ñà‑malu yehè andea (quixa), doco mà sáà cundeá nùù ana xínduu tàcá nèhivì xí. ");
INSERT INTO mitNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Vàchi cuàhìn daníhìtáhvìˊ mii‑ní (ñà‑sàhà palabra cachí‑nî) icúmí yàha nèhivì ndè ñuhìví ìì xí Dios, na ian cucumi‑ní ndahà cáa xán. Te nú cachì‑ní xì‑né ñà‑nsìdá cuàchi ndisa‑ne, dandu cundiaa stná palabra mà ndé (iá Dios) ansivi. Te ò nú ni cachí‑nî xì‑né ñà‑màdì cuáchi nduá sànì quida‑ne, dandu divi cundiaa stná mà ndè ansivi ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dandu nì sàcùnaha nsidaa nècuàchì dacuahá‑yá mà ñà‑màsà cáchí‑nè xì nèhivì ñà‑ndùú‑yá Cristu (nì quixi dìquì‑xí). ");
INSERT INTO mitNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Daaní, quìvì yucán nì quesaha‑yá cachítnùhu‑ya xì nècuàchì dacuahá‑yá nansa icúmí cuu xi‑yá na sáà‑yà ñuu Jerusalén. Icúmí‑yâ ndoho cuahà‑yá, nì cachi‑yà xì‑né, vàchi ducán icúmí quida nècuàchì sahnú dandacú, xì stná dùtù xícusahnú, xì nècuàchì ley xi veheñùhu. Te nú sànì xìhì‑yà, dandu icúmí‑yâ natiacu‑yà tìxi ùnì quìvì. ");
INSERT INTO mitNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dandu nì tavà cuaán Pedro‑yà, te nì càhàn duchi ini‑nè xì‑yá, cachí‑nè: ―Cahnú gà Dios, màsà nunca cuu xi‑ní ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Doco nì naxiconihí‑yá nùù‑né, cachí‑yà: ―¡Cuxio‑ní nùí, vàchi nahi ñà‑malu Satanás nduu‑ní, te quidá quíní‑nî xìˊ! Cuisì chuun xi nèhivì ñuhìví yohó nduá nihnú inì‑ní, màdì chuun xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dandu nì cachi‑yà xì nècuàchì dacuahá‑yá: ―Nsidaa ana cuní cunchicùn xìˊ, xiñuhu nacoo‑ne ñà‑ndùá cuní inì‑ni mii‑né quida‑ne, te quida‑ne cuenta na ian nsidá stná‑nè cruz xi‑ne cutnáhâ‑né xìˊ ñà‑cui stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Vàchi nsidaa ana cuní dacácu xi vida xi, ñà‑dandáñúhú dahuun‑ne mii‑né nduá. Doco nú ni cuí‑nè sàhí, dandu ñà‑sànì càcu ndisa vida xi‑ne nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Vàchi mate ni níhì iin nèhivì nsidaa ñà‑ìá ñuhìví, doco ni mà sáà‑mà cundua ñà‑vàha xi‑ne nú màsà sáà stná anima‑nè càcua nùù Dios. Còó. Te ò nú ni cuní stná iin nèhivì nacuiin‑ne anima‑nè, còó, mà cúí. ");
INSERT INTO mitNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","’Yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî naxicocuíìn, cutnahá stnáì xì cuàhà ángel xi. Te ndiaha gá icúmí coo tnùñuhu xí, nahi tnùñuhu xí Yuamánìˊ. Dandu nsidandaì sàhà nsidaa nèhivì ñuhìví, según nansa nì quida iin iin‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Te cunaha‑nsiá, dava mii‑nsiá nècuàchì itá yohó, mà cúí‑nsià dècuèndè cuni‑nsià nansa coo quìvì naxicocuíìn yùhù ñuhìví yohó cusahnúí. ");
INSERT INTO mitNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Daaní, na ní yàha ìñù quìvì, dandu nì saca Jesús Pedro xì Jacobo, xì ñani Jacobo nani Juan, cuàhàn cuaán‑yá xì‑né ndè dìnì iin yucù ducún. ");
INSERT INTO mitNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Te yucán nì nadàma‑ya, tucu nì nàcùnahà‑yà nì xini nècuàchìmà, vàchi nì natnuù nihni fuerte nùù‑yá nahi orá, te nì nanchiì cuxín yaa stná sìcoto xi‑ya nahi nduà orá. ");
INSERT INTO mitNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dandu nanàá nì xini stná‑nè jaàn sànì ndecoyo stná nèhivì (sànaha) nani Moisés xì Elías, ndatnúhú‑nê xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dandu nì cachi Pedro xì‑yá: ―Stoho‑nsì Señor, ¡nansicáhán‑ndá ndoo‑nda yohó! Chicá vàha quidavàha‑nsi ùnì siahva, nú cuní‑nî; ian coo mii‑ní, ingà coo Moisés, te ingà coo stná Elías. ");
INSERT INTO mitNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Meru cáhàn Pedro ducán, te nì dàhvi nsidaa‑né mahì iin vìcò nchií ndiaha. Dandu nì tiacu‑nè cáhàn iin ana cáhàn mahì vìcò mà, cachí‑yà: ―Dèhemaní nduú ana yohó, te cudíì inì sàhà‑yá. Ñàyùcàndùá cunini‑nsia ñà‑ndùá cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Daaní, na ní inini nècuàchì dacuahá‑yá palabra mà, dandu nì tutuyuhu nsidaa‑né ñuhù, vàchi nì yùhí cuàá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dandu nì tnàtuu Jesús nùù‑né, te nì chituu‑ya ndahà‑yá ìcà‑né, cachí‑yà: ―Vàtùni ndacuìta‑nsia; màsà yúhî gà‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Dandu nì ndacoto‑ne inicutu, te nì xini‑nè, còò cá iin, ndé làcà mii Jesús iá yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Daaní, nì naquihin‑ya ichì mànuu‑ya xì‑né yucù yucán. Te ichì mà nì chinaha‑yánè, cachí‑yà xì‑né: ―Màsà nácání‑nsiá xì nèhivì ñà‑ndùá nì xini‑nsià vichi dècuèndè nú sànì natiacu yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dandu cachí‑nè xì‑yá: ―Nú ducán, dandu ¿índù chuun cachí nècuàchì ley xi veheñùhu ñà‑dihna icúmí naxicocuíìn Elías? ");
INSERT INTO mitNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dandu nì cachi‑yà xì‑né: ―Ñà‑ndáà nduá, dihna icúmí Elías naxicocuíìn‑nè, te nsidaviì‑né nsidaa chuun có‑ìá viì. ");
INSERT INTO mitNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Doco cunaha‑nsiá, sànì quixi nècuàchìmà, doco nì nacuaà nèhivì‑né, nì quida ndevàha‑ne xì nècuàchìmà nacua cudíì ini‑nè. Te ducán icúmí‑nê dandohó stná‑nè yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dandu nì sàà nècuàchì dacuahá‑yá nì cundaà ini‑nè ñà‑divi Juan Bautista cáhàn‑yà sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nì nsihi nì nasaa‑yà xì‑né ndé ndoó cuàhà nèhivì, dandu ndacá nècuàchìmà iin tiàa nì quesaa nùù‑yá. Te nì sàcuììn sìsì tiàa ma nùù‑yà, ");
INSERT INTO mitNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","cachí‑nè: ―Señor, cundehè ndahví sacù‑ní dèhi, vàchi cuàhà gá xichi xíhì ìhí‑te. Yáha ga ndohó‑te, vàchi cuàhà xichi nduá‑te mahì ñuhu xì mahì tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ñàyùcàndùá, ndaquí‑te nì quixi nùù nècuàchì dacuaha‑ní, doco mànì cùí dandúvàha‑nète. ");
INSERT INTO mitNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dandu nì cachi‑yà xì‑né: ―Mii‑nsiá, mà túha‑nsia cunindisá‑nsiá; ni có‑sâà‑nsia cundaà inì‑nsia. ¿Nadaa ga quìvì icúmî coi xì‑nsiá, te quidandee gá stná inì sàhà‑nsiá? Pues cundaca‑nsiàte quixi nùí. ");
INSERT INTO mitNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dandu (nì saca‑nète vàxi nùù‑yá), te nì dàndàcú‑yá nì sadi‑yà nùù ñà‑malu mà, te nì quea cuàhàn. Te nì nduvàha nchito‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Daaní, después na iá cuaán‑yá xì nècuàchì dacuahá‑yá, dandu nì catnàtuu‑ne nùù‑yá, cachí‑nè xì‑yá: ―¿Índù chuun mànìcùí tavà nsiùhù ñà‑malu mà? ");
INSERT INTO mitNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Dandu nì cachi‑yà xì‑né: ―Sàhà‑ñá iyuhu guá xiníndísâ‑nsiá, ñàyùcàndùá mànìcùí. Vàchi ñà‑ndáà nduú palabra cachíˋ xì‑nsiá yohó: nú xiníndísâ ndisa‑nsia, mate (iyuhu nduá) nahi tata cuati yutnù mostaza, dandu vàtùni dandacú‑nsiá nùù yucù jaàn, te cachi‑nsià xán: “Cuxio iladu”, te seguru icúmí cuu ducán, vàchi nsidanicuú iñàha cui quida‑nsia, nú xiníndísâ‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Doco ñà‑malu tnaha quisì nìsa inacaa ini tèchii ma, có‑quèé yáchà, cuisì nú ni cácàn tàhvì‑nsiá nùù Dios, te cunihiì dócô‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na iá va‑ya ladu Galilea, nì cachi‑yà xì nèhivì xicánúú xí‑yá: ―Yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî yàhi ndahà nèhivì (malu), vàchi iá iin tiàa cuàhàn cahin xìˊ nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Dandu cahnì‑né yùhù; doco tìxi ùnì quìvì icúmî natiacuì ―nì cachi‑yà. Te nèhivì dacuahá‑yá, cuàhà gá nì nàcùndoo‑ne tnùnsí ini sàhámà. ");
INSERT INTO mitNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Daaní, na ní sàà‑yà xì‑né ñuu Capernaum, dandu nì tnàtuu tè‑xícàn xì cuota nùù Pedro, cachí‑te: ―¿A có‑chîyàhvi maestru xi‑nsia cuota xi‑ne? ");
INSERT INTO mitNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","―Jaan ―cachí Pedro. Dandu nì quìhvi‑ne ini vehe (ndé iá‑yà). Te dihna‑ya nì càhàn‑yà xì‑né, cachí‑yà: ―¿Nansa tuxí inì‑ní, Simón? ¿Nansa quidá rey ñuhìví yohó? ¿A núù nèhivì xí mii‑té tavá‑te cuota xi‑tè, te ò núù nèhivì tùcù (dandacú‑te nùù‑xí)? ");
INSERT INTO mitNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Dandu nì cachi Pedro: ―Divi nùù nèhivì tùcù. Dandu nì cachi‑yà xì‑né: ―Nú ducán nduá, dandu nèhivì xínduu nèhivì xí rey, còò obligación icúmí‑nê, ¿á ma ndisá? ");
INSERT INTO mitNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Doco sàhà‑ñá có‑cùní‑ndà cuduchi ini ni‑iin nèhivì sàhà‑ndà, ñàyùcàndùá cuahán‑nî mar yucù siaca, te quisì primeru nìhì‑ní, nacuna‑ní yuhù‑sí, te tavà‑ní dìhùn inácáá mà. Dandu cunihi‑níà cùhùn chiyàhvi‑ní nùù nècuàchìmà, vàchi vàtùni sàà mà sàhà ndúì‑ndà ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Daaní, hora yucán nì tnàtuu nècuàchì dacuahá‑yá nùù‑yá, te nì ndàcàtnùhù‑né: ―¿Ana chicá ndiaá nùù nsidaa nèhivì ñuhìví ìì xí mii‑yá iá ansivi? ");
INSERT INTO mitNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dandu Jesús, nì cana‑ya iin tètii, te nì chicani‑yàte mahì nsidaa‑né, cachí‑yà xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","―Palabra ndàcuisì nduá cachíˋ xì‑nsiá yohó; nú màsà náxícócuîìn ini‑nsià, te nàcùnihnu viì inì‑nsia na iin ñà‑cuati, dandu mà sáà‑nsià ñuhìví ìì xí mii‑yá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ñàyùcàndùá, iin nèhivì, nú nihnú ndáhví ini‑nè nahi tètii yohó, pues divi‑ne nduú ana chicá ndiaá ndé nduú ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te nú sàhà yùhù quidáñúhú nèhivì iin tètii nahi tèyòhó, dandu davani queá na ian yùhù quidáñúhú‑nê. ");
INSERT INTO mitNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Nú ni datúcù iin nèhivì iin ñà‑cuati xiníndísá‑xî, ¡ndahví‑nè! Vàchi chicá vàha màcùndiacu iin yùù yódò dùcùn‑né, te ndiachi‑né mahì mar cunú sàhà‑ñá màsà dátûcù gà‑nè iin ñà‑cuati. ");
INSERT INTO mitNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ndahví nèhivì ñuhìví datúcù xì ñanìtnaha‑xi! Vàchi mate fuerza cuàhàn tùcù dava‑ne, doco yáha ga ndahví tiàa dìsáhà‑xí túcù‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Te ò nú sàhà ndahà‑nsiá ò sáhà‑nsiá xidá cuàchi‑nsia, dandu chicá vàha nì táhndèà, te dacaná‑nsiáñà, vàchi chicá nsiaha (sàà‑nsià nùù Dios), te cutiacu‑nsià nicanicuahàn, mate sánì ndañuhu iin ndahà‑nsiá, ò iin sàhà‑nsiá, te màdìá coo nsihi‑nsia, te ndiachi‑nsiá ndé xîxìn ñuhu nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te nú sàhà nduchìnúù‑nsiá quidá‑nsiá cuàchi, dandu chicá vàha tavà‑nsiáñà dacaná‑nsiá, vàchi chicá nsiaha (sàà‑nsià nùù Dios) xì mindaa nduchìnúù‑nsiá, te cutiacu‑nsià nicanicuahàn, te màdìá xì ndúìà, dandu después icúmí‑nsiâ ndiachi‑nsiá ndé xîxìn ñuhu andea. ");
INSERT INTO mitNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Màsà nunca cahíchì inì‑nsia iin ñà‑cuati nahi tèyòhó, vàchi cachí ndàì xì‑nsiá, ndè ansivi ndoó ángel (ndiaá) xán, te nicanicuahàn ndoó tùha‑ne nùù Yuamánìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Vàchi yùhù ana nduú Tnaha Nèhivì Ñuhìví, nì quesaì ñuhìví yohó ñà‑dacácui ana cuàhàn ndañuhu ni cuí. ");
INSERT INTO mitNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Nansa tuxí inì‑nsia quida iin tiàa nú ndoó iin cientu riì xí‑né, te nì tùcù iin‑sì? ¿Amádi nácóó‑né 99 quisì dava ga mà yucán ndé (xixáhan‑sì) yucù yucán, te cùhùn‑nè nanducu‑né quisì nì ndañuhu ma? ");
INSERT INTO mitNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Te nú sànì natùi‑sì, dandu cudíì gá ini‑nè. Ndè chicá cudíì ini‑nè sàhà quisì yucán nùù nsidaa gá quisì cónì túcù mà. ");
INSERT INTO mitNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pues ducán iá stná xì nèhivì nahi ñà‑cuati yohó, có‑cùní Yuandiaha‑nsiá iá ansivi ndañuhu ni‑iin‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Nú ni quidá iin ñanìtnaha‑nsia iin cuàchi nùù iin‑nsia, dandu nècuàchì nì quida quini‑ne nùù‑xí, xiñuhu tavà cuaán‑ñánê iladu, te ndatnuhu víi‑né xi nècuàchìmà. Te nú ni quihín casu nècuàchìmà, dandu ñà‑sànì dàcácu tnahá‑né nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Doco nú có‑quìhín casu nècuàchìmà, dandu xiñuhu cuaca‑ne iin ò úì gà nèhivì sàhà ñà‑cunduu‑ne testigu cundaà vàha inì‑xi nansa ndisa iá chuun. ");
INSERT INTO mitNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Doco nú ni‑xi ñà‑jaàn có‑cùní‑nè, dandu ni cúhùn‑nsià nùù nsidaa nèhivì natácá càhvì xì Dios. Te nú iin‑ni có‑cùní‑nè quihin casu‑nè nsidaa nèhivì mà, dandu ni cúnàhá chuun ma, te quida‑nsia cuenta na ian nècuàchì siùmí nduú‑né, te ò iin ana nì cuchicuehe dahuun anima‑xi. ");
INSERT INTO mitNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ñà‑ndáà nduá cachíˋ xì‑nsiá yohó: nú cachí‑nsià xì nèhivì ñà‑nsìdá cuàchi ndisa‑ne, dandu cundiaa stná palabra mà ndé (iá Dios) ansivi. Stná palabra cachí‑nsià xì‑né ñà‑màdì cuáchi nduá sànì quida‑ne, divi cundiaa stná mà ndè ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Te cachí stnáì xì‑nsiá, mate cuísi ùì‑nsià ndoó, doco nú iin‑ni sànì cachi ndúì‑nsià cuàhàn‑nsià càcàn tàhvì‑nsiá iñàha nùù Yuamánìˊ iá ansivi, dandu icúmí‑yâ quida‑yañà, ndéni chuun nì cui ni cúndúá. ");
INSERT INTO mitNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Vàchi nú sànì nataca‑nsià mate úì ò únì‑nsià iin‑ni xaan, te ndácùcahan‑nsiá quìví, dandu yucán icúmí coo stnáì cutnahí xì‑nsiá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dandu nì tnàtuu Pedro nùù‑yá, cachí‑nè: ―Stoho‑nsì Señor, ¿nadaa xichi icúmî cuicahnú inì sàhà iin ñanìtnahi nú nì quida‑ne cuàchi nùí? ¿A ndéˋ ùsà xichi, ò nadaa xichi? ");
INSERT INTO mitNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","―Còó ―cachí Jesús xì‑né― màdì cuísi ùsà xichi, cachíˋ. Dècuèndè (yáha ga cuàhà tantu) ñà‑jaàn xiñuhu cuicahnú inì‑ní sàhà‑né, mate 70 tantu gà nùù ùsà xichi ni cúndúá. ");
INSERT INTO mitNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ñàyùcàndùá, ducán iá stná ñuhìví ìì xí mii‑yá iá ansivi nacua nì cuu na ní dànáyàha iin rey nsidaa cuenta xi nèhivì nduú peón xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nì natavà víi‑né cuenta, te nì cana‑ne iin peón iníhícá cuàhà millón pesu nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Doco còò ni‑iñàha icúmí‑tê ñà‑danáà‑té. Ñàyùcàndùá, nì dàndàcú rey mà ñà‑nì cúyàhvi‑tè, mii‑té, xì ñahàdìhí‑te, xì dèhe‑tè, xì nsidanicuú stná traste xi‑tè sàhà‑ñá tùi dìhùn danáà‑té. ");
INSERT INTO mitNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Doco nì tutuyuhu‑té ñuhù nùù sàhà rey mà nì sacundahví‑te nùù‑né, cachí‑te: “¡Señor! Quida sacù‑ní favor xìˊ, cundiatu tahvì gá‑nî yùhù, dandu danáà nsìhí”. ");
INSERT INTO mitNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ñàyùcàndùá, nì cuhi ini rey mà‑té, te nì nacoo‑nète, nì dàndùtù nsìhí‑né ñà‑ndùá iníhícá‑tê. ");
INSERT INTO mitNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Doco nì quee cuisì‑té nùù rey mà, te nì sàhàn‑te nì nanducu‑té inga peón nduú compañeru‑te, vàchi iníhícá stná nècuàchìmà iin cientu dìhùn plata nùù‑té. Te nì tnii nihni tnuu tehe‑té dùcùn‑né nì cachì‑te xi‑né: “Danáà dahuun ñà‑ndùá iníhícó nùí”. ");
INSERT INTO mitNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dandu nì tutuyuhu stná nècuàchìmà ñuhù nùù sàhà‑té nì sacundahví‑nè nùù‑té, cachí‑nè: “Quida sacù‑ní favor xìˊ cundiatu tahvì gá‑nî yùhù, dandu danáà nsìhí”. ");
INSERT INTO mitNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Doco còó, cónì cùní‑te. Nì sanicuàchi‑tè sàhà‑né nì chicadì‑tené dècuèndè danáà nsìhí‑né ñà‑ndùá iníhícá‑nê. ");
INSERT INTO mitNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Doco na ní xini dava ga peón nduú compañeru‑te, cuàhà gá nì cuduchi ini‑nè. Ñàyùcàndùá, nì sàhàn‑nè nì nacani‑ne xì rey mà ñà‑ndùá nì quida‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sàhámà tucutu nì cana rey mà‑té nì cachi‑nè xì‑té: “¡Peón malu ndùù‑yó! Vàchi yùhù, nì xicahnú inì sàhù; nì dàndùtù nsìhí ñà‑ndùá nì ìníhícó, vàchi ducán nì sacundahvú núìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿A có‑ndìá ìcà stnáù cuhi inù compañeru nacua nì quide xì miun?” nì cachi rey mà. ");
INSERT INTO mitNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cunaha‑nsiá, yáha ga nì xìdà ini‑nè, ñàyùcàndùá nì dàyáha‑nète ndahà tè‑dàndòhò‑xì nèhivì ñà‑coo‑tè ndahà‑témà ndè cachi danáà nsìhí‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Pues ducán icúmí quida stná Yuamánìˊ iá ansivi xi mii‑nsiá nú có‑cùní‑nsià cuicahnú ndisa ini‑nsià sàhà ñanìtnaha‑nsia ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Daaní, na ní nsihi nì cachi Jesús ducán, nì quee‑ya ladu Galilea cuàhàn‑yà ndè inga ladu yùte Jordán ndé nduú stná ladu Judea. ");
INSERT INTO mitNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Te cuàhà gá stná nèhivì nì tenchicùn xì‑yá nì sàà stná‑nè yucán. Ñàyùcàndùá nì dàndúvàha‑ya nècuàchì cuhí xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Dandu nì catnàtuu nècuàchì fariseu nùù‑yá nì càhàn‑nè xì‑yá áma níhìndèè‑né daquée cuàchi‑ne dìquì‑yá. Te dohó nì cachi‑nè xì‑yá: ―(¿Nansa cachí‑nî?) ¿A vátùni cate‑ndà ñahàdìhí‑ndà nansa ni nì cui? ");
INSERT INTO mitNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Te nì cachi‑yà xì‑né: ―Ádi sánì cahvi‑nsia nùù tutu ìì ndé cacháˋ nansa nì quidayucun Dios nèhivì primeru, iin‑ne nì sàcùnduu tiàa, te inga‑nè ñahà. ");
INSERT INTO mitNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Te nì cachi stná‑yà ñà‑jaàn nduá dìsáhà‑xí nándàhà iin nècuàchì tiàa xì iin nècuàchì ñahà, te quecuáân‑né nùù yuadíhí‑nê. Ñàyùcàndùá, mate diín diín nì sanduu‑ne antes, doco vichi na imindaa nèhivì sànì nanduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sàhámà có‑ndùú gá‑nè diín diín nèhivì; còó, vàchi quida‑nda cuenta na ian imindaa nèhivì nduú‑né. Ñàyùcàndùá, nú ducán sànì dàcuàcátnáhâ Dios‑nè, dandu ni‑iin nèhivì màsà cáté stnàhá‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dandu nì cachi nècuàchì fariseu xì‑yá: ―Pues nú ducán, dandu ¿índù chuun nì cachi Moisés iá permisu, vàtùni cuàha‑nda ñahàdìhí‑ndà iin tutu cachí cuàhàn‑ndà cate‑ndàñá, dandu nacoo‑ndañá? ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","―Còó ―cachí‑yà―; sàhà ñà‑có‑cùní‑nsià cunini viì‑nsiá, ñàyùcàndùá nì sàha Moisés permisu cate stnàhá‑nsiá. Doco na ní quesaha ñuhìví, còó, màdì dùcàn nìsá ìa. ");
INSERT INTO mitNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Te yùhù cachí stnáì xì‑nsiá, cuàchi ndisa nduá nú ni caté iin nècuàchì tiàa ñahàdìhí‑nè, te coo‑ne xì inga nècuàchì ñahà. Doco nú sànì càhàn ñahàdìhí‑nè xì inga tiàa, dandu màdì cuáchi cunduu ñà‑cate‑nè ñahàdìhí‑nèmà. Te nú ni nándàhà stná iin nècuàchì tiàa xi iin nècuàchì ñahà nì sate stnàhá, divini cuàchi cunduu stná mà. ");
INSERT INTO mitNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dandu nì cachi nècuàchì dacuahá‑yá xì‑yá: ―Nú ducán (ùhì) iá chuun sàhà iin ñahàdìhí‑ndà, dandu chicá vàha màsà nándàhà‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Dandu nì cachi‑yà xì‑né: ―Cunaha‑nsiá, màdì nsidaa nèhivì sáà mànìhì inì‑xi sàhà ñà‑ndùá nì cachì jaàn, cuisì nèhivì sànì nìhìtáhvì mànìhì inì‑xi. ");
INSERT INTO mitNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","’Dava nèhivì, có‑ìá nsihi iquìcúñú‑nè, vàchi ducán nì cacu‑ne, ñàyùcàndùá, có‑nândàhà‑né. Daaní, dava nèhivì, có‑ìá nsihi‑ne sàhà‑ñá ducán nì quida nèhivì xì‑né. Daaní, dava stná‑nè cuisì sàhà‑ñá (cudíì ini‑nè quida‑ne) chuun xi ñuhìví ìì xí Dios, ñàyùcàndùá có‑cùní‑nè nandàhà‑né. Nú ni sáà‑nsià mànìhì ini‑nsià palabra yohó, vàtùni, (te nú còó, pues mà cúndáà inì‑nsia). ");
INSERT INTO mitNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Daaní, ndacá nèhivì ñà‑cuati vàxi nùù‑yá ñà‑chitàndòó‑yá ndahà‑yá dìnì‑vé, te càcàn tàhvì‑yá nùù Dios sàhà‑vé. Doco nècuàchì dacuahá‑yá, nì sadi‑nè nùù nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ñàyùcàndùá nì cachi‑yà xì‑né: ―Nacoo‑nsia ñà‑cuati ni quixá nùí. Màsà cádí‑nsià nùá, vàchi nsidaa ana nihnú inì‑xi nahi ñà‑cuati, divi cunduu ana sàà ñuhìví ìì xí mii‑yá iá ansivi ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dandu nì chitàndòó‑yá ndahà‑yá dìnìá, te cuàhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Daaní, nì sàà iin tèchii nùù‑yá, te nì cachì‑te xi‑yá: ―Maestro, mii‑ní vàha ndisa‑ní. Cachì‑ní xìˊ índù obra vàha quide, te nìhìtáhvìˊ vida ndiaha nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dandu nì cachi‑yà xì‑té: ―¿A ndísá (cuní‑nî) càhàn‑ní xì yùhù sàhà índù iñàha nduú ñà‑vàha? Vàchi còò ni‑iin nèhivì ùún vàha ndisa, cuisì nú nduí Dios, dandu vàha ndisa inì. Doco nú cuní‑nî nìhìtáhvì‑ní vida ndiaha, dandu chivàha‑ní ñà‑ndùá dandacú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dandu nì cachi tèmà: ―¿Índù ñà‑càchí‑yà icúmî chivàhi? Te nì cachi Jesús: ―Divi ñà‑màsà cáhni stnaha‑nda, ni màsà cáhàn‑ndà xì inga ana có‑ndùú nècuàchì vehe‑nda, ni màsà quídá cuíhná‑ndá, ni màsà cáchí stná‑ndà ni‑iin tnùhu sàhà ñanìtnaha‑nda. ");
INSERT INTO mitNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Te ni coó tnùñuhu xi‑nda nùù yuadíhí‑ndá; te nacua cuú íní‑ndà sàhà mii‑nda, divi ducán icúmí‑ndá cuu stná ini‑ndà sàhà ñanìtnaha‑nda. ");
INSERT INTO mitNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dandu nì cachi tèchii ma xi‑yá: ―Cunaha‑ní, nsidaájàn sànì chivàhi dècuèndè na tíî. ¿Índù iñàha cumánì gá quide? ");
INSERT INTO mitNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dandu nì cachi‑yà xì‑té: ―Nú ndisa cuní‑nî cunduu‑ní iin ana vàha ndisa, dandu cuahán‑nî dicò nsìhì‑ní ñà‑ndùá icúmí‑nî, te dasàn‑ní dìhùn mà nùù nècuàchì ndahví; dandísá nìhìtáhvì‑ní cucumi‑ní cuàhà ñà‑cuìcà iá ansivi. Te quixi‑ní cunichicùn stná‑ní yùhù ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Daaní, na ní inini‑tè ñà‑jaàn, dandu yáha ga nì cuhuun inì‑te, vàchi cuica cuáhà‑té. Ñàyùcàndùá nì quihin‑tè ichì mànuhù‑té. ");
INSERT INTO mitNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dandu nì cachi Jesús xì nècuàchì dacuahá‑yá: ―Ñà‑ndácuisì nduá cachíˋ xì‑nsiá: Ùhì sàstnùhù sàà iin tècuìcà ñuhìví ìì xí mii‑yá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Te ùhì gà stná dayáha‑nda iin camellu nùù chìcòhò ndúhu íqui, doco ñà‑chicá ùhì nduú ñà‑yàha iin tècuìcà ndè ñuhìví ìì xí Dios ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Na ní inini nècuàchì dacuahá‑yá ñà‑jaàn, dandu yáha ga nì ndulocó‑nè, te nì cachi‑nè iin‑ne xì inga‑nè: ―Pues nú ducán nduá, dandu ùhì ndisa càcu anima iin nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dandu nì indehè váha Jesús‑nè, te nì cachi‑yà: ―Nèhivì ñuhìví, mà cúí quida‑neàmà. Doco Dios, vàtùni, vàchi nsidaa iñàha, mà úhì quida‑yañà. ");
INSERT INTO mitNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dandu nì cachi Pedro xì‑yá: ―Nsiùhù, sànì nacoo‑nsi nsidaa ñà‑ndùá icúmí‑nsî, te vàxi‑nsi nchícùn‑nsì mii‑ní, Stoho‑nsì Señor. Ñàyùcàndùá, ¿índù iin ñà‑vàha icúmí‑nsî nìhì‑nsí? ");
INSERT INTO mitNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dandu nì cachi‑yà xì nsidaa‑né: ―Cunini‑nsia palabra ndàcuisì yohó: na sáà tiempu ndusaa nsidaa ley ñuhìví, dandu yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî nàcòi nùù silla ndiaha xí. Te daa cunduu quìvì nìhìtáhvì stná nsì‑úxìn ùì mii‑nsiá, màcùndoo stná‑nsià nùù iin iin silla vico ma, te dandacú‑nsiá nùù nsidaa descendencia xi nsì‑úxìn ùì dèhe Israel. ");
INSERT INTO mitNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Daaní, nú sàhà yùhù sànì nacoo iin nèhivì iñàha, dandu iin cientu gà tantu ñà‑jaàn icúmí‑nê nìhìtáhvì‑né. Mate icúmí‑nê nacoo‑ne vehe‑ne, ò ñani‑nè, ò cúha‑ne, ò yua‑né, ò dihi‑né, ò ñahàdìhí‑nè, ò déhe‑ne, ò ñuhù xí‑né sàhà yùhù, có‑quìdámà, vàchi iin cientu gà tantu icúmí stná‑nè nìhìtáhvì‑né, te nìhì stná‑nè vida ndiaha nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Doco cuàhà nèhivì idónuu vichi, icúmí‑nê sàà‑nè natenchicùn‑nè ndè cahà‑xí quìvì yucán. Te cuàhà ana nchícùn cahà‑xí vichi, icúmí‑nê nàcòdònùù‑né nùù‑xí. ");
INSERT INTO mitNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Ducán iá ñuhìví ìì xí mii‑yá iá ansivi nacua nì quida iin lamú, naha nì quee‑ne cuàhàn‑nè nducu‑né peón caquidachuún nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","(Te na ní tùi‑tè), dandu nì ndòo‑ne ñà‑chiyàhvi‑ne iin dìhùn plata quìvì, ñàyùcàndùá nì techuún‑nète ñà‑cacuhùn‑te quidachuún‑te itu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Daaní, nahi càhíìn nì quee tu‑ne cuàhàn‑nè yàhvi, te yucán nì xini‑nè itá uun itnii gá tiàa. ");
INSERT INTO mitNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ñàyùcàndùá nì càhàn‑nè xì‑té áma cúhùn stná‑te quidachuún‑te itu‑nè, te quiyàhvi stná‑te iyuhu nacua ndiá ìcà. Ñàyùcàndùá, nì dàndáà stná‑te cuàhàn‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Daaní, tucu tu nì quee‑ne nahi càxíhúì, te yucán nì nìhì tú‑né iin ùì gà peón; stná càhúnì nì cuaà, ducán nì quida stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Daaní, nahi càhúhùn tucu tu nì quee‑ne nì xini tu‑ne itá úún más gà tiàa yucán, ñàyùcàndùá, nì cachi‑nè xì‑té: “¿Índù chuun ndui yacá itá úún‑nsiá?” ");
INSERT INTO mitNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Te nì cacachì‑te xi‑né: “Divi sàhá còò iin taxi xi chuun quida‑nsi”. Dandu nì cachi‑nè xì‑té: “Pues cuahán stnâ‑nsià quidachuún stná‑nsià ituì, te quiyàhvi stná‑nsià nacua ndiá ìcà”. ");
INSERT INTO mitNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Daaní, na ní cuaà dahuun, dandu nì cachi lamú mà xì tiàa dandacú nùù nsidaa peón mà: “Cana‑ní nsidaa‑té ni quixí‑te quiyàhvi‑tè; doco dihna peón nì quìhvi último ni cáyàha, dandu ducán cunchicùn tnahá‑te quìhvi‑tè dècuèndè stná nùù peón nì quìhvi primeru”. ");
INSERT INTO mitNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ñàyùcàndùá, dihna tiàa nì caquìhvi nahi càhúhùn nì yàha, te iin iin‑tè nì nìhì‑té iin iin dìhùn plata. ");
INSERT INTO mitNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Daaní, nì cayàha stná peón nì quìhvi naha, te chicá más cuàhàn‑te nìhì‑té cahan‑té, doco còó. Iin‑ni nì canihì nsidaa‑té. ");
INSERT INTO mitNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ñàyùcàndùá nì quesaha‑té daquée cuàchi‑tè dìquì lamú mà, ");
INSERT INTO mitNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","cachí‑te xi‑né: “Cuisì iin hora‑ni nì caquidachuún nècuàchì último jaàn, te quida‑ní cuenta na ian dava‑ni nì quidachuún‑né xì nsiùhù, mate ndui yacá nì quidachuún ndee‑nsí nùù cahnì”. ");
INSERT INTO mitNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dandu nì cachi lamú mà xì iin tiàa mahì peón mà: “Còó, amigo, màdì cuáchi nduá quidé. ¿Amádi sánì ndòo sahnu‑nda ñà‑quiyàhvi iin iin‑nsia iin‑ni dìhùn plata? ");
INSERT INTO mitNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tnii‑ní yàhvi‑ní, te cuahán‑nî, vàchi yùhù cuníˋ ñà‑dava‑ni quiyàhvi stná nècuàchì último yohó nacua quíyàhvi mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Á coo derechu xi ñà‑quide xì dìhùn xí nacua chítnùní inì? ¿ò cumbídiâ inì‑ní ñà‑nì quide iin ñà‑vàha (sàhà nècuàchìmà?”, nì cachi lamú mà). ");
INSERT INTO mitNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sàháyùcàndùá, nècuàchì chicá idónuu vichi, icúmí‑nê sàà‑nè natenchicùn‑nè ndè cahà‑xí, te nècuàchì nchícùn cahà‑xí vichi, icúmí‑nê sàà‑nè nàcòdònùù‑né nùù‑xí. Vàchi mate cuáhà nèhivì cánà (cundoo nùù Dios), doco sacu‑nè cunduu ana nacàxin‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Daaní, meru xicá Jesús ichì mànana‑ya cuàhàn‑yà ñuu Jerusalén, te nì tavà cuàán‑yá nsì‑úxìn ùì tiàa dacuahá‑yá, te nì cachi‑yà xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Cunaha‑nsiá, icúmí‑ndá sàà‑ndà ñuu Jerusalén, te yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî yàhi ndahà dùtù xícusahnú yucán, xì ndahà stná nècuàchì ley xi veheñùhu, te icúmí‑nê cachi‑nè ñà‑fuerza icúmî cuì. ");
INSERT INTO mitNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dandu dayáha‑ne yùhù ndahà tè‑inga raza ñà‑cuàcùndiaà‑te yùhù, te cahnì cuìí‑te yùhù, dandu chituu‑tè yùhù nchìca cruz, doco tìxi ùnì quìvì icúmî natiacuì. ");
INSERT INTO mitNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Daaní, vàxi ñahàdìhí Zebedeo nùù‑yá, ndacá‑né dèhe‑ne, te nì sàcuììn sìsì‑né nùù‑yá, cuní‑nè càcàn‑nè iin favor nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Te nì cachi‑yà xì‑né: ―¿Índù iñàha cuní‑nî? Te nì cachi‑nè xì‑yá: ―Cuníˋ nìhìtáhvì ndúì dèhi yohó ñà‑cundoo iin iin‑tè ladu‑ní quìvì sàà‑ní cusahnu‑ní ñuhìví, iin‑tè coo ladu cuàhá‑nî, te ingà‑te ladu itní‑nî. ");
INSERT INTO mitNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dandu nì cachi‑yà xì ndúì tiàa ma: ―Mii‑nsiá, có‑sânìhì ini‑nsià ñà‑ndùá xícàn tàhvì‑nsiá nùí. ¿A vátùni cundee inì‑nsia ndoho‑nsia nacua icúmî ndohi te yàha stná‑nsià tnùndoho nacua icúmî yàhi? ―Jaan ―nì cachi‑nè― vàtùni stná nsiùhù. ");
INSERT INTO mitNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dandu nì cachi‑yà xì‑né: ―Ñà‑ndáà nduá, icúmí‑nsiâ ndoho‑nsia nahi yùhù, te icúmí‑nsiâ yàha stná‑nsià tnùndoho nahi yùhù; doco ñà‑daníhìtáhvìˊ mii‑nsiá cundoo iin iin‑nsia iin iin ladúì, mà cúí, vàchi có‑quìdá tocar yùhù quide ñà‑jaàn. Yuamánìˊ nduú ana chítnùní inì‑xi índù nèhivì nìhìtáhvì cundoo iin iin ladúì. ");
INSERT INTO mitNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Daaní, na ní xinitnùhu ùxìn gà nècuàchì dacuahá‑yá, nì cuduchi gá ini‑nè sàhà ùì ñàní mà. ");
INSERT INTO mitNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Doco nì cana‑ya nsidaa‑né ni nátácá‑nè nùù‑yá, te nì cachi‑yà xì‑né: ―Sà‑ìnáhá‑nsiâ nansa xíquida tè‑cùsáhnû inga ñuu, fuerte cusáhnû‑te nùù nèhivì ñuù‑te; vàchi nsidaa tè‑nìhí chuun ñuu yucán, ndee dandacú‑te nùù nècuàchì ñuù‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Doco mii‑nsiá, màsà quídá‑nsiá ducán. Còó, vàchi nú iá ana cuní cunduu ana dandacú núù‑nsiá, dandu icúmí‑nê cunduu‑ne ana xinúcuáchí nûù nsidaa‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Vàchi nècuàchì cuní codònùù nùú‑xí, icúmí‑nê cunduu‑ne nahi peón chindéé xí nècuàchì dava ga. ");
INSERT INTO mitNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dècuèndè stná yùhù ana nduú Tnaha Nèhivì Ñuhìví, cónì quésáì ñuhìví yohó ñà‑cunucuachi nèhivì nùí. Còó, sàhà‑ñá cunucuachi mií nùù‑né nì quesaì, dandu después cuàhi vida‑xi cuì cuenta xi‑ne, te ducán nàcùndoo cuàhà‑né libre. ");
INSERT INTO mitNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Daaní, mii‑yá xì compañeru‑yà, nì quihin‑ya ichì nì quee‑ya ñuu Jericó, te nchícùn cuàhà gá stná nèhivì dava ga. ");
INSERT INTO mitNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Te yuhù ìchí yucán ndoó ùì nècuàchì cuaá. Te na ní tiacu‑nè cuàhàn yàha Jesús, dandu nì quesaha‑né cána ndee‑né, cachí‑nè: ―¡Stoho‑nsì Señor! ¡Mii‑ní descendencia ìì xí David! ¡Cuhi inì‑ní nsiùhù! ");
INSERT INTO mitNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dandu nèhivì cuáhà yucán, nì canàhá‑nè xì nècuàchì cuaá mà: ―Màsà cána ga‑nsià ―cachí‑nè. Doco nècuàchìmà, chicá ndee ní càna‑ne, cachí‑nè: ―¡Stoho‑nsì Señor! ¡Mii‑ní descendencia ìì xí David! ¡Cuhi inì‑ní nsiùhù! ");
INSERT INTO mitNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dandu nì cucuiin‑yà, te nì cana‑ya nècuàchì cuaá mà nì cachi‑yà xì‑né: ―¿Ndíà nduá cuní‑nsià quide sàhà‑nsiá? ");
INSERT INTO mitNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Te nì cachi‑nè xì‑yá: ―Stoho‑nsì Señor, cuní‑nsì natùinuù‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ñàyùcàndùá nì cuhi ini‑yànè, te nì chituu‑ya ndahà‑yá nùù‑né. Te vichi vichi nì natùinuù‑né. Dandu nì tenchicùn stná‑nè mii‑yá cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Daaní, nì sàà‑yà xì‑né yatni ñuu Jerusalén ndé iá iin ñuu tii nani Betfagé, yatni dìnì yucù Olivo. Dandu nì càhàn‑yà xì ùì nècuàchì dacuahá‑yá ñà‑nì cúhùn cueé‑nè nùù‑xí. ");
INSERT INTO mitNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Te dohó nì cachi‑yà xì‑né: ―Cuahán‑nsià ñuu tii chicá nùù‑xí. Te yucán icúmí‑nsiâ cuni‑nsià nuhní iin burru xì dèhe‑sì. Quisì yucán ndaxin‑nsiá, cundaca‑nsia quixi. ");
INSERT INTO mitNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te nú càhàn nèhivì xì‑nsiá sàhà‑sí, dandu cachi‑nsià xì‑né ñà‑Stoho‑ndà Señor xiñuhu xi‑sí, doco luegu naxicocuíìn‑si ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Cunaha‑nsiá, ducán (nì cachi‑yà xì‑né) sàhà ñà‑nì cùú ndisa ñà‑ndùá nì cachitnùhu iin nèhivì xí Dios sànaha na ní cachi‑nè palabra yohó: ");
INSERT INTO mitNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Dohó cachitnùhu‑nsia xi nèhivì ñuu Sión, (divi nduú ñuu Jerusalén): “Cundehè‑nsiá, yucán vàxi rey xi‑nsia, nihnú ndáhví íní‑yà, te indánuú‑yá iin burru chii nduú dèhe iin quisì (sànsìdá)”. (Ducan nì cachitnùhu nècuàchì sànaha ma.) ");
INSERT INTO mitNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Daaní, nì caquihin ùì nècuàchìmà ichì cuàhàn‑nè chuun ma, nì caquida‑ne nacua nì dàndàcú Jesús nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nì saca‑ne burru mà vàxi xi dèhe‑sì. Dandu nì chitàndòó‑né sìcoto xi‑ne dìquì‑sí, te nì sàcùnùú‑yàsi. ");
INSERT INTO mitNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Daaní, dava nècuàchì cuáhà yucán, nì chitànduhù‑né dòò‑né ichì ndé icúmí‑yâ yàha‑ya, te dava‑ne, nì sahnde‑nè ndahà yutnù nì chindoo stná‑nè ichì mà, (te ducán nì nducutá). ");
INSERT INTO mitNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Te nèhivì idónuu, xì stná nècuàchì nchícùn cahà‑xí, cána ndee‑né, cachí‑nè: ―¡Viva ana sahnú yohó! ¡Descendencia ìì xí rey David nduú‑né! ¡Ndiaha gá ndeníhí vàha‑ndané, vàchi cuenta xi Stoho‑ndà Señor vàxi‑ne! ¡Ansivéhé cahnú mii‑yá iá ansivi! ");
INSERT INTO mitNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Daaní, na sánì quìhvi‑ya ñuu Jerusalén mà, dandu nì ndulocó gà nsidaa nèhivì ndoó yucán, cachí‑nè: ―¿Ana divi nduú nècuàchì yohó? ");
INSERT INTO mitNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Te nì naxiconihí nèhivì cuáhà mà: ―Jesús nani‑né, te nduú‑né iin nècuàchì cáhàn cuenta xi Dios. Te meru ñuu‑nè nduú ñuu Nazaret iá ladu Galilea. ");
INSERT INTO mitNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Dandu cuàhàn‑yà veheñùhu cahnú xí Dios, te nì taxi‑yá nsidaa tè‑dìcó xi tè‑xìín yucán, te nì ducùn nsìhí‑yá mesa xi tiàa damá dìhùn inga ñuu, te nì ducùn stná‑yà silla xi tè‑dìcó loma, ");
INSERT INTO mitNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","cachí‑yà xì nsidaa témà: ―Dohó cachí (Dios) nùù tutu ìì: “Veheñùhu xi cunduu iin vehe ndé nataca nèhivì càcàn tàhvì‑né nùí”, cachí‑yà. Doco sàhà mii‑nsiá sànì nandua na iin lugar ndé ndoó cuàhà tècuìhnà ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Dandu nì catnàtuu cuàhà nècuàchì cuhí nùù‑yá, dava‑ne cuaá‑nè, te dava‑ne xicá cuéhê‑nè; te nì dàndúvàha‑yanè. ");
INSERT INTO mitNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Doco dùtù xícusahnú, xì nècuàchì ley xi veheñùhu, nì cuduchi ini‑nè na ní xini‑nè ñà‑cuàhà guá milagru quidá‑yá. Te nì tiacu stná‑nè cána ndee ñà‑cuati ini veheñùhu, cacháˋ sàhà‑yá: “¡Ndiaha gá ana sahnú yohó; descendencia ìì xí rey David nduú‑né!” ");
INSERT INTO mitNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ñàyùcàndùá, nì candudana nècuàchìmà, cachí‑nè xì‑yá: ―¿A có‑ìníní‑nî nansa cachí ñà‑cuati jaàn? Dandu nì cachi‑yà xì‑né: ―Jaan, iníní. Doco mii‑nsiá, a táñâha ga cahvi‑nsia (ndé cáhàn nèhivì xì Dios, cachí‑nè palabra yohó): Ndè stná ñà‑cuati xi méè tíquìn sànì dàtnúù stná‑ní sàxìnítnùní‑xi, te nì nìhì‑vé naquimanì ndiaha‑vé mii‑ní. (Ducán nì cachi Jesús xì nècuàchìmà.) ");
INSERT INTO mitNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dandu nì nacoo‑yanè, te nì quee‑ya ñuu mà cuàhàn‑yà ñuu tii Betania, te yucán nì quìdì‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na ní tùinuù, nì quihin‑ya ichì màndixi‑ya ñuu cahnú, dandu nì xìhì‑yà doco. ");
INSERT INTO mitNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Te nì xini‑yà jaàn yatni ichì mà iín iin nù‑higu. Ñàyùcàndùá, nì tnàtuu‑ya ndé iín‑nu, doco còò quisì vídì caá, cutu ndahà cuií‑ni‑nù iá. Ñàyùcàndùá nì cachi‑yà xì‑nú: ―Màsà nunca cana ga quisì vídì yohó. Dandu luegu nì ìchì dahuun‑nù. ");
INSERT INTO mitNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Te na ní xini nècuàchì dacuahá‑yá ñà‑ndùá nì cuu, nì ndulocó‑nè, te nì cachi‑nè: ―¿Índù chuun yàchì guá nì ìchì nù‑higu jaàn? ");
INSERT INTO mitNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Dandu nì cachi‑yà xì‑né: ―Ñà‑ndáà ndùá cachíˋ xì‑nsiá yohó; nú ni cúníndísâ vàha‑nsia, te có‑ndòó‑nsiá xì duda, dandu vàtùni quida stná‑nsià milagru, doco màdì cuisì milagru na ian nì cuu xi nù‑higu yohó. Còó, dècuèndè vàtùni cachi stná‑nsià xì yucù jaàn ñà‑nì cúxíóá, te quècahnua ini mar, te divi ducán ndisa icúmí cuu. ");
INSERT INTO mitNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Vàchi nú ni cúníndísâ víi‑nsiá, dandu nìhìtáhvì‑nsiá nsidaa ñà‑ndùá nì cácàn tàhvì‑nsiá nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Daaní, nì nansìhvi‑ya veheñùhu cahnú, te nì quesaha‑yá chináhá‑yà nèhivì. Doco nì catnàtuu stná dùtù xícusahnú, xì stná nècuàchì xídandacú nùù ñuu mà, cachí‑nè xì‑yá: ―¿Índù nì nìhì‑ní derechu quida‑ní ñà‑ndùá quìdà‑ní? ¿Ana divi nì dàndàcú nùù‑ní ñà‑quida‑ní ducán? ");
INSERT INTO mitNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Dandu nì cachi‑yà xì‑né: ―Yùhù cuní stnáì ndàcàtnùhí nùù mii‑nsiá, te nú ni náxícóníhî‑nsiá nùí, dandu cachitnùhu stnáì xì‑nsiá ana divi nì dàndàcù‑xì núìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Cachi‑nsià xìˊ ana divi nì dàndàcù‑xì nùù Juan (Bautista) ñà‑quida iì‑né nèhivì. ¿A Dios nì cachi xì‑né, te ò nèhivì ñuhìví? Dandu nècuàchìmà, nì candatnuhu tnahá nsidaa‑ní mii‑né, cachí‑nè: ―Nú ni cachí‑ndà Dios nì dàndàcù‑xì nùù Juan, dandu cachi Jesús xì‑ndà: “¿Índù chuun cónì xíníndísâ‑nsiá nècuàchìmà, nú ducán?” ");
INSERT INTO mitNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Doco nú ni cachí‑ndà ñà‑divi nèhivì ùún nì cachi xì nècuàchìmà, dandu yúhî‑ndà ndíà ndùá quida nèhivì xì‑ndà, vàchi nsidaa‑né quidá‑né cuenta iin ana nì càhàn cuenta xi Dios nì sanduu ndisa Juan mà. ");
INSERT INTO mitNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ñàyùcàndùá, nì cacachi nècuàchìmà xì‑yá: ―Có‑cùndáà ini‑nsì ana divi nì dàndàcù‑xì nùù Juan. Dandu nì cachi‑yà xì‑né: ―Ni yùhù, mà cáchí stnáì xì‑nsiá ana divi nì dàndàcù‑xì núìˊ ñà‑quide ñà‑ndùá quìdé. ");
INSERT INTO mitNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","(Dandu nì cachi Jesús xì‑né:) ―¿Nansa tuxí inì‑nsia (sàhà ejemplu yohó)? Nìsa ìa iin tiàa ndoó ùì dèhe‑xi. Te nì cachi‑nè xì iin‑tè: “Cuahán vichi duha, quidachuun itu‑ndà ndé iá sì‑uva xi‑nda”. ");
INSERT INTO mitNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Te nì cachi dèhe‑ne mà: “Còó, vàchi có‑càhín cùhìn”. Doco después nì naxicocuíìn inì‑te, te nì sàhàn‑te nì quidachuún‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dandu nì sàhàn yua ma ní càhàn tu‑ne xì inga dèhe‑ne, cachí‑nè xì‑té nacua nì cachi‑nè xì tè‑primeru mà (ñà‑nì cúhùn‑te quidachuún‑te). Te nì cachi tèchii úì mà: “Juùn, yohó cúhìn, papá”. Doco cónì sáhàn‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pues, vichi cachi‑nsià xìˊ índù tèchii ma nì quida ndisa ñà‑ndùá nì dàndàcú yua‑té. Te nì cachi nèhivì iníní má: ―Divi tè‑primeru mà. Dandu nì cachi Jesús xì‑né: ―(Cachí vàha‑nsia.) Te palabra ndàcuisì nduá cachíˋ xì‑nsiá yohó: chicá mà úhì càcu tè‑dàchíyàhvi (cahíchì guá ini‑nsià), ò iin nècuàchì ñahà quidá ndevàha, te sàà‑nè ñuhìví ìì xí Dios, mientras mii‑nsiá, ùhì gà càcu‑nsia ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Vàchi na ní quixi Juan Bautista cónì xìníndísâ‑nsiá (na ní càhàn‑nè sàhù) sàhà ichì váha Dios. Doco tè‑dàchíyàhvi, xì stná nècuàchì ñahà iá cuàchi xi, nì xinindisá‑né nècuàchìmà. Te nú sànì xini‑nsià (nì xinindisá cuàhà nècuàchìmà), dandu ¿índù chuun cónì náxícócuîìn stná ini‑nsià ñà‑cunindisá‑nsiá? ");
INSERT INTO mitNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Cunini‑nsia, vàchi cuàhìn nacani inga ejemplu. Nì ìa iin lamú nì dànándèe nducu yòhò sì‑uva nùù ñuhù xí‑né, te nì quida‑ne corra‑ñà. Dandu nì quidavàha stná‑nè iin pilá cahnú ndé cuñuhu ndudi quisì mà. Te nì quidavàha stná‑nè iin torre ndé cundiaa peón inii itu mà. Dandu nì tatu‑nè itnii medieru, te cuàhàn‑nè inga ñuu xìcà. ");
INSERT INTO mitNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Daaní, na ní sàà tiempu cùchi quisì vídì mà, dandu nì techuún‑né iin ùì peón xi‑ne nùhù naquihin xi fruta nùù medieru mà. ");
INSERT INTO mitNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Doco na ní canasaa nècuàchìmà yucán, nì catnii medieru mà nsidaa‑né, te nì sahnì cuìí‑te iin‑ne, inga‑nè nì sahnì dahuun‑tè, te inga‑nè nì cani yuu‑té. ");
INSERT INTO mitNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Daaní, inga tu nì techuún lamú mà más gà peón xi‑ne nùhù tu, te chicá más nduú‑né nùù nècuàchì nì nùhù primeru. Doco divi ni ducán nì quida quini medieru mà xì nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dandu último nì techuún lamú mà dèhemanì‑né nùhù, vàchi ádi quidañuhu‑té dèhe‑ne nì cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Doco na ní xinì‑te vàxi dèhe lamú mà, dandu nì candatnuhu tnahá‑te, cachí‑te: “Tè‑yòhó nduú tè‑ìcúmí ndutahvì (xì ñuhù yohó). Vichi cahnì‑ndàté chicá vàha, dandu mii‑nda nanduu‑nda stoho ñuhù”, nì cacachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ñàyùcàndùá, nì catnii‑tè nècuàchìmà nì tavà‑ténê iladu nùù ñuhù mà, te nì casahnì‑ténê. ");
INSERT INTO mitNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Pues, vichi ¿ndíà nduá icúmí quida stoho itu mà xì medieru mà nú sànì nasaa‑nè yucán? ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dandu nècuàchì iníní, nì cachi‑nè xì‑yá: ―Icúmí‑nê dandáñúhú dahuun‑ne tè‑malu mà. Ni‑iyuhu mà cúhí ini‑nète. Dandu después nanducu gá‑nè medieru tùha quida viì, divi nècuàchì tùha nacuàha xi‑né quisì vídì tiempu iá‑si. ");
INSERT INTO mitNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dandu nì cachi‑yà xì‑né: ―¿A táñâha ga cahvi‑nsia nùù tutu ìì ndé cacháˋ palabra yohó?: Nì ìa iin cavà, te nì cahíchì ini albañil‑ñà, doco vichi sànì sàà mà nì sàcùndua yùù vìcò esquina vehe. Divi Stoho‑ndà Señor nduú ana nì quida ducán, te ndulócô‑nsì ñà‑ndiaha guá nì quida‑ya. (Ducan nacání nùù tutu ìì.) ");
INSERT INTO mitNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ñàyùcàndùá, yùhù cachíˋ xì‑nsiá, mà níhì gá nèhivì ñuu yohó derechu cundoo‑ne ñuhìví ìì xí Dios; còó, nèhivì inga ñuu icúmí nìhìtáhvì xán, te mii‑né, ndisa, icúmí‑nê quida viì‑né na iin medieru vàha tùha nacuàha viì xì cosecha. ");
INSERT INTO mitNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Te (cunaha‑nsiá, yohó iá gà stná inga ejemplu sàhà cavà mà): nsidaa ana caquìhi sahà‑xí cavà ma, icúmí‑nê nacuèhè‑nè. Te nsidaa ana nacava mà dìquì‑xí, tàdì nchìhì‑nè quida ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Te (cunaha‑nsiá, yucán itá stná) dùtù xícusahnú, xì nècuàchì fariseu, te iníní stná‑nè ejemplu nì nacani‑ya, te nì cundaà ini‑nè, divi mii‑né cáhàn‑yà sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ñàyùcàndùá, nì cuni‑nè tnii‑neyà, doco yúhî‑nè nèhivì cuáhà ndoó yucán, vàchi ndeníhí nècuàchìmà mii‑yá ñà‑ndùú‑yá iin ana cáhàn cuenta xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Daaní, nì quesaha Jesús nì nacani tu‑ya xì‑né inga ejemplu, te dohó nì cachi‑yà: ");
INSERT INTO mitNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Dohó iá ñuhìví ìì xí Dios nacua nì quida iin rey na ní nandàhà dèhe ii‑né; nì quida‑ne iin vicò cahnú. ");
INSERT INTO mitNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Te nì techuún‑né peón xi‑ne ñà‑cacanuu‑tè cachitnùhu‑tè xì nsidaa nèhivì sànì cànà. Doco cónì cùní nècuàchìmà quixi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ñàyùcàndùá, nì techuún rey mà más gà peón xi‑ne cacanuu‑tè cachitnùhu‑tè. Te dohó nì cachi‑nè xì‑té: “Cachì‑ndá xì nèhivì cánà mà ñà‑sà‑ìá quixi‑ne vicò, vàchi sànì cuyucun comida; sànì xìhì buey xì nsidaa gá quisì ndatnù. Sà‑ìá nsidaá ndiatúá‑nè”, nì cachi rey mà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Doco nèhivì cánà mà, cónì quìhín casu‑nè, nì caquee nsidaa‑né cuàhàn‑nè nùù chuun xi‑ne. Iin‑ne cuàhàn‑nè nùù ìtú, inga‑nè cuàhàn‑nè ndé iá venta xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Te dava ga‑nè nì tnii xi peón xi rey mà nì quida quini‑ne xì‑té, nì sahnì‑néte. ");
INSERT INTO mitNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ñàyùcàndùá na ní inini rey mà, cuàhà gá nì xìdà ini‑nè, te nì techuún‑né soldadu xi‑ne nì dàndáñúhú‑tê nèhivì mà, te nì sahmi‑tè ñuu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dandu nì cachi rey mà xì peón xi‑ne: “Sà‑ìá listu vicò‑xí, doco nèhivì nì cachì quixi primeru, cónì nátùi‑ne nìhìtáhvì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ñàyùcàndùá, vichi cuahán‑ndâ ndè ichì nahnú, te quida‑ndá invitar nsidanicuú nèhivì ndácùhun stnaha‑xi‑ndá, te cachì‑ndá xì‑né ñà‑nì quìxí‑né vicò xí”. ");
INSERT INTO mitNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ñàyùcàndùá, nì caquee peón mà inga xichi nì nacàhin‑tè calle ñuu mà nì dànátácà‑te nsidanicuú ana nì ndacùhun stnaha‑xi‑té, vàha‑ne ò malu‑nè, te ducán nì chitu vehe rey mà nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Daaní, nì quìhvi rey mà ndé iá vicò, te nì xini‑nè jaàn iá iin tiàa có‑ndìxí vícó nacua ndiá ìcà‑ndà na ndoo‑nda vicò nándàhà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ñàyùcàndùá, nì cachi‑nè xì nècuàchìmà: “Amigo, ¿índù chuun nì yàha‑ní vicò yohó, te có‑ndìxì‑ní sìcoto nacua ndiá ìcà‑ní?” Doco nècuàchìmà, mànìcùí naxiconihí‑né nùù rey mà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dandu nì cachi rey mà xì peón xi‑ne: “Chicuhnì‑ndá ndahàsáhà nècuàchì jaàn, te dacana‑ndánè fuera ndé iín tnúú; (ndahví‑nè), vàchi yucán nduú lugar ndé yáha ga cuacu nèhivì, te càna stná nùhu‑ne”, nì cachi rey mà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pues sàhà (ejemplu yohó vàtùni cundaà ini‑nsià) ñà‑cuàhà nèhivì cánà (cundoo nùù Dios), doco sacu‑nè cunduu ana nacàxin‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Daaní, nì caquee nècuàchì fariseu nì ndatnuhu tnahá‑né nansa cui quida‑ne, te dadaná‑né mii‑yá na cáhàn‑yà (xì nèhivì). ");
INSERT INTO mitNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ñàyùcàndùá, nì techuún‑né itnii nèhivì nchícùn xì‑né nùù‑yá, te cutnáhâ stná iin ùì nècuàchì partidu xi Herodes, te dohó nì cacachi‑nè xì‑yá: ―Maestro, ináhá‑nsî nduu‑ní iin nèhivì ndàcuisì inì‑xi, te chináhá viì‑ní nansa ndisa iá ichì váha Dios. Có‑quìhín casu‑ní nansa cachí nèhivì, te ni có‑yûhî stnâ‑ní ni‑iin‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ñàyùcàndùá, cuní‑nsì cachì‑ní xì‑nsí nansa tuxí inì‑ní, ¿a vátùni sáha Dios lugar chiyàhvi‑nda renta nùù rey cahnú César, á coó? ");
INSERT INTO mitNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Doco Jesús, sànì cundaà ini‑yà có‑xîcàn tnùhu sahnú ndisa‑ne nùù‑yá. Ñàyùcàndùá nì cachi‑yà xì‑né: ―(Ndahví‑nsià, vàchi) dananí uun‑nsia vàha guá‑nsià. ¿Índù chuun cuní‑nsià quida‑nsia maña nùí? ");
INSERT INTO mitNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dacuní‑nsià yùhù iin dìhùn xí‑nsiá chíyàhvi‑nsia sàhà renta, cundehí. Dandu nì sàha‑neyà dìhùn plata mà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Te na ní indehè‑yáñà, dandu nì cachi‑yà: ―¿Ana dìnúù‑xí, te ana dìquívì‑xí itúú ìcà dìhùn yohó? ");
INSERT INTO mitNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","―Divi rey cahnú César ―nì cachi‑nè. Dandu nì cachi‑yà xì‑né: ―Nú ducán nduá, dandu nacuàha‑nsia César ñà‑ndùá icúmí‑nsiâ cuàha‑nsiàte, te cuàha stná‑nsià Dios ñà‑ndùá ndiá ìcà‑nsiá cuàha‑nsiayà ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dandu nèhivì mà, nì ndulocó‑nè sàhà palabra jaàn, te nì nacoo‑neyà cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Daaní, quìvì yucán nì tnàtuu itnii nècuàchì saduceu nùù‑yá, nì càhàn‑nè xì‑yá. Nècuàchì yucán, có‑xìníndísâ‑né ñà‑ìcúmí‑ndá natiacu‑ndà. Ñàyùcàndùá, dohó nì cachi‑nè xì‑yá: ");
INSERT INTO mitNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, ñà‑yòhó nduá nì tiaa Moisés quida‑nda: nú sànì xìhì iin tiàa, te còò déhe‑ne nì ndóo (xi ñahàdìhí‑nè), dandu icúmí ñani nsìi ma nandàhà‑né xì ñahàcuàán nì ndòo ma, áma cóó iin dèhe‑ne; dandu quida‑nda cuenta na ian dèhe nsìi ma nduú méè mà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","’Pues cunaha‑ní, nì sandoo ùsà ñàní ñuu‑ndà yohó, te nì nandàhà nècuàchì primeru, doco nì xìhì‑nè, te còò déhe‑ne. Ñàyùcàndùá, nì ndòo ñahàdìhí‑nè nùù ñani‑nè nchícùn gà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Daaní, divi ducán nì cuu stná xì nècuàchì ùì, nì xìhì stná‑nè, te còò stná dèhe‑ne, te nì ndòo ñahàdìhí‑nè nùù inga ñani nchícùn gà; te iin‑ni nì quida‑ne seguir ducán dècuèndè (nì xìhì stná) nècuàchì ùsà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dandu por último nì xìhì stná nècuàchì ñahà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ñàyùcàndùá, na sáà quìvì (cachí‑nsià) natiacu nsìi, ¿índù tiàa ma nacuaca xi nècuàchì ñahà mà? vàchi antes nsì‑úsà‑nè nìsa ìa xi‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dandu nì cachi Jesús xì‑né: ―Còó; có‑càchí viì‑nsiá, vàchi có‑cùndáà inì‑nsia nansa cachí tutu ìì xí Dios, ni có‑cùndáà stná inì‑nsia ñà‑càhnù‑guá poder xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cunaha‑nsiá, na sáà quìvì natiacu nèhivì, mà nándàhà gá‑nè, vàchi nahi ángel ndoó ansivi (xinúcuáchí) nùù Dios, ducán icúmí nanduu nècuàchì nsìi. ");
INSERT INTO mitNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pues vichi cuàhìn càhìn xì‑nsiá sàhà nansa iá ndisa natiacu nsìi. Ádi sánì cahvi‑nsia nansa nì cachi Dios xì‑nsiá palabra yohó: ");
INSERT INTO mitNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yùhù nduí Dios cahvi nsì‑Abraham, xì nsì‑Isaac, xì nsì‑Jacob”, cachí‑yà. (Ñàyùcàndùá, itiácú ìì nècuàchì nsìi ma), vàchi nècuàchì sànì xìhì dahuun ndisa, mà cúí cahvi gá‑nè Dios; cuisì ana itiácú càhvì xì‑yá ");
INSERT INTO mitNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","―nì cachi Jesús. Te na ní inini nèhivì cuáhà mà ñà‑ndùá nì cachi‑yà, dandu yáha ga nì ndulocó‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dandu nì xinitnùhu nècuàchì fariseu ñà‑sànì cundee‑yá nùù nècuàchì saduceu, mànìcùí nanihì tnùní ini‑nè nansa naxiconihí‑né nùù‑yá. Ñàyùcàndùá nì nataca nècuàchì fariseu mà; ");
INSERT INTO mitNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","te iin‑ne nduú nècuàchì ley xi veheñùhu, te nì tnàtuu‑ne nùù‑yá nì ndàcàtnùhù‑né iñàha nùù‑yá, a ver nansa naxiconihí‑yá. Te dohó nì cachi‑nè xì‑yá: ");
INSERT INTO mitNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, nùù nsidaa ñà‑ndùá nì dàndàcú Dios nùù ley xi‑ya, ¿índù‑ñá chicá ndiaá? ");
INSERT INTO mitNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Dandu nì cachi‑yà xì‑né: ―Icúmí‑ndá cuu ini‑ndà sàhà Stoho‑ndà Dios xì nsidanicuú anima‑ndà, xì nsidanicuú voluntad xi‑nda, xì nsidanicuú stná sàxìnítnùní‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ñà‑jaàn nduá chicá ndiaá dandacú‑yá, te chicá chuun cahnú nduú stná. ");
INSERT INTO mitNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Daaní, nacua cachí ley primeru mà, ducán cachí stná ley ùì nì dàndàcú‑yá, (vàchi dohó cacháˋ): “Nacua cuú ini‑ndà sàhà mii‑nda, ducán icúmí stná‑ndà cuu ini‑ndà sàhà ñanìtnaha‑nda”. ");
INSERT INTO mitNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cunaha‑nsiá divi ley jaàn nduú yohò nsidanicuú ley xi Moisés xì nsidaa gá stná palabra nì cachi profeta nìsa cahàn cuenta xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ndoó íì nècuàchì fariseu yucán, te nì cachi Jesús xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Nansa cachí mii‑nsiá sàhà ana nduú Cristu? ¿Índù descendencia nduú‑yá (cahan‑nsiá)? Te nì cachi‑nè xì‑yá: ―Divi David nduú yohòtéhè‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dandu nì cachi‑yà xì‑né: ―Pues, nú ducán, dandu ¿índù chuun nì cachi David ñà‑stoho‑nè nduú‑yá na ní càhàn‑nè sàhà‑yá tìxi poder xi Espíritu Ìì xí Dios? Vàchi dohó nì cachi nècuàchìmà nùù tutu ìì: ");
INSERT INTO mitNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nì càhàn Yua‑nda Dios xì Stohì, (divi Cristu), te nì cachi‑yà: “Yohó coo‑ní ladu cuahíˋ ndè cachi sàà cundeí nùù nsidaa ana xiní ùhì xì‑ní, dandu cusahnú fuerte‑ní nùù‑né”. ");
INSERT INTO mitNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Cundehè‑nsiá, nì cachi David ñà‑Stoho‑nè nduú Cristu, doco nú ducán nduú‑yá, dandu ¿índù modo cunduu stná‑yà iin descendencia xi‑ne? (Doco ñà‑ndáà nduá.) ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Doco còò ni‑iin nèhivì nì nánîhì tnùní gà ini‑nè naxiconihí‑né nùù‑yá ni‑iin palabra. Ñàyùcàndùá, quìvì nùù‑xí cónì sáha ga‑nè valor dadavátnáhâ‑né xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dandu nì càhàn tu‑ya xì nèhivì cuáhà yucán, xínduu‑ne nècuàchì dacuahá‑yá, xì stná nècuàchì iníní úún. ");
INSERT INTO mitNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Te dohó nì cachi‑yà xì‑né: ―Nècuàchì fariseu xi nècuàchì ley xi veheñùhu, iá derechu xi‑ne chinaha‑nè ley ìì xí Moisés. ");
INSERT INTO mitNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ñàyùcàndùá, nsidaa ñà‑ndùá cachí‑nè, chivàha‑nsiañà. Doco màsà quídá‑nsiá nacua quidá mii‑né, còó, vàchi diín iñàha chináhá‑nè, te diín iñàha quidá‑né. Nùù mii‑né, mà úhì cachi‑nè xì nèhivì ñà‑chivàha‑ne cuàhà iñàha, doco mii‑né, có‑chîvàha‑neà. ");
INSERT INTO mitNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Doco nèhivì, mà cúndéé ini‑nè chivàha nsihi‑ne ñà‑ndùá cachí nècuàchìmà, vàchi na iin carga vèe nduá nùù‑né, te mate úhì cunsida‑neà, doco ndacú núù‑né. Doco nècuàchì ley mà, còó; ni‑iyuhu mà ndáníhí‑néà, ni có‑dûcùn ni‑iin dìnìndàhá‑nèà. ");
INSERT INTO mitNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","’Cunaha‑nsiá, nsidaa ñà‑ndùá quidá nècuàchìmà, cuisì sàhà‑ñá cundehè nèhivì‑né nduá. Ndahà‑né te tnaa‑nè nuhní itni ndé ñuhú tutu ìì, doco puru itni nahnú cuní‑nè cundua (na ian vàha guá‑nè). Te divi sàhà ñà‑yùcán nduá nsidá naní stná‑nè ñà‑vico iá nùù sáhà sìcoto xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Te na sáhàn‑nè vicò, ò veheñùhu, dandu nandúcú‑nê lugar ndé chicá ndiaha cundoo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Te cudíì stná ini‑nè ñà‑cásàhú tnùñuhu nèhivì xì‑né yàhvi, te cachí nèhivì xì‑né maestro. ");
INSERT INTO mitNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Doco mii‑nsiá, màsà nándúcú‑nsiâ ñà‑cachi nèhivì xì‑nsiá maestro, vàchi imindaa maestru icúmí‑nsiâ, divi nduú yùhù Cristu, te iin‑ni ñaní nduú nsidaa‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ni màsà cáchí‑nsià “padre” xì ni‑iin nèhivì ñuhìví yohó, vàchi imindaa ana nduú yua ndisa‑nsia, divi nduú mii‑yá iá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni màsà cáchí stnàhá stná‑nsià “jefe”, vàchi imindaa jefe icúmí‑nsiâ, divi nduú yùhù Cristu. ");
INSERT INTO mitNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Te nècuàchì cuní cunduu ana chicá idónuu, divi icúmí cunduu ana xinúcuáchí. ");
INSERT INTO mitNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Vàchi nsidaa ana datiaá chicá ndiaá, icúmí‑nê sàà‑nè nducahan‑ne. Doco nsidaa ana ndaníhí ndáhvî xì mii‑xí, divi nduú ana chicá icúmí nìhì xì tnùñuhu. ");
INSERT INTO mitNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ndahví mii‑nsiá nècuàchì ley xi veheñùhu! Te ¡ndahví stná mii‑nsiá nècuàchì fariseu! Vàchi datiaá uun‑nsia vàha‑nsia. Cutu estorbu quidá‑nsiá nùù nèhivì cuní quìhvi ñuhìví ìì xí Dios: ni có‑quîhvi mii‑nsiá, te nèhivì cuní quìhvi, sadí‑nsià nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ndahví mii‑nsiá nècuàchì ley xi veheñùhu, xì stná mii‑nsiá nècuàchì fariseu! Datiaá uun‑nsia vàha‑nsia. Vàchi tùha‑nsia (tnii diqui uun‑nsia ley, te) xidándiáá‑nsià vehe nècuàchì nì xìhì iì‑xí, te después sácuìta‑nsia nacuátú cuáhà‑nsiá na ian vàha guá‑nsià. Sàháyùcàndùá, iin castigu chicá fuerte icúmí‑nsiâ nìhì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ndahví mii‑nsiá nècuàchì ley xi veheñùhu, xì stná mii‑nsiá nècuàchì fariseu! Vàchi datiaá uun‑nsia vàha‑nsia. Ndè inicutu ñuhìví nácàhin‑nsia, te yáha stná‑nsià mar nducu‑nsiá ana dayáha‑nsia nùù religión xi‑nsia. Te nú sànì yàha‑ne, dandu sàhà (ley) xi‑nsia sáà stná‑nè nanduu‑ne ana malu, ndè ùì tantu gà más malu nanduu‑ne nùù mii‑nsiá, te sàhájàn chicá yàchì sàà‑nè andea. ");
INSERT INTO mitNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ndahví‑nsià! vàchi mate nahi nècuàchì cuaá nduú‑nsiá, doco cuní‑nsià dacúndéhe‑nsiá nèhivì índù iá ichì. Vàchi cachí‑nsià xì‑né ñà‑màdì obligación nduá nú ni caquín‑ndà compromisu, te chináhá‑ndá veheñùhu. Doco ñà‑ndùú compromisu ndisa nduú ñà‑chinaha‑nda oro iá veheñùhu, cachí‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","(¡Ndahví‑nsià!) ¿Índù chuun có‑sâà‑nsià cundaà ini‑nsià, te quidámáxìní‑nsià? ¿A có‑ìnáhá‑nsiâ ñà‑chicá ndiaá veheñùhu nùù oro mà? vàchi cuisì sàhà‑ñá iáˋ ini veheñùhu, ñàyùcàndùá nduá oro ìì. ");
INSERT INTO mitNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Daaní, cachí stná‑nsià ñà‑màdì obligación ndisa nduá nú ni caquín‑ndà iin compromisu, te chináhá‑ndá mesa ìì xí Dios. Doco ñà‑ndùú compromisu ndisa nduú ñà‑chinaha‑nda promesa iá nùù mesa mà, cachí‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pues ¿índù chuun có‑sâà‑nsià cundaà inì‑nsia, te quidámáxìní guâ‑nsia? ¿A có‑ìnáhá‑nsiâ chicá ndiaá mesa ìì mà nùù nsidaa promesa? Vàchi divi sàhà mesa‑mà níhì stná promesa mà ndu‑iìá. ");
INSERT INTO mitNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ñàyùcàndùá, nsidaa nècuàchì saquín compromisu, te chináhá‑nê mesa ìì, pues davani queámà na ian chináhá stnâ‑nè promesa iá nùù mesa mà. ");
INSERT INTO mitNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Daaní, stná iin nècuàchì saquín compromisu, te chináhá‑nê veheñùhu, pues iin‑ni nduú stná na ian chináhá stná‑nè mii‑yá iá ini veheñùhu ma. ");
INSERT INTO mitNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Te nècuàchì saquín compromisu, te chináhá‑nê ansivi, davani queé stná mà na ian chináhá stnâ‑nè silla ìì xí Dios, xì stná mii‑yá iá nùù silla mà. ");
INSERT INTO mitNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ndahví mii‑nsiá nècuàchì ley xi veheñùhu, xì stná mii‑nsiá nècuàchì fariseu! Vàchi datiaá uun‑nsia vàha‑nsia, mate túha‑nsia cuàha‑nsia diezmu xi (yùcù cuatilúhá nahi) ndua ndòò, xì anís, xì cominu. Doco ñà‑ndùú ley ìì chicá ndiaá, ni có‑quìhín casu‑nsiàñà, mate nacáníámà sàhà nansa cunihnu ndàcuisì ini‑ndà, te cundehè ndàhví stnahá stná‑ndà, xì stná ñà‑cunihnu vàha ini‑ndà mii‑yá. Pues ñà‑jaàn ndisa ndiá ìcà‑nsiá quida‑nsia cumplir, te ni có‑xìñùhù nacoo stná‑nsià diezmu mà. ");
INSERT INTO mitNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Doco nahi nècuàchì cuaá cuní dacúndéhe xi inga nèhivì índù iá ichì, ducán nduú‑nsiá. Mate daxíxin‑nsia nsidaa ndutè xihí‑nsiá sàhà‑ñá màsà cócó‑nsiâ ni‑iin quisì tìì, doco iin chuun ndiaá ndisa, ni có‑ndùlócô‑nsià sàhámà. Ñàyùcàndùá, ducán queámà na ian sànì coco‑nsiá (iin quisì cahnú) na iin camellu. ");
INSERT INTO mitNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ndahví mii‑nsiá nècuàchì ley xi veheñùhu, xì stná mii‑nsiá nècuàchì fariseu! Pues náhà xìcà datiaá uun‑nsia vàha‑nsia, vàchi dohó iá estilu xi‑nsia na ian nacáté‑ndá iin pocillu, ò iin còhò, te cuisì yàtà‑ñá nacáté‑ndá, doco (inià, quini iáˋ. Te divi ducán iá stná) anima‑nsià, chitu stná cuàchi ñà‑xího‑nsiá cuàhà iñàha, te quidá ndévàha‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Ndahví mii‑nsiá nècuàchì fariseu! Cutu quidámáxìní‑nsià. Vàchi (nú icúmí‑ndá) iin pocillu ò iin cóhò, amádi primeru inià ndundoo, dandu vàtùni coo ndoo (inià xì) stná yàtà‑ñá. (Pues ducání xiñuhu ndoo stná anima‑nsià.) ");
INSERT INTO mitNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ndahví mii‑nsiá nècuàchì ley xi veheñùhu, xì stná mii‑nsiá nècuàchì fariseu! Vàchi datiaá uun‑nsia vàha‑nsia, doco còó. Nahi monumentu (ndé índùxin nsìi), ducán nduú‑nsiá; vàchi cuaha‑ni iámà nú sànì ndanuu cuxán, doco inì‑xi ñuhú chitu iquì nsíi xi cuàhà ñà‑sìquini. ");
INSERT INTO mitNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ducán iá stná mii‑nsiá, indéhe nèhivì mii‑nsiá na ian nèhivì vàha nduú‑nsiá, doco danani uun‑nsia, vàchi anima‑nsià, chituá ñà‑có‑ndiàá. ");
INSERT INTO mitNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ndahví mii‑nsiá nècuàchì ley xi veheñùhu, xi stná mii‑nsiá nècuàchì fariseu! vàchi datiaá uun‑nsia vàha‑nsia. Pues mii‑nsiá nduú ana quidávàha monumentu nùù ñaña xí nècuàchì profeta nìsa cahàn cuenta xi Dios sànaha, te nsidácútú stná‑nsià lugar ndé xí‑indùxin nsìi nì sanduu nèhivì vàha. ");
INSERT INTO mitNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Dandu cachí‑nsià: “Nú ni cúndóó nsiùhù tiempu sànaha ni cuí, dandu mà cáhni‑nsí nèhivì cáhàn cuenta xi Dios nacua nì quida xìì‑ndà”. ");
INSERT INTO mitNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pues cunaha‑nsiá, sàhà palabra jaàn claru cachí‑nsià ñà‑mii‑nsiá nduú‑nsiá meru descendencia xi nècuàchì nì casahnì xì nèhivì xí‑yá sànaha. ");
INSERT INTO mitNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ñàyùcàndùá, nú yohòtéhè‑nsiá nduú nècuàchìmà, dandu mà úhì quida stná‑nsià divi nacua nì quida mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Mii‑nsiá, nahi anima còò nduú anima‑nsià, nacua xìì‑nsiá sànaha ma, te ducán stná mii‑nsiá vichi! Còò ni‑iyuhu modo nansa càcu‑nsia nùù andea, vàchi icúmí‑nsiâ ndoho‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sàháyùcàndùá, icúmî techuín nèhivì càhàn xì‑nsiá, divi nècuàchì profeta, xì stná nècuàchì nchichí, xì cuàhà stná maestru. Doco ináhî mii‑nsiá, ñà‑ìcúmí‑nsiâ quida quini‑nsia xì‑né. Dava‑ne cahnì‑nsiá; te dava‑ne chituu‑nsia nchìca cruz, te dava ga‑nè cahnì cuìí‑nsià ini veheñùhu xi‑nsia, te dava ga‑nè taxi‑nsiá ñuu te ñuu. ");
INSERT INTO mitNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ñàyùcàndùá, fuerza icúmí mii‑nsiá nacuida‑nsia cuàchi sàhà nsidanicuú nècuàchì vàha sànì sahnì nèhivì ñuhìví yohó. Dihna Abel nì xìhì nùù nsidaa gá nècuàchì vàha, dandu iin‑ni vàxi‑nda duha dècuèndè nì xìhì stná dèhe Berequías nani Zacarías, vàchi divi (nèhivì nihnú inì‑xi nahi) mii‑nsiá nì sahnì xì nècuàchìmà na iín‑né mahì veheñùhu cahnú xì mesa ìì ndé sahmí‑né ñà‑càmánì‑ndà Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ñàyùcàndùá, yùhù cachíˋ xì nsidaa mii‑nsiá nèhivì tiempu vichi, fuerza icúmí‑nsiâ cunsida‑nsia cuàchi sàhà nsidanicuú nsìi ma. ");
INSERT INTO mitNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Ndahví mii‑nsiá nècuàchì ñuu Jerusalén! vàchi tùha‑nsia cahnì‑nsiá nècuàchì cáhàn cuenta xi Dios, vàchi na techúûn‑yánè sàà‑nè nùù‑nsiá, dandu caníyúú‑nsiânè ñà‑cui‑nè. Na cuahà guá xichi nì cunì danátáquì mii‑nsiá nùí, na ian danátácá sìùn pílù xi‑sì ñà‑nàcùñuhu quisì mà tìxi ndìxìn‑sí; doco còó, cónì cùní‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ñàyùcàndùá, icúmí lugar xi‑nsia yohó ndòo nihnia. ");
INSERT INTO mitNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Te cachí stnáì xì‑nsiá, mà cúní gà‑nsià yùhù ndè cachi sàà quìvì cachi‑nsià xìˊ: “Ndiaha gá mii‑ní, vàchi divi ana vàxi cuenta xi Stoho‑ndà Señor nduu‑ní”. ");
INSERT INTO mitNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Daaní, nì quee Jesús veheñùhu cahnu‑ma cuàhàn‑yá. Te nì catnàtuu nècuàchì dacuahá‑yá nùù‑yá, cuní‑nè dacuní‑nèyà nansa ndáa vehe nahnú ndoó yatni yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Doco nì cachi‑yà xì‑né: ―¿A xiní‑nsià nsidaa vehe yohó? Yùhù cachíˋ xì‑nsiá, vàxi iin quìvì, dandu mà códotnahá gá ni‑iin yùù yohó. Vàchi icúmíâ caà nsìhá quida nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Daaní, cuàhàn cuaán‑yá xì‑né ndè yucù Olivo, te nì catnàtuu nècuàchì dacuahá‑yá, cachí‑nè xì‑yá: ―Cachì‑ní xì‑nsí ¿índù quìvì cuu nsidaa ñà‑nì cachì‑ní jaàn? ¿Índù milagru coo ñà‑cundaà ini‑nsì ñà‑sà‑ìtúú naxicocuíìn‑ní, te xìnu tiempu yohó? ");
INSERT INTO mitNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dandu nì cachi‑yà xì‑né: ―Cuidadu cundoo‑nsia ñà‑màsà dándáhvî ni‑iin nèhivì mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vàchi cuàhà ana icúmí quixi dananí uun‑tè nduú‑te yùhù, te cachi iin iin‑tè xì nèhivì ñà‑Cristu nduú‑te. Te sàhájàn cuàhà nèhivì nìhì‑té dandahví‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Daaní, icúmí cunitnùhu stná‑nsià iá cuàhà guerra yohó te yucán. Doco màsà yúhî‑nsià, vàchi fuerza icúmí coo ducán. Doco tàñáha ga sàà xìnu tiempu yohó cunduamà: iá gà ñà‑vàxi cuu. ");
INSERT INTO mitNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vàchi ñuu xì ñuu icúmíâ nàá stnahá. Te cuàhà rey icúmí‑tê dandacú‑te ñà‑coo guerra xì inga ñuu. Te icúmí coo stná tnama, te caca cuàhà stná cuèhè dana. Te yohó te yucán ñuhìví icúmí tnàa stná. ");
INSERT INTO mitNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Doco ñà‑jaàn làcà cuàhàn quesaha tnùndoho nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Daaní, tiempu yucán icúmí nèhivì tnii‑ne mii‑nsiá, te quida quini‑ne xì‑nsiá. Te dava‑nsia icúmí‑nê cahnì‑né. Vàchi sàhà yùhù icúmí nsidaa nèhivì cuni ùhì‑nè mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Te cuàhà‑né cuàhàn stná‑nè nacuaà‑né Dios. Ni mà cuíñúhú gâ stnâ‑nè ñanìtnaha‑ne; mà úhì cahin‑nè ñanìtnaha‑ne nùù tè‑xídandacú. ");
INSERT INTO mitNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Daaní, icúmí ndecoyo cuàhà stná tètnùhù. Cuenta xi Dios cáhàn‑te, cachì‑te, te mà úhì nìhì‑té dandahví‑te cuàhà nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Te ñà‑cuàhà guá cuàchi icúmí coo ñuhìví, ñàyùcàndùá mà cúú stnahá gá ini nèhivì sàhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Doco nèhivì iin‑ni cunihnu vàha inì‑xi dècuèndè xìnu tiempu, icúmí‑nê càcu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Te tiempu ma icúmí cuìtià stná razón ndiaha sàhà ñuhìví ìì xí Dios; inicutu ñuhìví icúmíâ cuìtià, te cunitnùhu nèhivì ndoó nsidaa ñuu. Dandísá, ñà‑sànì sàà quìvì xìnu tiempu yohó cundua. ");
INSERT INTO mitNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Sànaha nì cachitnùhu Daniel iin palabra xi Dios sàhà nansa icúmí coo iin figura dana có‑xìñùhù dahuun‑ya. Cunaha‑nsiá, quìvì cuni‑nsià sànì sàcuììn figura mà ini lugar chicá ìì, (dandu seña cundua). Te vichi xiñuhu cundaà ini nsidaa ana càhvì‑xì tutu yohó. ");
INSERT INTO mitNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Te na sáà quìvì yucán, dandu ni cunúdèhé nsidaa nèhivì ndoó ladu Judea yohó, te cùhùn‑nè yucù. ");
INSERT INTO mitNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Te nú ndoó nèhivì quetátú dìnìvèhé‑xi, dandu yàchì ni nuú‑né, te cunudèhé stná‑nè; doco màsà (nánsìhvi‑ne) vehe nsiquihin‑ne ñà‑ndùá icúmí‑nê. Còó. ");
INSERT INTO mitNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Te nú ndoó‑né nùù ìtú, dandu màsà nándúcú‑nê ni cotón‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Te ¡ndahví stná nècuàchì ñahà cuhí cuàhàn tùinuù méè‑xi quìvì yucán! Te ¡ndahví stná nècuàchì icúmí xí mêè chichi! ");
INSERT INTO mitNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Te càcàn tàhvì stná‑nsià nùù Dios ñà‑màsà cúvìxin tiempu cunudèhé‑nsià mà, te màsà cúndúú stnâ iin quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Vàchi quìvì yucán yáha ga icúmí nèhivì ndoho‑ne. Còò gá tnùndoho chicá cahnú ni ía ndè quìvì nì cuyucun ñuhìví xì ndéˋ quìvì coamà; te ni quìvì después, mà sáà coo ga tnùndoho ndudava xi ñà‑jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te nú màsà cúndéhe ndahví Dios, te dacúxíó yáchì‑yà tnùndoho ma, dandu ndutu nsihí nèhivì ñuhìví nì cùí. Doco sàhà nèhivì xí‑yá sànì nacàxin‑ya, ñàyùcàndùá chicá yàchì icúmí‑yâ dacúxíó‑yá tnùndoho ma. ");
INSERT INTO mitNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Quìvì yucán màsà cúníndísâ‑nsiá yuhù nèhivì cachí xì‑nsiá: “Cundehè‑nsiá, yohó iá ana nduú Cristu”, te ò nú cachí‑nè: “Cundehè‑nsiá, yucán iá‑yà”. ");
INSERT INTO mitNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vàchi icúmí quixi cuàhà tètnùhù, te iin iin‑tè cachì‑te ñà‑divi Cristu nduú‑te. Te tiempu‑mà quixi stná cuàhà ana dananí uun cáhàn cuenta xi Dios. Ndè quida stná‑te cuàhà milagru fuerte ñà‑ndulocó nèhivì, áma níhì‑te dandahví‑te nèhivì nì nacàxin‑ya cahan‑té; doco mà cúí. ");
INSERT INTO mitNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cunaha‑nsiá, sànì cachitnùhi xì‑nsiá nsidaa ñà‑ndùá icúmí cuu. ");
INSERT INTO mitNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ñàyùcàndùá, nú cachí nèhivì xì‑nsiá: “Yucán iá‑yà yucù”, màsà cúhùn‑nsià yucán. Te ò nú ni cachí stnâ‑nè: “Ini vehe yohó iá‑yà”, màsà cúníndísâ‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Vàchi na ian tása, te xiní nèhivì natnúù fuerte ndè iin ladu ansivi xi ndéˋ inga ladúà, ducán icúmí (natùi vate) stná yùhù ana nduú Tnaha Nèhivì Ñuhìví quìvì naxicocuíìn. ");
INSERT INTO mitNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","(Doco nèhivì malu, ducán icúmí cuu xi‑né nahi dichu cachí:) “Ndé indúhu ñà‑ndùá nì xìhì, yucán icúmí nataca stná longo”. ");
INSERT INTO mitNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Nú sànì yàha tiempu tnùndoho ma, dandu mà cúnchíi gá ni orá ni yoo. Te sìnsìví itándiaa ansivi, icúmí‑sî còyo nihni‑sì nùù ñuhìví. Te sìtnúù nahnú, icúmí stnâ‑si ndacùchí ndee‑sí. ");
INSERT INTO mitNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dandu después icúmí natùi seña ansivi (ñà‑cundaà ini‑nsià sà‑ìá naxicocuíìn) yùhù ana nduú Tnaha Nèhivì Ñuhìví. Dandu nèhivì nsidaa ñuu, icúmí‑nê cuacu‑ne na cundehè‑né mànui mahì vìcò xì poder cahnú xí, te ndiaha gá coo inicutu ndé mànui. ");
INSERT INTO mitNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dandu icúmí sivi stná corneta, te techuín ángel xi cùhùn‑nè inicutu ñuhìví ñà‑danátácá‑nè ana nduú nèhivì sànì nacàxin, mate lugar chicá xica ñuhìví ni cúndóó‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Vichi cuàhìn nacani iin ejemplu sàhà nù‑higu sàhà‑ñá cundaà ini‑nsià. Nú sànì ndunsidi‑nú, te nì quesaha naná ditù yuté‑nu, dandu ñà‑yùcàn cùndáà ini‑ndà sà‑ìtúú tiempu ihni. ");
INSERT INTO mitNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Te divi ducání stná xì ñà‑ndùá icúmí cuu; quìvì cuni‑nsià cuú ñà‑ndùá sànì cachì xì‑nsiá, dandu vàtùni cundaà stná inì‑nsia ñà‑sà‑ìtúú tiempu naxicocuíìn ndùá; sà‑ìtúú nihni. ");
INSERT INTO mitNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cunaha‑nsiá, mà sáà cui nsihi nèhivì itiácú vichi dècuèndè cachi sànì cuu ndisa nsidaa ñà‑ndùá sànì cachì xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cunaha‑nsiá, icúmí sàà ansivi xi ñuhìví ndañuhá, doco palabra nì cachi yùhù, còó, mà nunca sàà ndañuhá. ");
INSERT INTO mitNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","37","’Doco ni quìvì, te ni hora naxicocuíìn, ni‑iin nèhivì có‑ìnáhá‑nê. Ni ángel ndoó ansivi, có‑ìnáhá stnâ‑nè; ni yùhù ana nduú Dèhemanì Dios, có‑ìnáhá stnâì, cuisì Yuamánìˊ Dios ináhá. Vàchi nacua nì cuu tiempu xi Noé, ducán icúmí cuu stná na sáà meru quìvì naxicocuíìn yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Vàchi na táñâha ga cuun dàvì dàhvi ñuhìví, dandu (ndoó cuéyàà nèhivì ñuhìví), xixí‑né, xihí‑né, nándàhà‑né; te ducán nìsa quida‑ne dècuèndè nì sàà quìvì nì quìhvi Noé ini barcu cahnú. ");
INSERT INTO mitNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Te ni cónì sáà mànìhì tnùní ini nèhivì mà dècuèndè nì quixi dàvì, te nì càhà nsihi‑ne. Te divi ducán icúmí coo stná tiempu naxicocuíìn yùhù. ");
INSERT INTO mitNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ndé ndoó ùì nèhivì nùù ìtú, icúmí iin‑ne cuxio‑ne, te iin‑ne ndòo. ");
INSERT INTO mitNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Te ndé ndoó ùì nècuàchì ñahà cutnáhâ nchicó, iin‑ne cuxio, te inga‑nè ndòo. ");
INSERT INTO mitNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ñàyùcàndùá, cundoo tùha‑nsia, vàchi có‑ìnáhá‑nsiâ índù quìvì icúmí naxicocuíìn yùhù ana nduú Stoho‑nsià Señor. ");
INSERT INTO mitNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Doco nsinuu inì‑nsia nansa quidá iin stoho vehe: nú sànì xinitnùhu‑ne índù hora quixi tècuìhnà ñuú, dandu cundiatu tùha‑ne; mà cuáha‑ne quìhvi‑tè nì cùí. ");
INSERT INTO mitNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ñàyùcàndùá, stná mii‑nsiá, nicanicuahàn cundoo tùha‑nsia, vàchi iin quìvì có‑nìhnú ini‑nsià, divi quìvì jaàn icúmî naxicocuíìn. ");
INSERT INTO mitNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Ana tuxí inì‑nsia nduú nahi peón nùù ejemplu yohó? Nì ìa iin peón tùha quida viì; nicanicuahàn quidá sahnú‑te. Ñàyùcàndùá, nì nìhì‑té chuun nùù lamú xi‑tè ñà‑dandacú‑te nùù peón dava ga, te dasàn stná‑te ñà‑cutiacu nsidaa gá peón mà quìvì xiñuhá. Dandu cuàhàn xìcà lamú mà. ");
INSERT INTO mitNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pues nansicáhán peón dandacu‑ma nú iin‑ni ni quidá víi‑té dècuèndè nsiaa lamú xi‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Vàchi cunaha‑nsiá, icúmí nècuàchìmà cuàha‑nète chuun chicá ndiaá ñà‑dandacú‑te sàhà nsidanicuú ñà‑cuìcà‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Doco nú peón malu nduú‑te, dandu quesaha‑té nacání chicuéhè inì‑te, te cachì‑te: “Còó, cucueè‑va lamú xi, dandu nsiaa‑nè”. ");
INSERT INTO mitNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Dandu quesaha‑té cahnì cuìí‑te peón dava ga mà, te cuisì‑ní ñà‑cuxi‑tè, coho‑tè, xìni‑tè cunì‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pues nú ducán ni quidá‑te, dandu iin quìvì có‑nìhnú inì‑te nsiaa lamú. ");
INSERT INTO mitNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dandu nìhì‑té iin castigu cahnú sàstnùhù, te sàhámà cuacu ndee‑té, te càna fuerte nùhu‑tè, vàchi ducán icúmí ndoho nsidaa nèhivì dananí úún vàha inì‑xi. ");
INSERT INTO mitNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Ducán iá ley xi ñuhìví ìì xí Dios na ian nì cuu xi ùxìn ñahà cuàchì cuàhàn ndé cundiatuà quesaa noviu (xì novia), te iin iàn nihá lámpara xi‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Ùhùn‑ña, listu‑ña, nihí‑ña sìquìi ndutè xíxìn cuàhàn xì lámpara. Doco inga ùhùn‑ña, cónì nácání inìa, ñàyùcàndùá còò ndúte xíxìn nìsá níhí‑ña cúhùn. ");
INSERT INTO mitNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Daaní, sàhà‑ñá nì cuee guá ana nándàhà, ñàyùcàndùá nì tnii vàhná nsì‑úxìn‑ña nì quìdìa. ");
INSERT INTO mitNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Te nahi dava ñùu, dandu nì tiacu ndáhì iin nèhivì, cachí‑nè: “¡Cunaha‑nsiá, sàmàndixi noviu! ¡Naha‑nsià casàhú‑nsià xì‑né!” ");
INSERT INTO mitNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ñàyùcàndùá, nì ndacuìta nsidaa ñahà cuàchì mà nì nacuicùn‑ñá lámpara xi‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dandu ñahà cuàchì mà‑túha nacani inì‑xi, nì cachà xi ñahà cuàchì listu mà: “Taxi toó sacu‑nsià chii ndutè xíxìn xi‑nsia nùù‑nsí, vàchi meru cuàhàn ndàhvà lámpara xi‑nsi”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Doco nì cachi compañeru‑ña ma: “Còó, vàchi vihini mà sáà‑té sàhà nsidaa‑nda; chicá vàha cuahán‑nsià cuiin‑nsiàte ndé cûyàhvi‑tè, dandu cucumi‑nsiáte”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","(Ñàyùcàndùá, cuàhàn‑ña cuiin‑ñà.) Te na sánì yàha‑ñà cuàhàn‑ña, dandu nì nsiaa noviu, te nì cayàha nècuàchì ndiatu‑ma ndé iá vicò, te nì nandiadi yehè. ");
INSERT INTO mitNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Daaní, después nì nsiaa tu ùhùn ñahà cuàchì nì sàhàn mà, te nì càhàn‑ña yehè, cachí‑ña: “¡Señor! ¡Señor! ¡Nacuna sacù‑ní yehè!” ");
INSERT INTO mitNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Doco nì naxiconihí nècuàchì nduú noviu mà, cachí‑nè: “Yùhù, de plano, có‑ìnáhî ana nduú‑nsiá”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","(Ducán nì cuu xi ñahà cuàchì mà. Ñàyùcàndùá cachí stnáì xì mii‑nsiá:) ni cúníhnú vàha ini‑nsià, vàchi có‑ìnáhá‑nsiâ índù quìvì, te ni índù hora naxicocuíìn yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ducán iá stná ley xi ñuhìví ìì xí Dios nacua nì quida iin lamú na cuáhàn‑nè quee‑ne cùhùn‑nè inga ñuu; nì cana‑ne nsidaa peón xi‑ne, te nì dasàn tòó‑né ñà‑cuìcà‑né nùù‑té. ");
INSERT INTO mitNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iin‑tè nì nìhì ùhùn mil dìhùn plata; ingà‑te nì nìhì ùì mil, te inga stná‑te nì nìhì iin mil‑ni, según nansa tiacu ini iin iin‑tè, ducán nì nìhì‑té. Dandu nì quihin lamú mà ichì cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","’Daaní, peón nì nìhì ùhùn mil mà, nì quesaha‑té nì quida‑tè negociu xì dìhùn mà, te nì nìhì‑té nì nandua inga ùhùn mil. ");
INSERT INTO mitNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Te ducán nì quida stná peón nì nìhì ùì mil, nì sàà nì nàcùnduu stná inga ùì mil. ");
INSERT INTO mitNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Doco tè‑nì nìhì iin mil‑ni, nì sate‑tè tìxi ñuhù, te nì sùxin‑tèá. ");
INSERT INTO mitNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Daaní, na sánì yàha caní tiempu, dandu nì nsiaa lamú mà, te nì natnii‑ne cuenta ñà‑cundaà ini‑nè nansa nì quida iin iin peón xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Te nì tnàtuu peón nì nìhì ùhùn mil, nì nacuàha‑tènéà xì stná inga ùhùn mil, te nì cachì‑te: “Señor, ùhùn mil nì nacoo‑ní nùí, te vichi yohó iá gà stná inga ùhùn mil nì quide ganar”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ñàyùcàndùá, nì cachi lamú mà xì peón mà: “Vàtùni nì quida‑ní. Peón vàha nduu‑ní. Sànì quida viì‑ní mate chuun cuatilúhá nì sandua. Ñàyùcàndùá, icúmî cuàhi mii‑ní ñà‑dandacu‑ní nùù cuàhà chuun nahnú. Yàha‑ní yohó, cundoo‑nda cudiì ini‑ndà”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Daaní, nì tnàtuu peón nì nìhì ùì mil, te nì nacuàha‑tènéà xì stná inga ùì mil, te nì cachì‑te: “Señor, ùì mil nì nacoo‑ní nùí, doco cunaha‑ní, yohó iá gà stná inga ùì mil nì quide ganar”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dandu nì cachi lamú mà: “Vàtùni nì quida stná mii‑ní. Peón vàha nduú stná‑ní. Sànì quida viì‑ní mate chuun cuatilúhá nì sandua. Ñàyùcàndùá, icúmî cuàhi mii‑ní ñà‑dandacu‑ní nùù cuàhà chuun nahnú. Yàha‑ní yohó, cundoo‑nda cudiì ini‑ndà”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Dandu nì tnàtuu stná peón nì nìhì iin mil‑ni ma, te nì cachì‑te xi lamú mà: “Yùhù ináhî mii‑ní ñà‑dana gà‑ní; mà úhì quihin‑ní cosecha ndé có‑xìtù‑ní, te mà úhì quindiaà‑ní iñàha mate cónì quìdà‑níà. ");
INSERT INTO mitNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ñàyùcàndùá, nì yùhîˋ, te nì sùxin dìhùn xí‑nî tìxi ñuhù. Yohó iáˋ; naquihin‑níà”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dandu nì cachi lamú mà xì‑té: “¡Peón malu nduu‑yó! ¡Dusan‑yó! Nú sà‑ìnáhú ñà‑quìndiáì cosecha ndé có‑xìtuí, te xidándiáì iñàha ndé cô‑quìdáchúîn, ");
INSERT INTO mitNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","pues, nú ducán, dandu ndiá ìcò cuàhu nècuàchì bancu dìhùn xí, dandu quìvì nsiaì vàtùni nìhì stnáì dìquìá nì cùí”, nì cachi lamú mà. ");
INSERT INTO mitNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dandu (nì càhàn stná‑nè) xì peón itá yucán, cachí‑nè: “Quindiaa‑nsià mil dìhùn jaàn nùù tè‑yòhó, te cuàha‑nsia nècuàchì sà‑ìcúmí ùxìn mil. ");
INSERT INTO mitNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Vàchi nècuàchì sà‑ìcúmí algu vichi, icúmí‑nê nìhì gá‑nè más, dandu vihi gá cucumi‑né; doco ana có‑ìcúmí vichi, icúmí cuxio nsihi nsidaa iyuhu gá ñà‑ìcúmí‑nê. ");
INSERT INTO mitNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Cunaha‑nsiá, còò chuun peón yohó. Ñàyùcàndùá, dandiachi‑nsiáte fuera ndé iín tnúú ndúchí, te yucán icúmí‑tê cuacu ndee‑té, te càna fuerte stná nùhu‑tè”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Ndiaha gá coo quìvì naxicocuíìn yùhù ana nduú Tnaha Nèhivì Ñuhìví. Quìvì naxicocuíìn icúmî cutnahá stnáì xì nsidaa ángel ìì xí quixi. Dandu nàcòi nùù silla ndiaha xí (ndé cùsáhnuî), ");
INSERT INTO mitNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","te (cani) nèhivì nsidanicuú ñuu ñà‑nataca‑nè nùí. Dandu icúmî tavà cuàín nèhivì (vàha nùù nèhivì malu) na quidá pastor na nácàxin‑ne quisì xí‑né, iladu ndoó riì, te inga ladu ndoó sìmbee. ");
INSERT INTO mitNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ladu cuahíˋ icúmí màcuìta (nèhivì vàha na ian nduú‑né) riì, te ladu ìtníˋ icúmí màcuìta (nèhivì malu na ian nduú‑né) sìmbee. ");
INSERT INTO mitNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Dandu (yùhù) ana cusáhnû, icúmî cachì xì nèhivì ladu cuahíˋ: “Naha‑nsià, cundoo‑nsia ñuhìví ìì xí Yuamánìˊ, vàchi dècuèndè tiempu nì cuyucun ñuhìví sànì chitnùní ini‑yà cundiatú anima‑nsià ducán. ");
INSERT INTO mitNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Vàchi na ní xìhì güéˋ doco, nì dàcùxí‑nsiá yùhù; te na ní xìhì stnáì tècuìí, nì dàcútâhvì‑nsiá yùhù chii‑té. Daaní, na ní xìcanuu ndahví stnâì, dandu nì dàyáha‑nsia yùhù vehe‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Còò dúhnùí, doco nì taxi‑nsia ñà‑nì sàcùndixi. Nì cuhi stnáì, te nì nàcòtò‑nsià yùhù. Te na ní sandiadì vehecàa, nì sàà stná‑nsià visita yucán”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dandu nsidaa nèhivì vàha yucán, icúmí‑nê cachi‑nè xìˊ: “Stoho‑nsì Señor, (cónì cùndáà ini‑nsì nì chindee‑nsí mii‑ní ducán). ¿Índù nì xini‑nsì mii‑ní ñà‑xíhì‑ní doco, te nì dàcùxí‑nsí mii‑ní, te ò xíhì‑ní tècuìí, te nì taxi‑nsi tècuìí nì xihi‑ní? ");
INSERT INTO mitNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Índù nì xini‑nsì xicánúú ndahví‑nî, te nì dàyáha‑nsi mii‑ní vehe? Ni‑iin xichi cónì xìní‑nsì ñà‑còò dúhnù‑ní, te nì sàha‑nsi mii‑ní ñà‑nì sàcùndixi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ni có‑ìnáhá stnâ‑nsì nì cuhì‑ní, ò ní sandiadì‑ní, te nì sàà‑nsì visita ndé iá‑nî”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dandu yùhù ana cusáhnû, icúmî cachì xì nècuàchìmà: “Cunaha‑nsiá, nahi ñanì xínduu nèhivì itá yohó. Ñàyùcàndùá na cada nì quida‑nsia favor sàhà iin‑ne, mate nduú‑né iin ana chicá cahíchì ini nèhivì, doco davani queámà na ian nì quida stná‑nsià favor xì yùhù”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Daaní icúmî càhàn stnáì xì nèhivì itá ladu itníˋ, te cachì xì‑né: “¡Cuxio‑nsia nùí! Còò cá nansa càcu‑nsia. Cuahán‑nsià ndé iá ñuhu xíxìn nicanicuahàn, divi lugar nì quidayucun Dios ñà‑coo ñà‑malu xì nsidaa ángel (malu) xi‑sì. ");
INSERT INTO mitNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Vàchi yùhù, na ní xìhì doco, nì xidahan‑nsiá ñà‑cuxi. Nì xìhì stnáì tècuìí, te ni‑iyuhu‑té cónì sáha‑nsia yùhù cohi. ");
INSERT INTO mitNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Xicánúú ndahví stnâì, doco cónì dàyáha‑nsia yùhù vehe‑nsia; còò dúhnùí, doco còò ni‑iin sìcoto nì sáha‑nsia yùhù. Nì cuhi vàhi, te nì sandiadi stnáì, doco cónì sáà‑nsià nàcòtò‑nsia yùhù”. ");
INSERT INTO mitNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dandu nèhivì mà, icúmí‑nê cachi‑nè xìˊ: “Señor, mà nunca nì xìní‑nsì mii‑ní na xíhì‑ní doco, ò xíhì‑ní tècuìí, ò xìcánúú ndahví‑nî, ò còò sícoto vàha xi‑ní, ò cùhí‑nî, ò ndiàdí‑nî. ¿Índù nì xinì‑ní nsiùhù nì xidahan‑nsí nsidaámà nùù‑ní?” ");
INSERT INTO mitNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dandu yùhù, icúmî cachì xì‑né: “Cunaha‑nsiá, ñà‑cónì chíndéé‑nsiâ nèhivì ndahví yohó, ñàyùcàndùá davani queámà na ian sànì cahíchì stná inì‑nsia yùhù”. (Ñà‑jaàn nduá icúmî cachì xì nècuàchì malu mà.) ");
INSERT INTO mitNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ñàyùcàndùá icúmí nsidaa‑né yàha‑ne ndé ndoho‑ne nicanicuahàn. Doco nèhivì vàha, còó. Vida ndiaha nicanicuahàn icúmí‑nê nìhìtáhvì‑né ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Daaní, nì nsihi nì nacani Jesús nsidaa ñà‑jaàn xì nècuàchì dacuahá‑yá, dandu nì cachi‑yà xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Sà‑ìnáhá‑nsiâ ñà‑tìxi ùì quìvì icúmí nacava vicò pascua, dandu yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî yàhi ndahà nèhivì, te cahnì‑né yùhù nchìca cruz. ");
INSERT INTO mitNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Daaní, nì nataca dùtù xícusahnú, xì nècuàchì ley xi veheñùhu, xì stná nècuàchì sahnú dandacú ñuu yucán, nì sàà nsidaa‑né patiu vehe cahnú dùtù chicá cusáhnû nani Caifás. ");
INSERT INTO mitNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Te nì ndatnuhu tnahá‑né nansa tnii dèhé‑nè Jesús, te cahnì‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Te nì cachi stná‑nè: ―Chicá vàha màdì mahì vicò tnii‑nda nècuàchìmà, vàchi nú ducán, dandu vihini nacuidà nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iá‑yà vehe iin nècuàchì ñuu Betania nani Simón. Nècuàchìmà nduú iin nèhivì nì sandoho cuèhè lepra antes. ");
INSERT INTO mitNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Te yucán nì sàà stná iin nècuàchì ñahà, nihí‑né iin quìdi iá dùcùn‑xí. Yùù nì cuyucàn, te ñuhú ndutè tnàmì ndiaá sàstnùhù. Te divi ndutè mà nì sòdò‑nè itnu dìnì Jesús na iá‑yà xixí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Doco na ní xini nècuàchì dacuahá‑yá, nì cuduchi ini‑nè, cachí‑nè (iin‑ne xì inga‑nè): ―¿Índù chuun nì sate uun‑ne ndutè jaàn? ");
INSERT INTO mitNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chicá vàha dicò‑néte ni cuí, dandu tùi cuàhà dìhùn dasàn‑ndà nùù nècuàchì ndahví. ");
INSERT INTO mitNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Doco Jesús, ináhá‑yâ nansa cachí‑nè, ñàyùcàndùá nì cachi‑yà xì‑né: ―¿Índù chuun cánàhá‑nsià xì nècuàchì jaàn? Vàchi iin ñà‑vàha nduá quidá‑né xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vàchi nècuàchì ndahví, nicanicuahàn ndoó‑né xì‑nsiá; doco yùhù, còó, sacù‑ni quìvì iéˋ xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cunaha‑nsiá, ñà‑nì sòdò nècuàchì yohó ndutè tnàmì dìní, divi sàhà‑ñá cutatna cuerpu yùhù na ndúxan nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Te ñà‑ndáà nduá yohó cachítnùhi xì‑nsiá: nsidanicuú ñuu ndé icúmí sàà razón ndiaha xí Dios inicutu ñuhìví, yucán icúmí sàà stná palabra sàhà ñà‑vàha nì quida nècuàchì ñahà yohó, te ducán mà nunca sàà nèhivì ñuhìví nandòdó‑né nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nùù ùxìn ùì compañeru Jesús, iin‑ne nani Judas Iscariote. Pues divi nècuàchìmà nì sàhàn nùù dùtù xícusahnú, ");
INSERT INTO mitNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","te nì cachi‑nè xì nècuàchìmà: ―¿Nadaa cuàha‑nsia yùhù, te quide Jesús entregar nùù‑nsiá? Dandu nì sàha dùtù mà‑né òcò ùxìn dìhùn plata. ");
INSERT INTO mitNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ñàyùcàndùá, dècuèndè quìvì yucán nì quesaha Judas mà nandúcú‑nê índù tiempu chicá mà úhì dayáha‑ne Jesús nùù ndahà nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Daaní, nì sàà tu quìvì primeru xi vicò xixí‑né pan có‑ndùtáchí. Te nì tnàtuu nèhivì dacuahá‑yá nùù‑yá, cachí‑nè: ―¿Índù divi cuní‑nî cùhùn‑nsì quidayucun‑nsì ñà‑cuxi‑nda comida vicò pascua? ");
INSERT INTO mitNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Te nì cachi‑yà xì‑né: ―Cuahán‑nsià ini ñuu ndè vehe iin tal nèhivì, te cachi‑nsià xì‑né ñà‑càchí maestru sà‑ìtúú meru quìvì xí‑yá, ñàyùcàndùá vehe mii‑ní icúmí‑yâ chivàha‑ya vicò pascua, mii‑yá xì nsidaa nècuàchì dacuahá‑yá. Ducán cachi‑nsià xì‑né ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ñàyùcàndùá, ducán nì quida nècuàchì dacuahá‑yá nacua nì sàcùnaha‑né nùù‑yá, nì nsidayucun‑nè comida pascua. ");
INSERT INTO mitNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Daaní, na ní cuaà, dandu (nì sàà stná) mii‑yá yucán, te nì sàcòo‑ya nùù mesa xì nsì‑úxìn ùì nècuàchì dacuahá‑yá. Te na iá‑yà xixí‑yá, dandu nì cachi‑yà (xì‑né): ―Cunaha‑nsiá, iá iin‑nsia cuàhàn cahin xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dandu nsidaa nècuàchìmà, nì nàcùndoo‑ne tnùnsí ini, te nì cachi iin iin‑ne xì‑yá: ―¿A víhíní yùhù, Señor mío? ");
INSERT INTO mitNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Te nì cachi‑yà xì‑né: ―Iin mii‑nsiá nècuàchì iin‑ni xixi‑xi‑nda nùù còhò yohó nduú ana icúmí cahin xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Vàchi ñà‑ndáà ndùá, icúmí cuu ndisa ñà‑ndùá nì cachitnùhu nùù tutu ìì ñà‑ìcúmí cui yùhù ana nduú Tnahá Nèhivì Ñuhìví. Doco tiàa cuàhàn cahin xìˊ, ¡ndahví‑nè! Chicá vàha màsà túinuù‑né ñuhìví nì cùí ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dandu nì càhàn Judas, divi tiàa cuàhàn quida xi‑yá entregar, te nì cachi‑nè: ―Maestro, ¿a víhíní yùhù nduí? Te nì cachi‑yà xì‑né: ―Ducán nduá nacua nì cachì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na meru xixí nsidaa‑né, nì tnii‑ya iin pan, te nì naquimanì‑yá Dios sàhà‑ñá. Dandu nì dàcuàchí‑yáñà, te nì dasàn‑yá nùù nècuàchì dacuahá‑yá yucán, te nì cachi‑yà: ―Cuxi‑nsia, vàchi pan yohó, nahi iquìcúñú yùhù nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dandu nì tnii stná‑yà pocillu, nì naquimanì‑yá Dios sàhà‑ñá, te nì sàha‑yanè, cachí‑yà: ―Nsidaa‑nsiá coho‑nsia chichii ndutè yòhó. ");
INSERT INTO mitNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Vàchi nahi nìì mií nduú‑te. Te cunaha‑nsiá, sàhà nììˊ icúmî nacoi iin ichì sàà cunchicùn nèhivì, vàchi nú sànì xìtià nìí, dandu sàhájàn icúmí ndutu cuàchi cuàhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Te vichi, mà cóhó guéˋ ndutè sì‑uva yohó ndè cachi sàà coho saa‑túì‑te xi‑nsiá quìvì cusahnú Yuamánìˊ inicutu ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Daaní, na ní nsihi nì xito nsidaa‑né iin alabanza, dandu nì quee‑ne cuàhàn‑nè xì‑yá ndè yucù Olivo. ");
INSERT INTO mitNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Te nì cachi‑yà xì‑né: ―Ñuú vichi, icúmí nsidaa‑nsiá nacoo nihni‑nsia yùhù; vàchi ducán cachí nùù tutu ìì: “Cuàhìn dacúxíóé pastor, dandu cuìtià nihni riì”, cacháˋ. ");
INSERT INTO mitNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Doco nú sànì natiacuì, dandu icúmî codònùí nùù‑nsiá nùhù ndè ladu Galilea. ");
INSERT INTO mitNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dandu nì cachi Pedro xì‑yá: ―Mate ni sáà nsidaa nèhivì nacoo nihni‑ne mii‑ní, doco yùhù, còó, mà nunca. ");
INSERT INTO mitNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dandu nì cachi‑yà xì‑né: ―Cunaha‑ní, divi ñuú vichi icúmí‑nî nacuaà‑ní yùhù. Tàñáha ga coto lehe sinduhá, te sànì nacuaà‑ní yùhù ùnì xichi. ");
INSERT INTO mitNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Doco nì cachi‑nè xì‑yá: ―Còó, mate ni cahní‑nèndó, doco mà nunca sàì nacuaìˊ mii‑ní ―nì cachi‑nè. Te divi ducání nì cachi gà stná nsidaa nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Dandu nì sàà‑yà xì‑né ndè iin xaan nani Getsemaní. Te nì cachi‑yà xì‑né: ―Yohó ndòo‑nsia, vàchi yùhù cuahìn chicá nùù‑xí càcàn tàhví nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dandu nì saca‑ya Pedro xì ùì ñàní dèhe Zebedeo, cuàhàn‑yà xì‑né. Te nì nàcòo cuahà‑yá tnùnsí ini; nì quesaha‑yá yáha ga nacání cuáhà ini‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dandu nì cachi‑yà xì‑né: ―Yáha ga iéˋ tnùnsí ini, na ian cuníà cahnì dáhúán yùhù. Ñàyùcàndùá, yohó ni ndóo‑nsia, te cunchito tùha‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dandu cuàhàn‑yà chicá nùù‑xí, nì sàcùnduhù ndèé‑yá, te nì xìcàn tàhvì‑yá nùù Yuamánì‑yá, cachí‑yà: ―Yuamánìˊ, xícàn tàhví nùù‑ní, áma dácúxíó‑nî (tnùndoho icúmî yàhi), vàchi nahi (ñà‑úà ñuhú iin) taza nduá nùí. Doco màdì ñá‑ndùá cuní yùhù ni cúndúá; còó, ñà‑ndùá cuní mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dandu nì naxicocuíìn‑yà vàxi‑ya ndé nì ndòo nècuàchì dacuahá‑yá, te nì xini‑yà sàquídì‑nè. Ñàyùcàndùá, nì cachi‑yà xì Pedro: ―¿Áma cúí cunchito stná‑nsià xì yùhù siquiera iin hora‑ni? ");
INSERT INTO mitNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cundoo tùha‑nsia, te càcàn tàhvì‑nsiá nùù Dios sàhá màsà dándáhvî ñà‑malu mii‑nsiá, vàchi mate iá voluntad xi‑nsia, doco iyuhu gá valor icúmí cuerpu‑nsià ñà‑quidandee inì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Daaní, tucu tu cuàhàn‑yà càcàn tàhvì‑yá nùù Dios, te nì cachi‑yà: ―Yuamánìˊ, nú icúmî yàhi tnùndoho fuerte, te mà cúí cuxioa, dandu ducanicoó nacua cuní mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Dandu vàxi tu‑ya (ndé ndoó nècuàchìmà), te nì xini‑yà tucu tu quídì‑nè, vàchi sádì vàhná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dandu nì nacoo‑yanè inga tu, te cuàhàn‑yà ñà‑únì, te davani nì xìcàn tàhvì‑yá (nahi antes). ");
INSERT INTO mitNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dandu nì naxicocuíìn‑yà, te nì cachi‑yà xì‑né: ―Cùdù cuéyàà‑nsià, te quetatu‑nsià vichi, vàchi sà‑ìá. Sànì sàà meru hora xi yùhù ana nduú Tnaha Nèhivì Ñuhìví, divi hora icúmî yàhi ndahà nèhivì cuáchi. ");
INSERT INTO mitNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ndacuìta‑nsia, cúhùn‑ndà, vàchi sà‑ìtúú quesaa ana cuàhàn cahin xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Daaní, cáhàn ìì‑yá xì nècuàchìmà, te nì quesaa Judas, divi tiàa nìsa cutnaha‑xi ùxìn iin ga nècuàchì dacuahá‑yá, te ndacá stná‑nè cuàhà gá tiàa xínihi xi espada xì garroti. Cuenta xi dùtù xícusahnú vàxi‑tè, xì cuenta xi stná nècuàchì xídandacú nùù ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Te sànì ndatnuhu Judas xì nsidaa ana ndacá‑némà ñà‑coo iin seña ana tnii‑tè, divi ana chìtú‑nè cunduu meru ana tnìì cúhùn presu. ");
INSERT INTO mitNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ñàyùcàndùá, nì tnàtuu Judas ndé iín Jesús, te vichi vichi nì casàhú‑nè xì‑yá, cachí‑nè: ―¡Cuñaàváha‑ní, maestro! Te nì chìtú‑nè nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dandu nì cachi‑yà xì‑né: ―Amigo, ¿índù chuun nihi‑ní vàxi yohó? Dandu nì tnàtuu tè‑dava ga mà nì tnii‑tèyá nì ndòo‑ya ndahà‑té. ");
INSERT INTO mitNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dandu iin nèhivì xí‑yá, nì tavà‑né espada xi‑ne nì cani‑ne iin tiàa quidáchúûn nùù dùtù cusáhnû, nì sahnde‑nè iin tùtnù‑té. ");
INSERT INTO mitNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Doco nì cachi‑yà xì‑né: ―Nachinacaà‑ní espada xi‑ní dòá, vàchi nsidaa ana caní xì espada, divi espada icúmí‑nê cui stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿A có‑cùndáà inì‑ní ñà‑vàtùni càcàn tàhví nùù Yuamánìˊ, te vichi duha techuún‑yá cuàhà mil ángel chindee xí? ");
INSERT INTO mitNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Doco nú ni cáquìn ducán, dandu mà cúí cuu ndisa ñà‑ndùá nì cachitnùhu tutu ìì ñà‑dùcán icúmí cuu. ");
INSERT INTO mitNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Daaní, nì cachi stná‑yà xì nsidaa nèhivì cuáhà mà: ―A ducán nduú modo tnií‑nsiá yùhù, vàxi‑nsia nihí‑nsiá espada xì garroti na ian tècuìhnà nduí, mate nsìquívì nìsa ìe xì‑nsiá veheñùhu cahnú dacuahí nèhivì, te cónì tnìí‑nsiá yùhù. ");
INSERT INTO mitNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Doco cunaha‑nsiá, dohó quidá‑nsiá vichi sàhà ñà‑nì cuú ndisa ñà‑ndùá nì tiaa nèhivì xí Dios sànaha ―nì cachi‑yà. Dandu nì nacoo nihni nsidaa nècuàchì dacuahá‑yá mii‑yá, nì xinudèhé‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nèhivì nì tnii xi‑yá, ndacá‑néyà cuàhàn nùù dùtù cusáhnû nani Caifás. Te divi vehe nècuàchìmà sànì nataca stná nècuàchì ley xi veheñùhu, xì stná nècuàchì sahnú xídandacú nùù ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Te Pedro, nchícùn xìcà‑níné mii‑yá cuàhàn‑nè. Te nì yàha stná‑nè patiu iá vehe dùtù cusáhnúmá, te nì sàcòo stná‑nè xì policia ndoó yucán, ndiatú‑né cundaà ini‑nè índù fin cucumi‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Daaní, dùtù xícusahnú, xì nsidaa tè‑xídandacú, xì nsidaa stná nècuàchì Junta Cahnú, nì nducu‑né ana daquée cuàchi dìquì‑yá sàhà‑ñá cui‑yà, mate té‑tnùhù nduú‑te. ");
INSERT INTO mitNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Doco còò iin ni túi (cunduu testigu nacua cuní‑nè), mate cuáhà nèhivì nì càhàn tnùhù dìquì‑yá. Doco por fin nì quixi ùì‑te, ");
INSERT INTO mitNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","te nì cachì‑te: ―Nì cachi Jesús yohó ñà‑vàtùni dacaá‑né veheñùhu xi Dios, dandu tìxi ùnì quìvì naquidavàha saa‑néà. ");
INSERT INTO mitNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dandu nì ndacuiin dùtù cusáhnû, te nì cachi‑nè xì‑yá: ―¿Áma náxícóníhí‑nî ni‑iñàha? ¿Nansa iá ñà‑càchí guâ nècuàchì yohó sàhà‑ní? ");
INSERT INTO mitNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Doco Jesús, dadí úún nì ndòo‑ya. Dandu nì cachi dùtù mà: ―Fuerza icúmí‑nî chinaha‑ní Dios iá nicanicuahàn, te cachì‑ní xì‑nsí a díví Dèhemanì‑yá nani Cristu nduu‑ní, ò á coó. ");
INSERT INTO mitNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Dandu nì cachi Jesús xì nècuàchìmà: ―Nacua nì cachì‑ní, ducán nduá. Te yùhù cachí stnáì xì‑nsiá, icúmí‑nsiâ cuni‑nsià yùhù ana nduú Tnaha Nèhivì Ñuhìví na nui quixi mahì vìcò nahnú ansivi, te coi ladu cuahá mii‑yá ana cahnú poder xi. ");
INSERT INTO mitNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dandu dùtù cusáhnú‑má, (nì xìdà ini‑nè), ñàyùcàndùá nì ndata canúú‑nê iyuhu sìcoto ndixí‑né, te nì cachi‑nè xì nèhivì cuáhà mà: ―¡Cuní nècuàchì yohó ndudava‑ne xì Dios! ¡Có‑xìñùhù gá‑ndà ni‑iin testigu quixi! Vàchi vichi sànì inini‑nsia ñà‑quini guá nì càhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nansa quida‑nda xi‑né, cachí mii‑nsiá? Dandu nì cacachi nècuàchì Junta Cahnu‑ma: ―Icúmí nècuàchì jaàn cui‑nè, vàchi iá cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dandu nì caquesaha nècuàchìmà nì sivi dìí‑nè nùù‑yá, te nì cani‑neyà sìcàtú, te dava ga‑nè, cahmá uun nì cani‑ne nùù‑yá, ");
INSERT INTO mitNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","cachí‑nè xì‑yá: ―¡Cachi cuàá‑nî ana nì cani xi‑ní, vàchi ádi Cristu (nì quixi ansivi) nduu‑ní! ");
INSERT INTO mitNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Te Pedro, patiu tùvèhé iá‑nè. Te yucán nì tnàtuu iin ñahà chìì, cachí‑ña xi‑né: ―Amádi mii‑ní nìsa cutnahá stná‑ní xì Jesús de Galilea. ");
INSERT INTO mitNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Doco nì nacuaà‑né mii‑yá, iníní nsidaa nèhivì yucán, te nì cachi‑nè xì ñahà chìì mà: ―Có‑ìnáhî ñà‑ndùá cachí‑nî. ");
INSERT INTO mitNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dandu cuàhàn‑nè quee‑ne yehè, doco nì xini inga ñahà chìì‑né, te nì cachà xi nèhivì dava ga itá yucán: ―Nècuàchì jaàn nìsa cutnahá stná xì Jesús de Nazaret. ");
INSERT INTO mitNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dandu tucutu nì nacuaà‑néyà, nì chinaha‑né Dios ñà‑tàcùní‑nè Jesús, cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Daaní, inga ratu gà nì tnàtuu stná iin ùì nèhivì itá yatni yucán, te nì cachi‑nè xì Pedro: ―Ndisa, iin compañeru Jesús nduu‑ní, vàchi sàhà modo cáhàn‑ní, ducán cundáà ini‑nsì. ");
INSERT INTO mitNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dandu nì cachi Pedro xì‑né: ―Yùhù chináhî Dios, có‑ìnáhî nècuàchìmà. Te nú tètnùhù ndùí, ni daquixí‑yá castigu dìquí. Dandu momentu mà nì xito lehe. ");
INSERT INTO mitNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Te ñà‑yùcán nì nsinuu ini‑nè nansa nì cachi‑yà xì‑né daa ñà‑tàñáha ga coto lehe, te sànì nacuaà‑néyà ùnì xichi. Ñàyùcàndùá, nì quee‑ne iladu patiu, iá‑nè sacú cuáhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Daaní, na ní tùinuù, dandu nì càhàn dùtù xícusahnú xì tè‑dàndàcú nùù ñuu mà, nì candatnuhu tnahá‑né nansa quida‑ne, te cui Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dandu nì nachicuhni‑nè ndahà‑yá, te cuàhàn‑nè xì‑yá nùù gobernador Poncio Pilato, te yucán nì ndòo‑ya ndahà témà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Daaní, Judas, divi ana nì cahin xì‑yá, nì cundaà ini‑nè ñà‑ndisa icúmí Jesús cui‑yà. Ñàyùcàndùá, nì naxicocuíìn ini‑nè, nì sàhàn‑nè nì naxiconihí‑né òcò ùxìn dìhùn plata nùù dùtù xícusahnú, xì nùù stná nècuàchì sahnú xídandacú, cachí‑nè xì nècuàchìmà: ");
INSERT INTO mitNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","―Cuàchi nduá nì quide, vàchi còò falta xi nècuàchì nì dàyáhi ndahà‑nsiá. Doco nì naxiconihí nècuàchìmà, cachí‑nè: ―Có‑dàndòhájàn nsiùhù; chuun xi mii‑ní nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ñàyùcàndùá, nì ducùn Judas nsidaa dìhùn mà pisu veheñùhu, te nì quee‑ne nì dàcuáhnâ‑nè mii‑né xì yohò. ");
INSERT INTO mitNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Daaní, después nì dàtàcá dùtù mà dìhùn mà, te nì cachi‑nè: ―Có‑sâha ley xi‑nda permisu daquée‑nda dìhùn yohó alcancía xi Dios, vàchi sàhà ñà‑yòhó nì xìhì iin nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ñàyùcàndùá, nì ndatnuhu tnahá‑né (nansa quida‑ne xì) dìhùn mà, te nì xiin‑ne iin ñuhù nani Itu Alfareru ñà‑cundua panteón ndé cundùxin nècuàchì inga ñuu. ");
INSERT INTO mitNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ñàyùcàndùá dìsáhà‑xí nì sàcùnani ñuhù mà Ñuhù Níì, te dècuèndè vichi ducán cachí‑nè xán. ");
INSERT INTO mitNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pues divi ducán nì cuu nsidaámà sàhà ñà‑nì cùú ndisa ñà‑ndùá nì cachitnùhu iin nècuàchì sànaha nani Jeremías, vàchi dohó nì tiaa‑ne: “Cutu ócò ùxìn dìhùn plata ndiaá‑yà, nì cachi nècuàchì raza Israel. Dandu después nì natnii‑ne dìhùn mà ");
INSERT INTO mitNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nì xiin‑ne Itu Alfareru, nacua nì cachi Stoho‑ndà Señor xìˊ”. ");
INSERT INTO mitNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pues (hora yucán sànì sàà‑yà) nùù gobernador, te iín‑yá nùù‑té. Dandu nì ndàcàtnùhù‑té nùù‑yá, cachí‑te: ―¿A ndísá rey xi nècuàchì raza Judea nduu‑ní, á coó? Dandu nì cachi‑yà: ―Nacua cachí‑nî, divi ducán nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dandu dùtù xícusahnú, xì nècuàchì xídandacú, nì càhàn tnùhù‑né sàhà‑yá, doco còò ni‑iñàha ni cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dandu nì cachi Pilatu xì‑yá: ―¿A có‑tiàcú‑nî ñà‑cuàhà guá câhàn tnùhù‑né dìquì‑ní? ");
INSERT INTO mitNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Doco mii‑yá, còò ni‑iñàha ni náxícóníhî‑yá. Ñàyùcàndùá, nì ndulocó gobernador mà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cunaha‑nsiá, cada nacává vicò pascua mà, tùha Pilatu daña‑té iin tè‑ndiàdí, ndéni‑te nì cui ndiadí ni cácàn nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Te quìvì yucán ndiadí iin tiàa iá cuàhà fama‑xi nani Barrabás. ");
INSERT INTO mitNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ñàyùcàndùá, na sánì nataca nèhivì cuáhà mà nùù Pilatu, dandu nì xìcàn tnùhù‑té nùù‑né, cachí‑te: ―¿Ana cuní‑nsià dàñà? ¿A divi Barrabás, te ò Jesús, ana cachí nduú Cristu? ");
INSERT INTO mitNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ducán nì cachì‑te xi‑né, vàchi sà‑ìnáhá‑tê ñà‑cuisì sàhà envidia xi dùtù sànì yàha Jesús ndahà‑té. ");
INSERT INTO mitNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Daaní, iá ìì‑té nùù silla ndé nsidándáà‑te chuun, te nì quesaa iin razón xi ñahàdìhí‑te, cachí‑nè: “Màsà quídá‑nî ni‑iñàha xi Jesús, vàchi nècuàchì vàha nduú‑né. Cunaha‑ní, cuàhà gá nì sàníˋ ñuú ndùvèhè nì quida nècuàchìmà, te nì nacani cuaá inì”, cachí razón mà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Doco dùtù mà xì nècuàchì xídandacú, nì chiyuhù‑né nèhivì cuáhà mà ñà‑nì cácàn‑nè dàñà Barrabás, te cui Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ñàyùcàndùá, nì càhàn gobernador xì nsidaa nèhivì mà, cachí‑te: ―Nùù ùì nècuàchì yohó, ¿índù nècuàchì cuní‑nsià dàñà? Dandu nì cachi nèhivì mà: ―¡Divi Barrabás! ");
INSERT INTO mitNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dandu nì cachì‑te xi‑né: ―Pues, nú ducán, dandu ¿nansa quide xì Jesús, divi ana cachí nduú Cristu? Te nì naxiconihí nsidaa‑né, cachí‑nè: ―¡Ni cuí‑nè nchìca cruz! ");
INSERT INTO mitNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dandu cachí gobernador mà: ―¿Índù chuun cui‑nè ñà‑còò falta xi‑ne iá? Doco chicá ndee ní càna nèhivì cuáhà mà, cachí‑nè: ―¡Ni cuí‑nè nchìca cruz! ");
INSERT INTO mitNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dandu nì xini Pilatu còò ni‑iñaha níhìndèè‑té, cuisì quesáhá nacuídà fuerte nèhivì mà. Ñàyùcàndùá, nì xìcàn‑te tècuìí, te nì ndaha‑tè, indéhe nsidaa nèhivì mà, te nì cachì‑te xi‑né: ―Yùhù, mà cúnsídá cuàchi nú ni cuí nècuàchì yohó, vàchi còò ni‑iñàha iníhícá‑nê. Chuun xi mii‑nsiá nduá. ");
INSERT INTO mitNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dandu nì cachi nsidaa nèhivì mà: ―Nsiùhù xì dèhe‑nsi ni cúnsídá cuàchi‑nsi sàhà nècuàchì jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dandu nì dàñà Pilatu Barrabás mà nùù nèhivì mà, doco Jesús, còó; nì dàndàcú‑te ñà‑nì ñáhnì cuìí‑yà, te después cùhùn‑yà màcùtuu‑ya nchìca cruz cui‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dandu soldadu xi gobernador mà, nì saca‑tèyá cuàhàn‑te xi‑yá vehechuún. Te nì cana‑tè nsidaa compañeru‑te ñà‑tnàtuu‑tè ndé iá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dandu nì tavà‑té sìcoto xi‑ya, te nì chindixi‑tèyá iin capa cuahá. ");
INSERT INTO mitNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Te nì cava stná‑te iin corona iñù nì chicaà‑te dìnì‑yá, te nì dàcùníndáha stná‑teyá iin nù‑iin ndahà cuàhá‑yà. Dandu nì sàcuìta sisi‑té nùù‑yá, sácùndiaà‑teyá, cachí‑te: ―¡Viva! Vàchi ¡rey xi tè‑raza Judea nduu‑ní (vichi)! ");
INSERT INTO mitNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Te nì casivi dìí‑teyá. Dandu nì dìtá‑te nù‑iin ma ndahà‑yá nì cani fuerte‑te dìnì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te na ní nsihi nì sàcùndiaà‑teyá ducán, dandu nì tavà‑té capa mà, te nì nachindixi‑tèyá sìcoto xi mii‑yá. Dandu nì saca‑tèyá cuàhàn‑te chituu‑tèyá nchìca cruz. ");
INSERT INTO mitNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na ní caquee‑tè xì‑yá nì ndacùhun tnahá‑te xi iin tiàa ñuu Cirene nani Simón. Te divi nècuàchìmà nì catnii‑tè nì dàcuìdá‑tené cruz xi‑ya cuàhàn. ");
INSERT INTO mitNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dandu nì casaà‑te xi‑yá iin xaan nani Gólgota. Quìvì jaàn cachí dàhàn yucán, Nùù Iquì Dìnì. ");
INSERT INTO mitNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Dandu nì cunì‑te dacohó‑teyá vinu ia dácà tnàhá xì ñà‑ùà, doco na ní tuiyàá‑yàñà, cónì cùní gà‑yà coho‑yañà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Daaní, nì chituu‑tèyá nchìca cruz. Te sìcoto xi‑ya, nì dasàn‑téâ según nansa nì nìhì iin iin‑tè na ní idàdìquí‑te sàhà‑ñá. Pues ducán nì quida‑tè sàhà ñà‑nì cùú ndisa palabra nì cachitnùhu nèhivì xí Dios sànaha na ní cachi‑nè: “Nì dasàn‑té sìcoto xi entre mii‑té, te nì idàdìquí‑te sàhà‑ñá”. ");
INSERT INTO mitNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Daaní, nì sàcùndoo soldadu mà ñà‑cundiaà‑teyá. ");
INSERT INTO mitNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Te dìquì‑xí dìnì cruz xi‑ya nì sàcùtuu iin ñà‑càchítnùhu índù‑ñá dìsáhà‑xí dandohó‑teyá. Te dohó cacháˋ: “Ana yohó nduú Jesús, rey xi tè‑raza Judea”. ");
INSERT INTO mitNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Cunaha‑nsiá, yucán nì sàcuìtandiaa stná ùì tècuìhnà nchìca cruz, iin‑tè ladu cuahá‑yà, te ingà‑te ladu itní‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Te nèhivì yáha yucán, nì canàhá stnâ‑nè xì‑yá, dacuico dínì‑né, cahíchì ini‑nèyà, cachí‑nè xì‑yá: ");
INSERT INTO mitNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","―¡Ndahví‑nî! vàchi cuàhàn‑ní dacaá‑nî veheñùhu cahnú, te tìxi ùnì quìvì nsidavàha saa‑níà, cachí‑nî. Nú ducán fuerte guá‑nî, dandu dacácu‑ní mii‑ní, nú ndisa Dèhemanì Dios nduu‑ní, te danuu‑ní mii‑ní nùù cruz jaàn cundehè‑nsí ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Te divi‑ni ducán nì sàcùndiaa stná dùtù xícusahnú, te cutnáhâ stná nècuàchì ley xi veheñùhu, xì stná nècuàchì xídandacú; nsidaa‑né nì sàcùndiaa stná‑nè, cachí‑nè iin‑ne xì inga‑nè (sàhà‑yá): ");
INSERT INTO mitNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Nècuàchì jaàn, nìsa dacácu‑ne nècuàchì dava ga, doco mà cùì dacácu‑ne mii‑né. Nú ndisa rey xi nècuàchì raza‑ndà Israel nduú‑né, dandu ni danuú‑né mii‑né nùù cruz jaàn cundehè‑ndà, dandu cunindisa‑ndané. ");
INSERT INTO mitNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dios cundéé îní‑nè, (cachí‑nè): pues nú ducán nduá, dandu ni dacácu‑yanè vichi, nú cuní‑yà, te nú ndisa Dèhemanì‑yá nduú‑né nacua cachí‑nè ―nì cachi tè‑xícusahnu‑ma. ");
INSERT INTO mitNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Te dècuèndè stná tècuìhnà itándiaa stná nchìca cruz yucán, nì canàhá stná‑te xi‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Daaní, dècuèndè càxíhúì xì ndéˋ càhúnì nì nàcuììn tnùù inicutu ñuu yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Te nahi càhúnì nì ndàhì ndee‑yá, cachí‑yà: ―Elí, Elí, ¿lama sabactani? ―te dohó cuní cachàmà: ¡Dios mío, Dios mío! ¿A ñá‑sànì ndòo nihni nduá yohó? ");
INSERT INTO mitNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Te dava nècuàchì itá yucán, nì tiacu‑nè ndáhì‑yà ducán, ñàyùcàndùá nì cachi‑nè: ―Elías caná‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ñàyùcàndùá, nì dàyáà iin‑tè nì quihin‑tè iin ñà‑ñàhmá uun nani esponja, te nì chindaxin‑tèá xì vinu nì xìò, nì chihi‑tèá dìnì iin vara yutnù, te nì sàha‑tèyá nì sihvi‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dandu nì cachi ingà‑te: ―Nacoo‑nínè, cundiatu‑nda, áma quíxí Elías dacácu xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dandu inga xichi nì ndàhì ndee‑yá, te nì xìhì‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Daaní, yucán ini veheñùhu cahnú nì quedava ìì cortina cahnú sadí nihni cuartu xan; iin‑ni nì ndàtà‑ñá ndè dìnì‑xí xì ndéˋ tìxi‑xi. Te nì tnàa stná ñuhìví, te nì ndàtà cavà nahnú. ");
INSERT INTO mitNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Dècuèndè nì nuna stná cuàhà lugar ndé índùxin nsìi. Ñàyùcàndùá na sánì natiacu‑yà después, dandu nì natiacu stná cuàhà nècuàchì sànaha nduú nèhivì xí‑yá, nì caquee‑ne ndé índùxin‑ne nì caquìhvi‑ne ini ñuu ìì (Jerusalén), te nì ndecoyo‑ne nùù cuàhà nèhivì ndoó yucán. ");
INSERT INTO mitNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","(Cunaha‑nsia, frente ndé iín cruz xi Jesús,) yucán iín stná iin capitán xì compañeru‑te, xíndiaà‑teyá. Te na ní caxinì‑te nansa nì cuu ñà‑nì tnàa guá, dandu nì yùhí gà‑te, cachí‑te: ―Ñà‑ndáà nduá, Dèhemanì Dios nì sanduu nècuàchì jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Daaní, yucán itá xica stná cuàhà nècuàchì ñahà, indéhe‑ne: nècuàchì ladu Galilea nduú‑né, te cutnáhâ‑né xì‑yá nì quixi ndè ñuu mà ñà‑chindee stná‑nèyà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iin‑ne nduú María Magdalena, te inga‑nè nduú María dihi Jacobo xì José, te inga‑nè nduú ñahàdìhí Zebedeo. ");
INSERT INTO mitNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Daaní, na ní cuaà quìvì yucán, dandu nì sàà stná iin nècuàchì ñuu tii Arimatea nani José. Iin nècuàchì cuìcà nduú‑né, te nchícùn stná‑nè ichì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Te divi‑ne nì sàhàn nùù Pilatu, nì xìcàn‑nè cuerpu‑yà. Dandu nì cachi Pilatu xì soldadu ñà‑nì cuáha‑tè nècuàchìmà iquìcúñú‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ñàyùcàndùá, nì sàhàn José nì naquihin‑neyà, te nì chidùcún‑nèyà iin dahmà iá ndoo. ");
INSERT INTO mitNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Te sàhà ñà‑làcà nì sate nèhivì xí‑né iin cueva nùù cavà, ñàyùcàndùá, divi yucán nì chinacaa‑nèyà. Dandu nì dàtùí nihni‑ne iin cavà cahnú nì sàcùndiadi yuhù cueva mà, te cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Doco yucán nì ndòo María Magdalena xì inga María mà, xíndoo‑ne frente lugar ndé nì ndùxin‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Daaní, nì yàha quìvì mà, divi quìvì nduú vigilia xi quìvì descansu. Dandu meru quìvì (descansu) mà nì sàhàn itnii dùtù xì iin ùì stná nècuàchì fariseu, nì tnàtuu‑ne nùù Pilatu, ");
INSERT INTO mitNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nì cachi‑nè xì‑té: ―Señor gobernador, nsiùhù nsinúú ini‑nsì nansa nì cachi (Jesús) na xicánúú íì‑né dandahví‑nè nèhivì, nì cachi‑nè ñà‑tìxi ùnì quìvì icúmí‑nê natiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ñàyùcàndùá, cuní‑nsì dandacu‑ní ñà‑cundiaa vàha soldadu sepultura dècuèndè nì xínu quìvì únì, vàchi nú coó, vihini nataca nèhivì xí nècuàchìmà ñuú, te tavà‑nàné, dandu después cachi‑nè xì nèhivì ñà‑sànì natiacu nècuàchìmà nduá. Te nú ducán, dandu cundua iin tnùhu chicá cahnú nùù palabra nìsa cachi nècuàchìmà antes. ");
INSERT INTO mitNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dandu nì cachi Pilatu xì‑né: ―Vàtùni iá cùhùn iin ùì soldadu, nacua xícàn‑nsià. Te cuahán stnâ mii‑nsiá nùù sepultura, te chicadi vàha‑nsiañà nacua cui quida‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ñàyùcàndùá, nì caquihin nècuàchìmà ichì cuàhàn‑nè ndè sepultura, te chicá fuerte nì chicadi‑nè lugar mà. Te nì candòo stná itnii soldadu xíndiaa. ");
INSERT INTO mitNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Daaní, nì yàha quìvì descansu mà. Te na sácuàhàn tùinuù quìvì primeru semana, dandu cuàhàn María Magdalena cundehè‑né sepultura, te cutnáhâ stná‑nè xì inga María mà. ");
INSERT INTO mitNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Datúha nì quesaha tnáa fuerte, vàchi ndè ansivi nì nuu iin ángel xi Stoho‑ndà Señor, nì dàcúxíó‑né cavà cahnú ndiadí yuhù cueva mà, te nì sàcòo‑ne dìquìá. ");
INSERT INTO mitNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tnúù nihni‑ne na ian tása; te cuxín yaa sìcoto xi‑ne nahi yùhà. ");
INSERT INTO mitNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Te soldadu ndoó ndiaá yucán, nì cayùhí cuaá‑te, te nì quesaha‑té quidí fuerte‑te, ndè nì xìhì nihni‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Doco nì cachi ángel mà xì nècuàchì ñahà mà: ―Màsà yúhî‑nsià. Ináhî nandúcú‑nsiâ Jesús, divi ana nì xìhì nchìca cruz. ");
INSERT INTO mitNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Doco cunaha‑nsiá, còò cá‑yà yohó; sànì natiacu‑yà nacua nì cachitnùhu‑ya antes. Naha‑nsià cundehè‑nsiá lugar ndé nì sanduhù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Te cuahán‑nsià vichi duha ndé ndoó nècuàchì dacuahá‑yá, te cachitnùhu‑nsia xì‑né ñà‑sànì natiacu‑yà, te icúmí‑yâ codònùù‑yá nùù‑nsiá nùhù‑yà ndè ladu Galilea. Yucán icúmí‑nsiâ cuni‑nsiàyà. Pues vichi sànì cachitnùhi xì‑nsiá ―nì cachi ángel. ");
INSERT INTO mitNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dandu yàchì nì caquee nsihi nècuàchì ñahà mà cueva mà, te nì dàyáà‑nè cuàhàn‑nè cachitnùhu‑ne xì nècuàchì dacuahá‑yá: chii yúhî‑nè, te chii cudíì stná ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Doco ichì ndé cuàhàn‑nè yucán nì ndacùhun stnahá‑né xì‑yá, te nì casàhú‑yà xì‑né. Ñàyùcàndùá nì tutuyuhu‑né ñuhù nùù sàhà‑yá, te nì tnii‑ne sàhà‑yá nì cahvi‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dandu nì cachi‑yà xì‑né: ―Màsà yúhî‑nsià. Cuahán‑nsià ndé ndoó nèhivì xínduu nahi ñanì, te cachi‑nsià xì‑né ñà‑nì núhù‑nè ndè ladu Galilea, vàchi yucán icúmí‑nê cuni‑nè yùhù. ");
INSERT INTO mitNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Daaní, na sámànuhù nècuàchì ñahà mà, dandu nì caquee stná dava soldadu nì sandiaa yucán, mànuhù stná‑te ñuu Jerusalén. Te nì nacani‑tè xì dùtù xícusahnú nansa nì cuu. ");
INSERT INTO mitNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ñàyùcàndùá, nì nataca dùtù mà xì nècuàchì xídandacú nùù ñuu mà, te nì ndatnuhu tnahá‑né nansa quida‑ne. Dandu nì sàha‑ne soldadu mà vihi dìhùn, ");
INSERT INTO mitNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","te nì cachi‑nè xì‑té: ―Dohó cachi‑nsià xì nèhivì: na hora quídì naà‑nsiá ñuú, dandu nì casaà nècuàchì dacuahá Jesús, nì xidacuihna‑né cuerpu nsìi ma, cachi‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te nú ni cunítnùhu gobernador sàhà chuun yohó, dandu càhàn‑nsì sàhà‑nsiá nùù‑té, te còò ni‑iñàha cuu xi‑nsiá ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ñàyùcàndùá, nì catnii soldadu mà dìhùn mà, te nì cachì‑te xi nèhivì nacua nì sàcùnaha‑té. Te divi sàhà ñà‑jaàn nduá ducán xicá cuentu mà nùù nèhivì raza Judea dècuèndè quìvì vichi. ");
INSERT INTO mitNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Daaní, nì quihin nsì‑úxìn iin nècuàchì dacuahá‑yá ichì cuàhàn‑nè ndè iin xaan nì cachi‑yà xì‑né, divi nduú iin yucù iá ladu Galilea. ");
INSERT INTO mitNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te na ní xini‑nè mii‑yá nì tutuyuhu‑né ñuhù nùù sàhà‑yá, te nì cahvi‑néyà. Doco dava‑ne, ndoó‑né xì duda. ");
INSERT INTO mitNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dandu chicá nì cuyatni‑ya, te nì cachi‑yà xì‑né: ―Yùhù nì nìhìtáhvìˊ dandacuí sàhà nsidanicuú iñàha iá ñuhìví xì ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ñàyùcàndùá, cuahán‑nsià inicutu ñùhìví, te dacuahá‑nsiá nèhivì nansa iá ichì váha, te quida iì stná‑nsiànè, ndacùcahan‑nsiá Yuamánìˊ, xì stná yùhù ana nduú Dèhemanì‑yá, xì stná Espíritu Ìì xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Te chinaha stná‑nsiànè nansa quida‑ne chivàha‑ne nsidanicuú ñà‑ndùá sànì dàndàcuí nùù‑nsiá. Te cunaha‑nsiá, nicanicuahàn icúmî cutnahí xì‑nsiá ndè cachi nsihi ñuhìví. Yohó nì nsihi historia.");
INSERT INTO mitNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ñà‑yòhó nduá quesáhá nacání razón ndiaha xí Dios sàhà Dèhemanì‑yá Jesucristu. ");
INSERT INTO mitNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Sànaha nìsa cahàn Isaías cuenta xi Dios. Te nì tiaa stná‑nè (palabra yohó nì cachi‑yà): Cunaha‑ní, cuàhìn techuín iin tiàa, te dihna‑ne yàha‑ne càhàn‑nè xì nèhivì ñà‑ndùú razón xi, te ducán (nsida viì‑né anima‑nè), na ian nduviì iin ichì, dandu después yàha stná mii‑ní (Cristu). ");
INSERT INTO mitNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tiacú cáhàn fuerte ana cáhàn sàhù yucù, te (cachí‑nè xì nèhivì ñà‑nsida viì‑né anima‑nè) na ian nduvíi ichì ndé yàha Stoho‑ndà Señor, nandua ichì ndáà ndé quixi‑ya. (Ducán cachí tutu mà.) ");
INSERT INTO mitNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ñàyùcàndùá, nì quixi nècuàchìmà. Juan Bautista nani‑né, te yucù nì càhàn‑nè sàhù xì nèhivì, nì cachitnùhu‑ne nansa xiñuhu quida‑ne ñà‑naxicocuíìn ini‑nè sàhà‑ñá cuicahnú ini Dios sàhà cuàchi‑ne, dandu cuhiì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ñàyùcàndùá cuàhà nèhivì ñuu Jerusalén xì nsidaa gá stná nèhivì ladu Judea, nì casaà‑nè nùù Juan mà, nì dàtúi‑ne cuàchi‑ne nùù Dios, te nì cuhiì stná‑nè nùù yùte Jordán nì quida nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dòò idì sì‑camellu nì sandixi nècuàchìmà. Te iìn quisì nduú siuhma tìxi‑ne. Te sìca xi ndudi ñùñù yucù nduá nìsa itiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Te nì càhàn‑nè xì nèhivì, cachí‑nè: ―Nú sànì yàha yùhù, dandu vàxi mii‑yá ana chicá icúmí poder cahnú nùí. Ni có‑nâtùi (cundui ni mozo xi‑ya) ndaxin correa ndìsàn‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yùhù, tècuìí quidá íìˊ mii‑nsiá. Doco mii‑yá, còó; tìxi Espíritu Ìì xí Dios icúmí‑yâ quida iì‑yánsià. ");
INSERT INTO mitNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Quìvì yucán nì quee‑ya ñuu Nazaret iá Galilea, te nì quida iì Juan‑yà nùù yùte Jordán. ");
INSERT INTO mitNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te na ní quee‑ya nùù tècuìí mà, dandu nì xini‑yà nì nuna ansivi, te nì nuu Espíritu Ìì xí Dios dìquì‑yá na iin loma. ");
INSERT INTO mitNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te nì tiacu cáhàn iin ana cáhàn ansivi, cachí‑yà: ―Mii‑ní, Dèhemanìˊ nduu‑ní, te cudíì cuáhà inì sàhà‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Daaní, nì nsihi nì cuhiì‑yá, dandu vichi vichi nihí Espíritu Ìì xí Dios‑yà nì sàhàn ñà‑coo‑ya yucù dàná. ");
INSERT INTO mitNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Te yucán nìsa ìa‑ya ùì dico quìvì ndé ndoó quisì yùcù. Te nì sàà Satanás, nì cunì‑si dacà‑síyâ, (doco mànìcùí). Daaní, después nì casaà stná ángel xi Dios nì chindee‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Daaní, na ní sàcùndiadi Juan Bautista vehecàa, dandu mànuhù Jesús ladu Galilea. Te nì quesaha‑yá cáhàn‑yà xì nèhivì inicutu ñà‑ndùú razón ndiaha sàhà ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Te dohó nì cachi‑yà xì‑né: ―Sànì sàà hora, sà‑ìtúú tiempu cusahnú Dios ñuhìví yohó. Ñàyùcàndùá naxicocuíìn inì‑nsia sàhà cuàchi‑nsia, te cunindisá‑nsiá ñà‑ndùú razón ndiaha xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Xicá Jesús yuhù mar iá Galilea, te nì xini‑yà Simón xì ñani‑nè Andrés, dacaná‑né ñunù xí‑né mahì tècuìí, vàchi nècuàchì tavá siaca xínduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Te nì cachi‑yà xì‑né: ―Cunchicùn‑nsià yùhù, vàchi mà cúndúú gá‑nsià nècuàchì tavá xi siaca; yùhù icúmî dacuahí mii‑nsiá ñà‑cunduu‑nsia nècuàchì tavá xi nèhivì (nùù ichì malu). ");
INSERT INTO mitNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dandu nècuàchìmà, vichi vichi nì nacoo‑ne ñunù xí‑né yucán, te nì tenchicùn‑nè mii‑yá cuàhàn. ");
INSERT INTO mitNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Dandu nì sàà‑yà chicá nùù‑xí, te nì xini tu‑ya ùì dèhe iin tiàa nani Zebedeo, Jacobo nani iin‑ne, te Juan nani ñani‑nè, ndoó‑né nùù lancha xi‑ne, nácàhmá‑nè ñunù xí‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Te nì cana stná‑yà ndúì‑nè. Ñàyùcàndùá nì nacoo‑ne yua‑né ini lancha mà xì tètàtú, te nì catenchicùn stná‑nèyà cuàhàn. ");
INSERT INTO mitNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Dandu nì casaà‑nè xì‑yá iin ñuu nani Capernaum. Te na ní sàà quìvì descansu, dandu cuàhàn‑yà veheñùhu, te nì dàcuàhá‑yá nèhivì yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Te nì ndulocó‑nè sàhà ñà‑ndùá dàcuàhá‑yánè, vàchi nì chinaha‑yà nahi ana cusáhnû, màdìá nahi nècuàchì ley xi veheñùhu. ");
INSERT INTO mitNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Daaní, ini veheñùhu ma iá stná iin tiàa inácáá iin ñà‑malu inì‑xi. Te nì ndàhì‑nè, cachí‑nè: ");
INSERT INTO mitNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Jesús de Nazaret, ¿ndíà cunduu‑ní nsiùhù? ¿A váxi‑ní dandáñúhú‑nî nsiùhù? Yùhù ináhî mii‑ní: ana ìì nì quixi nùù Dios ndùù‑ní ―cacháˋ. ");
INSERT INTO mitNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Doco Jesús, ndee ní dàndàcú‑yá nùá, cachí‑yà: ―¡Màsà cáhàn, te quee cuahán! ¡Nacoo tiàa jaàn! ");
INSERT INTO mitNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dandu ñà‑malu mà, nì dàquìdí fuerteà nècuàchìmà, te nì ndàhì ndeá, dandu nì quea cuàhàn. ");
INSERT INTO mitNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ñàyùcàndùá, nsidaa nèhivì yucán, nì ndulocó sàstnùhù‑né sàhá yùcán, te nì ndàcàtnùhù tnàhá‑né nùù‑né, cachí‑nè: ―¿Ndíà nduá cuú jaàn? ¿Índù ley saa nduá? Vàchi na iin nècuàchì cusáhnû, ducán cáhàn nècuàchì jaàn. Mà úhì dàndàcú‑né nùù ñà‑malu, te iníníá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dandu nì xìtià fama xi‑ya inicutu ladu Galilea yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Daaní, na sánì caquee nsidaa‑né veheñùhu yucán, dandu cuàhàn‑yà xì Jacobo xì ñani‑nè Juan, nì yàha‑ne vehe Simón xì Andrés. ");
INSERT INTO mitNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Te yucán indúhu dìdo Simón, nècuàchì ñahà, quidá yócò xì‑né. Te vichi vichi nì cachitnùhu nèhivì vehe ma xi‑yá sàhà nècuàchì cuhí mà. ");
INSERT INTO mitNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ñàyùcàndùá, nì tnàtuu‑ya ndé indúhu‑né, te nì tnii‑ya ndahà‑né, nì dàndácòo‑yanè. Dandu vichi duha nì cuxio cuèhè yòcò mà‑né, te nì quesaha‑né nì xinucuachi‑né nùù‑yá xì compañeru‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Daaní, nì quècahnu orá, te nì cuñaà. Dandu nì casaca nèhivì nsidaa nècuàchì cuhí xi‑ne, xì stná nècuàchì inácáá ñà‑malu inì‑xi nì quixi nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Te nsidaa‑né, nì nataca chitu‑né yehè vehe ndé iá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Te nì dàndúvàha‑ya nsidaa nècuàchì cuhí mà, nsidanuu cuèhè quìdà‑xì‑né. Te nì tavà stná‑yà cuàhà ñà‑malu. Doco cónì sáha‑ya càhàn gà‑si, vàchi ináhá‑sî ana nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Daaní, itnúú gá dàtnàà nì ndacòo‑ya, nì quee cuaán‑yá cuàhàn‑yà iin xaan ndé còò nèhivì, te yucán nì xìcàn tàhvì‑yá nùù Yuamánì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Daaní, después, nì caquee stná Simón xì compañeru‑nè cuàhàn‑nè nanducu‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Te na ní ndacùhun‑neyà, nì cachi‑nè xì‑yá: ―Cunaha‑ní, nsidaa nèhivì, nanducu‑né mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Doco nì cachi‑yà xì‑né: ―Ni cúhùn‑ndà ndè ñuu chicá nùù‑xí, cachitnùhu stnáì xì nèhivì yucán ñà‑ndùú ndudu ìì, vàchi divi chuun jaàn vàxi ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ñàyùcàndùá, ducán nì xìcanuu‑ya inicutu ladu Galilea yucán, nì cachitnùhu‑ya ndudu ìì xí‑yá xì nèhivì nsidaa veheñùhu yucán, te nì tavà stná‑yà ñà‑malu ñuhú ini nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dandu nì sàà stná iin tiàa icúmí cuèhè lepra, nì tnàtuu‑ne nùù‑yá, nì sàcuììn sìsì‑né nùù‑yá xícàn tàhvì‑né nùù‑yá, cachí‑nè: ―Nú cuní‑nî, vàtùni dandúvàha‑ní yùhù. ");
INSERT INTO mitNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dandu nì cuhi ini Jesús nècuàchìmà, te nì chituu‑ya ndahà‑yá nùù‑né, cachí‑yà xì‑né: ―Juùn. Vichi duha ni ndúvàha‑ní, cachíˋ xì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dandu na momentu nì cachi‑yà ducán nì quee cuèhè quìdà‑xì‑né, te nì nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Dandu na cuáhàn‑yà techuún‑yánè nùhù‑né, dandu cuàhà gá nì chinaha‑yánè, cachí‑yà xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Cunaha‑ní, màsà cáchì‑ní ni‑iñàha xi nèhivì. Cuisì cuahán‑nî nùù dùtù ñà‑cundehè‑né ìcà‑ní (ñà‑sànì nduvàha‑ní), te nacuàha‑ní promesa xi Dios, vàchi ducán cachí ley xi Moisés, dandu vàtùni cundaà ini nèhivì ñà‑sànì nduvàha‑ní nduá ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Doco nècuàchìmà, nì quee‑ne nì quesaha‑né nacání‑né xì cuàhà nèhivì, te sàhámà nì xìtià cuentu inicutu. Ñàyùcàndùá mànìcùí gá quìhvi vate Jesús ini ni‑iin ñuu. Puru campu xicánúú‑yá. Doco nsidanicuú xaan nì caquee nèhivì nì nataca‑nè nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nì yàha itnii quìvì, dandu mànuhù Jesús ñuu Capernaum. Te nì xinitnùhu nèhivì iá‑yà vehe. ");
INSERT INTO mitNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ñàyùcàndùá luegu nì nataca cuàhà‑né, ni có‑nùná gà índù cundoo‑ne, ni siquiera nùù yehè. Te nì càhàn‑yà xì‑né ñà‑ndùú palabra xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dandu yucán nì sàà stná itnii gá nèhivì, cùmì‑né nsìdà‑xì iin nècuàchì cuhí nì dàñà íì cuerpu xi. ");
INSERT INTO mitNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Doco ñà‑cuàhà guá nèhivì ndoó yucán, mànìcùí quìhvi‑ne dècuèndè ndé iá‑yà. Ñàyùcàndùá nì nana‑ne dìnìvèhé nì nacanì‑nè iyuhu dìnìá meru ndé indéhe ndáà iá‑yà ini vehe. Te na sánì nacuna‑nemà, dandu nì dànùú‑né nècuàchì cuhí xi‑ne nùù camilla. ");
INSERT INTO mitNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ñàyùcàndùá, na ní xini‑yà ñà‑cuàhà guá xíxinindisá‑néyà, dandu nì cachi‑yà xì nècuàchì cuhí: ―Hijo, xicáhnû inì sàhà cuàchi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Doco yucán ndoó stná itnii nècuàchì nduú nècuàchì ley xi veheñùhu, te nì nacani ini‑nè: ");
INSERT INTO mitNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Índù chuun cáhàn Jesús ducán? ¡Mà ndóo ini Dios sàhà ñà‑ndùá cachí‑nè! Vàchi còò inga ana cui cuicahnú inì‑xi sàhà‑ndà, cuisì mii‑yá”. ");
INSERT INTO mitNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Doco Jesús, nì cundaà ini anima‑yà ñà‑ndùá nacání guâ ini nècuàchìmà. Ñàyùcàndùá nì cachi‑yà xì‑né: ―¿Índù chuun nacání inì‑nsia ducán? ");
INSERT INTO mitNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Índù milagru nduú ñà‑chicá ùhì quida‑nda: a ñá‑cachi uun‑nda xi nècuàchì cuhí yohó ñà‑xìcáhnû ini‑ndà sàhà cuàchi‑ne, te ò ñá‑cachi‑ndà xì‑né ni ndácuíín‑nè ndanihi‑ne camilla xi‑ne, te nacaca‑ne? ");
INSERT INTO mitNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pues yùhù ana nduú Tnaha Nèhivì Ñuhìví, cuàhìn quide iñàha ñà‑cundaà inì‑nsia ñà‑ndisa icúmî derechu cuicahnú inì sàhà cuàchi nèhivì ñuhìví. Dandu nì cachi‑yà xì nècuàchì cuhí mà: ");
INSERT INTO mitNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Mii‑ní cachí xìˊ, ndacuiìn‑ní, ndanihi‑ní camilla xi‑ní, te xuhun‑ní vehe‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dandu nì ndacuiin nècuàchì cuhí mà, te vichi vichi nì ndanihi‑ne camilla xi‑ne, nì quee‑ne, mànuhù‑né vehe‑ne, indéhe nsidaa nèhivì yucán. Ñàyùcàndùá nsidaa‑né, nì ndulocó‑nè, te nì ndenihi vàha‑ne Dios, cachí‑nè: ―Ni‑iin xichi, có‑xìní‑ndà cuu (ndiaha guá) nahi ñà‑yòhó. ");
INSERT INTO mitNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Daaní, nì quee‑ya inga xichi cuàhàn‑yà dècuèndè mar. Te nì nataca cuàhà gá nèhivì nùù‑yá, te nì dàcuàhá‑yánè. ");
INSERT INTO mitNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dandu nì yàha‑ya (inga xaan), te nì xini‑yà iin dèhe Alfeo nani Leví, iá‑nè nùù mesa ndé dachíyàhvi‑ne. Te nì cachi‑yà xì‑né: ―Nahà‑ní, cunchicùn‑ní yùhù. Dandu nì ndacuiin nècuàchìmà cuàhàn stná‑nè xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Daaní, después dohó nì cuu na ní ìa‑ya vehe Leví mà. Iá‑yà xixí‑yá, te ndoó stná cuàhà nècuàchì dachíyàhvi, xì cuàhà gá más nècuàchì cachí‑nè iá cuàchi‑xi, xixí‑né xì Jesús xì nècuàchì dacuahá‑yá, vàchi cuàhà gá nèhivì nchícùn xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te nècuàchì ley xi veheñùhu, xì stná nècuàchì fariseu, nì xini‑nè nansa quidá‑yá xixí‑yá xì nèhivì mà. Ñàyùcàndùá nì cachi‑nè xì nècuàchì dacuahá‑yá: ―¿Índù chuun cutnáhâ maestru xi‑nsia xixí‑né xì cuàhà tè‑dàchíyàhvi, xì dava gà stná nèhivì cuáchi? ");
INSERT INTO mitNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na ní tiacu Jesús cachí‑nè ducán, dandu nì cachi‑yà xì‑né: ―Màdì nècuàchì ndáa vàha xiñuhu xi ana quidatatna xi‑né. Nècuàchì cuhí xiñuhu xì ana quidatatna xi‑né. Te divi ducání stná yùhù, màdì nèhivì nihnú ndàcuisì inì‑xi vàxi càhàn xìˊ. Còó, nèhivì cuáchi vàxi nanduquí, áma naxicocuíìn ini‑nè sàhà cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Daaní, iin xichi na iníhíì nècuàchì dacuahá Juan Bautista xì stná nècuàchì fariseu, dandu nì tnàtuu itnii nèhivì nùù Jesús, te nì ndàcàtnùhù‑né nùù‑yá cachí‑nè: ―¿Índù chuun iníhíì dócô nècuàchì dacuahá Juan xì stná nècuàchì xídacuahá ley xi tè‑fariseu, doco nècuàchì dacuahá mii‑ní, còó? ");
INSERT INTO mitNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Dandu nì cachi Jesús xì‑né: ―Nècuàchì ndoó vicò nándàhà, ¿a vátùni iá ñà‑cunihiì‑né na hora ndoó‑né cutnáhâ‑né xì noviu? Còó, vàchi na ndoó‑né xì noviu, mà cúí cunihiì dócô‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Doco vàxi iin quìvì, dandu mà cóó gà noviu nùù‑né, dandísá, tiempu yucán icúmí‑nê cunihiì dócô‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Sìcoto saa, màsà nácàhmá‑ndàñá nùù ñà‑tùhú. Vàchi nú ducán, dandu dandánsíá ndé nì nacàhmá, te chicá icúmí ndàtà sìcoto tuhú mà. Dandu ñà‑sànì ndàtà dahuun sìcoto‑mà cundua. ");
INSERT INTO mitNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Stná vinu, nú vinu saa nduá, mà dáquêe stná nèhivì‑ñá ini itni iìn tuhú, vàchi nú ducán, ndàtà‑ñá, vàchi cahnsià quida vinu saa ma, te cuìtià‑ñà, te cuchicuehe stná iìn mà. Ñàyùcàndùá, nú vinu saa nduá, dandu ini itni iìn saa covàha. ");
INSERT INTO mitNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Iin quìvì descansu nì sandua, te yáha Jesús nùù iin itu ndé iá trigu, te cutnáhâ stná‑yà xì nècuàchì dacuahá‑yá. Te nacua yáha‑ne ducán sáhnù‑nè sìcàyòcó trigu mà saxí‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ñàyùcàndùá, nì cachi nècuàchì fariseu xì‑yá: ―Cundehè‑ní nansa quidá nècuàchì dacuaha‑ní, quidá‑né iin chuun có‑sâha ley xi‑nda quida‑nda quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Dandu nì cachi‑yà xì‑né: ―¿A cónì càhví‑nsiá (nùù tutu ìì) ndé nacáníá nansa nì quida David sànaha na xicánúú ndahví‑nè xì compañeru‑nè tiempu xi jefe xi dùtù nani Abiatar, te xíhì‑nè doco? Nì quìhvi‑ne ini veheñùhu xi Dios, te nì xixi‑ne dìtà vídì ìì, mate còò permisu cuxi‑neà, cuisì‑ní dùtù iá permisu cuxi xi ñá‑yùcán. Doco David, ndè stná compañeru‑nè nì sàha‑ne, nì caxixi stná nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Dandu nì cachi stná‑yà xì nèhivì yucán: ―Sàhà ñà‑cunduu ñà‑vàha xi nèhivì, ñàyùcàndùá nì sàcòo iin quìvì descansu, màdìá nì cúyúcún nèhivì sàhà‑ñá (chicá nducahnú) quìvì mà. ");
INSERT INTO mitNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ñàyùcàndùá, yùhù ana nduú Tnaha Nèhivì Ñuhìví, dandacú stnáì sàhà nansa quida nèhivì quìvì mà. ");
INSERT INTO mitNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Dandu cuàhàn Jesús veheñùhu. Te na sánì quìhvi‑ya yucán, (nì xini‑yà) jaàn iá iin tiàa nì ìchì dahuun iin ndahà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Doco ndoó stná nècuàchì fariseu yucán, indéhe váha‑neyà, áma dándûvàha‑ya nècuàchì cuhí‑mà cahan‑né, te ducán nìhìndèè‑né daquée cuàchi‑ne dìquì‑yá sàhà ñà‑ndùá quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dandu nì cachi‑yà xì tiàa cuhí ndahà‑xì mà: ―Ndacuiìn‑ní, cuiin‑ní dava mahì nèhivì yohó. ");
INSERT INTO mitNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dandu nì càhàn‑yà xì nèhivì nánî xì‑yá yucán, cachí‑yà: ―¿Nansa ndiá ìcà‑ndà quida‑nda quìvì descansu? ¿Amádi chicá iá vàha quida‑nda ñà‑ìá viì, te màdìá ñà‑có‑ndiàá? ¿Amádi chicá iá vàha dacácu‑nda nèhivì quìvì mà, te màdìá cahnì stnàhà‑ndà? Doco nècuàchì yucán, còò ni‑iñàha ni náxícóníhî‑né nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ñàyùcàndùá, nì xiconúù‑yá nùù nsidaa‑né, te nì cuduchi ini‑yà sàhà‑né, vàchi caxin sàstnùhù anima‑nè. Dandu nì cachi‑yà xì tiàa ma: ―Chitanini‑ní ndahà‑ní. Dandu nì chitanini nècuàchìmà ndahà‑né, te nì nduvàha dahuan. ");
INSERT INTO mitNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ñàyùcàndùá nì caquee nècuàchì fariseu mà nì càhàn‑nè xì nècuàchì partidu herodianu, nì ndatnuhu‑né nansa cui dandáñúhú‑nêyà. ");
INSERT INTO mitNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Daaní, cuàhàn‑yà xì nècuàchì dacuahá‑yá nùù mar, te cuàhà sàstnùhù nèhivì ladu Galilea nì catenchicùn stná xì‑yá. Te na ní xìtià cuentu ñà‑ndiaha guá quidá‑yá, dandu más nèhivì nì ndecoyo: nècuàchì ñuu Jerusalén, xì más gà nèhivì ladu Judea xì stná nèhivì ladu Idumea, xì nèhivì ladu duha yùte Jordán, xì nèhivì ladu ñuu Tiro xì ñuu Sidón, nsidaa‑né vàxi‑ne ndé iá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ñàyùcàndùá, nì cachi‑yà xì nècuàchì dacuahá‑yá ñà‑cundiatu tùha‑ne xì iin lancha ndé coo‑ya sàhá màsà ndútnúú guâ‑yà mahì nèhivì cuáhà mà. ");
INSERT INTO mitNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Vàchi cuàhà‑né nì dàndúvàha‑ya, ñàyùcàndùá nsidaa nècuàchì cuhí, nì nachitu‑né nùù‑yá, cuní‑nè dacácùhun‑ne ndahà‑né ìcà‑yá, te nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Stná ñà‑malu, na ní xinià‑yà, nì sàcuìtasisiá nùù‑yá, cacháˋ: ―Dèhemanì Dios nduu‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Doco mii‑yá, vihi gá cuàhà nì dàndàcú ndee‑yá nùá ñà‑màsà cáchà ana divi nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Dandu nì nana‑ya yucù, te nì cana‑ya nècuàchì tuxí‑yá ñà‑nì cáquíxí‑né nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Te nì nacàxin‑ya ùxìn ùì‑nè ñà‑cunduu‑ne nèhivì cutnahá xi‑yá cacanuu, dandu después techuún stná‑yànè cùhùn‑nè càhàn‑nè xì nèhivì palabra xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Te nì sàhatahvì‑yánè ñà‑dandúvàha‑ne nècuàchì cuhí, te tavà stná‑nè ñà‑malu ñuhú anima nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Te divi nècuàchì yohó xínduu nècuàchì nì nacàxin‑ya: iin‑ne nani Simón, te divi‑ne nì dànànì stná‑yà Pedro; ");
INSERT INTO mitNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","daaní, iá stná dèhe Zebedeo nani Jacobo xì ñani‑nè Juan, ndúì nècuàchìmà nì dànànì stná‑yà Boanerges, te cuní cachàmà na cáhàn dàvì cáhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Daaní iá stná Andrés, xì Felipe, xì Bartolomé, xì Mateo, xì Tomás, xì dèhe Alfeo nani Jacobo, xì stná Tadeo, xì Simón nì sanduu partidu cachí‑nè nècuàchì Canaán; ");
INSERT INTO mitNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","te nì ìa stná Judas Iscariote, divi nècuàchì icúmí cahin xì‑yá. Daaní, nì yàha‑ya xì compañeru‑yà ini iin vehe. ");
INSERT INTO mitNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Te yucán nì nataca cuàhà gá tu nèhivì nùù‑yá. Ñàyùcàndùá, cónì cúsáá gá‑yà cuxi‑ya, ni mii‑yá ni nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dandu nècuàchì xínduu nèhivì vehe‑ya, nì xinitnùhu‑ne nansa cachí nèhivì sàhà‑yá ñà‑sànì ndañuhu sàxìnítnùní‑yà, cachí‑nè. Ñàyùcàndùá, cuàhàn‑nè ndé iá‑yà ñà‑cùní‑nè cundaca‑neyà nùhù. ");
INSERT INTO mitNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Daaní, nècuàchì ley xi veheñùhu, nì caquee‑ne ñuu Jerusalén, nì casaà‑nè ndé iá‑yà, te nì càhàn cuàchi‑ne dìquì‑yá, cachí‑nè xì nèhivì: ―Nècuàchì jaàn, icúmí‑nê ñà‑malu nani Beelzebú ini‑nè, divi quisì cusáhnû. Ñàyùcàndùá, vàtùni tavá‑né dava ga ñà‑malu anima nèhivì, vàchi quisì mà chindéé xí‑nê ―nì cachi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ñàyùcàndùá nì cana Jesús nèhivì, te nì nacani‑ya historia nduú ejemplu, cachí‑yà xì‑né: ―Ñà‑malu, ¿nansa cui tavà stnahá nsidaa mián? Mà cúí. ");
INSERT INTO mitNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Vàchi ducán iá xán na iá xì nèhivì dandacú nùù iin ñuu, nú ni táhndè dava‑ne, te náâ stnahá‑né, dandu mà cúí dandacú gá‑nè nùù ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te nèhivì ndoó iin vehe, nú xiní ùhì stnahá‑né, dandu mà cúí cundoo tàcá gà‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Stná ñà‑malu xi Satanás, nú ni táhndè dava, te cuni ùhì stnahá, dandu mà cuéà, te yàchì nsiha, nú ducán. ");
INSERT INTO mitNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Vehe iin tiàa ndacuì, mà cúí quìhvi ndevàha nèhivì, te tavà‑né ñà‑ìcúmí‑tê. Còó, vàchi dihna icúmí‑nê chicuhni‑nète, dandu vàtùni quida‑ne ducán. ");
INSERT INTO mitNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ñà‑ndáà ndùá cachíˋ xì‑nsiá, mate nadaa ga cuàchi nèhivì iá nùù Dios, te ò nadaa ga xichi cáhàn ùhí‑nè dìquì‑yá, vàtùni cuicahnú ini‑yà sàhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Doco nú ni cáhàn ùhí‑nè dìquì Espíritu Ìì xí Dios, dandísá, mà cúí cuicahnú ini‑yà, sàhà‑né, vàchi nicanicuahàn icúmí‑nê cunsida‑ne cuàchi ma. ");
INSERT INTO mitNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ducán nì cachi‑yà xì nèhivì yucán sàhà nècuàchì cáhàn tnùhù dìquì‑yá, vàchi cachí‑nè ñà‑ìnácáá iin ñà‑malu ini‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Daaní, nì sàà stná dihi‑yá xì ñani‑yà tùvèhé, te nì techuún‑né iin razón caná‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ñàyùcàndùá, nèhivì ndoó nùù‑yá, nì cachi‑nè xì‑yá: ―Cunaha‑ní, tùvèhè càˊ iín dihi‑ní xì stná ñanì‑ní, caná‑né mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dandu nì cachi‑yà xì nèhivì mà: ―¿Ana divi nduú mamá xi cahan‑nsiá? Te ò ¿ana divi xínduu ñanì? ");
INSERT INTO mitNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dandu nì xiconúù‑yá nì indehè‑yá nsidaa nèhivì ndoó nùù‑yá, te nì cachi‑yà: ―Divi nècuàchì yohó xínduu nahi mamá xi, ò nahi ñanì. ");
INSERT INTO mitNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Vàchi nsidanicuú ana quìdà‑xì ñà‑ndùá cuní Dios, divi xínduu nahi ñanì, nahi cùhe, te nahi dihi stnáì. ");
INSERT INTO mitNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Daaní, inga xichi nì quesaha Jesús dacuahá‑yá nèhivì nùù mar. Te yucán nì nataca cuàhà gá‑nè nùù‑yá. Ñàyùcàndùá, nì nana‑ya iin lancha iín yuhù mar mà, te nì sàcòo‑ya inì‑nu. Te nèhivì cuáhà mà, yuhù mar mà nì sàcùndoo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dandu nì dàcuàhá‑yánè cuàhà iñàha, nì nacani‑ya xì‑né cuàhà historia nduú ejemplu. Te dohó nì cachi‑yà: ");
INSERT INTO mitNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Cunini‑nsia. Nìsa ìa iin nècuàchì xìtú, nì quee‑ne cuàhàn‑ne chihi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te nì sate uun‑ne tata mà. Te dava‑ña, nì còya nùù ichì. Dandu nì quixi laa, nì saxì‑síâ. ");
INSERT INTO mitNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Te dava stná mà, nì còya nùù cavà ndé còò cuàhà ñuhù. Te yàchì nì xìtià, vàchi có‑ndòó cucún ñuhù yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Doco na ní dùcàn orá, nì ìchà, vàchi cónì níhì yohá. ");
INSERT INTO mitNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Daaní, dava stná tata mà, mahì iñù nì còya. Te na ní sahnu iñù mà, dandu nì dàdáhvia viu cuati ma, ñàyùcàndùá cónì cuáha. ");
INSERT INTO mitNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Daaní, dava stná tata mà, nì còya nùù ñuhù vàha, te nì xìtià, nì sahnua, te nì cuàha; dava‑ña, òcò ùxìn gà tantu nì cuàha; te dava‑ña, ùnì dico gà tantu, te dava‑ña, ùhùn dico gà tantu nì cuàha. ");
INSERT INTO mitNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dandu nì cachi‑yà xì‑né: ―Ni cúníní vàha nsidaa‑nsiá ñà‑ndùá cachíˋ. ");
INSERT INTO mitNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na ní ndòo mii Jesús xì ùxìn ùì nècuàchì dacuahá‑yá xì stná nècuàchì ndoó yatni, dandu nì ndàcàtnùhù‑né nùù‑yá sàhà ejemplu mà. ");
INSERT INTO mitNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ñàyùcàndùá, dohó nì cachi‑yà xì‑né: ―Mii‑nsiá, sànì nìhìtáhvì‑nsiá cundaà inì‑nsia nansa iá ñuhìví ìì xí Dios, mate nísa ìa dèhé palabra sàhámà antes. Doco nècuàchì dava ga, còó. Puru ejemplu icúmî nacani xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ducán iá sàhà‑ñá màsà cúnítnùhu‑ne, mate indéhe‑né, te màsà cúndáà ini‑nè, mate iníní‑né. Pues ducán icúmí cuu xi‑né sàhà‑ñá màsà ndédúmá ini‑nè, te cuicahnú ini Dios sàhà cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dandu nì cachi stná‑yà xì‑né: ―¿A ñá‑cô‑cùndáà inì‑nsia sàhà ejemplu jaàn nduá? Pues nú coó, dandu ¿nansa cui cundaà stná inì‑nsia sàhà nsidaa ejemplu dava ga? ");
INSERT INTO mitNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","’Pues cunaha‑nsia, na ian quidá nècuàchì nì dàndiàchì uun xi tata mà, ducán quidá stná nècuàchì chìhì xì Palabra xi Dios ini anima nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tata nì còyo nùù ichì mà nduú nahi nèhivì iníní xí palabra xi Dios, doco yàchì vàxi ñà‑malu dacúxíó‑si palabra nì ndòo ini anima‑nè mà. ");
INSERT INTO mitNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Daaní, nahi tata nì còyo nùù cavà nduú nèhivì iníní xí palabra ìì, te luegu cudíì ini‑nè sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Doco na ian cùù xì viu còò yohò‑xí, ducán cuú stná xì‑né. Iyuhu gá quidándéé ini‑nè nchícùn viì‑né. Daaní, nú ni yáha‑ne iin tnùndoho, ò nú quidáquíní nèhivì xì‑né ñà‑nchícùn‑nè palabra xi‑ya, dandu luegu naxícócuîìn ini‑nè, te nacóó‑néà. ");
INSERT INTO mitNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","’Daaní, nahi tata nì còyo mahì iñù nduú nèhivì iníní xí palabra ìì, ");
INSERT INTO mitNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","doco cuàhà gá nacání ini‑nè sàhà vida xi‑ne ñuhìví yohó. Te cudíì stná ini‑nè dacáyà‑nè ñà‑cuìcà‑né, vàchi xího sàstnùhù‑né cucumi‑né cuàhà iñàha. Ñàyùcán nduá sadí xì núù palabra xi Dios ñà‑mà cùì nìhìndèá chindeá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Daaní, nahi tata nì còyo nùù ñuhù vàha nduú nèhivì iníní xí palabra ìì, te xiníndísâ‑néà. Ñàyùcàndùá, queámà ñà‑ndùú‑né na iin viu nì cana viì, a sea nduú‑né nahi viu nì cana òcò ùxìn tantu, te ò ñá‑nì cana ùnì dico tantu, te ò ñà‑nì cana ùhùn dico tantu. ");
INSERT INTO mitNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Dandu nì cachi stná‑yà xì‑né: ―Nú xícàn‑ndà quixi iin lámpara, dandu mà chícání dèhé‑ndàñá tìxi iin canasta, ò tìxi iin cama. Còó, cuiin vateá iin xaan ndé cutnuà inicutu. ");
INSERT INTO mitNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Cunaha‑nsiá, nsidaa ñà‑nì ìa dèhé, icumíâ tùi vateá. Te nsidaa ñà‑ndùá quidá dèhé nèhivì, icúmíâ natùi clarúà. ");
INSERT INTO mitNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ni cúníní vàha nsidaa‑nsiá palabra jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Dandu nì cachi stná‑yà xì‑né: ―Cunini vàha‑nsia na sáha xi‑nsiá (ichì váha). Vàchi divi vara chitácùhá‑nsià icúmí stná mii‑nsiá nacuitacùhá‑nsià. Doco nú iníní vàha‑nsia, dandu chicá nìhìtáhvì‑nsiá cundaà vàha inì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Vàchi nècuàchì sàñùhú (ñà‑vàha) inì‑xi, chicá más icúmí‑nê nìhìtáhvì‑né; doco nèhivì có‑ñùhú ndisa (ñà‑vàha) inì‑xi, ndè iyuhu (ñà‑vàha) ñuhú ini‑nè, icúmíâ cuxio nsiha. ");
INSERT INTO mitNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dandu nì cachi stná Jesús: ―Na historia yohó, ducán iá stná ñuhìví ìì xí Dios. Nì chihi iin tiàa tata mahì itù‑te. ");
INSERT INTO mitNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Na túinuù, dandu ndácòo‑tè (nácòtò‑teá); daaní sàñaà quídì‑te. Doco tata mà, xítià te sahnúá, mate có‑cùndáà inì‑te índù modo sahnúá. ");
INSERT INTO mitNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Vàchi iin itu, miá cuàha. Dihna viu xítià, dandu después caná sìcàyòcó‑ñà, te nachitu nùnìá. ");
INSERT INTO mitNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te nú sànì sisa vàha, dandu yàchì icúmí ndanchito cosecha, vachi sà‑ìáˋ. ");
INSERT INTO mitNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Dandu nì cachi stná Jesús: ―¿Índù iñàha cui cachì sàhà‑ñá cundaà vàha inì‑nsia nansa iá ñuhìví ìì xí Dios? ¿Índù ejemplu cui nacani sàhà ñà‑cundaà inì‑nsia nansa iá tiempu mà? ");
INSERT INTO mitNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Pues, cunaha‑nsiá, nahi tata yutnù mostaza, ducán iá tiempu mà. Vàchi tata mà, mate tata chicá cuati iá ñuhìví nduá, doco nú sànì chihi‑ndañá, dandu sahnúá. Queé nahnú ndahà‑nú, te vihi gá nducáhnûá nùù nsidaa gá ñà‑tàtá. Dècuèndè laa ndavá ansivi vàxi sácuìtàndòó casì mahì ndahà‑nú ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Cunaha‑nsiá, cuàhà gá ejemplu nahi ñà‑jaàn nì nacani‑ya xì nèhivì na dacuahá‑yánè, según nansa nì sàà‑nè cundaà ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Puru historia nduú nahi ejemplu nì nacani‑ya xì‑né, doco na ní ndòo mii‑yá xì nècuàchì dacuahá‑yá, dandu nì dàtúi nsihi‑ya sàhámà nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na ní cuñaà quìvì yucán, nì cachi‑yà xì nècuàchì dacuahá‑yá: ―Cúhùn‑ndà yàha‑nda ladu mar. ");
INSERT INTO mitNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dandu nì dànácuîtià compañeru‑yà nèhivì cuáhà mà. Te mii‑yá, nacua iá‑yà ini lancha, ducán nì saca‑neyà cuàhàn‑nè yàha‑ne mar. Te cuàhàn stná iin ùì gà lancha ndoó stná yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Doco después nì dàñà iin tàchì dàná, te nì nacuahnu todò tècuìí, nì xìnu‑tè ndè ini lancha mà, sàdaaní chitu‑nú. ");
INSERT INTO mitNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Doco mii‑yá, indúhu‑yá quídì‑yà cahà‑nú, ihí almohada dìnì‑yá. Dandu nì dànsícuìhnu ini‑nèyà, cachí‑nè xì‑yá: ―¡Ay! ¡Maestro! ¿A có‑ndùlócô‑nî ñà‑vihini cui‑ndà? ");
INSERT INTO mitNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dandu nì ndacuiin‑yà, nì càhàn‑yà nì sadi‑yà nùù tàchì mà, te nì cachi‑yà xì tècuìí mar: ―Ihíì‑ní ni coó, te ni ndúdádî. Dandu luegu nì cucuiìn tàchì, te nì nàcùñuhu dadí tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Dandu nì cachi‑yà xì nècuàchì yucán: ―¿Índù chuun yúhî guâ‑nsià? ¿A có‑càhví‑nsiá xì Dios? ");
INSERT INTO mitNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dandu nì yùhí sàstnùhù nècuàchìmà, te nì cachi‑nè iin‑ne xì inga‑nè (sàhà‑yá): ―¿Índù clase nèhivì nduú nècuàchì yohó, te dècuèndè tàchì xì mar iníní xí‑nê? ");
INSERT INTO mitNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Daaní, nì sàà‑nè xì‑yá inga ladu mar nùù ñuu nècuàchì Gadareno. ");
INSERT INTO mitNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Te na ní quee‑ya nùù lancha, luegu nì ndacùhun tnahá‑yá xì iin tiàa ñuhú ñà‑malu inì‑xi, vàxi‑ne dècuèndè mahì cueva ndé xí‑indùxin nsìi. ");
INSERT INTO mitNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Vàchi de por sí, yucán iá dahuun‑ne. Te còò ni‑iin cui chicuhni xì‑né, mate cadena ni cúndúá. ");
INSERT INTO mitNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cuàhà xichi nì sàcùnuhni‑nè xì manilla càa, xì stná cadena. Doco siempre sahndé‑nèà, te dacuachí stná‑nè manilla mà. Còò ni‑iin cui nsida viì xì sàxìnítnùní‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nicanicuahàn ndui te ñuú ndáhì loco‑nè, xicánúú‑né yucù xì mahì cueva mà, danácuêhè‑nè mii‑né xì yùù. ");
INSERT INTO mitNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Doco na ní xini xìcà‑né Jesús, nì dàyáà‑nè nì sàà‑nè nùù‑yá, te nì sàcuììn sìsì‑né nùù‑yá, ");
INSERT INTO mitNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ndáhì ndee‑né quidá ñà‑malu, te nì cachi‑nè: ―Jesús, ¿ndíà cunduu‑ní yùhù? (Yùhù ináhî mii‑ní), Dèhemanì Dios iá dìquì‑xí ansivi nduu‑ní. Sàhà Dios sacúndáhvîˋ nùù‑ní, ¡màsà dándóhó‑nî yùhù! ");
INSERT INTO mitNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Pues ducán nì cachi nècuàchìmà, vàchi làcà nì cachi‑yà xì‑ñá: ―¡Cuxio yohó ñà‑malu nùù tiàa yohó! ");
INSERT INTO mitNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dandu nì ndàcàtnùhù stná‑yà nùá: ―¿Nansa nanu? Te nì cachà: ―Ejército naní, vàchi cuàhà nduú‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dandu cuàhà gá nì sacundahví tiàa ma nùù‑yá ñà‑màsà téchúûn‑yáñà cùhàn inga ñuu. ");
INSERT INTO mitNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Te yatni yucù yucán nì sandoo cuàhà cochi, xixáhan‑sì. ");
INSERT INTO mitNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ñàyùcàndùá, nì sacundahvíà nùù‑yá, cacháˋ: ―Dayáha‑ní nsiùhù ni cúhùn‑nsì màcùñuhu‑nsi ini cochi yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dandu nì dàndáà‑yàñà. Ñàyùcàndùá nì caquea nùù tiàa ma cuàhàn, nì sàcùñuha ini cochi yucán. Nahi ùì mil nì sanduu‑sì. Daaní, carrera nì nuu nsidaa‑sí candiaa yucán, te nì còyo‑sì ini mar nì càhà‑si. ");
INSERT INTO mitNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Daaní, tè‑xíndiaa xì cochi mà, nì yùhí‑te; carrera mànuhù‑té nì cachitnùhu‑tè xì nècuàchì ini ñuu mà xì stná nècuàchì ndoó ranchu. Dandu nèhivì ndoó yucán, vàxi‑ne cundehè‑né ñà‑ndùá nì cuu. ");
INSERT INTO mitNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nì quesaa nsidaa‑né ndé iá‑yà, te nì caxini‑nè nècuàchì nìsa ñuhu cuàhà ñá‑malu inì‑xi, iá‑nè, ndixí‑né sìcoto, sànì nàcòo nsihi sàxìnítnùní‑nè. Dandu nèhivì yucán, nì cayùhí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Te nècuàchì nì caxini nansa nì cuu, nì nacani‑ne xì nsidaa nèhivì mà sàhà cochi xì sàhà stná tiàa ma. ");
INSERT INTO mitNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dandu nèhivì cuáhà mà, nì quesaha‑né nì sacundahví‑nè nùù‑yá ñà‑nì quèé dahuun‑ya ñuu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Daaní, na sánì nana tu‑ya lancha yucán, dandu nì càhàn nècuàchì nìsa ñuhu ñà‑malu inì‑xi, nì xìcàn‑nè áma cui cutnahá stná‑nè xì‑yá cùhùn. ");
INSERT INTO mitNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Doco cónì sáha‑ya cùhùn‑nè: ―Còó ―cachí‑yà―, xuhun‑ní vehe‑ni, te cachitnùhu‑ní xì tnaha‑ní ñà‑cuàhà guá nì quida Stohò‑ní Dios xì‑ní, te nì cuhi ini‑yà mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ñàyùcàndùá, nì quee tiàa ma cuàhàn‑nè inicutu ladu mà nani Decápolis, nì cachitnùhu‑ne ñà‑ndiaha guá nì quida Jesús xì‑né. Te nsidaa nèhivì yucán, nì ndulocó‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Dandu nì nayàha‑ya ini lancha cuàhàn‑yà inga ladu mar. Te yucán yuhù mar mà nì nataca cuàhà sàstnùhù nèhivì nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dandu yucán nì sàà stná iin nècuàchì cusáhnû nùù iin veheñùhu, Jairo nani‑né. Te nì tnàtuu‑ne nùù‑yá, nì tutuyuhu‑né ñuhù nùù sàhà‑yá, ");
INSERT INTO mitNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","te nì sacundahví cuàhà‑né nùù‑yá, cachí‑nè: ―Meru cucáhvî dèheyoquí. Cúhùn‑ndà, chindàndòò‑ní ndahà‑ní dìquì‑ñá sàhà‑ñá nduvàha‑ñà, te màsà cúì‑ña. ");
INSERT INTO mitNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ñàyùcàndùá, cuàhàn‑yà xì‑né. Te cuàhà gá stná nèhivì cutnáhâ xí‑yâ nchícùn stná‑nè cuàhàn, dècuèndè tnuu cuàhàn‑nè xì‑yá ñà‑cuàhà guá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Te cunaha‑nsiá, mahì nèhivì mà cuàhàn stná iin nècuàchì ñahà cuhí. Ùxìn ùì cuìà sàcuàhàn‑nè ndohó‑né cuèhè nìì. ");
INSERT INTO mitNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Te cuàhà gá sànì ndoho‑ne nì quida nècuàchì quidátátná, doco cónì níhì nècuàchìmà chindee‑ñánê. Còó, chicá nì quida yaa cuèhè xi‑ne, dècuèndè sànì dànsìhí‑né dìhùn xí‑né sàhá. ");
INSERT INTO mitNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Doco na ní xinitnùhu‑ne sàhà Jesús, nì quixi‑ne ladu yàtà‑yá mahì nèhivì cuáhà mà, te nì dàcúhùn ndahà‑né nùù sìcoto xi‑ya, ");
INSERT INTO mitNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","vàchi nì nacani ini‑nè: “Nú ni dúcùn ndahí mate sìcoto‑ni xi‑ya, vàtùni nduvàhi”. ");
INSERT INTO mitNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Te (ñà‑ndáà nduá), luegu nì cucuiìn nìì‑né, te nì cuu ini‑nè sànì nduvàha‑ne cuèhè dana ma. ");
INSERT INTO mitNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Daaní, momentu mà nì cundaà stná ini‑yà sànì dàndúvàha iin nèhivì xì poder xi‑ya. Ñàyùcàndùá, nì naxicocuíìn duma‑yá yàtà‑xí mahì nèhivì cuáhà mà, te nì cachi‑yà: ―¿Ana divi nì dùcùn ndahà‑xí ìcà sìcoto xi? ");
INSERT INTO mitNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dandu nècuàchì dacuahá‑yá, nì cachi‑nè xì‑yá: ―¿A có‑xìní‑nî ñà‑cuàhà guá nèhivì ndoó yohó, te yáha ga tnuu cuàhàn‑ndà? Te nú ducán, dandu ¿índù chuun cachí‑nî: “¿Ana nì dùcùn ndahà‑xí ìcà sìcoto xi?”? ");
INSERT INTO mitNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dandu nì xiconúù‑yá nì indehè‑yá, áma nátùi nècuàchì nì quida mà. ");
INSERT INTO mitNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Te nècuàchì ñahà mà, ndé quìdí cuisì‑né ñà‑yúhî‑nè, vàchi ináhá‑nê ñà‑ndùá nì cuu xi ini‑nè. Dandu nì tnàtuu‑ne, nì sàcuììn sìsì‑né nùù‑yá, te nì cachi ndàà‑nè xì‑yá nsidaa ñà‑ndùá nì cuu xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dandu nì cachi‑yà xì‑né: ―Hija, sànì nduvàha‑ní ñà‑nì xinindisa‑ní. Vàtùni nùhù‑ní contentu vichi. Iin‑ni ni cúxíó cuèhè dana nìsa quida xi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na meru cachí‑yà ducán, dandu nì caquesaa nèhivì vàxi vehe presidente xi veheñùhu ma, te nì cacachi‑nè xì nècuàchìmà: ―Sànì xìhì dèhe yoco‑ní. Có‑xìñùhù cuàhachuún gà‑ní maestru. ");
INSERT INTO mitNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Doco Jesús, cónì ndúlócô‑yà sàhà ñà‑ndùá nì cachi‑nè, cuisì‑ní nì cachi‑yà xì presidente mà: ―Màsà yúhî‑nî. Cuisì cunihnu vàha inì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dandu nì cachi‑yà ñà‑màsà cútnáhâ gá nèhivì xì‑yá, cuisì‑ní Pedro, xì Jacobo, xì ñani Jacobo nani Juan. ");
INSERT INTO mitNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Te nì sàà‑yà xì‑né ndè vehe presidente mà, te nì xini‑yà ndoó chitu nèhivì, yáha ga quidácuáhà‑né, sacú ndee‑né, te cána fuerte‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dandu nì nsìhvi‑ya vehe, te nì cachi‑yà: ―¿Índù chuun cána guá‑nsia, te sacú guá‑nsià? vàchi cónì xíhì ñahà chìì yohó. Quídì uun ni‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Doco nècuàchìmà, nì sàcùndiaa uun‑neyà. Ñàyùcàndùá, nì tavà nsìhí‑yánè fuera, te nì saca‑ya yuadíhâ xì nècuàchì cutnáhâ xí‑yâ, nì yàha‑ne ndé indúhu ñahà chii ma. ");
INSERT INTO mitNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dandu nì tnii‑ya ndahà‑ñá, cachí‑yà: ―Talita cumi ―te cuní cachàmà dàhàn ñuu yucán: Yohó cachí xìˊ, ndacuiin xá. ");
INSERT INTO mitNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dandu vichi vichi nì ndacuiìn‑ña nì nacacanuu‑ñà, vàchi nahi ùxìn ùì cuìà xicá‑ña. Te nècuàchì cutnáhâ xí‑yâ, nì candulocó sàstnùhù‑né sàhà ñà‑ndùá nì cuu. ");
INSERT INTO mitNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Doco mii‑yá, nì chinaha‑yánè ñà‑màsà cáchí‑nè xì nèhivì ñà‑ndùá nì xini‑nè. Dandu nì cachi‑yà xì‑né ni dácúxî‑nèña. ");
INSERT INTO mitNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Dandu nì quee Jesús yucán mànuhù‑yá ñuu‑yà, te nchícùn stná nècuàchì dacuahá‑yá, ndacá tnáhâ‑né xì‑yá cuàhàn. ");
INSERT INTO mitNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Te na ní sàà quìvì descansu ñuu yucán, nì sàhàn‑yà veheñùhu, te nì quesaha‑yá dacuahá‑yá nèhivì. Te na ní inini‑ne ñà‑ndùá nì cachi‑yà, nì ndulocó‑nè, cachí‑nè: ―¿Índù nì xini‑ndà nì nìhìtáhvì guá nècuàchì yòhó? Te ¿índù nì xini‑ndà nì cunchichí guâ‑nè? ¿Te nansa iá stná milagru quidá‑né? ");
INSERT INTO mitNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Vàchi iin ana tùha yàcún yutnù nduú‑né. Te dihi‑né nani María, te ñani‑nè nduú Jacobo, xì José, xì Judas, xì Simón. Te ñahàcúha‑ne, ¿a có‑ndòó stná‑nè yohó ndé ndòò‑ndà? Ducání nì cachi‑nè ñà‑nì cuduchi ini‑nè sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Doco nì cachi‑yà xì‑né: ―Iin ana cáhàn cuenta xi Dios, nú inga ñuu ni cáhàn‑nè, dandu siempre quidáñúhú nèhivì ñuu mà‑né, doco nèhivì ñuu mii‑né, ò tnaha‑ne, ò nèhivì vehe‑ne, còó, có‑quìdáñúhú‑ñánê ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ñàyùcàndùá, mànìcùí quida‑ya milagru ñuu‑yà mà, cuisì iin ùì nècuàchì cuhí, nì chitàndòó‑yá ndahà‑yá dìquì‑né, te nì nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Te nì ndulocó‑yà ñà‑có‑cùní nècuàchì ñuu mà cunindisá‑né. Dandu nì nacàhin‑ya vuelta cuàhà ñuu cuati, nì dàcuàhá‑yá nècuàchì ñuu yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dandu nì cana‑ya ùxìn ùì nècuàchì dàcuàhá‑yá, te nì dàndàcú‑yá ñà‑cutnahá ùì ùì‑nè cùhùn. Te nì sàhatahvì‑yánè ñà‑tavà‑né ñà‑malu. ");
INSERT INTO mitNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Te nì cachi stná‑yà xì‑né ñà‑còò ni‑iñàha cunihi‑ne cùhùn ichì mà, cuisì‑ní bastón xi‑ne; còò morral, còò pan, còò dìhùn cunihi‑ne ini siuhmatìxi‑ne, ");
INSERT INTO mitNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","te ndìsàn uun ni cúnáì‑né. Te cuisì imindaa dùhnù cundixi‑ne cùhùn. ");
INSERT INTO mitNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Te nì cachi stná‑yà xì‑né: ―Nú cuàhàn‑nsià cundoo‑nsia iin vehe, dandu iin‑ni cundoo‑nsia yucán ndè cachi sàà quìvì quee‑nsia ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te nú có‑cùní nèhivì quihin casú‑nè cunini‑ne, dandu quee‑nsia ñuu‑nèmà, te catù‑nsiá sàhà‑nsiá ñà‑còyo yàcá ñuu mà. Vàchi ñà‑jaàn cunduu testigu dìquì‑né quìvì coo juiciu xi‑ne. Te yùhù cachíˋ xì‑nsiá, na sáà quìvì ndàcàn Dios cuenta sàhà cuàchi, dandu chicá cuàhà castigu icúmí nècuàchìmà nìhì‑né nùù nècuàchì (malu) nì sandoo ñuu Sodoma xì ñuu Gomorra sànaha. ");
INSERT INTO mitNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dandu nècuàchì dacuahá‑yá mà, nì caquihin‑ne ichì cuàhàn‑nè, nì càhàn‑nè xì nèhivì ñà‑ndìá ìcà‑né naxicocuíìn ini‑nè sàhà cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Te nì tavà stná‑nè cuàhà ñà‑malu ñuhú ini nèhivì, te nì saquin stná‑nè seña xì aceite dìnì cuàhà nècuàchi cuhí, te nì dàndúvàha‑ñané. ");
INSERT INTO mitNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ñà‑cuàhà guá nì xìtià fama xi Jesús, ñàyùcàndùá, nì xinitnùhu stná rey nani Herodes. Te sàhámà nì cachi tèmà: ―Sànì natiacu Juan Bautista, te ñàyùcàndùá quidá‑né milagru. ");
INSERT INTO mitNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ducán nì cachi tèmà. Doco dava ga nèhivì, nì cacachi‑nè sàhà‑yá ñà‑divi Elías nìsa ìa sànaha nduú‑yá. Te dava ga‑nè, nì cachi‑nè ñà‑iin nècuàchì cáhàn cuenta xi Dios nduú‑yá, nahi nècuàchì profeta sànaha. ");
INSERT INTO mitNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Doco Herodes mà, dohó nì cachì‑te na ní xinitnùhu‑tè sàhà‑yá: ―Còó, divi Juan nduú‑né, vàchi sànì natiacu‑nè, mate ní quendodò dìnì‑né nì quide. ");
INSERT INTO mitNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ducán nì cachi tèmà, vàchi antes nì chicadì‑te Juan, nì dàndàcú‑te nùù soldadu xi‑tè, te nì tnii tèmàné. Ñàyùcàndùá nì sàcùnuhni‑nè cadena, te nì sàcùndiadi‑nè vehecàa. Pues nsidaa ñà‑jaàn nì quida Herodes mà sàhà‑ñá cuní‑te ndòo vàha‑tè nùù iin ñahà nani Herodías. Vàchi sànì nandàhà‑té xí‑ñâ mate ñahàdìhí ñanì‑te Felipe nduú‑ña. ");
INSERT INTO mitNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ñàyùcàndùá nì cachi Juan xì‑té: ―Có‑sâha Dios lugar coo‑ní xì ñahàdìhí ñanì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pues divi sàhà ñà‑jaàn nì xini ùhì Herodías mà Juan, te cuní‑ña cahnì‑ñánê, doco mànìcùí. ");
INSERT INTO mitNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Vàchi Herodes mà, ináhá‑tê Juan ñà‑ndùú‑né iin nècuàchì nihnú ndáà inì‑xi, te ìì stná ini‑nè. Ñàyùcàndùá, yúhî‑tené. Te divi sàhájàn nì xidahan stná‑te nècuàchìmà nùù ñahà mà. Te cudíì stná inì‑te cunini‑tè ñà‑ndùá cachí nècuàchìmà, mate cónì sáà‑te cundaà vàha inì‑te. ");
INSERT INTO mitNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Doco nì sàà iin quìvì nì cuu ofrecer nansa dandáñúhú ñahà màné, vàchi nì naxìnu rey mà cuìà, te nì quida‑tè iin vicò cahnú nì casaà cuàhà tè‑cùsáhnû ñuu mà, xì cuàhà stná comandante capitán, xì stná cuàhà tècuìcà ndoó ladu Galilea yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dandu nì quìhvi dèheyoco Herodías mà ndé iá vicò, te nì ìtasaha sàstnùhù‑ñá, nì dàcúdîì inì‑ña rey mà xì stná tè‑xínduu visita xi‑tè. Ñàyùcàndùá, nì cachì‑te xi‑ñá: ―Ndéni iñàha nì cui cunú, càcùn‑ñá nùí, te nìhùn‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Te nì chinaha‑té Dios ñà‑ndéni iñàha nì cui ni cácàn‑ña, cuàha‑tèñá, mate ni cúndúá iin davatahvi ñuu ndé cusáhnû‑te, cuàha‑tèñá. ");
INSERT INTO mitNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ñàyùcàndùá nì quee‑ñà cuàhàn‑ña ndàcàtnùhù‑ñá nùù dihi‑ñá: ―¿Ndíà nduá càquìn? Te nì cachi dihi‑ñá: ―Dìnì Juan Bautista càcùn ―nì cacha. ");
INSERT INTO mitNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ñàyùcàndùá, yàchì nì nansìhvi ñahà chìì mà ndé iá rey mà, te nì xìcàn‑ña, cachí‑ña: ―Dìnì Juan Bautista taxi‑ní luegu, cunacaà ini iin charola cahnú ―cachá. ");
INSERT INTO mitNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Dandu rey mà, cuàhà gá nì cuhuun inì‑te, doco sàhà‑ñá sànì dàndáà‑te, te sàhà stná visita ndoó yucán, ñàyùcàndùá có‑cùní‑te dama‑tè ñà‑ndùá nì cachì‑te xi‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sàhájàn vichi vichi nì techuún‑te iin tè‑cùhùn cahnì xì Juan, te cunihi tèmà dìnì‑né ndixi. ");
INSERT INTO mitNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ñàyùcàndùá, nì sàhàn tèmà vehecàa, nì quendodò‑té dìnì‑né, te nihí‑teá ini iin charola nì nansìhvi nì sàha‑tè ñahà chìì mà, dandu mii‑ñá, nì sàha‑ñà dihi‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Daaní, na ní caxinitnùhu nècuàchì nìsa dacuahá Juan, dandu nì casahàn itnii‑né nì naquihin‑ne iquìcúñú nsìi ma nì sùxin‑ne nì chicaa‑nèà ndé nduú cueva xi nsìi. ");
INSERT INTO mitNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Daaní, nì cansiaa nècuàchì nì techuún Jesús cacanuu, te nì canataca‑nè nùù‑yá, nì nacani‑ne xì‑yá nsidaa ñà‑ndùá nì quida‑ne xì ñá‑ndùá nì chinaha‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Dandu nì cachi‑yà xì‑né: ―Naha‑nsià cùhùn cuaán‑nda iin xaan ndé có‑ndòó nèhivì, quetatu chii‑nsiá. Ducán nì cachi‑yà, vàchi ni có‑cùsáá gá‑nè cuxi‑ne, ñà‑cuàhà guá nèhivì queé nsíhvi nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ñàyùcàndùá nì nana‑ya xì‑né ini iin lancha ñà‑cùhùn cuaán‑yá xì‑né iin xaan ndé còò iin. ");
INSERT INTO mitNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Doco nì xini nèhivì cuàhàn‑yà, te cuàhà‑né nì nacuni‑nèyà, ñàyùcàndùá nì caquee‑ne nsidaa ñuu nì dàyáà‑nè, te dihna‑ne nì sàà‑nè nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ñàyùcàndùá, na ní quee‑ya nùù lancha mà, nì xini‑yà cuàhà gá‑nè ndoó, te nì cuhi ini‑yànè, vàchi nahi riì còò stohò‑xi, ducán nduú‑né. Ñàyùcàndùá, nì dàcuàhá‑yánè cuàhà iñàha. ");
INSERT INTO mitNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Daaní, na ní cuaà nì catnàtuu nèhivì siempre nchícùn xì‑yá nùù‑yá, cachí‑nè: ―Vichi sàcuàhàn nì cuaà, te lugar yohó, còò ni‑iin vehe. ");
INSERT INTO mitNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ñàyùcàndùá, ndaquìndèè‑ní xì nèhivì yohó ñà‑nì cuítià‑nè cùhùn‑nè ndè ranchu ò ñuu cuati ndoó yatni, te cuiin‑ne ñà‑cutiacu‑nè, vàchi còò ñá‑cuxi‑ne lugar yohó. ");
INSERT INTO mitNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dandu nì cachi‑yà xì‑né: ―Mii‑nsiá dacuxí‑nsiánè. Te nì cachi‑nè xì‑yá: ―¿A cúhùn‑nsì xì ùì cientu dìhùn plata, te cuiin‑nsi pan dacuxí‑nsínè? ");
INSERT INTO mitNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Dandu nì cachi‑yà xì‑né: ―¿Nadaa pan icúmí‑nsiâ? Cuahán‑nsià cundehè‑nsiá. Ñàyùcàndùá, (nì ndàcàtnùhù‑né), te na ní cundaà ini‑nè, nì cachi‑nè: ―Ùhàn, xì ùì siaca. ");
INSERT INTO mitNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dandu nì dàndàcú‑yá ni mácùndoo nsidaa nèhivì mà, cuaán cuaán iin iin grupu‑nè nùù yùcù cuií. ");
INSERT INTO mitNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Te ducán nì quida‑ne nì sàcùndoo yucùn‑né, cientu cientu‑ne, te dava cientu dava cientu‑nè nùù iin iin grupu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dandu nì tnii‑ya ùhùn pan mà xì ùì siaca ma, nì ndacoto ndiaá‑yà dìquì‑xí, te nì naquimanì‑yá Dios sàhà‑ñá. Dandu nì dàcuàchí‑yá pan mà nì sàha‑ya nècuàchì dacuahá‑yá, te mii‑né, nì dasàn‑néà nùù nèhivì cuáhà mà; daaní, divi‑ni ducán nì quida stná‑yà xì ùì siaca, nì dàcuàchí stná‑yàsi nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Te nì xixi nsidaa‑né nì ndenuu ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Dandu nì chivàha‑ne ñà‑nì cuyodò gá, pedazu siaca xì stná pedazu pan, te nì chitu ùxìn ùì ìcà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te cunaha‑nsiá, ùhùn mil tiàa nì sanduu nèhivì nì xixi xi pan mà. ");
INSERT INTO mitNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Daaní, vichi duha nì cachi‑yà xì nècuàchì dacuahá‑yá ñà‑nì mácùñuhu‑ne ini lancha, te codònùù cueé‑nè nùù‑yá cùhùn‑nè inga ladu mar dècuèndè ñuu Betsaida. Doco mii‑yá, cuàhàn‑yà danácuîtià‑yà nèhivì cuáhà mà. ");
INSERT INTO mitNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Te nì nsihi nì ndaquìndèè‑yá xì‑né, dandu nì nana‑ya iin yucù nì xìcàn tàhvì‑yá nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Daaní, na ní cuñaà, xicá íì lancha mà mahì mar. Doco mii‑yá, mindaa‑yá iá‑yà ñuhù íchî. ");
INSERT INTO mitNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dandu nì xini xìcà‑yánè ñà‑ùhì gà dacacá‑nènu xi yutnù iá nahi pala, vàchi caná tàchì ladu nùù‑né. Ñàyùcàndùá, sinduhá nì sàà‑yà nùù‑né, xicándódo‑yá nùù tècuìí mar, te nihnú ini‑yà yàha‑ya iin ladu. ");
INSERT INTO mitNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Doco na ní caxini‑nè nansa xicá‑yá nùù tècuìí ducán, dandu nì càna ndee‑né, vàchi duma nduá càhàn‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Vàchi nsidaa‑né, nì xini‑nèyà, te nì ndulocó‑nè, yúhî cuàhà‑né. Doco nì càhàn‑yà xì‑né, cachí‑yà: ―Nacuàhandee inì‑nsia, vàchi yùhù nduí; màsà yúhî‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dandu nì quècahnu‑ya ini lancha ndé ndoó‑né, te nì cucuiìn tàchì mà. Ñàyùcàndùá, cuàhà sàstnùhù nì ndulocó gà‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Vàchi cónì sánìhì váha ini‑nè sàhà milagru nì nducuahà pan mà, vàchi ùhì mànìhì ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Daaní, na sánì yàha‑ya xì‑né mar mà, dandu nì sàà‑yà ñuhù íchî iin ñuu nani Genesaret. ");
INSERT INTO mitNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te na ní quecoyo‑ne xì‑yá nùù barcu mà, dandu vichi vichi nì nacuni nèhivì ñuu mà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ñàyùcàndùá, nì cadayáà‑nè cuàhàn‑nè inicutu ladu yucán, nì sàquíhin‑ne nècuàchì cuhí xi‑ne, te nihí‑né nècuàchìmà vàxi nùù‑yá itánduhù‑né nùù camilla. Te ndéni nì cui nì xinitnùhu‑ne iá‑yà, divi yucán nì sàà‑nè xì nècuàchì mà. ");
INSERT INTO mitNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Te na yáha‑ya ñuu cuati, ò ñuu nahnú, te ò iin ranchu, o ndéni nì cui, yucán nì cachitànduhù‑né nècuàchì cuhí xi‑ne ichì, te nì xìcàn‑nè ñà‑siquiera nùù sàhà sìcoto xi‑ya ni dúcùn ndahà nècuàchì cuhí mà. Te nsidaa ana nì dùcùn ndahà‑xí ducán, nì nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Daaní, ñuu Jerusalén nì caquee dava nècuàchì fariseu xì stná nècuàchì ley xi veheñùhu vàxi‑ne, nì quesaa‑nè nùù Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Te nì caxini‑nè nansa quidá nècuàchì dacuahá‑yá, xixí‑né comida xi‑ne, te cónì ndàhá‑né. Ñàyùcàndùá, nì caxitnùhu‑ne nècuàchìmà. Vàchi modo jaàn nduhíì ndahà‑ndà (càhàn‑né). ");
INSERT INTO mitNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Vàchi nècuàchì fariseu mà, xì nsidaa gá nècuàchì raza Judea, nú màsà ndáhá‑né, mà cúxí‑né, vàchi ducán iá estilu xi xìì‑né chivàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Te nú nì sàhàn‑nè yàhvi, dècuèndè ndaha‑ne, dandu cuxi‑ne. Te cuàhà sàstnùhù gá estilu icúmí‑nê chivàha‑ne, vàchi icúmí‑nê nacate stná‑nè taza, quìdi, yoo, càa, cama. ");
INSERT INTO mitNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ñàyùcàndùá, nècuàchì fariseu mà, xì stná nècuàchì ley xi veheñùhu, nì xìcàn tnùhù‑né nùù Jesús, cachí‑nè: ―Nècuàchì dacuaha‑ní, ¿índù chuun có‑nchîcùn‑nè estilu xi xìì‑ndà? vàchi có‑ndùhíì ndahà‑né na xixí‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Dandu nì cachi‑yà xì‑né: ―Ñà‑ndáà nduá nì cachitnùhu Isaías sàhà mii‑nsiá sànaha, vàchi dananí uun‑nsia vàha‑nsia. Pues ñà‑yòhó ndùá nì cachi Dios, te nì tiaa Isaías yucán: Nèhivì yohó, cuisì‑ní yuhù‑né quidáñúhú‑nê yùhù, màdì ini anima‑nè, vàchi xica iéˋ cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Cahvi‑né yùhù tuxí‑né, doco có‑ndiàáˋ, vàchi nèhivì ùún nduú ana nì quidavàha xi ley chináhá‑nè nèhivì, cachí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Vàchi mii‑nsiá, mà úhì nacóó nihni‑nsia ñà‑ndùá nì dàndàcú Dios, doco ñà‑ndùú ley xi nèhivì ùún, ñà‑jaàn ndisa quidá‑nsiá cumplir. Costumbre xi‑nsia nduú ñà‑nàcáté‑nsiá quìdi, xì taza, te cuàhà gá costumbre icúmí stná‑nsià nahi ñà‑jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Dandu nì cachi gà‑yà xi‑né: ―Mii‑nsiá, tuxí inì‑nsia vàtùni nacoo‑nsia ñà‑ndùá nì dàndàcú Dios, te cuisì estilu xi mii‑nsiá chivàha‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","(Cundehè‑nsiá casu yohó): sànaha nì cachi Moisés ñà‑ìcúmí coo tnùñuhu xi‑nda nùù yuadíhí‑ndá, te nú ni cáhàn ùhí iin nèhivì dìquì iin yuadíhí‑nê, dandu icúmí‑nê cui‑nè. (Ducán nì cachi Dios.) ");
INSERT INTO mitNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Doco tucu cachí mii‑nsiá, vàchi cachí‑nsià vàtùni cachi iin nèhivì xì yuadíhí (ndahví‑nè): “Mà cúí chindeí mii‑nsiá xì ñà‑ndùá icúmî, vàchi sànì cachì sàhà nsidaámà ñà‑ndùá dìhùn íì; vàchi sànì cachì: Corbán nduá, te cuní cachàmà, dìhùn xí Dios nduá”. ");
INSERT INTO mitNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Te nú ducán ni cachí nècuàchìmà, dandu có‑sâha ga‑nsià chindee gá‑nè yuadíhí‑nê (xì dìhùn mà). ");
INSERT INTO mitNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ñàyùcàndùá, sàhà estilu xi‑nsiamà, iladu sànì ndòo ley ìì mà, te cuisì estilu nì ndòo nùù‑nsiá chívàha‑nsia. Te cuàhà gá estilu tnaha ñà‑yùcán icúmí stná‑nsià ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dandu nì cana‑ya nèhivì cuáhà mà ñà‑tnàtuu‑ne nùù‑yá, te nì cachi‑yà xì‑né: ―Cunini nsidaa‑nsiá, te cundaà vàha inì‑nsia: ");
INSERT INTO mitNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","mà cúnsídá cuàchi ni‑iin nèhivì sàhà ñà‑ndùá xixí‑né. Còó. Ñà‑nìhnú ini anima‑nè, te quidá‑néà, divi ñà‑jaàn nduá dacuidá cuàchi xì anima‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ni cúníní vàha nsidaa‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dandu nì yàha‑ya ini vehe, te nì ndòo nèhivì cuáhà mà tùvèhé. Dandu nì ndàcàtnùhù nècuàchì dacuahá‑yá nùù‑yá ndíà ndùá cuní cachi ejemplu mà. ");
INSERT INTO mitNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Te nì cachi‑yà xì‑né: ―¿A có‑sânìhì stná ini mii‑nsiá? Cunaha‑nsiá, ñà‑ìá fuera iquìcúñú‑ndà, nú ni quéa yuhù‑ndà, mà cúí dacuidá cuàcha‑ndó nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Vàchi màdì ini anima‑ndà quíhvia. Còó, tìxi‑nda cuáhàn, dandu después queá. Ducán nì cachi‑yà sàhà‑ñá cundaà ini‑ndà comida viì nduú nsidaa clase ñà‑cutiacu‑ndà, màdì cuáchi nduá cuxi‑ndañá. ");
INSERT INTO mitNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Dandu nì cachi stná‑yà: ―Ñà‑ndùá nihnú ini nèhivì, te queá anima‑nè, divi nduá dacuidá cuàchi xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vàchi anima nèhivì ñuhú cuàchi‑ne, te sàhà ñà‑ñùhámà ini‑nè, ñà‑yùcàndùá quìdá stná‑nè cuàhà ñà‑có‑ndiàá; vàchi nacání quini ini‑nè, te ò cáhàn‑nè xì nècuàchì cónì nándàhà xì‑né, te ò dava‑ne, uun‑ni ndoó‑né xì ndé ni nèhivì ní cui; te dava‑ne, sahní stnahá‑né, ");
INSERT INTO mitNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ò xidá cuíhná‑nê; te xího stná‑nè ñà‑ìcúmí ñanìtnaha‑ne; quini quidá stná‑nè xì ñanìtnaha‑ne, te dandahví stnàhá stná‑nè; tùha quini stná‑nè, te có‑cùcáhán núù‑né; te cuàhà‑né, cúmbìdia stnahá stná ini‑nè, te cáhàn quini‑ne dìquì ñanìtnaha‑ne; cuadú stná‑nè, te nacání ndévàha ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pues ducán quidá‑né, vàchi ñuhú nsidaájàn ini anima‑nè, te na quidá‑néà, dandu dacuidá cuàcha‑nè ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Dandu nì quee Jesús ladu yucán cuàhàn‑yà ladu ñuu Tiro xì ñuu Sidón. Te yucán nì sàà‑yà visita iin vehe, doco có‑cùní‑yà cundaà ini nèhivì ñà‑ìá‑yà yucán; doco mànìcùí coo dèhé‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Vàchi vichi vichi nì xinitnùhu iin nècuàchì ñahà inácáá iin ñà‑malu ini dèheyoco‑xí. Iin nècuàchì inga ñuu nduú‑né, iin ñuu nani Sirofenicia. Te na ní sàà‑nè ndé iá‑yà, nì sàcuììn sìsì‑né nùù‑yá, nì sacundahví‑nè nùù‑yá áma táva‑yá ñà‑malu anima dèhe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Doco nì cachi‑yà xì‑né: ―Dihna icúmí cutahvì dèhe (ñuu nsiùhù, dandu después nèhivì inga ñuu), vàchi ducán iá na ian xixí ñà‑cuati. Dihna cuxi mii‑vé, te ndenuu ini‑vè, dandu después cuxi sìhina cuati. Vàchi mà váha cuxio dìtà‑vé, te cuxi‑sìá. ");
INSERT INTO mitNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Doco nì cachi tu nècuàchìmà xì‑yá: ―Ñà‑ndáà nduá, Señor. Doco cunaha‑ní, dècuèndè stná sìhina xicánúú tìxi mesa, níhì stná‑si iyuhu xèhè dìtà cóyo ndé xixí dèhe‑nda. (Ñàyùcàndùá, chindee sacu stná‑ní yùhù.) ");
INSERT INTO mitNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dandu nì cachi‑yà xì‑né: ―Vàtùni cachí‑nî. Ñàyùcàndùá, xuhun‑ní vehe‑ní, vàchi sànì quee ñà‑malu nùù dèhe‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Daaní, mànuhù nècuàchìmà vehe‑ne, te nì xini‑nè indúhu víi dèhe‑ne cama, vàchi sànì cuxio ñà‑malu nìsa dandoho‑xi‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Dandu nì quee Jesús ñuu Tiro mà, nì yàha‑ya ñuu Sidón, xì stná ladu Decápolis, te nì nasaa‑yà mar iá Galilea. ");
INSERT INTO mitNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Te nèhivì yucán, nì saca‑ne iin nècuàchì dòhò có‑câhàn viì stná, te nì casaà‑nè nùù‑yá, nì sacundahví‑nè ñà‑nì chìndánuú‑yá ndahà‑yá dìnì nècuàchìmà, te nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dandu nì tavà cuaán‑yá nècuàchìmà, te nì dàquíhvi‑ya dìnìndàhá‑yà ini tùtnù‑né. Te nì dàcóyo‑ya tèdìí‑yà dìnìndàhá‑yà nì chituu‑ya nùù yàá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dandu nì ndacoto ndiaá‑yà dìquì‑xí, te nì sàcàn ini‑yà, cachí‑yà xì tiàa ma dàhàn ñuu mà: ―¡Efata! ―ñà‑ndùá cuní cachà: Ni nuná tùtnù‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dandu nì nuna tùtnù‑né, te nì nduvàha stná yàá‑nè, vàtùni càhàn viì‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Te nì cachi‑yà xì nsidaa nèhivì ndoó yucán ñà‑màsà cáchí‑nè ni‑iñàha xi nèhivì, doco entre más cachí‑yà xì‑né ducán, vihi gá cuàhà nì sate tnùhu‑ne sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Te yáha ga nì ndulocó nsidaa nèhivì, cachí‑nè: ―Viì gá quidá‑yá nsidanicuú iñàha. Dècuèndè tèdòhò natiácú quidá‑yá, xì stná tè‑ìhìn dànácâhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Quìvì yucán nì nataca tu cuàhà sàstnùhù nèhivì, doco còò ni‑iñàha cuxi‑ne. Ñàyùcàndùá, nì cana Jesús nècuàchì dacuahá‑yá, te nì cachi‑yà xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Yùhù cuhí inì nèhivì yohó, vàchi sàcuàhàn‑ndà ùnì quìvì ndoó‑né cutnáhâ‑né xì‑ndà yohó, te còò cá ñà‑cuxi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te nú ni dánâcuîtiè‑nè nùhù‑nè vehe‑ne, vihini cuìtá‑nè ichì, vàchi có‑xìxí‑né, te xica ní caquixi dava‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dandu nì naxiconihí nècuàchì dacuahá‑yá nùù‑yá: ―Doco ¿índù nìhì‑ndà ñà‑dacuxi‑ndané? vàchi yucù nduá yohó. ");
INSERT INTO mitNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dandu nì xìcàn tnùhù‑yá nùù‑né: ―¿Nadaa pan nihí‑nsiá? ―Ùsà‑ñà iá ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dandu nì dàndàcú‑yá ni mácùndoo viì nsidaa nèhivì mà ñuhù. Te nì tnii‑ya ùsà pan mà, nì naquimanì‑yá Dios sàhá, te nì dàcuàchí‑yáñà. Dandu nì sàha‑ya nècuàchì dacuahá‑yá, te mii‑né, nì dasàn‑néà nùù nèhivì cuáhà mà. ");
INSERT INTO mitNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Te nì ìa stná iin ùì siaca cuati; ñàyùcàndùá nì naquimanì stná‑yà Dios sàhà‑sí, te nì cachi‑yà xì nècuàchìmà ñà‑dasàn stná‑nèsi nùù nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dandu nèhivì cuáhà mà, nì caxixi nsidaa‑né, te nì ndenuu ini‑nè. Te después, nì dàtàcá‑nè ñà‑ndùá nì cuyodò gá, te nì chitu ùsà canasta‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te nèhivì nì caxixi ma, nahi cùmì mil nì sanduu‑ne. Daaní, na sánì dànácuîtià‑yà nsidaa nèhivì mà, ");
INSERT INTO mitNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","dandu nì nana tu‑ya iin lancha xì nècuàchì dacuahá‑yá cuàhàn‑yà xì‑né ndè ladu ñuu Dalmanuta. ");
INSERT INTO mitNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Daaní, nì casaà nècuàchì fariseu nùù‑yá, te nì quesaha‑né cuáà‑nè xì‑yá, dasaá‑nèyà xícàn‑nè ñà‑quida‑ya iin milagru xi Dios cundehè‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dandu nì sàcàn cuàhà ini‑yà, te nì cachi‑yà xì‑né: ―Mii‑nsiá xì dava ga nècuàchì ñuu yohó, ¿índù chuun xícàn guá‑nsià quide iin milagru cundehè‑nsiá? Yùhù cachíˋ xì‑nsiá, mà sáà coo ni‑iin milagru cundehè‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dandu nì nacoo uun‑yanè, nì ndècahnu‑ya ini lancha inga xichi, te nì quihin‑ya ichì cuàhàn‑yà inga ladu mar. ");
INSERT INTO mitNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Cunaha‑nsiá, sànì nandòdó nècuàchì dacuahá‑yá cunihi ga‑nè pan cùhùn ini lancha mà. Cuisì iin‑nia nihí‑né cuàhàn. ");
INSERT INTO mitNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Dandu nì cachi‑yà xì‑né: ―Cundehè‑nsiá, cuidadu gà ni cúndóó‑nsiá sàhà tàtnà nsidátáchí xí pan xi nècuàchì fariseu xì stná Herodes. ");
INSERT INTO mitNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dandu nì quesaha‑né nì ndatnuhu‑né, cachí‑nè: ―Ádi ñá‑còò pan nihi‑nda vàxi, ñàyùcàndùá cachí‑yà xì‑ndà ducán ―cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sàhájàn na ní cundaà ini‑yà ñà‑ndùá ndatnúhú‑nê, dandu nì cachi‑yà xì‑né: ―Có‑xìñùhù ndatnuhu‑nsiá sàhà‑ñá còò pan nihí‑nsiá vàxi. ¿A có‑nsìnúú inì‑nsia (ñà‑ndùá nì xini‑nsià)? Yùhù xiníˋ tàñáha ga cundaà inì‑nsia. ¡Na cueé guâ sánìhì inì‑nsia! ");
INSERT INTO mitNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Iá nduchìnúù‑nsiá, ñàyùcàndùá xiñuhu cundehè‑nsiá. Te iá stná tùtnù‑nsiá; xiñuhu cunini‑nsia. ¿A có‑nsìnúú inì‑nsia nansa nì cuu daa? ");
INSERT INTO mitNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na ní dasín ùhùn pan, te nì xixi ùhùn mil tiàa, ¿nadaa ga ìcà pedazu pan nì ndòo nì dàtàcá‑nsià? ―Ùxìn ùìà ―cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Dandu nì cachi tu‑ya: ―Na ní dasín ùsà pan nì caxixi cùmì mil nèhivì, ¿nadaa ìcà pedazu pan nì dàtàcá‑nsià? ―Ùsà ―cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dandu nì cachi tu‑ya xì‑né: ―¿A táñâha ga mànìhì inì‑nsia? ");
INSERT INTO mitNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Dandu nì sàà‑yà xì‑né ñuu Betsaida, te nèhivì ndoó yucán, ndacá‑né iin nècuàchì cuaá nì quesaa nùù‑yá, sacúndáhvî‑nè ñà‑nì chítúú‑yá ndahà‑yá nùù‑né, te ni ndúvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ñàyùcàndùá, nì tnii‑ya ndahà nècuàchìmà, te nì tavà‑yánè fuera ñuu tii ma. Dandu nì dàcùchí‑yà tèdìí‑yà nduchìnúù‑né, te nì chituu‑ya ndahà‑yá ndé cuhí nùù‑né. Dandu nì ndàcàtnùhù‑yá nùù‑né, a sánì natùinuù‑né, á coó. ");
INSERT INTO mitNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dandu nì ndacoto‑ne, te nì cachi‑nè: ―Vàtùni indéhí nèhivì, xicánúú‑né, doco na iá yutnù, ducán ndáa‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dandu, nì nachituu‑ya ndahà‑yá nduchìnúù‑né, te nì indehè nsìí‑né. Te momentu yucán nì nduvàha nduchìnúù‑né, te nì natùi nina. ");
INSERT INTO mitNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dandu nì cachi‑yà xì nècuàchìmà ñà‑nì núhù‑nè vehe‑ne, doco màsà yáha‑ne ñuu tii ma, ni màsà cáchí‑nè xì nèhivì ndoó yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Daaní, cuàhàn‑yà xì nècuàchì dacuahá‑yá ndè ñuu cuati ndoó yatni ñuu Cesarea de Filipo. Te na cuáhàn‑nè ichì, dandu nì xìcàn tnùhù‑yá nùù‑né, cachí‑yà: ―¿Ana nduú yùhù, cachí nèhivì? ");
INSERT INTO mitNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Te nì cachi‑nè xì‑yá: ―Dava‑ne cachí‑nè Juan Bautista nduu‑ní. Te dava‑ne cachí‑nè Elías nduu‑ní, te dava ga‑nè cachí‑nè ñà‑ndùù‑ní nahi profeta sànaha. ");
INSERT INTO mitNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dandu nì cachi‑yà xì‑né: ―Doco mii‑nsiá, ¿ana nduí cachí‑nsià? Dandu nì cachi Pedro: ―Divi Cristu (nì quixi dìquì‑xí) nduu‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dandu nì sàcùnaha nsidaa nècuàchì dacuahá‑yá mà ñà‑màsà cáchí‑nè xì nèhivì dava ga ni‑iin palabra mà. ");
INSERT INTO mitNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dandu nì dàtúi‑ya nùù‑né nansa icúmí cuu xi‑yá después. Nì cachi‑yà xì‑né ñà‑mii‑yá ana nduú Tnaha Nèhivì Ñuhìví, icúmí‑yâ ndoho cuahà‑yá. Vàchi tè‑sàhnú xídandacú, xì stná dùtù xícusahnú, xì stná nècuàchì ley xi veheñùhu, nsidaa‑né icúmí‑nê cahíchì ini‑nèyà, dandu (càcàn‑nè) cahnì nèhivì‑yá. Doco tìxi ùnì quìvì icúmí‑yâ natiacu‑yà, ");
INSERT INTO mitNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","nì cachi‑yà, cáhàn vate‑yá xì‑né ducán. Ñàyùcàndùá, nì tavà cuaán Pedro‑yà, nì cachi‑nè xì‑yá ñà‑màsà cáchí‑yà ducán. ");
INSERT INTO mitNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Doco nì nacuico‑yá ladu yàtà‑yá, nì indehè‑yá dava ga nècuàchì dacuahá‑yá, te nì càhàn duchi ini‑yà xì Pedro, cachí‑yà: ―Cuxio‑ní nùí, vàchi nahi ñà‑malu Satanás nduu‑ní. Có‑nìhnú vàha inì‑ní Dios. Cuisì chuun xi nèhivì ñuhìví nihnú inì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dandu nì cana‑ya nècuàchì dacuahá‑yá xì dava ga nèhivì ndoó yucán, te nì cachi‑yà xì‑né: ―Nsidaa ana cuní cunchicùn xìˊ, xiñuhu nacoo‑ne ñà‑ndùá cuní inì‑ni mii‑né quida‑ne, te cunchicùn‑nè yùhù, quida‑ne cuenta na ian nsidá stná‑nè cruz xi‑ne ñà‑cui stná‑nè xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Vàchi nú cuní iin nèhivì dacácu‑ne vida xi‑ne, cutu ñà‑dandáñúhú‑nêàmà cundua. Doco nú ni cuí‑nè sàhà yùhù ò sàhà razón ndiaha xí, dandu ñà‑sànì càcu ndisa vida xi‑ne nduá. ");
INSERT INTO mitNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Vàchi mate ni níhì iin nèhivì nsidaa ñà‑ìá ñuhìví, doco ni mà sáà‑mà cundua ñà‑vàha xi‑ne nú màsà sáà stná anima‑nè càcua nùù Dios. Còó, mà cúí. ");
INSERT INTO mitNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Te ò nú ni cuní stná iin nèhivì nacuiin‑ne anima‑nè, còó, mà cúí. ");
INSERT INTO mitNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Vàchi nèhivì tiempu vichi, nacóó‑né Dios, te xidá cuàchi‑ne. Ñàyùcàndùá, iin nècuàchì iá mahì nèhivì malu ndoó vichi, te cucáhán nûù‑né yàha‑ne ladu xi, te ò cucáhán nûù‑né cunini‑ne palabra xi, ndahví‑nè, vachi nú ducán, dandu yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmí stnáì nacuaìˊ mii‑né quìvì naxicocuíìn. Vàchi icúmî naxicocuíìn ñuhìví yohó, cutnahí xì ángel ìì‑xí quixi, te ndiaha gá icúmî nanchiìˊ quida Yuamánìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Dandu nì cachi stná‑yà xì‑né: ―Palabra ndàcuisì nduá yohó cachítnùhi xì‑nsiá, ñà‑dava mii‑nsiá nècuàchì itá yohó, antes cui‑nsià icúmí‑nsiâ cuni‑nsià cusahnú fuerte Dios xì poder xi‑ya ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Daaní, nì yàha ìñù quìvì, dandu nì saca‑ya Pedro, xì Jacobo, xì Juan, cuàhàn cuaán‑yá xì‑né ndè dìnì iin yucù ducún, te yucán nì nadama‑ya mii‑yá; tucu nì nàcùnahà‑yà nì xini nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nì nducuxín yaa sìcoto xi‑ya, te nì nanchiì yéhà. Na cuxín yaa ñà‑ndùú yùhà (dìnì yucù), ducán nì nducuxán. Còò ni‑iin nèhivì ñuhìví cui nsida cuxín xán ducán. ");
INSERT INTO mitNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Daaní, yucán nì ndecoyo stná nèhivì (sànaha) nani Elías xì Moisés, ndatnúhú‑nê xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dandu nì cachi Pedro xì‑yá: ―Maestro, ¡nansicáhán‑ndá ndoo‑nda yohó! Chicá vàha quida vàha‑nsi ùnì siahva, ian coo mii‑ní, te inga coo Moisés yohó, te inga coo stná Elías yohó ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Doco ñà‑yáha guá yúhî nsidaa‑né, ñàyùcàndùá ni cónì cúndáà ini Pedro nansa cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Daaní, nì nuu iin vìcò yucán, te nì dàhvi nsidaa‑né vìcò mà. Dandu nì tiacu‑nè cáhàn iin ana cáhàn mahìá, cachí‑yà: ―Dèhemanìˊ nduú ana yohó. Cunini‑nsia ñà‑ndùá cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Daaní, nì ndacoto nècuàchì dacuahá‑yá, doco na iin cachí còò cá iin ni xiní‑nè, ndé làcà mii‑yá iá yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Daaní, nì naquihin‑ya ichì mànuu‑ya xì‑né yucù yucán. Te ichì mà nì dàndàcú‑yá nùù‑né, cachí‑yà: ―Màsà nácání‑nsiá xì nèhivì ñà‑ndùá nì xinì‑nsia dècuèndè nú sànì natiacu yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ñàyùcàndùá, nì chivàha nècuàchìmà chuun jaàn ini anima‑nè, doco nacání cuáhà ini‑nè nansa coo ñà‑natiacu‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dandu nì xìcàn tnùhù‑né nùù‑yá, cachí‑nè: ―¿Índù chuun cachí nècuàchì ley xi veheñùhu ñà‑dihna icúmí Elías naxicocuíìn‑nè? ");
INSERT INTO mitNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dandu nì cachi‑yà xì‑né: ―Ñà‑ndáà nduá, dihna icúmí Elías naxicocuíìn‑nè, te nsida viì‑né nsidaa chuun có‑ìá viì. Doco ¿nansa cachí stná tutu ìì sàhà yùhù? Pues nacáníámà nansa icúmî ndohi xì nansa icúmí nèhivì cahíchì ini‑nè yùhù. ");
INSERT INTO mitNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Doco cunaha‑nsiá, sànì quixi Elías mà. Doco nèhivì, nì quida ndevàha‑ne xì nècuàchìmà nacua nì cudiì ini‑nè, vàchi ducán sànì cachitnùhu tutu ìì. ");
INSERT INTO mitNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Dandu nì nasaa‑yà xì compañeru‑yà ndé nì ndòo dava ga nècuàchì dacuahá‑yá. Te yucán nì xini‑yà ndoó cuàhà nèhivì sànì nataca nùù nècuàchìmà. Te ndoó stná nècuàchì ley xi veheñùhu, náâ tnahá‑né xì nèhivì xí‑yá mà. ");
INSERT INTO mitNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Te na ní xini nèhivì cuáhà mà mii‑yá, luegu nì ndulocó nsidaa‑né, te nì cadayáà‑nè vàxi‑ne, nì casàhú‑nè xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dandu nì ndàcàtnùhù‑yá nùù‑né: ―¿Ndíà ndatnúhú guâ‑nsià xì nècuàchì yohó? ");
INSERT INTO mitNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dandu nì càhàn iin ana iín mahì nèhivì cuáhà mà, cachí‑nè: ―Maestro, yohó ndaquí dèhi vàxi nùù‑ní, vàchi inácáá iin ñà‑malu inì‑te, te sadíà nùù‑té, mà cùì cáhàn‑te. ");
INSERT INTO mitNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Te ndéni nì cui iá‑te, vàxa sahní iháˋ‑te, ducánˋ‑te, dandu queé chìhìñù yuhù‑té, saxíndiaá tnahá nùhu‑tè, te nduyútnú tehe‑té. Te sànì xìcàn tàhví nùù nècuàchì dacuaha‑ní ñà‑tavà‑néà, doco mànìcùí. ");
INSERT INTO mitNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dandu nì cachi Jesús: ―Mii‑nsiá, mà túha‑nsia cunindisá‑nsiá. ¿Nadaa ga quìvì icúmî coi xì‑nsiá, te quidandee gá stná inì sàhà‑nsiá? Pues cundaca‑nsiàte quixi nùí. ");
INSERT INTO mitNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dandu nì saca‑ne tèchii ma vàxi nùù‑yá. Doco na ní xini ñà‑malu mà mii‑yá, luegu nì sahnì ìháˋ‑te, ñàyùcàndùá nì sàcasàn‑té, natúì nìhní‑te, te caná chìhìñù yuhù‑té. ");
INSERT INTO mitNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Dandu nì xìcàn tnùhù‑yá nùù yua‑té, cachí‑yà: ―¿Nadaa tiempu sàcuàhàn‑ndà ndohó‑te ducán? Dandu cachí yua‑té: ―Ndè tii‑té. ");
INSERT INTO mitNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Te cuàhà xichi nduá‑te mahì ñuhu quidá ñà‑malu. Ndè stná ini yùte sácasàn‑té, vàchi cuníà cahnìá‑te. Ñàyùcàndùá, nú vàtùni chindee‑ní nsiùhù, dandu cundehè ndahví‑nî nsiùhù, te quida manì‑ní xì‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Dandu nì cachi Jesús xì‑né: ―Cuisì cuníà cunindisa‑ní, te vàtùni. Vàchi iin nècuàchì xiníndísâ, vàtùni nìhìtáhvì‑né nsidaa ñà‑vàha xícàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dandu luegu nì sacu yua‑té, te nì càhàn fuerte‑nè, cachí‑nè: ―Yùhù, xiníndísê vichi; te nú cô‑sâì cunindisá vàhi, dandu chindee‑ní yùhù ñà‑nì cúníndísâ guéˋ. ");
INSERT INTO mitNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dandu nì xini Jesús ñà‑vihi gá cuàhà nèhivì natácá. Ñàyùcàndùá, nì dàndàcú‑yá nì sadi‑yà nùù ñà‑malu mà, cachí‑yà: ―Yohó ñà‑malu quidá quini xi téchii yohó ñà‑mà cùì cáhàn‑te, te có‑tiàcú‑te, nacoo dahuun‑tè, te màsà náxícócuîìn gò nansìhvu inì‑te. ");
INSERT INTO mitNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dandu yáha ga ndee ní ndàhìà, nì dàndácùcháˋ‑te, te nì quea cuàhàn. Doco nahi ana nì xìhì nì ndòo‑tè. Ñàyùcàndùá, cuàhà nèhivì nì cachi‑nè: ―Sànì xìhì dahuun‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Doco nì tnii‑ya ndahà‑té nì dìtá‑yà, te nì dàndácuíín‑yàte. ");
INSERT INTO mitNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Daaní, nì quìhvi cuaán‑yá xì nècuàchì dacuahá‑yá ini iin vehe, te yucán nì xìcàn tnùhù‑né nùù‑yá, cachí‑nè: ―¿Índù chuun mànìcùí tavà nsiùhù ñà‑malu mà (nùù‑te)? ");
INSERT INTO mitNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Dandu nì cachi‑yà xì‑né: ―Mànìcùí, vàchi ñà‑malu tnaha quisì mà, có‑quèá nansa ni nì cui, cuisì nú ni cácàn tàhvì‑nsiá nùù Dios, te cunihiì stná‑nsià cundoo dòcó‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dandu ndacá‑yá nècuàchì dacuahá‑yá cuàhàn‑yà xì‑né ndè ladu Galilea. Doco cuàhàn dèhé‑yà, vàchi có‑cùní‑yà cundaà ini nèhivì índù xìcánúú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Te tiempu mà chináhá stná‑yà nècuàchì dacuahá‑yá mà (sàhà nansa icúmí‑yâ cui‑yà), te dohó nì cachi‑yà xì‑né: ―Yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî yàhi ndahà nèhivì (malu), vàchi iá iin tiàa icúmí quida xí entregar ñà‑cahnì nèhivì yùhù; doco tìxi ùnì quìvì icúmî natiacuì. ");
INSERT INTO mitNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pues divi nduá nì cachi‑yà, doco cónì sáà nècuàchìmà mànìhì ini‑nè ñà‑ndùá cuní cachàmà. Te yúhî stná‑nè ndàcàtnùhù‑né nùù‑yá sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dandu nì sàà‑yà xì‑né ndè ñuu Capernaum. Te na iá‑yà ini iin vehe yucán, dandu nì xìcàn tnùhù‑yá nùù‑né, cachí‑yà: ―¿Ndíà ndùá ndácàtnùhù tnahá guâ‑nsià ichì vàxi‑nda? ");
INSERT INTO mitNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Doco dadí úún nì ndòo‑ne, vàchi ichì mà nì cuàà‑nè ndácàtnùhù tnahá‑né índù nècuàchì chicá ndiaá. ");
INSERT INTO mitNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ñàyùcàndùá, nì sàcòo‑ya, te nì cana‑ya nsì‑úxìn ùì‑nè, te nì cachi‑yà xì‑né: ―Iin ana cuní cunduu ana chicá ndiaá, xiñuhu cunihnu ini‑nè nduú‑né ana chicá có‑dàndàcú, te cunucuachi stná‑nè nùù nsidaa nècuàchì dava ga. ");
INSERT INTO mitNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dandu nì cana‑ya iin tètii nì chicani‑ya mahì nsidaa‑né, te nì numi nihni‑yàte, cachí‑yà xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nú sàhà yùhù quidáñúhú nèhivì iin tètii nahi tè‑yòhó, dandu davani queá na ian yùhù quidáñúhú‑nê. Te nú yùhù quidáñúhú‑nê, dandu iin‑ni quee stná ñà‑quìdáñúhú stná‑nè ana nì techuun‑xí vàxi. ");
INSERT INTO mitNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dandu nì cachi Juan xì‑yá: ―Maestro, nì xini‑nsì iin tiàa tavá xi ñà‑malu nùù nèhivì, te ndácùcahan‑né quìvì mii‑ní. Doco có‑ndùú‑né iin ana cutnáhâ xí‑ndá xicánúú. Ñàyùcàndùá, nì sadi‑nsì nùù‑né ñà‑màsà quídá gá‑nè ducán. ");
INSERT INTO mitNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Doco nì cachì Jesús xì‑né: ―Còó, màsà cádí‑nsià nùù‑né, vàchi iin nècuàchì ndácùcahan xi quìvìˊ, te quidá‑né milagru ducán, ùhì càhàn quini stná‑nè dìquí. ");
INSERT INTO mitNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Vàchi nsidaa ana có‑xìní ùhì xì‑ndà, favor xi‑nda iá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Te nú ináhá nèhivì nduú‑nsiá nèhivì xí, te sàhámà quidá víi‑né xì‑nsiá, dandu seguru icúmí‑nê nìhì‑né ñà‑vàha xi‑ne nùù Dios, mate iyuhu tècuìí‑ni nduá nì sàha‑nensià nì xihi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Dandu nì cachi tu Jesús: ―Iin ñà‑cuati xiníndísá‑xî, nú ni dátûcù nèhivì‑ñá, dandu ¡ndahví‑nè! Vàchi chicá vàha màcùndiacu iin yùù yódò dùcùn‑né, te ndiachi‑né mahì mar sàhà‑ñá màsà dátûcù gà‑nè ñà‑cuati. ");
INSERT INTO mitNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Te nú sàhà ndahà‑nsiá xidá cuàchi‑nsia, dandu chicá vàha ni táhndèà. Vachi chicá nsiaha (sàà‑nsià nùù Dios) xì iin‑ni ndahà‑nsiá, te cutiacu‑nsià nicanicuahàn, te màdìá coo ndúìà, te ndiachi‑nsiá andea, vàchi yucán, mà cúí ndàhvà ñuhu. ");
INSERT INTO mitNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Te sìcùdì ñuhú yucán, mà nunca cuì‑si, te ñuhu yucán, mà sáà ndàhvà. ");
INSERT INTO mitNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te nú sàhà sáhà‑nsiá xidá cuàchi‑nsia, dandu chicá vàha ni táhndè stná, vàchi chicá nsiaha (sàà‑nsià nùù Dios) xì iin‑ni sàhà‑nsiá, te cutiacu‑nsià nicanicuahàn, te màdìá coo ndúìà, te ndiachi‑nsiá andea, vàchi yucán, mà cúí ndàhvà ñuhu. ");
INSERT INTO mitNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Te sìcùdì ñuhú yucán, mà nunca cuì‑si, te ñuhu yucán, mà sáà ndàhvà. ");
INSERT INTO mitNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te nú sàhà nduchìnúù‑nsiá xidá cuàchi‑nsia, dandu chicá vàha ni tavá‑nsiáñà. Vàchi chicá nsiaha sàà‑nsià xì imindaa nùù‑nsiá, te màdìá coo ndúìà, te ndiachi‑nsiá andea. ");
INSERT INTO mitNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Vàchi sìcùdì ñuhú yucán, mà nunca cuì‑si, te ñuhu yucán, mà sáà ndàhvà. ");
INSERT INTO mitNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Nsidanicuú nèhivì, icúmí‑nê (yàha‑ne tnùndoho) na ian nsíì yadi‑né yoho te yucán; (doco bien xi‑ne cunduamà, na ian nduhádì comida) ñà‑quéa ììn. ");
INSERT INTO mitNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Vàha ga ììn, vàchi nsidá ádìá ñà‑xìxì‑ndà; doco nú sànì ndañuhu ñà‑ádì xán, dandu mà cúí gá nduhadìá. Te na ian quidá ììn (iá vàha), ducán xiñuhu quida stná mii‑nsiá xì anima‑nsià, te cundoo mànì stná‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Dandu nì quee Jesús ñuu yucán, cuàhàn‑yà ladu Judea, divi iin ladu Judea iá ndè inga ladu yùte Jordán. Te yucán nì nataca tu cuàhà gá nèhivì nùù‑yá. Te nì quesaha‑yá dacuahá‑yánè nacua quidá‑yá siempre. ");
INSERT INTO mitNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Te yucán nì casaà stná nècuàchì fariseu, te nì càhàn‑nè xì‑yá áma níhìndèè‑né coo nansa daquée cuàchi‑ne dìquì‑yá. Te dohó nì cachi‑nè xì‑yá: ―¿A vátùni iá ñà‑cate stnàhà‑ndà xì ñahàdìhí‑ndà? ");
INSERT INTO mitNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dandu nì cachi‑yà xì‑né: ―¿Ndíà ndùá nì dàndàcú Moisés quida‑nsia? ");
INSERT INTO mitNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Te nì cacachi nècuàchì yucán: ―Nì sàha Moisés lugar ñà‑cuyucun iin tutu nùù juez, dandu vàtùni cate stnàhà‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dandu nì cachi‑yà xì‑né: ―Cunaha‑nsiá, cuisì sàhà ñá‑cô‑cùní‑nsià cunini viì‑nsiá, ñàyùcàndùá nì tiaa Moisés ley jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Doco na ní sàcòo ñuhìví, còó. Vàchi na ní quidayucun Dios ñuhìví, dandu nì quidayucun stná‑yà nèhivì, iin‑ne nì sàcùnduu tiàa, te inga‑nè ñahà. ");
INSERT INTO mitNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ñà‑jaàn nduá dìsáhà‑xí nándàhà iin nècuàchì tiàa xi iin nècuàchì ñahà, te quecuáân‑né nùù yuadíhí‑nê. ");
INSERT INTO mitNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ñàyùcàndùá, mate diín diín nì sanduu‑ne antes, doco na imindaa nèhivì sànì nanduu‑ne vitni. Te sàhámà, có‑ndùú gá‑nè diín diín nèhivì; quida‑nda cuenta na ian iin‑ni nèhivì nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ñàyùcàndùá, nú ducán sànì dàcuàcá stnahá Dios‑nè, dandu ni‑iin nèhivì màsà cáté stnàhá‑né ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Daaní, na sánì nansìhvi‑ya ini vehe, dandu nì ndàcàtnùhù gá nècuàchì dacuahá‑yá nùù‑yá sàhà chuun jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Te nì cachi‑yà xì‑né: ―Nú ni caté iin tiàa ñahàdìhí‑nè, te coo‑ne xì inga nècuàchì ñahà, dandu cuàchi ndisa nduá nùù Dios, te cuàchi nduú stná nùù ñahàdìhí‑nè primeru. ");
INSERT INTO mitNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Stná nècuàchì ñahà, nú ni caté‑nè iì‑né, te nandàhà tú‑né xì inga tiàa, cuàchi nduú stná. ");
INSERT INTO mitNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Daaní, ndacá nèhivì ñà‑cuati xí‑né vàxi nùù‑yá ñà‑chitàndòó‑yá ndahà‑yá dìnìá. Doco nècuàchì dacuahá‑yá, nì sadi‑nè nùù nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te na ní xini‑yà ñà‑ndùá quidá‑né, nì cuduchi ini‑yà, cachí‑yà: ―Nacoo‑nsia ñà‑cuati ni quixá nùí. Màsà cádí‑nsià nùá, vàchi ana nihnú inì‑xi nahi ñà‑cuati, divi cunduu ana sàà ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Te yùhù cachíˋ xì‑nsiá, nú màsà cóó (vìtá ini nèhivì) nahi ñà‑cuati, te ducán quìhvi‑ne ichì ñuhìví ìì xí mii‑yá, dandu mà nunca sàà‑nè yucán ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dandu nì numi nihni‑yañà, nì chitàndòó‑yá ndahà‑yá dìnìá, te nì xìcàn tàhvì‑yá ñà‑ndiaha nùù Dios sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Daaní, na lácà nì quihin Jesús ichì cuàhàn‑yà, dandu nì xini‑yà yucán vàxi iin tèchii carrera. Te na ní quesaà‑te nùù‑yá, nì sàcuììn sìsì‑té, cachí‑te: ―Maestro, vàha ndisa‑ní. Cachì‑ní xìˊ ndíà ndùá quide, te nìhìtáhvìˊ vida ndiaha nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Dandu nì cachi‑yà xì‑né: ―¿Ndíà nduá dìsáhà‑xí cachí‑nî xìˊ: “Mii‑ní vàha‑ní”? Vàchi còò ni‑iin nèhivì ùún vàha ndisa, cuisì nú nduí Dios, dandu vàha ndise. ");
INSERT INTO mitNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pues vichi, ináhá‑nî nansa nì dàndàcú‑yá quida‑nda: màsà cáhni stnaha‑nda, ni màsà cáhàn‑ndà xí inga ana có‑ndùú nècuàchì vehe‑nda, te màsà quídá cuihna‑nda, ni màsà cáchí‑ndà ni‑iin tnùhu sàhà ñanìtnaha‑nda; te màsà dándáhvî stnàhà‑ndà. Te icúmí stnâ‑ndà quidañuhu‑nda yuadíhí‑ndá. ");
INSERT INTO mitNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dandu nì cachi tu tèmà xì‑yá: ―Maestro, nsidaájàn sànì chivàhià dècuèndè na tií. ");
INSERT INTO mitNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dandu mànì mánì nì indehè‑yáte, vàchi cuú ini‑yà sàhà‑té, te nì cachi‑yà: ―Cumánì gá inga iñàha quida‑ní. Dicò nsìhì‑ní ñà‑ndùá icúmí‑nî, te dasàn‑ní dìhùn mà nùù nècuàchì ndahví, dandísá, nìhìtáhvì‑ní sàà‑ní ansivi, te yucán cucumi ndisa‑ní cuàhà ñà‑cuìcà. Dandu quixi stná‑ní, cunchicùn‑ní yùhù; te dispuestu coo‑ní cuì‑ní sàhí, mate ni cuí‑nî nchìca cruz. ");
INSERT INTO mitNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Doco tèchii ma, na ní inini‑tè ñà‑ndùá nì cachi‑yà, nì ndulocó‑te, te nì cuhuun cuahà inì‑te, vàchi yáha ga cuìcà‑té. Ñàyùcàndùá, nì quihin‑tè ichì cuàhàn‑te. ");
INSERT INTO mitNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dandu Jesús, nì xiconúù‑yá nùù nècuàchì dacuahá‑yá, te nì cachi‑yà xì‑né: ―¡Na ùhì guá sàà iin tècuìcà ndè ñuhìví ìì xí Dios! ");
INSERT INTO mitNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Doco na ní inini nècuàchìmà, yáha ga nì ndulocó‑nè. Ñàyùcàndùá, inga xichi nì càhàn‑yà xì‑né, cachí‑yà: ―Hijos, na ùhì guá nìhìtáhvì iin nècuàchì càhvì xì ñà‑cuìcà‑xí yàha‑ne ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ñà‑ndáà nduá, ùhì dayáha‑nda iin camellu nùù chìcòhò nduhù iquì; doco chicá ùhì yàha iin tècuìcà ndè ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na ní inini nècuàchì dacuahá‑yá ñà‑jaàn, dandu yáha ga nì ndulocó‑nè, te nì cachi‑nè iin‑ne xì inga‑nè: ―Pues nú ducán, ¿nansa cui càcu anima iin nèhivì? ");
INSERT INTO mitNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dandu nì indehè váha‑yanè, te nì cachi‑yà: ―Nèhivì ñuhìví, mà cúí quida‑neàmà. Doco Dios, vàtùni, vàchi nsidaa iñàha, mà úhì quida‑yañà. ");
INSERT INTO mitNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dandu nì cachi Pedro xì‑yá: ―Nsiùhù, sànì nacoo‑nsi nsidaa ñà‑ìcúmí‑nsî, te vàxi‑nsi nchícùn‑nsì mii‑ní, Stoho‑nsì Senór. ");
INSERT INTO mitNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Dandu nì cachi Jesús xì‑né: ―Yùhù cachíˋ xì‑nsiá, nú sàhà yùhù icúmí iin nèhivì nacoo‑ne iñàha, dandu iin cientu gà tantu icúmí‑nê nìhìtáhvì‑né. Mate icúmí‑nê nacoo‑ne vehe‑ne, ò ñani‑nè, ò cúha‑ne, ò yua‑né, ò dihi‑né, ò ñahàdìhí‑nè, ò déhe‑ne, ò ñuhù xí‑né sàhà yùhù, ò sáhà razón ndiaha, có‑quìdá, vàchi iin cientu gà tantu ñà‑jaàn nìhìtáhvì‑né mientras iá‑nè ñuhìví yohó, mate icúmí‑nê ndoho stná‑nè quida nèhivì ñuhìví. Doco na sáà‑nè inga ñuhìví vàxi xi‑nda, dandu nìhì stná‑nè vida ndiaha nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Doco cuàhà nèhivì idónuu vichi, icúmí‑nê sàà‑nè natenchicùn‑nè cahà‑xí quìvì yucán; te cuàhà ana nchícùn cahà‑xí vichi, icúmí‑nê sàà‑nè nàcòdònùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Daaní, ndacá Jesús nècuàchì dacuahá‑yá cuàhàn‑yà xì‑né ichì mànana ndè ñuu Jerusalén, te idónuu‑yá nùù‑né. Doco mii‑né, yáha ga nacání ini‑nè, te yúhî‑nè. Dandu nì tavà cuàán‑yá nsì‑úxìn ùì‑nè, te nì nacani‑ya xì‑né ñà‑ndùá sà‑ìtúú cuu xi‑yá, ");
INSERT INTO mitNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","cachí‑yà xì‑né: ―Cunaha‑nsiá, icúmí‑ndá sàà‑ndà ñuu Jerusalén. Te yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî yàhi ndahà dùtù xícusahnú yucán, xì ndahà stná nècuàchì ley xi veheñùhu. Te icúmí nècuàchìmà cachi‑nè ñà‑fuerza icúmî cuì. Dandu dayáha‑ne yùhù ndahà tè‑inga raza. ");
INSERT INTO mitNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Te mii‑té, cuàcùndiaà‑te yùhù, te cahnì cuìí‑te yùhù; te sivi dìí‑te nùí, dandu después cahnì‑té yùhù. Doco tìxi ùnì quìvì icúmî natiacuì ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Daaní, nì tnàtuu dèhe Zebedeo nani Jacobo xì Juan nùù‑yá, cachí‑nè xì‑yá: ―Maestro, cuní‑nsì quidamanì‑ní xì‑nsí iin favor ñà‑ndùá xícàn‑nsì. ");
INSERT INTO mitNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dandu nì cachi‑yà: ―¿Índù iñàha cuní‑nsià quide? ");
INSERT INTO mitNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Te nì cachi‑nè xì‑yá: ―Na sáà tiempu ndiaha na cusáhnú‑nî, cuàha‑ní lugar ñà‑cundoo iin iin‑nsi iin iin ladu‑ní; iin‑nsi coo ladu cuàhá‑nî, te inga‑nsì coo ladu ìtní‑nî. ");
INSERT INTO mitNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Dandu nì cachi‑yà xì‑né: ―Mii‑nsiá, có‑sánìhì ini‑nsià ñà‑ndùá xícàn tàhvì‑nsiá nùí. ¿A vátùni cundee ini‑nsià ndoho‑nsia nacua icúmî ndohi, te yàha stná‑nsià tnùndoho nacua icúmî yàhi? ");
INSERT INTO mitNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","―Jaan ―nì cachi‑nè―, vàtùni stná nsiùhù. Dandu nì cachi‑yà xì‑né: ―Ndisa, icúmí‑nsiâ ndoho‑nsia nahi yùhù; te icúmí stnâ‑nsià yàha‑nsia tnùndoho nahi yùhù. ");
INSERT INTO mitNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Doco ñà‑daníhìtáhvìˊ mii‑nsiá cundoo iin iin‑nsia iin iin ladúì, mà cúí, vàchi có‑quìdá yùhù tocar quide ñà‑jaàn. Nècuàchì nìhìtáhvì cundoo ladúì, cuisì nèhivì señaladu cunduu‑ne, vàchi divi sàhà mii‑né icúmí lugar mà cuyucàn. ");
INSERT INTO mitNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Daaní, na ní xinitnùhu ùxìn gà nècuàchì dacuahá‑yá, dandu nì cuduchi gá ini‑nè sàhà Jacobo xì Juan mà. ");
INSERT INTO mitNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Doco Jesús, nì cana‑ya nsidaa‑né ñà‑nì nátácá‑nè nùù‑yá, te nì cachi‑yà xì‑né: ―Ináhá‑nsiâ sàhà tè‑cùsàhnú inga ñuu, xínduu‑tè autoridad cahan néhivì, te fuerte cusáhnû‑te nùù‑né. Vàchi nsidaa tè‑nìhí chuun ñuu yucán, ndee dandacú‑te nùù nèhivì yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Doco mii‑nsiá, màsà quídá‑nsiá ducán. Còó, vàchi nú iá ana cuní cunduu ana dandacú nùù‑nsiá, dandu icúmí‑nê cunduu‑ne ana xinúcuáchí nùù nsidaa‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Vàchi nècuàchì cuní codònùù nùù‑nsiá, icúmí‑nê cunduu‑ne nahi peón chindéé xí nèhivì dava ga. ");
INSERT INTO mitNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Dècuèndè stná yùhù ana nduú Tnaha Nèhivì Ñuhìví, cónì quésáì ñuhìví yohó ñà‑cunucuachi néhivì nùí. Còó, sàhà‑ñá cunucuachi mií nùù‑né nì quesaì, dandu después cuàhi vida xi cuì cuenta xi‑ne, te ducán nàcùndoo cuàhà‑né libre ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Daaní, nì sàà‑yà xì compañeru‑yà iin ñuu nani Jericó. Te na xicá‑yá ichì queé‑yá ñuu mà, dandu nchícùn stná cuàhà gá nèhivì. Te yuhù ìchí yucán iá iin nècuàchì cuaá xícàn caridad. Bartimeo nani‑né, vàchi dèhe Timeo nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Te nì tiacu‑nè sà‑cùyátní Jesús de Nazaret. Ñàyùcàndùá nì quesaha‑né ndáhì‑nè, cachí‑nè: ―¡Jesús! ¡Mii‑ní descendencia ìì xí David! ¡Cuhi inì‑ní yùhù! ");
INSERT INTO mitNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Doco cuàhà nèhivì cuàhàn yucán, nì canàhá‑nè xì nècuàchìmà: ―Màsà ndáhì gà‑ní ―cachí‑nè. Doco nècuàchì cuaá mà, chicá ndee ní ndàhì‑nè, cachí‑nè: ―¡Jesús! ¡Mii‑ní descendencia ìì xí David! ¡Cuhi inì‑ní yùhù! ");
INSERT INTO mitNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dandu nì cucuiìn‑yà, te nì cachi‑yà xì compañeru‑yà: ―Cana‑nsianè ni quixí‑né. Dandu nì cana‑ne nècuàchì cuaá mà, cachí‑nè xì nècuàchìmà: ―Màsà cúhúún inì‑ní; ndacuiìn‑ní, vàchi caná‑yá mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ñàyùcàndùá, nì tavà‑né dòò‑né, nì dàndiàchì‑né iladú. Te yàchì nì ndacuiin‑nè cuàhàn‑nè ndé iá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Dandu nì xìcàn tnùhù‑yá nùù‑né, cachí‑yà: ―¿Ndíà nduá cuní‑nî quide? Te nì cachi‑nè xì‑yá: ―Cuníˋ natùinuí, maestro. ");
INSERT INTO mitNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dandu nì cachi‑yà xì‑né: ―Cuahán cuéyàà‑ní, vàchi sànì nduvàha‑ní ñà‑nì xinindisa‑ní. Dandu luegu nì natùinuù‑né, te nì tenchicùn stná‑nèyà ichì cuàhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Daaní, nì sàà‑yà xì‑né yatni ñuu Jerusalén ndé nduú ñuu cuati nani Betfagé xì Betania, yatni dìnì yucù Olivo. Dandu nì càhàn‑yà xì úì nècuàchì dacuahá‑yá ñà‑cùhùn cuèé‑nè nùù‑xí. ");
INSERT INTO mitNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Te dohó nì cachi‑yà xì‑né: ―Cuahán‑nsià ñuu tii chicá nùù‑xí; te yucán icúmí‑nsiâ cuni‑nsià ndé iín iin burru nuhní. Quisì tàñáha ga cuida nduú‑si. Quisì yucán ndaxin‑nsiá cundaca‑nsiàsi quixi. ");
INSERT INTO mitNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te nú ndácàtnùhù nèhivì nùù‑nsiá índù chuun ndaxin‑nsiási, dandu cachi‑nsià xì‑né ñà‑Stoho‑ndà Señor xiñuhu xì‑sí, doco luegu naxicocuíìn‑si ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Daaní, luegu nì quihin ùì nècuàchìmà ichì cuàhàn‑nè, te nì xini‑nè yucán iín burru nì cachi‑yà, nuhní‑si yuhù ìchí yatni yehè iin vehe. Ñàyùcàndùá nì ndaxin‑nési. ");
INSERT INTO mitNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Doco dava nècuàchì itá yucán, nì cachi‑nè: ―¿Índù chuun ndaxin‑nsiá burru jaàn? ");
INSERT INTO mitNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dandu nì naxiconihí nècuàchìmà nacua nì cachi‑yà xì‑né. Dandu nì sàha nèhivì mà permisu ñà‑cundaca‑nèsi cùhùn. ");
INSERT INTO mitNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ñàyùcàndùá luegu nì saca‑nèsi cuàhàn‑nè ndé iá‑yà, te nì chitàndòó‑né sìcoto xi‑ne dìquì‑sí. Dandu nì sàcùnùú‑yàsi. ");
INSERT INTO mitNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Te cuàhà nècuàchì yucán, nì chitànduhù‑né dòò‑né ichì nacua cuàhàn yàha‑ya. Te dava‑ne, nì sahnde‑nè ndahà yutnù nì chindoo stná‑nè ichì. ");
INSERT INTO mitNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Te nèhivì idónuu, xì stná nècuàchì nchícùn cahà‑xí, cánandee‑né, cachí‑nè: ―¡Viva ana sahnú yohó! ¡Ndiaha gá ndeníhí vàha‑ndané, vàchi cuenta xi Stoho‑ndà Señor vàxi‑ne! ");
INSERT INTO mitNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ndiaha gá coo, vàchi vàxi‑ne cunduu‑ne rey, cusahnú‑né na ian nìsa cusahnú xìì‑ndà David. ¡Ansivéhé mii‑yá iá ansivi! ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Cunaha‑nsiá, ducán nì sàà Jesús ñuu Jerusalén. Dandu cuàhàn‑yà veheñùhu cahnú, te nì xini‑yà nansa iá nsidaa iñàha yucán. Dandu nì quee‑ya ñuu mà cuàhàn‑yà xì úxìn ùì compañeru‑yà ndè ñuu tii Betania, vàchi sànì cuaà. ");
INSERT INTO mitNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Dandu dàtnàà inga quìvì nì quee‑ya xì‑né ñuu Betania mà vàxi‑ya. Te xíhì‑yà doco. ");
INSERT INTO mitNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Te nì xini xìcà‑yá iín iin yutnù nani nù‑higu, te iá ndahà cuìí‑nu. Ñàyùcàndùá, cuàhàn‑yà cundehè‑yá a có‑càá sì‑higu caxì‑yá. Doco na ní tnàtuu‑ya nì xini‑yà micuísi ndahà‑nú iá. Còò quisì vídì, vàchi tàñáha ga sàà tiempu cana‑sì. ");
INSERT INTO mitNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dandu nì cachi‑yà xì yutnù mà: ―Màsà nunca cana ga quisì vídì‑yó caxì nèhivì. Te nì inini stná nècuàchì dacuahá‑yá nì cachi‑yà ducán. ");
INSERT INTO mitNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nì nsihi ñà‑yùcán, dandu nì sàà‑yà xì nècuàchìmà ñuu Jerusalén. Dandu cuàhàn‑yà veheñùhu cahnú, te nì taxi nsihí‑yá tè‑dìcó xi tè‑xìín yucán. Nì naxiconihí‑yá mesa xi tiàa dama‑xi díhùn inga ñuu, te nì ducùn stná‑yà silla xi tè‑dìcó xi loma. ");
INSERT INTO mitNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Te cónì sáha stná‑yà lugar nacuico ni‑iin nèhivì carga xi‑ne yàha‑ne patiu veheñùhu cahnu‑ma. ");
INSERT INTO mitNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Te nì càhàn fuerte‑yà xì nèhivì yucán, cachí‑yà: ―Dohó cachí Dios nùù tutu ìì: “Veheñùhu xi cunduu iin vehe ndé nataca nèhivì vàxi nsidanicuú ñuu càcàn tàhvì‑né nùí”, cachí‑yà. Doco sàhà mii‑nsiá sànì nandua na iin lugar ndé ndoó cuàhà tècuìhnà. ");
INSERT INTO mitNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Doco dùtù xícusahnú, xì nècuàchì ley xi veheñùhu, iníní stná‑nè ñà‑ndùá nì cachi‑yà. Te vichi yúhî‑nèyà, vàchi ináhá‑nê ndulócô nsidaa nèhivì sàhà ñà‑ndùá dacuahá‑yá. Ñàyùcàndùá nì quesaha‑né nandúcú‑nê nansa cui cahnì‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Daaní, na ní cusinsiquin, dandu nì quee‑ya ñuu mà mànuhù‑yá (ñuu tii Betania). ");
INSERT INTO mitNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Daaní, dàtnàà inga quìvì vàxi tu‑ya xì nècuàchì dacuahá‑yá, te nì nayàha‑ne xì‑yá (ndé iín yutnù mà), te nì xini‑nè sànì ìchì dahuun‑nù ndè yohò‑nú. ");
INSERT INTO mitNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dandu nì nsinuu ini Pedro, te nì cachi‑nè xì‑yá: ―Cundehè‑ní, Maestro, yutnù nì càhàn xì‑ní, te nì sadì‑ní nùù‑xí icu, ¡sànì ìchì‑nu! ");
INSERT INTO mitNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Dandu nì cachi Jesús xì‑né: ―Xiñuhu cunindisá vàha‑nsia Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Vàchi palabra seguru nduá cachíˋ xì‑nsiá yohó: nsidaa nèhivì có‑ìá xì duda, dècuèndè vàtùni dandacú stná‑nè nùù yucù jaàn ñà‑cuxioa, te quècahnua ini mar, te divi ducán ndisa icúmí cuu, nú nihnú ndisa ini‑nè cuu nacua nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ñàyùcàndùá, yùhù cachíˋ xì‑nsiá, nsidaa iñàha ni cácàn tàhvì‑nsiá nùù Dios, nú xiníndísâ‑nsiá ñà‑sà‑ìá ñà‑ndùá nì xìcàn‑nsià, dandu nìhì‑nsiáñà. ");
INSERT INTO mitNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Doco dava xichi xícàn tàhvì‑nsiá nùù‑yá, te xiní ùhì‑nsià iin ñanìtnaha‑nsia. Nú ducán nduá, dandu dihna icúmí‑nsiâ cuicahnú stnahá ini‑nsià, dandu vàtùni cuicahnú stná ini Yuandiáhá‑nsiâ iá ansivi sàhà cuàchi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Vàchi nú có‑xìcáhnû ini‑nsià sàhà ñanìtnaha‑nsia, dandu mà cuícáhnû stná ini mii‑yá sàhà cuàchi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Daaní, nì sàà tu‑ya xì‑né ñuu Jerusalén. Te na xicánúú‑yá ini veheñùhu cahnú yucán, dandu yucán nì casaà stnà dùtù xícusahnú, xì nècuàchì ley xi veheñùhu, xì stná nècuàchì xídandacú nùù ñuu mà, nì tnàtuu‑ne nùù‑yá, ");
INSERT INTO mitNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","cachí‑nè: ―¿Índù nì nìhì‑ní derechu quida‑ní ñà‑ndùá quìdà‑ní? ¿Ana divi nì dàndàcú nùù‑ní ñà‑quida‑ní ducán? ");
INSERT INTO mitNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Te nì cachi‑yà xì‑né: ―Yùhù cuní stnáì ndàcàtnùhí nùù mii‑nsiá, te nú ni náxícóníhî‑nsiá nùí, dandu cachitnùhu stnáì xì‑nsiá ana divi nì dàndàcù‑xì núìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Cachi‑nsià xìˊ ana divi nì dàndàcù‑xì núù Juan (Bautista) ñà‑quida iì‑né nèhivì. ¿A Dios nì cachi xì‑né, te ò nèhivì ñuhìví? Naxiconihí‑nsiá nùí. ");
INSERT INTO mitNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dandu nècuàchìmà, nì candatnuhu tnahá nsidaa ní míí‑nê, cachí‑nè: ―Nú ni cachí‑ndà Dios nì dàndàcù‑xì núù Juan, dandu cachi Jesús xì‑ndà ¿índù chuun cónì xìníndísá‑ndá nècuàchìmà? ");
INSERT INTO mitNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te nú ni cachí‑ndà divi nèhivì ùún nì cachi xì‑né, (dandu ni mà quéé víi stná mà). Ducán nì cacachi nècuàchìmà, vàchi yúhî‑nè ndíà ndùá cachi nèhivì xì‑né, vàchi nsidaa nèhivì, quidá‑né cuenta iin nècuàchì yuhù núù Dios nì sanduu Juan. ");
INSERT INTO mitNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ñàyùcàndùá, nì cacachi nècuàchìmà xì‑yá: ―Có‑cùndáà ini‑nsì ana divi nì dàndàcù‑xì núù Juan. Dandu nì cachi Jesús xì‑né: ―Ni yùhù, mà cáchí stnáì xì‑nsiá ana divi nì dàndàcù‑xì núìˊ ñà‑quide ñà‑ndùá quidé. ");
INSERT INTO mitNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Daaní, nì quesaha Jesús nacání‑yá xì‑né puru ejemplu. Te dohó nì cachi‑yà xì‑né: ―Nì ìa iin lamú, nì dànándèe‑ne nducu yòhò sì‑uva nùù ñuhù xí‑né. Te nì quida‑ne corra‑ñà, xì stná iin pila cahnú ndé cuñuhu ndudi quisì mà; te nì quidavàha stná‑nè iin torre ndé cundiaa peón inii itu‑nè. Dandu nì tatu‑nè itnii medieru, te cuàhàn‑nè inga ñuu xìcà. ");
INSERT INTO mitNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Daaní, na sánì sàà tiempu cùchi quisì vídì mà, dandu nì techuún‑né iin peón xi‑ne nùhù naquihin chii fruta mà nùù medieru xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Doco na ní sàà peón mà, nì catnii medieru mà‑né, nì sahnì cuìí‑tené, te nì taxi‑ténê, còò ni‑iñàha nihí‑né nì násáá. ");
INSERT INTO mitNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Daaní, inga tu nì techuún lamú mà inga peón xi‑ne, doco divi‑ni nì cacani yuu‑ténê, ndè nì dànácuèhè‑te dìnì‑né, te nì canàhá‑te xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Daaní, tucutu nì techuún lamú mà inga peón nùù‑té. Doco tèmà, nì sahnì dahuun‑tèné. Dandu cuàhà gá xichi nì techuún lamú mà más gà peón nùù‑té. Doco divi ducán‑ní nì cuu, vàchi dava‑ne nì sahnì cuìí‑tené, te dava ga‑nè nì sahnì dahuun‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ndé làcà mindaa dèhemanì lamú mà ndóo ga. Ñàyùcàndùá último nì techuún stná‑nè dèhe‑ne cuàhàn, vàchi ádi quidañuhu‑té dèhe‑ne, nì cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Doco medieru mà, nì candatnuhu tnahá‑te, cachí‑te: “Tè‑yòhó nduú tè‑ìcúmí ndutahvì xì nsidaa ñuhù yohó. Vichi cahnì‑ndàté chicá vàha, dandu mii‑nda nanduu‑nda stohà”, nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ñàyùcàndùá nì catnii‑tè dèhe lamú mà, nì sahnì‑ténê, te nì dàcàná‑te nsìi ma yàtà corra. ");
INSERT INTO mitNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Pues vichi, ¿ndíà ndùá icúmí lamú mà quida‑ne xì medieru mà? Icúmí‑nê nùhù‑nè yucán, te cahnì nsìhí‑nète, dandu nanducu saa‑né inga ana quidachuún ñuhù xí‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Dandu nì cachi gà‑yà xì nèhivì mà: ―A táñâha ga cahvi‑nsia nùù tutu ìì xí Dios ndé cacháˋ palabra yohó: Nì ìa iin cavà, te nì cahíchì ini albañil‑ñà. Doco vichi sànì sàà mà nì sàcùndua yùù vìcò esquina vehe. ");
INSERT INTO mitNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Divi Stoho‑ndà Señor nduú ana nì quida ducán. Te ndulócô‑ndà ñà‑ndiaha guá nì quida‑ya. (Ducán nacání nùù tutu ìì, nì cachi Jesús.) ");
INSERT INTO mitNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Daaní, nècuàchì xícusahnú sàhà religión ñuu mà, nì cundaà ini‑nè divi mii‑né cáhàn‑yà sàhà‑xí na ní nacani‑ya ejemplu mà. Ñàyùcàndùá, nì cuni‑nè tnii‑neyà, te chicadi‑nèyà. Doco ñà‑yúhî‑nè nèhivì cuáhà yucán, ñàyùcàndùá, nì nacoo‑neyà, cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dandu nì techuún‑né iin ùì nècuàchì fariseu quixi xi iin ùì nècuàchì partidu xi rey Herodes, cuní‑nè dadaná‑néyà na cáhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ñàyùcàndùá, nì tnàtuu‑ne nùù‑yá, cachí‑nè xì‑yá: ―Maestro, ináhá‑nsî mii‑ní, ana ndàà cuisì inì‑xi nduu‑ní. Có‑quìhín casu‑ní nansa cachí nèhivì, ni có‑yûhî stná‑ní ni‑iin nèhivì, vàchi chináhá víi‑ní ñà‑ndùú ichì váha Dios. Cachì‑ní xì‑nsí: ¿A vátùni sáha Dios lugar ñà‑chiyàhvi‑nda renta nùù rey cahnú César, á coó? ¿A ndiá ìcà‑ndà chiyàhvi‑nda, á coó? ");
INSERT INTO mitNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Doco Jesús, sànì cundaà ini‑yà có‑xîcàn tnùhù sahnú ndisa‑ne nùù‑yá; ñàyùcàndùá, nì cachi‑yà: ―¿Índù chuun cuní‑nsià quida‑nsia maña nùí? Cunihi‑nsia iin dìhùn quixi, cundehíà nansa iáˋ. ");
INSERT INTO mitNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dandu na ní quesaa dìhùn plata mà, nì indehè‑yáñà, te nì cachi‑yà xì‑né: ―¿Bueno, ana dìnúù‑xí, te ana dìquívì‑xì itúú ìcà dìhùn yohó? Te nì cachi‑nè: ―Divi rey cahnú César. ");
INSERT INTO mitNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dandu nì cachi‑yà xì‑né: ―Nú ducán nduá, dandu nacuàha‑nsia César ñà‑ndùá icúmí‑nsiâ cuàha‑nsiàte, te cuàha stná‑nsià Dios ñà‑ndùá ndiá ìcà‑nsiá cuàha‑nsiayà ―nì cachi‑yà. Dandu nèhivì iníní, nì ndulocó‑nè ñà‑nchìchí guâ nì naxiconihí‑yá nùù nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Dandu nì catnàtuu itnii nècuàchì saduceu nùù‑yá nì càhàn‑nè xì‑yá. Nècuàchì yucán, có‑xìníndísâ‑né icúmí natiacu nsìi. Ñàyùcàndùá, dohó nì cachi‑nè xì‑yá: ");
INSERT INTO mitNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, ñà‑yòhó nduá nì tiaa Moisés quida‑nda: “Nú sànì xìhì iin tiàa, te còò déhe‑ne nì ndóo xi ñahàdìhí‑nè, dandu icúmí ñani nsìi ma nandàhà‑né xì ñahà mà, áma cóó iin dèhe‑ne; dandu quida‑nda cuenta na ian dèhe nsìi‑ma cunduu méè mà”. ");
INSERT INTO mitNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Cunaha‑ní, nì sandoo ùsà ñàní. Te nècuàchì chicá sahnú, nì nandàhà‑né xì iin nècuàchì ñahà, doco nì xìhì‑nè, te còò déhe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dandu ñani‑nè chicá nchícùn gà, nì nandàhà stná‑nè xì ñahà cuaán ma, doco nì xìhì stná nècuàchì úì mà, te còò stná dèhe‑ne. Te divi ducán nì cuu stná xì nècuàchì únì. ");
INSERT INTO mitNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dècuèndè nì sàà nsì‑úsà‑nè nì nandàhà iin iin‑ne xì ñahà mà, (te iin iin‑ne nì xìhì‑nè), doco còò ni‑iin dèhe‑ne nì ía (xi ñahà mà). Daaní, último nì xìhì stná nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ñàyùcàndùá, na sáà quìvì (cachí‑nsià) natiacu nsìi, ¿índù tiàa ma nacuaca xi nècuàchì ñahà mà? vàchi antes nsì‑úsà‑nè nìsa ìa xi‑ñá ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dandu nì cachi Jesús xì‑né: ―Còó, có‑càchí viì‑nsiá, vàchi có‑cùndáà inì‑nsia nansa cachí tutu ìì xí Dios, ni có‑cùndáà stná inì‑nsia ñà‑càhnù‑guá poder xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cunaha‑nsiá, na sáà quìvì natiacu nèhivì, mà nándàhà gá‑nè, vàchi nahi ángel ndoó ansivi icúmí‑nê nanduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Te vichi cuàhìn càhìn xì‑nsiá sàhà nansa iá ñà‑natiacu nsìi. Ádi sánì cahvi‑nsia nùù tutu nì tiaa Moisés ndé cacháˋ sàhà yutnù tii (xíxìn), te iá Dios mahì‑nú, te nì cachi‑yà xì Moisés: “Yùhù nduí Dios càhvì nsì‑Abraham, xì nsì‑Isaac, xì nsì‑Jacob”, cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","(Ñàyùcàndùá, itiácú ìì nècuàchì sànaha ma), vàchi nècuàchì ní xìhì dahuun ndisa, mà cúí cahvi‑né Dios, cuisì nèhivì itiácú càhvì xì‑yá. Ñàyùcàndùá, ni‑iyuhu có‑ìá viì ñà‑ndùá cachí mii‑nsiá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Daaní, iin nècuàchì ley xi veheñùhu, nì inini‑ne nansa nì ndatnuhu stnahá‑né, te nì cundaà ini‑nè yáha ga nì naxiconihí víi Jesús nùù nècuàchì yucán. Ñàyùcàndùá, chicá nì tnàtuu‑ne, te nì ndàcàtnùhù‑né nùù‑yá, cachí‑nè: ―Nùù nsidaa ñà‑ndùá nì dàndàcú Dios, ¿índù ñà‑chicá ndiaá? ");
INSERT INTO mitNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Dandu nì cachi‑yà xì‑né: ―Ñà‑dàndàcú Dios chicá ndiaá nduá yohó: “Cunini vàha‑nsia, nèhivì Israel, vàchi Stoho‑ndà Dios, imindaa‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Te icúmí‑ndá cuu ini‑ndà sàhà‑yá xì nsidanicuú anima‑ndà, xì nsidanicuú voluntad xi‑nda, xì nsidanicuú sàxìnítnùní‑ndà, te nsidanicuú stná valor xi‑nda”. Ñà‑jaàn nduá dandacú Dios chicá ndiaá chivàha nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Daaní, nacua cachí ley primeru mà, ducán cachí stná ley ùì dàndàcú‑yá: “Nacua cuú ini‑ndà sàhà mii‑nda, ducán icúmí stná‑ndà cuu ini‑ndà sàhà ñanìtnaha‑nda”. Còò cá ñà‑nì dàndàcú Dios chicá ndiaá nùù ùì ñà‑jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dandu nì cachi nècuàchì ley xi veheñùhu ma: ―Cachí vàha ndisa‑ní, maestro; ñà‑ndáà nduá, vàchi imindaa Dios iá, còò cá ana nduú Dios, cuisì mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te icúmí‑ndá cuu ini‑ndà sàhà‑yá xì nsidanicuú anima‑ndà, xì nsidanicuú sàxìnítnùní‑ndà, xì nsidaa voluntad xi‑nda, xì nsidaa stná valor xi‑nda; te icúmí stná‑ndà cuu ini‑ndà sàhà ñanìtnaha‑nda nacua cuú ini‑ndà sàhà mii‑nda. Vàchi ñà‑jaàn chicá ndiaá nùù nsidanicuú promesa cuàha‑ndayá, a sea nduá iin quisì coco nùù‑yá; te ò ndéni promesa nì cùí ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dandu Jesús, nì xini‑yà nì naxiconihí víi nècuàchìmà nùù‑yá; ñàyùcàndùá nì cachi‑yà xì‑né: ―Làcà iyuhu‑ni cumánì, te sàà‑ní cunduu‑ní iin nèhivì ñuhìví ìì xí Dios. Daaní, (na ní nsihi nì cachi‑yà ñà‑jaàn), dandu ni‑iin nèhivì, cónì sáha ndee gá ini‑nè dadavátnáhâ‑né xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Daaní, iin quìvì iá‑yà veheñùhu cahnú, dacuahá‑yá nèhivì, te nì cachi‑yà xì‑né: ―Cachí nècuàchì ley xi veheñùhu: “Descendencia xi xìì‑ndà David nduú Cristu”. Ducán cachí nècuàchìmà, doco ¿índùví cuní cachàmà? ");
INSERT INTO mitNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Vàchi divi xìì‑ndà David nì tiaa stná‑nè sàhà Cristu tìxi poder xi Espíritu Ìì xí Dios, te dohó nì cachi‑nè: Nì càhàn Yua‑nda Dios xì Stohì (divi Cristu), nì cachi‑yà: “Yohó coo‑ní ladu cuàhíˋ ndè cachi sàà cundeí nùù nsidaa tè‑xìní ùhì xì‑ní, dandu cusahnú fuerte‑ní nùù‑né”, nì cachi Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Cundehè‑nsiá, nì cachi David ñà‑Stoho‑nè nduú Cristu. Doco nú ducán nduú‑yá, dandu ¿índù modo cui cunduu stná‑yà iin descendencia xi‑ne? (Doco ñà‑ndáà nduá) ―nì cachì Jesús. Te nsidaa nèhivì cuáhà yucán, cudíì ini‑nè xì ñà‑ndùá cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Dandu nì dàcuàhá gá‑yà nèhivì, cachí‑yà: ―Còtó quida‑nsia na xíquida nècuàchì ley xi veheñùhu. Vàchi ñà‑diì xí‑né nduá cacanuu‑ne cundixi‑ne sìcoto quihín vico, te casàhú tnùñuhu nsidaa nèhivì xì‑né yàhvi. ");
INSERT INTO mitNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Te na sáhàn‑nè veheñùhu, ò ndoó‑né iin vicò, dandu nandúcú‑nê lugar ndé chicá ndiaha cundoo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Te tùha stná‑nè (tnii diqui‑né ley, te) xidándiáá stná‑nè vehe nècuàchì nì xìhì iì‑xí, dandu después sácuìta‑ne nacuátú cuáhà‑né na ian ndisa guá vàha‑ne. Sàháyùcàndùá, iin castigu chicá fuerte icúmí‑nê nìhì‑né ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iin xichi iá‑yà veheñùhu cahnú yatni ndé itá alcancía xi Dios, te indéhe‑yá nèhivì daquée‑ne dìhùn ini alcancía mà. Tècuìcà, cuàhà gá dìhùn nì dàquée‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dandu nì quixi stná iin nècuàchì ñahà ndahví nì xìhì iì‑xí; te nì dàquée‑ne ùì dìhùn cuàtì ndiaá nahi ùxìn centavu. ");
INSERT INTO mitNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ñàyùcàndùá, nì cana Jesús nècuàchì dacuahá‑yá nataca‑nè nùù‑yá, te nì cachi‑yà xì‑né: ―Cunaha‑nsiá, chicá más nduá nì sàha nècuàchì viuda ndahví yohó nùù ñà‑nì sàha nsidaa gá nèhivì yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Vàchi nsidaa gá‑nè, cuisì ñà‑cùyódo nùù‑né nduá nì sàha‑ne. Doco nècuàchì ñahà yohó, mate ndahví dahuun‑ne, doco nì sàha‑ne nsidanicuú dìhùn sàhà ñà‑cuiin‑ne ñà‑cutiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Daaní, na ní quee‑ya veheñùhu cahnú, dandu nì cachi iin nècuàchì dacuahá‑yá xì‑yá: ―Cundehè‑ní, Maestro. ¡Na vico guá iá yùù nahnú nì cuàha veheñùhu yohó, te na cuaha guá ndáa stná vehe yohó! ");
INSERT INTO mitNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Doco nì naxiconihí Jesús nùù‑né: ―¿A xiní‑nsià vehe nahnú yohó? Cunaha‑nsiá, vàxi iin quìvì, dandu ni mà códotnahá gá ni‑iin yùù yohó, vàchi icúmíâ caà nsìhá quida nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Daaní, cuàhàn cuaán‑yá xì‑né ndè yucù Olivo iá frente veheñùhu cahnú, te yucán nì sàcòo‑ya. Te na ndoó‑né xì‑yá yucán, dandu nì càhàn ùnì‑nè xì‑yá, divi Pedro, xì Jacobo, xì Juan, nì ndàcàtnùhù‑né nùù‑yá, cachí‑nè: ");
INSERT INTO mitNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Cachì‑ní xì‑nsí índù quìvì cuu nsidaa ñà‑nì cachì‑ní jaàn. ¿Índù milagru coo ñà‑cundaà ini‑nsì ñà‑sà‑ìtúú quìvì cuu nsidaájàn? ");
INSERT INTO mitNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dandu nì cachi‑yà xì‑né: ―Cuidadu cundoo‑nsia ñà‑màsà dándáhvî ni‑iin nèhivì mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vàchi cuàhà ana icúmí quixi danani úún‑né nduú‑né yùhù, te cachi iin iin‑ne xì nèhivì ñà‑Cristu nduú‑né. Te sàhájàn cuàhà nèhivì nìhì‑né dandahví‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Doco mii‑nsiá, na cunitnùhu‑nsia iá cuàhà guerra yoho te yucán, màsà yúhî‑nsià, vàchi fuerza icúmí coo ducán. Doco tàñáha ga xìnu tiempu yohó nduájàn, iá gà ñà‑vàxi cuu. ");
INSERT INTO mitNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Daaní, ñuu xì ñuu, icúmíâ nàá stnahá. Vàchi cuàhà rey, icúmí‑tê dandacú‑te coo guerra xì inga ñuu. Te icúmí tnàa stná yoho te yucán ñuhìví, te coo stná tnama. Doco ñà‑làcà cuàhàn quesaha tnùndoho cunduamà. ");
INSERT INTO mitNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Doco mii‑nsiá, cundoo tùha‑nsia, vàchi icúmí nèhivì tnii‑ne mii‑nsiá cundaca‑nensià cùhùn nùù tè‑xícusahnú. Te icúmí‑nsiâ ñàhnì cuìí‑nsià ini veheñùhu. Te sàhà‑ñá càhvì‑nsiá yùhù, ñàyùcàndùá, icúmí‑nê datnátuu stná‑nè mii‑nsiá nùù gobernador xì nùù rey (ñà‑càhàn tnùhù‑né dìquì‑nsiá). Dandu ñà‑jaàn cunduu tiempu vàha cachi vate‑nsiá ñà‑ndùá xiníndísâ‑nsiá cunini‑temà. ");
INSERT INTO mitNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Te dècuèndè inicutu ñuhìví icúmí cuìtià stná razón ndiaha xí Dios, dandu después xìnu (tiempu yohó). ");
INSERT INTO mitNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Doco icúmí nèhivì canicuàchi‑ne sàhà‑nsiá, te cundaca‑nensià cùhùn nùù tè‑xícusahnú. Doco màsà nácání ini‑nsià ni‑iyuhu índù palabra naxiconihí‑nsiá nùù‑té. Còó, cuisì nacua dachítnùní ini Dios mii‑nsiá hora yucán, divi cachi‑nsià xì‑té. Vàchi màdì mii‑nsiá cunduu ana càhàn; còó, divi Espíritu Ìì xí Dios icúmí dacáhàn xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","’Doco dava nèhivì, dècuèndè ñani‑nè icúmí‑nê cahin‑nè nùù autoridad ñà‑cui nècuàchìmà. Te dava stná‑nè, dècuèndè dèhe‑ne cahin stná‑nè ñà‑cuià. Te dava stná‑nè, dècuèndè yuadíhí‑nê cuni ùhì‑nè, te canicuàchi stnahá‑né ñà‑cui‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Te mii‑nsiá, sàhà yùhù icúmí nsidaa nèhivì cuni ùhì‑nènsià. Doco nú iin‑ni cunihnu vàha inì‑nsia dècuèndè sàà xìnu tiempu, dandu càcu‑nsia nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Sànaha nì cachitnùhu Daniel iin palabra xi Dios sàhà nansa icúmí coo iin figura dana có‑xìñùhù dahuun‑ya. Cunaha‑nsiá, quìvì cuni‑nsià sànì sàcuììn figura mà iin xaan ndé còò permisu cuian, (dandu seña cundua). Te vichi xiñuhu cundaà ini nsidaa ana càhvì‑xì tutu yohó. Pues na sáà quìvì yucán, dandu ni cunúdèhé nsidaa nèhivì ndoó ladu Judea yohó cùhùn‑nè yucù. ");
INSERT INTO mitNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Te nú dìnìvèhé ndoó‑né (quetátú‑nè), dandu (yàchì ni nuú‑né cunudèhé stná‑nè), doco màsà nánsìhvi ga‑nè vehe nsiquihin‑ne ñà‑ndùá icúmí‑nê. ");
INSERT INTO mitNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te nú ndoó‑né nùù ìtú, dandu màsà nándúcú‑né ni cotón‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Te ¡ndahví nècuàchì ñahà cuhí cuàhàn tùinuù méè‑xi quìvì yucán! Te ¡ndahví stná nècuàchì icúmí xí méè chìchì! ");
INSERT INTO mitNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Te càcàn tàhvì stná‑nsià nùù Dios ñà‑màsà cúvìxin na sáà tiempu cunudèhé‑nsià mà. ");
INSERT INTO mitNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Vàchi yáha ga icúmí nèhivì ndoho‑ne quìvì yucán. Còò cá tnùndoho chicá cahnú ni ía ndè quìvì nì cuyucun ñuhìví xì ndé quìvì coamà. Ni quìvì después, mà sáà gà coo tnùndoho ndudava xán. ");
INSERT INTO mitNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te nú màsà cúndéhe ndahví Dios, dacúxíó yàchì‑yà tnùndoho ma, dandu ndùtù nsìhí nèhivì ñuhìví nì cùí. Doco sàhà nèhivì sànì nacàxin‑ya, ñàyùcàndùá sànì chitnùní ini‑yà ñà‑chicá yàchì dacúxíó‑yá tnùndoho. ");
INSERT INTO mitNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Quìvì yucán màsà cúníndísâ‑nsiá yuhù nèhivì cachí xì‑nsiá: “Cundehè‑nsiá, yohó iá ana nduú Cristu”, te ò: “Yucán iá‑yà”. ");
INSERT INTO mitNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Vàchi icúmí quixi cuàhà tètnùhù, te iin iin‑tè cachì‑te ñà‑divi Cristu nduú‑te. Te icúmí quixi cuàhà stná ana danani úún càhàn cuenta xi Dios. Ndè quida stná‑te cuàhà milagru sàhà‑ñá ndulocó nèhivì, áma níhì stná‑te dandahví‑te nèhivì nì nacàxin‑ya cahan‑té, doco mà cúí. ");
INSERT INTO mitNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ñàyùcàndùá, mii‑nsiá, cundoo tùha‑nsia, vàchi sànì cachitnùhi xì‑nsiá nsidaa ñà‑ndùá icúmí cuu. ");
INSERT INTO mitNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Nú sànì yàha tiempu tnùndoho quìvì yucán, dandu mà cúnchíi gá ni orá ni yoo. ");
INSERT INTO mitNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Te sìnsìví itándiáá ansivi, icúmí‑sî còyo nihni‑sì nùù ñuhìví. Te sìtnúù nahnú, icúmí stnâ‑si ndacùchí ndee‑sí. ");
INSERT INTO mitNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dandu natùi yùhù ana nduú Tnaha Nèhivì Ñuhìví, cundehè nèhivì ñuhìví yùhù sàmànui mahì vìcò xì poder cahnú xí. Te ndiaha gá coo inicutu ndé mànui. ");
INSERT INTO mitNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dandu luegu icúmî techuín ángel xi cùhùn‑nè inicutu ñuhìví ñà‑danátácá‑nè ana nduú nèhivì sànì nacàxin, mate ndoó‑né iin xaan ndé vihi gá xica ñuhìví xì ansivi, doco icúmí‑nê nataca‑nè quixi‑ne quida ángel xi. ");
INSERT INTO mitNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Vichi cuàhìn nacani xì‑nsiá iin ejemplu sàhà nù‑higu sàhà ñà‑cundaà inì‑nsia iñàha. Nú sànì ndunsidi‑nú nì quesaha naná dìtù yuté‑nu, dandu ñà‑yùcán cundáà ini‑ndà sà‑ìtúú tiempu ihni. ");
INSERT INTO mitNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pues ducání stná xì mii‑nsiá; quìvì cuni‑nsià cuú ñà‑ndùá sànì cachì xì‑nsiá, dandu vàtùni cundaà stná inì‑nsia ñà‑sànì cuyatni tiempu naxicocuíìn nduá; sà‑ìtúú nihni. ");
INSERT INTO mitNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Te mà sáà cui nsihi nèhivì itiácú vichi dècuèndè cachi sànì cuu ndisa nsidaa ñà‑ndùá sànì cachì xì‑nsiá vichi. ");
INSERT INTO mitNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cunaha‑nsiá, icúmí sàà ansivi xì ñuhìví ndañuhá, doco palabra xi, còó, mà nunca sàà ndañuhá. ");
INSERT INTO mitNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Doco ni quìvì, te ni hora naxicocuíìn, ni‑iin nèhivì có‑ìnáhá‑nê, ni ángel ndoó ansivi, có‑ìnáhá stnâ‑nè. Ni stná yùhù ana nduú Dèhemanì Dios, có‑ìnáhá stnâì; cuisì Yuamánìˊ nduú ana ináhá. ");
INSERT INTO mitNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ñàyùcàndùá, cundoo tùha‑nsia, te cunihnu vàha ini‑nsià, vàchi có‑ìnáhá‑nsiâ índù hora divi cuu nsidaájàn. ");
INSERT INTO mitNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ducán iá na ian quidá iin lamú na cuyúcún‑nè cùhùn xìcà‑né, dandacú‑né nùù mozo xi‑ne sàhà biene xi‑ne. Iin iin mozo mà, nihí‑te chuun quida‑tè. Te mozo ndiaá yehè, ndacú núù stná‑te ñà‑cundiaa tùha‑tè yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pues divi ducán stná mii‑nsiá, xiñuhu cundoo tùha‑nsia, vàchi có‑ìnáhá‑nsiâ índù hora divi naxicocuíìn yùhù ana nduú Lamú xi‑nsia, sea cuñaà, ò dava ñùu, ò sinduhá cundua, te ò naha. ");
INSERT INTO mitNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Vàchi nanàá icúmî naxicocuíìn, ñàyùcàndùá còtó (nandòdó‑nsiá ñà‑jaàn), te na ian quídì‑nsià cundua. ");
INSERT INTO mitNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ñàyùcàndùá, yùhù cachíˋ xì‑nsiá nacua cachíˋ xì nsidaa nèhivì xí, ni cúndóó tùha‑nsia ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Daaní, cumánì gá ùì quìvì cunduu vicò pascua xì stná vicò xixí‑né pan có‑ndùtáchí. Te dùtù xícusahnú, xì nècuàchì ley xi veheñùhu, nì nanducu‑né nansa tnii dèhé‑nè Jesús ñà‑cui‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Doco nì cachi‑nè: ―Còó, màdì mahì vicò (quida‑nda ducán), vàchi te nú còó, vihini nacuidà nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iá‑yà vehe iin nècuàchì ñuu Betania nani Simón, iin nèhivì nì sandoho cuèhè lepra antes. Te iá‑yà xixí‑yá, te yucán nì sàà stná iin nècuàchì ñahà, nihí‑né iin quìdi iá dùcùn‑xí. Yùù nì cuyucàn mà, te ñuhá ndutè tnàmì finu nani nardo; te ndiaá sàstnùhù‑té. Dandu nì sàhnù nècuàchìmà dùcùn quìdi ma nì sòdò‑nète itnu dìnì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Doco dava nècuàchì xixí yucán, nì cuduchi gá ini‑nè, cachí‑nè iin‑ne xì inga‑nè: ―¿Índù chuun nì sate uun‑ne ndutè jaàn, te ndiaá guâ‑te? ");
INSERT INTO mitNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chicá vàha dicò‑néte ni cuí, te mà úhì quee iin ùnì cientu dìhùn plata dasàn‑ndà nùù nècuàchì ndahví. Ducán cachí‑nè, cánàhá‑nè xì nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Doco nì cachi Jesús xì nèhivì mà: ―Nacoo‑nsia nècuàchì jaàn. ¿Índù chuun cánàhá‑nsià xì‑né? Vàchi iin ñà‑vàha nduá sànì quida‑ne xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vàchi nècuàchì ndahví, nicanicuahàn ndoó‑né xì‑nsiá, te mà úhì chindee‑nsiánè nú cahan‑nsiá. Doco yùhù, còó, sacù‑ni quìvì iéˋ xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ñàyùcàndùá, nècuàchì ñahà yohó, ñà‑ndùá sáà‑nè quida‑ne, divi nduá sànì quida‑ne sàhí, na ian sànì quidatatna‑né cuerpu xi sàhà‑ñá cundùxan, ducán nduá. ");
INSERT INTO mitNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Te yùhù cachítnùhi xì‑nsiá, nsidanicuú ñuu ndé sàà razón ndiaha xí Dios inicutu ñuhìví, yucán icúmí sàà stná palabra sàhà ñà‑vàha nì quida nècuàchì ñahà yohó, te ducán mà nunca sàà nèhivì nandòdó‑né nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nùù ùxìn ùì compañeru Jesús, iin‑ne nani Judas Iscariote. Nècuàchì yohó, nì sàhàn‑nè nùù dùtù xícusahnú, nì ndatnuhu‑né xì nècuàchìmà ñà‑cahin‑nèyà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Te nì cacudiì ini nècuàchìmà na ní cundaà ini‑nè. Te nì saquin‑nè compromisu chiyàhvi‑ne. Ñàyùcàndùá, nì quesaha Judas mà nandúcú‑nê índù modo dayáha‑neyà ndahà nècuàchì yucán. ");
INSERT INTO mitNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Daaní, nì sàà tu quìvì primeru xi vicò xixí‑né pan có‑ndùtáchí. Te quìvì yucán xíhì stná lelù nduú promesa siempre sáha‑ne vicò pascua mà. Ñàyùcàndùá, nì cachi nècuàchì dacuahá‑yá xì‑yá: ―¿Índù divi cuní‑nî cùhùn‑nsì quidayucun‑nsì ñà‑cuxi‑ní comida vicò pascua? ");
INSERT INTO mitNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dandu nì dàndàcú‑yá nùù ùì compañeru‑yà, cachí‑yà: ―Cuahán‑nsià ini ñuu. Te yucán icúmí‑nsiâ ndacùhun tnahá‑nsiá xì iin tiàa idádocó xì iin yoo tècuìí. Nècuàchì yucán cunchicùn‑nsià cùhùn. ");
INSERT INTO mitNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Te divi vehe ndé quìhvi‑ne, yucán càhàn‑nsià xì nècuàchì dìvéhé‑xímá, cachi‑nsià xì‑né ñà‑dòhó cachí maestru: ¿Índù iá cuartu cahnú ndé cuxi‑ya comida pascua xì nècuàchì dacuahá‑yá? ");
INSERT INTO mitNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dandu icúmí nècuàchìmà dacuní‑nè mii‑nsiá índù iá iin vehe cahnú pisu dìquì‑xí ndé sà‑ìá nsidaa ñà‑ndùá xiñuhu. Yucán quidayucun‑nsià ñà‑cudiní‑nda. ");
INSERT INTO mitNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dandu nì quihin ùì nècuàchìmà ichì cuàhàn‑nè. Te nì sàà‑nè ini ñuu mà, te nacua nì cachi‑yà, ducán ndisa nì cuu. Ñàyùcàndùá divi yucán nì quidayucun‑nè comida pascua. ");
INSERT INTO mitNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Daaní, na ní cuñaà, dandu nì sàà stná‑yà xì nsì‑úxìn ùì nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Te na ndoó‑né xixí‑né, dandu nì cachi‑yà xì‑né: ―Cunaha‑nsiá, iá iin‑nsia cuàhàn cahin xìˊ. Te yohó iá‑nè xixí‑né xì‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dandu nì nàcùndoo nsidaa nècuàchìmà tnùnsí ini, te nì cachi iin iin‑ne xì‑yá: ―¿A víhíní yùhù? ―¿Te ò yùhù? ―cachí inga‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Dandu nì cachi‑yà xì‑né: ―Nùù nsì‑úxìn ùì‑nsià, iin‑nsia cuàhàn cahin xìˊ, mate iin‑ni xixí‑né xì‑ndà, te tavá stná‑nè pan nùù cazuela yohó. ");
INSERT INTO mitNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ñà‑ndáà nduá, icúmí cuu ndisa ñà‑nduàˊ nì cachitnùhu nùù tutu ìì ñà‑ìcúmí cui yùhù ana nduu Tnaha Nèhivì Ñuhìví. Doco tiàa cuàhàn cahin xìˊ, ¡ndahví‑nè! Chicá vàha màsà túinuù‑né ñuhìví nì cùí ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na meru xixí nsidaa‑né, nì tnii‑ya iin pan, te nì naquimanì‑yá Dios sàhà‑ñá, te nì dàcuàchí‑yáñà, nì dasàn‑yá nùù nècuàchì dacuahá‑yá mà, cachí‑yà: ―Tnii iin iin‑nsia pan yohó, vàchi nahi iquìcúñú yùhù nduá. ");
INSERT INTO mitNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dandu nì tnii stná‑yà pocillu, nì naquimanì stná‑yà Dios sàhà ñà‑ñùhú, te nì sàha‑ya nì caxihi nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Dandu nì cachi‑yà: ―Ndutè sì‑uva yohó, nahi nìí nduú‑te, vàchi divi sàhà nìí icúmî nacoi iin ichì sàà cunchicùn nèhivì nú sànì xìtià‑ñà sàhà cuàhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Doco cunaha‑nsiá, mà cóhó guéˋ ndutè sì‑uva yohó dècuèndè cachi sàà nacoho saa túì‑te quìvì sáà cusahnú Dios inicutu ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Daaní, nì xito nsidaa‑né alabanza, te nì quee‑ne cuàhàn‑nè xì‑yá ndè yucù Olivo. ");
INSERT INTO mitNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dandu nì cachi‑yà xì‑né: ―Ñuú vichi icúmí nsidaa‑nsiá nacoo nihni‑nsia yùhù, vàchi ducán cachí tutu ìì: “Cuàhìn dacúxíóé pastor, dandu icúmí riì cuìtià nihni‑sì”, cacháˋ. ");
INSERT INTO mitNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Doco nú sànì natiacuì, dandu icúmî codònùí nùù‑nsiá cùhùn ndè ladu Galilea. ");
INSERT INTO mitNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dandu nì cachi Pedro xì‑yá: ―Mate ni sáà nsidaa nèhivì nacoo nihni‑ne mii‑ní, doco yùhù, còó, mà nunca. ");
INSERT INTO mitNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dandu nì cachi‑yà xì‑né: ―Cunaha‑ní, divi ñuú vichi icúmí‑nî nacuaà‑ní yùhù. Tàñáha ga coto lehe ùì xichi sinduhá, te sànì nacuaà‑ní yùhù ùnì xichi. ");
INSERT INTO mitNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Doco Pedro, yáha ga ndee ní càhàn‑nè, cachí‑nè: ―Còó. Mate ni cahní‑nèndó, doco mà nunca sàì nacuaìˊ mii‑ní ―nì cachi‑nè. Te divi ducání nì cachi gà stná nsidaa nècuàchì dacuahá‑yá mà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Dandu nì sàà‑yà xì‑né iin xaan nani Getsemaní. Te nì cachi‑yà xì‑né: ―Mii‑nsiá, yohó ndòo‑nsia. Te yùhù, cùhìn chicá nùù‑xí càcàn tàhví nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dandu nì saca‑ya Pedro xì Jacobo xì Juan, cuàhàn‑yà xì‑né. Te nì sàcòo‑ya na ian yúhî‑yà, te nì quesaha‑yá yáha ga nacání cuáhà ini‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Te nì cachi‑yà xì‑né: ―Yáha ga iéˋ tnùnsí ini, na ian cuníà cahnì dahuan yùhù. Ñàyùcàndùá, yohó ni ndóo‑nsia, te cunchito tùha‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dandu cuàhàn‑yà chicá nùù‑xí, te nì sàcùnduhù ndèé‑yá nì xìcàn tàhvì‑yá nùù Dios, áma cui cuxio tnùndoho icúmí‑yâ yàha‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Te dohó nì cachi‑yà: ―Yuamánìˊ, nsidaa iñàha vàtùni quida‑ní. Ñàyùcàndùá, xícàn tàhví nùù‑ní áma cúxíó tnùndoho icúmî yàhi, vàchi na iin (ñà‑úà ñuhú iin) taza nduá nùí, te ùhì cohià. Doco màdì ñà‑ndùá cuní yùhù ni cúndúá, cuisì ñà‑ndùá cuní mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dandu vàxi tu‑ya ndé nì ndòo nècuàchì dacuahá‑yá, te nì xini‑yà xíquidì‑nè. Ñàyùcàndùá, nì cachi‑yà xì Pedro: ―Simón, ¿índù chuun quídì‑ní? ¿Áma cui cunchito‑ní ducán iin hora ni? ");
INSERT INTO mitNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Cundoo tùha‑nsia, te càcàn tàhvì‑nsiá nùù Dios sàhá màsà dándáhvî ñà‑malu mii‑nsiá, vàchi mate iá voluntad xi‑nsia, doco iyuhu gá valor icúmí cuerpu‑nsià ñà‑quidandee ínì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dandu nì sàhàn‑yà inga xichi, te divi ducán‑ní nì cachi tu‑ya xì Yua‑yá Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dandu vàxi tu‑ya, te nì xini‑yà tucutu quídì‑nè, vàchi sádì vàhná‑nè. Ni có‑nàníhì tnùní ini‑nè nansa naxiconihí‑né nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dandu tucu tu nì sàhàn‑yà ñà‑únì, te nì nsiaa tu‑ya nùù‑né, cachí‑yà: ―Cùdù cuéyàà‑nsià, te quetatu‑nsià vichi, vàchi sà‑ìá, sànì sàà hora xi yùhù ana nduú Tnaha Nèhivì Ñuhìví, divi hora icúmî yàhi ndahà nèhivì cuáchi. ");
INSERT INTO mitNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndacuìta‑nsia, cúhùn‑ndà, vàchi sà‑ìtúú quesaa ana nì cahin xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Daaní, na cáhàn ìì‑yá xì nècuàchìmà, dandu nì quesaa Judas, divi iin nècuàchì nùù ùxìn ùì nècuàchì dacuahá‑yá. Te ndacá stná‑nè cuàhà gá tiàa xínihi xi espada xì garroti. Cuenta xi dùtù xícusahnú vàxi‑tè, xì cuenta xi stná nècuàchì ley xi veheñùhu, xì stná nècuàchì xídandacú nùù ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Te sànì ndatnuhu Judas xì nsidaa tiàa xícutnahá xi‑né ñà‑coo iin seña ana tnii‑tè. Divi ana chìtú‑nè cunduu meru ana tnìì cúhùn presu. ");
INSERT INTO mitNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dandu na sánì quesaa‑nè, dandu vichi vichi nì tnàtuu‑ne nùù Jesús, cachí‑nè: ―¡Maestro, maestro! Dandu nì chìtú‑nè nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dandu compañeru‑nèmà, nì tnii‑tè Jesús, nì ndòo‑ya ndahà‑té. ");
INSERT INTO mitNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Doco iin nèhivì xí‑yá, nì tavà‑né espada xi‑ne, nì cani‑ne iin tiàa quidáchúûn nùù dùtù cusáhnû, nì sahnde‑nè iin tùtnù‑té. ");
INSERT INTO mitNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dandu nì cachi‑yà xì nsidaa nèhivì cuáhà mà: ―A ducán nduú modo tnií‑nsiá yùhù, vàxi‑nsia nihí‑nsiá espada xì garroti ñà‑tnii‑nsia yùhù, na ian tècuìhnà nduí, ");
INSERT INTO mitNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","mate nsìquívì nìsa ìe xì‑nsiá veheñùhu cahnú dacuahí nèhivì, doco cónì tnìí‑nsiá yùhù. Doco cunaha‑nsiá, dohó quidá‑nsiá xìˊ vichi sàhà‑ñá cuu ndisa ñà‑ndùá cachí nùù tutu ìì ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dandu nì nacoo nihni nsidaa nècuàchì dacuahá‑yá mii‑yá, nì xinudèhé‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Daaní, nchícùn stná iin tèchii ndixi‑xi iin dahmà. Te nì tnìì stná‑te. ");
INSERT INTO mitNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Doco nì ndòo sìcoto xi‑tè, te nì xinu‑tè cuáhàn‑te iá chaa‑té. ");
INSERT INTO mitNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Daaní, ndacá tiàa ma‑yá nì sàà dècuèndè ndé iá dùtù chicá cusáhnû. Te yucán sànì nataca nsidaa gá dùtù xícusahnú, xì stná nècuàchì sahnú xídandacú nùù ñuu mà, xì stná nècuàchì ley xi veheñùhu. ");
INSERT INTO mitNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Te Pedro, nchícùn xìcà ní‑né mii‑yá cuàhàn‑nè. Te nì yàha stná‑nè patiu xi vehe dùtù cusáhnúmá, te nì sàcòo stná‑nè xì policía ndoó nadáà nùù ñuhu. ");
INSERT INTO mitNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Daaní, dùtù xícusahnú, xì nsidaa Junta Càhnùmà, nì nducu‑né ana daquée cuàchi dìquì Jesús, (te cundua iin cuàchi pesadu) sàhà‑ñá cui‑yà. Doco còò iin ni túi càhàn ducán. ");
INSERT INTO mitNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vàchi cuàhà tètnùhù nì càhàn tnùhù dìquì‑yá, doco cónì ndúdává ñà‑ndùá nì cachi iin iin‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Vàchi dava‑tè, nì ndacuìta‑tè nì càhàn tnùhù‑té dìquì‑yá, cachí‑te: ");
INSERT INTO mitNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nècuàchì yohó, nì inini‑nsi nì cachi‑nè cuàhàn‑nè dacaá‑né veheñùhu nì quidavàha nèhivì (ñuu‑ndà). Dandu tìxi ùnì quìvì cuàhàn‑nè quidavàha saa‑né inga‑ñà, doco màdì xì ndahà nèhivì cuyucàn, cachí‑nè ―nì cachi tètnùhù mà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Doco ni ñà‑jaàn, cónì ndúdává xí ñà‑ndùá nì cachi ingà‑te. ");
INSERT INTO mitNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dandu nì ndacuiin dùtù cusáhnû, cachí‑nè xì‑yá: ―¿Áma náxícóníhí‑nî ni‑iñàha? ¿Nansa iá ñà‑càchí guâ nècuàchì yohó sàhà‑ní? ");
INSERT INTO mitNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Doco mii‑yá, dadí uun iín‑yá; còò ni‑iñàha ni cachí‑yà. Dandu tucutu nì càhàn dùtù mà, cachí‑nè: ―¿A divi Cristu Dèhemanì Yua‑nda Dios ndùù‑ní càhàn‑ní? ");
INSERT INTO mitNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dandu nì cachi‑yà xì nècuàchìmà: ―Jaan, divi nduí. Te icúmí‑nsiâ cuni‑nsià yùhù ana nduú Tnaha Nèhivì Ñuhìví na naxicocuíìn, iéˋ ladu cuahá mii‑yá cahnú poder‑xi mànui mahì vìcò cahnú ansivi. ");
INSERT INTO mitNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dandu dùtù cusáhnú má, (nì xìdà ini‑nè, ñàyucàndùá) nì ndata canúú‑nê iyuhu sìcoto ndixí‑né, te nì cachi‑nè xì nèhivì cuáhà mà: ―¡Có‑xìñùhù gá‑ndà ni‑iin ana quixi cunduu testigu! ");
INSERT INTO mitNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Vàchi vichi sànì inini‑nsia ñà‑quini guá nì càhàn nècuàchì yohó. ¿Nansa quida‑nda xi‑né, cachí mii‑nsiá? Dandu nsidaa‑né, nì cachi‑nè ñà‑ìcúmí‑yâ cui‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dandu nì caquesaha dava tiàa ma nì sivi dìí‑teyá, te nì chidàhvi stná‑te nùù‑yá, sahní cuìí‑teyá xì sìcàtú, cachí‑te: ―¡Cachi cuàá‑nî ana nì cani xi‑ní! Daaní, stná policía yucán, ndee ní cani‑ne nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Doco Pedro, tìxi‑xi iá‑nè patiu. Dandu nì quixi iin ñahà chìì quidáchúûn vehe dùtù mà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Te na ní xinìa Pedro iín‑né nadáà stná‑nè nùù ñuhu, dandu nì indehè váha‑ñà nùù‑né, te nì cacha xi‑né: ―¿Amádi mii‑ní nìsa cutnahá stná‑ní xì Jesús de Nazaret? ");
INSERT INTO mitNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Doco nì nacuaà‑né mii‑yá, cachí‑nè: ―Còó, tàcùníˋ nècuàchìmà, ni có‑cùndáà inì ñà‑ndùá cachú. Dandu nì quee‑ne cuàhàn‑nè corredor yucán. Te daa ní xito iin lehe. ");
INSERT INTO mitNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Te ñahà chìì mà, nì indehè tú‑ñané, te nì cachì‑ña xi nècuàchì itá yucán: ―Compañeru Jesús nduú stná nècuàchì jaàn. ");
INSERT INTO mitNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Doco divi‑ni nì nacuaà tú Pedro‑yà. Daaní, tìxi inga ratu gà, tucutu nì càhàn nècuàchì itá yucán xì‑né, cachí‑nè: ―Ndisa, iin compañeru nècuàchìmà nduu‑ní, vàchi nècuàchì ladu Galilea nduu‑ní, te nacua cáhàn nèhivì ladu yucán, ducán cáhàn stná‑ní. ");
INSERT INTO mitNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dandu nì cachi‑nè: ―Nú tètnùhù nduí, ni quixí castigu xi nùù Dios. Yùhù, chináhî Dios, tàcùníˋ nècuàchì cachí‑nsiàmà. ");
INSERT INTO mitNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dandu momentu yucán nì xito lehe ñà‑úì; te nì nsinuu ini Pedro nansa nì cachi Jesús xì‑né daa, ñà‑tàñáha ga coto lehe ùì xichi, te ùnì xichi sànì nacuaà‑né mii‑yá. Pues divi palabra mà (ní nsinuu ini‑nè), te na ní nacani ini‑nè sàhámà, nì quesaha‑né nì sacu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na ní tùinuù, dandu nì ndatnuhu dùtù xícusahnú xì tè‑cùsáhnû nùù ñuu mà, xì stná nècuàchì ley xi veheñùhu, xì nsidaa gá stná Junta Cahnú. Ñàyùcàndùá, nì nacuhni‑nè ndahà Jesús, cuàhàn‑nè xì‑yá nùù gobernador nani Pilatu, te yucán nì ndòo‑ya ndahà témà. ");
INSERT INTO mitNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Dandu nì xìcàn tnùhù‑té nùù‑yá, cachí‑te: ―¿A ndísá rey xi nècuàchì raza Judea nduu‑ní, á coó? ―Nacua cachí‑nî, divi ducán nduá ―cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dandu dùtù xícusahnú, cuàhà ní càhàn tnùhù‑né sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dandu nì ndàcàtnùhù Pilatu nùù‑yá inga xichi, cachí‑te: ―¿Áma náxícóníhí‑nî sàhà ñà‑cuàhà guá cáhàn‑nè dìquì‑ní? ");
INSERT INTO mitNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Doco Jesús, còò ni‑iñàha ni náxícóníhî‑yá. Ñàyùcàndùá, nì ndulocó Pilatu. ");
INSERT INTO mitNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cunaha‑nsiá, cada nacává vicò pascua mà, tùha gobernador mà daña‑té iin tè‑ndiàdí, ndéni‑te nì cui ndiadí cudíì ini nèhivì cuáhà. ");
INSERT INTO mitNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Te quìvì yucán ndoó itnii tiàa vehecàa. Vàchi nì casahàn‑te revolución dìquì gobiernu, te nì sahnì stnàhá‑te. Te iin tèmà nani Barrabás. ");
INSERT INTO mitNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ñàyùcàndùá nì caquixi tu nèhivì cuáhà mà nì quesaha‑né nì xìcàn‑nè nùù Pilatu ñà‑nì quìdá tú‑te ñà‑ndùú costumbre xi‑tè cada vicò mà. ");
INSERT INTO mitNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Te nì naxiconihí‑te nùù‑né, cachí‑te: ―¿A vátùni dañí Jesús yohó, divi nècuàchì cachí nduú rey xi nècuàchì raza‑nsià Judea? ");
INSERT INTO mitNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ducán nì cachì‑te xi‑né, vàchi ináhá‑tê ñà‑sàhà mbidiá xi dùtù xícusahnú, ñàyùcàndùá nì dàyáha‑ne Jesús ndahà‑té. ");
INSERT INTO mitNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Doco dùtù mà, nì chiyuhù‑né nèhivì cuáhà mà ñà‑nì cácàn‑nè dàñà Barrabás mà, te màdìá Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dandu nì càhàn tu Pilatu xì nèhivì mà, cachí‑te: ―¿Ndíà ndùá cuní‑nsià quide xì nècuàchì yohó? Vàchi rey xi mii‑nsiá nècuàchì raza Judea nduú‑né, cachí‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dandu ndee ní càna nsidaa nèhivì yucán, cachí‑nè: ―¡Ni cuí‑nè nchìca cruz! ");
INSERT INTO mitNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Dandu nì cachi tu Pilatu: ―¿Índù chuun cui‑nè ñà‑còò falta xi‑ne iá? Doco chicá ndee ní càna nèhivì mà, cachí‑nè: ―¡Ni cuí‑nè nchìca cruz! ");
INSERT INTO mitNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Te sàhà ñà‑cùní Pilatu ndòo vàha‑tè xì nèhivì mà, ñàyùcàndùá nì daña‑té Barrabás. Te nì dàndàcú‑te ñàhnì cuìí Jesús xì chirrión. Dandu nì dàndàcú stná‑te nùù soldadu xi‑tè ñà‑cundaca‑temàyá cùhùn chituu‑tèyá nchìca cruz. ");
INSERT INTO mitNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Doco primeru, nì casaca‑tèyá ndè patiu vehechuún, te nì cana‑tè nsidaa compañeru‑te ñà‑tnàtuu‑tè. ");
INSERT INTO mitNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dandu nì chindixi‑tèyá iin sìcoto moradu. Te nì cavà‑té iin corona iñù nì chicaà‑te dìnì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dandu nì sàcùndiaà‑teyá, cána‑tè, cachí‑te: ―¡Viva! ¡Ádi rey xi tè‑raza Judea nduu‑ní! ");
INSERT INTO mitNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Te nì cani fuerte‑te dìnì‑yá xì iin nù‑yòò. Dandu nì casivi dìí‑teyá, te nì sàcuìtasisi‑té nùù‑yá, na ian quidáñúhú‑têyâ. ");
INSERT INTO mitNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Daaní, na ní nsihi nì sàcùndiaà‑teyá ducán, dandu nì tavà‑té sìcoto moradu mà, te nì nachindixi‑tèyá sìcoto xi mii‑yá. Dandu nì saca‑tèyá cuàhàn‑te ñà‑chituu‑tèyá nchìca cruz. ");
INSERT INTO mitNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ichì yucán nì ndacùhun tnahá‑te xi iin tiàa nani Simón, màndixi‑ne nì sàhàn‑nè nùù ìtú. Iin nècuàchì ñuu Cirene nduú‑né, te yua Alejandro xì Rufo nduú stná‑nè. Te divi nècuàchìmà nì tnii soldadu, te nì dàcuìdá‑tené cruz xi Jesús cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dandu nì casaà‑te xi‑yá iin xaan nani Gólgota. Quìvì jaàn cachí dàhàn yucán, Nùù Iquìdìnì. ");
INSERT INTO mitNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dandu nì cunì‑te dacohó‑teyá vinu dácà xì iin dùsa tatna nani mirra, doco cónì cùní‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Daaní, nì chituu‑tèyá nchìca cruz. Te nì dasàn‑té sìcoto xi‑ya según nansa nì nìhì iin iin‑tè na ní idìquí‑te sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nahi cà‑íìn dàtnàà nduá nì chituu‑tèyá nchìca cruz mà. ");
INSERT INTO mitNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te yucán nì cachituu stná‑te iin ñà‑càchítnùhu índù‑ñá dìsáhà‑xí dandohó‑teyá. Te dohó cacháˋ: “Rey xi tè‑raza Judea”. ");
INSERT INTO mitNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Cunaha‑nsiá, yucán nì sàcùtundiaa stná ùì tècuìhnà nchìca cruz, iin‑tè ladu cuàhá‑yà, te ingà‑te ladu ìtní‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Te ducán nì cuu ndisa ñà‑ndùá nì cachitnùhu tutu ìì ndé cacháˋ: “Nì quida nèhivì cuenta na ian tiàa malu nduú‑yá”. ");
INSERT INTO mitNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dandu nèhivì yáha yucán, nì canàhá‑nè xì‑yá, dacuico dínì‑né, cahíchì ini‑nèyà, te ndacótó dana‑ne nùù‑yá, cachí‑nè: ―¡Ndahví‑nî! ¡Cuàhàn‑ní dacaa‑ní veheñùhu cahnú, te tìxi ùnì quìvì naquidavàha saa‑ní inga‑ñà cahan‑ní! ");
INSERT INTO mitNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pues nú ducán fuerte guá‑nî, dandu dacácu‑ní mii‑ní. Danuu‑ní mii‑ní nùù cruz cundehè‑nsí ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ndè stná dùtù xícusahnú, xì nècuàchì ley xi veheñùhu, divi‑ni ducán nì sàcùndiaa stná‑nèyà, cachí‑nè iin‑ne xì inga‑nè: ―Nècuàchì jaàn, nìsa dacácu‑ne nècuàchì dava ga, doco mà cùì dacácu‑ne mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Doco nú ndisa Cristu rey xi nècuàchì raza‑ndà Israel nduú‑né, dandu ni dánúû‑né mii‑né nùù cruz jaàn cundehè‑ndà, dandísá cunindisa‑ndané. Ducán nì cachi‑nè. Te dècuèndè stná tiàa itándiáá stná nchìca cruz yucán, nì canàhá stná‑te xi‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Daaní, càxíhúì xì ndé càhúnì, nì nàcuììn tnùù inicutu ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dandu càhúnì nì ndàhì ndee‑yá, cachí‑yà: ―Eloi, Eloi, ¿lama sabactani? ―te dohó cuní cachàmà: Dios mío, Dios mío, ¿a ñá‑sànì ndòo nihni nduá yohó? ");
INSERT INTO mitNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Te dava nècuàchì itá yucán, nì tiacu‑nè ndáhì‑yà ducán, ñàyùcàndùá nì cachi‑nè: ―Cunini‑nsia, caná‑né Elías. ");
INSERT INTO mitNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dandu nì dàyáà iin‑tè nì quihin‑tè iin ñà‑ñàhmá uun nani esponja, te nì chindaxin‑tèá xì vinu nì xìò, nì chihi‑tèá dìnì iin vara yutnù, te nì sàha‑tèyá nì sihvi‑yá, cachí‑te: ―Vichi nacoo‑ndané cundiatu‑nda, áma quíxí Elías nanihi xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dandu nì ndàhì ndee‑yá, te nì xìhì‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Daaní, yucán ini veheñùhu cahnú (ñuu mà) nì quedava ìì cortina cahnú (sadí nihni cuartu xan). Iin‑ni nì ndàtà‑ñá ndè dìnì‑xí xì ndé tìxi‑xi. ");
INSERT INTO mitNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te iín iin capitán nùù‑yá, te nì xinì‑te nansa nì ndàhì‑yà, te nì xìhì‑yà. Ñàyùcàndùá nì cachì‑te: ―Ñà‑ndáà nduá, Dèhemanì Dios nì sanduu nècuàchì yohó. ");
INSERT INTO mitNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Daaní, yucán itá xica stná itnii nècuàchì ñahà, indéhe stná‑nè (nansa cuú). Iin‑ne nduú María Magdalena, te inga‑nè nduú María dihi José xì Jacobo chii. Te inga‑nè nduú Salomé. ");
INSERT INTO mitNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nècuàchì ladu Galilea xínduu nsidaa nècuàchìmà, te na ní xìcanuu‑ya ladu yucán, nì cutnahá stná‑nè xì‑yá nì chindee‑néyà. Te vichi itá xica‑né, (indéhe‑ne), cutnáhâ‑né xì cuàhà gá stná nècuàchì ñahà nì quixi stná xì‑yá ndè ñuu Jerusalén. ");
INSERT INTO mitNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Te sàdaaní quècahnu orá quìvì yucán. Te quìvì mà nduú stná quìvì icúmí‑nê nsidayucun‑nè sàhà quìvì descansu cunduu inga quìvì mà. ");
INSERT INTO mitNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ñàyùcàndùá nì sàà stná iin nècuàchì ñuu tii Arimatea nani José, nì xìcàn‑nè cuerpu xi Jesús. Iin nècuàchì dandacú nùù Junta Cahnú nduú‑né, te nihnú stná ini‑nè sàà tiempu cusahnú Dios ñuhìví yohó. Divi‑ne nì sàhàn nùù Pilatu; cónì yúhî‑nè, nì xìcàn‑nè cuerpu xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Te nì ndulocó‑te, a ndísá yàchì gà sànì xìhì‑yà, á coó. Ñàyùcàndùá, nì cana‑tè iin capitán, nì xìcàn tnùhù‑té nùù témà a ndísá sànì xìhì‑yà, á coó. ");
INSERT INTO mitNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","―Jaan ―nì cachi capitán mà. Ñàyùcàndùá, nì sàha Pilatu lugar naquihin José mà cuerpu xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sàháyùcàndùá, nì xiin nècuàchìmà iin dahmà finu, te nihí‑néà cuàhàn nì nanihi‑ne cuerpu xi‑ya, nì chidùcún‑néyà, te nì chinacaa‑nèyà ini cueva xi nsìi sànì cààn canúú ìcà cavà. Dandu nì dàtùí‑né iin cavà cahnú yuhù cueva mà nì sàcùndiadià. ");
INSERT INTO mitNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Te María Magdalena, xì María dihi José, nì caxini stná‑nè lugar ndé nì sàcùnacaa‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Daaní, na sánì cuñaà quìvì descansu, dandu nì sàhàn María Magdalena, xì Salomé, xì María dihi Jacobo, nì xiin‑ne tàtnà tnàmì ñà‑cunihi‑ne cùhùn dacuchí‑né cuerpu xi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dandu naha quìvì primeru semana nì quihin‑ne ichì cuàhàn‑nè cueva ndé iá‑yà. Te nì xìnu orá. ");
INSERT INTO mitNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Te cachí‑nè, iin‑ne xì inga‑nè: ―¿Ana chindee xi‑nda dacúxíó xí cavà cahnú ndiadí yuhù cueva mà? ");
INSERT INTO mitNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Doco nì candacoto‑ne, te nì xini‑nè sànì cuxio cavà mà, mate cahnú sàstnùhá. ");
INSERT INTO mitNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dandu nì quìhvi‑ne ini cueva mà, te nì xini‑nè iá iin ana nduú na iin nècuàchì chìì, iá‑nè ladu cuàhá cueva mà, ndixí‑né iin sìcoto quihín cuxín yaa. Ñàyùcàndùá nì candulocó gà nècuàchì ñahà mà. ");
INSERT INTO mitNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Doco nì càhàn nècuàchì iá yucán, cachí‑nè xì nècuàchìmà: ―Màsà yúhî‑nsià; Jesús de Nazaret nandúcú‑nsiâ, divi ana nì xìhì nchìca cruz. Doco cunaha‑nsiá, sànì natiacu‑yà. Còò cá‑yà yohó. Cundehè‑nsiá lugar ndé nì sanduhù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ñàyùcàndùá, cuahán‑nsià cachitnùhu‑nsia xì Pedro xì nècuàchì dava ga nìsa dacuahá‑yá, te cachi‑nsià xì‑né ñà‑ìcúmí‑yâ codònùù‑yá nùù‑nsiá nùhù‑yà ladu Galilea. Yucán icúmí‑nsiâ cunì‑nsiayà, vàchi ducán nì cachi‑yà xì‑nsiá ―nì cachi ángel. ");
INSERT INTO mitNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Daaní, nì caquee nècuàchìmà cueva mà, nì dàyáà‑nè cuàhàn‑nè. Vàchi nì quesaha‑né quidí‑né, te ndulócô gà‑nè. Doco sàhà ñà‑nì yùhí guâ‑nè, cónì càchí‑nè ni‑iñàha xì nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ducán nì natiacu Jesús naha quìvì primeru semana. Te María Magdalena nduú nècuàchì primeru nì ndecunu‑ya nùù‑xí. Nècuàchìmà, ùsà ñà‑malu nì sañuhu ini‑nè antes, doco nì tavà‑yá nsidaámà anima‑nè. ");
INSERT INTO mitNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pues divi nècuàchìmà nì xini xì‑yá primeru, dandu nì sàhàn‑nè nì cachitnùhu‑ne xì compañeru‑yà, divi nècuàchì nìsa xìcanuu xi‑yá antes. Vàchi ndoó‑né tnùnsí ini, te sacú‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Dandu nì nacani María mà xì‑né ñà‑sànì natiacu‑yà, te nì ndecunu‑ya nùù‑né. Doco cónì xìníndísâ nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Daaní, después cuàhàn ùì nèhivì xí‑yá nùù campu, te yucán nì ndecunu tu‑ya nùù‑né, doco tucu nì nàcùnahà‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dandu nì naxicocuíìn nècuàchìmà nì cachitnùhu‑ne xì compañeru‑nè. Doco cónì xìníndísâ stná nècuàchì dava ga mà yuhù‑né. ");
INSERT INTO mitNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chicá después nì ndecunu tu‑ya nì natùi‑ya nùù nsìhúxìn iin nècuàchì dacuahá‑yá na meru ndoó‑né xixí‑né. Te nì càhàn duchi ini‑yà xì‑né sàhà ñà‑caxin guá anima‑nè, vàchi cónì xìníndísâ‑né yuhù nècuàchì nì xini xì‑yá primeru ñà‑sànì natiacu‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dandu nì cachi‑yà xì‑né: ―Cuahán‑nsià inicutu ñuhìví, te cachitnùhu vate‑nsiá razón ndiaha xí ñà‑cunini nsidanicuú nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nècuàchì cunindisa‑xán, te cuhiì‑né, icúmí‑nê càcu‑ne nùù Dios. Doco nècuàchì mà cúníndísá‑xân, nicanicuahàn icúmí‑nê cunsida‑ne cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Te nú sànì xinindisá nèhivì, dandu icúmí stnâ‑nè quida‑ne milagru. Sàhà yùhù icúmí‑nê tavà‑né ñà‑malu ñuhú anima nèhivì, te càhàn stná‑nè dàhàn sàà. ");
INSERT INTO mitNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Te nú ni tnií‑né iin còò dàná, te ò nú ni cohó‑né ndutè dàná, dandu còò ni‑iñàha cuu xi‑né. Te icúmí stnâ‑nè chitàndòó‑né ndahà‑né dìnì nècuàchì cuhí, te nduvàha nècuàchìmà ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Daaní, na ní nsihi nì càhàn‑yà xì nècuàchì dacuahá‑yá ducán, dandu mànana cuisì‑yá ansivi cuàhàn‑yà, te nì sàcòo‑ya ladu cuàhá Dios. ");
INSERT INTO mitNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dandu nècuàchìmà, nì caquihin‑ne ichì cuàhàn‑nè, nì cachitnùhu vate‑né inicutu ñà‑ndùú razón ndiaha xí‑yá. Te Stoho‑ndà Señor, nì chindee stná‑yànè nì sàha‑ya milagru ñà‑cucumi‑nda seguru divi palabra ndàcuisì nduá cachí‑nè. Yohó nì nsihi historia.");
INSERT INTO mitNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Cuàhà nèhivì sànì quida lucha tiaa‑ne iin tutu ndé nachutnahá víi‑né historia nacání xí ñà‑ndùá nì xini nèhivì xí‑nsí nì cuu, nì tiaa‑ne nacua nì cachitnùhu nècuàchì nì xininùù mà, vàchi ináhá nècuàchìmà nansa nì cuu dècuèndè quìvì primeru, dandu nì dàcuítià stná‑nè palabra mà, te ducán nì xinitnùhu stná nsiùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Ñàyùcàndùá, stná yùhù nì nacani stná inì tiai iin tutu ñà‑nàcání víi xi‑ní sàhà nsidaa ñà‑ndùá nì ìa. Vàchi yùhù, sànì sàì nì cundaà vàha inì sàhà nsidaa chuun yohó dècuèndè quìvì primeru na ní quesaha‑ñá. (Ñàyùcàndùá, tiaí tutu yohó) nùù mii‑ní don Teófilo, sàhà‑ñá vàtùni cundaà vàha inì‑ní divi ñà‑ndáà nduá sànì nacani nèhivì xì‑ní sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tiempu dandacú rey Herodes nùù ñuu Judea nì sandua, te ñuu yucán nìsa ìa stná iin dùtù nani Zacarías. Turnu nì saquidachuún‑né chuun xi dùtù. Te mii‑né xì dùtù compañeru‑nè, nsidaa‑né nani‑né turnu xi Abías. Te ñahàdìhí‑nè nani Elisabet. Descendencia xi dùtù Aarón sànaha xínduu ndúì nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Te nihnú ndàcuisì ini‑nè Yua‑nda Dios; chívàha ndisa‑ne nsidaa ñà‑ndùá dandacú‑yá, nsidaa ñà‑ndùá cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Doco còò déhe‑ne, vàchi de por sí, còò méè xi Elisabet, te vichi ndúì‑nè sànì sahnu cuahà‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Daaní, iin quìvì nì sàà nì quida tocar Zacarías mà turnu xi‑ne ñà‑quida‑ne chuun xi dùtù nùù Dios. Te estilu nìsa icumi dùtù mà ndùá ñà‑quìdá‑né iin sorteu (índù chuun divi quida cada iin iin‑ne). Te Zacarías nì quida tocar ñà‑quìhvi‑ne veheñùhu cahnú ñà‑chiñùhmá‑nè inciensu. ");
INSERT INTO mitNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Te nsidaa nèhivì dava ga sáhàn veheñùhu yucán, ndoó‑né tùvèhé nacuátú‑né na hora chíñùhmá dùtù mà inciensu. ");
INSERT INTO mitNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Dandu ini veheñùhu ma nì ndecunu iin ángel xi Stoho‑ndà Señor, te nì xini Zacarías‑nè, iín‑né ladu cuàhá mesa ndiaha ndé sàhmì‑xì inciensu. ");
INSERT INTO mitNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Te nì yùhí Zacarías mà, yáha ga nacání ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dandu nì càhàn ángel mà xì‑né, cachí‑nè: ―Màsà yúhî‑nî, Zacarías, vàchi cunaha‑ní, sànì tiacu Dios ñà‑ndùá nì xìcàn tàhvì‑ní nùù‑yá; ñàyùcàndùá, cuàhàn coo iin dèhe‑ní, vàchi cuàhàn coo iin méè xi nècuàchì vehe‑ní Elisabet; méè tiàa cunduu‑ve, te Juan dacúnání‑nsiâvè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Cuàhà gá icúmí‑nsiâ cudiì inì‑nsia, te naquimanì stná‑nsià mii‑yá; te cuàhà gá stná nèhivì icúmí cudiì inì‑xi na quesaa‑vè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Te na cuahnu‑ve, icúmí‑vê nìhì‑vé iin chuun cahnú nùù Yua‑nda Dios. Te ni vinu te ni ndutè ìhnì, mà nunca sàà‑nè coho‑ne ndutè mà. Mate táñâha ga tùinuù‑né ñuhìví, doco sàchitu anima‑nè Espíritu Ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Te sàhà palabra cachi‑nè icúmí cuàhà nècuàchì raza‑ní Israel naxicocuíìn ini‑nè, te natenchicùn‑nè Stoho‑ndà Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dihna dèhe‑ní icúmí codònùù quesaa, dandu mii‑yá. Icúmí‑nê quida‑ne nacua nìsa quida Elías sànaha, iin‑ni cunihnu ini‑nè Dios nacua nìsa quida nècuàchì yucán, te iin‑ni chindee stná Dios‑nè. Te icúmí‑nê càhàn stná‑nè xì ana xínduu nècuàchì sahnú ñuù‑ní, dandu nsinuu ini nècuàchìmà dèhe‑ne, te nàcùndoo viì nsidaa‑né. Te càhàn stná dèhe‑ní xì cuàhà nèhivì có‑ndùlócô xì Dios sàhà‑ñá nìhì nècuàchìmà nàcùnihnu vàha stná ini‑nè, dandu nsidaviì‑né anima‑nè, te cundoo tùha‑ne na quesaa Stoho‑ndà Señor ―nì cachi ángel mà. ");
INSERT INTO mitNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dandu nì cachi Zacarías xì ángel: ―¿Índù iin milagru coo sàhà‑ñá cundaà ndisa inì ñà‑ndáà nduá cachí‑nî? Vàchi yùhù, sàsàhnú cuáhìˊ, te ducán stná ñahàdìhíˋ, sàsàhnú stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Te nì cachi ángel mà: ―Yùhù nduí Gabriel, te nùù Dios iín tùhe nicanicuahàn. Te divi‑ya nì techuún‑yá yùhù vàxi cachitnùhi xì‑ní ñà‑ndùá sànì cachì xì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Doco vichi icúmí‑nî nduhihin‑ní, mà cúí gá càhàn‑ní ni‑iin palabra dècuèndè quìvì cuu ndisa ñà‑ndùá nì cachì xì‑ní, vàchi có‑xìníndísá‑nî. Doco seguru icúmí cuu ñà‑ndùá nì cachì xì‑ní ―nì cachi ángel. ");
INSERT INTO mitNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Daaní, nècuàchì xíndiatu tùvèhèmà, nacání gá ini‑nè, ¿índù chuun nì cuee guá Zacarías ini veheñùhu? ");
INSERT INTO mitNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dandu nì quee nècuàchìmà, doco mà cùì gá càhàn‑nè. Ñàyùcàndùá, nì cundaà ini nèhivì mà sànì dàcùní Dios nècuàchimà iñàha na iá‑nè veheñùhu, vàchi sànì nduhihin‑né, te vichi cuisì‑ní ndahà‑né cuú quidá‑né seña. ");
INSERT INTO mitNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Daaní, después nì cuee Zacarías nì ìa‑ne ñuu yucán dècuèndè nì xìnu quìvì xinúcuáchí‑nê yucán, dandu nì naquihin‑ne ichì mànuhù‑né vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Te nì yàha iin tiempu, dandu nì cundaà ini‑nè sàñùhú méè xi ñahàdìhí‑nè Elisabet. Ñàyùcàndùá, ùhùn yòò nì ndòo Elisabet mà vehe‑ne, cudíì ini‑nè, cachí‑nè: “(Ansivéhé) Dios, sànì chindee‑yá yùhù, vàchi ináhá‑yâ sácùndiaa nèhivì yùhù; ñàyùcàndùá nì indehè ndahví‑yà yùhù, te vichi mà cáhîchì gá ini‑nè yùhù”. ");
INSERT INTO mitNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Daaní, nì sàà ìñù yòò, te nì techuún Dios ángel Gabriel mà inga xichi vàxi‑ne iin ñuu tii nani Nazaret iá ladu Galilea, ");
INSERT INTO mitNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","vàxi‑ne cachitnùhu‑ne xì iin nècuàchì ñahà chìì nani María. Señorita nduú nècuàchìmà; te sànì ndiadi tnùhu xi‑ne ñà‑cuàhàn‑nè nandàhà‑né xì iin tiàa nani José, iin nècuàchì descendencia xi rey David. ");
INSERT INTO mitNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Te nì sàà ángel mà ndé iá María mà, nì yàha‑ne ini vehe, te nì cachi‑nè: ―Cuaàváha‑ní. Cunaha‑ní, sànì nìhì cuáhà‑ní gracia nùù Stoho‑ndà Dios, te cutnáhâ‑yá xì‑ní. Chicá ndiaha sànì nìhìtáhvì‑ní nùù nsidanicuú gá nècuàchì ñahà. ");
INSERT INTO mitNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dandu María, indéhe‑né ángel mà, te nì ndulocó‑nè: ¿índù chuun cásàhú nècuàchìmà xì‑né ducán? càhàn‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Dandu cachí ángel mà: ―Màsà yúhî‑nî, María, vàchi ndiaha gá sànì nìhìtáhvì‑ní nùù Dios ñà‑quida‑ya gracia sàhà‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cunaha‑ní, icúmí coo iin méè xi‑ní, tùinuù‑vé ñuhìví; méè tiàa cunduu‑ve, te Jesús cunani‑vé quida‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Cahnú chuun icúmí‑yâ nìhì‑yá, vàchi Dèhemanì Stoho‑ndà Dios iá ansivi cunduu‑ya. Te chuun cucumi‑yá nùù Yuamánì‑yá cunduu ñà‑dandacú‑yá nacua nìsa dandacú yohòtéhè‑yá David. ");
INSERT INTO mitNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Te nicanicuahàn icúmí‑yâ cusahnú‑yá nùù nsidaa nèhivì raza‑ní Israel, te mà nunca sàà iin quìvì mà dándácû gá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dandu nì cachi María xì ángel mà: ―Doco ¿índù modo cuu xí ducán, como tàyóo iì yúhù? ");
INSERT INTO mitNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dandu nì cachi tu ángel mà xì‑né: ―Fuerte icúmí quixi Espíritu Ìì xí Dios ini anima‑ní xì poder ìì xí‑yá; vàchi iin milagru cundua quida Yua‑nda Dios iá ansivi. Ñàyùcàndùá, ìì sástnùhù icúmí coo méè xi‑ní, vàchi Dèhemanì Dios cunduu‑ve. ");
INSERT INTO mitNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Cunaha‑ní, tnaha stná‑ní Elisabet, cuàhàn coo stná iin méè xi‑ne, mate sàsàhnú cuáhà‑né. Te vichi sàcuàhàn‑ndà ìñù yòò ñuhú méè xi‑ne, mate antes nìsa cachi nèhivì mà cúí coo ni‑iin dèhe‑ne. Ducán nì nìhìtáhvì‑né nùù Dios, vàchi mà úhì quida‑ya nsidanicuú iñàha. ");
INSERT INTO mitNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dandu nì cachi María: ―Còó, vàtùni; yùhù icúmî quide ñà‑ndùá cachí mii‑yá. Vàtùni ni quidá‑yá xìˊ nacua cachí‑nî ―nì cachi‑nè. Dandu nì quee ángel mà cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Quìvì yucán nì quihin María ichì cuàhàn ndee‑né iin ñuu iá ladu Judea ndé iá puru yucù cuàchì. Te na ní sàà‑nè ñuu yucán, nì sàhàn‑nè vehe Zacarías, nì casàhú‑nè xì Elisabet. ");
INSERT INTO mitNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na ní tiacu nècuàchìmà cásàhú María xì‑né, dandu nì cundaà ini‑nè nì ndacùchí fuerte méè xi‑ne tìxi‑ne. Dandu fuerte nì quixi Espíritu Ìì xí Dios ini anima‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Te ndee ní càhàn‑nè, cachí‑nè xì María: ―Ndiaha gá sànì quida Yua‑nda Dios xì mii‑ní nùù nsidaa gá nècuàchì ñahà, te ndiaha gá coo stná méè xi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","’Mii‑ní, dihi Stoho‑ndà Señor nduu‑ní, doco vichi sànì quesaà‑ní ndé iéˋ, mate có‑nâtùi (quixi‑ní vehi). ");
INSERT INTO mitNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Vàchi cunaha‑ní, na ní tiacuì cásàhú‑nî xìˊ, dandu nì ndacùchí fuerte méè‑xi tìxi ñà‑cùdíì guá ini‑vè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Vàchi, ndiaha gá sànì cundiatú anima‑ní, ñà‑nì xinindisa‑ní; te vichi seguru icúmí cuu ndisa razón xi Dios nì inini‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dandu nì cachi María: Yùhù, cuàhà gá naquímánìˊ Stoho‑ndà Señor vichi, ");
INSERT INTO mitNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","te cuàhà gá cudíì ini anímè sàhà‑yá, divi mii‑yá nì dàcácu xí. ");
INSERT INTO mitNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Vàchi sànì xinimànì‑yá yùhù, mate nècuàchì ndahví nduí. Ináhî, dècuèndè vichi xì ndéˋ nicanicuahàn icúmí nèhivì cundaà ini‑nè ndiaha gá nì quida Dios xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Fuerte sàstnùhù‑yá, te cuàhà gá obra sànì quida‑ya xìˊ; ìì ndisa‑ya sànì cundaà inì. ");
INSERT INTO mitNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nicanicuahàn icúmí‑yâ cundehè ndahví‑yà nèhivì càhvì xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","52","Te ndiaha gá obra nahnú quidá‑yá, ñàyùcàndùá nsidaa nècuàchì cuadú, sànì cundee dahuun‑ya nùù‑né, xì nsidaa stná tè‑xídandacú, sànì dàcúxíó stná‑yàte nùù chuun xi‑tè, te nì chidònùù‑yá nècuàchì ndahví. ");
INSERT INTO mitNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Stná nècuàchì xíhì guá doco, sànì sàha‑yanè ñà‑vàha xi‑ne, te nì ndòo vàha ini‑nè. Doco nècuàchì cuìcà, còò ni‑iñàha ni níhì‑né nùù‑yá, te cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Sànaha nì càhàn‑yà xì xìì‑ndà Abraham, te nì quida‑ya comprometer ñà‑nicanicuahàn icúmí‑yâ chindee‑yá mii‑né xì descendencia xi‑ne. Ñàyùcàndùá, vichi sànì quida‑yañà‑mà cumplir, sànì chindee‑yá raza‑ndà Israel, vàchi cónì nándodó‑yá ñà‑ndùá nì cachi‑yà daa, nì cachi María. ");
INSERT INTO mitNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Daaní, ùnì yòò nìsa ìa ga nècuàchìmà xì Elisabet, dandu mànuhù‑né vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Daaní, nì sàà quìvì quesaa méè xi Elisabet, te nì tùinuù‑vé, méè tiàa nduú‑vé. ");
INSERT INTO mitNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Te nsidaa vecinu xi‑ne, xì nsidaa stná tnaha‑ne, nì xinitnùhu‑ne nansa nì indehè ndahví Stoho‑ndà Señor nècuàchìmà. Ñàyùcàndùá, nì cudiì gá ini nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Te na ní xìnu ùnà quìvì, nì casaà nsidaa nèhivì mà (vehe Elisabet), vàchi cuàhàn màcùtuu seña xi Dios ìcà‑vé; te cuní nèhivì mà dacúnání‑nêvè Zacarías, nacua nani yua‑vé. ");
INSERT INTO mitNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Doco nì cachi dihi‑vé: ―Còó, Juan cunduu quìvì‑vé. ");
INSERT INTO mitNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Te nì cacachi nècuàchìmà: ―¿Índù chuun? vàchi còò ni‑iin tnaha‑nda nani Juan. ");
INSERT INTO mitNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dandu nì caquida nècuàchìmà seña nì ndàcàtnùhù‑né nùù yua‑vé, a ver nansa cuní mii‑né cunani‑vé. ");
INSERT INTO mitNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ñàyùcàndùá, nì xìcàn nècuàchìmà iin tabla tii nì tiaa‑ne ñà‑Juan cunduu quìvì‑vé. Dandu nsidaa nècuàchì yucán, nì candulocó‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Te divi momentu mà nì quesaha nì nacahàn fuerte Zacarías, vàtùni nì nacahàn viì‑né vichi. Te nì ndenihi vàha‑ne Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Daaní, nsidaa nèhivì ndoó yucù ladu Judea mà, nì ndatnuhu cuahà‑né sàhà ñà‑ndùá nì cuu ma. ");
INSERT INTO mitNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Te nsidaa ana nì xinitnùhu sàhà‑ñá, nì chivàha nsihi‑neà ini anima‑nè, cachí‑nè: ―¿Índù iin clase nèhivì cunduu méè yohó? Ducán nì cachi‑nè, vàchi cuàhà gá nì chindee Dios‑vè. ");
INSERT INTO mitNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Daaní, yua‑vé Zacarías, fuerte nì quixi Espíritu Ìì xí Dios ini anima‑nè, te ndiaha gá nì càhàn‑nè nì quida‑ya, cachí‑nè: ");
INSERT INTO mitNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cuàhà gá naquímánì‑ndà Stoho‑ndà Dios, divi mii‑yá ana càhvì nsidaa raza‑ndà Israel, vàchi sànì indehè ndàhví‑yà ndohó nècuàchì nduú nèhivì xí‑yá, te sànì dàcácu‑yàndó. ");
INSERT INTO mitNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Sànì techuún‑yá iin ana chicá fuerte dacácu xi‑nda, divi iin descendencia xi nèhivì xí‑yá nani David. ");
INSERT INTO mitNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Vàchi dècuèndè chicá sànaha sànì quida‑ya comprometer ñà‑quixi ana dacácu xi‑nda, vàchi ducán nì cachi‑yà xì nèhivì xí‑yá (sànaha), te nì cachitnùhu nècuàchì ìì mà ");
INSERT INTO mitNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ñà‑ìcúmí‑yâ dacácu‑yàndó nùù nsidaa ana xiní ùhì xì‑ndà, xì nùù stná ana dava ga có‑xìñùhù xì‑ndà, ");
INSERT INTO mitNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","te cundehè ndàhví‑yà nsidaa yohòtéhè‑ndà. Mà nándodó‑yá tratu ìì nì saquin‑yà xì xìì‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Vàchi fuerte nì càhàn‑yà ñà‑seguru quida‑ya ñà‑ndùá nì cachi‑yà xì xìì‑ndà Abraham, icúmí‑yâ cuidahan‑yándô nùù ndahà nsidaa tè‑xìní ùhì xì‑ndà, te mà yúhî gà‑ndà. Dandu vàtùni cunucuachi víi‑nda nùù‑yá nicanicuahàn, cunduu‑nda nèhivì ìì xí‑yá, nèhivì nihnú ndàcuisì inì‑xi. ");
INSERT INTO mitNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te miun xu, icúmú cunduu ana càhàn sàhà Yua‑nda Dios iá dìquì‑xí ansivi, vàchi dihna miun icúmú càhùn xì nèhivì sàhà‑ñá natenchicùn‑nè ichì váha, dandu na quívì quesaa Stoho‑ndà Señor, sàndòó tùha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Vàchi icúmú cachitnùhu xì nèhivì xí‑yá nansa cui càcu anima‑nè, te nandutu cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Vàchi vichi, sànì cuhi ini Dios ndohó. Ndè dìquì‑xí ansivi nì quee‑ya nì quesaa‑yà ñà‑datnúù‑yà sàxìnítnùní‑ndà, ");
INSERT INTO mitNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","xì stná sàxìnítnùní nèhivì có‑sâà cundaà inì‑xi, divi nèhivì sà‑ìtúú ndañuhu anima‑xi. Te vichi vàtùni cundaca‑yàndó iin ichì víi ndé cundoo viì‑ndà nùù‑yá, te cudiì gá ini‑ndà, nì cachi Zacarías. ");
INSERT INTO mitNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Daaní, nì sahnu méè Juan mà, te nì sàcòo fuerte anima‑nè. Te iin‑ni nì ìa‑ne yucù dècuèndè nì sàà quìvì nì quesaha‑né cacanuu‑ne cáhàn‑nè sàhù sàhà mii‑yá xì nèhivì raza‑nè Israel. ");
INSERT INTO mitNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Daaní, quìvì yucán nì dàndàcú tè‑cùsáhnû César Augusto ñà‑ìcúmí nandiahvi nsidaa nèhivì cusáhnû‑te nùù‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ñà‑yùcán nì sanduu censu primeru nì quida‑tè na tiempu dandacú Cirenio nùù ladu Siria. ");
INSERT INTO mitNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ñàyùcàndùá, nsidanicuú nèhivì, mànuhù‑né ñuu‑nè ñà‑nayàha‑ne nùù lista, ");
INSERT INTO mitNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","xì stná José, nì quee stná‑nè ñuu Nazaret iá ladu Galilea mànuhù‑né ladu Judea ndé nduú ñuu‑nè nani Belén, vàchi descendencia xi David nduú stná‑nè, ñàyùcàndùá, mànuhù‑né ñuu tii ma ndé nìsa ìa David sànaha, ");
INSERT INTO mitNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","cuàhàn‑nè dayáha‑ne quìvì‑né nùù lista mà. Te cutnáhâ stná‑nè xì María nècuàchì cuàhàn nandàhà xì‑né, te ñuhú méè xi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Daaní, ndoó íì‑né ñuu yucán, te nì sàà quìvì tùinuù méè mà. ");
INSERT INTO mitNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ñàyùcàndùá, yucán nì quesaa‑vè ñuhìví; méè nuu xí‑né nduú‑vé, te nì chidùcún‑névè sìcoto ndahví, te nì chinduhù‑névè ini iin canoa, vàchi có‑sâà gà vehe ndé quídì nècuàchì xicá ichì. ");
INSERT INTO mitNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Cunaha‑ní, yatni ñuu yucán ndoó stná nèhivì quídì ndiaá xì riì xí. ");
INSERT INTO mitNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te na íín cachí nì ndecunu iin ángel xi Stoho‑ndà Señor, nì sàcuììn‑nè nùù nècuàchìmà, te ndiaha gá nì natnuù inicutu ndé ndoó‑né nì quida Stoho‑ndà Señor. Ñàyùcàndùá, nì cayùhí cuaá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dandu nì cachi ángel mà xì‑né: ―Màsà yúhî‑nsià, vàchi cunaha‑nsiá, yohó vàxi nihí iin razón vàha cunini‑nsia, iin razón cudiì ini nsidaa nèhivì ñuhìví nduá. ");
INSERT INTO mitNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vàchi vichi ndè ñuu xìì‑nsiá David sànì tùinuù iin ana dacácu xi‑nsiá, divi Stoho‑ndà Cristu. ");
INSERT INTO mitNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Te na sáà‑nsià yucán, icúmí‑nsiâ cuni‑nsiàyà, idáducún‑yá sìcoto, indúhu‑yá ini iin canoa. Ñà‑jaàn cunduu seña cundaà vàha ini‑nsià divi ñà‑ndáà nduá cachíˋ xì‑nsiá ―nì cachi ángel. ");
INSERT INTO mitNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Daaní, na íín cachí nì ndecoyo cuàhà gá ángel nì caquixi ansivi, cutnáhâ‑né xì ángel nì quesaa primeru mà. Te ndeníhí vàha nsidaa‑né Dios, cachí‑nè: ");
INSERT INTO mitNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Dìquì‑xí ansivi ni queé cuàhà tnùñuhu xí Yua‑nda Dios, te ñuhìví yohó ni cúndóó víi nsidaa nèhivì cudíì ini‑yà sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Daaní, nì ndanchito nsidaa ángel mà mànuhù‑né gloria. Dandu nì cachi nècuàchì xíndiaa xì riì mà: ―Cúhùn‑ndà vichi duha ñuu tii Belén, cundehè‑ndà ñà‑ndùá nì cuu nì cachitnùhu Stoho‑ndà Señor xì‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ñàyùcàndùá, ndee ní quihin‑ne ichì cuàhàn‑nè, te nì casaà‑nè yucán, nì xini‑nè yucán iá María xì José xì stná méè, indúhu‑vé ini canoa. ");
INSERT INTO mitNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dandu nì nsihi nì xini‑nè méè mà, dandu nì cachitnùhu‑ne xì nèhivì ñà‑ndùá nì cachi ángel xì‑né sàhà‑vé. ");
INSERT INTO mitNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Te nsidaa nèhivì nì inini xi ñà‑ndùá nacání pastor mà, nì ndulocó‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Te María, cónì nándòdó stná‑nè ñà‑ndùá nì cachi ángel xì‑né, iin‑ni nacání ini‑nè sàhámà. ");
INSERT INTO mitNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Daaní, nì caquihin pastor mà ichì mànuhù‑né, ndeníhí vàha‑ne Dios, naquímánì cuáhà‑né mii‑yá sàhà nsidaa ñá‑ndùá nì xinitnùhu‑ne, xì ñà‑ndùá nì xini‑nè, vàchi nacua nì cachitnùhu ángel mà xì‑né, divi ducán nì cuu. ");
INSERT INTO mitNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na ní yàha ùnà quìvì, dandu nì sàcùtuu seña xi Dios ìcà méè Jesús mà, te nì nìhì stná‑yà quìvì‑yá; nì sàcùnani‑yá Jesús, vàchi ñà‑jaàn cunduu quìvì‑yá nì cachi ángel na táñâha ga nacùhun ndiaha‑yá tìxi dihi‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Daaní, nì yàha quìvì cuhí quihmi María, vàchi nì quida‑ne cumplir nacua iá ley xi Moisés sàhà nadaa quìvì coo quihmi‑né. Dandu mii‑né xì José, nihí‑névè cuàhàn ñuu Jerusalén ñà‑chitanini‑nevè nùù Yua‑nda Dios, ");
INSERT INTO mitNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","vàchi dohó cachí tutu ìì nduú ley xi Dios: “Tiàa primeru quesaa ñuhìví, nsidaa‑vé cunduu‑ve méè ndiaha xí Dios”. ");
INSERT INTO mitNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Te cachí stná ley mà ñà‑ìcúmí‑nê cuàha‑ne ùì lungu, te nú coó, ùì loma cuachi. Ñàyùcàndùá, nì sàhàn‑nè nì sàha stná‑nè quisì mà ñà‑cuì‑si cunduu‑sì promesa nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Cunaha‑ní, ñuu Jerusalén yucán nìsa ìa iin tiàa nani Simeón. Nècuàchì nihnú ndàcuisì ini xì Dios nduú stná‑nè, vàchi cahvi víi‑néyà, te nihnú vàha ini‑nè ñà‑quixi ana cuàhàn chindee xi raza‑nè Israel, te icúmí stná‑nè Espíritu Ìì xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Te divi Espíritu Ìì mà sànì cachitnùhu‑ya xì‑né antes ñà‑mà cúí‑nè dècuèndè cachi cuninùù‑né ana nduú Cristu nì quixi nùù Stoho‑ndà Señor. ");
INSERT INTO mitNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ñàyùcàndùá, quìvì yucán nì càhàn Espíritu Ìì xì‑né, te nì sàà‑nè veheñùhu cahnú na meru quíhvi stná yuadíhí‑vê nihí‑névè vàxi quida‑ne nacua cachí ley ìì. ");
INSERT INTO mitNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Dandu nècuàchì sàhnù‑mà, nì sàcùnìndiaa‑nèvè, te nì naquimanì‑né Dios, cachí‑nè: ");
INSERT INTO mitNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Sà‑ìá vichi, Señor mío, vàtùni nacuaca‑ní yùhù vichi, vàchi contentu iéˋ, vàchi nacua nì cachì‑ní xìˊ, divi ducán nì cuu ndisa, sànì xinì ana nì techuun‑ní ñà‑dacácu xi‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mii‑ní, nì chitnùní inì‑ní quesaa‑yà, dandu nìhì nèhivì nsidanicuú ñuu cundaà ini‑nè nansa cui càcu anima‑nè quida‑ya. ");
INSERT INTO mitNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Vàchi icúmí‑yâ datnúù‑yà sàxìnítnùní nsidaa nèhivì mà; te divi ducání stná nècuàchì raza‑nsì Israel, cuàhà gá tnùñúhú ndiaha icúmí‑nsî nìhì‑nsí sàhà‑yá, nì cachi Simeón. ");
INSERT INTO mitNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ñàyùcàndùá, cuàhà gá nì ndulocó José xì María sàhà ñà‑ndùá nì cachi nècuàchìmà sàhà méè mà. ");
INSERT INTO mitNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dandu nì xìcàn tàhvì Simeón gracia xi Dios sàhà yuadíhí‑vê, te nì cachi stná‑nè xì dihi‑vé: ―Cunaha‑ní, sàhà méè yohó icúmí cundiatú anima cuàhà gá nècuàchì ñuu‑ndà Israel. Doco dava ga stná‑nè, quixi tnùndoho cahnú dìquì‑né, según nansa indéhe‑né mii‑yá nduú méè yohó. Te icúmí‑yâ cachitnùhu‑ya sàhà ichì Yua‑nda Dios, doco cuàhà stná nèhivì cahíchì ini xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Te sàhámà icúmí cundaà inì‑xi ñà‑ndùá nihnú ini‑nè ini anima‑nè. Daaní, mii‑ní, icúmí stná‑ní (cunì‑ní tnùndoho), na ian xída iin càa anima‑ní ―nì cachi Simeón. ");
INSERT INTO mitNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Daaní, yucán nìsa ìa stná iin nècuàchì ñahà nani Ana, te sànì nìhìtáhvì‑né càhàn‑nè cuenta xi Dios. Dèhe iin tiàa nani Fanuel nduú‑né, te Aser nani yohòtéhè‑né. Sàsàhnú cuáhà‑né vichi. Nì nandàhà‑né na chii‑né, te ùsà cuìà nì ìa‑ne xì iì‑né, dandu nì xìhì nècuàchìmà. Te vichi sàcuàhàn‑ndà 84 cuìà iá mii‑né. Te có‑quèé‑né veheñùhu cahnú, vàchi ndui te ñuú iá‑nè yucán, xinúcuáchí‑nê nùù Dios, iníhíì‑né, te xícàn tàhvì‑né nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ñàyùcàndùá, divi momentu mà nì tnàtuu nècuàchìmà (ndé iín María xì José), te nì naquimanì stná‑nè Dios (sàhà méè Jesús), dandu nì quesaha‑né nì càhàn‑nè xì nèhivì ñuu Jerusalén sàhà‑vé, nì cachitnùhu‑ne xì nèhivì xíndiatu ñà‑quesaa mii‑yá quida‑xi obra, te càcu‑nda. ");
INSERT INTO mitNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Daaní, José xì María, nì nsihi nì quida‑ne nsidaa ñà‑ndùá dandacú ley xi Dios, dandu nì naquihin‑ne ichì mànuhù‑né ladu Galilea, nì nasaa‑nè ñuu‑nè Nazaret ndé ndoó‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Te méè nduú mii‑yá, nì sahnu‑ya, nì cufuerté anima‑yà, te chicá nì cunchichí‑yà, cuàhà gá gracia xi Dios icúmí‑yâ. ");
INSERT INTO mitNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cunaha‑ní, cuìà cuìà nì sasahàn yuadíhí‑yâ ñuu Jerusalén quìvì nacává vicò pascua. ");
INSERT INTO mitNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","(Te nì cuu iin xichi) na sáxìcá‑yá ùxìn ùì cuìà, dandu cuàhàn tu‑ya xì‑né vicò ñuu mà, vàchi ñà‑jaàn nì sanduu estilu xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Daaní, nì nsihi vicò mà, te nì naquihin‑ne ichì mànuhù‑né; doco nì ndòo Jesús ñuu Jerusalén mà, te cónì xìní José xì María, ");
INSERT INTO mitNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","vàchi ádi váxi‑ya cutnáhâ‑yá xì nèhivì dava ga càhàn‑né. Ñàyùcàndùá, iin quìvì sàxìcá‑né mànuhù‑né, dandu nì quesaha‑né xicánúú‑né nandúcú‑nêyà, ndácàtnùhù‑né nùù tnaha‑ne xì stná amigo xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","46","Doco còó, cónì nátùi‑ya. Ñàyùcàndùá, nì naxicocuíìn‑nè ñuu Jerusalén, áma ndácùhun‑neyà càhàn‑né. Te tìxi ùnì quìvì nì natùi‑ya, veheñùhu cahnú iá‑yà, dava mahì maestru xi ley ìì, iníní‑yá ñà‑ndùá cachí nècuàchìmà, te ndácàtnùhù stná‑yà nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Te nsidaa ana iníní má, nì ndulocó‑nè ñà‑nchìchí guâ‑yà, te naxícóníhî nchichí‑yà nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Te na ní xini José xì María iá‑yà yucán, dandu nì ndulocó‑nè, te nì cachi dihi‑yá: ―Hijo, ¿índù chuun nì quido xi‑nsí ducán? vàchi yùhù xì yuo, cuàhà gá nì xìcanuu‑nsi nandúcú‑nsî yohó, nacání cuáhà ini‑nsì. ");
INSERT INTO mitNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Dandu nì cachi‑yà xì‑né: ―Còó, có‑ndùá fuerza nanducu‑nsiá yùhù, vàchi xiñuhu ñà‑cundaà inì‑nsia iá chuun nì nìhí nùù Yua mií, te icúmî quideà. ");
INSERT INTO mitNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Doco José xì María, cónì sánìhì ini‑nè ñà‑ndùá nì cachi‑yà xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","52","Dandu nì nacuaca‑neyà mànuhù‑né xì‑yá ñuu Nazaret. Te nsidaa ñà‑ndùá nì cuu ma, nì chivàha María‑ñà ini anima‑nè. Te mii‑yá, nìsa inini‑ya nsidaa ñà‑ndùá nì cachi yuadíhí‑yâ. Te chicá nì cunchichí‑yà, te chicá nì sahnu‑ya, te nicanicuahàn ndeé vàha‑ya nùù Dios, te nsidaa stná nèhivì, nì cudiì stná ini‑nè sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Daaní, nì yàha tiempu, te nì sàà sàhùn cuìà cusáhnû rey cahnú Tiberio. Mismo cuìà yucán dandacú stná Poncio Pilatu nùù ladu Judea, nduú‑te gobernador. Te ladu Galilea dandacú rey Herodes. Te ñanì‑te Felipe dandacú ndé nduú ladu Iturea xì ladu Traconite. Daaní, ndè ladu Abilinia dandacú iin gobernador nani Lisanias. ");
INSERT INTO mitNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Te dùtù chicá xícusahnú xínduu Anás xì Caifás. Te divi tiempu yucán nì quesaha Dios datnúù‑yà ini sàxìnítnùní Juan (Bautista) ndé iá‑nè yucù. ");
INSERT INTO mitNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ñàyùcàndùá nì quee‑ne cuàhàn‑nè inicutu ladu yatni yùte Jordán, te yucán nì càhàn‑nè sàhù xì nèhivì ñà‑ìcúmí‑nê cuu‑ne arrepentir sàhà ñà‑cuicahnú ini Dios sàhà cuàchi‑ne, dandu cuhiì‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Vàchi ducán cachí stná nùù tutu ìì nì tiaa profeta Isaías, divi nècuàchì nì sacahàn cuenta xi Dios; dohó nì tiaa‑ne: Tiacú cáhàn fuerte ana cáhàn yucù, te cachí‑nè xì‑ndà ñà‑nsida viì‑ndà (anima‑ndà) na ian nduviì ichì ndé yàha Stoho‑ndà Señor, te ichì ndáà cundua. ");
INSERT INTO mitNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Te ducán iá stná na ian cuàhàn chitu stná nsidaa yui, te ndundaà stná nsidaa yucù, xì nsidaa lùnsì, xì nsidaa stná ichì cávà, icúmíâ ndundaà, te ndé iá ichì chicuéhè, nduviì stná yucán. (Ducán icúmí nduviì stná anima nèhivì), ");
INSERT INTO mitNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","dandu nsidanicuú‑né, icúmí‑nê sàà‑nè cuni‑nè nansa sáhatahvì Dios salvación xi‑ya. (Ducán nì cachitnùhu tiàa ma nùù libru mà.) ");
INSERT INTO mitNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ñàyùcàndùá nì caquee cuàhà nèhivì inii ladu yucán, cuàhàn‑nè nùù Juan, vàchi cuní‑nè cuhiì stná‑nè. Dandu nì cachi Juan xì‑né: ―Mii‑nsiá, na quidá còò, ducán quidá‑nsiá, vàxi‑nsia yohó xinúdèhé‑nsià nùù castigu cahnú icúmí quixi. ¿Ana divi nì cachi xì‑nsiá quida‑nsia ducán? ");
INSERT INTO mitNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pues, ñà‑ndùá xiñuhu nduá quida ndisa‑nsia cumplir nacua ndiá ìcà‑ndà nú sànì cuu ndisa‑nda arrepentir. Ni màsà cáchì‑nsia: “Divi Abraham nduú yohòtéhè‑ndà, còò ni‑iñàha cuu xi‑nda”. Vàchi cunaha‑nsiá, dècuèndè stná yùù ndoó yohó, vàtùni nanduu stná nahi nèhivì raza‑ndà Abraham nú cuní mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Te vichi sà‑ìá cuàhàn cachi‑yà índù nèhivì nìhì xì castigu, te ducán iá na ian nácàxin‑nda yutnù có‑càná fruta, te sà‑ìníndáhá‑ndá hacha tàhndè‑nu coco‑nù. Pues ducán icúmí cuu stná xì nèhivì có‑quìdá víi ―nì cachi Juan. ");
INSERT INTO mitNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dandu nì cachi nèhivì cuáhà yucán: ―Nú ducán iá, ¿nansa ndiá ìcà‑nsí quida‑nsi, maestro? ");
INSERT INTO mitNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dandu nì cachi Juan xì‑né: ―Nú ndoó nècuàchì còò dùhnù‑xí, dandu ni dácûtâhvì‑ndàné ian, nú icúmí‑ndá ùìà. Te nècuàchì xíhì doco, ni dácúxî stná‑ndàné nú iá ñà‑cutiacu‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Daaní, yucán nì casaà stná nècuàchì dachíyàhvi, te nì cuhiì stná‑nè. Dandu nì xìcàn tnùhù stná‑nè nùù Juan, cachí‑nè: ―Te nsiùhù, ¿nansa ndiá ìcà‑nsí quida stná‑nsì, maestro? ");
INSERT INTO mitNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Dandu nì cachi Juan xì‑né: ―Nacua cachí ley, divi ducán dachíyàhvi‑nsia nèhivì, màdìá chicá más. ");
INSERT INTO mitNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Daaní, stná soldadu, nì caxicàn tnùhù stná‑nè nùù nècuàchìmà, cachí‑nè: ―Nsiùhù, ¿nansa ndiá ìcà‑nsí quida stná‑nsì? Dandu nì cachi Juan: ―Màsà dáyûhî‑nsià ni‑iin nèhivì, te tavà‑nsiá dìhùn nùù‑né; ni màsà quídáyúcún uun stná‑nsià tnùhu. Te cundoo stná‑nsià conforme xì ñà‑ndùá quíyàhvi‑nsia ―nì cachi Juan. ");
INSERT INTO mitNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ñàyùcàndùá, nsidaa nèhivì, nacání ini‑nè sàhà Juan mà, a Cristu (icúmí quixi nùù Dios) nduú‑né cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dandú nì càhàn Juan xì nsidaa nèhivì yucán, cachí‑nè: ―Yùhù, tècuìí quidá íìˊ mii‑nsiá, doco nchícùn gà vàxi mii‑yá ana chicá cahnú poder xi nùù yùhù. Ni có‑nâtùi cundui iin mozo xi‑ya ñà‑taví ndìsàn‑yá. Te icúmí‑yâ quida iì‑yá anima‑nsià tìxi Espíritu Ìì xí Dios, te na ian quidá ñuhu, ducán quida stná‑yà xì‑nsiá (dandáñúhú stná‑yà ñà‑có‑ndiàá). ");
INSERT INTO mitNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Vàchi vichi sà‑ìá cuàhàn‑yà quida‑ya na quida‑nda xi trigu, yutnù chipála dandiachi‑ndañá, dècuèndè ndiachi nsihí trigu ndoó ñuhù, dandu chivàha‑nda nùnì mà, doco mihì‑ñá, icúmíâ coca. Pues ducan icúmí stná‑yà quida‑ya (xì néhivì, nèhivì xí mii‑yá dacácu‑ya, doco nèhivì dava ga), còó, nicanicuahàn icúmí‑nê coco‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ducán nì cachi Juan na ní càhàn‑nè sàhù, te cuàhà gá stná ñà‑vàha nì cachi‑nè xì nèhivì yucán, áma nánsídá viì‑né modo xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Daaní, rey Herodes, nì càhàn stná Juan mà xì‑té sàhà cuñada xi‑tè nani Herodías, vàchi iá‑te xi ñahà mà, te ñahàdìhí ñanì‑te Felipe nduú‑ña. Te nì càhàn stná‑nè xì‑té sàhà nsidaa gá ñà‑có‑ìá viì quidá‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Doco tèmà, chicá más nì quida chicuéhè‑te, dècuèndè nì sadi stná‑te Juan vehecàa. ");
INSERT INTO mitNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na ní nsihi nì cuhiì nsidaa nèhivì dava ga, dandu nì cuhiì stná Jesús. Te iín‑yá yucán xícàn tàhvì‑yá, dandu ní nuna ansivi, ");
INSERT INTO mitNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","te nì nuu Espíritu Ìì xí Dios dìquì‑yá; na iá loma, ducán iá‑yà mànuu‑ya. Te nì tiacu stná tàchì Dios cáhàn‑yà ansivi, cachí‑yà (xì Jesús): ―Mii‑ní, Dèhemaní nduu‑ní. Te cudíì cuáhà inì sàhà‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Cunaha‑ní, xicá Jesús nahi òcò ùxìn cuìà na ní quesaha‑yá (quidá‑yá chuun ndiaha xí‑yá), te tuxí ini nèhivì dèhe José nduú‑yá. Te iin tiàa nani Elí nì sanduu velú xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Te yua Elí mà ní sanduu Matat; te yua Matat nì sanduu Leví; te yua Leví nì sanduu Melqui; te yua Melqui nì sanduu Jana; te yua Jana nì sanduu inga José; ");
INSERT INTO mitNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","te yua José mà ní sanduu Matatías; te yua Matatías nì sanduu Amós; te yua Amós nì sanduu Nahum; te yua Nahum nì sanduu Esli; te yua Esli nì sanduu Nagai; ");
INSERT INTO mitNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","te yua Nagai nì sanduu Maat; te yua Maat nì sanduu inga Matatías; te yua Matatías mà nì sanduu Semei; te yua Semei nì sanduu inga José; te yua José mà ní sanduu Judá; ");
INSERT INTO mitNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","te yua Judá nì sanduu Joana; te yua Joana nì sanduu Resa; te yua Resa nì sanduu Zorobabel; te yua Zorobabel nì sanduu Salatiel; te yua Salatiel nì sanduu Neri; ");
INSERT INTO mitNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","te yua Neri nì sanduu inga Melqui; te yua Melqui mà ní sanduu Adi; te yua Adi nì sanduu Cosam; te yua Cosam nì sanduu Elmodam; te yua Elmodam nì sanduu Er; ");
INSERT INTO mitNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","te yua Er nì sanduu Josué; te yua Josué nì sanduu Eliezer; te yua Eliezer nì sanduu Jorim; te yua Jorim nì sanduu inga Matat; ");
INSERT INTO mitNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","te yua Matat mà ní sanduu inga Leví; te yua Leví mà ní sanduu Simeón; te yua Simeón nì sanduu inga Judá; te yua inga Judá mà ní sanduu inga José; te yua inga José mà ní sanduu Jonán; te yua Jonán nì sanduu Eliaquim; ");
INSERT INTO mitNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","te yua Eliaquim nì sanduu Melea; te yua Melea nì sanuu Mainán; te yua Mainán nì sanduu Matata; te yua Matata nì sanduu Natán; ");
INSERT INTO mitNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","te yua Natán nì sanduu David; te yua David nì sanduu Isaí; te yua Isaí ni sanduu Obed; te yua Obed nì sanduu Booz; te yua Booz nì sanduu Salmón; te yua Salmón nì sanduu Naasón; ");
INSERT INTO mitNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","te yua Naasón nì sanduu Aminadab; te yua Aminadab nì sanduu Aram; te yua Aram nì sanduu Esrom; te yua Esrom nì sanduu Fares; te yua Fares nì sanduu inga Judá; ");
INSERT INTO mitNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","te yua Judá mà ní sanduu Jacob; te yua Jacob nì sanduu Isaac; te yua Isaac nì sanduu Abraham; te yua Abraham nì sanduu Taré; te yua Taré nì sanduu Nacor; ");
INSERT INTO mitNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","te yua Nacor nì sanduu Serug; te yua Serug nì sanduu Ragau; te yua Ragau nì sanduu Peleg; te yua Peleg nì sanduu Heber; te yua Heber nì sanduu Sala; ");
INSERT INTO mitNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","te yua Sala nì sanduu Cainán; te yua Cainán nì sanduu Arfaxad; te yua Arfaxad nì sanduu Sem; te yua Sem nì sanduu Noé; te yua Noé nì sanduu Lamec; ");
INSERT INTO mitNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","te yua Lamec nì sanduu Matusalén; te yua Matusalén nì sanduu Enoc; te yua Enoc nì sanduu Jared; te yua Jared nì sanduu Mahalaleel; te yua Mahalaleel nì sanduu inga Cainán; ");
INSERT INTO mitNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","te yua Cainan mà ní sanduu Enós; te yua Enós nì sanduu Set; te yua Set nì sanduu Adán; te yua Adán nduú Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Daaní, (nì nsihi nì cuhiì Jesús) nì quee‑ya ladu yùte Jordán, chitu anima‑yà Espíritu Ìì xí Dios. Dandu nihí Espíritu Ìì mà‑yá nì sàhàn ñà‑coo‑ya yucù dàná. ");
INSERT INTO mitNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ùì dico quìvì nìsa ìa‑ya yucán, te nì cuni ñà‑malu dacà‑síyâ, (doco cónì cúndéé‑sî). Te inii tiempu mà nì ìa dòcó‑yà. Daaní, na ní yàha quìvì mà, dandú nì xìhì‑yà doco. ");
INSERT INTO mitNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Te nì cachi ñà‑malu xì‑yá: ―Nú ndisa Dèhemanì Dios nduu‑ní, dandu cachì‑ní xì yùù yohó ni nándúá pan cuxi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dandú nì cachi Jesús xì‑sí: ―Còó, vàchi dohó cachí nùù tutu ìì: “Màdì cuisì pan cutiacu nèhivì; còó, vàchi xiñuhu cucumi stná‑nè nsidaa palabra ìì cachí Dios”. ");
INSERT INTO mitNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Daaní, nì saca‑sìyá cuàhàn‑si xi‑yá dìnì iin yucù ducún, te nì dàcùní‑siyá nsidanicuú ñuu iá ñuhìví; iin ratu tii, te sànì dàcùní‑siyá nsidaámà. ");
INSERT INTO mitNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Dandu cachí‑si xi‑yá: ―Vàtùni dacútâhvìˊ mii‑ní nsidaa ñuu yucán ñà‑dandacu‑ní nùá, te nìhì stná‑ní nsidaa ñà‑vico icúmíâ, vàchi ndahí sà‑ìá nsidaájàn, te dandacúí nùá, te anà‑ni nì cui cudíì inì dacútâhvìˊ ñà‑dandacú‑né nùá. ");
INSERT INTO mitNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ñàyùcàndùá nú ni mácuììn sìsì‑ní nùí, te cahvi‑ní yùhù, dandu dacútâhvìˊ mii‑ní nsidaájàn. ");
INSERT INTO mitNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Dandu nì cachi Jesús xì‑sí: ―Còó, vàchi dohó cachí nùù tutu ìì: “Cuisì mii Stoho‑ndà Dios ndiá ìcà‑ndà cahvi‑nda, te cunucuachi‑nda nùù‑xí”. ");
INSERT INTO mitNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Daaní, nì saca‑sìyá cuàhàn‑si xi‑yá ndè ñuu Jerusalén. Yucán nì chicoo‑sìyá ndè dìnì veheñùhu cahnú, te nì cachì‑si xi‑yá: ―Nú ndisa Dèhemanì Dios nduu‑ní, dandu dandiachi‑ní mii‑ní, ");
INSERT INTO mitNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","vàchi ducán cachí nùù tutu ìì: Icúmí Dios dandacú‑yá nùù ángel xi‑ya ñà‑cundiaa‑nè mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Te cachí stná tutu mà: Icúmí ángel mà natnii ndahà‑né mii‑ní ñà‑màsà máquìhi sahà‑ní ni‑iin yùù. ");
INSERT INTO mitNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Dandu nì cachi Jesús xì‑sí: ―Cachí stná tutu ìì: “Màsà quídá canúú‑ndá ñà‑có‑cùní Stoho‑ndà Señor”. ");
INSERT INTO mitNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Dandu na ní nsihi ñà‑nì cunì‑si dacà‑síyâ, dandu nì nacoo chii‑síyâ cuàhàn‑si. ");
INSERT INTO mitNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Daaní, mànuhù‑yá ladu Galilea, chitu‑yá poder xi Espíritu Ìì xí Dios. Te nì xinitnùhu nèhivì sàhà‑yá inicutu ladu yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Te nì xìcanuu‑ya nì nacàhin‑ya nsidaa veheñùhu ñuu ladu yucán, dacuahá‑yá nèhivì. Te nsidaa‑né, nì ndenihi vàha‑neyà. ");
INSERT INTO mitNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Dandu nì nasaa‑yà ñuu Nazaret ndé nì sahnu‑ya. Te na ní sàà quìvì descansu, dandu nì sàhàn‑yà veheñùhu yucán, vàchi ducán nduú estilu xi‑ya. Te nì ndacuiin‑yà ini veheñùhu ma cuàhàn‑yà cahvi‑ya (tutu ìì) cunini nèhivì mà. Te nì sàha iin nèhivì‑yá tutu nì tiaa profeta Isaías nì sacahàn cuenta xi Dios sànaha. Dandu nì nacuna‑ya tutu mà nì nanducu‑yá iin lugar, te dohó cachí ndé nì ndacùhun‑ya: ");
INSERT INTO mitNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Fuerte inácáá Espíritu Ìì xí Dios ini anímè, vàchi sànì sàha‑ya yùhù chuun ìì cachitnùhi ñà‑vàha ndiaha xi nécuàchì ndahví, daaní, vàxi stnáì ñà‑càhìn xì ana xíndoo tnùnsí ini, dandu cahnde ini‑nè sàhámà. Te vàxi stnáì cachitnùhi xì ana có‑ndòó libre ñà‑vàtùni caquee‑ne libre quide; te nècuàchì cuaá, vàtùni natùi stná nùù‑né quide, xì nècuàchì yáha tnùndoho, vàtùni càcu ndisa‑ne nùámà quide. ");
INSERT INTO mitNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Te vàxi stnáì cachì xì nsidaa nèhivì (ñà‑vitni nduú) meru tiempu nàcùndoo vàha‑ne xì Stoho‑ndà Señor. ");
INSERT INTO mitNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Daaní, nì nacadi Jesús tutu mà, te nì naxiconihí‑yáñà nùù tiàa xinúcuáchí yucán. Dandu nì sàcòo‑ya, te nsidaa nèhivì ndoó veheñùhu yucán, indéhe váha‑neyà. ");
INSERT INTO mitNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dandu nì cachi‑yà xì nsidaa‑né: ―Vichi na meru nì inini‑nsia palabra nì cahvi nùù‑nsiá jaàn, ñà‑sànì cuu ndisa nduá, (te quidé nacua cacháˋ). ");
INSERT INTO mitNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Te nsidaa nèhivì yucán, nì ndenihi vàha‑neyà, te nì ndulocó‑nè, vàchi yáha ga ndiaha cáhàn‑yà. Doco cachí stná‑nè iin‑ne xì inga‑nè: ―¿Amádi dèhe José nduú nècuàchì yohó? ");
INSERT INTO mitNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Dandu nì cachi‑yà xì‑né: ―Ádi cuáhàn‑nsià cachi‑nsià xìˊ nacua cachí dichu: “Nú cuhí‑nî, te nduu‑ní doctor, dandu ¿índù chuun có‑dàndúvàha‑ní mii‑ní?” Vàchi sànì xinitnùhu‑nsia nansa nì quide milagru ñuu Capernaum, ñàyùcàndùá ádi cuáhàn‑nsià cachi‑nsià xìˊ ñà‑xìñùhù quida stnáì milagru mà ñuu‑ndà yohó nacua nì quide yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dandu nì cachi tu‑ya: ―Ñà‑ndáà nduá, ni‑iin tiàa nì nìhì chuun cáhàn cuenta xi Dios, có‑quìdáñúhú nècuàchì ñuu‑nè mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Doco cunini‑nsia palabra ndàcuisì yohó: na ní sanduu tiempu xi Elías sànaha, te cónì cùún dàvì ùnì cuìà dava, dandu fuerte nì quixi tnama inicutu ñuu‑ndà Israel yohó, te ndoó cuàhà nècuàchì ñahà nì xìhì iì‑xí ladu xi‑nda, ");
INSERT INTO mitNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","27","doco ni‑iin‑ne cónì níhìtáhvì‑né sàà Elías vehe‑ne. Còó, iin nècuàchì cuaán inga ñuu nani Sarepta yatni ñuu Sidón, divi nì nìhìtáhvì sàà nècuàchìmà vehe‑xi. Daaní, stná tiempu xi profeta Eliseo, mate ndoó cuàhà ana cuhí cuèhè lepra ñuu‑ndà Israel yohó, doco ni‑iin‑ne cónì dándûvàha Eliseo‑nè, cuisì iin nècuàchì inga ñuu Siria nani Naamán ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Daaní, nsidaa nèhivì ndoó veheñùhu yucán, yáha ga nì caxidà ini‑nè ñà‑nì cachi‑yà ducán. ");
INSERT INTO mitNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ñàyùcàndùá, nì ndacuìta nsihi‑ne, nì tavà‑néyà iladu ñuu mà. Te sàhà‑ñá dìnì yucù indúhá, ñàyùcàndùá nihí‑néyà nì casaà ndé iá tahvì, cuàhàn‑nè dandiachi‑néyà nì cùí. ");
INSERT INTO mitNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Doco nì yàha uun‑ya mahì nsidaa‑né cuàhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dandú nì sàà‑yà ñuu Capernaum iá ladu Galilea, te yucán nì dàcuàhá‑yá nèhivì sáhàn veheñùhu quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Te nècuàchìmà, nì ndulocó‑nè sàhà ñà‑ndùá dacuahá‑yánè, vàchi chináhá‑yà nahi ana cusáhnû. ");
INSERT INTO mitNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Te mahì nèhivì ndoó ini veheñùhu yucán nìsa ìa iin tiàa inácáá iin ñà‑malu anima‑xi. Te fuerte nì ndàhì ndee‑né, ");
INSERT INTO mitNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","cachí‑nè: ―¡Nacoo‑ní nsiùhù! ¿Ndíà cunduu‑ní nsiùhù, Jesús de Nazaret? ¿A váxi‑ní dandáñúhú‑nî nsiùhù nduá? ¡Yùhù ináhî mii‑ní! ¡Ana ìì nì quixi nùù Dios nduu‑ní! ");
INSERT INTO mitNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dandu ní sadi Jesús nùá, cachí‑yà: ―¡Màsà cáhùn, te quee cuahán! ¡Nacoo tiàa yohó! Dandu indéhe nsidaa nèhivì yucán, te nì nàcasàn tiàa ma nì quida ñà‑malu, te nì quee‑sì cuàhàn‑si, cónì dánâcuèhè‑siné. ");
INSERT INTO mitNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ñàyùcàndùá nì ndulocó sàstnùhù nèhivì ndoó yucán, cachí‑nè iin‑ne xì inga‑nè: ―¡Yáha ga fuerte palabra xi nècuàchì yohó! Vàchi na dandacú iin ana nì nìhì chuun cahnú, ducán dandacú‑né nùù ñà‑malu, te fuerza queá cuàhàn. ");
INSERT INTO mitNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ñàyùcàndùá, nì xìtià razón sàhà‑yá inicutu ladu yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Daaní, na sánì quee‑ya veheñùhu yucán, dandu cuàhàn‑yà vehe Simón. Te yucán indúhu dìdo‑ne ñahà; cuhí vàha‑ne, fuerte quidá yòcò xì‑né. Dandu nì sacundahví nèhivì yucán ñà‑nì quidá‑yá favor chindee‑yá nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ñàyùcàndùá nì nacahnù ndee‑ya ladu dìnì‑né, te nì dàndàcú‑yá nùù yòcò mà ñà‑nì cúcuíàn luegu. Te divi ducán nì cuu. Vichi vichi nì ndacuiin nècuàchìmà nì quesaha‑né nì xinucuachi‑né nùù mii‑yá xì compañeru‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Daaní, na ní quècahnu orá, dandu nì casaca cuàhà nèhivì nècuàchì cuhí xi‑ne, nihí‑né nècuàchìmà nì sàà nùù‑yá, nsidanuu cuèhè ndohó‑né, ñàyùcàndùá nì chitàndòó‑yá ndahà‑yá dìnì iin iin‑ne, te ducán nì canduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nùù cuàhà nècuàchì cuhí nì caquee stná ñà‑malu, cána‑sì, cachí‑si xi‑yá: ―Dèhemanì Dios nduu‑ní. Dandu nì sadi‑yà nùù‑sí, cónì sáha‑ya càhàn gà‑si, vàchi ináhá‑sî Cristu nì quixi nùù Dios nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Daaní, na ní tùinuù (inga quìvì), nì quee cuaán‑yá cuàhàn‑yà iin xaan ndé còò nèhivì. Te nandúcú nèhivì‑yá nì casaà‑nè ndé iá‑yà, te nì xìcàn‑nè ñà‑màsà nácóó‑yánè, te cùhùn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Doco nì cachi‑yà xì‑né: ―Ndè cuàhà stná inga ñuu icúmî cùhìn cachitnùhi xì nèhivì razón ndiaha sàhà ñuhìví ìì xí Dios, vàchi sàhà chuun jaàn nì techuún Yuamánìˊ yùhù vàxi ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ñàyùcàndùá, ducán nì xìcanuu‑ya ladu Galilea nì nacàhin‑ya iin iin veheñùhu, te nì càhàn‑yà sàhù (xì nèhivì xínataca yucán). ");
INSERT INTO mitNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iin xichi nì nataca cuàhà sàstnùhù nèhivì (nùù‑yá), te yáha ga ndutnúú‑yá quìdá‑né, vàchi cuní‑nè cunini‑ne palabra xi Dios. Yuhù mar de Genesaret iín‑yá; ");
INSERT INTO mitNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","te nì xini‑yà yucán itá ùì lancha (mahì tècuìí mà), doco sànì caquee stohò‑nu, nacáté‑né ñunù xí‑né, vàchi tè‑tàvá siaca xínduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ñàyùcàndùá, nì nana‑ya nì quècahnu stná‑yà ini iin lancha yucán, Simón nani stohò‑nu. Dandu nì càhàn‑yà xì nècuàchìmà áma dácûxícá tii gá‑nènu cùhùn mahì tècuìí, te ducán nì quida‑ne. Dandu nì sàcòo‑ya ini lancha mà, te nì quesaha‑yá nì dàcuàhá‑yá nèhivì cuáhà mà. ");
INSERT INTO mitNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Daaní, nì nsihi nì dàcuàhá‑yánè, dandu nì cachi‑yà xì Simón: ―Vichi dacaca‑ní lancha xi‑ní dècuèndè ndé chicá cunú ñuhú tècuìí, te danuú‑nsiá ñunù xí‑nsiá, te tnii‑nsia siaca. ");
INSERT INTO mitNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Doco nì cachi Simón xì‑yá: ―Niùyacà sànì quidachuún‑nsí, te còò ni‑iin‑sì nì níhì‑nsí, Maestro. Doco vichi vàtùni danuú tú‑nsí ñunù xí‑nsí nacua cachí‑nî. ");
INSERT INTO mitNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Daaní, na ní dànùú tú‑né ñunù xí‑né, nì tùi cuàhà siaca, dècuèndè nì quesaha ndátà ñunù xí‑né ñà‑cuàhà guá‑si. ");
INSERT INTO mitNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ñàyùcàndùá nì quida‑ne seña nùù compañeru‑nè ndoó inga lancha ñà‑nì tnátuu stná nècuàchìmà chindee stná‑nè. Doco na ní caquesaa‑nè, nì chitu ndúì lancha mà puru siaca, sàmérù càhà‑nu ni cuí. ");
INSERT INTO mitNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na ní xini Simón Pedro nì cuu ducán, dandu nì sàcuììn sìsì‑né nùù‑yá, cachí‑nè: ―Nacoo‑ní yùhù, por favor, vàchi iin nèhivì cuáchi nduí, Señor mío ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Vàchi mii‑né xì nsidaa nècuàchì cutnáhâ xí‑nê, yáha ga nì ndulocó‑nè sàhà ñà‑cuàhà guá siaca nì catavà‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Te ducán stná dèhe Zebedeo nani Jacobo xì Juan, cuàhà gá nì ndulocó stná‑nè, vàchi iin‑ni compañeru xínduu‑ne xì Simón nùù chuun xi‑ne. Dandu nì cachi Jesús xì Simón: ―Màsà yúhî‑nî, vàchi quìvì nùù‑xí màdì gá siaca tavà‑ní; nèhivì icúmí‑nî tavà‑ní ñà‑quee‑ne (ichì malu). ");
INSERT INTO mitNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ñàyùcàndùá, nì dàtnátuu‑ne lancha xi‑ne nùù ñuhù íchî, te nsidaa‑né nì nacoo ìì‑né ñà‑ndùá icúmí‑nê, te nì tenchicùn‑nè mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Daaní, nì cuu iin xichi iá‑yà iin ñuu, te yucán iá stná iin tiàa ndoho‑xi cuèhè lepra. Te nècuàchìmà, nì xini‑nè yucán iín Jesús, ñàyùcàndùá nì sàcuììn sìsì‑né nùù‑yá nì tutuyuhu‑né nùù sàhà‑yá, te nì xìcàn tàhvì‑né nùù‑yá, cachí‑nè: ―Señor mío, nú cuní‑nî, vàtùni dandúvàha‑ní yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dandu nì dàcúhùn Jesús ndahà‑yá dìnì‑né, te nì cachi‑yà: ―Juùn. Vichi duha ni ndúvàha‑ní, cachíˋ xì‑ní. Dandu na momentu nì cachi‑yà ducán, nì quee cuèhè quida‑xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dandú nì sàcùnaha‑né nùù‑yá ñà‑màsà cáchí‑nè xì nèhivì, cuisì‑ní ni cúhùn‑nè nùù dùtù dacuní‑nè nècuàchìmà ìcà‑né (ñà‑sànì nduvàha‑ne), dandu nacuàha‑ne promesa nùù Dios, vàchi ducán cachí ley xi Moisés, te ducán cundaà stná ini nèhivì ñà‑sànì nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Doco còó, vihi gá más nì xìtià palabra sàhà‑yá, te cuàhà gá nèhivì nì nachitu nùù‑yá, cuní‑nè cunini‑ne cáhàn‑yà, te cuní stná‑nè nduvàha‑ne sàhà cuèhè quida‑xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Doco mii‑ya, nìsa quecuaán‑yá iladu ndé còò nèhivì, te yucán nì xìcàn tàhvì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Daaní, iin quìvì iá‑yà dacuahá‑yá nèhivì. Te yucán ndoó stná nècuàchì fariseu xì stná nècuàchì ley xi veheñùhu; nduú‑né nèhivì nì caquixi cuàhà ñuu ladu Galilea, xì stná ñuu cuachi ladu Judea xì stná ñuu Jerusalén. Te fuerte nì chindee Dios nì dàndúvàha Jesús cuàhà nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Daaní, yucán nì casaà gà stná itnii nèhivì nsida‑xi iin camilla indúhu iin nècuàchì nì dàñà íì cuerpu‑xi. Te nandúcú nècuàchìmà nansa dayáha‑ne nècuàchì cuhí xi‑ne ini vehe, te chinduhù‑né nècuàchìmà nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Doco cónì níhì‑né nansa quida‑ne ducán ñà‑chitu guá nèhivì ndoó. Ñàyùcàndùá, nì canana‑ne dìnìvèhé, nì nacanì‑nè teja, te nì dànùú‑né camilla mà dècuèndè ndé iín Jesús mahì nèhivì mà. ");
INSERT INTO mitNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Te na ní xini‑yà ñà‑cuàhà guá xíxinindisá nècuàchìmà mii‑yá, dandu nì cachi‑yà xì nècuàchì cuhí mà: ―Mii‑ní nècuàchì tiàa jaàn, xicáhnû inì sàhà cuàchi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dandu nècuàchì ley xi veheñùhu, xì stná nècuàchì fariseu, nì quesaha‑né nacání ini‑nè, te cachí‑nè entre mii‑né: “¿Índù chuun cachí guâ tè‑yòhó ducán? Mà ndóo ini Dios sàhà palabra cachí‑te, vàchi còò inga ana cui cuicahnú inì‑xi sàhà‑ndà, cuisì Dios”. ");
INSERT INTO mitNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","23","Doco Jesús, nì cundaà ini anima‑yà ñà‑ndùá nacání guâ ini cada iin iin nècuàchìmà, ñàyùcàndùá nì cachi‑yà xì‑né: ―¿Índù chuun nacání ini‑nsià ducán? Vichi cachi‑nsià xìˊ índù milagru nduú ñà‑chicá ùhì quida‑nda: a ñá‑cachi uun‑nda xì nècuàchì cuhí ñà‑xìcáhnû ini‑ndà sàhà cuàchi‑ne, te ò ñá‑cachi‑ndà xì‑né ni ndácuíín‑nè, te nacaca‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pues yùhù ana nduú Tnaha Nèhivì Ñuhìví, cuàhìn quide iñàha ñà‑cundaà ini‑nsià ñà‑ìcúmí ndise derechu cuicahnú inì sàhà cuàchi nèhivì ñuhìví. Dandu nì cachi‑yà xì nècuàchì cuhí mà: ―Vichi cachíˋ xì‑ní, ndacuiìn‑ní ndanihi‑ní camilla xi‑ní, te xuhun‑ní vehe‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vichi vichi nì ndacuiin nècuàchì cuhí mà, indéhe nsidaa nèhivì yucán; te nì ndanihi‑ne camilla xi‑ne, mànuhù‑né vehe‑ne ndeníhí vàha‑ne Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dandu yáha ga nì ndulocó nsidaa nèhivì mà, te nì ndenihi vàha stná‑nè mii‑yá, te yúhî stná‑nè, cachí‑nè: ―Mà cándísâ ini‑ndà ñà‑ndùá nì xini‑ndà vichi. ");
INSERT INTO mitNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Daaní, nì quee‑ya cuàhàn‑yà, te nì xini‑yà iin nècuàchì dachíyàhvi renta nani Leví, iá‑nè lugar ndé naquíhín‑né renta. Te nì cachi‑yà xì‑né: ―Nahà‑ní cunchicùn‑ní yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dandu nì ndacuiin‑nè nì nacoo nsihi‑ne nsidaámà, te cuàhàn stná‑nè xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Daaní, después nì quida‑ne iin vicò cahnú vehe‑ne ñà‑cañúhu‑né Jesús. Te yucán nì casaà stná cuàhà nècuàchì dachíyàhvi, xì cuàhà stná nèhivì ùún, te ndoó nsidaa‑né (xixí‑né) yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Doco nècuàchì ley xi veheñùhu xì stná nècuàchì fariseu, nì xitnùhu‑ne nècuàchì dacuahá‑yá, cachí‑nè: ―¿Índù chuun cutnáhâ‑nsiá xì nècuàchì dachíyàhvi jaàn xì stná dava ga nècuàchì cuáchi, te ndoó‑nsiá xixí tàcá‑nsià xì‑né? ");
INSERT INTO mitNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Dandu nì naxiconihí Jesús nùù nècuàchìmà, cachí‑yà: ―Màdì nècuàchì ndáa vàha xiñuhu xi ana quidatatna xi‑né. Còó; divi nècuàchì cuhí xiñuhu xi ana quidatatna xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yùhù, màdì nèhivì nihnú ndàcuisì inì‑xi vàxi càhàn xìˊ. Còó; nèhivì cuáchi vàxi nanduquí, áma naxicocuíìn ini‑nè sàhà cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Daaní, nì cachi nèhivì xì‑yá: ―Nècuàchì dacuahá Juan xì stná nècuàchì xídacuahá tè‑fariseu, xí‑inihiì nsidaa‑né ndoó dòcó‑nè, te nacuátú cuáhà‑né, doco nècuàchì dacuahá mii‑ní, còó. Có‑nàcóó‑né ñà‑ìtiácú‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Dandu nì cachi Jesús xì‑né: ―Nècuàchì ndoó vicò nandàhà, ¿a cúí cunihiì‑né cundoo dòcó‑nè nú ndoó‑né cutnáhâ‑né xì noviu? Còó. ");
INSERT INTO mitNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Doco vàxi iin quìvì mà cóó gá noviu nùù‑né, dandísá, tiempu yucán icúmí‑nê cunihiì‑né cundoo dòcó‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Dandu nì nacani stná‑yà xì‑né inga ejemplu, cachí‑yà: ―Sìcoto saa, mà ndátá‑ndáñâ quee iin pedazu tii ñà‑nacàhmá‑ndà ñà‑tùhú. Nú ducán ni quida‑nda, ñà‑sànì ndàtà sìcoto saa nduá, te ni mà ndúdává stná pedazu saa ma xi sìcoto tùhú, vàchi náhà‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Stná vinu, nú vinu saa nduá, dandu mà dáquêe nèhivì‑ñá ini itni iìn tuhú, vàchi nú ducán, cahnsià quida vinu saa ma, te ndàtà‑ñá, dandu cuìtià vinu mà, te cuchicuéhè stná itni iìn mà. ");
INSERT INTO mitNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ñàyùcàndùá, nú vinu saa nduá, dandu itni iìn sàà chívàha nèhivì‑ñá, te còò ni‑iñàha cuu xán, te ni stná itni mà. ");
INSERT INTO mitNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iin tiàa tùha coho vinu tuhú, có‑cùní‑te vinu saa, vàchi cachí‑te: “Ñà‑tùhú chicá vàha”. ");
INSERT INTO mitNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Daaní, iin quìvì descansu nì yàha Jesús mahì iin itu. Te nì quesaha nècuàchì dacuahá‑yá sáhnù‑nè sìcàyòcó trigu mà, te dacóyo‑ne nùnìá ini ndahà‑né, te saxí‑néà. ");
INSERT INTO mitNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Doco nì cacachi nècuàchì fariseu xì‑yá: ―¿Índù chuun quidá‑nsiá iin chuun có‑sâha ley xi‑nda quida‑nda quìvì descansu? ");
INSERT INTO mitNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dandu nì naxiconihí Jesús nùù‑né, cachí‑yà: ―¿A cónì càhví‑nsiá (nùù tutu ìì) ndé cacháˋ nansa nì quida David sànaha quìvì nì xìhì cuàhà‑né doco, mii‑né xì stná compañeru‑nè? ");
INSERT INTO mitNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ndè ini veheñùhu xi Dios nì quìhvi‑ne, nì tnii‑ne dìtà vídì ìì iá nùù Dios, te nì xixi‑neà, dècuèndè compañeru‑nè nì sàha stná‑nè, mate còò permisu cuxi‑nda dìtà mà, cuisì dùtù xixi xi ñà‑yùcán. ");
INSERT INTO mitNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Te nì cachi stná‑yà xì‑né: ―Yùhù ana nduú Tnaha Nèhivì Ñuhìví, dandacú stnáì sàhà nansa quida nèhivì quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Daaní, inga quìvì descansu nì quìhvi‑ya ini veheñùhu, te nì dàcuàhá‑yá nèhivì; te yucán iá stná iin tiàa sànì ìchì ndahà cuàhá‑xi. ");
INSERT INTO mitNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Te yucán xíndoo stná nècuàchì fariseu xì stná nècuàchì ley xi veheñùhu, xínàní‑nè mii‑yá, a cuáhàn‑yà dandúvàha‑ya tiàa ma, mate quìvì descansu nduá, vàchi nú ducán, dandu nìhì ndèè‑né daquée cuàchi‑ne dìquì‑yá cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Doco mii‑yá, ináhá‑yâ nansa nacání ini‑nè. Ñàyùcàndùá, nì cachi‑yà xì tiàa nì ìchì iin ndahà‑xìmà: ―Ndacuiìn‑ní, cuiin‑ní mahì nèhivì yohó. Te ducán nì quida nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dandu nì cachi Jesús xì nsidaa‑né: ―Yùhù cuníˋ cachi‑nsià xìˊ nansa ndíà ìcà‑ndà quida‑nda quìvì descansu. ¿Amádi chicá iá vàha quida‑nda ñà‑ìá viì, te màdìá ñà‑có‑ìá vàha? ¿Amádi chicá nsiha dacácu‑nda nèhivì quìvì mà, te màdìá cahnì stnàhà‑ndà? ");
INSERT INTO mitNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dandu nì xiconúù‑yá nùù nsidaa‑né, te nì cachi‑yà xì tiàa ma: Chitanini‑ní ndahà‑ní. Te ducán nì quida‑ne, te nì nduvàha dahuan. ");
INSERT INTO mitNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dandu nècuàchì nì xitnùhu yucán, yáha ga nì caxidà ini‑nè, te nì candatnuhu‑né índù modo cadi‑nè nùù Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Daaní, quìvì yucán nì quecuaán‑yá cuàhàn‑yà yucù, te niùyacà nì ìa‑ya yucán cáhàn‑yà xì Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na ní tùinuù nì cana‑ya nèhivì dacuahá‑yá, te nì nacàxin‑ya ùxìn ùì‑nè; nècuàchì apóstol cucumi chuun nùù‑yá cunduu‑ne nì cachi‑yà xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iin nècuàchìmà nani Simón, doco Pedro nì dàcúnání‑yânè; daaní, inga‑nè nani Andrés, divi ñani Pedro; te iá stná Jacobo, xì Juan, xì Felipe, xì Bartolomé, ");
INSERT INTO mitNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","xì Mateo, xì Tomás, xì Jacobo nduú dèhe Alfeo, xì stná inga Simón. El Celador cachí stná‑nè xì Simón mà. ");
INSERT INTO mitNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Daaní, iá stná ñani Jacobo nani Judas, xì stná Judas Iscariote, divi tiàa icúmí cahin xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Daaní, nì nuu‑ya dècuèndè iin xaan ndé chicá ndàà, te nì nataca nsidaa nècuàchì dacuahá‑yá nùù‑yá, mii‑né xì cuàhà gá stná nèhivì, xínduu‑ne nèhivì ladu Judea, xì nèhivì ñuu Jerusalén, xì nèhivì ñuu Tiro xì ñuu Sidón ndoó yuhù mar. Pues nsidaa nèhivì mà, nì casaà‑nè yucán, cuní‑nè cunini‑ne càhàn‑yà, te cuní stná‑nè nduvàha nècuàchì cuhí xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Stná nèhivì xíndoho quidá ñà‑malu, nì canduvàha stná nsidaa‑né nì quida‑ya. ");
INSERT INTO mitNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Te nsidaa nèhivì cuáhà mà, cuní‑nè dùcùn ndahà‑né ìcà‑yá, te nduvàha‑ne, vàchi fuerte iá milagru xi‑ya, vàtùni dandúvàha nsihi‑yanè. ");
INSERT INTO mitNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Daaní, nì indehè‑yá nsidaa nèhivì xínchicùn xì‑yá ndoó yucán, te nì cachi‑yà: ―Nansicáhán mii‑nsiá nècuàchì ndahví, vàchi sànì nìhìtáhvì‑nsiá ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Nansicáhán mii‑nsiá nècuàchì xíhì doco vichi, vàchi icúmí‑nsiâ sàà‑nsià ndenuu ini‑nsià. ’Nansicáhán mii‑nsiá nècuàchì sacú, (te ndoó‑nsiá tnùnsí ini) vichi, vàchi icúmí‑nsiâ sàà‑nsià cudiì cuáhà ini‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Nansicáhán stná‑nsià na cahíchì ini nèhivì‑nsiá, te nacóó dahuun‑ne mii‑nsiá, te ò cánàhá‑nè daquée cuàchi‑ne dìquì‑nsiá sàhà yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Quìvì cuu xi‑nsiá ducán, dandu contentu ni cúndóó‑nsiá, te cudiì ini‑nsià, vàchi iin ñà‑vàha cahnú cucumi‑nsiá ndè gloria. Te nú quidá quini nèhivì xì‑nsiá vichi, dandu nsinuu inì‑nsia ñà‑divi ducán nìsa quida stná xìì‑né xì nècuàchì nìsa cahàn cuenta xi Dios sànaha. ");
INSERT INTO mitNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Doco mii‑nsiá nècuàchì cuìcà, ¡ndahví‑nsià! vàchi mate iin vida vàha icúmí‑nsiâ vichi, doco después mà níhì gá‑nsià ni‑iñàha. ");
INSERT INTO mitNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Te ¡ndahví stná mii‑nsiá nècuàchì xixí tnaha guá vichi! vàchi icúmí sàà iin quìvì tnaha inì‑nsia. Te mii‑nsiá nècuàchì cudíì guá inì‑xi sàhà vida‑xi vichi, icúmí‑nsiâ cundoo‑nsia tnùnsí ini, te cuhuun ga inì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Te ¡ndahví stná mii‑nsiá nú ndeníhí vàha nsidanicuú nèhivì mii‑nsiá! vàchi divi ducán nìsa quida stná yohòtéhè nèhivì vichi, nìsa ndenihi vàha stná nsidaa‑né tètnùhù cachí cáhàn cuenta xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Yùhù cachíˋ xì nsidaa mii‑nsiá nècuàchì iníní vichi, xiñuhu‑ñá cuu inì‑nsia sàhà nèhivì xiní ùhì xì‑nsiá, te obra vàha quida stná‑nsià sàhà ana cahíchì ini xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Te càhàn viì stná‑nsià xì nèhivì xícàn chìhán dìquì‑nsiá; te càcàn tàhvì stná‑nsià nùù Dios sàhà nèhivì quidá quini xi‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Te nú ni caní iin tiàa iin ladu nùù‑nsiá, dandu danácuícó stná‑nsià inga ladu nùù‑nsiá; te nú candiáá iin tiàa sacú ndixí‑nsiá, te cuní stná‑te candiaa‑tè dùhnù‑nsiá, dandu màsà cuídáhán‑nsiâñà nùù‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nsidaa ana xícàn iñàha nùù‑nsiá, cuàha‑nsia nècuàchìmà, te nú ni cándiáá‑né iñàha xi‑nsia, màsà nándácàn gà‑nsiañà. ");
INSERT INTO mitNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nacua cuní mii‑nsiá quida nèhivì xì‑nsiá, divi ducán xiñuhu quida stná mii‑nsiá xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Vàchi nú cuisì nèhivì cuú inì‑xi sàhà‑ndà cuú stná ini‑ndà sàhà‑xí, dandu mà cuáha Dios premiu sàhájàn, vàchi ducán quidá stná ndéni nèhivì cuáchi nì cui, cuú ini‑nè sàhà nècuàchì cuú inì‑xi sàhà mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Te nú cuisì quida‑nda obra xì nèhivì quidá stná obra xì‑ndà, dandu mà cuáha Dios premiu sàhájàn, vàchi divi ducán xíquida stná ndéni nècuàchì cuáchi nì cui. ");
INSERT INTO mitNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te nú cuisì sáha too‑nda dìhùn nùù nèhivì ndiatu‑nda danáà xì nùù‑ndà, dandu mà cuáha Dios premiu sàhájàn, vachi ndè stná nèhivì cuáchi, ducán xíquida stná‑nè, sáha toó stnahá stná‑nè dìhùn, te naquíhín tú‑néà. ");
INSERT INTO mitNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ñàyùcàndùá, (cachíˋ xì‑nsiá), xiñuhu‑ñá cuu ini‑nsià sàhà nèhivì xiní ùhì xì‑nsiá, te quida stná‑nsià obra xì‑né, te cuàha toó stná‑nsiànè iñàha, te màsà cúníhnú ini‑nsià naquihin‑nsia dìhùn mà, dandu cahnú coo premiu xi‑nsia, te cunduu ndisa‑nsia dèhe Yua‑nda Dios iá dìquì‑xí ansivi, vàchi mii‑yá, quidá stná‑yà favor xì nèhivì mà túha naquimanì xì‑yá, xì stná nèhivì malu. ");
INSERT INTO mitNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ñàyùcàndùá, nacua cuhí ini Yuandiaha‑nsiá nsidaa nèhivì, divi ducán ndiá ìcà stná mii‑nsiá quida‑nsia, cuhi stná ini‑nsià nsidaa nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Màsà dácuídâ cuàchi tnahá‑nsiá, dandú mà dácuídâ cuàchi stná Dios mii‑nsiá. Màsà dáquêe cuàchi stnahá‑nsiá dìquì‑nsiá, dandu mà dáquêe cuàchi stná Dios dìquì mii‑nsiá. Te cuicahnú stnahá stná ini‑nsià sàhà‑nsiá, dandu cuicahnú stná ini mii‑yá sàhà‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","’Nú dacútâhvì stnahá‑nsiá iñàha, dandu icúmí stná‑nsià nìhìtáhvì‑nsiá (nùù mii‑yá), te ñà‑ndùá cuàha‑yansià cundua na ian xiin‑nda nùnì, te itácùha viì medida mà, ndè quidíníhní‑teá ñà‑quèe tnua, te sádi vàha‑tèá, dècuèndè chiyódo gá stná‑teá nùù‑ndà. Pues, ducán iá stná na níhìtáhvì‑nsiá nùù mii‑yá. Vàchi divi vara chitácùhá‑nsià icúmí stná‑nsià nacuitacùhá‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dandu nì nacani‑ya xì‑né iin ejemplu, te dohó nì cachi‑yà: ―Nècuàchì cuaá, ¿a vátùni dacúndéhe stnahá‑né ichì? ¿Amádi dácôyo nihni stnahá‑né ini xìchi? ");
INSERT INTO mitNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","’Cunaha‑nsiá, ni‑iin tiàa làcà dàcuàhá nùù iin maestru, màdìá chicá ndiaá‑nè nùù maestru xi‑ne mà. Còó. Doco nú sànì nsihi nì cutùha vàha‑ne, dandísá, nahi maestru‑mà cunduu stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Màsà (cuítnùhu tnahá‑nsiá), vàchi nú jaan, dandu queámà na ian nandúcú iin tiàa iin xèhè tii inácáá nduchìnúù ñanìtnaha‑ne. Doco ini nduchìnúù mii‑né inácáá stná iin ñà‑chicá cahnú na iin sì‑ndùhú yutnù, te có‑quìhín casu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Màsà (cuítnùhu tnahá‑nsiá, cachíˋ), vàchi ducán queámà na ian cachí iin‑nsia xì iin ñanìtnaha‑nsia: “Nacoo‑ní yùhù taví xèhè tii inácáá dacúcuíín nduchìnúù‑ní”. Doco nècuàchì cachí ducán, dananí uun‑ne ndiaá ndisa‑ne, vàchi inácáá stná iin ñà‑càhnú nduchìnúù mii‑né, te có‑quìhín casu‑nè. Dihna xiñuhu tavà‑né ñà‑jaàn nùù mii‑né, dandu vàtùni cutùi viì nùù‑né ñà‑tavà‑né xèhè tii inácáá nduchìnúù ñanìtnaha‑nemà. ");
INSERT INTO mitNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Nú iá vàha iin yutnù fruta, mà cuáha‑nù fruta chicuéhè. Te iin yutnù iá cuèhè‑xi, mà cuáha stná‑nu fruta vàha. ");
INSERT INTO mitNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Vàchi sàhà fruta‑numa cundáà ini‑ndà, a yútnu vàha nduú‑nu, ò á coó. Na iin yutnù ìñù, de por sí, có‑càná sì‑higu nùù‑nú. Stná sì‑uva, mà cuídá‑ndá quisì mà nùù iin nducu yòhò ìñù. ");
INSERT INTO mitNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","(Te ducán iá stná xì mii‑nsiá.) Iin nècuàchì vàha, cuàhà ñà‑vàha ñuhú ini anima‑nè; te ñàyùcàndùá, divi palabra vàha ma nduá cachí‑nè. Doco iin nècuàchì malu, cuàhà ñà‑chìcuéhè ñuhú ini anima‑nè, ñàyùcàndùá ñà‑chìcuéhè nduá cachí stná‑nè. Vàchi ñà‑ñùhú chitu ini anima‑ndà, divi nduá cáhàn‑ndà sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Mii‑nsiá, “Stoho‑nsì Señor” cachí‑nsià xìˊ, doco ¿índù chuun có‑càhvì‑nsiá ñà‑ndùá cachíˋ xì‑nsiá? ");
INSERT INTO mitNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Vichi cuàhìn nacani xì‑nsiá sàhà nèhivì quíhvi ichì yùhù, te iníní víi‑né palabra xi, quidá‑néà cumplir. Nècuàchì xíquida ducán, queámà na ian nì quida iin tiàa na ní quidayucun‑nè vehe‑ne, cunú nì sate‑ne ndè nì natùi cavà, dandu nì chicaa‑nè cimientu xan. Daaní, después nì quixi tèñuhu cuáhà, nì xìnu‑tè nì dùcùn‑te ndè ìcà vehe ma, doco cónì ndùáˋ, vàchi nùù cavà indúhá. ");
INSERT INTO mitNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","’Doco nèhivì iníní uun xi ñà‑ndùá cachíˋ, te có‑quìhín casu‑nè sàhà‑ñá, ducán cuu stná xì‑né na ian nì quida inga tiàa, nì quidayucun‑nè vehe‑ne nùù ñuhù ùún, còò cimientu xan. Dandu nì xìnu stná tèñuhu nì dùcùn‑te ndè ìcà vehe ma, te vichi vichi nì ndua ìá; nì chàhmà dahuan ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Daaní, nì nsihi nì càhàn‑yà nì inini nsidaa nèhivì yucán, dandu cuàhàn‑yà ñuu Capernaum. ");
INSERT INTO mitNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Te yucan iá iin tiàa nduú capitán dandacú, te icúmí‑nê iin mozo mànì cuáhà nùù‑né, doco sànì quicuehè nècuàchìmà, meru cucáhví‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ñàyùcàndùá, na ní xinitnùhu capitán mà sàhà‑yá, dandu nì cana‑ne itnii nècuàchì sahnú dandacú nùù nècuàchì raza Judea, te nì techuún‑né nècuàchìmà ñà‑cùhùn‑nè cuacundahví‑nè nùù‑yá ñà‑quixi‑ya dandúvàha‑ya mozo mà. ");
INSERT INTO mitNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ñàyùcàndùá, nì casaà nècuàchì sàhnùmà nùù‑yá, te nì casacundahví‑nè nùù‑yá, cachí‑nè: ―Quida sacù‑ní favor xì capitán mà, vàchi vàha ndisa ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Cuú ini‑nè sàhà nèhivì raza‑ndà. Te nì chindee stná‑nè nì cuyucun iin veheñùhu xi‑nsi. ");
INSERT INTO mitNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Daaní, nì sacatnahá‑yá xì nècuàchìmà cuàhàn‑yà. Te na sá‑ìtúú‑yá sàà‑yà vehe capitán mà, dandu vàxi iin ùì amigo xi‑ne, nihí‑né razón xi nècuàchìmà vàxi nùù‑yá, te dohó cacháˋ: ―Señor mío, màsà dándóhô gà‑ní mii‑ní sàhí, vàchi có‑nâtùi yàha‑ní vehi. ");
INSERT INTO mitNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni có‑nâtùi stnáì tnàtui ndé iá mii‑ní. Cuisì icúmí‑nî cachì‑ní, dandu nduvàha mozo xi. ");
INSERT INTO mitNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","(Ináhî), vàchi iá inga nèhivì dandacú nùù yùhù, te yùhù dandacú stnáì nùù tè‑xínduu soldadu xi; te nú cachíˋ xì iin‑tè: “¡Cuahán!” dandu cùhùn‑te; te ò nú cachíˋ xì ingà‑te: “¡Naha!” dandu quidá stná‑teá; te ò nú cachíˋ xì mozo xi: “Dohó quido”, dandu quidá stná‑teá. Ducán cachí razón xi capitán mà. ");
INSERT INTO mitNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na ní nsihi nì inini Jesús razón mà, dandu nì ndulocó‑yà sàhà nècuàchìmà, te nì nacuico‑yá yàtà‑yá nì indehè‑yá nècuàchì nchícùn mà, te nì cachi‑yà xì‑né: ―Cunaha‑nsiá, có‑xìníˋ ni‑iin nèhivì raza‑ndà Israel xiníndísâ vàha guá nahi capitán yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dandu amigo xi capitán mà, mànuhù‑né vehe nècuàchìmà, te nì xini‑nè sànì nduvàha mozo cuhí mà. ");
INSERT INTO mitNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Daaní, nì yàha iin tiempu, te cuàhàn‑yà inga ñuu nani Naín, te cuàhà nècuàchì dacuahá‑yá xínchicùn xì‑yá, te cuàhà stná nèhivì dava ga. ");
INSERT INTO mitNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Te sà‑ìtúú‑yá sàà‑yà yehè cahnú ndé quíhvi‑nda ñuu mà, te nì xini‑yà yucán vàxi nèhivì xínsida xi iin nsìi. Vàxi stná dihi nsìi ma, cutnáhâ‑né xì cuàhà nèhivì. Sànì xìhì stná iì nècuàchì ñahà mà, te mindaa dèhe‑ne nduú nsìi cuàhàn cundùxin vichi. ");
INSERT INTO mitNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Doco na ní xini Stoho‑ndà Señor nècuàchìmà, nì cuhi ini‑yànè, te nì cachi‑yà xì‑né: ―Màsà cuácú gà‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dandu nì tnàtuu‑ya nùù caja mà, te nì chituu‑ya dìnìndàhá‑yà ìcà‑nú. Ñàyùcàndùá, nì cucuìta tiàa xínsida xi‑nú. Dandu nì cachi‑yà xì nsìi ma: ―Ndacuiìn‑ní, cachíˋ xì‑ní, xu. ");
INSERT INTO mitNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dandu nsìi ma, nì ndacòo‑ne nì quesaha‑né nì nacahàn‑nè. Dandu nì cachi Jesús xì dihi‑né: ―Yohó iá dèhe‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dandu nì cayùhí nsidaa nèhivì mà, te nì candenihi vàha‑ne Dios, cachí‑nè: ―Vichi ndisa, yohó sànì ndecunu ana vàxi cáhàn razón ndiaha xí Dios, te cuàhà sàstnùhù ñà‑ndùá quidá‑yá. Te dava ga‑nè xícachi stná‑nè: ―Sànì indehè ndahví Dios ndohó tè‑ndùú nèhivì xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ñàyùcàndùá, nì xìtià palabra sàhà Jesús inicutu ladu Judea yucán, xì inicutu stná ñuu chicá xica. ");
INSERT INTO mitNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Daaní, nècuàchì dacuahá Juan, nì nacani‑ne xì nècuàchìmà nsidaa ñà‑ndùá quidá Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ñàyùcàndùá, nì cana Juan mà ùì tiàa dacuahá‑né, te nì techuún‑né nècuàchìmà ñà‑cùhùn‑nè nùù‑yá ndàcàtnùhù‑né nùù‑yá a ndísá mii‑yá nduú ana ndiaha icúmí quesaa, te ò inga ana vàxi cundiatu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ñàyùcàndùá, cuàhàn nècuàchìmà ndé iá‑yà, te nì cachi‑nè xì‑yá: ―Juan Bautista nì techuun‑xi‑nsí vàxi‑nsi yohó ñà‑ndàcàtnùhù‑nsí nùù‑ní, ¿a divi mii‑ni nduú ndisa ana ndiaha icúmí quesaa, te ò inga ana vàxi cundiatu‑nsi? ");
INSERT INTO mitNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Daaní, divi hora xíndoo nècuàchìmà yucán nì dàndúvàha‑ya cuàhà nècuàchì cuhí. Te nì nduvàha stná cuàhà nècuàchì ñuhú ñà‑malu inì‑xi, xì cuàhà stná nècuàchì cuaá nì dànátùi‑ya nùù‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dandu nì cachi‑yà xì tiàa nì caquesaa mà: ―Cuahán‑nsià cachitnùhu‑nsia xì Juan sàhà ñà‑ndùá nì xinì‑nsia yohó, xì ñà‑ndùá nì inini‑nsia, te cachi‑nsià xì‑né nansa nì cuu nì natùinuù nècuàchì cuaá, te nì nacaca stná nècuàchì xicácuéhê, te nì nduvàha stná nècuàchì ndohó cuèhè lepra, te nì nìhì stná nècuàchì dòhò nì natiacu tùtnù‑né; stná nèhivì nì xìhì, nì natiacu stná‑nè. Te nècuàchì ndahví, sànì nìhìtáhvì stná‑nè cunini‑ne razón ndiaha xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ñàyùcàndùá, nú cudíì ini nèhivì modo xi, dandu contentu ni cúndóó‑né ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Daaní, na sàmànuhù nèhivì nì caquixi nùù Juan mà, dandu nì càhàn‑yà xì nèhivì cuáhà ndoó yucán; dohó nì cachi‑yà xì‑né sàhà Juan: ―Na ní caquee‑nsia ñuu‑nsià cuàhàn‑nsià yucù cundehè‑nsiá Juan, ¿a cuáhàn‑nsià cundehè‑nsiá iin nèhivì (tùha dàma dìnì‑xí) na iin yutnù ndóyo quidá tàchì? (Còó.) ");
INSERT INTO mitNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Te nú coó, dandu ¿nansa iá‑nè cahan‑nsiá? ¿A iin nèhivì ndixí vico nduú‑né cahan‑nsiá? Còó, vàchi nèhivì ndixí vico, te xíndoo‑ne vicò nsìquívì, puru vehe rey xíndoo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pues nú màdì ducán, dandu ¿nansa iá nècuàchì cuàhàn‑nsià cundehè‑nsiá? ¿A iin profeta cáhàn cuenta xi Dios nduú‑né? Pues jaan. Doco màdì cuisì profeta nduú‑né, chicá más ndiaá‑nè, ");
INSERT INTO mitNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","vàchi divi nècuàchìmà cáhàn tutu ìì sàhà‑xí ndé cachí Dios: Cuàhìn techuín iin tiàa cùhùn, te dihna‑ne yàha‑ne càhàn‑nè xì nèhivì ñà‑ndùú razón xi, te ducán nsida viì nècuàchìmà anima‑nè, na ian nduviì iin ichì, dandu después yàha stná mii‑ní (Cristu), cachí Dios nùù tutu ìì mà. ");
INSERT INTO mitNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Te yùhù, cachíˋ xì‑nsiá, nùù nsidaa nèhivì nì tùinuù ñuhìví, còò inga profeta chicá nì quida ndiaha nùù Juan Bautista. Còò ana inga ndudává xí‑nê. Doco cachí stnáì xì‑nsiá, chicá ndiaha coo xi ana cuàhàn cuni tiempu cusahnú Dios ñuhìví yohó, mate nèhivì ùún nduú‑né ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Daaní, nècuàchì dachíyàhvi, xì nsidaa stná nèhivì, nì naquimanì‑né Dios sàhà ñà‑ndùá nì cachi‑yà, vàchi cuàhà‑né sànì quida iì Juan‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Doco nècuàchì fariseu xì nècuàchì ley xi veheñùhu, nì cahíchì ini‑nè palabra nì cachi Dios sàhà‑né, vàchi cónì sáha‑ne cuhiì‑né quida Juan. ");
INSERT INTO mitNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Daaní, nì cachi tu Stoho‑ndà Señor: ―Cuàhìn cachì xì‑nsiá nansa quidá nèhivì tiempu vichi. Dohó quidá‑né na quidá ñà‑cuati ndoó idádiquí ini iin ñuu, dava caná xì tnaha, cacháˋ: “Siví‑nsí, doco nsiohó, có‑ìtásáhá‑ndâ; daaní, xitó tàsí‑nsí, doco nsiohó, có‑sàcù‑ndá”. ");
INSERT INTO mitNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","(Te ducán iá sàhà Juan Bautista xì yùhù), vàchi nì quixi Juan mà, nìsa ìa‑ne yohó, cónì sáxíxí‑né comida vàha, ni cónì sáxíhí stná‑nè (vinu); ñàyùcàndùá, nì cachì‑nsia sàhà‑né: “(Tè‑loco nduú‑te), ádi sánì cundee ñà‑malu nùù‑té”. ");
INSERT INTO mitNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Daaní, nì quesaa stná yùhù ana nduú Tnaha Nèhivì Ñuhìví, te tùha stnáì cuxi comida vàha, te xihí stnáì (vinu), doco cachí‑nsià sàhí ñà‑yáha ga ndadí, te cachí stná‑nsià ñà‑tùhe coho cuahí, dècuèndè iá vàha stnáì xì nècuàchì dachíyàhvi, xì stná nsidaa gá nèhivì cuáchi, cachí‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Doco cunaha‑nsiá, nú ndisa ñà‑nchìchí ndiaha nduá quidé, te xiní stná inga ana quidá stná ducán, dandu quidáñúhú stná‑nè yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Daaní, nì cànà‑yá cùhùn‑yà vehe iin nècuàchì fariseu ñà‑cutnahá‑yá xì‑né cuxi‑ne xì‑yá. (Ñàyùcàndùá, cuàhàn‑yà yucán), te nì yàha‑ya ini vehe nì sàcòo‑ya. ");
INSERT INTO mitNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Te ñuu yucán iá iin nècuàchì ñahà có‑quìdá sahnú. Te nì xinitnùhu nècuàchìmà sà‑cuàhàn Jesús vehe nècuàchì fariseu‑mà cuxi‑ya. Ñàyùcàndùá nì tnii‑ne iin quìdi tii nì cuyucun yùù finu nani alabastro; ñuhú tàtnà tnàmì quìdi ma, ");
INSERT INTO mitNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","te nihí‑néà cuàhàn ndé iá‑yà. Te nì sàcuììn‑nè yàtà‑yá yatni nùù sàhà‑yá, te sacú cuáhà‑né. Te ndutènúù‑némà nì dàndàxín‑né sàhà‑yá, dandu nì nsida ìchí‑nèà xì idìdínì‑né. Nì tutuyuhu stná‑nè sàhà‑yá, te nì dàcánúú‑né ñà‑tnami ma ìcà sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Doco nècuàchì fariseu nì cana xi‑yá mà, inì‑ni mii‑né nì nacani ini‑nè, cachí‑nè: “Nú ndisa iin nèhivì vàxi cuenta xi Dios nduú Jesús, dandu mà úhì cundaà ini‑nè sàhà nècuàchì ñahà tnií xi (sàhà‑né) ñà‑ndùú nècuàchìmà iin nèhivì cuáchi”. Ducán nì nacani ini nècuàchì fariseu mà. ");
INSERT INTO mitNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Doco Jesús, nì cachi‑yà xì‑né: ―Iá ñà‑ndùá cuníˋ cachì xì‑ní, Simón. ―Juùn, Maestro, cachì‑ní xìˊ ―nì cachi Simón mà. ");
INSERT INTO mitNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dandu nì cachi‑yà: ―Nì sandoo ùì tiàa, te ndúì‑nè, xí‑inihica‑né dìhùn nùù inga iin tiàa. Iin nècuàchìmà, iníhícá‑nê ùhùn cientu pesu, te inga‑nè, cutu ùì dico ùxìn pesu iníhícá‑nê. ");
INSERT INTO mitNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Doco ni‑iin‑ne, còò ni‑iñàha icúmí‑nê ñà‑danáà‑né. Ñàyùcàndùá, tiàa iníhícá‑nê nùù‑xìmà, nì dàndùtù‑né cuenta xi ndúì nècuàchìmà. Ñàyùcàndùá, vichi cachì‑ní xìˊ, ¿índù tiàa ma chicá cuàhàn cuu inì‑xi sàhà nècuàchìmà cahan‑ní? ");
INSERT INTO mitNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Dandu nì cachi Simón mà: ―Yùhù tuxí inì, nècuàchì chicá nì sanihica cuáhà mà, divi cunduu ana chicá cuú inì‑xi sàhà nècuàchìmà. Dandu cachí Jesús xì‑né: ―Sànì cachi vàha‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dandu nì ndacoto‑ya yàtà‑yá ndé iá nècuàchì ñahà mà, te nì cachi‑yà xì Simón mà: ―¿A xiní‑nî nècuàchì ñahà yohó? Na ní quesaì, te nì quìhvi vehe‑ní, còò tècuìí nì chìndánuu‑ní ñà‑ndoo sàhí; doco nècuàchì yohó, ndutènúù‑né nì dàndàxín‑né sàhí, te nì nsida ìchí‑nèà xì idìdínì‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Te mii‑ní, cónì tùtúyúhú‑nî yùhù na ní casàhú‑nî xí, doco nècuàchì yohó, dècuèndè hora nì quesaì, có‑nàcóó‑né ñà‑tùtúyúhú‑nê sàhí. ");
INSERT INTO mitNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Te mii‑ní, cónì (quìdáñúhú‑nî yùhù) ñà‑dacánúú‑nî aceite dìní. Doco nècuàchì yohó, tàtnà tnàmì sànì dàcánúú‑nê sàhí. ");
INSERT INTO mitNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ñàyùcàndùá, mate cuáhà cuàchi‑ne iá, doco ñà‑sànì nìhì‑né perdón sàhámà nduá, (náhà xìcà), vàchi cuàhà gá cuú ini‑nè (sàhí). Doco nú iyuhu cuàchi iá sànì nìhì nèhivì perdón sàhà‑xí, dandu chicá iyuhu cuú ini‑nè (sàhí). ");
INSERT INTO mitNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dandu nì cachi‑yà xì nècuàchì ñahà mà: ―Sànì xicahnú inì sàhà cuàchi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Doco nèhivì dava ga ndoó xixí xi‑yá yucán, nì nacani ini‑nè, cachí‑nè (entre mii‑né): ―¡Có‑ndùá ducán cachi Jesús ñà‑jaàn, vàchi mà cúí cuicahnú ini‑nè sàhà cuàchi‑nda! ");
INSERT INTO mitNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Doco Jesús, nì cachi‑yà xì nècuàchì ñahà mà: ―Sànì càcu‑ní ñà‑nì xinindisa‑ní. Vàtùni cùhùn‑ní, te contentu ni coo‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Daaní, nì quihin‑ya ichì cuàhàn‑yà nì nacàhin‑ya ñuu nahnú te ñuu cuati, cáhàn‑yà sàhù, cachítnùhu‑ya xì nèhivì ñà‑ndùú razón ndiaha sàhà ñuhìví ìì xí Dios. Te cutnáhâ stná‑yà xì nsì‑úxìn ùì nècuàchì dacuahá‑yá, ");
INSERT INTO mitNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","xì dava stná nècuàchì ñahà nì dàndúvàha‑ya. Dava‑ne, nìsa ñuhu ñà‑malu ini‑nè, te dava ga‑nè, cuèhè nì sandoho‑ne, doco nì dàndúvàha‑ya nsidaa‑né. Iin nècuàchì ñahà mà nani María Magdalena. Ùsà ñà‑malu nì tavà‑yá nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te inga‑nè nani Juana, ñahàdìhí Chuza, iin nècuàchì dandacú nùù biene xi rey Herodes. Te inga nècuàchì ñahà mà nani Susana, te cuàhà gá stná nècuàchì ñahà dava ga cutnáhâ xí‑yâ cuàhàn‑nè, chindéé‑nêyà, te quidá stná‑nè cooperar. ");
INSERT INTO mitNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Daaní, nì quesaa cuàhà nèhivì nì caquixi iin iin ñuu, nì nataca‑nè nùù‑yá. Te nì càhàn‑yà xì‑né, nì nacani‑ya xì‑né iin historia nduú ejemplu. Te dohó nì cachi‑yà: ");
INSERT INTO mitNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Nì ìa iin tiàa, te cuàhàn‑nè chihi‑ne. Te nì sate uun‑ne tata mà. Ducán nì quida‑ne, te dava‑ña nì còya mahì ichì. Te yucán nì sànihni nèhivì‑ñá; stná laa ndavá ansivi, nì saxì‑síâ. ");
INSERT INTO mitNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Te dava stná tata mà, nì còya nùù cavà. Te yucán nì xìtìa, doco nì ìchà, vàchi còò ndèhì. ");
INSERT INTO mitNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Te dava stná tata mà, nì còya mahì iñù, te iin‑ni nì sahnua xì‑ñá mà. Doco nì dàdáhviamà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Doco dava stná tata mà, nùù ñuhù vàha nì còya, te nì xìtià viìá; ndè ùhùn dico tantu nì cana ―nì cachi Jesús. Dandu fuerte nì cachi‑yà: ―¡Ni cúníní vàha nsidaa‑nsiá ñà‑ndùá cachíˋ! ");
INSERT INTO mitNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Después nì xìcàn tnùhù nècuàchì dacuahá‑yá nùù‑yá, cachí‑nè: ―¿Ndíà ndùá cuní cachi ejemplu nì nacani‑ní mà? ");
INSERT INTO mitNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Dandu nì cachi‑yà: ―Sànì sàhatahvì Dios mii‑nsiá ñà‑cundaà ini‑nsià sàhà ñuhìví ìì xí‑yá, mate antes nìsa ìa dèhámà. Doco nècuàchì dava ga, còó. Puru ejemplu nacání xì‑né sàhà‑ñá màsà cúnítnùhu‑ne, mate indéhe‑né, te màsà cúndáà ini‑nè, mate iníní‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Cunaha‑nsiá, ñà‑yòhó nduá cuní cachi ejemplu mà: Tata mà nduú nahi Palabra xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Te tata nì còyo mahì ichì mà nduú nahi nèhivì iníní palabra (xi‑ya), dandu vàxi ñà‑malu, te dacúxíó‑si palabra mà ini anima‑nè sàhá màsà cúníndísâ‑né, te càcu anima‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Daaní, tata nì còyo nùù cavà mà nduú nèhivì iníní xí palabra ìì, te luegu cudíì ini‑nè sàhámà. Doco nahi viu còò yohò‑xí nduú‑né, iin ratu tii xiníndísâ‑né, dandu na yáha‑ne tnùndoho, luegu nacóó‑né palabra mà. ");
INSERT INTO mitNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Daaní, tata nì còyo mahì iñù mà nduú nèhivì iníní xí palabra xi‑ya, doco cuàhà gá nacání ini‑nè sàhà vida xi‑ne ñuhìví yohó; cuú cuàhà ini‑nè sàhà biene xi‑ne, te cuàhà gá diversión có‑ìá viì nandúcú‑nê. Ñàyùcàndùá, ducán queá xì‑né na ian nì cuu xi viu mà, nì dàhvia nì quida iñù, vàchi có‑sâà‑nè quida‑ne ñà‑vàha nacua cuní Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Daaní, tata nì còyo nùù ñuhù vàha nduú nèhivì nihnú ndàcuisì inì‑xi; vàha anima‑nè, iníní‑né palabra vàha ma, te quidá ndisa‑neà cumplir, iin‑ni nchícùn‑nèà, te sàhámà nduú‑né nahi viu nì cana viì. ");
INSERT INTO mitNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Nú sànì nacahmi‑nda iin lámpara, mà chícání‑ndáñâ tìxi iin cazuela, ò tíxi iin cama. Còó, icúmíâ cuian ndé ducún ñà‑cutnuà nùù nèhivì yáha ini vehe. ");
INSERT INTO mitNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Cunaha‑nsiá, nsidaa ñà‑ìá dèhé, icúmíâ tùi vateá. Vàchi nsidaa ñà‑ndùá quidádèhé nèhivì, icúmíâ natùi claruà, te cunitnùhu nèhivì sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Cunini vàha‑nsia na sáha xi‑nsiá ichì váha, vàchi nècuàchì ñuhú (ñà‑vàha) inì‑xi, chicá más icúmí‑nê nìhìtáhvì‑né; doco nèhivì có‑ñùhú ndisa (ñà‑vàha) inì‑xi, mate tuxí ini‑nè iá iyuhá, doco nsidaájàn, icúmíâ cuxio nsiha. ");
INSERT INTO mitNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Daaní, nì sàà dihi‑yá xì ñani‑yà, doco mànìcùí quìhvi‑ne ndé iá‑yà sàhà‑ñá cuàhà guá nèhivì ndoó yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dandu nì cachi nèhivì xì‑yá: ―Cunaha‑ní, tùvèhè càˊ iín dihi‑ní xì stná ñanì‑ní; cuní‑nè càhàn‑nè xì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dandu nì cachi‑yà xì‑né: ―Nsidaa ana iníní xi Palabra xi Dios, te quidá ndisa‑neà, divi‑ne nduú nahi dihí, nahi ñanì, te nahi cùhe. ");
INSERT INTO mitNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iin quìvì nì nana‑ya ini iin lancha, mii‑yá xì nècuàchì dacuahá‑yá, te nì cachi‑yà xì‑né: ―Cúhùn‑ndà yàha‑nda inga ladu mar. Ñàyùcàndùá, nì quihin lancha mà ichì cuàhàn‑nu. ");
INSERT INTO mitNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Te na xicá‑nu cuàhàn‑nu mahì mar, dandu nì quìdì‑yà. Daaní, nì quesaha nì cana iin tàchì fuerte vàxi ndè ñuhù íchî, te nì quesaha cuàhàn chitu lancha mà tècuìí, yáha ga iá peligru xì nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dandu nì catnàtuu‑ne ndé indúhu‑yá quídì‑yà, te nì dàndácòo‑neyà, cachí‑nè xì‑yá: ―¡Maestro! ¡Maestro! ¡Cuàhàn‑ndà càhà‑ndà! Ñàyùcàndùá, nì ndacuiin‑yà nì càhàn‑yà nì sadi‑yà nùù tàchì mà xì nùù ñà‑nàcuáhnú tódo tècuìí. Dandu nì cucuiìn ìì nsidaámà, nì nàcuììn dadí uun. ");
INSERT INTO mitNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Te nì cachi‑yà xì‑né: ―¿Índù chuun có‑nìhnú vàha ndisa inì‑nsia Dios? Ñàyùcàndùá, nì yùhí‑nè, te nì ndulocó‑nè, cachí‑nè iin‑ne xì inga‑nè sàhà‑yá: ―¿Índù clase tiàa nduú ana yohó? Vàchi ndè tàchì xì ndè stná mar dandacú‑né nùù‑xí, te iníníá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Daaní, cuàhàn lancha mà, te nì sàà‑nu ndè ñuu nècuàchì gadarenu. Frente ladu Galilea indúhu ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Te nì nuu Jesús lancha mà nùù ñuhù íchî. Dandu yucán vàxi iin tiàa ñuu mà, ñuhú cuáhà ñà‑malu anima‑nè. Sàcàní tiempu ñuhá anima‑nè. Có‑ndìxí‑né sìcoto, ni còò stná vehe‑ne, cuisì mahì cueva ndé xí‑indùxin nsìi iá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Doco na ní xini‑nè Jesús, nì ndàhì ndee‑né nì sàcuììn sìsì‑né nùù‑yá, te fuerte nì cachi‑nè xì‑yá: ―Jesús, ¿ndíà cunduu‑ní yùhù? (Yùhù ináhî), Dèhemanì mii‑yá dandacú ndé chicá ansivi nduu‑ní. Sacúndáhvîˋ nùù‑ní ¡màsà dándóhó‑nî yùhù! ");
INSERT INTO mitNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ducán nì cachi nècuàchì‑mà, vàchi sàcàchí Jesús xì ñà‑malu mà ñà‑nì quèá ini‑nè. Vàchi antes cuàhà xichi nì dàndòhá‑nè, ñàyùcàndùá nì sàcùnuhni‑nè xì cadena xì stná manilla càa, te ducán nìsa ìa‑ne, ndiaá nèhivì‑né. Doco siempre sahndé uun‑ne ñà‑nùhní‑nè, te xinúdèhé‑nè yucù sáhàn‑nè quidá ñà‑malu mà. ");
INSERT INTO mitNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dandu Jesús, nì xìcàn tnùhù‑yá nùá, cachí‑yà: ―¿Nansa nanu? Te nì cachà: ―Ejército naní ―cacháˋ, vàchi cuàhà sàstnùhù ñà‑malu ñuhú anima‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Te nì sacundahvíà nùù‑yá ñà‑màsà dándácû‑yá cùhàn cuñuha yavi cunú sàstnùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Te yatni yucán iá iin yucù ndé ndoó cuàhà cochi xixáhan‑sì. Ñàyùcàndùá, nì xìcàn tàhvìá nùù‑yá áma cuáha‑ya permisu cùhàn caquìhvia ini cochi yucán. Te nì sàha‑ya permisu. ");
INSERT INTO mitNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dandu nì canacoyo nsidaa‑ñá ini tiàa ma cuàhàn, te nì caquìhvia ini cochi mà. Dandu nsidaa quisì mà, (nì culocó‑si); carrera nì canuu‑sì candiaa mà nì còyo‑sì mar, te nì càhà‑si. ");
INSERT INTO mitNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Daaní, tè‑xíndiaa xì cochi mà, na ní caxinì‑te nì cuu ducán, dandu carrera mànuhù‑té nì nacani‑tè xì nèhivì ñuu yucán xì stná nèhivì ranchu. ");
INSERT INTO mitNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dandu ní caquee nsidaa‑né vàxi‑ne cundaà ini‑nè ndíà nduá nì cuu. Te nì casaà‑nè ndé iá Jesús, nì xini‑nè, yucán iá tiàa nì caquee ñà‑malu anima‑xi, iá‑nè nùù‑yá, sàndìxí‑nè sìcoto vichi. Sànì nàcòo nsihi sàxìnítnùní‑nè. Ñàyùcàndùá, yáha ga nì cayùhí nèhivì mà. ");
INSERT INTO mitNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dandu tiàa nì caxini nansa nì cuu nì dàndúvàha‑ya tiàa ma, nì nacani‑ne xì nèhivì nì caquesaa mà. ");
INSERT INTO mitNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dandu nsidaa nècuàchì ladu Gadara mà, nì sacundahví‑nè nùù‑yá ñà‑nì quèé‑yá nùù ladu mà, vàchi yúhî cuaá‑nè. Ñàyùcàndùá, nì nana tu‑ya lancha ñà‑cùhùn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dandu tiàa nì caquee ñà‑malu nùù‑xìmà, nì sacundahví‑nè nùù‑yá cuní‑nè cutnahá‑né xì‑yá cùhùn. Doco nì techuún‑yánè nùhù‑nè, cachí‑yà: ");
INSERT INTO mitNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Xuhun‑ní vehe‑ní, te nacani nchihì‑ní nsidaa favor nì quida Dios xì‑ní ―nì cachi‑yà. Ñàyùcàndùá, mànuhù nècuàchìmà ñuu‑nè yucán, te inii ní xìcanuu‑ne nacání‑né xì nèhivì nansa (nì nduvàha‑ne) nì quida Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Daaní, na ní nasaa‑yà, nì cacudiì ini nèhivì ndòó yucán, vàchi xíndiatu nsidaa‑né ñà‑nsiaa‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Daaní, nì sàà iin nècuàchì nani Jairo nùù‑yá; iin nècuàchì cusáhnû nùù iin veheñùhu nduú‑né. Te nì tutuyuhu‑né ñuhù nùù sàhà‑yá nì sacundahví‑nè nùù‑yá ñà‑cùhùn‑yà vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Vàchi mindaa dèheyoco‑né iá, nahi ùxìn ùì cuìà xicá‑ña, doco vichi sàcùcáhví‑ña. Ñàyùcàndùá nì quihin Jesús ichì cuàhàn‑yà. Doco cuàhà stná nèhivì cutnáhâ xí‑yâ, dècuèndè yáha ga tnuu cuàhàn‑nè xì‑yá ñà‑cuàhà guá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Te mahì nèhivì mà cuàhàn stná iin nècuàchì ñahà, ùxìn ùì cuìà sàcuàhàn‑nè ndohó‑né cuèhè nìì, te sànì nsihi dìhùn xí‑né cuàhàn nùù cuàhà nècuàchì nì quidatatna xi‑né, doco ni‑iin nècuàchìmà, cónì níhì‑né dandúvàha‑ñané. ");
INSERT INTO mitNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Te vichi divi ñahà mà nì quixi ladu yàtà Jesús, nì dàcúhùn‑nè ndahà‑né nùù ìcà sìcoto xi‑ya. Te hora nchito ma nì cucuiìn nìì‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dandu ní cachi Jesús: ―¿Ana divi nì dùcùn ndahà‑xí yùhù? ―Ni‑iin‑nsi ―cachí nsidaa‑né. Te Pedro xì compañeru‑nè, nì cachi‑nè xì‑yá: ―Yáha ga ndutnúú, Maestro; tnuu ga vàxi‑nda mahì nèhivì. ¿Índù chuun ndácàtnùhù‑ní ana nì dùcùn ndahà‑xí ìcà sìcoto xi‑ní? ");
INSERT INTO mitNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Doco nì cachi‑yà: ―Ináhî iá ana nì quida xí ducán, vàchi nì cundaà inì nì quide iin milagru. ");
INSERT INTO mitNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dandu nècuàchì ñahà mà, nì cundaà stná ini‑nè ñà‑sà‑ìnáhá Jesús ñà‑ndùá nì quida‑ne. Ñàyùcàndùá, vàxi‑ne, ndé quidí cuisì‑né nì sàcuììn sìsì‑né nùù‑yá. Te itá nsidaa nèhivì yucán, iníní‑né, te nì nacani nècuàchìmà xì‑yá índù ñà‑dìsáhà‑xí nì dàcácùhun‑ne ndahà‑né ìcà‑yá, te nì nduvàha‑ne vichi duha. ");
INSERT INTO mitNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dandu nì cachi‑yà xì‑né: ―Hija, sànì nduvàha‑ní ñà‑nì xinindisa‑ní. Vàtùni nùhù‑ní vichi, te contentu ni coo‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na meru cachí‑yà ducan, dandu nì quesaa iin tiàa nì quixi vehe presidente xi veheñùhu ma, te nì càhàn‑te xi nècuàchìmà, cachí‑te: ―Sànì xìhì dèheyoco‑ní. Có‑xìñùhù cuàhachuún gà‑ní Maestru. ");
INSERT INTO mitNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Doco nì tiacu Jesús ñà‑ndùá nì cachì‑te, ñàyùcàndùá nì cachi‑yà xì nècuàchì dàndàcù‑mà: ―Màsà yúhî‑nî. Cuisì cunihnu vàha inì‑ní, te càcu‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Daaní, (nì sàà‑yà xì‑né), te nì quìhvi‑ya xì‑né ini vehe. Doco cónì sáha‑ya quìhvi inga nèhivì (ndé indúhu nsìi ma), cuisì Pedro xì Jacobo xì Juan xì stná yuadíhí‑ñâ. ");
INSERT INTO mitNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vàchi ndoó cuàhà nèhivì, te sacú ndee‑né, cána‑ne ñà‑sànì xìhì‑ña. Dandu nì cachi‑yà xì‑né: ―Màsà cuácú‑nsiá, vàchi cónì xíhì‑ña; quídì uun ni‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dandu nècuàchìmà, nì sàcùndiaa‑nèyà, vàchi ináhá‑nê ñà‑sànì xìhì‑ña nduá. ");
INSERT INTO mitNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Doco mii‑yá, nì cachi‑yà ni cáquéé nsihi‑ne fuera. Dandu nì tnii‑yà ndahà‑ñá, te nì càhàn fuerte‑yà, cachí‑yà: ―¡Ndacuiin xá! ");
INSERT INTO mitNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Daaní, nì nsiaa tu espíritu xi‑ñà, te yàchì nì ndacuiìn‑ña. Te nì dàndàcú‑yá daquixí‑né ñà‑cutiacù‑ña. ");
INSERT INTO mitNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Te yuadíhí‑ñâ, yáha ga nì ndulocó‑nè. Dandu nì cachi‑yà xì‑né ñà‑màsà nácání‑né xì ni‑iin nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Daaní, nì cana Jesús ùxìn ùì nècuàchì dacuahá‑yá, te nì sàhatahvì‑yánè ñà‑vàtùni tavà‑né nsidanuu clase ñà‑malu ñuhú ini nèhivì, te vàtùni dandúvàha stná‑nè nèhivì cuhí. ");
INSERT INTO mitNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Te nì sàcùnaha‑né ñà‑cùhùn‑nè cachitnùhu‑ne xì nèhivì palabra sàhà ñuhìví ìì xí Dios, te dandúvàha stná‑nè nècuàchì cuhí. ");
INSERT INTO mitNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Dohó nì cachi‑yà xì‑né: ―Ni‑iñàha màsà cúníhí‑nsiá cùhùn, ni bastón, ni morral, ni dìtà, ni dìhùn, ni inga dùhnù‑nsiá ñà‑nadama‑nsia màsà cúníhí‑nsiá cùhùn. ");
INSERT INTO mitNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Te nú nì sàà‑nsià iin vehe ndé cundoo‑nsia, iin‑ni cundoo‑nsia yucán dècuèndè cachi sàà quìvì quee‑nsia ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Doco nú có‑cùní nèhivì dayáha‑ne mii‑nsiá, dandu quee‑nsia yucán, te nacatù‑nsiá sàhà‑nsiá còyo yàcá ñuu mà, cunduamà seña cónì quidá víi nècuàchìmà (xì‑nsiá) ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Daaní, nècuàchì dacuahá‑yámà, nì caquihin‑ne ichì cuàhàn‑nè, nì nacàhin‑ne cuàhà ñuu cuati nì càhàn‑nè xì nèhivì nansa iá razón vàha xi Dios, te nì dàndúvàha stná‑nè nècuàchì cuhí nsidanicuú lugar. ");
INSERT INTO mitNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Daaní, rey Herodes, nì xinitnùhu‑tè ñà‑cuàhà guá milagru quidá‑yá, te nì ndulocó‑te, vàchi cachí dava nèhivì ñà‑sànì natiacu Juan (Bautista) nduájàn. ");
INSERT INTO mitNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Doco dava ga‑nè, nì cachi‑nè divi Elías sànì ndecunu, te ò iin nècuàchì yuhù núù Dios sànì natiacu. ");
INSERT INTO mitNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Doco Herodes, (nì ndulocó‑te), te nì cachì‑te: ―Yùhù nì sàhi orden tàhndè dìnì Juan (Bautista). Doco inga nècuàchì cáhàn guá nèhivì sàhà‑xìmà, ¿ana divi nduú‑né, te cuàhà guá ñà‑quìdà stná‑nè? ―nì cachì‑te. Ñàyùcàndùá cuní‑te cundehè‑té Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Daaní, sàmàndixi nsidaa nècuàchì dacuahá‑yá nì cansiaa‑nè, te nì nacani‑ne xì‑yá nsidaa ñà‑ndùá nì quida‑ne ndé nì sàhàn‑nè. Dandu nì nacuaca‑ya nsidaa‑né cuàhàn cuaán‑yá xì‑né iin xaan yatni ñuu Betsaida ndé còò nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Doco cuàhà nèhivì nì tenchicùn xì‑yá, vàchi nì xinitnùhu‑ne cuàhàn‑yà. Ñàyùcàndùá, nì casàhú‑yà xì‑né, te nì càhàn‑yà xì‑né sàhà ichì dandacú Yua‑nda Dios. Te nì dàndúvàha stná‑yà nècuàchì cuhí xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dandu nì cuaà quìvì yucán. Te ùxìn ùì nècuàchì dacuahá‑yá, nì tnàtuu‑ne nùù‑yá, cachí‑nè xì‑yá: ―Ndaquindèè‑ní xì nèhivì, dandu cùhùn‑nè ñuu cuati, te ò ranchu yatni, te nìhì‑né ndé cuxi‑ne, te cùdù‑nè, vàchi yohó ndé ndoo‑nda, còò vehe. ");
INSERT INTO mitNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Doco nì cachi‑yà xì‑né: ―Mii‑nsiá dacuxí‑nsiánè. Te nì cachi‑nè: ―Cuisì ùhùn pan nihí‑nsí, xì úì siaca. ¿A cuní‑nî cùhùn‑nsì cuiin‑nsi ñà‑cuxi nsidaa nècuàchì yohó? ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Vàchi nècuàchì tiàa ndoó yucán, ùhùn mil nduú nsidaa‑né. Dandu nì cachi‑yà xì nècuàchì dacuahá‑yá: ―Cachi‑nsià xì nèhivì ñà‑nì mácùndoo‑ne ñuhù, iin iin grupu‑nè ùì dico ùxìn, ùì dico ùxìn ni cúndúú‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ñàyùcàndùá, ducán nì caquida nècuàchì dacuahá‑yá, nì càhàn‑nè xì nèhivì, te nì sàcùndoo nsihi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Dandu nì tnii‑ya ùhùn pan mà xì ùì siaca ma, te nì ndacoto ndiaá‑yà dìquì‑xí, nì naquimanì‑yá Dios sàhámà. Dandu nì dàcuàchí‑yáñà, te nì sàha‑ya nècuàchì dacuahá‑yá, te nì dasàn‑néà nùù nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Te nsidaa‑né, nì xixi‑ne nì ndenuu ini‑nè. Dandu nì chivàha‑ne ñà‑nì cuyodò, te nì chitu ùxìn ùì ìcà pedazu pan mà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Daaní, nì ìa iin xichi nì quecuaán‑yá xì nècuàchì dacuahá‑yá, te nì xìcàn tàhvì‑yá nùù Dios. Dandu después nì ndàcàtnùhù‑yá nùù nècuàchìmà, cachí‑yà: ―¿Ana nduú yùhù, cachí nèhivì? ");
INSERT INTO mitNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Te nì cachi‑nè xì‑yá: ―Dava‑ne cachí‑nè ñà‑Juan Bautista nduu‑ní. Te dava‑ne cachí‑nè Elías nduu‑ní. Te dava ga‑nè cachí‑nè iin nècuàchì profeta sànaha nduu‑ní, te sànì natiacù‑ní vichi cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dandu nì cachi‑yà xì‑né: ―Doco mii‑nsiá, ¿ana nduí, cachí‑nsià? Dandu nì cachi Pedro xì‑yá: ―Divi Cristu nì quixi nùù Dios nduu‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dandu nì dàndàcú‑yá nùù‑né ñà‑màsà nácání‑né xì nèhivì nduú‑yá Cristu. ");
INSERT INTO mitNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Dandu nì cachi stná‑yà xì‑né: ―Yùhù ana nduú Tnaha Nèhivì Ñuhìví, cuàhà gá icúmî ndohi. Vàchi tè‑sàhnú xídandacú, xì stná dùtù xícusahnú, xì stná nècuàchì ley xi veheñùhu, nsidaa‑né icúmí‑nê cahíchì ini‑nè yùhù, dandu cacahnì nèhivì yùhù. Doco tìxi ùnì quìvì icúmî natiacuì. ");
INSERT INTO mitNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Te nì cachi stná‑yà xì nsidaa‑né; ―Nsidaa ana cuní cunchicùn xìˊ, xiñuhu nacoo‑ne ñà‑ndùá cuní inì‑ni mii‑né quida‑ne, te nsìquívì quida‑ne cuenta na ian nsidá stná‑nè cruz xi‑ne cutnáhâ‑né xìˊ (ñà‑cui stná‑nè). ");
INSERT INTO mitNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Vàchi nsidaa ana cuní dacácu xi vida xi vichi, ñà‑dàndáñúhú‑nê mii‑né nduá. Doco nú ni cuí‑nè sàhí, dandu ñà‑sànì càcu ndisa vida xi‑ne cundua. ");
INSERT INTO mitNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Vàchi nú ni níhì iin nèhivì nsidaa ñà‑ìá ñuhìví, ni ñà‑jaàn, mà cúndúá iin bien xi‑ne nú màsà sáà anima‑nè cundiatú stná, te càcua. ");
INSERT INTO mitNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iin nèhivì, nú cucáhán nûù‑né coo‑ne ladu xi, o nú cucáhán nûù‑né cunini‑ne palabra xi, (ndahví‑nè), vàchi icúmí stnáì nacuaí mii‑né quìvì naxicocuíìn yùhù ana nduú Tnaha Nèhivì Ñuhìví. Te ndiaha gá coo quìvì mà sàhà yùhù, xì sàhà Yuamánìˊ, xì sàhà ángel ìì cacutnahá xí quixi. ");
INSERT INTO mitNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Doco ñà‑ndáà nduá cachíˋ xì‑nsiá, dava mii‑nsiá nècuàchì itá yohó, tàñáha ga cui‑nsià, te cuni‑nsià nansa iá ñuhìví ìì xí Dios ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Daaní, nì nsihi nì cachi‑yà ducán, dandu nì yàha nahi ùnà gà quìvì, te nì saca‑ya Pedro xì Juan, xì Jacobo, cuàhàn‑yà xì‑né iin yucù ndé cuàhàn‑yà càhàn‑yà xì Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","(Daaní, na iá‑yà yucán) xícàn tàhvì‑yá nùù Dios, dandu ní xini nècuàchìmà tucu nì nàcùnahà‑yà. Nì nducuxín yaa sìcoto xi‑ya, te tnúù nihni ndiaha‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Dandu nì xini stná‑nè, yucán nì canatùi stná ùì nècuàchì (sànaha) iin‑ne nani Moisés, te inga‑nè nani Elías. Te itá stná ndómà ndatnúhú‑ndá xí‑yâ. Te tnúù nihni stná‑ndà, cáhàn‑ndà xì‑yá sàhà nansa icúmí‑yâ cui‑yà ñuu Jerusalén. ");
INSERT INTO mitNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Te Pedro xì compañeru‑nè, sádì gà vàhná‑nè. Doco na ní nsicuìhnú viì ini‑nè, dandu nì caxini‑nè ndiaha gá tnúù nihni‑ya, te mimíí nì caxini‑nè itá stná ùì ndósàhnù‑mà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Daaní, na meru cuàhàn cuxica‑nda, dandu ní cachi Pedro xì‑yá: ―¡Maestro, nansicáhán‑ndá ndoo‑nda yohó! Chicá vàha quidavàha‑nsi ùnì siahva, ian coo mii‑ní, inga stná coo Moisés yohó, te ingà coo stná Elías yohó. Ducán nì cachi Pedro, vàchi cónì cúndáà ini‑nè nansa cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Daaní, sà‑cáhàn‑nè xì‑yá ducán, dandu nì nuu iin vìcò, te nì dàhvi nsidaa‑né mahìá. Te nì cayùhí cuaá‑nè na ní xini‑nè nì cuu ducán. ");
INSERT INTO mitNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dandu nì tiacu‑nè cáhàn iin ana cáhàn mahì vìcò mà, te dohó cachí‑yà: ―Dèhemaní nduú ana yohó. Cunini‑nsia ñà‑ndùá cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Daaní, nì ndacoto nècuàchì dacuahá‑yámà, te nì xini‑nè ndé cuisì mindaa mii‑yá iá yucán. Doco después còò ni‑iñàha ni cachí‑nè xì ni‑iin nèhivì sàhà nsidaa ñà‑ndùá nì xini‑nè yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Daaní, inga quìvì nì nuu‑ya xì‑né yucù mà vàxi‑ya. Dandu nì ndacùhun stnahá‑yá xì cuáhà nèhivì sànì nataca. ");
INSERT INTO mitNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Te iin nècuàchìmà nì càhàn‑nè xì‑yá, sacúndáhvî fuerte‑nè nùù‑yá, cachí‑nè: ―Maestro, sacúndáhvîˋ nùù‑ní, cundehè ndahví‑nî tèchii xí, vàchi mindaa‑té nduú dèhi. ");
INSERT INTO mitNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Cunaha‑ní, iin ñà‑malu dandoho‑xi‑té, dandáhìà‑te, te xíhì ìhí‑te quidá, queé chìhìñù yuhù‑té: quini ga quidá xì‑té, có‑cùníà nacoà‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ñàyùcàndùá nì sacundahvíˋ nùù nècuàchì dacuaha‑ní ñà‑tavà‑néà, doco mànìcùí. ");
INSERT INTO mitNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dandu nì cachi Jesús xì‑né: ―Ndahví‑nsià, vàchi mà túha‑nsia cunindisá‑nsiá, ni có‑sâà‑nsià cundaà inì‑nsia. ¿Nadaa ga quìvì icúmî coo guè xì‑nsiá, te quidandee gá stná inì sàhà‑nsiá? Pues cundaca‑ní dèhe‑ní quixi ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Daaní, sàvàxi‑ne xì‑té, te nì ducùn ñà‑malu‑te ñuhù ní sahnì ìháˋ‑te. Ñàyùcàndùá, nì sadi‑yà nùá, te nì dàndúvàha‑yàte. Dandu nì quida‑yàte entregar nùù yua‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Te nsidaa nèhivì ndoó yucán, nì ndulocó cuàhà‑né ñà‑ndiaha guá nì quida Dios. Daaní, na ndulócô guá‑nè sàhà nsidaa obra nì quida‑ya, dandu nì cachi‑yà xì nècuàchì dacuahá‑yá: ");
INSERT INTO mitNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Cunini vàha‑nsia palabra cuàhìn cachì xì‑nsiá. Yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî yàhi coi ndahà nèhivì (malu), vàchi iá iin tiàa cuàhàn quida xí entregar ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Doco nècuàchìmà, cónì cúndáà ini‑nè ñà‑ndùá nì cachi‑yà, vàchi nì ìa dèhé chuun ma nùù‑né; ñàyùcàndùá, cónì sánìhì ini‑nè. Te yúhî stná‑nè ndàcàtnùhù‑né nùù‑yá sàhámà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Daaní, nì quesaha‑né nì cuàà‑nè ndácàtnùhù stnahá‑né nùù‑né ana chicá ndiaá. ");
INSERT INTO mitNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Dandu nì cundaà ini‑yà nansa xínacani ini‑nè, te ñàyùcàndùá nì nacuaca‑ya iin tètii nì chicani‑yàte iladú‑yà, ");
INSERT INTO mitNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","te nì cachi‑yà xì nècuàchìmà: ―Nú sàhà yùhù quidáñúhú iin nèhivì tètii yohó, dandu dava‑ni queá na ian yùhù quidáñúhú‑nê. Te nú yùhù quidáñúhú‑nê, dandu iin‑ni queá ñà‑quìdáñúhú stná‑nè ana nì techuun‑xí vàxi. Vàchi nècuàchì chicá nihnú ndáhví inì‑xi, divi nduú ana chicá ndiaá ndisa. ");
INSERT INTO mitNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dandu nì cachi Juan xì‑yá: ―Maestro, nì xini‑nsì iin tiàa tavá xi ñà‑malu nùù nèhivì, te quìvì mii‑ní ndácùcahan‑né. Doco có‑ndùú‑né iin ana cutnáhâ xí‑ndá xicánúú. Ñàyùcàndùá, nì sadi‑nsì nùù‑né ñà‑màsà quídá gá‑nè ducán. ");
INSERT INTO mitNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dandu nì cachi Jesús xì‑né: ―Còó, màsà cádí‑nsià nùù‑né, vàchi nsidaa ana có‑xìní ùhì xì‑ndà, favor xi‑nda iá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Daaní, na sá‑ìtúú tiempu nana‑ya ansivi nùhù‑yà, dandu nì quihin‑ya ichì cuáhàn‑yà ñuu Jerusalén, iin‑ni nihnú ini‑yà sàà‑yà yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Te nì techuún‑yá itnii tiàa codònùù núù‑yá ñà‑cachitnùhu‑ne icúmí‑yâ yàha‑ya ichì yucán. Ñàyùcàndùá, nì casaà tiàa ma iin ñuu tii nècuàchì raza samaritanu, cuàhàn‑nè nanducu‑né ndé coo‑ya nì cùí. ");
INSERT INTO mitNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Doco nècuàchì ñuu mà, ni loho cónì cándísâ‑né coo chii‑yá ñuu‑nè, vàchi sànì xinitnùhu‑ne ñà‑ichì Jerusalén nduá cuàhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ñàyùcàndùá, ùì nècuàchì dacuahá‑yá nani Jacobo xi Juan, na ní tiacu‑nè ñà‑dùcán nì cachi nècuàchì ñuu mà, dandu nì cachi‑nè xì‑yá: ―Stoho‑nsì Señor, ¿a có‑cùní‑nî dandacú‑nsí còyo ñuhu ansivi, te coco nsihi nèhivì ñuu yohó, vàchi ducán nì quida stná Elías sànaha? ");
INSERT INTO mitNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Doco nì dà‑íhî Jesús nècuàchìmà, cachí‑yà: ―Mii‑nsiá, có‑cùndáà inì‑nsia nansa ndiá ìcà‑nsiá cunihnu vàha inì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Vàchi yùhù ana nduú Tnaha Nèhivì Ñuhìví, ¿índù divi chuun nì quesaì ñuhìví yohó? Pues divi sàhà ñà‑dacácui nèhivì, te màdìá dandáñúhî‑nè ―nì cachi‑yà. Dandu cuàhàn‑yà xì‑né inga ñuu chicá nùù‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Daaní, na xicá‑yá xì‑né ichì, nì càhàn iin tiàa xi‑yá, cachí‑nè: ―Yùhù, dispuestu iéˋ cunchicuìn mii‑ní ndéni nì cui ni cúhùn‑ní, Señor mío. ");
INSERT INTO mitNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dandu nì cachi Jesús xì‑né: ―Lusu, iá nchihò‑sí, te laa ndavá ansivi, iá stná tacà‑si; doco yùhù ana nduú Tnaha Nèhivì Ñuhìví, còò ni‑iin lugar ndé cunduhí cùdì. ");
INSERT INTO mitNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Daaní, nì cachi‑yà xì inga nèhivì: ―Cunchicùn‑ní yùhù. Te nì cachi nècuàchìmà: ―Señor mío, dihna ni núhì ñà‑coo chii guéˋ vehi dècuèndè (ni cuí) yué, te nì ndùxin‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dandu nì cachi Jesús xì‑né: ―Nècuàchì có‑ìá vida anima‑xi, divi ni cúxin xi nsìi‑xi. Doco mii‑ní, cuahán‑nî cachitnùhu‑ní razón sàhà ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dandu inga nèhivì, nì cachi‑nè xì‑yá: ―Yùhù, cunchicuìn mii‑ní, Señor mío. Doco dihna ni núhì (coo chií) ndaquindèí xì nèhivì vehi. ");
INSERT INTO mitNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dandu nì cachi Jesús xì‑né: ―Iin nèhivì sà‑ìtníí‑xí yàtà, nú cuisì yàtà‑né indéhe‑né, dandu mà quéé víámà. Te ducán iá stná xì iin nèhivì (mà iin‑ni nihnú ini xì yùhù), mà cùì sáà‑nè cunduu‑ne nèhivì xí ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Daaní, na ní nsihi nì cuu ducán, dandu nì nacàxin Stoho‑ndà Señor ùnì dico ùxìn (70) tiàa, te nì techuún‑yánè cùhùn‑nè ùì ùì‑nè codònùù‑né nùù‑yá nacàhin‑ne nsidaa ñuu xì nsidaa xaan ndé icúmí‑yâ yàha stná‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ñàyùcàndùá, nì cachi‑yà xì‑né: ―Ñà‑ndáà nduá, cuàhà nèhivì (tàñáha ga cunindisá). Te na iin cosecha cahnú ndanihi‑nda nduú‑né, doco sacu nèhivì nduú ana (chindéé xí‑ndá) ndanchitoa. Ñàyùcàndùá, càcàn tàhvì‑nsiá nùù Lamú dandacú sàhà chuun yohó ñà‑nì téchúûn gá‑yà nèhivì cùhùn quida xi chuun (ìì xí‑yá), vàchi na ian ndanchító iin cosecha ndiaha nduá. ");
INSERT INTO mitNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","’Vàtùni cùhùn‑nsià vichi. Yùhù techuín mii‑nsiá cùhùn‑nsià cacanuu‑nsia mahì nèhivì dàná, cunduu‑nsia nahi lelù xicánúú mahì lobu. ");
INSERT INTO mitNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Doco màsà cúníhí‑nsiá ni‑iin itni cuñuhu dìhùn, ni stná morral xi‑nsia, ni inga ndìsàn‑nsiá. Te ni‑iin nèhivì màsà cásàhú xì‑nsiá ichì. ");
INSERT INTO mitNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Te nú sànì sàà‑nsià iin vehe ndé cundoo‑nsia, dandu cachi‑nsià xì stoho vehe ma: “Ni cúndóó mánì mii‑nsiá nèhivì vehe yohó”. ");
INSERT INTO mitNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dandu nú ndisa ndoó nèhivì tùha cundoo ndiaha vehe ma, dandu vàtùni. Doco nú coó, ni cúnàhá ñà‑ndùá nì cachi‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","’Cuisì iin‑ni vehe cundoo‑nsia, te cuxi‑nsia te coho‑nsia ñà‑ndùá sáha nècuàchì dìvéhé‑xímá mii‑nsiá. Vàchi nsidaa ana quidáchúûn, xiñuhu cuàha xi‑né iin algu. Màdì vehe yohó vehe yucán cundoo‑nsia, còó; iin‑ni ni cúndóó‑nsiá cuisì iin‑ni vehe. ");
INSERT INTO mitNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Te nú ni sáà‑nsià iin ñuu, te candísâ nèhivì cundoo‑nsia yucán, dandu ñà‑ndùá sáha‑nensià, divi ñà‑jaàn nduá cuxi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Te dandúvàha stná‑nsià nècuàchì cuhí ndoó yucán, te dohó cachi‑nsià xì nèhivì yucán: “Vichi sànì quesaa razón sàhà ñuhìví ìì xí Dios ndé ndoó‑nsiá”, cachi‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Doco nú nì sàà‑nsia iin ñuu, te có‑xìníndísâ nèhivì yucán mii‑nsiá, dandu màcuìta‑nsia mahì ichì cahnú ñuu mà, te cachì‑nsia xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Dècuèndè yàcá ñuu‑nsià nì tnìi sàhà‑nsí, icúmí‑nsî catù váha‑nsiñà còya, (vàchi ndahví gà modo xi‑nsia). Doco cunaha váha‑nsia, yohó ndé ndoó‑nsiá sànì quesaa stná razón sàhà ñuhìví ìì xí Dios (mate cónì ndúlócô‑nsià)”. Ducán cachi‑nsià (xì nèhivì ñuu mà). ");
INSERT INTO mitNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Te yùhù cachíˋ xì‑nsiá na sáà quìvì juiciu, dandu chicá cuàhà castigu icúmí nèhivì ñuu mà nìhì‑né nùù nèhivì (malu) ñuu Sodoma. ");
INSERT INTO mitNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Ndahví nèhivì ñuu Corazín! ¡Ndahví stná nècuàchì ñuu Betsaida! Vàchi cuàhà milagru fuerte nì xini‑nè, (te cónì ndúlócô‑nè). Doco cunaha‑nsiá, nú ducani ni coó stná milagru mà ñuu Tiro, ò ñuu Sidón nì cùí, dandísá, yàchì naxicocuíìn ini nècuàchì ñuu mà sàhà cuàchi‑ne, te nàcùndixi ndahví‑nè nàcùndoo‑ne mahì yàà tutnù, (te cunduamà seña ñà‑ndisa cuhí ini‑nè mii‑né sàhà cuàchi‑ne). ");
INSERT INTO mitNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Te quìvì cuu juiciu, chicá iyuhu castigu icúmí nìhì nèhivì ñuu Tiro mà, xì nèhivì ñuu Sidón mà, te chicá fuerte coo castigu xi ñuu Corazín xì ñuu Betsaida mà. ");
INSERT INTO mitNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Stná nècuàchì ñuu Capernaum, mate tuxí ini‑nè nana ducún‑nè ndè gloria, doco còó, ndè andea icúmí‑nê nuu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Cunaha‑nsiá, nú ni quihín casu nèhivì sàhà ñà‑ndùá cachí mii‑nsiá, dandu iin‑ni queámà na ian quihín casu stná‑nè yùhù. Te nú ni cáhîchì ini‑nè mii‑nsiá, icúmí quee stná mà na ian cahíchì stná ini‑nè yùhù. Te nú yùhù ni cáhîchì ini‑nè, dandu iin‑ni queé stná mà na ian sànì cahíchì stná ini‑nè mii‑yá ana dìchúún‑xí vàxi. ");
INSERT INTO mitNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Daaní, nì naxicocuíìn ùnì dico ùxìn (70) nècuàchì dacuahá‑yá, te cudíì ini‑nè, cachí‑nè xì‑yá: ―Cunaha‑ní, Stoho‑nsì Señor, dècuèndè stná ñà‑malu nì cundee‑nsí nùù‑xí ñà‑nì ndacùcahan‑nsí quìvì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dandu nì cachi‑yà xì‑né: ―Nì xini stnáì ñà‑malu cusáhnû, nì quea ndè gloria vàxan, nì nacava na ian nì tàsa. ");
INSERT INTO mitNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Cunaha‑nsiá, vichi sànì dàníhìtáhvì stnáì mii‑nsiá ñà‑nú ni cuánihni‑nsia còò ò sìduhma, dandu (còò ni‑iñàha cuu xi‑nsiá); te vàtùni cundee stná‑nsià nùù nsidaa ñà‑malu, mate yáha ga xiní ùhìàndó, te yáha ga nacúndéâ, doco còò ni‑iñàha cuu xi‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Xiñuhu cudiì ini‑nsià vichi, doco màdì sáhà‑ñá vàtùni nì cundee‑nsiá nùù ñà‑malu. Còó, cuisì xiñuhu cudiì inì‑nsia sàhà ñà‑sànì sàcuìtandiaa quìvì‑nsiá nùù (tutu iá) ansivi. ");
INSERT INTO mitNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Divi hora yucán nì cudiì ini Jesús nì quida Espíritu Ìì xí Dios, te nì cachi‑yà (xì Yuamánì‑yá): ―Ndeníhí vàhi mii‑ní, Yuamánìˊ Dios; vàchi mii‑ní nduu‑ní Stoho ansivi xì ñuhìví. (Te palabra ìì xí‑nî), sànì chitnùní inì‑ní ndòo dèháˋ nùù nècuàchì nchichí; doco nùù nècuàchì nihnú ndahvi inì‑xi nahi ñà‑cuati, sànì dàtnúù‑ní sàxìnítnùní‑nè. Ducán iá, vàchi ñà‑jaàn nduá nì chitnùní inì‑ní quida‑ní, te nì cudiì inì‑ní coo ducán ―nì cachi‑yà xì Yuamánì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dandu nì cachi stná‑yà: ―Nùù Yuamánìˊ sànì nìhìtáhvìˊ dandacuí nùù nsidanicuú iñàha; te còò ni‑iin nèhivì ináhá ana nduú yùhù, cuisì mii‑yá; te cuisì yùhù ináhá stnáì mii‑yá, cuisì yùhù xì stná nèhivì cuníˋ cundaà inì‑xi sàhà‑yá ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dandu nì nacuico‑yá nùù nècuàchì dacuahá‑yá, te nì cachi‑yà xì‑né: ―Nansicáhán mii‑nsiá, vàchi ndiaha gá iá ñà‑ndùá sànì xininùù‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Cunaha‑nsiá, cuàhà profeta sànaha, xì cuàhà stná rey, nìsa cuni‑nè cundehè‑né ñà‑ndùá sànì xini mii‑nsiá, doco cónì níhìtáhvì‑né cuni‑nèà. Te nìsa cuni stná‑nè cunini‑ne ñà‑ndùá sànì inini mii‑nsiá, doco cónì sáà‑nè nìhìtáhvì‑né cunini‑neà. ");
INSERT INTO mitNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Daaní, nì ndacuiin iin nècuàchì ley xi veheñùhu, cuní‑nè cundaà ini‑nè nansa naxiconihí Jesús nùù‑né. Te dohó nì cachi‑nè xì‑yá: ―Maestro, ¿ndíà ndùá quide, te nìhìtáhvìˊ vida ndiaha nicanicuahàn? ");
INSERT INTO mitNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Dandu nì cachi‑yà xì‑né: ―¿Nansa cachí tutu nduú ley xi Dios? Sànì cahvi‑níà. Pues ¿nansa cacháˋ? ");
INSERT INTO mitNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dandu nì cachi nècuàchìmà: ―Dohó cacháˋ: “Icúmí‑ndá cuu ini‑ndà sàhà Stoho‑ndà Dios xì nsidanicuú anima‑ndà, xì nsidanicuú ini‑ndà, xì nsidanicuú valor xi‑nda, xì nsidanicuú stná sàxìnítnùní‑ndà. Te nacua cuú ini‑ndà sàhà mii‑nda, ducán icúmí stná‑ndà cuu ini‑ndà sàhà ñanìtnaha‑nda”. ");
INSERT INTO mitNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Dandu nì cachi Jesús xì‑né: ―Cachí vàha‑ní. Ducán quida‑ní, dandu nìhì‑ní vida ndiaha nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Doco nècuàchìmà, có‑cùní‑nè cachi nèhivì xì‑né tonto iá‑nè, ñàyùcàndùá, nì cachi‑nè xì‑yá: ―Doco ¿índù clase nèhivì cachí xì‑ndà nduú ñanìtnaha‑nda? ");
INSERT INTO mitNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dandu nì cachi‑yà xì‑né: ―(Cunini‑ní historia.) Nìsa ìa iin tiàa ñuu Jerusalén, te nì quee‑ne cuàhàn‑nè inga ñuu nani Jericó. Doco (ichì mà) nì ndacùhun tnahá‑né xì itnii tècuìhnà. Te nì sadì‑te nùù‑né, nì xidacuihna‑té nsidaa sìcoto xi‑ne, nì sahnì cuìí‑tené, grave nì dànácuèhè‑tené, te cuàhàn‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Daaní, nì cuu nì yàha iin dùtù ichì mà. Te nì xini‑nè indúhu nècuàchì nì nacuèhè mà, doco iladú nì yàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Daaní, yucán nì yàha stná iin tiàa levita (quidáchúûn veheñùhu), te nì xini stná‑nè nècuàchìmà. Te divini iladú nì yàha stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Daaní, ichì yucán nì yàha stná iin nècuàchì ñuu Samaria, te na ní sàà‑nè ndé indúhu nècuàchìmà, nì xini‑nè nècuàchìmà, te nì cuhi inì‑ñané. ");
INSERT INTO mitNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nì tnàtuu‑ne nì quidatatna‑né ndé nì nacuèhè xi nècuàchìmà, nì dàquée‑ne aceite xì vinu, te nì chidùcún‑nèà. Dandu nì chindànùú‑ñané quisì ndacá‑né. te cuàhàn‑nè xì nècuàchìmà dècuèndè iin vehe ndé quetátú nècuàchì xicá ichì caní. Yucán nì ìa‑ne nì sandiaa‑nè nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Dandu inga quìvì na ní quihin‑ne ichì cuáhàn‑nè, nì tavà‑né ùì dìhùn, nì sàha‑ne nècuàchì dìvéhé‑xímá, cachí‑nè: “Cundiaa sacù‑ní nècuàchì ndahví yohó, te nú chicá cuàhà cuàhàn‑ní quida‑ní gastu, dandu icúmî danáìˊ na náyàhi”, nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pues, vichi cachì‑ní xìˊ: nùù nsì‑únì tiàa (nì yàha yucán), ¿indù nècuàchì meru nì sanduu ndisa ñanìtnaha nècuàchì nì ndacùhun tnahá xi tècuìhnà mà cahan‑ní? ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dandu nì cachi nècuàchì ley xi veheñùhu ma: ―Pues, divi tiàa nì indehè ndahví xì nècuàchìmà. Dandu nì cachi‑yà xì‑né: ―Pues, cuahán‑nî, te divi ducán quida stná mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Daaní, nì yàha‑ya xì compañeru‑yà ndè chicá nùù‑xí ndé iá iin ñuu tii. Te yucán iá iin nècuàchì ñahà nani Marta, te divi‑ne nì quida xi‑yá invitar ñà‑coo‑ya vehe. ");
INSERT INTO mitNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Te yucán iá stná iin cùhì nècuàchìmà nani María. Te María mà, cudíì ini‑nè coo‑ne ñuhù núù Jesús cunini‑ne ñà‑ndùá cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Doco Marta, cuàhà gá chuun yuhùnùhú icúmí‑nê, te ndé cutóntô‑nè sàhà chuun ma. Ñàyùcàndùá, vàxi‑ne ndé iá‑yà, cachí‑nè xì‑yá: ―Señor mío, ¿a có‑dàndóhâ mii‑ní ñà‑sànì nacoo cùhì yùhù quidachuún mindaí. Cachì‑ní xì‑né ñà‑nì chíndéé stná‑nè yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Doco nì cachi‑yà xì‑né: ―¡Ndahví‑nî, Marta! Cuàhà gá nacání inì‑ní. Cuàhà gá chuun sahní‑nî mii‑ní sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Doco cuisì imindaa chuun nduú ñà‑ìá ndisa necesidad quida‑nda. Te divi chuun vàha ma nduá cudíì ini María quida‑ne vichi, te yùhù, mà cuáhi cuxio chuun vàha ma nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Daaní, nì cuu iin xichi iá‑yà iin xaan xícàn tàhvì‑yá nùù Dios. Te nì nsihi nì càhàn‑yà xì Dios ducán, dandu nì cachi iin nècuàchì dacuahá‑yá: ―Señor mío, dacuaha‑ní nsiùhù càcàn tàhvì stná‑nsì nacua nìsa dacuahá Juan (Bautista) ana nchícùn xì mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dandu nì cachi‑yà xì‑né: ―Na xícàn tàhvì‑nsiá nùù Dios, dohó cachì‑nsia: Yua‑nsí Dios iá ansivi, ni ndácùcahan tnùñuhu nèhivì quìvì‑ní; te yàchì nì sáà stná tiempu cusahnu‑ní ñuhìví yohó, xícàn tàhvì‑nsí. Te nacua quidá ana ndoó ansivi ñà‑ndùá dandacu‑ní, divi ducán ni quidá stná nèhivì ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pan xi‑nsi iin quìvì, iin quìvì taxi tahvi‑níà nùù‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Te cuicahnú inì‑ní sàhà cuàchi iníhícá‑nsî, vàchi nsiùhù, xicáhnû stná ini‑nsì sàhà nsidaa ana iníhícá nùù‑nsí. Te chindee‑ní nsiùhù ñà‑màsà dáca nèhivì nsiùhù, te dacácu stná‑ní nsiùhù nùù ñà‑malu nicanicuahàn. (Amén.) ");
INSERT INTO mitNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Te nì cachi stná‑yà xì‑né: ―Ni cachí‑ndà nú iá iin amigo xi‑nda, te dava ñùu sáà‑ndà vehe‑ne, te cachí‑ndà xì‑né: “Amigo, taxi ica‑ní ùnì pan nùí, ");
INSERT INTO mitNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","vàchi sànì quesaa iin amigo xi vehi, ichì caní nì quixi‑ne. Te còò ni‑iñàha cuàhi‑nè cuxi‑ne”. ");
INSERT INTO mitNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dandu amigo xi‑nda ini vehe ma, vihini tiacu‑nè, te cachi‑nè xì‑ndà: “Còó, màsà dáñáná‑nî yùhù, vàchi ndiadí vàha yehí, te itánduhù‑nsí xì dèhe‑nsi. Mà cùì ndácòi cuàhi mii‑ní ñà‑ndùá xícàn‑ní”, cachi‑nè vihini. ");
INSERT INTO mitNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Cunaha‑nsiá, mate amigo xi‑nda nduú‑né, doco ni sàhà ñà‑jaàn mà cándísâ‑né ndacòo‑ne cuàha‑nèndó ñà‑ndùá xiñuhu‑nda. Còó, doco sàhà‑ñá nì cunaha iin‑nda cáhàn‑ndà yehè‑né, ñàyùcàndùá icúmí‑nê ndacòo‑ne cuàha‑nèndó iñàha. ");
INSERT INTO mitNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Te yùhù cachí stnáì xì‑nsiá, càcàn tàhvì‑nsiá, te nìhìtáhvì‑nsiá. Nanducu‑nsiá (ñà‑vàha nùù‑yá), te tùia. Càhàn‑nsià (yehè‑yá), te nuna. ");
INSERT INTO mitNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vàchi nsidaa ana xícàn tàhvì, icúmí‑nê nìhìtáhvì ndisa‑neà; te nsidaa ana nandúcú xí ñà‑vàha, icúmí tùi ndisamà núù‑né; te nsidaa ana xícàn tàhvì nùù yehè‑yá, icúmí‑yâ nacuna‑yañà nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Nú ni cácàn iin dèhe‑nsia iin pan cuxi‑tè, amádi pan cuàha‑nsiàte, te màdì iin yùù. Te nú cuñu siaca xícàn‑te, màdì iin còò cuàha‑nsiàte. ");
INSERT INTO mitNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Te ò nú nsìvì xícàn‑te caxì‑té, màdì iin sìduhma cuàha‑nsiàte. Còó. ");
INSERT INTO mitNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mii‑nsiá, mate nèhivì cuáchi nduú‑nsiá, doco tùha‑nsia cuàha‑nsia dèhe‑nsia ñà‑ìá viì. Ñàyùcàndùá Yuamánì‑ndà iá ansivi, chicá icúmí‑yâ cuàhatahvì‑yá mii‑nsiá Espíritu Ìì xí‑yá nú ni cácàn tàhvì‑nsiá nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Daaní, iin xichi nì cuu nì tavà‑yá iin ñà‑malu ìhìn (ní nsida ihin xi) iin nèhivì. Daaní, nì nsihi nì queamà, dandu vàtùni nì nacahàn nècuàchìmà. Te nì ndulocó nèhivì cuáhà ndoó yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Doco dava‑ne, nì (xitnùhu‑ne), cachí‑nè: ―Ñà‑malu cusáhnû nani Beelzebú, divi nduú ana chindéé, te ducán tavá Jesús ñà‑malu ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Te dava ga stná nèhivì yucán, nì xìcàn‑nè quida‑ya iin milagru xi Dios cundehè‑né, a ndísá cui quida‑yañà, á coó, cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Doco mii‑yá, ináhá‑yâ ñà‑ndùá nacání ini‑nè. Ñàyùcàndùá, nì cachi‑yà xì‑né: ―Nècuàchì xídandacú nùù iin ñuu, nú ni táhndè dava‑ne, te náâ stnahá‑né, dandu còò gá modo cadandacú gá‑nè nùù ñuu mà; te nèhivì ndoó iin vehe, nú xiní ùhì stnahá‑né, dandu mà cúí cundoo tàcá gà‑nè vehe ma. ");
INSERT INTO mitNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Te ñà‑malu Satanás, nú ni cuní ùhì‑si tnaha‑sì, dandu mà cúí gá dandacú‑si nùù quisì dava ga mà. Ducán cachíˋ, vàchi cachí mii‑nsiá sàhí ñà‑chìndéé sì‑Beelzebú yùhù, te ducán taví ñà‑malu. Doco còó, ");
INSERT INTO mitNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","vàchi stná nèhivì xí mii‑nsiá, tùha stná‑nè tavà‑né ñà‑malu, te ¿ana dìpódêr‑xi quidá‑néàmà? (Amádi poder xi Dios chindéé xí‑nê), ñàyùcàndùá, vàtùni cachi mii‑né xì‑nsiá ñà‑cónì cachí viì‑nsiá sàhà yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Doco Dios nduú ana chindéé xî tavíˋ‑si, ñàyùcàndùá náhà xìcà ñà‑vichi sànì sàà tiempu cunì‑nsia nansa dandácû ndiaha Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Iin tiàa ndacuì, nú nihí‑te iin càa dana, te ndiaá‑te vehe‑tè, dandu còò ni‑iñàha cuu xi ñà‑ìcúmí‑tê. ");
INSERT INTO mitNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Doco nú ni quésáá iin ndósàhnú chicá fuerte, te cundee ndómà nùù‑té, dandu dandiachi nsihi‑nda arma nihí‑te, divi arma tuxí‑te cuàhàn chindee xi‑té nì cùí. Daaní, icúmí ndósàhnùmà nìhì‑ndà nsidaa ñà‑ìcúmí‑têmà, te quida‑nda xán nacua cudiì ini‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Nsidaa ana có‑ìá favor xi, contra‑xi nduú‑né; te nsidaa ana có‑chìndéé xî danátáquì (nèhivì xí), ducán queámà na ian tàxì‑né nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Nú sànì quee ñà‑malu nùù ini iin nèhivì, dandu xicánúú‑si, yáha‑sì lugar ìchí, nandúcú‑sî ndé coo dadí‑si; te nú ni cúndáà inì‑si mà cùì, dandu cachí‑si: “Còó, chicá vàha nùhì ini nèhivì ndé nìsa ìe antes, vàchi vehi nduá”. ");
INSERT INTO mitNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ñàyùcàndùá, mànuhù‑sí anima nèhivì mà, te quidá‑si cuenta na ian sànì ndundoa, te nì nducutá. ");
INSERT INTO mitNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ñàyùcàndùá, cuàhàn‑si nácuàca‑sì inga ùsà tnaha‑sì chicá tùha quini, te caquìhvi nsihi‑sì ini anima nècuàchìmà ñà‑cuñuhu‑sì yucán. Sàhájàn chicá pesadu nàcòo tiàa ma nùù antes. ");
INSERT INTO mitNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na cáhàn‑yà ñà‑jaàn xì nèhivì cuáhà mà, dandu nì cachi iin nècuàchì ñahà xì‑yá: ―Nansicáhán nècuàchì nì dàtúinuù xì‑ní ñuhìví, te nì dàchìchì‑né mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dandu nì cachi‑yà xì‑né: ―Jaan. Doco chicá vàha cachi‑ndà nansicáhán nèhivì iníní xí Palabra ìì xí Dios, te quidá ndisa‑neà cumplir. ");
INSERT INTO mitNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Daaní, chicá nì nachitu nèhivì cuáhà nùù‑yá. Te nì càhàn‑yà xì‑né, cachí‑yà: ―Nèhivì tiempu vichi, malu‑nè. Xícàn‑nè coo iin milagru cundehè‑né, a ndísá icúmî poder cahan‑né. Doco mà níhì‑né cundehè‑né inga milagru, cuisì ñà‑ndùá (nì xini nèhivì sànaha) na ní cuu iin milagru xì Jonás, iin nècuàchì nìsa cahàn cuenta xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Vàchi milagru xi Jonás mà, ñà‑yùcán nì sanduu iin seña nùù nèhivì ñuu Nínive. Doco divi ducán icúmí cuu xi stná yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmí cuu stná iin milagru xìˊ, te cunduu stná mà iin seña nùù nèhivì tiempu vichi. ");
INSERT INTO mitNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na quìvì cuu juiciu, te màcuìta nsidaa nèhivì tiempu vichi (nùù Dios), dandu yucán icúmí nàcuììn stná iin nècuàchì ñahà nì sanduu reina dandacú nùù ladu sur sànaha. Te daquée cuàchi‑ne dìquì nèhivì tiempu vichi, vàchi dècuèndè iin ñuu chicá xica nì quixi‑ne ñà‑cunini‑ne cáhàn nchichí guâ rey Salomón. Doco cunaha‑nsiá, vichi sànì quesaa inga ana chicá nchichí nùù Salomón mà, doco (có‑ndùlócô nèhivì). ");
INSERT INTO mitNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Te quìvì coo juiciu mà, yucán màcuìta stná nèhivì ñuu sànaha nani Nínive, te daquée cuàchi stná‑nè dìquì nèhivì tiempu vichi, vàchi nèhivì yucán, nì naxicocuíìn ini‑nè sàhà cuàchi‑ne na ní càhàn Jonás xì‑né. Doco nèhivì tiempu vichi, còó, có‑nàxícócuîìn ini‑nè mate sánì quesaa ana chicá ndiaha nùù Jonás mà. ");
INSERT INTO mitNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Iin lámpara, có‑nàcuícun‑ndañá sàhà‑ñá cuiin dèháˋ; ni mà cuíán tìxi iin ìcà; còó, icúmíâ cuian ndé ducún, dandu cutnuà cutùi nùù nèhivì yáha ini vehe. ");
INSERT INTO mitNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nduchìnúù‑ndà nduú ñà‑tùínúù iquìcúñú‑ndà. Ñàyùcàndùá, nú iá vàha ma, dandu vàtùni cutùi nuù‑ndà ñà‑quida‑nda nsidanicuú iñàha. Doco nú cuhí nduchìnúù‑ndà, dandu nàcuìtnùù núù‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Te ducán stná xì anima‑ndà. Ñàyùcàndùá, cuidadu cundoo‑nsia, còtó cuiin tnuu ini anima‑nsià ndé cuàhàn datnúù mii‑yá nì cùí. ");
INSERT INTO mitNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Doco nú ndisa, inicutu sàxìnítnùní‑nsià datnúù‑yà, dandu mà cóó ni‑iin lugar ndé iín tnúú, vàchi cunduamà na ian nchií ndiaha inicutu sàxìnítnùní‑nsià, te quee stná mà na ian tnúù fuerte iin lámpara nùù‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Daaní, na ní nsihi nì càhàn‑yà, dandu nì quida iin nècuàchì fariseu mii‑yá invitar cùhùn‑yà cuxi‑ya xì‑né. Ñàyùcàndùá cuàhàn‑yà, te nì yàha‑ya ini vehe nècuàchìmà, te nì sàcòo‑ya. ");
INSERT INTO mitNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Doco nècuàchìmà, nì ndulocó‑nè ñà‑cónì ndàhá‑yá nacua nduú estilu xi‑ne na cuáhàn‑nè cuxi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dandu nì cachi Stoho‑ndà Señor xì nécuàchìmà: ―(Ndahví estilu chívàha) mii‑nsiá nècuàchì fariseu, vàchi ducán queámà na ian nacáté‑ndá iin pocillu, ò iin còhò, te cuisì yàtà‑ñá ndoó, doco (inià, quini iáˋ. Pues ducán iá stná) ini anima mii‑nsiá, vàchi sànì xida cuàchi‑nsia ñà‑xího guá‑nsià cuàhà iñàha, te nihnú quini ini‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ndahví‑nsià! vàchi mà túha‑nsia cundaà inì‑nsia. ¿A có‑ìnáhá‑nsiâ ñà‑iin‑ni mii‑yá nì quida vàha xi stná anima‑nsià, màdìá cuisì iquìcúñú‑nsià? ");
INSERT INTO mitNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Doco nú nihnú vàha inì‑nsia, te cutùha‑nsia dacútâhvì stnahá‑nsiá, dandu vàtùni cundaà inì‑nsia iá viì nsidaa ñà‑ndùá (nì quidayucun Dios). ");
INSERT INTO mitNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ndahví mii‑nsiá nècuàchì fariseu! vàchi mate túha ndisa‑nsia cuàha‑nsia diezmu, (iá gà ndé có‑quìdá viì‑nsiá). Mate sáha‑nsia diezmu xi yùcù cuatiluha caxì‑ndà nahi ndua ndòò, ò yùcù cuati nani ruda, doco nú nduá (iin chuun cahnú), có‑ndùlócô‑nsià sàhámà, vàchi có‑nìhnú ndàcuisì ini‑nsià, ni mà túha stná‑nsià cuu ini‑nsià sàhà Dios. Pues divi ñà‑jaàn ndisa ndiá ìcà‑nsiá quida‑nsia cumplir, te ni có‑xìñùhù nacoo stná‑nsià diezmu mà. ");
INSERT INTO mitNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Ndahví mii‑nsiá nècuàchì fariseu! vàchi na sáhàn‑nsià veheñùhu, cuisì lugar ndé cundoo viì‑nsiá nandúcú‑nsiâ; te na sáhàn‑nsià yàhvi, cuní stná‑nsià casàhú tnùñuhu cuàhà nèhivì xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ndahví mii‑nsiá nècuàchì ley xi veheñùhu, xì mii stná‑nsià nècuàchì fariseu! Datiaá uun‑nsia vàha‑nsia. Vàchi na iin yavi xi nsìi, ducán iá mii‑nsiá, te ò na iin ñaña có‑nâhà gà, te vihini cuànihni nèhivì nùá ñà‑có‑sâha‑ne cuenta nduá yavi. Ducán iá stná mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dandu iin maestru xi ley ìì mà, nì cachi‑nè xì‑yá: ―Maestro, nú ducán cachí‑nî sàhà nècuàchìmà, dandu queámà na ian dìquì stná nsiùhù cáhàn‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dandu nì cachi‑yà xì nècuàchìmà: ―¡Ndahví stná mii‑nsiá nècuàchì ley xi veheñùhu! vàchi tùha‑nsia quidayucun‑nsià cuàhà ley ñà‑chivàha nèhivì, mate mà cúndéé ini‑nè quida‑neà. Doco mii‑nsiá, có‑dûcùn ni‑iin dìnìndàhá‑nsiàñà. ");
INSERT INTO mitNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ndahví‑nsià! vàchi tùha‑nsia quidavàha‑nsia monumentu nùù ñaña xi nècuàchì nìsa cahàn cuenta xi Dios sànaha, doco divi xìì‑nsiá nduú ana nì sahnì xì nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ñàyùcàndùá, ducán queá na ian cudíì inì‑nsia sàhà cuàchi nì quida xìì‑nsiámà, vàchi dihna mii‑né nì sahnì xì nècuàchìmà, dandu vichi (daxínu mii‑nsiá chuun xi‑ne), quidávàha‑nsia monumentu xi nsìi ma. ");
INSERT INTO mitNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ñàyùcàndùá, dohó cachí Dios ñà‑nchìchí guâ‑yà: “Cuàhà profeta icúmî techuín, te càhàn‑nè xì nèhivì ñà‑ndùú razón xi. Te cuàhà stná nècuàchì apóstol icúmî techuín nùù‑né. Doco nèhivì malu mà, cahnì‑né nèhivì xí, te nú coó, siquiera taxi‑né nècuàchìmà”, cachí Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Doco cunaha‑nsiá, icúmí nèhivì tiempu vichi cunsida‑ne cuàchi sàhà nsidaa profeta nì casahnì nèhivì dècuèndè tiempu nì cuàha ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ñà‑ndáà nduá cachíˋ xì‑nsiá, icúmí nèhivì tiempu vichi cunsida‑ne cuàchi sàhà nsidaa profeta nì xìhì mà dècuèndè tiempu nì xìhì Abel xì dècuèndè tiempu nì xìhì stná Zacarías, divi Zacarías nì sahnì‑né mahì veheñùhu cahnú xì mesa ìì ndé sahmí‑né ñà‑càmánì‑ndà Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Ndahví mii‑nsiá nècuàchì ley xi veheñùhu! vàchi ducán iá na ian dandacú‑nsiá sàhà (vehe ndé dacuahá) nèhivì cundaà ini‑nè (sàhà Dios), doco nì chidèhé‑nsià ndahàcáa nuna yehè vehe ma. Ni cónì quíhvi mii‑nsiá ñà‑cundaà ini‑nsià sàhà‑yá, te nì sadi stná‑nsià nùù nèhivì cuní quìhvi dacuahá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Daaní, nì nsihi nì cachi‑yà nsidaájàn, dandu nì xìdà ini nècuàchì ley xi veheñùhu ma, xì stná nècuàchì fariseu, te nì caquesaha‑né nì càhàn ndee‑né xì‑yá, cuní‑nè càhàn‑yà, te cachi‑yà sàhà cuàhà iñàha, ");
INSERT INTO mitNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","áma cáchí‑yà iñàha ñà‑cui daquée cuàchi‑ne dìquì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Vichi sànì nataca chitu cuàhà mil nèhivì, dècuèndè sánihni tnahá‑né. Dandu nì càhàn Jesús xì nèhivì mà. Primeru nì càhàn‑yà xì nècuàchì dacuahá‑yá, cachí‑yà: ―Cuidadu cundoo‑nsia, còtó quida‑nsia na quidá nècuàchì fariseu. Vàchi nacua (còò permisu cuichuún‑nsiá) levadura (vicò xí‑nsiá), divi ducán còò stná permisu quida‑nsia na quidá nècuàchìmà, danani úún‑né nduú‑né nèhivì váha. ");
INSERT INTO mitNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Cunaha‑nsiá còò ni‑iñàha coo dèhé nicanicuahàn. Icúmíâ tùia, te cunitnùhu nèhivì sàhá. ");
INSERT INTO mitNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Dècuèndè stná ñà‑ndùá nì cachi nèhivì na ndoó dèhé‑nè ndé iín tnúú, icúmí palabra mà natùi vate stná ndé nchií orá. Te mate caya nì càhàn iin tiàa sàhà tùtnù compañeru‑nè ndé ndoó‑né vehe chicá ndiadí, doco icúmí palabra mà (cuìtià), vàchi nana ducún nèhivì, te cachitnùhu ndee‑né nsidaámà. ");
INSERT INTO mitNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Amigos, cachíˋ xì‑nsiá: màsà yúhî‑nsià ana cui cahnì xì cuisì iquìcúñú‑nsià; còó, vàchi nú sànì xìhì‑nsià, dandu còò cá ni‑iñàha cui quida ga‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Doco yùhù cachíˋ xì‑nsiá ana ndiá ìcà‑nsiá yùhí‑nsià. Xiñuhu yùhí ndisa‑nsia mii‑yá ana icúmí derechu dandiachi xi anima‑nsià andea nú sànì xìhì‑nsià. Mii‑yá, ndisa xiñuhu yùhí‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Sàhà cuisì ùì tuní dicó‑né ùhùn chòlìhì. Doco ni‑iin quisì mà, có‑nândòdó Dios‑si. ");
INSERT INTO mitNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dècuèndè ináhá stná‑yà nadaa idìdínì itá dìnì iin iin nèhivì. Ñàyùcàndùá, màsà nácání inì‑nsia, vàchi chicá ndiaá‑nsià nùù iin chòlìhì tìì, te ò núù cuàhà stná‑si. ");
INSERT INTO mitNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Yùhù cachíˋ xì‑nsiá, nú cachí vate iin nèhivì ñà‑ndùú‑né nèhivì xí, dandu yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmí stnáì cachì nùù ángel xi Dios ñà‑divi nèhivì xí nduú stná nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Doco nú ni chídèhé‑nè ñà‑ndùú‑né nèhivì xí, dandu yùhù stná, icúmî nacuaà stnáì mii‑né nùù ángel xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Mate ni cáhàn ùhí iin nèhivì dìquì yùhù ana nduú Tnaha Nèhivì Ñuhìví, doco vàtùni nìhì‑né cuicahnú ini Dios sàhà‑né. Doco nú dìquì Espíritu Ìì sànì càhàn ùhí‑nè, dandu mà nunca sàà‑yà cuicahnú ini‑yà sàhà nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Daaní, nú ni dátnâtuu nèhivì mii‑nsiá nùù nècuàchì dandacú nùù veheñùhu, ò núù juez, te ò nùù tè‑nìhí chuun, màsà nácání ini‑nsià nansa naxiconihí‑nsiá nùù‑té, ");
INSERT INTO mitNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","vàchi momentu yucán icúmí Espíritu Ìì xí Dios chindee‑yá mii‑nsiá ñà‑cundaà ini‑nsià índù‑ñá chicá ndiaha cachi‑nsià ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Daaní, iin tiàa iín mahì nèhivì cuáhà yucán, nì cachi‑nè xì Jesús: ―Maestro, càhàn‑ní xì ñanì ñà‑nì cándísâ‑né dacuachí‑né interés nì ndutahvì‑nsí (nùù yua‑nsí). ");
INSERT INTO mitNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dandu nì cachi‑yà xì nècuàchìmà: ―Senór, còò chuun ni níhìˊ cundui juez nsidandaì sàhà chuun xi mii‑nsiá, ni có‑ndùú stnáì iin ana dacuachi‑xi biene xi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Te nì cachi stná‑yà xì nèhivì cuáhà mà: ―Cuidadu cundoo‑nsia, màdí xihò‑nsiá cuàhà iñàha, vàchi mate ni coó cuàhà gá biene xi‑nda, có‑cùní cachàmà ñà‑sànì nìhì ndisa‑nda vida ndiaha. Còó. ");
INSERT INTO mitNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dandu nì nacani‑ya xì‑né iin ejemplu, cachí‑yà: ―Nìsa ìa iin tècuìcà; te iin cosecha cahnú nì cuàha itù‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ñàyùcàndùá, nì nacani inì‑te, cachí‑te: “¿Nansa quide? Vàchi có‑cuâhà gá ndé covàha cosecha xi”. ");
INSERT INTO mitNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dandu nì cachì‑te: “Chicá vàha dohó quide; cuàhìn duquín vehe cuachi yohó, te quidavàha saí vehe chicá nahnú sàhà‑ñá vàtùni sàà nàcòvàha cosecha xi, xì nsidaa gá stná ñà‑cuìqué. ");
INSERT INTO mitNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dandu cachì inì‑ni mií: Vichi sà‑ìá cuàhà iñàha iá vàha. Vàtùni sàà ñà‑jaàn cutiacuì cuàhà cuìà; vàtùni quetatuì vichi, vàchi iá ñà‑cuxi, te cohi. Contentu cuàhìn coi”, nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Doco nì càhàn Dios xì‑té, cachí‑yà: “¡Loco ió! vàchi ñuú vichi icúmî naquihin animo, dandu nsidaa biene sànì chivàhu, ¿ana ndòo xán?”, nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Te ducán icúmí coo xì nèhivì dacáyà xì cuàhà ñà‑cuìcà sàhà mii‑xí, te nú còò ni‑iñàha nduú ñà‑cuìcà ndisa‑ne nùù Dios ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Daaní, después nì cachi stná‑yà xì nècuàchì dacuahá‑yá: ―Yùhù, cachíˋ xì‑nsiá, màsà nácání ini‑nsià sàhà vida xi‑nsia nansa nìhì‑nsiá ñà‑cutiacu‑nsià, ni sàhà cuerpu xi‑nsia, nansa tùi ñà‑cundixi‑nsia. Còó, ");
INSERT INTO mitNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","vàchi màdì cuisì ñà‑cuxi‑nda nduá xiñuhu sàhà‑ñá cucumi ndisa‑nda vida ndiaha; te cuerpu xi‑nda ¿amádi chicá ndiaámà nùù sìcoto ndìxì‑ndà? ");
INSERT INTO mitNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cundehè‑nsiá càlù, có‑xìtú‑si, có‑ndàníhí‑si cosecha xi‑sì, ni còò vehe icúmí‑sî, ni còò stná ni‑iin lugar ndé chívàha‑sì iñàha; doco Dios, dacútiácú‑yàsi. Te mii‑nsiá, ¿amádi chicá ndiaá‑nsià nùù laa mà? ");
INSERT INTO mitNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Cunaha‑nsiá, mate yáha ga sahní‑nsiá dìnì‑nsiá, te nacání inì‑nsia, uun‑ni nduámà, mà níhì‑nsiá cuahnu ga‑nsià ni‑iin dava metro. ");
INSERT INTO mitNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ñàyùcàndùá, nú mà cùì quida‑nsia chuun tii jaàn, dandu chicá vàha màsà cáhni gá‑nsià dìnì‑nsiá sàhà chuun dava ga. ");
INSERT INTO mitNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Cundehè‑nsiá nansa sahnú ita nani lirio; có‑quìdáchúûn‑yá, ni có‑quìdávàha stná‑yà sìcoto, doco chicá ndiaha ita mà nùù rey Salomón (nìsa ìa sànaha), mate yáha ga vico nì sandixi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iin ita, yùcù‑ni nduá, (có‑ndiàá ndisa); quìvì vitni iáˋ campu, te tnaa sànì ìchà, vihini quèa xìtnù coca. Mate ducán nduá, doco ndiaha gá nì quìdavàha Dios ita mà. Ñàyùcàndùá, vihi gá icúmí‑yâ cuàhatahvì stná‑yà ndohó iin ñà‑cundixi‑nda. Doco mii‑nsiá, iyuhu gá xiníndísâ‑nsiá Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","’Màsà cácánúú‑nsiá cahnì‑nsiá dìnì‑nsiá nansa tùi ñà‑cuxi‑nsia, coho‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vàchi nsidaa nèhivì ndoó ñuhìví, divi ñà‑jaàn nduá nandúcú‑nê. Doco ndohó, iá Yuamánì‑ndà Dios, te ináhá‑yâ xiñuhu nsidaámà nùù‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ñàyùcàndùá, dihna xiñuhu nanducu‑nsiá nansa chivàha viì‑nsiá ley xi ñuhìví ìì xí‑yá, dandísá nìhì stná‑nsià nsidaa ñà‑ndùá cumánì gá nùù‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Mii‑nsiá, nahi riì‑xí nduú‑nsiá, te cachíˋ xì‑nsiá, màsà yúhî‑nsià, mate mà túù‑nsiá, vàchi sànì chitnùní ini Yuandiaha‑nsiá ñà‑cundiatú anima‑nsià ndè ñuhìví ìì xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","’Dicò‑nsiá biene xi‑nsia, te dacútâhvì‑nsiá nècuàchì ndahví. Dandu queámà na ian sànì chivàha‑nsia ñà‑cuìcà‑nsiá ndè gloria. Te queé stná na ian iá vàha mà ini iin itni mà sáà tèhì, vàchi ndè gloria yucán, mà sáà ndañuhá, vàchi mà quíhín tècuìhnà‑ñá, ni mà cúsíquídí stná. ");
INSERT INTO mitNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Vàchi ndé quida‑nda cuenta iá vàha ñà‑cuìcà‑ndà, divi lugar yucán cuàhàn‑ndà cunihnu cuàhà ini anima‑ndà ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Dandu nì cachi‑yà: ―Cundoo tùha‑nsia na ian quidá peón xíndiatu na nsiáá lamú xi‑tè na cuáhàn nècuàchìmà vicò nandàhà; nacuícun‑té lámpara, te yáha ga ndiatú‑te. Daaní, nú sànì nsiaa nècuàchìmà, te nì càhàn‑nè yehè, dandu vichi vichi cuàhàn‑te nacuna‑tè nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nansicáhán‑tê nú ndiatú tùha‑tè na nsiaa‑nè, vàchi seguru icúmí‑nê quidayucun‑nè, te dayáha‑ne peón mà ndé cundoo‑tè cuxi‑tè. ");
INSERT INTO mitNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Te nú ndè dava ñùu, ò ndéˋ sinduhá ni nsiaá lamú mà, te xíndiatu ìì peón mà, pues nansicáhán‑tê nì sandiatu‑tè. ");
INSERT INTO mitNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","’(Inga ejemplu), nú ináhá‑ndá ndévì hora quixi tècuìhnà quìhvi‑tè vehe‑nda, dandu cundiatu tùha‑nda, mà cuáha‑nda quìhvi‑tè. ");
INSERT INTO mitNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Divi ducán stná mii‑nsiá, cundoo tùha stná‑nsià, vàchi iin quìvì có‑nìhnú inì‑nsia naxicocuíìn yùhù ana nduú Tnaha Nèhivì Ñuhìví ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dandu nì cachi Pedro xì‑yá: ―Señor mío, ¿a ní nacani‑ní ejemplu jaàn ñà‑cutùha miiní nsiùhù, te ò cuní stná‑ní quihin casu nsidaa nèhivì dava ga? ");
INSERT INTO mitNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Dandu nì cachi Stoho‑ndà Señor xì‑né: ―¿Ana tuxí ini‑nsià nduú nahi peón nùù ejemplu yohó? Nì ìa iin peón; tùha‑tè quida viì‑té, quidá sahnú‑te. Te nì nìhì‑té chuun nùù lamú xi‑tè ñà‑dandacú‑te nùù peón dava ga, te dasàn stná‑te ñà‑cutiacu nsidaa nècuàchìmà quìvì cuiñuhá. Daaní, cuàhàn lamú mà. ");
INSERT INTO mitNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pues nansicáhán peón nì ndòo dandacu‑ma nú iin‑ni quidá víi‑té dècuèndè nsiaa tu lamú xi‑tè. ");
INSERT INTO mitNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cunaha‑nsiá, icúmí nècuàchìmà cuàha‑ne peón mà chuun ñà‑dandacú‑te sàhà nsidanicuú ñà‑cuìcà‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Doco nú nacání chicuéhè ini peón mà, te cachí‑te: “Cucuee va lamú xi, dandu nsiaa‑nè”, te quesáhá‑tê cahnì cuií‑te peón dava ga mà, tiàa‑ne te ñahà‑né, te cuisì‑ní ñà‑cuxi‑tè, te coho‑tè cucahan‑té, te cutnáhâ stná‑te xi tè‑xíni xihí‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pues nú quidá‑te ducán, dandu icúmí lamú xi‑tè nsiaa‑nè iin quìvì có‑nìhnú inì‑te, cundua iin tiempu có‑ìnáhá‑tê, dandísá nìhì‑té iin castigu cahnú sàstnùhù, iin‑ni ndoho‑tè ñà‑ndùá icúmí ndoho nsidaa gá ana có‑xìníndísâ xí‑yâ. ");
INSERT INTO mitNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Iin peón, nú ináhá vâha‑tè ñà‑ndùá cuní lamú xi‑tè quida‑tè, te có‑quìdá‑teá, có‑ìníní‑te ñà‑ndùá cachí‑nè, dandu cuàhà gá icúmí‑tê ñàhnì‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Doco nú có‑cùndáà vàha ini peón mà, te quidá‑te iin falta, dandu chicá iyuhu ñàhnì‑te. Vàchi ducán queá na ian nacóó‑ndá cuàhà ñà‑ìcúmí‑ndá nùù ndahà inga nèhivì (ñà‑cundiaa‑nèà). Pues nú ducán, dandu cuàhà stná iñàha icúmí‑ndá naquihin‑nda nùù nècuàchìmà. Vàchi nú ni ndóo cuàhà iñàha ndahà iin nèhivì, dandu divi‑ni ducán cuàhà iñàha icúmí stná‑ndà nandacàn‑ndà nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Cunaha‑nsiá, yùhù vàxi cundui nahi ñuhu quìñuhu ñuhìví, (vàchi sàhà yùhù icúmí nèhivì tàhndè dava‑ne). Te ¡a sácú vàha ñà‑sànì quiñuhu ñuhu mà ni cúndúá! ");
INSERT INTO mitNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Vàchi iá iin tnùndoho icúmî yàhi, te cuàhà gá nacání inì ndè cachi sàà hora yàhamà. ");
INSERT INTO mitNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A túxí inì‑nsia vàxi ñuhìví yohó ñà‑cucumi nèhivì paz? Còó, vàchi sàhà yùhù icúmí tàhndè dava nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ndè vichi xi ndéˋ quìvì nùù‑xí icúmí tàhndè dava‑ne. Por ejemplu, nú iá iin vehe, te ndoó ùhùn nèhivì, ùnì‑nè cuni ùhì xì nècuàchì ùì mà. Te nú coó, ùì‑nè cuni ùhì xì nècuàchì ùnì mà. ");
INSERT INTO mitNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Te ò iin tiàa, cuàhàn‑nè cuni ùhì‑nè dèhe‑ne, te nú coó, dèhe‑ne cuàhàn cuni ùhì xì mii‑né; te ò iin nècuàchì ñahà, cuni ùhì‑nè dèheyoco‑né; ò nú coó, dèheyoco‑némà cuni ùhì xì mii‑né; te ò dìdo iin nècuàchì ñahà cuni ùhì xì sànu‑ne; ò nú coó, sànu‑nemà cuni ùhì xì mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dandu nì cachi‑yà xì nèhivì cuáhà ndoó yucán: ―Mii‑nsiá (nècuàchì ñuu yohó), nú nì xinì‑nsia itá vìcò ladu quécahnu orá, dandu cachí‑nsià: “Vàxi dàvì”, te ducán iá. ");
INSERT INTO mitNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te nú caná tàchì ladu sur, dandu cachí‑nsià: “Cuàhàn coo ihni”, te divi ducán coo. ");
INSERT INTO mitNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Ndahví‑nsià! Danani uun‑nsia nchichí ndisa‑nsia, vàchi mate túha‑nsia nacuni‑nsià seña iá ñuhìví xì ansivi, doco ¿índù chuun mà cùì nacuni stná‑nsià índù tiempu nduá vichi? ");
INSERT INTO mitNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Có‑chìndéé sàxìnítnùní‑nsià mii‑nsiá sàhà‑ñá cui mànìhì inì‑nsia índù chuun nduá chuun vàha. ");
INSERT INTO mitNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","’Nú sànì sanicuàchi iin tiàa sàhà iin‑nsia, te ndacá‑tensiá cuàhàn nùù tè‑nìhí chuun, dandu chicá vàha nanducu‑nsiá ñà‑nacahan stnahá‑nsiá Dios sàhà‑nsiá na meru xicá‑nsiá ichì cuàhàn‑nsià, te màdìá cundaca‑tènsiá sàà nùù juez, vàchi juez mà, dayáha‑tènsiá ndahà comandante xi‑tè, te chicadi tèmà‑nsiá vehecàa. ");
INSERT INTO mitNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Te ñà‑ndáà nduá cachíˋ xì‑nsiá, nú ni cuu‑xi‑nsiá ducán, dandu mà quéé gá‑nsià dècuèndè nú sànì dànáà nsìhí‑nsiá nsidanicuú ñà‑ndùá nihícá‑nsiâ ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Daaní, tiempu yucán nì cachitnùhu nèhivì xì‑yá nansa nì cuu xi nècuàchì ladu Galilea, nì dàndàcú Pilatu, te nì sahnì soldadu‑nè na meru sáhatahvì‑né quisì nduú promesa xi‑ne nùù Dios; meru xíhì quisì mà, te nì sahnì‑ténê. ");
INSERT INTO mitNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dandu nì naxiconihí‑yá nùù nècuàchì nì nacani ma, te dohó nì cachi‑yà: ―Nècuàchì Galilea mà, ¿a tuxí ini‑nsià ñà‑chicá nì sanduu‑ne nèhivì cuáchi nùù nsidaa nècuàchì ñuu‑nè, te sàhámà nì xìhì‑nè ducán? ");
INSERT INTO mitNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Còó, cachíˋ, vàchi divi ducání ndañuhu stná mii‑nsiá nú màsà cúú‑nsiá arrepentir sàhà cuàchi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Te ináhá stná‑nsià nansa nì cuu yatni Siloé yucán na ní ndua iin torre, te nì chàhmà sàhùn ùnì nèhivì. Pues ¿a tuxí ini‑nsià chicá nìsa ìa cuàchi nècuàchìmà nùù nsidaa gá nèhivì ñuu‑nè Jerusalén? ");
INSERT INTO mitNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Còó, cachíˋ; vàchi dècuèndè mii stná‑nsià, divi ducání icúmí stná‑nsià ndañuhu‑nsiá nú màsà náxícócuîìn inì‑nsia sàhà cuàchi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dandu nì nacani‑ya ejemplu yohó: ―Nìsa ìa iin tiàa icúmí xí iin ñuhù iá ñà‑tàtá, te yucán iín stná iin nù‑higu. Te nì sàà tiàa ma iin xichi yucán, cuàhàn‑nè cuida‑ne fruta‑nu ni cuí, doco còò ni‑iin sìhigu‑nu ni ndácùhun‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ñàyùcàndùá, nì cachi‑nè xì tèndiàá xì yutnù tatá mà: “Cunaha‑ní, sàcuàhàn ùnì cuìà quixí indéhí, áma níhìˊ sìhigu yutnù yohó cahín, doco còò‑sí. Ni táhndè‑nu chicá vàha; có‑cùníˋ cuiin uun gà‑nu yohó”. ");
INSERT INTO mitNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Doco peón mà, nì cachì‑te: “Senór, nacoo gà‑nínu dècuèndè inga cuìà, vàchi cuníˋ dadayíˋ ñuhù sàhà‑nú, te daquéi majada, ");
INSERT INTO mitNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","áma cuáha‑nùsí; te nú coó, dandísá, tàhndè‑nu”, nì cachi peón mà. ");
INSERT INTO mitNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Daaní, iin quìvì sábado iá‑yà iin veheñùhu dacuahá‑yá nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Te yucán nì quìhvi stná iin nècuàchì ñahà, sàhùn ùnì cuìà dandohó iin ñà‑malu‑nè, nì cuìtá yaa‑ne quidá‑si, ñàyùcàndùá xicá todo‑ne, mà cùì nácuììn ndàà‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Doco na ní xini Jesús‑nè, nì cana‑yanè ñà‑tnàtuu‑ne. Dandu ní cachi‑yà xì‑né: ―Mii‑ní nècuàchì ñahà jaàn, sànì quee cuèhè malu quidá quini xi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dandu nì chitàndòó‑yá ndahà‑yá dìnì‑né. Te vichi vichi nì ndundaà cuerpu xi‑ne, te nì nìhì‑né nì nàcuììn ndàà‑nè. Ñàyùcàndùá, cuàhà gá nì naquimanì‑né Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Doco nècuàchì dandacú nùù veheñùhu yucán, nì cuduchi ini‑nè, vàchi quìvì descansu nduá na ní dàndúvàha‑ya nècuàchìmà. Ñàyùcàndùá, nì cachi nècuàchì dandacu‑ma xi nsidaa nèhivì yucán: ―Ìñù quìvì ùún iá quidachuun‑nda; ñàyùcàndùá, quìvì jaàn quixi‑nsia nduvàha‑nsia, màdìá quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dandu nì naxiconihí Stoho‑ndà Señor nùù nècuàchìmà, cachí‑yà: ―¡Ndahví‑nî! ¡Cachí uun‑ní vàha‑ní! vàchi nsidaa‑nsiá, cada quìvì descansu ndàxìn‑nsiá buey xi‑nsia, ò burru xi‑nsia, te sáhàn‑nsia xì‑sí ñà‑coho‑sì tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Te nècuàchì ñahà yohó, descendencia xi xìì‑ndà Abraham nduú stná‑nè, ñàyùcàndùá, amádi ndiá ìcà stná‑nè dàñà stná‑nè nùù cuèhè itníí xí‑nê, mate quìvì descansu nduá, vàchi sàcuàhàn‑ndà sàhùn ùnì cuìà nuhní iquìcúñú‑nè quidá ñà‑malu ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Daaní, nsidaa nècuàchì xiní ùhì xì‑yá, nì nducahan‑ne; doco nèhivì cuáhà mà, nì cudiì ini‑nè sàhà nsidaa obra ndiaha quidá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Daaní, nì cachi gà‑yà xì‑né: ―¿Índù iñàha cui cachì sàhà‑ñá cundaà viì inì‑nsia nansa iá ñuhìví ìì xí Dios? ¿Índù ejemplu cui nacani xì‑nsiá, te sàà‑nsià cundaà ini‑nsià nansa iá tiempu mà? ");
INSERT INTO mitNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pues cunaha‑nsiá, nahi tata yutnù mostaza, ducán iá tiempu mà, na ian nì cuu na ní chihi iin tiàa tata mà itu‑nè, te nì sahnua; iin yutnù cahnú nì nanduu‑nù. Dècuèndè laa ndavá ansivi, vàxi stná‑si quidávàha‑sì tacà‑si mahì‑nú. ");
INSERT INTO mitNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Daaní, tucutu nì cachi‑yà: ―¿Índù ejemplu cui nacani xì‑nsiá sàhà ñuhìví ìì xí Dios? ");
INSERT INTO mitNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Na iin tàtnà nsidátáchí xí yusàn pan, ducán nduá, vàchi divia nì quihin iin nècuàchì ñahà nì dàquée‑ne mahì ùnì maquila yusàn harina, te nì ndutachi nsihá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Daaní, na xicá‑yá ichì Jerusalén, nì nacàhin‑ya ñuu nahnú te ñuu cuati, dacuahá‑yá nèhivì ndoó yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Te nì cachi iin nèhivì mà xì‑yá: ―Señor mío, ¿a iyuhu nèhivì cunduu nècuàchì càcu anima‑xi? Dandu nì cachi‑yà xì nsidaa nèhivì mà: ");
INSERT INTO mitNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Quida‑nsia lucha fuerte quìhvi‑nsia yehè sìtníhì gloria, vàchi ñà‑yòhó cachíˋ xì‑nsiá: nùù nsidaa nèhivì cucuni quìhvi yucán, cuàhà‑né, mà níhì‑né yàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Vàchi quida‑nda cuenta na ian iá iin vehe, te cuní‑nsià quìhvi‑nsia, doco sànì nacadi nècuàchì dìvéhé‑xímá yehè‑né. Ñàyùcàndùá sáà‑nsià, te cáhàn‑nsià yehè, cachí‑nsià: “Stoho‑nsì Señor, nacuna sacù‑ní nùù‑nsí”. Dandu nècuàchìmà, icúmí‑nê cachi‑nè: “Còó, tàcùníˋ mii‑nsiá, (ni có‑ìnáhî) índù nì quixi‑nsia”. ");
INSERT INTO mitNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dandu mii‑nsiá, cuàhàn‑nsià cachi‑nsià: “Nsiùhù, nìsa cutnahá‑nsí xì‑ní nì sandoo‑nda nìsa xixi‑nda nìsa xihi‑nda (tècuìí); te mii‑ní, nìsa dacuaha‑ní nèhivì ñuu‑nsì, calle ñuu‑nsì”. ");
INSERT INTO mitNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dandu nècuàchì sahnú yucán, icúmí‑nê cachi‑nè: “Yùhù cachíˋ xì‑nsiá, tàcùníˋ mii‑nsiá, ni có‑ìnáhî índù nì quixi‑nsia. Ñàyùcàndùá, cuahán‑nsià iladu, vàchi nècuàchì chicuéhè xínduu‑nsia”, cachi nècuàchì sahnu‑ma. ");
INSERT INTO mitNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pues (ducán stná mii‑nsiá), icúmí‑nsiâ cuni‑nsià na yáha xìì‑ndà Abraham ndè ñuhìví ìì xí Dios, mii‑né xì stná Isaac, xì Jacobo, xì nsidaa stná nècuàchì profeta nìsa cahàn cuenta xi‑ya sànaha. Nsidaa‑né icúmí‑nê màcùndoo‑ne nùù Dios ñuhìví ìì xí‑yá. Doco mii‑nsiá, còó; fuera icúmí‑nsiâ ndòo‑nsia. Dandu yáha ga cuàhàn‑nsia cuacu‑nsia, ndé càna nùhu‑nsia (ñà‑ndòhó guâ‑nsià). ");
INSERT INTO mitNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vàchi nsidanicuú ladu icúmí quee nèhivì sàà‑nè ñuhìví ìì xí‑yá, cunduu‑ne nèhivì vàxi ladu caná hora, xì nèhivì ladu quécahnu stnáˋ, xì nèhivì ladu norte, xì nèhivì ladu sur, nsidaa‑né icúmí‑nê casaà‑nè màcùndoo‑ne (ndé iá vicò) ñuhìví ìì xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Vàchi nèhivì nchícùn cahà‑xí vichi, icúmí‑nê sàà‑nè nàcòdò nùù‑né nùù‑xí (quìvì yucán), te nècuàchì idónuu vichi, icúmí‑nê sàà‑nè natenchicùn‑nè ndè cahà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Divi quìvì yucán nì casaà dava nècuàchì fariseu nùù‑yá, te nì cachi‑nè xì‑yá: ―Cuahán‑nî quecuaán‑nî yohó, vàchi cuní Herodes cahnì‑té mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dandu nì cachi‑yà xì nècuàchìmà: ―Cuahán‑nsià, te dohó cachi‑nsià xì tè‑ìcúmí guá maña mà: “Cunaha‑ní, vichi xi tnaa cuàhìn taví ñà‑malu ñuhú anima nèhivì, te dandúvàha stnáì nècuàchì cuhí, dandu quìvì ùnì cuàhìn dansihí chuun xi”. ");
INSERT INTO mitNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Doco sà‑ìá ñà‑caqui vichi, te tnaa, te idá, vàchi ndè ñuu Jerusalén nduú lugar ndé tùha ndisa nèhivì cahnì‑né iin ana cáhàn cuenta xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Ndahví mii‑nsiá nècuàchì ñuu Jerusalén! vàchi tùha‑nsia cahnì‑nsiá nècuàchì cáhàn palabra xi Dios, vàchi na techúûn‑yánè sàà‑nè nùù‑nsiá dandu caníyúú‑nsiânè ñà‑cui‑nè. Na cuahà guá xichi nì cunì danátáquì mii‑nsiá nùí na ian danátácá sìùn pilu xi‑sì ñà‑nàcùñuhu quisì mà tìxi ndìxì‑sí; doco còó, cónì cùní‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ñàyùcàndùá icúmí lugar xi‑nsia yohó ndòo nihnia. Te cachí stnáì xì‑nsiá, mà cúní gà‑nsià yùhù ndè cachi sàà quìvì cachi‑nsià xìˊ: “Ndiaha gá mii‑ní, vàchi divi ana vàxi cuenta xi Stoho‑ndà Señor nduu‑ní”. ");
INSERT INTO mitNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Daaní, iin quìvì descansu cuàhàn‑yà vehe iin nècuàchì idónuu nùù nècuàchì fariseu, cuàhàn‑yà cuxi‑ya yucán. Te vehe nècuàchìmà iá stná iin nècuàchì cuhí cuèhè cuiun, te iín‑né nùù‑yá. Ñàyùcàndùá, dava ga nècuàchì fariseu ndoó yucán, indéhe váha‑neyà, nansa quida‑ya. ");
INSERT INTO mitNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ñàyùcàndùá, nì cachi‑yà xì nècuàchì fariseu mà xì stná nècuàchì ley xi veheñùhu ndoó yucán: ―¿A sáha ley ìì xì‑ndà dandúvàha‑nda nèhivì nú quìvì descansu nduá? (Cachi‑nsià xìˊ.) ");
INSERT INTO mitNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Doco nècuàchìmà, dadí úún nì ndòo‑ne. Ñàyùcàndùá, nì tnii‑ya ndahà nècuàchì cuhí mà, te nì dàndúvàha‑yanè. Dandu nì cachi‑yà xì‑né: ―Vàtùni cùhùn‑ní vichi. ");
INSERT INTO mitNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dandu nì cachi stná‑yà xì nècuàchì ndoó yucán: ―Nú iá iin burru, ò iin buey xi‑nsia, te nì nacava‑sì ini iin xìchi, ¿áma cúhùn‑nsià carrera tavà‑nsiási, mate quívì descansu nduá? ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Te mii‑né, mànìcùí nanihì tnùní ini‑nè nansa naxiconihí‑né nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Daaní, nì xini Jesús nansa quidá nècuàchì nì quesaa vicò mà, nandúcú‑nê lugar cundoo‑ne ndé chicá quee tnùñuhu xí‑né. Ñàyùcàndùá, nì nacani‑ya xì‑né iin ejemplu, cachí‑yà: ");
INSERT INTO mitNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Nú cánà iin nèhivì cùhùn‑nè iin vicò nandàhà, màsà cóó‑né ndé nduú lugar chicá iá tnùñuhu‑xí, vàchi vihini sàà stná inga ana chicá quidáñúhú nècuàchì dìvéhé‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nú ducán, dandu icúmí nècuàchì dìvéhé‑xímá tnàtuu‑ne ndé iá nècuàchì nì sàà primeru mà, te cachi‑nè xì nècuàchìmà: “Cuxio‑ní, te ni coó nècuàchì sahnú yohó lugar xi‑ní”. Dandu nècuàchìmà, ndacuiin‑nè, te cùhùn‑nè coo‑ne inga lugar ndè cahà‑xí, te ndòo cahan‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Cunaha‑nsiá, nú cánà‑ndà cùhùn‑ndà iin vicò, dandu nanducu‑nda lugar chicá cahà‑xí coo‑nda, dandu na tnátuu nècuàchì dìvéhé‑xímá, icúmí‑nê cachi‑nè xì‑ndà: “Amigo, nahà‑ní, coo‑ní ndé nduú lugar chicá iá tnùñuhu‑xí”. Pues nú ni quidá‑né ducán, dandu chicá quee tnùñuhu xi‑nda nùù nècuàchì cutnáhâ xí‑ndá ndoo‑nda xixi‑nda yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Vàchi nsidaa ana datiaá chicá ndiaá, icúmí‑nê sàà‑nè ndòo cahan‑ne. Doco nsidaa ana ndaníhí ndahví xì mii‑xí, divi nduú ana chicá icúmí nìhì xì tnùñuhu ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Daaní, nì càhàn‑yà xì nècuàchì nì cana xi‑yá ñà‑cuxi‑ya, cachí‑yà xì‑né: ―Nú cuàhàn‑ní quida‑ní iin vicò vehe‑ní, dàtnàà ò sàcuaà, dandu màsà cáná‑nî amigo xi‑ní, ò ñanì‑ní, ò tnaha‑ní, ò nècuàchì cuìcà ndoó yatni, còtó cana stná‑nè mii‑ní vehe‑ne, te ducán danáà‑né favor nì quida‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Còó, vàchi nú cuní‑nî quida‑ní iin vicò, dandu cana‑ní nècuàchì ndahví, xì nècuàchì nì nacuèhè, xì nècuàchì xicá cuéhê, xì nècuàchì cuaá; ");
INSERT INTO mitNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","dandu ndiaha gá coo xi‑ní, vàchi nsidaa nècuàchì yucán, mà cúí danáà‑né nùù‑ní. Daaní (ndè inga vida) na natiacù‑ní xì nsidaa gá nèhivì nihnú ndàcuisì inì‑xi, icúmí‑nî nìhì‑ní ñà‑vàha xi‑ní sàhámà ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Daaní, iin nècuàchì cutnáhâ xí‑yâ na xixí‑yá yucán, nì tiacu‑nè ñà‑ndùá nì cachi‑yà, te nì cachi‑nè xì‑yá: ―Ndiaha gá coo tiempu cundoo‑nda ñuhìví ìì xí Dios, te cuxi‑nda pan yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dandu nì cachi Jesús xì nècuàchìmà: ―Nìsa ìa iin tiàa nì quida iin vicò cahnú. Cuàhà gá nèhivì nì cana‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dandu na hora cuàhàn‑nè cacuxi‑ne, nì techuún‑né iin peón xi‑ne (ñà‑caca‑tè) cachitnùhu‑tè xì nsidaa nècuàchì nì cànà mà ñà‑sà‑ìá hora yàha‑ne, vàchi sà‑ìá listu nsidaá. ");
INSERT INTO mitNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","’Doco iin‑ni nì cacachi nsidaa‑né ñà‑nì cuícáhnû ini nècuàchì quìdà‑xì vicò mà sàhà‑né. Nècuàchì primeru, nì cachi‑nè: “Còó, làcà nì xiin iin ñuhù xí, te icúmî cùhìn cundehíà. Ni cuícáhnû ini‑nè sàhí”, cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","’Daaní, inga‑nè, nì cachi‑nè: “Còó, vàchi làcà nì xiin ùhùn yunta buey, te icúmî cùhìn cundaà inì sàhà‑sí, a quídá víi‑sí, á coó. Ni cuícáhnû ini nècuàchìmà sàhí”, nì cachi tiàa ma. ");
INSERT INTO mitNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Daaní, inga‑nè, nì cachi‑nè: “Còó, vàchi làcà nì nandàhí, te ñàyùcàndùá, mà cúí cùhìn”. ");
INSERT INTO mitNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’Ñàyùcàndùá, mànuhù peón mà, te nì nacani‑tè xì lamú xi‑tè nansa nì cacachi iin iin nèhivì mà. Ñàyùcàndùá, nì xìdà ini nècuàchìmà, te nì cachi‑nè xì peón mà: “Cuahán‑nî vichi duha cacanuu‑ní inii calle ñuu‑ndà yohó, calle nahnú te calle cuati, te danátácà‑ní nècuàchì ndahví, nècuàchì nì nacuèhè, xì stná nècuàchì xicá cuéhê, xì nècuàchì cuaá ñà‑nì quìxí‑né vicò xí”. ");
INSERT INTO mitNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","’Ñàyùcàndùá, (ducán nì quida peón mà); dandu nì cachì‑te: “Sànì quide ñà‑ndùá nì cachì‑ní xìˊ, señor, te vàtùni cundoo más gà nèhivì”. ");
INSERT INTO mitNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dandu nì cachi tu lamú mà xì peón mà: “Vichi cuahán tu‑ní nsidaa ichì xì nsidaa callejón, te datnátuu‑ní nèhivì sàhà‑ñá chitu vehi nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Vàchi ñà‑yòhó cachíˋ xì‑nsiá, ni‑iin nèhivì nì quide invitar daa, mà níhì‑né ni‑iyuhu ñà‑cuxi‑ne vehi”. ");
INSERT INTO mitNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cunaha‑ní, cuàhà gá nèhivì xínchicùn xì‑yá cuàhàn stná‑nè. Ñàyùcàndùá nì naxicocuíìn‑yà yàtà‑yá, te nì cachi‑yà xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Nú vàxi iin nèhivì nùí, te cuní‑nè cunchicùn‑nè yùhù, dandu (màsà ndúlócô gà‑nè ñà‑ndùá cachí) yua‑né, ò dihi‑né, ò dèhe‑ne, ò ñani‑nè, ò cùha‑ne, mate (ni cá‑cútúxí ini nècuàchìmà) sànì xini ùhì tnaha‑nemà mii‑né. Ni màsà cúú gà stná ini‑nè sàhà vida xi‑ne, vàchi nú coó, mà cúí sàà‑nè cunduu‑ne iin ana nchícùn xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Te xiñuhu stná (ñà‑coo‑ne dispuestu cui‑nè sàhí), quida‑ne cuenta na ian nsidá‑né iin cruz cuàhàn‑nè cui‑nè. Vàchi nú có‑nìhnú ini‑nè ducán, te có‑nchîcùn stná‑nè yùhù ducán, dandu mà cúí sàà‑nè cunduu‑ne iin nèhivì xí. ");
INSERT INTO mitNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Vàchi nú cuní‑ndà quidavàha‑nda iin vehe ducún, amádi dihna coo‑nda quida‑nda cuenta xi‑nda a vátùni sàà dìhùn xì‑ndà, ");
INSERT INTO mitNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","còtó mà cúí daxínu‑ndañá, cuisì cimientu xan daquésáhá‑ndá, te sà‑ìá ni. Dandu nècuàchì indéhe, cuàhàn‑nè cuàcùndiaa‑nèndó, ");
INSERT INTO mitNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","cachi‑nè: “Cuàhàn tè‑jaàn quidavàha‑tè iin vehe ni cuí, doco cónì níhì‑té daxínu‑teá”, cachi‑nè (cuàcùndiaa‑nèndó). ");
INSERT INTO mitNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Daaní, stná iin rey, nú cuní‑te cùhùn‑te guerra nàá tnàhá‑te xì inga rey vàxi xi soldadu‑xi, amádi dihna coo‑tè nacani vàha inì‑te, a vátùni sàà ùxìn mil soldadu xi‑tè ñà‑cundee‑té nùù òcò mil soldadu xi inga rey mà, á coó. ");
INSERT INTO mitNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Te nú mà sáà soldadu xi‑tè, dandu na táñâha ga cuyatni inga rey mà, dandu techuún‑te nèhivì xí‑te cùhùn‑nè ndatnuhu‑né xì tèmà nansa nsihi pleitu xi‑tè. ");
INSERT INTO mitNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Te ducán stná mii‑nsiá, xiñuhu nandòdó‑nsiá nsidanicuú iñàha icúmí‑nsiâ, vàchi nú coó, dandu mà cúí sàà‑nsià cunduu‑nsia ana nchícùn xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Vàha ga ììn, (vàchi nsidá ádìá ñà‑xìxì‑ndà); doco nú sànì ndañuhu ñà‑ádì xán, dandu mà cúí gá ndu‑adì gáˋ. ");
INSERT INTO mitNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Vàchi còò cá chuan, mà cúndúá ñuhù chihi‑nda, ni mà váha daquée stná‑ndà nùù itu‑ndà. Chicá vàha cate‑ndàñá. Ni cúníní vàha nsidaa‑nsiá palabra jaàn. ");
INSERT INTO mitNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Daaní, nì catnàtuu cuàhà tè‑dàchíyàhvi, xì cuàhà gá stná nèhivì iá cuàchi‑xi, vàchi cuní‑nè cunini‑ne ñà‑ndùá cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dandu nècuàchì fariseu, xì stná nècuàchì ley xi veheñùhu, nì xitnùhu‑neyà, cachí‑nè: ―Nècuàchì jaàn, cudíì ini‑nè cutnahá‑né xì nècuàchì cuáchi; dècuèndè xixí tàcá stná‑nè xì nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dandu nì nacani‑ya xì‑né iin ejemplu, te dohó nì cachi‑yà: ");
INSERT INTO mitNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Nú ndoó iin cientu riì xì‑ndà, te nì quecuaán iin‑sì ¿ndíà nduá quida‑nda? ¿Amádi nacoo‑nda 99 quisì dava ga mà iin yodò, te cùhùn‑ndà nanducu‑nda inga quisì mà ndè cachi nanihì‑ndàsí? ");
INSERT INTO mitNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Daaní, nú sànì ndacùhun‑ndasí, cudíì ini‑ndà ");
INSERT INTO mitNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","mànuhù‑ndà vehe‑nda idádocó‑ndà quisì mà. Dandu cana‑nda amigo xi‑nda xì stná nècuàchì ndoó yatni, te cachí‑ndà xì‑né: “¡Nahà‑nsia cundoo‑nda cudiì ini‑ndà, vàchi sànì natùi riì xí nì ndañuhu ni cuí!” ");
INSERT INTO mitNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","’Te yùhù cachí stnáì xì‑nsiá, nú nì sàà iin nèhivì iá cuàchi xi cuu‑ne arrepentir, dandu yáha ga xícudiì ini ana ndoó gloria. Ndè chicá cudíì ini‑nè sàhà nècuàchìmà nùù 99 nèhivì nihnú vàha inì‑xi, vàchi mii‑né, có‑xìñùhù gá cuu‑ne arrepentir. ");
INSERT INTO mitNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Te ò (inga ejemplu. Ni cachí‑ndà iá) iin nècuàchì ñahà icúmí xí ùxìn dìhùn plata. Pues nú ni ndáñúhú ian, amádi nacuicùn‑né iin isì, te nasihvi‑né vehe‑ne ñà‑nanducu‑néà ndè cachi natùia. ");
INSERT INTO mitNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Daaní, nú sànì nanihì‑néà, dandu cana‑ne amigo xi‑ne xì stná nècuàchì ñahà xíndoo yatni, te cachi‑nè xì nècuàchìmà: “Naha‑nsià cundoo‑nda cudiì ini‑ndà, vàchi sànì natùi dìhùn xí nì ndañuhu ni cuí”, cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Te cachí stnáì xì‑nsiá, ducán cudíì stná ini nsidaa ángel xi Dios nú nì sàà iin nècuàchì iá cuàchi‑xi cuu‑ne arrepentir. ");
INSERT INTO mitNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Dandu nì cachi stná‑yà: ―Nìsa ìa iin tiàa ndoó ùì dèhe‑xi. ");
INSERT INTO mitNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Te nì cachi tèchicá chii xi yua‑té: “Papá, taxi‑ní ñà‑ndùú tàhvì nìhì‑nsí nùù‑ní”. Ñàyùcàndùá, nì sàha‑ne iin iin‑tè ñà‑ndùú tàhvì‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Cónì yáha cuàhà quìvì, te nì dàtàcá tèchicá chii ma nsidaa ñà‑ìcúmí‑tê, te cuàhàn xìcà‑té inga ñuu. Yucán nì quida ndevàha‑tè gastu dìhùn xí‑te, nì quìhvi‑tè cuàhà viciu. ");
INSERT INTO mitNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Daaní, na ní nsihi dìhùn mà, nì quixi fuerte tnama ñuu yucán, te nì quesaha‑té nì ndundahví‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ñàyùcàndùá, cuàhàn‑te nùù iin lamú ñuu yucán, te nì nìhì‑té chuun nùù nècuàchìmà, nì techuún‑nète cuàhàn‑te campu dacáxâhan‑tè cochi. ");
INSERT INTO mitNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","(Ñàyùcàndùá, yucán iá‑te campu mà), dècuèndè nchichi yùcù saxí cochi‑mà cahan stná‑te caxì‑té, doco còò ni‑iin nèhivì sáha xi‑té ni‑iñàha. ");
INSERT INTO mitNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dandu nì nàcùnihnu sahnú inì‑te, te nì cachì‑te: “Cuàhà gá peón ndoó vehe yué, te iá cuàhà ñà‑cutiacu‑nè, dècuèndè cuyódo gá‑ñà nùù‑né. Doco yùhù, yohó iéˋ ndè cuníˋ cuì quidá doco. ");
INSERT INTO mitNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Chicá vàha naquihin ichì nùhì ndé iá papá xi, te cachì xì‑né: Papá, nsidá cuàchi nùù Dios, te nsidá cuàchi stnáì nùù mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ni mà nátùi cunduu guè nahi dèhe‑ní; nahi peón xi‑ní cundui quida‑ní cuenta”. Ducán nacání inì‑te entre mii‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ñàyùcàndùá, nì naquihin‑tè ichì mànuhù‑té ndé iá yua‑té. ’Te xica íì vàxi‑tè ndé iá nècuàchìmà, te nì xini‑nète. Dandu nì cuhi ini‑nète, te nì dàyáà‑nè cuàhàn‑nè nì numi nihni‑nète. Nì tutuyuhu tnahá‑né nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Dandu nì cachi dèhe‑nemà xì‑né: “Papá, nsidá cuàchi nùù mii‑yá iá ansivi, te nsidá cuàchi stnáì nùù mii‑ní. Mà nátùi cunduu guè nahi dèhe‑ní”, nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Doco yua‑té, nì cachi‑nè xì peón xi‑ne: “Tavà‑nsiá sìcoto chicá finu, te chindixi‑nsiàte; te ni cúnácáá stná iin anillu dìnìndàhá‑te; ni nácuáìn stná‑te iin ndìsàn. ");
INSERT INTO mitNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Te cundaca stná‑nsia chelù ndatnù quixi cuì‑si quida‑nda vicò. ");
INSERT INTO mitNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Vàchi sànì xìhì dèhi yohó cahín, doco vichi (sànì nsiaà‑te) na iin tiàa nì natiacu. Sànì ndañuhu‑té ni cuí, doco vichi sànì natùi‑tè”, nì cachi yua‑té. Te nsidaa nècuàchì ndoó yucán, nì quesaha‑né nì quida cahnú‑né vicò mà. ");
INSERT INTO mitNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Daaní, dèhe sahnú nècuàchìmà, iá‑te nùù ìtú. Te nì naquihin‑tè ichì màndixi‑tè. Te na ní cuyatni‑tè vehe, nì tiacù‑te quidándáá nèhivì, te itásáhá stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ñàyùcàndùá, nì cana‑tè iin peón; nì xìcàn tnùhù‑té nùù nècuàchìmà, cachí‑te: “¿Ndíà ndùá cùù‑guá vehi?” ");
INSERT INTO mitNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dandu nì cachi peón mà xì‑té: “Sànì nsiaa ñanì‑ní, ñàyùcàndùá nì cachi yua‑ní ñà‑nì càhní‑nsí chelù ndatnù, vàchi sànì natùi dèhe‑ne, te còò ni‑iñàha ni cuu xi‑té”. ");
INSERT INTO mitNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ñàyùcàndùá, nì xìdà ini ñani sàhnùmà, có‑cùní‑te nansìhvi‑tè vehe. Dandu nì quee yua‑té nì càhàn viì‑né xì‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Doco nì cachì‑te xi‑né: “Cunaha‑ní, sàcàní cuìà iéˋ nùù‑ní quidáchúîn, te iníní nsidanicuú ñà‑ndùá cachí‑nî xìˊ; doco tàñáha ga dacútâhvì‑ní yùhù ni‑iin litú quida stnáì vicò xì amigo xi. ");
INSERT INTO mitNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Doco vichi sàhà ñà‑nì nsiaa tè‑ndùú dèhe‑ní yohó, (ñàyùcàndùá quìdà‑ní iin vicò cahnú), dècuèndè nì xìhì stná chelù ndatnù xi‑nda sàhà‑té, mate nduú‑te iin ana nì quida uun gastu xì biene xi‑ní sàhà ñahà xí‑te”, nì cachi dèhe sahnuma. ");
INSERT INTO mitNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dandu nì cachi yua‑té: “Yohó, dèhi nduú stnáù. Siempre ió xî. Te nsidaa ñà‑ndùú biene xi, stoho stnáˋ nduú stnáù. ");
INSERT INTO mitNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Doco vitni ndiá ìcà‑ndà quida‑nda vicò, te cudiì ini‑ndà, vàchi tè‑ñanù yohó, nì xìhì‑te cahín, doco vichi yohó iá‑te na ian nì natiacù‑te; sànì ndañuhu dahuun‑tè nì cahín, doco còó, sànì nsiaà‑te vichi”. ");
INSERT INTO mitNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Dandu nì cachi Jesús xì nècuàchì dacuahá‑yá: ―Iin nècuàchì cuìcà, nì ìa iin mayordomu xi‑ne, te nì cachitnùhu nèhivì xì‑né: “Có‑quìdá víi mayordomu xi‑ní xì biene xi‑ní”. ");
INSERT INTO mitNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ñàyùcàndùá, nì cana‑ne tèmà, cachí‑nè xì‑té: “¿Nansa iá ñà‑ndùá quìdà‑ní? vàchi cáhàn tnùhù nèhivì sàhà‑ní nùí. Pues vichi icúmí‑nî quida nsihi‑ní entregar cuenta xi‑ní nùí, vàchi cuàhìn taví mii‑ní nùù chuun xi‑ní ñà‑ndùù‑ní mayordomu”, nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ñàyùcàndùá, nì quesaha‑témà nacání inì‑te, cachí‑te inì‑ni mii‑té: “¿Nansa quide vichi? vàchi cuàhàn lamú xi dacúxíó‑né yùhù nùù chuun xi. Ndahvíˋ, vàchi còò valor xi quidachuín xì pala. Vihini càcàn stnáì caridad, doco cucáhán núí. ");
INSERT INTO mitNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Áà! Vichi sànì cundaà inì nansa quide, te cundoo ana cuàha lugar coi vehe‑xi na quei nùù chuun xi”, nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ñàyùcàndùá, nì cana‑tè iin iin nèhivì iníhícá nùù lamú xi‑tè. Te nì ndàcàtnùhù‑té nùù nècuàchì primeru mà: “¿Nadaa iníhícá‑nî nùù lamú xi?” ");
INSERT INTO mitNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Te nì cachi nècuàchìmà: “Iin cientu tonel aceite iníhíquê”. Dandu nì cachi mayordomu mà: “Tnii‑ní cuenta xi‑ní, coo‑ní yohó, te yàchì natiaa‑ní cuenta xi‑ní ñà‑cundua cuisì ùì dico ùxìn (50) tonel vichi”. ");
INSERT INTO mitNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Dandu nì cachì‑te xi inga‑nè: “Te mii‑ní, ¿nadaa iníhícá‑nî?” Te nì cachi nècuàchìmà: “Iin cientu carga nùnì trigu iníhíquê”. Dandu nì cachì‑te: “Tnii‑ní cuenta xi‑ní, te natiaa‑ní cùmì dìcó (80) carga‑ni”. ");
INSERT INTO mitNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Daaní, lamú xi‑tè, nì cundaà ini‑nè ñà‑ndùá quidá‑te. Ñàyùcàndùá, nì cachi‑nè xì‑té sàhà‑ñá cónì quìdá víi‑té: “¡Na nchichí guá nì quida‑ní!” nì cachi‑nè. Vàchi cunaha‑nsiá, nèhivì nihnú inì‑xi cuisì ñuhìví yohó, chicá cuehé‑nè nùù chuun xi‑ne entre nsidaa mii‑né, te chicá mà cuèhé nèhivì datnúù Dios sàxìnítnùní‑xi. ");
INSERT INTO mitNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Te yùhù cachíˋ xì‑nsiá: mate dava‑tè, có‑quìdá víi‑té xì dìhùn xí‑te, doco mii‑nsiá, xiñuhu cuichuún víi‑nsiá ñà‑cuìcà‑nsiá sàhà‑ñá naquimanì nèhivì‑nsiá, dandu na quívì nsihi dìhùn xí‑nsiá mà, vàtùni cuàha Dios sàà‑nsià nùù‑yá vehe ndiaha‑yá nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Nú sànì nìhì iin nèhivì iin chuun tii, te quidá víi‑néà, dandu ñà‑jaàn cundaà ini‑ndà vàtùni quida viì stná‑nè iin chuun chicá cahnú. Te ò nú có‑quìdá víi‑né chuun tii ma, dandu ni mà quídá víi stná‑nè iin chuun cahnú. ");
INSERT INTO mitNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ñàyùcàndùá, nú icúmí‑ndá ñà‑cuìcà ñuhìví cuàchi yohó, te có‑quìdá víi‑nda xán, dandu còò iin cuàha xi‑nda ñà‑ndùú ñà‑cuìcà ndiaha ndisa. ");
INSERT INTO mitNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te nú có‑quìdá víi‑nda chuun ñà‑cundiaa‑ndà biene xi inga ñanìtnaha‑nda, dandu còò iin cuàha xi‑nda ñà‑cunduu biene xi mii‑nda. ");
INSERT INTO mitNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Iin tè‑quìdáchúûn, mà cúí coo ùì patrón xi‑tè, vàchi nú ducán, dandu icúmí‑tê cuni ùhì‑te iin‑ne, te inga‑nè cuu inì‑te sàhà‑xí. Te ò ni cachí‑ndà, iin‑ne coo vàha xi‑té, te inga‑nè cahíchì inì‑te. Te ducán stná mii‑nsiá, nú cuú ini‑nsià sàhà dìhùn, dandu mà cúí cunucuachi stná‑nsià nùù Dios ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Daaní, nècuàchì fariseu, itá stná‑nè yucán, iníní‑né nsidaa ñà‑ndùá cachí‑yà, te nì sàcùndiaa‑nèyà, vàchi cuàhà gá cuú ini‑nè sàhà dìhùn. ");
INSERT INTO mitNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ñàyùcàndùá, nì cachi‑yà xì‑né: ―Mii‑nsiá, nùù nèhivì cuní‑nsià ndee vàha‑nsia, na ian ni cúndúú‑nsiá nèhivì váha guá. Doco Dios, ináhá‑yâ ñà‑ñùhú ini anima‑nsià. Vàchi ñà‑ndùá chicá xího nècuàchì ñuhìví yohó, có‑nâtùia nùù mii‑yá, vàchi ñà‑chicá có‑ìá vàha nduá nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Inii tiempu antes quesaa Juan (Bautista) nì sandiaa ley (xi Moisés) xì stná palabra nì cachi profeta nìsa cahàn cuenta xi Dios. Doco tiempu xi Juan vàxi duha nì quesaha xítià cuentu sàhà ñuhìví ìì xí Dios, te vichi nsidaa nèhivì, quidá‑né lucha sàà‑nè ñuhìví ìì mà. ");
INSERT INTO mitNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Doco ley (sànaha) ma, nicanicuahàn cundua iin ley vàha; vàchi ni‑iin seña tii xí iin letra xan, mà nunca sàà ndañuhá. Chicá mà úhì ndañuhu ansivi xì ñuhìví, doco ley mà, nicanicuahàn coa. ");
INSERT INTO mitNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Nú ni caté stnahá iin tiàa xi ñahàdìhí‑nè, te coo‑ne xì inga nècuàchì ñahà, cuàchi ndisa cundua. Te nú ni nándàhà stná iin nècuàchì tiàa xi iin nècuàchì ñahà ní sate stnahá, divini cuàchi cunduu stná mà. ");
INSERT INTO mitNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Nìsa ìa iin tècuìcà, ndixí‑te sìcoto cuxín finu, xì cuàhà gá sìcoto chicá viì. Te nsìquívì nìsa quida‑tè vicò cahnú vehe‑tè. ");
INSERT INTO mitNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Te nìsa ìa stná iin nècuàchì satú nani Lázaro, indúhu‑né yehè cahnú tècuìcà mà, te itándiaa chitu nsìhi uhì ìcà‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Te cuní‑nè nìhì‑né pedazu cuati comida cóyo nùù mesa xi tècuìcà mà cuxi‑ne. Dècuèndè stná sìhina, vàxi‑sì ndé iá‑nè, te nacuáhá yàá‑si nsìhi uhì ìcà‑némà. ");
INSERT INTO mitNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Daaní, nì sàà quìvì nì xìhì‑nè, te nì caquixi ángel nì nacuaca‑ne anima nècuàchìmà cuàhàn‑nè ndé iá xìì‑ndà Abraham. Daaní, después nì xìhì stná tècuìcà mà, te nì ndùxin‑tè. ");
INSERT INTO mitNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Dandu (nì sàà‑te) ndé ndoó anima nècuàchì xínduu nsìi. Te yucán nì quesaha‑té ndohó cuáhà‑té. Dandu nì ndacoto‑tè nì xini xìcà‑té yucán iá Abraham, te yatni uun iá stná Lázaro. ");
INSERT INTO mitNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ñàyùcàndùá, nì ndàhì ndee‑té, cachí‑te: “¡Abraham! ¡Xìì‑nsí nduu‑ní! Cundehè ndahví‑nî yùhù; techuun‑ní Lázaro quixi‑ne dandaxín‑né dìnìndàhá‑nè tècuìí, te danchíco‑ne yàíˋ, vàchi yáha ga ndohí iéˋ mahì ñuhu yohó”. ");
INSERT INTO mitNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Doco nì cachi Abraham: “Nsinuu inì‑ní, hijo, vàchi na nísa itiacù‑ní ñuhìví, vàha vida nìsa icumi‑ní. Doco Lázaro yohó, còó; yáha ga ndahví nìsa yàha‑ne. Doco vichi sànì nìhìtáhvì‑né cudiì cuáhà ini‑nè, mientras mii‑ní, icúmí‑nî ndoho‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Te iá stná inga iñàha, vàchi mahì nsiùhù yohó xì mii‑nsiá jaàn iá iin yui cahnú cunú sàstnùhù. Ñàyùcàndùá, mate ni cúcáhán‑nsî yàha‑nsi ndé iá‑nî, doco mà cúí; te stná mii‑nsiá, mà cúí yàha stná‑nsià ndé ndoó nsiùhù yohó”. ");
INSERT INTO mitNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Dandu nì cachi tèmà: “Pues, nú ma cúí, dandu sacúndáhvîˋ nùù‑ní, tío Abraham; techuún sacù‑ní Lázaro nùhù‑nè vehe papá xi. ");
INSERT INTO mitNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Vàchi yucán ndoó ùhùn ñanì, te cuníˋ càhàn Lázaro xì‑té ñà‑màsà quíxí stná‑te lugar yohó ndé ndòhò guá‑nsì”. ");
INSERT INTO mitNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dandu ní cachi Abraham xì‑té: “Sà‑ìcúmí‑tê libru ìì nì tiaa Moisés, xì stná libru nì tiaa nècuàchì profeta. Ni cúníní‑te ñà‑ndùá cachí nùù tutu mà”. ");
INSERT INTO mitNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Dandu nì cachì‑te: “Còó, tío Abraham, vàchi nú ni nátiácú iin nsìi, te sàà‑nè càhàn‑nè xì‑té, dandísá, icúmí‑tê cuu‑tè arrepentir”. ");
INSERT INTO mitNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Doco nì cachi Abraham xì‑té: “Nú có‑cùní‑te cunini‑tè ñà‑ndùá nì cachi Moisés, te ni ñà‑ndùá nì cachi profeta, dandu mà sáà‑te naxicocuíìn inì‑te mate ni nátiácú iin nsìi (càhàn xì‑té)”. ");
INSERT INTO mitNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Dandu nì cachi Jesús xì nècuàchì dacuahá‑yá: ―Ñà‑ndáà nduá, icúmí dava nèhivì tùcù‑nè ichì có‑ndiàá quida ñanìtnaha‑ne. Doco ndahví nècuàchì datúcù tnàhà‑xìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vàchi chicá vàha ni mácùndiacu iin yùù yódò dùcùn‑né, te ndiachi‑né mahì mar sàhà‑ñá màsà dátûcù‑nè ni‑iin ñà‑cuati yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ñàyùcàndùá, cuidadu cundoo‑nsia sàhà ñà‑ndùá quidá‑nsiá. ’Nú quidá iin ñanìtnaha‑nsia cuàchi nùù‑nsiá, dandu càhàn‑nsià xì‑né sàhámà. Te nú ni náxícócuîìn ini‑nè sàhà ñà‑ndùá nì quida‑ne, dandu cuicahnú inì‑nsia sàhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mate ùsà xichi iin quìvì ni quidá‑né iin cuàchi nùù‑nsiá, có‑quìdá, vachi nú cada iin iin xichi vàxi‑ne cachí‑nè ñà‑cùú‑né arrepentir, dandu icúmí‑nsiâ cuicahnú inì‑nsia sàhà‑né ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dandu nècuàchì nì nìhì chuun nùù Stoho‑ndà Señor, nì xìcàn tàhvì‑né nùù‑yá, cachí‑nè: ―Chindee‑ní nsiùhù ñà‑nì sáà‑nsì cunindisá víi gá‑nsì. ");
INSERT INTO mitNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Dandu nì cachi‑yà xì‑né: ―Cuati lihngu tata yutnù nani nù‑mostaza. Te ñà‑yòhó cachíˋ xì‑nsiá: nú xiníndísâ ndisa‑nsia, mate (iyuhu nduá) nahi tata mà, dandu dècuèndè vàtùni dandacú‑nsiá nùù yutnù nahi yutnù fruta jaàn ñà‑nì ndánchító‑nu yohó, te cùhùn‑nu ndiachi‑nú mahì mar, dandu seguru ducán icúmí coo. ");
INSERT INTO mitNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Ni cachí‑ndà iá iin peón xi‑nda, te quidachuún saín‑te nùù‑ndà. Te vihini xitú‑te, o ndiaá‑te quisì xi‑nda. Doco nú nì nsiaà‑te vehe, ¿a cáchí‑ndà xì‑té ñà‑nì cúhùn‑te cudamá‑te? ");
INSERT INTO mitNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Còó, dohó cuàhàn‑ndà cachi‑ndà xì‑té: “Quidayucùn‑ní ñà‑cudamíˋ, dandu nsidaviì‑ní mii‑ní, te taxi‑ní ñà‑cuxi, te cohi. Doco mii‑ní, dècuèndè después icúmí‑nî cuxi‑ní”, cachi‑ndà xì‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pues, ¿a náquímánì‑ndà peón mà nú sànì quida‑tè nsidaa ñà‑ndùá nì ndacu nuù‑té? Ádi coó. ");
INSERT INTO mitNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pues divi ducán stná xì mii‑nsiá, vàchi nú sànì nsihi nì quida‑nsia nsidaa ñà‑ndùá nì ndacu nuù‑nsiá, dandu icúmí‑nsiâ, cachi‑nsià: “Còò ni‑iñàha ni quidá‑nsí, cuisì ñà‑ndùá ndiá ìcà‑nsí nì quida‑nsi”, ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nchícùn Jesús ichì Jerusalén cuàhàn, te nì yàha‑ya ladu Galilea xì stná ladu Samaria. ");
INSERT INTO mitNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Te na ní sàà‑yà iin ñuu tii nì xini‑yà yucán vàxi ùxìn tiàa ndohó cuèhè lepra. Itá xica‑né, ");
INSERT INTO mitNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","cána ndee‑né, cachí‑nè: ―¡Stoho‑nsì Jesús! ¡Cundehè ndahví‑nî nsiùhù! ");
INSERT INTO mitNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Daaní, na ní xini Jesús nècuàchìmà, nì cachi‑yà xì‑né: ―Cuahán‑nsià dacuní‑nsià dùtù ìcà‑nsiá. Ñàyùcàndùá nì caquihin‑ne ichì cuàhàn‑nè. Te meru xicá‑né ichì mà, dandu nì nduvàha nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Te iin‑ne, na ní xini‑nè sànì nduvàha‑ne, nì naxicocuíìn‑nè, nì ndenihi vàha cuahà‑né Dios, ndee cáhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Te nì sàcuììn sìsì‑né nùù‑yá, naquímánì‑néyà. Te nduú‑né iin nècuàchì ñuu Samaria. ");
INSERT INTO mitNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dandu nì cachi‑yà xì‑né: ―¿Amádi ùxìn tiàa nì nduvàha? Doco 9 nècuàchì dava ga mà, còò‑né ni náxícócuîìn. ");
INSERT INTO mitNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Cuisì mindaa nècuàchì tùcù yohó nì naxicocuíìn naquímánì xì Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dandu nì cachi‑yà xì tiàa nì naxicocuíìn mà: ―Ndacuiìn‑ní xuhun‑ní vehe‑ní. Vàtùni nì xinindisa‑ní, te ñàyùcàndùá nì nìhì‑ní nì nduvàha‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Daaní, nì ndàcàtnùhù nècuàchì fariseu nùù‑yá índù tiempu sàà quìvì cusahnú Dios ñuhìví yohó. Te nì cachi‑yà xì‑né: ―Màdìá nduchìnúù‑nsiá cuni‑nsià ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mà cúndúámà ñà‑cachitnùhu nèhivì xì‑nsiá, cachi‑nè yohó iá ñuhìví ìì mà, te ò yucán iáˋ. Còó, vàchi yohó mahì mii‑nsiá iá ñuhìví ìì mà. ");
INSERT INTO mitNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dandu nì cachi‑yà xì nècuàchì dacuahá‑yá: ―Vàxi iin tiempu na yáha ga cunì‑nsia cundua tiempu ndiaha (naxicocuíìn) yùhù ana nduú Tnaha Nèhivì Ñuhìví, doco tàñáha ga sàà cundua tiempu mà. ");
INSERT INTO mitNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Te nú cachí nèhivì xì‑nsiá ñà‑yòhó sànì naxicocuíìn, te ò yucán iéˋ, màsà cúhùn‑nsià xì‑né, màsà cúnchícùn‑nsiànè. ");
INSERT INTO mitNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Vàchi na ian tása, te natnúù fuerte inicutu ansivi ndè iin ladu xì ndè inga ladu, ducán icúmí cuu stná xì yùhù na sáà quìvì xí, (te cundehè nsidaa nèhivì yùhù). ");
INSERT INTO mitNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Doco antes, cuàhà iñàha icúmî ndohi; vàchi icúmí nèhivì tiempu vichi cahíchì ini‑nè yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Te nacua nì cuu tiempu xi Noé sànaha, ducán icúmí cuu stná na sáà meru quìvì xí yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Vàchi tiempu xi Noé mà nìsa (ndoo cuéyàà nèhivì ñuhìví), xixí‑né, xihí‑né, te nándàhà‑né. Te ducán nìsa quida‑ne dècuèndè nì sàà quìvì nì quìhvi Noé barcu cahnú, dandu nì quixi dàvì nì sahnì xì nsidaa nèhivì mà. ");
INSERT INTO mitNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Daaní, ducaní stná nèhivì ñuu Sodoma tiempu xi Lot sànaha, xixí‑né, xihí‑né, xiín‑né, te dicó‑né; xitú stná‑nè, te quidávàha stná‑nè vehe; ");
INSERT INTO mitNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","doco divi quìvì nì quee Lot ñuu mà, dandu ndè ansivi nì còyo ñuhu xì tàtnà cuaán sahán quini, te nì caxihì nsidaa nèhivì ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ducán icúmí cuu stná na quívì naxicocuíìn, te cuni nèhivì yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Quìvì mà, nú ndoó nèhivì dìnìvèhé‑né (quetátú‑nè), te ini vehe ñuhú ñà‑ìcúmí‑nê, dandu màsà ndúlócô‑nè sàhámà. Cuisì‑nì nì cùnú dèhé‑nè chicá vàha. Te ò nú ndoó‑né nùù ìtú, dandu màsà náxícócuîìn‑nè vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Màsà nándòdó‑nsiá nansa nì cuu xi ñahàdìhí Lot. ");
INSERT INTO mitNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nsidaa ana cuní dacácu xi vida‑xi, cutu‑ñá dandáñúhú‑nêàmà quea; doco nsidaa ana có‑dàcácu xi vida xi, divi cunduu nècuàchì càcu. ");
INSERT INTO mitNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Yùhù cachíˋ xì‑nsiá, na sáà ñuú naxicocuíìn, dandu ndé quídì ùì nèhivì, icúmí cuxio iin‑ne, te iin‑ne ndòo. ");
INSERT INTO mitNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Te ndé ndoó ùì nècuàchì ñahà cutnáhâ nchicó, iin‑ne icúmí cuxio, te inga‑nè ndòo. ");
INSERT INTO mitNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Te ndé ndoó stná ùì tiàa nùù ìtú, iin‑ne cuxio, te inga‑nè ndòo. ");
INSERT INTO mitNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dandu nì ndàcàtnùhù‑né nùù‑yá, cachí‑nè: ―Stoho‑nsì Señor, ¿índù cuàhàn cuu ñà‑jaàn? Te nì cachi‑yà: ―Cunaha‑nsiá, (ducán iá nahi dichu cachí): “Ndé indúhu ñà‑nì xìhì, yucán icúmí nataca stná longo”. ");
INSERT INTO mitNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Dandu nì nacani Jesús xì‑né iin ejemplu ñà‑cundaà ini‑nè ñà‑iin‑ni icúmí‑ndá càcàn tàhvì‑ndà nùù Dios, te màdìá cuhuun ini‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Dohó nì cachi‑yà: ―Nìsa ìa iin juez iin ñuu; doco ni cónì sácáhví‑tê Dios, ni stná nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Te divi ñuu yucán nìsa ìa stná iin nècuàchì ñahà nì xìhì iì‑xí. Te sáhàn nècuàchìmà nùù juez mà, cachí‑nè: “Nsidandaà‑ní chuun xi, vàchi iá iin nècuàchì xiní ùhì xí”. ");
INSERT INTO mitNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Doco cónì cùní‑te. Daaní, después nì nacani inì‑te, cachí‑te inì‑ni mii‑té: “Yáha ga sáhachuún ñahàcuàán yohó yùhù. Ñàyùcàndùá mate có‑càhví Dios, ni có‑càhvì stnáì ni‑iin nèhivì, doco cuàhìn nsidandaì chuun xi nècuàchì yohó, vàchi cuñáñî ñà‑tutoo quixi‑guá‑nè nùí”. ");
INSERT INTO mitNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dandu nì cachi Stoho‑ndà Señor: ―Cundehè‑nsiá nansa nì cachi juez mà, mate malu‑nè, (doco icúmí‑nê chindee‑né nècuàchìmà). ");
INSERT INTO mitNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Ñàyùcàndùá, Dios, ¿áma nsidandaà stná‑yà sàhà nèhivì nì nacàxin‑ya nú ndui te ñuú xícàn tàhvì‑né, te sacúndáhvî‑nè nùù‑yá? Te ¿a caní tiempu cueé‑yà, te sàà quìvì nsidandaà‑yà ducán? Còó, yàchì icúmí‑yâ nachitacùhá‑yà sàhà‑né, cachíˋ xì‑nsiá. Doco quìvì naxicocuíìn yùhù ana nduú Tnaha Nèhivì Ñuhìví, ¿a ndísá cunindisá cuàhà nèhivì yùhù cahan‑nsiá? ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Daaní, nì nacani‑ya iin ejemplu sàhà nèhivì ndaníhí vàha guá xì mii‑xí, te cachíchì ini‑nè nècuàchì dava ga. Dohó nì cachi‑yà: ");
INSERT INTO mitNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Ùì tiàa, cuàhàn‑nè veheñùhu cahnú ñà‑càcàntàhvì‑né nùù Dios. Iin‑ne nduú nècuàchì fariseu, te inga‑nè nduú nècuàchì dachíyàhvi. ");
INSERT INTO mitNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Te nècuàchì fariseu mà, nì sàcuììn‑nè yucán, te nì naquimanì‑né Dios sàhà mii‑né, cachí‑nè: “Ansivéhé‑nî Yua‑nsí Dios, vàchi yùhù, có‑quìdá ndevàhi nacua quidá nècuàchì dava ga mà, te có‑quìdá cuihna stnáì ni‑iñàha, vàchi có‑quìdé ni‑iin ñà‑có‑ndìá ìqué quide, có‑câhìn xì inga nècuàchì ñahà, ni có‑quìdá stnáì na quidá tè‑dàchíyàhvi jaàn. ");
INSERT INTO mitNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Còó; nùù cada ùnà quìvì iníhíìˊ iá dòquíˋ ùì quìvì, te nùù cada ùxìn pesu quidé ganar, chivàha cuaín ian ñà‑cunduu diezmu xan”, nì cachi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Doco nècuàchì dachíyàhvi ma, xica iín‑né, cucáhán nûù‑né ndacoto‑ne ansivi. Ñàyùcàndùá, iín‑ne, caní‑né nchìca‑ne (ñà‑cùù guá‑nè sentir sàhà cuàchi‑ne), te cachí‑nè: “Yua‑nsí Dios, cundehè ndahví‑nî yùhù, vàchi nècuàchì cuáchi nduí”, nì cachi‑nè, ");
INSERT INTO mitNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","dandu mànuhù‑né. Ñàyùcàndùá, yùhù cachíˋ xì‑nsiá, divi nècuàchì yucán nduú ana nì ndee vàha ndisa nùù Dios, te màdìá nècuàchì primeru mà. Vàchi nsidaa ana datiaá uun nduú nèhivì vàha guá, icúmí‑nê nducahan‑ne; te nsidaa ana ndaníhí ndahví xì mii‑xí, chicá icúmí‑nê nìhì‑né tnùñuhu. ");
INSERT INTO mitNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Daaní, ndacá nèhivì ñà‑cuati xí‑né vàxi nùù‑yá ñà‑chitàndòó‑yá ndahà‑yá dìnì‑vé. Doco na ní caxini nècuàchì dacuahá‑yá, nì sadi‑nè nùù nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ñàyùcàndùá, nì cana Jesús ñà‑cuati ma ni tnátua, te nì cachi‑yà: ―Nacoo‑nsia ñà‑cuati ni quixá nùí. Màsà cádí‑nsià nùá, vàchi cuisì nècuàchì nihnú inì‑xi nahi miá cunduu ana sàà ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ñà‑ndáà nduá cachíˋ xì‑nsiá, nú ni coó (vìtá ini) nèhivì nahi ñà‑cuati, dandu nìhì‑né quìhvi‑ne ñuhìví ìì xí‑yá, doco nú coó, mà sáà‑nè yucán ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Daaní, nì càhàn iin tè‑nìhí chuun, nì xìcàn tnùhù‑té nùù‑yá, cachí‑te: ―Maestro, mii‑ní vàha ndisa‑ní. Cachì‑ní xìˊ ndíà quide, te nìhìtáhvìˊ vida ndiaha nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Dandu nì cachi Jesús xì‑té: ―¿Ndíà dìsáhà‑xí cachí‑nî xìˊ: “Mii‑ní vàha‑ní”? Vàchi còò ni‑iin nèhivì ùún vàha ndisa, cuisì nú nduí Dios, dandu vàha ndisa inì. ");
INSERT INTO mitNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pues vichi, sà‑ìnáhá‑nî nansa nì dàndàcú‑yá ñà‑màsà cáhàn‑ndà xì inga ana có‑ndùú nècuàchì vehe‑nda; te màsà cáhni stnaha‑nda, ni màsà quídá cuíhná‑ndá, ni màsà cáchí‑ndà iin tnùhu sàhà ñanìtnaha‑nda, te ni coó stná tnùñuhu xi‑nda nùù yuadíhí‑ndá. ");
INSERT INTO mitNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dandu nì cachi tu‑tè xì‑yá: ―Cunaha‑ní, nsidaájàn sànì chivàhi dècuèndè na tií. ");
INSERT INTO mitNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Na ní inini Jesús ñà‑ndùá nì cachì‑te, dandu nì cachi‑yà: ―Cumánì gá inga iñàha quida‑ní. Dicò nsìhì‑ní ñà‑ndùá icúmí‑nî, te dasàn‑ní dìhùn mà nùù nècuàchì ndahví; dandísá nìhìtáhvì‑ní sàà‑ní ansivi, te yucán cucumi ndisa‑ní cuàhà ñà‑cuìcà. Te quixi‑ní cunchicùn stná‑ní yùhù ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Doco tèmà, na ní inini‑tè nì cachi‑yà ducán, dandu yáha ga nì cuhuun inì‑te, vàchi cuica cuáhà‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Te na ní xini Jesús ñà‑nì cuhuun guá inì‑te, dandu nì cachi‑yà: ―¡Na uhì guá sàà iin tècuìcà ñuhìví ìì xí Dios! ");
INSERT INTO mitNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ùhì gà stná dayáha‑nda iin camellu nùù chìcòhò ndúhu iquì; doco chicá ùhì yàha iin tècuìcà ndè ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dandu nècuàchì xí‑inini yucán, nì cachi‑nè: ―Nú ducán nduá, dandu ¿nansa cui càcu anima iin nèhivì? ");
INSERT INTO mitNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dandu nì cachi‑yà: ―Ñà‑ndùá có‑sâà nèhivì quida‑ne, vàtùni quida Dios‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dandu nì cachi Pedro xì‑yá: ―Nsiùhù, sànì nacoo iì‑nsí nsidaa ñà‑ndùá icúmí‑nsî, te vàxi‑nsi nchícùn‑nsì mii‑ní, Stoho‑nsì Señor. ");
INSERT INTO mitNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dandu nì cachi‑yà xì nsidaa‑né: ―Ñà‑ndáà nduá cachíˋ xì‑nsiá yohó, nú nchícùn iin nèhivì ñuhìví ìì xí Dios, te sàhámà icúmí‑nê nacoo‑ne iñàha, (màsà ndúlócô‑nè), mate ni nácóó‑né vehe‑ne, ò yuadíhí‑nê, ò ñani‑nè, ò cùha‑ne, ò ñahàdìhí‑nè, ò dèhe‑ne, (có‑quìdámà), ");
INSERT INTO mitNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","vàchi después yáha ga cuàhà gá más icúmí‑nê nìhìtáhvì‑né vida xi‑ne ñuhìví yoho. Daaní, na sáà‑nè inga ñuhìví vàxi xi‑nda, dandu nìhìtáhvì stná‑nè vida ndiaha nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Daaní, nì tavà cuaán‑yá ùxìn ùì nècuàchì dacuahá‑yá, te nì cachi‑yà xì‑né: ―Cunaha‑nsiá, ichì ñuu Jerusalén nchícùn‑ndà vichi, te ñuu yucán icúmí cuu ndisa nsidaa ñà‑ndùá nì tiaa nèhivì xí Dios sànaha sàhà yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Vàchi icúmí nèhivì dayáha‑ne yùhù ndahà tè‑inga raza ñà‑cuàcùndiaà‑te yùhù, te canàhá stná‑te xìˊ. Te icúmí stná‑te sivi dìí‑te nùí, te cahnì cuìí‑te yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Dandu después cahnì‑té yùhù. Doco tìxi ùnì quìvì icúmî natiacuì ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Doco nècuàchì dacuahá‑yá, cónì cúndáà ini‑nè sàhámà. Cónì sáà‑nè mànìhì ini‑nè, vàchi nahi palabra dèhé nì sandua nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yatni iá‑yà ñuu Jericó vàxi‑ya, te yuhù íchî yucán iá iin nècuàchì cuaá xícàn xì caridad. ");
INSERT INTO mitNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Te na ní tiacu‑nè yáha cuàhà nèhivì, dandu nì ndàcàtnùhù‑né ndíà nduá cuú. ");
INSERT INTO mitNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Te nì cachi nèhivì ñà‑divi Jesús de Nazaret cuàhàn yàha. ");
INSERT INTO mitNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ñàyùcàndùá, nì ndàhì‑nè, cachí‑nè: ―¡Jesús! ¡Mii‑ní descendencia ìì xí David! ¡Cuhi inì‑ní yùhù! ");
INSERT INTO mitNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Doco nèhivì idónuu (nùù nèhivì cuáhà mà), nì canàhá‑nè xì nècuàchì cuaá mà, ni cadí‑nè yuhù‑né cachí nècuàchìmà xì‑né. Doco mii‑né, chicá ndee ní ndàhì‑nè, cachí‑nè: ―¡Mii‑ní descendencia ìì xí David, cuhi inì‑ní yùhù! ");
INSERT INTO mitNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dandu nì cucuiin Jesús, nì dàndàcú‑yá ñà‑nì cúndácá nèhivì nècuàchìmà quixi. Te na ní tnàtuu‑ne, nì xìcàn tnùhù‑yá nùù‑né, ");
INSERT INTO mitNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","cachí‑yà: ―¿Ndíà nduá cuní‑nî quide? Dandu nì cachi‑nè xì‑yá: ―Señor mío, cuníˋ natùinuìˊ. ");
INSERT INTO mitNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dandu nì cachi‑yà xì‑né: ―¡Ni ndúvàha nduchìnúù‑ní, cachíˋ xì‑ní! Vàchi ñà‑sànì xinindisa‑ní, ñàyùcàndùá sànì nduvàha‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dandu luegu nì natùinuù‑né, te nì tenchicùn stná‑nèyà, naquímánì‑né Dios. Te nsidaa nèhivì nì xini ñà‑ndùá nì cuu, nì ndenihi ndiaha stná‑nèyà sàhámà. ");
INSERT INTO mitNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na ní sàà‑yà ñuu Jericó, nì yàha uun‑ya inii ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Te cunaha‑nsiá, ñuu mà iá stná iin nècuàchì cuìcà nani Zaqueo. Te chuun xi nècuàchìmà nduá dandacú‑né nùù dava ga tè‑dàchíyàhvi. ");
INSERT INTO mitNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Te cuní stná‑nè cundehè‑né Jesús ana nduú‑yá. Doco mànìcùí ñà‑cuàhà guá nèhivì itá yucán, vàchi iin nècuàchì cuisí nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ñàyùcàndùá, nì dàyáà‑nè chicá nùù‑xí, te nì nana‑ne dòcò iin yutnù fruta tnuu, vàchi yucán icúmí Jesús yàha‑ya. ");
INSERT INTO mitNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Dandu na ní sàà‑yà lugar mà, nì ndacoto‑ya dìquì‑xí, te nì xini‑yà nècuàchìmà, dandu nì cachi‑yà xì‑né: ―Zaqueo, dansíhi‑ní nuu‑ní, vàchi vichi icúmî sàì vehe‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ñàyùcàndùá, vichi vichi nì nuu yàchì nècuàchìmà, te ndacá‑néyà mànuhù vehe‑ne, cudíì ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Doco nèhivì cuáhà mà, na ní xini‑nè cuàhàn‑yà xì nècuàchìmà, dandu nì xitnùhu‑neyà, índù chuun cuàhàn‑yà vehe iin nècuàchì iá cuàhà cuàchi‑xi, nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Daaní, (na iá‑yà vehe Zaqueo mà), nì ndacuiin nècuàchìmà, cachí‑nè xì‑yá: ―Señor mío, ñà‑ndùú davatahvi biene xi cuàhìn dasín nùù nèhivì ndahví. Te nècuàchì nì dàndàhvíˋ nì quihin dìhùn‑xí, cùmì tantu gà cuàhìn nacuàhi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dandu nì cachi Jesús (xì nèhivì yucán): ―Vichi sà‑ìá salvación xi nècuàchì dìvéhé‑xí yohó, vàchi nacua nì quida yohòtéhè‑ndà Abraham, ducán nì quida stná‑nè, (te sàhámà nì càcu‑ne), ");
INSERT INTO mitNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","vàchi yùhù ana nduú Tnaha Nèhivì Ñuhìví, nì quesaì ñuhìví yohó ñà‑nanduquí ana nì tùcù inga ichì, te dacácui anima‑nè ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Daaní, nsidaa nèhivì yucán, ndoó‑né iníní‑né ñà‑ndùá cachí‑yà. Dandu nì nacani tu‑ya xì‑né inga ejemplu, vàchi sà‑ìtúú‑yá sàà‑yà ñuu Jerusalén, te tuxí ini‑nè ñà‑mà cuéé gà, te sàà tiempu ndiaha cusahnú Dios (ñuhìví yohó). ");
INSERT INTO mitNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ñàyùcàndùá, nì cachi‑yà xì‑né: ―Nìsa ìa iin dèhe rey, cuní‑nè cùhùn xìcà‑né inga ñuu ñà‑nìhì stná‑nè chuun dandacú stná‑nè, dandu después ndixi‑ne (cusahnú‑né). ");
INSERT INTO mitNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ñàyùcàndùá, (na táñâha ga quihin‑ne ichì, dandu) nì cana‑ne ùxìn peón xi‑ne, te nì sàha‑ne iin iin‑tè iin iin dìhùn oro, te nì cachi‑nè xì‑té: “Inii tiempu dècuèndè quìvì naxicocuíìn icúmí‑nsiâ quida‑nsia lucha nducuahà dìhùn yohó”, (nì cachi‑nè xì‑té, dandu cuàhàn‑nè). ");
INSERT INTO mitNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Doco nècuàchì ñuu‑nè, sàhà‑ñá có‑xìñùhù‑né nècuàchìmà, ñàyùcàndùá, nì techuún‑né itnii nèhivì xí‑né nihi‑xi razón cuàhàn, te dohó cachí razón mà: “Có‑cùní‑nsì cusahnú nècuàchì jaàn nùù‑nsí”, cacháˋ. ");
INSERT INTO mitNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Doco nècuàchìmà, vàtùni nì nìhì‑né chuun cusahnú‑né, te nì naxicocuíìn‑nè ñuu‑nè mà. Dandu nì dàndàcú‑né cànà nsidaa peón nì sàha‑ne iin iin dìhùn mà, vàchi cuní‑nè cundaà ini‑nè nadaa nì nandua. ");
INSERT INTO mitNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dandu nì tnàtuu tè‑primeru, cachí‑te: “Señor, imindaa dìhùn oro nì taxi‑ní, doco vichi sànì nandua ùxìn dìhùn”. ");
INSERT INTO mitNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Dandu nì cachi nècuàchìmà xì‑té: “¡Vàtùni iáˋ! Peón vàha nduu‑ní. Ñàyùcàndùá icúmí‑nî dandacu‑ní nùù ùxìn ñuu nahnú, vàchi viì gá nì quida‑ní xì iin chuun tii”. ");
INSERT INTO mitNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Dandu nì tnàtuu peón ùì, cachí‑te: “Señor, nì taxi‑ní imindaa dìhùn oro, doco vichi sànì nandua ùhùn”. ");
INSERT INTO mitNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ñàyùcàndùá, nì cachi‑nè xì témà: “Mii‑ní, icúmí‑nî dandacu‑ní nùù ùhùn ñuu nahnú”. ");
INSERT INTO mitNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Dandu nì tnàtuu inga peón, cachí‑te: “Señor, yohó naquihin‑ní dìhùn xí‑nî, vàchi nì chivàhià nùù iin sìcoto. ");
INSERT INTO mitNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Vàchi yúhîˋ mii‑ní. Ináhî nansa iá‑nî, dana‑ní, dècuèndè tùha stná‑ní candiaà‑ní iñàha mate cónì quìdáchúún‑nî, te tùha stná‑ní quihin‑ní cosecha ndé cónì xìtù‑ní”. ");
INSERT INTO mitNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dandu nì cachi nècuàchì dàndàcù‑mà xì peón mà: “¡Peón malu nduu‑yó! Ináhú dana yùhù, te candiáì iñàha ndé cónì quìdáchúîn, te ndaníhí cosecha ndé cónì xìtúí. ");
INSERT INTO mitNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Te nú ináhú ducán quidé, dandu ¿índù chuun cónì dàcúhùn dìhùn xí nùù iin vehe ndé quidachuún‑né xán, dandu na quívì nsiaì, vàtùni nìhì stnáì dìquìá ni cuí?” ");
INSERT INTO mitNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dandu nì cachi‑nè xì peón itá yatni ma: “Candiaà‑nsia dìhùn nùù tè‑yòhó, te cuàha‑nsia nècuàchì icúmí ùxìn dìhùn oro jaàn”. ");
INSERT INTO mitNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dandu nì cacachi peón mà xì‑né: “Doco Señor, sà‑ìcúmí nècuàchìmà ùxìn‑ñà vitni”. ");
INSERT INTO mitNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Doco nì cachi nècuàchì cusáhnú‑má: “Cunaha‑nsiá, ana sà‑ìcúmí algu vichi, icúmí‑nê nìhì gá‑nè más, te ana icúmí cuisì iyuhu iñàha, icúmí cuxio nsidaa ñà‑ndùá icúmí‑nê. ");
INSERT INTO mitNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Doco nèhivì xiní ùhì xìˊ, te có‑cùní‑nè cusahnúí nùù‑né, cundaca‑nsianè quixi nùí, te cahnì‑nsiánè yohó”, nì cachi rey mà. ");
INSERT INTO mitNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Daaní, nì nsihi nì nacani‑ya ejemplu mà, nì quihin tu‑ya ichì cuàhàn‑yà Jerusalén, idónuu‑yá nùù compañeru‑yà cuàhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Te sà‑ìtúú‑yá sàà‑yà ñuu cuati Betfagé xì Betania, frente yucù Olivo. Dandu nì càhàn‑yà xì ùì nècuàchì dacuahá‑yá ñà‑nì cúhùn cueé‑nè chicá nùù‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Te dohó nì cachi‑yà xì‑né: ―Cuahán‑nsià ñuu tii yatni yucán. Te na sáà‑nsià yucán, dandu icúmí‑nsiâ cuni‑nsià ndé nuhní iin burru chii. Burru tàñáha ga cuida nduú‑si. Quisì yucán ndaxin‑nsiá cundaca‑nsia quixi. ");
INSERT INTO mitNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te nú ndàcàtnùhù nèhivì nùù‑nsiá índù chuun ndaxin‑nsiási, dandu cachi‑nsià xì‑né ñà‑Stoho‑ndà Señor xiñuhu xi‑sí ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dandu luegu nì caquihin ùì nècuàchìmà ichì cuàhàn‑nè chuun ma, te nì xini‑nè ñà‑divi nacua nì cachi‑yà xì‑né, ducán ndisa nì ìa. ");
INSERT INTO mitNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Te na meru ndaxin‑nési, dandu nì càhàn stohò‑si xi‑né, cachí‑nè: ―¿Índù chuun ndaxin‑nsiá burru yohó? ");
INSERT INTO mitNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dandu nì cachi‑nè: ―Stoho‑ndà Señor xiñuhu xi‑sí. ");
INSERT INTO mitNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dandu nì saca‑nèsi cuàhàn‑nè ndé iá‑yà; te nì chindàndòó‑né sìcoto xi‑ne dìquì‑sí, te nì sàcùnùú‑yàsi ");
INSERT INTO mitNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","nì quihin‑ya ichì cuàhàn‑yà (ñuu Jerusalén). Te ichì yucán ndé yàha‑ya nì chitànduhù nèhivì dòò‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Te na sá‑ìtúú‑yá nacatacaa‑ya yucù Olivo yucán, dandu nsidaa nèhivì nchícùn xì‑yá, nì quesaha‑né cána fuerte‑ne, naquímánì‑né Dios sàhà ñà‑cuàhà guá milagru nì quida‑ya nì xini‑nè; ");
INSERT INTO mitNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","te palabra yohó nduá nì cachi‑nè: ―¡Ndiaha gá rey yohó vàxi cuenta xi Stoho‑ndà Señor! ¡Ndiaha gá iá paz ansivi! ¡Ndiaha gá quidá mii‑yá iá dìquì‑xí! ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dandu dava nècuàchì fariseu cuàhàn mahì nèhivì cuáhà mà, nì cachi‑nè: ―Maestro, càhàn‑ní xì nèhivì xí‑nî (ñà‑màsà cáchí‑nè ducán). ");
INSERT INTO mitNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dandu nì cachi‑yà xì‑né: ―Cunaha‑nsiá, nú ni cúdádî nècuàchì cána guá yohó, dandu fuerza icúmí càna stná nsidaa yùù ndoó yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Daaní, nì sàà‑yà yatni ñuu Jerusalén. Te nì indehè‑yá ñuu cahnu‑ma. Te nì sacu‑ya sàhà nèhivì ndoó yucán, ");
INSERT INTO mitNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","cachí‑yà: ―¡Ndahví‑nsià! Vàchi meru quìvì vàha xi‑nsia nduá vitni. ¡A sácú vàha nú ni sáà‑nsià cundaà inì‑nsia nansa coo ndisa paz ñuù‑nsia ni cuí! Doco cónì cúndáà inì‑nsia. Ñàyùcàndùá, vichi sànì ndòo dèhámà nùù‑nsiá, te mà níhì gá‑nsià cundaà inì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Cunaha‑nsiá, vàxi iin quìvì caquixi contra xi‑nsia, te natnahà‑te ñuu‑nsià, dandu caquidavàha‑tè nama orilla ñuù‑nsia ñà‑cadì‑te nùù‑nsiá. Dandu nàá stnahá‑te xi‑nsiá nsidanicuú ladu. ");
INSERT INTO mitNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Te dacaá nsihi‑tè vehe‑nsia, te cahnì nsìhí stná‑te mii‑nsiá. Mà ndóo ga ni‑iin yùù idótnahá víi yohó. Nsidaájàn icúmí cuu xi‑nsiá sàhà ñà‑cónì nácúní‑nsià ana dacácu xi‑nsiá ni cuí. ");
INSERT INTO mitNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Daaní, cuàhàn‑yà veheñùhu cahnú, te nì taxi nsihí‑yá tè‑dìcó xì tè‑xìín ndoó yucán, ");
INSERT INTO mitNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","cachí‑yà xì‑té: ―Dohó cachí Dios nùù tutu ìì: “Veheñùhu xi, icúmíâ cundua iin vehe ndé natácá nèhivì càcàn tàhvì nùí”. Doco sàhà mii‑nsiá sànì nandua na iin lugar ndé ndoó cuàhà tècuìhnà ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Daaní, nsìquívì sáhàn‑yà veheñùhu cahnu‑ma, te dacuahá‑yá nèhivì. Doco dùtù xícusahnú, xì nècuàchì ley xi veheñùhu, xì stná nècuàchì nihí chuun ñuu mà, nandúcú‑nê nansa cui dandáñúhú‑nêyà. ");
INSERT INTO mitNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Doco mànìcùí nìhì‑né nansa quida‑neà, vàchi nsidaa nèhivì cuáhà mà, iníní vàha‑ne ñà‑ndùá dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Daaní, nì cuu iin quìvì mà iá‑yà dacuahá‑yá nèhivì veheñùhu cahnu‑ma. Te na meru cáhàn‑yà razón vàha xi Dios, dandu nì casaà stná dùtù xícusahnú, cutnáhâ‑né xì nècuàchì ley xi veheñùhu, xì stná nècuàchì xídandacú nùù ñuu mà, ");
INSERT INTO mitNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","cachí‑nè xì‑yá: ―Cachì‑ní xì‑nsí índù nì nìhì‑ní derechu quida‑ní ñà‑ndùá quida‑guá‑nî. ¿Ana divi nì dàndàcú núù‑ní ñà‑quida‑ní ducán? ");
INSERT INTO mitNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Dandu nì cachi‑yà xì‑né: ―Yùhù ndácàtnùhù stnáì nùù mii‑nsiá iñàha, te cachi‑nsià xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ana divi nì dàndàcù‑xì núù Juan Bautista ñà‑quida iì‑né nèhivì? ¿A Dios nì cachi xì‑né, te ò nèhivì ñuhìví? ");
INSERT INTO mitNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dandu nècuàchìmà, nì candatnuhu tnahá nsidaa‑ní mii‑né, cachí‑nè: ―¿Ndíà cachi‑ndà? Vàchi nú ni cachí‑ndà divi Dios nì dàndàcù‑xì núù Juan, dandu cachi Jesús xì‑ndà: “¿Índù chuun cónì xìníndísâ‑nsiá nècuàchìmà, nú ducán?” ");
INSERT INTO mitNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Doco nú ni cachí‑ndà divi nèhivì ùún nì cachi xì nècuàchìmà, dandu cahnì nèhivì‑ndó xì yùù, vàchi nsidaa‑né ndeníhí‑né Juan mà ñà‑nì sanduu ndisa‑ne iin ana nìsa cahàn cuenta xi Dios ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ñàyùcàndùá, nì naxiconihí‑né nùù Jesús ñà‑có‑cùndáà ini‑nè ana divi (nì dàndàcù‑xì núù Juan mà). ");
INSERT INTO mitNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dandu nì cachi‑yà xì‑né: ―Ni yùhù, mà cáchí stnáì xì‑nsiá ana divi nì dàndàcù‑xì núìˊ quide ñà‑ndùá quidé. ");
INSERT INTO mitNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dandu nì nacani‑ya xì nèhivì iin ejemplu, te dohó nì cachi‑yà: ―Nìsa ìa iin lamú, te nì dànándèe‑ne nducu yòhò sì‑úvà nùù ñuhù xí‑né. Dandu nì tatu‑nè itnii medieru cundiaa xán, te cuàhàn xìcà‑né caní tiempu. ");
INSERT INTO mitNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Daaní, después, na sánì sàà tiempu cùchi quisì vídì mà, dandu nì techuún‑né iin peón xi‑ne nùhù naquihin xi chii fruta mà nùù medieru mà. Doco na ní sàà peón mà, nì casahnì cuìí‑tené, te nì taxi‑ténê, còò ni‑iñàha nihí‑né nì násáá. ");
INSERT INTO mitNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Daaní, inga tu nì techuún lamú mà inga peón. Doco medieru mà, tucutu nì casahnì cuìí‑tené, nì quida quini‑tè xì‑né, te nì taxi tú‑tené, còò ni‑iñàha nihí‑né nì násáá tu. ");
INSERT INTO mitNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Daaní, ñà‑únì nì techuún tu lamú mà inga nèhivì, doco divini ducán nì cuu xi‑né, dècuèndè nì dànácuèhè tèmà‑né, te fuerza nì tavà‑ténê nùù ñuhù ndé iá ñà‑tàtá mà. ");
INSERT INTO mitNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ñàyùcàndùá, nì cachi lamú mà: “¿Ndíà quide vichi? Ádi chicá vàha techuín dèhemaní nùhù‑te, vàchi vihini quidañuhu‑té dèhi”, cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Doco medieru mà, na ní xinì‑te vàxi dèhe lamú xi‑tè, dandu nì candatnuhu tnahá‑te, cachí‑te: “Tè‑yòhó nduú tè‑ìcúmí ndutahvì xì ñuhù yohó. Vichi cahnì‑ndàté chicá vàha, dandu mii‑nda nanduu‑nda stoho ñuhù yohó”, nì cacachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ñàyùcàndùá, nì tavà‑té nècuàchìmà iladu nùù ñuhù mà, te nì casahnì‑ténê. ’Pues vichi, ¿ñdíà ndùá icúmí lamú mà quida‑ne xì medieru mà? ");
INSERT INTO mitNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Icúmí‑nê nùhù‑nè cahnì nsìhí‑nète, dandu nanducu saa‑né inga ana quidachuún ñuhù xí‑né ―nì cachi‑yà. Dandu nì cachi nèhivì xí‑inini ma: ―¡Ay! ¡Ndiaha ini Dios, màsà cúú ducán! ");
INSERT INTO mitNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dandu nì indehè‑yánè, te nì cachi‑yà: ―Nacua cachí nùù tutu ìì xí Dios, ñà‑jaàn nduá icúmí cuu, vàchi dohó cacháˋ: Nì ìa iin cavà nì cahíchì ini albañil. Doco vichi sànì sàà mà nì sàcùndua yùù vico esquina vehe. ");
INSERT INTO mitNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Te nsidaa ana caquìhi sàhà‑xí cavà mà, icúmí‑nê nacuèhè‑nè. Te nsidaa ana nacava cavà mà dìquì‑xí, tàdì nchìhì‑nè quida‑mà ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dandu dùtù xí‑cusahnú, xì nècuàchì ley xi veheñùhu ma, nì cuni‑nè tnii‑neyà hora mà, vàchi nì cundaà ini‑nè ñà‑sàhà mii‑né nì nacani‑ya ejemplu mà, doco mànìcùí tnii‑neyà, vàchi yúhî‑nè nèhivì cuáhà mà. ");
INSERT INTO mitNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ñàyùcàndùá, nì techuún‑né nèhivì cùhùn quida maña, datiaá uun‑ne nduú‑né nèhivì vàha, te cunini vàha‑ne nansa cachí‑yà, áma níhìndèè‑né càhàn tnùhu‑ne sàhà ñà‑ndùá cachí‑yà, te ducán tnii‑neyà dayáha‑neyà ndahà gobernador. ");
INSERT INTO mitNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ñàyùcàndùá, cuàhàn nècuàchìmà nùù‑yá, te nì ndàcàtnùhù‑né, cachí‑nè: ―Maestro, ináhá‑nsî mii‑ní, ana ndàà cuisì inì‑xi nduu‑ní, te cuisì ñà‑ìá viì dacuaha‑ní nèhivì. Ni có‑yûhî stná‑ní ni‑iin nèhivì; còó, vàchi chináhá víi‑ní ñà‑ndùú ichì váha Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ñàyùcàndùá, cuní‑nsì cachì‑ní xì‑nsí, ¿a vátùni sáha Dios lugar ñà‑chiyàhvi‑nda renta nùù rey cahnú César, á coó? ");
INSERT INTO mitNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Doco Jesús, sànì cundaà ini‑yà ñà‑có‑xîcàn tnùhù sahnú ndisa‑ne nùù‑yá nduá. Ñàyùcàndùá, nì cachi‑yà xì‑né; ―¿Índù chuun cuní‑nsià quida‑nsia maña nùí? ");
INSERT INTO mitNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Dacuní‑nsià yùhù iin dìhùn cundehí. Bueno, vichi cachì‑nsia xìˊ ana dìnúù‑xí, te ana dìquívì‑xí itúú ìcà dìhùn yohó. Te nì cachi‑nè: ―Divi rey cahnú César. ");
INSERT INTO mitNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dandu nì cachi‑yà xì‑né: ―Nú ducán nduá, dandu nacuàha‑nsia César ñà‑ndùá icúmí‑nsiâ cuàha‑nsiàte, te cuàha stná‑nsià Dios ñà‑ndùá ndiá ìcà‑nsiá cuàha‑nsiayà ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ñàyùcàndùá, (nì cundaà ini nèhivì nì ndàcàtnùhù mà) ñà‑mà cùì dadaná‑néyà na cáhàn‑yà nùù nèhivì cuáhà mà. Ñàyùcàndùá, nì ndulocó‑nè, te dadí uun nì candòo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Daaní, nì casaà itnii nècuàchì saduceu nùù‑yá. Te nècuàchìmà, có‑xìníndísâ‑né ñà‑ìcúmí‑ndá natiacu‑ndà. Ñàyùcàndùá, nì xìcàn tnùhù‑né nùù‑yá, ");
INSERT INTO mitNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","cachí‑nè: ―Maestro, ñà‑yòhó nduá nì tiaa Moisés quida‑nda: nú sànì xìhì iin tiàa, doco còò déhe‑ne ni ndóo (xi ñahàdìhí‑nè), dandu icúmí ñani nsìi ma nandàhà‑né xì ñahàcuàán mà áma cóó iin dèhe‑ne; dandu quida‑nda cuenta na ian dèhe nsìi ma nduú méè mà. ");
INSERT INTO mitNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pues cunaha‑ní, nì sandoo ùsà ñàní. Te nècuàchì chicá sahnu‑ma, nì nandàhà‑né xì iin nècuàchì ñahà, doco nì xìhì‑nè, te còò déhe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dandu ñani‑nè chicá nchícùn gà mà, nì nandàhà stná‑nè xì nècuàchìmà, doco nì xìhì stná nècuàchì ùì mà, te còò stná dèhe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Daaní, nì nandàhà nècuàchì ùnì xì ñahà mà, doco nì xìhì stná‑nè; te divi ducán nì cuu xì nsì‑úsà ñàní mà; doco divini, còò ni‑iin dèhe nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Daaní, último nì xìhì stná nècuàchì ñahà. ");
INSERT INTO mitNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ñàyùcàndùá, na sáà quìvì (cachí‑nsià) natiacu nsìi, ¿índù tiàa ma nacuaca xi nècuàchì ñahà mà ñà‑nsì‑úsà‑nè nìsa ìa xi‑ñá? ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Dandu nì cachi Jesús xì‑né: ―Ñà‑ndáà nduá, tùha nèhivì ñuhìví yohó nandàhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Doco nèhivì natùi natiacu cundoo inga ñuhìví, mà nándàhà gá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ni mà cúí gà‑nè, vàchi cuàhàn‑nè ndudava‑ne xì ángel, cunduu‑ne dèhe ndisa Dios, vàchi ñà‑sànì natiacu‑nè cundua. ");
INSERT INTO mitNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Doco sàhà chuun ñà‑natiacu‑ndà, claru nì cachi Moisés sànaha sàhà ñà‑jaàn na ní nacani‑ne sàhà yutnù tìì (xíxìn); nì cachi‑nè ñà‑divi Stoho‑ndà Señor nduú Dios càhvì nsì‑Abraham, xì nsì‑Isaac, xì nsì‑Jacob. ");
INSERT INTO mitNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","(Ñàyùcàndùá, itiácú ìì nsìi ma), vàchi nècuàchì nì xìhì dahuun ndisa, mà cúí cahvi‑né Dios; còó, cuisì nèhivì itiácú càhvì xi‑yá. Vàchi nùù mii‑yá, itiácú nsidaa ana nduú nèhivì ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dandu nì naxiconihí dava nècuàchì ley xi veheñùhu, cachí‑nè: ―Vàtùni cachí‑nî, Maestro ");
INSERT INTO mitNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Daaní, nì nsihi nì càhàn‑yà xì‑né ducán, còò gá iin ni sáhandee inì‑xi ndàcàtnùhù gá xì nùù‑yá sàhà ni‑iñàha. ");
INSERT INTO mitNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Dandu nì cachi Jesús xì nèhivì cuáhà mà: ―Cachí nèhivì, yohòtéhè xìì‑ndà David cunduu (rey ndiaha nani) Cristu. Doco ¿nansa iájàn? ");
INSERT INTO mitNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Vàchi mii David mà, nì tiaa‑ne nùù libru ìì nani Salmos, te dohó nì cachi‑nè: Nì càhàn Yua‑nda Dios xì Stohi (divi Cristu), nì cachi‑yà: “Yohó coo‑ní ladu cuahíˋ ndè cachi sàà cundeí nùù nsidaa ana xìní ùhì xì‑ní, dandu cusahnú fuerte‑ní nùù‑né”, nì cachi Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Cundehè‑nsiá, nì cachi David ñà‑Stoho‑nè nduú Cristu. Doco nú ducán nduú‑yá, dandu ¿índù modo cunduu stná‑yà iin descendencia xi‑ne? (Doco ñà‑ndáà nduá.) ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Daaní, nì cachi‑yà palabra yohó xì nècuàchì dacuahá‑yá, iníní nsidaa nèhivì yucán: ");
INSERT INTO mitNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Còtó quida‑nsia na xíquida nècuàchì ley xi veheñùhu, vàchi ñà‑diì xí‑né nduá cacanuu‑ne cundixi‑ne sìcoto quihín vico, te casàhú tnùñuhu nèhivì xì‑né yàhvi. Te na sáhàn‑nè veheñùhu, ò ndoó‑né iin vicò, dandu nandúcú‑nê lugar ndé chicá ndiaha cundoo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Te tùha stná‑nè (tnii diqui‑né ley, te) xidándiáá‑nè vehe nècuàchì nì xìhì iì‑xí, dandu después sácuìta‑ne nacuátú cuáhà‑né na ian ndisa vàha guá‑nè. Sàháyùcàndùá, iin castigu chicá fuerte icúmí‑nê nìhì‑né ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iá‑yà veheñùhu cahnú, te nì ndacoto‑ya nì xini‑yà daquée tècuìcà promesa xi‑tè ini alcancía xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Te nì xini stná‑yà iá iin nècuàchì ñahà ndahví nì xìhì iì‑xí, te nì dàquée‑ne ùì ñà‑úhùn centavu. ");
INSERT INTO mitNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dandu nì cachi‑yà: ―Ñà‑ndáà nduá cachíˋ xì‑nsiá, chicá más nduá nì sàha ñahà ndahví jaàn nùù ñà‑nì sàha nsidaa gá nèhivì yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vàchi nsidaa gá‑nè, cuisì ñà‑cùyódo nùù‑né nduá nì sàha‑ne. Doco nècuàchì ñahà yohó, mate ndahví dahuun‑ne, doco nì sàha‑ne nsidanicuú dìhùn sàhà ñà‑cuiin‑ne ñà‑cutiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Daaní, nì quesaha dava‑ne nì càhàn‑nè sàhà veheñùhu cahnú, na cuaha guá iá yùù nahnú nì cuyucàn, te na cuaha guá iá promesa nì sàhatahvì nèhivì nì nducutá, cachí‑nè. Ñàyùcàndùá nì cachi‑yà xì‑né: ");
INSERT INTO mitNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Cunaha‑nsiá, vàxi iin quìvì icúmí nèhivì ducùn‑né nsidaa ñà‑ndùá indéhe‑nsiá yohó, ni mà códotnahá gá ni‑iin yùù yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dandu nì ndàcàtnùhù‑né nùù‑yá, cachí‑nè: ―Maestro, ¿índù quìvì cuu ñà‑ndùá nì cachì‑ní jaàn? ¿Índù milagru coo ñà‑cundaà ini‑nsì sà‑ìtúú quìvì mà? ");
INSERT INTO mitNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Dandu nì cachi‑yà xì‑né: ―Cuidadu cundoo‑nsia màsà dándáhvî ni‑iin nèhivì‑nsiá. Vàchi cuàhà ana icúmí quixi danani uun nduú‑né yùhù, te cachi iin iin‑ne xì nèhivì ñà‑Cristu nduú‑né. Te ò cachi‑nè: “Vichi ndisa sànì sàà quìvì (xí‑yá)”. Doco mii‑nsiá, màsà cúnchícùn‑nsià nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Te nú cunitnùhu‑nsia iá cuàhà guerra, ò iá revolución, màsà yúhî‑nsià, vàchi fuerza icúmí cuu ducán primeru. Doco tàñáha ga nsihi tiempu yohó nduámà, iá gà ñà‑vàxi cuu. ");
INSERT INTO mitNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dandu nì cachi stná‑yà xì‑né: ―Cunaha‑nsiá, ñuu xì ñuu icúmíâ nàá stnahá. Te cuàhà rey, icúmí‑tê dandacú‑te coo guerra xì inga ñuu. ");
INSERT INTO mitNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Te icúmí tnàa fuerte, te quixi stná tnama yohó te yucán, te coo cuàhà stná cuèhè cuàhà ñuu; te ndè ansivi icúmí coo cuàhà seña nahnú dayúhî xì nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Doco na táñâha ga cuu nsidaájàn, dandu icúmí nèhivì tnii‑ne mii‑nsiá, te quida quini‑ne xì‑nsiá, cundaca‑ne mii‑nsiá cùhùn nùù tè‑xídandacú veheñùhu, te chicadi stná‑nè mii‑nsiá vehecàa. Te icúmí stná‑nè datnátuu‑ne mii‑nsiá nùù rey xì nùù gobernador (ñà‑daquée cuàchi‑ne dìquì‑nsiá). Nsidaájàn icúmí‑nê quida‑ne xì‑nsiá sàhà ñà‑nchícùn‑nsià yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dandu cundua quìvì quida tocar mii‑nsiá datúi stná‑nsià nùù nsidaa‑né ñà‑ndùá xiníndísâ‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Doco iin‑ni cunihnu ini‑nsià; màsà nácání ini‑nsià nansa nachutnahá víi‑nsiá palabra naxiconihí‑nsiá nùù nècuàchì gobiernu mà, ");
INSERT INTO mitNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vàchi mií, icúmî chindeí sàxìnítnùní‑nsià ñà‑vàtùni càhàn nchichí‑nsià, te naxiconihí víi‑nsiá nùù‑né. Te mii‑né, ni mà nánîhì tnùní ini‑nè nansa naxiconihí‑né nùù‑nsiá. Còó, mà níhì‑né nacahnù‑nè mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","’Daaní, ndè stná yuadíhí‑nsiâ, ò ñani‑nsià, ò tnaha ga‑nsià, ò amigo xi‑nsia, icúmí‑nê cahin stná‑nè mii‑nsiá nùù tè‑xídandacuma; te dava‑nsia icúmí‑nê càcàn‑nè ñà‑cui‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Te sàhà yùhù icúmí nsidaa nèhivì cuni ùhì‑nè mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Doco mà sáà‑nsià ndañuhu‑nsiá (nùí); ni‑iin idìdínì‑nsiá mà ndáñúhú. ");
INSERT INTO mitNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Te nú iin‑ni ni cúníndísâ‑nsiá, dandu nìhì‑nsiá cutiacu ndisa anima‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Doco quìvì cuni‑nsià inicutu sànì natnaha soldadu ñuu Jerusalén yohó, dandu ñà‑jaàn cundaà inì‑nsia sà‑ìtúú quìvì cuàhàn‑te dandáñúhú‑tê ñuu yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ñàyùcàndùá, na sáà quìvì mà, ni cunúdèhé nsidaa nèhivì ndoó ladu Judea yohó, te cundoo dèhé‑nè yucù. Te nècuàchì ndoó ini ñuu yohó, ni cáquéé‑né fuera, te nècuàchì ndoó fuera, màsà nánsìhvi ga‑nè ñuu. ");
INSERT INTO mitNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vàchi quìvì yucán cunduu quìvì nìhì (cuàhà nèhivì) castigu, te cuu ndisa nsidaa ñà‑ndùá nì cachitnùhu tutu ìì xí Dios sànaha. ");
INSERT INTO mitNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ndahví nècuàchì ñahà cuhí cuàhàn tùinuù méè‑xi! Te ¡ndahví stná nècuàchì icúmí xí méè chichi! Vàchi quìvì yucán cuàhà gá tnùndoho icúmí coo inicutu ñuu yohó; cuàhà castigu icúmí nèhivì yohó nìhì‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Te cuàhà gá‑nè cui nùù guerra, te cuàhà gá stná‑nè cundaca‑tè fuerza cùhùn ñuu xìcà (ñà‑quidachuún‑né). Te icúmí nècuàchì inga raza dandacú‑né nùù ñuu Jerusalén yohó dècuèndè nsihi tiempu iá permisu quida‑ne ducán. ");
INSERT INTO mitNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Quìvì yucán icúmí coo cuàhà seña nùù orá, xì nùù yoo, xì stná nùù sìtnúù; te yáha ga icúmí ndulocó nèhivì ñuhìví yohó, te nacani cuaá ini‑nè na tiácú‑nè ñà‑fuerte guá cahá ndee tècuìí mar, te nacuáhnú ducún‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Dècuèndè cuñaà‑né ñà‑yúhî guá‑nè ndoó‑né ndiatú‑né cuu ñà‑ndùá cuàhàn cuu ñuhìví. Ndè stná sìtnúù nahnú itándiaa ansivi, icúmí‑sî ndacùchí ndee‑sí. ");
INSERT INTO mitNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dandu natùi yùhù ana nduú Tnaha Nèhivì Ñuhìví, cundehè nèhivì yùhù sàmànui mahì vìcò nahnú. Cahnú poder cucumí, te yáha ga ndiaha coo inicutu ndé iéˋ. ");
INSERT INTO mitNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Daaní, quìvì quesaha cuu nsidaájàn, dandu contentu ni cúndóó‑nsiá; ndacoto ndiaá‑nsià dìquì‑xí, vàchi sà‑ìtúú hora càcu‑nsia ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dandu nì nacani‑ya xì‑né inga ejemplu, te dohó nì cachi‑yà: ―Cundehè‑nsiá nù‑higuera jaàn, ò ndéni yutnù ní cui; ");
INSERT INTO mitNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","nú indéhe‑nda sànì ndunsidi‑nú, dandu ñà‑yùcán cundaà ini‑ndà sà‑ìtúú tiempu ihni. ");
INSERT INTO mitNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pues ducán stná mii‑nsiá, quìvì cuni‑nsià cuú ñà‑ndùá sànì cachì xì‑nsiá, dandu vàtùni cundaà inì‑nsia ñà‑sà‑ìtúú tiempu cusahnú Dios ñuhìví nduá. ");
INSERT INTO mitNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ñà‑ndáà nduá cachíˋ, mà sáà cui nsihi nèhivì itiácú vichi dècuèndè cachi sànì cuu ndisa nsidaa ñà‑ndùá sànì cachì xì‑nsiá vichi. ");
INSERT INTO mitNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cunaha‑nsiá, icúmí sàà ansivi xì ñuhìví ndañuhá, doco palabra cachí yùhù, còó, mà nunca sàà ndañuhá. ");
INSERT INTO mitNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Cuidadu cundoo‑nsia, còtó nandòdó‑nsiá ichì váha, vàchi nú quidá cuáhà‑nsiá vicò, te xíni‑nsia, te ò nacání cuáhà inì‑nsia sàhà vida xi‑nsia ñuhìví yohó, pues vihini nandòdó‑nsiá ichì mà, dandu nanàá sàà quìvì coo tnùndoho, te có‑nìhnú inì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vàchi na ian (nanàá tníì iin quisì ini) iin trampa, ducán icúmí quixi tnùndoho dìquì nèhivì inicutu ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ñàyùcàndùá, cunihnu tùha inì‑nsia, te càcàn tàhvì‑nsiá nicanicuahàn sàhà‑ñá vàtùni càcu‑nsia nùù nsidaa tnùndoho vàxi ma, te nìhìtáhvì‑nsiá natùi‑nsia màcùndoo‑nsia nùù yùhù ana nduú Tnaha Nèhivì Ñuhìví ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Quìvì yucán, veheñùhu cahnú iá‑yà ndui, dacuahá‑yá nèhivì, te ñuú núhù‑yà (iin ñuu tii iá) Yucù Olivo. ");
INSERT INTO mitNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dandu nsìquívì dàtnàà vàxi tu‑ya veheñùhu. Ñàyùcàndùá, nèhivì cuáhà mà, naha vàxi stná‑nè veheñùhu, vàchi cuní‑nè cunini‑ne nansa cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Vicò pascua nìsa nani iin vicò nìsa xixi‑ne pan có‑ndùtáchí. Te sà‑ìtúú vicò mà vàxan, te nì ndatnuhu tnahá dùtù xícusahnú xì nècuàchì ley xi veheñùhu, nandúcú‑nê nansa nìhì‑né cahnì‑né Jesús, vàchi yúhî‑nè (cunitnùhu) nèhivì cuáhà sàhámà. ");
INSERT INTO mitNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Daaní, nì quìhvi ñà‑malu ini anima iin tiàa dacuahá Jesús nani Judas Iscariote. ");
INSERT INTO mitNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ñàyùcàndùá, nì sàhàn‑nè nùù dùtù xícusahnú. Te nì càhàn‑nè xì nècuàchìmà, xì stná tè‑xídandacú nùù policía, nì ndatnuhu‑né xì nècuàchìmà nansa cui quida‑ne, te dayáha‑ne mii‑yá ndahà nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Te nècuàchìmà, nì cacudiì ini‑nè, te nì ndòo sahnú‑né chiyàhvi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ñàyùcàndùá nì cachi Judas vàtùni iámà, te nì quesaha‑né nì nanducu‑né nansa nìhì‑né dayáha‑neyà ndahà nècuàchìmà, doco ni cúndúá na có‑ndòó cuàhà nèhivì indéhe. ");
INSERT INTO mitNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Daaní, nì sàà vicò xixí‑né pan có‑ndùtáchí, te quìvì yucán xíhì stná iin lelù nduú promesa siempre sáha‑ne vicò pascua mà. ");
INSERT INTO mitNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ñàyùcàndùá nì techuún Jesús Pedro xì Juan, cachí‑yà xì‑né: ―Cuahán‑nsià quidayucun‑nsià ndé cuxi‑nda vicò pascua. ");
INSERT INTO mitNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Te nì cachi‑nè xì‑yá: ―¿Índù divi cuní‑nî cùhùn‑nsì quidayucun‑nsì? ");
INSERT INTO mitNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Dandu nì cachi‑yà xì‑né: ―Na sáà‑nsià ñuu mà, icúmí‑nsiâ ndacùhun tnahá‑nsiá xì iin tiàa idádocó xi iin yoo tècuìí. Divi nècuàchìmà cunchicùn‑nsià cùhùn dècuèndè vehe ndé quìhvi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Dandu càhàn‑nsià xì nècuàchì dìvéhé‑xí má cachi‑nsià xì‑né ñà‑dòhó cachí maestru xì‑né: “¿ndévì iá vehe cahnú ndé cuxi‑ya comida pascua xì nècuàchì dacuahá‑yá?” ");
INSERT INTO mitNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dandu nècuàchì dìvéhé‑xí má, icúmí‑nê dacuní‑nè mii‑nsiá índù iá iin vehe cahnú pisu dìquì‑xí ndé sà‑ìtá víi yutnù. Yucán nsidayucun‑nsià ñà‑cudiní‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dandu nì caquihin nècuàchìmà ichì cuàhàn‑nè. Te nacua nì cachi‑yà xì‑né, ducán ndisa nì cuu. Ñàyùcàndùá yucán nì quidayucun‑nè comida pascua. ");
INSERT INTO mitNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Daaní, na ní sàà hora mà, dandu nì sàà‑yà yucán, te nì sàcòo‑ya xì nsì‑úxìn ùì nècuàchì nì nìhì chuun nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Te nì cachi‑yà xì‑né: ―Yùhù, ñuhú cuísi inì cutnahí xì‑nsiá cuxi‑nda vicò pascua yohó, dandu después icúmî ndohi. ");
INSERT INTO mitNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Vàchi cachíˋ xì‑nsiá, mà cúxí guè comida vicò pascua ndè cachi sàà tiempu cusahnú Dios ñuhìví yohó; vàchi vicò yohó, ejemplu nduá, doco na sáà quìvì cusahnú‑yá, dandu cunduamà ñà‑sànì cuu ndisa ñà‑ndùá cuní cachi vicò yohó ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dandu nì tnii‑ya pocillu, te nì naquimanì‑yá Dios (sàhà ndutè sì‑úvà ñuhu‑ma), te nì cachi‑yà: ―Tnii‑nsia pocillu yohó, te coho nsidaa‑nsiá chichíí‑tê. ");
INSERT INTO mitNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Vàchi cachíˋ xì‑nsiá, mà cóhó guè ndutè sì‑úvà ndè cachi sàà tiempu cusahnú Dios ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Dandu nì tnii stná‑yà iin pan, nì naquimanì‑yá Dios sàhá, te nì dàcuàchí‑yáñà; dandu nì dasàn‑yáñà nùù nsidaa‑né, te nì cachi‑yà xì‑né: ―Pan yohó, nahi iquìcúñúì nduá, vàchi cuàhìn cuàhatahvì vida xi (cuì) sàhà nsidaa‑nsiá. (Cuxi‑nsia vichi, dandu después), nacua nì quida‑nda vichi, ducán quida stná‑nsià (quìvì nùù‑xí) sàhà‑ñá nsinuu inì‑nsia yùhù ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Daaní, divini ducán nì quida stná‑yà xì pocillu mà: na ní nsihi nì xixi‑ne, dandu (nì tnii‑yañà), te nì cachi‑yà: ―Ñà‑ñùhú pocillu yohó nduú seña xi ichì saa nacóí cunchicùn nèhivì, vàchi nahi nìí nduá, te icúmí nìí cuìtià sàhà‑ñá nìhìtáhvì ndiaha‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","’Doco cunaha‑nsiá, tiàa cuàhàn cahin xì yùhù ana nduú Tnaha Nèhivì Ñuhìví, iá‑nè yohó xixí tàcá‑ndà xì‑né nùù mesa yohó. Te mate ñà‑ndáà nduá, icúmí cuì, vàchi ducán nì chitnùní ini Dios, doco tiàa cuàhàn cahin xìˊ, ¡ndahví‑nè! ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ñàyùcàndùá, nì quesaha nèhivì ndoó yucán nì xìcàn tnùhù stnahá‑né nùù‑né ana nduú tiàa cuàhàn quida ducán cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nì cuàà stná‑nè sàhà‑ñá ana cunduu nècuàchì chicá ndiaá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ñàyùcàndùá, nì cachi‑yà xì‑né: ―Tè‑cùsàhnú inga ñuu, fuerte cusáhnû‑te nùù nèhivì ñuù‑te. Yua ñuu dandacú víi cachí tè‑xícusahnuma sàhà mii‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Doco mii‑nsiá, màsà quídá‑nsiá na quidá tè‑yùcán. Vàchi nsidaa ana nìhì chuun dandacú nùù‑nsiá, icúmí‑né cunihnu (ndahvi ini‑nè) na iin nèhivì chicá chii; vàchi iin nècuàchì chicá idónuu, xiñuhu cunduu‑ne nahi ana xinúcuáchí. ");
INSERT INTO mitNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Vàchi ni cachí‑ndà iá iin lamú iá xixí, te iá stná iin nècuàchì xinúcuáchí (nùù chuun yuhùnùhú), pues ¿ana chicá idónuu cahan‑nsiá? ¿Amádi lamú mà nduú ana chicá idónuu? Doco cundehè‑nsiá yùhù, nansa quidé xì mii‑nsiá: na ian quidá iin peón xinúcuáchí, ducán nduú modo xi quidé xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Mii‑nsiá nduú nècuàchì iin‑ni sànì tenchicùn xìˊ, te nì yàha stná‑nsià nsidaa tnùndoho nì yàhi. ");
INSERT INTO mitNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ñàyùcàndùá, nacua nì sàha Yué yùhù chuun cusahnúí, ducán nìhìtáhvì stná mii‑nsiá quide, nìhì stná‑nsià chuun dandacú‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Vàchi na sáà quìvì cusahnúí, dandu icúmí stná mii‑nsiá cutnahá‑nsiá xìˊ cundoo‑nda cuxi‑nda nùù mesa xi, te nìhìtáhvì stná‑nsià cundoo iin iin‑nsia silla ndiaha, dandacú‑nsiá nùù ùxìn ùì ñuu‑ndà ndé cundoo nèhivì raza‑ndà Israel. ");
INSERT INTO mitNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Dandu nì cachi Stoho‑ndà Señor xì Simón (Pedro): ―¡Ay, Simón! Nì xìcàn ñà‑malu permisu quida ndevàha‑sì xì anima‑ní na ian quìdà‑ndà na dandiáchí‑ndá nùnì. ");
INSERT INTO mitNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Doco yùhù, nì xìcàn tàhví sàhà‑ní ñà‑màsà nándòdó‑nî yùhù, Simón. Dandu mii‑ní, quìvì sànì sàà‑ní naxicocuíìn inì‑ní, dandu nacuàhandee inì‑ní ñanìtnaha‑ní. ");
INSERT INTO mitNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dandu nì cachi Simón xì‑yá: ―Señor mío, iin‑ni iéˋ dispuestu cunchicuìn mii‑ní mate ni chícádí‑nèndó, te ò ni cahní‑nèndó. ");
INSERT INTO mitNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Doco nì cachi‑yà xì‑né: ―Cachíˋ xì‑ní, Pedro: ñuú vichi na táñâha ga coto lehe sìndùhá, te sànì nacuaà‑ní yùhù ùnì xichi. ");
INSERT INTO mitNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dandu nì cachi stná‑yà xì nsidaa‑né: ―Na ní techuín mii‑nsiá nì xìcanuu‑nsia daa, nì dàndàcuí nùù‑nsiá ñà‑nì ndóo cartera xi‑nsia, xì stná morral xi‑nsia, te ni màsà cúníhí stná‑nsià inga ndìsàn‑nsiá cùhùn. Pues, (vichi cachi‑nsià xìˊ), ¿a ní quidamanì iñàha nùù‑nsiá quìvì yucán? Dandu nì cachi‑nè xì‑yá: ―Còó. ");
INSERT INTO mitNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dandu nì cachi‑yà xì‑né: ―Pues, tucu iá vichi, vàchi xiñuhu‑ñá cunihi‑nsia cartera xi‑nsia na cùhùn‑nsià, te cunihi stná‑nsià morral xi‑nsia cùhùn. Te nècuàchì có‑ìcúmí espada, chicá vàha ni dicó‑né dùhnù‑né, te cuiin‑ne ian. ");
INSERT INTO mitNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Vàchi dohó cacháˋ sàhí nùù tutu ìì: “Nì quida nèhivì cuenta na ian nduú‑yá iin tiàa malu”. Ñàyùcàndùá, yùhù cachíˋ (xì‑nsiá), fuerza icúmí cuu ducán xí, vàchi nsidaa ñà‑ndùá cacháˋ sàhí, icúmíâ cuu ndisa. ");
INSERT INTO mitNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dandu nì cachi‑nè xì‑yá: ―Stoho‑nsì Señor, cundehè‑ní yohó: Ùì espada nihí‑nsí. Dandu nì cachi‑yà xì‑né: ―¡Daaní xì palabra jaàn! ");
INSERT INTO mitNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Daaní, nì quee‑ya vehe, te nacua nduú estilu xi‑ya cuàhàn‑yà Yucù Olivo, te nchícùn stná nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Te na ní sàà‑yà lugar cuní‑yà, dandu nì cachi‑yà xì‑né: ―Càcàn tàhvì‑nsiá nùù Dios sàhà‑ñá màsà dándáhvî ñà‑malu mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dandu nì cuxica tii‑yá chicá nùù‑xí, nacua sáà dacana‑nda iin yùù. Te yucán nì sàcuììn sìsì‑yá nì xìcàn tàhvì‑yá nùù Dios, ");
INSERT INTO mitNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","cachí‑yà: ―Yuamánìˊ, xícàn tàhví nùù‑ní. Nú cuní‑nî, dandu dacúxíó‑nî tnùndoho icúmî yàhi, vàchi nahi (ñà‑úà ñuhú iin) taza, ducán nduá nùí. Doco màdì ñá‑nduá cuní yùhù ni cúndúá; còó, ñà‑ndùá cuní mii‑ní ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dandu nì ndecunu iin ángel nì quixi ansivi, te nì chindee‑né mii‑yá ñà‑nìhì gá‑yà valor xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Vàchi yáha ga nacání ini‑yà. Ñàyùcàndùá chicá fuerte nì càhàn‑yà xì Dios. Te nì cana cuàhà tètnìì‑yá, doco tètnìì mà, na ian cóyo gota nahnú nìì, ducán nì còyo‑tè ñuhù. ");
INSERT INTO mitNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Daaní, nì ndacuiin‑yà vàxi‑ya ndé itánduhù nècuàchì dacuahá‑yá, te nì xini‑yà xíquidì‑nè ñà‑cuàhà guá ndoó‑né tnùnsí ini. ");
INSERT INTO mitNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ñàyùcàndùá, nì cachi‑yà xì‑né: ―¿A ñá‑sànì quìdì‑nsia nduá? Chicá vàha ndacuìta‑nsia, te càcàn tàhvì‑nsiá nùù Dios sàhá màsà dándáhvî ñà‑malu mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na cáhàn ìì‑yá xì nècuàchìmà, dandu nì quesaa cuàhà nèhivì. Te iin tiàa nì sanchicùn xì‑yá nduú ana ndàcà‑xì‑né vàxi, divi Judas, vàchi iin ana nìsa cutnahá xi nsì‑úxìn iin ga nècuàchì dacuahá‑yá nduú‑né. Te divi‑ne nì tnàtuu‑ne nùù‑yá, nì chìtú‑nè nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Dandu nì cachi‑yà xì‑né: ―Judas, ñà‑nì chìtú‑nî nùí, ¿a ducán nduú modo cahín‑nî yùhù ana nduú Tnaha Nèhivì Ñuhìví? ");
INSERT INTO mitNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Dandu compañeru‑yà, nì cundaà ini‑nè nansa cuàhàn cuu, ñàyùcàndùá nì cachi‑nè xì‑yá: ―Stoho‑nsì Señor, ¿a cání‑nsí mii‑né xì espada vichi? ");
INSERT INTO mitNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dandu iin compañeru‑yà, nì cani‑ne espada xi‑ne iin tiàa quidáchúûn nùù dùtù cusáhnû, te nì tàhndè tùtnù‑té ladu cuahá‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Doco nì cachi‑yà: ―¡Daaní xì ñà‑jaàn! Te nì chituu‑ya dìnìndàhá‑yà tùtnù témà, te nì nduvàha dahuan. ");
INSERT INTO mitNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dandu nì càhàn‑yà xì nsidaa nèhivì nì caquesaa tnii xi‑yá, divi dùtù xícusahnú, xì tè‑dàndàcú xíndiaa veheñùhu, xì dava ga stná nècuàchì nihí chuun, te nì cachi‑yà xì nsidaa‑né: ―A ducán nduú modo (tnií‑nsiá yùhù), vàxi‑nsia nihí‑nsiá espada xì garroti na ian tècuìhnà nduí, ");
INSERT INTO mitNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","mate nsìquívì nìsa ìe xì‑nsiá veheñùhu cahnú, te cónì tnìí‑nsiá yùhù. Doco vichi, meru tiempu xi mii‑nsiá nduá, divi tiempu quida quini guá mii‑sí dandacú nùù ichì ñáa. ");
INSERT INTO mitNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dandu nì tnii‑tèyá nì saca‑tèyá cuàhàn‑te ndè ini vehe dùtù cusáhnû. Te Pedro, nchícùn xica ní‑né mii‑yá cuàhàn‑nè, (te nì yàha stná‑nè) ini patiu vehe ma. ");
INSERT INTO mitNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dandu nèhivì ndoó yucán, nì xicùn‑né iin ñuhu mahì patiu mà, te nì sàcùndoo‑ne; te nì sàcòo stná Pedro mahì nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Doco iin ñahà chìì quidáchúûn yucán, nì xinì‑ña Pedro na iá stná‑nè ndé tnúù ñuhu mà, te nì indehè váha‑ñàné, cachí‑ña: ―Nècuàchì yohó, compañeru Jesús nduú stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Doco Pedro, nì nacuaà‑néyà, cachí‑nè: ―Yùhù, có‑ìnáhî Jesús, señorita. ");
INSERT INTO mitNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Daaní, después, indéhe stná inga nèhivì‑né, te nì cachi‑nè: ―¿Amádi iin nèhivì xí Jesús nduú stná mii‑ní? Doco nì cachi Pedro: ―Còó, mà ndìsá, señor. ");
INSERT INTO mitNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Daaní, nì yàha inga hora, te fuerte nì cachi inga nèhivì (xì compañeru‑nè): ―Ñà‑ndáà nduá, nècuàchì yohó nduú iin nèhivì nì cutnahá stná xì Jesús, vàchi nècuàchì ladu Galilea nduú stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Doco Pedro, nì cachi‑nè: ―Señor, ni có‑cùndáà inì ñà‑ndùá cáhàn‑ní sàhà‑xí. Te cáhàn ìì Pedro palabra mà, te momentu mà nì xito lehe. ");
INSERT INTO mitNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dandu Stoho‑ndà Señor, nì nacuico‑yá yàtà‑yá, nì ndacoto‑yanè. Te sàhà ñà‑yùcán nduá nì nsinuu ini‑nè nansa nì cachi‑yà xì‑né daa ñà‑tàñáha ga coto lehe, te ùnì xichi sànì nacuaà‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ñàyùcàndùá, nì quee‑ya iladu patiu mà nì sacu cuahà‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Daaní, tiàa xíndaca xi‑yá, nì sàcùndiaà‑teyá, te nì cani‑tèyá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nì chidàhvi‑tè nùù‑yá, te nì cani‑tèyá, cachí‑te xi‑yá: ―¡Cachi cuàá‑nî ana nì cani xi‑ní! ");
INSERT INTO mitNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te cuàhà gá stná iñàha nì cacachì‑te nì cahíchì uun inì‑teyá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Daaní, na ní tùinuù, nì nataca nsidaa nècuàchì nduú Junta Cahnú; nì cànà nècuàchì sahnú dandacú nùù ñuu yucán, xì stná dùtù xícusahnú, xì stná nècuàchì ley xi veheñùhu. Dandu nì dàtnátuu‑ne Jesús nùù nsidaa‑né, te nì cachi‑nè xì‑yá: ");
INSERT INTO mitNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Nú divi Cristu ndiaha nduu‑ní, dandu cachi ndàà‑ní xì‑nsí. Dandu nì cachi‑yà xì‑né: ―Nú ni cachíˋ xì‑nsiá, mà nunca cunindisá‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Te ò nú ni ndácàtnùhí nùù mii‑nsiá iñàha, ni mà náxícóníhî stná‑nsiá nùí, te ni mà dáñá‑nsiâ yùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Doco yùhù ana nduú Tnaha Nèhivì Ñuhìví, dècuèndè vichi cuàhàn duha icúmî coi ndahà cuahá mii‑yá ana chicá cusáhnû, divi Dios. ");
INSERT INTO mitNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ñàyùcàndùá, nsidaa nècuàchì Junta mà, nì xìcàn tnùhù‑né nùù‑yá, cachí‑nè: ―¿A ndísá Dèhemanì Dios nduu‑ní cahan‑ní? ―Jaan ―cachí‑yà― nacua nì cachi‑nsià, divi ducán nduá. ");
INSERT INTO mitNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ñàyùcàndùá, nì cachi nèhivì Junta mà: ―Có‑xìñùhù gá‑ndà ni‑iin testigu quixi, vàchi divi mii‑né sànì cachi‑nèà, te nì inini‑nda ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dandu nsidaa nècuàchì Junta yucán, nì ndacuìta‑ne, nì saca‑neyà cuàhàn‑nè xì‑yá nùù Pilatu. ");
INSERT INTO mitNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Te cuàhà nì càhàn tnùhu‑ne sàhà‑yá nùù témà, cachí‑nè: ―Nècuàchì yohó, sànì xini‑nsì, dacá‑né dìnì nèhivì ñuu‑nsì yohó, vàchi cachí‑nè mà váha chiyàhvi‑nsi renta xi nación nùù rey cahnú César, vàchi cachí‑nè mii‑né nduú‑né rey Cristu. ");
INSERT INTO mitNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dandu nì ndàcàtnùhù Pilatu nùù‑yá, cachí‑te: ―Mii‑ní, ¿a ndísá rey xi nècuàchì raza Judea nduu‑ní, á coó? Dandu cachí Jesús: ―Nacua cachí‑nî, divi ducán nduá. ");
INSERT INTO mitNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dandu nì cachi Pilatu xì dùtù xícusahnú, xì stná nèhivì cuáhà yucán: ―Sànì càhìn xì nècuàchì yohó, te còò ni‑iin falta ni quidá‑né tuxí. ");
INSERT INTO mitNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Doco nècuàchì cáhàn tnùhu sàhà‑yá mà, vihi gá dana nì càhàn‑nè, cachí‑nè: ―Nècuàchì yohó, cuàhà nèhivì raza‑nsì dacuahá‑né, te danácuîdà‑nè nècuàchìmà dècuèndè ladu Galilea xì ndéˋ stná ladu yohó, nsidanicuú ladu ndé ndoó‑nsí ―nì cacachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na ní inini Pilatu ñà‑jaàn, dandu nì ndàcàtnùhù‑té, ¿a nécuàchì Galilea nduú Jesús, á coó? ");
INSERT INTO mitNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Te divi (ñà‑ndáà nduá). Ñàyùcàndùá, nì cundaà inì‑te ñà‑divi rey Herodes nduú ana ndiá ìcà nsidandaà sàhà chuun ma. Sàháyùcàndùá, nì dàyáha‑tèyá ndahà rey mà, vàchi iá stná tèmà ñuu Jerusalén quìvì yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Daaní, na ní xini rey mà‑yá, nì cudiì gá inì‑te, vàchi sàcàní tiempu cuní‑te cundehè‑téyâ. Vàchi cuàhà gá ñà‑ndùá cachí nèhivì sàhà‑yá, te cuní stná‑te cundehè‑té quida‑ya iin milagru. ");
INSERT INTO mitNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ñàyùcàndùá, cuàhà ní ndàcàtnùhù‑té nùù‑yá, doco còò ni‑iñàha ni náxícóníhî‑yá nùù‑té. ");
INSERT INTO mitNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Te yucán nì casaà stná dùtù xícusahnú, xì nècuàchì ley xi veheñùhu, nì sàcuìta stná‑nè, te yáha ga dana nì càhàn tnùhu‑ne dìquì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Doco Herodes xì soldadu xi‑tè, cuisì‑ní nì dàvádiquì uun‑tèyá, te nì sàcùndiaà‑teyá. Dandu nì chindixi‑tèyá sìcoto vico, te nì dànúhù‑teyá nùù Pilatu. ");
INSERT INTO mitNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Te cunaha‑ní, divi quìvì yucán nì nàcòovàha stnahá Herodes xì Pilatu, vàchi nìsa xini ùhì stnahá‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dandu Pilatu, nì nacana‑tè dùtù xícusahnú, xì nsidaa tè‑nìhí chuun, xì nsidaa gá nèhivì. Te nì nsihi nì catnàtuu nsidaa‑né nùù‑té, ");
INSERT INTO mitNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","dandu nì cachì‑te xi‑né: ―Ndacá‑nsiá nècuàchì yohó vàxi, vàchi cahan‑nsiá dacá‑né dìnì nèhivì ñuù‑nsia yohó. Doco sànì xìcàn tnùhù váhi nùù‑né indéhe nsidaa‑nsiá, te sànì cundaà inì, còò ni‑iin cuàchi‑ne nacua cachí‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Daaní, después nì dàyáhi‑nè ndahà Herodes, te nì sàhàn stná‑nsia nùù nècuàchìmà, doco ni mii stná‑nè, cónì càchí stná‑nè sàhà ñà‑cui Jesús, vàchi còò ni‑iñàha iníhícá‑nê. ");
INSERT INTO mitNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ñàyùcàndùá, cuàhìn dandacuí ñàhnì cuií‑nè, dandu dàñà‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Ducán nì cachi Pilatu), vàchi fuerza icúmí‑tê daña‑té iin nècuàchì ndiadí cada nacává vicò mà. ");
INSERT INTO mitNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Doco nèhivì cuáhà itá yucán, iin‑ni cána fuerte sàstnùhù‑né, cachí‑nè: ―¡Ni cuí Jesús! ¡Barrabás ni dáñà cuní‑nsì! ―nì cachi‑nè, ");
INSERT INTO mitNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","vàchi Barrabás mà nduú iin tiàa nì quida revolución ñuu yucán, te nì sahnì stnàhá‑te, ñàyùcàndùá, ndiadí‑te vehecàa. ");
INSERT INTO mitNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Daaní, tucutu nì càhàn Pilatu xì nèhivì cuáhà mà, fuerte nì càhàn‑te, vàchi dispuestu iá‑te daña‑té Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Doco nèhivì mà, tucutu cána ndee‑né, cachí‑nè: ―¡Ni cuí Jesús nchìca cruz! ¡Ni cuí‑nè, cuní‑nsì! ");
INSERT INTO mitNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Dandu ñà‑únì nì càhàn‑te xi‑né, cachí‑te: ―¿Índù chuun cui‑nè ñà‑còò ni‑iin falta xi‑ne iá? Sànì ndàcàtnùhí nùù‑né, te còò ni‑iñàha dìsáhà‑xí cui‑nè. Ñàyùcàndùá, icúmí‑nê ñàhnì cuìí ni‑ne, te dàñà‑né ―nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Doco nèhivì cuáhà yucán xì stná dùtù cutnáhâ xí‑nê, vihi gá fuerte nì càna ndee‑né, xícàn‑nè ñà‑cui Jesús nchìca cruz. Te ñà‑fuerte guá nì càna‑ne, sàhámà nì cundee‑né (nì dàxínù ini‑nè Pilatu) ñà‑quida‑tè nacua nì cuni mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ñàyùcàndùá, nì daña‑té Barrabás nùù‑né, vàchi divi‑tè nì xìcàn‑nè dàñà, mate iin ana nì quida revolución nduú‑te, te nì sahnì stnàhá‑te, ñàyùcàndùá nì sàcùndiadì‑te. Doco Jesús, còó. Nì dàyáha Pilatu mii‑yá (ndahà soldadu) ñà‑quida temà xì‑yá ñà‑ndùá nì xìcàn nèhivì cuáhà mà. ");
INSERT INTO mitNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dandu nì saca‑tèyá cuàhàn‑te xi‑yá. Te ichì yucán nì xinì‑te vàxi iin nècuàchì ñuu Cirene nani Simón, màndixi‑ne nì sàhàn‑nè nùù ìtú. Te divi nècuàchìmà ní tnii soldadu, te nì dàcuìdá‑tené cruz xi‑ya; ñàyùcàndùá, nsidá‑né cruz cuàhàn‑nè nchícùn‑nèyà. ");
INSERT INTO mitNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Cunaha‑ní, cuàhà gá nècuàchì ñahà nchícùn stná xì‑yá cuàhàn, te cuàhà stná nèhivì dava ga. Te nècuàchì ñahà mà, yáha ga xísacu‑ne, ndoó‑né tnùnsí ini sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dandu nì nacuico‑yá yàtà‑yá, cachí‑yà xì‑né: ―Cunini vàha mii‑nsiá nècuàchì ñahà ñuu Jerusalén. Màsà cuácú‑nsiá sàhà yùhù. Chicá vàha ni cuacú‑nsiá sàhà mii‑nsiá xì sàhà dèhe‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Vàchi vàxi iin tiempu (ùhì) quìvì nùù‑xí, dandu icúmí nèhivì cachi‑nè: “Nansicáhán nèhivì còò méè‑xi. Chicá nsiha màsà cácú ni‑iin dèhe‑nda ni cuí, te màsà cúcúmí‑ndá ni‑iin méè dachichi‑nda chicá vàha”. ");
INSERT INTO mitNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Te icúmí stná‑nè cachi‑nè: “¡A sácú vàha ni caá yucù ò lúnsì dìquì‑ndà, te dàhvi dahuun‑nda!” cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Vàchi (ducán iá nahi ejemplu sàhà tutnù): nú dècuèndè yutnù vida cuní nèhivì (cahmi‑ne), dandu vihi gá mà úhì coco stná tutnù ìchí. (Te ducán stná yùhù: nú dècuèndè yùhù cuní nèhivì dandohó‑né, dandu vihi gá más icúmí nèhivì malu ndoho stná‑nè) ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Cunaha‑nsiá, ndacá stná soldadu mà ùì tiàa nì quida falta, cutnáhâ stná‑te xi‑yá cuàhàn ndé cui stná‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dandu nì casaà nsidaa‑né iin xaan ndé cachí‑nè Nùù Iquì Dìnì. Te yucán nì chituu soldadu mà‑yá nchìca cruz, mii‑yá xì stná ùì tè‑nì quida cuàchi ma, iin‑tè ladu cuahá‑yà, te ingà‑te ladu itní‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dandu nì cachi‑yà: ―Padre mío, cuicahnú inì‑ní sàhà nèhivì yohó, vàchi có‑ìnáhá‑nê ñà‑ndùá quidá‑né. Daaní, tè‑xínduu soldadu mà, nì dasàn‑té sìcoto xi‑ya según nì nìhì iin iin‑tè na ní idàdìquí‑te sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Te indéhe váha nsidaa nèhivì cuáhà mà. Te itá stná nècuàchì nihí chuun, sácùndiaa‑nèyà, cachí‑nè: ―Nècuàchì yohó, nìsa dacácu‑ne nècuàchì dava ga; pues vichi xiñuhu dacácu stná‑nè mii‑né, nú ndisa Dios nì techuun‑xi‑né vàxi, te nú mii‑yá nani Cristu nduú‑né cahan‑né ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Daaní, stná soldadu mà, nì sàcùndiaa stná‑teyá, nì catnàtuu‑tè nùù‑yá chitáníní‑te vinu ia ñà‑coho‑ya, ");
INSERT INTO mitNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","cachí‑te: ―Nú ndisa rey xi nècuàchì raza Judea nduu‑ní, dandu dacácu‑ní mii‑ní ―cachí‑te. ");
INSERT INTO mitNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Te itúú stná iñàha dìnì cruz ndé itándiaa palabra dàhàn griegu, xì dàhàn latín, xì stná dàhàn hebreu, te dohó cacháˋ: “Ana yohó nduú rey xi tè‑raza Judea”. ");
INSERT INTO mitNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Daaní, nì càhàn stná iin tè‑ìtúú stná nchìca cruz yucán, divi iin tè‑nì quida falta mà; te nì canàhá stná‑te xi‑yá, cachí‑te: ―Nú ndisa rey Cristu nduu‑ní, dandu dacácu‑ní mii‑ní, te dacácu stná‑ní nsiùhù. ");
INSERT INTO mitNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Doco inga tè‑ìtúú stná yucán, nì càhàn duchi inì‑te xi compañeru‑tema, cachí‑te: ―¿A có‑yûhî stná‑ní Dios ñà‑iin‑ni castigu sànì nìhì nsidaa‑nda? ");
INSERT INTO mitNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Te ndohó, ndiá ìcà‑ndà ndoho‑nda, vàchi iá ndisa cuàchi‑nda, ñàyùcàndùá iá castigu xi‑nda. Doco Jesús yohó, còó; còò ni‑iñàha iníhícá‑yâ. ");
INSERT INTO mitNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dandu nì cachì‑te xi Jesús: ―Nsinuu inì‑ní yùhù na quìvì naxicocuíìn‑ní cusahnu‑ní ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dandu nì cachi‑yà xì‑té: ―Ñà‑ndáà nduá cachíˋ xì‑ní, quìvì vichi icúmí‑nî cutnaha‑ní xìˊ cundoo‑nda ñuhìví ndiaha xí Dios ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Daaní, nahi càxíhúì nì dàhvi orá, te nì nàcuììn tnùù inicutu ñuhìví, te iin‑ni nì ndòo ducán dècuèndè càhúnì nì cuaà. Te ini veheñùhu cahnú nì quedava cortina cahnú (sadí nihni cuartu yucán). ");
INSERT INTO mitNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dandu Jesús, fuerte nì ndàhì ndee‑yá, cachí‑yà: ―Padre mío, nùù ndahà mii‑ní quidé entregar anímè ―nì cachi‑yà. Dandu nì xìhì‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Daaní, capitán (iín yucán), nì xinì‑te nsidaa ñà‑ndùá nì cuu, te nì ndenihi vàha‑tè Dios, cachí‑te: ―Ñà‑ndáà nduá, nèhivì ndàcuisì inì‑xi nì sanduu nècuàchì yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Te nsidaa gá nèhivì nì sàà yucán, nì xini‑nè nansa nì cuu, dandu nì naquihin‑ne ichì mànuhù‑né vehe‑ne, caní ndáha‑né nchìca‑ne. ");
INSERT INTO mitNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Te yucán ndoó stná cuàhà nècuàchì ñahà nì quixi ñuu Galilea cutnáhâ‑né xì‑yá nì quesaa ñuu Jerusalén. Te mii‑né xì stná nècuàchì dava ga ináhá xí‑yâ, xica itá‑né, indéhe váha‑ne ñà‑ndùá nì cuu. ");
INSERT INTO mitNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Daaní, (ñuu mà) nìsa ìa stná iin tiàa nani José. Iin nècuàchì vàha nduú‑né, vàchi ndàcuisì ini‑nè. Te meru ñuu‑nè nduú iin ñuu tii nani Arimatea ndé ndoó puru nècuàchì raza‑nè Judea. Iin nècuàchì Junta Cahnú nduú stná‑nè, doco mii‑né, cónì ndóo ini‑nè xì ñà‑ndùá nì dàndàcú compañeru‑nè ñà‑cui Jesús, vàchi nihnú ini‑nè (Dios, te xiníndísâ‑né) ñà‑ìcúmí‑yâ cusahnú‑yá ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pues divi nècuàchìmà nì sàhàn nùù Pilatu, nì xìcàn‑nè iquìcúñú Jesús. ");
INSERT INTO mitNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dandu nì sàhàn‑nè nì nanihi‑neyà, nì chidùcún‑nèyà iin dahmà, te nì chinacaa‑nèyà ini cueva xi nsìi nì sate nèhivì nùù cavà. Te cueva mà, ni‑iin nsìi tàñáha ga cundùxin inià. ");
INSERT INTO mitNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Cunaha‑ní, quìvì yucán nì sanduu víspera xi vicò pascua, te sà‑ìtúú cunduu stná quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ñàyùcàndùá, nècuàchì ñahà nì quixi Galilea mà, nì catenchicùn stná‑nè nì sàhàn ndé nì sàcùndùxin‑ya, te nì xini‑nè lugar mà, xì nansa nì sàcùnacaa cuerpu‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dandu mànuhù‑né, nì quidayucun‑nè tàtnà tnàmì xì pomada sahán tnami. Daaní, quìvì descansu mà nì quetatu‑nè nacua cachí ley (xi‑ne). ");
INSERT INTO mitNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Naha va quìvì primeru semana nì quihin nècuàchì ñahà mà ichì cuàhàn‑nè ndé nì ndùxin‑ya, nihí‑né tàtnà tnàmì nì quidayucun‑nè, te cutnáhâ stná‑nè xì itnii gá nècuàchì ñahà. Te na ní casaà‑nè yucán ");
INSERT INTO mitNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","nì xini‑nè sànì cuxio cavà cahnú nì sandiadi yuhù cueva mà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dandu nì caquìhvi‑ne inì‑xi, doco còò cá Stoho‑ndà Jesús nì xìní‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ñàyùcàndùá, cuàhà gá nì ndulocó‑nè. Dandu nì xini‑nè yatni uun yucán nì sàcuìta ùì ana ndixín sìcoto cuxín yéhè. ");
INSERT INTO mitNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Te nì cayùhí cuaá‑nè, te nì nàcùnihni ndee‑ne. Dandu nì cachi ángel mà xì‑né: ―Còò necesidad nanducu‑nsiá mii‑yá yohó ndé nduú lugar xi nsìi, vàchi sà‑ìtiácú‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Còò cá‑yà yohó, vàchi sànì natiacu‑yà. ¿A có‑nsìnúú inì‑nsia ñà‑ndùá nì cachi‑yà na iá va‑ya xì‑nsiá ladu Galilea? ");
INSERT INTO mitNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Vàchi dohó nì cachi‑yà: “Yùhù ana nduú Tnaha Nèhivì Ñuhìví, icúmî yàhi ndahà tè‑malu, dandu cachituu‑tè yùhù nchìca cruz; doco tìxi ùnì quìvì icúmî natiacuì”, nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dandu nècuàchì ñahà mà, nì nsinuu ini‑nè ñà‑dùcán ndisa nì cachi‑yà xì‑né daa. ");
INSERT INTO mitNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Dandu nì caquee‑ne cueva mà mànuhù‑né ndé ndoó‑né, te nì nacani‑ne nsidaámà xì ùxìn iin nèhivì xí‑yá, xì stná nècuàchì dava ga. ");
INSERT INTO mitNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Cunaha‑ní, nècuàchì ñahà mànuhù cachitnùhu xi nèhivì mà nduú María Magdalena, xì Juana, xì María dihi Jacobo, xì itnii gá stná nècuàchì ñahà dava ga. ");
INSERT INTO mitNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Doco nècuàchì tiàa (nì inini ma), nì tuxi ini‑nè ádi cuentu uun nduá nì nacani nècuàchì ñahà mà. Ñàyùcàndùá, cónì xìníndísâ‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Doco Pedro, después nì ndacuiin‑nè nì dàyáà‑nè cuàhàn‑nè sepultura mà. Te (na ní sàà‑nè) nì xito nihni‑ne inià nì xini‑nè mii dahmà nì ndòo itánduhù iladú. Dandu mànuhù‑né vehe‑ne, nacání cuáhà ini‑nè ndíà ndùá nì cuu cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Daaní, divi quìvì yucán cuàhàn ùì nèhivì xí‑yá ichì ñuu Emaús. Nahi ùì hora nduá caca‑nda ndè ñuu Jerusalén xì ndéˋ ñuu tii yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Te ùì nècuàchìmà, ndatnúhú‑nê cuàhàn‑nè, cáhàn‑nè sàhà nsidaa ñà‑ndùá làcà ní cuu. ");
INSERT INTO mitNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Te meru ndatnúhú‑nê ducán, te nì cuyatni Jesús vàxi‑ya; nì tnàtuu‑ya nì sacatnahá‑yá xì‑né cuàhàn. ");
INSERT INTO mitNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Doco cónì nácóó‑yá mii‑né nacuni‑nèyà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Dandu nì cachi‑yà xì‑né: ―¿Ndíà ndùá ndatnúhú guá‑nsià cuàhàn‑nsià, te ndoó‑nsiá tnùnsí ini? ");
INSERT INTO mitNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dandu nì naxiconihí iin nècuàchìmà nani Cleofas, nì cachi‑nè xì‑yá: ―Nsidaa gá nèhivì ndoó ñuu Jerusalén, ináhá‑nê ñà‑ndùá nì cuu yucán quìvì vichi. Ádi cuisì mii‑ní nduú ana tàcùnítnùhu sàhámà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Dandu nì cachi‑yà: ―¿Ndíà ndùá nì cuu yucán? Te nì cachi‑nè: ―Cáhàn‑nsì sàhà Jesús de Nazaret, vàchi cunaha‑ní, iin ana cáhàn ndisa cuenta xi Dios nì sanduu‑ya. Cuàhà milagru fuerte nì quida‑ya, te cuàhà palabra ndiaha nì chinaha‑yà. Chuun ndiaha xí Dios nìsa quida‑ya nì cundaà ini nsidaa nèhivì ñuu‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Doco dùtù xícusahnú, xì stná tè‑nìhí chuun ga, nì dàyáha‑neyà ndahà ana nì sahnì xì‑yá, te nì chituu‑tèyá nchìca cruz. ");
INSERT INTO mitNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Doco cunaha‑ní, mii‑yá nduú ana cuàhàn dacácu xi ñuu‑ndà Israel nì cahan‑nsí. Te vichi sàcuàhàn‑ndà ùnì quìvì nì cuu xi‑yá ducán. ");
INSERT INTO mitNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Te quìvì vichi nì sàà itnii nècuàchì ñahà iin‑ni xiníndísâ stná xì‑yá, te nì ndulocó‑nsì nì quida‑ne, vàchi naha nì sàhàn‑nè sepultura (xi‑ya), te còò gá iquìcúñú‑yà nì xìní‑nè, cachí‑nè. Te nì ndecoyo stná ángel nùù‑né, te cachí ángel mà sànì natiacu‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Daaní, nì sàhàn stná dava compañeru‑nsì sepultura mà, te nacua nì nacani nècuàchì ñahà mà, divi ducán nì xini stná‑nè ñà‑còò gá iquìcúñú‑yà yucán. ");
INSERT INTO mitNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dandu nì cachi‑yà xì nècuàchìmà: ―¡Ndahví‑nsià! Mà túha‑nsia mànìhì inì‑nsia; cueé sàstnùhù‑nsiá cunindisá‑nsiá nsidaa ñà‑ndùá nì tiaa nècuàchì nì càhàn cuenta xi Dios sànaha. ");
INSERT INTO mitNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Vàchi (claru nì cachitnùhu‑ne sàhà) ana nduú Cristu, xì nansa icúmí‑yâ ndoho‑ya, dandu después nanihì‑yá tnùñuhu ndiaha xí‑yá ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dandu nì quesaha‑yá nì dàtúi‑ya nùù‑né nansa cachí tutu ìì sàhà mii‑yá, divi tutu nì tiaa Moisés, xì stná tutu nì tiaa nsidaa gá nècuàchì profeta. ");
INSERT INTO mitNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Doco vichi, sà‑ìtúú sàà‑nè xì‑yá ñuu tii ndé cuàhàn‑nè. Dandu nì cundaà ini‑nè cuní‑yà cùhùn‑yà chicá nùù‑xí. ");
INSERT INTO mitNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ñàyùcàndùá, nì sacundahví‑nè nùù‑yá, cachí‑nè: ―Yohó ndòo‑ní, chicá vàha, vàchi sànì cuaà, te cuàhàn cuñaà. Dandu nì yàha nsidaa‑né ini iin vehe ñà‑cutnahá chii gá‑yà xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Te nì sàcòo‑ya nùù iin mesa ñà‑cuxi‑ya xì‑né. Te nì tnii‑ya pan, nì naquimanì‑yá Dios sàhá, te nì dàcuàchí‑yáñà; dandu nì dasàn‑yáñà nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Te momentu jaàn nì nìhì‑né nì nacuni‑nèyà ana nduú‑yá. Doco na íín cachí nì ndañuhu‑yá nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Dandu nì cachi‑nè iin‑ne xì inga‑nè: ―¡Na ndiaha guá nihnú ini‑ndà na ní càhàn‑yà xì‑ndà vàxi‑nda ichì mà, te nì dàtúi‑ya nùù‑ndà nansa cuní cachi tutu ìì! ");
INSERT INTO mitNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dandu vichi duha nì ndacuìta‑ne mànuhù‑né ñuu Jerusalén, nì nasaa‑nè vehe ndé sànì nataca ùxìn iin nècuàchì dacuahá‑yá xì stná compañeru gà‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Te nsidaa nècuàchìmà, nì cachitnùhu‑ne xì nècuàchì làcà nì cansiaa mà, cachí‑nè: ―Ñà‑ndáà nduá, sànì natiacu Stoho‑ndà Señor, vàchi sànì xini Simón‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dandu nècuàchì nì cansiaa mà, nì nacani stná‑nè xì nècuàchì yucán nansa nì cuu xi‑né na cuáhàn‑nè ichì yucán, te después nì nacuni‑nèyà na ní dàcuàchí‑yá pan (cuàhàn‑nè cuxi‑ne). ");
INSERT INTO mitNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Daaní, nacání vá nècuàchìmà ñà‑jaàn, te nanàá nì sàcuììn Jesús dava mahì‑xí. Te nì cachi‑yà xì‑né: ―¡Ni ndóo vàha ini nsidaa‑nsiá! ");
INSERT INTO mitNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Doco mii‑né, nì cayùhí cuaá‑nè; yáha ga nì ndulocó‑nè, vàchi ádi duma nduá nì cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ñàyùcàndùá, nì cachi‑yà xì‑né: ―¿Índù chuun yúhî guá‑nsià? ¿Índù chuun nacání guá inì‑nsia? ");
INSERT INTO mitNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cundehè‑nsiá ndahí xì sàhí, dandu cundaà inì‑nsia divi yùhù nduí. Tnii ndahà‑nsiá yùhù, te cundaà inì‑nsia màdì ihna nduí, vàchi ihna, còò iquìcúñúà, doco yùhù, iá iquìcúñúì sà‑ìndéhe‑nsiá ");
INSERT INTO mitNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","―nì cachi‑yà. Dandu nì dàcùní‑yànè ndahà‑yá, xì sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Doco có‑xìníndísâ ndisa‑ne ñà‑cuàhà guá cudíì ini‑nè, te ndulócô‑nè. Ñàyùcàndùá, nì cachi‑yà xì‑né: ―¿Á coo iyuhu ñà‑cuxi‑nda yohó? ");
INSERT INTO mitNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dandu nì sàha‑neyà iyuhu cuñu siaca nì chòhò, xì stná iin dahnde ñùñù. ");
INSERT INTO mitNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ñàyùcàndùá, nì tnii‑yañà nì xixi‑ya nì sandehè nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dandu, nì cachi‑yà xì‑né: ―Ñà‑yòhó nduá nì cachì xì‑nsiá na nísa ìe xì‑nsiá antes, te nì cachì xì‑nsiá ñà‑fuerza icúmí cuu ndisa nsidaa ñà‑ndùá cacháˋ sàhí nùù ley xi Moisés xì nùù tutu nduú alabanza, xì nùù stná tutu nì tiaa nècuàchì profeta; nsidaámà, fuerza nì cuu ndisa, ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dandu nì dàtúi‑ya nùù nsidaa‑né nansa cuní cachi tutu ìì, te nì sàà‑nè nì cundaà ini‑nè nì quida‑ya. ");
INSERT INTO mitNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Dandu nì cachi stná‑yà xì‑né: ―Nacua nì cachì xì‑nsiá, ducán nìsa ìa destinadu cuu xi (yùhù ana nduú) Cristu, vàchi ducán nì cachitnùhu tutu ìì ñà‑ìcúmî ndohi, te cuì, dandu tìxi ùnì quìvì natiacuì. ");
INSERT INTO mitNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Te nì cachitnùhu stná tutu mà ñà‑después cuìtià razón ndiaha ma inicutu ñuhìví, vàchi icúmí‑nsiâ cùhùn‑nsià càhàn‑nsià sàhí xì nsidaa nèhivì ñà‑ndìá ìcà‑né naxicocuíìn ini‑nè sàhà cuàchi‑ne, dandu cuicahnú ini xì sàhà‑né. Te ñuu primeru ndé càhàn‑nsià razón mà nduú ñuu Jerusalén yohó. ");
INSERT INTO mitNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Te vichi sànì xinì‑nsia nsidaa ñà‑ndùá nì cuu (tiempu vichi), ñàyùcàndùá testigu xínduu‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cunaha‑nsiá, sànì quida Yuamánìˊ comprometer quixi iin ana (chindee) xi‑nsiá. Te yùhù cuàhìn techuín yàmà quixi coo‑ya ini anima‑nsià. Ñàyùcàndùá, yohó ni cúndóó‑nsiá ñuu Jerusalén dècuèndè cachi sànì cundiatú‑nsià ndudu ìì vàxi ansivi ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Daaní, nì saca‑yanè cuàhàn‑yà xì‑né (fuera) ñuu Jerusalén dècuèndè ñuu tii Betania. Dandu nì chitanini ducún‑yà ndahà‑yá, te nì xìcàn‑yà ni quidá Dios gracia sàhà nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Te meru xícàn tàhvì‑yá nùù Dios ducán, dandu nì ndanchito‑ya mànana‑ya mànuhù‑yá gloria. ");
INSERT INTO mitNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ñàyùcàndùá nì sàcuìta sisi nsidaa‑né nì naquimanì ndiaha‑néyà. Dandu nì quihin tu‑ne ichì mànuhù‑né ñuu Jerusalén, cudíì gá ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Te nsìquívì nìsa sahàn‑nè veheñùhu cahnú, ndoó‑né ndeníhí vàha cuahà‑né Dios, te naquímánì stná‑nèyà. Sà‑ìá.");
INSERT INTO mitNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na táyôo ñuhìví, sà‑ìá mii‑yá ana datúi nansa nihnú ini Dios. Nùù Yua‑nda Dios iá‑yà, te mii stná‑yà nduú stná‑yà Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Te divi‑ya iá nùù Yua‑nda Dios na táyôo ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mii‑yá nì quidayucun‑yà nsidanicuú iñàha iá ñuhìví. Te nú màsà cóó‑yá, ni‑iñàha mà cóó stná ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sàhà mii‑yá xí‑itiacu nsidaa ana itiácú. Te sàhà ñà‑ìtiácú ndiaha‑yá, ñà‑jaàn sànì sàà‑yà datnúù ini‑yà nèhivì ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Cunaha‑nsiá, ichì ñáa nduá ñuhìví yohó, doco iin‑ni datnúù ndiaha‑yá ini anima‑ndà; te nsidaa ñà‑ìá ichì ñáa ma, cónì cùí cundeá nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nìsa ìa iin tiàa nì nìhì chuun nùù Dios; Juan nani‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Te nì quixi‑ne nì cachi‑nè ñà‑ndácuisì xì nèhivì nansa iá mii‑yá ana datnúù xì sàxìnítnùní‑ndà sàhà‑ñá vàtùni cunindisá nsidaa‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Màdì Juan yucán nì sándúú ana datnúù ndiaha xi ini‑ndà, còó; cuisì nì quixi‑ne ñà‑cachitnùhu uun‑ne nansa iá mii‑yá quìdà‑xì ñà‑jaàn, ");
INSERT INTO mitNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","vàchi ndisa sàvàxi mii‑yá ana datnúù ndiaha xi ini anima nsidaa nèhivì, te mà dándáhvî‑yàndó. ");
INSERT INTO mitNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nì ìa‑ya ñuhìví, divi ñuhìví nì quidayucun‑yà, doco cónì nácúní nèhivì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Stoho ñuhìví nduú‑yá, te nì quixi‑ya yohó, doco nèhivì ñuhìví xi‑ya, nì cahíchì ini‑nèyà. ");
INSERT INTO mitNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Doco nsidaa ana nì dàyáha xi‑yá ini anima‑xi, nì nìhìtáhvì‑né cunduu‑ne dèhe ndisa‑ya, te divi nduú nsidaa ndohó nècuàchì xiníndísá‑xí‑yâ, te ndácùcahan xi quìvì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Te ¿nansa nì nìhì‑ndà nì sàcùnduu ndisa‑nda dèhe‑ya? Pues màdì sàhà‑ñá nduu‑nda descendencia xi iin nèhivì (chica ndiaá), ni màdì sàhà yua‑nda, ni sàhà stná ñà‑dùcán cuní iin nèhivì coo. Còó, sàhà cuisì‑ña ducán cuní Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ndè ñuhìví yohó nì quixi mii‑yá ana datúi nansa iá Dios, te nì nduvàha‑ya iin nèhivì iá iquìcúñù‑xi. Te nìsa ìa chii‑yá yohó ndé ndoo‑nda. Te nsiùhù, nì xini‑nsì ñà‑ndiaha guá iá‑yà. Ndiaha gá‑yà, cachíˋ, vàchi mindaa Dèhemanì Yua‑nda Dios nduú‑yá, te chitu‑yá gracia xì stná palabra ndàcuisì. ");
INSERT INTO mitNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Daaní, nì càhàn Juan mà sàhà Jesús, nì ndàhì‑nè, cachí‑nè (xì nèhivì): ―Divi mii‑yá nduú ana dìsáhà‑xí nì càhìn xì‑nsiá daa, te nì cachì, dihna yàha yùhù, dandu después vàxi mii‑yá ana chicá ndiaá nùí, vàchi na táyôo yùhù, sà‑ìá mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Chitu‑yá cuàhà gá ñà‑ndiaha íì ñuhú ini‑yà, ñàyùcàndùá nùù mii‑yá sànì nìhìtáhvì stná‑ndà cuàhà ñà‑jaàn, cuàhà sàstnùhù gracia. ");
INSERT INTO mitNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Vàchi ley sànaha nduá nì dàtúi Moisés antes, doco vichi sànì dàtúi‑ya ñà‑ndùú gracia ndiaha xí‑yá xì stná palabra ndàcuisì xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Còò ni‑iin nèhivì nì xìní xì Yua‑nda Dios ni‑iin xichi. Doco mindaa Dèhemanì‑yá iá nùù‑yá, sànì dàtúi yà‑yùcán nansa iá Yuamánì‑yá sàhà‑ñá cundaà ini‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Daaní, nècuàchì raza Judea ndoó ñuu Jerusalén, nì techuún‑né iin ùì dùtù xi‑ne nùù Juan, te cutnáhâ stná‑nè xì dava nècuàchì (xinúcuáchí veheñùhu nani) Levita. Te nì xìcàn tnùhù‑né nùù nècuàchìmà ana divi nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ñàyùcàndùá, ñà‑yòhó ndùá nì cachi Juan; cónì càchí‑nè á coó; nì cachi ndàà‑nè: ―Yùhù, có‑ndùí mii‑yá nani Cristu. ");
INSERT INTO mitNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dandu nì cacachi nècuàchìmà: ―(Pues nú coó), ¿ana divi nduu‑ní? ¿A nsì‑Elías nduu‑ní? Te nì cachi Juan: ―Còó. Te nì cacachi tu nècuàchìmà: ―Entonces, ¿a divi nduu‑ní mii‑yá ana icúmí quixi canúú càhàn cuenta xi Dios? ―Còó ―cachí Juan. ");
INSERT INTO mitNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ñàyùcàndùá, nì cachi nècuàchìmà: ―Pues, ¿ana divi nduu‑ní? vàchi icúmí‑nsî cachitnùhu‑nsi xì nèhivì nì catechuun‑xi‑nsí vàxi‑nsi. ¿Ndíà cachí‑nî sàhà mii‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dandu nì cachi Juan: ―Yùhù nduí ana cáhàn fuerte sàhù yucù, (te cachíˋ xì nèhivì ñà‑nsidaviì‑né anima‑nè) na ian ndundaà iin ichì ndé yàha Stoho‑ndà Señor nacua nì cachitnùhu Isaías sànaha na ní càhàn‑nè cuenta xi Dios ―ni cachi Juan. ");
INSERT INTO mitNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Cunaha‑nsiá, nècuàchì nì casaà nùù Juan mà, nècuàchì fariseu xínduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Dandu nì xìcàn tnùhù gá‑nè, cachí‑nè: ―Vichi, ¿índù chuun quidá íì‑ní nèhivì nú có‑ndùù‑ní mii‑yá nani Cristu, te có‑ndùù stná‑ní nsì‑Elías, te ni có‑ndùú stná‑ní mii‑yá icúmí quixi càhàn cuenta xi Dios? ");
INSERT INTO mitNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Dandu nì cachi Juan xì‑né: ―Yùhù, ndisa, quidá íìˊ nèhivì xì tècuìí. Doco mahì mii‑nsiá iá iin ana có‑nàcúní‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Te mii‑yá, nchícùn gà vàxi‑ya nùí, te chicá ndiaá stná‑yà nùí. Ni mà nátùi (cundui iin mozo xi‑ya) ñà‑tavà xì ndìsàn‑yá ―nì cachi Juan. ");
INSERT INTO mitNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Cunaha‑nsiá, ndé iá ñuu tii Betábara ladu duha yùte Jordán, yucán nì cuu nsidaa ñà‑yòhó. ");
INSERT INTO mitNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Daaní, nì yàha inga quìvì, dandu nì xini Juan vàxi Jesús, te nì cachi‑nè: ―Cundehè‑nsiá, jaàn vàxi mii‑yá ana nduú nahi Lelù Íì nì sàhatahvì Dios (ñà‑cui‑yà) dacúxíó‑yá cuàchi nèhivì ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sàhà mii‑yá nì càhìn daa na ní cachì: nchícùn gà vàxi‑ya nùí, vàchi na táyôo yùhù ñuhìví, sà‑ìá‑yà, vàchi nicanicuahàn iá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Te cónì nácúnì mii‑yá antes, doco sàhà‑ñá cundaà ini raza‑ndà Israel ana divi nduú‑yá, sàhájàn nì nìhí chuun quida iìˊ nèhivì xì tècuìí ―nì cachi Juan. ");
INSERT INTO mitNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Daaní, nì cachi tu‑ne inga palabra yohó: ―Yùhù, nì xinì nì nuu Espíritu Ìì xí Dios; nahi loma náhà‑yà mànuu‑ya ansivi nì sàcòo‑ya dìnì Jesús, te nì ndòo‑ya yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yùhù, cónì nácúnì mii‑yá antes. Doco na ní sàha Yua‑nda Dios yùhù chuun quida iìˊ nèhivì, dandu nì cachi stná‑yà xìˊ: “Na cúnì‑ní nuu Espíritu Ìì màcòo‑ya dìnì iin (ana cuhíì), dandu ñà‑jaàn cundaà inì‑ní divi nduú mii‑yá cuàhàn nsida iì xì anima nèhivì tìxi Espíritu Ìì”. ");
INSERT INTO mitNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ñàyùcàndùá, yùhù, sànì xinì, te datúi nùù‑nsiá ñà‑divi Dèhemanì Dios nduú Jesús ―nì cachi Juan. ");
INSERT INTO mitNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Daaní, nì yàha inga quìvì, te yucán iín Juan, cutnáhâ‑né xì ùì tiàa dacuahá‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Te nì xini‑nè yatni yáha Jesús, ñàyùcàndùá nì cachi‑nè: ―Cundehè‑nsiá, jaàn cuàhàn mii‑yá ana nduú Lelù Íì vàxi nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Te ùì tiàa dacuaha‑ma, nì tiacu‑nè nì càhàn Juan ducán, te nì tenchicùn‑nè Jesús cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Dandu nì ndacoto‑ya, te nì xini‑yà xínchicùn nècuàchìmà. Ñàyùcàndùá nì cachi‑yà xì‑né: ―¿Ndíà nduá nandúcú‑nsiâ? Dandu nì cachi‑nè xì‑yá: ―Maestro, ¿índù iá‑nî? ");
INSERT INTO mitNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","―Nahà‑nsia, cundehè‑nsiá ―nì cachi‑yà xì‑né. Ñàyùcàndùá, cuàhàn‑nè xì‑yá, te nì xini‑nè índù iá‑yà. Te nì ndòo‑ne xì‑yá sàcuaà yucán, vàchi nahi càcúmì nì cuaà nduá. ");
INSERT INTO mitNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Iin tiàa nani Andrés nduú iin ana nì inini na ní càhàn Juan daa, te nì tenchicùn stná‑nè Jesús. Dandu vichi duha nì sàhàn stná‑nè nì nanducu‑né ñani‑nè nani Simón Pedro, te nì cachi‑nè xì nècuàchìmà: ―Sànì ndacùhun stnahá‑nsí xì mii‑yá nduú Mesías. Quìvì Mesías nì cachi Andrés dàhàn mii‑né, vàchi cuní cachàmà Cristu (nì quixi dìquì‑xí). ");
INSERT INTO mitNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dandu nì saca‑ne ñani‑nè nì casaà‑nè ndé iá‑yà. Te na ní xini‑yà Simón mà, dandu nì cachi‑yà xì‑né: ―Dèhe Jonás nduu‑ní, te nani‑ní Simón, doco yùhù cuàhìn cachì xì‑ní Cefas ―nì cachi‑yà. Te quìvì Cefas mà, Pedro cuní cachà. ");
INSERT INTO mitNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Daaní, nì yàha inga quìvì, te cuní Jesús nùhù‑yà ladu Galilea. Te nì ndacùhun tnahá‑yá xì iin tiàa nani Felipe, te nì cachi‑yà xì‑né: ―Cunchicùn‑ní yùhù nùhù‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Cunaha‑nsiá, ñuu Felipe mà nduú ñuu Betsaida, divi ñuu Andrés xì Pedro. ");
INSERT INTO mitNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ñàyùcàndùá nì nanducu Felipe iin tiàa nani Natanael, te nì cachi‑nè xì nècuàchìmà: ―Cunaha‑ní, sànì ndacùhun tnahá‑nsí xì mii‑yá nì tiaa Moisés sàhà‑xí nùù ley ìì, te divi sàhà stná‑yà nì tiaa stná cuàhà profeta nì càhàn cuenta xi Dios sànaha. Jesús de Nazaret nani‑yá, te yua‑yá nani José. ");
INSERT INTO mitNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Dandu nì cachi Natanael: ―¿A ndísá? ¿A iá iin nèhivì vàha ñuu Nazaret? Dandu nì cachi Felipe: ―Nahà‑ní cundehè‑ní. (Dandu cuàhàn‑nè xì nècuàchìmà.) ");
INSERT INTO mitNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Te na ní xini Jesús vàxi Natanael, dandu nì cachi‑yà sàhà‑né: ―Yohó vàxi iin tiàa quidá ndisa nacua ndiá ìcà quida nècuàchì raza‑ndà Israel, te ni‑iyuhu mà túha‑ne dandahví‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dandu nì cachi Natanael xì‑yá: ―¿Nansa ináhá‑nî yùhù? Te nì cachi Jesús xì‑né: ―Na táñâha ga cana Felipe mii‑ní, te iá‑nî sàhà iin nù‑higu, dandu nì xinitùí mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dandu nì cachi Natanael xì‑yá: ―Dèhemanì Dios nduu‑ní, Maestro, divi rey icúmí cusáhnû nùù ñuu‑ndà Israel nduu‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Dandu nì cachi Jesús xì‑né: ―Mà úhì guá nì xinindisa‑ní na ní cachì nì xinitùí mii‑ní sàhà yutnù yucán. Cunaha‑ní, icúmí‑nî cunì‑ní milagru chicá ndiaha. ");
INSERT INTO mitNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ñà‑ndácuisì nduá cachíˋ xì‑ní, icúmí‑nî cunì‑ní nuna ansivi, dandu quecoyo ángel xi Dios mànana mànuu cucuu‑ne dìquì‑xí ndé iín yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Daaní, quìvì ùnì nì ìa iin vicò nandàhà ñuu tii Caná iá ladu Galilea. Te yucán nì sàà stná dihi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Te nì cànà stná mii‑yá xì nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te nì cuu nì nsihi tècuìí vìdì sì‑uva coho‑ne. Ñàyùcàndùá, nì càhàn dihi‑yá xì‑yá, cachí‑nè: ―Sànì nsihi tècuìí vìdì sì‑uva. ");
INSERT INTO mitNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Dandu nì cachi‑yà xì‑né: ―Chicá vàha nacoo‑ní ñà‑jaàn nùù yùhù, vàchi tàñáha ga sàà meru hora xi. ");
INSERT INTO mitNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dandu nì càhàn dihi‑yá xì tiàa xinúcuáchí yucán, cachí‑nè: ―Quida‑nsia nacua cachí dèhi xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Cunaha‑nsiá, yucán itá ìñù barril yùù, iin ian vàtùni cuñuhu cùmì ò úhùn yoo tècuìí. Tècuìí mà xichúûn nècuàchì raza Judea ñà‑nsidandoo‑ne mii‑né según estilu nduú ley xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Te nì cachi Jesús xì tiàa yucán: ―Dachitu‑nsiá barril jaàn tècuìí. Ñàyùcàndùá, ducán nì caquida‑tè, dècuèndè yuhá nì chitu. ");
INSERT INTO mitNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Dandu nì cachi‑yà xì‑té: ―Vichi chitacùhá‑nsià chii‑té cunihi‑nsia cùhùn nùù nècuàchì iín sáhnû nùù vicò. Ñàyùcàndùá, ducán nì caquida‑tè. ");
INSERT INTO mitNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Te nì xihi nècuàchìmà iyuhu tècuìí mà, doco sànì nanduu‑tè tècuìí vìdì sì‑uva. Te cónì sáha‑ne cuenta índù nì quixi ndutè mà, doco tè‑xìnúcuáchí nì catavà xì‑té, ináhá‑tê. Daaní, na ní cundaà ini‑nè nansa xihí ndutè mà, dandu nì cana‑ne noviu nándàhà, ");
INSERT INTO mitNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","te nì cachi‑nè xì nècuàchìmà: ―Nsidaa nèhivì, na sáha‑ne tècuìí vìdì sì‑uva coho‑nda, dihna sáha‑ne ndutè chicá vàha, dandu nú sànì xihi cuahà‑ndàté, dandu tavá‑né ndutè chicá ndahví. Doco mii‑ní, còó, làcà vichi nì tavà‑ní ndutè chicá finu ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ñà‑jaàn nduú milagru primeru nì quida Jesús. Te ñuu Caná iá ladu Galilea nduú lugar ndé nì quida‑yañà. Ducán nduú nì dàcùní‑yà nèhivì ñà‑ndiaha guá quidá‑yá, te nì xinindisá stná nècuàchì dacuahá‑yá mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Daaní, nì sàhàn Jesús ñuu Capernaum, mii‑yá xì dihi‑yá xì ñani‑yà, xì stná nècuàchì dacuahá‑yá. Te yucán nì cuee‑yà iin ùì quìvì. ");
INSERT INTO mitNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Dandu nì quihin tu‑ya ichì cuàhàn‑yà ñuu cahnú Jerusalén, vàchi sà‑ìtúú vicò pascua, iin vicò nsidácáhnû nècuàchì raza Judea yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","(Ñàyùcàndùá, nì sàà‑yà ñuu mà), te nì xini‑yà yucán yehè veheñùhu cahnú itá nèhivì dicó; dicó‑né buey, dicó‑né riì, dicó‑né loma, te ndoó stná nèhivì nadámá tnahá xi dìhùn (vàxi inga ñuu). ");
INSERT INTO mitNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dandu nì cava‑yà itnii yohò nì quidayucun‑yà iin chirrión, te nì taxi nsihí‑yánè yehè veheñùhuma, mii‑né xì riì xí‑né xì stná buey xi‑ne. Te nì dàndiàchì‑yá dìhùn damá‑né, te nì ducùn nsìhí‑yá mesa xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Te nì cachi stná‑yà xì nècuàchì dicó xi loma mà: ―¡Tavà‑nsiá quisì yohó fuera! vàchi màdì yàhvi nduú vehe ìì Yuamánìˊ ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dandu nì nsinuu ini nècuàchì dacuahá‑yá nansa cachí nùù tutu ìì ndé cacháˋ: “Yáha ga cuàhà nacání ínì sàhà veheñùhu ìì xí‑nî ñà‑màsà dándâñúhú nèhivì ñà‑ìì icúmíâ”. ");
INSERT INTO mitNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Dandu nècuàchì raza‑yà Judea yucán, nì cachi‑nè xì‑yá: ―Quida‑ní iin milagru cunduu seña ñà‑cundaà ini‑nsì a icúmí‑nî derechu quida‑ní ñà‑ndùá nì quida‑ní, á coó. ");
INSERT INTO mitNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Dandu nì cachi‑yà xì‑né: ―Vàtùni. Ducùn‑nsiá veheñùhu yohó, te tìxi ùnì quìvì nsida saí‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dandu nì cachi nècuàchì yucán: ―Ùì dico ìñù cuìà nì quidachuún nèhivì nì dàxínu‑ne veheñùhu yohó. Te mii‑ní, ¿a ndísá daxínu‑níà tìxi ùnì quìvì? ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Doco màdì veheñùhu ndisa nduá cáhàn‑yà sàhà‑xí; còó, vàchi ejemplu‑ni nduámà; divi cuerpu mii‑yá cáhàn‑yà sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ñàyùcàndùá, después, na quívì sànì natiacu‑yà, dandu nì nsinuu ini nècuàchì nchícùn xì‑yá ñà‑dùcán nì cachi‑yà xì‑né daa, te nì sàà‑nè nì xinindisá‑né ñà‑ndùá cachí nùù tutu ìì, te nì xinindisá stná‑nè ñà‑ndùá nì cachi mii‑yá daa. ");
INSERT INTO mitNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Cuàhà nèhivì nì xinindisa‑xi‑yá na ní xini‑nè milagru nì quida‑ya na iá‑yà ñuu Jerusalén quìvì vicò pascua ma. ");
INSERT INTO mitNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Doco mii‑yá, cónì ícúmí‑yâ nècuàchìmà seguru, vàchi ináhá‑yâ ñà‑ñùhú ini anima nsidanicuú‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Còò necesidad icúmí‑yâ cachi iin nèhivì xì‑yá nansa iá anima ñanìtnaha‑ne, vàchi ináhá‑yâ nsidaa ñà‑ndùá ñuhú ini anima nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nìsa ìa iin nècuàchì fariseu nani Nicodemo. Iin nècuàchì xídandacú nùù ladu Judea mà nduú stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Te divi‑ne nì sàhàn ndé iá Jesús iin sàñaà, te nì cachi‑nè xì‑yá: ―Maestro, ináhá‑nsî divi mandu xi Dios vàxi‑ní, vàchi nú màsà chíndéé Dios, dandu ni‑iin nèhivì, mà níhì‑né quida‑ne milagru nacua quidá mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dandu nì cachi Jesús xì‑né: ―Palabra ndàcuisì nduá yohó cachíˋ xì‑ní: nú màsà nácácú sáá nèhivì, dandu mà cúí sàà‑nè cuni‑nè ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dandu nì cachi Nicodemo xì‑yá: ―¿Nansa cui nacacu‑nda nú sànì sahnu‑nda? ¿A cúí nàcùñuhu saa‑nda ini dihimánì‑ndà, te nacacu‑nda? ");
INSERT INTO mitNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Dandu nì cachi Jesús xì‑né: ―Ñà‑ndácuisì nduú palabra yohó cachíˋ xì‑ní: nú màsà nácácú sáá iin nèhivì quida tècuìí xì stná Espíritu Ìì, dandu mà níhì‑né yàha‑ne ñuhìví ìì ndé cusáhnû Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Vàchi nú sànì cacu‑nda nùù yuadíhí‑ndá, dandu iquìcúñú icúmí‑ndá. Doco nú sànì cacu anima‑ndà quida Espíritu Ìì xí Dios, dandu espíritu (saa) cucumi stná‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Màsà ndúlócô‑nî ñà‑nì cachì xì‑ní icúmí‑nî nacacu saa‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vàchi ducán quidá stná tàchì, caná te caná yohó yucán, doco có‑ìnáhá‑nsiâ índù lugar vàxa, ni índù lugar cuàhàn. Ducán iá stná xì anima nsidaa nèhivì nì nacacu nì quida Espíritu Ìì. ");
INSERT INTO mitNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Dandu nì cachi Nicodemo xì‑yá: ―Pues, ¿índù modo cunduu nsidaa ñà‑càchí‑nî jaàn? ");
INSERT INTO mitNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Dandu nì cachi Jesús xì‑né: ―Iin maestru ñuu‑ndà Israel nduu‑ní, te có‑sânìhì inì‑ní sàhájàn nacua ndiá ìcà‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ñà‑ndácuisì nduá yohó cachíˋ xì‑ní: ñà‑ndùá ináhá‑nsî, divi ñà‑jaàn cachí‑nsì xì‑nsiá. Te datúi stná‑nsì nùù‑nsiá ñà‑ndùá sànì xini‑nsì, doco có‑xìníndísâ‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mate cuisì sàhà ñà‑ìá ñuhìví yohó‑ní nduá cáhìn xì‑nsiá, doco có‑xìníndísâ‑nsiá; ñàyùcàndùá, ùhì cunindisá stná‑nsià nú ni cáhìn xì‑nsiá sàhà gloria (xi Dios). ");
INSERT INTO mitNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ni‑iin nèhivì tàñáha ga nana‑ne gloria. Doco yùhù ana nduú Tnaha Nèhivì Ñuhìví, ansivi nduú vehi, te nì nui nì quesai (ñuhìví yohó). ");
INSERT INTO mitNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Te nacua nì quida Moisés (sànaha) na nísa ìa‑ne yucù, nì chituu ducún‑nè iin còò (càa), pues ducán stná yùhù, icúmí nèhivì chituu ducún stná‑nè yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Dandu nsidaa nèhivì cunindisa‑xí, mà nunca sàà‑nè ndañuhu‑né; còó, nicanicuahàn cutiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Vàchi ñà‑cuàhà guá cuú ini Yua‑nda Dios sàhà nèhivì ñuhìví, nì sàhatahvì‑yá mindaa Dèhemanì‑yá (ñà‑cui‑yà), dandu nsidaa nèhivì xiníndísá‑xí‑yâ, mà sáà‑nè ndañuhu‑né, còó, nicanicuahàn icúmí‑nê cutiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Vàchi màdì sàhà‑ñá dandohó‑yá nèhivì cuáchi nduá dìsáhà‑xí nì ndacu nuù Dèhemanì‑yá quixi‑ya ñuhìví yohó, còó; divi sàhà‑ñá càcu‑ne nduá. ");
INSERT INTO mitNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Nú xiníndísâ iin nèhivì Dèhemanì Dios, dandu ñà‑sànì càcu‑ne nùù castigu sàhà cuàchi‑ne nduá; doco nèhivì có‑xìníndísâ, sà‑ìá vàxi castigu xi‑ne nùù‑yá, vàchi có‑xìníndísâ‑né ñà‑ndùá cachí mindaa Dèhemanì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Te ¿ndíà nduú meru ñà‑dìsáhà‑xí vàxi castigu mà dìquì‑né? Divi sàhà‑ñá sànì quesaa palabra ndàcuisì ñuhìví yohó ñà‑datnúà sàxìnítnùní nèhivì, doco chicá nì cudiì ini‑nè caca‑ne ichì ñáa, màdì ichì ndé datnúù Dios, vàchi quini iá ñà‑ndùá quidá‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Te nsidaa nècuàchìmà, có‑cùní dahuun‑ne cunini‑ne palabra datnúù xì sàxìnítnùní‑nè, ni có‑tnâtuu stná‑nè ndé cáhàn xì palabra mà sàhà‑ñá màsà túi ñà‑quini guá quidá‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Doco iin nèhivì quidá víi nacua cachí palabra ndàcuisì, cudíì ini‑nè tnàtuu‑ne ndé iá palabra datnúù xì sàxìnítnùní‑nè, vàchi cuní‑nè cundaà ini nsidaa nèhivì ñà‑quìdá víi‑né nchícùn‑nè ichì Dios ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Daaní, nì quihin tu Jesús ichì cuàhàn‑yà ladu Judea, mii‑yá xì nècuàchì xínchicùn xì‑yá. Te yucán nì ndòo chii‑yá xì‑né, dandu nì cuhiì nèhivì cuàhà gá nì sàà yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Stná Juan Bautista, yucán quidá íì stná‑nè nùù iin xaan nani Enón yatni lugar nani Salim, vàchi ñuhú cuáhà tècuìí yucán. Ñàyùcàndùá, divi lugar mà sáhàn cuàhà nèhivì ñà‑cuhiì‑né, ");
INSERT INTO mitNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","vàchi tàñáha ga cundiadi Juan. ");
INSERT INTO mitNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tiempu mà nì cuu nì quesaha nì cuàà nèhivì nchícùn xì Juan xì itnii gá nècuàchì raza‑nè Judea, vàchi tucu tucu cachí iin iin‑ne sàhà modo nduhiì‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dandu nsidaa‑né nì quixi‑ne nùù Juan nì cacachi‑nè xì nècuàchìmà: ―Maestro, ináhá‑nî ana nìsa ìa xi‑ní ladu duha yùte Jordán, te nì càhàn‑ní sàhà‑né, ndiaha gá‑nè nì cachì‑ní; pues vichi mii stná‑nè quidá íì stná‑nè nèhivì, te cuàhà gá nèhivì sáhàn nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dandu nì cachi Juan xì‑né: ―Ni‑iin nèhivì, mà cúí nìhì‑né iin chuun ndiaha nú màsà cuáha Dios‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ináhá‑nsiâ nansa nì cachì: “Yùhù, có‑ndùí (rey ndiaha nani) Cristu, cuisì iin ana nì techuún Dios nduí, te dihna vàxi nùù mii‑yá”. ");
INSERT INTO mitNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cunaha‑nsiá, na iá vicò nandàhà, iá iin noviu, te iá stná novia cutnáhâ xí‑nê. Doco iá stná padrinu iladú, iníní‑né, te cudíì ini‑nè na cáhàn noviu. Pues, ducán iá stná yùhù, nahi padrinu nduí, te yáha ga cudíì inì sàhà mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mii‑yá, cueé‑ni cueé‑ni chicá icúmí‑yâ nìhì gá‑yà tnùñuhu xí‑yá, doco yùhù, còó. Cueé‑ni cueé‑ni icúmí nèhivì nandòdó‑né yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mii‑yá, dècuèndè dìquì‑xí nì quee‑ya, ñàyùcàndùá chicá ndiaá‑yà nùù nsidaa‑nda. Iin nèhivì ñuhìví yohó, nèhivì ùún nduú‑né, te cuisì sàhà ñuhìví yohó cáhàn‑nè. Doco mii‑yá, ansivi nì quixi‑ya, te chicá ndiaá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Te ñà‑ndùá sànì xini‑yà, xì ñà‑ndùá nì inini‑ya, ñà‑jaàn nduá cachí‑yà xì nèhivì, doco có‑xìníndísâ‑né ñà‑ndùá cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Doco nú xiníndísâ iin nèhivì‑yá, dandu náhà claru sànì cundaà ini nècuàchìmà ñà‑mii palabra ndàcuisì nduá cachí Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Vàchi Jesús, mandu xi (Yua‑nda) Dios vàxi‑ya, te divi palabra ndiaha xí Yuamánì‑yá cáhàn‑yà, vàchi màdì iyuhu‑ní Espíritu Ìì sànì níhìtáhvì‑yá, còó. Sànì nìhì nsìhí‑yá Espíritu Ìì. ");
INSERT INTO mitNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Te cuú ini Yuamánì‑yá sàhà‑yá. Ndahà‑yá sànì dàyáha Yuamánì‑yá nsidanicuú iñàha. ");
INSERT INTO mitNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cunaha‑nsiá, nsidaa ana xiníndísá‑xí Dèhemanì Dios, nicanicuahàn cucumi‑né vida ndiaha. Doco nèhivì có‑xìníndísâ, mà‑níhì‑né vida ndiaha ma. Còó, iin castigu cahnú icúmí‑nê nìhì‑né nùù‑yá, te sà‑ìtúá vàxan. ");
INSERT INTO mitNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Quìvì yucán nì nducuahà gá nèhivì nchícùn xì Jesús. Te nì cuhiì stná‑nè. Doco màdì mii Jesús nì quìdá íì xì‑né, cuisì nècuàchì dacuahá‑yá nì quida iì xì‑né. Dècuèndè más gà nèhivì xí‑yá nì cuhiì nùù nèhivì nì quida iì Juan Bautista. Dandu nì xinitnùhu stná nècuàchì fariseu ñà‑cuàhà guá nèhivì nchícùn xì‑yá. Ñàyùcàndùá, na ní cundaà ini‑yà ñà‑sà‑ìnáhá nècuàchìmà ñà‑jaàn, ");
INSERT INTO mitNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","dandu nì quee‑ya ladu Judea mànuhù‑yá ladu Galilea, (mii‑yá xì nècuàchì dacuahá‑yá). ");
INSERT INTO mitNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Te ichì mà icúmí‑yâ yàha‑ya ladu Samaria. ");
INSERT INTO mitNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Te xicá‑yá nì nasaa‑yà yatni iin ñuu tii nani Sicar. Te divi yucán nduú stná ñuhù ndé nìsa itnii José sànaha, vàchi ñuhù nì ndutahvì‑né nùù yua‑né Jacob nduá. ");
INSERT INTO mitNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Te yucán iá stná pozo nìsa xichuún Jacob mà sànaha. Pues divi yuhù pozo mà nì sàcòo chii‑yá, vàchi caní ichì nì xìca‑ya, te xávî‑yà. Nahi càxíhúì nduá, ");
INSERT INTO mitNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","te sàcuàhàn nsidaa nècuàchì dacuahá‑yá ñuu mà ñà‑cuiin‑ne ñà‑cutiacu‑nè. Dandu (nùù pozo mà) nì tnàtuu stná iin nècuàchì ñahà ladu Samaria mà ñà‑tavà‑né tècuìí. Te nì cachi‑yà xì‑né: ―Taxi tahvì‑ní iyuhu tècuìí cohi. ");
INSERT INTO mitNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Te nì cachi nècuàchìmà xì‑yá: ―Doco mii‑ní, iin nècuàchì raza Judea nduu‑ní. ¿Índù chuun xícàn‑ní tècuìí coho‑ní nùù yùhù? vàchi nsidaa nècuàchì ñuù‑ní, indéhe úhì‑nè nsiùhù tè‑ndùú nècuàchì Samaria yohó. ");
INSERT INTO mitNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Dandu nì cachi Jesús xì‑né: ―Ndahví‑nî, vàchi có‑cùndáà inì‑ní nansa quidá Dios, dacútâhvì‑yá tnùmanì xí‑yá nùù nèhivì; ni có‑ìnáhá stná‑ní ana divi nduú yùhù ana xícàn xì tècuìí nùù‑ní. Vàchi nú ni cúndáà inì‑ní, dandu càcàn tàhvì‑ní nùí, te dacútâhvìˊ mii‑ní tècuìí cutiacu ndiaha‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dandu nì cachi‑nè xì‑yá: ―Señor, còò ni‑iñàha nihi‑ní tavà‑ní tècuìí yohó, vàchi cunú ñuhú‑te. ¿Nansa cui tavà‑ní tècuìí cutiacu ndiahí? ");
INSERT INTO mitNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Cunaha‑ní, pozo yohó nduú ndé nìsa xihi xìì‑ndà Jacob, mii‑né xì nsidaa dèhe‑ne xì quisì xí‑né, dandu nì nacoo‑neà nùù nsiùhù. ¿Te mii‑ní, a chicá ndiaá‑nî nùù xìì‑ndà mà cahan‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Dandu nì cachi Jesús xì‑né: ―Nú ni cohó nèhivì tècuìí pozo yohó, dandu tucutu icúmí‑nê cui‑nè tècuìí después. ");
INSERT INTO mitNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Doco nú ni cohó‑né tècuìí dacútâhvì yùhù‑nè, dandu mà nunca cui gà‑nète nicanicuahàn. Vàchi ducán quea na ian ñuhú tècuìí ini‑nè, te ndéà ndiaha‑té dècuèndè nìhìtáhvì‑né vida ndiaha nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dandu nì cachi nècuàchì ñahà mà: ―Señor, taxi‑ní tècuìí mà cohi ñà‑màsà cúí guè tècuìí, te màsà quíxí guè yohó taví‑te. ");
INSERT INTO mitNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Dandu nì cachi Jesús xì‑né: ―Cuahán‑nî cana‑ní iì‑ní quixi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Dandu nì cachi nècuàchìmà: ―Còò iì yùhù. Dandu nì cachi Jesús xì‑né: ―Ñà‑ndáà nduá cachí‑nî còò iì‑ní, ");
INSERT INTO mitNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","vàchi ùhùn xichi sànì nandàhà‑ní, te nì sate tnahá‑nsiá. Te tiàa iá xì‑ní vichi, màdì iì‑ní nduú‑né. Ñà‑jaàn ndisa nì cachi ndàà‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dandu nì cachi nècuàchìmà: ―Vichi sànì cundaà inì, na iin nèhivì cáhàn cuenta xi Dios nduu‑ní, señor. ");
INSERT INTO mitNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Doco estilu xi xìì‑nsí nduá cahvi‑nsí Dios dìnì yucù jaàn; doco mii‑nsiá, còó. Ñuu‑nsià Jerusalén nduú lugar ndé ndiá ìcà‑ndà cahvi‑nda Dios, cachí mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dandu nì cachi Jesús xì‑né: ―Señora, cunindisa‑ní yùhù: vàxi iin quìvì, dandu màdì cuisì dìnì yucù jaàn, ni màdì cuisì ñuu Jerusalén cùhùn‑nsià cahvi‑nsiá Yua‑nda Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mii‑nsiá, có‑ìnáhá ndisá‑nsiá ana divi cahvi‑nsiá. Doco nsiùhù, ináhá vâha‑nsi ana cahvi‑nsí, vàchi cuisì nsiùhù tè‑ndùú nècuàchì raza Judea icúmí xí palabra nansa càcu anima nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Cunaha‑ní, vàxi iin quìvì, dandu nèhivì cuní cahvi ndisa xi Dios, inì‑ni anima‑nè icúmí‑nê cahvi‑néyà, te cahvi stná‑nèyà nacua cachí palabra ndàcuisì xí‑yá, vàchi ducán cuní‑yà quida‑ne na cahvi‑néyà. Te vichi sànì sàà stná quìvì quida‑ne ducán. ");
INSERT INTO mitNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Vàchi mii espíritu ndiaha nduú Dios. Ñàyùcàndùá, nú cuàhàn‑ndà cahvi‑ndayá, dandu inì‑ni anima‑ndà icúmí‑ndá cahvi‑ndayá; te icúmí‑ndá cahvi stná‑ndàyá cuisì nacua cachí palabra ndàcuisì xí‑yá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Dandu nì cachi nècuàchì ñahà mà: ―Yùhù ináhî quixi mii‑yá ana nduú Mesías, divi mii‑yá nani Cristu. Te nú sànì quesaa‑yà, dandu cachitnùhu‑ya xì nèhivì nsidaa ñà‑ndùú ñà‑ndáà. ");
INSERT INTO mitNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dandu nì cachi Jesús xì‑né: ―Yùhù ana cáhàn xì‑ní vichi, divi nduú mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Daaní, cáhàn va‑ya xì nècuàchì yucán, te nì cansiaa tu nècuàchì dacuahá‑yá. Te nì ndulocó‑nè, cónì cúndáà ini‑nè índù chuun ndatnúhú‑yâ xì nècuàchì ñahà mà. Doco cónì xícàn tnùhù‑né nùù‑yá índù chuun cáhàn‑yà xì‑né, ni cónì ndácàtnùhù‑né nùù‑yá índù palabra cachí‑yà xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dandu nècuàchì ñahà mà, nì nacoo‑ne yoo xi‑ne mànuhù‑né ini ñuu mà, te nì càhàn‑nè xì nèhivì, cachí‑nè: ");
INSERT INTO mitNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Naha‑nsià cúhùn‑ndà cundehè‑nsiá iin tiàa iá yucán, vàchi nì nacani‑ne xìˊ nsidaa ñà‑ndùá nì quide vida xi. ¿Amádi mii‑yá nduú Cristu (ndiatu‑nda)? ");
INSERT INTO mitNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ñàyùcàndùá, nì ndecoyo cuàhà nèhivì ñuu yucán vàxi‑ne ndé iá Jesús, ");
INSERT INTO mitNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","vàchi iá ìì‑yá xì nècuàchì dacuahá‑yá. Te nì sacundahví nècuàchì dàcuàhá‑yá mà nùù‑yá, cachí‑nè: ―Maestro, cuxi‑ní iyuhu. ");
INSERT INTO mitNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Doco nì cachi‑yà xì‑né: ―Sà‑ìcúmî ñà‑cutiacuì mate có‑cùndáà inì‑nsia índù iñàha nduá. ");
INSERT INTO mitNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dandu nì ndatnuhu nècuàchì dacuahá‑yá iin‑ne xì inga‑nè, cachí‑nè: ―¿A vihi‑ni nì quixi iin nèhivì nihí xi ñà‑ndùá cuxi‑ya cahan‑nsiá? ");
INSERT INTO mitNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ñàyùcàndùá nì cachi‑yà xì‑né: ―Còó. Ñà‑ìtiácú yùhù nduú ñà‑quide cumplir nacua nì cachi mii‑yá nì techuun‑xí vàxi. Cuníˋ dansihí chuun ndiaha nì sàha‑ya yùhù. Te ñà‑jaàn nduá itiácuì. ");
INSERT INTO mitNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","36","(Ináhî) cachí‑nsià cumánì gá cùmì yòò, dandu ndanchito cosecha. Doco yùhù cachíˋ xì‑nsiá, cundehè‑nsiá (nadaa nèhivì ndoó ñuhìví), vàchi nahi cosecha xínduu stná‑nè, te sà‑ìá ndanchitoa. Te na quidá nèhivì chuun ndiaha xí cosecha mà, pues ñà‑nìhì ñanìtnaha‑ne vida ndiaha nicanicuahàn nduá. Dandu después, icúmí‑nê nìhì‑né ñà‑vàha xi‑ne, te cudiì gá ini‑nè, mii‑né xì stná nèhivì nì chihi stná xì (palabra primeru). ");
INSERT INTO mitNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Te ñà‑jaàn nduú nahi dichu cachí: “Diín nèhivì chihí, te diín nèhivì ndaníhí xí cosecha”. ");
INSERT INTO mitNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yùhù nì techuín mii‑nsiá ñà‑quida‑nsia iin chuun (ndiaha ñà‑chindee‑nsiá nèhivì nìhì‑né vida ndiaha, na ian) ndanihi‑nsia cosecha. Doco màdì mii‑nsiá nduú ana nì dàquésáhá xí chuun ma; còó, diín nèhivì nduú ana nì caquidachuún primeru, dandu después nì quìhvi stná mii‑nsiá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Cunaha‑nsiá, cuàhà nèhivì ñuu tii ladu Samaria mà nì xinindisa‑xi‑yá, vàchi nì xinindisá‑né palabra nì cachi nècuàchì ñahà mà ñà‑nì nacani‑ya xì‑né nsidaa ñà‑ndùá nì quida‑ne vida xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ñàyùcàndùá na ní quesaa nsidaa‑né ndé iá‑yà, dandu nì sacundahví‑nè nùù‑yá ñà‑nì còó chii gá‑yà ñuu‑nè; te sàhájàn nì ìa ga‑yà ùì gà quìvì. ");
INSERT INTO mitNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Dandu cuàhà gá stná nèhivì nì xinindisa‑xi‑yá, vàchi nì inini‑ne nì càhàn mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ñàyùcàndùá, nì cacachi‑nè xì nècuàchì ñahà mà: ―Vichi màdì cuisì sàhà ñà‑ndùá nì cachì‑ní nì xìníndísâ‑nsí; còó, vàchi vichi sànì inini stná‑nsì mii‑yá na cáhàn‑yà palabra xi‑ya, ñàyùcàndùá sànì cundaà ini‑nsì ñà‑divi mii‑yá nduú ana dacácu xi nèhivì ñuhìví; meru Cristu nduú‑yá ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Daaní, nì nsihi nì ìa Jesús ñuu yucán ùì quìvì, dandu nì naquihin‑ya ichì mànuhù‑yá ladu Galilea. ");
INSERT INTO mitNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Te mii‑yá nduú ana nì cachi ñà‑có‑quìdáñúhú nèhivì iin tiàa cáhàn cuenta xi Dios nú nduú‑né iin nècuàchì ñuu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Daaní, na ní nasaa‑yà ladu Galilea mà, nì cudiì ini nècuàchì ladu yucán sàhà‑yá, vàchi nì sàhàn stná‑nè ñuu Jerusalén quìvì nì ìa vicò, te nì xini stná‑nè nsidaa milagru nì quida‑ya yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Daaní, nì nasaa stná‑yà ñuu tii Caná iá ladu mà, divi ñuu ndé nì quida‑ya milagru xì tècuìí uun nì nanduu‑tè ndutè vídì sì‑uva. Te yucán nì quesaa stná iin nèhivì xí gobiernu nì quixi ñuu Capernaum, vàchi iá iin dèhe‑ne cuhí. ");
INSERT INTO mitNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Te nì xinitnùhu‑ne sànì nsiaa tu Jesús nì sàhàn‑yà ladu Judea. Ñàyùcàndùá vàxi‑ne nchícùn‑nèyà, te nì sacundahví‑nè nùù‑yá áma cúhùn‑yà xì‑né ñuu‑nè, te dandúvàha‑ya dèhe‑ne, vàchi sàcùcáhví‑te. ");
INSERT INTO mitNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Doco nì cachi Jesús xì‑né: ―Mii‑nsiá, nú màsà quídé iin milagru fuerte cundehè‑nsiá, mà sáà‑nsià cunindisá‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Doco nì cachi nècuàchìmà xì‑yá: ―Señor, cúhùn‑ndà vehi por favor, còtó cui dèhi. ");
INSERT INTO mitNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Dandu nì cachi Jesús xì‑né: ―Vàtùni nùhù‑ní, vàchi cuàhàn nduvàha dèhe‑ní. Dandu nì xinindisá nècuàchìmà palabra nì cachi‑yà xì‑né, ñàyùcàndùá mànuhù‑né vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te na sá‑ìtúú‑né nasaa‑nè, nì ndacùhun tnahá‑né xì itnii peón xi‑ne nihi‑xi razón vàxi, te nì cachì‑te: ―Sàcuàhàn nduvàha dèhe‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dandu nì xìcàn tnùhù‑né índù hora nì quesaha nì nchìco cuèhè. Te nì cachì‑te: ―Icu, nahi càhiin nì nchìco ini‑vè. ");
INSERT INTO mitNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ñàyùcàndùá, nì cundaà ini‑nè, divi hora nì càhàn‑nè xì Jesús nì sanduamà, divi hora nì cachi‑yà xì‑né ñà‑cuàhàn nduvàha dèhe‑ne. Ñàyùcàndùá, nì xinindisá‑néyà, mii‑né xì nsidaa stná nèhivì vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Cunaha‑nsiá, milagru yohó nduú milagru ùì nì quida‑ya na ní nasaa‑yà ladu Galilea nì sàhàn‑yà ñuu Judea. ");
INSERT INTO mitNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Daaní, quìvì yucán nacává iin vicò xí nècuàchì raza Judea, ñàyùcàndùá, nì quihin tu‑ya ichì cuàhàn‑yà ñuu Jerusalén. ");
INSERT INTO mitNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Te ini ñuu mà iá iin pila cahnú tècuìí. Te yucán itánduhù stná ùhùn vehe nahi corredor. Te lugar mà, Betesda naniá, te yatni iá mà ndé iá iin yehè ñuu mà nani Yehè Riì. ");
INSERT INTO mitNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pues divi vehe ma itánduhù cuáhà nècuàchì cuhí, nècuàchì cuaá, nècuàchì xicá cuéhê, nècuàchì yáha ga nì ìchì, xíndiatu nsidaa‑né ndacùchí tècuìí mà. ");
INSERT INTO mitNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Vàchi (cachí‑nè) cada yáha iin tiempu, dandu nuú iin ángel xi Dios dandácùchí xì‑té. Dandu nèhivì primeru quìhvi mahì‑té, icúmí‑nê nduvàha‑ne nùù cuèhè quida xi‑né, ndéni cuèhè nì cui ni cúndúá, icúmíâ cuxioa. ");
INSERT INTO mitNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Te yucán iá stná iin tiàa indúhu yuhù tècuìí mà, 38 cuìà icúmí‑nê cuèhè quida xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Dandu, nì xini Jesús jaàn indúhu‑né, te ináhá stná‑yà ñà‑càní cuìà iá‑nè xì cuèhè mà, ñàyùcàndùá, nì cachi‑yà xì‑né: ―Mii‑ní, ¿a cuní‑nî nduvàha‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dandu nì cachi‑nè xì‑yá: ―Señor, còò iin chindee xí na hora ndácùchí tècuìí, te quìhvi stnáì mahì‑té. Vàchi na meru sáì, dihna inga‑nè nì sàà‑nè nùí, te nuú‑né ndé ñuhú tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dandu nì cachi Jesús xì‑né: ―Ndacuiìn‑ní, ndanihi‑ní camilla xi‑ní, te caca‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dandu vichi vichi nì nduvàha nècuàchìmà nì ndanihi‑ne camilla xi‑ne, nì nacaca‑ne cuàhàn‑nè. Te quìvì yucán, quìvì descansu nduá. ");
INSERT INTO mitNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ñàyùcàndùá, nì cachi dava nècuàchì ñuu mà xì nècuàchì nì nduvàha ma: ―Quìvì descansu nduá vichi. Còò ley xi‑nda cunsida‑ní camilla xi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Dandu nì cachi tiàa ma xi‑né: ―Nècuàchì nì dàndúvàha xí, nì cachi‑nè xìˊ: “Ndanihi‑ní camilla xi‑ní, te caca‑ní”. ");
INSERT INTO mitNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dandu nì ndàcàtnùhù nèhivì mà nùù tiàa ma, cachí‑nè: ―¿Ana divi nì cachi xì‑ní ducán? ");
INSERT INTO mitNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Doco nècuàchìmà, có‑ìnáhá‑nê nansa nani ana nì dàndúvàha xi‑né, vàchi sàcuàhàn Jesús, te cuàhà gá nèhivì ndoó lugar yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Daaní, después nì ndacùhun tnahá‑yá xì‑né na xicánúú‑né patiu veheñùhu, te nì cachi‑yà xì‑né: ―Vichi sànì nduvàha‑ní. Màsà náxícócuîìn‑ní quida‑ní cuàchi, còtó quixi iin tnùndoho chicá fuerte dìquì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dandu tiàa ma, nì sàhàn‑nè nì cachitnùhu‑ne xì nècuàchì raza‑nèmà ñà‑divi Jesús nduú ana nì dàndúvàha xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ñàyùcàndùá nì caxini ùhì nècuàchì yucán mii‑yá, te nì quesaha‑né ndatnúhú‑nê nansa cahnì‑néyà ñà‑nì quida‑ya milagru mà iin quìvì descansu. ");
INSERT INTO mitNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Dandu nì cachi‑yà xì nsidaa nècuàchì yucán: ―Yuamánìˊ, iin‑ni quidáchúûn‑yá nsìquívì, ñàyùcàndùá ducán quidá stná yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ñàyùcàndùá chicá más nì cuni nècuàchì ladu Judea mà cahnì‑néyà, vàchi màdì cuisì‑ní có‑chîvàha viì‑yá quìvì descansu (cahan‑né), sino que nì cachi stná‑yà Dios nduú Yua‑yá, te ducán ndudává stnahá‑yá xì mii Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Dandu nì naxiconihí‑yá nùù nècuàchìmà, cachí‑yà: ―Cunini‑nsia palabra yohó cachíˋ. Mií mà cúí quide ni‑iñàha, cuisì ñà‑ndùá sànì xinì quidá stná Yuamánìˊ Dios, vàchi nacua quidá mii‑yá, divi ducán icúmî quida stnáì. ");
INSERT INTO mitNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Cunaha‑nsiá, cuú ini‑yà sàhí, te nsidaa obra ndiaha quidá mii‑yá, ñà‑jaàn dacuní stná‑yà yùhù quide. Te vichi sànì xini‑nsià iin ùì milagru, doco cuàhà obra chicá ndiaha icúmí‑yâ dacuní‑yà yùhù, dandu más gà icúmí‑nsiâ ndulocó‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Vàchi nacua danátiácú‑yà nècuàchì nsìi, te nacuàha‑yanè vida, divi ducán quidá stná yùhù. Ñàyùcàndùá, vàtùni danátiácú stnáì ndéni nèhivì ní cui cudíì inì. ");
INSERT INTO mitNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Te có‑nsìdándáà‑yà sàhà cuàchi nèhivì, vàchi ndahà yùhù sànì dàyáha‑ya chuun jaàn. ");
INSERT INTO mitNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ducán, dandu quidañuhu stná nèhivì yùhù nacua quidáñúhú‑nê mii‑yá. Vàchi nú màsà quídáñúhú‑nê yùhù ana nduú Dèhemanì‑yá, dandu queámà na ian có‑quìdáñúhú stná‑nè mii‑yá ana nì techuun‑xí vàxi. ");
INSERT INTO mitNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ñà‑ndácuisì nduá cachíˋ xì‑nsiá: nú iníní iin nèhivì ñà‑ndùá cachíˋ, te xiníndísâ‑né mii‑yá nì techuun‑xí vàxi, dandu cutiacu‑nè nicanicuahàn. Mà sáà‑nè cuni‑nè juiciu, vàchi sànì yàha‑ne ndahà mii‑yá ana sáha xi vida ndiaha. Mà cóó gá‑nè ladu ndé xíhì anima‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ñà‑ndáà nduá yohó cachíˋ xì‑nsiá: vàxi iin tiempu, dandu icúmí yùhù ana nduú Dèhemanì Dios ndàhì fuertíˋ, te cani nsidaa nècuàchì sànì xìhì, dandu nsidaa ana cunini xí, nìhì‑né vida ndiaha. Te cunaha‑nsiá, vichi nduú stná tiempu mà. ");
INSERT INTO mitNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","’Yuamánìˊ, nicanicuahàn ñuhú vida saín ini‑yà. Te sànì chitnùní stná ini‑yà ñà‑nicanicuahàn cucumi stná yùhù vida saín mà, vàchi Dèhemanì‑yá nduí. ");
INSERT INTO mitNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Te sànì sàha stná‑yà yùhù chuun nsidandaì sàhà cuàchi nèhivì, vàchi tnaha nèhivì ñuhìví nduú stnáì. ");
INSERT INTO mitNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Te có‑ndùá ñà‑ndulocó‑nsià sàhà palabra jaàn, vàchi vàxi iin quìvì, dandu nsidaa ana ñuhú tìxi ñuhù, icúmí‑nê tiacu‑nè na cani mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Dandu quecoyo nsihi‑ne. Nècuàchì nìsa quida viì, nìhì‑né natiacu‑nè sàhà ñà‑cutiacu ndiaha‑né nicanicuahàn. Doco nècuàchì cónì quìdá víi, cuisì natiacu‑nè sàhà ñà‑nìhì‑né castigu sàhà cuàchi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Cuenta xi mií, mà cúí quide ni‑iñàha. Cuisì nacua nì sàcùnahí, divi ducán nsidándáì sàhà cuàchi nèhivì. Te nú nsidándáì sàhà‑né ducán, dandu meru nacua ndiá ìcà cundua, vàchi divi Yuamánìˊ nduú ana nì techuun‑xí nì quesaì ñuhìví, te ñà‑ndùá cuní mii‑yá coo, divi nduá quidé, màdìá nandúquî ñà‑quide ñà‑cùní mií. ");
INSERT INTO mitNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","’Nú cuisì yùhù nì cúndúú ana cachítnùhu xi‑nsiá sàhà ana nduí, dandu mà có‑ndiàá mà. ");
INSERT INTO mitNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Doco iá inga nèhivì cachítnùhu sàhí, te ináhî cachí ndàà‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pues divi nduú Juan (Bautista). Te nì techuún‑nsiá compañeru‑nsià ndàcàtnùhù‑né nùù nècuàchìmà, te ñà‑ndáà nduu palabra ni naxiconihí‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Doco yùhù, còò necesidad icúmî càhàn iin nèhivì ùún sàhí. Te ñà‑ndùá cachíˋ xì‑nsiá, ñà‑jaàn cachíˋ sàhà‑ñá nìhì‑nsiá càcu anima‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Iin ratu tii nì cudiì inì‑nsia sàhà ñà‑ndùá quidá Juan (Bautista), vàchi iin ana datnúù xì sàxìnítnùní‑nsià (sàhà ichì Dios) nì sanduu ndisa‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Doco iá inga iñàha chicá fuerte nùù palabra nì cachi Juan sàhí. Vàchi cuàhà chuun ndiaha nì sàhatahvì Yuamánìˊ yùhù ñà‑quide, te divi sàhà chuun ndiaha ma vàtùni cundaà inì‑nsia ñà‑divi mandu xi mii‑yá vàxi. ");
INSERT INTO mitNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Daaní, stná mii‑yá sànì dàtúi‑ya ana divi nduú yùhù. Doco mii‑nsiá, tàcùní‑nsià nansa cáhàn‑yà; te tàcùní stná‑nsià nansa indéhe‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ni có‑nìhnú stná inì‑nsia ñà‑ndùá cachí‑yà, vàchi có‑xìníndísâ‑nsiá yùhù ana vàxi cuenta xi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","’Cuàhà gá dacuahá stná‑nsià tutu ìì, vàchi ducán nìhì‑nsiá vida ndiaha nicanicuahàn, cachí‑nsià. Doco cunaha‑nsiá, divi sàhà yùhù cáhàn stná tutu ìì mà. ");
INSERT INTO mitNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Doco có‑cùní‑nsià cunindisá‑nsiá yùhù, te nìhì‑nsiá vida ndiaha. ");
INSERT INTO mitNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Yùhù, có‑xìcánúí nandúquî nansa quidañuhu nèhivì yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Doco ináhî nansa nihnú ini mii‑nsiá; ináhî có‑cùú ini‑nsià sàhà Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","’Mate cuenta xi Yuamánìˊ vàxi, có‑xìníndísâ‑nsiá yùhù. Doco nú ni quixí inga ana càhàn cuisì sàhà mii‑xí, dandu divi cuàhàn‑nsià cunindisá‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","’Tùha‑nsia nanducu‑nsiá quidañuhu nèhivì mii‑nsiá, doco ñà‑ndee vàha‑nsia nùù ana nduú mindaa Dios, còó, có‑nàndúcú‑nsiâ ñà‑jaàn. Ñàyùcàndùá, sadíàmà nùù‑nsiá ñà‑mà cùì cunindisá‑nsiá yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","’Màsà túxí inì‑nsia yùhù cuàhìn daquée cuàchi dìquì‑nsiá nùù Yua‑nda Dios. Còó, diín nduú ana icúmí canicuàchi sàhà‑nsiá, divi nduú Moisés, mate tuxí ini‑nsià ley xi nècuàchìmà nduá cuàhàn dacácu xi‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Vàchi nú nì xinindisá‑nsiá ñà‑ndùá nì tiaa Moisés nì cùí, dandu cunindisá stná‑nsià yùhù, vàchi divi sàhà yùhù nì tiaa nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Doco nú có‑xìníndísâ‑nsiá palabra nì tiaa‑nemà, dandu mà sáà stná‑nsià cunindisá‑nsiá ñà‑ndùá cachí yùhù ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Daaní, nì quihin tu‑ya ichì cuàhàn‑yà inga ladu tècuìí cuáhà nani mar de Galilea. Te mar de Tiberio nani stná mà. ");
INSERT INTO mitNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Te cutnáhâ stná‑yà xì cuáhà gá nèhivì, vàchi sànì xini‑nè nansa nì quida‑ya milagru nì dàndúvàha‑ya cuàhà nècuàchì cuhí. ");
INSERT INTO mitNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dandu nì nana‑ya iin yucù yucán, te nì sàcòo‑ya, mii‑yá xì stná nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Te quìvì yucán nduú quìvì sà‑ìtúú nacava vicò pascua, iin vicò cahnú xí nècuàchì raza Judea. ");
INSERT INTO mitNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Te nì indehè‑yá, nì xini‑yà ñà‑cuàhà guá nèhivì vàxi nùù‑yá, ñàyùcàndùá, nì cachi‑yà xì Felipe: ―¿Índù cui cùhùn‑ndà cuiin‑nda ñà‑cutiacu nsidaa nèhivì yohó cahan‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ducán nì cachi‑yà xì nècuàchìmà, doco sà‑ìnáhá‑yâ nansa cuàhàn‑yà quida‑ya; nì cachi uun‑ya xì‑né a ver nansa cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ñàyùcàndùá, nì cachi‑nè xì‑yá: ―Còó, ni mà sáà ùì cientu dìhùn plata ñà‑cuiin‑nda pan cuxi‑ne, vàchi ni ñà‑jaàn mà sáà nìhì iin iin‑ne iyuhu iyuhá ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dandu nì càhàn iin nècuàchì dacuahá‑yá nani Andrés, divi ñani Simón Pedro, te nì cachi‑nè xì‑yá: ");
INSERT INTO mitNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Yohó iá iin tèchii nihi‑xi ùhùn pan tnuu xì ùì siaca cuati. Doco iyuhu nduájàn; mà sáà cuxi nsidaa nèhivì ñà‑cuàhà guá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dandu nì cachi Jesús: ―Càhàn‑nsià xì nèhivì ni mácùndoo‑ne ñuhù. Ñàyùcàndùá nì sàcùndoo nsidaa nèhivì nùù yùcù cuií, vàchi iá cuàhà yùcù yucán. Te cunaha‑nsiá, cuisì nècuàchì xínduu tiàa, ùhùn mil nì sanduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dandu nì tnii‑ya nsì‑úhùn pan mà, nì naquimanì‑yá Dios sàhà‑ñá, te nì dasàn‑yáñà nùù nècuàchì dacuahá‑yá. Dandu mii‑né, nì dàcuàchí‑néà nì sàha‑ne nèhivì ndoó yucán. Te divi ducán nì quida stná‑nè xì siaca. Te nsidaa nèhivì, nì nìhì‑né nacua cudíì ini‑nè cuxi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Daaní, na sánì chitu tìxi nsidaa‑né, dandu nì cachi‑yà xì nècuàchì dacuahá‑yá: ―Datacá‑nsià ñà‑nì cusobrá sàhá màsà ndáñúhú ni‑iyuhá. ");
INSERT INTO mitNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ñàyùcàndùá, nì dàtàcá‑nè ñà‑nì ndòo ma na ní nsihi nì xixi nsidaa‑né. Te nùù ùhùn pan mà nì cuyodò gá ùxìn ùì ìcà sìcàté chitu pedazu‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Dandu nì cundaà ini nèhivì yucán iin milagru nduá nì quida‑ya, ñàyùcàndùá nì cachi‑nè: ―Ñà‑ndáà nduá, Jesús yohó nduú ana xíndiatu‑nda quesaa ñuhìví, divi nècuàchì icúmí càhàn cuenta xi Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Doco Jesús, ináhá‑yâ nansa xínihnu ini‑nè quida‑ne, divi ñà‑cùní‑nè tnii‑neyà fuerza, te cunduu‑ya rey dandacú nùù‑né. Ñàyùcàndùá, nì quecuaán‑yá inga xichi, cuàhàn mindaa‑yá ndé nduú yucù. ");
INSERT INTO mitNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Daaní, nì cuaà quìvì yucán, te nì nuu nècuàchì dacuahá‑yá dècuèndè yuhù tècuìí cuáhà mà. ");
INSERT INTO mitNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nì sàcùñuhu‑ne ini lancha, te nì quihin‑ne ichì cuàhàn‑nè inga ladu mar tii ma, cuní‑nè cùhùn‑nè ñuu Capernaum. Te nì cuñaà, te tàñáha ga quesaa Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Dandu nì quesaha caná fuerte tàchì, ñàyùcàndùá, ducún nì nacuahnu todò tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Te na sácuàhàn‑nè ini lancha mà nahi ùhùn ò ìñù kilómetro, dandu nì xini‑nè jaàn vàxi‑ya, xicándódo‑yá nùù tècuìí, te sà‑ìtúú‑yá quesaa‑yà ndé cuàhàn lancha. Doco mii‑né, nì yùhí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Dandu nì cachi‑yà xì‑né: ―Yùhù nduí; màsà yúhî‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ñàyùcàndùá, nì dàyáha‑neyà ini lancha, cudíì ini‑nè. Te vichi vichi na iin cachí sànì sàà lancha mà dècuèndè ñuu ndé nchícùn‑nè cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Daaní, inga quìvì, te nì nataca cuàhà tú nèhivì yuhù mar (ndé nì quee lancha), te ináhá‑nê imindaa‑nú nìsa ìa yucán, te vichi cuàhàn nsihi nècuàchì dacuahá‑yá inì‑nu. Doco ináhá stnâ‑nè ñà‑có‑cùtnáhâ‑yá xì nècuàchìmà cuàhàn, vàchi micuísi‑né cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Doco después nì caquesaa tu itnii gá lancha nì quixi dècuèndè ñuu Tiberias nì quesaà‑nu ndé ndoó nèhivì cuáhà mà, divi lugar ndé nì caxixi‑ne pan na ní naquimanì‑yá sàhà‑ñá. ");
INSERT INTO mitNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","25","Ñàyùcàndùá, na ní cundaà ini nèhivì yucán, ni còò‑yá, te ni còò stná nècuàchì dacuahá‑yá, dandu nì quècoyo stná‑nè ini lancha, nì quihin‑ne ichì cuàhàn‑nè mahì mar, te nì casaà stná‑nè ñuu Capernaum, nandúcú‑nêyà inga ladu mar mà. Te na ní ndacùhun‑neyà, nì cachi‑nè xì‑yá: ―Maestro, ¿índù hora nì quesaà‑ní yohó? ");
INSERT INTO mitNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Te nì cachi‑yà xì‑né: ―Cunini‑nsia palabra yohó: yùhù ináhî índù chuun nandúcú‑nsiâ yùhù. Màdì sáhà ñà‑nì xini‑nsià milagru nduá; còó. Sàhà ñà‑nì xixi vàha‑nsia, te nì chitu tìxi‑nsia nduá. ");
INSERT INTO mitNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Doco màsà nácání inì‑nsia sàhà nansa nìhì‑nsiá ñà‑cutiacu‑nsià ñuhìví yohó, vàchi sacù‑ni tiempu cundiaà mà. Chicá nsiha nanducu‑nsiá ñà‑ndiaha íì cutiacù‑nsia nicanicuahàn. Te divi ñà‑jaàn nduá sáhatahvì yùhù ana nduú Tnaha Nèhivì Ñuhìví, vàchi nùù Yua‑nda Dios sànì nìhìtáhvìˊ ñà‑quide chuun ìì xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dandu nì cachi nèhivì mà xì‑yá: ―Cachì‑ní xì‑nsí nansa quida‑nsi sàhà‑ñá cundua obra vàha nacua cuní Dios quida‑nda. ");
INSERT INTO mitNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Dandu cachí‑yà xì‑né: ―Ñà‑cunindisá‑nsiá yùhù ana nì techuún‑yá nì quesaa, divi ñà‑jaàn nduú chuun vàha cuní Dios quida‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dandu cachí‑nè xì‑yá: ―Pues nú ducán, dandu ¿índù seña quida‑ní cundehè‑nsí, te cunindisá‑nsí? ¿Índù milagru quida‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Vàchi xìì‑ndà, na ní saxìca‑ne yucù dàná, nìsa còyo ñà‑ndiaha nani maná nìsa xixi‑ne, vàchi ducán cachí nùù tutu ìì: “Nùù ansivi nì dàcóyo Yua‑nda Dios pan nìsa xixi‑ne”. ");
INSERT INTO mitNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Dandu nì cachi Jesús xì‑né: ―Ñà‑ndácuisì nduá cachíˋ xì‑nsiá: pan nì nìhì xìì‑nsiá nùù Moisés sànaha ma, cónì sándúú ndisa pan ndiaha vàxi ansivi. Còó. Yuamánìˊ nduú ana sáhatahvì xì pan ndisa ndiaha ma. ");
INSERT INTO mitNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Vàchi pan sáhatahvì mii‑yá nduú yùhù ana nì techuún‑yá nì quixi ndè gloria sàhà ñà‑cutiacu nèhivì ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ñàyùcàndùá, nì cachi nèhivì yucán: ―Señor, nicanicuahàn taxi tahvì‑ní nsiùhù pan mà cuxi‑nsi. ");
INSERT INTO mitNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Dandu nì cachi‑yà xì‑né: ―Yùhù nduí nahi pan xi‑nsia cuxi‑nsia nsìquívì, te cutiacu‑nsià. Vàchi nsidaa ana sàà cunindisa‑xí, (ndiaha gá cundiatú anima‑nè), na ian mà nunca cui‑nè doco, te ni mà nunca cui stná‑nè tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Doco nacua nì cachì xì‑nsiá, sànì xini‑nsià nansa quidé, te có‑xìníndísâ‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Doco sànì chitnùní ini Yuamánìˊ ñà‑cundoo ana nduú nèhivì xí, te nsidanicuú nècuàchìmà, icúmí‑nê (sàà‑nè cunchicùn‑nè yùhù). Te mà nunca taxí ni‑iin ana cuní tnàtuu nùí. ");
INSERT INTO mitNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Vàchi divi sàhà‑ñá quide ñà‑ndùá cuní mii‑yá nì techuun‑xí, ñàyùcàndùá nì quei gloria nì quesaì. Mà váxi quide ñà‑ndùá cuní mií. ");
INSERT INTO mitNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Te ¿ndíà nduá cuní mii‑yá nì techuun‑xí? Pues, cuní‑yà (ñà‑iin‑ni cundoo viì) nsidaa nèhivì nì sàhatahvì‑yá yùhù; có‑cùní‑yà ndañuhu ni‑iin‑ne. Dandu na sáà xìnu tiempu, icúmí‑nê natiacu nsihi‑ne quide. ");
INSERT INTO mitNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ñàyùcàndùá, ndéni nèhivì ni cunítnùhu sàhà yùhù ana nduú Dèhemanì‑yá, te cunindisá‑né yùhù, vida ndiaha nicanicuahàn cucumi‑né, vàchi ducán nì chitnùní ini Yuamánìˊ. Dandu quìvì xìnu tiempu, icúmí‑nê natiacu‑nè quide ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ñàyùcàndùá, nì cuàà nècuàchì raza‑yà Judea sàhà‑yá ñà‑nì cachi‑yà nduú‑yá pan ndiaha nì quixi gloria. ");
INSERT INTO mitNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Te dohó nì cachi‑nè, iin‑ne xì inga‑nè: ―Amádi dèhe José nduú Jesús yohó. Ináhá‑ndá ana nduú yuadíhí‑nê. ¿Índù chuun cachí‑nè ndè gloria nì quixi‑ne? ");
INSERT INTO mitNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ñàyùcàndùá, nì cachi Jesús xì nècuàchì yucán: ―¿Índù chuun cuáà‑nsià ducán? ");
INSERT INTO mitNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mà níhì ni‑iin nèhivì nàcùnihnu ini‑nè yùhù nú cónì níhìtáhvì‑né ducán nùù Yuamánìˊ nì techuun‑xí; doco nú ni níhìtáhvì‑né ducán, dandu na quívì xìnu tiempu, icúmî danátiácuì‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sànaha nì tiaa nècuàchì profeta nùù tutu ìì, te dohó nì cachi‑nè: “Cunaha‑nsiá, icúmí Dios chinaha‑yà nsidaa‑né”, nì cachi‑nè. Ñàyùcàndùá, nsidaa nèhivì iníní xí Yua‑nda Dios, te cundaà vàha ini‑nè, divi nduú nècuàchì icúmí cunchicùn xì yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Còò ni‑iin ni xiní xì Yua‑nda Dios. Cuisì mindaa ana nì quixi nùù‑yá nì xininùù xì‑yá, (divi yùhù). ");
INSERT INTO mitNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ñà‑ndáà nduá cachíˋ xì‑nsiá, nsidaa ana xiníndísá‑xí yùhù, vida ndiaha nicanicuahàn sànì nìhìtáhvì‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yùhù nduí nahi pan (cuxi nèhivì), te cutiacu‑nè nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xìì‑nsiá nìsa xìca yucù dàná, nìsa xixi‑ne nùnì ansivi nani maná, doco nì xìhì nsihi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Doco pan cáhàn yùhù sàhà‑xí, còó. Nùù gloria nì quea vàxan, te nú sànì xixi iin nèhivì‑ñá, dandu mà cúí gà‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pues cunaha‑nsiá, yùhù nduí pan mà. Nùù gloria nì nui vàxi, te nú ni cúnchícùn iin nèhivì yùhù, dandu nicanicuahàn cutiacu‑nè, (na ian) sànì xixi‑ne yùhù, te ducán cutiacu‑nè. Te ¿índù iñàha cundua cuàhi ñà‑cunduu nahi pan mà? Pues divi cuerpu xi cunduu pan mà, vàchi icúmî cuàhi vida xi cuenta xi nèhivì ñuhìví sàhà‑ñá nìhì‑né cutiacu‑nè ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ñàyùcàndùá, nì quesaha nècuàchì raza‑yà Judea mà cuáà‑nè entre mii‑né, cachí‑nè: ―¿Índù modo cuàha nècuàchì yohó iquìcúñú‑nè ñà‑caxì‑ndàñá? ");
INSERT INTO mitNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dandu nì cachi‑yà xì‑né: ―Palabra ndàcuisì nduá cachíˋ xì‑nsiá yohó: nú màsà cáxi‑nsiá cuñu yùhù ana nduú Tnaha Nèhivì Ñuhìví, te nú màsà cóhó‑nsiá nìí, dandu còò vida ndiaha nùù‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nsidaa ana saxí xi cuñuì, te xihí‑né nìí, vida ndiaha nicanicuahàn icúmí‑nê, te icúmí‑nê natiacu‑nè na xìnu tiempu. ");
INSERT INTO mitNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Vàchi cuñuì, ñà‑cutiacu‑ndà nduá, te nìí, ñà‑coho‑nda nduú stná. ");
INSERT INTO mitNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nsidaa ana saxí xi cuñuì, te xihí‑né nìí, sànì ndèe anima‑nè ini anima yùhù, te iá stnáì ini anima mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","’Yùhù itiácúì sàhà mii‑yá ana nì techuun‑xí vàxi, divi sàhà Yua‑nda Dios iá nicanicuahàn. Te divi ducání stná xì nsidaa ana saxí xi yùhù, sàhà yùhù cutiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Pues, ducán nduú pan nì quixi gloria. Doco tucu iá pan nìsa xixi xìì‑nsiá sànaha, vàchi siempre nì xìhì‑nè. Cunaha‑nsiá, nsidaa ana xìxì‑xì pan cachíˋ xì‑nsiá vichi, nicanicuahàn cutiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ñà‑jaàn nduá nì cachi Jesús na iá‑yà veheñùhu ñuu Capernaum dacuahá‑yá nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na sánì inini nècuàchì dacuahá‑yá ñà‑ndùá nì cachi‑yà, dandu nì cachi dava‑ne: ―Ùhì cunindisa‑nda ñà‑jaàn. Mà cándísâ nèhivì palabra jaàn. ");
INSERT INTO mitNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Doco Jesús, ducání ináhá‑yâ nansa xícachi‑nè cáhàn ndiaa‑nèyà ducán. Ñàyùcàndùá, nì cachi‑yà xì‑né: ―¿A có‑ndôo ini‑nsià sàhà ñà‑ndùá nì cachì? ");
INSERT INTO mitNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pues nú coó, (dandu ¿nansa cachi gà‑nsià sàhà) yùhù ana nduú Tnaha Nèhivì Ñuhìví na cuni‑nsià yùhù mànaní ansivi nùhì? ");
INSERT INTO mitNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Cunaha‑nsiá, cuisì sàhà anima‑ndà nìhì‑ndà cutiacu ndiaha‑nda, màdì sàhà iquìcúñú‑ndà, vàchi còò ni‑iñàha nìhì‑ndà nùájàn. Cuisì palabra sànì cachì xì‑nsiá nduá dacútiácú xì anima‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Doco ináhî mii‑nsiá ñà‑dava‑nsia có‑xìníndísâ ndisa‑nsia ―nì cachi‑yà. Vàchi dècuèndè antes sà‑ìnáhá‑yâ ana xínduu nèhivì có‑xìníndísâ, te ináhá stná‑yà índù tiàa cuàhàn cahin xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ñàyùcàndùá, nì cachi‑yà xì nsidaa‑né: ―Nacua nì cachì xì‑nsiá daa, ducán nduá: mà cúí cunchicùn iin nèhivì yùhù nú màsà níhìtáhvì‑né ducán nùù Yuamánìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Daaní, divi quìvì yucán nì quecuaán cuàhà nècuàchì dacuahá‑yá, nì naxicocuíìn ini‑nè, cónì cútnáhâ gá‑nè xì‑yá cacanuu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ñàyùcàndùá nì càhàn‑yà xì ùxìn ùì nècuàchì dacuahá‑yá (cónì quécuáân): ―Mii‑nsiá, ¿a nacoo stná‑nsià yùhù? ");
INSERT INTO mitNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Dandu nì cachi Simón Pedro xì‑yá: ―Señor mío, còò inga gà ana cùhùn‑nsì nùù‑xí, vàchi cuisì sàhà palabra xi mii‑ní nìhìtáhvì‑nsí vida ndiaha nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Te xiníndísâ‑nsí mii‑ní ñà‑ndùù‑ní Cristu, divi Dèhemanì mii‑yá iá nicanicuahàn. Ináhá vâha‑nsi ñà‑jaàn. ");
INSERT INTO mitNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dandu nì cachi Jesús xì‑né: ―Ùxìn ùì mii‑nsiá sànì nacàxin, doco iin‑nsia nduú nahi ñà‑malu. ");
INSERT INTO mitNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pues divi palabra mà nì cachi‑yà sàhà dèhe Simón, nècuàchì nani Judas Iscariote, vàchi divi‑ne nduú tiàa cuàhàn cahin xì‑yá, te nduú stná‑nè iin nècuàchì dacuahá. ");
INSERT INTO mitNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Daaní, después, cuisì ladu Galilea nì quesaha xicánúú Jesús. Có‑cùní gà‑yà cacanuu‑ya ladu Judea, vàchi nècuàchì raza‑yà ndoó ladu mà, cuní‑nè cahnì‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Doco vichi sà‑ìtúú iin vicò nsidácáhnû‑né ladu Judea, divi vicò ndoó‑né siahva. ");
INSERT INTO mitNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ñàyùcàndùá, nì càhàn ñani Jesús xì‑yá, cachí‑nè: ―Vichi chicá vàha quee‑ní ladu yohó cuahán‑nî ladu Judea, dandu cuni nsidaa nècuàchì dacuaha‑ní mii‑ní, te cundehè stná‑nè milagru quida‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vàchi nú cuní‑ndà cuìtià fama xi‑nda nùù nèhivì, dandu mà quídá dèhé‑ndà ñà‑ndùá quida‑nda. Ñàyùcàndùá, nú cuàhà guá ñà‑ndùá quida‑ní, dandu quida vate‑níà cundehè nsidaa nèhivì ―nì cachi‑nè xì‑yá, ");
INSERT INTO mitNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","vàchi cunaha‑nsiá, ni ñani‑yà có‑xìníndísá‑xí‑yâ. ");
INSERT INTO mitNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ñàyùcàndùá, nì cachi Jesús xì‑né: ―Tàñáha ga sàà quìvì xí. Doco mii‑nsiá, ndéni tiempu nì cui, vàtùni quida‑nsia ñà‑ndùá cudíì inì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Te mà cúní ùhì nèhivì ñuhìví mii‑nsiá. Doco yùhù, xiní ùhì‑nè yùhù, vàchi cachíˋ xì‑né chuun quini nduá quidá‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cuahán‑nsià vicò mà; vàchi yùhù, tàñáha ga cùhìn, vàchi tàsáà quìvì xí. ");
INSERT INTO mitNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ñà‑jaàn nduá nì cachi‑yà xì‑né, te nì ndòo iì‑yá ladu Galilea yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Daaní, nì nsihi nì caquihin ñani‑yà ichì, dandu nì quihin stná‑yà ichì cuàhàn‑yà vicò mà. Doco cuàhàn dèhé‑yà, mà cuáhàn vate‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Te yucán ndé iá vicò mà nì nanducu nècuàchì ladu Judea mii‑yá, cachí‑nè: ―¿Índù iá Jesús? ");
INSERT INTO mitNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Te cuàhà gá nì ndatnuhu stná‑nè sàhà‑yá. Vàha ga‑yà, cachí dava‑ne, doco dava ga‑nè, còó, mà váha‑ya, vàchi dandahví uun‑ya nèhivì, cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Doco ni‑iin nèhivì, cónì cáhàn vate‑né sàhà‑yá, vàchi yúhî‑nè nècuàchì ladu Judea mà. ");
INSERT INTO mitNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Daaní, sànì cudava vicò, dandu nì sàà‑yà yehè veheñùhu cahnú, te nì quesaha‑yá dacuahá‑yá nèhivì ndoó yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ñàyùcàndùá, nì ndulocó nècuàchì ñuu mà, cachí‑nè: ―¡Na nchichí guâ cáhàn nècuàchì yohó, te cónì xìcá‑né escuela (xi‑nda)! ");
INSERT INTO mitNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Dandu nì cachi Jesús xì‑né: ―Cunaha‑nsiá, màdì dìnì yùhù taví ñà‑ndùá dacuahí nèhivì. Vàchi divi mii‑yá nì techuun‑xí vàxi nduú ana nì chitnùní inì‑xi nansa coo ñà‑ndùá chináhì. ");
INSERT INTO mitNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Te ndéni nèhivì nì cui, nú iá voluntad xi‑ne quida ndisa‑ne ñà‑ndùá cuní Dios, vàtùni sàà‑nè cundaà ini‑nè sàhà palabra chináhì, a divi dìnì mií queá, te ò Dios chindéé xî. ");
INSERT INTO mitNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Vàchi nú inì‑ni mii‑nda chítnùní ini‑ndà índù palabra chinaha‑ndà, dandu náhà claru cuisì cuní‑ndà tavà‑ndà tnùñuhu xí mii‑nda. Doco nú nandúcú‑ndá nansa quee tnùñuhu xí ana nì techuun‑xi‑nda vàxi, dandu vàtùni cundaà inì‑xi, ñà‑ndáà nduá cachí‑ndà, màdìá dandahví‑ndà nèhivì nduá. ");
INSERT INTO mitNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés nì sàha xi‑nsiá ley sànaha. Doco ni‑iin‑nsia có‑quìdá ndisa‑nsia ñà‑ndùá cachí ley mà. ¿Índù chuun cuní‑nsià cahnì‑nsiá yùhù? ");
INSERT INTO mitNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dandu nì cachi nèhivì cuáhà yucán: ―Ndisa sànì culocó‑nî nì quida ñà‑malu. ¿Ana cuní cahnì xì‑ní cahan‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Dandu nì cachi Jesús xì‑né: ―Sànì ndulocó nsidaa‑nsiá sàhà imindaa milagru nì quide. ");
INSERT INTO mitNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","(Ináhá‑ndá), sànaha nì saquin Moisés iin ley ñà‑màcòo seña xi Dios ìcà‑ndà. Doco màdì mii Moisés nduú ana nì chitnùní inì‑xi ñà‑coo estilu mà, vàchi xìì‑ndà chicá antes nduú ana nì dàquésáhá xân. Ñàyùcàndùá, ducan quida‑nda vichi, mate iin quìvì descansu nduá, doco fuerza màcòo seña mà ìcà iin méè. ");
INSERT INTO mitNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Cundehè‑nsiá, dècuèndè stná iin quìvì descansu saquín stná‑nsià seña mà ìcà‑vé, (danácuèhè‑nsiàvè) sàhà ñà‑cùní‑nsià chivàha viì‑nsiá ley mà. Te yùhù, divi stná quìvì descansu mà nì sandua na ní dàndúvàhi iin tiàa, te nì ndòo vàha‑ne; doco sàhájàn xídà inì‑nsia. ¿Nansa nduájàn? ");
INSERT INTO mitNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","(Yùhù cachíˋ xì‑nsiá), màsà cuítnùhu ndevàha‑nsia nacua tuxí uun ini‑nsià. Nú cuàhàn‑nsià càhàn tnùhù‑nsiá sàhà iin nèhivì, dandu ñà‑ndácuisì xiñuhu cundua cachi‑nsià ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ñàyùcàndùá, dava nècuàchì ñuu Jerusalén yucán, nì cachi‑nè iin‑ne xì inga‑nè: ―¿Amádi nècuàchì jaàn nduú tiàa cuní‑nè cahnì‑né? ");
INSERT INTO mitNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Doco cundehè‑nsiá, jaàn iín‑né mahì nèhivì, chináhá‑nè, te còá cachí nècuàchì cuní dandáñúhú xí‑nê. ¿A vihi‑ni sànì nacuni tè‑xídandacú nùù‑ndà ñà‑divi Cristu (nì quixi nùù Dios) nduú‑né? ");
INSERT INTO mitNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Doco nsiùhù, còó, vàchi sà‑ìnáhá‑nsî índù nì quixi nècuàchì jaàn. Vàchi na quívì quixi mii‑yá ana nduú ndisa Cristu, mà cúndáà inì‑xi índù nì quixi‑ya ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ñàyùcàndùá, ndee ní càhàn Jesús xì nèhivì dacuahá‑yá yehè veheñùhu, cachí‑yà: ―¿A ináhá‑nsiâ yùhù (tuxí inì‑nsia)? ¿A ndisa ináhá‑nsiâ ndévì nì quixi? Pues yùhù, màdìá inì‑ni mií nì ndàcú inì quixi; còó. Iá ana nì techuun‑xí vàxi, te vàtùni cahvi‑nda xi‑yá. Doco mii‑nsiá, có‑ìnáhá‑nsiâyà. ");
INSERT INTO mitNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yùhù, ndisa, ináhî mii‑yá, vàchi divi‑ya nduú ana nì techuun‑xí, te ñàyùcàndùá nùù mii‑yá nì quixi ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ñàyùcàndùá, nì nanducu nècuàchìmà nansa tnii‑neyà, doco cónì níhì‑né quida‑neà, vàchi tàñáha ga sàà quìvì cuu xi‑yá ducán. ");
INSERT INTO mitNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Doco cunaha‑nsiá, cuàhà gá nèhivì itá yucán nì xinindisá stná‑nè mii‑yá, te nì cachi‑nè: ―Cuàhà gá milagru quidá Jesús yohó. Ádi có‑xìñùhù gá cundehè gá‑ndà milagru sàhà‑ñá cundaà ini‑ndà divi rey ndiaha nì quixi nùù Dios nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Dandu nì caxinitnùhu nècuàchì fariseu ñà‑ndùá cachí nèhivì sàhà‑yá. Ñàyùcàndùá, mii‑né xì dùtù xícusahnú, nì càhàn‑nè xì policía ñà‑cùhùn‑te catnii‑tèyá. ");
INSERT INTO mitNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Dandu nì càhàn‑yà xì nèhivì inga xichi, cachí‑yà: ―Sacù‑ni tiempu coo guè xì‑nsiá yohó, dandu icúmî nùhì nùù ana nì techuun‑xí vàxi. ");
INSERT INTO mitNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Te mate ni nándúcú‑nsiâ yùhù, doco mà ndácùhun‑nsia yùhù, vàchi ndé cùhìn, mà cúí sàà‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dandu nècuàchì raza‑yà Judea yucán, nì ndatnuhu‑né entre mii‑né, cachí‑nè: ―¿Índù cùhùn nècuàchì yohó, te (cachí‑nè) mà cúí ndacùhun‑ndané? ¿A cúhùn xìcà‑né ñuu griegu ndé ndoó stná nècuàchì raza‑ndà, te dacuahá‑né nècuàchì griegu mà? ");
INSERT INTO mitNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Có‑sânìhì ini‑ndà ñà‑càchí‑nè ñà‑mà cúí ndacùhun‑ndané, mate ni nándúcú‑ndánê, te mà cúí sàà stná‑ndà lugar ndé cùhùn‑nè ―nì cachi nèhivì mà. ");
INSERT INTO mitNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Daaní, nì sàà quìvì nì xìnu vicò mà, divi quìvì chicá nducáhnû. Dandu nì ndacuiin Jesús mahì nèhivì, te nì càhàn ndee‑yá, cachí‑yà xì‑né: ―Nú iá ana xíhì tècuìí, dandu ni quixí‑né nùí, te coho vàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Vàchi nú xiníndísâ iin nèhivì xìˊ, ducán queá nùù‑né na ian caná fuerte tècuìí ini anima‑nè, te xítià‑te, nduú‑te nahi tècuìí coho‑nda cutiacu‑ndà nicanicuahàn, divi nacua cachítnùhu nùù tutu ìì ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Doco tècuìí nì cachi‑yà mà nduú (ejemplu, vàchi cunaha‑nsiá), Espíritu Ìì nduú tècuìí mà, te nsidaa ana xiníndísá‑xí‑yá, icúmí‑nê nìhìtáhvì‑né Espíritu Ìì mà. Doco tàñáha ga cuàhatahvì Dios Yà‑ìì mà, vàchi tàñáha ga nanihì Jesús tnùñuhu ndiaha xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Daaní, na ní inini dava nècuàchì itá yucán ñà‑ndùá nì cachi‑yà, dandu nì cachi‑nè: ―Ndisa, nècuàchì ndiatu‑nda quesaa càhàn cuenta xi Dios nduú ana yohó. ");
INSERT INTO mitNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Te dava ga‑nè, cachí‑nè: ―Divi rey ndiaha Cristu nduú nècuàchì yohó. Doco dava ga‑nè, nì cachi‑nè: ―¿A tuxí inì‑nsia rey ndiaha Cristu cunduu iin nècuàchì nì quixi ladu Galilea (nahi Jesús)? ");
INSERT INTO mitNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Amádi cachítnùhu tutu ìì sàhà rey mà ñà‑divi yohòtéhè‑yá nduú David, te ñuu nècuàchìmà nani Belén cunduu ñuu‑yà, cacháˋ. ");
INSERT INTO mitNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ñàyùcàndùá, nì tàhndè dava nèhivì sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Te mate cuní dava‑ne tnii‑neyà, doco ni‑iin‑ne có‑sâhandee ini‑nè quida‑neà. ");
INSERT INTO mitNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Daaní, na sámànuhù tè‑xínduu policía ndé ndoó dùtù xícusahnú xì nècuàchì fariseu, te nì cachi nècuàchìmà xì‑té: ―¿Índù chuun cónì sándácá‑nsiá Jesús quixi? ");
INSERT INTO mitNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Te nì naxiconihí policía, cachí‑te: ―Còò inga ana cáhàn ndiaha guá na cáhàn nècuàchì yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dandu nì cachi nècuàchì fariseu mà: ―¿A ndéˋ stná mii‑nsiá sànì dàndàhví Jesús? ");
INSERT INTO mitNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Cundehè‑nsiá nsiùhù tè‑xídandacú, ¿a sánì xinindisá‑nsí? Còó, ni‑iin‑nsi. Te ¿ò dává gá nècuàchì fariseu? Còó. Ni‑iin‑ne, có‑xìníndísâ‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Doco dava ga nèhivì ndahví yucán, ni có‑ìnáhá‑nê nansa cachí ley ìì, sàháyùcàndùá icúmí‑nê nìhì‑né castigu xi‑ne ―nì cachi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Cunaha‑nsiá, yucán iá stná Nicodemo, divi nècuàchì nì sàhàn nùù Jesús daa, vàchi iin nècuàchì xídandacú nduú stná‑nè. Te vichi nì càhàn stná‑nè xì nsidaa compañeru‑nèmà, cachí‑nè: ");
INSERT INTO mitNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―(Ñánì), ndéni nèhivì ní cui, nú cuní‑ndà nsidandaà‑ndà sàhà‑né, dihna icúmí‑ndá cunini‑nda nansa cachí mii‑né, dandísá, vàtùni cundaà ini‑ndà sàhà chuun xi‑ne. Amádi ñà‑jaàn nduú stná ley xi‑nda. ");
INSERT INTO mitNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Doco nì naxiconihí compañeru‑nèmà cachí‑nè: ―¿A ndéˋ stná mii‑ní nduú stná‑ní iin nècuàchì ladu Galilea? Nanducu váha‑ní (nùù tutu ìì), dandu cundaà inì‑ní, còò ni‑iin nècuàchì cáhàn cuenta xi Dios quixi ladu Galilea ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Dandu nsidaa‑né nì nacuitià‑nè mànuhù‑né vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Daaní, nì quee Jesús cuàhàn‑yà yucù Olivo. ");
INSERT INTO mitNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Dandu inga quìvì na ní tùinuù, vàxi tu‑ya veheñùhu cahnú. Te nì nataca cuàhà gá nèhivì nùù‑yá; te nì sàcòo‑ya nì chinaha‑yànè. ");
INSERT INTO mitNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dandu yucán nì sàà stná itnii maestru ináhá ley sànaha, xì stná dava nècuàchì fariseu, xíndaca‑ne iin nècuàchì ñahà nì sàà, te nì chicani‑ne nècuàchìmà nùù‑yá, vàchi ñahà mà, nì càhàn‑nè xì iin nècuàchì có‑ndùú nècuàchì vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ñàyùcàndùá nì cacachi nècuàchì tiàa ma xi‑yá: ―Maestro, nì tnii‑nsi ñahà yohó na quidá‑né iin cuàchi. ");
INSERT INTO mitNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Te cachí ley xi Moisés ñà‑ìcúmí‑nê cui‑nè xì yùù nú quidá‑né ducán. Doco mii‑ní, ¿nansa cachí‑nî quida‑nda? ");
INSERT INTO mitNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ducán nì cachi nècuàchìmà, áma cáchí‑yà iin ñà‑có‑ndìá ìcà‑yá cahan‑né, te ducán nìhìndèè‑né daquée cuàchi‑ne dìquì‑yá. Doco mii‑yá, nì nàcòo ndee ni‑ya, tiaá‑yá nùù ñuhù xì dìnìndàhá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dandu chicá cuàhà nì ndàcàtnùhù‑né nùù‑yá, ñàyùcàndùá, nì nàcòo ndaà‑yà, te nì cachi‑yà xì‑né: ―Nú iá ndisa iin‑nsia còò ni‑iin falta‑xi, dandu divi ni cúndúú primeru caniyuu‑xi nècuàchì yohó. ");
INSERT INTO mitNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dandu ingà tu nì nàcòo ndee‑ya, tiaá tú‑yá nùù ñuhù. ");
INSERT INTO mitNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","10","Doco nsidaa nècuàchì itá yucán, ináhá‑nê iá stná cuàchi‑ne. Ñàyùcàndùá, dihna nècuàchì chicá sahnú nì caquee cuàhàn, dandu después nì caquee stná iin iin nècuàchì dava ga mà cuàhàn‑nè, ndé mii Jesús nì ndòo, xì stná nècuàchì ñahà mà. Dandu nì nàcòo ndaà‑yà, te nì xini‑yà ndélà mindaa nècuàchìmà iín. Ñàyùcàndùá, nì cachi‑yà xì‑né: ―Señora, ¿a sácuàhàn nsidaa nèhivì daquée cuàchi dìquì‑ní? ¿Á coo cá ana cuní cahnì xì‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Dandu nì cachi nècuàchìmà: ―Còó, Señor; còò cá iin. Dandu nì cachi Jesús xì‑né: ―Pues ni yùhù, có‑cùní stnáì cuì‑ní. Cuahán‑nî, te màsà náxícócuîìn‑ní quida gà‑ní cuàchi ma ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Daaní, nì càhàn gà Jesús xì nèhivì yucán, cachí‑yà: ―Yùhù nduí ana datnúù xì sàxìnítnùní nèhivì ñuhìví. Ñàyùcàndùá, nsidaa ana nchícùn xìˊ, icúmí cutnuù ndiaha nùù ichì nchícùn‑nè, te ducán nìhìtáhvì stná‑nè vida ndiaha, vàchi mà nunca cunduamà ichì ñáa. ");
INSERT INTO mitNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dandu nì cachi nècuàchì fariseu xì‑yá: ―Còó, mà ndìsá, vàchi cuisì mii‑ní ndeníhí vàha‑ní mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Dandu nì cachi‑yà xì‑né: ―Mate mií cáhìn sàhà‑xí, doco vàtùni cundiaa mà, vàchi ináhî índù nì quei vàxi, te ináhî índù icúmî nùhì. Doco mii‑nsiá, có‑ìnáhá‑nsiâ índù nì quei vàxi, ni có‑ìnáhá stnâ‑nsià índù icúmî nùhì. ");
INSERT INTO mitNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Indéhe uun‑nsia nansa quidá nèhivì, te ñà‑jaàn cachí‑nsià sàhà‑né, a quidá víi‑né, ò á coó. Doco yùhù, có‑càchíˋ nú quidá víi‑né, ò á coó. ");
INSERT INTO mitNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Doco nú ndisa indéhí sàhà‑né, dandu ñà‑ndácuisì nduámà, vàchi màdì cuisì yùhù nduú ana cachí ducán, vàchi cutnáhâ stná Yuamánìˊ xìˊ, divi mii‑yá ana nì techuun‑xí vàxi. ");
INSERT INTO mitNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Cachí ley xi‑nsia: xì ùì testigu vàtùni cunindisa‑nda ñà‑ndáà nduá cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pues, cunaha‑nsiá, yùhù nduú iin ana cáhàn favor xi. Daaní, iá stná mii‑yá nì techuun‑xí, divi Yuamánìˊ, te cáhàn stná‑yà favor xi. ");
INSERT INTO mitNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dandu nì cacachi nècuàchìmà xì‑yá: ―¿Índù iá yua‑ní? Te nì cachi‑yà xì‑né: ―Mii‑nsiá, ni có‑ìnáhá‑nsiâ yùhù, ni có‑ìnáhá stnâ‑nsià Yuamánìˊ. Vàchi nú ni cúnáhá ndisa‑nsia yùhù nì cùí, dandu ñà‑jaàn nìhì stná‑nsià cunaha stná‑nsià mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ñà‑jaàn nduá nì cachi Jesús na ní dàcuàhá‑yá nèhivì ndoó yehè veheñùhu cahnú yatni ndé itá alcancía xi Dios. Doco còò iin ni tnii‑xi‑yá, vàchi tàñáha ga sàà quìvì cuu xi‑yá ducán. ");
INSERT INTO mitNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Daaní, nì cachi tu Jesús xì nècuàchì yucán: ―Yùhù icúmî cùhùn xìqué, te mii‑nsiá, icúmí‑nsiâ nanducu‑nsiá yùhù, doco na quívì cui‑nsià, icúmí‑nsiâ cui‑nsià xì cuàchi‑nsia. Te lugar ndé cùhìn, mà cúí cùhùn stná‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ñàyùcàndùá, nì cachi nècuàchì raza‑yà Judea mà entre mii‑né: ―¿A vihini cahnì nècuàchì jaàn mii‑né, ñàyùcàndùá nì cachi‑nè lugar ndé cùhùn‑nè mà cúí sàà stná‑ndà? ");
INSERT INTO mitNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Dandu nì cachi‑yà xì‑né: ―Nèhivì ñuhìví yohó xínduu‑nsia, doco yùhù, dìquì‑xí ansivi nì quixi, có‑ndùí nèhivì ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ñàyùcàndùá nì cachì xì‑nsiá daa ñà‑ìcúmí‑nsiâ cui‑nsià xì cuàchi‑nsia. Vàchi nú có‑xìníndísâ‑nsiá yùhù ñà‑ndùí ana nì cachì xì‑nsiá, dandu quìvì cui‑nsià cunsida iì‑nsiá cuàchi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ñàyùcàndùá, nì cachi‑nè xì‑yá: ―Pues, mii‑ní ¿ana divi nduu‑ní? Te nì cachi‑yà xì‑né: ―Ndè primeru sànì cachì xì‑nsiá ana nduí. ");
INSERT INTO mitNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Te cuàhà gá icúmí guêˋ cundehí, te cachì sàhà‑nsiá. Cunaha‑nsiá, palabra ndàcuisì nduá cachí mii‑yá ana dìchúún‑xí vàxi. Nùù mii‑yá nì sàcùnahí cachì nsidaa ñà‑ndùá cachíˋ xì mii‑nsiá nèhivì ñuhìví yohó ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Doco nèhivì yucán, cónì sánìhì ini‑nè ñà‑divi Yua‑nda Dios cáhàn‑yà sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ñàyùcàndùá nì cachi tu‑ya xì‑né: ―Nú sànì sàà‑nsià nì chituu ducún‑nsià yùhù ana nduú Tnaha Nèhivì Ñuhìví, dandu cundaà ini‑nsià ñà‑divi yùhù nduí ana cachíˋ xì‑nsiá, te màdì dìnì mií chítnùní inì quide ñà‑ndùá quidé. Cuisì quidé ñà‑ndùá nì dàndàcú Yuamánìˊ nùí, te divi ñà‑jaàn nduá cachíˋ xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cunaha‑nsiá, divi Yuamánìˊ nì techuun‑xí vàxi, te nicanicuahàn iá‑yà cutnáhâ stná‑yà xìˊ; mà nunca nacóó‑yá yùhù, vàchi nicanicuahàn quidé ñà‑ndùá cudíì ini‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ducán nì cachi Jesús, te sàhà palabra jaàn nì sàà nì xinindisá cuàhà gá nèhivì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Daaní, nì càhàn Jesús xì nèhivì xiníndísá‑xí‑yâ, cachí‑yâ: ―Nú iin‑ni cunindisá vàha‑nsia, dandu cunduu ndisa‑nsia nèhivì xí, ");
INSERT INTO mitNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","te sàà stná‑nsià mànìhì ini‑nsià ñà‑ndùú palabra ndàcuisì. Te divi sàhà palabra mà icúmí‑nsiâ caquee‑nsia libre. ");
INSERT INTO mitNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dandu nì cachi nèhivì xì‑yá: ―Nsidaa‑nsí, yohòtéhè‑nsí nduú Abraham, te ni‑iin xichi cónì ía ni‑iin lamú dandacu‑xi nùù‑nsí. Ñàyùcàndùá, ¿índù chuun cachí‑nî ñà‑ìcúmí‑nsî quee‑nsi libre? ");
INSERT INTO mitNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Dandu nì cachi‑yà xì‑né: ―Palabra ndàcuisì nduá yòhó cachíˋ xì‑nsiá: nsidaa ana tùha quida xi cuàchi, divi cuàchi ma nduá dàndàcù‑xì nùù‑né vida xi‑ne, na ian peón xi cuàchi ma nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Te iin peón, màdì nicanicuahàn coo‑tè vehe lamú xi‑tè. Tucu iá xì dèhe iin lamú, nicanicuahàn icúmí‑nê coo‑ne nùù nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ñàyùcàndùá, nú sànì dàcácu Dèhemanì (Dios) mii‑nsiá, te sànì quee‑nsia libre, dandísá, libre dahuun icúmí‑nsiâ cundoo‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yùhù ináhî Abraham nduú yohòtéhè‑nsiá. Doco vichi cuní‑nsià cahnì‑nsiá yùhù, vàchi có‑ndôo inì‑nsia xì ñà‑ndùá cachíˋ xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Cuisì ñà‑ndùá sànì xinì nùù Yuamánìˊ nduá cachíˋ xì‑nsiá, te ducán stná mii‑nsiá, ñà‑ndùá nì inini‑nsia nùù yua‑nsiá, divi nduá quidá stná‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","40","Dandu nì cacachi nècuàchìmà xì‑yá: ―Nsiùhù, Abraham nì sanduu primeru yua‑nsí. Te nì cachi Jesús xì‑né: ―Nú ndisa Abraham ni cúndúú yohòtéhè‑nsiá nì cùí, dandu icúmí‑nsiâ quida viì‑nsiá nacua nìsa quida nècuàchìmà sànaha. Doco vichi cuní‑nsià cahnì‑nsiá yùhù, mate palabra ndàcuisì nduá cachíˋ xì‑nsiá, te nduú stná mà palabra nì inini nùù Dios. Cunaha‑nsiá ni‑iin xichi cónì cùní Abraham quida‑ne nacua cuní mii‑nsiá quida‑nsia xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Doco mii‑nsiá, nacua quidá yua‑nsiá, divi ducán quidá stná‑nsià. Dandu nì cachi nèhivì mà xì‑yá: ―Nsiùhù, có‑ndùú‑nsí dèhe ndahví. Mindaa Yua‑nsí iá, te divi nduú Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dandu nì cachi‑yà xì‑né: ―Nú Dios ni cúndúú yua‑nsiá nì cùí, dandu icúmí‑nsiâ cuu ini‑nsià sàhí, vàchi nùù mii‑yá nì quei vàxi. Màdì yùhù nì nácání mií inì quixi, còó. Divi mii‑yá nì techuun‑xí vàxi. ");
INSERT INTO mitNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Te ¿índù chuun mà cùì mànìhì inì‑nsia ñà‑ndùá cachíˋ xì‑nsiá? Pues divi sàhà‑ñá mà cúndéé inì‑nsia cunindisá‑nsiá palabra xi. ");
INSERT INTO mitNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Vàchi divi ñà‑malu nduú yua‑nsiá, te nacua cudíì ini quisì mà quida quini‑sì, divi ducán stná mii‑nsiá, cudíì stná inì‑nsia quida‑nsia ducán. Dècuèndè tiempu chicá antes cudíì inì‑si dacahní stnahá‑si nèhivì. Mà nunca tùha‑sì quida‑sì ni‑iñàha nduú ñà‑ndáà, vàchi còò ni‑iin palabra vàha nihnú inì‑si. Te na cáhàn tnùhù‑sí, (màsà ndúlócô‑ndà), vàchi ducání tnuhu ini anima‑si. Tnuhu‑sí, te yua ñá‑tnùhù nduú‑si. ");
INSERT INTO mitNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Te yùhù, sàhà‑ñá cachíˋ xì‑nsiá ñà‑ndùú ñà‑ndácuisì, ñàyùcàndùá có‑xìníndísâ‑nsiá yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Te nú iá cuàchi nì quide cahan‑nsiá, dandu ¿índù chuun có‑càchí claru‑nsiàñà? Doco te nú ñà‑ndáà nduá cachíˋ xì‑nsiá, dandu xiñuhu cunindisá‑nsiá yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nsidaa ana nduú nèhivì xí Dios, cudíì ini‑nè cunini‑ne palabra vàxi nùù‑yá. Doco sàhà‑ñá có‑ndùú‑nsiá nèhivì xí‑yá, ñàyùcàndùá có‑ìníní‑nsiá palabra xi‑ya ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dandu nì càhàn tu nèhivì raza‑yà Judea xì‑yá, cachí‑nè: ―Ádi ñá‑ndâà nduá cachí‑nsì, iin nècuàchì samaritanu (sìquini) nduu‑ní, te iá stná iin ñà‑malu anima‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Dandu nì cachi‑yà xì‑né: ―Còò ñà‑malu anímè. (Na cáhìn xì‑nsiá), cuisì cuníˋ quee tnùñuhu xí Yuamánìˊ. Doco mii‑nsiá, cahíchì inì‑nsia yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Có‑nàndúquî nansa tavà nèhivì tnùñuhu xí mií, vàchi iá iin ana quida‑xi ñà‑jaàn, te mii‑yá nduú stná ana icúmí nsidandaà viì sàhà nsidaa chuun. ");
INSERT INTO mitNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Palabra ndàcuisì nduá cachíˋ xì‑nsiá yohó: nú ni chívàha iin nèhivì ñà‑ndùá chináhì, dandu mà nunca sàà‑nè cui‑nè nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dandu nì cachi nècuàchì raza‑yà Judea yucán: ―Vichi sànì cundaà ndisa ini‑nsì iá ñà‑malu anima‑ní, vàchi sànaha nì xìhì Abraham yucán, te nì xìhì stná nsidaa profeta nìsa cahàn cuenta xi Dios. Doco mii‑ní cachí‑nî mà nunca sàà cui nèhivì chívàha xi ñà‑ndùá cachí‑nî. ");
INSERT INTO mitNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿A tuxí inì‑ní chicá ndiaá‑nî nùù xìì‑ndà Abraham? Vàchi còò gá ndómà, xì stná profeta nìsa cahàn cuenta xi Dios, sànì caxihì nsihi‑ne. ¿Ana divi nduu‑ní cahan‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Dandu nì cachi Jesús xì‑né: ―Nú mií ni cachíˋ ñà‑chicá ndiaíˋ, dandu, mà cúndiááˋ mà. Vàchi divi Yuamánìˊ nduú ana icúmí tavà xì tnùñuhu xí yùhù, mate mii‑yá nduú ana càhvì stná‑nsià, cachí‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Doco mii‑nsiá, có‑ìnáhá‑nsiâyà; cuisì yùhù, ndisa, ináhî‑yà. Te nú ni cachíˋ có‑ìnáhî‑yà, dandu cunduu stnáì tè‑tnùhù nahi mii‑nsiá. Doco yùhù, ináhî mii‑yá, te chívàhi ñà‑ndùá cachí‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Xìì‑ndà Abraham mà, nì cudiì ini‑nè ñà‑nìhìtáhvì‑né cuni‑nè tiempu (quesaì ñuhìví yohó). Ñàyùcàndùá, contentu nì ndòo‑ne na ní cuu ndisa ñà‑jaàn. ");
INSERT INTO mitNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dandu nì cachi nèhivì mà xì‑yá: ―¡Mii‑ní, ni có‑xìcà‑ní ùì dico ùxìn cuìà, te ináhá‑nî Abraham cahan‑ní! ");
INSERT INTO mitNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Dandu nì cachi Jesús xì‑né: ―Cunaha‑nsiá, tàyóo Abraham, doco yùhù sà‑ìéˋ. ");
INSERT INTO mitNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ñàyùcàndùá nì dàtàcá nècuàchìmà yùù cuàhàn‑nè cahnì‑néyà nì cùí, doco nì quee dèhé‑yà veheñùhu ma nì chindaà‑yà mahì‑né cuàhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Dandu nì yàha Jesús chicá nùù‑xí, te nì xini‑yà yucán iá iin nècuàchì cuaá, dècuèndè nì cacu‑ne cuaá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Te nì xìcàn tnùhù nècuàchì dacuahá‑yá nùù‑yá, cachí‑nè: ―Maestro, ¿ana cuàchi‑xi nduá, te cuaá nècuàchì yohó nì cacu‑ne? ¿A yuadíhí‑nê iá cuàchi‑xi, ò mii‑né? ");
INSERT INTO mitNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Dandu nì cachi Jesús xì‑né: ―Ni còò cuàchi ni quidá nècuàchì yohó, ni stná yuadíhí‑nê. Cunaha‑nsiá, sàhà‑ñá ni sáà nèhivì cundaà ini‑nè ñà‑ndiaha guá quidá Dios, ñàyùcàndùá nì cuu xi nècuàchì yohó ducán. ");
INSERT INTO mitNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yùhù, na iá va quìvì, icúmî quide obra ndiaha nì sàcùnahí nùù mii‑yá ana nì techuun‑xí vàxi; vàchi (vàxi iin tiempu ùhì) nàcuììn tnùù, dandu mà cúí gá quida ni‑iin nèhivì chuun xi mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yùhù, na iá ve ñuhìví yohó, chuun xi nduá datnúì sàxìnítnùní nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Dandu nì nsihi nì cachi‑yà ducán, nì dàcóyo‑ya tèdìí‑yà ñuhù, te nì quidavàha‑ya iyuhu ndèhì nì dàcánúú‑yâ nùù nècuàchì cuaá mà. ");
INSERT INTO mitNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Te nì cachi‑yà xì‑né: ―Vichi cuahán‑nî quisi‑ní ndé ñuhú tècuìí pila nani Siloé. Pues cunaha‑nsiá, quìvì Siloé mà cuní cacháˋ dàhàn ñuu yucán ñà‑sànì techuún nèhivì‑ndó. Ñàyùcàndùá, nì sàhàn tiàa ma nì quisi‑ne, te na mándixi‑ne sàtùínúù‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Dandu nsidaa nècuàchì ndoó yatni ndé iá‑nè, xì stná dava ga nècuàchì ináhá xí‑nê antes cuaá‑nè, nì cachi‑nè: ―¿Amádi nècuàchì tiàa jaàn nduú ana nìsa ìa xícàn xì caridad? ");
INSERT INTO mitNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Te dava‑ne, cachí‑nè: ―Divi nduú‑né. Te dava ga‑nè, cachí‑nè: ―Còó, cuisì na indéhe nècuàchì cuaá mà, ducán indéhe stná nècuàchì yohó. Doco nècuàchì nì sanduu nècuàchì cuaá mà, nì cachi‑nè: ―Divi nduí. ");
INSERT INTO mitNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dandu nì cacachi nècuàchì yucán xì nècuàchìmà: ―¿Nansa nì cuu nì natùinuù‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Te nì cachi nècuàchìmà: ―Iin tiàa nani Jesús, nì quidavàha‑ne iyuhu ndèhì nì dàcánúú‑né nùí, te nì cachi‑nè xìˊ: “Cuahán‑nî ndè pila Siloé, te quisi‑ní”. Ñàyùcàndùá, ducán nì quide, te nì natùinuìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Dandu nì cachi nèhivì mà xì‑né: ―Pues vichi, ¿índù iá tiàa ma? Te nì cachi nècuàchìmà: ―Có‑cùndáà inì. ");
INSERT INTO mitNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dandu nèhivì yucán, ndacá‑né nècuàchìmà cuàhàn nùù nècuàchì fariseu. ");
INSERT INTO mitNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Vàchi cunaha‑nsiá, quìvì descansu nduá na ní quidavàha Jesús ndèhì nì dànátùi‑ya nùù nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ñàyùcàndùá, nì xìcàn tnùhù stná nècuàchì fariseu nùù nècuàchìmà nansa nì cuu nì natùinuù‑né. Dandu nì cachi‑nè: ―Nì quidavàha nècuàchìmà ndèhì, te nì dàcánúú‑nê nùí; dandu nì sàhìn nì quisi, te vichi duha nì natùinuìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Dandu dava nècuàchì fariseu mà, nì cacachi‑nè: ―Tiàa nì quida ducan xi nècuàchì yohó, có‑ìá‑nè ladu xi Dios, vàchi có‑chîvàha‑ne quìvì descansu. Doco dava ga nècuàchìmà, nì cacachi‑nè: ―Còó, vàchi nú nècuàchì cuàchi ni cúndúú nècuàchìmà, dandu mà cúí quida‑ne iin milagru nahi ñà‑yòhó. Ñàyùcàndùá, nì tàhndè dava nècuàchì fariseu mà. ");
INSERT INTO mitNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dandu nì cachi tu‑ne xì tiàa nì sanduu nècuàchì cuaá mà: ―Te mii‑ní tu, ¿nansa cachí‑nî sàhà nècuàchìmà ñà‑sànì dànátùi‑ne nùù‑ní? Dandu nì cachi nècuàchìmà: ―Iin profeta cáhàn cuenta xi Dios nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Doco nècuàchì xídandacú nùù tè‑raza Judea, cónì xìníndísâ‑né ñà‑cuàá ndisa nècuàchìmà na ní cacu‑ne. Ñàyùcàndùá, nì cana‑ne yuadíhí nècuàchìmà, ");
INSERT INTO mitNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","te nì xìcàn tnùhù‑né nùù nècuàchì sahnuma, cachí‑nè: ―¿A dèhe‑nsia nduú nècuàchì yohó, te a ndísá cuaá‑nè na ní cacu‑ne, cachí‑nsià? Te nú ducán, ¿nansa nì cuu nì natùinuù‑né vichi? ");
INSERT INTO mitNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Dandu nì cachi yuadíhí nècuàchìmà: ―Ináhá‑nsî dèhe‑nsi nduú tè‑yòhó, te ñà‑ndáà nduá cuaá‑te na ní cacu‑tè. ");
INSERT INTO mitNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Doco có‑cùndáà ini‑nsì nansa nì cuu nì natùinuù‑té, ni có‑ìnáhá stná‑nsì ana nduú nècuàchì nì dàndúvàha xi‑té. Cunaha‑nsiá, tè‑sàhnú sàndùú‑te; nùù mii‑té ndàcàtnùhù‑nsiá. Vàtùni nacani‑tè nansa nì cuu xi‑té. ");
INSERT INTO mitNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ñà‑jaàn nduá nì cachi yuadíhí nècuàchìmà, vàchi yúhî‑nè nècuàchì dava ga raza‑nè Judea, vàchi sànì ndatnuhu váha nècuàchì (dandacú) sàhà nsidaa ana cachi vate sàhà Jesús ñà‑ndùú‑yá Cristu (nì quixi nùù Dios); te vichi sànì tavà‑né orden ñà‑mà cóó gá permisu cùhùn nècuàchìmà veheñùhu. ");
INSERT INTO mitNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ñàyùcàndùá, nì cachi yuadíhí tiàa ma ñà‑sàsàhnú dèhe‑nemà, chicá vàha ndàcàtnùhù xì nùù mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Daaní, nì cana tu nècuàchì dandacu‑ma tiàa nì nduvàha ma ñà‑tnàtuu‑ne, te nì cachi‑nè xì nècuàchìmà: ―Tavà‑ní tnùñuhu xí Dios; vàchi nsiùhù, ináhá‑nsî nècuàchì cuàchi nduú nècuàchì nì càhàn xì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dandu nì cachi tiàa ma xi nsidaa‑né: ―Yùhù, có‑cùndáà inì, a nècuàchì cuàchi nduú‑né, á coó. Cuisì imindaa iñàha ináhî: divi ñà‑antes nìsa ìa cuaá dahuin, doco vichi sànì natùinuìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dandu nì cachi nècuàchìmà: ―¿Nansa nì quida‑ne xì‑ní? ¿Ndíà nduá nì quida‑ne, te nì nanihì‑ní vista xi‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Dandu nì cachi tiàa ma xi‑né: ―Pues sànì cachì xì‑nsiá nsidaámà, te có‑xìníndísâ‑nsiá. ¿Índù chuun cuní‑nsià nacani guè xì‑nsiá ingà tu? ¿A cuní stná‑nsià yàha‑nsia ladu xi Jesús? ");
INSERT INTO mitNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dandu nì quesaha nècuàchìmà cánàhá‑nè, cachí‑nè: ―Mii‑ní, ladu xi nècuàchìmà iá‑nî, doco nsiùhù, ladu xi (xìì‑ndà) Moisés iá‑nsì. ");
INSERT INTO mitNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ináhá‑nsî nì càhàn Dios xì Moisés, doco nècuàchì jaàn, ni có‑ìnáhá‑nsî índù ladu nì quixi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dandu nì cachi tiàa ma xi nsidaa‑né: ―Pues ndiaha mánì nduájàn. Ni có‑ìnáhá‑ndá índù nì quixi‑ne, doco sànì dàndúvàha‑ne nduchìnúìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pues ináhá‑ndá ñà‑có‑ìníní Dios na xícàn tàhvì iin nèhivì có‑quìdá víi. Doco nú nihnú vàha ini‑ndàyá, te quida‑nda ñà‑ndùá cachí‑yà, dandu quihín casu‑yà na xícàn tàhvì‑ndà nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Te ni dècuèndè sànaha có‑xìnítnùhu‑nda coo ana danátùi xi nùù iin nèhivì cuaá dècuèndè quìvì nì cacu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ñàyùcàndùá, sànì cundaà inì, ladu xi Dios iá Jesús, vàchi nú coó, mà cúí quida‑ya ni‑iin milagru. ");
INSERT INTO mitNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dandu nì cachi nsidaa nècuàchìmà xì tiàa ma: ―Mii‑ní, dècuèndè nì quesaà‑ní ñuhìví sà‑ìá cuàhà cuàchi‑ní, te ¿a tuxí inì‑ní cuàhàn‑ní chinahà‑ní nsiùhù? Ducán nì cachi‑nè, te nì taxi‑né nècuàchìmà tùvèhé. ");
INSERT INTO mitNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Dandu nì xinitnùhu Jesús nansa nì cuu xi nècuàchìmà ñà‑nì taxi‑ñánê. Ñàyùcàndùá, na ní ndacùhun stnahá‑yá xì‑né, nì cachi‑yà xì‑né: ―¿A xiníndísá‑nî mii‑yá ana nduú Dèhemanì Dios? ");
INSERT INTO mitNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Dandu nì cachi nècuàchìmà xì‑yá: ―Señor, cachì‑ní xìˊ ana divi nduú‑yá, dandu cunindisé. ");
INSERT INTO mitNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Te nì cachi Jesús xì‑né: ―Sànì xinì‑ní mii‑yá, vàchi divi nduú yùhù ana cáhàn xì‑ní vichi. ");
INSERT INTO mitNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dandu nì cachi tiàa ma: ―Yùhù xiníndísê, Señor mío. Te nì cahvi‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Dandu nì cachi‑yà: ―¿Índù chuun nì quesaì ñuhìví yohó? Divi sàhà‑ñá cunahà claru ana quidá víi ndisa; dandu nèhivì cuaá ini anima‑xi, vàtùni nìhì‑né (cundaà ini‑nè, na ian nì) natùinuù‑né. Doco nèhivì tuxí inì‑xi sàcùndáà vàha inì‑xi, mii‑né nduú ana icúmí cuaá anima‑xi, (mà cúndáà gà ini‑nè) ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Doco dava nècuàchì fariseu cutnáhâ xí‑yâ yucán, nì inini‑ne ñà‑ndùá nì cachi‑yà, te nì cacachi‑nè xì‑yá: ―Te nsiùhù tu, ¿a cuaá stná ini anima‑nsì cahan‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dandu nì cachi‑yà xì‑né: ―Nú sànì nacuni‑nsià cuaá ini anima‑nsià nì cùí, dandu mà cóó gá cuàchi‑nsia; doco vichi cachí‑nsià (ñà‑cùndáà vàha ini‑nsià), te claru ináhá‑nsiâ nsidaa iñàha. Ñàyùcàndùá, iá ìì cuàchi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Palabra ndàcuisì nduá yohó: nú quíhvi dèhé nèhivì ìcà corra ndé có‑ndùú yehè, dandu ináhá‑ndá nècuàchì vàxi quidacuihna xi riì xì‑ndà nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Doco nècuàchì quíhvi yehè corra, còó, nècuàchì dìríi‑xí nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Te iá stná peón xi‑ne ndiaá xì yehè mà. Te cuisì nùù nècuàchì dìríi‑xí nacúná‑te. Te na cáhàn nècuàchìmà xì riì xí‑né, nacúnì‑siné. Te caná‑nèsi quìvì iin iin‑sì, dandu queé‑si xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","5","Te na tavá‑nèsi ducán, dandu sácòdònùù‑né nùù‑sí cuàhàn‑nè; te vivìí‑ni xínchicùn‑siné, vàchi ináhá‑sî tàchì stohò‑si. Doco inga nèhivì tùcù, còó, mà cúnchícùn‑siné. Xinúdèhé‑si nùù‑né, vàchi có‑nàcúnì‑si tàchì nèhivì tùcù. ");
INSERT INTO mitNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ñà‑jaàn nduú iin ejemplu nì nacani Jesús xì nèhivì yucán, doco cónì cúndáà ini‑nè ndíà nduá cuní cachàmà. ");
INSERT INTO mitNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Dandu nì càhàn tu Jesús xì nèhivì yucán, cachí‑yà: ―Palabra ndàcuisì nduá yohó: na iin yehè ndé quíhvi riì, ducán nduú yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nsidaa ana nì quixi antes, tècuìhnà xínduu‑tè, te cutu cuní‑te quidacuihna‑té riì xí. Doco nèhivì nduú nahi riì xí, cónì ndúlócô‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Te (nacua nì cachì) ñà‑nahi yehè nduí, ñàyùcàndùá, sàhà yùhù vàtùni quìhvi nèhivì, te nìhì‑né salvación xi‑ne, dandu después cucumi‑né vida ndiaha xí‑né, na iin riì sáhàn ndé iá cuàhà pastu, dandu màndixi tu‑sì corra‑si. ");
INSERT INTO mitNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Iin tècuìhnà, cutu quixí‑te ñà‑quidacuihna‑té ñà‑ndùá icúmí‑ndá, te ò cahnì‑téndô, te ò quida quini‑tè xì‑ndà. Doco yùhù, còó, sàhà ñà‑cui nìhìtáhvì nèhivì cutiacu ndiaha‑né nicanicuahàn, ñàyùcàndùá nì quesaì (ñuhìví yohó). ");
INSERT INTO mitNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yùhù nduú ndise pastor vàha. Te sáhi vida xi sàhà‑ñá nìhì nèhivì nduú nahi riì xí cutiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Doco dava tè‑ndiàá xì riì, peón‑ni nduú‑te, te mà úhì nacoo‑tèsí, vàchi có‑ndùú ndisa‑tè pastor xi‑sì; có‑ndùú‑te meru stohò‑si. Ñàyùcàndùá nú nì xinì‑te vàxi nsìvòhú, dandu nacóó nihni‑tèsí, te xinúdèhé‑te; dandu tnií quisì mà‑sí, te xítià nihni nsihi‑sì. ");
INSERT INTO mitNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Te ¿índù chuun xinúdèhé tèmà? Pues divi sàhà‑ñá nduú‑te peón‑ni, te có‑ndùlócô‑te sàhà‑sí. ");
INSERT INTO mitNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Doco yùhù, pastor vàha ndisa nduí, te ináhá vâhi nèhivì xí. Te mii‑né, ináhá stná‑nè yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Na ináhá Yuamánìˊ yùhù, ducán ináhá stnáì mii‑yá. Te yùhù, vida xi sáhi sàhà‑ñá càcu nèhivì xí, vàchi nahi riì xí xínduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Te ndoó gá más nèhivì nduú nahi riì xí. Te mate diín xaan ndoó‑né vichi, doco icúmî cùhìn cundaqui‑nè ndixi; dandu cunchicùn‑nè yùhù, te iin‑ni nacuatnahá‑né xì nsidaa gá ana nduú riì xí; te mindaa yùhù cundiaì‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Yùhù icúmî cuàhi vida xi, te nú sànì nsihi nì cuu ducán, dandu icúmî naquihin tuià. Sahájàn cuú ini Yuamánìˊ sàhí. ");
INSERT INTO mitNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Cunaha‑nsiá, còò ni‑iin cui quindiaa xì vida xi. Voluntad xi mií cuàhià. Vàtùni cuàhià, te vàtùni danátiácúì mií, vàchi ducán nì nìhìtáhvìˊ nùù Yuamánìˊ; divi ducán nì cachi‑yà xìˊ ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Daaní, nècuàchì ladu Judea mà, nì tàhndè dava‑ne sàhà ñà‑ndùá nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Cuàhà‑né nì (cahíchì ini‑nèyà), cachí‑nè: ―Iin ñà‑malu inácáá ini tè‑jaàn. Tè‑loco nduú‑te. ¿Índù chuun ndulócô‑nsià sàhà‑té? ");
INSERT INTO mitNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Doco dava ga‑nè nì cachi‑nè: ―Còó, màdì iin nècuàchì inácáá ñà‑malu nduú nècuàchì cáhàn ducán. ¿A tuxí ini‑nsià cui dandúvàha ñà‑malu iin nècuàchì cuaá? ");
INSERT INTO mitNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Daaní, nì sàà quìvì nducahnú ñà‑nì xìnu veheñùhu cahnú. Tiempu vìxin nì sandua, te iá tu Jesús ñuu Jerusalén, xicánúú‑yá patiu veheñùhu ma ndé nani Portal de Salomón. ");
INSERT INTO mitNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Te yucán nì sàà stná itnii nècuàchì raza‑yà Judea, cachí‑nè xì‑yá: ―¿Nadaa ga tiempu cuàhàn‑ní chidèhé gà‑ní ana nduu‑ní? Nú ndisa mii‑yá nani Cristu nduu‑ní, cachi ndàà‑ní xì‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dandu nì cachi Jesús: ―Sànì cachì xì‑nsiá, doco có‑xìníndísâ‑nsiá. Nì ndacùcahín quìvì Yuamánìˊ, te nì quide cuàhà milagru. Xì ñà‑jaàn vàtùni cundaà ini‑nsià ana divi nduí. ");
INSERT INTO mitNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Doco mii‑nsiá, có‑xìníndísâ‑nsiá, vàchi có‑ndùú‑nsiá ana nduú riì xí, nacua nì cachì xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Vàchi nèhivì nduú nahi riì xí, iníní‑né na cáhìn xì‑né. Te ináhî‑nè, te nchícùn‑nè yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Te sáhi‑nè vida ndiaha nicanicuahàn, te mà nunca sàà ndañuhu anima‑nè, ni còò iin tavà xì‑né nùù ndahìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Vàchi nùù Yuamánìˊ nì nìhí nèhivì nduú nahi riì xí, te còò cá ana chicá fuerte nùù mii‑yá; còò iin cui dandáñúhú‑xí‑nê nùù ndahà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Te yùhù xì Yuamánìˊ, iin‑ni xínduu‑nsi ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ñàyùcàndùá, nècuàchì raza‑yà yucán, nì dàtàcá tu‑ne yùù ñà‑caniyuu‑néyà, te cahnì‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dandu nì cachi‑yà xì‑né: ―Cuàhà gá obra vàha sànì quide nì xini‑nsià. Te nsidaa obra mà nduá nì nìhìtáhvìˊ nùù Yuamánìˊ. Pues ¿índù obra xi (có‑ndiàá), te sàhámà cuní‑nsià cahnì‑nsiá yùhù? ");
INSERT INTO mitNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dandu nì cachi nècuàchìmà xì‑yá: ―Còó, màdì sàhà ñà‑nì quìdà‑ní obra cuní‑nsì cahnì‑nsí mii‑ní; còó. Sàhà ñá‑nì cachì‑ní iin cuàchi, ñàyùcàndùá ndiá ìcà‑nsí caniyuu‑nsí mii‑ní, vàchi cuní‑nî ndudava‑ní xì Dios, te nèhivì ùún nduu‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dandu nì cachi Jesús xì‑né: ―Pues, ¿nansa divi cachí nùù tutu nduú ley xi‑nsia? Dohó cacháˋ: “Nahi dios xínduu‑nsia, cachíˋ”. ");
INSERT INTO mitNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Pues, ducán cacháˋ sàhà nèhivì sànaha ma, mate cuisì nèhivì ùún nì inini razón xi Dios nduú‑né, doco nahi dios nduú‑né, cacháˋ, te ináhá‑ndá, siempre ñà‑ndácuisì nduá cachí tutu ìì. ");
INSERT INTO mitNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Doco yùhù, mate ní nìhí iin chuun ìì nùù Yuamánìˊ, te nì techuún‑yá yùhù nì quesai ñuhìví yohó, doco cachí‑nsià iin cuàchi nduá ñà‑càchíˋ nduí Dèhemanì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Cuisì cundehè‑nsiá obra quidé, te nú có‑ndùá nahi obra quidá stná Yuamánìˊ, dandu màsà cúníndísâ‑nsiá yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Doco nú dava‑ni iá obra quidé xì obra quidá stná mii‑yá, dandu xiñuhu cunindisá‑nsiá. Te mate có‑xìníndísâ‑nsiá yùhù, doco siquiera cunindisá‑nsiá milagru quidé, dandu vàtùni sàà‑nsià cundaà ini‑nsià, te cunindisá stná‑nsià ñuhú saín vida xi Yuamánìˊ anímè, te ñuhú saín stná vida xi yùhù ini mii‑yá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dandu nsidaa nècuàchì yucán, tucutu nì cuni‑nè tnii‑neyà, doco nì càcu‑ya nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Daaní, inga xichi cuàhàn‑yà inga ladu yùte Jordán ndè lugar ndé nì saquida iì Juan (Bautista) nèhivì. Te nì cuee chii‑yá yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ñàyùcàndùá, cuàhà nèhivì nì casaà stná nùù‑yá yucán, vàchi dohó cachí‑nè: ―Còò milagru nìsá quídá Juan (Bautista), doco nsidaa ñà‑ndùá nì cachitnùhu‑ne sàhà Jesús, divi ñà‑ndáà nduá, (sànì xini‑nsì) ―nì cachi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Te tiempu iá‑yà lugar yucán nì xinindisá cuàhà nèhivì mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Daaní, después nì quicuehè iin nècuàchì ñuu tii Betania nani Lázaro. Te divi ñuu yucán ndoó stná ùì cùha‑ne, iin‑ne nani María, te inga‑nè nani Marta. Te María mà nduú nècuàchì (nì sàà nùù Jesús después), te nì dàcùchí‑né tàtnà tnàmì sàhà‑yá, dandu nì nsida ìchí‑nèà xì idìdínì‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pues divi cùha Lázaro mà nduú ana nì catechuún iin razón nùù Jesús, cachí‑nè xì‑yá: ―Stoho‑nsì Señor, cuhí vàha nècuàchì mànì guá nùù‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ñàyùcàndùá, (nì sàà razón mà ndé iá‑yà); doco na ní tiacu‑yà palabra mà, dandu nì cachi‑yà: ―Cuèhè jaàn, có‑ndùá cuèhè ñà‑cui‑ndà, cuisì iin cuèhè ñà‑naquimanì cuáhà‑ndà Dios nduá, te quee cuàhà stná tnùñuhu xí Dèhemanì‑yá ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Cunaha‑nsiá, mànì cuáhà Marta xì cùhì‑nè xì cùha‑ne nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Doco na ní xinitnùhu‑ya cuhí nècuàchìmà, nì cuee chii gá‑yà ùì quìvì lugar yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dandu nì cachi‑yà xì nècuàchì dacuahá‑yá: ―Vichi cúhùn tu‑nda ladu Judea. ");
INSERT INTO mitNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Te nì cacachi nècuàchìmà xì‑yá: ―Maestro, ¿a cuní tu‑ní cùhùn‑ní yucán? vàchi nècuàchì ladu mà, cuàhàn‑nè cahnì‑né mii‑ní xì yùù nì cùí, te tàyáha cuàhà quìvì. ");
INSERT INTO mitNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Dandu nì cachi‑yà xì‑né: ―Ùxìn ùì hora nchií orá nùù‑ndà, ñàyùcàndùá mà úhì cacanuu‑nda ndui, te mà cáquìhi sàhà‑ndà, vàchi tnúù nùù‑ndà ñuhìví yohó. Te ducán iá stná xì nsidaa ana datnúù ndiaha (Dios) anima‑xi, (mà yúhî‑nè). ");
INSERT INTO mitNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Doco tucu iá nú xica‑nda ñuú, mà úhì nàcasàn‑ndà. Te divi ducán iá stná xì nèhivì có‑dàtnúù Dios ini anima‑xi. ");
INSERT INTO mitNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Na ní nsihi nì cachi‑yà ducán, dandu nì cachi gà‑yà xì‑né: ―Quídì amigo xi‑nda Lázaro. Ñàyùcàndùá, cùhìn dansícuìhnu inì‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dandu nì cachi nècuàchì dacuahá‑yá: ―Vàtùni Stoho‑ndà Señor, vàchi nú quídì uun‑ne vichi, ádi vàtùni nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ducán nì cachi‑nè, vàchi tuxí ini‑nè cáhàn‑yà sàhà ñà‑quídì‑ndà na quetátú‑ndà; doco còó, sàhà ñà‑xíhì‑ndà cáhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ñàyùcàndùá, chicá claru nì càhàn‑yà xì‑né, cachí‑yà: ―Cunaha‑nsiá, sànì xìhì Lázaro. ");
INSERT INTO mitNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Te mate có‑ìéˋ xì‑né (na ní xìhì‑nè), doco vàtùni, vàchi chindeámà ñà‑sàà‑nsià cunindisá ndisa‑nsia. Pues vichi cúhùn‑ndà ndé iá nsìi ma ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Te yucán iá stná iin nècuàchì dacuahá‑yá nani Tomás. Cuatí cachí nèhivì xì‑né. Te vichi nì cachi‑nè xì nsidaa gá compañeru‑nè: ―Cúhùn stná‑ndà xì‑yá, te cui‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Daaní, (nì quihin nsidaa‑né ichì cuáhàn‑nè xì‑yá), te nì sàà‑nè ñuu tii Betania ndé iá nsìi ma, te nì xinitnùhu‑ne sàcuàhàn‑ndà cùmì quìvì inácáá‑ndà cueva ndé índùxin‑nda. ");
INSERT INTO mitNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Cunaha‑nsiá, yatni iá stná ñuu cahnú Jerusalén ndé nduú ñuu tii ma, nahi dava hora caca‑nda, ");
INSERT INTO mitNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","(te yucán ndoó cuáhà) nècuàchì raza Judea. Ñàyùcàndùá, nì casaà stná cuàhà nècuàchìmà ndé iá Marta xì María, cuní‑nè nacuàhandee ini‑nè nècuàchìmà sàhà nsì‑cùha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Daaní, na ní xinitnùhu Marta sànì quesaa Jesús, dandu cuàhàn‑nè nànchìcùn‑nèyà. Doco María, nì ndòo‑ne vehe. ");
INSERT INTO mitNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Te na ní sàà Marta ndé iín‑yá, dandu nì cachi‑nè xì‑yá: ―Señor mío, nú ni ía‑ní yohó nì cùí, dandu mà cúí cùhe. ");
INSERT INTO mitNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Doco yùhù ináhî, nsidaa ñà‑ndùá ni cácàn tàhvì‑ní nùù Dios vichi, seguru cuàhatahvì‑yá mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Dandu nì cachi Jesús xì‑né: ―Icúmí cùha‑ní natiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Dandu nì cachi Marta xì‑yá: ―Yùhù ináhî, icúmí‑nê natiacu‑nè na sáà xìnu tiempu, te natiacu nsidaa nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dandu nì cachi Jesús xì‑né: ―Yùhù nduú ana danátiácú xì nèhivì, te sáhatahvì stnáì vida ndiaha. Ana càhvì xìˊ, mate sànì xìhì‑nè, doco icúmí‑nê natiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Te nsidaa ana itiácú, te xiníndísâ‑né yùhù, mà nunca sàà‑nè cui ndisa‑ne. ¿A xiníndísá‑nî ñà‑jaàn? ");
INSERT INTO mitNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Dandu nì cachi‑nè xì‑yá: ―Jaan, Señor mío; yùhù xiníndísê ñà‑mii‑ní nduu‑ní Cristu Dèhemanì Dios, te ndè inga ñuhìví nì quee‑ní nì quesaà‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ducán nì cachi‑nè, dandu mànuhù‑né vehe‑ne, te nì cana dèhé‑nè cùhì‑nè, cachí‑nè xì nècuàchìmà: ―Sànì quesaa maestru Jesús, te caná‑yá mii‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ñàyùcàndùá, na ní tiacu María ñà‑jaàn, dandu luegu nì ndacuiin‑nè cuàhàn‑nè ndé iá‑yà, ");
INSERT INTO mitNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","vàchi tàñáha ga sàà‑yà meru ini ñuu mà, iá va‑ya ndé nì ndacùhun tnahá‑yá xì Marta. ");
INSERT INTO mitNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Daaní, nècuàchì raza Judea ndoó nácuàhandee xi ini María vehe‑ne, nì xini‑nè na ní ndacuiin yàchì nècuàchìmà cuàhàn‑nè, ñàyùcàndùá, nì tenchicùn stná‑nè cuàhàn‑nè, cachí‑nè: ―Ádi cuáhàn nècuàchì jaàn ndé índùxin nsìi ñà‑coo‑ne cuacu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Dandu nì sàà María ndé iá Jesús. Te nì sàcuììn sìsì‑né nùù‑yá, cachí‑nè: ―Señor mío, nú ni ía‑ní yohó nì cùí, dandu mà cúí cùhe. ");
INSERT INTO mitNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Daaní, na ní xini Jesús sacú María, te sacú stná nèhivì cutnáhâ xí‑nê, dandu nì sàcàn fuerte ini‑yà, te nì cutàsi ini‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dandu nì cachi‑yà xì nèhivì yucán: ―¿Índù índùxin nsìi? Te nì cachi‑nè xì‑yá: ―Cúhùn‑ndà cundehè‑ní, Stoho‑nsì Señor. ");
INSERT INTO mitNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dandu nì sacu stná‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Te sàháyùcàndùá nì cacachi nècuàchì raza‑yà (nì quixi Jerusalén): ―Cundehè‑nsiá na cuahà guá cuú ini‑yà sàhà nsìi ma. ");
INSERT INTO mitNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Doco dava nèhivì yucán, nì (xitnùhu‑ne), cachí‑nè: ―Dècuèndè iin nècuàchì cuaá nì dànátùi Jesús yohó nùù‑xí. ¿Índù chuun mànìcùí dandúvàha‑ne nècuàchì nsìi yohó sàhà ñà‑màsà cúí‑nè nì cùí? ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Daaní, cuàhàn‑yà xì‑né te nì sàà nsidaa‑né dècuèndè ndé índùxin nsìi ma. Cueva nduá, te ndiadí iin cavà cahnú yehá. Te mii‑yá, sácàn ndee ini‑yà nì sàà‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Dandu nì cachi‑yà xì nèhivì yucán: ―Dìtá‑nsià cavà jaàn. Doco nì càhàn Marta, cùha nsì‑Lázaro, cachí‑nè: ―Señor mío, sàcuàhàn‑ndà cùmì quìvì vichi; ádi sàsàhán quini nsìi jaàn. ");
INSERT INTO mitNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dandu nì cachi‑yà xì‑né: ―Sànì cachì xì‑ní cuisì xiñuhu cunindisá vàha‑ní, dandu cunì‑ní ñà‑ndiaha guá quidá Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ñàyùcàndùá, nì dìtá nèhivì mà cavà ndiadí yehè cueva mà. Dandu nì ndacoto ndiaá‑yà dìquì‑xí, te nì cachi‑yà: ―Ansivéhé‑nî, Yuamánìˊ, vàchi nì inini‑ní ñà‑ndùá nì xìcàn tàhví nùù‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Te ináhî, ducani iníní‑nî yùhù na xícàn tàhví nùù‑ní, doco ducán cachíˋ xì‑ní vichi sàhà‑ñá ni cúníní nèhivì itá yohó, te cunindisá‑né mii‑ní ñà‑ndùù‑ní ana nì techuun‑xí vàxi ");
INSERT INTO mitNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","―nì cachi‑yà. Dandu nì ndàhì ndee‑yá, cachí‑yà: ―¡Lázaro! ¡Quee‑ní, nahà‑ní! ");
INSERT INTO mitNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dandu nì natiacu nècuàchì nsìi ma nì quee‑ne cueva, idáducún íì‑né sìcoto. Te nuhní stná ndahàsáhà‑né, te nùù‑né, ídàhvi stná iin sìcoto. Dandu nì dàndàcú‑yá nùù nèhivì itá yucán, cachí‑yà: ―Nacanì‑nsiànè, te ni cacá‑né ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ñàyùcàndùá, cuàhà nècuàchì raza Judea yucán, nì xinindisá stná‑nèyà na ní xini‑nè nansa nì quida‑ya. Divi nèhivì nì sàhàn vehe María nàcòtò xì nècuàchìmà xínduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Doco dava ga nèhivì yucán, mànuhù‑né, te nì cachitnùhu‑ne xì nècuàchì fariseu nansa nì quida‑ya. ");
INSERT INTO mitNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ñàyùcàndùá, nì nataca nècuàchìmà xì dùtù xícusahnú, te nì ndatnuhu tnahá‑né, cachí‑nè: ―¿Ndíà quida‑nda? vàchi cuàhà gá milagru quidá Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Te nú ni nácóó uun‑ndané, dandu icúmí nsidaa nèhivì cunindisá‑né nècuàchìmà. Te nú ducán, dandu caquixi tè‑romanu, dacaá‑te veheñùhu xi‑nda, te dandutu stná‑te nsidaa‑nda ñuu‑ndà yohó ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dandu nì càhàn iin tiàa nani Caifás, divi nècuàchì nduú dùtù cusáhnû cuìà yucán. Te dohó nì cachi‑nè: ―Mii‑nsiá, có‑cùndáà ini‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Có‑sânìhì inì‑nsia ñà‑nùù ndohó chicá vàha quea nú ni cuí imindaa nèhivì sàhà ñuu‑ndà yohó, te màdìá ndañuhu nsidaa‑nda ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Doco Caifás mà, màdì inì‑ni mii‑né nì chitnùní ini‑nè cachi‑nè ducán; còó, vàchi sàhà‑ñá nduú‑né dùtù cusáhnû cuìà yucán, ñàyùcàndùá Dios nì dàchítnùní ini‑yànè cachi‑nè ducán sàhà Jesús ñà‑ìcúmí‑yâ cui‑yà sàhà nèhivì ñuu‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Te màdì cuisì sàhà nèhivì ñuu‑yà. Còó, vàchi icúmí stná‑yà cundaca‑ya nsidaa nèhivì nduú dèhe ndisa Dios, te danátácá‑yànè ñà‑cundoo‑ne iin‑ni cahnú‑ní, mate vichi xíndoo‑ne inicutu ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Cunaha‑nsiá, ndè quìvì yucán nì quesaha tè‑xídandacú ñuu mà ndatnuhu stnahá‑te nansa quida‑tè ñà‑cahnì‑téyâ. ");
INSERT INTO mitNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ñàyùcàndùá, cónì xícanuu vate gá‑yà mahì nèhivì raza‑yà yucán, còó. Nì quee‑ya cuàhàn‑yà inga ñuu nani Efraín, iin ñuu indúhu yatni ndé nduú puru yucù. Te yucán nì ìa chii‑yá xì nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Daaní, quìvì yucán sà‑ìtúú nacava iin vicò nani vicò pascua, nduámà iin vicò siempre nsidácáhnû nècuàchì raza Judea yucán. Ñàyùcàndùá, cuàhà nèhivì nì quee ñuu cuati vàxi ñuu Jerusalén sàhà ñà‑nduhiì‑né antes sàà vicò mà. ");
INSERT INTO mitNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Te itá nècuàchìmà veheñùhu cahnú ndatnúhú‑nê, ndácàtnùhù stnahá‑né nùù‑né a quixi stná Jesús vicò mà, á coó, cachí‑nè iin‑ne xì inga‑nè: ―¿Nansa tuxí inì‑nsia? ¿A quixi‑ne, á coó? Ádi mà quíxí‑né cahan‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Cunaha‑nsiá, sànì quee iin orden nùù dùtù xícusahnú, xì nùù nècuàchì fariseu, cachí‑nè xì nsidaa nèhivì ñà‑ìcúmí‑nê cachitnùhu‑ne índù iá‑yà, nú ináhá‑nê, sàhà‑ñá cùhùn nècuàchìmà tnii‑neyà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Daaní, cumánì gá ìñù quìvì cunduu vicò pascua, dandu nì sàà Jesús ñuu tii Betania, divi ñuu ndé iá nècuàchì nì dànátiácú‑yà nani Lázaro. ");
INSERT INTO mitNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Te ñuu mà nì quida stná nèhivì iin vicò tìì sàhà‑ñá cundoo‑ne cuxi‑ne xì‑yá. Te vicò mà nì chindee stná Marta, nì quida‑ne chuun yuhùnùhú. Te iá stná Lázaro yucán mahì nèhivì cutnáhâ xí‑yâ xixí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Daaní, nì sàà stná María yucán, nihí‑né dava litro ñà‑tnami nani nardo, finu cuàhà‑té, te yàhvi gà‑te. Te nì dàcùchí‑nète sàhà‑yá, dandu ni nacuaha‑nète xi idìdínì‑né. Te inicutu vehe nì nacutu dico tnami‑té. ");
INSERT INTO mitNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Doco yucán iá stná iin nècuàchì dacuahá‑yá nani Judas Iscariote, divi dèhe Simón, te nduú stná‑nè tiàa icúmí dicò xì‑yá después. Te dohó nì cachi‑nè: ");
INSERT INTO mitNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Índù chuun cónì cúyàhvi ñà‑tnami jaàn chicá vàha ni cuí? Vàchi vàtùni tùi ùnì cientu dìhùn plata sàhà ñà‑jaàn, te dasàn‑ndàñá nùù nècuàchì ndahví. ");
INSERT INTO mitNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ducán nì cachi nècuàchìmà, doco màdì ndisa nècuàchì ndahví cuhí ini‑nè; (mii‑né cuhí ini‑nè), vàchi iin nècuàchì cuìhnà nduú‑né. Te ndahà‑né iá itni dìhùn xí nsidaa nècuàchìmà, te tùha stná‑nè cuida cuihna‑né dìhùn ñuhuma. ");
INSERT INTO mitNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ñàyùcàndùá, nì cachi Jesús xì‑né: ―Nacoo‑ní nècuàchì ñahà yohó, vàchi sàhà‑ñá sà‑ìtúú quìvì cundùxin, ñàyùcàndùá nì chivàha‑ne ñà‑tnami yohó, te vichi nì xichuún‑néà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nècuàchì ndahví, nicanicuahàn ndoó‑né yohó, doco yùhù, còó, sacù‑ni quìvì iéˋ xì‑nsiá ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Daaní, cuàhà gá stná nècuàchì raza Judea, nì sàà stná‑nè ñuu tii Betania mà na ní xinitnùhu‑ne yucán iá‑yà. Doco màdì cuisì mii‑yá cuní‑nè cundehè‑né, còó. Stná Lázaro cuní‑nè cundehè‑né, vàchi sànì natiacu nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ñàyùcàndùá, dècuèndè stná nècuàchìmà cuní stná dùtù xícusahnú cahnì‑né, te sàhámà nì quesaha‑né ndatnúhú tnahá‑né (nansa quida‑ne). ");
INSERT INTO mitNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Vàchi sàhà Lázaro cuàhà nèhivì ladu Judea mà cuní‑nè yàha‑ne ladu xi Jesús ñà‑cunindisá stná‑nèyà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Daaní, nì yàha inga quìvì. Te nèhivì cuáhà sànì quesaa ñuu Jerusalén chivàha xi vicò mà, nì xinitnùhu‑ne ñà‑ìcúmí Jesús quesaa stná‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ñàyùcàndùá, nì sahnde‑nè ndahà nù‑ñúù, te nihí‑nènu nì quee‑ne cuàhàn‑nè dècuèndè ndé vàxi‑ya, cána ndee nsidaa‑né, cachí‑nè: ―¡Viva! ¡Ndiaha gá nècuàchì yohó, vàchi cuenta xi Stoho‑ndà Señor vàxi‑ne! ¡Ndiaha gá‑nè, vàchi cuàhàn‑nè cusahnú‑né nùù ñuu‑ndà Israel! ");
INSERT INTO mitNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Dandu nì tùi iin burru chii, te nì sàcùnùú‑yá yàtà‑sí. Ducán nì quida‑ya, vàchi dohó cachí nùù tutu ìì: ");
INSERT INTO mitNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mii‑nsiá nèhivì ñuu Sión yohó, màsà yúhî‑nsià, vàchi icúmí quesaa mii‑yá ana cusahnú nùù‑nsiá, cuindànùú‑yá iin burru chii ―cachí tutu mà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Doco nècuàchì dacuahá‑yá, có‑ìnáhá‑nê ñà‑sàhà mii‑yá cachí tutu ìì ducán. Cuisì dècuèndè después na sánì nanihì‑yá tnùñuhu ndiaha xí‑yá, dandu nì nsinuu ini‑nè, ndisa, ducán cachí tutu mà, te divi ducán nì chindee stná‑nèyà, (te nì quida ndisa‑ya) nsidaámà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Pues vichi sànì ndecoyo cuàhà nèhivì (ñuu mà) nánchìcùn xì‑yá, vàchi sànì xinitnùhu‑ne sàhà milagru cahnú nì quida‑ya na ní cana‑ya Lázaro nì quee‑ne sepultura nì natiacu‑nè. Vàchi nèhivì nì xini xì milagru mà, sànì dàcuítià‑nè cuentu inicutu. ");
INSERT INTO mitNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Daaní nì xini nècuàchì fariseu ñà‑cuàhà guá nèhivì nì ndecoyo, te nì ndatnuhu tnahá‑né entre mii‑né, cachí‑nè: ―¡Jaàn xiní‑nsià ni‑iyuhu có‑quìdà‑ndà ganar! Cundehè‑nsiá, nsidanicuú nèhivì nchícùn xì Jesús vichi. ");
INSERT INTO mitNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Daaní, vicò mà nì sàà stná itnii nècuàchì ñuu Grecia ñà‑cahvi‑né Dios vicò mà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Te nì tnàtuu‑ne nùù Felipe, iin nècuàchì ñuu Betsaida iá ladu Galilea, te nì cachi‑nè xì nècuàchìmà: ―Señor, cuní‑nsì càhàn‑nsì xì Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dandu nì sàhàn Felipe nì cachitnùhu‑ne xì Andrés, dandu ndúì‑nè cuàhàn‑nè nùù mii‑yá, te nì cachi‑nè xì‑yá sàhà nècuàchì ñuu Grecia mà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Dandu nì naxiconihí‑yá nùù‑né, cachí‑yà: ―Vichi sànì sàà quìvì nanihìˊ tnùñuhu ndiaha xí, divi yùhù ana nduú Tnaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cunini‑nsia palabra ndàcuisì yohó: nú (cuhí ini‑ndà) iin nùnì, te sàhámà có‑chìhì‑ndàñá, dandu imindaa nùnì cundua nicanicuahàn. Doco nú sànì chihi‑ndañá, dandísá icúmíâ nducuahàˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pues ducán iá stná xì vida xi nèhivì. Nú cuhí gà ini‑nè vida xi‑ne ñuhìví yohó, dandu icúmíâ ndañuhu dahuan. Doco nú có‑cùhí ini‑nèà, dandu nicanicuahàn cucumi‑né vida ndiaha. ");
INSERT INTO mitNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Te nú nduú ndisa‑ne iin ana xinúcuáchí nùí, dandu ni cúnchícùn‑nè yùhù, te ndéni nì cui ni sáì, yucán icúmí sàà stná nècuàchìmà cutnahá‑né xìˊ. Te nsidaa ana xinúcuáchí nùí, icúmí Yuamánìˊ quidañuhu‑yánè. ");
INSERT INTO mitNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Vichi yáha ga nacání cuáhà inì. Doco ¿a cuáhìn càquìn nùù Yuamánìˊ ñà‑nì dácâcu‑ya yùhù nùù ñà‑ndùá icúmí cuu xí vichi? Còó, vàchi divi sàhà ñà‑nì cùù‑xìˊ ducán nduá nì quesaì ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Te vichi dohó cachíˋ xì Yuamánìˊ: “Tavà‑ní tnùñuhu xí‑nî cundehè nèhivì”. Dandu nì tiacu tàchì ana cáhàn ansivi, cachí‑yà: ―Sànì taví tnùñuhu xí, doco más gà‑ñà icúmí quee nùù nèhivì quìvì nùù‑xí. ");
INSERT INTO mitNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ñàyùcàndùá, nèhivì itá yucán, na ní tiacu‑nè tàchì‑yá, nì cachi‑nè: ―Dàvì ní càhàn. Te dava ga‑nè nì cachi‑nè: ―Ádi ángel nì càhàn xì Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dandu nì cachi‑yà xì‑né: ―Màdì sàhà yùhù nì cáhàn Dios ndè ansivi nì tiacu‑nsià; sàhà mii‑nsiá nduá nì càhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cunaha‑nsiá, sà‑ìtúú ndundaà sàhà nsidaa ñà‑có‑ndiàá ñuhìví yohó. Te vichi icúmí Dios tavà‑yá quisì dandacú núù ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Daaní, nú sànì chituu ducún nèhivì yùhù, dandu icúmî danátâquì cuàhà nèhivì nùí. ");
INSERT INTO mitNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Palabra mà nì cachi‑yà nahi ejemplu sàhà‑ñá cundaà ini‑ndà índù modo icúmí nèhivì cahnì‑néyà (nchìca cruz). ");
INSERT INTO mitNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Dandu nì cachi nèhivì cuáhà mà xì‑yá: ―Nsiùhù, sànì inini‑nsi nì cahvi‑ne nùù ley ìì ndé cacháˋ: “Nicanicuahàn icúmí coo mii‑yá nani Cristu”. Doco mii‑ní, cachí‑nî ñà‑ìcúmí nèhivì dananá ducún‑nè mii‑ní, (te cuì‑ní). Te cachí stná‑ní ñà‑ndùù‑ní Tnaha Nèhivì Ñuhìví. Pues ¿nansa iá (chuun quidá) iin ana nduú Tnaha Nèhivì Ñuhìví? ");
INSERT INTO mitNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dandu nì cachi Jesús xì‑né: ―Iyuhu nduú tiempu cuàhàn cutnuù ndiaha luz (xi Dios) mahì‑nsiá. Ñàyùcàndùá, nacua datnúù ndiaha‑yá nùù‑nsiá, ducán quida ndisa‑nsia cumplir vichi, vàchi (vàxi iin quìvì) vihini cuxio nsidaámà, te ndé cuisì ichì ñáa ndòo nùù‑nsiá. Cunaha‑nsiá, nú ni cacá iin nèhivì ichì ñáa, mà có‑cùndáà tnùní ini‑nè índù nùù‑xí sàà‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Doco vichi nduú meru hora datnúù ndiaha‑yá luz (xi‑ya) nùù‑nsiá, ñàyùcàndùá cunindisá‑nsiá sàhà‑ñá sàà‑nsià cunduu‑nsia dèhe mii‑yá ana datnúù ndiaha xi‑nsiá ―nì cachi‑yà. Dandu nì quecuaán‑yá iin xaan ndé mà ndácùhun nècuàchìmà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mate cuàhà milagru nahnú nì quida‑ya nì xini nèhivì, doco cónì sáà‑nè cunindisá‑néyà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","39","Te ducán nì cuu ndisa ñà‑ndùá nì tiaa profeta sànaha nani Isaías, vàchi dohó nì cachitnùhu ndómà: Stoho‑nsì Señor, sacu nèhivì nì xinindisá ñà‑ndùá nì cachi‑nsì xì‑né, mate cuáhà gá sànì quida‑ní milagru fuerte, nì cachi ndómà. Ñàyùcàndùá, mànìcùí gá cunindisá nèhivì (raza‑yà), vàchi dohó nì tiaa stná Isaías mà (ñà‑ndùá nì cachi Dios) sàhà‑né: ");
INSERT INTO mitNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Sànì dàcuàí anima‑nè, te quidámáxìní‑nè quidé. Ñàyùcàndùá, có‑cùní‑nè cundehè‑né ichì yùhù, ni có‑cùní stná‑nè mànìhì ini‑nè, ni có‑cùní stná‑nè natnahnù‑nè (ichì váha), te ducán nsida viìˊ anima‑nè, nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ñà‑jaàn nduá nì tiaa Isaías sànaha na ní xini ndómà seña xi Dios ñà‑ndiaha guá cuàhàn quida Jesús, te nì cachitnùhu‑nda sàhámà. ");
INSERT INTO mitNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Doco cunaha‑nsiá, cuàhà gá stná nèhivì raza‑yà nì xinindisá stná‑nèyà, dècuèndè stná cuàhà nècuàchì dandacú. Doco cónì càchí vate‑né ñà‑jaàn, vàchi nì yùhí‑nè (cuìdà ini) nècuàchì fariseu‑nè, te mà cóó gá permisu cùhùn‑nè veheñùhu. ");
INSERT INTO mitNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vàchi chicá nì cudiì ini‑nè ndee vàha‑ne nùù nèhivì ñuhìví, te màdì nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Daaní, nì ndàhì ndee Jesús, cachí‑yà: ―Nú xiníndísâ nèhivì yùhù, màdì cuisì yùhù xiníndísâ‑né; còó. Stná mii‑yá ana nì techuun‑xí vàxi xiníndísâ stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Te nú indéhe‑né yùhù, dandu indéhe stná‑nè ana nì techuun‑xí vàxi. ");
INSERT INTO mitNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Cunaha‑nsiá, sàhà‑ñá datnúì nùù nèhivì ichì cùhùn‑nè, ñàyùcàndùá nì quesaì ñuhìví yohó, dandu nsidaa ana xiníndísâ xí, mà cácá gá‑nè ichì ñáa. ");
INSERT INTO mitNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","Te nú cundáà ini iin nèhivì ñà‑ndùá cachíˋ, te có‑chîvàha‑neà, dandu icúmí ndundaà sàhà cuàchi‑ne, te nìhì‑né castigu. Doco màdì yùhù icúmí nsidandaà xì sàhà‑né. Còó, vàchi màdì sàhà‑ñá dandohí nèhivì nì quesaì ñuhìví yohó. Còó; sàhà‑ñá càcu‑ne nì quesaì. Divi palabra sànì cachì icúmí nsidandaà sàhà cuàchi nèhivì cahíchì inì‑xi, te có‑càndísâ‑né ñà‑ndùá cachíˋ. Icúmí palabra mà cachà nansa nìhì‑né castigu na sáà xìnu tiempu. ");
INSERT INTO mitNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","’Nsidaa ñà‑ndùá sànì cachì xì‑nsiá, màdì dìnì mií nì quèá; còó, divi Yuamánìˊ nduú ana nì sàcùnahí nùù‑xí; divi mii‑yá nì cachi‑yà xìˊ ñà‑ndùá cuní‑yà cachì xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Te ináhî, nú ni cúníndísâ‑nsiá ñà‑ndùá dandacú‑yá, dandu vida ndiaha cucumi‑nsiá nicanicuahàn. Ñàyùcàndùá, nacua sànì cachi‑yà xìˊ, divi ñà‑jaàn nduá cachíˋ xì‑nsiá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Daaní, nì sàà vigilia vicò pascua, te ináhá Jesús sà‑ìtúú stná quìvì icúmí‑yâ quee‑ya ñuhìví yohó nùhù‑yà ndé iá Yuamánì‑yá. Te cunaha‑nsiá, cuú cuáhà ini‑yà sàhà nèhivì xí‑yá ndoó ñuhìví yohó, ñàyùcàndùá nì (quida‑ya iñàha ñà‑cundaà ini‑ndà) yáha ga cuú cuáhà ini‑yà sàhà‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","(Vàchi divi ñuú vigilia mà) iá‑yà cudínî‑yà xì (nèhivì xí‑yá). Doco iin nècuàchìmà nani Judas Iscariote, divi dèhe Simón, sànìhnú ini‑nè cahin‑nèyà (nùù tè‑xídandacú), vàchi ducán nì dànácání ini ñà‑malu‑nè quida‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Te mii‑yá, ináhá stná‑yà sànì chitnùní ini Yuamánì‑yá ñà‑dandacú‑yá nùù nsidanicuú iñàha, te ináhá stná‑yà ñà‑nùù Yuamánì‑yá nì quixi‑ya, te después nùhù‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ñàyùcàndùá, nì nacoo‑ya ñà‑xìxí‑yá, te nì ndacuiin‑yà, nì tavà‑yá dùhnù quihín‑yà, te nì chicuhni nihni‑ya iin sìcoto caní tìxi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Daaní, nì tnii‑ya iin tina, te nì dàchìtù‑yáñà tècuìí, dandu nì quesaha‑yá nacáté‑yá sàhà nècuàchì dacuahá‑yá, te después nì nsida ìchí‑yàñà xì sìcoto cani‑ma. ");
INSERT INTO mitNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Te na ní sàà‑yà ndé iá Simón Pedro, dandu nì cachi‑nè xì‑yá: ―¿A ndisa cuní‑nî nacate‑ní sàhí, Señor mío? ");
INSERT INTO mitNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Te nì cachi‑yà xì‑né: ―Vichi có‑sânìhì inì‑ní índù iñàha nduá cuàhìn quide xì‑ní, doco vàxi iin quìvì, dandu sàà‑ní cundaà vàha inì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dandu nì cachi‑nè xì‑yá: ―¡Còó! ¡Mà nunca cuàhi nacate‑ní sàhí! Te nì cachi tu‑ya xì‑né: ―Nú màsà nácátí sàhà‑ní, mà cúí cunduu‑ní nèhivì xí. ");
INSERT INTO mitNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Te nì cachi tu‑ne xì‑yá: ―Señor mío, nú ducán nduá, dandu nacate stná‑ní ndahí xì dìní, te màdìá cuisì sàhí. ");
INSERT INTO mitNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Dandu nì cachi‑yà xì‑né: ―Cunaha‑ní, nú làcà nì xichi iin nèhivì, còò necesidad cuchi tu‑ne, vàchi sà‑ìá ndoo inicutu ìcà‑né, cuisì sàhà‑né (cúdi), te ñà‑jaàn xiñuhu ndoo. Te ducán iá stná xì mii‑nsiá vichi, sànì ndoo vàha dahuun anima‑nsià. Doco màdì nsidaa‑nsiá iá ndoo‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ducán nì cachi‑yà, vàchi ináhá‑yâ ana cuàhàn dicò xì‑yá, ñàyùcàndùá nì cachi‑yà: “Màdì nsidaa‑nsiá iá ndoo‑nsia”. ");
INSERT INTO mitNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Daaní, nì nsihi nì nacate‑ya sàhà‑né, dandu nì nàcùndixi‑ya dùhnù quihín‑yà, te nì sàcòo‑ya. Te nì cachi‑yà xì‑né: ―¿A cundáà inì‑nsia índù chuun nì quide xì‑nsiá ducán? ");
INSERT INTO mitNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pues Maestro cachí‑nsià xìˊ, te Stoho‑nsì Señor cachí stná‑nsià xìˊ. Te vàtùni iámà, vàchi divi nduí. ");
INSERT INTO mitNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Doco cunaha‑nsiá, mate maestru xi‑nsia nduí, te stoho‑nsià nduí, doco nì nacati sàhà‑nsiá. Ñàyùcàndùá, stná mii‑nsiá ndiá ìcà‑nsiá nacate stnahá stná‑nsià sàhà‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Vàchi nacua nì quide xì mii‑nsiá, divi ducán xiñuhu quida stná‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ñà‑ndáà nduá cachíˋ xì‑nsiá yohó: màsà cútúxí ini iin peón ñà‑chicá ndiaá‑te nùù lamú xi‑tè. Stná iin tè‑nìhì‑xì iin razón, màsà cútúxí inì‑te ñà‑chicá ndiaá‑te nùù ana nì techuun‑xi‑té xì razón mà. ");
INSERT INTO mitNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ñàyùcàndùá, nú sànì cundaà vàha inì‑nsia ñà‑ndáà nduá sànì cachì xì‑nsiá, te quidá ndisa‑nsia cumplir, dandu ndiaha gá cundoo‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Doco có‑câhìn sàhà nsidaa‑nsiá. Yùhù ináhî índù nèhivì sànì nacàxin. Te nacua nì cachitnùhu nùù tutu ìì, ducán ndisa sànì cuu xí, vàchi dohó cacháˋ: “Iin tiàa cutnáhâ xí na xixí, divi nduú ana sànì nanduu ana xiní ùhì xìˊ”. ");
INSERT INTO mitNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yùhù, tàñáha ga yàhi tnùndoho icúmí cuu xí, doco sànì cachitnùhi xì‑nsiá sàhà‑ñá, dandu na sáà cuu ducán, icúmí‑nsiâ cunindisá‑nsiá ñà‑divi yùhù nduú mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ñà‑ndácuisì nduá yohó cachíˋ xì‑nsiá: nú xiníndísâ nèhivì iin ana nì techuín, dandu queámà na ian sànì xinindisá stná‑nè yùhù. Te nú ducán xiníndísâ‑né yùhù, dandu cuní cachàmà xiníndísâ stná‑nè mii‑yá nì techuun‑xí vàxi ");
INSERT INTO mitNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","―nì cachi‑yà. Dandu nì quesaha‑yá cuhúún cuáhà ini‑yà, te nì cachitnùhu‑ya xì nèhivì xí‑yá yucán: ―Cunaha‑nsiá, iá iin‑nsia cuàhàn cahin xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ñàyùcàndùá nì quesaha nsidaa nècuàchìmà indéhe stnahá‑né nùù‑né, nacání ini‑nè ana divi cáhàn‑yà sàhà‑xí cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Te yatni uun diìn‑yá iá iin nècuàchì mànì guá nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ñàyùcàndùá, nì quida Pedro iin seña nùù nècuàchìmà ñà‑nì ndácàtnùhù‑né nùù‑yá ana divi cáhàn‑yà sàhà‑xí. ");
INSERT INTO mitNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dandu nècuàchìmà, chicá nì cuyatni‑ne nùù‑yá, te nì cachi‑nè xì‑yá: ―Señor mío, ¿ana divi nduú tiàa cachí‑nî? ");
INSERT INTO mitNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Dandu nì cachi‑yà xì‑né: ―Cuàhìn dandaxín iyuhu pan, te ana cuàhi, divi nècuàchì jaàn nduú‑né. Dandu nì dàndàxín‑yá pan mà, te nì sàha‑ya Judas Iscariote, divi dèhe Simón. ");
INSERT INTO mitNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Te na ní tnii nècuàchìmà pan mà, dandu nì quìhvi ñà‑malu Satanás ini anima‑nè. Dandu nì cachi‑yà xì‑né: ―Ñà‑ndùá cuàhàn‑ní quida‑ní, yàchì quida‑níà. ");
INSERT INTO mitNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Doco nèhivì dava ga cutnáhâ xí‑yâ yucán, cónì cúndáà ini‑nè índù chuun nì cachi‑yà palabra mà xì nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Dava‑ne, nì tuxi ini‑nè nì cachi‑yà ducán sàhà ñà‑ndùú nècuàchìmà ana ndiaá xì dìhùn xí nsidaa‑né, te ádi iá iñàha cùhùn‑nè cuiin‑ne ñà‑nducahnú vicò, te ò cùhùn‑nè dasàn‑né dìhùn nùù nècuàchì ndahví cahan‑né, (doco còó). ");
INSERT INTO mitNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Daaní, na ní nsihi nì tnii Judas mà pan mà, dandu vichi vichi nì quee‑ne cuàhàn‑nè; te ñuú nduá. ");
INSERT INTO mitNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na sácuàhàn Judas, dandu nì cachi Jesús: ―Yùhù ana nduú Tnaha Nèhivì Ñuhìví, vichi sànì nìhì ndise tnùñuhu xí, te sàhà stná yùhù icúmí quee ga stná tnùñuhu xí (Yuamánìˊ) Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ñàyùcàndùá, nú sàhà yùhù chicá coo tnùñuhu xí‑yá, dandu stná yùhù nìhì gá stnáì más tnùñuhu quida‑ya; te yàchì icúmí‑yâ quida‑ya ducán. ");
INSERT INTO mitNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Hijos, làcà iyuhu‑ní coo guè xì‑nsiá yohó. Vàchi nacua nì cachì xì nècuàchì raza‑ndà Judea daa, ñà‑jaàn nduá cachí stnáì xì mii‑nsiá vichi, icúmí‑nsiâ nanducu‑nsiá yùhù, doco lugar ndé cùhìn mà‑cúí sàà‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Te vichi dandacuí iin ley saa chivàha‑nsia, divi ñà‑cuu stnahá ini‑nsià sàhà‑nsiá, ñà‑jaàn nduá dandacuí; nacua cuú cuáhà inì sàhà mii‑nsiá, divi ducán xiñuhu cuu stnahá stná ini‑nsià sàhà‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Vàchi nú ni cuú stnahá ini‑nsià sàhà‑nsiá, dandu sàhájàn vàtùni cundaà ini nsidaa nèhivì ñà‑divi nèhivì xí yùhù nduú‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dandu nì cachi Simón Pedro xì‑yá: ―Señor mío, ¿índùvì cúhùn‑ní? Dandu nì cachi‑yà xì‑né: ―Vichi mà cúí cutnaha‑ní xìˊ cùhùn índù icúmî cùhìn. Doco después, dandu icúmí stná‑ní sàà‑ní yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Dandu nì cachi‑nè xì‑yá: ―Señor mío, ¿índù chuun mà cúí cutnahá stnáì xì‑ní cùhùn vichi? Vàchi cunaha‑ní, dispuestu iéˋ cuì sàhà‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Dandu nì cachi‑yà xì‑né: ―¿A ndisa dispuestu iá‑nî cuì‑ní sàhí cahan‑ní? Yùhù cachíˋ xì‑ní, te ñà‑ndáà nduá, tàñáha ga coto lehe, te sànì nacuaà‑ní yùhù ùnì xichi. ");
INSERT INTO mitNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Màsà nácání gá ini‑nsià; cuisì cunihnu ini‑nsià Dios, te cunihnu stná ini‑nsià yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ini vehe cahnú Yuamánìˊ iá cuàhà gá lugar ndé cundoo‑nda. Te nú màdì ñà‑ndáà nduájàn, dandu sànì cachì xì‑nsiá nì cùí. Doco icúmî codònùí nùù‑nsiá cùhìn sàhà ñà‑quida viìˊ ndé cundoo stná‑nsià xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Daaní, na nsihi quideàmà, dandu icúmî naxicocuíìn nàcuàqui mii‑nsiá nùhù‑ndà sàhà‑ñá cutnaha‑nda cundoo‑nda yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Te lugar yucán, sàcùndáà inì‑nsia índù iáˋ, te sàcùndáà stná inì‑nsia índù ichì sáà yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dandu nì cachi Tomás xì‑yá: ―Señor mío, có‑ìnáhá‑nsî ichì mà, vàchi có‑cùndáà ini‑nsì índù cùhùn‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Dandu nì cachi Jesús xì‑né: ―Yùhù nduí ichì mà, te nduú stnáì ñà‑ndácuisì, te nduú stnáì ana (sáha xi) vida ndiaha. Nú màdì sàhà yùhù, còò íín sáà nùù Yuamánìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Doco nú ináhá‑nsiâ yùhù, dandu ináhá stná‑nsià mii‑yá. Ñàyùcàndùá, vichi sànì xini‑nsiàyà, te sà‑ìnáhá stná‑nsiàyà. ");
INSERT INTO mitNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Dandu nì cachi Felipe xì‑yá: ―Señor mío, cuní‑nsì cundehè‑nsí Yua‑nda Dios, dandu ndòo vàha ini‑nsì. ");
INSERT INTO mitNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Dandu nì cachi‑yà xì‑né: ―Sàcuàhà gá tiempu iéˋ cutnáhî xì‑nsiá, te ¿a táñâha ga nacunì‑ní yùhù, Felipe? Cunaha‑ní, nú sànì xini‑nsià yùhù, dandu ñà‑sànì xini stná‑nsià Yuamánìˊ nduá, te còò cá necesidad cachì‑ní ñà‑cùní‑nsià cundehè‑nsiáyà. ");
INSERT INTO mitNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ádi sá‑xìníndísá‑nî ñà‑ñùhú saín vida xi ini Yuamánìˊ, te ñuhú stná vida xi‑ya ini yùhù. (Pues divi ducán nduá, te sàhámà) nsidaa ñà‑ndùá cachíˋ xì‑nsiá, màdìá inì‑ni mií ndacú ínìà, vàchi ini anímè iá Yuamánìˊ, te divi‑ya nduú ana quìdà‑xì obra ndiaha xí‑yá (xiní‑nsià). ");
INSERT INTO mitNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cunindisá‑nsiá ñà‑ñùhú vida xi ini mii‑yá, te iá stna vida xi‑ya ini yùhù. Te nú có‑xìníndísâ‑nsiá mate sànì cachì xì‑nsiá ducán, doco siquiera cunindisá‑nsiá ñà‑sànì xini‑nsià milagru ndiaha nì quide. ");
INSERT INTO mitNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ñà‑ndáà nduá cachíˋ xì‑nsiá yohó: nú xiníndísâ ndisa iin nèhivì yùhù, dandu vàtùni quida stná‑nè milagru nahi ñà‑ndùá quidé. Dècuèndè milagru chicá fuerte vàtùni quida stná‑nè, vàchi icúmî nùhì ndé iá Yuamánìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te nsidaa ñà‑ndùá nì cácàn tàhvì‑nsiá, te ndacùcahan‑nsiá quìví, icúmî quideà, dandu chicá más nìhì Yuamánìˊ tnùñuhu xí‑yá sàhà yùhù ana nduú Dèhemanì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ndéni iñàha nì cui ni cácàn tàhvì‑nsiá, te ndacùcahan‑nsiá quìví, quideà. ");
INSERT INTO mitNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Nú cuú ndisa ini‑nsià sàhí, dandu icúmí‑nsiâ chivàha‑nsia ñà‑ndùá dandacuí nùù‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Icúmî càcàn tàhvì stnáì nùù Yuamánìˊ, dandu techuún‑yá inga ana quixi chindee xi‑nsiá, te Yà‑ìcúmí quixi ma, nicanicuahàn icúmí‑yâ coo‑ya cutnahá‑yá xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Divi Espíritu Ìì xí Dios nduú‑yá, te cuisì ñà‑ndácuisì cachí‑yà. Nèhivì dava ga ñuhìví yohó, mà cúí nìhì‑né Yà‑ìì mà, vàchi có‑tùí‑yá nùù‑né, te ni có‑ìnáhá stná‑nèyà. Doco mii‑nsiá, sà‑ìnáhá‑nsiâyà, vàchi sà‑ìá‑yà cutnáhâ‑yá xì‑nsiá, te después, icúmí‑yâ yàha‑ya ini anima‑nsià coo‑ya nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yùhù, mà cuáhi ndòo penchì‑nsiá, vàchi icúmî naxicocuíìn ñà‑coi xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","’Làcà sacu tiempu, dandu mà cúní gà nèhivì ñuhìví yùhù. Doco mii‑nsiá, jaan. Vàtùni cuni‑nsià yùhù. Iin‑ni itiácuì, te sàhà ñà‑ìtiácuì, ñàyùcàndùá iin‑ni cutiacu stná mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na sáà quìvì yucán, dandu cundaà vàha inì‑nsia ñà‑iin‑ni nduí xì Yuamánìˊ, te cundaà stná inì‑nsia ñà‑sà‑ìá stná mii‑nsiá ini anímè, te yùhù, ini anima mii‑nsiá iá stnáì. ");
INSERT INTO mitNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","’Ana ináhá xí ñà‑ndùá dandacuí, te quidá‑néà cumplir, divi nècuàchìmà nduú ana cuú ndisa inì‑xi sàhí. Daaní, nú cuú ini‑nè sàhí, icúmí Yuamánìˊ cuu stná ini‑yà sàhà‑né, te stná yùhù, cuu stná inì sàhà mii‑né, te datúi nansa nduú modo xi nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Daaní, nì càhàn Judas xì‑yá, (doco inga Judas), màdì Judas Iscariote, te dohó nì cachi‑nè xì‑yá: ―Señor mío, ¿índù chuun cuisì nùù nsiùhù icúmí‑nî datúi‑ní nansa nduú modo xi‑ní? ¿Índù chuun mà quídá‑nî ducán xì dava ga nèhivì ñuhìví? ");
INSERT INTO mitNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Dandu nì cachi Jesús xì‑né: ―Nèhivì cuú inì‑xi sàhí, tùha‑ne chivàha‑ne ñà‑ndùá cachíˋ xì‑né. Dandu Yuamánìˊ, icúmí stná‑yà cuu ini‑yà sàhà‑né, te sàà‑nsì nùù‑né ñà‑cundoo‑nsi ini anima iin iin‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Doco nècuàchì có‑cùú inì‑xi sàhí, có‑chîvàha‑ne ñà‑ndùá cachíˋ. Te ñà‑ndùá cachíˋ xì‑nsiá, màdì inì‑ni mií ndacú inì cachì ñà‑jaàn. Còó, Yuamánìˊ nduú ana chítnùní inì‑xi ñà‑ndùá cachíˋ xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Cunaha‑nsiá, nsidaa ñà‑jaàn sànì cachì xì‑nsiá mientras iá ve xì‑nsiá yohó. ");
INSERT INTO mitNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Doco iá inga ana cuàhàn chindee xi‑nsiá, divi nduú Espíritu Ìì icúmí Yuamánìˊ techuún quixi cuenta xi. Te Yà‑ìì mà, icúmí‑yâ chinaha‑yà mii‑nsiá nsidaa iñàha, te dansínúú ini‑yà mii‑nsiá nsidaa ñà‑ndùá sànì cachì xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Mate cúhìn, doco sàhà yùhù vàtùni cundoo‑nsia contentu, divi nacua iéˋ contentu, ducán sáhatahvì stnáì mii‑nsiá ñà‑cundoo stná‑nsià contentu. Mà quídé na quidá nèhivì ñuhìví yohó, diín modo ndoó díì‑né. Còó, màsà nácání ini‑nsià sàhà ni‑iñàha, ni màsà yúhî‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Vichi sànì inini‑nsia nì cachì ñà‑ìcúmî nùhù xìqué, dandu naxicocuíìn. Te nú ni cuú vàha ini‑nsià sàhí nì cùí, dandísá cudiì gá inì‑nsia ñà‑nì cachì icúmî nùhì ndé iá Yuamánìˊ, vàchi chicá dandacú mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Cunaha‑nsiá, sànì cachitnùhi xì‑nsiá palabra yohó sàhà ñà‑ndùá cuàhàn cuu después, dandu quìvì cuu ndisa nacua sànì cachì xì‑nsiá, vàtùni cunindisá víi‑gá‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Pues vichi, mà cáhàn cuàhà guéˋ xì‑nsiá, vàchi sà‑vàxi mii‑sí dandacu‑xi nùù nèhivì ñuhìví yohó, te còò ni‑iñàha nduú‑si xi yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Doco ñà‑ndùá cuàhìn quide, cuàhìn quideà sàhà ñà‑cundaà ini nèhivì ñuhìví ñà‑cùú ndisa inì sàhà Yuamánìˊ, te cuníˋ quidandise ñà‑ndùá nì dàndàcú‑yá nùí. Ñàyùcàndùá, ndacuìta‑nsia cúhùn‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Ñà‑ndáà nduá, ducán iéˋ xì nèhivì‑xí na ian nducuyòhò ndèè nduí. (Te mii‑né, nahi rama‑nu nduú‑né.) Te Yuamanìˊ, nahi nècuàchì ndiaá xì‑nú nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Vàchi nsidaa ndahà nducuyòhò, nu có‑càná quisì vídìà, tàhndèà. Te nú cuàha‑sì nùù ndahà‑nú, dandu táhndè ndodò iin ian ndundoa sàhà‑ñá chicá más quisì vídì cana. Ducán nduú modo quidá stná Yuamánìˊ xì nsidaa nèhivì nihnú vàha ini xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ñàyùcàndùá, stná mii‑nsiá, sànì ndundoo stná anima‑nsià ñà‑sànì càhìn xì‑nsiá palabra ndiaha. ");
INSERT INTO mitNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Te vichi, iin‑ni ni cúníhnú vàha ini‑nsià yùhù, dandu icúmí coo stná vida‑xi ini anima‑nsià, vàchi ducán iáˋ na iin ndahà nducuyòhò, nú có‑ìtúú gáˋ ìcà nducuyòhò ndèè mà, dandu mà cuáha ga quisì vídì. Te ducán iá stná xì mii‑nsiá, nú có‑nìhnú vàha ga inì‑nsia yùhù, dandu mà cúí quida ga‑nsià ni‑iin ñà‑vàha. ");
INSERT INTO mitNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Ñàyùcàndùá, yùhù nduí nahi nducuyòhò ndèè mà, te mii‑nsiá nduú‑nsiá nahi rama‑nu. Nú iin‑ni nihnú vàha ini‑nsià yùhù, te iá stná vida xi ini anima‑nsià, dandu vàtùni quida stná‑nsià cuàhà gá ñà‑vàha. Doco nú màsà chíndéî mii‑nsiá, mà cúí quida‑nsia ni‑iñàha. ");
INSERT INTO mitNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Doco iin nèhivì, nú có‑cùní‑nè cunihnu ini‑nè yùhù, dandu ducán cuu xi‑né na iin ndahà yutnù sànì tàhndè, vàchi dítâ‑nèà iladu ñà‑ìchà, te nú sànì ìchà, dandu danátácá‑nèà quéa ñuhu coca. ");
INSERT INTO mitNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Doco nú ndisa, nihnú vàha ini‑nsià yùhù, te iin‑ni nsinúú ini‑nsià ñà‑ndùá cachíˋ xì‑nsiá, dandísá, vàtùni càcàn tàhvì‑nsiá nùù Dios ndéni iñàha nì cui, te nìhì‑nsiáñà. ");
INSERT INTO mitNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Te nú cuàhà gá ñà‑vàha nìhì‑nsiá quida‑nsia, dandu chicá más tnùñuhu xí Yuamánìˊ quee, te sàà stná‑nsià cunduu ndisa‑nsia nèhivì nchícùn viì xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","’Cunaha‑nsiá, divi nacua cuú ini Yuamánìˊ sàhí, divi ducán cuú stná inì sàhà mii‑nsiá. Ñàyùcàndùá, iin‑ni ni cúndóó mánì‑nsiá nùí. ");
INSERT INTO mitNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Cunaha‑nsiá, nú ni chívàha‑nsia ñà‑ndùá dandacuí, dandísá, iin‑ni cundoo manì‑nsiá nùí. Vàchi yùhù, chívàha stnáì ñà‑ndùá cachí Yuamánìˊ, ñàyùcàndùá mànì guéˋ nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Nsidaa ñà‑jaàn sànì cachì xì‑nsiá sàhà‑ñá ni cúdíì stná ini‑nsià nacua cudíì ini yùhù, vàchi cuníˋ cundoo‑nsia contentu nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ñà‑yòhó nduá dandacuí nùù‑nsiá, ñà‑nì cùú stnahá ini‑nsià sàhà‑nsiá, nacua quidá yùhù xì mii‑nsiá, ducán cuníˋ quida stná‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","’Nú ni cuí iin nèhivì sàhà iin ana iá vàha xi‑né, dandu cundaà ini‑ndà, yáha ga cuú ndisa ini‑nè sàhà nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pues cunaha‑nsiá, nècuàchì xíndoo vàha‑xí nduú stná‑nsià nú ni quidá ndisa‑nsia ñà‑ndùá dandacuí. ");
INSERT INTO mitNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","’Vichi mà cáchí guè xì‑nsiá ñà‑ndùú‑nsiá ana xinúcuáchí uun nùí; còó, amigo‑xi cachíˋ xì‑nsiá, vàchi iin ana xinúcuáchí uun nùù lamú‑xi, có‑cùndáà ini‑nè nansa nacání ini lamú mà quida‑ne. Doco yùhù, claru sànì cachì xì‑nsiá nsidaa ñà‑ndùá nì cachi Yuamánìˊ xìˊ, ñàyùcàndùá, náhà xìcà, amigo‑xi sàndùú‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","’Cunaha‑nsiá, màdì mii‑nsiá nì nácàxin‑nsia yùhù. Còó, yùhù nì nacàxin mii‑nsiá, te nì chitnùní inì ñà‑cùhùn‑nsià, quida‑nsia cuàhà ñà‑vàha. Te obra quida‑nsiamà, mà ndútâ. Dandu nsidaa ñà‑ndùá ni cácàn tàhvì‑nsiá nùù Yuamánìˊ, te ndácùcahan‑nsiá quìví, seguru nìhì‑nsiáñà. ");
INSERT INTO mitNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","’Ñà‑yòhó nduá dandacuí nùù‑nsiá, ñà‑nì cùú stnahá ini‑nsià sàhà‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Na xiní‑nsià xiní ùhì nèhivì ñuhìví mii‑nsiá, dandu xiñuhu nsinuu ini‑nsià ñà‑dihna yùhù nì xini ùhì stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Doco nú iin‑ni ni cúníhnú stná ini‑nsià na nihnú ini mii‑né, dandísá cuu ini‑nè sàhà‑nsiá nì cùí. Doco yùhù, sànì nacàxin mii‑nsiá nùù nsidaa‑né, te ñàyùcàndùá xiní ùhì‑nènsià, vàchi có‑nìhnú gá ini‑nsià nahi mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Doco xiñuhu nsinuu inì‑nsia nansa nì cachì xì‑nsiá daa, ñà‑màsà cútúxí ini iin peón ñà‑chicá ndiaá‑te nùù lamú xi‑tè. Vàchi nú sànì quida quini nèhivì xì yùhù, dandu stná mii‑nsiá icúmí‑nê quida quini xi‑né. Te nú ni chívàha‑ne ñà‑ndùá nì cachi yùhù nì cùí, dandísá chivàha stná‑nè ñà‑ndùá cachi mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Cunaha‑nsiá, ducán icúmí nèhivì cuni ùhì‑nè mii‑nsiá sàhà‑ñá nduú‑nsiá nèhivì xí, te sàhà stná ñà‑có‑ìnáhá‑nê mii‑yá ana nì techuun‑xí vàxi. ");
INSERT INTO mitNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Nú màsà quésáì ñuhìví yohó càhìn xì‑né, dandu mà cúnsídá cuàchi‑ne nì cùí. Doco vichi có‑nàníhì gá ini‑nè nansa cachi‑nè sàhà cuàchi nì quida‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nú có‑xìñùhù nèhivì yùhù, dandu náhà claru ñà‑có‑xìñùhù stná‑nè Yuamánìˊ nduú stná. ");
INSERT INTO mitNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Cuàhà milagru sànì quide nì xini‑nè. Mate ndoó gá nèhivì nì quida ga stná milagru, doco có‑ndùdávámà xì ñà‑ndùá sànì quida yùhù. Te nú màsà quídé milagru mà, dandu mà cúnsídá cuàchi stná‑nè nì cùí. Doco vichi sànì xini‑nè yùhù xì stná Yuamánìˊ, te ñàyùcàndùá xiní ùhì‑nè yùhù xì stná mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Doco ducán nì quida‑ne sàhà‑ñá ni cuú ndisa ñà‑ndùá cachí nùù tutu ìì xí‑né ndé cacháˋ: “Nì xini ùhì‑nè yùhù, mate còò ni‑iñàha dìsáhà‑xí nduá”. ");
INSERT INTO mitNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Cunaha‑nsiá, nú sànì nasaì nùù Yuamánìˊ, dandu icúmî techuín mii‑yá ana nduú Espíritu Ìì ñà‑quixi‑ya chindee‑yá mii‑nsiá. Te mii‑yá, puru ñà‑ndácuisì nihnú ini‑yà. Nùù Yuamánìˊ icúmí‑yâ quee‑ya quixi‑ya ñà‑datnúù ini‑yà mii‑nsiá sàhí. ");
INSERT INTO mitNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Dandu icúmí stná‑nsià càhàn‑nsià xì nèhivì sàhí, vàchi ndè quìvì primeru xicánúú‑nsiá xìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Cuàhà gá sànì càhìn xì‑nsiá sàhà‑ñá màsà náxícócuîìn ini‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Vàchi nèhivì dava ga, icúmí‑nê taxi‑né mii‑nsiá nùù veheñùhu xi‑ne. Te vàxi stná iin tiempu na cutuxi ini‑nè ñà‑cùdíì gá ini Dios nú ni cahní‑né mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Doco sàhà‑ñá có‑ìnáhá‑nê Yuamánìˊ, te ni có‑ìnáhá stná‑nè yùhù, ñàyùcàndùá icúmí‑nê quida‑ne ducán. ");
INSERT INTO mitNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Doco vichi sànì cachitnùhi xì‑nsiá sàhà nsidaájàn, te sàhámà quìvì cuu xi‑nsiá ducán, vàtùni nsinuu ini‑nsià ñà‑divi ducán nì cachì xì‑nsiá. ’Cónì càchítnùhi xì‑nsiá palabra yohó antes, vàchi yohó iéˋ cutnáhî xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Doco vichi icúmî nùhì nùù mii‑yá ana nì techuun‑xí vàxi. Te ni‑iin‑nsia có‑ndâcàtnùhù‑nsiá nùí índù cùhìn. ");
INSERT INTO mitNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Doco ñà‑nì cachì xì‑nsiá ñà‑ndùá nì cachì, ñàyùcàndùá yáha ga ndoó‑nsiá tnùnsí ini vichi. ");
INSERT INTO mitNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Doco cunaha‑nsiá, ñà‑ndáà nduá, chicá ndiaha icúmí quea nùù‑nsiá nú sàcuàhìn, vàchi nú màsà cúhìn, dandu mà quíxí mii‑yá ana icúmí chindee xi‑nsiá. Doco nú sàcuàhìn, dandu icúmî techuín mii‑yá quixi‑ya. ");
INSERT INTO mitNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te nú sànì quesaa‑yà, dandu dacúndáà ini‑yà nèhivì ñuhìví sàhà cuàchi‑ne, xì sàhà stná ichì váha, xì sàhà stná nansa icúmí ndundaà sàhà‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Claru icúmí‑yâ dacúndáà ini‑yà nècuàchìmà ñà‑ìá ndisa cuàchi‑ne ñà‑có‑xìníndísâ‑né yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Te icúmí‑yâ cachi stná‑yà xì‑né nansa iá ichì váha, vàchi yùhù, mànuhìˊ nùù Yuamánìˊ (iá ansivi), te mà cúní gà‑nè yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Daaní, icúmí‑yâ cachi stná‑yà xì‑né nansa icúmí ndundaà sàhà‑né, vàchi cunaha‑nsiá, sànì cachi Dios sàhà ñà‑malu dandacú ñuhìví yohó ñà‑ìcúmí‑sî cunsida‑sì cuàchi‑sì nicanicuahàn. ");
INSERT INTO mitNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Cuàhà gá iñàha cumánì gá cachì xì‑nsiá, doco vichi mà cúí, vàchi tàñáha ga cui mànìhì inì‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Doco después icúmí quesaa Espíritu Ìì, te mii‑yá, puru ñà‑ndácuisì nihnú ini‑yà. Te icúmí‑yâ chindee stná‑yà mii‑nsiá sàhà‑ñá vàtùni cundaà ini‑nsià nsidaa ñà‑ndùú ndisa palabra ndàcuisì. Vàchi màdì inì‑ni mii‑yá ndacu ini‑yà ñà‑ndùá cuàhàn‑yà cachi‑yà. Còó, cuisì cachi‑yà ñà‑ndùá iníní‑yá cachí (Yuamánìˊ). Te icúmí‑yâ cachitnùhu stná‑yà xì‑nsiá nansa icúmí coo quìvì vàxi xi‑nda. ");
INSERT INTO mitNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Te tavà gá stná‑yà más tnùñuhu xí; vàchi nùù yùhù icúmí‑yâ nìhì‑yá ñà‑ndiaha íì xí, te datnúù‑yà sàxìnítnùní‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Cunaha‑nsiá, nsidaa ñà‑ndùá icúmí Yuamánìˊ, divi stoho stná nduí. Ñàyùcàndùá cachíˋ xì‑nsiá ñà‑ìcúmí Espíritu Ìì mà nìhì‑yá nsidaa ñà‑ndùú ñà‑ndiaha íì xí, dandu datnúù stná‑yà sàxìnítnùní mii‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Làcà sacu tiempu, dandu mà cúní gà‑nsià yùhù. Vàchi mànuhìˊ nùù Yuamánìˊ. Doco sacù‑ni quìvì cunduamà, te cuni tu‑nsia yùhù ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ñàyùcàndùá, nì ndàcàtnùhù tnahá dava nècuàchì dacuahá‑yá‑mà nùù‑né, cachí‑nè: ―Ndíà ndùá cuní cachi‑yà ñà‑sacu gà tiempu, te mà cúní gà‑ndàyá, te inga sacu quìvì, dandu sà‑cuni tu‑ndayá, nì cachi‑yà; te cachí stná‑yà mànuhù‑yá nùù Yuamánì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pues ¿ndíà ndùá cuní cachi palabra nì cachi‑yà mà ñà‑sacu gà tiempu coo ga‑yà yohó? Có‑cùndáà ini‑ndà nansa cuní cachi ñà‑jaàn ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Daaní, Jesús, ñà‑sà‑ìnáhá‑yâ cuní‑nè ndàcàtnùhù‑né nùù‑yá sàhámà, ñàyùcàndùá nì cachi‑yà xì‑né: ―¿A cuní‑nsià ndàcàtnùhù‑nsiá nùí sàhà ñà‑ndùá nì cachì xì‑nsiá ñà‑làcà iyuhu tiempu, te mà cúní gà‑nsià yùhù, te inga sacu quìvì, dandu sa‑cuni tu‑nsia yùhù? ");
INSERT INTO mitNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ñà‑yòhó cachítnùhi xì‑nsiá: icúmí‑nsiâ cuacu‑nsia, te cundoo‑nsia tnùnsí ini (iin tiempu tii), doco nèhivì dava ga ndoó ñuhìví, còó. Icúmí‑nê cudiì ini‑nè. Doco mii‑nsiá, mate ducán ni cúndóó‑nsiá tnùnsí ini, doco después icúmí cuxio nsidaámà nùù‑nsiá, te ndudiì tú ini‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Iin nècuàchì ñahà, nú sànì sàà hora tùinuù méè xi‑ne ñuhìví, dandu yáha ga cuhúún ini‑nè, vàchi sànì sàà quìvì ndoho‑ne quidamà. Doco nú sànì tùinuù‑vé, dandu nándodó‑né sàhà dolor, vàchi cudíì gá ini‑nè ñà‑sànì quesaa inga luchi tii. ");
INSERT INTO mitNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Te ducán icúmí coo stná xì mii‑nsiá. Mate cuáhà gá cuhúún inì‑nsia vichi, doco yùhù icúmî cuni tui mii‑nsiá después, dandu cuàhà gá ndudiì tú ini‑nsià. Te ni‑iin nèhivì, mà cúí cadi‑nè nùù ñà‑jaàn. ");
INSERT INTO mitNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Quìvì yucán, mà ndácàtnùhù gá‑nsià ni‑iñàha nùí, vàchi cuisì icúmí‑nsiâ ndacùcahan‑nsiá quìví na xícàn tàhvì‑nsiá nùù Yuamánìˊ, dandu nìhì‑nsiá nsidaa ñà‑ndùá xícàn‑nsià. Palabra ndàcuisì nduájàn. ");
INSERT INTO mitNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tàñáha ga ndacùcahan‑nsiá quìví na xícàn tàhvì‑nsiá iñàha. Doco vichi ni cácàn tàhvì‑nsiá ducán, te nìhì‑nsiáñà, dandu chicá cudiì ini‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ndè vichi cuisì puru ejemplu‑ni nduá nì nacani xì‑nsiá. Doco vàxi iin quìvì, dandu mà nácání guéˋ ejemplu xì‑nsiá, vàchi claru icúmî cachì xì‑nsiá sàhà Yuamánìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Daaní, tiempu yucán màdì yùhù càcàn guè nùù‑yá sàhà‑nsiá, cachíˋ. Còó, cuisì quìvì yùhù icúmí‑nsiâ ndacùcahan‑nsiá (na cácàn tàhvì‑nsiá). ");
INSERT INTO mitNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Vàchi cuú ini‑yà sàhà‑nsiá sàhà‑ñá cuú stná ini‑nsià sàhí, te xiníndísâ stná‑nsià ñà‑nùù mii‑yá nì quixi. ");
INSERT INTO mitNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Vàchi (ñà‑ndáà nduá), nùù mii‑yá nì quixi nì quesaì ñuhìví yohó; te vichi icúmî nacoi ñuhìví yohó, te nùhì nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dandu nì cachi nècuàchì dacuahá‑yá xì‑yá: ―Vichi ndisa, claru cáhàn‑ní. Màdì ejemplu uun nduá cachí‑nî vichi. ");
INSERT INTO mitNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vitni sànì sàà‑nsì nì cundaà ini‑nsì ñà‑ìnáhá‑nî nsidanicuú iñàha. Te mate tàñáha ga ndàcàtnùhù‑nsí nùù‑ní sàhà iñàha, (doco vàtùni cachì‑ní xì‑nsí). Ñàyùcàndùá vichi xiníndísâ vàha‑nsi, ñà‑ndáà nduá, nùù Yua‑nda Dios nì quixi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dandu nì cachi Jesús xì‑né: ―¿A ndísá xiníndísâ vàha‑nsia vichi? ");
INSERT INTO mitNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Cunaha‑nsiá, vàxi iin tiempu, dandu cuìtià nihni‑nsia vehe‑nsia, te làcà mindaí nacoo‑nsia. Te vichi sànì sàà stná tiempu mà. Doco màdì ndisa ndòo mií; còó, vàchi cutnáhâ stnáì xì Yuamánìˊ. ");
INSERT INTO mitNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nsidaa ñà‑jaàn sànì cachì xì‑nsiá sàhà‑ñá ni cúndóó‑nsiá contentu ñà‑nìhnú vàha ini‑nsià yùhù. Te mate quídá quíní nèhivì xì‑nsiá na ndoó íì‑nsiá ñuhìví yohó, doco màsà cúhúún ini‑nsià sàhájàn, vàchi yùhù, sànì cundeí nùù nèhivì malu ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Na ní nsihi nì cachi Jesús nsidaájàn, dandu nì ndacoto ndiaá‑yà ansivi, te nì cachi‑yà xì Yuamánì‑yá: ―Cáhìn xì‑ní Yuamánìˊ. Vichi ndisa, sànì sàà hora. Te yùhù ana nduú Dèhemanì‑ní, xíquèn ñà‑nì tàvá‑nî tnùñuhu xí nùù nèhivì ñuhìví, dandu vàtùni quee stná tnùñuhu xí mii‑ní quide. ");
INSERT INTO mitNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Vàchi sànì chitnùní inì‑ní ñà‑ndahà yùhù cundoo nsidanicuú nèhivì. Dandu nèhivì nì chitnùní inì‑ní cunduu nèhivì xí, nìhì‑né vida ndiaha nicanicuahàn nùí. ");
INSERT INTO mitNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Te ¿índù modo nìhì‑né vida ndiaha ma? Cuisì sàhà ñà‑cunaha‑né mii‑ní xì stná yùhù Jesucristu, vàchi mii‑ní, ñà‑ndácuisì mindaa Dios nduu‑ní, te yùhù nduí ana nì techuun‑ní vàxi ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Vichi sànì dàxínui chuun nì dàndàcù‑ní nùí quide, te sàhà ñà‑jaàn sànì quee cuàhà tnùñuhu xí‑nî. ");
INSERT INTO mitNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ñàyùcàndùá, vichi xíquèn nùù mii‑ní Yuamánìˊ ñà‑coi cutnahí xì‑ní, te ducán quee más gà tnùñuhu xí; xíquèn ñà‑coi nùù‑ní xì tnùñuhu xí nacua nìsa ìe antes na táyôo ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Mii‑ní, nì nacàxin‑ní dava nèhivì ñuhìví yohó, te nì chitnùní inì‑ní ñà‑cunduu‑ne nèhivì xí. Te yùhù, sànì dàtúi nùù‑né nansa iá‑nî. Nèhivì xí mii‑ní nì sanduu‑ne, dandu nì chitnùní inì‑ní ñà‑cunduu‑ne nèhivì xí yùhù. Te vichi sànì chivàha‑ne palabra xi‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Te sànì cundaà stná ini‑nè sàhà nsidaa iñàha nì sàhatahvì‑ní yùhù, sà‑ìnáhá‑nê ñà‑nùù mii‑ní nì nìhí‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Te palabra ndiaha nì cachì‑ní xìˊ, sànì cachi stnáì‑ñà xì‑né, te mii‑né, cudíì inì‑nè xì palabra mà, te cundáà vàha ini‑nè ñà‑nùù mii‑ní nì quei vàxi, vàchi xiníndísâ‑né ñà‑divi mii‑ní nì techuun‑xí nì quesaì ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Vichi xícàn tàhví nùù‑ní sàhà‑né, màdì sàhà dava ga nèhivì ñuhìví, còó, cuisì sàhà nèhivì nì chitnùní inì‑ní cunduu nèhivì xí; vàchi nèhivì xí mii‑ní xínduu stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nsidaa nèhivì‑xí, nèhivì xí mii‑ní nduú stná‑nè. Te nèhivì xí mii‑ní, nèhivì xí yùhù nduú stná‑nè, te sàhà mii‑né sànì quee más gà tnùñuhu xí. ");
INSERT INTO mitNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Pues vichi, mà cóó guéˋ ñuhìví yohó. Icúmî nasaì nùù mii‑ní ana nduu Yua Íì Ndiahí. Doco nèhivì nì sàhatahvì‑ní yùhù, yohó icúmí‑nê candòo‑ne. Ñàyùcàndùá, sàhà poder xi‑ní cundiaà‑ní nsidaa‑né sàhà‑ñá iin‑ni cunduu nsidaa‑né nahi mii‑ní xì yùhù, iin‑ni xínduu‑nda. ");
INSERT INTO mitNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na iá ve xì‑né ñuhìví yohó, nì sandiaì‑nè xì poder xi‑ní. Te nsidaa ana nì dàyáha‑ní nùí, iin‑ni ndiaá vàhi‑nè, cónì ndáñúhú ni‑iin‑ne, cuisì imindaa tè‑de por sí icúmí ndañuhu, vàchi ducán icúmí coo sàhà‑ñá ni cuú ndisa ñà‑ndùá cachí nùù tutu ìì sàhà‑té. ");
INSERT INTO mitNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Te vichi sàmànasaì nùù‑ní. Doco ñà‑yòhó nduá cachíˋ na iá ve ñuhìví yohó sàhà‑ñá ni cúndóó nèhivì‑xí contentu nacua iá stná yùhù contentu. ");
INSERT INTO mitNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Sànì cachitnùhi xì‑né palabra xi‑ní. Doco nèhivì dava ga, xiní ùhì‑ñané sàhà ñà‑có‑nìhnú gá ini‑nè nahi nècuàchìmà. Te ducán stná yùhù, có‑nìhnú stná inì nahi nèhivì ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Te có‑xîquèn ñà‑tavà‑nínè ñuhìví yohó. Cuisì xíquèn‑ñà cundiaà‑nínè ñà‑màsà dáca ñà‑malu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yuhu, có‑nìhnú inì nahi nèhivì ñuhìví yohó, ñàyùcàndùá, stná nèhivì‑xí, có‑nìhnú gà stná ini‑nè nahi nècuàchì dava ga mà. ");
INSERT INTO mitNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","’Daaní, xícàn tàhvì stnáì ñà‑nì chínáhà‑nínè ñà‑ndùú palabra ndàcuisì, te ducán sàà‑nè cunduu‑ne nèhivì nihnú íì inì‑xi. Te palabra sànì cachì‑ní, divi ñà‑jaàn nduú ñà‑ndácuisì. ");
INSERT INTO mitNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nacua nì techuun‑ní yùhù nì quesaì ñuhìví yohó, ducán quidá stnáì, techuín mii‑né ñà‑cùhùn‑nè (càhàn‑nè xì) nèhivì ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Te sàhà ñà‑vàha xi mii‑né iéˋ dispuestu quide nsidaa chuun ìì (iá gà quide), dandu vàtùni sàà stná‑nè cunihnu ìì ini‑nè nú sànì chivàha‑ne ñà‑ndùú palabra ndàcuisì. ");
INSERT INTO mitNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Doco màdì cuisì sàhà nèhivì yohó xícàn tàhví. Còó, vàchi icúmí mii‑né càhàn stná‑nè xì nèhivì dava ga, dandu cunindisá stná nècuàchìmà yùhù. Ñàyùcàndùá, sàhà nècuàchì yucán xícàn tàhvì stnáì. ");
INSERT INTO mitNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","’Daaní, xícàn tàhví ñà‑nahi iin‑ni nèhivì ni cúndúú nsidaa nècuàchìmà, te iin‑ni ni cúndúú stná anima mii‑né xì anima ndohó, nahi mii‑ní xì yùhù, iin‑ni xínduu‑nda: iá‑nî ini anímè, te yùhù, iá stnáì ini anima mii‑ní. Ñàyùcàndùá xícàn tàhví ñà‑iin‑ni anima ni cúcúmí nsidaa‑né, dandu vàtùni cunindisá nèhivì ñuhìví ñà‑divi mii‑ní nì techuun‑xí nì quesaì ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Te nacua nì chitnùní inì‑ní ñà‑coo tnùñuhu xí yùhù, ducán sànì nìhìtáhvì stná mii‑né cucumi‑né tnùñuhu ma, dandu iin‑ni cahnú cunduu nsidaa‑né, nahi iin‑ni xínduu stná ndohó. ");
INSERT INTO mitNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mii‑ní, iá‑nî ini anímè, te yùhù, ini anima mii‑né coi; dandu iin‑ni cahnú cunduu ndisa nsidaa‑né xì ndohó. Te ducán icúmí nèhivì dava ga ñuhìví cundaà stná ini‑nè ñà‑divi mii‑ní nì techuun‑xí vàxi, te cundaà stná ini‑nè ñà‑cùú stná inì‑ní sàhà nèhivì‑xí nacua cuú inì‑ní sàhà yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Mii‑ní nduu‑ní Yuamánìˊ, te nì chitnùní inì‑ní cundoo ana cunduu nèhivì xí. Ñàyùcàndùá, yùhù cuníˋ sàà stná nsidaa nècuàchìmà cundoo‑ne ndé cuàhìn coi sàhà‑ñá iin‑ni cutnahá‑né xìˊ, te cundehè‑né nansa iá tnùñuhu ndiaha nì sàhatahvì‑ní yùhù, vàchi ndè antes na táyôo ñuhìví, iin‑ni cuú inì‑ní sàhí. ");
INSERT INTO mitNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mii‑ní, ndàcuisì nihnú inì‑ní. Doco nèhivì ñuhìví, tàcùní‑nè mii‑ní. Doco yùhù, ndisa, ináhî mii‑ní. Te nèhivì cutnáhâ xî yohó, sànì cundaà stná ini‑nè ñà‑divi mii‑ní nì techuun‑xí. ");
INSERT INTO mitNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Te yùhù, sànì dàtúi nùù‑né nansa iá‑nî nacua cuàhìn quide quìvì nùù‑xí. Ducán dandu nìhì‑né cuu stnahá stná ini‑nè sàhà‑né nacua cuú ini mii‑ní sàhà yùhù. Te ducán nìhì stná yùhù coi ini anima nsidaa‑né ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nì nsihi nì cachi‑yà ducán, dandu nì quee‑ya cuàhàn‑yà nì yàha‑ya inga ladu yui Cedrón, cutnáhâ‑yá xì nècuàchì dacuahá‑yá. Te nì yàha‑ya xì‑né mahì iin huertu iá yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Doco tiàa cuàhàn cahin xì‑yá, divi Judas, ináhá stná‑nè índù iá huertu mà, vàchi cuàhà xichi sáhàn‑yà xì nècuàchì dacuahá‑yá yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ñàyùcàndùá, nì saca nècuàchìmà itnii soldadu, te nì nìhì stná‑nè itnii policía nùù dùtù xícusahnú xì nùù stná tè‑xínduu fariseu, te cuàhàn‑nè xì nsidaa tèmà ndé nduú huertu mà. Te nsidaa‑té, iníndáhá‑tê lámpara xì nù‑ñùhú xíxìn, xì stná càa dana nduú arma xi‑tè. ");
INSERT INTO mitNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Daaní, Jesús, como ináhá‑yâ nsidaa ñà‑ndùá cuàhàn cuu xi‑yá, nì quee‑ya nì sànchìcùn‑yà tèmà, te nì cachi‑yà xì‑té: ―¿Ana divi nandúcú‑nsiâ? ");
INSERT INTO mitNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Te nì cachì‑te xi‑yá: ―Divi Jesús de Nazaret. Dandu nì cachi‑yà xì‑té: ―Yùhù nduí. Te yucán iín stná Judas, cutnáhâ‑né xì nsidaa témà. Te divi Judas mà nduú ana nì dicò xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Daaní, na ní nsihi nì cachi‑yà: “Yùhù nduí”, dandu yàchì nì naxiconihí duma candúà‑te. ");
INSERT INTO mitNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Dandu inga xichi nì cachi‑yà xì‑té: ―¿Ana divi nandúcú‑nsiâ? Te nì cacachì‑te: ―Divi Jesús de Nazaret. ");
INSERT INTO mitNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Dandu nì cachi‑yà: ―Sànì cachì xì‑nsiá, yùhù nduí. Ñàyùcàndùá, nú yùhù nchícùn‑nsià, nacoo‑nsia nèhivì xí yohó ni núhù‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ducán nì cachi‑yà xì‑té sàhà‑ñá ni cuú ndisa ñà‑ndùá nì cachi‑yà ñà‑còò ni‑iin nèhivì xí‑yá nì ndánúhú, ni‑iin nèhivì nì chitnùní ini Dios cunduu nèhivì xí‑yá, cónì ndáñúhú‑nê. ");
INSERT INTO mitNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Daaní, nì tavà Simón Pedro espada xi‑ne, te nì cani‑ne iin mozo xi dùtù cusáhnû, nì sahnde ìì‑né tùtnù nècuàchìmà ladu cuahá‑nè. Te Malco nani mozo mà. ");
INSERT INTO mitNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Doco nì cachi Jesús xì Pedro: ―Nachinacaà‑ní espada xi‑ní, vàchi yùhù, icúmî yàhi ñà‑ndùá nì chitnùní ini Yuamánìˊ cuu xí. ");
INSERT INTO mitNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dandu capitán yucán, xì soldadu xi‑tè, xì stná policía yucán, nì catnii‑tèyá nì chicuhnì‑teyá. ");
INSERT INTO mitNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Te nì saca‑tèyá cuàhàn‑te xi‑yá nùù nècuàchì nani Anás, vàchi dìdo dùtù cusáhnû cuìà yucán nduú‑né. Te Caifás nani dùtù cusahnu‑ma. ");
INSERT INTO mitNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Te divi‑ne nduú ana nì càhàn xì nècuàchì raza‑nè Judea daa na ní cachi‑nè ñà‑xìñùhù cui iin tiàa sàhà nsidaa nèhivì ñuu‑nèmà. ");
INSERT INTO mitNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Daaní, chicá cahà‑xí ndé cuàhàn Jesús vàxi stná Simón Pedro xì inga stná nècuàchì dacuahá‑yá. Te compañeru‑nèmà, ináhá‑nê dùtù cusáhnû. Ñàyùcàndùá, na ní dàyáha soldadu‑yà ini patiu vehe dùtù mà, dandu nì quìhvi stná inga‑nèmà. ");
INSERT INTO mitNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Doco Pedro, nì ndòo‑ne nùù yehè patiu‑ni ma. Ñàyùcàndùá, vàxi tu compañeru‑nè ináhá xí dùtù mà, te nì càhàn‑nè xì ñahà chìì ndiaá yehè mà áma dáyâha stná‑ña Pedro. ");
INSERT INTO mitNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dandu nì cachì‑ña xì Pedro: ―¿Amádi mii stná‑ní nduu‑ní iin nècuàchì nchícùn xì Jesús? Te nì cachi‑nè: ―Còó. ");
INSERT INTO mitNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Daaní, divi yucán itá stná mozo (xi dùtù mà) xì stná policía. Te nì xicùn‑té iin ñuhu tnùù ñà‑nadaà‑té, vàchi cúvìxin ga. Te yucán nì tnàtuu stná Pedro, iín‑né nadáà stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Daaní, dùtù cusáhnû, nì ndàcàtnùhù‑né nùù‑yá sàhà nèhivì dacuahá‑yá xì sàhà stná palabra chináhá‑yànè. ");
INSERT INTO mitNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ñàyùcàndùá, nì cachi‑yà xì‑né: ―Yùhù, vate ní càhìn xì nsidaa nèhivì ini veheñùhu cuachi, te ini stná veheñùhu cahnú ndé siempre natácá nèhivì raza‑ndà Judea. Divi yucán nduú lugar ndé siempre nìsa dacuahí nèhivì. Còò ni‑iñàha ni chínáhá dèhíˋ. ");
INSERT INTO mitNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Chicá vàha màsà ndácàtnùhù‑ní nùù mií; nùù nèhivì nì inini xi ñà‑ndùá nì cachì chicá vàha, vàchi mii‑né ináhá‑nê ñà‑ndùá nì cachì. ");
INSERT INTO mitNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Daaní, yatni ndé iín Jesús iín stná iin policía, te na ní cachi Jesús ducán, dandu nì cani‑tè nùù‑yá, cachí‑te: ―¿Índù chuun cáhàn‑ní xì dùtù ìì ducán? ");
INSERT INTO mitNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dandu nì cachi Jesús xì‑té: ―Nú cónì cáhàn viìˊ tuxi‑ní, dandu cachì‑ní xìˊ índù palabra cónì càchí viìˊ. Doco nú còò ni‑iñàha ni cáhàn quini, dandu có‑ìcúmí‑nî cani‑ní yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dandu nì dàyáha Anás mà‑yá cuàhàn‑yà ndahà dùtù cusáhnû nani Caifás. Te nuhní tnuu‑ya cuàhàn‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Doco Simón Pedro, iín stná‑nè nadáà‑né. Dandu nèhivì itá yucán, nì ndàcàtnùhù‑né nùù nècuàchìmà, cachí‑nè: ―¿Amádi mii stná‑ní nduu‑ní nèhivì xí Jesús? Dandu nì nacuaà nècuàchìmà mii‑yá, cachí‑nè: ―Còó, màdì yúhù. ");
INSERT INTO mitNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Daaní, nì càhàn inga mozo xi dùtù yucán, divi tnaha tiàa nì tàhndè tùtnù‑xí; te nì cachì‑te xi Pedro: ―¿Amádi mii‑ní nì xinì iá xì Jesús huertu yucán? ");
INSERT INTO mitNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Doco inga tu nì cachi‑nè: ―Còó. Daaní, divi momentu mà nì xito lehe. ");
INSERT INTO mitNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Daaní, nì saca‑tèyá nì caquee‑tè xì‑yá nùù Caifás, cuàhàn‑te xi‑yá ndè vehe gobernador, te yucán nì dàyáha‑tèyá ini vehe. Iín váa gá nduá. Doco tè‑xínduu raza Judea mà, cónì cá‑quìhvi‑tè vehe yucán, vàchi nú ni quíhvi‑tè, dandu mà cóó ndoo ga‑nè (nacua cachí ley xi‑ne), te mà cóó gá permisu cuxi‑tè ñà‑ndùá xixí‑te na nduá vicò pascua mà. ");
INSERT INTO mitNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Dandu Pilatu, nì quee‑tè fuera vàxi‑tè ndé itá ana nì casaà mà, te nì cachì‑te: ―¿Ndíà nduá nì quida tiàa yohó, te sanícuàchi‑nsia sàhà‑né? ");
INSERT INTO mitNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dandu nì cacachì‑te xi Pilatu: ―Nú ni cúndúú‑né iin nècuàchì cónì quìdá cuàchi ni cuí, dandísá, mà cúndácá‑nsínè quixi nùù‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dandu nì cachi Pilatu: ―Cundaca‑nsianè cuahán, te mii‑nsiá nsidandaà‑nsià sàhà‑né nacua cachí ley xi mii‑nsiá. Doco nì cacachi tè‑raza Judea mà: ―Ley (xi mii‑nsiá), có‑sâha ñà‑cahnì‑nsí iin ana iá falta xi. ");
INSERT INTO mitNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ducán nì cacachì‑te sàhà‑ñá ni cuú ndisa ñà‑ndùá nì cachitnùhu Jesús na ní cachi‑yà nansa icúmí‑yâ cui‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Daaní, nì nansìhvi Pilatu vehe‑tè, te nì cana‑tè Jesús, nì cachì‑te xi‑yá: ―Mii‑ní, ¿a ndísá rey xi nècuàchì raza Judea nduu‑ní cahan‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Dandu nì cachi Jesús xì‑té: ―¿A mii‑ní nì nacani inì‑ní ndàcàtnùhù‑ní nùí ducán, te ò inga nèhivì nì cachi xì‑ní ducán? ");
INSERT INTO mitNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Dandu nì cachi Pilatu xì‑yá: ―Yùhù, có‑ndùí iin tè‑raza‑ní Judea. Divi nècuàchì ñuù‑ní xì dùtù xícusahnú nduú ana nì dàyáha xi‑ní ndahí. ¿Índù cuàchi nì quida‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dandu nì cachi Jesús xì‑té: ―Cunaha‑ní, ñuu ndé cusáhnûí, có‑ndùá ñuhìví yohó, vàchi nú ñuhìví yohó ni cúndúá, dandísá icúmí nèhivì‑xí cuidahan‑né yùhù nùù ana xiní ùhì xìˊ sàhà‑ñá màsà yáhi ndahà nècuàchì raza Judea ni cuí. Doco ñuu ndé cusáhnûí, tucu iáˋ, mà ndúdává xí ñuhìví yohó. ");
INSERT INTO mitNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ñàyùcàndùá, nì cachi tu Pilatu xì‑yá: ―¿Àsù nduú stná‑ní iin rey cusáhnû? Dandu nì cachi Jesús xì‑té: ―Nacua cachí‑nî, divi ducán nduá, divi rey nduí. Te divi sàhà‑ñá cachitnùhi xì nèhivì ñà‑ndùú palabra ndàcuisì, ñàyùcàndùá nì quesaì ñuhìví yohó. Te vichi nsidaa ana cudíì ini xì palabra ndàcuisì mà, divi nduú stná ana cudíì ini xì ñà‑ndùá cachíˋ. ");
INSERT INTO mitNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dandu nì cachi Pilatu xì‑yá: ―¿Índù ñà‑ndisa nduú palabra ndàcuisì? Daaní, nì nsihi nì cachi Pilatu ducán, dandu nì quee‑tè inga xichi nì càhàn‑te xi tè‑xínduu raza Judea, cachí‑te xi tèmà: ―Sànì càhìn xì nècuàchì yohó, te còò ni‑iin falta ndácùhin‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Doco estilu xi‑nsia nduá ñà‑dàñà iin tè‑ndiàdí cada nacává vicò pascua yohó. Ñàyùcàndùá, vichi ¿a cuní‑nsià dàñà nècuàchì yohó cachí nduú rey xi tè‑raza‑nsià Judea? ");
INSERT INTO mitNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Daaní, tucu tu nì càna fuerte nsidaa‑témà, cachí‑te: ―Còó, màdì nècuàchì jaàn cuní‑nsì dàñà. Barrabás chicá vàha ni dáñà ―nì cacachì‑te. Doco cunaha‑nsiá, iin tècuìhnà nduú Barrabás mà. ");
INSERT INTO mitNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Daaní, nì dàndàcú Pilatu nùù soldadu, te nì tavà‑téyâ iladú, nì sahnì cuìí‑teyá xì iin chirrión. ");
INSERT INTO mitNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Dandu nì quidavàha‑tè iin sìcàté iñù, te nì chinacaà‑teá dìnì‑yá. Te nì chindixi stná‑teyá iin capa moradu. ");
INSERT INTO mitNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dandu nì catnàtuu‑tè nùù‑yá, (nì sàcùndiaà‑teyá), cachí‑te: ―¡Tùinuùváha‑ní, señor! ¡Vichi ndisa, sànì sàcùnduu‑ní rey xi tè‑raza Judea! Dandu nì cacani‑tè nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Daaní, tucutu nì quee Pilatu nùù nèhivì ndiatú yucán, cachí‑te xi‑né: ―Cunaha‑nsiá, cuàhìn taví Jesús cundehè‑nsiá, te cundaà inì‑nsia ñà‑còò ni‑iin falta xi‑ne nì ndácùhin. ");
INSERT INTO mitNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ñàyùcàndùá, nì quee Jesús (vehe ma), ñuhú dínì‑yá sìcàté iñù mà, te ndixí stná‑yà capa moradu mà. Dandu nì cachi Pilatu xì nsidaa nèhivì ndoó yucán: ―Cundehè‑nsiánè, yohó iín‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Daaní, dùtù xícusahnú, xì stná policía, na ní xini‑nèyà, dandu nì càna ndee‑né, cachí‑nè: ―¡Nchìca cruz ni cuí nècuàchì jaàn! ¡Cahnì‑nínè! Dandu nì cachi Pilatu xì nsidaa‑né: ―Mii‑nsiá cundaca‑nsianè cùhùn, te cahnì‑nsiánè, doco yùhù, còó, vàchi còò cuàchi‑ne ni ndácùhin. ");
INSERT INTO mitNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Dandu nì cacachi nècuàchì raza Judea mà: ―Nsiùhù, icúmí‑nsî iin ley, te según cachí ley mà icúmí nècuàchì jaàn cui‑nè sàhà ñà‑nì cachi‑nè nduú‑né Dèhemanì Dios. ");
INSERT INTO mitNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Dandu Pilatu, na ní inini‑tè ñà‑nì cacachi nècuàchìmà ducán, chicá nì yùhí‑te, ");
INSERT INTO mitNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","te nì nansìhvi‑tè ini vehe cahnú‑te nì càhàn tu‑tè xì‑yá, cachí‑te: ―¿Índù ndisa nì quixi mii‑ní? Doco Jesús, cónì cáhàn gà‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dandu cachí tu Pilatu xì‑yá: ―¿Índù chuun có‑câhàn‑ní xìˊ? ¿A có‑ìnáhá‑nî ñà‑yùhù icúmî poder: vàtùni cahní mii‑ní, te ò vátùni dacácui mii‑ní? ");
INSERT INTO mitNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dandu nì cachi‑yà xì‑té: ―Ni còò ni‑iyuhu poder cucumi‑ní nú màsà chítnùní ini mii‑yá iá ansivi ducán. Sàhámà tiàa nì dàndàcú quixi nùù‑ní, chicá nsidá cuàchi‑tè (nùù mii‑ní) ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Daaní, dècuèndè hora yucán nì nanducu Pilatu nansa daña‑téyâ, doco chicá fuerte nì càna nsidaa tè‑raza Judea mà, cachí‑te: ―Nú ni daña‑ní Jesús jaàn, dandu náhà claru có‑ndùù‑ní amigo ndisa xi rey cahnú César. Vàchi nsidaa ana cachí nduú stná rey, xiní ùhì stná‑nè rey cahnú César. ");
INSERT INTO mitNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Daaní, na ní inini Pilatu ñà‑jaàn, dandu nì tavà tú‑teyá inga xichi, te nì sàcòo‑tè silla ndé siempre iá‑te nsidándáà‑te chuun. Te silla mà, iín‑nu dìquì yùù chipála itánduhù ñuhù, te Gabata nani lugar mà dàhàn hebreu. ");
INSERT INTO mitNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te sànì cahin quìvì yucán, divi quìvì nduú vigilia vicò pascua mà, dandu nì càhàn‑te xì nsidaa nèhivì yucán, cachí‑te: ―Cundehè‑nsiá, yohó iín nècuàchì nduú rey xi‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Doco ndee ní càna nsidaa nèhivì mà: ―¡Còó! ¡Ni cuí‑nè cuní‑nsì! ¡Cahnì‑nínè! ¡Ni mácùtuu‑ne nchìca cruz! Dandu cachí Pilatu xì nsidaa‑né: ―¿A ndísá cuní‑nsià cui rey xi‑nsia nchìca cruz? Te nì cacachi dùtù xícusahnuma: ―Cuisì imindaa rey xi‑nsi iá, divi nduú César. ");
INSERT INTO mitNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ñàyùcàndùá, nì candisá Pilatu ñà‑ndùá xícàn nècuàchìmà; nì dàndàcú‑te ni cuí Jesús nchìca cruz. Dandu nì saca soldadu‑yà cuàhàn‑te xi‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Daaní, nì sàcùnsida‑ya cruz xi‑ya cuàhàn‑yà, te nì sàà‑yà nùù iin xaan nani lunsi Calvariu. Te Gólgota nani stná lugar yucán nùù dàhàn hebreu. ");
INSERT INTO mitNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Te yucán nì cachituu‑tèyá nchìca cruz, mii‑yá xì inga ùì stná tiàa, iin iin‑tè iin iin ladu‑yà, te mii‑yá mahì‑xí. ");
INSERT INTO mitNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Daaní, nì dàndàcú stná Pilatu ñà‑nì mácùtuu dìnì cruz xi‑ya iin ñà‑càchí: “Jesús de Nazaret, rey xi tè‑raza Judea”. ");
INSERT INTO mitNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Dandu nì cahvi cuàhà nècuàchì ñuu mà nansa cacháˋ, vàchi lugar ndé nì chituu‑tèyá nchìca cruz, yatni uun ñuu mà nduá. Te ùnì dàhàn nì tiaa palabra mà: dàhàn hebreu, xì dàhàn griegu, xì dàhàn latín. ");
INSERT INTO mitNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Dandu dùtù xícusahnu‑ma, nì càhàn‑nè xì Pilatu, cachí‑nè: ―Màsà cáchí palabra mà “Rey xi tè‑raza Judea”. Còó, chicá vàha tiaa‑ní ñà‑nì cachi uun‑ne nduú‑né rey xi nèhivì raza‑nsì. ");
INSERT INTO mitNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dandu nì cachi Pilatu xì nècuàchì yucán: ―Còó. Ñà‑ndùá sànì tiaa, ducanicoá ");
INSERT INTO mitNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Daaní, nì nsihi nì chituu soldadu‑yà nchìca cruz, dandu nì dàcuàchí‑te sìcoto xi‑ya nùù nsìcúmì‑té. Chii chiá nì nìhì iin iin‑tè. Doco cuaán nduú dùhnù quihín‑yà, vàchi iin‑ni cahnú nì cuàha; còò ni‑iin xaan xi‑ña ndé nì nsícu. ");
INSERT INTO mitNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ñàyùcàndùá, nì cacachi soldadu mà: ―Màsà dácuáchí‑ndáñâ. Chicá vàha cuidàdìquí‑ndà suerte sàhà‑ñá cundaà ini‑ndà ana nìhì xán. Pues ducán nì cuu sàhà‑ñá ni cuú ndisa ñà‑ndùá nì cachitnùhu nùù tutu ìì ndé cachí palabra yohó: “Nì cadasàn‑té sìcoto xi entre mii‑té, te nì idàdìquí‑te suerte, a ver índù‑té nìhì xì ñà‑ndùá ndìxí”. Ñàyùcàndùá, ducán nì caquida soldadu mà. ");
INSERT INTO mitNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Daaní, sàhà cruz xi‑ya iín stná dihi‑yá xì cùhì‑nè nani stná María, divi ñahàdìhí Cleofas; te yucán iín stná María Magdalena. ");
INSERT INTO mitNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Te nì xini‑yà dihi‑yá, te nì xini stná‑yà yucán iín stná iin nècuàchì dacuahá‑yá cuú cuáhà ini‑yà sàhà‑xí. Ñàyùcàndùá, nì cachi‑yà xì dihi‑yá: ―Cundehè‑ní mamá, jaàn iín dèhe‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dandu nì cachi‑yà xì nècuàchì dàcuàhàmà: ―Cundehè‑ní, jaàn iín mamá xi‑ní. Te divi hora yucán nì nàcùndiaa nècuàchìmà dihi‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Daaní, ináhá‑yâ ñà‑sànì cuu ndisa nsidaa ñà‑ndùá nì cachi tutu ìì, ñàyùcàndùá, nì cachi‑yà: ―Xíhì tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Te yatni uun yucán iín iin quìdi chitu vinu nì xìò. Ñàyùcàndùá, nì quihin soldadu iin ñà‑ñàhmá nani esponja, nì chihi‑tèá dìnì iin vara nù‑hisopo. Dandu nì chindaxin‑tèá vinu mà, te nì dàcúhùn‑teá nùù yuhù‑yá ");
INSERT INTO mitNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","nì sihvi‑yá chiá. Dandu nì cachi‑yà: ―Vichi ndisa sà‑ìá. Te nì nàcuìndee dìnì‑yá, te nì xìhì‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Dandu nècuàchì raza Judea, cónì cùní‑nè ndòo nsidaa nsìi ma nchìca cruz, vàchi vigilia xi quìvì descansu nduá. Te divi quìvì descansu mà nì nacava stná iin vicò cahnú xí‑né. Ñàyùcàndùá, nì ca‑xicàn‑nè favor nùù Pilatu ñà‑nì cátnáhnù iquì naní sàhà iin iin ana itándiaa nchìca cruz (sàhà ñà‑nì cùí yàchì‑nè), dandu cuxio‑ne nùù cruz. ");
INSERT INTO mitNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ñàyùcàndùá, nì casaà tu soldadu (ndé itá cruz), te nì casahnù‑te iquìsáhà iin tiàa itúú nchìca cruz iin ladu Jesús, dandu después ingà‑te. ");
INSERT INTO mitNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Doco na ní tnàtuu‑tè ndé itúú mii‑yá, nì cundaà inì‑te sànì xìhì‑yà; ñàyùcàndùá, cónì sáhnù gà‑te iquìsáhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Doco iin soldadu mà, nì dàquíhvi‑tè lanza xi‑tè diìn tìxì‑yá, te nì dàñà nìì‑yá xì tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yùhù nì xinì nsidaájàn, teayùcàndùá nacání xì‑nsiá sàhá. Te ñà‑ndácuisì nduá cachíˋ. Yùhù ináhî, te cachítnùhu ndaì xì‑nsiá sàhà‑ñá ni cúníndísâ stná‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Cunaha‑nsiá, nsidaa ñà‑jaàn nì cuu xi‑yá sàhà‑ñá ni cuú ndisa nacua nì cachitnùhu nùù tutu ìì ndé cacháˋ: “Ni‑iin iquì‑yá mà‑tnáhnù”. ");
INSERT INTO mitNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Daaní, cachí stná inga xaan nùù tutu mà, ndé cacháˋ: “Icúmí nèhivì cuni‑nè mii‑yá ana nì dàquíhvi‑tè (càa) ìcà‑xí”. ");
INSERT INTO mitNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Daaní, nì nsihamà, dandu nì sàhàn iin tiàa nani José nùù Pilatu. Iin nècuàchì ñuu Arimatea nduú nècuàchìmà, te nduú stná‑nè iin nèhivì xí Jesús, doco chídèhé‑nè, vàchi yúhî‑nè tè‑dava ga raza‑nè Judea. Pues divi mii‑né nì sàhàn nì xìcàn permisu nùù Pilatu nanihi‑ne iquìcúñú‑yà. Te juùn nì cachi Pilatu. Ñàyùcàndùá, nì sàhàn‑nè nì nanihi‑ne iquìcúñú‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Daaní, nì sàà stná Nicodemo yucán, divi nècuàchì nì sàhàn ñuú visita ndé iá‑yà. Te vichi nihí‑né ñà‑tnami nani mirra nì sàà, te dácà stnahá stná mà xì inga ñà‑tnami nani áloe. Nsidaájàn cúvèa nahi òcò ùxìn kilo. ");
INSERT INTO mitNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ñàyùcàndùá, José xì Nicodemo mà, nì nanihi‑ne iquìcúñú‑yà nùù cruz, te nì chidùcún‑néyà sìcoto finu cuxín, te nì dàquée stná‑nè ñà‑tnami ma, vàchi ducán nduú estilu xi nèhivì raza Judea na sácùndùxin‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Cunaha‑nsiá, yatni ndé nì sa‑ituu Jesús nchìca cruz, yucán itá stná itnii yutnù tàtá. Te mahì yutnù mà iá stná iin cueva làcà ní sate, doco tàñáha ga cundùxin ni‑iin nsìi‑ña. ");
INSERT INTO mitNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Te sàhà‑ñá sà‑ìtúú quìvì descansu xi nècuàchì ñuu mà, ñàyùcàndùá, ini cueva yucán‑ní nì chindùxin‑neyà, vàchi yatni nduá. ");
INSERT INTO mitNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Daaní, quìvì primeru semana, (divi quìvì domingu) vàxi María Magdalena cueva ndé índùxin Jesús. Naha nduá, te iín tnuu va nduá. Dandu nì xini‑nè, sànì cuxio cavà cahnú ndiadí yuhù cueva. ");
INSERT INTO mitNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ñàyùcàndùá, nì dàyáà‑nè cuàhàn‑nè ndé iá Simón Pedro xì inga nècuàchì dacuahá‑yá, divi nècuàchì mànì guá nùù‑yá, te nì cachi‑nè xì nècuàchìmà: ―Sànì tavà‑té Stoho‑ndà Señor ndé nì sàcùndùxin‑ya. Te có‑cùndáà ini‑nsì índù cuàhàn‑te xi‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ñàyùcàndùá, nì quee Pedro xì compañeru‑nè, cuàhàn stná‑nè cueva yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Te cutnáhâ‑né nì dàyáà‑nè cuàhàn‑nè, doco chicá ndee ní dàyáà compañeru Pedro mà, teayùcàndùá, dihna nècuàchìmà nì sàà‑nè nùù cueva. ");
INSERT INTO mitNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Te nì nacàhnu ndee‑ne nì xito nihni‑ne ini cueva, te nì xini‑nè ndé sìcoto xi‑ya itánduhù, doco cónì quíhvi‑ne inì‑xi. ");
INSERT INTO mitNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Daani, nchícùn Simón Pedro nì sàà stná‑nè, doco mii‑né ndisa, nì quìhvi‑ne inì‑xi, te nì xini stná‑nè itánduhù sìcoto xi‑ya, ");
INSERT INTO mitNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","xì stná pañuelu nìsa idàhvi nùù‑yá, doco có‑ìndúhá xì sìcoto dava ga; iladú indúhá, te sànì natnahnù viá. ");
INSERT INTO mitNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dandu nì quìhvi stná compañeru Pedro nì sàà primeru, te nì xini stná‑nè nansa iámà, te nì xinindisá‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Doco ni mii‑né ni stná Pedro, tàñáha ga cundaà ini‑nè nansa cachí nùù tutu ìì ndé cachí icúmí‑yâ natiacu‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Daaní, ndúì‑nè mànuhù‑né vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Doco yucán ndé iá cueva mà (nì sàà) stná María. Te vichi iín‑né fuera sacú‑né. Te nì nacàhnu ndee‑ne, nì xito nihni stná‑nè ini cueva. ");
INSERT INTO mitNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Te yucán nì xini‑nè ndoó ùì ángel xi Dios lugar ndé nìsa induhù Jesús, iin‑ne ndé nì sanduu dìnì‑yá, te inga‑nè ndé nì sanduu sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Te nì cachi ángel mà xì María: ―Señorita, ¿índù chuun sacu‑ní? Dandu cachí‑nè xì nècuàchìmà: ―Vàchi sànìhí‑te Stoho‑nsì Señor cuàhàn, te có‑cùndáà inì índù cuàhàn‑te xi‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Dandu nì ndecoto María ladu yàtà‑né, te nì xini‑nè yucán iín mii‑yá, doco cónì nácúní‑nèyà nduú‑yá Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Te nì cachi‑yà xì‑né: ―Señorita, ¿índù chuun sacu‑ní? ¿Ana divi nandúcú‑nî? Doco María, nì tuxi ini‑nè ádi té‑ndiàá yutnù tàtá iá yucán nduú ana cáhàn; ñàyùcàndùá nì cachi‑nè: ―Señor, nú mii‑ní nì tavà‑níyà, dandu cachi sacù‑ní xìˊ índù nì sànihi‑níyà, te cùhìn naquihin‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dandu nì cachi‑yà xì‑né: ―¡María! Dandu nì naxicocuíìn‑nè ladu yàtà‑né, te nì cachi‑nè dàhàn mii‑né: ―¡Raboni! ―ñà‑ndùá cuní cachà Maestro. ");
INSERT INTO mitNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dandu nì cachi‑yà xì‑né: ―Màsà dúcùn ndahà‑ní yùhù, vàchi tàñáha ga nani nùù Yuamánìˊ. Còó. Cuahán‑nî, cachitnùhu‑ní xì nèhivì xí, vàchi nahi ñanì xínduu‑ne. Te cachì‑ní xì‑né ñà‑ìcúmî nani nùhì nùù Yuamánìˊ. Te cunaha‑nsiá, Yuamánì mii‑nsiá nduú stná‑yà. Te ana càhvì yúhù nduú‑yá, nacua nduú stná‑yà ana càhvì mii‑nsiá ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ñàyùcàndùá, nì sàhàn María Magdalena mà nì cachitnùhu‑ne xì dava ga nècuàchì dacuahá‑yá, nì nacani‑ne nansa nì xini‑nè Stoho‑ndà Señor, te dohó te dohó nì cachi‑yà xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Daaní, na ní cuñaà quìvì domingu mà nì nataca nsidaa nècuàchì dacuahá‑yá. Te nì nacadi vàha‑ne yehè, vàchi yúhî‑nè nèhivì dava ga raza‑nè Judea. Dandu (na iin cachí) nì sàcuììn Jesús dava mahì‑né, te nì cachi‑yà xì‑né: ―Contentu ni cúndóó‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Na ní nsihi nì cachi‑yà ducán, dandu nì dàcùní‑yànè ndahà‑yá xì diìn tìxì‑yá. Ñàyùcàndùá, cuàhà gá nì cudiì ini‑nè ñà‑sànì xini‑nè divi Stoho‑ndà Señor nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dandu inga xichi nì cachi‑yà xì‑né: ―Contentu ni cúndóó‑nsiá. Nacua nì techuún Yuamánìˊ yùhù nì quesaì, ducán techúûn stnáì mii‑nsiá cùhùn‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Daaní, nì sivi tàchì‑yá nùù nsidaa‑né, te nì cachi‑yà: ―¡Ni nándèe Espíritu Ìì ini anima‑nsià, cachíˋ! ");
INSERT INTO mitNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nú ni cuícáhnû inì‑nsia sàhà cuàchi nèhivì, dandu ñà‑sànì ndutu ndisa‑ña cundua; te nú màsà cuícáhnû inì‑nsia sàhà‑né, dandu iá ìì cuàchi‑ne ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Doco nùù ùxìn ùì nècuàchì dacuahá‑yá, iin‑ne cónì ía‑ne xì compañeru‑nè na ní ndecunu Jesús nùù‑né. Divi Tomás nduú nècuàchìmà, te Cuatí cachí stná nèhivì xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ñàyùcàndùá, nì cachi compañeru‑nè xì‑né: ―Cunaha‑ní, ¡sànì xini‑nsì Stoho‑ndà Señor! Doco mii‑né, nì cachi‑nè: ―Dècuèndè cundehí yantà ndahà‑yá ndé nì ìhi clavu, te daquíhvi dìnìndàhí ndé nì xìda mà, te daquíhvi stnáì ndahí ndé (nì nacuèhè) diìn tìxì‑yá, te nú coó, mà cúníndísê ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Daaní, na ní xìnu inga ùnà quìvì, nì nataca tu nècuàchì dacuahá‑yá ini vehe. Doco daa ndisa iá stná Tomás xì nècuàchì ndòò‑mà. Te ndiadí vàha tu yehè. Te nì sàà Jesús inga xichi nì sàcuììn‑yà mahì‑né, te nì cachi‑yà: ―Contentu ni cúndóó‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dandu nì cachi‑yà xì Tomás: ―Yohó daquíhvi‑ní dìnìndàhá‑nî, te cundehè‑ní ndahí; dandu daquíhvi‑ní ndahà‑ní diìn tìxí. Te cunindisá vàha‑ní. Màsà cáchí gà‑ní có‑xìníndísá‑nî. ");
INSERT INTO mitNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dandu nì cachi Tomás xì‑yá: ―Stohì Señor nduu‑ní, vàchi Dios nduu‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Dandu nì cachi‑yà xì‑né: ―Tomás, sàhà‑ñá nì xininùù‑ní yùhù, ñàyùcàndùá nì xinindisa‑ní. Vihi gá ndiaha cundua nú ni cúníndísâ‑nsiá mate tàñáha ga cuninùù‑nsiá yùhù ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Cunaha‑nsiá, cuàhà gá stná milagru nì quida Jesús nì indehè nècuàchì dacuahá‑yá, doco cónì tiàá nsiha nùù tutu yohó. ");
INSERT INTO mitNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Doco ñà‑ndùá cachí nùù tutu yohó, nì tiaa‑ña sàhà‑ñá ni sáà‑nsià cunindisá‑nsiá divi Cristu Dèhemanì Dios nduú Jesús. Vàchi nú sànì xinindisá‑nsiá ñà‑jaàn, te ndácùcahan‑nsiá quìvì‑yá, dandu vida ndiaha sànì nìhì stná‑nsià. ");
INSERT INTO mitNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Daaní, nì nsihajàn, dandu nì ndecunu tu Jesús nùù nècuàchì dacuahá‑yá na ndoó‑né iin xaan yuhù mar nani mar Tiberias. Cuàhìn nacani xì‑nsiá nansa nì cuu na ní ndecunu‑ya nùù‑né yucán. ");
INSERT INTO mitNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Cunaha‑nsiá, cutnáhâ Simón Pedro xì Tomás nècuàchì nani Cuatí, te cutnáhâ stná Natanael nècuàchì dìñúù‑xi nani Caná iá ladu Galilea. Te ndoó stná (ùì) dèhe Zebedeo, xì stná inga ùì nècuàchì dacuahá‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Te nì cachi Simón Pedro xì nsidaa‑né: ―Cuàhìn taví siaca. Dandu nì cachi compañeru‑nè: ―Ni cúhùn nsidaa‑nda. Ñàyùcàndùá, nì sàcùñuhu nsidaa‑né ini iin lancha cuàhàn‑nè; doco ni‑iin siaca cónì níhì‑né niù yacà. ");
INSERT INTO mitNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Daaní, na sácuàhàn nì tùinuù, yucán nì sàà stná Jesús, iín‑yá yuhù mar (yatni ndé ndoó‑né) mà. Doco cónì nácúní‑nèyà. ");
INSERT INTO mitNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ñàyùcàndùá, nì cachi‑yà xì‑né: ―Hijos, ¿a sánì nìhì‑nsiá ñà‑caxì‑ndà? ―Còó, còò ni‑iin‑sì ―nì cachi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dandu nì cachi‑yà xì‑né: ―Ladu cuahá lancha, jaàn dacaná‑nsiá ñunù xí‑nsiá, dandu nìhì‑nsiási ―nì cachi‑yà. Dandu ducán nì quida‑ne, te ni mà cùì gá tavà‑né ñunù xí‑né ñà‑chitu guáˋ cuàhà siaca nì nìhì‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dandu iin nècuàchì dacuahá‑yá, divi nècuàchì mànì guá nùù‑yá, nì cachi‑nè xì Pedro: ―¡Divi Stoho‑ndà Señor nduú Yà‑yòhó! Nì nsihi nì inini Simón Pedro ñà‑divi Stoho‑ndà Señor nduú‑yá, dandu nì nàcùndixi‑ne sacú‑nè, vàchi cuisì sìcoto inì‑xi ndixí‑né. Dandu ní ndàvà‑nè mahì tècuìí cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Te después cuàhàn stná dava ga nècuàchì dacuaha‑ma, doco ini lancha cuàhàn‑nè, vàchi yatni iín‑nu nùù ñuhù íchî, nahi 100 metro. Te cahà‑nú itácáá ñunù chitu siaca. ");
INSERT INTO mitNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dandu nì nuu nècuàchì yucán ñuhù íchî, te nì xini‑nè yucán ndoó tnùù sàxíxìn, te sà‑ìtándoó stná siaca chóhò. Te iá stná pan. ");
INSERT INTO mitNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dandu nì cachi Jesús xì‑né: ―Cuahán‑nsià quihin‑nsia itnii siaca nì tavà‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ñàyùcàndùá, nì nana tu Simón Pedro lancha, te nì dìtá‑nè ñunù mà nì naxìnua ndè nùù ñuhù íchî. Chitu dini ñunù mà siaca, vàchi ñuhú 153 siaca nahnú. Mate cuáhà gá‑si ñuhú, doco cónì sàchí ñunù mà. ");
INSERT INTO mitNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Dandu nì cachi Jesús xì nsidaa‑né: ―Naha‑nsià, cadi inì‑nsia. Te ni‑iin nècuàchì dacuaha‑ma, cónì sáha ndee ini‑nè ndàcàtnùhù‑né nùù‑yá ana nduú‑yá, vàchi ináhá‑nê divi Stoho‑ndà Señor nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dandu nì tnàtuu Jesús nì tnii‑ya pan, te nì dasàn‑yáñà nùù‑né. Te nì dasàn stná‑yà siaca (nì chòhò mà) nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ñà‑jaàn nì sanduu ùnì xichi nì ndecunu Jesús nùù nècuàchì dacuahá‑yá na sánì natiacu‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Daaní, na ní nsihi nì sadi ini nsidaa‑né, dandu nì cachi‑yà xì Simón Pedro: ―Simón, dèhe Jonás, ¿a ñá‑ndâà chicá cuú ndisa inì‑ní sàhí nùù nècuàchì dava ga yohó? ―Jaan, Señor mío. Sà‑ìnáhá‑nî cuú inì sàhà‑ní ―nì cachi‑nè. Dandu cachí tu‑ya xì‑né: ―Nú ndisa, dandu cundiaà‑ní nèhivì xí na ian ndiaá pastor lelù xí‑né. ");
INSERT INTO mitNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Daaní, ñà‑úì nì cachi‑yà xì‑né: ―Simón, dèhe Jonás, ¿a cuú ndisa inì‑ní sàhí? Te nì cachi tu‑ne xì‑yá: ―Jaan, Señor mío. Sà‑ìnáhá‑nî cuú inì sàhà‑ní. Dandu cachí Jesús xì‑né: ―Dacúndéhe‑ní (nèhivì‑xí ichì váha), na ian ndiaá‑ndà riì. ");
INSERT INTO mitNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Daaní, ñà‑únì nì cachi tu‑ya xì‑né: ―Simón, dèhe Jonás, ¿a ñá‑ndâà nduá, cuú ndisa inì‑ní sàhí? Pues vichi nì cuhuun ini‑nè ñà‑sà‑ùnì xichi ndácàtnùhù‑yá a ndísá cuú ini‑nè sàhà‑yá, á coó. Ñàyùcàndùá nì cachi‑nè xì‑yá: ―Señor mío, nsidanicuú iñàha ináhá‑nî. Ñàyùcàndùá, ináhá stná‑ní, yùhù cuú ndisa inì sàhà‑ní. Dandu nì cachi‑yà xì‑né: ―Pues nú ducán, dandu cundiaà‑ní nèhivì xí, na ian ndiaá‑ndà riì xì‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cunaha‑ní, ñà‑ndáà nduá cuàhìn cachitnùhi xì‑ní yohó: na cuachi‑ní, (nìsà nàcùndixi‑ní sìcoto xi‑ní), nì sansidatnuu‑ní cinturón xi‑ní, te cuàhàn‑ní ndéni nì cui cudíì inì‑ní. Doco nú sànì sahnu‑ní, dandu icúmí‑nî ndanihi‑ní ndahà‑ní, te inga‑nè icúmí‑nê nsidatnuu‑ne cinturón xi‑ní, te cunihi‑ne mii‑ní cùhùn ndé có‑cùdíì inì‑ní cùhùn‑ní. ");
INSERT INTO mitNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ñà‑jaàn nduá nì cachi Jesús cachítnùhu‑ya nansa quida nèhivì xì Pedro na quívì cui‑nè, te ducán chicá quee tnùñuhu xí Dios. Daaní, nì nsihi nì cachi‑yà ñà‑jaàn, dandu nì cachi tu‑ya xì Pedro: ―Cunchicùn‑ní yùhù. ");
INSERT INTO mitNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Daaní, nì nacuico Pedro yàtà‑né, te nì xini‑nè nchícùn stná nècuàchì dacuahá cuú guá ini‑yà sàhà‑xí. Te divi nècuàchìmà nduú nècuàchì nì ìa yatni diìn Jesús na ní sandoo‑ne nì xixi‑ne xì‑yá daa, te nì xìcàn tnùhù‑né nùù‑yá nì cachi‑nè: “Señor mío, ¿ana divi nduú tiàa icúmí cahin xì‑ní?” ");
INSERT INTO mitNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pues, divi nècuàchìmà nì xini Pedro nchícùn vàxi, te nì cachi‑nè xì‑yá: ―Te nècuàchì jaàn tú, ¿nansa icúmí cuu xi‑né, Señor mío? ");
INSERT INTO mitNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Dandu nì cachi‑yà xì‑né: ―Pues nú cudíì inì cutiacu‑nè ndè cachi sàà quìvì naxicocuíìn, doco mii‑ní, màsà nácání inì‑ní sahájàn. (Chuun xi‑ní nduá) ñà‑cunchicùn‑ní yùhù ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ñàyùcàndùá, nì xìtià cuentu nùù nèhivì xí‑yá, ñà‑mà nunca cui nècuàchì dacuahama, cachí cuentu. Doco cónì càchí‑yà mà cúí‑nè. Còó, cuisì ní cachi‑yà nú cuní‑yà cutiacu‑nè ndè cachi sàà quìvì naxicocuíìn‑yà, màsà nácání íní Pedro sàhámà. ");
INSERT INTO mitNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Cunaha‑ní, divi nècuàchìmà nduú yùhù, te divi yùhù nì tiaa nsidaa palabra yohó. Te ñà‑ndácuisì nduá cachíˋ, vàchi ináhî cachí ndàì xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Cunaha‑nsiá, cuàhà gá stná iñàha iá nì quida Jesús (ñuhìví yohó). Doco nú cuní‑ndà tiaa nsihi‑nda nsidaámà, dandu cuàhà sàstnùhù libru cundua. Te mà cuáhà‑ñá ni inicutu ñuhìví, cachí yùhù. Sà‑ìá.");
INSERT INTO mitNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Cásàhúì xì mii‑ní señor Teófilo. Cunaha‑ní, tutu nì tiai primeru, nacáníámà sàhà ñà‑ndùá nì quida Jesús xì ñà‑ndùá nì chinaha‑yà ndè quìvì nì quesaha‑yá xì ndéˋ quìvì nì nana‑ya mànuhù‑yá ansivi. Doco na táñâha ga nùhù‑yà, dandu nì càhàn‑yà xì apóstol ana nì sàhatahvì‑yá chuun xi‑ya; sàhà poder xi Espíritu Ìì xí Dios nì càhàn‑yà xì‑né nì dàndàcú‑yá nùù‑né nansa quida‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Vàchi antes, na ní nsihi nì ndoho‑ya, te nì xìhì‑yà, dandu vivu nì ndecunu‑ya, te nì xini‑nèyà ñà‑sànì natiacu‑yà, ùì dico quìvì nì ndòo ga‑yà ñuhìví, te cuàhà xichi nì ndecunu‑ya nùù‑né, te cuàhà gá stná ñà‑ndùá nì quida‑ya sàhà‑ñá cundaà ndisa ini‑nè divi nduú‑yá. Te nì càhàn stná‑yà xì‑né sàhà chuun xi ñuhìví ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Daaní, na iá va‑ya xì‑né, nì cachi‑yà xì‑né ñà‑màsà quéé yáchì‑nè ñuu Jerusalén: ―Còó ―cachí‑yà― yohó cundiatu‑nsia dècuèndè nìhìtáhvì‑nsiá cuu xi‑nsiá nacua sànì quida Yuamánìˊ comprometer, divi ñà‑ndùá nì cachi stnáì xì‑nsiá antes. ");
INSERT INTO mitNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Vàchi ñà‑ndáà ndùá, tècuìí nìsa quida iì Juan nèhivì. Doco mii‑nsiá, tìxi Espíritu Ìì xí Dios icúmí anima‑nsià nduhiìá tìxi sacu quìvì ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Daaní, nì nataca tu nsidaa nècuàchì dacuahá‑yá‑mà nùù‑yá, te nì xìcàn tnùhù‑né, cachí‑nè: ―Stoho‑nsì Señor, ¿a vichi nacání inì‑ní quee libre ñuu‑ndà Israel quida‑ní? ");
INSERT INTO mitNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dandu nì cachi‑yà xì‑né: ―Có‑sâhatahvì Dios mii‑nsiá ñà‑cunaha‑nsiá índù iin quìvì, ò índù iin tiempu cuu iñàha. Còó, vàchi cuisì Yuamánìˊ iá ansivi chítnùní inì‑xi sàhà nsidaájàn. ");
INSERT INTO mitNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Doco mii‑nsiá, icúmí‑nsiâ nìhìtáhvì‑nsiá quìvì quixi fuerte Espíritu Ìì ini anima‑nsià, dandu inicutu icúmí‑nsiâ càhàn‑nsià sàhí. Primeru ñuu Jerusalén yohó càhàn‑nsià, te ducán stná inii ladu Judea, xì stná ndè ladu Samaria xì dècuèndè stná inicutu ñuhìví ");
INSERT INTO mitNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","―nì cachi‑yà. Daaní, indéhe‑né nì ndanchito‑ya mànana cuisì‑yá ansivi, te nì dàhvi‑ya nùù‑né mahì iin vìcò mànuhù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Te na indéhe váha‑ne ansivi ndé mànana‑ya, dandu yucán ndé itá‑né nì sàcuìta stná ùì ana ndixín cuxín. ");
INSERT INTO mitNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Te nì cachi nècuàchìmà xì nècuàchì xí‑indehè mà: ―Mii‑nsiá nècuàchì ñuu Galilea, có‑ndùá cundehè gá‑nsià ansivi, vàchi divi Jesús nì xini‑nsià mànuhù yucán, icúmí‑yâ naxicocuíìn‑yà. Vàchi nacua iá‑yà mànana‑ya mànuhù‑yá, divi ducán icúmí‑yâ naxicocuíìn‑yà nuu‑ya. ");
INSERT INTO mitNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","13","Dandu nsidaa nècuàchì apóstol mà, nì nuu‑ne yucù Olivo yucán, mànuhù‑né ñuu Jerusalén, vàchi yatni iá ñuu mà nùù yucù yucán, nahi dava hora caca‑nda. Te na ní nasaa‑nè, nì yàha‑ne ndè iin vehe idótnahá, nì canana‑ne dìquì‑xí ndé ndoó‑né. Te nèhivì ndoó yucán, dohó nani‑né: Pedro, xì Jacobo, xì Juan, stná Andrés, xì Felipe, xì Tomás, xì Bartolomé, xì Mateo, xì stná dèhe Alfeo nani stná Jacobo, xì stná Simón Zelote, xì ñani Jacobo mà nani Judas. ");
INSERT INTO mitNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nsidaa nècuàchìmà, iin‑ni nihnú ini‑nè, te iin‑ni xícàn tàhvì‑né nùù Dios, mii‑né xì stná ñani Jesús, xì dihi‑yá María, xì más gà stná nècuàchì ñahà. ");
INSERT INTO mitNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Daaní, quìvì yucán nì nataca nsidaa nèhivì nchícùn ichì‑yá. Na iin cientu òcò xínduu‑ne. Te nì ndacuiin Pedro mahì nsidaa‑né, cachí‑nè: ―Ñánì, sànaha nì chindee Espíritu Ìì xí Dios xìì‑ndà David, te nì tiaa‑ne nì cachitnùhu‑ne sàhà Judas, divi tiàa nì sacatnahá xi nècuàchì nì tnii xi Jesús. Te ducán nì cuu, vàchi ñà‑ndùá nì cachi Dios sànaha ma, fuerza nì cuu ndisa‑ña. ");
INSERT INTO mitNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Vàchi Judas mà, nìsa cutnahá‑né xì‑ndà, iin‑ni chuun nìsa quida‑nda xi‑né antes. ");
INSERT INTO mitNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Doco nì quida‑ne iin cuàchi, nì tnii‑ne dìhùn, te sàhà dìhùn mà nì xiin‑ne iin ñuhù. Dandu nì nacava candéé‑nê yucán, nì cahnsi ìì‑né nì quecoyo iì sisi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Te nsidaa nèhivì ñuu Jerusalén yohó, nì xinitnùhu stná‑nè sàhámà. Ñàyùcàndùá nì sàcùnani ñuhù mà Acéldama, te cuní cachi quìvì mà: “Iin ñuhù ndé nì xìtià nìì”. ");
INSERT INTO mitNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Vàchi ducán nì cachitnùhu libru ndé itándiaa alabanza ìì ndé cacháˋ: “Ni ndóo nihni vehe‑ne. Màsà cúndóó gá nèhivì yucán”. Te cachí stná tutu mà: “Ni ndóo chuun xi‑ne nùù inga nèhivì”. ");
INSERT INTO mitNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Ñàyùcàndùá, xiñuhu nanducu‑nda inga tiàa chindee tnaha‑xi‑nda cachitnùhu‑nda xi nèhivì ñà‑sànì natiacu Stoho‑ndà Jesús. Doco icúmí‑nê cunduu‑ne iin ana sànì cutnahá xi‑nda inii tiempu nìsa xìcanuu‑ya mahì‑ndà dècuèndè tiempu nìsa quida iì Juan xì ndè quìvì nì nana‑ya ansivi cuàhàn‑yà ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ñàyùcàndùá, nì catavà‑né ùì nèhivì. Iin‑ne nani José Barsabás, te Justo nduú inga quìvì‑né. Daaní, inga nèmà nani Matías. ");
INSERT INTO mitNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Dandu nì xìcàn tàvhì nsidaa‑né nùù Dios, cachí‑nè: ―Stoho‑nsì Señor, ináhá‑nî nansa iá anima nsidaa nèhivì. Ñàyùcàndùá, nùù ùì tiàa yohó cuàha‑ní nsiùhù iin seña índù nècuàchì cundehè chuun xi‑ní cuenta xi Judas, vàchi nècuàchìmà, sàhà cuàchi‑ne, ñàyùcàndùá nì ndòo chuun xi‑ne, te cuàhàn‑nè ndé nì nchihò ini‑nè cùhùn‑nè ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dandu nì caquida‑ne iin sorteu, te nècuàchì nani Matías mà nì quee nombradu ñà‑cutnahá stná‑nè xì ùxìn iin ga nècuàchì apóstol. ");
INSERT INTO mitNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Daaní, meru quìvì nducáhnû vicò Pentecostés, dandu iin‑ni xaan nì nataca nsihi nècuàchì nchícùn ichì mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ndoó‑né, te nanàá nì tiacu‑nè ndè dìquì‑xí ansivi na ian cahá fuerte guá tàchì, te nì tiacu inii ini vehe ndé ndoó‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dandu nì xini‑nè nchií ñuhu cuati nahi yàá‑ndà, te nì xìtià nihnia, iin ian nì ndòo dìnì iin iin nèhivì yucán. ");
INSERT INTO mitNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Te nsidaa‑né, nì chitu anima‑nè Espíritu Ìì xí Dios, te nì quesaha‑né cáhàn‑nè dàhàn sàà según nansa nì dàtnúù Espíritu Ìì sàxìnítnùní iin iin‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Cunaha‑ní, ñuu Jerusalén yucán ndoó cuàhà nècuàchì raza Judea nì caquee nùù nsidaa ñuu inicutu ñuhìví. Nèhivì càhvì víi xi Dios nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Te na ní tiacu‑nè cáhàn guá nèhivì yucán, dandu nì nataca cuàhà‑né, te yáha ga nì ndulocó‑nè, vàchi iníní‑né cáhàn nècuàchìmà dàhàn cada iin iin ñuu nècuàchì nì nataca iníní má. ");
INSERT INTO mitNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ñàyùcàndùá, nì ndulocó nsidaa‑né, nacání ini‑nè, cachí‑nè iin‑ne xì inga‑nè: ―Amádi puru nècuàchì ñuu Galilea xínduu nècuàchì cáhàn guá yohó. ");
INSERT INTO mitNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Doco vichi iníní‑ndá cáhàn‑nè dàhàn nì sahnu cada iin iin ndohó. ¿Nansa cui quida‑neàmà? ");
INSERT INTO mitNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Vàchi mii‑nda, cuàhà ñuu nì quixi‑nda: ñuu Partia, xì ñuu Media, xì ñuu Elam, xì ñuu Mesopotamia, xì ladu Judea yohó, xì ñuu Capadocia, xì ñuu Ponto, xì ladu Asia, ");
INSERT INTO mitNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","xì ladu Frigia, xì ladu Panfilia, xì ñuu Egipto, xì stná ladu Africa iá nùù‑xí ñuu Cirene, te yohó ndoó stná nècuàchì Roma, nduú‑né nècuàchì raza Judea, te nduú stná‑nè nècuàchì nì yàha ndè religión xi raza mà. ");
INSERT INTO mitNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Daaní, ndoó stná nècuàchì ñuu Creta, xì stná nècuàchì ladu Arabia. Doco nsidaa‑nda iníní‑ndá cáhàn nècuàchì yohó dàhàn iin iin‑nda, ndeníhí vàha‑ne Dios sàhà obra ndiaha quidá‑yá ―nì cacachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ñàyùcàndùá nsidaa nècuàchì iníní yucán, nì ndulocó cuàhà‑né, nacání cuáhà ini‑nè, ndácàtnùhù tnàhá‑né nùù‑né, cachí‑nè: ―¿Ndíà nduá cuní cachi ñà‑yòhó? ");
INSERT INTO mitNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Doco dava ga nèhivì, nì sàcùndiaa uun‑ne, cachí‑nè: ―Ádi xíni nsidaa nècuàchì jaàn nì quida vinu fuerte ―cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dandu Pedro, iín‑né cutnáhâ‑né xì ùxìn iin nècuàchì icúmí stná chuun nùù Jesús, te ndee nì càhàn‑nè xì nsidaa nècuàchì sànì nataca yucán, cachí‑nè: ―Mii‑nsiá tè‑ndùú ñanìtnaha raza‑ndà Judea, xì nsidaa mii‑nsiá nècuàchì ndoó ñuu Jerusalén yohó, cunini‑nsia cuàhìn càhìn. ");
INSERT INTO mitNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Xíni‑nsi tuxí inì‑nsia, doco còó. Có‑ndùá ñà‑xíni‑nsi, vàchi làcà ní cahin vitni. ");
INSERT INTO mitNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Còó, ñà‑ndùá cáhàn nècuàchì yohó, divi nduú ñà‑ndùá nì cachi Joel sànaha na ní cachitnùhu‑ne iin razón ndiaha xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Te dohó cachí‑yà, nì cachi Joel mà: Quìvì xìnu tiempu, cuàhà icúmî cuàhatahvìˊ nsidaa nèhivì Espíritu Ìì xí. Ndè dèhe ii‑nsiá xì dèhe yoco‑nsiá, icúmíâ càhàn ñà‑ndùú razón ndiaha xí. Te tiàa cuachi, icúmî dacuní nùí‑nè cuàhà ñà‑ndiaha; xì stná nècuàchì sahnú, icúmí quixi stná sani nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Te quìvì yucán, cuàhà icúmî cuàhatahvìˊ nècuàchì xinúcuáchí nùí, tiàa‑ne te ñahà‑né, cuàhà gá icúmí‑nê nìhìtáhvì‑né Espíritu Ìì xí, dandu càhàn‑nè ñà‑ndùú razón xi. ");
INSERT INTO mitNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Te dìquì‑xí ansivi icúmí cuu cuàhà stná milagru fuerte quide, xì stná ñuhìví yohó, icúmí stnâ‑nsià cuni‑nsià milagru ndiaha xí. Vàchi icúmí cucuu nìì, te cucuu ñuhu, te cucuu ñùhmà nahi ñùhmànsìvì. ");
INSERT INTO mitNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Doco dihna icúmí ndàhvà orá, xì stná yoo, icúmí‑sî nducuahá‑si nahi nìì, dandu sàà quìvì xí yùhù ana nduú Stoho‑nsià Señor. ");
INSERT INTO mitNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Te nsidaa ana ndacùcahan xi quìví, icúmí‑nê càcu‑ne, nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Nsidaa‑nsiá nècuàchì ñanìtnaha raza Israel, cunini vàha‑nsia ñà‑ndùá cuàhìn cachì: nì quixi Jesús de Nazaret nì xìcanuu‑ya mahì nsidaa‑nda, te ndiaha gá nì quida‑ya nacua cuní Yua‑nda Dios, vàchi sàhà poder ndiaha xí Dios nì quida‑ya cuàhà milagru fuerte, cuàhà milagru ndiaha. Ináhá vâha‑nsia sàhà ñà‑jaàn. ");
INSERT INTO mitNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Doco Dios, nì chitnùní ini‑yà ñà‑tnii‑nsia Jesús, te coo‑ya ndahà‑nsiá. Te divi ducán nì cuu, vàchi ináhá Dios nansa cuàhàn cuu xi (Dèhemanì‑yá) Jesús. Ñàyùcàndùá, nì tnii‑nsiayà, te nì sahnì‑nsiáyà, vàchi iin‑ni nì ndatnuhu‑nsiá xì tiàa malu, te nì cachituu‑tèyá nchìca cruz. ");
INSERT INTO mitNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Doco nì dànátiácú Yua‑nda Dios‑yà, nì tavà‑ñáyâ nùù tnùndoho ñà‑nì xìhì‑yà, vàchi có‑ndùá ducán ndòo‑ya tìxi ñuhù. ");
INSERT INTO mitNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Te divi ducán nduá nì cachitnùhu stná David sànaha sàhà‑yá, vàchi dohó nì cachi‑nè: Dios nì quide cuenta cutnáhá‑xî nicanicuahàn, vàchi yatni iá‑yà ladu cuahíˋ sàhà‑ñá màsà dáyûhî nèhivì yùhù, te quidi yùhù. ");
INSERT INTO mitNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ñàyùcàndùá, cuàhà gá nì cudiì ini anímè, te nì naquimaní (mii‑yá), vàchi mate ni ndúxin iquìcúñúì, doco ináhî iá tnùndé ini xi. ");
INSERT INTO mitNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Vàchi dohó sànì cachì xì Dios: “Ináhî, mà nácóó‑nî anímè ñà‑ndòa ndé ndoó vàha anima nècuàchì nsìi; còó, yùhù tè‑ndùú dèhemanì‑ní, mà cuáha‑ní tnani iquìcúñúì ñuhù. ");
INSERT INTO mitNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sàhà mii‑ní sànì sàì nì cundaà inì nansa iá ichì cutiacu ndiahí; icúmí‑nî dacúdíì inì‑ní yùhù, vàchi seguru icúmî naxicocuíìn cundehí nùù‑ní”, nì cachi David. ");
INSERT INTO mitNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Doco ináhá‑ndá nì sàà xìì‑ndàmà nì xìhì‑nè, ñánì, dandu nì ndùxin‑ne, (ináhá‑ndá), vàchi ñuu yohó nduú ndé índùxin‑ne, te ndè vichi náhà lugar mà. ");
INSERT INTO mitNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Doco iin ana tùha cachítnùhu razón xi Dios nì sanduu stná nècuàchìmà, ñàyùcàndùá ináhá stnâ‑nè ñà‑sànì quida Dios comprometer ñà‑divi Cristu cunduu iin descendencia xi‑ne, te seguru cusahnú stná‑yà nacua nìsa cusahnú mii‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ñàyùcàndùá, nì dàcùní Dios‑nè iñàha, te nì xini‑nè nansa cuàhàn cuu xi Cristu ñà‑ìcúmí‑yâ natiacu‑yà, mà ndóo anima‑yà ndé ndoó vàha anima nsìi, ni mà tnání stná iquìcúñú‑yà ñuhù. ");
INSERT INTO mitNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Te divi ducán nì cuu, nì natiacu‑yà nì quida Yua‑nda Dios. Ináhá‑nsî, vàchi testigu nduú‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dandu después dècuèndè gloria mànana ducún‑yà nì quida ndahà cuàhá Yua‑nda Dios, te divi nduú ana nì quida comprometer cuàhatahvì stná‑yà Espíritu Ìì xí‑yá. Ñàyùcàndùá sànì dàquìxí fuerte Jesús Espíritu Ìì, te ñà‑jaàn nduá dìsáhà‑xí cuú ñà‑ndùá xiní‑nsià te iníní‑nsiá vichi. ");
INSERT INTO mitNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Doco nsì‑David (sànaha ma), tàñáha ga nana ducún‑nè ndè ansivi; còó, vàchi palabra yohó nduá nì cachi‑nè: Nì cachi Dios xì Stoho yùhù: “Yohó coo‑ní ladu cuàhíˋ ");
INSERT INTO mitNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ndè cachi sàà cundeí nùù nsidaa ana xiní ùhì xì‑ní, dandu cusahnú fuerte‑ní nùù‑né”. ");
INSERT INTO mitNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Ñàyùcàndùá, mii‑nsiá xì dava ga stná nècuàchì Israel, ni cúnáhá vâha‑nsia ñà‑yòhó: mate nchìca cruz nì chituu‑nsia Jesús, doco nì chitnùní ini Dios ñà‑divi mii‑yá cunduu Stoho‑ndà, te cunduu stná‑yà rey ndiaha Cristu ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Daaní, nì nsihi nì inini nèhivì cuáhà mà ñà‑jaàn, nì nàcùndoo‑ne tnùnsí ini. Cuàhà gá nì nacani ini‑nè, te nì cachi‑nè xì Pedro xì dava ga nècuàchì apóstol: ―¿Nansa chicá vàha quida‑nsi vichi, ñánì? ");
INSERT INTO mitNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dandu nì cachi Pedro xì‑né: ―Icúmí iin iin‑nsia naxicocuíìn inì‑nsia sàhà cuàchi‑nsia, te cuhiì‑nsiá, ndacùcahan‑nsiá quìvì Jesucristu sàha ñá‑dùcán ndoo cuàchi anima‑nsià, te nìhìtáhvì‑nsiá nandèe Espíritu Ìì xí‑yá anima‑nsià; ");
INSERT INTO mitNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","vàchi sànì quida Stoho‑ndà Dios comprometer ñà‑ìcúmí‑ndá nìhìtáhvì‑ndà Espíritu Ìì xí‑yá nú ni cúníndísá‑ndá na caná‑yàndó. Vàtùni nìhìtáhvì‑ndà, mii‑nda, xì stná dèhe‑nda, xì stná anà‑ni nì cui mate xica gá xíndoo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ducán nì cachi Pedro xì nsidaa nècuàchìmà, vàchi cuàhà gá nì càhàn‑nè nì dàtúi‑ne ichì‑yá nùù nècuàchìmà; te dohó nì cachi stná‑nè: ―Nèhivì tiempu vichi, icúmí‑nê ndañuhu‑né, vàchi malu‑nè. Ñàyùcàndùá, nacoo‑nsianè, te càcu‑nsia ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Daaní, cuàhà gá nècuàchì yucán, nì cudiì ini‑nè palabra nì inini‑ne mà; nahi ùnì mil nèhivì nduú‑né, te nì yàha‑ne ladu xi nècuàchì xiníndísâ. Te divi quìvì yucán nì cuhiì nsidanicuú‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Daaní, iin‑ni nì quesaha‑né nchícùn‑nè palabra dacuahá nècuàchì apóstol. Mànì mánì ndoó‑né, xixí tàcá‑nè, te iin‑ni xícàn tàhvì stná‑nè nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Daaní, nsidaa nèhivì dava ga, yáha ga nì ndulocó‑nè, vàchi (nì chindee Dios) nècuàchì apóstol, te nì caquida‑ne cuàhà milagru fuerte, cuàhà milagru ndiaha. ");
INSERT INTO mitNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Te nsidaa nècuàchì xiníndísâ xí‑yâ, iin‑ni nihnú ini‑nè, te nsidaa ñà‑ndùá icúmí‑nê, nìsa xichuún tàcá‑nèà. ");
INSERT INTO mitNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Te nú iá iin ñuhù xí‑né, ò inga iñàha xi‑ne, nì dicò‑néà, nì tùi dìhùn, te nì dasàn‑né dìhùn mà según iá necesidad nùù iin iin‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Te nsìquívì nìsa nataca‑nè veheñùhu cahnú, te vehe vehe iin iin‑ne nìsa xixi tàcá stná‑nè, cudíì ini‑nè, te ndóo vàha ini‑nè, ");
INSERT INTO mitNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","te ndeníhí vàha stná‑nè Dios. Te nsidaa nèhivì dava ga, cudíì stná ini‑nè sàhà nècuàchì xiníndísámá, te quidáñúhú stná‑nè nècuàchìmà. Te quìvì quívì más gà nèhivì nì cànà nùù Stoho‑ndà Jesús ñà‑càcu anima‑nè, te nì nacuastnahá stná‑nè xì nèhivì xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Iin quìvì cutnáhâ Pedro xì Juan cuàhàn‑nè veheñùhu cahnú. Càhúnì nì cuaà cuàhàn‑nè yucán, vàchi divi hora yucán nìsa xicàn tàhvì nèhivì nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Te iin yehè cahnú veheñùhu ma nìsa nani Yehè Ndiaha. Te nsìquívì nìsa saà nèhivì yehè mà nsidá‑né iin tiàa mà cùì caca. De por sí ducán nì tùinuù‑né ñuhìví. Ñàyùcàndùá, yucán nìsa chicoo nècuàchìmà‑né sàhà‑ñá càcàn‑nè caridad nùù nècuàchi quíhvi yehè mà. ");
INSERT INTO mitNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pues vichi nì xini‑nè Pedro xì Juan ñà‑cuàhàn‑nè quìhvi stná‑nè, te sàhámà nì xìcàn‑nè iin caridad nùù nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ñàyùcàndùá nì candacoto nècuàchìmà ndé iá‑nè, te nì cachi Pedro xì‑né: ―Cundehè‑ní yohó. ");
INSERT INTO mitNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dandu nì ndacoto‑ne nùù Pedro xì Juan, cuàhàn‑nè nìhì‑né iñàha cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Doco nì cachi Pedro xì‑né: ―Ni còò plata nihí, te ni còò stná oro. Doco ñà‑ndùá sáì quide. Ndácùcahín quìvì Jesucristu de Nazaret, te cachíˋ xì‑ní ndacuiìn‑ní caca‑ní. ");
INSERT INTO mitNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dandu nì tnii‑ne ndahàcuàhá tiàa ma, nì ndacani‑ne nècuàchìmà. Te vichi duha nì ndufuerté sàhà‑né, ");
INSERT INTO mitNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","yàchì nì ndanchito‑ne, nì ndacuiin‑nè, te luegu nì quesaha‑né xicá‑né; nì quìhvi stná‑nè veheñùhu, cutnáhâ‑né xì Pedro xì Juan, nandávà nihni‑ne, xicánúú‑né naquímánì cuáhà‑né Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Te nsidaa nècuàchì itá yucán, nì xini‑nè xicánúú nècuàchìmà, ndeníhí vàha‑ne Dios, ");
INSERT INTO mitNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","te nì nacuni‑nè nècuàchìmà ñà‑ndùú‑né tiàa nìsa ìa Yehè Ndiaha veheñùhu cahnú xícàn caridad. Ñàyùcàndùá, cuàhà gá nì ndulocó nèhivì mà, nacání ini‑nè sàhà ñà‑ndùá nì cuu xi tiàa ma, te nì nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Lugar yucán nduú corredor nani Portal de Salomón. Te tiàa nì nduvàha ma, itníí ndáha stnahá vàha‑ne xì Pedro xì Juan. Dandu nsidaa nèhivì veheñùhu yucán, nì nataca‑nè ndé iá Pedro xì Juan, yáha ga ndulócô‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ñàyùcàndùá na ní xini Pedro natácà‑guá nèhivì, dandu nì càhàn‑nè xì nsidaa‑né, cachí‑nè: ―Nècuàchì ñuu‑ndà Israel, ¿índù chuun ndulócô‑nsià sàhà ñà‑yòhó? ¿Índù chuun indéhe váha‑nsia nsiùhù na ian nsiùhù nì dàndúvàha xi nècuàchì yohó cahan‑nsiá? Còó, màdì sáhà fuerza xi nsiùhù nì níhì nècuàchì yohó caca‑ne, te ni màdì sáhà ñà‑ìì guá stná‑nsì. Còó. ");
INSERT INTO mitNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","14","’Xìì‑ndà Abraham, xì Isaac, xì Jacob, nsidaa‑né nìsa cahvi‑né Dios ndiaha xi‑nda, te divi mii‑yá nduú ana nì chitnùní inì‑xi ñà‑cucumi Dèhemanì‑yá Jesús tnùñuhu ndiaha xí‑yá. Doco mii‑nsiá, nì dàyáha‑nsiayà ndahà Pilatu, te nì nacuaà‑nsiáyà na ní cuni tèmà daña‑téyâ. Ana ìì ndisa nduú‑yá, te ndàà cuisì ini‑yà, doco (cónì ndúlócô‑nsià), iin tè‑sàhní nì xìcàn‑nsià dàñà. ");
INSERT INTO mitNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Dandu nì sahnì‑nsiáyà, mate divi sàhà mii‑yá itiácú‑ndà. Doco (Yua‑nda) Dios, nì dànátiácú‑yà Jesús. Ináhá‑nsî, vàchi testigu nduú‑nsí. ");
INSERT INTO mitNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Te cunaha‑nsiá, divi sàhà ñà‑nìhnú vàha ini‑nsì mii‑yá, te ndácùcahan‑nsí quìvì‑yá, ñàyùcàndùá nì ndufuerté tiàa yohó. Indéhe‑nsiánè, ináhá‑nsiânè. Náhà xìcà sànì nduvàha vàha‑ne ñà‑nì xinindisá stná‑nè mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Te vichi sànì sànìhì inì ñà‑cónì cúndáà inì‑nsia nduá, ñánì. Stná nècuàchì cusáhnû nùù ñuu‑ndà, ni cónì cúndáà stná ini‑nè, ñàyùcàndùá nì quida‑nsia ducán. ");
INSERT INTO mitNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Doco ñà‑ndùá nì cachitnùhu Dios sànaha, divi ñà‑jaàn nduá nì cuu ndisa nì quida‑ya. Vàchi ñà‑ìcúmí Cristu ndoho‑ya, divi nduá nìsa cachi nsidaa nècuàchì profeta sànaha. Te ducán nì cuu ndisa. ");
INSERT INTO mitNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ñàyùcàndùá, naxicocuíìn inì‑nsia sàhà cuàchi‑nsia vichi, te natenchicùn‑nsià ichì mii‑yá sàhà‑ñá ndutu cuàchi‑nsia, dandu quixi tiempu cundoo ndiaha‑nsiá quida‑ya, ");
INSERT INTO mitNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","te techuún‑yá Jesucristu ndixi‑ya, vàchi divi‑ya nduú ana nì chitnùní ini Dios cunduu rey ndiaha xi‑nda. ");
INSERT INTO mitNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Doco vichi iá‑yà gloria, te yucán icúmí‑yâ coo‑ya ndè cachi sàà tiempu nsida viì‑yá nsidaa iñàha. Vàchi ducán nì cachitnùhu nèhivì xí Dios sànaha na ní càhàn‑nè nì quida‑ya. ");
INSERT INTO mitNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Vàchi ñà‑ndácuisì nduá nì cachitnùhu Moisés xì xìì‑ndà sànaha na ní cachi‑nè palabra yohó: “Icúmí Stoho‑ndà Dios nacàxin‑ya iin descendencia xi‑nda cunduu ana càhàn cuenta xi‑ya. Te divi nacua nì quida yùhù, ducán icúmí quida stná ana quixi ma. Dandu mii‑nsiá, icúmí‑nsiâ cunini‑nsia nsidaa ñà‑ndùá cachi‑yà xì‑nsiá. ");
INSERT INTO mitNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Te nú ni coó iin nècuàchì có‑cùní cunini xi‑yá, dandu icúmí nècuàchìmà ndañuhu‑né ñuu‑nè”, nì cachi Moisés. ");
INSERT INTO mitNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Cunaha‑nsiá, nsidaa nècuàchì sànaha nìsa cahàn cuenta xi‑ya, inii décuèndè tiempu nìsa cahàn Samuel te vàxi duha, nsidaa‑né nì càhàn‑nè sàhà tiempu vitni. ");
INSERT INTO mitNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Te vichi, mii‑nda nduu‑nda dèhe nècuàchì nìsa cahàn razón mà. Ñàyùcàndùá icúmí‑ndá nìhìtáhvì‑ndà ñà‑ndiaha íì nì quida Dios comprometer xì xìì‑ndà na ní saquin‑yà tratu xì Abraham, te nì cachi‑yà palabra yohó: “Sàhà iin descendencia xi‑ní icúmí quixi ñà‑ndiaha íì cundiatú anima nsidanicuú nèhivì ñuhìví”, nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","’Ñàyùcàndùá, dihna ndohó nècuàchì (ñuu yohó) nì nìhìtáhvì‑ndà, vàchi divi chuun jaàn ní sàhatahvì Dios Dèhemanì‑yá (Jesús), nì quixi‑ya ndé ndoo‑nda ñà‑cundiatú anima nsidaa‑nda nú ni náxícócuîìn ini‑ndà, te nacoo‑nda ichì malu nchícùn‑nda ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Daaní, na meru cáhàn‑nè xì nèhivì yucán, dandu nì caquesaa nècuàchì nduú dùtù ndé itá‑né, cutnáhâ nècuàchìmà xì comandante ndiaá veheñùhu cahnu‑ma, te cutnáhâ stná‑nè xì nècuàchì saduceu, ");
INSERT INTO mitNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","có‑ndôo ini‑nè ñà‑chìnáhá Pedro xì Juan sàhà nansa natiacu‑ndà quida Jesús. ");
INSERT INTO mitNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ñàyùcàndùá, nì tnii‑ne nècuàchìmà nì chicadi‑ñàné vehecàa, te sàhà ñà‑sànì cuaà, ñàyùcàndùá nì candòo‑ne yucán ndè inga quìvì. ");
INSERT INTO mitNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Doco nècuàchì nì inini nì càhàn Pedro xì Juan palabra xi Dios, cuàhà‑né nì xinindisá‑né, ndè ùhùn mil sànì nanduu nècuàchì tiàa xiníndísâ. ");
INSERT INTO mitNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Daaní, inga quìvì nì nataca nècuàchì cusáhnû, xì nècuàchì sahnú nchichí, xì nècuàchì ley xi veheñùhu, nsidaa‑né nì nataca‑nè ");
INSERT INTO mitNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ñuu Jerusalén yucán. Te nì sàà stná dùtù cusáhnû nani Anás, xì stná Caifás, xì Juan, xì Alejandro, xì nsidaa dava ga tnaha dùtù cusáhnúmá. ");
INSERT INTO mitNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dandu nì tavà‑né Pedro xì Juan ñà‑cundaca tnahá‑né quixi, te nì sàcuìta nècuàchìmà dava mahì‑xí. Dandu nì candacàtnùhù nècuàchì Junta mà nùù‑né, cachí‑nè: ―¿Ana dìvalor‑xi nì càhàn‑nsià sàhà‑xí nì quida‑nsia ñà‑ndùá nì quida‑nsia? ¿Ana dìquívì‑xí nì ndacùcahan‑nsiá? ");
INSERT INTO mitNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dandu fuerte nì quixi Espíritu Ìì xí Dios ini anima Pedro, te nì naxiconihí‑né nùù nècuàchìmà, cachí‑nè: ―Mii‑nsiá nècuàchì xícusahnú ñuu‑ndà yohó, xì mii stná‑nsià nècuàchì sahnú nchichí raza‑ndà Israel, cunini vàha‑nsia. ");
INSERT INTO mitNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Vichi xícàn tnùhù‑nsiá nùù‑nsí nansa nì quida‑nsi iin obra xì nècuàchì ndahví yohó, nansa nì nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pues ni cúnáhá mii‑nsiá xì nsidaa stná nècuàchì Israel ñà‑divi Jesucristu de Nazaret nduú ana dìquívì‑xí nì ndacùcahan‑nsí, te nì nduvàha‑ne. Te yohó iín stná‑nè dava mahì‑nsiá, indéhe‑nsiánè. Te mate ní chituu‑nsia Jesucristu nchìca cruz, te nì xìhì‑yà, doco nì natiacu‑yà nì quida Yua‑nda Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Te mate ní cahíchì íní‑nsiàyà, doco vichi sànì cuu xi‑yá na ian nì cuu xi iin cavà nì cahíchì ini albañil, te después nì sàà nì sàcùndua yùù vìcò indúhu esquina vehe. ");
INSERT INTO mitNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Te còò inga gà ana sáha xi salvación, cuisì mii‑yá. Vàchi inicutu ñuhìví còò inga gà ana dìquívì‑xí ndacùcahan‑nda, te càcu‑nda nùù‑xí. Còò inga gà ana nì techuún Dios ñuhìví yohó ñà‑dacácu xi‑nda, cuisì mii‑yá ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dandu nècuàchì dandacuma, nì xini‑nè, có‑yûhî Pedro cáhàn‑nè, te có‑yûhî stnâ Juan. Te ni có‑ndùú stná ñà‑nì dàcuàhá cuáhà‑né, còó, vàchi cónì xíca cuahà‑né escuela. Ñàyùcàndùá, na ní quida nècuàchì Junta mà cuenta ducán, nì ndulocó‑nè, te nì cundaà ini‑nè, divi Jesús nìsa cutnahá xi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Te tiàa nì nduvàha ma, yucán iín stná‑nè xì nècuàchìmà. Ñàyùcàndùá, mà nì cùí nìhìndèè nècuàchì Junta mà canicuàchi‑ne sàhà Pedro xì Juan. ");
INSERT INTO mitNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ñàyùcàndùá, nì dàndàcú‑né ni cáquéé nècuàchìmà iladu, te nì ndatnuhu nsidaa‑ní mii‑né, ");
INSERT INTO mitNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","cachí‑nè: ―¿Nansa quida‑nda xi nècuàchì caá? Vàchi iin milagru cahnú ndisa nduá nì quida‑ne, ináhá nsidaa nèhivì ñuu‑ndà Jerusalén yohó, te ùhì cachi‑nsì nduá tnùhu. ");
INSERT INTO mitNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Doco sàhà‑ñá màsà cuítià gà palabra yohó, chicá vàha dayúhî‑ndàné ñà‑màsà cáhàn gà‑nè sàhà Jesús xì ni‑iin nèhivì ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dandu nì cana‑ne Pedro xì Juan, te fuerte nì chinaha‑né nècuàchìmà ñà‑màsà cáhàn gà‑nè xì nèhivì sàhà Jesús, ni màsà dácuáhâ gá‑nè ni‑iin nèhivì sàhà‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Doco Pedro xì Juan, nì cachi‑nè: ―¿Índù ñà‑tùxí ini mii‑nsiá, a chicá vàha cunini‑nsi ñà‑ndùá cachí mii‑nsiá, te ò ñá‑ndùá cachí Dios? ");
INSERT INTO mitNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pues cunaha‑nsiá, có‑ndùá ducán cuhihin‑nsí. Vàchi ndiá ìcà‑nsí càhàn‑nsì xì nèhivì ñà‑ndùá sànì xininùù‑nsí xì ñà‑ndùá sànì tiacu tùtnù‑nsí ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dandu nècuàchìmà, chicá nì càhàn dana‑ne xì Pedro xì Juan, dandu después nì daña‑ñané, vàchi cónì túi ni‑iin falta ñà‑ndoho‑ne. Te yúhî stnâ nècuàchì dandacu‑ma ñà‑vihini nacuidà nèhivì cuáhà ñuu‑nè, vàchi nsidaa nècuàchìmà, naquímánì‑né Dios sàhà ñà‑ndùá nì cuu. ");
INSERT INTO mitNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Vàchi tiàa nì nduvàha sàhà milagru mà, sànì yàha‑ne ùì dico cuìà xicá‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Daaní, na ní quee Pedro xì Juan libre, dandu mànuhù‑né ndé ndoó compañeru‑nè, te nì cachitnùhu‑ne nsidaa ñà‑ndùá nì cachi dùtù xícusahnú, xì ñà‑ndùá nì cachi nècuàchì sahnú xídandacú. ");
INSERT INTO mitNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Te nì nsihi nì cachitnùhu‑ne, dandu nsidaa‑né, iin‑ni nì xìcàn tàhvì‑né nùù Dios, cachí‑nè: ―Stoho‑nsì Señor, na mii‑ní nduu‑ní Dios; cuisì mii‑ní nduú ana nì quidavàha xi ansivi, ñuhù íchî, mar, xì nsidaa stná iñàha iá inicutu ñuhìví xì ansivi. ");
INSERT INTO mitNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Te mii‑ní nduú ana nì dàcáhàn xì iin nècuàchì sànaha cahvi xi‑ní, divi xìì‑nsí David, te dohó nì cachi nècuàchìmà: Nèhivì ñuhìví, ¿índù chuun cuadú guâ‑nè, te cánàhá guâ‑nè dìquì Dios? ¿Índù chuun nacání guâ ini cuàhà raza nèhivì quida‑ne ñà‑có‑ndiàá? ");
INSERT INTO mitNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Vàchi cuàhà rey xícusahnú ñuhìví yohó, nì sàcuìta listu‑te xi dava ga tè‑xídandacú; nì nataca nsidaa‑té ñà‑cuni ùhì‑te Yua‑nda Dios xì Dèhemanì‑yá Cristu, nì cachi David. ");
INSERT INTO mitNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Te divi ñà‑ndáà nduá, vàchi ducán nì cuu, divi ñuu yohó nì nataca rey Herodes, xì Poncio Pilatu, xì stná nècuàchì ñuu Israel yohó, xì stná cuàhà nèhivì inga nación, vàchi cuní‑nè quida quini‑ne xì Dèhemanì‑ní Jesús, mate divi‑ya nduú ana nì chitnùní inì‑ní cusahnú. ");
INSERT INTO mitNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Doco na ní quida nècuàchìmà ducán, cuisì ñà‑ndùá nì nacani inì‑ní dihna nì sandua, te nì sàha‑ní lugar nì quida‑ne ducán; vàchi mii‑ní, nì chitnùní inì‑ní coo ducán, ");
INSERT INTO mitNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Stoho‑nsì Señor. Te vichi (xícàn tàhvì‑nsí) ñà‑cunini‑ní ñà‑ndùá cachí nècuàchìmà, ndee gá cáhàn‑nè, cuní‑nè dayúhî‑nè nsiùhù. Doco nacuàhandee inì‑ní nsiùhù nècuàchì cahvi xi‑ní, te ducán vàtùni cachitnùhu‑nsi palabra ìì xí‑nî, te mà yúhî‑nsì. ");
INSERT INTO mitNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Xícàn tàhvì‑nsí nùù‑ní ñà‑nì dándûvàha‑ní nècuàchì cuhí sàhà poder ìì xí‑nî. Te nsiùhù, icúmí‑nsî ndacùcahan‑nsí Dèhe ndiaha‑ní Jesús, dandu mii‑ní quida‑ní nsidaa clase milagru (cundehè nèhivì) ―nì cacachi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Daaní, nì nsihi nì xìcàn tàhvì‑né nùù Dios ducán, dandu nì ndacùchí vehe ndé ndoó‑né, te fuerte nì quixi Espíritu Ìì xí‑yá ini anima nsidaa‑né, te ndee ní càhàn‑nè palabra ìì xí‑yá, cónì yúhî‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Cunaha‑ní, iin‑ni sàxìnítnùní nìsa icumi nsidanicuú nècuàchì xiníndísâ. Còò ni‑iñàha nìsá xídáhán‑nê nùù ñanìtnaha‑ne, vàchi iin‑ni cahnú‑ní nìsa ìa nsidaa ñà‑ndùá icúmí‑nê. ");
INSERT INTO mitNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Te poder cahnú xí Dios, cuàhà gá nì chindeá nècuàchì apóstol, vàchi fuerte nì càhàn‑nè sàhù sàhà nansa nì xininùù‑né Stoho‑ndà Jesús na sánì natiacu‑yà. Te cuàhà stná gracia xi‑ya iá nùù nsidaa nèhivì xí‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ñàyùcàndùá, cónì quìdámánì ni‑iñàha nùù ni‑iin‑ne, vàchi nècuàchì nìsa ìa ñuhù‑xí, ò vehe‑xi, nì dicò‑néà, te nihí‑né dìhùn mà nì sàhàn nì nacoo‑neà nùù nècuàchì apóstol, dandu mii‑né, nì dasàn‑néà nùù nèhivì icúmí necesidad. ");
INSERT INTO mitNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Te iin nècuàchì nì dicò mà nani José; doco Bernabé nìsa cachi nècuàchì apóstol xì‑né, vàchi quìvì mà, iin ana nácuàhandee ini xì‑ndà cuní cachàmà. Ñuu Chipre nduú ñuu‑nè, te Leví nduú yohòtéhè‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Pues divi‑ne nìsa icumi stná xì iin ñuhù, te nì dicò‑néà. Dandu nihí‑né dìhùn yàhvia nì sàhàn nì sàha‑ne nècuàchì apóstol, te nì ndòa ndahà nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Daaní, nìsa ìa iin tiàa nani Ananías xì ñahàdìhí‑nè Safira, te nì dicò stná‑nè iin ñuhù. ");
INSERT INTO mitNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Doco nì chivàha cuaán‑né chii dìhùn sàhámà. Dandu dìhùn nì cusobrá mà nduá nì tnii nècuàchì tiàa ma, te nihí‑néà nì sàhàn nì sàha‑ne nècuàchì apóstol, (na ian iá nsiha). Te ináhá stná ñahàdìhí‑nè nansa nì quida‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Doco Pedro, nì cachi‑nè: ―Ananías, ¿índù chuun nì sàha‑ní nì dacà ñà‑malu dìnì‑ní? Dècuèndè cuní‑nî dandahví stnâ‑ní Espíritu Ìì xí Dios, vàchi nì chidèhé‑nî sàhà ñuhù mà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Amádi ñuhù xí mii‑ní nì sandua daa, te vàtùni quida‑ní disponer sàhá? Daaní, na sánì dicò‑níà, ¿amádi díhùn xí mii‑ní nì sanduu stná? ¿Índù chuun nì nacani quini inì‑ní, te nì quida‑ní dohó? Cunaha‑ní, màdì núù nèhivì nì cáhàn tnùhù‑ní. Còó, nùù Dios nì càhàn tnùhù‑ní ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Daaní, na ní nsihi nì inini Ananías ducán, dandu nì natnahnù‑nè, te nì xìhì‑nè. Te nsidaa ana nì xinitnùhu ma, nì yùhí cuaá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dandu nì caquixi tiàa cuachi gá, nì chidùcún‑te nsìi ma, te nì xida‑tèndó cuàhàn‑ndà cundùxin‑nda. ");
INSERT INTO mitNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Daaní, na ní yàha ùnì hora, nì quesaa stná ñahàdìhí ndómà, doco tàñáha ga cunitnùhu‑ne nansa nì cuu. ");
INSERT INTO mitNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Dandu nì ndàcàtnùhù Pedro nùù‑né, cachí‑nè: ―Cachì‑ní xìˊ, ¿a ndísá tantu dohó nì dicò‑nsiá ñuhù xí‑nsiá? Te cachí nècuàchìmà: ―Jaan, divi ducán nì sandua. ");
INSERT INTO mitNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dandu nì cachi Pedro xì‑né: ―¿Índù chuun nì ndatnuhu ndúì‑nsià quida‑nsia ducán, a ndísá cuìdà ini Espíritu Ìì xí Stoho‑ndà Señor, cahan‑nsiá? Cunaha‑ní, tiacú sànì nsiaa ana nì casahàn nì sùxin xi iì‑ní, te vichi icúmí‑tê cunsida stná‑te mii‑ní cùhùn ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Te vichi duha nì natnahnù stná nècuàchìmà nùù sàhà Pedro, te nì xìhì‑nè. Te na ní nansìhvi tècuachima, sànì xìhì‑nè nì xinì‑te, ñàyùcàndùá, nì tavà stná‑te nsìi ma nì sàhàn‑te nì sùxin stná‑te ndómà divi ndé nì sàcùndùxin nsì‑iì‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ñàyùcàndùá, cuàhà gá nì yùhí nsidaa nècuàchì xiníndísâ ichì‑yá, mii‑né xì nsidaa stná nècuàchì dava ga nì xinitnùhu ma. ");
INSERT INTO mitNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Daaní, nècuàchì apóstol, ndiaha gá nì caquida‑ne cuàhà milagru nì indehè nèhivì. Te nsidaa nècuàchì xiníndísámá, nsìquívì nìsa nataca‑nè nùù Portal de Salomón (iá yehè veheñùhu). Te iin‑ni sàxìnítnùní nìsa icumi nsidaa‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Doco nèhivì dava ga, ni‑iin‑ne cónì sáhandee ini‑nè cutnahá‑né xì nècuàchì natácá mà, mate ndeníhí vàha cuahà‑né nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Te nì sàà nì xinindisá cuáhà gá nèhivì, tiàa te ñahà‑né, nì xinindisá‑né Stoho‑ndà Señor. ");
INSERT INTO mitNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Dècuèndè nìsa tavà stná nèhivì nècuàchì cuhí xi‑ne, nì chitànduhù‑né nècuàchìmà yuhù ìchí, dava‑ne nùù cama, te dava‑ne nùù yuì, ndiatú‑né yàha Pedro, áma dúcùn‑nè casì nècuàchìmà, te nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Stná ñuu cuati ndoó yatni nì caquee cuàhà stná nèhivì vàxi ñuu Jerusalén ndacá‑né cuàhà nècuàchì ndohó quidá cuèhè, xì stná nècuàchì dandohó ñà‑malu. Te nsidaa‑né, nì nduvàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dandu dùtù xícusahnu‑ma, yáha ga nì cumbìdia ini‑nè, mii‑né xì compañeru‑nè tè‑ndùú nècuàchì saduceu. ");
INSERT INTO mitNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ñàyùcàndùá, nì tnii‑ne nècuàchì icúmí chuun nùù Jesús, te nì chicadi‑nè nècuàchìmà vehecàa. ");
INSERT INTO mitNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Doco iin ángel xi Stoho‑ndà Señor, ñuú nì sàà‑nè vehecàa yucán, te nì nacuna‑ne yehè nì tavà‑né nècuàchìmà, te nì cachi‑nè: ");
INSERT INTO mitNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Cuahán‑nsià cuita‑nsia veheñùhu cahnú, te nacani‑nsia xì nèhivì nansa nìhìtáhvì‑né cutiacu ndiaha anima‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ducán nì dàndàcú‑né nùù nècuàchìmà quida‑ne. Ñàyùcàndùá, na ní tùinuù, dandu nì quìhvi‑ne veheñùhu cahnú, te nì quesaha‑né dacuahá‑né nèhivì. Daaní, dùtù cusáhnû, xì compañeru‑nè, nì cana‑ne nècuàchì Junta ñà‑nataca nsidaa‑né, te quixi stná nsidaa nècuàchì sahnú nchichí ñuu Israel yucán. Dandu nì techuún‑né policía cuàhàn‑te vehecàa ñà‑cundaca‑tè nècuàchì ndiadí quixi. ");
INSERT INTO mitNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Doco na ní casaà‑te yucán, còò cá iin ni ndácùhun‑tè. Ñàyùcàndùá, nì naxicocuíìn‑te nì cachitnùhu‑tè, ");
INSERT INTO mitNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","cachí‑te: ―Ñà‑ndáà nduá, ndiadí vàha yehè vehecàa ma, te itá stná soldadu ndiaá xán, doco na ní nacuna‑nsi, còò cá nècuàchì ndiadí mà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dandu dùtù cusáhnû, xì comandante ndiaá veheñùhu, xì stná dùtù nihí gá chuun nahnú, nì ndulocó‑nè na ní xinitnùhu‑ne ducán. ¿Índù fin cucumi chuun yohó? cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Daaní, divi momentu mà nì quesaa inga tiàa nì cachitnùhu xi‑né: ―Cunaha‑nsiá, nècuàchì nì chicadi‑nsià vehecàa, yucán sàndòó‑né veheñùhu cahnú, dacuahá‑né nèhivì ―nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dandu comandante mà, cuàhàn‑te xi policía xi‑tè, te vivìí‑ni nì saca‑tè nècuàchìmà vàxi‑ne, vàchi yúhî‑te nèhivì cuáhà mà ñà‑vihini cacani yuu‑néte cahan‑té. ");
INSERT INTO mitNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ñàyùcàndùá, ndacá‑te nècuàchìmà nì quesaa, te nì sàcuìta‑ne nùù nsidaa nècuàchì Junta mà. Dandu nì cachi dùtù cusáhnû: ");
INSERT INTO mitNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Amádi sánì dàndàcú‑nsí nùù‑nsiá ñà‑màsà chínáhá gà‑nsià nèhivì sàhà Jesús? Doco vichi, nsidanicuú lugar ñuu yohó sànì càhàn‑nsià sàhù ñà‑ndùú dàñùhù xi‑nsia, te cuní‑nsià ñà‑nsiùhù nacuida‑nsi cuàchi sàhà nècuàchì nì xìhì mà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dandu Pedro xì dava ga nècuàchì apóstol, nì naxiconihí‑né nùù nècuàchìmà, cachí‑nè: ―Nsiùhù, icúmí‑nsî cunchicùn‑nsì ñà‑ndùá cachí Dios, te màdì ñá‑ndùá cachí nèhivì ùún. ");
INSERT INTO mitNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mii‑nsiá nì chituu‑nsia Jesús nchìca cruz. Doco mate modo ducán nì sahnì‑nsiáyà, doco vichi sànì natiacu‑yà nì quida Dios, divi mindaa Dios nìsa cahvi xìì‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Te vichi sànì saquin‑yà Jesús ndahà cuàhá‑yà ñà‑cunduu‑ya ana cusáhnû, te cunduu stná‑yà ana dacácu xi‑nda. Te ducán nì cuu sàhà‑ñá ni cuu‑nda arrepentir, nsidaa ndohó nècuàchì ñuu Israel yohó, te ducán nìhì‑yá nansa cuicahnú ini‑yà sàhà cuàchi‑nda. ");
INSERT INTO mitNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Te nsiùhù, testigu xínduu‑nsi, vàchi nì xininùù‑nsí ducán nì cuu. Te testigu nduú stná Espíritu Ìì xí‑yá ñuhú ini anima‑nsì, vàchi nsidaa ana cunini xi‑yá, nìhìtáhvì‑né ndèe Espíritu Ìì xí‑yá ini anima‑nè quida‑ya ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Doco nècuàchì dandacu‑ma, na ní inini‑ne ñà‑jaàn, yáha ga nì caxidà ini‑nè, te nì quesaha‑né nì ndatnuhu tnahá‑né nansa dandáñúhú‑nê nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Doco nùù nèhivì Junta mà, iá iin maestru nani Gamaliel, iin nècuàchì fariseu chináhá xì ley xi Dios. Nècuàchì vàha nduú‑né cachí nsidaa nècuàchì ñuu yucán. Te divi‑ne nì ndacuiin‑nè nì dàndàcú‑né quee cuaán chii nècuàchì apóstol mà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dandu nì cachi‑nè xì nsidaa compañeru‑nè yucán: ―Nsidaa mii‑nsiá nècuàchì raza‑ndà Israel, cuidadu ni cúndóó‑ndá sàhà ñà‑ndùá quida‑nda xi nècuàchì càá. ");
INSERT INTO mitNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Vàchi ¿a có‑nsînuu inì‑nsia nansa nì cuu tiempu na ní ìa iin tiàa nani Teudas? Tè‑càhnú ícà‑xí nduú‑te nìsa cachì‑te. Te nahi cùmì cientu nèhivì nì quìhvi tnahá xi‑té nì sanchicùn‑nète. Doco por fin nì sahnì nèhivì‑té, te nì xìtià nihni nsidaa nècuàchì nchícùn xì‑té, te ducán nì nsihi chuun ma. ");
INSERT INTO mitNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Daaní, después nì yàha inga casu na tiempu nì cuu‑nda empadronar. Iin tiàa ladu Galilea nani Judas, nì nìhì‑té nì dàyáha‑tè cuàhà nèhivì ladu xi‑tè. Doco nì xìhì stná‑te, te nì xìtià nihni stná nsidaa nèhivì nì chiyuhù‑té. ");
INSERT INTO mitNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ñàyùcàndùá, yùhù cachíˋ xì‑nsiá vichi, ni cúnàhá nècuàchì sànì tnii‑nda jaàn. Chicá vàha nacoo‑ndané, vàchi nú inì‑ni mii‑né nì nacani ini‑nè quida‑ne ñà‑ndùá quidá‑né, dandu icúmíâ ndòo uan. ");
INSERT INTO mitNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Doco nú Dios nì dàndàcù‑xì nùù‑né, dandu mà nunca nìhì‑ndà cadi‑ndà nùù‑né, te cachíˋ, còtó Dios nàá stnàhà‑xì‑ndà ―nì cachi Gamaliel mà. ");
INSERT INTO mitNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Dandu nsidaa compañeru nècuàchìmà, nì dàjuùn‑nè nècuàchìmà, te nì cana‑ne nècuàchì apóstol nì nansìhvi tu‑ne. Dandu nì sahnì cuìí‑nè nècuàchìmà, te nì chinaha‑ñánê ñà‑màsà cáhàn gà‑nè xì nèhivì sàhà Jesús. Dandu nì daña Junta Cahnu‑mané, ");
INSERT INTO mitNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","te nì caquee‑ne libre, cudíì ini‑nè ñà‑nì natùi stná‑nè ndoho‑ne sàhà chuun xi mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Daaní, nsìquívì vehe vehe nìsa xìcanuu‑ne dacuahá‑né nèhivì. Sáhàn stná‑nè veheñùhu cahnú, te chináhá stná‑nè nèhivì yucán, cáhàn‑nè sàhù sàhà Jesucristu, ni‑iyuhu cónì nácóó‑néàmà. ");
INSERT INTO mitNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Quìvì yucán vihi gá nì nducuahà nècuàchì nchícùn ichì mii‑yá; dava‑ne cáhàn‑nè dàhàn hebreu, te dava ga‑nè cáhàn‑nè dàhàn griegu. Dandu nì quesaha nècuàchì griegu mà nì xitnùhu‑ne compañeru‑nè cáhàn hebreu, vàchi ñahàcuàán xí‑icumi nècuàchì griegu mà, có‑nîhì váha‑ne ñà‑cutiacu‑nè na dásàn‑ñà quìvì quívì. ");
INSERT INTO mitNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ñàyùcàndùá nì cana nsì‑úxìn ùì apóstol nsidaa nècuàchì xiníndísâ, te nì cachi‑nè xì nècuàchìmà: ―Nsiùhù, có‑ndùá ñà‑nacoo nihni‑nsi chuun xi palabra xi Dios, te cacanuu‑nsi dasàn‑nsí ñà‑cutiacu nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ñàyùcàndùá, mii‑nsiá nanducu‑nsiá ùsà tiàa nchichí dandacú sàhà chuun yohó, ñánì. Nècuàchì tnùñuhu ni cúndúú‑né, te ni coó chitu stná anima‑nè Espíritu Ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Doco nsiùhù, iin‑ni cuàhàn‑nsì quida‑nsi seguir càcàn tàhvì‑nsí nùù‑yá, te dacuahá‑nsí nèhivì palabra xi‑ya ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Daaní, nsidaa nèhivi mà, nì cudiì ini‑nè ñà‑ndùá nì cachi nècuàchì apóstol mà. Ñàyùcàndùá, nì caquee nombradu ùsà tiàa. Iin‑ne nani Esteban. Iin nècuàchì nihnú vàha inì‑xi nduú‑né, te chitu stná anima‑nè Espíritu Ìì xí Dios. Te nì caquee stná nombradu nècuàchì nchícùn yohó: Felipe, Prócoro, Nicanor, Timón, Parmenas, xì Nicolás. Nècuàchì inga raza nì quixi ñuu Antioquía nduú Nicolás mà, doco nì yàha‑ne religión xi nècuàchì raza Judea. ");
INSERT INTO mitNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Daa‑ní, nsidaa nèhivi mà, nì saca‑ne nècuàchì nombradu mà nùù nècuàchì apóstol; dandu apóstol mà, nì xìcàn tàhvì‑né nùù Dios, te nì chindòó‑né ndahà‑né dìnì nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Daaní, después, chicá más nì cucuahà palabra xi Dios, vàchi cuàhà gá nèhivì ñuu Jerusalén nì sàà nì xinindisá, te cuàhà gá stná nècuàchì dùtù nì sàà‑nè nì xinindisá stná‑nè palabra mà. ");
INSERT INTO mitNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Daaní, nì xìcanuu Esteban mahì nèhivì, te nì quida‑ne cuàhà milagru ndiaha, vàchi cuàhà gá icúmí‑nê gracia xi Dios, te fuerte iá palabra cachí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Doco dava nèhivì, nì quesaha‑né náâ tnahá‑né xì nècuàchìmà. Nèhivì sáhàn veheñùhu nani Veheñùhu xi Nèhivì Libre xínduu‑ne, te nì caquixi‑ne inga ñuu, divi ñuu Cirene, xì ñuu Alejandría, xì ladu Cilicia, xì ladu Asia. ");
INSERT INTO mitNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Doco mànìcùí nìhìndèè‑né màcòdònùù‑né nùù Esteban, vàchi chindéé Espíritu Ìì xí Dios‑nè cáhàn nchichí‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ñàyùcàndùá, nècuàchì náâ xì‑némà, nì nducu‑né iin ùì tètnùhù, te nì chiyàhvi‑nète ñà‑càhàn tnùhù‑té dìquì Esteban. Sàhà ñá‑jaàn, dohó nì cachi tèmà: ―Nì inini‑nsi nì cachi quini Esteban dìquì (yua‑nda) Moisés xì dìquì stná Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ñàyùcàndùá, ducán nì nìhì nècuàchì malu mà nì dànácuîdà‑nè nèhivì ñuu mà, mii‑né xì stná nècuàchì sahnú dandacú, xì stná nècuàchì ley xi veheñùhu, te nì quida cuahà‑né sàhà Esteban; yàchì nì sàà‑nè ndé iá nècuàchìmà, te nì tnii‑ñané, te ndacá‑ñánê nì casaà nùù nècuàchì Junta. ");
INSERT INTO mitNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yucán nì cana‑ne tètnùhù mà nì tnàtuu‑tè, te nì sanicuàchi‑tè sàhà Esteban, cachí‑te: ―De por sí, tùha quini tè‑jaàn, vàchi quini cáhàn‑te dìquì veheñùhu ìì xì‑ndà, xì dìquì stná ley ìì xì‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Te nì inini stná‑nsì nì cachì‑te ñà‑ìcúmí quixi Jesús de Nazaret, te dacaá‑né veheñùhu xi‑nda. Dandu fuerza icúmí dàma estilu xi‑nda, divi estilu nì nacoo xìì‑ndà Moisés ―nì cachi tèmà. ");
INSERT INTO mitNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dandu nsidaa nèhivì ndoó Junta mà, nì indehè‑né nùù Esteban, te nì xini‑nè, na indéhe ángel indéhe nècuàchìmà vichi. ");
INSERT INTO mitNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dandu dùtù cusáhnû, nì cachi‑nè xì Esteban: ―¿A díví ñà‑ndáà nduá (xícachi nècuàchì jaàn), á coó? ");
INSERT INTO mitNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Dandu nì naxiconihí Esteban, cachí‑nè: ―Mii‑nsiá, nècuàchì sahnú nchichí, cunini chii‑nsiá, ñánì, vàchi (cuàhìn nacani) nansa nì quida Dios ndiaha xi‑nda sànaha dècuèndè na iá ìì xìì‑ndà Abraham ñuu nani Mesopotamia. Tàñáha ga nadàma‑ne ndè ñuu Harán, dandu nì dàcùní Dios‑nè mii‑yá, ");
INSERT INTO mitNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","te dohó nì cachi‑yà xì‑né: “Nacoo‑ní ñuù‑ní yohó, te nacoo‑ní tnaha‑ní, quihin‑ní ichì cuahán‑nî inga ñuu icúmî dacuníˋ mii‑ní”. ");
INSERT INTO mitNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ñàyùcàndùá, nì quee‑ne ladu Caldea yucán, te nì sàà‑nè ñuu Harán. Te ñuu mà nì ndòo‑ne dècuèndè nì xìhì yua‑né. Dandu inga xichi nì càhàn tu Dios xì‑né, ñàyùcàndùá nì quihin‑ne ichì nì quesaa‑nè ñuu yohó ndé ndoo‑nda vichi. ");
INSERT INTO mitNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Doco cónì sáha‑yanè ni‑iin ñuhù cunduu ñuhù xí mii‑né, ni siquiera iin ñuhù tìì. Doco nì cachi‑yà xì‑né ñà‑después cuàhàn‑yà dacútâhvì‑yánè inii ñuu yohó, te cucumi‑néà, mii‑né xì dèhe‑ne. Ducán nì cachi‑yà xì‑né, mate táyôo ni‑iin dèhe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Te nì cachi stná‑yà ñà‑ìcúmí descendencia xi‑ne sàà‑nè cundoo‑ne inga ñuu xìcà ndé cuichuún uun‑ni nècuàchìmà‑né, nì cachi‑yà; te cuàhà ìcúmí‑nê ndoho‑ne quida nècuàchìmà, te cùmì cientu cuìà cundua. ");
INSERT INTO mitNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Doco dohó nì cachi stná‑yà (xì Abraham mà): “Después icúmî dandohó stnáì nèhivì cuichuun‑xi tnaha‑ní ñuu xìcà mà, dandu caquee‑ne libre, ndixi‑ne cahvi‑né yùhù lugar yohó”, nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dandu nì quida stná‑yà iin tratu xì Abraham, nì cachi‑yà ñà‑ìcúmí tàhndè iin seña ìcà nsidaa dèhe ii‑né. Ñàyùcàndùá, na ní tùinuù dèhe ii‑né nani Isaac, dandu tìxi ùnà quìvì nì sàcùnihi seña ìcà‑vé. Daaní dèhe Isaac mà nani Jacob, nì sàcùtuu stná seña mà ìcà‑vé. Te divi‑ni ducán nì quida stná Jacob mà xì nsìhúxìn ùì dèhe ii‑né, divi nècuàchì nduú xìì‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Te xìì‑ndà mà, nì cumbìdia ini‑nè sàhà ñani chii‑né nani José. Te ñàyùcàndùá nì dicò‑né nècuàchìmà nùù nèhivì cuàhàn ñuu Egipto. Doco Dios, nì cutnahá stná‑yà xì nècuàchìmà iá‑nè ñuu yucán, ");
INSERT INTO mitNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nì dàyáha‑yanè nùù nsidaa tnùndoho nì xini‑nè. Dandu nì cunchichí‑nè nì quida‑yà, te nì ndòo manì‑né nùù rey Faraón ñuu Egipto yucán, vàchi mii‑yá nì chindee‑yánè. Te nì quida rey mà nombrar José ñà‑cunduu‑ne nècuàchì cu‑uì nùù‑té ñuu mà, dècuèndè nì cachì‑te ñà‑dandacú stná‑nè nùù nsidaa nècuàchì quidachuún vehe‑tè. ");
INSERT INTO mitNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Daaní, nì quixi iin tnama inicutu ñuu mà, xì stná inii ñuu Canaán; iin tnùndoho cahnú nì sandua. Te xìì‑ndàmà, có‑nîhì gá‑nè ñà‑cutiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Dandu nì xinitnùhu yua‑né Jacob ñà‑ìá trigu ndè ñuu Egipto. Ñàyùcàndùá, nì techuún‑né dèhe‑ne cuàhàn‑nè ñuu mà. Te primeru viaji nì sanduamà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Daaní, viaji ùì nduá na ní dàtúi José mii‑né nùù ñani‑nèmà. Dandu nì cundaà ini rey Faraón índù raza nèhivì nduu José. ");
INSERT INTO mitNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Te nì dàquìxí stná José iin razón ñà‑cùhùn stná yua‑né Jacob xì nsidaa stná tnaha‑ne. Te nsidaa nsidaa‑né ùnì dico sàhùn (75) nduú‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ñàyùcàndùá, nì sàà Jacob ñuu Egipto mà, te yucán nì ndòo‑ne dècuèndè nì xìhì‑nè, mii‑né xì nsidaa stná dèhe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Doco después nì natavà xìì‑ndà iquì nsìi ma, te nihí‑néà màndixi‑ne ñuu‑nè yohó dècuèndè ndè iá ñuu tii Siquem, te yucán nì ndùxan ini iin cueva, divi cueva nì xiin xìì‑ndà Abraham nùù dèhe iin tiàa nani Hamor. ");
INSERT INTO mitNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Daaní, nì cuyatni tiempu cuu ndisa ñà‑ndùá nì cachi Dios na ní càhàn‑yà xì Abraham daa. Te yáha ga nì nducuahà descendencia xi nècuàchìmà ndoó ñuu Egipto yucán; cuàhà sàstnùhù nì nanduu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Dandu nì quìhvi inga rey dandacú nùù ñuu yucán. Te rey mà, cónì cúndáà inì‑te nansa (nì chindee) José antes. ");
INSERT INTO mitNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ñàyùcàndùá, nì dàndàhví‑te xìì‑ndà mà, nì quida quini‑tè xì‑né, nì dàndàcú‑te nùù‑né ñà‑nacoo nihni‑ne méè cuati xí‑né sàhà‑ñá cui‑vè. ");
INSERT INTO mitNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Te divi tiempu mà nì tùinuù Moisés ñuhìví, te cudíì ini Dios sàhà‑vé. Cutu únì yòò nì ìa‑ve xì yuadíhí‑vê, ");
INSERT INTO mitNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Te nì sàà hora icúmí‑nê nacoo nihni‑nevè, doco (nì càcu‑ve), vàchi nì ndacùhun iin dèheyoco rey mà‑vé. Te nì dàcuàhnú‑ñavé na iin dèhe‑ñà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Dandu después nì dàcuàhá vàha‑ne nsidaa palabra nchichí ñuu Egipto yucán. Nì cutùha vàha‑ne càhàn‑nè sàhù, te nì ìa stná fama‑nè sàhà chuun nahnú nìsa quida‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Daaní, na cuáhàn‑nè xìnu‑ne ùì dico cuìà, nì nacani ini‑nè nùhù‑nè nàcòtò‑nè tnaha‑ne, divi nècuàchì xínduu (descendencia xi xìì‑né) Israel. ");
INSERT INTO mitNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Te yucán nì xini‑nè iin tè‑Egipto dandohó‑te iin tnaha‑ne. Ñàyùcàndùá, nì nacuidahan‑né nècuàchìmà nùù tèmà, te nì nachitacùhá‑nè sàhà tnaha‑nemà, nì sahnì‑né tèmà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Vàchi nì tuxi ini‑nè cuàhàn nsidaa tnaha‑ne cundaà ini‑nè ñà‑sàhà mii‑né icúmí Dios dacácu‑ya nsidanicuú‑né. Doco còó, cónì cácúndáà ini nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","’Daaní, inga quìvì‑mà tucu tu xicánúú‑né yucán, te nì xini‑nè itá ùì tnaha‑ne náâ stnahá. Ñàyùcàndùá, nì cuni‑nè nachindoviì‑né nècuàchìmà, te nì cachi‑nè xì nècuàchìmà: “Señores, ¿índù chuun caní stnahá‑nsiá? ¿Amádi iin‑ni ñaní xínduu‑nda?” ");
INSERT INTO mitNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dandu tiàa caní stnahama, nì chindaha níhní‑te Moisés, cachí‑te: “¿Ana nì cachi xì‑ní ñà‑dàndàcù‑ní nùù‑nsí? Còó, còò permisu nsidandaà‑ní chuun xi nsiùhù. ");
INSERT INTO mitNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A cuní‑nî cahnì stná‑ní yùhù nacua nì sahnì‑ní tè‑Egipto icu?” nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Dandu na ní inini Moisés ñà‑jaàn, nì xinudèhé‑nè cuàhàn‑nè ñuu Madián. Te yucán nì ndòo‑ne, te nì sàcùndoo stná ùì dèhe ii‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Daaní, nì yàha ùì dico cuìà iá‑nè yucán, dandu iin quìvì xicánúú‑né ìcà yucù nani Sinaí, te nì xini‑nè xíxìn iin yutnù tìì. Te mahì ñuhu mà nì natùi iin ángel. ");
INSERT INTO mitNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ñàyùcàndùá, nì ndulocó‑nè sàhà ñà‑ndùá nì xini‑nè. Te na ní cuyatni‑ne ña‑cuàhàn‑nè cundehè váha‑ne, dandu nì tiacu‑nè cáhàn Stoho‑ndà Dios xì‑né, cachí‑yà: ");
INSERT INTO mitNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yùhù nduí Dios. Cuisì yùhù nìsa cahvi xìì‑ní Abraham, xì Isaac xì Jacob”, nì cachi‑yà. Ñàyùcàndùá, nì quesaha Moisés quidí‑né, te yúhî‑nè cundehè gá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dandu nì cachi tu Stoho‑ndà Señor xì‑né: “Tavà‑ní ndìsàn‑ní, vàchi ñuhù ndé iin‑ní yohó, ñuhù íì nduá. ");
INSERT INTO mitNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Cunaha‑ní, sànì xinì nansa ndohó nèhivì‑xí ndoó ñuu Egipto. Sànì tiacuì xítnana‑ne, te ndoho‑guá‑nè. Ñàyùcàndùá, sànì nui yohó ñà‑vàxi nacuaqui‑nè caquee‑ne ñuu mà. Pues vichi cúhùn‑ndà, vàchi cuàhìn techuín mii‑ní nùhù‑ní ñuu Egipto”, nì cachi Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Ñàyùcàndùá, divi Moisés nduú ana nì techuún‑yá nùhù dandacu‑xi nùù tnaha‑nda, te dacácu‑ne nècuàchìmà, vàchi divi ducán nì ndacu nuù‑né nùù mii‑yá nì tùi mahì yutnù tìì mà, te indéhe‑yá nahi ángel. Pues divi‑ne nduú ana nì cahíchì ini tnaha‑nda daa na ní cachi‑nè: “¿Ana nì cachi xì‑ní dandacu‑ní nùù‑nsí? Còò permisu nsidandaà‑ní chuun xi‑nsi”. ");
INSERT INTO mitNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Doco divi Moisés mà nduú ana nì tavà xì nècuàchìmà ñuu Egipto yucán, te nì quida stná‑nè cuàhà milagru fuerte ñuu mà, cuàhà milagru ndiaha. Dandu nùù Mar Cuahá, yucán nì cuu ga más milagru fuerte. Te inii ùì dico cuìà nì cuu ga stná milagru nùù yucù dàná (ndé nì xìcanuu‑ne). ");
INSERT INTO mitNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","’Dandu después nì cachitnùhu Moisés inga palabra xì xìì‑ndà nècuàchì Israel mà, te dohó nì cachi‑nè: “Vàxi iin quìvì na icúmí Stoho‑ndà Dios cuàha‑ya iin tnaha‑nda chuun ndiaha càhàn cuenta xi‑ya ñuu‑ndà. Te nacua quidá yùhù, ducán icúmí quida stná ana icúmí quixi ma. Te icúmí‑nsiâ cahvi‑nsiá ñà‑ndùá cachi‑yà”, nì cachi Moisés. ");
INSERT INTO mitNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","’(Ináhá‑nsiâ), divi Moisés nduú ana nìsa ìa yucù dàná yucán, cutnáhâ‑né xì nèhivì cuáhà nduú xìì‑ndà mà, te cutnáhâ stná‑nè xì mii‑yá nì càhàn xì‑né yucù Sinaí mà, divi mii‑yá indéhe nahi ángel. Te (ináhá‑nsiá, divi nùù mii‑yá) nì nìhì stná‑nè palabra xi vida ndiaha icúmí‑ndá chivàha‑nda. ");
INSERT INTO mitNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Doco xìì‑ndà mà, còó, cónì cùní‑nè cunini‑ne Moisés. Nì cahíchì ini‑nè nècuàchìmà, vàchi cuisì cuní‑nè nùhù dahuun‑ne ñuu Egipto. ");
INSERT INTO mitNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Te nì cacachi stná‑nè xì Aarón: “Quidayucùn‑ní iin ñà‑cunduu stoho‑ndà cundaca‑nda codònùù núù‑ndà, vàchi sàcuàhàn Moisés, te cutu ní tavà úún‑nèndó ñuu Egipto, te vichi có‑cùndáà ini‑nsì ndíà nì cuu xi‑né”, nì cachi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Te divi quìvì yucán nì quidavàha‑ne iin chelù. Dandu nì sahnì stná‑nè quisì cunduu promesa nùù chelù mà, te cudíì gá ini‑nè, vàchi sànì quidavàha‑ne (iin ñà‑cahvi‑né). ");
INSERT INTO mitNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ñàyùcàndùá, nì naxicocuíìn ini Dios sàhà‑né, te nì nacoo uun‑yanè ñà‑quida‑ne ñà‑ndùú gustu xi‑ne cahvi‑né orá, xì yoo, xì sìtnúù. Ináhá‑ndá nì cuu ducán, vàchi dohó cachí‑yà nùù libru nì tiaa profeta sànaha ndé cachí‑yà: ¿Nsiohó nècuàchì Israel, ùì dico cuìà nì xìca‑ndá yucù, te nì sàha‑ndá yùhù ofrenda xi promesa, divi quisì nì sahnì‑ndá sàhí? Doco ¿a ndísá nì cahvi ndisa‑ndá yùhù na ní quida‑ndá ducán? ");
INSERT INTO mitNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Còó, mà ndìsá; yùù yócò (nduá nìsa cahvi‑ndá, vàchi divia) nìsa nihi‑ndá xicánúú, divi yùù yócò nani Moloc inácáá ini veha, xì stná stohò‑ndá nani Renfán náhà nahi sìtnúù cahnú. Vàchi figura‑ñà mà nì quidayucùn‑ndá, te nì cahvi‑ndá. Pues (divi sàhà nsidaámà) icúmî taxi xiqué nsiohó ndè nùù‑xí ñuu Babilonia, nì cachi Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","(Dandu nì cachi gà stná Esteban palabra yohó): ―Na ní sandoo xìì‑ndà mà yucù, nìsa icumi‑né iin vehe sìcoto ndé nìsa cahvi‑né Dios. Vàchi nì dàndàcú‑yá nùù Moisés ñà‑quidavàha‑ne vehe ìì mà, te ndudava xì ñà‑ndùá nì dàcùní‑yànè antes. Ñàyùcàndùá, nì cuyucun vehe ma. ");
INSERT INTO mitNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Daaní, después nì ndòa nùù dèhe xìì‑ndà mà. Te nècuàchìmà, nsidá‑néà nì quesaa‑nè xì Josué ladu nación yohó ndé nì sandoo nèhivì cuàhà inga raza. Doco nì cacuxio nèhivì mà nùù ñuu‑nè yohó, te nì nandua ñuu xìì‑ndà, vàchi nì chindee Dios xìì‑ndàmà ní taxi‑né nècuàchìmà. Ñàyùcàndùá, ñuu yohó nì ndòo vehe ìì mà inii tiempu dècuèndè tiempu xi David. ");
INSERT INTO mitNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Te David mà, nì xini mànì Dios‑nè. Ñàyùcàndùá, nì xìcàn tàhvì‑né nùù‑yá, áma cuáha‑ya lugar quidayucun‑nè iin veheñùhu cahnú xí‑yá, vàchi divi‑ya nduú ana cahvi nsidaa descendencia xi xìì‑né Jacob. ");
INSERT INTO mitNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Doco (màdì mii‑né, sino que dèhe‑ne) Salomón nduú ana nì nìhìtáhvì nì quidayucun xì veheñùhu cahnu‑ma. ");
INSERT INTO mitNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","’Doco cunaha‑nsiá, cahnú Dios icúmí‑ndá, màdì cuisì veheñùhu ñuhìví yohó iá‑yà. Còó, vàchi ducán nì cachi stná iin nècuàchì nì càhàn cuenta xi‑ya sànaha, nì tiaa‑ne palabra yohó ndé cachí‑yà: ");
INSERT INTO mitNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Na iin silla cahnú ndé iéˋ dandacuí, ducán nduú ansivi. Te nahi bancu tii ndé quetátú sàhí, ducán nduú ñuhìví. Ñàyùcàndùá, mà sáà nèhivì quidavàha‑ne iin vehe cahnú ndé coi, vàchi màdì iin xaan‑ni iéˋ quetátúì. ");
INSERT INTO mitNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Còó, yùhù nduí ana nì quida vàha xi ansivi xi ñuhìví; nsidaa ñá‑jaàn nì quidavàhi xì ndahìˊ, nì cachi Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","(Dandu nì cachi gà Esteban): ―Ndisa, ndee íní mii‑nsiá. Có‑nìhnú inì‑nsia Dios, vàchi nahi tè‑siùmí xínduu‑nsia, ñàyùcàndùá mà túha‑nsia cunini‑nsia. De por sí, xiní ùhì‑nsià Espíritu Ìì xí Dios; vàchi divi nacua nìsa quida xìì‑ndà sànaha, ducán quidá stná mii‑nsiá vichi. ");
INSERT INTO mitNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Vàchi nècuàchì yucán, quini ga nì quida‑ne xì nsidaa nècuàchì nìsa cahàn cuenta xi Dios, nì sahnì‑né nècuàchìmà, mate nduú nècuàchìmà ana nì cachitnùhu ñà‑ìcúmí quixi mii‑yá ana ndàà cuisì inì‑xi. (Daaní, na ní quesaa‑yà), divi mii‑nsiá nì cahin xì‑yá, te nì sahnì‑nsiáyà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","De por sí, có‑cùní dahuun‑nsia chivàha‑nsia ley xi Dios, mate ángel ndiaha nì sàha xi‑nda ley mà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","―Ducán nì cachi Esteban xì nèhivì yucán. Dandu nèhivì iníní má, yáha ga nì caxidà ini‑nè, nì saxìndiàá stnahá nùhu‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Doco Esteban, chitu anima‑nè Espíritu Ìì xí Dios. Dandu nì indehè‑né dìquì‑xí ansivi, te nì xini‑nè tnúù ndiaha ndé iá Yua‑nda Dios, te yucán iín Jesús ladu cuahá‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dandu nì cachi‑nè: ―Cundehè‑nsiá, nuná ansivi indéhí, te yucán ladu cuahá Yua‑nda Dios iín mii‑yá ana nduú Tnaha Ndiaha Nèhivì Ñuhìví. ");
INSERT INTO mitNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Doco nèhivì yucán, ndee cána dana‑ne, te sadí ndahà‑né tùtnù‑né, cuàhàn nsidaa‑né carrera ndé iá nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nì tavà‑ñàné ñuu mà ñà‑cahnì‑ñánê xì yùù. Te tiàa nì càhàn tnùhù sàhà‑né, nì tavà‑né dùhnù‑né, nì ndòa nùù iin tiàa chii nani Saulo. ");
INSERT INTO mitNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dandu nì quesaha‑né nì cani‑ne cuàhà yùù dìquì nècuàchìmà ñà‑cui‑nè. Doco mii‑né, nì ndacùcahan‑né Jesús, cachí‑nè: ―Stoho‑nsì Jesús, ¡sà‑ìá natnii‑ní anímè! ");
INSERT INTO mitNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dandu nì sàcuììn sìsì‑né, te nì ndàhì ndee‑né, cachí‑nè: ―Stoho‑nsì Señor, xícàn tàhví nùù‑ní ñà‑màsà quíhín cuenta‑ní sàhà cuàchi quidá nèhivì yohó xìˊ. Te na ní nsihi nì cachi‑nè ducán, dandu nì ndàhvà‑ne ñuhìví, na ian nì quìdì‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Te Saulo mà, cudíì stná ini‑nè ñà‑nì xìhì Esteban ducán. Daaní, divi quìvì yucán nì quesaha nì cucuahà gá sàhà nècuàchì nchícùn ichì Jesús. Nì quesaha nèhivì dava ga dandohó‑né nsidaa nèhivì xí‑yá ndoó ñuu Jerusalén. Ñàyùcàndùá, nì xinudèhé nècuàchìmà, cuàhàn‑nè inicutu ladu Judea xi ladu Samaria. Doco nècuàchì apóstol, còó, cónì xítià‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Daani, (nì nsihi nì sahnì nèhivì Esteban), dandu nì casaà dava nècuàchì nihnú vàha ini xì Dios, nì (nsiquihin‑ne ndómà), te nì sùxin‑nèndó. Te cuàhà gá nì casacu‑ne sàhà‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Doco Saulo, yáha ga nì quida quini‑ne xì nsidaa nècuàchì nchícùn ichì Jesús, vàchi vehe vehe nì xìcanuu‑ne, nì quìhvi‑ne nì tavà‑né nècuàchìmà, tiàa‑ne te ñahà‑né, te ñuhú‑né nècuàchìmà nì sàhàn nì chicadi vàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Doco nècuàchì nì xìtià mà, inicutu nì sàhàn‑nè nì dàcuítià‑nè razón ndiaha xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Iin nècuàchìmà nani Felipe, te divi‑ne nì sàhàn iin ñuu iá ladu Samaria. Te yucán nì càhàn‑nè sàhù sàhà Cristu. ");
INSERT INTO mitNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Te nì nataca cuàhà nèhivì ñuu mà, nì inini vàha nsidaa‑né ñà‑ndùá nì cachi Felipe, vàchi nì xini stná‑nè milagru nì quida nècuàchìmà, ");
INSERT INTO mitNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","vàchi nì dàndúvàha stná‑nè cuàhà nèhivì ñuhú ñà‑malu inì‑xi. Caná fuertéà nì caquea ini‑nè. Te nì nduvàha stná cuàhà nècuàchì nì dàñà íì cuerpu xi, xì cuàhà gá stná nècuàchì xicá cuéhê. ");
INSERT INTO mitNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ñàyùcàndùá, nì cudiì sàstnùhù ini nècuàchì ñuu mà. ");
INSERT INTO mitNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Doco yucán iá stná iin tiàa nani Simón. Sà‑ìá cuìà iá‑te ñuu mà. Tètàtnà tàdí nduú‑te, te dandahví uun‑tè nèhivì ladu yucán, vàchi cachí‑te xi‑né ñà‑chuun cahnú nduá nì nìhìtáhvì‑té. ");
INSERT INTO mitNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ñàyùcàndùá, nsidaa nèhivì ñuu mà, xiníndísâ‑né yuhù‑té, nècuàchì ndahví te nècuàchì cuìcà, nsidaa‑né tuxí ini‑nè ndudu ndiaha xí Dios icúmí‑tê. ");
INSERT INTO mitNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ñàyùcàndùá, cahvi váha‑nète, vàchi caní tiempu dandahví‑tené xì tàtnà xí‑te. ");
INSERT INTO mitNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Doco na ní sàà Felipe yucán, te nì dàtúi‑ne razón ndiaha sàhà ñuhìví ìì xí Dios xì sàhà ichì Jesucristu, dandu nì xinindisá cuàhà nècuàchìmà, te nì cuhiì stná‑nè, tiàa‑ne te ñahà‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Dècuèndè stná Simón mà, nì xinindisá stná‑te, te nì cuhiì stná‑te. Dandu iin‑ni nì tenchicùn stná‑te Felipe, ndulócô cuàhà‑té, vàchi nì xinì‑te cuú cuàhà milagru ndiaha, cuàhà milagru fuerte. ");
INSERT INTO mitNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Daaní, nècuàchì apóstol ndoó ñuu Jerusalén, nì xinitnùhu‑ne ñà‑ndùá nì cuu ladu Samaria yucán, ñà‑sànì xinindisá cuàhà stná nècuàchì ladu yucán ñà‑ndùú palabra ìì xí Dios. Ñàyùcàndùá, nì techuún‑né compañeru‑nè Pedro xì Juan ");
INSERT INTO mitNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ñà‑cùhùn‑nè ñuu mà, te càcàn tàhvì‑né nùù Dios sàhà‑ñá nandèe stná Espíritu Ìì xí‑yá ini anima nsidaa nècuàchì yucán. ");
INSERT INTO mitNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Vàchi tàñáha ga nìhìtáhvì nècuàchìmà Espíritu Ìì, cuisì‑ñá nì cuhiì‑né na ní xinindisá‑né Stoho‑ndà Jesús. ");
INSERT INTO mitNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ñàyùcàndùá, nì sàà Pedro xi Juan yucán, te nì chitàndòó‑né ndahà‑né dìnì nècuàchìmà, te nì nandèe Espíritu Ìì xí Dios ini anima‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Doco Simón ma, na ní xinì‑te nansa nì nìhìtáhvì nècuàchìmà Espíritu Ìì xí Dios ñà‑nì sàcuìtandoó ndahà apóstol dìnì‑né, dandu nì cahìn‑te dìhùn nùù nècuàchìmà, ");
INSERT INTO mitNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","cachí‑te: ―Cuàhatahvì stná‑nsià yùhù ndudu ìì mà, vàchi cuní stnáì chitàndòí ndahí dìnì nèhivì, te nìhì stná‑nè Espíritu Ìì xí Dios ―nì cachì‑te. ");
INSERT INTO mitNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Doco nì cachi Pedro xì‑té: ―Ni sáà‑ní ndañuhu dahuun‑ní xì dìhùn xí‑nî ñà‑tùxí inì‑ní vàtùni cuyàhvi tàhvì ndiaha‑nda nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Có‑ndùá ducán cucuu‑ní xì chuun yohó, vàchi anima chicuéhè icúmí‑nî nùù mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Te vichi xiñuhu cuu‑ní arrepentir sàhà cuàchi nì quida‑ní, te càcàn tàhvì‑ní nùù‑yá, áma cuícáhnû ini‑yà sàhà‑ní ñà‑nì nacani quini guá inì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Vàchi sànì cundaà inì, cuàhà gá cúmbìdia inì‑ní, te ñuhú ínì‑ní, vàchi sadí cuàchi‑ní nùù‑ní ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dandu nì cachi Simón mà: ―Càcàn tàhvì‑nsiá nùù Stoho‑ndà Señor sàhí ñà‑màsà cúú xî ni‑iñàha nacua nì cachi‑nsià jaàn. ");
INSERT INTO mitNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Daaní, Pedro xì Juan, chicá nì càhàn gà‑nè (xì nècuàchì ñuu mà) palabra ìì xí‑yá sàhà ichì ndiaha Stoho‑ndà Señor. Dandu mànuhù cuéyàà‑nè ñuu Jerusalén, nì yàha‑ne cuàhà ñuu cuati ndé ndoó nècuàchì samaritanu, te yucán nì càhàn stná‑nè xì nèhivì mà ñà‑ndùú razón ndiaha xí mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dandu nì quixi iin ángel xi Stoho‑ndà Señor, nì càhàn‑nè xì Felipe, cachí‑nè: ―Quihin‑ní ichì cuahán‑nî ladu sur ndè cachi sàà‑ní ichì cuàhàn ñuu Jerusalén xì ñuu Gaza; te ichì yucán, yucù nduá. ");
INSERT INTO mitNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ñàyùcàndùá, nì quihin nècuàchìmà ichì cuàhàn‑nè. Te cunaha‑ní, yucán yáha stná iin tiàa ñuu Etiopía. Iin nècuàchì eunuco nduú‑né, te chuun cahnú nihí‑né nùù Candace, divi ñahà dandacú nùù ñuu Etiopía yucán, vàchi ana ndiaá xì ñà‑cuìcà ñahà mà nduú‑né. Te vichi sàmànuhù‑né ñà‑nì sàhàn‑nè ñuu Jerusalén nì cahvi‑né Dios. Te xicá‑né carreta xi‑ne, cahví‑né tutu ìì nì tiaa profeta nani Isaías. ");
INSERT INTO mitNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dandu Espíritu Ìì xí Dios, nì càhàn‑yà xì Felipe, cachí‑yà: ―Cuahán ndé cuàhàn carreta yucán, cutnahu xi nècuàchìmà cùhùn. ");
INSERT INTO mitNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ñàyùcàndùá nì dàyáà Felipe nì sànìhì‑né carreta mà, te nì tiacu‑nè cahví nècuàchìmà tutu nì tiaa Isaías. Ñàyùcàndùá, nì xìcàn tnùhù‑né nùù nècuàchìmà: ―¿A sánìhì inì‑ní ñà‑ndùá cahvi‑ní, á coó? ");
INSERT INTO mitNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Dandu nì cachi nècuàchìmà: ―Còó, mà cúí, vàchi còò iin cachi xìˊ nansa cuní cachà sàhà‑ñá ducán mànìhì inì. Dandu nì sàcùndàhví nècuàchìmà nùù Felipe ñà‑nì nàná stná‑nè nùù carreta, te cutnahá‑né cundoo‑ne mà. ");
INSERT INTO mitNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Te tutu ìì cahví nècuàchìmà, dohó cachí meru ndé cahví‑né: Na ian ndaca‑nda iin riì cuàhàn‑si ndé cuì‑si, ducán nì saca stná‑te ndómà cuàhàn ndé cui‑ndà, te divi na ian cuhíhín iin riì tìì na dátê‑si, ducán nì quida stná ndómà, cónì cáhàn‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Doco nèhivì, nì cahíchì ini‑nèndó. Ndahví nì quida‑ne, nì dàtnátuu‑nèndó nùù juez, te nì dàcuìdá cuàchi uun‑nèndó, mate còò cuàchi‑nda, dandu nì sahnì‑néndô. Te vichi mà cóó gá ni‑iin descendencia xi‑nda cahan néhivì, (cachí tutu mà). ");
INSERT INTO mitNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dandu nì cachi nècuàchìmà xì Felipe: ―Quida sacù‑ní favor, cachì‑ní xìˊ; ¿índù nèhivì cáhàn tutu yohó sàhà‑xí? Isaías ni tiaa xán, doco ¿a divi mii‑né cáhàn sàhà‑xì, te ò sáhà inga‑nè? ");
INSERT INTO mitNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dandu nì quesaha Felipe nì nacani‑ne ñà‑ndùá cuní cachi palabra meru ndé cahví nècuàchìmà, te nì cachitnùhu nsihi‑ne nansa iá ichì Jesús. ");
INSERT INTO mitNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Daaní, nì casaà‑nè iin xaan ndé ñuhú tècuìí. Te nì cachi tiàa ma: ―Cundehè‑ní, yucán ñuhú tècuìí. ¿A iá ñà‑cùmánì quide? vàchi cuníˋ cuhiì stnáì vichi. ");
INSERT INTO mitNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Dandu nì cachi Felipe: ―Nú ndisa, iin‑ni nihnú vàha inì‑ní, vàtùni. Dandu cachí nècuàchìmà: ―Yùhù xiníndísê Dèhemanì Dios nduú Jesús. ");
INSERT INTO mitNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ñàyùcàndùá, nì dàndàcú nècuàchìmà ñà‑cucuiin carreta xi‑ne, te ndúì‑nè nì nuu‑ne cuàhàn‑nè ndé ñuhú tècuìí mà. Te nì quida iì Felipe nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Dandu nì caquee‑ne nùù tècuìí mà mànana‑ne. Te na iin cachí nì ndiachi Felipe nì quida Espíritu Ìì xí Stoho‑ndà Señor cuàhàn‑nè, nì ndañuhu‑né nùù vista xi inga nècuàchìmà. Ñàyùcàndùá nì quihin tu nècuàchìmà ichì mànuhù‑né, cudíì gá stná ini‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Daaní, Felipe, ndè ñuu Azoto nì natùi‑ne, te ñuu ñuu nì yàha‑ne, dacuítià‑nè razón ndiaha xí Dios dècuèndè nì sàà‑nè ñuu Cesarea. ");
INSERT INTO mitNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Daaní, Saulo, iin‑ni xídà sàstnùhù ini‑nè sàhà nècuàchì nchícùn ichì Stoho‑ndà Señor. Dana cáhàn‑nè, cuàhàn‑nè cahnì nsìhí‑né nècuàchìmà, cachí‑nè. Ñàyùcàndùá nì sàhàn‑nè nùù dùtù cusáhnû, ");
INSERT INTO mitNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nì xìcàn‑nè tutu cunihi‑ne cùhùn ñuu Damasco (cahvi nècuàchì dandacú) nùù veheñùhu xi nèhivì raza‑nè yucan sàhà‑ñá ducán nìhì‑né permisu nanducu‑né nèhivì nchícùn ichì Jesús, te màcùnuhni nècuàchìmà quixi‑ne presu ñuu Jerusalén, tiàa o ñáha ni cúndúú‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ñàyùcàndùá, nì quihin Saulo ichì cuàhàn‑nè ñuu Damasco mà. Te sà‑ìtúú‑né sàà‑nè ñuu mà, dandu na iin cachí ndè dìquì‑xí ansivi nì tnùù fuerte iin luz. ");
INSERT INTO mitNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Te nì sàcasàn‑né ñuhù nì quidamà, te nì tiacu‑nè cáhàn iin ana cáhàn cachí xì‑né: ―¡Saulo, Saulo! ¿Índù chuun nchícùn‑ní yùhù quida quini‑ní xìˊ? ");
INSERT INTO mitNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Dandu nì cachi Saulo: ―¿Ana nduu‑ní, Señor mío? Te nì cachi tu‑ya: ―Yùhù nduí Jesús, divi ana dandoho‑ní. Doco mii‑ní quidá quíní‑nî xì mii‑ní, na ian quidá quisì caní sàhà nùù garrocha ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Dandu Saulo, ndé quidí cuisì‑né ñà‑yúhî guâ‑nè, te nì cachi‑nè: ―¿Ndíà nduá cuní‑nî quide, Señor mío? Dandu cachí tu Stoho‑ndà Señor xì‑né: ―Ndacuiìn‑ní, cuahán‑nî ñuu Damasco, te yucán ndacu nuù‑ní nansa quida‑ní ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Doco tiàa xícutnaha‑xi‑né cuàhàn ichì mà, nì yùhí cuaá‑te, vàchi nì inini‑tè iá ana nì càhàn, doco còò iin tuí. ");
INSERT INTO mitNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Dandu nì ndacuiin Saulo, te nì nacuna‑ne nduchìnúù‑né, doco mànìcùí gá cundehè‑né, (vàchi sànì cuaà nduchìnúù‑né). Ñàyùcàndùá ídìtá ndahà tnahá‑né nì sàà‑nè ñuu Damasco. ");
INSERT INTO mitNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Te yucán nì ìa‑ne ùnì quìvì, có‑tùínúù‑né, có‑xìxí‑né, ni có‑xìhí stná‑nè tècuìí. ");
INSERT INTO mitNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Te ñuu mà iá stná iin nècuàchì nchícùn xì Stoho‑ndà Jesús nani Ananías. Te nì dàcùní Jesús‑nè mii‑yá, cachí‑yà xì‑né: ―¡Ananías! Te nì naxiconihí‑né nùù‑yá, cachí‑nè: ―Yohó iéˋ, Señor mío. ");
INSERT INTO mitNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dandu nì cachi Stoho‑ndà Señor xì‑né: ―Quihin‑ní ichì cuahán‑nî calle nani Calle Ndàà, te yucán nanducu‑ní iin tiàa nani Saulo. Iin nècuàchì ñuu Tarso nduú‑né, te iá‑nè vehe iin nèhivì nani Judas. Te vichi iá‑nè xícàn tàhvì‑né nùí. ");
INSERT INTO mitNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Te quìvì vitni nì xini‑nè iin seña na ian sánî‑nè, te nì xini‑nè mii‑ní nì quìhvi‑ní ndé iá‑nè, te nì chitàndòò‑ní ndahà‑ní dìnì‑né, te nì nìhì‑né nì natùinuù‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Doco nì cachi Ananías mà: ―Señor mío, cuàhà nèhivì sànì cachi‑nè xìˊ nansa quidá nècuàchìmà, ñà‑cuàhà guá sànì dàndòhó‑né nèhivì xí‑nî ndoó ñuu Jerusalén. ");
INSERT INTO mitNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Te vichi yohó sànì quesaa stná‑nè nihí‑né orden nùù dùtù xícusahnú ñà‑tnii‑ne nsidaa ana ndácùcahan xi quìvì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Doco nì cachi Stoho‑ndà Señor xì‑né: ―Cuahán‑nî, vàchi sànì nacàxin nècuàchìmà sàhà ñà‑quida stná‑nè chuun xi, cùhùn‑nè càhàn‑nè sàhù sàhí nùù nèhivì ndoó cuàhà inga ñuu, xì nùù stná tè‑xídandacú yucán, xì nùù stná nècuàchì Israel. ");
INSERT INTO mitNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Te icúmî cachitnùhu stnáì xì‑né ñà‑cuàhà guá icúmí‑nê ndoho‑ne sàhí ―nì cachi Jesús. ");
INSERT INTO mitNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ñàyùcàndùá, nì quee Ananías mà cuàhàn‑nè vehe yucán, te nì yàha‑ne ndé iá Saulo, nì chitàndòó‑né ndahà‑né dìnì nècuàchìmà, cachí‑nè: ―Ñánì Saulo, ichì vàxi‑ní nì xinì‑ní Stoho‑ndà Jesús. Pues divi‑ya nì techuun‑xí vàxi ndé iá‑nî ñà‑natùinuù‑ní, te chitu stná anima‑ní Espíritu Ìì xí‑yá― nì cachi Ananías. ");
INSERT INTO mitNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Daaní, vichi duha nì còyo ñà‑sàdí nihni nduchìnúù Saulo, nahi chìdìdà dìi nì sandua, te nì natùi dahuun nduchìnúù‑né. Dandu nì ndacuiin‑nè, te nì cuhiì‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Te na ní nacuxi‑ne, dandu nì ndundee ini‑nè. Te divi ñuu Damasco mà nì ndòo‑ne itnii gá quìvì, nìsa ìa‑ne xì nèhivì xí Jesús ndoó yucán. ");
INSERT INTO mitNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Daaní, vichi duha nì sàhàn‑nè iin iin veheñùhu xi nècuàchì raza‑nè Judea, nì càhàn‑nè sàhù sàhà Jesús ñà‑divi Dèhemanì Dios nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ñàyùcàndùá, cuàhà gá nì ndulocó nsidaa ana iníní nì càhàn‑nè, te nì ndàcàtnùhù tnahá‑né nùù‑nè, cachí‑nè: ―¿Amádi nècuàchì yohó nduú tiàa nìsa ìa ñuu Jerusalén nìsa dandáñúhú guâ xì nèhivì ndácùcahan xi quìvì Jesús? Te ¿acónì quésáá stná‑nè ñuu‑ndà yohó ñà‑tnii‑ne nècuàchìmà, te cundaca‑ñané presu nùhù ñuu Jerusalén ñà‑cundoo‑ne ndahà dùtù xícusahnú? ―Ducán nì cachi nèhivì mà. ");
INSERT INTO mitNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Doco Saulo, chicá ndee ní càhàn‑nè xì nècuàchì raza‑nè Judea ñuu Damasco mà, te nècuàchìmà, cónì náníhì tnùní gà ini‑nè nansa naxiconihí‑né, vàchi claru nì dàtúi Saulo sàhà Jesús, ñà‑divi rey ndiaha xí raza‑nè nduú‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Daaní, nì yàha caní quìvì, dandu nì nataca dava tè‑raza Judea mà, te iin‑ni nì candatnuhu‑té ñà‑cahnì‑té Saulo. Ñàyùcàndùá, ndui te ñuú ndiatú‑te yehè nahnú ñuu mà, áma níhì‑té cahnì‑ténê. Doco nì xinitnùhu‑ne nansa cuní tèmà quida‑tè xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ñàyùcàndùá, ñuú nì saca nèhivì xí Jesús‑nè, cuàhàn‑nè dìquì nama ndiadí nùù ñuu mà, te yucán nì dànùú‑ñánê yàtà nama mà, inácáá‑nè ini iin ìcà sìcàté. ");
INSERT INTO mitNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Dandu mànuhù‑né ñuu Jerusalén. Ñuu yucán nì cuni‑nè nacuatnahá‑né xì dava ga nèhivì xí Jesús, doco nsidaa nècuàchìmà, nì yùhí‑nè, vàchi có‑xìníndísâ‑né ñà‑ndáà ndùá nchícùn ndisa Saulo ichì mii‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ñàyùcàndùá, nì saca Bernabé nècuàchìmà, te ndacá tnahá‑né nì sàà nùù nècuàchì apóstol, nì nacani‑ne xì nècuàchìmà nansa nì cuu na ní xini Saulo Stoho‑ndà Señor, te nì càhàn‑yà xì‑né. Te nì nacani stná‑nè nansa nì quida Saulo ñuu Damasco, nì càhàn vate cuáhà‑né sàhà Jesús ñuu yucán. ");
INSERT INTO mitNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ñàyùcàndùá, yucán nì ndòo Saulo ñuu Jerusalén, xicánúú‑né xì nèhivì xí Jesús. ");
INSERT INTO mitNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Te cuàhà gá nì càhàn‑nè sàhà‑yá, cónì yúhî‑nè. Dècuèndè stná nècuàchì raza‑nè cáhàn dàhàn griegu nì càhàn stná xì‑né, cuàhà gá nì ndatnuhu‑né xì nècuàchìmà. Doco nècuàchìmà, cuisì xícuni‑nè cahnì‑ñánê. ");
INSERT INTO mitNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Doco dava nèhivì cahvi stná xì Jesús, nì xinitnùhu‑ne sàhà peligru mà. Ñàyùcàndùá, nì saca‑ne Saulo mà cuàhàn‑nè ndè ñuu Cesarea, dandu mànuhù nècuàchìmà ñuu Tarso. ");
INSERT INTO mitNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Daaní, inicutu ladu Judea mà, xì ladu Samaria, xì stná ladu Galilea, nì ndudadí uun; vàtùni nataca cuéyàà nèhivì xí Jesús. Ñàyùcàndùá nì nacuàhandee gá ini‑nè, te chicá nì cahvi víi‑né Stoho‑ndà Señor, vàchi nì chindee stná Espíritu Ìì xí‑yá mii‑né, te sàhámà chicá nì nducuahà‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Daaní, xicánúú Pedro visita inicutu ladu yucán, te nì sàà‑nè iin ñuu tii nani Lida ñà‑coo‑ne visita xì nèhivì xí Jesús ndoó yucán. ");
INSERT INTO mitNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Te ñuu mà nì xini‑nè iá iin tiàa nani Eneas; ùnà cuìà indúhu‑né cama, vàchi sànì dàñà íì cuerpu xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ñàyùcàndùá, nì cachi Pedro xì‑né: ―Cunaha‑ní, Eneas: momentu yohó cuàhàn Jesucristu dandúvàha‑ya mii‑ní. Ñàyùcàndùá ndacuiìn‑ní, nsida viì‑ní cama xi‑ní. Dandu momentu mà nì ndacuiin‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Te (nì xìcanuu‑ne) ñuu Lida mà, xì stná yodò nani Sarón, te nì xini nèhivì‑né. Ñàyùcàndùá cuàhà nècuàchìmà nì tenchicùn stná‑nè ichì Stoho‑ndà Señor. ");
INSERT INTO mitNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Daaní, tiempu yucán nìsa ìa iin nèhivì xí Jesús ñuu Jope nani Tabita. Te Dorcas nduú quìvì‑né dàhàn griegu. Te cuàhà gá obra nìsa quida‑ne; cuàhà gá nìsa chindee‑né nècuàchì ndahví. ");
INSERT INTO mitNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Doco quìvì yucán nì quicuehè‑nè, te nì xìhì‑nè. Ñàyùcàndùá, nì dàcùchí nèhivì nsìi ma tècuìí, te nì chinduhù‑néndô iin cuartu dìquì‑xí pisu ùì. ");
INSERT INTO mitNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Dandu nèhivì xí Jesús (ndoó ñuu mà), nì xinitnùhu‑ne ñà‑yatni uun iá Pedro ñuu Lida. Ñàyùcàndùá, nì techuún‑né ùì tiàa nì sàhàn nì sacundahví xì nùù nècuàchìmà ñà‑quixi‑ne vichi duha. ");
INSERT INTO mitNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ñàyùcàndùá, nì quihin Pedro ichì vàxi‑ne cutnáhâ‑né xì tiàa ma, te nì caquesaa‑nè vehe nsìi ma. Dandu nì saca nèhivì mà‑né nì nana‑ne ndè vehe dìquì‑xí. Te yucán nì tnàtuu nsidaa nècuàchì ñahà cuàán, itá‑né sacú‑né, dacuní‑nè Pedro vestidu‑nè xì dùhnù‑né, vàchi na nísa itiacu nsì‑Dorcas mà, nì sansìcu‑nda sìcoto xi nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Dandu nì cachi Pedro xì nsidaa nèhivì mà ñà‑nì cáquéé‑né fuera. Te na sánì caquee‑ne, dandu nì sàcuììn sìsì Pedro, nì xìcàn tàhvì‑né nùù Dios. Te nì nacuico‑né, nì indehè‑né ndé indúhu nsìi ma, te nì cachi‑nè xì ndómà: ―Ndacuiìn‑ní, Tabita. Dandu nì nacuna nècuàchìmà nduchìnúù‑né, te na ní xini‑nè Pedro, nì ndacòo‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Te nì chitanini Pedro ndahà‑né nì ndacani‑ne nècuàchìmà. Daaní, nì cana‑ne nsidaa nècuàchì dava ga ñà‑nansìhvi‑ne, divi ñahàcuàán mà, xi dava ga stná nèhivì xí Jesús. Te nì cachi‑nè xì nècuàchìmà: ―Yohó iá Tabita xi‑nsia; sànì natiacu‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ñàyùcàndùá, nì xìtià cuentu mà inicutu ñuu Jope nansa nì cuu xi nsìi ma, te cuàhà gá nèhivì nì xinindisa‑xi Stoho‑ndà Señor. ");
INSERT INTO mitNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Dandu después, caní quìvì nì ndòo ga Pedro ñuu mà, iá‑nè vehe iin tiàa nani Simón, iin nècuàchì tùha dacáhì iìn. ");
INSERT INTO mitNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ñuu Cesarea nì sandoo cuàhà soldadu. “Tè‑italianu” nìsa cachi nèhivì ñuu mà xì soldadu ndoó yucán. Te iin capitán xi soldadu mà nani Cornelio. ");
INSERT INTO mitNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mii‑ne xì nsidaa stná nèhivì ndoó vehe‑ne, xínduu‑ne nèhivì tnùñuhu cahvi ndisa xi Dios, te chívàha ndisa‑ne tnùñuhu xí‑yá. Te dasán stná‑nè cuàhà dìhùn ñà‑chindee xi nècuàchì ndahví, te nacuátú cuáhà stná‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Te nì cuu iin quìvì nahi càhúnì nì cuaà nì dàcùní Dios‑nè tuí ndáí vàxi iin ángel quíhvi‑ne vehe ndé iá‑nèmà, te nì cachi ángel mà xì‑né: ―¡Cornelio! ");
INSERT INTO mitNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Dandu nì indehè váha‑ne ángel ma, te yúhî cuàhà‑né; dandu nì cachi‑nè: ―¿Ndíà iá, señor? Te nì cachi ángel mà xì‑né: ―Sànì inini Dios ñà‑ndùá xícàn tàhvì‑ní nùù‑yá, te sànì natùi stná obra xi‑ní nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ñàyùcàndùá, vichi duha techuun‑ní nèhivì cùhùn ñuu Jope, te cana‑ní iin tiàa nani Simón Pedro quixi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Cunaha‑ní, iá‑nè vehe iin nècuàchì dacáhì xì iìn quisì, te yuhù mar indúhu vehe nècuàchìmà. Pues divi Pedro mà icúmí cachi xì‑ní nansa ndíà ìcà‑ní quida‑ní ―nì cachi ángel mà, ");
INSERT INTO mitNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","te cuàhàn‑nè. Daaní, luegu nì cana Cornelio ùì mozo xi‑ne tnàtuu‑ne, te nì cana stná‑nè iin soldadu xinúcuáchí nûù‑né, vàchi iin nècuàchì cahvi víi xi Dios nduú stná nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Dandu nì nacani nsihi‑ne xì nècuàchìmà nansa nì cuu, te nì techuún‑ñané cùhùn‑nè ñuu Jope. ");
INSERT INTO mitNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Daaní, nahi càxíhúì inga quìvì na sá‑ìtúú‑né casaà‑nè ñuu mà, dandu divi hora mà nì nana Pedro dìnìvèhé ndé iá‑nè, cuàhàn‑nè càcàn tàhvì‑né nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dandu nì quesaha‑né nì xìhì cuàhà‑né doco, te cuní‑nè cuxi‑ne. Ñàyùcàndùá, cuàhàn cuyucun ñà‑cudamá‑nè. Doco na táñâha ga coo listúàmà, dandu nì dàcùní Dios‑nè iin seña na ian sánî‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nì xini‑nè nì nuna ansivi, te yucán iá iin sìcoto na iin dahmà cácùhun nsì‑cúmì punta‑ñà dìquì‑xí, mànua dècuèndè ndé iá‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Te nì xini‑nè ini dahmà mà ñuhú nsidanuu clase quisì; quisì nahnú, quisì cuàtì, xì quisì nduú laa. ");
INSERT INTO mitNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dandu nì tiacu‑nè cáhàn iin ana cáhàn xì‑né, cachí‑yà: ―Ndacuiìn‑ní cahnì‑ní quisì jaàn caxì‑ní, Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Doco nì cachi Pedro: ―Còó, Señor mío, mà túhe caxí ñà‑quini. Mà túhe caxí ñà‑có‑ndìá ìqué caxí. ");
INSERT INTO mitNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dandu cachí tu ana cáhàn xì‑némà: ―Màsà cáchì‑ní quini iá‑si, vàchi Dios nduú yùhù, te sànì cachì, iá viì quisì jaàn ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ùnì xichi nì càhàn‑yà ducán, dandu nì nana dahmà mà ansivi mànuhá. ");
INSERT INTO mitNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ñàyùcàndùá, cuàhà gá nì nacani ini Pedro; ¿ndíà nduá cuní cachàmà? cahan‑né. Te divi hora daa sànì caquesaa tiàa nì techuún Cornelio, itá‑né yehè, vàchi sànì ndàcàtnùhù‑né nùù nècuàchì ñuu mà ndévì iá vehe Simón mà. ");
INSERT INTO mitNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ñàyùcàndùá, meru cáhàn‑nè yehè, xícàn tnùhù‑né a divi vehe ma iá Simón Pedro, á coó. ");
INSERT INTO mitNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Daaní, Pedro, iá‑nè nacání vá ini‑nè (ndíà cuní cachi) ñà‑ndùá nì dàcùní Dios‑nè, te nì cachi Espíritu Ìì xì‑né: ―Cunaha‑ní, sànì quesaa ùnì tiàa cuní càhàn xì‑ní. ");
INSERT INTO mitNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ndacuiìn‑ní, nuu‑ní, te cuahán‑nî xì‑né. Màsà nácání inì‑ní, vàchi yùhù nduú ana nì cana xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ñàyùcàndùá, nì nuu Pedro dècuèndè ndé itá tiàa vàxi nùù Cornelio mà, te nì cachi‑nè xì nècuàchìmà: ―Amádi yùhù cuní‑nsià càhàn xì‑nsiá. ¿Índù iin chuun nihí‑nsiá vàxi? ");
INSERT INTO mitNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Dandu nì cacachi nècuàchìmà: ―Nùù capitán Cornelio vàxi‑nsi. Nècuàchì ndàà cuisì inì‑xi nduú nècuàchìmà. Chívàha viì‑né tnùñuhu xí Dios, te cuú ini nsidaa nècuàchì raza‑ní Judea sàhà‑né. Te iin ángel ìì xí Dios nì cachi xì‑né ñà‑nì càná‑né mii‑ní cùhùn‑ní vehe‑ne càhàn‑ní xì‑né cunini‑ne ―nì cacachi tiàa ma. ");
INSERT INTO mitNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dandu nì dàyáha Pedro tiàa ma ini vehe‑ne, te yucán nì caquidì nècuàchìmà iin ñuú. Dandu inga quìvì nì naquihin‑ne ichì ndacá tnáhâ‑né xì Pedro mànuhù. Te iin ùì nècuàchì ñuu Jope cahvi stná xì Dios, cutnáhâ stná‑nè xì Pedro cuàhàn. ");
INSERT INTO mitNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Dandu quìvì ùì nì casaà‑nè ñuu Cesarea. Te yucán ndiatú Cornelio vehe‑ne, mii‑né xì tnaha‑ne, xì nsidaa stná nècuàchì chicá cutnáhâ vàha xi‑né, vàchi sànì cana‑ne nècuàchìmà ñà‑quixi‑ne vehe‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Dandu nì sàà Pedro meru vehe ma, te nì quee Cornelio, nì casàhú‑nè xì nècuàchìmà, nì sàcuììn sìsì‑né nì cahvi‑né nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Doco Pedro, nì ndacani‑ne nècuàchìmà, cachí‑nè: ―Ndacuiìn‑ní, vàchi na tiàa nduú mii‑ní, ducán tiàa nduú yùhù. ");
INSERT INTO mitNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Dandu nì quesaha‑né ndatnúhú‑nê xì nècuàchìmà, te ducán nì cayàha‑ne ini vehe, te nì xini Pedro cuàhà gá nèhivì sànì nataca ndòò‑mà. ");
INSERT INTO mitNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Dandu nì cachi‑nè xì nsidaa nècuàchìmà: ―Mii‑nsiá, sà‑ìnáhá‑nsiâ nansa iá ley xi nsiùhù tè‑ndùú raza Judea, ñà‑có‑sâha ley xi‑nsi nacuatnahá‑nsí xì nèhivì inga ñuu (nahi mii‑nsiá). Ni còò stná permisu yàha‑nsi vehe‑ne. Doco vichi sànì sàì nì cundaà inì nì quida Dios ñà‑mà váha cachi‑ndà xì nèhivì inga ñuu ñà‑có‑xìñùhù Dios‑nè, te ò nècuàchì sìquini nduú‑né. Còó. ");
INSERT INTO mitNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ñàyùcàndùá, na ní cana‑nsia yùhù quixi, cónì càchíˋ á coó. Vichi duha nì quihin ichì váxi. Ñàyùcàndùá, cuníˋ cundaà inì ndíà ndùá dìsáhà‑xí nì cana‑nsia yùhù. ");
INSERT INTO mitNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dandu nì cachi Cornelio: ―Cunaha‑ní, sàcuàhàn‑ndà cùmì quìvì, divi hora yohó nahi càhúnì nì cuaà nì sandua. Te iníhíìˊ iá dòquí, te xícàn tàhví nùù Dios. Dandu yucán nì ndecunu iin tiàa nì xinì, ndiaha gá nchií sìcoto xi‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Te nì cachi‑nè xìˊ: “Cornelio, sànì tiacu Dios xícàn tàhvì‑ní nùù‑yá, te sànì natùi stná obra xi‑ní nùù‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ñàyùcàndùá, techuun‑ní nèhivì cùhùn ñuu Jope, te cana‑ní iin tiàa nani Simón Pedro; iá‑nè vehe inga Simón, iin nècuàchì dacáhì xì iìn. Yuhù mar nduú vehe‑ne. Te nú sànì quesaa‑nè yohó, dandu icúmí‑nê càhàn‑nè xì‑ní”. ");
INSERT INTO mitNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ñàyùcàndùá, vichi vichi nì dàsáì razón ñà‑quixi‑ní. Te vàtùni nì quida‑ní nì quesaà‑ní. Te vichi, yohó ndoó nsidaa‑nsí nùù Dios ndiatú‑nsí cunini‑nsi nsidaa ñà‑ndùá sànì cachi Dios xì‑ní ―nì cachi Cornelio. ");
INSERT INTO mitNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dandu nì càhàn Pedro xì nsidaa nècuàchìmà, cachí‑nè: ―Vichi sànì cundaà inì, ñà‑ndáà nduá, có‑càhíchì ini Dios ni‑iin nèhivì. ");
INSERT INTO mitNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Vàchi có‑quìdá mà, nú cuisì cahvi víi iin nèhivì mii‑yá, te quidá víi‑né, dandu icúmí‑nê ndee vàha‑ne nùù‑yá, mate nèhivì ndéni ñuu nì cui ni cúndúú‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","37","Te mii‑nsiá, sà‑ìnáhá‑nsiâ ñà‑ndùá nì cachitnùhu Dios xì raza‑nsì Israel, nì dàquésáá‑yà iin razón ndiaha nansa nàcùndoo vàha‑nda nùù‑yá quida Jesucristu. Te Jesucristu, Stoho nsidanicuú nèhivì ñuhìví nduú‑yá. Pues ináhá vâha‑nsia ñà‑ndùá nì cuu, ñà‑dihna Juan nì quixi nì càhàn xì nèhivì, te nì quida iì stná‑nè nècuàchìmà. Daaní, ndè ñuu Galilea nì quesaha chuun xi Jesús de Nazaret, te dècuèndè inicutu ladu Judea nì xìtià stná palabra sàhà chuun ma. ");
INSERT INTO mitNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Te ináhá stnâ‑nsià nansa nì quida‑ya, nì nìhì fuerte‑yà Espíritu Ìì xí Dios. Ñàyùcàndùá, nì xìcanuu‑ya nì quida‑ya milagru ndiaha, nì dàndúvàha‑ya nsidaa ana ndohó quidá ñà‑malu, vàchi Yuamánì‑yá Dios iá xì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Te nsiùhù, testigu xínduu‑nsi, vàchi nì xininùù‑nsí nsidaa ñà‑ndùá nì quida‑ya ladu Judea xì stná ñuu Jerusalén. Dandu nì sahnì nèhivì‑yá. Nchìca cruz nì chituu‑neyà. ");
INSERT INTO mitNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Doco tìxi ùnì quìvì nì natiacu‑yà nì quida Yua‑yá Dios. Dandu cuàhà xichi nì ndecunu‑ya nùù nèhivì, doco màdì núù nsidaa‑né. Còó, cuisì nùù nsiùhù nècuàchì nì chitnùní ini Dios ndecunu‑ya nùù‑xí, vàchi divi nsiùhù nì nacàxin‑ya cunduu ana cuninùù xì‑yá na ní natiacu‑yà, dècuèndè nì cutnahá stná‑yà xì‑nsí nì xixi‑nsi (nùù mesa). ");
INSERT INTO mitNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dandu nì sàcùnaha‑nsí nùù‑yá ñà‑dacuítià‑nsì palabra sàhà‑yá nùù nèhivì, cachi‑nsì xì‑né ñà‑divi mii‑yá nì chitnùní ini Dios nsidandaà sàhà cuàchi nsidanicuú nèhivì, nèhivì itiácú, xì nèhivì sànì xìhì. ");
INSERT INTO mitNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Te cunaha‑nsiá, divi sàhà mii‑yá nì cachitnùhu stná nsidaa nècuàchì nìsa cahàn cuenta xi Dios sànaha, nì cachi‑nè ñà‑sàhà mii‑yá vàtùni ndoo cuàchi nsidaa ana cunindisa‑xi‑yá, te ndacùcahan xi quìvì‑yá ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Daaní, meru cáhàn Pedro, dandu fuerte nì quixi Espíritu Ìì xí Dios ini anima nsidaa nècuàchì (inga raza) iníní má. ");
INSERT INTO mitNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Te nì quesaha ní càhàn‑nè dàhàn sàà, ndeníhí vàha‑ne Dios. Ñàyùcàndùá nì ndulocó nècuàchì raza Judea nì quixi xi Pedro, vàchi nì xini‑nè dècuèndè stná nècuàchì inga raza sànì nìhìtáhvì Espíritu Ìì xí Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ñàyùcàndùá nì cachi Pedro xì nècuàchì raza‑nè xiníndísá‑má: ―Sànì xini‑nsià nansa nì nìhìtáhvì stná nècuàchì yohó cucumi‑né Espíritu Ìì xí Dios nahi nsiùhù. Ádi còò iin cuní cadi xì nùù‑né ñà‑cuhiì‑né vichi. ");
INSERT INTO mitNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Dandu nì cachi Pedro xì compañeru‑nèmà ñà‑nì ndácùcahan‑né quìvì Jesucristu, te quida iì‑né nècuàchì sàà mà. Ñàyùcàndùá, na ní nsihi nì cuhiì nsidaa nècuàchìmà, dandu nì sacundahví‑nè nùù Pedro ñà‑nì còó chii gá‑nè iin ùì gà quìvì xì‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Daaní, nì xìtià cuentu nansa nì cuu nì xinindisá stná nècuàchì inga raza mà. Dècuèndè stná ladu Judea nì sàà razón mà, te ñàyùcàndùá nì xinitnùhu stná nècuàchì apóstol xì dava ga nècuàchì xiníndísâ. ");
INSERT INTO mitNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Sàhájàn na ní nasaa tu Pedro ñuu Jerusalén, dandu nì tnàtuu cuàhà nècuàchì raza‑nè nùù‑né, te nì quesaha‑né xítnùhu‑ñané, ");
INSERT INTO mitNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","cachí‑nè: ―¿Índù chuun nì quìhitnaha‑ní xì nècuàchì có‑nchîcùn ley xi‑nda, te nì yàha‑ní vehe‑ne nì xixi‑nsia? ");
INSERT INTO mitNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dandu nì nacani nsihi Pedro xì nècuàchìmà nansa nì cuu, te dohó nì cachi‑nè: ");
INSERT INTO mitNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Ñuu Jope iéˋ xícàn tàhví nùù Dios, te nì dàcùní‑yà yùhù iñàha. Nì xinì iin ñà‑ndùú nahi dahmà cahnú cácùhun nsì‑cúmì punta‑ñà dìquì‑xí, te ndè ansivi nì nua vàxan ndé iéˋ. ");
INSERT INTO mitNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Indéhe váhi, te nacání inì, ¿ndíà nduá ñuhuma? Te yucán ñuhú nsidanuu clase quisì: quisì nahnú, quisì yùcù, quisì cuàtì, xì stná laa. ");
INSERT INTO mitNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dandu nì tiacuì cáhàn iin ana cáhàn, cachí‑yà xìˊ: “Ndacuiìn‑ní cahnì‑nísi caxì‑ní, Pedro”. ");
INSERT INTO mitNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Doco nì cachì xì‑yá: “Còó, Señor mío, mà túhe caxí ni‑iin ñà‑quini, ni‑iin ñà‑có‑ndìá ìqué caxí”. ");
INSERT INTO mitNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dandu, inga xichi nì càhàn‑yà ansivi, cachí‑yà xìˊ: “Màsà cáchì‑ní quini iá‑si, vàchi Dios nduú yùhù, te sànì cachì, iá viì‑sí”, nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ùnì xichi nì càhàn‑yà xìˊ ducán, dandu nì nana dahmà xì quisì mà mànuhá ansivi. ");
INSERT INTO mitNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Daaní, divi hora yucán sànì quesaa ùnì tiàa, itá‑né tùvèhé ndé iéˋ. Ndè ñuu Cesarea nì quixi‑ne nandúcú‑nê yùhù. ");
INSERT INTO mitNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Dandu nì cachi Espíritu Ìì xìˊ: “Cuahán‑nî, cutnaha‑ní xì nècuàchìmà cùhùn, doco màdí cachì‑ní a ndísá, á coó”. Dandu ní saqui ìñù compañerúì iin‑ni cahvi stná xì Jesús, divi nècuàchì itá yohó, te ndacá tnahá‑nsí cuàhàn‑nsì (ñuu yucán. Te na ní sàà‑nsì), nì quìhvi‑nsi ini vehe tiàa nì cana xí. ");
INSERT INTO mitNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Dandu nì nacani‑ne xì‑nsí nansa nì cuu nì xini‑nè iín iin ángel xi Dios ini vehe‑ne, te nì cachi ángel mà xì‑né: “Techuun‑ní tiàa cùhùn ñuu Jope cana‑ní Simón Pedro quixi‑ne, ");
INSERT INTO mitNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","vàchi icúmí Pedro mà cachitnùhu‑ne xi‑ní iin razón ndiaha nansa càcu anima‑ní nùù Dios, mii‑ní xì nsidaa stná nèhivì vehe‑ní”, nì cachi ángel mà. ");
INSERT INTO mitNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Daaní, làcà ní quesahí càhìn xì nèhivì ndoó yucán, te fuerte nì quixi Espíritu Ìì xí Dios dìquì‑né, nacua nì quida‑ya xì ndohó daa. ");
INSERT INTO mitNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Dandu ní nsìnuu inì nansa nì cachitnùhu Stoho‑ndà Señor xì‑ndà na ní cachi‑yà: “Ñà‑ndáà nduá, tècuìí nìsa quida iì Juan nèhivì, doco mii‑nsiá, tìxi Espíritu Ìì xí Dios icúmí‑nsiâ nduhiì‑nsiá”, nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pues divi ducán ndisa nì cuu stná xì nècuàchì inga raza mà, nì nìhìtáhvì stná‑nè Espíritu Ìì xí Dios nacua nì nìhìtáhvì ndohó na ní xinindisa‑nda Stoho‑ndà Jesucristu. Ñàyùcàndùá, (nì cundaà inì), divi Dios nduú ana nì quida xi ñà‑jaàn, te sàhámà nì nacani inì chicá vàha màsà cádì nùù‑yá ―nì cachi Pedro. ");
INSERT INTO mitNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Dandu na ní nsihi nì inini nècuàchì Jerusalén mà palabra jaàn, dandu nì ndòo vàha ini‑nè, te nì naquimanì‑né Dios, cachí‑nè: ―Pues ñà‑ndáà nduá, dècuèndè stná nècuàchì inga raza sànì nìhìtáhvì ñà‑cuu‑ne arrepentir sàhà cuàchi‑ne, te ducán cundiatú‑nè vida ndiaha nicanicuahàn ―nì cachi‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Cunaha‑ní, divi tiempu nì casahnì nèhivì Esteban nì quesaha stná‑nè quida quini‑ne xì nsidaa gá nèhivì xí Jesús. Ñàyùcàndùá, cuàhà nècuàchìmà nì xìtià nihni cuàhàn cuàhà ñuu. Dècuèndè stná ñuu Fenecia nì casaà dava‑ne, xì ndè stná ñuu Chipre, xì ñuu Antioquía. Te yucán nì càhàn stná‑nè palabra xi Dios, doco xi cuisì nècuàchì raza‑nè Judea. ");
INSERT INTO mitNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Daaní, dava nècuàchì ñuu Chipre xì dava stná nècuàchì ladu Cirene, nì casaà stná‑nè ñuu Antioquía mà, te mii‑né, ndisa, nì càhàn‑nè xì nèhivì ñuu mà có‑ndùú raza Judea, nì cachitnùhu‑ne ñà‑ndùú razón ndiaha sàhà Stoho‑ndà Jesucristu. ");
INSERT INTO mitNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Te cuàhà gá nì chindee‑yánè, vàchi cuàhà nècuàchì ñuu mà nì xinindisá, te nì tenchicùn stná‑nè ichì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Daaní, nì xinitnùhu stná nèhivì xí Jesús ndoó ñuu Jerusalén nsidaájàn. Ñàyùcàndùá, nì techuún‑né Bernabé cuàhàn‑nè Antioquía. ");
INSERT INTO mitNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Te na ní sàà‑nè yucán, yáha ga nì cudiì ini‑nè na ní xini‑nè ñà‑cuàhà guá gracia sànì sàhatahvì Dios nèhivì yucán. Ñàyùcàndùá, nì càhàn‑nè xì nècuàchìmà ñà‑siempre Stoho‑ndà Señor ni cahvi xi‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Vàchi Bernabé mà, vàha ndisa ini‑nè, vàchi chitu anima‑nè Espíritu Ìì xí Dios, te xiníndísâ fuerte‑nèyà. Te cuàhà gá stná nèhivì ñuu mà nì tenchicùn xì ichì‑yá. ");
INSERT INTO mitNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dandu nì quihin Bernabé mà ichì cuàhàn‑nè ñuu Tarso nandúcú‑nê Saulo. Te na ní ndacùhun tnahá‑né, nì nacuatnahá‑né màndixi‑ne ñuu Antioquía. ");
INSERT INTO mitNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Daaní, inii iin cuìà totoo nì nataca‑nè xì cuàhà nèhivì xí Jesús, nì dàcuàhá tnahá‑né. Te cunaha‑ní, divi ñuu Antioquía mà nduú ndé nì quesaha nèhivì cachí‑nè cristianu xì nècuàchì nchícùn ichì Jesús. ");
INSERT INTO mitNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","28","Daaní, quìvì yucán nì casaà stná itnii nècuàchì profeta ñuu mà. Ñuu Jerusalén nì quixi‑ne. Te iin‑ne nani Agabo; te divi nècuàchìmà nì sàcuììn‑nè mahì nèhivì natácá mà, te nì dàcáhàn Espíritu Ìì xí Dios‑nè, nì cachitnùhu‑ne ñà‑vàxi tnama inicutu ñuhìví. Te ñà‑ndáà nduá, vàchi ducán nì cuu ndisa tiempu xi rey cahnú nani Claudio. ");
INSERT INTO mitNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ñàyùcàndùá, (na ní tiacu) nèhivì (ñà‑vàxi tnama), dandu nì nacani ini‑nè chicá vàha chindee‑né nècuàchì hermanu (ndahví) ndoó ladu Judea, vàtùni cuàha iin iin‑ne iyuhu según ñà‑ndùá sáà‑nè cuàha‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ñàyùcàndùá, nì nacuatnahá dìhùn, te nì quida‑neà entregar nùù ndahà Bernabé xì Saulo. Dandu nècuàchìmà, nihí‑néà nì sàà (ladu Judea), te nì ndòa ndahà nècuàchì sahnú idónuu. ");
INSERT INTO mitNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Daaní, divi tiempu yucán nì dàndàcú rey Herodes tnìì dava nècuàchì natácá cahvi xi Jesús, ñà‑dandohó‑tené. ");
INSERT INTO mitNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Te iin nècuàchì nì ndoho ma nduú ñani Juan nani Jacobo, vàchi nì dàndàcú rey mà, te nì sahnì‑té nècuàchìmà xì espada. ");
INSERT INTO mitNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Dandu nì xini rey mà cudíì ini nècuàchì ñuu mà ñà‑nì xìhì ndómà, ñàyùcàndùá nì nacani inì‑te chicá vàha tnii stná‑te Pedro. Meru quìvì iá vicò xixí‑né pan có‑ndùtáchí nì sanduamà. ");
INSERT INTO mitNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ñàyùcàndùá nì tnìì stná Pedro, te nì sàcùndiadi‑nè, nì ndòo‑ne ndahà soldadu, cùmì cúmì‑té nì sandiaa xì‑né, te cùmì turnu iá nsìquívì. Te rey mà, cuisì ndiatú‑te yàha inga vicò, divi vicò pascua, dandu tavà‑té nècuàchìmà ñà‑cundehè nèhivì‑né, (te cui‑nè). ");
INSERT INTO mitNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ñàyùcàndùá, yucán iá Pedro, ndiadí‑nè vehecàa. Doco nècuàchì natácá cahvi xi Jesús, cuàhà gá nì xìcàn tàhvì‑né nùù Dios sàhà nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Daaní, nì sàà iin ñuú antes quìvì cuàhàn rey mà tavà‑té Pedro cundehè nèhivì‑né. Te indúhu‑né ini vehecàa ma, quídì naà‑né. Te itánduhù stná soldadu iin iin ladu‑nè, itníí‑te cadena nuhní‑nè, te xí‑ita stná soldadu ndiaá yehè. ");
INSERT INTO mitNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Dandu na iin cachí yucán nì ndecunu iin ángel xi Stoho‑ndà Señor, te nì natnuù iin luz ini vehecàa ma. Te nì tùxìn ndáha ángel mà diìn tìxì Pedro, nì dàndácòo‑ñané, te nì cachi‑nè: ―Ndacuiìn‑ní vichi duha. Daaní, cadena nuhní ndahà Pedro, nì dàñàtnàhá miá. ");
INSERT INTO mitNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Te nì cachi tu ángel: ―Nacuhnì‑ní siuhmatìxi‑ní, te nacuaìn‑ní ndìsàn‑ní. Te na ní nsihi nì quida Pedro ducán, dandu nì cachi tu ángel mà xì‑né: ―Cundixi‑ní dòò‑ní, te cunchicùn‑ní yùhù cúhùn‑ndà. ");
INSERT INTO mitNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ñàyùcàndùá, nì tenchicùn Pedro ángel mà cuàhàn‑nè, doco cónì cúndáà ini‑nè a ndísá ñà‑ndáà nduá cuú xi‑né, á coó, vàchi na ian sánî‑nè quidá Dios nduá cahan‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Dandu nì cayàha‑ne ndé iín iin soldadu ndiaá, te después nì yàha stná‑nè nùù ingà‑te, dandu nì sàà‑nè ndè yehè cáa cahnú quee‑nda calle ñuu mà. Te nì nuna miá, dandu nì caquee‑ne fuera cuàhàn‑nè. Te nì sàà‑nè ndé nacáhndé‑nè inga calle, te yucán nì nacoo ángel mà‑né cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dandu nì sàà Pedro nì cundaà vàha ini‑nè, te nì cachi‑nè: ―Vichi sànì cundaà inì, ñà‑ndáà nduá, nì techuún Stoho‑ndà Señor ángel xi‑ya, nì sàà‑nè nì tavà‑né yùhù ndahà Herodes. Te vitni còò gá iñàha cuu xí nacua nì cuni tè‑raza Judea cuu xí. ");
INSERT INTO mitNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Daaní, na ní nsihi nì nacani ini‑nè sàhámà, dandu cuàhàn‑nè vehe María nduú dihi Juan Marcos. Te yucán ndoó cuàhà nèhivì sànì nataca, xícàn tàhvì‑né nùù Dios. ");
INSERT INTO mitNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Dandu nì dàcàsàn Pedro tranca mà, cásàhú‑nè. Te nì quee iin ñahà chìì nani Rode vàxi‑ñà cunini‑ñà ana cáhàn. ");
INSERT INTO mitNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Te nì nacunì‑ña tàchì Pedro. Doco ñà‑cuàhà guá cudíì inì‑ña, cónì nácúná‑ña yehè; nì dàyáà‑ña nì nansìhvià vehe, nì cachitnùha xì nèhivì mà ñà‑divi Pedro nduú nècuàchì cáhàn yehè mà. ");
INSERT INTO mitNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Doco nèhivì yucán, cónì xìníndísâ‑né, ñàyùcàndùá nì cachi‑nè xì‑ñá: ―Ádì sánì culocú. Doco mii‑ñá, iin‑ni cachí‑ña divi ñà‑ndáà nduá. ―Còó ―cachí‑nè―, ádi ángel (ndiaá) xì‑né nduú ana cáhàn. ");
INSERT INTO mitNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Doco iníní‑né casan yehè, cásàhú ìì Pedro. Ñàyùcàndùá nì (caquee‑ne nì) nacuna‑ne yehè, te nì xini‑nè ¡divi Pedro nduú‑né! Ñàyùcàndùá nì ndulocó sàstnùhù‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Dandu nì cuu ndahà Pedro ñà‑nì cúníní nècuàchìmà ñà‑ndùá cuàhàn‑nè cachi‑nè, te nì nacani‑ne nansa nì nìhì‑né nì quee‑ne vehecàa ma nì quida Stoho‑ndà Señor. Te nì cachi stná‑nè xì nècuàchìmà (ni cúhùn‑nè) cachitnùhu stná‑nè xì Jacobo xì dava ga compañeru‑nè xiníndísâ. Dandu nì quee‑ne cuàhàn‑nè inga xaan. ");
INSERT INTO mitNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Daaní, na ní tùinuù quìvì yucán, cuàhà gá nì ndulocó soldadu, ¿índù cuàhàn Pedro? cahan‑té. ");
INSERT INTO mitNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Te rey Herodes, nì dàndàcú‑te ñà‑nanducù‑né cuàhà xaan. Doco cónì nátùi‑ne. Ñàyùcàndùá, nì sanicuàchi rey mà sàhà soldadu mà, te nì sahnì‑ñátê. Dandu nì quee rey mà ladu Judea cuàhàn‑te ñuu Cesarea, te yucán nì ndòo‑tè. ");
INSERT INTO mitNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Cunaha‑ní, xiní ùhì rey mà nèhivì ñuu Tiro xì nèhivì ñuu Sidón. Doco mii‑né, cuní‑nè nàcùndoo vàha‑ne xì‑té, vàchi ndè ñuù‑te quixí ñà‑ìtiácú‑nè ñuu‑nèmà. Ñàyùcàndùá, nì nìhì‑né nì nàcùndoo vàha‑ne xì iin ana xinúcuáchí nùù‑té vehe‑tè, divi iin tiàa nani Blasto. Dandu iin‑ni nì ndatnuhu nsidaa‑né, te nì catnàtuu‑ne nùù rey mà tìxi Blasto mà, (áma níhì‑né nàcùndoo vàha‑ne xì‑té). ");
INSERT INTO mitNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Te nì saquìn‑te iin quìvì (quixi tu nsidaa‑né). Ñàyùcàndùá, divi quìvì mà nì sàcòo‑tè silla cahnú xí‑te, ndixí‑te sìcoto viì xí‑te, te nì càhàn‑te sàhù xì nsidaa nècuàchìmà. ");
INSERT INTO mitNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Dandu yáha ga nì càna fuerte‑nè, cachí‑nè: ―¡Màdì nèhivì ùún cáhàn! ¡Iin dios nduú ana cáhàn! ―cachí‑nè, cána‑ne. ");
INSERT INTO mitNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Dandu vichi duha nì dùcùn rey mà iin castigu nì quida ángel xi Stoho‑ndà Señor, vàchi cónì tàvá‑te tnùñuhu xí‑yá. Ñàyùcàndùá, nì saxì sìndacu inì‑te, te nì xìhì‑te. ");
INSERT INTO mitNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Doco razón ndiaha xí Stoho‑ndà Señor, chicá nì xìtià inicutu, te chicá cuàhà nèhivì nì tenchicùn xì palabra mà. ");
INSERT INTO mitNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Daaní, na ní nsihi nì xìnu chuun nì quida Bernabé xì Saulo ñuu Jerusalén yucán, dandu nì saca‑ne Juan Marcos, te ndacá stnahá‑né nì quee‑ne ñuu mà mànuhù‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ñuu Antioquía mà nì sandoo cuàhà nècuàchì natácá cahvi xi‑yá. Te dava‑ne nduú nècuàchì chináhá, te dava‑ne nduú profeta cachítnùhu razón xi Dios. Te nècuàchì chicá xíquida ducán nì sanduu Bernabé, xì Simón el Negro, xì stná Lucio nì quixi ñuu Cirene, xì stná Saulo, xì stná Manaén, iin nècuàchì dava‑ni nì sahnu xi gobernador Herodes. ");
INSERT INTO mitNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Daaní, nì cuu iin quìvì na cahvi nsidaa‑né Stoho‑ndà Señor, te iníhíì stná‑nè nùù‑yá ndoó dòcó‑nè, dandu nì cachi Espíritu Ìì xì‑né: ―Cunaha‑nsiá, cuaán cunduu chuun xi Bernabé xì Saulo vichi, vàchi sànì nacàxin mii‑né. Ñàyùcàndùá, nacoo‑nsianè ni cúhùn‑nè quida‑ne inga chuun xi ―nì cachi‑yà. ");
INSERT INTO mitNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ñàyùcàndùá chicá nì inihiì‑né, te nì xìcàn tàhvì stná‑nè nùù‑yá. Dandu nì chitàndòó‑né ndahà‑né dìnì Bernabé xì Saulo (ñà‑cunduajàn seña ñà‑sànì nìhì nècuàchìmà chuun ndiaha). Dandu nì ndaquìndèè‑né xì nècuàchìmà cuàhàn‑nè. ");
INSERT INTO mitNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ñàyùcàndùá, nì quihin nècuàchìmà ichì cuàhàn‑nè, vàchi sànì techuún Espíritu Ìì‑né cùhùn‑nè. Te nì sàà‑nè ñuu Seleucia. Te yucán nì nana‑ne iin barcu cuàhàn‑nè ndè iin ñuu cahnú nani Chipre. ");
INSERT INTO mitNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Te meru ñuu ndé nì nuu‑ne barcu mà nani Salamina. Dandu cuàhàn‑nè veheñùhu xi nècuàchì raza‑nè Judea iá yucán, te nì càhàn‑nè palabra xi Dios. Te cutnáhâ stná Juan xì‑né, xinúcuáchí nècuàchìmà nùù‑né. ");
INSERT INTO mitNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Dandu nì nacàhin‑ne inii ñuu mà dècuèndè nì sàà‑nè inga orilla mar ndé iá ñuu Pafos. Te yucán nì ndacùhun tnahá‑né xì iin tètàtnà nani Barjesús. Te Elimas nani stná‑te, vàchi ducán cachí‑nè xì tètàtnà dàhàn yucán. Iin tè‑raza Judea nduú stná‑te, te cáhàn‑te razón xi Dios, cachí‑te, doco dandahví uun‑tè. Pues divi‑tè iá nùù iin nècuàchì nchichí cusáhnû ladu yucán nani Sergio Paulo. Te nècuàchìmà, nì cana‑ne Bernabé xì Saulo, vàchi cuní‑nè cunini‑ne palabra xi Dios. Doco tètàtnà mà, nì càhàn‑te dìquì Bernabé xì Saulo, daquítnùhu‑tè nùù nècuàchì cusáhnú‑má ñà‑màsà cúníndísâ stná‑nè ichì Jesús. ");
INSERT INTO mitNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Dandu Saulo, ò nì càchí stná‑ndà Pablo, fuerte nì quixi Espíritu Ìì xí Dios ini anima‑nè, ñàyùcàndùá nì indehè váha‑ne tètàtnà mà, ");
INSERT INTO mitNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","cachí‑nè xì‑té: ―Ndahví‑nî, vàchi dandahví uun‑ní nèhivì ñà‑cuàhà gá maña quida‑ní, te ni‑iin ñà‑vàha có‑cùú inì‑ní sàhà‑xí, vàchi dèhe ñà‑malu nduu‑ní. ¿Índù chuun tùha guá‑nî datúcù‑ní nèhivì ñà‑màsà cúnchícùn‑nè ichì ndácuisì Stoho‑ndà Señor? ");
INSERT INTO mitNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Doco cunaha‑ní, sàhà‑ñá quida‑ní ducán, ñàyùcàndùá icúmí‑nî nìhì‑ní iin castigu xi Dios vichi. Icúmí‑nî cuaà dahuun‑ní iin ratu; ni nduà orá mà cútùi ga nùù‑ní ―nì cachi Pablo. Dandu vichi duha nì cuaà nùù témà, te nì nàcuììn tnùù dahuan. Ñàyùcàndùá, nì quee‑tè cuàhàn‑te nanducu‑té ana cudìtá xì‑té cacanuu. ");
INSERT INTO mitNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Te na ní xini nècuàchì cusáhnú‑má ñà‑ndùá nì cuu, dandu nì xinindisá stná‑nè palabra xi Dios, vàchi nì ndulocó‑nè sàhà ñà‑ndùá chináhá Pablo sàhà Stoho‑ndà Señor. ");
INSERT INTO mitNT_vpl VALUES ("AC13_13","074_13_13","A